﻿USE sofia;
DROP TABLE IF EXISTS sofia.lbm_vpl;
CREATE TABLE lbm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lbm_vpl WRITE;
INSERT INTO lbm_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","सुरूवात म परमेश्वर न स्वर्ग अऊर धरती ख बनायो। ");
INSERT INTO lbm_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","अऊर धरती बिना आकार कि होती, अऊर धरती पर कुछ भी नहीं होतो, अऊर गहरो पानी को ऊपर अन्धियारो होतो; अऊर परमेश्वर की आत्मा पानी को ऊपर मण्डरावत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","जब परमेश्वर न आज्ञा दियो, “उजाड़ो हो” अऊर उजाड़ो भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","अऊर परमेश्वर न उजाड़ो ख देख्यो, अऊर ऊ जान गयो कि यो अच्छो हय। तब परमेश्वर न उजाड़ो ख अन्धारो सी अलग कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","तब परमेश्वर न उजाड़ो को नाम “दिन” अऊर अन्धारो को नाम “रात” रख्यो। तब शाम भयी अऊर तब सुबेरे भयी। तब यो पहिलो दिन भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","तब परमेश्वर न कह्यो, “पानी को बीच एक असो अन्तर हो कि पानी दोय भाग होय जाये।” ");
INSERT INTO lbm_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","तब परमेश्वर न एक अन्तर कर क् ओको खल्लो को पानी अऊर ओको ऊपर को पानी ख अलग अलग करयो; अऊर वसोच भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","अऊर परमेश्वर न ऊ अन्तर ख “आसमान” कह्यो। फिर शाम भयी तब सुबेरे भयी। यो तरह दूसरों दिन भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","तब परमेश्वर न आज्ञा दियो, “आसमान को खल्लो को पानी एक जागा म जमा हो जाये अऊर सूखी जमीन दिखायी दे” अऊर वसोच भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्वर न सूखी जमीन को नाम “धरती” रख्यो अऊर जो पानी जमा भयो होतो, ओख “समुन्दर” नाम दियो। अऊर परमेश्वर न देख्यो कि यो अच्छो हय। ");
INSERT INTO lbm_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","तब परमेश्वर न कह्यो, “धरती सी हरी घास, अऊर बीज वालो छोटो छोटो झाड़, अऊर फर वालो झाड़ भी जिन्को बीज उन्कोच म एक एक की जाति को अनुसार हंय, अऊर धरती पर उगें,” अऊर वसोच भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","यो तरह धरती सी हरी घास, अऊर छोटो छोटो झाड़ जिन्म अपनी अपनी जाति को अनुसार बीज होवय हय, अऊर फर वालो झाड़ जिन्को बीज एक एक की जाति को अनुसार उन्कोच म होवय हंय ऊ उगें: अऊर परमेश्वर न देख्यो कि यो अच्छो हय। ");
INSERT INTO lbm_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","फिर शाम भयी फिर सुबेरे भयी। यो तरह तीसरो दिन भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","तब परमेश्वर न आज्ञा दियो, “रात ख दिन सी अलग करन लायी आसमान को अन्तर म ज्योतियां हो; अऊर हि चिन्हों, अऊर ठहरायो हुयो समयों अऊर दिनों, अऊर सालों को चिन्ह हो; ");
INSERT INTO lbm_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","अऊर हि धरती ख उजाड़ो देन लायी आसमान म चमकेंन” अऊर वसोच भयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","तब परमेश्वर न दोय बड़ो उजाड़ो बनायो; सूरज न दिन पर शासन करन लायी अऊर चन्दा न रात पर शासन करन लायी; अऊर उन्न तारागन भी बनायो। ");
INSERT INTO lbm_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमेश्वर न उन्ख आसमान को अन्तर म येकोलायी रख्यो कि हि धरती पर उजाड़ो दे, ");
INSERT INTO lbm_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","दिन अऊर रात पर शासन करन लायी, अऊर अन्धारो सी उजाड़ो ख अलग करन लायी। अऊर जो कुछ परमेश्वर न देख्यो कि हि अच्छो हंय। ");
INSERT INTO lbm_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","तब शाम भयी अऊर सुबेरे भयी। यो तरह चौथो दिन भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","तब परमेश्वर न आज्ञा दियो, “पानी जीन्दो प्रानियों सी भरयो रहे, अऊर पक्षी धरती को ऊपर आसमान को ऊपर उड़े, हवा ख पक्षियों सी भरन दे।” ");
INSERT INTO lbm_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","येकोलायी परमेश्वर न जाति जाति को बड़ो बड़ो पानी को जीव जन्तुवों, अऊर उन सब जीन्दो प्रानियों की भी रचना करी जो चलतो फिरतो हंय जिन सी पानी बहुतच भर गयो, अऊर एक एक जाति को उड़न वालो पक्षियों की भी रचना करी : अऊर परमेश्वर न देख्यो कि यो अच्छो हंय। ");
INSERT INTO lbm_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","अऊर परमेश्वर न उन्ख यो कह्य क आशीर्वाद दियो, “फलो फूलो, अऊर समुन्दर को पानी म भर जावो, अऊर उन्न पक्षियों ख संख्या म बढ़न लायी कह्यो।” ");
INSERT INTO lbm_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","तब शाम भयी अऊर सुबेरे भय गयी। यो तरह पाचवों दिन भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","तब परमेश्वर न आज्ञा दियो, “धरती म सी एक एक जाति को जीन्दो प्रानी, यानेकि घरेलू जनावर, अऊर रेंगन वालो जन्तु, अऊर धरती को जंगली जनावर, जाति जाति को अनुसार पैदा हो,” अऊर वसोच भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","यो तरह परमेश्वर न धरती को जाति जाति को जंगली जनावरों ख, अऊर जाति जाति को पालतु जनावरों ख, अऊर जाति जाति को जमीन पर सब रेंगन वालो जन्तुवों ख बनायो : अऊर परमेश्वर न देख्यो कि यो अच्छो हय। ");
INSERT INTO lbm_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","तब परमेश्वर न कह्यो, “हम आदमी ख अपनो स्वरूप को अनुसार अपनी समानता म बनायो; अऊर हि समुन्दर की मच्छी, अऊर पालतु जनावरों, अऊर पूरी धरती पर, अऊर सब रेंगन वालो जन्तुवों पर जो धरती पर रेंगय हंय, उन बड़ो छोटो पर अधिकार रखे।” ");
INSERT INTO lbm_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","तब परमेश्वर न आदमी ख अपनो स्वरूप को अनुसार पैदा करयो, अऊर अपनोच स्वरूप को अनुसार परमेश्वर न ओख पैदा करयो; अऊर नर अऊर नारी कर क् ओन आदमियों की रचना करी। ");
INSERT INTO lbm_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","अऊर परमेश्वर न उन्ख आशीर्वाद दियो, अऊर उन्को सी कह्यो, “फूलो फलो, अऊर धरती म भर जावो, अऊर ओख अपनो बस म कर लेवो; अऊर समुन्दर की मच्छी, तथा आसमान की पक्षियों, अऊर धरती पर रेंगन वालो सब जन्तुवों पर अधिकार रखो।” ");
INSERT INTO lbm_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","तब परमेश्वर न उन्को सी कह्यो, “सुनो, जितनो बीज वालो छोटो छोटो झाड़ पूरी धरती को ऊपर हंय अऊर जितनो झाड़ म बीज वालो फर होवय हंय, हि सब मय न तुम ख दियो हंय; हि तुम्हरो खान लायी आय। ");
INSERT INTO lbm_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","अऊर जितनो धरती को जनावर, अऊर आसमान को पक्षी, अऊर धरती पर रेंगन वालो जन्तु हंय, जिन्म जीवन को जीव हय, उन सब ख खान लायी मय न सब हरो हरो छोटो झाड़ दियो हंय,” अऊर वसोच भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","तब परमेश्वर न जो कुछ बनायो होतो सब ख देख्यो, त का देख्यो, कि ऊ बहुतच अच्छो हय। तथा शाम भयी फिर सुबेरे भयी। यो तरह छठवो दिन भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","यो तरह आसमान अऊर धरती अऊर जो कुछ उन्म हय, इन सब की रचना पूरी भयी। ");
INSERT INTO lbm_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","अऊर परमेश्वर न अपनो काम जेक ऊ करत होतो सातवों दिन ओन खतम करयो, अऊर ओन अपनो करयो हुयो पूरो काम सी सातवों दिन आराम करयो। ");
INSERT INTO lbm_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","अऊर परमेश्वर न सातवों दिन ख आशीर्वाद दियो अऊर पवित्र ठहरायो; कहालीकि ओको म ओन जगत की रचना कर क् अपनो पूरो काम सी आराम करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","आसमान अऊर धरती की उत्पत्ति को वर्नन यो हय कि जब हि पैदा भयो मतलब जो दिन यहोवा परमेश्वर न धरती अऊर आसमान ख बनायो : ");
INSERT INTO lbm_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","पर ऊ समय धरती पर कोयी पौधा नहीं होतो अऊर नहीं जमीन की कोयी बीज अंकुरित भयी होती; कहालीकि प्रभु परमेश्वर न धरती पर पानी नहीं बरसायो होतो, अऊर जमीन पर खेती करन लायी आदमी भी नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ओस धरती सी ऊपर उठत होतो, जेको सी पूरी जमीन सिंची जात होती। ");
INSERT INTO lbm_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","तब प्रभु परमेश्वर न जमीन सी माटी निकाली अऊर ओको म सी आदमी ख बनायो; अऊर ओन अपनी नासिका सी जीवन की श्वास फूक्यो अऊर आदमी एक जीन्दो प्रानी बन गयो। ");
INSERT INTO lbm_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","अऊर प्रभु परमेश्वर न पूर्व दिशा म अदन म एक बगीचा लगायो, अऊर उत ओन ऊ आदमी ख रख्यो जो ओन बनायो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","अऊर यहोवा परमेश्वर न जमीन सी सब तरह को झाड़, जो देखनो म सुन्दर अऊर जिन्को फर खानो म अच्छो हंय, जमीन सी जगायो, अऊर बगीचा को बीच म जीवन को झाड़ ख अऊर भलो या बुरो ज्ञान को झाड़ ख भी लगायो। ");
INSERT INTO lbm_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ऊ बगीचा ख सींचन लायी एक महा नदी अदन सी निकली अऊर उत सी बह क चार नदियों म बट गयी। ");
INSERT INTO lbm_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहिली नदी को नाम पीशोन हय; या वाच नदी आय जो हवीला देश को चारों तरफ बह हय, जित सोनो मिलय हय। ");
INSERT INTO lbm_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ऊ देश को सोनो शुद्ध होवय हय; उत मोती अऊर सुलैमानी गोटा भी मिलय हंय। ");
INSERT INTO lbm_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दूसरी नदी को नाम गीहोन हय; या वाच नदी आय जो कूश देश को चारों तरफ बह हय। ");
INSERT INTO lbm_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","अऊर तीसरी नदी को नाम हिद्देकेल हय; या वाच आय जो अश्शूर देश की पूर्व दिशा म बहय हय। अऊर चौथी नदी को नाम फरात हय। ");
INSERT INTO lbm_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","तब प्रभु परमेश्वर न आदमी ख ले क अदन को बगीचा म रख दियो, कि ऊ ओको म काम करे अऊर ओकी रक्षा करे। ");
INSERT INTO lbm_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","अऊर प्रभु परमेश्वर न आदमी ख आज्ञा दी, “तुम बगीचा को सब झाड़ को फर बिना झीझक खाय सकय हय; ");
INSERT INTO lbm_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","पर भलो या बुरो को ज्ञान को जो झाड़ हय, ओको फर तुम कभी मत खाजो : कहालीकि जो दिन तुम ओको फर खावो उच दिन जरूर मर जाजो।” ");
INSERT INTO lbm_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","तब प्रभु परमेश्वर न कह्यो, “आदमी को अकेलो रहनो अच्छो नहीं; मय ओकी मदद लायी एक असो संगी बनाऊं जो ओको सी मेल खाये।” ");
INSERT INTO lbm_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","येकोलायी प्रभु परमेश्वर जमीन सी कुछ माटी ली अऊर पूरो जनावरों अऊर आसमान को सब पक्षियों ख रच क आदमी को जवर आयो कि ऊ उन्को का का नाम रखेंन; अऊर जो जो जीन्दो प्रानी को जो जो नाम आदम न रख्यो उच ओको नाम होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","त ऊ आदमी न सब जाति को पालतु जनावरों, अऊर आसमान को पक्षियों, अऊर सब जाति को जंगली जनावरों को नाम रख्यो; पर आदमी लायी कोयी असो मदद करन लायी नहीं मिल्यो जो ओको सी मेल खाय सके। ");
INSERT INTO lbm_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","तब प्रभु परमेश्वर न आदम ख गहरी नींद म डाल दियो, अऊर जब ऊ सोय गयो, ओन आदम की एक फसली निकाली अऊर मांस ख भर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","अऊर प्रभु परमेश्वर न ऊ फसली ख जो ओन आदमी म सी निकाली होती, ओन एक बाई बनायी; अऊर ओख आदम को जवर लायो। ");
INSERT INTO lbm_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","तब ऊ आदम न कह्यो, “अब यो मोरी हड्डियों म की हड्डी अऊर मोरो मांस म को मांस हय; येकोलायी येको नाम ‘बाई’ होयेंन, कहालीकि ओख आदम म सी बाहेर निकाली गयी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","योच वजह हय कि आदमी अपनो माय बाप ख छोड़ क अपनी पत्नी सी मिल्यो रहेंन, अऊर हि एक जुट बन्यो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","आदम अऊर ओकी पत्नी दोयी नंगा होतो, पर हि लज्जित नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","उन सब जंगली प्रानियों म जिन्ख प्रभु परमेश्वर न बनायो होतो, उन सब म सांप चालाक होतो। ओन बाई सी कह्यो, “का सचमुच परमेश्वर न कह्यो हय, तुम यो बगीचा को कोयी झाड़ को फर नहीं खावो?” ");
INSERT INTO lbm_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","बाई न सांप ख उत्तर दियो, “हम यो बगीचा को झाड़ को फर खाय सकजे हंय;” ");
INSERT INTO lbm_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","पर परमेश्वर न हमरो सी कह्यो, “बगीचा को बीच म लग्यो हुयो झाड़ को फर मत खावो, अऊर नहीं ओख छूवो, नहीं त तुम मर जावो।” ");
INSERT INTO lbm_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","तब सांप न बाई सी कह्यो, “यो सच नोहोय; तुम कभी नहीं मरो! ");
INSERT INTO lbm_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","बल्की परमेश्वर खुद जानय हय कि जो दिन तुम ओको फर खावो उच दिन तुम्हरी आंखी खुल जायेंन, अऊर तुम भलो बुरो को ज्ञान पा क परमेश्वर को जसो बन जावो।” ");
INSERT INTO lbm_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","जब बाई न देख्यो कि झाड़ कितनो सुन्दर होतो अऊर ओको फर खानो म कितनो अच्छो होयेंन, अऊर ओन सोच्यो कि बुद्धिमान बनन लायी यो कितनो लायक होयेंन। येकोलायी ओन कुछ फर ले लियो अऊर खाय लियो अऊर अपनो पति ख भी दियो, अऊर ओन ओख भी खायो। ");
INSERT INTO lbm_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब उन दोयी की आंखी खुल गयी, अऊर उन्ख मालूम भयो कि हि नंगा हय; येकोलायी उन्न अंजीर को पत्ता ख एक संग सिल दियो अऊर खुद ख झाक लियो। ");
INSERT INTO lbm_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","जब शाम ख उन्न प्रभु परमेश्वर ख बगीचा म घुमतो हुयो सुन्यो, तब आदमी अऊर ओकी पत्नी बगीचा को झाड़ को बीच म प्रभु परमेश्वर सी लूक गयो। ");
INSERT INTO lbm_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","पर प्रभु परमेश्वर न आदम ख पुकारयो, “तुम कित हय?” ");
INSERT INTO lbm_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ओन उत्तर दियो, “मय न तुम ख बगीचा म घुमतो हुयो सुन्यो; मय डर गयो, अऊर तोरो सी लूक गयो, कहालीकि मय नंगा होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","प्रभु परमेश्वर न पुच्छ्यो, “कौन न तोरो सी कह्यो कि तय नंगा हय? का तय न ऊ झाड़ को फर खायो हय, जेक मय न खान लायी नहीं कह्यो होतो?” ");
INSERT INTO lbm_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदम न उत्तर दियो, “जो बाई तुम न मोरो संग रहन लायी दियो हय, ओन ऊ झाड़ को फर मोख दियो, अऊर मय न खाय लियो।” ");
INSERT INTO lbm_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","प्रभु परमेश्वर न बाई सी पुच्छ्यो, “यो तुम न असो कहाली करयो?” बाई न उत्तर दियो, “सांप न मोख बहकाय दियो अऊर मय न फर खाय लियो।” ");
INSERT INTO lbm_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","तब प्रभु परमेश्वर न सांप सी कह्यो, “तुम न जो यो करयो हय येकोलायी तुम सब पालतु जनावरों अऊर सब जंगली जनावरों सी ज्यादा श्रापित हय; अब सी तुम पेट को बल चलजो, अऊर जब तक जीन्दो रहो तब तक तुम्ख धूल चाटनो पड़ेंन ");
INSERT INTO lbm_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","अऊर मय तोरो अऊर बाई को बीच म, अऊर तोरो वंश अऊर येको वंश को बीच म घृना पैदा करूं; अऊर ओको वंश तुम्हरी मुंड ख कुचल देयेंन, अऊर तुम ओकी एड़ी ख डसो।” ");
INSERT INTO lbm_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","प्रभु परमेश्वर न बाई सी कह्यो, “मय तोरी पीड़ा अऊर तोरो गर्भवती होन को दु:ख ख बहुत बढ़ाऊं; अऊर तय पीड़ित होय क बच्चा पैदा करजो; अऊर तोरी इच्छाये तोरो पति को तरफ होयेंन, अऊर ऊ तोरो पर शासन करेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","प्रभु परमेश्वर न आदम सी कह्यो, “तय न अपनी पत्नी की बात सुनी, अऊर ऊ झाड़ को फर खायो जेको बारे म मय न तोख आज्ञा दी होती कि तय ओको फर नहीं खाजो, ओख तय न खायो हय येकोलायी जमीन तोरो वजह श्रापित हय। तय ओकी फसल खान लायी तोख जीवन भर कठोर परिश्रम करनो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","अऊर ऊ तोरो लायी काटा अऊर ऊंटकटारे उगायेंन, अऊर तोख जंगली पौधा ख खानो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","अऊर अपनो मस्तक को पसीना की रोटी खायो करजो, अऊर आखरी म माटी म मिल जाजो कहालीकि तय ओकोच म सी निकाल्यो गयो हय; तय माटी त आय अऊर माटी मच फिर मिल जाजो।” ");
INSERT INTO lbm_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदम न अपनी पत्नी को नाम हवा रख्यो; कहालीकि वा पूरो आदमियों की माय बनी। ");
INSERT INTO lbm_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","अऊर प्रभु परमेश्वर न आदम अऊर ओकी पत्नी लायी जनावरों की खाल सी कपड़ा बनायो, अऊर ओन ओख कपड़ा पहिनायो। ");
INSERT INTO lbm_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","तब प्रभु परमेश्वर न कह्यो, “अब हि आदमी भलो अऊर बुरो ख जान क हम म सी एक को जसो भय गयो हंय, अब कहीं असो नहीं होय कि ऊ हाथ बढ़ाय क जीवन को झाड़ को फर तोड़ ले, अऊर ओख खाय क अमर होय जाये।” ");
INSERT INTO lbm_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","येकोलायी प्रभु परमेश्वर न आदमी ख अदन को बगीचा म सी निकाल दियो कि ऊ वा जमीन पर खेती करे, जेको म सी आदमी ख बनायो गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ओन आदम ख निकाल दियो, ओन जीवन को झाड़ को तरफ जान वालो रस्ता की देखभाल करन लायी अदन को बगीचा की पूर्व दिशा म करूबों अऊर जीन्दो प्रानियों अऊर एक धधकती तलवार ख नियुक्त करयो। ");
INSERT INTO lbm_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","जब आदम अपनी पत्नी हवा को जवर गयो तब वा गर्भवती भयी तब ओन कैन ख जनम दियो अऊर कह्यो, “प्रभु की मदत सी मय न एक बेटा पा लियो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","तब बाद म हवा न अऊर एक बेटा, हाबिल ख जनम दियो। तब हाबिल मेंढावों को चरवाहा बन गयो, लेकिन कैन खेती करन वालो किसान होतो। ");
INSERT INTO lbm_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","कुछ दिनों बाद कैन अपनी फसल ले क आयो अऊर ओख प्रभु ख भेंट को रूप म दियो। ");
INSERT INTO lbm_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","तब हाबिल न अपनी शेरी अऊर मेंढी म सी कुछ एक ख जो पैदा हुयो पहिलो मेंढी को बच्चा चर्बी युक्त भेंट चढ़ायी; तब प्रभु न हाबिल अऊर ओकी भेंट सी प्रसन्न भयो, ");
INSERT INTO lbm_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","लेकिन ओन कैन अऊर ओकी भेंट ख अस्वीकार कर दियो। येकोलायी कैन बहुत गुस्सा भयो, अऊर ओको मुंह पर उदासी छाय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","तब प्रभु न कैन सी कह्यो, “तय कहाली गुस्सा होय रह्यो हय? अऊर तोरो मुंह पर उदासी कहाली छायी हुयी हय?” ");
INSERT INTO lbm_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","यदि तय न सही काम करयो रह्यतो, त का म तोख ग्रहन नहीं करतो; किन्तु यदि तय भलायी नहीं करजो त देख; तोरो दरवाजा पर पाप खड़ो हय, अऊर यो तोरो पर शासन करनो चाहवय हय, लेकिन तोख येख दूर करनो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","तब कैन न हाबिल सी कह्यो, “आवो हम खेत ख निकलजे हंय।” जब हि खेत को बाहेर होतो, त कैन न अपनो भाऊ हाबिल पर चढ़ क ओख मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","प्रभु न कैन सी कह्यो, “तोरो भाऊ हाबिल कित हय?” ओन उत्तर दियो, “मोख नहीं मालूम। त कैन न कह्यो का मय अपनो भाऊ को रखवाली करन वालो आय?” ");
INSERT INTO lbm_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","तब प्रभु न कह्यो, “तय न यो भयानक काम कहाली करयो हय? तोरो भाऊ को खून जमीन सी मोख बुलाय रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","अब तय वा जमीन को तरफ सी श्रापित हय, जेन तोरो भाऊ को खून तोरो हाथ सी स्वीकार करन लायी अपनो मुंह खोल्यो हंय। ");
INSERT INTO lbm_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","जब तय जमीन पर खेती करन की कोशिश करजो, त माटी तोरो लायी कुछ पैदा नहीं करेंन; अऊर तय धरती पर बेघर होय जाजो अऊर भटकन वालो होयजो।” ");
INSERT INTO lbm_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","अऊर कैन न परमेश्वर सी कह्यो, “यो सजा मोरो लायी सहन करनो बहुत कठिन हय। ");
INSERT INTO lbm_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","देख, तय न अज मोख जमीन सी हटाय दियो हंय, अऊर मय तोरी नजर की आड़ म रहूं, अऊर धरती पर एक बेघर होय जाऊं अऊर भटकूं, अऊर जो कोयी मोख मिलेंन ऊ मोख मार डालेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","परमेश्वर न कैन सी कह्यो, “असो नहीं होयेंन। जो कोयी कैन ख मार डालेंन ओको सी सात गुना बदला ले लियो जायेंन।” येकोलायी प्रभु न कैन पर एक चिन्ह डाल दियो कि ओख पान वालो कोयी भी ओकी हत्या नहीं करे। ");
INSERT INTO lbm_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","तब कैन प्रभु की उपस्थिति सी दूर चली गयो अऊर “नोद” नाम को देश म रहन लग्यो, जो कि अदन की पूर्व दिशा म हय। ");
INSERT INTO lbm_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","जब कैन अपनी पत्नी को जवर गयो तब वा गर्भवती भयी, अऊर ओन हनोक ख जनम दियो; तब कैन न एक नगर बसायो अऊर ऊ नगर को नाम अपनो बेटा को नाम पर हनोक रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोक सी ईराद पैदा भयो, अऊर ईराद सी महूयाएल, अऊर महूयाएल सी मतूशाएल, अऊर मतूशाएल सी लेमेक पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेक की दोय पत्नी होती। एक को नाम आदा अऊर दूसरी को नाम सिल्ला होतो। ");
INSERT INTO lbm_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदा न याबाल ख जनम दियो। याबाल उन लोगों को बुजूर्ग बन्यो जो तम्बुवों म रहत होतो अऊर जनावर पालत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","अऊर ओको भाऊ को नाम यूबाल होतो। ऊ वीणा अऊर बांसुरी बजावन वालो को पूर्वज होतो। ");
INSERT INTO lbm_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","अऊर सिल्ला न तूबल अऊर कैन ख जनम दियो, ऊ पीतर अऊर लोहा को सब धार वालो हथियार बनान वालो पहिलो धातुकार होतो। तूबल कैन की बहिन नामा होती। ");
INSERT INTO lbm_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","अऊर लेमेक न अपनी पत्नियों सी कह्यो, “हे आदा अऊर हे सिल्ला मोरी बात सुनो; हे लेमेक की पत्नियों, मोरी बात पर ध्यान देवो : जो आदमी न मोख घायल करयो, अऊर जो जवान न मोख चोट पहुंचायी, ओख मय न मार डाल्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","अगर कैन को बदला सात गुना लियो जायेंन, त लेमेक को सतहत्तर गुना लियो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","अऊर आदम अपनी पत्नी को जवर फिर गयो; अऊर ओन एक बेटा ख जनम दियो अऊर ओको नाम यो कह्य क शेत रख्यो कि : “परमेश्वर न मोरो लायी हाबिल को बदला, जेक कैन न मार डाल्यो होतो, येकोलायी परमेश्वर न हाबिल की जागा पर यो दूसरो बच्चा प्रदान करयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","अऊर शेत ख भी एक टुरा पैदा भयो अऊर ओन ओको नाम एनोश रख्यो; ऊ समय सी लोग प्रभु को नाम सी आराधना करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदम की वंशावली को विवरन यो तरह हय। जब परमेश्वर न आदम ख बनायो त ओन उन्ख अपनो जसो बनायो। ");
INSERT INTO lbm_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ओन उन्ख नर अऊर नारी बनायो, जब हि दोयी बनायो गयो, तब ओन ओको नाम आदम रख्यो अऊर उन्ख आशीर्वाद दियो। ");
INSERT INTO lbm_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","जब आदम एक सौ तीस साल को भयो, तब ओको सी ओको जसो एक टुरा पैदा भयो जो ओको समान होतो, अऊर ओन ओको नाम शेत रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","अऊर शेत को जनम को बाद आदम आठ सौ साल तक जीन्दो रह्यो, अऊर ओख अऊर भी टुरा टुरी पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","यो तरह आदम कुल नव सौ तीस साल जीन्दो रह्यो, तब बाद म ओकी मृत्यु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","जब शेत एक सौ पाच साल को भयो, तब ओको सी एनोश पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश को जनम को बाद शेत आठ सौ सात साल तक जीन्दो रह्यो, अऊर ओख अऊर भी टुरा टुरी पैदा भयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","यो तरह शेत कुल नव सौ बारा साल जीन्दो रह्यो; ओको बाद ओकी मृत्यु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","जब एनोश नब्बे साल को भयो, तब ओन केनान ख पैदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान को जनम को बाद एनोश आठ सौ पन्द्रा साल तक जीन्दो रह्यो, अऊर ओख अऊर भी टुरा टुरी पैदा भयी ");
INSERT INTO lbm_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","यो तरह एनोश कुल नव सौ पाच साल जीन्दो रह्यो; ओको बाद ओकी मृत्यु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","जब केनान सत्तर साल को भयो, तब ओन महल्लेल ख पैदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महल्लेल को जनम को बाद केनान आठ सौ चालीस साल तक जीन्दो रह्यो, अऊर ओख अऊर भी टुरा टुरी पैदा भयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","यो तरह केनान कुल नव सौ दस साल जीन्दो रह्यो; ओको बाद ओकी मृत्यु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","जब महल्लेल पैसठ साल को भयो, तब ओन येरेद ख पैदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","येरेद को जनम को बाद महल्लेल आठ सौ तीस साल तक जीन्दो रह्यो, अऊर ओख अऊर भी टुरा टुरी भयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","यो तरह महल्लेल कुल आठ सौ पंचानबे साल जीन्दो रह्यो; ओको बाद ओकी मृत्यु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","जब येरेद एक सौ बाहसठ साल को भयो, तब ओन हनोक ख पैदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोक को जनम को बाद येरेद आठ सौ साल तक जीन्दो रह्यो, अऊर ओख अऊर भी टुरा टुरी भयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","यो तरह येरेद कुल नव सौ बाहसठ साल जीन्दो रह्यो; ओको बाद ओकी मृत्यु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","जब हनोक पैसठ साल को भयो, तब ओन मतूशेलह ख पैदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मतूशेलह को जनम को बाद हनोक तीन सौ साल तक परमेश्वर को संग संग चलतो रह्यो, अऊर ओख अऊर भी टुरा टुरी भयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","यो तरह हनोक कुल तीन सौ पैसठ साल जीन्दो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक परमेश्वर को संग संग चलत होतो; तब ऊ गायब भय गयो, कहालीकि परमेश्वर न ओख उठाय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","जब मतूशेलह एक सौ सत्तासी साल को भयो, तब ओको सी लेमेक ख पैदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेक को जनम को बाद मतूशेलह सात सौ बयासी साल तक जीन्दो रह्यो, अऊर ओख अऊर भी टुरा टुरी भयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","यो तरह मतूशेलह कुल नव सौ उनसत्तर साल जीन्दो रह्यो; ओको बाद ओकी मृत्यु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","जब लेमेक एक सौ बयासी साल को भयो, तब ओन एक बच्चा पैदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","अऊर ओन ओको नाम नूह रख्यो, अऊर कह्यो, “जो जमीन ख प्रभु न श्राप दियो हय, ओको बारे म यो लड़का हमरो कार्य करतो समय हमरो कठिन कामों म जो हम करजे हंय, यो हम्ख आराम देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नूह को जनम को बाद लेमेक पाच सौ पंचानबे साल तक जीन्दो रह्यो, अऊर ओख अऊर भी टुरा टुरी भयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","यो तरह लेमेक कुल सात सौ सतहत्तर साल जीन्दो रह्यो; ओको बाद ओकी मृत्यु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","अऊर जब नूह पाच सौ साल को भयो, तब ओन शेम, हाम अऊर येपेत ख पैदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","जब आदमी जमीन पर बहुत बढ़न लग्यो, तब उन्ख बेटियां पैदा होन लगी, ");
INSERT INTO lbm_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","तब परमेश्वर को बेटावों न आदमी की बेटियों ख देख्यो, कि हि सुन्दर हंय, अऊर उन्न जेक जेक चाह्यो ओन बिहाव कर लियो। ");
INSERT INTO lbm_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","तब परमेश्वर न कह्यो, “मोरी आत्मा आदमी म हमेशा निवास नहीं करेंन, कहालीकि आदमी भी शरीरच आय; ओकी उमर एक सौ बीस साल की होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","उन दिनो म धरती पर दानव रहत होतो; अऊर येको बाद जब परमेश्वर को बेटा अऊर आदमी की बेटियों को जवर गयो तब उन्को द्वारा जो बेटा पैदा भयो हि प्राचीनकाल को शक्तिशाली अऊर प्रसिद्ध वीर होतो। ");
INSERT INTO lbm_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","परमेश्वर न देख्यो कि आदमियों की बुरायी धरती पर बढ़ गयी हय, अऊर उन्को मन को बिचार म जो कुछ पैदा होवय हय ऊ हर समय बुरायी लायीच होवय हंय। ");
INSERT INTO lbm_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","यो बात सी प्रभु ख दु:ख भयो कि ओन धरती पर आदमी ख बनायो, अऊर ओको मन ख बहुत ठेस पहुंची। ");
INSERT INTO lbm_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","तब परमेश्वर न कह्यो, “मय आदमी ख जेकी मय न सृष्टि करी हय धरती को ऊपर सी मिटाय देऊं; का आदमी, का, जनावर, का रेंगन वालो जन्तु, का आसमान को पक्षी, सब ख मिटाय देऊं, कहालीकि मोख यो बात को दु:ख हय कि मय न उन्ख बनायो।” ");
INSERT INTO lbm_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","पर परमेश्वर को अनुग्रह की नजर नूह पर बनी रही। ");
INSERT INTO lbm_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नूह की वंशावली यो हय। नूह सच्चो पुरुष अऊर अपनो समय को लोगों म खरो होतो; अऊर नूह परमेश्वर कोच संग संग चलतो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","अऊर नूह सी शेम, हाम, अऊर येपेत नाम को तीन बेटा पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ऊ समय परमेश्वर की नजर म धरती भ्रष्ट होय गयी होती, अऊर धरती हिंसा सी भर गयी होती ");
INSERT INTO lbm_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","अऊर परमेश्वर न धरती ख देख्यो कि वा भ्रष्ट भय गयी हय; कहालीकि पूरो प्रानियों न धरती पर अपनो चाल चलन भ्रष्ट कर लियो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","तब परमेश्वर न नूह सी कह्यो, “मय न पूरो प्रानियों को अन्त करन को निश्चय करयो हय; उन्को वजह धरती हिंसा सी भर गयी हय, येकोलायी मय उन्ख धरती समेत नाश कर डालूं। ");
INSERT INTO lbm_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","येकोलायी तय गोपेर झाड़ की लकड़ी को एक जहाज बनाय ले, ओको म कमरा बनायजो, अऊर अन्दर बाहेर ओको पर राल लगायजो। ");
INSERT INTO lbm_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","यो रीति सी तय जहाज बनायजो: अऊर जहाज की लम्बाई चार सौ पचास फीट, पछात्तर फीट चौड़ो, अऊर ऊचो पैतालीस फीट रखजो। ");
INSERT INTO lbm_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","जहाज म एक खिड़की बनायजो, अऊर ओको अठरा इंच ऊपर छत बनायजो, अऊर जहाज म एक तरफ दरवाजा रखजो; अऊर जहाज म पहिलो, दूसरो, तीसरो खण्ड बनायजो। ");
INSERT INTO lbm_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","अऊर मय आसमान को खल्लो उन पूरी प्रानियों ख, जेको म जीवन की श्वास हय, नाश करन लायी धरती पर जल प्रलय करूं; अऊर धरती को पूरो प्रानी मर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","पर मय तोरो संग एक वाचा बान्धू हय; येकोलायी तय अपनी पत्नी, अपनो बेटां, अऊर बहुवों समेत जहाज म प्रवेश करजो। ");
INSERT INTO lbm_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","अऊर पूरी जाति को जीन्दो प्रानियों म सी दोय दोय, नर अऊर मादा, अपनो संग जहाज म ले जाजो जेको सी हि तोरो संग जीन्दो रहे। ");
INSERT INTO lbm_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","हर एक जाति को पक्षियों, जनावरों, जमीन पर रेंगन वालो जन्तुवों म सी दोय दोय तोरो जवर आयेंन कि तय उन्ख जीन्दो रखजो। ");
INSERT INTO lbm_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","हर एक तरह को भोजन जो खायो जायेंन, उन्ख तय ले क अपनो जवर जमा कर लेजो; जो तोरो अऊर उन्को भोजन लायी होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","नूह न असोच करयो, ओन परमेश्वर की आज्ञा को अनुसार सब कुछ करयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","परमेश्वर न नूह सी कह्यो, “तय अपनो पूरो परिवार सहित जहाज म जावो; कहालीकि मय न यो समय को लोगों म सी केवल तोख अपनी नजर म सच्चो पायो हय। ");
INSERT INTO lbm_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","तय सब जाति को शुद्ध जनावरों म सी नर अऊर मादा को सात जोड़ा अऊर अशुद्ध जनावरों म सी नर मादा को एक एक जोड़ा लेजो। ");
INSERT INTO lbm_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","अऊर आसमान को पक्षियों म सी नर अऊर मादा को सात सात जोड़ा लेजो, जेको सी पूरी धरती पर उन्की जाति जीन्दी रहे। ");
INSERT INTO lbm_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","कहालीकि अब सी सात दिन को बाद चालीस दिन अऊर चालीस रात तक धरती पर पानी बरसातो रहूं; अऊर उन सब प्रानियों ख जमीन को ऊपर सी मिटाय देऊं, जिन्ख मय न बनायो होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","नूह न परमेश्वर की आज्ञा को अनुसार सब कुछ करयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","जब धरती पर जल प्रलय भयो, तब नूह की उमर छय सौ साल की होती। ");
INSERT INTO lbm_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नूह जल प्रलय सी बचन लायी अपनी पत्नी, बेटां, अऊर बहुवों को संग जहाज म गयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","शुद्ध अऊर अशुद्ध, दोयी तरह को जनावरों म सी, अऊर रेंगन वालो पूरो जन्तुवों म सी भी, ");
INSERT INTO lbm_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","दोय दोय, यानेकि नर अऊर मादा, नूह को संग जहाज म गयो, जसो परमेश्वर न नूह ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","सात दिन को बाद धरती पर प्रलय को पानी बरसन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","जो साल नूह छय सौ साल को भयो, ओको दूसरों महीना को सत्राहवों दिन आयो; उच दिन बड़ो गहरो समुन्दर को सब झरना फूट पड़्यो, अऊर आसमान को पूरो पानी की रस्ता खुल गयी। ");
INSERT INTO lbm_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","चालीस दिन अऊर चालीस रात तक धरती पर बारीश होती रही। ");
INSERT INTO lbm_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ठीक उच दिन नूह न अपनी पत्नी अऊर बेटा शेम, हाम, अऊर येपेत नाम को बेटा, अऊर तीनो बहुवों को संग जहाज म सिरयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","अऊर उन्को संग हर एक जाति को जंगली जनावर, पालतु जनावर, अऊर धरती पर रेंगन वालो जन्तु अऊर जाति जाति को उड़न वालो पक्षी, जहाज म गयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","हर एक प्रानियों म सी दोय दोय प्रानी जिन्म जीवन की श्वास होती, हि नूह को संग जहाज म गयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","हर एक प्रानियों को नर अऊर मादा जहाज म गयो, जसो परमेश्वर न आज्ञा दियो होतो। तब परमेश्वर न नूह को जहाज को दरवाजा बन्द कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","धरती पर चालीस दिन तक जल प्रलय होतो रह्यो; अऊर पानी बहुत बड़तो गयो, जेको सी जहाज ऊपर उठन लग्यो; अऊर ऊ धरती पर सी ऊचो उठ गयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","पानी बढ़तो बढ़तो धरती पर बहुतच बढ़ गयो, अऊर जहाज पानी को ऊपर ऊपर तैरन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पानी बढ़ क धरती पर इतनो बढ़ गयो, कि आसमान को खल्लो की पूरी ऊची ऊची पहाड़ी भी ओको म डुब गयी। ");
INSERT INTO lbm_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पानी पच्चीस फीट अऊर ऊपर बढ़ गयो। अऊर पहाड़ी भी डुब गयी। ");
INSERT INTO lbm_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","अऊर का पक्षी, का घरेलू जनावर, का जंगली जनावर, अऊर धरती पर सब चलन वालो प्रानी, अऊर जितनो जीव जन्तु, यानेकि धरती को हर एक आदमी मर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","जो जो जमीन पर होतो, जितनो को शरीर म जीवन की श्वास होती, सब मर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","परमेश्वर न जमीन पर रहन वालो हर एक जीन्दो प्रानी ख, आदमी अऊर जनावर ख, रेंगन वालो जन्तुवों ख, अऊर आसमान को पक्षियों ख मिटाय डाल्यो; केवल नूह अऊर जितनो ओको संग जहाज म होतो, हिच बच गयो। ");
INSERT INTO lbm_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","अऊर पानी धरती पर एक सौ पचास दिन तक बन्यो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","पर परमेश्वर न नूह अऊर जितनो जंगली जनावर अऊर पालतु जनावरों की सुधि ली, जो जहाज म ओको संग होतो, अऊर परमेश्वर न धरती पर हवा चलायी, अऊर पानी घटन लग्यो; ");
INSERT INTO lbm_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","अऊर गहरो समुन्दर को झरना अऊर आसमान को झरोका बन्द होय गयो; अऊर ओको सी जो बारीश होत होती, वा भी रुक गयी; ");
INSERT INTO lbm_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","अऊर एक सौ पचास दिन को बाद पानी धरती पर सी लगातार घटन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","अऊर जहाज सातवों महीना को सत्राहवों दिन अरारात नाम की पहाड़ी पर टिक गयो। ");
INSERT INTO lbm_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","अऊर पानी दसवों महीना तक घटतो चली गयो, अऊर दसवों महीना को पहिलो दिन पहाड़ी की सेंडी दिखायी दी। ");
INSERT INTO lbm_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","तब असो भयो कि चालीस दिन को बाद नूह न अपनो बनायो हुयो जहाज की खिड़की ख खोल क, ");
INSERT INTO lbm_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ओन एक कौवा उड़ाय दियो : अऊर जब तक पानी धरती पर सी सूख नहीं गयो, तब तक कौवा इत उत उड़तो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","तब नूह न अपनो जवर सी एक कबूत्तरी ख भी उड़ाय दियो कि देखबो कि पानी धरती पर सी घट गयो कि नहीं। ");
INSERT INTO lbm_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ऊ कबूत्तरी ख अपनो पाय टेकन लायी आधार नहीं मिल्यो, त कबूत्तरी नूह को जवर जहाज म वापस चली गयो: कहालीकि पूरी धरती को ऊपर पानीच पानी छायो होतो तब नूह न हाथ बढ़ाय क ओख अपनो जवर जहाज म ले लियो। ");
INSERT INTO lbm_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","तब ऊ अऊर सात दिन तक रुक्यो रह्यो, अऊर ओन उच कबूत्तरी ख जहाज म सी फिर सी उड़ाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","अऊर कबूत्तरी शाम को समय ओको जवर आय गयो, त ओन यो देख्यो कि ओकी चोच म जैतून को एक नयो पत्ता हय; येको सी नूह न जान लियो कि पानी धरती पर सी घट गयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","तब नूह न सात दिन अऊर रुक क उच कबूत्तरी ख उड़ाय दियो; किन्तु ऊ ओको जवर फिर वापस नहीं आयी। ");
INSERT INTO lbm_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","जो साल नूह छय सौ एक साल को भयो, ओको पहिलो महीना को पहिलो दिन धरती को पानी सूख गयो। तब नूह न जहाज की छत खोल क चारयी तरफ देख्यो कि जमीन सूख रही हय। ");
INSERT INTO lbm_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","अऊर दूसरों महीना को सत्ताईसवों दिन देख्यो कि धरती पूरी तरह सूख गयी। ");
INSERT INTO lbm_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तब परमेश्वर न नूह सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“तय अपनी पत्नी, बेटा अऊर बहुवों को संग जहाज म सी बाहेर निकल आव। ");
INSERT INTO lbm_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","तोरो संग जो जीन्दो प्रानी, यानेकि जनावरों, पक्षियों, अऊर धरती पर रेंगन वालो जन्तु हंय, उन्ख भी तय जहाज सी बाहेर निकाल ले जेको सी हि धरती पर झुण्ड को झुण्ड पैदा करे; अऊर हि बहुत जादा ताकतवर हो, अऊर धरती पर फैल जाये।” ");
INSERT INTO lbm_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","तब नूह अपनी पत्नी, बेटा, अऊर बहुवों को संग जहाज सी बाहेर निकल आयो : ");
INSERT INTO lbm_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","अऊर सब जनावर, रेंगन वालो जन्तु, अऊर पक्षी अऊर धरती को पूरो जीवजन्तु अपनी जाति जाति को अनुसार जहाज म सी बाहेर निकल आयो। ");
INSERT INTO lbm_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","तब नूह न प्रभु लायी एक वेदी बनायी; अऊर सब शुद्ध जनावरों अऊर सब शुद्ध पक्षियों म सी कुछ ख चुन्यो अऊर वेदी पर उन्की होमबलि चढ़ायो। ");
INSERT INTO lbm_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","जब प्रभु ख होमबलि की सुखदायक सुगन्ध मिली तब प्रभु न अपनो दिल म कह्यो, “अब मय आदमी को वजह जमीन ख फिर कभी श्राप नहीं देऊं, बचपन सीच आदमी को मन को बिचार बुरायी लायी होवय हय; जसो मय न अभी करयो हय, वसो उन्ख फिर कभी नहीं मारूं। ");
INSERT INTO lbm_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","अब सी जब तक धरती बनी रहेंन, तब तक बोवन अऊर काटन को समय, ठंडी अऊर गर्मी, गर्मी अऊर ठंडी, दिन अऊर रात, को होनो खतम नहीं होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","तब परमेश्वर न नूह अऊर ओको बेटा ख आशीष दी अऊर ओन कह्यो, “फूलो फलो, अऊर बढ़ो, अऊर धरती म भर जावो। ");
INSERT INTO lbm_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","तुम्हरो डर अऊर अधिकार सी धरती को सब जनावरों, अऊर आसमान को सब पक्षियों, अऊर जमीन पर को सब रेंगन वालो जन्तुवों, अऊर समुन्दर की सब मच्छी पर बन्यो रहेंन हि सब तुम्हरो वश म कर दियो जावय हंय। ");
INSERT INTO lbm_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","सब चलन वालो जीवजन्तु तुम्हरो जेवन होयेंन; जसो मय न तुम्ख हरो पौधा दियो होतो, वसोच अब सब कुछ देऊ हय। ");
INSERT INTO lbm_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","पर, तुम मांस ख ओको जीव मतलब खून को संग मत खाजो। ");
INSERT INTO lbm_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","कहालीकि मय जरूर तुम्हरो खून अऊर जीव को बदला लेऊं: अऊर मय हर एक जनावर सी, अऊर हर एक आदमी सी ओको बदला लेऊं; अऊर मय हर एक आदमी सी ओको भाऊ बहिनों को खून को बदला लेऊं। ");
INSERT INTO lbm_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जो कोयी आदमी को खून बहायेंन ओको भी खून आदमी द्वारा बहायो जायेंन; कहालीकि परमेश्वर न आदमी ख अपनो जसो बनायो हय। ");
INSERT INTO lbm_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“अऊर तुम फलो फूलो अऊर धरती पर बहुतायत सी सन्तान पैदा कर क् ओको म भर जावो।” ");
INSERT INTO lbm_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","तब परमेश्वर न नूह अऊर ओको बेटों सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“सुनो, मय तुम्हरो संग अऊर तुम्हरो वंशजों को संग अपनी वाचा बान्ध रह्यो हय; ");
INSERT INTO lbm_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","अऊर जब जीन्दो प्रानियों सी भी जो तुम्हरो संग हंय, का पक्षी का पालतु जनावर, का धरती को सब जंगली जनावर, धरती को जितनो जीवजन्तु जहाज सी निकल्यो हंय। ");
INSERT INTO lbm_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","अऊर मय तुम्हरो संग अपनी यो वाचा बान्धू हय कि सब प्रानी फिर जल प्रलय सी नाश नहीं होयेंन अऊर धरती को नाश करन लायी फिर कभी जल प्रलय नहीं होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","तब परमेश्वर न कह्यो, “जो वाचा मय न तुम्हरो संग, अऊर जितनो जीन्दो प्रानी तुम्हरो संग हय उन सब को संग भी युग युग की पीढ़ियों लायी बान्धू हय; ओको यो चिन्ह हय : ");
INSERT INTO lbm_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","कि मय न बादर म अपनो धनुष रख्यो हय, ऊ मोरो अऊर धरती को बीच म वाचा को चिन्ह होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","अऊर जब मय धरती पर बादर फैलाऊं तब बादर म धनुष दिखायी देयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","तब मोरी जो वाचा तुम्हरो अऊर पूरो जीन्दो प्रानियों को संग बंधी हय; ओख मय याद करूं, तब असो जल प्रलय फिर नहीं होयेंन जेको सी सब प्रानी को नाश होय जाये। ");
INSERT INTO lbm_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","बादर म जो धनुष होयेंन मय ओख देख क यो हमेशा की वाचा याद करूं, जो परमेश्वर को अऊर धरती पर को पूरो जीन्दो प्रानियों को बीच बंधी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","तब परमेश्वर न नूह सी कह्यो, “जो वाचा मय न धरती भर को पूरो प्रानियों को संग बान्धी हय, ओको चिन्ह योच आय।” ");
INSERT INTO lbm_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नूह को जो बेटा जहाज म सी निकल्यो, ऊ शेम, हाम अऊर येपेत होतो; अऊर हाम कनान को बाप भयो। ");
INSERT INTO lbm_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","नूह को तीन बेटा हिच हंय, अऊर इन्को वंश पूरी धरती पर फैल गयो। ");
INSERT INTO lbm_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नूह जो एक किसान होतो, जो अंगूर की बाड़ी लगावन वालो पहिलो आदमी भयो। ");
INSERT INTO lbm_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","अऊर ऊ अंगूर को रस पी क मतवालो भयो; अऊर अपनो तम्बू को अन्दर नंगा भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","तब कनान को बाप हाम न, अपनो बाप ख नंगा देख्यो, अऊर बाहेर आय क अपनो दोयी भाऊ ख बताय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","तब शेम अऊर येपेत दोयी न एक चादर ली, अऊर ओख अपनो बख्खा पर रख्यो अऊर पीछु को तरफ उलटो चल क अन्दर गयो अऊर उन्न अपनो बाप को शरीर ख झाक दियो अऊर हि अपनो मुंह पीछु करयो हुयो होतो, येकोलायी उन्न अपनो बाप ख नंगा नहीं देख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जब नूह को नशा उतर गयो, तब ओन जान लियो कि ओको छोटो बेटा न ओको संग का करयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","येकोलायी नूह न कह्यो, “कनान श्रापित हो : ऊ अपनो भाऊवों को दासों को दास हो।” ");
INSERT INTO lbm_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","नूह न फिर कह्यो, “शेम को प्रभु परमेश्वर धन्य हय, अऊर कनान शेम को दास हो। ");
INSERT INTO lbm_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्वर येपेत को वंश ख फैलाये; अऊर ऊ शेम को तम्बूवों म निवास करे, अऊर कनान येपेत को दास हो।” ");
INSERT INTO lbm_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जल प्रलय को बाद नूह तीन सौ पचास साल जीन्दो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","यो तरह नूह की कुल उमर नव सौ पचास साल की भयी; ओको बाद ऊ मर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नूह को बेटां शेम, हाम अऊर येपेत होतो; उन्को बेटा जल प्रलय को बाद पैदा भयो: उन्की वंशावली या आय। ");
INSERT INTO lbm_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेत को बेटां : गोमेर, मागोग, मादै, यावान, तूबल, मेशेक अऊर तीरास भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","अऊर गोमेर को बेटां : अश्कनज, रीपत अऊर तोगर्मा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","अऊर यावान को वंश म एलीशा अऊर तर्शीश, कित्ती, अऊर दोदानी लोग भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","इन्को वंश दूसरी जातियों को द्वीपों को देशों म असो बट गयो कि हि दूसरी दूसरी भाषावों, कुलों, अऊर जातियों को अनुसार अलग अलग भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","तब हाम को बेटां : कूश, मिस्र, पूत अऊर कनान भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","अऊर कूश को बेटां सबा, हवीला, सबता, रामा, अऊर सब्तका भयो। अऊर रामा को बेटा शबा अऊर ददान भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूश को वंश म निम्रोद भी भयो; जो धरती पर पहिलो महा शक्तिशाली विजेता होतो। ");
INSERT INTO lbm_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ऊ प्रभु की नजर म महान शिकारी होतो, येकोलायी ओको बारे म यो कहावत प्रसिद्ध हय; “प्रभु की नजर म निम्रोद को जसो महान शिकारी।” ");
INSERT INTO lbm_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ओको राज्य की सुरूवात शिनार देश म बेबीलोन, एरेख, अक्कद, अऊर कलने सी भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","निम्रोद ऊ देश सी निकल क अश्शूर ख गयो, अऊर नीनवे, रहोबोतीर अऊर कालह नाम को नगरों ख बसायो। ");
INSERT INTO lbm_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ओन रेसेन नगर ख भी बसायो जो नीनवे अऊर कालह को बीच म हय; ऊ महानगर हय। ");
INSERT INTO lbm_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिस्र को वंश म लूदी, अनामी, लहाबी, नप्तूही, ");
INSERT INTO lbm_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","अऊर पत्रुसी, कसलूही, अऊर कप्तोरी लोग भयो, कसलूहियों म सी त पलिश्ती लोग निकल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान को वंश म ओको बड़ो बेटा सीदोन, तब हित्त, ");
INSERT INTO lbm_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, एमोरी, गिर्गाशी, ");
INSERT INTO lbm_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, अर्की, शीनी, ");
INSERT INTO lbm_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वदी, समारी, अऊर हमाती लोग भी भयो; तब कनानियों को कुल भी फैल गयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","अऊर कनानियों की सीमा सीदोन सी ले क गरार की रस्ता सी होय क अज्जा तक अऊर तब सदोम, अमोरा, अदमा अऊर सबोयीम की रस्ता सी होय क लाशा तक भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","हाम को वंश म हिच भयो; अऊर हि दूसरो दूसरो कुलों, भाषावों, देशों, अऊर जातियों को अनुसार अलग अलग भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","तब शेम, जो सब एबेर वंशियों को मूल पुरुष भयो, अऊर जो येपेत को भाऊ होतो, ओको भी बेटा पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेम को बेटां : एलाम, अश्शूर, अर्पक्षद, लूद अऊर अराम भयो ");
INSERT INTO lbm_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम को बेटां : ऊस, हूल, गेतेर अऊर मश भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अऊर अर्पक्षद न शेलह ख, अऊर शेलह न एबेर ख जनम दियो। ");
INSERT INTO lbm_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","अऊर एबेर को दोय बेटां पैदा भयो, एक को नाम पेलेग यो वजह रख्यो गयो कि ओको दिनों म धरती बट गयी, अऊर ओको भाऊ को नाम योक्तान होतो। ");
INSERT INTO lbm_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","अऊर योक्तान न अल्मोदाद, शेलेप, हसर्मावेत, येरह, ");
INSERT INTO lbm_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, ऊजाल, दिक्ला, ");
INSERT INTO lbm_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शबा ");
INSERT INTO lbm_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला, अऊर योबाब ख जनम दियो : हिच सब योक्तान को बेटां भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","इन्को रहन की जागा मेशा सी ले क सपारा, जो पूर्व दिशा म एक पहाड़ी प्रदेश हय, ओकी रस्ता तक भयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","शेम को बेटां हिच भयो; अऊर हि दूसरो दूसरो कुलों, भाषावों देशों अऊर जातियों को अनुसार अलग अलग भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नूह को बेटा को घरानों हिच आय : अऊर उन्की जातियों को अनुसार उन्की वंशावली हिच हंय; अऊर जल प्रलय को बाद धरती भर की जातियां इन्कोच म सी होय क बट गयी। ");
INSERT INTO lbm_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","पूरी धरती पर एकच भाषा, अऊर सब जातियां एकच बोली बोलत होती। ");
INSERT INTO lbm_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ऊ समय लोग पूर्व दिशा को तरफ चलतो समय उन्ख शिनार देश म एक मैदान मिल्यो, अऊर हि ऊ मैदान म बस गयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","तब उन्न आपस म कहन लग्यो, “आवो, हम ईटा बनाय बनाय क भली भाति आगी म पकायबो।” अऊर उन्न गोटा की जागा पर ईटा सी, अऊर चूना की जागा पर माटी को गारा सी काम लियो। ");
INSERT INTO lbm_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","तब उन्न कह्यो, “आवो, हम एक नगर अऊर एक मीनार बनायबो, जेकी सेंडी आसमान ख छुय ले, यो तरह सी हम अपनो नाम करबो, असो नहीं होय कि हम्ख पूरी धरती पर फैलनो पड़े।” ");
INSERT INTO lbm_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","जब लोग नगर अऊर गुम्मट बनाय रह्यो होतो; तब उन्ख देखन लायी परमेश्वर उतर आयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","तब प्रभु न कह्यो, “मय का देखू हय, कि सब एकच जाती को लोग हंय, अऊर इन सब की भाषा भी एकच हय, अऊर उन्न असोच काम सुरूवात करयो; अऊर अब जो कुछ हि करन की कोशिश करेंन, ओको म सी कुछ भी उन्को लायी असम्भव नहीं होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","येकोलायी आवो, हम उतर क उन्की भाषा म बड़ी गड़बड़ी डालबो, कि हि एक दूसरो की बोली ख नहीं समझ सके।” ");
INSERT INTO lbm_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","यो तरह परमेश्वर न उन्ख उत सी पूरी धरती को ऊपर फैलाय दियो; अऊर उन्न ऊ नगर ख बनानो छोड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","यो वजह ऊ नगर को नाम बेबीलोन पड़्यो; कहालीकि पूरी धरती की भाषा म जो गड़बड़ी हय, प्रभु न उतच डाली, अऊर उतच सी प्रभु न आदमियों ख पूरी धरती को ऊपर फैलाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेम की वंशावली यो आय। जल प्रलय को दोय साल बाद जब शेम एक सौ साल को भयो, तब ओन अर्पक्षद ख जनम दियो। ");
INSERT INTO lbm_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अऊर अर्पक्षद न जनम को बाद शेम पाच सौ साल जीन्दो रह्यो; अऊर ओको अऊर भी बेटा बेटियां पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जब अर्पक्षद पैतीस साल को भयो, तब ओन शेलह ख जनम दियो। ");
INSERT INTO lbm_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","अऊर शेलह को जनम को बाद अर्पक्षद चार सौ तीन साल अऊर जीन्दो रह्यो, अऊर ओको अऊर भी बेटा बेटियां पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","जब शेलह तीस साल को भयो, तब ओको द्वारा एबेर को जनम भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","अऊर एबेर को जनम को बाद शेलह चार सौ तीन साल अऊर जीन्दो रह्यो, अऊर ओको अऊर भी बेटा बेटियां पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","जब एबेर चौंतीस साल को भयो, तब ओको द्वारा पेलेग को जनम भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","अऊर पेलेग को जनम को बाद एबेर चार सौ तीस साल अऊर जीन्दो रह्यो, अऊर ओको अऊर भी बेटा बेटियां पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","जब पेलेग तीस साल को भयो, तब ओको द्वारा रऊ को जनम भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","अऊर रऊ को जनम को बाद पेलेग दोय सौ नव साल अऊर जीन्दो रह्यो, अऊर ओको अऊर भी बेटा बेटियां पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","जब रऊ बत्तीस साल को भयो, तब ओको द्वारा सरूग को जनम भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","अऊर सरूग को जनम को बाद रऊ दोय सौ सात साल अऊर जीन्दो रह्यो, अऊर ओको अऊर भी बेटा बेटियां पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","जब सरूग तीस साल को भयो, तब ओको द्वारा नाहोर को जनम भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","अऊर नाहोर को जनम को बाद सरूग दोय सौ साल अऊर जीन्दो रह्यो, अऊर ओको अऊर भी बेटा बेटियां पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","जब नाहोर उनतीस साल को भयो, तब ओको द्वारा तेरह को जनम भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","अऊर तेरह को जनम को बाद नाहोर एक सौ उन्नीस साल अऊर जीन्दो रह्यो, अऊर ओको अऊर भी बेटा बेटियां पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","जब तक तेरह सत्तर साल को भयो, तब तक ओको द्वारा अब्राम, नाहोर, अऊर हारान पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरह की वंशावली यो आय : तेरह न अब्राम, नाहोर अऊर हारान ख जनम दियो; अऊर हारान न लूत ख जनम दियो। ");
INSERT INTO lbm_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","अऊर हारान की मृत्यु ओको बाप तेरह को जीवन काल मच कसदी जाति को ऊर नाम को नगर म भयी, जो ओकी जन्मभूमि होती। ");
INSERT INTO lbm_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम अऊर नाहोर न बिहाव करयो। अब्राम की पत्नी को नाम सारै, अऊर नाहोर की पत्नी को नाम मिल्का होतो। मिल्का हारान की बेटी होती, अऊर हारान मिल्का अऊर यिस्का इन दोयी को बाप होतो। ");
INSERT INTO lbm_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारै त बांझ होती; अऊर ओकी कोयी सन्तान नहीं होती। ");
INSERT INTO lbm_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","अऊर तेरह न अपनो बेटा अब्राम, अऊर अपनो नाती लूत, जो हारान को बेटा होतो, अऊर अपनी बहू सारै, जो ओको बेटा अब्राम की पत्नी होती, इन पूरो ख ले क कसदी जाति को ऊर नगर सी निकल क कनान देश को तरफ चल पड़्यो; पर हारान नाम को देश म पहुंच क उतच रहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","जब तेरह दोय सौ पाच साल को भयो, तब ऊ हारान देश म मर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","प्रभु न अब्राम सी कह्यो, “तय अपनो देश, अऊर अपनी जन्मभूमि, अऊर अपनो बाप को घर ख छोड़ क ऊ देश म चली जा, जो मय तोख दिखाऊं। ");
INSERT INTO lbm_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","अऊर मय तोरो सी एक बड़ो राष्ट्र पैदा करूं, अऊर मय तोख आशीष देऊं, अऊर तोरो नाम महान बनाऊं, ताकि तय आदमी की जाति लायी आशीष को वजह बन जाजो। ");
INSERT INTO lbm_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","“जो तोख आशीर्वाद देन, उन्ख मय आशीष देऊं, पर जो तोख श्राप देन, ओख मय श्राप देऊं; अऊर धरती को पूरो कुटुम्ब तोरो द्वारा मोरो सी आशीष पायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","परमेश्वर की आज्ञा को अनुसार अब्राम चली गयो; अऊर लूत भी ओको संग चली गयो; अऊर अब्राम हारान देश सी निकल्यो ऊ समय अब्राम पचहत्तर साल को होतो। ");
INSERT INTO lbm_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","यो तरह अब्राम अपनी पत्नी सारै, अऊर अपनो भतीजा लूत ख, अऊर जो धन उन्न जमा करयो होतो, अऊर जो उन्न हारान देश म दास दासियों ख हासिल करयो होतो, इन सब ख ले क कनान देश म जान लायी निकल गयो, अऊर हि कनान देश म पहुंच्यो। ");
INSERT INTO lbm_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ऊ देश को बीच सी जातो हुयो अब्राम शेकेम नाम की जागा पर पहुंच्यो, जित मोरे को पवित्र झाड़ हय। ऊ समय कनानी जाति ऊ देश म रहत होती। ");
INSERT INTO lbm_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","तब परमेश्वर न अब्राम ख दर्शन दे क कह्यो, “यो देश मय तोरो वंश ख देऊं।” अऊर अब्राम उत प्रभु लायी, जेन ओख दर्शन दियो होतो, उत ओको लायी ओन एक वेदी बनायी। ");
INSERT INTO lbm_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","तब उत सी आगु बढ़ क, अब्राम ऊ पहाड़ी पर आयो, जो बेतेल नगर की पूर्व दिशा को तरफ हय; अऊर अपनो तम्बू ऊ जागा म खड़ो करयो जेको पश्चिम को तरफ बेतेल, अऊर पूर्व को तरफ ऐ नगर होतो, उत अब्राम न प्रभु लायी एक वेदी बनायी : अऊर प्रभु सी आराधना करी। ");
INSERT INTO lbm_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","तब अब्राम कनान देश को दक्षिन भाग को तरफ, एक जागा सी दूसरी जागा पर चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","लेकिन कनान म एक अकाल पड़्यो: येकोलायी अब्राम मिस्र देश ख चली गयो कि उत परदेशी जसो रहे, कहालीकि देश म भयानक अकाल पड़्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","तब असो भयो कि हि मिस्र देश को जवर पहुंच क, अब्राम न अपनी पत्नी सारै सी कह्यो, “सुनो, मोख मालूम हय, कि तय एक सुन्दर बाई हय। ");
INSERT INTO lbm_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","अऊर जब मिस्र को रहन वालो तोख देखेंन, तब कहेंन, ‘या ओकी पत्नी आय,’ येकोलायी हि मोख त मार डालेंन, पर तोख जीन्दो रहन देयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","येकोलायी तय यो कह्यजो कि, ‘मय ओकी बहिन आय,’ जेको सी तोरो वजह मोरो कल्यान हो अऊर मोरो जीव तोरो वजह बचेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","तब असो भयो कि जब अब्राम मिस्र देश म आयो, तब उत को रहन वालो न ओकी पत्नी ख देख्यो कि या त बड़ी सुन्दर हय। ");
INSERT INTO lbm_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","अऊर मिस्र को राजा फिरौन को अधिकारियों न ओख देख क फिरौन को आगु ओकी प्रशंसा करी : येकोलायी सारै ख फिरौन को महल म पहुंचायी गयी। ");
INSERT INTO lbm_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","अऊर फिरौन न ओको वजह अब्राम को संग अच्छो बरताव करयो; अऊर अब्राम ख शेरी मेंढी, गाय बईल, दास दासी, गधा गधी, अऊर ऊंट मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","तब प्रभु न फिरौन अऊर ओको महल को लोगों पर, अब्राम की पत्नी सारै को वजह भयानक रोग तकलीफ लगायी। ");
INSERT INTO lbm_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","तब फिरौन न अब्राम ख बुलाय क कह्यो, “तय न मोरो संग यो का करयो? तय न मोख कहाली नहीं बतायो कि वा तोरी पत्नी आय? ");
INSERT INTO lbm_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तय न कहाली कह्यो कि वा तोरी बहिन आय? मय न येकोलायी ओख अपनी पत्नी बनाय लियो होतो; पर अब अपनी पत्नी ख ले क इत सी चली जा।” ");
INSERT INTO lbm_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","अऊर फिरौन न अपनो अधिकारियों ख ओको बारे म आज्ञा दियो अऊर उन लोगों न अब्राम ख अऊर अब्राम की पत्नी ख, सब सम्पत्ति को संग जो ओको होतो, ओख बिदा कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","तब अब्राम अपनी पत्नी, अऊर अपनी पूरी सम्पत्ति ले क, अऊर लूत ख भी संग लियो, अऊर मिस्र देश ख छोड़ क कनान को दक्षिन देश म आयो। ");
INSERT INTO lbm_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम अपनी शेरी मेंढी, गाय बईल, अऊर सोनो चांदी को वजह बहुत धनी होतो। ");
INSERT INTO lbm_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","तब अब्राम दक्षिन देश सी चल क, बेतेल नगर को जवर उच जागा पर पहुंच्यो, जित पहिले ओन अपनो तम्बू खड़ो करयो होतो, जो बेतेल अऊर ऐ नगर को बीच म हय। ");
INSERT INTO lbm_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","यो जागा ऊ वेदी को हय, जेक अब्राम पहिले सीच बनायो होतो, अऊर उत अब्राम न फिर प्रभु सी आराधना करी। ");
INSERT INTO lbm_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","लूत को जवर भी, जो अब्राम को संग चलत होतो, ओको जवर भी शेरी मेंढी, गाय बईल अऊर तम्बू होतो। ");
INSERT INTO lbm_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","येकोलायी ऊ देश म उन दोयी लायी उचित जागा नहीं होती कि हि एक संग रह्य सके, कहालीकि उन्को जवर बहुत सारो जनावर होतो, कि हि एक संग नहीं रह्य सकत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","तब अब्राम को जनावरों की देखभाल करन वालो अऊर लूत को जनावरों की देखभाल करन वालो को बीच म झगड़ा शुरू भय गयो। ऊ समय कनानी, अऊर परिज्जी लोग, ऊ देश म रहत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","तब अब्राम लूत सी कहन लग्यो, “मोरो अऊर तोरो जनावरों की देखभाल करन वालो को बीच झगड़ा होनो नहीं पाये; कहालीकि हम लोग रिश्तेदार हंय। ");
INSERT INTO lbm_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","का पूरो देश तोरो आगु नहीं? येकोलायी मोरो सी अलग होय जा; यदि तय बायो तरफ जाजो त मय दायो तरफ जाऊं; अऊर यदि तय दायो तरफ जाजो, त मय बायो तरफ जाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","तब लूत न अपनी आंखी ऊपर उठाय क आगु देख्यो, कि सोअर की दिशा म यरदन नदी को जवर वालो पूरो घाट अऊर प्रभु को बगीचा, अऊर मिस्र देश की जमीन को जसो पानी सी पूरी सिंची हुयी होती। यो प्रभु को द्वारा करयो गयो सदोम अऊर अमोरा को नाश को पहिले की बात आय। ");
INSERT INTO lbm_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","येकोलायी लूत अपनो लायी यरदन की पूरो घाट ख चुन क पूर्व दिशा को तरफ चली गयो, यो तरह हि एक दूसरो सी अलग भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम त कनान देश म रह्यो, पर लूत ऊ घाट को नगरों म रहन लग्यो; अऊर अपनो तम्बू सदोम नगर को जवर खड़ो करयो। ");
INSERT INTO lbm_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोम नगर को लोग प्रभु की नजर म बड़ो दुष्ट अऊर पापी होतो। ");
INSERT INTO lbm_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","जब लूत अब्राम सी अलग भय गयो तब ओको बाद प्रभु न अब्राम सी कह्यो, “अपनी आंखी ऊपर उठाव अऊर जो जागा पर तय हय उत सी उत्तर दक्षिन, पूर्व पश्चिम, इन चारयी तरफ नजर कर। ");
INSERT INTO lbm_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","कहालीकि जितनी जमीन तोख दिखायी देवय हय, उन सब ख मय तोख अऊर तोरो वंश ख हमेशा हमेशा लायी देऊं। ");
INSERT INTO lbm_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","अऊर मय तोरो वंश ख धरती की धूल को कन को जसो बहुत बढ़ाऊं, कि उन्की गिनती करनो बहुत मुश्किल होयेंन, यदि कोयी धरती की धूल को कन ख गिन सकेंन त उच तोरो वंश ख भी गिन सकेंन। ");
INSERT INTO lbm_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","उठ, यो देश की लम्बाई अऊर चौड़ाई म चल फिर; कहालीकि मय यो सब तोख देन जाय रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","येको बाद अब्राम न अपनो तम्बू निकाल क, मम्रे को पवित्र झाड़ को जवर जो हेब्रोन म होतो, जाय क रहन लग्यो, अऊर उत भी ओन परमेश्वर की एक वेदी बनायी। ");
INSERT INTO lbm_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","शिनार को राजा अम्रापेल, अऊर एल्लासार को राजा अर्योक, अऊर एलाम को राजा कदोर्लाओमेर, अऊर गोयीम को राजा तिदाल को दिनों म असो भयो, ");
INSERT INTO lbm_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","कि उन्न सदोम को राजा बेरा, अऊर अमोरा को राजा बिर्शा, अऊर अदमा को राजा शिनाब, अऊर सबोयीम को राजा शेमेबेर, अऊर बेला जो सोअर भी कहलावय हय, इन राजावों को खिलाफ युद्ध करयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","इन पाचों राजा न सिद्दीम नाम को घाट म, जो खारे नदी को जवर हय, हि सब जमा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","अऊर हि बारा साल तक त कदोर्लाओमेर को अधिन रह्यो; पर तेरहवों साल म ओको खिलाफ विद्रोह कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चौदावों साल म कदोर्लाओमेर, अऊर ओको संगी राजा चढ़ आयो, अऊर अशतरोत्कनम म रपाई जाति ख, अऊर हाम म जूजी जाति ख, अऊर शावे-किर्यातैम एमी जाती ख, ");
INSERT INTO lbm_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","अऊर सेईर नाम की पहाड़ी म होरी जाति ख, हराय क ऊ एल्पारान तक जो जंगल को जवर हय, उत तक पहुंच गयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","उत सी हि लौट क एन्मिशपात ख आयो, जो कादेश भी कहलावय हय, अऊर अमालेकी जाति को पूरो देश ख, अऊर हसासोन्तामार म रहन वाली एमोरी जाति ख भी हराय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","तब सदोम, अमोरा, अदमा, सबोयीम, अऊर बेला, जो सोअर भी कहलावय हय, इन्को राजा निकल्यो, अऊर सिद्दीम नाम को घाट म, उन्को संग युद्ध लायी फैसला करयो : ");
INSERT INTO lbm_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","यानेकि एलाम को राजा कदोर्लाओमेर, गोयीम को राजा तिदाल, शिनार को राजा अम्रापेल, अऊर एल्लासार को राजा अर्योक, इन चारयी को खिलाफ उन पाचों न युद्ध को बारे म फैसला करयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीम नाम को घाट म डामर को बहुत सारो गड्डा होतो; जब सदोम अऊर अमोरा को राजा भग्यो तब उन्की सेना को बहुत सारो सिपाही उन्म गिर गयो, अऊर जो बच्यो हि पहाड़ी पर भग गयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","तब उन्को दुश्मनों न सदोम अऊर अमोरा को पूरो सम्पत्ति अऊर भोजन की पूरी चीज ख लूट क चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","अऊर अब्राम को भतीजा लूत, जो सदोम म रहत होतो; अऊर ओकी सम्पत्ति सहित ले क हि चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","तब एक आदमी जो भग क बच निकल्यो होतो ओन जाय क इब्री अब्राम ख यो समाचार दियो; अब्राम त एमोरी मम्रे, जो एशकोल अऊर आनेर को भाऊ होतो, ओको पवित्र झाड़ को बीच म रहत होतो; अऊर हि लोग अब्राम को संग वाचा बान्ध्यो हुयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब अब्राम न यो सुन्यो कि ओको भतीजा बन्दी बनाय लियो गयो हय, तब अब्राम न अपनो तीन सौ अठरा युद्ध विद्या म अनुभवी, सेवकों ख ले क जो ओको कुटुम्ब म पैदा भयो होतो, अऊर हथियार ले क दान नगर तक उन्को पीछा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","अऊर अब्राम न रात म अपनो सेवकों ख अलग अलग दलों म बाट दियो, अऊर अपनो सेवकों को संग दुश्मन पर हमला कर क् उन्ख मार डाल्यो अऊर होबा तक, जो दमिश्क नगर को उत्तर को तरफ हय, उत तक उन्को पीछा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ओको बाद ऊ पूरी सम्पत्ति अऊर अपनो भतीजा लूत, ख अऊर ओकी सम्पत्ति सहित अऊर बाईयों ख, अऊर सब बन्दियों ख, छुड़ाय क वापस ले आयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","जब ऊ कदोर्लाओमेर अऊर ओको संगी राजावों ख जीत क लौट आवत होतो तब सदोम को राजा शावे नाम को घाट म, जो राजा को घाट भी कह्यो जावय हय, ओको सी भेंट करन लायी आयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","तब शालेम को राजा मलिकिसिदक, जो परमप्रधान परमेश्वर को याजक होतो, ऊ रोटी अऊर अंगूर को रस ले आयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","अऊर ओन अब्राम ख यो आशीर्वाद दियो, “परमप्रधान परमेश्वर को तरफ सी, जो आसमान अऊर धरती को अधिकारी हय, तय धन्य हो। ");
INSERT INTO lbm_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","अऊर धन्य हय परमप्रधान परमेश्वर, जेन तोरो दुश्मनों ख तोरो वश म कर दियो।” तब अब्राम न ओख हर एक चिज को दसवा अंश भेंट करयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","तब सदोम को राजा न अब्राम सी कह्यो, “आदमी ख त मोख दे, अऊर सम्पत्ति ख अपनो जवर रख।” ");
INSERT INTO lbm_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","अब्राम न सदोम को राजा ख उत्तर दियो, “परमप्रधान प्रभु परमेश्वर, जो आसमान अऊर धरती को अधिकारी हय, ");
INSERT INTO lbm_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ओकी मय यो कसम खाऊ हय, कि जो कुछ तोरो हय ओको म सी मय सूत नहीं लेऊं, अऊर नहीं जूती को बन्धन, अऊर कोयी चिज नहीं लेऊं; कि तय असो नहीं कहनो पाये, कि अब्राम मोरो वजह धनी भयो। ");
INSERT INTO lbm_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","पर जो कुछ इन जवानों न खाय लियो हय अऊर उन्को भाग, जो मोरो संग गयो होतो मतलब आनेर, एशकोल, अऊर मम्रे, मय नहीं लौटाऊं, हि त अपनो अपनो भाग रख ले।” ");
INSERT INTO lbm_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","इन बातों को बाद प्रभु को यो वचन दर्शन म अब्राम को जवर पहुंच्यो : “हे अब्राम, मत डर; मय तोरी ढाल अऊर बड़ो प्रतिफल आय।” ");
INSERT INTO lbm_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्राम न कह्यो, “हे प्रभु यहोवा, मोरी त कोयी सन्तान नहाय, अऊर मोरो घर को वारिस यो दमिश्कवासी एलीएजेर होयेंन, बल्की तय मोख का देजो?” ");
INSERT INTO lbm_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अऊर अब्राम न कह्यो, “मोख त तय न सन्तान नहीं दियो, अऊर का देखू हय, कि मोरो घर म पैदा भयो एक जन मोरो वारिस होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तब प्रभु को यो वचन ओको जवर पहुंच्यो, “यो तोरो वारिस नहीं होयेंन, तोरो जो खुद को बेटा होयेंन, उच तोरो वारिस होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","अऊर प्रभु न अब्राम ख बाहेर लिजाय क कह्यो, “आसमान को तरफ नजर कर क् तारा ख, तय गिन सकय हय?” तब प्रभु न अब्राम सी कह्यो, “तोरो वंश असोच होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अब्राम न परमेश्वर पर विश्वास करयो; अऊर परमेश्वर न अब्राम को यो विश्वास ख उन्की सच्चायी मान्यो। ");
INSERT INTO lbm_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","अऊर परमेश्वर न अब्राम सी कह्यो, “मय उच परमेश्वर आय, जो तोख कसदियों को ऊर नगर सी बाहेर ले आयो, कि तोख यो देश को अधिकार देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","अब्राम न कह्यो, “हे परमेश्वर यहोवा, मय कसो जानु कि यो देश पर मोरो अधिकार होयेंन?” ");
INSERT INTO lbm_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","परमेश्वर न अब्राम सी कह्यो, “मोरो लायी तीन तीन साल की एक गाय, अऊर एक शेरी, अऊर एक मेंढा, अऊर एक पण्डुक, अऊर एक कबूत्तर को बच्चा भी लाजो।” ");
INSERT INTO lbm_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अऊर इन पूरो ख ले क, अब्राम न बीच सी दोय टुकड़ा कर दियो अऊर टुकड़ा ख आमने सामने रख्यो पर चिड़ियां को ओन टुकड़ा नहीं करयो। ");
INSERT INTO lbm_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","जब शिकारी पक्षी उन टुकड़ा पर झपट्यो, तब अब्राम न उन्ख उड़ाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","जब सूरज डुबन लग्यो, तब अब्राम ख गहरी नींद आय गयी; अऊर देखो, बहुत जादा डर अऊर अन्धकार ओको ऊपर आय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","तब प्रभु न अब्राम सी कह्यो, “यो अच्छो सी जान ले कि तोरो वंश परायो देश म परदेशी होय क रहेंन, अऊर ऊ देश को लोगों को दास होय जायेंन; अऊर हि उन्ख चार सौ साल तक दु:ख देयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","तब जो देश को हि दास होयेंन ओख मय दण्ड देऊं : अऊर ओको बाद हि बड़ो धन उत सी ले क निकल आयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","तय त अपनो मरयो हुयो पूर्वजों को जवर जाजो; अऊर तोख पूरो बुढ़ापा म माटी दी जायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","पर हि चौथी पीढ़ी म इत फिर आयेंन : कहालीकि अब तक एमोरी जाति को अधर्म पूरो नहीं भयो हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","अऊर असो भयो कि जब सूरज डुब गयो अऊर घोर अन्धारो छाय गयो, तब एक आग भट्टी जेको म सी धुवा निकलत होतो अऊर एक जरती हुयी मशाल दिखायी दी जो उन टुकड़ा को बीच म सी होय क निकल गयी। ");
INSERT INTO lbm_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","उच दिन परमेश्वर न अब्राम को संग यो वाचा बान्धी, “मिस्र की महा नदी सी ले क फरात नाम की बड़ी नदी तक जितनो देश हय, ");
INSERT INTO lbm_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","मतलब केनियों, कनिज्जियों, कदमोनियों, ");
INSERT INTO lbm_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्तियों, परिज्जियों, रपाइयों ");
INSERT INTO lbm_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरियों, कनानियों, गिर्गाशियों अऊर यबूसियों को देश, मय न तोरो वंश ख दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्राम की पत्नी सारै की कोयी सन्तान नहीं होती : अऊर ओको जवर हागार नाम की एक मिस्री दासी होती। ");
INSERT INTO lbm_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","सारै न अब्राहम सी कह्यो, “देख, प्रभु न त मोरी कोख बन्द कर रखी हय येकोलायी मय तोरो सी बिनती करू हय कि तय मोरी दासी को जवर जा; सम्भव हय कि मोरो घर ओको द्वारा बस जाये।” सारा की यो बात अब्राम न मान ली। ");
INSERT INTO lbm_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","येकोलायी जब अब्राम ख कनान देश म रह्यतो हुयो दस साल बीत गयो तब ओकी पत्नी सारै न अपनी मिस्री दासी हागार ख ले क अपनो पति अब्राम ख दियो, कि वा ओकी पत्नी हो। ");
INSERT INTO lbm_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","तब अब्राम हागार को जवर गयो, अऊर वा गर्भवती भयी; जब हागार न जान्यो कि मय गर्भवती हय, तब वा अपनी स्वामिनी ख अपनी नजर म तुच्छ समझन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","तब सारै न अब्राम सी कह्यो, “जो चोट मोख लगी हय ओको वजह तुम हो। मय न त अपनी दासी ख तोरी पत्नी कर दियो; पर जब ओन जान्यो कि वा गर्भवती हय, तब वा मोख तुच्छ समझन लगी, येकोलायी परमेश्वर मोरो अऊर तोरो बीच म न्याय करे।” ");
INSERT INTO lbm_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्राम न सारै सी कह्यो, “देख तोरी दासी तोरो बस म हय; जसो तोख अच्छो लगे वसोच ओको संग कर।” तब सारै हागार ख दु:ख देन लगी अऊर वा ओको आगु सी भग गयी। ");
INSERT INTO lbm_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","तब परमेश्वर को दूत न हागार ख जंगल म शूर की रस्ता पर पानी को एक झरना को जवर पा क कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“हे सारै की दासी हागार, तय कित सी आवय अऊर कित ख जावय हय?” ओन कह्यो, “मय अपनी स्वामिनी सारै को आगु सी भग क आयी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","परमेश्वर को दूत न ओको सी कह्यो, “अपनी स्वामिनी को जवर लौट जा अऊर ओको बस म रह्य।” ");
INSERT INTO lbm_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","अऊर परमेश्वर को दूत न ओको सी कह्यो, “मय तोरो वंश ख बहुत बढ़ाऊं, यहां तक कि बहुतायत को वजह ओकी गिनती नहीं होय सकेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","अऊर परमेश्वर को दूत न ओको सी कह्यो, “देख तय गर्भवती हय, अऊर बेटा पैदा करजो; तय ओको नाम इश्माएल रखजो; कहालीकि परमेश्वर न तोरो दु:ख को हाल सुन लियो हय। ");
INSERT INTO lbm_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","अऊर तोरो बेटा जंगली गधा को आगु, होयेंन, ओको हाथ सब को विरोध म उठेंन, अऊर सब को हाथ ओको विरोध म उठेंन; अऊर ऊ अपनो सब भाऊ-बन्धुवों को विरोध म निवास करेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","तब हागार न परमेश्वर को नाम जेन ओको सी बाते करी होती, “ओको नाम देखन वालो परमेश्वर रख्यो” कहालीकि वा कहत होती, “का मय न सचमुच परमेश्वर ख देख्यो अऊर ओख देखन को बाद भी जीन्दी रही?” ");
INSERT INTO lbm_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","यो वजह ऊ कुंवा को नाम जीन्दो आदमी को कुंवा जो मोख देखय नाम पड़्यो; ऊ त कादेश अऊर बेरेद को बीच म हंय। ");
INSERT INTO lbm_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हागार ख अब्राम को द्वारा एक बेटा भयो; अऊर अब्राम न अपनो बेटा को नाम, जेक हागार न जनम दियो होतो, इश्माएल रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","जब हागार न अब्राम को द्वारा इश्माएल ख जनम दियो ऊ समय अब्राम छियासी साल को होतो। ");
INSERT INTO lbm_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जब अब्राम निन्यानवे साल को भय गयो, तब प्रभु न ओख दर्शन दे क कह्यो, “मय सर्वशक्तिमान परमेश्वर आय; मोरी उपस्थिति म रह्य क निर्दोष आचरन करन की कोशिश कर। ");
INSERT INTO lbm_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","मय तोरो संग वाचा बान्धूं, अऊर तोरो वंश ख बहुत जादा बढ़ाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","तब अब्राम मुंह को बल गिरयो : अऊर परमेश्वर ओको सी यो बाते करतो गयो, ");
INSERT INTO lbm_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“देख, मोरी वाचा तोरो संग बंधी रहेंन, येकोलायी तय कुछ राष्ट्रों को बुजूर्ग बनजो। ");
INSERT INTO lbm_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","येकोलायी अब सी तोरो नाम अब्राम नहीं रहेंन पर तोरो नाम अब्राहम होयेंन; कहालीकि मय न तोख कुछ राष्ट्रों को बुजूर्ग बनायो हय। ");
INSERT INTO lbm_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","मय तोख बहुत जादा वंशज देऊं, अऊर ओको म सी कुछ राजा होयेंन। अऊर तोरो जवर इतनो वंशज होयेंन कि हि राष्ट्र बन जायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“अऊर मय तोरो संग, अऊर तोरो बाद तोरो वंश की पीढ़ी को संग हमेशा लायी अपनो विधान स्थापित करू हय कि मय तोरो अऊर तोरो बाद तोरो वंश को परमेश्वर रहूं। ");
INSERT INTO lbm_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","अऊर मय तोख, अऊर तोरो बाद तोरो वंश ख भी, यो पूरो कनान देश, जेको म तय परदेशी होय क रह्य हय, यो रीति सी देऊं कि वा हमेशा हमेशा उन्की अपनी जमीन रहेंन, अऊर मय उन्को परमेश्वर रहूं।” ");
INSERT INTO lbm_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","तब परमेश्वर न अब्राहम सी कह्यो, “तय भी मोरो संग बान्धी हुयी वाचा को पालन करजो; तय अऊर तोरो बाद तोरो वंश भी अपनी अपनी पीढ़ी म ओको पालन करे। ");
INSERT INTO lbm_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","मोरो संग बान्धी हुयी वाचा, जेको पालन तोख अऊर तोरो बाद तोरो वंश ख करनो पड़ेंन, ऊ यो आय : तुम म सी एक एक आदमी को खतना हो। ");
INSERT INTO lbm_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तुम अपनो अपनो बच्चा को खतना कराय लेवो : जो वाचा मोरो अऊर तुम्हरो बीच म हय, ओको योच चिन्ह होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","तुम्हरो हर एक बच्चा को खतना ओको जनम को आठवों दिन करयो जाये, हर एक पीढ़ी को आदमी को खतना होनो चाहिये, चाहे ऊ तुम्हरो घर म पैदा भयो दास हो, या विदेशियों सी धन दे क खरीद्यो गयो हो, जो तोरो वंश को नोहोय। ");
INSERT INTO lbm_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","जो तोरो घर म पैदा भयो दास हय, अऊर जो धन दे क खरीद्यो गयो हय, इन दोयी को खतना करयो जाये। यो तरह मोरी वाचा जेको चिन्ह तुम्हरो शरीर पर होयेंन, अऊर यो वाचा हमेशा हमेशा बनी रहेंन। ");
INSERT INTO lbm_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","जो आदमी खतनारहित रहे, मतलब जेको बच्चा को खतना नहीं करयो गयो हय, उच अपनो लोगों म सी नाश करयो जाये, कहालीकि ओन मोरो संग बान्धी हुयी वाचा ख तोड़ दियो।” ");
INSERT INTO lbm_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","तब परमेश्वर न अब्राहम सी कह्यो, “तोरी जो पत्नी सारै हय, ओख तय अब सारै मत कहजो, ओको नाम सारा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","मय ओख आशीष देऊं, अऊर तोख ओको द्वारा एक बेटा देऊं; अऊर मय ओख असी आशीष देऊं, कि वा जाति जाति की माय बनेंन; अऊर ओको वंश म राज्य राज्य को राजा पैदा होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","तब अब्राहम मुंह को बल गिर पड़्यो अऊर हस्यो, अऊर मन मच कहन लग्यो, “का सौ साल को होनो पर भी सन्तान होय सकय हय? अऊर का नब्बे साल की सारा गर्भवती होय सकय हय?” ");
INSERT INTO lbm_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","अऊर अब्राहम न परमेश्वर सी कह्यो, “इश्माएल तोरी नजर म बन्यो रहे, योच बहुत हय।” ");
INSERT INTO lbm_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","तब परमेश्वर न कह्यो, “निश्चय तोरी पत्नी सारा ख तोरो सी एक बेटा पैदा होयेंन; अऊर तय ओको नाम इसहाक रखजो; अऊर मय ओको संग असी वाचा बान्धूं जो ओको बाद ओको वंश लायी हमेशा हमेशा की वाचा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इश्माएल को बारे म भी मय न तोरी सुनी हय; मय ओख भी आशीष देऊं, अऊर ओख कुछ बच्चा अऊर कुछ वंशज देऊं; अऊर ऊ बारा राजकुमारों को बाप होयेंन, अऊर मय ओको वंशजों को एक महान राष्ट्र बनाऊं। ");
INSERT INTO lbm_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","पर मय अपनी वाचा इसहाक को संगच बान्धूं जो सारा सी अगलो साल को योच ठहरायो हुयो समय म पैदा होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","तब परमेश्वर न अब्राहम सी बाते करनो बन्द करी अऊर ओको जवर सी ऊपर चढ़ गयो। ");
INSERT INTO lbm_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","तब अब्राहम न अपनो बेटा इश्माएल ख लियो अऊर, अपनो घर म पैदा भयो दासों, अऊर जितनो ओको रुपया सी खरीद्यो गयो दासों सहित, मतलब ओको घर म जितनो आदमी होतो, उन पूरो ख ले क उच दिन परमेश्वर को वचन को अनुसार उन्को खतना करयो। ");
INSERT INTO lbm_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","जब अब्राहम को खतना करयो गयो तब ऊ निन्यानवे साल को होतो ");
INSERT INTO lbm_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","अऊर जब अब्राहम को बेटा इश्माएल को खतना करयो गयो तब ऊ तेरह साल को होतो। ");
INSERT INTO lbm_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहम अऊर ओको बेटा इश्माएल दोयी को खतना एकच दिन भयो। ");
INSERT INTO lbm_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","अऊर अब्राहम को घर म जितनो आदमी अऊर दास होतो जो घर म पैदा भयो होतो, अऊर जो विदेशियों सी खरीद्यो गयो होतो, सब को खतना ओकोच हाथ सी भयो। ");
INSERT INTO lbm_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","अब्राहम मम्रे को पवित्र झाड़ों को बीच कड़ी तपन को समय तम्बू को दरवाजा पर बैठ्यो हुयो होतो, तब परमेश्वर न ओख दर्शन दियो : ");
INSERT INTO lbm_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","अब्राहम न आंखी ऊपर उठाय क देख्यो कि ओको आगु तीन आदमी खड़ो हंय। जब अब्राहम न उन्ख देख्यो तब ऊ उन्को सी भेंट करन लायी तम्बू को दरवाजा सी दौड़ क आयो, अऊर जमीन पर झुक क उन्ख नमस्कार करयो, ");
INSERT INTO lbm_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","अऊर अब्राहम न कह्यो, “हे प्रभु, यदि मोरो पर तोरी अनुग्रह की नजर हय त मय बिनती करू हय, कि अपनो दास को जवर सी चली मत जाजो। ");
INSERT INTO lbm_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","मय थोड़ो सो पानी लाऊ हय अऊर तय अपनो पाय धोय क यो झाड़ को खल्लो आराम कर। ");
INSERT INTO lbm_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","तब मय एक टुकड़ा रोटी ले आऊं, अऊर तय ओख खाय क अपनो जीव ख सन्तुष्ट कर; तब ओको बाद तय आगु चली जाजो, कहालीकि तय अपनो दास को जवर आयो हंय।” उन्न कह्यो, “जसो तय कह्य हय वसोच कर।” ");
INSERT INTO lbm_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","तब अब्राहम जल्दी सी तम्बू म सारा को जवर गयो अऊर कह्यो, “जल्दीच दस किलो मैदा ले क ओख सान अऊर ओकी रोटी बनाय लेवो।” ");
INSERT INTO lbm_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","तब अब्राहम गाय बईल को झुण्ड म दौड़्यो, अऊर एक कवलो अऊर अच्छो बछड़ा ले क अपनो दास ख दियो, अऊर ओन जल्दी सी ओख पकायो। ");
INSERT INTO lbm_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","तब अब्राहम न दूध, अऊर दही, अऊर बछड़ा को पकायो हुयो मांस, आदमियों को आगु परोस दियो; तब तक हि जेवन करतो रह्यो, अऊर अब्राहम उन्को जवर झाड़ को खल्लो खड़ो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","उन्न अब्राहम सी पुच्छ्यो, “तोरी पत्नी सारा कित हय?” अब्राहम न उत्तर दियो, “वा त तम्बू म हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","उन्म सी एक न कह्यो, “मय अब सी नव महीना बाद वापस आऊं, अऊर तोरी पत्नी सारा ख एक बेटा पैदा होयेंन।” सारा जो अब्राहम को पीछू खड़ी होती, तम्बू को दरवाजा सी उन्की बातचीत सुन रही होती। ");
INSERT INTO lbm_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहम अऊर सारा बहुत बूढ्ढा भय गयो होतो, अऊर सारा को मासिक धर्म बन्द भय गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","येकोलायी सारा अपनो मन म हस क बोली, “मय बूढ्ढी होय गयी हय, अऊर मोरो पति भी बूढ्ढा हय, का येको बाद भी मोख सहवास को आनन्द हासिल होयेंन?” ");
INSERT INTO lbm_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","जब यहोवा न अब्राहम सी कह्यो, “सारा यो कह्य क कहाली हसी, का मय बूढ्ढी होय जाऊं तब भी का एक बेटा ख जनम देऊं? ");
INSERT INTO lbm_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","का यहोवा लायी कोयी काम कठिन हय? जसो कि मय न कह्यो, अब सी नव महीना बाद फिर मय तोरो जवर आऊं, अऊर सारा ख एक बेटा होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","तब सारा डर को मारे यो कह्य क मुकर गयी, “मय नहीं हसी।” यहोवा न कह्यो, “नहीं, तय जरूर हसी होती।” ");
INSERT INTO lbm_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","तब हि आदमी वहां सी चली गयो, उत सी हि सदोम को तरफ देख सकत होतो; अऊर अब्राहम उन्को संग उन्ख उन्की रस्ता पर भेजन लायी संग गयो। ");
INSERT INTO lbm_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","अऊर यहोवा न अपनो आप सी कह्यो, “मय अब्राहम सी नहीं छुपाऊं कि मय का करन जाय रह्यो हय? ");
INSERT INTO lbm_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहम सी त निश्चय एक महान अऊर शक्तिशाली राष्ट्र बनेंन, अऊर धरती को पूरो राष्ट्र ओको द्वारा मोरो सी आशीष पायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","कहालीकि मय जानु हय, कि ऊ अपनो बेटां अऊर वंशजों ख जो ओको पीछू रह्य जायेंन, आज्ञा देयेंन कि हि परमेश्वर की रस्ता म चलतो रहे, अऊर जो सच्चो अऊर न्याय पूर्ण करतो रहे, ताकि जो कुछ परमेश्वर न अब्राहम को बारे म कह्यो हय ओख पूरो करे।” ");
INSERT INTO lbm_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","तब परमेश्वर न कह्यो, “सदोम अऊर अमोरा नगर को खिलाफ भयानक आरोप हंय, अऊर उन्को पाप बहुत भारी होय गयो हय; ");
INSERT INTO lbm_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","येकोलायी मय उतर क देखूं, कि ओको जसो भयानक आरोप मोरो कान तक पहुंच्यो हय, उन्न ठीक वसोच काम करयो हय कि नहीं; अऊर नहीं करयो होना त मय ओख जान लेऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","तब हि आदमी उत सी मुड़ क सदोम को तरफ जान लग्यो; पर अब्राहम परमेश्वर को आगु खड़ो रह्य गयो। ");
INSERT INTO lbm_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","तब अब्राहम न परमेश्वर को जवर आय क कह्यो, “का तय सचमुच दुष्ट को संग निर्दोष ख भी नाश करजो? ");
INSERT INTO lbm_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","अगर ऊ नगर म पचास निर्दोष लोग हंय, त का तय सचमुच पूरो नगर ख नाश कर देजो, अऊर पचास निर्दोष को वजह ओख माफ नहीं करजो, जो ओको म हंय? ");
INSERT INTO lbm_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","यो तरह को काम करनो तोरो सी दूर रहे कि दुष्ट को संग निर्दोष ख भी मार डाले अऊर निर्दोष अऊर दुष्ट दोयी की एकच दशा हो। यो तोरो सी दूर रहे। का पूरी धरती को न्यायी न्याय नहीं करेंन?” ");
INSERT INTO lbm_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","परमेश्वर न कह्यो, “यदि मोख सदोम नगर म पचास निर्दोष लोग मिले, त उन्को वजह मय पूरो नगर ख छोड़ देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","तब अब्राहम न कह्यो, “हे परमेश्वर, सुन मय त माटी अऊर राख आय; तब भी मय न इतनी हिम्मत करी कि तोरो सी बाते करूं। ");
INSERT INTO lbm_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","लेकिन शायद उन पचास निर्दोष म पाच कम होय जाये; त का तय पाच को कम होय जानो को वजह ऊ पूरो नगर को नाश कर देजो?” परमेश्वर न उत्तर दियो, “यदि मय पैतालीस निर्दोष लोग भी मिलेंन, तब मय नगर ख नाश नहीं करूं।” ");
INSERT INTO lbm_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","अब्राहम न फिर कह्यो, “शायद उत चालीस मिले।” तब परमेश्वर न उत्तर दियो, “अगर चालीस हंय त मय ओख नाश नहीं करूं।” ");
INSERT INTO lbm_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","अब्राहम न फिर सी कह्यो, “हे परमेश्वर गुस्सा मत हो, त मय फिर सी कहू हय, यदि केवल उत तीस हंय, त का होयेंन।” परमेश्वर न उत्तर दियो; “यदि मोख उत तीस भी मिलेंन, तब भी मय असो नहीं करूं।” ");
INSERT INTO lbm_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","तब अब्राहम न कह्यो, “हे परमेश्वर, सुन, मय न इतनी हिम्मत त करी हय कि तोरो सी बात करूं : मान ले कि ओको म बीस निर्दोष मिले।” परमेश्वर न कह्यो, “अगर मय बीस ख पाऊ हय त मय नगर ख नाश नहीं करूं।” ");
INSERT INTO lbm_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","अब्राहम न कह्यो, “हे परमेश्वर, गुस्सा मत हो, अऊर मय केवल एकच बार अऊर कहूं : यदि केवल दस मिले त का होयेंन।” परमेश्वर न उत्तर दियो, “अगर दस हंय त मय ओख नाश नहीं करूं।” ");
INSERT INTO lbm_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","अब्राहम को संग बोलन को बाद, परमेश्वर चली गयो अऊर अब्राहम अपनो घर ख लौट गयो। ");
INSERT INTO lbm_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","शाम को समय जब दोय स्वर्गदूत सदोम नगर म आयो; त लूत सदोम नगर की फाटक को जवर बैठ्यो होतो। त लूत स्वर्गदूत ख देख क उन्को सी मुलाखात करन लायी उठ्यो, अऊर मुंह को बल झुक क नमस्कार कर क् कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“हे मोरो प्रभुवों, मय तुम्हरो सी बिनती करू हय, तुम अपनो दास को घर म पधारो, अऊर अपनो पाय धोवो, अऊर रात इतच बिताबो, अऊर सुबेरे उठ क अपनी रस्ता पर जावो।” लेकिन उन्न उत्तर दियो, “नहीं, हम इतच नगर को चौक म रात बितायबो।” ");
INSERT INTO lbm_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","अऊर लूत न स्वर्गदूतों सी बहुत बिनती कर क् उन्ख मनायो; येकोलायी हि ओको संग चल क ओको घर म आयो; अऊर ओन स्वर्गदूतों लायी अपनो दासों ख कुछ रोटी सेकन अऊर जेवन तैयार करन की आज्ञा दियो, जब पूरो जेवन तैयार भय गयो, त उन्न खाय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","उन्को सोय जान को पहिले, सदोम नगर को आदमियों न, जवानों सी ले क बूढ्ढा तक, बल्की चारयी तरफ को सब लोगों न आय क ऊ घर ख घेर लियो; ");
INSERT INTO lbm_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","अऊर लूत ख पुकार क कहन लग्यो, “जो आदमी अज रात ख तोरो जवर आयो हंय हि कित हंय? उन्ख हमरो जवर बाहेर ले आव, कि हम उन्को संग संभोग करे।” ");
INSERT INTO lbm_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","तब लूत दरवाजा सी निकल क उन्को जवर आयो, अऊर दरवाजा ख अपनो पीछू बन्द कर क् उन्को सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“हे मोरो भाऊवों, मय तुम्हरो सी बिनती करू हय, असी बुरी बात मत करो। ");
INSERT INTO lbm_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","देखो, मोरी दोय बेटियां हंय जो अब तक कुंवारी हंय, मोख उन्ख तुम्हरो जवर लावन देवो, अऊर तुम जसो चाहवय हय वसोच उन्को संग व्यवहार करो : लेकिन इन लोगों लायी कुछ भी मत करो; हि मोरो घर म मिजवान हय, अऊर मोख इन की मदत करनो हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","उन्न कह्यो, “हट जा!” तब हि कहन लग्यो, “तय एक परदेशी होय क यहां रहन लायी आयो पर अब तय सच्चो भी बन बैठ्यो हय; येकोलायी अब हम उन्को सी भी जादा तोरो संग बुरो व्यवहार करबो।” अऊर उन्न लूत ख पीछू ढकल दियो अऊर दरवाजा तोड़न लायी जवर आयो। ");
INSERT INTO lbm_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","तब उन दूतों न हाथ बढ़ाय क लूत ख अपनो जवर घर म खीच लियो, अऊर दरवाजा ख बन्द कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","अऊर उन्न का छोटो, का बड़ो, सब आदमियों ख जो घर को दरवाजा पर होतो अन्धा कर दियो, तब हि दरवाजा ख ढूंढतो ढूंढतो थक गयो। ");
INSERT INTO lbm_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","तब दोय दूत न लूत सी कह्यो, “अगर तोरो यहां कोयी अऊर हय? बेटा, बेटियां, जवायी, या नगर म रहन वालो कोयी दूसरो रिश्तेदार, त उन पूरो ख ले क यो जागा सी निकल जा। ");
INSERT INTO lbm_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","कहालीकि हम यो जागा ख नाश करन जाय रह्यो हंय। येकोलायी कि परमेश्वर न इन लोगों को खिलाफ भयानक आरोपों ख सुन्यो हय अऊर हम्ख सदोम ख नाश करन लायी भेज्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","तब लूत घर सी निकल क अपनो जवायियों को जवर गयो, जो ओकी बेटियां सी बिहाव करन वालो होतो, त लूत न उन्को सी कह्यो, “उठो, अऊर यो जागा सी निकल चलो; कहालीकि परमेश्वर यो नगर ख नाश करन वालो हय।” पर लूत को जवायियों न समझ्यो कि ऊ उन्को सी मजाक कर रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","जब सुबेरे भयी तब स्वर्गदूतों न लूत सी जल्दी करन ख कह्यो अऊर बोल्यो, “उठो, अऊर अपनी पत्नी अऊर दोयी बेटियां ख जो यहां हंय इन्क ले क बाहेर निकल जावो : नहीं त तुम भी यो नगर को अधर्म को दण्ड म भस्म होय जावो।” ");
INSERT INTO lbm_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","पर ऊ देर करतो रह्यो, तब स्वर्गदूत न ओको अऊर ओकी पत्नी, अऊर दोयी बेटियों को हाथ पकड़ क उन्ख नगर सी बाहेर लिजायो : कहालीकि परमेश्वर की दया लूत पर होती। ");
INSERT INTO lbm_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","तब स्वर्गदूतों न उन्ख नगर को बाहेर निकाल क, उन्को सी कह्यो, “अपनो जीवन लायी भगो! अऊर पीछू मुड़ क मत देखो, अऊर घाटी म मत रुको। पहाड़ियों पर भगो, नहीं त तुम भी भस्म होय जावो।” ");
INSERT INTO lbm_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","लूत न उन्को सी कह्यो, “हे प्रभु, कृपया असो मत कर! ");
INSERT INTO lbm_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","देख, तोरो दास पर तोरी अनुग्रह की नजर भयी हय, अऊर तय न येको म बड़ी कृपा दिखायी, कि मोरो जीव ख बचायो हय; पर मय पहाड़ी पर भग नहीं सकू, कहीं असो नहीं होय, कि कोयी दुर्घटना मोरो संग होय जाये, अऊर मय मर जाऊं। ");
INSERT INTO lbm_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","देख, ऊ नगर असो जवर हय कि मय उत भग सकू हय, अऊर ऊ छोटो भी हय। मोख उतच भग जान दे, का ऊ नगर छोटो नहाय? अऊर मोरो जीव बच जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","स्वर्गदूत न लूत सी कह्यो, “देख, मय न यो बारे म भी तोरी बिनती स्वीकार करी हय, कि जो नगर की चर्चा तय न करी हय, ओख मय नाश नहीं करूं। ");
INSERT INTO lbm_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","फुर्ती सी उत भग जा; कहालीकि जब तक तय उत नहीं पहुंच जाजो तब तक मय कुछ नहीं कर सकूं।” योच वजह ऊ नगर को नाम सोअर पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","जब लूत सोअर नगर को जवर पहुंच्यो, तब धरती पर सूरज उदय भयो। ");
INSERT INTO lbm_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","तब परमेश्वर न अपनो तरफ सी सदोम अऊर अमोरा पर आसमान सी गन्धक अऊर आगी बरसायी; ");
INSERT INTO lbm_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","अऊर ओन उन नगरों अऊर पूरी घाटी ख, अऊर नगरों को सब निवासियों ख, अऊर जमीन की पूरी उपज समेत नाश कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","लूत की पत्नी जो ओको पीछू होती, ओन पीछू मुड़ क देख्यो, अऊर वा नमक को खम्बा बन गयी। ");
INSERT INTO lbm_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","अब्राहम सुबेरे उठ क ऊ जागा पर गयो, जित ऊ पहिले परमेश्वर को जवर खड़ो होतो; ");
INSERT INTO lbm_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ओन सदोम, अमोरा, अऊर ऊ घाटी को पूरो देश को तरफ नजर करी अऊर देख्यो कि धधकती हुयी भट्टी को जसो धुवा जमीन सी निकल क ऊपर जाय रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","अऊर असो भयो कि जब परमेश्वर न ऊ घाटी को नगरों ख नाश करयो, तब ओख अब्राहम की याद आयी, जब ओन उन नगरों ख उलट पुलट कर दियो, जित लूत रहत होतो, तब विनाश को बीच म सी लूत ख ऊ घटना सी बचाय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लूत न सोअर नगर ख छोड़ दियो, अऊर पहाड़ी पर अपनी दोयी बेटी को संग रहन लग्यो; कहालीकि ऊ सोअर म रहन सी डरत होतो; येकोलायी लूत अऊर ओकी दोयी बेटी पहाड़ी पर एक गुफा म रहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","तब बड़ी बेटी न अपनी छोटी बहिन सी कह्यो, “हमरो बाप बूढ्ढा हय, अऊर हमरो सी बिहाव करन लायी पूरी धरती भर म कोयी असो आदमी नहाय जो जगत की रीति रिवाज को अनुसार हमरो जवर आये अऊर हम सन्तान पैदा कर सके। ");
INSERT INTO lbm_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","येकोलायी आव, हम अपनो बाप ख अंगूर रस पिलाय क, ओको संग सोयबो, जेको सी कि हम अपनो बाप को वंश ख बचायो रखबो।” ");
INSERT INTO lbm_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","दोयी बेटी न ऊ रात अपनो बाप ख अंगूर रस पिलायो, अऊर तब बड़ी बेटी जाय क अपनो बाप को संग सोय गयी; पर ओको बाप ख पता नहीं चल्यो, कि वा कब आय क सोयी, अऊर कब उठ क चली गयी। ");
INSERT INTO lbm_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","दूसरो दिन बड़ी बेटी न अपनी छोटी बहिन सी कह्यो, “देख, मय कल रात बाप को संग सोयी होती; येकोलायी अज भी रात ख अपनो बाप ख अंगूर रस पिलायबो; तब तय जाय क ओको संग सोय जाजो, कि हम अपनो बाप को द्वारा वंश पैदा करबो।” ");
INSERT INTO lbm_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","येकोलायी ऊ रात उन्न अपनो बाप ख अंगूर रस पिलायो, अऊर छोटी बेटी जाय क ओको संग सोय गयी; पर ओको बाप ख पता नहीं चल्यो, कि वा कब आय क सोयी, अऊर कब उठ क चली गयी। ");
INSERT INTO lbm_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","यो तरह लूत की दोयी बेटी अपनो बाप सी गर्भवती भयी। ");
INSERT INTO lbm_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","बड़ी बेटी ख एक बेटा पैदा भयो, ओन ओको नाम मोआब रख्यो; ऊ अज तक मोआबी जाति को पूर्वज मान्यो जावय हय। ");
INSERT INTO lbm_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","अऊर छोटी बेटी ख भी एक बेटा पैदा भयो, ओन ओको नाम बेनम्मी रख्यो; ऊ अज तक अम्मोनी जाति को पूर्वज मान्यो जावय हय। ");
INSERT INTO lbm_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","तब अब्राहम उत सी निकल क कनान को दक्षिन देश म आय क कादेश अऊर शूर को बीच म ठहरयो, अऊर गरार नगर म रहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","अऊर अब्राहम न अपनी पत्नी सारा को बारे म कहन लग्यो, “वा मोरी बहिन आय,” येकोलायी गरार नगर को राजा अबीमेलेक न दूत भेज क सारा ख अपनो पास बुलाय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","पर रात ख परमेश्वर न सपनो म अबीमेलेक को जवर आय क कह्यो, “सुन, जो बाई ख तय न रख लियो हय, ओको वजह तय मर जाजो, कहालीकि वा सुहागिन हय।” ");
INSERT INTO lbm_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","पर अबीमेलेक अब तक सारा को जवर नहीं गयो होतो; येकोलायी ओन कह्यो, “हे परमेश्वर, मय निर्दोष हय? का तय मोख अऊर मोरो लोगों ख भी नाश कर देजो? ");
INSERT INTO lbm_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","का अब्राहम न खुद मोरो सी नहीं कह्यो होतो, ‘वा मोरी बहिन आय?’ अऊर वा बाई न भी खुद कह्यो होतो, ‘कि यो मोरो भाऊ आय,’ मय न त अपनो मन की खराई अऊर अपनो व्यवहार की सच्चायी सी यो काम करयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","परमेश्वर न ओको सी सपनो म कह्यो, “हव, मय भी जानु हय कि तय न अपनो मन की खराई सी यो काम करयो हय अऊर मय न तोख रोक क भी रख्यो कि तय मोरो खिलाफ पाप मत करे; योच वजह मय न तोख ओख छूवन नहीं दियो। ");
INSERT INTO lbm_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","येकोलायी तय वा बाई ख ओको पति ख वापस दे दे; कहालीकि ऊ एक भविष्यवक्ता आय, अऊर ऊ तोरो लायी प्रार्थना करेंन, ताकि तय जीन्दो रह्यजो, अगर तय ओख वापस नहीं देवय हंय, त मय तोख चेतावनी देऊ हय कि तय अऊर तोरो नगर को पूरो लोग मर जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","दूसरो दिन अबीमेलेक न सुबेरे जल्दी उठ क अपनो सब अधिकारियों ख बुलाय क यो सब बाते बतायी; अऊर हि लोग बहुत डर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","तब अबीमेलेक अब्राहम ख बुलाय क कह्यो, “तय न हमरो संग यो का करयो हय? अऊर मय न तोरो का बिगाड़्यो होतो कि तय न मोरो अऊर मोरो राज्य को ऊपर असो बड़ो पाप डाल दियो हय? तय न मोरो संग जो व्यवहार करयो हय ऊ तोख नहीं करनो होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","तब अबीमेलेक न अब्राहम सी पुच्छ्यो, “तय न का समझ क असो काम करयो?” ");
INSERT INTO lbm_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहम न कह्यो, “मय न यो सोच्यो होतो कि यो जागा म परमेश्वर को कुछ भी डर नहीं होयेंन; येकोलायी हि लोग मोख मोरी पत्नी को वजह मार डालेंन। ");
INSERT INTO lbm_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","वा वास्तव म सचमुच मोरी बहिन आय, वा मोरो बाप की बेटी त आय, लेकिन मोरी माय की नहीं, तब वा मोरी पत्नी होय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","अऊर असो भयो कि जब परमेश्वर न मोख अपनो बाप को घर छोड़ क निकलन कि आज्ञा दी, तब मय न ओको सी कह्यो, ‘इतनी कृपा तोख मोरो पर करनो होना कि हम दोयी जित जित जाबो उत उत तय मोरो बारे म कह्यजो कि यो मोरो भाऊ आय।’” ");
INSERT INTO lbm_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","अब अबीमेलेक न शेरी मेंढी, गाय बईल, अऊर दास दासी अब्राहम ख भेंट दे दियो, अऊर ओकी पत्नी सारा भी ओख वापस कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","अऊर अबीमेलेक न कह्यो, “देख, मोरो देश तोरो आगु हय; जो जागा तोरी नजर म अच्छी लगे, उत तय रह्य सकय हय।” ");
INSERT INTO lbm_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","अऊर सारा सी अबीमेलेक न कह्यो, “देख, मय न तोरो भाऊ ख एक हजार चांदी को सिक्का दियो हंय। जो लोग तोरो संग हंय, उन सब लोगों की नजर म तय निर्दोष हंय; अऊर सब लोगों ख पता चल जायेंन कि तय न कोयी गलत काम नहीं करयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","तब अब्राहम न परमेश्वर सी प्रार्थना करी, अऊर परमेश्वर न अबीमेलेक, अऊर ओकी पत्नी अऊर दासियों ख चंगो करयो, अऊर हि फिर सी सन्तान पैदा करन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","कहालीकि परमेश्वर न अब्राहम की पत्नी सारा को वजह अबीमेलेक को घर की सब बाईयों की कोखों ख पूरी रीति सी बन्द कर दियो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","परमेश्वर न सारा ख आशीर्वाद दियो, जसो ओन वादा करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","अऊर सारा अब्राहम सी गर्भवती भयी; अऊर जब ऊ बूढ्ढा भय गयो त अब्राहम ख एक बेटा पैदा भयो। बेटा ठहरायो समय पर पैदा भयो होतो जब परमेश्वर न कह्यो होतो कि ऊ पैदा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहम न अपनो ऊ बेटा को नाम जो सारा सी पैदा भयो होतो इसहाक रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","अऊर जब इसहाक आठ दिन को भयो, तब अब्राहम न ओको खतना करयो, जसो परमेश्वर न आज्ञा दियो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","अपनो बेटा इसहाक को जनम को समय अब्राहम सौ साल को होतो। ");
INSERT INTO lbm_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","अऊर सारा न कह्यो, “परमेश्वर न मोख खुशी अऊर हसी दी हंय; येकोलायी जो कोयी येको बारे म सुनय हय ऊ मोरो संग हसेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","तब ओन कह्यो, “अब्राहम सी कौन कह्यो होना, कि सारा बच्चां ख दूध पिलायेंन? तब भी मय न अब्राहम ख ओको बुढ़ापा म बेटा ख जनम दियो।” ");
INSERT INTO lbm_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","अऊर ऊ बच्चा बड़ो भयो, अऊर ओको दूध छुड़ायो गयो; जो दिन इसहाक को दूध छुड़ायो गयो, ऊ दिन अब्राहम न एक बहुत अच्छो जेवन दियो। ");
INSERT INTO lbm_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","एक दिन सारा न मिस्री हाजिरा को बेटा ख, जेक हाजिरा न अब्राहम सी पैदा करयो होतो, सारा न अपनो बेटा इसहाक को संग खेलतो देख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","यो वजह सारा न अब्राहम सी कह्यो, “या दासी ख बेटा सहित निकाल दे : कहालीकि या दासी को बेटा मोरो बेटा इसहाक को संग उत्तराधिकारी नहीं बनेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","अपनो बेटा इश्माएल को सम्बन्ध म असी बात अब्राहम ख बहुत बुरी लगी। ");
INSERT INTO lbm_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तब परमेश्वर न अब्राहम सी कह्यो, “तय बच्चा अऊर अपनी दासी को वजह बुरो मत मान; जो बात सारा तोरो सी कह्य हय, ओख सुन, कहालीकि इसहाक द्वारा तोरो वंशजों म तोरो नाम बन्यो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","मय दासी को बेटा सी एक राष्ट्र पैदा करूं; कहालीकि ऊ तोरी सन्तान हय।” ");
INSERT INTO lbm_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","येकोलायी अब्राहम न सुबेरे जल्दी उठ क रोटी अऊर पानी सी भरी चमड़ा की झोली भी हाजिरा ख दी, अऊर ओख हाजिरा को बख्खा पर रख दियो, अऊर बच्चा सहित ओख बिदा कर दियो, हाजिरा चली गयी, अऊर बेर्शेबा को जंगल म भटकन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","जब झोली को पानी खतम होय गयो, तब ओन बच्चा ख एक झाड़ी को खल्लो छोड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","अऊर लगभग सौ मीटर दूर जाय क बैठ गयी; ओन खुद सी कह्यो, “मय अपनो बच्चा ख मरतो हुयो नहीं देख सकू।” जब वा ओको आगु दूर बैठी तब बच्चा जोर जोर सी रोवन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेश्वर न बच्चा की रोवन की आवाज सुनी; अऊर परमेश्वर को दूत न स्वर्ग सी हाजिरा ख पुकारयो अऊर ओको सी कह्यो, “हे हाजिरा, तोख का भयो हय? मत डर, कहालीकि जित तोरो बच्चा पड़्यो हय उत सी परमेश्वर न ओकी आवाज सुनी हय। ");
INSERT INTO lbm_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","उठ, अऊर अपनो बच्चा ख उठाव अऊर ओख अपनो हाथों म सावधानी सी सम्भाल; कहालीकि मय ओको वंशजों म सी एक महान राष्ट्र बनाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","तब परमेश्वर न ओकी आंखी खोल दी, अऊर ओख एक कुंवा दिखायी दियो; तब वा ओको जवर गयी, अऊर झोली म पानी भर क बच्चा ख पिलायी। ");
INSERT INTO lbm_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","अऊर परमेश्वर बच्चा को जवर होतो; अऊर जब ऊ बड़ो होतो गयो, तब ऊ सुनसान जागा म रह्यतो रह्यतो धनुर्धारी बन गयो। ");
INSERT INTO lbm_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ऊ पारान नाम को जंगल म रहत होतो; अऊर ओकी माय न ओको लायी मिस्र देश सी एक लड़की मंगवायी। ");
INSERT INTO lbm_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","उन दिनों म असो भयो कि अबीमेलेक अपनो सेनापति पीकोल ख संग ले क अब्राहम सी कहन लग्यो, “जो कुछ तय करय हय ऊ काम म परमेश्वर तोरो संग रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","येकोलायी अब मोरो सी इत यो बारे म परमेश्वर की कसम खा कि तय न मोरो सी, अऊर न मोरी सन्तान सी अऊर न मोरो वंश सी छल कपट करजो, पर जसो मय न तोरो संग प्रेम को व्यवहार करयो हय, वसोच तय मोरो पर अऊर यो देश को संग जित तय रह्य हंय, वसोच व्यवहार करजो।” ");
INSERT INTO lbm_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहम न कह्यो, “मय कसम खाऊ हय।” ");
INSERT INTO lbm_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","पर जब अब्राहम न अपनो एक कुंवा को बारे म अबीमेलेक सी शिकायत करी, जेको पर अबीमेलेक को दासों न कब्जा कर लियो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","तब अबीमेलेक न कह्यो, “मय नहीं जानु कि कौन यो काम करयो हय; अऊर तय न भी मोख नहीं बतायो, अऊर मय न अज तक येको बारे म सुन्यो भी नहीं होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","तब अब्राहम न शेरी मेंढी, अऊर गाय बईल अबीमेलेक ख भेंट दियो; अऊर उन दिनों न आपस म वाचा बान्धी। ");
INSERT INTO lbm_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहम न मेंढी को सात बच्चा ख झुण्ड सी अलग रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","तब अबीमेलेक न अब्राहम सी पुच्छ्यो, “इन सात मेंढी को बच्चा ख, जिन्ख तय न अलग रख्यो हय, का मतलब हय?” ");
INSERT INTO lbm_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","अब्राहम न उत्तर दियो, “तय मोरो हाथ सी इन सात मेंढी को बच्चा ख स्वीकार करजो कि तय मोरो गवाह बनजो कि मय नच यो कुंवा खुदवायो होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","उत उन दोयी न कसम खायी, येकोलायी ऊ जागा को नाम बेर्शेबा पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","जब उन्न बेर्शेबा म यो वाचा बान्धी, तब अबीमेलेक अऊर ओको सेनापति पीकोल, उठ क पलिश्तियों को देश म लौट गयो। ");
INSERT INTO lbm_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","तब अब्राहम न बेर्शेबा म झाऊ को एक झाड़ लगायो, अऊर परमेश्वर की आराधना करी। ");
INSERT INTO lbm_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अऊर अब्राहम लम्बो समय तक पलिश्तियों को देश म रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","इन बातों को बाद असो भयो कि परमेश्वर न अब्राहम सी यो कह्य क ओकी परीक्षा ली, “हे अब्राहम!” ओन कह्यो, “का आज्ञा हय।” ");
INSERT INTO lbm_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","परमेश्वर न कह्यो, “अपनो बेटा ख यानेकि अपनो एकलौतो बेटा इसहाक ख, जेको सी तय प्रेम रखय हय, तय ओख ले क मोरिय्याह देश म चली जा, अऊर उत ओख एक पहाड़ी को ऊपर जो मय तोख बताऊं, तय अपनो बेटा ख होमबलि म चढ़ाजो।” ");
INSERT INTO lbm_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","अगलो दिन की सुबेरे अब्राहम न होमबलि लायी कुछ लकड़ी काटी, अऊर अपनो गधा पर कस दी, अऊर इसहाक अऊर दोय सेवकों ख अपनो संग ले गयो। तब उन्न ऊ जागा लायी सुरूवात करी, जेको बारे म परमेश्वर न उन्ख बतायो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तीसरो दिन अब्राहम न आंखी उठाय क ऊ जागा ख दूर सी देख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","अऊर अब्राहम न अपनो सेवकों सी कह्यो, “तुम इतच गधा को जवर रुक्यो रहो; मय अऊर इसहाक आगु जाय क आराधना करबो, तब तुम्हरो जवर वापस आबो।” ");
INSERT INTO lbm_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","तब अब्राहम न अपनो बेटा इसहाक ख होमबलि की लकड़ी चढ़ान लायी कह्यो, अऊर अपनो हाथ म आगी अऊर छुरी लियो; अऊर हि दोयी एक संग चल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाक न अपनो बाप अब्राहम सी कह्यो, “हे मोरो बाप,” अब्राहम न कह्यो, “हे मोरो बेटा, का बात हय?” इसहाक न कह्यो, “देख, आगी अऊर लकड़ी त हंय; पर होमबलि लायी मेंढी को बच्चा कित हय?” ");
INSERT INTO lbm_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहम न उत्तर दियो, “हे मोरो बेटा, परमेश्वर खुद होमबलि लायी मेम्ना को इंतजाम करेंन।” अऊर हि दोयी संग संग आगु चलतो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","जब हि ऊ जागा पर पहुंच्यो, जेको बारे म परमेश्वर न अब्राहम सी कह्यो होतो; तब उत अब्राहम न वेदी बनाय क लकड़ी ख बिन बिन क रख्यो, अऊर अपनो बेटा इसहाक ख बान्ध क वेदी पर रखी लकड़ियों को ऊपर रख दियो। ");
INSERT INTO lbm_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","तब अब्राहम न अपनो बेटा ख बलि करन लायी हाथ बढ़ाय क छुरी उठायो। ");
INSERT INTO lbm_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","तब यहोवा को दूत न स्वर्ग सी ओख पुकार क कह्यो, “हे अब्राहम, हे अब्राहम!” ओन उत्तर दियो, “का आज्ञा हय।” ");
INSERT INTO lbm_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","दूत न कह्यो, “ऊ बच्चा को तरफ अपनो हाथ मत बढ़ा अऊर ओख कुछ हानि मत पहुंचाव, अब मय जान गयो हय कि तय परमेश्वर को सम्मान करय हय अऊर ओको पालन करय हय, कहालीकि तय न अपनो एकलौतो बेटा ख नहीं रख छोड़्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","तब अब्राहम न अपनी आंखी ऊपर ऊठायी, तब देख्यो, कि ओको पीछू एक मेंढा हय, ऊ अपनो सींगो सी एक झाड़ी म फस्यो हुयो हय; तब अब्राहम गयो, अऊर ऊ मेंढा ख पकड़्यो अऊर अपनो बेटा की जागा पर ओकी होमबलि कर क् चढ़ायो। ");
INSERT INTO lbm_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","अब्राहम न ऊ जागा को नाम “यहोवा इंतजाम करय हय, रख्यो।” येकोलायी अज तक लोग यो भी कह्य हंय, “यहोवा की पहाड़ी पर इंतजाम करयो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","तब यहोवा को दूत न दूसरी बार स्वर्ग सी अब्राहम ख पुकार क कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“यहोवा अपनीच कसम खाय क कह्य हय, कि तय न यो काम करयो हय; कहालीकि तय न मोरो लायी अपनो बेटा, यानेकि अपनो एकलौतो बेटा ख भी नहीं रख छोड़्यो; ");
INSERT INTO lbm_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","यो वजह मय जरूर तोख आशीष देऊं, अऊर तोरो वंश ख आसमान को तारों, अऊर समुन्दर किनार को बहुत रेतु को जसो अनगिनत करूं, अऊर तोरो वंश अपनो दुश्मनों को नगरों को अधिकारी होयेंन; ");
INSERT INTO lbm_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","अऊर धरती को पूरो राष्ट्र तोरो वंश को द्वारा मोरो सी आशीष हासिल करेंन : कहालीकि तय न मोरी आज्ञा सुन क ओको पालन करयो।” ");
INSERT INTO lbm_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","येको बाद अब्राहम अपनो सेवकों को जवर वापस आयो, अऊर हि सब उठ क ओको संग बेर्शेबा गयो, अऊर अब्राहम बेर्शेबा म रहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","कुछ समय को बाद, अब्राहम ख यो बतायो गयो, “मिल्का भी माय बन गयी हय; ओन तोरो भाऊ नाहोर लायी आठ बेटा ख जनम दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","बड़ो बेटा ऊस, अऊर ऊस को भाऊ बूज, अऊर कमूएल, जो आराम को बाप भयो। ");
INSERT INTO lbm_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","तब केसेद, हजो, पिल्दाश, यिद्लाप, अऊर बतूएल। ");
INSERT INTO lbm_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","इन आठ बेटां ख मिल्का न अब्राहम को भाऊ नाहोर को द्वारा जनम दियो। अऊर बतूएल सी रिबका पैदा भयी। ");
INSERT INTO lbm_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","तब नाहोर की रूमा नाम की एक रखैल भी होती; जेको सी तेबह, गहम, तहश, अऊर माका, पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा एक सौ सत्ताईस साल की भयी; ");
INSERT INTO lbm_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","तब सारा की मृत्यु किर्यतर्बा यानेकि हेब्रोन नगर म भयी। जो कनान देश म हय। तब अब्राहम न सारा की मृत्यु लायी शोक मनायो। ");
INSERT INTO lbm_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","तब अब्राहम न अपनी पत्नी को शव को जवर सी उठ क हित्तियों सी कह्यो; ");
INSERT INTO lbm_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“मय त तुम्हरो बीच एक परदेशी अऊर अजनबी हय; मोख मरघट लायी अपनो इत जमीन देवो ताकि मय अपनी पत्नी को शव ख गाड़ सकूं।” ");
INSERT INTO lbm_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हित्तियों को सन्तानों न अब्राहम सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“श्रीमान, तय हमरी बात सुन। तय हमरो बीच म बड़ो प्रधान हंय। तय जित चाहवय अपनी पत्नी ख हमरो अच्छो कब्र म गाड़ सकय हंय। हम म सी कोयी भी तोख अपनी पत्नी ख गाड़न लायी अपनो कब्र देन सी मना नहीं करेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","तब अब्राहम उठ्यो अऊर ऊ देश को लोगों ख यानेकि हित्तियों ख झुक क नमस्कार करयो, ");
INSERT INTO lbm_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","अऊर अब्राहम न उन्को सी कह्यो, “यदि तुम चाहवय हंय कि मय अपनी पत्नी ख माटी देऊं, तब मोरी एक बात अऊर मान लेवो अऊर तुम सोहर को बेटा एप्रोन सी मोरो लायी बिनती करो, ");
INSERT INTO lbm_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ताकि ऊ मकपेला की गुफा ख, जो ओकी जमीन की सीमा पर हय; ओको पूरो दाम ले क मोख बेच दे, ताकि ऊ तुम्हरो बीच म हमरो लायी एक मरघट की जागा हो।” ");
INSERT INTO lbm_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एप्रोन त हित्तियों को बीच उत बैठ्यो हुयो होतो, येकोलायी जितनो हित्ति ओको नगर को फाटक सी होय क अन्दर जात होतो, उन पूरो को आगु एप्रोन न अब्राहम सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“हे मोरो स्वामी; मोरी बात सुनो; मय तोख ऊ गुफा जमीन सहित मोरो लोगों को आगु दे रह्यो हय; तय येको म अपनी पत्नी ख गाड़ दे।” ");
INSERT INTO lbm_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","तब अब्राहम न फिर सी हित्तियों को आगु झुक क नमस्कार करयो। ");
INSERT INTO lbm_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","अऊर ऊ उन्को सुनतो हुयो एप्रोन सी कह्यो, “यदि तय असो चाहे, त मोरी सुन ऊ जमीन को जो दाम हो, ऊ मय देनो चाहऊ हय; ओख मोरो सी ले ले, तब मय अपनी पत्नी को शव ख उत गाड़ सकूं।” ");
INSERT INTO lbm_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एप्रोन न अब्राहम ख यो उत्तर दियो, ");
INSERT INTO lbm_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे मोरो स्वामी, मोरी बात सुन; ऊ जमीन को दाम त चार सौ चांदी को सिक्का हय; पर ऊ मोरो अऊर तोरो बीच म का हय? तय अपनी पत्नी ख गाड़ दे।” ");
INSERT INTO lbm_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहम न एप्रोन की बात मान क ओख उतनो रूप्या की चांदी तौल क दे दियो, जितनो ओन हित्तियों को सुनतो म कह्यो होतो : चार सौ चांदी को सिक्का जो ऊ समय व्यापारियों को बीच म चलत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","येकोलायी एप्रोन को ऊ जमीन अऊर गुफा, जो मकपेला म मम्रे को जवर होतो, अऊर जमीन को पूरो झाड़ जो ओको म अऊर ओको चारयी तरफ सीमा को अन्दर होतो, ");
INSERT INTO lbm_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","सब अब्राहम ख दे दियो, जितनो हित्तियों नगर की फाटक पर जमा भयो होतो, उन पूरो को आगु वा सम्पत्ति अब्राहम को अधिकार म पक्की रीति सी आय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ओको बाद अब्राहम न अपनी पत्नी सारा ख मकपेला को जमीन की गुफा म गाड़ दियो, जो कनान देश को मम्रे मतलब हेब्रोन नगर म होतो। ");
INSERT INTO lbm_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","यो तरह हित्तियों को द्वारा ऊ जमीन अऊर ओको म की गुफा मरघट को रूप म अब्राहम को अधिकार म दे दी गयी। ");
INSERT INTO lbm_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहम अब बहुत बूढ्ढा भय गयो होतो, अऊर ओकी उमर बहुत होती अऊर यहोवा न ओख हर काम म आशीर्वाद दियो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","एक दिन अब्राहम न अपनो घर को सब सी बूढ्ढा अऊर अपनी सम्पत्ति की देखभाल करन वालो सेवक सी कह्यो, “अपनो हाथ मोरी जांघ पर रख; ");
INSERT INTO lbm_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","मय तोख स्वर्ग अऊर धरती को परमेश्वर यहोवा की कसम खिलाऊ हय कि तय मोरो बेटा लायी कनानी जाति की टुरियों म सी, जिन्को बीच हम रह्य रह्यो हय, मोरो बेटा को बिहाव नहीं करावो। ");
INSERT INTO lbm_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","पर तय मोरो देश म मोरो रिश्तेदारों म सी मोरो बेटा इसहाक लायी पत्नी लावो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ऊ सेवक न अब्राहम सी कह्यो, “ऊ स्थिति म मय का करूं, जब वा बाई यो देश म आनोच नहीं चाहे; का मय तोरो बेटा ख ऊ देश म ले जाऊं, जित सी तय आयो हंय?” ");
INSERT INTO lbm_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","तब अब्राहम न कह्यो, “सावधान, तय मोरो बेटा ख उत कभी नहीं ले जाजो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","यहोवा, जो स्वर्ग को परमेश्वर हंय, जो मोख मोरो बाप को परिवार अऊर मोरी जन्मभूमि सी लायो हय अऊर जिन्न कसम खाय क मोरो सी यो वादा करयो, “मय यो देश तोरो वंश ख देऊं; उच स्वर्गदूत ख तोरो आगु आगु भेजेंन, अऊर तय मोरो बेटा लायी उत सी एक बाई ले आये। ");
INSERT INTO lbm_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","अगर बाई तोरो संग आन लायी मना करे, तब तय मोरी यो कसम सी छूट जाजो; लेकिन ध्यान रखजो कि तय मोरो बेटा ख वापस उत मत ले जाजो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","येकोलायी ऊ सेवक न अपनो स्वामी अब्राहम की जांघ पर अपनो हाथ रख क अब्राहम सी यो बारे म कसम खायी। ");
INSERT INTO lbm_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","तब ऊ सेवक न अपनो स्वामी को ऊंट को झुण्ड म सी दस ऊंटों ख लियो अऊर उन पर अपनो स्वामी को तरफ सी अलग अलग उपहार पकड़्यो अऊर नाहोर को नगर ख चली गयो जो उत्तरी मेशोपोटामियां देश म होतो। ");
INSERT INTO lbm_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","नगर को जवर पहुंच क ओन ऊंटों ख कुंवा को जवर बैठाय दियो; यो शाम को समय होतो। योच समय बाईयां पानी भरन बाहेर आयो करत होती। ");
INSERT INTO lbm_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","तब सेवक न प्रार्थना करी, “यहोवा, मोरो स्वामी अब्राहम को परमेश्वर, अज मोरो काम ख सफल कर, अऊर मोरो स्वामी अब्राहम पर दया कर। ");
INSERT INTO lbm_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","तय देख रह्यो हय कि मय यो पानी को कुंवा को जवर खड़ो हय, अऊर यो नगर को निवासियों की टुरियां पानी भरन लायी निकल क आय रही हंय। ");
INSERT INTO lbm_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","तय कुछ असो कर कि जो टुरी सी मय यो कहूं, ‘अपनो घड़ा झुकाय क कृपया मोख पानी पिलाय दे,’ अऊर वा टुरी कहे, ‘तय पानी पी ले, अऊर फिर मय तोरो ऊंटों ख भी पानी पिलाय देऊं,’ या वाच टुरी हो जेक तय न अपनो सेवक इसहाक लायी चुन्यो हय; येको द्वारा मोख यो विश्वास होय जायेंन कि तय न मोरो स्वामी पर अपनी दया दिखायी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","अऊर असो भयो कि जब प्रार्थना करच रह्यो होतो, तबच रिबका नगर को बाहेर अपनो बख्खा पर घड़ा ले क पानी भरन आयी। वा मिल्का को बेटा बतूएल की टुरी होती अऊर मिल्का अब्राहम को भाऊ नाहोर की पत्नी होती। ");
INSERT INTO lbm_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","रिबका बहुत सुन्दर होती, वा कुंवारी होती; अब तक कोयी आदमी सी ओको बिहाव नहीं भयो होतो। वा खल्लो कुंवा म उतरी, अऊर अपनो घड़ा पानी सी भरी अऊर तब ऊपर आय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","सेवक दौड़ क ओको जवर आयो, अऊर ओको सी कह्यो, “कृपया अपनो घड़ा सी मोख थोड़ो पानी पिलाय देवो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","रिबका न कह्यो, “हे मोरो स्वामी लेवो, पी लेवो,” अऊर ओन तुरतच घड़ा ख खल्लो कर क् ओख पानी पिलायो। ");
INSERT INTO lbm_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","जब रिबका न सेवक ख पानी दियो, तब ओन ओको सी कह्यो, “मय तोरो ऊंटों लायी भी पानी ले क आऊ हय, जब तक हि पूरो सन्तुष्ट नहीं होय जाये।” ");
INSERT INTO lbm_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ओन जल्दी सी घड़ा को पानी जनावरों की डोंगी म खाली कर दियो, फिर वापस कुंवा पर अऊर पानी भरन गयी; अऊर ओको पूरो ऊंटों लायी उन्को लायक पानी ले आयी। ");
INSERT INTO lbm_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","जब यो सब होय रह्यो होतो, तब सेवक ध्यान सी रिबका ख देख रह्यो होतो अऊर सोच रह्यो होतो कि यहोवा न मोरी यात्रा ख सफल करयो हय या नहीं। ");
INSERT INTO lbm_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","जब ऊंटों न पानी पी लियो, तब सेवक न अरधो तोला की सोनो कि एक नथ निकाल क ओख दियो, अऊर दस तोला सोनो को कंगन ओको हाथों म पहिनाय दियो; ");
INSERT INTO lbm_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","अऊर रिबका ख दे क ओको सी पुच्छ्यो, “कृपया, मोख बता, तय कौन्की बेटी आय? का तोरो बाप को घर म हमरो रूकन लायी जागा हय?” ");
INSERT INTO lbm_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","रिबका न उत्तर दियो, “मय त नाहोर तथा मिल्का को बेटा बतूएल की बेटी आय।” ");
INSERT INTO lbm_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","अऊर ओन यो भी कह्यो, “हमरो इत घास अऊर चारा बहुत हय, अऊर रूकन लायी जागा भी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तब ऊ सेवक न झुक क अऊर यो कह्य क यहोवा की आराधना करी, ");
INSERT INTO lbm_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“धन्य हय यहोवा, मोरो स्वामी अब्राहम को परमेश्वर, जिन्न मोरो स्वामी को प्रति अपनो प्रेम अऊर करुना ख नहीं हटायो : यहोवा मोख सही जागा पर लायो जो मोरो स्वामी को रिश्तेदारों कोच घर हय।” ");
INSERT INTO lbm_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तब रिबका दौड़ क घर गयी अऊर अपनी माय को घर को लोगों ख सब बाते बतायी। ");
INSERT INTO lbm_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रिबका को भाऊ लाबान दौड़ क कुंवा को जवर गयो, जित अब्राहम को सेवक होतो। ");
INSERT INTO lbm_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","जब लाबान न नथ अऊर अपनी बहिन रिबका को हाथों म कंगन देख्यो अऊर जो बात सेवक न कही होती, ओख सुन्यो, तब लाबान ऊ सेवक को जवर गयो, अऊर देख्यो कि ऊ सेवक कुंवा को जवर ऊंटों को बाजू म खड़ो हय। ");
INSERT INTO lbm_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","लाबान न सेवक सी कह्यो, “हे यहोवा को तरफ सी धन्य आदमी अन्दर आव तय कहाली बाहेर खड़ो हय? मय न तोरो लायी, घर अऊर तोरो ऊंटों लायी भी जागा तैयार करी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","अब्राहम को सेवक लाबान को संग घर म गयो; तब लाबान न ऊंटों पर सी सामान उतारयो, अऊर ऊंटों लायी पैरा अऊर चारा लायो; तब ओन सेवक अऊर ओको लोगों को पाय धोवन लायी पानी दियो। ");
INSERT INTO lbm_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","तब सेवक ख जेवन दियो, पर ओन कह्यो, “मय तब तक जेवन नहीं करूं, जब तक कि मय अपनी बात नहीं सुनाय देऊं।” लाबान न कह्यो, “ठीक हय, बताय दे।” ");
INSERT INTO lbm_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“तब ओन कह्यो, मय अब्राहम को सेवक आय।” ");
INSERT INTO lbm_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","यहोवा न मोरो स्वामी ख बहुत आशीष दी हंय, जेको सी ऊ धनवान भय गयो हंय; यहोवा न उन्ख बहुत शेरी-मेंढी, गाय-बईल, सोनो-चांदी, सेवक-सेविका, तथा ऊंट अऊर गधा दियो हंय। ");
INSERT INTO lbm_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","अऊर मोरो स्वामी की पत्नी सारा ख बुढ़ापा म एक बेटा पैदा भयो, अऊर ऊ बेटा ख अब्राहम न अपनो सब कुछ दे दियो हय। ");
INSERT INTO lbm_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","अऊर मोरो स्वामी न मोख कसम खिलायी हय। कि तय मोरो बेटा लायी कनानियों की टुरियों म सी जिन्को देश म मय रहू हय, कोयी पत्नी नहीं ले आऊं। ");
INSERT INTO lbm_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","पर तय मोरो बाप को परिवार, मोरो अपनो वंश म जाजो, अऊर मोरो बेटा लायी एक पत्नी लाजो। ");
INSERT INTO lbm_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","तब मय न अपनो स्वामी सी पुच्छ्यो, यदि वा बाई मोरो संग आनो नहीं चाहेंन तब का? ");
INSERT INTO lbm_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“मोरो स्वामी न कह्यो, ‘यहोवा, जेकी मय न हमेशा आज्ञा मानी हय, ऊ अपनो स्वर्गदूत ख तोरो संग भेजेंन अऊर तोरी यात्रा ख सफल करेंन, ताकि तय मोरो बेटा लायी मोरो अपनो वंश अऊर मोरो बाप को परिवार सी एक पत्नी लाय सकजो। ");
INSERT INTO lbm_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","तय मोरी या कसम सी तबच छूट पायजो, जब तय मोरो वंश को लोगों को जवर जाजो, अऊर यदि हि वा बाई ख तोरो संग भेजन लायी मना करे तब तय मोरी कसम सी छूट जाजो।’ ");
INSERT INTO lbm_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“येकोलायी मय अज जब कुंवा को जवर पहुंच्यो, त मय न यो प्रार्थना करी, ‘यहोवा, मोरो स्वामी अब्राहम को परमेश्वर, मय जो लक्ष सी इत आयो हय, ऊ काम पूरो होय जाये; ");
INSERT INTO lbm_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","त देख, मय यो कुंवा को किनारे खड़ो हय; यदि कोयी बाई निकल क पानी भरन आवय हय, अऊर मय ओको सी कहूं, “अपनो घड़ा म सी मोख थोड़ो पानी दे,” ");
INSERT INTO lbm_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","अऊर यदि वा मोरो सी कहे, “पी ले, अऊर मय तोरो ऊंटों लायी भी पानी ले क आऊ हय,” त वा वाच बाई हो, जेक परमेश्वर न मोरो स्वामी को बेटा लायी चुन्यो हय।’ ");
INSERT INTO lbm_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","येको पहिले कि मय अपनो मन म यो प्रार्थना खतम करतो, त रिबका अपनो कन्धा पर घड़ा धर क निकल आयी; तब वा खल्लो कुंवा को जवर जाय क पानी भरन लगी, अऊर मय न ओको सी कह्यो, ‘कृपया मोख पानी पिलाय दे।’ ");
INSERT INTO lbm_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","तब ओन तुरतच अपनो कन्धा पर सी घड़ा ख झुकाय क कह्यो, ‘ले, पी ले, अऊर तब मय तोरो ऊंटों ख भी पानी पिलाय देऊं,’ तब मय न पानी पियो, अऊर ओन ऊंटों ख भी पानी पिलाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","तब मय न ओको सी पुच्छ्यो, ‘तय कौन्की टुरी आय?’ ओन कह्यो, ‘मय बतूएल की टुरी आय, जो नाहोर तथा मिल्का को बेटा आय,’ तब मय न ओकी नाक म नथ, अऊर ओको हाथों म कंगन पहिनाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","तब मय न झुक क यहोवा की आराधना करी, मय न अपनो स्वामी अब्राहम को परमेश्वर यहोवा की महिमा करी, कहालीकि ओन मोख सही रस्ता म अगुवायी करी, ताकि मय अपनो स्वामी को टुरा लायी रिश्तेदार की टुरी ख ले जाऊं। ");
INSERT INTO lbm_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","येकोलायी अब, यदि तुम मोरो स्वामी को प्रति दया अऊर सच्चायी दिखानो चाहवय हय, त मोख बतावो; अऊर यदि नहीं चाहवय हय, तब भी मोरो सी कह्य देवो; ताकि मय जान सकूं कि मोख का करनो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","यो सब सुन क लाबान अऊर बतूएल न उत्तर दियो, “यो बात यहोवा को तरफ सी भयी हय; येकोलायी हम लोग तोरो सी भलो या बुरो कुछ नहीं कह्य सकजे। ");
INSERT INTO lbm_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","देख, रिबका तोरो आगु हय; येख अपनो संग ले जा, ताकि वा तोरो स्वामी को बेटा की पत्नी होय जाये, जसो की यहोवा न निर्देश दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","उन्की बात सुन क, अब्राहम को सेवक न जमीन पर झुक क यहोवा ख बड़ायी करी। ");
INSERT INTO lbm_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","तब सेवक न सोनो अऊर चांदी को जेवर, अऊर कपड़ा निकाल क रिबका ख दियो; ओन रिबका को भाऊ अऊर ओकी माय ख भी बहुत अनमोल चिजे दी। ");
INSERT INTO lbm_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","तब ओन अऊर ओको संग को लोगों न खायो पीयो अऊर उत रात बितायी। अगलो दिन सुबेरे जब हि सोय क उठ्यो त सेवक न कह्यो, “मोख अपनो स्वामी को जवर वापस जान लायी बिदा करो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","पर रिबका को भाऊ अऊर ओकी माय न कह्यो, “टुरी ख हमरो संग कुछ दिन मतलब कम सी कम दस दिन रहन देवो; तब ओख ले जावो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","पर सेवक न उन्को सी कह्यो, “मोख मत रोको; कहालीकि परमेश्वर न मोरी यो यात्रा ख सफल करयो हय; मोख अपनो स्वामी को जवर वापस जान लायी बिदा करो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","तब उन्न कह्यो, “हम रिबका ख बुलाय क येको बारे म ओको सी पूछबो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","तब उन्न रिबका ख बुलाय क ओको सी पुच्छ्यो, “का तय यो आदमी को संग जाजो?” ओन कह्यो, “हव, मय जाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","येकोलायी उन्न अपनी बहन रिबका ख ओकी दासी अऊर अब्राहम को सेवक अऊर ओको लोगों को संग बिदा करयो। ");
INSERT INTO lbm_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","अऊर उन्न रिबका ख आशीर्वाद दे क कह्यो, “हे हमरी बहिन, तय हजारों लाखों की आदिमाता हो, अऊर तोरो वंश अपनो दुश्मनों को नगरों पर अधिकार हो।” ");
INSERT INTO lbm_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","तब रिबका अपनी सहेलियों समेत चली; अऊर ऊंट पर चढ़ क ऊ आदमी को संग गयी। यो तरह ऊ सेवक रिबका ख संग ले क चल्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इसहाक जो कनान को दक्षिन देश म रहत होतो, लहैरोई नाम को कुंवा को जवर सी निर्जन प्रदेश म आवत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","शाम को समय ऊ मैदान म ध्यान करन लायी निकल्यो होतो; अऊर ओन आंखी ऊपर उठायी त देख्यो, कि ऊंट चल क आय रह्यो हंय। ");
INSERT INTO lbm_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबका न भी आंखी उठाय क इसहाक ख देख्यो, अऊर अपनो ऊंट पर सी उतर पड़ी। ");
INSERT INTO lbm_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","तब ओन सेवक सी पुच्छ्यो, “ऊ आदमी कौन आय जो हम सी मुलाखात करन लायी मैदान सी आय रह्यो हय?” सेवक न कह्यो, “ऊ त मोरो स्वामी आय।” तब रिबका न घूंघट सी अपनो मुंह ख झाक लियो। ");
INSERT INTO lbm_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","सेवक न इसहाक सी अपनो संग हुयी घटना को वर्नन करयो। ");
INSERT INTO lbm_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","तब इसहाक रिबका ख अपनी माय सारा को तम्बू म लायो, जेको म ओकी माय रहत होती, अऊर ओको संग बिहाव कर क् ओको सी प्रेम करयो। यो तरह इसहाक ख माय को मरन को बाद शान्ति मिली। ");
INSERT INTO lbm_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","तब अब्राहम न एक अऊर बाई सी बिहाव करयो जेको नाम कतूरा होतो। ");
INSERT INTO lbm_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ओन जिम्रान, योक्षान, मदना, मिद्यान, यिशबाक, अऊर शूह पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान सी शबा अऊर ददान पैदा भयो; अऊर ददान को वंश म अश्शूरी, लतूशी, अऊर लुम्मी लोग भयो। ");
INSERT INTO lbm_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यान को बेटा एपा, एपेर, हनोक, अबीदा, अऊर एल्दा भयो, हि सब कतूरा की सन्तान भयो। ");
INSERT INTO lbm_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","इसहाक ख त अब्राहम न अपनो सब कुछ दियो ");
INSERT INTO lbm_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","पर अपनी रखेलियों सी पैदा भयो बेटा ख केवल उपहार दे क अपनो जीतो जी अपनो बेटा इसहाक को जवर सी पूर्व देश म भेज दियो। ");
INSERT INTO lbm_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","तब अब्राहम की पूरी उमर एक सौ पचहत्तर साल की भयी ");
INSERT INTO lbm_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","अब्राहम की लम्बी उमर म पूरो बुढ़ापा की स्थिति तक जीव छूट गयो; अऊर ऊ अपनो मरयो हुयो पूर्वजों म जाय क मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ओको बेटा इसहाक अऊर इश्माएल न, ओख मम्रे की पूर्व दिशा म मकपेला को गुफा म माटी दी, जो हित्ती सोहर को बेटा एप्रोन की जमीन म होती; ");
INSERT INTO lbm_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","या वाच जमीन आय, जेक अब्राहम न हित्तियों सी मोल ले लियो होतो; ओको म अब्राहम, अऊर ओकी पत्नी सारा, दोयी ख माटी दी गयी। ");
INSERT INTO lbm_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहम को मरन को बाद परमेश्वर न ओको बेटा इसहाक ख आशीष दी, जो लहैरोई नाम को कुंवा को जवर रहत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","अब्राहम को बेटा इश्माएल जो सारा की मिस्री दासी हाजिरा सी पैदा भयो होतो, ओकी वंशावली यो तरह हय। ");
INSERT INTO lbm_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्माएल को बेटावों को नाम यो तरह हय : इश्माएल को बड़ो बेटा नबायोत, फिर केदार, अद्बेल, मिबसाम, ");
INSERT INTO lbm_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दूमा, मस्सा, ");
INSERT INTO lbm_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश, अऊर केदमा। ");
INSERT INTO lbm_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इश्माएल को बेटा हिच भयो, अऊर इन्कोच नामो को अनुसार इन्को गांवो, अऊर छावनियों को नाम भी पड़्यो; अऊर हिच बारा अपनो अपनो कुल को प्रधान भयो। ");
INSERT INTO lbm_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएल की पूरी उमर एक सौ सैंतीस साल को हुयो; तब ऊ मर गयो, अऊर ऊ अपनो मरयो हुयो पूर्वजों म जाय क मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","अऊर ओको वंश हवीला सी शूर तक, जो मिस्र देश को पूर्व म अश्शूर की रस्ता म हंय, बस गयो; अऊर उन्को भाग उन्को सब भाऊ-बन्धुवों को जवर पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहम को टुरा इसहाक की वंशावली यो आय : अब्राहम सी इसहाक पैदा भयो; ");
INSERT INTO lbm_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","अऊर इसहाक न चालीस साल को होय क रिबका सी, जो पद्दनराम को वासी, बतूएल की टुरी अऊर अरामी लाबान की बहिन होती, बिहाव कर लियो। ");
INSERT INTO lbm_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाक की पत्नी रिबका बांझ होती, येकोलायी ओन रिबका लायी परमेश्वर सी बिनती करी; अऊर परमेश्वर न ओकी प्रार्थना सुनी, यो तरह ओकी पत्नी गर्भवती भयी। ");
INSERT INTO lbm_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ओको गर्भ म बच्चा आपस म लिपट क एक दूसरो ख मारन लग्यो। तब रिबका न कह्यो, “मोरी जो असीच दशा रहेंन त मय कसी जीन्दी रहूं?” अऊर वा यहोवा की इच्छा पूछन ख गयी। ");
INSERT INTO lbm_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","तब परमेश्वर न रिबका सी कह्यो, “तोरो गर्भ म दोय जातियां हंय, अऊर तोरी कोख सी निकल क दोय राज्य को लोग अलग अलग होयेंन, अऊर एक राज्य को लोग दूसरो सी शक्तिशाली होयेंन, अऊर बड़ो बेटा छोटो की सेवा करेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","जब रिबका को जनम देन को समय आयो, तब मालूम भयो कि रिबका को गर्भ म जुड़वा बच्चा हंय। ");
INSERT INTO lbm_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पहिलो जो बच्चा पैदा भयो ऊ लाल निकल्यो, अऊर ओको पूरो शरीर बालों सी भरयो होतो; येकोलायी ओको नाम एसाव रख्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","तब ओको पीछू ओको भाऊ अपनो हाथ सी एसाव की एड़ी पकड़्यो हुयो पैदा भयो; अऊर ओको नाम याकूब रख्यो गयो। जब रिबका न उन्ख जनम दियो तब इसहाक साठ साल को होतो। ");
INSERT INTO lbm_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","तब हि टुरा बढ़न लग्यो, अऊर एसाव त जंगल म रहन वालो चतुर शिकारी होय गयो, पर याकूब सीधो आदमी होतो अऊर तम्बुवों म रहत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाक एसाव द्वारा लायो शिकार को मांस खातो रहत होतो, येकोलायी ऊ ओको सी प्रेम रखत होतो; पर रिबका याकूब सी प्रेम रखत होती। ");
INSERT INTO lbm_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एक दिन याकूब जेवन लायी कुछ दार पकात होतो; अऊर एसाव जंगल सी थक्यो हुयो आयो। ");
INSERT INTO lbm_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","तब एसाव न याकूब सी कह्यो, “ऊ जो लाल चीज हय, उच लाल चीज म सी मोख कुछ खिल्ला, कहालीकि मय थक्यो हय।” योच वजह ओको नाम एदोम भी पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकूब न कह्यो, “अपनो बड़ो होन को अधिकार अज मोरो हाथ बेच दे।” ");
INSERT INTO lbm_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव न कह्यो, “देख, मय त अभी मरन पर हय : येकोलायी यो अधिकार सी मोरो का भलो होयेंन?” ");
INSERT INTO lbm_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याकूब न कह्यो, “मोरो सी अभी कसम खा,” येकोलायी एसाव न ओको सी कसम खायी, अऊर अपनो बड़ो होन को अधिकार याकूब को हाथ बेच डाल्यो ");
INSERT INTO lbm_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तब याकूब न एसाव ख रोटी अऊर पकायी हुयी मसूर की दार दी; अऊर ओन खायो पियो, अऊर उठ क चली गयो। यो तरह एसाव न अपनो बड़ो होन को अधिकार ख बेकार जान्यो। ");
INSERT INTO lbm_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ऊ देश म अकाल पड़्यो, यो ऊ पहिलो अकाल सी अलग होतो जो अब्राहम को दिनों म पड़्यो होतो। येकोलायी इसहाक पलिश्ती जाति को राजा अबीमेलेक को जवर गरार नगर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","परमेश्वर न इसहाक ख दर्शन दे क कह्यो, “मिस्र देश मत जा; जो देश को बारे म मय तोरो सी कहूं, ओको म रह्य। ");
INSERT INTO lbm_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","तय उच देश म रह्य, अऊर मय तोरो संग रहूं, अऊर तोख आशीष देऊं; मय तोख, अऊर तोरो वंश ख यो सब देश प्रदान करूं; जो कसम मय न तोरो बाप अब्राहम सी खायी होती, ओख मय पूरी करूं। ");
INSERT INTO lbm_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","अऊर मय तोरो वंश ख आसमान को तारों को जसो करूं; अऊर मय तोरो वंश ख यो सब देश देऊं, अऊर धरती की पूरी जातियां तोरो वंश को वजह अपनो आप ख धन्य मानेंन। ");
INSERT INTO lbm_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","कहालीकि अब्राहम न मोरी बात मानी, अऊर जो मय न ओख सौंप्यो होतो ओख अऊर मोरी आज्ञावों, विधियों अऊर व्यवस्था को पालन करयो।” ");
INSERT INTO lbm_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","येकोलायी इसहाक गरार नगर म रह्य गयो। ");
INSERT INTO lbm_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","जब ऊ जागा को लोगों न ओकी पत्नी रिबका को बारे म पुच्छ्यो, तब इसहाक न यो सोच क कि यदि मय ओख अपनी पत्नी कहूं, त इत को लोग रिबका को वजह जो बहुत सुन्दर हय, मोख मार डालेंन, इसहाक न उत्तर दियो, “वा त मोरी बहिन आय।” ");
INSERT INTO lbm_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जब इसहाक ख उत रह्यतो हुयो बहुत समय बीत गयो, तब एक दिन पलिश्तियों को राजा अबीमेलेक न खिड़की म सी झांक क देख्यो कि इसहाक अपनी पत्नी रिबका को संग प्रेम कर रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","तब अबीमेलेक न इसहाक ख बुलाय क कह्यो, “वा बाई त निश्चय तोरी पत्नी हय; तब तय न कहाली ओख अपनी बहिन कह्यो?” तब इसहाक न उत्तर दियो, “मय न सोच्यो होतो, कि असो नहीं हो कि मोख ओको वजह अपनी जान खोनो पड़े।” ");
INSERT INTO lbm_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेक न कह्यो, “तय न हमरो सी यो का करयो? असो त मोरी प्रजा को कोयी भी आदमी तोरी पत्नी को संग सोय सकत होतो, अऊर तय हम्ख पाप म फसातो।” ");
INSERT INTO lbm_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","येकोलायी अबीमेलेक न अपनी पूरी प्रजा ख आज्ञा दी, “जो कोयी ऊ आदमी ख यां वा बाई ख छुयेंन, ऊ निश्चय मार दियो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","तब इसहाक न ऊ देश म जमीन पर अनाज बोयो, अऊर उच साल म सौ गुना फसल हासिल करी; अऊर परमेश्वर न ओख आशीष दी। ");
INSERT INTO lbm_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","अऊर ऊ धनी भय गयो, ओकी उन्नति होती गयी, अऊर ऊ बहुत धनवान आदमी भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","जब ओको शेरी-मेंढी, गाय-बईल, अऊर दास-दासियां भयी, तब पलिश्ती ओको सी जलन करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","जिन कुंवा ख इसहाक को बाप अब्राहम को दासों न अब्राहम को जीतो जी खोद्यो होतो, उन्ख पलिश्ती जाति को लोग न माटी सी बुझाय क बन्द कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","तब अबीमेलेक न इसहाक सी कह्यो, “हमरो जवर सी चली जा; कहालीकि तय हमरो सी बहुत सामर्थी भय गयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","येकोलायी इसहाक उत सी चली गयो, अऊर गरार नगर की घाटी म अपनो तम्बू खड़ो कर क् रहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","तब जो कुंवा ओको बाप अब्राहम को दिनों म खोद्यो गयो होतो, अऊर अब्राहम को मरन को बाद पलिश्तियों न कुंवा ख बुझाय दियो होतो, तब इसहाक न हि कुंवा ख फिर सी खुदवायो; अऊर उन्को उच नाम रख्यो, जो ओको बाप न रख्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","तब इसहाक को दासों जो घाटी म कुंवा खोदतो खोदतो एक झरना मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","तब गरार को चरवाहों न इसहाक को चरवाहों सी झगड़ा करयो, अऊर कह्यो, “यो पानी हमरो आय।” येकोलायी इसहाक न ऊ कुंवा को नाम एसेक रख्यो; कहालीकि हि इसहाक सी झगड़ा करत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","तब इसहाक को दासों न दूसरो कुंवा खोद्यो; अऊर उन्न ओको लायी भी झगड़ा करयो, येकोलायी इसहाक न उन्ख सित्ना को नाम दियो। ");
INSERT INTO lbm_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","तब इसहाक न उत सी निकल क एक अऊर कुंवा खुदवायो; अऊर ओको लायी उन्न झगड़ा नहीं करयो; येकोलायी इसहाक न ओको नाम यो कह्य क स्वतंत्रता रख्यो। इसहाक न कह्यो, “अब त परमेश्वर न हमरो लायी बहुत जागा दियो हय, अऊर हम यो देश म सफल होयबो।” ");
INSERT INTO lbm_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","उत सी ऊ बेर्शेबा ख गयो। ");
INSERT INTO lbm_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","अऊर उच दिन परमेश्वर न रात ख ओख दर्शन दे क कह्यो, “मय तोरो बाप अब्राहम को परमेश्वर आय; मत डर, कहालीकि मय तोरो संग हय, अऊर अपनो दास अब्राहम को वजह तोख आशीष देऊं, अऊर तोरो वंश बढ़ाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","तब इसहाक न वहां एक वेदी बनायी, अऊर परमेश्वर सी आराधना करी, अऊर अपनो तम्बू वहांच खड़ो करयो; अऊर वहां इसहाक को दासों न एक कुंवा खोद्यो। ");
INSERT INTO lbm_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","तब अबीमेलेक अपनो सलाहकार अहुज्जत, अऊर सेनापति पीकोल ख संग ले क, गरार नगर सी इसहाक को जवर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाक न उन्को सी कह्यो, “तुम न मोरो सी दुश्मनी कर क् अपनो बीच सी निकाल दियो होतो, अब मोरो जवर कहाली आयो हय?” ");
INSERT INTO lbm_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","उन्न कह्यो, “हम्न त साफ देख्यो हय, कि यहोवा तोरो संग रह्य हय; येकोलायी हम्न सोच्यो, कि तय त यहोवा को तरफ सी धन्य हय, येकोलायी हमरो अऊर तोरो बीच म कसम खायी जाये, अऊर हम तोरो सी यो चाहजे हय कि तय वादा करे; ");
INSERT INTO lbm_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","कि जसो हम्न तोख नहीं छूयो, अऊर तोरो संग केवल भलायीच करी हय, अऊर तोख शान्ति सी बिदा करयो, ओको अनुसार तय भी हम सी कोयी बुरो व्यवहार मत करजो अब तुम परमेश्वर की आशीष पायो हुयो आदमी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","तब इसहाक न उन्को लायी विशेष भोजन तैयार करयो, अऊर उन्न खायो पियो। ");
INSERT INTO lbm_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","तब हि भुन्सारे जल्दी उठ क आपस म कसम खायी; तब इसहाक न उन्ख बिदा करयो, अऊर हि खुशी सी ओको जवर सी चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","उच दिन इसहाक को दासों न आय क अपनो ऊ खोद्यो हुयो कुंवा को बारे म इसहाक ख बतायो, “हम्ख पानी को एक सोता मिल गयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","तब इसहाक न कुंवा को नाम शिबा रख्यो; योच वजह अज तक ऊ नगर को नाम बेर्शेबा पड़्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जब एसाव चालीस साल को भयो, तब ओन हित्ती जाति की दोय टुरियों सी बिहाव करयो, यहूदीत अऊर बासमत, यहूदीत को बाप को नाम बेरी अऊर बासमत को बाप को नाम एलोन होतो; ");
INSERT INTO lbm_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","अऊर उन्को वजह इसहाक अऊर रिबका को मन ख ठेस पहुंची। ");
INSERT INTO lbm_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जब इसहाक बूढ्ढा भय गयो, अऊर ओकी आंखी असी धुंधली पड़ गयी कि ऊ देख नहीं सकत होतो, तब ओन अपनो बड़ो बेटा एसाव ख बुलाय क कह्यो, “हे मोरो बेटा!” “एसाव न उत्तर दियो, का बात हय।” ");
INSERT INTO lbm_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसहाक न कह्यो, “सुन, मय त बूढ्ढा भय गयो हय, अऊर मय नहीं जानु हय कि मोरो मरन को दिन कब आयेंन ");
INSERT INTO lbm_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","येकोलायी अब तय अपनो धनुष बान ले क जंगल म जा, अऊर मोरो लायी शिकार कर क् लाव ");
INSERT INTO lbm_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ओको बाद तय मोरी इच्छा को अनुसार स्वादिष्ट खाना बनाय क मोरो जवर ले आजो, कि मय ओख खाय क मरन सी पहिले तोख जी भर क आशीर्वाद देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","तब एसाव शिकार करन ख जंगल म गयो। जब इसहाक एसाव सी यो बात कह्य रह्यो होतो, तब रिबका भी सुन रही होती। ");
INSERT INTO lbm_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","येकोलायी रिबका न अपनो बेटा याकूब सी कह्यो, “सुन, मय न तोरो बाप ख तोरो भाऊ एसाव सी यो कहतो सुन्यो हय, ");
INSERT INTO lbm_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘तय मोरो लायी शिकार कर क् ओको स्वादिष्ट खाना बनाव, कि मय ओख खाय क तोख परमेश्वर को आगु मरन सी पहिले आशीर्वाद देऊं।’ ");
INSERT INTO lbm_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","येकोलायी अब, रिबका न कह्यो हे मोरो बेटा, मोरी सुन, जसी मय तोरो सी कहू हय, वसोच कर, ");
INSERT INTO lbm_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","तय शेरियों को जवर जाय क शेरी को दोय अच्छो अच्छो बच्चा ले आव; अऊर मय तोरो बाप लायी ओकी इच्छा को अनुसार उन्को मांस को स्वादिष्ट खाना बनाऊं। ");
INSERT INTO lbm_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","तब तय ओख अपनो बाप को जवर ले जाजो, कि ऊ ओख खाय क मरन सी पहिले तोख आशीर्वाद दे।” ");
INSERT INTO lbm_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकूब न अपनी माय रिबका सी कह्यो, “सुन, मोरो भाऊ एसाव को शरीर म बहुत बाल हय, लेकिन मोरो शरीर म नहाय। ");
INSERT INTO lbm_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","कभी मोरो बाप मोख छुयेंन, तब मय ओकी नजर म धोका देन वालो ठहरूं; अऊर आशीष को बदला अपनो ऊपर श्राप लाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ओकी माय न ओको सी कह्यो, “हे मोरो बेटा, श्राप तोरो पर नहीं मोरोच पर आयेंन, तय केवल मोरी सुन, अऊर जाय क शेरी को बच्चां मोरो जवर ले आव।” ");
INSERT INTO lbm_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","तब याकूब जाय क शेरी को बच्चां अपनी माय को जवर ले आयो, अऊर ओकी माय न ओको बाप की इच्छा को अनुसार स्वादिष्ट खाना बनाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","तब रिबका न अपनो बड़ो बेटा एसाव को सब सी अच्छो कपड़ा, जो ओको जवर घर म होतो, उन्ख ले क अपनो छोटो बेटा याकूब ख पहिनाय दियो; ");
INSERT INTO lbm_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","अऊर ओन शेरियों को बच्चा को चमड़ा ख ओको हाथों पर अऊर गर्दन पर लपेट दियो। ");
INSERT INTO lbm_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","अऊर ऊ स्वादिष्ट खाना अऊर अपनी बनायी हुयी रोटी भी अपनो बेटा याकूब को हाथ म दे दी। ");
INSERT INTO lbm_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","तब याकूब अपनो बाप को जवर गयो, अऊर कह्यो, “हे मोरो बाप,” इसहाक न कह्यो, “का बात हय? मोरो बेटा, तय कौन आय?” ");
INSERT INTO lbm_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूब न अपनो बाप सी कह्यो, “मय तोरो बड़ो बेटा एसाव आय। मय न तोरी आज्ञा को अनुसार करयो हय; येकोलायी उठ अऊर बैठ क मोरो शिकार को मांस म सी खा ले, ताकि तय मोख दिल सी आशीर्वाद दे सके।” ");
INSERT INTO lbm_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाक न अपनो बेटा सी कह्यो, “हे मोरो बेटा, का वजह हय कि शिकार तोख इतनो जल्दी मिल गयो?” याकूब न यो उत्तर दियो, “तोरो परमेश्वर यहोवा न ओख मोरो आगु कर दियो होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","तब इसहाक न याकूब सी कह्यो, “हे मोरो बेटा, जवर आव, मय तोख छुय क जान सकू कि तय सचमुच मोरो बेटा एसाव आय का नहीं।” ");
INSERT INTO lbm_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","तब याकूब अपनो बाप इसहाक को जवर गयो, अऊर इसहाक न ओख छुय क कह्यो, “तोरी आवाज त याकूब को जसी हय, पर तोरो हाथ त एसाव को हाथ जसो लगय हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","यो तरह इसहाक न ओख नहीं पहिचान्यो, कहालीकि ओको हाथ ओको भाऊ एसाव को जसो बाल वालो होतो; येकोलायी इसहाक न ओख आशीर्वाद दियो। ");
INSERT INTO lbm_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","अऊर इसहाक न पुच्छ्यो, “का तय सचमुच मोरो बेटा एसाव आय?” याकूब न कह्यो, “हव, मय आय।” ");
INSERT INTO lbm_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब इसहाक न कह्यो, “खाना ख मोरो जवर ले आव, कि मय अपनो बेटा को शिकार को मांस म सी खाय क, तोख दिल सी आशीर्वाद देऊ।” तब याकूब न अपनो बाप को जवर खाना लायो, अऊर ओन खायो; अऊर ऊ अंगूरीरस रस भी लायो, अऊर ओन पियो। ");
INSERT INTO lbm_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","तब ओको बाप इसहाक न ओको सी कह्यो, “हे मोरो बेटा, जवर आय क मोख चुम्मा दे।” ");
INSERT INTO lbm_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ओन जवर जाय क इसहाक ख चुम्मा दियो; अऊर इसहाक न ओको कपड़ा की सुगन्ध सूंघ क ओख यो आशीर्वाद दियो, “देख, मोरो बेटा की सुगन्ध ऊ खेत को जसो हय जेक परमेश्वर न आशीर्वाद दियो हय; ");
INSERT INTO lbm_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्वर तोख आसमान सी ओस, अऊर जमीन की अच्छी सी अच्छी उपज, अऊर बहुत सो अनाज अऊर नयो अंगूरीरस रस देन। ");
INSERT INTO lbm_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","राज्य राज्य को लोग तोरी सेवा करेंन, अऊर हर एक जाती को लोग तोरो आगु झुकेंन। तय अपनो रिश्तेदारों को ऊपर शासन कर सकय हय, अऊर तोरी माय को बेटा तोरो आगु झुकेंन। जो तोख श्राप देन ऊ खुदच श्रापित होयेंन, अऊर जो तोख आशीर्वाद देन ऊ खुद आशीष पायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","जसोच इसहाक न याकूब ख आशीर्वाद देनो खतम करयो, अऊर जसोच याकूब अपनो बाप इसहाक को जवर सी बाहेर निकल्यो, कि ओको भाऊ एसाव शिकार ले क आयो। ");
INSERT INTO lbm_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","तब एसाव भी स्वादिष्ट खाना बनाय क अपनो बाप को जवर ले आयो, अऊर ओन कह्यो, “हे मोरो बाप, उठ क अपनो बेटा को शिकार को मांस खा, ताकि तय मोख दिल सी आशीर्वाद दे।” ");
INSERT INTO lbm_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ओको बाप इसहाक न पुच्छ्यो, “तय कौन आय?” एसाव न कह्यो, “मय तोरो बड़ो बेटा एसाव आय।” ");
INSERT INTO lbm_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","तब इसहाक पूरो तरह सी थरथर कांपन लग्यो, अऊर ओन पुच्छ्यो, “ऊ कौन होतो जो शिकार कर क् मोरो जवर ले आयो होतो, अऊर मय न तोरो आवन सी पहिले सब म सी कुछ कुछ खाय लियो अऊर ओख आशीर्वाद दियो? अब उच आशीर्वाद हमेशा ओको पर बन्यो रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","जब एसाव न अपनो बाप इसहाक की यो बाते सुनी, तब ऊ जोर सी चिल्लायो अऊर फूट फूट क रोवन लग्यो अऊर अपनो बाप सी कह्यो, “हे मोरो बाप, मोख भी अपनो आशीर्वाद दे!” ");
INSERT INTO lbm_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","इसहाक न उत्तर दियो, “तोरो भाऊ आयो अऊर मोख धोका दियो, अऊर ऊ तोरो आशीर्वाद छीन क चली गयो।” ");
INSERT INTO lbm_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसाव न कह्यो, “ओको नाम याकूब ठीकच रख्यो गयो होतो। ओन मोख दोय बार धोका दियो हय। पहिले त ओन मोरो बड़ो बेटा होन को अधिकार ले लियो; अऊर अब मोरो आशीर्वाद भी छीन लियो हय।” तब एसाव न कह्यो, “का तय न मोरो लायी कोयी आशीर्वाद नहीं बचाय क रख्यो?” ");
INSERT INTO lbm_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाक न एसाव ख उत्तर दे क कह्यो, “सुन, मय न ओख तोरो स्वामी बनाय दियो हय, अऊर ओको सब रिश्तेदारों ख ओको दास बनाय क ओख सौंप दियो हय, अऊर मय न अनाज अऊर अंगूर को रस दे क ओख भरपूर आशीष दियो हय। येकोलायी अब, हे मोरो बेटा, मय तोरो लायी का करूं?” ");
INSERT INTO lbm_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव न अपनो बाप सी कह्यो, “हे मोरो बाप, का तोरो मन म केवल एकच आशीर्वाद हय? हे मोरो बाप, मोख भी आशीर्वाद दे।” यो कह्य क एसाव फूट फूट क रोवन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","तब ओको बाप इसहाक न ओको सी कह्यो, “सुन, तोरो निवास उपजाऊ जमीन सी दूर हो, अऊर ऊपर सी आसमान की ओस ओको पर नहीं पड़े। ");
INSERT INTO lbm_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तय अपनी तलवार को दम सी जीन्दो रह्यजो, अऊर तय अपनो भाऊ को दास त बनजो; पर जब तय आजादी लायी लड़जो, तब तय अपनो ऊपर पड़्यो ओको गुलामी को जूआ ख तोड़ फेकजो।” ");
INSERT INTO lbm_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","एसाव याकूब सी नफरत करत होतो, कहालीकि ओको बाप न याकूब ख आशीर्वाद दियो होतो; अऊर एसाव न सोच्यो, “मोरो बाप की मृत्यु को शोक मनान को दिन जवर हय, तब मय अपनो भाऊ याकूब ख मार डालूं।” ");
INSERT INTO lbm_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","जब रिबका ख ओको बड़ो बेटा एसाव की यो बात बतायी गयी, तब ओन अपनो छोटो बेटा याकूब ख बुलाय क कह्यो, “सुन, तोरो भाऊ एसाव तोख मारन लायी अपनो मन म धीरज रख्यो हुयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","येकोलायी अब, हे मोरो बेटा, मोरी सुन, अऊर हारान नगर ख मोरो भाऊ लाबान को जवर भग जा; ");
INSERT INTO lbm_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","अऊर थोड़ो दिन तक, यानेकि जब तक तोरो भाऊ को गुस्सा शान्त नहीं होय जाय, तब तक ओकोच जवर रह्यजो। ");
INSERT INTO lbm_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","फिर जब तोरो भाऊ को गुस्सा तोरो पर सी शान्त होय जायेंन, अऊर जो काम तय न ओको संग करयो हय ओख ऊ भूल जायेंन; तब मय दास भेज क तोख वहां सी बुलाय लेऊं। तब असो कहाली हो कि एकच दिन म मोख तुम दोयी बेटावों सी वंचित होनो पड़े?” ");
INSERT INTO lbm_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","तब रिबका न इसहाक सी कह्यो, “मय हित्ति जाति की बहुवों को वजह अपनो जीव सी ऊब गयी हय; यदि याकूब भी इन बहुवों को जसो यो देश की कोयी हित्ती जाति की टुरी सी बिहाव कर लेन, त मोख अपनो जीव सी का लाभ मय मर जाऊं?” ");
INSERT INTO lbm_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","तब इसहाक न याकूब ख बुलाय क आशीर्वाद दियो, अऊर आज्ञा दी, “तय कोयी कनानी टुरी सी बिहाव मत कर लेजो। ");
INSERT INTO lbm_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","उठ अऊर पद्दनराम म अपनो नाना बतूएल को घर जाय क, वहां अपनो मामा लाबान की एक टुरी सी बिहाव कर लेजो। ");
INSERT INTO lbm_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वशक्तिमान परमेश्वर तोख आशीष दे, अऊर तोख कुछ बच्चा दे क बढ़ाये, ताकि तय कुछ राष्ट्रों को बाप बन जाये। ");
INSERT INTO lbm_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ऊ तोख अऊर तोरो वंश ख भी अब्राहम की जसी आशीष दे, कि तय यो देश जेको म तय परदेशी होय क रह्य हय, अऊर जेक परमेश्वर न अब्राहम ख दियो होतो, ओको अधिकार होय जाये।” ");
INSERT INTO lbm_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","यो तरह इसहाक न याकूब ख बिदा करयो, अऊर ऊ पद्दनराम ख अरामी बतूएल को बेटा लाबान को जवर चली गयो, जो याकूब अऊर एसाव की माय रिबका को भाऊ होतो। ");
INSERT INTO lbm_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","जब एसाव ख पता चल्यो कि इसहाक न याकूब ख आशीर्वाद दे क पद्दनराम क्षेत्र भेज दियो, कि ऊ वहां सी पत्नी लाये, अऊर ओख आशीर्वाद देन को समय यो आज्ञा भी दी, “तय कोयी कनानी टुरी सी बिहाव मत कर लेजो,” ");
INSERT INTO lbm_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","अऊर याकूब अपनो माय बाप की आज्ञा मान क पद्दनराम ख चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","तब एसाव यो सब देख क् अऊर यो भी सोच क कि कनानी टुरियां मोरो बाप इसहाक ख बुरी लगय हंय, ");
INSERT INTO lbm_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","येकोलायी ऊ अब्राहम को बेटा इश्माएल को जवर गयो, अऊर एश्माएल की टुरी महलत ख, जो नबायोत की बहिन होती, ओको सी बिहाव कर क् अपनी पत्नियों म मिलाय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकूब बेर्शेबा सी निकल क हारान नगर को तरफ चल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","अऊर ओन कोयी एक जागा म पहुंच क रात उतच बितावन को बिचार करयो, कहालीकि सूरज डुब गयो होतो; येकोलायी ओन ऊ जागा म गिरयो गोटा म सी एक गोटा ले क ओख अपनी मुंड को खल्लो रख्यो, अऊर ऊ उच जागा पर सोय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","तब याकूब न सपनो म देख्यो, कि एक सीढ़ी धरती पर खड़ी हय, अऊर ओको सिरा स्वर्ग तक पहुंच्यो हय; अऊर परमेश्वर को दूत ओको पर सी चढ़य अऊर उतरय हंय। ");
INSERT INTO lbm_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","अऊर यहोवा ओको ऊपर खड़ो होय क कह्य हय, “मय यहोवा, तोरो दादा अब्राहम को परमेश्वर, अऊर इसहाक को भी परमेश्वर आय; जो जमीन पर तय सोयो हय, ओख मय तोख अऊर तोरो वंश ख देऊं। ");
INSERT INTO lbm_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","अऊर तोरो वंश जमीन की धूल को कन को जसो बहुत सारो होयेंन, अऊर पश्चिम, पूर्व, उत्तर, दक्षिन, चारयी तरफ फैलतो जायेंन : अऊर तोरो अऊर तोरो वंश को द्वारा धरती को पूरो वंशज आशीष पायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","अऊर सुन, मय तोरो संग रहूं, अऊर जित कहीं तय जाजो उत तोरी रक्षा करूं, अऊर तोख यो देश म वापस ले आऊं: जो बात मय न तोरो सी कहीं हंय, जब तक उन्ख पूरी नहीं कर लेऊं तब तक तोख नहीं छोडूं।” ");
INSERT INTO lbm_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","तब याकूब नींद सी जग गयो, अऊर कहन लग्यो, “निश्चय यो जागा म यहोवा हय; अऊर मय यो बात ख नहीं जानत होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","अऊर ओन डर को मारे कह्यो, “या जागा कितनी भयानक हय! यो त परमेश्वर को भवन को अलावा अऊर कुछ नहीं होय सकय; नहीं त यो स्वर्ग म खुलन वालो फाटकच होना।” ");
INSERT INTO lbm_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","सुबेरे याकूब उठ्यो, अऊर ओन अपनो मुंड को खल्लो रख्यो हुयो गोटा ख उठायो, अऊर ओख खम्बा को जसो खड़ो करयो, अऊर ओको बाद ओकी मुंड पर तेल डाल दियो। ");
INSERT INTO lbm_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","अऊर ओन ऊ जागा को नाम बेतेल रख्यो; पर ऊ नगर को नाम पहिले लूज होतो। ");
INSERT INTO lbm_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","तब याकूब न परमेश्वर सी एक कसम मांगी, “यदि तय मोरो संग रह्य क यो यात्रा म मोरी रक्षा करजो, अऊर मोख खान लायी रोटी, अऊर पहिन न लायी कपड़ा दे, ");
INSERT INTO lbm_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","कि मय अपनो बाप को घर म अच्छी तरह सी लौट आऊं; त तय यहोवा च मोरो परमेश्वर होयजो। ");
INSERT INTO lbm_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","खम्भा अऊर यो गोटा जेको मय न खम्बा खड़ो करयो हय, यो परमेश्वर को भवन बनेंन, अऊर जो कुछ तय मोख देजो ओकोच दसवा हिस्सा मय जरूरच तोख दियो करूं।” ");
INSERT INTO lbm_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","याकूब न अपनी रस्ता पकड़ी, अऊर पूर्व को निवासियों को देश म आयो। ");
INSERT INTO lbm_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ओन नजर कर क् देख्यो कि मैदान म एक कुंवा हय, अऊर ओको जवर शेरी मेंढियों को तीन झुण्ड बैठ्यो हुयो हंय; कहालीकि जो गोटा ऊ कुंवा को ऊपर रहत होतो, जेको म सी झुण्डों ख पानी पिलायो जात होतो, ऊ भारी होतो। ");
INSERT INTO lbm_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","अऊर जब सब झुण्ड वहां जमा होय जावय तब चरावन वालो ऊ गोटा ख कुंवा को ऊपर सी गंडलाय क शेरी मेंढियों ख पानी पिलात होतो, अऊर फिर गोटा ख कुंवा को ऊपर जसो को वसो रख देत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","तब याकूब न चरावन वालो सी पुच्छ्यो, “हे मोरो भाऊवों, तुम कित सी आयो हय?” उन्न कह्यो, “हम हारान नगर सी आयो हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","तब याकूब न उन्को सी पुच्छ्यो, “का तुम नाहोर को नाती लाबान ख जानय हय?” उन्न कह्यो, “हव, हम ओख जानजे हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","तब ओन उन्को सी पुच्छ्यो, “का ऊ खुश हय?” उन्न कह्यो, “हव, ऊ खुश हय अऊर तब, ओकी बेटी राहेल शेरी मेंढियों ख धर क चली आवय हय।” ");
INSERT INTO lbm_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याकूब न कह्यो, “देखो, अभी त दिन बहुत हय, जनावरों को जमा होन को समय नहीं आयो हय; येकोलायी शेरी मेंढियों ख पानी पिलाय क फिर सी लिजाय क चरावों।” ");
INSERT INTO lbm_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","उन्न कह्यो, “हम अभी असो नहीं कर सकजे; जब सब झुण्ड जमा होवय हंय तब गोटा कुंवा को ऊपर सी गंडलायो जावय हय, अऊर तब हम शेरी मेंढियों ख पानी पिलाजे हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","उन्की यो बात चीत होतच रह्य कि राहेल, जो जनावर चरायो करत होती, अपनो बाप की शेरी मेंढियों ख धर क आय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","याकूब न अपनो मामा अऊर लाबान की बेटी राहेल ख, अऊर ओकी शेरी मेंढियों ख देख्यो त जवर जाय क कुंवा को ऊपर सी गोटा ख गंडलायो अऊर अपनो मामा लाबान की शेरी मेंढियों ख पानी पिलायो। ");
INSERT INTO lbm_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","तब याकूब न राहेल को चुम्यो, अऊर जोर जोर सी रोयो। ");
INSERT INTO lbm_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","अऊर याकूब न राहेल ख बताय दियो, कि मय तोरो फुफ भाऊ आय, मतलब रिबका को टुरा आय। तब राहेल दौड़ क अपनो बाप सी कह्य दियो। ");
INSERT INTO lbm_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","अपनो भास्या याकूब को समाचार पातोच लाबान ओको सी मिलन ख दौड़्यो, अऊर ओख गलो लगाय क चुम्यो, तब अपनो घर ले आयो। याकूब न लाबान ख अपनो सब लेखा सुनायो। ");
INSERT INTO lbm_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","तब लाबान न याकूब सी कह्यो, “तय त सचमुच मोरी हड्डी अऊर मांस हय।” अऊर याकूब एक महीना भर ओको संग रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","तब लाबान न याकूब सी कह्यो, “कुटुम्बी होन को वजह तोरो सी फुकट म सेवा करवानो मोरो लायी उचित नहाय; येकोलायी मोख बताव कि मय तोख सेवा को बदला म का देऊं?” ");
INSERT INTO lbm_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबान की दोय बेटियां होती, जिन्म सी बड़ी को नाम लिआ अऊर छोटी को राहेल होतो। ");
INSERT INTO lbm_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लिआ की आंखी धुन्धरी होती, पर राहेल बहुत अच्छी अऊर सुन्दर होती। ");
INSERT INTO lbm_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","येकोलायी याकूब न, जो राहेल सी प्रेम करत होतो, ओन कह्यो, “मय तोरी छोटी बेटी राहेल लायी सात साल तोरी सेवा करूं।” ");
INSERT INTO lbm_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान न कह्यो, “ओख परायो आदमी ख देन सी अच्छो तोख देनो अच्छो होयेंन; येकोलायी मोरो जवर रह्य।” ");
INSERT INTO lbm_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","तब याकूब न राहेल लायी सात साल सेवा करी; अऊर हि ओख राहेल को प्रेम को वजह थोड़ोच दिनों को बराबर जान पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","तब याकूब न लाबान सी कह्यो, “मोरी पत्नी मोख दे, अऊर मय ओको जवर जाऊं, कहालीकि मोरो समय पूरो भय गयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","तब लाबान न ऊ जागा को सब आदमियों ख बुलाय क जमा करयो, अऊर बिहाव को खाना दियो। ");
INSERT INTO lbm_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","शाम को समय ऊ अपनी बेटी लिआ ख याकूब को जवर ले गयो, अऊर याकूब ओको जवर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबान न अपनी बेटी लिआ ख अपनी दासी जिल्पा दी कि वा ओकी सेवा करे। ");
INSERT INTO lbm_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","सुबेरे ख मालूम भयो कि या त लिआ आय, येकोलायी ओन लाबान सी कह्यो, “यो तय न मोरो संग का करयो हय? मय न तोरो संग रह्य क जो तोरी सेवा करी, त का राहेल लायी नहीं करी? फिर तय न मोरो सी असो कहाली धोखा करयो हय?” ");
INSERT INTO lbm_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबान न कह्यो, “हमरो यहां असी रीति नहाय कि बड़ी बेटी सी पहिले दूसरी को बिहाव कर दे। ");
INSERT INTO lbm_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","येको हप्ता त पूरो कर; तब दूसरी भी तोख ऊ सेवा लायी मिलेंन जो तय मोरो संग रह्य क अऊर सात साल तक करजो।” ");
INSERT INTO lbm_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याकूब न असोच करयो, अऊर लिआ को हप्ता ख पूरो करयो; तब लाबान न ओख अपनी बेटी राहेल भी दी कि वा ओकी पत्नी हो। ");
INSERT INTO lbm_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबान न अपनी बेटी राहेल की दासी होन लायी अपनी दासी बिल्हा ख दियो। ");
INSERT INTO lbm_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","तब याकूब राहेल को जवर भी गयो, पर ओन लिआ सी जादा राहेल सी प्रेम करयो; ओन सात साल अऊर लाबान की सेवा करी। ");
INSERT INTO lbm_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","जब यहोवा न देख्यो, कि लिआ सी नफरत करी जावय हय, तब ओन ओख गर्भवती बनायो, पर राहेल बांझ रही। ");
INSERT INTO lbm_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","तब लिआ गर्भवती भयी अऊर ओको एक टुरा पैदा भयो, अऊर ओन यो कह्य क ओको नाम रूबेन रख्यो, “यहोवा न मोरो दु:ख पर नजर करी हय, अब मोरो पति मोरो सी प्रेम रखेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","तब वा गर्भवती भयी अऊर ओको एक टुरा पैदा भयो; तब ओन यो कह्यो, “यो सुन क कि मोरो सी नफरत करी गयी हय, यहोवा न मोख यो टुरा भी दियो।” येकोलायी ओन ओको नाम शिमोन रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","तब वा गर्भवती भयी अऊर ओको एक टुरा पैदा भयो; अऊर ओन कह्यो, “अब त मोरो पति मोरो सी मिल जायेंन, कहालीकि ओको सी मोरो तीन टुरा पैदा भयो।” येकोलायी ओको नाम लेवी रख्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","अऊर तब वा गर्भवती भयी अऊर ओको एक अऊर टुरा पैदा भयो; अऊर ओन कह्यो, “अब त मय यहोवा को धन्यवाद करूं।” येकोलायी ओन ओको नाम यहूदा रख्यो; तब ओकी कोख बन्द होय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","जब राहेल न देख्यो कि याकूब लायी मोरो सी कोयी सन्तान नहीं होवय, तब वा अपनी बहिन सी नफरत करन लगी अऊर याकूब सी कह्यो, “मोख भी सन्तान दे, नहीं त मर जाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","तब याकूब न राहेल सी जलन सी कह्यो, “का मय परमेश्वर आय? तोरी कोख त ओनच बन्द कर रखी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","राहेल न कह्यो, “देखो, मोरी दासी बिल्हा हय; ओकोच जवर जा, ताकि वा मोरो लायी बच्चा पैदा कर सके, अऊर ओको द्वारा मोरो भी घर बसेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","तब राहेल न अपनी दासी याकूब ख दी कि वा ओकी पत्नी हो; अऊर याकूब ओको जवर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","अऊर बिल्हा गर्भवती भयी अऊर याकूब सी ओको एक टुरा पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","तब राहेल न कह्यो, “परमेश्वर न मोरो न्याय चुकायो अऊर मोरी सुन क मोख एक बेटा दियो।” येकोलायी ओन ओको नाम दान रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेल की दासी बिल्हा फिर गर्भवती भयी अऊर याकूब सी एक टुरा अऊर पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","तब राहेल न कह्यो, “मय न अपनी बहिन को संग बड़ी ताकत सी लड़ाई लड़ी हय, लेकिन मय जीत गयी हय।” येकोलायी ओन ओको नाम नप्ताली रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जब लिआ न देख्यो कि ओकी सन्तान होनो बन्द होय गयो हय, तब ओन अपनी दासी जिल्पा ख ले क याकूब की पत्नी होन लायी दे दी। ");
INSERT INTO lbm_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","अऊर लिआ की दासी जिल्पा ख भी याकूब सी एक टुरा पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","तब लिआ न कह्यो, “अहो भाग्य!” येकोलायी ओन ओको नाम गाद रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","तब लिआ की दासी जिल्पा ख याकूब सी अऊर एक टुरा पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","तब लिआ न कह्यो, “मय धन्य हय; निश्चय बाईयों मोख धन्य कहेंन।” येकोलायी ओन ओको नाम आशेर रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गहूं काटन को दिनों म रूबेन ख मैदान म दूदा फर मिल्यो, अऊर ऊ उन्ख अपनी माय लिआ को जवर ले गयो। तब राहेल न लिआ सी कह्यो, “अपनो बेटा को दूदा फर म सी कुछ मोख दे।” ");
INSERT INTO lbm_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लिआ न ओको सी कह्यो, “तय न जो मोरो पति ख ले लियो हय का या छोटी सी बात हय? अब का तय मोरो बेटा को दूदा फर भी लेनो चाहवय हय?” राहेल न कह्यो, “अच्छा, तोरो बेटा को दूदा फरों को बदला ऊ अज रात ख तोरो संग सोयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","शाम ख जब याकूब मैदान सी आय रह्यो होतो, तब लिआ ओको सी मिल न ख निकली, अऊर कह्यो, “तोख मोरोच जवर आनो होना, कहालीकि मय न अपनो बेटा को दूदा फर देख क तोख सचमुच ले लियो।” तब याकूब ऊ रात ख ओकोच संग सोयो। ");
INSERT INTO lbm_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","तब परमेश्वर न लिआ की सुनी, अऊर वा गर्भवती भयी अऊर याकूब सी ओको पाचवों टुरा पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","तब लिआ न कह्यो, “मय न जो अपनो पति ख दासी दी, येकोलायी परमेश्वर न मोख मोरी मजूरी दी हय।” येकोलायी ओन ओको नाम इस्साकार रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लिआ : फिर गर्भवती भयी अऊर याकूब सी ओको छठवो टुरा पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","तब लिआ न कह्यो, “परमेश्वर न मोख अच्छो दान दियो हय; अब की बार मोरो पति मोरो संग बन्यो रहेंन, कहालीकि मोरो ओको सी छय टुरा पैदा भय गयो हंय।” येकोलायी ओन ओको नाम जबूलून रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","येको बाद ओकी एक टुरी भी भयी, अऊर ओन ओको नाम दीना रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","परमेश्वर न राहेल की भी सुधि ली, अऊर ओकी प्रार्थना सुन क ओकी कोख खोली। ");
INSERT INTO lbm_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","येकोलायी वा गर्भवती भयी अऊर ओन एक टुरा ख जनम दियो, तब ओन कह्यो, “परमेश्वर न मोरी नामधरायी ख दूर कर दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","येकोलायी ओन यो कह्य क ओको नाम यूसुफ रख्यो, “परमेश्वर मोख एक बेटा अऊर देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","जब राहेल सी यूसुफ पैदा भयो, तब याकूब न लाबान सी कह्यो, “मोख बिदा कर कि मय अपनो देश अऊर घर ख वापस जाऊं। ");
INSERT INTO lbm_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मोख मोरी पत्नियां अऊर मोरो बच्चा, दे जिन्को लायी मय न तोरी सेवा करी हय, कि मय उन्ख ले क चली जाऊं; तय जो जानय हय कि मय न तोरी कसी सेवा करी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबान न ओको सी कह्यो, “यदि तोरी नजर म मय न अनुग्रह पायो हय, त इतच रह्य जा; कहालीकि मय न अनुभव सी जान लियो हय कि परमेश्वर न तोरो वजह सी मोख आशीष दी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","तब याकूब न कह्यो, “तय ठीक बता कि मय तोख का देऊं, अऊर मय जरूर ओख देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकूब न ओको सी कह्यो, “तय जानय हय कि मय न तोरी कसी सेवा करी, अऊर तोरो जनावर मोरो जवर कसो तरह सी रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","मोरो आन सी पहिले हि कितनो होतो, अऊर अब कितनो भय गयो हंय; अऊर यहोवा न मोरो आनो पर तोख आशीष दी हय। पर मय अपनो घर को काम अब कब करन पाऊं?” ");
INSERT INTO lbm_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","लाबान न फिर कह्यो, “मय तोख का देऊं?” याकूब न कह्यो, “तय मोख कुछ मत दे; यदि तय मोरो लायी एक काम करजो, त मय फिर तोरी शेरी मेंढियों ख चराऊं, अऊर उन्की रक्षा करूं। ");
INSERT INTO lbm_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","मय अज तोरी सब शेरी मेंढियों को बीच म सी होय क निकलूं, अऊर जो शेरी या मेंढी धब्बा वाली अऊर चितबहाड़ी हो, अऊर जो मेंढी कारी हो, अऊर जो शेरी धब्बा वाली अऊर चितबहाड़ी हो, उन्ख मय अलग कर क् रखूं; अऊर याच मोरी मजूरी ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","अऊर जब आगु ख मोरी मजूरी की चर्चा तोरो आगु चले, तब ऊ दिन सच्चायी मोरो बदला तोख उत्तर देयेंन; मतलब शेरियों म सी जो कोयी बिना धब्बा वाली अऊर न चितबहाड़ी हो, अऊर मेंढी म सी जो कोयी कारी नहीं हो, यदि मोरो जवर निकले त चोरी की ठहरेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","तब लाबान न कह्यो, “तोरो कहन को अनुसार हो।” ");
INSERT INTO lbm_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","तब लाबान न उच दिन सब धारी वालो अऊर धब्बा वालो बकरों, अऊर सब धब्बा वाली चितबहाड़ी शेरियों ख, मतलब जेको पर सफेद धब्बा होतो, उन्ख अऊर सब कारी मेंढियों ख भी अलग कर क् अपनो बेटावों को हाथ सौंप दियो; ");
INSERT INTO lbm_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","अऊर ओन अपनो अऊर याकूब को बीच म तीन दिन की रस्ता को अन्तर ठहरायो; अऊर याकूब लाबान की शेरी मेंढियों ख चरान लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","तब याकूब न चिनार, अऊर बादाम, अऊर अर्मोन को झाड़ों की हरी हरी डगालियां ले क, उन्को छिलटा कहीं छील क, उन्ख धारीदार बनाय दियो, अऊर उन छड़ियों की सफेदी दिखायी देन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","तब छीली हुयी छड़ियों ख शेरी मेंढियों को आगु उन्को पानी पीवन को डोंगी म खड़ी करयो; अऊर जब हि पानी पीवन लायी आयी तब हि गाभन भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","छड़ियों को आगु गाभन होय क, शेरी मेंढी धारी वालो, धब्बा वालो अऊर चितबहाड़ी बच्चा जनी। ");
INSERT INTO lbm_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","तब याकूब न मेंढियों को बच्चा ख अलग अलग करयो, अऊर लाबान की शेरी मेंढियों को मुंह ख धब्बा वालो अऊर सब कारो बच्चा को तरफ कर दियो; अऊर अपनो झुण्डों ख उन्को सी अलग रख्यो, अऊर लाबान की शेरी मेंढियों सी मिलन नहीं दियो। ");
INSERT INTO lbm_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","अऊर जब जब ताकतवर शेरी मेंढी गाभन होत रह्य, तब तब याकूब उन छड़ियों ख उन्को आगु घड़ा म रख देत रह्य; जेकोसी हि ऊ छड़ियों ख देखतो हुयो गाभन होत रह्य। ");
INSERT INTO lbm_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","पर जब कमजोर शेरी मेंढी गाभन होत रही, तब ऊ छड़ियों ख उन्को आगु नहीं रखत रह्य। येको सी कमजोर कमजोर शेरी मेंढी लाबान की भयी, अऊर ताकतवर शेरी मेंढी याकूब की भयी। ");
INSERT INTO lbm_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","यो तरह याकूब बहुत धनी भय गयो, अऊर ओको बहुत सो शेरी मेंढी, दासियां अऊर दास, अऊर ऊंट अऊर गधा भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","तब लाबान को टुरावों कि या बाते याकूब को सुननो म आयी, “याकूब न हमरो बाप को सब कुछ छीन लियो हय, अऊर हमरो बाप को धन को वजह ओकी या प्रतिष्ठा हय।” ");
INSERT INTO lbm_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","अऊर याकूब न लाबान को मुंह पर नजर करी अऊर देख लियो कि ऊ ओको प्रति पहिले को जसो नहीं रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","तब यहोवा न याकूब सी कह्यो, “अपनो पूर्वजों को देश अऊर अपनी जन्मभूमि पर वापस चली जा, अऊर मय तोरो संग रहूं।” ");
INSERT INTO lbm_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","तब याकूब न राहेल अऊर लिआ : ख मैदान म अपनी शेरी मेंढियों को जवर बुलाय क कह्यो, ");
INSERT INTO lbm_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“तुम्हरो बाप को मुंह सी मय जान लेऊ हय कि ऊ मोख पहिले को जसो अब नहीं देखय; पर मोरो बाप को परमेश्वर मोरो संग हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तुम भी जानय हय कि मय न तुम्हरो बाप की सेवा पूरी शक्ति सी करी हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","तब भी तुम्हरो बाप न मोरो सी छल कर क् मोरी मजूरी ख दस बार बदल दियो; पर परमेश्वर न ओख मोरो कुछ बुरो करन नहीं दियो। ");
INSERT INTO lbm_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","जब ओन कह्यो, ‘धब्बा वालो बच्चा तोरी मजूरी ठहरेंन,’ तब सब शेरी मेंढी धब्बा वालो बच्चाच जनन लगी; अऊर जब ओन कह्यो, ‘धारी वालो बच्चा तोरी मजूरी ठहरेंन,’ तब सब शेरी मेंढी धारी वालो बच्चा जनन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","यो रीति सी परमेश्वर न तुम्हरो बाप को जनावर ले क मोख दे दियो। ");
INSERT INTO lbm_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“शेरी मेंढियों को गाभन होन को समय मय न सपनो म यो देख्यो कि जो बकरा शेरियों पर चढ़ रह्यो हंय, हि धारी वालो, धब्बा वालो, अऊर चितबहाड़्या। ");
INSERT INTO lbm_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","तब परमेश्वर को दूत न सपनो म मोरो सी कह्यो, ‘हे याकूब,’ मय न कह्यो, ‘का आज्ञा हय।’ ");
INSERT INTO lbm_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ओन कह्यो, ‘आंखी उठाय क उन सब बकरा ख देख जो शेरियों पर चढ़ रह्यो हंय, कि हि धारी वालो, धब्बा वालो, अऊर चितबहाड़्या हंय; कहालीकि जो कुछ लाबान तोरो सी कह्य हय, ऊ मय न देख्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","मय ऊ बेतेल को परमेश्वर आय, जित तय न एक गोटा को खम्बा पर तेल डाल्यो होतो, अऊर मोरी मन्नत मानी होती। अब चल, यो देश सी निकल क अपनी जन्मभूमि पर वापस चली जा।’” ");
INSERT INTO lbm_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","तब राहेल अऊर लिआ : न याकूब सी कह्यो, “का हमरो बाप को घर म अब भी हमरो लायी कुछ हिस्सा या जायजाद बची हय? ");
INSERT INTO lbm_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","का हमरो बाप न हम्ख परायो नहीं समझ्यो? देख, ओन हम्ख त बेच डाल्यो, अऊर जो रुपया हम्ख हासिल भयो होतो ओख खुद खाय गयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","येकोलायी परमेश्वर न हमरो बाप को जितनो धन ले लियो हय, ऊ हमरो अऊर हमरो टुरावों को आय; अब जो कुछ परमेश्वर न तोरो सी कह्यो हय, उच कर।” ");
INSERT INTO lbm_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","तब याकूब न अपनो टुरावों अऊर पत्नियों ख ऊंटों पर बैठायो; ");
INSERT INTO lbm_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","अऊर जितनो जनावरों ख ऊ पद्दनराम की सीमा म जमा कर क् धनवान भय गयो होतो, सब ख कनान देश म अपनो बाप इसहाक को जवर जान को बिचार सी, संग ले गयो। ");
INSERT INTO lbm_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","लाबान अपनी मेंढियों को ऊन काटन गयो होतो, जब ऊ बाहेर गयो तब राहेल घर म घुसी अऊर अपनो बाप को गृहदेवतावों ख चुराय ख ले गयी। ");
INSERT INTO lbm_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","तब याकूब लाबान अरामी वंशीय को जवर सी चोरी सी चली गयो, तब लाबान ख याकूब न नहीं बतायो कि मय भगन वालो हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","याकूब न अपनो परिवार अऊर सब कुछ ले क भग्यो, अऊर फरात नदी को पार उतर क अपनो मुंह गिलाद को तरफ करयो अऊर पहाड़ी देश को तरफ चल पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीसरो दिन लाबान ख समाचार मिल्यो कि याकूब भग गयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","येकोलायी लाबान न अपनो भाऊवों ख संग ले क ओको सात दिन तक पीछा करयो, अऊर गिलाद को पहाड़ी देश म याकूब को संग जाय क मिल गयो। ");
INSERT INTO lbm_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","पर परमेश्वर न रात को सपनो म अरामी लाबान को जवर आय क कह्यो, “सावधान रह्य, तय याकूब सी भलो बुरो मत कह्यजो।” ");
INSERT INTO lbm_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","तब याकूब अपनो तम्बू गिलाद नाम की पहाड़ी देश म खड़ो कर क् होतो; अऊर लाबान न भी अपनो भाऊवों को संग अपनो तम्बू उच पहाड़ी देश म खड़ो करयो। ");
INSERT INTO lbm_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","तब लाबान याकूब सी कहन लग्यो, “तय न यो का करयो कि मोरो जवर सी चोरी सी चल्यो आयो, अऊर मोरी टुरियों ख असो ले क आयो, मानो तलवार की ताकत सी बन्दी बनायी गयी हो? ");
INSERT INTO lbm_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","तय कहाली चुपचाप सी भग क आयो, अऊर मोरो सी बिना कुछ कह्यो मोरो जवर सी चोरी सी चल्यो आयो; नहीं त मय तोख आनन्द को संग डफली अऊर वीणा बजवात, अऊर गीत गवातो बिदा करतो? ");
INSERT INTO lbm_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तय न त मोख अपनो टुरा अऊर टुरियों को भी चुम्मा तक नहीं लेन दियो? तय न मूर्खता को काम करयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","तुम लोगों की हानि करन की शक्ति मोरो हाथ म त हय; पर तुम्हरो बाप को परमेश्वर न मोरो सी बीती हुयी रात म कह्यो, ‘सावधान रह्य, याकूब सी न त भलो कह्यजो न बुरो।’ ");
INSERT INTO lbm_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","मोख पता हय कि, अब तय अपनो बाप को घर म बड़ो उत्सुक सी चल्यो आयो हय, पर तय न मोरो घर को देवतावों ख कहाली चोर ख लायो?” ");
INSERT INTO lbm_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकूब न लाबान ख उत्तर दियो, “मय यो सोच क डर गयो होतो कि कही तय अपनी टुरियों ख मोरो सी छीन न ले। ");
INSERT INTO lbm_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","जो कोयी जवर तोरो अपनो देवतावों की मूर्ति मिलेंन, ऊ जीन्दो नहीं बचेंन। मोरो जवर तोरो जो कुछ निकले, ओख भाऊ बन्धुवों को आगु पहिचान क ले ले।” कहालीकि याकूब नहीं जानत होतो कि राहेल घर को देवतावों की मूर्तियां चोर क आयी हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","यो सुन क लाबान याकूब को तम्बू म गयो; ओको बाद ऊ लिआ को तम्बू म गयो, अऊर तब ऊ दोयी दासियों को तम्बूवों म गयो; पर ओख मूर्तियां नहीं मिली। ओको बाद ऊ लिआ को तम्बू सी बाहेर निकल्यो अऊर राहेल को तम्बू म आयो। ");
INSERT INTO lbm_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल त घर को देवतावों की मूर्तियां ख ऊंट को ऊपर को कपड़ा म लूकाय क उन्को पर बैठी होती। लाबान न ओको पूरो तम्बू म ढूंढ्यो पर उन्ख नहीं पायो। ");
INSERT INTO lbm_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेल न अपनो बाप सी कह्यो, “हे मोरो प्रभु; येको सी गुस्सा मत हो कि मय तोरो आगु नहीं उठी; कहालीकि मय मासिक धर्म सी हय।” यो तरह लाबान न ढूंढ्यो पर ओख घर को देवतावों की मूर्तियां नहीं मिली। ");
INSERT INTO lbm_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तब याकूब गुस्सा म आय क लाबान सी झगड़ा करन लग्यो, अऊर कह्यो, “मोरो का अपराध हय? मोरो का पाप हय कि तय न इतनो गुस्सा म आय क मोरो पीछा करयो हय? ");
INSERT INTO lbm_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","तय न जो मोरो पूरो सामान की तलाशी ली, त तोख अपनो घर को पूरो सामान म सी का मिल्यो? कुछ मिल्यो होना त ओख इत अपनो अऊर मोरो भाऊवों को आगु रख दे, अऊर हि हम दोयी को बीच न्याय करे। ");
INSERT INTO lbm_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","इन बीस सालों तक मय तोरो जवर रह्यो; इन म न त तोरी शेरी मेंढियों को गर्भ गिरयो, अऊर न तोरो मेंढा को मांस मय न कभी खायो। ");
INSERT INTO lbm_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जो मेंढियों ख जंगली जनावर मार डालत रह्य ओख मय तोरो जवर नहीं लात रह्य, अऊर मय खुद ऊ हानि को पूर्ति करत होतो; मेंढियों की चोरी चाहे रात ख हो, या दिन ख, तय मोरो सीच ओकी पूरी पूर्ति करवात होतो। ");
INSERT INTO lbm_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मोरी त असी दशा होती कि दिन की तपन अऊर रात की ठंडी सी मय मरयो जात होतो; अऊर मोरी नींद मोरी आंखी सी भग जात रह्य। ");
INSERT INTO lbm_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","मय बीस साल तक तोरो घर म रह्यो; चौदा साल त मय न तोरी दोयी टुरियों लायी, अऊर छय साल तोरी शेरी मेंढियों लायी सेवा करी; अऊर तय न मोरी मजूरी ख दस बार बदल डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","मोरो बाप को परमेश्वर, मतलब अब्राहम को परमेश्वर, जेको डर इसहाक भी मानय हय, यदि मोरो पक्ष म नहीं होतो त तय जरूरच मोख खाली हाथ बिदा कर देतो। मोरो दु:ख अऊर मोरो हाथों को परिश्रम ख देख क परमेश्वर न बीती हुयी रात म तोख डाट्यो।” ");
INSERT INTO lbm_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबान न याकूब सी कह्यो, “हि टुरियां त मोरोच आय, अऊर हि बच्चा भी मोरोच आय, अऊर हि शेरी मेंढियां भी मोरीच आय, अऊर जो कुछ तोख दिखय हय ऊ सब मोरोच आय। पर अब मय अपनी इन टुरियों, अऊर इन्की सन्तान सी का कर सकू हय? ");
INSERT INTO lbm_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","अब आव, मय अऊर तय हम दोयी आपस म वाचा करबो, अऊर ऊ वाचा मोरो अऊर तोरो बीच याद रहन लायी हम गोटा को एक खम्भा बनायबो।” ");
INSERT INTO lbm_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","तब याकूब न एक गोटा ले क ओको खम्भा खड़ो करयो। ");
INSERT INTO lbm_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","तब याकूब न अपनो भाऊ बन्धुवों सी कह्यो, “गोटा जमा करो,” यो सुन क उन्न गोटा जमा कर क् एक ढेर लगायो, अऊर उच ढेर को जवर उन्न जेवन करयो। ");
INSERT INTO lbm_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ऊ ढेर को नाम लाबान न त यज्रसहादुथा रख्यो, पर याकूब न गिलियाद रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान न कह्यो, “यो ढेर अज सी मोरो अऊर तोरो बीच साक्षी रहेंन।” यो वजह ओको नाम गिलियाद रख्यो गयो, ");
INSERT INTO lbm_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","तब लाबान न कह्यो, “जब हम एक दूसरो सी अलग रह्यो तब यहोवा मोरी अऊर तोरी देखभाल करतो रह्यो, येकोलायी ऊ जागा को नाम मिज़पा भी रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","तब लाबान न कह्यो, “यदि तय मोरी टुरियों ख दु:ख दे, या उन्को अलावा अऊर दूसरी बाईयां सी बिहाव कर ले, त हमरो संग कोयी आदमी त नहीं रहेंन; पर देख, मोरो तोरो बीच म परमेश्वर साक्षी रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","तब लाबान न याकूब सी कह्यो, “यो ढेर ख देख अऊर यो खम्भा ख भी देख, जिन्ख मय न अपनो अऊर तोरो बीच म खड़ो करयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","यो ढेर अऊर यो खम्भा दोयी या बात को गवाह रहे कि यो ढेर ख पार कर क् तोरो जवर हानि करन को बिचार सी मय नहीं आऊं, अऊर तय यो ढेर अऊर खम्भा ख पार कर क् मोरो जवर नहीं आजो। ");
INSERT INTO lbm_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहम अऊर नाहोर अऊर उन्को बाप; इन तीनो को जो परमेश्वर हय, उच हम दोयी को बीच न्याय करे।” तब याकूब न ओकी कसम खायी जेको डर ओको बाप इसहाक मानत होतो; ");
INSERT INTO lbm_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","अऊर याकूब न ऊ पहाड़ी पर जनावर की बलि चढ़ायी, अऊर अपनो भाऊ बन्धुवों ख जेवन करन लायी बुलायो; तब उन्न जेवन कर क् पहाड़ी पर रात बितायी। ");
INSERT INTO lbm_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","दूसरो दिन भुन्सारे ख लाबान उठ्यो, अऊर अपनो नातियों को चुम्मा ले क टुरियों ख अलबिदा बोल क उन्ख आशीर्वाद दियो, अऊर अपनो घर ख चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूब न भी अपनी रस्ता लियो अऊर परमेश्वर को दूत ओख आय मिल्यो ");
INSERT INTO lbm_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ओख देखतोच याकूब न कह्यो, “यो त परमेश्वर को दल हय।” येकोलायी ओन ऊ जागा को नाम महनैम रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","तब याकूब न सेईर देश म, यानेकि एदोम देश म, अपनो भाऊ एसाव को जवर अपनो आगु खबरी ख भेज दियो, ");
INSERT INTO lbm_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","अऊर याकूब न खबर भेजन वालो ख या आज्ञा दी, “मोरो प्रभु एसाव सी यो कह्यजो : तोरो दास याकूब तोरो सी यो कह्य हय कि मय लाबान को यहां परदेशी होय क अब तक रह्यो; ");
INSERT INTO lbm_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","अऊर मोरो जवर गाय बईल, गधा, शेरी मेंढी, अऊर दास दासियां हंय : अऊर मय न अपनो प्रभु को जवर येकोलायी सन्देश भेज्यो हय कि तोरो अनुग्रह कि नजर मोरो पर हो।” ");
INSERT INTO lbm_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","हि दूत याकूब को जवर वापस आय क कहन लग्यो, “हम तोरो भाऊ एसाव को जवर गयो होतो, अऊर ऊ भी तोरो सी मुलाखात करन ख चार सौ आदमी को संग चल्यो आय रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","तब याकूब बहुत डर गयो, अऊर मुसीबत म पड़्यो; अऊर यो सोच क अपनो संगियों को, अऊर शेरी मेंढियों को, गाय बईल को, अऊर ऊंटों ख भी अलग कर क दोय दल बनायो, ");
INSERT INTO lbm_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","कि यदि एसाव आय क पहिलो दल ख मारन लगे, त दूसरो दल भग क बच जायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","तब याकूब न परमेश्वर सी कह्यो, “हे मोरो दादा अब्राहम को परमेश्वर, हे मोरो बाप इसहाक को परमेश्वर, तय न त मोरो सी कह्यो होतो कि अपनो देश अऊर जन्मभूमि म लौट जा, अऊर मय तोरी भलायी करूं : ");
INSERT INTO lbm_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तय न जो जो काम अपनी करुना अऊर सच्चायी सी अपनो दास को संग करयो हंय, कि मय जो अपनी छड़ीच ले क या यरदन नदी को पार उतर आयो, अऊर अब मोरो दोय दल होय गयो हंय; तोरो असो असो कामों म सी मय एक को भी लायक त नहाय। ");
INSERT INTO lbm_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","मोरी बिनती सुन क मोख मोरो भाऊ एसाव को हाथ सी बचा : मय त ओको सी डरू हय, कही असो नहीं होय कि ऊ आय क मोख अऊर माय को संग टुरावों ख भी मार डाले। ");
INSERT INTO lbm_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","तय न त कह्यो हय कि मय निश्चय तोरी भलायी करूं, अऊर तोरो वंश ख समुन्दर की रेतु को कन को जसो बहुत करूं, जो बहुतायत को मारे गिन्यो नहीं जाय सकय।” ");
INSERT INTO lbm_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","याकूब न ऊ दिन रात उतच बितायी; अऊर जो कुछ ओको जवर होतो ओको म सी अपनो भाऊ एसाव की भेंट लायी छांट छांट क निकाल्यो; ");
INSERT INTO lbm_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","यानेकि दोय सौ मादा शेरियां, अऊर बीस नर बकरा, अऊर दोय सौ मादा मेंढी, अऊर बीस नर मेंढा, ");
INSERT INTO lbm_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","अऊर बच्चा समेत दूध देन वाली तीस मादा ऊंट, अऊर चालीस गाय, दस बईल, अऊर बीस मादा गधी अऊर उन्को दस बच्चा। ");
INSERT INTO lbm_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","इन्क याकूब न झुण्ड झुण्ड म कर क्, अपनो दासों ख सौंप क उन्को सी कह्यो, “मोरो आगु बढ़ जावो; अऊर झुण्डों को बीच बीच म दूरी रखो।” ");
INSERT INTO lbm_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","तब याकूब न अगलो झुण्ड को रख वालो ख या आज्ञा दी, “जब मोरो भाऊ एसाव तोख मिले, अऊर पूछन लगे, ‘तय कोन्को दास आय, अऊर कित जावय हय, अऊर हि जो तोरो आगु आगु हंय, हि कोन्को जनावर आय?’ ");
INSERT INTO lbm_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तब कह्यजो, ‘यो तोरो दास याकूब को जनावर हंय। हे मोरो प्रभु एसाव, हि भेंट देन लायी तोरो जवर भेज्यो गयो हंय, अऊर तोरो दास खुदच हमरो पीछू पीछू आय रह्यो हय।’” ");
INSERT INTO lbm_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","अऊर याकूब न दूसरो अऊर तीसरो रख वालो ख भी, बल्की उन पूरो ख जो झुण्डों को पीछू पीछू होतो असीच आज्ञा दी कि जब एसाव तुम ख मिले तब योच तरह ओको सी कहो। ");
INSERT INTO lbm_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","अऊर यो भी कहो, “तोरो दास याकूब हमरो पीछू पीछू आय रह्यो हय।” कहालीकि ओन यो सोच्यो कि या भेंट जो मोरो आगु आगु जावय हय, येको द्वारा मय एसाव को गुस्सा ख शान्त कर क् तब ओको दर्शन करूं; होय सकय हय कि ऊ मोरो सी खुश होय जाये। ");
INSERT INTO lbm_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","येकोलायी ओन झुण्ड कि भेंट याकूब सी पहिलेच भेज दी, अऊर ऊ खुद ऊ रात ख छावनी म रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","उच रात ख याकूब उठ्यो अऊर अपनी दोयी पत्नियों, दोयी दासियों अऊर ग्यारा टुरावों ख संग ले क घाट सी यब्बोक नदी को ओन पार उतर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","याकूब न उन्ख नदी को ऊ पार उतार दियो, अऊर जो कुछ याकूब को जवर होतो सब कुछ उतार दियो। ");
INSERT INTO lbm_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","अऊर याकूब खुद अकेलो रह्य गयो; तब कोयी आदमी आय क भुन्सारो तक याकूब सी कुश्ती करतो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जब ऊ आदमी न देख्यो कि मय याकूब ख हराय नहीं सकू, तब ओन याकूब को जांघ की नस ख छूयो, तब ऊ समय याकूब को जांघ की नस अपनी जागा सी हट गयी। ");
INSERT INTO lbm_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","तब ऊ आदमी न कह्यो, “मोख जान दे, कहालीकि सुबेरे होन वाली हय,” याकूब न कह्यो, “जब तक तय मोख आशीर्वाद नहीं देजो, तब तक मय तोख जान नहीं देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","अऊर ओन याकूब सी पुच्छ्यो, “तोरो नाम का हय?” ओन कह्यो, “याकूब।” ");
INSERT INTO lbm_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ओन कह्यो, “तोरो नाम अब याकूब नहाय, पर इस्राएल होयेंन, कहालीकि परमेश्वर सी अऊर आदमियों सी भी युद्ध कर क् तय न विजय हासिल करी हय।” ");
INSERT INTO lbm_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","याकूब न कह्यो, “मय बिनती करू हय, मोख अपनो नाम बता।” ओन कह्यो, “तय मोरो नाम कहाली पूछय हय?” तब ओन याकूब ख उतच आशीर्वाद दियो। ");
INSERT INTO lbm_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","तब याकूब न ऊ जागा को नाम पनीएल रख्यो; कहालीकि ओन कह्यो, “मय न परमेश्वर ख आमने सामने देखनो पर भी मय जीन्दो रह्यो।” ");
INSERT INTO lbm_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","जब याकूब पनीएल सी जान लग्यो त सूरज निकल गयो, अऊर याकूब की जांघ की नस सुजन को वजह लंगड़ावत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","इस्राएली जाति को लोग अज तक जनावरों को जांघ की नस ख जो जांघ को जोड़ो पर होवय हय, ओख नहीं खावय; कहालीकि ऊ आदमी न याकूब की जांघ म जांघ की नस को छूयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकूब न आंखी उठाय क यो देख्यो कि एसाव चार सौ आदमी ख संग लियो हुयो आय रह्यो हय। तब ओन बच्चा ख अलग अलग बाट क लिआ : राहेल अऊर दोयी दासियों ख उन्को बच्चा सौंप दियो। ");
INSERT INTO lbm_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","अऊर ओन सब सी आगु दोयी दासियों अऊर उन्को बच्चा ख, उन्को पीछू लिआ ख ओको बच्चा को संग, अऊर सब सी पीछू राहेल अऊर यूसुफ ख खड़ो करयो, ");
INSERT INTO lbm_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","अऊर याकूब खुद उन सब को आगु आगु गयो जब तक ऊ अपनो भाऊ को जवर नहीं पहुंच गयो, तब तक ऊ जमीन पर झुक क सात बात ओख दण्डवत करतो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","तब एसाव ओको सी भेंट करन ख दौड़्यो, अऊर ओन याकूब ख दिल सी लगाय क, ओख गरो लगायो अऊर चुम्मा लियो; तब एसाव अऊर याकूब रोवन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","तब एसाव न आंखी उठाय क बाईयों अऊर बच्चा ख देख्यो, अऊर याकूब सी पुच्छ्यो, “हि जो तोरो संग हंय हि कौन आय?” याकूब न कह्यो, “हि तोरो दास को बच्चा आय, जिन्ख परमेश्वर न अनुग्रह कर क् मोख दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","तब दासियां अऊर उन्को बच्चा जवर आय क झुक क एसाव ख दण्डवत करयो; ");
INSERT INTO lbm_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","योच तरह लिआ अऊर ओको बच्चा जवर आयो अऊर उन्न झुक क एसाव ख दण्डवत करयो; आखरी म यूसुफ अऊर राहेल न भी जवर आय क दण्डवत करयो। ");
INSERT INTO lbm_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","तब एसाव न पुच्छ्यो, “तोरो यो बड़ो झुण्ड मोख मिल्यो, येको का मतलब हय?” याकूब न कह्यो, “हि तुम्ख मोरी भेंट हंय जेको सी तुम मोख स्वीकार कर सको।” ");
INSERT INTO lbm_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसाव न कह्यो, “हे मोरो भाऊ, मोरो जवर त बहुत हय; जो कुछ तोरो हय ऊ तोरोच रहे।” ");
INSERT INTO lbm_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूब न कह्यो, “नहीं नहीं, यदि तोरो अनुग्रह मोरो पर हो, त मोरी भेंट ग्रहन कर; कहालीकि मय न तोरो दर्शन पा क, मानो परमेश्वर को दर्शन पायो हय, अऊर तय मोरो सी प्रसन्न भयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","येकोलायी यो भेंट जो तोख भेजी गयी हय, ओख ग्रहन कर; कहालीकि परमेश्वर न मोरो पर अनुग्रह करयो हय, अऊर मोरो जवर बहुत हय।” जब याकूब न ओको सी बहुत आग्रह करयो, तब एसाव न भेंट ख ग्रहन करयो। ");
INSERT INTO lbm_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","तब एसाव न कह्यो, “आव, हम अपनी रस्ता पर आगु चलबो; अऊर मय तोरो आगु आगु चलूं।” ");
INSERT INTO lbm_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","याकूब न कह्यो, “हे मोरो स्वामी, तय त जानय हय कि मोरो बच्चा कमजोर हंय, मोरो संग दूध देन वाली शेरी मेंढियां अऊर गाय हंय; जिन्की देखभाल मोख करनो पड़य हय, यदि मय इन्क एक दिन भी ज्यादा दूर चलन लायी विवश करू हय, त सब को सब मर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","येकोलायी मोरो स्वामी अपनो दास को आगु बढ़ जाये, अऊर मय इन जनावरों की गति को अनुसार जो मोरो आगु हंय, अऊर बच्चां की गति को अनुसार धीरू धीरू आगु चल क सेईर नगर म अपनो स्वामी को जवर पहुंचूं।” ");
INSERT INTO lbm_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसाव न कह्यो, “त मय अपनो संगियों म सी कुछ ख तोरो संग छोड़ जाऊं।” तब याकूब न कह्यो, “येकी का जरूरत हय? इतनोच बहुत हय कि मोरो स्वामी की अनुग्रह की नजर मोरो पर बनी रहे।” ");
INSERT INTO lbm_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","तब एसाव उच दिन सेईर नगर चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","पर याकूब उत सी निकल क सुक्कोत नगर ख गयो, अऊर उत अपनो लायी एक घर, अऊर जनावरों लायी कोठा बनायो। योच वजह ऊ जागा को नाम सुक्कोत पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","याकूब पद्दनराम प्रदेश सी निकल क, कनान देश को शकेम नगर को जवर अच्छो सी पहुंच क ओन नगर को जवर तम्बू खड़ो करयो। ");
INSERT INTO lbm_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","अऊर जो जमीन पर याकूब न तम्बू खड़ो करयो, ओख ओन शकेम को बाप हमोर को टुरावों को हाथ सी एक सौ चांदी को सिक्का म लेय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","उत याकूब न एक वेदी बनाय क ओको नाम एल-एलोहे-इस्राएल रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","एक दिन लिआ की टुरी दीना, जो याकूब सी पैदा भयी होती, वा कनान देश की टुरियों सी भेंट करन ख गयी। ");
INSERT INTO lbm_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","तब ऊ देश को प्रधान हमोर होतो हमोर को टुरा को नाम शकेम होतो ऊ हिव्वी जाति को होतो, शकेम न दीना ख पकड़ लियो अऊर अपनो संग शारीरिक सम्बन्ध बनाय क ओख भ्रष्ट कर डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","तब शकेम को मन याकूब की टुरी दीना सी लग गयो, अऊर ओन दीना सी प्रेम की बाते करी, अऊर ओको सी प्रेम करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","तब शकेम न अपनो बाप हमोर सी कह्यो, “मोख या टुरी ख मोरी पत्नी को रूप म दिलाय दे।” ");
INSERT INTO lbm_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","अऊर याकूब न सुन्यो कि शकेम न मोरी टुरी दीना ख अशुद्ध कर डाल्यो हय; पर याकूब को टुरा ऊ समय जनावरों को संग मैदान म होतो, येकोलायी याकूब उन्को आनो तक चुप रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","तब शकेम को बाप हमोर निकल क याकूब सी बातचीत करन लायी ओको जवर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","तब याकूब को टुरावों न दीना को बारे म असो सुन्यो त मैदान सी बहुत उदास अऊर गुस्सा सी आयो; कहालीकि शकेम न याकूब की टुरी को संग सोय क इस्राएली समाज म मुर्खतापूर्न काम करयो होतो, असो करनो बहुत गलत होतो ");
INSERT INTO lbm_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोर न उन सब सी कह्यो, “मोरो टुरा शकेम तुम्हरी टुरी सी बहुत प्रेम करन लग्यो हय, कृपया अपनी टुरी ख पत्नी को रूप म शकेम ख प्रदान कर देवो। ");
INSERT INTO lbm_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","अऊर हम लोगों सी बिहाव को सम्बन्ध बान्धो; अपनी बेटियां हम्ख देवो, अऊर हमरी बेटियां तुम लेवो। ");
INSERT INTO lbm_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","तब तुम हमरो संग यो देश म रह्य सको; यो देश को दरवाजा तुम्हरो लायी खुल जायेंन, यहां रहो अऊर व्यापार करो, अऊर धन सम्पत्ति कमाय लेवो।” ");
INSERT INTO lbm_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शकेम न भी दीना को बाप अऊर भाऊवों सी कह्यो, “यदि मोरो पर तुम लोगों की अनुग्रह की नजर हो, त जो कुछ तुम मोरो सी कहो, ऊ मय तुम्ख देऊं। ");
INSERT INTO lbm_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","तुम मोरो सी कितनो भी ज्यादा दाम अऊर भेंट मांगो, उतनो मय तुम्ख तुम्हरो वचन को अनुसार देऊं; पर तुम केवल मोख अपनी टुरी पत्नी को रूप म प्रदान कर देवो।” ");
INSERT INTO lbm_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","तब यो सोच क कि शकेम न हमरी बहिन दीना ख अशुद्ध करयो हय, याकूब को टुरावों न शकेम अऊर ओको बाप हमोर ख छल को संग यो उत्तर दियो, ");
INSERT INTO lbm_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","हि बोल्यो “हम असो काम नहीं कर सकजे कि कोयी बिना खतना वालो आदमी ख हम अपनी बहिन देबो, कहालीकि येको सी हमरो अपमान होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","हम केवल यो शर्त पर तुम्हरी बात मान सकजे हंय कि हमरो जसो तुम्हरी जाति को हर एक आदमी को खतना करयो जाये। ");
INSERT INTO lbm_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तब हम अपनी बेटियां तुम लोगों ख देबो, अऊर तुम्हरी बेटियां हम अपनाय लेबो, अऊर तुम्हरो संग बस्यो भी रह्यबोंन, अऊर हम दोयी एकच जाति को आदमी बन जाबो। ");
INSERT INTO lbm_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","पर यदि तुम हमरी बात नहीं मानो अऊर खतना नहीं करो, त हम अपनी टुरी ख ले क इत सी चली जाबो।” ");
INSERT INTO lbm_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","उन्की यो बात पर हमोर अऊर ओको टुरा शकेम खुश भयो। ");
INSERT INTO lbm_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","अऊर युवक शकेम न ओकी मांग ख पूरो करनो म देर नहीं करयो, कहालीकि ऊ याकूब की टुरी ख बहुत चाहत होतो। ऊ अपनो बाप को पूरो परिवार म बहुत ज्यादा महत्वपूर्न आदमी होतो। ");
INSERT INTO lbm_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","येकोलायी हमोर अऊर ओको टुरा शकेम अपनो नगर को फाटक को जवर जाय क नगर म रहन वालो ख यो समझान लग्यो, ");
INSERT INTO lbm_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“हि आदमी हमरो संग मिलझुल क रहनो चाहवय हंय, येकोलायी उन्ख यो देश म रह्य क लेन देन करन देवो; देखो, यो देश की जमीन उन्को लायी भी बहुत हय; तब हम लोग उन्की टुरियों सी भी बिहाव कर लेबो, अऊर अपनी टुरियों ख भी उन्ख दियो करबो। ");
INSERT INTO lbm_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","हि लोग केवल यो बात पर हमरो संग रहन लायी अऊर एकच जाति को लोग होय जान लायी राजी हंय कि उन्को जसो हमरो सब आदमियों को भी खतना करयो जाये। ");
INSERT INTO lbm_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","तब उन्की शेरी मेंढियां, अऊर गाय बईल अऊर उन्को पूरो जनावर अऊर धन सम्पत्ति हमरी नहीं होय जायेंन? इतनोच करे कि हम लोग उन्की बात मान ले, त हि हमरो संग रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","येकोलायी जितनो ऊ नगर की फाटक सी निकलत होतो, उन पूरो न हमोर की अऊर ओको टुरा शकेम की बात मानी; अऊर हर एक आदमी को खतना करयो गयो, जितनो ऊ नगर की फाटक सी निकलत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीसरो दिन, जब खतना करयो वालो लोग दु:ख म पड़्यो होतो, तब असो भयो कि शिमोन अऊर लेवी नाम को याकूब को दोय टुरावों न, जो दीना को भाऊ होतो, अपनी अपनी तलवार धर क ऊ नगर म बेधड़क घुस क सब आदमियों ख मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","हमोर अऊर ओको टुरा शकेम ख उन्न तलवार सी मार डाल्यो, अऊर दीना ख शकेम को घर सी निकाल क लिजायो। ");
INSERT INTO lbm_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकूब को दूसरो टुरावों न मार डालन पर भी उन्न नगर ख येकोलायी लूट लियो कि ऊ नगर म उन्की बहिन अशुद्ध करी गयी होती। ");
INSERT INTO lbm_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","उन्न शेरी मेंढी गाय बईल, गधा, अऊर नगर अऊर मैदान म जितनो धन होतो लूट लियो। ");
INSERT INTO lbm_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","उन सब ख, अऊर उन्को बाल बच्चा, अऊर उन्की बाईयों ख भी लिजायो, अऊर घर घर म जो कुछ होतो उन्ख भी उन्न लूट लियो। ");
INSERT INTO lbm_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","तब याकूब न शिमोन अऊर लेवी सी कह्यो, “तुम न जो यो देश को निवासी म कनानियों अऊर परिज्जी जाति को मन म मोरो खिलाफ नफरत पैदा करायी हय, येको सी तुम न मोख संकट म डाल्यो हय, कहालीकि मोरो संग त थोड़ो सोच लोग हंय; येकोलायी अब हि जमा होय क मोरो पर हमला करेंन, अऊर मोख मार डालेंन, त मय अपनो घराना सहीत नाश होय जाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","उन्न कह्यो, “का ऊ हमरी बहिन को संग वेश्या को जसो बर्ताव करे?” ");
INSERT INTO lbm_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","तब परमेश्वर न याकूब सी कह्यो, “इत सी निकल क बेतेल नगर ख जा, अऊर उतच रह्यजो; अऊर उत परमेश्वर लायी वेदी बना, जेन तोख ऊ समय दर्शन दियो जब तय अपनो भाऊ एसाव को डर सी भगत होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","तब याकूब न अपनो घराना सी, अऊर उन सब सी भी कह्यो जो ओको संग होतो, “तुम्हरो बीच म जो परायो देवता हंय, उन्ख निकाल फेको; अऊर अपनो अपनो ख शुद्ध करो, अऊर अपनो कपड़ा बदल डालो; ");
INSERT INTO lbm_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","अऊर आवो, हम इत सी निकल क बेतेल नगर ख जाबो; उत मय परमेश्वर लायी एक वेदी बनाऊं, जेन संकट को दिन म मोरी सुन ली, अऊर जो रस्ता सी मय चलत होतो, ओको म मोरो संग रह्यो।” ");
INSERT INTO lbm_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","जितनो दूसरो देवतावों की मूर्तियां उन्को जवर होती, अऊर जितनो कुण्डल उन्को कानो म होतो, उन पूरो ख उन्न याकूब ख दे दियो; अऊर याकूब न उन्ख शकेम नगर को जवर बांझ झाड़ को खल्लो गाड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","तब याकूब अऊर ओको टुरावों न प्रस्थान करयो; तब उन्को चारयी तरफ को नगर निवासियों को मन म परमेश्वर को असो डर समाय गयो कि उन्न याकूब को टुरावों को पीछा नहीं करयो। ");
INSERT INTO lbm_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकूब उन पूरो को संग जो ओको संग होतो, कनान देश को लूज नगर म आयो। ऊ नगर बेतेल भी कहलावय हय। ");
INSERT INTO lbm_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","उत याकूब न एक वेदी बनायी, अऊर ऊ जागा को नाम एलबेतेल रख्यो; कहालीकि जब ऊ अपनो भाऊ को डर सी भग्यो जात होतो तब परमेश्वर न खुद ख ओको पर उतच प्रगट करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","अऊर रिबका की दूध पिलान वाली दाई दबोरा मर गयी, अऊर बेतेल नगर को बांझ झाड़ को खल्लो को भाग म ओख माटी दी गयी, अऊर ऊ बांझ झाड़ को नाम अल्लोनबक्कूत रख्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","तब याकूब को पद्दनराम सी आन को बाद परमेश्वर न दूसरी बार ओख दर्शन दे क आशीष दी। ");
INSERT INTO lbm_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","अऊर परमेश्वर न ओको सी कह्यो, “अब तक तोरो नाम याकूब रह्यो हय, पर आगु ख तोरो नाम याकूब नहीं रहेंन, पर तय इस्राएल कहलायजो।” यो तरह परमेश्वर न याकूब को नाम इस्राएल रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","तब परमेश्वर न ओको सी कह्यो, “मय सर्वशक्तिमान ईश्वर आय। तय फूल फल अऊर बढ़े; अऊर तोरो सी एक जाति अऊर जातियों की मण्डली भी पैदा होयेंन, अऊर तोरो वंश म राजा पैदा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","अऊर जो देश मय न अब्राहम अऊर इसहाक ख दियो हय, उच देश तोख देऊ हय, अऊर तोरो पीछू तोरो वंश ख भी देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","तब परमेश्वर ऊ जागा म, जित ओन याकूब सी बाते करी, ओको जवर सी ऊपर चढ़ गयो। ");
INSERT INTO lbm_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","अऊर जो जागा म परमेश्वर न याकूब सी बाते करी, उत याकूब न गोटा को एक खम्भा खड़ो करयो, अऊर ओको पर अंगूर रस अऊर जैतून को तेल डाल दियो। ");
INSERT INTO lbm_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","जित परमेश्वर न याकूब सी बाते करी, ऊ जागा को नाम ओन बेतेल रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","तब याकूब अऊर ओको परिवार बेतेल नगर सी जान लग्यो। अऊर एप्राता नगर थोड़ोच दूर रह्य गयो होतो कि राहेल ख बच्चा पैदा होन की बड़ी पीड़ा उठन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","जब ओख बड़ी बड़ी पीड़ा उठत होती तब सुईन न ओको सी कह्यो, “मत डर; अब की भी बार तोख टुराच होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","तब असो भयो कि वा मर गयी, अऊर जीव निकलतो निकलतो ओन ऊ टुरा को नाम बेनोनी रख्यो; पर ओको बाप न ओको नाम बिन्यामीन रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","राहेल त मर गयी, अऊर एप्राता मतलब बैतलहम की रस्ता म ओख माटी दी गयी। ");
INSERT INTO lbm_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","याकूब न ओकी कब्र पर एक खम्भा खड़ो करयो : राहेल की कब्र को ऊ खम्भा अज तक खड़ो अऊर बन्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","तब इस्राएल आगु बड़तो गयो, अऊर एदेर नाम की मीनार को आगु बढ़ क अपनो तम्बू खड़ो करयो। ");
INSERT INTO lbm_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","जब इस्राएल ऊ देश म बस्यो होतो, तब एक दिन असो भयो कि रूबेन न जाय क अपनो बाप की रखैल बिल्हा को संग कुकर्म करयो; अऊर या बात इस्राएल ख मालूम भय गयी। याकूब को बारा टुरा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","उन म सी लिआ : को टुरा हि होतो; रूबेन याकूब को बड़ो टुरा शिमोन, लेवी, यहूदा, इस्साकार, अऊर जबूलून। ");
INSERT INTO lbm_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","अऊर राहेल को टुरा हि होतो; मतलब यूसुफ अऊर बिन्यामीन। ");
INSERT INTO lbm_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","अऊर राहेल की दासी बिल्हा को टुरा हि होतो; मतलब दान अऊर नप्ताली। ");
INSERT INTO lbm_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","अऊर लिआ : की दासी जिल्पा को टुरा हि होतो : मतलब गाद, अऊर आशेर। याकूब को हिच टुरा भयो, जो ओको सी पद्दनराम क्षेत्र म पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकूब मम्रे म, जो किर्यतर्बा मतलब हेब्रोन हय, जित अब्राहम अऊर इसहाक परदेशी होय क रह्यो होतो, अपनो बाप इसहाक को जवर आयो। ");
INSERT INTO lbm_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक की उमर एक सौ अस्सी साल की भयी। ");
INSERT INTO lbm_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","अऊर इसहाक को जीव छूट गयो अऊर ऊ मर गयो, अऊर ऊ बूढ्ढा अऊर पूरी उमर को होय क अपनो लोगों म जाय मिल्यो; अऊर ओको टुरा एसाव अऊर याकूब न ओख माटी दी। ");
INSERT INTO lbm_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव जो एदोम भी कहलावय हय, ओकी यो वंशावली हय। ");
INSERT INTO lbm_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसाव न त कनान देश की टुरियां सी बिहाव कर लियो; मतलब हित्ती एलोन की टुरी आदा ख, अऊर ओहोलीबामा ख जो अना की टुरी अऊर हिव्वी सिबोन की नातिन होती। ");
INSERT INTO lbm_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","तब ओन इश्माएल की टुरी बासमत ख भी, जो नबायोत की बहिन होती, बिहाव कर लियो। ");
INSERT INTO lbm_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","आदा न एसाव को द्वारा एलीपज ख, अऊर बासमत न रूएल ख जनम दियो। ");
INSERT INTO lbm_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","अऊर ओहोलीबामा न यूश, अऊर यालाम, अऊर कोरह ख पैदा करयो। एसाव को हिच टुरा कनान देश म पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","तब एसाव अपनी पत्नियों अऊर टुरा टुरियों, अऊर घर को सब प्रानियों, अपनी शेरी मेंढियों, गाय बईल अऊर सब जनावरों, निदान अपनी पूरी जायजाद ख, जो ओन कनान देश म हासिल करी होती, ले क अपनो भाऊ याकूब को जवर सी दूसरो देश ख चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","कहालीकि उन्की जायजाद इतनी भय गयी होती कि हि जमा नहीं रह्य सक्यो; अऊर जनावरों को बहुत होनो को वजह ऊ देश म, जित हि परदेशी होय क रहत होतो, हि उत समाय नहीं सक्यो। ");
INSERT INTO lbm_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","एसाव जो एदोम भी कहलावय हय, सेईर नाम की पहाड़ी देश म रहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईर नाम की पहाड़ी देश म रहन वालो एदोमियों को मूल आदमी एसाव की वंशावली या आय। ");
INSERT INTO lbm_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव को टुरावों को नाम यो हंय; मतलब एसाव की पत्नी आदा को टुरा एलीपज, अऊर वाच एसाव की पत्नी बासमत को टुरा रूएल। ");
INSERT INTO lbm_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीपज को हि टुरा भयो; मतलब तेमान, ओमार, सपो, गाताम, अऊर कनज। ");
INSERT INTO lbm_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसाव को टुरा एलीपज की तिम्रा नाम की एक रखैल होती, जेन एलीपज को द्वारा अमालेक ख जनम दियो : एसाव की पत्नी आदा को वंश म हिच भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएल को हि टुरा भयो; मतलब नहत, जेरह, शम्मा, अऊर मिज्जा : एसाव की पत्नी बासमत को वंश म हिच भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ओहोलीबामा जो एसाव की पत्नी अऊर सिबोन की नातिन अऊर अना की टुरी होती, ओको हि टुरा भयो : मतलब ओन एसाव को द्वारा यूश, यालाम अऊर कोरह ख जनम दियो। ");
INSERT INTO lbm_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","हि एसाव को वंशजों को मुखिया भयो : मतलब एसाव को बड़ो टुरा एलीपज को वंश म सी तेमान, ओमार, सपो, कनज मुखिया, ");
INSERT INTO lbm_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम, अमालेक मुखिया : एलीपज को वंश म सी, एदोम देश म हिच मुखिया भयो : अऊर हिच आदा को वंश म भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसाव को टुरा रूएल को वंश म हि भयो; मतलब नहत, जेरह, शम्मा, मिज्जा : रूएल को वंश म सी, एदोम देश म सी हि मुखिया भयो; अऊर हिच एसाव की पत्नी बासमत को वंश म भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसाव की पत्नी ओहोलीबामा को वंश म हि भयो; मतलब यूश, यालाम, कोरह, अऊर अना की टुरी ओहोलीबामा जो एसाव की पत्नी होती ओको वंश म हिच मुखिया भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","एसाव जो एदोम भी कहलावय हय, ओको वंश हिच आय, अऊर उन्को मुखिया भी हिच भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","सेईर जो होरी नाम की जाति को होतो, ओको हि टुरा एदोम देश म पहिले सी रहत होतो : लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO lbm_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर, अऊर दीशोन : एदोम देश म सेईर को हिच होरी जाति को मुखिया भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतान को टुरा, होरी अऊर हेमाम भयो; अऊर लोतान की बहिन तिम्रा होती। ");
INSERT INTO lbm_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबाल को हि टुरा भयो : आल्वान, मानहत, एबाल, शपो, अऊर ओनाम। ");
INSERT INTO lbm_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिदोन को हि टुरा भयो : अय्या, अऊर अना; या वाच अना आय जेक जंगल म अपनो बाप सिबोन को गधा ख चरावत चरावत गरम पानी को झरना मिल्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अना को दीशोन नाम को टुरा भयो, अऊर वाच अना ख ओहोलीबामा नाम की टुरी भयी। ");
INSERT INTO lbm_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोन को हि टुरा भयो : हेमदान, एश्बान, यित्रान, अऊर करान। ");
INSERT INTO lbm_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेर को हि टुरा भयो : बिल्हान, जाबान, अऊर अकान। ");
INSERT INTO lbm_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशोन को हि टुरा भयो : ऊस, अऊर अरान। ");
INSERT INTO lbm_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरी जाति को मुखिया हि भयो : लोतान, शोबाल, सिबोन, अऊर अना मुखिया, ");
INSERT INTO lbm_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन, एसेर, दीशोन; सेईर देश म होरी जाति को हिच मुखिया भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","तब जब इस्राएलियों पर कोयी राजा न राज्य नहीं करयो होतो, तब भी एदोम को देश म हि राजा भयो; ");
INSERT INTO lbm_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बोर को टुरा बेला न एदोम म राज्य करयो, अऊर ओकी राजधानी को नाम दिन्हाबा हय। ");
INSERT INTO lbm_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला को मरनो पर, बोस्रा नगर को रहन वालो जेरह को टुरा योबाब ओकी जागा पर राजा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब को मरनो पर तेमानी जाति को देश को निवासी हूशाम ओकी जागा पर राजा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","तब हूशाम को मरनो पर बदद को टुरा हदद ओकी जागा पर राजा भयो : यो उच आय जेन मिद्दानी जाति ख मोआब को देश म मार लियो, अऊर ओकी राजधानी को नाम अबीत हय। ");
INSERT INTO lbm_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदद को मरनो पर मस्रेका नगर को निवासी सम्ला ओकी जागा पर राजा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","तब सम्ला को मरनो पर शाऊल जो महा नदी को तट वालो रहोबोत नगर को होतो ऊ ओकी जागा पर राजा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शाऊल को मरनो पर अकबोर को टुरा बाल्हानान ओकी जागा पर राजा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अकबोर को टुरा बाल्हानान को मरनो पर हदर ओकी जागा पर राजा भयो : अऊर ओकी राजधानी को नाम पाऊ हय; अऊर ओकी पत्नी को नाम महेतबेल हय, जो मेजाहब की नातिन अऊर मत्रेद की टुरी होती। ");
INSERT INTO lbm_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसाव को वंशजों को मुखिया को कुलों अऊर जागा को अनुसार उन्को नाम हि आय : तिम्रा, अल्बा, यतेत मुखिया, ");
INSERT INTO lbm_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा, एला, पीनोन मुखिया, ");
INSERT INTO lbm_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज, तेमान, मिबसार मुखिया, ");
INSERT INTO lbm_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्दीएल, ईराम : एदोम वंशियों न जो देश अपनो कर लियो होतो, ओकी निवास की जागा म उन्को हिच मुखिया भयो; एदोम जाति को मूल आदमी एसाव हय। ");
INSERT INTO lbm_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब त कनान देश म रहत होतो, जित ओको बाप परदेशी होय क रहत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकूब को वंश को वृत्तान्त यो हय। यूसुफ सत्रा साल को होय क अपनो भाऊवों को संग शेरी मेंढी ख चरावत होतो; अऊर ऊ लड़का अपनो बाप की पत्नी बिल्हा अऊर जिल्पा को टुरावों को संग रह्यो करत होतो; अऊर उन्की बुरायियों को समाचार अपनो बाप को जवर बतायो करत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","याकूब अपनो सब टुरावों सी बढ़ क् यूसुफ सी प्रेम रखत होतो, कहालीकि ऊ ओको बूढ़ापा को टुरा होतो : अऊर ओन ओको लायी एक रंगबिरंगी कपड़ा बनवायो। ");
INSERT INTO lbm_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","पर जब ओको भाऊवों न देख्यो कि हमरो बाप हम सब भाऊवों सी जादा ओको सीच प्रेम रखय हय, तब हि ओको सी घृना करन लग्यो अऊर ओको संग ठीक सी बात भी नहीं करत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","यूसुफ न एक सपनो देख्यो, अऊर अपनो भाऊवों सी ओको बारे म बतायो; तब हि ओको सी अऊर भी जादा घृना करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","यूसुफ न उन्को सी कह्यो, “जो सपनो मय न देख्यो हय, ओख सुनो : ");
INSERT INTO lbm_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हम लोग खेत म गहूं को बोझा बान्ध रह्यो हय, अऊर यो देख्यो कि अचानक मोरो बोझा उठ क सीधो खड़ो भय गयो; तब तुम्हरो बोझा न मोरो बोझा ख चारयी तरफ सी घेर लियो अऊर ओख दण्डवत करयो।” ");
INSERT INTO lbm_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","तब यूसुफ को भाऊवों न यूसुफ सी कह्यो, “का सचमुच तय हमरो ऊपर राज्य करजो? या का सचमुच तय हम पर प्रभुता करजो?” येकोलायी हि ओको सपनो अऊर ओकी बातों को वजह ओको सी अऊर भी जादा घृना करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","तब यूसुफ न अऊर एक सपनो देख्यो, अऊर अपनो भाऊवों ख सपनो को बारे म बतायो, “सुनो, मय न एक अऊर सपनो देख्यो हय, कि सूरज अऊर चन्दा अऊर ग्यारा तारा मोख दण्डवत कर रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","यो सपनो ओन अपनो बाप अऊर अपनो भाऊवों ख बतायो तब ओको बाप न ओख चिल्लाय क कह्यो, “यो कसो सपनो आय जो तय न देख्यो हय? का सचमुच मय अऊर तोरी माय अऊर तोरो भाऊ सब जाय क तोरो आगु जमीन पर गिर क दण्डवत करबो?” ");
INSERT INTO lbm_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ओको भाऊ ओको सी घृना करत होतो; पर ओको बाप न ओको ऊ बातों ख याद रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ओको भाऊ अपनो बाप की शेरी मेंढी ख चरान लायी शकेम नगर ख गयो। ");
INSERT INTO lbm_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","तब याकूब न यूसुफ सी कह्यो, “तोरो भाऊ शकेम मच शेरी मेंढी चराय रह्यो होना। येकोलायी जा, मय तोख उन्को जवर भेजू हय।” ओन उन्को सी कह्यो, “जो आज्ञा मय हाजिर हय।” ");
INSERT INTO lbm_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ओन ओको सी कह्यो, “जा, अपनो भाऊवों अऊर शेरी मेंढियों को हाल देख क आव कि हि अच्छो सी त हय, तब मोरो जवर समाचार ले आव।” तब ओन ओख हेब्रोन की घाटी म बिदा कर दियो, अऊर यूसुफ शकेम म आयो। ");
INSERT INTO lbm_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","अऊर एक आदमी न ओख मैदान म इत उत भटकतो हुयो देख क ओको सी पुच्छ्यो, “तय का ढूंढय हय?” ");
INSERT INTO lbm_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ओन कह्यो, “मय अपनो भाऊवों ख ढूंढु हय। कृपया मोख बता कि हि शेरी मेंढियों ख कित चराय रह्यो हंय?” ");
INSERT INTO lbm_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ऊ आदमी न कह्यो, “हि इत सी चली गयो हय; अऊर मय न उन्ख यो कहतो सुन्यो, ‘आवो, हम दोतान नगर ख चलबो’।” येकोलायी यूसुफ अपनो भाऊवों को पीछू चल्यो, अऊर उन्ख दोतान नगर म पायो। ");
INSERT INTO lbm_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ओको भाऊवों न ओख दूर सी आतो हुयो देख्यो, त ओको जवर आन कोच पहिले ओख मार डालन की साजीश रची। ");
INSERT INTO lbm_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","अऊर हि आपस म कहन लग्यो, “देखो, ऊ सपनो देखन वालो आय रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","येकोलायी आवो, हम ओख मार क कोयी गड्डा म डाल देबो; अऊर यो कह्य देबो कि कोयी जंगली जनावर ओख खाय गयो। तब हम देखबोंन कि ओको सपनो भविष्य म कसो पूरो होवय हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","यो सुन क रूबेन न यूसुफ ख उन्को हाथ सी बचान को बिचार सी कह्यो, “हम ओख जान सी त नहीं मारबो।” ");
INSERT INTO lbm_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","तब रूबेन न उन्को सी कह्यो, “खून मत बहावों, ओख जंगल को यो गड्डा म डाल देवो, अऊर ओको पर हाथ मत उठावों।” रूबेन ओख उन्को हाथ सी छुड़ाय क बाप को जवर फिर पहुंचानो चाहत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","येकोलायी असो भयो कि जब यूसुफ अपनो भाऊवों को जवर पहुंच्यो तब उन्न ओको रंगबिरंगी को कपड़ा देख्यो, जेक ओन पहिन्यो होतो, उन्न उतार लियो; ");
INSERT INTO lbm_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","अऊर यूसुफ ख उठाय क गड्डा म डाल दियो। ऊ गड्डा सुख्यो होतो अऊर ओको म कुछ भी पानी नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","तब हि रोटी खान ख बैठ गयो; अऊर आंखी उठाय क यो देख्यो कि इश्माएलियों को एक दल ऊंटों पर सुगन्ध की चिज, बलसान, अऊर गन्धरस टंगाय क, गिलाद सी मिस्र देश ख जाय रह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तब यहूदा न अपनो भाऊवों सी कह्यो, “अपनो भाऊ ख मार डालनो सी अऊर ओको खून लुकानो सी का फायदा होयेंन? ");
INSERT INTO lbm_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","आवो, हम ओख इश्माएलियों को हाथ बेच देबो, अऊर अपनो हाथ ओको पर नहीं उठाबो; कहालीकि ऊ हमरो भाऊ अऊर हमारीच हड्डी अऊर मास आय।” अऊर ओको भाऊवों न ओकी बात मान ली। ");
INSERT INTO lbm_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","तब मिद्यानी व्यापारी उत सी होय क उन्को जवर पहुंच्यो। तब यूसुफ को भाऊवों न ओख ऊ गड्डा म सी खीच क् बाहेर निकाल्यो, अऊर इश्माएलियों को हाथ चांदी को बीस सिक्का म बेच दियो; अऊर हि यूसुफ ख मिस्र देश ले गयो। ");
INSERT INTO lbm_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","जब रूबेन गड्डा को तरफ गयो अऊर यो देख्यो कि यूसुफ गड्डा म नहाय; येकोलायी ओन अपनो कपड़ा फाड़्यो, ");
INSERT INTO lbm_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","अऊर अपनो भाऊवों को जवर जाय क कहन लग्यो, “लड़का त गड्डा म नहाय; अब मय कित जाऊं?” ");
INSERT INTO lbm_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","तब उन्न यूसुफ को कपड़ा लियो, अऊर एक बकरा ख मार क् ओको खून म ओख डुबाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","अऊर उन्न ऊ रंगबिरंगी कपड़ा ख अपनो बाप को जवर यो कह्य क भेज दियो, “यो हम्ख मिल्यो हय, तय देख क पहिचान ले कि यो तोरो टुरा को कपड़ा आय या नोहोय।” ");
INSERT INTO lbm_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ओन ओख पहिचान लियो अऊर कह्यो, “हव, यो मोरोच टुरा को कपड़ा आय; कोयी दुष्ट जनावर न ओख खाय लियो हय; सही मच यूसुफ ख तुकड़ा तुकड़ा कर दियो गयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","तब याकूब न अपनो कपड़ा फाड़्यो अऊर कमर म टाट को कपड़ा गुन्ड क, अऊर अपनो टुरा लायी बहुत दिनों तक दु:ख मनातो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ओको सब टुरा टुरियों न ओख शान्ति देन की बहुत कोशिश करी; पर ओख शान्ति नहीं मिली; अऊर ऊ योच कहतो रह्यो, “मय त दु:ख करतो हुयो अपनो टुरा को जवर मरयो हुयो कि दुनिया म उतर जाऊं।” यो तरह ओको बाप ओको लायी रोतोच रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","तब येको बाद मिद्यानियों न यूसुफ ख मिस्र म लिजाय क पोतीपर नाम को फिरौन को एक हाकिम अऊर अंगरक्षकों को प्रधान को बेच डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","उन दिनों म असो भयो कि यहूदा अपनो भाऊवों को जवर सी चली गयो, अऊर हीरा नाम को एक अदुल्लाम नगर को एक निवासी को जवर रहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","उत यहूदा न शूआ नाम को एक कनानी आदमी की टुरी ख देख्यो; अऊर ओको सी बिहाव कर क् ओको जवर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","वा गर्भवती भयी, अऊर ओको एक टुरा पैदा भयो; अऊर यहूदा न ओको नाम एर रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","वा फिर गर्भवती भयी, अऊर ओको एक टुरा अऊर पैदा भयो, अऊर ओको नाम ओनान रख्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","तब ओख अऊर एक टुरा पैदा भयो, अऊर ओको नाम शेला रख्यो गयो; अऊर जो समय येको जनम भयो ऊ समय यहूदा कजीब नगर म रहत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","अऊर यहूदा न तामार नाम की एक लड़की सी अपनो बड़ो टुरा एर को बिहाव कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","पर यहूदा को ऊ बड़ो टुरा एर यहोवा की नजर म बुरो होतो, येकोलायी यहोवा न ओख मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","तब यहूदा न ओनान सी कह्यो, “तय अपनी भाभी को जवर जा, अऊर ओको संग देऊर को धर्म पूरो कर क् अपनो भाऊ लायी सन्तान पैदा कर।” ");
INSERT INTO lbm_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनान जानत होतो कि सन्तान मोरी नहीं होयेंन; येकोलायी असो भयो कि जब ऊ अपनी भाभी को जवर गयो, तब ओन जमीन पर वीर्य गिराय क नाश करयो, जेको सी असो नहीं होय कि ओको भाऊ को नाम सी वंश चले। ");
INSERT INTO lbm_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","यो काम जो ओन करयो परमेश्वर की नजर म बुरो होतो; अऊर परमेश्वर न ओख मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","तब यहूदा न यो डर को मारे कि कही असो नहीं होय कि अपनो भाऊवों को जसो शेला भी मरे, अपनी बहू तामार सी कह्यो, “जब तक मोरो टुरा शेला जवान नहीं होय जाये तब तक अपनो बाप को घर म विधवाच बैठी रह्य।” येकोलायी तामार अपनो बाप को घर म जाय क रहन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","बहुत समय को बीतन पर यहूदा की पत्नी जो शूआ की टुरी होती, वा मर गयी; तब यहूदा दु:ख को दिन बितन पर अपनो संगी हीरा अदुल्लामवासी सहीत अपनी शेरी मेंढियों को ऊन कतरन वालो को जवर तिम्नाथ नगर ख गयो। ");
INSERT INTO lbm_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","अऊर तामार ख यो समाचार मिल्यो, “तोरो ससरो अपनी शेरी मेंढियों को ऊन काटन लायी तिम्नाथ नगर ख जाय रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तब ओन यो सोच क कि शेला जवान त होय गयो पर मय ओकी पत्नी नहीं होय सकी; अपनो विधवापन को कपड़ा उतारयो अऊर घूंघट डाल क अपनो ख झाक लियो, अऊर एनैम नगर की फाटक को जवर, जो तिम्नाथ की रस्ता म हय, वहां जाय बैठी। ");
INSERT INTO lbm_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","जब यहूदा न ओख देख्यो, त ओख ओन वेश्या समझ्यो; कहालीकि ओन अपनो मुंह झाक्यो हुयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ऊ रस्ता सी ओको तरफ मुड़्यो, अऊर ओको सी कहन लग्यो, “मोख अपनो जवर आन दे,” कहालीकि ओख यो मालूम नहीं होतो कि वा ओकी बहू आय। ओन कह्यो, “यदि मय तोख अपनो जवर आन देऊ, त तय मोख का देजो?” ");
INSERT INTO lbm_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ओन कह्यो, “मय अपनी शेरियों म सी शेरी को बच्चा तोरो जवर भेज देऊं।” तब ओन कह्यो, “तब तक का तय मोरो जवर कुछ चीज रख दे?” ");
INSERT INTO lbm_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदा न पुच्छ्यो, “मय तोरो जवर का चिज रख देऊ?” तामार न कह्यो, “अपनी मुहर, अऊर बाजूबन्द, अऊर अपनो हाथ को डन्डा।” तब यहूदा न ओख सब चीज दे दी, अऊर ओको जवर गयो, अऊर वा ओको सी गर्भवती भयी। ");
INSERT INTO lbm_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","तब वा उठ क चली गयी, अऊर अपनो घूंघट उतार क् अपनो विधवापन को कपड़ा फिर पहिन्यो। ");
INSERT INTO lbm_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","तब यहूदा न शेरी को एक बच्चा अपनो संगी ऊ अदुल्लामवासी को हाथ भेज दियो कि जो चिज रखी हुयी चिज वा बाई को हाथ सी छुड़ाय क ले आये; पर वा बाई ओख नहीं मिली। ");
INSERT INTO lbm_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","तब हीरा न उत को लोगों सी पुच्छ्यो, “वा वेश्या जो एनैम म रस्ता को एक तरफ बैठी होती, कित हय?” उन्न कह्यो, “यहां त कोयी वेश्या नहीं होती।” ");
INSERT INTO lbm_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","येकोलायी ओन यहूदा को जवर जाय क कह्यो, “मोख वा नहीं मिली; अऊर ऊ जागा को लोगों न कह्यो, यहां त कोयी वेश्या नहीं होती।” ");
INSERT INTO lbm_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","तब यहूदा न कह्यो, “अच्छा, वा निशानी कि चिज ओकोच जवर रहन दे, नहीं त हम लोग बेकार गिन्यो जाबो; देख, मय न शेरी को यो बच्चा भेज दियो होतो, पर वा तोख नहीं मिली।” ");
INSERT INTO lbm_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","लगभग तीन महिना को बाद यहूदा ख यो समाचार मिल्यो, “तोरी बहू तामार न व्यभिचार करयो हय; अऊर वा व्यभिचार सी गर्भवती भी भय गयी हय।” तब यहूदा न कह्यो, “ओख बाहेर ले क जावो कि ओख जलायो जाये।” ");
INSERT INTO lbm_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","जब लोग ओख बाहेर निकाल रह्यो होतो तब ओन अपनो ससरो को जवर यो सन्देश भेज्यो, “जो आदमी की या चिजे हय, ओकोच सी मय गर्भवती भयी,” तब ओन यो कह्यो, “पहिचानो त सही कि यो मुहर, अऊर बाजूबन्द, अऊर डन्डा कोन्को आय।” ");
INSERT INTO lbm_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदा न उन्ख पहिचान क कह्यो, “ऊ त मोरो सी कम दोषी हय; कहालीकि मय न ओको अपनो टुरा शेला सी बिहाव नहीं करयो।” अऊर ओन ओको सी फिर कभी सहवास नहीं करयो। ");
INSERT INTO lbm_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","जब ओको बच्चा पैदा करन को समय आयो, तब यो जान पड़्यो कि ओको गर्भ म जुड़वा बच्चा हय। ");
INSERT INTO lbm_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","अऊर जब वा बच्चा पैदा करन लगी तब एक बच्चा को हाथ बाहेर आयो, अऊर सुईन न लाल सूत ले क ओको हाथ म यो कहतो हुयो बान्ध दियो, “पहिले योच पैदा भयो।” ");
INSERT INTO lbm_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","जब बच्चा न अपनो हाथ अन्दर कर लियो, तब ओको भाऊ पैदा भयो। तब वा सुईन न कह्यो, “तय कहाली खुदच निकलन की रस्ता बनाय लियो?” येकोलायी ओको नाम पेरेस रख्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","पीछू ओको भाऊ जेको हाथ म लाल सूत बन्ध्यो होतो ऊ पैदा भयो, अऊर ओको नाम जेरह रख्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","जब यूसुफ मिस्र देश म पहुंचायो गयो, तब पोतीपर नाम को एक मिस्री न जो फिरौन को हाकिम अऊर अंगरक्षकों को प्रधान होतो, ओख इश्माएलियों को हाथ सी, जो ओख उत ले गयो होतो, लेय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","यूसुफ अपनो मिस्री स्वामी को घर म रहत होतो, अऊर यहोवा ओको संग होतो येकोलायी ऊ भाग्यवान आदमी भय गयो, ");
INSERT INTO lbm_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","अऊर यूसुफ को स्वामी न देख्यो कि यहोवा ओको संग रह्य हय, अऊर जो काम ऊ करय हय ओख यहोवा ओको हाथ सी सफल कर देवय हय। ");
INSERT INTO lbm_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","तब पोतीपर की अनुग्रह की नजर ओको पर भयी, अऊर यूसुफ ओकी सेवा म लगन लायी चुन्यो गयो; तब ओन ओख अपनो घर को अधिकारी बनान लायी अपनो सब कुछ यूसुफ को हाथ म सौंफ दियो। ");
INSERT INTO lbm_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","सब सी ओन ओख अपनो घर को अऊर अपनी पूरी जायजाद को अधिकारी बनायो, तब सी यहोवा यूसुफ को वजह ऊ मिस्री को घर पर आशीष देन लग्यो; अऊर का घर म, का खेत म, ओको जो कुछ होतो सब पर यहोवा की आशीष होन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","येकोलायी ओन अपनो सब कुछ यूसुफ को हाथ म यहां तक कि अपनो खान की रोटी ख छोड़, ऊ अपनी जायजाद को हाल कुछ नहीं जानत होतो। यूसुफ सुन्दर अऊर रूपवान होतो। ");
INSERT INTO lbm_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","इन बातों को बाद असो भयो कि ओको स्वामी की पत्नी न यूसुफ को तरफ देख्यो अऊर कह्यो, “मोरो संग सो।” ");
INSERT INTO lbm_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","पर ओन मना करतो हुयो अपनो स्वामी की पत्नी सी कह्यो, “सुन, जो कुछ यो घर म हय मोरो हाथ म हय; ओख मोरो स्वामी कुछ नहीं जानय, अऊर ओन अपनो सब कुछ मोरो हाथ म सौंप दियो हय। ");
INSERT INTO lbm_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","यो घर म मोरो सी बड़ो कोयी नहीं, अऊर ओन तोख छोड़, जो ओकी पत्नी आय, मोरो सी कुछ नहीं रख छोड़्यो, येकोलायी भला, मय असो बड़ो पाप कर क् परमेश्वर को अपराधी कहाली बनू?” ");
INSERT INTO lbm_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","अऊर असो भयो कि वा हर दिन यूसुफ सी बात करती रही, पर ओन ओकी नहीं मानी कि ओको जवर सोये या ओको संग रहे। ");
INSERT INTO lbm_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन का भयो कि यूसुफ अपनो काम काज करन लायी घर म गयो, अऊर घर को सेवकों म सी कोयी भी घर को अन्दर नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तब वा बाई न ओको कपड़ा पकड़ क कह्यो, “मोरो संग सो,” पर ऊ अपनो कपड़ा ओको हाथ म छोड़ क भग्यो अऊर बाहेर निकल गयो। ");
INSERT INTO lbm_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","यो देख क कि यूसुफ अपनो कपड़ा मोरो हाथ म छोड़ क बाहेर भग गयो, ");
INSERT INTO lbm_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","तब वा बाई न अपनो घर को सेवकों ख बुलाय क कह्यो, “देखो, ऊ एक इब्री आदमी ख मोरो स्वामी मोरो अपमान करन लायी मोरो जवर लायो हय। ऊ त मोरो संग सोवन को मतलब सी मोरो जवर अन्दर आयो होतो, अऊर मय ऊची आवाज सी चिल्लाय उठी; ");
INSERT INTO lbm_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","अऊर मोरो चिल्लावन को वजह सी ऊ अपनो कपड़ा मोरो जवर छोड़ क भग्यो, अऊर बाहेर निकल गयो।” ");
INSERT INTO lbm_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","अऊर वा ओको कपड़ा अपनो स्वामी को घर आवत तक अपनो जवर रखी रही। ");
INSERT INTO lbm_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","तब ओन अपनो स्वामी सी यो तरह की बाते कही, “ऊ इब्री दास जेक तय मोरो जवर ले आयो हय, ऊ मोरो अपमान करन लायी मोरो जवर आयो होतो; ");
INSERT INTO lbm_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","अऊर जब मय ऊची आवाज सी चिल्लाय उठी, तब ऊ अपनो कपड़ा छोड़ क बाहेर भग गयो।” ");
INSERT INTO lbm_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","अपनी पत्नी की हि बाते सुन क कि तोरो दास न मोरो संग असो असो काम करयो, यूसुफ को स्वामी को गुस्सा भड़क्यो। ");
INSERT INTO lbm_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","अऊर यूसुफ को स्वामी न ओख पकड़ क जेलखाना म, डलवाय दियो; जित राजा को कैदी बन्द होतो, तब यूसुफ भी ऊ जेलखाना म रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","पर परमेश्वर यूसुफ को संग संग रह्यो अऊर ओको पर दया करी, अऊर जेलखाना को दरोगा की अनुग्रह की नजर ओको पर भयी। ");
INSERT INTO lbm_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","येकोलायी जेलखाना को दरोगा न उन सब बन्दियों ख, जो जेलखाना म होतो, यूसुफ को हाथ म सौंप दियो; अऊर जो जो काम हि वहां करत होतो, ऊ काम ओकीच आज्ञा सी होत रह्य। ");
INSERT INTO lbm_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","यूसुफ को वश म जो कुछ होतो ओको म सी जेलखाना को दरोगा ख कोयी भी चिज देखनी नहीं पड़त होती; कहालीकि यहोवा यूसुफ को संग होतो; अऊर जो कुछ ऊ करत होतो, यहोवा ओख ओको म सफल बनावत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","इन बातों को बाद असो भयो, कि मिस्र देश को राजा को पिलान वालो अऊर जेवन बनान वालो न अपनो स्वामी को खिलाफ कुछ अपराध करयो। ");
INSERT INTO lbm_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","तब फिरौन न अपनो उन दोयी हाकिमों, मतलब पिलान वालो को प्रधान अऊर जेवन बनान वालो को प्रधान, दोयी पर गुस्सा होय क ");
INSERT INTO lbm_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","उन्ख कैद कराय क् अंगरक्षकों को प्रधान को घर को जेलखाना म, जित यूसुफ बन्दी होतो, उन्ख उत डलवाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","तब अंगरक्षकों को प्रधान न उन्ख यूसुफ को हाथ सौंप्यो, अऊर ऊ उन्की सेवा करन लग्यो; तब हि कुछ दिन तक जेलखाना म रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","मिस्र को राजा फिरौन को पिलान वालो अऊर जेवन बनान वालो, जेलखाना म बन्द होतो, उन दोयी न एकच रात म, अपनो सपनो देख्यो अऊर दोयी को सपनो को विशेष अर्थ अलग अलग होतो। ");
INSERT INTO lbm_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","सुबेरे जब यूसुफ उन्को जवर अन्दर गयो, तब उन पर ओन नजर डाली त ओन देख्यो कि हि उदास हंय। ");
INSERT INTO lbm_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","येकोलायी ओन फिरौन को उन हाकिमों सी, जो ओको संग ओको स्वामी को घर को जेलखाना म होतो, पुच्छ्यो, “अज तुम्हरो मुंह कहाली उदास हंय?” ");
INSERT INTO lbm_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","उन्न यूसुफ सी कह्यो, “हम दोयी न सपनो देख्यो हय, अऊर उन्को सपनो को अर्थ बतावन वालो कोयी भी नहाय।” यूसुफ न उन्को सी कह्यो, “का सपनो को अर्थ बतानो केवल परमेश्वर को काम नहाय? मोख अपनो अपनो सपनो बतावो।” ");
INSERT INTO lbm_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","तब पिलान वालो को प्रधान अपनो सपनो यूसुफ ख बतावन लग्यो: “सपनो म देख्यो कि मोरो आगु एक अंगूर को गुच्छा हय। ");
INSERT INTO lbm_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","अऊर वा अंगूर की बेला म तीन डगालियां हय; अऊर असो लगय हय कि ओको म कलियां लगी हंय, अऊर हि फूलीं अऊर ओको गुच्छा म अंगूर लग क पक गयी हय। ");
INSERT INTO lbm_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","फिरौन को कटोरा मोरो हाथ म होतो; अऊर मय न उन अंगूरो ख ले क फिरौन को कटोरा म पिरयो, अऊर कटोरा ख फिरौन को हाथ म दियो।” ");
INSERT INTO lbm_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","तब यूसुफ न ओको सी कह्यो, “यो तोरो सपनो को अर्थ आय : तीन डगालियों को अर्थ तीन दिन हंय; ");
INSERT INTO lbm_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","येकोलायी अब सी तीन दिन को अन्दर फिरौन तोरो सिर ऊचो करेंन, अऊर फिर सी तोरो पद पर तोख नियुक्त करेंन, अऊर तय पहिले को जसो फिरौन को पिलान वालो बन क ओको कटोरा ओको हाथ म फिर सी दियो करजो। ");
INSERT INTO lbm_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","फिर जब तोरो भलो होय जाये तब मोख याद करजो, अऊर मोरो पर दया कर क् फिरौन सी मोरी चर्चा करजो, अऊर यो जेलखाना सी मोख छुड़ाय देजो। ");
INSERT INTO lbm_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","कहालीकि सचमुच इब्रानियों को देश सी मोख चोर क लायो गयो हय; अऊर यहां भी मय न कोयी असो काम नहीं करयो, जेको वजह मय यो जेलखाना म डाल्यो जाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","यो देख क कि ओको सपनो को अर्थ अच्छो हय, तब जेवन बनान वालो को प्रधान न यूसुफ सी कह्यो, “मय न भी सपनो देख्यो हय, ऊ यो आय : मय न देख्यो कि मोरी मुंड पर सफेद रोटी की तीन टोपलियां हंय; ");
INSERT INTO lbm_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","अऊर ऊपर की टोपली म फिरौन लायी सब तरह की पकी पकायी चिजे हंय; अऊर पक्षी मोरी मुंड पर की टोपली म सी उन चिजे ख खाय रही हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","यूसुफ न कह्यो, “तोरो सपनो को अर्थ यो हय : हि तीन टोपलियों को अर्थ तीन दिन हय। ");
INSERT INTO lbm_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","अब सी तीन दिन को अन्दर फिरौन तोरी मुंड कटवाय क तोख एक खम्भा पर टंगाय देयेंन, अऊर पक्षी तोरो मांस ख तिड़ तिड़ क खायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","तीसरो दिन फिरौन को जनम दिन होतो, ओन अपनो सब कर्मचारियों ख जेवन दियो, अऊर उन्म सी पिलान वालो को प्रधान अऊर जेवन बनान वालो को प्रधान हि दोयी ख जेलखाना म सी निकलवायो। ");
INSERT INTO lbm_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","पिलान वालो को प्रधान ख त पिलान वालो को पद पर फिर सी नियुक्त करयो, अऊर ऊ फिरौन को हाथ म कटोरा देन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","पर जेवन बनान वालो को प्रधान ख ओन टंगाय दियो, जसो कि यूसुफ न ओको सपनो को अर्थ ओन कह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","तब भी पिलान वालो को प्रधान न यूसुफ ख याद नहीं रख्यो; पर ओख भूल गयो। ");
INSERT INTO lbm_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","पूरो दोय साल बीतन पर फिरौन न यो सपनो देख्यो कि ऊ नील नदी को किनारे खड़ो हय। ");
INSERT INTO lbm_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","अऊर वा नील नदी म सी सात सुन्दर अऊर मोटी मोटी गाय निकल क नदी किनारे घास चरन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","अऊर, ओन देख्यो कि उन्को पीछू अऊर सात गाय, जो बदसुरत अऊर कमजोर हंय, नील नदी सी निकली, अऊर दूसरी गायों को जवर नील नदी को किनार पर जाय क खड़ी भयी। ");
INSERT INTO lbm_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","तब हि बदसूरत अऊर कमजोर गाये उन सात सुन्दर अऊर मोटी मोटी गायों ख खाय गयी। तब फिरौन जग गयो। ");
INSERT INTO lbm_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","अऊर ऊ फिर सोय गयो अऊर दूसरो सपनो देख्यो कि डंठल म सी सात मोटी अऊर अच्छी अच्छी बालें निकली। ");
INSERT INTO lbm_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","अऊर, देख्यो कि पूर्व की हवा सी सात लोम्ब पतली अऊर मुरझायी हुयी निकली। ");
INSERT INTO lbm_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","अऊर इन पतली लोम्ब न उन सातों मोटी अऊर अनाज सी भरी हुयी लोम्ब ख खाय लियो। तब फिरौन जाग्यो, अऊर ओख मालूम भयो कि यो सपनोच होतो। ");
INSERT INTO lbm_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","सुबेरे फिरौन को मन चिन्तित भयो अऊर ओन मिस्र को सब तान्त्रिकों अऊर जानकार लोगों ख बुलावा भेज्यो; अऊर उन्ख अपनो सपनो बतायो; पर उन्म सी कोयी भी ओको अर्थ नहीं बताय सक्यो। ");
INSERT INTO lbm_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तब पिलान वालो को प्रधान न फिरौन सी कह्यो, “मोरो अपराध अज मोख याद आयो। ");
INSERT INTO lbm_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","जब फिरौन अपनो दासों सी गुस्सा भयो होतो, तब मोख अऊर जेवन बनान वालो को प्रधान ख कैद कराय क् अंगरक्षकों को प्रधान को घर को जेलखाना म डाल दियो होतो; ");
INSERT INTO lbm_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","तब हम दोयी न एकच रात म सपनो देख्यो अऊर ऊ सपनो को अर्थ अलग अलग होतो। ");
INSERT INTO lbm_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","वहां हमरो संग एक इब्री जवान होतो, जो अंगरक्षकों को प्रधान को दास होतो; तब हम न ओख अपनो अपनो सपनो बतायो अऊर ओन हमरो सपनो को अर्थ हम्ख बतायो, हम म सी एक एक को सपनो को अर्थ ओन बताय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","अऊर जसो जसो अर्थ ओन बतायो होतो, वसोच भयो भी, यानेकि मोख त मोरो पद फिर मिल्यो, पर ऊ फासी पर लटकायो गयो।” ");
INSERT INTO lbm_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","तब फिरौन न यूसुफ ख बुलायो; अऊर ऊ तुरतच जेलखाना सी बाहेर निकाल्यो गयो, अऊर बाल बनाय क अऊर कपड़ा बदल क फिरौन को आगु आयो। ");
INSERT INTO lbm_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फिरौन न यूसुफ सी कह्यो, “मय न एक सपनो देख्यो हय, अऊर ओको अर्थ बतावन वालो कोयी भी नहाय; अऊर मय न तोरो बारे म सुन्यो हय कि तय सपनो सुनतोच ओको अर्थ बताय देवय हय।” ");
INSERT INTO lbm_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","यूसुफ न फिरौन सी कह्यो, “मय त कुछ भी नहीं जानु हय, पर परमेश्वरच फिरौन लायी शुभ वचन देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","तब फिरौन यूसुफ सी कहन लग्यो, “मय न अपनो सपनो म देख्यो कि मय नील नदी को किनारे खड़ो हय। ");
INSERT INTO lbm_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","फिर देख्यो, कि नील नदी म सी सात मोटी अऊर सुन्दर सुन्दर गाय निकल क घास चरन लगी। ");
INSERT INTO lbm_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","तब अऊर देख्यो, कि उन्को पीछू सात अऊर गाय निकली, जो पतली अऊर बहुत छोटी अऊर कमजोर हंय; मय न पूरो मिस्र देश म असी बदसूरत गाय कभी नहीं देख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","इन कमजोर अऊर बदसूरत गायों न उन पहिली सातों मोटी मोटी गायों ख खाय लियो; ");
INSERT INTO lbm_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","अऊर जब हि उन्ख खाय गयी तब यो मालूम नहीं होत रह्य कि हि उन्ख खाय गयी हंय, कहालीकि हि पहिले को जसो जसी की वसी बदसूरत रही। तब मय जग गयो। ");
INSERT INTO lbm_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","तब मय न दूसरो सपनो देख्यो, कि एकच डंठल म सात अच्छी अच्छी अऊर अनाज सी भरी हुयी लोम्ब निकली। ");
INSERT INTO lbm_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","तब देखू हय, कि उन्को पीछू अऊर सात मुरझायी, पतली, अऊर पूर्व की हवा सी सुखी हुयी लोम्ब निकली। ");
INSERT INTO lbm_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","अऊर इन पतली लोम्ब न उन सात अच्छी अच्छी लोम्ब ख खाय लियो। येख मय न तान्त्रिकों ख बतायो, पर येको अर्थ बतावन वालो कोयी नहीं मिल्यो।” ");
INSERT INTO lbm_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","तब यूसुफ न फिरौन सी कह्यो, “तोरो सपनो का एकच हय, परमेश्वर जो काम करनो चाहवय हय, ओख ओन फिरौन पर दरसायो हय। ");
INSERT INTO lbm_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","हि सात अच्छी अच्छी गाय सात साल हंय; अऊर हि सात अच्छी अच्छी लोम्ब भी सात साल हंय; यो तरह सी सपनो एकच आय। ");
INSERT INTO lbm_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","तब उन्को पीछू जो कमजोर अऊर गरीब गाय निकली, अऊर जो सात सुखी अऊर पूर्व की हवा सी मुरझायी हुयी लोम्ब निकाली, हि अकाल को सात साल होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","या वाच बात आय जो मय फिरौन सी कह्य चुक्यो हय कि परमेश्वर जो काम करनो चाहवय हय, ओख ओन फिरौन ख दिखायो हय। ");
INSERT INTO lbm_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","सुन, असो सात साल आयेंन जब पूरो मिस्र देश म बहुत तरह सी अनाज पैदा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","उन्को बाद सात साल अकाल को आयेंन, अऊर पूरो मिस्र देश म लोग हि पूरी उपज ख भूल जायेंन; अऊर अकाल सी देश को नाश होयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","अऊर अकाल इतनो भयानक होयेंन कि अच्छी फसल अऊर उपज कोयी ख याद तक नहीं रहेंन। ");
INSERT INTO lbm_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","अऊर फिरौन न जो यो सपनो दोय बार देख्यो हय येको भेद योच आय कि यो बात परमेश्वर को तरफ सी नियुक्त होय गयी हय, अऊर परमेश्वर येख जल्दीच पूरो करेंन। ");
INSERT INTO lbm_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“येकोलायी अब फिरौन कोयी समझदार अऊर बुद्धिमान आदमी ख ढूंढ क ओख मिस्र देश पर प्रधान मन्त्री ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","अऊर फिरौन पूरो मिस्र देश म अधिकारियों ख ठहराये, अऊर सात साल जो अच्छी फसल अऊर उपज को हंय ऊ समय जमीन की उपज को पाचवों भाग लियो करे। ");
INSERT INTO lbm_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","अऊर तब अच्छी फसल को सात सालों म सब तरह की खान की चिज जमा करे, अऊर नगर नगर म जेवन लायी अनाज को भण्डार घर खोले अऊर अनाज की रक्षा करे। ");
INSERT INTO lbm_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","या जेवन की चिज अकाल को उन सात सालों लायी हंय, जो मिस्र देश म आयेंन, देश को जेवन लायी रखी हय, जेको सी देश को ऊ अकाल सी सत्यानाश नहीं हो जाये।” ");
INSERT INTO lbm_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","यो बात फिरौन अऊर ओको पूरो अधिकारियों ख अच्छी लगी। ");
INSERT INTO lbm_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","येकोलायी फिरौन न अपनो अधिकारियों सी कह्यो, “का हम ख असो आदमी मिल सकय हय, जसो यो हय अऊर जेको म परमेश्वर की आत्मा रह्य हय।” ");
INSERT INTO lbm_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","तब फिरौन न यूसुफ सी कह्यो, “परमेश्वर न जो तोख इतनो ज्ञान दियो हय कि तोरो जसो कोयी समझदार अऊर बुद्धिमान नहीं; ");
INSERT INTO lbm_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","यो वजह तय मोरो घर को अधिकारी होयजो, अऊर तोरी आज्ञा को अनुसार मोरी पूरी प्रजा चलेंन, केवल राजगद्दी को बारे म मय तोरो सी बड़ो रहूं।” ");
INSERT INTO lbm_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","तब फिरौन न यूसुफ सी कह्यो, “सुन, मय तोख मिस्र को पूरो देश को ऊपर अधिकारी ठहराय देऊ हय।” ");
INSERT INTO lbm_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","तब फिरौन न अपनो हाथ सी अंगूठी निकाल क यूसुफ को हाथ म पहिनाय दी; अऊर यूसुफ ख बढ़िया मलमल को कपड़ा पहिनाय दियो, अऊर ओको गलो म सोनो की चैन डाल दी; ");
INSERT INTO lbm_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","अऊर ओख अपनो दूसरो रथ पर चढ़ायो; अऊर लोग ओको आगु आगु यो प्रचार करतो चल्यो कि घुटना टेक क दण्डवत करो, अऊर ओन यूसुफ ख मिस्र को पूरो देश को ऊपर प्रधान मन्त्री ठहराय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","तब फिरौन न यूसुफ सी कह्यो, “फिरौन त मय आय; पर मिस्र देश म कोयी भी तोरी आज्ञा को बिना हाथ पाय नहीं हिलायेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","तब फिरौन न यूसुफ को नाम सापनत्पानेह रख्यो; अऊर ओन नगर को याजक पोतीपेरा की बेटी आसनत सी ओको बिहाव कराय दियो। अऊर यूसुफ पूरो मिस्र देश को अधिकारी भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","जब यूसुफ मिस्र को राजा फिरौन को जवर खड़ो भयो, तब ऊ तीस साल को होतो। ऊ फिरौन को जवर सी निकल क पूरो मिस्र देश म दौरा करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","पहिले को सात सालों म जमीन बहुत तरह सी अनाज पैदा करती रही, ");
INSERT INTO lbm_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","अऊर यूसुफ उन सातों सालों म सब तरह की जेवन की चिजे, जो मिस्र देश म होत रह्य, उन्ख जमा कर क् नगरों म रखतो गयो; अऊर हर एक नगर को चारयी तरफ को खेतों की जेवन की चिजे ख ऊ उच नगर म जमा करतो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","यो तरह यूसुफ न अनाज ख समुन्दर की रेतु को जसो बहुत अच्छो सी एक एक कर क् गिन क रख्यो, तब वहां इतनी फसल भय गयी कि यूसुफ न ओख गिननोच छोड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","अकाल को पहिलो साल को आनो सी पहिले यूसुफ को दोय टुरा पैदा भयो, ओन नगर को याजक पोतीपेरा की बेटी आसनत न उन्ख जनम दियो। ");
INSERT INTO lbm_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","यूसुफ न अपनो बड़ो टुरा को नाम यो कह्य क मनश्शे रख्यो, कि “परमेश्वर न मोरो सी मोरी पूरी परेशानी, अऊर मोरो बाप को पूरो घराना भुलाय दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","दूसरो को नाम ओन यो कह्य क एप्रैम रख्यो, कि “परमेश्वर न मोख ऊ देश म फलवन्त करयो जित मोख दु:ख भोगनो पड़्यो होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","मिस्र देश को अच्छी फसल पकन को सात साल खतम होय गयो; ");
INSERT INTO lbm_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","अऊर यूसुफ को कहन को अनुसार सात सालों लायी अकाल शुरू भय गयो। सब देशों म अकाल पड़न लग्यो, पर मिस्र देश म अनाज होतो। ");
INSERT INTO lbm_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","जब मिस्र को पूरो देश भूखो मरन लग्यो; तब प्रजा फिरौन सी चिल्लाय चिल्लाय क खाना मांगन लग्यो; अऊर ऊ सब मिस्रियों सी कहत रह्य, “यूसुफ को जवर जावो; अऊर जो कुछ ऊ तुम सी कहेंन, उच करो।” ");
INSERT INTO lbm_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","जब अकाल पूरी धरती पर फैल गयो, अऊर मिस्र देश म अकाल को रूप भयंकर भय गयो, तब यूसुफ सब भण्डार घर ख खोल क मिस्रियों ख अनाज बेचन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","येकोलायी पूरी धरती को लोग मिस्र देश म अनाज लेन लायी यूसुफ को जवर आन लग्यो, कहालीकि पूरी धरती पर भयंकर अकाल होतो। ");
INSERT INTO lbm_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","जब याकूब न सुन्यो कि मिस्र म अनाज हय, तब ओन अपनो बेटावों सी कह्यो, “तुम एक दूसरो को मुंह कहाली देख रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","तब ओन कह्यो, “मय न सुन्यो हय कि मिस्र म अनाज हय; येकोलायी तुम लोग वहां जाय क हमरो लायी अनाज ले क आवो, जेको सी हम मरबो नहीं, बल्की जीन्दो रह्यबोंन।” ");
INSERT INTO lbm_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","तब यूसुफ को दस भाऊ अनाज लेन लायी मिस्र देश ख गयो। ");
INSERT INTO lbm_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","पर यूसुफ को भाऊ बिन्यामीन ख याकूब न यो सोच क भाऊवों को संग नहीं भेज्यो कि कही असो नहीं होय कि ओको पर कोयी संकट आय पड़े। ");
INSERT INTO lbm_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","यो तरह जो लोग अनाज लेन आयो उन्को संग याकूब को बेटा भी आयो; कहालीकि कनान देश म भी भारी अकाल होतो। ");
INSERT INTO lbm_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","यूसुफ त मिस्र देश को प्रधान मन्त्री होतो, अऊर ऊ देश को सब लोगों ख उच अनाज बेचत रह्य; येकोलायी जब यूसुफ को भाऊ आयो तब जमीन को तरफ मुंड झुकाय क ओख दण्डवत करयो। ");
INSERT INTO lbm_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","उन्ख देख क यूसुफ न पहिचान त लियो, पर उन्को आगु भोलो बन क् मजबूती को संग उन्को सी पुच्छ्यो, “तुम कित सी आयो हय?” उन्न कह्यो, “हम कनान देश सी अनाज लेन लायी आयो हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","यूसुफ न अपनो भाऊवों ख पहिचान लियो, पर उन्न ओख नहीं पहिचान्यो। ");
INSERT INTO lbm_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","तब यूसुफ अपनो उन सपनो ख याद कर क् जो ओन ओको बारे म देख्यो होतो, उन्को सी कहन लग्यो, “तुम लोग भेद जानन लायी आयो हय; यो मिस्र देश की दुर्दशा को।” ");
INSERT INTO lbm_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","उन्न ओको सी कह्यो, “नहीं, नहीं, स्वामी, तोरो दास जेवन की चिज ख लेन लायी आयो हंय। ");
INSERT INTO lbm_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हम सब एकच बाप को बेटा आय, हम सीधो आदमी हंय; तोरो दास भेद जानन वालो नोहोय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","यूसुफ न उन्को सी कह्यो, “नहीं, नहीं, तुम यो देश की दुर्दशा देखन लायीच आयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","उन्न कह्यो, “हम तोरो दास बारा भाऊ हंय, अऊर कनान देश को हम एकच आदमी को बेटा आय, अऊर छोटो भाऊ यो समय हमरो बाप को जवर हय, अऊर एक भाऊ मर गयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","तब यूसुफ न उन्को सी कह्यो, “मय न तुम सी कह्य दियो कि तुम भेद जानन वालो आय; ");
INSERT INTO lbm_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","तब योच रीति सी तुम्हरी जांच करी जायेंन, फिरौन की जीवन की कसम, जब तक तुम्हरो छोटो भाऊ इत नहीं आय जाये तब तक तुम इत सी नहीं निकल पावों। ");
INSERT INTO lbm_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","येकोलायी अपनो म सी एक ख भेज देवो कि ऊ तुम्हरो भाऊ ख ले आये, अऊर तुम लोग हमरी देख भाल म रहो; यो तरह तुम्हरी बाते जाची जायेंन कि तुम म सच्चायी हय का नहाय। यदि सच्चो नहीं निकल्यो तब त फिरौन को जीवन की कसम तुम सही मच भेद जानन वालो समझ्यो जावो।” ");
INSERT INTO lbm_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","तब यूसुफ न उन्ख तीन दिन तक जेलखाना म रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीसरो दिन यूसुफ न उन्को सी कह्यो, “एक काम करो तब जीन्दो रहो; कहालीकि मय परमेश्वर को डर मानु हय; ");
INSERT INTO lbm_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","यदि तुम सीधो आदमी हय, त तुम सब भाऊवों म सी एक जन यो जेलखाना म बन्दी रहे; अऊर तुम अपनो घर वालो की भूख मिटान लायी अनाज ले जावो, ");
INSERT INTO lbm_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","अऊर अपनो छोटो भाऊ ख मोरो जवर ले आवो; यो तरह तुम्हरी बाते सच्ची ठहरेंन, अऊर तुम मार डाल्यो नहीं जावो।” तब उन्न वसोच करयो। ");
INSERT INTO lbm_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","उन्न आपस म कह्यो, “कोयी सक नहाय कि हम अपनो भाऊ को बारे म दोषी हंय, कहालीकि जब ओन हम सी गिड़गिड़ाय क बिनती करी, तब भी हम न यो देख क कि ओको जीवन कसो संकट म पड़्यो हय, तब भी हम न ओकी नहीं सुनी; योच वजह हम भी अब यो संकट म पड़्यो हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रूबेन न ओको सी कह्यो, “का मय न तुम सी नहीं कह्यो होतो कि टुरा को अपराधी मत बनो? पर तुम न नहीं सुन्यो। देखो, अब ओको खून को बदला लियो जाय रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","यूसुफ की अऊर उन्की बातचीत एक दोय भाषियों को द्वारा होत रह्य; येको सी उन्ख मालूम नहीं भयो कि ऊ उन्की बोली समझय हय। ");
INSERT INTO lbm_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तब यूसुफ उन्को जवर सी हट क रोवन लग्यो; तब अऊर उन्को जवर लौट क उन्को सी बातचीत कर क् उन्म सी शिमोन ख निकाल्यो अऊर उन्को आगु ओख बन्दी बनाय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","तब यूसुफ न आज्ञा दी कि उन्को बोरा अनाज सी भरो अऊर एक एक जन को बोरा म ओको रुपया ख भी रख देवो, तब उन्ख रस्ता लायी भी जेवन की चिजे भी देवो। तब उन्को संग असोच करयो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","तब हि अपनो अनाज को बोरा अपनो गधा पर लाद क उत सी चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","सराय म जब एक न अपनो गधा ख चारा देन लायी अपनो बोरा खोल्यो, तब ओको रुपया बोरा को ऊपर रख्यो हुयो देख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","तब ओन अपनो भाऊवों सी कह्यो, “मोरो रुपया त लौटाय दियो गयो हय; देखो, ऊ मोरो बोरा म हय,” तब उन्को जीव म जीव नहीं रह्यो, अऊर हि एक दूसरो को तरफ डर सी देखन लग्यो, अऊर बोल्यो, “परमेश्वर न यो हम सी का करयो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","तब हि कनान देश म अपनो बाप याकूब को जवर आयो, अऊर अपनी पूरी बात ओख यो तरह सुनायो : ");
INSERT INTO lbm_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“जो आदमी मिस्र देश को स्वामी हय, ओन हम सी मजबूती को संग बाते करी, अऊर हम ख ओन ऊ देश को भेद जानन वालो कह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","तब हम न ओको सी कह्यो, ‘हम सीधो लोग हंय, भेद जानन वालो नहीं। ");
INSERT INTO lbm_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हम बारा भाऊ एकच बाप को बेटा आय; एक त मर गयो, पर छोटो भाऊ कनान देश म बाप को जवर हय।’ ");
INSERT INTO lbm_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","तब ऊ आदमी न, जो ऊ देश को स्वामी हय, हम सी कह्यो, ‘येको सी मालूम होय जायेंन कि तुम सीधो आदमी हय; तुम अपनो म सी एक ख मोरो जवर छोड़ क अपनो घर वालो की भूख मिटान लायी कुछ ले क जावो, ");
INSERT INTO lbm_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","अऊर अपनो छोटो भाऊ ख मोरो जवर ले क आवो। तब मोख विश्वास होय जायेंन कि तुम भेद जानन वालो नोहोय, पर सीधो लोग आय। तब मय तुम्हरो भाऊ ख तुम्ख सौंप देऊं, अऊर तुम यो देश म लेन देन भी कर सको’।” ");
INSERT INTO lbm_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","यो बताय क हि अपनो अपनो बोरा सी अनाज निकालन लग्यो, तब देख्यो कि एक एक जन को रुपया की झोली ओकोच बोरा म रखी हय। तब रुपया की झोलियों ख देख क हि अऊर उन्को बाप बहुत डर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","तब उन्को बाप याकूब न उन्को सी कह्यो, “मोख तुम न बिना सन्तान को कर दियो, देखो, यूसुफ नहीं रह्यो, अऊर शिमोन भी नहीं आयो, अऊर तुम बिन्यामीन ख भी लि जानो चाहवय हय। यो सब विपत्तियां मोरो ऊपर आय पड़ी हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","रूबेन न अपनो बाप सी कह्यो, “यदि मय ओख तोरो जवर नहीं लाऊ, त मोरो दोयी टुरावों ख मार डालजो; तय ओख मोरो हाथ म सौंप दे, मय ओख तोरो जवर फिर लाय देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","याकूब न कह्यो, “मोरो बेटा तुम्हरो संग नहीं जायेंन; कहालीकि ओको भाऊ मर गयो हय अऊर ऊ अब अकेलो रह्य गयो हय : येकोलायी जो रस्ता सी तुम जावो, ओको म यदि ओको पर कोयी विपत्ति आय गयी, तब त तुम्हरो वजह मय यो बुढ़ापा को दिन म दु:ख को संग अधोलोक म उतर जाऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","कनान देश म अकाल अऊर भी भयंकर होतो गयो। ");
INSERT INTO lbm_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","जब हि अनाज मिस्र सी ले आयो होतो, खतम होय गयो तब उन्को बाप याकूब न उन्को सी कह्यो, “मिस्र देश ख फिर जावो, अऊर हमरो लायी कुछ अऊर जेवन की चिज ले क लावो।” ");
INSERT INTO lbm_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","तब यहूदा न अपनो बाप याकूब सी कह्यो, “ऊ आदमी न हम ख चेतावनी दे क कह्यो, ‘यदि तुम्हरो भाऊ तुम्हरो संग नहीं आयेंन, त तुम मोरो जवर मत आवो।’ ");
INSERT INTO lbm_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","येकोलायी यदि तय हमरो भाऊ ख हमरो संग भेजय, तब हम जाय क तोरो लायी जेवन की चिज ख ले क आबो, ");
INSERT INTO lbm_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","पर यदि तय ओख नहीं भेजय, त हम नहीं जाबो, कहालीकि ऊ आदमी न हम सी कह्यो, ‘यदि तुम्हरो भाऊ तुम्हरो संग नहीं आयेंन, त तुम मोरो जवर मत आवो’।” ");
INSERT INTO lbm_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","तब याकूब न कह्यो, “तुम न ऊ आदमी ख यो कहाली बतायो कि हमरो एक अऊर भाऊ हय, कहाली मोरो सी बुरो बर्ताव करयो?” ");
INSERT INTO lbm_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","उन्न कह्यो, “जब ऊ आदमी न हमरी अऊर हमरो रिश्तेदारों की हालत को बारे म यो रीति सी पुच्छ्यो, ‘कि का तुम्हरो बाप अभी तक जीन्दो हय? का तुम्हरो कोयी अऊर भाऊ भी हय?’ तब हम न हि सवाल को अनुसार ओको सी बात करयो। तब हम का जानत होतो कि ऊ हम सी कहेंन, कि अपनो भाऊ ख इत ले आवो।” ");
INSERT INTO lbm_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","तब यहूदा न अपनो बाप याकूब सी कह्यो, “ऊ लड़का ख मोरो संग भेज दे कि हम चले जाये; येको सी हम अऊर तय, अऊर हमरो बाल बच्चा मरनो नहीं पायेंन, अऊर जीन्दो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","मय ओकी सुरक्षा की जवाब दारी लेऊ हय; मोरोच हाथ सी तय ओख वापस लेजो। यदि मय ओख तोरो जवर पहुंचाय क आगु खड़ो नहीं कर देऊ, तब त मय हमेशा लायी तोरो अपराधी ठहरूं। ");
INSERT INTO lbm_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","यदि हम लोग वहां इंतजार नहीं करतो, त अब तक दूसरी बार वापस आतो।” ");
INSERT INTO lbm_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","तब उन्को बाप याकूब न उन्को सी कह्यो, “यदि सचमुच असीच बात हय त यो करो, यो देश की अच्छी अच्छी चिज म सी कुछ कुछ अपनो बोरा म ऊ आदमी लायी भेंट ले जावो : जसो थोड़ो सो बलसान, शहेद, मसाला, गन्धरस, पिस्ता, अऊर बादाम। ");
INSERT INTO lbm_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","तब अपनो अपनो संग दोय गुना रुपया ले जावो; अऊर जो रुपया तुम्हरो बोरा को ऊपर रख क लौटाय दियो गयो होतो, ओख भी धर क जावो; शायद यो भूल सी भयो हो। ");
INSERT INTO lbm_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","अपनो भाऊ ख भी संग ले क ऊ आदमी को जवर फिर जावो, ");
INSERT INTO lbm_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","अऊर सर्वशक्तिमान परमेश्वर ऊ आदमी ख तुम पर दयालु करेंन, जेको सी ऊ तुम्हरो दूसरो भाऊ ख अऊर बिन्यामीन ख भी आन देन; अऊर यदि बिन सन्तान ख बिछड़नोच हय, त असोच होन दे।” ");
INSERT INTO lbm_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","तब उन भाऊवों न ऊ भेंट, अऊर दोय गुना रुपया, अऊर बिन्यामीन ख भी संग म धरयो, अऊर चलन लग्यो, अऊर मिस्र देश म पहुंच क यूसुफ को आगु खड़ो भयो। ");
INSERT INTO lbm_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","उन्को संग बिन्यामीन ख देख क यूसुफ न अपनो घर को अधिकारी सी कह्यो, “हि आदमियों ख घर म पहुंचाय देवो, अऊर जनावर मार क जेवन तैयार करो; कहालीकि हि लोग दोपहर ख मोरो संग जेवन करेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","तब ऊ अधिकारी आदमी यूसुफ को कहन को अनुसार उन आदमियों ख यूसुफ को घर म ले गयो। ");
INSERT INTO lbm_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","जब हि यूसुफ को घर ख पहुंचायो गयो तब हि आपस म डर क कहन लग्यो, “जो रुपया पहिली बार हमरो बोरा म वापस कर दियो गयो होतो, ओकोच वजह हम अन्दर पहुंचायो गयो हंय; जेको सी कि ऊ आदमी हम पर टूट पड़्यो, अऊर हम्ख वश म कर क् अपनो दास बनायो, अऊर हमरो गधा ख भी छीन ले।” ");
INSERT INTO lbm_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","तब हि यूसुफ को घर को अधिकारी को जवर जाय क घर को दरवाजा पर ओको सी कहन लग्यो, ");
INSERT INTO lbm_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“हे हमरो स्वामी, जब हम पहिली बार अनाज मोल लेन ख आयो होतो, ");
INSERT INTO lbm_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","तब हम घर ख जातो समय सराय म पहुंच क अपनो बोरा ख खोल्यो, त देख्यो कि एक एक जन को पूरो पूरो रुपया ओको बोरा म ऊपर रख्यो हय; येकोलायी हम ऊ रुपया ख फिर अपनो संग लायो हंय, ");
INSERT INTO lbm_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","अऊर दूसरो रुपया भी खान की चिज लेन लायी लायो हंय; हम नहीं जानजे कि हमरो रुपया हमरो बोरा म कौन रख दियो होतो।” ");
INSERT INTO lbm_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ओन कह्यो, “चिन्ता मत करो, मत डरो! तुम्हरो परमेश्वर, जो तुम्हरो बाप को भी परमेश्वर हय, ओनच तुम ख तुम्हरो बोरा म धन दियो होना, तुम्हरो रुपया त मोख मिल गयो होतो।” तब ओन शिमोन ख निकाल क ओको संग कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","तब ऊ अधिकारी न उन भाऊवों ख यूसुफ को घर म लिजाय क पानी दियो, तब उन्न अपनो पाय ख धोयो; तब ओन उन्को गधा लायी चारा भी दियो। ");
INSERT INTO lbm_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","तब यो सुन क कि अज हम्ख इतच जेवन करनो पड़ेंन, तब उन्न यूसुफ को आन को समय तक मतलब दोपहर तक, ऊ भेंट ख तैयार कर क् रख्यो। ");
INSERT INTO lbm_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","जब यूसुफ घर आयो तब हि ऊ भेंट ख, जो ओको हाथ म होती, ओको आगु घर म लिजायो अऊर जमीन पर गिर क ओख दण्डवत करयो। ");
INSERT INTO lbm_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","यूसुफ न उन्ख सब ठीक ठाक त हय असो पुच्छ्यो अऊर कह्यो, “का तुम्हरो ऊ बूढ्ढा बाप, जेकी तुम न चर्चा करी होती, ऊ ठीक हय? का ऊ अभी तक जीन्दो हय?” ");
INSERT INTO lbm_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","उन्न कह्यो, “हव, तोरो दास अऊर हमरो बाप ठीक हय अऊर अब तक जीन्दो भी हय।” तब उन्न मुंड झुकाय क फिर दण्डवत करयो। ");
INSERT INTO lbm_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","तब यूसुफ न आंखी ऊपर उठाय क अऊर अपनो सगो भाऊ बिन्यामीन ख देख क पुच्छ्यो, “का तुम्हरो ऊ छोटो भाऊ, जेकी चर्चा तुम न मोरो सी करी होती योच आय?” तब ओन कह्यो, “हे मोरो बेटा, परमेश्वर तोरो पर अनुग्रह करे।” ");
INSERT INTO lbm_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","यूसुफ जल्दी सी उठ्यो; कहालीकि अपनो छोटो भाऊ को वजह ओको मन भर आयो होतो, ओन अकेलो म आसू बहान लायी जागा ढूंढ़ी अऊर ऊ अपनी कोठरी म आयो, अऊर वहां रोय पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","तब अपनो मुंह धोय क निकल्यो, अऊर अपनो ख चुपचाप कर क् कह्यो, “जेवन परोसो।” ");
INSERT INTO lbm_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","तब उन्न ओको लायी अलग अऊर भाऊवों लायी भी अलग, अऊर जो मिस्री ओको संग खात रह्य उन्को लायी भी अलग जेवन परोस्यो; येकोलायी कि मिस्री इब्रियों को संग जेवन नहीं कर सकय, नहीं त मिस्री लोग असो करनो बुरो समझत होतो। ");
INSERT INTO lbm_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","अऊर यूसुफ को भाऊ ओको आगु बड़ो बड़ो पहिले अऊर छोटो छोटो पीछू, उन्ख अपनी अपनी उमर को अनुसार, कर्म सी बैठायो गयो; यो देख क हि हैरान होय क एक दूसरो को तरफ देखन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","तब यूसुफ अपनो आगु सी जेवन की चिजे उठाय उठाय क उन्को जवर भेजन लग्यो, अऊर बिन्यामीन ख अपनो भाऊवों सी पाच गुना जादा जेवन की चिजे मिली। यो तरह उन्न यूसुफ को संग खुशी मनायो। ");
INSERT INTO lbm_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","तब यूसुफ न अपनो घर को अधिकारी ख आज्ञा दी, “इन आदमियों को बोरा म जितनी जेवन की चिजे समाय सकेंन उतनी भर दे, अऊर एक एक जन को रुपया ख ओको बोरा को मुंह पर रख दे। ");
INSERT INTO lbm_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","अऊर मोरो चांदी को कटोरा सब सी छोटो भाऊ को बोरा को मुंह पर ओको अनाज को रुपया को संग रख दे।” यूसुफ की यो आज्ञा को अनुसार ओन वसोच करयो। ");
INSERT INTO lbm_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","सुबेरे होतोच हि आदमी अपनो गधा सहित बिदा करयो गयो ");
INSERT INTO lbm_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","हि नगर सी निकल्योच होतो अऊर दूर नहीं गयो होतो कि यूसुफ न अपनो घर को अधिकारी सी कह्यो, “उन आदमियों को पीछा कर, अऊर उन्ख मिल क उन्को सी कह्य, ‘तुम न भलायी को बदला बुरायी कहाली करी? तुम न मोरो स्वामी को चांदी को कटोरा कहाली चुरायो? ");
INSERT INTO lbm_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","का यो ऊ चांदी को कटोरा नोहोय जेको म मोरो स्वामी पीवय हय, अऊर जेको सी ऊ लूकी बातों ख भी करय हय? तुम न यो जो करयो ऊ बुरो करयो’।” ");
INSERT INTO lbm_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","तब अधिकारी न उन्ख जाय क पकड़्यो, अऊर असीच बाते उन्को सी कही। ");
INSERT INTO lbm_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","उन्न अधिकारी सी कह्यो, “हे हमरो स्वामी, तय असी बाते कहाली कह्य रह्यो हय? हम कसम खाजे हय कि हम न असो काम करयो हय कि तोरो दासों सी दूर रहे। ");
INSERT INTO lbm_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","देख, जो रुपया हमरो बोरा को मुंह को ऊपर निकल्यो होतो, जब हम न ओख कनान देश सी लाय क तोख वापस कर दियो, तब कहाली, हम तोरो स्वामी को घर म सी कोयी चांदी या सोनो की चिज कसो चुराय सकजे हंय? ");
INSERT INTO lbm_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","हे स्वामी, तोरो दासों म सी जो कोयी को जवर ऊ निकले, त ऊ मार डाल्यो जाये, अऊर हम भी ऊ स्वामी को दास होय जाबो।” ");
INSERT INTO lbm_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","घर को अधिकारी न कह्यो, “तुम्हरोच कहनो सही हय, जेको जवर कटोरा निकले ऊ मोरो दास होयेंन, अऊर तुम लोग निर्दोष ठहरो।” ");
INSERT INTO lbm_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","यो बात पर हर एक आदमी अपनो अपनो बोरा ख जमीन पर जल्दी रख क उन्ख खोलन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","तब यूसुफ को घर को अधिकारी ढूंढन लग्यो, अऊर बड़ो भाऊ को बोरा सी ले क छोटो भाऊ को बोरा तक ढूंढ्यो; अऊर कटोरा बिन्यामीन को बोरा म मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","तब भाऊवों न अपनो अपनो दु:ख म कपड़ा फाड़्यो, अऊर अपनो अपनो गधा पर सामान रख क नगर ख लौट गयो। ");
INSERT INTO lbm_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","जब यहूदा अऊर ओको भाऊ यूसुफ को घर पर पहुंच्यो, त यूसुफ वहांच होतो, तब हि ओको आगु जमीन पर गिरयो। ");
INSERT INTO lbm_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","यूसुफ न उन्को सी कह्यो, “तुम लोगों न यो कसो काम करयो हय? का तुम नहीं जानत होतो, कि मोरो जसो आदमी लूकी हुयी बातों ख भी कर सकय हय?” ");
INSERT INTO lbm_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदा न कह्यो, “हम लोग अपनो स्वामी सी का कह्यबो? हम का कह्य क अपनो ख निर्दोष ठहराबो? परमेश्वर न तोरो दासों को अधर्म ख पकड़ लियो हय। हम, अऊर जेको जवर कटोरा निकल्यो ऊ भी, हम सब को सब अपनो स्वामी को दासच हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","“यूसुफ न कह्यो असो काम मोरो सी दूरच रहे, जेको जवर कटोरा निकल्यो हय उच मोरो दास होयेंन; अऊर तुम लोग अपनो बाप को जवर अच्छो सी चली जावो।” ");
INSERT INTO lbm_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","तब यहूदा ओको जवर जाय क कहन लग्यो, “हे मोरो स्वामी, तोरो दास ख अपनो स्वामी सी एक बात कहन की आज्ञा हय, अऊर तोरो गुस्सा तोरो दास पर नहीं हो; कहालीकि तय त फिरौन राजा को जसो हय। ");
INSERT INTO lbm_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","मोरो स्वामी न अपनो दासों सी पुच्छ्यो होतो, ‘का तुम्हरो बाप अऊर कोयी दूसरो भी भाऊ हय?’ ");
INSERT INTO lbm_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","अऊर हम न अपनो स्वामी सी कह्यो, ‘हव, हमरो बूढ्ढा बाप हय, अऊर ओको बुढ़ापा को सहारा एक छोटो सो बच्चा भी हय, पर ओको भाऊ मर गयो हय, येकोलायी ऊ अब अपनी माय को अकेलोच बच्चा रह्य गयो हय, अऊर ओको बाप ओको सी प्रेम रखय हय।’ ");
INSERT INTO lbm_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","तब तय न अपनो दासों सी कह्यो होतो, ‘ओख मोरो जवर ले आवो, जेको सी मय ओख देख सकू।’ ");
INSERT INTO lbm_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","तब हम न अपनो स्वामी सी कह्यो होतो, ‘ऊ टुरा अपनो बाप ख नहीं छोड़ सकय; नहीं त ओको बाप मर जायेंन।’ ");
INSERT INTO lbm_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","अऊर तय न अपनो दासों सी कह्यो, ‘यदि तुम्हरो छोटो भाऊ तुम्हरो संग नहीं आये, त तुम मोरो जवर कभी नहीं आनो पावों।’ ");
INSERT INTO lbm_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“येकोलायी जब हम अपनो बाप अऊर तोरो दास को जवर गयो, तब हम न ओको सी अपनो स्वामी की बाते कही। ");
INSERT INTO lbm_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","तब हमरो बाप न कह्यो, ‘फिर जाय क हमरो लायी थोड़ी सी खान की चिज लेय क लावो।’ ");
INSERT INTO lbm_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","हम न कह्यो, ‘हम नहीं जाय सकजे, हव, यदि हमरो छोटो भाऊ हमरो संग रहे, तब हम जाबो; यदि हमरो छोटो भाऊ हमरो संग नहीं रहेंन, त हम ऊ आदमी को जवर नहीं जाय सकजे।’ ");
INSERT INTO lbm_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","तब तोरो दास अऊर हमरो बाप न हम सी कह्यो, ‘तुम त जानय हय कि मोरी बाई राहेल सी दोय टुरा पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","अऊर उन म सी एक त मोख छोड़ क चली गयो, अऊर मय न निश्चय कर लियो कि ऊ कोयी जनावर को वजह टुकड़ा टुकड़ा कर दियो गयो होना, अऊर तब सी मय ओको मुंह भी नहीं देख सक्यो। ");
INSERT INTO lbm_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","यदि तुम येख भी मोरी आंखी को आगु सी ले जावो, अऊर कोयी संकट येको पर पड़े, त तुम्हरो वजह म यो बुढ़ापा को समय म दु:ख को संग अधोलोक म उतर जाऊं।’ ");
INSERT INTO lbm_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“येकोलायी जब मय अपनो बाप अऊर तोरो दास को जवर पहुंचू अऊर यो लड़का संग म नहीं रहेंन, त ओको जीव त येकोच पर अटक्यो रहेंन, ");
INSERT INTO lbm_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","तब ऊ देखेंन कि लड़का नहाय त ऊ तुरतच मर जायेंन। तब तोरो दासों को वजह तोरो दास अऊर हमरो बाप, जो बुढ़ापा को समय म, दु:ख को संग अधोलोक म उतर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","मय तोरो दास अपनो बाप को इत यो कह्य क् लड़का लायी अपनो जीवन गिरवी रख्यो हय, यदि मय येख तोरो जवर नहीं पहुंचाय देऊ, त मय हमेशा लायी तोरो अपराधी ठहरूं। ");
INSERT INTO lbm_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","येकोलायी अब तोरो दास यो लड़का को बदला अपनो स्वामी को दास होय क रहन की आज्ञा पाये, अऊर यो लड़का ख अपनो भाऊवों को संग जान दियो जाये। ");
INSERT INTO lbm_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","यदि लड़का मोरो संग नहीं हो त मय कसो अपनो बाप को जवर जाय सकूं; कही असो नहीं होय कि मोरो बाप पर जो दु:ख पड़ेंन ओख मोख देखनो पड़े।” ");
INSERT INTO lbm_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","तब यूसुफ उन सब को आगु जो ओको जवर जवर खड़ो होतो, अपनो ख अऊर रोख नहीं सक्यो; अऊर पुकार क कह्यो, “मोरो जवर जवर सी सब लोगों ख बाहेर क देवो।” भाऊवों को आगु अपनो ख प्रगट करन को समय यूसुफ को संग अऊर कोयी नहीं रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","तब ऊ ऊची आवाज सी रोवन लग्यो; अऊर मिस्रियों न सुन्यो, अऊर फिरौन को घर को लोगों ख भी येको समाचार मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","तब यूसुफ अपनो भाऊवों सी कहन लग्यो, “मय यूसुफ आय, का मोरो बाप अभी तक जीन्दो हय?” येको उत्तर ओको भाऊ नहीं दे सक्यो; कहालीकि हि ओको आगु घबराय गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","तब यूसुफ न अपनो भाऊवों सी कह्यो, “मोरो जवर आवो।” यो सुन क हि जवर गयो। तब ओन कह्यो, “मय तुम्हरो भाऊ यूसुफ आय, जेक तुम न मिस्र देश सी आन वालो व्यापारी को हाथ बेच डाल्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","अब तुम लोग मत पछतावो, अऊर तुम न जो मोख इत बेच डाल्यो, येको सी उदास मत होवो; कहालीकि परमेश्वर न तुम्हरो जीवो ख बचान लायी मोख तुम्हरो आगु भेज दियो हय। ");
INSERT INTO lbm_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","कहालीकि अब दोय साल सी यो देश म अकाल हय; अऊर अब पाच साल अऊर असोच होयेंन कि उन्म त नहीं नांगर चलेंन अऊर नहीं अनाज काट्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","येकोलायी परमेश्वर न मोख तुम्हरो आगु येकोच लायी भेज्यो कि तुम धरती पर जीन्दो रहो, अऊर तुम्हरो जीवो को बचनो सी तुम्हरो वंश बढ़े। ");
INSERT INTO lbm_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","यो रीति सी अब मोख यहां पर भेजन वालो तुम नहीं, परमेश्वरच ठहरयो; अऊर ओनच मोख फिरौन को बाप, अऊर ओको पूरो घर को स्वामी, अऊर पूरो मिस्र देश को अधिकारी भी ठहराय दियो हय। ");
INSERT INTO lbm_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“तब जल्दी मोरो बाप को जवर जाय क कहो, ‘तोरो बेटा यूसुफ यो कह्य हय कि परमेश्वर न मोख पूरो मिस्र को स्वामी ठहरायो हय; येकोलायी तय मोरो जवर बिना रुक्यो चल्यो आव। ");
INSERT INTO lbm_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","तोरो निवास गोशेन देश म होयेंन, अऊर तय अपनो बेटा, नाती, शेरी मेंढी, गाय बईल, अऊर अपनो सब कुछ धर क मोरो जवर रह्यजो। ");
INSERT INTO lbm_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","अऊर अकाल को जो पाच साल अऊर होयेंन, उन्म मय उतच तोरो पालन पोषन करूं; असो नहीं होय कि तय अऊर तोरो घराना, बल्की जितनो तोरो जनावर हंय, हि भूखो मरे।’” ");
INSERT INTO lbm_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","अऊर तुम अपनी आंखी सी देखय हय, “अऊर मोरो भाऊ बिन्यामीन भी अपनी आंखी सी देखय हय कि जो हम सी बाते कर रह्यो हय ऊ यूसुफ आय। ");
INSERT INTO lbm_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","तुम मोरो सब वैभव को, जो मिस्र म हय अऊर जो कुछ तुम न देख्यो हय, ऊ बात को मोरो बाप सी वर्नन करजो; अऊर तुरतच मोरो बाप ख इत ले आजो।” ");
INSERT INTO lbm_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","तब ऊ अपनो भाऊ बिन्यामीन को गरो सी लिपट क रोयो; अऊर बिन्यामीन भी ओको गरो सी लिपट क रोयो। ");
INSERT INTO lbm_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ऊ अपनो सब भाऊवों ख चुम्मा ले क रोयो, अऊर येको बाद ओको भाऊ ओको सी बाते करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","यो बात को समाचार, कि यूसुफ को भाऊ आयो हंय, फिरौन को भवन तक पहुंच गयो, अऊर येको सी फिरौन अऊर ओको कर्मचारी प्रसन्न भयो। ");
INSERT INTO lbm_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","येकोलायी फिरौन न यूसुफ सी कह्यो, “अपनो भाऊवों सी कह्य कि एक काम करो : अपनो जनावरों पर अनाज रख क कनान देश म चली जावो। ");
INSERT INTO lbm_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","अऊर अपनो बाप अऊर अपनो अपनो घर को लोगों ख ले क मोरो जवर आवो; अऊर मिस्र देश म जो कुछ अच्छो सो अच्छो हय ऊ मय तुम्ख देऊं, अऊर तुम्ख देश को अच्छो सी अच्छो चिज खान ख मिलेंन। ");
INSERT INTO lbm_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","अऊर तोख आज्ञा मिली हय, ‘तुम एक काम करो कि मिस्र देश सी अपनो बाल बच्चां अऊर बाईयों लायी गाड़ियां ले जावो, अऊर अपनो बाप ख ले आवो। ");
INSERT INTO lbm_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","अऊर अपनो सामान की चिन्ता नहीं करे कहालीकि पूरो मिस्र देश म जो कुछ अच्छो सी अच्छो हय ऊ तुम्हरो हय’।” ");
INSERT INTO lbm_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","याकूब को टुरावों न वसोच करयो; अऊर यूसुफ न फिरौन की आज्ञा को अनुसार उन्ख गाड़ियां दी, अऊर रस्ता लायी जेवन को सामान भी दियो। ");
INSERT INTO lbm_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","उन्म सी एक एक जन ख ओन एक एक जोड़ा कपड़ा भी दियो; अऊर बिन्यामीन ख तीन सौ चांदी को सिक्का को संग पाच जोड़ी कपड़ा भी दियो। ");
INSERT INTO lbm_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","अपनो बाप को जवर ओन जो भेज्यो ऊ यो आय, मिस्र की अच्छी चिजों सी भरयो हुयो दस गधा, अऊर अनाज रोटी अऊर ओको बाप की रस्ता लायी जेवन की चिज सी भरी हुयी दस गधी। ");
INSERT INTO lbm_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","तब ओन अपनो भाऊवों ख बिदा करयो, अऊर हि चली गयो; अऊर ओन उन्को सी कह्यो, “रस्ता म कही झगड़ा मत करो।” ");
INSERT INTO lbm_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","मिस्र सी आय क हि कनान देश म अपनो बाप याकूब को जवर पहुंच्यो। ");
INSERT INTO lbm_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","अऊर ओको सी यो कह्यो, “यूसुफ अब तक जीन्दो हय, अऊर पूरो मिस्र देश पर शासन उच करय हय।” पर ओन उन्की बातों पर विश्वास नहीं करयो अऊर दंग भय गयो। ");
INSERT INTO lbm_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","तब उन्न अपनो बाप याकूब सी यूसुफ की पूरी बाते, जो ओन उन्को सी कही होती उन्न ओको सी कह्य दी। जब ओन उन गाड़ियों ख देख्यो, जो यूसुफ न ओख लेन लायी भेजी होती, तब ओको जीव म जीव आयो। ");
INSERT INTO lbm_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","अऊर याकूब न कह्यो, “बस, मोरो बेटा यूसुफ अभी तक जीन्दो हय; मय अपनो जीव निकलन को पहिले जाय क ओख देखूं।” ");
INSERT INTO lbm_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","तब याकूब अपनो सब कुछ ले क बेर्शेबा ख गयो, अऊर उत अपनो बाप इसहाक को परमेश्वर ख बलिदान चढ़ायो। ");
INSERT INTO lbm_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","तब परमेश्वर न याकूब सी रात ख दर्शन म कह्यो, “हे याकूब, हे याकूब।” ओन कह्यो, “का आज्ञा हय।” ");
INSERT INTO lbm_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","परमेश्वर न कह्यो, “मय परमेश्वर आय, तोरो बाप को परमेश्वर; तय मिस्र म जान सी मत डर; कहालीकि मय तोरो सी उत एक बड़ी जाति बनाऊं। ");
INSERT INTO lbm_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मय तोरो संग संग मिस्र ख चलू हय, अऊर मय तोख उत सी फिर सी वापस ले आऊं; अऊर यूसुफ अपनो हाथ सी तोरी आंखी ख बन्द करेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","तब याकूब बेर्शेबा सी चल्यो; अऊर याकूब को टुरा अपनो बाप याकूब अऊर अपनो टुरावों न, अऊर बाईयों ख उन गाड़ियों पर बैठायो, जो फिरौन न उन्ख लिजान लायी भेजी होती। ");
INSERT INTO lbm_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","हि अपनी शेरी मेंढी गाय बईल, अऊर कनान देश म अपनो जमा करयो हुयो पूरो धन ख ले क मिस्र म आयो; ");
INSERT INTO lbm_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","अऊर याकूब अपनो टुरा टुरियां, नाती नातिन, यानेकि अपनो पूरो वंश ख अपनो संग मिस्र देश म ले आयो। ");
INSERT INTO lbm_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","याकूब को संग जो इस्राएली, यानेकि याकूब को टुरा, नाती पहिले, मिस्र देश म आयो, उन्को नाम यो हंय : याकूब को बड़ो टुरा रूबेन होतो; ");
INSERT INTO lbm_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","अऊर रूबेन को टुरा हनोक, पल्लू, हेस्रोन अऊर कर्म्मी होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमोन को टुरा यमूएल यामीन, ओहद, याकीन, सोहर, अऊर एक कनानी बाई सी जनम्यो हुयो शाऊल भी होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवी को टुरा गेर्शोन, कहात, अऊर मरारी होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदा को टुरा एर, ओनान, शेला, पेरेस, अऊर जेरह नाम को टुरा भयो त होतो पर एर अऊर ओनान कनान देश म मर गयो होतो; अऊर पेरेस को टुरा हेस्रोन अऊर हामूल होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साकार को टुरा तोला, पुब्बा, योब, अऊर शिम्रोन होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलून को टुरा सेरेद एलोन, अऊर यहलेल होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","लिआ : को टुरा जो याकूब सी पद्दनराम म पैदा भयो होतो, उन्को बेटा अऊर नाती हिच होतो, अऊर इन्को सी जादा ओन ओको संग एक बेटी दीना ख भी जनम दियो। यहां तक त याकूब को सब वंश वालो तैंतीस लोग भयो। ");
INSERT INTO lbm_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","तब गाद को टुरा सिय्योन, हाग्गी, शूनी, एसबोन, एरी, अरोदी, अऊर अरेली होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेर को टुरा यिम्ना, यिश्वा, यिस्वी, अऊर उन्की बहिन सेरह होती; अऊर बरीआ को टुरा हेबेर अऊर मल्कीएल होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","जिल्पा, जेक लाबान न अपनी बेटी लिआ : ख दी होती, ओको बेटा अऊर नाती पहिले हिच होतो; अऊर ओको द्वारा याकूब को सोला लोग पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","तब याकूब की पत्नी राहेल को टुरा यूसुफ अऊर बिन्यामीन होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","अऊर मिस्र देश म ओन को याजक पोतीपेरा की बेटी आसनत सी यूसुफ को यो बेटा पैदा भयो, यानेकि मनश्शे अऊर एप्रैम। ");
INSERT INTO lbm_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","अऊर बिन्यामीन को टुरा बेला, बेकेर, अश्बेल, गेरा, नामान, एही, रोश, मुप्पीम, हुप्पीम अऊर आर्द होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","राहेल को टुरा जो याकूब सी पैदा भयो ओको योच टुरा होतो; ओको यो सब बेटा अऊर नाती चौदा लोग भयो। ");
INSERT INTO lbm_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","तब दान को टुरा हूशीम होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्ताली को टुरा यहसेल, गूनी, सेसेर, अऊर शिल्लेम होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","बिल्हा दासी, जेक लाबान न अपनी बेटी राहेल ख दियो, ओको बेटा अऊर नाती हिच आय; ओको द्वारा याकूब को वंश म सात लोग भयो। ");
INSERT INTO lbm_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकूब को वंश को पूरो लोग जो उन्को संग मिस्र म आयो होतो, याकूब की बहुवों ख छोड़ क सब मिल क छियासठ लोग होतो। ");
INSERT INTO lbm_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","अऊर यूसुफ को बेटा, जो मिस्र म ओको सी पैदा भयो, हि दोय लोग होतो; यो तरह याकूब को घरानो को जो लोग मिस्र म आयो हि सब मिल क सत्तर भयो। ");
INSERT INTO lbm_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","तब याकूब न यहूदा ख अपनो आगु यूसुफ को जवर भेज दियो कि ऊ ओख गोशेन की रस्ता दिखाये; अऊर हि गोशेन देश म आयो। ");
INSERT INTO lbm_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","तब यूसुफ अपनो रथ जुतवाय क अपनो बाप याकूब सी भेंट करन लायी गोशेन देश ख गयो, अऊर याकूब सी भेंट कर क् ओको गलो सी लपट्यो, अऊर बहुत देर तक याकूब को गलो सी लपट्यो हुयो रोतो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","तब याकूब न यूसुफ सी कह्यो, “मय अब मरनो सी भी प्रसन्न हय, कहालीकि तोख जीन्दो पायो अऊर तोरो मुंह देख लियो।” ");
INSERT INTO lbm_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","तब यूसुफ न अपनो भाऊवों सी अऊर अपनो बाप को घरानो सी कह्यो, “मय जाय क फिरौन ख यो कह्य क समाचार देऊं, ‘मोरो भाऊ अऊर मोरो बाप को पूरो घरानो को लोग, जो कनान देश म रहत होतो, हि मोरो जवर आय गयो हंय; ");
INSERT INTO lbm_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","अऊर हि लोग चरवाहे हंय, कहालीकि हि जनावरों ख पालतो आयो हंय; येकोलायी हि अपनी शेरी मेंढी, गाय बईल, अऊर जो कुछ उन्को हय, सब ले आयो हंय।’ ");
INSERT INTO lbm_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जब फिरौन तुम ख बुलाय क पूछे, ‘तुम्हरो धन्दा का हय?’ ");
INSERT INTO lbm_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तब यो कह्यजो, ‘तोरो दास बचपन सी ले क अज तक जनावरों ख पालतो आयो हंय, बल्की हमरो पूर्वज भी असोच करत होतो।’ येको सी तुम गोशेन देश म रहनो पावों; कहालीकि सब चरवाहों सी मिस्री लोग घृना करय हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","तब यूसुफ न फिरौन को जवर जाय क यो समाचार दियो, “मोरो बाप अऊर मोरो भाऊ, अऊर उन्की शेरी मेंढियां, गाय बईल अऊर जो कुछ उन्को हय, सब कनान देश सी आय गयो हय; अऊर अभी त हि गोशेन देश म हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","तब यूसुफ अपनो भाऊवों म सी पाच जन ख ले क फिरौन को आगु खड़ो कर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फिरौन न यूसुफ को भाऊवों सी पुच्छ्यो, “तुम्हरो काम का हय?” उन्न फिरौन सी कह्यो, “तोरो दास चरवाहे हंय, अऊर हमरो पूर्वजों भी असोच रह्यो।” ");
INSERT INTO lbm_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","तब उन्न फिरौन सी कह्यो, “हम यो देश म परदेशी को भाति रहन लायी आयो हंय; कहालीकि कनान देश म भारी अकाल होन को वजह तोरो दासों की शेरी मेंढियों लायी चारा नहीं रह्यो; येकोलायी अपनो दासों ख गोशेन देश म रहन की आज्ञा दे।” ");
INSERT INTO lbm_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","तब फिरौन न यूसुफ सी कह्यो, “तोरो बाप अऊर तोरो भाऊ तोरो जवर आय गयो हंय, ");
INSERT INTO lbm_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","अऊर मिस्र देश तोरो आगु पड़्यो हय; यो देश को जो सब सी अच्छो भाग हो, ओको म अपनो बाप अऊर भाऊवों ख बसाय दे, मतलब हि गोशेन देश मच रहे; अऊर यदि तय जानय हय, कि उन्म कोयी मेहनती आदमी हंय, त उन्ख मोरो जनावरों को अधिकारी ठहराय दे।” ");
INSERT INTO lbm_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","तब यूसुफ न अपनो बाप याकूब ख लाय क फिरौन को जवर खड़ो करयो; अऊर याकूब न फिरौन ख आशीर्वाद दियो। ");
INSERT INTO lbm_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","तब फिरौन न याकूब सी पुच्छ्यो, “तोरी उमर कितनो साल की भयी हय?” ");
INSERT INTO lbm_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूब न फिरौन सी कह्यो, “मय एक सौ तीस साल परदेशी होय क अपनो जीवन बिताय चुक्यो हय; मोरो जीवन को दिन थोड़ो अऊर दु:ख सी भरयो हुयो भी होतो, अऊर मोरो पूर्वजों परदेशी होय क जितनो दिन तक जीन्दो रह्यो उतनो दिन को मय अभी नहीं भयो।” ");
INSERT INTO lbm_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","अऊर याकूब फिरौन ख आशीर्वाद दे क ओको जवर सी चली गयो। ");
INSERT INTO lbm_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","तब यूसुफ न अपनो बाप अऊर भाऊवों ख बसाय दियो, अऊर फिरौन कि आज्ञा को अनुसार मिस्र देश को अच्छो सी अच्छो भाग म, मतलब रामसेस नाम को प्रदेश म, जमीन दे क उन्ख सौंप दियो। ");
INSERT INTO lbm_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","अऊर यूसुफ अपनो बाप को, अऊर अपनो भाऊवों को, अऊर बाप को पूरो घराना को, एक एक को बाल बच्चां की गिनती को अनुसार, भोजन दिलाय दिलाय क उन्को पालन पोषन करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ऊ पूरो देश म खान लायी कुछ नहीं रह्यो; कहालीकि अकाल बहुत भारी होतो, अऊर अकाल को वजह मिस्र अऊर कनान दोयी देश भूख को वजह तरस गयो ");
INSERT INTO lbm_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","अऊर जितनो रुपया मिस्र अऊर कनान देश म होतो, सब ख यूसुफ ऊ अनाज को बदला, जो उन्को निवासी लेत होतो, उन्ख जमा कर क् फिरौन को भवन म पहुंचाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जब मिस्र अऊर कनान देश को रुपया खतम भय गयो, तब सब मिस्री यूसुफ को जवर आय क कहन लग्यो, “हम ख खान की चिज दे; का हम रुपया को नहीं रहनो सी तोरो रहतो हुयो मर जाये?” ");
INSERT INTO lbm_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","यूसुफ न कह्यो, “यदि रुपया नहाय त अपनो जनावर दे दो, अऊर मय उन्को बदला म तुम्ख खान ख देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","तब हि अपनो जनावर यूसुफ को जवर ले आयो; अऊर यूसुफ उन्ख घोड़ा, शेरी मेंढियां, गाय बईलों अऊर गधा को बदला खान ख देन लग्यो : ऊ साल म ऊ सब जाति को जनावरों को बदला जेवन दे क उन्को पालन पोषन करतो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ऊ साल त असोच कट गयो; तब अगले साल म उन्न यूसुफ को जवर आय क कह्यो, “हम अपनो प्रभु सी यो बात छुपाय क नहीं रखबोंन कि हमरो रुपया खतम होय गयो हय, अऊर हमरो हर तरह को जनावर हमरो प्रभु को भय गयो हंय; येकोलायी अब हमरो प्रभु को आगु हमरो शरीर अऊर जमीन छोड़ क कुछ भी नहीं रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","हम तोरो देखतो म कहाली मरबो, अऊर हमरी जमीन कहाली उजड़ जायेंन? हम्ख अऊर हमरी जमीन ख जेवन की चिज को बदला लेय ले, कि हम अपनी जमीन सहीत फिरौन को दास हो : अऊर हम्ख बीज दे कि हम मरनो नहीं पाये, अऊर जीन्दो रहे, अऊर जमीन नहीं उजड़े।” ");
INSERT INTO lbm_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","तब यूसुफ न मिस्र की पूरी जमीन ख फिरौन लायी लेय लियो; कहालीकि ऊ भयंकर अकाल को पड़नो सी मिस्रियों ख अपनो अपनो खेत बेच डालनो पड़्यो। यो तरह पूरी जमीन फिरौन की भय गयी; ");
INSERT INTO lbm_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","अऊर एक कोना सी ले क दूसरो कोना तक पूरो मिस्र देश म जो प्रजा रहत होती, ओख यूसुफ न नगरों म लाय क बसाय दियो। ");
INSERT INTO lbm_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","पर याजकों की जमीन ओन लेय नहीं ली; कहालीकि याजकों लायी फिरौन को तरफ सी लगातार भोजन को बन्दोबस्त होतो, अऊर लगातार जो भोजन फिरौन उन्ख देत होतो उच हि खात होतो, यो वजह उन्ख अपनी जमीन बेचनी नहीं पड़ी। ");
INSERT INTO lbm_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","तब यूसुफ न प्रजा को लोगों सी कह्यो, “सुनो, मय न अज को दिन तुम ख अऊर तुम्हरी जमीन ख भी फिरौन लायी लेय लियो हय; देखो, तुम्हरो लायी इत बीज हय, येख जमीन म बोवो। ");
INSERT INTO lbm_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","अऊर जो कुछ जमीन सी होयेंन ओको पाचवों अंश फिरौन ख देवो, बाकी चार अंश तुम्हरो रहेंन कि तुम ओख अपनो खेतो म बोवो, अऊर अपनो अपनो बाल बच्चां अऊर घर को दूसरो लोगों सहित खायो करो।” ");
INSERT INTO lbm_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","उन्न कह्यो, “तय न हम्ख बचाय लियो हय; हमरो प्रभु की अनुग्रह की नजर हम पर बनी रहे, अऊर हम फिरौन को दास होय क रहबोंन।” ");
INSERT INTO lbm_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","यो तरह यूसुफ न मिस्र की जमीन को बारे म असो नियम ठहरायो हय, जो अज को दिन तक चल्यो आवय हय कि पाचवों अंश फिरौन ख मिल्यो करे; केवल याजकों कीच जमीन फिरौन की नहीं भयी। ");
INSERT INTO lbm_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्राएली मिस्र को गोशेन प्रदेश म रहन लग्यो; अऊर उत की जमीन उन्को बस म होती; अऊर हि बहुतायत सी बढ़्यो अऊर उन्को कुछ बच्चा भयो। ");
INSERT INTO lbm_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","मिस्र देश म याकूब सत्रा साल जीन्दो रह्यो : यो तरह याकूब की पूरी उमर एक सौ सैंतालीस साल की भयी। ");
INSERT INTO lbm_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","जब इस्राएल को मरन को दिन जवर आयो, तब ओन अपनो टुरा यूसुफ ख बुलाय क कह्यो, “यदि तोरो अनुग्रह मोरो पर हो, त अपनो हाथ मोरी जांघ पर रख क कसम खा कि तय मोरो संग कृपा अऊर सच्चायी को यो काम करजो कि मोख मिस्र देश म माटी नहीं देजो। ");
INSERT INTO lbm_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","जब मय अपनो बापदादों को संग सोय जाऊं, तब तय मोख मिस्र देश सी लिजाय क उन्कोच कब्रस्थान म रखजो।” तब यूसुफ न कह्यो, “मय तोरो वचन को अनुसार करूं।” ");
INSERT INTO lbm_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","तब याकूब न कह्यो, “मोरो सी कसम खा।” तब यूसुफ न ओको सी कसम खायी। तब याकूब न खटिया को मुन्डेसो को तरफ मुंड झुकाय क प्रार्थना करी। ");
INSERT INTO lbm_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","इन बातों को बाद कोयी न यूसुफ सी कह्यो, “सुन तोरो बाप बीमार हय।” तब यूसुफ मनश्शे अऊर एप्रैम नाम को दोयी टुरावों ख संग ले क याकूब को जवर गयो। ");
INSERT INTO lbm_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","कोयी न याकूब ख बताय दियो, “तोरो टुरा यूसुफ तोरो जवर आय रह्यो हय,” तब याकूब अपनो ख सम्भाल क खटिया पर बैठ गयो ");
INSERT INTO lbm_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","अऊर याकूब न यूसुफ सी कह्यो, “सर्वशक्तिमान परमेश्वर न कनान देश को लूज नगर को जवर मोख दर्शन दे क आशीष दी, ");
INSERT INTO lbm_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","अऊर कह्यो, ‘सुन, मय तोख फलवन्त कर क् बढ़ाऊं, अऊर तोख राज्य राज्य की मण्डली को मूल बनाऊं, अऊर तोरो बाद तोरो वंश ख यो देश देऊं, जेको सी कि ऊ हमेशा तक उन्की निजी जमीन बनी रहे।’” ");
INSERT INTO lbm_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","अऊर अब तोरो दोयी टुरा, “जो मिस्र म मोरो आन को पहिले पैदा भयो हंय, हि मोरोच ठहरेंन; मतलब जो रीति सी रूबेन अऊर शिमोन मोरो हंय, उच रीति सी एप्रैम अऊर मनश्शे भी मोरो ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","अऊर उन्को बाद तोरी जो सन्तान पैदा होयेंन ऊ तोरी त ठहरेंन; पर बंटवारा को समय हि अपनो भाऊवों कोच वंश म गिन्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","जब मय पद्दान सी आय रह्यो होतो, तब एप्राता नगर पहुंचन सी थोड़ोच दूर पहिले राहेल कनान देश म, रस्ता म, मोरो आगु मर गयी; अऊर मय न ओख उतच, मतलब एप्राता नगर जो बैतलहम भी कहलावय हय, उच रस्ता म माटी दी।” ");
INSERT INTO lbm_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","तब याकूब न यूसुफ को टुरावों ख देख्यो, तब पुच्छ्यो, “हि टुरा कौन आय?” ");
INSERT INTO lbm_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","यूसुफ न अपनो बाप सी कह्यो, “हि मोरो टुरा आय, जो परमेश्वर न मोख इत दियो हंय।” याकूब न कह्यो, “उन्ख मोरो जवर ले आव कि मय उन्ख आशीर्वाद देऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","याकूब की आंखी बुढ़ापा को वजह धुन्धरी भय गयी होती, यहां तक कि ओख कम दिखायी देत होतो। तब यूसुफ अपनो टुरावों ख याकूब को जवर लिजायो; अऊर ओन उन्ख चुम क गरो लगाय लियो। ");
INSERT INTO lbm_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","तब याकूब न यूसुफ सी कह्यो, “मय न सोच्यो तो नहीं कि मय तोरो मुख फिर सी देखनो पाऊं : पर देख, परमेश्वर न मोख तोरो वंश भी दिखायो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","यूसुफ न उन्ख अपनो बाप को घुटना को बीच सी हटायो अऊर जमीन को तरफ मुंड झुकाय क दण्डवत करयो। ");
INSERT INTO lbm_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","तब यूसुफ न उन दिनों ख ले क, मतलब एप्रैम ख अपनो दायो हाथ सी कि ऊ याकूब को बायो हाथ पड़े, अऊर मनश्शे ख अपनो बायो हाथ सी कि ऊ याकूब को दायो हाथ पड़े, उन्ख ओको जवर लिजायो। ");
INSERT INTO lbm_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","तब याकूब न अपनो दायो हाथ बढ़ाय क एप्रैम की मुंड पर जो छोटो होतो, अऊर अपनो बायो हाथ बढ़ाय क मनश्शे की मुंड पर रख दियो; ओन जान बुझ क असो करयो नहीं त बड़ो मनश्शेच होतो। ");
INSERT INTO lbm_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","तब ओन यूसुफ ख आशीर्वाद दे क कह्यो, “परमेश्वर जेकी उपस्थिति म रह्य क मोरो बापदादा अब्राहम अऊर इसहाक चल्यो, उच परमेश्वर मोरो जनम सी ले क अज को दिन तक मोरो देखभाल करन वालो बन्यो हय; ");
INSERT INTO lbm_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","अऊर उच स्वर्गदूत मोख पूरी बुरायी सी छुड़ातो आयो हय, उच अब इन टुरावों ख आशीष दे; अऊर हि मोरो अऊर मोरो बापदादा अब्राहम अऊर इसहाक को कहलाये; अऊर धरती म बहुतायत सी बढ़े।” ");
INSERT INTO lbm_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","जब यूसुफ न देख्यो कि मोरो बाप न अपनो दायो हाथ एप्रैम की मुंड पर रख्यो हय, तब या बात यूसुफ ख बुरी लगी; येकोलायी ओन अपनो बाप को हाथ यो बिचार सी पकड़ लियो कि एप्रैम की मुंड पर सी उठाय क मनश्शे की मुंड पर रख दे। ");
INSERT INTO lbm_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","अऊर यूसुफ न अपनो बाप सी कह्यो, “हे बाप, असो नहीं; कहालीकि बड़ो योच आय; अपनो दायो हाथ येकी मुंड पर रख।” ");
INSERT INTO lbm_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ओको बाप न कह्यो, “नहीं; सुन, हे मोरो टुरा, मय या बात ख अच्छो सी जानु हय : अऊर येको सी भी आदमियों की एक मण्डली पैदा होयेंन, अऊर ऊ भी महान होय जायेंन, तब भी येको छोटो भाऊ येको सी बहुत ज्यादा महान होय जायेंन, अऊर ओको वंश सी बहुत सी जातियां निकलेंन।” ");
INSERT INTO lbm_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","तब ओको बाप न उच दिन यो कह्य क उन्ख आशीर्वाद दियो, “इस्राएली लोग तोरो नाम ले ले क असो आशीर्वाद दियो करेंन, ‘परमेश्वर तोख एप्रैम अऊर मनश्शे को जसो बना दे,’” अऊर ओन मनश्शे सी पहिले एप्रैम को नाम लियो। ");
INSERT INTO lbm_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","तब याकूब न यूसुफ सी कह्यो, “देख, मय त मरन पर हय : पर परमेश्वर तुम लोगों को संग रहेंन, अऊर तुम ख तुम्हरो पूर्वजों को देश म फिर पहुंचाय देयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","अऊर मय तोख तोरो भाऊवों सी ज्यादा जमीन को एक भाग देऊ हय, जेक मय न एमोरी जाति को हाथ सी अपनी तलवार अऊर धनुष की ताकत सी ले लियो हय।” ");
INSERT INTO lbm_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","तब याकूब न अपनो टुरावों ख यो कह्य क बुलायो, “जमा होय जावो, मय तुम ख बताऊं कि आखरी को दिनों म तुम पर का का बीतेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“हे याकूब को टुरावों, जमा होय क सुनो, अपनो बाप याकूब को तरफ कान लगावो। ");
INSERT INTO lbm_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“हे रूबेन, तय मोरो पहिलो अऊर बड़ो टुरा आय, अऊर मोरो आदमी होन को नाते पहिलो सबूत तयच आय; तय मोरो पूरो टुरावों सी बड़ो अभिमानी अऊर ताकतवर तयच हय। ");
INSERT INTO lbm_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तय एक भयंकर बाढ़ की लहर को जसो प्रचण्ड हय, येकोलायी तय मोरो पूरो टुरावों सी ज्यादा महत्व को नहीं होय सकजो; कहालीकि तय मोरी पत्नी को संग सोयो, अऊर तय न अपनो बाप को बिस्तर ख अशुद्ध करयो। ");
INSERT INTO lbm_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमोन अऊर लेवी भाऊ हंय, हि अपनी तलवार हिंसा करन लायी इस्तेमाल करय हंय। ");
INSERT INTO lbm_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","हे मोरो जीव, उन्की गुप्त बैठक म मत पड़, हे मोरी महिमा, उन्की सभा म मत मिल; कहालीकि उन्न गुस्सा म आदमियों ख मार डाल्यो हय, अऊर अपनीच इच्छा पर चल क बईलों ख लंगड़ा बनावय हंय। ");
INSERT INTO lbm_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","धिक्कार हय उन्को गुस्सा पर, कहालीकि ऊ भयंकर हय; अऊर उन्को गुस्सा ख, जो निर्दयी होतो; मय उन्ख याकूब को देश म अलग अलग अऊर इस्राएल म तितर बितर कर देऊं। ");
INSERT INTO lbm_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“हे यहूदा, तोरो भाऊ तोरो धन्यवाद करेंन, तोरो हाथ तोरो दुश्मनों की गर्दन पर पड़ेंन; तोरो बाप को टुरा तोख दण्डवत करेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा सिंह को बच्चा हय। हे मोरो टुरा, तय शिकार कर क् गुफा म गयो हय; ऊ सिंह जसो, सिंहनी को जसो झुक क बैठ्यो हय; तब कौन ओख छेड़ क उठाय सकय हय। ");
INSERT INTO lbm_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","जब तक शीलो नहीं आये तब तक राजदण्ड यहूदा सी नहीं छूटेंन, अऊर न ओको वंश सी व्यवस्था देन वालो अलग होयेंन; अऊर राज्य राज्य को लोग ओकी आज्ञा को पालन करेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ऊ अपनो जवान गधा ख अंगूर की बेला म, अऊर अपनी गधी को बच्चा ख सब सी अच्छी अंगूर की बेला म बान्ध्यो करेंन; ओन अपनो कपड़ा अंगूर को रस म, अऊर अपनो पहिनन वालो कपड़ा अंगूरीरस रस म धोवय हय। ");
INSERT INTO lbm_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ओकी आंखी अंगूर को रस पीवन सी लाल होती, अऊर ओको दात दूध सी ज्यादा सफेद हय। ");
INSERT INTO lbm_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“जबूलून समुन्दर को किनार पर निवास करेंन, ऊ जहाजों लायी बन्दरगाह को काम देयेंन, अऊर ओको राज्य की सीमा सीदोन देश तक पहुंचेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साकार एक ताकतवर गधा हय, जो जनावरों को झुण्ड को बीच म सोयो रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ओन एक आराम की जागा देख क, कि अच्छी हय, अऊर एक देश, कि मनोहर हय, अपनो बख्खा ख बोझ उठावन लायी झुकायो, अऊर बेगारी म दास को जसो काम करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“दान इस्राएल को एक गोत्र होय क अपनो जाति भाऊवों को न्याय करेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान रस्ता म को एक सांप, अऊर सड़क को किनार को एक नाग होयेंन, जो घोड़ा की एड़ी ख डंसय हय, जेको सी ओको सवार पछाड़ खाय क पीछू को तरफ गिर जावय हय। ");
INSERT INTO lbm_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“हे परमेश्वर, मय तोरो सीच उद्धार पावन की बाट देखत आयो हय। ");
INSERT INTO lbm_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“गाद पर एक डाकुवों को दल आक्रमन त करेंन; पर ऊ पीछू सी उन पर आक्रमन करेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आशेर सी जो अनाज पैदा होयेंन ऊ उत्तम होयेंन, अऊर ऊ राजा को लायक स्वादिष्ट जेवन दियो करेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नप्ताली एक छूटी हुयी हरिन की जसी हय वा सुन्दर बाते बोलय हय। ");
INSERT INTO lbm_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“यूसुफ फलवन्त डगाली की एक बेला आय, वा झरना को जवर लगी हुयी फलवन्त डगाली की एक बेला आय; ओकी डगालियां दीवार पर सी चढ़ क फैल जावय हंय। ");
INSERT INTO lbm_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धनुर्धारियों न ओको पर भयंकर आक्रमन करयो, अऊर ओको पर बान छोड्यो, अऊर ओख बहुत ज्यादा सतायो। ");
INSERT INTO lbm_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","तब भी ओको धनुष स्थिर रह्यो, अऊर ओकी भुजा अऊर हाथ याकूब को उच शक्तिमान परमेश्वर को हाथों को द्वारा फुर्तीलो भयो, जेको जवर ऊ चरवाहा आयेंन, जो इस्राएल नगर की चट्टान भी ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","यो तोरो बाप को ऊ परमेश्वर को नाम आय, जो तोरी मदत करेंन, ऊ सर्वशक्तिमान को जो तोख ऊपर सी आसमान म की आशीषें, अऊर खल्लो सी गहिरो पानी म की आशीषें, अऊर स्तनों अऊर गर्भ की आशीषें देयेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तोरो बाप को आशीर्वाद, मोरो पूर्वजों को आशीर्वादों सी ज्यादा बढ़ गयो हंय अऊर सनातन पहाड़ियों की मनचाही चिजों को जसो बन्यो रहेंन : हि यूसुफ की मुंड पर, जो अपनो भाऊवों सी अलग करयो गयो होतो, ओकोच मुंड को मुकुट पर फूले फलेंन। ");
INSERT INTO lbm_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बिन्यामीन बहुत खूंखार भेड़िया हय, सुबेरे त ऊ शिकार ख फाड़य, अऊर शाम ख लूट को माल बाटय हय।” ");
INSERT INTO lbm_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","इस्राएल को बारा गोत्र हिच आय : अऊर उन्को बाप न जो जो वचन सी उन्ख आशीर्वाद दियो, ऊ हिच आय; एक एक ख ओको लायक आशीर्वाद को अनुसार ओन आशीर्वाद दियो। ");
INSERT INTO lbm_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","तब ओन यो कह्य क उन्ख आज्ञा दी, “मय अपनो लोगों को संग मिलन पर हय : येकोलायी मोख हित्ती जाति एप्रोन की जमीन वाली गुफा म मोरो बापदादों को संग माटी देजो ");
INSERT INTO lbm_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","अऊर उच गुफा म जो कनान देश म मम्रे को आगु वाली मकपेला की जमीन म हय; ऊ जमीन ख अब्राहम न हित्ती जाति एप्रोन को हाथ सी येकोच लायी लेय लियो होतो कि ऊ कब्रस्थान लायी ओकी निजी जमीन हो। ");
INSERT INTO lbm_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","उत अब्राहम अऊर ओकी पत्नी सारा ख माटी दी गयी होती, अऊर उतच इसहाक अऊर ओकी पत्नी रिबका ख भी माटी दी गयी होती; अऊर उतच मय न लिआ : ख भी माटी दी। ");
INSERT INTO lbm_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ऊ जमीन अऊर ओको म की गुफा हित्तियों को हाथ सी ले ली होती।” ");
INSERT INTO lbm_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","याकूब जब अपनो टुरावों ख यो आज्ञा दे चुक्यो, तब अपनो पाय खटिया पर जमा कर क् जीव छोड़्यो, अऊर अपनो लोगों म जाय मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","तब यूसुफ अपनो बाप को मुंह पर गिर क रोयो अऊर अपनो बाप ख चुम्यो। ");
INSERT INTO lbm_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","अऊर यूसुफ न उन बैद्यों ख, जो ओको सेवक होतो, आज्ञा दी कि ओको बाप को शव म सुगन्ध की चिज भरे। तब बैद्यों न याकूब को शव म सुगन्ध की चिज भर दियो। ");
INSERT INTO lbm_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","अऊर ओको चालीस दिन पूरो भयो, कहालीकि जिन्को शव म सुगन्ध की चिज भरी जावय हंय, उन्ख इतनोच दिन पूरो लगय हंय : अऊर मिस्री लोग ओको लायी सत्तर दिन तक शोक मनातो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","जब ओको शोक को दिन बीत गयो, तब यूसुफ फिरौन को घराना सी कहन लग्यो, “यदि तुम्हरी अनुग्रह की नजर मोरो पर हो त मोरो सन्देश फिरौन ख सुनावो, ");
INSERT INTO lbm_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","मोरो बाप न यो कह्य क, मोख यो कसम खिलायी, ‘देख मय मरन पर हय,’ ‘जो कब्र मय न अपनो लायी कनान देश म खुदवायी हय ओकोच म मोख तय माटी देजो।’ येकोलायी अब मोख उत जाय क अपनो बाप ख माटी देन की आज्ञा दे, ओको बादच म लौट आऊं।” ");
INSERT INTO lbm_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","तब फिरौन न कह्यो, “जाय क अपनो बाप की खिलायी हुयी कसम को अनुसार ओख माटी दे।” ");
INSERT INTO lbm_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","येकोलायी यूसुफ अपनो बाप ख माटी देन लायी चली गयो, अऊर फिरौन को सब काम करन वालो अऊर ओको भवन को मुखिया अऊर मिस्र देश को सब मुखिया ओको संग चल्यो, ");
INSERT INTO lbm_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","अऊर यूसुफ को घर को सब लोग अऊर ओको भाऊ अऊर ओको बाप को घर को सब लोग भी संग गयो; पर हि अपनो बाल बच्चां, शेरी मेंढियों, अऊर गाय बईल ख गोशेन प्रदेश म छोड़ गयो। ");
INSERT INTO lbm_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","अऊर यूसुफ को संग रथ अऊर घुड़सवार भी गयो, यो तरह शव यात्रा म भीड़ बहुत भारी भय गयी। ");
INSERT INTO lbm_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जब हि आताद को खरियान तक, जो यरदन नदी को पार हय, उत पहुंच्यो, तब उत बहुत शोक मनायो; अऊर यूसुफ न अपनो बाप लायी सात दिन तक शोक करयो। ");
INSERT INTO lbm_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","आताद को खरियान म को शोक ख देख क ऊ नगर को निवासी कनानियों न कह्यो, “यो त मिस्रियों को कोयी भारी शोक होना।” योच वजह ऊ जागा को नाम आबेलमिस्रैम पड़्यो, अऊर ऊ यरदन को पार हय। ");
INSERT INTO lbm_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","याकूब को टुरावों न ठीक उच काम करयो, जसो ओन उन्ख आज्ञा दी होती ");
INSERT INTO lbm_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","अऊर उन्न याकूब ख कनान देश म ले जाय क मकपेला की ऊ जमीन वाली गुफा म, जो मम्रे को आगु हय, उत माटी दी; जेक अब्राहम न हित्ती एप्रोन को हाथ सी येकोलायी लेय लियो होतो कि ऊ कब्रस्थान लायी ओकी निजी जमीन हो। ");
INSERT INTO lbm_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","अपनो बाप ख माटी दे क यूसुफ अपनो भाऊवों अऊर उन सब को संग, जो ओको बाप ख माटी देन लायी ओको संग गयो होतो, उन सब को संग मिस्र लौट आयो। ");
INSERT INTO lbm_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","जब यूसुफ को भाऊवों न देख्यो कि हमरो बाप मर गयो हय, तब कहन लग्यो, “अब शायद यूसुफ हमरो सी नफरत करे, अऊर जितनी बुरायी हम न ओको सी करी होती सब को बदला हम सी लेयेंन?” ");
INSERT INTO lbm_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","येकोलायी उन्न यूसुफ को जवर एक सन्देश भेज्यो, “तोरो बाप न मरनो सी पहिले हम्ख यो आज्ञा दी होती ");
INSERT INTO lbm_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘तुम लोग यूसुफ सी यो तरह कहो, कि हम बिनती करजे हंय कि तय अपनो भाऊवों को अपराध अऊर पाप ख माफ कर; हम न तोरो सी बुरायी करी होती, पर अब अपनो बाप को परमेश्वर को दासों को अपराध माफ कर’।” उन्की या बाते सुन क यूसुफ रोय पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","अऊर ओको भाऊ खुद भी जाय क ओको आगु गिर पड़्यो, अऊर कह्यो, “देख, हम तोरो दास हंय।” ");
INSERT INTO lbm_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","यूसुफ न उन्को सी कह्यो, “मत डरो, का मय परमेश्वर की जागा पर हय? ");
INSERT INTO lbm_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","हालांकि तुम लोगों न मोरो लायी बुरायी को बिचार करयो होतो; पर परमेश्वर न उच बात म भलायी को बिचार करयो, जेको सी ऊ असो करे, जसो अज को दिन प्रगट हय, कि बहुत सो लोगों को जीव बच्यो हंय। ");
INSERT INTO lbm_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","येकोलायी अब मत डरो; मय तुम्हरो अऊर तुम्हरो बाल बच्चां को पालन पोषन करतो रहूं।” यो तरह यूसुफ न उन्ख समझाय-बुझाय क शान्ति दी। ");
INSERT INTO lbm_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","यूसुफ अपनो बाप को घराना सहीत मिस्र देश म निवास करतो रह्यो, अऊर यूसुफ एक सौ दस साल जीन्दो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","अऊर यूसुफ न एप्रैम की सन्तान ख तीसरी पीढ़ी तक देख्यो; अऊर मनश्शे को नाती, जो माकीर को टुरा होतो, हि पैदा भयो अऊर यूसुफ न उन्ख गोदी म लियो। ");
INSERT INTO lbm_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","यूसुफ न अपनो भाऊवों सी कह्यो, “मय त मरन पर हय; पर परमेश्वर जरूरच तुम्हरी चिन्ता करेंन, अऊर तुम्ख यो देश सी निकाल क ऊ देश म पहुंचाय देयेंन, जेक देन की ओन अब्राहम, इसहाक, अऊर याकूब सी कसम खायी होती।” ");
INSERT INTO lbm_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","तब यूसुफ न अपनो लोगों सी एक प्रतिज्ञा करन ख कह्यो। यूसुफ न कह्यो, “मोरो सी प्रतिज्ञा करो कि जब परमेश्वर तुम लोगों ख नयो देश म लिजायेंन तब तुम भी मोरी अस्थियां अपनो संग लिजावों।” ");
INSERT INTO lbm_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","यो तरह यूसुफ एक सौ दस साल को होय क मर गयो; अऊर ओको शव म सुगन्ध की चिज भरी गयी, अऊर ऊ शव मिस्र देश म एक सन्दूक म रख्यो गयो।");
INSERT INTO lbm_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","इस्राएल मतलब याकूब को टुरावों को नाम, जो अपनो बाप को संग अपनो घरानो समेत मिस्र देश म आयो होतो, यो आय : ");
INSERT INTO lbm_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमोन, लेवी, यहूदा, ");
INSERT INTO lbm_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साकार, जबूलून, बिन्यामीन, ");
INSERT INTO lbm_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्ताली, गाद अऊर आशेर। ");
INSERT INTO lbm_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","अऊर यूसुफ त मिस्र देश म पहिलेच आयो होतो। याकूब को अपनो वंश म जो पैदा हुयो हि सब सत्तर लोग होतो। ");
INSERT INTO lbm_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ओको बाद यूसुफ अऊर ओको सब भाऊ अऊर ओकी पीढ़ी को सब लोग मर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","पर इस्राएल लोगों की सन्तान फूलन-फलन लगी; अऊर हि लोग बहुतच सामर्थी बनतो गयो, अऊर उन्की संख्या बढ़ती गयी कि पूरो देश उन्को सी भर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","मिस्र देश म एक नयो राजा बन्यो जो यूसुफ ख नहीं जानत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ओन अपनी प्रजा सी कह्यो, “देखो, इस्राएली लोग हम सी गिनती अऊर ताकत म बहुत बढ़ गयो हंय। ");
INSERT INTO lbm_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","येकोलायी आवो, हम उन्को संग चालाकी सी व्यवहार करबोंन, कहीं असो नहीं होय कि जब हि बहुत बढ़ जायेंन अऊर यदि लड़ाई को समय आय पड़्यो, त हमरो दुश्मनों सी मिल क हमरो विरोध म लड़ क देश सी भग जायें।” ");
INSERT INTO lbm_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","येकोलायी उन्न इस्राएलियों पर कठिन काम करन वालो अधिकारियों ख नियुक्त करयो कि हि उन पर भारी बोझा डाल क उन्ख दु:ख दियो करे; अऊर उन्न फिरौन लायी पितोम अऊर रामसेस नाम को भण्डार घर वालो नगरों ख बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","पर जितनो अधिक उन्ख दु:ख देतो गयो, उतनोच अधिक बढ़तो अऊर फैलतो गयो; येकोलायी मिस्र को लोग इस्राएलियों सी बहुतच डर गयो अऊर घृना करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","तब भी मिस्रियों न इस्राएलियों लोगों सी कठोर मेहनत करवायो, ");
INSERT INTO lbm_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","अऊर उन्को जीवन ख गारा, ईटा अऊर खेती को अलग अलग को काम की कठिन सेवा सी जीनो मुश्किल कर डाल्यो; जो कोयी काम म हि उन्को सी सेवा करावत होतो ओको म हि कठोरता को व्यवहार करत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","इस्राएली बाईयों ख मदत करन वाली शिप्रा अऊर पूआ नाम की दोय इब्री मतलब इस्राएली सुईन ख मिस्र देश को राजा न आज्ञा दियो, ");
INSERT INTO lbm_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“जब तुम इब्री बाईयों को बारतपन करवातो समय ध्यान सी देखो कि टुरा आय, त ओख मार डालजो, अऊर टुरी हय त ओख जीन्दी रहन देजो।” ");
INSERT INTO lbm_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","पर हि सुईन परमेश्वर को डर मानत होती, येकोलायी मिस्र को राजा की आज्ञा नहीं मान क टुरावों ख भी जीन्दो छोड़ देत होती। ");
INSERT INTO lbm_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तब मिस्र देश को राजा न सुईन ख बुलाय क पुच्छ्यो, “तुम जो टुरावों ख जीन्दो छोड़ देवय हय, त असो कहाली करय हय?” ");
INSERT INTO lbm_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","सुईन न फिरौन ख उत्तर दियो, “इब्री बाईयां मिस्र देश की बाईयों की जसी नहाय; हि असी फुरतीली हंय कि सुईन को पहुंचन को पहिलेच उन्ख बच्चा पैदा होय जावय हय।” ");
INSERT INTO lbm_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","येकोलायी परमेश्वर न सुईन को संग भलायी करी; अऊर हि इस्राएली बढ़ कर बहुत शक्तिशाली भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","सुईन परमेश्वर को डर मानत होती, येकोलायी परमेश्वर न उन्ख अपनो परिवार दियो। अऊर इस्राएली लगातार बढ़तो अऊर ताकवर बनतो गयो। ");
INSERT INTO lbm_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","तब फिरौन न अपनो पूरी प्रजा ख यो आज्ञा दी, “जब इब्रियों को जितनो टुरा पैदा होयेंन उन्ख तुम नील नदी म फेंक देजो, अऊर सब टुरियों ख जीन्दो रहन देजो।” ");
INSERT INTO lbm_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी को घरानो को एक आदमी न एक लेवी वंश की बाई सी बिहाव कर लियो। ");
INSERT INTO lbm_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","वा बाई गर्भवती भयी अऊर ओको एक बेटा पैदा भयो; अऊर यो देख क कि यो बच्चा सुन्दर हय, ओन ओख तीन महीना तक लूकाय क रख्यो। ");
INSERT INTO lbm_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","जब वा ओख अऊर लूकाय नहीं सकी तब ओको लायी सरकंडों की एक टोकनी ले क ओको पर डामर को लेप लगायी, अऊर ओको म बच्चा ख रख क नील नदी को किनार पर लम्बी घास को बीच म रख दी। ");
INSERT INTO lbm_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ऊ बच्चा की बहिन यो देखन लायी कुछ दूर खड़ी होती कि ओको संग का होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","तब फिरौन की बेटी आंग धोवन लायी नदी को किनार पर आयी। ओकी दासियां नील नदी को किनार पर घुमत होती। अचानक फिरौन की बेटी न ऊचो घास म टोकनी ख देख क अपनी सेविका ख ओख लावन लायी भेज्यो। ");
INSERT INTO lbm_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","जब ओन ओख खोल्यो त देख्यो कि एक बच्चा हय, जो रोय रह्य हय, तब ओको पर दया आयी अऊर ओन कह्यो, “यो त कोयी इब्रियों को बच्चा आय।” ");
INSERT INTO lbm_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तब बच्चा की बहिन न फिरौन की बेटी सी कह्यो, “का मय जा क इब्री बाईयों म सी कोयी बाई ख बुलाय क ले आऊं, जो तोरो लायी बच्चा ख दूध पिलायो करेंन?” ");
INSERT INTO lbm_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फिरौन की बेटी न कह्यो, “जावो।” तब टुरी जाय क बच्चा की माय ख बुलाय क आयी। ");
INSERT INTO lbm_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फिरौन की बेटी न ओको सी कह्यो, “तय यो बच्चा ख लिजाय क मोरो लायी दूध पिलायो कर, अऊर मय तोख मजूरी देऊं।” तब वा बाई बच्चा ख लिजाय क दूध पिलान लगी। ");
INSERT INTO lbm_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","जब बच्चा थोड़ो बड़ो भयो तब कुछ समय को बाद ओख फिरौन राजा की बेटी को जवर ले गयी, अऊर ओन बच्चा ख अपनो टुरा मान लियो; अऊर ओन यो कह्य क ओको नाम मूसा रख्यो, “मय न येख पानी सी निकाल्यो होतो।” ");
INSERT INTO lbm_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","जब मूसा बड़ो भयो, तब उन दिनों म ऊ बाहेर अपनो भाऊ-बन्धुवों को जवर जाय क उन्को दु:खों पर नजर रखन लग्यो; तब ओन देख्यो कि एक मिस्री आदमी ओको एक इब्री भाऊ ख मार रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ओन इत उत देख्यो कि कोयी नहाय, त ऊ मिस्री आदमी ख मार डाल्यो अऊर रेतु म लूकाय दियो। ");
INSERT INTO lbm_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","दूसरो दिन बाहेर दोय इब्री आदमी आपस म लड़ाई कर रह्यो हंय। मूसा न देख्यो कि ओको म एक गलत हय, त मूसा न ओख बोल्यो “तय अपनो संगी ख कहाली मारय हय?” ");
INSERT INTO lbm_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ओन कह्यो, “कौन न तोख हम लोगों पर शासक अऊर न्याय करन वालो ठहरायो? का तुम मोख मारन आयो हंय, जसो तुम न मिस्री आदमी ख मार डाल्यो होतो?” तब मूसा यो सोच क डर गयो, कि “निश्चय ऊ बात खुल गयी हय जो मय न करयो होतो।” ");
INSERT INTO lbm_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","जब फिरौन न यो बात सुन्यो कि मूसा न यो का करयो तब ओख मारन लायी देखन लग्यो। पर मूसा फिरौन सी दूर भग गयो, अऊर मिद्यान देश म जाय क रहन लग्यो; अऊर ऊ उत एक कुंवा को जवर बैठ गयो। ");
INSERT INTO lbm_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिद्यान देश को याजक की सात बेटियां होती; अऊर हि कुंवा पर अपनो बाप की शेरी-मेंढी लायी डोगी म पानी भरन आयी होती। ");
INSERT INTO lbm_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","तब कुछ चरवाहे आय क उन्ख हटान लग्यो; तब मूसा उठ्यो उन्न याजक की टुरियों की मदत करी अऊर शेरी-मेंढी ख पानी पिलायो। ");
INSERT INTO lbm_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जब वा अपनो बाप रूएल को जवर वापस गयी, तब ओको बाप न उन्ख पुच्छ्यो, “का वजह हय कि अज तुम इतनो जल्दी वापस आय गयी।” ");
INSERT INTO lbm_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","उन्न कह्यो, “एक मिस्री आदमी न हम ख चरवाहों सी बचायो, अऊर हमरो लायी बहुत पानी भर क् शेरी-मेंढी ख पानी पिलायो।” ");
INSERT INTO lbm_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","तब ओन अपनी बेटियों सी कह्यो, “ऊ आदमी कित हय? तुम ओख कहाली छोड़ आयी हय? ओख बुलाय क लावो कि ऊ हमरो संग जेवन करेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","अऊर मूसा उन्को संग रहन लायी तैयार भय गयो। ओन अपनी बेटी सिप्पोरा को बिहाव मूसा को संग कर दियो। ");
INSERT INTO lbm_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ओन एक टुरा ख जनम दियो, तब मूसा न यो कह्यो, “मय यो देश म परदेशी हय,” येकोलायी ओको नाम गेर्शोम रख्यो। ");
INSERT INTO lbm_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","बहुत साल को बाद मिस्र देश को राजा मर गयो। इस्राएली लोगों ख गुलामी म कठिन काम करनो पड़त होतो। अऊर हि मदत लायी चिल्लावत होतो, अऊर उन्की दोहायी जो कठिन काम को वजह हुयी ऊ परमेश्वर तक पहुंची। ");
INSERT INTO lbm_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेश्वर न उन्को दु:ख ख सुन्यो अऊर अपनो वाचा ख, जो ओन अब्राहम, इसहाक, अऊर याकूब को संग बान्धी होती, याद करयो। ");
INSERT INTO lbm_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","अऊर परमेश्वर न इस्राएलियों की दुर्दशा पर नजर कर क् उन पर मन लगायो। ");
INSERT INTO lbm_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","एक दिन मूसा अपनो ससरो यित्रो, मिद्यान देश को याजक, की मेंढी-शेरी ख चरावत होतो; अऊर ऊ उन्ख सुनसान जागा की पश्चिम दिशा म अऊर परमेश्वर को होरेब पहाड़ी को जवर ले गयो। ");
INSERT INTO lbm_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","अऊर परमेश्वर को दूत न एक काटा की झाड़ी को बीच आगी की लौ म ओख दर्शन दियो; अऊर मूसा न नजर उठाय क देख्यो कि झाड़ी जल त रही हय, पर जल क भस्म नहीं होय रही हय। ");
INSERT INTO lbm_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","तब मूसा न सोच्यो, “मय उत जाय क यो बड़ो आश्चर्य ख देखूं कि वा झाड़ी कहाली नहीं जल रही हय।” ");
INSERT INTO lbm_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब परमेश्वर न देख्यो कि मूसा झाड़ी ख देखन लायी जवर आय रह्य हय, तब परमेश्वर न झाड़ी को बीच सी ओख बुलायो, अऊर कह्यो, “हे मूसा, हे मूसा!” मूसा न उत्तर दियो, “हव मय इत हय।” ");
INSERT INTO lbm_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","परमेश्वर न कह्यो, “जवर मत आव; अऊर अपनो पाय सी चप्पल ख उतार दे, कहालीकि जो जागा पर तय खड़ो हय ऊ पवित्र जमीन हय।” ");
INSERT INTO lbm_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","“मय तुम्हरो पूर्वजों अब्राहम, इसहाक, अऊर याकूब को परमेश्वर आय।” तब मूसा न अपनो मुंह झाक लियो; कहालीकि ऊ परमेश्वर की तरफ देखन सी डर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","तब परमेश्वर न कह्यो, “मय न अपनी प्रजा को लोग जो मिस्र देश म हय, उन्को दु:ख देख्यो हय; अऊर उन्की जो चिल्लाहट कठिन मेहनत करावन वालो को वजह होवय हय। उन्ख भी सुन्यो हय, अऊर मय उन्को दु:ख ख जानु हय। ");
INSERT INTO lbm_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","येकोलायी अब मय उतर आयो हय कि उन्ख मिस्रियों को वश सी छुड़ाऊं, अऊर ऊ देश सी निकाल क एक अच्छो अऊर बड़ो देश म, जित दूध अऊर शहेद की धाराये बहय हंय, मतलब कनानी, हित्ती, एमोरी, परिज्जी, हिब्बी, अऊर यबूसी जाति को लोगों को जागा म पहुंचाऊं। ");
INSERT INTO lbm_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","येकोलायी अब सुन, इस्राएलियों की चिल्लाहट मोख सुनायी पड़ी हय, मय न ओको अत्याचार ख भी देख्यो हय, जो मिस्र देश को निवासी उन पर कर रह्यो हंय। ");
INSERT INTO lbm_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","अब तय जा, मय तोख फिरौन राजा को जवर भेज रह्यो हय कि तय मोरी इस्राएली प्रजा ख मिस्र देश सी निकाल लाये।” ");
INSERT INTO lbm_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","पर मूसा न परमेश्वर सी कह्यो, “मय कौन आय जो फिरौन राजा को जवर जाऊ, अऊर इस्राएलियों ख मिस्र देश सी बाहेर निकाल लाऊं?” ");
INSERT INTO lbm_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","परमेश्वर न कह्यो, “निश्चय मय तोरो संग रहूं; अऊर यो बात को कि तोरो भेजन वालो मय आय, तोरो लायी यो चिन्ह होयेंन कि जब तय उन लोगों ख मिस्र देश सी निकाल लावो, तब तुम योच पहाड़ी पर मोरी आराधना करो।” ");
INSERT INTO lbm_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मूसा न परमेश्वर सी कह्यो, “जब मय इस्राएलियों को जवर जाय क उन्को सी कहू, ‘तुम्हरो पूर्वजों को परमेश्वर न मोख तुम्हरो जवर भेज्यो हय,’ अऊर हि मोरो सी पुछेंन, ‘ओको का नाम हय?’ तब मय उन्ख का बताऊं?” ");
INSERT INTO lbm_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेश्वर न मूसा सी कह्यो, “मय जो आय सो आय।” तब ओन कह्यो, “तय इस्राएलियों सी यो कह्यजो, ‘जेको नाम मय आय हय ओन मोख तुम्हरो जवर भेज्यो हय’।” ");
INSERT INTO lbm_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","तब परमेश्वर न मूसा सी यो भी कह्यो, “तय इस्राएलियों सी यो कह्यजो, ‘तुम्हरो पूर्वजों को परमेश्वर, अब्राहम को, इसहाक को अऊर, याकूब को परमेश्वर, यहोवा, ओन मोख ख तुम्हरो जवर भेज्यो हय। देख, हमेशा मोरो नाम योच रहेंन, अऊर योच नाम सी मोख पीढ़ी सी पीढ़ी तक याद करयो जायेंन।’ ");
INSERT INTO lbm_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","येकोलायी अब जा इस्राएली बुजूर्गों ख जमा कर, अऊर उन्को सी बोल, ‘तुम्हरो पूर्वजों को परमेश्वर, अब्राहम, इसहाक, अऊर याकूब को परमेश्वर, यहोवा न मोख दर्शन दे क यो कह्यो हय। मय न तुम्हरी सुधि ली हय। जो बर्ताव मिस्र देश म तुम्हरो संग करयो जाय रह्यो हय ओको पर भी चित्त लगायो हय। ");
INSERT INTO lbm_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","अऊर मय न ठान लियो हय कि तुम ख मिस्र देश को दु:खों सी बाहेर निकालूं अऊर कनानी, हित्ती, एमोरी, परिज्जी, हिब्बी, अऊर यबूसी लोगों को देश म पहुंचाऊं, जो असो देश आय कि जेको म दूध अऊर शहेद की धारायें बहय हंय।’ ");
INSERT INTO lbm_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","तब हि तोरी सुनेंन; अऊर तय इस्राएली बुजूर्गों ख संग ले क मिस्र देश को राजा को जवर जा अऊर ओको सी कह्यजो, ‘इब्रियों को परमेश्वर, यहोवा हम पर प्रगट भयो हय; येकोलायी अब हम ख तीन दिन की यात्रा पर सुनसान जागा म जान दे कि अपनो परमेश्वर लायी बलि दान चढ़ाये।’ ");
INSERT INTO lbm_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","मय जानु हय कि मिस्र देश को राजा तुम्ख तब तक जान नहीं देयेंन, जब तक कि एक ताकतवर हाथ ओख मजबूर नहीं करय। ");
INSERT INTO lbm_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","तब मय अपनो हाथ बढ़ाय क सामर्थ को काम मिस्र देश को बीच करूं अऊर चमत्कार को कामों सी ऊ देश पर मुसीबत डालूं; तब ऊ तुम ख जान देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","तब मय मिस्रियों सी अपनी यो प्रजा पर अनुग्रह कराऊं; अऊर जब तुम निकलो तब हि तुम्ख खाली हाथ नहीं जान देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","बल्की हर एक बाई अपनी पड़ोसिन, अऊर उन्को घर म रहन वाली सी सोनो-चांदी को जेवर अऊर कपड़ा मांग क टुरावों अऊर टुरियों ख पहिनाजो; या तरह तुम मिस्रियों ख लूटो।” ");
INSERT INTO lbm_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","तब मूसा न उत्तर दियो, “अगर हि मोरो विश्वास नहीं करेंन अऊर नहीं मोरी सुनेंन, बल्की कहेंन, ‘परमेश्वर न तोख ख दर्शन नहीं दियो’।” ");
INSERT INTO lbm_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","परमेश्वर न ओको सी कह्यो, “तोरो हाथ म का हय?” ऊ बोल्यो, “लाठी।” ");
INSERT INTO lbm_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","परमेश्वर न कह्यो, “ओख जमीन पर डाल दे।” जब ओन ओख जमीन पर डाल्यो तब वा सांप बन गयी, अऊर मूसा ओको आगु सी भग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","तब परमेश्वर न मूसा सी कह्यो, “हाथ बढ़ाय क ओकी पूछ पकड़ ले, जब ओन हाथ बढ़ाय क ओख पकड़्यो तब वा ओको हाथ म फिर लाठी बन गयी। ");
INSERT INTO lbm_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ताकी हि लोग विश्वास करे कि तुम्हरो पूर्वजों को परमेश्वर मतलब अब्राहम को परमेश्वर, इसहाक को परमेश्वर, अऊर याकूब को परमेश्वर, परमेश्वर न तोख दर्शन दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","परमेश्वर न मूसा ख फिर सी कह्यो, “अपनो हाथ पहिन्यो कपड़ा को अन्दर छाती पर रख।” मूसा न आज्ञा मानी अऊर कपड़ा को अन्दर छाती पर अपनो हाथ रख क झाक लियो; फिर जब ओन हाथ बाहेर निकाल्यो तब ओको हाथ बरफ को समान कोढ़ जसो सफेद भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","तब परमेश्वर न कह्यो, “अब फिर सी अपनो हाथ छाती पर रख।” ओन अपनो हाथ छाती पर रख क झाक लियो; अऊर जब ओन ओख छाती पर सी निकाल्यो तब का देखय हय कि ऊ फिर पूरो शरीर को जसो अच्छो भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तब परमेश्वर न कह्यो, “यदि हि तोरी बात पर विश्वास नहीं करेंन, अऊर पहिले चिन्ह ख नहीं मानेंन, त दूसरो चिन्ह पर विश्वास करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","अऊर यदि हि इन दोयी चिन्हों पर विश्वास नहीं करेंन अऊर तोरी बात ख नहीं मानेंन, तब तय नील नदी सी कुछ पानी ले क सूखी जमीन पर डालजो; अऊर जो पानी तय नदी सी निकालजो ऊ सूखी जमीन पर खून बन जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","मूसा न परमेश्वर सी कह्यो, “हे मोरो प्रभु, मय बोलनो म अच्छो बोलकार नहाय, नहीं पहिले होतो, अऊर नहीं जब सी तय अपनो दास सी बाते करन लग्यो; मय त मुंह अऊर जीबली सी लड़खड़ाऊ हय।” ");
INSERT INTO lbm_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","परमेश्वर न ओको सी कह्यो, “आदमी को मुंह कौन न बनायो हय? अऊर आदमी ख मुक्का, यां बहिरा, यां देखन वालो, यां अन्धा, मोख छोड़ क कौन बनावय हय? का मय ऊ यहोवा नहीं। ");
INSERT INTO lbm_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","अब जा, तोरो बोलतो समय मय तोरी मदत करूं, अऊर तोख का कहनो हय सिखातो जाऊं।” ");
INSERT INTO lbm_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","पर मूसा न कह्यो, “हे मोरो परमेश्वर, कृपया तय कोयी दूसरो ख भेज।” ");
INSERT INTO lbm_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तब परमेश्वर को गुस्सा मूसा पर भड़क्यो अऊर ओन कह्यो, “का तोरो भाऊ ख नहीं जानय, जो लेवीय वंश को हारून आय? मय जानु हय कि ऊ अच्छो सी बोल सकय हय, देख, ऊ तोरो सी मिलन आय रह्यो हय; अऊर तोख देख क खुश होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","येकोलायी तय ओको सी बाते करजो; अऊर ओख बतावो कि का करनो हय मय ओख अऊर ओख बोलन म मदत करूं, अऊर तुम दोयी ख का करनो हय यो सिखाऊं। ");
INSERT INTO lbm_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","हारून तोरो तरफ सी लोगों सी बाते करेंन; ऊ तोरो लायी मुंह की वानी अऊर तय ओको लायी परमेश्वर जसो ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","अऊर तय यो लाठी ख अपनो संग म लिजाव, अऊर येको सी इन चिन्ह चमत्कार ख दिखाजो।” ");
INSERT INTO lbm_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","तब मूसा अपनो ससरो यित्रो को जवर वापस गयो अऊर ओको सी कह्यो, “मोख बिदा कर कि मय मिस्र देश म रहन वालो अपनो भाऊवों को जवर जाय क देखू कि अब तक जीन्दो हय का नहाय।” यित्रो न मूसा सी कह्यो, “तय शान्ति सी जा।” ");
INSERT INTO lbm_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","अऊर परमेश्वर न मिद्यान देश म मूसा सी कह्यो, “मिस्र देश वापस जा; कहालीकि जो आदमी तोरो जीव को प्यासो होतो, हि सब मर गयो हंय।” ");
INSERT INTO lbm_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","तब मूसा न अपनी पत्नी अऊर अपनो बेटों ख गधा पर बैठाय क मिस्र देश को तरफ परमेश्वर न दी हुयी लाठी ख हाथ म लियो हुयो वापस लौट्यो। ");
INSERT INTO lbm_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","तब परमेश्वर न मूसा सी कह्यो, “जब तय मिस्र देश म पहुंचो तब ध्यान रखजो कि जो चमत्कार मय न तोरो वश म करयो हंय उन सब ख फिरौन ख दिखाजो; पर मय ओको मन ख कठोर करूं, अऊर ऊ मोरो लोगों ख नहीं जान देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","अऊर तय फिरौन सी कह्यजो, परमेश्वर यो कह्य हय, कि इस्राएल मोरो पहिलो टुरा आय, ");
INSERT INTO lbm_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","अऊर मय तोरो सी कहूं हय कि मोरो टुरा ख जान दे। मोरी आराधना कर सके; अऊर तय न अब तक ओको नहीं जान दियो, त मय तोरो पहिलो टुरा ख मारूं।” ");
INSERT INTO lbm_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मिस्र को रस्ता पर एक जागा म परमेश्वर मूसा को जवर आयो कि ओख मार डालनो चाहयो। ");
INSERT INTO lbm_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","तब सिप्पोरा न एक धार वालो गोटा ले क अपनो टुरा को खतना करयो अऊर चमड़ी ख काट क, मूसा को पाय पर डाल दियो अऊर कह्यो, “निश्चय तय मोरो लायी खून बहान वालो मोरो पति आय।” ");
INSERT INTO lbm_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","येकोलायी परमेश्वर न मूसा ख छोड़ दियो। जब सिप्पोरा न खतना को समय कह्यो होतो, “तय खून बहानो वालो मोरो पति आय।” ");
INSERT INTO lbm_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","तब परमेश्वर न हारून सी कह्यो, “मूसा सी मिलन लायी जंगल म जा।” ऊ गयो। अऊर पवित्र पहाड़ी पर मूसा सी मिल्यो अऊर हारून न मूसा ख चुम्बन लियो। ");
INSERT INTO lbm_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","तब मूसा न हारून ख ऊ सब बतायो जो परमेश्वर न ओख मिस्र सी लौटतो समय कह्यो होतो; अऊर उन चिन्ह को बारे म भी बतायो जेक परमेश्वर न मूसा ख करन की आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","तब मूसा अऊर हारून मिस्र ख गयो अऊर इस्राएलियों को सब बुजूर्गों ख जमा करयो। ");
INSERT INTO lbm_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","जो बाते परमेश्वर न मूसा सी कह्यो होतो, ऊ सब हारून न उन्ख सुनायी, अऊर लोगों को आखी को आगु सब चिन्ह भी दिखाये। ");
INSERT INTO lbm_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","अऊर उन्न न उन्को विश्वास करयो; अऊर यो सुन क कि परमेश्वर न इस्राएलियों की सुधि ली अऊर उन्को दु:खो पर नजर करी हय, उन्न अपनो मुंड झुकाय क आराधना करयो। ");
INSERT INTO lbm_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","तब मूसा अऊर हारून फिरौन को जवर गयो अऊर कह्यो, “इस्राएलियों को परमेश्वर यहोवा यो कह्य हय : ‘मोरी प्रजा ख जान दे, कि हि जंगल म मोरो सम्मान म त्यौहार मनाय सके’।” ");
INSERT INTO lbm_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फिरौन न कह्यो, “परमेश्वर कौन आय कि मय ओको बात सुन क इस्राएलियों ख जान देऊं? मय परमेश्वर ख नहीं जानु हय, अऊर मय इस्राएलियों ख नहीं जान देऊं।” ");
INSERT INTO lbm_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","मूसा अऊर हारून न कह्यो, “इब्रियों को परमेश्वर न खुद हम सी मिल्यो हय; येकोलायी हम्ख जंगल म तीन दिन को रस्ता पर जान दे, कि अपनो परमेश्वर यहोवा लायी बलिदान चढ़ाबों, असो न हो कि ऊ हम्ख महामारी यां तलवार सी नाश करे।” ");
INSERT INTO lbm_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","मिस्र देश को राजा न मूसा अऊर हारून सी कह्यो, तुम लोगों ख उन्को काम सी दूर कहाली करनो चाहवय हय? तुम सब जावो अपनो-अपनो मेहनत को काम करो। ");
INSERT INTO lbm_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","अऊर फिरौन न कह्यो, “सुनो, यो देश म हि लोग मिस्र की जनता सी बहुत बढ़ गयो हंय, अब तुम उन्ख भारी काम सी आराम दिलानो चाहवय हय!” ");
INSERT INTO lbm_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","फिरौन राजा न उच दिन उन इस्राएली लोगों पर कठिन काम करावन वालो ख अऊर उन्को मुखिया ख यो आदेश दियो, ");
INSERT INTO lbm_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“तुम जो अब तक ईटा बनान लायी लोगों ख भूसा दियो करत होतो, ऊ आगु ख मत देजो; हि खुदच जाय क अपनो लायी भूसा जमा करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","जितनी ईटा अब तक उन्ख बनानो पड़त होती उतनोच आगु ख भी उन्को सी बनवाजो, ईटा की गिनती कुछ भी कम मत करजो; कहालीकि हि आलसी भय गयो हंय, योच वजह सी हि मोख चिल्लाय क कहतो रह्य हय। हम्ख जान दे परमेश्वर को जवर बलिदान चढ़ान लायी। ");
INSERT INTO lbm_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","उन लोगों सी अऊर भी कठिन काम करवाजो जेको सी हि ओको म झुटो रहेंन अऊर मूसा अऊर हारून की झूठी बातों पर ध्यान नहीं देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","तब लोगों सी मेहनत करवावन वालो न अऊर इस्राएली मतलब इब्री मुखिया न बाहेर जाय क इस्राएलियों सी कह्यो, “फिरौन राजा असो कह्य हय, अब मय तुम्ख ईटा बनान लायी अऊर भूसा नहीं देऊं। ");
INSERT INTO lbm_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तुम खुदच जावो, अऊर जित कहीं तुम्ख भूसा मिलेंन, उत सी जमा कर क् लावो; पर तुम्हरो काम म कुछ भी कमी नहीं आनो होना।” ");
INSERT INTO lbm_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","येकोलायी हि लोग भूसा को बदला खूटी ख ढ़ूंढ़न म पूरो मिस्र देश म फैल गयो। ");
INSERT INTO lbm_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","मेहनत करावन वालो उन्को सी जल्दी काम करन लायी कहत होतो, जसो तुम भूसा रहन पर करत होतो उच तरह अपनो हर दिन को काम अब भी पूरो करो। ");
INSERT INTO lbm_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","अऊर इस्राएलियों म सी जिन मुखियावों ख फिरौन को मेहनत करावन वालो न उन्को अधिकारी ठहरायो होतो, उन्न मार खायी अऊर उन्को सी पुच्छ्यो गयो, “जसो तुम अब तक करत होतो, वसो निश्चित गिनती म ईटा बनावन लायी कल अऊर अज तुम न अपनो काम कहाली नहीं करयो?” ");
INSERT INTO lbm_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तब इस्राएलियों को मुखिया न फिरौन राजा को जवर जाय क दोहायी दी, “तय अपनो दासों सी असो बर्ताव कहाली करय हय? ");
INSERT INTO lbm_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","तुम हम्ख कोयी भूसा देवय नहाय, तब भी हम सी कहतो रह्य हंय, ‘ईटा बनावो,’ अऊर अब हम्ख मार रह्यो हय; पर दोष तोरोच लोगों को हय।” ");
INSERT INTO lbm_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फिरौन राजा न उत्तर दियो, “तुम आलसी हो, आलसी; योच वजह कह्य हय कि हम्ख परमेश्वर लायी बलिदान करन ख जान दे। ");
INSERT INTO lbm_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब जावो अऊर अपनो काम करो; अऊर तुम्ख भूसा नहीं दियो जायेंन, तब भी तुम्ख ईटा की गिनती पूरी करनो पड़ेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","जब इस्राएलियों को मुखिया न यो बात सुन्यो कि उन्की ईटों की गिनती कम नहीं होयेंन, अऊर हर दिन उतनोच काम पूरो करनो पड़ेंन जितनो पहिले करत होतो, तब हि जान गयो कि उन्को संकट को दिन आय गयो हंय। ");
INSERT INTO lbm_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","जब हि फिरौन राजा को जवर सी बाहेर निकल रह्यो होतो, तब मूसा अऊर हारून उन्को सी मिल्यो जो उत उन्को लायी रूक्यो होतो, ");
INSERT INTO lbm_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","अऊर उन्न मूसा अऊर हारून सी कह्यो, “परमेश्वर तुम पर नजर कर क् न्याय करे, कहालीकि तुम न हम ख फिरौन राजा अऊर ओको कर्मचारियों की नजर म दोषी ठहराय क हम्ख मार डालन लायी उन्को हाथ म तलवार दे दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","तब मूसा न परमेश्वर को जवर वापस आय क कह्यो, “हे प्रभु, तय न यो प्रजा को संग बुरो व्यवहार कहाली करयो? तय न मोख इत कहाली भेज्यो? ");
INSERT INTO lbm_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","जब सी मय तोरो नाम सी फिरौन को जवर बाते करन लायी गयो, तब सी ओन यो प्रजा को संग बुरो व्यवहार करयो, अऊर तय न अपनो लोगों की कुछ भी मदत नहीं करयो।” ");
INSERT INTO lbm_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तब परमेश्वर न मूसा सी कह्यो, “अब तय देखजो कि मय फिरौन राजा सी का करूं, अब तय ओख देखजो, ऊ मोरी महान शक्ति को वजह, अपनो देश सी निकाल देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेश्वर न मूसा सी कह्यो, “मय यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","मय सर्वशक्तिमान परमेश्वर को नाम सी अब्राहम, इसहाक, अऊर याकूब ख दर्शन देत होतो, पर परमेश्वर को नाम सी कभी अपनो आप ख उन पर प्रगट नहीं करयो। ");
INSERT INTO lbm_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","अऊर मय न उन्को संग अपनी वाचा करयो, कि मय उन्ख कनान देश देऊं, जेको म हि परदेशी होय क रहत होतो, ओख उन्ख दे देऊ। ");
INSERT INTO lbm_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","इस्राएलियों जिन्ख मिस्री लोग गुलाम बनाय क रख्यो होतो, उन्को चिल्लानो भी सुन क मय न अपनी वाचा ख याद करयो हय। ");
INSERT INTO lbm_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","येकोलायी तय इस्राएलियों सी कह्यजो, ‘मय परमेश्वर आय, अऊर तुम ख मिस्रियों को बोझां सी निकालू, अऊर उन्की गुलामी सी छुड़ाऊं, अऊर अपनो हाथ बढ़ाय क तुम्हरी रक्षा करूं, ");
INSERT INTO lbm_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","अऊर मय तुम ख अपनी प्रजा बनान लायी अपनाय लेऊं, अऊर मय तुम्हरो परमेश्वर ठहरूं; अऊर तुम जान लेवो कि मय तुम्हरो परमेश्वर यहोवा आय जो तुम्ख मिस्रियों को दबाव अऊर बोझ सी निकाल ले आयो, ");
INSERT INTO lbm_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","अऊर जो देश ख हाथ उठाय क देन की कसम मय न अब्राहम, इसहाक, अऊर याकूब सी खायी होती। ओको म मय तुम्ख पहुंचाय क ओख तुम्हरो अधिकार म कर देऊं। मय परमेश्वर आय’।” ");
INSERT INTO lbm_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मूसा न इस्राएलियों ख यो बाते सुनायी, पर उन्न मन की बेचैनी अऊर गुलामी को वजह उन्की बाते नहीं सुन्यो। ");
INSERT INTO lbm_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“जावो अऊर मिस्र देश को राजा फिरौन सी कहजो इस्राएलियों ख ओको देश सी बाहेर जान दे।” ");
INSERT INTO lbm_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","पर मूसा न परमेश्वर सी कह्यो, “देख, इस्राएलियों न मोरी बात नहीं सुन्यो; तब फिरौन मोरी कसी बात सुनेंन? मय त बोलनो म लड़खड़ाऊ हय।” ");
INSERT INTO lbm_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","तब परमेश्वर न मूसा अऊर हारून ख आदेश दियो कि इस्राएलियों अऊर मिस्र देश को फिरौन राजा सी कहो, हि इस्राएली लोग मिस्र देश सी बाहेर निकाल ले जाये। ");
INSERT INTO lbm_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","उन्को पूर्वजों को घराना को मुख्य आदमियों को नाम यो आय : इस्राएल को बड़ो बेटा रूबेन को टुरा: हनोक, पल्लू, हेस्रोन अऊर कर्मी; इन्को म सी रूबेन को वंश निकल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमोन को छय टुरा होतो : यमूएल, यामीन, ओहद याकीन अऊर सोहर अऊर एक कनानी बाई को टुरा शाऊल होतो; इन्को सी शिमोन को वंश निकल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवी को तीन टुरा होतो : उन्की वंशावली को नाम यो आय : गेर्शोन, कहात अऊर मरारी; अऊर लेवी की पूरी उमर एक सौ सैतीस साल की हुयी। ");
INSERT INTO lbm_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोन को वंश अनुसार गेर्शोन को दोय टुरा होतो : लिबनी अऊर शिमी। ");
INSERT INTO lbm_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहात को चार टुरा होतो : अम्राम, यिसहार, हेब्रोन अऊर उज्जीएल। कहात की उमर एक सौ तैतीस साल की भयी। ");
INSERT INTO lbm_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारी को दोय टुरा होतो : महली अऊर मूशी। लेवियों पीढ़ी जिन्कोसी उन्की वंशावली चली यो आय। ");
INSERT INTO lbm_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्राम न अपनी फूफू योकेबेद सी बिहाव करयो अऊर ओको सी हारून अऊर मूसा पैदा भयो; अऊर अम्राम की पूरी उमर एक सौ सैतीस साल की भयी। ");
INSERT INTO lbm_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहार को तीन टुरा होतो : कोरह, नेपेग अऊर जिक्री। ");
INSERT INTO lbm_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जीएल को तीन टुरा होतो : मीशाएल, एलसाफन अऊर सित्री। ");
INSERT INTO lbm_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारून न अम्मीनादाब की टुरी अऊर नहशोन कि बहिन एलीशेबा सी बिहाव करयो; अऊर ओको सी नादाब, अबीहू, एलाजार अऊर ईतामार पैदा भयो। ");
INSERT INTO lbm_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरह को तीन टुरा होतो : अस्सीर, एलकाना अऊर अबीआसाप; अऊर इन्को सी कोरह को वंश निकल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारून को टुरा एलाजार न पूतीएल की टुरी सी बिहाव करयो; अऊर ओको सी पीनहास पैदा भयो। इन्को सी उन्को वंश चल्यो। लेवियों को पूर्वजों को घरानों को मुख्य आदमी हिच आय। ");
INSERT INTO lbm_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","हारून अऊर मूसा योच आय जिन्ख परमेश्वर न आज्ञा दी: “इस्राएलियों ख दल बनाय क मिस्र देश सी बाहेर निकाल लावो।” ");
INSERT INTO lbm_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","यो उच मूसा अऊर हारून हंय जिन्न मिस्र देश को राजा फिरौन सी कह्यो कि हम इस्राएलियों ख मिस्र देश सी निकाल ले जाबो। ");
INSERT INTO lbm_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","जो दिन परमेश्वर न मूसा सी मिस्र देश म बाते करी, ");
INSERT INTO lbm_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ओन मूसा ख बतायो, “मय यहोवा आय; जो कुछ मय तोरो सी कहूं ऊ सब बात मिस्र देश को फिरौन राजा सी कह्यजो।” ");
INSERT INTO lbm_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","पर मूसा न परमेश्वर ख उत्तर दियो, “मय अच्छो तरह बोल नहीं सकू; अऊर फिरौन राजा मोरी बात कसी सुनेंन?” ");
INSERT INTO lbm_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","परमेश्वर न मूसा सी कह्यो, “अब देख, मय तोख फिरौन राजा को जसो परमेश्वर ठहराऊ हय; अऊर तोरो भाऊ हारून तोरो भविष्यवक्ता ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जो जो बात मय तुम्ख बताऊं, ऊ सब बात तुम हारून सी कह्यजो, अऊर हारून ऊ सब फिरौन राजा सी कहेंन, तब फिरौन राजा इस्राएलियों ख अपनो देश सी जान देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","पर मय फिरौन राजा को मन ख कठोर कर देऊं, अऊर अपनो बहुत सी चिन्ह चमत्कार मिस्र देश म दिखाऊं। ");
INSERT INTO lbm_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","फिरौन राजा तुम्हरी नहीं सुनेंन; अऊर मय मिस्र देश पर अपनो हाथ उठाय क मिस्रियों ख भारी सजा दे क अपनी सेना मतलब अपनी इस्राएली प्रजा ख मिस्र देश सी निकालूं। ");
INSERT INTO lbm_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","अऊर जब मय मिस्र देश पर हाथ बढ़ाय क इस्राएलियों ख उन्को बीच सी निकालूं, तब मिस्री जान लेयेंन कि मय यहोवा आय।” ");
INSERT INTO lbm_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","मूसा अऊर हारून न परमेश्वर की आज्ञा को अनुसार करयो। ");
INSERT INTO lbm_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","जब हि फिरौन राजा सी बात करन लग्यो तब मूसा अस्सी साल, अऊर हारून तिरासी साल को होतो। ");
INSERT INTO lbm_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","तब परमेश्वर न मूसा अऊर हारून सी असो कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“जब फिरौन राजा तुम सी कह्यो, ‘अपनो प्रमान को कोयी चमत्कार दिखान ख कहेंन,’ तब तय हारून सी कह्यजो, ‘अपनो लाठी ले क फिरौन राजा को आगु डाल दे कि हि सांप बन जायेंन’।” ");
INSERT INTO lbm_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","तब मूसा अऊर हारून न फिरौन राजा को जवर जाय क परमेश्वर की आज्ञा को अनुसार करयो; अऊर जब हारून न अपनी लाठी फिरौन अऊर ओको कर्मचारियों को आगु डाल दी, तब ऊ सांप बन गयो। ");
INSERT INTO lbm_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तब फिरौन राजा न पण्डितों अऊर जादू टोना करन वालो ख बुलायो; अऊर मिस्र देश को जादूगरों न आय क अपनो तंत्र-मंत्र सी वसोच काम करयो। ");
INSERT INTO lbm_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","उन्न अपनी अपनी लाठी जमीन पर फेंक्यो त, वा भी सांप बन गयी। पर हारून की लाठी न उन सब की लाठीयों ख गिटक लियो। ");
INSERT INTO lbm_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","पर फिरौन राजा को मन अऊर हठीलो भय गयो, अऊर जसो परमेश्वर को वचन को अनुसार ओन मूसा अऊर हारून की बातों ख नहीं मान्यो। ");
INSERT INTO lbm_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तब परमेश्वर न मूसा सी कह्यो, “फिरौन राजा को मन बहुत कठोर होय गयो हय अऊर ऊ मोरो लोगों ख जान नहीं देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","येकोलायी सुबेरे फिरौन जब नदी को जवर आयेंन, तब तय ओको जवर जावो, तय नील नदी को किनार पर रस्ता देखजो जो लाठी सांप बन गयी होती, ओख अपनो हाथ म लेजो। ");
INSERT INTO lbm_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","अऊर राजा सी यो तरह कह्यजो, ‘इब्रियों मतलब इस्राएल को परमेश्वर यहोवा न मोख यो कहन लायी तोरो जवर भेज्यो हय कि मोरी प्रजा को लोगों ख जान देवो, जेकोसी हि सुनसान जागा म मोरी आराधना करेंन; अऊर अब तक तय न परमेश्वर की बातों ख नहीं मान्यो। ");
INSERT INTO lbm_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","परमेश्वर यो कह्य हय, येकोसी तय जान लेजो कि मयच परमेश्वर आय; मय अपनो हाथ की लाठी सी नील नदी को पानी पर मारूं, अऊर नील नदी को पानी खून म बन जायेंन, ");
INSERT INTO lbm_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","नील नदी की मच्छियां मर जायेंन, अऊर नदी म सी बास आन लगेन, अऊर मिस्री को लोग नील नदी सी पानी नहीं पी सकेंन’।” ");
INSERT INTO lbm_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","तब परमेश्वर न मूसा सी कह्यो, “हारून सी कह्यजो कि हि अपनी लाठी ले क मिस्र देश म जितनो पानी हय, मतलब ओकी नदियां, नहर झील, अऊर तलाव, सब को ऊपर अपनो हाथ बढ़ा कि उन्को पानी खून बन जाये; अऊर पूरो मिस्र देश म लकड़ी, गोटा अऊर कटोरा को पानी खून म बन जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","तब मूसा अऊर हारून न परमेश्वर की आदेश को अनुसार करयो, मतलब ओन लाठी ख उठाय क फिरौन राजा अऊर ओको कर्मचारियों को देखतो हुयो, नील नदी को पानी पर मारयो, अऊर नदी को सब पानी खून बन गयो। ");
INSERT INTO lbm_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नील नदी की मच्छियां मर गयी; अऊर नदी सी बास आन लग्यो, अऊर मिस्र देश को लोग नदी को पानी नहीं पी सक्यो; अऊर पूरो मिस्र देश म खूनच खून भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","तब मिस्र देश को जादूगरों न भी अपनो तंत्र-मंत्रों सी वसोच करयो; तब भी फिरौन राजा को मन कठोर भय गयो, अऊर परमेश्वर को कहन को अनुसार ओन मूसा अऊर हारून की बात नहीं मानी। ");
INSERT INTO lbm_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फिरौन राजा न यो पर भी ध्यान नहीं दियो, अऊर घर म चल्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","मिस्री लोग पानी पीवन लायी नील नदी को इत उत गड्डा खोदन लग्यो, कहालीकि हि नदी को पानी नहीं पी सकत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","जब परमेश्वर न नील नदी ख मार क् पानी को खून बनाये सात दिन बीत चुक्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","तब परमेश्वर न मूसा सी कह्यो, “फिरौन राजा को जवर जावो अऊर बोल, ‘परमेश्वर तोरो सी असो कह्य हय : मोरो लोगों ख जान दे कि हि मोरी आराधना कर सकय। ");
INSERT INTO lbm_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","पर यदि उन्ख जान नहीं देजो त सुन, मय मेंढकों ख भेज क तोरो पूरो देश ख हानि पहुंचान वालो हय। ");
INSERT INTO lbm_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","अऊर नील नदी मेंढकों सी भर जायेंन, मेंढका नदी म सी निकल क तुम्हरो घरों म, तुम्हरो बिस्तर पर, तुम्हरो सेवकों को घरों म अऊर पूरी प्रजा को घरों म भी भर जायेंन यहां तक कि तुम्हरो तन्दूरों म यां तुम्हरो आटा गूथन को बर्तन म भी भर जायेंन; ");
INSERT INTO lbm_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","तोरो अऊर तोरी प्रजा अऊर तोरो कर्मचारियों, सब को शरीर पर मेंढका चढ़ जायेंन’।” ");
INSERT INTO lbm_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","तब परमेश्वर न मूसा सी कह्यो, “हारून सी कह्यजो कि नदियों, नहरों, अऊर झीलों को ऊपर लाठी को संग अपनो हाथ बढ़ा कि मेंढकों पूरो मिस्र देश पर चढ़ जाये।” ");
INSERT INTO lbm_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","तब हारून न मिस्र देश को झीलों पर हाथ बढ़ायो; अऊर मेंढकों न बाहेर निकल क पूरो मिस्र देश ख झाक दियो। ");
INSERT INTO lbm_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","अब जादूगर न भी अपनो तंत्र-मंत्रों सी वसोच मिस्र देश पर मेंढकों ख ले आये। ");
INSERT INTO lbm_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","फिरौन न मूसा अऊर हारून ख बुलाय क कह्यो, “अपनो परमेश्वर सी बिनती कर कि इन मेंढकों ख मोरो सी अऊर मोरी प्रजा सी दूर कर दे; अऊर मय इस्राएली लोगों ख जान देऊं। जेको सी हि परमेश्वर लायी बलिदान कर सकय।” ");
INSERT INTO lbm_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मूसा न फिरौन राजा ख उत्तर दियो, “तय मोख आदेश दे कि अब मय तोरो, अऊर तोरो कर्मचारियों, अऊर तोरो लोगों लायी, कब बिनती करूं, कि परमेश्वर तोरो जवर सी अऊर तोरो घरों सी मेंढकों ख दूर करे, अऊर हि केवल नील नदी मच रहे।” ");
INSERT INTO lbm_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फिरौन राजा न उत्तर दियो, “कल मोरो लायी प्रार्थना करो।” मूसा न कह्यो, “जसो तय कह्य हंय, वसोच होयेंन, जेकोसी तोख समझ आय जायेंन कि हमरो परमेश्वर को समान कोयी दूसरो नहाय। ");
INSERT INTO lbm_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","अऊर मेंढका तोरो जवर सी तोरो घरों म सी अऊर तोरो कर्मचारियों अऊर तुम्हरी प्रजा को जवर सी दूर कर दियो जायेंन अऊर केवल नील नदी म रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","तब मूसा अऊर हारून फिरौन राजा को जवर सी बाहेर चल्यो गयो; मूसा न मेंढकों को जान को बारे म परमेश्वर सी बिनती करी। जो राजा पर लायो होतो, ");
INSERT INTO lbm_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","परमेश्वर न मूसा को कहन को अनुसार करयो; अऊर मेंढका घरों, आंगनों, गावों अऊर खेतों को सब मेंढका मर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","तब लोगों न मरयो हुयो मेंढका ख एक तरफ जमा करयो, अऊर पूरो देश दुर्गन्ध सी भर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","जब फिरौन राजा न देख्यो कि मेंढका सब मर गयो अऊर परेशानी सब दूर भय गयी, ओन अपनो मन फिर सी कठोर कर क् मूसा अऊर हारून की बात नहीं सुनी, जसो परमेश्वर न कह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","तब परमेश्वर न मूसा सी कह्यो, “हारून ख आज्ञा दे, ‘तय अपनो लाठी उठाय क जमीन की धूल पर मार, जेकोसी पूरो मिस्र देश म धूल मच्छर बन जाये’।” ");
INSERT INTO lbm_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","अऊर उन्न वसोच करयो; मतलब हारून न अपनो हाथ बढ़ाय क् लाठी ले क जमीन की धूल पर मारयो, तब मच्छरो न आदमी अऊर पशु दोयी ख पिसवा भय गयो, पूरो मिस्र देश म जमीन की धूल पिसवा बन गयो। ");
INSERT INTO lbm_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","जादूगरों न अपनो तंत्र-मंत्रों को द्वारा पिसवा ख लावन की कोशिश करी; पर नहीं कर पायो। यो तरह आदमी अऊर जनावरों दोयी पर मच्छर बन्यो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तब जादूगरों न फिरौन राजा सी कह्यो, “यो परमेश्वर को काम आय।” पर फिरौन राजा को मन कठोर भय गयो, ओन मूसा अऊर हारून की बात नहीं सुनी। जसो परमेश्वर न कह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","तब परमेश्वर न मूसा सी कह्यो, “कल सुबेरे जल्दी उठ कर फिरौन राजा को जवर जावो जब ऊ नील नदी की तरफ जाये, तब ओको सी कह्यजो, ‘परमेश्वर तोरो सी यो कह्य हय : मोरो लोगों ख जान दे कि हि मोरी आराधना करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","यदि तय मोरो लोगों ख नहीं जान देजो त सुन, मय तोरो पर अऊर तोरो कर्मचारियों अऊर तोरो प्रजा पर, अऊर तोरो घरों म झुण्ड को झुण्ड माखी भेजूं, अऊर मिस्रियों को घर अऊर उन्को रहन को जागा भी माखियों सी भर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","पर ऊ दिन मय गोशेन देश ख जेको म मोरी प्रजा रह्य हय अलग करूं, अऊर ओख म माखियों को झुण्ड नहीं होयेंन; जेकोसी तय जान ले कि पूरी धरती पर मयच परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","मय अपनो लोगों अऊर तोरी प्रजा को बीच अन्तर करूं। यो चिन्ह चमत्कार कल प्रगट होयेंन’।” ");
INSERT INTO lbm_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","अऊर परमेश्वर न वसोच करयो, फिरौन राजा को महल अऊर ओको कर्मचारियों को घरों म, अऊर पूरो मिस्र देश म माखियों सी झुण्ड को झुण्ड भर गयो, पूरो मिस्र देश माखियों को वजह नुकसान भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","तब फिरौन राजा न मूसा हारून ख बुलाय क कह्यो, “तुम जावो अऊर अपनो परमेश्वर लायी योच देश म बलिदान चढ़ावो।” ");
INSERT INTO lbm_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मूसा न कह्यो, “असो करनो उचित नहीं होयेंन; कहालीकि हम अपनो परमेश्वर यहोवा लायी असी मिस्रियों को जनावर बलिदान करबोंन; जेक मिस्र को लोग घृणित समझय हय। मिस्रियों को देखतो असी बलिदान करबोंन त का हि हम पर गोटा नहीं मारेंन? ");
INSERT INTO lbm_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","हम सुनसान जागा म तीन दिन को रस्ता पर जाय क अपनो परमेश्वर यहोवा लायी जसो ऊ हम सी कहेंन वसोच बलिदान चढ़ाबों।” ");
INSERT INTO lbm_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फिरौन न कह्यो, “मय तुम ख जान देऊं कि तुम अपनो परमेश्वर यहोवा लायी सुनसान जागा म बलिदान चढ़ावो; पर बहुत दूर मत जावो, अऊर तुम मोरो लायी प्रार्थना करो।” ");
INSERT INTO lbm_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मूसा न उत्तर दियो, “सुन, मय तोरो जवर सी बाहेर जाय रह्यो हय। मय परमेश्वर सी प्रार्थना करूं कि माखियों को झुण्ड तोरो, कर्मचारियों, अऊर प्रजा को जवर सी कल दूर हो; पर फिरौन फिर कपट सी हम्ख परमेश्वर लायी बलिदान करन ख जान देन लायी मना नहीं करे।” ");
INSERT INTO lbm_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","मूसा फिरौन राजा को जवर सी निकल्यो अऊर परमेश्वर सी प्रार्थना करी। ");
INSERT INTO lbm_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","अऊर परमेश्वर न मूसा को कहन को अनुसार माखियों को झुण्डों ख फिरौन, अऊर ओको कर्मचारियों, अऊर ओकी प्रजा सी दूर करयो; अऊर एक भी मक्खी नहीं रही। ");
INSERT INTO lbm_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","पर फिरौन राजा न यो बार भी अपनो मन कठोर कर लियो, अऊर फिर ओन लोगों ख जान नहीं दियो। ");
INSERT INTO lbm_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","तब परमेश्वर न मूसा सी कह्यो, “फिरौन राजा को जवर जाय क कह्य, ‘इब्रियों को परमेश्वर यहोवा न यो कह्य हय कि, मोरी प्रजा ख यहां सी जान देवो कि हि मोरी आराधना करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","यदि तय उन्ख नहीं जान देजो अऊर उन्ख अब भी पकड़्यो रखजो, ");
INSERT INTO lbm_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","त देख, तोरो जो घोड़ा, गधा, ऊंट, गाय-बईल, मेंढी-शेरी, अऊर जो जनावर मैदान म हंय, उन पर परमेश्वर को हाथ असो पड़ेंन कि एक भयानक महामारी फैलेंन। ");
INSERT INTO lbm_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","पर परमेश्वर इस्राएलियों को जनावर अऊर मिस्रियों को जनावर को बीच असो अन्तर कर देयेंन अऊर कोयी भी जनावर इस्राएलियों को नहीं मरेंन’।” ");
INSERT INTO lbm_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","तब परमेश्वर न एक समय ठहरायो, अऊर कह्यो, “मय यो काम कल मिस्र देश म करूं।” ");
INSERT INTO lbm_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","दूसरो दिन परमेश्वर न असोच करयो; अऊर मिस्र देश को पूरो जनावर मर गयो, पर इस्राएलियों को एक भी जनावर नहीं मरयो। ");
INSERT INTO lbm_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","अऊर फिरौन राजा न लोगों ख देखन भेज्यो, पर इस्राएलियों को एक भी जनावर नहीं मरयो होतो। तब भी फिरौन राजा को मन कठोर भय गयो, अऊर ओन इस्राएलियों ख जान नहीं दियो। ");
INSERT INTO lbm_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","फिर परमेश्वर न मूसा अऊर हारून सी कह्यो, “तुम भट्ठी सी मुट्टी भर राख लेवो, अऊर मूसा ओख फिरौन राजा को आगु राखड़ ख आसमान को तरफ उड़ाय देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","तब राख धूल बन क पूरो मिस्र देश म आदमियों अऊर जनावर पर फोड़ा बन जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","येकोलायी उन्न भट्ठी म की मुट्ठी भर राख उठायी, अऊर हि फिरौन को आगु खड़ो भयो, अऊर मूसा न हवा म आसमान को तरफ राखड़ उड़ाय दियो, अऊर वहां आदमियों अऊर जनावर पर फफोंला अऊर फोड़ा बन गयो। ");
INSERT INTO lbm_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","येकोलायी उन जादूगर फोड़ा को वजह मूसा को आगु खड़ो नहीं भय सक्यो। कहालीकि पूरो मिस्रियों अऊर जादूगरों को शरीर पर भी फोड़ा भय गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","पर परमेश्वर न फिरौन को मन ख कठोर कर दियो, जसो परमेश्वर न मूसा सी कह्यो होतो, ओन उन्की नहीं सुनी। ");
INSERT INTO lbm_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","तब परमेश्वर न मूसा सी कह्यो, “कल सुबेरे उठ क फिरौन राजा को जवर जाय क यो कह्यजो की, ‘इब्रियों को परमेश्वर यहोवा यो कह्य हय : मोरो लोगों ख जान देवो कि हि मोरी आराधना कर सके। ");
INSERT INTO lbm_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","कहालीकि अब की बार मय तोरो पर, अऊर तोरो कर्मचारियों पर अऊर तोरी प्रजा पर विपत्तियां डालूं, जेकोसी तय जान लेजो की पूरो धरती पर मोरो जसो दूसरो कोयी भी नहाय। ");
INSERT INTO lbm_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","मय न त अभी हाथ बढ़ाय क तोख अऊर तोरी प्रजा ख महामारियों सी मारयो होतो, अऊर धरती पर सी तोरो सत्यानाश भय गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","पर मय न सचमुच तोख योच उद्देश सी येकोलायी जीन्दो रख्यो हय कि मय तोख अपनी सामर्थ दिखाऊं, अऊर मोरो नाम पूरी धरती म प्रसिद्ध हो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","फिर तुम अब भी मोरी प्रजा को सामने अपनो आप ख बड़ो समझय हय, अऊर उन्ख जान नहीं देवय हय? ");
INSERT INTO lbm_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","सुन, कल मय योच समय असो भारी गारगोटियों की भयंकर बारीश बरसाऊं; जसो मिस्र देश की स्थापना को दिन सी अब तक नहीं भयी हय। ");
INSERT INTO lbm_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","येकोलायी अब लोगों ख भेज क अपनो सब जनावर ख अऊर तोरो जवर खुलो मैदानी क्षेत्र म हय, सब ख सुरक्षित जागा पर लिजाय क रख्यो जाये; नहीं त जितनो आदमी यां जनावर मैदान म असुरक्षित रह्य गयो हय, उन्ख घरों म नहीं जमा करयो जाये, नहीं त उन पर गारगोटी गिरेंन, अऊर हि मर जायेंन’।” ");
INSERT INTO lbm_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","येकोलायी फिरौन को कुछ कर्मचारियों म सी जो लोग परमेश्वर को वचन को डर मानत होतो, उन्न अपनो अपनो सेवकों अऊर जनावर ख आसरा लेन लायी घरों को अन्दर ले आये। ");
INSERT INTO lbm_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","पर जिन्न परमेश्वर को वचन पर ध्यान नहीं लगायो उन्न अपनो सेवक अऊर जनावर ख मैदान मच रहन दियो। ");
INSERT INTO lbm_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","तब परमेश्वर न मूसा सी कह्यो, “अपनो हाथ आसमान की तरफ बढ़ा कि पूरो मिस्र देश को आदमियों, जनावरों, अऊर खेतो की पूरी हरियाली फसल पर गारगोटी गिरें।” ");
INSERT INTO lbm_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","तब मूसा न अपनी लाठी आसमान को तरफ उठायो, अऊर परमेश्वर की सामर्थ सी बादर गर्जन लग्यो अऊर गारगोटी गिरन लगी अऊर बीजली भी धरती पर चमकन लगी। यो तरह परमेश्वर न मिस्र देश पर गारगोटी की बारीश करी। ");
INSERT INTO lbm_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","जो गारगोटी को संग बीजली भी गिरत होती, मिस्र देश म असी गारगोटी की बारीश पहिले कभी नहीं गीरी होती। ");
INSERT INTO lbm_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","गारगोटी न पूरो मिस्र देश को आदमियों अऊर जनावरों ख जो मैदान म होतो, नाश कर दियो। गारगोटी सी खेत की पूरी फसल नाश भय गयी, अऊर मैदान को सब झाड़ भी टूट गयो। ");
INSERT INTO lbm_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","केवल गोशेन प्रदेश म, जित इस्राएली रहत होतो गारगोटी की बारीश नहीं भयी। ");
INSERT INTO lbm_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तब फिरौन राजा न मूसा अऊर हारून ख बुलायो, अऊर फिरौन न उन्को सी कह्यो, “मय न यो बार पाप करयो हय; परमेश्वर सच्चो हय, मय अऊर मोरी प्रजा झूठी हय। ");
INSERT INTO lbm_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","परमेश्वर सी प्रार्थना करो। बादर को गर्जनों अऊर गारगोटी को बरसनो त बहुत भय गयो; अब तुम परमेश्वर सी बिनती करो; तब मय तुम लोगों ख जान देऊं, तुम लोगों ख यहां नहीं रोकूं।” ");
INSERT INTO lbm_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मूसा न फिरौन सी कह्यो, “जसोच मय नगर सी बाहेर जाऊं परमेश्वर की तरफ अपनो हाथ फैलाऊं, तब बादर को गर्जनों बन्द होय जायेंन अऊर गारगोटी फिर नहीं गिरेंन, जेको सी तय जान जाजो कि धरती परमेश्वर कीच आय। ");
INSERT INTO lbm_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","तब भी मय जानु हय कि नहीं त तय अऊर नहीं तोरो कर्मचारी यहोवा परमेश्वर को डर नहीं मानय।” ");
INSERT INTO lbm_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","सन अऊर अलसी की फसल बरबाद भय गयी, कहालीकि जौ की लोंब निकल गयी होती अऊर सन म कली अऊर फूल लग्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","पर कोयी भी गहूं अऊर कठिया गहूं नाश नहीं भयो, कहालीकि ऊ बाद म पकय हय। ");
INSERT INTO lbm_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","जब मूसा फिरौन राजा को जवर सी नगर को बाहेर निकल गयो अऊर परमेश्वर की तरफ अपनो हाथ फैलाय क प्रार्थना करयो, अऊर तुरतच बादर को गर्जनों अऊर गारगोटी को गिरनो बन्द भयो, फिर धरती पर बारीश नहीं भयी। ");
INSERT INTO lbm_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","जब फिरौन राजा न देख्यो कि बारीश अऊर गारगोटी अऊर बादर को गर्जनों बन्द होय गयो, तब ओन फिर सी पाप करयो। ओन अऊर ओको सेवकों न अपनो मन कठोर कर लियो। ");
INSERT INTO lbm_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","फिरौन राजा को मन कठोर होतो गयो, अऊर ओन इस्राएलियों ख जान नहीं दियो, जसो कि परमेश्वर न मूसा को द्वारा कह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","तब परमेश्वर न मूसा सी कह्यो, “फिरौन राजा को जवर जावो; कहालीकि मय नच ओको अऊर ओको कर्मचारियों को मन कठोर कर दियो हय कि उन्को बीच म अपनो चिन्ह चमत्कार ख दिखाऊं; ");
INSERT INTO lbm_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","अऊर तुम अपनो बेटों अऊर नातियों सी येको वर्णन करो कि परमेश्वर न मिस्रवासियों ख कसो ठट्ठा म उड़ायो अपनो का का चिन्ह चमत्कार उन्को बीच म प्रगट करयो हय; जेकोसी तुम यो जान लेवो कि मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","मूसा अऊर हारून फिरौन को जवर जाय क कह्यो, “इब्रियों को परमेश्वर यहोवा तोरो सी असो कह्य हय, ‘तय कब तक मोरो आगु नम्र होन सी संकोच करतो रहजो? मोरो लोगों ख जान नहीं दे, कि हि मोरी आराधना कर सके। ");
INSERT INTO lbm_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","यदि तय मोरी लोगों ख जान नहीं देजो त, कल मय तोरो देश पर फाफावों ख ले आऊं, ");
INSERT INTO lbm_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","अऊर फाफावों पूरो जमीन ख असो झाक लेयेंन कि वा कोयी ख दिखायी नहीं पड़ेंन; अऊर जो कुछ गारगोटी सी बच गयो हय ओख हि खाय जायेंन, अऊर तुम्हरो जितनो मैदान म लग्यो हय उन्को भी हि चट कर देयेंन, ");
INSERT INTO lbm_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","अऊर हि तोरो अऊर तोरो पूरो कर्मचारियों, यहां तक कि पूरो मिस्रियों को घरों म भर जायेंन; इतनो फाफावों ख तोरो बाप दादों न यां उन्को पूर्वजों न जब सी धरती पर जनम्यो तब सी अज तक कभी नहीं देख्यो।’” तब मूसा मुड़ क फिरौन को जवर सी बाहेर चली गयो। ");
INSERT INTO lbm_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","तब फिरौन राजा को कर्मचारियों न फिरौन सी कह्यो, “ऊ आदमी कब तक हमरो लायी मुसीबत बन्यो रहेंन? इस्राएलियों ख जान दे कि हि अपनो परमेश्वर यहोवा की आराधना कर सकय। का तय अब भी नहीं जानय कि पूरो मिस्र देश नाश भय गयो हय?” ");
INSERT INTO lbm_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","मूसा अऊर हारून फिरौन राजा को जवर वापस लायो गयो। अऊर फिरौन राजा न उन्को सी कह्यो, “चली जावो, अपनो परमेश्वर यहोवा की आराधना करो; पर जो जान वालो हय, हि लोग कौन-कौन आय?” ");
INSERT INTO lbm_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मूसा न उत्तर दियो, “हम त पूरो बेटा-बेटियां, मेंढी-शेरियां, गाय-बईलों समेत बल्कि बच्चा सी बूढ्ढा तक सब जाबोन, कहालीकि हम्ख परमेश्वर लायी त्यौहार मनानो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फिरौन राजा न यो तरह उन्को सी कह्यो, “परमेश्वर तुम्हरो संग रहे यदि मय तुम्ख बच्चां समेत जान देऊ हय; त देखो, तुम्हरो मन म बुरायी हय। ");
INSERT INTO lbm_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","नहीं! असो नहीं होय सकेंन; तुम आदमीच जावो अऊर परमेश्वर की आराधना करो। तुम असोच त चाहत होतो।” मूसा अऊर हारून ख फिरौन को आगु सी निकाल दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","तब परमेश्वर न मूसा सी कह्यो, “मिस्र देश को तरफ अपनो हाथ उठाय क कि फाफावों को झुण्ड मिस्र देश पर चढ़ क् जमीन को जितनो अनाज आदि गारगोटी सी बच्यो हय सब खाय जाये।” ");
INSERT INTO lbm_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","जब मूसा न मिस्र देश की तरफ अपनी लाठी उठायी, तब परमेश्वर न पूरो मिस्र देश पर पूरो दिन अऊर रात पूर्व दिशा की हवा चलायी; अऊर जब भुन्सारे भयी तब ऊ हवा को संग फाफावों को झुण्ड भी आयो। ");
INSERT INTO lbm_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","अऊर फाफावों न चढ़ क पूरो मिस्र देश म फैल गयो। उन्को झुण्ड बहुत बड़ो होतो, उन सी पहले असो फाफा नहीं आयो होतो, अऊर नहीं उन्को बाद असी कभी आयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","हि त फाफावों न जमीन ख असो झाक दियो, कि पूरो देश म अन्धारो छाय गयो। उन्न देश को पूरो पौधों ख, अऊर झाड़ को फरों ख, उन्को पूरो अनाज जो कुछ गारगोटी की बारीश सी बच्यो होतो, सब ख खाय लियो; पूरो मिस्र देश म कोयी भी हरी चिज नहीं बची, अऊर मैदान को पौधा अऊर झाड़ नहीं। ");
INSERT INTO lbm_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","तब फिरौन न तुरतच मूसा अऊर हारून ख बुलाय क अऊर उन्को सी कह्यो, “मय न तुम्हरो परमेश्वर यहोवा को अऊर तुम्हरो भी खिलाफ पाप करयो हय। ");
INSERT INTO lbm_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","अब मोरो पाप ख एक बार अऊर माफ करो, अऊर अपनो परमेश्वर यहोवा सी बिनती करो कि ऊ मोरो ऊपर सी मृत्यु दण्ड ख दूर करे।” ");
INSERT INTO lbm_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मूसा फिरौन राजा को जवर सी बाहेर चल्यो गयो अऊर परमेश्वर सी प्रार्थना करी। ");
INSERT INTO lbm_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","तब परमेश्वर न पूर्व को हवा ख बदल क बहुत भयानक पश्चिम हवा बहायो अऊर फाफावों ख उड़ाय क लाल समुन्दर म डाल दियो, अऊर मिस्र देश को कोयी जागा म एक भी फाफा नहीं रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","पर परमेश्वर न फिरौन राजा ख कठोर बनाय दियो, अऊर ओन इस्राएलियों ख जान नहीं दियो। ");
INSERT INTO lbm_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","तब परमेश्वर न मूसा सी कह्यो, “अपनो हाथ आसमान की तरफ उठा कि मिस्र देश पर असो अन्धारो छाय जाये, कि टटोल्यो जाय सके।” ");
INSERT INTO lbm_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","तब मूसा न अपनो हाथ आसमान की तरफ बढ़ायो, अऊर पूरो मिस्र देश पर तीन दिन तक घोर अन्धारो छायो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","मिस्र निवासी तीन दिन तक कोयी ख नहीं देख सक्यो, अऊर नहीं कोयी अपनी जागा सी उठ्यो; पर पूरो इस्राएलियों को घरों म उजाड़ो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तब फिरौन राजा न मूसा ख बुलाय क कह्यो, “तुम जावो, अऊर परमेश्वर की आराधना करो; अपनो संग बच्चा ख भी ले जावो; केवल अपनी शेरी-मेंढियों अऊर गाय-बईल ख छोड़ जावो।” ");
INSERT INTO lbm_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मूसा न कह्यो, “तोख हमरो हाथ म मेलबलि अऊर होमबलि को जनावर भी देनो पड़ेंन, जिन्ख हम अपनो परमेश्वर यहोवा लायी बलिदान चढ़ायबो। ");
INSERT INTO lbm_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","येकोलायी हमरो जनावर भी हमरो संग जायेंन, उन्की एक खुरी भी नहीं रह्य जायेंन, हम अपनो परमेश्वर की आराधना लायी उन्ख अपनो संग ले जाबोंन, जब तक हम उत नहीं पहुंच जाय, तब तक नहीं जानजे कि हम अपनो परमेश्वर की आराधना कसो करबोंन।” ");
INSERT INTO lbm_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","पर परमेश्वर न फिरौन राजा को मन कठोर कर दियो, अऊर ऊ उन्ख जान नहीं दियो। ");
INSERT INTO lbm_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","तब फिरौन राजा न मूसा सी कह्यो, “मोरो आगु सी निकल जा; अऊर सावधान रह्य; मोख अपनो मुंह फिर मत दिखाजो; कहालीकि जो दिन तय मोख मुंह दिखाजो, ओन दिन तय मारयो जाजो।” ");
INSERT INTO lbm_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","तब मूसा न फिरौन राजा सी कह्यो, “तय न ठीक कह्यो हय; मय तोरो मुंह ख फिर कभी नहीं देखूं।” ");
INSERT INTO lbm_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","तब परमेश्वर न मूसा सी कह्यो, “मय एक अऊर विपत्ति फिरौन राजा अऊर मिस्र पर लाऊं, ओको बाद तुम लोगों ख इत सी जान देयेंन; अऊर जब ऊ जान देयेंन तब तुम सब ख जरूरच निकाल देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","अब तय मोरो इस्राएली लोगों मोरी या आज्ञा सुनाव कि हर एक आदमी अऊर बाई अपनो पड़ोसिन सी सोनो-चांदी को जेवर मांग ले।” ");
INSERT INTO lbm_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","तब परमेश्वर न मिस्रियों पर दया करी। येको अलावा मूसा मिस्र देश म फिरौन राजा को कर्मचारियों अऊर साधारन लोगों की नजर म अति महान होतो। ");
INSERT INTO lbm_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","तब मूसा न फिरौन सी कह्यो, “परमेश्वर यो कह्य हय, मय अरधी रात को लगभग मय मिस्र देश को बीच म सी होय क चलूं। ");
INSERT INTO lbm_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","तब मिस्र म सिंहासन पर विराजन वालो फिरौन सी ले क चक्की पीसन वाली दासी तक को बड़ो टुरा; अऊर जनावर तक को सब पहिलौठा मर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","अऊर पूरो मिस्र देश म बड़ो हाहाकार मचेंन, यहां तक कि ओको जसो नहीं त कभी भयो अऊर नहीं होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","पर इस्राएलियों को खिलाफ, का आदमी का जनावर, कोयी पर कोयी कुत्ता भी नहीं भूकेंन; जेकोसी तुम जान लेवो कि मिस्रियों अऊर इस्राएलियों म मय परमेश्वर भेद करू हय। ");
INSERT INTO lbm_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","तब तोरो यो सब कर्मचारी मोरो जवर आय क प्रणाम कर क् यो कहेंन, ‘अपनो सब लोगों समेत निकल जावो।’ अऊर ओको बाद मय भी निकल जाऊं।” यो कह्य क मूसा बड़ो गुस्सा सी फिरौन को जवर सी निकल गयो। ");
INSERT INTO lbm_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","परमेश्वर न मूसा सी कह्य दियो होतो, “फिरौन तुम्हरी बाते नहीं सुनेंन; कहालीकि मय मिस्र देश म बहुत सो चमत्कार करूं।” ");
INSERT INTO lbm_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मूसा अऊर हारून न फिरौन राजा को आगु यो सब चमत्कार करयो; पर परमेश्वर न फिरौन को दिल ख अऊर कठोर कर दियो, येकोलायी ओन इस्राएलियों ख अपनो देश सी जान नहीं दियो। ");
INSERT INTO lbm_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","तब परमेश्वर न मिस्र देश म मूसा अऊर हारून सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“यो महीना तुम लोगों लायी सुरूवात को साल को पहिलो महीना ठहरे। ");
INSERT INTO lbm_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्राएल की पूरी मण्डली सी यो कहो की; यो महीना को दसवों दिन ख तुम अपनो पूर्वजों को घराना को अनुसार, एक एक मेम्ना ले रखो; ");
INSERT INTO lbm_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","अऊर यदि कोयी को घराना म एक मेम्ना ख खान लायी आदमी कम हो, त ऊ अपनो सब सी जवर रहन वालो पड़ोसी को संग प्रानियों की गिनती को अनुसार एक मेम्ना ले रखो; अऊर तुम हर एक को खान को अनुसार मेम्नों को हिसाब करजो। ");
INSERT INTO lbm_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","तुम्हरो मेम्ना निर्दोष अऊर एक साल को नर हो, अऊर ओख चाहे मेंढी म सी लेना चाहे शेरी म सी। ");
INSERT INTO lbm_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","अऊर यो महीना को चौदा दिन तक ओको ध्यान रखजो, अऊर ओख शाम ख इस्राएल की पूरी मण्डली को लोग ओख बलिदान करे। ");
INSERT INTO lbm_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","तब हि ओको खून म सी कुछ ले क जिन घरों म मेम्ना ख खाबोंन उन्को द्वार को दोयी बाजू अऊर चौखट को ऊपर लगाये। ");
INSERT INTO lbm_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","अऊर हि ओको मांस ख उच रात आगी म भूज क अखमीरी रोटी अऊर कड़ू साग भाजी को संग म खाये। ");
INSERT INTO lbm_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","मेम्ना को मांस ख कच्चो यां पानी म उबाल क मत खाना, बल्की मुंड, पाय, अऊर अतड़िया सहित ओख आगी म भूज क खाजो। ");
INSERT INTO lbm_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","अऊर ओको म सी कुछ भी सुबेरे तक मत रहन देजो अऊर यदि कुछ सुबेरे तक रह्य भी जाये, त ओख आगी म जलाय देजो। ");
INSERT INTO lbm_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","अऊर ओकी खान की या विधि आय, अपनी कमर बान्ध क, पाय म जूता पहिन्यो, अऊर हाथ म लाठी पकड़्यो हुयो ओख फुर्ती सी खाना; ऊ त परमेश्वर को त्यौहार आय। ");
INSERT INTO lbm_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","कहालीकि मय यो रात ख मिस्र देश को बीच म होय क जाऊं, अऊर उत का आदमी अऊर का जनावरों को हरेक नर पहिलौठा ख मारूं; अऊर मिस्र को पूरो देवतावों ख भी सजा देऊं; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","अऊर जिन घरों म तुम रह्य हय, उन पर लगायो खून तुम्हरो लायी एक चिन्ह ठहरेंन; मतलब मय ऊ खून को चिन्ह ख देख क तुम ख छोड़ देऊं, अऊर जब मय मिस्र देश को लोगों ख मारूं, तब ऊ महामारी तुम पर नहीं आयेंन अऊर तुम नाश नहीं होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","अऊर ऊ दिन तुम ख याद दिलान वालो ठहरेंन, अऊर तुम ओख परमेश्वर लायी त्यौहार कर क् मनाना; ऊ दिन तुम्हरो पीढ़ियों म हमेशा की विधि जान क मान्यो जाये।” ");
INSERT INTO lbm_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","परमेश्वर न कह्यो, “सात दिन तक अखमीरी रोटी खायो जाये, तुम पहिलो च दिन अपनो-अपनो घर सी खमीर दूर करजो, कहालीकि जो आदमी पहिले दिन सी ले क सातवों दिन तक कोयी खमीर को चीज खाये, ऊ इस्राएलियों को बीच सी बाहेर निकाल दियो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","तुम पवित्र सभा पहिले दिन अऊर सातवों दिन करजो; उन दोयी दिनों म कोयी भी काम नहीं करयो जाये; पर जेवन लायी खाना पकाय सकय हय। ");
INSERT INTO lbm_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","येकोलायी तुम बिना खमीर की रोटी को त्यौहार मानना, कहालीकि उच दिन मानो मय न तुम ख मिस्र देश सी बाहेर निकाल्यो हय; यो वजह ऊ दिन तुम्हरो पीढ़ियों म हमेशा की विधि जान क मान्यो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहिलो महिना को चौदावों दिन की शाम सी ले क इक्कीसवो दिन की शाम तक तुम अखमीरी रोटी खायो करजो। ");
INSERT INTO lbm_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिन तक तुम्हरो घरों म कुछ भी खमीर नहीं रहनो पाये; बल्की जो कोयी कोयी खमीरी चिज ख खाये, चाहे ऊ देशी हो यां परदेशी, ऊ प्रानी इस्राएलियों की सभा सी निकाल दियो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","तुम कोयी भी खमीर को चीज मत खाजो; तुम अपनो घर म बिना खमीर की रोटी खायो करजो।” ");
INSERT INTO lbm_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","तब मूसा न इस्राएलियों को सब बुजूर्गों ख बुलाय क कह्यो, “तुम अपनो अपनो परिवार को अनुसार एक एक मेम्ना अलग कर रखो, अऊर फसह त्यौहार पशु बलि करजो। ");
INSERT INTO lbm_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","अऊर ओको खून जो कोहपर म होयेंन ओको म जूफा नाम की झाड़ी सी बन्यो एक गुच्छा डुबाय क उच कोहपर म को खून सी दरवाजा को चौखट पर दोयी बाजुवों पर लगावो; अऊर सबेरे होनो तक तुम म सी कोयी भी घर सी बाहेर नहीं निकले। ");
INSERT INTO lbm_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","जब परमेश्वर मिस्रियों ख मारन लायी मिस्र देश सी होय क जायेंन; येकोलायी जित जित ऊ चौखट को ऊपर अऊर दोयी बाजू ऊ खून देखेंन, ऊ दरवाजा ख छोड़ देयेंन, अऊर नाश करन वालो ख तुम्हरो घरों म मारन लायी नहीं जान देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","फिर तुम या विधि ख अपनो अऊर अपनो वंश को लायी हमेशा को नियम जान क मानतो जावो। ");
INSERT INTO lbm_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","जब तुम ऊ देश म पहुंचो जेक परमेश्वर न तुम्ख देन को वादा करयो होतो, तुम उत सिरजो, त तुम यो विधि ख मानजो। ");
INSERT INTO lbm_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","अऊर जब तुम्हरो बच्चां तुम सी पूछेंन, ‘या विधि को का मतलब हय?’ ");
INSERT INTO lbm_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तब तुम उन्को यो उत्तर देजो, ‘परमेश्वर को यो फसह को बलिदान आय, जो मिस्रियों को मारन को समय मिस्र म रहन वालो हम इस्राएलियों को घरों ख बचायो, योच वजह ओको फसह को यो बलिदान करयो जावय हय।’” तब लोगों न मुंड झुकाय क आराधना करी। ");
INSERT INTO lbm_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","तब इस्राएलियों न जाय क असोच करयो, जो आज्ञा परमेश्वर न मूसा अऊर हारून ख दी होती, ओको अनुसार उन्न करयो। ");
INSERT INTO lbm_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","आधी रात ख परमेश्वर न मिस्र देश म राजगद्दी पर बैठन वालो फिरौन सी ले क बन्दी गृह म पड़्यो हुयो कैदी को बच्चा तक, अऊर सब को पहिलौठा को बल्की जनावर को सब पहिलौठों ख, मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","अऊर फिरौन राजा अऊर ओको सब कर्मचारी, अऊर सब मिस्र निवासी ऊ रात म उठ्यो; अऊर पूरो देश म बड़ो रोवनो अऊर चिल्लानो मच्यो, कहालीकि एक भी घर असो नहीं होतो जेको म कोयी मरयो नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","तब फिरौन न रात खच मूसा अऊर हारून ख बुलायो अऊर उन्को सी कह्यो। “तुम उठो, अऊर इस्राएलियों संग मोरो लोगों को बीच सी निकल जावो; जसो तुम न कह्यो होतो अऊर अपनो परमेश्वर की आराधना करो। ");
INSERT INTO lbm_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","जसो तुम न कह्यो होतो, अपनी मेंढी-शेरियों, गाय-बईलों ख संग ले जावो; अऊर मोख आशीर्वाद दे जावो।” ");
INSERT INTO lbm_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","मिस्री जो कहत होतो, हम त सब मर मिट्यो हय, उन्न इस्राएली लोगों पर दबाव डाल क कह्यो, “देश सी जल्दी नकल जावो, नहीं त हम सब मर जाबोन।” ");
INSERT INTO lbm_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","तब उन्न अपनो सन्यो हुयो आटा ख बिना खमीर मिलाये, बर्तन सहित कपड़ा म बान्ध क अपनो कन्धों पर उठाय क जान लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इस्राएलियों न जसो मूसा न कह्यो होतो वसोच कह्यो, अऊर मिस्रियों सी सोना-चांदी को जेवर अऊर कपड़ा मांग लियो; ");
INSERT INTO lbm_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","परमेश्वर न मिस्रियों लोगों पर दया करयो उन्न जो जो मांग्यो ऊ सब उन्ख दियो। यो तरह इस्राएलियों न पूरो मिस्रियों ख लूट लियो। ");
INSERT INTO lbm_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","तब इस्राएलियों लोग रामसेस नगर सी सुक्कोत नगर की तरफ चले, बाईयों अऊर बाल बच्चां ख छोड़ क् हि लगभग छय लाख पैदल चलन वालो आदमी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","उन्को संग एक दूसरो गैर-इस्राएली लोग भी गयो, अऊर मेंढी-शेरी, गाय-बईल, अऊर भी बड़ो झुण्ड उन्को संग गयो। ");
INSERT INTO lbm_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","अऊर जो सान्यो आटा हि मिस्र देश सी संग ले गयो होतो ओकी उन्न बिना खमीर कीच रोटियां बनायी; कहालीकि हि मिस्र देश सी निकाल्यो गयो होतो। हि नहीं त कुछ समय लायी उत ठहर सक्यो अऊर नहीं अपनी यात्रा लायी जेवन बना सके। ");
INSERT INTO lbm_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","मिस्र देश म रह्यतो इस्राएलियों लोगों ख चार सौ तीस साल तक रह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","अऊर उन चार सौ तीस साल को बीतन पर, ठीक उच दिन, परमेश्वर की लोगों की पूरी सेना मिस्र देश सी निकल गयी। ");
INSERT INTO lbm_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","परमेश्वर इस्राएलियों ख मिस्र देश सी निकाल लायो, यो तरह वा रात ओको निमित्त मानन को लायक हय; या परमेश्वर की वाच रात आय जेको पीढ़ी सी पीढ़ी म माननो इस्राएलियों को लायी जरूरी हय। ");
INSERT INTO lbm_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","तब परमेश्वर न मूसा अऊर हारून सी कह्यो, “त्यौहार की विधि या आय : कोयी परदेशी ओको म सी नहीं खाये; ");
INSERT INTO lbm_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","पर जो कोयी ख रुपया दे क लियो हुयो दास होना, अऊर ओको खतना करयो होना, त ऊ ओको म सी खाय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","पर परदेशी अऊर मजूर ओको म सी मत खावो। ");
INSERT INTO lbm_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ओको जेवन एकच घर म हो; मतलब तुम ओको मांस म सी कुछ घर सी बाहेर मत ले जावो; अऊर बलि प्रानी की कोयी हड्डी नहीं तोड़ो। ");
INSERT INTO lbm_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","पूरी इस्राएल मण्डली यो त्यौहार ख मनायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","अऊर यदि कोयी परदेशी तुम लोगों को संग रह्य क परमेश्वर लायी त्यौहार मनानो चाहेंन, त ऊ अपनो परिवार को सब आदमी को खतना करायो जाय, तब हि धार्मिक विधि म भाग ले क त्यौहार ख मना सकेंन; अऊर हि ऊ देश को निवासी ठहरेंन। पर कोयी खतनारहित आदमी ओको म सी नहीं खाय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ओको नियम देशी अऊर तुम्हरो बीच म रहन वालो परदेशी दोयी लायी एकच आय।” ");
INSERT INTO lbm_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","यो आज्ञा जो परमेश्वर न मूसा अऊर हारून ख दी ओको अनुसार पूरो इस्राएलियों न करयो। ");
INSERT INTO lbm_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","अऊर ठीक उच दिन परमेश्वर न इस्राएलियों ख मिस्र देश सी पूरो इस्राएलियों ख निकाल लायो। ");
INSERT INTO lbm_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“का आदमी को का जनावर को, हर एक नर इस्राएलियों म जितनो अपनी माय सी पहिलो जनम्यो हय, उन्ख मोरो लायी पवित्र माननो; ऊ मोरोच आय।” ");
INSERT INTO lbm_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","तब मूसा न लोगों सी कह्यो, “यो दिन ख याद रखो, जेको म तुम लोग मिस्र देश की गुलामी सी निकल आये हो; परमेश्वर न तुम ख उत सी अपनो हाथ को बल सी निकाल लायो हय; येकोलायी यो दिन खमीर सी बनी रोटी नहीं खायी जाये। ");
INSERT INTO lbm_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आबीब को महीना म अज कोच दिन तुम निकल्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","येकोलायी जब परमेश्वर तुम ख कनानी, हित्ती, एमोरी, हिब्बी, अऊर यबूसी लोगों को देश म पहुंचायेंन, जेक देन की ओन तुम्हरो पूर्वजों सी कसम खायी होती, अऊर जेक म दूध अऊर शहेद को धारा बहय हंय, तब तुम योच महीना म त्यौहार मनावो। ");
INSERT INTO lbm_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिन तक बिना खमीर की रोटी खायो करजो, अऊर सातवों दिन परमेश्वर लायी त्यौहार मनावो। ");
INSERT INTO lbm_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","इन सातों दिनों म बिना खमीर की रोटीच खायी जाये, अखमीरी रोटी तुम्हरो बीच नहीं दिखायी दे अऊर नहीं तुम्हरो पूरो देश म कहीं तुम्हरो जवर खमीर दिखायी दे। ");
INSERT INTO lbm_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","अऊर उच दिन तुम अपनो अपनो टुरावों ख यो कह्य क् समझाय देना कि यो हम उच काम को वजह करय हंय, जो परमेश्वर न हम्ख मिस्र देश सी निकाल आवन को समय हमरो लायी करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","तब यो तोरो लायी तोरो हाथ म एक चिन्ह होयेंन, अऊर तोरी आंखी को आगु याद करन वाली चीज ठहरे; जेको सी परमेश्वर की व्यवस्था तोरो मुंह पर रहे, कहालीकि परमेश्वर न तुम्ख अपनो ताकतवर हाथ सी मिस्र देश सी निकाल्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","यो वजह तुम या विधि ख हर साल सही समय पर करत रह्यजो। ");
INSERT INTO lbm_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“फिर जब परमेश्वर वा कसम को अनुसार, जो ओन तुम्हरो पूर्वजों सी अऊर तुम सी भी खायी हय, तुम्ख कनानियों को देश म पहुंचाय क ओख तुम्ख दे देयेंन, ");
INSERT INTO lbm_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तब तुम म सी जितनो नर अपनी अपनी माय को पहिलो जनम्यो आय उन्को, अऊर तुम्हरो जनावरों म जो असो आय उन्ख भी परमेश्वर लायी अर्पन करजो; सब नर बच्चां त परमेश्वर को आय। ");
INSERT INTO lbm_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","अऊर गधा को हर एक पहिलौठा को बदले मेम्ना दे क ओख छुड़ाय लेना, अऊर यदि तुम ओख छुड़ानो नहीं चाहवय त ओको गर्दन तोड़ देना। पर अपनो सब पहिलौठा टुरावों ख बदला दे क छुड़ाय लेना। ");
INSERT INTO lbm_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","अऊर आगु को दिनों म जब तुम्हरो टुरा तुम सी पूछेंन, ‘यो का हय?’ त उन सी कह्यजो, ‘परमेश्वर न हम लोगों ख मिस्र की गुलामी सी बाहेर अपनो ताकतवर हाथ को बल सी निकाल लायो हय। ");
INSERT INTO lbm_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","उच समय जब फिरौन राजा न कठोर होय क हम्ख निकलन नहीं दे रह्यो होतो, तब परमेश्वर न मिस्र देश म आदमी सी ले कर जनावर तक सब को पहिलौठा ख मार डाल्यो। येकोलायी हम हर एक जनावर नर पहिलौठा परमेश्वर ख चढ़ाजे हय, पर अपनो सब पहिलौठे टुरावों ख हम बदला दे क छुड़ाय लेजे हय।’ ");
INSERT INTO lbm_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","यो तुम्हरो याद लायी हाथ पर बन्ध्यो एक चिन्ह जसो अऊर तोरी दोयी आंखी को बीच टिका जसो ठहरे; कहालीकि परमेश्वर न हम लोगों ख मिस्र देश सी अपनो ताकतवर हाथों को बल सी निकाल लायो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","जब फिरौन राजा न लोगों ख जान की आज्ञा दे दी, परमेश्वर उन्ख पलिश्ती देश म होय क जो रस्ता जावय हय ऊ छोटो होतो; तब भी परमेश्वर न यो सोच्यो कि उन्ख ऊ रस्ता सी नहीं ले गयो कि कहीं असो नहीं होय कि जब हि लोग लड़ाई देखे तब पछताय क मिस्र देश वापस लौट जाय। ");
INSERT INTO lbm_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","येकोलायी परमेश्वर उन्ख घुमाय-फिराय क लाल समुन्दर को सुनसान रस्ता सी ले गयो। अऊर इस्राएली लोग अस्त्र-शस्त्र बान्ध्यो हुयो मिस्र सी निकल गयो। ");
INSERT INTO lbm_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","अऊर मूसा यूसुफ की हड्डियों ख संग म ले गयो; कहालीकि यूसुफ न इस्राएलियों सी यो कह्य क् कसम ली होती, “जब परमेश्वर तोरी सुधि ले, तब अपनो संग मोरी हड्डियों ख इत सी जरूर ले जाजो।” ");
INSERT INTO lbm_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","फिर उन्न सुक्कोत नगर सी आगु बढ़ क् सुनसान जागा पर एताम म डेरा डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","अऊर परमेश्वर उन्ख दिन म रस्ता दिखान लायी बादर को खम्बा म, अऊर रात ख उजाड़ो देन लायी आगी को खम्बा म होय क उन्को आगु आगु चलत होतो, जेकोसी हि रात-दिन चल सके। ");
INSERT INTO lbm_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ओन नहीं त बादर को खम्बा ख दिन म अऊर नहीं आगी को खम्बा ख रात म लोगों को आगु सी हटायो। ");
INSERT INTO lbm_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएलियों ख कहो कि हि पीछू लौट क मिगदोल नगर अऊर समुन्दर को बीच, पीहाहीरोत नगर को आगु, बालसपोन को सामने अपनो डेरा डाल, अऊर तुम लाल समुन्दर को किनार पर पड़ाव डालनो। ");
INSERT INTO lbm_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","तब फिरौन राजा इस्राएलियों को बारे म सोचेंन, ‘हि अनजान देश म भटक क घबराय गयो हय। सुनसान जागा न उन्ख बन्दी बनाय लियो हय।’ ");
INSERT INTO lbm_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","तब मय फिरौन राजा को मन ख कठोर कर देऊं, अऊर ऊ उन्को पीछा करेंन। तब फिरौन राजा अऊर ओकी पूरी सेना को द्वारा मोरी महिमा होयेंन; अऊर मिस्र लोग जान लेयेंन कि मयच परमेश्वर आय।” अऊर उन्न वसोच करयो। ");
INSERT INTO lbm_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जब मिस्र देश को फिरौन राजा ख यो समाचार मिल्यो कि हि लोग भग गयो, तब फिरौन राजा अऊर ओको कर्मचारियों को मन उन्को खिलाफ बदल गयो, अऊर हि कहन लग्यो, “हम न यो का का करयो कि इस्राएलियों को गुलामी सी मुक्त कर क् जान दियो!” ");
INSERT INTO lbm_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","तब राजा न अपनो रथ तैयार करयो अऊर अपनी सेना ख संग लियो। ");
INSERT INTO lbm_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ओन छय सौ अच्छो सी अच्छो रथ बल्की मिस्र को सब रथ उन्को अधिकारियों संग रख्यो। ");
INSERT INTO lbm_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","अऊर परमेश्वर न मिस्र देश को राजा फिरौन को मन ख कठोर कर दियो। येकोलायी ओन इस्राएलियों को पीछा करयो; पर इस्राएली जो हिम्मत को संग बढ़तो जाय रह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","पर फिरौन राजा को सब घोड़ा, रथों, अऊर घुड़सवारों संग मिस्र की सेना उन्को पीछा करतो हुयो उन्को जवर लाल समुन्दर को किनार पर जित डेरा डाल्यो होतो जाय पहुंची, जो पीहाहीरोत को जवर, बालसपोन को आगु होती। ");
INSERT INTO lbm_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","जब फिरौन राजा जवर आयो, तब इस्राएलियों न आंखी उठाय क का देख्यो कि मिस्री हमरो पीछा करतो आय रह्यो हय; तब इस्राएली बहुत डर गयो, अऊर चिल्लाय क परमेश्वर सी मदत की दोहायी मांगी; ");
INSERT INTO lbm_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","अऊर हि मूसा सी कहन लग्यो, “का मिस्र देश म कब्र नहीं होती जो तय हम ख मरन लायी जंगल म ले आयो हय? तय न हम्ख मिस्र देश सी निकाल क हमरो संग यो का करयो? ");
INSERT INTO lbm_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","का हम तोरो सी मिस्र देश म योच बात नहीं कहत रह्यो कि हम्ख रहन देवो कि हम मिस्रियों की गुलामी करतो? हमरो लायी जंगल म मरन को बदला मिस्रियों की गुलामी करनो अच्छो होतो।” ");
INSERT INTO lbm_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मूसा न लोगों सी कह्यो, “डरो मत, खड़ो खड़ो ऊ उद्धार को काम देखो, जो परमेश्वर अज तुम्हरो लायी करेंन; कहालीकि जिन मिस्रियों ख तुम अज देखय हय, उन्ख फिर कभी नहीं देख सकोंन। ");
INSERT INTO lbm_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","परमेश्वर तुम्हरो लायी लड़ेंन, येकोलायी तुम चुप रहो।” ");
INSERT INTO lbm_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तब परमेश्वर न मूसा सी कह्यो, “तय कहाली पुकार रह्यो हय मदत लायी? इस्राएलियों ख कहो हि आगु बढ़े। ");
INSERT INTO lbm_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","अऊर तय अपनी लाठी उठाय क अपनो हाथ समुन्दर को ऊपर बढ़ा, अऊर पानी दोय हिस्सा म होय जायेंन; जेकोसी इस्राएली समुन्दर को बीच सी सूखी जागा पर जा सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","अऊर सुन, मय खुद मिस्रियों को मन ख कठोर कर देऊं, जेकोसी हि इस्राएलियों को पीछा करतो हुयो समुन्दर को बीच म जायेंन। तब फिरौन राजा अऊर ओकी पूरी सेना, अऊर रथों अऊर घुड़सवारों को विनाश सी मोरी महिमा दिखेंन। ");
INSERT INTO lbm_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","जब फिरौन राजा, अऊर ओको रथों, अऊर घुड़सवारों ख हराऊं तब मोरी महिमा होयेंन, अऊर मिस्री जान लेयेंन कि मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","तब परमेश्वर को दूत जो इस्राएली सेना को आगु चलत होतो उन्को पीछु भय गयो; अऊर बादर को खम्बा भी आगु सी हट क उन्को पीछू भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","असो तरह ऊ मिस्रियों की सेना अऊर इस्राएलियों की सेना को बीच म आय गयो; अऊर बादर अऊर अन्धारो त होतो, तब भी रात ख उन्ख उजाड़ो मिलतो रह्यो पर मिस्रियों ख अन्धारो; पर ऊ रात मिस्री उन्ख पकड़न लायी जवर नहीं आय सक्यो। ");
INSERT INTO lbm_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","तब मूसा न अपनो हाथ लाल समुन्दर को ऊपर बढ़ायो; अऊर परमेश्वर न रात भर भारी पूर्व सी हवा चलायी, अऊर समुन्दर को पानी दोय हिस्सा म बट गयो, जेकोसी ओको बीच सूखी जमीन भय गयी। ");
INSERT INTO lbm_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","तब इस्राएली समुन्दर को बीच सूखी जमीन पर सी चल क गयो, अऊर पानी उन्की दायो अऊर बायो तरफ पानी की दीवार बन क खड़ो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","तब मिस्रियों न उन्को पीछा करयो। फिरौन राजा को सब रथ, घोड़ा, अऊर सवार उन्को पीछा करतो हुयो समुन्दर को बीच म चली गयो। ");
INSERT INTO lbm_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","अऊर रात को आखरी पहर म परमेश्वर न बादर अऊर आगी को खम्बा म सी मिस्रियों की सेना पर नजर रख क उन्ख घबराय दियो। ");
INSERT INTO lbm_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","अऊर ओन उन्को रथों को चक्का ख निकाल डाल्यो, जेकोसी उन्को चलनो मुश्किल भय गयो। तब मिस्री आपस म कहन लग्यो, “आवो, हम इस्राएलियों को जवर सी भाग जाये; कहालीकि परमेश्वर उन्की तरफ सी मिस्रियों को खिलाफ युद्ध कर रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","फिर परमेश्वर न मूसा सी कह्यो, “अपनो हाथ समुन्दर को ऊपर बढ़ा कि पानी मिस्रियों, अऊर उन्को रथों, अऊर सवारों पर फिर बहन लग्यो।” ");
INSERT INTO lbm_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","तब मूसा न अपनो हाथ समुन्दर को ऊपर बढ़ायो, अऊर सुबेरे होतोच का भयो कि समुन्दर फिर पहिलो को जसो होन लग्यो; अऊर मिस्री भगन लग्यो, पर परमेश्वर न उन्ख समुन्दर को बीच म डुबाय दियो। ");
INSERT INTO lbm_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","अऊर पानी को पलटनो सी, जितनो रथ अऊर घुड़सवार इस्राएलियों को पीछु समुन्दर म आयो होतो, हि सब बल्की फिरौन राजा की पूरी सेना ओको म डुब गयी, अऊर ओको म सी एक भी नहीं बच्यो। ");
INSERT INTO lbm_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","पर इस्राएली समुन्दर को बीच सूखी जमीन पर चल क समुन्दर पार होय गयो, अऊर पानी उन्को दायो अऊर बायो तरफ दीवार बन क खड़ो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","असो तरह परमेश्वर न ऊ दिन इस्राएलियों ख मिस्रियों सी बचायो; अऊर इस्राएलियों न मिस्रियों ख समुन्दर को किनार पर मरयो पड़्यो हुयो देख्यो। ");
INSERT INTO lbm_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","जब इस्राएलियों न मिस्र को निवासियों को खिलाफ करयो गयो परमेश्वर महान भुजबल को कार्य ख दिखायो, तब हि परमेश्वर को डरन लग्यो। उन्न परमेश्वर अऊर ओको दास मूसा पर विश्वास करयो। ");
INSERT INTO lbm_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मूसा अऊर इस्राएलियों न परमेश्वर को या गाना गायो। उन्न कह्यो, “मय परमेश्वर को गाना गाऊं, कहालीकि ओन महान काम करयो हय;” घोड़ा समेत सवारों ख ओन समुन्दर म फेंक दियो हय। ");
INSERT INTO lbm_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","परमेश्वर मोरी शक्ति अऊर सामर्थ हय अऊर भजन को विषय हय, अऊर उच मोरो उद्धार भी ठहरयो हय; मोरो परमेश्वर उच आय, मय ओकीच स्तुति करूं, मोरो पूर्वजों को परमेश्वर उच आय, मय ओको गुन गान करूं। ");
INSERT INTO lbm_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","परमेश्वर महान योद्धा हय; ओको नाम परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ओन फिरौन राजा को रथों अऊर सेना ख ओन समुन्दर म फेंक दियो; अऊर ओको अच्छो सी अच्छो रथों अऊर अधिकारियों ख लाल समुन्दर म डुबाय दियो। ");
INSERT INTO lbm_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहरो पानी न उन्ख झाक लियो; हि गोटा को जसो गहरो जागावों म डुब गयो। ");
INSERT INTO lbm_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे परमेश्वर, तोरो दायो हाथ महाप्रतापी भयो; हे परमेश्वर, तोरो दायो हाथ दुश्मन ख चकनाचूर कर देवय हय। ");
INSERT INTO lbm_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","तय अपनो विरोधियों ख अपनो महा प्रताप सी गिराय देवय हंय; तय अपनो गुस्सा भड़कावय, अऊर हि भूसा को समान राखड़ होय जावय हंय; ");
INSERT INTO lbm_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तोरो नथनों की श्वास सी समुन्दर को पानी जमा भय गयो, पानी ढेर बन क दिवार जसो ऊचो खड़ो भय गयो; समुन्दर को बीच म गहरो पानी जम गयो। ");
INSERT INTO lbm_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","दुश्मन न कह्यो, मय पीछा करूं अऊर पकड़ूं, अऊर लूट को माल ख बाट लेऊं, उन सी मोरो जी भर जायेंन। मय अपनी तलवार निकालूं अऊर अपनो हाथ सी उन्ख नाश कर डालूं। ");
INSERT INTO lbm_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","तय न अपनो श्वास सी हवा चलायो, तब समुन्दर न मिस्रियों ख झाक लियो; हि लोहा को जसो गहरो भयानक पानी म डुब गयो। ");
INSERT INTO lbm_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे परमेश्वर, देवतावों म तोरो बराबर कौन हय? तय त पवित्रता को वजह महान सामर्थी, अऊर अपनी स्तुति करन वालो को डर को योग्य, अऊर आश्चर्यकर्म को करन वालो हय। ");
INSERT INTO lbm_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तय न अपनो दायो हाथ बढ़ायो, अऊर धरती न उन दुस्मन ख गिटक लियो हय। ");
INSERT INTO lbm_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","अपनी सामर्थ सी तय न करुना अपनो छुड़ायो हुयो लोगों ख चलायो हय, अपनो सामर्थ सी उन्ख अपनो पवित्र निवास म लिजाय रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","देश देश को लोग सुन क काप उठेंन; पलिश्ती देश को निवासियों को डर को जसो होन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","तब एदोम को मुखिया डर जायेंन; मोआब को पहलवान थरथरायेंन; सब कनान निवासियों को हिम्मत हार जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","तोरो सामर्थ ख देख क हि लोग घबराय जायेंन; जब तक, हे परमेश्वर तोरी प्रजा को लोग जिन्ख तय न मोल लियो हय पार नहीं निकल जाये। तुम्हरो लोगों ख कुछ नहीं करतो हुयो हि एकच जागा गोटा को समान खड़ो रह जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","हे परमेश्वर, तय अपनो ऊ पहाड़ी पर, अपनो ऊ जागा पर, जेक तय न अपनो निवास जागा लायी बनायो हय, उन्ख पहुंचायेंन। उच पवित्र जागा पर, हे प्रभु, जेक तय न अपनो हाथों सी बनायो हय। ");
INSERT INTO lbm_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","परमेश्वर हमेशा हमेशा राज्य करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","यो गाना गान को वजह या हय, कि फिरौन राजा को घोड़ा, रथों अऊर सवारों सहित समुन्दर को बीच म चल्यो गयो, अऊर परमेश्वर उन्को ऊपर समुन्दर को पानी वापस ले आयो; पर इस्राएली समुन्दर को बीच सूखी जमीन पर चल क पार भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तब हारून की बहिन मरियम न जो भविष्यवक्ता होती, डफली लियो; अऊर सब बाई डफली लियो नाचतो अऊर गातो हुयो ओको पीछु भय गयी। ");
INSERT INTO lbm_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","अऊर मरियम उन्को संग या गाना गात होती, “परमेश्वर को गाना गावो, कहालीकि ऊ महान काम करयो हय;” घोड़ा सहित सवारों ख ओन समुन्दर म फेंक दियो हय। ");
INSERT INTO lbm_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","तब मूसा इस्राएलियों ख लाल समुन्दर सी आगु ले गयो, अऊर हि शूर नाम सुनसान जंगल म गयो; अऊर सुनसान जागा म तीन दिन तक जातो रह्यो, पर उन्ख पानी नहीं मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","जब हि मारा नाम को एक जागा पर पहुंच्यो, उत को पानी कड़ु होतो, ओख हि नहीं पी सक्यो; या वजह ऊ जागा को नाम मारा पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","तब हि यो कह्य क मूसा को खिलाफ बड़ बड़ान लग्यो, “हम का पीबों?” ");
INSERT INTO lbm_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","तब मूसा न परमेश्वर ख पुकारयो, अऊर परमेश्वर न ओख एक पौधा बतायो, जेक ओन पानी म डाल्यो, त ऊ पानी मीठो भय गयो। परमेश्वर न उन्को लायी एक विधि अऊर नियम बनायो, अऊर उन्की विश्वास की परीक्षा करी, ");
INSERT INTO lbm_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","अऊर कह्यो, “यदि तय अपनो परमेश्वर यहोवा को वचन तन मन सी सुनो, अऊर जो ओकी नजर म ठीक हय उच करो, अऊर ओकी आज्ञावों पर कान लगावो, अऊर ओकी सब विधियों ख मानो, त जितनो रोग मय न मिस्रियों पर भेज्यो हंय उन्म सी एक भी तोरो पर नहीं भेजूं; कहालीकि मय तुम्हरो चंगो करन वालो परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","तब इस्राएली एलीम नाम जागा म आये, जित पानी को बारा झरना अऊर सत्तर खजूर को झाड़ होतो; उत उन्न पानी को जवर डेरा डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","तब इस्राएलियों की पूरी मण्डली एलीम सी निकल क, सीन नाम को जंगल म पहुंच्यो, जो एलीम अऊर सीनै पहाड़ी को बीच म हय, मिस्र देश सी निकल्यो हुयो दोय महीना पन्द्रह दिन हो चुक्यो। ");
INSERT INTO lbm_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","सुनसान जागा म इस्राएलियों की पूरी मण्डली मूसा अऊर हारून को विरोध म बड़ बड़ान लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","अऊर इस्राएली उन्को सी कहन लग्यो, “जब हम मिस्र देश म मांस अऊर बहुत सी हान्डियों को जवर बैठ क पेट भर जेवन करत होतो, तब हम परमेश्वर को हाथ सी मार डाल्यो भी जातो त सही होतो; पर तुम हम ख या जागा म पूरो लोगों ख भूख सी मार डालन लायी मिस्र देश सी हम्ख निकाल लायो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तब परमेश्वर न मूसा सी कह्यो, “देखो, मय तुम लोगों लायी स्वर्ग सी जेवन लायी भोजन बरसाऊं; अऊर यो लोग दिन भर पूरेंन इतनोच बाहेर जाय क हर दिन को भोजन जमा करेंन, मय इन्क जाचूं कि यो मोरो बतायो अनुसार वसोच करय का नहीं। ");
INSERT INTO lbm_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","अऊर असो होयेंन कि छठवो दिन ऊ भोजन पहिलो दिनों सी दोय गुना होयेंन, छठवो दिन ख दोय दिन पूरेंन इतनो तैयार करो।” ");
INSERT INTO lbm_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","येकोलायी मूसा अऊर हारून न पूरो इस्राएलियों सी कह्यो, “शाम ख तुम जान लेवो कि जो तुम ख मिस्र देश सी निकाल लायो हय ऊ योच परमेश्वर आय, ");
INSERT INTO lbm_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","अऊर सुबेरे तुम्ख ओको महिमा को तेज दिखेंन, कहालीकि तुम जो परमेश्वर पर बुड़बुड़ावय हय ओख ऊ सुनय हय। अऊर हम का हंय कि तुम हम पर बुड़बुड़ावय हय।” ");
INSERT INTO lbm_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","फिर मूसा न कह्यो, “या तब होयेंन जब परमेश्वर शाम ख तुम्ख खान लायी मांस अऊर सुबेरे पेट भर रोटी देयेंन; कहालीकि तुम जो ओको पर बुड़बुड़ावय हय ओख ऊ सुनय हय। अऊर हम का हंय? तुम्हरो बुड़बुड़ानो हम पर नहीं परमेश्वरच पर होवय हय।” ");
INSERT INTO lbm_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","फिर मूसा न हारून सी कह्यो, “इस्राएलियों की पूरी मण्डली ख आज्ञा दे कि परमेश्वर को जवर आये, कहालीकि ओन उन्को बुड़बुड़ानो सुन्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","जब हारून इस्राएलियों की पूरी मण्डली सी बात कर रह्यो होतो, कि अचानक उन्न सुनसान जागा की तरफ नजर कर क् देख्यो, अऊर उन्ख परमेश्वर को तेज बादर म दिखायी दियो। ");
INSERT INTO lbm_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“इस्राएलियों को बुड़बुड़ानो मय न सुन्यो हय; उन्को सी कह्य दे कि हर शाम ख तुम्ख मांस अऊर सुबेरे पेट भर रोटी सी तृप्त होय जावो; अऊर तुम जान जाजो कि मयच तुम्हरो परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","तब असो भयो कि शाम ख लावा पक्षी आय क पूरी छावनी पर बैठ गयी; अऊर सुबेरे छावनी को चारयी तरफ ओस गिरी। ");
INSERT INTO lbm_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","अऊर जब ओस सूख गयी त हि का देखय हंय कि सुनसान जागा पर छोटो छोटो जमी ओस को जसो छोटो कन दिखायी दियो। ");
INSERT INTO lbm_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","यो देख क इस्राएली लोग, जो न जानत होतो कि या का चीज आय, कहालीकि हि नहीं जानत होतो कि ऊ का आय। तब मूसा न उन्को सी कह्यो, “या उच जेवन आय जेक परमेश्वर तुम्ख खान लायी देवय हय। ");
INSERT INTO lbm_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","जो आज्ञा परमेश्वर न दियो हय वा या आय : तुम ओको म सी अपनी जरूरत को अनुसार खान लायी जमा करजो, मतलब तम्बू म रहन वालो अपनो अपनो लोगों की गिनती को अनुसार, हर एक आदमी को पीछु एक एक ओमेर जमा करजो; जेको तम्बू म जितनो हो ऊ उन्कोच लायी जमा करे।” ");
INSERT INTO lbm_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","अऊर इस्राएलियों न वसोच करयो; अऊर कोयी न अधिक, अऊर कोयी न थोड़ो जमा करयो। ");
INSERT INTO lbm_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","जब उन्न ओको पायली सी नाप्यो, तब जिन्को जवर जरूरत सी जादा होतो ओको जवर अधिक नहीं, अऊर जिन्को जवर थोड़ो होतो उन्को जवर कुछ कम नहीं निकल्यो; कहालीकि हर एक न अपनो जेवन अनुसार जमा करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","फिर मूसा न उन्को सी कह्यो, “कोयी भी येको म सी कल सबेरे लायी बचाय क मत रखो।” ");
INSERT INTO lbm_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","पर कुछ लोगों न मूसा की बात नहीं मानी; अऊर ओको म सी कुछ बाकी सुबेरे लायी बचायो, त ओख म कीड़ा पड़ गयो अऊर ऊ बास करन लग्यो; तब मूसा उन लोगों पर गुस्सा भयो ");
INSERT INTO lbm_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","हि हर दिन सुबेरे अपनी जरूरत को अनुसार जेवन लायी मन्ना जमा करत होतो, अऊर जब सूर्य की कड़ी तपन होनो पर ऊ पिघल जात होती। ");
INSERT INTO lbm_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","फिर असो भयो कि छठवो दिन उन्न दोय गुना, मतलब हर आदमी को पीछु दोय दोय पायली मन्ना जमा कर लियो, तब इस्राएली मण्डली को सब मुखिया न आय क मूसा ख बतायो। ");
INSERT INTO lbm_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","तब मूसा न उन्को सी कह्यो, “या वा बात आय जो परमेश्वर न असो कह्यो कि, कहालीकि कल परम आराम, मतलब परमेश्वर लायी पवित्रता को आराम दिन हय, अज तुम्ख जितनो पकानो हय, उतनो पकावों, जितनो उबालनो हय उतनो उबालो, अऊर येको म सी जितनो बचेंन ओख सबेरे लायी रखो।” ");
INSERT INTO lbm_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","जब उन्न मूसा की आज्ञा को अनुसार सुबेरे तक रख्यो, तब नहीं त ऊ बासो भयो, अऊर नहीं ओको म कीड़ा भयो। ");
INSERT INTO lbm_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","तब मूसा न कह्यो, “अज परमेश्वर को आराम दिन हय; येकोलायी तुम उच खावो, अज मन्ना मैदान म नहीं मिलेंन। ");
INSERT INTO lbm_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","छय दिन त तुम ओख जमा करजो; पर सातवों दिन आराम को दिन हय, ओको म ऊ नहीं मिलेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","तब भी लोगों म सी कोयी कोयी सातवों दिन भी जमा करन बाहेर गयो, पर उन्को कुछ नहीं मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब परमेश्वर न मूसा सी कह्यो, “तुम लोग मोरी आज्ञावों अऊर नियमों ख कब तक नहीं मानो? ");
INSERT INTO lbm_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","परमेश्वर न जो तुम ख आराम को दिन दियो हय, योच वजह ऊ छठवो दिन ख दोय दिन को जेवन तुम्ख देवय हय; येकोलायी तुम अपनो अपनो जागा पर बैठे रहना, सातवों दिन कोयी अपनो जागा सी बाहेर नहीं जावो।” ");
INSERT INTO lbm_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","येकोलायी लोगों न सातवों दिन आराम करयो। ");
INSERT INTO lbm_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएल लोगों न उच चीज को नाम मन्ना रख्यो, समार को दाना जसो सफेद होतो। अऊर ओको स्वाद शहेद सी बन्यो पुवा को जसो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","फिर मूसा न कह्यो, “परमेश्वर न आज्ञा दियो कि ऊ यो आय कि येख म सी ओमेर भर ‘मन्ना’ अपनो वंश की पीढ़ी पीढ़ी लायी रख छोड़ो, जेकोसी हि जान कि परमेश्वर हम्ख मिस्र देश सी निकाल क सुनसान जागा म कसी रोटी खिलावत होतो।” ");
INSERT INTO lbm_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","तब मूसा न हारून सी कह्यो, “एक बर्तन ले क ओख म ओमेर भर मन्ना ले क ओख परमेश्वर को आगु रख देवो कि ऊ तुम्हरो पीढ़ियों लायी रख्यो रहें।” ");
INSERT INTO lbm_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","जसो आज्ञा परमेश्वर न मूसा ख दियो होती, ओको को अनुसार हारून न बर्तन ख साक्षी को सन्दूक को आगु रख दियो कि ऊ उत रख्यो रहो। ");
INSERT INTO lbm_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएलियों लोग जब ऊ देश म नहीं पहुंच्यो तब तक, मतलब लोगों न चालीस साल तक मन्ना खातो रह्यो; हि जब तक कनान देश की सीमा पर नहीं पहुंच्यो तब तक मन्ना खात रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","एक ओमेर मतलब पायली त एपा को दसवा हिस्सा आय। ");
INSERT INTO lbm_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","फिर इस्राएलियों की पूरी मण्डली सीन नाम को सुनसान जागा सी निकली, अऊर जागा जागा म डेरा डालतो हुयो आगु बढ़ी अऊर परमेश्वर को आज्ञा सी सब रपीदीम की जागा म अपनो डेरा डाल्यो; उत उन लोगों लायी पीवन को पानी नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","येकोलायी हि मूसा सी वाद विवाद करन लग्यो, “हम्ख पीवन लायी पानी देवो।” मूसा न उन्को सी कह्यो, “तुम लोग मोरो सी कहाली वाद विवाद करय हय? अऊर परमेश्वर की परीक्षा कहाली करय हय?” ");
INSERT INTO lbm_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","फिर उत लोगों ख पानी कि बहुत प्यास लगी, तब हि या कह्य क मूसा पर कुड़कुड़ान लग्यो, “तय हम्ख बाल-बच्चां अऊर जनावरों समेत प्यासो मार डालन लायी मिस्र देश सी कहाली लायो हय?” ");
INSERT INTO lbm_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","तब मूसा न परमेश्वर सी बिनती करी, अऊर कह्यो, “इन लोगों को संग का करूं? हि सब मोर पर गोटा सी मारन लायी तैयार हंय।” ");
INSERT INTO lbm_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","परमेश्वर न मूसा सी कह्यो, “इस्राएलियों को बुजूर्ग मुखिया म सी कुछ ख अपनो संग ले क लोगों को आगु आगु बढ़, तय अपनो हाथ म उच लाठी ख ले क जाजो जेकोसी तय न नील नदी पर मारयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","मय तोरो आगु चल क होरेब पहाड़ी की एक चट्टान पर खड़ो रहूं; अऊर तय उच चट्टान पर लाठी मारजो, तब ओको म सी पानी निकलेंन, जेकोसी लोग पानी पी सकेंन।” तब मूसा न इस्राएल को मुखिया लोगों को आगु वसोच करयो। ");
INSERT INTO lbm_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","अऊर मूसा न ऊ जागा को नाम मस्सा अऊर मरीबा रख्यो, कहालीकि इस्राएलियों न उत मूसा सी वाद विवाद करयो होतो, अऊर परमेश्वर की परीक्षा करी कि “का परमेश्वर हमरो बिच हय यां नहीं?” ");
INSERT INTO lbm_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","तब अमालेकी जाति को लोग आय क रपीदीम जागा म इस्राएलियों सी लड़न लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","तब मूसा न यहोशू सी कह्यो, “हमरो लायी कुछ आदमियों ख चुन ले कि बाहेर जाय क अमालेकियों सी लड़े; अऊर मय कल परमेश्वर की लाठी हाथ म पकड़ क पहाड़ी की सेंडी पर खड़ो रहूं।” ");
INSERT INTO lbm_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","मूसा की या आज्ञा को अनुसार यहोशू अमालेकियों सी लड़न गयो; अऊर मूसा, हारून, अऊर हूर पहाड़ी की सेंडी पर चढ़ गयो। ");
INSERT INTO lbm_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","जब तक मूसा अपनो हाथ उठायो रहत होतो तब तक त इस्राएल को लोग लड़ाई जीतत होतो; पर जब जब ऊ ओख नीचो करतो तब तब अमालेक जीतत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","पर जब मूसा को हाथ थक गयो, तब उन्न एक गोटा ले क मूसा को नीचे रख दियो, अऊर ऊ ओख पर बैठ गयो, अऊर हारून अऊर हूर उन्को हाथ सम्भालतो रह्यो; एक दायो बाजू अऊर दूसरो बायो बाजू अऊर ओको हाथ सूरज डुबन तक उठ्यो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","अऊर यहोशू न अपनो तलवार को दम सी अमालेकी जाति ख हराय दियो। ");
INSERT INTO lbm_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तब परमेश्वर न मूसा सी कह्यो, “लड़ाई म जीत की बात यादगार लायी किताब म लिख लेवो अऊर यहोशू ख बताय देवो कि मय आसमान को नीचो सी अमालेक को यादगार चिन्ह पूरो रीति सी मिटाय डालूं।” ");
INSERT INTO lbm_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","तब मूसा न एक वेदी बनाय क ओको नाम “यहोवा निस्सी रख्यो;” ");
INSERT INTO lbm_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","मूसा न कह्यो, “परमेश्वर न कसम खायी हय, कि परमेश्वर अमालेकियों सी पीढ़ियों तक लड़ाई करतो रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","जब मूसा को ससरो यित्रो जो मिद्यान देश को याजक न उन कामों को बारे म सुन्यो जो परमेश्वर न मूसा अऊर अपनो इस्राएल को लोगों लायी कसो इस्राएलियों ख मिस्र देश सी बाहेर निकाल्यो, ");
INSERT INTO lbm_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","तब मूसा को ससरो यित्रो अऊर मूसा की पत्नी सिप्पोरा ख, पहिलेच ओको मायको भेज दियो होतो, ");
INSERT INTO lbm_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","अऊर ओको दोयी टुरा ख भी संग लायो; इन म सी एक टुरा को नाम यो कह्य क गेर्शोम रख्यो होतो, “मय दूसरो देश म परदेशी हय।” ");
INSERT INTO lbm_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","अऊर दूसरो को नाम एलीएजेर रख्यो, “मोरो बाप को परमेश्वर न मोरी मदत कर क् मोख मिस्र को फिरौन राजा की तलवार सी बचायो।” ");
INSERT INTO lbm_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मूसा को ससरो यित्रो, मूसा की पत्नी अऊर ओको दोय टुरा ख, संग ले क मूसा को जवर सुनसान जागा म गयो, जित परमेश्वर को पहाड़ी को जवर ओको डेरा होतो। ");
INSERT INTO lbm_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","अऊर ओन मूसा को जवर अपनी बात भेजी, “मय तोरो ससरो यित्रो आय, अऊर दोयी टुरावों सहित तोरी पत्नी ख तोरो जवर लाय रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","येकोलायी तब मूसा अपनो ससरो सी मुलाखात करन लायी निकल्यो, अऊर ओख झुक क सत्कार करयो अऊर चुम्यो; अऊर हि एक दूसरो को कुशल मंगल पूछतो हुयो डेरा पर आय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मूसा न अपनो ससरो यित्रो ख हर उन सब कार्य को वर्णन सुनायो जो परमेश्वर न इस्राएलियों की मदत लायी फिरौन अऊर मिस्रियों को संग जो करयो होतो, अऊर इस्राएलियों न यात्रा म जो कष्ट उठायो ओको सी परमेश्वर उन्ख कसो छुड़ायो हय। ");
INSERT INTO lbm_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","तब यित्रो न वा पूरी भलायी को वजह जो परमेश्वर न इस्राएलियों को संग करी होतो, की उन्ख मिस्रियों को हाथ सी छुड़ायो होतो, खुश होय क कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","यित्रो न कह्यो “धन्य हय परमेश्वर, जेन तुम ख फिरौन अऊर मिस्रियों को वश सी छुड़ायो, जेन तुम लोगों ख गुलामी सी मिस्रियों को हाथ सी छुड़ायो हय। ");
INSERT INTO lbm_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मय न जान लियो हय कि यहोवा सब देवतावों सी बड़ो हय; बल्की ओको बारे म भी जेकोसी उन्न इस्राएलियों को संग अहंकारपूर्न व्यवहार करयो होतो।” ");
INSERT INTO lbm_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","तब मूसा को ससरो यित्रो न परमेश्वर लायी होमबलि अऊर मेलबलि चढ़ाये, अऊर हारून इस्राएलियों को सब बुजूर्ग समेत मूसा को ससरो यित्रो को संग परमेश्वर को आगु जेवन करन ख आयो। ");
INSERT INTO lbm_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दूसरो दिन मूसा लोगों को न्याय करन ख बैठ्यो, अऊर सबेरे सी शाम तक लोग मूसा को आस पास खड़े रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","जब मूसा को ससरो न उन लोगों को न्याय करतो देख्यो तब उन्को सी पुच्छ्यो “यो का काम हय जो तुम लोगों लायी करय हय? का वजह हय कि तुम अकेलो बैठ्यो रह्य हय, अऊर लोग सबेरे सी शाम तक तोरो आस पास खड़ो रह्य हंय?” ");
INSERT INTO lbm_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मूसा न अपनो ससरो सी कह्यो, “येको वजह यो हय कि लोग मोरो जवर परमेश्वर की इच्छा सिखन आवय हंय। ");
INSERT INTO lbm_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","जब जब उन्को कोयी वाद विवाद होवय हय तब तब हि मोरो जवर आवय हंय, अऊर मय उन्को बिच न्याय करू हय, अऊर परमेश्वर की विधि अऊर व्यवस्था उन्ख समझाऊ हय।” ");
INSERT INTO lbm_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मूसा को ससरो न ओको सी कह्यो, “जो काम तय करय हय, ऊ ठीक नहाय। ");
INSERT INTO lbm_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","येकोसी तय का, बल्की हि लोग भी जो तोरो संग हंय निश्चय थक जायेंन, कहालीकि यो काम तोरो लायी बहुत भारी हय; तय येख अकेलो नहीं कर सकय। ");
INSERT INTO lbm_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","येकोलायी अब मोरी सुन ले, मय तोख सम्मति देऊ हय, परमेश्वर तोरो संग रहेंन! तय इन लोगों लायी परमेश्वर को सामने जायो कर, अऊर इन्को मुकद्दमा ख परमेश्वर को जवर तय पहुंचाय दियो कर। ");
INSERT INTO lbm_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","इन्क विधि अऊर व्यवस्था प्रगट कर क्, जो रस्ता पर इन्क चलनो, अऊर जो जो काम इन ख करनो हय, ऊ इन ख बता दियो कर। ");
INSERT INTO lbm_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","फिर तय इन सब इस्राएली लोगों म सी असो आदमियों ख चुन ले, जो गुनी अऊर परमेश्वर को डर मानन वालो, सच्चो, अऊर अन्याय को लाभ सी घृना करन वालो होना; अऊर इन ख हजार-हजार, सौ-सौ, पचास-पचास, अऊर दस-दस लोगों पर मुखिया बनाय दे। ");
INSERT INTO lbm_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","अऊर हि सब समय इन लोगों को न्याय करतो रहे; अऊर सब बड़ो बड़ो मुकद्दमा ख त तोरो जवर लायो करे; तब तोरो बोझ हल्को होयेंन, कहालीकि यो बोझ ख हि भी तोरो संग उठायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","यदि तय यो उपाय करजो, अऊर परमेश्वर तोख असी आज्ञा दे, त तय ठहर सकजो, अऊर हि सब लोग अपनो जागा म शान्ति सी पहुंच सकेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","अपनो ससरो की या बात मान क मूसा न ओको सब वचनों को अनुसार करयो। ");
INSERT INTO lbm_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","मूसा न सब इस्राएल म सी बुद्धि मान आदमियों ख चुन क उन्ख हजार-हजार, सौ-सौ, पचास-पचास, दस-दस लोगों को ऊपर मुखिया ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","अऊर हि सब लोगों को न्याय करन लग्यो; जो विवाद कठिन होतो ओख हि मूसा को जवर लावत होतो, अऊर सब छोटो विवाद को न्याय हि खुदच करत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","तब मूसा न अपनो ससरो ख बिदा करयो, अऊर ऊ अपनो देश वापस जान लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्राएली लोग मिस्र देश सी निकलनो को तीन महीना को बाद सीनै को सुनसान जागा म आयो। ");
INSERT INTO lbm_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","अऊर जब हि रपीदीम सी निकल क सीनै को सुनसान जागा म आये, तब उतच होरेब मतलब सीनै पहाड़ी को तरफ इस्राएलियों न डेरा डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","अऊर तब मूसा पहाड़ी पर परमेश्वर सी मिलन चढ़ गयो, अऊर उत सी परमेश्वर न ओख बोल्यो, “याकूब को घरानों सी असो कहो, अऊर इस्राएलियों लोगों ख मोरो यो वचन सुना, ");
INSERT INTO lbm_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘तुम लोगों न देख्यो हय कि मय न मिस्रियों सी का का करयो; जसो गरूड़ पक्षी को पंखा पर चढ़ाय क अपनो जवर लायो। ");
INSERT INTO lbm_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","येकोलायी अब यदि तुम मोरी आज्ञा मानजो, अऊर मोरी वाचा को पालन करजो, त सब लोगों म सी तुमच मोरो निजी धन ठहरेंन; पूरो धरती त मोरीच आय। ");
INSERT INTO lbm_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","अऊर तुम मोरी नजर म याजकों को राज्य अऊर पवित्र राष्ट्र ठहरेंन।’ मूसा जो बात तोख इस्राएलियों सी कहनो हंय हि योच आय।” ");
INSERT INTO lbm_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","तब मूसा न आय क इस्राएली लोगों को बुजूर्गों ख बुलायो, अऊर या सब बात, जेक कहन की आज्ञा परमेश्वर न ओख दियो होतो, उन्को समझाय दियो। ");
INSERT INTO lbm_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","अऊर सब लोग एक संग उत्तर दियो, “जो कुछ परमेश्वर न कह्यो हय ऊ सब हम करबोंन।” लोगों की या बात मूसा न परमेश्वर ख सुनायी। ");
INSERT INTO lbm_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","तब परमेश्वर न मूसा सी कह्यो, “सुन, मय कारो बादर अन्धारो म सी होय क तोरो जवर आऊ हय, येकोलायी कि जब मय तोरो सी बात करूं तब हि लोग सुने, अऊर हमेशा तोरो पर विश्वास करे।” अऊर मूसा न परमेश्वर सी लोगों की बात बतायी। ");
INSERT INTO lbm_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","तब परमेश्वर न मूसा सी कह्यो, “लोगों को जवर जावो अऊर उन्ख अज अऊर कल पवित्र करजो, अऊर हि अपनो कपड़ा धोय ले, ");
INSERT INTO lbm_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","अऊर हि तीसरो दिन तक तैयार होय जाये; कहालीकि तीसरो दिन परमेश्वर सब लोगों को आखी को देखतो सीनै पहाड़ी पर उतरेंन। ");
INSERT INTO lbm_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","अऊर तय लोगों लायी चारयी तरफ एक सीमा रेसा खीच देजो, अऊर उन्को सी कह्यजो, ‘तुम सावधान रहजो कि पहाड़ी पर न चढ़जो अऊर ओकी सीमा ख भी नहीं छूयजो; अऊर जो कोयी पहाड़ी ख छूयेंन ऊ निश्चय मार डाल्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ओख कोयी हाथ सी नहीं छुये; जो छूयेंन ओख गोटा सी मारयो जायेंन, या ओख तीरों सी छेद्यो जायेंन; चाहे जनावर होय चाहे आदमी, ऊ जीन्दो नहीं बचेंन।’ जब मेंढा को सींग को नरसिंगा वालो शब्द तक सुनायी दे, तब लोग पहाड़ी पर चढ़ेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","तब मूसा पहाड़ी सी उतर क लोगों को जवर आय क उन्ख पवित्र करयो, अऊर लोगों न अपनो कपड़ा धोयो। ");
INSERT INTO lbm_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","अऊर मूसा न लोगों सी कह्यो, “तीसरो दिन तक तैयार होय जावो, आदमियों न बाईयों सी सहवास नहीं करे।” ");
INSERT INTO lbm_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","जब तीसरो दिन आयो तब सुबेरे होतोच बादर गर्जन अऊर बिजली चमकन लग्यो, अऊर पहाड़ी पर कारो ढ़ग छाय गयो, फिर तुरही को बड़ो भारी आवाज भयो, अऊर डेरा म जितनो लोग होतो सब डर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","तब मूसा लोगों ख परमेश्वर सी मिलान लायी डेरा सी निकाल लायो, अऊर हि पहाड़ी को नीचे खड़ो भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","अऊर परमेश्वर जो आगी म होय क सीनै पहाड़ी पर उतरो होतो, या वजह पूरो पहाड़ी धुवा सी भर गयो; अऊर ओको धुवा भट्टा जसो उठ रह्यो होतो, अऊर पूरो पहाड़ी बहुत काप रह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","फिर जब नरसिंगा को आवाज तेज बढ़तो, गयो, तब मूसा बोल्यो, अऊर परमेश्वर न बादर गर्जन की आवाज जसो ओको उत्तर दियो। ");
INSERT INTO lbm_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","अऊर परमेश्वर सीनै पहाड़ी की सेंडी पर सी खल्लो उतरयो; अऊर मूसा ख पहाड़ी की सेंडी पर बुलायो, अऊर मूसा ऊपर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","तब परमेश्वर न मूसा सी कह्यो, “नीचे उतर क् लोगों ख चेतावनी दे, कहीं असो नहीं हय कि हि बाड़ा तोड़ क परमेश्वर को जवर देखन ख घुसयो, अऊर उन्म सी बहुत सो नाश होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","अऊर याजक जो परमेश्वर को जवर आन वालो हंय हि भी अपनो आप ख पवित्र करेंन, कहीं असो नहीं होय कि मय उन ख सजा दे देऊ।” ");
INSERT INTO lbm_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मूसा न परमेश्वर सी कह्यो, “हि लोग सीनै पहाड़ी पर नहीं चढ़ सकय; तुम न त खुद हम ख यो कह्य क चितायो कि पहाड़ी को चारयी तरफ बाड़ा बान्ध क ओख पवित्र रखो।” ");
INSERT INTO lbm_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","परमेश्वर न मूसा सी कह्यो, “तय जा, अऊर हारून ख ले आव। पर याजक अऊर साधारन लोग परमेश्वर को बाड़ा तोड़न चढ़ क आये, असो नहीं होय कि मय उन ख सजा देऊं।” ");
INSERT INTO lbm_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","या बात मूसा पहाड़ी सी उतर क् लोगों ख सुनायी। ");
INSERT INTO lbm_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","तब परमेश्वर न यो सब वचन कह्यो : ");
INSERT INTO lbm_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“मय तोरो परमेश्वर यहोवा आय, जो तोख मिस्र देश की, गुलामी सी बाहेर निकाल्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“तुम मोख छोड़ क कोयी दूसरो ख ईश्वर कर क् नहीं मानजो। ");
INSERT INTO lbm_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“तय अपनो लायी कोयी मूर्ति नहीं बनावो, न कोयी की मूर्ती बनावो, जो आसमान म, यां धरती पर, या धरती को खल्लो पानी म हय। ");
INSERT INTO lbm_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","तय उन्को दण्डवत नहीं करजो, अऊर नहीं उन्की उपासना करजो; कहालीकि मय तोरो परमेश्वर यहोवा जलन रखन वालो परमेश्वर आय, अऊर जो मोरो सी दुश्मनी रखय हंय, उन्को टुरा, नाती, अऊर पन्ती ख भी पीढ़ी को अधर्म को दण्ड देऊ हय, ");
INSERT INTO lbm_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","अऊर जो मोरो सी प्रेम रखय अऊर मोरी आज्ञावों ख मानय हंय, उन हजार पीढ़ियों पर दया करू हय। ");
INSERT INTO lbm_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“तय अपनो परमेश्वर को नाम व्यर्थ नहीं लेजो; कहालीकि जो परमेश्वर को नाम बिन काम को लेवय ऊ ओख निर्दोष नहीं ठहरायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“तुम आराम दिन ख पवित्र मानन लायी याद रखजो। ");
INSERT INTO lbm_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","छय दिन त तुम मेहनत करजो, अपनो सब काम-काज करजो, ");
INSERT INTO lbm_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","पर सातवों दिन तोरो परमेश्वर लायी आराम दिन हय। उन्म नहीं त तुम कोयी भी काम-काज करजो, अऊर नहीं तोरो टुरा-टुरी, सेवक-सेविका, जनावर, अऊर कोयी परदेशी जो तोरो फाटकों को अन्दर रहन वालो हो। ");
INSERT INTO lbm_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","कहालीकि छय, दिन म परमेश्वर न आसमान, अऊर धरती, अऊर समुन्दर, अऊर जो कुछ उन्म हंय, सब ख बनायो, अऊर सातवों दिन आराम करयो; या वजह परमेश्वर न आराम दिन ख आशीष दियो अऊर पवित्र ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“तुम अपनो माय-बाप को आदर करजो, जेकोसी जो देश तोरो परमेश्वर तोख देवय हय ओख म तुम बहुत दिन तक रहनो पाये। ");
INSERT INTO lbm_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“तय खून नहीं करजो। ");
INSERT INTO lbm_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“तुम व्यभिचार नहीं करजो। ");
INSERT INTO lbm_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“तुम चोरी नहीं करजो। ");
INSERT INTO lbm_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“तुम कोयी को खिलाफ झूठी गवाही नहीं देजो। ");
INSERT INTO lbm_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“तुम कोयी को घर को लालच नहीं करजो; नहीं त कोयी की बाई को लालच करजो, अऊर नहीं कोयी को दास-दासी यां बईल-गधा को, नहीं कोयी की कोयी चीज को लालच करजो।” ");
INSERT INTO lbm_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","सब लोग गर्जन अऊर बिजली अऊर तुरही को आवाज सुनय, अऊर धुवा उठतो हुयो पहाड़ी ख देखतो रह्यो, तब डर क कापतो हुयो दूर खड़ो होय गयो; ");
INSERT INTO lbm_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","अऊर हि मूसा सी कहन लग्यो, “तयच हम सी बात कर, हम तोरो सी सुनबों; पर परमेश्वर ख हम सी बात मत करन दे, असो नहीं हो कि हम मर जाबोंन।” ");
INSERT INTO lbm_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मूसा न लोगों सी कह्यो, “डरो मत; कहालीकि परमेश्वर येकोलायी आयो हय कि तुम्हरी परीक्षा करे, अऊर ओको डर तुम्हरो मन म बन्यो रहें कि तुम पाप नहीं करो।” ");
INSERT INTO lbm_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","पर हि लोग दूरच खड़ो रह्यो पर मूसा घोर अन्धकार को जवर गयो जित परमेश्वर होतो। ");
INSERT INTO lbm_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तब परमेश्वर न मूसा सी कह्यो, “तुम इस्राएलियों ख यो वचन सुनाव, तुम न खुदच देख्यो हय कि मय न स्वर्ग सी तुम सी बाते करी हंय। ");
INSERT INTO lbm_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","तुम मोरो अलावा कोयी ख सामिल मत करजो, मतलब अपनो लायी चांदी अऊर सोना सी देवतावों की मूर्तियां ख मत बनाजो। ");
INSERT INTO lbm_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","मोरो लायी माटी की एक वेदी बनाजो, अऊर अपनी मेंढी-शेरी अऊर गाय-बईलों को होमबलि अऊर मेलबलि ख ओको पर चढ़ाजो; जहां जहां मय अपनो नाम को याद कराऊं वहां वहां मय आय क तुम्ख आशीष देऊं। ");
INSERT INTO lbm_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","अऊर यदि तुम मोरो लायी गोटा सी वेदी बनाजो, गोटा म अवजार सी छेदायी कर क् नहीं बनावो; कहालीकि तुम न ओख पर हथियार लगानो सी अशुद्ध होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","अऊर मोरी वेदी पर सीढ़ी लगाय क मत चढ़जो, कुछ असो नहीं हो कि तोरो शरीर को नंगोपन ओको पर दिख पड़ेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“फिर जो नियम तोख उन्को समझानो हंय हि यो आय, ");
INSERT INTO lbm_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","जब तुम कोयी इब्री दास लेय ले, तब ऊ छय साल तक सेवा करतो रहेंन, पर सातवों साल बिना कीमत चुकाये स्वतंत्र होय क जाय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","यदि ऊ बिना शादी को आयो हय, त ऊ बिना शादी कोच चली जाये; अऊर पत्नी संग आयो हय, त पत्नी को संग चली जाये। ");
INSERT INTO lbm_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","यदि ओको मालिक न ओको लायी पत्नी बनाय दियो हय, अऊर ओको सी ओको संतान भयी हय, त ओकी पत्नी अऊर बच्चा ओको स्वामी कोच रहेंन, अऊर ऊ अकेलो जाय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","पर यदि ऊ दास दृढ़ता सी कहेंन, ‘मय अपनो स्वामी, अऊर अपनी पत्नी, अऊर बच्चा सी प्रेम रखू हय, येकोलायी मय स्वतंत्र होय क नहीं जाऊं;’ ");
INSERT INTO lbm_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","त ओको मालिक ओख न्याय करन वालो को आगु लिजाय क; फिर ओख दरवाजा को चौखट जवर लिजाय क बारीक सुजा सी ओको कान छेदेंन; तब ऊ अपनो मालिक की हमेशा सेवा करेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“यदि कोयी अपनी टुरी ख दासी होन लायी बेच डाले, त ऊ दासी होन को वजह आदमी-दासों को जसो स्वतंत्र होय क बाहेर नहीं जाय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","यदि वा अपनो मालिक ओख अपनी पत्नी बनाये, अऊर फिर ओख सी खुश नहीं रह्य, त वापस ओको बाप ख दाम सी छुड़ायी जान दे; पर ओको विश्वास घात करन को बाद ओख विदेशी लोगों को हाथ बेचन को ओको अधिकार नहीं रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","यदि ओन अपनो बेटा लायी चुन्यो हय, त बेटी जसो व्यवहार करो। ");
INSERT INTO lbm_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","यदि ऊ दूसरी सी बिहाव कर ले, तब ऊ पहिली पत्नी ख खाना, कपड़ा, की कमी नहीं होन दे, अऊर कोयी सुख सी दूर नहीं रखे। ");
INSERT INTO lbm_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","अऊर यदि ऊ इन तीन बातों म कमी करेंन, त वा बाई बिना दाम चुकायो स्वतंत्र होय जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“जो कोयी आदमी ख असो मारयो कि ऊ मर जाये, त ऊ भी निश्चय ओख मार डाल्यो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","यदि ओकी मारन की मंसा नहीं होती पर अचानक सी परमेश्वर की इच्छा सी ऊ ओको हाथ सी मर गयो, त असो मारन वालो को भगन लायी मय एक जागा ठहराऊं जित ऊ भग जाये। ");
INSERT INTO lbm_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","पर यदि कोयी जान बूझ क कोयी ख छल सी मार डाले, त ओको मार डालन लायी मोरी वेदी को जवर सी भी अलग ले जाजो।” ");
INSERT INTO lbm_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“जो अपनो माय-बाप ख मारय हय, ओख निश्चय मार डाल्यो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“जो कोयी आदमी ख अपहरन करय, ओख बिकय यां ओको जवर मिलय त ऊ भी निश्चय मार डाल्यो जाये।” ");
INSERT INTO lbm_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“जो कोयी अपनो माय-बाप ख श्राप दे ऊ भी निश्चय मार डाल्यो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“यदि आदमी झगड़य हय, अऊर एक दूसरो ख गोटा या घूसा सी असो मारे कि ऊ मरयो नहीं पर बीस्तर पर पड़्यो रहो, ");
INSERT INTO lbm_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","त जब उठ क फिर लाठी को सहारा चलन फिरन लगेंन, तब ऊ मारन वालो निर्दोष ठहरेंन; उच दशा म ऊ ओको पड़्यो रहन को समय की हानि भर दे, अऊर ओख ठीक भी कराय देंन।” ");
INSERT INTO lbm_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“यदि कोयी अपनो दास यां दासी ख लाठी सी असो मारयो कि ऊ ओको मारन सी मर जाये, तब ओख निश्चय सजा दियो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","पर यदि ऊ एक दोय दिन जीन्दो रहेंन, त ओको स्वामी ख सजा नहीं दियो जाये; कहालीकि ऊ दास ओको धन हय। ");
INSERT INTO lbm_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“यदि कोयी आदमी मार पीट करतो समय ओको धक्का कोयी गर्भवती बाई ख लगन सी ओको गर्भ गिर जाये, पर अऊर कुछ नुकसान नहीं होय, त मारन वालो सी ऊ बाई को पति जो भी मांग करय उतनो दण्ड की रकम दियो जाये जितनो पन्च निश्चित करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","पर यदि मार-पीट म कुछ हानि पहुंच्यो, त जीव को बदला जीव देनो पड़ेंन, ");
INSERT INTO lbm_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","अऊर तुम आंखी को बदला आंखी को, अऊर दात को बदला दात को, अऊर हाथ को बदला हाथ, अऊर पाय को बदला पाय लेवो, ");
INSERT INTO lbm_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","अऊर दाग को बदला दाग, अऊर घाव को बदला घाव, अऊर मार को बदला मार की सजा आय।” ");
INSERT INTO lbm_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“जब कोयी अपनो दास यां दासी की आंखी पर असो मारयो कि फूट जाये, त ऊ ओकी आंखी को बदला ओख स्वतंत्र कर क् जान देजो। ");
INSERT INTO lbm_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","अऊर यदि ऊ अपनो दास या दासी ख मार क् ओको दात तोड़ डालेंन, त ऊ ओको दात को बदला ओख स्वतंत्र कर क् जान देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“यदि बईल कोयी आदमी यां बाई ख असो सींग मारे कि ऊ मर जाये, त ऊ बईल निश्चय गोटा सी मार डाल्यो जाये, अऊर ओको मांस खायो नहीं जाये; पर बईल को मालिक निर्दोष ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","पर यदि बईल कि पहिलो सीच सींग मारन की आदत पड़्यो हय, अऊर ओको मालिक न पहिलो सी बतावन को बाद भी ओख नहीं बान्ध्यो हय, अऊर ऊ कोयी आदमी यां बाई ख मार डालय, तब त बईल ख गोटा सी मार डाल्यो जाये, अऊर ओको मालिक भी मारयो डाल्यो जाये।” ");
INSERT INTO lbm_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","पर बदला म धन दे क बईल को मालिक ख छोड़ सकय हय। ओख उतनोच धन देनो पड़ेंन। जितनो जान की छुड़ौती लायी ठहरायो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","यदि चाहे बईल न कोयी टुरा यां टुरी ख मारयो हय, तब भी येको नियम को अनुसार ओको मालिक को संग व्यवहार करयो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","यदि बईल न कोयी दास यां दासी ख सींग मारयो हय, त बईल को मालिक ऊ दास को मालिक ख चांदी को तीस सिक्का दे, अऊर बईल ख गोटा मार कर मार डालो। ");
INSERT INTO lbm_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“यदि कोयी आदमी न गड्डा खोल क या खोद क ओख नहीं झाक्यो, अऊर ओख म कोयी को बईल यां गधा गिर जाये, ");
INSERT INTO lbm_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","त जेको ऊ गड्डा आय ऊ ओको नुकसान ख भर दे; ऊ जनावर को मालिक ख ओको कीमत भर देंन, अऊर मरयो हुयो जनावर गड्डा वालो को होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","यदि कोयी को बईल कोयी दूसरों को बईल ख असो मारे कि ऊ मर जाये, त हि दोयी आदमी जीन्दो बईल ख बेच क ओकी कीमत आपस म अरधो अरधो बाट ले; अऊर मरयो हुयो पशु को शव ख भी वसोच बाट ले। ");
INSERT INTO lbm_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","यदि यो मालूम पड़े कि ऊ बईल की पहिलो सी सींग मारन की आदत होती, पर ओको मालिक न ओख बान्ध क् नहीं रख्यो, त निश्चय ऊ बईल को बदला बईल भर दे, पर मरयो शव ओकोच ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“यदि कोयी आदमी गाय-बईल, यां मेंढी-शेरी चुराय क काटय यां बिकय, त ऊ गाय-बईल को बदला पाच गाय-बईल, अऊर मेंढी-शेरी को बदला चार मेंढी-शेरी भरनो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","यदि चोर चोरी करतो पकड़ायो, अऊर ओख पर असी मार पड़ी कि ऊ मर जाये, त ओको खून को दोष नहीं लगे। ");
INSERT INTO lbm_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","यदि सूरज निकल्यो, त ओको खून को दोष लगेन; जरूर हय कि ऊ नुकसान ख भर दे, अऊर यदि ओको जवर कुछ नहाय हय, त ऊ यो चोरी को वजह बेच दियो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","यदि चोरयो हुयो बईल, यां गधा, यां मेंढी, यां शेरी ओको हाथ म जीन्दो मिल्यो, त ऊ ओको दोय गुना भर दे।” ");
INSERT INTO lbm_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“यदि कोयी अपनो पशु सी कोयी को खेत यां अंगूर की बाड़ी चराये, मतलब अपनो पशु ख असो छोड़ दे कि ऊ दूसरो को खेत ख चराय ले, त ऊ अपनो खेत की अऊर अपनी अंगूर की बाड़ी की अच्छी सी अच्छी फसल म सी ओको नुकसान ख भर दे।” ");
INSERT INTO lbm_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“यदि कोयी आगी जलाये, अऊर वहां काटा म लग जायेंन, अऊर फूलों को ढेर यां अनाज यां खड़ो खेत जर जायेंन, त जेन आगी जलायी होना ऊ नुकसान ख जरूर भर दे।” ");
INSERT INTO lbm_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“यदि कोयी दूसरो को जवर रुपया यां सामान की धरोहर रख दे, अऊर ऊ ओको घर सी चोरी जायेंन, त यदि चोर पकड़्यो जाये त दो गुना भर देनो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","यदि चोर नहीं पकड़्यो जाये, त घर को मालिक ख परमेश्वर को जवर लायो जाये कि निश्चय होय जाये कि ओन अपनो भाऊ-बन्धु की सम्पत्ति पर हाथ लगायो हय यां नहीं।” ");
INSERT INTO lbm_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“चाहे बईल, चाहे गधा, चाहे मेंढी यां शेरी, चाहे कपड़ा, कोयी तरह की असी घुमी हुयी चीज को बारे म दोष कहाली नहीं लगायो जाये, जेख दोय जन अपनी अपनी कह्य हय, त दोयी को मुकद्दमा परमेश्वर को जवर आये; अऊर जेख परमेश्वर दोषी ठहराये ऊ दूसरो ख दोय गुना भर दे।” ");
INSERT INTO lbm_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“यदि कोयी पड़ोसी ख गधा, यां बईल यां मेंढी-शेरी यां कोयी अऊर पशु रखन लायी सौंपेंन, अऊर कोयी को बिना देखेंन ऊ मर जायेंन, यां चोट खाये, यां भगाय दियो जायेंन,” ");
INSERT INTO lbm_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","त उन दोयी को बिच परमेश्वर की कसम खिलायी जाय, मय न येकी सम्पत्ति पर हाथ नहीं लगायो; तब सम्पत्ति को मालिक येख सच मानेंन, अऊर दूसरो ख कुछ भी भर देनो नहीं पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","यदि ऊ सचमुच ओको यहां सी चोरयो गयो होना, त ऊ ओको मालिक ख भर दे। ");
INSERT INTO lbm_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","अऊर यदि ऊ जनावर ख जंगली जनावर न चिर डाल्यो, त ऊ चिरयो हुयो ख सबूत लानो पड़ेंन, तब ओख कुछ भी भर नहीं देनो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“फिर यदि कोयी अपनो काम निकालन लायी दूसरो सी जनावर मांग लाये, अऊर ओको मालिक को गैरहाजिर म जनावर घायल होय यां मर जाये, त ऊ निश्चय ओको नुकसान भर दे। ");
INSERT INTO lbm_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","यदि ऊ समय ओको मालिक संग म हय, त दूसरो ख ओको नुकसान भरनो नहीं पड़ेंन; अऊर यदि किरायो को हय त ओको नुकसान ओको किरायो म आय गयी।” ");
INSERT INTO lbm_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“यदि कोयी आदमी कोयी कुंवारी टुरी ख, जेको बिहाव की बात नहीं लगी हय, फुसलाय क ओको संग कुकर्म करेंन, त ऊ निश्चय ओकी मोल दे क ओको सी बिहाव कर ले। ");
INSERT INTO lbm_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","पर यदि ओको बाप ओख देनो सी मना करेंन, त कुकर्म करन वालो टुरियों को कीमत रीति को अनुसार रुपया भर दे। ");
INSERT INTO lbm_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“तय जादू-टोना करन वाली बाई ख जीन्दो मत रहन देजो। ");
INSERT INTO lbm_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“जो कोयी जनावर सी कुकर्म करे ऊ निश्चय मार डाल्यो जाय। ");
INSERT INTO lbm_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“जो कोयी परमेश्वर ख छोड़ क अऊर कोयी अऊर देवता लायी बलि चढ़ाये ओको सत्यानाश करयो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“तुम कोयी परदेशी ख मत सताजो अऊर नहीं ओको पर अन्याय करजो, कहालीकि मिस्र देश म तुम भी परदेशी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","कोयी विधवा यां अनाथ बच्चा ख दु:ख मत देजो। ");
INSERT INTO lbm_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","यदि तुम असो ख कोयी तरह को दु:ख देवो अऊर हि मोरो सी मदत लायी रोवय, त मय निश्चय उन्की दोहाई सुनूं; ");
INSERT INTO lbm_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","तब मोरो गुस्सा भड़केंन, त मय तुम ख तलवार सी मार डालूं, अऊर तुम्हरी पत्नी विधवा अऊर तुम्हरो बच्चा अनाथ होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“यदि तय मोरो लोगों म सी कोयी गरीब आदमी ख जो तोरो संग रह्य हय पैसा उधार देजो त ओको सी साहुकार को जसो ब्याज नहीं लेजो। ");
INSERT INTO lbm_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","यदि तय कभी अपनो भाऊ-बन्धु को कपड़ा ख गिरवी रख क रख भी ले, त सूरज को डुबन तक ओख लौटाय देजो; ");
INSERT INTO lbm_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","कहालीकि ऊ ओको एकच चादर हय, ओको शरीर को उच एकच कपड़ा होयेंन, फिर ऊ कसो ओढ़ क सोयेंन? अऊर जब ऊ मोरी दोहाई देयेंन तब मय ओकी सुनूं, कहालीकि मय करुनामय आय। ");
INSERT INTO lbm_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“परमेश्वर ख दोष मत देजो, अऊर नहीं अपनो लोगों को मुखिया ख श्राप मत देजो। ");
INSERT INTO lbm_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“अपनो खेती की फसल अऊर फर को रस म सी मोख देन म देर मत करजो। अपनो टुरावों म सी पहिलौठा ख मोख देजो। ");
INSERT INTO lbm_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","वसोच अपनी गाय अऊर मेंढी-शेरी को पहिलौठा भी देजो; सात दिन तक त बच्चा अपनी माय को संग रहेंन, अऊर आठवों दिन तय ओख मोख ख दे देजो। ");
INSERT INTO lbm_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“तुम मोरो लायी पवित्र लोग बनजो; यो वजह जो पशु मैदान म चिरयो हुयो पड़्यो मिलेंन ओको मांस मत खाजो, ओख कुत्ता को आगु फेंक देजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“झूठी बात मत फैलावो। अऊर झूठी गवाही दे क अन्यायी लोगों को साथ मत देजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","बुरायी करन लायी बहुतों को पीछू मत पड़जो; अऊर न उन्को पीछू फिर क् मुकद्दमा म न्याय बिगाड़न लायी गवाही देजो; ");
INSERT INTO lbm_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","अऊर गरीब को मुकद्दमा म ओको भी पक्ष मत लेजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“फिर यदि तोरो दुश्मन को बईल यां गधा भटकतो हुयो तोख मिलेंन, त ओख ओको जवर जरूर वापस ले आजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","फिर यदि तय अपनो दुश्मन को गधा ख बोझ को मारे दब्यो हुयो देखो, तब भी जरूर मालिक की मदत कर क् ओख छुड़ाय लेजो करजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“तोरो लोगों म सी जो गरीब हय ओको मुकद्दमा म न्याय मत बिगाड़जो ");
INSERT INTO lbm_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","झूठो मुकद्दमा सी दूर रहजो, अऊर निर्दोष अऊर सच्चो ख घात मत करजो, कहालीकि मय बुरो ख निर्दोष नहीं ठहराऊं, ");
INSERT INTO lbm_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","तय घुस नहीं लेजो, कहालीकि घुस आदमी ख सच सी अन्धो कर देवय अऊर सच्चो की न्याय बिगाड़ देवय हय। ");
INSERT INTO lbm_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“परदेशी पर जुलूम मत करजो; तुम त परदेशी को मन की बात जानय हय, कहालीकि तुम भी मिस्र देश म परदेशी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“छय साल तक अपनी जमीन म बीज बोवो अऊर ओकी फसल जमा करजो; ");
INSERT INTO lbm_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","पर सातवों साल म ओख खाली रहन देजो अऊर वसोच छोड़ देजो, त गरीब लोग अऊर जो कुछ उन्को सी भी बच जायेंन त जंगली जनावर ख खान को काम म आये। अपनी अंगूर अऊर जैतून की बाड़ी सी भी असोच करजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","छय दिन तक अपनो काम काज करजो, अऊर सातवों दिन आराम करजो ताकि तोरो बईल अऊर गधा सुस्तायेंन, अऊर तोरी सेविका को टुरा अऊर परदेशी ख भी आराम मिल सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","जो कुछ मय न तुम सी कह्यो हय ओको पालन करजो; अऊर अन्य देवतावों की नाम की चर्चा भी मत करजो, बल्की हि तुम्हरो मुंह सी सुनायी भी नहीं दे। ");
INSERT INTO lbm_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“हर साल तीन बार मोरो लायी त्यौहार मानजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","पहिलो पवित्र त्यौहार अखमीरी रोटी को त्यौहार मनायजो; ओको म मोरी आज्ञा को अनुसार अबीब महीना को नियत समय पर सात दिन तक अखमीरी रोटी खायो करनो, कहालीकि ओको महीना म तुम लोग मिस्र देश सी निकल आये होतो। मोख कोयी खाली हाथ अपनो मुंह नहीं दिखाये। ");
INSERT INTO lbm_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","जब तोरी बोयी हुयी खेत की पहिली फसल तैयार होना, तब कटनी को त्यौहार मनायजो। साल को आखरी म जब तय मेहनत की फसल जमा कर क् ढेर लगायजो, तब जमा करन को त्यौहार मनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","हर साल तीनों बार तोरो सब लोग प्रभु परमेश्वर ख अपनो मुंह दिखाये। ");
INSERT INTO lbm_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“मोरो जनावर को बलिदान को खून खमीरी रोटी को संग नहीं चढ़ाजो, अऊर नहीं मोरो त्यौहार को उत्तम बलिदान म सी कुछ सुबेरे तक रहन देजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","अपनो जमीन की पहिली फसल को पहिलो हिस्सा अपनो परमेश्वर यहोवा को भवन म ले आजो। शेरी को बच्चा ओकी माय को दूध म नहीं पकाजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“सुन, मय एक दूत तोरो आगु आगु भेजूं जो रस्ता म तोरी रक्षा करेंन, अऊर जो जागा ख मय न तैयार करयो हय उत तोख पहुंचायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ओको आगु सावधान रहजो, अऊर ओकी मानजो, ओको विरोध मत करजो, कहालीकि ऊ तोरो अपराध माफ नहीं करेंन; येकोलायी कि मोरो नाम ओको म हय। ");
INSERT INTO lbm_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","यदि तय सचमुच मोरी आज्ञा मानेंन अऊर जो कुछ मय कहूं ऊ करय, त मय तोरो दुश्मनों को दुश्मन अऊर तोरो बैरियों को बैरी बनूं। ");
INSERT INTO lbm_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","जब मोरो दूत आगु चल क तोख एमोरी, हित्ती, परिज्जी, कनानी, हिब्बी, अऊर यबूसी लोगों को यहां पहुंचायेंन, अऊर मय उन्ख सत्यानाश कर डालूं। ");
INSERT INTO lbm_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","उन्को देवतावों ख दण्डवत मत करजो, अऊर नहीं उन्की आराधना करजो, अऊर नहीं उन्को सी काम करजो, बल्की उन मूर्तियों को पूरी रीति सी सत्यानाश कर डालजो, अऊर उन लोगों को खम्बा को तुकड़ा तुकड़ा कर देजो। ");
INSERT INTO lbm_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तय अपनो परमेश्वर यहोवा की आराधना करजो, तब ऊ तोरो भोजन अऊर पानी पर आशीष देयेंन, अऊर तोरो बीच म सी रोग दूर करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तोरो देश म नहीं त कोयी को गर्भ गिरेंन अऊर नहीं कोयी बांझ रहेंन; अऊर तोरी उमर को दिन मय पूरो करूं। ");
INSERT INTO lbm_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","जितनो लोगों को बीच तय जाजो उन सब को मन म मय अपनो डर पहिले सी असो समाय देऊं कि उन्ख परेशान कर देऊं, अऊर मय तोख सब दुश्मन ख वापस जान लायी विवश कर देऊं। ");
INSERT INTO lbm_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","अऊर मय तोरो सी पहिले गंदनल ख भेजूं जो हिब्बी, कनानी, अऊर हित्ती लोगों ख तोरो आगु सी भगाय क दूर कर देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","मय उन्ख तोरो आगु सी एकच साल म नहीं निकालूं, असो नहीं होय कि देश उजाड़ होय जाये, अऊर जंगली जनावर बढ़ क तोरी हानि करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","जब तक तय बढ़ क देश पर अपनो अधिकार नहीं कर ले तब तक मय उन्ख तोरो आगु सी थोड़ो थोड़ो कर क् निकालतो रहूं। ");
INSERT INTO lbm_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","मय तोरी सीमा लाल समुन्दर सी ले क पलिश्तियों को समुन्दर तक अऊर जंगल सी ले क फरात नदी तक को देश ख तोरो वश म कर देऊं; मय ऊ देश को निवासियों ख भी तोरो वश म कर देऊं, अऊर तय उन्ख अपनो जवर सी निकाल देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तय नहीं त उन्को सी वाचा बान्धजो अऊर नहीं उन्को देवतावों सी। ");
INSERT INTO lbm_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","हि तोरो देश म नहीं रहनो पाये, असो नहीं होय कि हि तोरो सी मोरो खिलाफ पाप करायेंन; यदि तय उन्को देवतावों की आराधना करे त यो तोरो लायी फन्दा बनेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","परमेश्वर न मूसा सी कह्यो, “तय हारून, नादाब, अबीहू, अऊर इस्राएलियों को सत्तर बुजूर्गों को संग परमेश्वर को जवर ऊपर आय क दूर सी आराधना करजो। ");
INSERT INTO lbm_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","केवल मूसा परमेश्वर को जवर आयेंन, पर हि जवर नहीं आये, अऊर दूसरो लोग तोरो संग ऊपर नहीं आये।” ");
INSERT INTO lbm_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मूसा न लोगों को जवर जाय क परमेश्वर की पूरी बात अऊर नियम सुना दियो। तब सब लोग एक आवाज म बोल्यो, “जितनो बात परमेश्वर न कह्यो हंय उन सब बात ख हम मानबों।” ");
INSERT INTO lbm_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","तब मूसा न परमेश्वर को सब वचन लिख दियो; अऊर बहुत सुबेरे उठ क पहाड़ी को खल्लो एक वेदी अऊर इस्राएल को बारा कुल को अनुसार बारा खम्बा भी बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","तब ओन इस्राएली जवानों ख भेज्यो, जिन्न परमेश्वर लायी होमबलि अऊर जनावर की मेलबलि चढ़ायी। ");
INSERT INTO lbm_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","अऊर मूसा न अरधो खून ले क कटोरा म रख्यो, अऊर अरधो वेदी पर छिड़क दियो। ");
INSERT INTO lbm_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","तब वाचा की किताब ख ले क लोगों ख पढ़ क सुनायो; ओख सुन क उन्न कह्यो, “जो कुछ परमेश्वर न कह्यो हय ऊ सब ख हम करबो, अऊर ओकी आज्ञा मानबो।” ");
INSERT INTO lbm_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मूसा न खून ले क लोगों पर छिड़क्यो, अऊर उन सी कह्यो, “देखो, यो ऊ वाचा को खून आय, जेख परमेश्वर न इन सब वचनों पर तुम्हरो संग बान्धी हय।” ");
INSERT INTO lbm_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","तब मूसा, हारून, नादाब, अबीहू अऊर इस्राएलियों को सत्तर बुजूर्ग लोग ऊपर पहाड़ी पर चढ़ गयो, ");
INSERT INTO lbm_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","अऊर इस्राएल को परमेश्वर को दर्शन करयो; अऊर ओको पाय को खल्लो नीलमनि को चौरंग को जसो कुछ होतो, जो आसमान को समान साफ होतो। ");
INSERT INTO lbm_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","अऊर ओन इस्राएलियों को मुखियावों पर हाथ नहीं बढ़ायो; तब उन्न परमेश्वर को दर्शन करयो, अऊर खायो पीयो। ");
INSERT INTO lbm_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","तब परमेश्वर न मूसा सी कह्यो, “पहाड़ी पर मोरो जवर चढ़ आव, अऊर वहां मोरी बाट देखजो; अऊर मय तोख गोटा की पट्टियां, अऊर अपनी लिखी हुयी व्यवस्था अऊर आज्ञा देऊं कि तय उन्ख सिखाजो।” ");
INSERT INTO lbm_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","तब मूसा यहोशू नाम को अपनो सेवक को संग परमेश्वर की पहाड़ी पर चढ़ गयो। ");
INSERT INTO lbm_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","अऊर बुजूर्गों सी यो कह्यो गयो, “जब तक हम तुम्हरो जवर फिर नहीं आबो तब तक तुम यहांच हमरी बाट देखत रहो; अऊर सुनो, हारून अऊर हूर तुम्हरो संग हंय; यदि कोयी को मुकद्दमा हय त उन्कोच जवर जाये।” ");
INSERT INTO lbm_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","तब मूसा पहाड़ी पर चढ़ गयो, अऊर बादर न पहाड़ी ख छाय लियो। ");
INSERT INTO lbm_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","तब परमेश्वर को तेज न सीनै पहाड़ी पर निवास करयो, अऊर ऊ बादर ओको पर छय दिन तक पहाड़ी पर छायो रह्यो; अऊर सातवों दिन ओन मूसा ख बादर को बीच म सी बुलायो। ");
INSERT INTO lbm_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएलियों की नजर म परमेश्वर को तेज पहाड़ी की सेंडी पर भस्म करनवाली आगी को समान दिखायी देत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","तब मूसा बादर को बीच जाय क पहाड़ी पर चढ़ गयो। अऊर पहाड़ी पर चालीस दिन अऊर चालीस रात रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएलियों सी यो कहजो कि मोरो लायी भेंट लाये; जितनो अपनी इच्छा सी देनो चाहेंन उन सभी सी मोरी भेंट लेजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","अऊर जिन चिजों की भेंट उन्को सी लेनो हय हि यो आय; मतलब सोना, चांदी अऊर पीतल, ");
INSERT INTO lbm_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीलो, जामुनी अऊर लाल रंग को कपड़ा, पतलो सूत सी बुन्यो कपड़ा, शेरी को बाल, ");
INSERT INTO lbm_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","लाल रंग सी रंगी हुयो मेंढी की खाल, सुईसों की खाल, बबूल की लकड़ी, ");
INSERT INTO lbm_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","दीया लायी तेल, अभिषेक को तेल लायी अऊर सुगन्धित धूप लायी सुगन्ध मसाला, ");
INSERT INTO lbm_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एपोद पोशाक अऊर ओको ऊपर पहिनन वालो चपरास लायी सुलैमानी गोटा, अऊर जड़न लायी मनि। ");
INSERT INTO lbm_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","अऊर हि मोरो लायी एक पवित्र जागा बनाये कि मय उन्को बीच निवास करूं। ");
INSERT INTO lbm_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","जो कुछ मय तोख दिखाऊ हय, मतलब रहन की जागा अऊर ओको सब सामान को नमुना, ओकोच अनुसार तुम लोग ओख बनावो।” ");
INSERT INTO lbm_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","बबूल की लकड़ी को एक सन्दूक बनायो जाये; ओकी लम्बायी ढायी हाथ, अऊर चौड़ायी अऊर ऊंचायी देड़ देड़ हाथ की होना। ");
INSERT INTO lbm_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","अऊर ओख शुद्ध सोनो सी अन्दर अऊर बाहेर मढ़वाजो, अऊर सन्दूक को ऊपर चारयी तरफ सोनो की किनार बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","अऊर सोनो को चार कड़ा साचा सी ढाल क बनायजो ओको चारयी पाय पर, एक तरफ दोय कड़ा अऊर दूसरो तरफ दोय कड़ा लगाजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","फिर बबूल की लकड़ी को डन्डा बनवाजो, अऊर उन्ख भी सोनो सी मढ़ो। ");
INSERT INTO lbm_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","अऊर डन्डा ख सन्दूक को दोयी तरफ को कड़ा म डालजो, जेकोसी उन्को सहारा सी सन्दूक ख उठायो जाये सके। ");
INSERT INTO lbm_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","हि डन्डा सन्दूक को कड़ा म लग्यो रहेंन; अऊर ओको सी अलग नहीं करयो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","अऊर जो गवाही चिट्ठी मय तोख देऊं ओख उच सन्दूक म रखजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“फिर शुद्ध सोनो को एक पश्चाताप को ढक्कन बनवाजो; ओकी लम्बायी ढायी हाथ, अऊर चौड़ायी देड़ हाथ की होना। ");
INSERT INTO lbm_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","अऊर सोना ढाल क दोय करूब बनाय क पश्चाताप को ढक्कन को दोयी कोना पर लगवाजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक करूब एक कोना पर अऊर दूसरो करूब दूसरो कोना पर लगवाजो; करूबों ख दया आसन को ढक्कन ख एकच तुकड़ा सी बनाय क ओको दोयी कोना पर लगवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","उन करूबों को पंखा ऊपर सी असो फैल्यो हुयो बने कि पश्चाताप को ढक्कन उन सी ढक्यो रहे, अऊर उन्को मुख आमने-सामने अऊर दया आसन को ढक्कन को तरफ रहे। ");
INSERT INTO lbm_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","अऊर पश्चाताप को ढक्कन ख सन्दूक को ऊपर लगवाजो; अऊर जो गवाही चिट्ठी मय तोख देऊं ओख सन्दूक को अन्दर रखजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","मय वहां रह्य क तोरो सी मिलतो रहूं; अऊर इस्राएलियों लायी जितनी आज्ञाये मोख ख तोख देनो होय, उन सभी को बारे म पश्चाताप को ढक्कन को ऊपर सी अऊर उन करूबों को बीच म सी, जो गवाही चिट्ठी को सन्दूक पर होना, तोरो सी बात-चित करतो रहूं।” ");
INSERT INTO lbm_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“फिर बबूल की लकड़ी की एक टेबल बनायजो; ओकी लम्बायी दोय हाथ, चौड़ायी एक हाथ, अऊर ऊंचायी देड़ हाथ की होना। ");
INSERT INTO lbm_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ओख शुद्ध सोनो सी मढ़ायजो, अऊर ओको चारयी तरफ सोनो की एक किनार बनायजो ");
INSERT INTO lbm_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","अऊर ओको चारयी तरफ चार बोट चौड़ी चौखट बनायजो, अऊर यो चौखट को चारयी तरफ सोनो की एक किनार बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","अऊर सोनो को चार कड़ा बनवाय क टेबल को उन चारयी कोना म लगायजो जो ओको चारयी पाय म होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","हि कड़ा चौखट को जवरच होना, अऊर जेकोसी टेबल डन्डा को सहारा सी उठायो जाय सके। ");
INSERT INTO lbm_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","बबूल की लकड़ी को डन्डा बनाय क सोनो सी मढ़वाजो, टेबल उन्को सीच उठायो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","अऊर ओको परात अऊर धूपदान, अऊर मग्गा अऊर कुड़ावन को कटोरा, सब शुद्ध सोनो को बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","अऊर टेबल पर मोरो आगु भेंट की रोटी हमेशा रखजो।” ");
INSERT INTO lbm_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“फिर शुद्ध सोना को एक दीया बनायजो। सोनो ढाल क ऊ दीया पाया अऊर डन्डी सहित बनायो जाये; ओकी पंखुड़ी, गाठ, अऊर फूल, एकच तुकड़ा की बनी होना; ");
INSERT INTO lbm_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","अऊर ओको किनार सी छय डन्डी निकली हो, तीन त दीवट को एक तरफ सी अऊर तीन ओको दूसरी तरफ सी निकली हुयी हो; ");
INSERT INTO lbm_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","हर एक डगाली म बादाम को फूल को जसो तीन तीन पुष्पकोष, एक एक गांठ, अऊर एक एक फूल हो; दीया सी निकली हुयी छय डगालियों को योच आकार अऊर रूप हो; ");
INSERT INTO lbm_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","अऊर खड़ो दीवट की डन्डी म बादाम को फूल को समान चार कटोरी अपनी पंकुड़ी फूल समेत हो; ");
INSERT INTO lbm_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","अऊर दीया सी निकली हुयी छय डगालियों म सी एक बाजू तीन अऊर दूसरो बाजू तीन असो डन्डी हो, हि दीवट समेत एकच तुकड़ों को बन्यो हुयो हो। ");
INSERT INTO lbm_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","उन्की पंकुड़ी अऊर डगाली सब दीया समेत एकच तुकड़ों की शुद्ध सोनो सी बनी हो। ");
INSERT INTO lbm_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","अऊर सात दीया बनवाजो, अऊर दीया जलाय क दीवट पर रखजो कि उजाड़ो आगु दिखेंन। ");
INSERT INTO lbm_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","अऊर ओको चिमटा अऊर गुलदान सब शुद्ध सोनो को हो। ");
INSERT INTO lbm_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ऊ सब पूरो सामान लगभग पैतीस किलो शुद्ध सोनो सी बनें। ");
INSERT INTO lbm_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","अऊर ध्यान सी इन सब चीजो ख जसो बतायो हय वसोच बनायजो, जो तोख या पहाड़ी पर दिखायो होतो।” ");
INSERT INTO lbm_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","परमेश्वर न मूसा सी कह्यो, फिर निवास जागा लायी दस परदा बनायजो; इन्को पतलो धागा को बिन्यो हुयो नीलो, जामुनी अऊर लाल रंग को कपड़ा को बुन्यो हुयो करूबों को चित्र संग बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","हर एक परदा की लम्बायी अट्ठावीस फीट अऊर चौड़ायी चार फीट की हो, सब परदा एकच नाप को हो। ");
INSERT INTO lbm_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पाच परदा एक दूसरो सी जोड़्यो हुयो हो; अऊर फिर जो पाच परदा रहेंन हि भी एक दूसरो सी जुड़्यो हुयो हो। ");
INSERT INTO lbm_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","अऊर जित या दोयी परदा जोड़्यो जाये उत को दोयी कोना पर नीलो नीलो फन्दा लगायजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","दोयी कोना म पचास पचास फन्दा असो लगवायजो कि हि आमने-सामने हो। ");
INSERT INTO lbm_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","अऊर सोनो को पचास गोल कड़ी बनायजो; अऊर जोड़्यो हुयो परदा ख इन कड़ी सी जोड़ देजो जेकोसी पूरो निवास जागा एक बन जाये। ");
INSERT INTO lbm_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“फिर निवास को ऊपर तम्बू लायी बकरा को बाल को ग्यारा परदा बनवाजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","हर एक परदा की लम्बायी तीस हाथ अऊर चौड़ायी चार हाथ हो, असो ग्यारा परदा एकच नाप को हो। ");
INSERT INTO lbm_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","अऊर पाच परदा को एक जोड़ अऊर फिर छय परदा को दूसरो जोड़ अलग जोड़जो, अऊर छठवो परदा ख तम्बू को आगु मोड़ क डबल कर क् लटकाय देजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","अऊर तय पचास कड़ी उच परदा को कोना म अऊर पचास कड़ी दूसरी तरफ को परदा को कोना म जो बाहेर सी मिलाय क बनवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","अऊर पीतल को पचास कड़ा बनाजो, अऊर कड़ा ख फन्दा म लगाय क तम्बू ख असो जोड़जो कि ऊ मिल क एक होय जाये। ");
INSERT INTO lbm_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","अऊर तम्बू को परदा को लटक्यो हुयो हिस्सा, यानेकि जो अरधो बच्यो रहेंन, ऊ निवास-जागा की पिछली तरफ लटक्यो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","अऊर तम्बू को परदा की लम्बायी म सी हाथ भर इत, अऊर हाथ भर उत निवास-जागा को ढकन लायी ओको दोयी तरफ लटक्यो हुयो रहो। ");
INSERT INTO lbm_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","फिर तम्बू लायी लाल रंग सी रंगी हुयो मेंढी की खाल को एक ओढ़नो अऊर ओको ऊपर सुइसों की खाल को भी एक ओढ़नो बनायजो।” ");
INSERT INTO lbm_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“फिर निवास-जागा ख खड़ो करन लायी बबूल की लकड़ी को चौखट बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","हर एक तक्ता की लम्बायी दस हाथ अऊर चौड़ायी देढ़ हाथ की हो। ");
INSERT INTO lbm_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","हर एक तक्ता म एक दूसरो सी जोड़ी हुयी दोय दोय खाचा हो; निवास-जागा को सब तक्ता ख येको भाति सी बनवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","निवास-जागा लायी जो तक्ता तय बनवायजो उन्म सी बीस तक्ता त दक्षिन की तरफ लायी हो; ");
INSERT INTO lbm_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","अऊर बीस तक्तां को नीचो चांदी की चालीस आधार-तक्ता बनाजो, मतलब एक एक तक्तां को नीचो ओको खाचा लायी दोय दोय आधार-तक्ता बनवाजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","निवास को दूसरी तरफ, मतलब उत्तर की तरफ लायी बीस तक्तां बनवायजो; ");
INSERT INTO lbm_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","अऊर उन्को लायी चांदी की चालीस आधार-तक्ता बनवायजो, मतलब एक एक तक्तां को नीचो दोय दोय हो।” ");
INSERT INTO lbm_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","निवास को पीछू तरफ, मतलब पश्चिम की तरफ लायी छय तक्तां बनवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","अऊर पिछलो हिस्सा म निवास को कोना लायी दोय तक्तां बनवायजो; ");
INSERT INTO lbm_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","अऊर या नीचो सी दोय दोय हिस्सा को हो, अऊर दोयी हिस्सा ऊपर को कोना तक एक एक कड़ा म मिलाये जाये; दोयी तक्तां को योच रूप हो; या दोयी कोनो लायी आय। ");
INSERT INTO lbm_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","अऊर आठ तक्ता हो, अऊर उन्की चांदी की आधार-तक्ता हो, मतलब एक एक तक्ता को नीचो दोय दोय हो। ");
INSERT INTO lbm_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“तब बबूल की लकड़ी को डन्डा बनायजो, मतलब निवास को एक तरफ को तक्तां लायी पाच, ");
INSERT INTO lbm_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","अऊर निवास को दूसरी तरफ को तक्तां लायी पाच डन्डा अऊर निवास को जो भाग पश्चिम की तरफ पीछू भाग म होयेंन, ओको लायी पाच बेंड़े बनायजो।” ");
INSERT INTO lbm_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","बीच वालो डन्डा जो तक्तां को बीच म होयेंन ऊ तम्बू को एक कोना सी दूसरो कोना तक जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","तक्तां ख सोनो सी मढ़वाजो, अऊर उन्को कड़ां जो डन्डा को सहारा को काम देयेंन उन्ख भी सोनो सी बनवाजो, अऊर बेंड़ा ख भी सोनो सी मढ़वायजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","अऊर निवास की जागा ख असो रीति सी खड़ो करजो जसो पहाड़ी पर तोख दिखायो गयो हय। ");
INSERT INTO lbm_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“तब नीलो, जामुनी अऊर लाल रंग को पतलो धागा सी बुन्यो हुयो कपड़ा को एक बीच वालो परदा बनायजो; ओको पर करूबों को चित्र बुन क बनायजो।” ");
INSERT INTO lbm_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","अऊर ओख सोनो सी मढ़यो हुयो बबूल को चार खम्बां पर लटकायजो, इन्की खूटी सोनो की हो, अऊर या चांदी की चार आधार-तक्ता पर लगी हुयो, सोनो को छल्ला म फस्यो होन ख होना। ");
INSERT INTO lbm_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","अऊर बीच वालो परदा ख खूटी को नीचो लटकाय क, ओकी आड़ म साक्षी पत्र को सन्दूक अन्दर ले जानो, यो तरह ऊ बीच वालो परदा तुम्हरो लायी पवित्र जागा ख परम पवित्र जागा सी अलग करयो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","फिर परम पवित्र जागा म गवाही चिट्ठी को सन्दूक को ऊपर पश्चाताप को ढक्कन ख रखजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","अऊर ऊ परदा को बाहेर निवास को उत्तर को तरफ मेज रखजो; अऊर ओको दक्षिन तरफ मेज को आगु दीवट ख रखजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","फिर तम्बू को द्वार लायी नीलो, जामुनी अऊर लाल रंग को अऊर पतलो धागा सी बुन्यो हुयो एक परदा बनवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","अऊर यो परदा लायी बबूल को पाच खम्बा बनायजो, अऊर उन्ख सोनो सी मढ़वाना; उन्को कड़ां सोनो की हो, अऊर उन्को लायी पीतल की पाच तक्ता ढलवाय क बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","परमेश्वर न मूसा सी कह्यो, “तब वेदी ख बबूल की लकड़ी सी, पाच हाथ लम्बी अऊर पाच हाथ चौड़ी बनायजो; वेदी चौकोन हो, अऊर ओकी ऊंचायी तीन हाथ की हो। ");
INSERT INTO lbm_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","अऊर ओको चारयी कोनो पर चार सींग बनायजो; हि ओको सहित एकच तुकड़ा को हो, अऊर ओख पीतल सी मढ़वायजो। ");
INSERT INTO lbm_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","अऊर ओकी राख उठान को सुपड़ी, अऊर पावड़ा, अऊर कटोरा, अऊर दोय दाती पावड़ा, अऊर आगी सामान बनायजो; ओको सब सामान पीतल को होना। ");
INSERT INTO lbm_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ओको लायी पीतल की एक जाली बनायजो; अऊर ओको चारयी कोनो पर पीतल को चार कड़ा लगवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","अऊर वा जाली ख वेदी को चारयी तरफ की मेज को नीचो असो लगवायजो कि ऊ वेदी की ऊचायी को बीच तक पहुंच्यो। ");
INSERT INTO lbm_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","अऊर वेदी लायी बबूल की लकड़ी को डन्डा बनायजो, अऊर उन्ख पीतल सी मढ़वाजो। ");
INSERT INTO lbm_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","अऊर डन्डा ख कड़ों म असो डाले कि जब वेदी उठायी जाये तब हि ओको दोयी किनार पर रह्य सके। ");
INSERT INTO lbm_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदी ख तक्तों सी खोखली बनवायजो; जसी ऊ पहाड़ी पर तोख दिखायो होतो वसोच बनवाजो।” ");
INSERT INTO lbm_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“फिर निवास को आंगन ख बनायजो। ओको दक्षिन की तरफ लायी पतलो धागा बिन्यो हुयो कपड़ा को परदा हो, ओकी लम्बायी सौव हाथ की होय; एक किनार पर इतनोच हो। ");
INSERT INTO lbm_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","अऊर उन्को लायी बीस खम्बा बनेंन, अऊर इन्को लायी पीतल की बीस तक्ता होना, अऊर खम्बा को कुन्दा अऊर उन्की पट्टियां चांदी की होना। ");
INSERT INTO lbm_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","अऊर उच तरह आंगन को उत्तर की तरफ की लम्बायी म भी सौ हाथ लम्बो परदा होना, अऊर उन्को लायी भी बीस खम्बा अऊर इन्को लायी भी पीतल को बीस खाना होना; अऊर उन खम्बों को कुन्दा अऊर पट्टियां चांदी की होना। ");
INSERT INTO lbm_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","फिर आंगन की चौड़ायी म पश्चिम की तरफ पचास हाथ को परदा हो, उन्को लायी खम्बा दस अऊर खानो भी दस हय। ");
INSERT INTO lbm_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","पूर्व की तरफ आंगन की चौड़ायी पचास हाथ की होना। ");
INSERT INTO lbm_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","आंगन को फाटक की एक तरफ पन्द्रा हाथ को परदा हय, अऊर उन्को लायी खम्बा तीन अऊर खाना तीन होना; ");
INSERT INTO lbm_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","अऊर दूसरी तरफ भी पन्द्रा हाथ को परदा हो, उन्को लायी भी खम्बा तीन अऊर खाना तीन होना। ");
INSERT INTO lbm_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","आंगन को फाटक लायी एक परदा बनायजो, जो नीलो, जामुनी अऊर लाल रंग को कपड़ा अऊर पतलो बुन्यो हुयो सूती कपड़ा सी बन्यो होयेंन, ओको लायी खम्बा चार अऊर खाना भी चार होना। ");
INSERT INTO lbm_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आंगन को चारयी तरफ को सब खम्बां चांदी की पट्टियां सी जुड़्यो हुयो हो, उन्को कुन्दा चांदी को अऊर खाना पीतल को हो। ");
INSERT INTO lbm_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आंगन की लम्बायी सौ हाथ की अऊर ओकी चौड़ायी सब जागा पचास हाथ की हो, ओको परदा की ऊचायी पाच हाथ की हो, तब ऊ पतलो बुन्यो हुयो सूती कपड़ा सी बन्यो हो, खम्बों को खाना पीतल को होना। ");
INSERT INTO lbm_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","निवास जागा को अलग अलग तरह को बर्तन अऊर सब सामान अऊर ओको सब खूटा अऊर आंगन को भी सब खूटा पीतल को हो। ");
INSERT INTO lbm_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“तब तय इस्राएलियों ख आज्ञा देजो, कि मोरो जवर दीया लायी पीस क निकाल्यो हुयो जैतून को शुद्ध तेल ले आजो, जेकोसी दीया हमेशा जलतो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","परमेश्वर को उपस्थिति को तम्बू म, उच बीच वालो परदा सी बाहेर जो साक्षी चिट्ठी को आगु होयेंन, हारून अऊर ओको टुरा दीया शाम सी सुबेरे तक परमेश्वर को आगु सजाय क रखो। या विधि इस्राएलियों की पीढ़ियों लायी हमेशा बन्यो रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“तब तय इस्राएलियों म सी अपनो भाऊ हारून, अऊर नादाब, अबीहू, एलीआजार अऊर ईतामार नाम को ओको टुरावों ख अपनो जवर ले आजो कि हि मोरो लायी याजक को काम करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","अऊर तय अपनो भाऊ हारून लायी वैभव अऊर शोभा को लायी पवित्र कपड़ा बनाजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","अऊर जितनो बुद्धि वालो कारागिर हय, जिन्ख मय न बुद्धि देन वाली आत्मा सी परिपूर्न करयो हय, उन्को तय हारून को कपड़ा बनान की आज्ञा दे कि ऊ मोरो लायी याजक को काम करन लायी पवित्र बनो। ");
INSERT INTO lbm_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","जो कपड़ा उन्ख बनानो होयेंन हि यो हंय, मतलब सीनाबन्द, अऊर एपोद पोशाक, अऊर बागा, चारखाने को अंगरखा, फेटा अऊर कमर पट्टा; योच पवित्र कपड़ा तोरो भाऊ हारून अऊर ओको टुरावों लायी बनाये जाये कि हि मोरो लायी याजक को काम करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","अऊर हि सोनो अऊर नीलो अऊर जामुनी अऊर लाल रंग को अऊर पतलो धागा सी बुन्यो हुयो कपड़ा ले। ");
INSERT INTO lbm_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“हि एपोद ख सोनो अऊर नीलो, जामुनी अऊर लाल रंग को कपड़ा को अऊर पतलो धागा सी बिन्यो हुयो कपड़ा बनाये, जो कि निपुनता सी बुनायी को काम करन वालो को हाथ को काम हो। ");
INSERT INTO lbm_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ऊ यो तरह सी जोड़्यो जाये कि ओको दोयी कन्धों को कोना आपस म मिल्यो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","अऊर एपोद पर जो ओख पर निपुनता सी बुन्यो हुयो कमर पट्टा होयेंन, ओकी बनावट ओकोच समान हो, अऊर हि दोयी बिना जोड़ को हो, अऊर सोनो अऊर नीलो, जामुनी अऊर लाल रंग वालो अऊर पतलो धागा सी बुन्यो हुयो कपड़ा को हो। ");
INSERT INTO lbm_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","फिर दोय सुलैमानी मनि ले क उन पर इस्राएल लोगों को टुरावों को नाम खुदवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","उन्को नामों म सी छय एक मनि पर अऊर शेष छय नाम दूसरो मनि पर, इस्राएल को टुरावों की जनम को अनुसार खुदवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","मनि खोदन वालो को काम को समान जसो छापा खोद्यो जावय हय, वसोच उन दोय मनियों पर इस्राएल लोगों को टुरावों को नाम मनि पर खुदवायजो; अऊर उन्को सोनो को खाना म जड़वाय देजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","अऊर दोयी मनियों ख एपोद को कन्धों पर लगायजो, हि इस्राएलियों को याद दिलावन वाली मनि ठहरेंन; मतलब हारून उन्को नाम परमेश्वर को आगु अपनो दोयी कन्धों पर याद लायी लगायो रखेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","“तब सोनो को खाना बनायजो, ");
INSERT INTO lbm_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","अऊर डोरियों को समान गूथ्यो हुयो दोय संकली शुद्ध सोनो को बनायजो; अऊर गूथ्यो हुयो संकलियों ख उन खाना म फसाय देजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“तब न्याय की चपरास ख भी बुनायी को काम को बनायजो, एपोद को समान सोनो, अऊर नीलो, जामुनी अऊर लाल रंग को अऊर पतलो धागा सी बिन्यो हुयो कपड़ा की ओख बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ऊ चौकोन अऊर डबल हो, अऊर ओकी लम्बायी अऊर चौड़ायी एक एक बिल्लस की हो। ");
INSERT INTO lbm_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","अऊर ओको म चार लायीन मनि जोड़जो। पहिली लायीन म त माणिक्य, पुखराज अऊर लालड़ी हो; ");
INSERT INTO lbm_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दूसरी लायीन म मरकत, नीलमनि अऊर हीरा : ");
INSERT INTO lbm_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तीसरी लायीन म लशम, सूर्यकान्त अऊर नीलम; ");
INSERT INTO lbm_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","अऊर चौथी लायीन म फीरोज़ा, सुलैमानी मनि अऊर यशब हो; यो सब सोनो को खाना म जड़्यो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","अऊर इस्राएल लोग को टुरावों को जितनो नाम हंय उतनो मनि हो, मतलब ओको नामों की गिनती को अनुसार बारा नाम खुदें, बारा वंशों म सी एक एक को नाम एक एक मनि पर असो खुद्यो जसो छाप खोद्यो जावय हय। ");
INSERT INTO lbm_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","तब चपरास पर डोरियों को समान गूंथ्यो हुयो शुद्ध सोनो की संकली लगायजो; ");
INSERT INTO lbm_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","अऊर चपरास म सोनो की दोय कड़ियां लगवायजो, अऊर दोयी कड़ियों ख चपरास को दोयी कोनो पर लगवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","अऊर सोनो को दोयी गूंथ्यो संकली ख उन दोयी कड़ियों म जो चपरास को कोनो पर होयेंन लगवायजो; ");
INSERT INTO lbm_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","अऊर गूंथ्यो हुयो दोयी संकली को दोयी बाकी कोनो ख दोयी खानों म जड़वाय क एपोद को दोयी कन्धों को बन्धनों पर ओको आगु लगवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","तब सोनो की दोय अऊर कड़ियां बनाय क चपरास को दोयी कोनो पर, ओकी उच कोना पर जो एपोद को अन्दर की तरफ होयेंन लगायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","तब उन्को सिवाय सोनो की दोय अऊर कड़ियां बनाय क एपोद को दोयी कन्धों को बन्धनों पर, नीचो सी ओको आगु अऊर ओको जोड़ को जवर एपोद को अच्छो सी बन्यो हुयो पट्टे को ऊपर लगवायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","अऊर चपरास अपनी कड़ियों को द्वारा एपोद की कड़ियों म नीलो फीते सी बान्धी जाये या रीति ऊ एपोद को काढ़यो हुयो अच्छो सी बिन्यो हुयो पट्टे झूलतो रहेंन, अऊर चपरास एपोद पर सी अलग नहीं होन पाये। ");
INSERT INTO lbm_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","जब जब हारून पवित्र जागा म सिरयो करेंन, तब तब ऊ न्याय की चपरास पर अपनो दिल को ऊपर इस्राएलियों को नामों ख लगाये रहेंन, जेकोसी परमेश्वर को आगु उन्को याद हमेशा रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","अऊर तय न्याय की चपरास म ऊरीम अऊर तुम्मीम ख रखजो, अऊर जब जब हारून परमेश्वर को आगु आये, तब तब हि ओको दिल को ऊपर हो, यो तरह हारून इस्राएलियों लोगों लायी परमेश्वर को न्याय ख अपनो दिल को ऊपर हमेशा लगाये रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“तब एपोद को पोशाक ख पूरो नीलो रंग को बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ओकी बनावट असी हो कि ओको बीच म मुंड डालन लायी छेद हो अऊर ओको चारयी तरफ कपड़ा की कालर को जसी गोट बनायजो मतलब पोशाक को ऊ भाग फटनो नहीं पाये। ");
INSERT INTO lbm_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ओको खल्लो को घेरा म चारयी तरफ नीलो, जामुनी अऊर लाल रंग को कपड़ा को अनार जसो गोल बनायजो, अऊर ओको बीच चारयी तरफ सोनो को घन्टी लगवाना, ");
INSERT INTO lbm_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","मतलब एक सोनो को घन्टी अऊर एक अनार, लगातार योच रीति सी पोशाक को खल्लो वालो घेरा म चारयी तरफ असोच होना। ");
INSERT INTO lbm_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","अऊर हारून उच पोशाक ख याजक को काम करतो समय पहिने, कि जब जब ऊ पवित्र जागा को अन्दर परमेश्वर को आगु जायेंन यां बाहेर निकलेंन, तब तब ओको आवाज सुनायी दे, नहीं त ऊ मर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“शुद्ध सोनो की एक पट्टी बनाना, अऊर जसो मुहर म अक्षर खोद्यो जावय हय वसोच ओको पर ‘परमेश्वर लायी पवित्र अक्षर खोद्यो जाये।’ ");
INSERT INTO lbm_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","अऊर ओख नीलो फीते सी बान्धजो; अऊर ऊ फेटा को आगु को भाग पर रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ऊ हारून को मस्तक पर रहेंन, येकोलायी कि इस्राएली जो कुछ पवित्र ठहराये, मतलब जितनो पवित्र चीजो भेंट म चढ़ायो उन पवित्र चीजो को दोष हारून उठाये रहेंन, अऊर ऊ हमेशा ओको मस्तक पर रहेंन, जेकोसी परमेश्वर उन्को सी खुश रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“अंगरखा ख महीन सूती को कपड़ा चारखाना वालो बनायजो, अऊर एक फेटा भी महीन सूती कपड़ा को बनायजो, अऊर रस्सी जसो बन्यो हुयो एक कमर बन्द भी बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“तय हारून को टुरावों लायी भी कपड़ा अऊर कमर बन्द अऊर टोपियां बनायजो; यो कपड़ा भी वैभव अऊर शोभा लायी बनेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","अपनो भाऊ हारून अऊर ओको टुरावों ख योच सब कपड़ा पहिनाय क उन्को अभिषेक अऊर संस्कार करजो, अऊर उन्ख पवित्र करजो कि हि मोरो लायी याजक को काम करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","अऊर उन्को लायी सन को कपड़ा की चड्डी बनाजो जिन्कोसी उन्को शरीर झक्यो रहेंन, हि कमर सी जांघ तक लम्बी हो; ");
INSERT INTO lbm_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","अऊर जब जब हारून यां ओको टुरा मिलाप वालो तम्बू म सिरेंन, यां पवित्र जागा म याजक को काम करन को वेदी को जवर जाये, तब तब हि चड्डी ख पहिने रहेंन, नहीं त हि दोषी ठहरेंन अऊर मर जाये। यो हारून लायी अऊर ओको बाद ओको वंश लायी भी हमेशा कि विधि ठहरे। ");
INSERT INTO lbm_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“उन्ख पवित्र करन ख जो काम तोख उन को संग करनो हय कि हि मोरो लायी याजक को काम करेंन, ऊ यो हय: एक निर्दोष बछड़ा अऊर दोय निर्दोष मेंढी लेजो, ");
INSERT INTO lbm_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","अऊर अखमीरी रोटी, अऊर तेल सी सन्यो हुयो मैदा को अखमीरी सुवारी, अऊर तेल सी चुपड़ी हुयी अखमीरी पपड़ियां भी लेजो। यो सब गहूं को मैदा को बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","इन्को एक टोकनी म रख क उच टोकनी ख ओको बछड़ा अऊर उन दोयी मेंढी सहित जवर लायजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","तब हारून अऊर ओको टुरावों ख मिलाप वालो तम्बू को फाटक को जवर सी लिजाय क पानी सी धुलायजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","तब उन कपड़ा ख ले क हारून ख अंगरखा अऊर एपोद को पोशाक पहिनाजो, अऊर एपोद अऊर चपरास बान्धनो, अऊर एपोद को बनायो हुयो पट्टा भी बांधजो; ");
INSERT INTO lbm_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","अऊर ओको मुंड पर फेटा रखजो, अऊर फेटा पर पवित्र मुकुट ख रखजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","तब पवित्र तेल ले क ओको मुंड पर डाल क ओको अभिषेक करजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","तब ओको टुरावों ख जवर लिजाय क उन्को अंगरखा पहिनाजो, ");
INSERT INTO lbm_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","अऊर उन्को मतलब हारून अऊर ओको टुरावों को कमर बान्धजो अऊर उन्को मुंड पर टोपियां रखजो; जेकोसी याजक को पद पर हमेशा उन्को अधिकार रहेंन। यो तरह हारून अऊर ओको टुरावों को संस्कार करजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“तब बछड़ा ख परमेश्वर की उपस्थिति को तम्बू को आगु ले आजो। हारून अऊर ओको टुरा, बछड़ा की मुंड पर अपनो अपनो हाथ रखे, ");
INSERT INTO lbm_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","तब ऊ बछड़ा ख परमेश्वर को आगु मिलाप वालो तम्बू की फाटक पर बलिदान करजो, ");
INSERT INTO lbm_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","अऊर बछड़ा को खून म सी कुछ ले क अपनो बोट सी वेदी को सींगो पर लगाजो, अऊर शेष सब खून ख वेदी को पाये पर कुड़ाय देजो, ");
INSERT INTO lbm_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","अऊर जेको चरबी सी अंतड़ियां झकी रह्य हंय, अऊर जो झिल्ली कलेजे को ऊपर होवय हय, उन्को अऊर दोयी गुर्दो ख उन्को ऊपर चरबी सहित लेकर सब ख वेदी पर जलाजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","पर बछड़ा को मांस, अऊर खाल, अऊर गोबर, छावनी सी बाहेर आगी म जलाय देजो; कहालीकि यो पापबलि होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“फिर एक मेंढा लेजो, अऊर हारून अऊर ओको टुरा ओकी मुंड पर अपनो अपनो हाथ रखे, ");
INSERT INTO lbm_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","तब उच मेंढी ख बलि करजो, अऊर ओको खून ले क वेदी पर चारयी तरफ छिड़क देजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","तब ऊ मेंढा ख तुकड़ा तुकड़ा काटजो, अऊर ओकी अंतड़ियां अऊर पाय ख धोय क ओको तुकड़ा मुंड को संग म रखजो, ");
INSERT INTO lbm_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","अऊर पूरो मेंढा ख वेदी पर जलाजो; ऊ त परमेश्वर लायी होमबलि होयेंन; ऊ सुखदायक सुगन्ध अऊर परमेश्वर लायी हवन होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“फिर दूसरो मेंढा ख लेजो; अऊर हारून अऊर ओको टुरा ओकी मुंड पर अपनो अपनो हाथ रखे, ");
INSERT INTO lbm_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","तब ऊ मेंढा ख बलि करजो, अऊर ओको खून म सी कुछ ले क हारून अऊर ओको टुरावों को दायो कान को कोना पर, अऊर उन्को दायो हाथ अऊर दायो पाय को अंगुठा पर लगाजो, अऊर खून ख वेदी पर चारयी तरफ छिड़क देजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","फिर वेदी पर को खून अऊर अभिषेक को तेल, इन्को दोयी म सी थोड़ो थोड़ो ले क हारून अऊर ओको कपड़ा पर, अऊर ओको टुरावों अऊर उन्को कपड़ा पर भी छिड़क देजो; तब ऊ अपनो कपड़ा सहित, अऊर ओको टुरा भी अपनो अपनो कपड़ा सहित पवित्र होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","तय उच मेंढी को चरबी लेजो, अऊर मोटी पूछ को अऊर जेको चरबी सी अतड़ियां झकी रह्य हंय ओको, अऊर कलेजा पर की झिल्ली ख, अऊर चरबी सहित दोयी गुर्दां ख, अऊर दायो जांघ लेजो, कहालीकि यो पुरोहित को अभिषेक बलि को मेंढा हय। ");
INSERT INTO lbm_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","अऊर अखमीरी रोटी की टोकनी जो परमेश्वर को आगु रखी होना ओख म सी भी एक रोटी, अऊर तेल सी सान्यो हुयो मैदा को एक सुवारी, अऊर एक पपड़ी लेजो, ");
INSERT INTO lbm_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","इन सब ख हारून अऊर ओको टुरावों को हाथों म रख क हिलाये जान की भेंट ठहराय क् परमेश्वर को आगु हिलायो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","तब उन चीजो ख उन्को हाथों सी ले क होमबलि की वेदी पर जलाय देजो, जेकोसी ऊ परमेश्वर को आगु सुखदायक सुगन्ध ठहरे; ऊ परमेश्वर लायी हवन होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“फिर हारून को संस्कार को जो मेंढा होना ओकी छाती ख ले क हिलायी जान की भेंट लायी परमेश्वर को आगु लहराजो; अऊर ऊ तोरो भाग ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","हारून अऊर ओको टुरावों को संस्कार को मेंढा होना ओको म सी हिलाये जान वाली भेंट वाली छाती जो हिलायी जायेंन, अऊर उठायी जान की भेंट वाली जांघ जो उठायी जायेंन, इन दोयी ख पवित्र ठहराजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","अऊर यो हमेशा की विधि की रीति पर इस्राएलियों को तरफ सी हारून अऊर ओको टुरावों को भाग रहेंन, कहालीकि यो उठाये जान की भेंट ठहरी हंय; अऊर यो इस्राएलियों को तरफ सी उन्को मेलबलि म सी परमेश्वर लायी उठाये जान की भेंट होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“हारून को जो पवित्र कपड़ा रहेंन ऊ ओको बाद ओको टुरा अऊर नाती ख मिलतो रहे, जेको सी उन्खच दे क उन्को अभिषेक अऊर नियुक्त करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ओको टुरावों म सी जो ओको जागा पर याजक होयेंन, ऊ जब पवित्र जागा म सेवा काम करन लायी मिलाप वालो तम्बू म पहले आये, तब उन कपड़ा ख सात दिन तक पहिने रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“फिर याजक को अभिषेक-बलि को जो मेंढी होयेंन ओख लेकर ओको मांस कोयी पवित्र जागा म पकाजो; ");
INSERT INTO lbm_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","तब हारून अपनो टुरावों सहित उच मेंढी को मांस अऊर टोकनी की रोटी, दोयी ख मिलाप वालो तम्बू को फाटक पर खाये। ");
INSERT INTO lbm_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","जिन चिजों सी उन्को अभिषेक अऊर उन्ख पवित्र करन लायी प्रायश्चित करयो जायेंन उन्को त हि खाये, पर दूसरो वंश को कोयी उन्ख नहीं खान पाये, कहालीकि हि पवित्र होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","यदि अभिषेक वालो मांस यां रोटी म सी कुछ सुबेरे तक बच्यो रहेंन, त उच बच्यो हुयो ख आगी म जलाजो, ऊ खायो नहीं जाये; कहालीकि ऊ पवित्र होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“मय न तोख जो जो आज्ञा दियो हय; उन सब को अनुसार तय हारून अऊर ओको टुरावों सी करनो; अऊर सात दिन तक उन्को संस्कार विधि करतो रहजो, ");
INSERT INTO lbm_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","मतलब पापबलि को एक बछड़ा प्रायश्चित लायी हर दिन चढ़ाजो। वेदी ख भी प्रायश्चित करन को समय‍ शुद्ध करजो, अऊर ओख पवित्र करन लायी ओको संस्कार करजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिन तक वेदी लायी प्रायश्चित कर क् ओख शुद्ध अऊर पवित्र करजो, अऊर वेदी परम पवित्र ठहरेंन; अऊर जो कुछ ओको सी छूय जायेंन ऊ भी पवित्र होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“जो तोख वेदी पर हमेशा चढ़ानो होयेंन ऊ यो आय : हर दिन एक एक साल को दोय मेंढी को बच्चा चढ़ाजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक मेंढी को बच्चां ख त सुबेरे को समय, अऊर दूसरो मेंढी को बच्चां ख शाम को समय चढ़ाजो; ");
INSERT INTO lbm_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","अऊर पहिलो मेंढी को बच्चां को संग दोय लिटर को तेल सी उसन्यो हुयो एक किलो मैदा, अऊर बली लायी अंगूर को रस चढ़ाजो। ");
INSERT INTO lbm_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","अऊर दूसरो मेंढी को बच्चां ख शाम को समय चढ़ाजो, अऊर ओको संग सुबेरे की रीति अनुसार अनाज बलि अऊर अर्घ दोयी देजो, जेको सी ऊ सुखदायक सुगन्ध अऊर परमेश्वर लायी हवन ठहरे। ");
INSERT INTO lbm_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","तुम्हरो पीढ़ी सी पीढ़ी म परमेश्वर को आगु मिलाप वालो तम्बू को फाटक पर हमेशा असोच होमबलि होतो रहे; यो ऊ जागा आय जेको म मय तुम लोगों सी येकोलायी मिल्यो करूं कि तोरो सी बाते करू। ");
INSERT INTO lbm_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","मय इस्राएली लोगों सी उतच मिल्यो करूं अऊर ऊ तम्बू मोरो तेज सी पवित्र करयो जायेंन; ");
INSERT INTO lbm_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","अऊर मय मिलाप वालो तम्बू अऊर वेदी ख पवित्र करूं, अऊर हारून अऊर ओको टुरावों ख भी पवित्र करूं कि हि मोरो लायी याजक को काम करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","अऊर मय इस्राएलियों लोगों को बीच निवास करूं, अऊर उन्को परमेश्वर ठहरूं। ");
INSERT INTO lbm_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","तब हि जान लेयेंन कि मय यहोवा उन्को परमेश्वर आय, जो उन्को मिस्र देश सी येकोलायी निकाल ले आयो कि उन्को बीच निवास करूं; मयच उन्को परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“फिर धूप जलान लायी बबूल की लकड़ी की वेदी बनाजो। ");
INSERT INTO lbm_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ओकी लम्बायी एक हाथ अऊर चौड़ायी एक हाथ की हय, ऊ चौकोन हो, अऊर ओकी ऊंचायी दोय हाथ की हो, अऊर ओको सींग ओको तुकड़ा सी बनायो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","अऊर वेदी को ऊपर वालो पल्ला अऊर चारयी तरफ को बाजुवों ख अऊर सींग ख शुद्ध सोनो सी मढ़वाजो, अऊर इन्को चारयी तरफ सोनो की एक किनार बनाजो। ");
INSERT INTO lbm_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","अऊर येको किनार को नीचो येको आमने-सामने को दोयी पल्ला पर सोनो को दोय दोय कड़ा बनाय क येको दोयी तरफ लगाजो, हि कड़ा डन्डो को सहारा उठान को काम देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","डन्डो ख बबूल की लकड़ी को बनाय क उन्ख सोनो सी मढ़वाजो। ");
INSERT INTO lbm_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","अऊर तय ओको उच परदा को आगु रखजो जो गवाही चिट्ठी को सन्दूक को आगु हय, मतलब पश्चाताप वालो ढकन को आगु जो गवाही चिट्ठी को ऊपर हय, वहांच मय तोरो सी मिल्यो करूं। ");
INSERT INTO lbm_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","अऊर ओको वेदी पर हारून सुगन्धित धूप जलायो करेंन; हर दिन सुबेरे ख जब ऊ दीया ख ठीक करेंन तब ऊ धूप जलाये, ");
INSERT INTO lbm_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","अऊर शाम को समय जब हारून दीयां ख जलाये तब धूप जलायो करेंन, या धूप परमेश्वर को आगु तुम्हरो पीढ़ी पीढ़ी म हमेशा जलायो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","वा वेदी पर तुम कोयी दूसरो तरह को धूप नहीं जलाजो, अऊर नहीं ओको पर होमबलि अऊर नहीं अन्नबलि चढ़ाजो; अऊर नहीं उच पर अर्घ देजो। ");
INSERT INTO lbm_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","हारून साल म एक बार येको सींगो पर प्रायश्चित करेंन; अऊर तुम्हरी पीढ़ी पीढ़ी म साल म एक बार प्रायश्चित को पापबलि को खून सी येको पर प्रायश्चित करयो जाये; यो परमेश्वर लायी परम पवित्र हय।” ");
INSERT INTO lbm_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“जब तय इस्राएलियों लोगों की गिनती लेन लग्यो, तब गिनती को समय जेकी गिनती हुयी हो हि अपनो अपनो जीव लायी परमेश्वर ख प्रायश्चित को शुल्क दे, जेकोसी जब तय उन्की गिनती कर रह्यो हय उच समय कोयी भयानक विपत्ति उन पर नहीं आय पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","जितनो लोग गिन्यो जाये हि पवित्र जागा को शेकेल को अनुसार चांदी अरधो शेकेल दे यो शेकेल बीस गेरा को होवय हय, परमेश्वर की भेंट अरधो शेकेल हो। ");
INSERT INTO lbm_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","बीस साल को यां ओको सी अधिक अवस्था को जितनो गिन्यो जाये उन्म सी हर एक जन परमेश्वर ख भेंट दे। ");
INSERT INTO lbm_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","जब तुम्हरो जीव को पश्चाताप को निमित्त परमेश्वर कि भेंट अर्पित की जाये, तब धनी लोग अरधो शेकेल सी अधिक नहीं देयेंन; अऊर नहीं गरीब लोग ओख सी कम देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","अऊर तय इस्राएलियों सी प्रायश्चित को हिस्सा ले क मिलाप वालो तम्बू को काम म लगाजो; जेकोसी ऊ परमेश्वर को आगु इस्राएलियों को याद गार चिन्ह ठहरे, अऊर उन्को जीव को प्रायश्चित भी हो।” ");
INSERT INTO lbm_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“धोन लायी पीतल को एक गंगार बनाजो, अऊर ओको पाया भी पीतल को बनाजो। ओको मिलाप वालो तम्बू अऊर वेदी को बीच म रख क उन्म म पानी भर देजो; ");
INSERT INTO lbm_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","अऊर ओको म हारून अऊर ओको टुरा अपनो अपनो हाथ पाय धोयो करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","जब जब हि मिलाप वालो तम्बू म सिरेंन तब तब हि हाथ पाय पानी सी धोये, नहीं त मर जायेंन; अऊर जब जब हि वेदी को जवर सेवा करन वेदी को जवर आये, मतलब परमेश्वर लायी हवन जलावन ख आये तब तब हि हाथ पाय धोये, असो नहीं होय कि मर जाये। ");
INSERT INTO lbm_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","यो हारून अऊर ओको पीढ़ी पीढ़ी को वंश लायी हमेशा की विधि ठहरे।” ");
INSERT INTO lbm_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“तय उत्तम सी उत्तम सुगन्धित मसाला लावो, मतलब पवित्र जागा को शेकेल को अनुसार पाच सौ शेकेल अपनो आप निकल्यो हुयो गन्धरस, अऊर ओको अरधो, मतलब ढायी सौ शेकेल सुगन्धित कलमी, अऊर ढायी सौ शेकेल सुगन्धित लुभान, ");
INSERT INTO lbm_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","पवित्र जागा को अनुसार छय किलो तेजपान, अऊर चार लिटर जैतून को तेल लेजो ");
INSERT INTO lbm_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","उन्को सी अभिषेक को पवित्र तेल, मतलब सुगन्ध की रीति सी तैयार करयो हुयो सुगन्धित तेल बनायजो; यो अभिषेक को पवित्र तेल ठहरे। ");
INSERT INTO lbm_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","अऊर ओको सी मिलाप वालो तम्बू को, अऊर गवाही चिट्ठी को सन्दूक पर यो तेल ख डालेंन, ");
INSERT INTO lbm_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","अऊर पूरो सामान सहित मेज को, अऊर सामान सहित दीया को, अऊर धूप वेदी को ");
INSERT INTO lbm_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","अऊर पूरो सामान सहित होमबलि वेदी को, अऊर पाये सहित गंगार को सजायजो, ");
INSERT INTO lbm_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","अऊर उन्ख पवित्र करजो, जेकोसी हि परम पवित्र ठहरेंन; अऊर जो कुछ उन्को सी छुय जायेंन ऊ पवित्र होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","तय हारून को ओको टुरावों को संग नियुक्त करजो, अऊर यो तरह उन्ख मोरो लायी याजक को काम करन लायी पवित्र करजो। ");
INSERT INTO lbm_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","अऊर इस्राएलियों लोगों ख मोरी यो आज्ञा सुनाजो, ‘यो तेल तुम्हरो पीढ़ी पीढ़ी म मोरो लायी पवित्र करयो हुयो तेल होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","यो कोयी आदमी को शरीर पर नहीं डालो जाये, अऊर मिलावट म ओको समान अऊर कुछ नहीं बनाजो; यो पवित्र हय, यो तुम्हरो लायी भी पवित्र होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जो कोयी येको समान कुछ बनाये, यां जो कोयी येको म सी कुछ पराये कुल वालो पर लगाये, ऊ अपनो लोगों म नहीं गिन्यो जाये’।” ");
INSERT INTO lbm_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","फिर परमेश्वर न मूसा सी कह्यो, “बोल, नखी अऊर कुन्दरू, यो सुगन्ध द्रव्य शुद्ध लुभान सहित ले लेजो, हि सब बराबर तौल की मात्रा हो, ");
INSERT INTO lbm_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","अऊर इन्को धूप मतलब नमक मिलाय क सुगन्ध की रीति को अनुसार शुद्ध अऊर पवित्र सुगन्धित मसाला सी बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","फिर ओको म सी कुछ पीस क बारीक क डालजो, तब ओको म सी कुछ मिलाप वालो तम्बू म साक्षी पत्र को आगु, जित पर मय तोरो सी मिल्यो करूं, रखजो; ऊ तुम्हरो लायी परम पवित्र होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","जो धूप तय बनायजो, मिलावट म ओको समान तुम लोग अपनो लायी अऊर कुछ नहीं बनायजो; ऊ तुम्हरो आगु परमेश्वर लायी पवित्र होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","जो कोयी सूंघन लायी ओको समान कुछ बनाये ऊ अपनो लोगों म न गिन्यो जाये।” ");
INSERT INTO lbm_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“सुन, मय ऊरी को टुरा बसलेल को, जो हूर को पोता अऊर यहूदा को वंश को हय, नाम ले कर बुलावय हय। ");
INSERT INTO lbm_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","अऊर मय ओको परमेश्वर की आत्मा सी जो बुद्धि, हुनर, ज्ञान, अऊर सब तरह को काम की समझ देनो वालो आत्मा हय, परिपूर्ण करय हय, ");
INSERT INTO lbm_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","जेकोसी ऊ कारीगरी को काम बुद्धि सी निकाल क जिन्ख ऊ सोनो, चांदी, अऊर पीतल को बर्तन पर बनाय सकेंन, ");
INSERT INTO lbm_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","अऊर जड़न लायी मनि काट सके, अऊर लकड़ी पर नकाशी काम भी कर सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","अऊर सुन, मय दान को वंश वालो अहीसामाक को टुरा ओहोलीआब ख ओको संग कर देवय हय; बल्की जितनो बुद्धि मान हय उन सब को दिल म मय बुद्धि देवय हय, जेकोसी जितनो चीजो की आज्ञा मय न तोख दियो हय उन सब ख हि बनाये; ");
INSERT INTO lbm_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","मतलब मिलाप वालो तम्बू, अऊर साक्षी पत्र को सन्दूक अऊर उच पर को प्रायश्चित वालो ढकन अऊर तम्बू को पूरो सामान, ");
INSERT INTO lbm_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","अऊर सामान सहित मेज, अऊर पूरो सामान सहित शुद्ध सोनो को दीया, अऊर धूप जलान की वेदी, ");
INSERT INTO lbm_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","अऊर पूरो सामान सहित होमबलि वेदी, अऊर पाये सहित गंगार, ");
INSERT INTO lbm_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","अऊर बुन्यो हुयो धागा को कपड़ा, अऊर याजक हारून को याजक वालो काम को पवित्र कपड़ा, अऊर ओको टुरावों को कपड़ा, जिन्ख हि याजक को कार्य करतो समय पहिनेंन, ");
INSERT INTO lbm_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अऊर अभिषेक को तेल, अऊर पवित्र जागा लायी सुगन्धित धूप, इन सब ख हि उन सब आज्ञावों को अनुसार बनाये जो मय न तोरो दियो हंय।” ");
INSERT INTO lbm_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“तय इस्राएलियों लोग सी यो भी कहजो, ‘निश्चय तुम मोरो आराम दिनों ख मनाजो, कहालीकि तुम्हरो पीढ़ी पीढ़ी म मोरो अऊर तुम लोगों को बीच यो एक चिन्ह ठहरो हय, जेकोसी तय यो बात जान रख्यो कि परमेश्वर हमरो पवित्र कर्ता हय। ");
INSERT INTO lbm_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","यो तरह तय आराम दिन ख मनाजो, कहालीकि ऊ तुम्हरो लायी पवित्र ठहरो हय; जो ओको अपवित्र करेंन ऊ निश्चय मार डाल्यो जाये : जो कोयी उच दिन म कुछ काम काज करेंन ऊ अपनो लोगों को बीच सी निकाल दियो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","छय दिन त काम-काज करयो जाये, पर सातवों दिन परम पवित्र को दिन अऊर परमेश्वर लायी पवित्र हय; येकोलायी जो कोयी आराम को दिन म कुछ काम-काज करेंन ऊ निश्चय मार डाल्यो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","येकोलायी इस्राएली आराम दिन ख मानो करेंन, बल्की पीढ़ी पीढ़ी म ओको हमेशा की वाचा को बारे जान क मानो करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ऊ मोरो अऊर इस्राएलियों को बीच हमेशा एक चिन्ह रहेंन, कहालीकि छय दिन म परमेश्वर न आसमान अऊर धरती ख बनायो, अऊर सातवों दिन आराम कर क् अपनो जीव ख शान्त करयो’।” ");
INSERT INTO lbm_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","जब परमेश्वर मूसा सी सीनै पहाड़ी पर असी बात कर चुक्यो, तब ओन ओको अपनी बोट सी लिखी हुयो गवाही चिट्ठी देन वालो गोटा की दोयी पट्टियां दियो। ");
INSERT INTO lbm_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","जब लोगों न देख्यो कि मूसा ख पहाड़ी सी उतरन म बहुत देर होय रह्यो हय, तब हि हारून को जवर जमा होय क कहन लग्यो, “अब हमरो लायी भगवान बनो, जो हमरो आगु आगु चलेंन; कहालीकि उच आदमी मूसा ख जो हम्ख मिस्र देश सी निकाल ले आयो हय, हम नहीं जानय कि का भयो?” ");
INSERT INTO lbm_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","हारून न उन्को सी कह्यो, “तुम्हरो पत्नियों अऊर टुरा टुरियों को कानों म सोनो की जो बालियां हंय उन्ख उतारो, अऊर मोरो जवर ले आवो।” ");
INSERT INTO lbm_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","तब तब लोगों न उन्को कानों सी सोनो की बालियां ख उतारयो, अऊर हारून को जवर ले आये। ");
INSERT INTO lbm_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","हारून न उन्को हाथ सी लियो, अऊर एक बछड़ा की मूर्ति ढाल क बनायो, ओन ओको साचा म ढाल्यो। तब लोग कहन लग्यो, “हे इस्राएल समाज, यो हय तोरो ईश्वर जो तोख मिस्र देश सी निकाल लायो हय, ऊ योच आय।” ");
INSERT INTO lbm_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","यो देख क् हारून न ओको आगु एक वेदी बनायी; अऊर या प्रचार करयो, “कल परमेश्वर लायी त्यौहार होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","अऊर दूसरो दिन लोगों न सुबेरे ख उठ क होमबलि चढ़ाये, अऊर मेलबलि ले आये; तब बैठ क खाये पीये, अऊर उठ क मौज मस्ती करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तब परमेश्वर न मूसा सी कह्यो, “नीचो उतर जा, कहालीकि तोरी प्रजा को लोग, जिन्ख तय मिस्र देश सी निकाल लायो हय, हि भ्रष्ट होय गयो हंय; ");
INSERT INTO lbm_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","अऊर जेको रस्ता पर चलन की आज्ञा मय न उन्को दियो होती ओको तुरतच छोड़ क उन्न एक बछड़ा की मूर्ती बनाय लियो, तब ओख दण्डवत करयो, अऊर ओको लायी बलिदान भी चढ़ायो, अऊर यो कह्यो, ‘हे इस्राएलियों समाज, तुम्हरो ईश्वर जो तुम्ख मिस्र देश सी छुड़ाय ले आयो हय ऊ योच आय’।” ");
INSERT INTO lbm_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","तब परमेश्वर न मूसा सी कह्यो, “मय न इन लोगों ख देख्यो हय, अऊर सुन, हि हठीलो हंय। ");
INSERT INTO lbm_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","अब मोख मत रोख, मोरो कोप उन पर भड़क उठ्यो हय जेकोसी मय उन्ख भस्म करूं; पर तोरो सी एक बड़ो राष्ट्र बनाऊं।” ");
INSERT INTO lbm_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तब मूसा अपनो परमेश्वर यहोवा ख यो कह्य क् बिनती करन लग्यो, “हे परमेश्वर, तोरो कोप अपनी प्रजा पर कहाली भड़क्यो हय जेख तय बड़ी सामर्थ अऊर बलवन्त हाथ को द्वारा मिस्र देश सी निकाल लायो हय? ");
INSERT INTO lbm_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिस्र देश को लोग यो कहाली कहनो पाये, ‘ऊ उन्को बुरो अभिप्राय सी मतलब पहाड़ी म घात कर क् जमीन पर सी मिटाय डालन की मनसा सी निकाल ले गयो?’ तय भड़क्यो हुयो गुस्सा ख शान्त कर, अऊर अपनो लोगों की हानि को बिचार ख छोड़ दे। ");
INSERT INTO lbm_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","अपनो सेवक अब्राहम, इसहाक, अऊर याकूब ख याद कर जिन्कोसी तय न अपनीच कसम खाय क कह्यो होतो, ‘मय तुम्हरो वंश ख आसमान को तारा को समान बहुत करूं, अऊर यो पूरो देश जिन्की मय न बात की हय तुम्हरो वंश ख देऊं कि हि ओको अधिकारी हमेशा बन्यो रहेंन’।” ");
INSERT INTO lbm_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तब अपनो लोगों की जो हानि परमेश्वर करन वालो होतो ओको बिचार ओन छोड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","तब मूसा मुड क साक्षी की दोयी तक्तां ख हाथ म लियो हुयो पहाड़ी सी उतर गयो। उन तक्तां को इत अऊर उत दोयी तरफ लिख्यो हुयो होतो, ");
INSERT INTO lbm_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","अऊर हि पट्टियां परमेश्वर कि बनायी हुयी होती, अऊर उन पर जो खोद क लिख्यो हुयो होतो ऊ परमेश्वर को लिख्यो हुयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","जब यहोशू ख लोगों क् शोर को आवाज सुनायी पड़्यो, तब ओन मूसा सी कह्यो, “छावनी म युद्ध को आवाज सुनायी दे रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मूसा न कह्यो, “यो जो आवाज हय ऊ नहीं त जितन वालो को आय, अऊर नहीं हारन वालो को आय; मोख त गीत को आवाज सुनायी पड़य हय।” ");
INSERT INTO lbm_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","छावनी को जवर आतोच मूसा ख ऊ बछड़ा अऊर नाचनो दिखायी पड़्यो, तब मूसा को गुस्सा भड़क उठ्यो, अऊर ओन पट्टियों ख अपनो हाथ सी पहाड़ी को खल्लो पटक क तुकड़ा तुकड़ा कर दियो। ");
INSERT INTO lbm_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","तब ओन उन्को बनाये हुयो बछड़ा ख ले कर आगी म डाल क् जलाय दियो। अऊर पीस क चूर चूर क डाल्यो हय, अऊर पानी म डाल दियो, अऊर इस्राएली लोग ख पिलायो। ");
INSERT INTO lbm_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","तब मूसा हारून सी कहन लग्यो, “इन लोगों न तोरो संग का करयो कि तय न उन्ख इतनो बड़ो घोर पाप म फसायो?” ");
INSERT INTO lbm_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारून न उत्तर दियो, “हे स्वामी तोरो गुस्सा नहीं भड़के; तय त इन लोगों ख जानयच हय कि हि बुरायी म मन लगाये रह्य हंय।” ");
INSERT INTO lbm_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","अऊर उन्न मोरो सी कह्यो, हमरो लायी देवता बनाव जो हमरो आगु आगु चले; कहालीकि ऊ आदमी मूसा ख, जो हम्ख मिस्र देश सी छुड़ाय लायो हय, हम नहीं जानजे कि का भयो? ");
INSERT INTO lbm_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","तब मय न उन्को सी कह्यो, “जेको जेको जवर सोनो को जेवर होना, हि उन ख उतार लाये; अऊर जब उन्न मोरो ख ऊ दियो, मय न उन्ख आगी म डाल दियो, तब यो बछड़ा बन गयो।” ");
INSERT INTO lbm_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","जब मूसा देख्यो कि लोग हारून न लोगों ख नियंत्रन सी बाहेर कर दियो अऊर अपनो दुश्मनों को आगु खुद ख हसी मजाक को पात्र बन गयो। ");
INSERT INTO lbm_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","उन्ख अनियंत्रित देख क मूसा न छावनी की फाटक पर खड़ो होय क कह्यो, “जो कोयी परमेश्वर को तरफ को हय ऊ मोरो जवर आये;” तब पूरो लेवीय वंश को ओको जवर जमा भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","मूसा न उन्को सी कह्यो, “इस्राएल को परमेश्वर यहोवा यो कह्य हय कि अपनी अपनी कमर म तलवार बान्ध क छावनी को एक तम्बू सी दूसरो तम्बू पर जाय क भाऊवों, संगियों, अऊर पड़ोसियों ख मार डालो।” ");
INSERT INTO lbm_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मूसा को या वचन को अनुसार लेवियों न करयो; अऊर ऊ दिन तीन हजार को लगभग लोग मारयो गयो। ");
INSERT INTO lbm_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","तब मूसा न कह्यो, “अज को दिन परमेश्वर लायी अपनो याजक पद को अभिषेक करो, बल्की अपनो अपनो टुरावों अऊर भाऊवों को खिलाफ होय क असो करयो जेको सी ऊ अज तुम्ख आशीष दे।” ");
INSERT INTO lbm_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","दूसरो दिन मूसा न लोगों सी कह्यो, “तय न बड़ोच पाप करयो हय। अब मय परमेश्वर को जवर ऊपर जाऊं; सम्भव हय कि मय तुम्हरो पाप को प्रायश्चित कर सकू।” ");
INSERT INTO lbm_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","तब मूसा परमेश्वर को जवर जाय क कहन लग्यो, “हाय, हाय, उन लोगों न सोनो को देवता बनाय क बड़ोच घोर पाप करयो हय। ");
INSERT INTO lbm_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","अब तय उन्को पाप माफ कर नहीं त अपनी लिख्यो हुयी किताब म सी मोरो नाम ख काट दे।” ");
INSERT INTO lbm_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","परमेश्वर न मूसा सी कह्यो, “जिन्कोसी मोरो खिलाफ पाप करयो हय उच नाम को मय अपनी किताब म सी काट देऊं। ");
INSERT INTO lbm_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","अब तुम जाय क उन लोगों ख ऊ जागा म ले चल जेकी चर्चा मय न तोरो सी करी होती; देख, मोरो स्वर्गदूत तोरो आगु आगु चलेंन। पर जो दिन मय सजा देन लगूं ऊ दिन उन्ख यो पाप को भी सजा देऊं।” ");
INSERT INTO lbm_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","परमेश्वर न उन लोगों पर विपत्ति डाली, कहालीकि हारून को बनायो हुयो बछड़ा ख उन्नच बनायो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","तब परमेश्वर न मूसा सी कह्यो, “तय उन लोगों ख जिन्ख मिस्र देश सी छुड़ाय क लायो हय संग ले क ऊ देश ख जा, जेको बारे मय न अब्राहम, इसहाक, अऊर याकूब सी कसम खाय क कह्यो होतो कि मय ओख तोरो वंश ख देऊं। ");
INSERT INTO lbm_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","अऊर मय तोरो आगु आगु एक दूत ख भेजूं, अऊर कनानी, एमोरी, हित्ती, परिज्जी, हिब्बी अऊर यबूसी ख निकाल देऊं। ");
INSERT INTO lbm_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","तुम लोग ऊ देश ख जावो जेको म दूध अऊर शहेद की धारा बहय हय; पर तुम जिद्दी हो, यो वजह मय तुम्हरो बीच म होय क नहीं चलूं, असो नहीं हो कि मय रस्ता म तुम्हरो अन्त कर डालूं।” ");
INSERT INTO lbm_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","यो बुरो समाचार सुन क हि लोग विलाप करन लगे; अऊर कोयी अपनो जेवर पहिने हुयो नहीं रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","कहालीकि परमेश्वर न मूसा सी कह्यो दियो होतो, “इस्राएली लोगों ख मोरो यो वचन सुना, ‘तुम लोग त जिद्दी हय; यदि मय पल भर लायी तुम्हरो बीच होय क चलू, त तुम्हरो अन्त कर डालूं। येकोलायी अब अपनो अपनो जेवर अपनो आंग सी उतार देवो कि मय जान सकू कि तुम्हरो संग का करनो चाहिये’।” ");
INSERT INTO lbm_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","येकोलायी इस्राएली होरेब पहाड़ी सी ले क आगु तक अपनो जेवर उतारयो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मूसा तम्बू ख डेरा सी बाहेर, ओको सी कुछ दूरी पर खड़ो करत होतो। ऊ ओख मिलाप वालो तम्बू कहत होतो। प्रभु को खोजी मिलाप वालो तम्बू ख जो डेरा को बाहेर होतो, जात होतो। ");
INSERT INTO lbm_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","जब जब मूसा तम्बू को जवर जावय हय, तब तब सब लोग उठ क अपनो अपनो डेरा को फाटक पर खड़ो होय जावय, अऊर जब तक मूसा ऊ तम्बू म सिरत नहीं होतो तब तक ओकी तरफ ताकतो रहत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","जब मूसा ऊ तम्बू म सिरयो करत होतो, जब बादर को खम्बा उतर क तम्बू को फाटक पर ठहर जावय होतो, अऊर परमेश्वर मूसा सी बाते करत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","अऊर सब लोग जब बादर को खम्बा ख तम्बू को फाटक पर खड़ो देखतो होतो, तब उठ क अपनो अपनो डेरा को फाटक पर सी दण्डवत करत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","अऊर परमेश्वर मूसा सी यो तरह आमने-सामने बाते करत होतो, जेको तरह कोयी अपनो भाऊ बहिन सी बाते करो। अऊर मूसा त डेरा म लौट आवत होतो, पर यहोशू नाम को एक जवान, जो नून को टुरा अऊर मूसा को सेवक होतो, ऊ तम्बू म सी नहीं निकलत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मूसा न परमेश्वर सी कह्यो, “देख, तय मोरो सी कह्य हय, इन लोगों ख ले जा; पर तय न मोख नहीं बतायो कि तय मोरो संग कौन ख भेजजो। तय न कह्यो, मय तोख नाम सी जानु हय। अऊर तोरो पर मोरी अनुग्रह की नजर हय। ");
INSERT INTO lbm_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","अऊर अब यदि मोरो पर तोरो अनुग्रह की नजर होना, त मोख अपनो मार्ग समझाय दे, जेकोसी जब मय तोरो ज्ञान पाऊं तब तोरो अनुग्रह की नजर मोरो पर बनी रहेंन। फिर यो भी ध्यान रख कि या लोग तोरी प्रजा आय।” ");
INSERT INTO lbm_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","परमेश्वर न कह्यो, “मय खुद तोरो संग चलूं अऊर तोरो ख आराम देऊं।” ");
INSERT INTO lbm_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","मूसा न ओको सी कह्यो, “यदि तय खुद नहीं चलजो, त हम्ख यहां सी आगु मत ले जा। ");
INSERT INTO lbm_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","यो कसो जान्यो जायेंन कि तोरी अनुग्रह की नजर मोरो पर अऊर अपनी प्रजा पर हय? का येकोसी नहीं कि तय हमरो संग संग चले, जेकोसी मय अऊर तोरी प्रजा को लोग धरती पर को सब लोगों सी अलग ठहरेंन?” ");
INSERT INTO lbm_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","परमेश्वर न मूसा सी कह्यो, “मय यो काम भी, जेकी चर्चा तय न करी हय, मय करूं; कहालीकि मोरो अनुग्रह की नजर तोरो पर हय, अऊर तोरो नाम मोरो मन म बस्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","मूसा न कह्यो, “मोख अपनो महिमा को तेज दिखाय दे।” ");
INSERT INTO lbm_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ओन कह्यो, “मय तोरो जवर होय क चलतो हुयो तोख अपनी पूरी भलायी दिखाऊं, अऊर तोरो जवर परमेश्वर को नाम को प्रचार करूं; अऊर जेको पर मय अनुग्रह करनो चाहूं ओकोच पर दया करूं।” ");
INSERT INTO lbm_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","तब ओन कह्यो, “तय मोरो मुख को दर्शन नहीं कर सकय; कहालीकि आदमी मोरो मुख को दर्शन कर क् जीन्दो नहीं रह्य सकय।” ");
INSERT INTO lbm_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","तब परमेश्वर न कह्यो, “सुन, मोरो जवर एक जागा हय, यहां तय ऊ चट्टान पर खड़ो हो; ");
INSERT INTO lbm_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","अऊर जब तक मोरी महिमा को तेज तोरो आगु चलतो रहेंन, तब तक मय तोख चट्टान की फट म रखूं अऊर जब तक मय तोरो आगु सी होय क नहीं निकल जाऊं तब तक अपनो हाथ सी तोख झाक्यो रहूं; ");
INSERT INTO lbm_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","फिर मय अपनो हाथ उठाय लेऊं, तब तय मोरी पीठ ख देखजो; पर मोरो मुख नहीं दिखायी देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","फिर परमेश्वर न मूसा सी कह्यो, “पहिली पट्टियों को जसो गोटा की दोय अऊर पट्टियों खोद ख ले; तब जो वचन उन पहिली पट्टियों पर लिख्यो होतो, जिन्ख तय न तोड़ डाल्यो, हिच वचन मय उन पट्टियों पर भी लिखूं। ");
INSERT INTO lbm_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","सुबेरे तैयार रहजो, अऊर सुबेरे ख सीनै पहाड़ी पर चढ़ क ओकी सेंडी पर मोरो आगु खड़ो होनो। ");
INSERT INTO lbm_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तोरो संग कोयी नहीं चढ़ पाये, बल्की पहाड़ी भर कोयी आदमी कहीं दिखायी नहीं दे; अऊर नहीं शेरी मेंढी अऊर गाय बईल भी पहाड़ी को आगु चरन पायेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","तब मूसा न पहली पट्टियों को समान दोय अऊर पट्टियों खोदी; अऊर सुबेरे उठ क अपनो हाथ म गोटा की हि दोयी पट्टियों ले क परमेश्वर की आज्ञा को अनुसार सीनै पहाड़ी पर चढ़ गयो। ");
INSERT INTO lbm_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तब परमेश्वर न बादर म उतर क ओको संग उत खड़ो होय क परमेश्वर न अपनो नाम को बल्की यहोवा को नाम को प्रचार करयो। ");
INSERT INTO lbm_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","परमेश्वर ओको आगु सी निकल्यो अऊर ओन प्रचार करयो, “परमेश्वर! परमेश्वर! ऊ दयालु अऊर अनुग्रहकारी, विलम्ब-क्रोधी, अऊर धीरजवन्त, सच्चो परमेश्वर हय। ");
INSERT INTO lbm_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारों पीढ़ियों पर करुना करन वालो, अधर्म, अपराध अऊर पाप ख माफ करन वालो हय, पर ऊ दोषी ख कोयी तरह निर्दोष नहीं ठहरायेंन; ऊ पूर्वजों को अधर्म की सजा तीसरी अऊर चौथी पीढ़ी तक सन्तान अऊर आवन वाली सन्तान ख देतो रहू हय।” ");
INSERT INTO lbm_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तब मूसा न तुरतच धरती को तरफ झुक क प्रभु ख दण्डवत करयो। ");
INSERT INTO lbm_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","अऊर मूसा न कह्यो, “हे स्वामी, यदि मय न तोरी अनुग्रह की नजर हासिल करी हय, त मय बिनती करू हय, स्वामी, यदि हठीलो लोग हय, त भी तय हमरो बीच म होय क चल। हमरो अधर्म ख, हमरो पाप ख माफ कर अऊर हम्ख अपनी निज सम्पत्ति बनाव।” ");
INSERT INTO lbm_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ओन कह्यो, “देख, मय एक वाचा बान्धू हय। मय तोरो सब लोगों को आगु मय असो आश्चर्यपूर्ण कर्म करूं, जो पूरी धरती पर, पूरो राष्ट्रों म कभी नहीं करयो गयो। जिन लोगों को बीच म तय हय, हि सब परमेश्वर को कार्य ख देखेंन; ऊ आतंकमय कार्य हय, जेख मय तोरो लायी करूं। ");
INSERT INTO lbm_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","जो आज्ञा मय तुम्ख देऊ हय, ओको पालन करजो। देख, मय तोरो आगु सी एमोरी, कनानी, हित्ती, परिज्जी, हिव्वी, अऊर यबूसी जातियों ख निकाल देऊं। ");
INSERT INTO lbm_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","येकोलायी सावधान रहजो कि जो देश म तय जान वालो हय ओको निवासियों सी वाचा मत बान्धजो; कहीं असो नहीं होय कि ऊ तोरो लायी फन्दा बन जाये। ");
INSERT INTO lbm_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","बल्की उन्की वेदियों ख गिराय देजो, उन्की खम्भा ख तोड़ डालजो, अऊर उन्की अशेरा नाम की मूर्तियों ख तोड़ डालजो; ");
INSERT INTO lbm_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","कहालीकि तुम्ख कोयी दूसरो ख ईश्वर कर क् दण्डवत करन की आज्ञा नहाय, कहालीकि परमेश्वर जिन्को नाम जलनशील हय, जर क उठन वालो परमेश्वर आय, ");
INSERT INTO lbm_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","असो न होय कि तय ऊ देश को निवासियों सी बातचीत करे। असो नहीं हो कि जब हि अपनो देवतावों को व्यभिचार करेंन, अऊर वेश्या को जसो बर्ताव करेंन, अपनो देवतावों ख बलि चढ़ाये अऊर कोयी तोख नेवता देवय तब तय ओकी बली को मांस खाये। ");
INSERT INTO lbm_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","अऊर तय उन्की टुरियों ख अपनो टुरावों लायी लाये, जो मोरो टुरा को प्रति विश्वासघात होयेंन अऊर उन्को मूर्ती पूजक देवतावों की पूजा करन लायी प्रेरित करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“तय देवतावों की मूर्तियां ढाल क मत बनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“अखमीरी रोटी को त्यौहार मनाजो। ओको म मोरी आज्ञा को अनुसार आबीब को महीना को उचित समय पर सात दिन तक अखमीरी रोटी खायो करजो; कहालीकि तय मिस्र देश सी आबीब को महीने म निकल क आयो।” ");
INSERT INTO lbm_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","हर एक पहिलौठा मोरो आय; अऊर का बछड़ा, का मेम्ना, तोरो जनावरों म सी जो नर पहिलौठा होना हि सब मोरोच आय। ");
INSERT INTO lbm_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गधी को पहिलौठा को बदला मेम्ना दे क ओख छुड़ायजो, यदि तय ओख छुड़ावनो नहीं चाहवय त ओकी गर्दन तोड़ देजो। पर अपनो सब पहिलौठा टुरावों ख बदला दे क छुड़ायजो। मोख कोयी खाली हाथ अपनो मुंह मत दिखाये। ");
INSERT INTO lbm_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“छय दिन त मेहनत करजो, पर सातवों दिन आराम करजो; बल्की नांगर जोतन अऊर फसल काटतो समय म भी आराम करजो। ");
INSERT INTO lbm_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","अऊर हप्ता को त्यौहार मनायजो जो पहिली गहूं की फसल को त्यौहार कहलावय हय, अऊर साल को आखरी म जमा करन को भी त्यौहार मनायजो। ");
INSERT INTO lbm_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","साल म तीन बार तोरो सब आदमी इस्राएल को परमेश्वर प्रभु यहोवा ख अपनो मुंह दिखाये। ");
INSERT INTO lbm_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","कहालीकि मय दूसरो राष्ट्रों ख तोरो आगु सी निकाल क तोरी सीमावों ख बढ़ाऊं; अऊर जब तय अपनो परमेश्वर यहोवा ख अपनो मुंह दिखावन लायी साल म तीन बार आयो करजो, तब कोयी तोरी जमीन को लालच नहीं करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“मोरो बलिदान को खून ख खमीर सहित मत चढ़ायजो, अऊर नहीं फसह को त्यौहार को बलिदान म सी कुछ सुबेरे तक रहन देजो। ");
INSERT INTO lbm_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","अपनी जमीन की पहिली फसल को पहिलो हिस्सा अपनो परमेश्वर यहोवा को भवन म ले आजो। शेरी को बच्चा ख ओकी माय को दूध म मत पकायजो।” ");
INSERT INTO lbm_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","तब परमेश्वर न मूसा सी कह्यो, “यो वचन लिख ले; कहालीकि योच वचनों को अनुसार मय न तोरो अऊर इस्राएल को संग वाचा बान्धी हय।” ");
INSERT INTO lbm_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मूसा वहां परमेश्वर को संग चालीस दिन अऊर रात; अऊर तब तक नहीं त ओन रोटी खायी अऊर नहीं पानी पीयो। अऊर ओन उन पट्टियों पर वाचा को वचन मतलब दस आज्ञाये लिख दियो। ");
INSERT INTO lbm_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","जब मूसा गवाही की दोयी पट्टियां हाथ म लियो हुयो सीनै पहाड़ी सी उतर रह्यो होतो तब परमेश्वर को संग बाते करन को वजह ओको चेहरा चमकत होतो, पर ऊ यो नहीं जानत होतो कि ओको चेहरा चमक रह्यो हंय। ");
INSERT INTO lbm_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जब हारून अऊर सब इस्राएली लोगों न मूसा ख देख्यो कि ओको चेहरा चमक रह्यो होतो, तब हि ओको जवर जान सी डर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","तब मूसा न उन्ख बुलायो; अऊर हारून मण्डली को पूरो मुखियावों सहित ओको जवर आयो, अऊर मूसा उन्को सी बाते करन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","येको बाद सब इस्राएली लोग जवर आयो, अऊर जितनी आज्ञाये परमेश्वर न सीनै पहाड़ी पर ओको संग बात करतो समय दी होती, हि सब ओन उन्ख बतायी। ");
INSERT INTO lbm_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","जब तक मूसा उन्को सी बात नहीं कर चुक्यो तब तक अपनो मुंह पर गमछा झाक्यो रह्यो; ");
INSERT INTO lbm_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","पर जब जब मूसा अन्दर परमेश्वर सी बात करन ख ओको आगु जात होतो, तब तब ऊ ऊ गमछा ख उतारयो हुयो रहत होतो; फिर बाहेर आय क जो जो आज्ञा ओख मिलत होती ओख इस्राएलियों ख कह्य देत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएली लोग मूसा को चेहरा देखत होतो कि ओको सी चमक निकलत होती; अऊर जब तक ऊ परमेश्वर सी बात करन ख अन्दर नहीं जात होतो तब तक ऊ ऊ गमछा ख डाल्यो रहत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मूसा न इस्राएलियों की पूरी मण्डली ख जमा कर क् उन्को सी कह्यो, “जिन कामों ख करन की आज्ञा परमेश्वर न दियो हय हि या हंय। ");
INSERT INTO lbm_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","छय दिन त काम-काज करयो जाये, पर सातवों दिन तुम्हरो लायी पवित्र अऊर परमेश्वर लायी परम आराम को दिन ठहरे; ओको म जो कोयी काम काज करेंन ऊ मार डाल्यो जाये; ");
INSERT INTO lbm_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","बल्की आराम को दिन तुम अपनो अपनो घरों म आगी तक मत जलाजो।” ");
INSERT INTO lbm_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","फिर मूसा न इस्राएलियों की सारी मण्डली सी कह्यो, “जो बात की आज्ञा परमेश्वर न दी हय वा या आय। ");
INSERT INTO lbm_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","तुम्हरो जवर सी परमेश्वर लायी भेंट लियो जाये, मतलब जितनो अपनी इच्छा सी देजो चाहेंन हि परमेश्वर की भेंट कर क् या चिजे ले आये; मतलब सोनो, चांदी, पीतल; ");
INSERT INTO lbm_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीलो, जामुनी अऊर लाल रंग को कपड़ा, पतलो सूत सी बुन्यो हुयो कपड़ा;‍ शेरी को बाल, ");
INSERT INTO lbm_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","लाल रंग सी रंगी हुयी मेंढा की खाल, सुइसों की खाल; बबूल की लकड़ी, ");
INSERT INTO lbm_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","उजाड़ो देन लायी तेल, अभिषेक को तेल अऊर धूप लायी सुगन्धित मसाले, ");
INSERT INTO lbm_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","तब एपोद अऊर चपरास लायी सुलैमानी गोटा अऊर जड़न लायी मनि। ");
INSERT INTO lbm_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“जो बुद्धिमान कारागिर व्यक्ति तुम्हरो बीच म हंय, हि आये अऊर प्रभु की आज्ञा अनुसार या चिजें बनाये, रहन की जागा। ");
INSERT INTO lbm_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","यानेकि तम्बू, अऊर झाकन समेत निवास, अऊर ओकी आकड़ा, छड़, बेंड़ा, खम्बा अऊर तक्ता; ");
INSERT INTO lbm_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","तब डन्डो सहित सन्दूक, अऊर प्रायश्चित को ढक्कन, अऊर बीच वालो परदा; ");
INSERT INTO lbm_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","डन्डो अऊर सब सामान समेत मेज, अऊर भेंट की रोटियां; ");
INSERT INTO lbm_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","सामान अऊर दीपकों समेत उजाड़ो देन वालो दीया, अऊर उजाड़ो देन लायी तेल; ");
INSERT INTO lbm_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","डन्डों समेत धूपवेदी, अभिषेक को तेल, सुगन्धित धूप, अऊर निवास को फाटक को परदा; ");
INSERT INTO lbm_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","पीतल की जाली, डन्डो आदि पूरो सामान सहित होमबलि वेदी, पाय सहित गंगार; ");
INSERT INTO lbm_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","खम्बा अऊर उन्को तक्ता सहित आंगन को परदा, अऊर आंगन को फाटक को परदा; ");
INSERT INTO lbm_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","निवास अऊर आंगन दोयी को खूटा, अऊर रस्सियां; ");
INSERT INTO lbm_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्र जागा म सेवा काम करतो समय पहिनन को बुन्यो हुयो कपड़ा, अऊर याजक को काम करन लायी हारून याजक को पवित्र कपड़ा, अऊर ओको टुरावों को कपड़ा।” ");
INSERT INTO lbm_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","तब इस्राएलियों की पूरी मण्डली मूसा को आगु सी लौट गयी। ");
INSERT INTO lbm_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","अऊर जितनो ख उत्साह भयो अऊर जितनो को मन म असी इच्छा पैदा भयी होती, हि मिलाप वालो तम्बू को काम करन अऊर ओकी पूरी सेवा अऊर पवित्र कपड़ा ख बनावन लायी परमेश्वर की भेंट लावन लग्यो, ");
INSERT INTO lbm_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","का बाई, का आदमी, जितनो को मन म असी इच्छा पैदा भयी होती हि सब नथनी, अंगुठी, कान की बाली अऊर गरो को हार अऊर सब तरह को सोनो को जेवर लावन लग्यो, जो जो आदमी परमेश्वर ख भेंट चढ़ानो चाहत होतो ओन सोनो लायो। ");
INSERT INTO lbm_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","अऊर जो जो आदमी को जवर नीलो, जामुनी यां लाल रंग को कपड़ा, यां पतलो सूत सी बुन्यो हुयो कपड़ा, यां शेरी को बाल, यां लाल रंग सी रंगी हुयी मेंढा की खाल, यां सुइसों की खाल होती हि उन्ख ले आयो। ");
INSERT INTO lbm_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","फिर जितनो चांदी, यां पीतल की भेंट को देन वालो होतो हि परमेश्वर लायी वसीच भेंट ले आये; अऊर जेको जेको जवर उपयोग म आवन वालो बबूल की लकड़ी होती हि ओख ले आये। ");
INSERT INTO lbm_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","अऊर जितनी बाईयों को दिल म बुद्धि की कला होती हि अपनो हाथ सी सूत कात कात क नीलो, जामुनी अऊर लाल रंग को, पतलो सूत कात क ले आयी। ");
INSERT INTO lbm_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","जितनी बाईयों को मन म असी बुद्धि की कला होती उन्न शेरी को बाल भी बुन्यो। ");
INSERT INTO lbm_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","अऊर मुखिया लोग एपोद अऊर चपरास लायी सुलैमानी मनि, अऊर जड़न लायी मनि, ");
INSERT INTO lbm_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","अऊर प्रकाश देन अऊर अभिषेक अऊर धूप को लायी सुगन्धित मसाले अऊर तेल लायो। ");
INSERT INTO lbm_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","जो जो चिज ख बनावन की आज्ञा परमेश्वर न मूसा को द्वारा दी होती ओको लायी जो कुछ जरूरी होतो, ओख हि सब आदमी अऊर बाईयों ले आयी, जिन्को दिल म असी इच्छा पैदा भयी होती। यो तरह इस्राएली परमेश्वर लायी अपनीच इच्छा सी भेंट ले आयो। ");
INSERT INTO lbm_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","तब मूसा न इस्राएली लोगों सी कह्यो, “सुनो, परमेश्वर न यहूदा को वंश वालो बसलेल ख, जो ऊरी को टुरा अऊर हूर को नाती हय, नाम ले क बुलायो हय; ");
INSERT INTO lbm_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","अऊर ओन ओख परमेश्वर को आत्मा सी असो परिपूर्न करयो हय कि सब तरह की कला लायी ओख असी बुद्धि, समझ, अऊर ज्ञान मिल्यो हय ");
INSERT INTO lbm_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","कि ऊ कला की योजना निकाल क सोनो, चांदी अऊर पीतल म, ");
INSERT INTO lbm_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","अऊर जड़न लायी मनि काटन म अऊर लकड़ी पर नक्कासी करन म, बल्की बुद्धी सी सब तरह की निकाली हुयी कला म काम कर सके। ");
INSERT INTO lbm_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","फिर परमेश्वर न ओको मन म अऊर दान वंश को अहीसामाक को टुरा ओहोलीआब को मन म भी शिक्षा देन की शक्ति दी हय। ");
INSERT INTO lbm_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","इन दोयी को दिल ख परमेश्वर न असी बुद्धि सी परिपूर्न करयो हय कि हि कुशल कला अऊर गढ़न वालो अऊर नीलो, जामुनी अऊर लाल रंग को कपड़ा, अऊर पतलो सूत को कपड़ा म काढ़न अऊर बुनन वालो होना, बल्की सब तरह की बनावट म, अऊर बुद्धि सी काम निकालन म सब तरह को काम करे। ");
INSERT INTO lbm_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“बसलेल अऊर ओहोलीआब अऊर सब बुद्धिमान जिन्ख परमेश्वर न असी बुद्धि अऊर समझ दियो हो कि हि परमेश्वर की पूरी आज्ञावों को अनुसार पवित्र जागा की सेवा लायी सब तरह को काम करनो जानय हय, हि सब यो काम करेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","तब मूसा न बसलेल अऊर ओहोलीआब अऊर सब बुद्धिमानों ख जिन्को दिल म परमेश्वर न बुद्धि को प्रकाश दियो होतो, मतलब जेख जेख जवर आय क काम करन को उत्साह भयो होतो उन सब ख बुलायो; ");
INSERT INTO lbm_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","अऊर इस्राएली जो जो भेंट पवित्र जागा की सेवा को काम अऊर ओख बनावन लायी ले आयो होतो, उन्ख उन आदमियों न मूसा को हाथ सी ले लियो। तब भी लोग हर सुबेरे ओको जवर भेंट अपनी इच्छा सी लावतो रहो; ");
INSERT INTO lbm_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","अऊर जितनो बुद्धिमान पवित्र जागा को काम करत होतो हि सब अपनो अपनो काम छोड़ क मूसा को जवर आये, ");
INSERT INTO lbm_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","अऊर मूसा सी कहन लग्यो, “जो काम ख करन की आज्ञा परमेश्वर न दियो हय ओको लायी जितनो होनो ओको सी जादा हि ले आयो हंय।” ");
INSERT INTO lbm_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तब मूसा न पूरी छावनी म या आज्ञा को प्रचार करवायो, “का आदमी, का बाई, कोयी पवित्र जागा लायी अऊर भेंट नहीं लाये।” यो तरह लोग अऊर भेंट लावन सी रोक्यो गयो; ");
INSERT INTO lbm_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","कहालीकि सब काम बनावन लायी जितनो सामान जरूरत होतो, ओको सी जादा बनावन वालो को जवर आय चुक्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","काम करन वालो जितनो कुशल कारीगर होतो उन्न निवास लायी यां परदा पतलो सूत सी बुन्यो हुयो नीलो, जामुनी अऊर लाल रंग को कपड़ा को दस परदा ख बुनायी करयो हुयो करूबों सहित बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","हर एक परदा की लम्बायी अट्ठावीस हाथ अऊर चौड़ायी चार हाथ की होना; सब परदा एकच नाप को बने। ");
INSERT INTO lbm_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ओन पाच परदा एक दूसरो सी जोड़ दियो, अऊर फिर दूसरो पाच परदा भी एक दूसरो सी जोड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","अऊर जहां यो परदा जोड़्यो गयो वहां की दोयी कोनो पर ओन नीलो नीलो फन्दा लगाये। ");
INSERT INTO lbm_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ओन दोयी कोना म पचास पचास फन्दा यो तरह लगाये कि हि एक दूसरो को आगु रहे। ");
INSERT INTO lbm_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","अऊर ओन सोनो को पचास आकड़ा बनाये, अऊर उन्को द्वारा परदा ख एक दूसरो सी असो जोड़्यो कि निवास मिल क एकच भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","तब निवास जागा को ऊपर को तम्बू लायी ओन शेरी को बाल को ग्यारा परदा बनाये। ");
INSERT INTO lbm_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","एक एक परदा की लम्बाई तीस हाथ अऊर चौड़ाई चार हाथ की भयी; अऊर ग्यारा परदा भी एकच नाप को होतो। ");
INSERT INTO lbm_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","इन म सी ओन पाच परदा अलग अऊर छय परदा अलग जोड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","अऊर जहां दोयी जोड़्यो गयो वहां को कोना म ओन पचास पचास फन्दा लगाये। ");
INSERT INTO lbm_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","अऊर ओन तम्बू को जोड़न लायी पीतल को पचास आकड़ा भी बनाये जेकोसी ऊ एक होय जाये। ");
INSERT INTO lbm_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","अऊर ओन तम्बू लायी लाल रंग सी रंगी हुयी मेंढा की खालों को एक ओढ़ना अऊर ओको ऊपर लायी सुइसों की खालों को भी एक ओढ़ना बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","तब ओन निवास लायी बबूल की लकड़ी को तक्ता ख खड़ो रहन लायी बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","हर एक तक्ता की लम्बायी दस हाथ अऊर चौड़ायी देड़ हाथ की भयी। ");
INSERT INTO lbm_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","हर एक तक्ता म एक दूसरो सी जोड़ी हुयी दोय दोय खाचा बन्यो, निवास को सब तक्ता ख ओन एक जसो बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ओन निवास लायी तक्ता ख बनायो कि दक्षिन को तरफ बीस तक्ता; ");
INSERT INTO lbm_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","अऊर इन बीसों तक्ता को खल्लो चांदी की चालीस पाया, मतलब एक एक तक्ता को खल्लो ओकी दोय खाचा लायी ओन दोय कुर्चियां बनायी। ");
INSERT INTO lbm_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","अऊर निवास की दूसरो तरफ, मतलब उत्तर को तरफ लायी भी ओन बीस तक्ता बनाये; ");
INSERT INTO lbm_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","अऊर इन्को लायी भी ओन चांदी की चालीस पाया, मतलब एक एक तक्ता को खल्लो दोय दोय पाया बनायी। ");
INSERT INTO lbm_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","अऊर निवास को पीछु को तरफ, मतलब पश्चिम को तरफ को लायी ओन छय तक्ता बनायो; ");
INSERT INTO lbm_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","अऊर पिछलो हिस्सा म निवास को कोना लायी ओन दोय तक्ता बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","हि खल्लो सी दोय दोय हिस्सा को बने, अऊर दोयी हिस्सा ऊपर को कोना तक एक एक कड़ा म मिलाये गयो; ओन उन दोयी तक्ता को आकार असोच बनायो ");
INSERT INTO lbm_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","यो तरह आठ तक्ता भयो, अऊर उन्की चांदी की सोला पाया भयी; मतलब हर एक तक्ता को खल्लो दोय दोय पाया भयी। ");
INSERT INTO lbm_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","तब ओन बबूल की लकड़ी की बेंड़े बनायो, मतलब निवास को एक तरफ को तक्ता लायी पाच बेंड़ा, ");
INSERT INTO lbm_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","अऊर निवास को दूसरो तरफ को तक्ता लायी पाच बेंड़ा, अऊर निवास को जो किनार पश्चिम को तरफ पिछलो हिस्सा म होतो ओको लायी भी पाच बेंड़ा बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","अऊर ओन बीच वालो बेंड़ा ख तक्ता को बीच म तम्बू को एक कोना सी दूसरो कोना तक पहुंचन लायी बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","अऊर तक्ता ख ओन सोनो सी मढ़यो, अऊर बेंड़ों ख जो घर को काम देन वालो कड़ा ख सोनो को बनायो, अऊर बेंड़ा ख भी सोनो सी मढ़यो। ");
INSERT INTO lbm_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","फिर ओन नीलो, जामुनी अऊर लाल रंग को कपड़ा को, अऊर पतलो सूत सी बुन्यो हुयो कपड़ा को बीच वालो परदा बनायो; ऊ बुनायी को काम करयो हुयो करूबों को संग बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ओन ओको लायी बबूल को चार खम्बा बनायो, अऊर उन्को सोनो सी मढ़यो; उन्की घुंड़ियां सोनो की बनायी, अऊर ओन उन्को लायी चांदी को चार पाया बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ओन तम्बू को दरवाजा लायी भी नीलो, जामुनी अऊर लाल रंग को कपड़ा को, अऊर पतलो सूत बुन्यो हुयो कपड़ा सी बुनायी को काम करयो हुयो परदा बनायो; ");
INSERT INTO lbm_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","अऊर ओन घुंड़ियों सहित ओको पाच खम्बा भी बनाये, अऊर उन्को कोनो अऊर जोड़न की पट्टियों ख सोनो सी मढ़यो, अऊर उन्को पाच पाया पीतल को बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","तब बसलेल न बबूल की लकड़ी को सन्दूक बनायो; ओकी लम्बायी ढायी हाथ, चौड़ायी डेढ़ हाथ, अऊर ऊंचायी डेढ़ हाथ की होती, ");
INSERT INTO lbm_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ओन ओख अन्दर बाहेर शुद्ध सोनो सी मढ़यो, अऊर ओको चारयी तरफ सोनो की किनार बनायी। ");
INSERT INTO lbm_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","अऊर ओको चारयी पाय पर लगान लायी ओन सोनो को चार कड़ा डाल्यो, दोय कड़ा एक तरफ अऊर दोय कड़ा दूसरो तरफ लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","तब ओन बबूल को डन्डा बनाये, अऊर उन्ख सोनो सी मढ़यो, ");
INSERT INTO lbm_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","अऊर उन्को सन्दूक को दोयी तरफ को कड़ों म डाल्यो कि उन्को बल सन्दूक उठायो जाये। ");
INSERT INTO lbm_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","तब ओन शुद्ध सोनो को प्रायश्चित वालो ढक्कन ख बनायो; ओकी लम्बायी ढायी हाथ अऊर चौड़ायी देढ़ हाथ की होती। ");
INSERT INTO lbm_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","अऊर ओन सोनो ढाल क दोय करूब प्रायश्चित को ढक्कन को दोयी कोनो को ऊपर बनाये; ");
INSERT INTO lbm_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","एक करूब एक कोना पर, अऊर दूसरो करूब दूसरो कोना पर बनाव; ओन उन्ख प्रायश्चित को ढक्कन को संग एकच तुकड़ा को दोयी कोनो पर बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","अऊर करूबों को पंख ऊपर सी फैलायो हुयो बनाव, अऊर उन पंखा सी प्रायश्चित को ढकना झक्यो हुयो बनाव, अऊर उन्को मुख आमने-सामने अऊर प्रायश्चित को ढक्कन को तरफ करयो हुयो बनाव। ");
INSERT INTO lbm_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","तब ओन बबूल की लकड़ी की मेज ख बनायो; ओकी लम्बायी दोय हाथ, चौड़ायी एक हाथ, अऊर ऊचायी देढ़ हाथ की होती; ");
INSERT INTO lbm_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","अऊर ओन ओख शुद्ध सोनो सी मढ़यो, अऊर ओको म चारयी तरफ सोनो की एक किनार बनायी; ");
INSERT INTO lbm_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","अऊर ओन ओको लायी चार बोट चौड़ी एक चौखट बनायी, अऊर या चौखट लायी चारयी तरफ सोनो की एक किनार बनायी। ");
INSERT INTO lbm_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ओन मेज लायी सोनो को चार कड़ा ढाल क उन चारयी कोनो म लगायो, जो ओको चारयी पाय पर होतो। ");
INSERT INTO lbm_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","हि कड़ां चौखट को जवर मेज ख उठावन लायी डन्डो ख सहारा देन लायी बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ओन मेज ख उठावन लायी डन्डा ख बबूल की लकड़ी को बनायो अऊर सोनो सी मढ़यो। ");
INSERT INTO lbm_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","अऊर ओन मेज पर को सामान मतलब परात, धूपदान, कटोरा, अऊर पीवन को बर्तन सब शुद्ध सोनो को बनाये। ");
INSERT INTO lbm_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","तब ओन शुद्ध सोनो को एक दीया बनायो; ओको डगाली, गाठ, पंकुड़ी अऊर फूल सब एकच तुकड़ा को बन्यो। ");
INSERT INTO lbm_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","अऊर दीया सी निकली हुयी छय डगालियां बनी; तीन डगालियां ओको एक तरफ सी अऊर तीन डगालियां ओको दूसरी तरफ सी निकली हुयी बन्यो। ");
INSERT INTO lbm_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","छय डगाली म सी हर एक सजावटी फूल होत होतो, जो कलियां अऊर पंकुड़ियां को संग बादाम को फूलों को तरह होत होतो। ");
INSERT INTO lbm_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","अऊर दीया की डन्डी म बादाम को फूल को जसो अपनी अपनी कलियां अऊर फूल सहित चार पंकुड़ी बनाये। ");
INSERT INTO lbm_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","अऊर दीया सी निकली हुयी छय डगालियां म सी दोय दोय डगालियां को नीचो एक एक कलियां दीया को संग एकच तुकड़ा की बनाये। ");
INSERT INTO lbm_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","कली अऊर डगालियां सब दीया को संग एकच तुकड़ा की बने; शुद्ध सोनो ढाल क पूरो दीया एकच तुकड़ा को बन्यो। ");
INSERT INTO lbm_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","अऊर ओन दीया को सातों दीया बनाये, अऊर चिमटे अऊर थारी सब शुद्ध सोनो को बनाये। ");
INSERT INTO lbm_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ओन पूरो सामान सहित दीवट अऊर ओको सब कटोरा लगभग चौतीस किलो शुद्ध सोनो को बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","तब ओन बबूल की लकड़ी की धूप वेदी भी बनायी; ओकी लम्बायी एक हाथ अऊर चौड़ायी एक हाथ की होती; वा चौकोन बने, अऊर ओकी ऊचायी दोय हाथ की होती; अऊर ओको सींग ओको संग एकच तुकड़ा को बन्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ऊपर वालो पल्लां, अऊर चारयी तरफ को बाजुवों अऊर सींगो सहित ओन उच वेदी ख शुद्ध सोनो सी मढ़यो; अऊर ओको चारयी तरफ सोनो की एक किनार बनायी, ");
INSERT INTO lbm_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","अऊर ऊ किनार को खल्लो ओको दोयी पल्लां पर ओन सोनो को दोय कड़ा बनायो, जो ओख उठावन को डन्डा ख सहारा को काम दे। ");
INSERT INTO lbm_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","अऊर डन्डा ख ओन बबूल की लकड़ी को बनायो अऊर सोनो सी मढ़यो। ");
INSERT INTO lbm_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ओन अभिषेक को पवित्र तेल अऊर सुगन्धित द्रव्य को धूप सुगन्ध को रीति को अनुसार बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","तब ओन बबूल की लकड़ी की होमबलि वेदी भी बनायी; ओकी लम्बायी पाच हाथ अऊर चौड़ायी पाच हाथ की होती; यो तरह सी ऊ चौकोन बनी, अऊर ऊचायी तीन हाथ की होती। ");
INSERT INTO lbm_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ओन ओको चारयी कोनो पर ओको चार सींग बनाये, हि ओको संग बिना जोड़ क् बन्यो; अऊर ओन ओख ख पीतल सी मढ़यो। ");
INSERT INTO lbm_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","अऊर ओन वेदी को पूरो सामान, यानेकि ओकी हान्डियों, फावडां, कटोरा, काटे अऊर आगी कटोराच सब पीतल सी बनाये। ");
INSERT INTO lbm_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ओन वेदी लायी पेटी को नीचो, एक पीतल की जाली एक असी एक जाली बनायी, ऊ नीचो सी वेदी की ऊचायी को बीच तक पहुंची। ");
INSERT INTO lbm_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ओन पीतल की जाली को चारयी कोनो लायी चार कड़ा ढाल्यो, जो डन्डों को खाना को काम दे। ");
INSERT INTO lbm_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","तब ओन डन्डों ख बबूल की लकड़ी को बनायो अऊर पीतल सी मढ़यो। ");
INSERT INTO lbm_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","तब ओन डन्डों ख वेदी को किनारो को कड़ों म वेदी क् उठान लायी डाल दियो। वेदी ख ओन तक्ता सी खोखली बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ओन गंगार अऊर ओको पाया दोयी पीतल को बनाये, यो मिलाप वालो तम्बू को फाटक पर सेवा करन वालो बाईयों को आरसा को पीतल सी बनाये गयो। ");
INSERT INTO lbm_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","तब ओन आंगन बनायो; अऊर दक्षिन की तरफ लायी आंगन को परदा पतलो सूत सी बुन्यो हुयो कपड़ा को होतो, अऊर सब मिलाय क सौ हाथ लम्बो होतो; ");
INSERT INTO lbm_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","उन्को लायी बीस खम्बा, अऊर पीतल को बीस पाया बन्यो; अऊर खम्बा की घुंड़ियां अऊर जोड़न की पट्टियां चांदी की बनी। ");
INSERT INTO lbm_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","अऊर उत्तर की तरफ लायी भी सौ हाथ लम्बो परदा बन्यो; अऊर उन्को लायी बीस खम्बा अऊर पीतल को बीस पाया बन्यो, अऊर खम्बां की घुंड़ियां अऊर जोड़न की पट्टियां चांदी को बनी होती। ");
INSERT INTO lbm_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","अऊर पश्चिम की तरफ परदा साढ़े बावीस मीटर लम्बो होतो; उन्को लायी दस खम्बा अऊर दस उन्को पाया होतो, अऊर खम्बां की घुन्डियां अऊर जोड़न वाली पट्टियां चांदी की होती। ");
INSERT INTO lbm_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","अऊर पूर्व हिस्सा म आगु को तरफ को परदा पचास लम्बो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","आंगन को फाटक को एक तरफ लायी पन्द्रा हाथ को परदा बन्यो; अऊर उन्को लायी तीन खम्बा अऊर तीन पाया होतो। ");
INSERT INTO lbm_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","अऊर आंगन को फाटक को दूसरी तरफ भी वसोच बन्यो होतो; अऊर आंगन को दरवाजा को इत अऊर उत पन्द्रा पन्द्रा हाथ को परदा बन्यो होतो; अऊर उन्को लायी तीन तीन खम्बा, अऊर तीन तीन पाया भी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आंगन को चारयी तरफ सब परदा पतलो बुन्यो हुयो सूती कपड़ा को होतो। ");
INSERT INTO lbm_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","अऊर खम्बां को पाया पीतल को अऊर घुन्डियां अऊर पट्टियां चांदी को बन्यो होतो, अऊर उन्को ऊपर को कोना चांदी सी मढ़यो हुयो होतो, अऊर आंगन को सब खम्बां चांदी की पट्टियां सी जुड़ गयो। ");
INSERT INTO lbm_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आंगन को फाटक को परदा पर बुनायी करी गयी होती, अऊर ऊ नीलो, जामुनी तब लाल रंग को कपड़ा को; पतलो बुन्यो हुयो सूती कपड़ा को होतो; अऊर ओकी ऊचायी आंगन को बराबर को चौड़ायी को समान पाच हाथ की बन्यो। ");
INSERT INTO lbm_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","अऊर उन्को लायी चार खम्बां, अऊर खम्बों की चारयी पाया पीतल को बन्यो, उन्की घुन्डियां चांदी की बन्यो, अऊर उन्को कोना चांदी सी मढ़यो गयो होतो, अऊर उन्की पट्टियां चांदी को बन्यो होती। ");
INSERT INTO lbm_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","निवास जागा तब आंगन को चारयी तरफ को सब खूटा पीतल को बन्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","निवास जागा मतलब गवाही चिट्ठी को तम्बू को सामान जो लेवियों को सेवा लायी बन्यो होतो, अऊर जेकी गिनती मूसा को आज्ञा को अनुसार हारून याजक को टुरा ईतामार को द्वारा हुयी होती, ओको वर्नन यो हय। ");
INSERT INTO lbm_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","जेको जेको चिज को बनान की आज्ञा परमेश्वर न मूसा ख दियो होती ओख ख बसलेल न बनायो, ऊ ऊरी को टुरा, हूर को नाती अऊर यहूदा को वंश को होतो। ");
INSERT INTO lbm_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","अऊर ओको संग दान वंश वालो, अहीसामाक को टुरा, ओहोलीआब होतो, जो नक्कासी करन अऊर गढ़न वालो अऊर नीलो, जामुनी अऊर लाल रंग को पतलो धागा सी बुन्यो हुयो कपड़ा म बुनायी करन वालो निपुन कारीगर होतो। ");
INSERT INTO lbm_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्र जागा को पूरो काम म जो भेंट को सोनो लग्यो ऊ पवित्र जागा को शेकेल को हिसाब सी एक हजार दोय किलो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","अऊर मण्डली को गिन्यो हुयो लोगों की भेंट की चांदी पवित्र जागा को शेकेल को हिसाब सी सौ किक्कार अऊर सतरा सौ पचहत्तर शेकेल होती। ");
INSERT INTO lbm_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","मतलब जितनो बीस साल अऊर ओख सी जादा उमर को होतो, जो गिनती म छय लाख तीन हजार पाच सौ पचास आदमी होतो, उन सी एक बेका हर आदमी ख मतलब पवित्र जागा को शेकेल को अनुसार अरधो शेकेल मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","अऊर ऊ सौ किक्कार चांदी पवित्र जागा अऊर बीच वालो परदा दोयी को पाया को ढालन म लग गयो; सौ किक्कार सी सौ पाया बन्यो, हर एक पाया एक किक्कार को बन्यो। ");
INSERT INTO lbm_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","अऊर शेष एक हजार सात सौ पछत्तर शेकेल सी ओन खम्बों की घुन्डियां बनायी अऊर खम्बों को ऊपर को भाग मढ़यो, अऊर उन्की पट्टियां भी बनायी। ");
INSERT INTO lbm_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","अऊर भेंट को पीतल सत्तर किक्कार अऊर दोय हजार चार सौ शेकेल होतो ");
INSERT INTO lbm_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ओको सी मिलाप वालो तम्बू को फाटक को पाया अऊर पीतल की वेदी, ओकी पीतल की जाली, अऊर वेदी को पूरो सामान; ");
INSERT INTO lbm_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","अऊर आंगन को चारयी तरफ को पाया, अऊर ओको फाटक को पाया, अऊर निवास, अऊर आंगन को चारयी तरफ को खूटा भी बनाये गयो। ");
INSERT INTO lbm_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","तब उन्न नीलो, जामुनी अऊर लाल रंग को सूत सी पवित्र वेदी की सेवा करन वालों याजकों लायी पहिनन लायी कपड़ा बनाये, अऊर हारून लायी भी पवित्र कपड़ा बनाये; जो तरह परमेश्वर न मूसा ख आज्ञा दी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ओन एपोद पोशाक ख सोनो सी, पतलो सूत सी बुन्यो हुयो नीलो, जामुनी अऊर लाल रंग को कपड़ा सी बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","अऊर उन्न सोनो ख पीट क पतली पत्तियां बनायी अऊर उन्म सी तार काट्यो। बाद म उन तार बनायो अऊर कुशल कारीगरों को द्वारा पतलो सूत सी बुन्यो हुयो नीलो, जामुनी अऊर लाल रंग को कपड़ा पर बनावट सी मिलाय दियो। ");
INSERT INTO lbm_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","उन्न एपोद लायी ओको दोयी कोनो पर जुड़्यो हुयो दोय कन्धा बनाये। ");
INSERT INTO lbm_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","अऊर ओख कसन लायी जो बारीक बुन्यो हुयो पट्टा ओको पर बन्यो, ऊ ओको संग बिना जोड़ को होतो, अऊर ओकीच बनावट को अनुसार, मतलब सोनो अऊर नीलो, जामुनी अऊर लाल रंग को कपड़ा को, अऊर स्वर्ण को कपड़ा को बन्यो; जसो परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","अऊर उन्न सुलैमानी गोटा काट क सोनो की खांचों म जोड़्यो गयो, यो गोटा इस्राएल को बारा टुरावों को नामों को अनुसार मुहर को समान खोद्यो गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","अऊर ओन उन्ख एपोद पोशाक को कन्धावों पर लगाय दियो, जेकोसी इस्राएलियों लायी याद करान वालो मनि ठहरे; जो तरह परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ओन सीनाबन्द ख एपोद को समान सोनो की, अऊर नीलो, जामुनी रंग को कपड़ा सी बनायो, अऊर बन्यो हुयो सन को कपड़ा म कलात्मक ढंग सी सीनाबन्द बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","सीनाबन्द चार च कोना बराबर बन्यो होतो; डबल मोड़्यो हुयो, अऊर ऊ डबल होय क नव इंच अऊर नव इंच चौड़ो बन्यो। ");
INSERT INTO lbm_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","अऊर उन्न ओको पर चार लायीन म मनि लगायो। पहली लायीन म एक माणिक्य; एक पुखराज, अऊर लालड़ी लगायो गयो; ");
INSERT INTO lbm_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","अऊर दूसरी लायीन म मरकत, नीलमनि, अऊर हीरा की होती; ");
INSERT INTO lbm_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","अऊर तीसरी लायीन म लशम, सूर्यकान्त, अऊर नीलम; ");
INSERT INTO lbm_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","अऊर चौथी लायीन म लशम, सुलैमानी मनि, अऊर यशब जड़े; यो सब अलग अलग सोनो को जड़्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","अऊर यो मनि इस्राएल को टुरावों को नामो को अनुसार बारा होतो; एक एक मनि पर एक एक कुल को नाम छाप को समान खोद्यो हुयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","अऊर उन्न सीनाबन्द कवच पर डोरियां को समान गूथ्यो हुयो शुद्ध सोनो की संकली बनाय क लगायी; ");
INSERT INTO lbm_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","तब उन्न सोनो को दोय खाना, अऊर सोनो की दोय कड़ियां बनाय क दोयी कड़ियों ख सीनाबन्द कवच को दोयी कोनो पर जोड़ दियो; ");
INSERT INTO lbm_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","तब उन्न सोनो की दोयी गूथी हुयी संकली ख सीनाबन्द कवच को कोनो पर की दोयी कड़ियों म लगायो। ");
INSERT INTO lbm_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","अऊर गूथी हुयी दोयी संकलीयों को दोयी बाकी कोनो ख उन्न दोयी खांचों म लगायो, एपोद को आगु दोयी कन्धों को बन्धनो पर लगायो। ");
INSERT INTO lbm_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","तब उन्न सोनो की अऊर दोय कड़ियां बनायो अऊर उन्ख एपोद पोशाक को बाजू को अन्दर किनार पर, एपोद को खल्लो कोनो पर जोड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","अऊर उन्न सोनो की दोय अऊर कड़ियां भी बनाय क एपोद को दोयी कन्धों को खल्लो भाग को जोड़ पर, एपोद पोशाक को पतलो बुन्यो हुयो पट्टा को ऊपर जोड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","तब उन्न सीनाबन्द कवच ख ओकी कड़ियों को द्वारा एपोद की कड़ियों म नीलो पट्टा सी असो बान्ध्यो कि ऊ एपोद को लगायो हुयो पट्टा को ऊपर रहेंन, अऊर चपरास एपोद सी अलग नहीं हो सकेंन; जसो परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ओन एपोद लायी सम्पूर्न नीलो रंग को एक अंगरखा बुन क बनायो। ");
INSERT INTO lbm_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","अंगरखा को बीचो बीच एक छेद होतो, यो छेद को चारयी तरफ कपड़ा की गोट लग्यो होतो जेकोसी ऊ फट नहीं सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","उन्न अंगरखा को खल्लो वालो घेरा म पतलो सूत सी बुन्यो हुयो नीलो, जामुनी अऊर लाल रंग को कपड़ा को अनार जसो गोल बनाये। ");
INSERT INTO lbm_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","उन्न शुद्ध सोनो की घुंगरू भी बनाय क अंगरखा को नीचो वालो घेरा को चारयी तरफ अनारों को बीचो बीच लगायी; ");
INSERT INTO lbm_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","मतलब झगली को खल्लो वालो घेरा को चारयी तरफ एक सोनो की घन्टी, अऊर एक अनार, फिर एक सोनो की घन्टी, अऊर एक अनार लगायो गयो कि उन्ख पहिन्यो हुयो सेवा कार्य करे; जसो परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","उन्न हारून अऊर ओको टुरावों लायी यो पोशाकें बनायी: महीन सूती कपड़ा को कुरता, फेटा अऊर टोपियां पतलो सूत सी बुन्यो हुयो कपड़ा को जांघियां, ");
INSERT INTO lbm_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","पतलो बुन्यो हुयो कपड़ा को फेटा, सुन्दर टोपियां, अऊर जांघियां बनायी, ");
INSERT INTO lbm_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","अऊर पतलो सूत सी बुन्यो हुयो नीलो, जामुनी फिर लाल रंग को कपड़ा को कमर पट्टा, जो पर सूई सी बुनायी करयो गयो होतो, जसी परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","तब उन्न पवित्र मुकुट की पट्टी शुद्ध सोनो की बनायी; अऊर जसो मुहर म वसोच उन्म यो अक्षर खोद्यो गयो, मतलब “परमेश्वर लायी पवित्र।” ");
INSERT INTO lbm_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","उन्न ओको फेटा को आगु नीलो रंग की रस्सी संग बान्ध दियो, ठीक जसो “परमेश्वर न मूसा ख आज्ञा दी होती।” ");
INSERT INTO lbm_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","यो तरह मिलाप वालो तम्बू को निवास को सब काम पूरो भयो, अऊर जो काम की आज्ञा परमेश्वर न मूसा ख दी होती, इस्राएलियों न ओको अनुसार करयो। ");
INSERT INTO lbm_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","अऊर हि निवास को तम्बू अऊर ओकी सब चिजों सहित मूसा को जवर ले आये : मतलब हंसिया, चौखट, सलाखें, खम्बा अऊर तम्बू तक ले आये; ");
INSERT INTO lbm_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","अऊर लाल रंग सी रंगी हुयी मेंढा की खाल को ओढ़ना, अऊर सूइसों की खाल को ओढ़ना, अऊर बीच को परदा; ");
INSERT INTO lbm_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","गवाही-चिट्ठी को सन्दूक अऊर ओको खम्बा, अऊर पश्चाताप को ढक्कन; ");
INSERT INTO lbm_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","मेज अऊर ओकी सब चिजे अऊर भेंट की रोटी; ");
INSERT INTO lbm_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","शुद्ध सोनो की दीवट, अऊर ओको संग ओकी सजावट को दीया, अऊर ओकी सब चिजे फिर दीया जलावन लायी तेल; ");
INSERT INTO lbm_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सोनो की वेदी, अऊर अभिषेक को तेल; सुगन्धित धूप अऊर तम्बू को दरवाजा को परदा; ");
INSERT INTO lbm_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","पीतल की वेदी अऊर ओकी पीतल की जाली, ओकी सब चिजों सहित खम्बा; गंगार अऊर ओको पाये; ");
INSERT INTO lbm_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","खम्बों अऊर पाया समेत आंगन को परदा, अऊर आंगन को फाटक को परदा, अऊर डोरियां, अऊर खूटा, अऊर मिलाप वालो तम्बू को निवास को सेवा को पूरो सामान; ");
INSERT INTO lbm_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","पवित्र जागा म सेवा करतो समय पहिन्यो हुयो कपड़ा, अऊर याजकीय सेवा काम करन लायी हारून याजक को पवित्र कपड़ा अऊर ओको टुरावों को कपड़ा। ");
INSERT INTO lbm_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","जसी परमेश्वर न मूसा ख आज्ञा दी होती ओको अनुसार इस्राएलियों न सब काम करयो। ");
INSERT INTO lbm_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","तब मूसा न पूरो काम ख जांच क देख्यो कि उन्न वसोच करयो होतो जसो परमेश्वर न आज्ञा दी होती। अऊर मूसा न उन्ख आशीर्वाद दियो। ");
INSERT INTO lbm_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहिलो महीना को पहिलो दिन ख तय मिलाप वालो तम्बू को निवास ख खड़ो कर देजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","अऊर ओको म गवाही चिट्ठी को सन्दूक ख रख क बीच वालो परदा की आड़ म कर देजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","अऊर मेज ख अन्दर लिजाय क जो कुछ ओको पर सजानो हय ओख सजाय देजो; तब दीवट ख अन्दर लिजाय क ओको दीयावों ख जलाय देजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","अऊर गवाही चिट्ठी को सन्दूक को आगु सोनो की वेदी ख, जो धूप लायी हय ओख रखजो, अऊर निवास को दरवाजा को परदा ख लगाय देजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","अऊर तय मिलाप वालो तम्बू को निवास को फाटक को आगु होमबलि वेदी ख रखजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","अऊर मिलाप वालो तम्बू फिर वेदी को बीच गंगार ख रख क् उन्म पानी भर देजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","अऊर तय चारयी तरफ आंगन बाड़ा बान्ध क आंगन को फाटक पर परदा लटकाय देजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","तब तय अभिषेक को तेल ले क निवास जागा अऊर जो कुछ ओको म हय, सब को अभिषेक करजो अऊर ओख अऊर ओकी पूरी चिजे ख पवित्र करजो; तब वा पवित्र होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","अऊर तय होमबलि वेदी अऊर ओकी सब चिजे ख अभिषेक कर क् वेदी ख अर्पन करजो; तब वेदी परम पवित्र होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","अऊर तय पाय समेत गंगार ख भी अभिषेक कर क् ओख पवित्र करजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","तब तय हारून अऊर ओको टुरावों ख मिलाप वालो तम्बू को फाटक पर लिजाय क पानी सी नहलाजो, ");
INSERT INTO lbm_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","अऊर तय हारून ख पवित्र कपड़ा पहिनाजो, अऊर ओको अभिषेक कर क् ओख अर्पन करजो, ताकि ऊ मोरो लायी याजक होय क मोरी सेवा काम करेंन। ");
INSERT INTO lbm_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","अऊर तय ओको टुरावों ख भी लायजो अऊर उन्ख कुरता पहिनाजो। ");
INSERT INTO lbm_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","अऊर तय उन्को वसोच संस्कार करजो जसो उन्को बाप को संस्कार करयो होतो, कि हि मोरो लायी याजकीय सेवा काम कर सके; अऊर उन्को अभिषेक उन्की पीढ़ी सी पीढ़ी लायी हमेशा लायी याजक बन्यो रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मूसा न असोच करयो, जो आज्ञा परमेश्वर न उन्ख दी होती, ओको अनुसार उन्न सब काम करयो। ");
INSERT INTO lbm_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","अऊर दूसरो साल को पहिलो महीना को पहिलो दिन को निवास ख खड़ो करयो गयो। ");
INSERT INTO lbm_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मूसा न निवास ख खड़ो करयो, तब पाया पर तक्ता रख क उन्म बेंड़ा डाल्यो, अऊर ओको खम्बों ख खड़ो करयो; ");
INSERT INTO lbm_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","अऊर ओन निवास को ऊपर तम्बू ख फैलायो, अऊर तम्बू को ऊपर ओन ओढ़ना ख लगायो; जो तरह परमेश्वर न मूसा ख आज्ञा दी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","अऊर ओन गवाही चिट्ठी ख ले क सन्दूक म रख्यो, अऊर सन्दूक म डन्डा ख लगाय क ओको ऊपर प्रायश्चित को ढक्कन ख सन्दूक को ऊपर रख दियो; ");
INSERT INTO lbm_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","अऊर मूसा न सन्दूक ख पवित्र जागा म रखवायो, अऊर बीच वालो परदा ख लटकाय दियो अऊर गवाही चिट्ठी ख सन्दूक ख अन्दर परदा की आड़ म करयो; जसो परमेश्वर न मूसा ख आज्ञा दी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","तब मूसा न मिलाप वालो तम्बू म निवास को उत्तर दिशा म बीच को परदा को बाहेर मेज लगवायो, ");
INSERT INTO lbm_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","उन्न ओको पर परमेश्वर को जवर रोटी सजाय क रखी; जसी परमेश्वर न मूसा ख आज्ञा दी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","अऊर मूसा न मिलाप वालो तम्बू म मेज को आगु निवास को दक्षिन दिशा म दीवट ख रख दियो, ");
INSERT INTO lbm_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","अऊर ओन दीयावों ख परमेश्वर को आगु जलाय दियो; जो तरह परमेश्वर न मूसा ख आज्ञा दी होतो। ");
INSERT INTO lbm_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","तब मूसा न मिलाप वालो तम्बू को अन्दर बीच को परदा को आगु सोनो की वेदी ख रख्यो, ");
INSERT INTO lbm_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","अऊर ओन ओको पर सुगन्धित धूप जलायो; जो तरह परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","अऊर ओन निवास को दरवाजा पर परदा ख लगायो। ");
INSERT INTO lbm_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","अऊर मिलाप वालो तम्बू को निवास को दरवाजा पर होमबलि वेदी ख रख क ओको पर होमबलि अऊर अन्नबलि ख चढ़ायो; जो तरह परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","अऊर मूसा न मिलाप वालो तम्बू अऊर वेदी को बीच म गंगार ख रख क ओको म धोवन लायी पानी भर दियो, ");
INSERT INTO lbm_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","अऊर मूसा अऊर हारून अऊर ओको टुरावों न ओको म अपनो अपनो हाथ पाय धोवत होतो; ");
INSERT INTO lbm_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","अऊर जब जब हि मिलाप वालो तम्बू म यां वेदी को जवर जात होतो तब तब हि हाथ पाय धोय क जात होतो; जो तरह परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","अऊर मूसा न मिलाप वालो तम्बू अऊर वेदी को चारयी तरफ आंगन ख घेरा लगाय क अऊर आंगन को फाटक पर परदा लटकाय दियो। येकोलायी ओन पूरो काम खतम कर दियो। ");
INSERT INTO lbm_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","तब बादर मिलाप वालो तम्बू पर छाय गयो, अऊर परमेश्वर को तेज निवास-जागा म भर गयो। ");
INSERT INTO lbm_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","अऊर बादर मिलाप वालो तम्बू पर रूक गयो, अऊर परमेश्वर को तेज निवास-जागा म भर गयो, यो वजह मूसा ओको म सिर नहीं सक्यो। ");
INSERT INTO lbm_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","अऊर उन्की पूरी यात्रा म जब जब ऊ बादर मिलाप वालो तम्बू को ऊपर सी उठ जात होतो, तब तब इस्राएली आगु सी निकल जात होतो; ");
INSERT INTO lbm_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","पर यदि बादर नहीं उठत होतो, त हि ऊ दिन तक निकलत नहीं होतो जब तक बादर वहां सी उठत नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","कहालीकि उन्की पूरी यात्रा म परमेश्वर दिन म मिलाप वालो तम्बू पर रूक्यो रहत होतो, अऊर रात म इस्राएली लोगों ख ओको म आगी दिखायी देत होती।");
INSERT INTO lbm_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","परमेश्वर न मूसा ख बुलाय क मिलाप वालो तम्बू म सी ओको सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","इस्राएलियों सी कह्य कि तुम म सी यदि कोयी आदमी परमेश्वर को लायी पशु को चढ़ावा चढ़ाये, त ओको बलिपशु पालतु जनावर यां मेंढा-शेरियों को झुण्ड म सी एक को हो। ");
INSERT INTO lbm_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“यदि ऊ गाय-बईलों म सी होमबलि करे, त निर्दोष नर मिलाप वालो तम्बू को द्वार पर चढ़ाये कि परमेश्वर ओख स्विकार करे। ");
INSERT INTO lbm_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ऊ अपनो हाथ होमबलिपशु को मुंड पर रखे, अऊर ऊ ओको लायी प्रायश्चित कर क् स्विकार करे। ");
INSERT INTO lbm_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","तब ऊ बछड़ा ख परमेश्वर को आगु बलि करे; अऊर हारून को टुरा जो याजक हंय हि खून ख वेदी को जवर लिजाय क ऊ वेदी को चारयी तरफ छिड़के जो मिलाप वालो तम्बू को फाटक पर हय।” ");
INSERT INTO lbm_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","फिर ऊ होमबलिपशु की खाल निकाल क ऊ पशु ख तुकड़ा-तुकड़ा करे; ");
INSERT INTO lbm_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","तब हारून याजक को टुरा वेदी पर आगी रखे, अऊर आगी पर लकड़ी सजाय क रखे; ");
INSERT INTO lbm_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","अऊर हारून को टुरा जो याजक हय हि मुंड अऊर चरबी समेत पशु को टुकड़ा ख ऊ लकड़ी पर जो वेदी की आगी पर होना सजाय क रखे; ");
INSERT INTO lbm_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","अऊर ऊ ओकी आंतड़ियों अऊर पाय ख पानी सी धोये। तब याजक सब ख वेदी पर जलाये कि ऊ होमबलि परमेश्वर को लायी सुखदायक सुगन्ध वालो बलिदान ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","यदि ऊ झुण्ड म सी मेंढी यां शेरियों की होमबलि चढ़ाये त पूरो तरह सी स्वस्थ नर जनावर ख चढ़ाये; ");
INSERT INTO lbm_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","अऊर ऊ ओख परमेश्वर को आगु वेदी को उत्तर को तरफ बलि करे; अऊर हारून को टुरा जो याजक हंय हि ओको खून ख वेदी को चारयी तरफ छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","अऊर ऊ ओख तुकड़ा-तुकड़ा करे, अऊर मुंड अऊर चरबी ख अलग करे, अऊर याजक इन सब ख ऊ लकड़ी पर सजाय क रखे जो वेदी की आगी पर होना; ");
INSERT INTO lbm_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","अऊर ऊ ओकी आंतड़ियों अऊर पाय ख पानी सी धोये। अऊर याजक सब ख जवर लिजाय क वेदी पर जलाये कि ऊ होमबलि अऊर यहोवा को लायी सुखदायक सुगन्ध वालो बलिदान ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","यदि ऊ परमेश्वर को लायी पक्षियों की होमबलि चढ़ाये, त पण्डुकों यां कबूतरों को चढ़ावा चढ़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","याजक ओख वेदी को जवर लिजाय क ओको गलो मुरकट क मुंड ख धड़ सी अलग करे, अऊर वेदी पर जलाये; अऊर ओको पूरो खून ऊ वेदी को बाजू म गिरायो जाये; ");
INSERT INTO lbm_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","अऊर ऊ ओकी गल-थैली ख पंखों क वेदी को पूर्व को तरफ राख डालन को जागा पर फेंक दे; ");
INSERT INTO lbm_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","अऊर ऊ ओख पंखा को बीच सी फाड़े, पर अलग-अलग नहीं करे। तब याजक ओख वेदी पर ऊ लकड़ी को ऊपर रख क जो आगी पर होना जलाये कि ऊ होमबलि अऊर परमेश्वर को लायी सुखदायक सुगन्ध वालो बलिदान ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","अब कोयी परमेश्वर लायी अनाज की भेंट को चढ़ावा चढ़ानो चाहे, त ऊ मैदा‍ चढ़ाये; अऊर ओको ऊपर तेल डाल क ओको ऊपर लुभान रखे; ");
INSERT INTO lbm_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","अऊर ऊ ओख हारून को टुरा को जवर जो याजक हंय लाये। अऊर अनाज की भेंट को तेल मिल्यो हुयो मैदा म सी यो तरह अपनी मुट्ठी भर क निकाले कि लुभान ओको म आय जाये; अऊर याजक उन्ख याद दिलावन वालो हिस्सा लायी वेदी पर जलाये कि यो परमेश्वर लायी सुखदायक सुगन्धित भेंट ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अऊर अनाज की भेंट म सी जो बच्यो रहे ऊ हारून अऊर ओको टुरावों को ठहरे; यो परमेश्वर की भेंटों म सी परमपवित्र हिस्सा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“जब तय अनाज की भेंट लायी चुलो म पकायो हुयो चढ़ावा चढ़ाये, त ऊ तेल सी सान्यो हुयो अखमीरी मैदा कि रोटियां यां तेल लगायी हुयी रोटियों को होना।” ");
INSERT INTO lbm_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","अऊर यदि तोरो चढ़ावा तवा पर पकायो हुयो अनाज की भेंट होना, त ऊ तेल सी सान्यो हुयो अखमीरी मैदा को होना; ");
INSERT INTO lbm_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ओख तुकड़ा तुकड़ा कर क् ओको पर तेल डालजो, तब ऊ अनाज की भेंट होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","अऊर यदि तोरो चढ़ावा कढ़ाही म तल्यो हुयो अनाज की भेंट होना, त ऊ मैदा सी तेल म बनायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","अऊर जो अनाज की भेंट इन चिजों म सी कोयी को बन्यो होना ओख परमेश्वर को जवर लि जावो; अऊर जब ऊ याजक को जवर लायो जाय, तब याजक ओख वेदी को जवर लि जाये। ");
INSERT INTO lbm_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","अऊर याजक अनाज की भेंट म सी याद दिलावन वालो हिस्सा निकाल क वेदी पर जलाये कि ऊ परमेश्वर को लायी सुखदायक सुगन्ध वालो अग्नि भेंट ठहरे; ");
INSERT INTO lbm_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अऊर अनाज की भेंट म सी जो बच्यो रहे ऊ हारून अऊर ओको टुरावों को ठहरे; ऊ परमेश्वर को अग्नि भेंटों म परमपवित्र हिस्सा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“कोयी अनाज की भेंट जेक तुम परमेश्वर को लायी चढ़ावो, खमीर मिलाय क बनायो नहीं जाय; तुम कभी वेदी म परमेश्वर लायी खमीर अऊर शहेद मत जलावो।” ");
INSERT INTO lbm_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तुम इन ख पहली फसल को चढ़ावा कर क् परमेश्वर लायी चढ़ावो, पर हि सुखदायक सुगन्ध लायी वेदी पर चढ़ायो नहीं जाय। ");
INSERT INTO lbm_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","फिर अपनो सब अनाज की भेंटों ख नमकीन बनावो; अऊर अपनो कोयी अनाज की भेंट अपनो परमेश्वर को संग बन्धी हुयी वाचा को नमक सी रहित होनो नहीं देजो; अपनो सब चढ़ावा को संग नमक भी चढ़ावो। ");
INSERT INTO lbm_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“यदि तय परमेश्वर को लायी पहली फसल को अनाज की भेंट चढ़ाये, त अपनी पहली फसल को अनाज की भेंट को लायी आगी म भुजी हुयी हरी-हरी लोम्ब, मतलब हरी-हरी लोम्बा को दाना ख कुस कर क् निकाल लेजो, तब अनाज ख चढ़ावो। ");
INSERT INTO lbm_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","अऊर ओको म तेल डालजो, अऊर ओको पर लुभान रखजो; तब ऊ अनाज की भेंट होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","अऊर याजक छिलका निकाल्यो हुयो अनाज ख, अऊर तेल ख, अऊर पूरो लुभान ख याद दिलावन वालो हिस्सा कर क् ख जलाय दे; ऊ परमेश्वर लायी वेदी की अग्नि ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“यदि ओको चढ़ावा मेल-मिलाप बलिदान को होना, अऊर यदि पालतु जनावर म सी कोयी ख चढ़ाये, चाहे ऊ पशु नर यां मादा, जो पूर्ण स्वस्थ होना ओखच ऊ परमेश्वर को आगु चढ़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","अऊर ऊ अपनो हाथ अपनो चढ़ावा को पशु को मुंड पर रखे अऊर ओख मिलाप वालो तम्बू को फाटक पर बलि करे; अऊर हारून को टुरा जो याजक हंय हि ओको खून ख वेदी को चारयी तरफ छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","अऊर ऊ मेल-मिलाप बलिदान म सी परमेश्वर लायी वेदी की आगी अर्पण करे, मतलब जो चर्बी सी अतड़ियां झकी रह्य हय, अऊर जो चरबी ओको म लिपटी रह्य हय वा भी, ");
INSERT INTO lbm_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","अऊर दोयी गुड़दा अऊर उन्को ऊपर की चरबी जो कमर को जवर रह्य हय, अऊर गुड़दा समेत कलेजा को ऊपर की झिल्ली, इन सब ख ऊ अलग करे। ");
INSERT INTO lbm_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","तब हारून को टुरा इन ख वेदी पर ऊ होमबलि को ऊपर जलाये, जो उन लकड़ियों पर होना जो आगी को ऊपर हय कि यो परमेश्वर लायी सुखदायक सुगन्ध वालो भेंट ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“यदि परमेश्वर को मेल-मिलाप बलिदान लायी ओको चढ़ावा पालतु मेंढी-शेरियों को झुण्ड म सी होना, त चाहे ऊ नर होना यां मादा, पर जो पूर्ण स्वस्थ होना ओखच ऊ चढ़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","यदि ऊ मेंढी को बच्चा चढ़ावय हय, त ओख परमेश्वर को सामने चढ़ाये, ");
INSERT INTO lbm_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","अऊर ऊ अपनो चढ़ावा को पशु को मुंड पर हाथ रखे अऊर ओख मिलाप वालो तम्बू को सामने बलि करे; अऊर हारून को टुरा ओको खून ख वेदी को चारयी छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","तब मेल-मिलाप बलिदान म सी चरबी ख परमेश्वर लायी भेंट करे, मतलब ओकी चरबी भरी पूछ ख ऊ रीढ़ को जवर सी अलग करे, अऊर जो चरबी सी अतड़ियां झकी रह्य हंय, अऊर जो चरबी उन म लिपटी रह्य हय, ");
INSERT INTO lbm_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","अऊर दोयी गुड़दा, अऊर जो चरबी ओको ऊपर कमर को जवर रह्य हय, अऊर गुड़दावो समेत कलेजा को ऊपर की झिल्ली, इन सब ख अलग करे। ");
INSERT INTO lbm_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","अऊर याजक उन्ख वेदी पर जलाये; यो परमेश्वर लायी हव्यरूपी भोजन ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“यदि ऊ शेरी चढ़ाये, त ओख परमेश्वर को सामने चढ़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","अऊर ऊ अपनो हाथ ओको मुंड पर रखे, अऊर ओख मिलाप वालो तम्बू को आगु बलि करे; अऊर हारून को टुरा ओको खून ख वेदी को चारयी तरफ छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","तब ऊ ओको म सी अपनो चढ़ावा परमेश्वर लायी भेंट कर क् चढ़ाये, मतलब जो चरबी सी अतड़ियां झकी रह्य हय, अऊर जो चरबी उन म लिपटी रह्य हय ऊ भी, ");
INSERT INTO lbm_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","अऊर दोयी गुड़दा अऊर जो चरबी ओको ऊपर कमर को जवर रह्य हय, अऊर गुड़दावो समेत कलेजा को ऊपर की झिल्ली, इन सब ख अलग करे। ");
INSERT INTO lbm_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","अऊर याजक इन ख वेदी पर जलाये; यो हव्यरूपी भोजन हय जो सुखदायक सुगन्ध लायी होवय हय; कहालीकि पूरी चरबी परमेश्वर की आय। ");
INSERT INTO lbm_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","यो तुम्हरो निवासों म तुम्हरी पीढ़ी सी पीढ़ी तक लायी हमेशा की विधि ठहरेंन कि तुम चरबी अऊर खून कभी नहीं खावो।” ");
INSERT INTO lbm_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","इस्राएलियों सी यो कह्य कि यदि कोयी आदमी उन कामों म सी जिन्ख परमेश्वर न मना करयो हय, उन म सी एक कोयी काम ख भूल सी कर क् पापी होय जाये; ");
INSERT INTO lbm_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","अऊर यदि अभिषिक्त याजक असो पाप करय हय, त प्रजा दोषी ठहरय हय, त अपनो पाप को वजह एक जवान बईल परमेश्वर ख पापबलि कर क् चढ़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ऊ बईल ख मिलाप वालो तम्बू को फाटक पर परमेश्वर को सामने लिजाय क ओको मुंड पर हाथ रख क परमेश्वर को सामने बलि करे। ");
INSERT INTO lbm_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","अऊर अभिषिक्त याजक बईल को खून म सी कुछ ले क मिलाप वालो तम्बू म लिजाये; ");
INSERT INTO lbm_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","अऊर याजक अपनो बोट खून म डुबाय क अऊर ओको म सी कुछ अंश ले क पवित्र जागा को बीच वालो परदा को सामने परमेश्वर को सामने सात बार छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","अऊर याजक ऊ खून म सी कुछ अंश सुगन्धित धूप की वेदी को सींगो पर जो मिलाप वालो तम्बू म हय परमेश्वर को सामने लाये; फिर बईल को सब खून ख होमबलि की वेदी जो मिलाप वालो तम्बू को फाटक हय कुड़ाय दे। ");
INSERT INTO lbm_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","फिर ऊ पापबलि को बईल की सब चरबी ख ओको सी अलग करे, मतलब जो चरबी सी अतड़ियां झकी रह्य हय, अऊर जितनी चरबी ओको म लिपटी रह्य हय, ");
INSERT INTO lbm_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","अऊर दोयी गुड़दा अऊर उन्को ऊपर की चरबी जो कमर को जवर रह्य हय, अऊर गुड़दा समेत कलेजा को ऊपर झिल्ली, इन सब ख ऊ असो अलग करे, ");
INSERT INTO lbm_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","अऊर मेल-मिलाप बलिदान वालो चढ़ावा को जनावर सी अलग करयो जावय हय, अऊर याजक उन्ख होमबलि की वेदी पर जलायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","पर ऊ बईल की खाल, पाय, मुंड, अतड़ियां, गोबर, ");
INSERT INTO lbm_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","बईल को पूरो बच्यो हिस्सा ख छावनी सी बाहेर शुद्ध जागा म, जहां राख डाली जावय हय, अऊर ओख लकड़ी पर रख क जलाय दे; जहां राख डाली जावय हय वहांच ओख जलायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","यदि इस्राएल की पूरी मण्डली अज्ञानता को वजह पाप करे अऊर वा बात मण्डली की आंखी सी लूकी होना, अऊर परमेश्वर न पाप नहीं करन को आदेश दियो हय, यदि असो होवय हय त ऊ दोषी ठहरेंन; ");
INSERT INTO lbm_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","त जब ओको करयो हुयो पाप प्रगट होय जाये तब मण्डली एक बईल ख पापबलि कर क् चढ़ाये। ऊ ओख मिलाप वालो तम्बू को सामने लि जाय, ");
INSERT INTO lbm_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","अऊर मण्डली को बुजूर्ग लोग अपनो अपनो हाथों ख परमेश्वर को सामने बईल को मुंड पर रखे, अऊर ऊ बईल परमेश्वर को सामने बलि करयो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","तब अभिषिक्त याजक बईल को खून म सी कुछ मिलाप वालो तम्बू म लि जाय; ");
INSERT INTO lbm_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","अऊर याजक अपनो बोट खून म डुबाय क ओख बीच वालो परदा को सामने सात बार परमेश्वर को सामने छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","अऊर उच खून म सी वेदी को सींगो पर जो परमेश्वर को सामने मिलाप वालो तम्बू म हय लगाये; अऊर बच्यो हुयो सब खून होमबलि की वेदी की पाया पर जो मिलाप वालो तम्बू को फाटक पर हय कुड़ाय दे। ");
INSERT INTO lbm_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","अऊर ऊ बईल की सब चरबी निकाल क वेदी पर जलाये। ");
INSERT INTO lbm_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","जसो पापबलि को बईल सी करयो होतो वसोच येको सी भी करे; यो तरह याजक इस्राएलियों को पापों ख झाके, तब ओको ऊ पाप माफ करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","अऊर ऊ बईल ख छावनी सी बाहेर लिजाय क उच तरह जलाये जसो पहिलो बईल ख जलायो होतो; वसोच यो मण्डली लायी पापबलि ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","जब कोयी मुखिया पाप कर क्, मतलब अपनो परमेश्वर यहोवा की कोयी आज्ञा को खिलाफ भूल सी कुछ कर क् दोषी होय जाये, ");
INSERT INTO lbm_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","अऊर ओको पाप ओको पर प्रगट होय जाये। त ऊ एक निर्दोष बकरा बलिदान करन लायी ले जाय; ");
INSERT INTO lbm_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","अऊर बकरा को मुंड पर अपनो हाथ रखे, अऊर बकरा ख वा जागा पर बलि करे जहां होमबलिपशु परमेश्वर को सामने बलि करयो जावय हय; यो पापबलि ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","तब याजक अपनो बोट सी पापबलिपशु को खून म सी कुछ ले क होमबलि की वेदी को सींगो पर लगाये, अऊर ओको खून होमबलि की वेदी की पाया पर कुड़ाय दे। ");
INSERT INTO lbm_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","अऊर ऊ ओकी पूरी चरबी ख मेल-मिलाप बलिदान पशु की चरबी को जसो वेदी पर जलाये; अऊर याजक ओको पाप ख झाके, तब ऊ माफ करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","यदि साधारन लोगों म सी कोयी अज्ञानता सी पाप करे, उन कामों म सी कोयी काम ख करय हय जिन्ख परमेश्वर न मना करयो हय, त ऊ दोषी ठहरेंन, ");
INSERT INTO lbm_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","त ऊ पाप को वजह एक निर्दोष शेरी को बच्चा बलिदान लायी ले जाय। ");
INSERT INTO lbm_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","अऊर ऊ अपनो हाथ पापबलिपशु को मुंड पर रखे, अऊर होमबलि को जागा पर पापबलिपशु को बलिदान करे। ");
INSERT INTO lbm_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","अऊर याजक ओको खून म सी अपनो बोट सी कुछ ले क होमबलि की वेदी को सींगो पर लगाये, अऊर ओको सब खून ख उच वेदी की पाया पर कुड़ाय दे। ");
INSERT INTO lbm_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","अऊर ऊ ओकी सब चरबी ख मेल-मिलाप बलिदान पशु की चरबी को जसो अलग करे, तब याजक ओख वेदी पर परमेश्वर लायी सुखदायक सुगन्ध लायी जलाये; अऊर यो तरह याजक ओको पाप झाके, तब ओख माफी मिलेंन। ");
INSERT INTO lbm_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","यदि ऊ पापबलि लायी एक मेंढी को बच्चा लावय, त ऊ निर्दोष मादा होनो चाहिये, ");
INSERT INTO lbm_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","अऊर ऊ अपनो हाथ पापबलिपशु को मुंड पर रखे, अऊर ओख पापबलि लायी उतच बलिदान करे जहां होमबलिपशु बलि करयो जावय हय। ");
INSERT INTO lbm_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","तब याजक अपनो बोट सी पापबलि को खून म सी कुछ ले क होमबलि की वेदी को सींगो पर लगाये, अऊर ओको सब खून ख वेदी की पाया पर कुड़ाय दे। ");
INSERT INTO lbm_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","अऊर ऊ ओकी सब चरबी ख मेल-मिलाप बलिदान वालो मेंढी को बच्चा की चरबी को जसो अलग करे, अऊर याजक ओख वेदी पर परमेश्वर को हवनों को ऊपर जलाये; अऊर यो तरह याजक ओको पाप ख झाके, तब ऊ माफ करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","यदि कोयी गवाह होय क असो पाप करे की कसम खिलाय क पूछन पर भी कि का तय न यो सुन्यो यां जानय हय, अऊर वा बात प्रगट नहीं करय, त ओख अपनो दोष को बोझ उठानो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","यां यदि कोयी दूसरी चिज ख अज्ञानता सी छुय लेवय, त चाहे ऊ अशुद्ध जंगली पशु की, यां अशुद्ध घरेलू पशु की, यां अशुद्ध रेंगन वालो जीव-जन्तु की लोथ होना, त ऊ अशुद्ध होय क दोषी ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","यां कोयी आदमी कोयी अशुद्ध चिज ख अज्ञानता सी छुय लेवय, चाहे ऊ अशुद्ध चिज कोयी भी तरह की होना जेको सी लोग अशुद्ध होय जावय हय, त जब ऊ वा बात ख जान लेयेंन तब ऊ दोषी ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","यदि कोयी बुरो यां भलो करन ख बिना सोचे समझे कसम खाये, यां कोयी तरह की बात ऊ बिना सोच-बिचार कसम खाय क कहे, त असी बात म ऊ दोषी ऊ समय ठहरेंन जब ओख मालूम होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","अऊर जब ऊ इन बातों म सी कोयी भी बात म दोषी हो, तब जो बारे म ओन पाप करयो होना ऊ ओख मान ले, ");
INSERT INTO lbm_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","अऊर ऊ परमेश्वर को सामने अपनो दोषबलि लाये, मतलब ऊ पापबलि को लायी ऊ झुण्ड म सी एक मेंढा यां शेरी पापबलि करन लायी लाये; तब याजक ऊ पाप को बारे म ओको लायी पश्चाताप करे। ");
INSERT INTO lbm_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“पर यदि ओख मेंढा यां शेरी देन की सामर्थ नहीं होना, त अपनो पाप को वजह दोय पण्डुक यां कबूत्तर को दोय बच्चा दोषबलि चढ़ावन लायी परमेश्वर को जवर लाये, उन म सी एक त पापबलि लायी अऊर दूसरो होमबलि लायी। ");
INSERT INTO lbm_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ऊ उन्ख याजक को जवर लाये, अऊर याजक पापबलि वालो ख पहिले चढ़ाये, अऊर ओको मुंड गलो सी मुरकट डाले, पर अलग नहीं करे, ");
INSERT INTO lbm_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","अऊर ऊ पापबलिपशु को खून म सी कुछ वेदी को बाजू म छिड़के, अऊर जो खून बच्यो रहे ऊ वेदी को आधार पर गिरायो जाय; ऊ पापबलि ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","तब दूसरो पक्षी ख वा विधि को अनुसार होमबलि करे, अऊर याजक ओको पाप ख झाके, तब ऊ माफ करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“तब यदि ऊ दोय पण्डुक यां कबूत्तर को दोय बच्चा भी नहीं दे सके, त ऊ अपनो पाप को वजह अपनो चढ़ावा एपा को दशवों हिस्सा मैदा पापबलि कर क् लाये; ओको पर नहीं त ऊ जैतून को तेल डाले, अऊर नहीं लुभान रखे, कहालीकि ऊ पापबलि होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ऊ ओख याजक को जवर ले जाय, अऊर याजक ओको म सी अपनी मुट्ठी भर याद दिलावन वालो हिस्सा जान क वेदी पर परमेश्वर को वेदी को ऊपर जलाये; ऊ पापबलि ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","अऊर इन बातों म सी कोयी भी बात को बारे म जो कोयी पाप करे, याजक ओको पाप ख झाके, तब ओको ऊ पाप माफ करयो जायेंन। तब अन्नबलि को जसो बच्यो हिस्सा याजक को होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“यदि कोयी परमेश्वर की पवित्र करी हुयी चिजों को बारे म भूल सी विश्वासघात करे अऊर पापी ठहरे, त ऊ परमेश्वर को जवर एक निर्दोष मेंढा दोषबलि लायी लाये; ओको दाम पवित्र जागा को शेकेल को अनुसार उतनोच शेकेल चांदी को हो जितनो याजक ठहरायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","अऊर जो पवित्र चिज को बारे म ओन पाप करयो होना, ओको म ऊ पाचवों हिस्सा अऊर बढ़ाय क याजक ख दे; अऊर याजक दोषबलि को मेंढा चढ़ाय क ओको पाप ख झाके, तब ओको पाप माफ करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“यदि कोयी असो पाप करे, कि उन कामों म सी जिन्ख परमेश्वर न मना करयो हय कोयी काम ख करे, त चाहे ऊ ओको अनजानो म भयो होना, त भी ऊ दोषी ठहरेंन, अऊर ओख अपनो बुरायी को बोझ उठानो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","येकोलायी ऊ एक निर्दोष मेंढा दोषबलि कर क् याजक को जवर लाये, ऊ उतनो दाम को होना जितनो याजक ठहराये, अऊर याजक ओको लायी ओकी वा भूल को जो ओन अनजानो म करयो हुयो पाप ख झाके, अऊर ऊ माफ करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यो दोषबलि ठहरे; कहालीकि बिना शक परमेश्वर को सामने दोषी ठहरेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“यदि कोयी परमेश्वर को विश्वासघात कर क् पापी ठहरे, जसो कि जायजाद, यां लेन देन यां लूट को बारे म अपनो भाऊ सी छल करे, यां ओको पर अत्याचार करे, ");
INSERT INTO lbm_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","यां पड़ी हुयी चिज ख पा क ओको बारे म झूठ बोले अऊर झूठी कसम भी खाये; असी कोयी भी बात कहाली नहीं हो जेक कर क् आदमी पापी ठहरय हय, ");
INSERT INTO lbm_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","त जब ऊ असो काम कर क् दोषी होय जाये, तब जो भी चिज ओन लूट, यां अत्याचार कर क्, यां जायजाद, यां पड़ी हुयी पायी होना; ");
INSERT INTO lbm_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","चाहे कोयी चिज कहाली नहीं हो जेको बारे म ओन झूठी कसम खायी होना; त ऊ ओख पूरो-पूरो लौटाय दे, अऊर पाचवों हिस्सा भी बढ़ाय क भर दे, जो दिन यो मालूम होय कि ऊ दोषी हय, उच दिन ऊ चिज ख ओको लौटाय दे। ");
INSERT INTO lbm_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","अऊर ऊ परमेश्वर को सामने अपनो दोषबलि भी लाये, मतलब एक निर्दोष मेंढा दोषबलि लायी याजक को जवर लाये, ऊ उतनोच दाम को होना जितनो याजक ठहराये। ");
INSERT INTO lbm_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","यो तरह याजक ओको लायी परमेश्वर को सामने पाप ख झाके, अऊर जो काम ख कर क् ऊ दोषी भय गयो हय ओकी माफी ओख मिलेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून अऊर ओको टुरावों ख आज्ञा दे क यो कह्य कि होमबलि की व्यवस्था या हय: होमबलि अग्निकुन्ड को ऊपर रात भर रख क सुबेरे तक वेदी पर पड़ी रहे, अऊर वेदी की आगी वेदी पर जरती रहे। ");
INSERT INTO lbm_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","अऊर याजक अपनो सन को कपड़ा अऊर अपनो तन पर सन की जांघियां पहिन क होमबलि की राख, जो आगी को भस्म करन सी वेदी पर रह्य जाये, ओख उठाय क ओख वेदी को बाजू म रखे। ");
INSERT INTO lbm_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","तब ऊ अपनो यो कपड़ा उतार क दूसरो कपड़ा पहिन क राख ख छावनी सी बाहेर कोयी शुद्ध जागा पर लिजाये। ");
INSERT INTO lbm_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदी पर आगी जरती रहे, अऊर कभी बुझन मत देवो; अऊर याजक हर दिन सुबेरे ओको पर लकड़ियां जलाय क होमबलि को टुकड़ा ख ओको पर सजाय क रख दे, अऊर ओको ऊपर मेल-मिलाप बलिदान पशु की चरबी ख जलायो करे। ");
INSERT INTO lbm_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदी पर आगी लगातार जरती रहे; अऊर वा कभी बुझनो नहीं पाये। ");
INSERT INTO lbm_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“अनाज भेंट चढ़ावन की व्यवस्था यो तरह हय: हारून को टुरा ओख वेदी को आगु परमेश्वर को सामने लाये। ");
INSERT INTO lbm_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","अऊर ऊ अनाज भेंट चढ़ावन को तेल मिल्यो हुयो मैदा म सी मुट्ठी भर अऊर ओको पर को सब लुभान उठाय क अनाज भेंट की याद म यो हिस्सा ख परमेश्वर को सामने सुखदायक सुगन्ध लायी वेदी पर जलाये। ");
INSERT INTO lbm_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","अऊर ओको म सी जो बच्यो रह्य जाये ओख हारून अऊर ओको टुरा खाये; ऊ बिना खमीर पवित्र जागा म खायो जाये, मतलब हि मिलाप वालो तम्बू को आंगन म ओख खाये। ");
INSERT INTO lbm_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ऊ खमीर को संग पकायो नहीं जाये; कहालीकि मय न अपनो अन्नबलि म सी ओख दियो हय; येकोलायी जसो पापबलि अऊर दोषबलि अती पवित्र हय वसोच ऊ भी हय। ");
INSERT INTO lbm_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","तुम्हरी पीढ़ी-पीढ़ी म हारून को वंश को सब आदमी ओको म सी खाय सकय हंय, परमेश्वर को भेंटों म सी यो ओको हिस्सा हमेशा बन्यो रहेंन; जो कोयी उन भेंटों ख छुवय ऊ पवित्र ठहरेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ जो दिन हारून को अभिषेक होयेंन ऊ दिन ऊ अपनो टुरा को संग परमेश्वर ख यो चढ़ावा चढ़ाये; मतलब एपा को दसवों हिस्सा मैदा रोज अन्नबलि म चढ़ाये, ओको म सी अरधो सुबेरे अऊर अरधो शाम को समय चढ़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ऊ तवा पर तेल को संग पकायो जाय; जब ऊ तेल सी तल क होय जाये तब ओख लायजो, यो अन्नबलि को पक्यो हुयो तुकड़ा परमेश्वर को सुखदायक सुगन्ध लायी चढ़ायजो। ");
INSERT INTO lbm_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","हारून को टुरावों म सी जो ऊ याजकपद पर अभिषिक्त होयेंन, ऊ भी उच तरह को चढ़ावा चढ़ायो करे; या विधि हमेशा लायी हय, कि परमेश्वर को सामने ऊ पूरो चढ़ावा जलायो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","याजक को पूरो अन्नबलि भी जलायो जाये; ऊ कभी नहीं खायो जाय।” ");
INSERT INTO lbm_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून अऊर ओको टुरावों सी यो कह्य कि पापबलि की व्यवस्था या हय: जो जागा म होमबलिपशु मारयो जावय हय ओकोच म पापबलिपशु भी परमेश्वर को सामने बलि करयो जाय; ऊ परमपवित्र हय।” ");
INSERT INTO lbm_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जो याजक पापबलि चढ़ाये ऊ ओख खाये; ऊ पवित्र जागा म, मतलब मिलाप वालो तम्बू को आंगन म खायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जो कोयी ओको मांस ख छुयेंन, ऊ पवित्र होय जायेंन। यदि ओको खून को छीटा कपड़ा पर पड़ेंन त ऊ कपड़ा ख जेक पर छीटा पड़ गयो हय, ओख पवित्र जागा म धोय लेजो। ");
INSERT INTO lbm_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","जो माटी को बर्तन म ऊ पकायो जायेंन, त ऊ बर्तन ख तोड़ देजो, पर यदि ऊ पीतल को बर्तन म पकायो गयो हय, त ऊ मांज्यो अऊर पानी सी धोयो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","याजक म सी सब आदमी ओख खाय सकय हंय; ऊ परमपवित्र चिज आय। ");
INSERT INTO lbm_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","पर जो पापबलिपशु को खून म सी कुछ भी खून मिलाप वालो तम्बू को अन्दर पवित्र जागा म पश्चाताप करन लायी पहुंचायो जाय ओको मांस कभी नहीं खायो जाय; ऊ आगी म जलाय दियो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","फिर दोषबलि की व्यवस्था या हय, ऊ अती पवित्र हय। ");
INSERT INTO lbm_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","जो जागा पर होमबलिपशु की बलि करय हय उच जागा पर दोषबलिपशु भी बलि करे, अऊर ओको खून ख याजक वेदी पर चारयी तरफ छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ओकी पूरी चरबी ख चढ़ाये, मतलब ओकी मोटी पूछ ख, अऊर जो चरबी सी अतड़ियां झकी रह्य हय, ");
INSERT INTO lbm_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","अऊर दोयी गुड़दा अऊर जो चरबी ओको ऊपर अऊर कमर को जवर रह्य हय, अऊर गुड़दावों समेत कलेजा को ऊपर की झिल्ली; इन सब ख ऊ अलग करे; ");
INSERT INTO lbm_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","अऊर याजक इन ख वेदी पर परमेश्वर लायी आगी म जलाये; तब ऊ दोषबलि होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","याजकों म को सब आदमी ओको म सी खाय सकय हय; ऊ कोयी पवित्र जागा म खायो जाये; कहालीकि ऊ परमपवित्र हय। ");
INSERT INTO lbm_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","जसो पापबलि हय वसोच दोषबलि भी हय, उन दोयी की एकच व्यवस्था हय; जो याजक उन बलियों ख चढ़ाय क पाप ख झाके उच उन चिजों ख ले ले। ");
INSERT INTO lbm_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","अऊर जो याजक कोयी लायी होमबलि ख चढ़ाये ऊ होमबलिपशु की खाल ख उच याजक ले ले। ");
INSERT INTO lbm_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","अऊर भट्टी म, यां कढ़ाई म, यां तवा पर पक्यो हुयो सब अनाज की भेंट उच याजक को होयेंन जो उन्ख चढ़ावय हय। ");
INSERT INTO lbm_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","अऊर सब अनाज की भेंट, जो चाहे तेल सी सान्यो हुयो होना यां सुख्यो होना, हि हारून को सब टुरावों ख एक जसो मिले। ");
INSERT INTO lbm_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","मेल-मिलाप बलि की, जेख कोयी परमेश्वर लायी चढ़ाये त व्यवस्था या आय। ");
INSERT INTO lbm_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","यदि ऊ ओख धन्यवाद लायी चढ़ाये, त धन्यवाद बलि को संग तेल सी सान्यो हुयो अखमीरी पतली रोटी, अऊर तेल लगायी हुयी मोटी रोटियां, अऊर तेल सी सान्यो हुयो मैदा की सुवारी तेल सी तल क चढ़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","अऊर ऊ अपनो धन्यवाद वालो मेल-मिलाप बलि को संग खमीरी रोटियां, भी चढ़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","अऊर एक एक चढ़ावा म सी ऊ एक एक रोटी परमेश्वर ख भेंट कर क् चढ़ाये; ऊ मेल-मिलाप बलि को खून को छिड़कन वालो याजक को होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","अऊर ऊ धन्यवाद वालो मेल-मिलाप बलि को मांस बलिदान चढ़ावन को दिनच खायो जाय; ओको म सी कुछ भी सुबेरे तक बच्यो नहीं रह जाये। ");
INSERT INTO lbm_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","पर यदि ओको बलिदान को चढ़ावा मन्नत यां खुद की इच्छा को हो, त ऊ बलिदान ख जो दिन ऊ चढ़ायो जाय उच दिन ऊ खायो जाय, अऊर ओको म सी जो बच्यो रह जाये ऊ दूसरो दिन भी खायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","पर जो कुछ बलिदान को मांस म सी तीसरो दिन तक बच जाये त ओख आगी म जलाय दियो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","अऊर ऊ मेल-मिलाप बलि को मांस म सी यदि कुछ भी तीसरो दिन खायो जाय, त ऊ स्विकार नहीं करयो जायेंन, अऊर नहीं ओको हित म गिन्यो जायेंन; लेकिन येख अशुद्ध मान्यो जायेंन, अऊर जो येख खायेंन, ओको परिनाम ओख भुगतनो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“फिर जो मांस अशुद्ध चिज सी छुय जाये ऊ नहीं खायो जाय; ओख आगी म जलाय दियो जायेंन।” फिर जितनो मांस शुद्ध होना ओख खाये, ");
INSERT INTO lbm_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","पर जो अशुद्ध होय क परमेश्वर को मेलबलि को मांस म सी कुछ खाये ऊ अपनो लोगों म सी नाश करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“अऊर यदि कोयी अशुद्ध चिज ख छुय क परमेश्वर को मेल-मिलाप बलि पशु को मांस म सी खाये, त ऊ भी अपनो लोगों म सी नाश करयो जायेंन, चाहे ऊ आदमी की कोयी अशुद्ध चिज यां अशुद्ध पशु यां कोयी भी अशुद्ध अऊर घृणित चिज हो।” ");
INSERT INTO lbm_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएलियों सी यो तरह कह्य: तुम लोग नहीं त बईल की कुछ चरबी खावो अऊर नहीं मेंढा यां शेरी की। ");
INSERT INTO lbm_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","अऊर जो पशु खुद मर जाये, अऊर जो दूसरो पशु सी फाड़्यो जाये, ओकी चरबी दूसरो काम म लावो, पर ओख खावो मत। ");
INSERT INTO lbm_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","जो कोयी असो पशु की चरबी खायेंन जेको म सी लोग कुछ परमेश्वर लायी बलिदान कर क् चढ़ायो करय हय ओख खान वालो ख अपनो लोगों म सी नाश करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","तुम अपनो घर म कोयी अलग को खून, चाहे पक्षी को चाहे पशु को खून हो, मत खावो। ");
INSERT INTO lbm_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","हर एक प्रानी जो कोयी को खून खायेंन ऊ अपनो लोगों म सी बाहेर करयो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएलियों सी यो तरह कह्य: जो परमेश्वर लायी मेल-मिलाप बलि चढ़ाये ऊ उच मेल-मिलाप बलि म सी परमेश्वर को जवर भेंट लाये; ");
INSERT INTO lbm_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ऊ अपनोच हाथों सी परमेश्वर को बलि ख, मतलब छाती समेत चरबी ख लाये कि छाती हिलावन की भेंट कर क् परमेश्वर को सामने हिलायी जाये।” ");
INSERT INTO lbm_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","अऊर याजक चरबी ख त वेदी पर जलायेंन, पर छाती हारून अऊर ओको टुरावों की होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","फिर तुम अपनो मेल-मिलाप बलियों म सी दायो जांघ ख भी चढ़ावा को रूप म याजक ख देजो। ");
INSERT INTO lbm_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारून को टुरावों म सी मेल-मिलाप बलि को खून अऊर चरबी ख चढ़ाये दायो जांघ ओकोच हिस्सा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","कहालीकि इस्राएलियों को मेल-मिलाप बलियों म सी हिलावन की भेंट की छाती अऊर उठावन की भेंट की जांघ ख ले क मय न याजक हारून अऊर ओको टुरावों ख दियो हय, कि यो हमेशा इस्राएलियों की तरफ सी उन्को हक बन्यो रहे। ");
INSERT INTO lbm_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“जो दिन हारून अऊर ओको टुरा परमेश्वर को सामने याजक पद लायी लायो गयो, उच दिन परमेश्वर को बलिदानों म सी उन्को योच अभिषिक्त हिस्सा ठहरायो गयो; ");
INSERT INTO lbm_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","मतलब जो दिन परमेश्वर न उन्को अभिषेक करयो उच दिन ओन आज्ञा दी कि उन्ख इस्राएलियों को तरफ सी यो हिस्सा हमेशा मिलतो रहे; उन्की पीढ़ी-पीढ़ी लायी उन्को योच हक ठहरायो गयो।” ");
INSERT INTO lbm_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","होमबलि, अन्नबलि, पापबलि, दोषबलि, याजकों को संस्कार बलि, अऊर मेल-मिलाप बलि की व्यवस्था याच आय; ");
INSERT INTO lbm_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","जब परमेश्वर न सीनै पहाड़ी को जवर को बंजर जागा म मूसा ख आज्ञा दी कि इस्राएली मोरो लायी का-का चढ़ावा चढ़ाये, तब ओन उन्ख याच व्यवस्था दी होती। ");
INSERT INTO lbm_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“तय हारून अऊर ओको टुरावों को कपड़ावों, अऊर अभिषेक को तेल, अऊर पापबलि को बईल, अऊर दोयी मेंढावों, अऊर अखमीरी रोटी की टोकनी ख, ");
INSERT INTO lbm_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","मिलाप वालो तम्बू को फाटक पर ले आव, अऊर वहांच पूरी मण्डली ख जमा कर।” ");
INSERT INTO lbm_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","परमेश्वर की या आज्ञा को अनुसार मूसा न करयो; अऊर मण्डली मिलाप वालो तम्बू को फाटक पर जमा भयी। ");
INSERT INTO lbm_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","तब मूसा न मण्डली सी कह्यो, “जो काम करन की आज्ञा परमेश्वर न दी हय वा या आय।” ");
INSERT INTO lbm_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","फिर मूसा न हारून अऊर ओको टुरावों ख जवर लाय क पानी सी नहलायो। ");
INSERT INTO lbm_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","तब ओन हारून ख कुरता पहिनायो, अऊर कुरता ख कमर पट्टा सी कस दियो। ओख अंगरखा पहिनायो। अऊर एपोद डाल्यो, अऊर कलात्मक ढंग सी बुन्यो हुयो एपोद को पट्टा सी ओख बान्ध क कस दियो। ");
INSERT INTO lbm_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","अऊर ओन चपरास लगाय क सिनाबन्ध म ऊरीम अऊर तुम्मीम रख दियो। ");
INSERT INTO lbm_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","तब ओन ओको मुंड पर फेटा बान्ध क फेटा को आगु सोना की पट्टी ख मतलब पवित्र मुकुट ख लगायो, जो तरह परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","तब मूसा न अभिषेक को तेल ले क निवास को अऊर जो कुछ ओको म होतो उन सब को भी अभिषेक कर क् उन्ख पवित्र करयो। ");
INSERT INTO lbm_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","अऊर ऊ तेल म सी कुछ ओन वेदी पर सात बार छिड़क्यो, अऊर पूरो सामान सहित वेदी को अऊर पाया समेत गंगार को अभिषेक कर क् उन्ख पवित्र करयो। ");
INSERT INTO lbm_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","अऊर ओन अभिषेक को तेल म सी कुछ हारून को मुंड पर डाल क ओको अभिषेक कर क् ओख पवित्र करयो। ");
INSERT INTO lbm_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","तब मूसा न हारून को टुरावों ख जवर लाय क, अंगरखा पहिनाय क, अऊर कमर पट्टा बान्ध क उन्को मुंड पर टोपी रख दियो, जो तरह परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","तब ऊ पापबलि को बईल ख जवर लाय क; अऊर हारून अऊर ओको टुरावों न अपनो अपनो हाथ पापबलि को बईल को मुंड पर रखे। ");
INSERT INTO lbm_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","तब मूसा न ओख बलि करयो, अऊर मूसा न खून ले क बोट सी वेदी को चारयी सींगो पर लगाय क पवित्र करयो, अऊर खून ख वेदी को पाया पर कुड़ाय दियो, अऊर ओको पाप झाके अऊर ओख पवित्र करयो। ");
INSERT INTO lbm_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","अऊर मूसा न अतड़ियां पर की चरबी, अऊर कलेजा पर की झिल्ली, अऊर चरबी समेत दोयी गुड़दावो ख ले क वेदी पर जलायो। ");
INSERT INTO lbm_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","पर बईल म सी जो कुछ बच्यो रह्य गयो ओख, मतलब गोबर समेत ओकी खाल, मांस अऊर मांस ख छावनी सी बाहेर आगी म जलायो, जो तरह परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","तब मूसा न होमबलि लायी मेंढा ख लायो, हारून अऊर ओको टुरावों न ऊ मेंढा को मुंड पर अपनो हाथ रखे। ");
INSERT INTO lbm_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","मूसा न ओख बलि करयो, अऊर येको खून ख वेदी को चारयी तरफ छिड़क दियो। ");
INSERT INTO lbm_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","उन्न यो मेंढा को तुकड़ा तुकड़ा करयो अऊर मूसा न ओको मुंड, ओको टुकड़ावों अऊर चरबी ख जलाय दियो। ");
INSERT INTO lbm_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","मूसा न अतड़ियां अऊर पाय ख पानी सी धोय क पूरो मेंढा ख वेदी पर जलायो; अऊर ऊ सुखदायक सुगन्ध देन लायी होमबलि अऊर परमेश्वर लायी बलिदान भय गयो, जो तरह परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","तब मूसा न दूसरो मेंढा ख जो अभिषेक को मेंढा होतो जवर लायो, अऊर हारून अऊर ओको टुरावों न अपनो अपनो हाथ मेंढा को मुंड पर रख्यो। ");
INSERT INTO lbm_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","तब ऊ बलि करयो गयो, अऊर मूसा न ओको खून म सी कुछ ले क हारून को दायो कान को कोना पर अऊर ओको दायो हाथ अऊर दायो पाय को अंगूठा पर लगायो। ");
INSERT INTO lbm_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","अऊर ऊ हारून को टुरावों ख जवर ले गयो, अऊर खून म सी एक-एक को दायो कान को कोना पर अऊर दायो हाथ अऊर दायो पाय को अंगूठा पर लगायो; अऊर मूसा न खून ख वेदी पर चारयी तरफ छिड़क्यो। ");
INSERT INTO lbm_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","अऊर ओन चरबी, अऊर चरबीदार पूछ, अऊर अतड़ियों पर की सब चरबी, अऊर कलेजा पर की झिल्ली समेत दोयी गुड़दा, अऊर दियो जांघ, हि सब ले क अलग रखे। ");
INSERT INTO lbm_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","अऊर अखमीरी रोटी की टोकनी जो परमेश्वर को आगु रखी गयी होती ओको म सी एक अखमीरी रोटी, अऊर तेल सी सान्यो हुयो मैदा को एक सुवारी, अऊर एक सुवारी ले क अऊर चरबी दायो जांघ पर रख दियो। ");
INSERT INTO lbm_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","अऊर या सब चिजे हारून अऊर ओको टुरावों को हाथों पर रख दी गयी, इन्ख परमेश्वर ख चढ़ावन की भेंट मान क परमेश्वर को आगु हिलायी गयी। ");
INSERT INTO lbm_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","तब मूसा न उन्ख फिर उन्को हाथों पर सी ले क उन्ख वेदी पर जलायो, यो सुखदायक सुगन्ध देन लायी अभिषेक की भेंट अऊर परमेश्वर लायी अग्निबलि होती। ");
INSERT INTO lbm_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","तब मूसा न छाती ख ले क हिलावन की भेंट को रूप म परमेश्वर को सामने हिलायो। अभिषेक को मेंढा म सी मूसा को हिस्सा होतो; जसो परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","तब मूसा न अभिषेक को तेल अऊर वेदी पर को खून, दोयी म सी कुछ ले क हारून अऊर ओको कपड़ा पर, अऊर ओको टुरावों अऊर उन्को कपड़ा पर भी छिड़क्यो; अऊर ओन कपड़ा समेत हारून ख भी पवित्र करयो। ");
INSERT INTO lbm_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","तब मूसा न हारून अऊर ओको टुरावों सी कह्यो, “मांस ख मिलाप वालो तम्बू को फाटक पर पकावों, अऊर वा रोटी ख जो अभिषेक की टोकनी म हय उतच खावो, जसो मय न आज्ञा दी हय कि हारून अऊर ओको टुरा ओख खाये। ");
INSERT INTO lbm_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","अऊर मांस अऊर रोटी म सी जो बच्यो हुयो ख आगी म जलाय देवो। ");
INSERT INTO lbm_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","अऊर जब तक तुम्हरो अभिषेक को दिन पूरो नहीं होय जाये तब तक, मतलब सात दिन तक मिलाप वालो तम्बू को फाटक को बाहेर मत जाजो, कहालीकि ऊ सात दिन तक तुम्हरो अभिषेक करतो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","जो तरह अज करयो गयो हय वसोच करन की आज्ञा परमेश्वर न दी हय, जेको सी तुम्हरो पाप झाक्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","येकोलायी तुम मिलाप वालो तम्बू को फाटक पर सात दिन अऊर सात रात ठहरे रहजो, ताकि तुम मर नहीं जावो; कहालीकि असीच आज्ञा मोख दी गयी हय।” ");
INSERT INTO lbm_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","तब परमेश्वर की याच सब निर्देश आज्ञावों को अनुसार जो ओन मूसा सी दी होती हारून अऊर ओको टुरावों न करयो। ");
INSERT INTO lbm_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठवों दिन मूसा न हारून अऊर ओको टुरावों ख अऊर इस्राएली बुजूर्गों ख बुलाय क कह्यो। ");
INSERT INTO lbm_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","“पापबलि लायी एक निर्दोष बछड़ा, अऊर होमबलि लायी एक निर्दोष मेंढा लाय क परमेश्वर को सामने भेंट चढ़ाव। ");
INSERT INTO lbm_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","अऊर इस्राएलियों सी यो कह्य, ‘तुम पापबलि लायी एक बकरा, अऊर होमबलि लायी एक बछड़ा अऊर एक मेंढी को बच्चा लावो, जो एक साल को हो अऊर पूर्ण स्वस्थ हो,’ ");
INSERT INTO lbm_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","अऊर मेल-मिलाप बलि लायी परमेश्वर को सामने चढ़ावन लायी एक बईल अऊर एक मेंढा, अऊर तेल सी सान्यो हुयो मैदा को एक अनाज भेंट भी लावो; कहालीकि अज परमेश्वर तुम्ख दर्शन देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","अऊर जो-जो चिज की आज्ञा मूसा न दी उन सब ख हि मिलाप वालो तम्बू को आगु लाये; अऊर पूरी मण्डली जवर जाय क परमेश्वर को सामने खड़ी भयी। ");
INSERT INTO lbm_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","तब मूसा न कह्यो, “यो ऊ काम आय जेक करन लायी परमेश्वर न आज्ञा दी हय कि तुम ओख करो; अऊर परमेश्वर की महिमा तुम ख दिखायी पड़ेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","तब मूसा न हारून सी कह्यो, “परमेश्वर की आज्ञा को अनुसार वेदी को जवर जाय क अपनो पापबलि अऊर होमबलि ख चढ़ाय क अपनो अऊर सब जनता को पाप ख झाके करो अऊर जनता को चढ़ावा ख भी चढ़ाय क ओको पाप ख झाके।” ");
INSERT INTO lbm_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","येकोलायी हारून न वेदी को जवर जाय क अपनो पापबलि को बछड़ा ख बलिदान करयो। ");
INSERT INTO lbm_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","अऊर हारून को टुरा खून ख ओको जवर ले गयो, तब ओन अपनो बोट ख खून म डुबाय क वेदी को सींगो पर खून ख लगायो, अऊर बच्यो खून ख वेदी को पाया पर कुड़ाय दियो; ");
INSERT INTO lbm_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","अऊर पापबलि म की चरबी अऊर गुड़दा अऊर कलेजा पर की झिल्ली ख ओन वेदी पर जलायो, जसो परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","अऊर मांस अऊर खाल ख ओन छावनी सी बाहेर आगी म जलायो। ");
INSERT INTO lbm_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","तब होमबलिपशु ख भेंट चढ़ायो; अऊर हारून को टुरावों न खून ख ओको हाथ म दियो, अऊर ओन ओख वेदी पर चारयी तरफ छिड़क दियो। ");
INSERT INTO lbm_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","तब उन्न होमबलिपशु को तुकड़ा अऊर मुंड सहित ओको हाथ म दियो अऊर ओन ओख वेदी पर जलाय दियो। ");
INSERT INTO lbm_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","अऊर ओन अतड़ियों अऊर पाय ख धोय क वेदी पर होमबलि को ऊपर जलायो। ");
INSERT INTO lbm_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","तब हारून न लोगों को चढ़ावा ख आगु लाय क अऊर ऊ पापबलि को बकरा जो लोगों लायी होतो ले क ओकी बलि चढ़ायो, अऊर पहिले को जसो ओख भी पापबलि कर क् चढ़ायो। ");
INSERT INTO lbm_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","अऊर ओन होमबलि ख भी जवर लिजाय क विधि को अनुसार चढ़ायो। ");
INSERT INTO lbm_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","अऊर अनाज भेंट ख भी जवर लिजाय क ओको म सी मुट्ठी भर वेदी पर जलायो, यो सुबेरे को होमबलि को सहित चढ़ायो गयो। ");
INSERT INTO lbm_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","बईल अऊर मेंढा, मतलब जो मेल-मिलाप बलि पशु, जनता लायी होतो हि भी बलि करयो गयो; अऊर हारून को टुरावों न खून ख उन्को हाथ म दियो,अऊर ओन ओख वेदी पर चारयी तरफ छिड़क दियो; ");
INSERT INTO lbm_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","अऊर उन्न बईल की चरबी ख, अऊर मेंढा म सी चरबीदार पूछ ख, अऊर जो चरबी सी अंतड़ियां झकी रह्य हय ओख, अऊर गुड़दावो सहित कलेजा पर की झिल्ली ख भी ओको हाथ म दियो; ");
INSERT INTO lbm_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","अऊर उन्न चरबी ख जनावरों की छातियों पर रख्यो; अऊर ओन वा चरबी वेदी पर जलायी, ");
INSERT INTO lbm_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","पर छातियों अऊर दायो जांघ ख हारून न मूसा की आज्ञा को अनुसार हिलावन की भेंट लायी परमेश्वर को सामने हिलायो। ");
INSERT INTO lbm_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","तब हारून न लोगों को तरफ हाथ बढ़ाय क उन्ख आशीर्वाद दियो; अऊर पापबलि, होमबलि, अऊर मेल-मिलाप बलियों ख चढ़ाय क ऊ खल्लो उतर गयो। ");
INSERT INTO lbm_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","तब मूसा अऊर हारून मिलाप वालो तम्बू म गयो, अऊर बाहेर निकल क लोगों ख आशीर्वाद दियो; तब परमेश्वर को महिमा पूरी जनता ख दिखायी दियो। ");
INSERT INTO lbm_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","अऊर परमेश्वर को सामने सी आगी निकली अऊर चरबी सहित होमबलि ख वेदी पर भस्म कर दियो; येख देख क जनता न जय जयकार को नारा लगायो अऊर अपनो अपनो मुंह को बल गिर क दण्डवत प्रनाम करयो। ");
INSERT INTO lbm_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","तब नादाब अऊर अबीहू नाम को हारून को दोय टुरावों न अपनो अपनो धूपदान लियो, अऊर उन म आगी भरी, अऊर ओको म धूप डाल क वा ऊपरी आगी ख जेकी आज्ञा परमेश्वर न नहीं दी होती परमेश्वर को सामने चढ़ायो। ");
INSERT INTO lbm_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","तब परमेश्वर को सामने सी आगी निकली, अऊर उन दोयी ख भस्म कर दियो, अऊर हि परमेश्वर को सामने मर गयो। ");
INSERT INTO lbm_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","तब मूसा न हारून सी कह्यो, “या वाच बात आय जेक परमेश्वर न कह्यो होतो कि जो मोरो जवर आयेंन, जरूरी हय कि ऊ मोख पवित्र जाने, अऊर पूरी जनता को सामने मोरी महिमा करे।” पर हारून चुप रह्यो। ");
INSERT INTO lbm_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","तब मूसा न मीशाएल अऊर एलसाफान ख जो हारून को काका उज्जीएल को टुरा होतो बुलाय क कह्यो, “जवर आवो, अऊर अपनो भतीजों ख पवित्र जागा को सामने सी उठ क छावनी को बाहेर ले जावो।” ");
INSERT INTO lbm_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","मूसा की या आज्ञा को अनुसार हि जवर जाय क उन्ख अंगरखा सहित उठाय क छावनी को बाहेर गयो। ");
INSERT INTO lbm_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","तब मूसा न हारून सी अऊर ओको टुरा एलीआजार अऊर ईतामार सी कह्यो, “तुम लोग अपनो मुंड को बाल मत बिखरावो, अऊर नहीं अपनो कपड़ावों ख फाड़ो, असो नहीं होय कि तुम भी मर जावो, अऊर पूरी मण्डली पर ओको गुस्सा भड़क उठेंन; पर ऊ इस्राएल को पूरो घराना को लोग जो तुम्हरो भाऊबन्धु हंय परमेश्वर की आगी सी जर गयो ओको पर विलाप करे। ");
INSERT INTO lbm_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","अऊर तुम लोग मिलाप वालो तम्बू को फाटक को बाहेर मत जाजो, असो नहीं होय कि तुम मर जावो; कहालीकि परमेश्वर को अभिषेक को तेल तुम पर लग्यो हुयो हय।” मूसा को यो वचन को अनुसार उन्न करयो। ");
INSERT INTO lbm_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","तब परमेश्वर न हारून सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“जब जब तय यां तोरो टुरा मिलाप वालो तम्बू म आये तब तब तुम म सी कोयी अंगूरीरस यां दारू मत पीवो; कहीं असो नहीं हो कि तुम मर जावो; तुम्हरी पीढ़ी पीढ़ी म या विधि चलती रहे, ");
INSERT INTO lbm_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","जेकोसी तुम पवित्र अऊर अपवित्र म, अऊर शुद्ध अऊर अशुद्ध म अन्तर कर सको, ");
INSERT INTO lbm_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","अऊर इस्राएलियों ख उन सब विधियों ख सिखाय सको जेक परमेश्वर न मूसा को द्वारा उन्ख बताय दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","फिर मूसा न हारून सी अऊर ओको टुरा भयो दोयी टुरा ईतामार अऊर एलीआजार सी भी कह्यो, “परमेश्वर को भेंट म सी जो अनाज बलि बच्यो हय ओख ले क वेदी को जवर बिना खमीर को खावो, कहालीकि ऊ परमपवित्र हय; ");
INSERT INTO lbm_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","अऊर तुम ओख कोयी पवित्र जागा म खावो, ऊ परमेश्वर को भेंट म सी तोरो अऊर तोरो टुरावों को हक हय; कहालीकि मय न असीच आज्ञा पायी हय। ");
INSERT INTO lbm_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","पर हिलायी हुयी भेंट की छाती अऊर उठायी हुयी भेंट की जांघ ख तुम लोग, मतलब तय अऊर तोरो बेटा-बेटियां सब कोयी शुद्ध जागा म खावो; कहालीकि हि इस्राएलियों को मेल-मिलाप बलियों म सी तोख अऊर तोरो टुरावों को हक ठहराय दियो गयो हय। ");
INSERT INTO lbm_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","चर्बी को अग्निबलियों समेत जो उठायी हुयी जांघ अऊर हिलायी हुयी छाती परमेश्वर को सामने हिलावन लायी आयो करेंन, यो हिस्सा परमेश्वर की आज्ञा को अनुसार हमेशा की विधि की व्यवस्था सी तोरो अऊर तोरो बच्चां लायी हय।” ");
INSERT INTO lbm_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","फिर मूसा न पापबलि को बकरा की जांच-पड़ताल करी, त का पायो कि ऊ जलायो गयो हय, येकोलायी एलीआजार अऊर ईतामार जो हारून को टुरा बच्यो होतो उन्कोसी ऊ गुस्सा म आय क कहन लग्यो, ");
INSERT INTO lbm_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“पापबलि जो परमपवित्र हय अऊर जेक परमेश्वर न तुम्ख येकोलायी दियो हय कि तुम मण्डली को पाप को बोझ अपनो ऊपर उठाय क ओको लायी परमेश्वर को सामने पश्चाताप करो, तुम न ओको मांस पवित्र जागा म कहाली नहीं खायो? ");
INSERT INTO lbm_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","देखो, ओको खून भी पवित्र जागा को अन्दर म नहीं लायो गयो होतो, तुम्ख ओख पवित्र जागा म खानो होतो; जसो मय न आज्ञा दियो होतो।” ");
INSERT INTO lbm_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","येको उत्तर हारून न मूसा ख यो तरह सी दियो, “देख, अजच उन्न अपनो पापबलि अऊर होमबलि ख परमेश्वर को सामने चढ़ायो; फिर भी मोरो पर असी विपत्तियां आय पड़ी हय! येकोलायी यदि मय अज पापबलि को मांस खातो त का या बात परमेश्वर को सामने अच्छी होती?” ");
INSERT INTO lbm_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जब मूसा न यो सुन्यो तब ओख अच्छो लग्यो। ");
INSERT INTO lbm_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","फिर परमेश्वर न मूसा अऊर हारून सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएलियों सी कहो: जितनो पशु धरती पर हय उन सब म सी तुम इन जीवधारियों को मांस खाय सकय हय।” ");
INSERT INTO lbm_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","पशुवों म सी जितनो चिरयो यां फट्यो खुरी को होवय हय अऊर कवरी करय हय, उन्ख खाय सकय हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","पर कवरी करन वालो यां फटी खुरी वालो को अलावा इन जनावरों ख मत खावो, मतलब ऊंट, जो कवरी त करय हय पर चिरयो खुरी को नहीं होवय हय, येकोलायी ऊ तुम्हरो लायी अशुद्ध ठहरयो हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","अऊर चट्टानी बिज्जू, जो कवरी त करय हय पर चिरयो खुरी को नहीं होवय, ऊ भी तुम्हरो लायी अशुद्ध होवय हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","अऊर ससा, जो कवरी त करय हय पर चिरयो खुरी को नहीं होवय, येकोलायी ऊ भी तुम्हरो लायी अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","अऊर डुक्कर, जो चिरयो मतलब फटी खुरी को होवय त हय पर कवरी नहीं करय, येकोलायी ऊ भी तुम्हरो लायी अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","इन को मांस म सी कुछ मत खावो, अऊर इन्को लोथ ख छूवो भी मत; यो त तुम्हरो लायी अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“फिर जितनो जलजन्तु हय उन म सी तुम इन ख खाय सकय हय, मतलब समुन्दर यां नदियों को जलजन्तुवों म सी जितनो को पंखा अऊर खिपला होवय हय उन्ख खाय सकय हय।” ");
INSERT INTO lbm_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","अऊर जलचरी प्रानियों म सी जितनो जीवधारी बिना पंखा अऊर खिपला वालो जीव-जन्तु समुन्दर यां नदियों म रह्य हय हि सब तुम्हरो लायी अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","हि तुम्हरो लायी घृणित ठहरे; तुम उन्को मांस म सी कुछ मत खावो, अऊर उन की लोथों ख अशुद्ध जानो। ");
INSERT INTO lbm_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","पानी म जो कोयी जन्तु को पंखा अऊर खिपला नहीं होवय ऊ तुम्हरो लायी अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","फिर पक्षियों म सी इन ख अशुद्ध जानो, हि अशुद्ध होन को वजह नहीं खानो चाहिये, गरूड़, दाढ़ी वालो गिधाड़, कारो चमगादड़, ");
INSERT INTO lbm_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","लाल घार, अऊर कारी गिधाड़, ");
INSERT INTO lbm_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","अऊर अलग अलग तरह को कौवा, ");
INSERT INTO lbm_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","शुतुरमुर्ग, रात शिकरा, पानकोबंड़ी, अऊर अलग अलग तरह को शिकारी पक्षी, ");
INSERT INTO lbm_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","पिंजल्ला, बगला, बड़ो घुबड़, ");
INSERT INTO lbm_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","राजहंस, पानकोंबड़ी, गिधाड़, ");
INSERT INTO lbm_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, सब तरह को बगला, टिटिहरी अऊर चमगादड़। ");
INSERT INTO lbm_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“जितनो पंखा वालो कीड़ा चार पाय को बल चलय हय हि सब तुम्हरो लायी अशुद्ध हय।” ");
INSERT INTO lbm_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","पर रेंगन वालो अऊर पंखा वालो कीड़ा जो चार पाय को बल चलय हय, अऊर जिन्को पाय को ऊपर एक मुड़ी हुयी टांग होवय हय, जेको बल पर हि जमीन पर कूदय हय, उन्ख तुम खाय सकय हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","तुम इन म सी खाय सकय हय सब तरह की टिड्डियां, भौरा, झींगुर अऊर सब तरह को टिड्डे। ");
INSERT INTO lbm_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","पर अऊर सब रेंगन वालो पंखा वालो कीड़ा जो चार पाय वालो होवय हय हि तुम्हरो लायी अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","इन्को वजह तुम अशुद्ध ठहरो; जो कोयी सी इन की लोथ छुय जाये ऊ शाम तक अशुद्ध ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","अऊर जो कोयी इन्की लोथ म सी कुछ भी उठायेंन ऊ अपनो कपड़ा धोयेंन अऊर शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","फिर जितनो पशु चिरयो खुरी को होवय त हय पर पूरो तरह सी दोय हिस्सा म नहाय अऊर कवरी भी नहीं करय, हि तुम्हरो लायी अशुद्ध हंय; जो कोयी इन ख छुय लेयेंन ऊ अशुद्ध होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","अऊर चार पाय को बल चलन वालो पशु म सी जितनो पंजा को बल चलय हय हि सब तुम्हरो लायी अशुद्ध हय; जो कोयी उन्की लोथ छुय लेयेंन ऊ शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","अऊर जो कोयी उन्की लोथ उठायेंन ऊ अपनो कपड़ा धोये अऊर शाम तक अशुद्ध रहे; कहालीकि हि तुम्हरो लायी अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","जो धरती पर रेंगय हय उन म सी हि रेंगन वालो जन्तुवों तुम्हरो लायी अशुद्ध हय, मतलब मुंगुश, मुसा, अऊर अलग अलग तरह की बड़ी इजगुर, ");
INSERT INTO lbm_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","अऊर इजगुर, मगर, सांपसिरोली, घोरपड़ अऊर डोकेला। ");
INSERT INTO lbm_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","सब रेंगन वालो जन्तुवों म सीच तुम्हरो लायी अशुद्ध हय; जो कोयी इन्की लोथ ख छुयेंन त ऊ शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","अऊर इन म सी कोयी की लोथ जो कोयी चिज पर गिर जाये ऊ भी अशुद्ध ठहरे, चाहे ऊ लकड़ी को बर्तन होना, चाहे कपड़ा, चाहे खाल, चाहे बोरा, यां कोयी काम को कैसो भी बर्तन कहाली नहीं होना; ऊ पानी म डाल्यो जाये, अऊर शाम तक अशुद्ध रहेंन, येको बाद यो चिज शुद्ध मानी जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","यदि कोयी माटी को बर्तन म जन्तुवों को लोथ म सी कुछ गिर जाये, त ऊ बर्तन म जो कुछ भी होना ऊ अशुद्ध मान्यो जायेंन, तुम ऊ बर्तन ख तोड़ देवो। ");
INSERT INTO lbm_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","यदि यो बर्तन को पानी कोयी भी खान की चिज पर गिर जाये, ऊ अशुद्ध होय जायेंन अऊर यदि असो बर्तन म पिवन लायी कुछ होना त ऊ भी अशुद्ध होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","अऊर यदि इन की लोथ म सी कुछ हिस्सा भट्टी यां चुलो पर गिर जाये त ऊ भी अशुद्ध होयेंन, अऊर ओख तोड़ दियो जाये; कहालीकि ऊ अशुद्ध हय, ऊ तुम्हरो लायी भी अशुद्ध होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","पर सोता यां तलाव जेको म पानी जमा होवय हय ऊ त शुद्धच रहे; पर जो कोयी इन की लोथ ख छुयेंन ऊ अशुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","अऊर यदि इन की लोथ को कुछ हिस्सा बोयो जान वालो बीज पर गिर जाये, त ऊ बीज शुद्ध मान्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","पर यदि बीज पर पानी डाल्यो गयो होना अऊर ऊ लोथ म सी कुछ हिस्सा ओको पर गिर जाये, त ऊ तुम्हरो लायी अशुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“फिर जिन पशुवों ख खान की आज्ञा तुम ख दी गयी हय यदि उन म सी कोयी पशु मर जाये, त जो कोयी उन्की लोथ ख छुयेंन ऊ शाम तक अशुद्ध रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","अऊर ओकी लोथ म सी जो कोयी कुछ खाये ऊ अपनो कपड़ा धोये अऊर शाम तक अशुद्ध रहे; अऊर जो कोयी ओकी लोथ ख उठाये ऊ भी अपनो कपड़ा धोये अऊर शाम तक अशुद्ध रहे। ");
INSERT INTO lbm_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","सब तरह को धरती पर रेंगन वालो जीव-जन्तु अशुद्ध हय; हि खायो नहीं जाये। ");
INSERT INTO lbm_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","धरती पर सब रेंगन वालो जन्तुवों म सी जितनो पेट यां चार पाय को बल चलय हय, यां बहुत जादा पाय वालो होवय हय, उन्ख तुम मत खावो; कहालीकि हि अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","तुम अपनो आप ख रेंगन वालो जन्तुवों को द्वारा घृणित मत बनावो; अऊर नहीं उन्को द्वारा अपनो आप ख अशुद्ध कर क् अपवित्र होय जावो। ");
INSERT INTO lbm_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","कहालीकि मय तुम्हरो परमेश्वर यहोवा आय; येकोलायी अपनो आप ख शुद्ध कर क् पवित्र बन्यो रहो, कहालीकि मय पवित्र हय। येकोलायी तुम कोयी तरह को रेंगन वालो जन्तुवों को द्वारा जो धरती पर चलय हय अपनो आप ख अशुद्ध मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","“कहालीकि मय ऊ परमेश्वर आय जो तुम्ख मिस्र देश सी येकोलायी निकाल लायो हय कि तुम्हरो परमेश्वर ठहरू; येकोलायी तुम पवित्र बनो, कहालीकि मय पवित्र हय।” ");
INSERT INTO lbm_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","पशुवों, पक्षियों, अऊर हर एक जनावरों, जो पानी म अऊर जमीन पर रेंगय हय उन्को लायी याच व्यवस्था हय, ");
INSERT INTO lbm_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","जेकोसी शुद्ध अऊर अशुद्ध अऊर खान की यां नहीं खान की चिजों म भेद करयो जाय सके। ");
INSERT INTO lbm_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","इस्राएलियों सी कहो: जो बाई गर्भवती होय क बच्चा ख जनम देवय हय त वा सात दिन तक अशुद्ध रहेंन; जसी वा मासिक धर्म को समय अशुद्ध रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","अऊर आठवों दिन बच्चा को खतना करयो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","फिर वा बाई अपनो शुद्ध करन वालो रक्तस्राव म तैतीस दिन रहे; अऊर जब तक ओको शुद्ध होय जान को दिन पूरो नहीं होय जाये तब तक वा नहीं त कोयी पवित्र चिज ख छुयेंन, अऊर नहीं पवित्र जागा म जाय। ");
INSERT INTO lbm_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","यदि वा टुरी ख जनम देवय हय, त वा चौदा दिन तक अशुद्ध रहेंन, जसी वा मासिक धर्म म रह्य हय, वा अपनो शुद्धिकरन को रक्तस्राव म छैसठ दिन तक रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","जब ओको शुद्ध होय जान को दिन पूरो होय जाये, तब ओख टुरा होय यां टुरी होय, वा होमबलि को लायी एक साल को मेंढा को बच्चा, अऊर पापबलि को लायी कबूत्तर को एक बच्चा यां पण्डुक मिलाप वालो तम्बू को फाटक पर याजक को जवर लाये। ");
INSERT INTO lbm_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","तब याजक ओख परमेश्वर को सामने भेंट चढ़ाय क ओको लायी पश्चाताप करे; अऊर वा अपनो रक्तस्राव सी शुद्ध होय जायेंन। जो बाई ख टुरा यां टुरी पैदा होय ओको लायी याच व्यवस्था हय। ");
INSERT INTO lbm_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“अऊर यदि ओको जवर मेंढा यां शेरी देन लायी धन नहीं होना, त दोय पण्डुक यां कबूत्तर को दोय बच्चा, एक होमबलि को लायी अऊर दूसरो पापबलि को लायी दे; अऊर याजक ओको लायी पश्चाताप करेंन, तब वा शुद्ध ठहरेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","फिर परमेश्वर न मूसा अऊर हारून सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","जब कोयी आदमी को शरीर को चमड़ी म सूजन यां चट्ठा यां चमक दार दाग होना, अऊर येकोसी ओको चमड़ी म कोढ़ को लक्षन दिखायी दे, त ओख हारून याजक को जवर यां ओको टुरा जो याजक हय उन म सी कोयी को जवर ले जाय। ");
INSERT INTO lbm_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","जब याजक ओको चमड़ी को चट्ठा ख देखे, अऊर यदि ऊ दाग को जागा को बाल सफेद होय गयो होना अऊर दाग चमड़ी सी गहरो दिखायी दे, त ऊ जान ले कि कोढ़ को रोग हय; अऊर याजक ऊ आदमी ख देख क ओख अशुद्ध ठहराये। ");
INSERT INTO lbm_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","पर यदि ऊ दाग चमड़ी म सफेद त होना, पर चमड़ी सी गहरो नहीं दिखायी दे, अऊर वहां को बाल सफेद नहीं भयो होना, त याजक ओख सात दिन तक अलग कर क् रखे; ");
INSERT INTO lbm_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","अऊर सातवों दिन तक याजक ओख देखे, अऊर यदि ऊ रोग वसो को वसो हय, अऊर ओको चमड़ी म नहीं फैल्यो हय, त याजक ओख अऊर भी सात दिन तक अलग कर क् रखे; ");
INSERT INTO lbm_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","अऊर सातवों दिन याजक ओख फिर सी देखे, की रोग की चमक कम हय अऊर रोग चमड़ी पर नहीं फैल रह्यो हय, त याजक ओख शुद्ध ठहराये; यो केवल चट्ठा आय अऊर अपनो कपड़ा धोय क शुद्ध होय जाय। ");
INSERT INTO lbm_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","पर यदि याजक की वा जांच करन को बाद जेको म ऊ शुद्ध ठहरायो गयो होतो, ऊ दाग ओकी चमड़ी पर बहुत फैल जाये, त ओख फिर सी याजक ख दिखायो जाय; ");
INSERT INTO lbm_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","अऊर यदि याजक ख दिखायी दे कि दाग चमड़ी म फैल गयो हय, त ऊ ओख अशुद्ध ठहराये; कहालीकि ऊ कोढ़च आय। ");
INSERT INTO lbm_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","यदि कोढ़ को रोग को जसो कोयी आदमी म हय, त ओख याजक को जवर लायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","अऊर याजक ओख जांचे, अऊर ओकी चमड़ी पर सफेद रंग की सूजन हय, अऊर ओको वजह बाल भी सफेद भय गयो हय, अऊर ऊ सूजन म बिना चमड़ी को मांस हय, ");
INSERT INTO lbm_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","त याजक जानेंन कि ओको चमड़ी म पुरानो कोढ़ हय, येकोलायी ऊ ओख अशुद्ध ठहराये; अऊर ओख अलग नहीं रखेंन, कहालीकि ऊ अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","अऊर यदि कोढ़ चमड़ी म बहुत जादा फूट क, जहां तक याजक देखे रोगी को मुंड सी पाय तक पूरो शरीर म फैल्यो होना, ");
INSERT INTO lbm_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","त याजक फिर सी जांचे, अऊर यदि कोढ़ ओको पूरो शरीर म फैल गयो हय, त याजक ओख शुद्ध ठहराये; अऊर ओको पूरो शरीर सफेद भय गयो हय त ऊ शुद्धच ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","पर ओको म बिना चमड़ी को मांस दिखायी दे, तब ऊ अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","अऊर याजक बिना चमड़ी को मांस देख क ओख अशुद्ध ठहराये; कहालीकि वसो बिना चमड़ी को मांस अशुद्धच होवय हय; अऊर ऊ कोढ़ को रोग आय। ");
INSERT INTO lbm_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","पर यदि ऊ बिना चमड़ी को मांस फिर सी सफेद होय जाये, त ऊ आदमी याजक को जवर जाये, ");
INSERT INTO lbm_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","अऊर याजक ओख जांचे, अऊर यदि ऊ दाग फिर सी सफेद भय गयो हय, त याजक रोगी ख शुद्ध ठहराये; ऊ शुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","फिर यदि कोयी की चमड़ी म फोड़ा हय जो अच्छो भय गयो हय, ");
INSERT INTO lbm_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","अऊर फोड़ा को जागा म सफेद सूजन यां लाल जसो सफेद दाग होना, त ऊ याजक ख दिखाये; ");
INSERT INTO lbm_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","अऊर याजक ऊ फोड़ा ख जांचे, यदि ओख लगे कि चमड़ी म फैल रह्यो हय अऊर ओको बाल भी सफेद भय गयो हय, तब याजक ऊ आदमी ख अशुद्ध ठहराये; यो कोढ़ को रोग आय जेकी सुरूवात फोड़ा सी भयी हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","पर यदि याजक ओख जांचे कि ओको म सफेद बाल नहाय, अऊर चमड़ी म नहीं फैल रह्यो हय, अऊर ओकी चमक कम भय गयी हय, त याजक ऊ आदमी ख सात दिन तक अलग रखे। ");
INSERT INTO lbm_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","अऊर यदि ऊ रोग ऊ समय तक चमड़ी म सचमुच फैल जाये, त याजक ऊ आदमी ख अशुद्ध ठहराये; कहालीकि ऊ कोढ़ को रोग आय। ");
INSERT INTO lbm_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","पर यदि ऊ दाग नहीं फैलय अऊर अपनो जागा परच रह्य, त ऊ फोड़ा को दाग आय; तब याजक ऊ आदमी ख शुद्ध ठहराये। ");
INSERT INTO lbm_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","फिर यदि कोयी की चमड़ी म जरयो हुयो घाव होना, अऊर ऊ जरयो हुयो घाव म बिना चमड़ी को लाल जसो दाग सफेद यां सफेदच होय जाये, ");
INSERT INTO lbm_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","त याजक ओख जांचे, अऊर ऊ दाग म को बाल सफेद भय गयो होना अऊर ऊ चमड़ी सी गहरो दिखायी दे, त ऊ कोढ़ आय; जो ऊ जरयो हुयो घाव को दाग म सी फूट निकल्यो हय; त याजक ऊ आदमी ख अशुद्ध ठहराये; कहालीकि ओको म कोढ़ को रोग आय। ");
INSERT INTO lbm_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","पर यदि याजक ओकी जांच करे कि दाग म सफेद बाल नहाय अऊर चमड़ी सी गहरो नहाय, अऊर ओकी चमक कम भय गयी हय, त ऊ ओख सात दिन तक अलग रखे, ");
INSERT INTO lbm_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","अऊर याजक सातवों दिन ओख जांचे, अऊर यदि ऊ चमड़ी म फैल गयो हय, त याजक ऊ आदमी ख अशुद्ध ठहराये; कहालीकि ओख कोढ़ को रोग हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","पर यदि ऊ दाग चमड़ी म नहीं फैल्यो हय अऊर अपनो जागा पर जसो को वसोच बन्यो हय, त ऊ जरन को वजह सूजयो हुयो हय, याजक ऊ आदमी ख शुद्ध ठहराये; कहालीकि ऊ दाग जरन को वजह हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“फिर यदि कोयी आदमी यां बाई को मुंड पर, यां आदमी को दाढ़ी म दाग होना, ");
INSERT INTO lbm_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","त याजक ऊ रोग की जांच करे, अऊर यदि ऊ चमड़ी को अन्दर गहरो दिखायी दे, अऊर ओको म भूरो भूरो पतलो बाल होना, त याजक ऊ आदमी ख अशुद्ध ठहराये; यो मुंड यां दाढ़ी को कोढ़ यां खुजली आय।” ");
INSERT INTO lbm_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","अऊर यदि याजक चर्मरोग को रोग ख जांचय कर क् देखय हय अऊर ओको म कारो बाल भी नहाय, त याजक चर्मरोग को रोगी ख सात दिन तक अलग रखे, ");
INSERT INTO lbm_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","अऊर याजक सातवों दिन रोग की जांच करे, यदि चर्मरोग फैल्यो नहीं होना, अऊर ओको म भूरो भूरो बाल नहीं होना, अऊर चर्मरोग चमड़ी को अन्दर गहरी नहीं दिखायी देवय हय, ");
INSERT INTO lbm_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","त ऊ आदमी दाढ़ी बनायेंन; पर ऊ चर्मरोग की जागा ख छोड़ देयेंन; अऊर याजक चर्मरोग वालो रोगी ख सात दिन तक अलग रखे। ");
INSERT INTO lbm_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","याजक सातवों दिन चर्मरोग की जांच करे, यदि चर्मरोग चमड़ी पर फैली नहाय अऊर वा चमड़ी को अन्दर गहरी दिखायी नहीं देवय हय, त याजक ऊ आदमी ख शुद्ध ठहराये; अऊर ऊ अपनो कपड़ा धोय क शुद्ध ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","पर यदि ओको शुद्ध होन को बाद भी चर्मरोग चमड़ी म कुछ फैलय हय, ");
INSERT INTO lbm_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","त याजक ओख जांचे अऊर यदि वा चर्मरोग चमड़ी म फैल गयी हय, त याजक भूरो बाल ख नहीं ढूंढे; कहालीकि ऊ आदमी अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","पर यदि ओकी नजर म चर्मरोग जसो को वसोच हय, अऊर ऊ जागा पर कारो बाल उग्यो हय, त चर्मरोग अच्छी भय गयी हय, अऊर ऊ आदमी शुद्ध हय; याजक ओख शुद्धच ठहराये। ");
INSERT INTO lbm_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","फिर यदि कोयी आदमी यां बाई को चमड़ी म चमकदार सफेद दाग होना, ");
INSERT INTO lbm_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","त याजक जांचे, यदि चमड़ी म हि दाग थोड़ो सफेद होना, त ऊ समझे कि यो दागच आय; त ऊ आदमी शुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“फिर जेको मुंड को बाल झड़ गयो होना, त समझनो कि ऊ टक्कल हय पर शुद्ध हय।” ");
INSERT INTO lbm_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","अऊर यदि कोयी आदमी को मुंड को सामने को अऊर कनपटी को बाल झड़ गयो हय, त ओको मस्तक टक्कल हय पर ऊ शुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","पर यदि टक्कल मुंड पर यां मस्तक पर लाल जसो सफेद दाग होना, त समझनो कि ऊ ओको टक्कल मुंड यां मस्तक पर निकल्यो हुयो कोढ़ आय। ");
INSERT INTO lbm_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","येकोलायी याजक ओख जांचे, यदि ओको टक्कल मुंड यां टक्कल मस्तक पर चमड़ी को कोढ़ को समान लाल जसो सफेद हय,जसो चमड़ी को कोढ़ म होवय हय, ");
INSERT INTO lbm_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","त ऊ आदमी कोढ़ को रोगी हय अऊर अशुद्ध हय; अऊर याजक ओख निश्चितच अशुद्ध ठहराये; कहालीकि ऊ रोग ओको मुंड पर भयो हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","कोढ़ जसो रोग को रोगी फट्यो कपड़ा पहिने अऊर ओको मुंड को बाल बिखरयो रहे, अऊर खल्लो को ओंठ ख झाक क पुकारे, “अशुद्ध, अशुद्ध!” ");
INSERT INTO lbm_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जितनो दिन तक ओको म रोग रहेंन उतनो दिन तक ऊ अशुद्ध रहेंन; अऊर ऊ अशुद्धच हय येकोलायी ऊ अकेलो रहे, ओकी रहन की जागा छावनी को बाहेरच रहे। ");
INSERT INTO lbm_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","फिर जो कपड़ा म कोढ़ को रोग जसो दाग होना, चाहे ऊ कपड़ा ऊन को हो यां सन को हो, ");
INSERT INTO lbm_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","अऊर सन को सियो हुयो यां ऊन को बुन्यो हुयो कपड़ा को कोयी तुकड़ा पर यां चमड़ा यां चमड़ा सी बनी कोयी भी चिज म हो, ");
INSERT INTO lbm_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","यदि दाग सियो हुयो कपड़ा म, यां उन को बुन्यो हुयो कपड़ा, यां चमड़ा म यां चमड़ा को तुकड़ा म बनी कोयी चिज म हरी यां लाल दिखायी दे, त समझनो की ऊ कोढ़ को रोग आय अऊर ओख याजक ख दिखायो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","अऊर याजक दाग की जांच करे, अऊर दाग वाली चिज ख सात दिन अलग रखे। ");
INSERT INTO lbm_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","त ओख सातवों दिन दाग की फिर सी जांच करे, यदि कपड़ा म, यां कपड़ा को बुन्यो हुयो हिस्सा म, यां चमड़ा कि बनी कोयी चिज म दाग फैल गयो हय, चाहे ऊ चमड़ा कोयी भी काम म आवत होना, ऊ हानी कर क् कोढ़ को लक्षन आय, ऊ अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ऊ कपड़ा को बन्यो हुयो हिस्सा म रोग होना, चाहे ऊ ऊन को यां सन को, यां चमड़ा की चिज होना, ओख जलाय देयेंन, ऊ रोग हानी कर क् कोढ़ आय; ऊ चिज ख आगी म जलाय दियो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","यदि याजक जांच कर क् देखे कि रोग कपड़ा को बन्यो हुयो हिस्सा म, यां चमड़ा की कोयी चिज म नहीं फैल्यो हय, ");
INSERT INTO lbm_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","अऊर याजक वा दाग वालो चिज ख धोवन की आज्ञा दे, अऊर भी ओख सात दिन लायी अलग रखे। ");
INSERT INTO lbm_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","अऊर धोवन को बाद याजक ऊ चिज की जांच करे, यदि दाग को रंग बदल्यो नहाय, अऊर दाग फैल्यो नहाय, त समझनो की वा चिज अशुद्ध हय; तुम ओख आगी म जलावो, चाहे दाग आगु को भाग म हो यां पीछु को भाग म। ");
INSERT INTO lbm_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","पर यदि याजक जांच कर क् देखे कि धोवन को बाद दाग की चमक कम भय गयी हय, त याजक ऊ कपड़ा यां चमड़ा म सी फाड़ क निकाले; ");
INSERT INTO lbm_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","अऊर यदि दाग कपड़ा म, यां कपड़ा को बन्यो हुयो हिस्सा म, यां चमड़ा की कोयी भी चिज म दिखायी देवय हय, त ऊ फिर सी फैल रह्यो हय; त तुम वा चिज ख आगी म जलाय देवो। ");
INSERT INTO lbm_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","यदि ऊ उन को कपड़ा म होना, या चमड़ा की जो चिज होना ओको सी जब धोयी जायेंन अऊर दाग निकलती रहेंन, त वा दूसरी बार धोय क शुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","त ऊन यां सन को कपड़ा म यां चमड़ा की बनी कोयी चिज म कोढ़ जसो दाग हय त ओख शुद्ध यां अशुद्ध ठहरान की याच व्यवस्था आय। ");
INSERT INTO lbm_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","कोढ़ को रोगी ख शुद्ध ठहरान को नियम यो आय। कि ओख याजक को जवर लायो जाय; ");
INSERT INTO lbm_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","अऊर याजक छावनी को बाहेर जाये, अऊर याजक ऊ कोढ़ी ख जांचे, अऊर यदि ओको कोढ़ को रोग ठीक भय गयो होना, ");
INSERT INTO lbm_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","त याजक आज्ञा दे कि शुद्ध ठहरायो जान वालो लायी दोय जीन्दो शुद्ध पक्षी, देवदार की लकड़ी, जूफा को पौधा अऊर लाल रंग की दोरी लायो जाये; ");
INSERT INTO lbm_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","अऊर याजक आज्ञा दे कि बहतो हुयो पानी को ऊपर माटी को बर्तन म एक पक्षी ख बलि करयो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","तब ऊ दूसरो जीन्दो पक्षी ख देवदार की लकड़ी अऊर लाल रंग की दोरी अऊर जूफा को पौधा इन सब ख ले क एक संग ऊ पक्षी को खून म जो बहतो हुयो पानी को ऊपर बलि करयो गयो होतो डुबाय दे; ");
INSERT INTO lbm_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","अऊर कोढ़ सी शुद्ध होन वालो आदमी को ऊपर सात बार छिड़क क ओख शुद्ध ठहराये, तब ऊ जीन्दो पक्षी ख खुलो मैदान म छोड़ दे। ");
INSERT INTO lbm_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","अऊर शुद्ध होन वालो अपनो कपड़ा ख धोये, अऊर अपनो सब बाल मुंडवाय क पानी सी नहाय क शुद्ध होय जाय, अऊर ओको बाद छावनी म आय सकेंन, पर सात दिन तक अपनो तम्बू सी बाहेरच रहे। ");
INSERT INTO lbm_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","अऊर सातवों दिन ऊ अपनो मुंड को बाल, दाढ़ी, भौंहों अऊर अपनो पूरो शरीर को बाल मुंडवाय ले; अऊर अपनो कपड़ा धोय ले, अऊर पानी सी नहाये, तब ऊ शुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“आठवों दिन ऊ दोय निर्दोष मेंढा को बच्चा, अऊर एक निर्दोष मेंढी, अऊर अन्नबलि लायी तेल मिल्यो हुयो पाच किलो मैदा अऊर अरधो लिटर तेल लाये।” ");
INSERT INTO lbm_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","शुद्ध करन वालो याजक इन चिजों को संग शुद्ध होन वालो आदमी ख परमेश्वर को सामने मिलाप वालो तम्बू को द्वार पर खड़ो करे। ");
INSERT INTO lbm_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","तब याजक एक मेंढा अऊर अरधो लिटर तेल अऊर दोषबलि ख ले क हिलावन की भेंट को रूप म परमेश्वर को जवर लाये। ");
INSERT INTO lbm_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","अऊर ऊ मेंढा को बच्चा ख उच जागा म जहां ऊ पापबलि अऊर होमबलि पशुवों को बलिदान करयो जावय हय, उच पवित्र जागा म बलिदान करे; कहालीकि जसो पापबलि याजक को निजी हिस्सा हय वसोच दोषबलि भी ओकोच निजी हिस्सा ठहरेंन; ऊ परमपवित्र हय। ");
INSERT INTO lbm_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","तब याजक दोषबलि को खून म सी कुछ अंश ले क शुद्ध होन वालो को दायो कान को टोक पर, अऊर ओको दायो हाथ अऊर दायो पाय को अंगूठा पर लगाये। ");
INSERT INTO lbm_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","तब याजक जैतून को अरधो लिटर तेल म सी कुछ ले क अपनो बायो हाथ कि हतेली पर डाले, ");
INSERT INTO lbm_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","अऊर अपनो बायो हाथ को हतेली को तेल म दायो हाथ को बोट डुबाय क परमेश्वर को सामने सात बार छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","अऊर जो ओकी हतेली पर तेल बच जाये याजक ओख शुद्ध होन वालो को दायो कान को टोक पर अऊर दायो हाथ अऊर दायो पाय को अंगूठा पर दोषबलि को लग्यो हुयो खून को ऊपर लगाये; ");
INSERT INTO lbm_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","अऊर याजक अपनी हतेली पर को तेल ऊ शुद्ध होन वालो को मुंड पर डाले। अऊर याजक ओको लायी परमेश्वर को सामने प्रायश्चित करे। ");
INSERT INTO lbm_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","याजक पापबलि ख भी चढ़ाय क ओको लायी जो अपनी अशुद्धता सी शुद्ध होन वालो होना प्रायश्चित करे; अऊर ओको बाद होमबलि पशु को बलिदान चढ़ाये : ");
INSERT INTO lbm_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","अन्नबलि समेत वेदी पर भेंट चढ़ाये : अऊर याजक ओको लायी प्रायश्चित करे, तब ऊ शुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“पर यदि ऊ आदमी गरीब होना अऊर भेंट देन लायी ओको जवर धन नहाय, त अपनो प्रायश्चित लायी हिलावन की भेंट को रूप म दोषबलि लायी एक मेंढा को बच्चा, अऊर अन्नबलि लायी जैतून को तेल सी सन्यो हुयो लगभग पाच किलो मैदा, अऊर लगभग अरधो लिटर जैतून को तेल आये; ");
INSERT INTO lbm_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","अऊर दोय पंडुक, यां कबूत्तर को दोय बच्चा लाये, जो ऊ लाय सकय हय लाये; एक पापबलि लायी अऊर दूसरो होमबलि लायी होय। ");
INSERT INTO lbm_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","अऊर आठवों दिन ऊ आदमी शुद्ध होन लायी उन सब ख मिलाप वालो तम्बू को फाटक पर, परमेश्वर को आगु, याजक को जवर लाये; ");
INSERT INTO lbm_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","तब याजक लगभग अरधो लिटर जैतून को तेल अऊर दोषबलि को मेंढा को बच्चा ख ले क हिलावन की भेंट लायी परमेश्वर को सामने लाये। ");
INSERT INTO lbm_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","फिर दोषबलि मेंढा को बच्चा ख बलिदान करे; अऊर याजक ओको खून म सी कुछ ले क शुद्ध होन वालो आदमी को दायो कान को टोक पर, अऊर ओको दायो हाथ अऊर दायो पाय को अंगूठा पर लगाये। ");
INSERT INTO lbm_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","अऊर याजक ऊ तेल म सी कुछ अपनो बायो हाथ की हतेली पर डाले, ");
INSERT INTO lbm_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","अऊर दायो हाथ को बोट सी बायो हाथ को हतेली पर को तेल परमेश्वर को सामने सात बार छिड़के; ");
INSERT INTO lbm_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","फिर याजक अपनो दायो हाथ पर को कुछ तेल शुद्ध होन वालो को दायो कान टोक पर, अऊर ओको दायो हाथ अऊर दायो पाय को अंगूठा पर, जहां दोषबलि को खून लगायो गयो होतो वहां लगाये। ");
INSERT INTO lbm_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","याजक अपनी हतेली पर को बच्यो हुयो तेल ख शुद्ध होन वालो आदमी को मुंड पर लगाय दे अऊर याजक ऊ आदमी लायी परमेश्वर को सामने प्रायश्चित करे। ");
INSERT INTO lbm_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","तब ऊ पण्डुकों यां कबूत्तरी को बच्चां म सी जो ऊ लाय सक्यो होना एक ख चढ़ाये, ");
INSERT INTO lbm_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ऊ पक्षी म सी एक पापबलि लायी अऊर दूसरो अन्नबलि समेत होमबलि लायी चढ़ाये; यो तरह याजक शुद्ध होन वालो लायी परमेश्वर को सामने प्रायश्चित करे। ");
INSERT INTO lbm_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","जेख कोढ़ को रोग भयो होना, अऊर ओको जवर इतनो धन नहीं होना कि ऊ अपनो शुद्धिकरन लायी ऊ जरूरतों को सामान नहीं लाय सकय, त ओको लायी याच व्यवस्था आय।” ");
INSERT INTO lbm_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","फिर परमेश्वर न मूसा अऊर हारून सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जब तुम लोग कनान देश म पहुंचो, जेक मय तुम्हरो अधिकार म दे रह्यो हय, ऊ समय यदि मय कोढ़ को रोगी ख तुम्हरो अधिकार को कोयी घर म दिखाऊं, ");
INSERT INTO lbm_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","त ऊ घर को मालिक आय क याजक ख बताये, मोख असो दिखायी दे रह्यो हय कि मोरो घर म कोयी रोग हय। ");
INSERT INTO lbm_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","तब याजक आज्ञा देयेंन कि जो घर म जांच करन ख मोरो जान सी पहिले ऊ घर ख खाली करो, कहीं असो नहीं होय कि जो कुछ ऊ घर म हय हि सब अशुद्ध ठहरे; अऊर तब ओको बाद याजक घर कि जांच करन अन्दर जाय। ");
INSERT INTO lbm_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","तब याजक ऊ रोग की जांच करे; अऊर यदि ऊ रोग घर की दीवालों पर हरी हरी यां लाल लाल खोदी हुयी लकीरों को रूप म हय, अऊर हि लकीरें दीवाल म गहरी दिखय हय, ");
INSERT INTO lbm_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","त याजक घर सी बाहेर फाटक पर जाय क ऊ घर ख सात दिन तक बन्द कर क् रखेंन। ");
INSERT INTO lbm_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","अऊर सातवों दिन याजक फिर सी आय क देखेंन; अऊर यदि ऊ रोग घर की दीवालों पर फैल गयो हय, ");
INSERT INTO lbm_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","त याजक आज्ञा दे की जिन गोटावों ख रोग हय उन्ख निकाल क नगर सी बाहेर अशुद्ध जागा म फेक दे; ");
INSERT INTO lbm_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","अऊर ऊ घर को अन्दर चारयी तरफ खुरचवायेंन, अऊर ऊ खुरची हुयी माटी ख नगर सी बाहेर अशुद्ध जागा म डाल दे; ");
INSERT INTO lbm_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","अऊर उन निकाल्यो गयो गोटावों को जागा म दूसरो गोटा लाय क लगाये, अऊर ऊ ताजो गारा सी जुड़ायी करे। ");
INSERT INTO lbm_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“यदि गोटावों ख निकलवानो, घर ख खुरचनो अऊर जुड़ायी अऊर लीपायी करन को बाद ऊ रोग फिर सी घर म फूट क निकलय हय, ");
INSERT INTO lbm_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","त याजक आय क जांच करे; अऊर यदि ऊ रोग घर म फैल गयो हय, त ऊ जान ले कि घर म हानी कर क् कोढ़ आय; त ऊ घर अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","येकोलायी ऊ घर ख गिराय क गोटा, लकड़ी अऊर गारा समेत सब चिजों ख उठवाय क नगर सी बाहेर अशुद्ध जागा म फिंकवाय दे। ");
INSERT INTO lbm_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","अगर येको अलावा यदि कोयी ऊ समय म ऊ घर म जाये, जो बन्द होतो, त ऊ आदमी शाम तक अशुद्ध रहेंन; ");
INSERT INTO lbm_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","अऊर जो कोयी ऊ घर म सोयेंन ऊ अपनो कपड़ा धोयेंन; अऊर जो कोयी ऊ घर म जेवन करेंन ऊ भी अपनो कपड़ा ख धोयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“पर यदि याजक आय क देखे, कि घर कि लीपायी को बाद रोग घर म नहीं फैल्यो हय, त ऊ घर ख शुद्ध ठहराये; कहालीकि ऊ रोग दूर भय गयो हय। ");
INSERT INTO lbm_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","तब याजक ऊ घर ख शुद्ध करन लायी दोय पक्षी, देवदार की लकड़ी, लाल रंग को कपड़ा अऊर जूफा लाये, ");
INSERT INTO lbm_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","तब एक पक्षी बहतो हुयो पानी को ऊपर माटी को बर्तन म बलिदान करे, ");
INSERT INTO lbm_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","फिर ऊ जीन्दो पक्षी को संग देवदार की लकड़ी, जूफा अऊर लाल रंग को कपड़ा ऊ बलिदान करयो हुयो पक्षी को खून, अऊर बहतो हुयो पानी म डुबाय क ऊ घर पर सात बार छिड़के। ");
INSERT INTO lbm_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","यो तरह ऊ पक्षी को खून, बहतो हुयो पानी, जीन्दो पक्षी, देवदार की लकड़ी, जूफा अऊर लाल रंग को कपड़ा को संग ऊ घर ख शुद्ध करे। ");
INSERT INTO lbm_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","तब ऊ जीन्दो पक्षी ख नगर सी बाहेर खुलो मैदान म छोड़ दे; योच रीति सी ऊ घर लायी प्रायश्चित करे, तब ऊ शुद्ध ठहरेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","कोयी भी तरह को कोढ़ को रोग, अऊर दाग, ");
INSERT INTO lbm_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","अऊर कपड़ा, अऊर घर को कोढ़, ");
INSERT INTO lbm_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","सूजन, फोड़ा अऊर दाग को बारे म, ");
INSERT INTO lbm_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","शुद्ध अऊर अशुद्ध ठहरान की शिक्षा देन की व्यवस्था याच आय। अऊर सब तरह को कोढ़ की याच व्यवस्था आय। ");
INSERT INTO lbm_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","फिर परमेश्वर न मूसा अऊर हारून सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएली लोगों सी कहो, कि जो कोयी आदमी को शरीर सी धात बहय हय, त ओको धात अशुद्ध हय। ");
INSERT INTO lbm_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ऊ धात चाहे बहतो रहे, यां बहनो बन्द भी होय जाये, तब भी ओकी अशुद्धता बनी रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","धात बहन वालो आदमी जो बिस्तर पर आराम करय हय ऊ बिस्तर अशुद्ध होय जावय हय, अऊर हर एक चिज जेको पर ऊ बैठय हय ऊ भी अशुद्ध होय जावय हय। ");
INSERT INTO lbm_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","अऊर जो कोयी ओको बिस्तर ख छुवय ऊ भी अपनो कपड़ा ख धोय क पानी सी नहाय ले, अऊर ऊ शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","अऊर जो चिज पर ऊ धात बहन वालो आदमी बैठय हय, ऊ चिज पर दूसरो कोयी आदमी बैठय हय त ऊ भी अपनो कपड़ा धोय क पानी सी नहाये, अऊर शाम तक अशुद्ध रहे। ");
INSERT INTO lbm_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","अऊर धात बहन वालो आदमी को शरीर ख कोयी छुय ले त ऊ भी अपनो कपड़ा धोय क पानी सी नहाय क अऊर शाम तक अशुद्ध रहे। ");
INSERT INTO lbm_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","यदि धात बहन वालो आदमी कोयी शुद्ध आदमी पर थूक देवय हय, त ऊ अपनो कपड़ा धोय क पानी सी नहाय क शाम तक अशुद्ध रहे। ");
INSERT INTO lbm_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","अऊर जो वाहन पर ऊ बैठय हय त ऊ चिज अशुद्ध ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","यदि कोयी आदमी उन चिजों म सी कोयी ख भी छुय लेवय हय, जो धात बहन वालो आदमी को खल्लो की हय त ऊ शाम तक अशुद्ध रहेंन। अऊर जो कोयी आदमी ऊ चिज ख उठावय हय त ऊ अपनो कपड़ा ख धोय क पानी सी नहाय ले, अऊर शाम तक अशुद्ध रहे। ");
INSERT INTO lbm_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","यदि धात बहन वालो आदमी बिना हाथ धोयो कोयी ख छुय लेवय त ऊ अपनो कपड़ा धोय क पानी सी नहाय क शाम तक अशुद्ध रहे। ");
INSERT INTO lbm_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","अऊर धात बहन वालो आदमी कोयी माटी को बर्तन ख छुय लेवय हय त ओख तोड़ दियो जाये, अऊर यदि लकड़ी को बर्तन हय त उन सब बर्तन ख पानी सी धोयो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“जब धात बहन वालो आदमी अपनो धात सी शुद्ध होय जाये, तब ऊ अपनो शुद्ध होन लायी सात दिन गिन ले, अऊर ऊ दिन बीतन पर अपनो कपड़ा ख धोय क बहतो हुयो पानी सी नहाय ले; तब ऊ शुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","अऊर आठवों दिन ऊ दोय पंडुक यां कबूत्तरी को दोय बच्चा लाय क मिलाप वालो तम्बू को फाटक पर परमेश्वर को सामने याजक ख दे। ");
INSERT INTO lbm_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","तब याजक उन म सी एक पापबलि लायी, अऊर दूसरो होमबलि लायी भेंट चढ़ाये; अऊर याजक ओको लायी धात को वजह परमेश्वर को सामने प्रायश्चित करे। ");
INSERT INTO lbm_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“फिर यदि कोयी आदमी को वीर्यपात होय जावय हय, त ऊ अपनो पूरो शरीर ख पानी सी धोये, अऊर ऊ शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","अऊर जो कोयी कपड़ा पर यां चमड़ा पर ऊ वीर्य गिरय हय त ओख पानी सी धोयो जाये, अऊर शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","यदि कोयी आदमी कोयी बाई सी सहवास करय अऊर यो प्रक्रिया म ओको वीर्यपात भयो होना, त हि दोयी पानी सी नहाये, अऊर शाम तक अशुद्ध रहे। ");
INSERT INTO lbm_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“फिर जब कोयी बाई मासिक धर्म म रहे, त वा सात दिन तक अशुद्ध ठहरी रहे, अऊर जो कोयी ओख छुयेंन ऊ शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","अऊर वा अपनो मासिक धर्म म जो चिज पर वा सोवय हय यां बैठय हय, त ऊ सब चिज अशुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","अऊर जो कोयी ओको बिस्तर ख छुयेंन ऊ अपनो कपड़ा धोय क पानी सी नहाये, अऊर शाम तक अशुद्ध रहे। ");
INSERT INTO lbm_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","अऊर जो कोयी ऊ चिज ख छुय लेवय हय जेको पर वा बैठय हय त ऊ अपनो कपड़ा धोय क पानी सी नहाये, अऊर शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","चाहे यो ओको बिस्तर यां कोयी भी चिज होना जेको पर वा बैठय हय, यदि कोयी ओख छुय लेवय हय, त ऊ शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","यदि कोयी आदमी ओको संग हकिकत म सहवास कर लेवय हय अऊर वा बाई की मासिक धर्म अशुद्धता ओको पर आय जावय हय, त ऊ सात दिन तक अशुद्ध रहेंन, अऊर हर एक बिस्तर पर ऊ सोवय हय अशुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“यदि कोयी बाई ख खून बहनो ओको मासिक धर्म अशुद्धता को समय मच नहीं बल्की ओको अलावा भी जादा दिनों तक खून बहतो रहे, त वा मासिक धर्म अशुद्धता को जसी अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","जो जो बिस्तर पर वा अपनो खून बहन को दिनों म सोवय हय, त वा मासिक धर्म को जसी अशुद्ध ठहरेंन; अऊर जो बिस्तर पर वा बैठेंन, हि भी ओको मासिक धर्म रहन को दिनों को जसो अशुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","अऊर जो कोयी उन चिजों ख छुयेंन ऊ अशुद्ध ठहरेंन, येकोलायी ऊ अपनो कपड़ा धोय क पानी सी नहाये, अऊर शाम तक अशुद्ध रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","पर जब वा बाई अपनो मासिक धर्म सी शुद्ध होय जाये, तब सी वा सात दिन गिन ले, उन दिनों को बितन को बाद वा शुद्ध ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","फिर वा आठवों दिन दोय पंडुक यां कबूत्तर को दोय बच्चा लाय क मिलाप वालो तम्बू को फाटक पर याजक को जवर लाये। ");
INSERT INTO lbm_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","तब याजक एक ख पापबलि अऊर दूसरों ख होमबलि लायी चढ़ाये; अऊर याजक ओको मासिक धर्म अशुद्धता को लायी परमेश्वर को सामने प्रायश्चित करे। ");
INSERT INTO lbm_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“यो तरह तुम इस्राएली समाज ख उन्की अशुद्धता सी अलग रखो, कहीं असो नहीं होय कि हि मोरो तम्बू ख जो उन्को बीच म हय, अशुद्ध करे अऊर अपनी अशुद्धता को वजह मर जाय।” ");
INSERT INTO lbm_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","जेको धात बह रह्यो हय अऊर जो आदमी को वीर्यपात होन को वजह ऊ अशुद्ध होय जावय हय, ");
INSERT INTO lbm_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","अऊर जो बाई मासिक धर्म अशुद्धता को वजह अस्वस्थ होना; पर चाहे आदमी होना यां बाई होना, जो कोयी ख धात रोग होना, अऊर जो आदमी अशुद्ध बाई सी सहवास करय हय, त इन सब लायी याच व्यवस्था आय। ");
INSERT INTO lbm_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","जब हारून को दोय टुरा परमेश्वर को सामने जान को वजह मर गयो, ओको बाद परमेश्वर न मूसा सी बाते करी। ");
INSERT INTO lbm_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","अऊर परमेश्वर न मूसा सी कह्यो, “अपनो भाऊ हारून सी कहो कि ऊ परदा को अन्दर परमपवित्र जागा म वाचा को सन्दूक को ऊपर को प्रायश्चित वालो ढक्कन को सामने, बीचवालो परदा को अन्दर, पवित्र जागा म हर समय सिरे, नहीं त मर जायेंन; कहालीकि मय प्रायश्चित वालो ढक्कन को ऊपर बादर म दिखायी देऊं।” ");
INSERT INTO lbm_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","जब हारून पवित्र जागा म सिरे तब यो रीति सी सिरे, ऊ पापबलि लायी एक गोरा अऊर होमबलि लायी एक मेंढा ले क आये। ");
INSERT INTO lbm_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","तब हारून सन को पवित्र कपड़ा पहिने, अऊर अपनो शरीर पर सन की जांघिया पहिने, अऊर सन को पट्टा बान्धे, अऊर सन को फेटा बान्धे, यो पवित्र कपड़ा आय, ऊ पानी सी नहान को बादच पहिने। ");
INSERT INTO lbm_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","फिर ऊ इस्राएलियों की मण्डली को जवर सी पापबलि लायी दोय बकरा अऊर होमबलि लायी एक मेंढा लाये। ");
INSERT INTO lbm_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","अऊर हारून ऊ पापबलि को गोरा ख चढ़ाय क अपनो अऊर अपनो परिवार लायी प्रायश्चित करे। ");
INSERT INTO lbm_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","येको बाद ऊ दोयी बकरा ख ले क मिलाप वालो तम्बू को फाटक पर परमेश्वर को सामने खड़ो करे; ");
INSERT INTO lbm_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","अऊर हारून दोयी बकरा पर चिट्ठियां डाले, एक चिट्ठी परमेश्वर लायी अऊर दूसरी अजाजेल लायी होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","अऊर जो बकरा पर परमेश्वर को नाम की चिट्ठी निकलेंन ओख हारून पापबलि लायी चढ़ाये; ");
INSERT INTO lbm_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","पर जो बकरा पर अजाजेल लायी चिट्ठी निकलेंन ओख परमेश्वर को सामने जीन्दो खड़ो करयो जाये कि ओको पर प्रायश्चित करयो जाये, अऊर ओख अजाजेल लायी जंगल म छोड़ दियो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“हारून ऊ पापबलि को गोरा ख जो ओको लायी हय लाये, अऊर ओख बलिदान कर क् अपनो अऊर अपनो परिवार को पाप ख झाके।” ");
INSERT INTO lbm_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ऊ परमेश्वर को सामने वेदी पर जलतो हुयो कोयला सी भरयो हुयो धूपदान अऊर अपनी दोय मुट्ठी भर बारीक कूटी हुयी सुगन्धित धूप बीच वालो परदा को अन्दर लाये। ");
INSERT INTO lbm_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ऊ धूप ख परमेश्वर को आगु आगी म डाले, जेकोसी धूप को धुवा वाचा को सन्दूक पर गवाह चिट्ठी को ऊपर को प्रायश्चित को ढक्कन को ऊपर छाय जायेंन, नहीं त ऊ मर जायेंन; ");
INSERT INTO lbm_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","तब ऊ बछड़ा खून म सी कुछ ले क पूर्व दिशा को तरफ प्रायश्चित को ढक्कन को ऊपर अपनो बोट सी छिड़क दे, अऊर फिर ऊ खून म सी कुछ बोट को द्वारा ऊ ढक्कन को सामने भी सात बार छिड़क दे। ");
INSERT INTO lbm_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","फिर हारून ऊ पापबलि को बकरा ख जो साधारन लोगों लायी होयेंन बलिदान कर क् अऊर ओको खून ख बीच वालो परदा को अन्दर ले आये, अऊर जो तरह गोरा को खून सी ओन करयो होतो ठीक वसोच ऊ बकरा खून सी भी करे, मतलब ओख प्रायश्चित को ढक्कन को ऊपर अऊर ओको सामने छिड़क दे। ");
INSERT INTO lbm_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","फिर ऊ पवित्र जागा लायी इस्राएली लोगों की अशुद्धता यां उन्को सब पापों को सम्बन्ध म करयो गयो अपराध को लायी प्रायश्चित पूरो करे अऊर यो तरह ऊ मिलाप वालो तम्बू को लायी भी करे, जो उन्की अशुद्धतावों को बीच उन्को संग रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","जब हारून प्रायश्चित करन लायी पवित्र जागा म जाये, तब सी अपनो लायी अऊर घराना लायी अऊर इस्राएल की पूरी मण्डली लायी प्रायश्चित कर क् बाहेर निकलय तब तक कोयी भी मिलाप वालो तम्बू म नहीं रहे। ");
INSERT INTO lbm_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","फिर ऊ निकल क ऊ वेदी को जवर जो परमेश्वर को सामने हय जाये अऊर ओको लायी प्रायश्चित करे, मतलब बछड़ा को अऊर बकरा को कुछ खून दोयी म सी कुछ ले क वा वेदी को चारयी कोना को सींगो पर लगाये। ");
INSERT INTO lbm_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","अऊर ऊ खून म सी कुछ अपनो बोट सी सात बार ओको पर छिड़के। अऊर इस्राएली लोगों की अशुद्धता सी पवित्र करे। ");
INSERT INTO lbm_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“जब हारून पवित्र जागा, मिलाप वालो तम्बू अऊर वेदी लायी पाप झाकन को बाद, एक जीन्दो बकरा ख लाये। ");
INSERT INTO lbm_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","अऊर हारून अपनो जीन्दो बकरा को मुंड पर अपनो दोयी हाथ रख क इस्राएली लोगों को पूरो बुरो कामों, अऊर उन्को सब अपराधों, मतलब ओको पूरो पापों ख स्वीकार करे, अऊर उन्ख बकरा को मुंड पर रख क ओख कोयी आदमी को हाथ जो यो काम लायी तैयार रहे निर्जन जमीन म भेज क छोड़ दे। ");
INSERT INTO lbm_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","यो बकरा इन्को सब बुरो कामों को बोझ अपनो ऊपर उठाय क निर्जन जमीन म लिजायेंन; येकोलायी ऊ आदमी ऊ बकरा ख जंगल म छोड़ दे। ");
INSERT INTO lbm_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“तब हारून मिलाप वालो तम्बू म आयेंन, अऊर जो सन को कपड़ा ख पहिन्यो हुयो ओन पवित्र जागा म सिरतो समय पहिन्यो होतो ओख उतार क वहांच पर रख दे। ");
INSERT INTO lbm_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","फिर ऊ कोयी पवित्र जागा म पानी सी नहाय क अपनो कपड़ा पहिन ले, अऊर बाहेर आय क अपनी अऊर अपनो लोगों की होमबलि ख चढ़ाय क अपनो लायी अऊर लोगों को पापों ख झाकेंन। ");
INSERT INTO lbm_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","फिर ऊ पापबलि की चरबी ख वेदी पर आगी म जलाये। ");
INSERT INTO lbm_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","अऊर जो आदमी अजाजेल लायी बकरा ख छोड़ क आयेंन, अऊर ऊ अपनो कपड़ा धोयेंन, अऊर पानी सी नहायेंन तब ऊ छावनी म सिरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","अऊर पापबलि को गोरा अऊर बकरा भी जिन्को खून पवित्र जागा म पाप ख झाकन लायी लायो गयो होतो, उन्ख छावनी को बाहेर लायो जायेंन अऊर वहां उन्की खाल, मांस अऊर गोबर आगी म जलाय दियो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","अऊर जो उन्ख जलायेंन ऊ अपनो कपड़ा धोये, अऊर पानी सी नहान को बाद ऊ छावनी म सिर सकेंन। ");
INSERT INTO lbm_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“तुम लोगों लायी या विधि हमेशा लायी होयेंन कि सातवों महिना को दसवों दिन तुम अपनो अपनो जीव ख दु:ख देवो, अऊर ऊ दिन कोयी, चाहे ऊ तुम्हरो निजी देश को होना यां विदेश को होना तुम्हरो बीच म रह्य हय, कोयी भी तरह को काम काज नहीं करेंन; ");
INSERT INTO lbm_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","कहालीकि योच ऊ दिन आय जो दिन तुम्ख शुद्ध करन लायी पापों ख झाक्यो जायेंन; अऊर तुम परमेश्वर को सामने अपनो पूरो पापों सी शुद्ध ठहरो। ");
INSERT INTO lbm_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","यो तुम्हरो लायी परम आराम को दिन ठहरे, अऊर तुम ऊ दिन उपवास करो अऊर कोयी तरह को काम-काज मत करो; याच हमेशा की विधि आय। ");
INSERT INTO lbm_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","अऊर अपनो बाप की जागा पर याजक पद लायी जेको अभिषेक करयो जाये, ऊ याजक सन को पवित्र कपड़ा पहिन क पाप ख झाके, ");
INSERT INTO lbm_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","उच याजक पवित्र जागा, मिलाप वालो तम्बू अऊर वेदी लायी प्रायश्चित करे; अऊर सब याजकों अऊर मण्डली को सब लोगों लायी भी प्रायश्चित करे। ");
INSERT INTO lbm_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","अऊर तुम्हरो लायी हमेशा की या विधि होयेंन कि इस्राएली लोगों लायी ओको सब पापों को वजह हर साल एक बार प्रायश्चित करयो जाय।” मूसा न ठीक वसोच करयो, जसो परमेश्वर न आज्ञा दी होती हारून न करयो। ");
INSERT INTO lbm_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून अऊर ओको टुरावों सी अऊर सब इस्राएलियों सी कहो कि परमेश्वर न या आज्ञा दी हय।” ");
INSERT INTO lbm_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","यदि इस्राएल को घराना म सी कोयी भी आदमी जो कोयी मेंढा को बच्चा यां शेरी को बच्चा की हत्या, छावनी म यां छावनी को बाहेर करे, ");
INSERT INTO lbm_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","अऊर ऊ येख मिलापवालो तम्बू को फाटक पर परमेश्वर को निवास को सामने भेंट चढ़ावन लायी नहीं ले जाय, त ऊ आदमी ख हत्या को दोष लगेन; अऊर ऊ आदमी न खून बहायो हय, त असो आदमी ख अपनो लोगों को बीच सी बाहेर निकाल्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","या विधि को यो उद्देश हय कि इस्राएली लोग अपनी बलियों को बलिदान हि खुलो मैदान म करय हय, हि बलियों ख मिलापवालो तम्बू को फाटक पर याजक को जवर लाये, अऊर परमेश्वर को लायी मेल-मिलाप बलि को रूप म भेंट चढ़ाये; ");
INSERT INTO lbm_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","अऊर याजक खून ख मिलापवालो तम्बू को द्वार पर परमेश्वर की वेदी को ऊपर छिड़के, अऊर चरबी ख ओको सुखदायक सुगन्ध लायी जलाये। ");
INSERT INTO lbm_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","हि जो बकरा देवता को पूजक होय क व्यभिचार करय हय, हि फिर अपनो बलिपशुवों ख उन्को लायी बलिदान नहीं करे। तुम्हरी पीढ़ियों को लायी या हमेशा की विधि होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“तय उन्कोसी यो कहजो कि इस्राएल को घरानो को लोगों म सी यां परदेशियों म सी कोयी आदमी जो उन्को बीच म रह्य हय, होमबलि यां मेल-मिलाप बलि चढ़ाये, ");
INSERT INTO lbm_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","अऊर ओख मिलापवालो तम्बू को द्वार पर परमेश्वर को लायी भेंट चढ़ावन लायी नहीं लाये; त ऊ आदमी ख अपनो लोगों म सी मार डाल्यो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“फिर इस्राएल को घराना म सी यां उन्को बीच म रहन वालो परदेशियों म सी कोयी आदमी कोयी तरह को खून खाये, मय ऊ खून खान वालो को विरुद्ध होय क ओख ओको लोगों को बीच म सी नाश कर डालूं।” ");
INSERT INTO lbm_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","कहालीकि शरीर को जीव खून म रह्य हय; अऊर ओख मय न तुम लोगों ख वेदी पर चढ़ावन लायी दियो हय कि तुम्हरो जीवों को लायी पापों ख झाक्यो जाये; कहालीकि खून म जीव होन को वजह ओको सी पश्चाताप होवय हय। ");
INSERT INTO lbm_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","येकोलायी मय इस्राएली लोगों सी कहू हय कि तुम म सी कोयी यां कोयी परदेशी जो तुम्हरो बीच म रह्य हय ऊ भी कभी खून नहीं खाये।, ");
INSERT INTO lbm_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“इस्राएलियों म सी यां उन्को बीच म रहन वालो परदेशियों म सी कोयी आदमी शिकार कर क् खान को लायक पशु यां पक्षी ख पकड़ेंन; त ऊ ओको खून ख जमीन म कुड़ाय क माटी सी झाक दे।” ");
INSERT INTO lbm_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","कहालीकि सब प्रानियों को शरीर को जीवन खून म रह्य हय जो ओको जीव को संग एक हय; येकोलायी मय इस्राएलियों सी कहू हय कि कोयी प्रानी को खून ख तुम मत खावो, कहालीकि सब प्रानियों को जीव ओको खूनच आय; जो कोयी ओख खायेंन ओख नाश करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","यदि कोयी आदमी, चाहे ऊ देशी यां परदेशी होना, हिंसक पशु द्वारा फाड़्यो गयो पशु यां स्वाभाविक मृत्यु सी मरयो हुयो पशु को मांस खायेंन त ऊ अपनो कपड़ा ख धोय क पानी सी नहाये, ऊ शाम तक अशुद्ध रहेंन; अऊर तब ऊ शुद्ध होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","“पर यदि ऊ कपड़ा ख नहीं धोवय अऊर पानी सी नहीं नहावय, त ओख अपनो पाप को बोझ खुद ख उठानो पड़ेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएली लोगों सी कहो कि मय तुम्हरो परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुम मिस्र देश को कामों को अनुसार व्यवहार मत करो, जहां तुम रहत होतो; अऊर नहीं कनान देश को कामों को, जहां मय तुम्ख लिजाय रह्यो हय; तुम उन्की विधियों को पालन भी मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तुम मोरो नियमों को पालन करो, अऊर मोरीच विधियों ख मानतो हुयो उन पर चलो। मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","येकोलायी तुम मोरो नियमों अऊर मोरी विधियों ख हमेशा मानो; जो आदमी या विधियों ख मानेंन ऊ इन्को वजह जीन्दो रहेंन। मय यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“तुम म सी कोयी अपनी कुटुम्ब की बाई को तन उघाड़न लायी ओको जवर मत जावो। मय यहोवा आय।” ");
INSERT INTO lbm_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","तय अपनी माय को तन उघाड़ क अपनो बाप को अपमान मत करो; वा तुम्हरी जनम देन वाली माय आय, येकोलायी तुम ओको तन मत उघाड़जो। ");
INSERT INTO lbm_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","तय अपनी सौतेली माय सी सहवास मत करजो; यो तुम्हरो बाप को अपमान होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","तुम अपनी बहिन चाहे सगी होना चाहे सौतेली होना, चाहे ओको जनम घर म भयो होना यां दूसरों जागा म, ओको तन मत उघाड़जो। ");
INSERT INTO lbm_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","अपनी नातिन, जो वा बेटा की बेटी होना यां बेटी की बेटी होना ओको तन मत उघाड़जो; कहालीकि ओको अपमान तुम्हरो अपमान हय। ");
INSERT INTO lbm_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","तुम्हरी सौतेली बहिन जो तुम्हरो बाप सी पैदा भयी हय, वा तुम्हरी बहिनच आय, ओको तन मत उघाड़जो। ");
INSERT INTO lbm_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","तुम अपनी फूफू को तन मत उघाड़जो; वा त तुम्हरो बाप को जवर की बहिन आय। ");
INSERT INTO lbm_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","तुम अपनी मावसी को तन मत उघाड़ो; कहालीकि वा तुम्हरी माय की जवर की बहिन आय। ");
INSERT INTO lbm_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","तय अपनो काका तन मत उघाड़जो, मतलब ओकी पत्नी को जवर मत जावो; वा त तुम्हरी काकी आय। ");
INSERT INTO lbm_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","तय अपनी बहू को तन मत उघाड़जो; वा त तुम्हरो टुरा की पत्नी आय, ओको तन मत उघाड़जो। ");
INSERT INTO lbm_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","तय अपनी भाभी को तन मत उघाड़जो; वा त तुम्हरो भाऊ कोच तन आय। ");
INSERT INTO lbm_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","तय कोयी बाई अऊर ओकी बेटी दोयी को तन मत उघाड़जो, अऊर नहीं ओकी बेटा की बेटी को अऊर नहीं ओकी बेटी की बेटी को तन मत उघाड़जो, हि त जवर की कुटुम्बिनी आय; असो करनो महापाप हय। ");
INSERT INTO lbm_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","तय अपनी पत्नी की बहिन ख अपनाय क सौतन मत बनायजो, अऊर ओकी बहिन को जीन्दी रहतो हुयो ओको तन मत उघाड़जो। ");
INSERT INTO lbm_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","जब कोयी बाई मासिक धर्म को वजह अशुद्ध हय, तब तक ओको जवर ओको तन उघाड़न मत जाजो। ");
INSERT INTO lbm_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","फिर अपनो पड़ोसी की पत्नी सी कुकर्म कर क् अपनो ख अशुद्ध मत करजो। ");
INSERT INTO lbm_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","तय अपनी कोयी भी सन्तान ख मोलेक देवता ख होमबलि कर क् मत चढ़ायजो, अऊर अपनो परमेश्वर को नाम ख अपवित्र मत करजो; मय यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","तय बाई को संग सहवास को रीति सी आदमी को संग सहवास मत करजो; ऊ त घिनौना काम आय। ");
INSERT INTO lbm_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","तुम कोयी पशु सी कुकर्म कर क् खुद ख अशुद्ध मत करो, अऊर नहीं कोयी बाई कुकर्म करन को उद्देश सी कोयी पशु को सामने जाये; यो त अनर्थ हय। ");
INSERT INTO lbm_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","यो तरह को काम म सी कोयी भी काम कर क् अशुद्ध मत होय जाजो, कहालीकि जिन राज्य को लोगों ख मय तुम्हरो सामने सी निकालन पर हय हि यो तरह को काम कर क् अशुद्ध भय गयो हय। ");
INSERT INTO lbm_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","अऊर ओको देश भी अशुद्ध भय गयो हय, यो वजह मय ओको पर ओको बुरो कामों की सजा देऊ हय, अऊर ऊ देश अपनो निवासियों ख निकाल देवय हय। ");
INSERT INTO lbm_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","यो वजह तुम लोग मोरी विधियों अऊर नियमों ख हमेशा मानो, अऊर चाहे देशी होना यां तुम्हरो बीच म रहन वालो परदेशी होना, तुम म सी कोयी भी असो घृणित काम नहीं करेंन। ");
INSERT INTO lbm_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","कहालीकि असो सब घृणित कामों ख ऊ देश को लोग जो तुम सी पहिले वहां रहत होतो हि करतो आयो हय, येकोसीच ऊ देश अशुद्ध भय गयो हय। ");
INSERT INTO lbm_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","अब असो नहीं होय कि जो रीति सी जो राज्य को लोग तुम सी पहिले ऊ देश म रहत होतो ओख ओन निकाल दियो, उच रीति सी जब तुम ओख अशुद्ध करो, त ऊ तुम्ख भी निकाल देयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","जितनो असो कोयी घृणित काम करेंन हि सब अपनो लोगों म सी नाश करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","या आज्ञा जो मय न तुम्ख मानन लायी दी हय ओख तुम मानो, अऊर जो घृणित रीतियां तुम सी पहिले मानी जात होती उन्म सी कोयी रीति पर नहीं चलनो, अऊर नहीं उन को वजह अशुद्ध होय जावो। मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","इस्राएलियों की पूरी मण्डली सी कहो कि तुम पवित्र बन्यो रहो; कहालीकि मय तुम्हरो परमेश्वर यहोवा पवित्र हय। ");
INSERT INTO lbm_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","तुम अपनी माय अऊर अपनो बाप को आदर करनो, अऊर मोरो आराम दिनों ख माननो : मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","तुम मूर्तियों को तरफ मत फिरो, अऊर धातु को देवतावों की मूर्तियां ढाल क मत बनावो; मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","जब तुम परमेश्वर लायी मेल-मिलाप बलि करो, तब असो बलिदान करो जेकोसी मय तुम सी खुश होय जाऊं। ");
INSERT INTO lbm_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","जो दिन ओको मांस बलिदान करो उच दिन यां ओको दूसरो दिन ओख खायो जाये, पर तीसरो दिन तक बच जाये ओख आगी म जलाय दियो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","यदि ओको म सी कुछ भी तीसरो दिन खायो जाये, त यो अशुद्ध ठहरेंन, अऊर स्वीकार नहीं करयो जायेंन, ");
INSERT INTO lbm_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","अऊर ओख खानवालो परमेश्वर को पवित्र चिज ख अपवित्र ठहरावय हय, येकोलायी ओख अपनो बुरो काम को बोझ खुद ख उठानो पड़ेंन; अऊर ऊ व्यक्ति अपनो लोगों म सी नाश करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","फिर जब तुम अपनी जमीन की फसल काटो तब अपनो खेत को कोना कोना तक मत काटो, अऊर काट्यो हुयो फसल की गिरी पड़ी लोम्बा ख मत चुनो। ");
INSERT INTO lbm_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","अऊर अपनी अंगूर की बाड़ी को पूरो अंगूर मत तोड़जो, अऊर अपनी अंगूर की बाड़ी को झड़्यो हुयो अंगूरों ख जमा मत करजो; उन्ख गरीब अऊर परदेशी लोगों लायी छोड़ देजो; मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“तुम चोरी नहीं करनो, अऊर नहीं एक दूसरो सी कपट करनो, अऊर नहीं झूठ बोलनो। ");
INSERT INTO lbm_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","तुम मोरो नाम की झूठी कसम खाय क अपनो परमेश्वर को नाम कलंकित मत करो; मय परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“एक दूसरो पर अन्धेर नहीं करनो, अऊर नहीं एक दूसरो ख लूटनो। मजूर की मजूरी तोरो जवर पूरी रात सबेरे तक नहीं रहनो चाहिये। ");
INSERT INTO lbm_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","बहिरा ख श्राप नहीं देनो, अऊर अन्धा को आगु ठेस की चिज नहीं रखनो; अऊर अपनो परमेश्वर की भय रखो; मय परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“न्याय करतो समय अन्याय नहीं करनो; अऊर नहीं गरीब को पक्ष लेनो अऊर नहीं बड़ो आदमी को मुंह देख क बिचार करनो; एक दूसरो को न्यायीपन सी न्याय करनो। ");
INSERT INTO lbm_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","तुम अपनो लोगों को बीच म निन्दा करतो नहीं फिरनो, अऊर एक दूसरो को खून बहावन की युक्ति नहीं बनावो; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“अपनो मन म एक दूसरो को खिलाफ घृणा नहीं रखो; अपनो पड़ोसी ख जरूर डाटनो, नहीं त ओको पाप को बोझ तोख उठानो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","बदला नहीं लेनो, अऊर अपनो लोगों सी दुस्मनी नहीं रखनो, पर एक दूसरो सी अपनो जसो प्रेम रखो; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“तुम मोरी विधियों ख हमेशा मानो। अपनो जनावरों ख दूसरो जाति को जनावरों सी गर्भधारन मत होन देवो; अपनो खेत म दोय तरह को बीज मत बोवो; अऊर दोय तरह सी बन्यो हुयो कपड़ा मत पहिनो। ");
INSERT INTO lbm_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“यदि कोयी आदमी असी बाई को संग जो दासी हय, जेकी मंगनी दूसरो आदमी सी भयी होना, अऊर जेक दाम दे क मुक्त नहीं करयो गयो होना; यदि ओको सी कोयी कुकर्म करे, त उन दोयी ख सजा त मिलेंन, पर हि दोयी मार डाल्यो नहीं जाये। ");
INSERT INTO lbm_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","पर ऊ आदमी मिलापवालो तम्बू को फाटक पर एक मेंढा दोषबलि लायी लाये। ");
INSERT INTO lbm_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","अऊर याजक ओको करयो हुयो पाप को वजह दोषबलि को मेंढा को द्वारा ओको लायी परमेश्वर को सामने प्रायश्चित करे; तब ओको करयो हुयो पाप माफ करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“फिर जब तुम कनान देश म पहुंच क कोयी तरह को खान लायी सब तरह को फर को झाड़ लगावो, त उन्को फर तुम्हरो लायी तीन साल तक खतनारहित रहेंन; येकोलायी उन म सी कुछ नहीं खायो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","अऊर चौथो साल म उन्को सब फर परमेश्वर की स्तुति भेंट को रूप म पवित्र ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तब पाचवों साल म तुम उन्को फर खाय सकय हय, येकोलायी कि हि तुम्ख बहुत फर दे सके; मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“तुम खून लग्यो हुयो कुछ मांस मत खावो। अऊर जादू-टोना मत करो, अऊर शुभ यां अशुभ मुहुर्तों ख मत मानो। ");
INSERT INTO lbm_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","तुम अपनो मुंड को बाल घेरा रख क मत काटो, अऊर नहीं अपनी दाढ़ी ख किनारा सी काटो। ");
INSERT INTO lbm_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","कोयी की मृत्यु को वजह अपनो शरीर पर चिरा मत लगावो, अऊर नहीं गुदना गुदवानो; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“अपनी टुरी ख वेश्या बनाय क अपवित्र नहीं करनो, असो नहीं होय कि देश वेश्यागमन को वजह दुष्टता सी भर जाये। ");
INSERT INTO lbm_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","मोरो आराम दिन ख मानो, अऊर मोरो पवित्र जागा को डर मानो; मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“सलाह देन वालो अऊर भूत-प्रेत साधन वालो को तरफ मत फिरो, असो की खोज कर क् उन्को वजह अशुद्ध मत होय जावो; मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“बुजूर्ग आदमी को सामने उठ क खड़ो होनो, अऊर बुजूर्ग आदमी को आदर करो, अऊर अपनो परमेश्वर सी हमेशा डरो; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“यदि कोयी परदेशी तुम्हरो देश म तुम्हरो संग रहेंन, त ओको संग बुरो व्यवहार मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","जो परदेशी तुम्हरो संग रह्य हय ऊ तुम्हरो लायी स्वदेशी को जसो हो, अऊर ओको सी अपनो जसो प्रेम रखो; कहालीकि तुम भी मिस्र देश म परदेशी होतो; मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“तुम न्याय म, अऊर पाप म, अऊर तौल म, अऊर नाप म अन्याय मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","अऊर सच्चो तराजू, न्याय को बट, सच्चो नाप, सच्चो लिटर तुम्हरो जवर ठीक ठीक रहे; मय तुम्हरो ऊ परमेश्वर यहोवा आय जो तुम ख मिस्र देश सी निकाल लायो हय। ");
INSERT INTO lbm_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","येकोलायी तुम मोरी सब विधियों अऊर सब नियमों ख मानतो हुयो हमेशा पालन करो; मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इस्राएलियों सी कहो कि इस्राएलियों म सी यां इस्राएलियों को बीच रहन वालो परदेशियों म सी, कोयी भी होना जो अपनी कोयी सन्तान मोलेक देवता ख बलिदान करेंन, ऊ जरूर मार डाल्यो जायेंन; अऊर ऊ देश को लोग ओको पर पथराव करेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मय भी ऊ आदमी को खिलाफ होय क ओख ओको लोगों म सी यो वजह नाश करूं कि ओन अपनी सन्तान मोलेक देवता ख दे क मोरो पवित्र जागा ख अशुद्ध करयो हय, अऊर मोरो पवित्र नाम ख अपवित्र ठहरायो हय। ");
INSERT INTO lbm_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","अऊर यदि कोयी अपनी सन्तान मोलेक देवता ख बलिदान करे, अऊर ऊ देश को लोग ओको बारे म अनदेखा करे अऊर ओख मार नहीं डालय, ");
INSERT INTO lbm_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","तब मय खुद ऊ आदमी अऊर ओको घराना को खिलाफ होय क ओख अऊर जितनो मोलेक देवता को पीछू होय क मोरो संग व्यभिचार करेंन उन सब ख भी उन्को लोगों को बीच म सी नाश करूं। ");
INSERT INTO lbm_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“फिर जो आदमी तंत्र-मंत्र यां भूत-प्रेत साधन वालो को तरफ फिर क, अऊर उन्को पीछू होय क व्यभिचारी बनेंन, त मय ऊ आदमी को खिलाफ होय क ओख ओको लोगों को बीच म सी नाश कर देऊं। ");
INSERT INTO lbm_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","येकोलायी तुम अपनो आप ख पवित्र करो; अऊर पवित्र बन्यो रहो; कहालीकि मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","अऊर तुम मोरी विधियों ख मानो, अऊर उन्को पालन भी करो; कहालीकि मय तुम्ख पवित्र करन वालो परमेश्वर यहोवा आय।” ");
INSERT INTO lbm_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","जो कोयी भी अपनो बाप यां माय ख श्राप देयेंन ओख जरूर मार डाल्यो जाये; ओन अपनो बाप यां माय ख श्राप दियो हय, ओको खून ओकोच मुंड पर पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","यदि आदमी परायी बाई को संग व्यभिचार करय हय, जेन कोयी दूसरो की पत्नी सी व्यभिचार करयो हय, त ऊ व्यभिचारी अऊर व्यभिचारिनी दोयी ख जरूर मार डाल्यो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","यदि कोयी अपनी सौतेली माय को संग सोवय हय, ऊ अपनो बाप कोच तन उघाड़न वालो ठहरेंन; येकोलायी हि दोयी ख जरूर मार डाल्यो जाये, उन दोयी को खून उन्कोच मुंड पर पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","यदि कोयी आदमी अपनी बहू को संग सोवय, त हि दोयी ख जरूर मार डाल्यो जाये; कहालीकि उन्न गलत काम करयो हय, उन दोयी को खून उन्कोच मुंड पर पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","यदि कोयी आदमी कोयी दूसरो आदमी को संग घिनौनो काम करय हय जसो कोयी बाई को संग, त उन्न घृणित काम करयो हय; यो वजह जरूर उन्ख मार डाल्यो जाये, उन्को खून उन्कोच मुंड पर पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","यदि कोयी आदमी अपनी पत्नी अऊर सासु दोयी को संग बिहाव करय हय, त यो महापाप हय; येकोलायी ऊ आदमी ख अऊर दोयी बाई ख आगी म जलाय दियो जायेंन, जेको सी तुम्हरो बीच म महापाप नहीं रहे। ");
INSERT INTO lbm_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","फिर यदि कोयी आदमी पशु सी शारिरीक सम्बन्ध बनावय, त आदमी अऊर पशु दोयी ख जरूर मार डाल्यो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","यदि कोयी बाई जनावर को जवर जाय क ओको संग शारिरीक सम्बन्ध बनायेंन, त तय वा बाई अऊर जनावर दोयी ख मार डालजो; हि जरूर मार डाल्यो जाये, उन्को खून उन्कोच मुंड पर पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“यदि कोयी आदमी अपनी बहिन चाहे सगी हो यां सौतेली, ओको संग बिहाव कर क् बिना कपड़ा की देखे, अऊर ओकी बहिन भी ओख बिना कपड़ा को देखे, त या लज्जा की बात आय, हि दोयी ख अपनो लोगों को बीच म सी नाश करयो जाये; कहालीकि जेन अपनी बहिन की लज्जा ख उघाड़्यो हय ओख अपनो पाप को बोझ खुद ख उठानो पड़ेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","फिर यदि कोयी आदमी कोयी मासिक धर्म बाई को संग सोय क ओकी लज्जा ख उघाड़य हय, त ऊ आदमी ओको मासिक धर्म को सोता ख उघाड़न वालो ठहरेंन, अऊर वा बाई अपनो मासिक धर्म को सोता ख उघाड़न वाली ठहरेंन; यो वजह हि दोयी ख अपनो लोगों को बीच म सी नाश करयो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","अपनी मावसी यां फूफू की लज्जा नहीं उघाड़नो, कहालीकि जो ओख उघाड़ेंन ऊ अपनी जवर की कुटुम्बिनी ख नंगो करय हय; येकोलायी हि दोयी ख अपनो पाप को बोझ खुद ख उठानो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","यदि कोयी आदमी अपनी काकी को संग सोयेंन, त ऊ अपनो काका की लज्जा उघाड़य हय; येकोलायी हि दोयी अपनो पाप को बोझ ख उठातो हुयो बिन सन्तान को मर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","यदि कोयी अपनी भाभी को संग बिहाव करय हय, त यो घिनौनो काम आय; अऊर ऊ अपनो भाऊ की लज्जा उघाड़न वालो ठहरेंन, यो वजह हि दोयी बिना सन्तान को रह्य जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“तुम मोरी सब विधियों अऊर सब नियमों को पालन करो; असो नहीं होय की ऊ देश जहां मय तुम्ख लिजाय रह्यो हय ऊ तुम्ख निकाल दे। ");
INSERT INTO lbm_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","अऊर जो राज्य को लोगों ख मय तुम्हरो आगु सी निकालू हय उन्की रीति-रिवाज पर मत चलो; कहालीकि उन लोगों न जो यो सब कुकर्म करयो हय यो वजह मोख उन सी घृना भय गयी हय। ");
INSERT INTO lbm_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","पर मय तुम लोगों सी कहू हय कि तुम उन्की जमीन को अधिकारी होय जावो, अऊर मय यो देश ख जेको म दूध अऊर शहेद की धारा बहय हय तुम्हरो अधिकार म कर देऊं; मय तुम्हरो परमेश्वर यहोवा आय जेन तुम ख दूसरों देश को लोगों सी अलग करयो हय। ");
INSERT INTO lbm_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","येकोलायी तुम शुद्ध अऊर अशुद्ध पशुवों म, शुद्ध अऊर अशुद्ध पक्षियों म भेद करो; मय न जो पशु, पक्षी यां जमीन पर रेंगन वालो जीवजन्तु ख तुम्हरो लायी अशुद्ध ठहरायो हय, ओको द्वारा अपनो आप ख अशुद्ध मत बनावो। ");
INSERT INTO lbm_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तुम मोरो लायी पवित्र बन्यो रहो; कहालीकि मय परमेश्वर खुद पवित्र हय, अऊर मय न तुम ख अऊर संसार को लोगों सी येकोलायी अलग करयो हय कि तुम हमेशा मोरोच बन्यो रहो। ");
INSERT INTO lbm_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“यदि कोयी आदमी यां बाई सलाह देन वालो यां भूत-प्रेत की साधना करेंन, त ऊ जरूर मार डाल्यो जाये; असो पर पथराव करयो जाये, उन्को खून उन्कोच मुंड पर पड़ेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","फिर परमेश्वर न मूसा सी कह्यो, “हारून को टुरा जो याजक हय उन्कोसी कहजो कि तुम्हरो लोगों म सी कोयी भी मरेंन, त ओको वजह तुम म सी कोयी अपनो ख अशुद्ध नहीं करे; ");
INSERT INTO lbm_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","अपनो जवर को कुटुम्बियों, मतलब माय, बाप, टुरा, टुरी, यां भाऊ को लायी, ");
INSERT INTO lbm_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","या अपनी कुंवारी बहिन जेको बिहाव नहीं भयो होना, जिन्को जवर को सम्बन्ध हय; जेको कोयी पति नहाय उन्को लायी अपनो ख अशुद्ध कर सकय हय। ");
INSERT INTO lbm_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","पर याजक होन को वजह अपनो लोगों म मुखिया हय, येकोलायी ऊ अपनो आप ख असो अशुद्ध नहीं करे कि अपवित्र होय जाय। ");
INSERT INTO lbm_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“याजक अपनो मुंड को बाल नहीं मुंडाये, अऊर नहीं अपनी दाढ़ी मुंडाये, अऊर नहीं अपनो शरीर पर चिरा लगवाये। ");
INSERT INTO lbm_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","हि अपनो परमेश्वर लायी पवित्र बन्यो रहे, अऊर अपनो परमेश्वर को नाम अपवित्र नहीं करे; कहालीकि हि प्रभु की भेंट ख जो उन्को परमेश्वर को भोजन आय, चढ़ायो करय हय; यो वजह हि पवित्र बन्यो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","हि वेश्या यां भ्रष्ट बाई सी बिहाव नहीं करे, अऊर नहीं छोड़ी हुयी बाई सी बिहाव करे; कहालीकि याजक अपनो परमेश्वर लायी पवित्र होवय हय। ");
INSERT INTO lbm_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","येकोलायी तय याजक ख पवित्र मानो, कहालीकि ऊ तुम्हरो परमेश्वर को भोजन चढ़ायो करय हय; येकोलायी ऊ तोरी नजर म पवित्र ठहरे; कहालीकि मय यहोवा, जो तुम्ख पवित्र करू हय, मय पवित्र हय। ");
INSERT INTO lbm_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","अऊर याजक की टुरी वेश्या बन क अपनो आप ख अपवित्र करेंन, त वा अपनो बाप ख अपवित्र ठहरावय हय; ओख आगी म जलायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“जो अपनो भाऊवों म महायाजक होना, जेको मुंड पर अभिषेक को तेल डाल्यो गयो होना, अऊर जेको पवित्र कपड़ा पहिनन लायी संस्कार करयो गयो होना ऊ अपनो मुंड को बाल बिखरन नहीं देयेंन, अऊर नहीं अपनो कपड़ा फाड़े; ");
INSERT INTO lbm_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","अऊर नहीं कोयी लाश को जवर जाय, अऊर नहीं अपनो बाप यां माय को वजह अपनो ख अशुद्ध करे; ");
INSERT INTO lbm_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","अऊर ऊ पवित्र जागा सी बाहेर नहीं जाये, अऊर नहीं अपनो परमेश्वर को पवित्र जागा ख अपवित्र ठहराये; कहालीकि ओको पर अपनो परमेश्वर को अभिषेक को तेल डाल्यो गयो हय; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","अऊर ऊ कुंवारी बाई सीच बिहाव करे। ");
INSERT INTO lbm_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","जो विधवा, यां छोड़ी हुयी, यां भ्रष्ट, यां वेश्या होना, असी बाई सी ऊ बिहाव नहीं करे, ऊ अपनोच लोगों को बीच म की कोयी कुंवारी टुरी सी बिहाव करे। ");
INSERT INTO lbm_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","अऊर ऊ अपनी सन्तान ख अपनो लोगों म अपवित्र नहीं करे; कहालीकि मय ओको पवित्र करन वालो परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारून सी यो कहजो तोरो वंश म पीढ़ी सी पीढ़ी तक यदि कोयी म कोयी शारीरिक दोष होना, त ऊ अपनो परमेश्वर को भोजन चढ़ावन लायी जवर नहीं आयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","कोयी आदमी जेको म शारीरिक दोष होना ऊ जवर नहीं आये, चाहे ऊ अन्धा होना, चाहे लंगड़ा, चाहे चपटी नाक वालो होना, चाहे ओख कुछ जादा अंग होना, ");
INSERT INTO lbm_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","यां ओको पाय, यां हाथ विकलांग होना, ");
INSERT INTO lbm_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","यां कुबड़ो, यां ठिंगनो होना, यां ऊ आदमी ख खुजली होना, यां ऊ नपुसक होना; ");
INSERT INTO lbm_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","हारून याजक को वंश म सी जेको म शारीरिक दोष हय ऊ प्रभु लायी होमबलि चढ़ावन लायी जवर नहीं आये; जो दोषयुक्त हय ऊ कभी भी अपनो परमेश्वर को भोजन चढ़ावन लायी जवर नहीं आये। ");
INSERT INTO lbm_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ऊ अपनो परमेश्वर को पवित्र अऊर परमपवित्र दोयी तरह को भोजन खाये, ");
INSERT INTO lbm_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","पर ओको दोष को वजह ऊ नहीं बीचवालो परदा को अन्दर आये अऊर नहीं वेदी को जवर, जेकोसी असो नहीं होय कि ऊ मोरो पवित्र जागा ख अपवित्र करे; कहालीकि मय उन्को पवित्र करन वालो परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","येकोलायी मूसा न हारून अऊर ओको टुरावों ख अऊर सब इस्राएलियों ख या बाते कहीं। ");
INSERT INTO lbm_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून अऊर ओको टुरावों ख कहो की इस्राएलियों की पवित्र करी हुयी चिजों सी जिन्ख हि मोरो लायी चढ़ावय हय अलग रहे, अऊर मोरो पवित्र नाम ख अपवित्र नहीं करे; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","अऊर उन्कोसी कहो की तुम्हरी पूरी पीढ़ी म तुम्हरो पूरो वंश म सी जो कोयी अपनी अशुद्ध दशा म उन पवित्र चिजों को जवर जाये, जिन्ख इस्राएली लोग मोख चढ़ावय हय, त ऊ व्यक्ति ख मोरो सामने सी नाश करयो जायेंन; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“हारून को वंश को कोयी आदमी जो कोढ़ को रोग सी तकलीफ म हय, यां धात सी तकलीफ हय, ऊ आदमी जब तक शुद्ध नहीं होय जाये तब तक पवित्र करी हुयी चिजों म सी कुछ नहीं खाये। जो लाश को वजह अशुद्ध भयो होना, यां जेको वीर्यपात भयो होना, असो आदमी ख जो कोयी छुयेंन, ");
INSERT INTO lbm_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","अऊर जो कोयी असो रेंगन वालो जीव-जन्तु ख छुयेंन जेकोसी लोग अशुद्ध होय सकय हय, यां कोयी असो आदमी ख छुयेंन जेको म कोयी तरह की अशुद्धता होना जो ओख भी लग सकय हय। ");
INSERT INTO lbm_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","त ऊ व्यक्ति जो इन म सी कोयी ख छुयेंन त शाम तक अशुद्ध रहेंन, अऊर जब तक पानी सी नहाय नहीं लेवय तब तक पवित्र चिजों म सी कुछ नहीं खाये। ");
INSERT INTO lbm_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","तब ऊ सूरज डुबन को बाद शुद्ध ठहरेंन; अऊर तब ऊ पवित्र चिजों म सी खाय सकेंन, कहालीकि ओको भोजन उच आय। ");
INSERT INTO lbm_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","जो जनावर अपनो सी मरयो होना यां कोयी हिंसक जनावर सी फाड़्यो गयो होना ओख खाय क ऊ अपनो आप ख अशुद्ध नहीं करे; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“येकोलायी याजक लोग मोरो नियमों को पालन करे, असो नहीं होय कि हि उन्ख अपवित्र कर क् पाप को बोझ खुद उठाये, अऊर मर भी जाये; मय उन्को पवित्र करन वालो परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“परायो कुल को व्यक्ति कोयी भी पवित्र चिज ख नहीं खानो चाहिये, चाहे ऊ याजक को परदेशी होना यां मजूर होना, तब भी ऊ कोयी पवित्र चिज ख नहीं खाये।” ");
INSERT INTO lbm_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","यदि याजक कोयी व्यक्ति ख रुपया दे क खरीद लेवय, त ऊ व्यक्ति ओको म सी खाय सकय हय; अऊर जेको जनम याजक को घर म भयो होना हि भी ओको भोजन म सी खाय सकय हय। ");
INSERT INTO lbm_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","यदि याजक की टुरी परायो कुल को कोयी आदमी सी बिहाव भयो होना, त वा भेंट करी हुयी पवित्र चिजों म सी नहीं खाये। ");
INSERT INTO lbm_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","यदि याजक की टुरी विधवा या छोड़चिट्ठी भयो होना, अऊर वा जवानी म बिना सन्तान की अपनो बाप को घर आय जाये, त वा अपनो बाप को घर को भोजन म सी खाय सकय हय; पर परायो कुल को कोयी भी ओको म सी नहीं खाये। ");
INSERT INTO lbm_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“अऊर यदि कोयी आदमी कोयी पवित्र चिज म सी भूल सी खाय जाये, त ऊ ओको पाचवों हिस्सा ओको म बढ़ाय क पवित्र चिज याजक ख दे। ");
INSERT INTO lbm_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","हि इस्राएलियों की पवित्र करी हुयी चिजों ख, जिन्ख हि परमेश्वर लायी चढ़ायो करय हय, उन्ख अपवित्र नहीं करे। ");
INSERT INTO lbm_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","हि इस्राएली लोगों की पवित्र चिजों म सी खिलाय क उन्कोसी अपराध को दोष नहीं उठवाये; मय उन्को पवित्र करन वालो परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","हारून अऊर ओको टुरावों सी अऊर इस्राएलियों सी यो कहो कि इस्राएल को घराना यां इस्राएलियों म रहन वालो परदेशियों म सी कोयी व्यक्ति मन्नत यां खुद की इच्छा सी बलि करन लायी परमेश्वर ख होमबलि चढ़ाये, ");
INSERT INTO lbm_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","त अपनो स्विकार करन लायक ठहरन लायी पालतु जनावर यां मेंढा यां शेरियों म सी पूर्ण स्वस्थ नर चढ़ायो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","जिन पशुवों म शारीरिक दोष होना ओख मत चढ़ावो; कहालीकि ऊ तुम्हरो लायी स्विकारयो नहीं जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","अऊर जो कोयी पालतु जनावर यां मेंढा यां शेरियों म सी खास चिज मन्नत करन लायी यां खुद की इच्छा सी परमेश्वर ख मेल-मिलाप बलि चढ़ाये, त स्विकार होन लायी जरूरी हय कि ऊ पूर्ण स्वस्थ होना, ओको म कोयी भी दोष नहीं होना। ");
INSERT INTO lbm_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","जो अन्धो यां टूट्यो अंग वालो यां लुलो होना, यां ओको म फोड़ा-फुन्सी यां खुजली होना, असो ख परमेश्वर को लायी मत चढ़ावो, उन्ख परमेश्वर को लायी वेदी पर हवन लायी मत चढ़ावो। ");
INSERT INTO lbm_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","जो कोयी पालतु जनावर यां मेंढा यां बकरा को कोयी अंग बड़ो या छोटो होना ओख खुद की इच्छा सी बलि लायी चढ़ाय सकय हय, पर मन्नत पूरी करन लायी ओख स्विकार नहीं करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","जो जनावर को अण्डकोष दब्यो, कुचल्यो, टूट्यो यां कट गयो होना ओख परमेश्वर ख बलि लायी मत चढ़ावो, अऊर अपनो देश म भी असो काम मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","विदेशी व्यक्ति सी ले क असो कोयी जनावर अपनो परमेश्वर को भोजन को रूप म मत चढ़ावो, ओको शरीर पर दोष हय, अऊर विकृत हय, येकोलायी हि तुम्हरो लायी स्विकारयो नहीं जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जब गोरा यां मेंढा या शेरी को बच्चा पैदा होयेंन, त ऊ सात दिन तक अपनी माय को संग रहेंन; फिर आठवों दिन को बाद ऊ परमेश्वर को भेंट लायी स्विकारन लायक ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","चाहे पालतु जनावर, चाहे मेंढी यां शेरी होना, ओख अऊर ओको बच्चा ख एकच दिन बलि मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","अऊर जब तुम परमेश्वर लायी धन्यवाद को मेल-मिलाप बलि चढ़ावो, त ओख योच रीति सी करो जेकोसी ऊ स्विकार लायक ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ऊ उच दिन खायो जाय, ओको म सी कुछ भी सबेरे तक नहीं रहनो चाहिये; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“येकोलायी तुम मोरी आज्ञावों ख मानो अऊर ओको पालन करो; मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","अऊर मोरो पवित्र नाम ख अपवित्र मत करो, कहालीकि मय इस्राएलियों को बीच म जरूरच पवित्र मान्यो जाऊं; मय तुम्हरो पवित्र करन वालो परमेश्वर आय, ");
INSERT INTO lbm_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","जो तुम्ख मिस्र देश सी निकाल लायो, जेकोसी तुम्हरो परमेश्वर बन्यो रहूं; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","इस्राएलियों सी कहो कि परमेश्वर को त्यौहार तुम पवित्र सभा ख एकजूट करन लायी ठहरायो समय पर प्रचार करनो पड़ेंन, हि मोरो त्यौहार यो आय। ");
INSERT INTO lbm_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","छय दिन काम-काज करयो जायेंन, पर सातवों दिन परमविश्राम को अऊर पवित्र सभा को दिन आय; ओको म कोयी तरह को काम-काज नहीं करयो जायेंन; ऊ तुम्हरो घरों म परमेश्वर को आराम दिन ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“फिर परमेश्वर को त्यौहार जेको म सी एक एक को ठहरायो हुयो समय म तुम्ख पवित्र सभा करन लायी प्रचार करनो पड़ेंन हि यो आय। ");
INSERT INTO lbm_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","पहिलो महिना को चौदावों दिन शाम को समय परमेश्वर को फसह को त्यौहार मनायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","अऊर उच महिना को पन्द्रावों दिन ख परमेश्वर को लायी अखमीरी रोटी को त्यौहार मनायो जाय; ओको म तुम सात दिन तक अखमीरी रोटी खायो करो। ");
INSERT INTO lbm_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ओको म पहिलो दिन तुम्हरी पवित्र सभा होयेंन; अऊर ऊ दिन मेहनत को कोयी काम मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","पर सात दिन तक तुम परमेश्वर ख अग्निबलि चढ़ायो करो; अऊर सातवों दिन पवित्र सभा होयेंन; ऊ दिन कोयी मेहनत को काम मत करो।” ");
INSERT INTO lbm_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएलियों सी कहो कि जब तुम ऊ देश म सिरो जेक परमेश्वर तुम्ख देवय हय अऊर ओको म की फसल काटो, तब अपनो अपनो पक्यो खेत की पहली फसल की एक पेंढी याजक को जवर लायो करो; ");
INSERT INTO lbm_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","अऊर याजक ऊ पेंढी ख परमेश्वर को सामने हिलायेंन, कि ऊ तुम्हरो लायी स्विकारयो जायेंन; ऊ ओख आराम दिन को दूसरों दिन हिलायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","अऊर जो दिन तुम पेंढी हिलावो उच दिन एक साल को निर्दोष मेंढी को बच्चा परमेश्वर लायी होमबलि चढ़ावो। ");
INSERT INTO lbm_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","अऊर ओको संग अनाज भेंट एपा को दसवों अंश जैतून को तेल सी सान्यो हुयो मैदा होय, सुखदायक सुगन्ध लायी परमेश्वर को हवन को रूप म चढ़ायो जाय; अऊर ओको संग पेयबलि लायी दोय लिटर अंगूरीरस भी चढ़ायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","जब तक तुम नयी फसल को चढ़ावा अपनो परमेश्वर को जवर नहीं लावो, तब तक नयी फसल की रोटी यां भूज्यो दाना यां कच्चो दाना मत खावो; यो तुम्हरी पीढ़ी सी पीढ़ी म तुम्हरो घराना म हमेशा की विधि ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“फिर ऊ आराम दिन को दूसरो दिन सी, मतलब जो दिन सी तुम हिलायी जान वाली भेंट की पेंढी ख लावो, ऊ दिन सी पूरो सात आराम दिन गिन लेवो; ");
INSERT INTO lbm_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातवों आराम दिन को दूसरो दिन को बाद सी पचास दिन गिनो, अऊर पचासवों दिन परमेश्वर लायी नयो अन्नबलि चढ़ावो। ");
INSERT INTO lbm_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तुम अपनो घरों सी हिलावन की भेंट बलि को रूप म चढ़ावन लायी दोय किलो मैदा की दोय रोटियां लावो; जो परमेश्वर ख पहली फसल को रूप म चढ़ावन लायी खमीर को संग पकायी जाय। ");
INSERT INTO lbm_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","अऊर वा रोटी को संग एक एक साल को सात पूर्ण स्वस्थ मेंढी को बच्चा, अऊर एक बछड़ा अऊर दोय मेढ़े चढ़ावो; हि अपनो अपनो अनाज भेंट अऊर पेयबलि समेत परमेश्वर लायी अग्निबलि को जसो चढ़ायो जाये, मतलब हि परमेश्वर लायी सुखदायक सुगन्ध देन वालो हवन ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","फिर पापबलि लायी एक बकरा, अऊर मेल-मिलाप बलि लायी एक एक साल को दोय मेंढी को बच्चा चढ़ावो। ");
INSERT INTO lbm_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","तब याजक उन्ख पहली फसल की रोटी समेत परमेश्वर को सामने हिलावन की भेंट लायी हिलाये, अऊर इन रोटियों को संग हि दोयी मेंढी को बच्चा भी हिलायो जाये; हि परमेश्वर लायी पवित्र, अऊर याजक को भाग ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","अऊर उच दिन यो प्रचार करो कि अज हमरी एक पवित्र सभा होयेंन; अऊर मेहनत को कोयी काम मत करो; यो तुम्हरो पूरो घराना म तुम्हरी पीढ़ी पीढ़ी म हमेशा की विधि ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“जब तुम अपनी जमीन की फसल काटो तब खेतों ख पूरो को पूरो मत काटो, अऊर नहीं फसल की कटायी को बाद गिरी हुयी लोम्बा जमा करो; ओख गरीब अऊर परदेशियों लायी छोड़ देवो; मय तुम्हरो परमेश्वर यहोवा आय।” ");
INSERT INTO lbm_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएलियों सी कहो कि सातवों महिना को पहिलो दिन ख तुम्हरो लायी खास आराम को होना; ओको म याद दिलावन लायी नरसिंगा फूक्यो जाय, अऊर एक पवित्र सभा जमा हो। ");
INSERT INTO lbm_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ऊ दिन तुम मेहनत को कोयी काम मत करो, अऊर परमेश्वर लायी एक अग्निबलि चढ़ावो।” ");
INSERT INTO lbm_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","उच सातवों महिना को दसवों दिन पश्चाताप को दिन मान्यो जाये; ऊ तुम्हरो पवित्र सभा को दिन होयेंन, अऊर ओको म तुम उपवास करो अऊर परमेश्वर लायी अग्निबलि चढ़ावो। ");
INSERT INTO lbm_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ऊ दिन तुम कोयी तरह को काम-काज मत करो; कहालीकि ऊ पश्चाताप को दिन चुन्यो गयो हय जेको म तुम्हरो परमेश्वर यहोवा को सामने तुम्हरो लायी पश्चाताप करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","येकोलायी जो आदमी ऊ दिन खुद दु:ख नहीं सहेंन ऊ अपनो लोगों म सी नाश करयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","अऊर जो आदमी ऊ दिन कोयी तरह को काम-काज करेंन ऊ आदमी ख मय ओको लोगों को बीच म सी नाश कर डालूं। ");
INSERT INTO lbm_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुम कोयी तरह को काम-काज मत करो; यो तुम्हरी पीढ़ी पीढ़ी म तुम्हरो घराना म हमेशा की विधि होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ऊ दिन तुम्हरो लायी परमविश्राम को होयेंन, ओको म तुम खुद दु:ख देवो; अऊर ऊ महिना को नववों दिन की शाम सी ले क दूसरो दिन की शाम तक अपनो खास आराम दिन मान्यो करो। ");
INSERT INTO lbm_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएलियों सी कहो कि उच सातवों महिना को पन्द्रावों दिन सी सात दिन तक परमेश्वर लायी खोपड़ियों को त्यौहार मनायो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहिलो दिन पवित्र सभा होयेंन; ओको म मेहनत को कोयी काम मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","“सातवों दिन परमेश्वर लायी अग्निबलि चढ़ायो करो, फिर आठवों दिन तुम्हरी पवित्र सभा होयेंन, अऊर परमेश्वर लायी हवन चढ़ावो; ऊ महासभा को दिन आय, अऊर ओको म मेहनत को कोयी काम मत करो। ");
INSERT INTO lbm_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","परमेश्वर को ठहरायो त्यौहार योच आय, इन म तुम परमेश्वर ख बलिदान चढ़ावो, मतलब अग्निबलि, अन्नबलि, मेल-मिलाप बलि अऊर अंगूरीरस, हर एक अपनो अपनो नियुक्त समय पर चढ़ायो जाय अऊर पवित्र सभा को प्रचार करो। ");
INSERT INTO lbm_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","इन सब सी जादा परमेश्वर को आराम दिनों ख मानो, अऊर अपनी भेंटों, अऊर मन्नतों, अऊर खुद की इच्छा सी बलियों ख परमेश्वर ख चढ़ायो करो। ");
INSERT INTO lbm_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“फिर सातवों महिना को पन्द्रावों दिन ख, जब तुम जमीन की फसल ख जमा कर लेवो, तब सात दिन तक परमेश्वर को त्यौहार मनावो; पहिलो अऊर आठवों दिन खास आराम को दिन होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","अऊर पहिलो दिन तुम अच्छो अच्छो झाड़ को फर, अऊर खजूर को डगालियां, अऊर घनो झाड़ो की डगालियां, अऊर नदी को किनार को मजनूं झाड़ की डगाली ले क अपनो परमेश्वर यहोवा को सामने सात दिन तक खुशी मनावो। ");
INSERT INTO lbm_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","हर साल सात दिन तक परमेश्वर लायी यो त्यौहार मनावो; यो तुम्हरी पीढ़ी सी पीढ़ी म हमेशा की विधि ठहरेंन कि सातवों महिना म यो त्यौहार मनायो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","सात दिन तक तुम खोपड़ियों म रह्यो करो, मतलब जितनो जनम सी इस्राएली हय हि सब को सब खोपड़ियों म रहेंन, ");
INSERT INTO lbm_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","येकोलायी कि तुम्हरी पीढ़ी सी पीढ़ी को लोगों ख एहसास होय जाये, कि परमेश्वर न हम इस्राएलियों ख मिस्र देश सी निकाल लायो होतो; तब हम्ख खोपड़ियों म निवास करायो होतो; मय तुम्हरो परमेश्वर यहोवा आय।” ");
INSERT INTO lbm_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","अऊर मूसा न इस्राएलियों ख परमेश्वर को त्यौहार को ठहरायो समय बतायो। ");
INSERT INTO lbm_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएलियों ख या आज्ञा देवो कि मोरो जवर उजाड़ो देन लायी कुट क निकाल्यो हुयो जैतून को शुद्ध तेल लावो कि एक दीया हमेशा जलतो रहे। ");
INSERT INTO lbm_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","हारून ओख, मिलापवालो तम्बू म, वाचा को सन्दूक को बीच वालो परदा को बाहेर, शाम सी ले क सबेरे तक परमेश्वर को सामने सजाय क रखे; यो तुम्हरी पीढ़ी सी पीढ़ी लायी हमेशा की विधि ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","हारून ऊ दीयावों ख शुद्ध सोनो को दीवट पर परमेश्वर को सामने हमेशा सजायो करे। ");
INSERT INTO lbm_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“तय मैदा ले क बारा रोटियां बनावो, हर एक रोटी दोय किलो मैदा की बनायी जाय। ");
INSERT INTO lbm_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","तब उन्की दोय पंगत कर क्, एक एक पंगत म छय छय रोटियां, शुद्ध सोनो को मेज पर परमेश्वर को सामने रखो। ");
INSERT INTO lbm_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","अऊर एक एक पंगत पर शुद्ध लुभान रखो कि वा रोटी याद दिलावन वाली चिज अऊर परमेश्वर लायी भेंट हो। ");
INSERT INTO lbm_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","हर आराम दिन ख ऊ ओख हमेशा परमेश्वर को सामने एक को बाद एक रख्यो जाये, या हमेशा वाचा की रीति इस्राएलियों को तरफ सी होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","अऊर हि रोटियां हारून अऊर ओको टुरावों की होयेंन, अऊर हि ओख कोयी पवित्र जागा म खायेंन, कहालीकि वा परमेश्वर को भेंटों म सी हमेशा की विधि को अनुसार हारून लायी परमपवित्र हिस्सा ठहरी हय।” ");
INSERT INTO lbm_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","उन दिनों म इस्राएली बाई को टुरा, जेको बाप मिस्री होतो, अऊर ऊ टुरा इस्राएलियों को बीच म चली गयो; अऊर ऊ इस्राएली बाई को टुरा अऊर एक इस्राएली आदमी छावनी को बीच म आपस म झगड़न लग्यो, ");
INSERT INTO lbm_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","अऊर वा इस्राएली बाई को टुरा परमेश्वर को नाम की निन्दा कर क् श्राप देन लग्यो। यो सुन क ओख मूसा को जवर ले गयो। ओकी माय को नाम शलोमीत होतो, जो दान वंशीय दिब्री की टुरी होती। ");
INSERT INTO lbm_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","उन्न ओख देखभाल म रख्यो, जेकोसी परमेश्वर को मन उन पर प्रगट होय सके । ");
INSERT INTO lbm_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","तब परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","तुम लोग ऊ श्राप देन वालो ख छावनी सी बाहेर लि जावो; अऊर जितनो लोगों न वा निन्दा सुनी होना हि सब अपनो अपनो हाथ ओको मुंड पर रखे, तब पूरी मण्डली को लोग ओको पर पथराव करेंन। ");
INSERT INTO lbm_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","अऊर तय इस्राएलियों सी कहजो कि कोयी भी व्यक्ति अपनो परमेश्वर ख श्राप देयेंन ओख अपनो पाप को बोझ उठानो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","परमेश्वर को नाम की निन्दा करन वालो निश्चितच मार डाल्यो जाय; पूरी मण्डली को लोग निश्चित ओको पर पथराव करे; चाहे देशी होना यां परदेशी होना, यदि कोयी परमेश्वर को नाम की निन्दा करेंन त ऊ मार डाल्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“फिर कोयी आदमी कोयी व्यक्ति ख जान सी मार डालेंन त ओख निश्चित मार डाल्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","यदि कोयी व्यक्ति कोयी जनावर ख जान सी मार दे त ऊ येको नुकसान की भरपाई कर दे, जनावर को बदला जनावर दे। ");
INSERT INTO lbm_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“फिर यदि कोयी दूसरो ख घाव पहुंचायो हय, त जसो ओन करयो हय वसोच ओको संग भी करयो जाय, ");
INSERT INTO lbm_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","मतलब तोड़-फोड़ करन को बदला तोड़-फोड़ करयो जाय, आंखी को बदला आंखी, दात को बदला दात, जसो दु:ख जेन कोयी ख दियो होना वसोच दु:ख ओख भी दियो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","जनावर ख मार डालन वालो ओको बदला भर दे, पर आदमी ख मार डालन वालो ख जरूर मार डाल्यो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","तुम्हरो नियम एकच हो, जसो देशी लायी वसोच परदेशी लायी भी हो; मय तुम्हरो परमेश्वर यहोवा आय।” ");
INSERT INTO lbm_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","येको बाद मूसा न इस्राएलियों ख यो समझायो; तब उन्न ऊ श्राप देन वालो आदमी ख छावनी सी बाहेर लाय क ओको पर पथराव करयो। अऊर इस्राएलियों न वसोच करयो जसो परमेश्वर न मूसा ख आज्ञा दी होती। ");
INSERT INTO lbm_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","फिर परमेश्वर न सीनै पहाड़ी पर मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएलियों सी कहो कि जब तुम ऊ देश म सिरो जो मय तुम्ख दे रह्यो हय, तब ऊ देश की जमीन भी परमेश्वर लायी आराम करेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","छय साल तक अपनो अपनो खेत म बीज बोयो करो, अऊर अंगूर की बाड़ी कटायी-छटायी कर क् ओकी फसल जमा करो; ");
INSERT INTO lbm_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","पर सातवों साल जमीन ख परमेश्वर लायी आराम मिलेंन; तुम ऊ साल म अपनो खेत मत बोवो अऊर नहीं अपनो अंगूर की बाड़ी छाटो। ");
INSERT INTO lbm_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","जो कुछ काट्यो हुयो खेत म अपनो आप सी उग्यो ओख मत काटो, अऊर बिना छाटी हुयी बेलावों को अंगूर मत तोड़ो; कहालीकि यो जमीन लायी परमविश्राम को साल होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","जमीन को आराम साल की फसल सी तुम्ख, अऊर तुम्हरो सेवक-सेविका ख, अऊर तुम्हरो संग रहन वालो मजूरों परदेशियों ख भी भोजन मिलेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","अऊर तुम्हरो पालतू जनावरों ख अऊर तुम्हरो देश को जंगली जनावरों ख भी जमीन की फसल सी भोजन मिलेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“सात आराम साल मतलब सातगुना सात साल गिनो, सातों साल को समय उनपचास साल होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","तब सातवों महिना को दसवों दिन ख, मतलब पश्चाताप को दिन ख, जय जयकार को महाशब्द को नरसिंगा अपनो पूरो देश म सब जागावों पर फूको। ");
INSERT INTO lbm_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","अऊर पचासवो साल ख पवित्र मानो, अऊर देश को पूरो निवासियों लायी छुटकारा को प्रचार करो; ऊ तुम्हरो लायी जुबली को साल कहलायेंन; अऊर तुम अपनो देश अऊर अपनो परिवार म लौट पावों। ");
INSERT INTO lbm_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","तुम्हरो यहां ऊ पचासवो साल जुबली को साल कहलायेंन; ओको म तुम मत बोवो, अऊर जो अपनो आप उगेंन ओख भी मत काटो, अऊर बिन छाटी हुयी अंगूर को बेला को अंगूर भी मत तोड़ो। ");
INSERT INTO lbm_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","कहालीकि ऊ जुबली को साल होयेंन; ऊ तुम्हरो लायी पवित्र साल होयेंन; जो खेतों की फसल होयेंन तुम ओखच खावो। ");
INSERT INTO lbm_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“यो जुबली को साल म हर आदमी ख अपनी अपनी निजी जमीन फिर सी हासिल होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","अऊर यदि तुम अपनो भाऊबन्धु ख कुछ बेचो यां अपनो भाऊबन्धु सी कुछ लेय लेवो, त तुम एक दूसरो ख ठगानो नहीं। ");
INSERT INTO lbm_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","जुबली साल को बाद जितनो साल बित्यो हय उन्की गिनती को अनुसार दाम ठहराय क एक दूसरो सी लेय लेवो, अऊर बच्यो साल फसल को अनुसार ऊ तुम्ख बेचेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","यदि जादा साल बच्यो हय त दाम बढ़ावो, पर यदि कम साल बच्यो हय त दाम घटावो, कहालीकि साल फसल की संख्या जितनी होना उतनीच ऊ बेचेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","तुम एक दूसरो ख धोका मत देवो; अपनो परमेश्वर सी डरो; मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“येकोलायी तुम मोरी विधियों ख मानो, मोरो नियमों को पालन करो; कहालीकि असो करनो सी तुम ऊ देश म निश्चिन्त निवास कर सको। ");
INSERT INTO lbm_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","जमीन तुम्ख अपनी फसल देयेंन, अऊर तुम पेट-भर खाय क ऊ देश म निश्चिन्त बस्यो रहो। ");
INSERT INTO lbm_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“अऊर यदि तुम कहो कि सातवों साल म हम बीज नहीं बोयबो, अऊर फसल जमा नहीं करबो, तब हम का खाबो? ");
INSERT INTO lbm_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","पर मय तुम्ख छठवो साल असी आशीष देऊं, कि जमीन की पुरानी फसल तीन साल तक पूरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","जब तुम आठवों साल म बीज बोवो, तब पुरानी फसल म सीच खावो, अऊर नववों साल की फसल आवन तक पुरानी फसल ख खावो। ");
INSERT INTO lbm_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“जमीन हमेशा लायी बेची नहीं जाय, कहालीकि जमीन मोरी आय; अऊर ओको म तुम परदेशी अऊर बाहरी हय।” ");
INSERT INTO lbm_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","पर तुम्ख अपनो हिस्सा को पूरो देश म की जमीन ख छुड़ावन को अधिकार हय। ");
INSERT INTO lbm_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“यदि तोरो कोयी जाति-भाऊ गरीब होना अऊर ऊ अपनी निजी जमीन म सी कुछ बेच डालय, त ओको कुटुम्बियों म सी जो जवर को होना ऊ आय क अपनो जाति-भाऊ को बेच्यो हुयो हिस्सा ख छुड़ाय ले। ");
INSERT INTO lbm_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","यदि कोयी आदमी लायी कोयी छुड़ावन वालो नहीं होना, अऊर ओको जवर इतनो धन होना कि खुदच अपनो हिस्सा ख छुड़ाय सकेंन, ");
INSERT INTO lbm_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","त ऊ ओको बिकन को समय सी गिनती करेंन जो साल ओन ओख बेच्यो होतो, ओख बच्यो साल को दाम चुकाय दे, तब ऊ अपनी निजी जमीन पर अधिकार होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","पर यदि ओको हाथ म अपनी जमीन फिर सी हासिल करन लायी धन नहीं होना, त वा जमीन लेन वालो को हाथ म जुबली को साल तक रहेंन; अऊर जुबली को साल म जमीन खुद मुक्त होय जायेंन अऊर बेचन वालो ख फिर सी हासिल होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“फिर यदि कोयी आदमी शहरपनाह वालो नगर म अपनो घर बेचेंन, त ऊ बेचन को बाद एक साल को अन्दर छुड़ाय सकेंन, मतलब पूरो साल भर ऊ आदमी ख छुड़ावन को अधिकार रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","पर यदि घर पूरो एक साल म छुड़ायो नहीं गयो, त शहरपनाह नगर को घर पीढ़ी सी पीढ़ी तक ऊ आदमी को अधिकार म होय जायेंन; जेन ओख लियो होतो ऊ जुबली को साल म भी नहीं छूटेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","पर बिना शहरपनाह को घर त देश को खेतों को जसो गिन्यो जायेंन; उन्को छुड़ानो भी होय सकेंन, अऊर हि जुबली को साल म भी छूट सकेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","फिर भी जिन नगरों म बन्यो घरों पर लेवियों को अधिकार हय, उन घरों ख लेवियों कोयी भी समय छुड़ाय सकय हय। ");
INSERT INTO lbm_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","अऊर यदि कोयी लेवीय अपनो घर नहीं छुड़ाये, त ऊ बेच्यो हुयो घर जो ओको हिस्सा को नगर म होना जुबली को साल म छूट जायेंन; कहालीकि इस्राएलियों को बीच म लेवियों नगरों को घरों पर उन्कोच अधिकार हय। ");
INSERT INTO lbm_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","पर उन्को नगरों को चारयी तरफ की चरायी की जमीन बेची नहीं जायेंन; कहालीकि उन पर लेवियों को अधिकार हय। ");
INSERT INTO lbm_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","फिर यदि तोरो कोयी भाऊबन्धु गरीब होय जाये, अऊर ओकी दशा तोरो सामने तरस खान लायक होय जाये, त तय ओख सम्भाल लेजो; ऊ परदेशी यात्री को जसो तोरो संग रह्य सकेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ओको सी ब्याज यां जादा फायदा मत लेजो; बल्की अपनो परमेश्वर को प्रति श्रद्धा-भाव रखजो; जेकोसी तोरो भाऊबन्धु तोरो संग जीवन बिताय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तय ओख ब्याज पर रुपया मत देजो, अऊर नहीं ओख भोजन चिज को फायदा कमावन को उद्देश सी देजो। ");
INSERT INTO lbm_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मय तुम्हरो परमेश्वर यहोवा आय; मय तुम्ख मिस्र देश सी येकोलायी निकाल लायो कि तुम्ख कनान देश देऊ अऊर तुम्हरो परमेश्वर होय जाऊ। ");
INSERT INTO lbm_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","फिर यदि कोयी तोरो भाऊबन्धु तोरो सामने गरीब होय क अपनो आप ख तोरो हाथ म बेच डाले, त ओको सी सेवक को जसो काम मत कराजो। ");
INSERT INTO lbm_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ऊ तोरो संग मजूर यां यात्री को समान रहेंन, अऊर जुबली को साल तक तोरो संग रह्य क सेवा करतो रहे; ");
INSERT INTO lbm_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","फिर ऊ अपनो बच्चावों को संग तोरो जवर सी निकल जाय, अऊर अपनो कुटुम्ब म अऊर अपनो पूर्वजों की सम्पत्ति फिर सी हासिल करेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","कहालीकि हि मोरोच सेवक आय, जिन्ख मय न मिस्र देश सी निकाल लायो हय; येकोलायी हि गुलाम को समान नहीं बेच्यो जाय। ");
INSERT INTO lbm_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","उन पर कठोरता सी अधिकार मत करजो; अपनो परमेश्वर को भय मानजो। ");
INSERT INTO lbm_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","यदि तुम्ख दास-दासियों की जरूरत हय त अपनो आस-पास की राज्यों म सी दास अऊर दासियों ख लेय लेजो। ");
INSERT INTO lbm_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","जो यात्री लोग तुम्हरो बीच म रहेंन, उन म सी अऊर उन्को घराना म सी भी जो तुम्हरो आस-पास होना, अऊर जिन्को जनम तुम्हरो देश म भयो हय, उन म सी तुम दास-दासियों ख लेय लेवो; अऊर हि तुम्हरी जायजाद होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुम अपनो टुरावों ख भी जो तुम्हरो बाद होयेंन उन्को अधिकार म कर सको, अऊर हि उन्को हिस्सा ठहरेंन; उन म सी तुम हमेशा अपनो लायी दास लियो करो, पर तुम्हरो भाऊबन्धु जो इस्राएली होना उन पर अपनो अधिकार कठोरता सी मत जताजो। ");
INSERT INTO lbm_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“फिर यदि तोरो सामने परदेशी यां यात्री धनी होय जाये, अऊर ओको सामने तोरो भाऊ गरीब होय क अपनो आप ख तोरो सामने ऊ परदेशी यां यात्री को कुटुम्ब को कोयी सदस्य को हाथ म बेच डाले, ");
INSERT INTO lbm_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","त ओको बेच्यो जान को बाद ऊ फिर छुड़ायो जाय सकय हय; ओको भाऊवों म सी कोयी ओख छुड़ाय सकय हय, ");
INSERT INTO lbm_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","यां ओको काका, यां काका भाऊ, यां ओको कुल को कोयी भी जवर को कुटुम्बी ओख छुड़ाय सकय हय; यां यदि ऊ धनी होय जाये, त ऊ खुदच अपनो ख छुड़ाय सकय हय।” ");
INSERT INTO lbm_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ऊ अपनो लेन वालो को संग अपनो बेच्यो जान को साल सी जुबली को साल तक गिनती करे, अऊर ओको बेचन को दाम साल की गिनती को अनुसार होयेंन, मतलब ऊ दाम मजूरों को समय को समान ओको संग होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","यदि जुबली को साल को बहुत साल बाकी रह्य जाये, त जितनो रुपयों सी ऊ लियो गयो होना उन म सी ऊ अपनो छुड़ावन को दाम उतनो साल को अनुसार लौटाय देयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","यदि जुबली को साल को थोड़ो साल बाकी रह्य गयो होना, तब भी ऊ अपनो मालिक को संग हिसाब कर क् अपनो छुड़ावन को दाम उतनोच साल को अनुसार लौटाय देयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ऊ अपनो मालिक को संग ऊ मजूर को समान रहे जेकी वार्षिक मजूरी ठहरायी जावय हय; अऊर ओको मालिक ओको पर तोरो सामने कठोरता सी अधिकार नहीं जतानो पाये। ");
INSERT INTO lbm_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","अऊर यदि ऊ इन रीतियों सी छुड़ायो नहीं जाये, त ऊ जुबली को साल म अपनो बाल-बच्चां समेत छूट जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","कहालीकि इस्राएली मोरोच सेवक आय; हि मिस्र देश सी मोरोच निकाल्यो हुयो सेवक आय; मय तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“तुम अपनो लायी मूर्ती मत बनावो, अऊर नहीं कोयी खोदी हुयी मूर्ती यां खम्बा अपनो लायी खड़ो मत करो, अऊर नहीं अपनो देश म दण्डवत करन लायी नक्काशीदार गोटा स्थापित करो; कहालीकि मय तुम्हरो परमेश्वर यहोवा आय।” ");
INSERT INTO lbm_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","तुम मोरो आराम दिनों को पालन करो अऊर मोरो पवित्र जागा को आदर करो; मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“यदि तुम मोरी विधियों पर चलो अऊर मोरी आज्ञावों ख मान क ओको पालन करो, ");
INSERT INTO lbm_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","त मय तुम्हरो लायी समय समय पर बारीश बरसाऊं, जेकोसी खेत अपनी उपज उपजायेंन, अऊर जमीन को झाड़ अपनो अपनो फर दियो करेंन; ");
INSERT INTO lbm_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","यहां तक कि तुम अंगूर तोड़न को समय भी दावनी करतो रहो, अऊर बोवन को समय भी अंगूर तोड़तो रहो, अऊर तुम भरपेट रोटी खावो, अऊर अपनो देश म निश्चिन्त होय क बस्यो रहो। ");
INSERT INTO lbm_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“अऊर मय तुम्हरो देश ख सुख चैन देऊं, अऊर तुम्ख कोयी नहीं डरायेंन; अऊर मय ऊ देश म हिंसक जनावरों ख नहीं रहन देऊं, अऊर नहीं तुम्हरो देश पर तलवार चलेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","अऊर तुम अपनो दुश्मनों ख मार भगावों। अऊर हि तुम्हरो सामने तलवार सी मारयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुम म सी पाच आदमी सौ ख अऊर सौ आदमी दस हजार ख खदेड़ेंन; अऊर तुम्हरो दुश्मन तलवार सी तुम्हरो सामने मारयो जायेंन; ");
INSERT INTO lbm_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","अऊर मय तुम्हरो तरफ कृपादृष्टि रखूं अऊर तुम ख फलवन्त करूं अऊर बढ़ाऊं, अऊर तुम्हरो संग अपनी वाचा ख पूरी करूं। ");
INSERT INTO lbm_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","अऊर तुम रख्यो हुयो अनाज ख खावो, अऊर नयो रहतो हुयो भी पुरानो ख निकालो। ");
INSERT INTO lbm_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","अऊर मय तुम्हरो बीच म अपनो निवास-स्थान बनाऊं, अऊर मोरो जीव तुम सी घृना नहीं करेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","अऊर मय तुम्हरो बीच म चल्यो फिरयो करूं, अऊर तुम्हरो परमेश्वर बन्यो रहूं, अऊर तुम मोरो लोग बन्यो रहो। ");
INSERT INTO lbm_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","मय त तुम्हरो ऊ परमेश्वर यहोवा आय, जो तुम ख मिस्र देश सी येकोलायी निकाल लायो कि तुम मिस्रियों को गुलाम नहीं बन्यो रहो; अऊर मय न तुम्हरो जूवा ख तोड़ डाल्यो हय, अऊर तुम्ख सीधो खड़ो कर क् चलायो हय।” ");
INSERT INTO lbm_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“यदि तुम मोरी नहीं सुनो, अऊर इन सब आज्ञावों ख नहीं मानो, ");
INSERT INTO lbm_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","अऊर मोरी विधियों ख निकम्मा जानो, अऊर तुम्हरी आत्मा मोरो फैसला सी घृना करेंन, अऊर तुम मोरी सब आज्ञावों को पालन नहीं करो, बल्की मोरी वाचा ख तोड़ो, ");
INSERT INTO lbm_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","त मय तुम सी यो व्यवहार करूं; मतलब मय तुम्ख बेचैन करूं, अऊर क्षयरोग अऊर बुखार सी पीड़ित करूं, अऊर इन्को वजह तुम्हरी आंखी धुंधली होय जायेंन, अऊर तुम्हरो मन जादा उदास होयेंन। अऊर तुम्हरो बीज बोवनो बेकार होयेंन, कहालीकि तुम्हरो दुस्मन उन्की उपज खाय जायेंन; ");
INSERT INTO lbm_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","अऊर मय भी तुम्हरो खिलाफ होय जाऊं, अऊर तुम अपनो दुस्मन सी हार जावो; अऊर तुम्हरो दुस्मन तुम्हरो ऊपर अधिकार करेंन, अऊर जब कोयी तुम्हरो पीछा भी नहीं कर रह्यो होना तब भी तुम भगो।” ");
INSERT INTO lbm_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“अऊर यदि तुम इन बातों को होन पर भी मोरी नहीं सुनो, त मय तुम्हरो पापों को वजह तुम्ख सातगुना सजा देऊं, ");
INSERT INTO lbm_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","अऊर मय तुम्हरो बल को घमण्ड तोड़ डालूं, अऊर तुम्हरो लायी आसमान ख लोहा को जसो अऊर जमीन ख पीतल को जसो कठोर बनाय देऊं, ");
INSERT INTO lbm_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","अऊर तुम्हरी मेहनत बेकार जायेंन, कहालीकि तुम्हरी खेत उपज नहीं उपजायेंन, अऊर जमीन को झाड़ अपनो फर नहीं देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“यदि तुम मोरो खिलाफ चलतोच रहो, अऊर मोरो कहनो नहीं मानो, त मय तुम्हरो पापों को अनुसार तुम पर सातगुना अऊर भी संकट डालूं।” ");
INSERT INTO lbm_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","अऊर मय तुम्हरो बीच म जंगली जनावर भेजूं, जो तुम्हरो बच्चां ख अऊर तुम्हरो घरेलू जनावरों ख नाश कर डालेंन, अऊर तुम्हरी गिनती घटायेंन, जेकोसी तुम्हरी सड़के सुनी पड़ जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“फिर यदि तुम इन बातों पर भी मोरी ताड़ना सी नहीं सुधरो, अऊर मोरो खिलाफ चलतोच रहो, ");
INSERT INTO lbm_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","त मय तुम्हरो खिलाफ चलू, अऊर तुम्हरो पापों को वजह मय खुदच तुम्ख सातगुना सजा देऊं।” ");
INSERT INTO lbm_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","अऊर मय तुम पर एक असी तलवार चलाऊं, जो वाचा तोड़न को पूरो पूरो बदला लेयेंन; अऊर जब तुम नगरों म जाय क जमा होवो तब मय तुम्हरो बीच म मरी फैलाऊं, अऊर तुम अपनो दुस्मनो को हाथ म सौप दियो जावो। ");
INSERT INTO lbm_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","जब मय तुम्हरो लायी अनाज को आधार ख दूर कर डालूं, तब दस बाईयां एकच तंदूर म पकाय क तौल तौल क देयेंन; तुम रोटियां त खावो पर तृप्त नहीं होवो। ");
INSERT INTO lbm_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“फिर यदि तुम येको बाद भी मोरी नहीं सुनो, अऊर मोरो खिलाफ चलतोच रहो, ");
INSERT INTO lbm_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","त मय गुस्सा म भर क तुम्हरो खिलाफ चलू, अऊर तुम्हरो पापों को वजह तुम ख सातगुना सजा अऊर भी देऊं।” ");
INSERT INTO lbm_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","अऊर तुम ख अपनो बेटावों अऊर बेटियां को मांस खानो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","अऊर मय तुम्हरो पूजा की वेदियों ख गिराय देऊं, अऊर तुम्हरी सूर्य की मूर्तियों ख तोड़ डालूं, अऊर तुम्हरो लाशों ख तुम्हरी तोड़ी हुयी मूर्तियों पर फेक देऊं; अऊर मय तुम सी घृना करूं। ");
INSERT INTO lbm_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","अऊर मय तुम्हरो नगरों ख उजाड़ देऊं, अऊर तुम्हरो पवित्र जागावों ख भी उजाड़ देऊं, अऊर तुम्हरो सुखदायक सुगन्ध स्विकार नहीं करूं। ");
INSERT INTO lbm_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","अऊर मय तुम्हरो देश ख सुनो कर देऊं, अऊर तुम्हरो दुस्मन जो ओको म रह्य हय हि इन बातों वजह चकित होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","अऊर मय तुम्ख राज्य-राज्य को बीच तितर-बितर कर देऊं, अऊर तुम्हरो पीछू पीछू तलवार निकाल्यो रहूं; अऊर तुम्हरो देश सुनो अऊर तुम्हरो नगर उजाड़ होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“तब जितनो दिन ऊ देश सुनो पड़्यो रहेंन अऊर तुम अपनो दुस्मनो को देश म रहो उतनो दिन ऊ अपनो आराम कालों ख मानतो रहेंन, तबच ऊ देश आराम पायेंन, मतलब अपनो आराम कालों ख मानतो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","जितनो दिन ऊ देश सूनो पड़्यो रहेंन उतनो दिन ओख आराम मिलेंन, मतलब जो आराम ओख तुम्हरो वहां बस्यो रहन को समय तुम्हरो आराम कालों म नहीं मिल्यो होना ऊ ओख तब मिलेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“अऊर तुम म सी जो बच्यो हुयो को दिल म जो तुम्हरो दुस्मनो को देश म होना उन्को दिलो म कायरता पैदा करूं; अऊर हि सुख्यो पत्ता को खड़कन को आवाज सीच भग जायेंन, अऊर हि असो भगेंन जसो कोयी तलवार सी बचन लायी भगय हय, उन्को पीछा करन वालो नहीं होनो पर भी हि गिर पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","जब कोयी पीछा करन वालो नहीं होना तब भी तलवार को डर सी लड़खड़ाय क एक दूसरो पर गिरतो जायेंन, अऊर तुम्ख अपनो दुस्मनो को सामने खड़ो रहन की तुम म कुछ भी शक्ति नहीं रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तब तुम राज्य-राज्य को बीच पहुंच क नाश होय जावो, अऊर तुम्हरो दुस्मनो की जमीन तुम्ख खाय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","अऊर तुम सी जो बच्यो रहेंन हि अपनो दुस्मनो को देश म अपनो पाप को वजह गल जायेंन; अऊर अपनो पुरखावों को बुरो कामों को वजह भी हि उन्कोच जसो गल जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“पर यदि हि अपनो पितरों को बुरो काम ख मान लेयेंन, मतलब ऊ जो मोरो विश्वासघात करेंन, अऊर यो भी मान लेयेंन कि हम परमेश्वर को खिलाफ चल्यो होतो, ");
INSERT INTO lbm_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","यो वजह ऊ हमरो खिलाफ होय क हम्ख दुस्मनो को देश म लायो हय। यदि ऊ समय उन्को खतनारहित दिल दब जायेंन अऊर हि ऊ समय अपनो बुरो काम की सजा ख स्विकार करेंन; ");
INSERT INTO lbm_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","तब जो वाचा मय न याकूब को संग बान्धी होती ओख मय याद करूं, अऊर जो वाचा मय न इसहाक अऊर अब्राहम सी बान्धी होती ओख भी याद करूं, अऊर यो देश ख भी मय याद करूं। ");
INSERT INTO lbm_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","पर ऊ देश उन्को निकल जानो सी सुनो पड़्यो रहेंन, अऊर उन्को बिना सुनो रह्य क भी आराम कालों ख मानतो रहेंन; अऊर हि लोग अपनो बुरो काम की सजा ख स्विकार करेंन, योच वजह सी उन्न मोरी आज्ञावों को उल्लंघन करयो होतो, अऊर उन्की आत्मावों ख मोरी विधियों सी घृना होती। ");
INSERT INTO lbm_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","इतनो होनो पर भी हि अपनो दुस्मनो को देश म रहेंन तब मय उन्ख यो तरह नहीं छोड़ूं, अऊर नहीं उन्कोसी असी घृना करूं कि उन्को सत्यानाश कर डालूं अऊर अपनी वा वाचा ख तोड़ देऊ जो मय न उन्कोसी बान्धी होती; कहालीकि मय उन्को परमेश्वर यहोवा आय; ");
INSERT INTO lbm_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","पर मय उन्की भलायी लायी उन्को पितरों सी बान्धी हुयी वाचा ख याद करूं; जिन्ख मय न दूसरो राज्यों को लोगों की आंखी को सामने मिस्र देश सी निकाल क लायो कि मय उन्को परमेश्वर ठहरू मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","जो जो विधियां अऊर नियम अऊर व्यवस्था परमेश्वर न अपनो तरफ सी इस्राएलियों लायी सीनै पहाड़ी पर मूसा को द्वारा ठहरायी होती हि याच आय। ");
INSERT INTO lbm_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","फिर परमेश्वर न मूसा सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएलियों सी यो कहो कि जब कोयी विशेष मन्नत मानेंन, त मन्नत करयो हुयो व्यक्ति तोरो ठहरायो जान को अनुसार परमेश्वर को होयेंन; ");
INSERT INTO lbm_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","येकोलायी यदि ऊ बीस साल यां ओको सी जादा अऊर साठ साल सी कम को आदमी होना, त ओको लायी पवित्र जागा को शेकेल को अनुसार चांदी को पचास शेकेल को सिक्का ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","अऊर यदि वा बाई होना, त ओको लायी चांदी को तीस शेकेल ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","फिर यदि ओकी उमर पाच साल यां ओको सी जादा हय अऊर बीस साल सी कम की होना, त टुरा लायी बीस शेकेल, अऊर टुरी लायी दस शेकेल ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","यदि ओकी उमर एक महिना यां ओको सी जादा हय अऊर पाच साल सी कम की होना, त टुरा लायी पाच शेकेल, अऊर टुरी लायी तीन शेकेल ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","फिर यदि ओकी उमर साठ साल की यां ओको सी जादा होना, अऊर ऊ आदमी होना त ओको लायी पन्द्रा शेकेल, अऊर बाई होना त दस शेकेल ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“पर यदि कोयी इतनो गरीब होना कि याजक को ठहरायो हुयो दाम नहीं दे सकय, त ओख याजक को सामने खड़ो करयो जाय, अऊर याजक ओकी धन ठहरायेंन, मतलब जितनो मन्नत मानन वालो सी होय सकय, याजक ओकोच अनुसार ठहरायेंन।” ");
INSERT INTO lbm_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“फिर जिन जनावरों म सी लोग परमेश्वर ख चढ़ावा चढ़ावय हंय, यदि असो म सी कोयी मन्नत करयो गयो होना, त जो जनावर कोयी परमेश्वर ख दे ऊ पवित्र ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ऊ ओख कोयी तरह सी नहीं बदले, नहीं त बुरो को बदला अच्छो, अऊर नहीं अच्छो को बदला बुरो दे; अऊर यदि ऊ ऊ जनावर को बदला दूसरो जनावर दे, त ऊ अऊर ओको दूसरो जनावर दोयी पवित्र ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","अऊर जिन अशुद्ध जनावरों म लोग परमेश्वर लायी चढ़ावा नहीं चढ़ावय ओको म सी होना, त ऊ व्यक्ति ऊ जनावर ख याजक को सामने खड़ो कर दे, ");
INSERT INTO lbm_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","तब याजक ओको दाम ठहरायेंन कि ऊ अच्छो हय यां बुरो; अऊर जितनो याजक ठहरायेंन ओको दाम उतनोच ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","पर यदि मन्नत मानन वालो ओख कोयी तरह सी छुड़ानो चाहेंन, त जो दाम याजक न ठहरायो होना ओको म ओको पाचवों हिस्सा अऊर बढ़ाय क दे। ");
INSERT INTO lbm_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“फिर यदि कोयी अपनो घर परमेश्वर लायी पवित्र ठहराय क मन्नत मानय, त याजक ओको दाम ठहरायेंन कि ऊ अच्छो घर हय यां बुरो; अऊर जितनो याजक ठहरायेंन ओको दाम उतनोच ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","अऊर यदि घर को पवित्र करन वालो ओख छुड़ानो चाहेंन, त जितनो रुपया याजक न ठहरायो होना ओको म ऊ व्यक्ति पाचवों हिस्सा अऊर बढ़ाय क दे, तब ऊ घर ओकोच रहेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“फिर यदि कोयी अपनी निजी जमीन को कोयी हिस्सा परमेश्वर लायी पवित्र ठहरानो चाहेंन, त ओको दाम येकोच अनुसार ठहरेंन कि ओको म कितनो बीज लगेन; जितनो जमीन म होमेर भर जौ बोयो जायेंन उतनो को दाम पचास शेकेल ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","यदि ऊ अपनो खेत जुबली को साल म पवित्र ठहरायेंन, त ओको दाम तोरो ठहरान को अनुसार ठहरेंन; ");
INSERT INTO lbm_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","अऊर यदि ऊ अपनो खेत जुबली को साल को बाद पवित्र ठहरायेंन, त जितनो साल दूसरो जुबली को साल को बाकी रहेंन उन्कोच अनुसार याजक ओको लायी रुपया को हिसाब करेंन, तब जितनो हिसाब म आयेंन उतनो याजक को ठहरायो हुयो सी कम कर दे। ");
INSERT INTO lbm_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","अऊर यदि खेत को पवित्र ठहरान वालो ओख छुड़ानो चाहेंन, त जो दाम याजक न ठहरायो होना ओख म सी ऊ पाचवों हिस्सा अऊर बढ़ाय क देयेंन, तब खेत ओकोच होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","पर यदि ऊ खेत ख छुड़ानो नहीं चाहेंन, यां ओन ऊ खेत दूसरो ख बेच्यो होना, त खेत कभी नहीं छुड़ायो जायेंन; ");
INSERT INTO lbm_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","पर जब ऊ खेत जुबली को साल म छुड़ायो जायेंन, तब पूरी रीति सी अर्पन करयो हुयो खेत को समान परमेश्वर लायी पवित्र ठहरेंन, मतलब ऊ याजक की निजी जमीन होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“फिर यदि कोयी अपनो लियो हुयो खेत, जो ओकी निजी जमीन को हिस्सा नोहोय, ओख परमेश्वर लायी पवित्र ठहराये, ");
INSERT INTO lbm_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","त याजक जुबली को साल तक को हिसाब कर क् ऊ आदमी लायी जितनो ठहरायो गयो हय उतनोच ऊ परमेश्वर लायी पवित्र जान क उच दिन दे दे।” ");
INSERT INTO lbm_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","जुबली को साल म खेत ऊ व्यक्ति ख फिर सी ओख हासिल होय जायेंन, जेकोसी ओन लियो होतो, जेकी वा निजी जमीन होती ओकीच होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","जो जो चिज को दाम याजक ठहरायेंन ओको दाम पवित्र जागा को शेकेल को हिसाब सी ठहरेंन, शेकेल बीस गेरा को होयेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“पर घरेलू जनावरों को पहिलौटा पर सिर्फ परमेश्वर को अधिकार हय, कोयी भी ओख पवित्र नहीं ठहराये; चाहे ऊ गोरा होना, चाहे ऊ मेंढा होना यां पालतु जनावर होना ओको पर परमेश्वर को अधिकार हय। ");
INSERT INTO lbm_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","पर यदि ऊ अशुद्ध जनावर को हय, त ओख पवित्र ठहरान वालो ओख याजक को ठहरायो हुयो दाम को अनुसार ओको पाचवों हिस्सा अऊर बढ़ाय क छुड़ाय सकय हय; अऊर यदि ऊ जनावर छुड़ायो नहीं जाये, त याजक को ठहरायो हुयो दाम पर बेच दियो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“पर अपनी पूरी चिजों म सी जो कुछ कोयी परमेश्वर लायी भेंट करे, चाहे ऊ आदमी होना चाहे जनावर, चाहे ओकी निजी जमीन को खेत होना, असी कोयी भेंट करी हुयी चिज नहीं बेची जाये अऊर नहीं छुड़ायी जाये; जो कुछ भेंट करयो जाये ऊ परमेश्वर लायी परमपवित्र ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","आदमियों म सी जो कोयी मृत्य-दण्ड लायी भेंट करयो जाये, ऊ छुड़ायो नहीं जाये; जरूर ऊ मार डाल्यो जाये। ");
INSERT INTO lbm_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“फिर जमीन की फसल को पूरो दशमांश, चाहे ऊ जमीन को बीज होना चाहे झाड़ को फर, ऊ परमेश्वर कोच आय; ऊ परमेश्वर लायी पवित्र ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","यदि कोयी अपनो दशमांश म सी कुछ वापस लेनो चाहेंन, त पाचवों हिस्सा बढ़ाय क ओख छुड़ाये। ");
INSERT INTO lbm_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","अऊर पालतु जनावर मेंढी-शेरियों को हर एक दसवों जनावर, जो चरवाहा की लाठी को खल्लो सी निकल जावय हय ऊ परमेश्वर लायी पवित्र ठहरे। ");
INSERT INTO lbm_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","कोयी उन म अच्छो अऊर बुरो जनावर म भेद नहीं करे, अऊर नहीं उन्ख बदले; अऊर यदि कोयी ओख बदल भी लेवय हय, त ऊ अऊर ओको दूसरो जनावर दोयी पवित्र ठहरेंन; अऊर ऊ कभी छुड़ायो नहीं जाये।” ");
INSERT INTO lbm_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","जो आज्ञाये परमेश्वर न इस्राएलियों लायी सीनै पहाड़ी पर मूसा ख दी होती हि याच आय।");
INSERT INTO lbm_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","परमेश्वर को सेवक मूसा को मरन को बाद परमेश्वर न ओको सेवक यहोशू सी कह्यो जो नून को टुरा होतो, ");
INSERT INTO lbm_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“मोरो सेवक मूसा मर गयो हय; येकोलायी अब तय उठ, तैयार हो, अऊर पूरी इस्राएली प्रजा समेत यरदन नदी को पार होय क ऊ देश म जा जेक मय इस्राएली लोगों ख दे रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","ऊ वचन को अनुसार जो मय न मूसा सी कह्यो, मतलब जो जो जागा पर तुम पाय रखो ऊ सब मय तुम्ख देऊं। ");
INSERT INTO lbm_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","दक्षिन म जंगल सी उत्तर म लबानोन की पहाड़ियों तक, पूर्व म फरात महानदी अऊर हित्ती जाती को सब लोग देश सी पश्चिम म महासमुन्दर तक ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","तोरो जीवन भर कोयी तोरो सामने ठहर नहीं सकेंन; जसो मय मूसा को संग रह्यो वसोच तोरो संग भी रहूं; अऊर नहीं मय तोख धोखा देऊं, अऊर नहीं तोख छोड़ूं। ");
INSERT INTO lbm_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","येकोलायी हिम्मत बान्ध क मजबूत होय जा; कहालीकि जो देश ख देन की कसम मय न इन लोगों को पूर्वजों सी खायी होती ओको अधिकारी तय इन ख करजो। ");
INSERT INTO lbm_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","इतनो हो कि तय हिम्मत बान्ध अऊर बहुत मजबूत होय क जो व्यवस्था मोरो सेवक मूसा न तोख दियो हय उन सब को अनुसार करन म चौकसी करजो; अऊर ओको सी नहीं तय दायो मुड़जो अऊर नहीं बायो, तब जहां जहां तय जाजो वहां वहां तोरो काम सफल होयेंन। ");
INSERT INTO lbm_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","व्यवस्था की या किताब को शब्द मोरो मुंह सी कभी नहीं अलग होनो पाये, येकोच म रात दिन ध्यान लगायो रहजो, येकोलायी कि जो कुछ ओको म लिख्यो हय ओको अनुसार करन की तय चौकसी करजो; कहालीकि असोच करन सी तोरो सब काम सफल होयेंन, अऊर तय प्रभावशाली होयजो। ");
INSERT INTO lbm_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","का मय न तोख आज्ञा नहीं दी? हिम्मत बान्ध क मजबूत होय जा; डर मत, अऊर तोरो मन निराश नहीं हो; कहालीकि जहां जहां तय जाजो वहां वहां तोरो परमेश्वर यहोवा तोरो संग रहेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","तब यहोशू न प्रजा को मुख्य लोगों ख या आज्ञा दी, ");
INSERT INTO lbm_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“छावनी म इत उत जाय क प्रजा को लोगों ख या आज्ञा देवो, कि अपनो अपनो लायी भोजन तैयार कर क् रखो; कहालीकि तीन दिन को अन्दर तुम ख यो यरदन नदी को पार उतर क ऊ देश ख अपनो अधिकार म लेन लायी जानो हय जेक तुम्हरो परमेश्वर यहोवा तुम्हरो अधिकार म दे रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","फिर यहोशू न रूबेनियों, गादियों, अऊर मनश्शे को अरधो वंश को लोगों सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“जो बात परमेश्वर को सेवक मूसा न तुम सी कही होती कि तुम्हरो परमेश्वर यहोवा तुम्ख आराम देवय हय, अऊर योच देश तुम्ख देयेंन, ओकी सुधि लेवो। ");
INSERT INTO lbm_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","तुम्हरी पत्नियां, बाल-बच्चा, अऊर जनावर त यो देश म रहेंन जो मूसा न तुम्ख यरदन को येन पारच दियो, पर तुम जो योद्धा शस्त्र उठाय क अपनो भाऊवों को आगु आगु ओन पार उतर क चलो, अऊर उन्की मदत करो; ");
INSERT INTO lbm_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","अऊर जब परमेश्वर उन्ख असो आराम देयेंन जसो ऊ तुम्ख दे चुक्यो हय, अऊर हि भी तुम्हरो परमेश्वर यहोवा को दियो हुयो देश को अधिकारी होय जायेंन; तब तुम अपनो अधिकार को देश म, जो परमेश्वर को सेवक मूसा न यरदन को येन पार पूर्व को तरफ तुम्ख दियो हय, लौट क येको अधिकारी होयेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","तब उन्न यहोशू ख उत्तर दियो, “जो कुछ तय न हम्ख करन की आज्ञा दी हय ऊ हम करबोंन, अऊर जहां कहीं तय हम्ख भेजो वहां हम जाबोन। ");
INSERT INTO lbm_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","जसो हम सब बातों म मूसा की मानत होतो वसोच तोरी भी मानबो, इतनो होय कि तोरो परमेश्वर यहोवा जसो मूसा को संग रहत होतो वसोच तोरो संग भी रहे। ");
INSERT INTO lbm_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","कोयी भी कहाली नहीं होय जो तोरो खिलाफ विद्रोह करे, अऊर जितनी आज्ञाये तय देजो उन्ख नहीं मानय, त ऊ मार डाल्यो जायेंन। पर तय मजबूत अऊर हिम्मत बान्ध्यो रहे।” ");
INSERT INTO lbm_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","तब नून को टुरा यहोशू न दोय भेदियों ख शित्तीम सी चुपचाप सी भेज दियो, अऊर ओन कह्यो, “जाय क ऊ देश अऊर यरीहो ख देखो।” तुरतच हि चली गयो, अऊर राहब नाम की कोयी वेश्या को घर म जाय क ठहर गयो। ");
INSERT INTO lbm_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","तब कोयी न यरीहो नगर को राजा सी कह्यो, “अज की रात कुछ इस्राएली लोग हमरो देश को भेद लेन लायी यहां आयो हुयो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","तब यरीहो नगर को राजा न राहब को जवर यो सन्देश भेज्यो, “जो आदमी तोरो यहां आयो हय उन्ख बाहेर लाव; कहालीकि हि पूरो देश को भेद लेन लायी आयो हंय।” ");
INSERT INTO lbm_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","वा बाई न दोयी आदमियों ख लूकाय रख्यो; अऊर यो तरह कह्यो, “मोरो जवर कुछ आदमी आयो त होतो, पर मय नहीं जानु कि हि कहां को होतो; ");
INSERT INTO lbm_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","अऊर जब अन्धारो भयो, अऊर नगर को फाटक बन्द होन लग्यो, तब हि निकल गयो; मोख मालूम नहीं कि हि कहां गयो; तुम फुर्ती कर क् उन्को पीछा करो त उन्ख जाय क पकड़ो।” ");
INSERT INTO lbm_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","राहब न भेदियों ख घर की छत पर चढ़ाय क सन की लकड़ियों को खल्लो लूकाय दियो होतो जो ओन लकड़ी छत पर जमाय क रखी होती। ");
INSERT INTO lbm_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","राजा को कर्मचारी यरदन को रस्ता सी उन्की खोज म घाट तक चली गयो; अऊर उन्ख खोजन वालो नगर को फाटक सी बाहेर निकलतोच फाटक बन्द कर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","भेदियों को सोवन सी पहले राहब छत पर उन्को जवर आयी ");
INSERT INTO lbm_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","अऊर इन आदमियों सी कहन लगी, “मोख त निश्चय हय कि परमेश्वर न तुम लोगों ख यो देश दियो हय, अऊर तुम्हरो डर हम लोगों को मन म समायो हय, अऊर यो देश को सब निवासी तुम्हरो वजह घबराय रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","कहालीकि हम न सुन्यो हय कि परमेश्वर न तुम्हरो मिस्र देश सी निकलन को समय तुम्हरो सामने लाल समुन्दर को पानी सुखाय दियो। अऊर तुम लोगों न सीहोन अऊर ओग नाम को यरदन को पार रहन वालो एमोरियों को दोयी राजावों को नाश कर डाल्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","अऊर यो सुनतोच हमरो मन पिघल गयो, अऊर तुम्हरो वजह कोयी को जीव म जीव नहीं रह्यो; कहालीकि तुम्हरो परमेश्वर यहोवा ऊपर को आसमान को अऊर खल्लो की धरती को परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","अब मय न तुम पर दयापूर्ण व्यवहार करयो हय, येकोलायी मोरो सी परमेश्वर की कसम खावो कि तुम भी मोरो बाप को परिवार को संग दयापूर्ण व्यवहार करो, अऊर येको सच्चो चिन्ह मोख देवो। ");
INSERT INTO lbm_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","तुम मोख वचन देवो कि तुम मोरो माय बाप, भाऊवों अऊर बहिनों ख, अऊर जो कुछ उन्को हय उन सब ख भी जीन्दो रहन देवो, अऊर हम सब को जीव मरन सी बचावो।” ");
INSERT INTO lbm_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","तब उन आदमियों न ओको सी कह्यो, “यदि तय हमरी या बात कोयी पर प्रगट नहीं करे, त तुम्हरो जीव को बदला हमरो जीव जाये; अऊर परमेश्वर हम्ख यो देश देयेंन, तब हम तोरो संग कृपा अऊर सच्चायी सी बर्ताव करबो।” ");
INSERT INTO lbm_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","तब राहब जेको घर नगर की दीवाल सी लग क बन्यो होतो, अऊर वा वहांच रहत होती, ओन भेदियों ख खिड़की सी रस्सा को सहारा सी उतार क नगर को बाहेर कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","अऊर ओन कह्यो, “पहाड़ी को तरफ चली जावो, असो नहीं होय कि खोजन वालो राजा को दूत तुम्ख पकड़ ले; येकोलायी जब तक तुम्हरो खोजन वालो वापस लौट क नहीं आवय तब तक, तीन दिन वहांच लूक्यो रहो, ओको बाद अपनो रस्ता लेवो।” ");
INSERT INTO lbm_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","उन्न ओको सी कह्यो, “जो कसम तय न हम्ख खिलायी हय ओको बारे म हम त निर्दोष रहबोंन। ");
INSERT INTO lbm_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","सुन, जब हम लोग यो देश म आयबो, तब जो खिड़की सी तय न हम्ख उतारयो हय ओको म योच लाल रंग की सूत की दोरी बान्ध देजो; अऊर अपनो माय बाप, भाऊवों, बल्की अपनो बाप को पूरो घराना ख योच घर म अपनो जवर जमा कर क् रखजो। ");
INSERT INTO lbm_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","तब जो कोयी तोरो घर को दरवाजा सी बाहेर निकलेंन, ओको खून को दोष ओकोच मुंड पर पड़ेंन, अऊर हम निर्दोष ठहरबो : पर यदि तोरो संग घर म रहतो हुयो कोयी को हाथ कोयी पर पड़ेंन, त ओको खून को दोष हमरो मुंड पर पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","फिर यदि तय हमरी या बात कोयी पर प्रगट करे, त जो कसम तय न हम्ख खिलायी हय ओको सी हम निर्दोष ठहरबो।” ");
INSERT INTO lbm_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","ओन कह्यो, “जसो तुम न कह्यो वसोच हो।” तब ओन उन्ख बिदा करयो, अऊर हि चली गयो; अऊर ओन लाल रंग की दोरी ख खिड़की म बान्ध दियो। ");
INSERT INTO lbm_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","भेदी जाय क पहाड़ी पर पहुंच्यो, अऊर वहां खोजन वालो को लौटन तक, मतलब तीन दिन तक रह्यो; अऊर खोजन वालो उन्ख पूरो रस्ता म ढूंढतो रह्यो पर हि कहीं नहीं मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","तब हि दोयी भेदी पहाड़ी सी उतरयो, अऊर नदी पार कर क् नून को टुरा यहोशू को जवर पहुंच्यो अऊर जो कुछ उन पर बीत्यो होतो ऊ बताय दियो। ");
INSERT INTO lbm_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","अऊर उन्न यहोशू सी कह्यो, “परमेश्वर न ऊ पूरो देश हमरो हाथ म कर दियो हय; येको सिवाय ओको पूरो निवासी हमरो वजह घबराय रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","यहोशू सुबेरे उठ्यो, अऊर सब इस्राएली लोगों ख ले क शित्तीम सी निकल क यरदन नदी को किनारे आयो; अऊर हि ओन पार जान सी पहले वहांच मुक्काम करयो। ");
INSERT INTO lbm_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","अऊर तीन दिन को बाद सरदारों न छावनी को बीच जाय क ");
INSERT INTO lbm_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","प्रजा को लोगों ख या आज्ञा दी, “जब तुम्ख अपनो परमेश्वर यहोवा को वाचा को सन्दूक अऊर ओख उठायो हुयो लेवी याजक ख भी देख लेवो, तब अपनी जागा सी निकल क ओको पीछू चलो, ");
INSERT INTO lbm_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","पर ओको अऊर तुम्हरो बीच म दोय हजार हाथ को अन्तर रहे; तुम सन्दूक को जवर मत जाओ। ताकी तुम देख सको कि कौन्सो रस्ता सी तुम्ख चलनो हय, कहालीकि अब तक तुम यो रस्ता पर नहीं आयो होतो।” ");
INSERT INTO lbm_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","फिर यहोशू न लोगों सी कह्यो, “तुम अपनो आप ख पवित्र करो; कहालीकि कल को दिन परमेश्वर तुम्हरो बीच म अद्भूत काम करेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","तब यहोशू न याजकों सी कह्यो, “वाचा को सन्दूक उठाय क प्रजा को आगु आगु चलो।” तब हि वाचा को सन्दूक उठाय क आगु आगु चलन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","तब परमेश्वर न यहोशू सी कह्यो, “अज को दिन सी मय इस्राएलियों को जवर तोरी प्रशंसा करनो सुरू करूं, तब हि जान लेयेंन कि जसो मय मूसा को संग रहत होतो वसोच मय तोरो संग भी हय। ");
INSERT INTO lbm_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","अऊर तय वाचा को सन्दूक उठावन वालो याजकों ख या आज्ञा दे, ‘जब तुम यरदन नदी को किनार पहुंचो, तब यरदन नदी म खड़ो होय जावो।’” ");
INSERT INTO lbm_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","तब यहोशू न इस्राएली लोगों सी कह्यो, “जवर आय क अपनो परमेश्वर यहोवा को वचन सुनो।” ");
INSERT INTO lbm_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","अऊर यहोशू कहन लग्यो, “येकोसी तुम जान लेवो कि जीन्दो परमेश्वर तुम्हरो बीच म हय, अऊर ऊ तुम्हरो सामने सी कनानियों, हित्तियों, हिब्बियों परिज्जियों, गिर्गाशियों, एमोरियों, अऊर यबूसियों ख उन्को देश सी निकाल देयेंन। ");
INSERT INTO lbm_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","देखो, पूरी धरती पर की परमेश्वर को वाचा को सन्दूक तुम्हरो आगु आगु यरदन म जानो परच हय। ");
INSERT INTO lbm_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","येकोलायी अब तुम इस्राएल को गोत्रों म सी बारा आदमियों ख चुन लेवो, हि एक गोत्र म सी एक आदमी हो। ");
INSERT INTO lbm_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","अऊर जो समय पूरी धरती को प्रभु यहोवा की वाचा को सन्दूक उठावन वालो याजक यरदन नदी को पानी म पाय रखेंन, ऊ समय यरदन नदी को बहतो हुयो पानी रूक जायेंन, अऊर ढेर होय क ठहर जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","फसल को समय होतो नदी म बहुत बाढ़ होतो येकोलायी जब प्रजा को लोगों न अपनो तम्बुवों सी यरदन नदी पार जान लायी निकल्यो, अऊर याजक वाचा को सन्दूक उठायो हुयो प्रजा को आगु आगु चल्यो, ");
INSERT INTO lbm_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","अऊर सन्दूक ख उठावन वालो यरदन नदी पर पहुंच्यो, अऊर सन्दूक को उठावन वालो याजकों को पाय यरदन नदी को पानी म डुब गयो यरदन नदी को पानी त कटनी को समय को सब दिन अपनो तट को ऊपर ऊपर बह्यो करय हय, ");
INSERT INTO lbm_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","तब जो पानी ऊपर को तरफ सी बहत आवय हय ऊ बहुत दूर, मतलब आदाम नगर को जवर जो सारतान नगर को जवर रूक क एक ढेर भय गयो, अऊर दीवार जसो उठ्यो रह्यो, अऊर जो पानी अराबा को सागर जो मृत सागर भी कह्यो जावय हय, ओको तरफ बहत जात होतो, ऊ पूरो रीति सी सूख गयो; अऊर प्रजा को लोग यरीहो को सामने पार उतर गयो। ");
INSERT INTO lbm_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","अऊर याजक यहोवा की वाचा को सन्दूक उठायो हुयो यरदन को बीचों बीच पहुंच क जागा पर स्थिर खड़ो रह्यो, अऊर सब इस्राएली जागाच जागा पार उतरतो रह्यो, आखरी म ऊ पूरी जाति को लोग यरदन नदी पार भय गयो। ");
INSERT INTO lbm_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","जब हि पूरी जाति को लोग यरदन नदी को पार उतर गयो, तब परमेश्वर न यहोशू सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“प्रजा म सी बारा आदमी, मतलब हर एक कुल सी एक आदमियों ख चुन क या आज्ञा दे, ");
INSERT INTO lbm_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","‘अऊर तुम यरदन को बीच म, जहां याजकों न पाय रख्यो होतो वहां सी बारा गोटा उठाय क अपनो संग ओन पार ले चलो, अऊर जहां अज की रात मुक्काम करो वहांच रख देवो।’” ");
INSERT INTO lbm_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","तब यहोशू न उन बारा आदमियों ख, जिन्ख ओन इस्राएलियों को हर एक कुल म सी छांट क रख्यो होतो, ");
INSERT INTO lbm_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","बुलाय क कह्यो, “तुम अपनो परमेश्वर यहोवा को सन्दूक को आगु यरदन को बीच म जाय क इस्राएलियों को कुलों की गिनती को अनुसार एक एक गोटा उठाय क अपनो अपनो कन्धा पर रखो, ");
INSERT INTO lbm_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","जेकोसी यो उन लोगों को बीच चिन्ह ठहरे, अऊर आगु जब तुम्हरो टुरा यो पूछेंन, ‘इन गोटावों को का मतलब हय?’ ");
INSERT INTO lbm_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","तब तुम उन्ख यो उत्तर देवो, कि यरदन नदी को पानी परमेश्वर को वाचा को सन्दूक को सामने दोय भाग भय गयो होतो; कहालीकि जब ऊ यरदन नदी पार कर क् आय रह्यो होतो, तब यरदन नदी को पानी दोय भाग भय गयो होतो। येकोलायी हि गोटा इस्राएल ख हमेशा लायी याद दिलावन वालो ठहरेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","यहोशू की या आज्ञा को अनुसार इस्राएली लोगों न करयो, जसो परमेश्वर न यहोशू सी कह्यो होतो वसोच उन्न इस्राएली कुलों की गिनती को अनुसार बारा गोटा यरदन नदी को बीच म सी उठाय क; ऊ जागा पर ले गयो जहां उन्न मुक्काम करयो होतो रख दियो। ");
INSERT INTO lbm_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","अऊर यरदन नदी को बीच म, जहां याजक वाचा को सन्दूक ख उठायो हुयो अपनो पाय रख्यो होतो वहां यहोशू न बारा गोटा खड़ो करायो; हि अज भी वहां हय। ");
INSERT INTO lbm_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","जिन कामों ख करन की आज्ञा परमेश्वर न यहोशू को द्वारा इस्राएली लोगों ख दी होती, जब तक हि पूरी नहीं होय जाय तब तक वाचा को सन्दूक उठाय क लिजान वालो याजक यरदन नदी को बीच म खड़ो रह्यो, असीच आज्ञा मूसा न यहोशू ख दियो होतो। तब लोगों न फुर्ती सी नदी पार कर लियो। ");
INSERT INTO lbm_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","अऊर जब सब लोग ओन पार उतर चुक्यो, तब याजक अऊर परमेश्वर को सन्दूक भी उन्को देखतो पार भय गयो। ");
INSERT INTO lbm_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","अऊर रूबेनी, गादी, अऊर मनश्शे को अरधो कुल को लोग मूसा को कहन को अनुसार बच्यो इस्राएली लोगों को आगु हथियार बान्ध्यो हुयो पार गयो; ");
INSERT INTO lbm_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","हि चालीस हजार आदमी युद्ध को हथियार बान्ध्यो हुयो युद्ध करन लायी परमेश्वर को सामने पार उतर क यरीहो को मैदान म पहुंच्यो। ");
INSERT INTO lbm_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","ऊ दिन परमेश्वर न सब इस्राएलियों को सामने यहोशू की महिमा बढ़ायी; अऊर जसो हि मूसा को भय मानत होतो वसोच यहोशू को भी भय ओको जीवन भर मानतो रहे। ");
INSERT INTO lbm_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","तब परमेश्वर न यहोशू सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“वाचा को सन्दूक उठावन वालो याजकों ख आज्ञा दे कि यरदन म सी निकल आये।” ");
INSERT INTO lbm_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","त यहोशू न याजकों ख आज्ञा दियो, “यरदन म सी निकल आवो।” ");
INSERT INTO lbm_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","अऊर जसोच परमेश्वर की वाचा को सन्दूक उठावन वालो याजक यरदन नदी को बीच म सी निकल आयो, अऊर उन्को पाय सूखी जमीन पर पड़्यो, वसोच यरदन नदी को पानी अपनो जागा पर लौट आयो, अऊर पहले को जसो किनारा को ऊपर फिर बहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","पहिलो महिना को दसवों दिन ख प्रजा को लोगों न यरदन म सी निकल क यरीहो की पूर्व सीमा पर गिलगाल म अपनो डेरा डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","अऊर जो बारा गोटा यरदन नदी म सी निकाल्यो होतो, उन्ख यहोशू न गिलगाल म खड़ो करयो। ");
INSERT INTO lbm_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","तब ओन इस्राएली लोगों सी कह्यो, “जब भविष्य म तुम्हरो बाल-बच्चा अपनो-अपनो बाप सी यो पूछेंन, ‘हि गोटावों को का मतलब हय?’ ");
INSERT INTO lbm_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","तब तुम उन्ख यो बतावो, ‘यो यरदन ख हम इस्राएलियों न सूखी जमीन पर चल क पार करयो होतो।’ ");
INSERT INTO lbm_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","कहालीकि जसो तुम्हरो परमेश्वर यहोवा न लाल समुन्दर ख हमरो पार होय जान तक हमरो सामने सी हटाय क सुखाय दियो होतो, वसोच ओन यरदन नदी को भी पानी तुम्हरो पार होय जान तक तुम्हरो सामने सी हटाय क सुखाय दियो; ");
INSERT INTO lbm_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","येकोलायी धरती को सब देशों को लोग जान ले कि परमेश्वर को हाथ सामर्थवान हय; अऊर तुम हमेशा परमेश्वर यहोवा को भय मानतो रहो।” ");
INSERT INTO lbm_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","जब यरदन को पश्चिम को तरफ रहन वालो एमोरियों को सब राजावों न, अऊर समुन्दर को जवर रहन वालो कनानियों को सब राजावों न यो सुन्यो, कि परमेश्वर न इस्राएलियों ख पार होन तक उन्को सामने सी यरदन को पानी हटाय क सुखाय दियो हय, तब इस्राएलियों को डर को मारे उन राजावों को मन घबराय गयो, अऊर उन म हिम्मत नहीं रही। ");
INSERT INTO lbm_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","ऊ समय परमेश्वर न यहोशू सी कह्यो, “चकमक गोटा की छुरियां बनाय क दूसरी बार इस्राएली लोगों को खतना कराय दे।” ");
INSERT INTO lbm_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","तब यहोशू न चकमक गोटा की छुरियां बनाय क खतना नाम की पहाड़ी पर इस्राएली लोगों को खतना करायो। ");
INSERT INTO lbm_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","अऊर यहोशू न जो खतना करायो, येको कारण यो हय, कि जितनो लड़ाई को लायक आदमी मिस्र सी निकल्यो होतो हि सब मिस्र सी निकलन पर जंगल को रस्ता म मर गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","जो आदमी मिस्र देश सी निकल्यो होतो उन सब को त खतना भय गयो होतो, पर जितनो उन्को मिस्र देश सी निकलन को बाद जंगल को रस्ता म पैदा भयो होतो उन म सी कोयी को खतना नहीं भयो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","कहालीकि जब तक इस्राएली जाति को लोग, मतलब जितनो लोग लड़ाई को लायक मिस्र देश सी निकल्यो होतो उन्की मृत्यु नहीं भयी, तब तक हि चालीस साल तक जंगल म फिरतो रह्यो, कहालीकि उन्न परमेश्वर की नहीं मानी होती; येकोलायी परमेश्वर न कसम खाय क उन्को सी कह्यो होतो, कि जो देश मय न तुम्हरो पूर्वजों सी कसम खाय क तुम्ख देन ख कह्यो होतो, अऊर उन म दूध अऊर शहेद की धाराये बहय हय, ऊ देश मय तुम्ख नहीं दिखाऊं। ");
INSERT INTO lbm_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","त उन लोगों को टुरा जिन्ख परमेश्वर न उन्को जागा पर पैदा करयो होतो, उन्को खतना यहोशू न करयो, कहालीकि रस्ता म उन्को खतना नहीं होन को वजह हि खतनारहित होतो। ");
INSERT INTO lbm_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","अऊर जब हि पूरी जाति को लोगों को खतना भय गयो, तब हि चंगो होय जान तक अपनो अपनो जागा पर डेरा म रह्यो। ");
INSERT INTO lbm_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","तब परमेश्वर न यहोशू सी कह्यो, “तुम्हरी निन्दा जो मिस्रियों म भयी हय ओख मय न अज दूर करी हय।” यो वजह ऊ जागा को नाम अज को दिन तक गिलगाल पड़्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","येकोलायी इस्राएली गिलगाल म डेरा डाल्यो हुयो होतो, अऊर उन्न यरीहो को जवर को मैदान म महिना को चौदावों दिन शाम को समय फसह त्यौहार मनायो। ");
INSERT INTO lbm_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","अऊर फसह को दूसरो दिन हि ऊ देश को फसल म सी अखमीरी रोटी अऊर उच दिन सी भूज्यो हुयो दाना भी खान लग्यो। ");
INSERT INTO lbm_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","अऊर ऊ देश की फसल खान को बाद मन्ना गिरनो बन्द भय गयो; ऊ दिन को बाद इस्राएली लोगों ख फिर कभी मन्ना नहीं मिल्यो, पर ऊ साल उन्न कनान देश की फसल म सी खायो। ");
INSERT INTO lbm_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","जब यहोशू यरीहो को जवर होतो तब ओन आंखी ऊपर उठायी, अऊर का देख्यो, कि हाथ म नंगी तलवार लियो हुयो एक आदमी सामने खड़ो हय; अऊर यहोशू न ओको जवर जाय क पुच्छ्यो, “का तय हमरो पक्ष को आय, यां हमरो बैरियों को पक्ष को?” ");
INSERT INTO lbm_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","तब ओन उत्तर दियो, “नहीं; बल्की मय परमेश्वर की सेना को प्रधान होय क अभी आयो हय।” तब यहोशू न जमीन पर झुक क दण्डवत करयो, अऊर ओको सी कह्यो, “अपनो दास लायी मोरो प्रभु की का आज्ञा हय?” ");
INSERT INTO lbm_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","परमेश्वर की सेना को प्रधान न यहोशू सी कह्यो, “अपनी चप्पल पाय सी उतार डाल, कहालीकि जो जागा पर तय खड़ो हय ऊ पवित्र हय।” तब यहोशू न वसोच करयो। ");
INSERT INTO lbm_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","इस्राएली लोगों को वजह यरीहो नगर को फाटक बन्द कर दियो गयो होतो, कोयी भी नगर को अन्दर नहीं आय सकत होतो अऊर नहीं कोयी बाहेर जाय सकत होतो। ");
INSERT INTO lbm_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","फिर परमेश्वर न यहोशू सी कह्यो, “देख मय यरीहो नगर ख ओको राजा अऊर योद्धावों समेत तोरो वश म कर देऊ हय। ");
INSERT INTO lbm_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","येकोलायी तुम म जितनो योद्धा हय नगर ख घेर ले, अऊर ऊ नगर को चारयी तरफ दिन म एक बार चक्कर लगाये। अऊर छय दिन तक असोच करतो रहो। ");
INSERT INTO lbm_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","अऊर सात याजक मेंढा को सींगो सी बन्यो सात नरसिंगा ले क सन्दूक को आगु आगु चलेंन; फिर सातवों दिन तुम नगर को चारयी तरफ सात बार घूमो, अऊर याजक भी नरसिंगा फूकतो चलेंन। ");
INSERT INTO lbm_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","अऊर जब हि मेंढा को सींगो को नरसिंगा देर तक फूकतो रहेंन, तब सब लोग नरसिंगा को आवाज सुनतोच बड़ो आवाज सी जय जयकार करेंन; तब नगर की दीवाल नीव गिर जायेंन, अऊर सब लोग अपनी आंखी को सामने सीधो चलतो जाये।” ");
INSERT INTO lbm_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","येकोलायी नून को टुरा यहोशू न याजकों ख बुलाय क कह्यो, “वाचा को सन्दूक ख उठाय लेवो, अऊर सात याजक परमेश्वर को सन्दूक को आगु आगु मेंढा को सींगो को सात नरसिंगा ले क चलेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","फिर ओन इस्राएली लोगों सी कह्यो, “आगु बढ़ क नगर को चारयी तरफ घुम क आवो; अऊर हथियार लियो हुयो आदमी परमेश्वर को सन्दूक को आगु आगु चले।” ");
INSERT INTO lbm_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","अऊर जब यहोशू या बाते लोगों सी कह्य चुक्यो, त हि सात याजक जो परमेश्वर को सामने सात नरसिंगा लियो हुयो होतो नरसिंगा फूकतो हुयो चले, अऊर याजक परमेश्वर की वाचा को सन्दूक ख ले क उन्को पीछु पीछु चल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","अऊर हथियार लियो हुयो आदमी नरसिंगा फूकन वालो याजकों को आगु आगु चले, अऊर पीछु वालो सन्दूक को पीछु पीछु चले, अऊर याजक नरसिंगा फूकतो हुयो चले। ");
INSERT INTO lbm_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","अऊर यहोशू न लोगों ख आज्ञा दी, “जब तक मय तुम्ख जय जयकार करन की आज्ञा नहीं देऊ, तब तक जय जयकार मत करो, अऊर नहीं तुम्हरो कोयी आवाज सुनन म आये, अऊर नहीं कोयी बात तुम्हरो मुंह सी निकलनो चाहिये; जब मय तुम्ख आज्ञा देऊ तब जय जयकार करो।” ");
INSERT INTO lbm_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","ओन परमेश्वर को सन्दूक ख एक बार नगर को चारयी तरफ घुमवायो; तब हि छावनी म आयो, अऊर रात वहां बितायी। ");
INSERT INTO lbm_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","यहोशू सुबेरे उठ्यो, अऊर याजकों न परमेश्वर को सन्दूक उठाय लियो। ");
INSERT INTO lbm_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","अऊर उन सात याजकों न मेंढा को सींगो को सात नरसिंगा ले क परमेश्वर को सन्दूक को आगु आगु लगातार फूकतो हुयो चल रह्यो होतो; अऊर उन को आगु हथियार लियो हुयो आदमी चल रह्यो होतो, अऊर पीछु वालो परमेश्वर को सन्दूक को पीछु चल रह्यो होतो, अऊर याजक नरसिंगा फूकतो चली गयो। ");
INSERT INTO lbm_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","यो तरह हि दूसरो दिन भी एक बार नगर को चारयी तरफ घुम क छावनी म लौट आयो। अऊर योच तरह उन्न छय दिन तक करयो। ");
INSERT INTO lbm_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","फिर सातवों दिन भुन्सारो ख उठ क उच रीति सी नगर ख चारयी तरफ सात बार घुम्यो; केवल उच दिन हि सात बार घुम्यो। ");
INSERT INTO lbm_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","तब सातवों बार याजक नरसिंगा फूक रह्यो होतो, तब यहोशू न लोगों सी कह्यो, “जय जयकार करो; कहालीकि परमेश्वर न यो नगर तुम्ख दे दियो हय। ");
INSERT INTO lbm_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","अऊर नगर अऊर जो कुछ चिज ओको म हय परमेश्वर ख बलि को रूप म अर्पन कर क् पूरो तरह सी नाश कर दियो जायेंन; केवल राहब वेश्या अऊर जितनो ओको घर म होतो हि जीन्दो छोड़्यो जायेंन, कहालीकि ओन हमरो भेज्यो हुयो दूतों ख लूकाय क रख्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","अऊर तुम नाशवान चिजों सी सावधानी सी अपनो आप ख अलग रखो, असो नहीं होय की नाश होन वाली की चिज ठहराय क बाद म वाच नाश होन वाली चिज म सी कुछ ले लेवो, अऊर यो तरह इस्राएली छावनी ख भ्रष्ट कर क् ओख संकट म डाल देवो। ");
INSERT INTO lbm_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","सब चांदी, सोना, अऊर जो बर्तन पीतल अऊर लोहा को हय, हि परमेश्वर लायी पवित्र हय, अऊर ओकोच भण्डार म रख्यो जाय।” ");
INSERT INTO lbm_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","तब लोगों न जय जयकार करयो, अऊर याजक नरसिंगा फूकतो रह्यो। अऊर जब लोगों न नरसिंगा को आवाज सुन्यो त फिर बड़ी आवाज सी उन्न जय जयकार करयो, तब नगर की दीवाल गिर गयी, अऊर लोग सीधो ऊ नगर म घुस गयो, अऊर नगर पर अधिकार कर लियो। ");
INSERT INTO lbm_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","ओको बाद उन्न नगर को सब बाई, आदमी, जवान, बुजूर्ग, बईल, मेंढी अऊर गधा ख अर्पन की चिज जान क तलवार सी मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","तब यहोशू न उन दोयी आदमियों सी जो ऊ देश म भेद लेन गयो होतो कह्यो, “अपनी कसम को अनुसार वा वेश्या को घर म जाय क ओख अऊर जो ओको घर म होना उन्ख भी निकाल लावो।” ");
INSERT INTO lbm_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","तब हि दोयी जवान भेदी अन्दर जाय क राहब ख, अऊर ओको माय-बाप, भाऊवों, अऊर सब ख जो ओको घर म रहत होतो, बल्की ओको सब कुटुम्बियों ख निकाल लायो, अऊर इस्राएल की छावनी को बाहेर बैठाय दियो। ");
INSERT INTO lbm_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","तब उन्न नगर ख अऊर जो कुछ ओको म होतो, सब ख आगी लगाय क जलाय दियो; केवल चांदी, सोना, अऊर जो बर्तन पीतल अऊर लोहा को होतो, उन्ख उन्न परमेश्वर को भवन को भण्डार म रख दियो। ");
INSERT INTO lbm_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","अऊर यहोशू न राहब वेश्या अऊर ओको बाप को घराना ख, बल्की ओको सब लोगों ख जीन्दो छोड़ दियो; अऊर अज तक ओको वंश इस्राएलियों को बीच म रह्य हय, कहालीकि जो दूत यहोशू न यरीहो नगर को भेद लेन भेज्यो होतो उन्ख ओन लूकाय क रख्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","फिर उच समय यहोशू न इस्राएलियों को सामने कसम दी, अऊर कह्यो, “जो आदमी उठ क यो नगर यरीहो ख फिर सी बनायेंन ऊ परमेश्वर को तरफ सी श्रापित होयेंन। “जब ऊ ओको पायवा डालेंन तब ओको बड़ो टुरा मरेंन; अऊर जब ऊ ओको फाटक लगायेंन तब ओको छोटो टुरा मर जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","अऊर परमेश्वर यहोशू को संग रह्यो; अऊर यहोशू की कीर्ति ऊ पूरो देश म फैल गयी। ");
INSERT INTO lbm_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","पर इस्राएलियों न भेंट की चिज को बारे म विश्वासघात करयो; मतलब यहूदा वंश को आकान, जो जेरहवंशी जब्दी को नाती अऊर कर्मी को टुरा होतो, ओन भेंट की चिजों म सी कुछ ले लियो; यो कारन परमेश्वर को कोप इस्राएलियों पर भड़क उठ्यो। ");
INSERT INTO lbm_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","यहोशू न यरीहो सी ऐ नाम को नगर को जवर, जो बेतावेन सी लग्यो हुयो बेतेल को पूर्व को तरफ हय, कुछ आदमियों ख यो कह्य क भेज्यो, “जाय क ऊ देश को भेद ले क आवो।” अऊर उन आदमियों न जाय क ऐ नगर को भेद लियो। ");
INSERT INTO lbm_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","अऊर उन्न यहोशू को जवर लौट क कह्यो, “सब लोगों ख वहां जान की जरूरत नहाय, केवल दोय यां तीन हजार लोग जाय क ऐ नगर ख जीत सकय हय; सब लोगों ख वहां जान लायी तकलीफ देन की जरूरत नहाय, कहालीकि हि लोग थोड़ोच हंय।” ");
INSERT INTO lbm_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","येकोलायी इस्राएलियों को लगभग तीन हजार आदमी वहां गयो; पर उन्ख ऐ नगर को निवासियों को सामने सी भगनो पड़्यो, ");
INSERT INTO lbm_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","तब ऐ नगर को रहन वालो न उन म सी छत्तीस आदमी ख मार डाल्यो, अऊर अपनी फाटक सी शबारीम तक उन्को पीछा कर क् खदानों तक उन्ख मारतो गयो। तब लोगों को मन पिघल क थंडो पड़ गयो। ");
INSERT INTO lbm_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","तब यहोशू न पराजय को दु:ख प्रगट करन लायी अपनो कपड़ा फाड़्यो, ऊ शाम होन तक परमेश्वर की सन्दूक को सामने जमीन पर मुंह को बल गिर क पड़्यो रह्यो; असोच इस्राएली बुजूर्गों न भी करयो अऊर उन्न दु:ख प्रगट करन लायी अपनो मुंड पर धूल डाली। ");
INSERT INTO lbm_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","अऊर यहोशू न कह्यो, “हाय, प्रभु परमेश्वर, तय अपनी या प्रजा ख यरदन नदी को येन पार कहाली लायो? का हम्ख एमोरियों को वश म कर क् नाश करन लायी लायो हय? भलो होतो कि हम सन्तुष्ट कर क् यरदन नदी को ओन पार रह्य जातो! ");
INSERT INTO lbm_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","हाय, प्रभु मय का कहूं, जब इस्राएलियों न अपनो दुस्मनों ख पीठ दिखायी हय! ");
INSERT INTO lbm_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","कहालीकि कनानी जाति बल्की यो देश को सब रहन वालो यो सुन क हम्ख घेर लेयेंन, अऊर हमरो नाम निशान कर क् धरती पर सी मिटाय डालेंन; फिर तय अपनो बड़ो नाम को लायी का करजो?” ");
INSERT INTO lbm_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","परमेश्वर न यहोशू सी कह्यो, “उठ, खड़ो होय जा, तय कहाली यो तरह मुंह को बल जमीन पर पड़्यो हय? ");
INSERT INTO lbm_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","इस्राएलियों न पाप करयो हय; अऊर जो वाचा मय न उन सी अपनो संग बान्धी होती ओख उन्न तोड़ दियो हय, उन्न भेंट की चिजों म सी ले लियो, बल्की चोरी भी करी अऊर छल कर क् ओख अपनो सामान म रख दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","येकोलायी इस्राएली अपनो दुस्मनों को सामने खड़ो नहीं रह्य सकय; हि अपनो दुस्मनों ख पीठ दिखावय हय, येकोलायी हि खुद भेंट की चिज बन गयो हय। अऊर यदि तुम अपनो बीच म सी भेंट की चिज को सत्यानाश नहीं कर डालो, तब तक मय तोरो संग नहीं रहूं। ");
INSERT INTO lbm_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","उठ, प्रजा को लोगों ख पवित्र कर, उन्को सी कह्य, सुबेरे तक अपनो आप ख पवित्र कर क् रखो; कहालीकि इस्राएल को परमेश्वर यहोवा यो कह्य हय, “हे इस्राएल, तोरो बीच म भेंट की चिज हय; येकोलायी जब तक तय भेंट की चिज ख अपनो बीच म सी दूर नहीं करय तब तक तय अपनो दुस्मनों को सामने खड़ो नहीं रह सकजो।” ");
INSERT INTO lbm_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","येकोलायी सुबेरे तुम हर एक कुल को अनुसार जवर खड़ो करयो जावो; अऊर जो कुल ख परमेश्वर पकड़ेंन हि एक एक कुल कर क् जवर आये; अऊर जो कुल ख परमेश्वर पकड़ेंन ऊ परिवार एक एक परिवार कर क् जवर आये; फिर जो परिवार ख परमेश्वर पकड़ेंन हि एक एक आदमी कर क् जवर आये। ");
INSERT INTO lbm_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","तब जो आदमी भेंट की चिज रख्यो हुयो पकड़्यो जायेंन, ऊ अऊर जो कुछ ओको होना सब आगी म डाल क जलाय दियो जायेंन; कहालीकि ओन परमेश्वर की वाचा ख तोड़्यो हय, अऊर इस्राएल म अनुचित काम करयो हय। ");
INSERT INTO lbm_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","यहोशू सुबेरे उठ क इस्राएलियों ख कुल कुल कर क् जवर लायो, अऊर यहूदा को कुल पकड़्यो गयो; ");
INSERT INTO lbm_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","तब ओन यहूदा को परिवार ख जवर लायो, अऊर जेरहवंशियों को कुल पकड़्यो गयो; फिर जेरहवंशियों को परिवारों को एक एक आदमी ख जवर लायो, अऊर जब्दी पकड़्यो गयो; ");
INSERT INTO lbm_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","तब ओन ओको परिवारों को एक एक आदमी ख जवर खड़ो करयो, अऊर यहूदा कुल को आकान, जो जेरहवंशी जब्दी को नाती अऊर कर्मी को टुरा होतो, पकड़्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","तब यहोशू आकान सी कहन लग्यो, “हे मोरो बेटा, इस्राएल को परमेश्वर यहोवा को आदर कर, अऊर ओको आगु कबूल कर; अऊर जो कुछ तय न करयो हय ऊ मोख बताय दे, अऊर मोरो सी कुछ मत छुपाय।” ");
INSERT INTO lbm_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","आकान न यहोशू ख उत्तर दियो, “सचमुच मय न इस्राएल को परमेश्वर यहोवा को खिलाफ पाप करयो हय, अऊर यो तरह मय न करयो हय, ");
INSERT INTO lbm_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","कि जब मोख लूट म शिनार देश को एक सुन्दर अंगरखा, अऊर दोय किलो चांदी, अऊर अरधो किलो सोनो को एक ईटा देख्यो होतो, तब मय न उन्को लालच कर क् उन्ख रख लियो; हि मोरो डेरा को अन्दर जमीन म गड़्यो हय, अऊर सब को खल्लो चांदी हय।” ");
INSERT INTO lbm_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","तब यहोशू न कुछ दूत भेज्यो, अऊर हि ऊ डेरा म दौड़ क गयो; अऊर का देख्यो कि हि चिजे ओको डेरा म गड़्यो हय, अऊर सब को खल्लो चांदी हय। ");
INSERT INTO lbm_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","उन्ख उन्न डेरा म सी निकाल क यहोशू अऊर सब इस्राएलियों को जवर लाय क परमेश्वर को सामने रख दियो। ");
INSERT INTO lbm_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","तब सब इस्राएलियों समेत यहोशू जेरहवंशी आकान ख, अऊर वा चांदी अऊर अंगरखा अऊर सोनो की ईटा ख, अऊर ओको बेटा बेटियां ख, अऊर ओको बईलों, गधा अऊर मेंढियों को झुण्ड ख, अऊर ओको डेरा ख, मतलब जो कुछ ओको होतो उन सब ख आकोर नाम की घाटी म ले गयो। ");
INSERT INTO lbm_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","तब यहोशू न आकान सी कह्यो, “तय न हम्ख कहाली तकलीफ दियो हय? अज को दिन परमेश्वर तोखच तकलीफ देयेंन।” तब सब इस्राएलियों न ओको पर पथराव कर क् मार डाल्यो; अऊर उन्ख आगी म डाल क जलायो, अऊर उन्को ऊपर गोटा डाल दियो। ");
INSERT INTO lbm_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","अऊर उन्न ओको ऊपर गोटा को बड़ो ढेर लगाय दियो जो अज भी वहां हय; तब परमेश्वर को भड़क्यो हुयो कोप शान्त भय गयो। यो तरह ऊ जागा को नाम अज तक आकोर की घाटी पड़्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","तब परमेश्वर न यहोशू सी कह्यो, “मत डर, निराश मत हो; उठ कमर बान्ध क सब योद्धावों ख संग म ले, अऊर ऐ नगर पर चढ़ायी कर; सुन, मय न ऐ नगर को राजा ख ओकी प्रजा अऊर ओको नगर अऊर जमीन समेत तोरो अधिकार म सौंप दियो हय। ");
INSERT INTO lbm_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","अऊर जसो तय न यरीहो अऊर ओको राजा को संग करयो वसोच ऐ नगर को राजा को संग भी करजो; केवल ऐ नगर को जनावरों अऊर सब सामान ख अपनो लायी लूट सको; येकोलायी ऐ नगर को पीछु को तरफ अपनो लोग आक्रमन करन लायी बिठाय देजो।” ");
INSERT INTO lbm_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","यहोशू न सब सैनिकों समेत ऐ नगर पर चढ़ायी करन की तैयारी करी; अऊर यहोशू न तीस हजार शूरवीर सैनिक चुन क रात मच भेज दियो। ");
INSERT INTO lbm_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","अऊर उन्ख या आज्ञा दी, “सुनो, तुम ऊ नगर को पीछु को तरफ आक्रमन करन लायी बैठ्यो रहो; नगर सी बहुत दूर मत जावो, अऊर सब को सब तैयार रहो; ");
INSERT INTO lbm_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","अऊर मय अपनो सब संगियों समेत ऊ नगर को जवर जाऊं। अऊर जब हि पहले जसो हमरो सामना करन लायी निकलेंन, तब हम उन्को आगु सी भगबोंन; ");
INSERT INTO lbm_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","तब हि यो सोच क, कि हि पहले को जसो हमरो सामने सी भाग रह्यो हय, हमरो पीछा करेंन; यो तरह हम उन्को सामने सी भाग क उन्ख नगर सी दूर निकाल ले जायबो; ");
INSERT INTO lbm_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","तब तुम अपनो लूकन की जागा सी निकलजो अऊर नगर पर अधिकार कर लेजो; कहालीकि तुम्हरो परमेश्वर यहोवा ऊ नगर ख तुम्हरो अधिकार म कर देयेंन। ");
INSERT INTO lbm_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","अऊर जब तुम नगर ख अपनो अधिकार म कर लेवो तब ओको म आगी लगाय क फूक देजो, परमेश्वर की आज्ञा को अनुसारच काम करो; सुनो, मय न तुम्ख आज्ञा दी हय।” ");
INSERT INTO lbm_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","तब यहोशू न उन्ख भेज दियो; हि लूकन की जागा पर चली गयो, हि ऐ नगर को पश्चिम दिशा म अऊर बेतेल को बीच म लूक क बैठ गयो; पर यहोशू वा रात ख अपनो लोगों को बीच टिक्यो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","यहोशू सुबेरे उठ्यो, अऊर लोगों की गिनती ले क इस्राएली बुजूर्ग लोगों समेत सैनिकों को आगु आगु ऐ नगर को तरफ गयो। ");
INSERT INTO lbm_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","अऊर ओको संग को सब सैनिक आगु बड़्यो, अऊर ऐ नगर को जवर पहुंच क ओको सामने उत्तर को तरफ डेरा डाल दियो, अऊर उन्को अऊर ऐ नगर को बीच म एक घाटी होती। ");
INSERT INTO lbm_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","तब यहोशू न लगभग पाच हजार आदमी चुन क बेतेल अऊर ऐ नगर को बीच म नगर को पश्चिम को तरफ लूकाय क बैठाय दियो। ");
INSERT INTO lbm_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","अऊर सब लोगों न नगर को उत्तर दिशा को तरफ की पूरी सेना ख अऊर पश्चिम दिशा को तरफ घात म लूक क बैठ्यो हुयो ख भी अपनो अपनो डेरा म कर दियो, तब यहोशू वाच रात घाटी म रह्यो। ");
INSERT INTO lbm_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","जब ऐ नगर को राजा न यो देख्यो, तब हि फुर्ती कर क् सुबेरे उठ्यो, अऊर राजा अपनी पूरी प्रजा ख ले क इस्राएलियों को सामने उन्को सी लड़न लायी यरदन की घाटी को तरफ गयो; अऊर ऊ नहीं जानत होतो कि नगर को पीछु को भाग म लोग घात लगायो बैठ्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","तब यहोशू अऊर सब इस्राएली लोग उन्को सी हार मान क जंगल को रस्ता ले क भाग निकल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","तब नगर को सब लोग इस्राएलियों को पीछा करन लायी बुलायो गयो; अऊर हि यहोशू को पीछा करतो हुयो नगर सी दूर निकल गयो। ");
INSERT INTO lbm_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","अऊर नहीं ऐ नगर म अऊर नहीं बेतेल म एक भी आदमी नहीं रह्यो, जो इस्राएलियों को पीछा करन लायी नहीं गयो होना; अऊर उन्न नगर ख खुलो छोड़ क इस्राएलियों को पीछा करयो। ");
INSERT INTO lbm_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","तब परमेश्वर न यहोशू सी कह्यो, “अपनो हाथ को भाला सी ऐ नगर को तरफ इशारा कर; कहालीकि मय ओख तोरो हाथ म दे देऊं।” अऊर यहोशू न अपनो हाथ को भाला सी ऐ नगर को तरफ इशारा करयो। ");
INSERT INTO lbm_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","जसोच यहोशू न अपनो हाथ ऊपर उठायो लूक क बैठ्यो हुयो सैनिक तुरतच अपनो जागा सी उठ्यो, अऊर दौड़ क नगर म सिरयो अऊर ओख अपनो अधिकार म कर लियो; अऊर तुरतच ओको म आगी लगाय दियो। ");
INSERT INTO lbm_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","जब ऐ नगर को लोगों न पीछु पलट क देख्यो, कि नगर को धूगां आसमान को तरफ उठ रह्यो हय; उन्ख आगु-पीछु भगन को मौका भी नहीं मिल्यो, कहालीकि जंगल को तरफ भगन वालो इस्राएलियों न लौट क अपनो पीछा करन वालो पर आक्रमन कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","जब यहोशू अऊर सब इस्राएलियों न देख्यो कि घातियों न नगर पर अधिकार कर लियो हय, अऊर ओको धूगां उठ रह्यो हय, तब घुम क ऐ नगर को आदमियों ख मारन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","अऊर उन्को सामना करन लायी दूसरो नगर सी भी लोग निकल आयो; येकोलायी हि इस्राएलियों को बीच म पड़ गयो, कुछ इस्राएली त उन्को आगु, अऊर कुछ उन्को पीछु होतो; उन्न उन्ख यहां तक मारयो कि उन म सी नहीं त कोयी बच्यो अऊर नहीं भग सक्यो। ");
INSERT INTO lbm_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","अऊर ऐ नगर को राजा ख हि जीन्दो पकड़ क यहोशू को जवर लायो। ");
INSERT INTO lbm_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","जब इस्राएली ऐ नगर को सब निवासियों ख मैदान म, मतलब ऊ जंगल म जहां उन्न उन्को पीछा करयो होतो मार डाल्यो, जब ऐ नगर को हर एक निवासी तलवार सी मारयो गयो, तब सब इस्राएलियों न ऐ नगर ख लौट क बच्यो हुयो निवासियों ख तलवार सी मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ऊ ऐ नगर कि जनसंख्या बारा हजार होती, ऊ दिन बाई अऊर आदमी सब मारयो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","जो हाथ सी यहोशू भाला उठायो हुयो होतो, ओख तब तक ओन खल्लो नहीं करयो जब तक ऐ नगर को निवासियों ख पूरी तरह नाश नहीं कर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","परमेश्वर की वा आज्ञा को अनुसार जो ओन यहोशू ख दी होती इस्राएलियों न पशु अऊर नगर को सब सामान अपनो लायी लूट लियो। ");
INSERT INTO lbm_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","तब यहोशू न ऐ नगर म आगी लगाय दियो, अऊर ओख हमेशा लायी खंडहर बनाय दियो : ऊ अज तक उजाड़ पड़्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","अऊर ऐ नगर को राजा ख ओन शाम तक झाड़ पर लटकाय दियो; अऊर सूर्य डुबतो समय यहोशू की आज्ञा सी ओको शव झाड़ पर सी उतार क नगर की फाटक को सामने डाल दियो गयो, अऊर ओको पर गोटावों को बड़ो ढेर लगाय दियो, जो अज तक बन्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","तब यहोशू न इस्राएल को परमेश्वर यहोवा को लायी एबाल पहाड़ी पर एक वेदी बनवायी, ");
INSERT INTO lbm_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","जसो परमेश्वर को सेवक मूसा न इस्राएलियों ख आज्ञा दी होती, अऊर जसी मूसा की व्यवस्था की किताब म लिख्यो हय, ओन असो गोटावों ख ले क एक वेदी बनायी जेको पर कोयी भी तरह को अवजार को उपयोग नहीं करयो गयो होतो। अऊर ओको पर उन्न परमेश्वर लायी होमबलि अऊर मेलबलि चढ़ायो। ");
INSERT INTO lbm_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","उच जागा पर यहोशू न इस्राएलियों को सामने उन गोटावों को ऊपर मूसा की व्यवस्था, जो ओन लिखी होती, ओकी नकल करायी। ");
INSERT INTO lbm_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","अऊर हि देशी परदेशी, पूरो इस्राएली अपनो बुजूर्ग लोगों, सरदारों, अऊर न्यायियों समेत परमेश्वर को वाचा को सन्दूक उठावन वालो लेवी याजकों को सामने इत उत खड़ो भयो, मतलब अरधो लोग गिरिज्जीम पहाड़ी को, अऊर अरधो लोग एबाल पहाड़ी को सामने खड़ो भयो, जसो कि परमेश्वर को दास मूसा न पहले सी आज्ञा दी होती कि इस्राएली प्रजा ख आशीर्वाद दियो जाये। ");
INSERT INTO lbm_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ओको बाद यहोशू न आशीष अऊर श्राप की व्यवस्था को पूरो वचन, जसो व्यवस्था की किताब म लिख्यो हय वसोच पढ़ क सुनाय दियो। ");
INSERT INTO lbm_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","जितनी बातों की मूसा न आज्ञा दी होती, उन म सी कोयी असी बात नहीं रही जो यहोशू न इस्राएल की पूरी सभा, अऊर बाईयों, अऊर बाल-बच्चां, अऊर उन्को संग रहन वालो परदेशी लोगों को सामने भी पढ़ क नहीं सुनायी गयी होना। ");
INSERT INTO lbm_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","यो सुन क हित्ती, एमोरी, कनानी, परिज्जी, हिब्बी, अऊर यबूसी, जितनो राजा यरदन को येन पार पहाड़ी देश म अऊर खल्लो को देश म, अऊर लबानोन को सामने महासागर को किनार पर रहत होतो, ");
INSERT INTO lbm_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","हि एक मन होय क यहोशू अऊर इस्राएलियों सी लड़न लायी जमा भयो। ");
INSERT INTO lbm_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","जब गिबोन को निवासियों न ऊ सब सुन्यो कि जो यहोशू न यरीहो अऊर ऐ नगर को संग का का करयो हय, ");
INSERT INTO lbm_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","उन्न भी चालाकी करी, अपनी यात्रा राजदूतों को रूप म शुरू करी, उन्न अपनो गधा पर फट्यो पुरानो बोरा, अऊर पुरानी फटी जोड़ लगी हुयी अंगूरीरस की कुप्पी बान्ध लियो ");
INSERT INTO lbm_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","अऊर अपनो पाय म पुरानी चप्पल, अऊर पुरानो कपड़ा पहिन्यो, अऊर अपनो जेवन लायी बुर्सी लगी हुयी सूखी रोटी ले ली। ");
INSERT INTO lbm_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","तब हि गिलगाल की छावनी म यहोशू को जवर जाय क ओको सी अऊर इस्राएली लोगों सी कहन लग्यो, “हम दूर देश सी आयो हय; येकोलायी अब तुम हम सी वाचा बान्धो।” ");
INSERT INTO lbm_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","इस्राएली लोगों न उन हिब्बियों सी कह्यो, “होय सकय हय कि तुम हमरो बीच म रहत होना; फिर हम तुम सी वाचा कसो बान्धबो?” ");
INSERT INTO lbm_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","उन्न यहोशू सी कह्यो, “हम तोरो दास आय।” तब यहोशू न उन्को सी कह्यो, “तुम कौन आय? अऊर कहां सी आयो हय?” ");
INSERT INTO lbm_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","तब उन्न ओको सी कह्यो, “हम तोरो दास तोरो परमेश्वर यहोवा को नाम सुन क बहुत दूर देश सी आयो हय; जो कार्य ओन मिस्र देश म करयो हय, ओको बारे म हम न सुन्यो हय, ");
INSERT INTO lbm_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","अऊर जो कुछ ओन एमोरियों को दोयी राजावों को संग करयो जो यरदन को ओन पार पूर्व दिशा म रहत होतो, हेशबोन को राजा सीहोन, अऊर बाशान को राजा ओग जो अश्तारोत म होतो। ");
INSERT INTO lbm_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","येकोलायी हमरो यहां को बुजूर्ग लोगों न अऊर हमरो देश को निवासियों न हम सी कह्यो, कि रस्ता लायी अपनो संग भोजन को सामान ले क उन्को सी मिलन जावो, अऊर उन्को सी कहो, कि हम तुम्हरो दास आय; येकोलायी अब तुम हम सी वादा करो। ");
INSERT INTO lbm_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","जो दिन हम तुम्हरो जवर आवन लायी निकल्यो ऊ दिन त हम न अपनो अपनो घर सी या रोटी गरम अऊर ताजी धरी होती; पर अब देखो, या रोटी सुख गयी हय अऊर येको म बुर्सी लग गयी हय। ");
INSERT INTO lbm_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","फिर या जो अंगूरीरस कि कुप्पी हम न भर लियो होतो, तब त नयी होती, पर देखो अब हि फट गयी हय; अऊर हमरो यो कपड़ा अऊर चप्पल बड़ी लम्बी यात्रा को वजह पुरानी भय गयी हय।” ");
INSERT INTO lbm_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","तब उन इस्राएल को लोगों न परमेश्वर सी बिना पुच्छ्यो उन्को जेवन म सी कुछ स्विकार करयो। ");
INSERT INTO lbm_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","तब यहोशू न उन्को संग मेल कर क् उन्को सी वाचा बान्धी कि तुम्ख जीन्दो छोड़बो; अऊर मण्डली को मुखियावों न उन सी कसम खायी। ");
INSERT INTO lbm_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","उन्को संग वाचा बान्धन को तीन दिन बाद उन्ख यो सन्देश मिल्यो, कि हि हमरो पड़ोस को रहन वालो लोग आय, अऊर हमरोच बीच म बस्यो हंय। ");
INSERT INTO lbm_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","तब इस्राएली लोग निकल क तीसरो दिन उन्को नगरों ख गिबोन, कपीरा, बेरोत, अऊर किर्यत्यारीम म पहुंच गयो, ");
INSERT INTO lbm_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","पर इस्राएलियों न उन्ख नहीं मारयो, कहालीकि मण्डली को मुखियावों न उन्को संग इस्राएल को परमेश्वर यहोवा की कसम खायी होती। तब पूरी मण्डली को लोग मुखियावों को खिलाफ कुड़कुड़ावन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","तब सब मुखियावों न पूरी मण्डली को लोगों सी कह्यो, “हम न उन सी इस्राएल को परमेश्वर यहोवा की कसम खायी हय, येकोलायी अब हम उन्ख छुय नहीं सकजे। ");
INSERT INTO lbm_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","हम उन सी योच काम करबो कि वा कसम को अनुसार हम उन्ख जीन्दो छोड़ देबो, नहीं त हमरी खायी हुयी कसम को वजह हम पर परमेश्वर को गुस्सा भड़क उठेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","फिर मुखियावों न उन्को सी कह्यो, “हि जीन्दो छोड़्यो जाय।” पर मुखियावों को यो वचन को अनुसार हि पूरी मण्डली लायी लकड़ी काटेंन अऊर पानी भरेंन। ");
INSERT INTO lbm_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","फिर यहोशू न गिबोन नगर को निवासियों ख बुलाय क कह्यो, “तुम त हमरो बीच म रह्य हय, फिर तुम न हम्ख धोखा कहाली दियो हय, कि हम तुम सी बहुत दूर रहजे हय? ");
INSERT INTO lbm_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","येकोलायी अब तुम श्रापित हय, अऊर तुम म सी हर कोयी परमेश्वर को दास, अऊर मोरो परमेश्वर को भवन लायी लकड़ी काटन वालो अऊर पानी भरन वालो बनेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","उन्न यहोशू ख उत्तर दियो, “तोरो दासों ख यो जरूरच बतायो गयो होतो, कि तोरो परमेश्वर यहोवा न अपनो दास मूसा ख आज्ञा दी होती कि तुम्ख ऊ पूरो देश दे, अऊर ओको पूरो निवासियों को तुम्हरो सामने सी सर्वनाश करे; येकोलायी हम लोगों ख तुम्हरो वजह हम्ख अपनो जीव को डर लग्यो, येकोलायी हम न असो काम करयो। ");
INSERT INTO lbm_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","अऊर अब हम तोरो अधिकार म हय, जसो काम तोख अच्छो लगय हय, वसोच व्यवहार हमरो संग कर।” ");
INSERT INTO lbm_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","तब यहोशू न उन्को सी वसोच करयो, अऊर उन्ख इस्राएलियों को हाथ सी असो बचायो, कि हि उन्ख मार नहीं सके। ");
INSERT INTO lbm_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","पर यहोशू न उच दिन गिबोन को लोगों ख इस्राएल की मण्डली लायी, अऊर जो जागा परमेश्वर चुन लेयेंन ओको म ओकी वेदी लायी, लकड़ी काटन वालो अऊर पानी भरन वालो चुन लियो, वहां हि अज तक हय। ");
INSERT INTO lbm_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","जब यरूशलेम को राजा अदोनीसेदक न सुन्यो कि यहोशू न ऐ नगर ख जीत लियो, अऊर ओको सत्यानाश कर डाल्यो हय, अऊर जसो ओन यरीहो नगर अऊर ओको राजा को संग करयो वसोच ऐ नगर अऊर ओको राजा को संग भी करयो हय, अऊर यो भी सुन्यो कि गिबोन को निवासियों न इस्राएलियों सी मेल करयो, अऊर उन्को बीच म रहन लग्यो हंय, ");
INSERT INTO lbm_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","तब हि बहुत डर गयो, कहालीकि गिबोन बड़ो नगर बल्की राजधानी को समान अऊर ऐ नगर सी बड़ो होतो, अऊर ओको सब निवासी शूरवीर होतो। ");
INSERT INTO lbm_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","येकोलायी यरूशलेम को राजा अदोनीसेदक न हेब्रोन को राजा होहाम, यर्मूत को राजा पिराम, लाकीश को राजा यापी, अऊर एग्लोन को राजा दबीर को जवर यो सन्देश भेज्यो : ");
INSERT INTO lbm_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“मोरो जवर आय क गिबोन नगर ख हरावन म मोरी मदत करो; कहालीकि ओन यहोशू अऊर इस्राएलियों सी मेल कर लियो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","येकोलायी यरूशलेम, हेब्रोन, यर्मूत, लाकीश, अऊर एग्लोन को पाचयी एमोरी राजावों न अपनी अपनी पूरी सेना जमा कर क् चढ़ायी कर दी, अऊर गिबोन नगर को सामने डेरा डाल क ओको सी युद्ध छेड़ दियो। ");
INSERT INTO lbm_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","तब गिबोन नगर को निवासियों न गिलगाल की छावनी म यहोशू को जवर यो सन्देश भेज्यो, “अपनो दासों को मुंड पर सी अपनो हाथ मत हटावों; तुरतच हमरो जवर आय क हम्ख बचाय ले, अऊर हमरी मदत कर; कहालीकि पहाड़ी पर रहन वालो एमोरी जाति को राजा हमरो खिलाफ जमा भयो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","तब यहोशू पूरी सेना अऊर शक्तिशाली योद्धावों ख संग ले क गिलगाल सी निकल गयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","अऊर परमेश्वर न यहोशू सी कह्यो, “उन्को सी मत डर, कहालीकि मय न उन्ख तोरो हाथ म सौप दियो हय; उन म सी एक भी आदमी तोरो सामने खड़ो नहीं रह्य सकेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","तब यहोशू रातोंरात गिलगाल सी जाय क एकाएक उन पर हमला कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","तब परमेश्वर न असो करयो कि हि इस्राएलियों सी घबराय गयो, अऊर इस्राएलियों न गिबोन नगर म उन्ख बुरी तरह मारयो, अऊर बेथोरोन को चढ़ाव पर उन्को पीछा कर क् अजेका अऊर मक्केदा नगर तक उन्ख मारतो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","फिर जब एमोरी इस्राएलियों को सामने सी भग क बेथोरोन को उतार पर आयो, तब अजेका पहुंचन तक परमेश्वर न आसमान सी बड़ी बड़ी गारगोटी उन पर बरसायी, अऊर हि मर गयो; जो गारगोटी सी मर गयो होतो उन्की गिनती इस्राएलियों की तलवार सी मारयो हुयो सी जादा होती। ");
INSERT INTO lbm_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","ऊ समय, मतलब जो दिन परमेश्वर न एमोरियों ख इस्राएलियों को हाथ म सौंप दियो, ऊ दिन यहोशू न परमेश्वर सी इस्राएलियों को देखतो यो तरह कह्यो, “हे सूर्य, तय गिबोन पर, अऊर हे चन्दा, तय अय्यालोन की घाटी को ऊपर रुक्यो रह्य।” ");
INSERT INTO lbm_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","अऊर सूर्य ऊ समय तक रुक्यो रह्यो, अऊर चन्दा ऊ समय तक हट्यो नहीं, जब तक ऊ जाति को लोगों न अपनो दुस्मनो सी बदला नहीं लियो। का या बात याशार की किताब म नहीं लिखी हय कि सूर्य आसमान को बीचोंबीच रुक्यो रह्यो, अऊर लगभग पूरो दिन नहीं डुब्यो? ");
INSERT INTO lbm_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","नहीं त ओको सी पहले असो दिन भयो अऊर नहीं ओको बाद, जेको म परमेश्वर न कोयी आदमी की सुनी होना; कहालीकि परमेश्वर त इस्राएल को तरफ सी लड़त होतो। ");
INSERT INTO lbm_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","तब यहोशू पूरो इस्राएलियों समेत गिलगाल की छावनी ख लौट गयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","हि पाचयी राजा भग क मक्केदा को जवर की गुफा म लूक गयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","तब यहोशू ख यो सन्देश मिल्यो, “पाचयी राजा मक्केदा को जवर की गुफा म लूक्यो हुयो हम्ख मिल्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","यहोशू न कह्यो, “गुफा को दरवाजा पर बड़ो बड़ो गोटा लुढ़काय क उन पर पहरा देन लायी कुछ आदमियों ख बैठाय देवो; ");
INSERT INTO lbm_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","पर तुम मत ठहरो, अपनो दुस्मनों को पीछा कर क् उन म सी जो जो पीछु रह्य गयो हय उन्ख मार डालो, उन्ख अपनो अपनो नगर म सिरन को अवसर मत देवो; कहालीकि तुम्हरो परमेश्वर यहोवा न उन्ख तुम्हरो हाथ म सौप दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","जब यहोशू अऊर इस्राएली सैनिकों न दुस्मनों ख मार डाल्यो, अऊर उन म सी जो बच गयो हि गढ़ वालो नगर म घुस गयो, ");
INSERT INTO lbm_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","तब सब लोग मक्केदा की छावनी म यहोशू को जवर सुरक्षित लौट आयो; अऊर इस्राएलियों को खिलाफ कोयी न मुंह सी एक शब्द भी नहीं निकाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","तब यहोशू न आज्ञा दी, “गुफा को दरवाजा खोल क उन पाचयी राजावों ख निकाल क मोरो जवर लावो।” ");
INSERT INTO lbm_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","उन्न असोच करयो, अऊर यरूशलेम, हेब्रोन, यर्मूत, लाकीश, अऊर एग्लोन को उन पाचयी राजावों ख गुफा म सी निकाल क ओको जवर ले गयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","जब हि उन राजावों ख यहोशू को जवर लायो, तब यहोशू न इस्राएल को सब लोगों ख बुलाय क अपनी सेना को अधिकारियों सी कह्यो, “जवर आय क अपनो अपनो पाय इन राजावों की गर्दन पर रखो।” अऊर उन्न जवर जाय क अपनो अपनो पाय उन्की गर्दनों पर रख्यो। ");
INSERT INTO lbm_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","तब यहोशू न अधिकारी सी कह्यो, “मत डरो, तुम्हरो मन कच्चो नहीं होय; हिम्मत बान्ध क मजबूत हो; कहालीकि परमेश्वर तुम्हरो सब दुस्मनों सी जिन्कोसी तुम लड़ाई करो असोच व्यवहार करेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","येको बाद यहोशू न उन पाच राजावों ख मार डाल्यो, अऊर पाच झाड़ो पर लटकाय दियो। अऊर हि शाम तक उन झाड़ो पर लटक्यो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","सूरज डुबतो समय यहोशू सी आज्ञा पा क लोगों न उन शवों ख उन झाड़ो पर सी उतार क उच गुफा म रख्यो जहां हि लूक्यो होतो डाल दियो, अऊर ऊ गुफा को द्वार पर बड़ो बड़ो गोटा रख दियो, हि अज तक वहांच रख्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","उच दिन यहोशू न मक्केदा नगर ख हराय दियो, अऊर नगर को राजा अऊर ऊ नगर को लोगों ख तलवार सी मार डाल्यो; अऊर जितनो प्रानी ऊ नगर म होतो उन म सी कोयी ख भी जीन्दो नहीं छोड़्यो; अऊर जसो यहोशू न यरीहो को राजा को संग करयो होतो वसोच मक्केदा को राजा को संग भी करयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","तब यहोशू सब इस्राएलियों को संग मक्केदा सी जाय क लिब्ना नगर ख पहुंच्यो, अऊर लिब्ना नगर सी लड़्यो; ");
INSERT INTO lbm_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","अऊर परमेश्वर न लिब्ना नगर अऊर ओको राजा ख भी इस्राएलियों को हाथ म सौप दियो; अऊर यहोशू न नगर ख अऊर ओको म को सब प्रानियों ख तलवार सी मार डाल्यो; अऊर ओको म सी कोयी ख भी जीन्दो नहीं छोड़्यो; अऊर ओको राजा सी वसोच करयो जसो ओन यरीहो को राजा को संग करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","फिर यहोशू सब इस्राएलियों को संग लिब्ना नगर सी चल क लाकीश नगर ख गयो, अऊर डेरा डाल क ओको खिलाफ युद्ध करयो; ");
INSERT INTO lbm_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","अऊर परमेश्वर न लाकीश नगर ख इस्राएल को हाथ म सौंप दियो, अऊर दूसरो दिन ओन ओख जीत लियो; अऊर जसो ओन लिब्ना को सब प्रानियों ख तलवार सी मारयो होतो वसोच ओन लाकीश नगर सी भी करयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","तब गेजेर नगर को राजा होराम लाकीश नगर की मदत करन आयो; अऊर यहोशू न सेना समेत ओख भी मारयो ओन ओको एक भी व्यक्ति जीन्दो नहीं छोड़्यो। ");
INSERT INTO lbm_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","फिर यहोशू सब इस्राएलियों समेत लाकीश नगर सी चल क एग्लोन नगर ख गयो; अऊर डेरा डाल क ओको खिलाफ युद्ध करन लग्यो; ");
INSERT INTO lbm_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","अऊर उच दिन उन्न ओको पर अधिकार कर लियो, अऊर ओको म रहन वालो सब प्रानियों ख तलवार सी मार डाल्यो; अऊर उच दिन जसो ओन लाकीश नगर को सब प्रानियों को सत्यानाश कर डाल्यो होतो वसोच ओन एग्लोन नगर सी भी करयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","फिर यहोशू सब इस्राएलियों समेत एग्लोन नगर सी चल क हेब्रोन नगर ख गयो, अऊर ओको सी भी युद्ध करयो; ");
INSERT INTO lbm_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","अऊर उन्न ओको पर भी अधिकार कर लियो, ओन ओको राजा अऊर ओको म रहन वालो सब प्रानियों ख तलवार सी मार डाल्यो, जसो यहोशू न एग्लोन नगर सी करयो होतो वसोच ओन हेब्रोन म भी कोयी ख जीन्दो नहीं छोड़्यो; ओन नगर ख अऊर ओको म को सब प्रानियों ख नाश कर डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","तब यहोशू सब इस्राएलियों को संग दबीर नगर ख गयो, अऊर ओको सी युद्ध करन लग्यो; ");
INSERT INTO lbm_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","अऊर ओको राजा अऊर ओको सब गांवो पर अधिकार कर लियो; अऊर उन्न उन्ख तलवार सी मार डाल्यो, अऊर जितनो प्रानी उन म होतो सब को सत्यानाश कर डाल्यो; कोयी ख जीन्दो नहीं छोड़्यो, जसो यहोशू न हेब्रोन अऊर लिब्ना अऊर ओको राजा को संग करयो होतो वसोच ओन दबीर अऊर ओको राजा को संग भी करयो। ");
INSERT INTO lbm_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","यो तरह यहोशू न ऊ पूरो देश ख, मतलब पहाड़ी देश, दक्षिन देश, खल्लो को देश, अऊर ढलान को देश ख, ओको सब राजावों समेत मार डाल्यो; अऊर इस्राएल को परमेश्वर यहोवा की आज्ञा को अनुसार कोयी ख जीन्दो नहीं छोड़्यो, बल्की जितनो प्रानी होतो सब को सत्यानाश कर डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","अऊर यहोशू न दक्षिन को कादेशबर्ने नगर सी अज्जा नगर तक, अऊर गोशेन देश सी उत्तर को गिबोन नगर तक को लोगों ख मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","इन सब राजावों ख ओको देशों समेत यहोशू न एकच समय म अधिकार कर लियो, कहालीकि इस्राएल को परमेश्वर यहोवा इस्राएलियों को तरफ सी लड़त होतो। ");
INSERT INTO lbm_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","तब यहोशू सब इस्राएलियों को संग गिलगाल की छावनी म लौट आयो। ");
INSERT INTO lbm_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","यो सुन क हासोर को राजा याबीन न मादोन नगर को राजा योबाब, अऊर शिम्रोन नगर अऊर अक्षाप नगर को राजा ख, ");
INSERT INTO lbm_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","अऊर जो जो राजा उत्तर को तरफ पहाड़ी देश म, अऊर किन्नेरेत को दक्षिन को अराबा म, अऊर खल्लो को देश म, अऊर पश्चिम को तरफ दोर नगर को ऊंचो देश म रहत होतो, उन्ख, ");
INSERT INTO lbm_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","अऊर पूर्व अऊर पश्चिम दोयी तरफ को रहन वालो कनानियों, अऊर एमोरियों, हित्तियों, परिज्जियों, अऊर पहाड़ी यबूसियों, अऊर मिस्पा देश म हेर्मोन पहाड़ी को खल्लो रहन वालो हिब्बियों ख सन्देश भेज्यो। ");
INSERT INTO lbm_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","अऊर हि अपनी अपनी सेना समेत, जो समुन्दर को किनार की रेतु को कन को समान बहुत होतो, मिल क नगरों सी निकल आयो, अऊर उन्को संग बहुत सो घोड़ा अऊर रथ भी होतो। ");
INSERT INTO lbm_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","तब हि सब राजा सम्मति कर क् जमा भयो, अऊर इस्राएलियों सी लड़न ख मेरोम नाम को तलाव को जवर आय क एक संग डेरा डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","तब परमेश्वर न यहोशू सी कह्यो, “उन सी मत डरो, कहालीकि कल योच समय मय उन सब ख इस्राएलियों को हाथ म सौप क मरवाय डालूं; तब तय उन्को घोड़ा को घुटना की नस कटवायजो, अऊर उन्को रथ जलाय क भस्म कर देजो।” ");
INSERT INTO lbm_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","अऊर यहोशू सब सैनिकों को संग मेरोम नाम को तलाव को जवर पहुंच क अचानक उन पर टूट पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","अऊर परमेश्वर न उन्ख इस्राएलियों को हाथ म सौंप दियो, येकोलायी उन्न उन्ख मार डाल्यो, अऊर बड़ो नगर सीदोन अऊर मिस्रपोतमैम तक, अऊर पूर्व को तरफ मिस्पा को मैदान तक उन्को पीछा करयो; अऊर उन्ख मारयो, अऊर उन म सी कोयी ख जीन्दो नहीं छोड़्यो। ");
INSERT INTO lbm_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","तब यहोशू न परमेश्वर की आज्ञा को अनुसार उन्को संग वसोच करयो, मतलब उन्को घोड़ा की घुटना की नस कटवायी, अऊर उन्को रथ आगी म जलाय क भस्म कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","ऊ समय यहोशू न हासोर नगर ख जो पहले उन सब राज्यो म मुख्य नगर होतो अधिकार कर लियो, अऊर ओको राजा ख तलवार सी मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","अऊर जितनो प्रानी ओको म होतो उन सब ख उन्न तलवार सी मार क नाश कर दियो; अऊर कोयी प्रानी ख जीन्दो नहीं छोड़्यो, अऊर हासोर ख यहोशू न आगी लगाय क फुंकवाय दियो। ");
INSERT INTO lbm_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","अऊर उन सब नगरों ख अऊर ओको सब राजावों समेत यहोशू न अधिकार कर लियो, अऊर परमेश्वर को सेवक मूसा की आज्ञा को अनुसार उन्ख तलवार सी मार क नाश कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","पर हासोर नगर ख छोड़ क, जेक यहोशू न जलाय दियो होतो, इस्राएलियों न अऊर कोयी नगर ख जो पहाड़ी पर बस्यो होतो नहीं जलायो। ");
INSERT INTO lbm_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","अऊर उन नगरों को जनावर अऊर उन्की पूरी लूट की सम्पत्ति ख इस्राएलियों न अपनो जवर रख लियो; पर आदमियों ख उन्न तलवार सी मार डाल्यो, यहां तक उन्को सत्यानाश कर दियो कि एक भी प्रानी जीन्दो नहीं छोड़्यो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","जो आज्ञा परमेश्वर न अपनो दास मूसा ख दी होती ओकोच अनुसार मूसा न यहोशू ख आज्ञा दी, अऊर ठीक वसोच यहोशू न भी करयो; जो जो आज्ञा परमेश्वर न मूसा ख दी होती उन म सी यहोशू न कोयी भी आज्ञा पूरी करयो बिना नहीं छोड़्यो। ");
INSERT INTO lbm_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","तब यहोशू न ऊ पूरो देश ख, मतलब पहाड़ी देश, अऊर पूरो दक्षिन देश, अऊर गोशेन देश, अऊर खल्लो को जमीन देश, यरदन घाटी, अऊर इस्राएल को पहाड़ी देश, अऊर उन्को खल्लो वालो देश ख, ");
INSERT INTO lbm_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","हालाक नाम की पहाड़ी सी ले क, जो सेईर की चढ़ायी पर हय, बालगाद नगर तक, जो लबानोन को मैदान म हेर्मोन पहाड़ी को खल्लो, जितनो देश हय जीत लियो अऊर उन देशों को पूरो राजावों ख पकड़ क मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","उन सब राजावों सी लड़ाई करत करत यहोशू ख बहुत दिन लग गयो। ");
INSERT INTO lbm_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","गिबोन को निवासी हिब्बियों ख छोड़ क अऊर कोयी नगर को लोगों न इस्राएलियों सी मेल-मिलाप नहीं करयो; अऊर सब नगरों ख उन्न युद्ध कर क् जीत लियो। ");
INSERT INTO lbm_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","कहालीकि परमेश्वर की जो मनसा होती, कि अपनी वा आज्ञा को अनुसार जो ओन मूसा ख दी होती उन पर कुछ भी दया नहीं करे, बल्की सत्यानाश कर डाले, यो वजह ओन उन्को मन असो कठोर कर दियो, कि उन्न इस्राएलियों को सामना कर क् उन सी युद्ध करयो। ");
INSERT INTO lbm_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","ऊ समय यहोशू न पहाड़ी देश म आय क हेब्रोन, दबीर, अनाब, यहूदा अऊर इस्राएल दोयी को पूरो पहाड़ी देश म रहन वालो अनाकियों ख नाश कर दियो; यहोशू न नगरों समेत उन्को सत्यानाश कर डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","इस्राएलियों को देश म कोयी अनाकी व्यक्ति नहीं रह्य गयो; केवल अज्जा, गत, अऊर अशदोद नगर म कोयी कोयी रह्य गयो। ");
INSERT INTO lbm_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","जसो परमेश्वर न मूसा सी कह्यो होतो, वसोच यहोशू न ऊ पूरो देश पर अधिकार कर लियो; अऊर ओख इस्राएल को गोत्रों अऊर कुलों को अनुसार बाट क उन्ख दे दियो। अऊर तब युद्ध को बाद देश ख शान्ति मिली। ");
INSERT INTO lbm_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","यरदन नदी को ओन पार पूर्व दिशा को तरफ, मतलब अर्नोन घाटी सी ले क हेर्मोन पहाड़ी तक को देश, अऊर पूरो पूर्व अराबा को जिन राजावों ख इस्राएलियों न मार क उन्को देश ख अपनो अधिकार म कर लियो होतो हि यो आय : ");
INSERT INTO lbm_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","एमोरियों को हेशबोन नगर को राजा सीहोन, जो अर्नोन घाटी को किनार को अरोएर नगर सी ले क, अऊर उच घाटी को बीच को नगर ख छोड़ क यब्बोक नदी तक, जो अम्मोनियों कि सीमा हय, अरधो गिलाद को बराबर होतो, ");
INSERT INTO lbm_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","अऊर किन्नेरेत नाम को तलाव सी ले क बेत्यशीमोत सी होय क अराबा को तलाव तक; जो खारो तलाव भी कहलावय हय, पूर्व को तरफ को अराबा, अऊर दक्षिन को तरफ पिसगा को ढलान को खल्लो को देश पर शासन करत होतो। ");
INSERT INTO lbm_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","फिर बच्यो हुयो रपाई जाती म सी बाशान देश को राजा ओग को देश होतो, जो अश्तारोत अऊर एद्रेई नगर म रह्यो करत होतो, ");
INSERT INTO lbm_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","अऊर हेर्मोन पहाड़ी, सल्का, अऊर गशूरियों, अऊर माकियों की सीमा तक कुल बाशान देश म, अऊर हेशबोन को राजा सीहोन की सीमा तक अरधो गिलाद देश म भी शासन करत होतो। ");
INSERT INTO lbm_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","इस्राएलियों अऊर परमेश्वर को दास मूसा न इन ख मार डाल्यो; अऊर परमेश्वर को सेवक मूसा न इन्को देश रूबेनियों अऊर गादियों अऊर मनश्शे को अरधो गोत्र को लोगों ख दे दियो। ");
INSERT INTO lbm_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","यरदन नदी को पश्चिम को तरफ, लबानोन को मैदान म को बालगाद नगर सी ले क सेईर की चढ़ायी को हालाक पहाड़ी तक को देश को जिन राजावों ख यहोशू अऊर इस्राएलियों न मार क उन्को देश इस्राएलियों ख गोत्रों अऊर कुलों को अनुसार भाग कर क् दे दियो होतो हि यो आय : ");
INSERT INTO lbm_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","हित्ती, एमोरी, कनानी, परिज्जी, हिब्बी, यबूसी जाती, जो पहाड़ी देश म, खल्लो को देश म, अराबा म, ढलान देश म, जंगल म, अऊर दक्षिन देश म रहत होती। ");
INSERT INTO lbm_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","एक, यरीहो को राजा; एक, बेतेल को जवर ऐ नगर को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","एक, यरूशलेम को राजा; एक, हेब्रोन को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","एक, यर्मूत को राजा; एक, लाकीश को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","एक, एग्लोन को राजा; एक, मेजेर को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","एक, दबीर को राजा; एक, गेदेर को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","एक, होर्मा को राजा; एक, अराद को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","एक, लिब्ना को राजा; एक, अदुल्लाम को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","एक, मक्केदा को राजा; एक, बेतेल को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","एक, तप्पूह को राजा; एक, हेपेर को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","एक, अपेक को राजा; एक, लश्शारोन को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","एक, मादोन को राजा; एक, हासोर को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","एक, शिम्रोन्मरोन को राजा; एक, अक्षाप को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","एक, तानाक को राजा; एक, मगिद्दो को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","एक, केदेश को राजा; एक, कर्मेल म को योकनाम को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","एक, दोर नाम को ऊंचो देश म को दोर को राजा; एक, गिलगाल म को गोयीम को राजा; ");
INSERT INTO lbm_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","अऊर एक, तिर्सा को राजा हय; यो तरह सब राजा येकतीस भयो। ");
INSERT INTO lbm_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","यहोशू बूढ्ढा अऊर बहुत उमर को भय गयो होतो; अऊर परमेश्वर न ओको सी कह्यो, “तय बूढ्ढा अऊर बहुत उमर को भय गयो हय, अऊर बहुत देश रह्य गयो हंय, जो इस्राएल को अधिकार म अभी तक नहीं आयो। ");
INSERT INTO lbm_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","यो देश रह्य गयो हय, पलिश्तियों को पूरो प्रान्त, अऊर पूरो गशूरी देश ");
INSERT INTO lbm_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","मिस्र देश को आगु शीहोर नदी सी ले क उत्तर को तरफ एक्रोन नगर की सीमा तक जो कनानियों को भाग गिन्यो जावय हय; अऊर पलिश्तियों को पाचों सरदार, मतलब अज्जा, अशदोद, अशकलोन, गत, अऊर एक्रोन को लोग, अऊर दक्षिन को तरफ अव्वी जाती भी, ");
INSERT INTO lbm_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","फिर अपेक नगर अऊर एमोरियों की सीमा तक कनानियों को पूरो देश, अऊर सीदोनियों को मारा नाम को देश, ");
INSERT INTO lbm_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","फिर गवालियों को देश, अऊर पूर्व को तरफ हेर्मोन पहाड़ी को खल्लो को बालगाद नगर सी ले क हमात की घाटी तक पूरो लबानोन प्रदेश, ");
INSERT INTO lbm_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","फिर लबानोन प्रदेश सी ले क मिस्रपोतमैम तक सीदोनियों को पहाड़ी देश को निवासी। इन ख मय इस्राएलियों को सामने सी निकाल देऊं; इतनो होय कि तय मोरी आज्ञा को अनुसार उन्को अधिकार इस्राएलियों को बीच म बाट दे। ");
INSERT INTO lbm_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","येकोलायी तय अब यो देश ख नव गोत्रों अऊर मनश्शे को अरधो गोत्र ख उन्को हिस्सा होन लायी बाट दे।” ");
INSERT INTO lbm_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","रूबेनियों अऊर गादियों ख त ऊ हिस्सा मिल चुक्यो होतो, जेक मूसा न उन्ख यरदन नदी को पूर्व को तरफ दियो होतो, कहालीकि परमेश्वर को सेवक न यो उन्खच दियो होतो, ");
INSERT INTO lbm_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","मतलब अर्नोन नाम की घाटी को किनार को अरोएर नगर सी ले क, अऊर उच घाटी को बीच को नगर ख छोड़ क दीबोन नगर तक मेदबा को जवर को पूरो चौरस देश; ");
INSERT INTO lbm_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","अऊर अम्मोनियों की सीमा तक हेशबोन म रहन वालो एमोरियों को राजा सीहोन को पूरो नगर; ");
INSERT INTO lbm_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","अऊर गिलाद देश, अऊर गशूरियों अऊर माकावासियों की सीमा, अऊर पूरो हेर्मोन पहाड़ी, अऊर सल्का नगर तक पूरो बाशान प्रदेश, ");
INSERT INTO lbm_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","फिर अश्तारोत अऊर एद्रेई नगर म रहन वालो ऊ ओग को पूरो राज्य जो रपाई जाती म सी अकेलो बच गयो होतो; कहालीकि इन ख मूसा न मार क उन्की प्रजा ख ऊ देश सी निकाल दियो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","पर इस्राएलियों न गशूरियों अऊर माकियों ख उन्को देश सी नहीं निकाल्यो; येकोलायी गशूरी अऊर माकी जाती इस्राएलियों को बीच म अज तक रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","अऊर लेवी को कुल ख मूसा न कोयी हिस्सा नहीं दियो; कहालीकि इस्राएल को परमेश्वर यहोवा को वचन को अनुसार ओकीच चढ़ायी हुयी होमबलि बलि की भेंट उन्को लायी हिस्सा ठहरी हय। ");
INSERT INTO lbm_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","मूसा न जमीन को हिस्सा रूबेन को वंश ख उन्को परिवार ख बाट दियो होतो, ");
INSERT INTO lbm_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","मतलब अर्नोन नाम की घाटी को किनार को अरोएर नगर सी ले क अऊर उच घाटी को बीच को नगर ख छोड़ क मेदबा को जवर को पूरो चौरस देश; ");
INSERT INTO lbm_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","फिर चौरस देश म को हेशबोन अऊर ओको सब गांव; फिर दीबोन, बामोतबाल, बेतबाल्मोन, ");
INSERT INTO lbm_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","यहसा, कदेमोत, मेपात, ");
INSERT INTO lbm_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","किर्यातैम, सिबमा, अऊर घाटी म की पहाड़ी पर बस्यो हुयो सेरेथश्शहर, ");
INSERT INTO lbm_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","बेतपोर, पिसगा पहाड़ी की ढलान अऊर बेत्यशीमोत, ");
INSERT INTO lbm_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","मतलब चौरस देश म बस्यो हुयो हेशबोन म रहन वालो एमोरियों को ऊ राजा सीहोन को राज्य को पूरो नगर जिन्ख मूसा न मार लियो होतो। मूसा न एवी, रेकेम, सूर, हूर, अऊर रेबा नाम को मिद्दानी जाती को मुखियावों ख भी मार डाल्यो होतो जो सीहोन को ठहरायो हुयो शासक अऊर उच देश को निवासी होतो। ");
INSERT INTO lbm_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","अऊर इस्राएलियों न उन्को अऊर मारयो हुयो व्यक्तियों को संग बोर को टुरा भविष्य बतावन वालो बिलाम ख भी तलवार सी मार डाल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","अऊर रूबेनियों की सीमा यरदन नदी को किनार होतो। रूबेनियों को हिस्सा उन्को वंशों अऊर कुलों को अनुसार योच नगर अऊर गांव उन्को हिस्सा होतो। ");
INSERT INTO lbm_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","फिर मूसा न गाद को वंशों ख भी कुलों को अनुसार उन्को हिस्सा कर क् बाट दियो। ");
INSERT INTO lbm_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","तब यो ठहरयो, मतलब याजेर या गिलाद प्रदेश को पूरो नगर, अऊर रब्बा नगर को सामने को अरोएर नगर तक अम्मोनियों को अरधो देश, ");
INSERT INTO lbm_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","अऊर हेशबोन नगर सी रामतमिस्पे अऊर बतोनीम् तक, अऊर महनैम सी दबीर की सीमा तक, ");
INSERT INTO lbm_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","अऊर घाटी म बेथारम, बेतनिम्रा, सुक्कोत, अऊर सापोन अऊर हेशबोन नगर को राजा सीहोन को राज्य को बच्यो हुयो हिस्सा, अऊर किन्नेरेत नाम को तलाव को किनार तक, यरदन नदी को पूर्व को तरफ को ऊ देश जेकी सीमा यरदन हय। ");
INSERT INTO lbm_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","गादी लोगों को हिस्सा उन्को कुलों को अनुसार नगरों अऊर गांवो समेत यहांच रूक गयो। ");
INSERT INTO lbm_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","फिर मूसा न मनश्शे को अरधो कुलों ख भी उन्को निजी हिस्सा कर क् दियो; ऊ मनश्शे को अरधो कुल को निजी हिस्सा उन्को कुलों को अनुसार ठहरयो। ");
INSERT INTO lbm_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","ऊ यो आय, मतलब महनैम सी ले क बाशान प्रदेश को राजा ओग को राज्य को पूरो देश, अऊर बाशान प्रदेश म बसी हुयी याईर की साठ बस्तियां, ");
INSERT INTO lbm_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","अऊर गिलाद को अरधो हिस्सा, अऊर अश्तारोत, अऊर एद्रेई, जो बाशान म ओग को राज्य को नगर होतो, हि मनश्शे को टुरा माकीर को वंश को, मतलब माकीर को अरधो वंश को निजी हिस्सा कुलों को अनुसार बाट दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","जो हिस्सा मूसा न मोआब को मैदान म यरीहो को जवर को यरदन नदी को पूर्व को तरफ बाट दियो हि योच आय। ");
INSERT INTO lbm_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","पर लेवी को गोत्र ख मूसा न कोयी हिस्सा नहीं दियो; इस्राएल को परमेश्वर यहोवाच अपनो वचन को अनुसार उन्को हिस्सा ठहरयो। ");
INSERT INTO lbm_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","जो जो हिस्सा इस्राएलियों ख कनान देश म मिल्यो, जिन्ख एलीआजार याजक, अऊर नून को टुरा यहोशू, अऊर इस्राएली गोत्र को पूर्वजों को घराना को मुख्य मुख्य आदमियों न उन्ख दियो हि यो आय। ");
INSERT INTO lbm_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","जो आज्ञा परमेश्वर न मूसा को द्वारा साढ़े नव गोत्रों लायी दी होती, उन्को अनुसार उन्को हिस्सा चिट्ठी डाल क दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","मूसा न त ढायी गोत्रों को हिस्सा यरदन को पार दियो होतो; पर लेवियों ख ओन उन्को संग कोयी हिस्सा नहीं दियो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","यूसुफ को वंश को दोय गोत्र होतो, मतलब मनश्शे अऊर एप्रैम; अऊर ऊ देश म लेवियों ख कुछ हिस्सा नहीं दियो गयो, केवल रहन लायी नगर, अऊर जनावर अऊर धन रखन लायी चराइयां उन्ख दी गयी। ");
INSERT INTO lbm_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","जो आज्ञा परमेश्वर न मूसा ख दी होती ओको अनुसार इस्राएलियों न करयो; अऊर उन्न देश ख बाट लियो। ");
INSERT INTO lbm_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","तब यहूदी लोग यहोशू को जवर गिलगाल म आयो; अऊर कनजी यपुन्ने को टुरा कालेब न ओको सी कह्यो, “तय जानत होना कि परमेश्वर न कादेशबर्ने म परमेश्वर को सेवक मूसा सी मोरो अऊर तोरो बारे म का कह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","जब परमेश्वर को दास मूसा न मोख यो देश को भेद लेन लायी कादेशबर्ने सी भेज्यो होतो तब मय चालीस साल को होतो; अऊर मय सच्चो मन सी ओको जवर सन्देश ले क आयो। ");
INSERT INTO lbm_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","अऊर मोरो संगी जो मोरो संग गयो होतो उन्न त प्रजा को लोगों को मन निराश कर दियो, पर मय न अपनो परमेश्वर यहोवा की पूरी रीति सी बात मानी। ");
INSERT INTO lbm_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","तब ऊ दिन मूसा न कसम खाय क मोरो सी कह्यो, ‘तय न पूरी रीति सी मोरो परमेश्वर यहोवा की बातों को अनुसरन करयो हय, यो तरह बिना सक जो जमीन पर तय पाय रख्यो हय ऊ हमेशा लायी तोरो अऊर तोरो वंश को हिस्सा होयेंन।’ ");
INSERT INTO lbm_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","अऊर अब देख, जब परमेश्वर न मूसा सी यो वचन कह्यो होतो तब सी पैतालीस साल भय गयो हय, जिन म इस्राएली लोग जंगल म भटकतो रह्यो; उन म परमेश्वर न अपनो वादा को अनुसार मोख जीन्दो रख्यो हय; अऊर अब मय पच्यासी साल को हय। ");
INSERT INTO lbm_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","जितनी शक्ति मूसा को भेजन को दिन मोरो म होती उतनी शक्ति अभी भी मोरो म हय; युद्ध करन, यां बाहेर आन-जान लायी जितनी शक्ति ऊ समय होती उतनीच शक्ति अभी भी मोरो म हय। ");
INSERT INTO lbm_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","येकोलायी अब ऊ पहाड़ी देश मोख दे जेकी चर्चा परमेश्वर न ऊ दिन करी होती; तय न त ऊ दिन सुन्यो होना कि ओको म अनक वंशी रह्य हंय, अऊर बड़ो बड़ो गढ़ वालो नगर भी हय; यदि परमेश्वर मोरो संग रहे, त ओकी प्रतिज्ञा को अनुसार मय उन्ख उन्को देश सी निकाल देऊं।” ");
INSERT INTO lbm_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","तब यहोशू न ओख आशीर्वाद दियो; अऊर हेब्रोन नगर यपुन्ने को टुरा कालेब ख हिस्सा दे दियो। ");
INSERT INTO lbm_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","यो वजह हेब्रोन नगर कनजी यपुन्ने को टुरा कालेब को हिस्सा अज तक बन्यो हय, कहालीकि इस्राएल को परमेश्वर यहोवा को पूरी रीति सी अनुसरन करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","पहले हेब्रोन नगर को नाम किर्यतर्बा होतो; ऊ अर्बा नाम को व्यक्ति अनाकियों म सब सी बड़ो आदमी होतो। अऊर युद्ध खतम होन को बाद ऊ देश ख शान्ति मिली। ");
INSERT INTO lbm_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","यहूदा कुल को लोगों ख उन्को परिवारों की संख्या को अनुसार चिट्ठी डालन पर एदोम की सीमा मिली, जो दक्षिन को तरफ सीन को जंगल तक दक्षिन सीमा पर हय। ");
INSERT INTO lbm_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","उन्को भाग की दक्षिनी सीमा मृत सागर को छोर सी सुरूवात भयी जो दक्षिन को तरफ बढ़य हय; ");
INSERT INTO lbm_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","अऊर अक्रबीम नाम की चढ़ायी को दक्षिन को तरफ सी निकल क सीन होतो हुयो कादेशबर्ने को दक्षिन को तरफ पहुंच गयी, फिर हेस्रोन को जवर सी अद्दार ख पहुंच क कर्का को तरफ मुड़ गयी, ");
INSERT INTO lbm_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","वहां सी अम्मोन होतो हुयो वा मिस्र को नाला पर निकली, अऊर वा सीमा को अन्त भूमध्यसागर भयो। यो यहूदा कुल की दक्षिनी सीमा होती। ");
INSERT INTO lbm_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","फिर पूर्व दिशा की सीमा को किनार तक खारो तलाव हय, अऊर उत्तर दिशा की सीमा यरदन को किनार को जवर को तलाव की खाड़ी सी शुरू कर क्, ");
INSERT INTO lbm_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","बेथोग्ला ख चढ़तो हुयो बेतराबा की उत्तर को तरफ होय क रूबेन को टुरा बोहन नाम की चट्टान तक चली गयी; ");
INSERT INTO lbm_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","अऊर वाच सीमा आकोर नाम की घाटी सी दबीर को तरफ पहुंची, अऊर उत्तर दिशा होतो हुयो गिलगाल को तरफ मुड़ी जो घाटी को दक्षिन को तरफ को अदुम्मीम की चढ़ायी को सामने हय; वहां सी वा एनशेमेश नाम को झरना को जवर पहुंच क एनरोगेल घाटी पर निकली; ");
INSERT INTO lbm_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","फिर वाच सीमा बेन-हिन्नोम घाटी सी होय क यबूस जो यरूशलेम कहलावय हय अऊर दक्षिन को तरफ सी चढ़ती हुयी वा पहाड़ी की ऊचायी पर पहुंची, जो पश्चिम को तरफ हिन्नोम की घाटी को सामने अऊर रपाईम की घाटी को उत्तर वालो आखरी छोर पर हय; ");
INSERT INTO lbm_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","फिर वाच सीमा ऊ पहाड़ी की ऊचायी सी नेप्तोह नाम को झरना पर पहुंची, अऊर एप्रोन पहाड़ी को नगरों पर निकली; फिर वहां सी बाला ख जो किर्यत्यारीम भी कहलावय हय पहुंची; ");
INSERT INTO lbm_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","फिर सीमा बाला सी पश्चिम को तरफ मुड़ क सेईर पहाड़ी तक पहुंची अऊर यारीम पहाड़ी जो कसालोन भी कहलावय हय ओको उत्तर दिशा को तरफ सी होय क बेतशेमेश पर उतर गयी, अऊर वहां सी तिम्ना पर निकली; ");
INSERT INTO lbm_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","वहां सी वा सीमा एक्रोन को उत्तर दिशा को जवर सी होतो हुयो शिक्करोन गयी, अऊर बाला पहाड़ी होय क यब्नेल पर गयी; अऊर वा सीमा को अन्त महासमुन्दर पर भयो। ");
INSERT INTO lbm_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","अऊर पश्चिम की सीमा महासमुन्दर को किनार ठहरी। यहूदा ख जो हिस्सा उन्को कुलों को अनुसार मिल्यो ओको चारयी तरफ की सीमा याच भयी। ");
INSERT INTO lbm_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","अऊर यपुन्ने को टुरा कालेब ख यहोशू न परमेश्वर की आज्ञा को अनुसार यहूदियों को बीच म हिस्सा दियो, मतलब किर्यतर्बा जो हेब्रोन भी कहलावय हय ऊ अर्बा अनाक को बाप होतो। ");
INSERT INTO lbm_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","अऊर कालेब न वहां सी शेशै, अहीमन, अऊर तल्मै नाम को, अनाक को तीनयी टुरावों ख निकाल दियो। ");
INSERT INTO lbm_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","फिर कालेब न दबीर को निवासियों पर हमला करयो; दबीर को पुरानो नाम किर्यत्सेपेर होतो। ");
INSERT INTO lbm_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","अऊर कालेब न कह्यो, “जो किर्यत्सेपेर ख हराय क ओख अपनो अधिन कर लेयेंन ओको सी मय अपनी टुरी अकसा को बिहाव कर देऊं।” ");
INSERT INTO lbm_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","तब कालेब को भाऊ कनजी को टुरा ओत्नीएल न ऊ नगर पर अधिकार कर लियो; अऊर ओन ओको सी अपनी टुरी अकसा को बिहाव कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","जब वा ओत्नीएल को जवर आयी, तब ओन अकसा ख बाप सी कुछ जमीन मांगन ख कह्यो, वा कालेब को जवर गयी जब वा गधा पर सी खल्लो उतरी, तब कालेब न ओको सी पुच्छ्यो, “तय का चाहवय हय?” ");
INSERT INTO lbm_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","वा बोली, “मोख आशीर्वाद दे; तय न मोख दक्षिन देश म की कुछ जमीन त दे दी हय, मोख पानी को सोता भी दे।” तब ओन ऊपर अऊर खल्लो को सोता दोयी ओख दे दियो। ");
INSERT INTO lbm_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","यहूदियों को कुल को हिस्सा त उन्को कुलों को अनुसार योच ठहरयो। ");
INSERT INTO lbm_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","यहूदा कुल को नगर दक्षिन देश म एदोम की सीमा को तरफ हि आय, कबसेल, एदेर, यागूर, ");
INSERT INTO lbm_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","कीना, दीमोना, अदादा, ");
INSERT INTO lbm_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","केदेश, हासोर, यित्नान, ");
INSERT INTO lbm_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","जीप, तेलेम, बालोत, ");
INSERT INTO lbm_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","हासोर्हदत्ता, करिय्योथेस्रोन, जो हासोर भी कहलावय हय, ");
INSERT INTO lbm_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","अऊर अमाम, शमा, मोलादा, ");
INSERT INTO lbm_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","हसर्गद्दा, हेशमोन, बेत्पालेत, ");
INSERT INTO lbm_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","हसर्शूआल, बेर्शेबा, बिज्योत्या, ");
INSERT INTO lbm_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","बाला, इय्यीम, एसेम, ");
INSERT INTO lbm_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","एलतोलद, कसील, होर्मा, ");
INSERT INTO lbm_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","सिकलग, मदमन्ना, सनसन्ना, ");
INSERT INTO lbm_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","लबाओत, शिल्हीम, ऐन, अऊर रिम्मोन; गावों सहित सब नगरों की संख्या उनतीस हय। ");
INSERT INTO lbm_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","खल्लो को देश म स्थित नगर : एशताओल, सोरा, अशना, ");
INSERT INTO lbm_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","जानोह, एनगन्नीम, तप्पूह, एनाम, ");
INSERT INTO lbm_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","यर्मूत, अदुल्लाम, सोको, अजेका, ");
INSERT INTO lbm_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","शारैम, अदीतैम, गदेरा, अऊर गदेरोतैम; हि सब गांव सहित सब नगरों की संख्या चौदा हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","फिर सनान, हदाशा, मिगदलगाद, ");
INSERT INTO lbm_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","दिलान, मिस्पे, योक्तेल, ");
INSERT INTO lbm_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","लाकीश, बोस्कत, एग्लोन, ");
INSERT INTO lbm_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","कब्बोन, लहमास, कितलीश, ");
INSERT INTO lbm_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","गदेरोत, बेतदागोन, नामा, अऊर मक्केदा; हि गांव सहित सब नगरों की संख्या सोला हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","फिर लिब्ना, ऐतेर, आशान, ");
INSERT INTO lbm_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","यिप्तह, अशाना, नसीब, ");
INSERT INTO lbm_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","कीला, अकजीब, अऊर मारेशा; हि गांव सहित सब नगरों की संख्या नव हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","फिर नगरों अऊर गांवो सहित एक्रोन, ");
INSERT INTO lbm_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","अऊर एक्रोन सी ले क महासमुन्दर तक, अपनो अपनो गांवो समेत जितनो नगर अशदोद को तरफ हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","फिर अपनो अपनो नगरों अऊर गांवो समेत अशदोद, अऊर अज्जा, बल्की मिस्र को नाला तक अऊर महासमुन्दर को किनार तक जितनो नगर हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","पहाड़ी देश म हि हय : शामीर, यत्तीर, सोको, ");
INSERT INTO lbm_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","दन्ना, किर्यत्सन्ना जो दबीर भी कहलावय हय, ");
INSERT INTO lbm_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","अनाब, एशतमो, आनीम, ");
INSERT INTO lbm_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","गोशेन, होलोन, अऊर गीलो; हि गांवो सहित सब नगरों की संख्या ग्यारा हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","फिर अराब, दूमा, एशान, ");
INSERT INTO lbm_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","यानीम, बेत्तप्पूह, अपेका, ");
INSERT INTO lbm_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","हुमता, किर्यतर्बा जो हेब्रोन भी कहलावय हय, अऊर सीओर गांवो सहित सब नगरों की संख्या नव हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","फिर माओन, कर्मेल, जीप, यूता, ");
INSERT INTO lbm_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","यिज्रेल, योकदाम, जानोह, ");
INSERT INTO lbm_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","कैन, गिबा, अऊर तिम्ना; गांवो समेत सब नगरों की संख्या दस हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","फिर हलहूल, बेतसूर, गदोर, ");
INSERT INTO lbm_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","मरात, बेतनोत, अऊर एलतकोन; हि गांवो समेत सब नगरों की संख्या छय हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","फिर किर्यतबाल जो किर्यत्यारीम भी कहलावय हय, अऊर रब्बा; हि गांव समेत दोय नगर हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","जंगल म हि नगर हंय : बेतराबा, मिद्दीन, सकाका; ");
INSERT INTO lbm_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","निबशान, लवन नगर, अऊर एनगदी, हि गांवो समेत छय नगर हंय। ");
INSERT INTO lbm_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","यरूशलेम को निवासी यबूसियों ख नहीं निकाल सक्यो; येकोलायी अज भी यबूसी यहूदियों को संग यरूशलेम म रह्य हंय। ");
INSERT INTO lbm_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","फिर यूसुफ को वंशजों ख यरीहो नगर को जवर, यरदन नदी सी यरीहो को झरना को पूर्व म जंगल तक की सीमा दी गयी, ओकी सीमा यरीहो सी शुरू होय क ऊ पहाड़ी देश सी होतो हुयो, बेतेल नगर ख पहुंची; ");
INSERT INTO lbm_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","वहां सी वा लूज सीमा तक पहुंची, अऊर अर्की जाति की सीमा सी होतो हुयो अतारोत सीमा पर जाय निकली; ");
INSERT INTO lbm_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","अऊर पश्चिम को तरफ यपलेतियों जाति की सीमा सी उतर क फिर खल्लो की बेथोरोन की सीमा सी होय क गेजेर नाम की जागा पर पहुंची, अऊर महासमुन्दर पर खतम भयी। ");
INSERT INTO lbm_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","तब मनश्शे अऊर एप्रैम नाम को यूसुफ को दोयी टुरावों की सन्तान न अपनो अपनो हिस्सा लियो। ");
INSERT INTO lbm_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","एप्रैमियों की सीमा उन्को कुलों को अनुसार या होती; उन्को हिस्सा की सीमा पूर्व सी शुरू होय क अत्रोतद्दार सी होतो हुयो ऊपर वालो बेथोरोन तक पहुंची; ");
INSERT INTO lbm_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","अऊर उत्तरी सीमा पश्चिम को तरफ को मिकमतात सी शुरू होय क पूर्व को तरफ मुड़ क तानतशीलो ख पहुंची, अऊर ओको जवर सी होतो हुयो यानोह तक गयी; ");
INSERT INTO lbm_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","फिर यानोह सी वा अतारोत अऊर नारा ख उतरती हुयी यरीहो को जवर सी होय क यरदन नदी पर खतम भयी। ");
INSERT INTO lbm_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","फिर वाच सीमा तप्पूह सी निकल क, अऊर पश्चिम को तरफ जाय क, काना को नाला सी होय क महासमुन्दर पर निकली। एप्रैमियों को कुल को हिस्सा उन्को कुलों को अनुसार योच ठहरयो। ");
INSERT INTO lbm_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","अऊर मनश्शे कुल को हिस्सा को बीच म भी कुछ नगर अपनो अपनो गांवो समेत एप्रैमियों को लायी अलग करयो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","पर जो कनानी गेजेर नगर म बस्यो होतो उन्ख एप्रैमियों न वहां सी नहीं निकाल्यो; येकोलायी हि कनानी जाति उन्को बीच म अज भी बस्यो हंय, अऊर बेकार म दास को जसो करय हंय। ");
INSERT INTO lbm_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","फिर यूसुफ को बड़ो टुरा मनश्शे को कुल को हिस्सा चिट्ठी डाल क दियो गयो। मनश्शे को बड़ो टुरा, माकीर गिलाद को बाप योद्धा होतो, यो वजह ओको वंश ख गिलाद अऊर बाशान प्रदेश दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","येकोलायी यो हिस्सा मनश्शे को दूसरो टुरावों लायी उन्को कुल अनुसार दियो गयो, अबीएजेर, हेलेक, अस्रीएल, शेकेम, हेपेर, अऊर शमीदा; जो अपनो अपनो कुलों को अनुसार यूसुफ को टुरा मनश्शे को परिवार को मुखिया होतो, उन्को अलग अलग वंशों लायी ठहरयो। ");
INSERT INTO lbm_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","पर हेपेर जो गिलाद को टुरा, माकीर को नाती, अऊर मनश्शे को पन्ती होतो, ओको टुरा सलोफाद ख टुरा नहीं बल्की टुरीच भयी; अऊर उन्को नाम महला, नोआ, होग्ला, मिल्का, अऊर तिर्सा हंय। ");
INSERT INTO lbm_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","तब हि टुरी एलीआजार याजक, नून को टुरा यहोशू, अऊर मुखियावों को जवर जाय क कहन लगी, “परमेश्वर न मूसा ख आज्ञा दी होती, कि ऊ हम्ख हमरो भाऊवों को बीच म हिस्सा दे।” त यहोशू न परमेश्वर की आज्ञा को अनुसार उन्ख उन्को काकावों को अधिकार को बीच म हिस्सा दियो। ");
INSERT INTO lbm_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","तब मनश्शे ख, यरदन नदी को ओन पार गिलाद अऊर बाशान प्रदेश ख छोड़ क, दस हिस्सा अऊर मिल्यो : ");
INSERT INTO lbm_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","कहालीकि मनश्शे को टुरावों को बीच म मनश्शे की टुरियों ख भी हिस्सा दियो गयो। अऊर गिलाद प्रदेश मनश्शे को बच्यो परिवार ख दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","मनश्शे की सीमा आशेर सी ले क मिकमतात तक होती, जो शकेम को सामने हय; फिर वा सीमा दक्षिन को तरफ बढ़ क एनतप्पूह को निवासियों तक चली गयी। ");
INSERT INTO lbm_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","तप्पूह की जमीन त मनश्शे ख मिली, पर तप्पूह नगर जो मनश्शे की सीमा पर बस्यो हय ऊ एप्रैमियों को ठहरयो। ");
INSERT INTO lbm_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","फिर वहां सी वा सीमा काना को नाला तक उतर क ओको दक्षिन को तरफ तक पहुंच गयी; हि एप्रैम को नगर मनश्शे को नगरों को बीच म होतो; अऊर मनश्शे की सीमा ऊ नाला को उत्तर को तरफ सी जाय क महासमुन्दर पर निकली; ");
INSERT INTO lbm_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","दक्षिन को तरफ को देश एप्रैम ख अऊर उत्तर को तरफ को देश मनश्शे ख मिल्यो, अऊर ओकी सीमा महासमुन्दर होती; अऊर उत्तर म आशेर ख अऊर पूर्व म इस्साकार ख जाय क मिली। ");
INSERT INTO lbm_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","अऊर मनश्शे ख, इस्साकार अऊर आशेर अपनो नगर समेत बेतशान, यिबलाम, अऊर अपनो नगर समेत दोर को निवासी, अऊर अपनो नगर समेत एनदोर को निवासी, अऊर अपनो नगर समेत तानाक को निवासी, अऊर अपनो नगर समेत मगिद्दो को निवासी, हि तीनयी जो ऊंचो जागा पर बस्यो हंय मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","पर मनश्शे को वंशज ऊ नगर को निवासियों ख नहीं निकाल सक्यो; येकोलायी हि कनानी ऊ देश म जबरदस्ती बस्योच रह्यो। ");
INSERT INTO lbm_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","सब इस्राएली शक्तिशाली भय गयो, तब भी उन्न कनानियों ख नहीं निकाल्यो, पर हि उन्को सी काम करावन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","यूसुफ की सन्तान यहोशू सी कहन लगी, “हम त गिनती म बहुत हंय, कहालीकि अब तक परमेश्वर हम्ख आशीषच देतो आयो हय, फिर तय न हमरो हिस्सा लायी चिट्ठी डाल क कहाली एकच हिस्सा दियो हय?” ");
INSERT INTO lbm_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","यहोशू न उन सी कह्यो, “यदि तुम गिनती म बहुत हय, अऊर एप्रैम को पहाड़ी देश तुम्हरो लायी छोटो होना, जो परिज्जियों अऊर रपाइयों को देश जो जंगल हय ओको म जाय क झाड़ो ख काट डालो।” ");
INSERT INTO lbm_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","यूसुफ की सन्तान न कह्यो, “ऊ पहाड़ी देश हमरो लायी छोटो हय; अऊर बेतशान अऊर ओको नगरों म रहन वालो अऊर यिज्रेल की घाटी म रहन वालो, जितनो कनानी लोग खल्लो को देश म रह्य हंय, उन सब को जवर लोहा को रथ हंय।” ");
INSERT INTO lbm_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","फिर यहोशू न एप्रैम अऊर मनश्शे, मतलब यूसुफ पूरो घराना सी कह्यो, “हां, तुम लोग त गिनती म बहुत हय, अऊर तुम्हरी शक्ति भी बड़ी हय, येकोलायी तुम्ख केवल एकच हिस्सा नहीं मिलेंन; ");
INSERT INTO lbm_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","पहाड़ी देश भी तुम्हरो होय जायेंन; कहालीकि ऊ जंगल त हय, पर ओको झाड़ काट डालो, तब ओको आजु-बाजू को देश भी तुम्हरो होय जायेंन; कहालीकि चाहे कनानी शक्तिशाली होना, अऊर उन्को जवर लोहा को रथ भी होना, तब भी तुम उन्ख वहां सी निकाल सको।” ");
INSERT INTO lbm_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","फिर इस्राएलियों की पूरी मण्डली न शीलो नगर म जमा होय क वहां मिलाप वालो तम्बू ख खड़ो करयो; कहालीकि उन्को देश अधिकार म आय गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","अऊर इस्राएल को सात कुल अब भी असो होतो, जिन्ख उन्को हिस्सा नहीं मिल्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","तब यहोशू न इस्राएलियों सी कह्यो, “जो देश तुम्हरो पूर्वजों को परमेश्वर यहोवा न तुम्ख दियो हय, ओख अपनो अधिकार म करन म कब तक ढिलायी करतो रहो? ");
INSERT INTO lbm_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","अब हर एक कुल म सी तीन आदमी चुन लेवो, मय उन्ख ऊ देश म भेजूं कि हि वहां जाय क ओकी जांच करे, अऊर जो जमीन हिस्सा उन्ख अपनो कुल को लायी होना, ओको बारे म लिख ले अऊर मोरो जवर वापस लौट आये। ");
INSERT INTO lbm_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","अऊर हि देश ख सात हिस्सा म बाट ले, यहूदा कुल दक्षिन को तरफ अपनो हिस्सा म, अऊर यूसुफ को घराना को लोग उत्तर को तरफ अपनो हिस्सा म रहे। ");
INSERT INTO lbm_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","अऊर तुम देश की पूरी जानकारी मोरो जवर लावो; अऊर मय यहां तुम्हरो लायी अपनो परमेश्वर यहोवा को सामने चिट्ठी डालूं। ");
INSERT INTO lbm_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","अऊर लेवियों को तुम्हरो बीच म कोयी हिस्सा नहीं मिलेंन, कहालीकि परमेश्वर को दियो हुयो याजकपदच उन्को हिस्सा हय; अऊर गाद, रूबेन, अऊर मनश्शे को अरधो कुल को लोग यरदन को पूर्व दिशा को तरफ परमेश्वर को दास मूसा को दियो हुयो अपनो हिस्सा पा चुक्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","तब हि चुन्यो गयो आदमी उठ क जान लायी तैयार भयो; अऊर जो ऊ देश को हाल लिखन जाय रह्यो होतो उन्ख यहोशू न या आज्ञा दी, “जाय क देश म घूमो फिरो, अऊर ओको हाल लिख क मोरो जवर लौट आवो; अऊर मय यहां शीलो म परमेश्वर को सामने तुम्हरो लायी चिट्ठी डालूं।” ");
INSERT INTO lbm_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","तब हि आदमी चल दियो, अऊर ऊ पूरो देश म घूम्यो, अऊर ओको नगर को सात हिस्सा कर क् उन्को हाल किताब म लिख क शीलो की छावनी म यहोशू को जवर आयो। ");
INSERT INTO lbm_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","तब यहोशू न शीलो म परमेश्वर को सामने उन्को लायी चिट्ठी डाली; अऊर वहां यहोशू न इस्राएलियों ख उन्को हिस्सा को अनुसार देश बाट दियो। ");
INSERT INTO lbm_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","बिन्यामीन को कुल की चिट्ठी उन्को परिवार को अनुसार निकली, अऊर उन्को हिस्सा यहूदा कुल अऊर यूसुफ को कुलों को बीच म होतो। ");
INSERT INTO lbm_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","अऊर उन्की उत्तर दिशा की सीमा यरदन नदी सी शुरू भयी, यरीहो की उत्तर को तरफ सी चढ़ती हुयी पश्चिम को तरफ पहाड़ी देश सी होय क बेतावेन को जंगल म निकली; ");
INSERT INTO lbm_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","वहां सी सीमा लूज ख पहुंची जो बेतेल भी कहलावय हय, अऊर लूज को दक्षिन दिशा सी होतो हुयो खल्लो को बेथोरोन को दक्षिन तरफ की पहाड़ी को जवर अत्रोतद्दार पर उतर गयी। ");
INSERT INTO lbm_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","फिर पश्चिमी सीमा मुड़ क बेथोरोन को सामने अऊर ओको दक्षिन को तरफ को पहाड़ी सी होतो हुयो किर्यतबाल नाम को यहूदा को एक नगर पर निकली जो किर्यत्यारीम भी कहलावय हय; पश्चिम की सीमा याच होती। ");
INSERT INTO lbm_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","फिर दक्षिन को तरफ की सीमा पश्चिम सी शुरू होय क किर्यत्यारीम को छोर सी निकल क नेप्तोह को झरना पर पहुंची; ");
INSERT INTO lbm_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","अऊर वा पहाड़ी को छोर पर उतरी, जो हिन्नोम को टुरा की घाटी को सामने अऊर रपाईम नाम की घाटी को उत्तर दिशा को तरफ हय; वहां सी सीमा हिन्नोम की घाटी म, मतलब यबूस को दक्षिन को तरफ सी होय क एनरोगेल झरना पर उतरी; ");
INSERT INTO lbm_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","वहां सी वा सीमा उत्तर को तरफ मुड़ क एनशेमेश ख निकल क गलीलोत को तरफ गयी, जो अदुम्मीम की चढ़ायी को सामने हय, फिर वहां सी या रूबेन को टुरा बोहन को गोटा तक उतर गयी; ");
INSERT INTO lbm_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","वहां सी वा सीमा उत्तर को तरफ जाय क अराबा को सामने की पहाड़ी को तरफ सी होतो हुयो यरदन नदी की घाटी म उतरी; ");
INSERT INTO lbm_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","वहां सी वा सीमा बेथोग्ला को उत्तर को तरफ सी जाय क खारो समुन्दर को उत्तर तरफ को घाटी म यरदन को मुख पर निकली; या दक्षिन की सीमा होती। ");
INSERT INTO lbm_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","अऊर पूर्व दिशा को तरफ की सीमा यरदन नदी होती। बिन्यामीनियों को हिस्सा, चारयी तरफ की सीमावों सहित, उन्को कुलों को अनुसार, याच होती। ");
INSERT INTO lbm_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","बिन्यामीन कुल को परिवारों ख हि नगर मिल्यो, यरीहो, बेथोग्ला, एमेक्कसीस, ");
INSERT INTO lbm_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","बेतराबा, समारैम, बेतेल, ");
INSERT INTO lbm_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","अव्वीम, पारा, ओप्रा, ");
INSERT INTO lbm_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","कपरम्मोनी, ओफनी अऊर गेबा; हि बारा नगर अऊर इन्को गांव मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","फिर गिबोन, रामा, बेरोत, ");
INSERT INTO lbm_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","मिस्पे, कपीरा, मोसा, ");
INSERT INTO lbm_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","रेकेम, यिर्पेल, तरला, ");
INSERT INTO lbm_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","सेला, एलेप, यबूस जो यरूशलेम भी कहलावय हय, गिबत अऊर किर्यत; हि चौदा नगर अऊर इन्को गांव मिल्यो। बिन्यामीनियों को हिस्सा उन्को कुलों को अनुसार योच होतो। ");
INSERT INTO lbm_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","दूसरी चिट्ठी शिमोन को नाम पर, मतलब शिमोनियों को कुलों को अनुसार उन्को कुल को नाम पर निकली; अऊर उन्को हिस्सा यहूदा को अधिकार को बीच म होतो। ");
INSERT INTO lbm_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","उन्को हिस्सा म हि नगर हय, बेर्शेबा, शेबा, मोलादा, ");
INSERT INTO lbm_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","हसर्शआल, बाला, एसेम, ");
INSERT INTO lbm_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","एलतोलद, बतूल होर्मा, ");
INSERT INTO lbm_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","सिकलग, बेत्मर्काबोत, हसर्शूसा, ");
INSERT INTO lbm_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","बेतलबाओत, शारूहेन; हि तेरा नगर अऊर इन्को गांव उन्ख मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","फिर ऐन, रिम्मोन, ऐतेर, अऊर आशान, हि चार नगर गांव समेत; ");
INSERT INTO lbm_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","अऊर बालत्बेर जो दक्षिन देश को रामा नगर भी कहलावय हय, वहां तक इन नगरों को चारयी तरफ को सब गांव भी उन्ख मिल्यो। शिमोनियों को कुल को हिस्सा उन्को कुलों को अनुसार यहांच ठहरयो। ");
INSERT INTO lbm_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","शिमोनियों को हिस्सा त यहूदा को हिस्सा म सी दियो गयो; कहालीकि यहूदा कुल को हिस्सा उन्को लायी बहुत होतो, यो वजह शिमोनियों को हिस्सा यहूदा को हिस्सा को बीच म मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","तीसरी चिट्ठी जबूलून को कुलों को अनुसार उन्को परिवारों को नाम पर निकली। अऊर उन्को हिस्सा की सीमा सारीद तक पहुंची; ");
INSERT INTO lbm_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","अऊर उन्की सीमा पश्चिम म मरला सी होतो हुयो दब्बेशेत ख पहुंची, अऊर योकनाम को सामने को नाला तक पहुंच गयी; ");
INSERT INTO lbm_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","फिर सारीद सी सीमा पूर्व को तरफ मुड़ क किसलोत्ताबोर की सीमा तक पहुंची, अऊर वहां सी बढ़त बढ़त दाबरत अऊर यापी तक चली गयी होती; ");
INSERT INTO lbm_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","वहां सी सीमा पूर्व को तरफ आगु बढ़ क गथेपेर अऊर इत्कासीन ख गयी, अऊर वा रिम्मोन को तरफ बढ़ गयी जो नेआ दिशा तक फैल्यो हुयो हय; ");
INSERT INTO lbm_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","वहां सी वा सीमा ओको उत्तर को तरफ सी मुड़ क हन्नातोन पर पहुंची; अऊर यिप्तहेल की घाटी म जाय क खतम भयी; ");
INSERT INTO lbm_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","कत्तात, नहलाल, शिम्रोन, यिदला, अऊर बैतलहम; हि गांवो सहित नगरों की संख्या बारा होती। ");
INSERT INTO lbm_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","जबूलून वंश को लोगों ख उन्को परिवारों को अनुसार अधिकार मिल्यो; अऊर ओको म अपनो अपनो गांवो समेत योच नगर आय। ");
INSERT INTO lbm_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","चौथी चिट्ठी इस्साकारियों को कुलों को अनुसार उन्को परिवारों को नाम पर निकली। ");
INSERT INTO lbm_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","अऊर उन्की सीमा यिज्रेल, कसुल्लोत, शूनेम, ");
INSERT INTO lbm_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","हपारैम, शीओन, अनाहरत, ");
INSERT INTO lbm_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","रब्बीत, किश्योन, एबेस, ");
INSERT INTO lbm_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","रेमेत, एनगन्नीम, एनहद्दा, अऊर बेत्पस्सेस तक पहुंची। ");
INSERT INTO lbm_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","फिर वा सीमा ताबोर, शहसूमा अऊर बेतशेमेश तक पहुंची, अऊर उन्की सीमा यरदन नदी पर खतम भयी; यो तरह गांवो समेत सोला नगर होतो। ");
INSERT INTO lbm_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","कुलों को अनुसार इस्साकारियों वंश को हिस्सा नगरों अऊर गांवो समेत दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","पाचवी चिट्ठी आशेर को वंश को परिवारों को नाम पर निकली। ");
INSERT INTO lbm_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","उन्की सीमा म हेल्कत, हली, बेतेन, अक्षाप, ");
INSERT INTO lbm_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","अल्लाम्मेलेक, अमाद, अऊर मिशाल होतो; अऊर ऊ पश्चिम को तरफ कर्मेल तक अऊर शीहोर्लिब्नात तक पहुंची; ");
INSERT INTO lbm_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","फिर वा सीमा पूर्व दिशा को तरफ मुड़ क बेतदागोन ख गयी, अऊर जबूलून को हिस्सा तक, अऊर यिप्तहेल की घाटी सी उत्तर दिशा को तरफ सी होय क बेतेमेक अऊर नीएल तक पहुंची; अऊर उत्तर को तरफ जाय क काबूल पर निकली, ");
INSERT INTO lbm_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","अऊर वा एब्रोन, रहोब, हम्मोन, अऊर काना सी होय क बड़ो सीदोन ख गयी; ");
INSERT INTO lbm_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","वहां सी वा सीमा मुड़ क रामा सी होतो हुयो सोर नाम को गढ़ वालो नगर तक चली गयी; फिर सीमा होसा को तरफ मुड़ क अऊर अकजीब को जवर को देश सी होय क समुन्दर पर खतम भयी, ");
INSERT INTO lbm_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","उम्मा, अपेक, अऊर रहोब भी होतो; यो तरह बावीस नगर अपनो गांवो समेत ओख मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","कुलों को अनुसार आशेरियों को वंश को हिस्सा नगरों अऊर गांवो समेत यहांच मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","छठवी चिट्ठी नप्ताली वंशों को अनुसार उन्को परिवारों को नाम पर निकली। ");
INSERT INTO lbm_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","अऊर उन्की सीमा हेलेप सी, अऊर सानन्नीम को बांझ झाड़ सी, अदामीनेकेब अऊर यब्नेल सी होय क, अऊर लक्कूम ख जाय क यरदन पर खतम भयी; ");
INSERT INTO lbm_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","वहां सी वा सीमा पश्चिम को तरफ मुड़ क अजनोत्ताबोर ख गयी, अऊर वहां सी हुक्कोक ख गयी, अऊर दक्षिन, अऊर जबूलून को हिस्सा तक, अऊर पश्चिम को तरफ आशेर को हिस्सा तक, अऊर पूर्व को तरफ यहूदा को हिस्सा को जवर की यरदन नदी पर निकली। ");
INSERT INTO lbm_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","अऊर उन्को गढ़ वालो नगर यो आय, मतलब सिद्दीम, शेर, हम्मत, रक्कत, किन्नेरेत, ");
INSERT INTO lbm_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","अदामा, रामा, हासोर, ");
INSERT INTO lbm_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","केदेश, एद्रेई, एन्हासोर, ");
INSERT INTO lbm_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","यिरोन, मिगदलेल, होरेम, बेतनात, अऊर बेतशेमेश; हि उन्नीस नगर गांवो समेत ओख मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","कुलों को अनुसार नप्तालियों को वंश को हिस्सा नगरों अऊर गांवो समेत यहांच मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","सातवी चिट्ठी कुलों को अनुसार दान को वंश को नाम पर निकली। ");
INSERT INTO lbm_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","अऊर उन्को हिस्सा को सीमा म सोरा, एशताओल, ईरशेमेश, ");
INSERT INTO lbm_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","शालब्बीन, अय्यालोन, यितला, ");
INSERT INTO lbm_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","एलोन, तिम्ना, एक्रोन, ");
INSERT INTO lbm_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","एलतके, गिब्बतोन, बालात ");
INSERT INTO lbm_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","यहूद, बनेबराक, गत्रिम्मोन, ");
INSERT INTO lbm_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","मेयर्कोन, अऊर रक्कोन, अऊर याफा को सामने की सीमा भी उन्की होती। ");
INSERT INTO lbm_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","अऊर दानियों को हिस्सा येको सी जादा भय गयो, मतलब दान को लोगों न लेशेम पर चढ़ायी करी, अऊर उन्ख तलवार सी मार डाल्यो, अऊर ओख अपनो अधिकार म कर क् ओको म बस गयो, अऊर अपनो मुख्य आदमी को नाम पर लेशेम को नाम दान रख्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","कुलों को अनुसार दानियों को वंश को हिस्सा नगरों अऊर गांवो समेत यहांच मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","जब देश को बाट्यो जानो सीमावों को अनुसार पूरो भय गयो, तब इस्राएलियों न नून को टुरा यहोशू ख भी अपनो बीच म एक हिस्सा दियो। ");
INSERT INTO lbm_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","परमेश्वर को कहन को अनुसार उन्न ओख ओको मांग्यो हुयो नगर दियो, यो एप्रैम को पहाड़ी देश म को तिम्नत्सेरह हय; अऊर ऊ ऊ नगर ख फिर सी बसाय क ओको म रहन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","जो जो हिस्सा एलीआजार याजक, अऊर नून को टुरा यहोशू, अऊर इस्राएलियों को वंश को घराना को पूर्वजों को मुख्य मुख्य आदमियों न शीलो म, मिलापवालो तम्बू को फाटक पर, परमेश्वर को सामने चिट्ठी डाल क बाट दियो हि योच आय। यो तरह उन्न देश बाटन को काम पूरो करयो। ");
INSERT INTO lbm_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","फिर परमेश्वर न यहोशू सी कह्यो, ");
INSERT INTO lbm_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“इस्राएलियों सी यो कहो, ‘मय न मूसा को द्वारा तुम सी शरन नगर की जो चर्चा करी होती ओको अनुसार उन्ख ठहराय लेवो, ");
INSERT INTO lbm_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","जेको सी जो कोयी भूल सी यां अनजानो म कोयी ख मार डाले, ऊ वहां सी भग क शरन ले सके; येकोलायी यो नगर खून को बदला लेन वालो सी बचन लायी तुम्हरो शरन नगर ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","ऊ कोयी भी शरन नगर म भग क जाये, अऊर ऊ नगर की फाटक पर खड़ो होय क उन बुजूर्गों ख अपनी हकिकत बताये; बुजूर्गों ओख अपनो नगर म ले जाये, अऊर ओख रहन लायी जागा दे, जेको म ऊ उन्को संग रहे। ");
INSERT INTO lbm_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","अऊर खून को बदला लेन वालो ओको पीछा करतो हुयो आये, त बुजूर्गों यो जान क कि ओन अपनो पड़ोसी ख अनजानो म, ओन ओको सी बिना दुस्मनी रख्यो ओख मारयो, येकोलायी ऊ खूनी ख ओको हाथ म नहीं देयेंन। ");
INSERT INTO lbm_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","अऊर जब तक ऊ मण्डली को सामने न्याय को लायी खड़ो नहीं होयेंन, अऊर जब तक उन दिनों को महायाजक नहीं मर जाये, तब तक ऊ उच नगर म रहेंन; ओको बाद ऊ खूनी अपनो नगर ख जहां सी ऊ भग क आयो होना अपनो घर म लौट जाये।’” ");
INSERT INTO lbm_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","येकोलायी उन्न नप्ताली को पहाड़ी देश म गलील को केदेश नगर ख, अऊर एप्रैम को पहाड़ी देश म शकेम नगर ख, अऊर यहूदा को पहाड़ी देश म किर्यतर्बा नगर ख, जो हेब्रोन भी कहलावय हय शरन नगर ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","अऊर यरीहो को जवर को यरदन को पूर्व दिशा को तरफ उन्न रूबेन को वंश को हिस्सा म बेसेर नगर ख, जो जंगल म चौरस जमीन पर बस्यो हुयो हय, अऊर गाद को वंश को हिस्सा म गिलाद को रामोत ख, अऊर मनश्शे को वंश को हिस्सा म बाशान को गोलान नगर ख ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","पूरो इस्राएलियों लायी, अऊर उन्को बीच म रहन वालो परदेशियों लायी भी, जो नगर यो मनसा सी ठहरायो गयो कि जो कोयी कोयी प्रानी ख भूल सी मार डाले ऊ उन म सी कोयी भी नगर म भग जाये, अऊर जब तक न्याय लायी मण्डली को सामने खड़ो नहीं होयेंन, तब तक खून को बदला लेन वालो ओख मार नहीं पाये, हि हिच नगर आय। ");
INSERT INTO lbm_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","तब लेवियों को पूर्वजों को परिवारों को मुख्य आदमी एलीआजार याजक, अऊर नून को टुरा यहोशू, अऊर इस्राएली वंश को पूर्वजों को परिवारों को मुख्य आदमियों को जवर आय क ");
INSERT INTO lbm_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","कनान देश को शीलो नगर म कहन लग्यो, “परमेश्वर न मूसा को द्वारा हम्ख बसन लायी नगर, अऊर हमरो जनावरों ख चरावन लायी मैदान भी देन की आज्ञा दी होती।” ");
INSERT INTO lbm_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","तब इस्राएलियों न परमेश्वर को कहन को अनुसार अपनो अपनो हिस्सा म सी लेवियों ख चराइयों समेत हि नगर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","तब कहात जाति को कुलों को नाम पर चिट्ठी निकली। येकोलायी लेवियों म सी हारून याजक को वंश को यहूदा, शिमोन, अऊर बिन्यामीन को वंशों को हिस्सा म सी तेरा नगर मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","बाकी कहात जातियों ख एप्रैम को वंश, दान को वंश, अऊर मनश्शे को अरधो वंश को हिस्सा म सी चिट्ठी डाल क दस नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","फिर गेर्शोनियों ख इस्साकार को वंश को परिवार, अऊर आशेर, अऊर नप्ताली को वंशों को हिस्सा म सी, अऊर मनश्शे को ऊ अरधो वंश को हिस्सा म सी भी जो बाशान प्रदेश म होतो चिट्ठी डाल क तेरा नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","वंशों को अनुसार मरारी वंश ख रूबेन, गाद, अऊर जबूलून को वंशों को हिस्सा म सी बारा नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","जो आज्ञा परमेश्वर न मूसा को द्वारा दी होती ओको अनुसार इस्राएलियों न लेवियों ख चारागाह जमीन समेत यो नगर चिट्ठी डाल क दियो। ");
INSERT INTO lbm_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","उन्न यहूदियों अऊर शिमोनियों को वंशों को हिस्सा म सी यो नगर जिन को नाम लिख्यो हंय दियो; ");
INSERT INTO lbm_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","हि नगर लेवीय कहाती वंशों म सी हारून को वंश लायी होतो; कहालीकि पहिली चिट्ठी उन्कोच नाम पर निकली होती। ");
INSERT INTO lbm_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","मतलब उन्न उन्ख यहूदा को पहाड़ी देश म चारयी तरफ की चराइयों समेत किर्यतर्बा नगर दे दियो, जो अर्बा अनाक को बाप होतो जो हेब्रोन भी कहलावय हय। ");
INSERT INTO lbm_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","पर ऊ नगर को खेत अऊर ओको गांव उन्न यपुन्ने को टुरा कालेब ख ओकी निजी जमीन कर क् दे दियो। ");
INSERT INTO lbm_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","तब उन्न हारून याजक को वंश ख चराइयों समेत खूनी को शरन नगर हेब्रोन, अऊर अपनी अपनी चराइयों समेत लिब्ना, ");
INSERT INTO lbm_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","यत्तीर, एश्तमो, ");
INSERT INTO lbm_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","होलोन, दबीर, ");
INSERT INTO lbm_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ऐन, युत्ता अऊर बेतशेमेश दियो; यो तरह उन दिनों वंशों को हिस्सा म सी नव नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","अऊर बिन्यामीन को वंश को हिस्सा म सी अपनी अपनी चराइयों समेत हि चार नगर दियो गयो, मतलब गिबोन, गेबा, ");
INSERT INTO lbm_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","अनातोत अऊर अल्मोन। ");
INSERT INTO lbm_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","यो तरह हारूनवंशी याजकों ख तेरा नगर अऊर चराइयां मिली। ");
INSERT INTO lbm_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","फिर बाकी कहाती को लेवी वंश को परिवारों ख एप्रैम को हिस्सा म सी कुछ नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","मतलब उन्ख चराइयों समेत एप्रैम को पहाड़ी देश म खूनी ख शरन लेन ख शकेम नगर दियो गयो, फिर अपनी चराइयों समेत गेजेर, ");
INSERT INTO lbm_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","किबसैम, अऊर बेथोरोन; हि चार नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","अऊर दान को वंश को हिस्सा म सी अपनी अपनी चराइयों समेत, एलतके, गिब्बतोन, ");
INSERT INTO lbm_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","अय्यालोन, अऊर गत्रिम्मोन; हि चार नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","अऊर मनश्शे को अरधो वंश को हिस्सा म सी अपनी अपनी चराइयों समेत तानाक अऊर गत्रिम्मोन; हि दोय नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","यो तरह बाकी कहातियों को वंश को सब नगर चराइयों समेत दस नगर होतो। ");
INSERT INTO lbm_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","फिर लेवियों को वंशों म सी गेर्शोनियों ख मनश्शे को अरधो वंश को हिस्सा म सी अपनी अपनी चराइयों समेत खूनी को शरन नगर बाशान प्रदेश को गोलान अऊर बेशतरा; हि दोय नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","अऊर इस्साकार को वंश को हिस्सा म सी अपनी अपनी चराइयों समेत किश्योन, दाबरत, ");
INSERT INTO lbm_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","यर्मूत, अऊर एनगन्नीम; हि चार नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","अऊर आशेर को वंश को हिस्सा म सी अपनी अपनी चराइयों समेत मिशाल, अब्दोन, ");
INSERT INTO lbm_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","हेल्कात, अऊर रहोब; हि चार नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","अऊर नप्ताली को वंश को हिस्सा म सी अपनी अपनी चराइयों समेत खूनी को शरन नगर गलील प्रदेश को केदेश नगर, हम्मोतदोर, अऊर कर्तान; हि तीन नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","गेर्शोनियों को वंशों को अनुसार उन्को सब नगर अपनी अपनी चराइयों समेत तेरा होतो। ");
INSERT INTO lbm_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","फिर बाकी लेवियों, मतलब मरारियों को वंशों ख जबूलून को वंश को हिस्सा म सी अपनी चराइयों समेत योकनाम, कर्ता, ");
INSERT INTO lbm_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","दिम्ना, अऊर नहलाल; हि चार नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","अऊर रूबेन को वंश को हिस्सा म सी अपनी चराइयों समेत बेसेर, यहसा, ");
INSERT INTO lbm_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","कदेमोत, अऊर मेपात; हि चार नगर दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","अऊर गाद को वंश को हिस्सा म सी अपनी चराइयों समेत खूनी को शरन नगर गिलाद प्रदेश म को रामोत, महनैम, ");
INSERT INTO lbm_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","हेशबोन, अऊर याजेर, यो सब मिलाय क चार नगर हंय, दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","लेवियों को बाकी वंशों मतलब मरारियों को वंशों को अनुसार उन्ख बारा नगर चिट्ठी डाल क दियो गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","इस्राएलियों की निजी जमीन को बीच लेवियों को सब नगर अपनी चराइयों समेत अड़तालीस हय। ");
INSERT INTO lbm_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","हि सब नगर अपनो चारयी तरफ की चराइयों को संग होती; इन सब नगरों की याच दशा होती। ");
INSERT INTO lbm_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","यो तरह परमेश्वर न इस्राएलियों ख ऊ पूरो देश दियो, जेक ओन उन्को पूर्वजों सी कसम खाय क देन ख कह्यो होतो; अऊर हि ओको अधिकारी होय क ओको म बस गयो। ");
INSERT INTO lbm_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","अऊर परमेश्वर न उन सब बातों को अनुसार, जो ओन उन्को पूर्वजों सी कसम खाय क कही होती, उन्ख चारयी तरफ सी आराम दियो; अऊर उन्को दुस्मनों म सी कोयी भी उन्को सामने टिक नहीं सक्यो; परमेश्वर न उन सब ख उन्को वश म कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","जितनी भलायी की बाते परमेश्वर न इस्राएल को घराना सी कही होती ओको म सी कोयी बात भी नहीं छूटी; सब की सब पूरी भयी। ");
INSERT INTO lbm_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","ऊ समय यहोशू न रूबेनियों, गादियों, अऊर मनश्शे को अरधो वंश को लोगों ख बुलाय क कह्यो, ");
INSERT INTO lbm_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","जो जो आज्ञा परमेश्वर को दास मूसा न तुम्ख दी होती हि सब तुम न मानी हय, अऊर जो जो आज्ञा मय न तुम्ख दी हंय उन सब ख भी तुम न मान्यो हय; ");
INSERT INTO lbm_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","तुम न अपनो भाऊवों ख इतनो दिनों म अज तक नहीं छोड़्यो, पर अपनो परमेश्वर यहोवा की आज्ञा तुम न अच्छो सी पालन करयो। ");
INSERT INTO lbm_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","अऊर अब तुम्हरो परमेश्वर यहोवा न तुम्हरो भाऊवों ख अपनो वचन को अनुसार आराम दियो हय; येकोलायी अब तुम लौट क अपनो डेरा ख, अऊर अपनी निजी भूमि म, जेक परमेश्वर को सेवक मूसा न यरदन को ओन पार तुम्ख दियो हय, चली जावो। ");
INSERT INTO lbm_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","केवल या बात की पूरी चौकसी करो कि जो जो आज्ञा अऊर व्यवस्था परमेश्वर को सेवक मूसा न तुम्ख दी हय ओख मान क अपनो परमेश्वर यहोवा सी प्रेम रखो, ओको पूरो रस्ता पर चलो, ओकी आज्ञाये मानो, ओकी भक्ति म लवलीन रहो, अऊर अपनो पूरो मन अऊर पूरो जीव सी ओकी सेवा करो। ");
INSERT INTO lbm_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","तब यहोशू न उन्ख आशीर्वाद दे क बिदा करयो अऊर हि अपनो अपनो डेरा ख चली गयो। ");
INSERT INTO lbm_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","मनश्शे को अरधो वंश को लोगों ख मूसा न बाशान प्रदेश म हिस्सा दियो होतो; पर दूसरो अरधो वंश ख यहोशू न उन्को भाऊवों को बीच म यरदन को पश्चिम दिशा को तरफ हिस्सा दियो। उन्ख जब यहोशू न बिदा करयो कि हि अपनो डेरा ख चली जाये, ");
INSERT INTO lbm_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","तब उन्ख भी आशीर्वाद दे क कह्यो, “बहुत सो जनावर, अऊर चांदी, सोनो, पीतल, लोहा, अऊर बहुत सो कपड़ा, अऊर बहुत धन सम्पत्ति ले क अपनो डेरा ख चली जावो; अऊर अपनो दुस्मनों की लूटी हुयी सम्पत्ति अपनो भाऊवों को संग बाट लेवो।” ");
INSERT INTO lbm_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","तब रूबेनी, गादी, अऊर मनश्शे को अरधो वंश को लोग इस्राएलियों को जवर सी, मतलब कनान देश को शीलो नगर सी, अपनी गिलाद नाम की निजी जमीन म, जो मूसा को द्वारा दी गयी परमेश्वर की आज्ञा को अनुसार उन्की निजी जमीन भय गयी होती, लौट गयो। ");
INSERT INTO lbm_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","जब रूबेनी, गादी, अऊर मनश्शे को अरधो वंश को लोग यरदन नदी को किनार पर स्थित गलीलोत नगर म पहुंच्यो जो कनान देश म हय, उन्न वहां एक बड़ी अऊर प्रभावशाली वेदी बनायी। ");
INSERT INTO lbm_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","अऊर इस्राएलियों न सुन्यो कि, रूबेनियों, गादियों, अऊर मनश्शे को अरधो वंश को लोगों न कनान देश की सीमा पर यरदन नदी को ओन पार हमरो क्षेत्र को सामने गलीलोत म एक वेदी बनायी हय। ");
INSERT INTO lbm_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","जब इस्राएल को लोगों न यो सुन्यो, तब इस्राएल की पूरी मण्डली उन सी लड़न लायी शीलो म जमा भयी। ");
INSERT INTO lbm_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","तब इस्राएलियों न रूबेनियों, गादियों, अऊर मनश्शे को अरधो वंश को लोगों को जवर गिलाद देश म एलीआजार याजक को टुरा पीनहास ख, ");
INSERT INTO lbm_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","अऊर ओको संग दस मुखियावों ख, मतलब इस्राएल को एक एक वंश म सी पूर्वजों को घराना म को एक एक मुखिया ख भेज्यो, अऊर हि इस्राएल को हजारों म अपनो अपनो पूर्वजों को घराना को मुख्य आदमी होतो। ");
INSERT INTO lbm_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","हि गिलाद देश म रूबेनियों, गादियों, अऊर मनश्शे को अरधो वंश को लोगों जवर जाय क कहन लग्यो, ");
INSERT INTO lbm_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“परमेश्वर की पूरी मण्डली यो कह्य हय, ‘तुम न इस्राएल को परमेश्वर यहोवा को यो कसो विश्वासघात करयो; अज त तुम न एक वेदी बनाय लियो हय, येको म तुम न ओको पीछू चलनो छोड़ क ओको खिलाफ अज विद्रोह करयो हय? ");
INSERT INTO lbm_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","सुनो, जो पोर नगर को अधर्म हमरो लायी कुछ कम होतो? ऊ अधर्म को वजह प्रभु की मण्डली को ऊपर महामारी आयी होती, हम अज भी ऊ अधर्म सी शुद्ध नहीं भयो हय; का वा तुम्हरी नजर म छोटी सी बात आय ");
INSERT INTO lbm_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","कि अज तुम परमेश्वर ख त्याग क ओको पीछू चलनो छोड़ देवय हय? यदि तुम परमेश्वर सी फिर जावय हय, त कल ऊ इस्राएल की पूरी मण्डली सी गुस्सा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","पर यदि तुम्हरी निजी भूमि अशुद्ध होना, त परमेश्वर की निजी भूमि म आय जावो जहां परमेश्वर को निवास रह्य हय, हम लोगों को बीच म अपनी अपनी निजी भूमि कर लेवो; पर हमरो परमेश्वर यहोवा की वेदी ख छोड़ क अऊर नहीं कोयी वेदी बनाय क परमेश्वर सी विद्रोह करो, अऊर नहीं हम सी। ");
INSERT INTO lbm_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","देखो, जब जेरह को टुरा आकान न भेंट करी हुयी चिज को बारे म विश्वासघात करयो, तब परमेश्वर को कोप इस्राएल की पूरी मण्डली पर भड़क्यो? अऊर ऊ आदमी को अधर्म की सजा अकेलो ओखच नहीं मिली।’” ");
INSERT INTO lbm_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","तब रूबेनियों, गादियों, अऊर मनश्शे को अरधो वंश को लोगों न इस्राएली मुखियावों ख यो उत्तर दियो, ");
INSERT INTO lbm_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“परमेश्वर जो एक ईश्वरों को परमेश्वर आय! ऊ परमेश्वर यहोवा ओख जानय हय, अऊर इस्राएली भी येख जान लेयेंन कि यदि परमेश्वर सी फिर क यां ओको विश्वासघात कर क् हम न यो काम करयो होना, त तय हम्ख जीन्दो मत छोड़, ");
INSERT INTO lbm_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","यदि हम न वेदी ख येकोलायी बनायो होना कि परमेश्वर को पीछू चलनो छोड़ दे, यां येकोलायी कि ओको पर होमबलि, अन्नबलि, यां मेलबलि चढ़ाये, त परमेश्वर खुद येको हिसाब लेयेंन; ");
INSERT INTO lbm_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","पर हम न योच बिचार अऊर मनसा सी यो करयो हय कि कहीं भविष्य म तुम्हरी सन्तान हमरी सन्तान सी यो नहीं कहन लगे, ‘तुम्ख इस्राएल को परमेश्वर यहोवा सी का काम? ");
INSERT INTO lbm_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","कहालीकि हे रूबेनियों, हे गादियों, परमेश्वर न तुम्हरो अऊर हमरो बीच म यरदन ख सीमा बनाय दियो हय, येकोलायी परमेश्वर को संग तुम्हरो कोयी साझा नहाय।’ यो तरह तुम्हरी सन्तान अऊर हमरी सन्तान म सी परमेश्वर को डर खतम कर देयेंन। ");
INSERT INTO lbm_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","येकोलायी हम न कह्यो, ‘आवो, हम अपनो लायी एक वेदी बनाय लेबो, वा होमबलि यां मेलबलि को लायी नहीं, ");
INSERT INTO lbm_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","पर येकोलायी कि हमरो अऊर तुम्हरो, अऊर हमरो बाद हमरो अऊर तुम्हरो वंश को बीच म एक संकेत को रूप म काम दे; येकोलायी कि हम होमबलि, मेलबलि, अऊर बलिदान चढ़ाय क परमेश्वर को सामने ओकी उपासना करे; अऊर भविष्य म तुम्हरी सन्तान हमरी सन्तान सी यो नहीं कहनो पाये, कि परमेश्वर को संग तुम्हरो कोयी साझा नहाय।’ ");
INSERT INTO lbm_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","येकोलायी हम न कह्यो, ‘जब हि लोग भविष्य म हम सी यां हमरो वंश सी कभी कहन लगेंन, तब हम उन सी कहबोंन, कि परमेश्वर कि वेदी को नमुना पर बनी हुयी या वेदी ख देखो, जेक हमरो पूर्वजों न होमबलि यां मेलबलि को लायी नहीं बनायो; पर येकोलायी बनायो होतो कि हमरो अऊर तुम्हरो बीच म एक गवाह बनन लायी काम दे।’ ");
INSERT INTO lbm_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","या हम सी दूर रहे कि परमेश्वर सी फिर क अज ओको पीछू चलनो छोड़ देबो, अऊर अपनो परमेश्वर यहोवा की वा वेदी ख छोड़ क जो ओको निवास को सामने हय होमबलि, अऊर अन्नबलि यां मेलबलि, लायी दूसरी वेदी बनायबो।” ");
INSERT INTO lbm_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","रूबेनियों, गादियों, अऊर मनश्शे को अरधो वंश को लोगों की इन बातों ख सुन्क पीनहास याजक अऊर ओको संग मण्डली को मुखिया, जो इस्राएल को मुख्य आदमी होतो, हि बहुत खुश भयो। ");
INSERT INTO lbm_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","अऊर एलीआजार याजक को टुरा पीनहास न रूबेन, गाद, अऊर मनश्शे को लोगों सी कह्यो, “तुम न परमेश्वर को विश्वासघात नहीं करयो, येकोसी हम न यो जान लियो कि परमेश्वर हमरो बीच म हय : अऊर तुम लोगों न इस्राएलियों ख परमेश्वर को हाथों सी सजा होन सी बचाय लियो हय।” ");
INSERT INTO lbm_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","तब एलीआजार को टुरा पीनहास मुखियावों समेत रूबेनियों अऊर गादियों को जवर सी गिलाद होतो हुयो कनान देश म इस्राएलियों को जवर लौट गयो : अऊर यो समाचार उन्ख सुनायो। ");
INSERT INTO lbm_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","तब इस्राएल को लोग खुश भयो; अऊर परमेश्वर ख धन्य कह्यो, अऊर रूबेनियों अऊर गादियों सी लड़न अऊर उन्को रहन को देश उजाड़न लायी चढ़ायी करन की चर्चा फिर नहीं करी। ");
INSERT INTO lbm_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","अऊर रूबेन अऊर गाद को लोगों न यो कह्य क, “या वेदी हमरो अऊर उन्को बीच म गवाह हय, कि यहोवाच परमेश्वर आय;” ऊ वेदी को नाम एद रख्यो। ");
INSERT INTO lbm_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","बहुत दिन को बाद, जब परमेश्वर न इस्राएलियों ख उन्को आजु-बाजू को दुस्मनो सी आराम दियो, अऊर यहोशू बूढ्ढा अऊर बहुत उमर को भय गयो होतो, ");
INSERT INTO lbm_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","तब यहोशू सब इस्राएलियों ख, अऊर बुजूर्गों, मुख्य आदमियों, न्यायियों, अऊर सरदारों ख बुलाय क कहन लग्यो, “मय त अब बूढ्ढा अऊर बहुत उमर को भय गयो हय; ");
INSERT INTO lbm_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","अऊर जो तुम न देख्यो हय कि तुम्हरो परमेश्वर यहोवा न तुम्हरो वजह इन सब जातियों को संग का का करयो हय, कहालीकि जो तुम्हरो तरफ सी लड़तो आयो हय ऊ तुम्हरो परमेश्वर यहोवा आय। ");
INSERT INTO lbm_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","देखो, मय न बची हुयी जातियों ख तुम्हरो वंश को हिस्सा बाट दियो हय; अऊर यरदन नदी सी ले क पश्चिम को तरफ को बड़ो समुन्दर तक रहन वाली उन सब जातियों ख भी असोच दियो हय, जिन्को मय न नाश कर डाल्यो हय। ");
INSERT INTO lbm_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","अऊर तुम्हरो परमेश्वर यहोवा उन्ख तुम्हरो सामने सी उन्को देश सी निकाल देयेंन; अऊर तुम अपनो परमेश्वर यहोवा को वचन को अनुसार उन्को देश को अधिकारी होय जावो। ");
INSERT INTO lbm_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","येकोलायी बहुत हिम्मत बान्ध क, जो कुछ मूसा की व्यवस्था की किताब म लिख्यो हय ओको पूरो करन म सावधान रहो, ओको सी नहीं त दायो मुड़ो अऊर नहीं बायो तरफ। ");
INSERT INTO lbm_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","हि जो जातियां तुम्हरो बीच म रह्य गयी हंय इन्को बीच म मत जावो, अऊर नहीं इन्को देवतावों को नाम की चर्चा करो, अऊर नहीं इन्की कसम खिलावो, अऊर नहीं उन्ख दण्डवत करो, ");
INSERT INTO lbm_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","पर जसो अज भी तुम अपनो परमेश्वर यहोवा की भक्ति म लवलीन रह्य हय, वसोच रह्यो करो। ");
INSERT INTO lbm_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","परमेश्वर न तुम्हरो सामने सी बड़ी अऊर शक्तिशाली जातियों ख निकाल्यो हय; अऊर तुम्हरो सामने अज तक कोयी ठहर नहीं सक्यो। ");
INSERT INTO lbm_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","तुम म सी एक आदमी हजार आदमियों भगाय सकय हय, कहालीकि तुम्हरो परमेश्वर यहोवा अपनो वचन को अनुसार तुम्हरो तरफ सी लड़य हय। ");
INSERT INTO lbm_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","येकोलायी अपनो परमेश्वर यहोवा सी प्रेम रखन लायी सदा चौकस रहो। ");
INSERT INTO lbm_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","कहालीकि यदि तुम कोयी रीति सी परमेश्वर सी फिर क इन जातियों को बाकी लोगों सी घुल-मिल जावो जो तुम्हरो बीच म बच्यो हुयो रह्य हंय, अऊर इन सी शादी बिहाव कर क् इन्को संग समधियाना रिस्ता जोड़ो, ");
INSERT INTO lbm_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","त जरूर जान लेवो कि तुम्हरो परमेश्वर यहोवा इन जातियों ख तुम्हरो सामने सी नहीं निकालेंन; अऊर हि तुम्हरो लायी जाल अऊर फन्दा, अऊर तुम्हरो पीठ पर कोड़ा, अऊर तुम्हरी आंखी म काटा को जसो खतरनाक ठहरेंन, अऊर आखरी म तुम या अच्छी जमीन पर सी जो तुम्हरो परमेश्वर यहोवा न तुम्ख दियो हय नाश होय जावो। ");
INSERT INTO lbm_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“सुनो, मय त अब मृत्यु की गति पर जान वालो हय, अऊर तुम सब अपनो अपनो दिल अऊर मन म जानय हय, कि जितनी भलायी की बाते हमरो परमेश्वर यहोवा न हमरो बारे म कही हय उन्म सी एक भी पूरी हुयी बिना नहीं रही; हि सब की सब तुम पर घट गयी हंय, उन्म सी एक भी पूरी हुयी बिना नहीं रही। ");
INSERT INTO lbm_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","त जसो तुम्हरो परमेश्वर यहोवा की कही हुयी सब भलायी की बाते तुम पर घटी हय; वसो परमेश्वर यहोवा विपत्ति की सब बाते भी तुम पर लगायेंन अऊर तुम्ख या अच्छी जमीन को ऊपर सी, जेक तुम्हरो परमेश्वर यहोवा न तुम्ख दियो हय, नाश कर डालेंन। ");
INSERT INTO lbm_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","जब तुम ऊ वाचा की, जेक तुम्हरो परमेश्वर यहोवा न तुम्ख आज्ञा दी हय, उल्लंघन कर क् परायो देवतावों की उपासना अऊर उन्ख दण्डवत करन लगो, तब परमेश्वर को कोप तुम पर भड़केंन, अऊर तुम यो अच्छो देश म सी जेक ओन तुम्ख दियो हय तुरतच नाश होय जावो।” ");
INSERT INTO lbm_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","यहोशू न इस्राएलियों को सब वंश को लोगों ख शकेम नगर म जमा करयो, अऊर इस्राएल को बुजूर्ग लोगों ख अऊर मुख्य आदमियों, अऊर न्यायियों, अऊर सरदारों ख बुलायो; अऊर हि परमेश्वर को सामने मौजूद भयो। ");
INSERT INTO lbm_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","तब यहोशू न उन सब लोगों सी कह्यो, “इस्राएल को परमेश्वर यहोवा यो तरह कह्य हय, ‘प्राचिन काल म अब्राहम अऊर नाहोर को बाप तेरह पहले, तुम्हरो पूर्वज फरात नदी को ओन पार रहत होतो, हि दूसरो देवतावों की पूजा करत होतो। ");
INSERT INTO lbm_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","अऊर मय न तुम्हरो पूर्वज अब्राहम ख फरात नदी को ओन पार सी लियो अऊर ओख पूरो कनान देश घुमायो, अऊर मय न ओको वंश बढ़ायो। अऊर ओख इसहाक ख दियो; ");
INSERT INTO lbm_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","फिर मय न इसहाक ख याकूब अऊर एसाव दियो। अऊर एसाव ख मय न सेईर नाम की पहाड़ी देश दियो कि ऊ ओको अधिकारी होय सके, पर याकूब अऊर ओको टुरा मिस्र देश ख चली गयो। ");
INSERT INTO lbm_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","फिर मय न मूसा अऊर हारून ख भेज क उन सब कामों को द्वारा जो मय न मिस्र देश म करयो, ऊ देश ख नाश कर दियो; अऊर ओको बाद वहां सी तुम्ख बाहेर निकाल लायो। ");
INSERT INTO lbm_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","अऊर मय न तुम्हरो पूर्वजों ख मिस्र देश म सी निकाल लायो, अऊर तुम लाल समुन्दर पर पहुंच्यो; अऊर मिस्रियों न रथों अऊर घुड़सवारों ख ले क लाल समुन्दर तक तुम्हरो पीछा करयो। ");
INSERT INTO lbm_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","अऊर जब तुम न यहोवा की दोहायी दी, अऊर मय न उन्को अऊर मिस्रियों को बीच अन्धियारो कर दियो, अऊर मय न उन पर समुन्दर ख बहाय क उन्ख डुबाय दियो; अऊर जो कुछ मय न मिस्र म करयो ओख तुम लोगों न अपनी आंखी सी देख्यो;’” “फिर तुम बहुत समय तक जंगल म रह्यो।” ");
INSERT INTO lbm_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","तब मय तुम्ख उन एमोरी जाति को देश म लायो, जो यरदन नदी को पूर्व दिशा म बस्यो होतो; अऊर हि तुम सी युद्ध करयो, अऊर मय न उन्ख तुम्हरो हाथ म सौंप दियो, अऊर तुम उन्को देश को अधिकारी भय गयो, अऊर मय न एमोरी जाति ख तुम्हरो सामने नाश कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","फिर मोआब को राजा सिप्पोर को टुरा बालाक इस्राएल सी लड़न तैयार भयो; अऊर तुम्ख श्राप देन लायी बोर को टुरा बिलाम ख बुलावा भेज्यो, ");
INSERT INTO lbm_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","पर मय न बिलाम की नहीं सुनी; ऊ तुम्ख आशीषच आशीष देतो गयो; यो तरह मय न तुम्ख ओको हाथ सी बचायो। ");
INSERT INTO lbm_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","तब तुम यरदन नदी पार होय क यरीहो को जवर आयो, अऊर जब यरीहो को लोग, अऊर एमोरी, परिज्जी, कनानी, हित्ती, गिर्गाशी, हिब्बी, अऊर यबूसी तुम सी लड़्यो, तब मय न उन्ख तुम्हरो वश म कर दियो। ");
INSERT INTO lbm_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","अऊर मय न तुम्हरो आगु बर्रों को आतंक भेज्यो, अऊर उन्न एमोरियों को दोयी राजावों ख तुम्हरो सामने सी निकाल दियो; देखो, या तुम्हरी तलवार यां धनुष को बल पर नहीं भयो। ");
INSERT INTO lbm_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","फिर मय न तुम्ख असो देश दियो होतो, अऊर असो नगर भी दियो हय जिन्ख तुम न नहीं बसायो होतो, अऊर तुम ओको म निवास करय हय; अऊर जो अंगूर अऊर जैतून को बगीचा को फर तुम खावय हय उन्ख तुम न नहीं लगायो होतो। ");
INSERT INTO lbm_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","यहोशू न कह्यो, “परमेश्वर को भय मान क ओकी सेवा खरायी अऊर सच्चायी सी करो; अऊर जिन देवतावों की सेवा तुम्हरो पूर्वज मेशोपोटामियां अऊर मिस्र म करत होतो, उन्ख दूर कर क् परमेश्वर की सेवा करो। ");
INSERT INTO lbm_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","अऊर यदि परमेश्वर की सेवा करनो तुम्ख बुरो लगय हय, त अज चुन लेवो कि तुम कौन की सेवा करो, चाहे उन देवतावों की उन्की सेवा तुम्हरो पूर्वज मेशोपोटामियां म करत होतो, अऊर चाहे एमोरियों को देवतावों की सेवा करो जिन्को देश म तुम रह्य हय; पर मय त अपनो परिवार समेत परमेश्वरच की सेवा हमेशा करूं।” ");
INSERT INTO lbm_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","तब लोगों न उत्तर दियो, “परमेश्वर ख त्याग क दूसरो देवतावों की सेवा करन को बिचार हम कभी नहीं करबो; ");
INSERT INTO lbm_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","कहालीकि हमरो परमेश्वर यहोवा उच आय जो हम्ख अऊर हमरो पूर्वजों ख मिस्र देश सी निकाल लायो, अऊर हमरो देखतो देखतो बड़ो बड़ो आश्चर्यकर्म करयो, अऊर जो रस्ता पर अऊर जितनी जातियों को बीच म सी हम चलत आवत होतो ओन हमरी रक्षा करी; ");
INSERT INTO lbm_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","अऊर हमरो सामने सी यो देश म रहन वाली एमोरी अऊर सब जातियों ख निकाल दियो हय; येकोलायी हम भी परमेश्वर की सेवा करबो, कहालीकि हमरो परमेश्वर उच आय।” ");
INSERT INTO lbm_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","यहोशू न लोगों सी कह्यो, “तुम सी परमेश्वर की सेवा नहीं होय सकय; कहालीकि ऊ पवित्र परमेश्वर आय; ऊ जलन रखन वालो परमेश्वर आय; ऊ तुम्हरो अपराध अऊर पाप माफ नहीं करेंन। ");
INSERT INTO lbm_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","यदि तुम परमेश्वर ख त्याग क परायो देवतावों की सेवा करन लगो, त ऊ तुम्हरो भलो करतो आयो हय तब भी ऊ मुड़ क तुम्हरी हानि करेंन, अऊर तुम्हरो अन्त भी कर डालेंन।” ");
INSERT INTO lbm_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","लोगों न यहोशू सी कह्यो, “नहीं; हम परमेश्वरच की सेवा करबो।” ");
INSERT INTO lbm_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","यहोशू न लोगों सी कह्यो, “तुम खुदच अपनो गवाह हय कि तुम न परमेश्वर की सेवा करन को निर्नय लियो हय।” उन्न कह्यो, “हां, हम गवाह हय।” ");
INSERT INTO lbm_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","यहोशू न कह्यो, “अपनो बीच म सी परायो देवतावों ख दूर कर क् अपनो अपनो मन इस्राएल को परमेश्वर यहोवा को तरफ लगावो।” ");
INSERT INTO lbm_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","लोगों न यहोशू सी कह्यो, “हम त अपनो परमेश्वर यहोवाच की सेवा करबो, अऊर ओकीच बात मानबो।” ");
INSERT INTO lbm_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","तब यहोशू न उच दिन लोगों सी वाचा बन्धायी, अऊर शकेम म उन्को लायी विधि अऊर नियम ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","या पूरी बाते यहोशू न परमेश्वर की व्यवस्था की किताब म लिख दियो; अऊर एक बड़ो गोटा चुन क वहां ऊ बांझ झाड़ को खल्लो खड़ो करयो, जो परमेश्वर को पवित्र जागा म होतो। ");
INSERT INTO lbm_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","तब यहोशू न लोगों सी कह्यो, “सुनो, यो गोटा हम लोगों को गवाह रहेंन, कहालीकि जितनो वचन परमेश्वर न हम सी कह्यो हय उन्ख येन सुन्यो हय; येकोलायी यो तुम्हरो गवाह रहेंन, असो नहीं होय कि तुम अपनो परमेश्वर सी मुकर जावो।” ");
INSERT INTO lbm_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","तब यहोशू न लोगों ख अपनो अपनो निजी हिस्सा म जान लायी बिदा करयो। ");
INSERT INTO lbm_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","इन बातों को बाद परमेश्वर को सेवक, नून को टुरा यहोशू, एक सौ दस साल को होय क मर गयो। ");
INSERT INTO lbm_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","अऊर ओको शव ख ओको जमीन हिस्सा तिम्नत्सेरह नगर म माटी दी गयी, जो एप्रैम को पहाड़ी देश म गाश नाम की पहाड़ी को उत्तर म हय। ");
INSERT INTO lbm_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","यहोशू जब तक जीन्दो रह्यो, तब तक इस्राएली लोग परमेश्वर की उपासना करतो रह्यो, अऊर ओको मरन को बाद भी हि अगुवा को जीन्दो रहतो, जिन्न ऊ सब कुछ जो परमेश्वर न इस्राएलियों को लायी करयो होतो, देख क इस्राएल को लोग परमेश्वर की उपासना करतो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","फिर यूसुफ की हड्डी जिन्ख इस्राएली लोग मिस्र सी लायो होतो हि शकेम नगर की जमीन को ऊ हिस्सा म गाड़ी गयी, जेक याकूब न शकेम नगर को पिता हमोर को टुरावों सी एक सौ चांदी को सिक्का म ले लियो होतो; येकोलायी ऊ यूसुफ की सन्तान को निजी हिस्सा भय गयो। ");
INSERT INTO lbm_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","हारून को टुरा एलीआजार भी मर गयो; अऊर ओख एप्रैम को पहाड़ी देश को गिबा नगर म माटी दी गयी, जो ओको टुरा पीनहास ख दियो गयो होतो।");
INSERT INTO lbm_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","क्षयर्ष नाम को राजा को दिनों म या बाते भयी : यो उच क्षयर्ष आय, जो एक सौ सत्ताईस देशों पर, मतलब भारत सी ले क कूश देश तक राज्य करत होतो। ");
INSERT INTO lbm_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","उच दिनों म राजा क्षयर्ष को शासन काल की राजधानी शूशन गढ़ म होती उत राजगद्दी पर बैठ क राज्य करत होतो। ");
INSERT INTO lbm_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","उत ओन अपनो शासन करन को तीसरो साल म अपनो सब हाकिमों अऊर काम करन वालो ख भेज दियो। फारस अऊर मादै देशों को सेनापति अऊर क्षेत्र क्षेत्र को प्रधान अऊर हाकिम ओको जवर आय गयो। ");
INSERT INTO lbm_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","ऊ उन्ख बहुत दिन बल्की छय महीना तक अपनो राज सी वैभव को धन अऊर अपनी महानता की अनमोल चिज दिखातो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","इन दिनों को बीतन पर राजा न छोटो बड़ो उन पूरो ख भी जो शूशन नाम को राजगढ़ म जमा भयो होतो, राजभवन को बगीचा को आंगन म सात दिन तक जेवन दियो। ");
INSERT INTO lbm_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","उत को परदा सफेद अऊर नीलो धागा को होतो, अऊर सन अऊर बैंजनी रंग की डोरियों सी चांदी को छल्ला म, संगमर्मर को खम्भा सी लग्यो हुयो होतो; अऊर उत की चौकियां सोनो चांदी की होती; अऊर लाल अऊर सफेद अऊर पीलो अऊर कालो संगमर्मर की बनी हुयी फर्श पर धरी हुयी होती। ");
INSERT INTO lbm_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","ऊ जेवन म राजा को लायक अंगूररस अऊर अलग अलग रूप को सोनो को बर्तनों म डाल क राजा की उदारता सी बहुतायत को संग पिलायो जात होतो। ");
INSERT INTO lbm_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","पीनो त नियम को अनुसार होत होतो, जेख जसो लगत होतो वसोच करत होतो; कहालीकि राजा न अपनो भवन को सब भण्डारियों ख आज्ञा दी होती, कि जो अतिथि जसो चाहे ओको संग वसोच बर्ताव करजो। ");
INSERT INTO lbm_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","रानी वशती न भी राजा क्षयर्ष को भवन म स्त्रियों ख भोज दियो। ");
INSERT INTO lbm_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","सातवों दिन, जब राजा को मन अंगूररस म चूर होतो, तब ओन महूमान, बिजता, हर्बोना, बिगता, अबगता, जेतेर अऊर कर्कस नाम को सातों किन्नर ख जो क्षयर्ष राजा को जवर सेवा करत होतो, आज्ञा दी, ");
INSERT INTO lbm_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","कि रानी वशती ख राजमुकुट धारन करयो हुयो राजा को जवर ले आवों; जेको सी देश देश को लोगों अऊर शासक पर ओकी सुन्दरता प्रगट हो जाये; कहालीकि वा देखनो म सुन्दर होती। ");
INSERT INTO lbm_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","किन्नरों को द्वारा राजा की या आज्ञा पा क रानी वशती न आनो सी मना करयो। या बात पर राजा बड़ो गुस्सा सी जलन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","तब राजा न समय समय को भेद जानन वालो पण्डितों सी पूछ्यो राजा त नीति अऊर न्याय को सब ज्ञानियों सी असोच करत होतो। ");
INSERT INTO lbm_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","ओको जवर कर्शन, शेतार, अदमाता, तर्शीश, मेरेस, मर्सना, अऊर ममूकान नाम को फारस अऊर मादै देश को सात प्रधान होतो, जो राजा को दर्शन करत होतो, अऊर राज्य म मुख्य मुख्य पदों पर नियुक्त करयो गयो होतो ");
INSERT INTO lbm_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","राजा न पूछ्यो, “रानी वशती न राजा क्षयर्ष की, किन्नरों द्वारा दिलायी हुयी आज्ञा को उल्लंघन करयो, त नीति को अनुसार ओको संग का करयो जाये?” ");
INSERT INTO lbm_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","तब ममूकान राजा न अऊर शासक की उपस्थिति म उत्तर दियो, “रानी वशती न जो अनुचित काम करयो हय, ऊ न केवल राजा सी पर सब शासक सी अऊर उन सब देशों को लोगों सी भी जो राजा क्षयर्ष को सब क्षेत्रों म रह्य हंय। ");
INSERT INTO lbm_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","कहालीकि रानी को यो काम की चर्चा सब स्त्रियों म होयेंन अऊर जब यो कह्यो जायेंन, ‘राजा क्षयर्ष न रानी वशती ख अपनो आगु लान की आज्ञा दी पर वा नहीं आयी,’ तब हि भी अपनो अपनो पति ख बेकार जानन लगेंन। ");
INSERT INTO lbm_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","अज को दिन फारसी अऊर मादी देश को हाकिमों की स्त्रियां जिन्न रानी की या बात सुनी हय, हि भी राजा को सब शासक सी असीच कहन लगेंन; यो तरह बहुत जलन अऊर गुस्सा पैदा होयेंन। ");
INSERT INTO lbm_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","यदि राजा ख स्वीकार हो, त या आज्ञा निकाले, अऊर फारसियों अऊर मादियों को कानून म लिखी भी जाये, जेको सी कभी बदल नहीं सके, कि रानी वशती राजा क्षयर्ष को जवर फिर कभी आनो न पाये, अऊर राजा पटरानी को पद कोयी दूसरो ख दे दे जो ओको सी अच्छी हो। ");
INSERT INTO lbm_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","तब जब राजा की या आज्ञा ओको पूरो राज्य म सुनायी जायेंन, तब सब पत्नियां अपनो अपनो पति को, आदर सम्मान करती रहेंन, चाहे ऊ गरीब हो या अमीर हो।” ");
INSERT INTO lbm_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","या बात राजा अऊर शासक ख पसंद आयी अऊर राजा न ममूकान की सलाह मान ली अऊर अपनो राज्य म, ");
INSERT INTO lbm_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","मतलब हर एक क्षेत्र को अक्षरों म अऊर हर एक जाति की भाषा म चिट्ठियां भेजी, कि सब आदमी अपनो अपनो घर म अधिकार चलाये, अऊर अपनी जाति की भाषा बोल्यो करे। ");
INSERT INTO lbm_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","इन बातों को बाद जब राजा क्षयर्ष को गुस्सा ठंडो पड़ गयो, तब ओन रानी वशती की, अऊर जो काम ओन करयो होतो, अऊर जो ओको बारे म आज्ञा निकली होती ओकी भी सुधि ली ");
INSERT INTO lbm_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","तब राजा को सेवक जो ओको सलाहकार होतो, कहन लग्यो, “राजा लायी सुन्दर नहीं त जवान कुवारी लड़कियां ढूंढ़ी जाये। ");
INSERT INTO lbm_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","अऊर राजा न अपनो राज्य को सब क्षेत्रों म लोगों ख येकोलायी नियुक्त करे कि हि सब सुन्दर जवान कुंवारियों ख शूशन गढ़ को रनवास म जमा करे अऊर स्त्रियों प्रबन्धक हेगे ख जो राजा को खोजा होतो सौंप दे; अऊर सिंगार की चिजे उन्ख दी जाये। ");
INSERT INTO lbm_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","तब उन्म सी जो कुंवारी लड़की राजा की नजर म अच्छी ठहरी, ओख रानी वशती की जागा पर पटरानी बनायी जाये।” या बात राजा ख पसंद आयी अऊर ओन असोच करयो। ");
INSERT INTO lbm_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","शूशन गढ़ म मोर्दकै नाम को एक यहूदी रहत होतो, जो कीश नाम को एक बिन्यामीनी को परनाती, शिमी को नाती, अऊर याईर को बेटा होतो। ");
INSERT INTO lbm_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","ऊ उन बन्दियों को संग यरूशलेम सी बन्धुआई म गयो होतो, जिन्ख बेबीलोन को राजा नबूकदनेस्सर, यहूदा को राजा यकोन्याह को संग बन्दी बना कर क् ले गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","ओन हदस्सा नाम की अपनी काका बहिन ख, जो एस्तेर भी कहलात होती, ओख पाल्यो पोस्यो होतो; कहालीकि ओको माय बाप कोयी नहीं होतो, अऊर वा लड़की सुन्दर अऊर रूपवती होती, अऊर जब ओको माय बाप मर गयो, तब मोर्दकै न ओख अपनी टुरी को रूप म पाल्यो। ");
INSERT INTO lbm_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","जब राजा की आज्ञा अऊर नियम सुनायो गयो, अऊर बहुत सी युवतियां, शूशन गढ़ म हेगे को अधिकार म जमा करी गयी, तब एस्तेर भी राजभवन म स्त्रियों को प्रबन्धक हेगे को अधिकार म सौंपी गयी। ");
INSERT INTO lbm_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","वा एस्तेर ओकी नजर म अच्छी लगी; अऊर ऊ ओको सी खुश भयो, तब ओन बिना विलम्ब ओख राजभवन म सी सिंगार करन की चिजे, अऊर ओको जेवन, अऊर ओको लायी चुनी हुयी सात सहेलियां भी दी, अऊर ओख अऊर ओकी सहेलियों ख रनवास म सब सी अच्छी रहन की जागा दी। ");
INSERT INTO lbm_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","एस्तेर न अपनो लोग नहीं बतायो होतो, न अपनो कुल, कहालीकि मोर्दकै न ओख आज्ञा दी होती कि ओख नहीं बताजो। ");
INSERT INTO lbm_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","मोर्दकै हर दिन रनवास को आंगन को आगु टहलत होतो ताकि एस्तेर को हाल चाल जान सके कि अऊर वा कसी हय? ");
INSERT INTO lbm_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","जब एक एक लड़की की पारी आयी, कि वा क्षयर्ष राजा को जवर जाये अऊर यो ऊ समय भयो जब ओको संग स्त्रियों लायी ठहरायो हुयो नियम को अनुसार बारा महिना तक व्यवहार करयो गयो होतो; मतलब उन्को सिंगार करन को दिन यो रीति सी बीत गयो, कि छय महिना तक गन्धरस को तेल लगायो जात होतो, अऊर छय महिना तक सुगन्ध की चिज, अऊर स्त्रियों ख शुद्ध करन को दूसरो सामान लगायो जात होतो। ");
INSERT INTO lbm_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","यो तरह सी वा लड़की जब राजा को जवर जात होती, तब जो कयी वा चाहत होती कि रनवास सी राजभवन म ले जाये, ऊ ओख दियो जात होतो। ");
INSERT INTO lbm_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","शाम ख त वा जात होती अऊर सुबेरे वा लौट क रनवास को दूसरो घर म जाय क रखेलियों को प्रबन्धक राजा को किन्नर शाशगज को अधिकार म होय जात होती, अऊर राजा को जवर फिर नहीं जात होती। यदि राजा ओको सी प्रसन्न होय जात होतो, तब ऊ नाम ले क बुलायी जात होती। ");
INSERT INTO lbm_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","जब मोर्दकै को काका अबीहैल की टुरी एस्तेर, जेख मोर्दकै न टुरी मान क रख्यो होतो, ओकी पारी आयी की राजा को जवर जाये, तब जो कुछ स्त्रियों को प्रबन्धक राजा को किन्नर अधिकारी हेगे न ओको लायी ठहरायो होतो, ओको सी ज्यादा ओन अऊर कुछ नहीं मांग्यो। जितनों न एस्तेर ख देख्यो, हि सब ओको सी प्रसन्न भयो। ");
INSERT INTO lbm_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","तब एस्तेर राजभवन म राजा क्षयर्ष को जवर ओको राज्य को सातवों साल को तेबेत नाम को दसवों महीना म पहुंचायी गयी। ");
INSERT INTO lbm_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","राजा न एस्तेर ख अऊर सब स्त्रियों सी ज्यादा प्रेम करयो, अऊर दूसरी सब कुंवारियों सी ज्यादा ओको अनुग्रह अऊर कृपा की दृष्टि ओकोच पर भयी, यो वजह ओन ओकी मुंड पर राजमुकुट रख्यो अऊर ओख वशती की जागा पर रानी बनायो। ");
INSERT INTO lbm_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","तब राजा न अपनो सब हाकिमों अऊर कर्मचारियों ख एक बड़ो भोज दियो, अऊर ओख एस्तेर को भोज कह्यो; अऊर क्षेत्रों म छुट्टी दिलायी, अऊर अपनी उदारता को लायक इनाम भी बाट्यो। ");
INSERT INTO lbm_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","अब तक राजा न मोर्दकै ख अपनी प्रशासकीय सेवा म नियुक्त करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","एस्तेर न अपनी जाति अऊर कुल को बारे म बतायो नहीं होतो, कहालीकि मोर्दकै न ओख असी आज्ञा दी होती कि न बताये; अऊर एस्तेर मोर्दकै की बात असी मानी जसी कि ओको इत अपनो पालन पोषन को समय मानत होती। ");
INSERT INTO lbm_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","उच दिनो म जब मोर्दकै राजा को राजभवन की फाटक पर बैठ्यो करत रह्य, तब राजा को किन्नर जो द्वारपाल भी होतो, उन्म सी बिकतान अऊर तेरेश नाम को दोय जन न राजा क्षयर्ष सी नाराज होय क ओख मारन की योजना बनायी। ");
INSERT INTO lbm_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","या बात मोर्दकै ख मालूम भयी, अऊर ओन एस्तेर रानी ख या बात बतायी, अऊर एस्तेर न मोर्दकै को नाम ले क राजा ख सावधान कर दी। ");
INSERT INTO lbm_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","तब जाच पड़ताल होन पर या बात सच निकली अऊर हि दोयी झाड़ पर लटकाय दियो गयो, अऊर यो वृत्तान्त राजा को आगु इतिहास की किताब म लिख लियो गयो। ");
INSERT INTO lbm_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","इन बातों को बाद राजा क्षयर्ष न अगागी हम्मदाता को टुरा हामान ख पंतप्रदान बनायो, अऊर ओख महत्व दे क ओको लायी ओको संगी हाकिमों को सिंहासनों सी ऊंचो सिंहासन ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","राजा को सब कर्मचारी जो राजभवन को फाटक म रह्यो करत होतो, हि हामान को आगु झुक क दण्डवत करत होतो कहालीकि राजा न ओको बारे म असीच आज्ञा दी होती; पर मोर्दकै न त झुकत होतो अऊर न ओख दण्डवत करत होतो ");
INSERT INTO lbm_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","तब राजा को कर्मचारी जो राजभवन म रह्यो करत होतो, उन्न मोर्दकै सी पूछ्यो, “तय राजा की आज्ञा को कहाली उल्लंघन करय हय?” ");
INSERT INTO lbm_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","जब हि ओको सी हर दिन असोच कहतो रह्यो, अऊर ओन उन्की एक नहीं मानी, तब उन्न यो देखन की इच्छा सी कि मोर्दकै की या बात चलेंन कि नहीं, हामान ख मोर्दकै न बताय दियो, होतो कि मय यहूदी आय। ");
INSERT INTO lbm_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","जब हामान न देख्यो कि मोर्दकै नहीं झुकय, अऊर न ओख दण्डवत करय हय, तब हामान बहुतच गुस्सा भयो। ");
INSERT INTO lbm_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","ओन केवल मोर्दकै पर हाथ उठानो अपनी मर्यादा सी कम जान्यो। कहालीकि उन्न हामान ख यो बताय दियो होतो कि मोर्दकै कौन्सी जाति को हय, येकोलायी हामान न क्षयर्ष को साम्राज्य म रहन वालो पूरो यहूदियों ख भी मोर्दकै की जाति जान क, नाश कर डालन की युक्ति निकाली। ");
INSERT INTO lbm_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","राजा क्षयर्ष को बारा साल को नीसान नाम को पहिलो महिना म, हामान न अदार नाम को बारा महीना तक को एक एक दिन अऊर एक एक महीना लायी “पूर” मतलब चिट्ठी अपनो आगु निकलवायी। ");
INSERT INTO lbm_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","तब हामान न राजा क्षयर्ष सी कह्यो, “तोरो राज्य को सब क्षेत्रों म रहन वालो देश देश को लोगों को बीच म अलग अलग बिखरयो हुयो लोग हय, जेको नियम अऊर सब लोगों को नियमों सी अलग हंय; अऊर हि राजा को कानून पर नहीं चलय, येकोलायी उन्ख रहन देनो राजा ख लाभ दायक नहाय। ");
INSERT INTO lbm_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","यदि राजा ख स्वीकार हय त उन्ख नाश करन की आज्ञा लिखी जाये, अऊर मय राजा को सेवकों को हाथ म राज भण्डार म पहुंचान लायी, दस हजार चांदी को सिक्का देऊं।” ");
INSERT INTO lbm_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","तब राजा न अपनी अंगूठी अपनो हाथ सी उतार क, अगागी हम्मदाता को टुरा हामान ख, जो यहूदियों को बैरी होतो दे दी; ");
INSERT INTO lbm_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","अऊर राजा न हामान सी कह्यो, “वा चांदी जो तोख दी गयी हय, अऊर हि लोग अऊर उन्को पैसा तोरो हाथ म हय, ताकि तय उन्को सी जसो मन कहे वसोच व्यवहार कर।” ");
INSERT INTO lbm_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","तब उच पहिलो महीना को तेरहवों दिन ख राजा को लेखक बुलायो गयो, अऊर हामान की आज्ञा को अनुसार राजा को सब अधिपतियों, अऊर सब क्षेत्रों को प्रधानों, अऊर देश देश को लोगों को हाकिमों लायी चिट्ठियां, एक एक क्षेत्र को अक्षरों म, अऊर एक एक देश को लोगों की भाषा म राजा क्षयर्ष को नाम सी लिखी गयी; अऊर उन्म राजा की अंगूठी की छाप लगायी गयी। ");
INSERT INTO lbm_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","राज्य को सब क्षेत्रों म यो आशय की चिट्ठियां हरकारों को द्वारा भेजी गयी कि एकच दिन म, मतलब अदार नाम को बारहवों महीना को तेरहवों दिन ख, का जवान का बूढ्ढा, का स्त्री, का बच्चा, सब यहूदी मार डाल्यो जाये, नाश करयो जाये अऊर उन्को सत्यानाश करयो जाये; अऊर उन्की धन सम्पत्ति लूट ली जाये। ");
INSERT INTO lbm_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","ऊ आज्ञा को लेख की नकलें सब क्षेत्रों म भेजी गयी अऊर बतायी गयी कि सब देशों को लोग ऊ दिन लायी तैयार होय जाये। ");
INSERT INTO lbm_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","या आज्ञा शूशन गढ़ म दी गयी, अऊर हरकारे राजा की आज्ञा सी तुरतच निकल गयो। राजा अऊर हामान त पीवन बैठ गयो, पर शूशन नगर म घबराहट फैल गयी। ");
INSERT INTO lbm_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","जब मोर्दकै न जान लियो कि का का करयो गयो हय तब मोर्दकै कपड़ा भाड़ क, टाट पहिन क, राख डाल क, नगर को बीच म जाय क ऊंचो अऊर दु:ख भरयो आवाज सी चिल्लान लग्यो; ");
INSERT INTO lbm_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","अऊर ऊ राजभवन की फाटक को आगु पहुंच्यो, पर टाट को कपड़ा पहिन्यो हुयो राजभवन की फाटक को अन्दर त कोयी ख जान की आज्ञा नहीं होती। ");
INSERT INTO lbm_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","एक एक क्षेत्र म, जित जित राजा की आज्ञा अऊर नियम पहुंच्यो, उत उत यहूदी बड़ो विलाप करन लग्यो अऊर उपवास अऊर रोनो पीटनो लग्यो; अऊर बहुत यहूदी टाट को कपड़ा पहिन क राख को ढेर पर बैठ्यो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","एस्तेर रानी की दासियां अऊर किन्नरों न जाय क ओख बताय दियो, तब रानी दु:ख सी भर गयी; अऊर मोर्दकै को जवर कपड़ा भेज क यो कह्यो कि टाट उतार क इन्क पहिन ले, पर मोर्दकै न उन्ख नहीं लियो। ");
INSERT INTO lbm_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","तब एस्तेर न राजा को किन्नरों म सी हताक ख जेक राजा न ओको जवर रहन ख ठहरायो होतो, बुलवाय क आज्ञा दी कि मोर्दकै को जवर जाय क मालूम कर ले कि का बात आय, अऊर येको का वजह हय। ");
INSERT INTO lbm_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","तब हताक नगर को ऊ चौक म, जो राजभवन को फाटक को आगु होतो, मोर्दकै को जवर गयो। ");
INSERT INTO lbm_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","मोर्दकै न ओख सब कयी बताय दियो कि मोरो ऊपर का का बीती हय, अऊर हामान न यहूदियों को नाश करन की अनुमति पान लायी राज भण्डार म कितनी चांदी भर देन को वचन दियो हय, यो भी ठीक ठीक बताय दियो। ");
INSERT INTO lbm_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","तब यहूदियों को विनाश करन की आज्ञा जो शूशन म दी गयी होती, ओकी एक नकल भी ओन हताक को हाथ म, एस्तेर ख दिखान लायी दी, अऊर ओख सब हाल बतावन लायी, अऊर या आज्ञा देन ख कह्यो, कि अन्दर राजा को जवर जाय क अपनो लोगों लायी गिड़गिड़ाय क बिनती करे। ");
INSERT INTO lbm_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","तब हताक न एस्तेर को जवर जाय क मोर्दकै की बाते कह्य क सुनायी। ");
INSERT INTO lbm_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","तब एस्तेर न हताक ख मोर्दकै सी यो कहन की आज्ञा दी, ");
INSERT INTO lbm_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“राजा को सब कर्मचारियों, अऊर राजा को क्षेत्रों को सब लोगों ख भी मालूम हय, कि का आदमी अऊर का स्त्री, कोयी कहाली न हो, जो आज्ञा बिना पाये अन्दर आंगन म राजा को जवर जायेंन ओख मार डालन कीच आज्ञा हय; केवल जेको तरफ राजा सोनो को राजदण्ड बढ़ाये उच बचय हय। पर मय अब तीस दिन सी राजा को जवर नहीं बुलायी गयी हय।” ");
INSERT INTO lbm_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","एस्तेर की या बाते मोर्दकै ख सुनायी गयी। ");
INSERT INTO lbm_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","तब मोर्दकै न एस्तेर को जवर यो सन्देश भेज्यो, “तय मन मच यो बिचार मत कर कि मयच राजभवन म रहन को वजह अऊर सब यहूदियों म सी बची रहूं। ");
INSERT INTO lbm_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","यदि तय यो समय चुपचाप रह्यजो, त अऊर कोयी न कोयी उपाय सी यहूदियों ख मदत अऊर छुटकारा मिल जायेंन, पर तय अपनो बाप को घराना सहीत नाश होय जाजो। का जाने तोख असोच कठिन समय लायी राज पद मिल गयो हो।” ");
INSERT INTO lbm_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","तब एस्तेर न मोर्दकै को जवर यो सन्देश भेज्यो, ");
INSERT INTO lbm_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“तय जाय क शूशन को सब यहूदियों ख जमा कर, अऊर तुम सब मिल क मोरो लायी उपवास करो, तीन दिन अऊर रात ख कयी मत खावो, अऊर न कयी पीवो। मय भी अपनी दासियां सहित उच रीति सी उपवास करूं; अऊर असीच दशा म मय नियम को विरुद्ध राजा को जवर अन्दर जाऊं; अऊर यदि नाश भय गयी त भय गयी।” ");
INSERT INTO lbm_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","तब मोर्दकै चली गयो अऊर एस्तेर की आज्ञा को अनुसारच ओन करयो। ");
INSERT INTO lbm_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","तीसरो दिन एस्तेर अपनो राजकीय कपड़ा पहिन क राजभवन को अन्दर आंगन म जाय क, राजभवन को आगु खड़ी भय गयी। राजा राजभवन म राजगद्दी पर भवन को दरवाजा को आगु विराजमान होतो; ");
INSERT INTO lbm_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","अऊर जब राजा न एस्तेर रानी ख आंगन म खड़ी हुयी देख्यो, तब ओन प्रसन्न होय क सोनो को राजदण्ड जो ओको हाथ म होतो ओको तरफ बढ़ायो। तब एस्तेर न जवर जाय क राजदण्ड को कोना ख छुयो। ");
INSERT INTO lbm_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","तब राजा न ओको सी पुच्छ्यो, “हे एस्तेर रानी, तोख का होना? तय का मांगय हय? मांग अऊर तोख आधो राज्य तक दियो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","एस्तेर न कह्यो, “यदि राजा ख स्वीकार हय, त अज हामान ख संग ले क ऊ भोज म आये, जो मय न राजा लायी तैयार करयो हय।” ");
INSERT INTO lbm_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","तब राजा न आज्ञा दी, “हामान ख तुरतच ले आवो, कि एस्तेर को नेवता ग्रहन करयो जाये।” तब राजा अऊर हामान एस्तेर को तैयार करयो हुयो भोज म आयो। ");
INSERT INTO lbm_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","भोज को समय जब अंगूर रस पियो जात होतो, तब राजा न एस्तेर सी कह्यो, “तोरी का बिनती हय? ऊ पूरो करयो जायेंन। तय का मांगय हय? मांग, अऊर आधो राज्य तक तोख दियो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","एस्तेर न उत्तर दियो, “मोरो निवेदन अऊर जो मय मांगू हय ऊ यो आय, ");
INSERT INTO lbm_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","यदि राजा मोरो पर प्रसन्न हय अऊर राजा उचित समझय हंय कि मोरी बिनती अऊर मांग ख पूरी करयो जाये त राजा अऊर हामान कल ऊ भोज म आये जेक मय उन्को लायी करूं, अऊर कल मय राजा को यो वचन को अनुसार करूं।” ");
INSERT INTO lbm_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","ऊ दिन हामान खुश अऊर मन म प्रसन्न होय क बाहेर गयो। पर जब ओन मोर्दकै ख राजभवन को फाटक म देख्यो, कि ऊ ओको आगु न त खड़ो भयो अऊर न हट्यो, तब ऊ मोर्दकै को विरुद्ध गुस्सा सी भर गयो। ");
INSERT INTO lbm_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","पर ओन अपनो ख रोक क अपनो घर गयो; अऊर अपनो संगियों अऊर अपनी पत्नी जेरेश ख बुलाय क लायो। ");
INSERT INTO lbm_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","तब हामान न उन्को सी अपनो धन को वैभव, अऊर अपनो बाल बच्चा की बढ़ती अऊर राजा न ओख कसो कसो बढ़ायो, अऊर दूसरो सब हाकिमों अऊर अपनो अऊर अपनो सब कर्मचारियों सी ऊंचो पद दियो होतो, इन सब को वर्नन करयो। ");
INSERT INTO lbm_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","हामान न यो भी कह्यो, “एस्तेर रानी न भी मोख छोड़ अऊर कोयी ख राजा को संग, अपनो करयो हुयो भोज म आनो नहीं दियो; अऊर कल लायी भी राजा को संग ओन मोख नेवता दियो हय। ");
INSERT INTO lbm_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","पर जब जब मोख ऊ यहूदी मोर्दकै राजभवन की फाटक म बैठ्यो हुयो दिखायी पड़य हय, तब तब यो सब मोरी नजर म बेकार लगय हय।” ");
INSERT INTO lbm_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","ओकी पत्नी जेरेश अऊर ओको सब संगियों न ओको सी कह्यो, “पचास हाथ ऊंचो फांसी को एक खम्भा बनायो जाये, अऊर सुबेरे राजा सी कहो कि ओको पर मोर्दकै लटकाय दियो जाये; तब राजा को संग खुशी सी भोज म जाजो।” या बात सी खुश होय क हामान न वसोच एक फांसी को खम्भा बनवायो। ");
INSERT INTO lbm_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","ऊ रात राजा ख नींद नहीं आयी, येकोलायी ओकी आज्ञा सी इतिहास की किताब लायी गयी, अऊर पढ़ क राजा ख सुनायी गयी। ");
INSERT INTO lbm_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","ओको म यो लिख्यो हुयो मिल्यो, कि जब राजा क्षयर्ष को हाकिम जो द्वारपाल भी होतो, उन्को म सी बिगताना अऊर तेरेश नाम को दोय जनों न ओको पर हाथ उठान की कोशिश करी होती ओख मोर्दकै न प्रगट करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","तब राजा न पूछ्यो, “येको बदला मोर्दकै को का सम्मान अऊर बड़ायी करी गयी?” राजा को जो सेवक ओकी सेवा म हाजिर होतो, उन्न ओख उत्तर दियो, “ओको लायी कयी भी नहीं करयो गयो।” ");
INSERT INTO lbm_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","राजा न पूछ्यो, “आंगन म कौन हय?” उच समय हामान राजा को भवन सी बाहेर आंगन म यो सोच क आयो होतो कि जो खम्भा ओन मोर्दकै लायी तैयार करायो होतो, ओको पर ओख लटकाय देन की चर्चा राजा सी करे। ");
INSERT INTO lbm_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","तब राजा को सेवकों न ओको सी कह्यो, “आंगन म त हामान खड़ो हय।” राजा न कह्यो, “ओख अन्दर बुलाय क लावो।” ");
INSERT INTO lbm_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","जब हामान अन्दर आयो, तब राजा न ओको सी पूछ्यो, “जो आदमी को सम्मान राजा करनो चाहवय हय त ओको लायी का करनो अच्छो होयेंन?” हामान न यो सोच क, कि मोरो सी ज्यादा राजा कौन्को सम्मान करनो चाहत होना, ");
INSERT INTO lbm_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","राजा ख उत्तर दियो, “जो आदमी को सम्मान राजा करनो चाहे, ");
INSERT INTO lbm_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","ओको लायी राजकीय कपड़ा लायो जाये, जो राजा पहिनय हय, अऊर एक घोड़ा भी, जेको पर राजा सवार होवय हय, अऊर ओकी मुंड पर जो राजकीय मुकुट धरयो जावय हय ऊ भी लायो जाये। ");
INSERT INTO lbm_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","फिर ऊ कपड़ा, अऊर ऊ घोड़ा राजा को कोयी बड़ो हाकिम ख सौंप्यो जाये, अऊर जेको सम्मान राजा करनो चाहवय हय, ओख ऊ कपड़ा पहिनायो जाये, अऊर ऊ घोड़ा पर सवार कर क् नगर को चौक म ओख फिरायो जाये; अऊर ओको आगु आगु यो प्रचार करयो जाये, ‘जेको सम्मान राजा करनो चाहवय हय, ओको संग असोच करयो जायेंन।’” ");
INSERT INTO lbm_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","राजा न हामान सी कह्यो, “फुर्ती कर क् अपनो कहन को अनुसार ऊ कपड़ा अऊर ऊ घोड़ा ख ले क, ऊ यहूदी मोर्दकै सी जो राजभवन की फाटक पर बैठ्यो करय हय, वसोच कर। जसो तय न कह्यो हय ओको म कयी भी कमी होनो नहीं पाये।” ");
INSERT INTO lbm_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","तब हामान न ऊ कपड़ा, अऊर ऊ घोड़ा ख ले क, मोर्दकै ख पहिनायो, अऊर ओख घोड़ा पर चढ़ाय क, नगर को चौक म यो तरह पुकारतो हुयो घुमायो, “जेको सम्मान राजा करनो चाहवय हय ओको संग असोच करयो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","तब मोर्दकै त राजभवन की फाटक म लौट गयो पर हामान दु:ख करतो हुयो अऊर मुंड झाक क झट सी अपनो घर ख गयो। ");
INSERT INTO lbm_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","हामान न अपनी पत्नी जेरेश अऊर अपनो सब संगियों सी सब कयी जो ओको पर बीत्यो होतो वर्नन करयो। तब ओको बुद्धिमान संगियों अऊर ओकी पत्नी जेरेश न ओको सी कह्यो, “मोर्दकै जेक तय नीचा दिखानो चाहवय हय, यदि ऊ यहूदियों को वंश म को आय, त तय ओको पर प्रबल होनो नहीं पाजो ओको सी पूरी रीति सी नीचाच मिलेंन।” ");
INSERT INTO lbm_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","हि ओको सी बात करच रह्यो होतो कि राजा को किन्नर आय क हामान ख एस्तेर लायी भोज म फुर्ती सी बुलाय ले गयो। ");
INSERT INTO lbm_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","तब राजा अऊर हामान एस्तेर रानी को भोज म आय गयो ");
INSERT INTO lbm_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","राजा न दूसरो दिन अंगूर रस पीतो पीतो एस्तेर सी फिर पूछ्यो, “हे एस्तेर रानी! तोरी का बिनती हय? ऊ पूरो करयो जायेंन। तय का मांगय हय? मांग, अऊर आधो राज्य तक तोख दियो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","एस्तेर रानी न उत्तर दियो, “हे राजा! यदि तय मोरो पर प्रसन्न हय, अऊर राजा ख यो स्वीकार हय, त मोरी बिनती सी मोख, अऊर मोरो मांगनो सी मोरो लोगों ख जीवन दान मिले। ");
INSERT INTO lbm_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","कहालीकि मय अऊर मोरी जाति को लोग बेच डाल्यो गयो हंय, अऊर हम सब घात अऊर नाश करयो जान वालो हंय। यदि हम केवल दास दासी होय जान लायी बेच डाल्यो जातो, त मय चुप रह्यती; चाहे वा दशा म विरोधी राजा की हानि भर नहीं सकतो।” ");
INSERT INTO lbm_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","तब राजा क्षयर्ष न एस्तेर रानी सी पूछ्यो, “ऊ कौन आय, अऊर कित हय, जेन असो करनो को निश्चय करयो हय?” ");
INSERT INTO lbm_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","एस्तेर न उत्तर दियो, “ऊ विरोधी अऊर दुश्मन योच दुष्ट हामान आय!” तब हामान राजा रानी को आगु भयभीत भय गयो। ");
INSERT INTO lbm_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","राजा गुस्सा सी भर क, अंगूर रस पीतो पीतो उठ क, राजभवन को बगीचा म निकल गयो; अऊर हामान यो देख क कि राजा न मोरी हानि ठान ली हय, एस्तेर रानी सी जीव की भीख मांगन ख खड़ो भयो। ");
INSERT INTO lbm_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","जब राजा राजभवन को बगीचा सी अंगूर रस पीवन की जागा पर लौट आयो तब यो देख्यो कि हामान वा खटिया पर हय जेको पर एस्तेर बैठी हय ओको पर हामान झुक्यो हुयो हय; अऊर राजा न कह्यो, “का यो मोरोच घर म मोरो आगु रानी ख जबरदस्ती करनो चाहवय हय?” राजा को मुंह सी यो वचन निकल्योच होतो, कि सेवकों न हामान को मुंह झाक दियो। ");
INSERT INTO lbm_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","तब राजा को आगु उपस्थित रहन वालो सेवक किन्नरों म सी हर्बोना नाम को एक न राजा सी कह्यो, “हामान को इत पचास हाथ ऊंचो फांसी को एक खम्भा खड़ो हय, जो ओन मोर्दकै लायी बनवायो हय, जेन राजा कि हित की बात कही होती।” राजा न कह्यो, “ओख ओको पर लटकाय देवो।” ");
INSERT INTO lbm_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","तब हामान उच खम्भा पर जो ओन मोर्दकै लायी तैयार करवायो होतो, ओख लटकाय दियो गयो। तब राजा को गुस्सा ठंडो पड़ गयो। ");
INSERT INTO lbm_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","उच दिन राजा क्षयर्ष न यहूदियों लायी विरोधी हामान को घरदार एस्तेर रानी ख दे दियो। मोर्दकै राजा को आगु आयो, कहालीकि एस्तेर न राजा ख बतायो होतो, कि ओको सी ओको का नाता होतो। ");
INSERT INTO lbm_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","तब राजा न अपनी वा अंगूठी जो ओन हामान सी ले ली होती, उतार क मोर्दकै ख दे दी। एस्तेर न मोर्दकै ख हामान को घरदार को अधिकारी चुन लियो। ");
INSERT INTO lbm_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","तब एस्तेर दूसरी बार राजा सी बोली; अऊर ओको पाय पर गिर क, आसू बहाय बहाय क ओको सी गिड़गिड़ाय क बिनती करी अगागी वंश को हामान द्वारा सोची गयी बुरायी यहूदियों को विरुद्ध रची गयी ओकी योजना रद्द करी जाये। ");
INSERT INTO lbm_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","तब राजा न एस्तेर को तरफ सोनो को राजदण्ड बढ़ायो तब एस्तेर उठ क राजा को आगु खड़ी भयी। ");
INSERT INTO lbm_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","अऊर कहन लगी, “यदि राजा ख स्वीकार हो अऊर ऊ मोरो सी प्रसन्न हय अऊर या बात ओख ठीक सी समझेंन, अऊर मय भी ओख अच्छी लगू हय, त जो चिट्ठियां हम्मदाता अगागी को बेटा हामान न राजा को सब क्षेत्रों को यहूदियों ख नाश करन की युक्ति कर क् लिखायी होती, चिट्ठी ख रद्द करन लायी लिख्यो जाये। ");
INSERT INTO lbm_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","कहालीकि मय अपनो लोगों पर पड़न वाली वा विपत्ति ख कौन्सी रीति सी देख सकूं? मय अपनो घरानों को विनाश ख कसी देख सकूं?” ");
INSERT INTO lbm_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","तब राजा क्षयर्ष न एस्तेर रानी सी अऊर मोर्दकै यहूदी सी कह्यो, “मय हामान को घरदार त एस्तेर ख दे चुक्यो हय, अऊर वा फासी को खम्भा पर लटकाय दियो गयो हय, येकोलायी कि ओन यहूदियों ख मारन की कोशिश कर रह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","तब तुम अपनी समझ को अनुसार राजा को नाम सी यहूदियों को बारे म लिखो, अऊर राजा की अंगूठी की छाप भी लगावो; कहालीकि जो चिट्ठी राजा को नाम सी लिखी जाये, अऊर ओको पर ओकी अंगूठी की छाप लगायी जाये, ओख कोयी भी पलट नहीं सकय।” ");
INSERT INTO lbm_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","उच समय मतलब सीवान नाम को तीसरो महीना को तेईसवों दिन ख राजा को लेखक बुलवायो गयो, अऊर जो जो बात की आज्ञा मोर्दकै न उन्ख दी होती ओख यहूदियों अऊर अधिपतियों अऊर भारत सी ले क कूश देश तक, जो एक सौ सत्ताईस क्षेत्र हंय, उन पूरो को अधिपतियों अऊर हाकिमों ख एक एक देश को लोगों की भाषा म, अऊर यहूदियों ख उन्को अक्षरों अऊर भाषा म लिखी गयी। ");
INSERT INTO lbm_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","मोर्दकै न राजा क्षयर्ष को नाम सी चिट्ठियां लिखाय क, अऊर उन पर राजा की अंगूठी की छाप लगाय क, जल्दी चलन वालो सरकारी घोड़ा, खच्चरों, पर सवार होन वालो को हाथ भेज दियो। ");
INSERT INTO lbm_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","इन चिट्ठियों म सब नगरों को यहूदियों ख राजा को तरफ सी अनुमति दी गयी, कि हि जमा हो अऊर अपनो अपनो जीव बचान लायी तैयार होय क, क्षेत्र को लोग अन्याय कर क् उन्ख या उन्की पत्नियों अऊर बाल बच्चां ख दु:ख देनो चाहे, उन्ख मार डाले अऊर नाश कर दे, अऊर उन्की धन सम्पत्ति लूट ले। ");
INSERT INTO lbm_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","अऊर यो राजा क्षयर्ष को सब क्षेत्रों म एकच दिन म करयो जाये, मतलब अदार नाम को बारहवों महीना को तेरहवों दिन ख। ");
INSERT INTO lbm_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","यो आज्ञा की लेख की नकलें, हर एक क्षेत्रों म सब लोगों को जवर खुली हुयी भेजी जायेंन; ताकि यहूदी ऊ दिन अपनो दुश्मनों सी बदला लेन ख तैयार रहे। ");
INSERT INTO lbm_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","तब सवारी करन वालो घोड़ा पर सवार होय क, राजा की आज्ञा सी फुर्ती सी जल्दी चली गयो, अऊर या आज्ञा शूशन गढ़ की राजधानी म दी गयी होती। ");
INSERT INTO lbm_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","तब मोर्दकै नीलो अऊर सफेद रंग को राजकीय कपड़ा पहिन्यो अऊर मुंड पर सोनो को बड़ो मुकुट पहिन्यो हुयो अऊर उत्तम बैंजनी मलमल को चोंगा पहिन्यो हुयो, राजा को जवर सी निकल्यो, अऊर शूशन नगर को लोग खुशी को मारे जयजयकारों को संग ललकार उठ्यो। ");
INSERT INTO lbm_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","यहूदियों ख खुशी अऊर हर्ष भयो अऊर उन्को बड़ो सम्मान करयो। ");
INSERT INTO lbm_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","अऊर जो जो क्षेत्र, अऊर जो जो नगर म, जित कही राजा की आज्ञा अऊर नियम पहुंचे, उत उत यहूदियों ख खुशी अऊर आराम भयो, अऊर उन्न भोज कर क् ऊ दिन ख खुशी को दिन मान्यो। अऊर ऊ देश को लोगों म सी बहुत लोग यहूदी बन गयो, कहालीकि उन्को मन म यहूदियों को डर समाय गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","अदार नाम को बारहवों महीना को तेरहवों दिन ख, जो दिन राजा की आज्ञा अऊर नियम पूरो होन ख होतो, अऊर यहूदियों को दुश्मन उन्को पर प्रबल होन की आशा रखत होतो, पर येको विपरीत यहूदी अपनो बैरियों पर प्रबल भयो; ");
INSERT INTO lbm_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","ऊ दिन यहूदी लोग राजा क्षयर्ष को सब क्षेत्रों म अपनो अपनो नगर म जमा भयो, कि जो उन्की हानि करन की कोशिश करेंन, उन्को पर हाथ चलावों। कोयी उन्को सामना नहीं कर सक्यो, कहालीकि उन्को डर देश देश को सब लोगों को मन म समाय गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","अऊर क्षेत्रों को सब सरदारों अऊर अधिपतियों अऊर प्रधानों अऊर राजा को कर्मचारियों न यहूदियों की मदत करी, कहालीकि उन्को मन म मोर्दकै को डर समाय गयो होतो। ");
INSERT INTO lbm_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","मोर्दकै त राजा को यहां बहुत प्रभावशाली व्यक्ति होतो, अऊर ओकी कीर्ति सब क्षेत्रों म फैल गयी; बल्की ऊ आदमी मोर्दकै की महिमा बढ़ती चली गयी। ");
INSERT INTO lbm_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","तब यहूदियों न अपनो सब दुश्मनों ख तलवार सी मार क अऊर घात कर क् नाश कर डाल्यो, अऊर अपनो दुश्मनों सी अपनी इच्छा को अनुसार बर्ताव करयो। ");
INSERT INTO lbm_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","शूशन राजगढ़ म यहूदियों न पाच सौ आदमियों ख घात कर क् नाश करयो। ");
INSERT INTO lbm_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","उन्न पर्शन्दाता, दल्पोन, अस्पाता, ");
INSERT INTO lbm_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","पोराता, अदल्या, अरीदाता, ");
INSERT INTO lbm_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","पर्मशता, अरीसै, अरीदै अऊर वैजाता, ");
INSERT INTO lbm_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","मतलब हम्मदाता को टुरा यहूदियों को विरोधी हामान को दसो टुरावों ख घात करयो; पर उन्को धन ख नहीं लूट्यो। ");
INSERT INTO lbm_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","उच दिन शूशन राजगढ़ म घात करयो हुयो की गिनती राजा ख सुनायी गयी। ");
INSERT INTO lbm_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","तब राजा न एस्तेर रानी सी कह्यो, “यहूदियों न शूशन राजगढ़ मच पाच सौ आदमियों अऊर हामान को दसो टुरावों ख घात कर क् नाश करयो हय; तब राज्य को दूसरो क्षेत्रों म उन्न न जाने का का करयो होना! अब येको सी ज्यादा तोरो निवेदन का हय? ऊ भी पूरो करयो जायेंन। तय का मांगय हय? ऊ भी तोख दियो जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","एस्तेर न कह्यो, “यदि राजा ख स्वीकार हय त शूशन को यहूदियों ख अज को जसो कल भी करन की आज्ञा दी जाये, अऊर हामान को दसो टुरा फांसी को खम्भा पर लटकायो जाये।” ");
INSERT INTO lbm_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","राजा न कह्यो, “असोच करयो जाये;” या आज्ञा शूशन म दी गयी, अऊर हामान को दसो टुरा लटकायो गयो। ");
INSERT INTO lbm_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","शूशन को यहूदियों न अदार नाम को महीना को चौदावों दिन ख भी जमा होय क शूशन म तीन सौ आदमियों ख घात करयो, पर धन ख नहीं लूट्यो। ");
INSERT INTO lbm_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","राज्य को दूसरो क्षेत्रों को यहूदी जमा होय क अपनो अपनो जीव बचान लायी खड़ो भयो, अऊर अपनो बैरियों म सी पचहत्तर हजार आदमियों ख घात कर क् अपनो दुश्मनों सी आराम पायो; पर धन ख नहीं लूट्यो। ");
INSERT INTO lbm_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","यो काम उन्न अदार महीना को तेरहवों दिन ख करयो गयो, अऊर चौदावों दिन ख उन्न आराम कर क् भोज करयो अऊर आनन्द को दिन ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","पर शूशन नगर को यहूदी अदार नाम को महीना को तेरहवों दिन ख, अऊर उच महीना को चौदावों दिन ख जमा भयो, अऊर उच महिना को पन्द्रावों दिन ख उन्न खुशी को दिन ठहरायो। ");
INSERT INTO lbm_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","यो वजह देहाती यहूदी जो बिना नगर की दीवार की बस्तियों म रह्य हंय, हि अदार महीना को चौदावों दिन ख खुशी अऊर भोज अऊर छुट्टी अऊर आपस म भोजन की चिजे भेजन को दिन नियुक्त कर क् मनावय हंय। ");
INSERT INTO lbm_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","इन बातों को विवरन लिख क, मोर्दकै न राजा क्षयर्ष को सब क्षेत्रों म, का जवर का दूर रहन वालो पूरो यहूदियों को जवर चिट्ठियां भेजी, ");
INSERT INTO lbm_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","अऊर या आज्ञा दी, कि अदार महीना को चौदावों अऊर उच महीना को पन्द्रावों दिन ख हर साल को पर्व मनायो जाये। ");
INSERT INTO lbm_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","इन दिनो म यहूदियों न अपनो दुश्मनों सी आराम पायो, अऊर यो महीना जेको म दु:ख सुख सी, अऊर विलाप खुशी सी बदल गयो; अऊर यहूदियों ख चाहिये कि हि इन दिनो म सामूहिक भोज अऊर खुशी अऊर एक दूसरो को जवर भोजन की चिजे भेजन लायी अऊर गरीबों ख दान देन लायी माने। ");
INSERT INTO lbm_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","येकोलायी यहूदियों न जसो सुरूवात करयो होतो, अऊर जसो मोर्दकै न उन्ख लिख्यो, वसोच चालु रखन को निश्चय कर लियो। ");
INSERT INTO lbm_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","कहालीकि हम्मदाता अगागी को टुरा हामान जो सब यहूदियों को विरोधी होतो, ओन यहूदियों को नाश करन की कोशिश करी, अऊर उन्ख मिटाय डालन लायी अऊर नाश करन लायी “पूर” मतलब चिट्ठी निकाली होती। ");
INSERT INTO lbm_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","पर जब राजा न यो जान लियो, तब ओन आज्ञा दी अऊर लिखवायी करी जो दुष्ट व्यक्ति हामान न यहूदियों को विरुद्ध करयो होतो ऊ ओकोच मुंड पर पलट आयो, तब हामान अऊर ओको टुरा फांसी को खम्भा पर लटकायो गयो। ");
INSERT INTO lbm_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","यो वजह उन दिनो को नाम पूर शब्द सी पूरीम रख्यो गयो। या चिट्ठी की सब बातों को वजह, अऊर जो कयी उन्न यो विषय म देख्यो अऊर जो कयी उन पर बीत्यो होतो, ओको वजह भी ");
INSERT INTO lbm_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","यहूदियों न अपनो अपनो लायी अऊर अपनी सन्तान लायी, अऊर उन पूरो लायी भी जो उन्म मिल गयो होतो यो अटल प्रन ठहरायो, कि ऊ लेख को अनुसार हर साल ओको ठहरायो हुयो समय म हि यो दोय दिन मनायेंन; ");
INSERT INTO lbm_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","अऊर पीढ़ी पीढ़ी, कुल कुल, क्षेत्र क्षेत्र, नगर नगर म यो दिन याद करेंन अऊर मान्यो जायेंन, अऊर पूरीम नाम को दिन यहूदियों म कभी नहीं मिटेंन अऊर उन्की याद उन्को वंश म उन्की याद हमेशा सुरक्षित रहेंन। ");
INSERT INTO lbm_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","तब अबीहैल की बेटी एस्तेर रानी न, अऊर मोर्दकै यहूदी न पूरीम को बारे म या दूसरी चिट्ठी बड़ो अधिकार को संग लिखी। ");
INSERT INTO lbm_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","येकी नकलें मोर्दकै न क्षयर्ष को राज्य को एक सौ सत्ताईसों क्षेत्रों को सब यहूदियों को जवर शान्ति देन वाली अऊर सच्ची बातों को संग यो कामना करतो हुयो भेजी, ");
INSERT INTO lbm_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","कि पूरीम को उन दिनो को विशेष ठहरायो हुयो समयों म मोर्दकै यहूदी अऊर एस्तेर रानी को आज्ञा को अनुसार, अऊर जो यहूदियों न अपनो अऊर अपनी सन्तान लायी ठान लियो होतो, ओको अनुसार भी उपवास अऊर विलाप करयो जाये। ");
INSERT INTO lbm_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","पूरीम को विषय को यो नियम एस्तेर की आज्ञा सी स्थिर करयो गयो, अऊर उन्की चर्चा किताब म लिखी गयी। ");
INSERT INTO lbm_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","राजा क्षयर्ष न देश अऊर समुन्दर को जवर को टापू को क्षेत्र पर कर लगायो। ");
INSERT INTO lbm_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","ओको सामर्थ अऊर पराक्रम को कामों, अऊर मोर्दकै की ऊ बड़ायी को पूरो ब्योरा, जो राजा न ओकी करी होती, का ऊ मादै अऊर फारस को राजावों को इतिहास की किताब म नहीं लिख्यो हय? ");
INSERT INTO lbm_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","यहूदी मोर्दकै, क्षयर्ष राजा कोच खल्लो होतो, अऊर यहूदियों की नजर म बड़ो होतो, अऊर ओको सब भाऊ ओको सी खुश होतो, कहालीकि ऊ अपनो लोगों की भलायी की खोज म रहत होतो अऊर अपनो सब लोगों सी शान्ति की बाते बोलत होतो।");
INSERT INTO lbm_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","यरूशलेम को राजा, दाऊद को टुरा अऊर उपदेशक को वचन। ");
INSERT INTO lbm_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","उपदेशक को यो वचन हय, “बेकारच बेकार, बेकारच बेकार! सब कयी बेकार हय।” ");
INSERT INTO lbm_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","ऊ सब मेहनत सी जेख आदमी धरती पर करय हय, ओख का फायदा होवय हय? ");
INSERT INTO lbm_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","एक पीढ़ी जावय हय, अऊर दूसरी पीढ़ी आवय हय, पर धरती जसी की वसी हमेशा रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","सूरज उदय होय क डूब भी जावय हय, अऊर तेजी सी ऊ जागा ख चली जावय हय जित सी ऊ निकलय हय। ");
INSERT INTO lbm_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","हवा दक्षिन को तरफ बहय हय, अऊर उत्तर दिशा को तरफ घुमती जावय हय; वा घुमती अऊर बहती रह्य हय, अऊर अपनी परिक्रमा म लौट आवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","सब नदियां एकच जागा को तरफ बार बार बहय हय। हि सब समुन्दर म जाय क मिलय हय; पर फिर भी समुन्दर कभी नहीं भरय। ");
INSERT INTO lbm_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","सब बाते थकावन वाली आय; आदमी येको वर्नन नहीं कर सकय; न त आंखी देखनो सी सन्तुष्ट होवय हंय, अऊर न कान सुननो सी भरय हंय। ");
INSERT INTO lbm_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","जो कुछ भयो होतो, उच फिर होयेंन, अऊर जो कुछ बन चुक्यो हय उच फिर बनायो जायेंन; अऊर धरती पर कोयी बात नयी नहाय। ");
INSERT INTO lbm_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","का असी कोयी बात हय जेको बारे म लोग कह्य सके कि देख या बात नयी हय? यो त हमरो सी पहिलो को समय सी होतो आय रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","पुरानी बातों की कुछ याद नहीं रही, अऊर होन वाली बातों की भी याद उन्को बाद आन वालों ख भी नहीं रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","मय उपदेशक यरूशलेम म इस्राएल को राजा होतो। ");
INSERT INTO lbm_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","मय न अपनो मन लगायो कि जो कुछ धरती पर करयो जावय हय, ओको भेद बुद्धि सी सोच सोच क मालूम करू; यो बड़ो दु:ख को काम आय जो परमेश्वर न मनुष्यों को लायी ठहरायो हय कि हि ओको म लगेंन। ");
INSERT INTO lbm_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","मय न उन सब कामों ख देख्यो जो धरती पर करयो जावय हंय; देखो, हि सब बेकार अऊर मानो हवा ख पकड़नो हय। ");
INSERT INTO lbm_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","जो तेढ़ो हय ऊ सीधो नहीं होय सकय, अऊर जो हयच नहाय, ऊ गिन्यो नहीं जाय सकय। ");
INSERT INTO lbm_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","मय न मन म कह्यो, “देख, जितनो यरूशलेम म मोरो सी पहिले होतो, उन सब सी मय न बहुत ज्यादा बुद्धि हासिल करी हय; अऊर मोख बहुत बुद्धि अऊर ज्ञान मिल गयो हय।” ");
INSERT INTO lbm_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","मय न अपनो मन लगायो कि बुद्धि को भेद लेऊ अऊर पागलपन अऊर मूर्खता ख भी जान लेऊ। मोख जान पड़्यो कि यो भी हवा ख पकड़नो हय। ");
INSERT INTO lbm_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","कहालीकि बहुत बुद्धि को संग बहुत दु:ख भी होवय हय, अऊर जो अपनो ज्ञान बढ़ावय हय ऊ अपनो दु:ख भी बढ़ावय हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","मय न अपनो मन सी कह्यो, “चल, मय तोख खुशी को द्वारा जांचूं; कि खुशी का हय।” पर मय न यो भी देख्यो, कि यो भी बेकार हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","मय न हसी को बारे म कह्यो, “यो त पागलपन आय,” अऊर खुशी को बारे म, “ओको सी का हासिल होवय हय?” ");
INSERT INTO lbm_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","मय न मन म सोच्यो कि कसो तरह सी मोरी बुद्धि बनी रहे अऊर मय अपनो जीव ख अंगूरीरस पीवन सी कसो तरह बहलाऊ अऊर कसो मूर्खता ख थाम्यो रहूं, जब तक मालूम नहीं करू कि ऊ अच्छो काम कौन्सो हय जेख आदमी जीवन भर करतो रहे। ");
INSERT INTO lbm_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","मय न बड़ो बड़ो काम करयो; मय न अपनो लायी घर बनायो अऊर अपनो लायी अंगूर की बाड़ी लगायी; ");
INSERT INTO lbm_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","मय न अपनो लायी बाड़ियां अऊर बगीचा लगाय लियो, अऊर ओको म अलग अलग को फर वालो झाड़ लगायो। ");
INSERT INTO lbm_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","मय न अपनो लायी तलाव खुदवाय लियो कि उन सी जंगल सींच्यो जाये जेको म पौधा लगायो जात होतो। ");
INSERT INTO lbm_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","मय न दास अऊर दासियां खरीद लियो, जिन्को मोरो घर मच सन्तान पैदा भयी; अऊर जितनो मोरो सी पहिले यरूशलेम म होतो उन सी कहीं जादा गाय-बईल अऊर मेंढी-शेरियां को मय मालिक भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","मय न चांदी अऊर सोनो अऊर राजावों अऊर देशों को किमती चिजे ख भी जमा करयो; मय न अपनो लायी गायकों अऊर गायिकावों ख रख्यो, आदमियों को दिल बहलावन वाली रखेलियां भी होती। ");
INSERT INTO lbm_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","यो तरह मय अपनो सी पहिलो को सब यरूशलेम वासियों सी ज्यादा महान अऊर धनवान भय गयो; तब भी मोरी बुद्धि न मोरो साथ नहीं छोड़्यो। ");
INSERT INTO lbm_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","अऊर जितनी चिजे ख देखन की मय न इच्छा करी, उन सब ख देखन सी मय नहीं रुक्यो; मय न अपनो मन कोयी तरह की खुशी भोगन सी नहीं रोक्यो कहालीकि मोरो मन मोरो सब मेहनत को वजह खुश भयो; अऊर मोरो सब मेहनत सी मोख योच इनाम मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","तब मय न फिर सी अपनो हाथों को कामों ख, अऊर अपनो सब मेहनत ख देख्यो, त का देख्यो कि सब कुछ बेकार अऊर हवा ख पकड़नो जसो हय, अऊर धरती पर आदमी को काम अऊर मेहनत सी कुछ फायदा नहाय। ");
INSERT INTO lbm_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","फिर मय न अपनो मन ख मोड़्यो कि बुद्धि अऊर पागलपन अऊर मूर्खता को काम ख देखू; कहालीकि जो आदमी राजा को पीछु आयेंन, ऊ का करेंन? केवल उच जो होतो चल्यो आयो हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","तब मय न देख्यो कि उजाड़ो अन्धारो सी जितनो अच्छो हय, उतनो बुद्धि भी मूर्खता सी अच्छी हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","जो बुद्धिमान हय, ओको मुंड म आंखी रह्य हय, पर मूर्ख अन्धारो म चलय हय; तब भी मय न जान लियो कि दोयी की दशा एक जसी होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","तब मय न मन म कह्यो, “जसी मूर्ख की दशा होयेंन, वसी मोरी भी होयेंन; फिर मय कहाली बुद्धिमान भयो?” अऊर मय न मन म कह्यो कि यो भी बेकारच हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","कहालीकि नहीं त बुद्धिमान को अऊर नहीं मूर्ख की याद हमेशा बनी रहेंन, पर भविष्य म सब कुछ भुलाय दियो जायेंन। बुद्धिमान कसो मूर्ख को जसो मरय हय! ");
INSERT INTO lbm_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","येकोलायी मय न अपनो जीवन सी घृना करी, कहालीकि जो काम धरती पर करयो जावय हय मोख बुरो मालूम पड़्यो; कहालीकि सब कुछ बेकार अऊर हवा ख पकड़नो हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","मय न अपनो पूरो मेहनत को फर सी जेख मय न धरती पर करयो होतो नफरत करयो, कहालीकि जरूरी हय कि मय ओको फर ऊ मनुष्य को लायी छोड़ जाऊं जो मोरो बाद आयेंन। ");
INSERT INTO lbm_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","यो कौन जानय हय कि ऊ आदमी बुद्धिमान भय गयो या मूर्ख? तब भी धरती पर जितनी मेहनत मय न करयो, अऊर ओको लायी बुद्धि इस्तेमाल करी कि ऊ सब को उच अधिकारी होयेंन। यो भी बेकारच हय । ");
INSERT INTO lbm_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","तब मय अपनो मन म ऊ पूरो मेहनत को बारे म जो मय न धरती पर करयो होतो निराश भयो, ");
INSERT INTO lbm_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","कहालीकि असो मनुष्य भी हय, जेको काम मेहनत अऊर बुद्धि अऊर ज्ञान सी होवय हय अऊर सफल भी होवय हय, तब भी ओख असो आदमी लायी छोड़ जानो पड़य हय, जेन ओको म कुछ भी मेहनत नहीं करयो होना। यो भी बेकार अऊर बहुतच बुरो हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","आदमी जो धरती पर मन लगाय लगाय क मेहनत करय हय ओको सी ओख का फायदा होवय हय? ");
INSERT INTO lbm_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","ओको त सब दिन त दु:खों सी भरयो रह्य हंय, अऊर ओको काम रुकावट को संग होवय हय; रात ख भी ओको मन चैन नहीं लेवय। यो भी बेकारच हय। ");
INSERT INTO lbm_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","मनुष्य को लायी खान-पीवन अऊर मेहनत करतो हुयो अपनो जीवन ख सुखी रखन को सिवाय अऊर कुछ भी अच्छो नहाय। मय न देख्यो कि यो भी परमेश्वर को तरफ सी मिलय हय; ");
INSERT INTO lbm_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","कहालीकि ओको बिना कौन खाय-पी क आनन्द मनाय सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","जो आदमी परमेश्वर की नजर म अच्छो हय, ओख ऊ बुद्धि अऊर ज्ञान अऊर आनन्द देवय हय; पर पापी ख ऊ दु:ख भरयो कामच देवय हय कि ऊ ओख देन लायी जमा कर क् ढेर लगाये जो परमेश्वर की नजर म अच्छो हो। यो भी बेकार अऊर हवा ख पकड़नो हय । ");
INSERT INTO lbm_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","हर एक बात को एक अवसर अऊर हर काम को, जो धरती पर होवय हय, एक समय हय। ");
INSERT INTO lbm_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","जनम को समय, अऊर मरन को समय; अऊर बोयो हुयो ख उखाड़न को भी समय हय; ");
INSERT INTO lbm_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","मारन को समय, अऊर चंगो करन को भी समय; गिराय देन को समय, अऊर बनावन को भी समय हय; ");
INSERT INTO lbm_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","रोवन को समय, अऊर हंसन को भी समय; शोक करन को समय, अऊर नाचन को भी समय हय; ");
INSERT INTO lbm_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","गोटा फेकन को समय, अऊर गोटा जमा करन को भी समय ; गलो लगावन को समय, अऊर गलो लगावन सी रूकन को भी समय हय; ");
INSERT INTO lbm_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","ढूंढन को समय, अऊर खोय देन को भी समय; बचाय रखन को समय, अऊर फेक देन को भी समय हय; ");
INSERT INTO lbm_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","फाड़न को समय, अऊर सीवन को भी समय; चुप रहन को समय, अऊर बोलन को भी समय हय; ");
INSERT INTO lbm_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","प्रेम करन को समय, अऊर दुश्मनी करन को भी समय; लड़ायी करन को समय, अऊर मिलन को भी समय हय। ");
INSERT INTO lbm_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","काम करन वालो ख अपनी मेहनत सी का फायदा होवय हय? ");
INSERT INTO lbm_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","मय न देख्यो हय कि परमेश्वर न मानव जाति पर कितनो बोझ डाल्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","उन्न हर एक चिज ख ओको लायी सही समय मच बनायो हय; उन्न आदमी को दिल म अनन्त काल को ज्ञान की क्षमता दी, तब भी आदमी नहीं समझ पावय कि परमेश्वर न शुरू सी आखरी तक का करयो हय। ");
INSERT INTO lbm_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","मय न जान लियो हय कि मनुष्यों को लायी खुशी मनावय अऊर जीवन भर भलायी करन को सिवाय, अऊर कुछ भी अच्छो नहाय; ");
INSERT INTO lbm_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","अऊर यो भी परमेश्वर को दान आय कि मनुष्य खाये-पीये अऊर अपनो सब मेहनत म सुखी रहे। ");
INSERT INTO lbm_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","मय जानु हय कि जो कुछ परमेश्वर करय हय ऊ हमेशा स्थिर रहेंन; नहीं त ओको म कुछ बढ़ायो अऊर नहीं कुछ घटायो जाय सकय हय; परमेश्वर असो येकोलायी करय हय कि लोग ओको डर माने। ");
INSERT INTO lbm_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","जो कुछ भयो ऊ येकोसी पहिले भी होय चुक्यो हय; जो होन वालो हय, ऊ भय भी गयो हय; अऊर परमेश्वर बीती हुयी बातों ख फिर सी कह्य हय। ");
INSERT INTO lbm_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","फिर मय न धरती पर का देख्यो कि न्याय की जागा म अन्याय होवय हय, अऊर अच्छायी की जागा म भी बुरो काम होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","मय न मन म कह्यो, “परमेश्वर न्यायी अऊर दुष्ट दोयी को न्याय करेंन,” कहालीकि ओको यहां एक एक विषय अऊर एक एक काम को समय हय। ");
INSERT INTO lbm_vpl VALUES ("EC3_18","022_3_18","ECC","3","18","18","मय न मन म कह्यो, “यो येकोलायी होवय हय कि परमेश्वर मनुष्यों ख जांचे कि हि देख सके कि हि जनावर जसो हय।” ");
INSERT INTO lbm_vpl VALUES ("EC3_19","022_3_19","ECC","3","19","19","कहालीकि जसी मनुष्यों की वसी जनावरों की भी दशा होवय हय; दोयी की वाच दशा होवय हय, जसो एक मरय वसोच दूसरो भी मरय हय। सब की स्वास एक जसी हय, अऊर मनुष्य जनावर सी कुछ बढ़ क नहाय; सब कुछ बेकारच हय। ");
INSERT INTO lbm_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","सब एक जागा म जावय हंय; सब माटी सी बन्यो हंय, अऊर सब माटी म मिल जावय हंय। ");
INSERT INTO lbm_vpl VALUES ("EC3_21","022_3_21","ECC","3","21","21","का आदमियों को जीव ऊपर को तरफ चढ़य हय अऊर जनावरों को जीव खल्लो को तरफ जाय क माटी म मिल जावय हय? यो कौन जानय हय? ");
INSERT INTO lbm_vpl VALUES ("EC3_22","022_3_22","ECC","3","22","22","अत: मय न यो देख्यो कि येको सी जादा कुछ अच्छो नहाय कि मनुष्य अपनो कामों म खुश रहे कहालीकि ओको हिस्सा योच आय; कौन ओको पीछू होन वाली बातों ख वापस लाय क दिखाय सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EC4_1","022_4_1","ECC","4","1","1","तब मय न ऊ सब अत्याचार देख्यो जो जगत म होवय हय। अऊर का देख्यो, कि अत्याचार सहन वालो को आंसू बह्य रह्यो हंय, अऊर उन्ख कोयी शान्ति देन वालो नहीं! अत्याचार करन वालो को हाथ म शक्ति होती, पर उन्ख कोयी शान्ति देन वालो नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EC4_2","022_4_2","ECC","4","2","2","अऊर मय न घोषना करी हय, कि जो पहिले मर चुक्यो हय, हि उन जीवतों सी ज्यादा खुश हय। ");
INSERT INTO lbm_vpl VALUES ("EC4_3","022_4_3","ECC","4","3","3","पर मरयो हुयो अऊर जीन्दो आदमियों सी महान हय ऊ आदमी जेको जनम नहीं भयो हय, जेन धरती पर करयो जान वालो दुष्कर्मों ख नहीं देख्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EC4_4","022_4_4","ECC","4","4","4","तब मय न सब मेहनत को काम अऊर सब सफल कामों ख देख्यो जो लोग अपनो पड़ोसी सी जलन को वजह करय हंय। यो भी बेकार हय या मानो हवा ख पकड़नो जसो हय। ");
INSERT INTO lbm_vpl VALUES ("EC4_5","022_4_5","ECC","4","5","5","मूर्ख हाथ पर हाथ रख क बैठ्यो रह्य हय, अऊर मानो अपनो आप ख बर्बाद करय हय। ");
INSERT INTO lbm_vpl VALUES ("EC4_6","022_4_6","ECC","4","6","6","मुट्ठी भर मन को चैन, दोय मुट्ठी मेहनत सी बड़ो हय, जो मानो हवा ख पकड़नो हय। ");
INSERT INTO lbm_vpl VALUES ("EC4_7","022_4_7","ECC","4","7","7","तब मय न धरती पर या भी बेकार बात देखी। ");
INSERT INTO lbm_vpl VALUES ("EC4_8","022_4_8","ECC","4","8","8","कोयी अकेलो रह्य हय अऊर ओको कोयी नहाय; न ओको टुरा हय, न भाऊ हय तब भी ओको परिश्रम को अन्त नहीं होवय; न ओकी आंखी धन सी सन्तुष्ट होवय हंय; अऊर न ऊ कह्य हय, मय कोन्को लायी मेहनत करतो अऊर अपनो जीवन ख सुख शान्ति सी दूर रखू हय? यो भी बेकार अऊर दु:ख भरयो काम हय। ");
INSERT INTO lbm_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","एक सी दोय अच्छो हंय, कहालीकि उन्को मेहनत को अच्छो फर मिलय हय। ");
INSERT INTO lbm_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","यदि उन्को म सी एक गिरेंन, त दूसरो ओख उठायेंन; पर हाय ओको पर जो अकेलो होय क गिरेंन अऊर ओको कोयी उठान वालो नहाय। ");
INSERT INTO lbm_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","यदि दोय जन एक संग सोयेंन त हि गरम रहेंन, पर कोयी अकेलो कसो गरम होय सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","यदि कोयी अकेलो पर भारी होवय हय त हय, पर दोय ओको सामना कर सकेंन। जो दोरी तीन धागा सी बटी हो वा जल्दी नहीं टूटय। ");
INSERT INTO lbm_vpl VALUES ("EC4_13","022_4_13","ECC","4","13","13","बुद्धिमान जवान गरीब होन पर भी असो बूढ्ढा अऊर मूर्ख राजा सी ज्यादा अच्छो हय जो सलाह नहीं मानय, ");
INSERT INTO lbm_vpl VALUES ("EC4_14","022_4_14","ECC","4","14","14","होय सकय हय कि ऊ ओको राज्य म गरीब पैदा भयो हो या होय सकय हय कि ऊ जैलखाना सी निकल क राजा भयो होना। ");
INSERT INTO lbm_vpl VALUES ("EC4_15","022_4_15","ECC","4","15","15","मय न धरती पर घुमतो हुयो पूरो जीन्दो लोगों ख ऊ दूसरो जवान को तरफ जातो हुयो देख्यो, जो पहिले वालों की जागा लेयेंन। ");
INSERT INTO lbm_vpl VALUES ("EC4_16","022_4_16","ECC","4","16","16","हि सब लोग अनगिनत होतो जिन्को पर ऊ प्रधान भयो होतो। तब भी भविष्य म होन वालो लोग ओको वजह खुश नहीं होयेंन। नि:सन्देह यो भी बेकार हय, अऊर मानो हवा ख पकड़नो हय। ");
INSERT INTO lbm_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","जब तय परमेश्वर को भवन म जाये, तब सावधानी सी चलजो; सुनन लायी जवर जाजो मूर्खों को बलिदान चढ़ानो सी अच्छो हय; कहालीकि हि नहीं जानय कि बुरो करय हंय। ");
INSERT INTO lbm_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","बाते करन लायी उतावली मत करजो, अऊर न अपनो मन सी कोयी बात उतावली म परमेश्वर को आगु निकालजो, कहालीकि परमेश्वर स्वर्ग म हय अऊर तय धरती पर हय; येकोलायी तोरो वचन थोड़ोच हो। ");
INSERT INTO lbm_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","कहालीकि जसो काम की अधिकता को वजह सपनो देख्यो जावय हय, वसोच बहुत सी बातों को बोलन वालो मूर्ख ठह्यरय हय। ");
INSERT INTO lbm_vpl VALUES ("EC5_4","022_5_4","ECC","5","4","4","जब तय परमेश्वर लायी मन्नत मानजो, तब ओको पूरो करनो म देरी मत करजो; कहालीकि ऊ मूर्खों सी प्रसन्न नहीं होवय। जो मन्नत तय न मानी हय ओख पूरी करजो। ");
INSERT INTO lbm_vpl VALUES ("EC5_5","022_5_5","ECC","5","5","5","मन्नत मान क पूरी नहीं करनो सी मन्नत को नहीं माननोच अच्छो हय। ");
INSERT INTO lbm_vpl VALUES ("EC5_6","022_5_6","ECC","5","6","6","कोयी वचन कह्य क अपनो ख पाप म न फसाजो, अऊर न ईश्वर को दूत को आगु कह्यजो कि यो भूल सी भयो; परमेश्वर कहाली तोरी आवाज सुन क अप्रसन्न हो, अऊर तोरो हाथ को कार्यों ख नाश करे? ");
INSERT INTO lbm_vpl VALUES ("EC5_7","022_5_7","ECC","5","7","7","कहालीकि सपनो की अधिकता सी बेकार बातों की बढ़ायी होवय हय : पर तय परमेश्वर को डर मानजो। ");
INSERT INTO lbm_vpl VALUES ("EC5_8","022_5_8","ECC","5","8","8","यदि तय कोयी प्रदेश म गरीबों पर अत्याचार अऊर न्याय अऊर धर्म ख बिगड़तो देखजो, त येको सी चकित मत होजो; कहालीकि एक अधिकारी सी बड़ो दूसरो रह्य हय जेख इन बातों की सुधि रह्य हय, अऊर उन्को सी भी ज्यादा बड़ो रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("EC5_9","022_5_9","ECC","5","9","9","जमीन की उपज सब लायी हय, बल्की खेती सी राजा को भी काम निकलय हय। ");
INSERT INTO lbm_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","जो रुपया सी प्रेम रखय हय ऊ रुपया सी कभी सन्तुष्ट नहीं होयेंन; अऊर न जो बहुत धन सी प्रेम रखय हय, लाभ सी : यो भी बेकार हय। ");
INSERT INTO lbm_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","जब सम्पत्ति बढ़य हय, त ओको खान वालो भी बढ़य हय, तब ओको स्वामी ख येख छोड़ अऊर का लाभ होवय हय कि वा सम्पत्ति ख अपनी आंखी सी देखे? ");
INSERT INTO lbm_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","परिश्रम करन वालो चाहे थोड़ो खाये या बहुत, तब भी ओकी नींद सुख चैन सी होवय हय; पर धनी को धन बढ़न को वजह ओख नींद नहीं आवय। ");
INSERT INTO lbm_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","मय न धरती पर एक बड़ी बुरी बला देखी हय, मतलब ऊ धन जेख ओको मालिक न अपनोच नुकसान लायी रख्यो होना, ");
INSERT INTO lbm_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","अऊर ऊ कोयी बुरो काम म उड़ जावय हय, अऊर यदि ओको घर म टुरा पैदा होवय हय त ओको हाथ म कयी भी नहीं बचय। ");
INSERT INTO lbm_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","जसो ऊ अपनी माय को पेट सी निकल्यो वसोच नंगा लौट जायेंन; जसो आयो होतो, अऊर अपनो हाथ म अपनो मेहनत को फल नहीं लिजाय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","या भी एक बड़ी बला हय कि जसो ऊ आयो, ठीक वसोच ऊ जायेंन; ओख ऊ बेकार मेहनत सी अऊर का लाभ हय? ");
INSERT INTO lbm_vpl VALUES ("EC5_17","022_5_17","ECC","5","17","17","केवल येको कि ओन जीवन भर बेचैनी सी जेवन करयो, अऊर बहुतच दु:खित अऊर रोगी रह्यो अऊर गुस्सा भी करतो रह्यो? ");
INSERT INTO lbm_vpl VALUES ("EC5_18","022_5_18","ECC","5","18","18","सुन, जो भली बात मय न देखी हय, बल्की जो उचित हय, ऊ यो कि आदमी खाये अऊर पीये अऊर अपनी मेहनत सी जो ऊ धरती पर करय हय, अपनी पूरी उमर भर जो परमेश्वर न ओख दियो हय, सुखी रहे; कहालीकि ओको भाग योच हय। ");
INSERT INTO lbm_vpl VALUES ("EC5_19","022_5_19","ECC","5","19","19","बल्की हर एक आदमी जेख परमेश्वर न धन सम्पत्ति दी होना, अऊर उन्को सी आनन्द भोगन अऊर ओको म सी अपनो भाग लेन अऊर मेहनत करतो हुयो आनन्द करन की शक्ति भी दी हय : यो परमेश्वर को वरदान हय। ");
INSERT INTO lbm_vpl VALUES ("EC5_20","022_5_20","ECC","5","20","20","आदमी अपनो पूरो जीवन ख हमेशा लायी याद नहीं रखेंन, कहालीकि परमेश्वर ऊ आदमी ख उन कामों मच लगायो रखय हय, जिन कामों ख करनो म ऊ आदमी इच्छा रखय हय। ");
INSERT INTO lbm_vpl VALUES ("EC6_1","022_6_1","ECC","6","1","1","एक बुरायी जो मय न धरती पर देखी हय, वा आदमियों ख बहुत भारी लगय हय : ");
INSERT INTO lbm_vpl VALUES ("EC6_2","022_6_2","ECC","6","2","2","कोयी आदमी ख परमेश्वर धन सम्पत्ति अऊर प्रतिष्ठा यहां तक देवय हय कि जो कुछ ओको मन चाहवय हय ओख ओकी कुछ भी घटी नहीं होवय, तब भी परमेश्वर ओख ओको म सी खान नहीं देवय, कोयी दूसरोच ओख खावय हय; यो बेकार अऊर भयानक दु:ख हय। ");
INSERT INTO lbm_vpl VALUES ("EC6_3","022_6_3","ECC","6","3","3","यदि कोयी आदमी को सौ टुरा हो, अऊर ऊ बहुत साल जीन्दो रहे अऊर ओकी उमर बढ़ जाये, पर न ओको जीव प्रसन्न रहे अऊर न ओकी आखरी क्रिया करी जाये, त मय कहूं हय कि असो आदमी सी अधूरो समय को पैदा हुयो वालो बच्चा अच्छो हय। ");
INSERT INTO lbm_vpl VALUES ("EC6_4","022_6_4","ECC","6","4","4","कहालीकि ऊ बेकारच आयो अऊर अन्धारो म चली गयो, अऊर ओको नाम भी अन्धारो म लूक गयो; ");
INSERT INTO lbm_vpl VALUES ("EC6_5","022_6_5","ECC","6","5","5","अऊर न सूरज ख देख्यो, अऊर न कोयी चिज ख जाननो पायो; तब भी येख ऊ आदमी सी ज्यादा चैन मिल्यो। ");
INSERT INTO lbm_vpl VALUES ("EC6_6","022_6_6","ECC","6","6","6","हव, चाहे ऊ दोय हजार साल जीन्दो रहे, अऊर कुछ सुख भोगनो न पाये, त ओख का? का सब को सब एकच जागा नहीं जावय? ");
INSERT INTO lbm_vpl VALUES ("EC6_7","022_6_7","ECC","6","7","7","आदमी को पूरो परिश्रम ओको पेट लायी होवय हय तब भी ओको मन नहीं भरय। ");
INSERT INTO lbm_vpl VALUES ("EC6_8","022_6_8","ECC","6","8","8","जो बुद्धिमान हय ऊ मूर्ख सी कौन्सी बात म बढ़ क हय? अऊर कंगाल जो यो जानय हय कि यो जीवन म कसो तरह सी चलनो चाहिये, ऊ भी ओको सी कौन्सी बात म बढ़ क हय? ");
INSERT INTO lbm_vpl VALUES ("EC6_9","022_6_9","ECC","6","9","9","आंखी सी देख लेनो मन की इच्छा सी अच्छो हय; यो भी बेकार अऊर मानो हवा ख पकड़नो हय। ");
INSERT INTO lbm_vpl VALUES ("EC6_10","022_6_10","ECC","6","10","10","जो कुछ भी आदमी होना, ओख ओको नाम शुरू मच दियो गयो होतो : अऊर आदमी को बारे म यो प्रगट कर दियो गयो होतो, कि आदमी केवल माटीच आय। अऊर ऊ अपनो सी ताकतवर व्यक्ति सी लड़ नहीं सकय। ");
INSERT INTO lbm_vpl VALUES ("EC6_11","022_6_11","ECC","6","11","11","बहुत सी असी बाते हय जिन्को वजह जीवन अऊर भी बेकार होवय हय त फिर आदमी ख का लाभ? ");
INSERT INTO lbm_vpl VALUES ("EC6_12","022_6_12","ECC","6","12","12","कहालीकि आदमी अपनो क्षणिक जीवन परछायी को जसो बितावय हय कौन जानय हय कि ओको लायी अच्छो का हय? कहालीकि आदमी ख कौन बताय सकय हय कि ओको बाद दुनिया म का होयेंन? ");
INSERT INTO lbm_vpl VALUES ("EC7_1","022_7_1","ECC","7","1","1","अच्छो नाम की सुगन्ध अनमोल अत्तर सी अच्छो हय अऊर मृत्यु को दिन जनम को दिन सी अच्छो हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","भोज को त्यौहार म शामिल होन की अपेक्षा, शोक सी पीड़ित परिवार म जानो अच्छो हय; कहालीकि मरनोच सब आदमियों को अन्त हय। अऊर जो जीन्दो हय ऊ मन लगाय क येको पर सोचेंन। ");
INSERT INTO lbm_vpl VALUES ("EC7_3","022_7_3","ECC","7","3","3","हसी सी दु:ख उत्तम हय, कहालीकि मुंह पर को शोक सी मन सुधरह्य हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_4","022_7_4","ECC","7","4","4","बुद्धिमानों को मन शोक करन वालों को घर को तरफ लग्यो रह्य हय पर मूर्खों को मन आनन्द करन वालों को घर लग्यो रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","मूर्खों को गीत सुनन सी बुद्धिमान की फटकार सुननो उत्तम हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","कहालीकि मूर्खों की हसी वसीच होवय हय जसी हांडी को खल्लो जरती लकड़ी की चरचराहट जसी; यो भी बेकार हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_7","022_7_7","ECC","7","7","7","निश्चय अत्याचार की कमायी सी बुद्धिमान मूर्ख बन जावय हय; अऊर रीश्वत सी बुद्धि नाश होय जावय हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","कोयी काम की सुरूवात सी ओको अन्त उत्तम हय; अहंकारी आदमी की अपेक्षा धीरज रखन वालो आदमी उत्तम हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","अपनो मन म उतावली सी गुस्सा मत हो, कहालीकि गुस्सा मूर्खों कोच दिल म रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_10","022_7_10","ECC","7","10","10","यो मत कह्यजो, “कि अज सी बीत्यो हुयो कल उत्तम होतो?” कहालीकि यो बारे म तुम्हरो असो कह्यनो, बुद्धि द्वारा नहाय। ");
INSERT INTO lbm_vpl VALUES ("EC7_11","022_7_11","ECC","7","11","11","बुद्धि धन सम्पत्ति समान उत्तम हय, जीन्दो लोगों लायी बुद्धि लाभदायक हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_12","022_7_12","ECC","7","12","12","कहालीकि बुद्धि को आड़ धन को आड़ को जसो हय; पर ज्ञान सी यो लाभ हय कि ऊ अपनो रखन वालो को जीवन सुरक्षित रखय हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","परमेश्वर को काम पर नजर कर; जो चिज ख ओन टेढ़ो बनायो हय ओख कौन सीधो कर सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EC7_14","022_7_14","ECC","7","14","14","सुख को दिनों म आनन्द मनावो, अऊर दु:ख को दिनों म बिचार करो; कहालीकि परमेश्वर न सुख अऊर दु:ख दोयी ख बनायो हय, ताकि आदमी यो बात को भेद नहीं पा सके कि ओको बाद का होन वालो हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","मय न अपनो बेकार जीवन म यो सब कुछ देख्यो हय; कोयी न्यायी अपनो न्याय को काम करतो हुयो नाश होय जावय हय, अऊर दुष्ट बुरायी करतो हुयो लम्बी उमर हासिल करय हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","अपनो ख बहुत न्यायी मत बना, अऊर न अपनो ख ज्यादा बुद्धिमान बना; तय कहाली अपनोच नाश को वजह होजो? ");
INSERT INTO lbm_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","अत्यन्त दुष्ट भी मत बन, अऊर न मूर्ख बन; तय कहाली अपनो समय सी पहिले मरजो? ");
INSERT INTO lbm_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","यो अच्छो हय कि तय या बात ख पकड़्यो रह्य; अऊर न वा बात पर सी भी हाथ न उठाजो; कहालीकि जो परमेश्वर को भय मानय हय ऊ इन सब कठिनायियों सी पार होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","बुद्धि सीच बुद्धिमान व्यक्ति ख नगर को दस शासकों सी ज्यादा ताकत हासिल होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","निश्चयच धरती पर कोयी असो धार्मिक व्यक्ति नहाय जो सदा भलायीच करय हय, अऊर कभी पाप नहीं करय। ");
INSERT INTO lbm_vpl VALUES ("EC7_21","022_7_21","ECC","7","21","21","जो बाते आदमी कह्य हय, उन सब बातों पर कान मत लगावो, असो नहीं हो कि तुम सुनो कि तुम्हरो दास तुम्हरी निन्दा करत होतो। ");
INSERT INTO lbm_vpl VALUES ("EC7_22","022_7_22","ECC","7","22","22","तुम्हरो दिल जानय हय कि खुद तुम न भी बहुत बार दूसरो लोगों की निन्दा करी हंय। ");
INSERT INTO lbm_vpl VALUES ("EC7_23","022_7_23","ECC","7","23","23","यो सब मय न बुद्धि सी परख्यो हय; मय न कह्यो, “मय बुद्धिमान होय जाऊं,” लेकिन बुद्धि मोरो सी दूरच रही। ");
INSERT INTO lbm_vpl VALUES ("EC7_24","022_7_24","ECC","7","24","24","ऊ जो दूर अऊर बहुत ज्यादा गहरो हय, ओको भेद कौन पा सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EC7_25","022_7_25","ECC","7","25","25","मय न अपनो मन लगायो कि बुद्धि को बारे म जान लेऊ; कि खोज निकालूं अऊर ओको भेद जानु, कि मूर्खता अधर्म हय, अऊर मूर्खता पागलपन हय ख जानु। ");
INSERT INTO lbm_vpl VALUES ("EC7_26","022_7_26","ECC","7","26","26","मय न मृत्यु सी भी ज्यादा दु:खदायी एक चिज पायी, मतलब वा स्त्री जेको मन फन्दा अऊर जाल हय अऊर जेको हाथ हथकड़ियां हय जो आदमी सी परमेश्वर प्रसन्न हय उच ओको सी बचेंन, पर पापी ओको शिकार होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EC7_27","022_7_27","ECC","7","27","27","देख, उपदेशक कह्य हय, मय न ज्ञान लायी अलग अलग बाते मिलाय क जाची, अऊर या बात निकाली, ");
INSERT INTO lbm_vpl VALUES ("EC7_28","022_7_28","ECC","7","28","28","जेख मोरो मन अब तक ढूंढ़ रह्यो हय, पर नहीं पायो। हजार आदमी म सी मय न एक आदमी ख पायो, पर उन्म मोख एक भी स्त्री नहीं मिली। ");
INSERT INTO lbm_vpl VALUES ("EC7_29","022_7_29","ECC","7","29","29","देखो, मय न केवल या बात पायी हय कि परमेश्वर न आदमी ख सीधो बनायो, पर उन्न बहुत सी योजना निकाली हंय। ");
INSERT INTO lbm_vpl VALUES ("EC8_1","022_8_1","ECC","8","1","1","बुद्धिमान आदमी को जसो कौन हय? अऊर कोयी बात को अर्थ कौन लगाय सकय हय? आदमी की बुद्धि को वजह ओको मुंह चमकय, अऊर ओको चेहरा को दु:ख दूर होय जावय हय। ");
INSERT INTO lbm_vpl VALUES ("EC8_2","022_8_2","ECC","8","2","2","मय तोख सलाह देऊ हय कि परमेश्वर को आगु ली गयी कसम को वजह राजा की आज्ञा को पालन कर। ");
INSERT INTO lbm_vpl VALUES ("EC8_3","022_8_3","ECC","8","3","3","राजा को आगु सी उतावली को संग मत लौटजो अऊर न बुरी बात पर खड़ो रह्यजो, कहालीकि ऊ जो कुछ चाहवय हय ऊ करय हय। ");
INSERT INTO lbm_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","कहालीकि राजा को वचन म त सामर्थ रह्य हय, अऊर कौन ओको सी कह्य सकय हय कि तय का करय हय? ");
INSERT INTO lbm_vpl VALUES ("EC8_5","022_8_5","ECC","8","5","5","यदि राजा की आज्ञा को पालन करय हय, त ऊ सुरक्षित रहेंन, पर बुद्धिमान व्यक्ति असो करन को ऊ सही समय जानय हय अऊर ऊ यो भी जानय हय कि या बात कब करनो चाहिये। ");
INSERT INTO lbm_vpl VALUES ("EC8_6","022_8_6","ECC","8","6","6","हर एक बात को ठह्यरायो हुयो समय अऊर ओको ठहरायी हुयी काम की विधि होवय हय, नहीं त आदमी को दु:ख ओको लायी बहुत भारी होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC8_7","022_8_7","ECC","8","7","7","ऊ नहीं जानय कि का होन वालो हय, अऊर कब होयेंन? यो ओख कौन बताय सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EC8_8","022_8_8","ECC","8","8","8","असो कोयी आदमी नहाय जेको वश जीव पर चले कि ऊ ओख निकलतो समय रोख ले, अऊर न कोयी मृत्यु को दिन पर अधिकारी होवय हय; अऊर न ओख लड़ायी सी छुट्टी मिल सकय हय, अऊर न दुष्ट लोग अपनी दुष्टता को वजह बच सकय हंय। ");
INSERT INTO lbm_vpl VALUES ("EC8_9","022_8_9","ECC","8","9","9","जितनो काम धरती पर करयो जावय हय उन सब ख ध्यान सी देखनो म यो सब कुछ मय न देख्यो, अऊर यो भी देख्यो कि एक आदमी दूसरो आदमी पर अधिकारी होय क अपनो ऊपर हानि लावय हय ");
INSERT INTO lbm_vpl VALUES ("EC8_10","022_8_10","ECC","8","10","10","तब मय न दुष्टों ख कबर म गाड़्यो जातो हुयो देख्यो; हि पवित्र जागा म आत जात होतो। नगर म जित उन्न हर तरह को दुष्कर्म करयो होतो, उन्की प्रशंसा करी जात होती। यो भी बेकार हय । ");
INSERT INTO lbm_vpl VALUES ("EC8_11","022_8_11","ECC","8","11","11","बुरो काम की दण्ड की आज्ञा फुर्ती सी नहीं दी जावय; यो वजह आदमियों को मन बुरो काम करन की इच्छा सी भरयो रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","चाहे पापी सौ बार पाप करे अऊर अपनो दिन भी बढ़ाये, तब भी मोख निश्चय हय कि जो परमेश्वर सी डरय हंय अऊर ओख अपनो सम्मुख जान क डर सी चलय हय, उन्को भलाच होयेंन; ");
INSERT INTO lbm_vpl VALUES ("EC8_13","022_8_13","ECC","8","13","13","पर दुष्ट को भला नहीं होन को, अऊर न ऊ छाया को जसो अपनी उमर लम्बी कर सकेंन, कहालीकि ऊ परमेश्वर को डर नहीं मानय। ");
INSERT INTO lbm_vpl VALUES ("EC8_14","022_8_14","ECC","8","14","14","एक बेकार बात धरती पर होवय हय, मतलब असो न्यायी हंय जिन्की वसी दशा होवय हय जो दुष्टों की होनी चाहिये, अऊर असो दुष्ट हय जिन्की वसी दशा होवय हय जो न्यायियों की होनी चाहिये। मय न कह्यो की यो भी बेकारच हय। ");
INSERT INTO lbm_vpl VALUES ("EC8_15","022_8_15","ECC","8","15","15","येकोलायी मय लोगों ख सलाह देऊ हय, आनन्द मनावो, धरती पर आदमी लायी खान पीन अऊर आनन्द मनान को सिवाय अऊर कुछ भी अच्छो नहाय। जो उमर परमेश्वर न ओख या धरती पर प्रधान करी हय, ओको परिश्रम म ओको संग बन्यो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","जब मय न बुद्धि हासिल करन लायी अऊर सब काम देखन लायी जो धरती पर करयो जावय हय अपनो मन लगायो, कि कसो आदमी रात दिन जागतो रह्य हंय; ");
INSERT INTO lbm_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","तब मोख अनुभव भयो कि परमेश्वर को पूरो काम जो सूरज को खल्लो या धरती पर होवय हय, चाहे आदमी ओको भेद जानन लायी कितनोच परिश्रम का न करे, ऊ ओको पता नहीं लगाय सकय। यदि कोयी बुद्धिमान आदमी ओख जानन को दावा करे, त भी ऊ ओको पता नहीं लगाय सकय। ");
INSERT INTO lbm_vpl VALUES ("EC9_1","022_9_1","ECC","9","1","1","यो सब कुछ मय न मन लगाय क गम्भीर होय क बिचार करयो इन सब बातों को भेद पाऊं, कि कसो तरह न्यायी अऊर बुद्धिमान लोग अऊर उन्को काम परमेश्वर को हाथ म हय; आदमी को आगु सब तरह की बातें हंय पर ऊ नहीं जानय कि ऊ प्रेम आय या दुश्मनी। ");
INSERT INTO lbm_vpl VALUES ("EC9_2","022_9_2","ECC","9","2","2","सब बाते सभी लायी एक जसी होवय हय, न्यायी हो या दुष्ट, भलो, शुद्ध या अशुद्ध, बली करन वालो अऊर बली नहीं करन वालो, सभी की दशा एक जसीच होयेंन। जसो भलो आदमी की दशा, वसीच पापी की भी दशा; जसो कसम खान वालो की दशा; वसीच ओकी जो कसम खानो सी डरय हय। ");
INSERT INTO lbm_vpl VALUES ("EC9_3","022_9_3","ECC","9","3","3","जो कयी सूरज को खल्लो करयो जावय हय ओको म या एक बुरी बात देखी कि सब लोगों की एक जसी दशा होवय; अऊर आदमियों को मनो म बुरायी भरी हुयी हय, अऊर जब तक हि जीन्दो रह्य हय उन्को मन म पागलपन भरयो रह्य हय, अऊर ओको बाद हि मरयो हुयो म जाय मिलय हंय। ");
INSERT INTO lbm_vpl VALUES ("EC9_4","022_9_4","ECC","9","4","4","जब तक आदमी जीन्दो रह्य हय, ओको दिल म आशा को दीया चमकतो रह्य हय, कहालीकि जीन्दो कुत्ता मरयो हुयो सिंह सी बढ़ क हय। ");
INSERT INTO lbm_vpl VALUES ("EC9_5","022_9_5","ECC","9","5","5","कहालीकि जो जीन्दो हंय हि जानय हंय कि उन्ख एक दिन मरनोच पड़ेंन, पर जो मर गयो हय, हि का जानय हय? उन्ख प्रतिफल मिल गयो हय, कहालीकि उन्की याद मिट गयी हय। ");
INSERT INTO lbm_vpl VALUES ("EC9_6","022_9_6","ECC","9","6","6","उन्को प्रेम अऊर उन्की नफरत अऊर उन्की दुश्मनी नाश भय गयी हय, अऊर अब जो कयी धरती पर करयो जावय हय ओको म हमेशा लायी उन्को अऊर कोयी भाग नहीं होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EC9_7","022_9_7","ECC","9","7","7","अपनी रस्ता पर चली जा, अपनी रोटी आनन्द सी खायो कर, अऊर मन म सुख मान क अपनो अंगूरीरस पीयो कर; कहालीकि परमेश्वर तोरो कामों सी प्रसन्न भय गयो हय। ");
INSERT INTO lbm_vpl VALUES ("EC9_8","022_9_8","ECC","9","8","8","तोरो कपड़ा हमेशा साफ रहे, अऊर तोरी मुंड पर हमेशा तेल लग्यो रहे। ");
INSERT INTO lbm_vpl VALUES ("EC9_9","022_9_9","ECC","9","9","9","अपनो बेकार जीवन को पूरो दिन जो ओन धरती पर तोरो लायी ठह्यरायो हय, अपनी प्यारी पत्नी को संग म बिताजो, कहालीकि तोरो जीवन अऊर तोरो परिश्रम म जो तय धरती पर करय हय तोरो योच भाग हय। ");
INSERT INTO lbm_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","जो काम तोख मिले ओख अपनी पूरी शक्ति सी करजो, कहालीकि अधोलोक म जहां अपनो मरन को बाद तय जान वालो हय, न काम हय, न बिचार अऊर वहां न ज्ञान हय अऊर न बुद्धि। ");
INSERT INTO lbm_vpl VALUES ("EC9_11","022_9_11","ECC","9","11","11","तब मय न धरती पर देख्यो कि न त दौड़ म तेज दौड़न वालो अऊर न ताकतवर योद्धा लड़ायी जीतय; बुद्धिमान आदमी ख जेवन नहीं मिलय, अऊर न समझदारों ख धन सम्पत्ति, विद्वानों पर कोयी कृपा नहीं करय; हि सब समय अऊर संयोग को वश म हय। ");
INSERT INTO lbm_vpl VALUES ("EC9_12","022_9_12","ECC","9","12","12","कहालीकि आदमी अपनो समय नहीं जानय। जसी मच्छियां दु:खदायी जार म अऊर चिड़ियां फन्दा म फसय हंय, वसोच आदमी दु:खदायी समय म जो उन्को पर अचानक आय पड़य हय, फस जावय हय। ");
INSERT INTO lbm_vpl VALUES ("EC9_13","022_9_13","ECC","9","13","13","मय न धरती पर यो तरह की बुद्धि की बात भी देखी हय, जो मोख बड़ी महत्व की लगी। ");
INSERT INTO lbm_vpl VALUES ("EC9_14","022_9_14","ECC","9","14","14","एक छोटो सो नगर होतो, जेको म थोड़ोच लोग होतो, अऊर कोयी बड़ो राजा न ओको पर चढ़ायी कर क् ओख घेर लियो, अऊर ओको खिलाफ बड़ी घेराबन्दी कर दी। ");
INSERT INTO lbm_vpl VALUES ("EC9_15","022_9_15","ECC","9","15","15","पर ओको म तक गरीब बुद्धिमान आदमी पायो गयो, अऊर ओन ऊ नगर ख अपनी बुद्धि को द्वारा बचायो। तब भी कोयी न ऊ गरीब आदमी ख याद नहीं रख्यो। ");
INSERT INTO lbm_vpl VALUES ("EC9_16","022_9_16","ECC","9","16","16","तब मय न कह्यो, “अगर गरीब की बुद्धि एकदम बेकार समझी जावय हय अऊर ओको वचन कोयी नहीं सुनय तब भी ताकत सी बुद्धि अच्छी हय।” ");
INSERT INTO lbm_vpl VALUES ("EC9_17","022_9_17","ECC","9","17","17","मूर्खों को बीच राजा ख चिल्लाय क कह्यनो सी अकेलो म बुद्धिमान की बाते सुन लेनो कही ज्यादा अच्छो हय। ");
INSERT INTO lbm_vpl VALUES ("EC9_18","022_9_18","ECC","9","18","18","लड़ायी को हथियारों सी बुद्धि अच्छी हय, पर एक पापी बहुत सी भलायी को नाश करय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","मरी हुयी माखी को वजह अत्तर को सड़नो अऊर बास आवन लगय हय; अऊर थोड़ी सी मूर्खता बुद्धि अऊर मान सम्मान ख घटाय देवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_2","022_10_2","ECC","10","2","2","बुद्धिमान को मन उचित बात को तरफ रह्य हय पर मूर्ख को मन ओको खिलाफ रह्य हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_3","022_10_3","ECC","10","3","3","जब मूर्ख रस्ता पर चलतो हुयो जावय हय, तब ओको चलनो सीच ओकी मूर्खता दिख जावय हय, जेको सी हर व्यक्ति देख लेवय हय, कि ऊ मूर्ख हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_4","022_10_4","ECC","10","4","4","यदि शासक को गुस्सा तोरो पर भड़के, त अपनी जागा मत छोड़जो, कहालीकि धीरज धरनो सी बड़ो बड़ो अपराध रुकय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_5","022_10_5","ECC","10","5","5","एक बुरायी हय जो मय न धरती पर देखी, या बुरायी शासक की भूल सी होवय हय : ");
INSERT INTO lbm_vpl VALUES ("EC10_6","022_10_6","ECC","10","6","6","मतलब मूर्ख बड़ी मान सम्मान की जागा म ठह्यरायो जावय हंय, अऊर धनवान लोग खल्लो बैठय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_7","022_10_7","ECC","10","7","7","मय न गुलामों ख घोड़ा पर जातो देख्यो हय, जब की शासक गुलामों को तरह पैदल चल रह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EC10_8","022_10_8","ECC","10","8","8","जो दूसरो लायी गड्डा खोदय हय ऊ खुद ओको म गिरेंन अऊर जो दीवार तोड़य ओख सांप डसेन। ");
INSERT INTO lbm_vpl VALUES ("EC10_9","022_10_9","ECC","10","9","9","जो गोटा फोड़ेंन, ऊ गोटा सीच घायल होयेंन, अऊर जो लकड़ी काटेंन, ओख लकड़ी सीच डर रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EC10_10","022_10_10","ECC","10","10","10","यदि टंगिया बोथड़ हो अऊर आदमी ओकी धार ख पैनी नहीं करेंन, त ओख उपयोग करनो म ज्यादा ताकत लगानो पड़ेंन; पर सफल होन लायी बुद्धि सी लाभ होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_11","022_10_11","ECC","10","11","11","यदि मंत्र सी पहिले सांप डसेन, त मंत्र पढ़न वालो ख कुछ भी लाभ नहीं। ");
INSERT INTO lbm_vpl VALUES ("EC10_12","022_10_12","ECC","10","12","12","बुद्धिमान को शब्द को वजह अनुग्रह होवय हय, पर मूर्ख अपनो शब्द को द्वारा नाश होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_13","022_10_13","ECC","10","13","13","मूर्ख को मुंह सी निकल्यो शब्द सुरूवात सी आखरी तक मूर्खता सी पूरो होवय हय, ओकी बात को अन्त दुष्टतापूर्ण पागलपन होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_14","022_10_14","ECC","10","14","14","मूर्ख आदमी बहुत बाते बढ़ाय क बोलय हय, तब भी कोयी आदमी नहीं जानय कि का होयेंन, अऊर कौन बताय सकय हय कि ओको बाद का होन वालो हय? ");
INSERT INTO lbm_vpl VALUES ("EC10_15","022_10_15","ECC","10","15","15","मूर्ख को परिश्रम ओख थकावय हय, इतनो कि ओख वापसी लायी नगर की रस्ता भी नहीं जानय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_16","022_10_16","ECC","10","16","16","हे देश, तोरो पर हाय जब तोरो राजा बिना अनुभव वालो सेवक आय अऊर तोरो शासक प्रात:काल भोज करय हंय! ");
INSERT INTO lbm_vpl VALUES ("EC10_17","022_10_17","ECC","10","17","17","हे देश, तय धन्य हय जब तोरो राजा अच्छो वंशज सी हय, अऊर तोरो शासक समय पर भोज करय हंय, अऊर ऊ भी मतवालो होन ख नहीं, बल्की ताकत हासिल करन लायी! ");
INSERT INTO lbm_vpl VALUES ("EC10_18","022_10_18","ECC","10","18","18","आलस को वजह छत गिर जावय हय, अऊर सुस्ती सी घर चुनो लगय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_19","022_10_19","ECC","10","19","19","भोज हसी खुशी लायी करयो जावय हय, अऊर अंगूरीरस सी जीवन ख आनन्द मिलय हय; अऊर रुपया सी सब कुछ हासिल होवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","अपनो मन म भी राजा की निन्दा मत करो, अऊर न अपनी आराम की जागा म रईसों की बुरायी करो। आसमान को पक्षी तोरो शब्द लिजायेंन, अऊर कोयी उड़न वालो जीव जन्तु खबर कर देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EC11_1","022_11_1","ECC","11","1","1","अपनी रोटी पानी को ऊपर डाल दे, कहालीकि बहुत दिन को बाद तय ओख फिर पाजो। ");
INSERT INTO lbm_vpl VALUES ("EC11_2","022_11_2","ECC","11","2","2","सात बल्की आठ जनों ख भी भाग दे, कहालीकि तय नहीं जानय कि धरती पर का विपत्ति आय पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("EC11_3","022_11_3","ECC","11","3","3","यदि बादर पानी सी भरयो हय, तब ऊ खुद जमीन पर बरसेंन, अऊर झाड़ चाहे दक्षिन को तरफ गिरे या उत्तर को तरफ, तब भी जो जागा पर झाड़ गिरेंन, ऊ वहांच पड़्यो रहेंन ");
INSERT INTO lbm_vpl VALUES ("EC11_4","022_11_4","ECC","11","4","4","जो वायु ख ताकतो रहेंन ऊ बीज बोवनो नहीं पायेंन, अऊर जो बादर ख देखतो रहेंन ऊ फसल काट नहीं पायेंन। ");
INSERT INTO lbm_vpl VALUES ("EC11_5","022_11_5","ECC","11","5","5","जसो तय हवा चलन की रस्ता नहीं जानय अऊर कसो तरह सी गर्भवती को पेट म बच्चा बढ़य हंय, वसोच तय परमेश्वर को काम नहीं जानय जो सब कुछ करय हय। ");
INSERT INTO lbm_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","पहेट ख अपनो बीज बोव, अऊर शाम ख भी अपनो हाथ मत रोक; कहालीकि तय नहीं जानय कि कौन सफल होयेंन, यो काम म या ऊ काम म, या दोयी को दोयी अच्छो निकलेंन। ");
INSERT INTO lbm_vpl VALUES ("EC11_7","022_11_7","ECC","11","7","7","उजारो बहुत प्रिय होवय हय, अऊर तपन ख देखन सी आंखी ख सुख पहुंचय हय। ");
INSERT INTO lbm_vpl VALUES ("EC11_8","022_11_8","ECC","11","8","8","यदि आदमी बहुत साल तक जीन्दो रहे, त ओख लगय हय कि ऊ अपनी उमर को सब सालो म जीवन को आनन्द ले; पर ऊ याद रखे कि अन्धारो को दिन भी कम नहीं होयेंन। जो कयी होवय हय ऊ बेकार हय। ");
INSERT INTO lbm_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","हे जवान,अपनी जवानी म आनन्द कर, अऊर अपनी जवानी को दिनों म मगन रह; अपनी मनमानी कर अऊर अपनी आंखी की नजर को जसो चल। पर यो जान रख कि इन सब बातों को बारे म परमेश्वर तोरो न्याय करेंन। ");
INSERT INTO lbm_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","अपनो मन सी परेशानी अऊर शरीर सी दु:ख दूर कर, कहालीकि लड़कपन अऊर जवानी दोयी बेकार हंय। ");
INSERT INTO lbm_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","अपनी जवानी को दिनों म अपनो सृजनहार ख याद रख, येको सी पहिले कि विपत्ति को दिन अऊर हि साल आये, जिन्म तय कह्यजो कि मोख इन दिनों म आनन्द नहीं मिलय। ");
INSERT INTO lbm_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","येको सी पहिले कि सूरज अऊर प्रकाश अऊर चन्दा अऊर तारा अन्धकारमय होय जाये, अऊर पानी आन को बाद बादर फिर घिर जाये; ");
INSERT INTO lbm_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","ऊ समय घर को सब रक्षा करन वालो कापेंन, अऊर ताकतवर झुक जायेंन, संख्या म कम होन को वजह दांत जेवन चबानो छोड़ देयेंन। खिड़की सी झाकन वाली आंखी धुंधली पड़ जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","अऊर सड़क की आवाज तुम्हरो कान ख सुनायी नहीं देयेंन, अऊर चक्की की आवाज धीरू होय जायेंन, अऊर पहेट ख चिड़िया को चिवचिव की आवाज सी एक उठ जायेंन, अऊर सब गावन वाली की आवाज धीरू होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","फिर जो ऊंचो हो ओको सी डर लगेंन, अऊर रस्ता म डरावनी चिजे सी डरजो; अऊर बदाम को झाड़ फूलेंन, अऊर फाफा भी रेंग क चलन लगेंन, अऊर भूक बढ़ावन वालो फर फिर काम नहीं देयेंन; कहालीकि आदमी अपनो सदा को घर ख जायेंन, अऊर रोवन पीटन वालो सड़क सड़क फिरेंन। ");
INSERT INTO lbm_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","ऊ समय चांदी को तार दोय टुकड़ा होय जायेंन अऊर सोनो को कटोरा टूटेंन, अऊर झरना को जवर घड़ा फूटेंन, अऊर कुंवा को जवर गिरनी टूट जायेंन, ");
INSERT INTO lbm_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","तब माटी जसी की वसी माटी म मिल जायेंन, अऊर आत्मा परमेश्वर जवर लौट जायेंन, जेन ओख प्रदान करयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","उपदेशक कह्य हय, सब बेकारच बेकार हय; सब कयी बेकार हय। ");
INSERT INTO lbm_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","उपदेशक जो बुद्धिमान होतो, ऊ प्रजा ख ज्ञान भी सिखावत रह्यो, अऊर ध्यान लगाय क अऊर जांच परख कर क् बहुत सो नीतिवचन क्रम सी रखत होतो। ");
INSERT INTO lbm_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","उपदेशक न मन भावन वालो शब्द ढूंढ्यो अऊर सच्चायी की शिक्षा देन वालो शब्द लिख्यो। ");
INSERT INTO lbm_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","बुद्धिमान लोगों को शब्द धार दार होवय हय, अऊर सभावों को मुखियां को द्वारा दियो गयो शब्द, मजबूती सी ठोकी गयी खूंटियों को जसो हंय, कहालीकि इन्को दाता एकच चरवाहा आय। ");
INSERT INTO lbm_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","हे मोरो टुरा, इन्को अलावा दूसरी शिक्षावों को बारे म सावधानी रख। बहुत सी किताबों ख लिख क रखन को कोयी अन्त नहाय, अऊर किताबों ख ज्यादा पढ़नो भी शरीर ख थकाय देवय हय। ");
INSERT INTO lbm_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","सब कुछ सुन्यो गयो; अन्त की बात या आय कि परमेश्वर को डर मान अऊर ओकी आज्ञावों को पालन कर; कहालीकि आदमी को पूरो कर्तव्य योच आय। ");
INSERT INTO lbm_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","कहालीकि परमेश्वर सब कामों अऊर सब गुप्त बातों को, चाहे हि भली हो या बुरी, न्याय करेंन।");
INSERT INTO lbm_vpl VALUES ("EK1_1","027_1_1","EZK","1","1","1","कहालीकि तीसवों साल को चौथो महीना को पाचवों दिन, मय बन्दियों को बीच कबार नदी को किनार पर होतो, तब स्वर्ग खुल गयो, अऊर मय न परमेश्वर को दर्शन पायो। ");
INSERT INTO lbm_vpl VALUES ("EK1_2","027_1_2","EZK","1","2","2","यहोयाकीन राजा की बन्धुवायी को पाचवों साल को चौथो महीना को पाचवों दिन ख, कसदियों को देश म कबार नदी को किनार पर, ");
INSERT INTO lbm_vpl VALUES ("EK1_3","027_1_3","EZK","1","3","3","परमेश्वर को वचन बूजी को टुरा यहेजकेल याजक को जवर पहुंच्यो; अऊर परमेश्वर की सामर्थ ओको पर वहांच प्रगट भयी। ");
INSERT INTO lbm_vpl VALUES ("EK1_4","027_1_4","EZK","1","4","4","जब मय देखन लग्यो, त का देखू हय कि उत्तर दिशा सी बड़ो बादर, अऊर लहराती हुयी आगी सहित बड़ी आन्धी आय रह्यी हय, अऊर घटा को चारयी तरफ प्रकाश अऊर आगी को बीचों-बीच सी चमकतो हुयो पीतल को जसो कुछ दिखायी देवय हय। ");
INSERT INTO lbm_vpl VALUES ("EK1_5","027_1_5","EZK","1","5","5","अऊर ओको बीच सी चार जीवधारी प्रानियों को जसो कुछ दिखायी दे रह्यो होतो। उन्को रूप आदमियों को जसो होतो, ");
INSERT INTO lbm_vpl VALUES ("EK1_6","027_1_6","EZK","1","6","6","पर उन्म सी हर एक को चार चार मुख अऊर चार चार पंख होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_7","027_1_7","EZK","1","7","7","उन्को पाय सीधो होतो, अऊर उन्को पाय को तलवा बछड़ा को खुरी को जसो होतो; अऊर हि चमकायो हुयो पीतल को जसो चमकत होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_8","027_1_8","EZK","1","8","8","उन्को चारयी तरफ पंखा को खल्लो आदमी को जसो हाथ होतो। उन चारयी को मुख अऊर पंख यो तरह होतो : ");
INSERT INTO lbm_vpl VALUES ("EK1_9","027_1_9","EZK","1","9","9","उन्को पंख एक दूसरो सी परस्पर जुड़्यो हुयो होतो; हि अपनो अपनो सामने सीधोच चलत होतो हि मुड़त नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_10","027_1_10","EZK","1","10","10","उन्को सामने को मुख को रूप आदमी को जसो होतो अऊर उन चारयी को दायो तरफ को मुख सिंह को जसो, अऊर बायो तरफ को मुख बईल को जसो होतो, अऊर चारयी को पीछु को मुख उकाब पक्षी को जसो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_11","027_1_11","EZK","1","11","11","उन्को चेहरा असोच होतो। उन्को मुख अऊर पंख ऊपर को तरफ अलग अलग होतो, हर एक जीवधारी को दोय दोय पंख होतो, जो एक दूसरो को पंख मिल्यो हुयो होतो, अऊर दोय दोय पंखों सी उन्को शरीर ढक्यो हुयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_12","027_1_12","EZK","1","12","12","हि सीधो अपनो अपनो सामनेच चलत होतो; जित आत्मा जानो चाहत होती, हि उतच जात होतो, अऊर चलतो समय मुड़त नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_13","027_1_13","EZK","1","13","13","जीवधारियों को रूप आगी अऊर जलती हुयी मशालों को समान दिखायी देत होतो, अऊर वा आगी जीवधारियों को बीच इत उत चलती फिरती हुयी बड़ो प्रकाश देत रह्यी; अऊर वा आगी सी बिजली निकलत होती। ");
INSERT INTO lbm_vpl VALUES ("EK1_14","027_1_14","EZK","1","14","14","जीवधारियों को चलनो फिरनो बिजली को जसो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_15","027_1_15","EZK","1","15","15","जब मय जीवधारियों ख देखतोच रह्यो होतो, त का देख्यो कि जमीन पर उन्को जवर चारयी मुखों की गिनती को अनुसार, एक एक पहिया होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_16","027_1_16","EZK","1","16","16","उन पहियों कि चमक अऊर बनावट स्वर्णमनि जसी होती, अऊर चारयी को एकच रूप होतो; अऊर उन्को रूप अऊर बनावट असी होती जसो एक पहिया को बीच दूसरो पहिया होना। ");
INSERT INTO lbm_vpl VALUES ("EK1_17","027_1_17","EZK","1","17","17","चलतो समय हि अपनो चारयी तरफ चल सकत होतो, अऊर चलन म मुड़त नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_18","027_1_18","EZK","1","18","18","उन चारयी को घेरा बहुत बड़ो अऊर डरावनो होतो, अऊर उन्को घेरावों म चारयी तरफ आंखीच आंखी होती। ");
INSERT INTO lbm_vpl VALUES ("EK1_19","027_1_19","EZK","1","19","19","जब जीवधारी चलत होतो, तब पहिया भी उन्को संग चलत होतो; अऊर जब जीवधारी जमीन पर सी उठत होतो, तब पहिया भी उठत होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_20","027_1_20","EZK","1","20","20","जित आत्मा जानो चाहत होती, उतच हि जात होतो, अऊर पहिया जीवधारियों को संग उठत होतो; कहालीकि उन्की आत्मा पहिया म होती। ");
INSERT INTO lbm_vpl VALUES ("EK1_21","027_1_21","EZK","1","21","21","जब हि चलत होतो तब हि भी चलत होतो; अऊर जब जब हि खड़ो होत होतो तब हि भी खड़ो होत होतो, अऊर जब हि जमीन पर सी उठत होतो तब पहिया भी उन्को संग उठत होतो; कहालीकि जीवधारियों की आत्मा पहियों म होती। ");
INSERT INTO lbm_vpl VALUES ("EK1_22","027_1_22","EZK","1","22","22","जीवधारियों को मुंड को ऊपर आकाश मण्डल को जसो कुछ होतो जो बरफ को समान भयानक रीति सी चमकत होतो, अऊर ऊ उन्को मुंड को ऊपर फैल्यो हुयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_23","027_1_23","EZK","1","23","23","आकाश मण्डल को खल्लो, उन्को पंख एक दूसरो को तरफ सीधो फैल्यो हुयो होतो; अऊर हर एक जीवधारी को दोय दोय अऊर भी पंख होतो जिन्कोसी उन्को शरीर झक्यो हुयो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_24","027_1_24","EZK","1","24","24","उन्को चलतो समय उन्को पंखा की फड़फड़ाहट की आवाज मोख बहुत सो पानी, यां सर्वशक्तिमान की वाणी, यां सेना की हलचल की आवाज सुनायी पड़त होती; अऊर जब हि खड़ो होत होतो, तब अपनो पंख लटकाय देत होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_25","027_1_25","EZK","1","25","25","फिर उन्को मुंडो को ऊपर जो आकाश मण्डल होतो, ओको ऊपर सी एक आवाज सुनायी पड़त होतो; अऊर जब हि खड़ो होत होतो, तब अपनो पंख खल्लो कर देत होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_26","027_1_26","EZK","1","26","26","जो आकाश मण्डल उन्को मुंडो को ऊपर होतो, ओको ऊपर मानो कुछ नीलम गोटा को बन्यो हुयो सिंहासन को ऊपर आदमी को समान कोयी दिखायी देत होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_27","027_1_27","EZK","1","27","27","ओकी कमर सी ले क ऊपर को तरफ मोख मानो चमकायो हुयो पीतल जसो दिखायी पड़्यो, अऊर ओको अन्दर अऊर चारयी तरफ आगी जसी दिखायी पड़त होती; पर ऊ आदमी की कमर सी ले क खल्लो को तरफ भी मोख कुछ आगी जसी दिखायी पड़त होती; अऊर ओको चारयी तरफ प्रकाश होतो। ");
INSERT INTO lbm_vpl VALUES ("EK1_28","027_1_28","EZK","1","28","28","जसो बारीश को दिन बादर म धनुष दिखायी पड़य हय, वसोच चारयी तरफ को प्रकाश दिखायी देत होतो। परमेश्वर की सामर्थ असीच होती। ओख देख क, मय मुंह को बल गिरयो, तब मय न एक शब्द सुन्यो जसो कोयी बाते करय हय। ");
INSERT INTO lbm_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","ओन मोरो सी कह्यो, “हे आदमी को सन्तान, अपनो पाय को बल खड़ो हो, अऊर मय तोरो सी बाते करूं।” ");
INSERT INTO lbm_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","जसोच ओन मोरो सी कह्यो, तबच आत्मा न मोरो म समाय क मोख पाय को बल खड़ो कर दियो; अऊर जो मोरो सी बाते करत होतो मय न ओकी सुनी। ");
INSERT INTO lbm_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","ओन मोरो सी कह्यो, “हे आदमी को सन्तान, मय तोख इस्राएलियों को जवर मतलब विद्रोह करन वाली राष्ट्र को जवर भेजू हय, जिन्न मोरो खिलाफ विद्रोह करयो हय; उन्को पूर्वज अऊर हि भी अज को दिन तक मोरो खिलाफ अपराध करतो चल्यो आयो हय। ");
INSERT INTO lbm_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","यो पीढ़ी को लोग जिन्को जवर मय तोख भेजू हय, हि निर्लज्ज अऊर जिद्दी हय; ");
INSERT INTO lbm_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","अऊर तय उन्को सी कहजो, ‘प्रभु परमेश्वर यो कह्य हय,’ येकोसी हि, जो विद्रोह करन वालो घराना को हय, चाहे हि सुने यां नहीं सुने, तब भी हि इतनो जान लेयेंन कि हमरो बीच एक भविष्यवक्ता प्रगट भयो हय। ");
INSERT INTO lbm_vpl VALUES ("EK2_6","027_2_6","EZK","2","6","6","“हे आदमियों की सन्तान, तय इन्को सी मत डरजो; चाहे तोख काटां, ऊंटकटारों अऊर बिच्छुवों को बीच भी रहनो पड़े, तब भी उन्को वचनों सी मत डरजो; यदि हि विद्रोही घराना को हय, तब भी नहीं त उन्को वचनों सी डरजो, अऊर नहीं उन्को मुंह देख क तोरो मन कच्चो होय। ");
INSERT INTO lbm_vpl VALUES ("EK2_7","027_2_7","EZK","2","7","7","येकोलायी चाहे हि सुने यां नहीं सुने; तब भी तय मोरो वचन उन्को सी कहजो, हि त बड़ो विद्रोही हंय। ");
INSERT INTO lbm_vpl VALUES ("EK2_8","027_2_8","EZK","2","8","8","“पर हे आदमी को सन्तान, जो मय तोरो सी कहू हय, ओख तय सुन ले, ऊ विद्रोही घराना को समान तय भी मत बनजो, जो मय तोख देऊ हय, ओख मुंह खोल क खाय ले।” ");
INSERT INTO lbm_vpl VALUES ("EK2_9","027_2_9","EZK","2","9","9","तब मय न नजर कर क् देख्यो, कि मोरो तरफ एक हाथ बढ़्यो हुयो हय अऊर ओको म एक किताब हय। ");
INSERT INTO lbm_vpl VALUES ("EK2_10","027_2_10","EZK","2","10","10","ओख ओन मोरो सामने खोल क फैलायो, अऊर वा दोयी तरफ लिखी हुयी होती; अऊर जो ओको म लिख्यो होतो, हि विलाप अऊर शोक अऊर दु:ख भरयो वचन होतो। ");
INSERT INTO lbm_vpl VALUES ("EK3_1","027_3_1","EZK","3","1","1","तब ओन मोरो सी कह्यो, “हे आदमी की सन्तान, जो तोख मिल्यो हय ओख खाय ले; मतलब या किताब ख खा, तब जाय क इस्राएल को घराना सी बाते कर।” ");
INSERT INTO lbm_vpl VALUES ("EK3_2","027_3_2","EZK","3","2","2","येकोलायी मय न मुंह खोल्यो अऊर ओन वा किताब मोख खिलाय दी। ");
INSERT INTO lbm_vpl VALUES ("EK3_3","027_3_3","EZK","3","3","3","तब ओन मोरो सी कह्यो, “हे आदमी की सन्तान, या किताब जो मय तोख देऊ हय ओख पचाय ले, अऊर अपनी पेट भर ले।” मय न ओख खाय लियो; अऊर मोरो मुंह म वा शहेद को जसो मीठो लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EK3_4","027_3_4","EZK","3","4","4","फिर ओन मोरो सी कह्यो, “हे आदमी की सन्तान, तय इस्राएल को घराना को जवर जाय क उन्ख मोरो वचन सुनाव। ");
INSERT INTO lbm_vpl VALUES ("EK3_5","027_3_5","EZK","3","5","5","कहालीकि तय कोयी अनोखी बोली यां कठिन भाषा वालो राष्ट्र को जवर नहीं भेज्यो जावय हय, पर इस्राएलच को घराना को जवर भेज्यो जावय हय। ");
INSERT INTO lbm_vpl VALUES ("EK3_6","027_3_6","EZK","3","6","6","अनोखी बोली यां कठिन भाषावाली बहुत सी राष्ट्रों को जवर जो तोरी बात समझ नहीं सके, तय नहीं भेज्यो जावय। बिना सक यदि मय तोख असो लोगों को जवर भेजतो त हि तोरी सुनतो। ");
INSERT INTO lbm_vpl VALUES ("EK3_7","027_3_7","EZK","3","7","7","पर इस्राएल को घराना वालो तोरी सुनन सी इन्कार करेंन; हि मोरी भी सुनन सी इन्कार करय हय; कहालीकि इस्राएल को पूरो घराना निर्लज अऊर कठोर मन को हय। ");
INSERT INTO lbm_vpl VALUES ("EK3_8","027_3_8","EZK","3","8","8","देख, मय तोरो मुख को सामने, अऊर तोरो मस्तक ख उन्को मस्तक को सामने, कठोर कर देऊ हय। ");
INSERT INTO lbm_vpl VALUES ("EK3_9","027_3_9","EZK","3","9","9","मय तोरो मस्तक ख हीरा को जसो कठोर कर देऊ हय जो चकमक गोटा सी भी कठोर होवय हय; येकोलायी तय उन्को सी मत डरजो, अऊर नहीं उन्को मुंह ख देख क तोरो मन कच्चो होय; कहालीकि हि विद्रोही घराना को हय।” ");
INSERT INTO lbm_vpl VALUES ("EK3_10","027_3_10","EZK","3","10","10","फिर ओन मोरो सी कह्यो, “हे आदमी की सन्तान, जितनो वचन मय तोरो सी कहू, हि सब अपनो दिल म रख अऊर कानों सी सुन। ");
INSERT INTO lbm_vpl VALUES ("EK3_11","027_3_11","EZK","3","11","11","अऊर उन बन्दियों को जवर जाय क, जो राष्ट्र को तोरो जाति भाऊ हय, उन्को सी बाते करजो अऊर कहजो, ‘प्रभु परमेश्वर यो कह्य हय;’ चाहे हि सुने यां नहीं सुने।” ");
INSERT INTO lbm_vpl VALUES ("EK3_12","027_3_12","EZK","3","12","12","तब आत्मा न मोख ऊपर उठायो, अऊर मय न अपनो पीछू बड़ी घड़घड़ाहट को संग एक आवाज सुन्यो : “परमेश्वर की महिमा आशीष की हय।” ");
INSERT INTO lbm_vpl VALUES ("EK3_13","027_3_13","EZK","3","13","13","अऊर ओको संगच उन जीवधारियों को पंखा को आवाज, जो एक दूसरो सी लगत होतो, अऊर ओको संग को पहिया को आवाज अऊर एक बड़ीच घड़घड़ाहट सुनायी दी। ");
INSERT INTO lbm_vpl VALUES ("EK3_14","027_3_14","EZK","3","14","14","अब आत्मा मोख उठाय क ले गयी, अऊर मय कठिन दु:ख सी भरयो हुयो, अऊर मन म जलतो हुयो चली गयो; अऊर परमेश्वर की शक्ति मोरो म प्रबल होती; ");
INSERT INTO lbm_vpl VALUES ("EK3_15","027_3_15","EZK","3","15","15","अऊर मय उन बन्दियों को जवर आयो जो कबार नदी को किनार पर तेलाबीब नगर म रहत होतो। अऊर वहां मय सात दिन तक उन्को बीच दु:खी होय क बैठ्यो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EK3_16","027_3_16","EZK","3","16","16","सात दिन बितन पर परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK3_17","027_3_17","EZK","3","17","17","“हे आदमी की सन्तान,” मय न तोख इस्राएल को घराना को लायी पहरेदार चुन लियो हय; तय मोरो मुंह की बात सुन क, उन्ख मोरो तरफ सी चितायजो। ");
INSERT INTO lbm_vpl VALUES ("EK3_18","027_3_18","EZK","3","18","18","जब मय दुष्ट सी कहू, तय जरूर मरजो, अऊर यदि तय ओख नहीं चितायजो, अऊर नहीं दुष्ट सी असी बात कहजो जेकोसी की ऊ सचेत अऊर अपनो बुरो रस्ता छोड़ क जीन्दो रहे, त दुष्ट अपनो अधर्म म फस्यो हुयो मरेंन, पर ओको खून को लेखा मय तोरोसीच लेऊं। ");
INSERT INTO lbm_vpl VALUES ("EK3_19","027_3_19","EZK","3","19","19","पर यदि तय ऊ दुष्ट आदमी ख चितायजो, अऊर ऊ अपनी दुष्टता अऊर दुष्ट मार्ग सी नहीं फिरे, त ऊ अपनो अधर्म म फस्यो हुयो मर जायेंन; पर तय अपनो आप ख बचायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK3_20","027_3_20","EZK","3","20","20","“फिर जब धर्मी जन अपनो धर्म सी फिर क कुटिल काम करन लगेंन, अऊर मय ओको सामने बाधाये पैदा करू, त ऊ मर जायेंन, कहालीकि तय न ओख नहीं चितायो होतो, येकोलायी ऊ अपनो पापों म फस्यो हुयो मरेंन; अऊर जो धर्म को काम ओन करयो होना, ओकी सुधि नहीं लियो जायेंन, पर मय ओकी मृत्यु को दोष तोरोसीच लेऊं। ");
INSERT INTO lbm_vpl VALUES ("EK3_21","027_3_21","EZK","3","21","21","पर यदि तय धर्मी आदमी ख असो कह्य क चिताजो, कि ऊ पाप नहीं करजो, त ऊ पाप सी बच जायेंन, त ऊ चितौनी ख स्विकार करन को वजह निश्चित जीन्दो रहेंन, अऊर तय अपनो आप ख बचायजो।” ");
INSERT INTO lbm_vpl VALUES ("EK3_22","027_3_22","EZK","3","22","22","फिर परमेश्वर की सामर्थ वहांच मोरो पर प्रगट भयी, अऊर ओन मोरो सी कह्यो, “उठ क मैदान म जा; अऊर वहां मय तोरो सी बाते करूं।” ");
INSERT INTO lbm_vpl VALUES ("EK3_23","027_3_23","EZK","3","23","23","तब उठ क मैदान म गयो, अऊर वहां का देख्यो, कि परमेश्वर की सामर्थ जसी मोख कबार नदी को किनार पर, वसोच यहां भी दिखायी पड़य हय, तब मय मुंह को बल जमीन पर गिर पड़्यो। ");
INSERT INTO lbm_vpl VALUES ("EK3_24","027_3_24","EZK","3","24","24","तब आत्मा मोरो म समाय क मोख पाय को बल खड़ो कर दियो; फिर ऊ मोरो सी कहन लग्यो, “अपनो घर जा, अऊर दरवाजा बन्द कर अन्दर बैठ। ");
INSERT INTO lbm_vpl VALUES ("EK3_25","027_3_25","EZK","3","25","25","हे आदमी की सन्तान, देख, हि लोग तोख रस्सियों सी बान्ध क रखेंन, अऊर तय निकल क उन्को बीच म नहीं जाय सकजो। ");
INSERT INTO lbm_vpl VALUES ("EK3_26","027_3_26","EZK","3","26","26","मय तोरी जीबली ख तालू सी चिपकाय देऊं; अऊर तय मुक्का होय जाजो, अऊर तय उन्ख डाट नहीं सकजो, कहालीकि हि झगड़ालु घराना को हय। ");
INSERT INTO lbm_vpl VALUES ("EK3_27","027_3_27","EZK","3","27","27","पर जब जब मय तोरो सी बाते करूं, तब तब मय तोरो मुंह ख खोलूं, अऊर तय उन्को सी असो कहजो, ‘प्रभु परमेश्वर यो कह्य हय,’ जो सुनय हय ऊ सुन ले अऊर जो नहीं सुनय ऊ नहीं सुने, हि त झगड़ालु घराना को आय।” ");
INSERT INTO lbm_vpl VALUES ("EK4_1","027_4_1","EZK","4","1","1","“हे आदमी की सन्तान, तय एक ईटा ले अऊर ओख अपनो सामने रख, ओको बाद तय ओको पर यरूशलेम नगर को चित्र बनाव। ");
INSERT INTO lbm_vpl VALUES ("EK4_2","027_4_2","EZK","4","2","2","तय ओख चारयी तरफ सी घेर क मोर्चाबन्दी कर। तय ओको सामने गहरी नाली बनाव, अऊर छावनी डाल, अऊर ओको चारयी तरफ युद्ध को यंत्र लगाव। ");
INSERT INTO lbm_vpl VALUES ("EK4_3","027_4_3","EZK","4","3","3","तब तय लोहा को एक तवा ले क ओख दीवाल को रूप म रख दे, यो तोरो अऊर नगर को बीच मनो लोहा की दीवाल होना। तय नगर को तरफ मुंह कर, अऊर ओख घेर ले। घेराव की स्थिति बनायो रख, यो रेखाचित्र इस्राएल को घराना को लायी चिन्ह ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("EK4_4","027_4_4","EZK","4","4","4","“फिर तय बायो तरफ करवट ले क इस्राएल को घराना को अधर्म को भार अपनो ऊपर रख, जितनो दिन तय बायो करवट पर लेट्यो रहजो, उतनो दिन तक तय उन लोगों को अधर्म को भार सहतो रहजो। ");
INSERT INTO lbm_vpl VALUES ("EK4_5","027_4_5","EZK","4","5","5","मय तोरो लायी दिनों की संख्या निश्चित कर देऊ हय, तय तीन सौ नब्बे दिन तक उन्की सजा सहजो। एक दिन एक साल को बराबर हय, इस्राएल को घराना ख तीन सौ नब्बे साल तक सजा सहनो पड़ेंन। ");
INSERT INTO lbm_vpl VALUES ("EK4_6","027_4_6","EZK","4","6","6","जब इतनो दिन पूरो होय जायेंन, तब तय दियो तरफ करवट ले क यहूदा को घराना को अधर्म को भार सह लेजो; मय न ओको लायी भी अऊर तोरो लायी एक साल को बदला एक दिन मतलब चालीस दिन ठहरायो हय। ");
INSERT INTO lbm_vpl VALUES ("EK4_7","027_4_7","EZK","4","7","7","“तय दुस्मनों सी घिरयो हुयो यरूशलेम नगर को तरफ अपनो मुंह करजो। गुस्सा प्रगट करन लायी तोरी बाहें फैलाय क रखजो। तब तय यरूशलेम को खिलाफ भविष्यवानी करजो। ");
INSERT INTO lbm_vpl VALUES ("EK4_8","027_4_8","EZK","4","8","8","देख, मय तोख रस्सियों सी जकड़ूं, अऊर जब तक ओको घेरन को दिन पूरो नहीं होयेंन, तब तक तय करवट नहीं बदल सकजो। ");
INSERT INTO lbm_vpl VALUES ("EK4_9","027_4_9","EZK","4","9","9","“तय गहूं, जौ, सेमी, मसूर, बाजरा, अऊर कठिया गहूं, ले क एक बर्तन म रख क उन्को सी रोटी बनायो करजो। जितनो दिन तय वा करवट पर लेट्यो रहजो, उतनो मतलब तीन सौ दिन तक ओख खायो करजो। ");
INSERT INTO lbm_vpl VALUES ("EK4_10","027_4_10","EZK","4","10","10","जो भोजन तय खाजो, ओख तौल क खाजो, मतलब हर दिन दोय सौ तीस ग्राम खायो करजो, अऊर ओख समय समय पर खाजो। ");
INSERT INTO lbm_vpl VALUES ("EK4_11","027_4_11","EZK","4","11","11","पानी भी तय नाप क पियो करजो, मतलब हर दिन दोय गिलास पिजो; अऊर ओख निश्चित समय पर पिजो। ");
INSERT INTO lbm_vpl VALUES ("EK4_12","027_4_12","EZK","4","12","12","अपनो भोजन जौ की रोटियों को जसो बनाय क खायो करजो, अऊर ओख आदमी को मल को कंडा पर उन्को देखतो बनायो करजो।” ");
INSERT INTO lbm_vpl VALUES ("EK4_13","027_4_13","EZK","4","13","13","फिर परमेश्वर न कह्यो, “योच तरह सी इस्राएल राष्ट्र को बीच अपनी अपनी रोटी अशुद्धता सी खायो करेंन, जहां मय उन्ख दूसरो देशों म खदेड़ देऊं।” ");
INSERT INTO lbm_vpl VALUES ("EK4_14","027_4_14","EZK","4","14","14","तब मय न कह्यो, “हाय, यहोवा परमेश्वर देख, मोरो मन कभी अशुद्ध नहीं भयो, अऊर नहीं मय न बचपन सी ले क अब तक अपनी मृत्यु सी मरयो हुयो यां फाड़्यो हुयो जनावर को मांस खायो, अऊर नहीं कोयी तरह को अशुद्ध मांस मोरो मुंह म कभी नहीं गयो हय।” ");
INSERT INTO lbm_vpl VALUES ("EK4_15","027_4_15","EZK","4","15","15","तब ओन मोरो सी कह्यो, “देख, मय न तोरो लायी आदमी को मल को कंडा को बदला गाय को गोबर को कंडा ठहरायो हय, अऊर ओको पर तय अपनी रोटी बनायजो।” ");
INSERT INTO lbm_vpl VALUES ("EK4_16","027_4_16","EZK","4","16","16","फिर ओन मोरो सी कह्यो, “हे आदमी की सन्तान, देख, मय यरूशलेम म अनाजरूपी आधार ख दूर करूं; येकोलायी वहां को लोग तौल तौल क अऊर चिन्ता करतो हुयो रोटी खायो करेंन; अऊर नाप नाप क अऊर दु:ख म होय क पानी पियो करेंन। ");
INSERT INTO lbm_vpl VALUES ("EK4_17","027_4_17","EZK","4","17","17","अऊर उन्ख रोटी अऊर पानी की कमी होयेंन; अऊर हि सब को सब घबरायेंन, अऊर अपनो अधर्म म फस्यो हुयो नाश जायेंन।” ");
INSERT INTO lbm_vpl VALUES ("EK5_1","027_5_1","EZK","5","1","1","“हे आदमी की सन्तान, एक धार वाली तलवार ले, अऊर ओख भाली को उस्तरा को जसो काम म लाय क अपनो मुंड अऊर दाढ़ी को मूंड डाल, अब तौलन को तराजू ले क बालों को हिस्सा कर। ");
INSERT INTO lbm_vpl VALUES ("EK5_2","027_5_2","EZK","5","2","2","जब नगर को घेरन को दिन पूरो होयेंन, तब नगर को अन्दर एक तिहायी हिस्सा आगी म डाल क जलायजो, अऊर एक तिहायी हिस्सा चारयी तरफ तलवार सी मारजो; अऊर एक तिहायी हिस्सा हवा म उड़ायजो, अऊर मय तलवार खीच क ओको पीछू चलाऊं। ");
INSERT INTO lbm_vpl VALUES ("EK5_3","027_5_3","EZK","5","3","3","तब इन म सी थोड़ो सो बाल ले क अपनो कपड़ा को कोना म बान्धजो। ");
INSERT INTO lbm_vpl VALUES ("EK5_4","027_5_4","EZK","5","4","4","फिर इन म सी भी थोड़ो सो बाल ले क आगी म डालजो कि हि आगी म जर जायेंन, तब वाच आगी म सी एक लौ भड़क क निकलेंन अऊर इस्राएल को पूरो घराना म फैल जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK5_5","027_5_5","EZK","5","5","5","“प्रभु परमेश्वर यो कह्य हय : यरूशलेम नगर असोच हय; मय न ओख दूसरो राष्ट्रों को बीच म ठहरायो हय, अऊर ऊ चारयी तरफ सी दूसरो देशों सी घिरयो हय। ");
INSERT INTO lbm_vpl VALUES ("EK5_6","027_5_6","EZK","5","6","6","ओन मोरो नियमों को खिलाफ काम कर क् दूसरो राष्ट्रों सी जादा दुष्टता करी, अऊर मोरी विधियों को खिलाफ चारयी तरफ को देशों को लोगों सी जादा बुरायी करी हय; कहालीकि उन्न मोरो नियम ख तुच्छ जान्यो, अऊर हि मोरी विधियों पर नहीं चल्यो। ");
INSERT INTO lbm_vpl VALUES ("EK5_7","027_5_7","EZK","5","7","7","यो तरह प्रभु परमेश्वर यो कह्य हय : तुम लोग जो अपनो चारयी तरफ को राष्ट्रों सी जादा हल्ला मचावय, अऊर नहीं मोरी विधियों पर चलय, अऊर नहीं मोरो नियमों को पालन करय अऊर अपनो चारयी तरफ को राष्ट्रों को नियमों को अनुसार भी नहीं करयो, ");
INSERT INTO lbm_vpl VALUES ("EK5_8","027_5_8","EZK","5","8","8","यो वजह प्रभु परमेश्वर यो कह्य हय : देख, मय खुद तोरो खिलाफ हय; अऊर दूसरो राष्ट्रों को देखतो मय तोरो बीच न्याय को काम करूं। ");
INSERT INTO lbm_vpl VALUES ("EK5_9","027_5_9","EZK","5","9","9","तोरो सब घिनौनो कामों को वजह मय तोरो बीच असो करूं, जसो अब तक नहीं करयो हय, अऊर नहीं भविष्य म फिर कभी करूं। ");
INSERT INTO lbm_vpl VALUES ("EK5_10","027_5_10","EZK","5","10","10","सुनो तुम्हरो बीच रहन वालो पिता अपनो बच्चां को मांस खायेंन; अऊर टुरा अपनो पिता को! मय तुम्ख याच सजा देऊं, अऊर जो लोग बच जायेंन, उन्ख मय चारयी तरफ दिशावों म बिखेर देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK5_11","027_5_11","EZK","5","11","11","“येकोलायी प्रभु परमेश्वर की या वाणी हय, कि मोरो जीवन की कसम, येकोलायी कि तय न मोरी पवित्र जागा ख अपनी पूरी घिनौनी मूर्तियों अऊर पूरो घिनौनो कामों सी अशुद्ध करयो हय, मय तोख घटाऊं, अऊर तोरो पर दया नहीं करूं, अऊर तोरो पर कुछ भी तरस नहीं खाऊं। ");
INSERT INTO lbm_vpl VALUES ("EK5_12","027_5_12","EZK","5","12","12","तोरो तीन म सी एक हिस्सा महामारी सी मरेंन, अऊर तोरो बीच म भूख सी मर जायेंन; तीन म सी एक हिस्सा नगर को बाहेर तलवार सी मारी जायेंन; अऊर तीन म सी हिस्सा ख मय चारयी तरफ तितर बितर करूं अऊर तलवार सी उन्को पीछा करूं। ");
INSERT INTO lbm_vpl VALUES ("EK5_13","027_5_13","EZK","5","13","13","“यो तरह सी मोरो क्रोध शान्त होयेंन, अऊर अपनी क्रोध की पूरी शक्ति उन पर भड़काय क मय शान्ति पाऊं; अऊर जब मय अपनी क्रोध की शक्ति उन पर पूरी रीति सी भड़काय देऊ, तब हि जान लेयेंन कि मोख परमेश्वरच न जलन म आय क यो कह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EK5_14","027_5_14","EZK","5","14","14","मय तोख तोरो चारयी तरफ को जातियों को बीच, सब आन-जान वालों को देखतो हुयो तोख उजाड़ देऊं, अऊर तोरी निन्दा करवाऊं। ");
INSERT INTO lbm_vpl VALUES ("EK5_15","027_5_15","EZK","5","15","15","“येकोलायी जब मय तोख क्रोध अऊर जलजलाहट अऊर फटकार को संग सजा देऊं, तब तोरो चारयी तरफ को राष्ट्र को सामने निन्दा, ठट्ठा, अऊर अपमानित होजो, कहालीकि मोख परमेश्वर न यो कह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EK5_16","027_5_16","EZK","5","16","16","यो ऊ समय होयेंन, जब मय उन लोगों को नाश करन लायी अकाल को घातक तीर चलाय क, तुम्हरो बीच भयंकर अकाल लाऊं, अऊर भोजनरूपी आधार ख दूर करूं। ");
INSERT INTO lbm_vpl VALUES ("EK5_17","027_5_17","EZK","5","17","17","मय तुम्हरो बीच अकाल अऊर जंगली जनावर भेजूं जो तुम्ख बिन सन्तान को कर देयेंन; अऊर महामारी अऊर खून तुम्हरो बीच चलतो रहेंन; अऊर मय तुम पर दुस्मन की तलवार चलवाऊं, मय, प्रभु न यो कह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("EK6_1","027_6_1","EZK","6","1","1","फिर परमेश्वर को यो वचन मोरो जवर पहुंच्यो : ");
INSERT INTO lbm_vpl VALUES ("EK6_2","027_6_2","EZK","6","2","2","“हे आदमी की सन्तान, अपनो मुख इस्राएल की पहाड़ी को तरफ कर क् उन्को खिलाफ भविष्यवानी कर, ");
INSERT INTO lbm_vpl VALUES ("EK6_3","027_6_3","EZK","6","3","3","अऊर कह्य, हे इस्राएल को पहाड़ो, प्रभु परमेश्वर को वचन सुनो! प्रभु परमेश्वर पहाड़ो अऊर पहाड़ियों सी, अऊर नाला अऊर चारागाह मैदान सी यो कह्य हय : देखो, मय तुम पर तलवार चलवाऊं, अऊर तुम्हरो पूजा को ऊंचो जागावों को नाश करूं। ");
INSERT INTO lbm_vpl VALUES ("EK6_4","027_6_4","EZK","6","4","4","तुम्हरी वेदियां उजड़ जायेंन अऊर तुम्हरी सूर्य की मूर्तियां तोड़ी जायेंन; अऊर मय तुम म सी मरयो हुयो लोगों ख तुम्हरी मूर्तियों को आगु फेक देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK6_5","027_6_5","EZK","6","5","5","मय इस्राएल को लोगों को शवों ख उन्की मूर्तियों को सामने रखूं, अऊर उन्की हड्डियों ख तुम्हरी वेदियों को चारयी तरफ बिखेर देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK6_6","027_6_6","EZK","6","6","6","तुम्हरो जितनो बसायो हुयो नगर हय, हि सब उजड़ जायेंन, कि तुम्हरो पूजा की जागा भी खण्डर होय जायेंन, तुम्हरी वेदियां उजड़ेंन अऊर गिरायी जायेंन, अऊर तुम्हरी मूर्तियां तोड़ी जायेंन अऊर तुम्हरी सूर्य की मूर्तियां तुकड़ा तुकड़ा होय जायेंन; अऊर तुम्हरी पूरी कारीगरी मिटायी जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK6_7","027_6_7","EZK","6","7","7","तुम्हरो बीच म शवों को ढेर लग्यो रहेंन, तब तुम जान लेवो कि मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EK6_8","027_6_8","EZK","6","8","8","“तब भी मय कितनो ख बचायो रखूं। येकोलायी जब तुम देश देश म तितर-बितर होय जावो, तब राष्ट्र को बीच तुम्हरो कुछ लोग तलवार को मार सी बच जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK6_9","027_6_9","EZK","6","9","9","हि बच्यो हुयो लोग, उन जातियों को बीच, जिन म हि बन्दी होय क रहेंन, मोख याद करेंन; अऊर यो भी कि हमरो व्यभिचारी दिल परमेश्वर सी कसो हट गयो हय, अऊर व्यभिचारिनी कि जसी हमरी आखी मूर्तियों पर कसी लगी हय, जेकोसी परमेश्वर को मन टूट्यो हय। यो रीति सी उन बुरायीयों को वजह, जो उन्न अपनो घृणित काम कर क् करयो हय, हि अपनी नजर म घृणित ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("EK6_10","027_6_10","EZK","6","10","10","तब हि जान लेयेंन कि मय परमेश्वर आय, अऊर उन्की पूरी हानि करन लायी मय न जो यो कह्यो होतो, ऊ बेकार नहीं कह्यो होतो।” ");
INSERT INTO lbm_vpl VALUES ("EK6_11","027_6_11","EZK","6","11","11","प्रभु परमेश्वर यो कह्य हय : “अपनो हाथ पर हाथ मार क अऊर पाय पटक क कहो, इस्राएल को घराना को पूरो घिनौनो कामों पर हाय, हाय, कहालीकि हि तलवार सी, भूखमरी, अऊर महामारी सी मर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK6_12","027_6_12","EZK","6","12","12","जो दूर हय हि बीमारी सी मरेंन, अऊर जो जवर हय हि तलवार सी मरेंन, अऊर जो नगर म रहतो हुयो बच जायेंन, हि भूख सी मरेंन। यो तरह मय अपनी क्रोध की शक्ति ख भड़काऊं। ");
INSERT INTO lbm_vpl VALUES ("EK6_13","027_6_13","EZK","6","13","13","जब हर एक ऊची पहाड़ी अऊर पहाड़ों की हर एक सेंडी पर, अऊर हर एक हरो झाड़ को खल्लो, अऊर हर एक घनो बांझ नाम को झाड़ की छाया म, जहां जहां हि अपनी सब मूर्तियों ख सुखदायक सुगन्ध अत्तर चढ़ावय हय, वहां उन्को मरयो हुयो लोगों को शव अपनी वेदियों को आजु-बाजू अपनी मूर्तियों को बीच म पड़्यो रहेंन; तब तुम लोग जान लेवो कि मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EK6_14","027_6_14","EZK","6","14","14","मय अपनो हाथ उन्को खिलाफ बढ़ाय क ऊ देश ख पूरो घरो समेत जंगल सी ले क रिबला नगर तक उजाड़ कर देऊं। तब हि जान लेयेंन कि मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EK7_1","027_7_1","EZK","7","1","1","फिर परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK7_2","027_7_2","EZK","7","2","2","“हे आदमी की सन्तान,” प्रभु परमेश्वर इस्राएल की जमीन को बारे म यो कह्य हय : कि विनाश आयो; चारयी कोना समेत देश को विनाश आय गयो। ");
INSERT INTO lbm_vpl VALUES ("EK7_3","027_7_3","EZK","7","3","3","हे इस्राएल तोरो विनाश को समय भी आय गयो, अऊर मय अपनो कोप तोरो पर भड़काय क तोरो चालचलन को अनुसार तोख सजा देऊं; अऊर तोरो पूरो घिनौनो कामों को फर तोख देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK7_4","027_7_4","EZK","7","4","4","मोरी दया की नजर तोरो पर नहीं रहेंन, अऊर नहीं मय तरस नहीं खाऊं, अऊर जब तक तोरो म घृणित पाप बन्यो रहेंन, मय तोरो आचरन को अनुसार तोख सजा देऊं। तब तय जान लेजो कि मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EK7_5","027_7_5","EZK","7","5","5","प्रभु परमेश्वर यो कह्य हय : विपत्ति को बाद विपत्ति! देख, तोरो पर विपत्ति आय रह्यी हय। ");
INSERT INTO lbm_vpl VALUES ("EK7_6","027_7_6","EZK","7","6","6","अन्त आय गयो हय, सब को अन्त आय गयो हय; ऊ तोरो सर्वनाश करन लायी जागृत भयो हय। देखो, ऊ आय रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EK7_7","027_7_7","EZK","7","7","7","हे इस्राएल देश को निवासियों, तुम्हरो लायी विनाश को समय आय गयो हय, विनाश को चक्र घूम चुक्यो हय, पहाड़ियों पर खुशी उल्लास को शब्द नहीं, पर भगदड़ को दिन होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_8","027_7_8","EZK","7","8","8","“अब थोड़ो दिनों म मय अपनी जलजलाहट तोरो पर भड़काऊं, अऊर तोरो पर पूरो कोप डाल देऊं अऊर तोरो चालचलन को अनुसार तोख सजा देऊं। अऊर तोरो पूरो घृणित कामों लायी तोख सजा देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK7_9","027_7_9","EZK","7","9","9","मोरी दया की नजर तोरो पर नहीं होयेंन अऊर नहीं मय तोरो पर तरस दिखाऊं। मय तोरी चालचलन को फर तोरो सी भुगताऊं, अऊर तोरो घिनौनो पाप तोरो म बन्यो रहेंन। तब तुम जान लेवो कि मय परमेश्वर सजा देन वालो आय।” ");
INSERT INTO lbm_vpl VALUES ("EK7_10","027_7_10","EZK","7","10","10","देखो, ऊ दिन ख देखो, ऊ आय रह्यो हय! विनाश को चक्र घुम चुक्यो हय, अन्याय की छड़ी फूल गयी हय, तोरो घमण्ड बढ़ गयो हय। ");
INSERT INTO lbm_vpl VALUES ("EK7_11","027_7_11","EZK","7","11","11","उपद्रव बढ़तो बढ़तो दुष्कर्म कि सजा बन गयो; उन म सी कोयी नहीं बचेंन, अऊर नहीं उन्की भीड़-भाड़, अऊर नहीं उन्को धन म सी कुछ बचेंन; अऊर नहीं उन म सी कोयी को लायी आंसू बहावन वालो भी नहीं रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_12","027_7_12","EZK","7","12","12","समय आय गयो, दिन जवर आय गयो हय; नहीं त खरीदन वालो खुशी मनायेंन अऊर नहीं बेचन वालो शोक करेंन, कहालीकि उन्की पूरी भीड़ पर कोप भड़क उठ्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EK7_13","027_7_13","EZK","7","13","13","चाहे ऊ जीन्दो रहे, तब भी बेचन वालो बेची हुयी चिज को जवर कभी नहीं जाय सकेंन; कहालीकि क्रोध कि या बात देश की पूरी भीड़ पर घटेंन, कोयी नहीं लौटेंन; कोयी भी आदमी जो अधर्म म जीन्दो रह्य हय, ऊ खुद ख सम्भाल नहीं पायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_14","027_7_14","EZK","7","14","14","उन्न नरसिंगा फूक्यो अऊर सब कुछ तैयार कर दियो; पर युद्ध म कोयी नहीं जात होतो कहालीकि देश की पूरी भीड़ पर मोरो कोप भड़क्यो हुयो हय। ");
INSERT INTO lbm_vpl VALUES ("EK7_15","027_7_15","EZK","7","15","15","नगर को बाहेर दुश्मन की तलवार अऊर नगर को अन्दर अकाल अऊर महामारी हय; अऊर जो नगर को मैदान म होना हि तलवार सी मरेंन, अऊर जो नगर को अन्दर हय हि भूख अऊर महामारी सी मारयो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_16","027_7_16","EZK","7","16","16","उन म सी जो बच निकलेंन हि बचेंन त सही पर अपनो अपनो अधर्म म फस्यो रह्य क घाटियों म रहन वालो कबूतरों को जसो पहाड़ियों को ऊपर शोक करतो रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_17","027_7_17","EZK","7","17","17","सब को हाथ ढीलो अऊर सब को घुटना बहुत कमजोर होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_18","027_7_18","EZK","7","18","18","हि कमर म टाट को कपड़ा पहिन लेयेंन, अऊर हि भयभित होय जायेंन, सब को मुंह लज्जा सी ढक जायेंन अऊर सब को मुंड को बाल काट्यो जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_19","027_7_19","EZK","7","19","19","हि अपनी चांदी सड़कों पर फेक देयेंन, अऊर उन्को सोनो अशुद्ध चिज ठहरेंन; परमेश्वर को कोप को दिन उन्को सोनो चांदी उन्ख बचाय नहीं सकेंन, नहीं ओको सी उन्को जीव सन्तुष्ट होयेंन, नहीं उन्को पेट भरेंन। कहालीकि ऊ उन्को अधर्म को ठोकर को वजह भयो हय। ");
INSERT INTO lbm_vpl VALUES ("EK7_20","027_7_20","EZK","7","20","20","उन्को देश जो सुन्दर जेवरों पर घमण्ड करत होतो अऊर सुसज्जित होतो, ओको बारे म उन्न गर्वच गर्व कर क् ओको म अपनी घृणित चिजों की मूर्तियां, अऊर घृणित चिजे बनाय रखी हय, यो वजह मय न ओख उन्को लायी अशुद्ध चिज ठहरायी हय। ");
INSERT INTO lbm_vpl VALUES ("EK7_21","027_7_21","EZK","7","21","21","मय ओख लूटन लायी परदेशियों को हाथ म, अऊर धन छीनन लायी धरती को बुरो लोगों को वश म कर देऊं, अऊर हि ओख अपवित्र कर डालेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_22","027_7_22","EZK","7","22","22","मय उन सी अपनो मुंह फिराय लेऊं, तब हि मोरो मन्दिर रूपी जागा ख अपवित्र कर डालेंन; डाकू ओको म घुस क ओख अपवित्र कर डालेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_23","027_7_23","EZK","7","23","23","“एक संकली बनाय दे, कहालीकि देश अन्याय को खून सी, अऊर नगर उपद्रव सी भरयो हुयो हय। ");
INSERT INTO lbm_vpl VALUES ("EK7_24","027_7_24","EZK","7","24","24","मय अलग अलग राष्ट्र को बुरो लोगों ख लाऊं, जो उन्को घरों पर अधिकार कर लेयेंन; अऊर मय ताकतवर लोगों को घमण्ड तोड़ डालूं अऊर उन्को पवित्र जागा अपवित्र कर डालेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_25","027_7_25","EZK","7","25","25","दु:ख पीड़ा आवन पर, शान्ति ख ढूंढेंन, पर ढूंढन पर भी उन्ख शान्ति नहीं मिलेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_26","027_7_26","EZK","7","26","26","उन पर एक को बाद एक विपत्ति आयेंन अऊर अफवाहें चारयी तरफ फैलेंन; अऊर लोग भविष्यवक्ता सी दर्शन की बात पूछेंन, पर याजक को जवर व्यवस्था, अऊर बुजूर्ग लोगों को जवर सम्मति देन की शक्ति नहीं रहेंन। ");
INSERT INTO lbm_vpl VALUES ("EK7_27","027_7_27","EZK","7","27","27","राजा त शोक करेंन, अऊर प्रधान आशा छोड़ देयेंन, अऊर देश को लोग कांप उठेंन। मय उन्को चालचलन को अनुसार उन सी व्यवहार करूं, अऊर जसो तय न दूसरों को संग न्याय करयो हय वसोच मय भी तोरो न्याय करूं। तब हि जान लेयेंन कि मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EK8_1","027_8_1","EZK","8","1","1","फिर छटवों साल को छटवों महिना को पाचवों दिन जब मय अपनो घर म बैठ्यो होतो, अऊर यहूदियों को मुखिया मोरो सामने बैठ्यो होतो, उच समय प्रभु परमेश्वर की सामर्थ मोरो पर प्रगट भयी। ");
INSERT INTO lbm_vpl VALUES ("EK8_2","027_8_2","EZK","8","2","2","तब मय न देख्यो कि आगी जसो एक रूप दिखायी देवय हय; ओकी कमर को खल्लो को तरफ आगी हय, अऊर ओकी कमर को ऊपर को तरफ चमकायो हुयो पीतल की चमक को जसो कुछ हय। ");
INSERT INTO lbm_vpl VALUES ("EK8_3","027_8_3","EZK","8","3","3","ओन अपनो हाथ बढ़ायो अऊर मोरो बाल पकड़ लियो। फिर यो दर्शन म परमेश्वर की आत्मा न मोख हवा म ऊपर उठायो अऊर यरूशलेम ले गयो। ऊ मोख मन्दिर को अन्दर आंगन को जवर फाटक को जवर जेको मुंह उत्तर दिशा को तरफ हय पहुंचाय दियो; जहां एक मूर्ती होती जो परमेश्वर को लायी अपमानजनक होती। ");
INSERT INTO lbm_vpl VALUES ("EK8_4","027_8_4","EZK","8","4","4","फिर वहां इस्राएल को परमेश्वर को तेज वसोच होतो जसो मय न कबार नदी को किनार पर देख्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK8_5","027_8_5","EZK","8","5","5","ओन मोरो सी कह्यो, “हे आदमी की सन्तान, अपनी आखी उत्तर दिशा को तरफ उठाय क देख।” मय न अपनी आखी उत्तर को तरफ उठाय क देख्यो की वेदी को फाटक को उत्तर दिशा को तरफ ओको फाटक को जवर मय न वा जलन उपजावन वाली मूर्ती देखी जेकोसी परमेश्वर को अपमान हय। ");
INSERT INTO lbm_vpl VALUES ("EK8_6","027_8_6","EZK","8","6","6","तब परमेश्वर न मोरो सी कह्यो, “हे आदमी की सन्तान, का तय देखय हय कि हि लोग का कर रह्यो हय? इस्राएल को घराना यहां कितनो घृणित काम कर रह्यो हय, ताकि मय अपनो पवित्र जागा सी दूर होय जाऊ; पर तय इन सी भी जादा घृणित काम देखजो।” ");
INSERT INTO lbm_vpl VALUES ("EK8_7","027_8_7","EZK","8","7","7","तब ऊ मोख आंगन की फाटक पर ले गयो, अऊर मय न देख्यो, कि दीवाल म एक छेद हय। ");
INSERT INTO lbm_vpl VALUES ("EK8_8","027_8_8","EZK","8","8","8","तब ओन मोरो सी कह्यो, “हे आदमी कि सन्तान, दीवाल ख फोड़।” येकोलायी मय न दीवाल ख फोड़ क का देख्यो कि एक दरवाजा हय। ");
INSERT INTO lbm_vpl VALUES ("EK8_9","027_8_9","EZK","8","9","9","ओन मोरो सी कह्यो, “अन्दर जाय क देख कि हि लोग यहां कसो कसो अऊर घृणित काम कर रह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("EK8_10","027_8_10","EZK","8","10","10","मय न अन्दर जाय क देख्यो कि चारयी तरफ की दीवाल पर अलग अलग तरह को रेंगन वालो जन्तुवों अऊर घृणित पशुवों अऊर इस्राएल को द्वारा पूज्यो जान वालो देवी-देवतावों को चित्र बनायो हुयो हय। ");
INSERT INTO lbm_vpl VALUES ("EK8_11","027_8_11","EZK","8","11","11","इस्राएल को घराना को मुखियावों म सी सत्तर आदमी जिन को बीच म शापान को टुरा याजन्याह भी हय, हि उन चित्र को सामने खड़ो हय, अऊर हर एक आदमी अपनो हाथ म धूपदान लियो हुयो हय, अऊर धूप को धूंगा ऊपर उठ रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EK8_12","027_8_12","EZK","8","12","12","तब ओन मोरो सी कह्यो, “हे आदमी कि सन्तान, का तय न देख्यो हय कि इस्राएल को घराना को मुखिया अपनी अपनी नक्काशी वालो कमरा को अन्दर मतलब अन्धारो म का कर रह्यो हय? हि कह्य हय कि परमेश्वर हम्ख नहीं देखय; परमेश्वर न देश ख त्याग दियो हय।” ");
INSERT INTO lbm_vpl VALUES ("EK8_13","027_8_13","EZK","8","13","13","फिर ओन मोरो सी कह्यो, “तय इन सी अऊर भी जादा घृणित काम देखजो जो हि करय हय।” ");
INSERT INTO lbm_vpl VALUES ("EK8_14","027_8_14","EZK","8","14","14","तब ऊ मोख परमेश्वर को भवन को ऊ फाटक को जवर ले गयो जो उत्तर दिशा को तरफ होतो अऊर वहां बाईयां बैठी हुयी तम्मूज देवता को लायी रोय रह्यी हय। ");
INSERT INTO lbm_vpl VALUES ("EK8_15","027_8_15","EZK","8","15","15","तब ओन मोरो सी कह्यो, “हे आदमी कि सन्तान, का तय न यो देख्यो हय? फिर इन सी भी बड़ो घृणित काम तय देखजो।” ");
INSERT INTO lbm_vpl VALUES ("EK8_16","027_8_16","EZK","8","16","16","तब ऊ मोख परमेश्वर को भवन को अन्दर आंगन म ले गयो; अऊर वहां परमेश्वर को भवन को फाटक को जवर मन्डप अऊर वेदी को बीच पच्चीस आदमी अपनी पीठ परमेश्वर को भवन को तरफ अऊर अपनो मूख पूर्व दिशा को तरफ करयो हुयो होतो; अऊर हि पूर्व दिशा को तरफ सूर्य ख प्रणाम कर रह्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK8_17","027_8_17","EZK","8","17","17","तब ओन मोरो सी कह्यो, “हे आदमी कि सन्तान, का तय न यो देख्यो? का यहूदा को घराना को लायी घृणित कामों को करनो जो हि यहां करय हय छोटी बात हय? उन्न अपनो देश ख उपद्रव सी भर दियो, अऊर फिर यहां आय क मोख गुस्सा दिलावय हय। हि मानो मुंह बनाय क मोरी निन्दा करय हय। ");
INSERT INTO lbm_vpl VALUES ("EK8_18","027_8_18","EZK","8","18","18","येकोलायी मय भी जलजलाहट को संग काम करूं, नहीं मय दया करूं अऊर नहीं मय तरस को व्यवहार करूं, अऊर चाहे हि मोरो कानों म ऊंचो आवाज सी पुकारे, तब भी मय उन्की बात नहीं सुनूं।” ");
INSERT INTO lbm_vpl VALUES ("EK9_1","027_9_1","EZK","9","1","1","फिर मय न परमेश्वर ख ऊंचो आवाज म चिल्लातो हुयो सुन्यो, “हे नगर ख सजा देन वालो आदमियों इत आवों। अपनो हथियार अपनो संग लावो।” ");
INSERT INTO lbm_vpl VALUES ("EK9_2","027_9_2","EZK","9","2","2","येको पर छय आदमी उत्तर दिशा को तरफ ऊपर को फाटक को रस्ता सी अपनो अपनो हाथ म हथियार लियो हुयो आयो; अऊर उन्को बीच मलमल को कपड़ा पहिन्यो, कमर म लिखन की दऊत बान्ध्यो हुयो एक अऊर आदमी होतो; अऊर हि सब भवन को अन्दर जाय क पीतल की वेदी को जवर खड़ो भयो। ");
INSERT INTO lbm_vpl VALUES ("EK9_3","027_9_3","EZK","9","3","3","तब इस्राएल को परमेश्वर की सामर्थ पंख धारी प्रानी पर सी, जिन को ऊपर ऊ रह्यो करत होतो, भवन को मन्डप को ऊपर उठ आयो होतो; अऊर ओन ऊ सन को कपड़ा पहिन्यो हुयो आदमी ख जो कमर म दऊत बान्ध्यो हुयो होतो, पुकारयो। ");
INSERT INTO lbm_vpl VALUES ("EK9_4","027_9_4","EZK","9","4","4","अऊर परमेश्वर न ओको सी कह्यो, “यो यरूशलेम नगर को अन्दर जावो, अऊर उन सब आदमियों को मस्तक पर चिन्ह लगावो, जो नगर म करयो जाय रह्यो घृणित कामों लायी दु:ख मनातो अऊर शोक करय हय।” ");
INSERT INTO lbm_vpl VALUES ("EK9_5","027_9_5","EZK","9","5","5","मय न परमेश्वर ख दूसरों सी बाते करतो सुन्यो, “तुम इन्को पीछु पीछु नगर म जावो; अऊर घृणित काम करन वालों ख मार डालो। तुम उन पर दया मत करो अऊर नहीं नम्रता सी काम करजो। ");
INSERT INTO lbm_vpl VALUES ("EK9_6","027_9_6","EZK","9","6","6","बूढ्ढा, जवान, कुंवारी, बाल-बच्चा, बाईयां, सब ख मार डालो, पर जो कोयी आदमी को मस्तक पर ऊ चिन्ह होना, ओको जवर मत जाजो। मोरो पवित्र जागा सीच शुरू करो।” उन्न उन मुखियावों सी शुरू करयो जो परमेश्वर को भवन को सामने होतो। ");
INSERT INTO lbm_vpl VALUES ("EK9_7","027_9_7","EZK","9","7","7","फिर परमेश्वर न उन्को सी कह्यो, “मोरो भवन ख शवों सी अशुद्ध कर देवो, आंगनों ख शवों सी भर देवो। जावो, मन्दिर को बाहेर जावो।” अऊर हि यरूशलेम नगर म घृणित काम करन वालों ख मारन लग्यो। ");
INSERT INTO lbm_vpl VALUES ("EK9_8","027_9_8","EZK","9","8","8","जब हि मार रह्यो होतो, अऊर मय अकेलो रह्य गयो, तब मय मुंह को बल गिरयो अऊर पुकार क कह्यो, “हे प्रभु परमेश्वर! का तय अपनी जलजलाहट यरूशलेम नगर पर भड़काय क इस्राएल को सब बच्यो हुयो ख भी नाश करजो?” ");
INSERT INTO lbm_vpl VALUES ("EK9_9","027_9_9","EZK","9","9","9","तब ओन मोरो सी कह्यो, “इस्राएल अऊर यहूदा को घराना को अधर्म बहुत जादा हय, यहां तक कि देश हत्या सी अऊर नगर अन्याय सी भर गयो हय; कहालीकि हि कह्य हय, ‘परमेश्वर न धरती ख त्याग दियो अऊर परमेश्वर कुछ नहीं देखय।’ ");
INSERT INTO lbm_vpl VALUES ("EK9_10","027_9_10","EZK","9","10","10","येकोलायी उन पर दया नहीं होयेंन, नहीं मय तरस करूं, बल्की उन्की चाल उन्कोच मुंड पर डाल देऊं।” ");
INSERT INTO lbm_vpl VALUES ("EK9_11","027_9_11","EZK","9","11","11","तब मय न का देख्यो, कि जो आदमी सन को कपड़ा पहिन्यो हुयो अऊर कमर म शाही की दऊत बान्ध्यो होतो, ओन यो कह्य क समाचार दियो, “जसो तय न आज्ञा दियो, मय न वसोच करयो हय।” ");
INSERT INTO lbm_vpl VALUES ("EK10_1","027_10_1","EZK","10","1","1","येको बाद मय न देख्यो कि करूबों को मुंड को ऊपर जो आकाश मण्डल हय, अऊर यो आकाश मण्डल म सिंहासन जसो कुछ हय, जो नीलमनि को जसो चमक रह्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EK10_2","027_10_2","EZK","10","2","2","तब परमेश्वर न ऊ सन को कपड़ा पहिन्यो हुयो आदमी सी कह्यो, “घूमन वालो चक्का को बीच करूबों को खल्लो जा अऊर अपनी दोयी मुट्ठियों म पंख धारी प्रानी को बीच म सी आगी उठाव अऊर यरूशलेम नगर पर बगराय दे।” ऊ मोरो देखतो हुयो उन्को बीच म गयो। ");
INSERT INTO lbm_vpl VALUES ("EK10_3","027_10_3","EZK","10","3","3","जब ऊ आदमी अन्दर गयो, तब हि करूब, भवन को दक्षिन दिशा को तरफ खड़ो होतो; अऊर बादर अन्दर को आंगन म समाय गयो। ");
INSERT INTO lbm_vpl VALUES ("EK10_4","027_10_4","EZK","10","4","4","तब परमेश्वर को तेज करूबों को ऊपर सी उठ क भवन की डेहरी पर आय गयो; अऊर बादर भवन म भर गयो; अऊर ऊ डेहरी परमेश्वर को तेज को महिमा सी भर गयो। ");
INSERT INTO lbm_vpl VALUES ("EK10_5","027_10_5","EZK","10","5","5","करूबों को पंखा को आवाज बाहेर को आंगन तक सुनायी देत होतो, ऊ सर्वशक्तिमान परमेश्वर को बोलन को जसो शब्द होतो। ");
INSERT INTO lbm_vpl VALUES ("EK10_6","027_10_6","EZK","10","6","6","जब ओन सन को कपड़ा पहिन्यो हुयो आदमी ख घूमन वालो चक्का को अन्दर करूबों को बीच म सी आगी लेन की आज्ञा दी, तब ऊ उन्को बीच म जाय क एक चक्का को जवर खड़ो भयो। ");
INSERT INTO lbm_vpl VALUES ("EK10_7","027_10_7","EZK","10","7","7","तब करूबों को बीच म सी एक करूब न अपनो हाथ बढ़ा क, वा आगी म सी जो करूबों को बीच म होती, कुछ उठाय क सन को कपड़ा पहिन्यो हुयो आदमी की मुट्ठी म दे दियो; अऊर ऊ ओख ले क बाहेर चली गयो। ");
INSERT INTO lbm_vpl VALUES ("EK10_8","027_10_8","EZK","10","8","8","करूबों को पंखा को खल्लो त आदमी को हाथ को जसो कुछ दिखायी देत होतो। ");
INSERT INTO lbm_vpl VALUES ("EK10_9","027_10_9","EZK","10","9","9","तब मय न देख्यो, कि करूबों को जवर चार चक्का हय; मतलब एक एक करूब को जवर एक एक चक्का हय, अऊर चक्का को रूप किमती चमकीलो गोटा को जसो हय। ");
INSERT INTO lbm_vpl VALUES ("EK10_10","027_10_10","EZK","10","10","10","उन्को असो रूप हय, कि चारयी एक जसो दिखायी दे रह्यो हंय, जसो एक चक्का को बीच दूसरो चक्का हय। ");
INSERT INTO lbm_vpl VALUES ("EK10_11","027_10_11","EZK","10","11","11","जब हि चलत होतो तब चारयी दिशावों म हि बिना मुड़्यो चलत होतो; पर सामने को चक्का जो दिशा म चलत होतो, बाकी चक्का ओको पीछु पीछु चलत होतो, अऊर चलतो समय हि मुड़त नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EK10_12","027_10_12","EZK","10","12","12","मय न देख्यो की करूबों को पूरो शरीर पीठ, हाथ अऊर पंखा म अऊर जो चक्का उन्को हय, उन म भी सब को सब चारयी तरफ आंखीच आंखी हय, ");
INSERT INTO lbm_vpl VALUES ("EK10_13","027_10_13","EZK","10","13","13","मोरो सुनतो हुयो इन चक्का ख चक्कर कह्यो गयो, मतलब घुमन वालो चक्का। ");
INSERT INTO lbm_vpl VALUES ("EK10_14","027_10_14","EZK","10","14","14","एक एक को चार चार मुंह होतो : एक मुंह त करूब को जसो, दूसरो मुंह आदमी को जसो, तीसरो मुंह सिंह को जसो, अऊर चौथो मुंह उकाब पक्षी को जसो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK10_15","027_10_15","EZK","10","15","15","करूब जमीन पर सी ऊपर उठ गयो। हि योच जीवधारी हय जो मय न कबार नदी को जवर देख्यो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK10_16","027_10_16","EZK","10","16","16","जब करूब चलत होतो तब तब हि चक्का उन्को जवर जवर चलत होतो; अऊर जब जब करूब धरती पर सी ऊपर उड़न लायी पंख फैलावत होतो तब तब चक्का उन्को जवर सी मुड़त नहीं होतो। ");
INSERT INTO lbm_vpl VALUES ("EK10_17","027_10_17","EZK","10","17","17","जब हि खड़ो होत होतो; तब चक्का भी खड़ो होय जात होतो; अऊर जब हि ऊपर उठय हय तब हि भी उन्को संग उठत होतो; कहालीकि इन जीवधारियों की आत्मा उन्म भी होती। ");
INSERT INTO lbm_vpl VALUES ("EK10_18","027_10_18","EZK","10","18","18","परमेश्वर की सामर्थ भवन को दरवाजा सी बाहेर निकल्यो अऊर करूबों को ऊपर ठहर गयो। ");
INSERT INTO lbm_vpl VALUES ("EK10_19","027_10_19","EZK","10","19","19","तब करूब अपनो पंख फैलाय क मोरो देखतो देखतो धरती पर सी उठ क निकल गयो; अऊर चक्का भी उन्को संग संग गयो, अऊर हि सब परमेश्वर को भवन को पूर्व दिशा को फाटक म खड़ो भय गयो; अऊर इस्राएल को परमेश्वर को तेज उन्को ऊपर रुक्यो रह्यो। ");
INSERT INTO lbm_vpl VALUES ("EK10_20","027_10_20","EZK","10","20","20","हि योच जीवधारी आय जो मय न कबार नदी को जवर इस्राएल को परमेश्वर को आसन को खल्लो देख्यो होतो, अऊर मय न जान लियो कि हि करूब आय। ");
INSERT INTO lbm_vpl VALUES ("EK10_21","027_10_21","EZK","10","21","21","हर एक को चार मुंह अऊर चार पंखा को खल्लो आदमी को जसो हाथ भी होतो। ");
INSERT INTO lbm_vpl VALUES ("EK10_22","027_10_22","EZK","10","22","22","उन्को मुंह को रूप उच हय जो मय न कबार नदी को किनार पर देख्यो होतो। उन्को मुंहच नहीं बल्की शरीर भी वसोच होतो। हि सीधो सामने को तरफ चलत होतो। ");
INSERT INTO lbm_vpl VALUES ("EK11_1","027_11_1","EZK","11","1","1","तब आत्मा न मोख उठाय क परमेश्वर को भवन की पूर्व दिशा की फाटक को जवर जेको मुंह पूर्व दिशा को तरफ हय, पहुंचाय दियो; अऊर वहां मय न का देख्यो, कि फाटक मच पच्चीस आदमी हय। मय न उन्को बीच अज्जूर को टुरा याजन्याह ख अऊर बनायाह को टुरा पलत्याह ख देख्यो, जो प्रजा को मुखिया होतो। ");
INSERT INTO lbm_vpl VALUES ("EK11_2","027_11_2","EZK","11","2","2","तब ओन मोरो सी कह्यो, “हे आदमी की सन्तान, जो आदमी यो नगर म बेकार उपाय अऊर बुरी युक्ति सोचय हय हि हिच आय। ");
INSERT INTO lbm_vpl VALUES ("EK11_3","027_11_3","EZK","11","3","3","हि कह्य हय, ‘घर बनावन को समय नहीं आयो हय, यो नगर मानो हन्डा हय अऊर हम ओको म को मांस आय।’ ");
INSERT INTO lbm_vpl VALUES ("EK11_4","027_11_4","EZK","11","4","4","येकोलायी हे आदमी की सन्तान, इन्को खिलाफ भविष्यवानी कर, भविष्यवानी।” ");
INSERT INTO lbm_vpl VALUES ("EK11_5","027_11_5","EZK","11","5","5","तब परमेश्वर को आत्मा मोरो पर उतरयो, अऊर मोरो सी कह्यो, असो कह्य, परमेश्वर यो कह्य हय : “हे इस्राएल को घराना, तुम न असोच कह्यो हय; जो कुछ तुम्हरो मन म आवय हय, ओख मय जानु हय। ");
INSERT INTO lbm_vpl VALUES ("EK11_6","027_11_6","EZK","11","6","6","तुम न त यो नगर म बहुत लोगों ख मार डाल्यो बल्की ओकी सड़कों ख लाशों सी भर दियो हय। ");
INSERT INTO lbm_vpl VALUES ("EK11_7","027_11_7","EZK","11","7","7","“यो वजह प्रभु परमेश्वर यो कह्य हय : जिन लोगों ख तुम न यो नगर म मार डाल्यो हय, नगररूपी हान्डी म को मांस आय; अऊर तुम येको बीच सी निकाल दियो जावो। ");
INSERT INTO lbm_vpl VALUES ("EK11_8","027_11_8","EZK","11","8","8","तुम तलवार सी डरय हय, अऊर मय तुम पर तलवार चलाऊं, प्रभु परमेश्वर की या वाणी हय। ");
INSERT INTO lbm_vpl VALUES ("EK11_9","027_11_9","EZK","11","9","9","मय तुम ख नगर म सी बाहेर निकाल क परदेशियों को हाथ म सौंप देऊं, अऊर तुम्ख सजा देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK11_10","027_11_10","EZK","11","10","10","तुम तलवार सी मर क गिरो, अऊर मय तुम्ख इस्राएल को देश की सीमा पर सजा देऊं; तब तुम जान लेवो कि मयच प्रभु आय। ");
INSERT INTO lbm_vpl VALUES ("EK11_11","027_11_11","EZK","11","11","11","यो नगर तुम्हरो लायी हान्डी अऊर खुद ख ओको अन्दर को मांस मानय हय; पर नहीं, मय तुम्ख सुरक्षित रहन नहीं देऊं। मय तुम्ख इस्राएल देश की सीमा पर सजा देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK11_12","027_11_12","EZK","11","12","12","तब तुम जान लेवो कि मय परमेश्वर आय; तुम त मोरी विधियों पर नहीं चलय, अऊर मोरो नियमों ख तुम न नहीं मान्यो; पर अपनो चारयी तरफ की राज्यों की रीतियों पर चलतो रह्यो।” ");
INSERT INTO lbm_vpl VALUES ("EK11_13","027_11_13","EZK","11","13","13","मय यो तरह की भविष्यवानी कर रह्यो होतो कि बनायाह को टुरा पलत्याह मर गयो। तब मय मुंह को बल गिर क ऊंचो आवाज सी चिल्लाय उठ्यो, अऊर कह्यो, “हाय प्रभु परमेश्वर, का तय इस्राएल को बच्यो हुयो लोगों को सत्यानाश कर डालजो?” ");
INSERT INTO lbm_vpl VALUES ("EK11_14","027_11_14","EZK","11","14","14","तब परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK11_15","027_11_15","EZK","11","15","15","“हे आदमी की सन्तान, यरूशलेम को निवासियों न तोरो जवर भाऊवों सी बल्की इस्राएल को पूरो घराना सी भी कह्यो हय कि ‘तुम परमेश्वर को जवर सी दूर होय जावो, यो देश हमरोच अधिकार म दियो गयो हय।’ ");
INSERT INTO lbm_vpl VALUES ("EK11_16","027_11_16","EZK","11","16","16","“पर तय उन्को सी कह्य, ‘प्रभु परमेश्वर यो कह्य हय : मय न तुम्ख तुम्हरो देश सी निकाल क दूसरी जातियों म बसायो अऊर दूसरो देशों म तितर-बितर कर दियो हय, तब भी जिन देशों म तुम आयो हुयो हय, उन म मय खुद तुम्हरो लायी थोड़ो दिन तक पवित्र जागा ठहराऊं।’ ");
INSERT INTO lbm_vpl VALUES ("EK11_17","027_11_17","EZK","11","17","17","“येकोलायी, उन्को सी कह्य, ‘प्रभु परमेश्वर यो कह्य हय : मय तुम्ख राज्य राज्य को लोगों को बीच सी जमा करूं, अऊर जिन देशों म तुम तितर-बितर करयो गयो हय, उन्म सी तुम्ख जमा करूं, अऊर तुम्ख इस्राएल की जमीन देऊं।’ ");
INSERT INTO lbm_vpl VALUES ("EK11_18","027_11_18","EZK","11","18","18","हि वहां पहुंच क ऊ देश की सब घृणित मूर्तियों ख हटाय देयेंन अऊर अपनो सब घृणित कामों ख घोड़ देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EK11_19","027_11_19","EZK","11","19","19","मय उन्को दिल एक कर देऊं, अऊर उन्को अन्दर नयी आत्मा पैदा करूं, अऊर उन्को शरीर म सी गोटा जसो दिल निकाल क उन्ख मांस को दिल देऊं, ");
INSERT INTO lbm_vpl VALUES ("EK11_20","027_11_20","EZK","11","20","20","जेकोसी हि मोरी विधियों पर हमेशा चल्यो करेंन अऊर मोरो नियमों ख मानेंन; अऊर हि मोरी प्रजा ठहरेंन, अऊर मय उन्को परमेश्वर ठहरूं। ");
INSERT INTO lbm_vpl VALUES ("EK11_21","027_11_21","EZK","11","21","21","पर हि लोग जो अपनी घृणित मूर्तियों अऊर घृणित कामों म मन लगाय क चलतो रह्य हय, उन्ख मय असो करूं कि उन्की चाल उन्कोच मुंड पर पड़ेंन, प्रभु परमेश्वर की याच वाणी आय।” ");
INSERT INTO lbm_vpl VALUES ("EK11_22","027_11_22","EZK","11","22","22","येको पर करूबों न अपनो पंख फैलायो, अऊर चक्का उन्को संग संग चलन लग्यो; अऊर इस्राएल को परमेश्वर की सामर्थ उन्को ऊपर होतो। ");
INSERT INTO lbm_vpl VALUES ("EK11_23","027_11_23","EZK","11","23","23","तब परमेश्वर को तेज नगर को बीच म सी निकल क वा पहाड़ी पर ठहर गयो जो नगर को पूर्व दिशा को तरफ हय। ");
INSERT INTO lbm_vpl VALUES ("EK11_24","027_11_24","EZK","11","24","24","फिर आत्मा न मोख ऊपर उठायो, अऊर परमेश्वर की आत्मा की शक्ति सी दर्शन म मोख कसदियों को देश म बन्दियों को जवर पहुंचाय दियो। जो दर्शन मय न देख्यो होतो ऊ दर्शन गायब भय गयो। ");
INSERT INTO lbm_vpl VALUES ("EK11_25","027_11_25","EZK","11","25","25","तब जितनी बाते परमेश्वर न मोख दिखायी होती, हि सब मय न बन्दियों ख बताय दियो। ");
INSERT INTO lbm_vpl VALUES ("EK12_1","027_12_1","EZK","12","1","1","फिर परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK12_2","027_12_2","EZK","12","2","2","“हे आदमी की सन्तान,” तय झगड़ालु करन वालो घराना को बीच म रह्य हय, जिन्ख देखन लायी आखी त हंय, पर नहीं देखय; अऊर सुनन लायी कान त हंय पर नहीं सुनय; कहालीकि हि विद्रोह करन वालो घराना को आय। ");
INSERT INTO lbm_vpl VALUES ("EK12_3","027_12_3","EZK","12","3","3","“येकोलायी हे आदमी की सन्तान, दिन ख बन्धुवायी को सामान तैयार कर क् उन्को आखी को सामने नगर सी निकल जाजो, उन्को आखी को सामने सी अपनी जागा छोड़ क दूसरी जागा ख चली जाजो। होय सकय हय हि विद्रोही तुम पर ध्यान दे। ");
INSERT INTO lbm_vpl VALUES ("EK12_4","027_12_4","EZK","12","4","4","येकोलायी तय दिन को समय उन्को देखतो हुयो बन्धुवायी को सामान को जसो अपनो सामान बान्ध लेजो, अऊर तय शाम ख बन्धुवायी म जान वालो को जसो उन्को देखतो हुयो निकल जाजो। ");
INSERT INTO lbm_vpl VALUES ("EK12_5","027_12_5","EZK","12","5","5","उन्को देखतो हुयो दीवाल ख फोड़ क वहां सीच निकल जाजो। ");
INSERT INTO lbm_vpl VALUES ("EK12_6","027_12_6","EZK","12","6","6","उन्को देखतो हुयो अपनो सामान कन्धा पर उठाय क अन्धारो म निकालजो, अऊर अपनो मुंह झाक्यो रहजो कि तय अपनो देश ख नहीं देख सके; कहालीकि मय न तोख इस्राएल को घराना को लायी एक चिन्ह ठहरायो हय।” ");
INSERT INTO lbm_vpl VALUES ("EK12_7","027_12_7","EZK","12","7","7","वा आज्ञा को अनुसार मय न वसोच करयो। दिन ख मय न अपनो सामान बन्धुवायी को सामान को जसो निकाल्यो, अऊर शाम ख अपनो हाथ सी दीवाल ख फोड़्यो; फिर अन्धारो म सामान ख निकाल क, उन्को देखतो हुयो अपनो कन्धा पर उठाय क चली गयो। ");
INSERT INTO lbm_vpl VALUES ("EK12_8","027_12_8","EZK","12","8","8","सुबेरे परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK12_9","027_12_9","EZK","12","9","9","“हे आदमी की सन्तान, का इस्राएल को घराना न मतलब ऊ विद्रोह करन वालो घराना न तोरो सी यो नहीं पुच्छ्यो, ‘यो तय का कर रह्यो हय?’ ");
INSERT INTO lbm_vpl VALUES ("EK12_10","027_12_10","EZK","12","10","10","तय उन सी कह्य, ‘प्रभु परमेश्वर यो कह्य हय : यो प्रभावशाली वचन यरूशलेम नगर को मुखिया अऊर इस्राएल को पूरो घराना को बारे म हय जेको बीच म हि रह्य हय।’ ");
INSERT INTO lbm_vpl VALUES ("EK12_11","027_12_11","EZK","12","11","11","तय उन्को सी कह्य, ‘मय तुम्हरो लायी चिन्ह आय; जसो मय न करयो हय, वसोच इस्राएली लोगों सी भी करयो जायेंन; उन्ख बन्दी बन क जानो पड़ेंन।’ ");
INSERT INTO lbm_vpl VALUES ("EK12_12","027_12_12","EZK","12","12","12","उन्को बीच जो मुखिया हय, ऊ अन्धारो म अपनो कन्धा पर बोझ उठाय क निकलेंन; हि अपनो सामान निकालन लायी दीवाल ख फोड़ेंन, अऊर अपनी आखी झाक्यो रहेंन ताकि ओख जमीन दिखायी नहीं दे। ");
INSERT INTO lbm_vpl VALUES ("EK12_13","027_12_13","EZK","12","13","13","मय ओको पर अपनो जार फैलाऊं, अऊर ऊ मोरो फन्दा म फसेंन; अऊर मय ओख कसदियों को देश को बेबीलोन शहर म पहुंचाय देऊं; पर ऊ ओख देख नहीं सकेंन, कहालीकि ऊ अन्धा कर दियो जायेंन अऊर वहांच मर जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK12_14","027_12_14","EZK","12","14","14","जितनो ओको मदत करन वालो ओको आजु-बाजू होना, उन्ख अऊर उन्को पूरो दलों ख मय सब दिशावों म तितर-बितर कर देऊं; अऊर तलवार खींच क उन्को पीछा करूं। ");
INSERT INTO lbm_vpl VALUES ("EK12_15","027_12_15","EZK","12","15","15","“जब मय उन्ख राज्यों म तितर-बितर कर देऊं, अऊर देश देश म छिन्न भिन्न कर देऊं, तब हि जान लेयेंन कि मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EK12_16","027_12_16","EZK","12","16","16","पर मय उन म सी थोड़ो सो लोगों ख तलवार, भूख अऊर महामारी सी बचाय रखूं; अऊर हि अपनो घृणित कामों को उन राष्ट्रों म वर्णन करेंन जिन को बीच म हि पहुंचेंन; तब हि जान लेयेंन कि मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EK12_17","027_12_17","EZK","12","17","17","तब परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK12_18","027_12_18","EZK","12","18","18","“हे आदमी की सन्तान, कापतो हुयो अपनी रोटी खाजो अऊर थरथरातो अऊर चिन्ता करतो हुयो अपनो पानी पीजो; ");
INSERT INTO lbm_vpl VALUES ("EK12_19","027_12_19","EZK","12","19","19","अऊर यो देश को लोगों सी यो कहजो, कि प्रभु परमेश्वर अऊर इस्राएल को देश यरूशलेम को निवासियों को बारे म यो कह्य हय : हि अपनी रोटी चिन्ता को संग खायेंन, अऊर अपनो पानी डर को संग पीयेंन; कहालीकि देश अपनो सब रहन वालों को उपद्रव को वजह अपनी पूरी भरपूरी सी रहित होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK12_20","027_12_20","EZK","12","20","20","बस्यो हुयो नगर उजड़ जायेंन, अऊर देश भी उजाड़ होय जायेंन, तब तुम लोग जान लेवो कि मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EK12_21","027_12_21","EZK","12","21","21","फिर परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK12_22","027_12_22","EZK","12","22","22","“हे आदमी की सन्तान, या का कहावत आय जो तुम लोग इस्राएल को देश म कहत होतो, ‘दिन बहुत बीत गयो हय, अऊर दर्शन की कोयी बात पूरी नहीं भयी?’ ");
INSERT INTO lbm_vpl VALUES ("EK12_23","027_12_23","EZK","12","23","23","येकोलायी उन्को सी कह्य, ‘प्रभु परमेश्वर यो कह्य हय : मय या कहावत ख बन्द करूं; अऊर या कहावत इस्राएल पर फिर कभी नहीं चलेंन।’ तय उन सी कह्य कि ऊ दिन जवर आय गयो हय, अऊर दर्शन कि सब बाते पूरी होन पर हय। ");
INSERT INTO lbm_vpl VALUES ("EK12_24","027_12_24","EZK","12","24","24","“कहालीकि इस्राएल को घराना म अऊर जादा झूठो दर्शन की कोयी बाते अऊर कोयी चिकनी-चुपड़ी बाते फिर कभी कही नहीं जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK12_25","027_12_25","EZK","12","25","25","कहालीकि मय परमेश्वर आय, जब मय बोलू, तब जो वचन मय कहू, वा पूरो होय जायेंन। ओको म देरी नहीं होयेंन, पर हे विद्रोह करन वालो घराना, तुम्हरो दिनो म मय वचन कहूं, अऊर ऊ पूरो होय जायेंन, प्रभु परमेश्वर की या वानी हय।” ");
INSERT INTO lbm_vpl VALUES ("EK12_26","027_12_26","EZK","12","26","26","फिर परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK12_27","027_12_27","EZK","12","27","27","“हे आदमी की सन्तान, देख, इस्राएल को घराना को लोग यो कह्य रह्यो हय, ‘जो दर्शन ऊ देखय हय, ऊ बहुत दिन को बाद पूरो होन वालो हय; अऊर ऊ दूर को भविष्य को बारे म भविष्यवानी करय हय।’ ");
INSERT INTO lbm_vpl VALUES ("EK12_28","027_12_28","EZK","12","28","28","येकोलायी तय उन्को सी कह्य, प्रभु परमेश्वर यो कह्य हय : मोरो कोयी वचन को पूरो होन म फिर देर नहीं होयेंन, बल्की जो वचन मय कहू ऊ जरूर पूरो होयेंन, प्रभु परमेश्वर की या वानी हय।” ");
INSERT INTO lbm_vpl VALUES ("EK13_1","027_13_1","EZK","13","1","1","परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK13_2","027_13_2","EZK","13","2","2","“हे आदमी की सन्तान, इस्राएल को जो भविष्यवक्ता अपनोच मन सी भविष्यवानी करय हय, उन्को खिलाफ भविष्यवानी कर क् तय कह्य, परमेश्वर को वचन सुनो।” ");
INSERT INTO lbm_vpl VALUES ("EK13_3","027_13_3","EZK","13","3","3","प्रभु परमेश्वर यो कह्य हय : हाय, “उन मूर्ख भविष्यवक्तावों पर जो अपनीच आत्मा को पीछु भटक जावय हय, अऊर उन्न कुछ दर्शन नहीं पायो! ");
INSERT INTO lbm_vpl VALUES ("EK13_4","027_13_4","EZK","13","4","4","हे इस्राएल, तोरो भविष्यवक्ता खण्डरों म की लोमड़ियों को तरह हय। ");
INSERT INTO lbm_vpl VALUES ("EK13_5","027_13_5","EZK","13","5","5","तुम न इस्राएल की जागा की रखवाली नहीं करी अऊर नहीं दीवाल सुधारी, येकोलायी जब परमेश्वर को दिन म युद्ध होयेंन तब इस्राएल की रक्षा नहीं होय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EK13_6","027_13_6","EZK","13","6","6","हि लोग जो कह्य हय, परमेश्वर की या वानी हय, उन्न झूठो दर्शन अऊर झूठो दावा करयो हय; अऊर तब भी या आशा दिलायी कि परमेश्वर यो वचन पूरो करेंन; तब भी परमेश्वर न उन्ख नहीं भेज्यो। ");
INSERT INTO lbm_vpl VALUES ("EK13_7","027_13_7","EZK","13","7","7","का तुम्हरो दर्शन झूठो नहाय, अऊर झूठमूठ भविष्य की बाते नहीं कह्य? तुम कह्य हय, परमेश्वर की या वानी हय; पर मय न कुछ नहीं कह्यो हय।” ");
INSERT INTO lbm_vpl VALUES ("EK13_8","027_13_8","EZK","13","8","8","येकोलायी प्रभु परमेश्वर तुम सी यो कह्य हय, “तुम न जो बेकार बात कही अऊर झूठो दर्शन देख्यो हय, येकोलायी मय तुम्हरो खिलाफ हय, प्रभु परमेश्वर की या वानी हय। ");
INSERT INTO lbm_vpl VALUES ("EK13_9","027_13_9","EZK","13","9","9","जो भविष्यवक्ता झूठो दर्शन देखय अऊर भविष्य की झूठी बाते कह्य हय, मोरो हाथ उन्को खिलाफ होयेंन, अऊर हि मोरी प्रजा की मण्डली म सहभागी नहीं होयेंन, उन्को नाम इस्राएल की नामावली म नहीं लिख्यो जायेंन, अऊर नहीं इस्राएल को देश म सिरनो पायेंन; येकोसी तुम लोग जान लेवो कि मय प्रभु परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EK13_10","027_13_10","EZK","13","10","10","“कहालीकि भविष्यवक्तावों न ‘शान्ति हय,’ असो कह्य क मोरी प्रजा ख बहकायो हय जब कि शान्ति हयच नहाय; अऊर मोरो लोगों न गोटा की कच्ची दीवाल बनावय हय तब हि ओको पर चुना सी पोतायी करय हय। ");
INSERT INTO lbm_vpl VALUES ("EK13_11","027_13_11","EZK","13","11","11","उन कच्ची पोतायी करन वालों सी कह्य कि वा दीवाल गिर जायेंन। कहालीकि मूसलाधार बारीश होयेंन, अऊर बड़ी-बड़ी गारगोटी गिरेंन, अऊर जोर-दार आन्धी तुफान चलेंन। ");
INSERT INTO lbm_vpl VALUES ("EK13_12","027_13_12","EZK","13","12","12","जब दीवाल गिर जायेंन, तब का लोग तुम सी यो नहीं कहेंन, जो लीपा-पोती तुम न करी होती वा कहां गयी।” ");
INSERT INTO lbm_vpl VALUES ("EK13_13","027_13_13","EZK","13","13","13","यो वजह प्रभु परमेश्वर तुम सी यो कह्य हय : मय क्रोध सी बड़ी आन्धी चलाऊं; अऊर मोरो प्रकोप को वजह मूसलाधार बारीश होयेंन, मोरो गुस्सा म बड़ी-बड़ी गारगोटी गिरेंन कि दीवाल ख नाश कर दे। ");
INSERT INTO lbm_vpl VALUES ("EK13_14","027_13_14","EZK","13","14","14","यो रीति सी तुम न दीवाल पर लीपा-पोती करी हय, ओख मय गिराय देऊं, बल्की माटी म मिलाय देऊं, मय ओको पायवा तक उखाड़ देऊं; अऊर जब वा गिरेंन, तब तुम भी ओको खल्लो दब क मर जावो; तब तुम जान लेवो कि मयच परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EK13_15","027_13_15","EZK","13","15","15","यो रीति सी मय दीवाल अऊर ओकी लीपा-पोती करन वालो दोयी पर अपनो गुस्सा पूरो रीति सी भड़काऊं; फिर तुम सी कहूं, नहीं त दीवाल रही, अऊर नहीं ओको लीपा-पोती करन वालो रह्यो, ");
INSERT INTO lbm_vpl VALUES ("EK13_16","027_13_16","EZK","13","16","16","हि इस्राएल को हि भविष्यवक्ता जो यरूशलेम को बारे म भविष्यवानी करत होतो, अऊर उन्की शान्ति को दर्शन बतावत होतो, जब कि वहां शान्ति हयच नहाय, पर प्रभु परमेश्वर की या वाणी हय। ");
INSERT INTO lbm_vpl VALUES ("EK13_17","027_13_17","EZK","13","17","17","“फिर हे आदमी की सन्तान, तय अपनो भाऊ-बन्धुवों की टुरियों को खिलाफ अपनो मुंह खोल, जो अपनोच मन सी भविष्यवानी करय हय; उन्को खिलाफ भविष्यवानी कर क् कह्य, ");
INSERT INTO lbm_vpl VALUES ("EK13_18","027_13_18","EZK","13","18","18","प्रभु परमेश्वर यो कह्य हय, “जो बाईयां हाथ सी सब हाथों लायी जादुई ताबीज बनावय अऊर हर कोयी ख मारन लायी सब तरह को आदमियों को मुंड ख झाकन लायी जादुई कपड़ा बनावय हय, उन पर धिक्कार हय! का तुम मोरी प्रजा को लोगों को जीवों ख जाल म डालो अऊर अपनो खुद को जीव बचाय सकजो? ");
INSERT INTO lbm_vpl VALUES ("EK13_19","027_13_19","EZK","13","19","19","तुम न त मुट्ठी भर जौ, गहूं, अऊर रोटी को तुकड़ा को बदला मोख मोरी प्रजा की नजर म अपवित्र ठहराय क, अऊर उन झूठी बातों को द्वारा, जो मोरी प्रजा को लोग तुम सी सुनय हय, जो नाश को लायक नहीं होतो, उन्ख मार डाल्यो; अऊर जो बचन को लायक नहीं होतो उन जीवों ख बचाय क रख्यो हय। ");
INSERT INTO lbm_vpl VALUES ("EK13_20","027_13_20","EZK","13","20","20","“यो वजह प्रभु परमेश्वर तुम सी यो कह्य हय : देखो, मय तुम्हरो उन ताबीज को खिलाफ हय, जिन्को द्वारा तुम जीवों पर जाल म फसावय हय, येकोलायी मय तुम्हरो ताबीजों ख बाहों पर सी छीन क उतार लेऊं, अऊर उन लोगों ख मुक्त कर देऊं, जिन्ख तुम फसावय होतो। ");
INSERT INTO lbm_vpl VALUES ("EK13_21","027_13_21","EZK","13","21","21","मय तुम्हरो मुंड को घुंघट ख फाड़ क अपनी प्रजा को लोगों ख तुम्हरो हाथ सी छुड़ाऊं, अऊर फिर कभी हि तुम्हरो वश म नहीं रहेंन कि तुम उन्को शिकार कर सको; तब तुम जान लेवो कि मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EK13_22","027_13_22","EZK","13","22","22","“तुम न जो झूठी बाते कह्य क धर्मी को मन ख उदास करयो हय, पर मय न ओख उदास करनो नहीं चाहयो, अऊर तुम न दुष्ट जन ख हिम्मत बन्धायी हय, ताकि ऊ अपनो बुरो रस्ता सी नहीं फिरे अऊर जीन्दो रहे। ");
INSERT INTO lbm_vpl VALUES ("EK13_23","027_13_23","EZK","13","23","23","यो वजह तुम फिर कभी झूठो दर्शन नहीं देखो, अऊर नहीं भविष्य कि झूठी बाते कह्य सको; कहालीकि मय अपनी प्रजा ख तुम्हरो हाथ सी छुड़ाऊं। तब तुम जान लेवो कि मय परमेश्वर आय।” ");
INSERT INTO lbm_vpl VALUES ("EK14_1","027_14_1","EZK","14","1","1","फिर इस्राएल को कुछ बुजूर्ग लोग मोरो जवर आय क मोरो सामने बैठ गयो। ");
INSERT INTO lbm_vpl VALUES ("EK14_2","027_14_2","EZK","14","2","2","तब परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK14_3","027_14_3","EZK","14","3","3","“हे आदमी की सन्तान,” हि आदमियों न त अपनो देवता की मूर्ति अपनो मन म बसाय लियो हय, अऊर अपनो अधर्म को ठोकर अपनो सामने रख्यो हय; फिर का हि मोरो सी कुछ पूछ पायेंन? ");
INSERT INTO lbm_vpl VALUES ("EK14_4","027_14_4","EZK","14","4","4","येकोलायी तय उन्को सी कह्य, प्रभु परमेश्वर यो कह्य हय : इस्राएल को घराना म सी जो कोयी अपनी देवता की मूर्ति अपनो मन म बसाय क, अऊर अपनो अधर्म को ठोकर अपनो सामने रख क भविष्यवक्ता को जवर आयेंन, ओख मय परमेश्वर, ओकी बहुत देवता की मूर्तियों को अनुसार उत्तर देऊं, ");
INSERT INTO lbm_vpl VALUES ("EK14_5","027_14_5","EZK","14","5","5","जेको सी इस्राएल को घराना, जो अपनी मूर्तियों को द्वारा मोख छोड़ क दूर भय गयो हय, उन्ख मय उन्कोच मन को द्वारा फसाऊं। ");
INSERT INTO lbm_vpl VALUES ("EK14_6","027_14_6","EZK","14","6","6","“येकोलायी इस्राएल को घराना सी कह्य, प्रभु परमेश्वर यो कह्य हय : पश्चाताप करो अऊर अपनी घृणित मूर्तियों सी मुंह मोड़ों; अऊर अपनो घृणित कामों ख छोड़ो।” ");
INSERT INTO lbm_vpl VALUES ("EK14_7","027_14_7","EZK","14","7","7","कहालीकि इस्राएल को घराना म सी अऊर उन्को बीच म रहन वालो परदेशियों म सी कोयी भी होना, जो मोरो पीछू चलनो छोड़ क अपनी देवता की मूर्ति अपनो मन म बसाय ले, अऊर अपनो अधर्म को ठोकर अपनो सामने रखेंन, अऊर सब मोरो सी अपनी कोयी बात पूछन लायी भविष्यवक्ता को जवर आयेंन, त ओख मय परमेश्वर खुदच उत्तर देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK14_8","027_14_8","EZK","14","8","8","मय ऊ आदमी को खिलाफ होय क ओख निराश करूं, अऊर चिन्ह ठहराऊं; अऊर ऊ अपनी दुर्दशा को वजह समाज म कहावत बन जायेंन, मय ओख अपनो निजी लोगों को बीच म सी निकाल देऊं; तब तुम जान लेवो कि मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EK14_9","027_14_9","EZK","14","9","9","यदि भविष्यवक्ता न धोखा खाय क कोयी वचन कह्यो हय, त जानो कि मय परमेश्वर न ऊ भविष्यवक्ता ख धोखा दियो हय; अऊर मय अपनो हाथ ओको खिलाफ उठाय क ओख अपनी प्रजा म सी नाश कर देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK14_10","027_14_10","EZK","14","10","10","हि सब लोग अपनो अपनो अधर्म को बोझ उठायेंन, मतलब जसो भविष्यवक्ता सी पूछन वालो को अधर्म ठहरेंन, वसोच भविष्यवक्ता को भी अधर्म ठहरेंन। ");
INSERT INTO lbm_vpl VALUES ("EK14_11","027_14_11","EZK","14","11","11","ताकि इस्राएल को घराना आगु सी मोरो पीछू चलनो मत छोड़े अऊर नहीं अपनो अलग अलग तरह को अपराधों को द्वारा आगु सी अशुद्ध बने; बल्की हि मोरी प्रजा बने अऊर मय उन्को परमेश्वर ठहरू, प्रभु परमेश्वर कि या वाणी आय। ");
INSERT INTO lbm_vpl VALUES ("EK14_12","027_14_12","EZK","14","12","12","तब परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK14_13","027_14_13","EZK","14","13","13","“हे आदमी की सन्तान,” जब कोयी देश को लोग मोरो सी विश्वासघात कर क् पापी होय जायेंन, तब मय उन्ख सजा देन लायी उन पर हाथ उठाय क उन्को भोजन को आधार बन्द करूं, अऊर उन पर अकाल भेजूं, मय वहां सी आदमी अऊर जनावर दोयी ख नाश करूं, ");
INSERT INTO lbm_vpl VALUES ("EK14_14","027_14_14","EZK","14","14","14","तब चाहे वहां नूह, दानिय्येल, अऊर अय्यूब रहत होना, त हि अपनो धर्म को वजह अपनो जीव बचाय सकेंन; प्रभु परमेश्वर की या वाणी आय। ");
INSERT INTO lbm_vpl VALUES ("EK14_15","027_14_15","EZK","14","15","15","यदि मय कोयी देश म जंगली जनावर भेजूं जो ओख रौंद क उजाड़ डालेंन, अऊर जंगली जनावर को वजह कोयी भी ऊ देश म सी होय क यात्रा नहीं करेंन, ");
INSERT INTO lbm_vpl VALUES ("EK14_16","027_14_16","EZK","14","16","16","त चाहे ओको म हि तीन धार्मिक आदमी रहत होना, तब भी परमेश्वर की या वाणी हय, मोरो जीवन की कसम, नहीं हि टुरावों ख अऊर नहीं टुरियों ख बचाय सकेंन, केवल हि तीनच आदमी बचेंन; पर पूरो देश नाश होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK14_17","027_14_17","EZK","14","17","17","यदि मय ऊ देश पर दुश्मन द्वारा तलवार चलवाय क कहूं, हे तलवार ऊ देश म चल; अऊर यो रीति सी मय ऊ देश म सी आदमी अऊर जनावर दोयी ख नाश करूं, ");
INSERT INTO lbm_vpl VALUES ("EK14_18","027_14_18","EZK","14","18","18","तब चाहे ओको म हि तीन धार्मिक आदमी भी होना, तब भी प्रभु परमेश्वर की या वाणी हय, मोरो जीवन की कसम, नहीं हि टुरावों ख अऊर नहीं टुरियों ख बचाय सकेंन, केवल हि अकेलोच बचेंन। ");
INSERT INTO lbm_vpl VALUES ("EK14_19","027_14_19","EZK","14","19","19","यदि मय ऊ देश म महामारी फैलाऊं अऊर ओको पर अपनो गुस्सा भड़काय क ओको खून असो बहाऊं कि वहां को आदमी अऊर जनावर दोयी नाश होय जायेंन, ");
INSERT INTO lbm_vpl VALUES ("EK14_20","027_14_20","EZK","14","20","20","त चाहे नूह, दानिय्येल अऊर अय्यूब भी वहां होना, तब भी प्रभु परमेश्वर की या वाणी हय, मोरो जीवन की कसम, हि नहीं टुरावों ख अऊर नहीं टुरियों ख बचाय सकेंन, अपनो धर्म को द्वारा हि केवल अपनोच जीव ख बचाय सकेंन। ");
INSERT INTO lbm_vpl VALUES ("EK14_21","027_14_21","EZK","14","21","21","“कहालीकि प्रभु परमेश्वर यो कह्य हय : मय यरूशलेम नगर पर अपनी चार विपत्तियां भेजूं, मतलब तलवार, अकाल, जंगली जनावर अऊर महामारी, जेको म आदमी अऊर जनावर सब ओको म सी नाश होय जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK14_22","027_14_22","EZK","14","22","22","तब भी ओको म सी थोड़ो सो टुरा-टुरियां बच जायेंन जो वहां सी निकाल क तुम्हरो जवर लायेंन, अऊर तुम उन्को चालचलन अऊर कामों ख देख क वा विपत्ति को बारे म जो मय यरूशलेम पर डालूं, बल्की जितनी विपत्ति मय ओको पर डालूं, हि सब को बारे म शान्ति पावों। ");
INSERT INTO lbm_vpl VALUES ("EK14_23","027_14_23","EZK","14","23","23","जब तुम उन्को चालचलन अऊर काम देखो, तब हि तुम्हरी शान्ति को वजह होयेंन; अऊर तुम जान लेवो कि मय न यरूशलेम नगर म जो कुछ करयो, ऊ बिना वजह नहीं करयो, प्रभु परमेश्वर की याच वाणी आय।” ");
INSERT INTO lbm_vpl VALUES ("EK15_1","027_15_1","EZK","15","1","1","फिर परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK15_2","027_15_2","EZK","15","2","2","“हे आदमी की सन्तान,” सब झाड़ो म अंगूर की बेला कि का श्रेष्ठता हय? अंगूर की बेला जो जंगल को झाड़ो को तुलना म अंगूर की एक डगाली को का महत्व हय? ");
INSERT INTO lbm_vpl VALUES ("EK15_3","027_15_3","EZK","15","3","3","का कोयी चिज बनावन लायी ओको म सी लकड़ी लियो जावय हय, यां कोयी बर्तन टंगावन लायी वा लकड़ी म सी खूटी बन सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EK15_4","027_15_4","EZK","15","4","4","वा त केवल आगी म जलावन लायी काम म आवय हय; आगी ओको दोयी कोना ख जलाय देवय हय, बीच को हिस्सा आगी सी कारो पड़ जावय हय, पर लकड़ी पूरी तरह नहीं जलय, का वा लकड़ी कोयी काम म आय सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EK15_5","027_15_5","EZK","15","5","5","देख, जब वा बनी होती, तब भी वा कोयी काम की नहीं होती, फिर जब वा आगी म जल क भस्म भय गयी हय, तब का वा कोयी काम म आय सकय हय? ");
INSERT INTO lbm_vpl VALUES ("EK15_6","027_15_6","EZK","15","6","6","येकोलायी प्रभु परमेश्वर यो कह्य हय, जसो जंगल को झाड़ो म सी मय अंगूर की बेला ख निकाल क जलाय दियो जावय हय, वसोच मय यरूशलेम नगर को निवासियों को नाश कर देऊं। ");
INSERT INTO lbm_vpl VALUES ("EK15_7","027_15_7","EZK","15","7","7","मय उन्को खिलाफ होऊं, अऊर हि एक आगी म सी निकाल क दूसरी आगी म भस्म होय जायेंन; जब मय उन सी मुंह फिराय लेऊं, तब तुम जान लेवो कि मय परमेश्वर आय। ");
INSERT INTO lbm_vpl VALUES ("EK15_8","027_15_8","EZK","15","8","8","मय उन्को देश उजाड़ देऊं, कहालीकि उन्न मोरो सी विश्वासघात करयो हय, प्रभु परमेश्वर की या वाणी हय। ");
INSERT INTO lbm_vpl VALUES ("EK16_1","027_16_1","EZK","16","1","1","फिर परमेश्वर को यो वचन मोरो जवर पहुंच्यो, ");
INSERT INTO lbm_vpl VALUES ("EK16_2","027_16_2","EZK","16","2","2","“हे आदमी की सन्तान,” यरूशलेम ख ओको सब घृणित काम बताय दे, ");
INSERT INTO lbm_vpl VALUES ("EK16_3","027_16_3","EZK","16","3","3","अऊर ओको सी कह्य, हे यरूशलेम, प्रभु परमेश्वर तोरो सी यो कह्य हय : अपनो इतिहास देखो, तोरो जनम कनान देश म भयो हय; तोरो बाप एमोरी राज्य को अऊर तोरी माय हित्ती राज्य की होती। ");
INSERT INTO lbm_vpl VALUES ("EK16_4","027_16_4","EZK","16","4","4","तोरो जनम असो भयो कि जो दिन तोरो जनम भयो, ऊ दिन नहीं नार काट्यो गयो, नहीं तय शुद्ध होन लायी पानी सी धोयी गयी, नहीं तोरो पर नमक मल्यो गयो अऊर नहीं कपड़ा म लपेटी गयी। ");
INSERT INTO lbm_vpl VALUES ("EK16_5","027_16_5","EZK","16","5","5","कोयी की तोरो पर दया नहीं भयी कि इन कामों म सी तोरो लायी एक भी काम करयो जातो; बल्की जब तय पैदा भयी तब तोख घृणित चिज समझ क खुलो मैदान म फेक दियो होतो। ");
INSERT INTO lbm_vpl VALUES ("EK16_6","027_16_6","EZK","16","6","6","“जब मय तोरो जवर सी निकल्यो, अऊर तोख खून म लथपथ इत-उत डोलतो देख्यो। तब मय न तोरो सी कह्यो, ‘तय जीन्दी रह्य।’ ");
INSERT INTO lbm_vpl VALUES ("EK16_7","027_16_7","EZK","16","7","7","फिर मय न तोख खेत को एक पौधा को जसो बढ़ायो, अऊर तय बढ़त बढ़त बड़ी भय गयी अऊर बहुत सुन्दर भय गयी; अऊर तय युवती बनी, अऊर तोरो बाल बढ़्यो, तब भी तय बीन कपड़ा की होती।” ");
INSERT INTO lbm_vpl VALUES ("EK16_8","027_16_8","EZK","16","8","8","“मय फिर तोरो जवर सी होय क गयो अऊर तोख देख्यो, कि तोरो प्रेम म पड़न को समय आय गयो हय; येकोलायी मय न तोरो नग्न शरीर ख अपनो कपड़ा उड़ाय क तोरो शरीर झाक दियो; अऊर कसम खाय क तोरो सी वादा करयो, अऊर तोरो संग बिहाव करन को वचन दियो, अऊर तय मोरी पत्नि भय गयी।” प्रभु परमेश्वर की या वाणी हय। ");
INSERT INTO lbm_vpl VALUES ("EK16_9","027_16_9","EZK","16","9","9","“तब मय न तोख पानी सी नहलाय क तोरो पर सी खून धोय लियो, अऊर तोरो शरीर पर तेल मल्यो। ");
INSERT INTO lbm_vpl VALUES ("EK16_10","027_16_10","EZK","16","10","10","फिर मय न तोख बुन्यो हुयो कपड़ा अऊर अच्छो चमड़ा की जूती पहिनायो; अऊर तोख सुन्दर रेशमी अऊर किमती कपड़ा उड़ायो। ");
INSERT INTO lbm_vpl VALUES ("EK16_11","027_16_11","EZK","16","11","11","तब मय न तोख जेवरों सी सजाय दियो, अऊर तोरो हाथों म चूड़ियां अऊर गलो म हार पहिनायो। ");
INSERT INTO lbm_vpl VALUES ("EK16_12","027_16_12","EZK","16","12","12","फिर मय न तोरी नाक म नथ अऊर तोरो कानों म बारियां पहनायी, अऊर तोरो मुंड पर सुन्दर मुकुट रख्यो। ");
INSERT INTO lbm_vpl VALUES ("EK16_13","027_16_13","EZK","16","13","13","तोरो सोनो चांदी को जेवर अऊर तोरो कपड़ा सूती, रेशम अऊर बुन्यो हुयो मलमल को होतो; अऊर तय मैदा, शहेद अऊर तेल म पकायो भोजन खात होती; अऊर तय बहुत सुन्दर अऊर रानी बनन को लायक भय गयी। ");
INSERT INTO lbm_vpl VALUES ("EK16_14","027_16_14","EZK","16","14","14","तोरी सुन्दरता की चर्चा दूसरो राज्यों म फैल गयी, कहालीकि ऊ शोभा को वजह, जो मय न अपनो तरफ सी तोख दियो होतो, तय बहुत सुन्दर बन गयी होती, प्रभु परमेश्वर की याच वाणी आय। ");
INSERT INTO lbm_vpl VALUES ("EK16_15","027_16_15","EZK","16","15","15","“पर तय अपनी सुन्दरता पर भरोसा कर क् अपनी कीर्ती को वजह व्यभिचार करन लगी, अऊर सब यात्रियों को संग बहुत कुकर्म करयो, अऊर जो कोयी तोख चाहत होतो तय उन्को सीच व्यभिचार करावत होती। ");
INSERT INTO lbm_vpl VALUES ("EK16_16","027_16_16","EZK","16","16","16","तय न अपनो कपड़ा म सी अपनो लायी पूजा की जागा बनाय दियो, अऊर उन पर व्यभिचार करयो, असो कुकर्म करयो जो कभी नहीं भयो अऊर नहीं होयेंन। ");
INSERT INTO lbm_vpl VALUES ("EK16_17","027_16_17","EZK","16","17","17","तय न अपनो सुन्दर जेवर ले क जो मोरो दियो हुयो सोनो चांदी को होतो, उन सी आदमियों की मूर्तियां बनाय ली, अऊर उन सी भी व्यभिचार करन लगी; ");
INSERT INTO lbm_vpl VALUES ("EK16_18","027_16_18","EZK","16","18","18","अऊर अपनो हाथ सी बुन्यो हुयो कपड़ा ले क उन्ख पहिनायो, अऊर मोरो जैतून को तेल अऊर धूप उन्को सामने चढ़ायो। ");
INSERT INTO lbm_vpl VALUES ("EK16_19","027_16_19","EZK","16","19","19","जो भोजन मय न तोख दियो होतो, मैदा, जैतून को तेल अऊर शहेद मय न तोख दियो होतो, ऊ सब तय न हि मूर्तियों को सामने सुखदायक सुगन्ध कर क् चढ़ायो; प्रभु परमेश्वर की या वाणी हय कि असोच भयो।” ");
INSERT INTO lbm_vpl VALUES ("EK16_20","027_16_20","EZK","16","20","20","“फिर तय न अपनो टुरा-टुरियों ख ले क जिन्ख तय न मोरो लायी जनम दियो होतो, हि मूर्तियों पर बलि कर क् चढ़ाय दियो। का तोरो असो व्यभिचार छोटी बात हय; ");
INSERT INTO lbm_vpl VALUES ("EK16_21","027_16_21","EZK","16","21","21","तय न मोरो बच्चावों ख हि मूर्तियों को आगु आगी म बलि कर क् चढ़ाय दियो? ");
INSERT INTO lbm_vpl VALUES ("EK16_22","027_16_22","EZK","16","22","22","तय न अपनो सब घृणित कामों म अऊर व्यभिचार करतो समय, अपनो बचपन को दिनो की कभी याद नहीं आयी, जब कि तय बिना कपड़ा की अपनो खून म लथपथ पड़ी होती।” ");
INSERT INTO lbm_vpl VALUES ("EK16_23","027_16_23","EZK","16","23","23","“तोख तोरो पूरो बुरो कामों को लायी धिक्कार हय! धिक्कार हय तोख! प्रभु परमेश्वर की या वाणी हय। ");
INSERT INTO lbm_vpl VALUES ("EK16_24","027_16_24","EZK","16","24","24","तय न अपनो लायी एक गुम्मट बनाय लियो, अऊर हर एक खुली जागा म एक ऊंचो पूजा की जागा बनाय लियो ");
INSERT INTO lbm_vpl VALUES ("EK16_25","027_16_25","EZK","16","25","25","अऊर हर एक सड़क को किनार पर तय न अपनो ऊंची जागा बनाय क अपनी सुन्दरता घृणित कर दी, अऊर हर एक जवर सी जान वालो ख बुलाय क कुकर्म करत होती, अऊर तय वेश्या सी जादा बन गयी। ");
INSERT INTO lbm_vpl VALUES ("EK16_26","027_16_26","EZK","16","26","26","तय न अपनो पड़ोसी मिस्रियों सी भी व्यभिचार करयो अऊर मोख गुस्सा दिलावन लायी तय न व्यभिचार करयो। ");
INSERT INTO lbm_vpl VALUES ("EK16_27","027_16_27","EZK","16","27","27","“येकोलायी मय न तोख सजा देन अऊर तोरो निजी हिस्सा छीनन लायी अपनो हाथ उठायो हय, अऊर मय न तोख तोरी दुस्मन पलिश्ती बाईयों को हाथ म सौप दियो हय, जो तोरो सी घृना करय हय, उन्की इच्छा पर मय न तोख छोड़ दियो हय। ");
INSERT INTO lbm_vpl VALUES ("EK16_28","027_16_28","EZK","16","28","28","“फिर भी तोख समाधान नहीं मिल्यो, येकोलायी तय न अश्शूरी लोगो सी भी व्यभिचार करयो; अऊर उन्को सी व्यभिचार करन पर भी तोख सन्तुष्टी नहीं मिली। ");
INSERT INTO lbm_vpl VALUES ("EK16_29","027_16_29","EZK","16","29","29","फिर तय न व्यापारियों को देश म व्यभिचार करत करत कसदियों को देश तक पहुंची, अऊर वहां भी तय तृप्त नहीं भयी।” ");
INSERT INTO lbm_vpl VALUES ("EK16_30","027_16_30","EZK","16","30","30","“प्रभु परमेश्वर की या वाणी हय, कि तोरो दिल कसो चंचल हय कि तय हि सब काम करय हय, जो निर्लज्ज वेश्या को जसो कुकर्म करय हय! ");
INSERT INTO lbm_vpl VALUES ("EK16_31","027_16_31","EZK","16","31","31","तय न हर एक सड़क को सुरूवात म जो अपनो गुम्मट, अऊर हर चौक म अपनो पूजा की जागा बनायो हय, पर तय एक आम वेश्या को समान पैसा को लायी नहाय? कहालीकि तय असी कमायी पर हसय हय? ");
INSERT INTO lbm_vpl VALUES ("EK16_32","027_16_32","EZK","16","32","32","तय व्यभिचारिनी पत्नि हय। तय परायो आदमियों ख अपनो पति को बदला स्विकार करय हय। ");
INSERT INTO lbm_vpl VALUES ("EK16_33","027_16_33","EZK","16","33","33","सब वेश्यावों ख त रुपया मिलय हय, पर तय न अपनो सब संगियों ख खुद रुपया दे क, अऊर उन्ख लालच दिखाय क बुलायो हय कि हि चारयी तरफ सी आय क तोरो सी व्यभिचार करे। ");
INSERT INTO lbm_vpl VALUES ("EK16_34","027_16_34","EZK","16","34","34","यो तरह तोरो व्यभिचार दूसरो व्यभिचारियों सी उलटो हय। तोरो पीछू कोयी व्यभिचारी नहीं चलय, अऊर तय कोयी सी दाम नहीं लेवय, बल्की तयच देवय हय; यो वजह तय उलटी ठहरी।” ");
INSERT INTO lbm_vpl VALUES ("EK16_35","027_16_35","EZK","16","35","35","येकोलायी, हे वेश्या, परमेश्वर को वचन सुन, ");
INSERT INTO lbm_vpl VALUES ("EK16_36","027_16_36","EZK","16","36","36","प्रभु परमेश्वर यो कह्य हय : “तय न जो व्यभिचार म अति निर्लज्ज होय क, अपनो शरीर अपनो संगियों ख दिखायो, अऊर अपनी मूर्तियों सी घृणित काम करयो, अऊर अपनो बच्चां को खून बहाय क उन्ख बलि चढ़ायो हय, ");
INSERT INTO lbm_vpl VALUES ("EK16_37","027_16_37","EZK","16","37","37","यो वजह देख, मय तोरो सब संगियों ख जो तोरो प्रेमी हय अऊर जितनों सी तय प्रेम करत होती, अऊर जितनों सी तय न दुश्मनी रखी, उन सब ख चारयी तरफ सी तोरो खिलाफ जमा कर क् उन्ख तोरो शरीर बिना कपड़ा को दिखाऊं, अऊर हि तोरो तन देखेंन। ");
INSERT INTO lbm_vpl VALUES ("EK16_38","027_16_38","EZK","16","38","38","तब मय तोख असी सजा देऊं, जसो व्यभिचारिनियों अऊर हत्यारिणी बाईयों ख दियो जावय हय, वाच सजा मय तोख देऊं; अऊर गुस्सा अऊर जलन को संग तोरो खून बहाऊं। ");
INSERT INTO lbm_vpl VALUES ("EK16_39","027_16_39","EZK","16","39","39","यो रीति सी मय तोख उन्को वश म कर देऊं; अऊर हि तोरो गुम्मटों ख गिराय देयेंन, अऊर तोरो पूजा जागा ख तोड़ देयेंन, हि तोरो कपड़ा अऊर तोरो सुन्दर जेवर छीन लेयेंन, अऊर तोख बिना कपड़ा की कर क् छोड़ देयेंन।” ");
INSERT INTO lbm_vpl VALUES ("EK16_40","027_16_40","EZK","16","40","40","“तब तोरो खिलाफ एक सभा जमा कर क् हि तोख गोटा सी मारेंन, अऊर तलवार सी तुकड़ा तुकड़ा कर देयेंन। ");
INSERT INTO lbm_vpl VALUES ("EK16_41","027_16_41","EZK","16","41","41","तब हि तोरो घरों ख आगी लगाय क जलाय देयेंन, अऊर तोख बहुत सी बाईयों को सामने सजा देयेंन; अऊर मय तोरो व्यभिचार बन्द कर देऊं, अऊर तय परायो आदमियों ख अपनी वेश्यावृत्ति को दाम नहीं देजो। ");
INSERT INTO lbm_vpl VALUES ("EK16_42","027_16_42","EZK","16","42","42","जब मय तोरो पर अपनी जलजलाहट प्रगट करूं, तब मोरो गुस्सा शान्त होय जायेंन, अऊर मय शान्त होय जाऊं। मय अब गुस्सा यां जलन नहीं करूं। ");
INSERT INTO lbm_vpl VALUES ("EK16_43","027_16_43","EZK","16","43","43","तय न जो अपनो बचपन को दिन याद नहीं रख्यो, बल्की इन सब बातों को द्वारा मोख चिढ़ायो, यो वजह मय तोरो चालचलन तोरो मुंड पर डालूं अऊर तय अपनो सब पिछलो घृणित कामों सी अऊर जादा पाप नहीं करजो, प्रभु परमेश्वर की या वानी हय।” ");
INSERT INTO lbm_vpl VALUES ("EK16_44","027_16_44","EZK","16","44","44","“देख, सब कहावत कहन वालो तोरो बारे म या कहावत कहेंन, ‘जसी माय वसी टुरी।’ ");
INSERT INTO lbm_vpl VALUES ("EK16_45","027_16_45","EZK","16","45","45","तोरी माय जो अपनो पति अऊर बच्चां सी घृणा करत होती, तय भी ठीक ओकीच टुरी ठहरी; अऊर तोरी बहिन जो अपनो अपनो पति अऊर बच्चां सी घृणा करत होती, तय भी अपनी बहिनों को जसी निकली। तोरी माय हित्ती राज्य की होती अऊर तोरो बाप एमोरी राज्य को होतो।” ");
INSERT INTO lbm_vpl VALUES ("EK16_46","027_16_46","EZK","16","46","46","“तोरी बड़ी बहिन सामरी नगर आय, जो अपनी टुरियों को समेत उत्तर सीमा को तरफ रह्य हय, अऊर तोरी छोटी बहिन जो तोरो दक्षिन सीमा को तरफ रह्य हय वा टुरियों समेत सदोम नगर आय। ");
INSERT INTO lbm_vpl VALUES ("EK16_47","027_16_47","EZK","16","47","47","तय न उन्को जसी चाल नहीं चली, अऊर उन्को समान घृणित कामों सीच सन्तुष्ट नहीं भयी; या त बहुत छोटी बात हय, पर तोरो पूरो चालचलन उन्को सी भी जादा बिगड़ गयो। ");
INSERT INTO lbm_vpl VALUES ("EK16_48","027_16_48","EZK","16","48","48","“प्रभु परमेश्वर की या वाणी हय,” मोरो जीवन की कसम, “तोरी बहिन सदोम न अपनी टुरियों समेत तोरी अऊर तोरी टुरियों को समान काम नहीं करयो। ");
INSERT INTO lbm_vpl VALUES ("EK16_49","027_16_49","EZK","16","49","49","देख, तोरी बहिन सदोम को अधर्म यो होतो, कि वा अपनी टुरियों समेत घमन्ड करत होती, पेट भर भर क खात होती, अऊर सुख चैन सी रहत होती; उन्न गरीबों अऊर जरूरतमन्दों की मदत नहीं करी। ");
INSERT INTO lbm_vpl VALUES ("EK16_50","027_16_50","EZK","16","50","50","बल्की वा घमन्ड कर क् मोरो सामने घृणित काम करन लगी, अऊर यो देख क मय न उन्ख दूर कर दियो। ");
INSERT INTO lbm_vpl VALUES ("EK16_51","027_16_51","EZK","16","51","51","“फिर शोमरोन नगर न तोरो पापों सी अरधो भी पाप नहीं करयो, तय न त ओको सी भी कहीं जादा घृणित काम करयो, अऊर अपनो घोर घृणित कामों को द्वारा तोरी तुलना म तोरी बहिन निर्दोष ठहरी हय। ");
INSERT INTO lbm_vpl VALUES ("EK16_52","027_16_52","EZK","16","52","52","येकोलायी तय न जो अपनी बहिनों को न्याय करयो होतो, यो वजह लज्जित हो, कहालीकि तय न उन्को सी बढ़ क घृणित पाप करयो हय; यो वजह हि तोरो सी कम दोषी ठहरी हय। येकोलायी तय या बात सी लज्जा कर अऊर लजाती रह्य, कहालीकि तय न अपनी बहिनों ख कम दोषी ठहरायो हय।” ");
INSERT INTO lbm_vpl VALUES ("EK16_53","027_16_53","EZK","16","53","53","“जब मय उन्ख मतलब टुरियों समेत सदोम अऊर शोमरोन ख बन्धुवायी सी वापस लाऊं, तब उन्को बीच म तोरो बन्दियों ख भी वापस लाऊं, ");
INSERT INTO lbm_vpl VALUES ("EK16_54","027_16_54","EZK","16","54","54","जेको सी तोरो अभिमान टूट जायेंन, अऊर अपनो सब कामों ख देख क लजायजो, कहालीकि तय उन्की शान्ति को वजह बनी हय। ");
INSERT INTO lbm_vpl VALUES ("EK16_55","027_16_55","EZK","16","55","55","तोरी बहिनें सदोम अऊर शोमरोन अपनी अपनी टुरियों समेत अपनी पहिली दशा म फिर सी लौट जायेंन, अऊर तय भी अपनी टुरियों समेत अपनी पहिली दशा म फिर सी लौट जायेंन। ");
INSERT INTO lbm_vpl VALUES ("EK16_56","027_16_56","EZK","16","56","56","जब तक तोरी बुरायी प्रगट नहीं भयी होती, मतलब जो समय तक तय आजु बाजू को लोगों समेत अरामी अऊर पलिश्ती छेत्र की बाईयों की जो अब चारयी तरफ सी तोख तुच्छ जानय हंय, नामधरायी करत होती, ");
INSERT INTO lbm_vpl VALUES ("EK16_57","027_16_57","EZK","16","57","57","उन अपनो घमण्ड को दिनों म त तय अपनी बहिन सदोम नगर को नाम भी नहीं लेत होती। ");
INSERT INTO lbm_vpl VALUES ("EK16_58","027_16_58","EZK","16","58","58","पर अब तोख अपनो महापाप अऊर घृणित कामों को बोझ खुद ख उठानो पड़्यो हय, परमेश्वर की याच वानी हय।” ");
INSERT INTO lbm_vpl VALUES ("EK16_59","027_16_59","EZK","16","59","59","“प्रभु परमेश्वर यो कह्य हय : मय तोरो संग असोच बर्ताव करूं, जसो तय न करयो हय, कहालीकि तय न त वाचा तोड़ क कसम तुच्छ समझी हय, ");
INSERT INTO lbm_vpl VALUES ("EK16_60","027_16_60","EZK","16","60","60","तब भी मय तोरो बचपन को दिनों की अपनी वाचा याद करूं, अऊर तोरो संग हमेशा की वाचा बान्धूं। ");
INSERT INTO lbm_vpl VALUES ("EK16_61","027_16_61","EZK","16","61","61","जब तय अपनी बहिनों ख मतलब अपनी बड़ी अऊर छोटी बहिनों ख स्विकार करजो, तब तय अपनो चालचलन याद कर क् लज्जित होयजो; अऊर मय उन्ख तोरी टुरियां ठहराय देऊं; पर या तोरी वाचा को अनुसार नहीं करूं। ");
INSERT INTO lbm_vpl VALUES ("EK16_62","027_16_62","EZK","16","62","62","मय तोरो संग अपनी वाचा स्थिर करूं, अऊर तब तय जान लेजो कि मय परमेश्वर आय, ");
INSERT INTO lbm_vpl VALUES ("EK16_63","027_16_63","EZK","16","63","63","जेकोसी तय याद कर क् लज्जित हो, अऊर लज्जा को मारे फिर कभी मुंह खोलन की हिम्मत नहीं करजो। यो ऊ समय होयेंन, जब मय तोरो सब कामों ख माफ करूं, प्रभु परमेश्वर की या वानी हय।” ");
INSERT INTO lbm_vpl VALUES ("EK17_1","027_17_1","EZK","17","1","1","परमेश्वर को यो वचन मोरो जवर पहुंच्यो : ");
INSERT INTO lbm_vpl VALUES ("EK17_2","027_17_2","EZK","17","2","2","“हे आदमी की सन्तान, इस्राएल को घराना सी या पहेली अऊर 