﻿USE sofia;
DROP TABLE IF EXISTS sofia.lbk_vpl;
CREATE TABLE lbk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lbk_vpl WRITE;
INSERT INTO lbk_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","2","Isnan laplapona, winad-ay Apo Dios nan chaya ya nan lota. Nan lota, maid paat manongnong si foyana issan chey. Maid entetee ya chadlos ab-afollinget isnan olay entona, ya kecheng nan fayfay is wad-ay. Sa et wad-ay nan Ispiriton Apo Dios ay enliklikhed isnan tongchon nan fayfay. ");
INSERT INTO lbk_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Sa et infilin Apo Dios ta mawad-ay nan paway, ya ket pinmaway tet-ewa. ");
INSERT INTO lbk_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Finoyan Apo Dios ay khawis nan paway, ya nang-ep. Sa na't isiyan nan paway isnan follinget. ");
INSERT INTO lbk_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nginadnana nan paway is mag-akhew, ya nan follinget is maschem. Ket ay nakhosfet, awni ya mawiit, ya nar-os nan inmona ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Sa et infilin Apo Dios ta mawad-ay nan lawag ay mangedwa isnan chanom ta enfalin ay chwa nan entey-ana. ");
INSERT INTO lbk_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Adi kad khinaebna nan lawag ay mensiyan isnan chanom isnan khwabna ya nan lifoo id tongcho. Et siya nan naangnen. ");
INSERT INTO lbk_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Sa na't nginadnan id tongcho is chaya. Ket ay nakhosfet, awni ya mawiit, ya nar-os nan ikadwa ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Sa na't kasin infilin ta maamong nan chanom ay wad-ay isnan khwab nan chaya ta matken nan tey-ana, ta maila nan lota, et siya nan naangnen. ");
INSERT INTO lbk_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nan maid chanomna nginadnana is lota, ya nan naamoamong ay chanom nginadnana is fayfay. Et nang-ep si Apo Dios isnan finoyana, tay khawis. ");
INSERT INTO lbk_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Sa na't infilin ta tomofo isnan lota nan am-in ay ilan si mola ay waschin mamkhas ya wad-ay fokerna, ya nan am-in ay ilan si kaew ay waschin mamkhas ay wad-ay nan fwana, et siya nan naangnen. ");
INSERT INTO lbk_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Siya chi ay nawad-ay isnan lota nan am-in ay nateketeken ay mola ay waschin mamkhas ya wad-ay fokerna, ya am-in ay nateketeken ay kaew ay waschin mamkhas ay wad-ay nan fwana. Et nang-ep si Apo Dios isnan finoyana tay khawis. ");
INSERT INTO lbk_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ket ay kasin nakhosfet, awni ya mawiit, ya nar-os nan ikatlo ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Sa na't infilin ay mawad-ay nan kasilasilaw id tongcho ay kail-an nan enteknan nan mag-akhew isnan maschem, tatno siya chachi nan kaimatonan nan lokhin si kaakheakhew, tawen, chinamey, chakhon, ya kesep. ");
INSERT INTO lbk_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ya ta enlanglang cha id chaya ta pomaway nan lofong, et siya nan naangnen. ");
INSERT INTO lbk_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Adi kad khinaeb Apo Dios nan chwa ay kalalanglangan ay silaw. Nan akhew ay ad-ad-acha nan langlangna nan napigpigsa isnan mag-akhew, ya nan fowan ay akit nan langlangna nan napigpigsa isnan maschem. Winad-ayna akhes nan tokwifi. ");
INSERT INTO lbk_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Inpeyna am-in chana ay silaw id chaya ta langlangancha nan lofong, ");
INSERT INTO lbk_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ta chaicha nan napigpigsa ay enlalanglang isnan mag-akhew ya maschem ya nan kail-an nan enteknan nan paway ya follinget. Et nang-ep si Apo Dios isnan finoyana, tay khawis. ");
INSERT INTO lbk_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kasin kayet nakhosfet, awni ya mawiit, ya nar-os nan ikap-at ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Sa et infilin Apo Dios ay mawad-ay is kadchanom nan angsaangsan ay ilan si enfib-iyag, ya id tongcho nan isyangkhay ay ilan si entat-ayaw. ");
INSERT INTO lbk_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Adi kad winad-ay Apo Dios nan chadchakowag ay enkik-iwi is kafayfay ya nan am-in ay ilan si enfib-iyag ay enkhig-iwa is kadchanom, ya am-in ay ilan si napayyakan. Et nang-ep si Apo Dios isnan finoyana, tay khawis. ");
INSERT INTO lbk_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Sa na't binindisyonan chachi ay mangwanin, “Makhanakhanak kayo ay wad-ay isnan fayfay, ta ponnenyo nan kawadyo, ya siya akhes ken chakayo ay entat-ayaw, makhanak kayo.” ");
INSERT INTO lbk_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kasin nakhosfet, awni ya mawiit, ya nar-os nan ikalma ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Sa et infilin Apo Dios ay mawad-ay isnan lota nan am-in ay ngag sisa'y ilan si enkik-iwi: naamo paymo atap, chadchake ya fanan-ig, et siya nan naangnen. ");
INSERT INTO lbk_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Siya chi ay khinaeb Apo Dios am-in chana, ya nang-ep siya isnan finoyana, tay khawis. ");
INSERT INTO lbk_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Sa et kanan Apo Dios, “Idwani, khomaeb tako is takho ay is-iso tako ya kag ken chatako. Chaicha nan en-apo isnan am-in ay ilan si enfib-iyag is kadchanom, am-in ay entat-ayaw, ya am-in ay ilan si naamo paymo atap, chadchake paymo fanan-ig is kalota.” ");
INSERT INTO lbk_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Siya chi et winad-ay Apo Dios nan takho ay kag ken siya. Winad-ayna chaicha ay lalaki ya fafai. ");
INSERT INTO lbk_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Sa na't binindisyonan chaicha ay mangwanin, “Makhanakhanak kayo et omangsan kayo ta wad-ay entee isnan olay entona issa ay mangiyapo isnan am-in ay wad-ay isnan lofong. Chakayo nan mangiyapo isnan enfib-iyag is kadchanom, nan am-in ay entat-ayaw, ya am-in ay ilan si enkik-iwi isnan lota.” ");
INSERT INTO lbk_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kinwanina kayet, “Chey! Wad-ay et nan am-in ay ilan si mola ay mamkhas ya wad-ay fokerna ya nan kaew ay mamkhas ya wad-ay nan fwana ay inchawchawko ay kanenyo. ");
INSERT INTO lbk_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ngem isnan am-in ay enkik-iwi ya nan am-in ay entat-ayaw et nan enlengleng ay mola ya lokham nan ichowak ay kanencha.” Et siya nan naangnen. ");
INSERT INTO lbk_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Finoyan Apo Dios nan am-in ay khinaebna ya nang-ep, tay mampay chadlos ay khawis. Kasin nakhosfet, awni ya mawiit, ya nar-os nan ikan-em ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Siya chi ya nakwas et ay nakhaeb nan chaya ya nan lofong ya am-iam-in ay wad-ay ischi. ");
INSERT INTO lbk_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Isnan ikapito ay akhew, tay nakwas et am-in nan chinnona, nentengaw si Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Binindisyonana nan ikapito ay akhew ya siya chi nan inpeyna ay nasantowan ay akhew, tay siya chi nan nentengawana issan osto ay nangikwasana isnan am-in ay chonona ay nenpawad-ay. ");
INSERT INTO lbk_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Siya chi nan inangnen nan chaya ya nan lofong ay nawad-ay. Issan cha nangab-an Apo ay Dios isnan lofong ya chaya, ");
INSERT INTO lbk_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","maid cha tomofo ay mola paymo lokham tay maid inpalpal-ina is ochan, ya sa et maid takho is mensama isnan lota. ");
INSERT INTO lbk_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Wad-ay magtek eb-eb ay mananchanom isnan olay entona ay lota. ");
INSERT INTO lbk_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Idwani inmala si Apo ay Dios isnan chapog is kalota ya khinmaeb is lalaki. Sa na't insop-ok nan omipabfiyag ay anges is kaelengna ket ay nenfalin ay takho ay enfibfiyag. ");
INSERT INTO lbk_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Sa et minolaan Apo ay Dios nan esa'y oma id Eden ay apet falaan si akhew, sa na't inpatee ischi nan takho ay khinaebna. ");
INSERT INTO lbk_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Inpatofona ischi nan am-in ay ngag sisa ay ilan si kaew ay kalal-ayad nan ilana ya khawis ay kanen nan fekhasna. Ya wad-ay nan nenkhakhawa ischi ay kaew ay omipabfiyag ya nan kaew ay omichawchaw isnan mangammowan isnan khawis ya ngaag. ");
INSERT INTO lbk_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Wad-ay nan wanga ay nen-ayos ay nalpo id Eden ya mananchanom isnan oma, sa et awni ya nasisyan is epat ay wanga. ");
INSERT INTO lbk_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nan ngachan nan inmona et Pison. Siya na nan wanga ay menliliwes isnan am-in nan ili ay Havila. ");
INSERT INTO lbk_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Mad-anan ischi nan telen ay pasig fallitok sa et nan fangfanglo ay niket ya nan nenkapateg ay fato.) ");
INSERT INTO lbk_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nan ikadwa ay wanga et Gihon nan ngachana. Siya na nan wanga ay menliliwes isnan am-in nan ili ay Cus. ");
INSERT INTO lbk_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nan ngachan nan ikatlo ay wanga et Tigris ay omayos isnan apet falaan si akhew nan ili ay Asiria. Sa et nan ikap-at ay wanga et nan Eufrates. ");
INSERT INTO lbk_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Siya chi ya inalan Apo ay Dios nan lalaki ya inpeyna siya isnan nay ay oma id Eden ta nongnongena ya tokkhongana. ");
INSERT INTO lbk_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Sa na't infilin ken siya ay mangwanin, “Mabfalin ay mangan ka isnan olay ngag sisa'y fekhas si kaew isnan nay oma. ");
INSERT INTO lbk_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ngem kecheng magtek yangkhay nan fekhas nan kaew ay omichawchaw isnan mangammowan isnan khawis ya ngaag nan ad-im kankanen, tay at matey ka ay matey isnan chey kannay ay akhew ay mangakkanam sidi.” ");
INSERT INTO lbk_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Awni ya ket kanan Apo ay Dios, “Ad-i khawis mo aped maeesang nan lalaki. Khomaeb ak is kafachangna ay maifakhay ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Adi kad inmala si Apo ay Dios isnan lota ay khinaebna isnan am-in ay enkik-iwi ya am-in ay entat-ayaw, et inyeyna isnan lalaki ta ilaena mo ngag nan ipangachana. Et mo ngag nan inpangachana isnan am-in ay enkik-iwi siya chi nan ngachancha. ");
INSERT INTO lbk_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Inagtan nan lalaki nan am-in ay entat-ayaw ya nan am-in ay enkik-iwi is ngachancha, naamo ya atap, nay met achi maid paat ischicha nan maifakhay ken siya is kafachangna. ");
INSERT INTO lbk_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Sa et inpaseyep Apo ay Dios nan lalaki, ya osto ay naseyeseyep inalana nan esa'y tadlangna sa na't kasin nen-om-omen nan nangal-ana. ");
INSERT INTO lbk_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Et isnan chey ay tadlang nan nangab-an Apo ay Dios isnan fafai, sa na't intakcho ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ket ay kanan nan lalaki, “Na! Ket ay naay chadlo si is-isok! Tadlangko nan tadlangna ya awakko nan awakna. Fafai nan makwani ken siya tay nalpo isnan lalaki.” ");
INSERT INTO lbk_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Siya chi nan khotokna ay nan lalaki et taynana nan amana ya inana ta maiyamong isnan asaw-ena, et enfalin cha is esang ay awak. ");
INSERT INTO lbk_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","En-iso ay nenlalafos nan lalaki ya nan fafai, ya ad-icha mabfain. ");
INSERT INTO lbk_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Idwani, nan oweg nan kasisikapan isnan am-in ay ngag sisa'y enkik-iwi ay khinaeb Apo ay Dios. Kinwanina isnan fafai, “Ay kinwanin ngen tet-ewa nan Dios ay ad-iyo kankanen nan fekhas si olay ngag sisa ay kaew isnan naay oma?” ");
INSERT INTO lbk_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Songfat et nan fafai ay mangwanin, “Mabfalin ay kanenmi nan fekhas nan olay ngag sisa ay kaew isna, ");
INSERT INTO lbk_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kecheng magtek yangkhay nan kaew ay wad-ay is khawana nan infilina'y ad-imi kankanen paymo khidkhidchowen, tay mo angnenmi et matey kami.” ");
INSERT INTO lbk_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ngem kanan nan oweg, “Ad-i! Ay ke kayo sa matey? ");
INSERT INTO lbk_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kinwanin yangkhay nan Dios sa tay ammona ay mo kanenyo chi, et makaawat kayo, ya enfalin kayo ay kag ken siya ay mangammo isnan khawis ya ngaag,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Osto'y inilan nan fafai ay kalal-ayad ay fob-oyaen nan kaew ya kabfifikhaw nan fekhasna ay kanen, sa et makaawis nan silib ay nakwanin ichowana, ya ket pinmokhas ya kinana. Sa na't inagtan si asawana et nangan akhes. ");
INSERT INTO lbk_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Osto ay kinancha chi ya ket ay nakaawat cha tet-ewa, ya finigfigcha ay ke cha pet enlalafos. Siya et chi ya chinmait cha isnan tofon si kaew ay makwanin igos ay ilofidcha. ");
INSERT INTO lbk_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Isnan sedsechemna ay cha ensoysoysoy, chinngecha't si Apo ay Dios ay cha manad-alan isnan oma. Sa cha't ala ya tafon isnan kakak-aewan, ta ad-icha sakhangen si Apo ay Dios. ");
INSERT INTO lbk_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ngem ket ay ayakhan Apo ay Dios nan lalaki ay mangwanin, “Ento ka pay?” ");
INSERT INTO lbk_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","“Chinngek nan manad-alanam isna's kaoma ya omegyat ak tay ke pet enlalafos ak, sak et intafonan sik-a,” kinwanin nan lalaki. ");
INSERT INTO lbk_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Sa et kanan Apo Dios, “Sino nan mangwanin enlalafos ka? Ay kinanmo ngen nan chey fekhas si kaew ay infilinko ay ad-im kanen?” ");
INSERT INTO lbk_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kanan et nan lalaki, “Nan fafai ay inigwam ay kadwak nan nangichawchaw isnan fekhas nan chey ay kaew ya kek et kinan.” ");
INSERT INTO lbk_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Sa et kinwanin Apo ay Dios isnan fafai, “Em man inangnen chi ay?” Sa na't kanan, “Nan oweg nan nammali ken sak-en ya kinanko.” ");
INSERT INTO lbk_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Idwani kinwanin Apo ay Dios isnan oweg, “Sik-a, khapo tay inangnem chi, nay et selaeg yo ay oweg isnan am-in ay enkik-iwi. Kecheng kayo is omayan nan nay ay chosa. Mailapo idwani, nan potoyo nan ikochongyo, ya chapog nan kag yo cha kankanen engkhana is mateyanyo. ");
INSERT INTO lbk_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Khab-ek nan en-asiligtanyo isnan fafai ya enfinnoso nan wanen-edyo ay chwa. At khimmiken nan wanedna nan olom, ya at ketfam nan pagpakhachana.” ");
INSERT INTO lbk_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ya isnan fafai kinwanina, “Sik-a ay fafai, et paam-amchek nan likhatmo isnan enlitonam ya siya akhes isnan sakit nan omanakam. Olay mo siya sa, siya kayet ay maiilew ka ken asawam, ngem at iyapowana sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Sa na't kinwani akhes isnan lalaki, “Tay si asawam nan chinngem ya kinanmo nan fekhas si kaew ay infilinko ay ad-im kanen, nay et pangaakhek nan lota khapo isnan inangnem. At enfelabfelay ka ay enpawad-ay is ikatakhoyo engkhana's kifos si fiyagyo. ");
INSERT INTO lbk_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Isyangkhay ay sibsifit nan wad-ayen nan lota, ya nan lokham nan kanenyo. ");
INSERT INTO lbk_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Enlingelinget ka ona esa kayo mangan, et sisyasisya sa engkhana'y tomoli ka isnan lota ay nalpowam. Tay chapog nan nakhab-am, at siya akhes nan tomoliyam,” kinwanin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Nginadnan Adan si asawana is Eva, tay siya nan inan nan am-in ay takho. ");
INSERT INTO lbk_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Sa et khinmaeb si Apo ay Dios is fachon cha Adan ay sin-asawa isnan kochil si enkik-iwi, sa na't inpafacho ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Sa et kanan Apo ay Dios, “Chey, nenfalin nan takho ay kag ken chatako ay mangammo isnan khawis ya ngaag. Idwani, masapol ay ad-i maipap-alofos ay omala cha is kanencha isnan fekhas nan kaew ay omipabfiyag, ta sa cha't matakho is eng-engkhana.” ");
INSERT INTO lbk_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tay siya chi inpakaan Apo ay Dios chaicha isnan oma id Eden ta samalencha nan lota ay nakhab-ancha. ");
INSERT INTO lbk_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Inpakaana, sa na't inpey isnan apet falaan si akhew ischi ay oma nan anghel ay manokkhong, ya nan enfidfichang ay fadyok ay enwaswasawas isnan olay entona, ta maid makaeey isnan chey ay kaew ay omipabfiyag. ");
INSERT INTO lbk_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Inseyep Adan si asawana ay Eva ya naliton, et inyanakna nan esa'y lalaki. Sa na't kanan, “Isnan fachang Dios Apo nay nawad-ayan ak is anakko ay lalaki.” Siya chi ke na't ay ngadnan is Cain. ");
INSERT INTO lbk_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Awni ya ket kasin inmanak is annochina ay lalaki ay si Abel. Nenfalin si Abel ay pomapastor ya si Cain, ensamsama. ");
INSERT INTO lbk_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Isnan namingsan, inmala si Cain isnan inapitna ay ichatona ken Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Si akhes Abel, inalana nan kakhawisan ay inaona ay innanak si karnilona sa na't inchaton nan kakhawisan ay karni ken Dios Apo. Nalaychan si Dios Apo ken Abel ya nan inchatona, ");
INSERT INTO lbk_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ngem eg-ay nalaychan ken Cain ya nan inchatona. Siya chi nan sinmongesongetan Cain ya chadlos nenngongoliwet isnan songetna. ");
INSERT INTO lbk_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Sa et kinwanin Dios Apo ken Cain, “En ka man ensosonget ay? Ya ke ka enngongoliwet? ");
INSERT INTO lbk_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mo osto nan angnem, at achi nalagsak nan ilam. Mo ad-i osto nan angnem, nan kinangaag, et kag atap ay enkik-iwi ay mangisasaneb ken sik-a tay laychena ay iyapowan ken sik-a. Ngem masapol ay afakem.” ");
INSERT INTO lbk_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Awni pay ya ket kanan Cain ken annochina ay Abel, “Mamoknag ta.” Ngem osto ay wad-ay cha is kaponchag, alan et Cain ya patey ken annochina. ");
INSERT INTO lbk_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Osto ay siya chi, ket ay kinwanin Dios Apo ken Cain, “Ento pay si Abel ay annochim?” Songfatna't ay nangwanin, “Tew-an! Ay ke chadlos sak-en nan mentotokkhong isnan akhik?” ");
INSERT INTO lbk_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ya ket kanan Dios Apo, “Ngag chi's inangnem! Ilaem achi, kag cha enkechaw ken sak-en is fales nan chalan annochim is kalota. ");
INSERT INTO lbk_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Idwani machosa ka ya nay ad-i ka kasin makasama isnan lota ay nanosop isnan chalan annochim. Siya, kag na tinakang nan topekna ay nanginom isnan chalan annochim ay pinateymo. ");
INSERT INTO lbk_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Olay mo ipapatim ay ensama, ad-i lomweb nan lota. At ad-i ka tomke ay aped entafotafon ya enlikhelikhed isnan lota.” ");
INSERT INTO lbk_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Sa et kanan Cain ken Dios Apo, “Ad-i ak makaikatpe isnan chadlos chad-ama ay chosam ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ilam kay ya! Ipawam nan lota ken sak-en idwani, ya matlad ak ken sik-a. Sak et ad-i paat tomke ya aped ak enlikhelikhed isnan lota, ya mo sino issa nan omila et pomatey cha.” ");
INSERT INTO lbk_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Sa et kanan Dios Apo, “Ad-i. Mo wad-ay mamatey ken sik-a at maminpito ay maifales.” Et pinay-an Dios Apo si Cain is matona ta mo wad-ay manab-at ken siya et ad-i cha pateyen. ");
INSERT INTO lbk_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tinaynan et Cain si Dios Apo ya en nentee isnan apet falaan si akhew nan Eden isnan makwanin Fafadchoyan. ");
INSERT INTO lbk_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Awni ya ket naliton nan inasawan Cain, ya inyanakna nan lalaki ay nginadnancha is Enoc. Sa et khinmaeb si Cain is ilina ay nginadnana isnan ngachan nan anakna. ");
INSERT INTO lbk_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Awni ya ket winad-ay Enoc nan lalaki ay si Irad, ya si Irad winad-ayna si Mehujael ay nenwad-ay ken Metusael ay aman Lamec. ");
INSERT INTO lbk_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Chwa nan asawan Lamec ay cha Ada ken Zilla. ");
INSERT INTO lbk_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Inyanak Ada nan lalaki ay si Jabal ay naiwanchan nan tomatalaken isnan enkik-iwi ya en-ab-afong isnan torcha. ");
INSERT INTO lbk_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Etadna si Jubal ay naiwanchan nan komokotengteng ya nan komakalleleng. ");
INSERT INTO lbk_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Si Zilla, inyanakna si Tubal Cain ay fomebfesa isnan folinsi ya lanchok ya nangaeb isnan am-in ay ilan si laminta. Si Naama nan fafai ay etad Tubal Cain. ");
INSERT INTO lbk_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Idwani ket ay kinwanin Lamec isnan cheycha'y asaswana, “Ada ken Zilla'y asaswak, chengngenyo et nan nay kanak. Nan tinmapak ay fab-alo, ay sinmokhat pinateyko. ");
INSERT INTO lbk_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Mo nan falesna ay omno ikit ay Cain et pito, nan falesko ay os-osto et piton poo ya pito.” ");
INSERT INTO lbk_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Idwani nawad-ayan kasin cha Adan ay sin-asawa is anakcha ay lalaki. Sa et kanan Eva, “Nay inmagtan si Apo Dios is esang ay lalaki ay sokat Abel ay pinatey Cain.” Siya chi ya ket ay nginadnana is Set. ");
INSERT INTO lbk_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Awni ya ket winad-ay Set nan esa'y lalaki ay nginadnana is Enos. Siya chi nan lapon nan nanad-ayawan nan takho ken Dios Apo ay mangayag ken siya isnan ngachana. ");
INSERT INTO lbk_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Siya chana nan naisolat ay katontonan nan wanen-ed Adan. (Issan nenwad-ayan Apo Dios isnan takho, khinaebna chaicha ay kag ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Winad-ayna chaicha ay lalaki ya fafai. Binindisyonana chaicha ya nginadnana chaicha is takho.) ");
INSERT INTO lbk_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Osto ay nentawen si Adan is sinkhasot ya tolon poo, winad-ayna nan lalaki ay kag paat ken siya ya nginadnana is Set. ");
INSERT INTO lbk_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sa et natakhotakho kayet is walon khasot ay tawen, ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna ay lallalaki ya fabfafai. ");
INSERT INTO lbk_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Siyam khasot ya tolon poo nan tawen Adan issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Osto ay nentawen si Set is sinkhasot ya lima, winad-ayna nan lalaki ay si Enos. ");
INSERT INTO lbk_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sa et natakhotakho kayet is walon khasot ya pito ay tawen, ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Siyam khasot ya sinpoo ya chwa nan tawen Set issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Osto ay nentawen si Enos is siyam poo, winad-ayna nan lalaki ay si Kenan. ");
INSERT INTO lbk_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Sa et natakhotakho kayet is walon khasot ya sinpoo ya lima ay tawen, ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Siyam khasot ya lima nan tawen Enos issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Osto ay nentawen si Kenan is piton poo, winad-ayna nan lalaki ay si Mahalalel. ");
INSERT INTO lbk_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Sa et natakhotakho kayet is walon khasot ya epat poo ay tawen, ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Siyam khasot ya sinpoo nan tawen Kenan issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Osto ay nentawen si Mahalalel is enem poo ya lima, winad-ayna nan lalaki ay si Jared. ");
INSERT INTO lbk_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Sa et natakhotakho kayet is walon khasot ya tolon poo ay tawen, ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Walon khasot ya siyam poo ya lima nan tawen Mahalalel issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Osto ay nentawen si Jared is sinkhasot ya enem poo ya chwa, winad-ayna nan lalaki ay si Enoc. ");
INSERT INTO lbk_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Sa et natakhotakho kayet is walon khasot ay tawen, ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Siyam khasot ya enem poo ya chwa nan tawen Jared issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Osto ay nentawen si Enoc is enem poo ya lima, winad-ayna nan lalaki ay si Matusalem. ");
INSERT INTO lbk_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Sa et natakhotakho ya kad-in naiyoornos ken Apo Dios is tolon khasot ay tawen, ya wad-ay nan tapina kayet ay cha na winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Tolon khasot ya enem poo ya lima ay tawen nan natatakhowan Enoc. ");
INSERT INTO lbk_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Natakhotakho siya ay naiyoornos ken Apo Dios ya ket awni ya namaid tay inayakhan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Osto ay nentawen si Matusalem is sinkhasot ya walon poo ya pito, winad-ayna nan lalaki ay si Lamec. ");
INSERT INTO lbk_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Sa et natakhotakho kayet is piton khasot ya walon poo ya chwa ay tawen, ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Siyam khasot ya enem poo ya siyam nan tawen Matusalem issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Osto ay nentawen si Lamec is sinkhasot ya walon poo ya chwa, winad-ayna nan lalaki ");
INSERT INTO lbk_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ay nginadnana is Noe. Sa na't kanan, “At si tona nan mangipayap-ew isnan felay ya chadlos chad-ama ay likhat si chono migkhapo isnan lota ay inpangaag Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Sa et natakhotakho kayet si Lamec is liman khasot ya siyam poo ya lima ay tawen, ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Piton khasot ya piton poo ya pito nan tawena issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nentawen si Noe is liman khasot, sa na winad-ay nan tolo ay lallalaki ay cha Sem, Ham ya si Jafet. ");
INSERT INTO lbk_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Isnan inmangsaangsanan nan takho ya naiwalasancha isnan olay entona isnan lofong, angsan nan cha naiyanak ay fabfafai. ");
INSERT INTO lbk_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ya ket wad-ay cha nan nalpo id chaya ay nangila ay kalal-ayad nan fabfafain si fakinlolota, sa cha't nenpili is inasawacha. ");
INSERT INTO lbk_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Osto ay siya chi kinwanin et Dios Apo, “Ad-ik ipalofos ay sa matakho is engkhana nan takho, tay takho cha yangkhay et matey cha ay matey. At ad-i enlafes is sinkhasot ya chwan poo nan tawencha.” ");
INSERT INTO lbk_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Issan chey ay timpo ya olay isnan cha kayet naitoptop ay tawen ay cha nar-os, wad-ay cha nan at-atakchag ay takho ay an-ak nan fabfafain si fakinlolota isnan nalpo id chaya. Chaicha nan kafibfikasan ya machamchamag ay takho id sangad-om. ");
INSERT INTO lbk_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Isnan nangil-an Dios Apo ay maid paat khawis ay takho isnan lota ya ngaag yangkhay nan semsemken ya pangkhepcha, ");
INSERT INTO lbk_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","chadlos ay ensakit nan semekna ya nenfafawi ay nangaeb ya nangipatee ken chaicha isnan lota. ");
INSERT INTO lbk_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Sa na't kanan, “Amasek nan takho ay winad-ayko ta mamaid cha isnan lota, ya itapik nan enkik-iwi ya entat-ayaw, tay enfafawi ak ay nangaeb ken chaicha.” ");
INSERT INTO lbk_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kecheng magtek yangkhay si Noe is nalaychan Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Idwani siya na nan kaokhochan Noe. Tolo nan an-ak Noe ay cha Sem, Ham ya si Jafet. Siya nan takho ay nalenteg ya maid naknakwaniyana issan timpona, ya kad-in naiyornos ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ngem am-in nan tapina ay takho et ngaag cha isnan sakhang Apo Dios ya kholo yangkhay nan kwacha isnan olay entona ay kawadcha. ");
INSERT INTO lbk_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Inoschongan Apo Dios nan lota ya chey, nafang-es nan semek nan am-in ay takho, tay chad-ama ay ngaag ay ik-ikkancha. ");
INSERT INTO lbk_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Sa et kanan Apo Dios ken Noe, “Sinmekko ay amasen ay amasen nan am-in ay takho, tay kholo yangkhay nan wad-ay ken chaicha isnan olay entona ay kawadcha. Nay et pakawasek tet-ewa chaicha ya nan am-in ay wad-ay isnan lota. ");
INSERT INTO lbk_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Khomaeb ka is chakchakowag ay fangka isnan khawis ya pasig saeng. Kwartokwartowem ya ispartowam isnan chaem ya falana. ");
INSERT INTO lbk_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Siya na nan angnem ay mangaeb: Khab-em is sinkhasot ya tolon poo ya tolo ay mitro nan kaanchona, ya chwan poo ya chwa ay mitro nan kalawana, sa et sinpoo ya tolo ay mitro nan katakchagna. ");
INSERT INTO lbk_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atepam ya khab-em is khedwan si esa'y mitro nan enfet-akan nan chingching isnan atepna. Khomaeb ka is eneb is kasikigna ya khomaeb ka is ikadwa ya ikatlo ay grado. ");
INSERT INTO lbk_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Siya chi nan angnem tay chey, at posngek nan lota ta mapakawas nan am-in ay matatakho. At matey am-iam-in nan olay ngag sisa ay matatakho isnan lota. ");
INSERT INTO lbk_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ngem siya na nan kanak ay entolakhanta: Somkhep kayo is kafangka, sik-a, si asawam, nan an-akmo ya iinnapom. ");
INSERT INTO lbk_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Omiskhep kayo akhes is sin-as-asaswa isnan am-in ay ilan si enkik-iwi, manad-alan, enkadkachap paymo enkodkochong, ya am-in ay ilan si entat-ayaw, ta matakho cha. ");
INSERT INTO lbk_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","En-ipenpen kayo akhes is kafangka si isyangkhay sisa ay makakan ya nan kanen nan enkik-iwi.” ");
INSERT INTO lbk_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Et siya chi ya inangnen Noe am-in nan infilin Apo Dios ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Idwani, kinwanin Dios Apo ken Noe, “Itapim nan am-in ay pangafongmo ay somkhep is kafangka, tay inilak ay kecheng ka is nalenteg isnan am-in ay takho idwani. ");
INSERT INTO lbk_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Omiskhep ka is sinpipto ay sin-as-asaswa isnan am-in ay ilan si masibfan ay enkik-iwi, ngem sin-es-a'y sin-as-asaswa isnan ilan si enkik-iwi ay maipawa ay masibfan. ");
INSERT INTO lbk_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Omiskhep ka akhes is sinpipto ay sin-as-asaswa isnan am-in ay ilan si ay-ayam. Siya sa nan angnem ta am-in ay ilan si enkik-iwi et matakho cha ay kasin makhanak isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tay pito ay akhew mailapo idwani ya at paodchanek is epat poo ay akhew ya maschem, ta amasek isnan lota nan am-in ay matatakho ay khinaebko.” ");
INSERT INTO lbk_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Inangnen Noe am-in nan infilin Dios Apo ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Enem khasot nan tawen Noe isnan nalifokhan nan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Idwani sinomkhep et cha Noe ay sin-asawa, nan an-ak ya iinnapocha is kafangka ta maikasiw cha isnan lifog. ");
INSERT INTO lbk_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Am-in ay ilan si sin-as-asaswa ay enkik-iwi ya entat-ayaw, masibfan paymo maipawa ay masibfan, et ");
INSERT INTO lbk_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","nakiskhep cha am-in ay sinchodwachodwa ken Noe ay maiyafoloy isnan infilin Apo Dios ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Nakwas pay nan pito ay akhew ya ket ay malifog nan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Osto ay enem khasot nan tawen Noe, isnan ikasinpoo ya pito ay akhew isnan maikadwa ay fowan, ket ay inmasyak nan am-in ay eb-eb isnan chaem nan lota, sa et kag wad-ay naikhowang ay kaaneanewang id chaya. ");
INSERT INTO lbk_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Et nen-ochaochan is epat poo ay akhew ya maschem. ");
INSERT INTO lbk_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Siya kannay chi ay akhew nan sinomkhepan cha Noe ya nan lallalaki ay an-akna ay cha Sem, Ham ya si Jafet, nan asawana ya nan tolo ay iinnapocha is kafangka. ");
INSERT INTO lbk_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ya nakiskhep ken chaicha nan am-in ay ilan si enkik-iwi, nan amo ya atap, chadchake ya fanan-ig, manad-alan, enkadkachap ya enkodkochong, ya nan am-in ay ilan si entat-ayaw. ");
INSERT INTO lbk_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Sin-as-asaswa isnan am-in ay ila ay wad-ay fiyagna nan nakiskhep is kafangka ken Noe ");
INSERT INTO lbk_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","maiyafoloy isnan infilin Apo Dios. Et wad-ay cha am-in ay ilan si matatakho, laki ya fai, sa et intangeb Dios Apo nan fangka. ");
INSERT INTO lbk_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Cha et fomikas nan lifog isnan lofong isnan las-od si epat poo ay akhew. Chadlos inmad-achaem nan chanom engkhana ay cha et tomongcho ya tomafog nan fangka. ");
INSERT INTO lbk_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Cha kayet omad-achaem nan chanom engkhana'y manalan nan fangka is kadchanom. ");
INSERT INTO lbk_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Inmad-achaem kayet nan chanom ya linin-ebna nan am-in ay kaat-atakchakhan ay filig. ");
INSERT INTO lbk_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Sa et tinmongchotongcho kayet engkhana'y pito ay mitro nan kachaemna isnan katoktok nan filig. ");
INSERT INTO lbk_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Et natey am-in nan matatakho isnan lofong: nan am-in ay entat-ayaw, enkik-iwi ya takho. ");
INSERT INTO lbk_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Siya, am-in ay enfibfiyag isnan lota et natey cha. ");
INSERT INTO lbk_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Inamas Apo Dios nan am-in ay matatakho isnan lota: nan takho, nan enkik-iwi ya nan entat-ayaw. Kecheng cha Noe ay sinpangafong ya nan wad-ay ken siya is kafangka nan natakho. ");
INSERT INTO lbk_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Sinkhasot ya liman poo ay akhew ya sisya kayet nan lifog. ");
INSERT INTO lbk_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Eg-ay magtek nalichongan Apo Dios si Noe ya nan am-in ay enkik-iwi ay nakitee ken siya is kafangka. Ke na't ay inpal-i nan chakhem ya cha khomwab nan chanom. ");
INSERT INTO lbk_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Apchas na pintot nan am-in ay fomab-ala ay chanom isnan lota ya id tongcho, ya tinomke nan ochan. ");
INSERT INTO lbk_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Sa et inlonloney nan chanom ay khomwab. Isnan osto ay sinkhasot ya liman poo ay akhew, cha kayet khomwab nan chanom ");
INSERT INTO lbk_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","engkhana ay inompa nan fangka isnan filig id Ararat isnan ikasinpoo ya pito ay akhew isnan ikapito ay fowan. ");
INSERT INTO lbk_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Intot-oloy nan chanom ay cha khomwab, ya isnan omona ay akhew isnan maikapoo'y fowan ket ay maila nan toktok nan kafilifilig. ");
INSERT INTO lbk_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Osto ay nakwas nan epat poo ay akhew kayet, tinekwafan Noe nan fintana ay khinaebna isnan fangka. ");
INSERT INTO lbk_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Sa na't inpatayaw nan khayang, ngem aped yangkhay nentayatayaw ay nen-atoaton engkhana ay nakwas nan lifog. ");
INSERT INTO lbk_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Awni ya ket patayawen Noe nan kalopati ta mangammowana mo natchok nan chanom isnan lota. ");
INSERT INTO lbk_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ngem maid inchanan nan kalopati is ompaana, tay sisya ay malilifog kayet am-in nan lota. Sa et tinmoli is kafangka. Inchawawan Noe nan limana et pinmatong nan kalopati sa na't iniskhep. ");
INSERT INTO lbk_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nensaed kayet si Noe is pito ay akhew, sa na't pafalaen kasin nan kalopati. ");
INSERT INTO lbk_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Osto ay tinmoli isnan sedsechemna, ket ay sinisipitna isnan topkayna nan enlengleng ay tofon si kaew ay olibo. Siya chi nan nangammowana ay natchok et nan chanom. ");
INSERT INTO lbk_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Sin-edna kasin nan pito ay akhew, sa na't inpatayaw kasin san kalopati, ngem eg-ay et tinmot-oli. ");
INSERT INTO lbk_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Osto ay nentawen si Noe is enem khasot ya esa, isnan omona ay akhew isnan omona ay fowan, nakwanakwas nan lifog. Sa na't kinaan nan atep nan fangka, nenmonaang, ya inilana ay cha maschok nan chanom isnan lota. ");
INSERT INTO lbk_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Isnan maikachwan poo ya pito ay akhew isnan maikadwa ay fowan, ket ay naschok ay osto nan chanom isnan lota. ");
INSERT INTO lbk_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Sa et kanan Apo Dios ken Noe, ");
INSERT INTO lbk_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Fomala kayo am-in is kafangka, chakayo ay sin-asawa, ya nan an-akyo ya nan iinnapoyo, am-in kayo ay sinpangafong. ");
INSERT INTO lbk_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pabfalaenyo akhes nan am-iam-in ay enkik-iwi, manad-alan, enkadkachap, enkodkochong ya entat-ayaw, ta kasin cha makhanakhanak ya omangsaangsan isnan lofong,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Et finmala cha Noe ay sin-asawa, nan an-akcha ya iinnapocha, am-in cha ay sinpangafong. ");
INSERT INTO lbk_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ya nasonson ay finmala akhes nan waschin sinpamoweg ay ilan si enkik-iwi, manad-alan, enkadkachap, enkodkochong ya entat-ayaw, ay nalpo is kafangka. ");
INSERT INTO lbk_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Sa et nentoping si Noe is altar ay enchad-ayawan ken Dios Apo. Ya inmala is sin-es-ang isnan masibfan ay enkik-iwi ya ay-ayam, sa na't pinoowan ay mafobfoker is kaaltar engkhana ay chomapo ay nangichoo ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nalaychalaychan si Dios Apo isnan sinongsongna ay seng-ew nan inchaton Noe. Sa na't kanan isnan semekna, “Idwani, ad-ik kasin pangaakhen nan lota khapo isnan angnen nan takho. Ammok ay mailapo is kaongacha et ngaag am-in nan semekcha. Olay siya chi ad-ik kasin pakpakawasen nan am-in ay matatakho ay kag isnan inangnek idwani. ");
INSERT INTO lbk_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mo sisya kayet nan lofong, mabfalin nan enmola ya en-ani, wad-ay nan atong ya lateng, chinamey, chakhon, ya kesep, akhew ya maschem, et ad-i tomtomke,” kanan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Binindisyonan Apo Dios si Noe ya nan an-akna ay lallalaki ya kinwanina, “Makhanakhanak kayo ta omangsan kayo ya entee kayo isnan olay entona issa isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Am-in ay ilan si enkik-iwi, manad-alan, enkadkachap, enkodkochong, entat-ayaw ya enkik-iyat, et chadlos cha omegyat ken chakayo. Inchowak am-in chana ay iyapowanyo. ");
INSERT INTO lbk_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Sikhod ay inchowak nan enlengleng ay mola ay kanenyo, idwani mabfalin akhes nan am-in ay enkik-iwi ay sibfanyo. ");
INSERT INTO lbk_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ngem esang magtek yangkhay nan masapol ay ad-iyo kanen. Siya chi nan karni ay sisya'y enchachala. Maipawa chi tay nan chala et siya nan fiyag. ");
INSERT INTO lbk_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mo wad-ay mangala isnan fiyag si takho, et fiyagna akhes kannay nan somongfat ken sak-en. Am-in ay enkik-iwi ay mamatey isnan takho, et maala. Siya akhes isnan takho ay mamatey isnan ib-ana. ");
INSERT INTO lbk_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tay nan takho et nakhaeb cha ay kag ken sak-en ay Dios, nay et mo sino nan enpatey, siya akhes ay mapatey isnan ib-ana ay takho. ");
INSERT INTO lbk_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Chakayo, masapol ay makhanakhanak kayo ya omangsan kayo ta wad-ay entee isnan olay entona isnan lofong.” ");
INSERT INTO lbk_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Sa et kinwanin Apo Dios ken Noe ya nan an-akna ay lallalaki, ");
INSERT INTO lbk_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Chey, en-ikali ak ken chakayo ya nan wanen-edyo, ");
INSERT INTO lbk_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ya isnan am-in ay matatakho, am-in ay entat-ayaw ya am-in ay enkik-iwi, am-iam-in ay nakifala ken chakayo is kafangka. ");
INSERT INTO lbk_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ikkalik ay at mam-aid kasin maamasan nan am-in ay matatakho khapo isnan lifog. Siya, mam-aid kasin omali ay lifog ay mamakawas isnan lofong.” ");
INSERT INTO lbk_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Sa na't kanan, “Siya na nan maton ay kail-il-an nan maid pengpengna ay inkalik ken chakayo ya isnan am-in ay matatakho ay wad-ay ken chakayo, ya isnan am-in akhes ay matatakho ay cha kayet mawad-ay. ");
INSERT INTO lbk_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ippeyko nan fongakhanko is kalifoo. Siya chi nan maton nan inkalik isnan am-in ay wad-ay isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Et mo ap-apak nan chaya isnan lifoo ya sa et wad-ay nan maila ay fongakhan, ");
INSERT INTO lbk_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","sesemkek nan inkalik ken chakayo ya nan am-iam-in ay matatakho, ya at ad-i kasin maliblifog nan chanom ay mamakawas isnan am-in ay matatakho. ");
INSERT INTO lbk_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mo wad-ay nan fongakhan is kalifoo et ilaek ya sesemkek nan maid pengpengna ay inkalik isnan am-iam-in ay matatakho ay wad-ay is kalofong.” ");
INSERT INTO lbk_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Sa na't kanan ken Noe, “Siya chi nan maton nan inkalik isnan am-iam-in ay matatakho isnan lofong.” ");
INSERT INTO lbk_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Siya chana nan an-ak Noe ay lallalaki ay finmala is kafangka: cha Sem, Ham ya si Jafet. (Si Ham nan aman Canaan.) ");
INSERT INTO lbk_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nan naycha ay tolo ay an-ak Noe nan ikik-it nan am-in ay takho. ");
INSERT INTO lbk_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Esa'y ensamsama si Noe, ya siya nan nang-ona ay takho ay nen-imola isnan makwanin ofas. ");
INSERT INTO lbk_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Awni ya ket ay nafoteng siya isnan nanginomana isnan fayas si ofasna, sa et nenlalafos ya naseyep is kaafongna ay torcha. ");
INSERT INTO lbk_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Isnan nangil-an Ham ay aman Canaan nan nenlalafosan amana, et aped na yangkhay infakha isnan cheycha'y chwa ay et-adna is chela. ");
INSERT INTO lbk_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sa et inmala cha Sem ken Jafet is kakhay sa cha't ineegnan ay pinadchokog is kapokecha, sa cha't nenchodchokog kayet ay sinomkhep ay en nangap-ap ken amacha, ya egay cha nensagsakhong ken amacha ta ad-icha ilaen nan enlalafos ay awakna. ");
INSERT INTO lbk_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Isnan naimonawan Noe ya inammowana nan inangnen nan alilis ay anakna ay si Ham ken siya, ");
INSERT INTO lbk_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","kinwanina, “Selaeg Canaan isnan inangnena! At enfalin siya ay mid filangna ay faan nan aag-ina.” ");
INSERT INTO lbk_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kinwanina kayet, “Machad-ayaw si Dios Apo ay Dios Sem! At sa enfaan Sem si Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Paanwaen Apo Dios nan sakop nan kwan nan waned Jafet, ya makitee cha isnan wanen-ed Sem! At sa enfaan Jafet si Canaan.” ");
INSERT INTO lbk_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kakwasan nan lifog, natakhotakho kayet si Noe is tolon khasot ya liman poo ay tawen, ");
INSERT INTO lbk_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ya siyam khasot ya liman poo nan tawena issan nateyana. ");
INSERT INTO lbk_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Siya chana nan katontonan nan wanen-ed nan lallalaki ay an-ak Noe ay cha Sem, Ham ya si Jafet. Kakwasan nan lifog winad-aycha nan an-akcha ay lallalaki. ");
INSERT INTO lbk_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Naaycha nan lallalaki ay an-ak Jafet: cha Gomer, Magog, Madai, Javan, Tubal, Mesec ya Tiras. Chaicha nan ikik-it nan cheycha'y nangingachan isnan ngadngachancha. ");
INSERT INTO lbk_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Nan wanen-ed Gomer et chaicha nan takho id Askenaz, Rifat ya Togarma. ");
INSERT INTO lbk_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Nan wanen-ed Javan et chaicha nan takho id Elisa, Tarsis, Cyprus ya Rodes. ");
INSERT INTO lbk_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Chaicha nan ikik-it nan cheycha'y entetee isnan kailit nan fayfay. Adi kad siya am-in chachi nan wanen-ed Jafet ay wad-ay nan waschin cha pangafong, tribo, ya kali, ya naiwalas cha ay nentee isnan teketeken ay lota. ");
INSERT INTO lbk_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Idwani, naaycha akhes nan lallalaki ay an-ak Ham: cha Cus, Egipto, Put ya Canaan. Siya chana akhes nan ikik-it nan cheycha'y nangingachan isnan ngadngachancha. ");
INSERT INTO lbk_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Nan wanen-ed Cus et chaicha nan takho id Seba, Havila, Sabta, Raama ya Sabteca. Nan wanen-ed Raama et chaicha nan takho id Seba ya Dedan. ");
INSERT INTO lbk_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Wad-ay nan anak Cus ay lalaki ay nenngachan si Nimrod. Siya nan kaoonaan ay kafibfikasan ay takho isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nenfalin siya ay nalaing ay omaanop khapo isnan fachang Dios Apo. Siya nan khotok nan mangmangwaniyan nan takho, “Khab-en koma Dios Apo sik-a ay nalaing ay omaanop ay kag ken Nimrod!” ");
INSERT INTO lbk_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nan inmona ay nen-ap-apowana et nan ili ay Babel, Erek ya Akkad. Siya chana nan sakop nan ili ay Babilonia. ");
INSERT INTO lbk_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nalpo siya ischi sa et nenpaAsiria ay nangab-ana isnan ili ay Nineve, Rehobot-ir, Cala ");
INSERT INTO lbk_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ya Resen, ay wad-ay isnan nenfet-akan nan Nineve ya nan wadwad-ay ay ili ay Cala. ");
INSERT INTO lbk_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Nan akhes wanen-ed Egipto et chaicha nan takho id Lydia, Anam, Lehab, Naftu, ");
INSERT INTO lbk_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patros, Caslu ya Caftor ay nalpowan nan Filisteo. ");
INSERT INTO lbk_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Nan an-ak Canaan ay lallalaki et si Sidon ay inaona ya si Het. Siya chana nan ikik-it nan cheycha'y nangingachan isnan ngadngachancha. ");
INSERT INTO lbk_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Si Canaan kayet nan ikit nan cheycha'y makwanin Jebuseo, Amorreo, Gergeseo, ");
INSERT INTO lbk_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Heveo, Arkeo, Sineo, ");
INSERT INTO lbk_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadeo, Zemareo ya nan cheycha'y Hamateo. Siya chana nan natkenatken ay tribo ay nalpo ken Canaan ay awni ya naiwalas ");
INSERT INTO lbk_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","engkhana ay nan fedcheng nan ilicha et mailapo id Sidon ay wad-ay isnan amyanan engkhana id Gerar ay sag-en nan Gaza ay wad-ay isnan ambagatan, sa et isnan apet falaan si akhew ay maitapi nan Sodoma, Gomorra, Adma ya Zeboiim, engkhana isnan maisasag-en ay ili ay Lasa. ");
INSERT INTO lbk_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Siya am-in chachi nan wanen-ed Ham, ay wad-ay nan waschin cha pangafong, tribo ya kali, ya naiwalas cha ay nentee isnan teketeken ay lota. ");
INSERT INTO lbk_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Si akhes Sem ay yon-an Jafet et siya nan ikit nan am-in ay Hebreo. ");
INSERT INTO lbk_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Naaycha nan lallalaki ay an-ak Sem: Elam, Assur, Arpaksad, Lud ya Aram. Siya chana nan ikik-it nan cheycha'y nangingachan isnan ngadngachancha. ");
INSERT INTO lbk_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Nan wanen-ed Aram et chaicha nan takho id Uz, Hul, Geter, ya Mesek. ");
INSERT INTO lbk_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Si Arpaksad nan aman Sela, ya nan anak Sela et si Eber. ");
INSERT INTO lbk_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Chwa cha nan an-ak Eber. Esang nan nangachanan is Peleg mo ke tay nasisyasisyan cha nan takho issan timpona. Nan naipangachan isnan akhina et Joktan. ");
INSERT INTO lbk_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Nan wanen-ed Joktan et chaicha nan takho id Almodad, Selef, Hasarmavet, Jera, ");
INSERT INTO lbk_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO lbk_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO lbk_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, ya Jobab. Nalpo am-in chana ken Joktan. ");
INSERT INTO lbk_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Nan ilicha et sakopena id Mesa engkhana id Sefar ay wad-ay isnan nafib-ilikhana ay apet falaan si akhew. ");
INSERT INTO lbk_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Siya am-in chana nan wanen-ed Sem, ay wad-ay nan waschin cha pangafong, tribo ya kali, ya naiwalas cha ay nentee isnan teketeken ay lota. ");
INSERT INTO lbk_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Siya am-in chana nan katontonan nan wanen-ed Noe ay nenfalin ay kailiili. Am-in ay takho ay nawad-ay ya naiwalas isnan lofong kakwasan nan lifog et naiwaned cha am-in isnan an-ak Noe. ");
INSERT INTO lbk_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Issan lapona, es-esang nan kalin nan am-in ay takho isnan lofong, et mismis-o nan kalicha. ");
INSERT INTO lbk_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Isnan cha khomeg-echan nan takho is apet falaan si akhew, ket ay inomchan cha isnan cheta id Babilonia ya inmili cha ischi. ");
INSERT INTO lbk_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Awni pay ke cha't natotya ay mangwanin, “Ali kayo! Khomaeb tako is madchalilyo ay poowan tako ay osto.” Siya na nan kanancha ay itopingcha sa cha't ispartowan am-in nan nenfetfet-akancha. ");
INSERT INTO lbk_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kinwanicha't, “Aye! Tomoping tako is ili ya nan tori ay at-atakchag ay omchan engkhana id chaya, ta machamchamag nan ngachan tako ya at ad-i tako masisyan isnan olay entona isnan lota.” ");
INSERT INTO lbk_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Osto'y siya chi ket ay pinmanad si Dios Apo ay nangila isnan ili ya nan tori ay tinoping si takho. ");
INSERT INTO lbk_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Sa na't kanan, “Chey, esang chana ay takho ya esang nan kalicha, ya laplapona yangkhay na isnan semsemkencha'y angnen. Awni't makaangnen cha isnan isyangkhay sisa ay laychencha. ");
INSERT INTO lbk_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Khomwab tako et ta tekneteknen tako nan kalicha ta ad-i cha enkasiawatan.” ");
INSERT INTO lbk_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Et siya chi ay sinisyasisyan Dios Apo chaicha ay nangiwalas ken chaicha isnan olay entona issa isnan lofong. Ya egay et natoloy san toptopingencha ay ili. ");
INSERT INTO lbk_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nangadnan nan chey ay ili is Babel mo ke tay ischi nan naneknateknan Dios Apo isnan kalin nan am-in ay takho, ya nailapo ischi nan nangsisyanana ay nangiwalasana ken chaicha isnan olay entona issa isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Naay nan katontonan nan wanen-ed Sem. Nar-os nan chwa ay tawen kakwasan nan lifog et sinkhasot nan tawen Sem ya winad-ayna nan anakna ay lalaki ay si Arpaksad. ");
INSERT INTO lbk_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sa et natakhotakho kayet is liman khasot ay tawen ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Osto ay nentawen si Arpaksad is tolon poo ya lima, winad-ayna nan anakna ay lalaki ay si Sela. ");
INSERT INTO lbk_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sa et natakhotakho kayet is epat khasot ya tolo ay tawen ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Osto ay nentawen si Sela is tolon poo, winad-ayna nan anakna ay lalaki ay si Eber. ");
INSERT INTO lbk_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sa et natakhotakho kayet is epat khasot ya tolo ay tawen ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Osto ay nentawen si Eber is tolon poo ya epat, winad-ayna nan anakna ay lalaki ay si Peleg. ");
INSERT INTO lbk_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Sa et natakhotakho kayet is epat khasot ya tolon poo ay tawen ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Osto ay nentawen si Peleg is tolon poo, winad-ayna nan anakna ay lalaki ay si Reu. ");
INSERT INTO lbk_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Sa et natakhotakho kayet is chowan khasot ya siyam ay tawen ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Osto ay nentawen si Reu is tolon poo ya chwa, winad-ayna nan anakna ay lalaki ay si Serug. ");
INSERT INTO lbk_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Sa et natakhotakho kayet is chwan khasot ya pito ay tawen ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Osto ay nentawen si Serug is tolon poo, winad-ayna nan anakna ay lalaki ay si Nahor. ");
INSERT INTO lbk_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sa et natakhotakho kayet is chwan khasot ay tawen ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Osto ay nentawen si Nahor is chwan poo ya siyam, winad-ayna nan anakna ay lalaki ay si Tera. ");
INSERT INTO lbk_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Sa et natakhotakho kayet is sinkhasot ya sinpoo ya siyam ay tawen ya wad-ay nan tapina ay cha na kayet winad-ay ay an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Nentawen si Tera is piton poo, esa na wad-ayen cha Abram, Nahor ya si Haran. ");
INSERT INTO lbk_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Naaycha nan wanen-ed Tera ay aman cha Abram, Nahor ya si Haran. Si Haran nan aman Lot. ");
INSERT INTO lbk_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Natey si Haran ischi id Ur id Babilonia ay naiyanakana isnan sisya'y matatakhowan amana. ");
INSERT INTO lbk_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Inmasawa cha Abram ken Nahor. Nan ngachan nan asawan Abram et Sarai, ya nan ngachan nan asawan Nahor et Milca ay anak Haran ay aman akhes Isca. ");
INSERT INTO lbk_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Maid anak Sarai tay nakot-eg. ");
INSERT INTO lbk_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Idwani, inayakhan Tera nan anakna ay si Abram, ya si Lot ay apona ay anak Haran, ya nan innapona ay si Sarai ay asawan Abram, sa cha't tinaynan ischi id Ur id Babilonia ta omey cha isnan ili ay Canaan. Ngem issan inomchanancha id Haran ket ay ischi nan nentey-ancha. ");
INSERT INTO lbk_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ischi nan nateyan Tera issan osto ay nentawen is chwan khasot ya lima. ");
INSERT INTO lbk_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Idwani, kinwanin et Dios Apo ken Abram, “Taynam nan ilim, nan aag-im, ya nan papangafong amam ta omey ka isnan ili ay itchok ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","At agtak sik-a is angsaangsan ay wanen-edmo ya at enfalin cha is chakchakowag ay ili. Bindisyonak sik-a ya et madngemadnge nan ngachanmo isnan olay entona, ta mabindisyonan nan tapina maichalan ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bindisyonak nan cheycha'y mamindisyon ken sik-a ya chosaek nan cheycha'y mangamsiw ken sik-a. Ya am-in ay takho isnan lofong et mabindisyonan cha maichalan ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Adi kad tinaynan Abram nan ilina ay Haran tay siya nan infilin Dios Apo, et naifoweg nan kaanakana ay si Lot ken siya. Piton poo ya lima nan tawen Abram issan kinmaanana ischi. ");
INSERT INTO lbk_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Intakin Abram si asawana ay Sarai ya si Lot, ya nan am-in ay kwacha ya faacha ay cha cha inamong id Haran, ya nenchawes cha ay omey id Canaan. Awni ya ket inomchan cha isnan ili ay Canaan, ");
INSERT INTO lbk_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","sa cha't nenfab-aat engkhana ay inomchan cha isnan kag alimmos ay kaew More id Sikem. Issan chey ay timpo, sisya ay omiili cha nan Cananeo ischi. ");
INSERT INTO lbk_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Idwani, nenpaila si Dios Apo ken Abram ya kinwanina, “Siya na nan lota ay ichowak isnan cheycha'y wanen-edmo.” Adi kad tinmoping si Abram is altar ay nenchatonana ken Dios Apo ay nenpaila ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Awni ya nen-aton ya nentee isnan filig ay nenfet-akan nan Betel ya Ai. Betel nan ili ay wad-ay is apet kalonokhan si akhew ya Ai nan wad-ay is apet falaan si akhew. Et ischi nan nangipatakchekhana isnan torchana ya nan nentopingana isnan altar ay nenchatonana ya nenchayawana ken Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Sa cha't nen-atoaton ay omey isnan ponchag id Canaan ay apetna id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Awni ya ket ay wad-ay nan chad-ama ay fitil id Canaan. Tay siya chi nen-eseg cha Abram id Egipto ta kanatee cha ischi. ");
INSERT INTO lbk_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Isnan nganngani ay omchanancha id Egipto, kinwanin Abram ken asawana'y Sarai, “Sik-a nan esang ay khag-awis nan ilana ay fafai. ");
INSERT INTO lbk_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mo ilan nan iyEgipto sik-a, at kananchan, ‘Naay nan asawana,’ ya awnin et pomatey cha, ngem at takhowencha sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kanam et yangkhay ay sin-akhi ta, tatno khawis nan ipailacha ken sak-en, sa cha't ad-i pomatey chomalat ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Awni pay, isnan inomchanancha id Egipto, inilan tet-ewa nan iyEgipto ay khag-awis nan ilan asawan Abram. ");
INSERT INTO lbk_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Osto ay inilan nan takhon nan ali si Sarai, inpaammocha nan ilana isnan ali et inpaayagna siya is kapalasyona. ");
INSERT INTO lbk_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Khawis nan inpailan nan ali ken Abram khapo ken Sarai, ya inmangsaangsan nan karnilo, faka, dangki, kamelio ya faana. ");
INSERT INTO lbk_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Idwani tay inalan san ali si Sarai, chinosan Dios Apo siya ya nan pangafongna isnan cheycha'y chad-ama ay sakit. ");
INSERT INTO lbk_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Sa et inpaayag nan ali si Abram sa na't sinosonget ay mangwanin, “Ngag man na's inangnem ken sak-en! Em man egay infaag ay asawam siya ay? ");
INSERT INTO lbk_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Aped mo kinwanin akhim siya ya inpalofosmo ay alaek ay asaw-en siya! Nay et chadlo si asawam, ayakham ta komaan kayo!” ");
INSERT INTO lbk_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Tay siya chi, finilin nan ali nan cheycha'y takhona ta ipangocha ay mangikaan ken cha Abram ay sin-asawa ya nan am-in ay kwana. ");
INSERT INTO lbk_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","NenpaCanaan cha Abram ken asawana ya nan am-in ay wad-ay ken siya isnan kinmaanancha id Egipto, ya naifoweg akhes cha Lot. Sa cha't inomchan isnan malalango ay ponchag id Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Finmaknafaknang si Abram. Angsan nan talakena, am-amed nan karnilo, karching, ya fakana, ya angsan akhes nan siping ya fallitokna. ");
INSERT INTO lbk_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Awni ya ke cha't kinmaan ischi ya nen-atoaton cha ay nenpaBetel ampon cha inomchan isnan sikhod ay nentetey-ancha ya nanopingana isnan altar ay nenfet-akan nan Betel ya Ai. Et nenchad-ayaw ken Dios Apo ischi. ");
INSERT INTO lbk_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Angsan akhes nan faan Lot ay naifoweg ken cha Abram, tay angsan nan karnilo, karching, ya fakana. ");
INSERT INTO lbk_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Et nay ad-i et omanay nan en-anglochan nan enkik-iwiyen cha Abram ken Lot isnan maaamongancha tay ayaka cha. ");
INSERT INTO lbk_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Siya chi nan khotok si kad-in masosmaan nan cheycha'y papaspastolencha. Esang pay, issan chey ay timpo sisya ay omiili nan Cananeo ya Perezeo ischi. ");
INSERT INTO lbk_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ya ket kanan Abram ken Lot, “Sin-ama ta. Ad-i somya mo masossosma nan takhota, ya olay chaita. ");
INSERT INTO lbk_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ensiyan ta man et. Piliyem nan olay entona ay lota ay laychem. Mo omey ka is apetna's chi, omey ak is apetna's na. Ngem mo omey ka is apetna's na, et omey ak is apetna's chi.” ");
INSERT INTO lbk_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nenmonaang si Lot et inilana ay angsan nan chanom isnan cheta ay ensag-en isnan wanga ay Jordan engkhana isnan ili ay Soar ay kag isnan oma ay Eden ya nan lota id Egipto. (Siya na nan kasasaad nan lota issan sisya'y egay namakawasan Dios Apo isnan Sodoma ya Gomorra.) ");
INSERT INTO lbk_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Pinilin Lot nan am-in ay lota ay ensag-en isnan wanga ay Jordan, et inmey isnan apet falaan si akhew. Siya na nan inangnen nan sin-ama ay nensiyan. ");
INSERT INTO lbk_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Nentee cha Abram id Canaan ya nentee cha Lot isnan sag-en nan Jordan ay kawad nan tapin nan ili. Inpatakchegna nan afongna ay torcha isnan sag-en nan Sodoma, ");
INSERT INTO lbk_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ay kawad nan cheycha'y ngaangaag ay takho ay chad-ama nan fasolcha ken Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Kakwasan nan kinmaanan cha Lot, kinwanin Dios Apo ken Abram, “Enmonaang ka ta ilaem isnan olay entona issa. ");
INSERT INTO lbk_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ichowak ken sik-a ya isnan wanen-edmo nan am-in ay lota ay iilaem, et sa yo enkwa is eng-engkhana. ");
INSERT INTO lbk_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","At pagkhanakek nan wanen-edmo ta kag cha isnan kaangsan nan chapog nan lota, et mo way makafilang isnan chapog nan lota, et siya akhes isnan wanen-edmo. ");
INSERT INTO lbk_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Aye, maligwat ka ta en ka likchen am-in nan lota tay at ichowak am-in ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Adi kad inyatoaton Abram nan kampona et nentee isnan sag-en nan cheycha'y kag alimmos ay kaew Mamre id Hebron. Nentoping ischi is altar ay enchatonana ken Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Awni ya ket wad-ay nan khofat isnan timpon Amrafel ay ali id Babilonia, si Arioc ay ali id Elasar, si Kedorlaomer ay ali id Elam ya si Tidal ay ali id Goiim. ");
INSERT INTO lbk_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Naamong nan naycha'y epat ay ali ta en cha khobfaten nan lima ay ali ay cha Bera ay ali id Sodoma, Birsa ay ali id Gomorra, Sinab ay ali id Adma, Semeber ay ali id Zeboiim, ya nan ali nan ili ay Bela paymo Soar. ");
INSERT INTO lbk_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nentotolag nan naycha'y lima'y ali ta amongencha am-in nan sorchachocha isnan cheta ay Siddim ay siya nan kawad nan fayfay idwani ay makwanin Natey ay Fayfay. ");
INSERT INTO lbk_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Siya chana nan lima ay ali ay tinetengngel Kedorlaomer isnan nar-os ay sinpoo ya chwa ay tawen, ngem isnan ikasinpoo ya tolo'y tawen, khinolacha siya. ");
INSERT INTO lbk_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Isnan mikasinpoo ya epat ay tawen, ya ket naligwat cha Kedorlaomer ya nan tolo'y ib-ana ay ali ay nangifoweg isnan sorchachocha ay en namaloknit isnan cheycha'y nateketekan ay ili. Inafakcha nan cheycha'y Refaim id Asterot Karnaim, nan cheycha'y Zuzim id Ham, nan cheycha'y Emim isnan cheta ay Kiriataim, ");
INSERT INTO lbk_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ya nan cheycha'y Horeo isnan kafib-ilikhan nan Edom. Inatikocha chaicha engkhana id Elparan ay sag-en nan malalango ay lota. ");
INSERT INTO lbk_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Sa cha't sinmakhong ya inmey cha id Kades (ay makwanin Enmispat id kasin). Inafakcha am-in nan nen-ili isnan awni't en-iliyan nan cheycha'y Amalekita ya inafakcha akhes nan cheycha'y Amorreo ay omili id Hazazon Tamar. ");
INSERT INTO lbk_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ya ket inamong nan cheycha'y ali id Sodoma, Gomorra, Adma, Zeboiim ya id Bela nan sorchachocha isnan cheta ay Siddim, ta faloknitencha ");
INSERT INTO lbk_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","nan cheycha'y ali ay nalpo'd Elam, Goiim, Babilonia ya Elasar. Lima ay ali nan mamaloknit isnan epat ay ali. ");
INSERT INTO lbk_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nan chey ay cheta ay nenfaloknitancha, et angsan nan fitona ay napno is isparto, et isnan lomayawan nan cheycha'y alin nan Sodoma ya Gomorra, nabfitowan cha, ngem nan cheycha'y tapina ay tolo'y ali et linmayaw cha is kafilig. ");
INSERT INTO lbk_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Inalan nan epat ay ali nan am-in ay wad-ay id Sodoma ya Gomorra, olay nan makakan, sa cha't kinmaan. ");
INSERT INTO lbk_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Intapicha akhes si Lot ay kaanakan Abram, ay inmili id Sodoma, ya nan kwana. ");
INSERT INTO lbk_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Nay met achi wad-ay nan esang ay nakalayaw et inokhodna ken Abram ay Hebreo nan am-in ay inmat. Nenkakampo cha Abram isnan sag-en nan cheycha'y kag alimmos ay kaew Mamre ay Amorreo, ya nakikadwa ken cha Mamre, Escol ya si Aner ay masinpapangib-a. ");
INSERT INTO lbk_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Isnan nangammowan Abram ay chinpapcha nan kaanakana, inamongna am-in nan fomafaloknit ay lallalaki ay naiyanak ay takhona kannay, ya tolon khasot ya sinpoo ya walo cha. Sa na't inpangpango chaicha ya ala cha ya onoonod isnan cheycha'y epat ay ali engkhana id Dan. ");
INSERT INTO lbk_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Khinedwana ischi nan cheycha'y takhona is chwan pamoweg, ya chinokloscha nan cheycha'y kafosocha isnan lafi, et inafakcha chaicha. Inatikocha chaicha engkhana'd Hoba ay chemang nan Damasco. ");
INSERT INTO lbk_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Et inalan cha Abram nan am-in ay kinamkam san epat ay ali. Insaana akhes si Lot ay kaanakana ya nan am-in ay kwana, nan cheycha'y fabfafai ya nan tap-in nan falod. ");
INSERT INTO lbk_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Isnan tinmoliyan Abram isnan kakwasan san nangafakana ken Kedorlaomer ya nan cheycha'y ib-ana ay ali, ya ket sinab-at nan alin nan Sodoma isnan cheta ay Save (ay makwani akhes en chetan si Ali). ");
INSERT INTO lbk_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Siya akhes ken Melkisedec ay ali id Salem, ya pachin akhes nan Katongchowan ay Dios, et inomyey si tinapay ya fayas ken Abram. ");
INSERT INTO lbk_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Binindisyonana si Abram ay mangwanin, “Asop ya si Apo Dios ay Katongchowan ay nangaeb isnan chaya ya nan lota et bindisyonana sik-a Abram! ");
INSERT INTO lbk_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Machad-ayaw nan Katongchowan ay Dios ay nangigwa isnan sinomyaam ay nangafakam isnan cheycha'y kafosom.” Inchowan Abram nan pagkapoon nan am-in ay kinamkamna. ");
INSERT INTO lbk_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sa et kinwanin nan alin nan Sodoma ken Abram, “Alaem am-in nan ngag sisa, ngem isoblim magtek nan takhok.” ");
INSERT INTO lbk_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ngem insongfat Abram, “Isapatak isnan Apo ay Katongchowan ay Dios, ay nenwad-ay isnan chaya ya nan lota, ");
INSERT INTO lbk_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ay ad-i ak en-ig-igto isnan olay ngag sisa'y kwam, olay paat sinolid yangkhay paymo taked nan pallokam. Ta ad-im kanan, ‘Sak-en nan nangipafaknang ken Abram.’ ");
INSERT INTO lbk_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tet-ewa, maid alaek ay ensilfi ken sak-en, mod-i ket nan yangkhay kinan nan takhok ya nan chatag nan kakadwak ay cha Aner, Escol ya Mamre ay naifoweg ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Awni pay ya ket nen-ikali si Dios Apo ken Abram isnan kag na it-itaw. Kinwanina, “Ad-i ka omegyat Abram. Saknifak sik-a isnan am-in ay kakaegyat, ya sobfalitak sik-a is ad-acha.” ");
INSERT INTO lbk_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Nay met achi kinwanin Abram, “Diosko ay Apok, ngag kay nan silfin nan iseg-angmo ken sak-en mo sisya'y maid anakko? Si met yangkhay Eliezer ay iDamasco nan wad-ay ay manawid isnan kwak. ");
INSERT INTO lbk_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Maid met inchowam si anakko, et nay esang isnan naycha'y faak nan manawid isnan kwak.” ");
INSERT INTO lbk_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Nakwas chi ya ket ay kasin nenkali si Dios Apo ay mangwanin, “Ad-i. Faken nan faam nan manawid isnan kwam, mod-i ket nan anakmo kannay.” ");
INSERT INTO lbk_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Sa et infalan Apo Dios si Abram, sa na't kanan, “Entangad ka ta filangem nan cheycha'y tokwifi mo makafilang ka, et kag nan filangcha nan wanen-edmo.” ");
INSERT INTO lbk_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Namati si Abram ken Dios Apo et nay infilangna siya ay nalenteg. ");
INSERT INTO lbk_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Sa et kinwanin Dios Apo ken siya, “Sak-en si Dios Apo ay nangifala ken sik-a id Ur ischi id Babilonia ta ichowak nan nay ay lota ken sik-a ta enkwam.” ");
INSERT INTO lbk_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kinwanin magtek Abram, “Ngag kay Apo nan sak mangammowan ay at enkwak nan nay ay lota?” ");
INSERT INTO lbk_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Insongfat Dios Apo ay mangwanin, “Omyali ka is fai ay faka ya karching, ya laki ay karnilo ay waschin entawen si tolo, esa'y kalopati ya esa'y anak si falog.” ");
INSERT INTO lbk_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Inyey Abram ken Apo Dios nan cheycha'y enkik-iwi, sa na't khedwaen ay nangekhed isnan awakcha, sa na't nensasakhangen ay nangisaad ischicha, ngem nan wad-ay payakcha et egayna khinedwa. ");
INSERT INTO lbk_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nen-epas nan cheycha'y lafaan isnan cheycha'y enkik-iwi ay finekfekna, ngem inafona chachi. ");
INSERT INTO lbk_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Isnan cha malonokhan nan akhew, naseyeseyep si Abram ya ket kag nafollingetan ya inmegyaegyat ya nafegyafegyas. ");
INSERT INTO lbk_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kinwanin et Dios Apo ken siya, “Siya na nan maangnen ay maangnen: At mangmangili cha yangkhay nan cheycha'y wanen-edmo isnan teken ay ili ay omayancha, et enfalin cha'y faa sa cha't maipap-alikhat is epat khasot ay tawen. ");
INSERT INTO lbk_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nay met achi at chosaek nan chey ay ili ay mamab-aa ken chaicha, ya at angsan nan itakincha ay ifaknangcha mo komaan cha. ");
INSERT INTO lbk_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ngem sik-a, at malakalakay ka ya oompa ka isnan mateyam ya khawis nan kaikaofam. ");
INSERT INTO lbk_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","At lomaos nan epat ay kaapo esa chadlo somakhong sina nan cheycha'y wanen-edmo, tay at ad-ik pakpakaanen nan cheycha'y Amorreo engkhana ay chad-ama nan kinangaagcha ya masapol ay machosa cha.” ");
INSERT INTO lbk_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Isnan nalonokhan et nan akhew ya finmollinget, ya ket wad-ay nan omas-asok ay fanga ya enfidfichang ay silew ay linmaos isnan nenfet-akan nan cheycha'y nakhedwakhedwa ay karni. ");
INSERT INTO lbk_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Et isnan siya chi kannay ay akhew tinot-oyan Dios Apo si Abram ay mangwanin, “Ikkalik ay mangichowa isnan cheycha'y wanen-edmo nan nay ay lota, mailapo isnan fedcheng nan Egipto engkhana isnan chakchake ay wanga ay Eufrates. ");
INSERT INTO lbk_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Maitapi nan chey lotan nan cheycha'y Kineo, nan cheycha'y Kenezeo ya nan cheycha'y Kadmoneo, ");
INSERT INTO lbk_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","nan cheycha'y Heteo, nan cheycha'y Perezeo, nan cheycha'y Refaim, ");
INSERT INTO lbk_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","nan cheycha'y Amorreo, nan cheycha'y Cananeo, nan cheycha'y Gergeseo, ya nan cheycha'y Jebuseo.” ");
INSERT INTO lbk_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Si Sarai ay asawan Abram, maid anakna, ngem wad-ay nan faana ay iyEgipto ay fafai ay nenngachan si Agar. ");
INSERT INTO lbk_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ket ay kinwanin Sarai ken Abram, “Chey! Inyad-in Dios Apo nan omanakak. Iseyepmo man et nan faak ta asop ya way enfalin ay anakko ken siya.” Adi kad tinan-oyan Abram nan infaag asawana, ");
INSERT INTO lbk_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","et inchowan Sarai nan iyEgipto ay faana ay si Agar ken Abram ta enfalin ay asawana. (Siya na nan inmat kakwasan nan sinpoo ay tawen ay nentetey-an cha Abram id Canaan.) ");
INSERT INTO lbk_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Inseyep Abram si Agar et naliton. Osto'y madlaw Agar ay maliton siya, ke na't ay ibfafan-ig nan apona ay si Sarai isnan teken ay pinang-ilana ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kinwanin et Sarai ken Abram, “Fasolmo nan omibfafan-ikhan Agar isnan teken ay pinang-ilana ken sak-en. Sak-en ay chadlos nan nangichowa ken siya ken sik-a, et engkhana issan nangammowana ay maliton siya ya ket ay omang-ango. Si Dios Apo koma nan mangokom ken chaita mo sino nan osto.” ");
INSERT INTO lbk_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kinwanin et Abram, “Faam met si Agar ya sik-a nan manetengngel ken siya, ikhad ka achi's angnem ken siya.” Siya chi ya ket inpalikhat Sarai nan faana engkhana'y linmayaw. ");
INSERT INTO lbk_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Inchanan nan anghel Dios Apo si Agar isnan eb-eb is kamalalango ay ponchag isnan chalan ay omey id Sur. ");
INSERT INTO lbk_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Sa na't kanan, “Agar ay faan Sarai, ento man nan nalpowam, ya ento nan omayam?” “Chak ilayawan nan apok,” insongfat Agar. ");
INSERT INTO lbk_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kinwanin et nan anghel, “Tomoli ka isnan apom ya maiyornos ka ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Sa na't kayet kanan, “At agtak sik-a's angsaangsan ay wanen-edmo, ya maid makafilang ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Et chey! Lalaki nan sam iyanak, ay at pangadnem si Ismael, tay chinngen Dios Apo nan akham isnan chadlos ay enliglikhatam. ");
INSERT INTO lbk_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nay met achi at kag atap ay dangki nan anakmo. At kholaena nan olay sino ya siya akhes at kholaencha siya. Ya maid kananan ib-ana.” ");
INSERT INTO lbk_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Sa et kanan Agar is semekna, “Ay tet-ewa ngen ay inilak nan Dios ya khechangna'y matatakho ak kayet?” Tay siya chi, nginadnana nan Dios Apo ay nanot-oya ken siya is, Nan Dios ay Omil-ila. ");
INSERT INTO lbk_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Siya et na nan chomalat ay nangadnan nan chey ay fofon ay wad-ay isnan nenfet-akan nan Kades ya Bered is, “Nan Fofon nan Enfibfiyag ay cha Omil-ila.” ");
INSERT INTO lbk_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Et inyanak Agar nan winad-ay Abram ay lalaki, ya nginadnan Abram si Ismael. ");
INSERT INTO lbk_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Walon poo ya enem nan tawen Abram issan nangiyanakan Agar ken Ismael. ");
INSERT INTO lbk_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Isnan nentawenan Abram is siyam poo ya siyam nenpaila si Dios Apo ken siya ay mangwanin, “Sak-en nan Dios ay Makabfalin isnan Am-in. Maiyornos ka ken sak-en ya angnem yangkhay nan nalenteg. ");
INSERT INTO lbk_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ipatet-ewak nan inkalik ay at sak pagkhanagkhanaken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Nenfalintomeng ay nentowad si Abram issan cha kayet manot-oyyan Apo Dios ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ilaem, siya na nan kanak ay entolakhanta: Ikkalik ay sik-a nan at enfalin ay aman nan katakhotakho isnan angsan ay kailiili. ");
INSERT INTO lbk_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Faken et Abram nan ngachanmo mod-i ket Abraham, tay enfalinek sik-a is aman nan katakhotakho isnan angsan ay kailiili. ");
INSERT INTO lbk_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Siya, pagkhanagkhanakek sik-a, ya khab-ek nan wanen-edmo is kailiili, ya ali nan tapina ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Et nan chey ay inkalik, et sak ilaen ta siya's maangnen ken sik-a ya isnan omon-onod ay kawanewanedmo. Et makitolag ak ken sik-a ya isnan wanen-edmo ta sak-en nan enDiosyo is eng-engkhana. ");
INSERT INTO lbk_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Et nan nay ay lota ay kawadmo ay mangmangili ka yangkhay et ichawchawko ken sik-a ya nan wanen-edmo ta enkwayo is eng-engkhana. Wen, am-in ay lota isnan Canaan et enkwacha is eng-engkhana ya sak-en nan Dioscha.” ");
INSERT INTO lbk_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kinwanin kasin Apo Dios ken Abraham, “Idwanin, sik-a ya nan omon-onod ay wanen-edmo et masapol ay angnenyo nan kanak ay entolakhanta. ");
INSERT INTO lbk_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Masapol ay abfoloyanyo isnan wanen-edmo ta masegyatan am-in nan lallalaki ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Mailapo idwani, masapol ay masegyatan nan ong-onga'y lalaki ay walo et nan akhewna. Maitapi nan faa ay naiyanak isnan afongyo, ya nan cheycha'y faa ay linakwam isnan cheycha'y mangili. Siya na nan mangipaila ay sik-a ya nan wanen-edmo et tan-oyanyo nan nentolakhanta. ");
INSERT INTO lbk_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Masapol ay waschin masegyatan, ta wad-ay maton isnan awakyo ay mangipaila ay maid pengpeng nan nentolakhanta. ");
INSERT INTO lbk_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Olay sino issa ay lalaki ay eg-ay nasegyatan et matlad isnan kakailiyana, tay eg-ayna inangnen nan nentolakhanta.” ");
INSERT INTO lbk_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kinwanin kayet Apo Dios ken Abraham, “Faken et Sarai nan kanam ken asawam. Mailapo idwani, Sara et nan ngachana. ");
INSERT INTO lbk_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","At bindisyonak siya ya at agtak sik-a is lalaki ay anakmo ken siya. Bindisyonak siya ta siya nan inan nan katakhotakho isnan kailiili. Ya at wad-ay cha nan ali isnan wanen-edna.” ");
INSERT INTO lbk_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Nenlokfob si Abraham, ngem ya ket ay mang-ango isnan semekna ay mangwanin, “Ay sa pet makawad-ay is anak nan am-ama ay sinkhasot et nan tawena? Ya kag akhes ken Sara, sa mampet omanak olay mo siyam poo et nan tawena?” ");
INSERT INTO lbk_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Sa na't inseg-ang ken Apo Dios ay mangwanin, “Mo sa achi koma ya figfikhem si Ismael.” ");
INSERT INTO lbk_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nay met achi kinwanin Apo Dios, “Ad-i, at omanak si Sara is lalaki et sam pangadnen si Isaac. Et sak patet-ewaen ken siya ya isnan wanen-edna san inkalik, tay mid pengpeng nan tolakhan tako. ");
INSERT INTO lbk_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Chinngek nan laychem ay kedchawen maipoon ken Ismael et chey, sak bindisyonan ya pagkhanagkhanakek siya ta omangsaangsan nan wanen-edna. At siya nan en-aman nan sinpoo ya chwa ay pangolo, et sak enfalinen is chakchakowag ay ili nan wanen-edna. ");
INSERT INTO lbk_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nay met achi nan chey ay inkalik, et sak angnen ken Isaac ay anakmo ay iyanak Sara isnan kag tona ay timpo is omali ay tawen.” ");
INSERT INTO lbk_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Sa et kinmaan si Apo Dios kakwasan nan nakitot-oyyana ken Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Isnan chey kannay ay akhew, inafolot Abraham si Apo Dios, et sinegyatana si Ismael ay anakna ya nan am-in ay lallalaki isnan afongna. Intapina akhes nan faa ay naiyanak isnan afongna ya nan cheycha'y linakwana. ");
INSERT INTO lbk_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Siyam poo ya siyam nan tawen Abraham issan nasegyatana, ");
INSERT INTO lbk_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ya sinpoo ya tolo akhes nan tawen Ismael. ");
INSERT INTO lbk_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Nasegyatan cha'y sin-ama isnan chey kannay ay akhew, ");
INSERT INTO lbk_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ya naitapi akhes ay nasegyatan nan am-in ay faan Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Awni ya ket nenpaila si Dios Apo ken Abraham isnan kawadna isnan kag alimmos ay kaew Mamre, isnan osto ay tomotokchowana isnan pantew nan afongna ay torcha isnan misoyaw ay kachad-amaan nan atong. ");
INSERT INTO lbk_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Isnan nenmonaangana, ya ke na't inila nan tolo ay lallalaki ay tinmatakcheg isnan adchawi is akit. Ala na't ya ligwat ya tagtag ay en nanab-at ken chaicha, sa et nenfalintomeng ay nentowad isnan sakhangcha. ");
INSERT INTO lbk_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ke na't kinwanin, “Apo, pangngaasiyo ta ad-iyo laosan nan afongko, tay naay ak ay mangipachag-os ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mo mabfalin ta maiyali nan chanom ay iyowasyo isnan sikiyo. Omilleng kayo isnan sanacha'y poon si kaew. ");
INSERT INTO lbk_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Sak et omiyali is akit ay tinapay ta way ifikasyo ay mangitoloy isnan faatyo. Khawis tay chinmag-os kayo”. Sa cha't kanan, “Siya man.” ");
INSERT INTO lbk_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Alan et Abraham ya sekhep is kaafongna ay torcha, sa na't kanan ken Sara, “Kamowem! Omala ka's tolo ay labfa ay kakhawisan ay alina ta omoto ka's tinapay.” ");
INSERT INTO lbk_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Sa et natanagtag is kakawad nan cheycha'y enkik-iwiyena, sa et pinmili isnan enlaplapog ay innanak si faka, et inchowana isnan cheycha'y faana ay nangikakamo ay nangisakhana ay nangoto. ");
INSERT INTO lbk_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Inmala si Abraham is naipapakheeng ay khatas, khatas ya watwat, sa na't inyey isnan cheycha'y mangilina is kapoon nan kaew, et inpasangona ken chaicha. Sa et naitatakcho ta cha na ikhaowan chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sa cha't kanan, “Ento kay si Sara ay asawam?” “Wad-ay is afong,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kinwanin et nan esang ken chaicha, “At somakhong ak ay somakhong isnan siya na ay timpo is omali ay tawen, et omanak si asawam ay Sara is lalaki.” Idwani, wad-ay si Sara is kachokogna is kapantew nan torcha ay afong ay mamannge ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Chadlos nalakay cha Abraham ay sin-asawa ya tinomke et nan kachawyan Sara. ");
INSERT INTO lbk_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Isonga naango siya isnan semekna ay mangwanin, “Idwani ay nalakalakay kami't ay sin-asawa ya maid et kachawyanko, ay kek ngen kasin khanasen?” ");
INSERT INTO lbk_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Sa et kanan Dios Apo ken Abraham, “En man naango si Sara ay nangwanin, ‘Ay tet-ewa ngen ay sak omanak si apchas ak et nalakay?’ ");
INSERT INTO lbk_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ay ke way ad-i mabfalin ay angnen Dios Apo? Kag sinan kinwanik ay at ensakhong ak isnan siya na ay timpo is omali ay tawen, et sa omanak si Sara is lalaki.” ");
INSERT INTO lbk_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Idwani, tay inmegyat si Sara, nen-engag ay mangwanin, “Ay ke ak nen-ango?” “Wen, nen-ango ka,” kinwanin nan mangili. ");
INSERT INTO lbk_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Naligwat et nan cheycha'y lallalaki ay komaan, sa cha't sinakhang is apet Sodoma. Naifoweg si Abraham ta ipangona chaicha isnan chalancha. ");
INSERT INTO lbk_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Sa et kanan Dios Apo is semekna, “Ad-ik koma itafon ken Abraham nan sinmekko ay angnen. ");
INSERT INTO lbk_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tay at enfalin nan wanen-edna is chakchakowag ya mafikas ay ili, ya maichalan ken siya et sak bindisyonan nan am-in ay omili isnan olay entona ay ili isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ya sak et pinili siya ta sa na ifilin isnan an-ak ya isnan wanen-edna ta pomati cha ya angnencha nan khawis ya nalenteg. Mo angnencha na, at angnek ken chaicha am-in nan inkalik ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Sa et kinwanin Dios Apo ken Abraham, “Chad-ama nan cha maipabfasolan nan Sodoma ya Gomorra. Chad-ama nan fasolcha. ");
INSERT INTO lbk_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Pomanad ak ta ilaek mo tet-ewa paymo ad-i nan cha cha maipabfasolan ay chak chengngen. Laychek ay ammowen.” ");
INSERT INTO lbk_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Adi kad nenchadchawes nan chwa ay lalaki id Sodoma, ngem sisya si Dios Apo ay nanatakcho ken Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Sa et sinmag-en si Abraham ken Apo Dios ay nangwanin, “Ay kem tet-ewa sa itapi ay mamakawas isnan cheycha'y nalenteg isnan nakafasol? ");
INSERT INTO lbk_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ngag kay mo wad-ay liman poo ay nalenteg isnan chey ay ili, at ngen pakawasem kayet? Ay kem ad-i isalakan nan ili ta maikasiw nan cheycha'y liman poo? ");
INSERT INTO lbk_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ad-i mabfalin ay itapim ay mamatey isnan cheycha'y nalenteg isnan nakafasol. Ad-ik patiyen ay angnem chi, tay mo siya sa nan angnem et pay en-iso cha ay machosa. Ammok ay ad-im angnen chi, tay sik-a ay mangokom isnan am-in ay lofong et nalenteg yangkhay nan angnem.” ");
INSERT INTO lbk_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Sinmongfat si Dios Apo ay nangwanin, “Mo ilaek ya wad-ay id Sodoma nan liman poo ay nalenteg ay takho, et isalakak am-in nan chey ay ili khapo ken chaicha.” ");
INSERT INTO lbk_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kinwanin et kasin Abraham, “Asop achi ya ad-im ngaakhen nan menpoopootak ken sik-a Apo. Tay takho ak yangkhay ya maid kalentekhak ay cha enkak-ali si isyangkhay ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ngem mo kay nget wad-ay epat poo ya lima ay takho's nalenteg at ngen sam pakawasen kayet, tay kolang si lima?” “Ad-ik pakawasen nan ili mo way ilaek is epat poo ya lima ay takho ay nalenteg,” kinwanin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kinwanin kasin Abraham, “Mo kay epat poo?” “Ad-ik pakawasen mo wad-ay epat poo cha.” ");
INSERT INTO lbk_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kinwanin kayet Abraham, “Asop ya ad-i ka somonget Apo, isnan kedchawek kasin. Mo pay way tolon poo yangkhay?” “Ad-ik pakawasen mo way tolon poo ischi,” insongfat Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Sa et kanan Abraham, “Pangngaasim Apo ta ad-im law-en nan kinatoledko ay enkechakechaw. Mo pay way chwan poo yangkhay is mad-anam?” “Ad-ik pakawasen sa ay ili mo wad-ay chwan poo is mad-anak,” kinwanin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kinwanin kayet Abraham, “Pangngaasim Apo ta ad-i ka somonget. Siya et na nan omochi ay kedchawek. Mo pay sinpoo yangkhay nan mad-anan?” Kinwanin nan Apo, “Ad-ik pakawasen nan chey ili mo wad-ay sinpoo.” ");
INSERT INTO lbk_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kakwasan nan nakikaliyan Dios Apo ken siya, kinmaan, et sinmaa akhes si Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Sedsechemna et isnan inomchanan san chwa ay anghel id Sodoma, ya sisya'y tomotokcho si Lot isnan pantew nan ili. Osto ay inilana chaicha, naligwat ay en nanab-at ken chaicha. Nenfalintomeng ay nentowad isnan sakhangcha ");
INSERT INTO lbk_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ay nangwanin, “Apo, naay ak ay ensilfi ken chakayo. Pangngaasiyo ta chomag-os kayo is afongko. Mabfalin ay owasanyo nan sikiyo ya omyan kayo. Is wakas et mabfalin ay mamikhat kayo ay omey isnan omayanyo.” Ngem kananchan, “Ad-i. Olay omyan kami is kapalasaan.” ");
INSERT INTO lbk_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Inpapatina kayet ay mangipakod ken chaicha engkhana'y inawisna chaicha, sa cha't nakisaa ken siya. Sa et inpaoton Lot nan tinapay ay mid fofodna ya nan khawis ay makakan ta isangona ken chaicha. Sa cha't nangan. ");
INSERT INTO lbk_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Osto ay maseyep koma nan cheycha'y mangilina ya ket liniwes nan am-in ay lallalakin si iSodoma nan afong Lot, amam-a's ongang-a. ");
INSERT INTO lbk_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Sa cha't finokhawan si Lot ay mangwanin, “Ento nan cheycha'y lallalaki ay inpachag-osmo idwani? Pafal-em chaicha!” Laychen nan lallalakin si iSodoma ay makiseyep ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Finmala si Lot ya inenfana nan pantew. ");
INSERT INTO lbk_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Sa na't kinwani ken chaicha, “Kakakyong, chadlos kalologkhitan nan semsemkenyo ay angnen. Pangngaasiyo ta ad-iyo angnen. ");
INSERT INTO lbk_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Chey na! Wad-ay met nan chwa ay mamagkitko ay sisya'y eg-ay kakapkappos na. Ifalak chaicha, et angnenyo nan laychenyo ay angnen ken chaicha. Ngem ngag ngotoyo isnan naycha'y lallalaki. Mangilik chaicha et isalakak chaicha.” ");
INSERT INTO lbk_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ngem kinwanicha, “Komasiw ka, sik-a ay mangmangili. Sino ka ay aped mangifaag isnan angnenmi? Ad-i ka enselat tay eleg et ya am-am-amed nan angnenmi ken sik-a mo ken chaicha.” Intolodcha si Lot sa cha't sinmag-en ay en mamakawas isnan eneb. ");
INSERT INTO lbk_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Nay met achi alan et nan cheycha'y minangilin Lot ya khoyod ken siya ay nangiskhep is afong, sa cha't inenfan. ");
INSERT INTO lbk_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Sa cha't kinolap nan cheycha'y wad-ay is chela ay amam-a's ongang-a, ta olay enkapokapokap cha et ad-i cha makaanap isnan eneb. ");
INSERT INTO lbk_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Sa et kinwanin nan chwa ay lalaki ken Lot, “Mo wad-ay kayet tapina'y an-akmo, innapom, paymo olay sino issa ay pangafongmo isna ay ili, et ikaanmo chaicha, ");
INSERT INTO lbk_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","tay nay et pakawasenmi nan nay ay ili. Chinngen Dios Apo nan chad-ama ay cha maipabfasolan nan omili isna, et finaana chakami ay mamakawas isna.” ");
INSERT INTO lbk_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Alan et Lot ya eey isnan cheycha'y lallalaki ay naitoya ay sa mangasawa isnan an-akna sa na't kanan, “Kamowenyo ay komaan sina! Nay pakawasen et Dios Apo nan nay ay ili.” Ngem kananchan mo aped en-ot-otyok si Lot. ");
INSERT INTO lbk_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Osto pay ay talan-o, chinagchag nan cheycha'y angheles si Lot. “Kamowem!” kinwanicha. “Ayakham si asawam ya nan chwa'y an-akmo ta komaan kayo, ta ad-i kayo maitapi ay machosa mo mapakawas nan nay ay ili.” ");
INSERT INTO lbk_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Nentontotonto si Lot, ngem khechangna'y naseg-ang kayet si Dios Apo ken siya. Et khinoyod nan mangilina siya, si asawana ya nan chwa'y an-akna sa cha't infala chaicha isnan ili ay Sodoma. ");
INSERT INTO lbk_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sa et kinwanin nan esang, “Lomayaw kayo't. Isalakanyo nan awakyo. Ad-i kayo ensagsakhong, ya ad-i kayo omil-illeng is kadcheta. Enchadchawes kayo is kafilig ta ad-i kayo matey.” ");
INSERT INTO lbk_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ngem ya ket ay kinwanin Lot, “Pangngaasim Apo ta chengngem sak-en. ");
INSERT INTO lbk_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ilaem achi, chadlos chachama nan inpailam ay seg-angmo ken sak-en isnan inmisalakam. Nay met achi ad-ik kafaelan tay ad-adchawiyan nan cheycha'y filig, ya et khechangna'y edchanan nan pomakawas sak-en ya at matey ak isnan sisya'y ad-ik omchanan sid-i. ");
INSERT INTO lbk_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Cheey sidi is ensagsag-en ay ili ay fan-ig, pangngaasim ta ipalofosmo ay ischi ak et yangkhay ay enpasalak. Mailam met ay fan-ig sa yangkhay ay ili et sa ak matakho ischi.” ");
INSERT INTO lbk_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","“Mo siya sa nan kanam, aye ad-ik pakawasen nan sana'y ili. ");
INSERT INTO lbk_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kamowenyo et mampay. Itagtagyo! Ad-i ak makapakawas isnan ngag sisa engkhana ay omchan kayo ischi.” Idwani tay fan-ig nan kinwanin Lot isnan chey ay ili, nay et nangadnan is Soar. ");
INSERT INTO lbk_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Cha et matan-ang nan akhew isnan inomchanan cha Lot id Soar. ");
INSERT INTO lbk_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ya ket ay nen-ipaochan Dios Apo isnan ili ay Sodoma ya Gomorra nan omap-apey ay asufre. ");
INSERT INTO lbk_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Et pinakawasna nan cheycha'y ili ya am-in nan nenlilwes ay cheta, et naitapi am-in nan cheycha'y takho, ya am-in ay tomobtofo ischi. ");
INSERT INTO lbk_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nay met achi ya ket ay nensakhong si asawan Lot ya nenfalin is tinagtakho ay asin. ");
INSERT INTO lbk_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Isnan wiiwiit isnan kawaksana, inmey si Abraham isnan tinmatakchekhancha ken Dios Apo issan chey. ");
INSERT INTO lbk_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nen-oschong isnan apet id Sodoma ya Gomorra ya minonaangna nan am-in ay chetana, et asok yangkhay ay tomongtongcho nan inilana ay kag asok nan chakchakowag ay enlonlonakhan sinan lanchok. ");
INSERT INTO lbk_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Adi kad issan namakawasan Apo Dios isnan cheycha'y ili ay liniliwes nan cheta, sisinmekna si Abraham et inpalayawna si Lot ta ad-i maitapi isnan menpakawasana isnan cheycha ay ili. ");
INSERT INTO lbk_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Idwani tay omegyat si Lot ay entee id Saor, inayakhana't nan chwa ay magmagkitna ya linmamag cha is kafilig et nentee cha is kaliyang. ");
INSERT INTO lbk_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Awni pay ya ket kinwanin nan yon-a isnan annochina, “Nay et cha malakay si ama ya maid paat lalaki isnan olay entona ta mabfalin ay omasawa ta ya omanak ta ay kag isnan ekhad si takho. ");
INSERT INTO lbk_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Fotengenta't achi si ama, ta mabfalin ay idchipata ta mawad-ayan ta is waned ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Adi kad isnan chey kannay ay lafi, finotengcha si amacha ya inseyep san yon-a. Et tay chachama san foteng amacha, et eg-ayna't inammowan san inmat. ");
INSERT INTO lbk_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Isnan kawaksana kinwanina isnan annochina, “Chey! Nakiseyep ak ken ama id kofab. Kasin ta fotngen idwani ay lafi ta sik-a akhes, et en-iso ta ay mawad-ayan si anak ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Et siya chi ay finotengcha kasin si amacha, sa et inseyep nan annochi. Et tay nafotefoteng si Lot, eg-ayna't akhes kayet inammowan ay inchipana pet nan anakna. ");
INSERT INTO lbk_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Adi kad en-iso et ay naliton nan an-ak Lot ay winad-ay kannay amacha. ");
INSERT INTO lbk_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Idwanin inmanak nan yon-a is lalaki et nginadnana's Moab. Siya nan nalpowan nan naycha'y Moabita idwani. ");
INSERT INTO lbk_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Inmanak akhes nan annochi et nginadnana's Benammi. Siya nan nalpowan nan naycha'y Ammonita idwani. ");
INSERT INTO lbk_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Awni pay ya ket kinmaan si Abraham id Mamre et inmey isnan ponchag ay nentee isnan nenfet-akan nan Kades ya Sur. Sa et nentee is sin-ak-itan id Gerar. ");
INSERT INTO lbk_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ya ket si Abimelec ay ali id Gerar, inalana si Sara tay aped kanan Abraham en akhina. ");
INSERT INTO lbk_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ngem ket ay nenpaila si Apo Dios ken Abimelec isnan it-itawna isnan lafi et kinwanina, “Matey ka'y matey tay inalam nan nay fafai ay apchas wad-ay nan asawana.” ");
INSERT INTO lbk_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Idwani tay egay inchipchipan Abimelec si Sara, kinwanina, “Apo, ay kem pakawasen nan maid fasolna? ");
INSERT INTO lbk_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Kinwanina met kannay ay sin-akhi cha. Ya olay nan fafai, siya akhes kayet nan kanana. Et siya chi nan khotokna ay khawis nan semekko ay nangala ken siya. Maid met ammok si inangnek ay ngaag.” ");
INSERT INTO lbk_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Sa et sinongfatan Apo Dios siya isnan it-itawna ay nangwanin, “Wen, ammok ay inangnem na isnan khawis ay semekmo, et egayko inpalofos ay kapposem ta ad-i ka makafasol ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Idwani magtek isoblim siya. Et tay mamadto nan asawana, at ilowalowana sik-a ta ad-i ka matey. Ngem mo ad-im isakhong siya et nay kanak ken sik-a ay at matey ka ay matey, sik-a ya nan am-in ay takhom.” ");
INSERT INTO lbk_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Wiit pay ya ket alan Abimelec ya among isnan am-in ay natangad ay takhona, sa na't infaag nan am-in ay inmat, et inmegyaegyat cha. ");
INSERT INTO lbk_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Inayakhana't si Abraham ay nangwanin, “Ngag man na's inangnem ken chakami? Ay ke way fasolko ken sik-a ta ipaiyaim nan nay chad-ama'y kangaakhan ken sak-en ya nan en-aliyak? Ay ke man somya nan nay inangnem ken sak-en? ");
INSERT INTO lbk_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ngag nan nangagkhalaam ay nangangnen sina?” ");
INSERT INTO lbk_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ket kanan Abraham, “Tay man kanak en mo maid paat takho isna is mangiyegyat ken Apo Dios. Ya kanak en ta ket lang wad-ay pomatey ta alaencha's asawak. ");
INSERT INTO lbk_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ngem tet-ewa man ay sin-akhi kami tay esang nan amami ngem teken nan in-ami, ya nen-asawa kami. ");
INSERT INTO lbk_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Adi kad issan nangiyadchawiyan Apo Dios ken sak-en isnan pangafong ama ay omey isnan teken ay ili, kinwanik ken asawak, ‘Siya na nan angnem ay mangipaila ay tet-ewa ka ken sak-en: Ibfakham ay sin-akhi ta isnan olay entona ay omayanta.’ ” ");
INSERT INTO lbk_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Siya chi't inagtan Abimelec si Abraham isnan cheycha'y karnilo, faka, ya faa, ya insoblina si Sara. ");
INSERT INTO lbk_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Kinwanina akhes ken Abraham, “Ilaem, lotak am-in chana. Piliyem nan olay entona ay laychem ay entey-an.” ");
INSERT INTO lbk_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sa na't akhes kanan ken Sara, “Nay agtak nan akhim is sinlifo ay pidaso ay nabfalor ay siping ay mangipaila isnan olay sino ay wad-ay ken chakayo ay maid makwaniyam. Et ammowen am-in nan takho ay mid ngaag si inangnem.” ");
INSERT INTO lbk_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Idwani khapo tay siya chi ay inalan Abimelec si Sara, ya ket am-in ay fabfafai isnan afongna et ad-i makaanak tay egay inpalofos Dios Apo. Adi kad inlowalowan Abraham si Abimelec et khinmawis cha. Inpagkhawis Apo Dios siya, si asawana ya nan cheycha'y fabfafai ay faana ta makaanak cha. ");
INSERT INTO lbk_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Sa et inpagkhawis Dios Apo si Sara ay maiyafoloy isnan inkalina. ");
INSERT INTO lbk_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Naliton et chadlo siya et inmanak is lalaki, olay mo chadlos nalakay si asawana ay Abraham. Naiyanak nan ong-onga isnan siya chadlos ay timpo ay initchon Apo Dios ay kaiyanakana, ");
INSERT INTO lbk_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ya Isaac nan inpangachan Abraham ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Osto ay walo et ay akhew nan ong-onga, sinegyatan Abraham ta maangnen nan infilin Apo Dios ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Entawen is sinkhasot si Abraham issan naiyanakan Isaac. ");
INSERT INTO lbk_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Kinwanin Sara, “Inmagtan si Apo Dios is khotokna's en-angowak. At akhes makiang-ango ken sak-en nan am-in ay mannge isna.” ");
INSERT INTO lbk_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kinwanina akhes, “Ay ke way nakakwani ken Abraham issan chey ay at enpasoso si Sara? Ngem nay met khechangna'y nakaiyanak ak is anakna isnan nalakayana.” ");
INSERT INTO lbk_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Naengngan nan ong-onga, ya isnan akhew ay napsowana nenpapiyasta si Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Isnan namingsan, si Ismael ay anak cha Abraham ken Agar ay iyEgipto et cha na ang-angowen si Isaac ay anak Sara. ");
INSERT INTO lbk_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Isnan nangil-an Sara ken chaicha kanana't ken Abraham, “Pakaanem et nan nay faa ya nan anakna. Ad-ik laychen ay makitawid nan anak si faa isnan tawichen koma Isaac ay anakko.” ");
INSERT INTO lbk_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Siya et na nan nen-akhalan nan nemnem Abraham, tay anakna met akhes si Ismael. ");
INSERT INTO lbk_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nay met achi kinwanin Apo Dios ken Abraham, “Ad-i ka madchanakhan isnan ong-onga ya nan faam ay si Agar. Angnem am-in nan ifaag Sara, tay at si Isaac nan malpowan nan wanen-edmo ay inkalik. ");
INSERT INTO lbk_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","At akhes pagkhanakek nan anak si faa ya enfalin cha'y chakchake akhes ay ili, tay anakmo akhes siya.” ");
INSERT INTO lbk_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Osto pay ay nawiit, ya ket inpaawit Abraham ken Agar nan senget ya nan lalat ay napno is chanom. Sa na't inchowa nan ong-onga ya inpaligwatna chaicha ay sin-ina ay komaan. Kinmaan cha't ya nenliklikhed cha isnan ponchag id Beerseba. ");
INSERT INTO lbk_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Isnan naangkhayan nan chanom, ya ke na't ay tinaynan nan anakna is kapoon nan chapong, ");
INSERT INTO lbk_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","sa et en tinmokcho is away sinkhasot ay mitro nan kaadchawina tay kananan, “Aye pay na! Ya ke ak ad-i makaikatpe ay mangiila isnan mateyan nan anakko.” Ya cha enngegngeg. ");
INSERT INTO lbk_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Idwani, chinngen Apo Dios nan akhan nan ong-onga, ya ket nenfokhaw id chaya nan anghelna ay mangwani ken Agar, “Ngag man nan chadlos kakorkolan nan semekmo Agar? Ad-i ka omegyat tay chinngen Apo Dios nan anakmo'y en-ag-akha. ");
INSERT INTO lbk_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Iligwatmo ta en ka akwaen nan ong-onga ta liwliw-em. Tay at khab-ek nan wanen-edna is chakchakowag ay ili.” ");
INSERT INTO lbk_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Sa et inpailan Apo Dios ken siya nan fofon ya en na pinno nan lalat is chanom et inpainomna nan anakna. ");
INSERT INTO lbk_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Tinatakchon Apo Dios nan ong-onga isnan cha na mengnganan. Ya isnan ponchag id Paran nan en na nentetey-an et nenfalin ay pomapantolay. ");
INSERT INTO lbk_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Inpaasawan inana siya isnan iyEgipto. ");
INSERT INTO lbk_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Idwani isnan chey ay timpo inmey cha Abimelec ya si Ficol ay kapitan nan sorchachona ken Abraham ay nangwanin, “Wad-ay si Apo Dios ken sik-a isnan am-in ay cham ang-angnen. ");
INSERT INTO lbk_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Isapatam et isnan sakhangna ay ad-im fab-aliyan sak-en, paymo nan an-akko ya nan wanen-edko. Inpailak yangkhay nan kinatet-ewak ken sik-a, et idwani kedchawek ta ipailam akhes nan kinatet-ewam ken sak-en ya nan nay ay ili ay entetey-am.” ");
INSERT INTO lbk_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Tinan-oyan Abraham ay mangwanin, “Wen, isapatak.” ");
INSERT INTO lbk_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Nay met achi inlilina ken Abimelec nan mipoon isnan chey fofon ay inokat nan cheycha'y faan Abimelec. ");
INSERT INTO lbk_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kinwanin Abimelec, “Ad-ik ammo nan nangangnen sina. Eg-aymo met infab-aag na ya idwani yangkhay nan nangammowak.” ");
INSERT INTO lbk_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Sa et inchowan Abraham nan tapin nan karnilo ya fakana ken Abimelec et khinaebcha nan pechen. ");
INSERT INTO lbk_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Tinlad akhes Abraham nan pito ay fai ay innanak si karnilona. ");
INSERT INTO lbk_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Sa et kanan Abimelec, “Em man telachen chachi ay?” ");
INSERT INTO lbk_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ya ket kinwanin Abraham, “Ichawchawko chachi ken sik-a. Alaem ay mangipatet-ewa ay figfikhem ay sak-en nan nangaob isnan nay ay fofon.” ");
INSERT INTO lbk_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Adi kad nangadnan et nan chey ay fofon is Beerseba tay ischi nan nensapataan nan chwa ay cheycha. ");
INSERT INTO lbk_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kakwasan nan nentolakhancha id Beerseba, naligwat cha Abimelec ken Ficol ya nensakhong cha isnan kawadcha ay sakop nan Filistia. ");
INSERT INTO lbk_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Et siya chi ay nen-imola si Abraham is kaew ay salamakhi ischi id Beerseba, sa et nenchayaw ken Dios Apo ay Eng-engkhana ay Dios. ");
INSERT INTO lbk_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Et inmannong ay inmili si Abraham ischi id Filistia. ");
INSERT INTO lbk_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Awni pay ya tinpeng Apo Dios si Abraham. “Abraham!” kinwanina. “Wen, naay ak,” insongfat Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","“Alaem si Isaac ay kedkecheng ay anakmo, ay chadlos mo laylaychen ta omey kayo id Moria. Ischi isnan filig ay itchok, poowam siya ay mangichaton ken sak-en,” kinwanin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Adi kad isnan kawiitana, chinmomet si Abraham is kaew ay at ipoona isnan anakna ay ichatona, sa na't inpaawit isnan dangki. Intakina si Isaac ya nan chwa'y faana, sa cha't nenligwat ay omey isnan chey filig ay kinwanin Apo Dios ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Isnan mikatlo'y akhew isnan sisya'y kawad cha isnan adchawi, sinakhang et Abraham nan chey omayancha ay filig. ");
INSERT INTO lbk_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Sa na't kanan sinan cheycha'y faana, “Som-ed kayo ya nan dangki isna, ta omey kami ay sin-ama ischi ay enchayaw sa kami't tomoli.” ");
INSERT INTO lbk_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Inpasakfat Abraham ken Isaac nan kaew ay at ipoona, sa na't inawit nan khipan ya nan khomakhangat ay oling. Isnan nenfobfowekhancha, kinwanin Isaac, “Ama.” Sinfat Abraham ay nangwanin, “Wen, anakko.” ");
INSERT INTO lbk_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Sa et kanan Isaac, “Ya ke wad-ay nan apey ya kaew, ya ento kay nan mapoowan ay innanak si karnilo mo?” ");
INSERT INTO lbk_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kinwanin et Abraham, “At kikhad si Apo Dios isnan maichoo.” Sa cha't nanad-alan kayet. ");
INSERT INTO lbk_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Isnan inomchanancha isnan inpitchon Apo Dios, tinmoping si Abraham si altar sa na't innongnong nan kaew isnan kaosona. Ala na't ya taked isnan anakna sa na't inyoson isnan cheycha'y innongnongna ay kaew is kaaltar. ");
INSERT INTO lbk_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Sa na't ala ya kaw-ed isnan khipan ay mamatey isnan anakna. ");
INSERT INTO lbk_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Nay met achi ya ket nenfokhaw id chaya nan anghel Dios Apo ay mangwani ken siya, “Abraham, Abraham!” “Wen, naay ak sina,” insongfatna. ");
INSERT INTO lbk_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kinwanin nan anghel, “Ad-im sokhaten nan anakmo paymo angnen nan ngag sisa ken siya. Idwanin, ammok ay pawadwad-em si Apo Dios tay olay nan kedkecheng ay anakmo et eg-aymo inyad-i ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Osto'y nensakhong si Abraham ke na't inila nan laki ay karnilo ay naisakhod nan sakkhodna is kachapong. Inmey et inalana ya siya et chi nan pinoowana engkhana ay chinmapo ay mangichoo ken Apo Dios ya faken et san anakna. ");
INSERT INTO lbk_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Osto ay siya chi, nginadnan et Abraham nan chey ay filig is, Si Dios Apo nan enpawad-ay. Engkhana idwani sisya'y cha kayet kanan nan takho en, “Isnan filig Dios Apo siya nan enpawad-ay.” ");
INSERT INTO lbk_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kasin nenkali id chaya nan anghel Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Kinwanina, “Siya na nan kanan Dios Apo: Isapatak isnan ngachanko kannay ay at bindisyonak ay bindisyonan sik-a mo ke tay isnan nay ay inangnem ay eg-ay nangiyad-i isnan es-esang ay anakmo ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ikkalik ay agtak sik-a is angsaangsan ay wanen-edmo ay kag nan kaangsan nan tokwifi id chaya paymo nan ofod is kailit nan fayfay. At afaken nan wanen-edmo nan kafosocha. ");
INSERT INTO lbk_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ya am-in ay kailiili isnan olay entona, et komchaw cha ken sak-en is khomawisancha ay kag nan angnek ay menbindisyon isnan wanen-edmo, tay inangnem nan filinko.” ");
INSERT INTO lbk_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Osto'y siya chi sinmakhong cha Abraham isnan kawad nan faana, et nafobweg cha am-in ay inmey id Beerseba ay nentey-ancha. ");
INSERT INTO lbk_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nawnawnin ya ket ay chinngen Abraham ay walo cha nan an-ak Milca ken asawana ay si Nahor ay akhina. ");
INSERT INTO lbk_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Si Uz nan yon-a, misned nan lallalaki ay cha Buz, Kemuel ay aman Aram, ");
INSERT INTO lbk_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildas, Jidlaf ya si Betuel. ");
INSERT INTO lbk_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Si Betuel nan aman Rebecca.) Siya chana nan walo ay lallalaki ay inyanak Milca ken Nahor ay akhin Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Si akhes Reuma ay fafain Nahor et inyanakna cha Teba, Gaham, Taaz ya si Maaca. ");
INSERT INTO lbk_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Natakhotakho si Sara et nentawen siya is sinkhasot ya chowan poo ya pito. ");
INSERT INTO lbk_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Natey id Hebron isnan ili ay Canaan, et inachokhan cha Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Awni pay ya ket naligwat ay en nanot-oya isnan cheycha'y Heteo ay omili ischi. Kinwanina, ");
INSERT INTO lbk_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Kakakyong, mangmangili ak yangkhay isna ay makitetee ken chakayo. Pangngaasiyo achi ta omilako kayo is akit ay lotayo ta way mangipay-ak ken asawak.” ");
INSERT INTO lbk_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kanan et nan cheycha'y Heteo, ");
INSERT INTO lbk_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Chengngem ona nan laychenmi ay kanan ken sik-a. Figfikhenmi ay sik-a et matangad ka ay pangolo isnan ilimi. Malaychan nan olay sino ken chakami ay mangichowa ken sik-a is kakaofan ay mangikaofam ken asawam. Aye, ippeymo siya isnan kakhawisan ay kakaofanmi!” ");
INSERT INTO lbk_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Nentakcheg si Abraham ya nenyongyong isnan sakhangcha, ");
INSERT INTO lbk_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ya kinwanina, “Mo ipalofosyo ay ikaobko isna si asawak et pangngaasiyo ta chengngenyo nan kanak. Kedchawenyo koma ken Efron ay anak Zohar, ");
INSERT INTO lbk_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ta ilakona ken sak-en nan liyang id Macpela ay wad-ay is kailit nan lotana. Fayachak nan osto ay falorna ken siya isnan sakhangyo am-in, ta wad-ay akhes enkwak ay sak en-ikak-aofan.” ");
INSERT INTO lbk_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Idwani, wad-ay kannay ischi si Efron ay makitotokcho isnan chey ib-ana ay Heteo isnan kaam-amongancha ay pantew nan ili. Ke na't kanan isnan sakhangcha am-in, ");
INSERT INTO lbk_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Siya na nan kanak ken sik-a, apo. Ichowak ay libli ken sik-a am-in nan chey ay oma mitapi nan liyang ay wad-ay ischi ta way mangikaofam ken asawam. Siya na nan kanak isnan kakawad nan naycha'y kakailiyak: Iseg-angko chi ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Nay met achi nenfalintomeng si Abraham isnan sakhang nan omili. ");
INSERT INTO lbk_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Sa na't kanan ken Efron isnan mamanngelancha am-in, “Pangngaasim ta chengngem sak-en. Lakwak am-in nan lota. Chawatem koma nan fayadna ta sak et ikaob ischi si asawak.” ");
INSERT INTO lbk_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Sa et kanan Efron, ");
INSERT INTO lbk_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Chengngem apo. Ay kem mang-ey fayachan nan lota ay epat khasot ay pidaso yangkhay nan falorna? Ikaobmo et yangkhay sid-i si asawam.” ");
INSERT INTO lbk_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Tinan-oyan Abraham nan epat khasot ay pidaso ay nabfalor ay siping ay infaag Efron isnan mamanngelancha am-in et siya chi nan tinimfang Abraham ay maiyafoloy isnan os-osalen nan cheycha'y en-ilaklako. ");
INSERT INTO lbk_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Siya na nan inangnen Abraham ay nangala isnan lotan Efron id Macpela isnan apet falaan si akhew id Mamre. Maitapi ischi nan oma, nan liyang, ya nan am-in ay kaew ay wad-ay ischi. ");
INSERT INTO lbk_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Et finigfig am-in nan Heteo ay wad-ay ischi ay kwan et Abraham nan chey ay lota. ");
INSERT INTO lbk_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Adi kad inkaob et Abraham si asawana isnan chey liyang id Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Et siya chi nenfalin et ay kwan Abraham ay en-ikak-aofana nan oma ya liyang ay sikhod ay kwan si Heteo. ");
INSERT INTO lbk_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Chadlos nalakalakay et si Abraham ya binindisyonan am-in Dios Apo nan cha na inang-angnen. ");
INSERT INTO lbk_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Idwani kinwanina isnan kaam-amaan ay faana, ay nenfiyang isnan am-in ay kwana, “Ippeymo nan limam isnan enfet-akan nan chwa'y opok ta ensapata ka. ");
INSERT INTO lbk_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ipasapatak sik-a ken Dios Apo, ay Dios isnan lota ya chaya ta ad-i ka omal-ala isnan fafai isna id Canaan is asaw-en nan anakko. ");
INSERT INTO lbk_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Omey ka magtek isnan ili ay nalpowak, ta pomili ka isnan cheycha'y papangafongko is asaw-en Isaac ay anakko.” ");
INSERT INTO lbk_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","“Mo pay ad-i laychen nan fafai ay makisaa ken sak-en isna?” kinwanin nan faa. “Sak ngen ifoweg nan anakmo ay omey ischi?” ");
INSERT INTO lbk_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“Ad-i! Ilaem ta ad-im ifob-oweg nan anakko ischi,” insongfat Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“Tay nan Dios Apo, ay Dios id chaya et infalana sak-en isnan afong ama ya isnan ili ay nalpowanmi ay sinpapangafong, sa na't insapata ay ichowana ken sak-en ya isnan wanen-edko nan nay ay ili. At mamangpango nan anghelna ischi ta makaala ka is asawan nan anakko. ");
INSERT INTO lbk_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mo en-ad-i nan fafai ay makiali ken sik-a, at mawayaan ka isnan nay ay sapata. Nay met achi, olay ngag nan om-omat, ad-im iyey nan anakko ischi.” ");
INSERT INTO lbk_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Et siya chi ay inpey san faa nan limana isnan enfet-akan nan chwa'y opon Abraham ay apona, ya insapatana ay angnena nan naifilin ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Sa et insakhanan nan chey ay faa nan sinpoo ay kamelio ya nan angsan ay ilan si kakhawisan ay ilayad Abraham ay apona, et nenligwat ay omey isnan ili ay nentetey-an Nahor id Mesopotamia. ");
INSERT INTO lbk_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Osto ay inomchan cha ischi, inpafalintomengna nan cheycha'y kamelio is kawad-an nan fofon isnan ilit nan ili. Nisakhilip et nan akhew ya timpon si manakchowan nan fabfafai. ");
INSERT INTO lbk_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Sa et nenlowalo, “Dios Apo, ay Dios nan apok ay si Abraham, omagtan ka is somyaan nan inalik idwani, ya ipailam nan kinagkhawismo isnan apok ay si Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Chey, naay ak et isnan fofon ay manaksakchowan si mamamagkit isnan nay ay ili. ");
INSERT INTO lbk_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Idwani, fomachang ka ta mo sak kanan isnan esang ken chaicha, ‘Pangngaasim ta eppasem nan fangam ta ominom ak,’ ya sa na't kanan, ‘Wen, ominom ka, ta sak et akhes somakcho si inomen nan kameliom,’ et siya chi nan mangammowak ay siya nan pinilim ay en-asawan nan faam ay si Isaac. Ya siya akhes nan mangammowak ay inpailam nan kinagkhawismo ken Abraham ay apok.” ");
INSERT INTO lbk_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Sisya'y cha kayet enlowalo, ya ket inomchan si Rebecca ay manasakfat isnan fangana. Siya nan anak Betuel ay anak cha Milca ken Nahor ay akhin Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nan nay ay magmagkit et chadlos ay khawis nan ilana ay fafai ya sisya'y egay kakapkappos. Pinmanad is kafofon ay namno isnan fangana sa et kasin linmamag. ");
INSERT INTO lbk_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Alan et san faa ya kamakam ay nanab-at ken siya sa na't kanan, “Ay ad-i ngen mabfalin ta ominom ak isnan sana ay sinakchom?” ");
INSERT INTO lbk_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Mabfalin apo,” kinwanin Rebecca. Chag-as na't ya epas isnan fangana ay nangipainom ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kakwasan nan inminoman san faa kinwanin et nan magmagkit, “Painomek akhes nan kameliom engkhana'y makainoman cha.” ");
INSERT INTO lbk_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ala na't ya koyag isnan chanom is kaomin-inoman si enkik-iwi sa na't kasin pinay-an. Siya chi nan inangnena engkhana'y inpainomna am-in nan cheycha'y kameliona. ");
INSERT INTO lbk_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Khinmigkhinek san faa ay mamob-oya ken Rebecca ta ilaena mo tet-ewa'y agtan Dios Apo is somyaan nan naibfaalana. ");
INSERT INTO lbk_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Osto ay inpainom Rebecca nan cheycha'y kamelio, ya ket inpafalan san faa nan nangina ay singsing ay fallitok, sa na't inpey is kaeleng nan magmagkit. Inpeyna akhes nan chwa ay chadchake ay fallitok ay khaching isnan chwa'y limana. ");
INSERT INTO lbk_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Sa na't kanan, “Ibfakham man mo sino nan amam? Ay wad-ay ngen mabfalin ay omyananmi is afongyo?” ");
INSERT INTO lbk_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","“Si Betuel nan amak ay anak nan cha ikit ay Milca ken Nahor,” kinwanin nan fafai. ");
INSERT INTO lbk_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","“Angsan nan chakhami ya nan tapina ay kanen si kamelio is afongmi ya wad-ay akhes nan omyananyo.” ");
INSERT INTO lbk_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nenyongyong et san faa ay nenchayaw ken Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Kinwanina, “Machad-ayaw nan Dios Apo ay Dios Abraham ay apok, tay ipailana'y ipaila nan kinagkhawis ya kinamatalekna isnan apok. Inmipango isnan afong nan aag-in nan apok.” ");
INSERT INTO lbk_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nentatagtag et san magmagkit ay sinmaa is kawad cha inana, et inokhodna am-in nan inmat. ");
INSERT INTO lbk_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Wad-ay ischi nan lalaki ay akhin Rebecca ay enngachan si Laban. Osto ay inilana nan singsing is kaeleng Rebecca, ya nan khaching is kalimana, ya sa na't chinnge nan infaagna ay kinwanin nan faa ken siya, ala na't ya tagtag is kafofon ay kawad-an san faan Abraham. Osto ay inomchan ischi, ya ket ay inilana san faa ay tinmatakcheg isnan sag-en nan kamelio is kafofon. ");
INSERT INTO lbk_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Sa na't kanan, “Apo ay binindisyonan Dios Apo, ali ka ta somaa ta. Ay ke ka aped entetee isna? Wad-ay nan naisakhana ay omyananyo is afongmi, ya wad-ay akhes nan entey-an nan kameliom.” ");
INSERT INTO lbk_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Sa et insaan Laban siya, sa na't eppasen nan awit nan cheycha'y kamelio ya inagtana is chakhami ya nan tapina'y kanen si kamelio. Inagtana akhes nan faan Abraham ya nan cheycha'y iib-ana is chanom ay iyowascha isnan sikicha. ");
INSERT INTO lbk_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Isnan nakhaowan nan kanencha, kinwanin san faa, “Ibfakhak ona nan khakhalak esa ak pay mangan.” “Ibfakham et achi,” kinwanin Laban. ");
INSERT INTO lbk_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“Sak-en nan faan Abraham,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“Chachama nan namindisyonan Dios Apo isnan apok. Inpafaknangna. Inagtana siya is angsan ay karnilo, karching, faka, siping, fallitok, lallalaki ya fabfafai ay faa, kamelio ya dangki. ");
INSERT INTO lbk_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nalakay et si Sara ay asawan nan apok isnan nangikimenana isnan anakcha ay lalaki. Et siya nan naigwaan nan am-in ay kwan nan apok. ");
INSERT INTO lbk_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Inpasapatan nan apok sak-en ta angnek nan infilina ay nangwanin, ‘Ad-i ka omal-ala is fafai isna id Canaan is asaw-en nan anakko. ");
INSERT INTO lbk_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Omey ka magtek isnan cheycha'y papangafong ama ta ischi nan omal-am.’ ");
INSERT INTO lbk_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Sak et pinoot isnan apok mo ngag nan angnek mo en-ad-i nan fafai ay makisaa, ");
INSERT INTO lbk_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ya kinwanina, ‘Si Dios Apo ay omichad-alan et sa na ifaa nan anghelna ay mangifoweg ken sik-a ta somya nan omayam. Ya at makaala ka is asawan nan anakko isnan cheycha'y papangafong ama. ");
INSERT INTO lbk_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Et sa ka yangkhay mawayaan isnan insapatam mo ad-iyencha sik-a isnan omayam isnan papangafongko. Ya et maid maipabfasolam.’ ");
INSERT INTO lbk_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Issan inomchanak is kafofon id kawni, nenseg-ang ak ken Apo Dios ta mo ke fomachang. Kinwanik, ‘Dios Apo ay Dios nan apok ay si Abraham, mo sa ya omagtan ka is somyaan nan khakhalak ay nenfaatan idwani. ");
INSERT INTO lbk_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Chey, naay ak isnan nay fofon. Mo sak kanan isnan magmagkit ay omali ay manakcho en, “Pangngaasim ta omagtan ka is akit si inomek isnan sana'y sinakchom,” ");
INSERT INTO lbk_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ya sa na't kanan, “Wen, ominom ka, ta sak et somakcho akhes si inomen nan kameliom,” et asop ya siya chi nan mangammowak ay siya nan pinilim ay en-asawan nan anak nan apok.’ ");
INSERT INTO lbk_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Sisya'y cha ak enlowalo isnan semekko, ya ket inomchan si Rebecca ay manasakfat isnan fanga ay isakchowana. Pinmanad is kafofon, nanakcho ya linmamag, ya sak et kinomchaw is inomek. ");
INSERT INTO lbk_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Chag-as na't ya epas isnan fangana sa na't kanan, ‘Mabfalin apo. Ominom ka ya sak et akhes painomen nan sanacha'y kameliom.’ Siya chi et inminom ak sa na't akhes inpainom nan cheycha'y kameliok. ");
INSERT INTO lbk_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Sinalodsodko mo sino nan amana et kinwaninan si Betuel ay anak cha Nahor ken Milca. Sak et inpey nan singsing is kaelengna, ya nan chwa'y khaching isnan chwa'y limana. ");
INSERT INTO lbk_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Sak et nenyongyong ay nenchayaw ken Dios Apo, ay Dios Abraham ay nenfaa ken sak-en. Chinayawko siya ay nangipango ken sak-en isnan afong nan aag-in nan apok ay nangchanak isnan magmagkit ay asaw-en nan anak nan apok. ");
INSERT INTO lbk_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Idwani, laychek akhes ay chengngen ken chakayo, mo ipailayo nan kinagkhawis ya kinamatalekyo isnan apok paymo ad-i. Ibfakhayo ta ammok nan angnek.” ");
INSERT INTO lbk_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Sinmongfat cha Laban ken Betuel ay nangwanin, “Idwani, tay si Dios Apo nan nangitcho isnan nay ay maangnen, maid kasin mi kanan. ");
INSERT INTO lbk_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Naay si Rebecca. Ayakham et ta itakinmo ta siya's en-asawan nan anak nan apom ta maangnen nan initchon Dios Apo.” ");
INSERT INTO lbk_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Isnan nanngelan nan faan Abraham isna, nenfalintomeng ay nenyongyong ay nenchayaw ken Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Sa na't inpafala nan lopot, ya akon ay nakhaeb isnan fallitok ya nabfalor ay siping et inchowana ken Rebecca. Sa na't inchowa akhes nan nenkangina ay ilayadna isnan etad Rebecca ay lalaki ya nan inana. ");
INSERT INTO lbk_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nangan ya inminom nan faan Abraham ya nan cheycha'y fowegna sa cha't inomyan ischi. Osto ay fomangon isnan wiit, ke na't kedchawen ay mangwanin, “Somaa kami't achi ay omey isnan apok.” ");
INSERT INTO lbk_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ngem ya ket ay inpakod nan sin-ina chaicha ay mangwanin, “Entee kayo kayet isna is esa'y chomingkho paymo sinpoo ay akhew, esa kayo't chadlo omey.” ");
INSERT INTO lbk_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ngem kinwanin nan faa, “Ad-i kayo koma omipakod tay nay inmagtan si Dios Apo is somyaan nan inmaliyak isna. Siya mo tomoli kami et isnan apok.” ");
INSERT INTO lbk_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“Tot-oyyen tako't yangkhay nan magmagkit mo ngag nan kanana,” insongfatcha. ");
INSERT INTO lbk_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Siya chi et inayakhan cha siya, sa cha't kanan, “Ay laychem ay maitakin kannay ken tona?” “Wen, maitakin ak,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Adi kad inpalofoscha't si Rebecca ya nan in-ina ay faa ay sikhod ay nangab-afa ken siya ta maitakin cha isnan chey faan Abraham ya nan takhona. ");
INSERT INTO lbk_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Sa et binindisyonan cha Laban si Rebecca ay nangwanin, “Asop ya sik-a ay kafabfaiyak et makhanakhanak ka ta enfalin ka ay inan si kalifolifo. Asop ya nan wanen-edmo et afakencha ya kowaencha nan ilin nan kafosocha!” ");
INSERT INTO lbk_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Sa et nenligwat cha Rebecca ya nan fabfafai ay faana, sa cha't nenlokhan isnan kamelio ay omon-onod isnan faan Abraham ay somaa. ");
INSERT INTO lbk_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Idwani si akhes Isaac et nen-aton ya en nentee isnan malalango ay ponchag isnan apet nan Canaan isnan fofon ay makwanin, “Fofon si Enfibfiyag ay Omiila.” ");
INSERT INTO lbk_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isnan nakhosfetana et finmala is kaponchag ay en nanad-alan, ke na't inila nan cheycha'y kamelio ay omal-ali. ");
INSERT INTO lbk_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Osto ay nenmonaang si Rebecca inilana't si Isaac ya nen-epas is kakamelio. ");
INSERT INTO lbk_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Sa na't salodsochen isnan faan Abraham ay mangwanin, “Sino man nan nay omal-ali ay manab-at ken chatako?” “Siya chi nan apok,” kinwanina. Osto'y siya chi ya ket alan et Rebecca ya ap-ap isnan kamesna isnan apongotna. ");
INSERT INTO lbk_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Idwani inokhod nan faa ken Isaac nan am-in ay inangnena. ");
INSERT INTO lbk_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Siya chi et inyey Isaac si Rebecca isnan sikhod ay torcha ay afong ay nentey-an inana, et inasawana. Chadlos nan layad Isaac ken Rebecca et naliwliwa olay mo natey si inana. ");
INSERT INTO lbk_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Inmasawa kasin si Abraham is enngachan si Ketura. ");
INSERT INTO lbk_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Et inyanakna cha Zimran, Jocsan, Medan, Midian, Isbak ya si Sua. ");
INSERT INTO lbk_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Jocsan nan aman cha Seba ken Dedan. Si Dedan nan nalpowan nan cheycha'y makwanin Assurim, Letusim ya nan cheycha'y Leummim. ");
INSERT INTO lbk_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Nan lallalaki ay an-ak Midian et cha Efa, Efer, Hanoc, Abida ya si Eldaa. Nalpo am-in chana ken Ketura. ");
INSERT INTO lbk_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Am-in ay kwan Abraham, inpatawidna ken Isaac. ");
INSERT INTO lbk_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ngem issan sisya'y matatakhowana, wad-ay akhes nan cha na inlayad isnan cheycha'y tap-ina ay an-akna ay lallalaki isnan kasina inasawa. Sa na't inpaeey chaicha is apet falaan si akhew ay en cha entey-an ta maiyadchawi cha ken Isaac. ");
INSERT INTO lbk_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Natakhotakho si Abraham engkhana'y nentawen is sinkhasot ya piton poo ya lima, sa et natey. Khawis nan eteyna tay nalakalakay. ");
INSERT INTO lbk_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Inkaob cha Isaac ken Ismael ay an-akna siya isnan liyang id Macpela isnan oma ay apet falaan si akhew id Mamre, ay sikhod ay kwan Efron ay anak Zohar ay Heteo. ");
INSERT INTO lbk_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Siya chi san oma ay linakwan Abraham ken siya. Ischi nan naikaofan cha Abraham ay sin-asawa. ");
INSERT INTO lbk_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Natey et si Abraham, ya si Isaac nentee isnan sag-en nan makwanin, “Fofon si Enfibfiyag ay Omiila.” Et binindisyonan Apo Dios siya. ");
INSERT INTO lbk_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Idwani, siya chana nan wanen-ed Ismael ay anak Abraham ken Agar ay iyEgipto ay faan asawana'y Sara. ");
INSERT INTO lbk_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Siya chana nan lallalaki ay an-ak Ismael: Si Nebayot nan yon-a, misned si Kedar, sa et cha Adbeel, Mibsam, ");
INSERT INTO lbk_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO lbk_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafis, ya si Kedema ay alilis. ");
INSERT INTO lbk_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Siya chana nan nalpowan nan sinpoo ya chwa ay pangapo, et nan kannay ngachancha nan naingachan isnan ili ay wad-ayancha ya nan enkakampowancha. ");
INSERT INTO lbk_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Natakhotakho si Ismael engkhana'y nentawen is sinkhasot ya tolon poo ya pito, sa et natey. ");
INSERT INTO lbk_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Inmili nan cheycha'y wanen-ed Ismael isnan lota ay nenfet-akan nan Havila ya nan Sur, is apet falaan si akhew id Egipto, isnan chalan ay enpaAsiria. Sinmiyan cha isnan inmiliyan nan tap-in nan wanen-ed Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Naay nan kaokhochan Isaac ay anak Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Entawen si Isaac is epat poo isnan nangasaw-ana ken Rebecca ay akhin Laban ya anak Betuel (ay Arameo ay iMesopotamia). ");
INSERT INTO lbk_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tay ad-i omanak si Rebecca, nenseg-aseg-ang si Isaac ken Dios Apo maipoon ken siya. Sineg-angan Dios Apo si Isaac et naliton si Rebecca. ");
INSERT INTO lbk_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Apik nan inlitona, ya isnan naililitonancha kag cha cha en-onong is kapotona. Sa et kanan Rebecca, “En man chadlos maangnen na ken sak-en ay?” Sa et en nensalodsod ken Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kinwanin et Dios Apo ken siya, “Enchwa ay ili nan ilillitonmo. Et sam ikimen nan chwa ay takho ay at enkhinnola nan wanen-edcha. At mafikfikas nan wanen-ed nan annochi. Siya, nan yon-a et iyapowan nan annochina.” ");
INSERT INTO lbk_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Awni ya inomchan nan enkimenan Rebecca, ya ke na't inyanak nan apik ay lallalaki. ");
INSERT INTO lbk_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Enkilat nan yon-a ya nachotchotan nan am-in ay awakna. Isonga nangadnan si Esau. ");
INSERT INTO lbk_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sa et fomala nan annochi ay mangeegnan isnan pagpakhachan nan yon-a, et nay nangadnan si Jacob. Entawen si Isaac is enem poo issan naiyanakan nan naycha'y apik. ");
INSERT INTO lbk_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Naengngan et nan sin-akhi. Nenfalin ay omaanop si Esau ya is kaponchag nan kad-in nentey-ana. Nay met achi si Jacob et nan kakhigkhinek ay fiyag nan laychena, ya is kakampocha nan kad-in enchonowana. ");
INSERT INTO lbk_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Laylaychen Isaac si Esau tay khankhanasena ay manifo isnan an-anopana. Ngem si Rebecca et si Jacob nan laylaychena. ");
INSERT INTO lbk_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Isnan namingsan, cha entanek si Jacob isnan kotilas. Ket ay sinmaa si Esau ay naowaowat ay namoknag. ");
INSERT INTO lbk_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kinwanina et ken Jacob, “Chadlos ak naowaowat. Omagtan ka man isnan sana'y enkilat ay cham lay-aken.” (Siya na nan khotokna is nangadnan si Esau is Edom.) ");
INSERT INTO lbk_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ket ay kanan Jacob, “Agtak sik-a mo kem et isokat nan kalentekham ay yon-a ay anak.” ");
INSERT INTO lbk_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“Siya man et tay ke ak chadlos matmatey isnan owatko. Ngag kay nan silfin nan kalentekhak ay enyon-a?” kinwanin Esau. ");
INSERT INTO lbk_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Sa et kanan Jacob, “Isapatam achi ona ay ichowam ken sak-en nan kalentekham.” Siya chi't ya nensapata si Esau, et inchowana nan kalentekhana ay kinayon-a ken Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Inagtan et Jacob isnan tinapay ya nan linay-akna. Nangan ya inminom si Esau, sa et komaan. Eg-ayna finalor nan pateg nan kalentekhana ay yon-a ay anak. ");
INSERT INTO lbk_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Idwani wad-ay nan fitil ay inomchan id Canaan ya teken mo nan inomchan ay fitil issan matatakhowan Abraham. Adi kad inmey si Isaac id Gerar ken Abimelec ay alin nan Filisteo. ");
INSERT INTO lbk_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Siya sa tay apchas nenpaila si Dios Apo ken siya ay nangwanin, “Ad-i ka omey id Egipto, mod-i ket itot-oloymo ay entee isna'd Canaan isnan olay entona ay ifaagko ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Wen, entee ka isna, et wad-ay ak ay manatakcho ken sik-a ya bindisyonak sik-a. Et ichowak am-in chana ay ili ken sik-a ya isnan cheycha'y wanen-edmo. Angnek ay angnen nan insapatak ken amam ay Abraham. ");
INSERT INTO lbk_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Pagkhanagkhanakek nan wanen-edmo ta kag cha isnan kaangsan nan tokwifi id chaya, ya at ichowak ken chaicha am-in nan nay ay lota. Ya am-in ay takho isnan lofong et mabindisyonan cha maichalan ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Bindisyonak sik-a tay pinatin Abraham nan kinwanik ya inangnena am-in nan lenteg ya filinko.” ");
INSERT INTO lbk_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Adi kad nentee si Isaac id Gerar. ");
INSERT INTO lbk_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Idwani isnan nensalodsochan nan lallalaki ischi mipoon ken asawana, aped na kinwanin akhina si Rebecca, tay omegyat. Kanana en mo ibfakhana ay asawana siya, et mabfalin ay at pateyencha siya ta alaencha si Rebecca, tay khag-awis nan ilana ay fafai. ");
INSERT INTO lbk_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isnan inmannongancha ischi ya ket osto ay cha entamtam-aw si Abimelec, inilana ay ya ke pet en-asilayad cha Isaac ken Rebecca. ");
INSERT INTO lbk_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Sa na't inpaayag si Isaac ay nangwanin, “Asawam pet siya ya! Em man kinwanin sin-akhi kayo ay?” Ke na't insongfat ay nangwanin, “Kanak man en ta ket lang ya mapatey ak mo ifaagko ay asawak siya.” ");
INSERT INTO lbk_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","“Ngag kan na is inangnem ken chakami?” kinwanin Abimelec. “To! at achi koma malanoy nan aped mangiseypan nan esa'y takhok ken asawam mo san ya! Ya et sik-a nan khotok nan enfasolanmi!” ");
INSERT INTO lbk_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Siya chi ya ket finagfag-an Abimelec am-in nan takhona: “Olay sino issa nan mangis-isik ken chaton-a ay sin-asawa et maipapatey.” ");
INSERT INTO lbk_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isnan kawad cha Isaac isnan chey ay ili, cha cha nensama, ya isnan chey ay tawen ad-acha nan inanina tay maminkhasot nan kaad-achana isnan chey inis-ekcha, tay binindisyonan Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nentot-oloy nan sinomyaan nan fiyagna ya finmaknafaknang. ");
INSERT INTO lbk_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tay angsaangsan nan karnilo, faka ya faana, inmapal et nan cheycha'y Filisteo ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Et khinab-onancha nan am-in ay fofon ay sikhod ay kinaofan nan cheycha'y faan amana ay Abraham issan natatakhowana. ");
INSERT INTO lbk_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ya ket kinwanin Abimelec ken Isaac, “Komaan ka et isnan ilimi, tay nay nenfalin kayo ay mafikfikas mo chakami.” ");
INSERT INTO lbk_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Siya chi ya ket nen-aton cha Isaac isnan kadchalolog id Gerar, et ischi nan nentey-ancha. ");
INSERT INTO lbk_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","s Kasin inpakaobna nan cheycha'y fofon ay nakaofan issan sisya'y matatakhowan Abraham, ngem issan nateyana awni ya ket khinab-onan kasin nan cheycha'y Filisteo. Et khechangna'y inpangachan Isaac nan inpangachan amana isnan cheycha'y fofon. ");
INSERT INTO lbk_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Kinmaob kasin nan cheycha'y faan Isaac is fofon isnan chalolog ay kawadcha, et wad-ay nan inchanancha ay chanom. ");
INSERT INTO lbk_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ngem awni ya ket ay nakisoma nan cheycha'y enpaspastor ay iGerar isnan cheycha'y papaspastolen Isaac. Kinwanicha, “Nan nay ay chanom et chanommi na!” Tay siya chi, nginadnan et Isaac nan chey ay fofon is Soma. ");
INSERT INTO lbk_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kasin kinmaob nan cheycha'y takhon Isaac is teken ay fofon, nay met achi finmala kasin nan soma. Siya akhes chi nan nenngadnan Isaac ischi is Khola. ");
INSERT INTO lbk_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Khinmeg-ed kasin cha Isaac ya kinmaob kasin is teken ay fofon. Maid chadlo finmala is sosma isnan nangaofancha ischi, nay et inpangachan Isaac chi is Wayawaya. Kinwanina, “Nay et inagtan Dios Apo chatako is nawaya ay entey-an chadlo isnan nay ay lota. At enkhagkhawis tako isna.” ");
INSERT INTO lbk_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Awni ya ket nen-aton cha Isaac et inmey cha id Beerseba. ");
INSERT INTO lbk_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Isnan chey kannay ay lafi nenpaila si Dios Apo ken siya ay nangwanin, “Sak-en nan Dios amam ay Abraham. Ad-i ka omegyat, tay wad-ay ak ken sik-a. At bindisyonak sik-a ya at pagkhanagkhanakek nan wanen-edmo khapo isnan inkalik ken Abraham ay faak.” ");
INSERT INTO lbk_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Tinmoping si Isaac ischi si altar et nenchayaw ken Dios Apo. Khinmaeb is nenkampowancha, sa et kinmaob nan faana is fofon ischi. ");
INSERT INTO lbk_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Awni ya ket inmey si Abimelec ay nalpo id Gerar ay mangila ken Isaac. Kadwana si Ahuzzat ay manogtokhon ken siya ya si Ficol ay apon nan sorchachona. ");
INSERT INTO lbk_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kinwanin et Isaac, “En kayo man inmali ay? Ya ngag man mo lomilikhet kayo ya inmipakaan kayo isnan iliyo?” ");
INSERT INTO lbk_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Sa cha't kanan, “Idwanin ammomi ay wad-ay si Dios Apo ken sik-a, ya kananmi ay khawis koma mo matotya tako ta khab-en tako nan pechen. Laychenmi ay ikkalim ");
INSERT INTO lbk_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ta sa ka ad-i omis-isik ay kag akhes isnan inangnenmi ay egay nangis-isik ken sik-a. Khinagkhawismi sik-a ya inpaligwatmi sik-a ay enkhagkhawis. Idwanin, chadlos maiila ay binindisyonan Dios Apo sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Sa et inpiyastaan Isaac chaicha, et nangan ya inminom cha. ");
INSERT INTO lbk_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Isnan kawiitana waschin et nangisapata isnan inkalina. Kakwasana, inpaligwat Isaac chaicha et nasisyan cha ya wad-ay et ornoscha. ");
INSERT INTO lbk_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Isnan chey ay akhew, inomchan nan faan Isaac ay nangifaag mipoon isnan kinaofancha ay fofon. Kinwanicha, “Wad-ay nan inchananmi ay chanom.” ");
INSERT INTO lbk_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Idwani nginadnan Isaac nan chey fofon is Seba. Siya na nan inangnen nan ili ay Beerseba ay nangadnan. ");
INSERT INTO lbk_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isnan nentawenan Esau is epat poo inasawana nan chwa'y mamagkit ay Heteo: si Judit ay anak Beeri ya si Basemat ay anak Elon. ");
INSERT INTO lbk_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Chaicha nan maikhapowan nan ensikhafan nan semek cha Isaac ken Rebecca ay katokhangancha. ");
INSERT INTO lbk_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Nalakalakay et si Isaac ya ad-i makaila. Idwani inpaayagna si Esau ay yon-a isnan an-akna sa na't kanan, “Anak.” “Naay ak, ama,” insongfat Esau. ");
INSERT INTO lbk_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kinwanin Isaac, “Ilaem, nalakay ak et ya ad-i kaammowan nan mateyak. ");
INSERT INTO lbk_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Alaem nan pantolaymo ta en ka manganop. ");
INSERT INTO lbk_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Sam et otowen isnan mam-is ay oto ay laylaychek, sam et khaowen ta kanek. Et mo nakakkanan ak sak et bindisyonan sik-a isnan sisya'y matatakhowak.” ");
INSERT INTO lbk_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Idwani wad-ay pet si Rebecca ay mamannge isnan cha kanan Isaac ken Esau. Ya isnan en nanganopan Esau, ");
INSERT INTO lbk_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","kinwanin Rebecca ken Jacob, “Chinngek nan kinwanin amam isnan yon-am. Kinwanina, ");
INSERT INTO lbk_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘En ka manganop si otowem is mam-is ay sibfak. Et mo makakanan ak sak et bindisyonan sik-a isnan sakhang Dios Apo isnan sisya'y matatakhowak.’ ");
INSERT INTO lbk_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Idwanin, anakko, chengngem nan kanak ya angnem nan ifaagko. ");
INSERT INTO lbk_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","En ka isnan kawad nan cheycha'y karching ta piliyem nan chwa'y alaalarmes ay innanak ta otowek isnan mam-is ay oto ay laylaychen amam, ");
INSERT INTO lbk_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","sam et iyey ta sibfana ta sa na't bindisyonan sik-a isnan sisya'y matatakhowana.” ");
INSERT INTO lbk_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Nay met achi kinwanin Jacob ken inana, “Ya ke nanginchochotchot si Esau ya! Ngem maid chotchot nan kopkopko. ");
INSERT INTO lbk_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mo komappos si ama ya maammowana ay chak pet fab-aliyan siya, at faken et nan mabindisyonak is pad-anek, mod-i ket nan madchosaak.” ");
INSERT INTO lbk_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sa et kanan inana, “Ngag ngotom ta sak-en nan somakhongan nan chosa, anakko. Angnem et yangkhay nan ifaagko. En ka't alaen nan cheycha'y innanak si karching.” ");
INSERT INTO lbk_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Et en inalan Jacob nan cheycha'y karching, sa na't inyey ken inana ay nangoto isnan mam-is ay oto ay laylaychen Isaac. ");
INSERT INTO lbk_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Sa et alaen Rebecca nan cheycha'y kakhawisan ay fachon Esau ay yon-a ay iniigtona ya inpafachona ken Jacob ay annochi. ");
INSERT INTO lbk_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Sa na't inpey nan kochil san karching isnan liman Jacob ya is kafakhangna ay maid chotchot. ");
INSERT INTO lbk_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Sa na't inchowa ken Jacob nan khinaona ay mam-is ay ischa ya nan tinapay ay inotona. ");
INSERT INTO lbk_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Sa et alan Jacob ya eey ken amana. Sa na't kanan, “Ama.” “Ay?” insongfat Isaac. “Sino ka anakko?” ");
INSERT INTO lbk_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","“Sak-en si Esau. Nan yon-a isnan an-akmo,” insongfat Jacob. “Inangnek nan infilinmo. Fomangon ka et man, tay naay nan inotok ay inanopak. Mangan ka ta sa ka't bomindisyon.” ");
INSERT INTO lbk_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","“Ya ke sin-ak-itan yangkhay nan en ka nanganopan ya ke ka't sa na'y sinmaa kannay anakko?” kinwanin Isaac. “Finmachang si Dios Apo ay Diosmo,” insongfat Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","“Somag-en ka ed ta kapokapek sik-a. Sik-a ngen tet-ewa si Esau?” kinwanin Isaac. ");
INSERT INTO lbk_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Sinmag-en tet-ewa si Jacob ken amana, et kinapokap Isaac nan anakna ay nangwanin, “Kag kalin Jacob nan kalim, ngem ya ke liman pet Esau nan limam.” ");
INSERT INTO lbk_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Eg-ayna finigfig ay si Jacob chi tay nanginchochotchot nan limana ay kag ken Esau. Isnan nganngani bindisyonana si Jacob, ");
INSERT INTO lbk_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","kasina't sinalodsod ay nangwanin, “Ay tet-ewa ngen ay si Esau ka?” “Wen, sak-en,” insongfat Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kinwanin et Isaac, “Yaim et nan inotom ay inanopam, ta mangan ak sak et bindisyonan sik-a.” Sa et inyey Jacob et nangan, ya inchoona akhes nan fayas ya inminom. ");
INSERT INTO lbk_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kinwanin amana, “Somag-en ka anakko ta fomisito ka.” ");
INSERT INTO lbk_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Isnan sinmag-enan Jacob ay namisito ken amana, sinongsong et Isaac nan akhob nan fachona ke na't ay bindisyonan ay nangwanin, “Nan khag-awis ay sayongosong nan anakko et kag isnan sayongosong nan ponchag ay binindisyonan Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Asop ya kad-in ebfen Apo Dios nan lotam isnan ormo ay malpo id chaya ya igwana ken sik-a nan malweb ay lota! Asop ya pafegkhasena nan isamam ya ta lomifas nan fayasmo. ");
INSERT INTO lbk_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Asop ya ichowana nan takho isnan kailiili ay ensilfi ken sik-a. Asop ya enfalintomeng cha am-in ay mangipaila ay naiyornos cha ken sik-a. Iyapowam nan iib-am. Asop ya nan wanen-ed inam et enfalintomeng cha ay mangipaila ay patpatiyencha sik-a. Machosa koma nan cheycha'y mangamsiw ken sik-a, ya mabindisyonan nan cheycha'y mamindisyon ken sik-a!” ");
INSERT INTO lbk_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kinmaan et si Jacob isnan kakwasan nan namindisyonan Isaac ken siya. Ket ay osto ay kakak-aan si Jacob ya sa na et si Esau ay kasas-aa ay nanganop. ");
INSERT INTO lbk_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Sa et akhes inmoto is mam-is ay oto sa na't ala ya eey ken amana ay nangwanin, “Fomangon ka et man, tay naay nan inotok ay inanopak. Mangan ka ta sa ka't bomindisyon.” ");
INSERT INTO lbk_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“Sino ka mampet?” sinalodsod Isaac. “Si Esau ak. Nan yon-a isnan an-akmo,” kinwanin Esau. ");
INSERT INTO lbk_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ya ket ay chadlos enpap-ayegpeg si Isaac ay nangwanin, “Sino mampet nan nangiyali isnan inanopana ay apchas ko sinibfan, awni ya ke ka't wad-ay? Apchas ko et achi inchawchaw ken siya nan bindisyon, ya nay maangnen ay maangnen ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Isnan nanngelan Esau isna, ke na't inpapangekhe ay nen-akha ya chadlos nenngegngeg ay nangwanin, “Bomindisyon ka achi akhes ama!” ");
INSERT INTO lbk_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","“Inmali nan annochim ay sinmailo, et apchas na inala nan ento mo ichowak ken sik-a ay bindisyon,” kinwanin Isaac. ");
INSERT INTO lbk_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","“Maikadwa et na is lomokwalokwana. Amfoyakas pet si Jacob nan ngachana. Inalana nan kalentekhak ay enyon-a. Ya chey, inalana kayet nan kabindisyonak. Maid ngen paat nakhayad is ichawchawmo ay bindisyon ken sak-en, ama?” ");
INSERT INTO lbk_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Sinmongfat si Isaac ay mangwanin, “Apchas ko't pay inpey siya ay mangiyapo ken sik-a, ya nenfalinek ay faana nan am-in ay iib-ana. Inchowak et ken siya nan lomwefan nan molana ya nan lomifasan nan fayasna. Maid et achi mabfalin ay ichawchawko ken sik-a, anakko!” ");
INSERT INTO lbk_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Intoloy Esau ay nenseg-aseg-ang ken amana ay nangwanin, “Ay ke es-esang ngen yangkhay nan mabfalin ay ichawchawmo ay bindisyon? Bindisyonam akhes sak-en achi ama!” kinwanina ay nangipapangekhe ay en-akha. ");
INSERT INTO lbk_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kinwanin et Isaac ken siya, “Chey, ilam. At adchawi nan entey-am isnan malweb ay lota. Ya at maid ormo ay malpo'd chaya is mangfe isnan lotam. ");
INSERT INTO lbk_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","At nan fadyok nan ikatakhom ya at enfaan nan annochim sik-a. Nay met achi mo iyangam ay mangonong ken siya, et mabfalin ay maikasiw ka isnan kamabfalina.” ");
INSERT INTO lbk_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Liligten et Esau nan annochina tay isnan bindisyon ay inchowan amacha ken Jacob. Kinwanin Esau, “Ad-i fali tay nganngani et ay matey si ama. Et sak pateyen si Jacob.” ");
INSERT INTO lbk_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Nay met achi naifaag ken Rebecca nan semsemken Esau, ya inpaayagna si Jacob ay mangwanin, “Anak. Chey, liwliw-en Esau nan semekna ay mangwanin pateyena sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Idwani mampay anakko, angnem nan ifaagko. Enligwat ka ta lomayaw ka kannay ay omey id Haran is ken Laban ay etadko. ");
INSERT INTO lbk_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kanatee ka ken siya engkhana ay mafaew nan songet nan yon-am. ");
INSERT INTO lbk_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","At awni't khechangna'y malichongana nan inangnem ken siya. Et sak komwani is en mangayag ken sik-a. Ad-ik laychen ay mamaid kayo ay chwa ay an-akko isnan esa'y akhew.” ");
INSERT INTO lbk_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Sa et kinwanin Rebecca ken Isaac, “Ke ak chadlo maoma isnan mangmangili ay asaswan Esau. Mo mangasawa akhes si Jacob isnan esang isnan naycha'y fabfafai ay Heteo, ngag et nan fongaek ay matatakho?” ");
INSERT INTO lbk_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Sa et inayakhan Isaac si Jacob sa na't binindisyonan ya infilina ken siya ay mangwanin, “Ad-im as-asaw-en nan iCanaan. ");
INSERT INTO lbk_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Enligwat ka et ta omey ka id Mesopotamia ken ikitmo ay Betuel ta siya's mangasaw-am isnan esa isnan cheycha'y an-ak alitaom ay Laban. ");
INSERT INTO lbk_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Asop ya si Apo Dios ay Makabfalin Am-in et bindisyonana sik-a ya pagkhanagkhanakena sik-a ta enfalin ka ay aman nan katakhotakho isnan angsan ay ili! ");
INSERT INTO lbk_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Asop ya bindisyonana sik-a ya nan wanen-edmo ay kag isnan namindisyonana ken Abraham, ta sam enkwa nan nay ay lota ay nentetey-am ya inchowan Apo Dios ken Abraham!” ");
INSERT INTO lbk_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Siya chi et inpaligwat Isaac si Jacob ay omey id Mesopotamia ken Laban ay anak Betuel ay Arameo ya akhin Rebecca ay inan cha Jacob ken Esau. ");
INSERT INTO lbk_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Idwani ket ay inammowan Esau nan namindisyonan Isaac ken Jacob ya nan nangipaligwatana ken siya ay omey id Mesopotamia ay en omanap sid-i is asawaena. Inammowana akhes ay issan namindisyonana ken Jacob, et infilina akhes kannay ta ad-i mangas-asawa isnan iCanaan. ");
INSERT INTO lbk_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Inammowana ay pinatin Jacob cha amana ken inana ya inmey id Mesopotamia. ");
INSERT INTO lbk_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Naawatan Esau ay ad-i pet laychen Isaac nan fabfafain si iCanaan, ");
INSERT INTO lbk_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","et nay inmey ken Ismael ay anak Abraham, ya inmasawa is esang kayet ay si Mahalat, ay akhin Nebayot ay anak Ismael. ");
INSERT INTO lbk_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Tinaynan Jacob id Beerseba ya nenligwat ay omey id Haran. ");
INSERT INTO lbk_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ya isnan nalonokhan nan akhew ket ay inomyan isnan inomchanana. Inmala is fato ischi ay nenponganana ya naseyep. ");
INSERT INTO lbk_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nen-it-itaw si Jacob et inilana nan agchan ay enpatikid id chaya, ya ket wad-ay nan angheles ay cha manikid ya cha pomanad ischi. ");
INSERT INTO lbk_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ya wad-ay akhes si Dios Apo ay manatakcho ken siya. Kinwanina, “Sak-en nan Apo ay Dios Abraham ya si Isaac. Nan nay ay lota ay maseseypam et ichowak ken sik-a ya isnan wanen-edmo. ");
INSERT INTO lbk_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","At kag chapog isnan lota nan kaangsan nan cheycha'y wanen-edmo ya maiwalas cha isnan olay entona issa, ya at bindisyonak nan am-in ay ili maichalan ken sik-a ya nan wanen-edmo. ");
INSERT INTO lbk_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Sesemkem ay at wad-ay ak ken sik-a ya isas-alakak sik-a isnan am-in ay omayam. At isakhongko sik-a isnan nay ay lota. Ad-ik og-ogkhayen sik-a mod-i ket tatakchowek sik-a ay mangangnen isnan am-in ay inkalik ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ket ay nenlikna si Jacob sa na't kanan, “To! Wad-ay pet nan Dios Apo isna! Ke pet wad-ay siya isna ya ad-ik am-ammo!” ");
INSERT INTO lbk_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Inmegyat sa na't kanan, “Ya ke pet kakaegyat na's lota ay! Maid kasin teken ay nen-afong sina mod-i ket si Apo Dios ya siya na nan segpan ay omey id chaya!” ");
INSERT INTO lbk_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Sa et isnan nawiitana finmangon si Jacob. Inalana san fato ay pinonganana sa na't tinood ay panemsemkana. Sa na't finokfokan isnan lana ta ichoona ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Et nginadnana nan chey ay lota is Betel. (Luz nan sikhod ay ngachan nan ili ay sag-en san inomyanana.) ");
INSERT INTO lbk_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Sa et insapatan Jacob ken Apo Dios ay nangwanin, “Mo wawawawad-ay ka ken sak-en ay omisas-alak isnan nay ay chak enfaatan, ya sa ka't pomakan ya fomacho, ");
INSERT INTO lbk_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ya pasakhongem sak-en ay enkhagkhawis isnan afong ama, et sik-a Dios Apo nan enDiosko. ");
INSERT INTO lbk_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nan nay fato ay tinoodko ay panemsemkan et siya nan enchad-ayawan ay afongmo, ya at ichowak ken sik-a nan pagkapoon nan am-in ay cham ichowa ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Intoloy Jacob ay nenfaat et inmey isnan ili ay apet falaan si akhew. ");
INSERT INTO lbk_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ya ket ay inilana nan fofon is kaponchag ay kawad nan tolo'y pangfon si karnilo ay inoomfon isnan lilwes nan fofon. Siya chi nan maipain-inoman nan karnilo, et wad-ay nan chakchakowag ay fato ay tangebna. ");
INSERT INTO lbk_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Et mo naamoamong cha't am-in nan cheycha'y karnilo ischi, omey cha nan enpaspastor ay mangolin isnan fato ta painomencha nan karnilocha, sa cha't kasin tangfan. ");
INSERT INTO lbk_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","“Ento man nan iliyo ay kakakyong?” sinalodsod Jacob isnan cheycha'y enpaspastor. “iHaran kami,” insongfatcha. ");
INSERT INTO lbk_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“Ay ammoyo ngen si Laban ay anak Nahor?” kinwanina. “Wen, ammomi,” kanancha. ");
INSERT INTO lbk_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Ay enkhagkhawis ngen?” “Wen enkhagkhawis,” kinwanicha. “Ilaem, naay nan magmagkitna ay si Raquel ay mangiyali isnan karnilocha.” ");
INSERT INTO lbk_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kinwanin Jacob, “Ya ke masapa ay? Misoyaw ya! Aw-awni sa yo aponen nan karnilo. En yo man et ad-i painomen chaicha ta sa yo't en paanglochen kasin chaicha ay?” ");
INSERT INTO lbk_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Sa cha't kanan, “Ad-i achi mabfalin tay engkhana ona ay wad-ay am-in nan enpaspastor ya nan karnilocha isna, esa pay maolin nan tangeb nan fofon ya sa mi't painomen chaicha.” ");
INSERT INTO lbk_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Sisya'y cha kayet makitot-oya si Jacob ya ket wad-ay et si Raquel ay mangiyali isnan karnilocha ay ipaspastorna. ");
INSERT INTO lbk_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Osto ay inilan Jacob nan kafabfaiyana ay si Raquel ya nan karnilon alitaona ay Laban, ya ket inmey is kafofon ay nangolin isnan tangebna ya inpainomna nan cheycha'y karnilo. ");
INSERT INTO lbk_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Sa na't fisitowen si Raquel ya nen-akha isnan lagsakna. ");
INSERT INTO lbk_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Kinwanina, “Sak-en nan kaanakan amam, ya anak Rebecca.” Alan et Raquel ya tagtag ay en nangifaag ken amana. ");
INSERT INTO lbk_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Et issan nanngelan amana mipoon ken Jacob ay kaanakana, natanagtag ay en manab-at ken siya, sa na't ala ya kawe ya fisito ken siya, sa na't isaa. Isnan nangokhochan Jacob isnan am-in ay inmat, ");
INSERT INTO lbk_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","kinwanin Laban, “Wen, tet-ewa, chadlos ta sinpangib-a. Awakko ya chalak sik-a.” Et nentee si Jacob ischi is esa'y fowan. ");
INSERT INTO lbk_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kinwanin Laban ken Jacob, “Ad-i khapo tay sin-ama ta ya aped ka enchonchono ken sak-en ay maid lagfom. Kaat pay nan laychem ay lagfom?” ");
INSERT INTO lbk_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Idwanin, wad-ay nan chwa ay magmagkit Laban: si Lea ay yon-a ya si Raquel ay annochi. ");
INSERT INTO lbk_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Khag-awis nan matan Lea ngem khag-awis nan awak Raquel ya kalal-ayad. ");
INSERT INTO lbk_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tay chachama nan layad Jacob ken Raquel, kinwanina, “Enchono ak is pito'y tawen ken sik-a mo ichowam si Raquel ay en-asawak.” ");
INSERT INTO lbk_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Sinmongfat si Laban ay nangwanin, “Khagkhag-awis mo sik-a's mangipaasaw-ak ken siya mo nan teken. Makitee ka't ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Sa et nenchono si Jacob is pito ay tawen ta mangasaw-ana ken Raquel, et kag yangkhay akit ay akhew chi ken siya tay isnan chadlos ay layadna ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Awni ya ket ay kinwanin Jacob ken Laban, “Nay et nakwas nan pito'y tawen. Asaw-ek et achi nan anakmo!” ");
INSERT INTO lbk_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Adi kad nenpakasar et si Laban ya inayakhana am-in nan omili ischi. ");
INSERT INTO lbk_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Nay met achi isnan chey ay lafi, ento mo si Raquel ya ket ay si Lea nan inyey Laban ken Jacob. Et inchipan Jacob siya. ");
INSERT INTO lbk_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Inchowan akhes Laban nan faana ay si Zilpa ken Lea ta enkafachangna.) ");
INSERT INTO lbk_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Eg-ay inam-ammowan Jacob ay ya ke pet si Lea nan inchipana engkhana'y nawiit. Ala na't ya eey ken Laban ay nangwanin, “Ngag man chi's inangnem ken sak-en? Nenchono ak ta asaw-ek si Raquel ya ke ka't ay linmoko?” ");
INSERT INTO lbk_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Kinwanin et Laban, “Wen, tay isnan ekhad isna, ad-i mabfalin ay mang-ona nan annochi ay paafongen nan ama esa pay nan yon-a. ");
INSERT INTO lbk_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Awni ta makwas ona nan nay ay chomingkho ay am-among sak et ichowa si Raquel, mo kasin ka enchono ken sak-en is pito kayet ay tawen.” ");
INSERT INTO lbk_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Tinan-oyan Jacob chi et isnan nakwasan san chomingkho ay am-among si kasar, inchowan Laban si Raquel ken Jacob ta en-asawana. ");
INSERT INTO lbk_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Inchowan akhes Laban nan faana ay si Bilha ken Raquel ta enkafachangna.) ");
INSERT INTO lbk_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Adi kad idwanin, inseyep et akhes Jacob si Raquel, et wadwad-ay ay linaylayadna siya mo si Lea. Sa et nenchono kasin ken Laban is pito kayet ay tawen. ");
INSERT INTO lbk_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Isnan nangil-an Dios Apo ay akit nan layad Jacob ken Lea, inpakhanakna siya. Ngem si Raquel maid paat anakna. ");
INSERT INTO lbk_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Naliton si Lea et inmanak is lalaki. Ke na't kanan, “Inilan Dios Apo nan likhatko, et idwanin at lomaylayad chadlo si asawak.” Siya na nan khotokna ay nginadnana nan anakna is Ruben. ");
INSERT INTO lbk_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Naliton kasin si Lea ya inmanak kayet is lalaki. “Inchowan kayet Dios Apo nan nay anakko tay chinngena ay ad-i ak malal-ayad,” kinwanina. Adi kad nginadnana't is Simeon. ");
INSERT INTO lbk_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kasin kayet naliton, et lalaki kayet nan inyanakna, sa na't kanan, “Idwani at nakapet si asawak ken sak-en tay tolo et ay lallalaki nan inyanakko ken siya.” Isonga nginadnana is Levi. ");
INSERT INTO lbk_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Naliton kasin ya inyanakna nan ikap-at ay lalaki, sa na't kanan, “Idwani ichad-ayawko si Dios Apo.” Khapo tay siya chi nginadnana nan onga is Juda. Awni pay ya ket tinmoyeng nan en-anakana. ");
INSERT INTO lbk_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Isnan nangil-an Raquel ay maid anakcha ken Jacob ya ket inmapal ken yon-ana. Kinwanina't ken Jacob, “Omagtan ka is anakko. Tay mo ad-i ka et matey ak.” ");
INSERT INTO lbk_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Sinmonget si Jacob ken Raquel sa na't kanan, “Ay ke ak man Dios? Siya met nan nangiyad-i isnan enlitonam.” ");
INSERT INTO lbk_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kinwanin Raquel, “Naay si Bilha ay faak. Idchipam ta way anakko ay malpo ken siya. Ta siya chi ay makwani ak ay ina maichalan ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Adi kad inchowana si Bilha ken Jacob et inseyepna. ");
INSERT INTO lbk_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Naliton si Bilha et inyanakna nan esa'y lalaki ay winad-ay Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kinwanin et Raquel, “Nay et chadlo inmagtan si Apo Dios is kalentekhak, et chinngena nan segseg-angko ya nay et inmagtan is anakko ay lalaki.” Siya chi nan khotokna ay nginadnana nan chey ay onga is Dan. ");
INSERT INTO lbk_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Naliton kasin si Bilha et inyanakna kasin nan esang kayet ay lalaki ay anakna ken Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Kinwanin Raquel, “Nakiapes ak ay ostoosto ken yon-ak et nay nangafak ak.” Isonga nginadnana is Neftali. ");
INSERT INTO lbk_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Isnan nangil-an Lea ay tinmoyeng et nan en-anakana, inchowana't nan faana ay si Zilpa ken Jacob ta asaw-ena. ");
INSERT INTO lbk_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Sa et inmanak si Zilpa is lalaki. ");
INSERT INTO lbk_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ya ket kinwanin Lea, “Naoney ak mampet!” Siya chi't nginadnana nan onga is Gad. ");
INSERT INTO lbk_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Inmanak kasin si Zilpa is lalaki ay anakna ken Jacob ");
INSERT INTO lbk_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","sa et kanan Lea, “Aye pay nan lagsakko! Idwanin at kanan nan fabfafai ken sak-en, nalagsak ak.” Siya chi et nginadnana nan onga is Aser. ");
INSERT INTO lbk_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Awni ya isnan timpon si ani finmoknag si Ruben ya ket ay wad-ay nan inchasana ay mandragoras sa na't insaa ken inana ay Lea. Kinwanin et Raquel ken yon-ana, “Omagtan ka man isnan mandragoras nan anakmo?” ");
INSERT INTO lbk_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ket ay kanan Lea, “Ay ad-i ngen omanay nan nangokatam ken asawak? Idwani akhes ya laychem kayet ay alaen nan mandragoras nan anakko!” Kinwanin et Raquel, “Mo ichowam nan mandragoras nan anakmo et ipalofosko ay makiseyep ka ken Jacob is maschem.” ");
INSERT INTO lbk_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Osto'y sedsechemna ay cha somaalan Jacob ay namoknag, en sinab-at et Lea ay mangwanin, “Makiseyep ka ken sak-en idwani ay maschem, tay finayachak sik-a ken Raquel isnan mandragoras nan anakko.” Et siya chi ay inseyep Jacob si Lea issan chey ay lafi. ");
INSERT INTO lbk_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Chinngen Apo Dios nan segseg-ang Lea et naliton ya inkimena nan ikalima ay anakna ay lalaki. ");
INSERT INTO lbk_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kinwanin et Lea, “Siya na nan finongak ken Apo Dios tay inchowak nan faak ken asawak.” Tay siya chi nginadnana't nan onga is Issacar. ");
INSERT INTO lbk_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Naliton kasin si Lea et inkimena nan lalaki kayet ay mikan-em ay anakna ken Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Sa na't kinwanin, “Khag-awis nan inlayad Apo Dios ken sak-en. Idwani, et chadlo patkhen asawak sak-en tay nay enem et ay lallalaki nan inyanakko ken siya.” Et nginadnana is Zabulon nan mikan-em ay anakna. ");
INSERT INTO lbk_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Awni pay ya ke na't ikimen nan esa'y fafai ay nginadnana is Dina. ");
INSERT INTO lbk_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Sa et sisinmek akhes Apo Dios si Raquel ya chinngena nan lowalona et inpalofosna ay mawad-ayan si anakna. ");
INSERT INTO lbk_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Adi kad naliton et inyanakna nan lalaki, sa na't kanan, “Kinaan chadlo Apo Dios nan kaang-angowak isnan inmagtanana is anakko. ");
INSERT INTO lbk_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Asop ya omagtan kayet is anakko ay lalaki.” Adi kad nginadnan et Raquel nan anakna is Jose. ");
INSERT INTO lbk_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Issan naiyanakan Jose, kinwanin et Jacob ken Laban, “Mo kem palofosen sak-en ta somaa ak isnan chadlos ko ili. ");
INSERT INTO lbk_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ipalofosmo koma ay itakinko nan an-akko ya nan asaswak ay finayachak isnan chak nenchonchonowan ken sik-a, ta sa kami't omey. Ammom met ay khawis nan inangnek ay nenchono ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Sa et kinwanin Laban, “Chengngem koma nan nay kanak. Inammowak isnan cheycha'y en-ila ay binindisyonan Dios Apo sak-en khapo ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Isonga ifaagmo et nan laychem ay lagfom et sak ichowa.” ");
INSERT INTO lbk_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Insongfat Jacob ay nangwanin, “Ammom mo ngag nan kasasaad nan chonok ken sik-a, ya inilam nan inmang-angsanan nan enkik-iwiyem isnan chak nangipaspastolan. ");
INSERT INTO lbk_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Akit nan kwam issan inmaliyak, ket ay idwani ya ke cha't chadlos inmangsaangsan, tay binindisyonan Dios Apo sik-a isnan am-in ay chak inang-angnen. Idwani, timpo na't ay siya mo anapek et akhes nan khomawisanmi ay sinpangafong.” ");
INSERT INTO lbk_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“Ngag nan ilagfok ken sik-a?” kinwanin Laban. “Faken lagfo is kedchawek. Itoloyko ay talaknen nan enkik-iwiyem mo abfoloyam nan laychek. ");
INSERT INTO lbk_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ipalofosmo ta omey ak idwani ay akhew isnan cheycha'y enkik-iwiyem ta isiyanko nan am-in ay inngitit ay innanak si karnilo ya nan am-in ay nalablabfangan paymo namatmatikan ay innanak si karching, ta kecheng chachi is kedchawek ay lagfok. ");
INSERT INTO lbk_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Et is tap-in at nalaka nan mangammowam mo tet-ewa ay osto ak. Et mo omali ka ay mangila isnan lagfok ya way faken lafang paymo namatmatikan ay karching paymo ad-i inngitit ay karnilo, at ammom ay inakewko chachi.” ");
INSERT INTO lbk_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Siya achi! Mo siya sa's kanam ay angnenta et siya.” ");
INSERT INTO lbk_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nay met achi isnan chey kannay ay akhew alan et cha Laban ay sin-am-a ya pilipili isnan cheycha'y laki ay karching ay nenkakhag-alitan paymo lafang, ya nan am-in ay fai ay karching ay namatmatikan ya lafang paymo nan wad-ay pokpokawna, ya nan am-in ay inngitit ay karnilo, sa na't inpatokkhong chachi isnan an-akna ay lallalaki. ");
INSERT INTO lbk_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Sa cha't nen-ikaan chana ay nangiyadchawi ken Jacob. Et inyeycha isnan ad-adchawi ay tolo ay akhew nan machad-alan. Et tinalaken Jacob nan nataynan ay karnilo ya karching Laban. ");
INSERT INTO lbk_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Inmala si Jacob isnan al-alangta ay sangan si kaew ay makwanin alamo, almendras, ya kastano, sa na't kinoskosan nan tapin nan sipsipna ta kag nakhag-alitan nan ilacha. ");
INSERT INTO lbk_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Sa na't inpadsek nan naycha'y kag nakhag-alitan ay sanga is kasakhang nan omin-inoman nan karnilo ya karching, tay ischi nan en-edchamancha mo en cha ominom. ");
INSERT INTO lbk_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Adi kad mo en-echam nan karching isnan sakhang nan cheycha'y sanga et nenkakhag-alitan, namatmatikan ya nalablabfangan nan iyanakcha. ");
INSERT INTO lbk_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ngem nan cheycha'y karnilo, et tinlad Jacob isnan cheycha'y karching, tatno isnan en-edchaman cha et ipasakhangna chaicha isnan kawad nan nakhag-alitan paymo inngitit ay enkik-iwiyen Laban. Siya na nan inangnena ay nangipaangsan isnan cheycha'y karnilo ya karchingna. Sa na't insiyan chachi isnan cheycha'y kwan Laban. ");
INSERT INTO lbk_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sa et akhes mo cha manini nan cheycha'y enkekedse ay talaken, inpey Jacob nan cheycha'y nakhag-alitan ay sanga isnan omin-inomancha ta isnan sakhang nan sanga nan en-edchamancha. ");
INSERT INTO lbk_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ngem faken chi is inangnena isnan cheycha'y nakoyyot ay talaken. Awni pay ya ket ay nenkwan et Laban nan am-in ay nenkakoyyot, ya nenkwan et akhes Jacob nan am-in ay komekedse. ");
INSERT INTO lbk_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Et kag tona nan inangnen Jacob ay finmaknafaknang. Angsan nan karnilo, karching, faa, kamelio ya dangki. ");
INSERT INTO lbk_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Awni ya ket chinngen Jacob ay cha kankanan nan lallalaki ay an-ak Laban, “Inalan Jacob nan am-in ay kwan amami. Nalpo ken ama nan am-in ay infaknangna.” ");
INSERT INTO lbk_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nadlaw akhes Jacob ay tinmeken si Laban ken siya, tay ad-i et khawis nan pinang-ilana ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kinwanin et Dios Apo ken siya, “Somakhong ka et chadlo isnan nalpowam ay ilin nan am-ayo ya isnan cheycha'y papangafongmo. At wad-ay ak ay manatakcho ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Adi kad finmaa et si Jacob is en mangwani ken cha Raquel ken Lea ta ilaencha siya is kaponchag ay cha na enpaspastolan. ");
INSERT INTO lbk_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Kinwanina ken chaicha, “Nadlawko ay nenfaliw si amayo, ya ad-i et khawis nan pinang-ilana ken sak-en. Nay met achi nan Dios amak et wawawawad-ay ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ammoyo met ay inpeyko am-in nan kafaelak ay nensilfi ken amayo. ");
INSERT INTO lbk_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ngem linmoko ya naminsinpoo ay finalibfaliwana nan lagfok. Egay magtek yangkhay inpap-alofos Apo Dios siya ay omisik. ");
INSERT INTO lbk_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Issan nangwaniyan amayo ay nan cheycha'y namatmatikan ay karching nan lagfok, siya et am-in nan inyanak nan cheycha'y karching. Awni ya mo kanana kasin ay nan cheycha'y nakhag-alitan nan lagfok, siya et akhes am-in nan naiyanak. ");
INSERT INTO lbk_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Siya achi chi nan inangnen Apo Dios ay nangala isnan enkik-iwiyen amayo ay nangichowa ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Intoloy Jacob ay nangwanin, “Issan timpon nan pinag-eecham nan cheycha'y enkik-iwi, init-itawko nan karching ay cha mangcham isnan fai, et nakhag-alitan, lafang, ya namatmatikan cha. ");
INSERT INTO lbk_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sa et nenkali nan anghel Apo Dios ken sak-en isnan it-itawko. Kinwanina, ‘Jacob.’ ‘Wen,’ kinwanik ay nanongfat. ");
INSERT INTO lbk_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","‘Ilaem! Am-in nan laki ay karching ay cha en-echam et nakhag-alitan, lafang, ya namatmatikan. Siya nan inischok ay maangnen, tay inilak nan am-in ay cha inang-angnen Laban ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Sak-en nan Dios ay nenpaila ken sik-a id Betel, ay nannoocham isnan fato ay nangifokfokam isnan lana ay olibo ta panemsemkam. Ya ischi akhes nan nensapataam ken sak-en. Idwani, enligwat ka ta somakhong ka isnan ili ay naiposkham.’ ” ");
INSERT INTO lbk_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Sinmongfat cha Raquel ken Lea ay nangwanin, “Ay ke way nakhayad is tawichenmi ken ama? ");
INSERT INTO lbk_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Infilangna chakami ay kag mangmangili. Inlakona chakami sa na't finosfos am-in nan siping ay fayadmi. ");
INSERT INTO lbk_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Am-in nan kinafaknang amami ay inalan Apo Dios ay nangiyaton ken sik-a, et kwami isnan an-akmi. Angnem et achi am-in nan infaag Apo Dios ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Siya chi ya alan et cha Jacob ya ligwat ay somaa ken amana ay Isaac id Canaan. Inpasakayna nan cheycha'y an-akna ya nan asaswana isnan kamelio. Sa na't inafo ay inpaon-ona nan am-in ay enkik-iwiyena ya intakina nan am-in ay kwana ay cha na chinakhop id Mesopotamia. ");
INSERT INTO lbk_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Maid si Laban isnan kinmaanancha tay inmey ay en namokis isnan cheycha'y karnilona. Si akhes Raquel, inmey ay nangakew isnan tinagtakho ay ap-aped ay dios amana. ");
INSERT INTO lbk_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Sinikapan Jacob si Laban tay inliwetna ay kinmaan. ");
INSERT INTO lbk_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Inalana am-in nan kwana sa cha't ala ya layaw. Khinchangcha nan wanga'y Eufrates sa cha't chinnawes nan nafib-ilikhana id Galaad. ");
INSERT INTO lbk_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Kakwasan nan tolo ay akhew, naifaag ken Laban ay linmayaw si Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Osto'y siya chi alan et Laban ya ligwat ya nan cheycha'y ib-ana, sa cha't inonod ay nangamakam ken Jacob engkhana'y inchanancha siya isnan maikapito ay akhew isnan nafib-ilikhana id Galaad. ");
INSERT INTO lbk_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ngem apchas et nenpaila si Apo Dios ken Laban isnan it-itawna isnan lafi ay nangwanin, “Ilaem ta mey-am nan kanam ken Jacob ta ad-im pap-aegyaten.” ");
INSERT INTO lbk_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Idwani, nenkakampo cha Jacob isnan nafib-ilikhana id Galaad ya siya akhes nan nenkampowan cha Laban. ");
INSERT INTO lbk_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Sa et kinwanin Laban ken Jacob, “En ka man sinmailo ay? Aped mo inkaan nan an-akko ay kag cha's nadpap is kafaloknitan. ");
INSERT INTO lbk_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Em man sinikapan sak-en sam et iliwet nan kinmaanam ay? Mo sa ya infaagmo, et inpaligwatko koma sik-a ay wad-ay nan laglagsak ya chagchag-ay ay migkhisan isnan tokar ya pandereta ya arpa. ");
INSERT INTO lbk_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Eg-ay ka pay paat inmagtan is wayak ay mamisito isnan aap-ok ya nan an-akko ay mangipaligwat ken chaicha. Linilewlew nan inangnem. ");
INSERT INTO lbk_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kafaelak achi ay mangisik ken sik-a, ngem issan lafi finmagfakha nan Dios cha amam ay mangwanin mey-ak nan kankanak ta ad-ik pap-aegyaten sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ammok ay kinmaan ka tay chadlos ay mailew ka isnan pangafong amam, ngem em man inakew nan diosko isnan afongko ay?” ");
INSERT INTO lbk_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Sa et kinwanin Jacob, “Inmegyat ak tay kanak en ta ket lang khoyochem ay mangipakod isnan an-akmo. ");
INSERT INTO lbk_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ngem mo mipoon isnan diosmo, et mo achi way edchanam isna is nangitafon, et maipapatey. Aye! Anapem isnan sakhang nan naycha'y iib-a tako, ta mo wad-ay isyangkhay ay kwam ken chakami, alaem.” (Ad-i ammon Jacob ay inakew pet Raquel nan cheycha'y dios amana.) ");
INSERT INTO lbk_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Adi kad nen-anaanap si Laban is katorcha ay afong Jacob. Sa et inmey isnan torcha ay afong Lea ya isnan torcha'y afong nan chwa'y faa ay inasawan Jacob, ngem maid inchasana isnan cheycha'y diosna. Sa et inmey isnan torcha'y afong Raquel. ");
INSERT INTO lbk_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Intafon Raquel nan cheycha'y ap-aped dios isnan montola ay maip-ippey is kaecheg nan kamelio ay entokchowan, et tinotokchowana chi is kaafongna. Nen-anaanap kasin si Laban et maid inchasana. ");
INSERT INTO lbk_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Kinwanin et Raquel ken amana, “Ad-i ka koma somonget ama isnan ad-ik tomakchekhan isnan wad-ayam tay inomchan nan enkachawyanak.” Nen-anaanap si Laban isnan afongna ngem mid nad-anana isnan cheycha'y diosna. ");
INSERT INTO lbk_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Sinmonget et si Jacob ay nangwani ken Laban, “Ngag mampet nan ngaag ay inangnek? Ngag nan fasolko ta aped ka omali ay chadlos omanoanop? ");
INSERT INTO lbk_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Idwani tay nen-anaanap ka et isnan am-in ay kwak, ngag nan inchasam ay naakew isnan afongmo? Ifalam et isna ta ilaen am-in nan iib-a tako ya fanakhencha mo sino ken chaita nan osto. ");
INSERT INTO lbk_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Chwan poo ay tawen nan nentey-ak ken sik-a. Ya maid paat egay nagkhanakan nan karnilom ya karchingmo. Maid akhes paat ko khinegkhekhed isnan laki ay enkik-iwiyem ay maipalofos ay masibfan. ");
INSERT INTO lbk_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ya mo wad-ay nan cha khineslay si atap ay enkik-iwi et sak-en kannay nan mangikalo ischi. Egayko kasin insas-aa ken sik-a ay mangipaila ta maammowan ay faken ko fasol. Inpilitmo ay sokatak si khawis nan cha maakew isnan maschem paymo mag-akhew. ");
INSERT INTO lbk_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Selaeg ko ay kad-in maakheakhewan ya maskamaskaw isnan lafi. Ya maid paat seyepek. ");
INSERT INTO lbk_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Et siyassiya sa issan chwan poo'y tawen ay nakitetey-ak ken sik-a. Sinpoo ya epat ay tawen nan nenchonowak ay sokat nan chwa ay an-akmo ay inasawak. Ya enem ay tawen nan nenfelabfellayak ay namaspastor isnan enkik-iwiyem. Ya khechangna ay siya kayet ay naminsinpoo ay finalibfaliwam nan lagfok. ");
INSERT INTO lbk_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mo maid ken sak-en nan Dios ikitko ay Abraham ay siya nan Dios ay iyeegyat ama'y Isaac, et away inpakaanmo sak-en ay maid paat alaek. Nay met achi inilan Apo Dios nan likhatko ya nan chinnok, et id kofab inpailana ken sik-a nan kalentekhak.” ");
INSERT INTO lbk_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Sa et kinwanin Laban, “An-akko chana ay fabfafai, ya kwak akhes nan an-akcha. Siya akhes ay kwak am-in nan naycha ay enkik-iwi. Isnan kinatet-ewana, am-in nan naycha'y wad-ay ay iilaem isna, et kwak am-in. Ngem maid mabfalin si angnek ay mangipakod isnan an-akko ya ap-ok. ");
INSERT INTO lbk_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ayet ta entolag ta. Sa ta't tomoping is kaskasmekan nan entolakhanta.” ");
INSERT INTO lbk_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Siya chi, et inmala si Jacob is fato et tinoodna chi ay kag panemsemkan. ");
INSERT INTO lbk_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Infaagna isnan cheycha'y takhona ta omamong cha is fato sa cha't topingen. Sa cha't nangan isnan sag-en nan cheycha'y fato ay natoping. ");
INSERT INTO lbk_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Nan inpangachan Laban ischi et Jegar-Sahaduta, ya Galed nan inpangachan akhes Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Sa et kinwanin Laban, “Nan nay ay natoping ay fato et panemsemkan na ken chaita.” Siya na nan khotokna ay nangadnan chi is Galed. ");
INSERT INTO lbk_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Kinwanin kayet Laban, “Si Apo Dios nan mangiila isnan ang-angnenta isnan ensiyananta.” Isonga nangadnan kayet chi is Mizpa. ");
INSERT INTO lbk_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Sa na't kanan, “Mo ngaag nan ang-angnem isnan naycha'y an-akko paymo omasawa ka is teken olay mo ad-ik ammo, sesemkem yangkhay ay wad-ay si Apo Dios ay omiila. ");
INSERT INTO lbk_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Naay nan tinopingko ay fato ay maniyan ken chaita, ya naay akhes nan fato ay panemsemkan. ");
INSERT INTO lbk_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Nan nay ay natoping ya nan nay natood ay fato et en-iso chana ay panemsemkan. At olay kaatna ad-i ak fomasfas-ang isnan nay natoping ay fato ay manoklos ken sik-a, ya masapol ay ad-i ka akhes fomas-ang isna paymo isnan nay panemsemkan ay fato ay manoklos ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","At yangkhay nan Dios Abraham ya nan Dios Nahor ay Dios amacha nan mangokom ken chaita.” Adi kad insapatan Jacob isnan ngachan Apo Dios ay iyeegyat Isaac ay amana, ta angnena nan inkalina. ");
INSERT INTO lbk_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Sa et pinmarki isnan enkik-iwi ay inchoona ay chaton ken Apo Dios isnan chey ay filig, et inayakhana nan takhona ay nangan. Et ischi kannay nan inomyanan cha. ");
INSERT INTO lbk_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Osto ay nawiit, isnan naligwatan Laban ay somaa, finisitona nan ap-ona ya nan an-akna. Sa na't binindisyonan chaicha ya kinmaan. ");
INSERT INTO lbk_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Isnan nangitot-oloyan Jacob isnan faatna, wad-ay cha et nan kaangheangheles Apo Dios ay nanab-at ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Sa na't kanan issan nangil-ana ken chaicha en, “Siya pet na nan kampon Apo Dios!” Et siya chi ay nginadnana chi is Mahanaim. ");
INSERT INTO lbk_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Idwani infaan Jacob nan takhona ay inpaon-onana ken Esau ay yon-ana id Edom ay makwani akhes en Seir. ");
INSERT INTO lbk_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Sa na't kanan ken chaicha, “Siya na nan kananyo isnan yon-ak, ‘Si Jacob ay ab-afaa ay faam, et laychena ay ipaammo ken sik-a ay apona ay Esau, ay inmannong ay nakitetee siya ken Laban ya nay inawniawnina nan tomoliyana engkhana idwani. ");
INSERT INTO lbk_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Wad-ay cha nan fakana, dangki, karnilo, karching ya faana akhes. Et infaana chakami ay omali ay mangila ken sik-a apo, ta asop ya malaychan ka ken siya.’ ” ");
INSERT INTO lbk_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Isnan tinmoliyan san cheycha'y finaan Jacob, kinwanicha, “Inmey kami ken Esau ay yon-am ya nay wad-ay et sinan chalan ay omal-ali ay manab-at ken sik-a. Fowegna nan epat khasot ay lallalaki.” ");
INSERT INTO lbk_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Chadlos inmegyat et si Jacob ya nadchanakhan. Ala na't ya khedwa isnan takhona is chwan pamoweg. Siya akhes isnan cheycha'y enkik-iwiyena. ");
INSERT INTO lbk_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tay kanana is semekna ay, “Mo choklosen Esau nan inmona ay sinpamoweg at mabfalin nget ay makalayaw nan esang.” ");
INSERT INTO lbk_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Nenlowalo et si Jacob ay nangwanin, “Apo ay Dios ikit ay Abraham ya si ama ay Isaac, chengngem koma sak-en. Infaagmo Dios Apo ay somakhong ak isnan ilik ya papangafongko, et angnem nan am-in ay somyaan nan fiyagko. ");
INSERT INTO lbk_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ad-i ak maikali isnan am-in ay inpailam ay kinagkhawis ya kinatalekmo ken sak-en ay faam. Khinchangko nan wanga ay Jordan ay aped ensosokod, ay maid paat ineegnak. Ya nay idwani ay somakhong ak et wad-ay nan naycha'y chwan pamoweg. ");
INSERT INTO lbk_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kedchawek ta omisalak ka isnan yon-ak ay si Esau. Omegyat ak tay ta ket lang ya omali ay chomoklos ya pomatey ken chakami am-in, olay nan in-a ya nan an-akcha. ");
INSERT INTO lbk_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Sesemkem koma nan inkalim ay at omipagkhawis ka. Inkalim ay paangsanem nan cheycha'y wanen-edko ay kag nan kaangsan nan ofod is kailit nan fayfay ay maid makafib-ilang.” ");
INSERT INTO lbk_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Inomyan si Jacob ischi, ya isnan kawaksana, nenpili isnan cheycha'y talakena is ilayadna isnan yon-ana: ");
INSERT INTO lbk_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","chwan khasot ay fai ay karching ya chwan poo ay laki; chwan khasot ay fai ay karnilo ya chwan poo ay laki; ");
INSERT INTO lbk_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tolon poo ay enpasoso ay kamelio ya nan innanakcha; epat poo ay fai ay faka ya sinpoo ay laki; ya chwan poo ay fai ay dangki ya sinpoo ay laki. ");
INSERT INTO lbk_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Sa na't tinketinken nan enkik-iwiyena ya sa na't inkakcheng isnan faana ay waschin menfiyang isnan sin-es-ang ay pangfon. Kinwanina ken chaicha, “Ipangpangoyo. Ilaenyo magtek ta en-inadchawi nan waschin esa'y pangfon.” ");
INSERT INTO lbk_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Infilina isnan namangpango ay faana, “Mo abten nan yon-ak ay si Esau sik-a ya salodsochena mo sino nan apom, mo ento nan omayam, ya mo sino nan nenkwa isnan naycha'y talaken ay cham okochen, ");
INSERT INTO lbk_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","et siya na nan masapol ay isfatmo: ‘Kwan nan faam ay si Jacob chana. Inpaiyalina chana ay ilayadna ken apona ay Esau. Wad-ay siya akhes ay cha omon-onod ken chakami.’ ” ");
INSERT INTO lbk_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Siya na akhes nan infilina isnan mikadwa, mikatlo, ya nan am-in kayet ay faa ay nangipakarkhowana isnan cheycha'y enkik-iwiyena. Kinwanina, “Siya na nan masapol ay ifaagyo am-in ken Esau mo abtenyo. ");
INSERT INTO lbk_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kananyo kayet, ‘Omon-onod ken chakami si Jacob ay faam.’ ” Isnan semek Jacob kankanana, “Et asop nget ya maawisko si yon-ak isnan naycha'y ilayadko ay ipaon-onak ken siya. Et isnan manab-atak ken siya asop ya pomakawan.” ");
INSERT INTO lbk_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Adi kad inpaiyon-onana nan ilayadna ay cheycha, ngem siya, inomyan is kakampona isnan chey ay lafi. ");
INSERT INTO lbk_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Isnan siya kannay chi ay lafi finmangon si Jacob ya intakina nan chwa'y asawana, nan chwa'y fabfafai ay faa ay inasawana ya nan cheycha'y sinpoo ya esang ay an-akna, et khinchangcha nan wanga ay Jabbok. ");
INSERT INTO lbk_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Osto'y khinomchang cha, inpagchangna akhes nan am-in ay kwana. ");
INSERT INTO lbk_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sa et nakhayad siya ay es-esang is chemangna. Ya ket ay inmali nan esa'y lalaki ay nakidpap ken siya engkhana ay nganngani ay napat-a. ");
INSERT INTO lbk_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Isnan nangil-an nan lalaki ay ad-i makaafak siya ken Jacob, ala na't ya tampak isnan tip-ay Jacob et nenkabsiw nan pangom-oman nan ingit si tip-ay. ");
INSERT INTO lbk_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kinwanin nan lalaki, “Omipalofos ka tay nay cha et mapat-a.” “Ad-ik palofosen sik-a engkhana ay bomindisyon ka,” kinwanin Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“Ngag man nan ngachanmo?” sinalodsod san lalaki. “Jacob,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kinwanin et nan lalaki, “Faken et Jacob nan ngachanmo, tay nakidpakidpap ka ken Apo Dios ya isnan takho, et nay nangafak ka, Israel et nan ngachanmo.” ");
INSERT INTO lbk_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","“Ibfakham ed nan ngachanmo,” kinwanin Jacob. Sa na't kanan, “Ay kem masapol salodsochen nan ngachanko?” Sa na't binindisyonan si Jacob ischi kannay. ");
INSERT INTO lbk_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Sa et kinwanin Jacob, “Inilak si Apo Dios ay sangosango ya nay khechangna ay matatakho ak pet kayet.” Siya na nan khotokna ay nangipangadnana ischi is Peniel. ");
INSERT INTO lbk_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Cha mamatok nan akhew issan cha komaanan Jacob id Peniel et nen-ak-akilla tay naikabsiw nan pangom-oman nan tip-ayna. ");
INSERT INTO lbk_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Isonga engkhana idwani ad-i sibfan nan cheycha'y wanen-ed Israel nan fekhas ay wad-ay isnan pangom-oman nan ingit si tip-ay, tay siya chi nan natampak ken Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Awni pay ya sinakhang Jacob ay ke pet cha omal-ali cha Esau ya nan epat khasot ay lallalaki. Tay siya chi inamongna nan cheycha'y sin-in-in-a ay cha Lea ya nan an-akna, si Raquel ya nan anakna, ya nan chwa'y faana ay inasawana ya nan an-akcha, ya tinketinkena chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Inpaon-onana nan chwa'y faa ya nan an-akcha, sa et cha Lea ay sin-in-a, awni ya cha Raquel ken Jose ay sin-ina ay inpakotitna. ");
INSERT INTO lbk_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Namangpango si Jacob et isnan cha na somag-enan ken yon-ana naminpito ay cha nenfalintomeng ay nentowad. ");
INSERT INTO lbk_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ngem alan Esau ya tagtag ay en nanab-at ken siya, sa na't ala ya kawe ya fisito. Et waschin nen-akha. ");
INSERT INTO lbk_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Osto'y nenmonaang si Esau ya ke na't ilan nan fabfafai ya nan ongang-a, sa na't kanan, “Sino man nan naycha'y fowegmo?” “Chaicha nan anan-ak ay inseg-ang Apo Dios ken sak-en ay faam,” kinwanin Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Idwani sinmag-en nan cheycha'y faa ay inasawana ya nan an-akcha sa cha't nenyongyong ken Esau. ");
INSERT INTO lbk_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Sinmag-en akhes cha Lea ay sin-in-a sa et nan kakotitan ay cha Jose ken Raquel ay sin-ina, et nenyongyong cha akhes. ");
INSERT INTO lbk_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ket ay sinalodsod Esau ay nangwanin, “Ngag man nan laychena ay kanan nan cheycha'y teken ay sinpamoweg ay sinab-atko?” “Siya man chachi apo, nan kanak ay ilayadko koma ken sik-a ta asop ya malaychan ka ken sak-en,” kinwanin Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Nay met achi kinwanin Esau, “Omanay et nan wad-ay ken sak-en annochik. Olay alaem nan sanacha'y kwam.” ");
INSERT INTO lbk_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","“Ad-i,” kinwanin Jacob. “Tay mo tet-ewa ay khawis nan liknam ken sak-en, et pangngaasim ta chawatem nan nay ilayadko. Nan nay ay kasin ko mangil-an ken sik-a, et kag si Apo Dios nan sasakhangek tay nay enlal-ayad ka ay manawat ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Pangngaasim ta chawatem nan inyalik ay ilayadko ken sik-a. Naanos si Apo Dios ken sak-en et inchowana am-in nan masapolko.” Eg-ay tinomke si Jacob engkhana'y chinawat Esau chachi. ");
INSERT INTO lbk_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Awni pay sa et kanan Esau, “Maligwat kayo et ta en tako, ta ipangpangok.” ");
INSERT INTO lbk_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Sa et kinwanin Jacob, “Da! Ilaem achi nan naycha'y ongang-a ay sisya'y malallachaan, ya masapol akhes ay ilaek nan naycha'y enpasoso ay talaken ya nan innanakcha. Ad-i mabfalin ay chadlos maikakamo ay maokod chana isnan sin-akhew yangkhay, tay et lang malektat cha'y matey. ");
INSERT INTO lbk_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Olay man et mang-ona ka apo ta sa mi cha ilonloney ay omon-onod maiyafoloy isnan kafaelan nan enkik-iwi ya ongang-a. Et sak edchanan sik-a id Edom isnan naycha'y talaken ya an-akko.” ");
INSERT INTO lbk_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","“Mo siya sa, et omikhayad ak et achi isnan tapin nan takhok ay mangifoweg ken chakayo mo laychem,” kinwanin Esau. Nay met achi kinwanin Jacob, “Ad-i fali, tay omanay et nan inpailam ay khawis ay liknam ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Siya chi et nenligwat si Esau ay sinmakhong id Edom. ");
INSERT INTO lbk_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ngem si Jacob et id Succot nan chinnawesna. Nenpatakcheg ischi's en-afongancha ya ab-afong nan cheycha'y enkik-iwiyena. Siya chi nan khotokna ay nangadnan sidi is Succot. ");
INSERT INTO lbk_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Awni pay ya ket intot-oloy cha Jacob ay nenfaat, ya enkhagkhawis cha ay inomchan id Canaan isnan ili ay Sikem issan nalpowancha id Mesopotamia. Nenkampo isnan sag-en nan ili. ");
INSERT INTO lbk_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Linakwana nan chey ay nenkampowana isnan cheycha'y an-ak Hamor ay aman Sikem is sinkhasot ay ilan si siping. ");
INSERT INTO lbk_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nentoping ischi is esang ay altar et nginadnana is El ay Dios nan Israel. ");
INSERT INTO lbk_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Issan namingsan inmey si Dina ay magmagkit nan cha Lea ken Jacob ay nakilil-iwid isnan fabfafain si iCanaan. ");
INSERT INTO lbk_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ya ket ay isnan nangil-an Sikem ay anak Hamor ay Heveo ay ap-apo ischi, khinoyodna ay namilit ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ngem awni ya ket ay chadlos chachama nan layadna ken siya. Sa na't inpey nan kafaelana ay mangaloalok ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sa na't kinwani ken amana, “Laychek ay alaem nan nay ay magmagkit is en-asawak.” ");
INSERT INTO lbk_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Inammowan Jacob ay naipabfain nan anakna, ngem khapo tay finmoknag nan an-akna ay en nangipastor isnan enkik-iwiyencha, khinmigkhinek siya engkhana ay sinmaa cha. ");
INSERT INTO lbk_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Idwani, finmala si Hamor ay aman Sikem ay nakitoya ken Jacob, ");
INSERT INTO lbk_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","isnan chadlos osto ay sinmaalan nan an-ak Jacob ay namoknag. Osto ay chinngecha nan inmat, ke cha't ay nenkalilingad ya en-al-alifotfot nan songetcha isnan kakaisew ay inangnen Sikem ken chaicha ay Israelitas isnan namilitana isnan akhicha ay anak Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Sa et kinwanin Hamor ken cha Jacob, “Chachama nan layad nan anakko ay si Sikem isnan magmagkitmo. Pangngaasim ta ipalofosmo ay en-asawa cha. ");
INSERT INTO lbk_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Khawis koma mo entotolag tako ay maasaswa nan an-ak tako ");
INSERT INTO lbk_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ta nawaya kayo ay makiili ken chakami, ya mabfalin ay entee kayo akhes isnan olay entona issa ay laychenyo, ya nawaya kayo kayet ay enkomerso ya makakwa isnan lota.” ");
INSERT INTO lbk_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sa et nenseg-ang akhes si Sikem isnan aman ya et-ad Dina ay mangwanin, “Pangngaasiyo ta chengngenyo nan kanak, et sak ichowa am-in nan laychenyo. ");
INSERT INTO lbk_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ifaagyo mo ngag nan laychenyo ay isab-ongko ay ichowak ken chakayo, ya mo kaat nan kananyo ay falorna ta sak et ichowa, olay kaat sisa. Ichowak nan am-in ay ngag sisa ay kedchawenyo, mo ket ipaasawayo siya ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Idwani, khapo isnan nangipafainan Sikem isnan etadcha ay si Dina, sinikapan et nan an-ak Jacob nan sin-ama. ");
INSERT INTO lbk_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kinwanicha, “Ad-imi mabfalin ay ipaasawa nan akhimi isnan naloyyopan. At siya sa nan kaifafainanmi. ");
INSERT INTO lbk_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Omafoloy kami yangkhay mo kag kayo ken chakami ay masegyatan am-in nan lallalaki. ");
INSERT INTO lbk_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mo angnenyo na et mabfalin ay maasaswa tako. At makitee kami ken chakayo ta maesang tako. ");
INSERT INTO lbk_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Nay met achi mo ad-i kayo, et alaenmi si Dina sa kami't komaan.” ");
INSERT INTO lbk_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tinan-oyan cha Hamor ken Sikem tay kanancha en mo khawis chi. ");
INSERT INTO lbk_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Et eg-ay nentontotonto nan fab-alo ay nangangnen isnan nakwani mo ke tay isnan layadna isnan magmagkit Jacob. Et khapo tay siya nan chadlos ay napateg isnan pangafongna, ");
INSERT INTO lbk_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","inmey cha't ay sin-ama isnan kamatottotyaan nan amam-a is kapantew nan ilicha et nakitot-oya cha ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Kinwanicha, “Khawis nan semek chatona ay mangili ken chatako. Khawis koma mo makiili cha ken chatako ya nawaya cha ay enkomerso. Annawa met nan lota tako. Makiasaswa tako't achi ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nay met achi tan-oyancha yangkhay ay makitee ay makies-esa ken chatako mo pasegyat ona nan am-in ay lallalaki tako ay kag ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ad-i ngen khawis chi tay et sa tako enkwa am-in nan enkik-iwiyencha ya nan am-in ay wad-ay ken chaicha? Isonga itan-oy tako't mampay ay makiili cha ken chatako.” ");
INSERT INTO lbk_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Adi kad tinan-oyan nan omili ischi nan kinwanin nan sin-ama ay cha Hamor ken Sikem, et nasegyatan am-in nan lallalakicha. ");
INSERT INTO lbk_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kakwasan nan tolo'y akhew, isnan sisya'y ensakit nan segyat nan lallalaki isnan chey ay ili, alan et nan chwa'y yoyon-an Dina ay an-ak Jacob ay cha Simeon ken Levi ya ala isnan fadyokcha, sa cha't inmey isnan ilin Hamor, et maid nakaammo isnan pangkhepcha, sa cha't pinatey am-in nan lallalaki ischi. ");
INSERT INTO lbk_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Intapicha ay namatey isnan sin-ama ay cha Hamor ken Sikem. Sa cha't inala si Dina is afong Sikem ya kinmaan cha. ");
INSERT INTO lbk_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Kakwasan nan nenpateyancha, alan et akhes nan tapin nan an-ak Jacob ay en nangamkam isnan am-in ay wad-ay isnan chey ay ili ta ifalescha nan naifafainan nan akhicha. ");
INSERT INTO lbk_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Inalacha nan am-in ay karnilo, karching, faka, dangki ya am-in ay wad-ay isnan ili ya is kaponchag. ");
INSERT INTO lbk_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Inalacha nan am-in ay maifaknang ischi. Chinpapcha nan fabfafai ya nan ongang-a ya inkaancha am-in nan wad-ay isnan kaafoafong. ");
INSERT INTO lbk_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kinwanin et Jacob ken cha Simeon ken Levi, “Kinmorkor kayo't ken sak-en. Idwanin kag ak et ang-angallot sina ya at lomilikhet et nan naycha'y Cananeo, Perezeo, ya nan am-in ay omili isna id Canaan. Ay ke way angsan si takhok? Mo maamong cha am-in nan takho isna ta chomoklos cha et mapatey tako am-in ay masinpapangafong.” ");
INSERT INTO lbk_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Nay met achi kinwanicha, “Ay ke mi aped iilan nan akhimi ay khab-encha's kag asi ay fafai?” ");
INSERT INTO lbk_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Idwani, kinwanin Apo Dios ken Jacob, “Enligwat ka ta omey ka id Betel ya kanatee ka ischi. Tomoping ka is altar sid-i ay enchad-ayawam ken sak-en ay Dios ay nenpaila ken sik-a issan chey ay ilaylayawam si yon-am ay Esau.” ");
INSERT INTO lbk_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Sa et kinwanin Jacob isnan pangafongna ya isnan am-in ay takhona, “Kaanenyo nan teketeken ay chiosyo. Pakhawisenyo nan okhaliyo ya chalosanyo nan fachoyo. ");
INSERT INTO lbk_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ta taynan tako isna ta omey tako id Betel, ay manoppingak isnan altar ay enchayawan tako ken Apo Dios ay finmachang isnan likhatko ya wawawawad-ay isnan am-in ay inay-ayak.” ");
INSERT INTO lbk_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Et siya chi ay inchowacha am-in ken Jacob nan cheycha'y teketeken ay ap-aped ay dioscha ay wad-ay ken chaicha, ya sa et nan singsing nan kowengcha. Et inkaob Jacob am-in chana is kapoon nan kaew ay kag alimmos ay maisasag-en id Sikem. ");
INSERT INTO lbk_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Isnan naligwatan cha Jacob ya nan an-akcha ay komaan, inpaegyat Apo Dios nan cheycha'y omili isnan maisasag-en ay ili, et eg-aycha inonod chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Inomchan cha Jacob ya nan am-in ay takhona id Luz ay siya nan makwani ay Betel idwani, id Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Tinmoping is altar sid-i sa na't nginadnan is, “Nan enchad-ayawan isnan Dios nan Betel,” tay ischi nan nenpail-an Apo Dios ken siya issan cha na ilayawan si yon-ana. ");
INSERT INTO lbk_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Isnan akhes kawadcha ischi ya ket ay natey nan in-ina ay kafachang Rebecca ay si Debora, ya inkaobcha siya is kapoon nan kaew is apet ambagatan id Betel. Et nginadnan Jacob akhes ischi is Kaew si Akha. ");
INSERT INTO lbk_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Idwani ay sinmakhong et si Jacob ay nalpo id Mesopotamia, nenpaila kasin si Apo Dios ay namindisyon ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kinwanin Apo Dios, “Milapo idwani faken et Jacob nan ngachanmo mod-i ket Israel.” Et siya chi ay nginadnan Apo Dios siya is Israel. ");
INSERT INTO lbk_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kinwanin Apo Dios, “Sak-en nan Dios ay Makabfalin Am-in. Makhanakhanak ka, et maiwaned ken sik-a nan takho isnan angsan ay ili, et sik-a nan ikit si kaaliali. ");
INSERT INTO lbk_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","At ichowak ken sik-a nan lota ay inchowak ken cha Abraham ken Isaac, ya ichowak akhes isnan cheycha'y wanen-edmo.” ");
INSERT INTO lbk_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sa et tinmongcho si Apo Dios ay nanaynan ken Jacob isnan chey ay nanot-oyyana ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Adi kad ischi kannay ay chadlos nanot-oyyan Apo Dios ken siya nan nangtoochana isnan fato ay panemsemkan, sa na't finokfokan si fayas ya lana ay nangichoo ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Siya chi et nginadnana is Betel nan chey ay nanot-oyyan Apo Dios ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Awni ya ket tinaynan cha Jacob ay sinpangafong id Betel ta enpaEfrata cha. Sisya'y adchawi cha ischi, ya ket inomchan nan timpo ay omanakan Raquel et chachama nan nensikhafana isnan cha na enpasikalan. ");
INSERT INTO lbk_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Isnan chadlos ensakitan nan cha na enpaspasikalan, kinwanin et nan enpaan-anak ken siya, “Ad-i ka omegyat Raquel tay nay lalaki kayet na!” ");
INSERT INTO lbk_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ngem matmatey et si Raquel. Isnan matmateyana nginadnana nan anakna is Benoni. Ngem ket ay nginadnan amana nan onga is Benjamin. ");
INSERT INTO lbk_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Issan nateyan Raquel, naikaob siya isnan ilit nan karsa ay omey id Efrata, ay makwanin Betlehem idwanin. ");
INSERT INTO lbk_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tinmood si Jacob is fato ay manemsemkan ischi, et sisya'y wad-ay ischi ay maton nan pantiyong Raquel engkhana idwani ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Intoloy Israel ay nenfaat sa et nenkampo isnan chemang nan at-atakchag ay toping ay enfeb-elewan Eder. ");
INSERT INTO lbk_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isnan nenkakampowan cha Israel ischi, ket ay inseyep Ruben si Bilha ay esa isnan asawan Israel ay amana. Isnan nanngelan amana ischi, chachama nan songetna. Sinpoo ya chwa nan an-ak Jacob ay lallalaki. ");
INSERT INTO lbk_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Nan an-akna ken Lea, et si Ruben (ay yon-a isnan an-ak Jacob), sa et cha Simeon, Levi, Juda, Issacar ya si Zabulon. ");
INSERT INTO lbk_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Nan an-akna ken Raquel et cha Jose ken Benjamin. ");
INSERT INTO lbk_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Nan an-akna ken Bilha ay faan Raquel et cha Dan ken Neftali. ");
INSERT INTO lbk_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ya nan an-akna ken Zilpa ay faan Lea et cha Gad ken Aser. Naiyanak chana id Mesopotamia. ");
INSERT INTO lbk_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Awni ya ket sinmaa si Jacob ken amana ay enkakampo id Mamre ay sag-en nan Hebron, ay sikhod ay nenkakampowan san si ikitna ay Abraham ya si amana ay Isaac. ");
INSERT INTO lbk_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Natakhotakho si Isaac et nentawen is sinkhasot ya walon poo, ");
INSERT INTO lbk_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","et natey ay chadlos nalakalakay. Inkaob nan an-akna ay cha Jacob ken Esau. ");
INSERT INTO lbk_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Siya chana nan wanen-ed Esau ay makwani akhes en Edom. ");
INSERT INTO lbk_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Fabfafain si iCanaan nan cha inasawan Esau ay cha Ada ay anak Elon ay Heteo, si Oholibama ay anak Ana. Nan aman Ana et si Zibeon ay Heveo. ");
INSERT INTO lbk_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Asawana akhes si Basemat ay anak Ismael ya akhin Nebayot. ");
INSERT INTO lbk_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Nan anakna ken Ada et si Elifaz; ya nan anak Basemat et si Reuel; ");
INSERT INTO lbk_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","nan an-akna akhes ken Oholibama et cha Jeus, Jaalam ya si Kora. Siya chana nan an-ak Esau, ay naiyanak id Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Idwani inkaan Esau nan pangafongna, am-in nan cheycha'y nakitetee ken siya, ya nan am-in ay talakena ya kwana ay cha na inala id Canaan et naisiyan ken annochina ay Jacob. Inmey isnan teken ay ili ");
INSERT INTO lbk_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","tay ad-i et omanay nan ponchag ischi ay manakho ken chaicha ay sin-akhi. Angsaangsan nan enkik-iwiyencha ya nay ad-i cha et mabfalin ay maaamong. ");
INSERT INTO lbk_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Et inmey nentee si Esau ay nangadnan is Edom isnan nafib-ilikhana id Seir. ");
INSERT INTO lbk_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Siya chana nan wanen-ed Esau ay ikit nan makwanin Edomita ay nentee isnan nafib-ilikhana id Seir. ");
INSERT INTO lbk_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Nan anak Esau ken Ada et es-esa'y lalaki ay si Elifaz. Ya si Elifaz, lima nan an-akna ay lallalaki: cha Teman, Omar, Zefo, Gatam ya si Kenaz. Isnan esang kayet ay asawan Elifaz ay si Timna wad-ay nan esa'y anakna'y lalaki ay si Amalek. Esang nan anak Esau ken Basemat, ay si Reuel. Et si Reuel, epat nan an-akna ay lallalaki: cha Nahat, Zera, Samma ya si Mizza. ");
INSERT INTO lbk_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Tolo akhes ay lallalaki nan an-akna ken Oholibama: cha Jeus, Jaalam ya si Kora. Nan aman Oholibama et si Ana ay anak Zibeon. ");
INSERT INTO lbk_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Siya chana nan tribo ay naiwaned ken Esau. Si Elifaz ay yon-a isnan an-akna, et siya nan nalpowan nan naycha ay tribo: nan tribo cha Teman, Omar, Zefo, Kenaz, ");
INSERT INTO lbk_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam ya si Amalek. Siya chana nan naiwaned ken Esau ay sin-asawa ken Ada id Edom. ");
INSERT INTO lbk_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Si Reuel ay anak Esau, et siya nan nalpowan nan naycha ay tribo: nan tribon cha Nahat, Zera, Saama ya si Mizza. Siya chana nan naiwaned ken Esau ay sin-asawa ken Basemat id Edom. ");
INSERT INTO lbk_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Siya chana nan tribo ay naiwaned ken cha Esau ay sin-asawa ken Oholibama ay anak Ana: nan tribo cha Jeus, Jaalam ya si Kora. ");
INSERT INTO lbk_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Am-in nan naycha ay tribo et naiwaned cha ken Esau ay makwani akhes ay Edom. ");
INSERT INTO lbk_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Nan sikhod ay nen-ili id Edom et nateketeken cha ay tribo. Nan naiwanchan nan naycha et isnan wanen-ed Seir ay esa ay Horeo. Et siya chana nan an-ak Seir: cha Lotan, Sobal, Zibeon, Ana, Dison, Ezer ya Disan. ");
INSERT INTO lbk_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Si Lotan nan aman cha Hori ya si Heman. (Wad-ay nan fafai ay akhin Lotan ay enngachan si Timna.) ");
INSERT INTO lbk_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Si Sobal nan aman cha Alban, Manahat, Ebal, Sefo ya si Onam. ");
INSERT INTO lbk_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Chwa nan lalaki ay an-ak Zibeon: cha Aya ken Ana. (Siya na si Ana ay nangchan isnan en-at-atong ay eb-eb isnan ponchag isnan nangipaspastolana isnan dangkin amana.) ");
INSERT INTO lbk_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Si Ana nan aman Dison ay aman cha Hemdan, Esban, Itran ya si Keran. Wad-ay akhes nan anak Ana ay fafai ay enngachan si Oholibama. ");
INSERT INTO lbk_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Si Ezer nan aman cha Bilhan, Zaavan ya si Akan. ");
INSERT INTO lbk_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Si Disan nan aman cha Uz ken Aran. ");
INSERT INTO lbk_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Et siya mampay chana nan cheycha'y tribon nan cheycha'y Horeo id Edom: cha Lotan, Sobal, Zibeon, Ana, Dison, Ezer ya si Disan. ");
INSERT INTO lbk_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Siya chana nan ali ay nasonsosonson ay nen-ap-apo id Edom esa wad-ay ali isnan Israel: si Bela ay anak Beor ay nangaeb isnan matangtangad ay ilina ay Dinhaba, si Jobab ay anak Zera ay iBozra, si Husam ay iTeman, si Hadad ay anak Bedad ay nangaeb is matangtangad ay ilina ay Avit (Inafakna nan Midianita isnan faloknitcha id Moab.), si Samla ay iMasrecca, si Saul ay iRehobot is kawanga, si Baal Hanan ay anak Akbor, ya si Hadad ay nangaeb is matangtangad ay ilina ay Pau. (Si Mehetabel nan asawana. Inan Mehetabel si Matred ya inan Matred si Mezaab.) ");
INSERT INTO lbk_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Si Esau nan nalpowan nan naycha'y Edomita ay tribo: cha Timna, Alva, Jetet, Oholibama, Ela, Pinon, Kenaz, Teman, Mibzar, Magdiel ya Iram. Nan nentetey-an nan waschin esa isnan naycha'y tribo et ili ay nangadnan isnan ngadngachancha kannay. ");
INSERT INTO lbk_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Intot-oloy cha Jacob ay nentee id Canaan ay nentetey-an san si amana. ");
INSERT INTO lbk_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Idwani, siya na nan kaokhochan nan pangafong Jacob. Finmab-alo et si Jose ay entawen si sinpoo ya pito, ya finadfachangana nan yoyon-ana ay nangipastor isnan cheycha'y karching ya karnilo. Naitaktakin isnan yoyon-ana ay an-ak cha Bilha ken Zilpa ay iyaafong amacha, ya intiktikna ken amana nan ngaag ay ang-angnen nan yoyon-ana. ");
INSERT INTO lbk_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isnan am-in ay an-ak Israel, si Jose nan chadlos na laylaychen tay nawad-ay issan apchas na nalakayan. Siya nan inkhab-an amana is an-ancho ay kakhay ay ancho akhes nan palimaana. ");
INSERT INTO lbk_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Isnan nangil-an nan yoyon-an Jose ay wadwad-ay nan layad amacha ken siya mo ken chaicha, chad-ama et nan likhetcha ken siya, et maid paat khawis si manot-oyyancha. ");
INSERT INTO lbk_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Isnan namingsan, nen-it-itaw si Jose sa na't okhochen isnan cheycha'y yoyon-ana. Siya et chi ya ket ay onanig cha linilikhet. ");
INSERT INTO lbk_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kinwanina, “Chengngenyo kay nan it-itawko ya! ");
INSERT INTO lbk_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Cha tako maachi en-ani, ya isnan cha tako mametkan isnan nakompay ay naani, ya ket ay tomakcheg nan awitko. Idwani, alan et nan awityo ya liwes isnan awitko, sa cha't waschin yoyongyong ischi.” ");
INSERT INTO lbk_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","“Na! Ay kem kanan ay sa ka en-ali ken chakami ta iyapowam chakami?” kinwanin nan ag-ina. Et onanig cha liligten siya mo ke tay isnan it-itawna ya isnan kinwanina. ");
INSERT INTO lbk_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kasin nen-it-itaw si Jose, sa na't kayet inokhod isnan aag-ina ay mangwanin, “Ilaenyo kay ya! Wad-ay kasin nan teken ay init-itawko, ay kek et ay inila nan akhew, fowan ya nan cheycha'y sinpoo ya esa'y tokwifi ay waschin yoyongyong ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Infaag akhes Jose nan nay ay it-itawna ken amana, sa et yangyangan amana ay mangwanin, “Ngag man ay it-itaw sa? Ay kanam ngen ay et sa enfalintomeng ay entowad si inam, nan aag-im ya sak-en ken sik-a?” ");
INSERT INTO lbk_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Inmapal nan aag-in Jose ken siya, ngem si amana sinmesinmekna nan mipoon ischicha. ");
INSERT INTO lbk_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Isnan namingsan, inmey nan yoyon-an Jose id Sikem ay en nangipastor isnan cheycha'y talaken amacha. ");
INSERT INTO lbk_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Awni ya ket kinwanin Israel ken Jose, “Omey ka id Sikem ay cha mangipastolan nan yoyon-am isnan talaken.” “Wen ama, nakasakhana ak.” ");
INSERT INTO lbk_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kinwanin amana, “En ka ilaen nan yoyon-am mo khawis cha ya nan chey paspastolancha. Sa ka't somaa ay mangifaag.” Et inpaligwat amana is kadchetan nan Hebron. Awni pay ya ket inomchan si Jose id Sikem. ");
INSERT INTO lbk_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ya isnan cha na enlikchan is kaponchag, ya ket inilan nan esa'y lalaki ay nangwanin, “Ngag man nan cham an-anapen?” ");
INSERT INTO lbk_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Chak man anapen nan yoyon-ak ay enpaspastor,” kinwanina. “Ay way ngen inil-ilam ken chaicha?” ");
INSERT INTO lbk_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kinwanin et nan chey lalaki, “Kinmaan cha et achi? Chinngek ay cha cha kanan en omey cha id Dotan.” Et siya chi inonod Jose nan yoyon-ana, ya inchanana chaicha id Dotan. ");
INSERT INTO lbk_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Adchawi is akit si Jose isnan nangil-an nan eet-adna ken siya. Et isnan sisya'y eg-ayna inomchanan isnan kawadcha, natotya nan yoyon-ana ay mamatey ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Naay nan am-itawen,” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Aye ta pateyen tako, ta sa tako't ekchakhen nan awakna isnan esa isnan naycha'y naschok ay fofon, sa tako't ifaag ay inischan si atap ay enkik-iwi. Ilan tako ed mo sa way enfanakhan san cheycha'y it-itawna!” ");
INSERT INTO lbk_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Chinngen nan yon-acha'y si Ruben nan kinwanicha et laychena ay isalakan si Jose. Kinwanina't, “Ad-i tako pateyen. ");
INSERT INTO lbk_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ekchakhen tako't yangkhay siya isnan esa'y naschok ay fofon isna is kaponchag. Ad-iyo sogsokhaten siya.” Kinwanina chi tay laychena'y matakho si Jose ta sa na't ipasaa chadlo ken amacha. ");
INSERT INTO lbk_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Isnan inomchanan Jose ken chaicha, ala cha't ya lokpos isnan chey ay ancho nan palimaana ay kakhayna. ");
INSERT INTO lbk_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Et inekchagcha siya isnan esa'y naschok ay fofon. ");
INSERT INTO lbk_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Isnan cha cha manganan ya ket inilacha nan sinpamoweg ay Ismaelita ay komersiyanti ay nalpo id Galaad. Et kalikalikacho ya nafanglo ay niket nan inaawit nan kameliocha ay iyeycha id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kinwanin et Juda isnan cheycha'y eet-adna, “Ngag man nan sa tako maala mo pateyen tako nan akhi tako sa tako't itabtafon? ");
INSERT INTO lbk_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ilako tako't achi yangkhay siya isnan naycha'y Ismaelita. Ad-i tako mang-ey sokhaten siya. Tay annochi tako met siya ay awak ya chala tako kannay.” Siya chi et tinan-oyan nan et-adna nan kinwanin Juda. ");
INSERT INTO lbk_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Adi kad isnan osto'y lomaosan nan cheycha'y komersiyanti ay makwani akhes en Midianita, khinoyod et nan cheycha'y et-adna si Jose is kafofon sa cha't inlako isnan cheycha'y Ismaelita is chwan poo ay siping ay silver. Et inyeycha siya id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Awni ya ket tinmoli si Ruben is kafofon ya ket maid inchanana ken Jose. Ket ay chadlos nensasanga, ya ala na't ya peskhat isnan fachona. ");
INSERT INTO lbk_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Sa et tinmoli isnan cheycha'y et-adna ay cha mangwanin, “Ya ket maid nan fab-alo ischi! Ngag et kay nan angnek?” ");
INSERT INTO lbk_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Sa cha't pinarki is esa'y karching ya nan chalana nan nangitapekancha isnan fachon Jose. ");
INSERT INTO lbk_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Sa cha't insaa chi ken amacha ya kinwanicha, “Ay faken na's kakhay nan anakmo? Inchananmi pay na.” ");
INSERT INTO lbk_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Inmatonana chi ke na't kanan, “Wen, tet-ewa'y kakhayna na! Da! Ya ke pinatey si atap ay enkik-iwi. Ya ke cha pet khinislakhislay nan awak Jose ay anakko!” ");
INSERT INTO lbk_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ket chachama'y ensasanga si Jacob ay nameskhapeskhat isnan fachona sa et nenfacho is sako. Et inmannoannong nan nangisasangaana ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Inmey am-in nan an-akna ay nangay-ayew ken siya ngem inad-ina nan menliwliw-ancha ken siya. Kinwanina, “At olay engkhana's mateyak ya mitapi ak ken siya isnan kawad nan nenkatey et sisya'y ensasanga ak kayet.” Et siya chi ay insangasangana nan anakna ay si Jose. ");
INSERT INTO lbk_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Idwani, inomchan et nan cheycha'y Midianita id Egipto, sa cha't inlako si Jose ken Potifar ay esa'y takhon nan ali ya kapitan nan am-in ay khwarchiyana. ");
INSERT INTO lbk_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nakwas chi ya ket tinaynan Juda nan et-adna ya inmey ay nakisag-en ken Hira ay iyAdullam. ");
INSERT INTO lbk_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ischi et nan nanab-atana isnan inasawana ay Cananeo ay anak Sua. ");
INSERT INTO lbk_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Naliton si asawana ya inmanak is lalaki ay nginadnan Juda is Er. ");
INSERT INTO lbk_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kasin pay naliton ya inmanak kayet is lalaki ya nginadnan nan fafai is Onan. ");
INSERT INTO lbk_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Kasin kayet inmanak is lalaki ya nginadnana is Sela. Wad-ay si Juda id Akzib issan naiyanakan Sela. ");
INSERT INTO lbk_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Awni ya ket inpaasawan Juda nan yon-a ay anakna ay si Er ken Tamar. ");
INSERT INTO lbk_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ngem ngaag nan okhalin Er ya egay nalaychan si Dios Apo ken siya, isonga inalana. ");
INSERT INTO lbk_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Sa et kinwanin Juda ken Onan ay annochin Er, “En ka iyamong nan nailekkasan ay asawan yon-am, ta angnem nan lebfengmo ay angnen ken siya ta womad-ay ka is enwanen-ed nan natey ay yon-am.” ");
INSERT INTO lbk_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ngem ammon Onan ay et khechangna'y fakena enkwa nan sa na wad-ayen, isonga mo iseyepna nan chey ay nailekkasan, iwasitna nan kisitna ta maid ngomachan ay enfalin is anak san yon-ana. ");
INSERT INTO lbk_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nan inangnen Onan et inpasongetna si Dios Apo ya ke na't ay inala akhes siya. ");
INSERT INTO lbk_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ket ay kanan Juda isnan innapona ay Tamar, “Somakhong ka't is afong cha amam ya ad-i ka mangas-asawa engkhana'y maengngan nan anakko ay si Sela.” Siya chi nan kinwanina tay omegyat tay ta ket lang ya mapatey si Sela ay kag isnan yoyon-ana. Sa et sinmaa si Tamar ken cha amana. ");
INSERT INTO lbk_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Awni pay ya ket natey nan asawan Juda. Kakwasan nan naliwliwaana, inmey cha ken Hira ay ib-ana ay iyAdullam id Timnat ay mapokpokisan nan karnilona. ");
INSERT INTO lbk_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ket ay wad-ay nan nangifaag ken Tamar ay omey si katokhangana id Timnat ay en mamokis isnan cheycha'y karnilona. ");
INSERT INTO lbk_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ala na't ya kaan isnan panesna ya nensokat, sa na't inap-apan nan kamesna isnan apongotna, ya inmey tinmotokcho isnan pantew nan ili ay omey id Enaim ay malaosan isnan omayan id Timnat. Siya chi tay ammona ay naengngan et nan kasaodna ay si Sela ngem ket ay eg-ay naiyasawa ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Idwani, isnan nangil-an Juda ken siya, kanana't mo esa'y asi ay fafai tay naaap-apan nan kamesna. ");
INSERT INTO lbk_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Sa et sinmag-en isnan kawadna is kailit nan karsa sa na't kanan, “Ayet! Kaat pay nan kanam?” (Tay eg-ayna inmatonan ay innapona pet siya.) Ket ay kanan Tamar, “Ngag kay nan ichowam ken sak-en?” ");
INSERT INTO lbk_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“At omipaiyali ak ken sik-a is innanak si karching ay talakenko.” Kinwanin et Tamar, “Siya achi, mo omagtan ka is iigtok ay kag sarchan nan chey karching engkhana'y ipaiyalim.” ");
INSERT INTO lbk_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“Ngag kay nan ichowak ay kag na sarcha?” kinwanina. “Nan sana'y matonmo ay iyoowaymo ya nan sokodmo ay eegnam,” kinwanina. Et siya chi ay inchowana chana ken siya, sa na't inseyep, et naliton si Tamar. ");
INSERT INTO lbk_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Sinmaa et si Tamar sa na't kinaan nan inyaap-apna ya kasin nenpanes. ");
INSERT INTO lbk_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Idwani, osto'y inpaiyey Juda isnan ib-ana ay si Hira nan chey innanak si karching isnan chey fafai ta sa na't alaen nan cheycha'y insarchana ken siya, ya ket maid inchanan Hira ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Sa et nensalodsod isnan cheycha'y lallalaki ischi ay iyEnain ay mangwanin, “Ento pay san asi ay fafai ay entotototokcho isna's ilit si karsa?” “Ay ke man wad-ay paat asi's fafai isna?” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Sa et sinmakhong ken Juda ay mangwanin, “Ya ke maid inchanak ken siya mo! Sa et kanan nan cheycha'y lallalaki ischi en maid kano paat asi ay fafai ischi.” ");
INSERT INTO lbk_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","“Ngag ngotom ta igtona chachi. Ad-ik laychen ay maang-ango ta isnan takho. Olay ket pinachasko ay mamayad ken siya. Kanak ta fayachak siya, ngem nay met egay ka nakad-an ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nakwas pay nan tolo ay fowan, ya ket wad-ay nan nangifaag ken Juda ay nangwanin, “Nen-angnen pet is asi nan innapom ay si Tamar, tay nay ya ket aped la maliton.” Infilin et Juda ay mangwanin, “Ifalayo siya ta mapoowan.” ");
INSERT INTO lbk_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Isnan cha maipafal-an Tamar, inpaifaagna ken katokhangana ay mangwanin, “Naliton ak isnan lalaki ay nenkwa isnan naycha. Isin-engmo achi ta ilaem mo sino nan nenkwa isnan naycha ay maton ay oway ya sokod.” ");
INSERT INTO lbk_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Inmatonan Juda nan cheycha'y kwana ke na't kanan, “Sak-en pet nan nakafasol. Nalenlenteg siya mo sak-en tay egayko tinongpal nan lebfengko ay angnen ay mangipaasawa isnan anakko ay si Sela ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Isnan inomchanan nan nenkimenan Tamar nadlaw et ay apik nan ilillitona. ");
INSERT INTO lbk_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Et isnan cha na omanakan, inpafalan nan esang nan limana, sa et inalan nan enpaan-anak ya tinakedna is sinolid ay enkilat sa na't kanan, “Siya na nan omon-ona ay maiyanak.” ");
INSERT INTO lbk_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Nay met achi kasina innenat san limana ya ket ay nan kaapikna et nan nang-ona ay finmala. Sa et kinwanin nan enpaan-anak, “Ke pet kag tona nan ikkam ay pomortot!” Isonga nangadnan is Perez. ");
INSERT INTO lbk_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Sa et inmonod ay naiyanak nan kaapikna ay natakchan is enkilat ay sinolid nan limana ya nangadnan is Zera. ");
INSERT INTO lbk_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Idwani inyey et nan cheycha'y Ismaelita si Jose id Egipto, ya inlakocha ken Potifar ay esa isnan cheycha'y takhon nan ali ya kapitan nan khwarchiya isnan palasyona. ");
INSERT INTO lbk_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Wawawawad-ay si Dios Apo ken Jose et sinomya nan am-in ay inang-angnena. Nakitee siya isnan afong nan apona ay iyEgipto ");
INSERT INTO lbk_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","et finigfig nan apona ay tatakchowen Dios Apo siya ya nay et sinomya am-in nan inang-angnena. ");
INSERT INTO lbk_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Adi kad nalaychalaychan et si Potifar ken Jose sa na't inpey siya ay fokfokodna ay faa. Et siya nan nangipakarkhowana isnan am-in ay cha maang-angnen isnan afongna ya nan am-in ay kwana. ");
INSERT INTO lbk_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Et mailapo ischi, khapo ken Jose, ket ay binindisyonan Dios Apo nan pangafong Potifar ya nan kwana: am-in nan wad-ay is afongna, id ilit, ya nan am-in ay molana. ");
INSERT INTO lbk_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Siya, inpakarkhona nan am-in ay kwana ken Jose, ya maid kasina chonnen ischi mod-i ket mangan yangkhay. Si Jose, makneg ya khawis nan ilana. ");
INSERT INTO lbk_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Awni pay ya ket ay fikhawen nan asawan nan apona siya sa na't awiawisen ay maseyep cha. ");
INSERT INTO lbk_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ngem nen-ad-i si Jose ay nangwanin, “Ilaem achi, intalek asawam ay apok ken sak-en nan am-in ay isyangkhay isnan afongna, ya maid chadlos na makibfiyangan tay wad-ay ak ay nangipakarkhowana isnan ngonon. ");
INSERT INTO lbk_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Wad-ay nan kalebfengak isnan nay ay afong ay kag isnan kalebfengana, et maid paat inyen-enatna is olay ngag sisa mod-i sik-a yangkhay, tay asawana sik-a. Ngag kay nan aped ko mangangnenan isnan kag tosa ay kangangngaakhan ya fomasol ak et yangkhay ken Apo Dios?” ");
INSERT INTO lbk_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Et olay inaloalokna si Jose isnan winakas ta maseyep cha, ngem khechangna ay inad-in kayet Jose, ya olay nan paat na maisag-enan yangkhay ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ngem isnan namingsan ay sinomkhepan Jose is afong ay en na enchonowan, ya maichan nan cheycha'y faa, ");
INSERT INTO lbk_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","alan et asawan Potifar ya lokpos isnan fachona ay mangwanin, “En ta maseyep!” Ngem ke na't ala ya layaw et nataynan nan fachona is kalimana. ");
INSERT INTO lbk_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Osto ay inilana ay tinaynan Jose nan fachona ya linmayaw, ");
INSERT INTO lbk_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ala na't ya wakis ya fokhaw isnan cheycha'y faana ay mangwanin, “Ilaenyo kay ya! Inyalin asawak nan Hebreo isna ta lomokloko ken chatako. Inmali is kakwartok ay pomilit, ngem alak ya fokhafokhaw. ");
INSERT INTO lbk_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Osto'y chinngena ay nenfokhaw ak, ala na't akhes ya layaw, et nataynan nan nay fachona is kakawadko.” ");
INSERT INTO lbk_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Sa na't inigto nan facho engkhana'y sinmaa si asawana ay apon Jose. ");
INSERT INTO lbk_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ya siya kayet chi nan inokhodna ken asawana. Kinwanina, “Nan chey Hebreo ay faa ay inyalim et sinkhepna nan kwartok ay pomilit. ");
INSERT INTO lbk_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ngem kek et ala ya fokhaw sa na't ala akhes ya layaw, et tinaynana nan nay fachona isnan kawadko.” ");
INSERT INTO lbk_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Sinmongesonget nan apon Jose isnan nanngelana isnan nangwaniyan asawana en, “Siya chi nan inikkan nan faam ken sak-en!” ");
INSERT INTO lbk_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ke na't inpatilew si Jose, sa cha't inpokok is kaipokpokokan nan falod si ali, ya ischi et nan nentetey-ana. ");
INSERT INTO lbk_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ngem wad-ay si Dios Apo ay nanegseg-ang ken Jose, nay et nalaychalaychan nan apo isnan fabfalochan ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ke na't ippey ay siya nan kikhad isnan am-in ay ib-ana ay falod ya menfiyang isnan am-in ay maang-angnen is kafabfalochan. ");
INSERT INTO lbk_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Adi kad maid et kasin masapol makibfiyangan san apo isnan fabfalochan isnan inpakarkhona ken Jose tay wad-ay si Dios Apo ken siya, nay et sinomya nan am-in ay inang-angnena. ");
INSERT INTO lbk_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Awni pay ya ket nan en-ap-apag isnan inomen nan alin si iyEgipto ya nan ap-apon si en-ot-oto isnan tinapay et inpasongetcha nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Sinosongetna nan naycha ay chwa ay takhona, ");
INSERT INTO lbk_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ke na't inpapokok chaicha is afong nan kapitan si khwarchiya isnan fabfalochan ay naipokokan Jose. ");
INSERT INTO lbk_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Pinilin nan kapitan si Jose ay ensilfi ken chaicha, ya inmannong nan naipokokancha. ");
INSERT INTO lbk_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Isnan esa'y maschem, nen-it-itaw san en-ap-apag ya san ap-apon si en-ot-oto, et teken nan ayen nan init-itaw nan waschin esang ken chaicha is kafabfalochan. ");
INSERT INTO lbk_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Isnan nawiitana ay en nangil-an Jose ken chaicha inilana ay kag makokorkor nan semekcha. ");
INSERT INTO lbk_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Sa na't kanan, “En man chadlos makokoloklot nan kitongyo idwani ay?” ");
INSERT INTO lbk_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“To! Wad-ay man nan init-itawmi ya nay maid makaipaawat mo ngag nan laychencha'y kanan,” kinwanicha. “Si yangkhay achi Apo Dios nan makabfalin ay mangifallikas isnan laychen nan it-itaw ay kanan,” kinwanin Jose. “Okhochenyo ed ken sak-en nan init-itawyo.” ");
INSERT INTO lbk_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Sa et inokhod san en-ap-apag nan it-itawna ay mangwanin, “Isnan it-itawko, wad-ay nan kinmawat ay wakan si ofas ay sasakhangek, ");
INSERT INTO lbk_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ya tolo nan pingina. Isnan osto'y finmalaan nan tofona ya ket ay sinmafong sa et finomkhas is ofas ya ket ay nenkakaom. ");
INSERT INTO lbk_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Idwani, eegnak nan tasan nan ali, sak et inala nan fekhasna ya pinsitko is katasa ya inchowak ken siya.” ");
INSERT INTO lbk_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kanan et Jose, “Siya na nan laychena ay kanan: nan chey tolo ay pingi et tolo ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Isnan maikatlo ay akhew mailapo idwani at patongchowen nan ali sik-a, ya patoliyena sik-a isnan sikhod ay saadmo. Ta sam kasin ichad-awat nan tasana ay kag sinan sikhod ay cham ang-angnen id kasin ay sik-a nan pala ap-apagna. ");
INSERT INTO lbk_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ngem pangngaasim ta sosommek ka mo somya nan esam ikakkan. Et pangngaasim achi ta maseg-ang ka ta way paat kanam isnan ali maipoon ken sak-en, ya fachangam sak-en ay lomofos isna is kafabfalochan. ");
INSERT INTO lbk_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tay nan kinatet-ewana, et inalacha sak-en ay nangikaan isnan ilin si Hebreo, ya olay pay isna id Egipto et maid inang-angnek is khotokna is aped ko maibfalochan.” ");
INSERT INTO lbk_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Osto'y chinngen nan ap-apon si en-ot-oto ay khawis pet nan ayen san it-itaw nan pala ap-apag, kinwanina ken Jose, “Wad-ay akhes nan it-itawko. Aagtowek nan tolo'y nenkhakhat-on ay malalabfa ay tinapay. ");
INSERT INTO lbk_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Isnan nen-oson ay labfa, wad-ay nan am-in ay nateketeken ay ila ay oton si tinapay ay pala isnan ali, ngem ya ket ay wad-ay nan ay-ayam ay cha mannopek isnan wad-ay ischi.” ");
INSERT INTO lbk_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Sa et kanan Jose, “Siya na nan laychena ay kanan: nan tolo ay labfa et tolo ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Isnan maikatlo ay akhew mailapo idwani at ipatongchon nan ali sik-a, ta papotlongna nan olom! Sa na't isabfot nan awakmo isnan tokod ya at topken nan ay-ayam nan fekhas nan awakmo.” ");
INSERT INTO lbk_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Awni ya ket isnan maikatlo ay akhew, nenpapiyasta nan ali ay manemsemkana isnan naiyanakana, et inayakhana am-in nan cheycha'y takhona. Inpalofosna san chwa ay falod ay san pala ap-apag ya san ap-apo ay pala ot-oto, sa na't inyey chaicha isnan sakhang nan cheycha'y takhona. ");
INSERT INTO lbk_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Insoblina san pala ap-apag isnan sikhod ay saadna, ya kasin en-ap-apag pala isnan ali ");
INSERT INTO lbk_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ngem inpaisabfotna nan chey ap-apon si en-ot-oto. Et naangnen am-in tet-ewa nan infaag Jose. ");
INSERT INTO lbk_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Nay met achi egay et sinsinmek san pala ap-apag si Jose. Nalichongana siya. ");
INSERT INTO lbk_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Isnan nakwasan nan chwa'y tawen init-itaw nan ali ay tinmatakcheg siya is kailit nan wanga ay Nile. ");
INSERT INTO lbk_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ya inilana isnan it-itawna ay wad-ay nan pito ay alaalarmes ya khanag-awis ay faka ay chinmaka ay nalpo's kadchanom, sa cha't nen-ang-anglod isnan lokham. ");
INSERT INTO lbk_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Awni ya ket akhes chinmaka nan pito ay faka ay nenkafikhot ya nenkakig-angan. Sa cha't inmey naidchipa isnan inmona ay pito ay faka is kailit nan wanga. ");
INSERT INTO lbk_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ya ket ay kinan san nenkafikhot ay faka san alaalarmes ay faka. Sa et finmangon nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Osto'y kasin naseyep, ya ket nen-it-itaw kasin, ya inilana nan pito ay lowey ay cha ensechang ya fegfekhasan ay tinmofo isnan esang ay sanga. ");
INSERT INTO lbk_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Sa et wad-ay kayet nan pito ay lowey ay inilana ay nenkakpit ya linoyaw si chakhem ay nalpo's kamalalango ay lota. ");
INSERT INTO lbk_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ket ay inokmon nan nenkakpit nan chey nenkaptong. Siya chi ya ket ay finmangon san ali, ya ke pet it-itawna kayet chi. ");
INSERT INTO lbk_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nadchanadchanakhan et nan ali isnan chey ay wiit, sa na't inpaayag am-in nan cheycha'y ensop-ok ya nan cheycha'y mammasilib ay takho id Egipto. Inokhodna nan init-itawna ken chaicha, ngem maid paat makaipaawat isnan ayen nan it-itawna. ");
INSERT INTO lbk_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kinwanin et san en-ap-apag isnan ali, “Naipasmek idwani nan nenkamaliyak. ");
INSERT INTO lbk_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Issan namingsan sinmonget ka apo ken chakami ay chwa isnan chey ap-apon si pala ot-oto, sam et inpafalod chakami isnan afong nan kapitan si khwarchiya. ");
INSERT INTO lbk_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ke kami't nen-iitaw isnan esa'y maschem ya teken nan waschin ayen san init-itawmi. ");
INSERT INTO lbk_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Idwani, wad-ay nan esa'y ib-ami ischi ay esa'y fab-alo ay Hebreo ay faan nan kapitan, ya inokhodmi ken siya nan init-itawmi sa na't inpaawat nan waschin ayen nan it-itawmi. ");
INSERT INTO lbk_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ket ay tinmet-ewa san kinwanina. Insoblim sak-en isnan sikhod ay saadko ya inpaisabfotmo san pala ot-oto is tinapay.” ");
INSERT INTO lbk_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ket ay inpaayag nan ali si Jose sa cha't inpafala siya is kafabfalochan. Nenpapokis ya nensokat, sa et inmey isnan sakhang nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kanan et nan ali ken Jose, “Wad-ay nan init-itawko ngem maid makailawlawag isnan ayena. Chinngek ay mo chengngem nan it-itaw makaipaawat ka isnan ayena.” ");
INSERT INTO lbk_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Sa et kinwanin Jose, “Maid mabfalinko apo, ngem si Apo Dios nan makaipaawat isnan ayena ay enkhawisan nan ali.” ");
INSERT INTO lbk_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kanan et nan ali ken Jose, “Init-itawko maachi ay tinmatakcheg ak is kailit nan wanga ay Nile. ");
INSERT INTO lbk_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ya ket chinmaka ay nalpo is kadchanom nan pito ay faka ay alaalarmes ya khanag-awis, sa cha't cha en-anglod isnan lokham. ");
INSERT INTO lbk_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mawnin pay ya ket akhes chinmaka nan pito ay nenkafikhot ya nenkakig-angan ay faka. Kecheng cha is inilak ay kag tod-i isnan olay entona isna id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Idwani, ya ket kinan nan nenkafikhot ay faka nan cheycha'y alaalarmes ay faka. ");
INSERT INTO lbk_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ngem maid makadlaw ay kinancha nan alaalarmes ay faka, tay khechangna'y sisya kayet ay nenkafikhot cha ay kag isnan sikhod. Sak et fomangon. ");
INSERT INTO lbk_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Wad-ay akhes nan init-itawko ay nensechang ay pito ay lowey ay fegfekhasan ay tinmofo isnan esa'y sanga. ");
INSERT INTO lbk_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Awni pay ya ket wad-ay kayet nan pito ay nenkakpit ay lowey ay linoyaw si chakhem ay malpo's kamalalango ay lota. ");
INSERT INTO lbk_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Sa et inokmon nan nenkakpit ay lowey san pito ay nenkaptong. Inokhodko nan naycha'y init-itawko isnan cheycha'y ensop-ok, ngem maid paat makaipaawat ken sak-en mo ngag nan ayencha.” ");
INSERT INTO lbk_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Sinongfatan Jose nan ali ay mangwanin, “En-iso nan ayen nan chwa ay it-itawmo. Inpaammon Apo Dios nan nganngani ay angnena. ");
INSERT INTO lbk_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nan pito'y alaalarmes ay faka et pito ay tawen nan ayena. Siya akhes isnan pito ay fegfekhasan ay lowey. En-iso nan ayencha. ");
INSERT INTO lbk_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nan pito ay nenkafikhot ay faka ay inmod-ochi ay chinmaka ay nalpo's kadchanom, ya nan pito ay nenkakpit ay lowey ay linoyaw si chakhem, et pito ay tawen ay fitil. ");
INSERT INTO lbk_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kag sinan apchas ko infakha ken sik-a apo, inpailan Apo Dios nan sa na angnen. ");
INSERT INTO lbk_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","At wad-ay nan pito ay tawen ay omaw-awas nan ngonon isnan olay entona isna id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ngem kakwasana sa et omchan akhes nan pito ay tawen ay fitil. Ya at malichongan nan nar-os ay pito ay khanag-awis ay tawen tay at pakawasen nan fitil nan ili. ");
INSERT INTO lbk_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Siya, nan cheycha'y tawen ay omaw-awas nan makakan et chadlos malichongan, tay at chad-ama nan fitil ay omchan. ");
INSERT INTO lbk_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nan laychen nan kasin napidwaan nan it-itawmo ay kanan et kinedchengan Apo Dios nan angnena, et siya chi nan angnena ay angnen isnan ad-i omannong. ");
INSERT INTO lbk_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Idwani, khawis koma mo pomili ka is lalaki ay masilib ya makaawat ta ippeymo siya ay mangichalan isnan am-in ay ili isnan Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pomili ka akhes apo si tapina ay en-apo, ay mangal-ala isnan pagkalma isnan am-in ay maani isnan timpon nan pito'y tawen ay omaw-awas nan maani. ");
INSERT INTO lbk_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Filinem chaicha ay manakhop isnan am-in ay maala ay makakan isnan chey khawis ay tawen ay omali, ya agtam chaicha is lebfengcha ay mangigto isnan maani isnan maipaypay-ana isnan chadchake ay ili sa cha't tokkhongan. ");
INSERT INTO lbk_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nan naycha ay makakan ay cha maigto nan sa maipafala isnan pito'y tawen ay fitil ay omchan isnan Egipto, ta maid matey is owat.” ");
INSERT INTO lbk_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Idwanin, tinan-oyan nan ali ya am-in nan faana nan infaag Jose. ");
INSERT INTO lbk_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Sa et kanan nan ali, “Ay ke tako makaanap is khagkhag-awis mo si Jose, ay wad-ayan nan Ispiriton nan Dios?” ");
INSERT INTO lbk_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Sa na't kanan ken Jose, “Tay inpailan nan Dios am-in na ken sik-a, nalatak ay wadwad-ay nan silib ya pinang-awatmo mo nan olay sino issa. ");
INSERT INTO lbk_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Idwani ippeyko sik-a ay matangtangad isnan am-in ay iyap-apowak, et am-in ay takhok et sa cha patiyen nan filinmo. At maikadwa ka ken sak-en ay enlebfeng. ");
INSERT INTO lbk_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Nay chotokak et sik-a ay khofernachor isnan olay entona issa isna id Egipto.” ");
INSERT INTO lbk_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Sa et kinaan nan ali nan alitosna ay namatonan isnan maton si ali sa na't inpey is kalecheng Jose. Inpafachona nan napateg ay facho ken siya, sa na't inpaoway nan fallitok. ");
INSERT INTO lbk_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Sa na't inpalokhan isnan ikadwa ay kalisan si ali ya namangpango nan takhona ay mangifogfokhaw en, “Enfalintomeng kayo! Enfalintomeng kayo!” Adi kad nadchotokan si Jose ay enkhofernachor isnan am-in ay ili id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kinwanin akhes nan ali ken siya, “Sak-en nan ali, ya ipatengngelko am-in ken sik-a nan takho isnan olay entona isnan am-in isna id Egipto, ta ad-icha paat igkhiwa nan lima paymo sikicha mo ad-im ipalofos.” ");
INSERT INTO lbk_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Sa na't nginadnan si Jose is Zafenat Panea, sa na't agtan siya's asaw-ena ay si Asenat ay anak Potifera ay pachi isnan ili ay Heliopolis. Tolon poo nan tawen Jose issan lapona ay nensilfiyana isnan ali id Egipto. Tinaynana nan kawad nan ali sa na't finaat ay en nangila isnan olay entona ischi ay ili. ");
INSERT INTO lbk_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Isnan timpon nan pito'y tawen ay inmaw-awas nan makakan, inpatofon nan lota nan nawadwad ay maani ");
INSERT INTO lbk_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ya cha inpaamong Jose nan chatag sa na't inpaigto isnan kaallaallang nan am-in ay ili. Adi kad inpaigtona isnan waschin ili nan naani isnan cheycha'y nenlilwes ay payew ischi kannay ay ili. ");
INSERT INTO lbk_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Chadlos omawas ay kag ofod is kafayfay nan cheycha'y naani ay inigtona, ya eg-ay et kasin sinas-alop Jose tay ad-i kasalop. ");
INSERT INTO lbk_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Isnan sisya'y eg-ay inomchanan nan fitil, chwa et nan an-ak Jose ay lallalaki ay inyanak Asenat ay asawana. ");
INSERT INTO lbk_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Kinwanina, “Finachangan Apo Dios sak-en ay menlichong isnan am-in ay likhatko ya nan ilewko isnan am-in ay pangafong ama.” Siya chi't ya nginadnana nan inmona ay anakna is Manases. ");
INSERT INTO lbk_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Awni pay ya kasin inmanak, ya nginadnan Jose nan nay ay maikadwa ay anakna is Efraim ay nangwanin, “Siya sa nan ngachana tay inpakhanak Apo Dios sak-en isnan ili ay nensikhafak.” ");
INSERT INTO lbk_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Awni pay ya ket nakwas nan pito ay tawen id Egipto ay inmaw-awas nan makakan. ");
INSERT INTO lbk_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Mailapo et nan pito ay tawen ay fitil, kag isnan kinwanin Jose. Wad-ay akhes nan fitil isnan am-in nan tapina ay ili, ngem id Egipto wad-ay nan naiigto ay makakan isnan olay entona ischi. ");
INSERT INTO lbk_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Isnan inomchanan et nan maowatan nan am-in id Egipto, ke cha't inmey ay nenseg-ang isnan ali is kanencha. Et infilina ay omey cha ken Jose ya angnencha nan ifaagna. ");
INSERT INTO lbk_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Osto'y chachama et nan fitil ya inmam-amed isnan olay entona ay ili id Egipto, tinekwafan Jose nan am-in ay allang et cha na inlako nan makakan isnan cheycha'y iyEgipto. ");
INSERT INTO lbk_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ya wad-ay akhes nan angsaangsan ay takho ay nalpo isnan olay entona ay ili ay inmey id Egipto ay lomako isnan makakan ken Jose, tay chad-ama nan fitil isnan olay entona. ");
INSERT INTO lbk_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Isnan nanngelan Jacob ay wad-ay nan makakan id Egipto, kinwanina isnan an-akna, “En kayo man aped yangkhay en-asiilaila ay? ");
INSERT INTO lbk_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kek cha chengngen ay wad-ay pet nan makakan id Egipto ya! En kayo et achi lomako ta ad-i tako matey pangkhep si owat.” ");
INSERT INTO lbk_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Sa et inmey nan sinpoo ay et-ad Jose ay lomako is makakan id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ngem eg-ay inpalofos Jacob ay maitakin si Benjamin ay chadlos etad Jose, tay omegyat tay ta ket lang ya way maangnen ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Adi kad khapo tay nabfitil akhes id Canaan, naitapi et nan an-ak Jacob isnan cheycha'y cha omey lomako is makakan id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Et si Jose kannay nan khofernachor ischi, ay mangil-ila isnan cha mailako ay makakan isnan omili. Adi kad inmey cha nan yoyon-ana ay nenfalintomeng ay nentowad isnan sakhangna. ");
INSERT INTO lbk_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Isnan nangil-an Jose ken chaicha, inmatonana chaicha, ngem inpailana ay kag na ad-i ammo chaicha. Finogtakana chaicha ay mangwanin, “Ento nan nalpowanyo?” “Apo, nalpo kami id Canaan, et inmali kami isna ay lomako is makakan,” insongfatcha. ");
INSERT INTO lbk_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Olay mo naimatonan Jose san eet-adna ngem chaicha eg-ay cha paat nakaimaton ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Sisinmekna san cha na init-itaw maipoon ken chaicha, sa na't kanan, “Inmali kayo yangkhay ay en-as-as! Inmali kayo ay mangila mo ento nan enkapsotan nan nay ilimi!” ");
INSERT INTO lbk_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Ad-i apo,” insongfatcha. “Inmali kami ay faam ay lomako yangkhay is makakan. ");
INSERT INTO lbk_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Sin-anag-i kami am-in. Egay kami inmali ay en-as-as, apo. Nalenteg kami ay takho.” ");
INSERT INTO lbk_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kanan kayet Jose ken chaicha, “Ad-i! Nan enkapsotan nan ilimi nan inaliyo!” ");
INSERT INTO lbk_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ke cha't kanan, “Apo, sinpoo ya chwa kami ay lallalaki ay sin-anag-i. Es-esang ay ama nan nalpowanmi ay wad-ay ischi id Canaan. Namaid nan esang ay annochimi ya chey ay wad-ay nan alilismi ken ama.” ");
INSERT INTO lbk_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","“Kanak chadlo ya! Inmali kayo ay en-as-as,” kinwanin kayet Jose. ");
INSERT INTO lbk_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","“Ngem kag tona nan katepnganyo: Isapatak isnan ngachan nan ali ay ad-i kayo makakak-aan sina engkhana ay omali nan alilisyo isna. ");
INSERT INTO lbk_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ifaayo nan esang ken chakayo ay en mangala ken siya. Magkhwarchiyaan isna nan tapina engkhana ay matet-ewaan nan kinwaniyo. Tay mo ad-i, tet-ewa nan insapatak isnan ngachan nan ali ay chakayo et inmali kayo ay en-as-as.” ");
INSERT INTO lbk_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Siya chi ya infalodna't chaicha am-in is tolo ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Isnan mikatlo ay akhew, kinwanin Jose ken chaicha, “Sak-en nan esang ay mangiyegyat ken Apo Dios, et takhowek chakayo mo ket angnenyo nan esang yangkhay ay kanak. ");
INSERT INTO lbk_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ta matet-ewaan ay nalenteg kayo, makhayad nan esang ken chakayo isna is kafabfalochan. Nan tapina mabfalin ay somaa cha ta iyeycha nan makakan isnan cheycha'y papangafongyo ay maoowat. ");
INSERT INTO lbk_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Sa et masapol ay iyaliyo nan alilisyo ken sak-en. Siya na nan mangipaila ay tet-ewa nan kankananyo, ya at ad-ik ipapatey chakayo.” Et siya chi ay tinan-oyancha chi. ");
INSERT INTO lbk_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ngem cha cha kankanan, “Chey, idwani selaeg tako et ay maipap-alikhat sinan inangnen tako isnan annochi tako. Inila tako nan chadlos likhatna issan cha na nenseg-angan ken chatako ngem ad-i tako chengchengngen. Isonga chatako et idwani nan enliglikhat.” ");
INSERT INTO lbk_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kanan et Ruben, “Kanak chadlo en ad-iyo oy-oyongen siya ya! Ngem ad-iyo met chengngen. Nay et maifales ken chatako nan chalana.” ");
INSERT INTO lbk_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ad-icha ammo ay ke pet naawatan Jose am-in nan kankanancha, tay nan inikkana ay nakitot-oya ken chaicha et maichalan isnan takho ay cha mangifallikas isnan kalin si iyEgipto. ");
INSERT INTO lbk_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Sa et tinaynan Jose chaicha ya inmey nen-akha. Sa et kasin tinmoli ken chaicha isnan kasina makakaliyan, sa na't pinili si Simeon ay maitaked isnan sakhangcha. ");
INSERT INTO lbk_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Infilin et Jose ay ponnencha am-in nan sakon nan et-adna isnan makakan ya maisobli nan sipingcha is kasakocha, ya sa cha't maagtan is sengetcha. Et siya chi nan naangnen. ");
INSERT INTO lbk_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Adi kad inkarkhan nan et-adna is kadangkicha nan kasakosako ay makakan ay linakwancha, sa cha't nenligwat. ");
INSERT INTO lbk_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Isnan inomyanancha is kachalan, finadfad nan esang ken chaicha nan taked nan sakona ta pakanena nan dangkina, ke na't inchanan nan sipingna is kasakona. ");
INSERT INTO lbk_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kinwanina't, “Da! Ya ke nay nan sipingko ay naisobli isna? Naay sina's kasakok,” kinwanina. Ke cha't nginmaya ya chad-ama nan egyatcha ay nen-iinnila ay mangwanin, “Ngag mampet na's inangnen Apo Dios ken chatako?” ");
INSERT INTO lbk_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Isnan sinmaalancha ken amacha ay Jacob id Canaan, infaagcha nan am-in ay naang-angnen ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Finogtakan nan khofernachor id Egipto chakami, sa na't pabfasolen chakami ay mangwanin inmey kami kano ay en-as-as isnan ilina. ");
INSERT INTO lbk_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kinwanimi ay nalenteg kami ya egay kami inmey ay en-as-as. ");
INSERT INTO lbk_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ya infaagmi ay sinpoo ya chwa kami am-in ay sin-et-ad ay lallalaki, ya es-esang nan ama ay nalpowanmi. Namaid nan esang, ngem sisya nan alilis, ya wad-ay isna id Canaan ken sik-a ay amami. ");
INSERT INTO lbk_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ke na't kinwani ken chakami, ‘Naay nan sak mangammowan mo tet-ewa ay nalenteg kayo. Mataynan ken sak-en nan esang. Isaayo ay tapina nan makakan isnan maoowat ay papangafongyo, ");
INSERT INTO lbk_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","sa yo't iyai ken sak-en magtek nan alilisyo. Siya sa nan mangammowak ay egay kayo inmali ay en-as-as isnan ilimi, mod-i ket tet-ewa kayo. Et sak isobli nan etadyo ken chakayo ya nawaya kayo ay enkomerso isna.’ ” ");
INSERT INTO lbk_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Idwani waschin et nangipakfo isnan wad-ay isnan sakona ya ket ay waschin nangila isnan masosopot ay sipingna. Isnan nangil-ancha isnan siping chachama et nan egyatcha, olay si amacha ay Jacob. ");
INSERT INTO lbk_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kanan et amacha ken chaicha, “Ay laychenyo ngen ay madchongaw am-in nan an-akko? Maid si Jose ya sa et si Simeon, ya idwanin nay laychenyo ay ikaan akhes si Benjamin! Sak-en et nan maamongan am-in nan naycha ay likhat.” ");
INSERT INTO lbk_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kanan et Ruben ken amana, “Mo ad-ik maisaa si Benjamin, mabfalin ay pateyem nan chwa'y an-akko. Ipakarkhom siya ken sak-en, et sak itoli siya ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ngem kanan Jacob, “Ad-i maifoweg nan anakko, tay natey nan chadlos na akhi ya siya yangkhay nan nataynan. Am-ama ak et, ya mo itakinyo siya sa et wad-ay maangnen isnan chalan, at matey ak ay chadlos ensasanga isnan inangnenyo.” ");
INSERT INTO lbk_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Sisya'y chachama nan fitil id Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Et isnan nangkhayan nan kanen nan pangafong Jacob ay linakwancha id Egipto, kinwanina isnan an-akna, “Tomoli kayo ay en lomako is akit ay kanen tako.” ");
INSERT INTO lbk_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ya ket kanan Juda ken amana, “Chadlos finag-an nan chey lalaki chakami ay nangwanin ad-ina chawaten chakami mo ad-i mi itakin nan annochimi. ");
INSERT INTO lbk_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Mo ipalofosmo ay makieey ken chakami nan annochimi, et omey kami ay lomako is kanem. ");
INSERT INTO lbk_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ngem mo iyad-im, et ad-i kami, tay kinwanin nan lalaki ay ad-ina chawaten chakami mo ad-imi itakin nan annochimi.” ");
INSERT INTO lbk_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kanan et Israel, “En kayo man chadlos omipalikhat isnan en kayo nangifag-an isnan lalaki ay wad-ay teken si akhiyo ay?” ");
INSERT INTO lbk_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kinwanicha'y sinmongfat, “Siya man tay maid ad-i na salodsodchen maipoon ken chakami ya nan pangafong tako. Sinalodsodna mo sisya'y matatakho ka ay amami, ya mo wad-ay teken si etadmi ay lalaki. Et masapol ay sebfatenmi nan salodsodna. Ay ke mi ammo ay sa na pet ipaayag nan annochimi?” ");
INSERT INTO lbk_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kinwanin Juda ken amana, “Ipalofosmo ta ifowegko nan annochimi ta sa kami't maligwat kannay, ta chakami, sik-a, ya nan anan-ak, et matakho cha ya maid matey si owat. ");
INSERT INTO lbk_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Sak-en nan somongfat isnan fiyagna. Et sak kikhad ken siya. Mo ad-ik isakhong siya ay enkhagkhawis at sak-en nan chadlos kawad si fasol is eng-engkhana. ");
INSERT INTO lbk_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Mo sa egay kami inmannong ay nensasaed, et away ikapidwa na is tinmoliyanmi.” ");
INSERT INTO lbk_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kinwanin et amacha, “Mo siya sa nan masapol ay maangnen, angnenyo na: Ipenpenyo isnan sakoyo nan kakhawisan ay winad-ay nan lota isna id Canaan, ta en yo ilayad isnan khofernachor ischi. Omiyey kayo is akit ay akhas ay nalpo isnan kaew, akit ay itlog si yokan, astragalo, laudano, piniones ya almendras. ");
INSERT INTO lbk_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ya pidwaenyo nan kaad-achan si siping ay itakinyo, tay masapol ay isakhongyo nan inchananyo ay siping isnan sakoyo. Away nget nenkammali cha. ");
INSERT INTO lbk_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Itakinyo nan annochiyo sa kayo't omey ay manakhang ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Asop ya si Apo Dios ay Makabfalin isnan Am-in nan wad-ay isnan chey ay lalaki ta seg-angana chakayo, ya isakhongna si Benjamin ya nan etadyo ay si Simeon ken chakayo. Ngem mo mamaid nan an-akko, et olay siya.” ");
INSERT INTO lbk_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Adi kad inalan et nan cheycha'y sin-et-ad nan ilayadcha ya nan mamidwa ay kaad-achan si siping, sa cha't naligwat ay omey id Egipto. Infowegcha si Benjamin sa cha't inmey ay nanakhang ken Jose. ");
INSERT INTO lbk_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Isnan nangil-an Jose ken Benjamin ay fowegcha, kinwanina isnan faana ay mangil-ila isnan afongna en, “Ipangom nan naycha'y lallalaki is afongko, et sa cha makikan ken sak-en isnan alas chosi. Pomarki ka sam et nongnongen.” ");
INSERT INTO lbk_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Inangnen nan faa nan naifilin et inyeyna nan cheycha'y sin-anag-i is afong Jose. ");
INSERT INTO lbk_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Isnan cha cha maipangowan is kaafong Jose, omeegyat cha sa cha't kanan, “Inyalicha chatako isna maipoon isnan siping ay naisobli is kasako tako issan laplapona. Sa cha't chepapen chatako sa cha't alaen nan dangki tako ya khab-ena chatako is faa.” ");
INSERT INTO lbk_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Isnan inomchanancha ala cha ya eey isnan chey faa ay mangil-ila isnan afong ay wad-ay is kapantew ya kinwanicha, ");
INSERT INTO lbk_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Pangngaasim apo ta chengngem chakami, tay issan laplapona inmali kami ay linmako is makakan, ");
INSERT INTO lbk_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ngem isnan inomyananmi is kachalan isnan cha mi somaalan, inokfayanmi nan sakomi ya ket waschin nangchan isnan sipingna isnan sakona ya egay kakok-olangan. Nay et inyalimi ta isoblimi ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Inmitakin kami akhes isnan tap-in si siping ay ilakomi kasin is kanenmi. Ad-imi ammo mo sino nan nangippey isnan sipingmi is kasakomi.” ");
INSERT INTO lbk_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kinwanin et san faa, “Ad-i kayo madchanakhan. Ad-i kayo omegyat. Nan Diosyo ay Dios amayo nan nangisakhong nget isnan sipingyo is kasakoyo ta enkwayo. Chinawatko san infayadyo.” Sa na't infala si Simeon ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Sa et inpaskhep san faa nan cheycha'y sin-anag-i is afong Jose. Inagtana chaicha's chanom ay iyowascha isnan sikicha, sa na't pinangan nan dangkicha. ");
INSERT INTO lbk_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Sa cha't insakhana nan cheycha'y igwacha ken Jose mo omchan isnan alas chosi, tay naifaag ken chaicha ay at makikan cha ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Isnan sinmaalan Jose, iniskhepcha is afong nan chey ichowacha ken siya, sa cha't nenfalintomeng ay nentowad isnan sakhangna. ");
INSERT INTO lbk_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Sinalodsodna mo enkhagkhawis cha, sa na't kanan, “Infaagyo issan chey nan maipoon ken amayo ay nalakay. Ay khawis ngen siya? Ay matatakho ngen ya sisya'y enkhagkhawis?” ");
INSERT INTO lbk_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Sa cha't kanan, “Wen, nan faam ay amami et sisya'y matatakho ya enkhagkhawis.” Sa cha't nentowad ay nenchayaw ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Isnan nangil-an Jose ken Benjamin ay chadlos na annochi kinwanina, “Adi kad si tona nan alilisyo ay infaagyo ken sak-en. Si Apo Dios nan mamachang ken sik-a anakko.” ");
INSERT INTO lbk_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Alan et Jose ya kaan tay chadlos ay ad-i makaikatpe isnan liknana ken annochina, ya chadlos ay makaag-akha. Isonga ya ket ay sinomkhep is kakwartona et ischi nan nen-akhalana. ");
INSERT INTO lbk_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ala na't ya chilam-os, sa et finmala ay chadlos nangikakatpe isnan liknana, sa na't infilin ay isangocha et nan makakan. ");
INSERT INTO lbk_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Teken nan lamisaan Jose ay nangisangowancha isnan kanena, ya teken akhes ay lamisaan nan nangisangowancha isnan kanen nan et-adna. Teken kayet nan lamisaan nan iyEgipto ay mangmangan ischi, tay ngaakhen nan iyEgipto ay makikan isnan Hebreo. ");
INSERT INTO lbk_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Naiyornos nan inangnencha ay nangipatokcho isnan sin-ag-i mailapo isnan yon-a engkhana isnan annochi isnan sakhang Jose. Isnan nangil-ancha isnan naikkan ken chaicha'y naipatokcho, nen-asiila cha ay cha mataa. ");
INSERT INTO lbk_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nalpo is kalamisaan Jose nan naisango ken chaicha, sa et si Benjamin, maminlima nan kaad-achan nan khinaocha ay kanena mo nan et-adna. Et nangan cha ya nakiinom cha ken Jose engkhana'y nafotfotngan cha. ");
INSERT INTO lbk_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sa et infilin Jose isnan chey faa ay mangil-ila isnan afongna en, “Ponnem ay osto nan sakocha, ya ippeymo nan siping nan waschin esa isnan topek nan sakona. ");
INSERT INTO lbk_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Iyosonmo akhes nan silver ay tasak is kasakon nan alilis sa et nan sipingna ay lakon nan makakan.” Et siya chi inangnena nan naifilin ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Osto ay wiiwiit naipaligwat cha isnan dangkicha ay somaa. ");
INSERT INTO lbk_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Isnan nakaadchawi cha is akit isnan ili, ya ket kinwanin Jose isnan chey faana, “Kamowem ta kamakamem chachi, et mo edchanam chaicha kanam, ‘En man ngaag nan isofalityo isnan khawis ay? ");
INSERT INTO lbk_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","En yo man inakew nan silver ay tasan nan apok ay? Ke siya chi nan en-in-inomana ya! Siya chi nan os-osalena ay en-ipadto. Chachama nan fasol ay inangnenyo!’ ” ");
INSERT INTO lbk_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Isnan nangchanan san faa ken chaicha, infaagna nan kinwanin Jose ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Sa cha't kanan, “Apo, ngag nan laychem ay kanan isnan kinwanim? Ay ke mi maangnen nan kag tosa? ");
INSERT INTO lbk_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ammom met ay nan siping ay inchananmi isnan sakomi et inyalpomi id Canaan ay mangisakhong ken sik-a. En mi man akewen nan pilak paymo fallitok isnan afong nan apom ay? ");
INSERT INTO lbk_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Apo, mo maanapan ya way esang ken chakami is kawadna at maipapatey, ya enfalin kami ay tapina is faam.” ");
INSERT INTO lbk_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Sa na't kanan, “Siya achi. Ngem kecheng nan mad-asan nan tasa is enfaak. Et mabfalin ay mapalofosan nan tapina ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Adi kad waschin et kannay nangepas isnan sakona ay nangokfay ischi. ");
INSERT INTO lbk_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mineymey-an nan faan Jose ay nen-anap. Inlapona isnan yon-a engkhana isnan annochi, et naanapan nan tasa is kasakon Benjamin. ");
INSERT INTO lbk_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Alan et nan yoyon-ana ya peskhat isnan fachocha ay enngongoyos. Kasin cha inkarkha chachi isnan dangkicha, sa cha't tinmoli. ");
INSERT INTO lbk_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Isnan inomchanan cha Juda ya nan et-adna is afong Jose, sisya ischi siya. Sa cha't nenfalintomeng ay nentowad isnan sakhangna. ");
INSERT INTO lbk_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Sa et kinwanin Jose, “Ngag man chi's inangnenyo? Ad-iyo ngen ammo nan kafaelak? Tay olay sino ay wad-ay isnan nay ay saadko et kafaelana ay en-ila?” ");
INSERT INTO lbk_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","“Apo, ngag kay nan kasin mi kanan?” kinwanin Juda. “Ento nan ikkanmi ay kasin makilinnawag? Ngag nan ikkanmi ay mangipatet-ewa ay mid fasolmi? Si Apo Dios nan nangipafala isnan fasolmi. Enfaam et achi am-in chakami ta faken yangkhay nan chey nad-asan ay kawad nan tasa.” ");
INSERT INTO lbk_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kinwanin et Jose, “Na! Ad-i! Ad-ik maangnen sa. Kecheng nan nad-asan nan tasak is enfaak. Somakhong kayo am-in ay tapina ay enkhagkhawis ken amayo.” ");
INSERT INTO lbk_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Idwani, sinmag-en si Juda ken Jose ay nenseg-ang. Kinwanina, “Pangngaasim apo ta makikali ak ken sik-a. Et asop ya ad-i ka somonget tay kag ka met laeng ken Faraon ay ali. ");
INSERT INTO lbk_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Apo, sinalodsodmo ken chakami mo sisya si amami ya mo way teken ay etadmi. ");
INSERT INTO lbk_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Et infaagmi ken sik-a ay sisya si amami ay nalakay, ya wad-ay nan annochimi ay nawad-ay isnan nalakayana. Natey nan chadlos etadna ay lalaki et kecheng siya is nakhayad ken chaicha ay chodchodwa ay sin-akhi. Chad-ama nan layad ama ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Sa et apo, infakham ay iyalimi siya isna tatno ilaem. ");
INSERT INTO lbk_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Sa mi't infakha ken sik-a ay ad-i mabfalin ay taynana nan am-ama tay et siya nan kateyana. ");
INSERT INTO lbk_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ya kem et kanan en ad-i ka chomawat mo ad-i mi itakin nan alilismi. ");
INSERT INTO lbk_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Adi kad idwani issan tinmoliyanmi ken ama ay faam, infaagmi san infakham apo. ");
INSERT INTO lbk_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Issan kasina fomaalan ken chakami ay lomako is akit ay makakan, ");
INSERT INTO lbk_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","kinwanimi ay ad-i kami makaali tay at ad-i ka chomawat mo maid nan alilismi ay ifowegmi. Kinwanimi ay mabfalin yangkhay ay makaali kami mo maifoweg nan alilismi. ");
INSERT INTO lbk_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kanan et ama ken chakami, ‘Ammoyo met ay si Raquel ay asawak et chodchodwa cha nan inpafalana ay an-akko, ");
INSERT INTO lbk_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ya namaid nan esang ken chaicha. Away khinislakhislay si atap ay enkik-iwi tay egayko kasin inil-ila siya engkhana issan kinmaanana. ");
INSERT INTO lbk_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Et mo ikaanyo nan nay akhina idwanin ya wad-ay maangnen ken siya, at matey ak ay chadlos ensasanga isnan inangnenyo tay nalakay ak et,’ kinwanin ama. ");
INSERT INTO lbk_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Isonga idwanin apo, mo aped ak somaa isnan faam ay si ama ya maid nan annochi, at matey mo ilaena ay maid siya. Tay nan fiyag tosa ay annochimi nan manatakho ken siya, ya tay chadlos nalakalakay, et omanay nan mangipangoyosanmi ken siya is kateyana. ");
INSERT INTO lbk_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Esang kayet, apchas ko insapata nan fiyagko ken ama pala isnan annochimi. Infaagko ken siya ay mo ad-ik isakhong siya ken ama at sak-en nan chadlos kawad si fasol engkhana ay matey ak. ");
INSERT INTO lbk_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Isonga idwani apo, sak-en et yangkhay si enfaam mo ket ipalofosmo ay makitaoli siya isnan aag-ik. ");
INSERT INTO lbk_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tay ngag kay nan ikkak ay somaa ken ama mo maid nan annochik ay fowegko? At ad-i ak makaikatpe ay mangila isnan enliglikhatan ama,” kinwanin Juda. ");
INSERT INTO lbk_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Sa et tay ad-i et makaikatpe si Jose isnan liknana isnan kawadna isnan cheycha'y faana, infilina't ta komaan cha. Adi kad maid et teken is ib-ana isnan nangipaammowana isnan awakna isnan et-adna. ");
INSERT INTO lbk_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Et tay chadlos na inpapangekhe nan akhana, chinngen nan cheycha'y iyEgipto ampon inomchan nan chamag is kapalasyon nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kinwanin et Jose isnan et-adna, “Sak-en si Jose! Ay matatakho ngen kayet si ama?” Ngem isnan nanngelan nan et-adna ischi naegyaegyatan cha ya ad-i cha makasefat. ");
INSERT INTO lbk_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ket ay kanan Jose ken chaicha, “Somagsag-en kayo ken sak-en.” Sinmag-en cha, sa na't kanan, “Sak-en si Jose ay etadyo ay inlakoyo, ya naiyali ak isna id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Idwani, ad-i kayo koma chadlos madchanakhan paymo sosongten nan awakyo isnan nangilakwanyo ken sak-en isna, tay tet-ewa ay si Apo Dios nan nangipaona ken sak-en isna ta matakho kayo ya nan tapina ay takho. ");
INSERT INTO lbk_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Maikadwa yangkhay ay tawen na isnan fitil isnan lota. Sisya nan lima ay tawen kayet ay maid ensamsama ya en-an-ani. ");
INSERT INTO lbk_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Et inpaonan mampay Apo Dios sak-en mo chakayo ta matakho kayo ay matakho ya nan wanen-edyo ta ad-i kayo mamaid isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Adi kad nan kinatet-ewana et faken chakayo nan nangipaiyali ken sak-en sina mod-i ket si Apo Dios. Sa na't inpey sak-en ay mamagfakha isnan ali, ya katotongchowan ay takhona ay enlebfeng isnan am-in. Ya chak iyap-apowan nan am-in ay ili isna id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Idwanin, kamowenyo ay somaa ken ama ya kananyo ken siya, ‘Siya na nan kanan Jose ay anakmo: Inpey Apo Dios sak-en ay en-ap-apo isnan am-in ay ili id Egipto. Omali ka ay omali kannay. Ad-i kayo en-enaenat. ");
INSERT INTO lbk_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mabfalin ay entee kayo id Gosen ay maisasag-en ken sak-en: sik-a, nan an-akmo, nan apop-om, nan karnilom, karchingmo, nan fakam ya nan am-in ay kwam. ");
INSERT INTO lbk_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mo wad-ay kayo id Gosen, mabfalin ay nonongnongek chakayo, tay sisya kayet ay chaan nan lima ay tawen ay fitil. Tay ad-ik laychen ay wad-ay enkolangam, nan pangafongmo, ya nan enkik-iwiyem.’ ” ");
INSERT INTO lbk_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Kinwanina kayet, “Idwani, am-in kayo ya olay sik-a Benjamin et nay iilaenyo ay tet-ewa ay sak-en na ay si Jose ay manot-oya ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ifaagyo ken ama nan am-in ay kamabfalinko isna id Egipto, ya ifaagyo am-in nan inil-ilayo isna, sa yo't kamowen ay mangifoweg ken siya isna.” ");
INSERT INTO lbk_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ala na't ya kawe ken Benjamin ay etadna sa et nen-akha. Cha akhes en-akha si Benjamin ay mangawe ken yon-ana. ");
INSERT INTO lbk_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Sisya ay cha en-akha si Jose isnan nangawwelana ya namisitowana isnan waschin esa isnan et-adna. Osto'y siya chi ya ket chadlo tinot-oyan nan et-adna siya. ");
INSERT INTO lbk_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Isnan inomchanan nan chamag is kapalasyo ay wad-ay cha nan et-ad Jose, ket ay nalaychalaychan nan ali ya nan takhona. ");
INSERT INTO lbk_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kinwanin et nan ali ken Jose, “Ifaagmo isnan et-admo ta karkhaancha nan dangkicha ta sa cha't somakhong id Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Kanam ta iyalicha isna si amayo ya nan papangafongcha. Et sak ichowa ken chaicha nan kakhawisan ay lota isna id Egipto ya nan kakhawisan ay wad-ayen nan lota nan kanencha. ");
INSERT INTO lbk_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ifilinmo akhes ay mo somaa cha et omitakin cha isnan kalison ay malpo isna ay enlokhanan nan ongang-a, nan asaswacha ya si amayo ay ifowegcha isna. ");
INSERT INTO lbk_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ya ta ad-i cha kasin semkesemken nan mataynan ay kwacha, tay at kowaencha nan kakhawisan isna id Egipto.” ");
INSERT INTO lbk_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Adi kad inangnen nan an-ak Jacob nan naifilin ken chaicha. Inagtan Jose chaicha is kalison ay infilin nan ali sa na't sinengtan chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Inagtana akhes nan waschin esang ken chaicha is kakhawisan ay ensokatancha, ngem si Benjamin, tolon khasot ay silver ay siping ya lima ay kakhawisan ay ensokatana ay facho nan inchowana ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Inpaiyeyna ken amana nan sinpoo ay laki ay dangki ay nakarkhaan isnan kakhawisan ay wad-ay id Egipto, ya nan sinpoo ay fai ay dangki ay nakarkhaan is ilik, tinapay, ya nan tapina kayet ay senget. ");
INSERT INTO lbk_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Adi kad inpaligwatna't nan et-adna, ya isnan komaanancha, finag-ana chaicha ta ad-i cha masossosma is kachalan. ");
INSERT INTO lbk_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Siya chi't tinaynancha id Egipto et sinmakhong cha ken amacha ay Jacob id Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Kinwanicha ken siya, “Sisya pet ay matatakho si Jose! Siya nan ap-apo isnan am-in ay ili id Egipto!” Natakag si Jacob ya ad-i mamati ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ngem isnan nangifag-ancha isnan am-in ay infaag Jose ken chaicha, ya isnan nangil-ana isnan kalison ay inpaiyey Jose ta enlokhanana koma ay omey id Egipto, ya ket ay naimosngan. ");
INSERT INTO lbk_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kinwanina, “Sisya pet ay matatakho si Jose ay anakko! Maid et kasik kedchawen! Masapol yangkhay ay ek ilaen siya isnan sisya ay matatakhowak.” ");
INSERT INTO lbk_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Inpenpen et cha Israel am-in nan kwacha, sa cha't inmey id Beerseba ya nenchaton ischi ken Apo Dios ay Dios amana ay Isaac. ");
INSERT INTO lbk_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Idwani nenkali si Apo Dios ken siya isnan maschem isnan kag it-itawna ay nangwanin, “Jacob, Jacob!” “Wen Apo, naay ak,” insongfatna. ");
INSERT INTO lbk_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Sak-en si Apo Dios ay Dios amam,” kinwanina. “Ad-i ka omegyat ay omey id Egipto tay at pagkhanakek nan wanen-edmo ischi ta enfalin cha ay chakchake ay ili. ");
INSERT INTO lbk_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Wawawawad-ay ak ay mangifofoweg ken sik-a id Egipto ya et sak isakhong nan wanen-edmo isna. At wad-ay si Jose ay mangimit isnan matam isnan mateyam.” ");
INSERT INTO lbk_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Adi kad nenligwat cha Jacob id Beerseba. Et inpalokhan nan an-akna siya, nan ongang-a ay ap-ona, ya nan asaswacha isnan kalison ay inpaiyey nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Intakincha akhes nan cheycha'y talakencha ya nan cha cha chinakhop ay kwacha id Canaan, sa cha't inmey id Egipto. Intakin Jacob am-in nan pangafongna: ");
INSERT INTO lbk_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","am-in nan an-akna ya apop-ona. ");
INSERT INTO lbk_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Siya chana nan pangafong Israel ay naitakin ken siya id Egipto: nan yon-a ay anakna ay si Ruben, ");
INSERT INTO lbk_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ya nan an-akna ay lallalaki ay cha Hanoc, Pallu, Hezron ya si Carmi; ");
INSERT INTO lbk_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","si Simeon ya nan an-akna ay lallalaki ay cha Jemuel, Jamin, Ohad, Jakin, Zohar, ya si Saul ay anakna isnan fafai ay Cananeo; ");
INSERT INTO lbk_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","si Levi ya nan an-akna ay lallalaki ay cha Gerson, Cohat ya si Merari; ");
INSERT INTO lbk_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","si Juda ya nan an-akna ay lallalaki ay cha Sela, Perez ya si Zera. (Natey nan chwa ay an-akna ay cha Er ken Onan id Canaan.) Nan an-ak Perez ay lallalaki et cha Hezron ken Hamul; ");
INSERT INTO lbk_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","si Issacar ya nan an-akna ay lallalaki ay cha Tola, Pua, Yob ya si Simron; ");
INSERT INTO lbk_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","si Zabulon ya nan an-akna ay lallalaki ay cha Sered, Elon ya si Jaleel. ");
INSERT INTO lbk_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Siya chana nan an-ak cha Lea ken Jacob ay lallalaki id Mesopotamia sa et nan anakcha'y fafai ay si Dina. Am-in nan wanedna ay nalpo ken Lea et tolon poo ya tolo. ");
INSERT INTO lbk_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Siya chana kayet nan tapina ay pangafongna: si Gad ya nan an-akna ay lallalaki ay cha Zifion, Aggi, Suni, Ezbon, Eri, Arodi ya si Areli; ");
INSERT INTO lbk_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","si Aser ya nan an-akna ay lallalaki ay cha Jimna, Isva, Isvi, Beria, ya nan fafaicha ay si Sera. Nan an-ak Beria ay lallalaki et cha Heber ken Malkiel. ");
INSERT INTO lbk_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Siya chana nan sinpoo ya enem ay waned Jacob isnan faa ay si Zilpa, ay inchowan Laban ay kafachang nan anakna ay si Lea. ");
INSERT INTO lbk_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Nan an-ak Jacob ken asawana ay Raquel et cha Jose ken Benjamin. ");
INSERT INTO lbk_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Si akhes Jose et winad-ayna ken Asenat nan chwa ay lallalaki ay cha Manases ken Efraim id Egipto. Si Asenat nan anak Potifera ay pachi id Heliopolis. ");
INSERT INTO lbk_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Nan an-ak Benjamin ay lallalaki et cha Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Muppim, Huppim ya si Ard. ");
INSERT INTO lbk_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Siya chana nan sinpoo ya epat ay waned Jacob ken Raquel. ");
INSERT INTO lbk_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Nan tapina kayet ay pangafongna et siya chana: si Dan ya nan anakna ay lalaki ay si Husim; ");
INSERT INTO lbk_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","si Neftali ya nan an-akna ay lallalaki ay cha Jazeel, Guni, Jeser ya si Sillem. ");
INSERT INTO lbk_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Siya chana nan pito ay waned Jacob isnan faa ay si Bilha ay inchowan Laban ay kafachang nan anakna ay si Raquel. ");
INSERT INTO lbk_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Nan filang am-in nan chadlos pangafong Jacob ay inmey id Egipto et enem poo ya enem. Ad-i maitapi nan iinnapona ay fabfafai. ");
INSERT INTO lbk_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Sa et wad-ay nan chwa ay an-ak Jose ay naiyanak id Egipto. Adi kad issan inmayan cha Jacob id Egipto nenpiton poo et si among nan pangafongna ischi. ");
INSERT INTO lbk_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Idwani inpaon-onan Jacob si Juda ay en mangwani ken Jose ta sab-atena chaicha id Gosen. Adi kad isnan inomchanancha id Gosen, ");
INSERT INTO lbk_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","nenligwat si Jose ya nenlokhan isnan kalisana ay omey id Gosen ay en manab-at ken amana. Isnan nen-asiil-an cha, alan et Jose ya kawe isnan fakhang amana sa et nen-akhaakha. ");
INSERT INTO lbk_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Sa et kanan Israel, “Idwani olay et matey ak, tay nay inilak chadlo sik-a ya nay ammok ay sisya'y matatakho ka.” ");
INSERT INTO lbk_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Sa et kinwanin Jose isnan eet-adna ya nan tapin nan papangafong amana, “Masapol ay ennak ibfakha isnan ali ay inmali kayo ay et-adko ya am-in nan papangafong ama ay nalpo id Canaan. ");
INSERT INTO lbk_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ifaagko ken siya ay enpaspastor kayo ya intakinyo am-in nan talakenyo ay karnilo, karching, ya faka, ya am-in ay kwayo. ");
INSERT INTO lbk_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mo paayag nan ali chakayo ya salodsochena nan chonoyo, ");
INSERT INTO lbk_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","masapol ay kananyo ay mangwanin, ‘Chakami ay faam, et enpaspastor kami. Siya nan sikhod ay chonomi ay kag nan chonon nan ikik-itmi.’ Mo siya sa nan kananyo, et pailiyena chakayo id Gosen. Siya chi tay mid ngoton nan iyEgipto isnan enpaspastor tay law-en chi ay chono.” ");
INSERT INTO lbk_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Idwani inmey cha Jose ya nan lima isnan et-adna ay en nangila isnan ali. Sa et kanan Jose, “Inmali cha ama ya nan et-adko ay nalpo id Canaan. Intakincha nan talakencha ya nan am-in ay kwacha. Et nay wad-ay cha id Gosen.” Sa na't inyam-ammo nan et-adna isnan ali. ");
INSERT INTO lbk_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Sinalodsod nan ali mo ngag nan chonocha. Sa cha't kanan, “Apo, enpaspastor kami ay faam ay kag nan sikhod ay chonon nan ikik-itmi. ");
INSERT INTO lbk_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Inmali kami ay kanatee isna tay chad-ama nan fitil id Canaan et maid mabfalin si en-anglochan nan talakenmi. Pangngaasim koma ta ipalofosmo ay entee kami id Gosen.” ");
INSERT INTO lbk_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ket ay kanan nan ali ken Jose, “Idwani ay inmali si amam ya nan et-admo, ");
INSERT INTO lbk_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","kwacha et nan Egipto. Ifowegmo chaicha id Gosen ay kakhawisan isnan am-in nan ili isna, ta ischi nan entey-ancha. Et mo wad-ay makabfaer ken chaicha, ipakarkhom ken chaicha nan talakenko.” ");
INSERT INTO lbk_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Sa et infoweg Jose si amana isnan kawad nan ali, ya binindisyonan Jacob nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Sa et sinalodsod nan ali ay mangwanin, “Kaat nan tawenmo?” ");
INSERT INTO lbk_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Kanan et Jacob, “Sinkhasot ya tolon poo ay tawen nan natatakhowak ay ek nenlikchalikchan. Akit yangkhay chachi ay tawen ya nalikhat, ad-i kag nan inmannong ay tawen ay cha nenliklikchan san cheycha'y ikik-itko.” ");
INSERT INTO lbk_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Binindisyonan kasin Jacob nan ali sa et kinmaan. ");
INSERT INTO lbk_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Adi kad inpateen Jose cha amana ya nan et-adna id Egipto, et inischona ken chaicha nan kakhawisan ay lota ay sag-en nan ili ay Rameses ta enkwacha, tay siya chi nan infilin nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Et si Jose nan namangpangan ken amana, nan et-adna, ya am-in nan papangafong amana maiyafoloy isnan filangcha am-in nan ongang-a. ");
INSERT INTO lbk_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Chadlos chad-ama nan fitil, et maid paat makakan isnan olay entona. Et kinmapsokapsot cha nan iyEgipto ya iCanaan maipoon isnan owatcha. ");
INSERT INTO lbk_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Et si Jose, cha na tinopog am-in nan sipingcha ay lakon nan makakan ay cha cha lakwan, sa na't cha inyey is kaafong nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Isnan nangkhayan et nan siping nan iyEgipto ya iCanaan, inmey cha nan iyEgipto ken Jose ay mangmangwanin, “Omagtan ka is kanenmi. Ay ke kami aped matey isnan sakhangmo? Tay nangkhay et am-in nan sipingmi.” ");
INSERT INTO lbk_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Sinmongfat si Jose ay mangwanin, “Yaiyo nan talakenyo ta sokatak is makakan mo nangkhay nan sipingyo.” ");
INSERT INTO lbk_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Sa cha't inyey nan talakencha ken Jose et inagtana chaicha's makakan ay sokat nan kafaryocha, karnilo, karching, faka, ya dangkicha. Isnan chey ay tawen inagtana chaicha is makakan ay sokat nan cheycha'y talakencha. ");
INSERT INTO lbk_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Isnan maisned ay tawen, inmey cha kasin ken Jose ay nangwanin, “Ad-imi itafon nan kinatet-ewana ken sik-a apo. Nangkhay et nan sipingmi, ya inalam et am-in nan talakenmi. Maid et kasin nakhayad si igwami ken sik-a, kecheng yangkhay nan awakmi ya nan lotami. ");
INSERT INTO lbk_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Selaeg mi ay aped matey ya maiwayang nan lotami. Lakwam et chakami ya nan lotami mo ket mangan kami. Olay sa kami enpafab-aa isnan ali ya enkwana nan lotami, mo ket agtam yangkhay chakami is kanenmi ta ad-i kami matey ya ta way imolami, ta ad-i maiwayang nan lotami.” ");
INSERT INTO lbk_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Linakwan et Jose nan am-in ay lota id Egipto ay enkwan nan ali. Waschin esa ken chaicha ay iyEgipto et napilit ay nangilako isnan lotana tay chadlos chad-ama nan fitil, et nenkwan nan ali nan am-in ay lota id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Nenfalinen akhes Jose nan takho isnan am-in ay ili id Egipto ay enfaan nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kecheng yangkhay nan lotan nan papachi is eg-ayna linakwan. Ad-i cha masapol ilako nan lotacha tay nan papachi, wad-ay ay wad-ay nan cha ichowan nan ali ay ikatakhocha. ");
INSERT INTO lbk_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kinwanin Jose isnan katakhotakho, “Ilaenyo kay ya! Nay linakwak chakayo ya nan lotayo ay enkwan nan ali. Alaenyo et nan nay esek ta wad-ay is-ekyo. ");
INSERT INTO lbk_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Et mo en-ani kayo, ichowayo nan pagkalma isnan ali. Mabfalin ay osalenyo nan tapina ay pala esek ya kanen nan papangafongyo.” ");
INSERT INTO lbk_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Sa cha't kanan, “Tinakhom chakami. Khinmagkhawis ka ken chakami apo, et sa kami enfaan nan ali.” ");
INSERT INTO lbk_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Idwani khinmaeb si Jose is lenteg id Egipto ay masapol ay enkwan nan ali nan pagkalma isnan maani. Ya sisya kayet ay maang-angnen na ay lenteg engkhana idwani. Kecheng magtek nan lotan nan papachi is eg-ay nenkwan nan ali. ");
INSERT INTO lbk_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nentee nan Israelitas id Gosen ay sakop nan Egipto ya finmaknafaknang ya nakhanakhanak cha. ");
INSERT INTO lbk_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Et sinpoo ya pito ay tawen nan nentetey-an Jacob id Egipto engkhana'y sinkhasot ya epat poo ya pito nan tawena. ");
INSERT INTO lbk_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Issan nganngani ay mateyana, inayakhana nan anakna ay si Jose, sa na't kanan, “Pangngaasim ta ikkam nan nay ay kedchawek, ya ippeymo nan limam isnan enfet-akan nan chwa'y opok, sam et isapata ay tet-ewa ya osto ka ken sak-en. Ad-im ikaob sak-en isna id Egipto, ");
INSERT INTO lbk_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","mod-i ket omikaob kayo isnan naikaofan ikitko ya si ama. Ikaanmo nan awakko isna id Egipto ta ikaobmo sak-en isnan naikaofancha.” “Wen, at angnek nan kinwanim,” insongfat Jose. ");
INSERT INTO lbk_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Sa et kinwanin Israel, “Isapatam ay angnem ay angnen chi.” Nensapata si Jose ken Israel ay wad-ay isnan kaseypana, ya nenyaman si Israel ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Awni pay ya naifaag ken Jose ay masasakit si amana. Ke na't iyey nan an-akna ay cha Manases ken Efraim ta en cha am-in ilaen siya. ");
INSERT INTO lbk_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Osto ay naifaag ken Jacob ay inmali nan anakna ay si Jose ay mangila ken siya, inpeyna nan kafaelana ay tinmokcho is maseyseypana. ");
INSERT INTO lbk_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Kinwanin Jacob ken Jose, “Nenpaila si Apo Dios ay Makabfalin Am-in ken sak-en id Luz id Canaan, sa et binmindisyon. ");
INSERT INTO lbk_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kinwanina, ‘Chey! pagkhanagkhanakek sik-a ta enfalin ay angsan ay ili nan wanen-edmo. Ichowak nan nay ay lota isnan wanen-edmo ay sa cha enkwa is eng-engkhana.’ ” ");
INSERT INTO lbk_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Kinwanin kayet Jacob, “Sik-a Jose, et ifilangko ay osto ay an-akko nan sanacha ay chwa ay an-akmo ay naiyanak isna id Egipto issan sisya'y egayko inmaliyan. Siya, cha Efraim ken Manases et ifilangko ay an-akko chaicha ay kag met laeng ken cha Ruben ken Simeon. ");
INSERT INTO lbk_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mo way kasin cham wad-ayen is lallalaki, et ad-i cha maikwani ay an-akko mod-i ket ap-ok. Nan at tawichencha ay enkwa et malpo ken cha Efraim ken Manases. ");
INSERT INTO lbk_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Angnek na khapo ken inam ay Raquel. Chadlos ko insanga nan nateyana id Canaan ay ensag-en id Efrata issan chak tomoliyan ay nalpo id Mesopotamia. Et inkaobko siya isnan ilit nan karsa ay enpaEfrata.” (Betlehem nan ngachan nan Efrata idwani.) ");
INSERT INTO lbk_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isnan nangil-an Israel isnan an-ak Jose, kinwanina, “Sino pay chana?” ");
INSERT INTO lbk_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","“An-akko chana ay inchowan Apo Dios ken sak-en isna id Egipto,” kinwanina. “Yaim chaicha isna ta bindisyonak chaicha,” kinwanin Israel. ");
INSERT INTO lbk_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Idwani, tay ad-i makaila ay khawis si Israel tay nalakay et, inchoon Jose nan an-akna ken amana et finisitona ya kinnawena chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Kinwanin Israel ken Jose, “Kanak man mo ad-ik kasin ilaen sik-a, ngem nay pet inpalofos Apo Dios ay ilaek sik-a olay nan an-akmo.” ");
INSERT INTO lbk_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Sa et inyadchawin Jose nan an-akna isnan manatakchowancha ken ikitcha ay Israel sa et nenfalintomeng ay nentowad si Jose isnan sakhangna. ");
INSERT INTO lbk_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Sa et insag-en Jose si Efraim is kakannikhid amana ay Israel, ya si Manases ay yon-a insag-ena is kakannawana. ");
INSERT INTO lbk_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ngem ket ay nen-akpilen Israel nan limana ya inpatangna nan kannawana ken Efraim olay mo siya nan annochi, ya nan kannikhidna ken Manases ay yon-a. ");
INSERT INTO lbk_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Sa na't binindisyonan si Jose ay nangwanin, “Asop ya si Apo Dios ay insilsilfiyan ikit ay Abraham ya si ama ay Isaac et bindisyonana chaton-a ay fafallo! Asop ya si Apo Dios ay nangipangpango ken sak-en engkhana idwani ay akhew et bindisyonana chaicha! ");
INSERT INTO lbk_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Asop ya nan anghel ay nangisas-alak ken sak-en isnan am-in ay ngaag, et bindisyonana chaicha! Asop ya maitot-oloy ken chaton-a ay fafallo nan ngachanko ya ngachan ikit ay Abraham ya si ama ay Isaac. Asop ya makhanakhanak cha ya omangsan nan wanen-edcha isnan lofong!” ");
INSERT INTO lbk_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Eg-ay linayad Jose nan nangil-ana isnan nangipay-an amana isnan kannawan ay limana is kaolon Efraim ay annochi, idwani inalana nan chey ay liman amana ta iyatona koma is kaolon Manases. ");
INSERT INTO lbk_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kinwanina ken amana, “Faken sa's angnem ama, si ton-a nan yon-a. Ipatangmo nan kannawanmo isnan olona.” ");
INSERT INTO lbk_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ngem inad-in amana ay nangwanin, “Ammok anakko. At khechangna'y makhanakhanak akhes nan wanen-ed Manases ya machamchamag siya, ngem at wadwad-ay nan annochi mo nan yon-a, ya nan wanen-edna et enfalin cha ay angsan ay chadchake ay ili.” ");
INSERT INTO lbk_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Et binindisyonana chaicha isnan chey ay akhew ay mangwanin, “At osalen nan Israelitas nan ngachanyo ay mamindisyon isnan tapina. Kanan cha, ‘Asop ya khab-en Apo Dios chakayo ay kag ken cha Efraim ya si Manases.’ ” Kag todi nan inikkan Israel ay nangippey ken Efraim ay inmon-ona mo si Manases. ");
INSERT INTO lbk_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Sa et kinwanin Israel ken Jose, “Iilaem ay nganngani ak ay matey, ngem at wawawawad-ay si Apo Dios ken chakayo ya at isakhongna chakayo isnan ilin nan ikik-ityo. ");
INSERT INTO lbk_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sik-a, ya faken nan et-admo nan mangigwaak isnan ponchag id Sikem ay inalak isnan Amorreo isnan fadyokko ya nan pantolayko.” ");
INSERT INTO lbk_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Inayakhan Jacob nan an-akna ay mangwanin, “Lomikob kayo ta ifaagko nan sa omat ay enfalinanyo is tap-in akhew. ");
INSERT INTO lbk_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Omali kayo am-in ay an-ak Jacob. Maamong kayo ta chengngenyo sak-en ay amayo ay Israel. ");
INSERT INTO lbk_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Sik-a Ruben ay inaona, sik-a nan fikasko ya inmona ay anakko isnan kafikfikasko. Sik-a nan kadchayewan ya kawad-ayan nan kamabfalin isnan am-in ay an-akko. ");
INSERT INTO lbk_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kag ka isnan chanom ay ad-i maipap-a, faken sik-a nan kapapatekhan mo ke tay inseyepmo nan fafai ay iyaafongko et linogkhitam nan kaseypak. ");
INSERT INTO lbk_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“En-iso cha Simeon ken Levi ay sin-akhi. Osalencha nan natadman ay enkholo. ");
INSERT INTO lbk_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ad-i ak maitaptapi isnan itabtafoncha ay en cha tibfitibfiyen paymo isnan am-amongcha, tay pateyencha nan takho isnan songetcha, sa cha't pilayen nan laki ay faka ay siya nan enlagsakancha. ");
INSERT INTO lbk_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Machosa cha isnan songetcha tay ayaka, ya nan fongetcha tay maisik. At paapokek chaicha isnan olay entona id Israel, ta makiili cha isnan teketeken ay ili id Israel. ");
INSERT INTO lbk_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Sik-a Juda, at chayawen nan et-admo sik-a. At sam cha pen seket nan fosom. At enyongyong nan et-admo ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Siya, kag anak si layon si Juda. Pateyena nan chepapena sa et tomoli isnan afongna ay en-oyad, ya enchaolag. Ay ke way makaitoled ay manangaw ken siya? ");
INSERT INTO lbk_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","At eeeegnan Juda nan sokod si kinaali, ya en-apo nan wanen-edna is eng-engkhana. At enfowis nan tapina ay ili ken siya, ya siya nan isilfiyan nan kailiili. ");
INSERT INTO lbk_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","At itakedna nan innanak si dangkina olay isnan kakhawisan ay wakan si ofas. Ya olay nan fachona, et kag na cha lab-an isnan kag chala ay fayas. ");
INSERT INTO lbk_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Komikilat nan matana isnan fayas ay in-inomena. Ya pomopokaw nan fab-ana isnan khatas. ");
INSERT INTO lbk_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Si Zabulon akhes et is kailit nan fayfay nan entetey-ana. At omap-aponan si fangka ay ilit si fayfay nan kawadna. At omchan engkhana id Sidon nan sakopen nan ilina. ");
INSERT INTO lbk_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Si Issacar, et kag dangki ay aped enchaolag isnan tengan nan ento mo awitna. ");
INSERT INTO lbk_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ngem osto ay ilaena ay khawis pet nan iillengan ya kalal-ayad nan entetey-ana, et olay pikotena nan echegna ay enfelay, ya ket enfalin ay faa ay mapilit ay enchono. ");
INSERT INTO lbk_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Si Dan et en-apo isnan takhona ay kag isnan tap-in nan tribon nan Israel. ");
INSERT INTO lbk_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","At kag oweg siya is kailit nan karsa. Siya, kag khiwachay ay oweg ay wad-ay is kailit nan chalan ay maninget isnan sikin nan kafaryo tatno mabfalintowag nan ensasakay. ");
INSERT INTO lbk_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Sad-ek nan omisalakam Dios Apo. ");
INSERT INTO lbk_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“At choklosen si mangaakew si Gad, ngem at somakhong ay mangonod ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“At patofowen nan lotan Aser nan kagkhakhawisan ay makakan. At pafal-ena nan osto ay kanen si ali. ");
INSERT INTO lbk_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Si Neftali et kag ogsa ay nawaya ay entagtatagtag, ya kalal-ayad cha nan an-akna. ");
INSERT INTO lbk_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Si Jose et kag ab-abfekhas ay kaew isnan sag-en nan eb-eb, ay cha fomas-ang nan sangana isnan natoping ay alad. ");
INSERT INTO lbk_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kakaegyat nan ikkan nan fosona ay manoklos ken siya, ya chad-ama nan likhetcha ay mamapantolay ay mangat-atiko ken siya. ");
INSERT INTO lbk_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ngem khechangna'y eegnana kayet nan pantolayna ya fomifikas nan limana isnan kamabfalin nan Dios Jacob. Siya, fomifikas siya maigkhapo isnan Pastor ay kag Pegnad Israel. ");
INSERT INTO lbk_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Siya nan Dios amayo ay mamadfachang ken chakayo. Siya si Apo Dios ay Makabfalin Am-in ay mamindisyon ken chakayo. Ichawchawna nan ochan ay malpo id tongcho, ya chanom ay malpo is chaem nan lota. Pagkhanakena nan asaswa ya talakenyo, ");
INSERT INTO lbk_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ya bindisyonana nan apityo ya nan sabsafong, sa et akhes nan enkhawisan ay malpo isnan kafilifilig ay maid pengpengna. Asop ya oompa chana ay bindisyon isnan olon Jose. Tet-ewa, siya chana nan omchan is kakitong Jose ay naischo ay maisiyan isnan et-adna. ");
INSERT INTO lbk_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“At kag atap ay aso si Benjamin. Winiit ya minaschem ay enpatepatey si ischaena.” ");
INSERT INTO lbk_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Siya chachi nan sinpoo ya chwa ay tribon Israel ya siya chachi nan inyanongosna ay kinwani ay maifakhay isnan waschin esa ken chaicha isnan nganngani mateyana. ");
INSERT INTO lbk_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Sa et infilin Jacob isnan an-akna ay mangwanin, “Idwani tay nay et nganngani ak ay en maiyamong isnan ikik-itko ay cha nang-ona, omikaob kayo isnan naikaofancha ay liyang ay wad-ay isnan ponchag Efron ay Heteo, ");
INSERT INTO lbk_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","id Macpela ay apet falaan si akhew id Mamre ischi id Canaan. Linakwan Abraham chi ay liyang ya ponchag ken Efron ay en-ikak-aofancha. ");
INSERT INTO lbk_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Et ischi nan nangikaofancha ken Abraham ya si asawana ay Sara. Ischi nan nangikaofancha ken ama'y Isaac ya si inak ay Rebecca, ya ischi akhes nan nangikaofak ken Lea. ");
INSERT INTO lbk_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nalakwan nan chey ay ponchag ya liyang ay wad-ay ischi isnan cheycha'y Heteo. Ikaobyo sak-en ischi.” ");
INSERT INTO lbk_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Isnan nakwasan nan filin Jacob ket ay nensachag ya natey, ya naiyamong isnan ikik-itna. ");
INSERT INTO lbk_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Alan et Jose ya kawe ken amana ya cha enngegngeg ay cha mamisito isnan kames amana. ");
INSERT INTO lbk_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ket ay infilin Jose isnan faana ay en-ag-akhas ta barsamalencha nan awak amana. ");
INSERT INTO lbk_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Et epat poo ay akhew nan nabarsamalan nan awakna tay siya chi nan ekhadcha ay enbarsamar ischi ay ili. Inachokhan nan iyEgipto siya is piton poo ay akhew. ");
INSERT INTO lbk_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Isnan nakwasan san achogna, kinwanin Jose isnan cheycha'y takhon nan ali en, “Pangngaasiyo ta en kayo ifaag nan nay ay kanak isnan ali: ");
INSERT INTO lbk_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Issan nganngani matey si ama, inpasapatana sak-en. Kinwanina, “Nganngani ak ay matey. At sa ka omikaob isnan pantiyong ay insakhanak isnan awakko id Canaan.” Isonga pangngaasim ta ek ikaob siya ischi, sak et chadlo tomoli.’ ” ");
INSERT INTO lbk_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Sa et kinwanin nan ali, “Engka ta ikaobmo si amam, tay siya met nan inpasapatana ay angnem.” ");
INSERT INTO lbk_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Adi kad inmey si Jose ay nangikaob ken amana. Nakieey ken siya nan am-in nan takhon nan ali, nan nenkapateg ay takhona ya nan am-in ay aap-apo id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Nakieey cha akhes am-in ken siya nan pangafongna: nan ag-ina ya am-in nan pangafong amana. Kecheng nan ongang-a ya nan karnilocha, karchingcha ya fakacha nan nataynan id Gosen. ");
INSERT INTO lbk_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wad-ay nan nenkalisa ya nenkafaryo ay inmey ay naitakin ken siya. Ad-achowan cha nan nakieey. ");
INSERT INTO lbk_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Isnan inomchanancha isnan illikan id Atad ay apet falaan si akhew isnan wanga ay Jordan, ke cha't inpapangekhe ay nen-akha ay nen-achog ay inmannong, ya pito ay akhew nan cha nangiyangnenan Jose isnan ekhad si achogna. ");
INSERT INTO lbk_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Isnan nangil-an nan iCanaan isnan cheycha'y cha en-achog isnan iillikan id Atad, kinwanicha, “Aye! Ke pet chad-ama nan angnen nan iyEgipto ay en-achog!” Isonga nangadnan ischi ay chemang nan Jordan is Abel Mizraim. ");
INSERT INTO lbk_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Sa et inangnen nan an-ak Jacob nan infilina ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Inyeycha nan awakna id Canaan ay nangikaob is kaliyang id Macpela ay apet falaan si akhew nan Mamre, isnan ponchag ay linakwan Abraham ken Efron ay Heteo ay en-ikak-aofancha. ");
INSERT INTO lbk_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Issan nakwasan san nangikaofan Jose ken amana, tinmoli cha ay sin-anag-i ya am-in nan cheycha'y naitakin ken siya ay nakikaob, id Egipto. ");
INSERT INTO lbk_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Isnan nakwasan nan nateyan amacha, kinwanin nan et-ad Jose, “Ngag kay mo sisya nan songet Jose ken chatako ya semkena'y ifales am-in nan ngaag ay inangnen tako ken siya?” ");
INSERT INTO lbk_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Sa cha't nen-ifaa is omey ken Jose ay mangwanin, “Issan sisya'y matatakhowan ama, ");
INSERT INTO lbk_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","infilina ken chakami ta ifaagmi ken sik-a ay pangngaasim koma ta pakawanem nan fasol ay inangnen nan et-admo ken sik-a. Idwani pangngaasim ta pakawanem nan ad-i osto ay inangnenmi, ay faan nan Dios amam.” Nen-akha si Jose isnan nanngelana ischi. ");
INSERT INTO lbk_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Osto'y siya chi ya ket ay inmey cha nan et-adna et nenfalintomeng cha ken siya ay nangwanin, “Naay kami isnan sakhangmo ay enfaam,” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ngem kinwanin Jose ken chaicha, “Ad-i kayo omegyat. Ay ke ak Dios? ");
INSERT INTO lbk_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tet-ewa ay ngaag nan sinsinmekyo ay angnen ken sak-en, ngem nenfalinen Apo Dios is khawis ta matakho nan angsan ay takho ay wad-ay idwani. ");
INSERT INTO lbk_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Idwani ad-i kayo omegyat. At sak nonongnongen chakayo ya nan an-akyo.” Siya chi nan inangnena ay nangipafikas ay nangay-ayew ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Sa et nentee cha Jose ya nan papangafong amana id Egipto, et natakhotakho engkhana ay nentawen is sinkhasot ya sinpoo. ");
INSERT INTO lbk_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Natakhotakho ay nangila isnan an-ak ya apop-on Efraim. Ya wad-ay siya ay nanawat ay nangakwa isnan kafab-ala ay anak Makir ay anak Manases. ");
INSERT INTO lbk_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kinwanina isnan et-adna, “Nganngani ak ay matey, ngem wad-ay si Apo Dios ay mangil-ila ken chakayo engkhana'y ifalana chakayo id Egipto ay mangiyey ken chakayo isnan chey ili ay insapatana ken Abraham, Isaac ya Jacob.” ");
INSERT INTO lbk_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Sa et inpasapatan Jose nan pangafongna ay an-ak Israel ay mangwanin, “Isapatayo ken sak-en ay mo ipangon Apo Dios chakayo ischi ay ili, et sa yo itakin nan awakko.” ");
INSERT INTO lbk_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Et siya chi natey si Jose ay nentawen is sinkhasot ya sinpoo. Binarsamarcha nan awakna sa cha't inlongon ischi id Egipto.");
INSERT INTO lbk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Siya na nan katontonan Jesu Cristo ay nalpo isnan kaapon David ay naiwaned ken Abraham. ");
INSERT INTO lbk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham nan aman Isaac; si Isaac nan aman Jacob; ya si Jacob nan aman cha Juda ay sin-ag-i. ");
INSERT INTO lbk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda nan aman cha Fares ken Zara (si Tamar nan inacha); si Fares nan aman Esrom; ya si akhes Esrom nan aman Aram. ");
INSERT INTO lbk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram nan aman Aminadab; si Aminadab nan aman Naason; ya si Naason nan aman Salmon. ");
INSERT INTO lbk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon nan aman Boaz (nan inana si Rahab); si Boaz nan aman Obed (nan inana si Ruth); si Obed nan aman Jesse; ");
INSERT INTO lbk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ya si Jesse nan aman David ay ali. Si David nan aman Solomon (nan inana et san sikhod ay asawan Urias); ");
INSERT INTO lbk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","si Solomon nan aman Roboam; si Roboam nan aman Abias; ya si Abias nan aman Asa. ");
INSERT INTO lbk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa nan aman Josafat; si Josafat nan aman Joram; ya si Joram nan aman Ozias. ");
INSERT INTO lbk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Ozias nan aman Joatam; si Joatam nan aman Acaz; ya si Acaz nan aman Ezekias. ");
INSERT INTO lbk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esekias nan aman Manases; si Manases nan aman Amon; ya si Amon nan aman Josias. ");
INSERT INTO lbk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias nan aman cha Jeconias ay sin-ag-i. Siya chi san timpon san naikaanan nan Israelita ay naiyey id Babilonia. ");
INSERT INTO lbk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kakwasan nan naiyeyancha id Babilonia, naiyanak si Salatiel, et si Jeconias nan amana. Si Salatiel nan aman Zorobabel; ");
INSERT INTO lbk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","si Zorobabel nan aman Abiud; si Abiud nan aman Eliakim; si Eliakim nan aman Azor; ");
INSERT INTO lbk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","si Azor nan aman Sadoc; si Sadoc nan aman Akim; si Akim nan aman Eliud; ");
INSERT INTO lbk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","si Eliud nan aman Eleazar; si Eleazar nan aman Matan; si Matan nan aman Jacob; ");
INSERT INTO lbk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ya si Jacob nan aman Jose ay asawan Maria. Et si Maria nan inan Jesus ay makwanin Cristo. ");
INSERT INTO lbk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Isnan nay ay tonton, sinpoo ya epat nan en-oonod ay sin-am-a mailapo ken Abraham engkhana ken David. Sinpoo ya epat akhes nan en-oonod ay sin-am-a mailapo ken David engkhana isnan naiyeyan nan cheycha'y Israelita ischi'd Babilonia. Ya sinpoo ya epat kayet nan en-oonod ay sin-am-a mailapo isnan naiyeyancha id Babilonia engkhana isnan naiyanakan Cristo. ");
INSERT INTO lbk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Siya na nan kaokhochan nan naiyanakan Jesu Cristo. Naikwani si Maria ay inana ay maiyasawa ken Jose, ngem issan sisya ay egaycha nen-amongan, ket ay naammowan ay maliton siya maipoon isnan kamabfalin nan Ispirito Santo. ");
INSERT INTO lbk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Idwani, nalenteg ay takho si Jose ay naitot-oyana, ya ad-ina laychen ay pafainen si Maria isnan sakhang nan takho. Tay siya chi nay et sinmekna ay mangad-i et issan tolagcha ken Maria ay ad-i ammon nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngem issan sisya'y cha na manemsemkan isna, nenpaila ken siya nan anghel nan Apo isnan it-itawna ay mangwanin, “Jose ay waned David, ad-i ka omegyat ay mangasawa ken Maria, tay nan wad-ay ay ilillitona et naangnen isnan kamabfalin nan Ispirito Santo. ");
INSERT INTO lbk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","At iyanakna nan lalaki ay pangadnem si Jesus, tay at isalakana nan takhona isnan fasolcha.” ");
INSERT INTO lbk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Naangnen am-in chana ta tomet-ewa san inpaifaag Apo Dios isnan mamadtona ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“At maliton nan esa'y birhen, ya at ikimena nan lalaki, ay sa mangadnan is Emmanuel.” (Nan ayen nan ngachana et wad-ay si Apo Dios ken chatako.) ");
INSERT INTO lbk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Issan finmangonan Jose, inangnena et san infakhan san anghel, ya insaana si Maria ay en-asawana. ");
INSERT INTO lbk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Eg-ayna magtek inchipchipa si Maria issan sisya ay eg-ay nangikimenan Maria isnan anakna ay lalaki, ay nginadnan Jose is Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Naiyanak si Jesus isnan ili ay Betlehem id Judea issan sisya'y ali si Herodes. Awni pay ya ket wad-ay cha nan mamasilib ay lallalaki ay nalpo isnan falaan si akhew ay mangad-achal maipoon isnan tokwifi. Inmey cha id Jerusalem ay nensalodsod ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ento nan kaiyan-anak ay Alin si Judio? Tay inilami nan tokwifi ischi's falaan si akhew ay nangischo isnan naiyanakana, et nay inmali kami ay enchayaw ken siya.” ");
INSERT INTO lbk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Adi kad issan nanngelan ali Herodes ischi, inmegyat. Olay akhes nan omili id Jerusalem inmegyat cha. ");
INSERT INTO lbk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sa na't inpaayag am-in nan cheycha'y aap-apon si papachi ya nan mimistolon si lenteg, ta pootena mo entona nan maiyanakan nan Cristo. ");
INSERT INTO lbk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Isnan ili ay Betlehem id Judea,” insongfatcha. “Tay kanana isnan insolat nan mamadton Apo Dios id Sangad-om, ");
INSERT INTO lbk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sik-a ay ili ay Betlehem ay wad-ay id Judea, faken met sik-a nan kaakkitan nan pategna isnan cheycha'y ili ay matangad isnan Probinsiya ay Judea, tay at malpo ken sik-a nan en-apo ay mangichalan isnan takhok ay Israel.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sa et inpaayag Herodes nan cheycha'y mamasilib, ta makekecheng cha ay matotya. Sa na't pinoot ken chaicha mo kaatna nan nenpail-an san tokwifi. ");
INSERT INTO lbk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Siya chi et inpaligwatna chaicha ay omey id Betlehem ya kanana, “Engkayo ya estenyo ay manganap isnan ong-onga. Et mo mad-ananyo, ipaammoyo ken sak-en ta ennak akhes enchad-ayaw ken siya.” ");
INSERT INTO lbk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Osto'y chinngecha nan kinwanin nan ali, inmey cha. Ya ket wad-ay san tokwifi ay inilacha is falaan si akhew ay nangipango ken chaicha engkhana ay tinomke isnan totongchowen nan kawad nan ong-onga. ");
INSERT INTO lbk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Chachama san lagsakcha issan nangil-ancha issan tokwifi. ");
INSERT INTO lbk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sinomkhep cha isnan afong, et inilacha nan ong-onga ya si Maria ay inana. Sa cha't ala ya falintomeng ay nenchad-ayaw ken Jesus. Tinekwafancha nan faorcha ay nangipafala isnan ilayadcha ken siya ay fallitok, insinso ya mirra. ");
INSERT INTO lbk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Idwanin, tay inpaammon Apo Dios ken chaicha isnan it-itaw ay ad-icha kasin tomoli ken Herodes, teken et ay chalan nan inikwancha ay sinmaa is ilicha. ");
INSERT INTO lbk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Issan kinmaanan san cheycha'y mamasilib, nenpaila nan anghel Apo Dios ken Jose isnan it-itawna ay nangwanin, “Ifangonmo. Itakinmo nan sin-ina ta lomayaw kayo id Egipto, ta ischi nan entey-anyo engkhana is kasik mangwaniyan ken chakayo, tay at paanap Herodes nan ong-onga ta ipapateyna.” ");
INSERT INTO lbk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ala na't ya fangon, sa na't intakin nan sin-ina ay naligwat isnan chey ay lafi, ay omey id Egipto. ");
INSERT INTO lbk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Et ischi nan nentey-ancha engkhana ay natey si Herodes. Siya chi nan inmat ta tomet-ewa san inpaifaag Apo Dios isnan mamadtona ay nangwanin, “Inayakhak nan Anakko ay nalpo id Egipto.” ");
INSERT INTO lbk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Issan nangammowan Herodes ay sinikapan nan cheycha'y mamasilib siya, chad-ama nan songetna. Sa na't infilin ay mapatey nan am-in ay ongang-a'y lallalaki ay entawen si chwa ya nan kolang si chwa nan tawencha isnan Betlehem ya nan am-in ay sakopna. Siya chi ta maitapi ay mapatey nan am-in ay naiyanak mailapo issan nangil-an nan cheycha'y mamasilib isnan tokwifi, ay kag isnan inammowana ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Adi kad tinmet-ewa nan kinwanin nan mamadto ay si Jeremias ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Wad-ay kakainge ay nadnadnge id Rama, cha cha enngegngeg ya chad-ama nan akhacha. Cha akhalan Raquel nan an-akna. Ad-ina paat laychen ay maliwliwa tay nay et maid cha.” ");
INSERT INTO lbk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Awni ya ket natey si Herodes, ya ket kasin nenpaila nan anghel Apo Dios ken Jose id Egipto isnan it-itawna. ");
INSERT INTO lbk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ifangonmo,” kinwanina. “Itakinmo nan sin-ina ta tomoli kayo chadlo id Israel, tay natey et nan cheycha'y menlayad ay mamatey isnan ong-onga.” ");
INSERT INTO lbk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Finmangon, et intakina nan sin-ina ya tinmoli cha id Israel. ");
INSERT INTO lbk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nay met achi issan nanngelan Jose ay si pet Arkelao nan cha en-apo id Judea, ay namanes ken amana ay Herodes, inmegyat et ay omey ischi. Ya khapo tay finag-an Apo Dios siya isnan it-itawna, naligwat cha ay nenpaGalilea ");
INSERT INTO lbk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","isnan ili ay makwani en Nazaret. Et ischi nan inmiliyancha. Siya chi ta tomet-ewa nan kinwanin nan cheycha'y mamadto ay nangwanin, “At makwani siya ay iNazaret.” ");
INSERT INTO lbk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Issan chey ay timpo, wad-ay si Juan Bautista isnan ponchag id Judea ay nangipap-alawag, ");
INSERT INTO lbk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ibfafawiyo nan fasolyo, tay nganngani et nan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan san chey cha kankanan nan mamadton Apo Dios ay si Isaias ay nangwanin, “Wad-ay isnan ponchag nan mangifogfokhaw ay mangwanin, ‘Isakhanayo nan chalan nan Apo, enletkhenyo nan ikwana.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Si Juan, innafe ay chotchot si kamelio nan fachona, ya nenfabfalikes is kochil. Sa et chochon ya itlog si aleg nan cha na inkatakho. ");
INSERT INTO lbk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Et nakhogkhog-oy cha nan takho ay inmey ken siya, ay nalpo id Jerusalem ya isnan am-in ay sakop nan Judea, ya isnan am-in nan ili ay mangakhawa isnan wanga ay Jordan. ");
INSERT INTO lbk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nenfafawi cha ay cha mangibfakha isnan fasolcha, et finonyakhan Juan chaicha isnan wanga ay Jordan. ");
INSERT INTO lbk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Issan magtek nangil-ana isnan angsan ay Fariseo ya Saduceo ay omey enpafonyag ken siya, kinwanina't ken chaicha, “Chakayo ay kag an-ak si oweg! Ay ke yo mailayawan nan omal-ali ay songet Apo Dios isnan ap-aped ay fafawiyo? ");
INSERT INTO lbk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Angnenyo magtek nan okhali ay mangipaila'y chinokokhanyo nan fasolyo! ");
INSERT INTO lbk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ya ad-iyo aped kankanan isnan semekyo en, ‘Osto kami tay si Abraham nan amami,’ tay kanak ken chakayo, ay mabfalin met ay aped yangkhay alaen Apo Dios nan naycha'y fato ya enfalinena is an-ak Abraham! ");
INSERT INTO lbk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Maiyalig kayo isnan kaew ay wad-ay nan naisasakhana ay wasay is kapooncha. Et am-in nan kaew ay maid khawis si fekhascha et masipo ya maiwasit is kaapey. ");
INSERT INTO lbk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Sak-en, fonyakhak chakayo isnan chanom ta kail-an nan nenfabfawiyanyo. Nay met achi, nan omali ay maisokat ken sak-en, fonyakhana chakayo isnan Ispirito Santo ya apey. Wadwad-ay chadlos nan kamabfalina mo sak-en, ya ad-i ak maikali ay olay mangngawit yangkhay isnan pallokana. ");
INSERT INTO lbk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","At sisyanena nan takho. Kag wad-ay lig-ona ay mannaep isnan ilik, sa na't igto is kaallang nan naptong ay ilik, ya poowana nan nakpit ay ilik ya olot is kaapey ay ad-i kaad-achep.” ");
INSERT INTO lbk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Awni ya ket inomchan isnan wanga ay Jordan si Jesus ay nalpo id Galilea, et en nenpafonyag ken Juan. ");
INSERT INTO lbk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nay met achi laychena'y ipawa ay mangwanin, “Apo, lebfengna ay sak-en koma nan fonyakham ya ket sik-a nan inmali ken sak-en?” ");
INSERT INTO lbk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngem kinwanin Jesus ay sinmongfat, “Olay siya's ikkanta na idwani ta maangnen am-in nan laychen Apo Dios ay maangnen.” Sa et intan-oy Juan. ");
INSERT INTO lbk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kakwasan nan nafonyakhan Jesus, finmala is kadchanom, ket ay nenkaookang nan chaya ya inilana nan Ispiriton Apo Dios ay khomkhomwab ay kag kalopati ay inompa ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ya ket id chaya wad-ay nan nenkali ay mangwanin, “Si tona nan laylaychek ay Anakko. Malaylaychan ak ken siya.” ");
INSERT INTO lbk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sa et inpangon nan Ispirito Santo si Jesus isnan ponchag ta sas-ailowan nan chimonyo. ");
INSERT INTO lbk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ya nentiptipe siya isnan epat poo ay akhew ya lafi, kakwasana ya ket ay naowaowat. ");
INSERT INTO lbk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sa et sinmag-en si Satanas ay nangwanin, “Mo sik-a nan Anak nan Dios, ayed, filinem ed nan naycha'y fato ta enfalin cha's tinapay.” ");
INSERT INTO lbk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sinfat magtek Jesus ay nangwanin, “Kanan nan naisolat ay kalin Apo Dios, ‘Faken yangkhay nan tinapay nan maikatakho, mod-i ket kasapolan nan am-in ay cha ifaag Apo Dios.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Inpangon et nan chimonyo si Jesus id Jerusalem sa na't iyey is katoktok nan Timplo, ");
INSERT INTO lbk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ya kinwanina ken siya, “Mo sik-a nan Anak nan Dios, ayed lomabtok ka. Tay kanan nan naisolat ay kalin nan Dios en, ‘At filinena nan anghelesna ay mamachang ken sik-a,’ ya, ‘At salapaencha sik-a ta ad-i maisogto nan sikim is kafato.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sa et kinwanin Jesus, “Wen, ngem kanan met akhes nan naisolat ay kalin Apo Dios en, ‘Ad-im padpachasen/teptepngen nan Apo ay Diosmo.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Inpangon et kasin nan chimonyo si Jesus isnan at-atakchag ay filig, sa na't inpaila ken siya nan am-in ay en-ap-apowan isnan lofong, ya nan kachad-ayawancha. ");
INSERT INTO lbk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sa na't kinwani ken siya, “Am-in chana et ichowak ken sik-a, mo enlokfob ka ay manayaw ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sa et kinwanin Jesus ken siya, “Komaan ka Satanas! Tay naisolat isnan kalin Apo Dios, ‘Chayawem nan Apo ay Diosmo, et siya yangkhay nan ensilfiyam.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Siya chi et tinaynan chadlo nan chimonyo, ya ket ay inmali nan angheles ay namachang ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Issan nanngelan Jesus ay naifalod si Juan, tinmoli id Galilea. ");
INSERT INTO lbk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Egay magtek nawni id Nazaret, mod-i ket inmey ay nentee id Capernaum ay ili is ilit nan fayfay, isnan sakop nan ili ay Zabulon ya Neftali. ");
INSERT INTO lbk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Siya chi nan inmat ta tomet-ewa nan kinwanin nan mamadto ay si Isaias ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nan ilin Zabulon ya nan ilin Neftali, ay ilit si fayfay ya chechemangen nan wanga ay Jordan, siya nan Galilea ay ilin si faken Judio. ");
INSERT INTO lbk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nan takho ay maiyalig ay follinget nan pinangsemekcha, nakaila cha et chadlo isnan enlalanglang ay silaw. Wen, nan cheycha'y entetee isnan ili ay aalin-ewan si etey, et nasilawan cha.” ");
INSERT INTO lbk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Siya chi san nangilapowan Jesus ay nen-ipap-alawakhan ay nangwanin, “Chokokhanyo nan fasolyo, tay nganngani et nan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Issan nanad-alanan Jesus is kailit nan fayfay id Galilea, inilana nan chwa ay sin-akhi ay cha Simon ay mangadnan si Pedro ya si Andres. Cha cha isabsabwag nan tafokorcha is kafayfay, tay siya nan chonocha. ");
INSERT INTO lbk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sa na't kinwani ken chaicha, “Maifoweg kayo ken sak-en, et isolok nan angnenyo'y mangamong isnan takho ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chag-as cha't ya taynan isnan tafokorcha ya naifoweg cha ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Intot-oloy Jesus ay nanad-alan ya ke na't ilaen nan teken kayet ay sin-akhi, ay cha Santiago ken Juan ay an-ak Zebedeo. Wad-ay cha ay sin-am-a is kafangka ay cha manginongnong isnan sichokcha, sa na't ayakhan chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chag-as cha't ya taynan isnan fangka ya si amacha, ya naifoweg cha ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Liniwes Jesus am-in nan Galilea ay en nen-isos-olo isnan sinagogacha, ya nangipap-alawag isnan khawis ay okhod maipoon isnan en-ap-apowan Apo Dios, ya inag-akhasana nan am-in ay kateketeken ay sakit ya sakew si takho. ");
INSERT INTO lbk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nadnadnge siya isnan am-in ay ili id Siria, nay et cha cha inyey ken siya nan am-in ay nenkasakit, am-in nan enliglikhat isnan kateketeken ay sakit ya peteg si awak, nan naan-anitowan, nan cheycha'y enkechas, ya nan ad-i makagkhiwa, et inpagkhawisna am-in chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Angsan cha nan katakhotakho ay inmon-onod ken siya ay nalpo id Galilea, nan makwanin Nan Sinpoo ay Ili, Jerusalem, Judea ya nan ili ay chechemangen nan wanga ay Jordan. ");
INSERT INTO lbk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Issan nangil-an Jesus isnan katakhotakho, nanikid is kafilig sa na't intokcho. Sinmag-en nan disipolosna ken siya, ");
INSERT INTO lbk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","sa na't insolowan chaicha ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Naoney nan cheycha'y mamigfig isnan kinakolangcha isnan nalenteg ay okhali, tay at maifilang cha isnan en-ap-apowan Apo Dios! ");
INSERT INTO lbk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Naoney nan cheycha'y ensakit nan semekcha khapo isnan fasol, tay at palin-awaen Apo Dios chaicha! ");
INSERT INTO lbk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Naoney nan cheycha'y naoya, tay at tawichencha nan kakhawisan ay inkalin Apo Dios! ");
INSERT INTO lbk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Naoney nan cheycha'y maeew-ew ya mamikhaw isnan kinalenteg Apo Dios, tay at mang-ep cha! ");
INSERT INTO lbk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Naoney nan cheycha'y maseg-ang isnan ib-acha, tay at seg-angan akhes Apo Dios chaicha! ");
INSERT INTO lbk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Naoney nan cheycha'y nadchalos nan semekcha, tay at ilaencha si Apo Dios! ");
INSERT INTO lbk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Naoney nan cheycha'y mangipaornos isnan ib-acha'y takho, tay at ifilang Apo Dios chaicha ay an-akna! ");
INSERT INTO lbk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Naoney nan cheycha'y maipap-alikhat khapo isnan mangiyangnenancha isnan laychen Apo Dios, tay at maitapi cha isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Naoney kayo mo amsiwencha, palikhatencha, ya is yangkhay nan kankanancha ay mangipangaag ken chakayo midkakay ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Enlal-ayad kayo ya enlagsak kayo kayet, tay chakchake nan fongaenyo id chaya. Siya akhes nan inikkancha ay nangipalikhat isnan cheycha'y mamadto ay cha nang-ona mo chakayo.” ");
INSERT INTO lbk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Chakayo nan maiyalig ay asin isnan am-in ay takho. Ngem mo mamaid nan aklitna, kecheng, ad-i kasin enfalin is asin. Maid et enkhawisana, mod-i ket maiwasit ya makhatkhatinan et yangkhay. ");
INSERT INTO lbk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Chakayo akhes nan maiyalig ay silaw isnan am-in ay takho isnan lofong. Nan ili is katoktok nan filig et ad-i maitafon. ");
INSERT INTO lbk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Siya akhes ay maid mamaskhed isnan silaw sa na't tangfan isnan salop, mod-i ket ippeyna isnan osto ay kaipatpatangana, ta silawana nan am-in ay wad-ay isnan afong. ");
INSERT INTO lbk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Siya akhes ken chakayo, masapol ay ipailayo nan maiyalig ay silawyo isnan ib-ayo ay takho, ta ilaencha nan khawis ay angnenyo ya chayawencha's Amayo id chaya.” ");
INSERT INTO lbk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ad-iyo kanan en inmali ak ay mangamas isnan lenteg Moises ya nan insos-olon nan mamadto. Egay ak inmali ay mangamas sidi mod-i ket ta iyangnek chachi. ");
INSERT INTO lbk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tay tet-ewa nan kanak ken chakayo: olay engkhana'y maamas nan chaya ya nan lota, ad-i mabfalin ay mamaid nan olay kabfafan-ikhan ay okhes paymo tornek isnan lenteg, engkhana'y maangnen am-in nan at maangnen. ");
INSERT INTO lbk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Adi kad mo sino nan mangiwayang isnan olay esa'y kayap-ewan ay lenteg, ya isolowana nan ib-ana ay manon-od ken siya, at maifilang siya ay kafan-ikhan isnan en-ap-apowan Apo Dios. Nay met achi mo sino nan mangangnen isnan lenteg, ya mangisolo isnan ib-ana ta patiyencha chi, maifilang akhes siya ay mapatpateg isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tay kanak ken chakayo ay mo nan kinakapetyo isnan kinalenteg Apo Dios et ad-ina apsan nan nakapsot ay kinalenteg nan Fafariseo ya mimistolon si lenteg, et ad-i kayo maitapi isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Chinngeyo et nan cha naitokhon isnan takho id sangad-om ay kag tona: ‘Ad-i ka enpatey. Et mo sino nan enpatey at songfatana isnan okom.’ ");
INSERT INTO lbk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Siya na magtek nan kanak ken chakayo idwani, ‘Mo sino nan menlilikhet isnan ib-ana, at songfatana isnan okom. Mo sino nan manopis isnan ib-ana, songfatana isnan maam-amongan nan amam-a, ya mo sino kayet nan mangwani isnan ib-ana en, “Wasit ka'y takho!” at machosa isnan apey id inferno.’ ");
INSERT INTO lbk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Adi kad mo wad-ay em ichoo ay ilayad ken Apo Dios is kaaltar, ya kem et nensemek ischi ay wad-ay sinaktam ay ib-am, ");
INSERT INTO lbk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ogkhayem et ischi's kasakhang nan altar nan ilayadmo, ta en ka ona maiyornos isnan ib-am, esam pay chadlo en ichoo nan chey ay ilayadmo ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mo wad-ay nangidchalom ken sik-a, ya omali ay mangayag ken sik-a, kamowem ay makiornos ken siya isnan sisya ay ad-iyo omchanan is kaokom, ta ad-ina apchas isakhang sik-a is kaokom, ay at akhes mangichowa ken sik-a isnan polis, ay en mangifalod ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tet-ewa kanak ken sik-a, at ad-i ka makafab-ala engkhana'y fayacham nan mortam engkhana isnan kaanongosan ay sintimos.” ");
INSERT INTO lbk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Chinngeyo akhes san naitokhon ay kag tona: ‘Ad-iyo chwadchwaen nan pantewyo.’ ");
INSERT INTO lbk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nay met achi kanak ken chakayo, ay mo sino yangkhay nan mamigfikhaw isnan olay sino ay fafai, et maifilang ay apchas na chinwa nan pantewna isnan semekna. ");
INSERT INTO lbk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Idwani, mo nan kannawan ay matam nan khotok nan makabfasolam, pen loknatam ta iwasitmo. Khap-esna't si mamaid nan tapin nan awakmo, mo nan wad-ay am-in ya khechangna'y maiwasit ka id inferno. ");
INSERT INTO lbk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ya mo nan kannawan ay limam nan khotok nan makabfasolam, pen potlongmo ta iwasitmo, tay khap-es na't si mamaid nan esa'y tapin si awakmo, mo nan maiwasitan nan khag-awisan ay awakmo id inferno.” ");
INSERT INTO lbk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Wad-ay akhes nan naitokhon ay kag tona: ‘Mo sino ka issa ay lalaki ay mangichang ken asawam, agtam nan kaichangmo is kasolatan.’ ");
INSERT INTO lbk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nay met achi kanak ken chakayo idwani, ‘Mo nan lalaki ya ichangena nan asawana ay maid inang-angnena is asi, et lag-ena'y makilalaki nan kaichangna mo makiasawa kasin. Ya olay nan lalaki ay mangasawa ken siya, et siya akhes ay chwaena nan pantewna.’” ");
INSERT INTO lbk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Chinngeyo kayet san naitokhon ken chaicha id sangad-om ay kag tona: ‘Ad-im iwayang nan insapatam, ngem angnem ay angnen nan insapatam ken Apo Dios.’ ");
INSERT INTO lbk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kanak magtek ken chakayo en, ‘Ad-i kayo ensapsapata. Ad-iyo ngadngadnan nan chaya isnan ensapataanyo, tay siya nan tomotokchowan Apo Dios, ");
INSERT INTO lbk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","paymo nan lota, tay siya nan enkhagkhatinana, olay pay nan Jerusalem, tay siya nan ilin nan Katotongchowan ay Ali. ");
INSERT INTO lbk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ad-im akhes isapsapata nan awakmo, tay ay ke sik-a nan kawad nan kamabfalin isnan awakmo? Maid kamabfalinmo ay mangipapokaw paymo mangipangitit isnan olay esang isnan fookmo. ’ ");
INSERT INTO lbk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kananyo magtek yangkhay en, ‘Wen,’ mo wen, ya ‘Ad-i,’ mo ad-i. Tay mo ngag nan itoptopmo kasin isnacha, et malpo chi ken Satanas.” ");
INSERT INTO lbk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Chinngeyo kayet nan naitokhon ay kag tona: ‘Mo mata, at mata akhes nan falesna, ya mo fab-a, at fab-a akhes.’ ");
INSERT INTO lbk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kanak magtek ken chakayo, ‘Ad-i kayo en-ifab-ales. Mo way manodpak isnan kannawan ay ipingmo, ichoom nan topakna. ");
INSERT INTO lbk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kag akhes mo wad-ay mangidchalom ken sik-a, ta alaena nan kamasitam, ngag ngotom ta alaena kayet nan kakhaymo. ");
INSERT INTO lbk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mo wad-ay mamilit ken sik-a ay mangipasakfat isnan awitna is esa'y kilomitro, sakfatem engkhana'y olay chwa'y kilomitro. ");
INSERT INTO lbk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Agtam nan olay sino ay komchaw ken sik-a, ya pabfolocham nan fomolod ken sik-a, ad-im chokokhan.’” ");
INSERT INTO lbk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Chinngeyo akhes nan naitokhon ay kag tona: ‘Laychem nan sagkhongmo ya kholaem nan fosom.’ ");
INSERT INTO lbk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kanak magtek ken chakayo, ‘Laychenyo nan fosoyo, ya ilowalowanyo nan cheycha'y mamap-alikhat ken chakayo.’ ");
INSERT INTO lbk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tay mo siya sa nan angnenyo, ipailayo ay chakayo, et tet-ewa ay an-ak Ama id chaya. Tay si Apo Dios, paakhewena nan akhew isnan ngaag ya khawis ay takho, ya ekchakhena nan ochan isnan nalenteg ya nan ad-i. ");
INSERT INTO lbk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tay mo nan yangkhay cheycha'y menlal-ayad ken chakayo nan laylaychenyo, ay ke yo kanan en way sa yo fongaen ken Apo Dios? Ad-i ngen siya akhes sa nan angnen nan natotokong ay enkorkortais? ");
INSERT INTO lbk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ya mo nan yangkhay cheycha'y ib-ayo nan tot-oyyenyo ay khawis, wadwad-ay ngen nan inangnenyo? Tay olay nan maid ammocha maipoon ken Apo Dios et angnencha chi. ");
INSERT INTO lbk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Adi kad chakayo et masapol ay ad-i enkolong nan layadyo, ay kag ken Amayo id chaya ay maid paat enkolangana.” ");
INSERT INTO lbk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kinwanin kayet Jesus, “Ilaenyo ta ad-iyo ipafoya isnan takho nan khawis ay ikkanyo ay kaidchayawan ken Apo Dios. Tay mo siya sa, at maid fongaenyo ken Amayo id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Adi kad mo wad-ay ichowam ay ilayadmo isnan kaseseg-ang, ad-im ipafoya isnan takho, ay kag isnan angnen nan cheycha'y kakas-okas-on. Pen pakaliyencha nan trompeta, ya somkhep cha is kasinagoga paymo fomala cha is kakammalin, ta maichayaw cha isnan takho. Tet-ewa kanak ken chakayo, apchas cha't inala nan fongaencha. ");
INSERT INTO lbk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nay met achi, mo wad-ay em ichowa ay ilayad, angnem isnan ad-i maila, ta olay nan aloyosmo, et ad-ina ammo nan cham angnen. ");
INSERT INTO lbk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Siya sa ta kecheng ka is mangammo, et nan Amayo id chaya ay mangammo am-in isnan ad-i maila, et siya nan mensofalit ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mo akhes enlowalo kayo, ad-iyo ikkan nan angnen nan kakas-okas-on, ay en mentatatatakcheg is kasinagoga ya is kakhawan nan ili ay enlowalo, ta mafob-oya cha isnan takho. Tet-ewa kanak ken chakayo, apchas cha't inala nan fongaencha. ");
INSERT INTO lbk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mo magtek enlowalo ka, somkhep ka chadlo isnan kwartom, sam et enfan, ya ischi nan makitot-oyam ken Ama'y Dios ay ad-i kaila. Et si Ama ay mangiila isnan ad-i kaila, et sobfalitana sik-a ay osto.” ");
INSERT INTO lbk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Isnan enlowalowanyo, ilaenyo ta ad-i yangkhay angsan ay apat ay mapidwapidwa, ay kag isnan ekhad nan Gentil, tay kanancha mo chengngen Apo Dios chaicha isnan angsan ay apatcha. ");
INSERT INTO lbk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ad-iyo tonton-ochen chaicha tay si Amayo, ammona nan kasapolanyo olay mo sisya'y egayyo infaag ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kag tona nan kananyo ay enlowalo: ‘Ama id chaya, machad-ayaw nan ngachanmo. ");
INSERT INTO lbk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Omali nan en-ap-apowam. Maangnen nan nemnemmo isnan lofong ay kag id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ichowam nan kanenmi isnan kawakawakas. ");
INSERT INTO lbk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pakawanem nan fasolmi, tay pinakawanmi akhes nan finmasol ken chakami. ");
INSERT INTO lbk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ad-im ogkhayen chakami isnan maawisanmi ay enfasol, mod-i ket isas-alakam chakami isnan ngaag.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sa na't kinwanin, “Tay mo pakawanenyo nan finmasol ken chakayo, at akhes pakawanen Amayo id chaya chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nay met achi mo ad-iyo pakawanen nan finmasolancha, et akhes ad-i pakawanen Amayo nan fasolyo.” ");
INSERT INTO lbk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Intoloy Jesus ay nangwanin, “Mo entipe kayo, ad-i kayo kas-on enngongoyos, ay kag isnan cheycha'y kakas-okas-on ay mamab-aliw isnan kamescha, ta mangammowan nan takho ay cha cha entipe. Tet-ewa kanak ken chakayo, apchas cha't inala nan fongaencha. ");
INSERT INTO lbk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Adi kad mo entipe kayo, nongnongenyo chadlo nan oloyo, ya enchilam-os kayo, ");
INSERT INTO lbk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta maid mangammo ay cha kayo entipe, mod-i yangkhay si Ama ay ad-i kaila. Et si Ama tako ay mangiila isnan ad-i kaila, et sobfalitana chakayo ay osto.” ");
INSERT INTO lbk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ad-i kayo en-ipenpen isnan maifaknang ay wad-ay isnan lofong. Tay isna, maaney, enlati, ya segpen si mangakew ay mangilayaw. ");
INSERT INTO lbk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amongenyo magtek id chaya nan kag yo akon. Tay ischi, maid aney, ad-i enlati, ya ad-i segpen si mangakew ay mangilayaw ischi. ");
INSERT INTO lbk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tay mo ento nan kawad nan ifaknangyo, siya akhes nan kawad nan semekyo.” ");
INSERT INTO lbk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kinwanin kayet Jesus, “Maiyalig nan mata ay silaw si awak, tay mo nalatak nan angnen ay en-ila, kag masisilawan nan semek ya khawis nan enfanakhana isnan am-in ay katatakhoyo. ");
INSERT INTO lbk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nay met achi mo ngaag nan pinang-ilayo, at kag akhes enpapanget nan semekyo. Adi kad ento mo silaw nan manangkhew ken chakayo, ya ket ay follinget nan wad-ay ken chakayo, et chachama ay ab-afollinget nan katatakhoyo.” ");
INSERT INTO lbk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Maid enpafab-aa isnan chwa ay apo, tay at liligtena nan esang ya laylaychena nan esang. Tet-ewa, nakapet isnan esang ya chilawena nan esang. Ad-i mabfalin ay chwa nan omayan nan semekmo, nan Dios ya nan siping.” ");
INSERT INTO lbk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Intoloy Jesus ay nangwanin, “Kanak et mampay ken chakayo, ad-i kayo man madchanakhan isnan fiyagyo. Ad-i kayo madchanakhan mo ngag nan kanen ya inomenyo. Ad-i kayo madchanakhan isnan awakyo, mo ngag nan ifachoyo. Ad-i ngen wadwad-ay nan fiyag mo nan makakan, ya nan awak mo nan facho? ");
INSERT INTO lbk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilaenyo nan ay-ayam id tongcho, ad-i cha met enmola, ad-i cha en-ani paymo en-ipenpen is kaallang. Ngem ya ke cha kayet panganen Amayo id chaya chaicha mo! Ay ke kayo ad-i napatpateg is solit mo chaicha? ");
INSERT INTO lbk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sino ken chakayo nan makaipaancho is akit isnan fiyagna mo enchanachanag? ");
INSERT INTO lbk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ya kag akhes isnan ifachoyo. En kayo man chadlos madchanakhan ay? Ilaenyo achi nan sabsafong is kafilig. Aped cha cha mengngan, ya ad-i cha met enchono paymo en-afe. ");
INSERT INTO lbk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nay met achi kanak ken chakayo ay, olay si ali Solomon isnan am-in ay chayawna, et egay nabfachowan isnan kakhawisan ay kag nan sanacha'y sabsafong. ");
INSERT INTO lbk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Et mo kag tosa nan angnen Apo Dios ay mamacho isnan mola, ay wad-ay ay tomobtofo idwani, ya is wakas et maittongo is kaapey, ad-ina ngen am-amed fachowan chakayo? Akiakit paat nan pammatiyo! ");
INSERT INTO lbk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ad-i kayo et mampay madchanakhan ay mangwanin, ‘Ngag nan kanenmi?’ ya ‘Ngag nan inomenmi?’ ya ‘Ngag nan ifachomi?’ ");
INSERT INTO lbk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tay nan cheycha'y maid pammaticha, siya am-in chana nan an-anapencha. Ngem chakayo, ammon et Amayo id chaya ay am-in chana et masapolyo. ");
INSERT INTO lbk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nan magtek angnenyo et mang-ona'y mang-ona ay pawadwad-ayenyo nan en-ap-apowan Apo Dios, ta somya nan kinalentegna, et ichawchawna akhes nan am-in ay masapolyo. ");
INSERT INTO lbk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Ad-i kayo et mampay madchanakhan isnan maipoon is wakas, tay kikhad nan mawaksana mo ngag nan fatokhena. Omanay et nan likhat ay wad-ay idwani, is wakas teken akhes.” ");
INSERT INTO lbk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kinwanin kayet Jesus, “Ad-iyo okomen nan ib-ayo ta ad-i kayo maokom. ");
INSERT INTO lbk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tay nan angnenyo ay mangokom isnan ib-ayo, et siya akhes nan angnen Apo Dios ay mangokom ken chakayo. Ya mo ngag nan angnenyo ay menlokod isnan ib-ayo, et siya akhes nan angnena ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Em man isin-eng nan khertab isnan matan nan ib-am, ya okhay nan sinlanges ay manasalak isnan matam? ");
INSERT INTO lbk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ay kem aped kanan isnan ib-am en, ‘Ay ta kaanek nan sana'y khertab isnan matam,’ mo sisya nan sinlanges ay manasalak isnan matam? ");
INSERT INTO lbk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sik-a ay kakas-okas-on! Kaanem pay ona nan sinlanges ay manasalak isnan matam, ta nalatak nan mangil-am isnan khertab ay cham kaanen isnan matan nan ib-am.” ");
INSERT INTO lbk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ad-iyo ichowa nan maifilang ay nasantowan isnan cheycha'y maiyalig ay aso, tay ta ket lang somakhong cha'y mangetfan ken chakayo. Ad-iyo akhes ibkas nan akon isnan cheycha'y maiyalig ay fotog, tay at khatigkhatinancha yangkhay chi.” ");
INSERT INTO lbk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Intoloy Jesus ay nangwanin, “Komchaw kayo et maagtan kayo. En-anap kayo et makad-an kayo. Enkogkog kayo et matekwafan nan eneb ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tay mo sino nan komchaw at maagtan, ya nan en-anap makad-an, ya isnan enkogkog, et matekwafan nan eneb ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ken chakayo ay am-a, ay ke wad-ay ken chakayo nan mangichowa is fato isnan fab-alona, mo komchaw is kanena? ");
INSERT INTO lbk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kag akhes mo komchaw si sibfana is khachiw, ay ke yo aped ichowa nan oweg? ");
INSERT INTO lbk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Olay ngaag kayo, et ammoyo ay en-ichowa isnan enkhawisan nan an-akyo. Ad-i ngen chadlos wadwad-ay nan ikkan Amayo id chaya, ay mangichawchaw isnan enkhawisan nan cheycha'y komchaw ken siya? ");
INSERT INTO lbk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Adi kad angnenyo et mampay isnan ib-ayo nan ngag issa ay laychenyo akhes ay angnencha ken chakayo. Tay siya sa nan ayen nan sos-olon nan lenteg Moises, ya nan insolat nan cheycha'y mamadton Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Somkhep kayo isnan nasopit ay segpan, faken nan an-annawa, tay annawa nan segpan ya malanoy nan chalan ay omiyey id inferno, ya ang-angsan cha nan somsomkhep ischi. ");
INSERT INTO lbk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ngem nasopit nan segpan ya sikhab nan chalan ay omiyey isnan fiyag ay eng-engkhana, ya akit cha nan cheycha'y mangchan ischi.” ");
INSERT INTO lbk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“En-annad kayo isnan cheycha'y ad-i tet-ewa'y mamadto. Ipailacha'y naanos cha ay kag cha karnilo, ya ke pet kag cha atap ay aso ay enpakawas. ");
INSERT INTO lbk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","At imatonanyo chaicha isnan ang-angnencha. Kag isnan mola, ay ke mapokhas nan ofas is kasibsifit, paymo nan higos is kapagpakhat? ");
INSERT INTO lbk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kag akhes isnan kaew. Mo al-alay-eng nan kaew, khawis nan fekhasna, ngem nan ngaag ay kaew, ngaag nan fekhasna. ");
INSERT INTO lbk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ad-i mabfalin ay mamkhas nan al-alay-eng ay kaew is ngaag, paymo nan ngaag ay kaew is khawis ay fekhas. ");
INSERT INTO lbk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Am-in ay kaew ay ad-i mamkhas si khawis et masipo ya maittongo. ");
INSERT INTO lbk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Siya akhes ken chaicha, imatonanyo chaicha isnan ang-angnencha.” ");
INSERT INTO lbk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kinwanin kayet Jesus, “Ad-i am-in ay mangwani ken sak-en en, ‘Apo, Apo,’ et maitapi cha isnan en-ap-apowan Apo Dios. Nan magtek cheycha'y mangangnen isnan nemnem Ama'y wad-ay id chaya, et chaicha nan somkhep. ");
INSERT INTO lbk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","At angsan cha nan mangwani ken sak-en isnan tosa ay akhew en, ‘Apo, Apo, ay kem egay inila chakami ay nen-ipadpadto isnan ngachanmo, ya nen-ipakpakaan si anito isnan ngachanmo, ya nen-angnen si angsan ay katataa ay chono isnan ngachanmo?’ ");
INSERT INTO lbk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Et siya na nan at ifaagko ken chaicha, ‘Maid ammok paat ken chakayo. Komaan kayo, chakayo ay ngaag nan chonona!’ ” ");
INSERT INTO lbk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Siya mampay na nan mangwaniyak, ay mo sino ka ay mannge isnan naycha ay kalik ya angnem et is-isom nan masilib ay takho ay nangipatakcheg isnan afongna is kafato. ");
INSERT INTO lbk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Issan nenlemlemana ay nen-anewangana ya nenchagmana, et egay natokang nan afong tay fato nan naikhab-ana. ");
INSERT INTO lbk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ngem mo sino ka akhes issa ay mannge isnan nay ay kalik ya ad-im angnen, is-isom nan ad-i ensemsemek ay takho ay nangipatakcheg isnan afongna is kalakhan. ");
INSERT INTO lbk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nay met achi issan nenlemlemana ay nen-anewangana ya nenchagmana, ya ket ay nenkatotokang nan afong. Chadlos chachama nan naifasfasana.” ");
INSERT INTO lbk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kakwasan san nangwaniyan Jesus am-in ischicha, ket ay nataataa nan katakhotakho ken siya, tay isnan ikkana ay en-isolo, ");
INSERT INTO lbk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tay wad-ay kalebfengana ay en-isolo, ad-i kag isnan mimistolon si lentegcha. ");
INSERT INTO lbk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Issan pinmanachan Jesus ay nalpo is kafilig, inonod si katakhotakho siya. ");
INSERT INTO lbk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sinmag-en ken siya nan esa'y nakolit, sa et nenfalintomeng ay nangwanin, “Apo, mo sa ya laychem, et mabfalin ay pakhawisem sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kinappos Jesus nan nakolit ay nangwanin, “Laychek, khomawis ka.” Ya ket nakhannawis nan kolitna. ");
INSERT INTO lbk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sa et finilin Jesus siya ay nangwanin, “Ilaem ta ad-im ifab-aag isnan olay sino. Engka't magtek paila isnan pachi, sam et en ichoo nan chaton ken Apo Dios ay kag nan infilin Moises, ta mangipaila isnan takho ay tet-ewa ay khinmawis ka.” ");
INSERT INTO lbk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Issan sinomkhepan Jesus id Capernaum, wad-ay nan esa'y kapitan si sorchacho ay inmey nangila ken siya. Ya nenseg-ang ");
INSERT INTO lbk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ay nangwanin, “Apo, wad-ay nan faak is afong ay maseseyep tay ad-i makagkhiwa, ya chad-ama nan likhatna.” ");
INSERT INTO lbk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kinwanin et Jesus ken siya, “Wen, omali ak ay mangipagkhawis ken siya.” ");
INSERT INTO lbk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sinomfat et nan kapitan ay nangwanin, “Apo, ad-i ak pay maikali ken sik-a, ta chadlos ka somkhep isnan afongko. Infilinmo koma et yangkhay, et omanay chi ay mangipagkhawis isnan faak. ");
INSERT INTO lbk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maawatak sa tay sak-en akhes, wad-ay nan entongtongcho mo sak-en, ya wad-ay cha akhes nan iyap-apowak ay sorchachok. Et kanak yangkhay isnan esang, ‘Omey ka ischi,’ et omey. Sa et isnan esang kayet kanak, ‘Omali ka,’ ya omali. Ya isnan faak kanak, ‘Angnem na,’ et angnena. Isonga ammok ay kafaelam.” ");
INSERT INTO lbk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Osto'y chinngen Jesus chi, nataa, sa na't kanan isnan cheycha'y inmonod ken siya en, “Tet-ewa kanak ken chakayo, ay maid paat inilak is kag tona ay pammati isnan olay sino isna id Israel. ");
INSERT INTO lbk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kanak ken chakayo, at ang-angsan nan faken Judio ay malpo is falaan ya kalonokhan si akhew, ay en makikan ken cha Abraham, Isaac ya si Jacob isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngem chaicha ay makwani en maitapi koma isnan en-ap-apowan Apo Dios, ya ket ay chaicha et nan maiwasit isnan enfollinget, ay kawad nan ngegngeg ya kaletket si fab-a.” ");
INSERT INTO lbk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sa et kinwanin Jesus isnan kapitan, “Somaa ka, et maangnen nan sana ay pinatim.” Et siya kannay chi ay olas nan khinmawisan nan faana. ");
INSERT INTO lbk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sa et sinomkhep si Jesus is afong cha Pedro, ya inilana nan katokhangan Pedro ay fafai ay maseseyep tay enpodpochot. ");
INSERT INTO lbk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Inegnan et Jesus nan limana, ya ket nenkamamaid nan pochotna. Sa et finmangon ya pinnakana si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Awni pay ya isnan sedsechemna, inyeycha ken siya nan angsan ay naan-anitowan. Et cha nen-ipafalan am-in Jesus isnan kalina yangkhay nan cheycha'y anito, ya inpagkhawisna am-in nan nenkasakit. ");
INSERT INTO lbk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Naangnen am-in chana ta maangnen nan infaag nan mamadto ay si Isaias ay nangwanin, “Kinaana nan am-in ay sakew ya sakit tako.” ");
INSERT INTO lbk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Idwani issan nangil-an Jesus isnan katakhotakho ay nangalifongfong ken siya, kinwanina isnan cheycha'y disipolosna, “Khomchang tako.” ");
INSERT INTO lbk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ya ket wad-ay nan mistolon si lenteg ay inmey ken Jesus, ay nangwanin, “Mistolo, maifoweg ak ken sik-a isnan olay entona ay omayam.” ");
INSERT INTO lbk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kinwanin et Jesus ken siya, “Nan silay, wad-ay tekawcha, ya siya akhes isnan ay-ayam, wad-ay nan khafancha. Ngem sak-en ay Anak si Takho et maid osto is maseypak.” ");
INSERT INTO lbk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wad-ay kayet nan esa'y disipolos ay nangwanin, “Aw-awni Apo, ta ennak ed ona ikaob si ama.” ");
INSERT INTO lbk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngem kinwanin Jesus ken siya, “Maifoweg ka ket ya! Ngag ngotom ta nan natey nan en mangikaob isnan ib-acha ay natey.” ");
INSERT INTO lbk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sa et inmey si Jesus is kafangka ya naifoweg nan cheycha'y disipolosna ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Awni ya ket naanali nan ab-afikas ay lemlem is kafayfay, nasepyatan nan fangka isnan talipyakew et cha mapsong, ngem si Jesus naseseyep. ");
INSERT INTO lbk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ala cha't ya fangon ken Jesus. “Omisalak ka Apo! Nay malin-eb tako!” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ya ket kanan Jesus ken chaicha, “Ya ke kayo omegyat ay? Akiakit paat nan pammatiyo.” Sa et finmangon ay nangipatke isnan chakhem ya nan fayfay, ya ket nenfalin ay kakhigkhinek am-in chadlo. ");
INSERT INTO lbk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nataataa et nan cheycha'y takhona ay cha mangwanin, “Ngag man nan katakhon tona, tay ya ke olay nan chakhem ya nan fayfay ya patiyencha siya?” ");
INSERT INTO lbk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Khinomchang cha pay isnan ilin nan iGadara, ya ket sinab-at nan chwa ay lalaki ay naan-anitowan, ay nalpo isnan liyang si natey. Kakaegyat cha, ya maid makatoled ay lomaos ischi. ");
INSERT INTO lbk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ala cha't ya wakis ay nangwanin, “Ngag nan fiyangmo ken chakami, sik-a ay Anak si Dios? Ay ke ka kannay omaali ay mangipalikhat ken chakami isnan fakena timpo?” ");
INSERT INTO lbk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Idwani, wad-ay isnan adchawi is akit nan maam-among ay kafotofotog ay cha en-anglod. ");
INSERT INTO lbk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nenseg-ang et nan kaanianito ken Jesus ay nangwanin, “Mo pafal-em chakami, ippeymo et yangkhay chakami isnan cheycha'y fotog.” ");
INSERT INTO lbk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sa na't nenkanan ken chaicha, “En kayo!” Ke cha't nabfanala ya kasi cha sesekhep isnan cheycha'y kafotofotog, sa cha't ala ya tagtag is katoy-ob ay enchadchawes is kafayfay, sa cha't natey am-in. ");
INSERT INTO lbk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Linmayaw et nan cheycha'y nangipaspastor ischicha, ya en cha inog-okhod is kaili nan am-in ay inmat, ya nan naangnen isnan cheycha'y naan-anitowan. ");
INSERT INTO lbk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Siya chi ya ket naligwat nan omili ay en nangila ken Jesus. Osto'y inomchan cha ken siya, nenseg-ang cha ta komaan siya isnan ilicha. ");
INSERT INTO lbk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nenfangka si Jesus ya kasin khinomchang isnan ilina chadlo. ");
INSERT INTO lbk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ya ket ay wad-ay cha nan nangiyey ken siya isnan lalaki ay ad-i makagkhiwa ay maiyaamaka. Issan nangilasinan Jesus isnan pammaticha, kinwanina isnan chey ad-i makagkhiwa, “Anak, pabfikasem yangkhay nan semekmo. Napakawan et nan fasolmo.” ");
INSERT INTO lbk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sa et wad-ay nan tapina ay mistolon si lenteg ay cha mangwani is semekcha en, “To! Am-amsiwen tona si Apo Dios!” ");
INSERT INTO lbk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngem tay ammon Jesus nan semsemkencha, kinwanina, “Ya ke ngaag nan wad-ay isnan semekyo ay? ");
INSERT INTO lbk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngag pet nan malanlanoy ay kanan, ‘Napakawan et nan fasolmo,’ paymo, ‘Fomangon ka ya manalan ka’? ");
INSERT INTO lbk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nay met achi ipailak ta mangammowanyo ay wad-ay kalebfengak ay Anak si Takho isnan kalota ay mamakawan isnan fasol.” Sa na't kanan isnan chey ad-i makagkhiwa, “Ifangonmo! Alaem nan kaseypam ta somaa ka't.” ");
INSERT INTO lbk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sa et finmangon ya somaa. ");
INSERT INTO lbk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Issan nangil-an nan katakhotakho nan todi ay inmat, inmegyat cha ya chinad-ayawcha si Apo Dios ay nangichowa isnan kag tod-i ay kamabfalin sinan takho. ");
INSERT INTO lbk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kinmaan si Jesus ischi ya issan cha na manad-alanan, inilana nan esa'y lalaki ay enngachan si Mateo, ay tomotokcho is kaenfob-owisana. Kinwanina't ken siya, “Maifoweg ka ken sak-en.” Sa et naligwat si Mateo ay naifoweg. ");
INSERT INTO lbk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Issan cha manganan cha Jesus ya nan disipolosna isnan afong Mateo, inmali nan angsan ay enkorkortais ya nan cheycha'y makwanin wasit ay takho ay en nakikan ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ya ket issan nangil-an nan cheycha'y Fariseo isnan chey takho, kinwanicha isnan cheycha'y disipolos Jesus, “En man cha pet makikan nan mistoloyo isnan sanacha'y enkorkortais ya wasit ay takho ay?” ");
INSERT INTO lbk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chinngen et Jesus chi sa na't kanan, “Faken nan takho ay komekedse nan makasapol isnan choktor mod-i ket nan nasakit. ");
INSERT INTO lbk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","En kayo et ta achaachalenyo nan ayen nan nay ay kinwanin Apo Dios, ‘Nan maneg-anganyo isnan ib-ayo nan laychek, faken nan enkik-iwi ay cha yo ichoo.’ Tay egay ak inmali ay mangayag isnan nalenteg, mod-i ket nan cheycha'y fomafasol.” ");
INSERT INTO lbk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Awni ya ket inmey ken Jesus nan cheycha'y disipolos Juan ay nangwanin, “En man chakami ya nan cheycha'y Fariseo et entipe kami, sa et nan disipolosmo ya ad-icha?” ");
INSERT INTO lbk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sa et kinwanin Jesus, “Ay ke mabfalin ay aped ensasanga nan lilwid nan kaab-afong ay lalaki, mo sisya kayet siya ken chaicha? Ngem at omali nan akhew ay maal-ana ken chaicha, et siya chi ay akhew nan ad-i cha mangmanganan. ");
INSERT INTO lbk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kanak akhes en, maid mangidchokop isnan egay kinomsen ay lopot isnan lokhak ay facho, tay mo malab-an et peskhatena nan lokhak, ya omam-amed et nan fakasna. ");
INSERT INTO lbk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Siya akhes isnan fayas, maid mangippey isnan kakhag-aeb ay fayas isnan chaan ay kochil ay entey-an si fayas, tay at pen paptokena chi ya maiwasit nan fayas ya kecheng mapakawas cha't ay chwa. Nan magtek falo ay fayas, et maippey koma isnan falo ay kochil ay entey-an si fayas, ta at en-iso chana ay maigto ya ad-i mapakpakawas.” ");
INSERT INTO lbk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Issan sisya'y enkak-aliyan Jesus, wad-ay nan ap-apo ay inmey ken siya. Ala na't ya falintomeng ay mangwanin, “Apo, kaet-etey nan anakko ay fafai, ngem mo omali ka ta ipatangmo nan limam ken siya, et ammok ay at matakho kasin.” ");
INSERT INTO lbk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Naligwat cha Jesus ya nan disipolosna ay naifoweg ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Issan cha cha omayan, wad-ay nan fafai ay nenchad-ala is sinpoo ya chwa ay tawen. Sinmag-en is kadchokog Jesus ay nanikchod isnan khayachan nan fachona. ");
INSERT INTO lbk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tay kanana is semekna en, “Olay sikchochek yangkhay nan fachona, et maipagkhawis ak.” ");
INSERT INTO lbk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nensakhong si Jesus, ke na't inila siya. Sa na't kanan, “Anak, pabfikasem nan semekmo! Nay inpagkhawis nan pammatim sik-a.” Chag-asna ya ket khinmawis san fafai. ");
INSERT INTO lbk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Issan inomchanan Jesus is afong san chey ap-apo, inilana nan cheycha'y mangak-alleleng ya nan katakhotakho ay ngomannganawngaw, ");
INSERT INTO lbk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","sa na't kanan, “Komaan kayo, tay egay natey nan magmagkit, mamaseyep yangkhay.” Ya ke cha't inang-ango siya. ");
INSERT INTO lbk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ngem isnan naipafal-an nan cheycha'y takho, sinomkhep si Jesus sa na't inegnan nan liman nan ong-onga, ya ket ay finmangon. ");
INSERT INTO lbk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Et siya na nan nadnadnge isnan am-in ay sakop nan chey ay ili. ");
INSERT INTO lbk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kinmaan si Jesus ischi ya issan nanad-alanana, inonod si chwa ay lallalaki ay ad-i makaila, ay nangifogfokhaw ken siya en, “Anak David, seg-angam chakami.” ");
INSERT INTO lbk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Issan sinomkhepan Jesus is afong, inmey cha ken siya. Sa et kinwanin Jesus, “Patiyenyo ngen ay makaikkan ak isna?” Kinwanicha't, “Wen, Apo.” ");
INSERT INTO lbk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kinappos et Jesus nan matacha ay nangwanin, “Mo siya sa, maangnen et kannay na ken chakayo ay kag isnan pammatiyo.” ");
INSERT INTO lbk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ke cha't makaila chadlo. Sa et chadlos infilin Jesus ken chaicha ay nangwanin, “Ilaenyo ta maid mangifagfag-anyo.” ");
INSERT INTO lbk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nay met achi, issan kinmaanancha, en cha't inokhookhod nan maipoon ken siya isnan am-in ay sakop nan chey ay ili. ");
INSERT INTO lbk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Issan naligwatancha, wad-ay et nan naiyey ken Jesus ay nginengek si anito. ");
INSERT INTO lbk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Osto ay inpakaan Jesus nan anito ken siya, ya ket ay nakakkali chadlo. Nataataa nan katakhotakho ay cha mangwanin, “Maid man paat kag tona is nail-ila isna id Israel.” ");
INSERT INTO lbk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngem kinwanin nan cheycha'y Fariseo en, “Da! Cha na achi pafal-en nan anito isnan fachang kannay nan ap-apon si anito.” ");
INSERT INTO lbk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Inmey si Jesus isnan kailiili ya am-in ay kabfakhaang ay cha nen-isos-olo isnan sinagogacha, ya nangipap-alawag maipoon isnan khawis ay okhod nan en-ap-apowan Apo Dios. Et cha na kinaan nan am-in ay ilan si sakit sa na't inpakedse nan am-in ay nenkasakew. ");
INSERT INTO lbk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Issan nangil-ana isnan katakhotakho, naseg-aseg-ang tay chadlos cha nginmayangaya ya maid mabmabfalincha, ay kag cha san naiwayang ay karnilo ay maid mangitokkhong ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sa na't kinwani isnan disipolosna, “Ang-angsan tet-ewa nan maani, ngem akit cha nan en-ani. ");
INSERT INTO lbk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Enlowalo kayo et mampay isnan Nenkwa isnan maani ta omifaa is omey en-ani.” ");
INSERT INTO lbk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Inayakhan Jesus nan sinpoo ya chwa ay disipolosna, sa na't inchowa ken chaicha nan kalebfengancha ay mangipafala isnan anito, ya mangaan isnan am-in ay ilan si sakit, ya mangipakedse isnan am-in ay nenkasakew. ");
INSERT INTO lbk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Naaycha nan ngachan nan sinpoo ya chwa ay apostolesna: omona, si Simon ay nenngachan is Pedro, sa et nan akhina ay si Andres; cha Santiago ken Juan ay sin-akhi ay an-ak Zebedeo; ");
INSERT INTO lbk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","cha Felipe ken Bartolome; si Tomas ya nan enkorkortais ay si Mateo; si Santiago ay anak Alfeo, ya si Tadeo; ");
INSERT INTO lbk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon ay mangitaktakcheg isnan mawayaan nan ilina, ya si Judas Iscariote, ay awni't mangitiktik ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Siya chachi nan sinpoo ya chwa ay infaan Jesus, ya finilina ay nangwanin, “Ad-i kayo omey isnan ilin si Gentil, paymo somkhep isnan kailiili id Samaria. ");
INSERT INTO lbk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Omey kayo magtek isnan maiyalig ay nadchongaw ay karnilo isnan pangafong Israel. ");
INSERT INTO lbk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","En kayo ipalawag ay mangwanin, ‘Naay et ay inmali nan en-ap-apowan Apo Dios!’ ");
INSERT INTO lbk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pakhawisenyo nan nasakit, takhowenyo nan natey, pakhawisenyo nan nakolit, ya pakaanenyo nan anito isnan naan-anitowan. Tay mampay maid fayad nan chinawatyo ay enkhawisan, ichowayo akhes ay maid fayadna. ");
INSERT INTO lbk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ad-i kayo en-itaktakin si fallitok, paymo ngag issa ay pilak ay ikog-ityo. ");
INSERT INTO lbk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ad-i kayo en-itakin si sopot, sokod, ya ensokatanyo ay facho paymo palloka isnan enfaatanyo. Tay nan enchono et lebfengna ay maagtan is ikatakhona.” ");
INSERT INTO lbk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mo omchan kayo isnan ngag sisa'y ili, pootenyo ay khawis mo sino nan maikali ay manawat ken chakayo ischi, ta siya nan enchagsanyo engkhana ay komaan kayo. ");
INSERT INTO lbk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Et mo somkhep kayo isnan chey ay afong, kananyo isnan nen-afong en, ‘Mawawawawad-ay koma ken chakayo nan talna ay malpo ken Apo Dios.’ ");
INSERT INTO lbk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Et mo nan takho isnan chey ay afong et tan-oyancha ay manawat ken chakayo, at omey ken chaicha nan enkhawisan ay iskhepyo. Ngem mo ad-icha chawaten chakayo at chadlo tomoli ken chakayo nan chey ay enkhawisan ay ento mo iskhepyo. ");
INSERT INTO lbk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mo wad-ay ad-i manawat ken chakayo paymo mannge isnan kananyo, pagpakhenyo nan sikiyo ta makaan nan pinomket ay chapog ta kag tokhon ken chaicha, mo taynanyo isnan chey ay afong paymo ili. ");
INSERT INTO lbk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tet-ewa kanak ken chakayo ay isnan chey ay akhew ay en-okoman Apo Dios, at enyapyap-ew nan ichowana ay chosan nan iSodoma ya iGomorra mo nan ichowana isnan cheycha'y takho isnan chey ay ili.” ");
INSERT INTO lbk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kinwanin kayet Jesus, “Semkenyo na. Ifaak chakayo ay kag naamo ay karnilo isnan kawad nan kakaegyat ay atap ay aso, et masapol ay masilib kayo koma ay kag nan oweg, ya naanos kayo koma ay kag kalopati. ");
INSERT INTO lbk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mey-anyo nan awakyo isnan takho, tay at ichowacha chakayo is kaokom, ya at saplitencha chakayo is kasinagogacha. ");
INSERT INTO lbk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sa cha't khoyochen chakayo, ay mangiyey isnan cheycha'y khofernachor ya ali midkakay ken sak-en. Et siya sa kannay nan mangitet-ewaanyo maipoon ken sak-en isnan kasakhangcha, ya isnan cheycha'y Gentil. ");
INSERT INTO lbk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Et mo iyeycha chakayo ay mangidchalom, ad-i kayo madchanakhan isnan sa yo kanan paymo nan angnenyo ay ensefat, tay at isolon Apo Dios nan kananyo isnan osto ay timpona. ");
INSERT INTO lbk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tay at faken chakayo nan enkali, mod-i ket nan Ispiriton Apo Dios ay Amayo nan enkali ay maichalan ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Siya akhes chana nan timpo ay mangipapateyan nan etad isnan akhina kannay, nan ama isnan anakna kannay, ya nan an-ak, at ipapateycha akhes kannay nan chakek-echa. ");
INSERT INTO lbk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ya at liligten am-in nan takho chakayo, khapo ken sak-en. Nay met achi mo sino ka issa ay makakatpe isnacha engkhana'y kifos, et maisalakan ka. ");
INSERT INTO lbk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mo palikhatencha chakayo isnan esa'y ili, lomayaw kayo isnan teken. Tet-ewa nan kanak ken chakayo, tay at ad-i kayo makadchapos ay mangikwas isnan inpadnok ken chakayo isnan am-in ay ili id Israel, ya et kasin ak omali ay Anak si Takho. ");
INSERT INTO lbk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Maid disipolos is entongtongcho mo nan mistolona. Siya akhes isnan faa, ad-i entongtongcho mo nan apona. ");
INSERT INTO lbk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Omanay et isnan esa'y disipolos ay enfalin ay kag isnan mistolona, ya nan faa kag isnan apona. Siya akhes ken chakayo, mo apon si engag nan ipangachancha ken sak-en ay apo isnan pangafong, at am-amed nan kanancha ken chakayo ay pangafongko.” ");
INSERT INTO lbk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ad-i kayo et mampay omeg-egyat ken chaicha, tay maid masasalakan ay at ad-i maipaila, ya maid maitatafon ay at ad-i maipaammo. ");
INSERT INTO lbk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nan infagfakhak ken chakayo ay maid nakadnge, et masapol ay ipaammoyo isnan katakhotakho. Et nan ifab-aagko ken chakayo isnan makekedchengan tako, ipalawagyo isnan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ad-i kayo omegyat isnan menpatey isnan awak, ay ad-i makapatey isnan leng-ag, mod-i ket egyatenyo nan Dios ay wad-ay kamabfalina ay mamakawas isnan leng-ag ya awak id inferno. ");
INSERT INTO lbk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ad-i ngen tantanso nan lakon si chwa'y chekchekchek? Nay met achi maid olay esang ay mekchag ken chaicha isnan lota, mo ad-i ona ipalofos Amayo id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Am-amed ken chakayo, tay ammona chakayo, olay nan kabfifilang nan fookyo. ");
INSERT INTO lbk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ad-i kayo mampay omeg-egyat, tay napatpateg kayo mo nan angsan ay chekchekchek.” ");
INSERT INTO lbk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mo sino nan mangifaag isnan sakhang nan katakhotakho ay takhok siya, at siya akhes nan angnek ken siya isnan sakhang Ama id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngem mo sino nan mangisaot ay takhok siya isnan sakhang nan katakhotakho, at siya akhes nan angnek ken siya isnan sakhang Ama id chaya.” ");
INSERT INTO lbk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ad-iyo kanan en ornos nan enfanakhan nan inmaliyak isnan lota. Faken ornos nan enfanakhana, mod-i ket kholo. ");
INSERT INTO lbk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tay inmali ak ay mangipawad-ay isnan en-asigkholaan nan sin-ama, nan sin-ina, ya nan innapo ay fafai isnan katokhangana ay fafai. ");
INSERT INTO lbk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nan foson nan esa'y lalaki, et maid teken mod-i nan pangafongna kannay. ");
INSERT INTO lbk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mo sino nan mangipawadwad-ay isnan layadna ken cha amana ya inana mo nan layadna ken sak-en, et ad-i maikali ken sak-en. Ya mo sino nan mangipawadwad-ay isnan layadna isnan anakna mo nan layadna ken sak-en, et ad-i maikali ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mo sino akhes nan ad-i mangekwat isnan kolosna ya omonod ken sak-en, et ad-i maikali ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mo sino nan ad-i mangayyew isnan fiyagna ta olay matey midkakay ken sak-en, at maisalakan, ngem nan takho ay chadlos mangisalak isnan fiyagna kannay at khechangna ay amasena.” ");
INSERT INTO lbk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mo sino nan manawat ken chakayo, sak-en nan chinawatcha. Ya mo sino nan manawat ken sak-en, chawatena nan nangifaa ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mo sino nan manawat isnan faan Apo Dios tay ammona ay faana at chawatena akhes nan isofalit Apo Dios isnan faana, ya mo sino nan manawat isnan nalenteg ay takho tay ammona ay nalenteg nan chey ay takho, at chawatena nan maisofalit isnan nalenteg ay takho. ");
INSERT INTO lbk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Et mo sino nan mangichowa is olay sintastasa ay entengnin ay chanom isnan esang isnan naycha'y fan-ig ay disipolosko tay disipolosko siya, et tet-ewa kanak en at masobfalitan ay masobfalitan siya.” ");
INSERT INTO lbk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kakwasan nan namilinan Jesus isnan sinpoo ya chwa ay disipolosna, kinmaan ischi ta en men-isolo ya en-ipalawag akhes isnan cheycha'y ili ay sasag-ena. ");
INSERT INTO lbk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Idwani inomchan ken Juan ay maibfafalod nan okhod maipoon isnan chonon Cristo. Sa et finmaa isnan disipolosna is omey ay manalodsod ken Jesus ");
INSERT INTO lbk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","isnan kag tona, “Faken ngen sik-a san nakwani ay at omali, paymo som-ed kami ngen si teken?” ");
INSERT INTO lbk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Songfat et Jesus ay nangwanin, “Tomoli kayo ya ifaagyo ken Juan nan cha yo chengchengngen ya il-ilaen: ");
INSERT INTO lbk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","nan nakolap, makaila cha kasin, nan napilay, makachalan cha, naipagkhawis nan nakolit, ya makadnge nan natoweng, takhowena kasin nan natey, ya cha maipalawag nan Khawis ay Chamag isnan posi. ");
INSERT INTO lbk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Naoney yangkhay nan takho ay ad-i enchwadchwa ken sak-en!” ");
INSERT INTO lbk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Issan kinmaanan nan disipolos Juan, inokhod Jesus isnan katakhotakho nan maipoon ken Juan. Kinwanina, “Ngag kay nan kananyo ay katatakhon nan en yo inila is kaponchag? Kag ngen isnan fololong ay khig-iwwen si chakhem? ");
INSERT INTO lbk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ngag nan paat yo inmayan sidi? Ay ke yo en inila nan takho ay enfafacho is khawigkhawis ay enchangchangnge ay lopot? Nan enfafacho is kag todi et wad-ay cha isnan afong si ali. ");
INSERT INTO lbk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngag mampay nan inmayanyo ischi? Ay ke yo egay en inila nan esa'y mamadto? Wen. Ya kanak ken chakayo ay wadwad-ay pay mo nan mamadto nan inilayo. ");
INSERT INTO lbk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tay si Juan nan nakwani isnan naisolat ay kalin Apo Dios ay mangwanin, ‘Chey, at faalek nan faak ay mang-ona mo sik-a, ta isakhanana nan kew-am.’ ");
INSERT INTO lbk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tet-ewa kanak ken chakayo en, isnan am-in ay naiyanak, maid finmala ay entongtongcho mo si Juan Bautista. Nay met achi olay siya sa, maifilang kayet ay naon-oney mo siya nan kafan-ikhan ay takho ay maitapi isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mailapo issan timpon Juan Bautista engkhana idwani, wad-ay ay wad-ay nan kholo isnan wad-ayan nan en-ap-apowan Apo Dios, ya wad-ay cha nan makedse ay mangipapilit ay maitapi ischi. ");
INSERT INTO lbk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Siya sa tay am-in nan mamadto ya nan lenteg Moises, inpadtocha nan maipoon isnan en-ap-apowan Apo Dios engkhana ay inmali si Juan. ");
INSERT INTO lbk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Et mo mamati kayo, si Juan nan nakwanin Elias ay at omali. ");
INSERT INTO lbk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chengngenyo et na mo wad-ay kowengyo ay mannge.” ");
INSERT INTO lbk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ngag mampay nan is-ison nan naycha ay takho idwanin? Kag cha ongang-a is kamarkitan ay maid paat pasiyat-encha. Aped cha en-asifokhafokhaw ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mamattong kami ya ad-i kayo manayaw. Ilapomi ay mangantoway ya ad-i kayo makiachog.’ ");
INSERT INTO lbk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tay issan inmaliyan Juan ay cha na nentiptipelan ya egayna nakiin-inoman, kinwanicha en, ‘Naan-anitowan siya.’ ");
INSERT INTO lbk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sak et inmali akhes ay Anak si Takho ay nangnangan ya nakiin-inom, ya ke cha't kanan, ‘Ilaenyo kay ya nan sana'y oklongan ya amfotngan, ay liwid si enkorkortais ya wasit ay takho!’ Nay met achi olay mo siya sa, matet-ewaan kayet nan silib Apo Dios isnan enfanakhana.” ");
INSERT INTO lbk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yinangyangan Jesus nan cheycha'y omili isnan kailiili ay cha na nangangnenan isnan kaangsanan ay kamabfalina, tay egaycha chinokokhan nan fasolcha. ");
INSERT INTO lbk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kinwanina, “Selaeg yo ay iCorazin ya ken chakayo akhes ay iBetsaida! Tay mo sa ya inangnek id Tiro ya Sidon nan cheycha'y kamabfalin ay chak inangnen ken chakayo, at chinokokhancha issan chey nan fasolcha, ya at enfachocha is sako, sa cha't logkhitan nan olocha is chapo ay mangipaila isnan fafawicha. ");
INSERT INTO lbk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Et siya na nan kanak ken chakayo, at enyapyap-ew nan chosan nan iTiro ya iSidon mo nan chosayo isnan akhew ay en-okoman Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya chakayo ay iCapernaum, ay ke yo kanan en at matangad kayo id chaya? At maiwasit kayo id inferno! Tay mo sa ya naangnen id Sodoma nan cheycha'y kamabfalin ay inang-angnek ken chakayo, at sisya'y wad-ay kayet idwanin nan chey ay ili. ");
INSERT INTO lbk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nay et kanak ken chakayo, at enyapyap-ew nan chosan nan iSodoma mo nan chosa ay omchan ken chakayo, isnan akhew ay en-okoman Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Issan chey ay timpo kinwanin Jesus, “Enyaman ak ken sik-a Ama ay Apon nan chaya ya nan lota, tay inpailam isnan cheycha ay egay nakaachar nan egaymo inpaam-ammo isnan mamasilib ya nan cheycha'y makaawat. ");
INSERT INTO lbk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tet-ewa Ama, siya sa nan inangnem tay siya nan khawis ay mangipalal-ayad ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sa na't kinwanin, “Si Ama, inchowana nan am-in ken sak-en. Maid mangammo ken sak-en ay Anakna, mo faken yangkhay si Ama. Ya maid akhes mangammo ken Ama mo faken yangkhay sak-en ay Anakna, ya nan cheycha'y laychek ay mangipaammowan ken siya.” ");
INSERT INTO lbk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Intoptop Jesus ay nangwanin, “Omali kayo ken sak-en, am-in kayo ay mamablay ya madchacham-etan isnan likhat, ta paillengek chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wanchenyo nan sos-olok ya ensolo kayo ken sak-en, tay naoya ya naanos ak, et khomawis nan semekyo. ");
INSERT INTO lbk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tay ad-ik ipaawit ken chakayo nan ad-iyo kafaelan.” ");
INSERT INTO lbk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Isnan esa'y Sabfacho ay tengaw nanad-alan cha Jesus ya nan disipolosna is kapayew. Idwani tay naowat nan cheycha'y disipolos Jesus, inmala cha is cha cha kotkotimen. ");
INSERT INTO lbk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ngem isnan nangil-an nan Fariseo ischi, kinwanicha, “Ilaem kay ya, cha angnen nan disipolosmo nan maipawa isnan tengaw ay Sabfacho.” ");
INSERT INTO lbk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sa et kinwanin Jesus ken chaicha, “Egayyo ngen finasa nan inikkan cha David ya nan cheycha'y fowegna issan naowatancha? ");
INSERT INTO lbk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Si David sinomkhep isnan afong Apo Dios, ya kinmakan cha isnan tinapay ay naichoo ken Apo Dios. Maipawa met chi ken siya ya isnan cheycha'y fowegna, tay kwan yangkhay nan papachi chi. ");
INSERT INTO lbk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ay ke yo akhes egay finasa isnan lenteg Moises ay nan papachi, et isnan enchonowancha is kaTimplo isnan Sabfacho, ongosancha nan tengaw ngem maid naknakwaniyancha? ");
INSERT INTO lbk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kanak ken chakayo, wad-ay ken chakayo isna nan napatpateg mo nan Timplo. ");
INSERT INTO lbk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wad-ay nan kinwanin Apo Dios en, ‘Faken nan enkik-iwi ay ichooyo ken sak-en nan laychek, mod-i ket nan maneg-anganyo isnan ib-ayo.’ Mo sa ya maawatanyo nan laychen nan nay ay kanan, ad-iyo pabfasolen nan maid fasolna, ");
INSERT INTO lbk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","tay sak-en ay Anak si Takho nan mangiyapo isnan tengaw.” ");
INSERT INTO lbk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kinmaan si Jesus ischi ya inmey is kasinagogacha. ");
INSERT INTO lbk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wad-ay et ischi nan lalaki ay nasakew nan limana. Sa et kasalosalodsod nan cheycha'y takho ken Jesus tay laychencha'y wad-ay mangipabfasolancha ken siya. Kinwanicha, “Ipalofos ngen nan lenteg tako nan en-akhasan isnan tengaw ay Sabfacho?” ");
INSERT INTO lbk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sa na't kinwanin, “Ayed ta mo sa ya wad-ay ken chakayo nan mekchag is kafito nan esa'y karnilona isnan tengaw, ay ke na ad-i en palot-ayen chi? ");
INSERT INTO lbk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ad-i ngen wadwad-ay is solit nan takho mo nan karnilo? Nalenteg et achi mampay nan en-ikkan is khawis sinan tengaw ay Sabfacho.” ");
INSERT INTO lbk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sa na't kinwani isnan lalaki, “Oyachem nan limam.” Inoyadna nan limana ya ket nakhannawis kasin ay kag isnan esang ay limana. ");
INSERT INTO lbk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nay met achi nan cheycha'y Fariseo, kinmaan cha ay en natotya maipoon isnan angnencha ay mangipapatey ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Idwani, tay ammon Jesus nan semsemken nan Fariseo, kinmaan ischi. Ya inon-onod si katakhotakho ya cha na inpagkhawis nan am-in ay masasakit ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sa na't infilin ken chaicha ta mid mangifagfag-ancha isnan maipoon ken siya, ");
INSERT INTO lbk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ta maangnen nan infaag Apo Dios maichalan ken Isaias ay mamadto issan nangwaniyanan, ");
INSERT INTO lbk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Naay nan faak ay pinilik, nan laylaychek ay chadlos kaay-ayewak. Ichowak nan Leng-agko ken siya, ya at ipaammona nan tet-ewa ay kinalentegko isnan am-in ay takho. ");
INSERT INTO lbk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","At ad-i makisomasoma paymo enfokhafokhaw ya ad-i madmadnge nan kalina is kakarsa. ");
INSERT INTO lbk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pabfikasena nan nginmaya ya pabfikasena akhes nan enchwadchwa nan pammatina. Siya na nan ikkana engkhana'y pangafakena nan kinalenteg. ");
INSERT INTO lbk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ya siya nan at namnamaen nan am-in ay takho.” ");
INSERT INTO lbk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sa et inyeycha ken Jesus nan lalaki ay kinolap ya nginengek si anito ay wad-ay ken siya. Et inpagkhawis Jesus ya ket nakakkali ya nakaila chadlo. ");
INSERT INTO lbk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nataataa am-in san cheycha'y takho sa cha't kanan, “Ay ke siya nan Mesias ay Anak David?” ");
INSERT INTO lbk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nay met achi issan nanngelan nan cheycha'y Fariseo ischi, kinwanicha, “Da! Nan kamabfalin maachi yangkhay Beelzebub ay ap-apon si anito nan mangipakpakaanan tosa isnan anito.” ");
INSERT INTO lbk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tay ammon Jesus nan semsemkencha kinwanina, “Olay ngag ay en-ap-apowan ay en-asibfaloknit kannay, et mapakawas. Ya maid omannong is ili paymo sinpangafong mo maon-onon-ong. ");
INSERT INTO lbk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Adi kad mo si Satanas et pakaanena kannay nan anito, kholaena kannay nan awakna. Ngag et pay nan ikkan nan en-ap-apowana ay omannong mo siya chi? ");
INSERT INTO lbk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mo kananyo en chak pakaanen nan anito isnan kamabfalin Beelzebub, ngag akhes ay kamabfalin nan cha osalen nan takhoyo ay enpakaan? Ay ke teken? Nay et chaicha kannay nan mangokom isnan nenkamaliyanyo. ");
INSERT INTO lbk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ngem tay pakaanek nan anito maichalan isnan kamabfalin nan Ispiriton Apo Dios, siya nan mangipaila ay inomchan et nan en-ap-apowan Apo Dios ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Maiyalig si Beelzebub isnan mafikas ay takho. Maid makaskhep isnan afongna ay mangikaan isnan kwana, mo ad-ina ona itaked siya ta sa et nawaya ay mangakew isnan wad-ay ischi. ");
INSERT INTO lbk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mo sino nan maid ken sak-en, chaicha nan mangad-i ken sak-en. Ya nan ad-i mamachang ken sak-en ay en-iyapon, chaicha nan cha enfoka. ");
INSERT INTO lbk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kanak et mampay ken chakayo ay at mapakawan nan takho ay mangipangaag ken Apo Dios, ya mapakawan akhes nan am-in ay ila ay fasol. Ngem nan mangipangaag isnan Ispirito Santo, et ad-i mapakpakawan. ");
INSERT INTO lbk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mabfalin akhes ay mapakawan nan mangipangaag ken sak-en ay Anak si Takho. Ngem nan mangipangaag isnan Ispirito Santo, et ad-i kapakpakawan isnan kawadyo isnan nay ay lofong, paymo isnan kasin omali ay fiyag.” ");
INSERT INTO lbk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mo nan kaew et khawis, khawis akhes nan fekhasna. Ngem mo ngaag nan kaew, siya akhes isnan fekhasna. Tay maammowan nan kaew isnan fekhasna. ");
INSERT INTO lbk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Chakayo ay napapasig ay kag ap-on si oweg! Ay ke mabfalin ay chakayo ay ngaag et khawis nan kananyo? Tay nan wad-ay ay mimigto isnan semek si takho, siya akhes chi nan fomala isnan topekna. ");
INSERT INTO lbk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nan takho ay khawis nan pinenpepenpena is kasemekna, et khawis nan pafal-ena. Nan akhes takho ay ngaag nan pinenpepenpena is kasemekna, et ngaag akhes nan pafal-ena. ");
INSERT INTO lbk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Siya na nan kanak ken chakayo, isnan akhew ay maokoman, at waschin manongfat isnan am-in ay kinkinwanina ay maid enkhawisana. ");
INSERT INTO lbk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tay nan kananyo, et siya chi kannay nan mangipawaya ken chakayo paymo mangipachosa ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sa et wad-ay cha nan mimistolon si lenteg ya Fafariseo ay nangwanin, “Mistolo, laychenmi ay omipaila ka ken chakami is katataa ay kaimatonam.” ");
INSERT INTO lbk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sinfat Jesus chaicha ay nangwanin, “Chakayo ay ngaag ay takho ay ad-i katatalek ken Apo Dios, enkechakechaw kayo is katataa ay sinyal, ngem maid paat maipaila ken chakayo, mo faken yangkhay kecheng nan sinyal ay naila ken Jonas ay mamadto. ");
INSERT INTO lbk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tay si Jonas, tolo ay akhew ya lafina is kapoton nan chakchakowag ay ikan, et siya akhes ken sak-en ay Anak si Takho, at tolo ay akhew ya lafik isnan chaem nan lota ay maikakaob. ");
INSERT INTO lbk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Is omali ay akhew ay en-okoman Apo Dios, at tomakcheg cha nan iNineve ay mangisaklang isnan naycha ay takho idwani, tay chaicha et chinokokhancha kannay nan fasolcha issan nanngelancha isnan inpalawag Jonas. Ngem ilaenyo, olay mo wad-ay isna nan entongtongcho mo si Jonas. ");
INSERT INTO lbk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Siya akhes sa isnan Reyna ay nalpo isnan kaambagatan ay ili, at tomakcheg ay mangisaklang isnan naycha ay takho isnan at en-okoman Apo Dios. Tay paat nenfaat ay nalpo isnan pengpeng nan lota ta en na chengngen nan silib Solomon. Ngem ilaenyo, wad-ay isna nan entongtongcho mo si Solomon.” ");
INSERT INTO lbk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mo komaan nan anito isnan takho, enfaat isnan filig ay omanap is omillengana. Et mo maid maanapana, ");
INSERT INTO lbk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kanana et isnan nemnemna, ‘Somakhong ak et chadlo isnan nenteytey-ak.’ Ket ay tomoli ya edchanana san tinaynana ay maid entetee, sa et nachalochalosan ya nanongnonongnong. ");
INSERT INTO lbk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Omey et omayag is pito kayet ay ib-ana'y anito, ay am-am-amed ay ngaag mo siya, sa cha't somkhep ay entee ischi. Adi kad am-am-amed nan enfanakhan nan chey ay takho mo san chey nang-ona ay kasasaadna. Siya sa nan omat akhes isnan naycha ay ngaag ay takho idwani.” ");
INSERT INTO lbk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sisya ay cha enkak-ali si Jesus isnan cheycha'y takho, isnan inomchanan cha inana ya nan aag-ina. Wad-ay cha is kadchela ya laychencha'y makitot-oya ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sa et wad-ay nangwani ken siya, “Anen, wad-ay cha inam ya nan aag-im ay entatakcheg is kadchela. Laychencha ay tot-oyyen sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ya ket kanan Jesus ken siya, “Sino nan kanam en inak ya aag-ik?” ");
INSERT INTO lbk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sa et inpitchon Jesus nan cheycha'y disipolosna ay nangwanin, “Naaycha nan inak ya nan aag-ik! ");
INSERT INTO lbk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tay mo sino nan mangikkan isnan nemnem Ama id chaya, chaicha nan aag-ik ya inak.” ");
INSERT INTO lbk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Isnan chey kannay ay akhew, kinmaan si Jesus is kaafong ya inmey nentokcho is kailit nan fayfay ay en-isolo. ");
INSERT INTO lbk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ngem tay angsan nan katakhotakho ay nangal-alifongfong ken siya, nen-aton is kafangka, ya ischi nan nentokchowana ay nangisos-olowan isnan cheycha'y katakhotakho ay tinmatakcheg is kailit nan fayfay. ");
INSERT INTO lbk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Angsan nan insos-olona ken chaicha ay cha na inyal-alig. Kinwanina, “Wad-ay nan inmey ay nen-isapowak is esek. ");
INSERT INTO lbk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Isnan cha na nangisapowakan, wad-ay nan cha nap-as is kachalan, ya cha tinopek si ay-ayam. ");
INSERT INTO lbk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Cha akhes nap-as nan tapina isnan lota ay cheppas nan enchaem. Tay entapew nan lota ischi, et sang-oyan ya ket tinmofo. ");
INSERT INTO lbk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nay met achi osto'y finmala nan akhew, ya ke cha't ay naatongan ya naloyaw tay egaycha nenlamot ay khawis. ");
INSERT INTO lbk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nan tapina et cha cha nap-as is kasibsifitan, ya osto'y tinmofo nan sibsifit, sinolincha et nan cha tomofo ay esek. ");
INSERT INTO lbk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nan akhes tapina, nap-as cha isnan khawis ay lota, ya cha cha tinmofo ay khawis, ya wad-ay nan nenfekhas si sinkhagsot, sin-en-em poo ya nan tapina kayet sintotlon poo.” ");
INSERT INTO lbk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sa na't kanan, “Chengngenyo et mampay chana, mo wad-ay kowengyo.” ");
INSERT INTO lbk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nawnawni ya ket sinmag-en nan disipolos Jesus ken siya ay en nangwanin, “En man al-alig nan ikkam ay enkali ken chaicha ay?” ");
INSERT INTO lbk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sa et kinwanin Jesus ken chaicha, “Chakayo nan naipaammowan nan sikhod ay egay naammowan maipoon isnan en-ap-apowan Apo Dios. Ngem egay naipaammo chana ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tay nan mangidno isnan wad-ay ken siya, at maagtan kayet ta onanig omad-acha. Ngem nan maiyalig ay maid mabfalina ay ad-i mangidno isnan wad-ay ken siya, olay nan akit ay wad-ay ken siya, et makaan. ");
INSERT INTO lbk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Siya akhes sa isnan sos-olok. Siya na nan khotokna ay ngag ko alig ay enkali ken chaicha. Tay iilaencha ngem pakebtencha ay ad-i mangila, ya chechengngencha ngem ad-i cha paskhepen isnan kowengcha ya ad-icha maawatan. ");
INSERT INTO lbk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chaicha tet-ewa nan naangnenan nan inpadton Isaias ay mangwanin, ‘At enchengedchenge kayo yangkhay, ngem ad-i kayo paat makaawat. Ya at en-ilaila kayo, nay met achi ad-i kayo kayet makaimaton. ");
INSERT INTO lbk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Siya sa tay nan takho ay sanacha, et kinmenteg nan semekcha, ya kag mapopolat-an nan kowengcha, sa cha't kikimiten akhes nan matacha. Tay eleg ya makafigfig cha ya makadnge cha chadlo ya makaawat cha, sa cha't somakhong ken sak-en ta pakhawisek chaicha,’ kanan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nay met achi chakayo, naoney kayo tay nan matayo makaimaton, ya nan kowengyo makadnge. ");
INSERT INTO lbk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tet-ewa kanak ken chakayo, angsan cha nan mamadton Apo Dios ya nan cheycha'y nalenteg ay takho, ay chadlos nenlayad ay mangila isnan ilaenyo, ngem egaycha inila. Lalaychencha ay mannge isnan cha yo chengngen, ngem egaycha chinnge.” ");
INSERT INTO lbk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Chengngenyo et mampay nan ayen nan al-alig maipoon isnan en-isapsapowak. ");
INSERT INTO lbk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mo sino nan mannge isnan okhod maipoon isnan en-ap-apowan Apo Dios, sa cha't ad-i maawatan, chaicha nan kaiyalikhan nan chalan ay nap-asan nan esek. Omali si Satanas ya ikaana nan chey ay sos-olo ay naimola is kasemekcha. ");
INSERT INTO lbk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nan akhes lota ay cheppas nan chaemna ay nap-asan nan esek, chaicha nan takho ay mannge isnan kalin Apo Dios sa cha't ala ya chawat ay mangilayalayad. ");
INSERT INTO lbk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngem tay egay linmamot isnan semekcha, sin-ak-itan yangkhay nan pammaticha. Isonga mo omali nan sikhab paymo maipalikhatancha maipoon isnan kalin Apo Dios, at ipeg-anancha kannay nan pammaticha. ");
INSERT INTO lbk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nan akhes kasibsifitan ay nap-asan nan esek, chaicha nan mannge isnan kalin Apo Dios, ngem nan ayaka ay chanagcha isnan fiyagcha is kalota ya nan layadcha isnan kinafaknang nan nanolin isnan chinngecha ya ad-i mamkhas. ");
INSERT INTO lbk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nan akhes khawis ay lota ay nap-asan nan esek, chaicha nan mannge isnan kalin Apo Dios ya maawatancha. Chaicha mampay nan mamkhas is sinkhagsot, paymo sin-en-em poo, paymo sintotlon poo.” ");
INSERT INTO lbk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wad-ay nan teken ay al-alig ay inokhod Jesus ken chaicha. Kinwanina, “Nan en-ap-apowan Apo Dios, maiyalig isnan esa'y takho ay en nen-isapowak is khawis ay esek isnan omana. ");
INSERT INTO lbk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngem ket ay isnan lafi ay naseyeseyep cha am-in, inmey nan chey fosona, ay en nangimola isnan lokham isnan chey ay oma, sa et kinmaan. ");
INSERT INTO lbk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Awni, ya isnan cha tomofowan nan mola ya namkhasancha, naitapi nan cheycha'y lokham ay nakiengngan ya chadlos cha mamaila. ");
INSERT INTO lbk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Inmey et nan cheycha'y faan san nen-imola ya kinwanicha ken siya, ‘Apo, ad-i ngen khawis nan inmolam is kaomam? Tay ya ke angsan nan lokhamna mo?’ ");
INSERT INTO lbk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sa na't kinwani ken chaicha, ‘Fosok nan nangangnen issa.’ Kinwanin kayet san cheycha'y faana en, ‘En kami ngen lokhaman?’ ");
INSERT INTO lbk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ad-i, tay eleg ya maitapi nan mola ay makhafot,’ kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Ogkhayenyo ta makhigsan cha ay mengngan engkhana ay ani, ta at ifaagko isnan cheycha'y en men-ani, ta onaencha'y mangafot isnan cheycha'y lokham ay mamtek ta maipoo. Sa cha't ipenpen is kaallangko nan maani.’” ");
INSERT INTO lbk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wad-ay kayet nan teken ay al-alig ay inokhod Jesus ken chaicha. Kinwanina, “Nan en-ap-apowan Apo Dios maiyalig isnan kabfafan-ikhan ay esek ay makwanin mostasa, ay inmolan nan esa'y takho is kaomana. ");
INSERT INTO lbk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kabfafan-ikhan chi isnan am-in ay esek, ngem isnan tomofowana, at siya nan kaaanchowan isnan cheycha'y chapong ay omancho ay kag kaew. Ya at enkhafanan si ay-ayam nan pangana.” ");
INSERT INTO lbk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Inokhod kayet Jesus nan teken ay al-alig. “Nan en-ap-apowan Apo Dios, kag isnan fofod ay inlaok nan esa'y fafai isnan tolo ay salop ay alina ay awni ya ket ay finomlad am-in.” ");
INSERT INTO lbk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Am-in ay infab-aag Jesus isnan katakhotakho, et inchalana isnan al-alig. Maid kinkinwanina ken chaicha ay egayna inyal-alig. ");
INSERT INTO lbk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Et siya na nan inangnena ta tomet-ewa nan kinwanin nan mamadto ay nangwanin, “At ichalanko isnan al-alig nan kanak, ya ifaagko nan naitatafon mailapo issan nakhab-an nan lofong.” ");
INSERT INTO lbk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tinaynan Jesus nan katakhotakho, ya sinomkhep is kaafong. Sa et sinmag-en nan cheycha'y disipolosna ay nangwanin, “Ngag man nan ayen nan kinwanim ay al-alig maipoon isnan lokham is kaoma?” ");
INSERT INTO lbk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kinwanin Jesus ay sinmongfat, “Nan chey nangimola isnan khawis ay esek, et sak-en ay Anak si Takho. ");
INSERT INTO lbk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nan chey oma, siya nan lofong. Et nan khawis ay esek, siya chachi nan takho ay naitapi isnan en-ap-apowan Apo Dios. Sa et nan lokham, chaicha akhes nan takho ay naitapi isnan en-ap-apowan Satanas. ");
INSERT INTO lbk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nan foso ay nangimola isnan lokham, siya si Satanas. Nan ani, siya nan pengpeng si lofong, sa et nan en-ani, chaicha nan angheles. ");
INSERT INTO lbk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","At kag isnan naangnen isnan lokham ay nakhafot sa et naamong ay naipoo nan sa omat is mapengpengan nan lofong. ");
INSERT INTO lbk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","At faalek ay Anak si Takho nan anghelesko ay en mangamong ay mangifala is kaenap-apowak, nan am-in ay chomalatan nan kinangaag ya nan am-in ay ngaag ay takho. ");
INSERT INTO lbk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sa et iwasit nan angheles chaicha isnan enfidfichang ay apey ay kawad nan ngegngeg ya kaletket si fab-a. ");
INSERT INTO lbk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sa et nan cheycha'y takhon Apo Dios, at wad-ay cha ay enlalanglang ay kag akhew isnan en-ap-apowan Amacha. Chengngenyo et mampay na, mo wad-ay kowengyo.” ");
INSERT INTO lbk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Maiyalig nan en-ap-apowan Apo Dios isnan akon ay nakhakhab-onan is kapayew, ay ya ket edchanan nan esa'y takho. Ala na't ya khab-on ischi, ya isnan layadna en na't inlako nan am-in ay kwana, sa na't en lakwan nan chey ay payew.” ");
INSERT INTO lbk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kasin akhes maiyalig nan en-ap-apowan Apo Dios isnan inikkan nan komersiyanti, ay en nen-an-anap isnan khag-awis ya fab-alolen ay perlas. ");
INSERT INTO lbk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Issan nangchanana isnan esa'y kapapatekhan ay perlas, ke na't inlako nan am-in ay kwana, sa na't en lakwan chi.” ");
INSERT INTO lbk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Maiyalig kayet nan en-ap-apowan Apo Dios isnan sichok ay naisichok is kafayfay, ya nenkena isnan teketeken ay ilan si enkik-iwi is kadchanom. ");
INSERT INTO lbk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Osto'y napno nan sichok, inpachakacha is kailitna, sa cha't tinmokcho ay nankenanken ischi. Nan cheycha'y khawis tinkencha isnan khakwan, ya nan ngaag inwasitcha. ");
INSERT INTO lbk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Siya akhes na nan maangnen isnan mapengpengan nan lofong. Omali nan cheycha'y angheles ay manken isnan ngaag ya nan nalenteg ay takho. ");
INSERT INTO lbk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nan cheycha'y ngaag, at maiwasit cha isnan enfidfichang ay apey, ay kawad nan ngegngeg ya kaletket si fab-a.” ");
INSERT INTO lbk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Naawatanyo ngen am-in?” kinwanin Jesus. “Wen,” insongfatcha. ");
INSERT INTO lbk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sa na't kanan ken chaicha, “Mo sino nan mangisos-olo isnan naitawid ay lenteg, ya enfalin ay disipolosko isnan en-ap-apowan Apo Dios, et kag isnan wad-ay afongna ay makaipafala isnan chowa'y ilan si akon: nan falo ya nan naitawid akhes.” ");
INSERT INTO lbk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Infaafaag am-in Jesus nan cheycha ay al-alig, sa et kinmaan isnan chey ay ili. ");
INSERT INTO lbk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Isnan inomchanana isnan ilina, nen-isos-olo isnan sinagogacha. Ya ket nataataa nan kakailiyana ay cha mangwanin, “Ento man nan nangal-an tona isnan silibna ya nan katataa ay kamabfalina? ");
INSERT INTO lbk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ay ke faken na san anak si kalapantilo? Faken ngen si Maria nan inana? Ad-i ngen cha Santiago, si Jose, si Simon ya si Judas nan aag-ina? ");
INSERT INTO lbk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ad-i ngen sanacha ken chatako nan kafabfaiyana? Ento achi nan nangal-ana isnan am-in ay wad-ay ay kafaelana?” ");
INSERT INTO lbk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sa cha't inad-i siya. Ngem kinwanin Jesus ken chaicha, “Maichad-ayaw nan mamadto isnan entona issa, nay met achi isnan osto ay ilina ya pangafongna kannay, maid filangna.” ");
INSERT INTO lbk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Et maid inangnena's angsan ay kail-an nan kamabfalina ischi, tay maid pammaticha ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Issan chey ay timpo, chinngen Herodes ay khofernachor id Galilea nan maog-okhod maipoon ken Jesus, ");
INSERT INTO lbk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","sa na't kinwani isnan faana, “Siya na si Juan Bautista, ay kasin finmangon isnan etey. Siya na nan khotokna ay wad-ay kamabfalina ay mangangnen isnan naycha ay katataa.” ");
INSERT INTO lbk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kinwanin Herodes chi tay siya san nangipakhoyod ken Juan issan chey, sa na't inpataked ya inpafalod siya, midkakay ken Herodias ay asawan nan etadna ay si Felipe. ");
INSERT INTO lbk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tay kanakanan Juan ken siya en, “Lawa nan mangiyamongam isnan asawan nan akhim.” ");
INSERT INTO lbk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Laychen Herodes ay mangipapatey ken Juan ngem omegyat isnan Judio, tay ifilangcha ay si Juan et esa'y mamadto. ");
INSERT INTO lbk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Osto'y pitsan nan akhew ay naiyanakan Herodes, inmey nan magmagkit Herodias ay nensalasala isnan sakhang nan cheycha'y naam-among ay makilaglagsak ken siya. Ya tay nalaychalaychan si Herodes, ");
INSERT INTO lbk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","inkalina ken siya ay nangwanin, “Isapatak ay ichowa ken sik-a nan olay ngag sisa ay kedchawem!” ");
INSERT INTO lbk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Et isnan sogsog inana, kinwanin et nan magmagkit, “Ichowam kannay ken sak-en isna nan mapapalato ay olon Juan Bautista.” ");
INSERT INTO lbk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nenfafawi si ali Herodes, ngem khapo isnan chey insapatana sa et tay wad-ay cha nan fisitana, infilina ay maala nan olon Juan. ");
INSERT INTO lbk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ket ay finaana nan inmey ay namotlong isnan olon Juan is kafabfalochan, ");
INSERT INTO lbk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","sa cha't palatowen ya naichowa isnan magmagkit, ay nangiyey ken Herodias ay inana. ");
INSERT INTO lbk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ya ket inmey nan cheycha'y disipolos Juan ay nangala isnan awakna ay en nangikaob. Ya inmey cha infaag ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Osto'y chinngen Jesus nan naangnen ken Juan, nakekecheng cha ay nenfangka ay kinmaan, ya inmey isnan kawad nan maid tagtakhowan. Nay met achi issan nangammowan nan katakhotakho, tinaynancha nan ilicha ya inchad-alan cha ay nangonod ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Issan chinmakalan Jesus, inilana nan angsaangsan ay takho ya chadlos naseg-ang ken chaicha. Et cha na inakhasan nan nasakit ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Osto'y sedsechemna, inmey nan disipolosna ken siya ay nangwanin, “Nay fomollinget et ya ponchag na. Kanam et achi isnan katakhotakho ta omey cha isnan sanacha ay ili ta lomako cha is kanencha.” ");
INSERT INTO lbk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sa et kinwanin Jesus, “Ad-icha mang-ey komaan. Panganenyo magtek chaicha.” ");
INSERT INTO lbk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kinwanicha't ken Jesus, “Kedkecheng paat nan lima ay tinapay ya chwa ay filis nan wad-ay ya!” ");
INSERT INTO lbk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kinwanin Jesus, “Iyaiyo isna.” ");
INSERT INTO lbk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Inpatokchona nan katakhotakho is kaponchag, sa na't inala nan lima ay tinapay ya chwa ay filis ya nentangad id chaya ay nenyaman, sa na't pinet-apet-ang ya inchowa isnan disipolosna ta iwalascha isnan cheycha'y takho. ");
INSERT INTO lbk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nangan cha't am-in ya negsan cha. Ya nan nakhayad ay tinapay ay cha chinakhop nan disipolosna et sinpoo ya chwa ay nenkapno ay labfa. ");
INSERT INTO lbk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Inmey si liman lifo ay lallalaki nan nangan, ay egay naitapi ay naifilang nan fabfafai ya nan ongang-a. ");
INSERT INTO lbk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Osto'y siya chi inpaon-onan Jesus nan disipolosna is kafangka, ta omey cha is chemangna, sa na't inpasaa akhes nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Inpasaana chaicha ya kedkecheng et siya is nanikid is kafilig, ay en nenlowalo. Naes-esang si Jesus ischi engkhana ay sedsechemna, ");
INSERT INTO lbk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ya adchawi et nan fangka ay cha mapalikhatan isnan talipyakew, tay ab-afikas nan chakhem ay manabsab-at ischi. ");
INSERT INTO lbk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cha matalan-o, ya ket wad-ay si Jesus ay manad-alan is kaoson nan chanom ay somagsag-en ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Issan nangil-an nan disipolosna ken siya ay cha manad-alan isnan oson nan fayfay, nenkabfefegyas cha ay mangwanin, “Cheey! Nay si anito!” Et khapo isnan egyatcha ke cha't ay nenwakis. ");
INSERT INTO lbk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngem nenkanan kannay Jesus ken chaicha, “Pabfikasenyo nan semekyo, tay sak-en na. Ad-i kayo omegyat.” ");
INSERT INTO lbk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sa et kinwanin Pedro ken siya, “Apo, tay sik-a pet sa, omayag ka ed ken sak-en ta manalan ak akhes is kadchanom ay omali ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Omali ka,” kinwanin Jesus. Nentaynana et nan fangka ya nanalan is kaoson nan chanom ay inmey ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nay met achi issan nangippengana isnan ab-afikas ay chakhem, ya ket ay inmegyat, ya cha et malin-eb. Infokhawna't ay mangwanin, “Apo, isalakam sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nen-egnan Jesus si Pedro ay nangwanin, “Na! Ke pet akiakit nan pammatim mo! Ya ke ka enchwadchwa ay?” ");
INSERT INTO lbk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Linmokhan cha pay is kafangka ya ket ay tinomke kannay san chakhem. ");
INSERT INTO lbk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chaicha akhes ay wad-ay is kafangka chinad-ayawcha siya ay mangwanin, “Tet-ewa pet ay sik-a nan Anak Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Intot-oloy cha ay inmey is kadchemangna ya inomchan cha isnan ili ay Genesaret. ");
INSERT INTO lbk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Inmatonan et nan takho ischi si Jesus, sa cha't inmey ay nangifab-aag isnan am-in ay kailiili, ya cha cha inyey ken siya nan am-in ay nenkasakit. ");
INSERT INTO lbk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nenseg-ang cha ken siya ta sikchochencha olay paat yangkhay nan khayachan nan fachona. Et am-in ay nanikchod ischi et naipagkhawis cha. ");
INSERT INTO lbk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Idwani, wad-ay cha nan tapina'y Fariseo ya nan mistolon si lenteg ay nalpo id Jerusalem ay inmey ken Jesus. Kinwanicha, ");
INSERT INTO lbk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“En man ad-i patiyen nan disipolosmo nan mawanwaned ay ekhad nan ikik-it tako ay? Tay ya ke cha ad-i enfolo ay mangaan ona isnan afig, esa cha mangan?” ");
INSERT INTO lbk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sinomfat si Jesus ay nangwanin, “Ya chakayo pay, ke yo chokokhan nan filin Apo Dios ta nan et ekhadyo nan en yo pawadwad-en mo? ");
INSERT INTO lbk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tay infilin Apo Dios ay mangwanin, ‘Patkhenyo nan amayo ya inayo,’ ya, ‘Mo sino nan mangipangaag isnan amana paymo inana, et masapol ay maipapatey.’ ");
INSERT INTO lbk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nay met achi nan kananyo et ad-i mang-ey fomachang isnan amana paymo inana nan takho ay mangwanin, ‘Chey, apchas ko inchowa ken Apo Dios nan ento mo ifachangko ken chakayo.’ ");
INSERT INTO lbk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Et khapo isnan sana ay ekhadyo, maichenyo et nan kalin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Chakayo ay kakas-okas-on! Tet-ewa san inpadton Isaias maipoon ken chakayo issan nangwaniyana en, ");
INSERT INTO lbk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Siya na nan kanan Apo Dios: “Nan naycha ay takho et chad-ayawencha sak-en isnan topekcha yangkhay, ngem adchawi nan semekcha ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ongar yangkhay nan chomad-ayawancha, tay en cha isos-olo nan lenteg si takho ay siya kano chi nan sos-olon Apo Dios.” ’ ” ");
INSERT INTO lbk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Inayakhan Jesus nan katakhotakho ya kinwanina ken chaicha, “Chengngenyo na ta maawatanyo. ");
INSERT INTO lbk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Faken nan ikamil nan takho is katopekcha nan mangipallawa ken chaicha, mod-i ket nan fomala isnan topekcha.” ");
INSERT INTO lbk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Inmey et ken Jesus nan cheycha'y disipolosna ay nangwanin, “Ammom ngen ay ensakit nan semek nan cheycha'y Fariseo khapo isnan kinwanim?” ");
INSERT INTO lbk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Inyalig Jesus ay nangwanin, “Am-in ay mola ay egay inmolan Ama id chaya, at makhafot. ");
INSERT INTO lbk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ngag ngotoyo ken chaicha. Tay kag cha nakolap ay en-ipangpango. Et mo nakolap nan mangipango isnan ib-ana ay nakolap akhes, et mekyag cha'y chwa is kafito.” ");
INSERT INTO lbk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sa et kinwanin Pedro ken siya, “Ilatlatakmo ed nan ayen nan sana ay al-alig ken chakami.” ");
INSERT INTO lbk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sa et kinwanin Jesus, “Ad-i kayo ngen akhes kayet makaawat? ");
INSERT INTO lbk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ay ke yo ad-i paat maawatan ay am-in ay maikamil is katopek et omey is kapoto sa et fomala? ");
INSERT INTO lbk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngem mo ngag nan fomala isnan topek, siya nan wad-ay isnan nemnem, ya siya nan mangipangaag isnan takho. ");
INSERT INTO lbk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tay malpo isnan nemnem nan ngaag ay semek, nan enpatey, nan menchwadchwa isnan pantewna, nan asi ay okhali, nan akew, nan mangisapata isnan ineengag, ya nan enpangaag. ");
INSERT INTO lbk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Siya chana nan mangipallawa isnan takho, ya faken nan ad-i enfolowan isnan manganan.” ");
INSERT INTO lbk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kinmaan si Jesus ischi ya inmey isnan sakop nan ili ay Tiro ya Sidon. ");
INSERT INTO lbk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ya ket inmey ken siya nan esa'y fafai ay Cananeo ay nakiiili ischi. Ya nenfogfokhaw ken Jesus ay nangwanin, “Seg-angam sak-en, Apo, ay Anak David. Tay naan-anitowan nan anakko ay fafai ya chad-ama nan likhatna.” ");
INSERT INTO lbk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngem aped na yangkhay inkhigkhinek. Sa et inmey nan cheycha'y disipolosna ken siya ay nangwanin, “Pakaanem achi siya, tay ke omon-on-onod ay fomokhafokhaw ken chatako!” ");
INSERT INTO lbk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sinmongfat et si Jesus ay nangwanin, “Naifaa ak ay mamachang yangkhay isnan pangafong Israel, ay maiyalig ay nadchongaw ay karnilo.” ");
INSERT INTO lbk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngem inmey kayet nan chey fafai ay nenfalintomeng ken siya ay cha kayet mangwanin, “Apo, fomachang ka ed ay.” ");
INSERT INTO lbk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kinwanin et Jesus, “Ad-i osto ay alaen nan kanen nan an-ak sa et ibkas isnan aso.” ");
INSERT INTO lbk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kinwanin kayet san fafai, “Tet-ewa nan kanam Apo, ngem olay kag todi, siya kayet ay kanen nan aso nan cha mekchag isnan lamisaan nan apona.” ");
INSERT INTO lbk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tay siya chi kinwanin Jesus ken siya, “Sik-a'y ina, mailak ay chachama nan pammatim! Maangnen et nan laychem.” Ya ket nakhannawis nan magmagkit ay anakna. ");
INSERT INTO lbk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tinaynan Jesus nan chey ay ili sa na't laosan nan fayfay id Galilea. Linmamag is kafilig sa et tinmokcho ischi. ");
INSERT INTO lbk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ya ket inmey nan angsan ay katakhotakho ken siya ay nangiyey isnan napilay, nakolap, nenkatormochan, nangengek ya nan angsan pay ay tapina. Et insaadcha am-in chaicha isnan sakhang Jesus, ya inpagkhawisna chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nataataa nan cheycha'y takho, sa cha't chinad-ayaw nan Dios nan Israel issan nangil-ancha ay nan nangengek et makakkali chadlo, ya nan nenkatormochan et naipagkhawis cha, nan napilay makachalan cha, ya nan nakolap makaila cha. ");
INSERT INTO lbk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Inayakhan et Jesus san cheycha'y disipolosna ay nangwanin, “Maseg-ang ak isnan naycha'y katakhotakho, tay tolo et ay akhewcha ken sak-en, ya maid et kanencha. Ad-ik laychen ay pasaalen chaicha ay maoowat, tay eleg ya maolaw cha isnan chalan.” ");
INSERT INTO lbk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sa et kinwanin nan disipolosna, “Ento pay nan omanapan tako isna is kaponchag si omanay ay ipakan isnan naycha'y angsan ay katakhotakho?” ");
INSERT INTO lbk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kinwanin et Jesus ken chaicha, “Kaat nan wad-ay ay tinapay sisa?” Sa cha't kinwanin, “Pito, sa et nan akit ay filis.” ");
INSERT INTO lbk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Inpatokchon et Jesus nan angsan ay takho is kalota. ");
INSERT INTO lbk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Inalana nan pito ay tinapay ya nan filis, ya osto ay nenyaman ken Apo Dios, pinetpet-angna sa na't inchowa isnan disipolosna, ya inwalascha isnan takho. ");
INSERT INTO lbk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nangan cha't am-in ya negsan cha, ya nan nakhayad ay tinapay ay chinakhop nan disipolosna et pito ay nenkapno ay labfa. ");
INSERT INTO lbk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Epat lifo nan nangan ay lallalaki, ay egay naitapi ay naifilang nan fabfafai ya nan ongang-a. ");
INSERT INTO lbk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sa et inpasaan Jesus nan katakhotakho, ya nenfangka ay inmey isnan sakop nan Magadan. ");
INSERT INTO lbk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Isnan namingsan wad-ay nan Fariseo ya Saduceo ay inmey naneptepeng ken Jesus, ta en-ipaila is maton ay malpo id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kinwanin et Jesus ken chaicha, “Mo sedsechemna kananyo en, ‘At maekhew is wakas tay mamab-ayas.’ ");
INSERT INTO lbk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ya mo ilaenyo nan chaya isnan wiit, kananyo, ‘Da! At enlemlem na tay mamab-ayas, ya inngitit nan lifoo!’ Ammoyo pet ay mangifaag isnan ayen nan ilan nan chaya, ngem ya ke kayo ad-i makaawat isnan ayen nan maton nan cha maang-angnen mo! ");
INSERT INTO lbk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Chad-ama chadlo nan kinangaag nan takho idwani, ya ad-i katatalek ken Apo Dios. Ya ke sinyal nan kedchakedchawenyo ken sak-en ay? Ngem maid ipailak ken chakayo mod-i kecheng nan sinyal ay naangnen ken Jonas.” Sa et tinaynan Jesus chaicha ya kinmaan. ");
INSERT INTO lbk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Issan inmayan nan cheycha'y disipolos is kadchemangna, nalichongancha nan sengetcha'y tinapay. ");
INSERT INTO lbk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Ilaenyo ta meymey-anyo nan awakyo isnan fofod nan Fariseo ya Saduceo,” kinwanin Jesus ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sa et natotya nan disipolosna ay mangwanin, “Kanana chi tay egay tako nen-itakin si tinapay.” ");
INSERT INTO lbk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tay ammon Jesus nan cha cha kankanan, kinwanina, “Ngag man nan kasin yo kanakanan isnan egayyo nanngetan? En man akiakit nan pammatiyo ay? ");
INSERT INTO lbk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ad-iyo ngen kayet maawatan? Ay ke yo ad-i semken san lima ay tinapay ay naikakcheng isnan liman lifo ay takho, sa et nan kaat ay labfa nan pinnoyo isnan cha nakhayad? ");
INSERT INTO lbk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ad-iyo ngen semken san pito ay tinapay ay naikakcheng isnan epat lifo, ya nan kaat ay labfa ay pinnoyo? ");
INSERT INTO lbk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","En yo man ad-i paat maawatan ay faken tinapay nan laychek ay kanan ay? Kanak ay en-annad kayo isnan fofod nan cheycha'y Fariseo ya Saduceo.” ");
INSERT INTO lbk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sa cha't chadlo naawatan ay faken pet nan fofod ay maiyoto isnan tinapay nan kankanan Jesus, mod-i ket nan sos-olon nan Fariseo ya nan Saduceo. ");
INSERT INTO lbk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Issan inomchanan Jesus isnan sakop nan Cesarea Filipos, kinwanina isnan cheycha'y disipolosna, “Isnan semek si takho, sino ak ay Anak si Takho?” ");
INSERT INTO lbk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sa cha't kinwanin, “Kanan nan tapina ay sik-a si Juan Bautista, nan tapina kanancha ay sik-a si Elias, ya wad-ay kayet nan mangwanin sik-a si Jeremias paymo esang ka isnan tapina ay mamadto.” ");
INSERT INTO lbk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sa na't kanan, “Chakayo kay, ngag nan kananyo? Sino ak?” ");
INSERT INTO lbk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sinomfat et si Simon Pedro ay nangwanin, “Sik-a si Cristo ay Anak nan matatakho ay Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sa et kinwanin Jesus, “Naoney ka Simon ay anak Jonas, tay faken takho nan nangipaammo issa ken sik-a mod-i ket si Ama id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Idwanin, siya na nan kanak ken sik-a, fato ka Pedro, ya isnan nay fato nan mamangonak isnan sinfaanko. Et maid kamabfalin nan olay etey ay mangafak isnan cheycha'y mamati ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ichowak ken sik-a nan torfek nan en-ap-apowan id chaya, et mo ngag issa nan ipawam isnan lota at maipawa akhes id chaya. Ya am-in nan ipalofosmo isnan lota, siya akhes chi nan maipalofos id chaya.” ");
INSERT INTO lbk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sa na't chadlos infilin isnan disipolosna, ta ad-icha ifab-aag isnan olay sino ay siya nan Cristo. ");
INSERT INTO lbk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nailapo ischi, cha inpaawat Jesus isnan cheycha'y disipolosna ay mangwanin, “Masapol ay omey ak id Jerusalem, ay at maipap-alikhatak isnan amam-an si Judio ya aap-apon si papachi, ya nan mimistolon si lenteg. Sak et maipapatey, ya isnan maikatlo ay akhew maipatakho ak.” ");
INSERT INTO lbk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sa et inik-ak Pedro si Jesus ya yinangyangana siya ay nangwanin, “Apo, ad-i koma ipalofos Apo Dios chi. Ad-i mabfalin ay maangnen chi ken sik-a!” ");
INSERT INTO lbk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sinakhong et Jesus si Pedro ay nangwanin, “Komaan ka, Satanas! Omisasakhaw ka yangkhay. Tay faken nan nemnem Apo Dios nan semsemkem mod-i nan nemnem si takho.” ");
INSERT INTO lbk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sa et kinwanin Jesus isnan disipolosna, “Mo sino nan menlayad ay maifoweg ken sak-en, masapol ay faken nan awakna is pawadwad-ena, awitena nan kolosna, ya maifoweg ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tay mo sino nan ad-i mangayyew isnan fiyagna ta olay matey midkakay ken sak-en, at maisalakan. Ngem nan takho ay chadlos mangisalak isnan fiyagna at khechangna ay amasena. ");
INSERT INTO lbk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ay ke wad-ay fongaen nan takho olay mo kowaena am-in nan wad-ay isnan lofong, ngem maid fiyagna ay eng-engkhana? Maid kasin mabfalin ay isakan nan takho isnan naamas ay fiyagna. ");
INSERT INTO lbk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tay isnan kamabfalin Ama at omali ak ay Anak si Takho ay mangifoweg isnan anghelesko. Sak et esaesangen ay sobfalitan nan takho isnan maifakhay isnan inang-angnena. ");
INSERT INTO lbk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tet-ewa kanak ken chakayo, wad-ay ken chakayo isna nan at ad-i mangippeng isnan etey engkhana ay ilaencha nan omaliyak ay Anak si Takho ay en-ap-apo.” ");
INSERT INTO lbk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kakwasan nan enem ay akhew intakin Jesus si Pedro ya cha Santiago ken Juan ay sin-akhi, ya nakekecheng cha ay nanikid isnan esang ay at-atakchag ay filig. ");
INSERT INTO lbk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ya ket tinmeken nan ilan Jesus isnan sakhangcha. Al-alanglang nan kamesna ay kag sinan akhew, ya somili nan fachona ay kag silaw. ");
INSERT INTO lbk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Faagna ke cha't inila cha Moises ken Elias, ay cha makitot-oya ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sa et kinwanin Pedro ken siya, “Apo, khawis pet nan wad-ayan tako isna, et mo laychem, khomaeb ak is tolo ay ab-afong isna, et enkwam nan esang, ya kwan Moises nan esang, sa et kwan akhes Elias nan esang.” ");
INSERT INTO lbk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sisya ay enkak-ali si Pedro ya ket wad-ay nan somili ay lifoo ay nangap-ap ken chaicha, sa cha't chinnge nan kali ay nalpo is kalifoo ay mangwanin, “Siya na nan laylaychek ay Anakko. Malaylaychan ak ken siya. Chengngenyo siya!” ");
INSERT INTO lbk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Issan nanngelan nan cheycha'y disipolosna isna, naneng cha't ya lokfob isnan chad-ama ay egyatcha. ");
INSERT INTO lbk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Inmey et si Jesus ay nanikchod ken chaicha ay nangwanin, “Fomangon kayo. Ad-i kayo omegyat!” ");
INSERT INTO lbk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Et osto'y nenmonaang cha, maid inilacha, mod-i ket kecheng si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Issan cha cha khomwafan is kafilig, infilin Jesus ken chaicha ay nangwanin, “Ad-iyo ifab-aag isnan olay sino nan inilayo, engkhana ay maipatakho ak ay Anak si Takho isnan etey.” ");
INSERT INTO lbk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sinalodsod et nan disipolosna, “En man kanan nan mimistolon si lenteg ay masapol ay mang-ona ay omali si Elias ay?” ");
INSERT INTO lbk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kinwanin et Jesus, “Tet-ewa'y mang-ona si Elias ay mennongnong isnan am-in. ");
INSERT INTO lbk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngem kanak ken chakayo ay apchas et inmali si Elias, ya egaycha naimatonan siya, et kangnon nan linayadcha ay inang-angnen ken siya. Siya akhes nan angnencha ken sak-en ay Anak si Takho, at palikhalikhatencha sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naawatan et nan cheycha'y disipolosna ay si Juan Bautista nan kankanana. ");
INSERT INTO lbk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Issan tinmoliyan cha Jesus isnan katakhotakho, sinmag-en nan esa'y lalaki ken siya, ya nenfalintomeng isnan sakhangna ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo, seg-angam nan fab-alok! Tay enkechas ya chad-ama nan likhatna. Kad-in maisakhaw is kaapey ya is kadchanom. ");
INSERT INTO lbk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inyeyko siya isnan cheycha'y disipolosmo, ngem ad-i cha makaipagkhawis.” ");
INSERT INTO lbk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kinwanin et Jesus, “Chakayo ay maid pammatina ya naikfis nan akkhona! Ay kek sa makitetetetee ken chakayo? Kaatna pan nan sak mangan-an-anosan ken chakayo? Yaiyo siya isna.” ");
INSERT INTO lbk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nenyangyangan Jesus nan chey anito ya nabfanala isnan chey fab-alo, ya ket kannay khinmawis. ");
INSERT INTO lbk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Awni ya ket nakekecheng cha nan disipolosna ay inmey ken Jesus ya kinwanicha, “En kami man ad-i tet-ewa'y makaipafala ay?” ");
INSERT INTO lbk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sa na't kanan, “Siya sa tay kolang nan pammatiyo. Tet-ewa kanak ken chakayo, mo sa wad-ay pammatiyo ay olay kag isnan kafan-ig nan esek si mostasa, at mabfalin ay kananyo isnan nay ay filig, ‘En-aton ka,’ et en-aton tet-ewa. Ya maid ad-i mabfalin ken chakayo! ( ");
INSERT INTO lbk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngem maid makaipafala isnan kag tona ay ilan si anito, mo ad-i esten ay enlowalo ya entipe.)” ");
INSERT INTO lbk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Isnan namingsan ay naamongan cha Jesus ya nan disipolosna id Galilea, kinwanin Jesus ken chaicha, “Nay at maichowa ak ay Anak si Takho isnan kamabfalin nan takho, ");
INSERT INTO lbk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ay at mamatey ken sak-en. Ya isnan ikatlo ay akhew at kasin takhowen Apo Dios sak-en.” Sa cha't nenngongoyos issan nanngelancha ischi. ");
INSERT INTO lbk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Issan inomchanan cha Jesus id Capernaum, sinmag-en ken Pedro nan cheycha'y enchagchakhop si fowis ay omey isnan Timplo. Sa cha't kinwani ken siya, “Ad-i ngen enfab-ayad nan mistoloyo isnan fowis?” ");
INSERT INTO lbk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Sinmongfat si Pedro ay nangwanin, “Wen pay.” Issan sinomkhepan Pedro is afong, inonnaan Jesus ay nangwanin, “Ngag nan semekmo Simon? Isnan cheycha'y ali isnan lofong, sino nan mangal-ancha isnan fowis? Isnan kailiyancha ngen paymo isnan teken?” ");
INSERT INTO lbk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Isnan teken achi,” insongfat Pedro. “Mo siya et mampay sa,” kinwanin Jesus, “ad-i et masapol ay enfayad nan kailiyancha. ");
INSERT INTO lbk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngem ta maid somongtan nan naycha, engka't mamanniit is kafayfay. Et nan mang-ona ay fanniitam, alaem ya takangem nan topekna, et edchasam nan siping. Siya chi nan alaem ay em ibfowis pala ken chaita ay chwa.” ");
INSERT INTO lbk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Osto'y siya chi, inmey nan disipolos Jesus ken siya ay nensalodsod, “Sino nan katongchowan isnan en-ap-apowan Apo Dios?” ");
INSERT INTO lbk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Inayakhan Jesus nan esang ay ong-onga, sa na't inpatakcheg isnan sakhangcha. ");
INSERT INTO lbk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sa na't kanan, “Tet-ewa kanak ken chakayo, sok-ed kayo ona enfaliw, ta kag kayo isnan ongang-a, esa kayo pay makaskhep isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mo sino et mampay nan mangifan-ig isnan awakna ay kag isnan nay ay ong-onga, siya nan katongchowan isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ya mo sino nan manawat isnan esa'y ong-onga ay kag ken tona maigkhapo ken sak-en, et sak-en nan chawatena.” ");
INSERT INTO lbk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mo sino nan enkhapowan nan enfasolan nan olay esang isnan naycha'y ongang-a ay mamati ken sak-en, et khagkhag-awis yangkhay mo maitaked is kafakhangna nan chakchake ay losong ay fato, sa et maiparneng is kaad-achaem ay fayfay. ");
INSERT INTO lbk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Selaeg nan katakhotakho isnan lofong, tay wad-ay cha nan manaisailo ken chaicha. Tet-ewa ay wad-ay ay wad-ay nan maawisan ay enfasolan, ngem selaeg nan takho ay kalpowan nan naycha ay makabfasolan. ");
INSERT INTO lbk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Et mo nan sana ay limam paymo nan sikim nan khotokna's enfasolam, khap-esna't si pen potlongmo ta iwasitmo. Khagkhag-awis si natormochan ka paymo napilay ka, mo ket maagtan ka is fiyag ay eng-engkhana, mo nan sisya nan chwa'y limam paymo sikim, ngem maiwasit ka isnan apey ay eng-engkhana. ");
INSERT INTO lbk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ya mo nan sana ay matam nan khotokna's enfasolam, pen loknatam sam et iwasit. Khagkhag-awis si olay esang nan matam mo ket maagtan ka is fiyag ay eng-engkhana, mo nan sisya'y chwa nan matam ya maiwasit ka isnan apey id inferno.” ");
INSERT INTO lbk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ilaenyo ta ad-iyo am-amsiwen nan olay esang isnan naycha'y ongang-a. Tay kanak ken chakayo, wad-ay anghelescha id chaya ay wawawawad-ay isnan sakhang Ama id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Tay inmali ak ay Anak si Takho ay mangisalak isnan cheycha'y nadchongaw.) ");
INSERT INTO lbk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ngag nan kananyo? Mo nan esa'y takho ya wad-ay sinkhasot ay karnilona, sa et nadchongaw nan esang, ad-ina ngen taynan nan siyam poo ya siyam is kafilig, ta en na anapen nan chey ay esang ay nadchongaw? ");
INSERT INTO lbk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tet-ewa kanak ken chakayo ay mo edchasana, at wadwad-ay nan lagsakna isnan nay ay es-esang, mo isnan siyam poo ya siyam ay egay nadchongaw. ");
INSERT INTO lbk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Siya akhes ken Ama id chaya, ad-ina laychen ay wad-ay maamas is olay esang sinan naycha'y ongang-a.” ");
INSERT INTO lbk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mo makafasol ken sik-a nan ib-am, engka ken siya ta ifaagmo nan finmasolana. Angnem magtek na isnan machodchwaanyo yangkhay. Et mo chengngena sik-a, inyornosmo kasin siya ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nay met achi mo ad-ina chengngen sik-a, omayag ka is esang paymo chwa ay takho ay mangila ya mannge isnan am-in nan angnem. ");
INSERT INTO lbk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Et mo ad-ina kayet chengngen chaicha, ifaagmo isnan kaam-amonganyo ay mamati. Mo ad-ina kayet chengngen chaicha, telachenyo siya ay kag pagano paymo enkorkortais.” ");
INSERT INTO lbk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tet-ewa kanak ken chakayo, ay mo ngag issa nan ipawayo isnan nay ay lota, at maipawa akhes chi id chaya. Ya mo ngag nan ipalofosyo isnan nay ay lota, at siya akhes chi id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Naay kayet nan kanak ken chakayo, ay mo wad-ay chwa ken chakayo isna is kalota ay mayoyomyom nan semekcha ay komchaw isnan ngag issa, at ichowan Ama id chaya ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tay isnan kaam-amongan nan chwa paymo tolo khapo ken sak-en, wad-ay ak ay maitatakcho ken chaicha.” ");
INSERT INTO lbk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sa et sinmag-en si Pedro ken Jesus ay nangwanin, “Apo, mangngat kay ay pakawanek nan ib-ak ay finmasol ken sak-en? Maminpito ngen?” ");
INSERT INTO lbk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kinwanin Jesus, “Ad-ik kanan en maminpito yangkhay, mod-i ket maminpito ay piton poo.” ");
INSERT INTO lbk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Idwani et mampay, mabfalin ay maiyalig nan en-ap-apowan Apo Dios isnan esa'y ali, ay menlayad ay mangonto isnan inpakhawatna isnan cheycha'y takhona. ");
INSERT INTO lbk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nan inmona ay inpaayagna, et nan chey nen-otang ken siya is sinpoo ay lifo ay talenton. ");
INSERT INTO lbk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Idwani tay ad-i kafaelan nan nay ay takhona ay mamayad isnan inotangna, infilin et nan apona ta mailako siya, nan asawana, ya nan an-akna, ta enfalin cha ay faa, sa et akhes nan am-in ay kwana, ta siya nan maifayad isnan otangna. ");
INSERT INTO lbk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sa na't ala ya falintomeng ay nenseg-ang ay nangwanin, ‘Apo, asop ya anosam sak-en, ta at chadlo fayachak am-in nan inotangko ken sik-a.’ ");
INSERT INTO lbk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naseg-ang nan apona, sa na't kinaan am-in nan otangna ya winayaana siya. ");
INSERT INTO lbk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nay met achi osto'y tinaynana nan afong san ali, inchanana't nan ib-ana ay nakaotang is sinkhasot ay denaryo ken siya. Sa na't pen seket ay mangwanin, ‘Ala! Fayacham et nan otangmo ken sak-en!’ ");
INSERT INTO lbk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nenfalintomeng et nan chey ay ib-ana, ay nenseg-ang ken siya ay mangwanin, ‘Asop ya anosam sak-en, ta at chadlo fayachak nan inotangko!’ ");
INSERT INTO lbk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngem inkekedsena kayet, sa na't inpafalod engkhana ay fayachana am-in nan inotangna. ");
INSERT INTO lbk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Idwani issan nangil-an nan ib-ana ay takhon si ali nan am-in ay naangnen, ensakit nan semekcha, ya inmey cha insodsod am-in isnan apocha. ");
INSERT INTO lbk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sa et inpaayag nan apona san chey ay takhona, ya kinwanina, ‘Ngaag ka pet ay takho. Kinaanko am-in nan otangmo tay nenseg-ang ka ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Seg-angam koma akhes achi nan ib-am, ay kag isnan naneg-angak ken sik-a!’ ");
INSERT INTO lbk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Et tay chad-ama nan songet nan apona, ya ke na't nen-ipafalod siya, ta engkhana ay fayachana am-in san otangna.” ");
INSERT INTO lbk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sa et kanan Jesus, “Siya akhes sa nan angnen Ama id chaya isnan waschin esa ken chakayo, mo maid seg-angyo ay mamakawan isnan ib-ayo.” ");
INSERT INTO lbk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kakwasan nan cheycha'y infab-aag Jesus, kinmaan id Galilea ya inmey isnan sakop nan Judea ay chemang nan wanga ay Jordan. ");
INSERT INTO lbk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ya inon-onod nan katakhotakho siya, et inag-akhasana chaicha ischi. ");
INSERT INTO lbk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sa et wad-ay cha nan Fariseo ay sinmag-en ay naneptepeng ken Jesus ay nangwanin, “Ay ipalofos ngen nan lenteg tako ay ichangen nan lalaki nan asawana maipoon isnan ngag sisa'y chomalat?” ");
INSERT INTO lbk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sinmongfat si Jesus ay nangwanin, “Egayyo ngen finasa ay issan laplapona, khinaeb Apo Dios nan takho ay lalaki ya fafai, ");
INSERT INTO lbk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","sa na't kanan, ‘Tay siya sa, masapol ay taynan nan lalaki nan amana ya inana, ta en maiyamong isnan asaw-ena, ta enfalin cha ay esang ay awak’? ");
INSERT INTO lbk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Adi kad, faken cha et chwa mod-i ket es-esang cha. Nan et mampay nen-amongen Apo Dios, maid kalebfengan nan takho ay mangipaichang ken chaicha.” ");
INSERT INTO lbk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sa cha't kinwani ken Jesus, “Mo siya sa, en man infilin Moises ay mo ichangen nan lalaki nan asawana, et khab-ena ona nan kasolatan maipoon isnan en-ichangancha, ta sa na't ipakaan siya mo?” ");
INSERT INTO lbk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kinwanina ken chaicha, “Wen, inpalofos Moises nan mangichanganyo isnan asawayo tay nan kinaweweyo, ngem faken kag tosa issan laplapona. ");
INSERT INTO lbk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kanak ken chakayo: Mo wad-ay lalaki is mangichang isnan asawana ay faken chomalat isnan asi ay inikkana, sa et omasawa is teken, et chwadchwaena nan pantewna.” ");
INSERT INTO lbk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kinwanin et nan cheycha'y disipolosna, “Mo siya sa nan kasasaad pet nan sin-asawa, khagkhag-awis et yangkhay si ad-i ta't omasawa.” ");
INSERT INTO lbk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ket ay kinwanina ken chaicha, “Ad-i kafaelan nan am-in ay takho isnan nay ay sos-olo, kecheng yangkhay nan nangigwalan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tay wad-ay cha nan lallalaki ay ad-i chadlo makaasawa, tay wad-ay kolangcha mailapo isnan naiyanakancha. Wad-ay cha akhes nan lallalaki ay ad-i makaasawa tay napaat cha ay nafitliyan. Sa et wad-ay nan tapina ay linayadcha chadlo ay ad-i omasawa, maigkhapo isnan en-ap-apowan Apo Dios. Mo sino nan makaawat isnan nay ay sos-olo, siya chi ta angnena.” ");
INSERT INTO lbk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sa et wad-ay cha nan tapina ay nangiyey isnan ongang-a ken Jesus ta egnana ya ilowalowana chaicha, ngem sinosonget nan cheycha'y disipolosna chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kinwanin et Jesus, “Ogkhayenyo nan ongang-a ay omali ken sak-en. Ad-iyo ipap-awa chaicha, tay nan kag tosacha ay takho nan maitapi isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Inpatang Jesus nan limana ken chaicha sa et kinmaan. ");
INSERT INTO lbk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Awni ya ket wad-ay nan fab-alo ay inmey nensalodsod ken Jesus ay nangwanin, “Mistolo, ngag nan khawis ay masapol ay angnek ta wad-ay fiyagko Khawis ay maid pengpengna?” ");
INSERT INTO lbk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kinwanin Jesus, “Ngag nan khotok nan manalodsocham ken sak-en maipoon isnan khawis! Maid kasin teken si khawis mod-i yangkhay si Apo Dios. Mo laychem ay maitapi isnan fiyag ay eng-engkhana, angnem nan cheycha'y filina.” ");
INSERT INTO lbk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Ngag ay filin?” kinwanina. Sa et kinwanin Jesus, “Ad-i ka enpatey, ad-im chwadchwaen nan pantewmo, ad-i ka mangakew, ad-i ka en-engag ay enpangaag isnan ib-am. ");
INSERT INTO lbk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Patkhem cha amam ken inam, ya laylaychem nan ib-am ay takho kag isnan menlaycham isnan awakmo.” ");
INSERT INTO lbk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kinwanin et nan chey fab-alo, “Inangnek met am-in chana, ngag kay kayet nan kolangko?” ");
INSERT INTO lbk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sa et kinwanin Jesus ken siya, “Ta maid enkolangam engka ilako nan kwam, ta sam et iwalas nan lakona isnan maid mabfalincha, ya at wad-ay akonmo id chaya. Sa ka't omali ya omonod ka et chadlo ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Issan nanngelan nan chey ay fab-alo isnan infaag Jesus, kinmaan ay nenngongoyos, tay faknafaknang. ");
INSERT INTO lbk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sa et kinwanin Jesus isnan disipolosna, “Tet-ewa kanak ken chakayo, ay sikhab nan somkhepan nan faknang isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kasik kanan ken chakayo, ay malanlanoy et pay nan somkhepan nan kamelio isnan lokaw si kachayom, mo nan somkhepan nan faknang isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Issan nanngelan nan disipolosna isna, nataataa cha ay nangwanin, “Sino mampet nan maisalakan?” ");
INSERT INTO lbk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sa et insisin-eng Jesus chaicha ay nangwanin, “Maid kafaelan nan takho, ngem kafaelan Apo Dios am-in.” ");
INSERT INTO lbk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kanan et Pedro, “Ngag nan maalami, tay nay tinaynanmi nan am-in ta onochenmi sik-a?” ");
INSERT INTO lbk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kinwanin Jesus ken chaicha, “Tet-ewa kanak ken chakayo, isnan mangipafalowan Apo Dios isnan am-iam-in, ya wad-ay ak et ay Anak si Takho isnan matangtangad ay tronok, chakayo ay sinpoo ya chwa ay inmon-onod ken sak-en, at wad-ay kayo akhes isnan sinpoo ya chwa ay tronoyo, ay mangokom isnan sinpoo ya chwa ay tribon Israel. ");
INSERT INTO lbk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tay olay sino ay manaynan isnan afongna, aag-ina, amana, inana, an-akna paymo lotana midkakay ken sak-en, et maminkhasot ay masobfalitan, ya teken kayet nan tawichena ay fiyag ay maid pengpengna. ");
INSERT INTO lbk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngem angsan cha nan omon-ona idwani, ay at enkotit. Ya angsan nan kotit ay at omon-ona.” ");
INSERT INTO lbk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kinwanin kayet Jesus, “Kag tona nan kaiyalikhan nan en-ap-apowan Apo Dios. Kag isnan takho ay namikhat ay en nen-ayag si padnowena isnan omana. ");
INSERT INTO lbk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Et wad-ay cha nan nakitolakhana ay lagfowena isnan sin-es-a ay denaryo nan sin-akhew. Sa na't inpadno chaicha is kaomana. ");
INSERT INTO lbk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kasin finmala isnan alas nowibi, ya ke na't inila nan tapin si lallalaki ay aped entaktakcheg isnan katinchaan. ");
INSERT INTO lbk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sa na't kanan ken chaicha, ‘En kayo akhes is kaomak ay enmadno, et ichowak nan lebfengna ay lagfoyo.’ ");
INSERT INTO lbk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sa cha't inmey. Kasin kayet finmala isnan alas chosi ya isnan alas tris isnan misoyaw, ya siya kayet nan inangnena. ");
INSERT INTO lbk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nganngani ay alas singko ya kasin finmala, ya inilana kayet nan tapina ay aped entaktakcheg. Sa na't kanan ken chaicha, ‘En yo man aped sangsangawen nan akhewyo issa ay?’ ");
INSERT INTO lbk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sefatcha ay nangwanin, ‘Maid mangipadno ken chakami ya!’ Sa na't kanan, ‘En kayo et akhes enchono is kaomak.’ ");
INSERT INTO lbk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Osto pay ay sedsechemna, finilin et san nen-oma nan chey ap-apon nan faana ay nangwanin, ‘Engka ayakhan am-in nan inpadnok is omak ta silchowam chaicha. Ilapom ay manilcho isnan inmod-ochi engkhana isnan inmona.’ ");
INSERT INTO lbk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Et inmali nan cheycha'y naayakhan ay nenmadno isnan alas singko, ya waschin nangala is esa'y denaryo. ");
INSERT INTO lbk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Idwani, issan inmayan akhes nan cheycha'y nang-ona ay nenchono, kananchan mo ad-acha nan chawatencha, nay met achi khechangna'y nasilchowancha is sin-es-a ay denaryo. ");
INSERT INTO lbk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ya ket issan nanawatancha isnan silchocha, nen-amoamoto cha isnan nangipadno ken chaicha, ");
INSERT INTO lbk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ay mangwanin, ‘Ya ke es-esang yangkhay ay olas nan nenchonnan nan cheycha'y inmod-ochi, ya kem et inkis-o nan lagfocha ken chakami, ay nangiyag-akhew ay nablanablay, ya nangikakatpe isnan chad-ama'y atong?’ ");
INSERT INTO lbk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sefatna't ay nangwani isnan esang ken chaicha, ‘Kayong, maid ngaag si inangnek ken sik-a. Ay ke ta egay nentolakhan nan sin-es-a ay denaryo nan sin-akhew? ");
INSERT INTO lbk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Alaem magtek nan lagfom ta omey ka. Tay laychek chadlo ay ichowa isnan naycha'y naod-ochi nan kag isnan inchowak ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ay ke ak ad-i kikhad isnan angnek isnan kwak? Paymo omapar ka ngen tay al-allayad ak ay en-igwa?’ ” ");
INSERT INTO lbk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sa et kinwanin Jesus, “Adi kad nan kotit, at omona cha ya nan omon-ona, at chaicha nan kotit.” ");
INSERT INTO lbk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nenfaat cha Jesus id Jerusalem, ya isnan cha cha manalanan, inik-akna nan sinpoo ya chwa ay disipolosna ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nay manikid tako id Jerusalem, ay at maichawchawak ay Anak si Takho isnan aap-apon si papachi ya nan mimistolo si lenteg. Ya at kedchengancha sak-en ay mangipapatey. ");
INSERT INTO lbk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sa cha't ichowa sak-en isnan Gentil ay mangipaam-amsiw ya mangipasaplisaplit ya mangilansa is kakolos, ya isnan maikatlo ay akhew at maipatakho ak isnan etey.” ");
INSERT INTO lbk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sa et sinmag-en ken Jesus nan asawan Zebedeo ay nangifofoweg isnan an-akna, ya nenfalintomeng isnan sakhangna ay nenseg-ang ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Ngag nan laychem?” kinwanin Jesus. “Apo, mo sa ya ikkalim ta nan naycha'y chwa ay an-akko, et tomokcho cha is kakannawan ya kakannikhidmo isnan enap-apowam.” ");
INSERT INTO lbk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ket ay kinwanin Jesus, “Ad-iyo ammo nan cha yo kedkedchawen. Makaikatpe kayo ngen isnan omali ay chad-ama'y likhatko?” “Wen, makaikatpe kami,” insongfatcha. ");
INSERT INTO lbk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sa na't kinwani ken chaicha, “Tet-ewa, at inaagyo nan chad-ama'y likhat ay kag ken sak-en, ngem faken sak-en nan mangichowa isnan kalebfenganyo ay tomokcho is kakannawanko ya kakannikhidko, tay wad-ay et nan cheycha'y apchas nangisagkhanaan Ama ischi.” ");
INSERT INTO lbk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Osto ay chinngen nan sinpoo ay disipolos nan maipoon sidi, linilikhetcha nan chwa'y sin-akhi. ");
INSERT INTO lbk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Adi kad inayakhan et Jesus chaicha ay nangwanin, “Ammoyo nan okhali nan cheycha'y apop-on si Gentil, palikhatencha nan iyap-apowancha. Olay nan cheycha'y okomcha, et ipip-ilitcha nan kalebfengancha. ");
INSERT INTO lbk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Faken siya sa ken chakayo, mod-i ket mo sino ken chakayo nan menlayad ay enap-apo, et siya koma nan ensilfi ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mo sino nan menlayad ay siya nan katongchowan, siya koma nan mafab-aa, ");
INSERT INTO lbk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ay kag ken sak-en ay Anak si Takho. Egay ak inmali ay masilfiyan, mod-i ket ta ensilfi ak isnan takho, ya ta ichowak nan fiyagko ay mensaka isnan ang-angsan.” ");
INSERT INTO lbk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Issan cha komaanan cha Jesus id Jerico, inon-onod nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Et wad-ay nan chwa ay lalaki ay nakolap, ay nentotokcho is kailit nan chalan. Chinngecha ay lomal-aos si Jesus, ya ke cha't ala ya fokhaw ay nangwanin, “Anak David, seg-angam chakami!” ");
INSERT INTO lbk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yinangyangan nan katakhotakho chaicha ay cha mangipagkhinek, ngem onanig cha kayet nenfokhaw ay nangwanin, “Apo, ay Anak David, seg-angam chakami!” ");
INSERT INTO lbk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tinomke si Jesus sa na't ayakhan chaicha ay nangwanin, “Ngag nan laychenyo ay ikkak ken chakayo?” ");
INSERT INTO lbk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kinwanicha ken siya, “Apo, seg-angam chakami ta makaila kami.” ");
INSERT INTO lbk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naseg-ang si Jesus ken chaicha, ya kinapposna nan matacha, ya ket nakaila cha kannay ya inmonod cha ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Awni pay ya ket nganngani ay omchan et cha Jesus id Jerusalem, ya wad-ay cha isnan ili ay Betfage isnan filig ay Olivo. Sa et finaan Jesus nan chwa ay disipolosna ");
INSERT INTO lbk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ay nangwanin, “En kayo isnan sasakhangenyo ay ili, et ilaenyo kannay ischi nan dangki ya nan anakna ay maitattaked. Fadfachenyo ta yaiyo ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Et mo way mangwani is ngag sisa ken chakayo, kananyo en, ‘Masapol nan Apo chana,’ ya at ipalofosna kannay.” ");
INSERT INTO lbk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Naangnen na ta tomet-ewa san infaag nan mamadto ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ifaagyo isnan iJerusalem en, ‘Naay et ay omal-ali nan Aliyo. Naanos siya ay Ali, ya ensasakay isnan dangki. Wen, ensasakay isnan koyaw, ay anak si dangki.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Inmey et san disipolos Jesus ya inangnencha nan naifilin ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inyaicha nan dangki ya nan anakna, sa cha't inyap-ap nan kakhaycha et nensakay si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Et ang-angsan cha nan nangiyaplag isnan kakhaycha is kachalan. Nan akhes tapina sinmipling cha isnan tofon si kaew, sa cha't inyaplag isnan chalan. ");
INSERT INTO lbk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sa et nan katakhotakho ay namangpango ya inmon-onod ken Jesus, et infogfokhawcha, “Machad-ayaw ka ay Anak ali David! Bindisyonan Apo Dios sik-a ay omali ay mangitakcheg ken siya. Machad-ayaw nan Dios ay Katotongchowan.” ");
INSERT INTO lbk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Osto'y sinomkhep si Jesus id Jerusalem, ya ket nen-al-alifotfot nan omili ay mangwanin, “Sino man na?” ");
INSERT INTO lbk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kinwanin et nan katakhotakho, “Siya na si Jesus ay mamadto ay iNazaret id Galilea.” ");
INSERT INTO lbk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sinomkhep si Jesus is kaawwichan nan Timplo, sa na't ala ya soyog isnan am-in ay wad-ay ischi ay en-ilaklako ya nan cha lomaklako. Finalintowagna nan lamisaan nan cheycha'y ensoksokat si siping, ya nan tokchowan nan cheycha'y en-ilaklako isnan kalopati. ");
INSERT INTO lbk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kinwanina ken chaicha, “Naisolat isnan kalin Apo Dios, ‘Nan afongko, et makwanin afong ay enlol-owalowan,’ ngem khinaebyo ay afong si mangaakew.” ");
INSERT INTO lbk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wad-ay et nan sinmag-en ken Jesus is kaawwichan nan Timplo ay nenkakolap ya nenkapilay, ya inpagkhawisna chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ya ket peteg nan songet nan aap-apon si papachi ya nan mimistolon si lenteg isnan nangil-ancha isnan katataa ay inangnena, ya nan ongang-a ay enfogfokhaw is kaawwichan nan Timplo ay mangmangwanin, “Machad-ayaw ka ay Anak ali David!” ");
INSERT INTO lbk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sa cha't kinwani ken Jesus, “Chechengngem ngen nan kankanan nan naycha?” Sa na't kanan, “Siya. Ay egayyo ngen paat finasa nan naisolat ay nangwanin, ‘Olay isnan topek nan ongang-a ya nan ensossoso, et inchowam nan angnencha'y mangifallikas isnan chayawmo’?” ");
INSERT INTO lbk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sa na't tinaynan chaicha, ya kinmaan isnan ili et inmey id Betania ya inomyan ischi. ");
INSERT INTO lbk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kawiitana tinmoli si Jesus id Jerusalem, ya ket naowat isnan chalan. ");
INSERT INTO lbk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Inilana nan kaew ay higos is kailit nan chalan, sa et sinmag-en ngem maid paat inilana is fekhasna mod-i ket tofona yangkhay nan angsan. Sa na't nenkanan, “Olay kaatna, at ad-i ka kasin mammamkhas!” Ya ket nenkaloloyaw kannay chi. ");
INSERT INTO lbk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Issan nangil-an nan disipolosna isnan chey ay naangnen, nataataa cha ya kinwanicha, “Ngag man nan inangnen nan chey kaew ay higos ay aped nenkaloloyaw?” ");
INSERT INTO lbk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sinmongfat si Jesus ay nangwanin, “Tet-ewa kanak ken chakayo, mo wad-ay pammatiyo ya ad-i kayo enchwadchwa, at faken yangkhay nan inilayo ay naangnen isnan nay kaew ay higos nan mabfalin ay angnenyo, mod-i ket olay pay mo kananyo isnan nay ay filig en, ‘Matan-ang ka ta maibkas ka is kafayfay,’ et siya nan at maikkan. ");
INSERT INTO lbk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mo wad-ay pammatiyo, at chawatenyo nan ngag issa ay kedchawenyo ken Apo Dios isnan enlowalowanyo.” ");
INSERT INTO lbk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tinmoli si Jesus is kaawwichan nan Timplo, ya isnan cha na en-isos-olowan, sinmag-en nan aap-apon si papachi ya nan amam-an si Judio ay nangwani ken siya en, “Ngag nan kalebfengam ay mangik-ikkan isnacha? Sino nan nangichowa isnan nay ay kalebfengam?” ");
INSERT INTO lbk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kinwanin et Jesus ay sinmongfat, “Ensalodsod ak akhes ken chakayo ta songfatanyo. Mo ifaagyo nan songfatna, at ifaagko akhes nan nalpowan nan kalebfengak ay mangangnen isnacha. ");
INSERT INTO lbk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Siya na nan salodsodko: ‘Sino nan nalpowan nan kalebfengan Juan ay mamonyag? Nalpo ngen ken Apo Dios paymo isnan takho?’ ” Sa cha't kanan ay natotya, “Mo kanan tako en, ‘Nalpo ken Apo Dios,’ at kananan, ‘Ya ke yo mampay ad-i patpatiyen siya mo?’ ");
INSERT INTO lbk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngem mo akhes kanan tako en, ‘Nalpo isnan takho,’ omegyat tako met akhes isnan at angnen nan katakhotakho, tay ifilangcha am-in ay mamadto si Juan.” ");
INSERT INTO lbk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Adi kad kinwanicha't ken Jesus, “Ad-imi ammo.” Sinmongfat et akhes si Jesus ay nangwanin, “Ad-ik et akhes ifaag ken chakayo mo ngag nan kalebfengak ay mangangnen isnacha.” ");
INSERT INTO lbk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ngag nan semekyo isna? Wad-ay nan ama ay chwa nan an-akna ay fafallo. Kinwanina isnan yon-a, ‘Anak, en ka is kaofasan ay enchono idwani.’ ");
INSERT INTO lbk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Sefatna't ay nangwanin, ‘Ad-i ak!’ Ngem nawni is akit, ya ket nenfaliw nan semekna ya khechangna'y inmey. ");
INSERT INTO lbk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sa et inmey akhes san ama isnan annochi et en-iso nan kinwanina ken siya. ‘Wen ama, omey ak,’ insongfatna. Nay met achi egay pet inmey. ");
INSERT INTO lbk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Idwani, sino et isnan chwa ay an-akna nan nangangnen isnan laychen amana?” sinalodsod Jesus. Sa cha't kanan, “Nan achi yon-a.” Kinwanin et Jesus ken chaicha, “Tet-ewa kanak ken chakayo, at mamangpango mo chakayo ay omey isnan en-ap-apowan Apo Dios nan cheycha'y enkorkortais ya nan asi ay fabfafai. ");
INSERT INTO lbk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Siya sa tay egayyo pinati nan insos-olon Juan maipoon isnan nalenteg ay angnen ay enfiyag. Ngem nan enkorkortais ya nan asi ay fabfafai, et namati cha isnan infab-aagna. Chakayo, olay issan nangil-anyo isnan inangnencha, egayyo finaliwan nan semekyo ta mamati kayo.” ");
INSERT INTO lbk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Chengngenyo kayet nan nay esa'y al-alig,” kinwanin Jesus. “Wad-ay nan esa'y takho ay nenmola is ofas is kaomana, sa na't inalachan. Khinmaeb akhes is falliwes, sa et nan ab-afong ay entey-an nan enfelew. Sa na't inpasama ya nenfaat isnan teken ay ili. ");
INSERT INTO lbk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Isnan namkhasan nan naimola, finaana nan cheycha'y faana ay en mangala isnan chatagna isnan cheycha'y nangipasamalana. ");
INSERT INTO lbk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nay met achi issan inmayancha, khinoyodcha nan faana, sa cha't finaig nan esang, pinateycha nan esang, ya finaofaogcha nan esang. ");
INSERT INTO lbk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Awni ya ket wad-ay kayet nan finaana ay ang-angsan mo nan inmona, ngem siya kayet chi nan inangnencha. ");
INSERT INTO lbk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Awni pay ya ke na't ifaa nan anakna tay kananan, ‘At chadlo ibfaincha nan anakko.’ ");
INSERT INTO lbk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngem osto'y inilacha ay anakna nan infaana, kanancha't ay natotya, ‘Naay nan at manawid. En tako pateyen ta enkwa tako nan tawidna.’ ");
INSERT INTO lbk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ke cha't nenkhoyakhoy ay nangibkas is kailitna, sa cha't pinatey. ");
INSERT INTO lbk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ad-i kad idwani, ngag et nan angnen nan nenkwa isnan oma isnan cheycha'y nangipasamalana mo omali?” ");
INSERT INTO lbk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Sa cha't kanan, “At kakaegyat nan angnena ay mamatey ken chatod-i ay ngaag ay takho. Sa na't ipasama nan omana isnan teken ay at mangichowa ken siya isnan osto'y chatagna isnan mamkhasana.” ");
INSERT INTO lbk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kinwanin et Jesus ken chaicha, “Ay egayyo ngen paat finasa nan naisolat ay kalin Apo Dios ay mangwanin, ‘Nan chadlos fato ay inad-in nan tomottoping, et siya nan nenfalin ay kapapatekhan ay fato isnan pegnadna. Siya sa nan chonon Apo Dios ya katataa ken chatako.’ ");
INSERT INTO lbk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kanak et mampay ken chakayo: Siya chi nan chomalat isnan maikaanan nan en-ap-apowan Apo Dios ken chakayo, ya maichowa isnan ili ay mangipafala isnan osto ay fekhasna. ");
INSERT INTO lbk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Et mo sino nan mekchag isnan nay ay fato, at mamekmek. Ya mo sino nan mekchakhan nan nay ay fato, at matomek.)” ");
INSERT INTO lbk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chinngen nan aap-apon si papachi ya nan Fafariseo nan al-alig Jesus, et ammocha ay chaicha nan kankanana. ");
INSERT INTO lbk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ad-i pay inanapcha nan ikkancha'y maniliw ken siya, ngem omegyat cha'y mangikkan tay infilang nan katakhotakho siya ay mamadto. ");
INSERT INTO lbk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Inyal-alig kayet Jesus isnan katakhotakho ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nan en-ap-apowan Apo Dios, et kag isnan esa'y ali ay nangipachomno isnan anakna ay lalaki. ");
INSERT INTO lbk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Idwani, finaana nan cheycha'y faana ay en-awil, nay met achi nan cheycha'y naayakhan, nen-ad-i cha. ");
INSERT INTO lbk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kasin kayet finmaa is teken ay faana ay mangwani ken chaicha en, ‘Ifaagyo isnan cheycha'y naayakhan ay nakhekhed et nan fakak ya nan alaalarmes ay paamok, et naisakhana et am-in. Kananyo et ta omali cha'y makichomno.’ ");
INSERT INTO lbk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nay met achi inog-okhay nan naayakhan, ya waschin et inmey isnan omayana. Wad-ay nan esang ay inmey nangoma, ya nan esang inmey nenkomerso. ");
INSERT INTO lbk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nan tapina kayet, khinoyodcha nan cheycha'y faa, sa cha't inisiisik ya pinateycha chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chad-ama et nan songet nan chey ali, sa na't ala ya fetad isnan kasorchasorchachona ay en mamatey isnan cheycha'y nenpatey, ya sa cha't pinoowan nan ilicha. ");
INSERT INTO lbk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sa na't kinwani isnan cheycha'y faana, ‘Nay nanongnong et nan am-in isnan chomno, ngem nan cheycha'y naayakhan et ad-i cha pet maikali. ");
INSERT INTO lbk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","En kayo et issacha is kachalan, ta awisenyo nan olay sino ay ilaenyo ta omali cha'y makichomno. ");
INSERT INTO lbk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sa et inmey nan cheycha'y faa is kachalan ya inayakhancha nan olay sino ay inilacha, ngaag ya khawis ay takho, et napno nan chomnowan isnan makichomno. ");
INSERT INTO lbk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nay met achi issan inmayan nan ali ay nanam-aw isnan cheycha'y nadkat, inilana't nan esa'y lalaki ay egay nenfacho isnan maifakhay isnan chomno. ");
INSERT INTO lbk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kinwanina et ken siya, ‘Anen, ngag nan inangnem ay aped nakaskhep isna ay egay nenfacho isnan maifakhay isnan chomno?’ Sa et egay nakakkali nan chey ay takho. ");
INSERT INTO lbk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nenkanan et nan ali isnan cheycha'y faana, ‘Takchenyo nan lima ya sikina ta ibkasyo is kaab-afollinget ay kawad nan ngegngeg ya kaletket si fab-a.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sa et kinwanin Jesus, “Siya sa, tay angsan tet-ewa nan naayakhan, ngem akit cha yangkhay nan napili.” ");
INSERT INTO lbk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Sa et kinmaan nan Fafariseo ay en natotya, mo ento nan ikkancha ay mensikap ay maniliw ken Jesus isnan kankanana. ");
INSERT INTO lbk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sa cha't inpaeey ken Jesus nan disipoloscha ya nan tapina ay makwanin Herodiano, ta en cha ifaag ken Jesus nan kag tona: “Mistolo, ammomi ay osto ka, ya tet-ewa ay isos-olom nan okhali ay laychen Apo Dios. Ad-i ka mangiyoya isnan kankanan nan takho, ya maid pawadwad-em tay faken nan wad-ay isnan takho nan il-ilaem. ");
INSERT INTO lbk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ibfakham ed ken chakami nan semekmo isnan tona: ipalofos ngen nan lenteg tako'y Judio nan enfayachan isnan fowis ken Cesar, paymo ad-i?” ");
INSERT INTO lbk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Si Jesus magtek ammona et nan sikapcha. Sa na't kanan, “Kakas-okas-on kayo! Ya ke kayo chadlos pomadpachas/tomeptepeng ay? ");
INSERT INTO lbk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipailayo nan siping ay ifab-ayadyo isnan fowis.” Sa cha't inyey ken siya nan siping. ");
INSERT INTO lbk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sa na't kanan, “Sino nan nenkames ya nenngachan isnan wad-ay isna?” ");
INSERT INTO lbk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Si Cesar,” kinwanicha. Sa na't kanan, “Ichowayo et mampay ken Cesar nan lebfengna'y enkwa, ya ken Apo Dios nan lebfengna akhes ay enkwa.” ");
INSERT INTO lbk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ya ke cha't nataataa issan nanngelancha ischi. Sa cha't kinmaan. ");
INSERT INTO lbk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Issan siya chi kannay ay akhew inmey nan cheycha'y makwanin Saduceo, ay en nangila akhes ken Jesus. (Chaicha nan ad-i mamati isnan kasin matakhowan nan matey.) Nensalodsodcha ken Jesus ay ");
INSERT INTO lbk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","nangwanin, “Mistolo, wad-ay san kinwanin Moises issan chey ay, ‘Mo nan esa'y lalaki ya matey ay maid anakna, masapol ay asawaen nan akhina nan chey ay nailekkasan, ta enpawad-ay is anak nan akhina ay natey.’ ");
INSERT INTO lbk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Idwani, wad-ay isna ay ilimi nan pito ay sin-ag-i ay lallalaki. Inmasawa nan inaona, ya ket natey ay maid winad-ayna. Ket ay siya kayet nan naangnen isnan misned ay lalaki ay nangasawa isnan chey ay nailekkasan, ");
INSERT INTO lbk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ya olay isnan ikatlo engkhana isnan ikapito. ");
INSERT INTO lbk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Awni pay ya ket natey akhes nan chey ay nailekkasan. ");
INSERT INTO lbk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Idwani isnan chey ay akhew ay kasin matakhowan nan natey, sino et isnan pito nan osto ay asawana? Tay inasawacha am-in siya!” ");
INSERT INTO lbk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sinomfat si Jesus ay nangwanin, “Nenkammali kayo, tay ad-iyo ammo nan kalin Apo Dios paymo nan kamabfalina. ");
INSERT INTO lbk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tay isnan kasin matakhowan nan natey, at maid maasaswa paymo maipaasawa, mod-i ket kag cha isnan angheles id chaya. ");
INSERT INTO lbk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ya mo maipoon isnan matakhowan nan natey, egayyo ngen finasa nan kinwanin Apo Dios ken chakayo? Kinwanina, ");
INSERT INTO lbk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sak-en nan Dios cha Abraham, Isaac, ya Jacob.’ Laychena'y kanan en faken siya nan Dios si natey, mod-i ket Dios si matatakho.” ");
INSERT INTO lbk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Issan nanngelan nan katakhotakho isnan chey, nataataa cha isnan chey ay sos-olona. ");
INSERT INTO lbk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Issan magtek nanngelan nan Fafariseo isnan nangipabtokhan Jesus isnan cheycha'y Saduceo, nakhog-oy cha't ay inmey akhes ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sa et tineptepeng nan esa'y mistolon si lenteg ay ib-acha si Jesus ay nensalodsod ken siya, ");
INSERT INTO lbk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mistolo, ngag nan kapapatekhan ay filin isnan lenteg?” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sinfat et Jesus ay nangwanin, “Masapol ay laylaychem nan Apo ay Diosmo isnan am-in ay wad-ay ken sik-a: nan posom, nan leng-agmo, ya nan semekmo. ");
INSERT INTO lbk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Siya na nan kapapatekhan ya kawedwedchaan ay filin. ");
INSERT INTO lbk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nan ikadwa ay kapapatekhan ay filin et kag isnan inmona, ‘Masapol ay laylaychem nan ib-am ay takho ay kag isnan menlaycham isnan awakmo.’ ");
INSERT INTO lbk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nan nay ay chwa ay filin, siya nan malpowan nan am-in ay lenteg ya nan insos-olon nan cheycha'y mamadto.” ");
INSERT INTO lbk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Idwani, issan sisya'y naaamongan nan cheycha'y Fariseo, nensalodsod si Jesus ken chaicha ay ");
INSERT INTO lbk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","nangwanin, “Ngag nan semekyo maipoon isnan Cristo? Sino ay kaapo nan kalpowana?” “Isnan waned David,” insongfatcha. ");
INSERT INTO lbk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ya ket kinwanina ken chaicha, “Mo siya sa, ento kayet nan inangnen nan Ispirito Santo ay nangischo ken David ay mangwani isnan Cristo en, Apo? Tay kinwanin David, ");
INSERT INTO lbk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kinwanin nan Dios Apo isnan Apok en, “Itokchom is kakannawanko engkhana ay ippeyko nan fosom ay enkhatkhatinam.” ’ ");
INSERT INTO lbk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Idwanin, mo Apo nan kinwanin David ken siya ay Cristo, ngag kay nan ikkana ay anak David siya?” ");
INSERT INTO lbk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Et maid paat nakaskasfat ken Jesus. Ya engkhana ischi ay akhew maid nakatoled ay nensalodsod ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sa et infaag Jesus isnan katakhotakho ya isnan cheycha'y disipolosna, ");
INSERT INTO lbk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nan mimistolon si lenteg ya nan Fafariseo, et wad-ay nan kalebfengancha ay mangilawag isnan lenteg Moises. ");
INSERT INTO lbk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Adi kad masapol ay ton-ochenyo ya iyangnenyo am-in nan ifaagcha ken chakayo, ngem ad-iyo tonton-ochen nan okhalicha, tay ad-icha iyangnen nan isos-olocha. ");
INSERT INTO lbk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Takchetakchencha nan ad-acham-et ay awit, ay ipasakfatcha isnan ib-acha'y takho, ngem ad-icha paat oyachen nan olay esa'y lechengcha'y mamachang ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Am-in ay ang-angnencha et angnencha yangkhay ta fob-oyaen si takho chaicha, kag isnan chey maitaktaked isnan lima ya kitong ay mangig-igtowan isnan naisolat ay lenteg. Paatencha'y mangipaanwa ta maiila, ya paanchoanchowencha akhes nan ipay nan fachocha. ");
INSERT INTO lbk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sa et mo maayakhan cha ay makikan, laychencha'y maichayaw isnan kakhawisan ay tokchowan, ya siya akhes is kasinagoga. ");
INSERT INTO lbk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Laychencha ay maichad-ayaw is kamarkitan, ya laychencha akhes ay makmakwani en Mistolo. ");
INSERT INTO lbk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ken chakayo magtek, ad-iyo itan-oy nan mangwaniyan nan takho en Mistolo ken chakayo. Tay masin-ag-i kayo am-in, ya esang yangkhay nan Mistoloyo. ");
INSERT INTO lbk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ad-iyo kankanan en Ama isnan olay sino ay takho isnan nay lota. Tay esang yangkhay nan Amayo, et siya nan Entotongcho ay wad-ay ad chaya. ");
INSERT INTO lbk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ad-iyo akhes ipalofos ay kanancha en Apo ken chakayo. Tay es-esang nan Apoyo ay siya nan Cristo. ");
INSERT INTO lbk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nan mangifan-ig isnan awakna ay enpafab-aa ken chakayo, et siya nan katongchowan ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ya mo sino nan mangipatongcho isnan awakna, at maifan-ig siya. Ya mo sino nan mangibfafan-ig isnan awakna, at maipatongcho.” ");
INSERT INTO lbk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Selaeg yo ay mimistolon si lenteg ya chakayo ay Fariseo! Kas-okas-on kayo! Tay ipawayo nan somkhepan nan takho isnan en-ap-apowan Apo Dios. Ad-i kayo somkhep ischi ya ipawayo akhes nan cheycha'y cha koma somkhep. ( ");
INSERT INTO lbk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Selaeg yo ay mimistolon si lenteg ya Fafariseo! Kakas-okas-on kayo! Maid ad-iyo angnen ay en mensikasikap isnan cheycha'y nailekkasan ta mangal-anyo isnan afongcha. Sa yo't anchoanchowen nan lowaloyo ta mafob-oya kayo. Tay siya sa at kadchacham-etan nan chosayo!) ");
INSERT INTO lbk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Selaeg yo, chakayo ay mistolon si lenteg ya Fariseo! Kakas-okas-on kayo! Khedchangenyo nan fayfay, ya faatenyo nan kailiili ay en men-awiawis is olay esa's endisipolosyo. Maifakhay kayo ay omey id inferno, ya mo wad-ay naawis, khab-enyo et chaicha ay am-amed maifakhay ay omey id inferno. ");
INSERT INTO lbk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Selaeg yo kayet ay kag isnan nakolap ay mangipango isnan ib-ana, tay kananyo ay mo nan esa'y takho et ensapata ay maichalan isnan Timplo, et ad-i fali chi. Ngem mo maichalan isnan fallitok nan Timplo, kananyo et en masapol ay angnena ay angnen nan insapatana. ");
INSERT INTO lbk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Chakayo ay nalewlew ay kag nakolap! Ay ke wadwad-ay nan fallitok nan Timplo mo nan chey Timplo kannay, ay nangipasanto isnan fallitok? ");
INSERT INTO lbk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kananyo pay kayet ay mo wad-ay takho ay ensapata ay maichalan isnan altar, et ad-i fali chi. Ngem mo ensapata ay maichalan isnan naichoo ay nailayad ischi, et masapol ay angnena ay angnen nan insapatana. ");
INSERT INTO lbk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Chakayo ay nakolap! Ay ke wadwad-ay nan naichoo ay nailayad, mo nan altar ay nangipasanto ischicha? ");
INSERT INTO lbk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Idwani et mampay, mo sino nan ensapata ay maichalan isnan altar, siya akhes ay nensapata isnan am-in ay wad-ay ischi. ");
INSERT INTO lbk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ya mo sino akhes nan ensapata isnan Timplo, siya akhes ay nensapata kannay ken Apo Dios ay entetee ischi. ");
INSERT INTO lbk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ya mo sino nan ensapata isnan chaya, siya akhes ay ensapata isnan tronon Apo Dios, ya ken Apo Dios kannay ay tomotokcho ischi. ");
INSERT INTO lbk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Selaeg yo, chakayo ay mistolon si lenteg ya Fariseo! Kakas-okas-on kayo! Khawis tay ichowayo olay nan pagkapoon nan am-in ay ilan si likacho ay aniyenyo, ngem nenkammali kayo tay iwayangyo nan napatpateg ay lenteg, tay ad-i nalenteg nan ikkanyo ay en-okom, maid seg-angyo, ya ad-i kayo katatalek. Mang-ona koma chana ay angnenyo, esa pay nan tapina. ");
INSERT INTO lbk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kag kayo nakolap ay mangipangpango isnan ib-ayo. Pawadwad-ayenyo nan enyap-ew ay lenteg, ngem iwayangyo nan chadlos napateg ay lenteg. ");
INSERT INTO lbk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Selaeg yo ay mistolon si lenteg ya chakayo ay Fariseo! Kakas-okas-on kayo! Maiyalig kayo isnan tasa ya palato. Chalochalosanyo nan falana ya ke pet nalokhilokhit nan chaemna tay tokong ya oklong nan wad-ay. ");
INSERT INTO lbk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Chakayo ay Fariseo ay kag nakolap, chalosanyo nan chaem nan tasa ya palato, ya at machalosan nan ngonon, maitapi nan falana. ");
INSERT INTO lbk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Selaeg yo ay mistolon si lenteg ya chakayo ay Fariseo! Kakas-okas-on kayo! Tay kag kayo tongon pantiyong ay napintolan is enpokaw, ay khag-awis nan foyana isnan falana, ngem nan chaemna et napno is ingit si natey ya nan isyangkhay ay ilan si lokhit. ");
INSERT INTO lbk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Siya akhes ken chakayo. Kas-on kayo nalenteg isnan falana, ngem isnan chaemna, et ngaag kayo ya kakas-okas-on kayo yangkhay.” ");
INSERT INTO lbk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Selaeg yo ay mistolon si lenteg ya Fariseo! Kas-okas-on kayo! Tay khab-enyo nan pantiyong nan cheycha'y mamadto, sa yo't en arkoarkosan nan liyang ay naipay-an nan napatey ay nenkalenteg ay takho. ");
INSERT INTO lbk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ya kankananyo, ‘Mo sa ya wad-ay kami issan timpon san ikik-itmi, et egay kami naitachon ken chaicha ay namatey isnan cheycha ay mamadto.’ ");
INSERT INTO lbk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ilaenyo! Isnan apatyo kannay ay sana, et cha yo kannay wenwenan ay chakayo nan an-ak nan cheycha'y namatpatey isnan mamadton Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Engkayo't achi ikwas chadlo nan ngaag ay inlapon nan ikik-ityo. ");
INSERT INTO lbk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Chakayo ay nasisikap ay kag oweg. Wen, an-ak kayo is oweg! Ay ke kayo sa makakasiw isnan madchosaanyo id inferno? ");
INSERT INTO lbk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Siya sa nan khapona ay at faalek ken chakayo nan cheycha'y mamadto, ya nan mamasilib ay takho, ya nan mangisolo ken chakayo, ya at pateyenyo nan tapina ya ilansayo is kakolos nan tapina, sa yo't akhes saplisapliten nan tapina is kasinagogayo, ya pakaanenyo chaicha isnan olay entona ay ili ay omayancha. ");
INSERT INTO lbk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Khapo tay siya sa, at machosa kayo maipoon nan napateyan nan am-in ay nalenteg ay takho isnan nay ay lota, mailapo ken Abel ay nalenteg ay takho, engkhana ken Zacarias ay anak Barakias, ay pinateyyo isnan nenfet-akan nan Timplo ya nan altar. ");
INSERT INTO lbk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tet-ewa kanak, chakayo ay wad-ay idwani nan machosa ay machosa khapo isnan am-in ay cheycha ay naang-angnen.” ");
INSERT INTO lbk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Chakayo ay iJerusalem, aped yo pateyen nan cheycha'y mamadto ya faokhenyo nan infaan Apo Dios ken chakayo! Nangngat chadlo ay laychek ay yomyomen chakayo, ay kag nan angnen nan mangalak ay mensakoong isnan impasna, ngem inmad-i kayo! ");
INSERT INTO lbk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Idwani, kikhad kayo et tay chey, inwayang Apo Dios nan kawadyo. ");
INSERT INTO lbk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tay kanak ken chakayo, at ad-iyo kasin il-ilaen sak-en, engkhana ay sok-ed yo kanan en, ‘Machad-ayaw nan omali ay finaan Apo Dios ya mangitakcheg ken siya.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tinaynan Jesus nan Timplo ya issan cha na komaanan sinmag-en nan cheycha'y disipolosna ay mangipaila ken siya isnan khag-awis ay foyan nan nateketeken ay afong ay tapin nan Timplo. ");
INSERT INTO lbk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ya ket kinwanin Jesus ken chaicha, “Siya man, isin-engyo kayet! Tet-ewa kanak ken chakayo, at maid paat olay esang is entotoon ay fato tay at maikoob cha am-iam-in.” ");
INSERT INTO lbk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nawni ya ket isnan tomotokchowan Jesus isnan filig ay makwani en Olivo, nakekecheng nan cheycha'y disipolosna ay sinmag-en ken siya, sa cha't kanan, “Ibfakham ed ken chakami mo kaatna nan sa kaommatan nan sanacha. Ngag nan kaimatonan nan kasim omaliyan ya nan mapengpengan nan lofong?” ");
INSERT INTO lbk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sa et kanan Jesus, “Ilaenyo mampay ta ad-i kayo masas-ailowan. ");
INSERT INTO lbk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tay at angsan cha nan fomala ay mangosar isnan ngachanko ay Cristo ay cha mangwanin, ‘Sak-en nan Cristo,’ ya at angsan nan sailowancha. ");
INSERT INTO lbk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Awni't chengngenyo nan ensag-en ay khofat ya nan chamag maipoon isnan khofat ay wad-ay isnan ad-adchawi. Ngem ilaenyo ta ad-i kayo omeg-egyat, tay siya chadlo sa nan maangnen ay maangnen, ngem faken kayet sa nan mapengpengan nan lofong. ");
INSERT INTO lbk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tay at enfifinnaloknit ona nan kailiili, ya enkhogkhofat cha nan kaaliali, ya at wad-ay nan fitil ya nan yekha isnan olay entona ay lota. ");
INSERT INTO lbk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Et siya am-in chasa nan omat, ay kag isnan lapon nan ensikhafan nan fafai ay omaanak. ");
INSERT INTO lbk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sa cha't alaen chakayo ay en mangipap-alikhat is kaokom. Sa cha't pateyen nan tapina ken chakayo. Et ligten nan takho isnan olay entona ay ili chakayo, midkakay ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sa et angsan nan mangipeg-an isnan pammaticha. Ya nan esang, at en na itiktik nan ib-ana ay mamati, ya at enlilinnikhet cha. ");
INSERT INTO lbk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Angsan akhes nan fomala ay ad-i tet-ewa ay mamadto, ay manailo isnan angsan ay takho. ");
INSERT INTO lbk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Et mampay tay kag tosa ay cha et omam-amed ngomaag nan katakhotakho, angsan cha nan tomamnay nan layadna isnan ib-ana. ");
INSERT INTO lbk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngem mo sino magtek nan makakatpe engkhana isnan omochi, et siya chadlo nan maisalakan. ");
INSERT INTO lbk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nan nay ay khawis ay okhod maipoon isnan en-ap-apowan Apo Dios isnan takho, et maipalawag isnan am-in ay ili isnan lofong, ta chengngen nan am-in ay takho nan tet-ewa, esa chadlo mapengpeng nan lofong.” ");
INSERT INTO lbk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“At ilaenyo nan kafokkawan nan nasantowan ay kawad Apo Dios khapo isnan kakkaisiw ay sinomkhep ischi, ay kag isnan kinwanin nan mamadto ay si Daniel ay maangnen. (Chakayo ay mamasa isna, et maawatanyo koma na.) ");
INSERT INTO lbk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sa et chakayo ay wad-ay isna id Judea, lomayaw kayo is kafilig. ");
INSERT INTO lbk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nan wad-ay is kaatep nan afongna, ad-i koma kasin khomwab ay en mangilayaw isnan wad-ay isnan afongna. ");
INSERT INTO lbk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ya nan namoknag, ad-i kasin somaa ay en mangilayaw isnan nataynan ay fachona. ");
INSERT INTO lbk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Selaeg nan cheycha'y maliton ya nan enpasoso isnan tosacha ay akhew! ");
INSERT INTO lbk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ilol-owaloyo et mampay ta nan enfakwitanyo, et ad-i maigkhisan isnan lemlem paymo isnan tengaw. ");
INSERT INTO lbk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tay siya chasa ay akhew nan kaommatan nan likhat ay eg-ay kaila engkhana issan lapon nan lofong engkhana idwani. Et olay kaatna, at ad-i kasin maangnen nan kag tona. ");
INSERT INTO lbk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Si Apo Dios, inaptikna nan filang nan cha omali ay akhew khapo isnan takhona ay pinilina. Tay mo ad-i, at maid paat makhayad si matatakho. ");
INSERT INTO lbk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sa et mo wad-ay mangwani ken chakayo en, ‘Chey, naay et nan Cristo!’ paymo kananchan, ‘Chey, wad-ay siya ischi!’ ad-iyo patpatiyen. ");
INSERT INTO lbk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tay at wad-ay cha ay wad-ay nan fomala ay ad-i tet-ewa ay Cristo, ya nan ad-i tet-ewa ay mamadto, ya en-ipaila cha is mafob-oya ay maton ya katataa, ta mo mabfalin et masailowan olay pay nan takhon Apo Dios ay pinilina. ");
INSERT INTO lbk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Chey ilaenyo, tay nay fagfag-ak ona chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Et mampay mo kananchan, ‘Wad-ay siya is kamalalango ay ponchag!’ ad-i kayo omey. Mo kananchan, ‘Wad-ay ay entabtafon!’ ad-iyo patpatiyen. ");
INSERT INTO lbk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tay nan omaliyak ay Anak si Takho, et kag isnan koryapyap ay malpo's falaan si akhew ay menlanglang engkhana isnan kalonokhana. ");
INSERT INTO lbk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kag akhes isnan nay, mo ento nan kawad nan naisaad ay awak, ischi nan maam-amongan nan kalafalafaan.” ");
INSERT INTO lbk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kakwasan kannay nan naycha ay kalilikhatan ay timpo, at mamaid nan silaw nan akhew. Nan fowan et mamaid nan langlangna, ya mekchag cha nan tokwifi. Ya at maid manongnong isnan wad-ay id tongcho tay at maiwegwewegweg cha. ");
INSERT INTO lbk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sa et maila id chaya nan matonko ay Anak si Takho, ya at enngegngeg nan am-in ay takho isnan lota, sa cha't ilaen sak-en ay Anak si Takho ay omal-ali isnan lifoo isnan kamabfalinko ya nan chadlos ay kinalanglang nan chayawko. ");
INSERT INTO lbk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Et isnan khanges nan trompeta, at ifaak nan anghelesko isnan olay entona isnan lofong, ta en cha amongen nan pinilin Apo Dios ay takhona isnan olay entona issa ay kawadcha.” ");
INSERT INTO lbk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Sesemkenyo nan wad-ay ay maachar isnan kaew ay makwanin higos. Mo chakhos somingi ya fomala nan tofona, ammoyo ay nganngani et nan chakhon. ");
INSERT INTO lbk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kag akhes mo ilaenyo ay maang-angnen am-in chana, ammoyo et ay nganngani nan omaliyak, ay kag ak et wad-ay is kapantew. ");
INSERT INTO lbk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tet-ewa kanak ken chakayo, at maangnen ay maangnen ona am-in chana esa pay mal-os nan takho ay wad-ay idwani. ");
INSERT INTO lbk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mamaid nan chaya ya nan lota, ngem nan kankanak et sisya is eng-engkhana ya ad-i enfab-aliw.” ");
INSERT INTO lbk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kinwanin kayet Jesus, “Ngem mo maipoon isnan omchanan nan chey ay akhew paymo olas, et maid mangammo, olay pay nan angheles id chaya paymo sak-en ay Anak, tay nan Dios Ama yangkhay nan mangammo ischi. ");
INSERT INTO lbk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nan kasik omaliyan ay Anak si Takho et kag isnan inmat isnan timpon Noe. ");
INSERT INTO lbk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tay issan chey ay timpo, ay sisya'y egay nalifokhan nan lota, cha cha mangmangan ya omin-inom nan takho ya cha cha maasaswa, engkhana isnan chey kannay ay akhew ay sinomkhepan cha Noe isnan chakchakowag ay fangka. ");
INSERT INTO lbk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tay maid semsemekcha isnan at maangnen, engkhana ay naanali nan lifog ay nangiyanod am-in ken chaicha. Siya akhes sa nan kasasaad nan takho isnan omaliyak ay Anak si Takho. ");
INSERT INTO lbk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","At wad-ay isnan chey ay timpo nan chwa ay lalaki ay cha ensama, ya at menkaaala nan esang ya makhayad nan esang. ");
INSERT INTO lbk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","At wad-ay akhes enkhig-iling ay chwa ay fafai, ya ket menkaaala nan esang ya makhayad nan esang. ");
INSERT INTO lbk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tay siya chi masapol ay ensasakhana kayo, tay ad-iyo ammo nan akhew ay omaliyan kasin nan Apoyo. ");
INSERT INTO lbk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sesemkenyo na: mo nan nenkwa isnan afong ya aammona mo ngag ay olas isnan lafi nan omchanan nan mangaakew is afongna, at ad-i maseyep ay manokkhong isnan afongna, ta ad-i maskhep. ");
INSERT INTO lbk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tay siya sa, masapol ay kad-in kayo ensasakhana, tay at omali ak ay Anak si Takho isnan olas ay ad-iyo ammo.” ");
INSERT INTO lbk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Sino et mampay nan makwani en katatalek ya masilib ay faa? Siya nan ippey nan apona ay mangila isnan kafaafaana, ya mangichowa isnan chatagcha isnan osto ay timpo. ");
INSERT INTO lbk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Naoney nan chey faa ay mo somaa nan apona et edchanana siya ay okhay ay cha manno isnan chonona. ");
INSERT INTO lbk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tet-ewa kanak ken chakayo, at ippey nan apona siya ay mangila isnan am-in ay kok-owana. ");
INSERT INTO lbk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngem mo ngaag siya ay faa, at kanana isnan semekna, ‘A, mawni pet nan apok,’ ");
INSERT INTO lbk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ya ke na't ala ya faifaig isnan ib-ana ay faa, ya en et yangkhay makikkikan ya makifotfoteng. ");
INSERT INTO lbk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Anono et ya naanali nan apona isnan akhew ay ad-ina ammo, ya isnan olas ay ad-ina am-ammo. ");
INSERT INTO lbk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Et siya chi nan chad-ama ay manosaan nan apona, sa na't iwasit siya ay maitapi isnan kakas-okas-on isnan kawad nan ngegngeg ya kaletket si fab-a.” ");
INSERT INTO lbk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nan maitapiyan isnan en-ap-apowan Apo Dios isnan omochi, et maiyalig isnan sinpoo ay mamagkit ay waschin inmala is silawna ta encha abten nan kaab-afong ay lalaki. ");
INSERT INTO lbk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima ken chaicha nan masilib, ya lima nan ad-i ensemsemek. ");
INSERT INTO lbk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nan cheycha'y ad-i ensemsemek, inawitcha nan silawcha, nay met achi maid intakincha is tapin nan lana ay maosar isnan silawcha. ");
INSERT INTO lbk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nan magtek cheycha'y masilib, nen-itakin cha is mafobfotilya ay lana pala isnan silawcha. ");
INSERT INTO lbk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Idwani, khapo tay chadlos inmannong nan sadsad-encha ay kaab-afong, naitom-e cha engkhana ay naseyep cha. ");
INSERT INTO lbk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tengan et si lafi nan nafalakhaancha isnan cha enfokhaw ay mangwanin, ‘Naay et nan kaab-afong ay lalaki! Ali kayo ta abtenyo siya!’ ");
INSERT INTO lbk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Naneng cha't ya ligwat san sinpoo ay mamagkit, ya waschin nangisakhana isnan silawna. ");
INSERT INTO lbk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nenkanan et nan cheycha'y ad-i ensemsemek en, ‘Omagtan kayo man is lana tay nay maad-achep nan silawmi,’ kinwanicha isnan masilib ay kakadwacha. ");
INSERT INTO lbk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sinmongfat et san cheycha'y masilib ay nangwanin, ‘En kayo't yangkhay lomako, tay ta ket lang ya ad-i omanay is osalen tako am-in.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ala cha't ya eey, ya issan nal-osancha, naanali et san kaab-afong ay lalaki, et siya chi ay nan cheycha'y nensasakhana, chaicha et nan nakiskhep ken siya ay nakikan. Sa et naifoti nan eneb. ");
INSERT INTO lbk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Awni ya ket wad-ay akhes san cheycha'y mamagkit ay mangwanin, ‘Apo, tekwafam nan eneb tay naay kami.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngem ket ay kinwanin nan kaab-afong en, ‘Ay kek ammo chakayo?’ ” ");
INSERT INTO lbk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sa et kinwanin Jesus, “Ensasakhana kayo et mampay tay ad-iyo ammo nan akhew paymo olas ay omaliyak.” ");
INSERT INTO lbk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Maiyalig kayet nan en-ap-apowan Apo Dios isnan takho ay nganngani ay enfaat. Issan osto ay komaanana, inayakhana nan cheycha'y faana, ya intalekna ken chaicha nan sipingna. ");
INSERT INTO lbk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Inwalasna nan sipingna isnan waschin esang ay maifakhay isnan kafaelana. Inchowana nan liman lifo isnan esang, chwa'y lifo isnan esang, ya esa'y lifo isnan esang. Sa et kinmaan ay enfaat. ");
INSERT INTO lbk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Idwani, nan chey faa ay nanawat issan liman lifo, inmey kannay ay nangikomerso isnan siping, ya ket nenpidwa nan kaad-achana. ");
INSERT INTO lbk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Siya akhes chi nan inangnen nan naagtan si chwa'y lifo, pinidwana nan kaad-achan nan sipingna. ");
INSERT INTO lbk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngem san faa ay nanawat isnan sinlifo, et en na inkaob nan siping nan apona. ");
INSERT INTO lbk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Osto'y nawnawni sinmaa nan apocha ya ninongnongna nan sipingna ay inpaegnana isnan cheycha'y faana. ");
INSERT INTO lbk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Inmona ay inmey ken siya nan faa ay nanawat isnan liman lifo, ya inyeyna nan sinpoo ay lifo. Sa na't kanan, ‘Naay apo nan liman lifom, ya nan liman lifo akhes ay anakna.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Sa et kanan nan apona, ‘Khawis nan inangnem. Khawis ya katatalek ka ay faa. Idwani tay matalek ka isnan olay akit, nay et italekko ken sik-a nan ad-ad-acha kayet. Omali ka ta makilaglagsak ka ken sak-en.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Sa et inmey akhes nan faa ay naagtan si chwa'y lifo, sa na't kanan, ‘Naay apo nan chwa'y lifom ay pinidwak nan kaad-achana.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Sa et kanan nan apona, ‘Khawis nan inangnem. Khawis ya kaaafolot ka ay faa. Idwani tay matalek ka isnan olay akit, nay et ipaegnanko ken sik-a nan ad-ad-acha kayet. Omali ka ta makilaglagsak ka ken sak-en.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Isnan omochi, inmey nan faa ay nanawat isnan sinlifo, sa na't kanan, ‘Apo, ammok ay sikhab ka ay takho, tay aniyem nan egaymo inmola, ya pokhasem nan egaymo inyesek. ");
INSERT INTO lbk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Khapo tay siya sa, nay et inmegyat ak, sak et en inkaob nan sipingmo. Nay et chadlo isoblik nan osto ay sipingmo.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Sa et nenkanan nan apona, ‘Ngaag ka ya sangaan ka ay faa! Siya sa pet ay ammom ay aniyek nan egayko inmola, ya pokhasek nan egayko inis-ek ");
INSERT INTO lbk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ya egaymo et yangkhay inyey is kabangko, ta isnan nay ay sinmaalak ya alaek nan sipingko ya nan porsintona?’ ");
INSERT INTO lbk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sa na't kanan, ‘Alaenyo et nan siping ken siya, ta ichowayo isnan faa ay kawad nan sinpoo ay lifo. ");
INSERT INTO lbk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tay mo sino nan mangidno isnan wad-ay ken siya, at maagtan kayet ta onanig omad-acha nan wad-ay ken siya. Ngem nan maiyalig ay maid mabfalina ay ad-i mangidno isnan wad-ay ken siya, et olay nan akit ay wad-ay ken siya, et makaan. ");
INSERT INTO lbk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ibkasyo nan nay maid silfina ay faa is kaab-afollinget, ay kawad nan ngegngeg ya kaletket si fab-a.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Isnan omaliyak ay Anak si Takho ay Ali, ya am-in nan angheles ay omifofoweg, at sak tomokcho isnan matangtangad ay tronok ay en-okom. ");
INSERT INTO lbk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","At maamong is kasakhangko nan am-in ay takho isnan entona ay ili, sak et tekneteknen chaicha ay kag isnan angnen nan enpaspastor ay manken isnan karnilo ya karching. ");
INSERT INTO lbk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ya at ippeyko nan karnilo is kakannawanko, ya nan karching is kakannikhidko. ");
INSERT INTO lbk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Et sak kanan isnan wad-ay is kakannawanko, ‘Omali kayo ay binindisyonan Ama, ta tawichenyo nan en-ap-apowan ay naisakhana pala ken chakayo mailapo issan nakhab-an nan lofong. ");
INSERT INTO lbk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tay issan naowatak et pinmangan kayo, naew-ew ak ya inmipainom kayo. Inmali ak ay mangmangili et minangiliyo sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Maid osto is fachok ya finachowanyo sak-en. Nensakit ak et inmali kayo ay tinmam-aw, ya siya akhes issan naibfalochak, inmali kayo ay nangila ken sak-en.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sa et kanan nan cheycha'y nalenteg en, ‘Apo, kaatna mampet nan nangil-anmi ken sik-a ay naowatam ya pinanganmi sik-a, paymo naew-ewam ya inpainommi sik-a? ");
INSERT INTO lbk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kaatna nan nangil-anmi ken sik-a ya minangilimi sik-a, ya nan namachowanmi ken sik-a issan maid osto is infafachom? ");
INSERT INTO lbk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kaatna akhes nan nangil-anmi ken sik-a ay nasakit paymo nafalod ya inmey kami ay nanam-aw ken sik-a?’ ");
INSERT INTO lbk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Et kanak ay Ali, ‘Tet-ewa kanak ken chakayo, tay siya na nan inang-angnenyo isnan aag-ik ay makwanin kafafan-ikhan, nay et inangnenyo ken sak-en!’ ");
INSERT INTO lbk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sak et akhes kanan isnan wad-ay is kakannikhidko en, ‘Komaan kayo ken sak-en, chakayo ay chosaen Apo Dios! Omey kayo isnan apey ay maid pengpengna, ay naisasakhana ken Satanas ya nan anghelesna. ");
INSERT INTO lbk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tay issan naowatak, et egay kayo pinmangan. Naew-ew ak ya egay kayo inmipainom. ");
INSERT INTO lbk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Egay kayo minangili sak-en issan inmil-anyo, maid osto is fachok ya inmookhay kayo, nensakit ak ya naifalod ak ya egay kayo tinmamtam-aw.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Et sebfatencha ay mangwanin, ‘Apo, kaatna nan nangil-anmi ken sik-a ay naowat, naew-ew, mangili, maid osto is fachom, nensakit paymo naifalod, ya egaymi fachangan sik-a?’ ");
INSERT INTO lbk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ya sak-en ay Ali et sebfatek chaicha ay mangwanin, ‘Tet-ewa kanak ken chakayo, issan egayyo namachangan isnan esang ay aag-ik ay makwanin kafan-ikhan, et eg-ay kayo finmachang.’ ");
INSERT INTO lbk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Chatona nan omey isnan madchosaancha is eng-engkhana, ngem nan cheycha'y nalenteg omey cha isnan eng-engkhana ay matatakhowancha.” ");
INSERT INTO lbk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kakwasan nan cheycha ay infab-aag Jesus, kinwanina isnan disipolosna, ");
INSERT INTO lbk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ammoyo ay chwa et yangkhay ay akhew nan chaan, sa et am-among isnan Paskua. Et siya nan maal-ak ay Anak si Takho ta en cha omilansa is kakolos.” ");
INSERT INTO lbk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Idwani, wad-ay nan aap-apon si papachi ya nan amam-a ay naam-among is kapalasyon Caifas ay katongchowan ay pachi. ");
INSERT INTO lbk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Cha cha matotya mo ngag nan angnencha ay mangisikap ay maniliw ken Jesus, ta sa cha't ipapatey. ");
INSERT INTO lbk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kananchan, “Masapol ay faken isnan piyasta ay nay tay ta ket lang magkholo nan takho.” ");
INSERT INTO lbk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Awni pay ya wad-ay et cha Jesus id Betania isnan afong nan nakolit ay enngachan is Simon. ");
INSERT INTO lbk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Et isnan mangmanganan cha Jesus, inmali nan fafai ay nangitakin isnan fotilya ay alabastro ay entetey-an nan nafanglofanglo ya chadlos kafalolan ay lana, ya infokfokna is kaolon Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nay met achi isnan nangil-an nan disipolos Jesus, asi cha momolotomot ay nangwanin, “Ay ke ad-i ayyew chi? ");
INSERT INTO lbk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ilako pay chi et ayaka ay siping nan maichowa isnan posi.” ");
INSERT INTO lbk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tay ammon Jesus nan kankanancha, kinwanina, “Ngag en yo man pangayaen siya ay? Khag-awis nan inangnena ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tay wawawawad-ay cha nan posi ken chakayo, ngem sak-en, ad-i ak eng-engkhana ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nan nay ay inangnena ay nenlana isnan awakko, et isagsakhanana sak-en isnan sak maikaofan. ");
INSERT INTO lbk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tet-ewa kanak ken chakayo, olay entona issa isnan lofong nan maipalawakhan nan khawis ay okhod, at maitapi ay maog-okhod akhes nan nay ay inangnena ay at kaskasmekana.” ");
INSERT INTO lbk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sa et inmey isnan aap-apon si papachi si Judas Iscariote ay esang isnan sinpoo ya chwa'y disipolos Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Sa na't kanan, “Ngag nan igwayo ken sak-en mo ichowak siya ken chakayo?” Sa cha't finayachan siya is tolon poo ay silver ay pilak. ");
INSERT INTO lbk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Et nailapo ischi, inyan-anapna nan ikkana ay mangitiktik ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Isnan omona ay akhew nan Piyastan si Tinapay ay Egay Kabfofochan, sinmag-en nan disipolos Jesus ken siya ay mangwanin, “Ento nan laychem ay omisagkhanaanmi isnan manganan tako isnan am-among ay Paskua?” ");
INSERT INTO lbk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sa et kinwanin Jesus, “En kayo isnan ili et ilaenyo ischi nan esa'y takho. Kananyo ken siya, ‘Kanan nan Mistolo ay nganngani et nan olasna, ya isnan afongmo nan mangiyofongana isnan disipolosna isnan Paskua.’ ” ");
INSERT INTO lbk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Inangnen nan cheycha'y disipolosna nan am-in ay infilin Jesus, ya insakhanacha nan manganancha isnan am-among ay Paskua. ");
INSERT INTO lbk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naschem pay ya nangan cha Jesus ya nan sinpoo ya chwa ay disipolosna. ");
INSERT INTO lbk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sa et kinwanin Jesus isnan cha cha manganan, “Tet-ewa kanak ken chakayo, at esang ken chakayo nan mangitiktik ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ya ke cha't nenngongoyos ya waschin nangisonson ay mangwani ken siya, “Apo, faken achi sak-en ad-i ngen?” ");
INSERT INTO lbk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kinwanin et Jesus, “Nan chadlos makisiwsiw ken sak-en isnan malokong, siya kannay nan mangisipsip ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Awni't matey ak ay Anak si Takho maiyafoloy isnan naisolat ay kalin Apo Dios, ngem selaeg nan takho ay mangitiktik ken sak-en. Khap-esna't si egay naiyanak nan chey ay takho.” ");
INSERT INTO lbk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sa et kinwanin Judas ay at mangitiktik ken siya, “Mistolo faken achi sak-en ad-i ngen?” Kinwanin et Jesus, “Sik-a kannay nan nangwani.” ");
INSERT INTO lbk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Issan cha cha manganan, inalan Jesus nan tinapay sa et nenyaman ken Apo Dios ya pinetpet-angna. Sa na't inchowa isnan disipolosna ay nangwanin, “Nay, alaenyo na ta kanenyo. Siya na nan awakko.” ");
INSERT INTO lbk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Inalana akhes nan matatasa ay fayas, ya nenyaman. Sa na't inchowa ken chaicha'y nangwanin, “Nay, ominom kayo am-in isna. ");
INSERT INTO lbk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tay siya na nan chalak ay mangaeb isnan tolag Apo Dios, ay omayos pala isnan angsan ay takho ta mapakawan nan fasol. ");
INSERT INTO lbk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Siya na nan kanak ken chakayo, at ad-ik kasin in-inomen nan kag tona ay fayas, engkhana isnan akhew ay inomek nan falo ay fayas isnan enkadwaan tako id chaya ay en-ap-apowan Ama.” ");
INSERT INTO lbk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nenchag-ay cha ay nanad-ayaw ken Apo Dios, sa cha't nanikid is kafilig ay makwanin Olivo. ");
INSERT INTO lbk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Osto'y awni ya ket ay kinwanin Jesus ken chaicha, “Idwani ay lafi at lomayaw kayo am-in ay tomaynan. Tay kinwanin Apo Dios isnan naisolat ay kalina en, ‘At alaek nan enpaspastor ya at omapok nan karnilo.’ ");
INSERT INTO lbk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nay met achi isnan kasina manakhowan ken sak-en isnan etey, at mang-ona ak mo chakayo ay omey id Galilea.” ");
INSERT INTO lbk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ket ay kanan Pedro, “At ad-ik taytaynan sik-a Apo, olay mo taynancha am-in sik-a!” ");
INSERT INTO lbk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sa et kinwanin Jesus ken siya, “Tet-ewa kanak ken sik-a, idwani kannay ay lafi, at sisya ay ad-i enkokook nan kawitan isnan talan-o, ya at omisaot ka is mamitlo ay mangwanin ad-im ammo sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","“Olay maitapi ak ken sik-a ay matey, at ad-ik paat isas-aot sik-a,” kinwanin Pedro. Siya kayet akhes nan kinwanicha am-in ay disipolosna. ");
INSERT INTO lbk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sa et infoweg Jesus nan disipolosna isnan oma ay makwanin Getsemani. Kinwanina ken chaicha, “Itoktokchoyo isna ta khomegkheg-ed ak si akit ay en menlowalo.” ");
INSERT INTO lbk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Intakina cha Pedro ya nan chwa'y an-ak Zebedeo. Sa et chadlos enngongoyos ya ad-i tomke nan semekna, ");
INSERT INTO lbk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ya kinwanina, “Chachama ay enseseg-ang nan semekko et nay kag ak matey. Isna kayo ya makisasakhana kayo ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sa et inmadchawi is akit ya nenlokfob ay nangilowalo, “Ama, mo sa ya mabfalin ta ikasiwmo sak-en isnan nay ay chadlos ay likhat. Nay met achi faken nan nemnemko mod-i ket nan nemnemmo nan maangnen.” ");
INSERT INTO lbk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Issan tinmoliyana is kakawad san tolo ay disipolosna, inaspowana chaicha ay cha mitom-e. Kinwanina't ken Pedro, “Na! Ad-i kayo ngen paat makaikatpe is esa'y olas ay makisasakhana ken sak-en? ");
INSERT INTO lbk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ensasakhana kayo ya enlowalo kayo achi, ta ad-i kayo maafak isnan sailo. Tet-ewa ay enfifikas nan semekyo ngem nakapsot nan awakyo.” ");
INSERT INTO lbk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Inmadchawi kasin si Jesus ay en nenlowalo. Kinwanina, “Ama, mo nan nay ay chadlos ay sikhab ya ad-i mabfalin ay makaan engkhana'y itopegko, maangnen et achi nan nemnemmo.” ");
INSERT INTO lbk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Isnan kasina sinmakhongan, inaspowana chaicha ay cha mitom-e, tay makases-eyep cha. ");
INSERT INTO lbk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ya ket ay tinaynana kasin chaicha ya inmey nenlowalo isnan ikatlo, ya siya kayet nan kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sa et nensobli ya kinwanina isnan cheycha'y disipolosna, “Maseseyep kayo ngen kayet ya omil-illeng kayo? Olas et ya! Ya nay et alaencha sak-en ay Anak si Takho, ay naitiktik isnan cheycha'y fomafasol. ");
INSERT INTO lbk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fomangon kayo! Tay nay, omal-ali nan inmitiktik. En tako't abten.” ");
INSERT INTO lbk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sisya'y cha enkak-ali si Jesus ya ket naannali si Judas, ay esang isnan sinpoo ya chwa ay disipolosna, ya infofowegna nan angsan ay takho ay mamebfeneng ya enpapak-o, ay finaan nan aap-apon si papachi ya nan amam-a. ");
INSERT INTO lbk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Idwani siya na nan kinwanin Judas ay mangimatonancha: “Nan takho ay fisitowek, siya nan khoyochenyo,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sa na't chinadchawes si Jesus ay nangwanin, “Wad-ay kami, Mistolo!” Sa na't finisito. ");
INSERT INTO lbk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sa et kinwanin Jesus ken siya, “Kayong, angnem et achi nan pangkhepmo ay inmaliyan isna.” Ya ket sinmag-en nan cheycha'y takho ya khinoyodcha si Jesus ay naniliw ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Osto'y siya chi, inokfos nan esang ay foweg Jesus nan fadyokna, sa na't ala ya fakag isnan faan nan katongchowan ay pachi ya ket ay nan koweng nan chey ay faa nan nalongochan. ");
INSERT INTO lbk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ket ay kinwanin Jesus, “Isiklangmo kasin nan fadyokmo, tay nan takho ay enfakag et fadyok akhes nan mangala ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ay kem ad-i ammo ay mabfalin ak ay enpafachang ken Ama, ya at kannay pen paaliyena nan liniblifo ay anghelesna ay fomachang? ");
INSERT INTO lbk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nay met achi mo siya sa nan maangnen, ento pay nan kaiyangnenan nan kinwanin Apo Dios isnan naisolat ay kalina ay masapol ay siya na nan maangnen?” ");
INSERT INTO lbk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sa et kinwanin Jesus isnan katakhotakho, “Ay ke ak mangaakew ya kakaegyat, ta omali kayo ay enfafadyok ya enpapak-o ay tomiliw? Inakhew ay itoktokchok is kaTimplo ay nen-isos-olo, et en yo man egay tiniliw sak-en mo? ");
INSERT INTO lbk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Maangnen magtek chadlo am-in chana ta matongpal nan insolat nan cheycha'y mamadton Apo Dios.” Osto'y kinwanin Jesus chi, ya ket tinaynan am-in nan disipolosna siya ya linmayaw cha. ");
INSERT INTO lbk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nan cheycha'y naniliw ken Jesus, et inyeycha siya isnan afong Caifas ay katongchowan ay pachi ay naamongan nan mimistolon si lenteg ya nan amam-a. ");
INSERT INTO lbk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Et nakhag-ayad si Pedro ay inmon-onod ken siya, ya pachongna yangkhay isnan kaawwichan nan afong nan katongchowan ay pachi. Sa et somkhep ay makitokcho isnan cheycha'y khwarchiya, ta ilaena mo ngag nan enfanakhan nan am-in. ");
INSERT INTO lbk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Idwani, nan aap-apon si papachi ya nan am-in nan papangolon si Judio, et mid ad-icha inangnen ay nangan-anap isnan mangipangaakhancha ken Jesus ta chalatna's mapateyana, ");
INSERT INTO lbk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ngem maid nad-anancha. Siya chi, olay mo angsan cha nan sinmag-en ay nen-eng-engag ay nangipangaag ken siya. Nawnawni ya ket sinmag-en cha nan chwa ");
INSERT INTO lbk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ay nangwanin, “Si tosa san chey nangwanin, ‘Kafaelak ay etfen nan Timplon Apo Dios, sak et ken tood kannay isnan las-od si tolo ay akhew yangkhay!’ ” ");
INSERT INTO lbk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tinmakcheg et nan katongchowan ay pachi ay nangwani ken Jesus, “Ngag nan kanam? Ay ke maid isfatmo isnan mangisaklangan nan naycha'y tistikho ken sik-a?” ");
INSERT INTO lbk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngem khinmigkhinek yangkhay si Jesus. Sa et kinwanin nan katongchowan ay pachi, “Ipasapatak sik-a isnan ngachan Apo Dios ay Matatakho ta itet-ewam ken chakami mo sik-a si Cristo ay Anak Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sa et kinwanin Jesus, “Kinwanim et ya! Kanak magtek ken chakayo am-in, ay awni't ilaenyo sak-en ay Anak si Takho ay tomotokcho is kakannawan nan Makabfalin, ya omali ak ay enlolokhan isnan lifoo id chaya.” ");
INSERT INTO lbk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ya ket nenpeskhat nan katongchowan ay pachi nan fachona ay nangwanin, “Chey, chopchopisena's Apo Dios! Ay ke tako kasin masapol nan mentistikho? Chinngeyo et nan kinangaagna ya! ");
INSERT INTO lbk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngag et nan kananyo?” kinwanin nan katongchowan ay pachi. Ya ke cha't kanan, “Siya pay mo matey.” ");
INSERT INTO lbk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sa cha't tinobfaan nan kamesna, ya nensontok cha akhes, ya sinodpak nan tapina ");
INSERT INTO lbk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ay mangwanin, “Pontowam man, sik-a ay Cristo, mo sino nan nanodpak ken sik-a!” ");
INSERT INTO lbk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sisya'y wad-ay si Pedro ay tinmotokcho is kaawwichan, ya ket sinmag-en nan magmagkit ay faa ay nangwanin, “Sik-a akhes nan fob-oweg Jesus ay iGalilea.” ");
INSERT INTO lbk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngem insaot Pedro isnan sakhangcha am-in ay nangwanin, “Ay ke man way ammok isnan kankanam?” ");
INSERT INTO lbk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ket ay khinmeg-ed ay inmey is kapantew nan awwichan, ya inilan kayet nan teken ay magmagkit ay faa, sa na't kanan isnan wad-ay ischi en, “Fob-oweg pay ton-a si Jesus ay iNazaret.” ");
INSERT INTO lbk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sa na't kasin insaot ay nangwanin, “Isapatak ay ad-ik ammo si tosa ay takho.” ");
INSERT INTO lbk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nawnawnin ya ket sinmag-en ken Pedro nan cheycha'y takho ay wad-ay ischi ay nangwanin, “Sik-a mampet tet-ewa nan esang ay fob-owegna, tay kikhad nan ayog nan kalim!” ");
INSERT INTO lbk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sa na't ala ya sapata ay mangwanin, “Isapatak ay ad-ik ammo nan sana ay takho, olay mo matey ak.” Osto'y siya chi ya ket ay nanakokook nan kawitan, ");
INSERT INTO lbk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ya sinmek Pedro san kinwanin Jesus, “At sisya'y ad-i enkokook nan kawitan is talan-o, ya at mamitlo ay omisaot ka.” Sa et finmala ya nensifesifek. ");
INSERT INTO lbk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Issan kawiitana, naamong ay natotya nan am-in ay ap-apon si papachi ya nan amam-a, ta tolakhencha mo ngag nan angnencha ay mangipapatey ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tinakedcha siya sa cha't inkaan ay nangiyey ken Pilato ay khofernachor si iRoma. ");
INSERT INTO lbk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Issan nangil-an Judas ay nangitiktik ken siya, ay nakedchengan et ay matey si Jesus, nenfafawi. Sa na't nen-isobli nan tolon poo ay silver ay pilak isnan aap-apon si papachi ya nan amam-a, ");
INSERT INTO lbk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ay nangwanin, “Nenfasol ak tay intiktikko nan takho ay maid paat fasolna.” Sa cha't kanan, “Ngag nan fiyangmi issa? Kikhad ka achi is angnem.” ");
INSERT INTO lbk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nen-ibkas et Judas is kaTimplo san chey ay siping, sa na't ala ya kaan ay en nensilo. ");
INSERT INTO lbk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Inomong nan aap-apon si papachi san chey ay siping sa cha't kanan, “Lawa na's ichad-om is kamangipaypay-an si siping isnan Timplo, tay fayad si fiyag na.” ");
INSERT INTO lbk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sa cha't natotya ay en ilako nan chey ay siping isnan lotan si enkhag-aeb si fanga, ta siya's kaikak-aofan nan matey ay mangili. ");
INSERT INTO lbk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tay fayad si fiyag nan nailako isnan chey ay lota, nay et Lotan si Chala nan kanancha ischi engkhana idwani. ");
INSERT INTO lbk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Siya et na nan tinmet-ewaan san kinwanin nan mamadto ay si Jeremias en, “Inalacha nan tolon poo ay silver ay pilak, ay nammalor nan tap-in nan Israelitas isnan fiyagna. ");
INSERT INTO lbk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Et inlakocha na isnan lotan si enkhag-aeb si fanga, ay kag nan infilin nan Apo ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Idwani, wad-ay si Jesus ay nentatakcheg isnan sakhang nan khofernachor. “Ay sik-a pet tet-ewa nan Alin si Judio?” kinwanin nan khofernachor. “Osto nan kinwanim,” inisfat Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Issan magtek cha mangichaloman nan aap-apon si papachi ya nan amam-a ken siya, aped khinmigkhinek. ");
INSERT INTO lbk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tay siya chi, kinwanin et Pilato ken siya, “Ay kem ad-i chengngen nan angsan ay chalomcha ken sik-a?” ");
INSERT INTO lbk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngem maid paat insongfatna is olay esang ay kali isnan chalomcha ken siya, et chachama ay nataa nan khofernachor. ");
INSERT INTO lbk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Idwani, nan ekhad nan khofernachor isnan piyastan si Paskua, et ipalofosna nan esa'y falod ay kedchawen nan cheycha'y takho ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Et issan chey ay timpo, wad-ay nan esa'y nadngenadnge ay falod ay nenngachan si Barrabas. ");
INSERT INTO lbk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Adi kad isnan naamongan et nan katakhotakho, pinoot Pilato ay nangwanin, “Sino nan laychenyo ay palofosek? Si Barrabas ngen, paymo si Jesus ay makwanin Cristo?” ");
INSERT INTO lbk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tay ammon Pilato ay inchowacha si Jesus ken siya midkakay yangkhay isnan apalcha. ");
INSERT INTO lbk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Issan sisya'y tinmotokchowan Pilato isnan kaen-ok-okomana, ket ay naanali nan finaan asawana ay en mangifaag isnan kag tona: “Ngag ngotom isnan sana'y nalenteg ay takho, tay chadlos ak nalikhatan maipoon ken siya isnan it-itawko id kofab.” ");
INSERT INTO lbk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Osto'y siya chi, nan aap-apon si papachi ya nan amam-a et sinogsokhancha nan cheycha'y takho ta en cha kedchawen ken Pilato ta ipalofosna si Barrabas, ya ta ipapateyna si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sa et kinwanin kasin nan khofernachor ken chaicha, “Sino isnan chwa nan laychenyo ay palofosek?” Sa cha't kanan, “Si Barrabas!” ");
INSERT INTO lbk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Ngag kay et mampay nan angnek ken Jesus ay makwanin Cristo?” kinwanin Pilato. “Ipalansam is kakolos,” kinwanicha am-in. ");
INSERT INTO lbk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sa na't kanan, “Ngag man nan finmasolana?” Nay met achi onanig cha infokhaw ay mangwanin, “Ipalansam is kakolos!” ");
INSERT INTO lbk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Issan nangil-an Pilato ay maid maangnena ya madlawna ay enkholo cha et, inmala is chanom sa et nenfolo isnan sakhang nan katakhotakho ay mangwanin, “Faken ko fiyang nan mapateyan tona ay takho. Chakayo nan kikhad sisa.” ");
INSERT INTO lbk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","“Ngag ngotom ta chakami ya nan an-akmi nan kikhad isnan mapateyana,” inisfat am-in nan cheycha'y takho. ");
INSERT INTO lbk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Winayaan et Pilato si Barrabas ya inpasaplitna si Jesus, sa na't inchowa ta en mailansa is kakolos. ");
INSERT INTO lbk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Iniskhep et nan cheycha'y sorchachon Pilato si Jesus is kaafong nan khofernachor, sa cha't inayakhan am-in nan ib-acha'y kasorchasorchacho. ");
INSERT INTO lbk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Linafosancha si Jesus sa cha't fachowan isnan an-ancho ay enkilat. ");
INSERT INTO lbk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Et inmapid cha si sibsifit ay inpeycha isnan olona. Sa cha't inpaegnan nan lolo is kakannawan ay limana, ya kabfalibfalintomeng cha is kasakhangna ay nangang-ango ay mangmangwanin, “Apo ay alin si Judio, matakhotakho ka!” ");
INSERT INTO lbk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tinobfatobfaancha, sa cha't inala nan lolo ken siya ya nen-ifaigcha is kaolona. ");
INSERT INTO lbk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Osto ay inangoangocha, kinaancha't nan inpafachocha ken siya, sa cha't inpafacho chadlo san fachona, ya inkaancha ay en nangilansa is kakolos. ");
INSERT INTO lbk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Issan cha cha fomal-an is kaili, sinab-atcha nan lalaki ay iCirene ay nenngachan si Simon. Sa cha't pinilit ay nangipasakfat isnan kolos ay sasakfaten Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Isnan inomchanancha isnan kawad nan makwanin Golgota (ay nan laychena ay kanan et ingit si olo), ");
INSERT INTO lbk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","inchowacha ischi ken Jesus nan fayas ay nalaokan si akkho ta ipainomcha, ngem issan nenlamanana, inad-ina. ");
INSERT INTO lbk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kakwasan nan nangilansaancha ken siya is kakolos, nenfonot cha ay manatag isnan fachona. ");
INSERT INTO lbk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sa cha't tinmokcho ischi ay nanokkhong ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Isnan katongchon nan olona, inpeycha nan naisolat ay chalomcha ken siya. Kananan, “Si ton-a si Jesus ay Alin si Judio.” ");
INSERT INTO lbk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wad-ay akhes nan naigkhisan ay naikolos ken siya ay chwa'y kakaegyat ay mangaakew, nan esang is kakannawana ya nan esang is kakannikhidna. ");
INSERT INTO lbk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nan cheycha'y linmal-aos ischi, chinopchopischa siya ya cha cha nenwegwegweg ");
INSERT INTO lbk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ay mangwanin, “Sik-a ay nangwanin etfem nan Timplo sam et kasin toochen isnan las-od nan tolo'y akhew, isalakam achi nan awakmo! Khomwab ka is kakolos, mo sik-a nan Anak Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Siya akhes nan inangnen nan aap-apon si papachi, nan mimistolon si lenteg ya nan amam-a ay nangang-ango ken siya ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Insalakana nan tapina, ngem nan awakna ya ad-i pet makaisalak! Ya ngag man mo Alin si Israel sa! Ayed mo khomwab idwani is kakolos ta sa tako't patiyen! ");
INSERT INTO lbk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kanana pay en talkena si Apo Dios, ya kananan Anak Apo Dios siya. Ayed ay ta ilaen tako mo laychen Apo Dios ay mangisalak ken siya!” ");
INSERT INTO lbk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Olay nan cheycha'y mangaakew ay ib-an Jesus ay naikolos, et siya akhes sa nan inang-angnencha'y nanopchopis ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Osto pay ay alas chosi, ya ket ay finmollinget nan am-in ay ili ischi, engkhana'y alas tris isnan misoyaw. ");
INSERT INTO lbk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Isnan away nget alas tris, ya ket nenngao si Jesus ay nangwanin, “Eli, Eli, lama sabachthani?” Laychena ay kanan, “Diosko, Diosko, en ka man omog-okhay ay?” ");
INSERT INTO lbk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chinngen nan cheycha'y tapin nan nentaktakcheg ischi ay enfob-oya ya kinwanicha, “Ay-ayakhan ton-a si Elias.” ");
INSERT INTO lbk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Natanagtag et nan esang ken chaicha, ay inmey inmala is osalencha ay manosop isnan sinmoka ay fayas, sa na't inpey isnan lolo ta ipasosopna ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngem nan tapina kinwanicha, “Ngag ngotoyo, ta ilaen tako mo omali si Elias ay mangisalak ken siya!” ");
INSERT INTO lbk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Inpapangekhen Jesus ay nenngao kasin, sa na't inyoya nan leng-agna ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sa et nenkapepeskhat nan kortinan nan Timplo ya nakhedwa, mailapo is tongchona engkhana is khwabna. Nenyekha et napet-ang nan fato. ");
INSERT INTO lbk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Natekwafan akhes nan pantiyong ya naipatakho nan angsan ay nenkatey ay takhon Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Finmala cha is kapantiyong, ya kakwasan nan natakhowan Jesus sinomkhep cha id Jerusalem, ya nenpaila cha isnan angsan ay takho. ");
INSERT INTO lbk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Inmegyaegyat et nan kapitan ya nan cheycha'y sorchachona ay manotokkhong ken Jesus, issan nenliknaancha isnan yekha, ya nangil-ancha isnan naangnen. Sa cha't kinwanin, “Tet-ewa pet ay Anak nan Dios na!” ");
INSERT INTO lbk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wad-ay akhes isnan adchawi is akit nan angsan ay fabfafai, ay mangiila isnan cha omat. Chaicha san inmon-onod ken Jesus ay nalpo id Galilea ay nensilsilfi ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wad-ay ken chaicha cha Maria Magdalena, ya si Maria ay inan Santiago ya si Jose, sa et nan inan nan an-ak san si Zebedeo. ");
INSERT INTO lbk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Issan sedsechemna, inmali nan esa'y kachangyan ay iyArimatea, ay enngachan si Jose. Esang akhes siya ay disipolos Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Inmey ken Pilato ay nangchaw isnan awak Jesus. Et infilin Pilato ay maichowa chi ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Inalan et Jose nan awak Jesus, sa na't innewesan isnan egay kaos-osal ay lopot. ");
INSERT INTO lbk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sa na't inpey isnan kakhag-aeb ay liyang ay inpakaongna is kacheppas ay ento mo pantiyongna. Sa na't inol-olin nan chakchakowag ay fato ay inyenebna ischi, sa et kinmaan. ");
INSERT INTO lbk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Wad-ay ischi san si Maria Magdalena ya nan ib-ana ay enngachan akhes si Maria, ay tomotokcho is kasakhang nan pantiyong. ");
INSERT INTO lbk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Issan kawaksana ay Sabfacho, naamong nan aap-apon si papachi ya nan Fafariseo is kasakhang Pilato. ");
INSERT INTO lbk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Sa cha't kinwanin, “Apo, sesemkenmi tew-a nan kinwanin san chey kakas-okas-on issan matatakhowana ay nangwanin, ‘Kakwasan nan tolo'y akhew, at kasi ak fomangon.’ ");
INSERT INTO lbk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tay siya chi, filinem ed nan en manokkhong isnan pantiyong engkhana isnan mikatlo ay akhew, ta ket lang omey nan cheycha'y disipolosna ya akewencha nan awakna, sa cha't omey ifaag isnan katakhotakho ay finmangon siya isnan etey. Et am-am-amed nan nay omochi ay pangsas-ailocha mo nan inmona.” ");
INSERT INTO lbk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kinwanin et Pilato ken chaicha, “Mabfalin. Omifoweg kayo is khwarchiya ay omey mangset ay manokkhong isnan naikaofana!” ");
INSERT INTO lbk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Siya chi sa cha't inmey ya inseinsetcha'y minatonan nan fato ay naiyeneb, sa cha't inpatokkhong isnan cheycha'y khwarchiya. ");
INSERT INTO lbk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nakwas nan Sabfacho ay tengawcha, et osto'y nawiiwiit inmey cha Maria Magdalena ya nan teken ay Maria, ay en nangila isnan naikaofan Jesus. ");
INSERT INTO lbk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Faagna ya ket nenyekha is chad-ama, tay ya ket pinmanad nan esa'y anghel nan Apo ay nalpo id chaya ay en nang-alin isnan chey fato ay naitangeb isnan naikaofana sa na't tinokchowan. ");
INSERT INTO lbk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kag koryapyap ay somili nan ilana, ya enpokakaaw nan fachona. ");
INSERT INTO lbk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nan cheycha'y khwarchiya, et nentayenten cha isnan egyatcha issan nangil-ancha ken siya, ya ket kag natey nan ilacha. ");
INSERT INTO lbk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sa et nenkali san anghel issan cheycha'y fabfafai, “Ad-i kayo omegyat. Ammok ay an-anapenyo si Jesus ay naikolos,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","“Ngem maid met isna, tay finmangon kasin ay kag met laeng issan kinwanina. Ali kayo ta ilaenyo nan naisaachana. ");
INSERT INTO lbk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sa yo't kamowen ay en mangipaammo isnan cheycha'y disipolosna, ay kasin finmangon siya isnan etey, ya at mang-ona mo chakayo ay omey id Galilea. Et ilaenyo siya ischi. Chey, infaagko et chana ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kinamo cha ay kinmaan, et olay mo naegyatan cha, khechangna ay nenlal-ayad cha. Sa cha't nentatagtag ay en nangipaammo isnan disipolosna. ");
INSERT INTO lbk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Faagna ya ket wad-ay si Jesus ay nanab-at ya nenkali ken chaicha ay nangwanin, “Oompa kayo.” Ala cha't ya payaket isnan sikina ay nanad-ayaw ken siya. ");
INSERT INTO lbk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kinwanin et Jesus ken chaicha, “Ad-i kayo omegyat. Engkayo et magtek ifaag isnan iib-ak ta omey cha id Galilea, ay at omil-ancha.” ");
INSERT INTO lbk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Issan cha komaanan nan fabfafai, tinmoli is kaili nan tapin nan cheycha'y khwarchiya, ya en cha infaag isnan aap-apon si papachi nan am-in ay inmat. ");
INSERT INTO lbk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naamong et nan aap-apon si papachi ya nan amam-a, sa cha't matotya mo ngag nan angnencha. Sa cha't inigwa nan chakchake ay siping isnan cheycha'y khwarchiya, ");
INSERT INTO lbk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ay nangwanin, “Ifaagyo isnan takho ay inmey nan disipolosna isnan lafi, ay en nangakew isnan awakna issan mamaseypanyo. ");
INSERT INTO lbk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Et mo omchan na isnan khofernachor, at chakami nan kikhad ay mangal-alok ken siya, ta maid khotok si madchanakhanyo.” ");
INSERT INTO lbk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Inalan et nan khwarchiya nan siping ya inangnencha nan naifaag ay angnencha. Et engkhana idwani ay akhew, siya na nan maog-okhod ay maiwalwalas isnan Judio. ");
INSERT INTO lbk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Inmey nan cheycha'y sinpoo ya esang ay disipolos Jesus id Galilea isnan filig ay inischona ay omayancha. ");
INSERT INTO lbk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Et issan nangil-ancha ken siya, chinad-ayawcha, olay mo nenchwadchwa nan tapina ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sinmag-en si Jesus ya kinwanina, “Naichowa ken sak-en nan am-in ay kamabfalin id chaya ya isna is kalota. ");
INSERT INTO lbk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Engkayo et mampay isnan katakhotakho isnan am-in ay ili isnan lofong, ta enfalinenyo chaicha ay disipolosko. Fonyakhanyo chaicha isnan ngachan Dios Ama, Dios Anak ya nan Ispirito Santo. ");
INSERT INTO lbk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ya isoloyo chaicha ay mangangnen isnan am-in ay infilinko ken chakayo. Ya sesemkenyo ay kad-ikad-in ay wad-ay ak ken chakayo engkhana is kifos nan lofong.”");
INSERT INTO lbk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Siya na nan mailogkhiyan nan Khawis ay Chamag maipoon ken Jesu Cristo ay Anak Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Inpaisolat Apo Dios ken Isaias ay mamadtona nan nay: “Chey, faalek nan faak ay mang-ona mo sik-a, ta isakhanana nan kew-am.” ");
INSERT INTO lbk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Wad-ay isnan ponchag nan mangifogfokhaw ay mangwanin, ‘Isakhanayo nan chalan nan Apo, enletkhenyo nan ikwana.’ ” ");
INSERT INTO lbk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Et siya chi ya inomchan si Juan Bautista isnan ponchag, sa na't inpalawag, “Ibfafawiyo ta chokokhanyo nan fasolyo ya enpafonyag kayo, ya at pakawanen Apo Dios chakayo!” ");
INSERT INTO lbk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Et nakhogkhog-oy cha nan takho ay inmey ken siya, ay nalpo isnan am-in ay kabfakhaang nan Judea, ya nan omili ay nalpo id Jerusalem. Nenfafawi cha ay cha nangibfakha isnan fasolcha, et finonyakhan Juan chaicha isnan wanga ay Jordan. ");
INSERT INTO lbk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nan fachon Juan et innafe ay chotchot si kamelio, ya nenfabfalikes is kochil. Sa et chochon ya itlog si aleg nan inkatkatakhona. ");
INSERT INTO lbk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Inpalawag Juan ay mangwanin, “Wad-ay nan at maisokat ken sak-en ay wadwad-ay nan kamabfalina, ya ad-i ak maikali ay olay enyoko ay mamadfad isnan taked nan pallokana. ");
INSERT INTO lbk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sak-en fonyakhak chakayo isnan chanom, ngem siya, at fonyakhana chakayo isnan Ispirito Santo.” ");
INSERT INTO lbk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Siya chi ay timpo nan inomchanan Jesus ay nalpo id Nazaret ay esa'y ili isnan Probinsiya ay Galilea. Et finonyakhan Juan siya isnan wanga ay Jordan. ");
INSERT INTO lbk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Osto ay fomala si Jesus, ket ay inilana kannay ay nenkaookang nan chaya ya cha khomwab ken siya nan Ispirito Santo ay kag ilan si kalopati. ");
INSERT INTO lbk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sa et wad-ay id chaya nan nenkali ay nangwanin, “Sik-a nan laylaychek ay Anakko. Malaylaychan ak ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Osto'y siya chi inkaan nan Ispirito Santo si Jesus ay omey isnan ponchag. ");
INSERT INTO lbk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nentee siya ischi is epat poo ay akhew ay nanas-ailowan Satanas. Kecheng nan cheycha'y atap ay enkik-iwi nan wad-ay ischi. Et wad-ay nan angheles ay namadfachang ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Idwani, naifalod si Juan. Sa et tinmoli si Jesus id Galilea ay en nangipap-alawag isnan Khawis ay Chamag ay nalpo ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kinwanina, “Wad-ay et nan naischo ay timpona, nganngani et nan en-ap-apowan Apo Dios. Ibfafawiyo ta chokokhanyo nan fasolyo ya mamati kayo isnan Khawis ay Chamag.” ");
INSERT INTO lbk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Issan cha lomaosan Jesus is kailit nan fayfay id Galilea, inilana nan sin-akhi ay cha Simon ken Andres ay mangisabsabwag isnan tafokorcha is kafayfay, tay siya nan chonocha. ");
INSERT INTO lbk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sa et kinwanin Jesus, “Maifoweg kayo ken sak-en, ta isolok nan angnenyo'y mangamong isnan takho ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chag-as cha't ya taynan isnan tafokorcha sa cha't naifoweg ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Natnat-an si Jesus is akit, ke na't inila nan sin-akhi akhes ay cha Santiago ken Juan ay an-ak Zebedeo. Wad-ay cha is kafangkacha ay cha manginongnong isnan tafokorcha. ");
INSERT INTO lbk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sa na't inayakhan kannay chaicha, et tinaynancha is kafangka si amacha ay Zebedeo ya nan cheycha'y laglagfowencha, sa cha't naifoweg ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sa cha't inmey id Capernaum, ya osto ay Sabfacho ay tengaw, sinomkhep si Jesus isnan sinagoga, sa et nen-isolo. ");
INSERT INTO lbk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nataataa cha isnan ikkana ay en-isolo tay wad-ay pet nan kalebfengana, ad-i kag isnan mimistolon si lenteg. ");
INSERT INTO lbk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ya ket ay wad-ay nan esang ay lalaki is kasinagoga ay naan-anitowan, ");
INSERT INTO lbk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ay nenfokhaw ay mangwanin, “Sik-a Jesus ay iNazaret, ngag nan fiyangmo ken chakami? Ay inmali ka ngen ay mamakawas ken chakami? Ammok mo sino ka. Sik-a nan Nasantowan ay faan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngem yinangyangan Jesus ay nangwanin, “Khenekmo! Komaan ka ken siya!” ");
INSERT INTO lbk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ket ay inpapayegpeg nan anito siya, sa et nen-awe ay finmala ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nataa cha am-in sa cha't apaten ay mangwanin, “Ngag man na? Tekteken na ay sos-olo! Wad-ay pet nan kalebfengana ay mamilin isnan anito ya angnencha nan ibfakhana.” ");
INSERT INTO lbk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ket ay nenkaiwawalakhawag kannay nan maipoon ken siya isnan olay entona isnan am-in ay sakop nan ili ay Galilea. ");
INSERT INTO lbk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sa et kinmaan cha Jesus is kasinagoga, ya inmey cha is afong cha Simon ken Andres, ya naifoweg cha Santiago ken Juan. ");
INSERT INTO lbk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wad-ay ischi nan fafai ay katokhangan Simon ay maseseyep tay enpodpochot. Infaagcha kannay ken Jesus nan maipoon ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Inmey si Jesus isnan kawadna sa na't egnan nan limana ay nangipafangon ken siya, ket ay nenkakakaan nan pochotna. Siya chi ya sa na't panganen chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Isnan chey ay sedsechemna ay nalonokhan nan akhew, inyeycha ken siya nan am-in ay masasakit ya nan naan-anitowan. ");
INSERT INTO lbk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ya nap-onap-on cha nan omili is kaawwichan ya kapantew. ");
INSERT INTO lbk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Et inpagkhawisna nan angsan ay nenkasakit isnan nateketeken ay sakit ya cha na inpakaan nan angsan ay anito. Inpawana nan enkaliyancha tay ammocha mo sino siya. ");
INSERT INTO lbk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Issan talan-o ay sisya'y egay napat-a, naligwat si Jesus ya inmey isnan maid paat tagtakhowan ay en nenlowalo. ");
INSERT INTO lbk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sa et inmey cha Simon ya nan iib-ana ay en nangan-anap ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ya osto ay inchanancha siya ke cha't kanan, “An-anapencha pay am-in sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sa na't kanan, “En tako akhes isnan sanacha'y kabfakhaang ta enpalawag ak, tay siya nan chadlos khotok nan inmaliyak.” ");
INSERT INTO lbk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Et finaatna nan olay entona id Galilea ay en nenpap-alawag isnan sinagogacha, ya cha na inpakaan nan anito isnan nenkaan-anitowan. ");
INSERT INTO lbk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Idwani sinmag-en ken siya nan esa'y nakolit ay nensegseg-ang ya nenfalintomeng ay nangwanin, “Mo sa ya laychem, et mabfalin ay pakhawisem sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naseg-ang si Jesus sa na't kinappos ay nangwanin, “Laychek, khomawis ka.” ");
INSERT INTO lbk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ya ket nenkakakaan nan kolitna ya khinmawis siya. ");
INSERT INTO lbk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sa et chadlos finilin Jesus siya ay nangipakaan ");
INSERT INTO lbk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ay nangwanin, “Ilaem ta ad-im ifab-aag isnan olay sino. Engka't magtek paila isnan pachi, sam et en ichoo nan chaton maipoon isnan khinmawisam ken Apo Dios ay kag isnan infilin Moises, ta mangipaila isnan takho ay khinmawis ka.” ");
INSERT INTO lbk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nay met achi issan kinmaanana ke na't onanig okhookhochen nan inmat, et nay ad-i mabfalin ay enpap-aila si Jesus ay omey isnan il-ili mod-i ket nentetee siya id ilit, ya cha inmey nan katakhotakho ay nalpo isnan olay entona ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nar-os nan kaat yangkhay ay akhew sa et tinmoli si Jesus id Capernaum. Ket ay naammowan ay wad-ay siya is kaafong. ");
INSERT INTO lbk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Siya chi ya ket ay nenkakap-on nan angsan ay takho engkhana'y maid entey-an olay is kaawwichan. Isnan cha na mangipap-alawakhan isnan kalin Apo Dios ken chaicha, ket ay ");
INSERT INTO lbk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","wad-ay cha nan epat ay lallalaki ay nangiyey ken siya isnan ib-acha ay ad-i makagkhiwa. ");
INSERT INTO lbk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ad-i cha makaisag-en ken siya tay angsan nan takho. Nan inangnencha et linekwabcha nan tapin nan atep isnan fatog Jesus sa cha't inpagkhwab nan chey ay ad-i makagkhiwa ay naiyaamaka. ");
INSERT INTO lbk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Issan nangilasinan Jesus isnan pammaticha, kinwanina isnan chey ad-i makagkhiwa, “Anakko, napakawan et nan fasolmo.” ");
INSERT INTO lbk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Idwani, wad-ay cha nan tapina ay mistolon si lenteg ay tinmotokcho ischi ay cha mangwani is semekcha, ");
INSERT INTO lbk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“En man enkali na's kag tona ay cha la mangam-amsiw ken Apo Dios ay? Ay ke wad-ay makapakawan si fasol mod-i si Apo Dios yangkhay?” ");
INSERT INTO lbk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Et tay ammon Jesus ay siya chi nan semsemkencha, nenkanana't ken chaicha, “Ngag man kasin nan en yo semkesemken? ");
INSERT INTO lbk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ngag pet nan malanlanoy ay kanan isnan sana'y ad-i makagkhiwa, ‘Napakawan et nan fasolmo,’ paymo, ‘Fomangon ka, ekwatem nan kaseypam ya manalan ka’? ");
INSERT INTO lbk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nay met achi ta mangammowanyo ay wad-ay kalebfengak ay Anak si Takho isna's kalota ay menpakawan isnan fasol, aye man et ta ipailak.” Sa na't kanan isnan chey ad-i makagkhiwa, ");
INSERT INTO lbk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kanak ken sik-a, fomangon ka! Alaem nan kaseypam ta somaa ka't.” ");
INSERT INTO lbk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ket ay finmangon sa na't ala ya ekwat isnan kaseypana ya tinaynana chaicha am-in. Sa cha't nataataa am-in ay manad-ayaw ken Apo Dios. Kinwanicha, “Maid paat inil-ilami is kag tona!” ");
INSERT INTO lbk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kasin inmey si Jesus isnan ilit nan fayfay, ya inmey cha kayet nan angsaangsan ay takho ay en nangal-alifongfong ken siya, sa na't insos-olowan chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Issan cha na manalanan, inilan Jesus si Levi ay anak Alfeo ay tomotokcho is kaenfob-owisana. Sa na't kanan, “Maifoweg ka ken sak-en.” Sa et naligwat si Levi ay naifoweg. ");
INSERT INTO lbk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Issan cha manganan cha Jesus ya nan disipolosna is afong Levi, angsan cha nan enkorkortais ya nan cheycha'y makwanin wasit ay takho ay nakikan ken chaicha, tay angsan cha nan naifoweg ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Issan nangil-an nan mistolon si lenteg ay tapin si Fariseo ay cha makikan si Jesus isnan kananchan wasit ay takho ya nan cheycha'y enkorkortais, kinwanicha isnan cheycha'y disipolosna, “En man cha pet makikan nan mistoloyo isnan sanacha'y enkorkortais ya wasit ay takho ay?” ");
INSERT INTO lbk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Osto'y chinngen Jesus chi kinwanina, “Faken nan takho ay komekedse nan makasapol isnan choktor mod-i ket nan nasakit. Egay ak inmali ay mangayag isnan nalenteg, mod-i ket nan cheycha'y fomafasol.” ");
INSERT INTO lbk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Isnan namingsan, nentiptipe nan cheycha'y disipolos Juan ya nan Fafariseo. Ya ket wad-ay nan inmali ken Jesus ay nangwanin, “En man entipe nan cheycha'y disipolos Juan ya siya akhes isnan disipolos nan Fariseo, sa et nan disipolosmo ya ad-icha?” ");
INSERT INTO lbk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sa et kinwanin Jesus, “Ay ke mabfalin ay aped entipe nan lilwid nan kaab-afong ay lalaki, mo sisya'y wad-ay siya ken chaicha? Mo sisya'y wad-ay nan kaab-afong ken chaicha, ad-icha mabfalin ay entipe. ");
INSERT INTO lbk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngem at omali nan akhew ay maikaanan nan kaab-afong ken chaicha, et siya chi ay akhew nan ad-icha mangmanganan. ");
INSERT INTO lbk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kanak akhes en, maid mangidchokop isnan egay kinomsen ay lopot isnan lokhak ay facho, tay mo malab-an ya komsen nan falo, at mapeskhat nan lokhak, ya omam-amed et nan fakasna. ");
INSERT INTO lbk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Maid akhes mangippey isnan kakhag-aeb ay fayas isnan chaan ay kochil ay entey-an si fayas, tay at pen paptoken nan falo ay fayas chi ya maiwasit et yangkhay nan fayas olay nan kochil ay naipay-ana. Nan magtek falo ay fayas, et maippey koma isnan falo ay kochil ay entey-an si fayas.” ");
INSERT INTO lbk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Isnan esa'y Sabfacho, wad-ay cha Jesus is kapayewan, ya isnan cha cha manalanan inmala nan cheycha'y disipolosna is kinotkotimcha. ");
INSERT INTO lbk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sa et kanan nan cheycha'y Fariseo ken siya, “Ilaem kay ya, ke cha angnen nan disipolosmo nan maipawa isnan tengaw ay Sabfacho mo!” ");
INSERT INTO lbk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sa na't kanan, “Egayyo ngen finasa nan inikkan cha David ya nan cheycha'y takhona issan enliglikhatan ya naowatancha? ");
INSERT INTO lbk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sinomkhep si David isnan afong Apo Dios, issan timpon Abiatar ay katongchowan ay pachi ya kinmakan isnan tinapay ay naichoo ken Apo Dios. Sa na't inwalas isnan takhona. Maipawa met chi isnan olay sino ay mangakan mo ad-i yangkhay nan papachi.” ");
INSERT INTO lbk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sa et kanan Jesus, “Nan tengaw et naischo ay enkhawisan nan takho, ya faken nan takho nan naischo ay enkhawisan nan Sabfacho. ");
INSERT INTO lbk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tay siya chi sak-en ay Anak si Takho nan mangiyapo olay isnan tengaw.” ");
INSERT INTO lbk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Inmey kasin si Jesus is kasinagoga ya wad-ay ischi nan esa'y lalaki ay nasakew nan limana. ");
INSERT INTO lbk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sa cha't tinotokkhongan siya ta mangil-ancha mo en-akhas isnan Sabfacho, tay laychencha'y wad-ay mangipabfasolancha ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sa na't kanan isnan chey nasakew nan limana, “Omali ka isna's khawana.” ");
INSERT INTO lbk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sa et kinwanin Jesus ken chaicha, “Ngag nan ipalofos nan lenteg tako ay angnen isnan Sabfacho? En-angnen tako ngen is khawis paymo ngaag? En-isalak paymo enpatey tako ngen?” Ngem aped cha inkhigkhinek. ");
INSERT INTO lbk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sa et linmikhet ay nenmonaang ken chaicha ya nenseseg-ang nan semekna tay chadlos inkekedsecha. Sa na't kanan isnan lalaki, “Oyachem nan limam.” Inoyadna nan limana ya ket ay nakhannawis. ");
INSERT INTO lbk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Alan et nan cheycha'y Fafariseo ya fala, sa cha't kannay natotya isnan takhon Herodes maipoon isnan angnencha ay mangipapatey ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kinmaan si Jesus ya nan disipolosna sa cha't inmey isnan ilit nan fayfay. Inon-onod nan angsaangsan ay takho ay nalpo id Galilea, id Judea, ");
INSERT INTO lbk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","id Jerusalem, id Idumea ya isnan fas-ang nan Jordan. Siya akhes isnan angsaangsan ay nalpo isnan il-ili ay sakop nan Tiro ya Sidon, inmey cha ken siya tay chinngecha nan inang-angnena. ");
INSERT INTO lbk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sa na't infaag isnan cheycha'y disipolosna ta omisakhana cha is fangka ay entey-ana tay ta ket lang maipit isnan kaangsan nan takho. ");
INSERT INTO lbk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tay angsan cha nan cha na inpagkhawis, et nay am-in nan cheycha'y nenkasakit et cha cha entotlod ay en manikchod ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mo chakhos ilaen nan naan-anitowan siya, ala cha't ya lokfob isnan sakhangna ya infokhawcha, “Sik-a nan Anak Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngem chadlos finilin Jesus chaicha ta maid mangifagfag-ancha isnan maipoon ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sa et nanikid si Jesus isnan filig, ya inayakhana nan cheycha'y laychena, et naamong cha. ");
INSERT INTO lbk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chinotokana nan sinpoo ya chwa ken chaicha ta chaicha nan fob-owegna ay pangadnena is apostolesna ya ta chaicha nan faalena ay en menpap-alawag, ");
INSERT INTO lbk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ya ta wad-ay kalebfengancha ay mangipakaan isnan anito. ");
INSERT INTO lbk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Siya chana nan sinpoo ya chwa ay pinilina: si Simon ay nginadnana akhes is Pedro; ");
INSERT INTO lbk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nan sin-akhi ay an-ak Zebedeo ay cha Santiago ken Juan, ay nginadnana is Boanerges ay nan laychena ay kanan et an-ak si khicho; ");
INSERT INTO lbk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","cha Andres, Felipe, Bartolome, Mateo, Tomas, Santiago ay anak Alfeo, Tadeo, Simon ay mangitaktakcheg isnan mawayaan nan ilina, ");
INSERT INTO lbk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ya si Judas Iscariote ay awni't mangitiktik ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Issan sinmaalan Jesus, naamoamong kasin nan angsan ay takho ay mangal-alifongfong ken siya, ya maid paat wayacha, olay pay nan manganancha. ");
INSERT INTO lbk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Osto ay chinngen nan pangafongna, inmey cha ay en nangikaan ken siya, tay wad-ay nan mangwanin nalewlew siya. ");
INSERT INTO lbk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nan akhes mimistolon si lenteg ay pinmanad ay nalpo id Jerusalem et cha cha kanan, “Da! Naan-anitowan siya ken Beelzebub! Nan maachi yangkhay kamabfalin Beelzebub ay ap-apon si anito nan cha mangipakaanan tosa isnan anito.” ");
INSERT INTO lbk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sa na't inayakhan chaicha isnan kawadna ya inyal-aligna ay mangwanin, “Ngag nan ikkan Satanas ay mangipakaan isnan awakna kannay? ");
INSERT INTO lbk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mo nan omili et en-asibfaloknit cha kannay, ay ke sa ikakkan nan en-ap-apowan nan alicha? ");
INSERT INTO lbk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kag akhes isnan sinpangafong, mo maid ornoscha, at ngen sa makatakcheg? ");
INSERT INTO lbk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Siya akhes ay mo khobfaten Satanas nan takhona kannay maid et ornos nan en-ap-apowana, ya maid ikkana ay tomakcheg ya at maamas. ");
INSERT INTO lbk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Maiyalig siya isnan mafikas ay takho. Maid makaskhep isnan afongna ay mangikaan isnan kwana, mo ad-ina ona itaked siya ta nawaya ay mangilayaw isnan wad-ay isnan afongna. ");
INSERT INTO lbk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Tet-ewa nan kanak ken chakayo, am-in ay fasol si takho et mapakawan, ya siya akhes isnan olay ngag sisa'y kankanancha ay mangipangaag ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngem mo sino nan mangipangaag isnan Ispirito Santo et ad-i kapakpakawan, tay nakafasol siya is eng-engkhana.” ");
INSERT INTO lbk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kinwanina chi tay kankanancha en naan-anitowan siya. ");
INSERT INTO lbk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Awni ya ket inmey si inan Jesus ya nan aag-ina ay nangila ken siya. Wad-ay cha'y nentatakcheg is kadchela ya inpaayagcha siya. ");
INSERT INTO lbk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Angsan cha nan tinmotokcho ay nenlilikob ken Jesus. Sa cha't kanan ken siya, “Apo, wad-ay cha inam ya nan aag-im is kadchela ay mangayag ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sa na't kanan, “Sino nan kananyo en inak ya aag-ik?” ");
INSERT INTO lbk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sa et nenmonaang isnan tinmotokcho ay nenlilikob ken siya ya kinwanina, “Cheeycha nan inak ya aag-ik! ");
INSERT INTO lbk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tay mo sino nan mangikkan isnan nemnem Apo Dios et chaicha nan aag-ik ya inak.” ");
INSERT INTO lbk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Isnan namingsan, nen-isos-olo kasin si Jesus is kailit nan fayfay. Ngem tay chadlos angsan nan takho ay nangal-alifongfong ken siya, ket ay nen-aton is kafangka ay sisya is kadchanom et ischi nan nentokchowana ay nangisos-olo isnan katakhotakho is kailit nan fayfay. ");
INSERT INTO lbk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Et angsan nan insos-olona ken chaicha ay cha na inyal-alig. Kinwanina, ");
INSERT INTO lbk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Chengngenyo! Wad-ay nan inmey ay nen-isapowak is esek. ");
INSERT INTO lbk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Isnan cha na nen-isapowakan, wad-ay nan cha nap-as is kachalan, ya cha tinopek si ay-ayam ay inmali. ");
INSERT INTO lbk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Cha akhes nap-as nan tapina isnan lota ay cheppas nan enchaem. Tay entapew nan lota ischi, et sang-oyan ya ket tinmofo. ");
INSERT INTO lbk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nay met achi osto ay naakhewan, ya ke cha't ay naatongan ya naloyaw tay egay cha linmamot ay khawis. ");
INSERT INTO lbk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nan tapina et cha cha nap-as is kasibsifitan, ya osto'y tinmofo nan sibsifit, sinolincha nan cha tomofo ay esek, et egay cha namkhas. ");
INSERT INTO lbk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nan akhes tapina, nap-as cha isnan khawis ay lota, ya tinmofo cha ay khawis, ya wad-ay nan namkhas is sintotlon poo, masin-en-em poo ya masinkhagsot.” ");
INSERT INTO lbk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sa na't kanan, “Chengngenyo et achi mampay chana, mo wad-ay kowengyo ay mannge.” ");
INSERT INTO lbk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Issan makekedchengan cha Jesus isnan cheycha'y sinpoo ya chwa ay apostolesna sa et nan tapin nan takho, sinalodsodcha ken siya nan ayen nan cheycha'y al-aligna. ");
INSERT INTO lbk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sa et kanan Jesus, “Chakayo nan naipaammowan nan sikhod ay eg-ay naammowan maipoon isnan en-ap-apowan Apo Dios. Ngem chaicha ay faken ko disipolos, al-alig am-in nan angnek ay mangisolo ken chaicha ");
INSERT INTO lbk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ta ‘Olay mo chadlos cha iilaen, et ad-i cha makafigfig. Ya olay mo chechengngencha, ad-icha maawatan, tay eleg ya somakhong cha ken sak-en ya mapakawan cha.’ ” ");
INSERT INTO lbk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sa et kinwanin Jesus, “Ad-iyo ngen maawatan nan chey ay al-alig? Mo siya sa, ngag kay nan ikkanyo ay mangawat isnan tapina ay al-alig? ");
INSERT INTO lbk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nan chey ay en-sapsapowak et isapsapowakna nan kalin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maiyalig nan tapina'y takho isnan chalan ay nap-asan nan tapina ay esek. Chaicha nan cheycha'y mannge isnan kalina ngem ket ay naanali si Satanas ay mangaan isnan chey ay kalina ay naimola is kasemekcha. ");
INSERT INTO lbk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Siya akhes isnan lota ay cheppas nan chaemna ay nap-asan nan esek. Maiyalig isnan cheycha'y mannge isnan kalin Apo Dios sa cha't ala ya chawat ay mangilayalayad. ");
INSERT INTO lbk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngem tay egay linmamot isnan semekcha, sinak-itan yangkhay nan pammaticha. Sa et mo omali nan ensikhafan paymo mapalikhatancha maipoon isnan kalin Apo Dios ke cha't ay iwayang kannay nan pammaticha. ");
INSERT INTO lbk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nan akhes kasibsifitan ay nap-asan nan esek, siya nan alig nan cheycha'y mannge isnan kalin Apo Dios, ");
INSERT INTO lbk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ngem nan ayaka ay chanagcha isnan fiyagcha is kalota, ya nan layadcha isnan kinafaknang, sa et nan tapina kayet ay figfikhawencha nan somya ay manolin isnan chinngecha ay kalina, et nay ad-i mamkhas ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngem nan khawis ay lota ay nap-asan nan esek, maiyalig isnan cheycha'y mannge isnan kalin Apo Dios ya chawatencha. Chaicha nan mamkhas is masintotlon poo, masin-en-em poo ya masinkhagsot.” ");
INSERT INTO lbk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Inyal-alig kayet Jesus ken chaicha ay nangwanin, “Ay ke maiskhep nan silaw ta sa et matangfan isnan salop paymo maipachao is kamaseypan ya faken isnan osto ay kaipatpatangana? ");
INSERT INTO lbk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Siya akhes ay isnan maitatafon idwani, naitafon ta sa et maipaila. Ya am-in ay maitatafon idwani et masapol ay maipalawag is tap-in. ");
INSERT INTO lbk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chengngenyo et mampay chana mo wad-ay kowengyo ay mannge.” ");
INSERT INTO lbk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kinwanina akhes, “Ilaenyo ay khawis nan angnenyo ay enchenge tay nan angnenyo isnan chengngenyo, siya akhes nan maisofalit ken chakayo, ya am-amed kayet ay tapiyan Apo Dios nan maawatanyo. ");
INSERT INTO lbk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tay nan mangidno isnan wad-ay ken siya, at maagtan kayet. Ngem nan maiyalig ay maid mabfalina ay ad-i mangidno isnan wad-ay ken siya, et olay nan akit ay wad-ay ken siya, et makaan.” ");
INSERT INTO lbk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kinwanin kayet Jesus, “Kag tona nan kaiyalikhan nan en-ap-apowan Apo Dios: Inmey nensapowak nan esa'y ensamsama. ");
INSERT INTO lbk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kalabfiyana inmey naseyep sa et fomangon isnan kawaksana. Ket ay tinmofo ya cha maengngan nan insapowakna. Ad-ina magtek ammo mo ngag nan inikkan nan chey esek ay tinmofo. ");
INSERT INTO lbk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kikhad nan lota ay menwad-ay isnan tomofo. Pabfalaena ona nan tofona, awni pay ya ket ay masiken sa et mamkhas. ");
INSERT INTO lbk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ngem mo nabkhasan et, ala na't ya kompay ay mangani tay timpona.” ");
INSERT INTO lbk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kinwanin kayet Jesus, “Ngag nan maikis-owan nan en-ap-apowan Apo Dios? Ngag ay al-alig nan osalek ay mangipaila isnan kais-isona? ");
INSERT INTO lbk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Iyaligko isnan esang ay kabfafan-ikhan ay esek ay makwanin mostasa. Siya nan kabfafan-ikhan isnan am-in ay ilan si mais-ek isnan lota. ");
INSERT INTO lbk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ngem mo mais-ek, tomofo ya masiken ya enfalin ay kaaanchowan isnan am-in ay chapong. Pomanga is chadchake ta sa et mabfalin ay enpaingan ya enkhafanan si ay-ayam.” ");
INSERT INTO lbk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Angsan ay al-alig ay kag tosa nan inangnen Jesus ay nangisos-olo isnan kalin Apo Dios ken chaicha. Insolowana chaicha isnan kafaelancha ay mangawat. ");
INSERT INTO lbk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Maid nen-og-okhochana ken chaicha is egayna inyal-alig, ngem mo chaicha yangkhay isnan disipolosna, inlawlawagna ken chaicha nan ayen nan am-in ay kankanana. ");
INSERT INTO lbk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Issan chey kannay ay akhew, osto ay nakhosfet, kinwanina isnan disipolosna, “En tako is chemangna.” ");
INSERT INTO lbk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sa cha't tinaynan nan angsan ay takho, ya inlokhancha si Jesus isnan fangka ay nentetey-ana. Wad-ay cha akhes ischi nan tapina ay nenfafangka ay naifoweg ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Awni pay ya ket nachannakhem is chad-ama, ya cha masepyatan ya mapsong nan fangka ay cha chosngowen nan talipyakew. ");
INSERT INTO lbk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngem si Jesus wad-ay ay enpoppongan ay mamaseyep is apet chokog nan fangka. Ala cha't ya fangon ken siya ay mangwanin, “Mistolo, ay ad-im ngen iyegyat nan mateyan tako?” ");
INSERT INTO lbk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sa et finmangon ay mangipatke isnan chakhem ya kinwanina isnan fayfay, “Khenek! Tomke ka!” Tinomke tet-ewa nan chakhem ya chadlos inompa nan fayfay. ");
INSERT INTO lbk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sa na't kanan, “Ya ke kayo omegyat ay? Maid ngen paat pammatiyo?” ");
INSERT INTO lbk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Chad-ama nan egyatcha ya cha cha kankanan, “Sino man na, tay ya ke olay nan chakhem ya nan fayfay et patiyencha siya?” ");
INSERT INTO lbk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Khinomchang cha isnan ilin nan iGerasa. ");
INSERT INTO lbk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ya osto ay finmala si Jesus is kafangka ket ay sinab-at nan lalaki ay naan-anitowan ay nalpo isnan liyang si natey, ");
INSERT INTO lbk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","tay ischi nan nentetey-ana. Maid kasin makataked ken siya, olay mo kadchinaancha. ");
INSERT INTO lbk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tay away nangaat ay nataked nan limana ya nan sikina isnan kachina, ngem khechangna'y aped na sinokpot nan taked nan limana, ya tinegtegna nan kachinan nan sikina, ya maid makaipap-a ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Minaschem ya winakas ay aped enwakwakis is kaliyang si natey ya is kafilig, sa na't tegtegtekhen nan awakna isnan fato. ");
INSERT INTO lbk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Osto'y inilana si Jesus isnan ad-adchawi, ala na't ya tagtatagtag ya nenlokfob isnan sakhangna. ");
INSERT INTO lbk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sa na't inpapangekhe ay nenfokhaw ay mangwanin, “Ngag nan fiyangmo ken sak-en Jesus ay Anak nan Katotongchowan ay Dios? Isapatam isnan ngachan nan Dios ta ad-i ka omipalikhat!” ");
INSERT INTO lbk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Siya chi tay kinwanin et Jesus, “Sik-a ay anito, komaan ka isnan sana ay lalaki!” ");
INSERT INTO lbk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sa et kinwanin Jesus, “Ngag nan ngachanmo?” “Kalifolifo nan ngachanko tay angsan kami ay anito,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sa na't chadlos inseg-aseg-ang ken Jesus ta ad-ina pakaanen chaicha isnan chey ay ili. ");
INSERT INTO lbk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Idwani, wad-ay akhes isnan chey ay ponchag nan angsan ay fotog ay en-ang-anglod. ");
INSERT INTO lbk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sa et nenseg-ang nan kaanianito ken siya ay mangwanin, “Ippeymo achi chakami isnan cheycha'y fotog. Ipalofosmo ta segpenmi chaicha.” ");
INSERT INTO lbk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Et tinan-oyan Jesus. Adi kad nabfanala nan cheycha'y anito sa cha't ala ya sekhep isnan kafotofotog, ke cha't ay ala ya tagtag is katoy-ob ay enchadchawes is kafayfay et nalin-eb cha. Omey si away chwan lifo chachi. ");
INSERT INTO lbk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Linmayaw et nan cheycha'y enpaspastor, sa cha't inmey isnan olay entona ay kawad si afong isnan chey ay ili ay nangipadnge isnan chey ay inmat. Et nakhogkhog-oy nan katakhotakho ay inmey nangila isnan inmat. ");
INSERT INTO lbk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Inmey cha ken Jesus, ya inilacha ay tinmotokcho ischi san chey lalaki ay nakaanan san kaanianito. Nabfachowan siya ya khinmawis et chadlo nan osto ay semekna. Sa cha't inmegyat. ");
INSERT INTO lbk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nan cheycha akhes chadlos nangila isnan chey ay inmat et inokhodcha nan naangnen isnan chey ay naan-anitowan ya nan cheycha'y fotog. ");
INSERT INTO lbk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Siya chi ke cha't ay nenseg-ang ken Jesus ta komaan siya isnan ilicha. ");
INSERT INTO lbk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Osto'y cha enlokhan si Jesus is kafangka, nenseg-ang ken siya san chey lalaki ay kinmaanan nan kaanianito ta maifoweg ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngem inad-in Jesus ay nangwanin, “Somaa ka ta ifaagmo isnan ib-am nan am-in ay namachangan ya naneg-angan Apo Dios ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Et inmey tet-ewa isnan Sinpoo ay Ili ay en nangifab-aag isnan am-in ay inangnen Jesus ken siya. Ya nataa cha am-in ay nannge isnan kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nenfangka si Jesus ay tinmoli is chemangna. Osto'y sisya cha is kailit nan fayfay, inal-alifongfongan nan angsaangsan ay takho. ");
INSERT INTO lbk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sa et inmey ken siya nan esa'y mangichad-alan isnan sinagogacha ay enngachan is Jairo. Osto'y inilana si Jesus, ket ay ala na ya lokfob isnan sakhangna ");
INSERT INTO lbk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ya nenseg-ang ay mangwanin, “Chadlos matmatey nan anakko ay fafai. Omali ka koma ta ipatangmo nan limam ay mangipagkhawis ken siya ta matakho.” ");
INSERT INTO lbk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Adi kad naitakin si Jesus, ya naifoweg nan chadlos angsan ay takho ay cha ensislig ay mangal-alifongfong ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wad-ay akhes ischi nan esa'y fafai ay egay nasnaschok nan kachawyana is sinpoo ya chwa ay tawen. ");
INSERT INTO lbk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chad-ama nan likhatna isnan angsan ay choktor ay en na cha nenpaag-akhasan. Aped yangkhay naengew nan am-in ay wad-ay ken siya, nay met achi egay paat khinmawis mod-i ket onanig inmam-amed. ");
INSERT INTO lbk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chinngena nan kankanan nan takho maipoon ken Jesus, et nay sinmag-en isnan chokogna isnan kawad nan angsan ay takho sa na't sinikchod nan fachona, ");
INSERT INTO lbk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tay kananan, “Olay mo sikchochek yangkhay nan fachona et maipagkhawis ak.” ");
INSERT INTO lbk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Siya chi ya ket naschok kannay nan kachawyana, ya liniknana nan khinmawisan nan sakit nan awakna. ");
INSERT INTO lbk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Issan nenliknaan Jesus ay wad-ay et nan kamabfalin ay finmala ken siya, ala na ya sakhong isnan cheycha'y angsan ay takho sa na't kanan, “Sino nan nanikchod isnan fachok?” ");
INSERT INTO lbk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sa et kanan nan disipolosna, “Apo, ya kem iilaen nan sanacha'y cha ensislig ay mangal-alifongfong ken sik-a ya kanam kayet en sino nan nanikchod ken sik-a?” ");
INSERT INTO lbk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sa et nenmonaang kayet si Jesus ay mangila mo sino nan nanikchod ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Idwani tay ammon nan fafai nan naangnen ken siya, inmegyat ya nanat-ayenten ay inmey ken Jesus ya nenlokfob isnan sakhangna ay nangifaag isnan am-in ay tet-ewa ay inangnena. ");
INSERT INTO lbk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sa et kinwanin Jesus, “Anakko, nan pammatim nan nangipagkhawis ken sik-a. Omey ka et oompa nan semekmo ya khinmawis nan sakitmo.” ");
INSERT INTO lbk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Issan sisya ay cha enkaliyan Jesus, wad-ay cha nan inmali ay nalpo is afong Jairo. Kananchan, “Apo, natey et nan anakmo. Ay kem kasin sangawen nan Mistolo?” ");
INSERT INTO lbk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngem inookhay Jesus nan kinwanicha, sa na't kanan ken Jairo, “Ad-i ka omegyat. Mamati ka yangkhay.” ");
INSERT INTO lbk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Maid inpalofos Jesus ay maifoweg ken siya mod-i kecheng si Pedro, ya nan sin-akhi ay cha Santiago ken Juan. ");
INSERT INTO lbk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Isnan inomchanan cha Jesus is afong Jairo ay ap-apo isnan sinagoga, inilana ay ngomanawngaw nan takho ischi, tay waschin cha aakha ya chadlos cha inpapangekhe ay manganako ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sinomkhep ya kinwanina ken chaicha, “En kayo man ngomanawngaw ya en-ag-akha ay? Eg-ay natey nan ong-onga, mamaseyep yangkhay.” ");
INSERT INTO lbk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sa cha't inang-ango siya. Ngem ke na't ay pabfalaen chaicha am-in, sa na't ayakhan nan chakek-ena ya nan cheycha'y tolo ay fowegna, sa na't ipango chaicha isnan kawad san ong-onga. ");
INSERT INTO lbk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Inegnan Jesus nan liman nan ong-onga sa na't kanan, “Talita kum!” Nan laychena ay kanan et, “Anakko, kanak ken sik-a, fomangon ka!” ");
INSERT INTO lbk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Finmangon kannay san ong-onga ya nanalan (nan tawena et sinpoo ya chwa). Et chadlos nataataa cha. ");
INSERT INTO lbk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sa na't chadlos finilin chaicha ta ad-icha ipap-aammo chi isnan olay sino. Sa na't kanan ta pakanencha. ");
INSERT INTO lbk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kinmaan cha Jesus ischi ya nafobweg cha isnan disipolosna ay sinmaa isnan ilina. ");
INSERT INTO lbk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Isnan tengaw ay Sabfacho, inmey is kasinagoga ya nen-isos-olo, ya angsan nan nataataa isnan cheycha'y nannge ken siya. Kinwanicha, “Ento man nan nangalaan tona isnan kankanana?” ya “Ngag kay na ay laing nan nay naichawchaw ken siya?” ya “Ento nan ikkana ay mangangnen isnan kamabfalin? ");
INSERT INTO lbk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ay ke faken na san kalapantilo ay anak Maria ya aag-ina cha Santiago, Jose, Judas ya si Simon? Ad-i ngen wad-ay cha nan kafabfaiyana ay nakiili ken chatako isna?” Sa cha't inad-i siya. ");
INSERT INTO lbk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sa et kinwanin Jesus ken chaicha, “Maichad-ayaw nan mamadto isnan olay entona issa, nay met achi isnan osto ay ilina, ay kawad nan kikib-ana ya pangafongna kannay, et maid filangna.” ");
INSERT INTO lbk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Et nay ad-i mabfalin ay ipailana ischi nan chadlos kamabfalina. Nan yangkhay inangnena et inpatangna nan limana isnan akit ay nenkasakit ya inpagkhawisna chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nataa siya khapo tay maid pammaticha. Sa et inmey si Jesus isnan kailiili ay cha nen-isos-olo. ");
INSERT INTO lbk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Inayakhana nan sinpoo ya chwa ay disipolosna sa na't infaa chaicha is sinchodwachodwa. Inagtana chaicha is kalebfengancha ay mangipakaan isnan anito. ");
INSERT INTO lbk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Finilina chaicha ta maid itaktakincha is senget, sopot ya siping isnan enfaatancha mod-i kecheng nan sokod. ");
INSERT INTO lbk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Infilina ta enpalloka cha, ngem ad-icha chowaen nan fachocha. ");
INSERT INTO lbk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kinwanina akhes, “Mo wad-ay menmangili ken chakayo isnan afongna, entee kayo ischi engkhana ay taynanyo chi ay ili. ");
INSERT INTO lbk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mo wad-ay ad-i manawat ken chakayo, ya ad-icha chengngen chakayo, taynanyo, ya isnan komaananyo, pagpakhenyo nan sikiyo ta makaan nan pinomket ay chapog nan chey ay ili, ta kag tokhon ken chaicha.” ");
INSERT INTO lbk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Adi kad inmey cha ay nangipap-alawag ay masapol ay enfafawi ya chokokhan nan takho nan fasolcha. ");
INSERT INTO lbk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Et cha cha inpakaan nan angsan ay anito, ya cha cha inapposan si lana nan angsan ay nenkasakit ya inpagkhawischa chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Idwani, chinngen Ali Herodes nan maipoon ken Jesus, tay nadnadnge nan ngachana isnan olay entona. Wad-ay cha nan nangwanin, “Siya si Juan Bautista ay finmangon isnan etey. Siya chi nan khotokna ay wad-ay kamabfalina.” ");
INSERT INTO lbk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngem nan tapina, kananchan, “Siya si Elias.” Ya wad-ay cha kayet nan mangwanin, “Mamadto siya, ay kag isnan mamadton Apo Dios id solit.” ");
INSERT INTO lbk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngem osto'y chinngen Herodes nan naang-angnen, kinwanina, “Natakho si Juan ay inpapotlongko nan olona.” ");
INSERT INTO lbk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kinwanin Herodes chi tay siya san nangipatiliw ken Juan issan chey, sa na't inpafalod siya midkakay ken Herodias ay asawan nan etadna ay si Felipe, tay inasawana. ");
INSERT INTO lbk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Siya chi nan khotok nan nangwaniyan Juan ken Herodes, “Lawa nan mangiyamongam isnan asawan nan etadmo.” ");
INSERT INTO lbk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Siya chi nan nanosongtan Herodias ken Juan ya laychena ay ipapatey siya. Ngem ad-i mabfalin ");
INSERT INTO lbk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tay omegyat si Herodes ken Juan khapo tay ammona ay nalenteg si Juan ya nakapet ken Apo Dios, et nay insas-alakana siya. Sa et olay mo makorkor nan semekna isnan manngelana isnan ifab-aag Juan, laychena kayet ay manmannge isnan kankanana. ");
INSERT INTO lbk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ngem awni ya inomchan nan wayan Herodias, tay isnan akhew ay pitsan nan naiyanakan Herodes, nenpapiyasta siya. Inpaayag Herodes nan am-in ay okom, nan ap-apon nan sorchacho, ya nan am-in ay matangad ay takho id Galilea. ");
INSERT INTO lbk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sa et inmey nan magmagkit Herodias ay nensalasala, ya nalaylaychan si Herodes ya nan cheycha'y inayakhana ay makilaglagsak ken siya. Ket ay kanan Herodes isnan magmagkit, “Ibfakham ken sak-en nan olay ngag sisa ay laychem et sak ichowa.” ");
INSERT INTO lbk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Insapatana kayet ay nangwanin, “Olay ngag sisa'y kedchawem et ichowak, olay mo kakhedwan nan en-ap-apowak.” ");
INSERT INTO lbk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sa et finmala ya kinwanina ken inana, “Ngag kay nan kedchawek?” Ket ay kanan inana, “Nan olon Juan Bautista.” ");
INSERT INTO lbk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ala na't ya eey ken Ali Herodes sa na't kedchawen ay mangwanin, “Laychek ay ichowam kannay ken sak-en nan olon Juan Bautista ay mapapalato.” ");
INSERT INTO lbk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ya ket ay chad-ama nan fafawin Ali Herodes, ngem khapo isnan chey insapatana sa et tay wad-ay nan fisitana, ad-ina laychen ay maichen nan apchas na inkali ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Adi kad finmaa kannay isnan khwarchiyana ta en na alaen nan olon Juan. Sa et inmey ya pinotlongna nan olon Juan is kafabfalochan. ");
INSERT INTO lbk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Et inyeyna tet-ewa ay mapapalato sa na't inchowa isnan magmagkit, ya inchowana ken inana. ");
INSERT INTO lbk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Osto ay chinngen nan disipolos Juan chi, inmey cha ay nangala isnan awakna ay en nangikaob. ");
INSERT INTO lbk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sa cha't tinmoli ken Jesus nan apostolesna ya inokhodcha ken siya nan am-in ay cha cha inang-angnen ya insos-olo. ");
INSERT INTO lbk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kinwanin Jesus ken chaicha, “Makekecheng tako ay omey isnan maid tagtakhowan, ta omilleng kayo is sinak-itan.” Tay masoblisobli nan takho ken chaicha ya maid paat wayacha olay pay nan manganancha. ");
INSERT INTO lbk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sa cha't nakekecheng ay nenfangka ay inmey isnan mam-aid takho. ");
INSERT INTO lbk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nay met achi angsan cha nan nangila isnan kinmaanancha ya inmatonancha chaicha. Sa cha't nentagtagtag ay inmonod ay nalpo isnan kailiili ischi, ket ay inmon-ona cha ay inomchan mo cha Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Issan chinmakalan Jesus, inilana nan angsaangsan ay takho ya chadlos naseg-ang ken chaicha tay kag cha karnilo ay maid manoktokkhong ken chaicha. Et angsan nan cha na insos-olo ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Issan nganngani malonokhan nan akhew, inmey nan disipolosna ken siya ay mangwanin, “Nay cha et makhosfet ya wad-ay tako isna'd ilit. ");
INSERT INTO lbk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kanam et achi ken chaicha ta omey cha isnan sanacha'y ensag-en ay ili ya kabfakhaang ta lomako cha is kanencha.” ");
INSERT INTO lbk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngem ket ay kinwanin Jesus, “Panganenyo chaicha.” Sa cha't kanan, “Apo, ay en kami ngen lomako is tinapay ay falor si chwa'y khasot ay denaryo sa mi't ichowa ken chaicha ta kanencha?” ");
INSERT INTO lbk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sa na't kanan, “Kaat nan wad-ay ken chakayo ay tinapay? En kayo ilaen.” Osto'y inammowancha, kinwanicha, “Lima ay tinapay ya chwa ay filis.” ");
INSERT INTO lbk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sa na't infilin ta patokchowencha am-in nan takho is sinpapangfon isnan kawad nan lokham. ");
INSERT INTO lbk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Et siya chi ay tinmokcho cha ay naop-opon is sinkhagsot ya sinlilman poo. ");
INSERT INTO lbk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sa et inalan Jesus nan chey lima ay tinapay ya chwa ay filis ya nentangad id chaya ay nenyaman, sa na't pinet-apet-ang ya inchowana isnan disipolosna ta iwalascha. Sa na't inpaiwalas nan chwa'y filis ken chaicha am-in. ");
INSERT INTO lbk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nangan cha't am-in ya negsan cha. ");
INSERT INTO lbk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ya nan nakhayad ay tinapay ya filis ay cha chinakhop nan disipolosna et sinpoo ya chwa ay nenkapno ay labfa. ");
INSERT INTO lbk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nan filang nan lallalaki yangkhay ay nangan et omey is liman lifo. ");
INSERT INTO lbk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Osto'y siya chi, inpafangkan kannay Jesus nan disipolosna ta mang-ona cha is chemangna ay ili ay Betsaida, sa na't inpasaa akhes nan cheycha'y takho. ");
INSERT INTO lbk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Osto'y inpasaana chaicha, nanikid is kafilig ay en menlowalo. ");
INSERT INTO lbk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Naeesang si Jesus ischi engkhana ay sedsechemna. Wad-ay nan fangka is kakhawan nan fayfay, ");
INSERT INTO lbk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ya inilan Jesus ay sikhab nan mangipadchalanancha isnan fangka tay ab-afikas nan chakhem ay mangab-afet ken chaicha. Isnan cha na tomalan-owan, inmey si Jesus ay nanad-alan is kaoson nan fayfay ay somagsag-en ken chaicha. Kanana en ta laosana koma chaicha, ");
INSERT INTO lbk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ngem isnan nangil-ancha ken siya ay cha manad-alan isnan oson nan fayfay, kananchan away anito, ke cha't ay nenwakis. ");
INSERT INTO lbk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tay inilacha am-in ya nenkabfefegyas cha. Ngem nenkanan kannay Jesus ken chaicha, “Pabfikasenyo nan semekyo, tay sak-en na. Ad-i kayo omegyat.” ");
INSERT INTO lbk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sa et nakilokhan ken chaicha isnan fangka ket ay tinomke kannay san chakhem. Sa cha't chadlos nataataa, ");
INSERT INTO lbk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tay egaycha naawatan nan ayen san chey inmat isnan tinapay tay sisya'y enkenteg nan olocha. ");
INSERT INTO lbk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Intot-oloy cha ay inmey is chemangna ya inomchan cha isnan ili ay Genesaret. Sa cha't padchakalen nan fangka. ");
INSERT INTO lbk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Inmatonan kannay nan takho ischi si Jesus isnan osto ay finmalaancha is kafangka, ");
INSERT INTO lbk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","sa cha't waschin tatagtag ay cha en nenkorchag isnan olay entona ischi ay ili ta iyeycha ken Jesus nan nenkasakit ay maiyaamaka ay iyonodcha ken siya isnan olay entona ay kawadna. ");
INSERT INTO lbk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Et olay mo entona nan inmayana, fanan-ig paymo chadchake ay ili, paymo id ilit, inyeycha nan masasakit isnan kamarkitan, sa cha't nenseg-ang ken siya ta sikchochencha olay paat yangkhay nan khayachan nan fachona. Et am-in ay nanikchod ken siya et naipagkhawis cha. ");
INSERT INTO lbk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Issan namingsan naam-among ken Jesus nan Fariseo ya nan tapina ay mistolon si lenteg ay nalpo id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Inilacha ay lawa nan inangnen nan tapina'y disipolos Jesus tay egaycha ona nenfolo isnan nanganancha. ");
INSERT INTO lbk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tay nan Fariseo ya am-in nan Judio et sok-ed cha enfolo sa cha mangan, tay siya chi nan winanedcha ay ekhad nan ikik-itcha id solit. ");
INSERT INTO lbk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ya mo nalpo cha is kamarkitan, ad-i cha paat mangan engkhana'y iyangnencha ona nan ekhadcha ay mawarsiyan isnan chanom. Angsan kayet ay ekhad nan iyangneangnencha, kag isnan menwarsiyancha isnan tasa, fanga, ya nan tapina kayet ay nakhaeb ay khanfang, ya nan tokchowancha.) ");
INSERT INTO lbk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sa et pinoot nan cheycha'y Fariseo ya mistolon si lenteg ken Jesus ay mangwanin, “En man ad-i abfoloten nan disipolosmo nan mawanwaned ay ekhad nan ikik-it tako ay? Ya ke pet lawa nan angnencha tay ad-i cha enfolo ona sa cha't mangan.” ");
INSERT INTO lbk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sa et kanan Jesus, “Chakayo ay kakas-okas-on, tet-ewa san inpadton Isaias maipoon ken chakayo. Insolatna ay mangwanin, ‘Siya na nan kanan Apo Dios: “Nan naycha ay takho et chad-ayawencha sak-en isnan topekcha ngem adchawi nan semekcha ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ongar yangkhay nan chomad-ayawancha, tay en cha isos-olo nan lenteg si takho ay siya kano chi nan sos-olon Apo Dios.” ’ ");
INSERT INTO lbk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ngag ngotoyo isnan filin Apo Dios ya mamangset kayo isnan ekhad si takho ay winanedyo.” ");
INSERT INTO lbk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kinwanina kayet, “Khawis met nan ikkanyo ay mangad-i isnan filin Apo Dios ta nan et ekhadyo nan somya ay en yo pawadwad-en. ");
INSERT INTO lbk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tay infilin Moises, ‘Patkhenyo nan amayo ya inayo,’ ya ‘Mo sino nan mangipangaag isnan amana paymo inana, et masapol ay maipapatey.’ ");
INSERT INTO lbk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngem teken nan kananyo. Tay mo wad-ay nan mangwani isnan amana paymo inana, ‘Chey. Korban et nan ento mo ifachangko ken chakayo’ (nan laychena ay kanan et naichowa et ken Apo Dios), ");
INSERT INTO lbk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","itan-oyyo, ya ipawayo siya ay mamachang ken amana ya inana. ");
INSERT INTO lbk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Et khapo isnan sana ay ekhadyo ay ipafanesyo, maichenyo nan kalin Apo Dios. Ya angsan kayet nan kag tonacha ay cha yo ik-ikkan.” ");
INSERT INTO lbk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Inayakhan kasin Jesus nan takho, ya kinwanina ken chaicha, “Chengngenyo na, am-in kayo, ta maawatanyo. ");
INSERT INTO lbk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Faken nan ikamil nan takho is katopekna nan mangipangaag ken siya, mod-i ket nan fomala ay malpo isnan semekna. ( ");
INSERT INTO lbk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Chengngenyo et mampay na mo wad-ay kowengyo ay mannge!)” ");
INSERT INTO lbk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Osto'y tinaynan Jesus nan cheycha'y takho ya sinomkhep is afong, pinoot nan disipolosna mo ngag nan ayen nan chey ay al-aligna. ");
INSERT INTO lbk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sa na't kanan, “Olay akhes ngen chakayo ya ad-iyo maawatan? Ay ke yo ad-i paat maawatan ay faken nan ikamil nan takho nan mangipangaag ken siya? ");
INSERT INTO lbk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tay faken is kasemekna nan somkhepan nan maikamil mod-i ket is kapotona sa et fomala ay maitai.” (Nan laychen Jesus ay kanan isnan chey ay kinwanina et, maid makakan is mangipangaag isnan takho.) ");
INSERT INTO lbk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sa na't kinwani kayet, “Nan fomala isnan takho nan mangipangaag isnan takho. ");
INSERT INTO lbk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tay malpo isnan otekna ya nemnem nan ngaag ay semek, nan asi ay okhali, akew, patey, nan menchwadchwa isnan pantewna, ");
INSERT INTO lbk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nan kinaakhom, apos, sailo, is yangkhay ay asi ay fikhaw, apal, pangaag, chayew ya inoong-ong. ");
INSERT INTO lbk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Am-in nan naycha ay ngaag et malpo cha isnan semek si takho. Siya chana nan mangipangaag ken siya.” ");
INSERT INTO lbk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sa et naligwat si Jesus sidi ya kinmaan ay omey isnan sakop nan ili ay Tiro ya Sidon. Inmey nentee isnan esang ay afong ischi, ya ad-ina laychen ay maammowan nan kawadna, ngem khechangna'y naammowan kayet. ");
INSERT INTO lbk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nan esa'y fafai ay naan-anitowan nan anakna ay fafai et chinngena nan maipoon ken siya, ya inmey kannay isnan kawadna. Sa na't ala ya lokfob isnan sakhang Jesus ");
INSERT INTO lbk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ay nangiseg-ang ta pakaanena nan anito ay inomchan isnan anakna. Nan chey ay fafai et Gentil ay Griego nan kalina ya nalpo id Fenisia ay esa'y ili id Siria. ");
INSERT INTO lbk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ya ket kinwanin Jesus, “Masapol ay mapangan ona nan ongang-a ay pangafong, tay ad-i osto mo aped alaen nan kanen nan an-ak sa et ibkas isnan aso.” ");
INSERT INTO lbk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ngem kinwanina kayet, “Tet-ewa nan kanam Apo, ngem olay siya chi, khechangna ay kanen nan aso ay wad-ay is khwab nan lamisaan nan makakan ay yagyakhen si ongang-a.” ");
INSERT INTO lbk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kinwanin et Jesus ken siya, “Osto met. Tay siya sa nan kanam, chey inpeg-anan et nan anito nan anakmo. Somaa ka't.” ");
INSERT INTO lbk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sa et sinmaa, ke na't inchanan nan anakna ay maseyseyep, ya tinaynan tet-ewa nan anito. ");
INSERT INTO lbk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kinmaan si Jesus id Tiro, ya inikwana id Sidon ya nan sakop nan Sinpoo ay Ili engkhana ay inomchan isnan fayfay id Galilea. ");
INSERT INTO lbk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Idwani, inyeycha ken siya nan lalaki ay natoweng ya nangengek. Sa cha't nenseg-ang ken Jesus ta ipatangna nan limana ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Initken Jesus nan chey ay lalaki isnan cheycha'y angsan ay takho, sa na't inpey nan lechengna isnan kowengna. Sa et nentobfa ay nangikappos isnan chilan nan lalaki. ");
INSERT INTO lbk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nentangad id chaya ya nenfon-es ay nen-achawag, sa na't kanan isnan lalaki, “Efata,” ay nan laychena ay kanan et, “Makadnge ka.” ");
INSERT INTO lbk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ket ay nakadnge kannay san lalaki ya nawayaan nan chilana, et nalatak chadlo nan enkak-aliyana. ");
INSERT INTO lbk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sa et finilin Jesus chaicha ta ad-icha og-okhochen, ngem isnan chadlos na mangiyad-ad-iyan isnan mangog-okhochancha, onanig cha kayet inokhookhod. ");
INSERT INTO lbk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chachama'y nataataa nan takho ischi ay mangwanin, “Khawis am-in nan ik-ikkana, tay olay nan natoweng, pakhawisena, ya nan nangengek, pakaliyena akhes.” ");
INSERT INTO lbk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Isnan namingsan, naamoamong kasin nan angsaangsan ay takho ken Jesus, ya maid et kanencha. Sa na't ayakhan nan disipolosna ya kinwanina, ");
INSERT INTO lbk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maseg-ang ak isnan naycha'y takho, tay tolo et ay akhewcha ken sak-en, ya nangkhay et nan sengetcha. ");
INSERT INTO lbk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mo ipasaak chaicha ay maoowat, at maolaw cha isnan chalan, tay adchawi nan somaalan nan tapina.” ");
INSERT INTO lbk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sa et kanan nan disipolosna, “Ento kay nan omalaan tako isna's kaponchag is sa tako ipangan isnan kag tona ay kaangsan si takho?” ");
INSERT INTO lbk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sa na't kanan, “Kaat nan wad-ay sisa ay tinapay?” “Pito,” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Inpatokchon Jesus nan angsan ay takho is kalota, sa na't inala nan pito ay tinapay, ya osto ay nenyaman ken Apo Dios pinetpet-angna sa na't inchowa isnan disipolosna ay mangiwalas isnan takho. Sa cha't nawalawalasan. ");
INSERT INTO lbk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wad-ay akhes ken chaicha nan akit ay filis. Nenyaman si Jesus ken Apo Dios, sa na't infilin ta maiwalas akhes isnan takho. ");
INSERT INTO lbk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nangan cha't ya negsan cha, ya nan nakhayad ay tinapay ay cha chinakhop nan disipolosna et pito ay nenkapno ay labfa. ");
INSERT INTO lbk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nan filang nan nangan ay takho et omey si epat lifo cha. ");
INSERT INTO lbk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Inpasaan et Jesus nan cheycha'y takho, sa cha't nenfangka kannay isnan disipolosna ay inmey isnan sakop nan ili ay Dalmanuta. ");
INSERT INTO lbk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Idwani, wad-ay cha nan Fariseo ay inmey nakisodsochok ken Jesus ta tepngencha siya. Infaagcha ta en-ipaila siya is katataa ay sinyal ay malpo id chaya. ");
INSERT INTO lbk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chadlos ay nenfon-es si Jesus sa na't kanan, “En man nan sinyal nan chadlos kedchakedchawen nan takho idwani ay? Tet-ewa nan kanak ken chakayo, maid ipailak ay sinyal isnan takho ay matatakho idwani.” ");
INSERT INTO lbk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sa na't tinaynan chaicha ya nenfangka ay omey is chemangna. ");
INSERT INTO lbk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Idwani, nalichongan nan disipolosna ay nannget is tinapay. Kecheng nan es-esa'y tinapay nan wad-ay is kafangka. ");
INSERT INTO lbk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Finagfag-an Jesus chaicha ay nangwanin, “Ilaenyo ta meymey-anyo nan awakyo isnan fofod nan Fariseo ya nan fofod Herodes.” ");
INSERT INTO lbk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ket ay natotya nan disipolosna ay mangwanin, “Kanana chi tay egay tako nannget si tinapay.” ");
INSERT INTO lbk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Idwani tay ammon Jesus nan cha cha kankanan, kinwanina, “Ngag man nan kasin yo kanakanan isnan egayyo nanngetan? Ad-iyo ngen kayet ammo paymo maawatan? Sisya'y enkenteg ngen nan oloyo? ");
INSERT INTO lbk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ay ke maid matayo ay mangila paymo kowengyo ay mannge? Ya ad-iyo ngen sesemken ");
INSERT INTO lbk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","san nametpet-angak isnan lima'y tinapay ya inmanay isnan liman lifo ay takho? Kaat ay labfa nan pinnoyo isnan tinapay ay nakhayad?” Sa cha't kanan, “Sinpoo ya chwa.” ");
INSERT INTO lbk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kinwanin Jesus, “Ya san pito ay tinapay ay inmanay isnan epat lifo, kaat ay labfa nan pinnoyo isnan nakhayad?” Sa cha't kanan, “Pito.” ");
INSERT INTO lbk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kinwanin et Jesus, “Ay ad-iyo ngen kayet maawatan?” ");
INSERT INTO lbk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Issan inomchanan cha Jesus id Betsaida, wad-ay nan inyey nan takho ken siya ay nakolap. Sa cha't inseg-ang ken Jesus ta egnana siya. ");
INSERT INTO lbk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pinachang Jesus sa na't infala isnan chey ay ili. Tinobfaana nan matana sa na't inpatang nan limana ken siya ay nangwanin, “Ay wad-ay ngen ilaem?” ");
INSERT INTO lbk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nen-ila san nakolap ya kinwanina, “Wad-ay cha nan ilaek ay takho, ngem kag cha kaew ay manmanalan.” ");
INSERT INTO lbk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kinappos kasin Jesus nan matana, ya nenfongag ay osto, ket ay makaila chadlo. Et nalatalatak nan mangil-ana isnan am-in. ");
INSERT INTO lbk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sa et inpasaan Jesus siya ay mangwanin, “Ad-im ik-ikwan isnan ili ay somaa.” ");
INSERT INTO lbk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sa et inmey kayet cha Jesus ya nan disipolosna isnan kailiili id Cesarea Filipos. Isnan manad-alanancha, kinwanina isnan disipolosna, “Sino ak isnan semek nan takho?” ");
INSERT INTO lbk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sa cha't kanan, “Wad-ay cha nan mangwanin sik-a si Juan Bautista. Nan tapina akhes kanancha ay sik-a si Elias, ya wad-ay cha kayet nan mangwanin esang ka isnan tapina ay mamadto.” ");
INSERT INTO lbk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sa na't kanan, “Chakayo kay, sino ak isnan semekyo?” Sa et kanan Pedro, “Sik-a nan Cristo.” ");
INSERT INTO lbk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sa na't finilin chaicha ta ad-icha ifab-aag isnan olay sino nan maipoon ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sa et insolon Jesus ken chaicha ay mangwanin, “Sak-en ay Anak si Takho et masapol ay maipap-alikhat ya maad-i ak isnan amam-an si Judio, nan aap-apon si papachi, ya nan mimistolon si lenteg. Sak et maipapatey, ya isnan ikatlo ay akhew et kasin ak fomangon.” ");
INSERT INTO lbk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Osto ay inlatlatak Jesus chi, inik-ak Pedro siya ya yinangyangana. ");
INSERT INTO lbk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngem issan nensakhongan Jesus ken siya ket ay inilana nan cheycha'y disipolosna, ya yinangyangana si Pedro ay nangwanin, “Komaan ka Satanas! Tay faken nan nemnem Apo Dios nan semsemkem mod-i ket nan nemnem si takho.” ");
INSERT INTO lbk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sa et inayakhan Jesus nan angsan ay takho ya nan disipolosna, ya kinwanina ken chaicha, “Mo sino nan menlayad ay maifoweg ken sak-en, masapol ay lichongana nan awakna, awitena nan kolosna, ya maifoweg ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tay mo sino nan ad-i mangayyew isnan fiyagna ta olay matey midkakay ken sak-en ya isnan Khawis ay Chamag, at maisalakan. Ngem nan takho ay chadlos mangisalak isnan fiyagna et khechangna ay amasena. ");
INSERT INTO lbk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ay ke wad-ay fongaen nan takho olay mo kowaena am-in nan wad-ay isnan lofong, ngem maid fiyagna ay eng-engkhana? ");
INSERT INTO lbk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ay ke wad-ay kasin sa issakan nan takho isnan naamas ay fiyagna? ");
INSERT INTO lbk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nan takho idwani, ad-icha paat kaaafolot ken Apo Dios, ya ngaag nan wad-ay ken chaicha. Mo wad-ay mabfain ay mangitakcheg ken sak-en ya nan sos-olok, siya akhes ay mabfain ak ay Anak si Takho ay mangitakcheg ken siya is omaliyak isnan katangtangachan Ama ya nan mangifowekhak isnan nasantowan ay angheles.” ");
INSERT INTO lbk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kinwanin kayet Jesus, “Tet-ewa kanak ken chakayo, wad-ay ken chakayo isna nan at ad-i mangippeng isnan etey engkhana ay ilaencha nan kamabfalin nan en-ap-apowan Apo Dios ay inmali.” ");
INSERT INTO lbk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kakwasan nan enem ay akhew, intakin Jesus si Pedro ya cha Santiago ken Juan ya nakekecheng cha ay nanikid isnan esang ay at-atakchag ay filig. Ket ay tinmeken nan ilan Jesus isnan sakhangcha. ");
INSERT INTO lbk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Somili nan fachona ya enpoksasaat. Maid isnan nay lofong nan olay sino issa ay makaipapokaw isnan facho ta kag nan kapokaw nan fachona. ");
INSERT INTO lbk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ke cha't inila cha Elias ken Moises ay cha makitot-oya ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sa et kinwanin Pedro ken siya, “Apo, khawis pet nan wad-ayan tako isna. Khomaeb kami is tolo ay ab-afong, enkwam nan esang, kwan Moises nan esang, ya kwan akhes Elias nan esang.” ");
INSERT INTO lbk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tay ad-ina ammo nan kankanana khapo isnan chad-ama ay egyatcha. ");
INSERT INTO lbk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sa et wad-ay nan lifoo ay nangap-ap ken chaicha, sa cha't chinnge nan kali ay nalpo is kalifoo ya mangwanin, “Siya na nan laylaychek ay Anakko. Chengngenyo siya!” ");
INSERT INTO lbk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sa cha't ala ya monaang, ya maid et inilacha ay ib-acha mod-i ket kecheng et yangkhay si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Issan cha cha pomannachan is kafilig, finilin Jesus chaicha ta ad-icha ifab-aag isnan olay sino nan inilacha, engkhana ay sok-ed ona kasin fomangon siya ay Anak si Takho isnan etey. ");
INSERT INTO lbk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Adi kad iniigtocha yangkhay chi is kasemekcha, ngem nen-asisalodsodcha mo ngag nan ayen nan fomangonan isnan etey. ");
INSERT INTO lbk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sa cha't sinalodsod ken Jesus, “En man kanan nan mimistolon si lenteg ay masapol ay mang-ona ay omali si Elias ay?” ");
INSERT INTO lbk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sa na't kanan, “Tet-ewa'y mang-ona si Elias ay omali ta nongnongena nan am-in. Ngem ngag kay nan naisolat maipoon ken sak-en ay Anak si Takho ay mangwanin masapol ay ilikhalikhatko nan chadlos sikhab ya sak et malayosan? ");
INSERT INTO lbk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngem kanak ken chakayo ay apchas et inmali si Elias, ya inangnencha nan olay ngag sisa ay laychencha ay angnen ken siya, ay maiyafoloy isnan naisolat maipoon ken siya.” ");
INSERT INTO lbk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Issan tinmoliyan cha Jesus isnan kawad nan tapina ay disipolosna, inilacha ay angsaangsan nan takho ay mangaalifongfong ken chaicha, sa et nan mimistolon si lenteg ay cha nakisodsochok ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nataataa nan cheycha'y takho isnan nangil-ancha ken Jesus, sa cha't nentatagtag ay en manot-oya. ");
INSERT INTO lbk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sa et kinwanin Jesus, “Ngag man nan maangang-aanyo?” ");
INSERT INTO lbk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ket ay sinmongfat nan esang ken chaicha ay mangwanin, “Mistolo, inyalik nan fab-alok ken sik-a, tay sinkhep si nangengek ay anito siya. ");
INSERT INTO lbk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ya mo chakhos segpen nan anito siya, et pen ifasfasna, ya omos-osab nan topekna sa et komalkaletket nan fab-ana ya komenkenteg. Kinchawko isnan disipolosmo ta pakaanencha nan chey ay anito ngem ad-icha kafaelan.” ");
INSERT INTO lbk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kinwanin et Jesus, “Chakayo ay maid pammatina! Ay kek sa makitetetetee ken chakayo? Kaatna pan nan sak mangan-an-anosan ken chakayo? Yaiyo isna.” ");
INSERT INTO lbk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sa cha't inyey ken siya nan chey ay fab-alo, ya osto ay inilan nan chey anito si Jesus, nenpapayagpakhena nan fab-alo sa et natokang ya nenkok-olipagpag ay cha en-os-osab nan topekna. ");
INSERT INTO lbk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sa et pooten Jesus ken amana, “Kaatna nan nenlapowan nan kag tona ay sakitna?” Sa et kanan amana, “Issan sisya'y kaongana. ");
INSERT INTO lbk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kad-in ifasfasna siya is kaapey ya is kadchanom ta pateyena. Ngem mo way mabfalin si ikkam, pangngaasim ta someg-ang ka ya fomachang ka.” ");
INSERT INTO lbk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kinwanin et Jesus, “Em man kanan en mo way mabfalin si ikkak ay? Maid ad-i mabfalin ay ikkan nan wad-ay pammatina.” ");
INSERT INTO lbk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ket ay nabfanokhaw kannay nan aman nan fab-alo ay mangwanin, “Mamati ak, ngem kolang. Fomachang ka koma ta fomikas nan pammatik!” ");
INSERT INTO lbk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Issan nangil-an Jesus ay cha entagtag nan angsan ay takho ay cha maamong, insag-okna nan anito ay mangwanin, “Sik-a'y anito ay nangipangengek ya nanoweng ken siya, filinek sik-a ta taynam siya ya ad-i ka kasin somsomkhep ken siya.” ");
INSERT INTO lbk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ket ay inpawakis ya inpapayagpag nan anito nan fab-alo sa et nabfanala ken siya. Et kag natey nan ilan nan fab-alo. Sa et angsan nan nangwanin, “Anay, natey.” ");
INSERT INTO lbk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngem ket ay inalan Jesus nan limana ay namangon ken siya, ya tinmakcheg. ");
INSERT INTO lbk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Issan sinmaalan cha Jesus ya nakekedchengancha isnan disipolosna isnan afong, pinootcha ken siya ay mangwanin, “En kami man ad-i tet-ewa makaipafala ay?” ");
INSERT INTO lbk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sa et kanan Jesus, “Maid makaipafala isnan kag todi ay ilan si anito mo ad-i esten ay enlowalo.” ");
INSERT INTO lbk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kinmaan cha Jesus ischi et inikwancha id Galilea. Ad-ina laychen ay ammon nan takho nan kawadcha, ");
INSERT INTO lbk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tay cha na isos-olowan nan disipolosna. Kinwanina, “Nay et maichowa ak ay Anak si Takho isnan kamabfalin nan takho ay sa mamatey ken sak-en. Ngem isnan maikatlo ay akhew, at kasin ak matakho.” ");
INSERT INTO lbk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nay met achi egaycha naawatan nan kinwanina, ya omegyat cha ay kasin mamoot ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sa et inomchan cha Jesus id Capernaum, ya issan wad-ayancha is kaafong kinwanina isnan disipolosna, “Ngag ta nan cha yo ap-appaten is kachalan?” ");
INSERT INTO lbk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngem aped cha finofomtog tay nan cha cha natottotyaan is kachalan et maipoon isnan mo sino ken chaicha nan katotongchowan. ");
INSERT INTO lbk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tinmokcho si Jesus sa na't ayakhan nan sinpoo ya chwa'y disipolosna ya kinwanina, “Mo sino nan menlayad ay siya nan omon-ona et masapol ay ifafan-igna nan awakna ta enkotit ya ensilfi isnan am-in ay ib-ana ay takho.” ");
INSERT INTO lbk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sa et inayakhan Jesus nan esang ay ong-onga ya inpatakchegna isnan sakhangcha. Sa na't sakloyen ay mangwani ken chaicha, ");
INSERT INTO lbk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mo sino nan manawat isnan esa'y ong-onga ay kag tona maigkhapo ken sak-en, et sak-en nan chawatena. Ya mo sino nan manawat ken sak-en, faken yangkhay sak-en nan chawatena mod-i ket chawatena akhes nan nangifaa ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sa et kinwanin Juan, “Mistolo, wad-ay nan inilami ay cha mangipakaan isnan anito maichalan isnan ngachanmo, ya inpawami tay faken tako foweg.” ");
INSERT INTO lbk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngem kinwanin Jesus, “Ad-iyo aped ipawa siya, tay nan mangangnen isnan kamabfalin isnan ngachanko et ad-i mabfalin ay pangaakhena kannay sak-en. ");
INSERT INTO lbk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tay mo sino nan ad-i manopla ken chatako et wad-ay cha ken chatako. ");
INSERT INTO lbk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tet-ewa kanak ken chakayo, mo sino nan mangipainom ken chakayo is olay sintastasa ay chanom tay takhon Cristo chakayo, et masobfalitan ay masobfalitan siya.” ");
INSERT INTO lbk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kinwanin kayet Jesus, “Mo sino nan enkhapowan nan fomasolan nan olay esang isnan naycha'y ongang-a ay mamati ken sak-en, et khagkhag-awis yangkhay mo maitaked is kafakhangna nan chakchake ay losong ay fato, sa et maiwasit is kafayfay. ");
INSERT INTO lbk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Et mo nan sana ay limam nan khotokna's enfasolam, pen potlongmo. Khakhag-awis si matormochan ka, mo ket maitapi ka isnan fiyag ay eng-engkhana, mo nan sisya'y chwa nan limam sa ka't omey id inferno isnan apey ay ad-i kaad-achep. ");
INSERT INTO lbk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Ya mo nan sana ay sikim nan khotokna's enfasolam, pen potlongmo. Khagkhag-awis si napilay ka, mo ket maitapi ka isnan fiyag ay eng-engkhana, mo nan sisya'y chwa nan sikim, sa ka't maiwasit id inferno. ");
INSERT INTO lbk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Ya mo nan sana ay matam nan khotokna's enfasolam, pen loknatam. Khagkhag-awis si olay esang nan matam ay maitapi isnan en-ap-apowan Apo Dios mo nan sisya'y chwa nan matam ya maiwasit ka id inferno ");
INSERT INTO lbk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ay ad-i katkatey nan fikhis ay mangmangan ken chaicha ya ad-i kaad-achep nan apey.” ");
INSERT INTO lbk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tay am-in ay takho et maitneb cha isnan apey ay maiyalig isnan likhat. ");
INSERT INTO lbk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Khawis nan asin, ngem mo mamaid nan aklitna, ngag kasin nan ikkana ay maiyasin? Ilaenyo et mampay ta maaasinan kayo, ta ad-i tomamnay, ya ilaenyo ta maiyornos kayo isnan ib-ayo.” ");
INSERT INTO lbk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sa et kinmaan cha Jesus id Galilea ya inikwan cha isnan sakop nan Judea sa cha't khomchang isnan wanga ay Jordan. Ket ay kasin napnap-on nan angsan ay takho ken siya. Sa na't insos-olowan chaicha ay kag isnan sikhod ay ang-angnena. ");
INSERT INTO lbk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sa et wad-ay cha nan Fariseo ay inmey ay maneptepeng/mamadpachas ken siya. Kinwanicha, “Ay ipalofos ngen nan lenteg tako ay ichangen nan lalaki nan asawana?” ");
INSERT INTO lbk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sinmongfat si Jesus ay nangwanin, “Ngag nan infilin Moises ken chakayo?” ");
INSERT INTO lbk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sa cha't kanan, “Inpalofos met Moises ay mo ichangen nan lalaki nan asawana, et khab-ena ona nan kasolatan maipoon isnan en-ichangancha, sa na't ipakaan siya.” ");
INSERT INTO lbk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kinwanin et Jesus, “Nan magtek yangkhay kinaweweyo nan khotok nan nangisolatan Moises issa ay filin. ");
INSERT INTO lbk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ngem issan laplapona ay nangab-ana isnan ngonon, ‘khinaeb Apo Dios nan takho ay lalaki ya fafai.’ ");
INSERT INTO lbk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Tay siya chi, masapol ay taynan nan lalaki nan amana ya inana ta en maiyamong isnan asaw-ena, ");
INSERT INTO lbk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","et enfalin cha ay esang ay awak.’ Adi kad faken cha et chwa mod-i ket es-esang cha. ");
INSERT INTO lbk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nan et mampay nen-amongen Apo Dios, maid kalebfengan nan takho ay mangipaichang ken chaicha.” ");
INSERT INTO lbk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Issan kawadcha is kaafong, kasin pinoot nan disipolosna nan maipoon isnan kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sa na't kanan ken chaicha, “Mo wad-ay lalaki ay mangichang isnan asawana sa et omasawa is teken, et chwadchwaena nan pantewna. ");
INSERT INTO lbk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Siya akhes isnan fafai, mo ichangena nan asawana sa et mangasawa is teken, chwadchwaena nan pantewna.” ");
INSERT INTO lbk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Idwani, wad-ay cha nan tapina ay nangiyey isnan ongang-a ken Jesus ta egnana chaicha. Ngem ket ay sinosonget nan disipolosna chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Osto'y inilan Jesus, sinmonget, ya yinangyangana nan disipolosna, “Ogkhayenyo nan ongang-a ay omali ken sak-en. Ad-iyo ipap-awa chaicha. Tay nan kag tosacha ay takho nan maitapi isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tet-ewa kanak ken chakayo, nan ad-i manawat isnan en-ap-apowan Apo Dios kag isnan angnen nan ong-onga ay manawat, at ad-i maitapi.” ");
INSERT INTO lbk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sa na't sinakloy chaicha ya inpatangna nan limana ken chaicha ay namindisyon ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Issan cha maligwatan Jesus ay kasin enfaatana, nentagtag ken siya nan esa'y lalaki ya nenfalintomeng isnan sakhangna. Sa na't kanan, “Khawis ay Mistolo, ngag man nan masapol ay angnek ta tawichek nan fiyag ay maid pengpengna?” ");
INSERT INTO lbk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sa et kanan Jesus, “Ngag man nan mangwaniyam en khawis ak? Ad-i ngen maid khawis mod-i yangkhay si Apo Dios? ");
INSERT INTO lbk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ammom met nan cheycha'y filina: Ad-i ka enpatey; Ad-im chwadchwaen nan pantewmo; Ad-i ka mangakew; Ad-i ka en-engag ay enpangaag isnan ib-am; Ad-i ka entokong; Patkhem cha amam ken inam.” ");
INSERT INTO lbk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ket ay sinmongfat nan lalaki ay nangwanin, “Mistolo, inkaong-ongak met ay nangang-angnen am-in issacha ay filin.” ");
INSERT INTO lbk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Insisin-eng Jesus siya ya chadlos nalaychan ken siya. Sa na't kanan, “Wad-ay nan esang kayet ay kolangmo. Engka ilako nan wad-ay ken sik-a ta sam et ichowa nan lakona isnan maid mabfalincha, et wad-ay akonmo id chaya. Sa ka't omali ay maifoweg ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Siya chi ya ket ay chadlos sinmasanga nan lalaki khapo isnan kinwanin Jesus. Sa et kinmaan ay nenngongoyos tay chadlos nafaknang. ");
INSERT INTO lbk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nenmonaang si Jesus ay nangila isnan cheycha'y disipolosna ya kinwanina ken chaicha, “Chad-ama ay sikhab nan somkhepan nan faknang isnan en-ap-apowan Apo Dios!” ");
INSERT INTO lbk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nataa nan disipolosna isnan kinwanina. Ngem kinwanin kayet Jesus ken chaicha, “An-akko, chad-ama ay sikhab nan somkhepan isnan en-ap-apowan Apo Dios! ");
INSERT INTO lbk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Malanlanoy nan somkhepan nan kamelio isnan lokaw si kachayom, mo nan somkhepan nan faknang isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sa cha't nataataa ay mangwanin, “Mo siya sa, sino mampet nan maisalakan?” ");
INSERT INTO lbk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sa et insisin-eng Jesus chaicha ay mangwanin, “Maid kafaelan nan takho, ngem teken ken Apo Dios, tay kafaelana am-in.” ");
INSERT INTO lbk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kanan et Pedro, “Chakami kay, tinaynanmi met am-in nan wad-ay ken chakami ta maifoweg kami ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Wen,” kinwanin Jesus, “ya tet-ewa kanak ken chakayo, mo sino nan manaynan isnan afongna, aag-ina, inana, amana, an-akna paymo nan lotana midkakay ken sak-en ya nan Khawis ay Chamag, ");
INSERT INTO lbk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","at maminkhasot cha ay masobfalitan. Maagtan cha idwani ay matatakhowancha is angsan ay afong, aag-i, in-a, an-ak ya lota, ya maitapi cha akhes ay maipap-alikhat. At chawatencha kayet nan fiyag ay eng-engkhana isnan omali ay fiyag. ");
INSERT INTO lbk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ngem angsan cha nan omon-ona idwani, ay at enkotit. Ya angsan nan kotit ay at omon-ona.” ");
INSERT INTO lbk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Issan cha cha manikichan id Jerusalem, cha mamangpango si Jesus. Matatakag cha nan disipolosna, sa et omegyat nan cheycha'y omon-onod ken chaicha. Inayakhan et kasin Jesus nan sinpoo ya chwa ay disipolosna, sa na't ifaag ken chaicha nan sa maangnen ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kinwanina, “Nay manikid tako id Jerusalem, ay maichawchawak ay Anak si Takho isnan aap-apon si papachi ya nan mimistolon si lenteg. Ya at kedchengancha sak-en ay mangipapatey. Sa cha't ichowa sak-en isnan Gentil, ");
INSERT INTO lbk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ay at chomopichopis ya tomobfatobfa. Somaplisaplit cha akhes sa cha't pomatey. Ngem at matakho ak kasin isnan maikatlo ay akhew.” ");
INSERT INTO lbk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Idwani, inmey ken Jesus cha Santiago ken Juan ay an-ak Zebedeo ya kinwanicha, “Mistolo, wad-ay man nan laychenmi ay angnem koma ken chakami.” ");
INSERT INTO lbk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sa et kanan Jesus, “Ay ngag kan nan laychenyo ay angnek ay mamachang ken chakayo?” ");
INSERT INTO lbk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sa cha't kanan, “Mo tomokcho ka isnan katangtangacham, ipalofosmo ta patokchowem man nan esang ken chakami is kakannawanmo ya nan esang is kakannikhidmo.” ");
INSERT INTO lbk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngem ket ay kinwanin Jesus, “Ad-iyo ammo nan kedkedchawenyo. Makaikatpe kayo ngen isnan omali ay chad-ama'y likhatko? Makaikatpe kayo ngen isnan ilan si fonyag ay sak kafonyakhan?” ");
INSERT INTO lbk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Wen, makaikatpe kami,” insongfatcha. Sa et kanan Jesus, “Tet-ewa, at inaagyo nan chad-ama'y likhat ay kag ken sak-en, sa kayo't mafonyakhan isnan siya met laeng ay ilan si fonyag ay sak kafonyakhan. ");
INSERT INTO lbk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngem faken sak-en nan mangichowa isnan kalebfenganyo ay tomokcho is kakannawan ya kannikhidko, tay wad-ay et nan apchas naisagkhanaana.” ");
INSERT INTO lbk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Osto ay chinngen nan sinpoo ay disipolos nan maipoon sidi, linilikhetcha cha Santiago ken Juan. ");
INSERT INTO lbk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sa et inayakhan Jesus chaicha ay mangwanin, “Ammoyo nan okhalin nan cheycha'y en-ap-apo koma isnan cheycha'y Gentil. Palikhatencha nan iyap-apowancha. Olay nan cheycha'y okomcha et ipip-ilitcha nan kalebfengancha. ");
INSERT INTO lbk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngem faken siya sa ken chakayo, mod-i ket mo sino ken chakayo nan menlayad ay en-ap-apo, et siya koma nan ensilfi ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ya mo sino nan menlayad ay siya nan katongchowan, siya koma nan mafab-aa isnan olay sino. ");
INSERT INTO lbk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tay olay sak-en ay Anak si Takho et egay ak inmali ay masilfiyan, mod-i ket ta ensilfi ak isnan takho, ya ta ichowak nan fiyagko ay mensaka isnan ang-angsan.” ");
INSERT INTO lbk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sa et inomchan cha Jesus id Jerico. Issan kinmaanancha ischi isnan disipolosna naifofoweg nan chadlos angsan ay takho. Ya wad-ay nan nakolap ay enngachan si Bartimeo ay anak Timeo ay tomotokcho is kailit nan chalan ya enlimlimos. ");
INSERT INTO lbk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Osto ay chinngena ay si Jesus ay iNazaret nan lomal-aos, naneng na't ya fokhaw ay mangwanin, “Jesus ay Anak David, seg-angam sak-en!” ");
INSERT INTO lbk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sa et angsan cha nan nenyangyang ken siya ay cha mangipagkhinek. Ngem onanig na infokhaw, “Anak David, seg-angam sak-en!” ");
INSERT INTO lbk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tinomke si Jesus sa na't kanan, “Ayakhanyo siya.” Sa cha't ayakhan nan nakolap ay lalaki. Kinwanicha, “Pabfikasem nan semekmo. Maligwat ka tay cha na ayakhan sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ala na't ya kaan isnan kakhayna ya nalanigwat ay omey ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sa et kanan Jesus, “Ngag nan laychem ay ikkak ken sik-a?” “Apo,” kinwanina, “laychek man ay makaila ak kasin.” ");
INSERT INTO lbk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kinwanin et Jesus, “Somaa ka't mampay. Nan pammatim nan nangipagkhawis ken sik-a.” Ya ket kannay makaila, sa et nakion-onod ken cha Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Issan nganngani inomchanan cha Jesus id Jerusalem, ya wad-ay cha isnan ili ay Betfage ya Betania isnan filig ay Olivo, finaana nan chwa ay disipolosna ");
INSERT INTO lbk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ya kinwanina, “En kayo isnan sasakhangenyo ay ili, et mo somkhep kayo ischi at edchananyo kannay nan maitataked ay anak si dangki ay eg-ay kasaksakayan. Fadfachenyo nan talina ya iyaliyo. ");
INSERT INTO lbk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mo wad-ay mangwanin, ‘En yo man aped angnen sa ay?’ kananyo, ‘Masapol nan Apo nan nay,’ ya at ipalofosna kannay chi.” ");
INSERT INTO lbk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Inmey cha, et inchanancha tet-ewa is kakarsa nan anak si dangki ay maitataked is kapantew nan afong, sa cha't fadfachen nan silona. ");
INSERT INTO lbk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ket ay kanan nan cheycha'y entatakcheg ischi, “En yo man aped fadfachen sa ay?” ");
INSERT INTO lbk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sa cha't infakha nan kinwanin Jesus ay kanancha, ke cha't ay intan-oy. ");
INSERT INTO lbk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sa cha't inyey nan chey anak si dangki ken Jesus, ya inyap-apcha nan kakhaycha, et nensakay si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Angsan cha nan nangiyaplag isnan kakhaycha is kachalan. Nan akhes tapina et cha cha sinmipling is pingin si kaew is kailit nan chalan ya inyap-aplagcha is kachalan. ");
INSERT INTO lbk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sa et nan cheycha'y namangpango ya inmon-onod ken Jesus, et infogfokhawcha ay mangwanin, “Machad-ayaw ka! Bindisyonan Apo Dios sik-a ay omali ay mangitakcheg ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bindisyonan koma Apo Dios nan omali ay en-ap-apowan ikit tako ay David. Machad-ayaw nan Dios ay Katotongchowan!” ");
INSERT INTO lbk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Osto'y sinomkhep si Jesus id Jerusalem, inmey is kaTimplo ya minonaangna nan am-in ay wad-ay ischi. Sa cha't nenpaBetania isnan sinpoo ya chwa ay disipolosna, tay nganngani et ay maschem. ");
INSERT INTO lbk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Issan kawaksana, isnan cha cha tomoliyan ay malpo id Betania, ket ay naowat si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Inilana't nan kaew ay higos ay wad-ay isnan adchawi ay angsaangsan nan tofona. Sa et sinmag-en ay mangila mo wad-ay fekhasna, ngem maid paat inchanana is fekhasna mod-i ket nan tofona yangkhay, tay fakena timpo ay mamkhas. ");
INSERT INTO lbk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sa na't kanan, “Olay kaatna, at maid mangmangan sinan fekhasmo!” Chinngen nan disipolosna nan chey ay infakhana. ");
INSERT INTO lbk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Issan inomchanan cha Jesus id Jerusalem, sinomkhep isnan awwichan nan Timplo, sa na't ala ya soyog isnan wad-ay ay cha en-ilaklako ischi ya nan cha lomaklako. Finalintowagna nan lamisaan nan cheycha'y ensoksokat si siping, ya nan tokchowan nan cheycha'y en-ilaklako si kalopati. ");
INSERT INTO lbk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Inpawana nan en-aagto ya nan ensasakfat ay mangikwan is kaTimplo. ");
INSERT INTO lbk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sa na't insolowan chaicha ay mangwanin, “Ad-i ngen naisolat isnan kalin Apo Dios, ‘Nan afongko, et makwanin afong ay enlol-owalowan si takho ay nalpo isnan olay entona ay ili,’ ngem khinaebyo ay afong si mangaakew.” ");
INSERT INTO lbk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Issan nanngelan nan aap-apon si papachi ya nan mimistolon si lenteg isnan kinwanina, inyan-anapcha nan ikkancha ay mamatey ken siya. Tay omegyat cha ken siya khapo isnan isos-olona ay chadlos nangipataa isnan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Osto ay sedsechemna tinaynan cha Jesus nan ili. ");
INSERT INTO lbk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Issan kawiitana, linaosancha san kaew ay higos ya ket nalango, olay nan lamotna. ");
INSERT INTO lbk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sinmek et Pedro san kinwanin Jesus sa na't kanan, “Apo, ilaem kay ya! Nalango et nan chey kaew ay higos ay inpangaagmo!” ");
INSERT INTO lbk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sa et kinwanin Jesus, “Mamati kayo ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tet-ewa kanak ken chakayo, olay sino ay mangwani isnan nay ay filig, ‘Matan-ang ka ta maibkas ka is kafayfay,’ sa et ad-i enchwadchwa, mod-i ket patiyena ay maangnen ay maangnen nan kanana, et siya tet-ewa nan at maangnen. ");
INSERT INTO lbk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tay siya chi kanak ken chakayo, mo ngag issa nan kedchawenyo ken Apo Dios isnan enlowalowanyo, patiyenyo ay tet-ewa ay chawatenyo, ya at enkwayo. ");
INSERT INTO lbk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ya mo enlowalo kayo, ya ammoyo ay wad-ay sakit si semekyo isnan ib-ayo ay finmasol ken chakayo, pakawanenyo chaicha, ta pakawanen akhes Amayo id chaya nan fasolyo. ");
INSERT INTO lbk_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Nay met achi mo ad-iyo pakawanen, et akhes ad-i pakawanen Amayo id chaya nan fasolyo.)” ");
INSERT INTO lbk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Issan kasin inmayan cha Jesus id Jerusalem, ya wad-ay siya ay manad-alan is kaawwichan nan Timplo, inmey cha ken siya nan aap-apon si papachi, nan mimistolon si lenteg ya nan amam-an si Judio. ");
INSERT INTO lbk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Sa cha't kanan ken siya, “Ngag nan kalebfengam ay mangik-ikkan isnacha? Sino nan nangichowa isnan kalebfengam ay mangangnen issacha?” ");
INSERT INTO lbk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sa et kanan Jesus, “Salodsochek ken chakayo. Mo songfatanyo nan kanak, sak et akhes ifaag nan nalpowan nan kalebfengak ay mangangnen isnacha. ");
INSERT INTO lbk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Siya na nan salodsodko: ‘Sino nan nalpowan nan kalebfengan Juan ay mamonyag? Nalpo ngen ken Apo Dios paymo isnan takho?’ Ifaagyo!” ");
INSERT INTO lbk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sa cha't kanan ay natotya, “Mo kanan tako, ‘Nalpo ken Apo Dios,’ at kananan, ‘Ya ke yo mampay ad-i patiyen siya mo?’ ");
INSERT INTO lbk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngem ay ke tako akhes sa kanan, ‘Nalpo isnan takho?’ ” Tay omegyat cha isnan sa angnen nan katakhotakho, tay ifilangcha am-in ay tet-ewa ay mamadto si Juan. ");
INSERT INTO lbk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Adi kad kinwanicha't ken Jesus, “Ad-imi ammo.” Sinmongfat et akhes si Jesus ay nangwanin, “Ad-ik et akhes ifaag ken chakayo mo ngag nan kalebfengak ay mangangnen isnacha.” ");
INSERT INTO lbk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sa et inyal-alig Jesus ay nangisolo ken chaicha, “Wad-ay nan esa'y takho ay nenmola is ofas is kaomana, sa na't inalachan. Khinmaeb akhes is falliwes, sa et nan ab-afong ay entey-an nan enfelew. Sa na't inpasama ya nenfaat isnan teken ay ili. ");
INSERT INTO lbk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Osto ay timpon si pinagpopokhas, finaana nan en manot-oya isnan cheycha'y nannama ta alaena nan chatag nan apona. ");
INSERT INTO lbk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nay met achi alan et nan cheycha'y nangipasamalana ya faifaig ken siya, sa cha't aped inpakaan ay maid paat inalana. ");
INSERT INTO lbk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Idwani kasin finmaa is teken, ngem pinak-ocha nan olona ya inlayolayosancha. ");
INSERT INTO lbk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sa et finmaa kasin is esang, ngem ke cha't ay pinatey. Siya akhes nan inangnencha isnan angsan kayet ay finaana: finaigcha nan tapina ya nan tapina kayet pinateycha. ");
INSERT INTO lbk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Siya chi ya engkhana ay nan et yangkhay anakna ay kedkecheng ay laylaychena nan nakhayad. Ya ket ay siya et nan finaana tay kinwaninan, ‘At chadlo ibfaincha nan anakko.’ ");
INSERT INTO lbk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngem ket ay nan cheycha'y manamsama isnan ofasan, kanan cha't ay natotya, ‘Naay nan sa manawid. En tako pateyen ta enkwa tako nan tawidna.’ ");
INSERT INTO lbk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sa cha't inala ay namatey ya nen-ibkascha is kailitna.” ");
INSERT INTO lbk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sa et kinwanin Jesus, “Idwani, ngag et kay nan angnen nan nenkwa isnan ofasan isnan cheycha'y manamsama? At kanaali ay mamatey ken chaicha, sa na't ipabfanes nan omana isnan teken. ");
INSERT INTO lbk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ay egayyo ngen paat finasa nan naisolat ay kalin Apo Dios ay mangwanin, ‘Nan chadlos fato ay inad-in nan tomottoping, et siya nan nenfalin ay kapapatekhan ay fato isnan pegnadna. ");
INSERT INTO lbk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Siya sa nan chonon Apo Dios ya katataa ken chatako’?” ");
INSERT INTO lbk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Adi kad inanapcha nan ikkancha'y maniliw ken siya, ngem omegyat cha isnan katakhotakho tay ammocha ay chaicha nan kankanan Jesus isnan inyal-aligna. Tay siya chi tinaynancha si Jesus ya kinmaan cha. ");
INSERT INTO lbk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Sa cha't inpaeey ken Jesus nan tapina ay Fariseo ya nan ib-acha ay disipolos Herodes ta en cha sikapan ay maniliw ken siya isnan kankanana. ");
INSERT INTO lbk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Inmey cha sa cha't kanan, “Mistolo, ammomi ay osto ka. Ad-i ka mangiyoya isnan kankanan nan takho, ya maid pawadwad-em tay faken nan wad-ay isnan takho nan il-ilaem, mod-i ket tet-ewa ay isos-olom nan okhali ay laychen Apo Dios. Ibfakham ed mo ipalofos nan lenteg tako'y Judio nan enfayachan isnan fowis ken Cesar, paymo ad-i? ");
INSERT INTO lbk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Masapol ngen ay fayachanmi chi paymo ad-i?” Ngem tay ammon Jesus ay kakas-okas-on cha, kinwanina, “Ya ke kayo chadlos tomeptepeng/pomadpachas ay? Omyali kayo is siping ta ilaek.” ");
INSERT INTO lbk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Sa cha't inagtan ya kinwanina ken chaicha, “Sino nan nenkames ya nenngachan isnan wad-ay isna?” Sa cha't kanan, “Si Cesar.” ");
INSERT INTO lbk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kinwanin et Jesus, “Ichowayo et mampay ken Cesar nan lebfengna'y enkwa, ya ken Apo Dios nan lebfengna akhes ay enkwa.” Ke cha't ay nataataa isnan kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sa et wad-ay cha nan Saduceo ay en nangila akhes ken Jesus. (Chaicha nan ad-i mamati isnan kasin matakhowan nan matey.) Nensalodsod cha ken Jesus ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mistolo, wad-ay nan insolat Moises ay lenteg ta wanchen tako nan kag tona: ‘Mo matey nan inasaw-an ay lalaki ya maid anakna, masapol ay asaw-en nan akhina nan chey ay nailekkasan, ta enpawad-ay si anak nan akhina ay natey.’ ");
INSERT INTO lbk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Idwani, wad-ay nan pito ay sin-ag-i ay lallalaki. Inmasawa nan inaona, ya ket natey ay maid winad-ayna. ");
INSERT INTO lbk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sa et inasawan nan ikadwa nan chey ay nailekkasan, ngem natey akhes ay maid anakcha. Siya kayet akhes chi nan inmat isnan ikatlo engkhana ");
INSERT INTO lbk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","isnan ikapito. Natey cha am-in ay maid anakcha. Awni pay ya ket natey akhes nan chey ay fafai. ");
INSERT INTO lbk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Idwani, isnan chey ay akhew ay kasin matakhowan nan natey, sino nan osto ay asawana? Tay siya chi ay inasawan met nan pito ay sin-ag-i siya.” ");
INSERT INTO lbk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sa et sinomfat si Jesus ay nangwanin, “Ad-i ngen siya sa nan nenkamaliyanyo, tay ad-iyo ammo nan kalin Apo Dios paymo nan kamabfalina? ");
INSERT INTO lbk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tay mo kasin cha matakho isnan etey, at maid maasaswa paymo maipaasawa, mod-i ket kag cha isnan angheles id chaya. ");
INSERT INTO lbk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ya mo maipoon isnan kasin matakhowan nan natey, egayyo ngen finasa nan inpaisolat Apo Dios ken Moises maipoon isnan enfidfichang ay chapong? Kinwanin Apo Dios ken siya, ‘Sak-en nan Dios cha Abraham, Isaac ya Jacob.’ ");
INSERT INTO lbk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Laychena'y kanan en faken siya nan Dios si natey, mod-i ket Dios nan matatakho. Siya na nan kail-an nan nenkammaliyanyo.” ");
INSERT INTO lbk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Issan nanngelan nan esa'y mistolon si lenteg nan chey ay totyacha ya nakisodsochokancha, ya chinngena ay osto am-in nan insongsongfat Jesus, ket ay sinmag-en ken siya ya nensalodsod ay mangwanin, “Ngag nan kawedwedchaan ay filin?” ");
INSERT INTO lbk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sa et kanan Jesus, “Nan kawedwedchaan ay filin et siya na: ‘Chengngenyo ay Israelitas: Nan Apo ay Dios tako et siya yangkhay nan Apo. ");
INSERT INTO lbk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Masapol ay laylaychem nan Apo ay Diosmo isnan am-in ay wad-ay ken sik-a: nan posom, nan leng-agmo, nan semekmo ya nan fikasmo.’ ");
INSERT INTO lbk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nan ikadwa et siya na: ‘Masapol ay laylaychem nan ib-am ay takho ay kag isnan menlaycham isnan awakmo.’ Maid kasin wedwedwecha ay filin mo nan naycha.” ");
INSERT INTO lbk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sa et kinwanin nan chey mistolon si lenteg, “Osto sa, Mistolo. Tet-ewa nan kanam ay es-esang yangkhay nan Dios ya maid kasin teken mod-i siya yangkhay. ");
INSERT INTO lbk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Osto nan kanam ay masapol ay laylaychen tako siya isnan am-in ay wad-ay ken chatako: nan poso, nan semek ya nan fikas. Sa et masapol ay laylaychen tako nan ib-a ay takho ay kag isnan menlaychan tako isnan awak tako. Tet-ewa ay wadwad-ay chana ay angnen mo nan en-ichatonan ken Apo Dios isnan enkik-iwi ay mapoowan engkhana ay chomapo ya nan tapina kayet ay chaton.” ");
INSERT INTO lbk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Issan nangil-an Jesus ay khawis nan semekna ay nanongfat ken siya, kinwanina, “Nganngani ay maitapi ka isnan en-ap-apowan Apo Dios.” Makwas chi ya maid et kasin natoled ay ensas-alodsod ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Isnan namingsan ay cha en-isos-olo si Jesus is kaTimplo, kinwanina, “Ngag nan mangwaniyan nan mimistolon si lenteg ay nan Cristo et malpo isnan waned David? ");
INSERT INTO lbk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tay inischon nan Ispirito Santo ken David ay mangwani isnan kag tona maipoon isnan Cristo. Kinwanina, ‘Kinwanin nan Dios Apo isnan Apok, “Itokchom is kakannawanko engkhana ay ippeyko nan fosom ay enkhatkhatinam.” ’ ");
INSERT INTO lbk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Si kannay David nan nangwanin Apo ken siya ay Cristo. Tay siya chi, ngag kay nan ikkana ay anak David siya?” Et siya chi ay enlal-ayad nan katakhotakho ay nannannge isnan cha na infagfakha. ");
INSERT INTO lbk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Issan cha nen-isos-olowan Jesus kinwanina, “Ilaenyo ta en-annad kayo isnan mimistolon si lenteg, ay en yangkhay mangichalachalan isnan khag-awis ay anancho ay fachocha. Laychencha akhes ay maichad-ayaw is kamarkitan, ");
INSERT INTO lbk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","isnan kakhawisan ay tokchowan is kasinagoga, ya nan kaidchayawancha isnan tomokchowancha mo maayakhancha ay makikan. ");
INSERT INTO lbk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Maid ad-icha angnen ay en mensikasikap isnan cheycha'y nailekkasan ta mangal-ancha isnan afongcha. Sa cha't anchoanchowen nan lowalocha ta mafob-oya cha. At kadchacham-etan nan chosacha!” ");
INSERT INTO lbk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tinmokcho si Jesus isnan sakhang nan maipaypay-an si siping, ya finob-oyana nan angsan ay cha mangippey isnan sipingcha ischi. Inilana ay angsan cha nan fafaknang ay cha nangippey isnan ad-acha. ");
INSERT INTO lbk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sa et wad-ay akhes nan inmey ay nailekkasan ay maid mabmabfalina, ya inpeyna nan chwa ay tanso ay omey is sais yangkhay. ");
INSERT INTO lbk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sa et inayakhan Jesus nan disipolosna ya kinwanina ken chaicha, “Tet-ewa nan kanak, ad-ad-acha nan inpey nan naay ay posi ay nailekkasan mo nan inpey am-in nan tapina ay cha nen-ippey. ");
INSERT INTO lbk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tay inchowacha am-in nan sobla isnan ifaknangcha, ngem nan nay ay nailekkasan, olay mo maid mabfalina, inchowana am-in, am-in nan ikatakhona.” ");
INSERT INTO lbk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Issan finmal-an cha Jesus is kaTimplo, kinwanin nan esa'y disipolosna, “Mistolo, ilaem kay ya! Aye pay nan kinagkhawis nan sanacha'y fato ya nan nangnen nan afong ay nakhaeb!” ");
INSERT INTO lbk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sa et kanan Jesus, “Siya man, isin-engyo achi nan naycha'y chadchake ay afong. Ngem awni pa achi et maid paat olay esang is entotoon ay fato tay at maikoob cha am-iam-in.” ");
INSERT INTO lbk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nawni ya ket isnan tomotokchowan Jesus isnan filig ay Olivo ay chemang nan Timplo, inkekecheng cha Pedro, Santiago, Juan ya si Andres ay nensalodsod ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ibfakham ed mo kaatna nan sa kaomatan nan sanacha. Ngag nan kaimatonan nan sa maangnenan am-in nan naycha?” ");
INSERT INTO lbk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sa et kanan Jesus, “Ilaenyo mampay ta ad-i kayo masasailowan. ");
INSERT INTO lbk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Angsan cha nan fomala ay mangosar isnan ngachanko ay Cristo ya mangmangwanin, ‘Sak-en nan Cristo,’ ya at angsan nan sailowancha. ");
INSERT INTO lbk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Awni't chengngenyo nan chamag maipoon isnan khofat isnan ensag-en ya isnan adchawi. Ad-i kayo omeg-egyat, tay siya chadlo sa nan maangnen ay maangnen, ngem faken kayet sa nan mapengpengan nan lofong. ");
INSERT INTO lbk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tay at enfifinnaloknit ona nan kailiili, ya enkhogkhofat cha nan kaaliali, ya at wad-ay nan yekha isnan tapina ay ili ya wad-ay akhes fitil. Siya am-in chasa nan omat, kag isnan lapon nan ensikhafan nan fafai ay omaanak. ");
INSERT INTO lbk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ngem ilaenyo tay at iyeycha chakayo ay masomarya isnan amam-a. Saplitencha chakayo is kasinagoga, ya at ipatakchegcha chakayo ay masomarya isnan sakhang nan cheycha'y khofernachor ya ali midkakay ken sak-en. Et siya chi nan manistikhowanyo isnan kinatet-ewa maipoon ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ngem masapol ay maipalawag ona nan Khawis ay Chamag isnan olay entona issa ay ili. ");
INSERT INTO lbk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ngem mo tiliwencha ay en mangidchalom ken chakayo, ad-i kayo madchanakhan isnan sa yo kanan. Ifaagyo et yangkhay nan isolon Apo Dios ken chakayo isnan chey kannay ay olas, tay at faken chakayo nan enkali, mod-i ket nan Ispirito Santo. ");
INSERT INTO lbk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Siya akhes chana nan timpo ay mangipapateyan nan etad isnan akhina kannay, nan ama isnan anakna kannay, ya nan an-ak, at ipapateycha akhes kannay nan chakek-echa. ");
INSERT INTO lbk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","At liligten am-in nan takho chakayo khapo ken sak-en. Nay met achi mo sino ka issa ay makakatpe isnacha engkhana'y khifosna, et maisalakan ka.” ");
INSERT INTO lbk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Sa et kinwanin Jesus, “Ngem at ilaenyo nan kafokkawan nan nasantowan ay kawad Apo Dios khapo isnan kakkaisiw ay sinomkhep ya tomakcheg ischi ay ad-ina lebfeng ay entey-an. (Chakayo ay menfasa isna, et maawatanyo koma na.) Sa et chakayo ay wad-ay isna id Judea, lomayaw kayo is kafilig. ");
INSERT INTO lbk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nan wad-ay is kaatep nan afongna, ad-i kasin pomanad ay somkhep ay en mangilayaw isnan wad-ay isnan afongna. ");
INSERT INTO lbk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ya nan namoknag, ad-i kasin somaa ay en mangilayaw isnan nataynan ay fachona. ");
INSERT INTO lbk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Selaeg nan cheycha'y maliton ya nan enpasoso isnan tosacha ay akhew! ");
INSERT INTO lbk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ilol-owaloyo et mampay ta ad-i maigkhisan chana isnan lemlem. ");
INSERT INTO lbk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tay siya chasa nan akhew ay kaomatan nan likhat ay eg-ay kail-ila engkhana issan lapon nan nangab-an Apo Dios isnan lofong engkhana idwani. Et olay kaatna, at ad-i kasin maangnen nan kag tona. ");
INSERT INTO lbk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Inaptik Apo Dios nan filang nan cha omali ay akhew khapo isnan takhona ay sinmek ya pinilina. Tay mo ad-i, at maid paat makhayad si matatakho. ");
INSERT INTO lbk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Sa et mo wad-ay mangwani ken chakayo, ‘Chey, naay et nan Cristo!’ paymo kananchan, ‘Chey, wad-ay siya ischi!’ ad-iyo patpatiyen. ");
INSERT INTO lbk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","At wad-ay cha ay wad-ay nan fomala ay ad-i tet-ewa ay Cristo, ya nan ad-i tet-ewa ay mamadto, ya en-ipaila cha is sinyal ya nan katataa, ta mo mabfalin et masailowan nan takhon Apo Dios ay pinilina. ");
INSERT INTO lbk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngem ilaenyo, tay nay inyon-onak et ay mamagfakha ken chakayo isnan am-in.” ");
INSERT INTO lbk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kinwanin kayet Jesus, “Isnan chey magtek ay timpo, kakwasan nan timpon si likhat, at mamaid nan silaw nan akhew. Sa et mamaid nan langlang nan fowan, ");
INSERT INTO lbk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ya mekmekchag nan tokwifi. Ya at maid manongnong isnan wad-ay id tongcho tay at maiwegwewegweg cha. ");
INSERT INTO lbk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sa et chadlo ilaen nan katakhotakho sak-en ay Anak si takho ay omal-ali isnan lifoo isnan chachama ay kamabfalinko ya nan kalanglang nan chayawko. ");
INSERT INTO lbk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ya at ifaak nan anghelesko isnan olay entona isnan lofong, ta en cha amongen nan pinilin Apo Dios ay takhona isnan olay entona issa ay ili ay kawadcha.” ");
INSERT INTO lbk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sa et kinwanin Jesus, “Semsemkenyo nan wad-ay ay maachar isnan kaew ay higos. Mo chakhos somingi ya fomala nan tofona, ammoyo ay nganngani et nan chakhon. ");
INSERT INTO lbk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Siya akhes mo ilaenyo ay maangnen chana, ammoyo et ay nganngani nan omaliyak, ya kag ak et wad-ay is kapantew. ");
INSERT INTO lbk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tet-ewa kanak ken chakayo, at maangnen ay maangnen ona am-in chana esa pay mal-os nan takho ay wad-ay idwani. ");
INSERT INTO lbk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mamaid nan chaya ya nan lota, ngem nan kankanak et sisya is eng-engkhana ya ad-i enfab-aliw.” ");
INSERT INTO lbk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Intoloy Jesus ay nangwanin, “Ngem mo maipoon isnan omchanan nan chey ay akhew paymo olas, et maid mangammo, olay pay nan angheles id chaya paymo sak-en ay Anak, tay nan Dios Ama yangkhay nan mangammo. ");
INSERT INTO lbk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ilaenyo mampay, ensasakhana kayo. Tay ad-iyo ammo nan kaomatan nan naycha. ");
INSERT INTO lbk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nan kaiyalikhana et kag isnan lalaki ay enfab-aat. Italekna nan afongna isnan cheycha'y faana ay mangigwaana isnan waschin kalebfengancha ay chonnen. Ifilina akhes isnan khwarchiyana ta entotokkhong, sa et komaan. ");
INSERT INTO lbk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Siya akhes ay masapol ay ensasakhana kayo tay ad-iyo ammo nan sa kanatoliyan nan nenkwa isnan afong. Mabfalin ay sedsechemna, paymo tengan si lafi, paymo talan-o paymo isnan wiit. ");
INSERT INTO lbk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Entokkhong kayo, tay et lang awni ya lektat ay kaanali ya aspowana chakayo ay mamaseyep. ");
INSERT INTO lbk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nan kanak ken chakayo et kanak isnan am-in: Ensasakhana kayo.” ");
INSERT INTO lbk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chwa kayet ay akhew nan chaan esa pay omchan nan Piyastan si Paskua ya Piyastan nan Tinapay ay Egay Kabfofochan. Inyan-anap nan aap-apon nan papachi ya nan mimistolon si lenteg mo ngag nan ikkancha ay mangisikap ay maniliw ken Jesus, ta sa cha't ipapatey. ");
INSERT INTO lbk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kananchan, “Masapol ay faken isnan piyasta ay nay tay ta ket lang magkholo nan takho.” ");
INSERT INTO lbk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wad-ay cha Jesus id Betania isnan afong nan nakolit ay enngachan is Simon. Isnan mangmanganancha inmey ken siya nan fafai ay nangitakin isnan fotilya ay alabastro ay napno is nafanglofanglo ya chadlos kafalolan ya telen ay lana ay makwanin nardo. Ala na ya tekwab isnan fotilya sa na't nen-ifokfok is kaolon Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nay met achi wad-ay cha ischi nan sinmonget ay mangwani isnan ib-ana, “Ay ke ad-i ayyew nan chey ay lana? ");
INSERT INTO lbk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mailako pay chi is solok si tolon khasot ay denaryo, et maichowa isnan posi.” Sa cha't yinangyangan siya. ");
INSERT INTO lbk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngem ket ay kinwanin Jesus, “Ngag ngotoyo ken siya. En yo man pangayaen siya ay? Khawis nan inangnena ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tay wawawawad-ay cha nan posi ken chakayo, ya mabfalin ay olay ngag ay olas et angnenyo nan khawis ken chaicha. Ngem sak-en, ad-i ak eng-engkhana ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Inangnena nan mabfalin ay angnena ken sak-en. Linanaana nan awakko idwani ay mangisakhana isnan sak maikaofan. ");
INSERT INTO lbk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tet-ewa kanak ken chakayo, olay entona issa isnan lofong nan maipalawakhan nan Khawis ay Chamag, at maitapi ay maog-okhod akhes nan nay ay inangnena ay at kaskasmekana.” ");
INSERT INTO lbk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sa et inmey isnan aap-apon si papachi si Judas Iscariote ay esang isnan sinpoo ya chwa'y disipolos Jesus, ta en na itiktik si Jesus ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Osto'y chinnge cha nan kinwanina nenlal-ayad cha, sa cha't inkali ken siya nan siping. Siya chi ya ke na't inyan-anap nan ikkana ay mangitiktik ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Isnan omona ay akhew nan Piyastan si Tinapay ay Egay Kabfofochan ay mangekhechancha isnan kordero isnan am-amongcha isnan Paskua, kinwanin nan disipolosna, “Ento nan laychem ay en mi omisagkhanaan isnan manganan tako isnan am-among ay Paskua?” ");
INSERT INTO lbk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Adi kad finaan Jesus nan chwa'y disipolosna ya kananan, “Somaa kayo isnan ili, ya at wad-ay nan lalaki ay sab-atenyo ay en nangisakcho isnan fanga. Onochenyo siya ");
INSERT INTO lbk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","isnan somkhepana, ya kananyo isnan nen-afong, ‘Laychen nan Mistolo ay ammowen mo ento nan kwarto ay mangiyofongana isnan disipolosna isnan Paskua?’ ");
INSERT INTO lbk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ya at ipailana ken chakayo nan chakchake ay entongcho ay kwarto ay nanongnonongnong ya naisakhasakhana. Ischi nan en-isagkhanaanyo.” ");
INSERT INTO lbk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Naligwat cha nan chwa'y disipolosna ay inmey isnan ili, et inchanancha tet-ewa nan chadlos infaag Jesus ken chaicha, ya insakhanacha ischi nan manganancha isnan am-among ay Paskua. ");
INSERT INTO lbk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Naschem pay ya inmey cha Jesus ya nan sinpoo ya chwa ay disipolosna isnan chey ay afong. ");
INSERT INTO lbk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ya isnan cha cha manganan ket ay kanan Jesus, “Tet-ewa kanak ken chakayo, esang ken chakayo nan mangitiktik ken sak-en. Esang ay cha makikan ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sa cha't enngongoyos ya waschin nangisonson ay mangwanin, “Apo, faken achi sak-en, ad-i ngen?” ");
INSERT INTO lbk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sa na't kanan, “Esang ken chakayo ay sinpoo ya chwa. Siya nan chadlos makisiwsiw ken sak-en isnan tinapay isnan malokong. ");
INSERT INTO lbk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tay awni't matey ak ay Anak si Takho maiyafoloy isnan naisolat ay kalin Apo Dios, ngem selaeg nan takho ay mangitiktik ken sak-en! Khap-esna't si egay naiyanak nan chey ay takho.” ");
INSERT INTO lbk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Issan cha cha manganan, inalan Jesus nan tinapay sa et nenyaman ken Apo Dios ya pinet-apet-angna. Sa na't inchowa isnan disipolosna ya kinwanina, “Nay, alaenyo na ta kanenyo. Siya na nan awakko.” ");
INSERT INTO lbk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Inalana akhes nan matatasa ay fayas, ya nenyaman. Sa na't inchowa ken chaicha ya inminom cha am-in. ");
INSERT INTO lbk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Sa na't kanan, “Siya na nan chalak ay mangaeb isnan tolag Apo Dios, ya omayos pala isnan angsan ay takho. ");
INSERT INTO lbk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tet-ewa kanak ken chakayo, at ad-ik kasin in-inomen nan kag tona ay fayas engkhana isnan akhew ay inomek nan falo ay fayas isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nenchag-ay cha ay nanad-ayaw ken Apo Dios, sa cha't nanikid is kafilig ay Olivo. ");
INSERT INTO lbk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Awni ya kinwanin Jesus ken chaicha, “At lomayaw kayo am-in ay tomaynan. Tay kinwanin Apo Dios isnan naisolat ay kalina, ‘At alaek nan enpaspastor ya at omapok nan karnilo.’ ");
INSERT INTO lbk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nay met achi isnan kasina manakhowan ken sak-en isnan etey, at mang-ona ak mo chakayo ay omey id Galilea.” ");
INSERT INTO lbk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sa et kinwanin Pedro, “At ad-ik taytaynan sik-a Apo, olay mo taynancha am-in sik-a!” ");
INSERT INTO lbk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sa et kinwanin Jesus ken siya, “Tet-ewa kanak ken sik-a, idwani kannay ay lafi, at sisya'y ad-i enkokook nan kawitan is mamidwa is talan-o, ya at omisaot ka is mamitlo ay mangwanin ad-im ammo sak-en.” ");
INSERT INTO lbk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngem kad-in inpapatin Pedro, “Olay maitapi ak ken sik-a ay matey, at ad-ik paat isas-aot sik-a.” Siya akhes chi nan kinwanicha am-in. ");
INSERT INTO lbk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sa et inmey cha Jesus isnan oma ay makwanin Getsemani, ay nangwaniyana isnan disipolosna, “Itoktokchoyo isna ta ennak enlowalo.” ");
INSERT INTO lbk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Intakina si Pedro, si Santiago ya si Juan. Sa et naegyatan ya ad-i tomke nan semekna. ");
INSERT INTO lbk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ke na't ay kanan ken chaicha, “Chachama ay enseseg-ang nan semekko et nay kag ak matey. Isna kayo ya ensasakhana kayo.” ");
INSERT INTO lbk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sa et inmadchawi is akit ya nenlokfob ay nenlowalo ta mo sa ya mabfalin et ad-i koma maangnen ken siya nan chey ay likhat. ");
INSERT INTO lbk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Inlowalona ay mangwanin, “Ama, Ama, am-in ay ngag sisa et kafaelam. Kaanem nan nay ay chad-ama ay likhat ken sak-en. Nay met achi faken nan nemnemko mod-i ket nan nemnemmo nan maangnen.” ");
INSERT INTO lbk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Issan tinmoliyana is kakawad nan cheycha'y tolo, inaspowana chaicha ay cha mitom-e. Kinwanina't ken Pedro, “Simon, maseseyep ka pet? Ad-i ka ngen paat makaikatpe is esa'y olas ay makisasakhana? ");
INSERT INTO lbk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ensasakhana kayo achi ya enlowalo kayo, ta ad-i kayo maafak isnan sailo. Tet-ewa ay enfifikas nan semekyo ngem nakapsot nan awakyo.” ");
INSERT INTO lbk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Inmadchawi kasin si Jesus ay en menlowalo, ya siya kayet chi nan inlowalona. ");
INSERT INTO lbk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Issan kasina tinmoliyan, inaspowana chaicha ay cha mitom-e, tay makases-eyep cha. Et ad-icha ammo nan kanancha ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Awni ya kasin tinmoli si Jesus ken chaicha isnan maikapitlo, sa na't kanan ken chaicha, “Maseseyep kayo ngen kayet ya omil-illeng kayo? Ad-o et sa, tay olas et ya! Ya nay et alaencha sak-en ay Anak si Takho, ay naitiktik isnan cheycha'y fomafasol. ");
INSERT INTO lbk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fomangon kayo! Tay nay, omal-ali nan inmitiktik. En tako't abten.” ");
INSERT INTO lbk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ket ay sisya ay cha enkak-ali si Jesus ya ket naanali si Judas ay esang isnan sinpoo ya chwa ay disipolosna, ya infofowegna nan angsan ay takho ay mamebfeneng ya enpapak-o, ay finaan nan aap-apon si papachi, nan mimistolon si lenteg ya nan amam-a. ");
INSERT INTO lbk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Idwani, siya na nan infaag Judas ay mangimatonancha: “Nan takho ay fisitowek, siya nan khoyochenyo. Tokkhonganyo siya ay mangikaan,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Issan inomchanancha, chinadchawesna't si Jesus ay mangwanin, “Mistolo!” Sa na't finisito. ");
INSERT INTO lbk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ke cha't ay khoyochen si Jesus ay naniliw ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngem inokfos nan esang ay nanatakcho ken Jesus nan fadyokna, sa na't ala ya fakag isnan faan nan katongchowan ay pachi ya ket ay nan koweng nan chey ay faa nan nalongochan. ");
INSERT INTO lbk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sa et kanan Jesus ken chaicha, “Ay ke ak mangaakew ya kakaegyat, ta omali kayo ay enfafadyok ya enpapak-o ay tomiliw? ");
INSERT INTO lbk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Inakhew ay wad-ay ak ken chakayo is kaTimplo ay nen-isos-olo, ya en yo man egay tiniliw sak-en mo? Ngem siya chi ta matongpal nan naisolat ay kalin Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ket ay tinaynan am-in nan fowegna siya ya linmayaw cha. ");
INSERT INTO lbk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wad-ay nan esa'y fab-alo ay inmonod ken siya ay aped yangkhay nangipopotipot isnan lopot ay linen isnan awakna. Chinpapcha siya, ");
INSERT INTO lbk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ngem ke na't ala ya lokpos isnan chey inpopotipotna ay lopot ya linmayaw ay enlalafos. ");
INSERT INTO lbk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sa cha't inyey si Jesus isnan katongchowan ay pachi, ay naamongan am-in nan aap-apon si pachi, nan amam-a ya nan mimistolon si lenteg. ");
INSERT INTO lbk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nakhag-ayad si Pedro ay inmon-onod ken siya isnan adchawi, engkhana ay somkhep isnan kaawwichan nan afong nan katongchowan ay pachi ya nakitokcho isnan cheycha'y khwarchiya ay makinidnicho. ");
INSERT INTO lbk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Idwani, nan aap-apon si papachi ya nan am-in nan papangolon si Judio, et mid egaycha inangnen ay nangiyan-anap isnan mangipangaakhancha ken Jesus ta chalatna's mapateyana, ngem maid nad-anancha. ");
INSERT INTO lbk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Angsan cha nan nen-eng-engag ay nangipangpangaag ken siya ngem ad-i mis-o nan kinwanicha ay nentistikho. ");
INSERT INTO lbk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sa et wad-ay cha nan tinmakcheg ay nangipangaag ken siya ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Chinngemi ay kinwanina, ‘At etfek nan nay ay Timplo ay khinaeb si takho, sa et isnan las-od nan tolo ay akhew, at patakchekhek nan teken ay faken takho nan mangaeb.’ ” ");
INSERT INTO lbk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngem olay nan nay ay kinwanicha'y nanistikho et ad-i mis-o. ");
INSERT INTO lbk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tinmakcheg et nan katongchowan ay pachi ay nangwani ken Jesus, “Ngag nan kanam? Ay ke maid isfatmo isnan mangisaklangan nan naycha'y tistikho ken sik-a?” ");
INSERT INTO lbk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngem khinmigkhinek yangkhay si Jesus ya egay sinomfat. Sa et kasin nensalodsod nan katongchowan ay pachi ay mangwanin, “Sik-a ngen nan Cristo ay Anak nan Machad-ayaw ay Dios?” ");
INSERT INTO lbk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sa et kanan Jesus, “Wen, sak-en, ya awni't ilaenyo sak-en ay Anak si Takho ay tomotokcho is kakannawan nan Makabfalin, ya omali ak isnan lifoo id chaya.” ");
INSERT INTO lbk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Alan et nan katongchowan ay pachi ya peskhat isnan fachona ay mangwanin, “Ay ke tako kasin masapol nan mentistikho? ");
INSERT INTO lbk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chinngeyo et nan nangipangaakhana ken Apo Dios ya! Ngag et nan kananyo?” Sa cha't am-in kanan en lebfengna ay mapatey siya. ");
INSERT INTO lbk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sa et tinobfaan nan tapina siya, ya inap-apan nan tapina nan kamesna ta sodpakencha siya ay mangwanin, “Ayed ta pontowam mo sino nan nanodpak ken sik-a!” Sa et akhes alaen nan cheycha'y khwarchiya ay manodpasodpak ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wad-ay si Pedro is khwabna is kaawwichan, ket ay sinmag-en ken siya nan magmagkit ay esa'y faan nan katongchowan ay pachi. ");
INSERT INTO lbk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Inilana si Pedro ay makinidnicho, ya insisin-engna siya ay mangwanin, “Sik-a akhes nan fob-oweg Jesus ay iNazaret.” ");
INSERT INTO lbk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngem insaot Pedro ay nangwanin, “Ay kek man ammo nan cham kankanan? Ad-ik pay maawatan mo ngag nan laychem ay kanan.” Sa et khinmeg-ed ay inmey is kapantew nan awwichan. (Sa et enkokook nan kawitan.) ");
INSERT INTO lbk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sa et inilan kasin san magmagkit ya kinwanina kayet isnan cheycha'y wad-ay ischi, “Esang na ay ib-acha.” ");
INSERT INTO lbk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngem insaotna kayet. Nawnawnin ya ket inpapatin kayet nan cheycha'y wad-ay ischi ay nangwani ken Pedro, “Sik-a mampet tet-ewa nan esang isnan fob-owegna, tay iGalilea ka.” ");
INSERT INTO lbk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sa na't ala ya sapata ay mangwanin, “Isapatak ay ad-ik ammo nan sana ay takho ay kankananyo, olay mo matey ak.” ");
INSERT INTO lbk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Osto'y siya chi ya ket ay nanakokook nan kawitan isnan ikadwa, ya sinmek Pedro san kinwanin Jesus ken siya, “At sisya'y ad-i enkokook nan kawitan is mamidwa is talan-o, ya at mamitlo ay omisaot ka.” Ket ay chadlos nensifesifek. ");
INSERT INTO lbk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Osto ay nawiit naamong ay matotya nan cheycha'y aap-apon si papachi, nan amam-a, nan mimistolon si lenteg, ya am-in nan papangolon si Judio. Tinakedcha si Jesus sa cha't inkaan ay nangiyey ken Pilato. ");
INSERT INTO lbk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sa et kinwanin Pilato, “Ay sik-a pet tet-ewa nan Alin si Judio?” “Osto nan kinwanim,” inisfat Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Angsan nan inpafapafasol nan aap-apon si papachi ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Sa et kasin kanan Pilato ken siya, “Maid ngen isfatmo? Ilaem nan angsan ay chalomcha ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ya nataa si Pilato tay egay kayet sinomfat si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Idwani, nan sikhod ay ekhad Pilato isnan Piyastan si Paskua, et ipalofosna nan esa'y falod ay kedchawencha ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Issan chey ay timpo, wad-ay nan esang isnan cheycha'y nenkholo ay naifalod ay enngachan is Barrabas. Esang siya ay nangipangpango isnan kholo ya nenpatey. ");
INSERT INTO lbk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Naamong cha nan angsan ay takho ay inmey ken Pilato ta kedchawencha ken siya ta iyangnena nan chey ay ekhadna isnan kag todi ay Piyasta. ");
INSERT INTO lbk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Sa et kinwanin Pilato, “Ay laychenyo ngen ay ipalofosko nan nay Aliyo ay Judio?” ");
INSERT INTO lbk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tay inammowana ay inchowan nan aap-apon si pachi si Jesus ken siya midkakay yangkhay isnan apalcha. ");
INSERT INTO lbk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ngem inpafikas nan aap-apon si papachi nan angsan ay takho ta faken si Jesus nan kedchawencha ken Pilato mod-i ket si Barrabas nan ipalofosna. ");
INSERT INTO lbk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kinwanin Pilato ken chaicha, “Ngag kay et nan angnek isnan chey takho ay kananyo en Aliyo ay Judio?” ");
INSERT INTO lbk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sa cha't ala ya fokhaw kasin ay mangwanin, “Ipailansam is kakolos!” ");
INSERT INTO lbk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sa et kanan Pilato, “Ngag mampay nan finmasolana?” Nay met achi onanig cha infokhaw ay mangwanin, “Ipailansam is kakolos!” ");
INSERT INTO lbk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Idwani tay laychen Pilato ay palaylaychen nan cheycha'y takho, ke na't ay inpalofos si Barrabas ken chaicha. Ya osto'y inpasaplitna si Jesus, inchowana ay en mailansa is kakolos. ");
INSERT INTO lbk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iniskhep et nan cheycha'y sorchacho si Jesus isnan palasyo ay afong nan khofernachor. Sa cha't inayakhan am-in nan iib-acha'y sorchacho. ");
INSERT INTO lbk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sa cha't inpafacho nan an-ancho ay enkilat. Inmapid cha is sibsifit ay inpeycha isnan olona. ");
INSERT INTO lbk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sa cha't nasonson ay kachayachayaw ay mangwanin, “Apo ay Alin si Judio, matakhotakho ka!” ");
INSERT INTO lbk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sa cha't nenfaig nan olona isnan lolo, tinobtobfaancha, sa cha't cha kabfalifalintomeng ay manayaw ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Osto ay inangoangocha, kinaancha't nan inpafachocha ken siya ay enkilat, sa cha't inpafacho chadlo san fachona, ya inkaancha ay en nangilansa is kakolos. ");
INSERT INTO lbk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Idwani wad-ay ischi nan cha lomaos ay iCirene ay nenngachan si Simon ay nalpo id ilit ya cha somkhep isnan ili. (Siya nan aman cha Alejandro ya si Rufo.) Ke cha't ay pinilit ay nangipasakfat ken siya isnan kolos ay sasakfaten Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Inyeycha si Jesus isnan kawad nan makwanin Golgota (ay nan laychena ay kanan et ingit si olo). ");
INSERT INTO lbk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sa cha't inchowa ken Jesus nan fayas ay nalaokan isnan akhas ay makwanin mirra, ngem inad-ina. ");
INSERT INTO lbk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Inlansacha't siya isnan kolos, sa cha't nenfonot ta mangil-ancha mo sino nan omayan nan waschin esang isnan fachona. ");
INSERT INTO lbk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nowibi isnan mag-akhew nan nangilansaancha ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wad-ay nan inpeycha ay naisolatan nan chalomcha ken siya. Kananan, “Si ton-a nan Alin si Judio.” ");
INSERT INTO lbk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wad-ay akhes nan chwa'y kakaegyat ay mangaakew ay naigkhisan ken siya ay naikolos, nan esang is kakannawana ya nan esang is kakannikhidna. ");
INSERT INTO lbk_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Siya sa nan tinmet-ewaan nan naisolat ay kalin Apo Dios ay mangwanin, “Naitapi siya isnan cheycha'y kangaakhan ay takho.”) ");
INSERT INTO lbk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sa et nan cheycha'y linmal-aos ischi, chinopchopischa siya ya cha cha nenwegwegweg ay mangwanin, “Siya pet! Sik-a ay nangwanin etfem nan Timplo sam et kasin toochen isnan las-od nan tolo'y akhew, ");
INSERT INTO lbk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","isalakam achi nan awakmo! Khomwab ka isnan sana ay kolos!” ");
INSERT INTO lbk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Siya akhes nan inangnen nan aap-apon si papachi ya nan mimistolon si lenteg ay nangang-ango ken siya ay cha mangwanin, “Insalakana nan tapina, ngem nan awakna ya ad-i pet makaisalak! ");
INSERT INTO lbk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Siya nan Cristo ay Alin si Israel. Ayed mo pomanad siya idwani is kakolos, ta ilaen tako esa tako't patiyen!” Olay akhes nan cheycha'y ib-an Jesus ay naikolos, et chinopchopischa akhes siya. ");
INSERT INTO lbk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Awni ya isnan alas chosi, ya ket ay finmollinget nan am-in ay ili ischi engkhana'y alas tres isnan misoyaw. ");
INSERT INTO lbk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Isnan alas tres, ket ay nenngao si Jesus ay nangwanin, “Eloi, Eloi, lama sabaktani?” Laychena ay kanan et, “Diosko, Diosko, en ka man inmiwayang ay?” ");
INSERT INTO lbk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chinngen nan cheycha'y tapin nan nentatakcheg ischi ay enfob-oya ya kinwanicha, “Chengngenyo! Ay-ayakhana si Elias.” ");
INSERT INTO lbk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sa et nentagtag nan esang ya inmala is maosar ay manosop isnan sinmoka ay fayas, sa na't inpey isnan lolo ta ipasosopna ken Jesus. Kinwanina, “Ngag ngotoyo ta ilaen tako mo omali si Elias ay mangipagkhwab ken siya!” ");
INSERT INTO lbk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sa et inpapangekhen Jesus ay nenngao, ya chag-as na't chi ya ket nasokpot nan fiyagna. ");
INSERT INTO lbk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sa et nenkapepeskhat nan kortinan nan Timplo ya nakhedwa, mailapo is tongchona engkhana is khwabna. ");
INSERT INTO lbk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Osto'y inilan nan chey kapitan si sorchacho ay nentatakcheg is kasakhang Jesus nan inangnena ay natey, kinwanina, “Tet-ewa pet ay Anak nan Dios na!” ");
INSERT INTO lbk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wad-ay akhes isnan adchawi's akit nan fabfafai ay mangiila isnan cha omat. Wad-ay ken chaicha cha Maria Magdalena, Maria ay inan cha Santiago ay makwanin ong-onga ya si Jose, sa et si Salome. ");
INSERT INTO lbk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Naifob-oweg ya nensilsilfi chana ken Jesus issan kawadna id Galilea. Ya angsan kayet nan tapina ay fabfafai ay nakieey ken siya id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nan chey akhew et kalmana, ya siya nan akhew ay ensagkhanaan nan Judio isnan kawaksana ay Sabfacho ay tengawcha. Idwani, tay sedsechemna, ");
INSERT INTO lbk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","inmey si Jose ay iyArimatea ken Pilato ya intotoledna ay en nangchaw isnan awak Jesus. Si Jose nan esang isnan amam-an si Judio ya maichad-ayaw. Siya nan esang ay manman-ed isnan omaliyan nan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nataa si Pilato ya enchwadchwa mo tet-ewa ay natey si Jesus, et nay inayakhana nan chey kapitan si sorchacho ta pootena mo apchas natey. ");
INSERT INTO lbk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Osto ay inammowana isnan kapitan ay natey et si Jesus, inpalofosna ay alaen Jose nan awakna. ");
INSERT INTO lbk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Adi kad linmako si Jose is lopot ay linen sa na't inpagkhwab nan awak Jesus ya innewesana isnan lopot. Sa na't inpey isnan liyang ay sikhod ay inpakaongna is kacheppas. Sa na't inol-olin nan fato ay inyenebna ischi. ");
INSERT INTO lbk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Inilan cha Maria Magdalena ya si Maria ay inan Jose nan naipay-ana. ");
INSERT INTO lbk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Issan nakwasan nan tengaw ay Sabfacho, cha Maria Magdalena, si Maria ay inan Santiago ya si Salome, et inmey cha linmako is fangfanglo ay en cha iyappos isnan awak Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Osto ay Chomingkho, namikhat cha ay inmey isnan kakaofan ya natan-ang et nan akhew issan inomchanancha ischi. ");
INSERT INTO lbk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sa cha't cha kankanan, “Sino kay nan sa mangolin isnan fato ay naitangeb isnan liyang?” ");
INSERT INTO lbk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ket ay sinakhangcha nan liyang, ya naolin pet san chakchake ay fato! ");
INSERT INTO lbk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Osto ay sinomkhep cha is kaliyang, inilacha't nan fab-alo ay nenfafacho is an-ancho ay enpokkakaaw ya tomotokcho is kakannawancha. Sa cha't natakag. ");
INSERT INTO lbk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sa na't kanan, “Ad-i kayo matakag. An-anapenyo achi si Jesus ay iNazaret ay naikolos. Ngem maid met isna, tay finmangon kasin. Ilaenyo nan nangipay-ancha ken siya. ");
INSERT INTO lbk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ngem en kayo't ifaag ken Pedro ya nan tapina ay disipolosna ay at mang-ona siya mo chakayo ay omey id Galilea. At ilaenyo siya ischi, ay kag isnan sikhod chadlo ay infakhana.” ");
INSERT INTO lbk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sa cha't ala ya fala is kaliyang ya layaw, tay natakag cha ya chadlos ay nentat-ayenten cha. Et maid paat nangifagfag-ancha isnan olay sino tay omegyat cha. ");
INSERT INTO lbk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Osto ay wiit isnan Chomingkho, natakho si Jesus. Si Maria Magdalena ay nangipakaanana isnan pito ay anito nan inmona ay nenpail-ana. ");
INSERT INTO lbk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sa et inmey si Maria isnan sikhod ay foweg Jesus ay ensasanga ya en-ag-akha, ya infakhana ay inilana si Jesus. ");
INSERT INTO lbk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nay met achi, isnan nanngelancha ay natakho siya ya inilan Maria, khechangna'y ad-icha patiyen. ");
INSERT INTO lbk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nakwas chi sa et nenpaila siya ay teken nan ilana isnan chwa ay disipolosna ay cha manad-alan id ilit. ");
INSERT INTO lbk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sa cha't tinmoli isnan ili ay nangibfakha isnan tapina ay ib-acha, ngem egay cha namati. ");
INSERT INTO lbk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Awni pay ya ket ay nenpaila si Jesus isnan sinpoo ya esang ay disipolosna issan mangmanganancha. Yinangyangana chaicha tay maid pammaticha ya enkenteg nan olocha, tay ad-icha patiyen nan cheycha'y nangila ken siya kakwasan nan finmangonana. ");
INSERT INTO lbk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sa na't kinwani ken chaicha, “En kayo isnan olay entona issa isnan lofong ta ipalawagyo nan Khawis ay Chamag isnan am-in ay takho. ");
INSERT INTO lbk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Et mo sino nan mamati ya mafonyakhan, at maisalakan. Ngem nan cheycha'y ad-i mamati et maokom cha ay machosa. ");
INSERT INTO lbk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ya nan cheycha'y mamati et siya chana nan kaimatonancha: Kafaelancha ay mangipakaan isnan anito isnan ngachanko, ya makakkali cha isnan nateketeken ay kali ay eg-aycha inam-ammowan. ");
INSERT INTO lbk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mo egnancha nan oweg paymo inomencha nan khiwachay at maid maangnen is ngaag ken chaicha. Sa cha't akhes ipatang nan limacha isnan masasakit ya khomawis.” ");
INSERT INTO lbk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kakwasan nan nanot-oyyan Apo Jesus isnan cheycha'y fob-owegna, ket ay naala ay naipalamag id chaya, ya tinmokcho is kakannawan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sa et naligwat nan cheycha'y fob-owegna ay inmey nenpap-alawag isnan olay entona issa. Ya wad-ay si Apo Jesus ay makidkidno ken chaicha, ya mangipatet-ewa isnan isos-olocha isnan katataa ay sinyal ay inang-angnencha.");
INSERT INTO lbk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Apo Teofilo: Angsan cha nan apchas nangisolat isnan am-in ay in-inmat isnan ili tako. ");
INSERT INTO lbk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Insolatcha nan cheycha'y chinngemi isnan cheycha'y chadlos nangiila engkhana issan lapona maipoon isnan naycha ay cha inmat ay inwalakhawagcha. ");
INSERT INTO lbk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kag akhes ken sak-en, sinmekko Apo ay away nget khawis mo isolatko chana ken sik-a tay pinoopootko chana ay khawis mailapo issan chamona. Et nay inongnongko ay mensolat ken sik-a Apo, maipoon isnan naycha'y naik-ikkan, ");
INSERT INTO lbk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ta maammowam nan kinatet-ewan nan cheycha'y naisolo ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Issan timpo ay nen-aliyan Herodes id Judea, wad-ay nan esang ay pachi ay enngachan is Zacarias ay waned Abias ay pachi akhes. Nan asawana ay si Elisabet, siya akhes nan apon Aaron ay pachi id sangad-om. ");
INSERT INTO lbk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cha Zacarias ay sin-asawa et nalenteg cha isnan sakhang Apo Dios, ya inafolotcha ay osto nan am-in ay filin ya lentegna ya maid naknakwaniyancha. ");
INSERT INTO lbk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngem maid anakcha tay nakot-eg si Elisabet ya nalakay cha't ay chwa. ");
INSERT INTO lbk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Isnan namingsan inomchan nan fiyang cha Zacarias ay ensilfi ken Apo Dios is kaTimplo. ");
INSERT INTO lbk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nan ekhad nan papachi issan chey, et enfonot cha mo sino ken chaicha nan somkhep ay ensilfi is kaTimplon Apo Dios, et si Zacarias nan nabfonotan. Tay siya chi, sinomkhep siya is kaTimplo, ay mamoo isnan insinso. ");
INSERT INTO lbk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Siya nan olas ay mapoowan nan insinso, ya naamong nan katakhotakho ay cha enlol-owalo is kadchela. ");
INSERT INTO lbk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ya ket ay nenpaila nan anghel Apo Dios ken Zacarias. Intatakchegna isnan kakannawan nan altar ay mapop-oowan nan insinso. ");
INSERT INTO lbk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Natakag si Zacarias isnan nangil-ana ya chad-ama nan egyatna. ");
INSERT INTO lbk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nay met achi kinwanin nan anghel, “Ad-i ka omegyat Zacarias, tay chinngen Apo Dios nan lowalom, ya nay at omanak si Elisabet ay asawam is lalaki, ya at ngadnam siya is Juan. ");
INSERT INTO lbk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","At enlal-ayad ka isnan chachama ay lagsakmo, ya angsan cha nan enlal-ayad isnan maiyanakana, ");
INSERT INTO lbk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tay at matangad siya isnan sakhang Apo Dios. Ad-i omin-inom isnan fayas paymo ngag issa ay fomoteng, ya mailapo isnan maililitonana, wad-ay nan Ispirito Santo ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Siya nan mangisakhong isnan angsan ay Israelita ta mamati cha kasin isnan Apo ay Dioscha. ");
INSERT INTO lbk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","At siya nan mangon-ona mo si Cristo ya at wad-ay ken siya nan fikas ya kamabfalin ay kag ken Elias ay mamadton Apo Dios, ta paornosena kasin nan am-a ya an-ak. Ya nan nasokil, ta ensemek cha isnan semek si nalenteg. Siya chi nan ikkana ta isakhanana nan takho isnan omaliyan nan Apocha.” ");
INSERT INTO lbk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sinfat Zacarias nan anghel ay nangwanin, “Ngag nan mangammowak ay tet-ewa na? Nay apchas ak et nalakay, ya si asawak et nalakay akhes.” ");
INSERT INTO lbk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sinmongfat akhes nan anghel ay nangwanin, “Sak-en si Gabriel ay maitatakcho ken Apo Dios, ya infaana sak-en ay mangifaag ken sik-a isnan nay Khawis ay Chamag. ");
INSERT INTO lbk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nay met achi tay egaymo pinati san kinwanik, at khomigkhinek ka ya ad-i ka makakkali engkhana isnan akhew ay maangnenan nan infaagko. Tay at mampay tomet-ewa nan naycha isnan osto ay timpocha.” ");
INSERT INTO lbk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Idwani, sisin-ed nan takho si Zacarias, ya nataa cha tay nawninawnin is kaTimplo. ");
INSERT INTO lbk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Issan finmalaana, aped yangkhay nenkak-awad ken chaicha tay ad-i makakkali. Tay siya chi, inammowancha ay wad-ay nan nenpaila ken siya isnan Timplo. ");
INSERT INTO lbk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sa et sinmaa si Zacarias isnan nakontowan nan chonona is kaTimplo. ");
INSERT INTO lbk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Awni pay ya ket ay naliton si asawana ay Elisabet ya sinosomkheng is afongcha isnan lima ay fowan. ");
INSERT INTO lbk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kinwanina en, “Siya na pet nan inangnen Apo Dios ken sak-en isnan akhew ay inmoschongana, ay nangaan isnan kaang-angowak isnan takho.” ");
INSERT INTO lbk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Issan maikan-em ay fowan nan liton Elisabet, infaan Apo Dios si Gabriel ay anghelna isnan ili ay Nazaret ay sakop nan Galilea. ");
INSERT INTO lbk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wad-ay ischi nan esang ay magmagkit ay enngachan is Maria ay naitot-oya isnan esa'y lalaki ay enngachan is Jose ay nalpo isnan waned ali ay David. ");
INSERT INTO lbk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Inmey nan anghel ken siya ay nangwanin, “Enlal-ayad ka ay chadlos binindisyonan Apo Dios! Wad-ay nan Apo ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nay met achi chadlos nadchanakhan si Maria isnan kinwanina, ya nensemesemek mo ngag nan laychena ay kanan. ");
INSERT INTO lbk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sa et kinwanin nan anghel, “Ad-i ka omegyat, Maria, tay laylaychen Apo Dios sik-a. ");
INSERT INTO lbk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nay, at maliton ka ya at iyanakmo nan esang ay lalaki ay at ngadnam is Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","At matangtangad siya ya makwani en Anak nan Katotongchowan. Sa et khab-en Apo Dios siya is ali ay kag ken David ay naiwanchana. ");
INSERT INTO lbk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iyapowana nan waned Jacob is eng-engkhana, ya maid pengpeng nan en-ap-apowana.” ");
INSERT INTO lbk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kinwanin et Maria isnan anghel, “Ento kay nan ikkana, tay maid met chinchinpak is lalaki?” ");
INSERT INTO lbk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sa et kinwanin nan anghel, “At omchan nan Ispirito Santo ken sik-a, ya nan kamabfalin nan Katotongchowan et takchowena sik-a. Tay siya chi, nan nasantowan ay ong-onga ay iyanakmo et makwanin Anak Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ilaem si Elisabet ay nangagkhiyanmo ay makwanin nakot-eg. Olay nain-ina, naliton siya, ya nay maikan-em et ay fowana idwani, ");
INSERT INTO lbk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","tay si Apo Dios, maid ad-ina kafaelan.” ");
INSERT INTO lbk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kinwanin et Maria, “Naay ak ay faan chadlo Apo Dios. Maangnen et koma ken sak-en nan kinwanim.” Sa et tinaynan nan anghel siya. ");
INSERT INTO lbk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Awni pay ya ket naligwat si Maria ya nenkakamo ay inmey isnan afong cha Zacarias isnan esa'y ili isnan nafib-ilikhana id Judea. Sinomkhep isnan afongcha ya tinot-oyana si Elisabet. ");
INSERT INTO lbk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Issan nanngelan Elisabet isnan kalin Maria, nakhanniwa nan ong-onga ay ilillitona, ya wad-ay nan Ispirito Santo ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sa na't inpapangekhe ay nangwanin, “Isnan am-in ay fabfafai sik-a nan kaoneyan, ya siya akhes isnan ilillitonmo. ");
INSERT INTO lbk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ya ke pet sak-en nan maichayaw tay inmali nan inan nan Apok ay mangila ken sak-en! ");
INSERT INTO lbk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tay issan chadlos ko nanngelan isnan kalim, nakhanniwa nan nay ay ilillitonko khapo isnan lagsakna. ");
INSERT INTO lbk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Naoney ka tay pinatim ay at maangnen nan inkalin Apo Dios ay maangnen ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sa et kinwanin Maria, “Chad-ayawek si Apo Dios isnan am-in ay kafaelak, ");
INSERT INTO lbk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ya isnan nemnemko ilal-ayadko si Apo Dios ay mangisas-alak ken sak-en, ");
INSERT INTO lbk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","khapo tay sisinmekna sak-en ay ad-i maifilang ay faana. Tay siya chi, mailapo idwani at kanan nan am-in ay masokasokat ay takho isnan eng-engkhana ay naoney ak, ");
INSERT INTO lbk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","khapo isnan katataa ay inangnen nan Makabfalin ken sak-en. Nasantowan chadlo nan ngachana. ");
INSERT INTO lbk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Isnan masokasokat ay wanen-ed si takho, kad-in seg-angana nan cheycha'y mangiyegyat ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Inpailana nan kafikas nan limana tay nenpaappokena nan nachayew ta masangaw nan semsemkencha ay angnen. ");
INSERT INTO lbk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kinaana nan ali isnan tronocha, sa na't inpatongcho nan cheycha'y fan-ig ay takho. ");
INSERT INTO lbk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pang-epena isnan khawis nan cheycha'y maoowat, ngem inpakaana nan fafaknang ay maid mabfalincha. ");
INSERT INTO lbk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Sisinmekna nan inkalina isnan am-a tako id solit, et nay finachangana chatako ay faana ay waned Israel. ");
INSERT INTO lbk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Siya, inpailana nan seg-angna ken Abraham ya isnan wanen-edna is eng-engkhana!” ");
INSERT INTO lbk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nakitetee si Maria ken cha Elisabet is tolo ay fowan, sa et sinmaa. ");
INSERT INTO lbk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Idwani, inomchan nan omanakan Elisabet, et inmanak is lalaki. ");
INSERT INTO lbk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Issan osto'y nanngelan nan sasagkhongcha ya nan kikib-acha nan chachama ay seg-ang Apo Dios ken Elisabet, nakilal-ayad cha ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Issan maikawalo ay akhew nan ong-onga, naamong cha't ta masegyatan ya mangadnan siya. Kanamo ipangachancha nan Zacarias ay ngachan amana, ");
INSERT INTO lbk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ya ket kinwanin inana en, “Ad-i! Juan nan maipangachan ken siya.” ");
INSERT INTO lbk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kanancha't en, “Maid met paat kikib-ayo is enngachan isnan kag tosa!” ");
INSERT INTO lbk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sa cha't nenkawad ken amana ay nensalodsod mo ngag nan laychena ay maipangachan isnan ong-onga. ");
INSERT INTO lbk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ala na et ya faa is pagsolatan sa na't isolat nan kag tona: “Juan nan ngachana.” Chachama'y nataa cha am-in. ");
INSERT INTO lbk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Faagna ya ket ay inpalosfot chadlo kasin Apo Dios nan kalin Zacarias ya chinad-ayawna si Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Natakag cha't am-in nan sasagkhongcha, sa et naog-okhod nan naycha ay cha inmat isnan am-in ay kailiili isnan nafib-ilkhana id Judea. ");
INSERT INTO lbk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","“Ngag ngen et nan enfalinan nan nay ay ong-onga?” kinwanin nan am-in ay nannge isnan naangnen. Sinmesinmekcha ay khawis nan inmat tay naammowan ay wad-ay nan kamabfalin Apo Dios ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Idwani, wad-ay nan Ispirito Santo ken Zacarias ay aman Juan sa na't inpadto ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Machad-ayaw nan Apo tako ay Dios nan Israel, tay inmali ay mamachang ay mangipalofos isnan takhona. ");
INSERT INTO lbk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Infaana et ken chatako nan makabfalin ay omisalak ay waned nan faana ay si David. ");
INSERT INTO lbk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kag isnan inkalina ken chatako isnan nasantowan ay mamadtona id solit ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","isalakana chatako isnan kafoso tako ya isnan kamabfalin nan am-in ay mangola ken chatako. ");
INSERT INTO lbk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kinwanina ay seg-angana nan am-a tako ya sesemkena nan nasantowan ay tolagna. ");
INSERT INTO lbk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Siya sa nan insapatana ken ama tako ay Abraham, ");
INSERT INTO lbk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ay siya nan mangisalak ken chatako isnan fomoso ta ad-i tako omeg-egyat ay manad-ayaw ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ta isnan am-in ay akhew ay matatakhowan tako, et khawis ya nalenteg nan okhali tako isnan sakhangna.” ");
INSERT INTO lbk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sa et kinwanin Zacarias isnan anakna, “Sik-a anakko, at makwani ka en mamadton nan Katotongchowan, tay at mang-ona ka mo nan Apo tako ay Cristo ay mangisakhana isnan kew-ana. ");
INSERT INTO lbk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta ipaammom isnan takhona ay at maisalakan cha isnan mapakawanan nan fasolcha. ");
INSERT INTO lbk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Siya chasa nan maangnen khapo tay chachama nan seg-ang nan Dios tako. Nay et wad-ay nan omali ken chatako ay faalen Apo Dios ay malpo id chaya ay kag isnan fomal-an nan akhew nan omaliyana. At silawana nan takho ay kag entetee isnan ab-afollinget ya omegyat ay matey. Ya ta ipangona chatako isnan chalan ay oompaan nan semek tako.” ");
INSERT INTO lbk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Idwanin, nan anak Zacarias, naengngan ya linmaing. Sa et inmey nentetee isnan malalango ay ponchag engkhana ay omchan nan timpo ay enpail-ana isnan Israelitas. ");
INSERT INTO lbk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Issan chey ay timpo infilin nan ap-apo ay si Cesar Augusto ay enpalista am-in nan katakhotakho isnan am-in ay ili ay iyap-apowan nan iRoma. ");
INSERT INTO lbk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Si Kirenio nan khofernachor isnan probinsiya ay Siria isnan nay ay inmon-ona ay nenpalistaan si katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Idwani waschin et sinmaa isnan chadlos ilina ay en nenpalista. ");
INSERT INTO lbk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Naligwat akhes si Jose isnan ilina ay Nazaret id Galilea, ya sinmaa id Betlehem id Judea, tay siya nan ilin nan naiwanchana ay si David id solit. ");
INSERT INTO lbk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Issan inmayana ay nenpalistaan, intakina si Maria ay asawana. Malilliton si Maria, ");
INSERT INTO lbk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ya osto ay wad-ay cha ischi, inomchan nan akhew ay omannakana. ");
INSERT INTO lbk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nay met achi tay maid paat entey-ancha isnan en-ab-afangan, ket ay isnan afong si faka nan nangiyanakana isnan on-ona ay anakna ay lalaki. Esa na't finongon isnan lopot ya inpaseyepna isnan mangmanganan nan faka. ");
INSERT INTO lbk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Isnan chey ay ili wad-ay cha nan oomyan isnan ponchag ay mangipaspastor isnan karnilocha. ");
INSERT INTO lbk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sa et nenpaila ken chaicha nan anghel Apo Dios ya tinangkhewan nan langlang ay chayaw Apo Dios chaicha. Chad-ama nan egyatcha, ");
INSERT INTO lbk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ngem kinwanin nan anghel ken chaicha en, “Ad-i kayo omegyat! Tay ibfakhak ken chakayo nan khawis ay chamag ay mangipalal-ayad isnan am-in ay takho. ");
INSERT INTO lbk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Idwanin ay akhew, isnan ilin David, naiyanak nan mangisalak ken chakayo. Siya si Cristo ay Apo! ");
INSERT INTO lbk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Et siya na nan mangimatonanyo: At edchananyo nan ong-onga ay nakomonan is lopot ay maipapaseyep isnan manganan nan faka.” ");
INSERT INTO lbk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nenkawawad-ay cha't nan ang-angsan ay angheles ay nalpo id chaya ya naitapi cha isnan chey ay anghel ay nanad-ayaw ken Apo Dios ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Machad-ayaw si Apo Dios isnan katotongchowan, sa et isnan lofong, oompa koma nan takho ay laylaychena!” ");
INSERT INTO lbk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Issan osto ay kinmaanan nan angheles ay tomoli id chaya, natotya nan cheycha'y enpaspastor ay nangwanin, “En tako't ilaen id Betlehem nan chey inmat ay inpaammon nan Apo ken chatako.” ");
INSERT INTO lbk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sa cha't nenkakamo ay inmey ya inchanancha cha Maria ken Jose ya nan ong-onga ay naipapaseyep isnan manganan si faka. ");
INSERT INTO lbk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Issan nangil-ancha, inpaammocha nan naifaag ken chaicha maipoon isnan ong-onga. ");
INSERT INTO lbk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Et am-in ay nannge, natataa cha isnan infab-aag nan enpaspastor. ");
INSERT INTO lbk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nay met achi si Maria, iniigtona am-in is kasemekna nan cha inmat, ya kad-in ninemnemna. ");
INSERT INTO lbk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nan cheycha ay enpaspastor akhes, tinmoli cha ay manad-ayaw ya mangichagchag-ay ken Apo Dios isnan am-in ay chinngecha ya inilacha, ay kag isnan infakhan nan anghel ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Inomchan et nan maikawalo ay akhew nan ong-onga, ay masegyatana, ya inpangachancha nan Jesus ken siya maiyafoloy isnan infakhan nan anghel issan sisya ay egay nailiton. ");
INSERT INTO lbk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Awni ya ket inyey cha Jose nan ong-onga ay mangichoo ken Apo Dios id Jerusalem tay inomchan et nan akhew ay mangiyangnenancha isnan nailenteg ay ekhad ay kachalosan inana isnan lenteg Moises. ");
INSERT INTO lbk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tay siya na nan naisolat isnan chey ay lenteg Apo Dios, “Am-in nan inaona ay anak ay lalaki et masapol ay maichoo ay kwan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Idwani inmey cha Jose ay mangichaton isnan infilin nan lenteg Apo Dios ay chwa ay ay-ayam ay falog paymo chwa ay anak si kalopati. ");
INSERT INTO lbk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Idwani, wad-ay nan am-ama id Jerusalem ay enngachan is Simeon ay nannan-ed isnan timpo ay mamachangan Apo Dios isnan Israelitas. Khawigkhawis siya ya iyeegyatna si Apo Dios, ya wad-ay nan Ispirito Santo ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Inpaammon akhes nan Ispirito Santo ken siya ay at ad-i matmatey engkhana ay ilaena si Cristo ay inkalin Apo Dios ay ifaana. ");
INSERT INTO lbk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Osto ay inyey cha Jose si Jesus is kaTimplo ay mangangnen isnan chey ay ekhad ay naifilin is kalenteg, wad-ay akhes si Simeon ischi ay inpangon nan Ispirito Santo. ");
INSERT INTO lbk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sinakloyna nan ong-onga sa na't chinad-ayaw si Apo Dios ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Idwanin Apo, tay naangnen et nan inkalim, olay alaem et sak-en et oompa nan semekko ay faam. ");
INSERT INTO lbk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tay nay et inilak chadlo nan infaam ay omisalak. ");
INSERT INTO lbk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Siya na nan insakhanam isnan sakhang nan am-in ay takho. ");
INSERT INTO lbk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Siya nan silaw ay mensilaw isnan semek nan Gentil. Ya siya nan khapon nan matangachan nan takhom ay waned Israel.” ");
INSERT INTO lbk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chinngen cha Jose nan kinwanin Simeon maipoon isnan anakcha, ya nataa cha. ");
INSERT INTO lbk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sa na't binindisyonan chaicha ya kinwanina isnan inana ay si Maria en, “Naay nan ong-onga ay pinilin Apo Dios ay mangsisyan isnan Israelitas. Pakawasena nan tapina, ya isalakana nan tapina. Siya nan sinyal ay malpo ken Apo Dios ay at kholaen nan ang-angsan ay takho, ");
INSERT INTO lbk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ya nay et maammowan nan wad-ay ay naitafon isnan semekcha. Et sik-a ay inana, alig ka mayoyok isnan fadyok isnan cham manginaakhan isnan chad-ama'y ensikhafan nan semekmo.” ");
INSERT INTO lbk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wad-ay akhes sid-i nan esang ay in-ina ay mamadton Apo Dios. Siya si Ana ay anak Fanuel ay nalpo isnan tribon Aser. Pito ay tawen nan nen-aamongancha ken asawana ket ay nailekkasan. ");
INSERT INTO lbk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nay walon poo et ya epat ay tawena. Inakhew ya minaschem ay wad-ay is kaTimplo siya ay egay nangnangan ay nenchad-ayaw ya nenlol-owalo ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Isnan chey kannay ay olas ay kawad cha Jesus is kaTimplo, inomchan siya ya nenyaman ken Apo Dios. Sa na't inog-okhod nan maipoon isnan ong-onga isnan am-in ay cha manman-ed isnan mensobtan Apo Dios isnan iJerusalem. ");
INSERT INTO lbk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nakwas et ay inangnencha nan am-in ay infilin nan lenteg Apo Dios, sa cha't sinmaa id Galilea isnan ilicha ay Nazaret. ");
INSERT INTO lbk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Sa et naengngan nan ong-onga ya finmikas. Silib nan wad-ay ken siya ya finadfachangan Apo Dios siya. ");
INSERT INTO lbk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tinnawen ay omey nan chakek-en Jesus id Jerusalem ay makipiyasta isnan kanancha en Paskua. ");
INSERT INTO lbk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Isnan maikasinpoo ya chwa'y tawen Jesus, inmey cha ay nakipiyasta maiyafoloy isnan sikhod ay ekhadcha. ");
INSERT INTO lbk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Issan nakwasan nan am-among, naligwat cha ay somaa. Nay met achi ad-i ammon cha amana ken inana ay ke pet nakhayad si Jesus id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kanancha en mo wad-ay siya ay maifofoweg, ya esa'y akhewcha ay nanad-alan ay somaa issan nanmekancha ay manganapan ken siya isnan kikib-acha ya nan tapina. ");
INSERT INTO lbk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ngem tay maid inilacha, ala cha't ya toli id Jerusalem ay en manganap ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Issan maikatlo ay akhew, inchanancha siya is kaTimplo ay makitoktokcho isnan mimistolo. Chinchinngena nan kinkinwanicha ya cha nensas-alodsod. ");
INSERT INTO lbk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Am-in ay nannge, nataa cha isnan silibna ya songfatna ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nataa akhes cha amana ken inana issan nangil-ancha ken siya. Sa et kinwanin inana, “Anak, em man inangnen na ken chakami ay? Ilam, si amam ya sak-en, chad-ama nan chanagmi isnan cha mi mangan-anapan ken sik-a!” ");
INSERT INTO lbk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“En kayo man mang-ey omanaanap ay? Ad-iyo ngen ammo ay masapol ay wad-ay ak isnan afong Ama?” kinwanin Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ngem egaycha naawatan nan kinwanina. ");
INSERT INTO lbk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naitakin et si Jesus ken chaicha ay khinomwab id Nazaret, ya sikhod ay patpatiyena chaicha. Si inana akhes, iniigtona is kasemekna yangkhay nan am-in ay in-inmat. ");
INSERT INTO lbk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Et naengngan si Jesus, olay isnan kinasilib, ya laylaychen Apo Dios ya nan katakhotakho siya. ");
INSERT INTO lbk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Isnan maikasinpoo ya lima ay tawen isnan en-ap-apowan Cesar Tiberio, inomchan nan kalin Apo Dios ken Juan ay anak Zacarias ya entetee isnan ponchag. Siya akhes chi nan en-ap-apowan nan naycha: si Poncio Pilato ay khofernachor id Judea, si Herodes ay khofernachor id Galilea, nan akhina ay si Felipe ay khofernachor id Iturea ya id Traconite, si Lisanias ay khofernachor id Abilene, sa et cha Anas ken Caifas ay entongcho ay papachi is kaTimplo. ");
INSERT INTO lbk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Idwani alan et Juan ya eey isnan am-in ay ili ay nenliwes isnan wanga ay Jordan, ay mangipalawag, “Ibfafawiyo ta chokokhanyo nan fasolyo ya enpafonyag kayo, ya at pakawanen Apo Dios chakayo!” ");
INSERT INTO lbk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Siya chi mampay san insolat Isaias ay mamadton Apo Dios id solit ay mangwani en, “Wad-ay isnan malalango ay ponchag nan mangifogfokhaw ay mangwanin, ‘Isakhanayo nan chalan nan Apo, enletkhenyo nan ikwana. ");
INSERT INTO lbk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Am-in ay nachad-alolog, khab-onanyo. Am-in nan at-atakchag ya enkhwab ay filig, chatlenyo. Nan natikotiko ay chalan, paletkhenyo. Ya nan kakhotkhotongan, masapol ay mas-et. ");
INSERT INTO lbk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sa et ilaen nan am-in ay katakhotakho nan angnen Apo Dios ay en-isalak!’ ” ");
INSERT INTO lbk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chadlos angsan ay takho nan inmey ay nenpafonyag ken Juan. Kinwanina, “Chakayo ay kag an-ak si oweg! Ay ke yo mailayawan nan omal-ali ay songet Apo Dios isnan ap-aped ay fafawiyo? ");
INSERT INTO lbk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Angnenyo magtek nan okhali ay mangipaila ay chinokokhanyo nan fasolyo! Ya ad-iyo cha et onaen ay mangwanin, ‘Osto kami tay si Abraham nan amami,’ tay kanak ken chakayo, mabfalin met ay aped yangkhay alaen Apo Dios nan naycha'y fato ya enfalinena si an-ak Abraham! ");
INSERT INTO lbk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Maiyalig kayo isnan kaew ay wad-ay nan naisasakhana ay wasay is kapoocha. Adi kad am-in nan kaew ay maid khawis si fekhasna et masipo ya maiwasit is kaapey!” ");
INSERT INTO lbk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Ngag et kay mampay nan angnenmi?” sinalodsod nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kinwanina en, “Mo sino nan chwa nan fachona, ichowana nan esang isnan ib-ana ay maid fachona, ya mo sino nan wad-ay kanena, siya akhes nan angnena.” ");
INSERT INTO lbk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wad-ay nan tapina ay enkorkortais ay inmey nenpafonyag ay nangwanin, “Mistolo, ngag nan masapol ay angnenmi?” ");
INSERT INTO lbk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Ad-i kayo ensingsingil is sobla mo nan naifilin ken chakayo,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Olay akhes nan cheycha'y sorchacho, nensalodsod cha, “Chakami pay? Ngag nan osto ay angnenmi?” Kinwanina, “Ad-iyo paegyaten paymo pabfasolen nan takho ta alaenyo nan kwacha. Mang-ep kayo magtek isnan lagfoyo!” ");
INSERT INTO lbk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Amed finmikas nan semek nan katakhotakho. Kasin cha nensemesemek am-in maipoon ken Juan mo siya nan Cristo. ");
INSERT INTO lbk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ngem insongfat Juan ay nangwanin, “At wad-ay nan omali ay maisokat ken sak-en. Sak-en, fonyakhak chakayo isnan chanom, ngem nan omali fonyakhana chakayo isnan Ispirito Santo ya apey. Wadwad-ay chadlos nan kamabfalina mo sak-en, ya ad-i ak maikali ay mamadfad olay isnan taked nan pallokana. ");
INSERT INTO lbk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","At sisyanena nan takho. Kag wad-ay lig-ona ay mannaep isnan ilik, sa na't igto is kaallang nan naptong ay ilik, ya poowana nan nakpit ay ilik ya olot is kaapey ay ad-i kaad-achep.” ");
INSERT INTO lbk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Angsan kayet nan cha intokhon Juan isnan nangipalawakhana isnan Khawis ay chamag ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yinangyangan akhes Juan si khofernachor Herodes isnan nangasaw-ana ken Herodias ay asawan nan akhina ya isnan angsan kayet ay ngaag ay ang-angnena. ");
INSERT INTO lbk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ngem ket ay onanig nginmaag si Herodes tay awni ya ke na't inpafalod si Juan. ");
INSERT INTO lbk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Issan namonyakhan Juan sinan katakhotakho, finonyakhana akhes si Jesus. Sa et issan cha enlol-owalowan Jesus, natekwafan nan chaya, ");
INSERT INTO lbk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ya khinomwab ken siya nan Ispirito Santo ay kag kalopati nan ilana. Sa et id chaya wad-ay nan nenkali ay nangwanin, “Sik-a nan laylaychek ay Anakko. Malaylaychan ak ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Omey is tolon poo ay tawen Jesus issan nangilapowana ay nen-isos-olowan. Infilang nan takho siya ay anak Jose. Si Jose et siya nan anak Eli. ");
INSERT INTO lbk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Et si Eli, anak Matat; si Matat, anak Levi; si Levi, anak Melki; si Melki, anak Jane; si Jane, anak Jose; ");
INSERT INTO lbk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","si Jose, anak Matatias; si Matatias, anak Amos; si Amos, anak Nahum; si Nahum, anak Esli; si Esli, anak Nage; ");
INSERT INTO lbk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","si Nage, anak Maat; si Maat, anak Matatias; si Matatias, anak Semei; si Semei, anak Jose; si Jose, anak Juda; ");
INSERT INTO lbk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","si Juda, anak Joana; si Joana, anak Resa; si Resa, anak Zorobabel; si Zorobabel, anak Sealtiel; si Sealtiel, anak Neri; ");
INSERT INTO lbk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","si Neri, anak Melki; si Melki, anak Adi; si Adi, anak Cosam; si Cosam, anak Elmodam; si Elmodam, anak Er; ");
INSERT INTO lbk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","si Er, anak Josue; si Josue, anak Eliezer; si Eliezer, anak Jorim; si Jorim, anak Matat; si Matat, anak Levi; ");
INSERT INTO lbk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","si Levi, anak Simeon; si Simeon, anak Judas; si Judas, anak Jose; si Jose, anak Jonan; si Jonan, anak Eliakim; ");
INSERT INTO lbk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","si Eliakim, anak Melea; si Melea, anak Mena; si Mena, anak Matata; si Matata, anak Natan; si Natan, anak David; ");
INSERT INTO lbk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","si David, anak Jesse; si Jesse, anak Obed; si Obed, anak Booz; si Booz, anak Salmon; si Salmon, anak Naason; ");
INSERT INTO lbk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","si Naason, anak Aminadab; si Aminadab, anak Aram; si Aram, anak Arni; si Arni, anak Esron; si Esron, anak Fares; si Fares, anak Juda; ");
INSERT INTO lbk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","si Juda, anak Jacob; si Jacob, anak Isaac; si Isaac, anak Abraham; si Abraham, anak Tare; si Tare, anak Nacor; ");
INSERT INTO lbk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","si Nacor, anak Serug; si Serug, anak Ragau; si Ragau, anak Peleg; si Peleg, anak Heber; si Heber, anak Selah; ");
INSERT INTO lbk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","si Selah, anak Cainan; si Cainan, anak Arfaxad; si Arfaxad, anak Sem; si Sem, anak Noe; si Noe, anak Lamec; ");
INSERT INTO lbk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","si Lamec, anak Matusalem; si Matusalem, anak Enoc; si Enoc, anak Jared; si Jared, anak Mahalaleel; si Mahalaleel, anak Cainan; ");
INSERT INTO lbk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","si Cainan, anak Enos; si Enos, anak Set; si Set, anak Adan; ya si Adan, anak Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kinmaan si Jesus isnan wanga ay Jordan ya wad-ay nan Ispirito Santo ken siya. Et inpangon nan Ispirito Santo isnan ponchag. ");
INSERT INTO lbk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ischi nan nanas-ailowan nan chimonyo ken siya is epat poo ay akhew. Eg-ay paat nangnangan issan cheycha ay akhew, awni ya ket ay naowaowat. ");
INSERT INTO lbk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kinwanin et Satanas ken siya, “Mo sik-a nan Anak nan Dios, ayed, filinem nan nay fato ta enfalin is tinapay.” ");
INSERT INTO lbk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kinwanin Jesus ay sinmongfat, “Kanan nan naisolat ay kalin Apo Dios en, ‘Faken yangkhay nan tinapay nan maikatakho.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sa et inpangon nan chimonyo si Jesus id tongcho, et inpailana is sin-ak-itan nan am-in ay en-ap-apowan isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sa na't kanan, “Am-in chasa ay kamabfalin ay en-ap-apowan ya nan am-in ay kaidchayawancha, et ichowak ken sik-a, tay naichowa am-in sa ken sak-en et mabfalin ay ichowak isnan olay sino ay laychek. ");
INSERT INTO lbk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","At kwam am-in chasa mo enlokfob ka't mampay ay manad-ayaw ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sinmongfat si Jesus ay mangwanin, “Kanan nan naisolat ay kalin Apo Dios en, ‘Enchayaw ka ken Apo Dios ay Diosmo, ya siya yangkhay nan ensilfiyam.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sa na't inpango siya id Jerusalem ya inyeyna is katoktok nan Timplo, sa na't kanan, “Mo sik-a nan Anak nan Dios, ayed lomabtok ka. ");
INSERT INTO lbk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tay kanan nan naisolat ay kalin nan Dios en, ‘At filinena nan anghelesna ay manokkhong ken sik-a.’ ");
INSERT INTO lbk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kanana akhes en, ‘At salapaencha sik-a ta ad-i maisogto nan sikim isnan fato.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sa et kasin sinmongfat si Jesus ay nangwanin, “Wen, ngem kanana met akhes en, ‘Ad-im teptepngen si Apo Dios ay Diosmo.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mid ad-i inangnen Satanas ay nannailo ken Jesus, ya osto'y siya chi, tinaynana is sin-ak-itan. ");
INSERT INTO lbk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tinmoli si Jesus id Galilea, ya wad-ay ken siya nan kamabfalin nan Ispirito Santo. Et nadngenadnge siya isnan olay entona ay ili ischi. ");
INSERT INTO lbk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Cha na sinkhep nan sinagogacha ay nen-isos-olo, sa cha't chinad-ayaw am-in siya. ");
INSERT INTO lbk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sa et sinmaa si Jesus id Nazaret ay naengnganana, ya isnan Sabfacho sinomkhep is kasinagoga tay siya nan inpaingsana. Tinmakcheg ay namasa isnan kalin Apo Dios, ");
INSERT INTO lbk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ya naichowa ken siya nan nalolokot ay liblon Isaias ay mamadton Apo Dios. Finitlagna chi sa na't inchanan nan nay ay naisolat, ");
INSERT INTO lbk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wad-ay nan Ispiriton Apo Dios ken sak-en. Tay pinilina sak-en ay mangiwalakhawag isnan Khawis ay Chamag isnan poposi. Infaana sak-en ay mangifaag isnan mabfafalod ay at maipalofos cha, ya isnan ad-i makaila ta at makaila cha kasin. Infaana sak-en ay mangipawaya isnan maliglikhatan, ");
INSERT INTO lbk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ya ta ipalawagko ay siya na nan tawen ay mangisalakan Apo Dios isnan takhona.” ");
INSERT INTO lbk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Linokot Jesus nan liblo ya insoblina isnan kafachang sa et tinmokcho ay nen-isolo. Iilaen am-in nan takho is kasinagoga siya. ");
INSERT INTO lbk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sa na't kinwani en, “Naangnen idwani kannay nan nay ay kalin Apo Dios isnan cha yo manngelan.” ");
INSERT INTO lbk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tinan-oyancha ya nataa cha am-in isnan khanag-awis ay kinkinwanina. Kinwanicha en, “Ay ke faken na san anak Jose?” ");
INSERT INTO lbk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sa na't kanan, “At kananyo ken sak-en nan nay ay al-alig, ‘Sik-a ay en-ag-akhas, akhasam nan awakmo.’ Nan laychenyo ay kanan ken sak-en et, ‘Angnem isnan osto ay ilim nan chinchinngemi ay inang-angnem id Capernaum.’ ");
INSERT INTO lbk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngem tet-ewa kanak ken chakayo, maid paat mamadto ay mafigfig isnan chadlos ilina. ");
INSERT INTO lbk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nay, ifaagko ken chakayo nan tet-ewa, angsan cha nan nailekkasan id Israel issan timpon Elias ay eg-ayna nen-od-odchanan is tolo ya kakhedwa ay tawen, ya chad-ama nan fitil isnan olay entona issa ay ili. ");
INSERT INTO lbk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ngem olay mo siya chi, egay paat infab-aan Apo Dios si Elias ay mamachang isnan olay esang ken chaicha, kecheng yangkhay nan esang ay mangili ay nailekkasan ay iSerepta id Sidon. ");
INSERT INTO lbk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Wad-ay akhes nan angsan ay nenkakolit id Israel isnan timpon nan mamadto ay si Eliseo, ngem maid paat olay esang is naipagkhawis ken chaicha, kecheng si Naaman ay mangili ay iSiria.” ");
INSERT INTO lbk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Peteg nan songet nan am-in ay wad-ay is kasinagoga issan nanngelancha ischi. ");
INSERT INTO lbk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Naligwat cha ya ala cha ya khoyod ken siya ay mangipafala is kaili. Khinoyodcha siya ay nangiyey isnan cheppas nan filig ay naikhab-an nan ilicha ta en cha ekchakhen. ");
INSERT INTO lbk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nay met achi nanalan is kakhawan nan mangal-alifongfong ay katakhotakho ya kinmaan. ");
INSERT INTO lbk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sa et khinomwab si Jesus id Capernaum id Galilea ay cha na nen-isos-olowan is kasinagoga isnan Sabfacho. ");
INSERT INTO lbk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Cha cha nataa isnan ikkana ay en-isolo, tay wad-ay pet kalebfengan nan kalina. ");
INSERT INTO lbk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ya ket wad-ay nan esang ay lalaki is kasinagoga ay naan-anitowan. Chadlos nenfogfokhaw ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Na! Sik-a Jesus ay iNazaret, ngag nan fiyangmo ken chakami? Ay inmali ka ngen ay mamakawas ken chakami? Ammok mo sino ka. Sik-a nan Nasantowan ay Faan Apo Dios!” ");
INSERT INTO lbk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngem yinangyangan Jesus ay nangwanin, “Khenekmo! Komaan ka ken siya!” Infasfas nan anito nan lalaki isnan sakhangcha am-in, sa et finmala siya ya egayna sinaksaktan nan lalaki. ");
INSERT INTO lbk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nataa am-in nan takho ay cha mangwani isnan ib-acha, “Ngag man chana ay kali? Tay ya ke wad-ay pet kalebfengana ya kamabfalina ay mamilin isnan anito ya fomala cha tet-ewa!” ");
INSERT INTO lbk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sa et nadngenadnge nan maipoon ken Jesus isnan olay entona isnan chey ay ili. ");
INSERT INTO lbk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kinmaan si Jesus is kasinagoga ya inmey is afong cha Simon. Wad-ay ischi nan katokhangan Simon ay fafai, ay ensaksakit ya chachama nan pochotna. Sa cha't nenseg-ang ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sinmag-en si Jesus ay nangoschong ken siya, ya yinangyangana nan pochotna ket ay nenkakkakaan. Ala na ya fangon sa na't panganen chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Issan osto'y sedsechemna, waschin et nangiyey ken Jesus isnan nenkasakit ken chaicha isnan nateketeken ay sakit. Kinkincheng Jesus ay nangappos ay nangipagkhawis ken chaicha am-in. ");
INSERT INTO lbk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nan cheycha'y anito ay finmala isnan cheycha'y sinkhepcha et nenfogfokhaw cha ay nangwanin, “Sik-a nan Anak nan Dios!” Nay met achi yinangyangan Jesus chaicha ya inpawana nan enkaliyancha, tay ammocha ay siya nan Cristo. ");
INSERT INTO lbk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Issan cha et mawiit, tinaynan Jesus nan ili ya inmey isnan maid paat tagtakhowan. Ngem ket ay inmey nan katakhotakho ay nangan-anap ken siya, ya osto'y inchanancha siya inpakodcha. ");
INSERT INTO lbk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngem kinwanina ken chaicha, “Masapol ay iwalakhawagko akhes nan Khawis ay Chamag maipoon isnan en-ap-apowan Apo Dios isnan tapina'y ili, tay siya nan khotok nan naibfaalak.” ");
INSERT INTO lbk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Et inmey nenpap-alawag isnan kasinagoga isnan olay entona ay ili id Judea. ");
INSERT INTO lbk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Isnan namingsan, wad-ay si Jesus ay tomatakcheg is kailit nan fayfay id Genesaret, ya inalifongfongan nan katakhotakho ta chengngencha nan isolona ay kalin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Inilana is kailit nan fayfay nan chwa ay fangka ay tinaynan nan cheycha'y mangadkhachiw ay cha mangowas isnan tafokorcha. ");
INSERT INTO lbk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Idwani, nen-agchang siya isnan esang ay fangka ay kwan Simon, sa na't infakha ken siya ta ipagpakheg-edna is akit nan fangka ta maiyadchawi is kalota. Sa et tinmokcho ischi ay nen-isos-olo isnan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kakwasan nan nen-isos-olowana, kinwanina ken Simon, “Iyeymo nan fangka is kaad-achaem ta oy-oyenyo nan iketyo.” ");
INSERT INTO lbk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Apo,” kinwanin Simon, “Iinsetmi met isnan maschem engkhana idwani ay wiit, ya ke maid paat inalami mo! Ngem khapo tay kanam, olay kasik oy-oyen nan iket.” ");
INSERT INTO lbk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Et osto ay inoy-oycha nan iketcha, ket ay angsaangsan tet-ewa nan inalacha ya nganngani mafakas nan iket. ");
INSERT INTO lbk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ala cha't ya kawad isnan kakadwacha is kaesang ay fangka ta omali cha ay mamachang ken chaicha. Sa cha't inmali ya pinnopinnocha nan chwa'y fangka ke cha't ay nganngani malin-eb. ");
INSERT INTO lbk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Issan nangil-an Simon Pedro isnan cha inmat, ala na et ya falintomeng isnan sakhang Jesus ay nangwanin, “Taynam sak-en, Apo, tay fomafasol ak!” ");
INSERT INTO lbk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Natakatakag cha ay enkakadwa isnan ad-achowan ay kinnacha. ");
INSERT INTO lbk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Siya akhes isnan tapina ay kakadwan Simon ay si Santiago ya si Juan ay anak Zebedeo. Kinwanin et Jesus ken Simon, “Ad-i ka omegyat. Tay mailapo kannay idwani, takho nan en ka khadchiwen.” ");
INSERT INTO lbk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sa cha't inpachaka nan fangkacha ya khinayadcha am-in nan ngag issa, ya naifoweg cha ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Isnan namingsan ay kawad Jesus isnan esa'y ili, sinmag-en nan lalaki ay chadlos nakolit. Issan chadlos na nangil-an ken Jesus, ala na ya eey is sakhangna ay nenlokfob ya nenseg-ang ken siya. Kinwanina, “Apo, mo sa ya laychem, et mabfalin ay pakhawisem sak-en.” ");
INSERT INTO lbk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kinappos Jesus nan nakolit ay nangwanin, “Laychek, khomawis ka!” Ya ket ay nenkakkakaan kannay nan kolitna. ");
INSERT INTO lbk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sa et finilin Jesus siya ay nangwanin, “Ad-im ifab-aag isnan olay sino nan sana ay inmat ken sik-a. Enchadchawes ka't ay en mangipaila isnan awakmo isnan pachi. Sam et ichowa nan chaton ay infilin Moises ay mangipaila isnan takho ay tet-ewa ay khinmawis ka.” ");
INSERT INTO lbk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngem am-amed kayet ay nadnadnge isnan olay entona, nan maipoon ken Jesus, et angsan cha nan katakhotakho ay inmey ken siya ay nannge isnan kalina ya nangipakaan isnan sakitcha. ");
INSERT INTO lbk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ngem si Jesus, omeomey isnan maid paat tagtakhowan ay en nenlol-owalo. ");
INSERT INTO lbk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Isnan namingsan ay cha en-isos-olowan Jesus, wad-ay cha nan nakitotokcho ay Fariseo ya mistolon si lenteg. Nalpo cha isnan am-in ay il-ili id Galilea, ya id Judea, ya id Jerusalem. Ya wad-ay ken Jesus nan kamabfalin Apo Dios ay mangipagkhawis isnan sakit. ");
INSERT INTO lbk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ya ket sanacha nan lallalaki ay mangiyal-ali isnan esang ay ad-i makagkhiwa ay lalaki ay maiyaamaka. Et inyan-anapcha nan angnencha ay mangiskhep ken siya is kasakhang Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nay met achi ad-icha makaiskhep khapo isnan katakhotakho, inlamagcha siya is kaatep, ya linekwabcha nan tapin nan minadchalilyo ay atep ischi, sa cha't inpagkhwab isnan sakhang Jesus is katengan nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Isnan nangilasinan Jesus isnan pammaticha, kinwanina isnan lalaki, “Kayong, napakawan et nan fasolmo.” ");
INSERT INTO lbk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ya ket ay kankanan nan cheycha'y mistolon si lenteg ya Fariseo is kasemekcha en, “Sino pan na's takho ay aped mangam-amsiw ken Apo Dios! Ay ke wad-ay makapakawan si fasol mod-i si Apo Dios yangkhay?” ");
INSERT INTO lbk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Si magtek Jesus, ammona nan semekcha, sa na't kanan, “Ngag man kasin nan en yo semkesemken? ");
INSERT INTO lbk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngag nan malanlanoy ay kanan, ‘Napakawan et nan fasolmo,’ paymo, ‘Fomangon ka ya manalan ka’? ");
INSERT INTO lbk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nay met achi ta mangammowanyo ay wad-ay kalebfengak ay Anak si Takho is kalota ay mamakawan isnan fasol, ay man et ta ipailak.” Et kinwanina isnan lalaki ay ad-i makagkhiwa, “Kanak ken sik-a, fomangon ka! Alaem nan kaseypam ta somaa ka!” ");
INSERT INTO lbk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ya isnan sakhangcha am-in, finmangon kannay sa na't inala nan kaseypana, et sinmaa ay nanad-ayaw ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sa cha't nenkatatakag, ya chinad-ayawcha si Apo Dios. Chadlos cha inmegyat ay nangwanin, “Chad-ama paat ay katataa nan naycha'y inila tako idwani.” ");
INSERT INTO lbk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Issan osto'y nakwas chachi, finmala si Jesus ya inilana nan esang ay enkorkortais ay enngachan is Levi. Wad-ay ay tomotokcho is kaenfob-owisana. Kinwanin Jesus ken siya en, “Maifoweg ka ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nenkaliligwat si Levi sa na't tinaynan nan am-in ya naifoweg ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Idwanin, nenpapiyasta si Levi is afongna. Angsan cha nan inmey ay enkorkortais ya nan tapina kayet ay makikan. ");
INSERT INTO lbk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ngem isnan nangil-an nan cheycha'y Fariseo ya nan ib-acha ay mistolon si lenteg isnan cheycha ay naamong, nenlili cha isnan disipolos Jesus, “En kayo man cha pet makikan ya makiinom isnan sanacha'y enkorkortais ya wasit ay takho ay?” ");
INSERT INTO lbk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sinfat et Jesus chaicha ay nangwanin, “Faken nan takho ay komekedse nan makasapol isnan choktor mod-i ket nan nasakit. ");
INSERT INTO lbk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Egay ak inmali ay mangayag isnan cheycha'y nalenteg, mod-i ket nan fomafasol ta enfafawi cha.” ");
INSERT INTO lbk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wad-ay cha nan nangwani ken Jesus, “Apo, entiptipe nan cheycha'y disipolos Juan, ta enlol-owalo cha et yangkhay. Siya akhes isnan disipolos nan Fariseo. Ngem ya ke pet cha ominom ya cha mangan nan disipolosmo mo?” ");
INSERT INTO lbk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sa et kinwanin Jesus, “Ay ke kayo makaiyad-i isnan makikkanan nan lilwid nan kaab-afong ay lalaki, mo sisya kayet siya ken chaicha? ");
INSERT INTO lbk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ngem at omali nan akhew ay maal-ana ken chaicha, at siya chachi ay akhew nan ad-i cha mangmanganan.” ");
INSERT INTO lbk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Inyalig kayet Jesus ken chaicha ay nangwanin, “Maid mamikis isnan falo ay fachona ta sa na't itakop nan chey pinikisna isnan lokhak. Tay at pakawasena't yangkhay nan falo ay facho, sa et ad-i akhes enfakhay nan falo ay lopot ya nan lokhak. ");
INSERT INTO lbk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Maid akhes mangippey isnan kakhag-aeb ay fayas isnan chaan ay kochil ay entey-an si fayas. Tay at paptoken nan falo ay fayas chi, ya ayyew et yangkhay nan kakhag-aeb ay fayas, olay nan nafakas ay pagfayyasan. ");
INSERT INTO lbk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nan magtek falo ay fayas, et masapol ay maippey isnan falo ay kochil ay pagfayyasan. ");
INSERT INTO lbk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Maid akhes kasin menlayad isnan kakhag-aeb ay fayas mo apchas et nakainom isnan naeteng ay fayas. Tay kanana en, ‘Khagkhag-awis nan naeteng.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Isnan esang ay Sabfacho, ay nanad-alanan cha Jesus is kapayewan, inmala nan cheycha'y disipolosna is kinotkotimcha. ");
INSERT INTO lbk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ket ay kinwanin nan tapin nan Fariseo en, “Ya ke yo pappaaten ay mangangnen isnan maipawa isnan tengaw ay Sabfacho ay?” ");
INSERT INTO lbk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sa et kanan Jesus, “Egayyo ngen finasa nan inangnen David ya nan cheycha'y fowegna issan naowatancha? ");
INSERT INTO lbk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sinomkhep si David isnan afong Apo Dios, ya kinmakan isnan tinapay ay naichoo ken Apo Dios. Sa na't inwalas isnan fowegna. Maipawa met chi isnan olay sino ay mangakan mo ad-i yangkhay nan papachi.” ");
INSERT INTO lbk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sa na't kinwani ken chaicha en, “Sak-en met ay Anak si Takho nan mangiyapo isnan tengaw.” ");
INSERT INTO lbk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Isnan esang kasin ay Sabfacho, sinomkhep si Jesus is kasinagoga ya nen-isos-olo. Ya ket ay wad-ay ischi nan esang ay lalaki ay nasakew nan kannawan ay limana. ");
INSERT INTO lbk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sa et tinotokkhongan nan cheycha'y mistolon si lenteg ya nan Fariseo si Jesus ta mangil-ancha mo en-akhas isnan Sabfacho ay tengaw, ta chomalat si mangipafasolancha ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ngem si Jesus, ammona nan semekcha, sa na't kinwani isnan chey nasakew nan limana, “Itakchegmo ta omali ka is katengana.” Tinmakcheg tet-ewa ya khinmawa. ");
INSERT INTO lbk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ya ket kinwanin Jesus, “Salodsochek na ken chakayo. Ngag nan ipalofos nan lenteg tako ay angnen isnan tengaw? En-angnen tako ngen isnan khawis paymo nan ngaag? En-isalak tako ngen paymo enpakawas tako isnan fiyag?” ");
INSERT INTO lbk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa et nenmonaang ken chaicha am-in, ya kinwanina isnan lalaki, “Oyachem nan limam.” Inangnena, ya ket khinmawis kasin nan limana. ");
INSERT INTO lbk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nay met achi amed cha sinmonget ya natotya cha mo ngag nan angnencha ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Issan chey ay timpo, linmamag si Jesus is kafilig ay en nenlowalo. Et sinlabfiyan ischi ay nenlol-owalo ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Issan kawiitana, inayakhana nan cheycha'y disipolosna sa na't pinili ken chaicha nan sinpoo ya chwa ay nginadnana is apostoles. ");
INSERT INTO lbk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Siya chana nan pinilina: Si Simon (ay nginadnan Jesus is Pedro), sa et nan akhina ay si Andres; cha Santiago ken Juan; cha Felipe ken Bartolome; ");
INSERT INTO lbk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","cha Mateo ken Tomas; si Santiago ay anak Alfeo; si Simon (ay nginadnancha is Zelot tay isaksakitna nan ilicha); ");
INSERT INTO lbk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas ay anak Santiago, ya si Judas Iscariote ay awni't mangitiktik ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pinmanad cha Jesus is kadchata. Ya wad-ay cha ischi nan angsan ay disipolosna ya nan angsan ay katakhotakho ay nalpo isnan kailiili id Judea, id Jerusalem, ya id Tiro ya Sidon ay ilit nan fayfay. ");
INSERT INTO lbk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inmali cha ay nannge ken Jesus ya nangipaakhas isnan sakitcha. Nan cheycha akhes ay naan-anitowan, naipagkhawis cha. ");
INSERT INTO lbk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ya waschin nenlayad ay manikchod ken siya, tay wad-ay nan kamabfalin ay malmalpo ken siya ay mangipagkhawis ken chaicha am-in. ");
INSERT INTO lbk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sa et iilaen Jesus nan disipolosna ya kinwanina en, “Naoney kayo ay mamigfig isnan kinakolangyo tay at maitapi kayo isnan en-ap-apowan Apo Dios! ");
INSERT INTO lbk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Naoney kayo ay kag maoowat idwani, tay at megsan kayo! Naoney kayo ay en-ag-akha idwani, tay at chadlo en-ango kayo!” ");
INSERT INTO lbk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Naoney kayo olay mo wad-ay menlilikhet ken chakayo, ya telachencha chakayo sa cha't am-amsiwen chakayo, paymo ippeycha ay ngaag nan ngachanyo khapo ken sak-en ay Anak si Takho. ");
INSERT INTO lbk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Siya, enlal-ayad kayo mo siya sa nan omat ken chakayo. Itaodyo nan lagsakyo, tay at chakchake nan fongaenyo id chaya. Siya akhes nan inang-angnen nan ikik-itcha isnan mamadton Apo Dios id sangad-om. ");
INSERT INTO lbk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngem chakayo ay fafaknang idwani, selaeg yo tay apchas yo chinawat nan enkhawisanyo. ");
INSERT INTO lbk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Selaeg yo ay maeegsan idwani, tay awni't maowat kayo! Ya chakayo ay aped en-ang-ango idwani, selaeg yo tay awni't aped kayo enngoyngoyos ya en-ag-akha! ");
INSERT INTO lbk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Selaeg yo akhes, mo khawis nan kankanan nan am-in ay takho ken chakayo. Tay siya akhes chadlo sa nan kalin nan ikik-itcha id sangad-om issan cheycha'y ad-i tet-ewa ay mamadto.” ");
INSERT INTO lbk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sa et kinwanin Jesus, “Ngem siya na nan ibfakhak ken chakayo ay mamannge ken sak-en: Laychenyo nan fosoyo. Khakhawisenyo nan menlikhet ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bindisyonanyo nan mangifotlog ken chakayo. Ilowalowanyo nan mangoyong ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mo wad-ay manodpak isnan ipingmo, ad-im ifales, mod-i ket ichoom kayet nan topakna. Mo wad-ay mangala isnan kakhaymo, iyoyam ta olay alaena kayet nan kamasitam. ");
INSERT INTO lbk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Agtam nan olay sino ay komchaw ken sik-a, ya mo wad-ay mangikaan isnan kwam, ad-im kasin anapen. ");
INSERT INTO lbk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Angnenyo isnan ib-ayo ay takho nan ngag issa ay laychenyo akhes ay angnencha ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mo nan yangkhay menlal-ayad ken chakayo nan laylaychenyo, ay ke wad-ay fongaenyo sidi? Tay olay nan fomafasol, laychencha nan menlayad ken chaicha! ");
INSERT INTO lbk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ya mo khakhawisenyo yangkhay nan cheycha'y mangagkhawis ken chakayo, ay ke wad-ay fongaenyo? Tay olay nan fomafasol, angnencha akhes sa! ");
INSERT INTO lbk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ya mo enpakhawat kayo yangkhay isnan cheycha ay ammoyo ay enfayad, ay ke wad-ay fongaenyo ischi? Tay olay akhes nan fomafasol et enpakhawat cha isnan ib-acha ay fomafasol ay mangisakhong isnan ostoosto ay khinawatcha. ");
INSERT INTO lbk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nan magtek angnenyo, et laychenyo nan kafosoyo. Khawisenyo chaicha. Enpakhawat kayo ya ad-iyo kasin sad-en nan maisakhongana. Mo siya chi nan angnenyo, at chakchake nan fongaenyo, ya maifilang kayo ay an-ak nan Katotongchowan, tay naanos siya isnan cheycha'y ngaag ya isnan cheycha'y ad-i mangammo ay ensofalit. ");
INSERT INTO lbk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Seg-anganyo mampay nan takho ay kag ken Amayo id chaya ay maseg-ang.” ");
INSERT INTO lbk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Sa et kinwanin Jesus, “Ad-iyo okomen nan ib-ayo ta ad-i akhes okomen Apo Dios chakayo. Ad-iyo pabfasolen nan ib-ayo, ta ad-i akhes okomen Apo Dios chakayo ay machosa. Pakawanenyo nan ib-ayo ya at pakawanen akhes Apo Dios chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Agtanyo nan ib-ayo ya at agtan akhes Apo Dios chakayo. Ad-acha nan ichowana ay kag isnan finayo ay nasalop isnan ostoosto ay salop ay nasedsesedsed sa et naiwegwewegweg ya enliblifas. Tay mo ngag nan kaad-achan nan ichowayo at siya akhes nan kaad-achan nan maichowa ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Inyalig kayet Jesus ken chaicha ay nangwanin, “Ay ke mabfalin ay ipangon nan esang ay nakolap nan ib-ana ay nakolap? Ad-i cha ngen mekchag ay chwa is kafito? ");
INSERT INTO lbk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maid disipolos is entongtongcho mo nan mistolona. Ngem mo linpas nan olay sino nan ad-achalena, at chadlo enfalin ay kag isnan chey ay mistolona.” ");
INSERT INTO lbk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Sa et kinwanin Jesus, “Em man isin-eng nan namolaw isnan matan nan ib-am, ya okhay nan sinlanges ay manasalak isnan matam kannay ay? ");
INSERT INTO lbk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ay kem aped kanan isnan ib-am en, ‘Kayong, ay ta kaanek nan sana'y mamofolaw isnan matam,’ ya ad-im ilaen nan sinlanges ay manasalak isnan matam? Sik-a ay kakas-okas-on! Kaanem pay ona nan sinlanges ay manasalak isnan matam, ta nalatak nan mangil-am ay mangaan isnan namolaw isnan matan nan ib-am.” ");
INSERT INTO lbk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kinwanin kayet Jesus, “Maid khawis ay kaew ay mamkhas is ngaag. Ya ad-i akhes mamkhas nan ngaag ay kaew is khawis. ");
INSERT INTO lbk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tay maammowan nan am-in ay kaew isnan fekhasna. Ad-i mapokhas nan higos isnan pagpakhat paymo nan ofas isnan sibsifit. ");
INSERT INTO lbk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kag tona tako akhes ay takho. Nan khawis ay takho, pabfalaena nan am-in ay khawis ay iigtona isnan semekna. Ngem nan ngaag ay takho, nan yangkhay ngaag ay naiigto is kasemekna nan ap-apatena. Tay mo ngag nan wad-ay ay semekna, siya akhes chi nan ap-apaten nan topekna.” ");
INSERT INTO lbk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sa et kinwanin Jesus, “En yo man kanan ken sak-en en Apo, Apo, ya ad-iyo angnen nan filinko ay? ");
INSERT INTO lbk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Iyaligko ken chakayo nan kasasaad nan takho ay omali ken sak-en ay mannge isnan kalik sa na't iyangnen: ");
INSERT INTO lbk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Siya nan kag isnan takho ay kinmaob engkhana ay inchasana nan fato ay tomakchekhan nan tokod nan cha na ipatood ay afongna. Awni ya ket nenlemlem ya chinmakchakowag nan anewang ya ab-afikas ay nanarsar isnan afong, ngem ad-i maiwegweg tay khawis nan naipatakchekhana. ");
INSERT INTO lbk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Nay met achi kag tona nan takho ay aped yangkhay manmannge isnan kalik ya ad-ina iyangnen: Siya nan kag isnan takho ay nangipatood isnan afongna isnan lota ay maid pegnadna. Osto ay lemlem ya ab-afikas nan anewang ay nanarsar isnan afong, ya ket nenkatotokang ya chad-ama nan inangnena ay napakawas.” ");
INSERT INTO lbk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sa et inmey si Jesus id Capernaum issan nakwasan nan nen-isos-olowana isnan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wad-ay ischi nan kapitan si sorchacho ay iRoma ay masaksakit nan patpatkhena ay faana ya nganngani matey. ");
INSERT INTO lbk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Osto'y chinngen nan kapitan nan maipoon ken Jesus, infaana nan tapin nan amam-an nan Judio ay omey enseg-ang ken Jesus ta omali ay mangipagkhawis isnan faana. ");
INSERT INTO lbk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Inmey cha ken Jesus ya nenseg-aseg-ang cha ay nangwanin, “Tet-ewa ay nan tona ay takho et lebfengna'y mabfachangan. ");
INSERT INTO lbk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tay laylaychena chatako ay Judio, ya siya nan nangipakhaeb isnan sinagoga tako.” ");
INSERT INTO lbk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sa et naifoweg si Jesus ken chaicha. Issan nganngani cha'y omchanan isnan afong, infaan kannay san kapitan nan lil-iwidna ay en mangibfakha ken Jesus, “Apo, ad-i ka kasin enfelay ay omali, tay ad-i ak maikali ken sik-a, ta chadlos ka somkhep isnan afongko. ");
INSERT INTO lbk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ya olay akhes sak-en, ad-i ak maikali ay aped omali ken sik-a. Ifilinmo koma et yangkhay, ya at omanay chi is mangipagkhawis isnan faak. ");
INSERT INTO lbk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Maawatak sa tay sak-en akhes, wad-ay nan entongtongcho mo sak-en, ya wad-ay cha akhes nan iyap-apowak ay sorchachok. Kanak yangkhay isnan esang, ‘Omey ka ischi,’ et omey. Sa et isnan esang kayet kanak en, ‘Omali ka,’ ya omali. Ya isnan faak kanak en, ‘Angnem na,’ et angnena. Isonga ammok ay kafaelam.” ");
INSERT INTO lbk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Osto'y chinngen Jesus chi, nataa, sa et nensakhong isnan katakhotakho ay inmonod ken siya ay nangwanin, “Ibfakhak ken chakayo, ay maid paat inilak is kag tona ay pammati isnan olay sino isna id Israel.” ");
INSERT INTO lbk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Issan tinmoliyan nan cheycha'y nafaa is afong nan kapitan, inchanancha nan chey faa ay apchas khinmawis. ");
INSERT INTO lbk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Awni ya ket inmey cha Jesus isnan ili ay makwani en Nain. Naifoweg ken siya nan disipolosna ya nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Issan cha cha omchanan isnan pantew nan ili, ke cha't ay sab-aten nan angsan ay omili ay en mangikaob isnan fab-alo ay kedkecheng si anak nan nailekkasan. ");
INSERT INTO lbk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chachama ay naseg-ang si Jesus issan nangil-ana isnan ina, sa na't kanan, “Ad-i ka en-akha.” ");
INSERT INTO lbk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sa et sinmag-en ay nangegnan isnan alongan, ya tinomke nan cheycha'y nangaawit. Sa et kinwanin Jesus, “Anakko, kanak ken sik-a, fomangon ka.” ");
INSERT INTO lbk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ya ket tet-ewa finmangon ya nakannali. Sa et inchawat Jesus ken inana. ");
INSERT INTO lbk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ke cha't ay inmegyat am-in ya chinad-ayawcha si Apo Dios. Kankanancha en, “Da! Naay nan matangtangad ay mamadton Apo Dios ay inmali ken chatako!” Kinwanicha akhes en, “Nay, inmali si Apo Dios ay mamachang isnan takhona!” ");
INSERT INTO lbk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kasin et nadngenadnge nan nay maipoon ken siya isnan am-in ay ili id Judea ya isnan malilwes ay ili. ");
INSERT INTO lbk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Idwani, nan disipolos Juan, infakhacha ken siya nan am-in ay cha inmat. Sa na't inayakhan nan chwa ken chaicha ");
INSERT INTO lbk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ya finaana chaicha ay omey ken Apo Jesus ta salodsochencha ay mangwani en, “Ad-i ngen sik-a san nakwani ay at omali, paymo som-ed kami ngen si teken?” ");
INSERT INTO lbk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Osto'y inomchan cha ken Jesus kinwanicha, “Finaan Juan Bautista chakami ay mangwani en, ‘Ad-i ngen sik-a san nakwani ay at omali, paymo som-ed kami ngen is teken?’ ” ");
INSERT INTO lbk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Siya kannay chi ay timpo nan cha nangag-akhasan Jesus isnan angsan ay nenkasakit isnan nateketeken ay sakitcha. Siya akhes nan cha na nangipafal-an isnan anito isnan tapina ay naan-anitowan, ya nan nangipakhawisana isnan matan nan angsan ay ad-i makaila. ");
INSERT INTO lbk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Adi kad sinfat Jesus nan disipolos Juan ay nangwanin, “Tomoli kayo ya ibfakhayo ken Juan nan am-in ay inilayo ya chinngeyo: Nan nakolap, makaila cha kasin, nan napilay, makachalan cha, naipagkhawis nan nakolit, makadnge nan natoweng, naipatakho nan natey, ya cha maipalawag nan Khawis ay Chamag isnan posi. ");
INSERT INTO lbk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Naoney yangkhay nan takho ay ad-i enchwadchwa ken sak-en!” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Issan osto'y kinmaanan nan infaan Juan, inokhod Jesus isnan katakhotakho nan maipoon ken Juan. Kinwanina, “Ngag kay nan kananyo ay katatakhon nan en yo inila is kaponchag? Kag ngen isnan fololong ay pakhig-iwwen si chakhem? ");
INSERT INTO lbk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngag nan en yo inila ischi? Nan ngen enfafacho is khawigkhawis ay enchangchangnge ay lopot? Nan man takho ay khanag-awis nan fachocha ya finofoslon nan fiyagcha, wad-ay cha isnan afong nan ali. ");
INSERT INTO lbk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngag nan en yo inila? Esang ngen ay mamadto? Siya. Ya kanak ken chakayo ay wadwad-ay kayet mo nan mamadto nan inilayo. ");
INSERT INTO lbk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tay si Juan nan nakwani isnan naisolat ay kalin Apo Dios ay mangwanin, ‘Chey, faalek nan faak ay mang-ona mo sik-a, ta isakhanana nan kew-am.’ ");
INSERT INTO lbk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kanak ken chakayo ay isnan am-in ay naiyanak, maid entongtongcho mo si Juan. Nay met achi olay mo siya sa, maifilang kayet ay naon-oney mo siya nan kafan-ikhan ay takho ay maitapi isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Am-in nan takho ya nan cheycha'y enkorkortais chinchinngecha nan kinwanina. Chaicha nan sikhod ay namigfig isnan kinalenteg Apo Dios ya nay et nenpafonyag cha ken Juan. ");
INSERT INTO lbk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ngem nan Fafariseo ya nan mimistolon si lenteg, inad-icha nan pangkhep Apo Dios ken chaicha, et egay cha nenpafonyag ken Juan. ");
INSERT INTO lbk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sa et kinwanin Jesus, “Ngag et kay nan mangiyalikhak isnan naycha ay takho idwani? Ngag kay nan kais-isocha? ");
INSERT INTO lbk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kag cha paat san ongang-a ay en-ay-ayam is kamarkitan ay maid paat pasiyat-encha. Kanan nan esang en, ‘Mamattong kami ngem ad-i kayo met manayaw. Ilapomi ay en-antoway ngem ad-iyo met afayan.’ ");
INSERT INTO lbk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Idwani, inmali si Juan Bautista ay cha nentiptipe ya eg-ay inmin-inom si fayas, ya kananyo en, ‘Naan-anitowan!’ ");
INSERT INTO lbk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sak et akhes inmali ay Anak si Takho ay makikkikan ya makiin-inom, ya ket ay kananyo akhes en, ‘Chey na! Ilaenyo kay nan takho ay nay ya! Oklong ya foteng yangkhay nan ammona. Liwid si enkorkortais ya wasit ay takho.’ ");
INSERT INTO lbk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngem olay, tay nan kinatet-ewan nan silib Apo Dios et maipaila ay chadlos isnan fiyag nan manawat ischi.” ");
INSERT INTO lbk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Awni ya inayakhan nan esang ay Fariseo si Jesus ay en makikan is afongna. Et inmey si Jesus ya nakiofong. ");
INSERT INTO lbk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Idwani wad-ay nan esang ay omili ischi ay asi ay fafai, ay nannge ay wad-ay si Jesus is afong nan Fariseo ay cha makikan. Ala na't ya eey ken Jesus ya intakina nan fotilya ay alabastro ay entetey-an nan nafanglofanglo ay lana. ");
INSERT INTO lbk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sa et tinmokcho is kachokogna ay nen-ag-akha engkhana ay infena nan sikin Jesus isnan akhana. Sa na't cha kannay ponasan isnan fookna ay cha mamisfisito ischi. Sa na't lanaan isnan chey ay fangfanglo. ");
INSERT INTO lbk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Issan nangil-an nan Fariseo ay nangayag ken siya, kinwanina isnan semekna, “Mo sa ya tet-ewa ay mamadto na, et man ammona mo sino nan nay ay fafai ay mangeg-egnan ken siya ya mo ngag nan katatakhona. Ammona koma ay asi nan okhalina.” ");
INSERT INTO lbk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ya ket kinwanin Jesus, “Simon, wad-ay nan laychek ay ifaag ken sik-a.” “Wen, Mistolo, kanam et mampay,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Wad-ay nan chwa ay nakaotang isnan enpaot-otang. Nan esang, liman khasot ay denaryo nan otangna, ya nan esang liman poo. ");
INSERT INTO lbk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Et tay ad-i cha makafayad isnan inotangcha, pinakkawana chaicha. Idwani, sino et ken chaicha ay inmotang nan wadwad-ay nan layadna isnan enpaot-otang?” ");
INSERT INTO lbk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sinmongfat si Simon ay nangwanin, “Away achi nan napakawan is ad-ad-acha.” “Naitneng nan songfatmo,” kinwanin Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sinakhongna't san fafai sa na't kanan ken Simon, “Ilaem achi nan cha angnen nan fafai ay nay. Minangilim tet-ewa sak-en isnan afongmo, ngem eg-ay ka inmagtan is chanom ay maiyowas isnan sikik. Ngem nan nay ay fafai, infena nan sikik isnan akhana sa na't pinnonasan isnan fookna. ");
INSERT INTO lbk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Eg-ay ka finmisito, ngem si tona, eg-ay tinomtomke ay namisfisito isnan sikik nailapo issan inmaliyak. ");
INSERT INTO lbk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Egaymo linanlanaan nan olok, ngem siya, inappoapposana nan sikik isnan lana ay nafanglofanglo. ");
INSERT INTO lbk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tay siya chi, ifaagko et ken sik-a ay nan nay chachama ay layad ay inpailana, siya nan mangipaila ay apchas et napakawan nan angsan ay fasolna. Ngem nan takho ay akit nan fasolna ay napakawan, et akit akhes nan layad ay ipailana.” ");
INSERT INTO lbk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sa na't kinwani isnan fafai, “Napakawan et nan fasolmo.” ");
INSERT INTO lbk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ya ket nan cheycha'y tapina ay nakikan, kinwanicha isnan semekcha, “Sino man nan nay takho ay olay pet nan fasol, ya pakawwanena?” ");
INSERT INTO lbk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ngem kinwanin Jesus isnan fafai, “Nan sana ay pammatim nan nangisalak ken sik-a. Omey ka et oompa nan semekmo.” ");
INSERT INTO lbk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nawnawni kasin nenfaat si Jesus isnan kailiili ay nangipap-alawag isnan Khawis ay Chamag maipoon isnan en-ap-apowan Apo Dios. Naifob-oweg nan cheycha'y sinpoo ya chwa ay disipolosna, ");
INSERT INTO lbk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ya nan tapina ay fabfafai ay inpagkhawis Jesus isnan sakitcha ya nan fabfafai ay nangipakaanana isnan anito ay nankhep ken chaicha. Chaicha cha Maria (ay makwanin Magdalena) ay nakaanan nan pito ay anito; ");
INSERT INTO lbk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","si Juana ay asawan Cusa ay ap-apo isnan afong Herodes; si Susana; ya nan angsan kayet ay fabfafai ay cha finmachang ken cha Jesus isnan ikatakhocha. ");
INSERT INTO lbk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Naam-among ken Jesus nan chadlos angsan ay takho ay nalpo isnan kailiili, sa na't inokhod nan nay ay al-alig: ");
INSERT INTO lbk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wad-ay nan inmey nensapowak is esek. Isnan cha na nen-isapowakan, wad-ay nan cha nap-as is kachalan, ya cha cha nagkhatinan ya tinopek nan ay-ayam. ");
INSERT INTO lbk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wad-ay akhes nan nap-as isnan lota ay cheppas nan enchaem, ya osto ay cha cha tomofo, ke cha't ay nenkaloloyaw tay kolang nan chanom. ");
INSERT INTO lbk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nan akhes tapina, nap-as cha is kasibsifitan, ya osto'y tinmofo nan sibsifit, sinolincha et nan cha tomofo ay esek. ");
INSERT INTO lbk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nan akhes tapina, nap-as cha isnan khawis ay lota ya siya chachi nan tinmofo ay khawis ya nenfekhas cha is sinkhagsot.” Sa et inyanongos Jesus nan okhodna ay nangipapangekhe ay nangwanin, “Chengngenyo mampay chana, mo wad-ay kowengyo ay mannge!” ");
INSERT INTO lbk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Awni ya ket pinoot nan disipolos Jesus nan ayen nan chey ay al-alig. ");
INSERT INTO lbk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sa et kinwanin Jesus en, “Chakayo nan naipaammowan nan sikhod ay egay naammowan maipoon isnan en-ap-apowan Apo Dios. Ngem isnan tapina et nan al-alig nan maosar ay mangipaammo ken chaicha isnan naycha, tatno olay mo chadlos cha iilaen, pakebtencha ay ad-i mangila, ya olay mo chechengngencha, ad-i cha maawatan.” ");
INSERT INTO lbk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Idwani, kag tona nan ayen nan chey ay al-alig,” kinwanin Jesus. “Nan chey ay esek, siya nan kalin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nan chalan ay nap-asan nan esek, siya nan kaiyalikhan nan takho ay mannge isnan kalin Apo Dios, ngem naanali nan Chimonyo ay nangamas is kasemekcha nan chinngecha ay kali ta ad-i cha mamati ya maisalakan. ");
INSERT INTO lbk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Nan lota ay cheppas nan chaemna ay nap-asan nan esek, et maiyalig isnan takho ay mannge isnan kalin Apo Dios sa cha't ala ya chawat ay mangilayalayad. Ngem tay egay linmamot isnan semekcha, sin-ak-itan nan pammaticha. Et isnan omchanan nan mapalikhatancha at ipeg-anancha kannay nan pammaticha. ");
INSERT INTO lbk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Nan kasibsifitan ay nap-asan nan esek, et maiyalig isnan cheycha'y mannge, ngem aw-awni ya ket nan ayaka ay chanag ya kinafaknangcha ya laglagsakcha isnan nay ay lota nan manolin isnan chinngecha, et nay ad-i maengngan nan pammaticha. ");
INSERT INTO lbk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Nan akhes khawis ay lota ay nap-asan nan tapina, et chaicha nan takho ay mannge isnan kalin Apo Dios, sa cha't igto isnan tet-ewa ya khawis ay semekcha, ya eestencha engkhana ay mamkhas nan pammaticha,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kinwanin kayet Jesus, “Maid takho is mamaskhed isnan silaw sa na't tangfan isnan fanga paymo padchaowen is kamaseypana. Ippeyna magtek isnan osto ay kaipatpatangana, ta nan somkhep et ilaencha nan silaw. ");
INSERT INTO lbk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Siya akhes ay maid maitatafon idwani ay at ad-i maipaila. Maid maitatafon idwani ay ad-i maammowan ya maipalawag is tap-in. ");
INSERT INTO lbk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ilaenyo et mampay ay khawis nan angnenyo ay enchenge. Tay nan mangidno isnan wad-ay ken siya, at maagtan kayet. Ngem nan maiyalig ay maid mabfalina ay ad-i mangidno isnan wad-ay ken siya, olay nan akit ay semsemkena ay wad-ay ken siya, et makaan.” ");
INSERT INTO lbk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inmey nan inan Jesus ya nan aag-ina ay nangila ken siya, ngem ad-i cha makasag-en khapo isnan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kinwanicha ken siya, “Apo, wad-ay cha inam ya nan aag-im ay entatakcheg is kadchela. Laychencha ay mangila ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sa et kinwanin Jesus, “Nan inak ya nan aag-ik, chaicha nan mannge isnan kalin Apo Dios ya angnencha.” ");
INSERT INTO lbk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Isnan namingsan nenlokhan cha Jesus ya nan disipolosna isnan fangka. Kinwanina en, “En tako is chemangna.” Sa cha't naligwat ay inmey. ");
INSERT INTO lbk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Issan cha cha omayan, naseyep si Jesus. Ya ket ay wad-ay nan chad-ama ay chakhem is kafayfay, ya cha et mapsong nan fangka engkhana ay nganngani cha'y malin-eb. ");
INSERT INTO lbk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ala cha't ya fangon ken Jesus. “Apo! Apo! Nay malin-eb tako!” kinwanicha. Finmangon ay nangipatke isnan chakhem ya nan chakchake ay talipyakew. Et inompa tet-ewa nan fayfay ya ket kakhigkhinek chadlo. ");
INSERT INTO lbk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sa na't kanan ken chaicha, “Ento pay nan pammatiyo?” Nay met achi sisya kayet san egyatcha ya taacha, ya cha cha kanan, “Sino mampet na ay takho? Ya ke pet olay nan chakhem ya chanom et filinena ya patiyencha tet-ewa siya!” ");
INSERT INTO lbk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sa cha't inomchan isnan ilin nan iGerasa, ay chechemangen nan fayfay id Galilea. ");
INSERT INTO lbk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ya osto ay chinmaka si Jesus, sinab-at nan naan-anitowan ay lalaki ay omili ischi. Inmannong ay aped enlalalalafos, ya faken isnan afong, mod-i ket is kaliyang si natey nan entetey-ana. ");
INSERT INTO lbk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kad-ikad-in malokhanan siya isnan anito et olay mo maifalod ya makadchinaan nan lima ya sikina, sinokpotna kayet chachi, ya kasin piliten nan anito ay mangittolong ken siya is kaponchag. Issan nangil-ana ken Jesus, ala na't ya wakis ya lokfob isnan sakhangna ay nangifokhaw, “Ngag nan fiyangmo ken sak-en Jesus ay Anak nan Katotongchowan? Pangngaasim ta ad-i ka omipalikhat!” Siya sa nan kinwanina tay apchas finilin Jesus nan anito ay fomala ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sa et kinwanin Jesus, “Ngag nan ngachanmo?” “Kalifolifo,” kinwanina, tay angsan cha ay anito nan nangeegnan ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sa cha't nenseg-aseg-ang ken Jesus ta ad-ina filinen chaicha ay omey isnan fito ay maid pengpeng nan kachaemna. ");
INSERT INTO lbk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Idwani, wad-ay akhes isnan chey ay ponchag nan angsan ay fotog ay cha en-anglod. Sa et inseg-ang nan kaanianito ta somkhep cha isnan cheycha'y fotog. Et tinan-oyan Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nabfanala kannay nan kaanianito isnan chey ay lalaki sa cha't ala ya sekhep isnan kafotofotog. Ke cha't ay ala ya tagtag is katoy-ob ay enchadchawes is kafayfay sa cha't nalin-eb. ");
INSERT INTO lbk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Issan nangil-an nan enpaspastor isnan chey ay inmat, linmayaw cha, sa cha't inmey isnan olay entona ay kawad si afong isnan chey ay ili ay nangipadnge isnan chey ay inmat. ");
INSERT INTO lbk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Et nakhogkhog-oy nan katakhotakho ay inmey nangila ischi. Inmey cha ay nangchan ken Jesus ya inilacha san chey lalaki ay nakaanan san kaanianito. Tinmotokcho is kasag-en nan sikin Jesus ya nabfachowan et, sa et inomchan chadlo nan osto ay semekna. Sa cha't inmegyat. ");
INSERT INTO lbk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nan cheycha akhes chadlos nangila isnan chey ay inmat, inog-okhodcha nan naangnen isnan naan-anitowan ay naipagkhawis. ");
INSERT INTO lbk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sa et am-in nan omili ay iGerasa, inpakaancha si Jesus isnan ilicha tay isnan chad-ama ay egyatcha. Et nenlokhan is kafangka si Jesus ya tinmoli. ");
INSERT INTO lbk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Osto'y siya chi, nenseg-ang ken Jesus san chey lalaki ay nakaanan nan kaanianito ta maifoweg ken siya. Ngem inpasaan Jesus ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Somaa ka ta em ifaag nan am-in ay inangnen Apo Dios ken sik-a.” Et inmey tet-ewa ay nangifab-aag isnan am-in ay kailiyana, nan maipoon isnan am-in ay inangnen Jesus ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Issan tinmoliyan Jesus is chemangna, chachama nan layad nan katakhotakho, tay siya nan sadsad-encha. ");
INSERT INTO lbk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Idwani, wad-ay nan inmey ken Jesus ay esang ay mangichad-alan isnan sinagogacha ay enngachan is Jairo. Nenfalintomeng ay nentowad ken Jesus ay nenseg-ang ta chomag-os is afongna, ");
INSERT INTO lbk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tay nan es-esang ay anakna ay fafai ay away nget entawen is sinpoo ya chwa et matmatey. Naifoweg si Jesus, et issan omay-ayana, inalifongfongan nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wad-ay akhes ischi nan esang ay fafai ay eg-ay nasnaschok nan kachawyana is sinpoo ya chwa ay tawen. Inamasna am-in nan kwana isnan nen-atoatonana ay nenpaag-akhasan, nay met achi maid paat nakaipagkhawis ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Inmey is kadchokog Jesus sa na't sinikchod nan khayachan nan fachona. Ya ket tinomke kannay nan chala ay fomab-ala ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sa et sinalodsod Jesus ay nangwanin, “Sino nan sinmikchod?” Idwani tay kinwanicha am-in ay faken cha, kinwanin et Pedro en, “Apo, ya ke man sanacha nan katakhotakho ay menliliwes ya mangal-alifongfong ken sik-a ya!” ");
INSERT INTO lbk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngem cha kayet kanan Jesus, “Wad-ay nan sinmikchod, tay liniknak ay finmala nan kamabfalin ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Osto ay nadlaw nan fafai ay naammowan ay siya, nentat-ayenten ay inmey ken Jesus ya nenfalintomeng isnan sakhangna. Sa na't infaag isnan am-in ay katakhotakho nan khotok nan nanikchochana ken siya ya nan nakhannawisana. ");
INSERT INTO lbk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sa et kinwanin Jesus, “Anakko, inpagkhawis nan pammatim sik-a. Omey ka et oompa nan semekmo.” ");
INSERT INTO lbk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Issan cha mangwaniyan Jesus ischi, ket ay inmali nan esang ay faa ay nalpo is afong Jairo ay nangwanin, “Apo, natey et nan anakmo. Ad-im kasin sangawen nan Mistolo.” ");
INSERT INTO lbk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngem tay chinngen Jesus chi kinwanina ken Jairo, “Ad-i ka omegyat. Mamati ka yangkhay, ya at khomawis siya.” ");
INSERT INTO lbk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Osto'y inomchan cha is afong, maid inpaspaskhepna, kecheng yangkhay cha Pedro, Juan, ya si Santiago, sa et nan ama ya inan nan ong-onga. ");
INSERT INTO lbk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Waschin cha aakha nan takho ay nangad-achog isnan ong-onga. Kinwanin et Jesus, “Ad-i kayo en-akha. Egay natey siya, mamaseyep yangkhay!” ");
INSERT INTO lbk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sa cha't inang-ango si Jesus, tay ammocha ay natey. ");
INSERT INTO lbk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngem inalana nan limana ay nangwanin, “Anak, fomangon ka!” ");
INSERT INTO lbk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ya ket sinmakhong san leng-agna ya ala na't ya fangon. Sa et infilin Jesus ta panganencha. ");
INSERT INTO lbk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nataataa cha amana ken inana, ngem ya ket ay infilin Jesus ta ad-icha ifab-aag nan chey ay inmat isnan olay sino. ");
INSERT INTO lbk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Inayakhan Jesus nan sinpoo ya chwa ay disipolosna sa na't inagtan chaicha is kamabfalin ya kalebfengancha ay mangipakaan isnan am-in ay anito ya mangag-akhas isnan kasakisakit. ");
INSERT INTO lbk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sa na't infaa chaicha ay mangipalawag maipoon isnan en-ap-apowan Apo Dios, ya mangipagkhawis isnan masasakit. ");
INSERT INTO lbk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kinwanina ken chaicha, “Ad-i kayo en-itaktakin is olay ngag isnan enfaatanyo. Maid sokod, sopot, makakan, siping, paymo ensokatanyo. ");
INSERT INTO lbk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ya olay sino ay menmangili ken chakayo, entetee kayo yangkhay isnan afongcha engkhana ay taynanyo nan chey ay ili. ");
INSERT INTO lbk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sa et mo wad-ay ili ay ad-i manawat ken chakayo, taynanyo, ya isnan komaananyo, pagpakhenyo nan sikiyo ta makaan nan pinomket ay chapog nan chey ay ili, ay kag manokhon ken chaicha.” ");
INSERT INTO lbk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sa cha't naligwat ay nenfab-aat isnan kailiili ay nangipap-alawag isnan Khawis ay Chamag ya nangipagkhawis isnan nenkasakit isnan olay entona. ");
INSERT INTO lbk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Si Herodes ay khofernachor, chinngena nan am-in ay in-inmat, et maid osto is semkena tay kanan nan tapina en kasin finmangon si Juan Bautista isnan etey. ");
INSERT INTO lbk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nan tapina akhes kanancha en nenpaila si Elias, ya wad-ay kayet nan mangmangwani en kasin natakho nan esang isnan cheycha'y mamadto id solit. ");
INSERT INTO lbk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sa et kinwanin Herodes, “Inpapotlongko met nan olon Juan, ngem sino man na ay cha maog-okhod isnan kag tonacha ay chak chengngen?” Siya chi't ya lalaychena ay mangila ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tinmoli nan cheycha'y apostoles, ya infab-aagcha nan am-in ay inang-angnencha. Sa et inayakhan Jesus chaicha yangkhay ay omey isnan ili ay Betsaida. ");
INSERT INTO lbk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Issan magtek nangammowan nan katakhotakho isnan inmayana ischi, inonodcha siya. Khinagkhawisna ay nanawat ken chaicha, sa na't infab-aag nan maipoon isnan en-ap-apowan Apo Dios, ya inakhasana akhes nan makasapol isnan khomawisancha. ");
INSERT INTO lbk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Issan cha malonokhan nan akhew, inmey nan sinpoo ya chwa ay disipolosna ay nangwani ken siya, “Kanam et achi isnan katakhotakho ta en cha't omanap is manganancha ya omyanancha isnan sanacha ay ili, tay ponchag na.” ");
INSERT INTO lbk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngem kinwanin Jesus ken chaicha, “Panganenyo chaicha.” Sa cha't kanan, “Kedkecheng paat nan lima ay tinapay ya chwa ay filis nan wad-ay ya! Laychem ngen ay en kami ilakwan nan katakhotakho ay naycha is kanencha?” ");
INSERT INTO lbk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Tay inmey si liman lifo ay lallalaki nan wad-ay ischi.) “Patokchowenyo chaicha is sinpapangfon. Olay masinlilman popoo cha,” kinwanin Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Et siya chi nan inangnen nan disipolosna, inpatokchocha am-in nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Inalan Jesus nan chey lima ay tinapay ya chwa ay filis ya nentangad id chaya ay nenyaman, sa na't pinet-apet-ang ya inchowana isnan disipolosna ta iwalascha isnan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nangan cha't am-in ya nabsog cha, ya nan nakhayad ay tinapay ay cha chinakhop nan disipolosna et sinpoo ya chwa ay labfa. ");
INSERT INTO lbk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Isnan namingsan, nakekecheng si Jesus ay nenlowalo isnan kawad nan disipolosna. Awni ya sinalodsodna ken chaicha ay mangwanin, “Sino ak isnan semek nan takho?” ");
INSERT INTO lbk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“Kanan nan tapina ay sik-a si Juan Bautista, ngem nan tapina kanancha ay sik-a si Elias, ya wad-ay akhes nan tapina ay mangwanin esang ka isnan cheycha'y mamadto id sangad-om ay kasin natakho.” ");
INSERT INTO lbk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Chakayo kay, sino ak isnan semekyo?” kinwanina. Sinmongfat si Pedro ay nangwanin, “Sik-a nan Criston Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sa et finilifilin Jesus chaicha ta ad-icha ifab-aag chi isnan olay sino. ");
INSERT INTO lbk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sa na't kayet kanan, “Sak-en ay Anak si Takho, masapol ay chadlos maipap-alikhat ya maad-i ak isnan amam-an si Judio, nan aap-apon si papachi, ya nan mimistolon si lenteg. Sak et maipapatey, ya isnan maikatlo ay akhew et maipatakho ak.” ");
INSERT INTO lbk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sa na't kinwani ken chaicha am-in, “Mo sino nan menlayad ay maifoweg ken sak-en, masapol ay lichongana nan awakna ya kawakawakas ay awitena nan kolosna ya maifoweg ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tay mo sino nan ad-i mangayyew isnan fiyagna ta olay matey midkakay ken sak-en, at maisalakan. Ngem nan takho ay chadlos mangisalak isnan fiyagna at khechangna ay amasena. ");
INSERT INTO lbk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ay ke wad-ay fongaen nan takho olay mo kowaena am-in nan wad-ay isnan lofong, mo siya chi kannay nan maamasana paymo maafakana? ");
INSERT INTO lbk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tay nan mabfain ay mangitakcheg ken sak-en ya nan sos-olok, siya akhes ay mabfain ak ay Anak si Takho ay mangitakcheg ken siya isnan omaliyak isnan katangtangachak ya isnan kamabfalin Ama ya nan nasantowan ay anghelesna. ");
INSERT INTO lbk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngem ibfakhak ken chakayo nan tet-ewa, at wad-ay ken chakayo isna nan ad-i mangippeng isnan etey engkhana ay ilaencha nan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nar-os et nan away esa'y chomingkho issan nangifag-an Jesus isnacha, sa et inmey is kafilig ay nenlowalo. Intakina cha Pedro, Juan ya si Santiago. ");
INSERT INTO lbk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Issan cha na enlol-owalowan, ket ay tinmeken nan kamesna ya nan fachona nenfalin ay chad-ama'y somili. ");
INSERT INTO lbk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sa et nenkawawad-ay nan chwa ay lallalaki ay nakitot-oya ken siya. Chaicha cha Moises ken Elias ");
INSERT INTO lbk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ya chachama ay somili nan ilacha. Tinot-oyacha si Jesus maipoon isnan maangnenan nan pangkhep Apo Dios ken siya ay siya nan at mateyana id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Idwani, naseyeseyep cha Pedro, ya osto'y finmangon cha ya ket inilacha nan katangtangachan Jesus ya nan chwa ay lalaki ay nakitaktakcheg ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Issan nanaynanan nan chwa'y lallalaki ken Jesus, kinwanin et Pedro ken siya, “Apo, khawis pet nan wad-ayan tako isna. Khomaeb kami is tolo ay ab-afong, enkwam nan esang, kwan Moises nan esang, ya kwan akhes Elias nan esang.” (Tay ad-ina ammo nan kankanana.) ");
INSERT INTO lbk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sa et isnan enkak-aliyana, inmali nan lifoo ay nangap-ap ken chaicha sa cha't naegyatan isnan nalibfoowancha. ");
INSERT INTO lbk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sa et nadnge nan kali ay nalpo is kalifoo ya mangwanin, “Siya na nan Anakko ay pinilik. Chengngenyo siya!” ");
INSERT INTO lbk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Osto'y khinminek nan cha enkali, kedkecheng et si Jesus is wad-ay. Mailapo issan chey inkhigkhinek et yangkhay cha Pedro, ya maid paat nangifagfag-ancha isnan chey ay timpo nan olay ngag sisa ay inilacha. ");
INSERT INTO lbk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Issan kawaksana nen-eseg cha't ay nalpo isnan filig, ya chadlos angsan nan takho ay inmey nanab-at ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sa et wad-ay isnan cheycha'y takho nan lalaki ay nenfokhaw ay nangwanin, “Mistolo, seg-angam sak-en ta ilaem ed nan kedkecheng paat ay anakko. ");
INSERT INTO lbk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tay sinkhep si anito ya aped kanafokhaw ya enpap-ayagpag ya omos-osab nan topekna. Kad-ikad-in palikhatena siya ya ad-ina paat pawayaen. ");
INSERT INTO lbk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Inseg-angko isnan disipolosmo ta pakaanencha nan chey ay anito, ngem ad-icha kafaelan.” ");
INSERT INTO lbk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kinwanin Jesus ken chaicha en, “Chakayo ay maid pammatina ya nikfis nan akkhona! Ay kek sa makitetee ya sak an-an-anosan chakayo?” Sa na't kinwani isnan lalaki, “Iyalim sina nan anakmo.” ");
INSERT INTO lbk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Issan cha maisag-enan nan chey ay ong-onga, infasfas kasin nan anito ket ay nenpap-ayagpag. Ngem nenyangyangan Jesus nan anito ya khinmawis chadlo, sa na't insakhong ken amana. ");
INSERT INTO lbk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Natakag am-in nan takho isnan chey ay matangtangad ay kamabfalin Apo Dios. Sisya kayet nan taan nan katakhotakho isnan am-in ay inang-angnen Jesus. Sa na't kinwani isnan disipolosna, ");
INSERT INTO lbk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Semkenyo ay khawis nan nay ay ifaagko: At maichowa ak ay Anak si Takho isnan kamabfalin nan takho.” ");
INSERT INTO lbk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nay met achi eg-aycha naawatan nan kinwanina, tay naitafon na ta ad-icha maawatan, ya omegyat cha ay kasin mamoot ischi. ");
INSERT INTO lbk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Awni ya ket wad-ay nan nasosmaan nan disipolos Jesus, mo sino ken chaicha nan katongchowan. ");
INSERT INTO lbk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ngem tay ammon Jesus nan semekcha, inayakhana nan esang ay ong-onga ya inpatakchegna isnan sag-ena. ");
INSERT INTO lbk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Sa na't kinwani ken chaicha, “Mo sino nan manawat isnan ong-onga ay kag ken tona maigkhapo ken sak-en, sak-en akhes nan chawatena. Ya mo sino nan manawat ken sak-en, chawatena akhes nan nangifaa ken sak-en. Tay mo sino nan kaoyaan ken chakayo am-in, siya nan katongchowan.” ");
INSERT INTO lbk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sa et kinwanin Juan, “Apo, wad-ay nan inilami ay cha mangipakaan isnan anito maichalan isnan ngachanmo, ya inpawami tay faken tako foweg.” ");
INSERT INTO lbk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngem kinwanin Jesus, “Ad-iyo aped ipawa siya, tay mo sino nan ad-i manopla ken chakayo, wad-ay cha ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Issan nganngani et nan timpo ay tomoliyan Jesus id chaya, inpapatina ay omey id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Inpaon-onana nan cheycha'y omey ay mangisakhana isnan omayancha. Nay met achi issan inmayancha isnan esa'y ili id Samaria ay en mangisakhana isnan am-in, ");
INSERT INTO lbk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ket ay inad-in nan omili ischi, tay nalatak ay id Jerusalem nan ayena. ");
INSERT INTO lbk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Osto ay siya chi nan inmat ay inilan nan disipolosna ay cha Santiago ya si Juan, kinwanicha, “Apo, laychem ngen ta lalayanmi nan apey ay malpo id chaya ta poowana chaicha?” ");
INSERT INTO lbk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Alan et Jesus ya sakhong ay nenyangyang ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sa cha't intoloy ay inmey isnan teken ay ili. ");
INSERT INTO lbk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Issan cha cha omayan, wad-ay nan lalaki ay nangwanin, “Maifoweg ak ken sik-a isnan olay entona ay omayam.” ");
INSERT INTO lbk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kinwanin et Jesus ken siya, “Nan silay, wad-ay tekawcha, ya siya akhes isnan ay-ayam, wad-ay khafancha. Ngem sak-en ay Anak si Takho et maid osto is maseypak.” ");
INSERT INTO lbk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wad-ay akhes nan teken ay nangwaniyana, “Maifoweg ka ken sak-en.” Ngem kinwaninan, “Aw-awni Apo, ta ennak ed ona ikaob si ama.” ");
INSERT INTO lbk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ket ay inyal-alig Jesus ay nanongfat ken siya, “Ngag ngotom ta nan natey nan en mangikaob isnan ib-acha ay natey. En ka't magtek ipalawag nan maipoon isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wad-ay akhes nan teken ay nangwanin, “Maifoweg ak ken sik-a, Apo, ngem awni ona ta ek ifaag isnan pangafongko.” ");
INSERT INTO lbk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sa et inyal-alig Jesus ay nangwani ken siya, “Nan mangilapo ay en-alacho ya ensakhosakhong, maid silfina isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Awni ya wad-ay akhes nan teken ay pinilin Apo Jesus ay piton poo ya chwa ay disipolosna ay infaana ta masinchodwa cha ay mamangpango isnan olay entona ay ili ay omaayana. ");
INSERT INTO lbk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Et siya na nan infaagna ken chaicha: “Angsan tet-ewa nan maani, ngem akit cha nan en-ani. Enlowalo kayo et mampay isnan nenkwa isnan maani ta wad-ay faalena is omey en-ani. ");
INSERT INTO lbk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Engkayo. Tay nay ifaak chakayo ay kag anak si karnilo isnan kawad nan kakaegyat ay atap ay aso. ");
INSERT INTO lbk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ad-i kayo en-itaktakin is pitaka, paymo sopot, paymo nan ensokatanyo ay palloka. Ad-i kayo tomtomke isnan chalan ay manot-oya isnan olay sino ay sab-atenyo. ");
INSERT INTO lbk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Et mo wad-ay somkhepanyo is afong, kananyo ona en, ‘Oompa kayo isnan nay ay afong.’ ");
INSERT INTO lbk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mo nan nen-afong ischi ya nan oompaana nan wadwad-ay ay sesemkena, at omey ken chaicha nan enkhawisan ay pawad-ayenyo. Ngem mo faken chi is semekna, at tomoli ken chakayo nan chey ay enkhawisan ay ento mo ichowayo. ");
INSERT INTO lbk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Eesangenyo nan afong ay makitey-anyo. Ad-i kayo en-atoaton. Mangan kayo ya ominom kayo isnan is yangkhay ay ipasangocha ken chakayo, tay nan enchono lebfengna ay malagfo. ");
INSERT INTO lbk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mo wad-ay omayanyo ay ili ya chawatencha chakayo, kanenyo nan ipasangocha. ");
INSERT INTO lbk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pakhawisenyo nan nenkasakit ischi ay ili, sa yo't kanan ken chaicha en, ‘Nganngani et nan en-ap-apowan Apo Dios ken chakayo.’ ");
INSERT INTO lbk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngem mo nan omayanyo ay ili ya ad-icha chawaten chakayo, omey kayo isnan karsacha ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Chey, olay nan chapog nan iliyo ay pinomket isnan sikimi, pokpokanmi ta kag yo matokhonan. Ngem sesemkenyo ay sinmag-en et nan en-ap-apowan Apo Dios ken chakayo!’ ");
INSERT INTO lbk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chadlos ko ifaag ken chakayo ay isnan chey ay akhew ay en-okoman Apo Dios, at enyapyap-ew nan ichowana ay chosan nan iSodoma mo nan takho isnan chey ay ili.” ");
INSERT INTO lbk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kinwanin kayet Jesus, “Selaeg yo ay iCorazin ya ken chakayo akhes ay iBetsaida! Tay mo sa ya inangnek id Tiro ya Sidon nan cheycha'y kamabfalin ay chak inangnen ken chakayo, at chinokokhancha issan chey kannay nan fasolcha, ya at enfacho cha is sako ay en mangitotokcho is kadchapo ay mangipaila isnan fafawicha. ");
INSERT INTO lbk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tay siya chi at enyapyap-ew nan chosan nan iTiro ya iSidon mo nan chosayo is omaliyan nan en-okoman Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya chakayo akhes ay iCapernaum, ay ke yo kanan en at matangad kayo id chaya? At maiwasit kayo id inferno!” ");
INSERT INTO lbk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sa et isnan disipolosna kinwanina en, “Nan takho ay mannge ken chakayo, chengngena akhes sak-en. Mo sino nan mangad-i ken chakayo, sak-en nan ad-iyena. Ya mo sino nan omad-i ken sak-en, ad-iyena akhes nan nangifaa ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nenlal-ayad nan piton poo ya chwa ay disipolos Jesus issan tinmoliyancha. “Apo,” kinwanicha, “olay nan anito, pinaticha chakami issan nangipakaananmi ken chaicha isnan ngachanmo!” ");
INSERT INTO lbk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kinwanin Jesus ken chaicha, “Wen, inilak si Satanas ay mekmekyag ay kag koryapyap ay nalpo id chaya. ");
INSERT INTO lbk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chengngenyo na! Inagtak chakayo is kalebfenganyo ta mabfalin ay khatinanyo nan oweg ya khayaman, ya ta afakenyo nan am-in ay kamabfalin nan fosoyo ay si Satanas. Tet-ewa, maid paat maik-ikkan is ngaag ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ngem faken nan mamatiyan nan anito ken chakayo is ilal-ayadyo, mod-i ket enlal-ayad kayo tay apchas naitapi nan ngachanyo isnan omili id chaya.” ");
INSERT INTO lbk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Issan chey ay timpo, inpalal-ayad nan Ispirito Santo si Jesus ay nangwanin, “Enyaman ak ken sik-a Ama ay Apon nan chaya ya nan lota, tay inpailam isnan cheycha'y egay nakaachar nan eg-aymo inpaam-ammo isnan mamasilib ya nan cheycha'y makaawat. Tet-ewa Ama, siya sa nan inangnem tay siya nan khawis ay mangipalal-ayad ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sa na't kinwanin, “Si Ama, inchowana nan am-in ken sak-en. Maid mangammo ken sak-en ay Anakna, mo sino ak, mod-i yangkhay si Ama. Ya maid akhes mangammo ken Ama mod-i yangkhay sak-en ay Anakna, ya nan olay sino ay laychek ay mangipaammowan ken siya.” ");
INSERT INTO lbk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sa et nensakhong si Jesus isnan disipolosna isnan nakekedchengancha. Sa na't kanan, “Naoney kayo ay mangiila isnan naycha ay il-ilaenyo! ");
INSERT INTO lbk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kanak ken chakayo ay angsan cha nan mamadto ya ali id sangad-om ay chadlos menlayad ay mangila isnan il-ilaenyo, ngem egaycha inila. Lalaychencha ay mannge isnan chengchengngenyo, ngem eg-aycha chinnge.” ");
INSERT INTO lbk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Isnan namingsan, tinmakcheg nan esa'y mistolon si lenteg ay naneptepeng ken Jesus ay nangwanin, “Mistolo, ngag ngen et nan masapol ay angnek ta tawichek nan fiyag ay maid pengpengna?” ");
INSERT INTO lbk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sinongfatan Jesus ay nangwanin, “Ngag nan naisolat ay lenteg Apo Dios? Ngag nan maawatam ay ibfakhana?” ");
INSERT INTO lbk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sa na't kanan, “Masapol ay laylaychem nan Apo ay Diosmo isnan am-in ay wad-ay ken sik-a: nan posom, nan leng-agmo, nan fikasmo, ya nan semekmo. Sa et masapol ay laylaychem nan sagkhongmo ay kag isnan menlaycham isnan awakmo.” ");
INSERT INTO lbk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Naitneng nan songfatmo,” kinwanin Jesus. “Siya et mampay sa nan angnem ya at matakho ka is eng-engkhana.” ");
INSERT INTO lbk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nay met achi tay laychena ay mangitakcheg isnan awakna, kasalosalodsod ken Jesus ay nangwanin, “Sino nan sagkhongko?” ");
INSERT INTO lbk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Idwani, inokhod Jesus ay nangwanin, “Wad-ay nan esang ay Judio ay cha en-eseg id Jerico ay nalpo id Jerusalem. Ya ket ay inafangan si mangaakew, sa cha't linafosan ya pinak-opak-o engkhana'y nganngani matey. Sa cha't tinaynan. ");
INSERT INTO lbk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Naiyaspo et ay wad-ay nan pachi ay cha akhes en-eseg ischi, ya osto ay oschongana nan chey ay takho, ke na't aped yangkhay linaosan ay nanalan is katopakna. ");
INSERT INTO lbk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Nawni, ya ket wad-ay akhes nan nen-eseg ischi ay kafachang isnan sinagoga ay makwanin Levita. Sinmag-en ay nangoschong ken siya, ngem siya kayet ay aped akhes linmaos ay nanalan is katopakna. ");
INSERT INTO lbk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ngem ket ay awni ya wad-ay nan Samaritano ay nenfaat ischi. Osto'y inilana nan lalaki, chachama nan seg-angna ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sa et inmey ya inakhasana nan sokhatna is lana ya fayas, ya finedfechana is lopot. Sa na't inpasakay isnan ensakayana ya inyeyna isnan esang ay en-ab-afangan, ya tinokkhongana siya. ");
INSERT INTO lbk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Issan kawaksana, finayachana nan enpaab-afang is chwa'y denaryo sa na't kanan, ‘Nongnongem siya, sa et mo wad-ay kayet nan enkhastosam pala ken siya, at fayachak is kasin ko aliyan.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sa et kanan Jesus, “Isnan semekmo, sino isnan tolo ay cheycha nan nensagkhong isnan lalaki ay inpalikhat nan cheycha'y mangaakew?” ");
INSERT INTO lbk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sinfat nan mistolon si lenteg ay nangwanin, “Nan chey achi naneg-ang ken siya.” Kinwanin et Jesus, “En ka't mampay ya siya akhes chi nan angnem.” ");
INSERT INTO lbk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Issan cha enfaatan cha Jesus, inomchan cha isnan ili ay kawad cha Marta ay nangipachag-os ken Jesus is afongna. ");
INSERT INTO lbk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wad-ay nan akhin Marta ay si Maria, ya osto ay en-isos-olo si Jesus, tinmokcho et si Maria isnan sag-en nan sikin Jesus ay nannannge isnan isos-olona. ");
INSERT INTO lbk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ngem si Marta, makokorkor nan semekna isnan angsan ay chonona, sa et inmey ken Jesus ay nangwanin, “Apo, ay kem ad-i ilaen si annochik? Aped na tinaynan sak-en ay es-esang ay manno am-in isnacha? Kanam achi ta omali ay fomachang!” ");
INSERT INTO lbk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sa et kinwanin Jesus, “Marta! Marta! Aped ka yangkhay enchanachanag isnan angsan ay khabkhab-em. ");
INSERT INTO lbk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nay met achi esang yangkhay nan kasapolan. Siya chi nan osto ay pinilin Maria ya at ad-i makak-aan ken siya.” ");
INSERT INTO lbk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Isnan namingsan ay cha enlol-owalo si Jesus, waday akhes ischi nan disipolosna. Osto ay nakwas, kinwanin nan esang en, “Apo, isolowam ed chakami ay enlowalo, kag isnan inangnen Juan isnan cheycha'y disipolosna.” ");
INSERT INTO lbk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","“Kag tona nan angnenyo ay enlowalo,” kinwanin Jesus. Kananyo en, “Ama, machad-ayaw nan ngachanmo. Omali nan en-ap-apowam. ");
INSERT INTO lbk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ichowam nan kanenmi isnan kawakawakas. ");
INSERT INTO lbk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pakawwanem nan fasolmi tay chakami akhes, pakawwanenmi nan am-in ay cha fomasol ken chakami. Ad-im ogkhayen chakami isnan maawisanmi ay enfasol.” ");
INSERT INTO lbk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sa na't kinwani ken chaicha, “Mo sa ya wad-ay esang ken chakayo ay omey is afong nan liwidna isnan tengan si lafi ay en mangwani en, ‘Kayong, omagtan ka ed is tolo ay tinapay ta at sak sokatan, ");
INSERT INTO lbk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tay kaal-ali nan liwidko ay cha enfaat, ya nay maid paat ipasangok ken siya!’ ");
INSERT INTO lbk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Et mo sa ya somfat nan liwidna is afong ay mangwani en, ‘Ad-im sangawen sak-en! Apchas et naifoti nan eneb, ya iseseyepko nan an-akko. Ad-i ak makafangon ay mangagtan ken sik-a.’ ");
INSERT INTO lbk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ibfakhak ken chakayo, olay mo ad-i fomangon ay mangagtan ken siya tay liwidna, et khechangna ay fomangon ay mangichowa isnan am-in ay masapol nan liwidna tay ad-i tomke ay enkechakechaw. ");
INSERT INTO lbk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Siya akhes koma sa nan ikkanyo ay enlowalo. Komchaw kayo et maagtan kayo. En-anap kayo et makad-an kayo. Enkogkog kayo et matekwafan nan eneb ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tay mo sino nan komchaw at maagtan, ya nan en-anap makad-an, ya isnan enkogkog, et matekwafan nan eneb ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ken chakayo akhes ay am-a, ay ke wad-ay ken chakayo nan mangichowa isnan oweg isnan fab-alona, mo komchaw is sibfana ay khachiw? ");
INSERT INTO lbk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kag akhes mo komchaw is itlog, ay ke yo aped ichowa nan khayaman? ");
INSERT INTO lbk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Olay ngaag kayo, et ammoyo ay en-ichowa is enkhawisan nan an-akyo. Mo siya sa, ad-i ngen wadwad-ay chadlos nan ikkan Ama id chaya ay mangichawchaw isnan Ispirito Santo ken chakayo ay komchaw ken siya?” ");
INSERT INTO lbk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isnan namingsan wad-ay nan lalaki ay ad-i makakkali tay sinkhep si nangengek ay anito. Osto ay inpakaan Jesus san anito, ya ket chadlo nenkali nan lalaki, ya nataataa nan angsan ay takho. ");
INSERT INTO lbk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nay met achi wad-ay nan tapina ay nangwanin, “Da! Nan kamabfalin maachi Beelzebub ay ap-apon si anito nan mangipakpakaanan tosa isnan anito.” ");
INSERT INTO lbk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wad-ay cha akhes nan naneptepeng ken siya isnan mangmangchawancha isnan katataa ay kaimatonana ay malpo id chaya. ");
INSERT INTO lbk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngem tay ammon Jesus nan semsemkencha, kinwanina en, “Olay ngag ay en-ap-apowan ay en-asifaloknit kannay, et mapakawas. Nan akhes sinpangafong ay maid ornoscha at maamas cha akhes. ");
INSERT INTO lbk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Siya akhes chi isnan en-ap-apowan Satanas. Mo siya sa ay en-asikhola cha, ngag et kay nan ikkan nan en-ap-apowana ay tomakcheg? Tay kananyo en chak pakaanen nan anito isnan kamabfalin Beelzebub. ");
INSERT INTO lbk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Idwani, mo siya sa ay chak pakaanen nan anito isnan kamabfalin Beelzebub, ngag akhes ay kamabfalin nan cha osalen nan takhoyo ay enpakaan? Ay ke teken? Idwani nay et chaicha kannay nan mangokom isnan nenkamaliyanyo. ");
INSERT INTO lbk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ngem tay pakaanek nan anito maichalan isnan kamabfalin Apo Dios, siya na nan mangipaila ay inomchan et nan en-ap-apowan Apo Dios ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Inokhod Jesus nan nay ay al-alig: “Mo nan mafikas ay takho et nakaarmas ay khawis ay manokkhong isnan afongna, at mimigto ay khawis nan kwana. ");
INSERT INTO lbk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ngem mo omali nan mafikfikas ay mangafak ken siya, at ikaana am-in nan armasna ay entatalkana sa et omey ay mangikakcheng isnan cheycha ay kinamkamna.” ");
INSERT INTO lbk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sa et kinwanin Jesus akhes en, “Mo sino nan maid ken sak-en, chaicha nan omad-i. Ya nan cheycha'y ad-i mamachang ken sak-en ay en-iyapon, chaicha nan cha enfoka.” ");
INSERT INTO lbk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Inyal-alig Jesus ay nangwanin, “Mo komaan nan anito isnan takho, enfaat isnan kaponchaponchag ay omanap is omillengana. Et mo maid maanapana, kecheng kanana isnan nemnemna en, ‘Somakhong ak et chadlo isnan sikhod ay nentetey-ak.’ ");
INSERT INTO lbk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ket ay tomoli ya edchanana san tinaynana ya nachalochalosan ya nanongnonongnong. ");
INSERT INTO lbk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sa et en omayag is pito kayet ay ib-ana ay anito ay am-amed ay ngaag mo siya, sa cha't somkhep ay entee isnan chey ay takho. Adi kad nan enfanakhan et nan chey ay takho, et am-am-amed mo san chey nang-ona ay kasasaadna.” ");
INSERT INTO lbk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Issan sisya ay enkak-aliyan Jesus isnan angsan ay takho, wad-ay nan fafai ischi ay nangifokhaw, “Naoney nan fafai ay nangiyanak ya nangipasoso ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ngem sinmongfat si Jesus ay nangwanin, “Naon-oney kayet nan cheycha ay mannge isnan kalin Apo Dios ya angnencha.” ");
INSERT INTO lbk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Issan am-amed kayet inmangsanan nan angsan ay takho ay mangal-alifongfong ken Jesus, ke na't kanan, “Chad-ama nan kinangaag nan takho idwanin! Komchakomchaw cha yangkhay is katataa ay sinyal, ngem maid paat maipaila ken chaicha, mod-i kecheng nan sinyal ay naila ken Jonas. ");
INSERT INTO lbk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kag isnan nenfallinan Jonas ay sinyal isnan iNineve, kag akhes ken sak-en ay Anak si Takho, at sak-en nan sinyal nan takho idwanin. ");
INSERT INTO lbk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Nan akhes Reyna ay nalpo isnan ambagatan ay ili, at tomakcheg ay mangisaklang isnan naycha ay takho isnan at en-okoman Apo Dios. Tay paat nenfaat ay nalpo isnan pengpeng nan lota ta en na chengngen nan silib Solomon. Ngem ilaenyo, wad-ay isna nan entongtongcho mo si Solomon. ");
INSERT INTO lbk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Siya akhes ay is omali ay akhew ay en-okoman Apo Dios, at tomakcheg cha akhes nan iNineve ay mangisaklang isnan naycha ay takho idwani, tay chaicha et chinokokhancha kannay nan fasolcha issan nanngelancha isnan inpalawag Jonas. Ngem ilaenyo, wad-ay isna nan entongtongcho mo si Jonas.” ");
INSERT INTO lbk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Insolon Jesus ay mangwanin, “Maid mamaskhed isnan silaw sa na't itafon paymo tangfan isnan salop, mod-i ket ippeyna isnan osto ay kaipatpatangana ta mo sino nan somkhep at ilaencha nan langlang nan silaw. ");
INSERT INTO lbk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nan mata, siya nan kag silaw nan awak. Mo nalatak nan angnen ay en-ila, kag masisilawan nan semek ya khawis nan enfanakhana isnan am-in ay katatakhoyo. Ngem mo ngaag nan pinang-ila, at kag akhes enpapanget nan semek. ");
INSERT INTO lbk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ilaenyo et mampay ay khawis ta faken follinget mod-i ket nan silaw nan manangkhew ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mo nan semekyo et nasilawan ya mam-aid follingetna, et kag enlalanglang nan am-in, ya kag kayo malalanglangan isnan silaw.” ");
INSERT INTO lbk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Osto ay nakwas si Jesus ay nen-isos-olo, inayakhan nan Fariseo ay en makikan is afongna. Et inmey ya tinmokcho ay makikan. ");
INSERT INTO lbk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ket ay nataa san Fariseo tay egay ona nenfolo si Jesus esa mangan. ");
INSERT INTO lbk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kinwanin et Apo Jesus ken siya en, “Chakayo maachi ay Fariseo, et tet-ewa'y eestenyo nan naiwaned ay ekhad ken chakayo, agkha ket ya tokong ya kinangaag yangkhay nan wad-ay isnan nemnemyo! Kag kayo tasa ya palato ay nadchalodchalos is kafalana ya ke pet nalokhilokhit isnan chaemna. ");
INSERT INTO lbk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Chakayo ay ad-i ensemsemek, ay ke si Apo Dios ay nangaeb isnan falana, ya faken akhes siya nan nangaeb isnan chaemna? ");
INSERT INTO lbk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","En-ated kayo magtek isnan poposi isnan wad-ay ken chakayo tatno khomawis mampay nan katatakhoyo. ");
INSERT INTO lbk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Selaeg yo ay Fariseo! Khawis tay ichowayo ken Apo Dios nan olay pagkapoon nan am-in ay ilan si likacho ay aniyenyo, ngem nenkammali kayo tay iwayangyo nan nalenteg ay okhali, ya nan layadyo ken Apo Dios. Mang-ona koma chana ay angnenyo, esa pay nan tapina. ");
INSERT INTO lbk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Selaeg yo ay Fariseo! Tay nan laychenyo et nan kakhawisan ay tokchowan is kasinagoga, ya nan maichad-ayawanyo is kamarkitan. ");
INSERT INTO lbk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Selaeg yo! Tay kag kayo isnan naikaofan nan natey ay maid matona ay aped khatkhatinan nan takho tay ad-icha ammo.” ");
INSERT INTO lbk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","“Mistolo,” kinwanin nan esang ay mistolon si lenteg, “isnan cham mangwaniyan issacha, nay et maitapi kami ay mafainan!” ");
INSERT INTO lbk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sinmongfat si Jesus ay nangwanin, “Olay akhes chakayo ay mistolon si lenteg, selaeg yo akhes! Tay ipasakfatyo isnan takho nan ad-acham-et ay awit ay ad-icha kafaelan, ngem ad-iyo met paat oyachen nan olay esang ay lechengyo ay mamachang ken chaicha! ");
INSERT INTO lbk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Selaeg yo! Tay khab-enyo nan pantiyong nan cheycha'y mamadton Apo Dios ay cha pinatey nan ik-ityo, ");
INSERT INTO lbk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","et nay ipailayo kannay ay tantan-oyanyo nan inang-angnencha. Cha cha pinatey nan mamadto ya cha kayo akhes khomaeb is pantiyongcha. ");
INSERT INTO lbk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tay siya chi isnan silib Apo Dios kinwanina, ‘At ifaak ken chaicha nan cheycha'y mamadto ya apostoles ya at pateyencha ya palikhatencha nan tapina!’ ");
INSERT INTO lbk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tay siya chi, at machosa nan takho idwani khapo isnan napateyan nan am-in ay mamadto, mailapo issan nakhab-an nan lofong engkhana idwani, ");
INSERT INTO lbk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mailapo issan napateyan Abel engkhana issan napateyan Zacarias ay napatey isnan nenfet-akan nan altar ya nan Timplo. Tet-ewa, ifaagko ay at machosa kayo maipoon isnan am-in ay nateyancha! ");
INSERT INTO lbk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Selaeg yo ay mimistolon si lenteg! Tay kag yo kinaan nan torfek ay manekwab isnan pantew ay somkhepan koma nan takho ta mangammowancha isnan silib Apo Dios. Ad-i kayo somkhep ischi, sa yo't cha selat-an nan takho ay cha koma somkhep.” ");
INSERT INTO lbk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Issan kinmaanan Jesus ischi, inlapon nan Fariseo ya nan mimistolon si lenteg ay menkhola ken siya, ya pinilipilitcha siya ay manongfat isnan angsan ay salodsodcha ");
INSERT INTO lbk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ta omanap cha is khotokna ay manpapancha ken siya maipoon isnan kankanana. ");
INSERT INTO lbk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Liniblifo nan mangal-alifongfong ken Jesus ya cha cha enkhikhinnatin. Sa et inyon-onan Jesus ay nanokhon isnan disipolosna ya kinwanina, “Ilaenyo ta meymey-anyo nan awakyo isnan fofod nan Fariseo ay siya nan kakas-okas-onancha. ");
INSERT INTO lbk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tay maid masasalakan ay at ad-i maipaila, ya maid maitatafon ay at ad-i maipaammo. ");
INSERT INTO lbk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Am-in ay kinwakinwaniyo isnan ab-afollinget, at madmadnge isnan mag-akhew. Ya am-in ay intifitifiyo isnan ib-ayo is afong, et maifokhaw isnan toktok nan afong.” ");
INSERT INTO lbk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kinwanin kayet Jesus, “Kanak ken chakayo ay iib-ak, ad-i kayo omegyat isnan menpatey ken chakayo, tay mo pateyencha nan awakyo, kecheng et maid kasin maangnencha. ");
INSERT INTO lbk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nay ifaagko magtek ken chakayo nan tet-ewa ay omegyatan: Siya si Apo Dios. Tay mo inalana't nan fiyagyo, kafaelana kayet ay mangibkas ken chakayo id inferno. Tet-ewa, siya chadlo nan egyatenyo. ");
INSERT INTO lbk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ilaenyo nan chekchekchek. Ad-i ngen chwa ay tanso yangkhay nan lakon nan lima? Ngem maid lichongan Apo Dios ken chaicha, olay esang. ");
INSERT INTO lbk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Am-amed ken chakayo, tay ammona chakayo, olay nan kabfifilang nan fookyo. Ad-i kayo omeg-egyat, tay napatpateg kayo mo nan angsan ay chekchekchek.” ");
INSERT INTO lbk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sa et kinwanin Jesus, “Naay kayet nan ifaagko: Mo sino nan mangifaag isnan sakhang nan takho ay takhok siya, at siya akhes chi nan ikkak ay Anak si Takho ken siya isnan sakhang nan angheles Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ngem mo sino nan mangisaot ay takhok siya isnan sakhang nan katakhotakho, at siya akhes ay maad-i siya isnan sakhang nan angheles Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mabfalin ay mapakawan nan olay sino ay mangipangaag ken sak-en ay Anak si Takho, ngem nan mangipangaag isnan Ispirito Santo et ad-i kapakpakawan. ");
INSERT INTO lbk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mo ikhoyodcha chakayo ay mangidchalom is kasinagoga paymo isnan aap-apo paymo isnan okom, ad-i kayo madchanakhan isnan angnenyo ay ensefat paymo nan kananyo. ");
INSERT INTO lbk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tay nan Ispirito Santo nan at mangisolo ken chakayo isnan omno ay kananyo isnan chey kannay ay olas.” ");
INSERT INTO lbk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ket ay wad-ay isnan angsaangsan ay takho nan nangwani ken Jesus, “Mistolo, kanam ed ay isnan akhik ta omichatag isnan tawid ay tinaynan ama ken chakami.” ");
INSERT INTO lbk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sinfat Jesus ay nangwanin, “Kayong, ay ke sak-en nan napili ay mangischo isnan ikkanyo ay enchatag isnan tawichenyo?” ");
INSERT INTO lbk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sa na't kinwani isnan katakhotakho en, “Ilaenyo ay khawis ta maid ken chakayo nan am-in ay ilan si kinaakhom, tay nan tet-ewa ay fiyag nan takho et ad-i maiyala isnan omawas ay kwa.” ");
INSERT INTO lbk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sa et inyal-alig Jesus ken chaicha ay nangwanin, “Wad-ay nan esang ay faknang ay ad-acha nan inanina isnan payewna. ");
INSERT INTO lbk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sa na't semkesemken, ‘Ngag man et nan angnek? Tay ya ke maid mangipay-ak isnan am-in ay inanik. ");
INSERT INTO lbk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na! Kag tona pet nan angnek,’ kinwanina. ‘Tastasek nan allangko ta khomaeb ak is chakchakchake ay mangipay-ak isnan pakhey ya nan tap-ina kayet ay ippeyko. ");
INSERT INTO lbk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Et mabfalin ay kanak en, “Naoney ak pet! Tay wad-ay et am-in ken sak-en nan ngonon ay masapolko is katawetawen. Chey, khankhanasek et ay enfiyag. Aped ak yangkhay mangmangan, omin-inom ya makilil-iwid.” ’ ");
INSERT INTO lbk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ngem ket ay kanan Apo Dios ken siya en, ‘Sik-a ay ad-i ensemsemek! Idwani kannay ay maschem, alaek nan leng-agmo. Sino pay nan sa menfanes isnan am-in ay kwam ay em inigtoigto?’ ” ");
INSERT INTO lbk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sa et kinwanin Jesus, “Siya sa nan kasasaad nan cheycha'y aped yangkhay en omamoamong is ifaknangcha, ya maid mabfalincha isnan sakhang Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sa et kinwanin Jesus isnan disipolosna, “Kanak et mampay ken chakayo, ad-i kayo man madchanakhan isnan fiyagyo. Ad-i kayo madchanakhan mo ngag nan kanenyo paymo nan ifachoyo. ");
INSERT INTO lbk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tay wadwad-ay nan fiyag mo nan makakan, ya nan awak mo nan facho. ");
INSERT INTO lbk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ilaenyo nan khayang. Ad-i cha met enmola, ad-i cha en-ani, ya maid en-ig-igtowancha paymo allangcha, ngem ya ke cha kayet panganen Apo Dios chaicha mo! Ad-i kayo ngen napatpateg is solit mo nan ay-ayam? ");
INSERT INTO lbk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sino ken chakayo nan makaipaancho is akit isnan fiyagna mo enchanachanag? ");
INSERT INTO lbk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mo maid maangnen nan chanagyo isnan olay kag tosa ay akiakit, en kayo man madchanakhan isnan tapina mo? ");
INSERT INTO lbk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ilaenyo achi nan sabsafong. Aped cha cha mengngan. Ad-i cha met enchono paymo en-afe. Nay met achi kanak ken chakayo, ay olay si ali Solomon isnan am-in ay chayawna, et eg-ay nabfachowan isnan kakhawisan ay kag nan kinagkhawis nan olay esang isnan sabsafong. ");
INSERT INTO lbk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Et mo kag tosa nan ikkan Apo Dios ay mamacho isnan mola, ay wad-ay is kaponchag idwani ya is wakas et maittongo, ad-ina ngen am-amed fachowan chakayo? Akiakit paat nan pammatiyo! ");
INSERT INTO lbk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Faken koma nan kanen ya inomenyo nan anaanapenyo. Ad-i kayo madchanakhan issacha. ");
INSERT INTO lbk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tay siya chasa nan anaanapen nan takho isnan olay entona isnan lofong ay ad-i mamati ken Apo Dios. Ngem si Ama id chaya, aammona ay masapolyo chana. ");
INSERT INTO lbk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pawadwad-enyo magtek nan en-ap-apowan Apo Dios, et ichawchawna akhes nan masapolyo.” ");
INSERT INTO lbk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kinwanin kayet Jesus, “Chakayo ay kag ko paspastolan, ad-i kayo omeg-egyat, olay akit kayo. Tay layad Amayo ay mangitapi ken chakayo ay makiap-apo ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ilakoyo magtek nan kwayo sa yo't ichowa nan lakona isnan maid mabfalincha. Et siya chi ay icholinyo nan kag yo pitaka id chaya ay ad-i machonot, ya nan kag yo akon ay ad-i mangmangkhay, tay maid mangakew ya maid akhes kimkimi ay mamakawas ischi. ");
INSERT INTO lbk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tay mo ento nan kawad nan kinafaknangyo, siya akhes nan kawad nan semekyo.” ");
INSERT INTO lbk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Intoloy Jesus ay nangwanin, “Ensasakhana kayo ay kag isnan cheycha'y faa ay nakafachofacho ay mangipabfifichang isnan silawcha ay manman-ed isnan tomoliyan nan apocha ay malpo isnan chomno. Ta mo omali ya enkogkog wad-ay cha kannay ay manekwab isnan eneb ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Naoney nan cheycha'y faa ay at edchanan nan apocha ay manman-ed isnan tomoliyana. Nay ibfakhak ken chakayo nan tet-ewa: At ala na ya sokat ya at patokchowena kannay chaicha sa na't ikhaowan chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Naoney nan cheycha'y mad-anan ay ensasakhana isnan tomoliyan nan apocha isnan olay ngag ay olas - tengan si lafi paymo mawmawni kayet! ");
INSERT INTO lbk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Sesemkenyo na: Mo nan nenkwa isnan afong ya aammona mo ngag ay olas nan omchanan nan mangaakew, at ensasakhana ta ad-i maskhep nan afongna. ");
INSERT INTO lbk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Siya akhes ken chakayo, masapol ay ensasakhana kayo, tay at omali ak ay Anak si Takho isnan olas ay ad-iyo ammo.” ");
INSERT INTO lbk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kinwanin Pedro, “Apo, ken chakami ngen nan mangifagfag-am isnan sana ay al-alig, paymo isnan olay sino?” ");
INSERT INTO lbk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kinwanin Apo Jesus ay sinmongfat, “Sino et mampay nan katatalek ya masilib ay faa? Siya nan ippey nan apona ay mangila isnan kafaafaana, ya mangichowa isnan chatagcha isnan osto ay timpo. ");
INSERT INTO lbk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Naoney nan chey faa ay okhay ay cha manno isnan chonona isnan mangchanan nan apona ken siya isnan somaalana. ");
INSERT INTO lbk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tet-ewa kanak ken chakayo, at ippey nan apona siya ay mangila isnan am-in ay kwana. ");
INSERT INTO lbk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ngem mo nan sana ay nadchotokan ay faa ya kanana isnan semekna en, ‘Na! Mawni pet nan apok,’ ya ke na't ala ya faifaig isnan tapina ay faa ay lallalaki ya fabfafai, ya en et yangkhay mangmangan ya omin-inom ya enfotfoteng, ");
INSERT INTO lbk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","anono et ya naanali nan apona isnan akhew ay egayna nan-echan ken siya, ya isnan olas ay ad-ina ammo. Et siya chi nan chad-ama ay manosaan nan apona sa na't iwasit siya ay maitapi isnan ad-i katatalek. ");
INSERT INTO lbk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nan faa ay mangammo isnan laychen nan apona ay maangnen sa et ad-i ensakhana ya ad-ina angnen, at angsaangsan nan faigna. ");
INSERT INTO lbk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ngem nan faa ay ad-i mangammo isnan laychen nan apona ay angnena, sa et nen-angnen is kadchosaana, at akit nan faigna. Nan takho ay naigwaan nan ad-acha, et ad-acha akhes nan masingil ken siya. Nan akhes naigwaan nan ad-ad-acha kayet, et ad-ad-acha akhes nan masingil ken siya.” ");
INSERT INTO lbk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kinwanin kayet Jesus, “Nan khotok nan inmaliyak et ta iyalik nan mangipafichang isnan lota, ya laychek ay fomichang et koma! ");
INSERT INTO lbk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngem masapol ay mafonyakhan ak ona isnan likhat, ya chad-ama ay enlikhat ak engkhana'y makwas. ");
INSERT INTO lbk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Away ngen kananyo ay ornos nan enfanakhan nan inmaliyak isnan lofong? Faken ornos, mod-i ket nan masisyanan. ");
INSERT INTO lbk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tay mailapo idwani at masisyan nan lima isnan sinpangafong. Nan tolo kholaencha nan chwa, ya nan chwa akhes kholaencha nan tolo. ");
INSERT INTO lbk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","At enkhinnola nan sin-ama, ya nan sin-ina, ya olay akhes nan sinkatokhangan, enkhinnola nan innapo ay fafai ya nan katokhangana ay fafai.” ");
INSERT INTO lbk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sa et kinwanin Jesus isnan angsaangsan ay takho, “Mo ilaenyo nan lifoo ay malpo isnan kalonokhan si akhew kananyo kannay en, ‘Chey, at omochan,’ ya siya nan omat. ");
INSERT INTO lbk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ya mo ilaenyo ay malpo is ambagatan nan chakhem kananyo en, ‘Chey, at pomoos,’ ya siya nan omat. ");
INSERT INTO lbk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Chakayo ay kakas-okas-on! Ammoyo pet ay mangifaag isnan ayen nan ilan nan lota ya chaya, ngem ya ke kayo ad-i makaawat isnan ayen nan cha maang-angnen idwani ay timpo mo!” ");
INSERT INTO lbk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sa et kinwanin Jesus en, “En kayo man ad-i makasmek isnan omno ay maangnen ay? ");
INSERT INTO lbk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mo wad-ay en mangidchalom koma ken sik-a, ipapatim ay kasin maiyornos ken siya isnan cha yo omayan is kaokom, ta ad-ina apchas pen khoyakhoy sik-a ay en mangisaklang, ya at pen igwan nan okom sik-a isnan polis, ya at ifalod nan polis sik-a. ");
INSERT INTO lbk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ibfakhak ken sik-a, at ad-i ka makafab-ala ischi engkhana ay fayacham nan mortam engkhana isnan kaaanongosan ay sintimos.” ");
INSERT INTO lbk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Issan chey ay timpo, wad-ay cha nan nangifaag ken Jesus maipoon isnan iGalilea ay inpapatey Pilato issan cha cha enchatonan ken Apo Dios et naikaslang nan chalacha isnan chalan nan cha cha ichaton. ");
INSERT INTO lbk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kinwanin Jesus ken chaicha, “At ngen kananyo en siya man chadlo chi nan mangipaila ay am-amed nan fasolcha mo nan tapina ay iGalilea, tay siya chi nan inangnencha ay natey? ");
INSERT INTO lbk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ad-i, tay ibfakhak ken chakayo, mo ad-iyo chokokhan nan fasolyo, et siya akhes ay kakaegyat nan eteyyo am-in. ");
INSERT INTO lbk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kag akhes isnan cheycha'y sinpoo ya walo ay natey issan nat-efan nan at-atakchag ay toping ay nangab-on ken chaicha id Siloe. At ngen kananyo en siya man chadlo chi nan mangipaila ay am-amed nan kinangaagcha mo nan am-in nan kailiyancha ay entetee id Jerusalem? ");
INSERT INTO lbk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ad-i! Ibfakhak ken chakayo ay mo ad-iyo chokokhan nan fasolyo, et siya akhes ay kakaegyat nan eteyyo am-in.” ");
INSERT INTO lbk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sa et inokhod Jesus ken chaicha nan nay ay al-alig. Kinwanina, “Nan esang ay takho, wad-ay nan kaew ay higos isnan omana. Osto ay timpon nan enfegkhasana, maid paat inchanana is fekhasna. ");
INSERT INTO lbk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sa na't kinwani isnan padpadnowena, ‘Ilaem, nay tolo et ay tawen ay tolitoliyek nan fekhas nan nay ay kaew ya maid paat edchanak. Sipowem et achi! Ya ke pet aped yangkhay ay-ayyew nan lota ay seselat-ana!’ ");
INSERT INTO lbk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ngem kinwanin nan enmadmadno en, ‘Apo, ogkhayem ed isnan tawen yangkhay ay nay. Ta kaykayek nan liwesna ya sak et lomengan. ");
INSERT INTO lbk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Et mo mamkhas is omali ay tawen, khawis, ngem mo ad-i, at chadlo ipasipom.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Isnan esang ay Sabfacho, nen-isos-olo si Jesus isnan esang ay sinagoga. ");
INSERT INTO lbk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ya ket ay wad-ay ischi nan in-ina ay sinakew si anito is sinpoo ya walo ay tawen. Napikot nan awakna ya ad-ina paat maiyoyad. ");
INSERT INTO lbk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Issan nangil-an Jesus ken siya, inayakhana ya kinwanina, “Ina, mawayaan ka't chadlo isnan likhatmo!” ");
INSERT INTO lbk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Inpatang Jesus nan limana ken siya ya ket kannay naoyad nan awakna, ya chinad-ayawna si Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ket ay sinmonget nan ap-apon nan sinagoga tay isnan Sabfacho ay tengaw nan nenpakhawisan Jesus. Kinwanina isnan cheycha'y takho, “Ad-i ngen wad-ay nan enem ay akhew ay siya chadlo nan osto ay enchonnan? Siya chasa nan akhew ay enpaakhasanyo, ta faken isnan Sabfacho!” ");
INSERT INTO lbk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sa et kinwanin Jesus, “Chakayo ay kakas-okas-on! Ay ke wad-ay ken chakayo nan ad-i mamadfad isnan taked nan fakana paymo dangkina is kamaitaktakchana isnan Sinabfacho ay tengaw ta en na painomen? ");
INSERT INTO lbk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sa et naay isna nan esang ay kailiyan tako ay apon Abraham ay kag intaked Satanas is sinpoo ya walo ay tawen. Ad-i ngen osto chadlo nan mawayaana isnan Sabfacho ay tengaw?” ");
INSERT INTO lbk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ya ket ay nafainan am-in nan cheycha'y menkhola ken siya isnan chey ay songfatna, ngem nan am-in ay takho, nenlal-ayad cha isnan am-in ay khanag-awis ay inang-angnena. ");
INSERT INTO lbk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sa et kinwanin kayet Jesus en, “Ngag nan ilan nan en-ap-apowan Apo Dios? Ngag nan mangiyalikhak ischi? ");
INSERT INTO lbk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kag chi isnan esang ay kafafan-ikhan ay esek ay makwani en mostasa, ay inyey nan esa'y takho ay mangimola is kaomana. Awni ya tinmofo ya nenfalin ay chapong ay kag kaew ya nenkhafanan si ay-ayam nan pangana.” ");
INSERT INTO lbk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Inyal-alig kayet Jesus ay nangwanin, “Ngag nan mangiyalikhak isnan en-ap-apowan Apo Dios? ");
INSERT INTO lbk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kag chi isnan fofod ay inlaok nan fafai isnan tolo ay salop ay alina ay awni ya ket finomlad am-in.” ");
INSERT INTO lbk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nen-atoaton si Jesus isnan kailiili ay chadchake ya fanan-ig, ta en-isos-olo isnan cha na omay-ayan id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ya wad-ay nan nensalodsod ay nangwani ken siya en, “Apo, akit ngen yangkhay nan takho ay maisalakan?” Sa et kinwanin Jesus, ");
INSERT INTO lbk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ipapatiyo ay somkhep isnan nasopit ay segpan id chaya, tay kanak ken chakayo ay angsan cha nan mamangset ay somkhep ischi ngem ad-i mabfalin. ");
INSERT INTO lbk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mo apchas intangeb nan Apo nan segpan ischi, ya sisya ay wad-ay kayo is chela ay entatakcheg, sa yo't ala ya kogkokogkog ay mangwani en, ‘Apo, tekwafam ed nan segpan ken chakami!’ “Ngem at kanana ay manongfat ken chakayo en, ‘Ad-ik ammo chakayo!’ ");
INSERT INTO lbk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“At ala yo ya songfat ay mangwanin, ‘Ya ke kami man nakiob-ofong ken sik-a ya! Nen-isos-olo ka pay is ilimi!’ ");
INSERT INTO lbk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ngem at kasina kanan, ‘Kinwanik et ay ad-ik ammo chakayo! Komaan kayo, am-in kayo ay ngaag!’ ");
INSERT INTO lbk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ya at siya chi nan enngegngekhanyo ya enkak-aletketan nan fab-ayo mo ilaenyo cha Abraham, Isaac, Jacob ya am-in nan mamadton Apo Dios isnan en-ap-apowana, ya wad-ay kayo ay naiwasit is chela. ");
INSERT INTO lbk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","At omali nan mangili ay malpo isnan amyanan ya ambagatan, ya isnan falaan ya kalonokhan si akhew ay en makikan isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Et wad-ay nan tapina ay enkotit idwani ay at omon-ona, ya wad-ay nan omon-ona idwani ay at enkotit.” ");
INSERT INTO lbk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Isnan siya chi kannay ay olas wad-ay cha nan Fariseo ay inmey ken Jesus ya kinwanichan, “Komaan ka et isna tay si Herodes, laychena ay pateyen sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kinwanin Jesus ken chaicha, “En kayo ibfakha ken tod-i ay nasikap en, ‘Chey, chak pakpakaanen nan anito isnan naan-anitowan ya chak en-akhas idwani. Siya kayet is wakas ya is kafigkhatana ay menlepasak isnan chonok.’ ");
INSERT INTO lbk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Olay mo siya sa, masapol ay manad-alan ak kayet idwani, is wakas ya is kafigkhatana ay enchadchawes id Jerusalem. Tay id Jerusalem pet nan omno ay aped mapateyan nan mamadto ya faken isnan olay entona.” ");
INSERT INTO lbk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kinwanina akhes, “Chakayo ay iJerusalem, aped yo pateyen nan cheycha'y mamadto, ya faokhenyo nan infaan Apo Dios ken chakayo! Nangngat chadlo ay laychek ay yomyomen chakayo, ay kag nan angnen nan mangalak ay mensakoong isnan impasna, ngem inmad-i kayo! ");
INSERT INTO lbk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Idwani, kikhad kayo tay chey, inwayang Apo Dios nan kawadyo. Kanak ken chakayo, at ad-iyo kasin il-ilaen sak-en, engkhana ay sok-ed yo kanan en, ‘Machad-ayaw nan omali ay finaan Apo Dios ya mangitakcheg ken siya.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Isnan esa'y Sabfacho ay tengaw inmey nakikan si Jesus is afong nan esang ay matangad ay Fariseo. Sipsipotancha siya mo ngag nan angnena. ");
INSERT INTO lbk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ya ket ay wad-ay nan lalaki ay komakkayong nan awakna ay sinmag-en ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sa et pinoot Jesus isnan mimistolon si lenteg ya nan Fafariseo ay mangwanin, “Ipalofos ngen nan lenteg tako ay en-akhas isnan tengaw ay Sabfacho, paymo ad-i?” ");
INSERT INTO lbk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngem aped cha inkhigkhinek. Sa na't inegnan san lalaki, inpagkhawisna, ya inpasaana. ");
INSERT INTO lbk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sa na't kinwani ken chaicha, “Olay sino ken chakayo, mo sa ya naekchag nan anakna paymo fakana is kafito, ay ke na ad-i palot-ayen kannay chi isnan chey kannay ay Sabfacho?” ");
INSERT INTO lbk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ngem egay cha nakasongfat. ");
INSERT INTO lbk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nadlaw Jesus ay wad-ay nan tapina isnan cheycha'y naayakhan ay cha namili isnan matangad ay tokchowan. Tay siya chi, inyal-aligna ken chaicha ay mangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mo sa ya naayakhan ka ay en makikan is kakasalan, ad-i ka omey tomokcho isnan matangad ay tokchowan. Tay et lang wad-ay nan naayakhan ay entongtongcho mo sik-a. ");
INSERT INTO lbk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Sa et omali nan nangayag ken chakayo ay chwa ya kanana ken sik-a en, ‘Iyoyam nan nay ay tokchowan ken tona.’ At achi mafainan ka ya en ka tomokcho isnan enkhwab. ");
INSERT INTO lbk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nan magtek angnenyo mo maayakhan kayo, et chawsenyo nan kakhowafan ay tomokchowan, ta mo ilaen nan nen-ayag ken chakayo, et omali ay mangwani en, ‘Kayong, tomongtongcho ka ischi.’ Ya at maichayaw ka isnan sakhang nan am-in ay cha makikan. ");
INSERT INTO lbk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tay olay sino ay mangipatongcho isnan awakna, et maifan-ig, ya mo sino nan mangifafan-ig isnan awakna, et maipatongcho.” ");
INSERT INTO lbk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sa et infakhan Jesus isnan takho ay nangayag ken siya en, “Mo omayag ka is olay sino ay makikan isnan mag-akhew paymo maschem, ad-im ayakhan nan lililwidmo, paymo nan aag-im, nan kikib-am paymo nan faknang ay sag-enmo, tay at ensofalit cha ay mangayag akhes ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mo magtek enpangan ka, ayakham nan poposi, nan nenkakotmochan, nan nenkapilay, ya nan cheycha'y ad-i makaila. ");
INSERT INTO lbk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Et mabindisyonan ka, tay at ad-icha kafaelan ay mensofalit ken sik-a. Si magtek Apo Dios nan manofalit ken sik-a is kasin matakhowan nan nalenteg ay natey.” ");
INSERT INTO lbk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sa et nan esang ay makikan, issan nanngelana isnan kinwanin Jesus, nenkali ay nangwanin, “Naoney nan at makikan isnan en-ap-apowan Apo Dios!” ");
INSERT INTO lbk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ket ay inyal-alig Jesus ay mangwani ken siya en, “Wad-ay nan esa'y takho ay nenpapiyasta ya angsaangsan cha nan inayakhana. ");
INSERT INTO lbk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Osto ay inomchan nan timpon nan kakan, finaana nan omey mangwani isnan cheycha'y cha na inpaayag, ‘Omali kayo et! Tay naisakhana et nan am-in!’ ");
INSERT INTO lbk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nay met achi ke cha't ay mismis-o ay waschin nenlason. Nan esang kinwanina, ‘Linmako ak is payew, et masapol ay ek ilaen chi. Asop man ya maawatam sak-en.’ ");
INSERT INTO lbk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nan esang akhes, kinwanina, ‘Chey, linmako ak is sinpoo ay faka, ya nay omey ak idwani ay mamachas ken chaicha. Asop man ya maawatam sak-en.’ ");
INSERT INTO lbk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kinwanin nan esang kayet, ‘Ad-i ak pay makaali tay nay kaab-afong ak.’ ");
INSERT INTO lbk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Sa et tinmoli nan faa ya infakhana chana isnan apona. Peteg nan songet nan apona ya nenkanana ken siya, ‘En ka! Kamowem ay omey id kammalin ya isnan am-in ay chalan isnan ili ta iyalim nan poposi, nan nenkakotmochan, nan ad-i makaila, ya nan nenkapilay.’ ");
INSERT INTO lbk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Awni ya ket ay kinwanin nan faa en, ‘Apo, naangnen nan filinmo, ngem wad-ay kayet nan tey-an!’ ");
INSERT INTO lbk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kinwanin et nan apo isnan faa, ‘Fomala ka isnan ili ya omey ka isnan karsa ya isnan olay entona ay chalan ischi, ta pilitem nan olay sino, ta mapno nan afongko. ");
INSERT INTO lbk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tay kanak ken chakayo ay at maid paat olay esang isnan cheycha'y sikhod ay naayakhan is sa makalaman isnan nay ay makakan!’ ” ");
INSERT INTO lbk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chadlos angsan ay takho nan naifoweg ken Jesus. Sa na't sinakhong chaicha ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mo sino nan omali ken sak-en ta maitapi isnan disipolosko, masapol ay wadwad-ay nan layadna ken sak-en mo nan layadna isnan amana, nan inana, nan asawana, nan an-akna, nan aag-ina ya olay nan fiyagna kannay. ");
INSERT INTO lbk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mo sino nan ad-i mangekwat isnan kolosna ta omonod ken sak-en et ad-i maitapi ay endisipolosko.” ");
INSERT INTO lbk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mo wad-ay ken chakayo nan menlayad ay enpatoping is at-atakchag, ay ke ad-i ona tomokcho ay manmek mo kaat nan makhastos, ya mo omanay nan sipingna paymo ad-i? ");
INSERT INTO lbk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tay mo ad-ina ona koblalen nan khastosna, ya aped na ipamanman nan pegnad nan toping sa et maid sipingna ay mangikwas ischi, at am-in nan mangila isnan naangnen et ang-angowencha siya. ");
INSERT INTO lbk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kanancha, ‘Chey nan takho ay cha kailapolapo ay enpatoping ya ket ay ad-i makaikwas isnan ipadnona!’ ” ");
INSERT INTO lbk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Siya achi akhes isnan ali ay omey makifaloknit isnan teken ay ali. At tomokcho ona ay manmemanmek mo nan sinpoo ay lifo ay takhona, et kafaelancha nan kafosona ay cha omali ay chwan poo ay lifo nan takhona. ");
INSERT INTO lbk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tay mo ilaena ay ad-i omanay nan takhona, at omifaa kannay is en mangiyafet isnan pechen isnan fosona ay ali ay sisya'y wad-ay isnan ad-adchawi.” ");
INSERT INTO lbk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sa et kinwanin Jesus, “Siya akhes isnan olay sino ken chakayo, ad-i kayo mabfalin ay endisipolosko mo ad-iyo ona ipeg-anan nan am-in ay wad-ay ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Inyalig Jesus ay nangwanin, “Khawis nan asin, ngem mo mamaid nan aklitna, kecheng, ad-i kasin omaklit. ");
INSERT INTO lbk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Maid enkhawisana olay is kalota, paymo is kalomeng. At aped yangkhay maiwasit. Chengngenyo et mampay na, mo wad-ay kowengyo ay mannge!” ");
INSERT INTO lbk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Isnan namingsan angsan cha nan naam-among ken Jesus ay enkorkortais ya nan cheycha'y makwani en wasit ay takho, ta chengngencha siya. ");
INSERT INTO lbk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ket ay enmollomollotomot nan Fariseo ya mimistolon si lenteg ay nangwanin, “Ya ke chawaten tona nan cheycha'y wasit ay takho, ya makikan ken chaicha!” ");
INSERT INTO lbk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tay siya chi, ket ay inog-okhod Jesus nan naycha ay al-alig: ");
INSERT INTO lbk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mo sa ya nan esang ken chakayo et wad-ay nan sinkhasot ay karnilona, sa et nadchongaw nan esang, ngag ngen et nan angnena? Ay ke na ad-i khayachen nan cheycha'y siyam poo ya siyam is kaponchag ta en na anapen nan chey esang engkhana ay edchanana? ");
INSERT INTO lbk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Et mo inchanana, at enlal-ayad ay manakor-ang ischi ");
INSERT INTO lbk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ay mangisaa. Sa na't ayakhan nan lililwidna ya nan sasagkhongna ay mangwanin, ‘Ali kayo ta ilagsakan tako nan nangchanak isnan nadchongaw ay karnilok.’ ");
INSERT INTO lbk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kanak ken chakayo, ay siya akhes ay wadwad-ay nan lagsak id chaya khapo isnan esang ay nenfafawi ay fomafasol, mo nan siyam poo ya siyam ay nalenteg ay takho ay ad-i masapol ay enfafawi.” ");
INSERT INTO lbk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sa et inyal-alig kayet Jesus ay nangwanin, “Kag akhes isnan fafai ay wad-ay nan sinpoo ay silver ay sipingna, ya ket ay chinongawna nan esang. Ngag ngen et nan angnena? Ad-ina ngen paskhechan nan silawna, sa na't sakhasakhachan nan afongna ya mamangset ay manganap ischi engkhana ay mad-asana? ");
INSERT INTO lbk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Et mo inchasana chi, ayakhana nan lililwidna ya nan sasagkhongna ay mangwanin, ‘Ali kayo ta ilagsakan tako nan inchanak ay nadchongaw ay sipingko.’ ");
INSERT INTO lbk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Kanak ken chakayo, ay siya akhes isnan angheles Apo Dios, enlal-ayad cha isnan enfabfawiyan nan esang ay fomafasol.” ");
INSERT INTO lbk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sa et inyal-alig Jesus kayet ay nangwanin, “Wad-ay nan esang ay ama ay chwa nan an-akna ay fafallo. ");
INSERT INTO lbk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nan annochi, kinwanina ken amana, ‘Ama, yaim et achi idwani nan fingayko isnan kwam ay at tawichek.’ Sa et finingay amacha nan ipatawidna ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nar-os nan akit ay akhew, ya ket inlakon nan annochi nan tawidna, sa et nenfaat isnan adchaadchawi ay ili. Sa na't khinastokhastos nan sipingna isnan finofoslon ay fiyag. ");
INSERT INTO lbk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Osto ay khinastosna am-in, inmali nan chad-ama ay fitil isnan chey ay ili, ya maid paat nakhag-ayad is ikatakhona. ");
INSERT INTO lbk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sa et inmey ay nenmadno isnan esang ay omili ischi, ay nangifaa ken siya ay manallaken isnan fotogna. ");
INSERT INTO lbk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ngem maid paat nen-ichowa is kanena, et mo sa ya mabfalin, laychena ay mangan isnan finogfogna is kakaew ay kanen si fotog. ");
INSERT INTO lbk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Awni ya ket chadlo naleng-akhan ya kinwanina en, ‘Ya ke ak naay isna ay aped matmatey is owat, sa et am-in ay laglagfowen ama ay faana et masawalan nan kanencha! ");
INSERT INTO lbk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Somaa ak man et ay mangwani ken ama en, “Ama, nakafasol ak ken Apo Dios ya ken sik-a. ");
INSERT INTO lbk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ad-i ak maikali ay makwani en anakmo. Ifilangmo et yangkhay sak-en ay laglagfowem ay faam.” ’ ");
INSERT INTO lbk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Adi kad ala na't ya ligwat ay somaa ken amana. “Ngem issan sisya ay ad-adchawi siya, inilan et amana, ya naseg-aseg-ang. Ala na't ya tagtag ay nangawe ya namisito ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Sa et kinwanin nan anak, ‘Ama, nakafasol ak ken Apo Dios ya ken sik-a. Ad-i ak maikali ay makwani en anakmo.’ ");
INSERT INTO lbk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ngem ya ket ay inpaayag amana nan kafaafaana sa na't kanan, ‘Ikamoyo! Iyaliyo nan kakhawisan ay kakhay ta ipafachoyo ken siya. Paalitosenyo akhes ya pasapatosenyo. ");
INSERT INTO lbk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sa yo't iyali nan al-alames ay innanak si faka ta parkiyenyo ta sa tako't maam-among ay mangan ya enlaglagsak! ");
INSERT INTO lbk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tay nan anakko ay nay, kag natey ay kasin natakho. Nadchongaw, ya ket ay naanapan.’ Et nailapo tet-ewa nan am-among ya laglagsak. ");
INSERT INTO lbk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Idwani nan yon-a, sisya is kapayew, ya issan cha na somaalan, chinngena't nan tokar ya nan sas-ala. ");
INSERT INTO lbk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sa na't inayakhan nan esang isnan faa ay manalodsod mo ngag nan khotok nan chey ay laglagsak. ");
INSERT INTO lbk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kanan nan faa, ‘Sinmaa nan annochim, ya nenparki si amam isnan al-alames ay innanak si faka tay chinawatna siya ay enkhagkhawis.’ ");
INSERT INTO lbk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nay met achi ket ay peteg nan songet nan yon-a, ya ad-ina paat laychen ay somkhep is afong. Sa et finmala si amana ay nangal-alok. ");
INSERT INTO lbk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngem ket ay finogtakana si amana ay nangwanin, ‘Ilaem kay ya! Ayaka ay tawen nan nensilfiyak ken sik-a, ya maid paat inwaywayangko is filinmo! Et wad-ay ngen inchod-owam ken sak-en is olay paat anak si karching ta parkiyenmi koma isnan lililwidko! ");
INSERT INTO lbk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sa et omali nan nay ay anakmo ay en nangamas isnan am-in ay kwam isnan asi ay fabfafai, sam et aped iparparkiyan isnan al-alames ay innanak si faka!’ ");
INSERT INTO lbk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Sa et kinwanin amana, ‘Anakko, wad-awad-ay ka ken sak-en. Ya am-in ay wad-ay ken sak-en et kwam am-in. ");
INSERT INTO lbk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nay met achi, khawis chadlo mo enpiyasta tako ay enlaglagsak, tay nan annochim ay nay, kag natey ay kasin natakho. Nadchongaw, ya ket ay naanapan.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Inyalig Jesus isnan disipolosna ay nangwanin, “Wad-ay nan esang ay faknang ay nangipakarkho isnan am-in ay kwana isnan kafachangna. Ngem ket ay awni ya chinngena ay nan chey ay kafachangna, et aped na pet am-amasen chachi. ");
INSERT INTO lbk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Tay siya chi, inayakhana siya ay nangwanin, ‘Ngag man nan nay ay chinngek maipoon ken sik-a? Chey, nongnongem et am-in ta ipailam mo ento nan inmay-ayan nan inpaegnak ken sik-a! Tay mailapo idwani ad-im et kasin karkhowen nan kwak.’ ");
INSERT INTO lbk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Sa et nensemesemek nan kafachangna ay nangwanin, ‘Ngag man et nan angnek, tay at kaanen nan apok sak-en isnan chonok? Ay ke wad-ay fikasko ay enkaykay! Fomain ak met akhes ay enlimos. ");
INSERT INTO lbk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na! Kag tona pet nan angnek, ta mo makaan ak isnan chonok at wad-ay cha nan lililwidko ay manawat ken sak-en isnan afob-ongcha.’ ");
INSERT INTO lbk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Idwanin inayakhana ay sin-es-a nan am-in ay nakaotang isnan apona. Sa na't kinwani isnan nang-ona, ‘Kaat nan otangmo isnan apok?’ ");
INSERT INTO lbk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“ ‘Sinkhasot ay fornay ay lana,’ kinwanina. “Sa na't kinwanin, ‘Nay! Pen itokchom ta kamowem ay sokatan nan sinkhasot is liman poo ay fornay isnan listaam.’ ");
INSERT INTO lbk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Isnan teken akhes, kinwanina, ‘Sik-a kay, kaat akhes nan otangmo?’ “ ‘Sinkhasot ay kafan ay finayo,’ insongfatna. “Kinwanina, ‘Nay! Sokatam is kalistaam nan sinkhasot ta ippeymo ay walon poo ay kafan yangkhay.’ ");
INSERT INTO lbk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Adi kad nan chey ay faknang, olay mo siya chi, ket ay chinayawna nan silib nan kafachangna. Tay nan takho ay kalotaan yangkhay nan semekcha, et am-am-amed ay masilib cha ay mennongnong isnan fiyangcha, mo nan ikkan nan takho ay nasilawan nan semekcha ay mennongnong isnan fiyangcha akhes.” ");
INSERT INTO lbk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sa et kinwanin Jesus, “Kanak et mampay ken chakayo en, osalenyo nan kalotaan ay kwayo ay menliwchanyo isnan iib-ayo tatno isnan tap-in akhew ay ad-i et ensilfi chachi, at wad-ay cha nan iib-ayo ay manawat ken chakayo isnan entey-an ay maid pengpengna.” ");
INSERT INTO lbk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sa et kanan Jesus en, “Mo sino nan matalek isnan akit, at matalek akhes isnan chakchake. Ya mo sino nan ad-i matalek isnan olay akit, siya akhes ay ad-i matalek isnan ad-acha. ");
INSERT INTO lbk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mo mampay ad-i kayo matalek ay mangegnan isnan kalotaan ay kinafaknang, ay ke na sa talken chakayo isnan tet-ewa ay nabfalor? ");
INSERT INTO lbk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ya mo ad-i kayo matalek isnan kwan nan teken, ay ke na sa aped ichowa ken chakayo nan chadlos yo enkwa? ");
INSERT INTO lbk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Maid faa ay pafab-aa isnan chwa ay apo, tay at liligtena nan esang ya laylaychena nan esang. Tet-ewa, nakapet isnan esang ya chilawena nan esang. Ad-i mabfalin ay chwa nan omayan nan semekmo, nan Dios ya nan siping.” ");
INSERT INTO lbk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Inang-angon nan cheycha'y Fariseo si Jesus issan osto ay nanngelancha isnan kinkinwanina, tay siping yangkhay nan pasiyat-encha. ");
INSERT INTO lbk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ket ay kinwanin Jesus ken chaicha, “Kas-okas-on kayo nalenteg isnan sakhang nan takho, ngem si Apo Dios, ammona nan semekyo. Tay nan ifilang nan takho ay napateg, siya chachi nan kakkaisiw isnan sakhang Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sa et kinwanin Jesus, “Nan lenteg Moises ya nan insos-olat nan mamadton Apo Dios id solit, et wad-ay kafalinancha engkhana isnan timpon Juan Bautista. Nailapo ischi, wad-ay nan naipap-alawag ay Khawis ay Chamag maipoon isnan en-ap-apowan Apo Dios, et waschin mangipapilit ay somkhep ischi. ");
INSERT INTO lbk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngem olay siya chi, malanlanoy nan maamasan nan chaya ya nan lofong mo nan mamaichan nan olay akiakit ay naisolat isnan lenteg Moises.” ");
INSERT INTO lbk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sa et kinwanin Jesus, “Mo sino nan lalaki ay mangichang isnan asawana sa et kasin omasawa is teken, chwadchwaena nan pantewna. Siya kayet sa isnan lalaki ay mangasawa isnan nakikaichang.” ");
INSERT INTO lbk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kinwanin kayet Jesus, “Wad-ay issan chey nan esang ay kachangyan ay nenkabfalor nan fadfachona ya inmawas nan kanena isnan kawakawakas. ");
INSERT INTO lbk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ya wad-ay akhes nan esang ay posiposi ay enngachan si Lazaro, ay nayam-ayam-an nan awakna, ya kad-in maiyey is kapantew nan chey ay kachangyan, ");
INSERT INTO lbk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ta asop ya makakkakan isnan cha mayagyag isnan lamisaan nan kachangyan. Ya olay nan aso, et cha cha chinilchilan nan nayam-an ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Awni, natey nan chey ay posi ya inkaan nan angheles ay nangiyey is kawad Abraham. Natey akhes nan chey ay faknang ya naikaob. ");
INSERT INTO lbk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sa et inmey id inferno ay chad-ama nan likhatna. Issan kawadna ischi nentangad ya ket inilana si Abraham isnan ad-adchawi ya wad-ay si Lazaro ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sa et nenfokhaw ay nangwanin, ‘Ama ay Abraham, seg-angam man sak-en! Faalem ed si Lazaro ta en na itapek nan ochon nan lechengna isnan chanom ta palatngena nan chilak, tay chad-ama nan likhatko isnan nay apey ay kawadko!’ ");
INSERT INTO lbk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ngem kinwanin Abraham, ‘Anakko, semkem achi ay issan sikhod ay natatakhowam, et naichowa ken sik-a nan am-in ay khanag-awis, ya siya akhes ay inamong Lazaro nan am-in ay likhat? Ngem idwani, khanasena't nan kawadna isna, ya sik-a akhes, enliglikhat ka. ");
INSERT INTO lbk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Faken yangkhay sa, tay wad-ay nan naippey ay ad-achaem ay cheppas ay mamanlad ken chatako tatno ad-i makagchang nan menlayad ay omey issa, paymo nan wad-ay issa ay menlayad ay omali isna.’ ");
INSERT INTO lbk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Sa et kinwanin nan kachangyan, ‘Mo siya chi ama, pangngaasim ta faalem si Lazaro ta omey is afong ama, ");
INSERT INTO lbk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tay wad-ay cha nan lima ay lallalaki ay ag-ik. Ta en na fagfag-an chaicha tay ta ket lang omali cha akhes isna ay kawad nan chad-ama'y likhat.’ ");
INSERT INTO lbk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ngem ket ay kinwanin Abraham, ‘Wad-ay et nan solat cha Moises ya nan cheycha'y mamadto ay manokhon ken chaicha. Siya achi chi nan chengngencha.’ ");
INSERT INTO lbk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Sa na't kinwani kayet, ‘Ad-i omanay chi, ama'y Abraham! Ngem mo wad-ay natey ay kasin matakho ay omey ken chaicha, at chadlo chokokhancha nan fasolcha.’ ");
INSERT INTO lbk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Nay met achi kinwanin Abraham, ‘Mo ad-icha chengngen nan insolat Moises ya nan mamadto, at ad-i cha kayet maawis olay mo wad-ay natey ay kasin matakho.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kinwanin Jesus isnan disipolosna, “Tet-ewa ay wad-ay ay wad-ay nan mangawis isnan takho ay enfasol, ngem at selaeg nan takho ay kalpowan nan enfasolan! ");
INSERT INTO lbk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Khagkhag-awis et yangkhay mo maitaked is kafakhangna nan losong ay fato sa et maiwasit is kafayfay, mo nan aped na awisen ay enfasol nan esang isnan naycha ay ongang-a. ");
INSERT INTO lbk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ilaenyo mampay ay khawis nan angnenyo! “Mo finmasol nan ib-ayo, tokhonenyo. Ya pakawanenyo siya mo enfafawi. ");
INSERT INTO lbk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mo maminpito isnan sin-akhew ay enfasol ken sik-a, sa et kad-in enfafawi ay mangwani ken sik-a en, ‘Na, ibfafawik man nan inangnek,’ masapol ay pakawanem siya.” ");
INSERT INTO lbk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sa et kinwanin nan apostoles ken Apo Jesus en, “Apo, pafibfikasem koma yangkhay nan pammatimi.” ");
INSERT INTO lbk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ke na't kanan, “Mo sa ya wad-ay pammatiyo ay olay kag isnan kafan-ig nan esek si mostasa, at mabfalin ay kananyo isnan nay ay kaew ay sikomoro en, ‘Khafotem nan awakmo ta imolam is kafayfay!’ ya at patiyena kannay chakayo.” ");
INSERT INTO lbk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kinwanin kayet Jesus, “Mo sa ya chakayo et wad-ay faayo ay en nen-alacho paymo en nangipastor isnan karnilo sa et kasas-aa ay namoknag, ngag kay nan kananyo? Ay ke yo sa kanan ken siya en, ‘Ikamom ta mangan ka’? ");
INSERT INTO lbk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ad-i achi! Tay at kananyo en, ‘Isakhanam nan kanek. En ka ensokat, sa ka't enkhao ta mangan ak. Awni et sam akhes isobli.’ ");
INSERT INTO lbk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ay ke kayo masapol enyaman isnan faa tay inangnena nan naifilin ken siya? Ad-i! ");
INSERT INTO lbk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Siya akhes ken chakayo ay faak, mo inangnenyo am-in nan naifilin ay chonnenyo, siya na koma nan kananyo, ‘Ad-i kami man maikali. Mafab-aa kami yangkhay ay cha manno isnan lebfengmi ay chonnen.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Issan cha omayan cha Jesus id Jerusalem, inikwancha isnan saefan nan Samaria ya Galilea. ");
INSERT INTO lbk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Osto ay om-omchan cha isnan esa'y ili, ya ket ay wad-ay nan sinpoo ay nenkakolit ay tinmatakcheg isnan ad-adchawi, ");
INSERT INTO lbk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ay nangifogfokhaw en, “Jesus! Apo! Seg-angam ed chakami!” ");
INSERT INTO lbk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Issan nangil-ana ken chaicha, kinwaninan, “En kayo paila nan awakyo isnan papachi.” Issan cha cha omayan, ket ay naipagkhawis cha am-in. ");
INSERT INTO lbk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sa et nan esang ken chaicha, osto ay inilana ay naipagkhawis siya, ala na't ya toli ay nangipapangekhe ay nenchad-ayaw ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Naneng na't ya lokfob is kasikin Jesus ay nenyamyaman ken siya. Ke pet esang siya ay iSamaria. ");
INSERT INTO lbk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sa et kinwanin Jesus, “Ad-i ngen sinpoo cha ay naipagkhawis? Ngem ento cha kay nan siyam? ");
INSERT INTO lbk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ya ke pet maid tinmoli ay nenchayaw ken Apo Dios mod-i kedkecheng nan mangili ay nay?” ");
INSERT INTO lbk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sa et kinwanin Jesus ken siya, “Itakchegmo ta omey ka. Nan pammatim nan nangipagkhawis ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Isnan namingsan wad-ay cha nan Fariseo ay nensalodsod ken Jesus mo kaatna nan sa omaliyan nan en-ap-apowan Apo Dios. Kinwaninan, “Ad-i chadlos maimatonan nan omaliyan nan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Maid makakwani en, ‘Naay, wad-ay sina!’ paymo, ‘Chey, wad-ay ischi!’ Tay wad-ay et mampay nan en-ap-apowan Apo Dios ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sa na't kinwani isnan disipolosna, “At wad-ay nan timpo ay menlalaychanyo paat ay mangil-an ken sak-en ay Anak si Takho, olay isnan sin-akhew yangkhay, ngem ad-i mabfalin. ");
INSERT INTO lbk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","At wad-ay cha nan mangwani ken chakayo en, ‘Chey, wad-ay ischi!’ paymo, ‘Naay, wad-ay isna!’ Ilaenyo ta ad-i kayo aped omey. Ad-iyo onochen chaicha! ");
INSERT INTO lbk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tay nan akhewko ay Anak si Takho, at kag isnan koryapyap ay mo enkoryapyap isnan esang ay ilit nan chaya, pen langlangana akhes nan tapina ay ilit nan chaya. Siya akhes isnan kasik omaliyan. ");
INSERT INTO lbk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngem masapol ay ilikhalikhatko ona nan angsan, ya maongoongosan ak isnan katakhotakho ay wad-ay idwani. ");
INSERT INTO lbk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nan akhew ay kasik omaliyan ay Anak si Takho, et kag isnan inmat isnan katakhotakho issan timpon Noe. ");
INSERT INTO lbk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cha cha mangmangan ya omin-inom, ya cha cha maasaswa engkhana issan chey kannay ay akhew ay sinomkhepan cha Noe isnan chakchakowag ay fangka, ya ket naanali nan lifog ay namatey ken chaicha am-in. ");
INSERT INTO lbk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Kag akhes issan timpon Lot id Sodoma. Cha cha mangmangan ya omin-inom, enlaklako ya lomaklako, enmolmola ya cha enpatakcheg is afong. ");
INSERT INTO lbk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ngem isnan akhew ay kinmaanan Lot isnan ili ay Sodoma, ya ket naiyochan nan apey ya nan enfidfichang ay asufre ay nalpo id chaya ya pinakawasna am-in chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Siya akhes sa nan at kasasaad nan katakhotakho isnan akhew ay kasin ko enpail-an ay Anak si Takho. ");
INSERT INTO lbk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Adi kad mo omali nan chey ay akhew, nan wad-ay is kaatep nan afongna, et ad-i kasin khomwab ay en mangilayaw isnan kwana ay nakhayad ischi. Siya akhes isnan namoknag, ad-i kasin somaa. ");
INSERT INTO lbk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Semkenyo nan naangnen isnan asawan Lot! ");
INSERT INTO lbk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mo sino mampay nan chadlos mangisalak isnan fiyagna, at khechangna ay maamas kayet. Ngem nan takho ay ad-i mangayyew isnan fiyagna ta olay matey, at maisalakan. ");
INSERT INTO lbk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Kanak ken chakayo ay isnan chey ay maschem, at wad-ay cha nan enchidchipa ay mammaek. Nan esang, at menkaaala, ya makhayad nan esang. ");
INSERT INTO lbk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","At wad-ay akhes nan chwa ay fafai ay enkhig-iling, ya at menkaaala nan esang ya makhayad nan esang. ( ");
INSERT INTO lbk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Siya akhes sa nan omat isnan chwa ay lallalaki is kaponchag, at menkaaala nan esang ya makhayad nan esang.)” ");
INSERT INTO lbk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sa et kinwanin nan disipolosna ken siya, “Entona ta, Apo?” Sa et inyalig Jesus ay nangwanin, “Mo ento nan kawad nan naisaad ay awak, ischi nan maam-amongan nan kalafalafaan.” ");
INSERT INTO lbk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Inokhod Jesus isnan disipolosna nan nay ay al-alig, ta isolona ken chaicha ay masapol ay kad-in enlowalo cha ya ta ad-i cha ngomayngaya. ");
INSERT INTO lbk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kinwaninan, “Wad-ay nan okom isnan esang ay ili ay ad-i mangiyegyat ken Apo Dios ya maid ngotngotona isnan olay sino. ");
INSERT INTO lbk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ya wad-ay akhes ischi ay ili nan nailekkasan ay kad-in nen-olioli ken siya ay en mangiseg-aseg-ang isnan kalentekhana. Kinwanina, ‘Pangngaasim ta itakchegmo nan kalentekhak isnan cha omap-apos.’ ");
INSERT INTO lbk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Inmannong ay inog-okhay nan okom siya ngem osto'y aw-awni chadlo, ket ay kinwanina isnan semekna, ‘Olay mo ad-ik iyegyat nan Dios ya maid ngotngotok isnan olay sino, ");
INSERT INTO lbk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","itakchegko kayet nan kalentekhana khapo isnan kad-ina omalialiyan ken sak-en. Tay ya ke chadlo kaooma nan en-olioliyana!’ ” ");
INSERT INTO lbk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sa et kinwanin Apo Jesus, “Semkenyo nan kinwanin nan ngaag ay okom! ");
INSERT INTO lbk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Si kay Apo Dios, ad-ina ngen am-amed itakcheg nan kalentekhan nan pinilina ay takhona ay enseg-aseg-ang ken siya is fachang isnan inakhew ya minaschem? Ay ke na sa iyawniawni nan mamachangana ken chaicha? ");
INSERT INTO lbk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ibfakhak ken chakayo, at itakchegna kannay nan kalentekhancha. Ngem, mo omali ak kasin ay Anak si Takho, at ngen wad-ay edchanak isnan lota ay mamati?” ");
INSERT INTO lbk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Inokhod akhes Jesus nan nay ay al-alig isnan cheycha'y takho ay mangwanin tet-ewa'y nalenteg cha ya chilawencha nan tapina. ");
INSERT INTO lbk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kinwanina, “Chwa ay lalaki nan nanikid ay inmey nenlowalo is kaTimplo. Fariseo nan esang, ya nan esang, enkorkortais. ");
INSERT INTO lbk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nentatakcheg san Fariseo ay nangitibtifi ay nangilowalo, ‘Enyaman ak ken sik-a Apo Dios tay osto ak ya faken ak kag isnan tapina ay takho. Ad-i ak mangak-akew paymo enlokloko paymo makifabfafai. Ya faken ak kayet kag isnan nay enkorkortais. ");
INSERT INTO lbk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tay sak-en, entipe ak ay mamidwa isnan esa'y chomingkho, sak et cha ichowa ken sik-a nan pagkapoo isnan am-in ay maanapak.’ ");
INSERT INTO lbk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nay met achi nan enkorkortais ay chey, nentatakcheg isnan ad-adchawi sa et egay paat nentangtangad id chaya, mod-i ket kinabkabna nan takebna ay nangnangwani en, ‘Apo Dios, pangngaasim ta seg-angam sak-en ay fomafasol!’ ” ");
INSERT INTO lbk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sa et kinwanin Jesus, “Kanak ken chakayo ay nan nay ay enkorkortais, sinmaa ay naifilang ay nalenteg isnan sakhang Apo Dios, ngem egay nan chey esang. Tay mo sino nan mangipatongcho isnan awakna, at maifan-ig siya, ya mo sino nan mangifafan-ig isnan awakna, at siya nan maipatongcho.” ");
INSERT INTO lbk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wad-ay cha nan tapina ay nangiyey akhes isnan an-akcha ken Jesus ta egnana chaicha. Ngem issan nangil-an nan disipolosna, yinangyangancha chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nay met achi inayakhan kayet Jesus nan ongang-a, sa na't kinwanin, “Ogkhayenyo nan ongang-a ay omali ken sak-en. Ad-iyo ipap-awa chaicha. Tay nan kag tosacha ay takho nan maitapi isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tet-ewa kanak ken chakayo, nan ad-i manawat isnan en-ap-apowan Apo Dios kag isnan angnen nan ong-onga ay manawat, at ad-i maitapi.” ");
INSERT INTO lbk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nensalodsod nan esang ay ap-apon si Judio ken Jesus ay nangwanin, “Khawis ay Mistolo, ngag man nan masapol ay angnek ta matawidko nan fiyag ay maid pengpengna?” ");
INSERT INTO lbk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sa et kanan Jesus, “Ngag nan mangwaniyam en khawis ak? Ad-i ngen maid khawis mod-i yangkhay si Apo Dios? ");
INSERT INTO lbk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ammom met nan cheycha'y filina: Ad-im chwadchwaen nan pantewmo; Ad-i ka enpatey; Ad-i ka mangakew; Ad-i ka en-engag ay enpangaag isnan ib-am; Patkhem cha amam ken inam.” ");
INSERT INTO lbk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ket ay sinmongfat nan lalaki ay nangwanin, “Inkaong-ongak met ay nangang-angnen am-in issacha ay filin.” ");
INSERT INTO lbk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Issan nanngelan Jesus ischi, kinwanina, “Wad-ay kayet nan esang ay kolangmo. En ka ilako nan am-in ay kwam ta iwalasmo nan lakona isnan maid mabfalincha, ya at wad-ay akonmo id chaya. Sa ka't omali ya omonod ka et chadlo ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngem osto'y chinngen san lalaki chi, ket ay nenngongoyos tay telen ay kachangyan siya. ");
INSERT INTO lbk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Osto ay inilan Jesus siya ay nenngongoyos, kinwanina en, “Chad-ama paat ay sikhab nan somkhepan nan kachangyan isnan en-ap-apowan Apo Dios! ");
INSERT INTO lbk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Malanlanoy et pay nan somkhepan nan kamelio isnan lokaw si kachayom, mo nan somkhepan nan kachangyan isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sa et nan cheycha'y takho ay nannge ischi sinalodsodcha ay nangwani en, “Mo siya sa, sino mampet nan mabfalin ay maisalakan?” ");
INSERT INTO lbk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kinwanin Jesus, “Nan ad-i kafaelan nan takho, mabfalin ken Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sa et kinwanin Pedro, “Chakami kay, tinaynanmi met nan am-in ay wad-ay ken chakami ta onochenmi sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Wen,” kinwanin Jesus. “Ya tet-ewa kanak ken chakayo, mo sino nan manaynan isnan afongna paymo nan asawana, aag-ina, amana ya inana, paymo nan an-akna midkakay nan en-ap-apowan Apo Dios, ");
INSERT INTO lbk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","at ad-ad-acha nan chawatena idwani, ya at chawatena kayet nan fiyag ay eng-engkhana isnan omali ay fiyag.” ");
INSERT INTO lbk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Inayakhan Jesus nan sinpoo ya chwa ay disipolosna, sa na't kanan, “Nay manikid tako id Jerusalem ay at maangnenan nan am-in ay cha insolat nan mamadto maipoon ken sak-en ay Anak si Takho. ");
INSERT INTO lbk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tay at ichowacha sak-en isnan Gentil, ay at omam-amsiw ya at omilal-ayos ya tomobfatobfa. ");
INSERT INTO lbk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Somaplisaplit cha akhes sa cha't pomatey. Ngem at matakho ak kasin isnan maikatlo ay akhew.” ");
INSERT INTO lbk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nay met achi eg-ay paat naawatan nan disipolosna nan ayen nan chey ay kinwanina. Ad-icha ammo nan laychena ay kanan tay naitafon nan ayen nan chey ay kali ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Issan cha maisag-enan cha Jesus id Jerico, wad-ay nan nakolap ay lalaki ay tomotokcho ay cha enlimlimos is kailit nan chalan. ");
INSERT INTO lbk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Issan nanngelana isnan angsaangsan ay takho ay lomal-aos kinwanina en, “Ngag man nan cha maang-angnen sina?” ");
INSERT INTO lbk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Cha lomaos si Jesus ay iNazaret,” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Naneng na't ya fokhaw ay nangwanin, “Jesus ay Anak David, seg-angam sak-en!” ");
INSERT INTO lbk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sa et yinangyangan nan cheycha'y namangpango ay cha mangipagkhinek. Ngem onanig na infokhaw ay nangwanin, “Anak David, seg-angam sak-en!” ");
INSERT INTO lbk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tinomke si Jesus ya infilina ta iyalicha ken siya. Osto ay sinmag-en, tinot-oyan Jesus ay nangwanin, ");
INSERT INTO lbk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngag nan laychem ay angnek ken sik-a?” “Apo,” kinwanina, “laychek man ay makaila kasin.” ");
INSERT INTO lbk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kinwanin et Jesus, “Makaila ka. Nan pammatim nan nangipagkhawis ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ya ket kannay nakaila, sa et inmonod ken Jesus ay nenchad-ayaw ken Apo Dios. Olay akhes nan am-in ay takho, chinad-ayawcha si Apo Dios issan nangil-ancha ischi. ");
INSERT INTO lbk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Inomchan et cha Jesus id Jerico. Issan linmaosancha ischi, ");
INSERT INTO lbk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","wad-ay nan ap-apon si enkorkortais ay faknang ay enngachan is Zakeo. ");
INSERT INTO lbk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Laychena koma ay ilaen mo sino si Jesus, ngem ad-i mabfalin tay aptik ya angsan ay takho nan nangalifongfong ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Naneng na't ya tagtag ay nang-ona, ya kinmalab is kakaew ay sikomoro ta ilaena si Jesus ay at lomaos ischi. ");
INSERT INTO lbk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Osto ay inomchan si Jesus is kakawad Zakeo, nentangad ay nangwanin, “Khomwab ka Zakeo. Ikamom, tay masapol ay chomag-os ak is afongmo idwani.” ");
INSERT INTO lbk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sa na't ala ya panad ya chachama nan layadna ay nangipaskhep ken Jesus is afongna. ");
INSERT INTO lbk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Am-in nan nangila ischi, et nenmollotomot cha ay nangwanin, “En man aped chomag-os siya is afong nan fomafasol ay?” ");
INSERT INTO lbk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tinmakcheg si Zakeo ay nangwani ken Apo Jesus, “Chey, Apo. Ichowak et nan khedwan nan kwak isnan posi, ya nan olay sino ay tinokongko isnan is yangkhay, et fayachak is mamin-epat ay kaad-acha.” ");
INSERT INTO lbk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Sa et kinwanin Jesus ken siya, “Naisalakan et chadlo nan nay ay sinpangafong idwani. Tay sak-en ay Anak si Takho, inmali ak ay manganap ya mangisalak isnan nadchongaw ay inmadchawi ken Apo Dios. Ya si Zakeo ay nay, nan esang ay nadchongaw ay anak met laeng Abraham.” ");
INSERT INTO lbk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Issan nanngelan nan cheycha'y takho isnacha, inog-okhod kayet Jesus nan esang ay al-alig, tay kanancha mo nganngani et nan maipail-an nan en-ap-apowan Apo Dios, tay cha et somag-en siya id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Adi kad kinwanina, “Wad-ay nan esang ay matangad ay lalaki ay nenfaat isnan ad-adchawi ay ili ta enfalin siya ay ali sa et chadlo somaa. ");
INSERT INTO lbk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Idwani, inayakhana nan sinpoo ay faana sa na't inkakcheng ay os-osto ken chaicha nan fallitokna ya infilina ken chaicha ay mangwanin, ‘Nay, igkhalansiyaanyo na engkhana is tomoliyak.’ ");
INSERT INTO lbk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ngem khapo tay kakholan nan kakailiyana siya, finmaa cha is omonod ay en mangwani, ‘Ad-imi laychen chi ay en-alimi.’ ");
INSERT INTO lbk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ngem khechangna kayet ay nenfalin siya ay ali sa et sinmaa. “Idwani, inpaayagna kannay nan cheycha'y faana ay nangitalkana isnan fallitok, ta waschin manakhang ken siya ay mangibfakha isnan khinalansiyana. ");
INSERT INTO lbk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nan inmona ay inmali, kinwanina, ‘Apo, nay nan maminsinpoo ay kaad-achan nan fallitok ay khinalansiyak isnan fallitokmo.’ ");
INSERT INTO lbk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Sa et kinwanin nan apona ken siya, ‘Khawis nan inangnem. Khawis ka ay faa. Idwani tay matalek ka isnan olay akit, nay et ippeyko sik-a ay mangiyapo isnan sinpoo ay ili.’ ");
INSERT INTO lbk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Inmali akhes nan ikadwa ay faa ay nangwanin, ‘Apo, nay nan maminlima ay kaad-achan nan fallitok ay khinalansiyak isnan fallitokmo.’ ");
INSERT INTO lbk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Sa na't kanan ken siya en, ‘At sik-a nan mangiyapo isnan lima ay ili.’ ");
INSERT INTO lbk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Inmali kayet nan esang, ke na't ay kanan en, ‘Apo, nay et chadlo nan fallitokmo. Finongonko isnan panyo ay nangitafon, ");
INSERT INTO lbk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tay omegyat ak ken sik-a, tay nalikhat ka ay takho. Aped mo alaen nan egaymo nenfellayan, sam et aniyen nan egaymo inmola.’ ");
INSERT INTO lbk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kanan et nan apona, ‘Ngaag ka ay faa! Nan sana ay kinwanim, tomoli ay men-okom ken sik-a! Ammom pet ay nalikhat ak ay takho tay alaek nan egayko inidno, sak et aniyen nan eg-ayko inmola. ");
INSERT INTO lbk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ngem ya kem eg-ay et mampay inyey is kabangko ta isnan nay ay sinmaalak ya alaek nan fallitokko ay wad-ay anakna?’ ");
INSERT INTO lbk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Sa na't kinwani isnan cheycha ay maitatakcho ken siya en, ‘Alaenyo ken siya nan fallitokko ya ichowayo isnan faak ay kawad nan maminsinpoo ay kaad-acha.’ ");
INSERT INTO lbk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Sa cha't kinwani ken siya, ‘Apo, ke man wad-ay et nan maminsinpoo ay kaad-acha ken siya ya!’ ");
INSERT INTO lbk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Sinongfatana chaicha ay nangwanin, ‘Siya na nan ibfakhak ken chakayo. Mo sino nan mangidno isnan wad-ay ken siya, at maagtan kayet. Ngem nan maiyalig ay maid mabfalina ay ad-i mangidno isnan wad-ay ken siya, et olay nan akit ay wad-ay ken siya, at makaan. ");
INSERT INTO lbk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Idwani, nan cheycha'y khomola ay ad-i menlayad ken sak-en ay en-alicha, iyaliyo chaicha isna ta pateyenyo isnan sakhangko!’ ” ");
INSERT INTO lbk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Osto ay kinwas Jesus nan al-aligna, namangpango ay nanikid id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Issan cha na somag-enan id Betfage ya id Betania, isnan filig ay makwani en Olivo, kinwanin Jesus ay nangipaon-ona isnan chwa ay disipolosna, ");
INSERT INTO lbk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“En kayo isnan chey ay ili ay masasakhang, ya mo somkhep kayo ischi at edchananyo nan maitattaked ay anak si dangki ay eg-ay kasaksakayan. Fadfachenyo nan talina ya iyaliyo isna. ");
INSERT INTO lbk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mo wad-ay mangwanin, ‘En yo man aped fadfachen sa ay?’ kananyo en, ‘Masapol nan Apo nan nay.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Issan inmayancha, tet-ewa ay inchanancha nan kinwanin Jesus ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Issan cha cha mamadfachan isnan dangki ket ay kinwanin nan nenkwa en, “En yo man aped fadfachen sa ay?” ");
INSERT INTO lbk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Masapol nan Apo nan nay,” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Adi kad inyeycha chi ken Jesus, ya inyap-apcha nan kakhaycha sa cha't finachangan siya ay nensakay ischi. ");
INSERT INTO lbk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Issan cha omayan Jesus, cha inyap-aplag nan cheycha'y takho nan kakhaycha is kachalan ay menchad-ayaw ken siya isnan omay-ayana. ");
INSERT INTO lbk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Osto ay sinmag-en et id Jerusalem, is kapannachan nan filig ay Olivo, inlapon nan angsaangsan ay disipolosna ay nenlal-ayad ya nangipapangekhe ay nenchad-ayaw ken Apo Dios khapo isnan angsan ay kamabfalina ay inil-ilacha. ");
INSERT INTO lbk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kinwanichan, “Bindisyonan Apo Dios nan Ali ay omali ay mangitakcheg ken siya. Machad-ayaw nan Katotongchowan, ya naornos cha nan wad-ay id chaya!” ");
INSERT INTO lbk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sa et nenkanan nan tapin nan Fariseo ay naichachad-om isnan angsaangsan ay takho ken Jesus, “Mistolo, pakhinkem nan disipolosmo!” ");
INSERT INTO lbk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ket ay kinwanin Jesus en, “Mo khominek cha, ibfakhak ken chakayo ay at isoblat nan naycha ay fato ay enfokhaw.” ");
INSERT INTO lbk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Issan cha et somag-enan cha Jesus id Jerusalem, nen-akha issan manasakhangana ischi. ");
INSERT INTO lbk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kinwanina, “Mo sa ya inammowanyo akhes nan mangitcho isnan oompaanyo, olay yangkhay idwani ay akhew! Ngem idwani naitafon et ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nay at omchan nan akhew ay menliwsan nan fosoyo isnan iliyo. Sa cha't alachan is lota nan iliyo ta selat-ancha ay ostoosto chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pakawasencha nan iliyo ya pateyencha chakayo ay omili ay wad-ay ischi, olay nan ongang-a. Ya maid paat mataynan ay olay esa'y matotoon ay fato isnan iliyo, tay paatenyo ay ad-i mamigfig isnan inmaliyan Apo Dios ken chakayo.” ");
INSERT INTO lbk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sinomkhep si Jesus isnan awwichan nan Timplo, sa na't ala ya soyog isnan wad-ay ischi ay cha en-ilaklako. ");
INSERT INTO lbk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kinwanina, “Naisolat isnan kalin Apo Dios en, ‘Nan afongko, et makwani en afong ay enlol-owalowan,’ ngem khinaebyo ay afong si mangaakew!” ");
INSERT INTO lbk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sa et winakas ay en nen-isos-olo is kaTimplo. Ngem nan aap-apon si papachi ya mimistolon si lenteg ya nan cheycha'y matangtangad ay takho, laychencha ay pateyen siya. ");
INSERT INTO lbk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nay met achi ad-i cha makaanap is waya ay mangangnen sidi, tay nan takho, eestencha ay manmannge isnan am-in ay kankanana. ");
INSERT INTO lbk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Isnan namingsan ay nen-isos-olowan ya nen-ipap-alawakhan Jesus isnan Khawis ay Chamag isnan takho isnan awwichan nan Timplo, inmey nan aap-apon si papachi ya nan mimistolon si lenteg ya nan amam-a ay ");
INSERT INTO lbk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nangwani ken siya en, “Ibfakham ken chakami mo ngag nan kalebfengam ay mangangnen isnacha. Sino nan nangichowa isnan nay ay kalebfengam?” ");
INSERT INTO lbk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sinongfatana chaicha ay nangwanin, “Ensalodsod ak ed akhes ken chakayo ta songfatanyo. ");
INSERT INTO lbk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Siya na nan salodsodko: ‘Sino nan nalpowan nan kalebfengan Juan ay mamonyag? Nalpo ngen ken Apo Dios paymo isnan takho?’ ” ");
INSERT INTO lbk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sa cha't natotya ay nangwanin, “Mo kanan tako en, ‘Nalpo ken Apo Dios,’ at kananan, ‘Ya ke yo mampay ad-i patpatiyen siya mo?’ ");
INSERT INTO lbk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ngem mo akhes kanan tako en, ‘Nalpo isnan takho,’ at fomaog am-in nan naycha'y takho tay patiyencha ay mamadto si Juan.” ");
INSERT INTO lbk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Adi kad kinwanichan, “Ad-imi ammo nan nalpowana.” ");
INSERT INTO lbk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sa et kinwanin Jesus, “Ad-ik et akhes ifaag ken chakayo mo ngag nan kalebfengak ay mangik-ikkan isnacha.” ");
INSERT INTO lbk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sa et inokhod Jesus nan nay ay al-alig isnan cheycha'y takho. Kinwanina, “Wad-ay nan esa'y takho ay nenmola is ofas is kaomana, sa na't inpasama ya nenfaat isnan teken ay ili ya inmannong siya ischi. ");
INSERT INTO lbk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Osto ay timpon si pinagpokhas, finaana nan en manot-oya isnan cheycha'y nannama ta alaena nan chatag nan apona. Nay met achi alan et nan cheycha'y nangipasamalana, ya faifaig ken siya, sa cha't aped inpakaan ay maid paat inalana. ");
INSERT INTO lbk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Idwani kasin finmaa is teken, ngem pinak-ocha kayet ya inlayolayosancha, sa cha't aped akhes inpakaan ay maid kayet inalana. ");
INSERT INTO lbk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sa et issan namaalana isnan maikatlo akhes, nenfakag cha, sa cha't aped inpakaan. ");
INSERT INTO lbk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Sa et kinwanin nan nenkwa isnan kaob-ofasan, ‘Ngag man et nan angnek? Ay man chadlo ta ifaak nan kedkecheng ay anakko ay laylaychek. At chadlo ibfaincha siya.’ ");
INSERT INTO lbk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ngem osto'y inilan nan cheycha'y manamsama isnan ofasan siya, kanancha't ay matotya, ‘Naay nan at manawid isna. Ay ta pateyen tako, ta enkwa tako nan tawidna!’ ");
INSERT INTO lbk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ke cha't nenkhoyakhoy ay nangibkas is kailitna sa cha't pinatey. “Idwani, ngag et kay nan angnen nan nenkwa isnan ofasan isnan cheycha'y manamsama? ");
INSERT INTO lbk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","At kanaali ay mamatey ken chaicha, sa na't ipabfanes nan omana isnan teken.” Issan nanngelan nan cheycha'y takho ischi, kinwanicha en, “Na! Lawa man! Asop ya ad-i maang-angnen sa!” ");
INSERT INTO lbk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iilaen Jesus chaicha ke na't kanan, “Mo siya sa, ngag et mampay nan ayen nan nay ay naisolat ay kalin Apo Dios? ‘Nan chadlos fato ay inad-in nan tomottoping, et siya nan nenfalin ay kapapatekhan ay fato isnan pegnadna’? ");
INSERT INTO lbk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Et olay sino ay mekchag isnan chey ay fato at mamekmek. Ya mo sino nan mekchakhan nan chey ay fato, at matomek.” ");
INSERT INTO lbk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Idwani, laychen nan mimistolon si lenteg ya nan aap-apon nan papachi ay pen tiliw kannay si Jesus isnan chey chadlos ay olas, tay ammocha ay chaicha nan kankanan Jesus isnan chey ay al-aligna. Ngem omegyat cha isnan takho. ");
INSERT INTO lbk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Et nensasaed cha is waya ay maniliwancha ken siya. Finmaa cha is finayachancha ay en kakhawigkhawis ya kasalosalodsod ken siya ta asop ya wad-ay kanana is khotok nan kaisaklangana ta ichowacha siya isnan kamabfalin ya kalebfengan nan khofernachor. ");
INSERT INTO lbk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sa cha't kinwani en, “Mistolo, ammomi ay osto nan kankanam ya isos-olom. Ya maid chadlos pawadwad-em isnan olay sino ay takho, mod-i ket nan yangkhay okhali ay laychen Apo Dios nan tet-ewa ay isos-olom. ");
INSERT INTO lbk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ibfakham ed ken chakami, mo ipalofos nan lenteg tako ay Judio nan enfayachan isnan fowis ken Cesar, paymo ad-i?” ");
INSERT INTO lbk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngem ammon Jesus nan sikapcha, ya kinwanina ken chaicha, ");
INSERT INTO lbk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Omipaila kayo is siping. Idwani, sino nan nenkames ya nenngachan isnan wad-ay isna?” “Si Cesar,” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Mo siya sa,” kinwanina, “ichowayo et mampay ken Cesar nan lebfengna ay enkwa, ya ken Apo Dios nan lebfengna akhes ay enkwa.” ");
INSERT INTO lbk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Adi kad egay cha't nakaipafasol ken siya isnan am-in ay kinkinwanina isnan takho. Cha cha't yangkhay nataa isnan insongfatna et inkhigkhinek cha et chadlo. ");
INSERT INTO lbk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wad-ay cha nan tapin nan Saduceo ay inmey ken Jesus. (Chaicha nan mangwani en ad-i kasin matakho nan natey.) ");
INSERT INTO lbk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Sinalodsod cha ay nangwanin, “Mistolo, wad-ay nan insolat Moises ay lenteg ta wanchen tako nan kag tona: ‘Mo matey nan inasaw-an ay lalaki ya maid anakna, masapol ay asaw-en nan akhina nan chey ay nailekkasan, ta enpawad-ay si anak nan akhina ay natey.’ ");
INSERT INTO lbk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Idwani, wad-ay nan pito ay sin-ag-i ay lallalaki. Inmasawa nan inaona, ya ket natey ay maid winad-ayna. ");
INSERT INTO lbk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sa et inasawan nan ikadwa nan chey ay nailekkasan, ngem natey akhes ay maid anakcha. ");
INSERT INTO lbk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Siya kayet chi isnan ikatlo engkhana isnan ikapito. Natey cha am-in ay maid anakcha. ");
INSERT INTO lbk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Awni pay ya ket natey akhes nan chey ay fafai. ");
INSERT INTO lbk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Idwani, isnan chey ay akhew ay kasin matakhowan nan natey, sino nan osto ay asawana? Tay siya chi ay inasawan nan pito ay sin-ag-i.” ");
INSERT INTO lbk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sinmongfat si Jesus ay nangwanin, “Nan takho isnan nay ay lota et maasaswa cha. ");
INSERT INTO lbk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ngem nan takho ay maikali ay matakho kasin isnan etey ta enfiyag isnan kasin wad-ay ay fiyag, at ad-i cha kasin maasaswa paymo maipaasawa ");
INSERT INTO lbk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tay ad-i cha matmatey. Kag cha angheles. Anak Apo Dios chaicha tay natakho cha kasin isnan etey. ");
INSERT INTO lbk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Olay si Moises, inpailana ay kasin matakho nan natey. Tay isnan naisolat maipoon issan enfidfichang ay chapong, infakhana nan maipoon ken Apo Dios ay nangwanin, ‘Nan Dios cha Abraham, Isaac, ya si Jacob.’ ");
INSERT INTO lbk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Idwani, nan laychena ay kanan et faken siya nan Dios si natey, mod-i ket Dios nan matatakho. Tay am-in nan takho, ay sisya'y wad-ay ya kinmaan, et matatakho cha isnan sakhangna.” ");
INSERT INTO lbk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sa et kinwanin nan tapina ay mistolon si lenteg en, “Khawis nan insongfatmo, Mistolo!” ");
INSERT INTO lbk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tay maid kasin toledcha ay ensalodsod ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sa et kinwanin Jesus ken chaicha, “Ngag nan mangwaniyancha ay nan Cristo, et malpo isnan waned David? ");
INSERT INTO lbk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tay si David kannay nan nangwani maipoon ken Cristo isnan liblon nan Salmo en, ‘Kinwanin nan Dios Apo isnan Apok en, “Itokchom is kakannawanko, ");
INSERT INTO lbk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","engkhana ay lag-ek nan fosom ay kag mo enkhatkhatinan.” ’ ");
INSERT INTO lbk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Idwani mo siya sa ay Apo nan kinwanin David ken siya ay Cristo, ngag kay nan ikkana ay anak David siya?” ");
INSERT INTO lbk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Issan nanngelan nan katakhotakho ken Jesus, kinwanina isnan disipolosna, ");
INSERT INTO lbk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ilaenyo ta en-annad kayo isnan mimistolon si lenteg, ay en yangkhay mangichalachalan isnan khag-awis ay anancho ay fachocha. Laylaychencha ay maichad-ayaw is kamarkitan, isnan kakhawisan ay tokchowan is kasinagoga, ya isnan maayakhancha ay makikkanan. ");
INSERT INTO lbk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Maid ad-icha angnen ay en mensikasikap isnan cheycha'y nailekkasan ta mangal-ancha isnan afongcha. Sa cha't anchoanchowen nan lowalocha ta mafob-oya cha. At kadchacham-etan nan chosacha!” ");
INSERT INTO lbk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wad-ay cha Jesus isnan awwichan nan Timplo ay sag-en nan maipaypay-an nan siping, ya osto'y nen-ila, inilana nan fafaknang ay cha mangippey isnan likhalocha ischi. ");
INSERT INTO lbk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sa na't inila akhes nan nailekkasan ay maid mabfalina ay en nangippey isnan chwa ay tanso. ");
INSERT INTO lbk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sa na't kanan, “Tet-ewa nan kanak, ad-ad-acha nan inpey nan naay ay posi ay nailekkasan mo nan inpey am-in nan cheycha'y tapina. ");
INSERT INTO lbk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tay inigwacha am-in nan sobla isnan ifaknangcha, ngem nan nay ay nailekkasan, olay mo maid mabfalina, inigwana nan am-in ay ikatakhona.” ");
INSERT INTO lbk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Cha matotya nan tapina maipoon isnan khag-awis ay ilan nan ensis-ileng ay fato ay naikhaeb isnan Timplo ya nan naiyar-arkos ay likhalo ay naichowa ken Apo Dios. Ngem kinwanin Jesus, ");
INSERT INTO lbk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Am-in nan naycha ay iilaenyo, at omali nan timpo ay mapakawas chasa ay ostoosto, ya maid paat olay esang is entotoon ay fato tay at maikoob cha am-iam-in.” ");
INSERT INTO lbk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sa cha't kanan, “Mistolo, kaatna kay nan kaommatan nan tosacha? Ya ngag nan kaimatonana ay nganngani et ay omat?” ");
INSERT INTO lbk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sinmongfat ay nangwanin, “Ilaenyo mampay ay khawis ta ad-i kayo masasailowan. Tay at angsan cha nan fomala ay mangosar isnan ngachanko ay Cristo ay mangmangwani en, ‘Sak-en nan Cristo,’ ya, ‘Inomchan et nan timpo!’ Ad-iyo ab-abfoloten chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mo akhes chengngenyo ay wad-ay khofat ya enkhogkholo nan katakhotakho, ad-i kayo omeg-egyat, tay masapol ona ay maangnen chasa, ngem faken kayet sa nan mapengpengan nan lofong.” ");
INSERT INTO lbk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sa na't intot-oloy ay nangwanin, “At enfifinnaloknit ona nan kailiili, ya enkhogkhofat cha nan kaaliali. ");
INSERT INTO lbk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","At wad-ay nan chachama ay yekha, ya isnan olay entona ay ili wad-ay nan chad-ama ay fitil ya kakaegyat ay pisti. Ya wad-ay kayet nan kakaegyat ay om-omat ya fomegyas ay maton ay mail-ila id chaya. ");
INSERT INTO lbk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ngem isnan ad-i kayet kaommatan am-in nan naycha, at khoyochencha chakayo ya palikhatencha chakayo. Isaklangcha chakayo is kasinagoga ya ifalodcha chakayo. Iyeycha akhes chakayo ay ipaokom isnan sakhang nan ali ya khofernachor midkakay ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Siya sa nan wayayo ay manistikho isnan kinatet-ewa maipoon ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Imolayo is kasemekyo ta ad-iyo cha et onaen ay manmemanmek isnan isfatyo, ");
INSERT INTO lbk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tay at sak-en kannay nan mangichowa isnan kananyo ya nan kinasilibyo ay somfat, ay ad-i mabfalin ay kasin soplaen paymo issot nan en-ap-apos. ");
INSERT INTO lbk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Olay nan ama ya inayo, nan ag-iyo, kikib-ayo ya nan lilwidyo, chaicha kannay nan mangitiktik ken chakayo, sa cha't pateyen nan tapina ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","At liligten nan olay sino chakayo midkakay ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nay met achi olay kag tosa, enkhagkhawis kayo kayet, maid olay esang is fook ay maamas isnan oloyo. ");
INSERT INTO lbk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ikekedseyo tay siya sa nan kaisalakan nan leng-agyo.” ");
INSERT INTO lbk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sa et kinwanin Jesus, “Mo ilaenyo nan ili ay Jerusalem ay liniwes nan kalifolifo ay sorchacho, at siya nan mangammowanyo ay nganngani nan mapakawasana. ");
INSERT INTO lbk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sa et chakayo ay wad-ay isna id Judea, lomayaw kayo kannay is kafilig. Nan wad-ay isnan ili, enfakwit cha, ya nan namoknag ad-i cha kasin somaa. ");
INSERT INTO lbk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tay at siya chana nan akhew ay madchosaan nan takho ay at maangnenan nan am-in ay naisolat ay kalin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Selaeg nan cheycha'y maliton ya nan enpasoso isnan tosacha ay akhew! Tay at kangangaya nan am-in isnan nay ay ili ya nan songet Apo Dios nan maliliknan nan naycha ay takho. ");
INSERT INTO lbk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","At mafadyokan nan tapina, mafalod nan tapina ay maiyey isnan kailiili. Sa et aped khakhagkhatinan nan Gentil nan iJerusalem engkhana ay makwas nan timpocha.” ");
INSERT INTO lbk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kinwanin kayet Jesus, “At wad-ay cha nan maton ay mail-ila isnan akhew, isnan fowan ya isnan tokwifi. Ya at ngomangaya nan am-in ay kailiili tay maid kasin maangnencha khapo isnan egyatcha isnan kakaegyat ay komayaas ay fayfay ya talipyakew. ");
INSERT INTO lbk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","At cha aped maolaw nan takho isnan egyatcha ay manman-ed et yangkhay isnan at maangnen isnan lofong, tay maid paat manongnong isnan wad-ay id chaya tay at maipaatoaton. ");
INSERT INTO lbk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sa et chadlo ilaen nan katakhotakho sak-en ay Anak si Takho ay omal-ali isnan lifoo isnan kamabfalinko ya nan chadlos ay kalanglang nan chayawko. ");
INSERT INTO lbk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Et mo mailapo ay maangnen chana, itakchegyo ya entangad kayo tay nganngani et nan kaisalakanyo.” ");
INSERT INTO lbk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sa et inokhod Jesus nan nay ay al-alig. Kinwanina, “Ilaenyo nan kaew ay higos ya nan tapina kayet ay kaew. ");
INSERT INTO lbk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mo chakhos ilaenyo ay kasin tomofo, ammoyo ay nganngani et nan chakhon. ");
INSERT INTO lbk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kag akhes mo ilaenyo ay om-omat nan naycha, at ammoyo ay nganngani nan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tet-ewa kanak ken chakayo, at maangnen ay maangnen ona am-in chana esa pay mar-os nan takho ay wad-ay idwani. ");
INSERT INTO lbk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mamaid nan chaya ya nan lota, ngem nan kankanak et sisya is eng-engkhana ya ad-i enfab-aliw.” ");
INSERT INTO lbk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Sa et kinwanin Jesus, “Mey-anyo, ta ad-i kayo makna isnan chey ay akhew ay kaanaliyak, ya maaspowan kayo ay maoolaw isnan foteng ya finofoslon ay fiyag, ya isnan ngag issa ay chanag maipoon isnan ikatakho. ");
INSERT INTO lbk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tay isnan sak omaliyan, kag masalacheyan nan am-in ay takho isnan olay entona isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ngem chakayo, ensasakhana kayo isnan ngag issa ay olas, ya kad-in enlol-owalo kayo ta wad-ay omanay is fikasyo ay mangikatpe ya komasiw isnan kaommatan am-in nan naycha, ya ta mabfalinyo ay somakhang ken sak-en ay Anak si Takho.” ");
INSERT INTO lbk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sa et kawakawakas si Jesus is kaTimplo ay cha en-isos-olo. Ngem mo malafi, omey isnan filig ay Olivo ay omyan sid-i. ");
INSERT INTO lbk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ya isnan kawiiwiit, omey nan katakhotakho ay mannge isnan kankanana is kaTimplo. ");
INSERT INTO lbk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Idwani nganngani et nan Piyastan nan Tinapay ay Egay Kafofochan, ay makwani akhes en Paskua. ");
INSERT INTO lbk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Et nan aap-apon nan papachi ya nan mimistolon si lenteg, cha cha inyan-anap mo ngag nan ikkancha ay mangipapatey ken Jesus, tay omegyat cha isnan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ket ay sinkhep Satanas si Judas Iscariote, ay esang isnan sinpoo ya chwa ay disipolos. ");
INSERT INTO lbk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Et inmey nakitoya isnan aap-apon si papachi ya nan kakapitan nan cheycha'y khwarchiya isnan Timplo maipoon isnan at angnena ay mangichowa ken Jesus ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Sa cha't nenlal-ayad ya inkalicha ken siya nan siping. ");
INSERT INTO lbk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tinan-oyan Judas nan kinwanicha, sa na't inyan-anap nan ikkana ay mangitiktik ken Jesus isnan maichan nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Inomchan et nan akhew ay Piyastan si Tinapay ay Egay Kafofochan ay masapol ay menkhekhechancha isnan kordero isnan am-amongcha isnan Paskua. ");
INSERT INTO lbk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Et finaan Jesus cha Pedro ken Juan ya kinwanina, “En kayo isakhana nan manganan tako isnan Paskua.” ");
INSERT INTO lbk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Ento nan laychem ay omisagkhanaanmi?” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sa na't kanan, “En kayo isnan ili, ya mo somkhep kayo, at wad-ay nan lalaki ay sab-atenyo ay en nangisakcho isnan fanga. Onochenyo isnan afong ay somkhepana, ");
INSERT INTO lbk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","sa yo't kanan isnan nen-afong en, ‘Laychen nan Mistolo ay ammowen mo ento nan kwarto ay mangiyofongana isnan disipolosna isnan Paskua?’ ");
INSERT INTO lbk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ya at ipailana ken chakayo nan chakchake ay kwarto ay entongcho ay nanongnonongnong. Ischi nan en-isagkhanaanyo.” ");
INSERT INTO lbk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Inmey cha ya inchanancha tet-ewa nan chadlos infaag Jesus ken chaicha, ya insakhanacha ischi nan manganancha isnan am-among ay Paskua. ");
INSERT INTO lbk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Osto'y olas ay pinnangan, nangan cha Jesus ya nan apostolesna. ");
INSERT INTO lbk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sa na't kanan, “Inmannong ay lalaychek ay makikan ken chakayo isnan nay ay Paskua, isnan sisya ay ad-ik enlikhatan! ");
INSERT INTO lbk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tay kanak ken chakayo ay ad-i ak kasin mangmangan isnan Paskua engkhana ay maangnen ona nan ayen nan Paskua isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sa et inalan Jesus nan matatasa ay fayas ya nenyaman ken Apo Dios, sa na't kanan, “Alaenyo na ta waschin kayo ominom. ");
INSERT INTO lbk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tay kanak ken chakayo ay mailapo idwani at maid kasin omin-inomak isnan kag tona ay fayas, engkhana ay omali ona nan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sa et akhes inmala isnan tinapay, nenyaman, pinetpet-angna sa na't inchowa ken chaicha ay mangwanin, “Siya na nan awakko ay maigwa pala ken chakayo. Kanenyo na ta manemsemkanyo ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Isnan nakakkanancha, siya akhes chi nan inangnena isnan matatasa ay inchowana ken chaicha. Kinwanina en, “Nan nay ay matatasa, siya nan falo ay tolag Apo Dios ay nakhaeb isnan chalak ay omayos pala ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ngem, ilaenyo! Wad-ay ay makikkikan ken sak-en nan at aped mangitiktik ken sak-en! ");
INSERT INTO lbk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tay awni't matey ak ay Anak si Takho ay maiton-od isnan inkedcheng Apo Dios, ngem selaeg nan takho ay mangitiktik ken sak-en!” ");
INSERT INTO lbk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sa cha't nen-asisalodsod mo sino ken chaicha nan sa mangangnen ischi. ");
INSERT INTO lbk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sa et nasosma nan disipolos Jesus mo sino ken chaicha nan maifilang ay katotongchowan. ");
INSERT INTO lbk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sa et kinwanin Jesus, “Nan alin nan Gentil, palikhatencha nan iyap-apowancha. Wen, chaicha ay wad-ay kalebfengancha, laychencha kayet ay makwani en, ‘Naoya ay Apo’. ");
INSERT INTO lbk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ngem faken kag tosa ken chakayo, mod-i ket nan katotongchowan ken chakayo, siya koma nan kag alilis, ya nan en-apo, siya koma nan mafab-aa. ");
INSERT INTO lbk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sino nan entongtongcho, nan tomokcho ay mangan paymo nan chey faa ay namangan ken siya? Ad-i ngen nan chey tomokcho ay mangan? Ngem sak-en, wad-ay ak ken chakayo ay kag faa.” ");
INSERT INTO lbk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Sa et kinwanin Jesus, “Chakayo nan wawawawad-ay ken sak-en isnan am-in ay likhatko. ");
INSERT INTO lbk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Idwani, angnek ken chakayo nan inangnen Ama ken sak-en, tay inchowana ken sak-en nan kalebfengak ay en-apo, ya siya akhes nan angnek ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","At makikan kayo ya makiinom kayo is kalamisaanko isnan en-ap-apowak, ya at wad-ay kayo akhes isnan cheycha'y tronoyo ay cha mangokom isnan sinpoo ya chwa ay tribon Israel.” ");
INSERT INTO lbk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, chengngem! Chey, chinawat et Satanas nan olasna ay maneptepeng ken chakayo isnan likhat, ay kag cha mangakhaag ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ngem inlol-owalowak sik-a, Simon, ta ad-i makaan nan pammatim. Ya sa et mo kasin ka somakhong ken sak-en, at isoblatmo akhes ay mangipafikas isnan ib-am.” ");
INSERT INTO lbk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kinwanin Pedro, “Apo, ensasakhana ak ay maitapi ken sik-a olay is kafabfalochan paymo isnan etey.” ");
INSERT INTO lbk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Pedro, kanak ken sik-a ay at sisya ay ad-i enkokook nan kawitan is talan-o ya omisaot ka is mamitlo ay mangwanin ad-im ammo sak-en.” ");
INSERT INTO lbk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sa et kinwanin Jesus, “Issan namaalak ken chakayo ay maid pitaka, sopot paymo sinilas, wad-ay ngen nenkolanganyo?” “Maid paat,” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Ngem idwani, nan wad-ay pitaka paymo sopotna, itakina. Ya mo sino nan maid fadyokna, ilakona nan kakhayna ta lomako. ");
INSERT INTO lbk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tay kanak ken chakayo ay masapol ay maangnen ken sak-en nan naisolat ay kalin Apo Dios ay mangwanin, ‘Infilangcha siya isnan takho ay maid lentegna.’ Siya, tay am-in nan naisolat maipoon ken sak-en, et cha maangnen.” ");
INSERT INTO lbk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sa cha't kanan, “Naay, Apo. Wad-ay et chwa'y fadyok isna.” Sa na't kinwanin, “Osto sa!” ");
INSERT INTO lbk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Idwani, kinmaan si Jesus ischi, ya kag isnan inpaingsana ay ang-angnen, nanikid cha isnan disipolosna isnan filig ay Olivo. ");
INSERT INTO lbk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Osto'y inomchan cha ischi, kinwanina ken chaicha, “Enlowalo kayo ta ad-i kayo maafak isnan sailo.” ");
INSERT INTO lbk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sa et inmadchawi siya is akit ay kag isnan kaadchawin nan maibkasan nan fato, sa et nenfalintomeng ay nenlowalo. ");
INSERT INTO lbk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama,” kinwanina, “mo sa ya laychem ta kaanem ken sak-en nan nay ay chad-ama ay likhat. Nay met achi faken nan nemnemko mod-i ket nan nemnemmo nan maangnen.” ( ");
INSERT INTO lbk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sa et nenpaila nan anghel ay nalpo id chaya ay nangipafikas ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ya onanig na inpapati ay nenlowalo isnan chad-ama ay likhatna, ya nenlingelinget is kag chala ay cha entedted is kalota.) ");
INSERT INTO lbk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Issan nakwasana ay nenlowalowan, naligwat ya tinmoli is kakawad nan disipolosna, ya inaspowana chaicha ay cha mitom-e tay chad-ama nan sangacha. ");
INSERT INTO lbk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sa na't kanan, “Ya ke kayo mammaek? Ifangonyo et achi ta enlowalo kayo ta ad-i kayo maafak isnan sailo.” ");
INSERT INTO lbk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sisya'y enkak-ali si Jesus issan inmaliyan nan angsan ay takho, ya si Judas ay esang isnan sinpoo ya chwa ay disipolos nan nangipango ken chaicha. Sa et sinmag-en ay mamisito ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ngem nenkanan Jesus, “Judas, ay kem itiktik sak-en ay Anak si Takho isnan fomisitowam?” ");
INSERT INTO lbk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Issan nangil-an nan cheycha'y disipolos Jesus ay ensag-en ken siya nan sa omat, nenkanancha, “Apo, pen fadyokanmi ngen chaicha?” ");
INSERT INTO lbk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sa et alan nan esang ken chaicha ya fakag isnan faan nan katongchowan ay pachi ya ket ay nan kannawan ay koweng nan chey ay faa nan nalongochan. ");
INSERT INTO lbk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","“Ad-o sa!” kinwanin Jesus. Sa na't inegnan nan koweng nan chey faa ya inpagkhawisna. ");
INSERT INTO lbk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sa et kinwanin Jesus isnan aap-apon nan papachi ya nan kakapitan nan cheycha'y khwarchiya isnan Timplo ya nan amam-a ay naitakin ay en maniliw ken siya, “Ay ke ak mangaakew ya kakaegyat, ta omali kayo ay enfafadyok ya enpapak-o? ");
INSERT INTO lbk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Inakhew met ay wad-ay ak ken chakayo is kaTimplo, ya eg-ay kayo tinmit-iliw. Ngem siya na nan naitcho ay timpoyo ay olas si follinget, ay en-ap-apowan nan ngaag.” ");
INSERT INTO lbk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sa cha't tiniliw si Jesus ya inpangocha ay nangiyey is afong nan katongchowan ay pachi, ya nakhag-ayad si Pedro ay inmon-onod. ");
INSERT INTO lbk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Osto ay pinaskhechancha nan ennidnichowancha isnan tengan nan awwichan nan afong, inmey et si Pedro ay nakitoktokcho ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ngem ket ay wad-ay nan magmagkit ay faa ay nangila ken siya issan nalanglangana. Sa na't insin-eng ay nangwanin, “Esang akhes si ton-a ay fowegna!” ");
INSERT INTO lbk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nay met achi insaot Pedro ay nangwanin, “Anen! Ay kek man ammo siya.” ");
INSERT INTO lbk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Osto'y nawnawni is akit, wad-ay kasin nan lalaki ay nangila ken siya. Sa na't kinwanin, “Sik-a akhes nan esang ay fowegna!” Ngem kinwanina, “Ay ke sak-en?” ");
INSERT INTO lbk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Away nget esa'y olas ya ket ay wad-ay nan nangipapilit ay nangwanin, “Tet-ewa mampet ay esang na akhes isnan fob-owegna, tay iGalilea!” ");
INSERT INTO lbk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngem kinwanin kayet Pedro en, “Ay kek man ammo nan kankanam!” Ket ay nanakokook nan kawitan issan cha na enkak-aliyan. ");
INSERT INTO lbk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sa et nensakhong si Jesus, ya iilaena si Pedro. Sa na't sinmek nan kinwanin Apo Jesus issan nangwaniyana en, “At sisya'y ad-i enkokook nan kawitan is talan-o, ya at mamitlo ay omisaot ka!” ");
INSERT INTO lbk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sa et finmala ya nensifesifek. ");
INSERT INTO lbk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Idwani, intachon nan cheycha'y manoktokkhong ken Jesus ay nangang-ango ya nanodsodpak ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sa cha't inokopan nan matana ay mangwanin, “Pontowam man mo sino nan nanodpak ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Sa cha't kayet kinalyakalyan siya is ensakit ay kali. ");
INSERT INTO lbk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Osto ay nawiit, naamong nan amam-an nan Judio ya aap-apon si papachi ya nan mimistolon si lenteg, sa cha't inpaayag si Jesus ay manakhang ken chaicha. Sa cha't kinwanin, ");
INSERT INTO lbk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ibfakham ken chakami mo sik-a nan Cristo.” Ngem kinwanina, “Mo ifaagko ken chakayo, ad-iyo kayet patiyen, ");
INSERT INTO lbk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ya mo wad-ay salodsochek ken chakayo, ad-i kayo somongfat. ");
INSERT INTO lbk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngem mailapo idwani, wad-ay ak ay Anak si Takho ay tomotokcho is kakannawan nan Makabfalin ay Dios.” ");
INSERT INTO lbk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Sa cha't am-in kinwanin, “Et sik-a ngen mampay nan Anak Apo Dios?” Sa na't kanan, “Kinwaniyo et ya!” ");
INSERT INTO lbk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sa cha't kinwanin, “Ay ke tako kasin masapol nan tistikho? Chinnge tako met nan chadlos na infakha!” ");
INSERT INTO lbk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sa cha't am-in naligwat ay nangiyey ken Jesus is sakhang Pilato. ");
INSERT INTO lbk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sa cha't inlapo ay nangisaklang ken siya ay nangwanin, “Inchananmi si tona ay mangipabpafikas isnan kakailiyanmi ta kholaencha nan khoferno, sa na't cha kankanan en ad-imi fayachan nan fowismi ken Cesar. Ifagfakhana akhes ay siya nan Cristo ay ali.” ");
INSERT INTO lbk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sa et kinwanin Pilato, “Ay sik-a pet tet-ewa nan Alin si Judio?” “Osto nan kinwanim,” inisfat Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sa et kinwanin Pilato isnan aap-apon nan papachi ya nan katakhotakho en, “Maid maanapak is fasol tona.” ");
INSERT INTO lbk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngem inpapaticha kayet ay nangwanin, “Pabpafikasena nan katakhotakho ay menkholo isnan am-in ay ili id Judea, khapo isnan isos-olona. Inlapona id Galilea, engkhana ay inomchan isna.” ");
INSERT INTO lbk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Issan nanngelan Pilato isna, sinalodsodna ay nangwanin, “iGalilea ngen na?” ");
INSERT INTO lbk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Osto ay chinngena ay nalpo si Jesus isnan ili ay iyap-apowan Herodes, inpaiyeyna siya ken Herodes ay wad-ay akhes id Jerusalem issan chey ay timpo. ");
INSERT INTO lbk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Issan nangil-an Herodes ken Jesus, nenlal-ayad tay inmannong ay laychena ay mangila ken siya. Chinngechinngena nan maipoon ken siya, ya laychena ay ilaen si Jesus ay en-angnen koma is katataa. ");
INSERT INTO lbk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tay siya chi angsan nan sinas-alodsod Herodes ken siya, ngem maid paat insongfatna. ");
INSERT INTO lbk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Osto ay siya chi, nan aap-apon nan papachi ya nan mimistolon si lenteg ay entatakcheg ischi, ab-afikas cha ay nangipangpangaag ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sa et si akhes Herodes ya nan sorchachona, inang-angocha ya inlal-ayosancha siya. Sa cha't inpafacho nan khag-akhag-awis ay kakhay ya inpasakhongna ken Pilato. ");
INSERT INTO lbk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Et nailapo isnan chey ay akhew, cha Herodes ken Pilato ay nen-asikhola issan chey, nenliwid cha't chadlo. ");
INSERT INTO lbk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sa et inpaayag Pilato nan aap-apon nan papachi, nan aap-apon nan takho, ya nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kinwanina ken chaicha, “Inyaliyo ken sak-en si tona tay kananyo en pabpafikasena nan katakhotakho ay menkhola isnan khoferno. Sinomaryak siya isnan sakhangyo, ngem chey, maid paat naanapak is fasolna maipoon isnan am-in ay chalomyo ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Siya akhes ken Herodes, tay inpasakhongna ken chatako, tay maid mampay inangnena is khotok si aped na mapateyan. ");
INSERT INTO lbk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Faikhek et yangkhay siya ta sak et palofosen.” ( ");
INSERT INTO lbk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Idwani, ekhad Pilato ay omipalofos is esang ay falod pala ken chaicha mo omchan nan kag tona ay piyasta.) ");
INSERT INTO lbk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sa et waschin fofokhaw nan katakhotakho ay mangwanin, “Alaem si tosa, si Barrabas nan ipalofosmo ken chakami!” ");
INSERT INTO lbk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Naifalod si Barrabas tay siya nan nangipangpango isnan kholo id Jerusalem ya nenpatey.) ");
INSERT INTO lbk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Idwani, tay lalaychen Pilato ay ipalofos si Jesus, kasin et nenkali isnan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ngem onanig cha kasifofokhaw ay mangwanin, “Ilansam siya! Ilansam siya is kakolos!” ");
INSERT INTO lbk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sa et kinwanin kayet Pilato ken chaicha isnan ikapitlo en, “Ngag mampay nan ngaag ay inangnena? Maid met naanapak is fasolna ay chadlos na mapateyan! Faikhek et yangkhay ta sak et palofosen.” ");
INSERT INTO lbk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngem inpapaticha kayet ay nangifogfokhaw ta mailansa siya, ya ket ay nangafak nan fokhawcha. ");
INSERT INTO lbk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tay siya chi, intan-oy et Pilato nan kechaw nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sa na't inpalofos nan naifalod ay nenkholo ya nenpatey ay kinchawcha, ngem si Jesus, inchowana ken chaicha ta angnencha ken siya nan laychencha. ");
INSERT INTO lbk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Idwani, issan cha cha mangikaanan ken Jesus, khinoyodcha nan iCirene ay enngachan is Simon ay nalpo id ilit ya cha somkhep isnan ili, sa cha't inpasakfat ken siya nan kolos ta iyon-onodna ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Angsan nan katakhotakho ay inmon-onod, ya wad-ay nan tapina ay fabfafai ay cha enngegngeg ay mangag-akha ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sa et sinakhong Jesus chaicha ay nangwanin, “In-a ay iJerusalem, ad-iyo akhalan sak-en, mod-i ket nan awakyo ya nan an-akyo. ");
INSERT INTO lbk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tay at omali nan kakaegyat ay akhew ay mangmangwaniyancha en, ‘Oneoney nan fafai ay nakot-eg, ay egay inman-anak paymo nenpaspasoso.’ ");
INSERT INTO lbk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Siya kayet chasa nan akhew ay at aped mangifag-an nan takho isnan kafilifilig en, ‘Khomab-on kayo!’ paymo, ‘Omitafon kayo!’ ");
INSERT INTO lbk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tay mo mampay kag tona nan angnencha ken sak-en ay kag al-alangta ay kaew, ad-i ngen am-am-amed nan angnencha ken chakayo ay kag nalango ay kaew?” ");
INSERT INTO lbk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Inpangocha akhes nan chwa ay falod ay maitapi ken siya ay en mapatey. ");
INSERT INTO lbk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ya issan inomchanancha isnan filig ay makwani en Ingit nan Olo, inlansacha si Jesus is kakolos, ya nan chwa ay falod akhes, is kakannawana ya is kakannikhidna. ");
INSERT INTO lbk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sa et kinwanin Jesus, “Ama, pakawanem chaicha, tay ad-icha ammo nan ang-angnencha.” Sa et nenfonot nan sorchacho ay manatag isnan fachona. ");
INSERT INTO lbk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wad-ay cha nan katakhotakho ay enfob-oya, ngem nan aap-apocha, chinopichopischa ay mangwanin, “Insalakana nan tapina, isalakana achi akhes nan awakna mo tet-ewa ay siya nan Criston Apo Dios ay pinilina!” ");
INSERT INTO lbk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Intachon akhes nan cheycha'y sorchacho ay nangang-ango ay en nangipasosop isnan sinmoka ay fayas. ");
INSERT INTO lbk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kinwanicha, “Mo sik-a nan alin nan Judio, isalakam nan awakmo!” ");
INSERT INTO lbk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tay wad-ay nan naisolat is tongchona ay kag tona: “Si tona nan Alin si Judio.” ");
INSERT INTO lbk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sa et nan chey esang ay falod ay naitapi ay naikolos, ab-afikas ay nangam-amsiw ken Jesus ay nangwanin, “Ay ke ka faken Cristo! Isalakam achi nan awakmo ya chakami!” ");
INSERT INTO lbk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngem yinangyangan nan kadwana ay nangwanin, “Ay ke ka ad-i omegyat ken Apo Dios? Ya ke tako mis-o am-in ay cha machosa ya! ");
INSERT INTO lbk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Chaita, lebfengna ay machosa ta khapo isnan inangnenta, ngem si tona, olay maid paat ngaag is inikkana…!” ");
INSERT INTO lbk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sa na't kanan ken Jesus, “Jesus, asop ya sesemkem sak-en mo omali ka ay en-ap-apo.” ");
INSERT INTO lbk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kinwanin Jesus ken siya, “Tet-ewa kanak ken sik-a ay idwani kannay ay akhew at wad-ay ka ken sak-en id Paraiso.” ");
INSERT INTO lbk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Away nget alas chosi ya ket ay namaid nan silaw nan akhew ya finmollinget isnan am-in ay ili ischi engkhana ay alas tris isnan misoyaw. Sa et nenkapepeskhat ay nakhedwa nan kortinan nan Timplo. ");
INSERT INTO lbk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sa et inpapangekhen si Jesus ay nenngao, “Ama, nay italekko nan leng-agko ken sik-a!” Kinwanina chi sa et nasokpot nan fiyagna. ");
INSERT INTO lbk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Issan nangil-an nan kapitan si sorchacho isnan chey ay naang-angnen, nenchayaw ken Apo Dios ay nangwanin, “Tet-ewa pet ay nalenteg na ay takho!” ");
INSERT INTO lbk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Am-in akhes nan takho ay naam-among ischi ay enfob-oya, et sinmaa cha ay enngongoyos ay nangabkabkab isnan takebcha, issan nangil-ancha isnan cha inmat. ");
INSERT INTO lbk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Am-in kayet nan cheycha'y chadlos mangammo ken Jesus ya nan fabfafai ay inmon-onod ken siya ay nalpo id Galilea, et nentatakcheg cha isnan ad-adchawi ay namob-oya isnacha. ");
INSERT INTO lbk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Idwani, wad-ay nan esang ay khawis ya nalenteg ay lalaki ay enngachan si Jose ay nalpo id Arimatea, ay esang ay ilin nan Judio. Sinsin-edna nan omaliyan nan en-ap-apowan Apo Dios. Ya olay mo esang siya isnan amam-an nan Judio, eg-ay nakitantan-oy isnan natotyaancha ya nan inangnencha ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inmey ken Pilato ay nangchaw isnan awak Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sa et inmey ay nangipagkhwab isnan awakna ya innewesana isnan khawis ay lopot, sa na't inpey isnan naliyangan ay cheppas ay egay kapaypay-an si natey. ");
INSERT INTO lbk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kalmana chi isnan misoyaw, ya nganngani ay mailapo nan Sabfacho ay tengaw. ");
INSERT INTO lbk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nan fabfafai ay naifoweg ken Jesus ay nalpo id Galilea, inmonod cha ken Jose. Inilacha nan naikaofan Jesus ya nan inangnen Jose ay nangisaad isnan awakna. ");
INSERT INTO lbk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sa cha't sinmaa ay en nen-isakhana is fangfanglo ya sapsapo ay maiyappos isnan awak Jesus. Et nentengaw cha isnan Sabfacho tay siya nan nailenteg. ");
INSERT INTO lbk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Osto ay wiiwiit isnan Chomingkho, inyey nan fabfafai nan insakhanacha ay fangfanglo isnan kakaofan. ");
INSERT INTO lbk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ket ay inchanancha ay apchas naalin nan fato ay tangeb nan liyang ay naikaofan Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Sa cha't sinomkhep, ngem ket ay maid inchanancha isnan awak Apo Jesus. ");
INSERT INTO lbk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Osto ay cha cha mataa, ket ay nenkawawad-ay isnan sag-encha nan chwa ay lallalaki ay somili nan fachocha. ");
INSERT INTO lbk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sa cha't nenyongyong isnan fegyascha. Ngem kinwanin nan lallalaki ken chaicha, “En yo man an-anapen nan matatakho isnan kawad nan natey ay? ");
INSERT INTO lbk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maid siya isna, tay natakho et. Semkenyo man nan kinwanina ken chakayo issan sisya ay kawad-ayanyo id Galilea issan nangwaniyana en, ");
INSERT INTO lbk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Masapol ay maichowa ak ay Anak si Takho isnan fomafasol, ta ilansacha sak-en sak et kasin matakho isnan maikatlo ay akhew.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sinmekcha tet-ewa nan kinwanina, ");
INSERT INTO lbk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","sa cha't ala ya taynan isnan naikaofana ya tinmoli cha ay en nangifab-aag isnan sinpoo ya esang ay disipolos Jesus ya isnan tapina kayet. ");
INSERT INTO lbk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nan naycha'y fabfafai et chaicha cha Maria Magdalena, si Juana ya si Maria ay inan Santiago ya nan tapina kayet ay fabfafai ay fowegcha. Chaicha nan nangifaag isna isnan apostolesna. ");
INSERT INTO lbk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngem ya ket ay ad-icha patiyen chaicha tay kanancha mo aped yangkhay ap-apat nan kankanancha. ");
INSERT INTO lbk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nay met achi si Pedro, ala na ya tagtag is kaliyang ay naipay-ana, ket ay kedkecheng nan lopot ay naiyewes ken siya nan inoschongana ischi. Sa et sinmaa ay natataa isnan am-in ay cha inmat. ");
INSERT INTO lbk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Issan siya chi kannay ay akhew, cha enfaat nan chwa ay disipolos Jesus id Emaus, ay away nget sinpoo ya esang ay kilomitro nan kaadchawina mailapo id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Cha cha entot-oya maipoon isnan am-in ay cha inmat. ");
INSERT INTO lbk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Osto ay cha cha entot-oya ay en-og-okhod, sinmag-en si Jesus ay namoweg ken chaicha, ");
INSERT INTO lbk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ngem ke cha't ay kag nakimit tay egay cha naipalofos ay makaimaton ken siya. ");
INSERT INTO lbk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sa na't kanan, “Ngag man nan entot-otot-oyyanyo isnan cha yo manalanan?” Sa cha't nensasanga ay tinomke, ");
INSERT INTO lbk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ya kinwanin et nan esang ay enngachan is Cleofas en, “Away nget kecheng ka is mangili id Jerusalem ay ad-i mangammo isnan cha inmat ischi isnan nar-os ay akhew.” ");
INSERT INTO lbk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Ngag kay chachi?” kinwanina. “Nan man naangnen ken Jesus ay iNazaret,” kinwanicha. “Esang ay mamadto, ay makabfalin nan chonona ya nan sos-olona isnan sakhang Apo Dios ya nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ya ket ay aped inchowan nan aap-apon nan papachi ya nan kannay aap-apo ay nangipapatey ken siya, sa cha't inpailansa is kakolos. ");
INSERT INTO lbk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ngem siya pay nan namnamaenmi ay mensofot isnan Israel! Ngem faken yangkhay kecheng chachi ay inmat id etewna is naangnen. Tay olay idwani ay ikatlo et ay akhew, ");
INSERT INTO lbk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","wad-ay cha nan fabfafai ay fowegmi ay inmipataataa. Tay nawiiwiit cha isnan naikaofana, ");
INSERT INTO lbk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ngem maid inchanancha isnan awakna, sa cha't tinmoli ay nangifaag maipoon isnan nenpaila ken chaicha ay angheles ay nangwanin natakho et siya. ");
INSERT INTO lbk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Naneng cha't akhes ya eey nan tapina ay fowegmi isnan naikaofana, ya inilacha nan wad-ay ischi ay ostoosto ay kag isnan infaag nan fabfafai, ngem si Jesus, egaycha inila.” ");
INSERT INTO lbk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sa et kinwanin Jesus ken chaicha, “Chakayo ay ad-i ensemsemek, ya nalikhat ay mamati isnan am-in ay kinwanin nan mamadto! ");
INSERT INTO lbk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ad-i ngen masapol ona ay ilikhat Cristo nan naycha, sa et somkhep isnan kachad-ayawana?” ");
INSERT INTO lbk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sa et inlawlawag Jesus nan nakwani maipoon ken siya isnan am-in ay naisolat ay kalin Apo Dios mailapo isnan insolat Moises engkhana isnan insos-olat nan am-in ay mamadto. ");
INSERT INTO lbk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nganngani cha't ay omchan isnan omayancha ay ili, ngem madlawcha ay itoloy kayet Jesus ay omey isnan omayana. ");
INSERT INTO lbk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ngem inpakodcha ay nangwanin, “Makiiyan ka et achi ken chakami, tay nay nalonog et nan akhew ya cha et maschem.” Sa et sinomkhep ay nakiiyan ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Osto ay tinmokcho cha ay nangan, inalana nan tinapay ya nenyaman. Sa na't pinetpet-ang chi ya inchowana ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ya ke cha't inmatonan chadlo siya, tay inpailatakna nan pinang-ilacha, ngem ket ay apchas nenkamamaid. ");
INSERT INTO lbk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sa cha't kanan, “Da! Ta sa et mampet chadlo pomopoos nan liknata issan cha na nakikak-aliyan ken chaita is kachalan, ay nangilawlawakhana isnan naisolat ay kalin Apo Dios!” ");
INSERT INTO lbk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sa cha't nenligwat isnan chey kannay ay olas ay tinmoli id Jerusalem. Ya inchanancha nan sinpoo ya esang ay disipolos Jesus ya nan tapina kayet ay maam-among ");
INSERT INTO lbk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ay mangmangwanin, “Tet-ewa pet ay natakho nan Apo! Nenpaila ken Simon!” ");
INSERT INTO lbk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sa et inpalawag nan chwa ay cheycha nan inmat is kachalan, ya nan nangimatonancha ken siya issan nametpet-angana isnan tinapay. ");
INSERT INTO lbk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Osto ay cha cha og-okhochen chana, faagna ya ket wad-ay si Jesus ay tomatakcheg isnan kawadcha. Kinwanina, “Oompa kayo!” ");
INSERT INTO lbk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Natakag ya nafegyas cha, tay kananchan mo anito nan inilacha. ");
INSERT INTO lbk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ngem kinwanina ken chaicha, “En kayo man matatakag ay? Ya ngag man nan kasin yo semkesemken? ");
INSERT INTO lbk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilaenyo nan limak ya nan sikik, ta mangil-anyo ay sak-en kannay na. Egnanyo sak-en ta mangil-anyo. Tay nan anito, maid awak paymo ingitna ay ad-i kag ken sak-en ay iilaenyo.” ");
INSERT INTO lbk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Osto ay kinwanina chi, inpailana ken chaicha nan limana ya nan sikina. ");
INSERT INTO lbk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nay met achi eg-ay cha kayet namati, tay chachama nan layadcha ya nan taacha. Sa na't kanan, “Wad-ay ngen kanenyo isna?” ");
INSERT INTO lbk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sa cha't inmichowa ken siya is nachawis ay fangos. ");
INSERT INTO lbk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Inalana chi sa na't kinan isnan sakhangcha. ");
INSERT INTO lbk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sa na't kinwani ken chaicha en, “Naangnen idwani nan chadlos ko infagfakha ken chakayo issan chey, issan nangwaniyak en, ‘Am-in nan naisos-olat maipoon ken sak-en isnan lenteg Moises, ya nan akhes insolat nan cheycha'y mamadto, ya isnan Salmo, et masapol ay maangnen.’ ” ");
INSERT INTO lbk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sa na't linawlawwakhan nan semekcha ta maawatancha nan naisolat ay kalin Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kinwaninan, “Siya na nan naisolat: ‘Masapol ay enlikhat nan Cristo, ya matey, sa et fomangon kasin isnan etey isnan maikatlo ay akhew. ");
INSERT INTO lbk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ya ta maipalawag isnan am-iam-in ay ili, mailapo id Jerusalem, nan enfabfawiyan ya manokokhan isnan fasol ta mapakawan isnan ngachana.’ ");
INSERT INTO lbk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Chakayo nan tistikho isnacha. ");
INSERT INTO lbk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Et sak-en kannay nan at mangifaa isnan inkalin Ama ay pal-iyena ken chakayo. Ngem masapol ay sad-enyo siya id Jerusalem, engkhana ay chawatenyo nan kag yo mabfachowan isnan kamabfalin ay malpo id tongcho.” ");
INSERT INTO lbk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sa et inpangon Jesus chaicha isnan ilit nan ili ay Betania. Sa na't intakwad nan limana ay namindisyon ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ya issan cha na mamindisyonan ken chaicha, tinaynana't chaicha tay ket ay naala id chaya. ");
INSERT INTO lbk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sa cha't chinad-ayaw siya, ya tinmoli cha id Jerusalem ay chadlos nenlal-ayad. ");
INSERT INTO lbk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ya wad-awad-ay cha is kaTimplo ay nenchad-ayaw ken Apo Dios.");
INSERT INTO lbk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Issan laplapona ay egay nakhab-an nan lofong, sikhod ay wad-ay siya ay makwani en Kali. Wad-ay siya ken Apo Dios, ya siya et Dios. ");
INSERT INTO lbk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Et siya chi ay engkhana issan laplapona, wad-ay siya ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Naichalan ken siya nan nawad-ayan nan am-in. Siya, maid paat nawad-ay, mo egay naichalan ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Siya nan poon nan fiyag, ay maiyalig ay silaw si takho. ");
INSERT INTO lbk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Langlangan nan silaw nan follinget ya maid mabfalin nan follinget ay mangafak isnan silaw. ");
INSERT INTO lbk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wad-ay nan esa'y takho ay finaan Apo Dios ay enngachan is Juan. ");
INSERT INTO lbk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Siya nan inmali ay manistikho maipoon isnan makwani en silaw, ta am-in nan mannge et mamati cha. ");
INSERT INTO lbk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Faken siya nan chey makwani en silaw, mod-i ket inmali ay manistikho isnan silaw. ");
INSERT INTO lbk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nan tet-ewa ay silaw, siya nan manangkhew isnan semek nan waschin esa'y takho ya omal-ali isnan lofong. ");
INSERT INTO lbk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sikhod ay wad-ay siya isnan lofong, ya naichalan ken siya nan nakhab-an nan lofong, nay met achi maid namigfig ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Inmey isnan osto'y ilina ngem egay chinawat nan kailiyana. ");
INSERT INTO lbk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Isnan magtek am-in ay nanawat ya namati ken siya, et inchowana ken chaicha nan kafaelancha ay enfalin ay an-ak Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ya nan nenfalinancha ay an-ak Apo Dios, et faken kag isnan angnencha ay maiyanak isnan awak khapo isnan layad si sin-asawa ya semek nan lalaki, mod-i ket khapo isnan nemnem Apo Dios ay en Amacha. ");
INSERT INTO lbk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Siya akhes nan Kali ay nenfalin ay takho ya nakitee ken chatako. Inilami nan katangtangachana ay maifakhay ken siya ay es-esang ay Anak nan Ama id chaya. Wad-ay ken siya nan am-in ay kinagkhawis ya kinatet-ewa. ");
INSERT INTO lbk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Siya nan tinistikhowan Juan issan nangifogfokhawana ay mangwanin, “Siya san kinwanik ay omali ay maisokat ken sak-en ya entongcho is solit mo sak-en, tay sikhod chadlo ay wad-ay siya.” ");
INSERT INTO lbk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ya isnan chachama ay kinagkhawisna, et ad-i mangmangkhay nan ichod-owana ken chatako ay enkhawisan. ");
INSERT INTO lbk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tay nan lenteg ay inchowan Apo Dios ken chatako et naichalan ken Moises, ngem inpailana nan kinagkhawisna ya nan kinatet-ewana maichalan ken Jesu Cristo. ");
INSERT INTO lbk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maid nakaila ken Dios Ama mod-i yangkhay nan es-esang ay Anakna ay maitatakcho ken siya. Siya nan nangipaammo ken Amana. ");
INSERT INTO lbk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Siya na nan infaag Juan isnan cheycha'y papachi ya nan kafachangcha ay makwani en Levita, ay finaan nan aap-apon si Judio ay en mamoot ken Juan mo sino tet-ewa siya. ");
INSERT INTO lbk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Et egay inkhigkhinek Juan nan tet-ewa maipoon isnan awakna, mod-i ket inlatakna ay nangwanin, “Faken sak-en nan Cristo.” ");
INSERT INTO lbk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sa cha't inpoot ay nangwanin, “Ya sino ka mampet? Ay sik-a ngen nan mamadto ay si Elias?” “Faken ak!” insongfatna. “Sik-a ngen nan omali ay Mamadto?” Kinwanin kayet Juan, “Faken.” ");
INSERT INTO lbk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Inpootcha kayet ay nangwanin, “Ibfakham et achi ken chakami mo sino ka, ta wad-ay isfatmi isnan namaa ken chakami. Ngag nan kanam maipoon ken sik-a?” ");
INSERT INTO lbk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sa et kinwanin Juan, “Sak-en nan inpadton Isaias ay nangwanin, ‘Wad-ay isnan ponchag nan mangifogfokhaw ay mangwanin, “Enletkhenyo nan chalan nan Apo.” ’ ” ");
INSERT INTO lbk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sa et kinwanin nan cheycha'y finaan nan Fafariseo en, ");
INSERT INTO lbk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Mo faken ka pet si Cristo, paymo si Elias, paymo nan omali ay Mamadto, ya ke ka enfonyag mo?” ");
INSERT INTO lbk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sa et kinwanin Juan, “Sak-en, chanom yangkhay nan ifonyagko. Ngem wad-ay ken chakayo nan esang ay ad-iyo ammo. ");
INSERT INTO lbk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Siya nan at omonod ken sak-en, ngem ad-i ak chadlos maikali ay olay mamadfad yangkhay isnan taked nan pallokana.” ");
INSERT INTO lbk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Inmat am-in chana id Betania is apet falaan nan akhew nan wanga ay Jordan ay cha nenfonyakhan Juan. ");
INSERT INTO lbk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kawaksana, inilan Juan si Jesus ay omal-ali sa na't kanan, “Naay nan Korderon Apo Dios ay mangaan isnan fasol nan katakhotakho. ");
INSERT INTO lbk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Siya san chak kankanan ay omonod ken sak-en ya entongcho is solit mo sak-en, tay sikhod chadlo ay wad-ay siya. ");
INSERT INTO lbk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Olay pay sak-en, egayko akhes finigfig siya. Ngem nan khotok nan inmaliyak ay enfonyag isnan chanom, et ta ipaammok siya isnan iyIsrael.” ");
INSERT INTO lbk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Infaag kayet Juan nan chadlos na inila, “Inilak nan Ispirito Santo ay kag kalopati ay cha khomwab ay nalpo id chaya. Sa et nentee ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Sak-en, sisya'y egayko finigfig siya issan lapona. Nay met achi si Apo Dios ay namaa ken sak-en ay en mangifonyag isnan chanom, et kinwanina ken sak-en, ‘Nan ilaem ay khomwafan ya entey-an nan Ispirito Santo, et siya nan mangifonyag isnan Ispirito Santo.’ ");
INSERT INTO lbk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tet-ewa, inilak ya tistikhowak ay siya nan Anak Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Issan kawaksana, wad-ay kasin cha Juan ya nan chwa'y disipolosna, ");
INSERT INTO lbk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ya inilana si Jesus ay lomal-aos, sa na't kanan en, “Ilaenyo, cheey nan Korderon Apo Dios!” ");
INSERT INTO lbk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Issan nanngelan nan chey chwa'y disipolosna isnan kinwanina, inmey cha ay maifoweg ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nensakhong si Jesus ya inilana chaicha ay cha omon-onod. Sa na't kanan, “Wad-ay ngen masapolyo?” “Rabbi, ento pay nan entetey-am?” insongfatcha. (Nan ayen nan Rabbi isnan kalin si Judio, et Mistolo.) ");
INSERT INTO lbk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Omali kayo ta ilaenyo,” kinwanin Jesus. Naifoweg cha't ken siya ya inilacha nan entetey-ana, sa cha't nakiiyan ken siya tay away nget alas kwatro chi. ");
INSERT INTO lbk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si Andres ay akhin Simon Pedro nan esang ken chaicha ay chwa ay nannge isnan kinwanin Juan sa cha't naifoweg ken Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nan inmona ay inangnena, et inmey ay en manganap ken Simon ay akhina ya kinwanina ken siya en, “Inchananmi et nan Mesias!” (Nan laychen nan Mesias ay kanan et Cristo.) ");
INSERT INTO lbk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sa na't infoweg si Simon ken Jesus. Insisin-eng Jesus si Simon sa na't kanan, “Sik-a si Simon ay anak Juan. At makwani ka en Cefas.” (En-iso nan ayen nan ngachan ay Pedro ya Cefas. Nan laychencha ay kanan et fato.) ");
INSERT INTO lbk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Issan kawaksana, sinmek Jesus ay enpaGalilea. Sa na't inila si Felipe, ya kinwaninan, “Maifoweg ka ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe ay nay et ib-an cha Andres ken Pedro ay iBetsaida. ");
INSERT INTO lbk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Idwani, en inanap Felipe si Natanael, sa na't kanan, “Inchananmi et san takho ay kankanan Moises isnan lenteg, ya san akhes insolat san cheycha'y mamadto ay at omali. Siya si Jesus ay iNazaret ay anak Jose.” ");
INSERT INTO lbk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Sa et kinwanin Natanael, “Siya pet! Ay ke wad-ay khawis ay malpo id Nazaret?” “Omali ka achi ta ilaem,” kinwanin Felipe. ");
INSERT INTO lbk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Issan nangil-an Jesus ken Natanael ay omal-ali, kinwanina, “Naay nan tet-ewa ay iyIsrael. Maid paat sikapna!” ");
INSERT INTO lbk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Sa et kinwanin Natanael ken siya, “Ngag nan nangammowam isnan katatakhok?” “Inilak sik-a is kapoon nan kaew ay higos issan sisya'y egay nangayakhan Felipe ken sik-a,” insongfat Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Sefat et Natanael ay nangwanin, “Apo, sik-a nan Anak Apo Dios! Sik-a nan Alin nan Israel!” ");
INSERT INTO lbk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","“Mamati ka tay kinwanik en inilak sik-a is kapoon nan kaew ay higos, ad-i ngen? At chakchakchake kayet nan ilaem ay katataa mo nan nay!” ");
INSERT INTO lbk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Intoptop kayet Jesus ay nangwanin, “Tet-ewa kanak ken chakayo, at ilaenyo nan chaya ay matekwafan, ya nan angheles Apo Dios ay cha tomongcho ya cha khomwab ken sak-en ay Anak si Takho.” ");
INSERT INTO lbk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Issan maikatlo ay akhew wad-ay nan kasar id Cana ay sakop nan Galilea, ya wad-ay si inan Jesus ischi. ");
INSERT INTO lbk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Olay akhes si Jesus ya nan disipolosna et naayakhan cha. ");
INSERT INTO lbk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Idwani, issan nangkhayan nan fayas, ket ay inmey si inan Jesus ken siya ay nangwanin, “Maid et fayascha.” ");
INSERT INTO lbk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ya ket kinwanin Jesus, “Ina, ogkhayem yangkhay sak-en. Sisya'y egay inmali nan timpok.” ");
INSERT INTO lbk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sa et kinwanin inana isnan cheycha'y faa, “Angnenyo nan ngag sisa ay ifaagna.” ");
INSERT INTO lbk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Idwani, wad-ay ischi nan kasaasaad ay enem ay fornay ay nakhaeb isnan fato ay maipaypay-an nan chanom, ya lima paymo enem ay lata nan malaon nan esang. Siya sa tay wad-ay nan ekhad nan Judio ay en-owas ay mangaan isnan afigcha. ");
INSERT INTO lbk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kinwanin et Jesus ken chaicha, “Ponnenyo nan sanacha ay fornay is chanom.” Osto ay pinnopinnocha chachi, ");
INSERT INTO lbk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","kinwanina't ken chaicha, “Komiyod kayo ta iyeyyo isnan cha ennongnong isnan kasar.” Sa cha't inyey. ");
INSERT INTO lbk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Osto'y linamanan nan cha ennongnong isnan kasar nan chey ay chanom ke pet fayas, sa na't nen-ipaayag nan kaab-afong ay lalaki. Ad-i ammon nan chey cha ennongnong nan nalpowan nan chey ay fayas, tay kecheng nan cheycha'y faa ay nangiyod isnan chanom nan mangammo ischi. ");
INSERT INTO lbk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Sa na't kinwani en, “Am-in ay takho, ipafalacha ona nan kakhawisan ay fayas. Sa et mo inminoinom cha't nan takho, ifalacha nan tapina. Ngem sik-a iniigtom pet nan kakhawisan ay fayas engkhana idwani.” ");
INSERT INTO lbk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Inangnen Jesus na id Cana ay sakop nan Galilea. Siya na nan inmona ay katataa ay inangnena ay sinyal ay nangilatak isnan katangtangachana, ya onanig namati nan disipolosna ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Osto'y nakwas chi, khinomwab cha Jesus id Capernaum. Naifoweg ken siya cha inana, nan aag-ina ya nan cheycha'y disipolosna, sa cha't natanee ischi is sin-ak-itan ay akhew. ");
INSERT INTO lbk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Isnan nganngani et nan Piyastan si Judio ay makwanin Paskua, nanikid si Jesus id Jerusalem. ");
INSERT INTO lbk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Issan inmayana is kaTimplo, inaspowana't nan cheycha'y enlaklako is faka, karnilo ya kalopati, ya nan cheycha'y tomotokcho ay ensoksokat isnan siping. ");
INSERT INTO lbk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sa et inmapid siya is tali ay khinaebna is faigna ay nanyog am-in ken chaicha, am-in nan cheycha'y faka ya karnilocha, et nasyog cha am-in ay finmala is kaTimplo. Nen-itokangna nan lamisaan nan cheycha'y ensoksokat si siping, ya nenpaappokena nan kasis-isis-ilyocha. ");
INSERT INTO lbk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sa na't yinangyangan nan cheycha'y en-ilaklako isnan kalopati ay nangwanin, “Pabfalaenyo chasa. Ad-iyo khab-en ay enkomersowan nan afong Ama!” ");
INSERT INTO lbk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ket ay sinmek nan cheycha'y disipolosna san naisolat ay kalin Apo Dios ay nangwanin, “Apo Dios, chadlos ko ikateyan nan mangipatkhak isnan afongmo.” ");
INSERT INTO lbk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sa et inmey nan cheycha'y aap-apon si Judio ken Jesus ay nangwanin, “Ngag nan ipailam ay katataa ay kaimatonam ay wad-ay kalebfengam ay mangangnen issacha?” ");
INSERT INTO lbk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kinwanin et Jesus ken chaicha, “Etfenyo nan nay ay Timplo, ya at patakchekhek isnan las-od nan tolo ay akhew.” ");
INSERT INTO lbk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Ento nan ikkam ay mangipatakcheg isnan nay ay Timplo isnan tolo ay akhew yangkhay? Epat poo ya enem ay tawen nan nakhab-ana ya!” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngem nan laychen Jesus ay kanan isnan kinwanina ay Timplo et nan awakna kannay. ");
INSERT INTO lbk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Isonga issan natakhowana kasin isnan etey, sinmek nan disipolosna nan chey ay kinwanina. Ya onanig cha namati isnan kalin Apo Dios ya nan infab-aag Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Idwani, issan kawad-an Jesus id Jerusalem isnan Piyasta ay makwanin Paskua, angsan nan namati ken siya issan nangil-ancha isnan katataa ay sinyal ay inang-angnena. ");
INSERT INTO lbk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Olay mo siya chi, ngem khechangna'y egay intalek Jesus nan awakna ken chaicha, tay ammona nan semek nan am-in ay takho. ");
INSERT INTO lbk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ad-ina masapol nan mangifag-an nan olay sino ken siya maipoon isnan takho, tay siya kannay et ammona nan semekcha. ");
INSERT INTO lbk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wad-ay nan esa'y Fariseo ay nenngachan si Nicodemo ay ap-apon si Judio. ");
INSERT INTO lbk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Isnan esa'y lafi inmey ken Jesus ya kinwanina ken siya, “Apo, ammomi ay sik-a nan mistolo ay nalpo ken Apo Dios. Maid makaikkan issacha ay katataa ay sinyal ay cham ang-angnen, mo maid si Apo Dios ken siya.” ");
INSERT INTO lbk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ya ket kinwanin Jesus, “Tet-ewa kanak ken sik-a, sok-ed chadlo ona maiyanak kasin nan takho, esa maitapi isnan en-ap-apowan Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pinoot et Nicodemo ay nangwanin, “Ento pan nan angnen nan takho ay maiyanak kasin mo apchas et nalakay? Ay ke mamidwa ay iliton inana ta kasin maiyanak?” ");
INSERT INTO lbk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kanan et Jesus, “Tet-ewa kanak ken sik-a, sok-ed maiyanak ona nan takho isnan chanom ya isnan Ispirito Santo esa makaskhep isnan en-ap-apowan Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nan maiyanak isnan takho, wanchena nan okhalin nan takho. Nay met achi nan maiyanak isnan Ispirito Santo, wanchena akhes nan okhalin nan Ispirito Santo. ");
INSERT INTO lbk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ad-i ka mataa isnan mangwaniyak en, ‘Masapol ay maiyanak kayo kasin.’ ");
INSERT INTO lbk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Maiyalig isnan chakhem nan Ispirito Santo. Isyangkhay nan chawsen nan chakhem. Makadnge ka isnan awengna, ngem ad-im ammo nan malpowana ya nan omayana. Siya akhes ay ad-i chadlos maawatan nan maiyanakan nan olay sino isnan Ispirito Santo.” ");
INSERT INTO lbk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sa et kinwanin Nicodemo, “Ento kay nan ikakkan nan sana ay maangnen?” ");
INSERT INTO lbk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","“Na! Sik-a nan mapatpateg ay Mistolon nan Israel, ya ad-im maawatan chana? ");
INSERT INTO lbk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tet-ewa kanak ken sik-a, kananmi nan ammomi ya ifaagmi nan inilami, ngem khechangna ay ad-iyo chawaten nan kananmi. ");
INSERT INTO lbk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mo siya sa ay ad-iyo patiyen nan ifab-aagko ay wad-ay isnan kalotaan, ngag pet nan katekena mo ifaagko nan maipoon isnan wad-ay id chaya? ");
INSERT INTO lbk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maid paat linmamag ay nangila id chaya, mod-i yangkhay sak-en ay Anak si Takho ay nalpo ischi ya khinomwab isna is kalota. ");
INSERT INTO lbk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Nan akhes maangnen ken sak-en et kag isnan nangipatongchowan Moises isnan khinaebna ay kag oweg is kakaew issan kawadcha is kaponchag. Masapol ay maipatongcho ak akhes ay Anak si Takho, ");
INSERT INTO lbk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ta nan olay sino ay mamati ken sak-en, et wad-ay fiyagcha is eng-engkhana.” ");
INSERT INTO lbk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tay chachama nan layad Apo Dios isnan takho isnan lofong, inchawchawna nan es-esang ay Anakna, ta olay sino ay mamati ken siya, et ad-i madchongaw mod-i ket wad-ay fiyagna is eng-engkhana. ");
INSERT INTO lbk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tay egay finaan Apo Dios nan Anakna isnan lofong ta okomena ay manosa isnan takho, mod-i ket ta isalakana chaicha. ");
INSERT INTO lbk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ad-i maokom ay machosa nan takho ay mamati ken siya. Ngem nan ad-i mamati ken siya et apchas naokom ay machosa, tay ad-i mamati isnan es-esang ay Anak Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Adi kad siya na nan kaokomancha, tay inmali et isnan lofong nan manangkhew koma isnan semekcha, nay met achi nan follinget nan wadwad-ayencha mo nan matangkhewancha, tay ngaag nan ang-angnencha. ");
INSERT INTO lbk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tay olay sino ay ngaag nan ik-ikkana, et ad-ina laychen ay masilawan nan semekna, ya ad-i somag-en isnan silaw tay ta ket lang maipaila nan ngaag ay ang-angnena. ");
INSERT INTO lbk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngem nan takho ay mangangnen isnan tet-ewa, et somag-en isnan silaw ta mailatak ay si Apo Dios nan mangis-ischo isnan ik-ikkana. ");
INSERT INTO lbk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Awni sa et inmey cha Jesus ya nan disipolosna isnan probinsiya ay Judea. Nanatee cha Jesus ischi ay cha enfonyag. ");
INSERT INTO lbk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Juan akhes, et wad-ay ay cha enfonyag id Enon ay sag-en nan Salim, tay ad-acha nan chanom ischi. Et cha na finonyakhan nan cheycha'y inmey ay nenpafonyag ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tay sisya'y egay naifalod siya ischi. ");
INSERT INTO lbk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Osto'y siya chi, nasosma nan cheycha'y disipolos Juan ya nan esa'y Judio maipoon isnan fonyag. ");
INSERT INTO lbk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sa cha't inmey ken Juan ya kinwanicha, “Apo, sesemkem ngen nan chey kadwam is chemangna isnan wanga ay Jordan ay siya san tinistikhowam? Wad-ay siya ay cha enfonyag idwani, et chey, siya nan cha omayan am-in nan takho.” ");
INSERT INTO lbk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kinwanin et Juan, “Maid kafallinan nan takho isnan olay ngag issa, mo ad-i ona ichowan Apo Dios ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ad-i ngen chakayo kannay san chadlos nanannge issan kinwanik ay faken sak-en nan Cristo, mod-i ket nafaa ak yangkhay ay mamangpango? ");
INSERT INTO lbk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Iyaligko nan awakko isnan aloyos nan omafong ay lalaki. Tay nan aloyos nan omafong, olay mo faken siya nan mangasawa isnan fafai, chachama nan layadna ay man-ed isnan omaliyan nan omafong, ya mo chengngena nan kalina, enlal-ayad. Siya akhes ay chachama nan layadko idwani. ");
INSERT INTO lbk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Masapol ay tomongtongcho siya ya khomkhomwab ak,” kinwanin Juan. ");
INSERT INTO lbk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nan malpo id tongcho, entongcho siya isnan am-in. Nan akhes takho ay fakinlolota, et nailotaan nan katatakhona ya nan wad-ay yangkhay isnan lofong nan ap-apatena. Ngem nan malpo id chaya et siya nan entongcho isnan am-in, ");
INSERT INTO lbk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ya tistikhowana nan chadlos na inila ya chinnge ischi, nay met achi maid manawat isnan ifab-aagna. ");
INSERT INTO lbk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mo sino magtek nan manawat isnan ifaagna, et ipailana ay tet-ewa si Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tay si Jesus ay finaan Apo Dios, et ifaagna nan kalin Apo Dios, ya ad-i kakonto nan angnen Apo Dios ay mangigwa isnan Ispirito Santo ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Chadlos laylaychen Dios Ama nan Anakna, ya inpeyna siya ay enlebfeng isnan am-in. ");
INSERT INTO lbk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mo sino nan mamati isnan Anakna, wad-ay ken siya nan fiyag ay maid pengpengna. Nay met achi nan mangad-i isnan Anakna, ad-i maitapi isnan fiyag ay maid pengpengna, mod-i ket sisyasisya nan songet Apo Dios ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nan Fafariseo, chinngecha ay angsan nan somos-olot ya cha enpafonyag ken Jesus mo ken Juan. ");
INSERT INTO lbk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nan magtek tet-ewa et faken si Jesus nan cha enfonyag mod-i ket nan disipolosna. ");
INSERT INTO lbk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Osto ay chinngen Jesus ay inammowancha chi, kinmaan id Judea ya tinmoli id Galilea. ");
INSERT INTO lbk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sa et nenpaSamaria tay masapol ay ischi nan ikwana. ");
INSERT INTO lbk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Issan cha cha omayan, sinmag-en cha id Sicar, ay esa'y ili id Samaria ay sag-en nan lota ay inpatawid Jacob ken Jose ay anakna. ");
INSERT INTO lbk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ischi nan kawad nan fofon ay makwanin fofon Jacob. Inmilleng si Jesus is kasag-en nan chey ay fofon, tay nablay isnan nenfaatana, ya away alas chosi chi. ");
INSERT INTO lbk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Sa et inmey nan disipolosna isnan chey ay ili ay en lomako is kanencha. Awni ya ket ay wad-ay nan fafai ay iSamaria ay en manakcho. Sa et kinwanin Jesus, “Omagtan ka ed is inomek.” ");
INSERT INTO lbk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sa et kanan nan fafai, “Ya ke ka lang Judio, ya komchaw ka ken sak-en ay fafai ya iSamaria akhes, is inomem ay?” (Kinwanina chi tay ad-i ib-aen nan Judio nan iSamaria.) ");
INSERT INTO lbk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sinmongfat si Jesus ay nangwanin, “Mo sa yangkhay ammom nan ilayad Apo Dios, ya mo sino nan cha komchaw ken sik-a is inomena, at komchaw ka ya agtana sik-a isnan tomakho ay chanom.” ");
INSERT INTO lbk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sa et kinwanin nan fafai, “Apo, ya ke maid isakchom ya sa et ad-achaem nan kawad nan chanom. Ento nan aped mo omalaan isnan chey ay tomakho ay chanom? ");
INSERT INTO lbk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Si ama tako ay Jacob nan nangipatawid isnan nay ay fofon ken chakami. Siya pay na nan inmin-inomana ya nan an-akna, sa et nan angsan ay enkiwiyena. Ay ke wad-ay kafaelam mo siya?” ");
INSERT INTO lbk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kinwanin et Jesus, “Olay sino ay ominom isnan nay ay chanom et kasin maew-ew, ");
INSERT INTO lbk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ngem nan ominom isnan ichawchawko ay chanom et ad-i paat kaew-ew. Nan chanom ay ichawchawko ken siya, et enfalin ay eb-eb isnan awakna ay mangichawchaw isnan fiyag ay maid pengpengna.” ");
INSERT INTO lbk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sa et kinwanin nan fafai, “Apo, ichowam man ed ken sak-en nan chey ay chanom, ta ad-i ak kasin maew-ew-ew, paymo omaliali ay manakcho isna.” ");
INSERT INTO lbk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Engka, ayakhan si asawam ta omali kayo,” kinwanin Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Maid asawak,” kinwanin nan fafai. Sa et kanan Jesus, “Tet-ewa nan kanam en maid asawam, ");
INSERT INTO lbk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tay lima kay man nan cham inas-asawa, ya nan maiyaamongam idwani et faken mo osto'y asawa. Tet-ewa nan kinwanim.” ");
INSERT INTO lbk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ya ket kinwanin nan chey fafai, “Apo, maawatak ay mamadto ka pet. ");
INSERT INTO lbk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chakami ay iSamaria, is kafilig ay nay nan enchad-ayawan nan am-ami ken Apo Dios, ngem chakayo ay Judio kananyo ay id Jerusalem nan osto chadlo ay enchayawan ken Apo Dios.” ");
INSERT INTO lbk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sa et kanan Jesus, “Anen, patiyem nan nay ay kanak. Nay cha et omchan nan akhew ay at faken isnan nay ay filig paymo id Jerusalem nan menchayawan nan takho ken Dios Ama. ");
INSERT INTO lbk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Chakayo ay iSamaria, ad-iyo ammo nan chad-ayawenyo. Chakami, ammomi nan chad-ayawenmi, tay malpo ken chakami ay Judio nan kaisalakan. ");
INSERT INTO lbk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ngem nay cha omali nan timpo ya wad-ay et idwani, ay nan takho ay tet-ewa ay manad-ayaw ken Ama, et chayawencha siya isnan osto ay semekcha ay maiyornos ken siya. Siya sa nan laychen Ama ay angnen nan takho ay menchayaw ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Si Apo Dios, et Ispirito. Tay siya chi, et nan angnen nan takho ay menchayaw ken siya, et masapol ay maiyornos nan am-in ay semekcha isnan kinatet-ewan Apo Dios,” kinwanina. ");
INSERT INTO lbk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sa et kinwanin nan fafai, “Ammok ay awni't omali nan Mesias ay makwani en Cristo. Ya mo omali, at ipaammona nan am-in ken chatako.” ");
INSERT INTO lbk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ket ay kinwanin Jesus, “Sak-en ay makikak-ali kannay ken sik-a nan kankanam.” ");
INSERT INTO lbk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Osto ay siya chi, tinmoli cha nan disipolos Jesus. Ya ket nataa cha issan nangedchanancha ken Jesus ay cha makitot-oya isnan fafai. Ngem maid namoot ay nangwanin, “Ngag nan masapolmo?” Ya maid akhes nanalodsod ken Jesus mo ngag nan khotok nan cha na makitot-oyyan isnan fafai. ");
INSERT INTO lbk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sa et tinaynan nan fafai nan fangana, ya sinmaa ay en nangifaag isnan kakailiyana, ");
INSERT INTO lbk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Omali kayo ed ta ilaenyo nan chey takho ay nangifaag ken sak-en isnan am-in ay inik-ikkak. Siya mangnget chi nan Cristo?” ");
INSERT INTO lbk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sa cha't naligwat isnan ilicha ay inmey isnan kad-an Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nan akhes disipolos Jesus, inawiawischa siya ay mangwanin, “Apo, ali ka't man ta mangan ka.” ");
INSERT INTO lbk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngem kinwanin Jesus, “Wad-ay nan kanek ay ad-iyo ammo.” ");
INSERT INTO lbk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ket ay natotya nan cheycha'y disipolosna ay mangwanin, “Wad-ay ngen inomyali is kanena?” ");
INSERT INTO lbk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sa et kanan Jesus, “Nan kang-epak, siya nan mangiyangnenak isnan nemnem nan finmaa, engkhana ay konfosek nan am-in ay inpadnona ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ad-i ngen wad-ay nan kananyo en, ‘Wad-ay nan epat kayet ay fowan sa et ani’? Kanak magtek, ani et ya! Enmonaang kayo achi ta ilaenyo nan katakhotakho ay maiyalig isnan pakhey ket ay lektat ay nagkhasan ya mabfalin et ay maani. ");
INSERT INTO lbk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Adi kad nan omey en-ani, cha malagfo, ya nan takho ay kag na cha aniyen et maitapi cha isnan fiyag ay maid pengpengna. Siya chi tatno makhigsan nan en-imola ya nan en-ani ay malaylaychan. ");
INSERT INTO lbk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tay tet-ewa nan nakwani en, ‘Esang nan enmola ya teken nan en-ani.’ ");
INSERT INTO lbk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Finaak chakayo ay en men-ani isnan egayyo chadlos nenfellayan. Teken nan nanno ya chakayo nan mangani isnan fongan nan felaycha.” ");
INSERT INTO lbk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Angsan cha nan iSamaria ay namati ken Jesus isnan chey ay ili khapo isnan nangifag-an san fafai en, “Infaagna ken sak-en nan am-in ay inik-ikkak.” ");
INSERT INTO lbk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tay siya chi, issan inmayancha ken Jesus inpakodcha siya ta makitee ken chaicha. Adi kad natanee ken chaicha is chwa ay akhew. ");
INSERT INTO lbk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ya inmang-angsan kayet nan namati ken siya khapo isnan insos-olona. ");
INSERT INTO lbk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sa cha't kinwani isnan fafai, “Mamati kami chadlo idwani faken yangkhay khapo isnan kinwanim, mod-i ket tay chadlos mi chinnge siya, ya ammomi ay siya pet tet-ewa nan mangisalak isnan katakhotakho isnan lofong.” ");
INSERT INTO lbk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kakwasan nan chwa ay akhew nenpaGalilea si Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Wad-ay san kinwanin Jesus issan chey ay ad-i maipateg nan mamadto isnan chadlos ilina.) ");
INSERT INTO lbk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Issan magtek inomchanana id Galilea, ke cha't ay nalaylaychan ken siya, tay inilacha nan am-in ay inang-angnena id Jerusalem issan Piyasta ay Paskua, tay inmey cha akhes ay nakipiyasta. ");
INSERT INTO lbk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kasin inmey cha Jesus id Cana ay sakop nan Galilea, ay nangipafalinana isnan chanom is fayas. Idwani, wad-ay id Capernaum nan esa'y okom ay masasakit nan fab-alona. ");
INSERT INTO lbk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chinngena ay inmali si Jesus ay nalpo id Judea ya wad-ay et id Galilea, sa et inmey ay nenseg-ang ay mangayag ken Jesus ta khomwab ay en mangipagkhawis isnan anakna ay matmatey. ");
INSERT INTO lbk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tay siya chi kinwanin Jesus ken siya, “Sok-ed pet ona wad-ay ilaenyo is sinyal ya nan omipataa esa kayo mamati!” ");
INSERT INTO lbk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kinwanin kayet nan okom, “Apo, pangngaasim ta omey ta't tay ta ket lang matey nan anakko.” ");
INSERT INTO lbk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ya ket ay kinwanin Jesus en, “Somaa ka tay matakho nan anakmo.” Pinatin nan okom nan kinwanin Jesus ya sinmaa. ");
INSERT INTO lbk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Et issan cha na pomannachan, sana cha't nan faana ay mangwanin, “Khinmawis nan fab-alom.” ");
INSERT INTO lbk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Adi kad sinalodsodna mo ngag ay olas nan nangilapowana ay khinmawis. Sa cha't kanan, “Ala ona id kogkha nan nabfaewan nan pochotna.” ");
INSERT INTO lbk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ya ket sinmek amana ay siya chi kannay san olas ay nangwaniyan Jesus en, “Matakho nan anakmo.” Sa et namati, ya olay nan am-in ay pangafongna. ");
INSERT INTO lbk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Siya na nan ikadwa ay katataa ay inangnen Jesus ay kaimatonana issan inmayana id Galilea ay nalpo id Judea. ");
INSERT INTO lbk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Awni ya ket wad-ay nan piyastacha ay Judio id Jerusalem, et nanikid si Jesus ay en nakipiyasta. ");
INSERT INTO lbk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kakwasan nan mankhepan isnan makwanin Segpan si Karnilo id Jerusalem, wad-ay nan posposong ay om-ommesan. Betsata nan ngachan nan posposong isnan kalin si Judio. Ya wad-ay nan lima ay malilwes ay enpap-aingan, ");
INSERT INTO lbk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ay oomfekhan nan angsan ay nenkasakew, nenkakimit, nenkapilay ya nan ad-i makagkhiwa, (tay sadsad-encha nan enkhiwwan nan chanom. ");
INSERT INTO lbk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tay mammamingsan yangkhay ay khomwab is kaposong nan anghel nan Apo ay en mangipagkhiwa isnan chanom. Et nan masasakit ay mang-ona ay omey is kadchanom kakwasan nan enkhiwwana, et khomawis nan am-in ay sakitna.) ");
INSERT INTO lbk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Idwani, wad-ay ischi nan esa'y lalaki ay nasasakit is tolon poo ya walo ay tawen. ");
INSERT INTO lbk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Issan nangil-an Jesus ken siya, ya inammowana ay inmannong ay apegket naiwawangcha ischi, ke na't kanan ken siya, “Ay laychem ay khomawis?” ");
INSERT INTO lbk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sinmongfat nan chey masakit ay nangwanin, “Apo, maid man chadlo ib-ak is fomachang ay mangippey ken sak-en is kaposposong mo enkhiwa nan chanom. Mo cha ak omey, ket ay wad-ay nan apchas pinmanad.” ");
INSERT INTO lbk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kinwanin et Jesus ken siya, “Maligwat ka, alaem nan aplagmo ta manalan ka.” ");
INSERT INTO lbk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Faagna ya ket khinmawis san lalaki, sa na't inala nan aplagna ya nanalan. Adi kad, tay Sabfacho chi ay tengaw, ");
INSERT INTO lbk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","kinwanin et nan aap-apon si Judio isnan lalaki ay naipagkhawis, “Anen, Sabfacho ya! Lawa pay isnan lenteg nan mangawwitam isnan aplagmo.” ");
INSERT INTO lbk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ke na't kanan, “Ngem kanan met nan takho'y inmipagkhawis en alaek nan aplagko ta manalan ak.” ");
INSERT INTO lbk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Sino nan nangwanin alaem nan aplagmo ta manalan ka?” kinwanicha. ");
INSERT INTO lbk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nay met achi ad-i ammon san lalaki mo sino san nangipagkhawis ken siya, tay angsaangsan nan takho ischi ya apchas namaid si Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aw-awni ya ket inchanan Jesus san lalaki is kaTimplo, sa na't kanan, “Ilaem, twa et khinmawis ka! Chokokham nan fasol, ta maid am-am-amed sikhab is maangnen ken sik-a.” ");
INSERT INTO lbk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Inmey et san lalaki ay en nangifaag isnan aap-apon si Judio ay si pet Jesus nan nangipagkhawis ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Midkakay et chi is mangapoaposan nan aap-apon si Judio ken Jesus, tay inangnena chi isnan Sabfacho. ");
INSERT INTO lbk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngem kinwanin Jesus ken chaicha, “Olay ngag ay akhew et enchono si Ama ya siya akhes ken sak-en.” ");
INSERT INTO lbk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Isnan nay ay kinwanina, onanig inmanap nan cheycha'y aap-apon si Judio is ikkancha ay mamatey ken siya. Tay faken yangkhay nan ad-ina somolotan isnan ekhad sinan Sabfacho nan menliligtancha ken siya, mod-i ket tay kananchan ikiskis-ona nan awakna ken Apo Dios isnan mangwaniyana en chadlos na Ama si Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tay siya chi kinwanin Jesus ken chaicha, “Tet-ewa kanak ken chakayo, ad-i mabfalin ay aped ko angnen ay Anak nan malpo isnan semekko, mod-i yangkhay nan ilaek ay ang-angnen Ama. Mo ngag nan angnen Ama, siya akhes chi nan angnek ay Anakna, ");
INSERT INTO lbk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","tay chadlos chachama nan layad Ama ken sak-en ay Anakna, ya ischona ken sak-en nan am-in ay ang-angnena. Ya wadwad-ay kayet ay katataa ay chono mo nan naycha nan at ischona ay angnek, ya at mataataa kayo. ");
INSERT INTO lbk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kag nan menfangonan Ama isnan natey, ay mangagtanana ken chaicha isnan fiyag, siya akhes ken sak-en ay Anakna, agtak si fiyag nan olay sino sisa ay laychek ay agtan. ");
INSERT INTO lbk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Maid akhes okomen Dios Ama, mod-i ket inchawchawna ken sak-en ay Anakna nan am-in ay kalebfengak ay en-okom, ");
INSERT INTO lbk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ta chayawen am-in nan takho sak-en, ay kag isnan pinangchayawcha ken Ama. Nan ad-i menchayaw ken sak-en, ad-ina akhes chayawen si Ama ay finmaa. ");
INSERT INTO lbk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tet-ewa kanak ken chakayo, nan mannge isnan kalik ya mamati isnan namaa ken sak-en, et wad-ay fiyagna ay maid pengpengna. Ya ad-i maokom ay machosa, tay apchas naikasiw isnan kadchosaana, ta enfiyag is engkhana. ");
INSERT INTO lbk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tet-ewa kanak ken chakayo, nay cha omali nan timpo ya wad-ay et idwani, ay nan cheycha'y kag natey et chengngencha nan kalik ay Anak Apo Dios. Ya mo sino nan mannge, et enfiyag cha. ");
INSERT INTO lbk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tay si Apo Dios nan poon si fiyag, inpeyna akhes sak-en ay Anak is poon si fiyag. ");
INSERT INTO lbk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Et tay sak-en nan Anak si Takho, inchowana kayet ken sak-en nan kalebfengak ay mangokom isnan takho. ");
INSERT INTO lbk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ad-i kayo mataa isnan kinwanik, tay awni't omali nan timpo ay am-in ay natey et chengngencha nan kalik, ");
INSERT INTO lbk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ya fomala cha isnan naikaofancha. Nan cheycha'y khawis nan inang-angnencha, at fomangon cha ay matakho is engkhana ken Apo Dios. Ya nan ngaag nan inang-angnencha, fomangon cha ay maokom ya machosa,” kinwanin Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kinwanin kayet Jesus, “Ad-i mabfalin ay aped ko angnen nan malpo isnan semekko, tay mo ngag nan isolon Ama, siya nan ikkak ay mangokom isnan takho. Et nalenteg nan angnek ay en-okom, tay faken nan nemnemko is laychek ay angnen, mod-i ket nan nemnem nan namaa ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tay maid filangna mo sak-en kannay nan manistikho isnan awakko, ");
INSERT INTO lbk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","nay met achi wad-ay akhes si Ama ay manistikho maipoon ken sak-en, ya ammok ay tet-ewa nan kanana. ");
INSERT INTO lbk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Wad-ay cha nan finaayo ay inmey ken Juan, et si Juan, infaagna nan tet-ewa maipoon ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ad-ik kanan en masapol ko nan takho ay manistikho ken sak-en. Ipasmekko magtek yangkhay nan infaagna ta kaisalakanyo. ");
INSERT INTO lbk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan san kag napaskhechan ay silaw ay enlalanglang, ya nanang-ep kayo isnan sin-ak-itan ay nangilal-ayad isnan nangilawlawakhana ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngem wadwad-ay nan chadlos mangitakcheg ken sak-en mo nan tinmistikhowan Juan. Siya chachi nan katataa ay chak angnen. Siya nan inpadnon Ama ken sak-en ay mangitet-ewa ay finaana sak-en. ");
INSERT INTO lbk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Et si kannay Ama ay namaa ken sak-en, siya nan tomistikho. Nay pay ya egayyo paat chinnge nan kalina paymo finoya nan ilana, ");
INSERT INTO lbk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ya ad-i entee nan kalina isnan semekyo tay ad-iyo patiyen sak-en ay finaana. ");
INSERT INTO lbk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aped yo poopooten nan naisolat ay kalin Apo Dios, tay kananyo en edchananyo ischi nan fiyag ay maid pengpengna. Ngem sak-en nan kankanan nan fasfasaenyo! ");
INSERT INTO lbk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nay met achi ad-iyo laychen ay omali ken sak-en ta mampay matakho kayo is engkhana. ");
INSERT INTO lbk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Faken nan kaidchayawak isnan takho nan an-anapek, ");
INSERT INTO lbk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ngem ken chakayo teken, tay ammok ay maid layadyo ken Apo Dios. ");
INSERT INTO lbk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inmali ak isnan kalebfengan Ama, ya ke kayo't omad-i. Ngem mo pet wad-ay omali ay mangitakcheg isnan awakna kannay, et chawatenyo! ");
INSERT INTO lbk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ngag man chadlo nan ikkanyo ay pomati mo nan et yangkhay en-asipadchayawanyo nan pawadwad-enyo, ya faken nan kaidchayawanyo isnan es-esang ay Dios nan pawadwad-enyo? ");
INSERT INTO lbk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ngem ad-iyo kanan en sak-en nan sa mangidchalom ken chakayo ken Ama. Si Moises nan mangidchalom ken chakayo ay nangisolat isnan nangipay-anyo isnan namnamayo. ");
INSERT INTO lbk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tay mo pinatiyo si Moises, et patiyenyo akhes sak-en, tay sak-en nan kankanan Moises isnan insolatna. ");
INSERT INTO lbk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngem tay ad-iyo patiyen nan insolatna, ngag nan nateknana isnan ifab-aagko?” kinwanin Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Awni ya khinomchang si Jesus isnan Fayfay id Galilea ay makwani akhes en Fayfay nan Tiberias. ");
INSERT INTO lbk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sa et inon-onod nan angsaangsan ay takho, tay inilacha nan katataa ay kaimatonana isnan cha na nangipakhawisan isnan nenkasakit. ");
INSERT INTO lbk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nanikid si Jesus ya nan cheycha'y disipolosna is kafilig et nakitoktokcho ken chaicha ischi. ");
INSERT INTO lbk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nganngani et nan Paskua ay Piyastan si Judio. ");
INSERT INTO lbk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Idwani, issan nangil-an Jesus isnan angsaangsan ay takho ay cha somag-en ken siya, kinwanina ken Felipe, “Ngag nan angnen tako ay lomako is ipangan tako isnan naycha'y takho?” ");
INSERT INTO lbk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ammon Jesus nan angnena, ngem sinalodsodna chi ay maneptepeng/mamadpachas ken Felipe mo ngag nan isongfatna.) ");
INSERT INTO lbk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kinwanin et Felipe, “Olay pay nget chowa'y khasot ay denaryo, ay ke sa omanay si mailako is tinapay ay maikakcheng is olay sin-ak-it yangkhay ken chaicha!” ");
INSERT INTO lbk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sa et kanan Andres ay akhin Simon Pedro ya disipolos akhes Jesus en, ");
INSERT INTO lbk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Naay nan fab-alo ay nannget is lima ay sebada ay tinapay ya chwa'y filis. Ngem ay ke sa omanay nan sengetna isnan ad-achowan ay takho?” ");
INSERT INTO lbk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kinwanin et Jesus, “Patokchowenyo am-in chaicha.” (Annawa nan ponchag ischi.) Waschin tinmokcho et omey ay liman lifo nan filang nan lallalaki yangkhay. ");
INSERT INTO lbk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Inalan Jesus nan tinapay ya nenyaman ken Apo Dios, sa na't inchowa ta maiwalas isnan cheycha'y takho, ta mangan cha ay osto. Siya akhes chi nan inangnena isnan filis. ");
INSERT INTO lbk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Issan nakakkanancha ya negsanancha, kinwanin Jesus isnan disipolosna, “Amongenyo am-in nan nakhayad tay ayyew.” ");
INSERT INTO lbk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sa cha't chinakhop nan khinayad nan cheycha'y nangan, et napno nan sinpoo ya chwa ay lowa ay nalpo isnan lima ay tinapay ay sebada. ");
INSERT INTO lbk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Issan nangil-an san cheycha'y takho isnan katataa ay kaimatonana, kinwanicha, “Siya na tet-ewa nan chey mamadto ay nakwani en omali isnan lofong.” ");
INSERT INTO lbk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sa et, tay ammon Jesus ay maliligwat nan cheycha'y takho ay mamilit ken siya ta enfalinencha siya ay ali, kinmaan isnan kawadcha ta maes-esang ay omey isnan nafib-ilikhana. ");
INSERT INTO lbk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Awni ya sedsechemna, sa et khinomwab nan cheycha'y disipolosna is kafayfay. ");
INSERT INTO lbk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Sa cha't nenfangka ay omey is chemangna id Capernaum, tay ampon maschem ya maid kayet si Jesus ken chaicha. ");
INSERT INTO lbk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Et ab-afikas nan chakhem ya chinmakchake nan fayfay. ");
INSERT INTO lbk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Lima paymo enem et ay kilomitro nan nangipadchalanancha isnan fangka, ya ke cha't ilaen si Jesus ay manad-alan is kaoson nan chanom ay cha somag-en is kafangka. Sa cha't nafegyas. ");
INSERT INTO lbk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ket ay kinwanin Jesus, “Ad-i kayo man omegyat, tay sak-en na!” ");
INSERT INTO lbk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Sa cha't nalaychan ay mangipalokhan ken siya, ket ay chinmapos cha kannay isnan ili ay omayancha. ");
INSERT INTO lbk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Kawaksana, nan cheycha'y takho wad-ay cha ay napnap-on isnan chey chemang nan fayfay, ay nenyamanan Jesus ya namangnganana ken chaicha isnan tinapay. Ya ke cha't sinmek ay es-esang tegwa nan fangka id kogkha, ya egay nakilokhan si Jesus isnan disipolosna tay kecheng nan disipolosna nan kinmaan. Idwani, wad-ay nan tapina ay fangka ay nalpo id Tiberias ay cha chinmaka isnan sag-encha. ");
INSERT INTO lbk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Adi kad issan nangil-an nan cheycha'y takho ay maid si Jesus ya nan disipolosna, nenfangka cha ay inmey id Capernaum ay en nanganap ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Osto'y inchanan nan cheycha'y takho si Jesus is chemangna, kinwanicha ken siya, “Apo, kaatna nan inmaliyam isna?” ");
INSERT INTO lbk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kinwanin et Jesus ay sinmongfat, “Tet-ewa kanak ken chakayo, omanap kayo, ad-i khapo tay naawatanyo nan ayen nan katataa ay kaimatonak ay inilayo, mod-i ket tay nangan kayo ya negsan kayo. ");
INSERT INTO lbk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ad-iyo koma pawadwad-en nan enchonowanyo isnan makakan ay awni't mafang-es, mod-i ket ippeyyo nan felayyo isnan makakan ay omichowa is fiyag ay eng-engkhana. Siya sa nan ichowak ken chakayo, tay tinan-oyan Dios Ama sak-en ay Anak si Takho ay mangegnan isnan kalebfengana.” ");
INSERT INTO lbk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sa cha't kanan, “Ngag et nan masapol ay ikkanmi ta maiyangnenmi nan chono ay laychen Apo Dios?” ");
INSERT INTO lbk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Sinfat Jesus chaicha ay nangwanin, “Siya na nan laychen Apo Dios ay angnenyo: patiyenyo sak-en ay finaana.” ");
INSERT INTO lbk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tay siya chi kinwanicha, “Ngag et mampay nan katataa ay ipailam ken chakami ay kaimatonam ta ilaenmi ya patiyenmi sik-a? Ngag kay nan angnem? ");
INSERT INTO lbk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tay si Moises, pinnangana nan cheycha'y am-a tako isnan mana issan kawadcha isnan ponchag id solit, kag isnan naisolat ay kalin Apo Dios ay nangwanin, ‘Inagtana chaicha is tinapay ay nalpo id chaya.’ ” ");
INSERT INTO lbk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sa et kanan Jesus, “Tet-ewa kanak ken chakayo ay faken si Moises nan nangichowa ken chakayo issan chey isnan tinapay ay nalpo id chaya, mod-i ket si Ama. Ya faken chi nan tet-ewa ay tinapay ay malpo id chaya ay ichowan Ama ken chakayo idwani. ");
INSERT INTO lbk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tay nan tet-ewa ay tinapay ay ichowan Apo Dios, et siya nan khomwab ay malpo id chaya ay manakho isnan am-in ay takho.” ");
INSERT INTO lbk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sa cha't kanan ken Jesus, “Apo, kad-in ichowam koma ken chakami nan nay ay tinapay.” ");
INSERT INTO lbk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kinwanin et Jesus, “Sak-en nan tinapay ay omipabfiyag. Mo sino nan omali ay maitapi ken sak-en, et olay kaatna ad-i maowat. Siya, mo sino nan mamati ken sak-en et ad-i paat maew-ew. ");
INSERT INTO lbk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngem kag issan kinwanik, olay mo inmila kayo, khechangna'y ad-i kayo mamati. ");
INSERT INTO lbk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Am-in ay ichowan Ama ken sak-en et omali cha ay maitapi ken sak-en. Ya ad-ik ad-iyen nan olay sino ay omali ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tay pinmanad ak ay nalpo id chaya ta omali ak ay manno isnan nemnem Apo Dios ay finmaa, ya faken nan nemnemko. ");
INSERT INTO lbk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Et siya na nan nemnem nan finmaa, ta ilaek ta ad-ik chongawen nan olay sino ay inchowana ken sak-en, mod-i ket ta kasik takhowen chaicha isnan omochi ay akhew. ");
INSERT INTO lbk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tay nan nemnem Ama, et mo sino nan mamigfig isnan Anakna ya mamati ken siya, et maagtan is fiyag ay maid pengpengna. At sak-en nan mamangon ken siya isnan etey is kaomodchiyan si akhew,” kinwanin Jesus. ");
INSERT INTO lbk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nenmollomollotomot nan cheycha'y Judio tay kinwanin Jesus ay siya nan tinapay ay khinomwab ay nalpo id chaya. ");
INSERT INTO lbk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kinwanicha, “Na! Ay ke faken si tosa si Jesus ay anak Jose? Ammo tako met nan chakek-ena. En na man aped kanan en nalpo siya id chaya ay?” ");
INSERT INTO lbk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kinwanin et Jesus ken chaicha, “Ad-i kayo en-amoamoto. ");
INSERT INTO lbk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kanak, maid olay sino is makaali ay maitapi ken sak-en sok-ed ona awisen Ama ay namaa ken sak-en, ya at fangonek siya isnan etey is kaomodchiyan si akhew. ");
INSERT INTO lbk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tay insolat nan cheycha'y mamadto en, ‘Am-in ay takho, et isolowan Apo Dios chaicha.’ Am-in nan cheycha'y mannge ya masolowan ken Ama, chaicha nan omali ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ad-ik kanan en wad-ay nangila ken Ama, tay maid nakaila ken siya mod-i kecheng nan nalpo ken siya ay Dios. ");
INSERT INTO lbk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tet-ewa kanak ken chakayo ay mo sino nan mamati ken sak-en et wad-ay fiyagna is eng-engkhana. ");
INSERT INTO lbk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Sak-en nan tinapay ay omipabfiyag. ");
INSERT INTO lbk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nan cheycha'y am-ayo, olay nangan cha isnan mana issan kawadcha isnan ponchag id solit, natey cha kayet. ");
INSERT INTO lbk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngem nan tinapay ay kankanak, malpo na id chaya ta nan takho ay mangan isna et ad-i matey. ");
INSERT INTO lbk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sak-en nan omipabfiyag ay tinapay ay nalpo id chaya. Mo sino nan mangan isnan nay ay tinapay, at matakho is engkhana. Nan nay ay tinapay, siya nan awakko kannay ay ichowak ay menfiyag isnan am-in ay takho.” ");
INSERT INTO lbk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Osto'y siya chi ya ket naangang-a nan cheycha'y Judio ay mangwanin, “Ngag man nan angnen tona ay mangichowa isnan awakna ta kanen tako?” ");
INSERT INTO lbk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kinwanin et Jesus ken chaicha, “Tet-ewa kanak ken chakayo ay mo ad-iyo kanen nan awakko ay Anak si Takho, ya inomen nan chalak, et maid fiyag ay tet-ewa ken chakayo. ");
INSERT INTO lbk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mo sino et mampay nan mangan isnan awakko ya ominom isnan chalak, wad-ay et fiyagna ay maid pengpengna, et siya nan takhowek is kaomodchiyan si akhew. ");
INSERT INTO lbk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tay nan awakko siya nan osto ay makakan, ya nan chalak nan osto ay mainom. ");
INSERT INTO lbk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mo sino nan mangan isnan awakko ya ominom isnan chalak et entetee ay maiyornos ken sak-en, ya wawawawad-ay ak akhes ken siya. ");
INSERT INTO lbk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Si Ama ay kalpowan si fiyag nan namaa ken sak-en, ya matatakho ak khapo ken siya. Siya akhes ay olay sino ay mangakan ken sak-en, et enfiyag is eng-engkhana khapo ken sak-en. ");
INSERT INTO lbk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sak-en nan tet-ewa ay tinapay ay nalpo id chaya, ay faken kag isnan kinan san am-ayo id sangad-om. Tay nan nangan ischi, khechangna'y natey cha, ngem mo sino nan mangan isnan nay ay kankanak et enfiyag is engkhana.” ");
INSERT INTO lbk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Siya chana am-in nan kinwanin Jesus ay nen-isos-olo is kasinagoga id Capernaum. ");
INSERT INTO lbk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Issan nanngelan nan disipolos Jesus isnan chey ay sos-olona, angsan nan nangwanin, “To! Sikhab pay sa ay sos-olo! Sino nan sa mannge issa?” ");
INSERT INTO lbk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ngem tay ammon Jesus ay cha en-amoto nan disipolosna maipoon isnan infakhana, kinwanina, “En kayo man chadlos ngomaya isnan kinwanik ay? ");
INSERT INTO lbk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ngag kay nget mo sa ya ilaenyo sak-en ay Anak si Takho ay tomongcho id chaya ay sikhod ay nalpowak? ");
INSERT INTO lbk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nan mangigwa isnan tet-ewa ay fiyag, siya nan Ispirito Santo. Maid mabfalin nan takho. Et nan naycha ay chak kinwani ken chakayo, siya nan mangipaiyali ken chakayo isnan Ispirito Santo ay omipabfiyag. ");
INSERT INTO lbk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngem wad-ay cha nan ad-i mamati ay tapina ken chakayo,” kinwanina. (Tay si Jesus, sikhod ay ammona mo sino nan cheycha'y ad-i mamati, ya mo sino nan at mangitiktik ken siya.) ");
INSERT INTO lbk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sa na't kanan, “Siya sa nan mangwaniyak ken chakayo ay maid makaali ay maitapi ken sak-en mod-i sok-ed ona tan-oyan Ama.” ");
INSERT INTO lbk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Osto'y siya chi, ya ket angsan nan disipolosna ay nanaynan ken siya, ya egay cha't kasin naifob-oweg. ");
INSERT INTO lbk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sa et kinwanin Jesus isnan sinpoo ya chwa ay disipolosna, “Chakayo kay, laychenyo ngen akhes ay tomaynan?” ");
INSERT INTO lbk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sa et kanan Simon Pedro, “Apo, sino nan kasin mi omayan? Sik-a met yangkhay nan kawad nan kali ay tomakho is engkhana. ");
INSERT INTO lbk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ya apchas kami namati, ya chadlos mi inammowan ay sik-a chadlo nan Nasantowan ay nalpo ken Apo Dios.” ");