﻿USE sofia;
DROP TABLE IF EXISTS sofia.lbj_vpl;
CREATE TABLE lbj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lbj_vpl WRITE;
INSERT INTO lbj_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","གོ༌མ༌རང༌ དཀོན༌མཆོག༌གི༌ ནམ༌ཁའ༌ དང༌ ཇིག༌རྟེན༌ ཛད༌ ཟ༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ཇིག༌རྟེན༌བོ༌ ཟོས༌ཏ༌ མེད༌ཁན༌ དང༌ སྟོང༌པ༌, ཆུ༌ ཏིང༌ཅན༌ཀོན༌དྲོའེ༌ གངས༌ཏེ༌ ཡང༌ ཏེ༌བོ༌ མུན༌གྲིག༌གི༌ ཀབས༌ཏེ༌ ཡོད༌པིན༌། ཡང༌ དཀོན༌མཆོག༌གི༌ ཐུག༌ཉིད༌ ཏེ༌ ཆུའི༌ ཁེ༌ཐོག༌ག༌ ཁོར༌ཨིན༌ སྣང༌ང༌ བོར༌ར༌ ཛད༌དད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “འོད༌ ཇུང༌ཤིག༌” ཏེ༌ནེ༌ འོད༌ ཇུང༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","འོད༌པོ༌ ཟིགས༌ཏེ༌ དཀོན༌མཆོག༌ ཐུགས༌ཐདས༌། ཏེ༌སྟིང༌ནེ༌ དཀོན༌མཆོག༌གི༌ འོད༌པོ༌, མུན༌གྲིག༌ནེ༌ སོ༌སོ༌ ཕེའ༌ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ཡང༌ དཀོན༌མཆོག༌གི༌ འོད༌ལ༌ ཉི༌མ༌ ཡང༌ མུན༌གྲིག༌ག༌ ཚན༌ མོལ༌ཏེ༌ མིང༌ ཏག༌ག༌ ཛདས༌། ཏེ༌ནེ༌ ཕི༌ཏོག༌ བུད༌ཏེ༌ ང༌མོ༌ ལེབ༌, ཡང༌ ཏེ༌བོ༌ ཞག༌ ཏང༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “ཁེ༌ཐོག༌གི༌ ཆུ༌ ཇིག༌རྟེན༌ནི༌ ཆུ༌ནེ༌ སོ༌སོ༌ ཕེ༌ཅེས༌ལ༌ ཏེ༌ ཉིས༌ཀོའེ༌ པར༌ལ༌ ནས༌ས༌ཞིག༌ གྲུབ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ གྲུབ༌། དཀོན༌མཆོག༌གི༌ ཁེ༌ཐོག༌གི༌ ཆུ༌ དང༌ ཇིག༌རྟེན༌ནི༌ ཆུའི༌ པར༌ལ༌ ནས༌ས༌ཞིག༌ གྲུབ༌ ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ཡང༌ དཀོན༌མཆོག༌གི༌ ཏེ༌ ནས༌ས༌བོའ༌ ནམ༌ ཟེར༌ཏེ༌ མིང༌ ཏག༌ག༌ ཛདས༌། ཏེ༌ནེ༌ ཕི༌ཏོག༌ བུད༌ཏེ༌ ང༌མོ༌ ལེབ༌, ཡང༌ ཏེ༌བོ༌ ཞག༌ ཉིས༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “ས༌ སྐམ༌པོ༌ ཇུང༌ཅེས༌སི༌ ཕིའ༌, ནམ༌མི༌ ཡོག༌ག༌ ཡོད༌ཁན༌ནི༌ ཆུ༌གུན༌ ནས༌ས༌ ཅིག༌ཅིག༌ག༌ གྲིལ༌ཤིག༌།” དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ཡང༌ དཀོན༌མཆོག༌གི༌ ས༌ སྐམ༌པོ༌བོའ༌ ས༌ཀྱད༌ ཡང༌ ཆུ༌ གྲིལ༌ཁན༌བོའ༌ གྱ༌ཚོ༌ མོལ༌ཏེ༌ མིང༌ ཏག༌ག༌ ཛདས༌། ཁོང༌རང༌ངི༌ ཛད༌ཁན༌གུན༌ ཟིགས༌ཏེ༌, དཀོན༌མཆོག༌ ཐུགས༌ཐདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “ས༌ཀྱད༌བོའེ༌ཀ༌ ཁ༌ཟས༌ སྨིན༌ཁན༌ནི༌ ལྕང༌མ༌ དང༌ གྲུ༌ སྨིན༌ཁན༌ནི༌ སྔོན༌པོ༌ ཚང༌མ༌ སྐྱེ༌ཤིག༌། ཏེ༌ ས༌འོན༌གུན༌ནི༌ རང༌རང༌ངི༌ རིགས༌སི༌ ལྕང༌མ༌ དང༌ རྩཱ༌སྔོན༌པོ༌ གུན༌ སྐྱེ༌ཅུག༌ཨིན༌།” དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ཏེ༌ ས༌ཀྱད༌བོའེ༌ཀ༌ སྔོན༌པོའེ༌ རིགས༌ ཚང༌མ༌ སྨིན༌, ཡང༌ན༌ ཁ༌ཟས༌སི༌ ལྕང༌མ༌ དང༌ གྲུ༌ སྣ༌ཚོགས༌སི༌ སྔོན༌པོ༌, ཀ༌བོའེ༌ ས༌འོན༌གུན༌ནི༌ རང༌རང༌ངི༌ རིགས༌སི༌ ལྕང༌མ༌ དང༌ རྩཱ༌སྔོན༌པོ༌ གུན༌ སྐྱེ༌ཨིན༌། ཁོང༌རང༌ངི༌ ཛད༌ཁན༌གུན༌ ཟིགས༌ཏེ༌, དཀོན༌མཆོག༌ ཐུགས༌ཐདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ཏེ༌ནེ༌ ཕི༌ཏོག༌ བུད༌ཏེ༌ ང༌མོ༌ ལེབ༌, ཡང༌ ཏེ༌བོ༌ ཞག༌ སུམ༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “ཉི༌མ༌ དང༌ ཚན༌ ཕེ༌ཅེས༌སི༌ ཕིའ༌, ནམ༌མི༌ ནང༌ང༌ འོད༌གུན༌ ཇུང༌ཤིག༌། ཏེ༌གུན༌ ནམ༌ཟླ༌, ཞག༌ དང༌ ལོ༌ གུན༌ སྟན༌ཅེས༌ལ༌ སྟགས༌གུན༌ གྱུར༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ཏེ༌ འོད༌ ནམ༌མི༌ ནང༌ང༌ ཡོད༌ཁན༌གུན༌ནི༌ ཇིག༌རྟེན༌ནི༌ཀ༌ འོད༌ ཏོང༌ཤིག༌།” དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ཡང༌ དཀོན༌མཆོག༌གི༌ འོད༌ ཀྲག༌པོ༌ ཉིས༌ ཅོའ༌ ཛད༌, འོད༌ ཤུག༌ཆེ༌བོའ༌ ཉི༌མའ༌ ཡང༌ ཤུག༌ཆུང༌ང༌བོའ༌ ཚན༌ལ༌ འོད༌ ཏང༌ ཅུག༌ག༌ ཛདས༌། ཁོང༌ངི༌ སྐར༌མ༌གུན༌ནའང༌ ཅོའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","དཀོན༌མཆོག༌གི༌ ཏེ༌ འོད༌གུན༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ལྡངས༌ ཏང༌ཅེས༌སི༌ ཕིའ༌ ནམ༌ཁའེ༌ ནང༌ང༌ བོར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ཏེ༌གུན༌ ཉི༌མ༌ དང༌ ཚན༌ལ༌ ལྡངས༌ ཏང༌ཅེས༌ ཡང༌ འོད༌པོ༌ མུན༌གྲིག༌ནེ༌ སོ༌སོའ༌ ཕེ༌ཅེས༌ལ༌ ཛདས༌། ཁོང༌རང༌ངི༌ ཛད༌ཁན༌གུན༌ ཟིགས༌ཏེ༌ དཀོན༌མཆོག༌ ཐུགས༌ཐདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ཏེ༌ནེ༌ ཕི༌ཏོག༌ བུད༌ཏེ༌ ང༌མོ༌ ལེབ༌, ཡང༌ ཏེ༌བོ༌ ཞག༌ ཞི༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “ཆུ༌ ཚང༌མའེ༌ ནང༌ང༌ འུགས༌ ཡོད༌ཁན༌ནི༌ སེམས༌ཅན༌ མང༌པོ༌ ཡང༌ ནམ༌ཁའ༌ ཅ༌ཅིའུ༌ སྣ༌ཚོགས༌སི༌ གང༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ཏེན༌ན༌ ཟུག༌གི༌ དཀོན༌མཆོག༌གི༌ གྱ༌ཚོའེ༌ ནང༌ང༌ ཧ༌ལས༌ཤེས༌སི༌ སེམས༌ཅན༌ ཇིགས༌པོ༌, ཆུའི༌ ནང༌ང༌ གྲུལ༌ཁན༌ དང༌ རྐྱལ༌ཁན༌ སེམས༌ཅན༌ སྣ༌ཚོགས༌ མང༌པོ༌ ཡང༌ ཤོག༌པ༌ ཡོད༌ཁན༌ནི༌ ཅ༌ཅིའུ༌འི༌ རིགས༌ ཚང༌མ༌ ཅོའ༌ ཛདས༌། ཁོང༌རང༌ངི༌ ཛད༌ཁན༌གུན༌ ཟིགས༌ཏེ༌ དཀོན༌མཆོག༌ ཐུགས༌ཐདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཛད༌ཁན༌ ཚང༌མ༌ལ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ མོལས༌, “ཕྲུ༌གུ༌ སྐྱེས༌ཏེ༌ རང༌ངི༌ ཀྲངས༌ཀ༌ གྱས༌ཤུག༌ཤིག༌, ཉ༌གུན༌ནི༌ གྱ༌ཚོའེ༌ ནང༌ང༌, ཡང༌ ཅ༌ཅིའུ༌གུན༌ནི༌ ཇིག༌རྟེན༌ནི༌ ནང༌ང༌ རང༌ངི༌ ཀྲངས༌ཀ༌ གུན༌ མང༌པོ༌ ཕེལ༌ཅུག༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ཏེ༌ནེ༌ ཕི༌ཏོག༌ བུད༌ཏེ༌ ང༌མོ༌ ལེབ༌, ཡང༌ ཏེ༌བོ༌ ཞག༌ ལྔ༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “སེམས༌ཅན༌ སྣ༌མི༌ སྣ༌ཚོགས༌ཤིག༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཇུང༌ཤིག༌, ཏེ༌གུན༌ལ༌ རང༌རང༌ངི༌ རིགས༌སི༌ ཕྲུ༌གུ༌ སྐྱེ༌ཨིན༌, ཏེ༌བོའེ༌ ནང༌ང༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌, སའེ༌ཀ༌ གྲུལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཆུ༌ངུན༌ དང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ གུན༌ ཨིན༌ནོག༌།” དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ཏེན༌ན༌ ཟུག༌གི༌ དཀོན༌མཆོག༌གི༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ནི༌ རིགས༌, སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌ནི༌ རིགས༌, སེམས༌ཅན༌ ཆུ༌ངུན༌ནི༌ རིགས༌ ཚང༌མ༌ ཅོའ༌ ཛདས༌། ཁོང༌རང༌ངི༌ ཛད༌ཁན༌གུན༌ ཟིགས༌ཏེ༌ དཀོན༌མཆོག༌ ཐུགས༌ཐདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “ང༌དང༌ངི༌ ང༌དང༌རང༌ ཙོགས༌སི༌ མི༌རིག༌ ཅོ༌ཨིན༌, ཁོང༌གུན༌ ང༌དང༌ ཙོགས༌ ཡོང༌ཨིན༌། ཁོང༌གུན༌ནི༌ གྱ༌ཚོའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཉ༌, ནམ༌མི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཅ༌ ཚང༌མ༌ དང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌, སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌, སའེ༌ཀ༌ གྲུལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཆུ༌ངུན༌ སྣ༌ཚོགས༌ ཚང༌མའེ༌ཀ༌ ཝང༌སྲུལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཁོང༌རང༌ ཙོགས༌ མི༌གུན༌ ཅོའ༌ ཛདས༌། དེན༌བ༌ དཀོན༌མཆོག༌གི༌ ཏེ༌གུན༌ ཁོང༌རང༌ དང༌ཙོགས༌ ཅོའ༌ ཛདས༌, ཁོང༌ངི༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཅོའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཁོང༌གུན༌ལ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ མོལ༌ལ༌ ཛདས༌, “ཕྲུ༌གུ༌ སྐྱེ༌ཅུག༌ཏེ༌ རང༌ངི༌ ཀྲངས༌ཀ༌ ཕེལ༌ཅུག༌། ཇིག༌རྟེན༌ནི༌ ནང༌ང༌ གང༌ཅུགས༌ཏེ༌ ཝང༌སྲུལ༌། གྱ༌ཚོའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཉ༌, ནམ༌མི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཅ༌ ཡང༌ སའེ༌ཀ༌ གྲུལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཚང༌མའེ༌ཀ༌ ཝང༌སྲུལ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ཡང༌ དཀོན༌མཆོག༌གི༌ མོལས༌, “ལྟོས༌ཤིག༌, ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཟའ༌ཅེས༌སི༌ ཕིའ༌, ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཁ༌ཟས༌སི༌ ལྕང༌མ༌ དང༌ ས༌འོན༌ སྐྱེ༌ཁན༌ནི༌ སྔོན༌པོའེ༌ རིགས༌ ཚང༌མ༌ ཏངས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ཡང༌ རྩཱ༌ དང༌ ལོ༌མ༌ སྔོན༌པོ༌ ཚང༌མ༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌, ནམ༌མ༌ འུར༌ཁན༌ནི༌ ཅ༌ཅིའུ༌, སའེ༌ཀ༌ གྲུལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཆུ༌ངུན༌ དང༌ འུགས༌ ཡོད༌ཁན༌ ཚང༌མ༌ལ༌ ཟའ༌ཅེས༌སི༌ ཕིའ༌ ཏངས༌ཏེ༌ ཨིན༌།” དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ཏེ༌ནེ༌ ཁོང༌རང༌ངི༌ ཛད༌ཁན༌ ཚང༌མ༌ལ༌ ཟིགས༌ཏེ༌ དཀོན༌མཆོག༌ ཐུགས༌ཐདས༌། དེན༌བ༌ ཁོང༌ མ༌སྲན༌ཏྲེ༌ ཐུགས༌ཐདས༌། ཏེ༌ནེ༌ ཕི༌ཏོག༌ བུད༌ཏེ༌ ང༌མོ༌ ལེབ༌, ཡང༌ ཏེ༌བོ༌ ཞག༌ དྲུག༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ཏེན༌ན༌ ཚུལ༌ལ༌ དཀོན༌མཆོག༌གི༌ ནམ༌ཁའ༌, ཇིག༌རྟེན༌ ཡང༌ ཏེ༌གུན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཅོའ༌ ཛད༌ཅེས༌པོ༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","དཀོན༌མཆོག༌གི༌ ཛད༌པའེ༌ ཆག༌ལས༌ ཚང༌མ༌ གྲུབ༌ཚར༌པ༌, ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ ཁོང༌ ངལ༌ཚོས༌ཏེ༌ ཞུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","དཀོན༌མཆོག༌གི༌ ཞག༌ རྡུན༌པ༌བོའ༌ ཅིན༌ལབས༌ སལ༌ལ༌ ཛད༌ཏེ༌, ཏེ༌ ཞག༌པོ༌ ཏམ༌པ༌ ཐེའ༌ ཛདས༌, ཅིའ༌ཟེར༌ན༌ ཆག༌ལས༌ གང༌པོ༌ གྲུབ༌ཚར༌པ༌, ཏེ༌ ཞག༌ག༌ ཁོང༌ ངལ༌ཚོའ༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ཏེན༌ན༌བོ༌ ནམ༌ཁའ༌ དང༌ ཇིག༌རྟེན༌ ཛད༌ཅེས༌སི༌ ཚིར༌བོ༌ ཨིན༌པིན༌། 2:4-25 ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ནམ༌ཁའ༌ དང༌ ཇིག༌རྟེན༌ ཛད༌ ཟ༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ཇིག༌རྟེན༌ནི༌ཀ༌ ཏབ༌ཁན༌ ཡ༌ མ༌ཏབ༌ཁན༌ནི༌ རྩཱ༌ སྐྱེའ༌ མེད༌པིན༌, ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ཏ༌རུང༌ཚག༌པ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཆར༌པ༌ བབས༌ ཅུག༌ག༌ མ༌ཛད༌ད༌ ཨིན༌པིན༌, ཡང༌ ཇིག༌རྟེན༌ནི༌ཀ༌ སྟོན༌ཐོག༌ བད༌ཁན༌ནི༌ མི༌སུའང༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ཨིན༌ནའང༌ སའེ༌ ནང༌ནེ༌ ཆུ༌མིག༌གི༌ ཆུ༌ བིང༌ཏེ༌ ས༌ཀྱད༌ ཚང༌མ༌ ལོན༌པ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ཏེ༌ནེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ས༌ཀྱད༌དི༌ ཀ༌ནེ༌ ས༌ ནམས༌ཏེ༌ མི༌ཞིག༌གི༌ ཟོའེ༌ ནང༌ང༌ ཅོའ༌ ཛདས༌། ཁོང༌ངི༌ ཏེ༌ མི༌བོའེ༌ ན༌ཁུང༌ངི༌ ནང༌ང༌ ཚེ༌ སལ༌ཁན༌ནི༌ འུགས༌པོ༌ སལ༌ལ༌ ཛད༌པ༌, ཏེ༌ མི༌བོ༌ སྲོག༌ ཡོད༌ཁན༌ནི༌ མི༌ཞིག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ཏེ༌ནེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ཨི༌དན༌ ཟེར༌སའེ༌ ནས༌སའེ༌ ཤར༌ ཆོགས༌ལ༌ ཚས༌ཤིག༌ ཏབ༌བ༌ ཛདས༌, ཡང༌ ཏེ༌ནང༌ང༌ ཁོང༌ངི༌ ཅོའ༌ ཛད༌ཁན༌ནི༌ མི༌བོ༌ བོར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ཚས༌པོའེ༌ ནང༌ང༌ ལྕང༌མ༌ སྣ༌མི༌ སྣ༌ཚོགས༌ སྐྱེ༌ ཅུག༌ག༌ ཛདས༌, ཀ༌བོའེ༌ ནང༌ང༌ ལྡེ༌མོ༌ དང༌ ཁ༌ཟས༌ ཞིམ༌པོ༌ ཆགས༌ཁན༌ནི༌ ལྕང༌མ༌གུན༌ ཡོད༌པིན༌། ཏེ༌ ཚས༌སི༌ སྐྱིལ༌ལ༌ སྲོག༌ སལ༌ཁན༌ ཡང༌ ངན༌པ༌ དང༌ ཟང༌པོ༌ ཤེས༌ཤུག༌ཁན༌ནི༌ ལྕང༌མ༌ ཉིས༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ཡང༌ ཨི༌དན༌ནི༌ ནས༌ས༌ནེ༌ ལྩངས༌པོ༌ བིངས༌ཏེ༌ གྱུག༌ཁན༌ནི༌ ཆུའི༌ ཚས༌པོའ༌ ཆུ༌ ཏང༌ངད༌པིན༌། ཚས༌སི༌ སྟིང༌ནེ༌ ཏེ༌ ལྩངས༌པོ༌བོ༌ ཁག༌ཞིའི༌ ནང༌ང༌ བེའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ཁག༌ ཏང༌པོ༌བོ༌ པི༌ཤོན༌ ཟེར༌ཁན༌ནི༌ ལྩངས༌པོ༌ ཨིན༌པིན༌, ཀ༌བོ༌ ཁོར༌ཨིན༌ སེར༌ ཡོད༌ཁན༌ནི༌ ཧ༌ཝི༌ལའེ༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ གྱུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ཏེ༌ ཡུལ༌ལི༌ སེར༌བོ༌ གྱལ༌ཤོག༌, ཡང༌ ཏེ༌རུ༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ མར༌ དང༌ རྡོའ༌ མ༌ རིན༌ཅན༌ ཨོ༌ནེཀས༌ ཟེར༌ཁན༌གུན༌ནའང༌ ཐོབ༌བད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ཁག༌ ཉིས༌པ༌བོ༌ གི༌ཧོན༌ ཟེར༌ཁན༌ནི༌ ལྩངས༌པོ༌ ཨིན༌པིན༌, ཀ༌བོ༌ ཁོར༌ཨིན༌ ཀུཤ༌ཤེ༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ གྱུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ཁག༌ སུམ༌པ༌བོ༌ ཀྲི༌གརིས༌ ཟེར༌ཁན༌ནི༌ ལྩངས༌པོ༌ ཨིན༌པིན༌, ཀ༌བོ༌ ཨ༌ཤེར༌ ནས༌སའེ༌ ཤར༌ ཆོགས༌ནེ༌ གྱུག༌གད༌པིན༌། ཡང༌ ཁག༌ ཞི༌པ༌བོ༌ ཡུཕ༌རེ༌ཀྲས༌ ཟེར༌ཁན༌ནི༌ ལྩངས༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ཁོང༌རང༌ངི༌ ཛད༌ཁན༌ནི༌ མི༌བོ༌ ཨི༌དན༌ནི༌ ཚས༌སི༌ ནང༌ང༌ སྟོན༌ཐོག༌ བད༌ཅེས༌ དང༌ ཏེ༌བོའ༌ སྟ༌སྟོག༌ ཅོ༌ཅེས༌སི༌ ཕིའ༌ བོར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ཡང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ བུ༌ཚ༌བོའ༌ བཀའ༌ སལས༌, “འི༌ ཚས༌སི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ལྕང༌མ༌གུན༌ནེ༌, ཁྱོ༌རང༌ ཐད༌ཁན༌ནི༌ ཁ༌ཟས༌ ཟན༌ནའང༌ གྲིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ཨིན༌ནའང༌ ངན༌པ༌ དང༌ ཟང༌པོ༌ ཤེས༌ཤུག༌ཁན༌ནི༌ ལྕང༌མའེ༌ ཁ༌ཟས༌པོ༌ ཟའ༌ མ༌གོས༌, ཀལ༌ཏེས༌ ཟའ༌ན༌ ཏེན༌ན༌ ཞག༌ག༌ ཁྱོ༌རང༌ ཤི༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ཏེ༌ནེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛདས༌, “ཕྲོ༌པ༌ མེད༌ཅེས༌པོ༌ བུ༌ཚའེ༌ ཕིའ༌ གྱལ༌ལ༌ཞིག༌ མི༌དུག༌, ངའེ༌ ཁོའ༌ ཟོབ༌ཤེས༌སི༌ རོགས༌ ཅོ༌ཁན༌ཞིག༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ སེམས༌ཅན༌ དང༌ ཅ༌ཅིའུ༌ ཚང༌མའ༌, ཅི༌ མིང༌ ཏག༌དུག༌ ཟིགས༌ས༌ལ༌, ས༌ ཉམ༌པོ༌ ཁོང༌རང༌ངི༌ ཆག༌ནེ༌ ཛད༌ཁན༌ནི༌ མི༌བོའེ༌ དུན༌ལ༌ ཁྱོང༌ང༌ ཛདས༌, ཡང༌ ཀ༌ཟུག༌ མིང༌ རིག༌ ཏག༌ནའང༌ ཏེ༌བོ༌ ཏེན༌ན༌བོའེ༌ མིང༌བོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ཏེ༌ནེ༌ མི༌བོའེ༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌, ནམ༌མ༌ འུར༌ཁན༌ནི༌ ཅ༌ དང༌ རིའི༌ སེམས༌ཅན༌ ཚང༌མ༌ལ༌ མིང༌ ཏགས༌། ཨིན༌ནའང༌ ཏེ༌གུན༌ནི༌ ནང༌ནེ༌ ཁོའ༌ ཟོབས༌ཤེས༌ཅན༌ནི༌ ཕྲོ༌པ༌ རོགས༌ ཅོ༌ཁན༌ཞིག༌ མ༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ཏེ༌ནེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ བུ༌ཚ༌བོའ༌ མ༌ ཉིད༌ ལྕིན༌ཏྲེ༌ ཡོང༌ ཅུག༌ག༌ ཛདས༌། ཁོའེ༌ ཟུགས༌པོའེ༌ ནང༌ནེ༌ ཙིབ༌མ༌ཅིག༌ ཕིང༌ང༌ ཛད༌ཏེ༌ ཏེ༌བོ༌ ཤ༌ ཉམ༌པོ༌ ཀབ༌བ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ བུ༌ཚ༌བོའེ༌ ཀ༌ནེ༌ ཕིང༌ང༌ ཛད༌ཁན༌ནི༌ ཏེ༌ ཙིབ༌མ༌བོའ༌, བུ༌མོ༌ཞིག༌ ཅོའ༌ ཛད༌ཏེ༌ བུ༌ཚའེ༌ དུན༌ལ༌ ཁྱོང༌ང༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ཏེ༌ནེ༌ བུ༌ཚའེ༌ ཟེརས༌, “ཝའོ༌! ཏ༌ འི༌ རུས༌པ༌བོ༌ ངའེ༌ རུས༌པ༌, འི༌ ཤ༌བོ༌ ངའེ༌ ཤ༌ ཨིན༌ནོག༌། ཁོའ༌ བུ༌མོ༌ ཟེར༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ བུ༌ཚའེ༌ ནང༌ནེ༌ ཕིངས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ཏེན༌ན༌ གྱུན༌ཚན༌བོའེ༌ ཕིའ༌ བུ༌ཚ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ དང༌ ཨ༌མ༌ནེ༌ བེ༌ཏེ༌ ཁོ༌རང༌ངི༌ ན༌མ༌ ཉམ༌པོ༌ ཛོམ༌མ༌ནོག༌, ཡང༌ ཁོང༌ ཉིས༌ཀོ༌ ཅིག༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ཏེ༌ཏུས༌ལ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཉིས༌ཀོ༌ ལྗེར༌ཉལ༌ ཡོད༌ནའང༌, ཁོང༌གུན༌ ཁྲེལ༌ལ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ཏ༌ རུལ༌བོ༌ ནི༌, ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ཛད༌ཁན༌ནི༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ ཚང༌མའེ༌སང༌, སྐྱོན༌ཇན༌ ཡོད༌པིན༌། ཁོའེ༌ བུ༌མོའ༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ཏན༌ཏན༌ལ༌, ཁྱོ༌རང༌ང༌ འི༌ ཚས༌སི༌ ལྕང༌མ༌ ཅིག༌གི༌ ཀ༌ནེའང༌ ཁ༌ཟས༌ ཟའ༌ མ༌གོས༌ མོལ༌ལ༌ རག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ཏེ༌ནེ༌ བུ༌མོའེ༌ རུལ༌ལ༌ ལན༌ཏངས༌, “དཀོན༌མཆོག༌གི༌ ང༌ཞའ༌, ‘ཚས༌སི༌ ནང༌ནེ༌ ཁ༌ཟས༌ ཚང༌མ༌ ཟའ༌ནའང༌ གྲིག༌, ");
INSERT INTO lbj_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ཨིན༌ནའང༌ ཚས༌སི༌ སྐྱིལ༌ལ༌ ཡོད༌ཁན༌ནི༌ ལྕང༌མའེ༌ ཁ༌ཟས༌པོ༌ ཟའ༌ མ༌གོས༌ ཡ༌ ལག༌པའང༌ མ༌རྩེ༌, ཏེ༌ཟུག༌ ཅོ༌ན༌ ཁྱོ༌ཞའ༌ ཤི༌ཨིན༌’ མོལ༌ལ༌རག༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ཨིན༌ནའང༌ རུལ༌བོའེ༌ བུ༌མོའ༌ ཟེརས༌, “ཁྱོ༌ཞའ༌ ཤིའ༌ མ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ཏེ༌ ཁ༌ཟས༌པོ༌ ཟའ༌ན༌ ཁྱོ༌ཞའེ༌ མིག༌ བེ༌ཏེ༌, ཁྱོ༌ཞ༌གུན༌ དཀོན༌མཆོག༌ ཙོགས༌ གྱུར༌ཏེ༌ ཟང༌པོ༌ དང༌ ངན༌པ༌ གུན༌ ཧ༌གོ༌ཅེས༌པོ༌ དཀོན༌མཆོག༌ག༌ གྱུས༌ཡོད༌ པ༌སང༌, ཏེ༌ ཁ༌ཟས༌པོ༌ མ༌ཟ༌ མོལ༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","བུ༌མོའ༌ ཏེ༌ ལྕང༌མའེ༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཁ༌ཟས༌གུན༌ མ༌ ལྡེ༌མོ༌ དང༌ ཞིམ༌པོ༌ ཡོད༌ཁན༌བོ༌ ཐོང༌ ཡང༌ ཏེ༌ ཤེས༌རབས༌པོ༌ ཐོབ༌ཅེས༌སི༌ དོད༌པ༌ ཡོད༌ པ༌སང༌, ཁོའེ༌ ཁ༌ཟས༌ཞིག༌ ཁྱོངས༌ཏེ༌ ཟོས༌། ཡང༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ ཁོ༌རང༌ངི༌ མག༌པ༌ ཟའ༌ཅེས༌ལ༌ ཏངས༌པ༌, ཁོའེང༌ ཟོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ཏེན༌ན༌མལ༌ལ༌, ཁོང༌གུན༌ནི༌ མིག༌ ཕེད༌ཏེ༌, ཁོང༌ ཉིས༌ཀོ༌ ལྗེར༌ཉལ༌ལ༌ ཡོད༌ཁན༌བོ༌ ཧ༌གོ༌པ༌, ཕིག༌ ཟེར༌ཁན༌ནི༌ ལྕང༌མའེ༌ ལོ༌མ༌གུན༌ ཙེམས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཟུགས༌པོའེ༌ རྨད༌བོ༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ཏེ༌ནེ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཉིས༌ཀོའ༌, ཡ༌ཝ༌ དཀོན༌མཆོག༌ ཚས༌སི༌ ནང༌ང༌ ཕི༌ཏོག༌གི༌ སིལ༌མོ༌ ལུངས༌པོའེ༌ ཏུས༌ ཞབ༌གྲུལ༌ལ༌ སྐྱོད༌ཨིན༌ ཡོད༌ཁན༌ནི༌ སྐད༌ ཚོར༌པ༌, ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ མི༌ཟིགས༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌གུན༌ ཚས༌སི༌ ལྕང༌མའེ༌ གྱབ༌བ༌ ཨིབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ཨིན༌ནའང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ བུ༌ཚ༌བོའ༌ བོད༌ཏེ༌, “ཁྱོ༌རང༌ ཀ༌ནེ༌ ཡོད༌?” མོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","བུ༌ཚ༌བོའེ༌ ལན༌ཏངས༌ཏེ༌, “ཉེ༌རང༌ ཚས༌སི༌ ནང༌ང༌ སྐྱོད༌ཅེས༌སི༌ སྐད༌པོ༌ ཚོར༌ར༌ཅིག༌, ང༌ ཇིགས༌ཏེ༌ ཨིབས༌པིན༌ ཅིའ༌ཟེར༌ན༌ ང༌ ལྗེར༌ཉལ༌ལ༌ ཡོད༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ཁོང༌ངི༌ མོལས༌, “སུའི༌ ཟེར༌ར༌རག༌ ཁྱོ༌རང༌ ལྗེར༌ཉལ༌ལ༌ དུག༌ ཟེར༌ཏེ༌? ཁྱོ༌རང༌ངི༌ ཚས༌སི༌ སྐྱིལ༌ལ༌ ཡོད༌ཁན༌ནི༌ ལྕང༌མའེ༌ ཀ༌ནེ༌ ཁ༌ཟས༌, ངའེ༌ མ༌ཟ༌ ཟེར༌ཁན༌བོ༌ ཏ༌ མ༌ཟོས༌པིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ཏེ༌ནེ༌ བུ༌ཚ༌བོའེ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ང༌ རོགས༌ ཅོའ༌ལ༌ སལ༌ཁན༌ནི༌ བུ༌མོའེ༌ ང༌ ཏེ༌ ལྕང༌མའེ༌ ཁ༌ཟས༌པོ༌ ཏངས༌པ༌, ངའེ༌ ཟོས༌པིན༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ཏེ༌ནེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ བུ༌མོའ༌, “ཁྱོ༌རང༌ངི༌ འི༌བོ༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌” མོལས༌། བུ༌མོའེ༌ ཟེརས༌, “རུལ༌ལི༌ ངའ༌ གོབ༌སྐོར༌པ༌ ངའེ༌ ཟོས༌པིན༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ རུལ༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ འི༌བོ༌ ཅོས༌ པ༌སང༌, སྲལ༌ཁན༌ དང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ ཚང༌མའེ༌ ཕྲོ༌ནེ༌ ངའེ༌ ཁྱོ༌རང༌ ཅིག༌པོའ༌ ཆད༌པ༌ ཏང༌ངད༌། ཏ༌ནེ༌ཕར༌ལ༌, ནམ༌ཚོག༌པ༌ ཁྱོ༌རང༌ ཤི༌ མི༌ཤི༌ ཁྱོ༌རང༌ གྲོད༌པའེ༌ཀ༌ གྲུལ༌ཨིན༌, སའེ༌ ཐལ༌བའེ༌ ནང༌ང༌ ཏུས༌གྱུན༌ དུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ངའེ༌ ཁྱོ༌རང༌ དང༌ བུ༌མོ༌ ཉིས༌ཀོ༌ གྲ༌འོ༌ གྱུར༌ཅུག༌ཨིན༌, མ༌ཚད༌ ཁྱོ༌རང༌ངི༌ མིར༌གྱུད༌ དང༌ ཁོའེ༌ མིར༌གྱུད༌དའང༌ གྲ༌འོ༌ གྱུར༌ཨིན༌། ཁོའེ༌ མིར༌གྱུད༌པོའེ༌ ཁྱོ༌རང༌ངི༌ གོའ༌ སྟིང༌ཟིས༌ ཏང༌ཨིན༌, ཡང༌ ཁྱོ༌རང༌ངི༌ ཁོའེ༌ རྐང༌པའེ༌ཀ༌ ཐམས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ཏེ༌ནེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ བུ༌མོ༌བོའ༌ མོལས༌, “ཏ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཕྲུ༌གུ༌ ཇོར༌རི༌ ཏུས༌ ནགས༌ མང༌ང༌ ཐོང༌ཅུག༌ཨིན༌, ཡང༌ ཟུ༌མོ༌ སྲན༌ཏྲེ༌ ཡོངས༌ཏེ༌ མ༌ནེ༌ ཁྱོ༌རང༌ང༌ ཕྲུ༌གུ༌ མི༌སྐྱེ༌། ཏེ༌ནེའང༌ ཁྱོ༌རང༌ང༌ མག༌པའེ༌ ཕིའ༌ མའ༌ དོད༌པ༌ ཡོང༌ཨིན༌, ཡང༌ ཁོའེ༌ ཁྱོ༌རང༌ངི༌ཀ༌ ཝང༌ སྲུལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ཏེ༌ནེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ བུ༌ཚའ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ རང༌ངི༌ ན༌མའེ༌ ཁའ༌ཉན༌ཏེ༌ ངའེ༌ མ༌ཟ༌ ཟེར༌ཁན༌ནི༌ ལྕང༌མའེ༌ ཁ༌ཟས༌པོ༌ ཟོས༌། ཁྱོ༌རང༌ངི༌ ཞས༌ཏེ༌, ཏ༌ ངའེ༌ ས༌ཀྱད༌ལ༌ ངན༌ ཏབ༌བད༌, ཏ༌ནེ༌ཕར༌ལ༌ ཀགས༌པོ༌ ཉམ༌པོ༌ མ༌ནེ༌ ཁྱོ༌རང༌ང༌ ཟའ༌ཅེས༌ལ༌ ཁར༌ཇི༌ སྨིན༌ཅུག༌ མི༌ཐུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ཞིང༌ངི༌ཀ༌ ཙེར༌མང༌ དང༌ ལྗང༌ཙེར༌ མང༌པོའང༌ སྐྱེ༌ཨིན༌, ཡང༌ ཁྱོ༌རང༌ངི༌ སའེ༌ཀ༌ ཏབ༌ཁན༌ དང༌ མ༌ཏབ༌བ༌ སྐྱེས༌ཁན༌ནི༌ སྔོན༌པོ༌གུན༌ ཙལ༌ཏེ༌ ཟེན༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ཁྱོ༌རང༌ སའེ༌ ནང༌ང༌ དྲེས༌དྲེས༌ ཚག༌པ༌ལ༌, ཁོ༌རང༌ངི༌ ཚད༌པ༌ བིང༌བིང༌ ལས༌ མ༌སྲན༌ཏྲེ༌ ཅོས༌ཏེ༌ མ༌ནེ༌, ཁྱོ༌རང༌ང༌ ཟའ༌ཅེས༌ལ༌ ཁར༌ཇི༌ མི༌ཐོབ༌། ཁྱོ༌རང༌ ས༌ནེ༌ ཅོས༌ཏེ༌ ཨིན༌ པ༌སང༌, ཁྱོ༌རང༌ ལོགས༌ཏེ༌ ས༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ཨ༌དམ༌མི༌ ཁོ༌རང༌ངི༌ ན༌མའེ༌ མིང༌ང༌ ཧ༌ཝ༌ ཏགས༌, ཅིའ༌ཟེར༌ན༌ ཁོ༌ མི༌ཚང༌མའེ༌ ཨ༌མ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ཡང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ སེམས༌ཅན༌ནི༌ པགས༌པའ༌ ཀོས༌ ཙེམས༌ཏེ༌ ཨ༌དམ༌ དང༌ ཁོའེ༌ ན༌མ༌ སྐོན༌ན༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ཏེ༌ནེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ མོལས༌, “ལྟོས༌སའང༌, ཏ༌ ཁོང༌ ཉིས༌ཀོའ༌ ཟང༌པོ༌ དང༌ ངན༌པ༌ ཤེས༌ཏེ༌, ང༌དང༌གུན༌ ཙོགས༌ གྱུར༌ཏེ༌ ཨིན༌ནོག༌། ཏ༌ ཁོང༌གུན༌ལ༌ ཏེ༌ སྲོག༌ ཏང༌ཁན༌ནི༌ ལྕང༌མའེ༌ ཁ༌ཟས༌པོ༌ ལེན༌ཏེ༌ ཟའ༌ཅུག༌ མ༌གོས༌, ཏེ༌ མ༌ནེ༌ ཁོང༌གུན༌ལ༌ ཐའ༌མེད༌པའེ༌ མི༌ཚེ༌ ཐོབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ཀ༌ ས༌བོའེ༌ ཀ༌ནེ༌ ཁོ༌ ཞང༌ང༌ ཛད༌ཏེ༌ ཨིན༌པིན༌ ཏེན༌ན༌ ས༌ བད༌ཅེས༌ལ༌ ཁོང༌གུན༌ ཨི༌དན༌ ཚས༌ནེ༌ ཕི༌ལོག༌ག༌ ཕིང༌ང༌ ཛདས༌ ");
INSERT INTO lbj_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ཁོང༌གུན༌ ཚས༌ནེ༌ ཕིང༌ཚར༌ཏེ༌ སྟིང༌ནེ༌, ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ སྲོག༌ སལ༌ཁན༌ནི༌ ལྕང༌མ༌ སྐྱོབ༌ཅེས༌སི༌ ཕིའ༌ ཚས༌སི༌ ཤར༌ ཆོགས༌ལ༌, སྲུང༌སྐྱོབ༌ ཛད༌ཁན༌ནི༌ ཆེ༌ར༌བེམ༌གུན༌ དང༌ མེ༌ བར༌ཁན༌ནི༌ ར༌འི༌ ཡུག༌ཨིན༌ བོར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ཨ༌དམ༌ དང༌ ཁོའེ༌ ན༌མ༌ ཧ༌ཝ༌ ཉིས༌ཀོ༌ ཛོམས༌ཏེ༌, ཧ༌ཝ༌ སྐྱེ༌ཅེས༌མ༌ཞིག༌ གྱུར༌། ཡང༌ བུ༌ཚ༌ ཀ༌ཡིན༌ ཟེར༌ཁན༌བོ༌ སྐྱེས༌པ༌ ཁོའེ༌ ཟེརས༌ “ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ རོགས༌ ཉམ༌པོ༌ ང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ཏུས༌བན༌ཤིག༌གི༌ སྟིང༌ནེ༌, ཧ༌ཝའ༌ ཀ༌ཡིན༌ནི༌ ནོ༌ ཨ༌བེལ༌ སྐྱེས༌། ཁོང༌གུན༌ ཆེན༌མོ༌ སོང༌ཏེ༌, ཨ༌བེལ༌ ལུག༌རྫི༌ ཡང༌ ཀ༌ཡིན༌ ཞིང༌བད༌པ༌ཞིག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ཞག༌ཤིག༌, ཀ༌ཡིན༌ནི༌ ཁོ༌རང༌ངི༌ སྟོན༌ཐོག༌གི༌ ཁག༌ཅིག༌ ཡ༌ཝའ༌ ཆོད༌པའ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ཡང༌ ཨ༌བེལ༌ལིའང༌ ཁོ༌རང༌ངི༌ ལུག༌ཁྱུའི༌ ནང༌ནེ༌ ཚང༌མའེ༌སང༌ རིན༌ཅན༌ གོ༌མ༌ སྐྱེས༌ཁན༌ ལུ༌གུའི༌ ཚང༌མའེ༌སང༌ གྱལ༌ལ༌ ཚིལ༌ཅན༌ནི༌ ཤ༌བོ༌ ཡ༌ཝའ༌ ཆོད༌པའ༌ ཕུལས༌། ཡ༌ཝའ༌ ཨ༌བེལ༌ལི༌ ཕུལ༌ཁན༌བོའ༌ ཐུགས༌ཐདས༌, ");
INSERT INTO lbj_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ཨིན༌ནའང༌ ཀ༌ཡིན༌ནི༌ སམ༌ཚུལ༌ དང༌ ཁོའེ༌ ཕུལ༌ཁན༌བོའེ༌ཀ༌ ཐུགས༌ མ༌ཐདས༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ ཀ༌ཡིན༌ལ༌ མ༌ སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌ ཡང༌ ཏེ༌བོ༌ ཁོའེ༌ ལྡོང༌ངི༌ཀ༌ སྔོནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོལས༌, “ཅི༌ཕིའ༌ སྲོ༌ ཡོང༌ངད༌, ཡང༌ ཏེ༌བོ༌ ཁྱོ༌རང༌ངི༌ ལྡོང༌ངི༌ཀ༌ ཅི༌ཕིའ༌ སྟན༌ནད༌? ");
INSERT INTO lbj_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","འོས༌པ༌ ཅོ༌ན༌, ཅི༌ ངའ༌ ཁྱོ༌རང༌ངི༌ཀ༌ ཐད༌པོ༌ མི༌ཆའ༌? ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ཀྲང༌པོ༌བོ༌ ཅོའ༌ མེད༌ན༌, ཏེ༌ནེ༌ ཤང༌ ཅོས༌, སྡིག༌པ༌ ཁྱོ༌རང༌ ཟུམ༌ཅེས༌ལ༌ ཁྱོ༌རང༌ངི༌ སྒོའེ༌ཀ༌ སྲུངས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ཀ༌ ཝང༌ ཅོའ༌ལ༌ གྲལ༌གྲིག༌ དུག༌། ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ཁོའ༌ ཕམ༌ཀལ༌ཏེ༌ ཁོའེ༌ཀ༌ ཝང༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ཞག༌ཤིག༌, ཀ༌ཡིན༌ནི༌ རང༌ངི༌ ནོ༌ ཨ༌བེལ༌ལ༌ ཟེརས༌, “ཡོང༌ངའང༌, ང༌དང༌ ཞིང༌ངི༌ཀ༌ ཆེན༌” ཡང༌ ཁོང༌གུན༌ ཏེ༌རུ༌ ཡོད༌ ཟ༌ནེ༌, ཀ༌ཡིན༌ནི༌ ཧུན༌མེད༌ལ༌ རང༌ངི༌ ནོ༌ ཨ༌བེལ༌ལི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","སྟིང༌ནེ༌ ཡ༌ཝའེ༌ ཀ༌ཡིན༌ལ༌ བྲིའ༌ ཛདས༌, “ཁྱོ༌རང༌ངི༌ ནོ༌ ཨ༌བེལ༌ ཀ༌ནེ༌ ཡོད༌།” ཀ༌ཡིན༌ནི༌ ཟེརས༌, “ང༌ གྱུས༌མེད༌, ཅི༌ ང༌, ངའེ༌ ནོ༌ སྲུང༌ཁན༌ ཨིན༌ནོག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ཉོན༌, ས༌ཀྱད༌དི༌ ཀ༌ནེ༌ ཁྱོ༌རང༌ངི༌ ནོའེ༌ ཁྲག༌པོའེ༌ ངའ༌ བོད༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ཏ༌ ཁྱོ༌རང༌ང༌ ངན༌ ཕོག༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ནོའེ༌ ཁྲག༌ ཐིམས༌ཁན༌ནི༌ ས༌ཀྱད༌པོའེ༌ ཁྱོ༌རང༌ ཕངས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ཁྱོ༌རང༌ངི༌ སའེ༌ཀ༌ སྟོན༌ཐོག༌ ཏབ༌ན༌, ཏེ༌བོའ༌ སྟོན༌ཐོག༌ ཅའང༌ མི༌སྨིན༌། ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌རང༌ང༌ དུག༌ས༌ མེད༌པ༌ ཁྱོ༌རང༌ ས༌ཆ༌ ཅིག༌ནེ༌ ཅིག༌ག༌ ཁྱམ༌ཨིན༌ མི༌ཚེ༌ ཕུད༌གོས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ཏེ༌ནེ༌ ཀ༌ཡིན༌ནི༌ ཡ༌ཝའ༌ ཞུས༌, “ཉེ༌རང༌ངི༌ ངའ༌ ཆད༌པ༌ ཀལ༌ལ༌ ཛད༌ཁན༌བོ༌ ང༌ ཁུར༌ ཐུབ༌ཅེས༌སི༌ ཁྱུད༌དི༌ སང༌ ཐལ༌ཏེ༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ཉེ༌རང༌ངི༌ ང༌ ས༌ཀྱད༌ དང༌ ཉེ༌རང༌ངི༌ སྐུན༌དུན༌ནེ༌ ཕང༌ང༌ ཛད༌ཏེ༌ ང༌ འི༌ ཇིག༌རྟེན༌ནི༌ཀ༌ དུག༌ས༌ མེད༌ཁན༌ནི༌ ཁྱམ༌པོ༌ཞིག༌ ཅོའ༌ ཛད༌པ༌, ངའ༌ ཐུག༌ཁན༌གུན༌ནི༌ ང༌ སད༌ད༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “ཏེ༌ཟུག༌ མ༌ནེ༌ མི༌ཆ༌, ཀལ༌ཏེས༌ སུ༌ཞིག༌གི༌ ཁྱོ༌རང༌ སད༌ན༌ ཏེ༌བོའ༌ ཆད༌པ༌, ཁྱོ༌རང༌ངི༌ སང༌ རྡུན༌ལྡབ༌ མང༌ང༌ ཕོག༌ཨིན༌།” སུ༌ཞིག༌གིའང༌ ཀ༌ཡིན༌ མི༌སད༌ཅེས༌སི༌ ཕིའ༌ ཡ༌ཝའེ༌ ཁོའེ༌ཀ༌ སྟགས༌ གྱབ༌བ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ཏེ༌ནེ༌ ཀ༌ཡིན༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ནེ༌ བེ༌ཏེ༌ སོང༌, ཡང༌ ཨི༌དན༌ནི༌ ཤར༌ ཆོགས༌སི༌ ནས༌ས༌ ནོདྲ༌ ཡང༌ན༌ “ཁོར༌ཨིན༌ དུག༌ཁན༌གུན༌ནི༌ ནས༌ས༌” ཟེར༌སའེ༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ཏུས༌བན༌ཤིག༌གི༌ སྟིང༌ནེ༌, ཀ༌ཡིན༌ ཁོ༌རང༌ངི༌ ན༌མ༌ ཉམ༌པོ༌ ཛོམས༌ཏེ༌, ཁོའེ༌ ན༌མ༌ སྐྱེ༌ཅེས༌མ༌ཞིག༌ གྱུར༌, ཡང༌ ཨེ༌ནོག༌ ཟེར༌ཁན༌ནི༌ བུ༌ཚ༌ཞིག༌ སྐྱེས༌། ཀ༌ཡིན༌ནི༌ གྱལ༌ས༌ཞིག༌ རྩིགས༌ཏེ༌ ཏེ༌བོའ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ མིང༌ ཙོགས༌, ཨེ༌ནོག༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ཨེ༌ནོག༌ག༌ ཨི༌རད༌ ཟེར༌ཁན༌ནི༌ བུ༌ཚ༌ཞིག༌ ཡོད༌པིན༌། ཨི༌རད༌ ནི༌ མེ༌ཧུ༌ཇེལ༌ལི༌ ཨ༌བ༌, ཡང༌ མེ༌ཧུ༌ཇེལ༌ ནི༌ མེ༌ཐུ༌ཤེལ༌ལི༌ ཨ༌བ༌, མེ༌ཐུ༌ཤེལ༌ ནི༌ ལ༌མེག༌གི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ལ༌མེག༌གི༌, ཨ༌ད༌ དང༌ ཟི༌ལ༌ བུ༌མོ༌ གུན༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ཨ༌ད༌ལ༌, ཡ༌བལ༌ ཟེར༌ཁན༌ནི༌ བུ༌ཚ༌བོ༌ སྐྱེས༌། ཡ༌བལ༌ ནི༌ སེམས༌ཅན༌ སྲལ༌ཨིན༌, ཀུར༌རི༌ ནང༌ང༌ དུག༌ཁན༌ ཏང༌པོ༌ མི༌བོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ཁོའེ༌ ནོ༌ ཡུ༌བལ༌ ཟེར༌ཁན༌བོ༌ ཏར༌ཅན༌ནི༌ རོལ༌མོ༌ དང༌ ལིང༌བུ༌ ཕུ༌ཁན༌གུན༌ནི༌ མི༌ ཏང༌པོ༌བོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ལ༌མེག༌གི༌ ན༌མ༌ ཟི༌ལའ༌ ཏ༌བུལ༌ཀ༌ཡིན༌ ཟེར༌ཁན༌ནི༌ བུ༌ཚ༌བོ༌ སྐྱེས༌། ཁོའེ༌ ལྕགས༌ དང༌ ཟངས༌སི༌ ལག༌ཆ༌གུན༌ ཅོའད༌པིན༌། ཡང༌ ཏ༌བུལ༌ཀ༌ཡིན༌ནི༌ ནོ༌མོ༌ ནི༌ ནའ༌མཧ༌ ཟེར༌ཁན༌བོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ལ༌མེག༌གི༌ རང༌ངི༌ ན༌མ༌ ཉིས༌ཀོའ༌ ཟེརས༌, “ཨ༌ད༌ དང༌ ཟི༌ལ༌, ངའེ༌ སྤེ༌ར༌ ཉོན༌ཤིག༌། ལ༌མེག༌གི༌ ན༌མ༌གུན༌ ངའེ༌ ཟེར༌ཁན༌བོའ༌ ཉོན༌ཤིག༌། ངའེ༌ ངའ༌ སྤུང༌གོལ༌ ཅོ༌ཁན༌ནི༌ མི༌ཞིག༌ སད༌པིན༌, ང༌ མ༌ཁའ༌ ཕིང༌ཁན༌ནི༌ ཁྱོག༌ཏོང༌ཞིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ཀལ༌ཏེས༌ ཀ༌ཡིན༌ སད༌ཁན༌བོའ༌ རྡུན༌ ལྡབ༌བི༌ ཆད༌པ༌ ཕོག༌ན༌ ཏེ༌ནེ༌ ངའ༌ སད༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོ༌ཁན༌བོའ༌ ཏེ༌བོའེ༌ རྡུན༌ཅུ༌དོན༌རྡུན༌ ལྡབ༌བི༌ ཆད༌པ༌ ཕོག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ཨ༌དམ༌ རང༌ངི༌ ན༌མ༌ ཉམ༌པོ༌ ཡང༌སྐྱར༌ ཛོམས༌པ༌, ཁོའེ༌ ན༌མ༌ བུ༌ཚ༌ སེད༌ ཟེར༌ཁན༌ཞིག༌ ཇོར༌། ཧ༌ཝའེ༌ ཟེརས༌, “ཀ༌ཡིན༌ནི༌ སད༌ཁན༌ ཨ༌བེལ༌ལི༌ ཚབས༌ལ༌ དཀོན༌མཆོག༌གི༌ ངའ༌ ཡང༌ བུ༌ཚ༌ཞིག༌ སལ༌ལ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","སེད༌ ཆེན༌མོ༌ སོང༌ཏེ༌ ཁོའེ༌ ན༌མའ༌ བུ༌ཚ༌ཞིག༌ སྐྱེས༌, ཡང༌ ཁོའེ༌ མིང༌ང༌ ཨེ༌ནོཤ༌ ཏགས༌། ཏེ༌ཏུས༌ནེ༌ ཕར༌ལ༌ མི༌གུན༌ནི༌ དཀོན༌མཆོག༌ག༌ ཡ༌ཝ༌ ཟེར༌ཨིན༌ ཅོལ༌ཅེས༌ གོ༌ཟུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","འི༌བོ༌ ཨ༌དམ༌མི༌ པུར༌གྱུད༌གུན༌ནི༌ སྐོར༌ལ༌ བྲིས༌ཁན༌ནི༌ ཐོ༌ ཨིན༌ནོག༌། དཀོན༌མཆོག༌གི༌ མི༌ ཛད༌ ཟ༌ནེ༌, ཁོང༌ངི༌ མི༌གུན༌ ཁོང༌རང༌ ཙོགས༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ཏེ༌གུན༌ ཁོང༌ངི༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཛད༌ཏེ༌ ཅིན༌ལབས༌ སལ༌ལ༌ ཛདས༌། ཡང༌ ཏེ༌གུན༌ ཛད༌ ཚར༌ར༌ཅིག༌, མི༌ ཟེར༌ཏེ༌ མིང༌ ཏག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ཨ༌དམ༌མ༌ ལོ༌ 130 ཆ༌ ཟ༌ནེ༌ ཁོ༌, ཁོ༌རང༌ངི༌ ཡིབས༌ དང༌ཙོགས༌ ཡོད༌ཁན༌ནི༌ ཕྲུ༌གུ༌ཞིག༌གི༌ ཨ༌བ༌ གྱུར༌། ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌བོའ༌ སེད༌ མིང༌ང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","སེད༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌, ཨ༌དམ༌ ཡང༌ ལོ༌ 800 སོན༌ཏེའ༌ ལུས༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ཨ༌དམ༌ ལོ༌ 930 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","སེད༌ལ༌ ལོ༌ 105 ཆ༌ ཟ༌ནེ༌ ཁོ༌, ཨེ༌ནོཤ༌ཤི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ཨེ༌ནོཤ༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌, སེད༌ ཡང༌ ལོ༌ 807 སོན༌ཏེའ༌ ལུས༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","སེད༌ ལོ༌ 912 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ཨེ༌ནོཤ༌ལ༌ ལོ༌ 90 ཆའ༌ ཟ༌ནེ༌ ཁོ༌, ཀེ༌ནན༌ནི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ཀེ༌ནན༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ཨེ༌ནོཤ༌, ཡང༌ ལོ༌ 815 སོན༌ཏེའ༌ ལུས༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ཨེ༌ནོཤ༌ ལོ༌ 905 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ཀེ༌ནན༌ལ༌ ལོ༌ 70 ཆ༌ ཟ༌ནེ༌, ཁོ༌ མ༌ཧ༌ལ༌ལེལ༌ལི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","མ༌ཧ༌ལ༌ལེལ༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ཀེ༌ནན༌, ཡང༌ ལོ༌ 840 སོན༌ཏེའ༌ ལུས༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ཀེ༌ནན༌ ལོ༌ 910 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","མ༌ཧ༌ལ༌ལེལ༌ལ༌ ལོ༌ 65 ཆ༌ ཟ༌ནེ༌, ཁོ༌ ཡེ༌རེད༌དི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ཡེ༌རེད༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ མ༌ཧ༌ལ༌ལེལ༌ ཡང༌ ལོ༌ 830 སོན༌ཏེའ༌ ལུས༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","མ༌ཧ༌ལ༌ལེལ༌ ལོ༌ 895 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ཡེ༌རེད༌ལ༌ ལོ༌ 162 ཆ༌ ཟ༌ནེ༌, ཁོ༌ ཨེ༌ནོག༌གི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ཨེ༌ནོག༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ཡེ༌རེད༌ ཡང༌ ལོ༌ 800 སོན༌ཏེའ༌ ལུས༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ཡེ༌རེད༌ ལོ༌ 962 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ཨེ༌ནོག༌ག༌ ལོ༌ 65 ཆ༌ ཟ༌ནེ༌ ཁོ༌ མ༌ཐུ༌ཤེ༌ལག༌གི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","མ༌ཐུ༌ཤེ༌ལག༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ལོ༌ 300 ཨེ༌ནོག༌གི༌ བྲེལ༌ དཀོན༌མཆོག༌ ཉམ༌པོ༌ མ༌ ཉེ༌མོ༌ ཡོད༌པིན༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ཨེ༌ནོག༌ ལོ༌ 365 སོན༌ཏེའ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","དཀོན༌མཆོག༌ དང༌ ཉེ༌མོ༌ བྲེལ༌ ཡོད༌དི༌ ཏུས༌, ཞག༌ཤིག༌ ཨེ༌ནོག༌ སྟོར༌ སོང༌, ཅིའ༌ཟེར༌ན༌ དཀོན༌མཆོག༌གི༌ ཁོ༌ ཁོང༌རང༌ ཡོད༌ས༌ ཁྱེར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","མ༌ཐུ༌ཤེ༌ལག༌ག༌ ལོ༌ 187 ཆ༌ ཟ༌ནེ༌ ཁོ༌ ལ༌མེག༌གི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ལ༌མེག༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ མ༌ཐུ༌ཤེ༌ལག༌, ཡང༌ ལོ༌ 782 སོན༌ཏེའ༌ ལུས༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","མ༌ཐུ༌ཤེ༌ལག༌ ལོ༌ 969 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ལ༌མེག༌ག༌ ལོ༌ 182 ཆ༌ ཟ༌ནེ༌, ཁོ༌ བུ༌ཚ༌ཞིག༌གི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ལ༌མེག༌གི༌ ཁོ༌རང༌ངི༌ བུ༌ཚའ༌ ནོ༌ཨ༌ མིང༌ང༌ ཏགས༌ཏེ༌, ཟེརས༌, “འི༌ བུ༌ཚ༌བོའེ༌ ང༌དང༌གུན༌, དཀོན༌མཆོག༌གི༌ ངན༌ ཏབ༌བ༌ ཛད༌ཁན༌ནི༌, འི༌ ས༌ཀྱད༌པོ༌ བད༌ཅེས༌སི༌ ནགས༌ དང༌ བར༌དོ༌ གུན༌ནི༌ ཀ༌ནེ༌ ཐར༌ཅུག༌ག༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ནོ༌ཨ༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ལ༌མེག༌ ཡང༌ ལོ༌ 595 སོན༌ཏེའ༌ ལུས༌། ཁོའ༌ ཞན༌ཡང༌ ཕྲུ༌གུ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ལ༌མེག༌ ལོ༌ 777 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ནོ༌ཨ༌ ལོ༌ 500 ཆའད༌པིན༌ ནམ༌, ཁོ༌ ཤེམ༌, ཧེམ༌ དང༌, ཡབ༌ཕེད༌ གུན༌ནི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","མི༌གུན༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཕེལ༌ཅེས༌ གོ༌ཟུག༌ ཟ༌ནེ༌ ཁོང༌གུན༌ལ༌ བུ༌མོ༌ མང༌པོའང༌ སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","དཀོན༌མཆོག༌གི༌ བུ༌ཚ༌གུན༌ནི༌ མིའི༌ བུ༌མོ༌གུན༌ མ༌ཛེས༌མོ༌ ཐོང༌པ༌, ཁོང༌གུན༌ནི༌ ཁོ༌རང༌ ཐད༌ཁན༌ནི༌ བུ༌མོ༌གུན༌ལ༌ ན༌མ༌ ཅོས༌ ཡང༌ ཏེ༌ བུ༌མོ༌གུན༌ནའང༌ ཏེ༌ཟུག༌ ཅོ༌ཅེས༌ལ༌ ཐད༌དད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོལས༌, “ངའེ༌ མི༌གུན༌ལ༌ ཏང༌ཁན༌ནི༌ ཏེ༌ མི༌ཚེ༌བོ༌ ཁོང༌གུན༌ནི༌ ནང༌ང༌ ཏུས༌གྱུན༌ནི༌ ཕིའ༌ ལུས༌ མི༌ཅུག༌, ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ ཏུས༌གྱུན༌ སོན༌ཏེའ༌ མི༌ལུས༌ཁན༌ནི༌ རིགས༌ནེ༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ ལོ༌ 120 མ༌ནེ༌ སོན༌ཏེའ༌ མི༌ལུས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ཏེ༌ཏུས༌ ཡང༌ སྟིང༌ནེའང༌, ནེ༌ཕི༌ལིམ༌ ཟེར༌ཁན༌ནི༌ མི༌ མ༌ ཆེན༌མོ༌གུན༌ ཇིག༌རྟེན༌ནི༌ཀ༌ དུག༌གད༌པིན༌, ཀ༌གུན༌ དཀོན༌མཆོག༌གི༌ བུ༌ཚ༌གུན༌ དང༌ མིའི༌ བུ༌མོ༌གུན༌ ཛོམས༌ཏེ༌ སྐྱེ༌ཁན༌ནི༌ ཕྲུ༌གུ༌གུན༌ ཨིན༌པིན༌། ཁོང༌གུན༌ ཏེན༌ན༌ ཏུས༌སི༌ སྤའ༌འོ༌གུན༌ དང༌ མག༌གི༌ ནང༌ང༌ ནོལ༌ཁན༌ མིང༌ཅན༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ཇིག༌རྟེན༌ནི༌ཀ༌ མི༌གུན༌ནི༌ ངན༌པ༌བོ༌ མངས༌ཏེའང༌ རྩོག༌པོ༌ ཡང༌ ཁོང༌གུན༌ནི༌ སམ༌བ༌ དང༌ དོད༌པ༌ ཚང༌མ༌ ཏུས༌གྱུན༌ ངན༌པ༌ ཅོ༌ཅེས༌ ཡོད༌ཁན༌ གུན༌ ཡ༌ཝའེ༌ ཟིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ཏེ༌ནེ༌ ཁོང༌ངི༌ འི༌ ཇིག༌རྟེན༌ནི༌ཀ༌ མི༌གུན༌ ཅོའ༌ ཛད༌ཁན༌བོའེ༌ཀ༌ ཡ༌ཝའ༌ མ༌སྲན༌ཏྲེ༌ གྱོད༌པ༌ སྐྱེའ༌ ཛདས༌, ཡང༌ ཁོང༌ངི༌ སེམས༌སི༌ ཏིང༌ང༌ སྲན༌ཏྲེ༌ རྡུག༌ངལ༌ ཇུང༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ཏེ༌བོའེ༌ ཞས༌ཏེ༌ ཡ༌ཝའེ༌ མོལས༌, “ངའེ༌ ཅོ༌ཁན༌ནི༌ མི༌ཚང༌མ༌ ཇིག༌རྟེན༌ནི༌ ཀ༌ནེ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། མི༌གུན༌ མ༌ཚད༌ སེམས༌ཅན༌ ཆེན༌མོ༌ དང༌ ཆུ༌ངུན༌ ཡང༌ ནམ༌མི༌ ནང༌ང༌ འུར༌ཁན༌ནི༌ ཅ༌ ཚང༌མའང༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། ཏེ༌གུན༌ ཅོ༌ཁན༌བོའེ༌ཀ༌ ངའ༌ མ༌ ཚེར༌ཁ༌ རག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ཨིན༌ནའང༌ ཡ༌ཝའ༌ ནོ༌ཨའེ༌ཀ༌ ཐུགས༌ཐདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","འི༌བོ༌ ནི༌ ནོ༌ཨའེ༌ མི༌ཚེའེ༌ སྐོར༌ལ༌ རུངས༌པོ༌ ཨིན༌ནོག༌། ཏེ༌ཏུས༌ལ༌ ནོ༌ཨ༌ ཅིག༌པོ༌ ནི༌ ཇིག༌རྟེན༌པ༌ ཚང༌མའེ༌ ནང༌ནེ༌ སྐྱོན༌མེད༌ཁན༌ དང༌ མི༌ ཀྲང༌པོ༌ཞིག༌ ཨིན༌པིན༌། ཁོའེ༌ བྲེལ༌ དཀོན༌མཆོག༌ ཉམ༌པོ༌ མ༌ ཉེ༌མོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ནོ༌ཨའ༌ བུ༌ཚ༌ སུམ༌, ཤེམ༌, ཧེམ༌ དང༌, ཡབ༌ཕེད༌ ཟེར༌ཁན༌གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ཏ༌ དཀོན༌མཆོག༌གི༌ འི༌ ཇིག༌རྟེན༌པ༌གུན༌ མ༌ ངན༌པ༌, ཛིང༌མོ༌ དང༌ ནོད༌སྐྱལ༌ཅེས༌ གུན༌ གངས༌ཏེ༌ ཟིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ཡང༌ དཀོན༌མཆོག༌གི༌ ཇིག༌རྟེན༌བོ༌ ངན༌པའེ༌ གངས༌ཏེ༌ ཟིགས༌, ཅིའ༌ཟེར༌ན༌ ཇིག༌རྟེན༌ནི༌ཀ༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མའེ༌ ངན༌པ༌ མི༌ཚེ༌ཞིག༌ ཕུད༌དད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ནོ༌ཨ༌ མོལས༌, “ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌, འུགས༌ ཡོད༌ཁན༌ ཚང༌མའ༌ སྲོའེ༌ གངས༌ཏེ༌, ཅིག༌ དང༌ ཅིག༌ག༌ ནོད༌སྐྱལ༌ པ༌སང༌, ངའེ༌ ཇིག༌རྟེན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོ༌ཅེས༌ལ༌ ཐག༌ཅད༌ཏེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“ཏེ༌བོའེ༌ཕིའ༌ ཁྱོ༌རང༌ངི༌ གོ༌ཕེར༌ ཟེར༌ཁན༌ནི༌ ཤིང༌ངི༌ མ༌ ཆེན༌མོ༌ གྲུ༌ཟིང༌ཞིག༌ རྩིག༌, ཡང༌ ཏེ༌ནང༌ང༌ ནང༌མིག༌ རིག༌ ཅོས༌། ཏེ༌ནེ༌ ཆུ༌ ནང༌ཀུག༌ག༌ མི༌ཡོང༌ཅེས༌སི༌ ཕིའ༌ ཕི༌ནང༌ ཉིས༌ཀོའ༌ ཏར༌ཀོལ༌ སྐུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","གྲུ༌ཟིང༌ངི༌ རིང༌བོ༌ མི༌ཀྲར༌ 135, ཞང༌བོ༌ མི༌ཀྲར༌ 22 དང༌ ཐོན༌བོ༌ མི༌ཀྲར༌ 13 ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ཡང༌ ཏེ༌ གྲུ༌ཟིང༌བོའ༌ ཐོག༌གའང༌ ཅོས༌, ཨིན༌ནའང༌ རྩིག༌པ༌ དང༌ ཐོག༌གི༌ ནང༌ང༌ མི༌ཀྲར༌ ཕེད༌དི༌ པར༌ བོར༌གོས༌། གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཐོག༌ཚད༌ སུམ༌ ཡང༌ ཆོགས༌ ཅིག༌ག༌ སྒོ༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“ཏ༌, འུགས༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོ༌ཅེས༌ལ༌ ངའེ༌ ཇིག༌རྟེན༌ གང༌པོ༌ ཆུ༌ལོག༌གི༌ཆུའི༌ གང༌ཅུག༌ཨིན༌། ཇིག༌རྟེན༌ནི༌ཀ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཤི༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ཨིན༌ནའང༌ ངའེ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཆད༌དོན༌ཞིག༌ ཅོའད༌, ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ ན༌མ༌, ཁྱོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ ན༌མ༌གུན༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ཡང༌ ཁྱོ༌རང༌ངི༌ སེམས༌ཅན༌ དང༌ ཅ༌ཅིའུ༌ རིགས༌ ཚང༌མའེ༌ ཕོ༌ དང༌ མོ༌ གུན༌ སོན༌ཏེའ༌ ལུས༌ཤེས༌ལ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཁྱོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ཅ༌ཅིའུ༌ རིགས༌ ཚང༌མའེ༌ ཆའ༌ཅིག༌, སེམས༌ཅན༌ ཆེན༌མོའེ༌ རིགས༌ ཚང༌མའེ༌ ཆའ༌ཅིག༌ དང༌, སེམས༌ཅན༌ ཆུ༌ངུན༌ནི༌ རིགས༌ ཚང༌མའེ༌ ཆའ༌ཅིག༌, སོན༌ཏེའ༌ ལུས༌ཤེས༌ལ༌ ཁྱོ༌རང༌ངི༌ཀ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ཡང༌ ཁྱོ༌རང༌ དང༌ ཏེ༌གུན༌ནི༌ ཟའ༌ཅེས༌སི༌ ཕིའ༌ སྣ༌ཚོགས༌སི༌ ཟ༌གྱུ༌ ཚང༌མ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ སག༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཅོས༌ མོལ༌ཁན༌ ཚང༌མ༌ ནོ༌ཨའེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ནོ༌ཨ༌ མོལ༌ལ༌ ཛདས༌, “ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ ནང༌ཚངས༌ གང༌པོ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ སོང༌ཤིག༌, ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ ངའ༌ ཁྱོ༌རང༌ མ༌ནེ༌ ཡང༌སུ༌ཞིག༌གའང༌ ཀྲང༌པོ༌ མི༌ཞིག༌ མ༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","རྩང༌མ༌ སེམས༌ཅན༌གུན༌ནི༌ ཕོ༌ དང༌ མོའེ༌ ཆ༌ རྡུན༌རྡུན༌, ཡང༌ རྩང༌མ༌ མན༌ཁན༌ སེམས༌ཅན༌གུན༌ནི༌ ཕོ༌ དང༌ མོའེ༌ ཆ༌ གུན༌, ཁྱོ༌རང༌ ཉམ༌པོ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཉེན༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ཡང༌ ཅ༌ཅིའུ༌གུན༌ནིའང༌ ཕོ༌ དང༌ མོའེ༌ ཆ༌ རྡུན༌ ཉེན༌། ཆུ༌ལོག༌གི༌ སྟིང༌ནེའང༌, ཇིག༌རྟེན༌ནི༌ཀ༌ སེམས༌ཅན༌ དང༌ ཅ༌ཅིའུ༌ གུན༌ནི༌ རིགས༌ ཚང༌མ༌ སོན༌ཏེའ༌ ལུས༌ཤེས༌སི༌ ཕིའ༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ ཟེར༌ཁན༌གུན༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ཞག༌མ༌ རྡུན༌ནི༌ སྟིང༌ནེ༌, ངའེ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཚན༌ཉིན༌ 40 ཆར༌པ༌ ཏང༌ཅུགས༌ཏེ༌, ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ ངའེ༌ ཅོ༌ཁན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ནོ༌ཨའེ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ལ༌ ཛད༌ཁན༌ ཚང༌མ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ནོ༌ཨའ༌ ལོ༌ 600 ཆའད༌པིན༌ ནམ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཆུ༌ལོག༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ཆུ༌ལོག༌ནེ༌ ཐར༌ཅེས༌ལ༌ ནོ༌ཨ༌, ཁོ༌རང༌ངི༌ ན༌མ༌, ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ ན༌མ༌གུན༌ ཉམ༌པོ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཞུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","རྩང༌མ༌ དང༌ རྩང༌མ༌ མན༌ཁན༌ནི༌ སེམས༌ཅན༌ ཆེན༌མོ༌, ཅ༌ཅིའུ༌ དང༌ སའེ༌ཀ༌ གྲུལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཆུ༌ངུན༌ ཚང༌མ༌, ");
INSERT INTO lbj_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ཕོ༌ དང༌ མོའེ༌ ཆ༌ ཅོས༌ཏེ༌ དཀོན༌མཆོག༌གི༌ བཀའ༌ ནང༌ཞིན༌ ནོ༌ཨ༌ ཡོད༌སའེ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ཏེ༌ནེ༌ ཞག༌མ༌ རྡུན༌ནི༌ སྟིང༌ནེ༌, ཇིག༌རྟེན༌བོ༌ ཆུ༌ལོག༌གི༌ ཆུའི༌ གང༌ཅེས༌ གོ༌ཟུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ནོ༌ཨའ༌ ལོ༌ 600 ཆའེ༌ ཞག༌ག༌ ཀ༌བོ༌ ཟླ༌ཝ༌ ཉིས༌པའི༌ ཞག༌མ༌ 17 པ༌ ཨིན༌པིན༌ ཏེ༌ ཞག༌ག༌ སའེ༌ ཐིལ༌ལ༌ ཡོད༌ཁན༌ནི༌ ཆུ༌ ཚང༌མ༌ ས༌ཀྱད༌ ཡས༌ཏེ༌ བིངས༌ཏེ༌ ཡོངས༌, ཡང༌ ནམ༌ཁའ༌ནེ༌ ཆར༌པ༌བོ༌ ཆུ༌ལོག༌ ཡོང༌ང༌ ཙོགས༌ལ༌ བབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ཇིག༌རྟེན༌ནི༌ཀ༌ ཚན༌ཉིན༌ 40 ཆད༌མེད༌ལ༌ ཆར༌པ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ཆར༌པ༌ བབས༌ཤེས༌ གོ༌ཟུག༌ ཆའེ༌ ཞག༌ག༌, ནོ༌ཨ༌, ཁོའེ༌ ན༌མ༌, བུ༌ཚ༌ ཤེམ༌, ཧེམ༌ དང༌, ཡབ༌ཕེད༌ སུམ༌ཀོ༌ ཡང༌ ཁོང༌གུན༌ནི༌ ན༌མ༌གུན༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཞོནས༌, ");
INSERT INTO lbj_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ཁོང༌གུན༌ ཉམ༌པོ༌ སེམས༌ཅན༌ནི༌ རིགས༌ ཚང༌མའེ༌ ཆའ༌ཅིག༌ ཡོད༌པིན༌: སྲལ༌ཁན༌ དང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ ཆེན༌མོ༌ དང༌ ཆུ༌ངུན༌ གུན༌, ཡང༌ ཅ༌ཅིའུ༌འི༌ རིགས༌ ཚང༌མ༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","འུགས༌ ལེན༌ཁན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཉིས༌ཉིས༌སི༌ ཆ༌ ཅོས༌ཏེ༌ ནོ༌ཨ༌ ཉམ༌པོ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","རིགས༌ ཚང༌མའེ༌ ཕོ༌ དང༌ མོ༌ རེ༌རེ༌ ཡོངས༌, ཀ༌ཟུག༌གི༌ ནོ༌ཨའ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ཁོང༌ ཚང༌མ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཞུགས༌ ཚར༌ར༌ཅིག༌, ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ སྒོ༌བོ༌ ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ཞག༌མ༌ 40 ཇིག༌རྟེན༌ནི༌ཀ༌ ཆར༌པ༌ ཆད༌མེད༌ལ༌ བབས༌, ཡང༌ ཆུ༌ལོག༌གི༌ ཆུ༌ ཕེལ༌པ༌ ས༌ཀྱད༌ ཆུའི༌ གངས༌ཏེ༌ གྲུ༌ཟིང༌བོ༌ ས༌ཀྱད༌ནེ༌ ཐོན༌པོའ༌ སྟགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","སའེ༌ཀ༌ ཆུ༌ མང༌ནེ༌ མང༌ང༌ ཕེལ༌ཨིན༌ སོང༌པ༌ གྲུ༌ཟིང༌བོ༌ ཆུའི༌ ཁེ༌ཐོག༌ག༌ ཇིགས༌པ༌ མེད༌པ༌ ལྡིངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","སྟིང༌ཇུག༌ག༌ ཇིག༌རྟེན༌ནི༌ རི༌ ཐོ༌ཤོག༌གུན༌ནའང༌ ཆུའི༌ ནང༌ང༌ ནུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ཆུ༌ ཕེལ༌ཨིན༌ སོང༌ཏེ༌, རི༌ ཐོ༌ཤོག༌གུན༌ནི༌ སང༌ མི༌ཀྲར༌ 6 ཐོའ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ཇིག༌རྟེན༌ནི༌ཀ༌ ཡོད༌ཁན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཤི༌: ཅ༌ཅིའུ༌, སྲལ༌ཁན༌ དང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌, སའེ༌ཀ༌ གྲུལ༌ཁན༌ནི༌ ཆུ༌ངུན༌ སེམས༌ཅན༌ དང༌, མི༌ཚང༌མ༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ས༌ སྐམ༌པོའེ༌ཀ༌ དུག༌ཁན༌ནི༌ འུགས༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ཡ༌ཝའེ༌ ཇིག༌རྟེན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོའ༌ ཛདས༌: མི༌གུན༌, སྲལ༌ཁན༌ དང༌ སའེ༌ཀ༌ གྲུལ༌ཁན༌ནི༌ ཆུ༌ངུན༌ སེམས༌ཅན༌ གུན༌ དང༌ ནམ༌མི༌ ཅི༌པ༌ ཚང༌མ༌། ཏེ༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོའ༌ ཛདས༌། ནོ༌ཨ༌ དང༌ ཁོ༌ ཉམ༌པོ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཡོད༌ཁན༌གུན༌ མ༌སྟོགས༌ སུ༌ཞིག༌གའང༌ སོན༌ཏེའ༌ མ༌ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ཡང༌ ས༌ཀྱད༌པོ༌ ཞག༌མ༌ 150 ཆུའི༌ ནང༌ང༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ནོ༌ཨ༌ དང༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ སྲལ༌ཁན༌ དང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ ཚང༌མའ༌ རྗེད༌ད༌ མ༌ཛདས༌། ཁོང༌ངི༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ལུངས༌པོ༌ ཀལ༌ལ༌ ཛད༌པ༌, ཆུ༌ལོག༌གི༌ ཆུ༌ ཉུ༌ངུན༌ ཆ༌ཅེས༌ གོ༌ཟུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ཁོང༌ངི༌ སའེ༌ ཐིལ༌ནེ༌ བིང༌སའེ༌ ཆུའི༌ ནས༌ས༌གུན༌ ཀག༌ག༌ ཛདས༌, ཡང༌ ནམ༌ཁའ༌ནེ༌ ཆུ༌ལོག༌ ཙོགས༌སི༌ ཆར༌པ༌ ཆད༌ ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ཇིག༌རྟེན༌ནི༌ ནང༌ང༌ གངས༌ཁན༌ནི༌ ཆུ༌ལོག༌གི༌ ཆུ༌ ཚང༌མ༌ ཐིམས༌ཨིན༌ ཉུ༌ངུན༌ ཆེན༌ སོང༌། ཞག༌མ༌ 150 སྟིང༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ཆུ༌ལོག༌ གོ༌ཟུགས༌ཏེ༌, ཟླ༌ཝ༌ 7 པའེ༌ ཞག༌མ༌ 17 ནི༌ ཞག༌ག༌ གྲུ༌ཟིང༌བོ༌ ཨ༌ར༌རད༌ ཟེར༌ཁན༌ནི༌ རི༌གྱུད༌གུན༌ནི༌ཀ༌ ཁད༌ཏེ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ཡང༌ ཆུ༌གུན༌ ཆད༌མེད༌ལ༌, ཟླ༌ཝ༌ 10 ཚོག༌པ༌ ཉུ༌ངུན༌ ཆེན༌ སོང༌། ཏེ༌ནེ༌ ཏེན༌ན༌ ཟླ༌ཝའེ༌ གོ༌མའེ༌ ཞག༌ག༌, རིའི༌ གོ༌གུན༌ ཆུ༌ནེ༌ ཕི༌ལོག༌ག༌ བིང༌ཏེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","རི༌ གོ༌གུན༌ ཐོང༌ཏེ༌ ཞག༌མ༌ 40 སྟིང༌ནེ༌, ནོ༌ཨའེ༌ ཁོ༌རང༌ངི༌ ཅོས༌ཁན༌ནི༌ གྲུ༌ཟིང༌ངི༌ ཀར༌ཁུང༌བོ༌ ཕེས༌ཏེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ཕོ༌རོག༌ཞིག༌ ཕུདས༌། ཁོ༌ ཆུ༌ སྐམས༌ཏེ༌ ས༌ཀྱད༌ བིང༌བིང༌ འུར༌ཨིན༌ དུགས༌ཏེ༌, གྲུ༌ཟིང༌ངི༌ཀ༌ ལོགས༌ཏེ༌ མ༌ནེ༌ མ༌ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ཏེ༌ནེ༌ ནོ༌ཨའེ༌ ཆུ༌ སྐམས༌ཏེ༌ ས༌ཀྱད༌ སྐམ༌པོ༌ བིངས༌ཏེ༌ དུག༌ག༌ ལྟ༌ཅེས༌ལ༌ ཕུར༌གོན༌ཞིག༌ ཕུདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ཨིན༌ནའང༌ ཕུར༌གོན༌ལ༌ རང༌ངི༌ རྐང༌པ༌ བོར༌ཅེས༌ལ༌ ནས༌ས༌ མ༌ཐོབ༌, ཅིའ༌ཟེར༌ན༌ ཇིག༌རྟེན༌ ཏ༌རུང༌ངའང༌ ཆུའི༌ ནང༌ང༌ ནུབས༌ཏེ༌ ཡོད༌པིན༌། ཕུར༌གོན༌བོ༌ ནོ༌ཨ༌ ཡོད༌ས༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ལོགས༌ཏེ༌ ཡོངས༌པ༌, ནོ༌ཨའེ༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཕི༌ལོག༌ག༌ ཕིངས༌ཏེ༌, ཕུར༌གོན༌བོ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ཞག༌པོ༌ རྡུན༌ སྲིངས༌ཏེ༌ སྟིང༌ནེ༌, ནོ༌ཨའེ༌ ཕུར༌གོན༌བོ༌ ཡང༌སྐྱར༌ ཕུདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ཕི༌ཏོག༌ ཕུར༌གོན༌བོ༌ ལོགས༌ཏེ༌ ཡོང༌ ཟ༌ནེ༌, ཁོའེ༌ ཁམ༌ཅུའི༌ ནང༌ང༌ ཨོ༌ལིཝ༌ཝི༌ ལྕང༌མའེ༌ ལོ༌མ༌ སྔོན༌པོ༌ཞིག༌ ཁུར༌ཏེ༌ ཐོང༌པ༌, ནོ༌ཨའ༌, ཇིག༌རྟེན༌ནི༌ ཀ༌ནེ༌ ཆུ༌ ཧ༌ལམ༌ ཚར༌ཏེ༌ ཨིན༌ཅེས༌པོ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ཏེ༌ནེ༌ ཡང༌ཞག༌པོ༌ རྡུན༌ སྲིངས༌ཏེ༌, ཁོའེ༌ ཕུར༌གོན༌བོ༌ ཡང༌ ལམ༌ཅུགས༌, ཨིན༌ནའང༌ འི༌ ལན༌ ཁོ༌ ནོ༌ཨའེ༌ཀ༌ ལོགས༌ཏེ༌ མ༌ནེ༌ མ༌ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ཏ༌ ནོ༌ཨ༌ ལོ༌ 601 སོང༌ཏེ༌, ཟླ༌ཝ༌ ཀྲང༌པོའེ༌ གོ༌མའེ༌ ཞག༌ག༌, ས༌ཀྱད༌དི༌ ཀ༌ནེ༌ ཆུ༌ ཚང༌མ༌ ཧ༌ལམ༌ སྐམས༌ཏེ༌ ཡོད༌པིན༌། ནོ༌ཨའེ༌ གྲུ༌ཟིང༌ངི༌ཀ༌ ཀབས༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ཐེན༌ཏེ༌ ལྟས༌པ༌, ས༌ཀྱད༌ ཚང༌མ༌ སྐམས༌ཨིན༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ཏེ༌བོའེ༌ སྟིང༌ནེ༌ ཧ༌ལམ༌ ཟླ༌ཝ༌ 2 ནེ༌, ས༌ཀྱད༌ གང༌པོ༌ སྐམ༌པོ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ནོ༌ཨའ༌ མོལ༌ལ༌ ཛདས༌, ");
INSERT INTO lbj_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ཁྱོ༌རང༌, ཁྱོ༌རང༌ངི༌ ན༌མ༌, བུ༌ཚ༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ ན༌མ༌གུན༌ གྲུ༌ཟིང༌ནེ༌ བིངས༌ཏེ༌ ཡོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ཡང༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌: ཅ༌ཅིའུ༌, སེམས༌ཅན༌ ཆེན༌མོ༌ དང༌ ཆུ༌ངུན༌ སའེ༌ཀ༌ གྲུལ༌ཁན༌ ཚང༌མ༌ ཕི༌ལོག༌ག༌ ཕིང༌། ཁོང༌གུན༌ གྱས༌ཏེ༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ ཕེལ༌ཅེས༌སི༌ ཕིའ༌ ཏེ༌ཟུག༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ཏེ༌ནེ༌ ནོ༌ཨ༌, ཁོ༌རང༌ངི༌ ནང༌ཚངས༌ ཉམ༌པོ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ནེ༌ བིངས༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ཡང༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཆེན༌མོ༌ དང༌ ཆུ༌ངུན༌ སེམས༌ཅན༌ དང༌ ཅ༌ཅིའུ༌ ཚང༌མ༌ ཉིས༌ཉིས༌སི༌ ཆ༌ ཅོས༌ཏེ༌ བིང༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ཏེ༌ནེ༌ ནོ༌ཨའེ༌ ཡ༌ཝའ༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ ནས༌ས༌ཞིག༌ རྩིགས༌། ཁོའེ༌ རྩང༌མ༌ སེམས༌ཅན༌ དང༌ ཅ༌ཅིའུ༌ གུན༌ནི༌ ནང༌ནེ༌ སྣ༌རེ༌རེ༌ ཁྱོངས༌ཏེ༌ སདས༌ ཡང༌ མེའ༌ སྲགས༌ཏེ༌ ཆོད༌པ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ཡ༌ཝའ༌ ཏེ༌ ཆོད༌པའེ༌ ཏྲི༌ཞིམ༌བོ༌ ཚོར༌ར༌ཅིག༌, ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ སེམས༌སི༌ ནང༌ང༌ མོལ༌ལ༌ ཛད༌, “མི༌གུན༌ནི༌ ཞས༌ཏེ༌ ངའེ༌ འི༌ ཇིག༌རྟེན༌བོ༌ ཡང༌ ཆུ༌ ཉམ༌པོ༌ མ༌ནེ༌ མེད༌ཁན༌ མི༌ཅོ༌། ཆུ༌ངུན༌ནི༌ ཏུས༌ནེ༌ ཕར༌ལ༌, མི༌གུན༌ནི༌ སྙིང༌པོ༌ ངན༌པའེ༌ ཆོགས༌ལ༌ ཡོད༌ནའང༌, ངའེ༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ མ༌ནེ༌ མི༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ཇིག༌རྟེན༌བོ༌ ལུས༌ལུས༌ ཚོག༌པ༌, ཞིང༌ ཏབ༌ཅེས༌ དང༌ རྔོ༌ཅེས༌, ཚད༌ དང༌ གྲང༌མོ༌, ཡར༌ དང༌ དགུན༌, ཡང༌ ཉི༌མ༌ དང༌ ཚན༌ནི༌ ཏུས༌ གུན༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","དཀོན༌མཆོག༌གི༌ ནོ༌ཨ༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ མོལ༌ལ༌ ཛདས༌, “ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ ཕེལ༌ཅེས༌སི༌ ཕིའ༌ ཕྲུ༌གུ༌ མང༌པོ༌ སྐྱེ༌ཅུག༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","སའེ༌ཀ༌ དུག༌ཁན༌ནི༌ སེམས༌ཅན༌, ནམ༌ཁའེ༌ ཅ༌, སའེ༌ཀ༌ གྲུལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཆུ༌ངུན༌ དང༌ ཆུའི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཉ༌ ཚང༌མའ༌ ཁྱོ༌རང༌གུན༌ནི༌ ཇིགས༌སི༌ ནང༌ང༌ དུག༌ཨིན༌། ངའེ༌ ཏེ༌ ཚང༌མ༌ ཁྱོ༌ཞའེ༌ ཝང༌ངི༌ ཡོག༌ག༌ ཏང༌ངད༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ངའེ༌ སྲོག༌ ཡོད༌ཏེ༌ གྲུལ༌ཁན༌ ཚང༌མ༌ ཁྱོ༌ཞའ༌ ཟའ༌ཅེས༌ལ༌ ཏང༌ངད༌, ཀ༌ཟུག༌གི༌ ངའེ༌ ཁྱོ༌ཞའ༌ སྔོན༌པོའེ༌ རིགས༌ དང༌ ཀྲོ༌ནས༌ ཚང༌མ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ཟའ༌ཅེས༌ལ༌ ཏ༌ ངའེ༌ ཁྱོ༌ཞའ༌ ཅི༌ཚང༌མ༌ ཏང༌ངད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“ཨིན༌ནའང༌ ཁྲག༌ ཡོད༌ཁན༌ནི༌ ཤ༌ ཟའ༌ མ༌གོས༌, ཅིའ༌ཟེར༌ན༌ སྲོག༌པོ༌ ཁྲག༌གི༌ ནང༌ང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ཀལ༌ཏེས༌ མི༌ཞིག༌གི༌ སྲོག༌ ལེན༌ན༌, ཏེ༌ སྲོག༌ ལེན༌ཁན༌བོའ༌ ཤི༌ཅེས༌སི༌ ཆད༌པ༌ ཕོག༌གོས༌། སེམས༌ཅན༌ ཨིན༌གྲོ༌ ཡ༌ མི༌, མི༌ སད༌ཁན༌བོ༌ སད༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“མི༌ སད༌ཁན༌བོའ༌ ཤི༌ཅེས༌སི༌ ཆད༌པ༌ ཞན༌ཡང༌ མི༌གུན༌ནི༌ ཏང༌གོས༌, ཅིའ༌ཟེར༌ན༌ དཀོན༌མཆོག༌གི༌ མི༌བོ༌ ཁོང༌རང༌ ཙོགས༌ ཅོའ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ཡང༌ ཁྱོ༌ཞ༌གུན༌, ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ ཕེལ༌ཅེས༌སི༌ ཕིའ༌ ཕྲུ༌གུ༌ མང༌པོ༌ སྐྱེ༌ཅུག༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ནོ༌ཨ༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ཏ༌ ངའེ༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ ཏངས༌ཁན༌ནི༌ ཆད༌དོན༌བོ༌ ཏན༌ཏན༌ ཅོའད༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ཏེ༌ ཆད༌དོན༌བོ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ གྲུ༌ཟིང༌ངི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌: སྲལ༌ཁན༌ དང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌, དང༌ ཅ༌ཅིའུ༌ ཡང༌ན༌ ཇིག༌རྟེན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མའེ༌ ཕིའང༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","འོ༌ན༌, ངའེ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌བོ༌ སྟན༌པོ༌ ཅོའད༌། ཏ༌ནེ༌ཕར༌ལ༌ ཆུ༌ལོག༌གི༌ ཆུའི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ མ༌ནེ༌ མི༌ཅོ༌། འི༌ ཇིག༌རྟེན༌བོ༌ ཆུ༌ལོག༌གི༌ ཆུ༌ གྱུད༌ཏེ༌ མེད༌ཁན༌ མ༌ནེ༌ མི༌ཆ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","དཀོན༌མཆོག༌གི༌ མོལས༌ལ༌ ཛདས༌, “འི༌བོ༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ དང༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌, ཡང༌ ཡོང༌ཅེས༌ཅན༌ནི༌ ཏུས༌སི༌ མིར༌གྱུད༌ ཚང༌མ༌ ཉམ༌པོ༌ ཅོས༌ཁན༌ནི༌ ཆད༌དོན༌ནི༌ སྟགས༌པོ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ངའེ༌ ནམ༌ཁའེ༌ ནང༌ང༌ ཟའ༌ཆུ༌ཐུང༌ཞིག༌ ཤར༌ཅུག༌ཨིན༌, ཏེ༌བོ༌ ཁྱོ༌ཞའ༌ དང༌ ཇིག༌རྟེན༌ གང༌པོ༌ ཉམ༌པོ༌ ངའེ༌ ཆད༌དོན༌ ཅོ༌ཁན༌ནི༌ སྟགས༌པོ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ངའེ༌ སྲིན༌ ཀལ༌ཏེ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཆར༌པ༌ ཕབས༌ཏེ༌, ནམ༌མི༌ ནང༌ང༌ ཟའ༌ཆུ༌ཐུང༌ ཐོང༌ ཟ༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ངའ༌ ཁྱོ༌ཞའ༌ དང༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཉམ༌པོ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌བོ༌ ཨིད༌ཏུ༌ ཡོང༌ཨིན༌། ཆུ༌ལོག༌གི༌ ཆུའི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཡང༌སྐྱར༌ མེད༌ཁན༌ མ༌ནེ༌ མི༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ཟའ༌ཆུ༌ཐུང༌ ནམ༌མི༌ ནང༌ང༌ ཤར༌ཏེ༌ ཐོང༌ང༌ཅིག༌, ངའ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཡོད༌ཁན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཉམ༌པོ༌ ངའེ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌བོ༌ ཨིད༌ཏུ༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","དཀོན༌མཆོག༌གི༌ ནོ༌ཨ༌ མོལས༌ལ༌ ཛདས༌, “འི༌ ཟའ༌ཆུ༌ཐུང༌བོ༌ ངའེ༌ ཇིག༌རྟེན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཉམ༌པོ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌ནི༌ སྟགས༌པོ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","གྲུ༌ཟིང༌ངི༌ ནང༌ནེ༌ བིང༌ཁན༌ནི༌ ནོ༌ཨའེ༌ བུ༌ཚ༌གུན༌ ནི༌, ཤེམ༌, ཧེམ༌ དང༌ ཡབ༌ཕེད༌ གུན༌ ཨིན༌པིན༌། ༼ཧེམ༌ ཀེ༌ནན༌ ནི༌ ཨ༌བ༌ ཨིན༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ནོ༌ཨའེ༌ འིན༌ན༌ བུ༌ཚ༌ སུམ༌ཀོའེ༌ ཀ༌ནེ༌ ཇིག༌རྟེན༌ནི༌ ནང༌ང༌ མི༌ཚང༌མ༌ ཕེལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ཞིང༌བད༌པ༌ ནོ༌ཨ༌ ནི༌ རྒུན༌ཚས༌ ཏབ༌ཁན༌ ཏང༌པོ༌ མི༌བོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ཞག༌ཤིག༌, ཁོ༌ རྒུན༌ནི༌ ཆང༌ ཐུངས༌ཏེ༌ ར༌རོས༌པ༌, ཁོ༌ ལྗེར༌ཉལ༌ལ༌ ཁོ༌རང༌ངི༌ ཀུར༌རི༌ ནང༌ང༌ ཉིད༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ཀེ༌ནན༌ནི༌ ཨ༌བ༌, ཧེམ༌, ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ ཀུར༌རི༌ ནང༌ང༌ སོང༌པ༌, ཨ༌བ༌ ལྗེར༌ཉལ༌ལ༌ ཡོད༌ཁན༌བོ༌ ཐོང༌། ཁོ༌ ཕི༌ལོག༌ག༌ ཡོངས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཉིས༌ཀོའ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ཏེ༌ནེ༌ ཤེམ༌ དང༌ ཡབ༌ཕེད༌དི༌ རས༌ ཆེན༌མོ༌ཞིག༌ ཁོ༌རང༌གུན༌ནི༌ སྤུང༌པའེ༌ཀ༌, ལག༌པ༌ ཉམ༌པོ༌ ཟུམས༌ཏེ༌ གྱབ༌ལོག༌ག༌ ཀུར༌རི༌ ནང༌ང༌ ཨ༌བ༌ ཡོད༌ས༌ སོང༌ཏེ༌, ནོ༌ཨ༌ ལྗེར༌ཉལ༌ ཡོད༌ཁན༌བོ༌ ཀབས༌། ཏེ༌ཟུག༌ ཅོ༌ ཟ༌ནེ༌ ཨ༌བ༌ ལྗེར༌ཉལ༌ལ༌ མི༌ཐོང༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌གུན༌ནི༌ ལྡོང༌བོ༌ ཨ༌བ༌ མེད༌ས༌ ཆོགས༌ལ༌ གྱུརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ནོ༌ཨ༌ ར༌ཞུ༌ཏེ༌ ཉིད༌ཚད༌ད༌དང༌, ཁོའ༌ ཁོའེ༌ བུ༌ཚ༌ ཆུང༌ཤོག༌པོའེ༌ ཁྲེལ༌བའེ༌ ལས༌ ཅོས༌ཁན༌བོ༌ གྱུས༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ཡང༌ ཁོའེ༌ ཟེརས༌, “ཧམ༌མི༌ བུ༌ཚ༌ ཀེ༌ནན༌ དང༌ ཁོའེ༌ པུར༌གྱུད༌གུན༌ལ༌ ངན༌ ཕོག༌ཤིག༌། ཁོང༌གུན༌ ཁོང༌ངི༌ ཨ༌ཅོ༌གུན༌ནི༌ ཚེ༌ཡོག༌ ཚང༌མའེ༌སང༌ རྩི༌ཝ༌ མེད༌ཁན༌བོ༌ གྱུར༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ནོ༌ཨའེ༌ ཡང༌ ཟེརས༌, “ཡ༌ཝ༌, ཤེམ༌མི༌ དཀོན༌མཆོག༌ག༌ སྟོད༌པ༌ ཐོབ༌ཤིག༌, ཡང༌ ཀེ༌ནན༌ ཁོའེ༌ ཚེ༌ཡོག༌ གྱུར༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","དཀོན༌མཆོག༌གི༌ ཡབ༌ཕེད༌དི༌ མིར༌གྱུད༌གུན༌ ཕེལ༌ཅུག༌ཤིག༌། ཡབ༌ཕེད༌ དང༌ ཤེམ༌མི༌ མིར༌གྱུད༌གུན༌ནི༌ མི༌ཚེ༌ ཉམ༌པོ༌ ཕུད༌ཤིག༌། ཡང༌ ཀེ༌ནན༌པ༌གུན༌ ཡབ༌ཕེད༌དི༌ པུར༌གྱུད༌གུན༌ནི༌ ཚེ༌ཡོག༌ གྱུར༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ཆུ༌ལོག༌གི༌ སྟིང༌ནེ༌ ནོ༌ཨ༌ ཡང༌ ལོ༌ 350 སོན༌ཏེའ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ཁོ༌ ལོ༌ 950 སོན༌ཏེའ༌ ལུས༌ ཏེ༌ནེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","འི༌གུན༌ ནི༌ ནོ༌ཨའེ༌ བུ༌ཚ༌ ཤེམ༌, ཧེམ༌ དང༌ ཡབ༌ཕེད༌ གུན༌ནི༌ མིར༌གྱུད༌གུན༌ ཨིན༌ནོག༌། ཆུ༌ལོག༌གི༌ སྟིང༌ནེ༌, ཁོང༌གུན༌ལ༌ ཕྲུ༌གུ༌ མང༌པོ༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ཡབ༌ཕེད༌ ནི༌, གོ༌མེར༌, མ༌གོག༌, མ༌དའི༌, ཡ༌ཝན༌, ཏུ༌བལ༌, མེ༌ཤེག༌ དང༌ ཀྲི༌རས༌ གུན༌ནི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","གོ༌མེར༌ ནི༌, ཨེཤ༌ཀི༌ནེཟ༌, རི༌ཕད༌ དང༌ ཏོ༌གར༌མ༌ གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ཡ༌ཝན༌ ནི༌, ཨེ༌ལི༌ཤ༌, ཏར༌ཤིཤ༌, ཀིཏ༌ དང༌ རོ༌ད༌ གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ཡ༌ཝན༌ ནི༌, ཚོའེ༌ ཐའ༌མ༌ དང༌ ཚོ༌ལིང༌ངི༌ཀ༌ དུག༌ཁན༌ནི༌ མིར༌གྱུད༌ གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། འི༌གུན༌ ཡབ༌ཕེད༌དི༌ མིར༌གྱུད༌གུན༌ ཨིན༌ནོག༌ ཀ༌གུན༌ལ༌ རང༌རང༌ངི༌ རིགས༌, སྐད༌ དང༌ ཡུལ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ཧེམ༌མི༌ བུ༌ཚ༌གུན༌ ཀུཤ༌, ཨི༌ཇིབ༌, ཕུཏ༌ དང༌ ཀེ༌ནན༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ཀུཤ༌ ནི༌ སི༌བ༌, ཧ༌ཝི༌ལ༌, སབ༌ཏ༌, ར༌མཧ༌ དང༌ སབ༌ཏི༌ཀ༌ གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ཡང༌ ར༌མཧ༌ ནི༌ ཤི༌བ༌ དང༌ དི༌དན༌ གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ཀུཤ༌ ནིམ༌རོད༌དི༌ ཨ༌བ༌ གྱུར༌། ནིམ༌རོད༌ ནི༌ ཇིག༌རྟེན༌ནི༌ ནང༌ང༌ ཞན༌ཡང༌ མིར༌གྱུད༌གུན༌ལ༌ ཕམ༌ཀལ༌ཁན༌ནི༌ མག༌མི༌ མ༌ ཀྲག༌པོ༌ ཏང༌པོ༌བོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ནིམ༌རོད༌ ནི༌ ལིངས༌པ༌ མ༌ ཁས༌པ༌ཞིག༌གའང༌ ཨིན༌པིན༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ མི༌གུན༌ནི༌, “ཁོ༌ ཇིག༌རྟེན༌ནི༌ ལིངས༌པ༌ ཀྲག༌པོ༌, ནིམ༌རོད༌ ཙོགས༌ དུག༌” ཟེར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ཏང༌པོ༌རང༌ ཁོའེ༌ ཝང༌སྲུལ༌ཁན༌ནི༌ གྱལ༌ས༌གུན༌ ནི༌, ཤི༌ནར༌རི༌ ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ བ༌བེལ༌, ཨི༌རིག༌, ཨ༌ཀད༌ དང༌ ཀལ༌ནེཧ༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ཏེ༌ཀ༌ནེ༌ ཁོའེ༌ ཨ༌སི༌རི༌ཡཱའེ༌ ཡུལ༌ལི༌ ནང༌ང༌ ཁོ༌རང༌ངི༌ གྱལ༌སྲིད༌པོ༌ གྱས༌ཅུགས༌ཏེ༌ ནི༌ནེ༌ཝ༌, རེ༌ཧོ༌བོཐ༌ འིར༌ དང༌ ཀ༌ལའ༌ ཟེར༌ཁན༌ནི༌ གྱལ༌ས༌གུན༌ རྩིག༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ཡང༌ ནི༌ནེ༌ཝ༌ དང༌ ཀ༌ལའ༌ ཉིས༌ཀོའེ༌ ཞུང༌ང༌ ཆགས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ རི༌སིན༌ ཟེར༌ཁན༌ནི༌ གྱལ༌ས༌ ཀྲག༌པོ༌བོའང༌ རྩིག༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ཨི༌ཇིབ༌ ནི༌ ལུད༌པ༌གུན༌, ཨ༌ནམ༌པ༌གུན༌, ལེ༌ཧབ༌པ༌གུན༌, ནབ༌ཏུ༌པ༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ཕ༌ཏུ༌རུས༌པ༌གུན༌, ཀེས༌ལུ༌པ༌གུན༌ ༼ཀ༌བོའེ༌ པུར༌གྱུད༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ ཨིན༌ནོག༌༽ དང༌ ཀེབ༌ཐོར༌པ༌གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ཀེ༌ནན༌ ནི༌, སི༌དོན༌ ༼ཁོའེ༌ བུ༌ཚ༌ གོ༌བུ༌༽ དང༌ ཧེད༌ གུན༌ནི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ཀེ༌ནན༌ ནི༌ ཡེ༌བས༌པ༌གུན༌, ཨ༌མོར༌པ༌གུན༌, གིར༌གཤ༌པ༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ཧིཝ༌པ༌གུན༌, ཨར༌ཀ༌པ༌གུན༌, སིན༌པ༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ཨར༌བིད༌པ༌གུན༌, ཟི༌མར༌པ༌གུན༌ དང༌ ཧ༌མད༌པ༌གུན༌ནིའང༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། སྟིང༌ནེ༌ ཀེ༌ནན༌ནི༌ མིར༌གྱུད༌གུན༌ ནས༌ས༌ མང༌པོའེ༌ ནང༌ང༌ ཕེལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ཡང༌ ཀེ༌ནན༌པ༌གུན༌ནི༌ དུག༌སའེ༌ ས༌ཀྱད༌པོ༌ སི༌དོན༌ནེ༌ ཏངས༌ཏེ༌ གེ༌རར༌, མ༌ཚད༌ ག༌ཟ༌ ཚོག༌པའང༌ ཕེལ༌ཏེ༌ སོང༌། ཡང༌ ཤར༌ ཆོགས༌ལ༌ སོ༌དོམ༌, གོ༌མོ༌ར༌, ཨད༌མཧ༌, ཟི༌བོ༌ཡིམ༌ དང༌ ལ༌ཤ༌ ཚོག༌པའང༌ ཕེལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ཏེ༌གུན༌ ནི༌, ཧེམ༌མི༌ པུར༌གྱུད༌གུན༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ མི༌རིགས༌ གྱུར༌ ཡང༌ མི༌རིགས༌གུན༌ནི༌ ནང༌ང༌ སྡེ༌སོ༌སོའ༌ རང༌རང༌ སོ༌སོའེ༌ སྐད༌ དང༌ ས༌ཀྱད༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ཡབ༌ཕེད༌དི༌ ཨ༌ཅོ༌ ཤེམ༌མའང༌ བུ༌ཚ༌ མང༌པོའེ༌ ཨ༌བ༌ གྱུར༌། ཡང༌ ཤེམ༌ ནི༌ ཨེ༌བར༌པ༌གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ཤེམ༌མི༌ བུ༌ཚ༌གུན༌ ཨེ༌ལམ༌, ཨ༌ཤེར༌, ཨར༌ཕ༌ཤེད༌, ལུད༌ དང༌ ཨ༌རམ༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ཨ༌རམ༌ ནི༌ ཨུཟ༌, ཧལ༌, གི༌ཏར༌ དང༌ མེ༌ཤེག༌ གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ཨར༌ཕ༌ཤེད༌ ནི༌ ཤེ༌ལག༌གི༌ ཨ༌བ༌, ཡང༌ ཤེ༌ལག༌ ནི༌ ཨེ༌བར༌རི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ཨེ༌བར༌ལ༌ བུ༌ཚ༌ ཉིས༌ ཡོད༌པིན༌: ཅིག༌པོའེ༌ མིང༌ང༌ པེ༌ལེག༌ ༼ཀ༌བོའེ༌ ཏོན༌བོ༌ པོ༌བུད༌ཅེས༌༽ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཏུས༌ལ༌, ཇིག༌རྟེན༌ནི༌ མི༌གུན༌ནི༌ ནང༌ང༌ པོ༌བུད༌། ཡང༌ ཁོའེ༌ ནོའེ༌ མིང༌ང༌ ཡོག༌ཏན༌ ཟེར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ཡོག༌ཏན༌ ནི༌ ཨལ༌མོ༌དད༌, ཤི༌ལེཕ༌, ཧ༌ཟར༌མ༌ཝེད༌, ཡི༌ར༌, ");
INSERT INTO lbj_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ཧ༌དོ༌རམ༌, འུ༌ཟལ༌, དིག༌ལ༌, ");
INSERT INTO lbj_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","འོ༌བལ༌, ཨ༌བི༌མེལ༌, ཤི༌བ༌, ");
INSERT INTO lbj_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","འོ༌ཕིར༌, ཧ༌ཝི༌ལ༌ དང༌ ཡོ༌བབ༌ གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌, ཡང༌ ཁོང༌གུན༌ ཡོག༌ཏན༌ནི༌ པུར༌གྱུད༌ ཚང༌མ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ཁོང༌གུན༌ དུག༌སའེ༌ ས༌ཀྱད༌པོ༌ མེ༌ཤ༌ནེ༌ ཏངས༌ཏེ༌ ཤར༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ནི༌ རི༌ ཡུལ༌, སི༌ཕར༌ ཆོགས༌ལའང༌ ཕེལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ཏེ༌གུན༌ ཤེམ༌མི༌ པུར༌གྱུད༌གུན༌ ཨིན༌པིན༌། ཁོང༌གུན༌ མི༌རིགས༌ གྱུར༌ ཡང༌ མི༌རིགས༌གུན༌ནི༌ ནང༌ང༌ སྡེ༌སོ༌སོའ༌ རང༌རང༌ སོ༌སོའེ༌ སྐད༌ དང༌ ས༌ཀྱད༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ཏེ༌ ཚང༌མ༌ ནི༌ ནོ༌ཨའེ༌ བུ༌ཚ༌གུན༌ནི༌ པུར༌གྱུད༌གུན༌ ཨིན༌ནོག༌, ཡང༌ མིར༌གྱུད༌ སོ༌སོའེ༌ མིང༌གུན༌ སྐྱེ༌ཚིར༌ ནང༌ཞིན༌ལ༌ བྲིས༌ཏེ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ཆུ༌ལོག༌གི༌ སྟིང༌ནེ༌ འིན༌ན༌ མི༌རིགས༌གུན༌ནི༌ ཀ༌ནེ༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ གྱལ༌ཁབ༌གུན༌ ཕེལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ཏུས༌ཤིག༌ག༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ མི༌གུན༌ནི༌ ཅའང༌ ཁྱད༌ མེད༌ཁན༌ནི༌ སྐད༌ ཅིག༌ཅིག༌ ཏང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ཤར༌ ཆོགས༌ནེ༌ ཡོང༌ ཟ༌ནེ༌ ཁོང༌གུན༌ ཤི༌ནར༌ ཡུལ༌ལི༌ ཏར༌ཏར༌ ནས༌ས༌ཞིག༌ག༌ ལེབ༌ ཡང༌ ཏེ༌རུ༌ ཚུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ཁོང༌ངི༌ ཅིག༌ དང༌ ཅིག༌ག༌ ཟེརས༌, “ཡོང༌ཤིག༌། ང༌དང༌ངི༌ པག༌བུ༌ ཅོས༌ཏེ༌ སྲན༌ཏྲེ༌ ཆ༌ཅེས༌ལ༌ མེའེ༌ ནང༌ང༌ སྲག༌ཨིན༌།” ཁོང༌གུན༌ནི༌ རྡོའེ༌ ཚབས༌ལ༌ པག༌བུ༌ ཡང༌ ཀ༌ལག༌གི༌ ཚབས༌ལ༌ ཏར༌ཀོལ༌ ཀོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཟེརས༌, “ཡོང༌ཤིག༌, ང༌དང༌རང༌ངི༌ ཕིའ༌ གྱལ༌ས༌ དང༌ ཏེ༌ནང༌ང༌ ནམ༌ཁའ༌ ཐུག༌ཅེས༌སི༌ པི༌འུ༌ ཐོན༌པོ༌ཞིག༌གའང༌ རྩིགས༌ཏེ༌, ང༌དང༌གུན༌ མིང༌ཅན༌ གྱུར༌ཨིན༌། ཡང༌ ང༌དང༌གུན༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ བེས༌ཏེ༌ ཆ༌ མི༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ཨིན༌ནའང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌, མིའི༌ རྩིགས༌ཁན༌ནི༌ གྱལ༌ས༌ དང༌ ཐོན༌པོ༌ པི༌འུ༌ གུན༌ ཟིགས༌ས༌ལ༌ ཡོག༌ག༌ བབས༌ཏེ༌ སྐྱོདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ཡ༌ཝའེ༌ མོལས༌, “མི༌གུན༌ ཅིག༌གྲིལ༌ སོང༌ཏེ༌ སྐད༌ ཅིག༌ཅིག༌གི༌ ནང༌ང༌ སྤེ༌ར༌ ཏང༌ཨིན༌ འི༌ཟུག༌ ཅོ༌ཉན༌པ༌, ཏ༌ ཁོང༌གུན༌ལ༌ ཅི༌ཞིག༌ ཅོ༌ཅེས༌སི༌ དོད༌པ༌ ཡོད༌ནའང༌ ཏེ༌གུན༌ ཅོ༌ཉན༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ཡོང༌, ང༌དང༌ ཇིག༌རྟེན༌ནི༌ཀ༌ བབས༌ཏེ༌ ཆེན༌, ཡང༌ མི༌གུན༌ལ༌ ཅིག༌ དང༌ ཅིག༌གི༌ སྐད༌གུན༌ ཧ༌གོ༌ མི༌ཐུབ༌ཅེས༌སི༌ ཕིའ༌ སྐད༌གུན༌ སྲེ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མི༌ཚང༌མ༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ ཡན༌ ཅུག༌ག༌ ཛད༌པ༌, ཁོང༌གུན༌ནི༌ གྱལ༌ས༌ རྩིག༌ཅེས༌པོ༌ གྲུབ༌ མ༌གྲུབ༌བ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ཏེ༌བོའེ༌ ཞས༌ཏེ༌ ཏེ༌ གྱལ༌ས༌བོའ༌ བ༌བེལ༌ ཟེར༌ཏེ༌ མིང༌ ཏགས༌, ཅིའ༌ཟེར༌ན༌ འིན༌ན༌ ནས༌ས༌བོའེ༌ཀ༌ ཡ༌ཝའེ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ སྐད༌བོ༌ སྲེའ༌ ཛདས༌ཏེ༌ སྐད༌ སྣ༌ཚོགས༌ཤིག༌ ཅོའ༌ ཛདས༌། ཡང༌ ཏེ༌ཀ༌ནེ༌ མི༌ཚང༌མ༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ ཡན༌ ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","འི༌གུན༌ནི༌ ཤེམ༌མི༌ པུར༌གྱུད༌གུན༌ནི༌ ཐོ༌ ཨིན༌ནོག༌། ཆུ༌ལོག༌ ཡོངས༌ཏེ༌ ལོ༌ ཉིས༌སི༌ སྟིང༌ནེ༌, ནམ༌ ཤེམ༌མ༌ ལོ༌ 100 ཆའད༌པིན༌, ཁོ༌ ཨར༌ཕ༌ཤེད༌དི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ཨར༌ཕ༌ཤེད༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ཤེམ༌ ཡང༌ ལོ༌ 500 སོན༌ཏེའ༌ ལུས༌, ཡང༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ཨར༌ཕ༌ཤེད༌ལ༌ ལོ༌ 35 ཆའད༌པིན༌ ནམ༌ ཁོ༌ ཤེ༌ལག༌གི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ཤེ༌ལག༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ཨར༌ཕ༌ཤེད༌ ཡང༌ ལོ༌ 403 སོན༌ཏེའ༌ ལུས༌, ཡང༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ཤེ༌ལག༌ག༌ ལོ༌ 30 ཆའད༌པིན༌ ནམ༌ ཁོ༌ ཨེ༌བར༌རི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ཨེ༌བར༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ཤེ༌ལག༌ ཡང༌ ལོ༌ 403 སོན༌ཏེའ༌ ལུས༌, ཡང༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ཨེ༌བར༌ལ༌ ལོ༌ 34 ཆའད༌པིན༌ ནམ༌ ཁོ༌ པེ༌ལེག༌གི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","པེ༌ལེག༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ཨེ༌བར༌ ཡང༌ ལོ༌ 430 སོན༌ཏེའ༌ ལུས༌, ཡང༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","པེ༌ལེག༌ག༌ ལོ༌ 30 ཆའད༌པིན༌ ནམ༌ ཁོ༌ རི༌འུའི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","རི༌འུ༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ པེ༌ལེག༌ ཡང༌ ལོ༌ 209 སོན༌ཏེའ༌ ལུས༌, ཡང༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","རི༌འུའ༌ ལོ༌ 32 ཆའད༌པིན༌ ནམ༌ ཁོ༌ སེ༌རུག༌གི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","སེ༌རུག༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ རི༌འུ༌ ཡང༌ ལོ༌ 207 སོན༌ཏེའ༌ ལུས༌, ཡང༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","སེ༌རུག༌ག༌ ལོ༌ 30 ཆའད༌པིན༌ ནམ༌ ཁོ༌ ན༌ཧོར༌རི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ན༌ཧོར༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ སེ༌རུག༌ ཡང༌ ལོ༌ 200 སོན༌ཏེའ༌ ལུས༌, ཡང༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ན༌ཧོར༌ལ༌ ལོ༌ 29 ཆའད༌པིན༌ ནམ༌ ཁོ༌ ཏི༌རཧའེ༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ཏི༌རཧ༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ན༌ཧོར༌ ཡང༌ ལོ༌ 119 སོན༌ཏེའ༌ ལུས༌, ཡང༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ཏི༌རཧ༌ ལོ༌ 70 ཆའད༌པིན༌ ནམ༌ ཁོ༌ ཨབ༌རམ༌, ན༌ཧོར༌ དང༌ ཧ༌རན༌ གུན༌ནི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","འི༌གུན༌ནི༌ ཏི༌རཧའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ཐོ༌ ཨིན༌ནོག༌། ཏི༌རཧ༌ ཨབ༌རམ༌, ན༌ཧོར༌ དང༌ ཧ༌རན༌ གུན༌ནི༌ ཨ༌བ༌ གྱུར༌, ཡང༌ ཧ༌རན༌ ལོད༌དི༌ ཨ༌བ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ཨ༌བ༌ ཏི༌རཧ༌ སོན༌ཏེའ༌ ཡོད༌དི༌ ཏུས༌ལ༌, ཧ༌རན༌ ཀཱལ༌དིའ༌པའེ༌ ཨུར༌ ཟེར༌སའེ༌ ནས༌སའེ༌ ནང༌ང༌ ཤི༌, ཀ༌རུ༌ ཁོ༌ སྐྱེས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ཨབ༌རམ༌ དང༌ ན༌ཧོར༌ ཉིས༌ཀོའེ༌ བག༌སྟོན༌ ཅོས༌། ཨབ༌རམ༌མི༌ ན༌མའེ༌ མིང༌ང༌ སཱ༌རཱི༌ ཡང༌ ན༌ཧོར༌རི༌ ན༌མའེ༌ མིང༌ང༌ མིལ༌ཀ༌ ཟེར༌རད༌པིན༌། ༼མིལ༌ཀ༌ དང༌ འིས༌ཀ༌ ཨ༌ཅེ༌ ནོ༌མོ༌ ཉིས༌ཀོ༌ ཧ༌རན༌ ནི༌ བུ༌མོ༌གུན༌ ཨིན༌པིན༌། ཡང༌ ཧ༌རན༌ནི༌ ན༌ཧོར༌རི༌ ནོ༌ ཨིན༌པིན༌༽ ");
INSERT INTO lbj_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ཏ༌ སཱ༌རཱིའ༌ ཕྲུ༌གུ༌ ཇོར༌ མ༌ཐུབ༌པ༌ ཁོའ༌ ཕྲུ༌གུ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ཞག༌ཤིག༌ ཏི༌རཧའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཨབ༌རམ༌ དང༌ ཨབ༌རམ༌མི༌ ན༌མ༌ སཱ༌རཱི༌, ཏི༌རཧའེ༌ ཚ༌འོ༌ ལོད༌ ༼ཧ༌རན༌ནི༌ བུ༌ཚ༌༽ གུན༌ ཁྲིད༌ཏེ༌ ཀཱལ༌དིའ༌པའེ༌ ཨུར༌ ཟེར༌སའེ༌ ནས༌ས༌ནེ༌ བིང༌ཏེ༌ ཀེ༌ནན༌ནི༌ ཡུལ༌ལ༌ སོང༌། ཨིན༌ནའང༌ ཧ༌རན༌ལ༌ ལེབ༌བ༌ཅིག༌, ཁོང༌གུན༌ ཏེ༌རུ༌ ཚུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ཏི༌རཧ༌ ལོ༌ 205 སོན༌ཏེའ༌ ལུས༌ཏེ༌ སྟིང༌ནེ༌ ཁོ༌ ཧ༌རན༌ ཟེར༌སའེ༌ ནས༌སའེ༌ ནང༌ང༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ཨབ༌རམ༌མ༌ མོལས༌, “རང༌ཡུལ༌, ཉེན༌གྲུང༌ དང༌ ཨ༌བའེ༌ ནང༌མི༌ གུན༌ ཕངས༌ཏེ༌ ངའེ༌ སྟན༌ཅེས༌ཅན༌ནི༌ ས༌ཆ༌བོའ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ གྱལ༌ཁམས༌ ཀྲག༌པོ༌ཞིག༌ གྱུར༌ཅུག༌ཨིན༌, ཡང༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ ཏངས༌ཏེ༌ མིང༌ཅན༌ གྱུར༌ཅུག༌ཨིན༌། ཏེ༌ནེ༌ ཁྱོ༌རང༌ གྱུད༌ཏེ༌ ཞན༌མ༌གུན༌ལ༌ ཅིན༌ལབས༌ ཐོབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ ཏང༌ཁན༌གུན༌ལ༌ ངའེ༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌, ཡང༌ ཁྱོ༌རང༌ང༌ ངན༌ ཏབ༌ཁན༌གུན༌ལ༌ ངའེ༌ ངན༌ ཏབ༌ཨིན༌། ཇིག༌རྟེན༌པ༌ མི༌ཚང༌མ༌ལ༌ ཁྱོ༌རང༌ གྱུད༌ཏེ༌ ཅིན༌ལབས༌ ཐོབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌ ནང༌ཞིན༌, ཨབ༌རམ༌ ཏེ༌ ནས༌ས༌བོ༌ ཕངས༌ཏེ༌ སོང༌, ཡང༌ ལོད༌དའང༌ ཁོ༌ ཉམ༌པོ༌ སོང༌། ཨབ༌རམ༌ ཧ༌རན༌ནེ༌ བིང༌ཏེ༌ ཆ༌ ཟ༌ནེ༌ ཁོའ༌ ལོ༌ 75 ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ཁོའེ༌ ཁོ༌རང༌ངི༌ ན༌མ༌ སཱ༌རཱི༌, ཁོ༌རང༌ངི༌ ཚ༌འོ༌ ལོད༌, ཁོང༌གུན༌ནི༌ གྱུར༌ནོར༌ སགས༌ཁན༌ ཚང༌མ༌ ཡང༌ ཧ༌རན༌ནི༌ ནང༌ང༌ ཉོས༌ཁན༌ནི༌ སེམས༌ཅན༌ དང༌ ཚེ༌ཡོག༌ གུན༌ ཁྲིད༌ཏེ༌, ཀེ༌ནན༌ནི༌ ས༌ཆའ༌ སོང༌། ཀེ༌ནན༌ལ༌ ལེབ༌བ༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ཨབ༌རམ༌ དང༌ ཁོའེ༌ ཕྲོ༌པ༌ ཚང༌མ༌ ཤེ༌ཀེམ༌མི༌ གྲོང༌སེབ༌ ཚོག༌པ༌ སོང༌, ཏེ༌རུ༌ ཁོང༌ མོ༌རེཧ༌ ཨིན༌ཁན༌ནི༌ མིང༌ཅན༌ ལྕང༌མའེ༌ ཉེ༌མོའ༌ ཏུས༌བན༌ཤིག༌ ནས༌ཏེ༌ དུགས༌། ༼ཏེ༌ཏུས༌ལ༌ ཀེ༌ནན༌པ༌གུན༌ ཏེ༌ ས༌ཆའེ༌ ནང༌ང༌ དུག༌གད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ཏེ༌ནེ༌ ཨབ༌རམ༌མ༌ ཡ༌ཝ༌ ཇལ༌, ཡང༌ ཁོང༌ངི༌ མོལ༌ལ༌ ཛདས༌, “ངའེ༌ འི༌ ས༌ཆ༌བོ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ ཏང༌ཨིན༌།” ཏེན༌ན༌བོའེ༌ཕིའ༌ ཨབ༌རམ༌མི༌ ཁོའ༌ ཇལ༌ཁན༌ནི༌ ཡ༌ཝའ༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌ལ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","སྟིང༌ནེ༌ ཨབ༌རམ༌ ཏེ༌ཀ༌ནེ༌ ལྷོ༌ ཆོགས༌ལ༌ སོང༌, ཡང༌ ནུབ༌ ཆོགས༌ལ༌ བེ༌ཐེལ༌ལི༌ གྲོང༌ཁྱེར༌ དང༌ ཤར༌ ཆོགས༌ལ༌ ཨའི༌ གྲོང༌ཁྱེར༌ ཉིས༌ཀོའེ༌ པར༌རི༌ རི༌ཡུལ༌ཞིག༌གི༌ ནང༌ང༌ ཚུགས༌ཏེ༌ དུགས༌། ཏེ༌རུ༌ ཁོའེ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌ཏེ༌ དཀོན༌མཆོག༌ག༌ ཡ༌ཝ༌ ཟེར༌ཨིན༌ ཅོལ༌ཅེས༌ གོ༌ཟུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ཏེ༌ ནས༌ས༌ནེ༌ བིང༌ཏེ༌ ཏུས༌ མང༌པོའེ༌ སྟིང༌ནེ༌ ཨབ༌རམ༌ ནེ༌གེཝ༌ ཟེར༌ཁན༌ནི༌ ས༌ཆ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ཏེ༌ཏུས༌ལ༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ མུ༌གེ༌ ཡོངས༌། ཨབ༌རམ༌ ཐུར༌ ཆོགས༌ལ༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ལ༌ དུག༌ཅེས༌སི༌ ཕིའ༌ ཆ༌གོས༌ ཅིའ༌ཟེར༌ན༌ མུ༌གེ༌ མ༌སྲན༌ཏྲེ༌ ཡོངས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ལེབ༌ཀྱིས༌ལ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ན༌མ༌ ཟེརས༌, “སཱ༌རཱི༌ ཁྱོ༌རང༌ བུ༌མོ༌ མ༌ ལྡེ༌མོ༌ ཡོད༌ཅེས༌པོའེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཁྱོ༌རང༌ ཐོང༌ང༌ཅིག༌, ‘ཁྱོ༌རང༌ ངའེ༌ ན༌མ༌ ཨིན༌ནོག༌’ སམས༌ཏེ༌ ང༌ སད༌ད༌ནོག༌ ཨིན༌ནའང༌ ཁྱོ༌རང༌ སོན༌ཏེའ༌ བོར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ཁྱོ༌རང༌ངི༌ ཞས༌ཏེ༌ ང༌ མ༌སད༌ད༌ གྱལ༌ལ༌ ཅོ༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌གུན༌ལ༌ ‘ཁྱོ༌རང༌ ངའེ༌ སྲིང༌མོ༌ ཨིན༌ ཟེར༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ཨབ༌རམ༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ལ༌ ལེབ༌བ༌ཅིག༌, ཨི༌ཇིབ༌པ༌གུན༌ནི༌ སཱ༌རཱི༌ མ༌ བུ༌མོ༌ ལྡེ༌མོ༌ཞིག༌ ཡོད༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཕེ༌རོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ སཱ༌རཱི༌ ཐོང༌ཏེ༌, ཁོང༌གུན༌ནི༌ གྱལ༌པོའ༌ ཁོ༌ ཙམ༌ཤིག༌ ལྡེ༌མོ༌ ཡོད༌ཁན༌བོའེ༌ སྐོར༌ལ༌ ཤདས༌། ཡང༌ སཱ༌རཱི༌ གྱལ༌པོའེ༌ ཁར༌ལ༌ ཁྲིད༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","སཱ༌རཱི༌ ཞས༌ཏེ༌, གྱལ༌པོའེ༌ ཨབ༌རམ༌མ༌ སྙིང༌རྗེ༌ སྟནས༌ ཡང༌ ཁོའ༌ སྐྱེས༌ མང༌པོ༌ ཏངས༌, སྤེར༌ན༌ ལུག༌, ར༌མ༌, བ༌ལང༌, བུང༌བུ༌ ཕོ༌ དང༌ མོ༌, རྔ༌བོང༌ དང༌ ཚེ༌ཡོག༌ བུ༌མོ༌ དང༌ བུ༌ཚ༌ གུན༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ གྱལ༌པོ༌ དང༌ ཁོའེ༌ ནང༌ཚངས༌ ཚང༌མ༌ལ༌ ཟུ༌མོ༌ མ༌ ཇིགས༌ནང༌ཅན༌ རིག༌ ཡོང༌ ཅུག༌ག༌ ཛདས༌, ཅིའ༌ཟེར༌ན༌ གྱལ༌པོའེ༌ ཨབ༌རམ༌མི༌ ན༌མ༌ སཱ༌རཱི༌, ན༌མ༌ ཅོ༌ཅེས༌ལ༌ ཁྱེར༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཕེ༌རོའེ༌ ཨབ༌རམ༌མ༌ བོད༌ཏེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ངའ༌ འི༌བོ༌ ཅིའ༌ ཅོས༌ཏེ༌ ཨིན༌? ཁོ༌ ཁྱོ༌རང༌ངི༌ ན༌མ༌ ཨིན༌ ཟེར༌ཏེ༌ ང༌ ཅི༌ཕིའ༌ ཁྱོ༌རང༌ངི༌ མ༌ཤད༌པིན༌? ");
INSERT INTO lbj_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ཁོ༌ ཁྱོ༌རང༌ངི༌ སྲིང༌མོ༌ ཨིན༌ ཟེར༌པ༌, ངའེ༌ ཁོ༌ ང༌རང༌ངི༌ ན༌མ༌ ཅོ༌ཅེས༌ལ༌ ཁྱེར༌པིན༌། ཅི༌ཕིའ༌ ཁྱོ༌རང༌ངི༌ ཏེ༌ཟུག༌ ཟེར༌པིན༌? ཡའ༌, ཁྱོ༌རང༌ངི༌ ན༌མ༌ ཁྲིད༌ཏེ༌ སོང༌!” ");
INSERT INTO lbj_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ མག༌མི༌ སྤོན༌བོ༌གུན༌ལ༌ བཀའ༌ ཏངས༌པ༌ ཁོང༌གུན༌ནི༌ ཨབ༌རམ༌ དང༌ ཁོའེ༌ ན༌མ༌, ཁོང༌གུན༌ནི༌ ནོར༌གུན༌ ཉམ༌པོ༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ནེ༌ ཕི༌ལོག༌ག༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཨབ༌རམ༌ ཨི༌ཇིབ༌ནེ༌ རང༌ངི༌ ན༌མ༌ དང༌ ཁོ༌རང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁུར༌ཏེ༌ ཀེན༌ ཆོགས༌ལ༌ ནེ༌གེཝ༌ ཟེར༌སའེ༌ ནས༌ས༌ ལོགས༌ཏེ༌ སོང༌, ལོད༌དའང༌ ཁོ༌ ཉམ༌པོ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ཨབ༌རམ༌ མ༌ ཆུག༌པོ༌ གྱུར༌། ཁོའ༌ མུལ༌, སེར༌ དང༌ ཀྲུད༌ཏྲོ༌ མང༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ནེ༌གེཝ༌ནེ༌ ཁོ༌ ནས༌ས༌ ཅིག༌ནེ༌ ཅིག༌ག༌ དུག༌ཨིན༌ བེ༌ཐེལ༌ལ༌ ལེབ༌ལེབ༌ ཚོག༌པ༌ སོང༌, བེ༌ཐེལ༌ དང༌ ཨའི༌ པར༌རི༌ ནས༌ས༌ ཀ༌བོའེ༌ཀ༌ སྔུན༌ལའང༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཀུར༌བོ༌ ཙུགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ཆོད༌ཁྲི༌ རྩིགས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ཏེན༌ན༌ ནས༌ས༌བོའེ༌ཀ༌ ཁོའེ༌ ཡང༌སྐྱར༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ཏ༌ ཨབ༌རམ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ནི༌ ལོད༌དའང༌ ར༌ལུག༌གི༌ ཁྱུ༌, བ༌ལང༌ངི༌ ཁྱུ༌ དང༌ མི༌གུན༌ནི༌ ཕིའ༌ ཀུར༌ མང༌པོ༌ཞིག༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ཨིན༌ནའང༌ ཁོང༌ ཉིས༌ཀོའེ༌ ཀྲུད༌ཏྲོའ༌ ལྡང༌ཤེས༌སི༌ རྩ༌ཁ༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ སྨིན༌ མ༌ཐུབ༌, ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ལ༌ ཀྲུད༌ཏྲོ༌ མ༌ མང༌པོ༌ སོང༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཨབ༌རམ༌ དང༌ ལོད༌དི༌ སེམས༌ཅན༌ ཚོ༌ཁན༌གུན༌ནི༌ པར༌ལ༌ ཛིང༌མོ༌ ཆ༌ཅེས༌ གོ༌ཟུགས༌། ཏེ༌ཏུས༌ལ༌ ཀེ༌ནན༌པ༌ དང༌ པེ༌རིཟ༌པ༌ གུན༌ནའང༌ ཏེན༌ན༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌གད༌ཀྱག༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ཏེ༌ནེ༌ ཨབ༌རམ༌མི༌ ལོད༌ལ༌ ཟེརས༌, “ང༌དང༌ ཡ༌ ང༌དང༌ངི༌ སེམས༌ཅན༌ ཚོ༌ཁན༌གུན༌ནི༌ པར༌ལ༌ ཛིང༌མོ༌ མི༌ཏང༌, ཅིའ༌ཟེར༌ན༌ ང༌དང༌ ཉིས༌ཀོ༌ སྤུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ང༌དང༌ངི༌ དུན༌ལ༌ ས༌ཀྱད༌ མ༌ ཆེན༌མོ༌ཞིག༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ཁྱོ༌རང༌ ཐད༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌པོ༌ ལྡོམ༌, ང༌དང༌ ཉིས༌ཀོ༌ བེ༌ཨིན༌། ཀལ༌ཏེས༌ ཁྱོ༌རང༌ ཡོ༌མ༌ ཆོགས༌ལ༌ ཆ༌ན༌ ཏེ༌ནེ༌ ང༌ ཡས༌པ༌ ཆོགས༌ལ༌ ཆེན༌, ཡ༌ ཁྱོ༌རང༌ ཡས༌པ༌ ཆོགས༌ལ༌ ཆ༌ན༌ ང༌ ཡོ༌མ༌ ཆོགས༌ལ༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ལོད༌དི༌ ཟོའར༌ གྲོང༌ཁྱེར༌རི༌ ཆོགས༌ལ༌ ལྟས༌པ༌, ཁོའ༌ ཡོར༌དཱན༌ ལུང༌པ༌བོ༌ ཀ༌རུང༌ས༌ མ༌ སྔོན༌པོ༌, ཨི༌དན༌ནི༌ ས༌ཆའེ༌ ཚས༌ ཡ༌ ཨི༌ཇིབ༌བི༌ ས༌ཆའ༌ ཙོགས༌ ཐོང༌། ༼ཏེ༌བོ༌ ཡ༌ཝའེ༌ སོ༌དོམ༌ དང༌ གོ༌མོ༌རའི༌ གྱལ༌ས༌གུན༌ ཁྲེས༌ཏོར༌ ཅོའེ༌ སང༌ སྔུན༌ལ༌ ཨིན༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ལོད༌དི༌ ཁོ༌རང༌ངི༌ ཕིའ༌ ཡོར༌དཱན༌ནི༌ སྤང༌ཐང༌ ཚང༌མ༌ ལྡམས༌ཏེ༌ ཤར༌ ཆོགས༌ལ༌ སོང༌། ཏེ༌ཟུག༌གི༌ ཁོ༌ དང༌ ཨབ༌རམ༌ ཉིས༌ཀོ༌ བེ༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ལོད༌ ཡོར༌དཱན༌ ཐང༌ངི༌ གྱལ༌ས༌གུན༌ནི༌ ཕྲོའ༌ དུགས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཀུར༌བོ༌ སོ༌དོམ༌མི༌ གྱལ༌སའེ༌ ཉེ༌ཁོར༌ལ༌ ཙུགས༌། ཨིན༌ནའང༌ ཨབ༌རམ༌ ཀེ༌ནན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ཏ༌ སོ༌དོམ༌པ༌གུན༌ མངས༌ཏེའང༌ ངན༌པ༌ ཡོད༌ཅེས༌པོའེ༌ ཡ༌ཝའེ༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཆད༌མེད༌ལ༌ ཅོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ལོད༌ སོང༌ ཚར༌ཏེ༌ སྟིང༌ནེ༌ ཡ༌ཝའེ༌ ཨབ༌རམ༌མ༌ མོལས༌, “ཁྱོ༌རང༌ ཡོད༌སའེ༌ ནས༌སའེ༌ ཀ༌ནེ༌ མིག༌ སྟགས༌ཏེ༌ ཆོགས༌ ཚང༌མ༌ལ༌ ལྟོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ཁྱོ༌རང༌ངི༌ མིག༌ནེ༌ ཐོང༌ཁན༌ནི༌ ནས༌ས༌ ཚང༌མ༌ ཏུས༌གྱུན༌ནི༌ ཕིའ༌ ངའེ༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ཡང༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཐལ༌བ༌ ཙོགས༌ལ༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ སུ༌ཞིག༌གའང༌ རྩི༌ མི༌ཉན༌ཅེས༌ མང༌པོ༌ ཕེལ༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ཏ༌ སོང༌ ཡང༌ ས༌ཀྱད༌དི༌ ཆོགས༌ ཚང༌མ༌ལ༌ ཁོར༌, ཅིའ༌ཟེར༌ན༌ ངའེ༌ འི༌ ཚང༌མ༌ ཁྱོ༌རང༌ང༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ཏེ༌ནེ༌ ཨབ༌རམ༌མི༌ ཀུར༌གུན༌ ཁྱེར༌ཏེ༌ ཧེབ༌རོན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ མམ༌རེ༌ ཟེར༌ཁན༌ནི༌ མི༌བོའེ༌ མིང༌ཅན༌ ལྕང༌མ༌གུན༌ནི༌ ཉེ༌མོའ༌ དུག༌ག༌ལ༌ ཙུག༌ཅུགས༌, ཡང༌ ཏེ༌རུ༌ ཁོའེ༌ ཡ༌ཝའ༌ ཅོལ༌ཅེས༌ལ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","བ༌བེ༌ལོན༌ནི༌ གྱལ༌པོ༌ ཨམ༌ར༌ཕེལ༌, འེ༌ལ༌སར༌རི༌ གྱལ༌པོ༌ ཨེ༌ར༌ཡོག༌, ཨེ༌ལེམ༌མི༌ གྱལ༌པོ༌ ཀ༌དོར༌ལ༌འོ༌མེར༌ དང༌ གོའིམ༌མེ༌ གྱལ༌པོ༌ ཀྲི༌གྲལ༌ ཞི༌ཀོ༌, ");
INSERT INTO lbj_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","སོ༌དོམ༌མི༌ གྱལ༌པོ༌ བེ༌ར༌, གོ༌མོ༌རའི༌ གྱལ༌པོ༌ བིར༌ཤའ༌, ཨད༌མཧའེ༌ གྱལ༌པོ༌ ཤི༌ནབ༌, ཟི༌བོ༌ཡིམ༌མི༌ གྱལ༌པོ༌ ཤེམ༌མེ༌བར༌ དང༌ བི༌ལའེ༌ ༼ཡང༌ན༌ ཟོར༌རི༌༽ གྱལ༌པོ༌ ལྔ༌ཀོའེ༌ གྱབ༌གལ༌ལ༌ མག༌ཏང༌ང༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ཏེ༌ གྱལ༌པོ༌ ལྔ༌ཀོའེ༌ མག༌མི༌གུན༌ སི༌དིམ༌མི༌ ལུང༌པའེ༌ ནང༌ང༌ ཛོམས༌ཏེ༌ ཅིག༌གྲིལ༌ སོང༌ཏེ༌ ཡོད༌པིན༌ ༼ཏེ༌བོའ༌ ཚོ༌རུལ༌ལི༌ ལུང༌པའང༌ ཟེར༌ར༌ནོག༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ཁོང༌གུན༌ ལོ༌ རྕུག༌ཉིས༌ གྱལ༌པོ༌ ཀ༌དོར༌ལ༌འོ༌མེར༌རི༌ ངའ༌ཡོག༌ག༌ ཡོད༌པིན༌། ཨིན༌ནའང༌ ལོ༌ ཅུག༌སུམ༌པའེ༌ ནང༌ང༌ ཁོང༌གུན༌ནི༌ ཏེ༌ གྱལ༌པོའེ༌ གྱབ༌གལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ལོ༌ ཅུབ༌ཞི༌པའེ༌ ནང༌ང༌ གྱལ༌པོ༌ ཀ༌དོར༌ལ༌འོ༌མེར༌ དང༌ ཁོའེ༌ ཝང༌ངི༌ ཡོག༌ག༌ ཡོད༌ཁན༌ནི༌ གྱལ༌པོ༌གུན༌ནི༌, ཨེཤ༌ཏི༌རོཐ༌ ཀར༌ནེ༌འིམ༌མི༌ ཡུལ༌ལི༌ ནང༌ང༌ རེ༌ཕའེ༌འམ༌པ༌གུན༌ལ༌, ཧམ༌མི༌ ཡུལ༌ལི༌ ནང༌ང༌ ཟུ༌ཟེམ༌པ༌གུན༌ལ༌ ཡང༌ ཤ༌ཝེཧ༌ ཀི༌རིའ༌ཐ༌ཡེམ༌མི༌ ཡུལ༌ལི༌ ནང༌ང༌ ཨི༌མམ༌པ༌གུན༌ལ༌ ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","སེ༌འིར༌རི༌ རི༌ ཡུལ༌, རི༌སྟོང༌ངི༌ ཐའ༌མ༌ ཡོད༌ཁན༌ནི༌ ཨེལ༌ཕ༌རན༌ ཚོག༌པ༌ དུག༌ཁན༌ནི༌ ཧོར༌པ༌གུན༌ལའང༌ ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ཏེ༌ནེ༌ ཁོང༌གུན༌ ལོགས༌ཏེ༌ ཨེན༌མིཤ༌པཏ༌ ༼ཡང༌ན༌ ཀ༌དེཤ༌ལ༌༽ ཡོངས༌, ཡང༌ ཏེ༌རུ༌ དུག༌ཁན༌ནི༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ལ༌ མ༌ཚད༌ ཧ༌ཟ༌ཟོན༌ ཏ༌མར༌རི༌ ནང༌ང༌ དུག༌ཁན༌ནི༌ ཨ༌མོར༌པ༌གུན༌ལའང༌ མ༌སྲན༌ཏྲེ༌ ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","ཏེ༌ནེ༌ ཀ༌དོར༌ལ༌འོ༌མེར༌ གྱལ༌པོའ༌ གྱབ༌གལ༌ ཅོ༌ཁན༌ནི༌ སོ༌དོམ༌, གོ༌མོ༌ར༌, ཨད༌མཧ༌, ཟི༌བོ༌ཡིམ༌ དང༌ བི༌ལའེ༌ ༼ཡང༌ན༌ ཟོར༌༽ གྱལ༌པོ༌ ལྔ༌ཀོའེ༌ སི༌དིམ༌མི༌ ལུང༌པའེ༌ ནང༌ང༌ ཁོ༌ དང༌ ཁོའ༌ ཆོགས༌སྐྱོར༌ ཅོ༌ཁན༌ནི༌ གྱལ༌པོ༌གུན༌ནི༌ མག༌མི༌ གྱབ༌གལ༌ལ༌ མག༌ཏང༌ང༌ ཡོངས༌། གྱལ༌པོ༌ ལྔའེ༌ གྱབ༌གལ༌ལ༌ གྱལ༌པོ༌ ཞི༌ མག༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ཏ༌ ཏེ༌ ལུང༌པ༌བོ༌ ཏར༌ཀོལ༌ལི༌ ས༌དོང༌ངི༌ གངས༌ཏེ༌ ཡོད༌པིན༌, ཡང༌ སོ༌དོམ༌ དང༌ གོ༌མོ༌རའི༌ གྱལ༌པོའེ༌ མག༌མི༌གུན༌ ཕམ༌ཕོགས༌ཏེ༌ མག༌ནེ༌ ཤོར༌ཏེ༌ ཆ༌ ཟ༌ནེ༌ ཁ༌ཅིག༌ ཏེ༌ ས༌དོང༌གུན༌ནི༌ ནང༌ང༌ བུད༌, ཡང༌ མ༌བུད༌ཁན༌གུན༌ རི༌ཡུལ༌གུན༌ལ༌ ཤོར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","གྱལ༌ཐོབ༌ཁན༌ནི༌ གྱལ༌པོ༌ ཞི༌ཀོའེ༌ སོ༌དོམ༌ དང༌ གོ༌མོ༌རའི༌ ནོར༌ དང༌ ཟན༌ ཚང༌མ༌ ཁུར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ཁོང༌གུན༌ནི༌ ཨབ༌རམ༌མི༌ ཚ༌འོ༌ སོ༌དོམ༌མི༌ ནང༌ང༌ དུག༌ཁན༌ ལོད༌ དང༌ ཁོའེ༌ གྱུ༌ནོར༌གུན༌ནའང༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ཨིན༌ནའང༌ ཤོར༌ཁན༌གུན༌ནི༌ ནང༌ནེ༌ ཅིག༌, ཨ༌མོར༌པ༌ མམ༌རེའེ༌ ཨིན༌ཁན༌ནི༌ མིང༌ཅན༌ ལྕང༌མ༌གུན༌ནི༌ ཉེ༌མོའ༌ དུག༌ཁན༌ ཨིབ༌རི༌པ༌, ཨབ༌རམ༌ ཡོད༌ས༌ ཡོངས༌ཏེ༌ ཇུང༌ཁན༌གུན༌ ཤདས༌། མམ༌རེ༌ ནོ༌ ཨེཤ༌ཀོལ༌ དང༌ ཨ༌ནེར༌ གུན༌ ཨབ༌རམ༌མི༌ ཆོགས༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ཨབ༌རམ༌མ༌ ཁོའེ༌ ཚ༌འོ༌བོ༌ ཟུམས༌ཏོགས༌ ཟེར༌ཏེ༌ ཚོར༌ར༌ཅིག༌, ཁོའེ༌ ནང༌ཚངས༌སི༌ ནང༌ང༌ སྐྱེས༌ཁན༌, ནོལ༌ཉན༌ཁན༌ནི༌ མི༌ 318 ཛོམ༌ཅེས༌ལ༌ བོདས༌། ཡང༌ ཁོང༌གུན༌ནི༌ དཱན༌ ཟེར༌སའེ༌ ནས༌ས༌ ཚོག༌པ༌ གྱལ༌པོ༌ ཞི༌ཀོའེ༌ མག༌མི༌གུན༌ ཐོབ༌ཐོབ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ཏེ༌རུ༌ ཨབ༌རམ༌མི༌ ཁོ༌རང༌ངི༌ མི༌གུན༌ སྡེ༌སྡེ༌ ནང༌ང༌ བགོས༌, ཡང༌ ཚན༌ལ༌ གྲ༌འོ༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོ༌ཅུགས༌པ༌ ཁོང༌གུན༌ ཤོར༌ཏེ༌ སོང༌། ཨབ༌རམ༌མི༌ མི༌གུན༌ནི༌ དཱ༌མེས༌ཀས༌ གྱལ༌སའེ༌ བྱང༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ནི༌ ནས༌ས༌ ཧོ༌བ༌ ཚོག༌པ༌ ཁོང༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ཁོའེ༌ གྱུ༌ནོར༌ ཁྱེར༌ཁན༌ ཚང༌མ༌ ལོགས༌ཏེ༌ ཁྱོངས༌, ཡང༌ ཁོ༌རང༌ངི༌ ཉེན༌ ལོད༌ དང༌ ཁོའེ༌ གྱུ༌ནོར༌, ཡང༌ བུ༌མོ༌གུན༌ དང༌ ཞན༌མི༌གུན༌ནའང༌ ལོགས༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ཨབ༌རམ༌མི༌ གྱལ༌པོ༌ ཀ༌དོར༌ལ༌འོ༌མེར༌ དང༌ ཁོའ༌ རོགས༌ ཅོ༌ཁན༌ནི༌ གྱལ༌པོ༌གུན༌ལ༌ ཕམ༌ཀལ༌ཏེ༌ ལོགས༌ཏེ༌ ཡོང༌ ཟ༌ནེ༌ སོ༌དོམ༌མི༌ གྱལ༌པོ༌, ཤ༌ཝེཧ༌ ལུང༌པ༌ ༼ཡང༌ན༌ གྱལ༌པོའེ༌ ལུང༌པ༌ ཟེར༌སའེ༌༽, ནང༌ང༌ ཁོའ༌ ཐུག༌ག༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ཏེ༌ནེ༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ བླ༌མ༌, སེ༌ལམ༌མི༌ གྱལ༌པོ༌ མེལ༌ཀ༌ཟེ༌དེག༌གི༌ ཨབ༌རམ༌མ༌ ཏ༌གི༌ དང༌ ཆང༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ཡང༌ ཁོའ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ མོལས༌, “ནམ༌ཁའ༌ དང༌ ཇིག༌རྟེན༌ ཉིས༌ཀོ༌ ཛད༌ཁན༌ནི༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ སལ༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ཁྱོ༌རང༌ང༌ གྲ༌འོ༌གུན༌ནི༌ཀ༌ གྱལ༌ཁའ༌ ཐོབ༌ ཅུག༌ག༌ ཛད༌ཁན༌ནི༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌ག༌ སྟོད༌པ༌ ཐོབ༌ཤིག༌།”, ཡང༌ ཨབ༌རམ༌མི༌ མེལ༌ཀ༌ཟེ༌དེག༌ག༌ ལོགས༌ཏེ༌ ཁྱོང༌ཁན༌ནི༌ གྱུ༌ནོར༌ ཚང༌མའེ༌ རྕུ༌ཁག༌པོ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","སོ༌དོམ༌མི༌ གྱལ༌པོའེ༌ ཨབ༌རམ༌མ༌ ཟེརས༌, “ངའེ༌ མི༌གུན༌ ལོགས༌ཏེ༌ ཏོང༌, ཨིན༌ནའང༌ ལོགས༌ཏེ༌ ཁྱོང༌ཁན༌ནི༌ གྱུ༌ནོར༌ ཚང༌མ༌ བོར༌ནའང༌ གྲིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ཨིན༌ནའང༌ ཨབ༌རམ༌མི༌ སོ༌དོམ༌མི༌ གྱལ༌པོའ༌ ཟེརས༌, “ངའེ༌ ནམ༌ཁའ༌ དང༌ ཇིག༌རྟེན༌ ཛད༌ཁན༌ནི༌ ཡ༌ཝ༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ སྐུན༌དུན༌ལ༌ ནའ༌ ཁུར༌རད༌, ");
INSERT INTO lbj_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ཁྱོ༌རང༌ངི༌ ཨིན༌ཁན༌ ཅི༌ཞིག༌གའང༌ ངའེ༌ མི༌ཁྱེར༌, པ༌བུ༌ ཡ༌ སྐུད༌པ༌ཞིག༌གའང༌, ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ངི༌, ‘ངའེ༌ ཨབ༌རམ༌ ཆུག༌པོ༌ གྱུར༌ཅུགས༌པིན༌’ ཟེར༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ངའེ༌ མི༌གུན༌ནི༌ ཟའ༌ཁན༌ནི༌ ཁར༌ཇི༌ ཡང༌ ངའ༌ རོགས༌ ཅོ༌ཁན༌ ཨ༌ནེར༌, ཨེཤ༌ཀོལ༌ དང༌, མམ༌རེ༌ གུན༌ནི༌ སྐལ༌ལའེ༌ ནོར༌གུན༌ མན༌པ༌ ངའེ༌ ཡང༌ ཅའང༌ མི༌ཁྱེར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ཏེ༌སྟིང༌ནེ༌ ཞལ༌ཟིགས༌ཤིག༌གི༌ ནང༌ང༌ ཨབ༌རམ༌མ༌ ཡ༌ཝའེ༌ མོལས༌, “ཨབ༌རམ༌ ཇིགས༌ མ༌ཇིགས༌, ངའེ༌ ཁྱོ༌རང༌ སྐྱོབས༌ཏེ༌ བོར༌ཨིན༌, ཁྱོ༌རང༌ང༌ སོལ༌རས༌ ཆེན༌མོ༌ཞིག༌ ཐོབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ཨིན༌ནའང༌ ཨབ༌རམ༌མི༌ ལན༌ཏངས༌, “ཡ༌ཝ༌, ངའེ༌ གཙོ༌བོ༌, ཉེ༌རང༌ངི༌ སོལ༌རས༌པོའེ༌ ངའ༌ ཅི༌ ཕན༌ཐོགས༌ ཨིན༌? ང༌ ཕྲུ༌གུ༌ མེད༌པ༌, དཱ༌མེས༌ཀས༌སི༌ ཨེ༌ལི༌འ༌ཟར༌ལ༌ ངའེ༌ ནོར༌སྐལ༌ ཚང༌མ༌ ཐོབ༌བ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ཉེ༌རང༌ངི༌ ངའ༌ ཕྲུ༌གུ༌ མ༌སལ༌ པ༌སང༌ ངའེ༌ ཡོག༌པོ༌ ཅིག༌ཅིག༌ ངའེ༌ ནོར༌སྐལ༌ ལེན༌ཁན༌བོ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ཏེ༌ནེ༌ ཁོའ༌ ཡ༌ཝའེ༌ ཡང༌སྐྱར༌ མོལ༌ཨིན༌ ཚོར༌, “མན༌, ཁྱོ༌རང༌ངི༌ ཡོག༌པོ༌ ཁྱོ༌རང༌ངི༌ ནོར༌སྐལ༌ ལེན༌ཁན༌བོ༌ མི༌གྱུར༌། ཨིན༌ནའང༌ ཁྱོ༌རང༌ རང༌ངི༌ བུ༌ཚ༌ ཁྱོ༌རང༌ངི༌ ནོར༌སྐལ༌ ལེན༌ཁན༌བོ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ཡ༌ཝའེ༌ ཨབ༌རམ༌ ཀུར༌རི༌ ནང༌ནེ༌ ཕི༌ལོག༌ག༌ ཁྱོངས༌ཏེ༌ མོལས༌, “ནམ༌ཁའ༌ ལྟོས༌སའང༌, ཁྱོ༌རང༌ང༌ སྐར༌མ༌གུན༌ རྩི༌ཉན༌ཅེས༌ རག༌ག༌? ཏེ༌ སྐར༌མ༌ ཙོགས༌ མང༌པོ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ཨབ༌རམ༌མི༌ ཡ༌ཝའེ༌ཀ༌ ཨིད༌ཤེས༌ ཅོས༌ པ༌སང༌ ཡ༌ཝའེ༌ ཁོའ༌ ཀྲང༌པོ༌ མི༌ཞིག༌ ཐེའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ཡ༌ཝའེ༌ ཁོའ༌ ཡང༌ མོལས༌, “ཁྱོ༌རང༌ང༌ འི༌ ས༌ཀྱད༌པོ༌ ཏང༌ཅེས༌ལ༌ བ༌བེ༌ལོན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཨུར༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཁན༌, ང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ཨིན༌ནའང༌ ཨབ༌རམ༌མི༌ ཟེརས༌, “ཡ༌ཝ༌, ངའེ༌ གཙོ༌བོ༌, འི༌ ས༌ཀྱད༌པོ༌ ངའེ༌ གྱུར༌ཨིན༌ ཟེར༌ཏེ༌ ངའ༌ ཀ༌ཟུག༌གི༌ གྱུས༌ཆེན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “ངའ༌ ལོ༌ སུམ༌ ཆའ༌ཁན༌ནི༌ བ༌ལང༌, ར༌མ༌ དང༌, ལུག༌ཕོ༌ ཡང༌ ཐི༌བ༌ ཟེར༌ཁན༌ནི༌ ཅ༌ དང༌ ཕུར༌གོན༌ནི༌ ཕྲུ༌གུ༌ཞིག༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ཨབ༌རམ༌མི༌ ཡ༌ཝའ༌ མོལ༌ཁན༌ནི༌ སེམས༌ཅན༌གུན༌ ཁྱོངས༌ཏེ༌, ཏེ༌གུན༌ནི༌ ཟུགས༌པོ༌ ཁག༌ཉིས༌སི༌ ནང༌ང༌ ཅད༌ཏེ༌ གྲལ༌ ཉིས༌སི༌ ནང༌ང༌ རིགས༌ཏེ༌ བོརས༌, ཨིན༌ནའང༌ ཅ༌གུན༌ ཁག༌ཉིས༌སི༌ ནང༌ང༌ མ༌ཅདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ཤ༌ ཟའ༌ཁན༌ནི༌ ཅ༌གུན༌ སད༌ཁན༌ནི༌ རོ༌གུན༌ནི༌ཀ༌ བབས༌ཏེ༌ ཡོངས༌, ཨིན༌ནའང༌ ཨབ༌རམ༌མི༌ ཏེ༌གུན༌ལ༌ སྲོགས༌ཏེ༌ ཆ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ཉི༌མ༌ སྐྱོད༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ ཨབ༌རམ༌མ༌ མའ༌ ཉིད༌ སྲན༌ཏྲེ༌ ཡོངས༌ ཡང༌ ཁོའེ༌ སེམས༌པོ༌ ཇིགས༌ནང༌ངི༌ གངས༌པ༌ ཁོ༌ དྲོགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོལས༌, “འི༌བོ༌ ཏན༌ཏན༌ ཨིན༌, ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ ཞན༌མའེ༌ ཡུལ༌ལི༌ ནང༌ང༌ མ༌ཤེས༌ཁན༌ནི༌ མི༌ ཚུལ༌ལ༌ དུག༌ཨིན༌། ཡང༌ ཏེ༌རུ༌ ཚེ༌ཡོག༌ གྱུར༌ཏེ༌ ལོ༌ ཞིབ༌གྱ༌ ཁོང༌གུན༌ལ༌ མ༌སྲན༌ཏྲེ༌ ནགས༌ སྟན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ཨིན༌ནའང༌ ངའེ༌ ཁོང༌གུན༌ ཚེ༌ཡོག༌ག༌ ལུས༌ཁན༌ནི༌ ཏེ༌ གྱལ༌ཁམས༌བོའ༌ ཆད༌པ༌ ཏང༌ཨིན༌, ཡང༌ ཏེ༌བོའེ༌ སྟིང༌ནེ༌ ཁོང༌གུན༌ ཏེ༌ གྱལ༌ཁབ༌ནེ༌ གྱུ༌ནོར༌ མང༌པོ༌ ཉམ༌པོ༌ བིངས༌ཏེ༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ཁྱོ༌རང༌ངི༌ སྐོར༌ལ༌ ཟེར༌ན༌, ཁྱོ༌རང༌ ལོ༌ མང༌པོ༌ སོན༌ཏེ༌ ལུས༌ཏེ༌ ཞི༌དེ༌ ཉམ༌པོ༌ ཤི༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ མི༌རབས༌ ཞི༌པའེ༌ སྟིང༌ནེ༌ འིན༌ན༌ ནས༌སའེ༌ ནང༌ང༌ ལོགས༌ཏེ༌ ཡོང༌ཨིན༌, ཅིའ༌ཟེར༌ན༌ ཨ༌མོར༌པ༌གུན༌ནི༌ སྡིག༌པའེ༌ ལས༌གུན༌, མེད༌ཁན༌ ཅོ༌གོ༌ཤེས༌སི༌ ཚད༌ ཚག༌པ༌ ཏ༌རུང༌ མ༌ལེབ༌བ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ཉི༌མ༌ སྐྱོད༌ ཚར༌ཏེ༌ མུན༌གྲིག༌ སོང༌ཏེ༌ སྟིང༌ནེ༌ ཨབ༌རམ༌མ༌ ཏུད༌པ༌ བིང༌ཁན༌ནི༌ ཟ༌མ༌ཞིག༌ དང༌ མེའེ༌ པམ༌བར༌ཞིག༌ ཏེ༌ སེམས༌ཅན༌ནི༌ རོ༌ ཁག༌ཉིས༌ པུད༌ཁན༌གུན༌ནི༌ པར༌པོ༌ནེ༌ སྐྱོད༌ད༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ཏེན༌ན༌ ཞག༌ག༌ ཡ༌ཝའེ༌ ཨབ༌རམ༌ ཉམ༌པོ༌ ཆད༌དོན༌ཞིག༌ ཅོའ༌ ཛདས༌ཏེ༌ མོལས༌, “ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ ཨི༌ཇིབ༌བི༌ ལྩངས༌པོ༌ནེ༌ ཡུཕ༌རེ༌ཀྲས༌སི༌ ལྩངས༌པོ༌ ཆེན༌མོ༌ ཚག༌པའེ༌ ས༌ཀྱད༌པོ༌ ཏང༌ངད༌, ");
INSERT INTO lbj_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ཀ༌གུན༌ ཀེན༌པའེ༌, ཀེ༌ནས༌པའེ༌, ཀད༌མོན༌པའེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ཧེད༌པའེ༌, པེ༌རིཟ༌པའེ༌, རེ༌ཕ༌པའེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ཨ༌མོར༌པའེ༌, ཀེ༌ནན༌པའེ༌, གིར༌གཤ༌པའེ༌ དང༌ ཡེ༌བས༌པའེ༌ ས༌ཀྱད༌གུན༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ཨབ༌རམ༌མི༌ ན༌མ༌ སཱ༌རཱིའ༌ ཕྲུ༌གུ༌ མ༌ནེ༌ མ༌ཇོར༌, ཨིན༌ནའང༌ ཁོའ༌ ཧཱ༌གར༌ ཟེར༌ཁན༌ནི༌ ཨི༌ཇིབ༌མ༌ ཚེ༌ཡོག༌ཞིག༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","སཱ༌རཱིའི༌ ཨབ༌རམ༌མ༌ ཟེརས༌, “ཡ༌ཝའེ༌ ང༌ ཕྲུ༌གུ༌ སྐྱེ༌ ཅུག༌ག༌ མ༌ཛདས༌པ༌, ཁྱོ༌རང༌ངི༌ ངའེ༌ ཨི༌ཇིབ༌མ༌ ཚེ༌ཡོག༌ ཉམ༌པོ༌ བྲེལ༌ཅོས༌། ཅི༌གྱུས༌, ཁོ༌ གྱུད༌ཏེ༌ ང༌ ཕྲུ༌གུ༌ ཐོབ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ཨབ༌རམ༌མི༌ སཱ༌རཱིའི༌ ཟེར༌ཁན༌བོའ༌ ཁའ༌ཉནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ཏེན༌ན༌བོའེ༌ཕིའ༌ སཱ༌རཱིའི༌, ཨི༌ཇིབ༌མ༌ ཚེ༌ཡོག༌ ཧཱ༌གར༌ ཨབ༌རམ༌མི༌ ན༌མ༌ ཉིས༌པ༌ ཅོ༌ཅེས༌ལ༌ ཏངས༌ ༼འི༌བོ༌ ཇུང༌ ཟ༌ནེ༌ ཨབ༌རམ༌ ཀེ༌ནན༌ནི༌ ཡུལ༌ལི༌ ནང༌ང༌ ཚུགས༌ཏེ༌ ལོ༌ 10 ཆའད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ཨབ༌རམ༌མི༌ ཧཱ༌གར༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ བོར༌པ༌ ཁོ༌ སྐྱེ༌ཅེས༌མ༌ཞིག༌ གྱུར༌། ཏེ༌བོ༌ གྱུས༌ ཆ༌ནའང༌, ཧཱ༌གར༌ ཕོ༌སོ༌ཅན༌ གྱུར༌ཏེ༌ སཱ༌རཱིའ༌ ཀུས༌པ༌ མི༌ཅོ༌ཅེས༌ གོ༌ཟུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ཏེ༌ནེ༌ སཱ༌རཱིའི༌ ཨབ༌རམ༌མ༌ ཟེརས༌, “ཧཱ༌གར༌རི༌ ངའ༌ ངན༌པ༌ ཅོ༌ཅེས༌པོ༌ ཁྱོ༌རང༌ངི༌ སྐྱོན༌ ཨིན༌ནོག༌། ཁྱོ༌རང༌ང༌ ངའེ༌ ང༌རང༌ངི༌ ཚེ༌ཡོག༌པོ༌ ཏངས༌པིན༌ ཡང༌ ཁོའ༌ སྐྱེ༌ཅེས༌མ༌ཞིག༌ གྱུར༌ཁན༌བོ༌ གྱུས༌ ཆ༌ནའང༌, ཁོའེ༌ ངའ༌ ཀུས༌པ༌ ཅོ༌ཅེས༌ ཕངས༌། ཡ༌ཝའེ༌ ང༌དང༌ ཉིས༌ཀོའེ༌ ནང༌ནེ༌ ནོངས༌ཅན༌བོའ༌ ཁྲིམས༌ཅད༌ ཛད༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ཨབ༌རམ༌མི༌ ཟེརས༌, “ལྟོས༌, ཁོ༌ ཁྱོ༌རང༌ངི༌ ཚེ༌ཡོག༌ ཨིན༌ནོག༌, ཁྱོ༌རང༌ ཐད༌ཁན༌བོ༌ ཁོ༌ ཉམ༌པོ༌ ཅོས༌།” ཏེ༌ནེ༌ སཱ༌རཱིའི༌ ཧཱ༌གར༌ལ༌ གྱལ༌ལ༌ མ༌ཅོས༌ པ༌སང༌ ཁོ༌ ཏེ༌ ནས༌ས༌ནེ༌ ཤོར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","རི༌སྟོང༌ངི༌ ནང༌ང༌ ཆུ༌མིག༌ཤིག༌གི༌ དུན༌ལ༌ ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ཧཱ༌གར༌ ཐུག༌ག༌ལ༌ སྐྱོདས༌ ༼ཏེ༌ ཆུ༌མིག༌པོ༌ ཤུར༌རི༌ གྱ༌ལམ༌མི༌ཀ༌ ཡོད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ཕོ༌ཉའེ༌ མོལས༌, “ཧཱ༌གར༌, སཱ༌རཱིའི༌ ཚེ༌ཡོག༌, ཁྱོ༌རང༌ ཀ༌ནེ༌ ཡོངས༌པིན༌, ཡང༌ ཀ༌རུ༌ ཆའད༌?” ཁོའེ༌ ཟེརས༌, “ང༌ སཱ༌རཱིའི༌ ངའེ༌ སྤོན༌མོ༌ནེ༌ ཤོར༌ཏེ༌ ཆའད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ཁོའ༌ མོལས༌, “རང༌ངི༌ སྤོན༌མོ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ སོང༌, ཡང༌ ཁོའེ༌ ཝང༌ངི༌ ཡོག༌ག༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ རྩི༌ མི༌ཉན༌ཅེས༌ མང༌པོ༌ ཕེལ༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ཡང༌སྐྱར༌ མོལས༌, “ཁྱོ༌རང༌ ཕན༌ཅེས༌མ༌ཞིག༌ ཨིན༌ནོག༌, ཡང༌ ཁྱོ༌རང༌ང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ཨིན༌། ཁྱོ༌རང༌ངི༌ ཁོའེ༌ མིང༌ང༌ ཨིཤ༌མ༌ཨེལ༌ ཏོག༌ ༼ཀ༌བོའེ༌ ཏོན༌ ནི༌ དཀོན༌མཆོག༌གི༌ སན༌ན༌ ཛདས༌༽, ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ངི༌ རྡུག༌ངལ༌གུན༌ ཡ༌ཝའེ༌ སན༌ན༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ཁྱོ༌རང༌ངི༌ བུ༌ཚ༌བོ༌ ནག༌ཚོགས༌སི༌ བུང༌བུ༌ ཙོགས༌ སྐྱོང༌པོ༌ དང༌ ཁའ༌མི༌ཉན༌ ཡོང༌ཨིན༌། ཁོའེ༌ མི༌ཚང༌མ༌ལ༌ ཡང༌ མི༌ཚང༌མའེ༌ ཁོའ༌ གྱབ༌གལ༌ ཅོ༌ཨིན༌། ཁོ༌ ཁོ༌རང༌ངི༌ སྤུན༌ ཚང༌མ༌ ཉམ༌པོ༌ མ༌ནེ༌ མི༌ཐུན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ཧཱ༌གར༌རི༌ ཁོའ༌ ཞལ༌ཏ༌ སལ༌ཁན༌ནི༌ ཡ༌ཝའ༌ ཡང༌ཚན༌ཞིག༌ ཉམ༌པོ༌ བོད༌ད༌ ཛད༌ཏེ༌ ཟེརས༌, “ཉེ༌རང༌ ནི༌ ངའ༌ ཟིགས༌ཁན༌ནི༌ དཀོན༌མཆོག༌ ཨིན༌ནོག༌།” ཁོའེ༌ སམ༌ “ཅི༌ ངའེ༌ ངོས༌པོའ༌ ངའ༌ ཟིགས༌ཁན༌ནི༌ དཀོན༌མཆོག༌ ཇལ༌ཏེ༌ ཨིན༌ནོག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཏེ༌ ཆུ༌དོང༌བོའ༌, ཀ༌དེཤ༌ དང༌ བེ༌རིད༌ གྲོང༌ཁྱེར༌རི༌ པར༌ལ༌ ཡོད༌ཁན༌ནི༌ བེར༌ལ༌ཧཱའི༌རོའི༌ ཟེར༌ར༌ནོག༌ ༼ཀ༌བོའེ༌ ཏོན༌ ནི༌ ངའ༌ ཟིགས༌ཁན༌ སོན༌པོ༌ ཞུགས༌ཁན༌ནི༌ ཆུ༌དོང༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ཨབ༌རམ༌མ༌ ཧཱ༌གར༌ གྱུད༌ཏེ༌ བུ༌ཚ༌ཞིག༌ སྐྱེས༌, ཡང༌ ཨབ༌རམ༌མི༌ ཁོའ༌ ཨིཤ༌མ༌ཨེལ༌ མིང༌ང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ཧཱ༌གར༌ལ༌ ཨིཤ༌མ༌ཨེལ༌ སྐྱེ༌ ཟ༌ནེ༌ ཨབ༌རམ༌མ༌ ལོ༌ 86 ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ཨབ༌རམ༌མི༌ ལོ༌ 99 ཨིན༌ ཟ༌ནེ༌ ཁོའ༌ ཡ༌ཝ༌ ཇལ༌ ཡང༌ མོལས༌, “ང༌ ནི༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌ ཨིན༌, ངའ༌ ཨིད༌ཤེས༌ཅན༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌ ནོངས༌མེད༌ཁན༌ནི༌ མི༌ཚེ༌ཞིག༌ པུད༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ངའེ༌ ཁྱོ༌རང༌ དང༌ ངའེ༌ ཕར༌ལ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌བོ༌ སྟན༌པོ༌ ཅོས༌ཏེ༌ ཁྱོ༌རང༌ང༌ པུར༌གྱུད༌ མང༌པོ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ཨབ༌རམ༌མི༌ གོ༌ སྒུས༌ཏེ༌ ཆག༌ཕུལས༌ ཡང༌ དཀོན༌མཆོག༌གི༌ ཁོའ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ངའེ༌ འི༌ ཆད༌དོན༌བོ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཅོའད༌། ཁྱོ༌རང༌ གྱལ༌ཁམས༌ མང༌པོའེ༌ ཕ༌མེས༌པོ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌རང༌ང༌ ཨབ༌རམ༌ མ༌ཟེར༌ར༌ ཨབ༌ར༌ཧམ༌ ཟེར༌ཨིན༌, ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁྱོ༌རང༌ གྱལ༌ཁམས༌ མང༌པོའེ༌ ཕ༌མེས༌པོ༌ གྱུར༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ངའེ༌ ཁྱོ༌རང༌ང༌ པུར༌གྱུད༌ མང༌པོ༌ ཏང༌ཨིན༌ ཀ༌གུན༌ གྱལ༌ཁམས༌ མང༌པོ༌ གྱུར༌ཨིན༌ ཡང༌ ཁོང༌གུན༌ནི༌ ནང༌ནེ༌ གྱལ༌པོ༌གུན༌ བིང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ངའེ༌ ཁྱོ༌རང༌ དང༌ ང༌ ཡང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ནི༌ པར༌ལ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌, ཀ༌བོ༌ ང༌ ཁྱོ༌རང༌ དང༌ ཁོང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཨིན༌ཁན༌བོ༌ མི༌རབས༌ནེ༌ མི༌རབས༌ ལུས༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ཡང༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཀེ༌ནན༌ནི༌ ཡུལ༌ གང༌པོ༌ ཏང༌ཨིན༌ ཀ༌རུ༌ དག༌ས༌ ཁྱོ༌རང༌ ཞན༌ཡུལ༌ལི༌ མི༌ ཙོགས༌ལ༌ དུག༌ཨིན༌ ཡོད༌, འི༌ ས༌ཀྱད༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ནི༌ ལག༌ག༌ ཏུས༌གྱུན༌ནི༌ གྱུ༌ནོར༌རི༌ ཚུལ༌ལ༌ ལུས༌ཨིན༌ ཡང༌ ང༌ ཁོང༌གུན༌ནི༌ དཀོན༌མཆོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཨབ༌ར༌ཧམ༌མ༌ མོལས༌, “ངའེ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཆད༌དོན༌ ཅོ༌ཁན༌བོ༌ ཁྱོ༌རང༌ངི༌ ཁའ༌ཉན༌གོས༌ ཡང༌ ཡོང༌ཅེས༌ཅན༌ནི༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ ཚང༌མེའང༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ གུན༌ནི༌ འི༌ ཆད༌དོན༌བོ༌ ཅོས༌, ཁྱོ༌ཞ༌གུན༌ནི༌ ཕྲོའ༌ ཡོད༌ཁན༌ནི༌ བུ༌ཚ༌ ཚང༌མའེ༌ སུན༌ནད༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ངའ༌ དང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕར༌ལ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌ནི༌ སྟགས༌སི༌ ཚུལ༌ལ༌ ཁྱོ༌ཞའེ༌ སུན༌ནད༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕྲུ༌གུ༌ བུ༌ཚ༌གུན༌ལ༌ ཞག༌པོ༌ 8 ཆའ༌ཅིག༌ སུན༌ནད༌ ཅོ༌གོས༌, ཏེ༌བོ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ ཅིག༌པོ༌ མན༌པ༌ ཁྱོ༌རང༌ངི༌ ཁང༌པའེ༌ ནང༌ང༌ སྐྱེས༌ཁན༌ དང༌ ཞན༌ མི༌རིགས༌གུན༌ནི༌ ཀ༌ནེ༌ ཉོ༌ཁན༌ནི༌ ཚེ༌ཡོག༌ གུན༌ལའང༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","བུ༌ཚ༌ ཚང༌མའ༌ སུན༌ནད༌ ཅོ༌གོས༌། ངའེ༌ ཏུས༌གུན༌ ལུས༌ཤེས༌སི༌ ཆད༌དོན༌ ནི༌ སྟགས༌པོ༌ ཁྱོ༌ཞའེ༌ ཟུགས༌པོའེ༌ཀ༌ ལུས༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","སུན༌ནད༌ མ༌ཅོས༌ཁན༌ནི༌ བུ༌ཚ༌གུན༌ ངའེ༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཕིང༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ངའེ༌ ཆད༌དོན༌བོ༌ ཅགས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","དཀོན༌མཆོག༌གི༌ ཨབ༌ར༌ཧམ༌མ༌ འི༌བོའང༌ མོལས༌, “ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌རང༌ངི༌ ན༌མའ༌ སཱ༌རཱིའ༌ མ༌ཟེར༌ར༌ སཱ༌ར༌ ཟེར༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ངའེ༌ ཁོའ༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌, ཏན༌ཏན༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཁོ༌ གྱུད༌ཏེ༌ བུ༌ཚ༌ཞིག༌ ཏང༌ཨིན༌། ཁོ༌ གྱལ༌ཁམས༌ མང༌པོའེ༌ ཨ༌མ༌ གྱུར༌ཨིན༌ ཡང༌ ཁོའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ཕྲོའ༌ གྱལ༌པོ༌ མང༌པོ༌ བིང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ཨབ༌ར༌ཧམ༌མི༌ ཆག༌ཕུལས༌ ཨིན༌ནའང༌ གོད༌ཅེས༌ ཡོངས༌ཏེ༌ སམ༌, “ང༌ ལོ༌ 100 ལོན༌ཏེ༌ ཀ༌ཟུག༌གི༌ ཨ༌བ༌ གྱུར༌ཉན༌ཨིན༌?” ཡང༌ “སཱ༌ར༌ ལོ༌ 90 སོང༌ཏེ༌ ཀ༌ཟུག༌གི༌ ཕྲུ༌གུ༌ སྐྱེ༌ཉན༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ཁོའེ༌ དཀོན༌མཆོག༌ག༌ ཞུས༌, “ཉེ༌རང༌ངི༌ ཅིན༌ལབས༌པོ༌ ཨིཤ༌མ༌ཨེལ༌ལ༌ སལ༌ལ༌ ཛད༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ མོལས༌, “མན༌ ཁྱོ༌རང༌ངི༌ ན༌མ༌ སཱ༌ར༌ བུ༌ཚ༌ཞིག༌ སྐྱེ༌ཨིན༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ཁོའེ༌ མིང༌ང༌ ཨི༌སཱག༌ ཏག༌ཨིན༌། ངའེ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌བོ༌ ཁོ༌ དང༌ ཁོའེ༌ པུར༌གྱུད༌གུན༌ ཉམ༌པོ༌ ཐའ༌མེད༌པ༌ ལུས༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ཁྱོ༌རང༌ངི༌ ཞུ༌ཝ༌ ཕུལ༌ཁན༌ ནང༌ཞིན༌ ངའེ༌ ཨིཤ༌མ༌ཨེལ༌ལའང༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌། ཁོའ༌ ཕྲུ༌གུ༌ མང༌པོ༌ ཇོར༌ཏེ༌ ཁོའེ༌ པུར༌གྱུད༌ མང༌པོ༌ ཕེལ༌ཅུག༌ཨིན༌ ཡང༌ ཁོ༌ ཝང༌སྲུལ༌པ༌ རྕུག༌ཉིས༌སི༌ ཨ༌བ༌ གྱུར༌ཨིན༌། ངའེ༌ ཁོའེ༌ གྱལ༌ཁམས༌པོ༌ བྲག༌པོ༌ གྱུར༌ཅུག༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ཨིན༌ནའང༌ ངའེ༌ ཆད༌དོན༌བོ༌ ཁྱོ༌རང༌ངི༌ བུ༌ཚ༌ ཨི༌སཱག༌ ཉམ༌པོ༌ བོར༌རད༌, ཀ༌བོ༌ སྟིང༌མ༌ ལོ༌ འིན༌ན༌ ཏུས༌པོའི༌ཀ༌ སཱ༌ར༌ གྱུད༌ཏེ༌ ཁྱོ༌རང༌ང༌ སྐྱེ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","དཀོན༌མཆོག༌གི༌ ཨབ༌ར༌ཧམ༌ ཉམ༌པོ༌ ཞལ༌ཏ༌ མོལ༌ ཚར༌ར༌ཅིག༌ ཁོང༌ ཀེན༌ལ༌ སྐྱོདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ཏེན༌ན༌ ཞག༌ག༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ ཨབ༌ར༌ཧམ༌མི༌ བུ༌ཚ༌ ཨིཤ༌མ༌ཨེལ༌, ཁོའེ༌ ཁང༌པའེ༌ ནང༌ང༌ སྐྱེ༌ཁན༌ ཡང༌ ཉོ༌ཁན༌ བུ༌ཚ༌ ཚེ༌ཡོག༌ ཚང༌མ༌ལ༌ སུན༌ནད༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ཨབ༌ར༌ཧམ༌མ༌ སུན༌ནད༌ ཅོ༌ ཟ༌ནེ༌ ཁོའ༌ ལོ༌ 99 ཆའད༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ཡང༌ ཁོའེ༌ བུ༌ཚ༌ ཨིཤ༌མ༌ཨེལ༌ལ༌ ལོ༌ 13 ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ཏེན༌ན༌ ཞག༌ག༌ ཁོང༌ ཉིས༌ཀོའ༌ སུན༌ནད༌ ཅོས༌ཏེ༌ ཨིན༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ཡང༌ ཁོའེ༌ ཁང༌པའེ༌ ནང༌ང༌ སྐྱེ༌ཁན༌ དང༌ ཉོ༌ཁན༌ བུ༌ཚ༌ ཚེ༌ཡོག༌ ཚང༌མ༌ལའང༌ སུན༌ནད༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ཞག༌ཤིག༌ ཉིང༌གུང༌ངི༌ ཏུས༌ ཨབ༌ར༌ཧམ༌ མམ༌རེ༌ ལྕང༌མ༌གུན༌ནི༌ དུན༌ལ༌ ཁོ༌རང༌ངི༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ དུགས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཁོའ༌ ཡ༌ཝ༌ ཇལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ཁོའེ༌ སྐྱེན༌ལ༌ ལྟས༌པ༌ འ༌ཟམ༌ཤིག༌ག༌ མི༌ སུམ༌ ལངས༌ཏེ༌ ཐོང༌། ཁོང༌གུན༌ ཐོང༌ང༌ཅིག༌, ཁོ༌ བང༌ཏངས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཐུག༌ག༌ སོང༌, ཡང༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ གོ༌ སྒུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ཁོའེ༌ ཟེརས༌, “ངའེ༌ གཙོ༌བོ༌ ཀལ༌ཏེས༌ ཉེ༌རང༌ངི༌ ང༌ འོས༌པ༌ སམ༌མད༌ན༌ ཉེ༌རང༌ངི༌ ཞབས༌ཏོག༌པ༌ ངའེ༌ ཁང༌པ༌ སྐྱོད༌ད༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ཉེ༌ཞའ༌ འི༌ཀ༌ ལྕང༌མའེ༌ སིལ༌ལ༌ ངལ༌ཚོས༌ཏེ༌ ཞུགས༌ས༌ཛད༌ ངའེ༌ ཉེ༌ཞའེ༌ རྐང༌པ༌ ཁྲུ༌ཅེས༌ལ༌ ཆུ༌ ཁྱོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ངའེ༌ ཁང༌པ༌ སྐྱོད༌ཅེས༌པོའེ༌, ངའ༌ ཉེ༌ཞའ༌ དོན༌ཅེས༌ལ༌ ཁར༌ཇི༌ ཁྱོང༌ ཅུག༌ག༌ཛད༌ ཀ༌བོའེ༌ ཉེ༌ཞའ༌ བེས༌ལ༌ སྐྱོད༌ཅེས༌སི༌ ནང༌ང༌ རོགས༌ ཐོབ༌ཨིན༌།” ཁོང༌གུན༌ནི༌ མོལས༌, “གྱལ༌ལ༌ རག༌,” ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌བོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ཨབ༌ར༌ཧམ༌ གྱོགས༌པ༌ ཀུར༌རི༌ ནང༌ང༌ སོང༌ ཡང༌ སཱ༌ར༌ ཟེརས༌, “གྱོགས༌པ༌ པག༌པའེ༌ གྱལ༌ཤོག༌ བན༌ཤིག༌ ཁྱོངས༌ཏེ༌ ཏ༌གི༌ སྲོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ཏེ༌ནེ༌ ཁོ༌ བང༌ཏངས༌ཏེ༌ བ༌ལང༌གུན༌ནི༌ ཕྲོའ༌ སོང༌ཏེ༌ བེ༌ཙོ༌ གྱགས༌པ༌ཞིག༌ ལྡམས༌ ཡང༌ ཏེ༌བོ༌ སད༌ཏེ༌ ཡོག༌པོའ༌ ཏངས༌, ཁོའེ༌ གྱོགས༌པ༌ ཏེ༌བོ༌ སྐོལ༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ཁོའེ༌ ཞོ༌, འོ༌མ༌ དང༌ ཤ༌ སྐོལ༌ཁན༌གུན༌ ཁོང༌གུན༌ནི༌ དུན༌ལ༌ རིགས༌ ཡང༌ ཁོང༌གུན༌ དོན༌ཏང༌ དོན༌ ཟ༌ནེ༌ ཨབ༌ར༌ཧམ༌ ལྕང༌མའེ༌ ཡོག༌ག༌ ཁོང༌གུན༌ནི༌ དུན༌ལ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ཁོང༌གུན༌ནི༌ ཁོའ༌ ཏྲིའ༌ ཛདས༌, “ཁྱོ༌རང༌ངི༌ ན༌མ༌ སཱ༌ར༌ ཀ༌ནེ༌ ཡོད༌?” ཁོའེ༌ ལན༌ཏངས༌, “ཀུར༌རི༌ ནང༌ཀུག༌ག༌ ཡོད༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ཁོང༌ ཅིག༌གི༌ མོལས༌, “སྟིང༌མ༌ ལོ༌ འིན༌ན༌ ཏུས༌པའེ༌ཀ༌ ང༌ ལོགས༌ཏེ༌ ཡོང༌ཨིན༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ན༌མའ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ཏེ༌ ཡོང༌ཨིན༌།” སཱ༌ར༌ ཀུར༌རི༌ སྒོའེ༌ དུན༌ལ༌ ཉན༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ཨབ༌ར༌ཧམ༌ དང༌ སཱ༌ར༌ ལོ༌ མང༌པོ༌ སོང༌ཏེ༌ རྒད༌པོ༌ ཡོད༌པིན༌, ཡང༌ སཱ༌ར༌ ཟླ༌ཁྲག༌ བིང༌ཅེས༌པོའང༌ ཆད༌ཏེ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ཏེན༌ན༌བོའེ༌ཕིའ༌ སཱ༌ར༌ གོདས༌ ཡང༌ སམ༌, “ང༌ དང༌ ངའེ༌ ཞིད༌མད༌ སྒས༌ཏེ༌ ཀ༌ཟུག༌གི༌ ང༌ཞའ༌ ཕྲུ༌གུ༌ ཇོར༌ཏེ༌ སྐྱིད༌པོའེ༌ ཏུས༌ཤིག༌ ཐོབ༌ཐུབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཨབ༌ར༌ཧམ༌མ༌ མོལས༌, “ཅི༌ཕིའ༌ སཱ༌ར༌ གོད༌ཏེ༌ ཟེར༌ར༌ནོག༌, ‘ཅི༌ དེན༌བའ༌ ང༌ ཙོགས༌ རྒད༌མོ༌ བུ༌མོ༌ ཞིག༌ག༌ ཕྲུ༌གུ༌ ཇོར༌ཨིན༌ན༌?’ ");
INSERT INTO lbj_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ཡ༌ཝའ༌ ཅོ༌མི༌ཉན༌ཅེས༌ ཅི༌ ཡོད༌ཀྱག༌? ཀ༌ཟུག༌ ངའེ༌ ཟེརས༌ སྟིང༌མ༌ ལོ༌ འིན༌ན༌ ཏུས༌པའེ༌ཀ༌ ང༌ ལོགས༌ཏེ༌ ཡོང༌ ཟ༌ནེ༌ སཱ༌ར༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ཏེ༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","སཱ༌ར༌ ཇིགས༌ པ༌སང༌ ཁོའེ༌ ཟུན༌ ཏངས༌ཏེ༌ ཟེརས༌, “ང༌ མ༌གོད༌པིན༌ལེ༌།” ཨིན༌ནའང༌ ཡ༌ཝའེ༌ མོལས༌, “མན༌, ཁྱོ༌རང༌ གོདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","དོན༌ཏང༌ དོན༌ ཚར༌ར༌ཅིག༌ མི༌གུན༌ སྐྱོད༌ད༌ལ༌ ཞངས༌ཏེ༌ སོ༌དོམ༌མི༌ གྱལ༌ས༌ ཆོགས༌ལ༌ ཟིགས༌ ཡང༌ ཨབ༌ར༌ཧམ༌ དན༌སྐྱལ༌ལ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ཡ༌ཝའེ༌ ཁོང༌རང༌ང༌ མོལས༌, “ངའེ༌ ཅོ༌ཅེས༌ཅན༌བོ༌ ཨབ༌ར༌ཧམ༌མ༌ ཤད༌ད༌? ");
INSERT INTO lbj_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ཁོའེ༌ པུར༌གྱུད༌གུན༌ གྱལ༌ཁམས༌ ཀྲག༌པོ༌ དང༌ ཝང༌ཅན༌ གྱུར༌ཨིན༌ ཡང༌ ཁོང༌གུན༌ གྱུད༌ཏེ༌ གྱལ༌ཁམས༌ ཚང༌མ༌ལ༌ ཅིན༌ལབས༌ ཐོབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ངའེ༌ ཁོ༌ ལྡམས༌ཏེ༌ ཨིན༌, ཁོའེ༌ ཁོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ དང༌ ཁོའེ༌ ཁང༌པའེ༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ལ༌ འོས༌པ༌ དང༌ ཀྲང༌པོ༌ ཅོ༌ཨིན༌ ཡ༌ཝའེ༌ ལམ༌མི༌ཀ༌ གྲུལ༌ཅེས༌ལ༌ བཀའ༌ཏང༌ཨིན༌། ཏེ༌ནེ༌ ངའེ༌ ཁོ༌ ཉམ༌པོ༌ ཁ༌ཆད༌ ཅོས༌ཁན༌ ཚང༌མ༌ གྲུབ༌ཅུག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཨབ༌ར༌ཧམ༌མ༌ མོལས༌, “སོ༌དོམ༌ དང༌ གོ༌མོ༌ར༌པ༌ གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཉད༌གལ༌ ཀྲག༌པོ༌ ཕོགས༌ཏེ༌ དུག༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ སྡིག༌པ༌གུན༌ མ༌ ངན༌པ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ང༌ ཐུར༌ལ༌ སོང༌ཏེ༌ ཁོང༌ངི༌ སྡིག༌པ༌, ཉད༌གལ༌ ཀལ༌ཁན༌ ཙོགས༌ ངན༌པ༌ དུག༌ག༌ ལྟེན༌, ཀལ༌ཏེས༌ མེད༌ན༌, ངའེ༌ ཤེས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ཏེ༌ནེ༌ མི༌ ཉིས༌ཀོ༌ སོ༌དོམ༌ གྱལ༌སའེ༌ ཆོགས༌ལ༌ སོང༌ ཨིན༌ནའང༌ ཨབ༌ར༌ཧམ༌ ཡ༌ཝའ༌ ཉམ༌པོ༌ ལངས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ཨབ༌ར༌ཧམ༌ ཡ༌ཝའེ༌ དུན༌ལ༌ སོང༌ཏེ༌ ཏྲིས༌, “དེན༌བའ༌ ཉེ༌རང༌ངི༌ ཀྲང༌པོ༌ མི༌གུན༌ ངན༌པ༌གུན༌ ཉམ༌པོ༌ མེད༌ཁན༌ ཛད༌ཅེས༌ ཨིན༌ན༌ལེ༌? ");
INSERT INTO lbj_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ཀལ༌ཏེས༌ གྱལ༌སའེ༌ ནང༌ང༌ ཀྲང༌པོ༌ མི༌ 50 ཡོད༌ན༌, ཉེ༌རང༌ངི༌ གྱལ༌ས༌ གང༌མ༌ མེད༌ཁན༌ ཛད༌ཨིན༌ན༌, ཉེ༌རང༌ངི༌ 50 སྐྱོབ༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌གུན༌ལ༌ ཤགས༌པ༌ མི༌སལ༌ལ༌? ");
INSERT INTO lbj_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ཉེ༌རང༌ངི༌ འི༌ཟུག༌ ཅོའ༌ མན༌ནེ༌ མི༌ཛད༌, ཀྲང༌པོ༌ མི༌གུན༌ ངན༌པ༌གུན༌ ཉམ༌པོ༌ སད༌ད༌ མི༌ཛད༌། ཅི༌ཕིའ༌ ཉེ༌རང༌ངི༌ ཀྲང༌པོ༌གུན༌ སྡིག༌ཅན༌གུན༌ ཙོགས༌ ཐེན༌, ཏན༌ཏན༌ལ༌ ཉེ༌རང༌ངི༌ ཏེ༌ཟུག༌ ཅོའ༌ མི༌ཛད༌། ཇིག༌རྟེན༌པ༌གུན༌ལ༌ ཁྲིམས༌ཅད༌ད༌ ཛད༌ཁན༌བོའེ༌ ཀྲང༌པོ༌ ཅི༌ མི༌ཛད༌?” ");
INSERT INTO lbj_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ཡ༌ཝའེ༌ ལན༌སལས༌, “ཀལ༌ཏེས༌ སོ༌དོམ༌མི༌ ནང༌ང༌ ངའ༌ མི༌ ཀྲང༌པོ༌ 50 ཐོབ༌ན༌, ངའེ༌ གྱལ༌ས༌ གང༌པོའ༌ ཁོང༌གུན༌ནི༌ ཏོན༌ལ༌ ཤགས༌པ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ཏེ༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ ཡང༌སྐྱར༌ ཟེརས༌, “ཧམ༌པ༌ ཅོས༌ཏེ༌ ཡ༌ཝའ༌ ཟེར༌ཁན༌ ངའ༌ ཐལ༌བ༌ དང༌ ཀོག༌ཐལ༌ ཙོགས༌ ཨིན༌, ");
INSERT INTO lbj_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ཀལ༌ཏེས༌ ཀྲང༌པོ༌གུན༌ནི༌ ཀྲངས༌ཀ༌ 50 མན༌པ༌ 45 ཡོད༌ན༌ ཅི༌ ཉེ༌རང༌ངི༌ ལྔ༌ ཉུ༌ངུན༌ ཡོད༌ཅེས༌པའེ༌ གྱལ༌ས༌ གང༌པོ༌ མེད༌ཁན༌ ཛད༌ཨིན༌ན༌?” ཡ༌ཝའེ༌ ལན༌སལས༌ “ཀལ༌ཏེས༌ ངའ༌ ཀྲང༌པོ༌ མི༌ 45 ཐོབ༌ན༌ ངའེ༌ གྱལ༌ས༌ མེད༌ཁན༌ མི༌ཅོ༌?” ");
INSERT INTO lbj_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ཨབ༌ར༌ཧམ༌མི༌ ཡང༌སྐྱར༌ ཟེརས༌, “ཀལ༌ཏེས༌ 40 མ༌ནེ༌ མེད༌ན༌?” ཡ༌ཝའེ༌ མོལས༌, “40 ཏོན༌ལ༌ ངའེ༌ གྱལ༌ས༌ མེད༌ཁན༌ མི༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ཨབ༌ར༌ཧམ༌མི༌ ཟེརས༌, “གཙོ༌བོ༌ལེ༌ ངའེ༌ ཟེར༌ཅེས༌ཅན༌བོའ༌ ཇུ༌ཇུ༌ ཐུགས༌སྲོ༌ མ༌སྐྱོད༌, ཀལ༌ཏེས༌ 30 མ༌ནེ༌ མེད༌ན༌?” ཁོང༌ངི༌ མོལས༌, “ཀལ༌ཏེས༌ 30 ཐོབ༌ན༌ ངའེ༌ གྱལ༌ས༌ མེད༌ཁན༌ མི༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ཨབ༌ར༌ཧམ༌མི༌ ཟེརས༌, “གཙོ༌བོ༌ལེ༌ ཇུ༌ཇུ༌ ངའེ༌ ཧམ༌པ༌ ཅོ༌ཅེས༌པོའ༌ གོངས༌པ༌ སལ༌, ཀལ༌ཏེས༌ 20 མ༌ནེ༌ མེད༌ན༌?” ཁོང༌ངི༌ མོལས༌, “20 ཏོན༌ལ༌ ངའེ༌ གྱལ༌ས༌ མེད༌ཁན༌ མི༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ཏེ༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ ཟེརས༌, “ཇུ༌ཇུ༌ ཐུགས༌སྲོ༌ མ༌སྐྱོད༌ད༌ ངའ༌ ཡང༌ ལན༌ཅིག༌ ཟེར༌ཅུག༌, ཀལ༌ཏེས༌ 10 མ༌ནེ༌ མེད༌ན༌?” ཁོང༌ངི༌ མོལས༌, “10 ཏོན༌ལ༌ ངའེ༌ གྱལ༌ས༌ མེད༌ཁན༌ མི༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ཡ༌ཝའེ༌ ཨབ༌ར༌ཧམ༌ ཉམ༌པོ༌ ཞལ༌ཏ༌ མོལ༌ ཚར༌ཏེ༌ སྟིང༌ནེ༌ ཁོང༌ སྐྱོད༌ད༌ ཛདས༌ ཡང༌ ཨབ༌ར༌ཧམ༌ ཁོ༌རང༌ངི༌ ཀུར༌ལ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ཕོ༌ཉ༌ ཉིས༌ཀོ༌ ཏེན༌ན༌ ཕི༌ཏོག༌ སོ༌དོམ༌མ༌ ལེབ༌བ༌ཅིག༌, ལོད༌ གྱལ༌སའེ༌ གྱས༌སྒོའེ༌ཀ༌ དུགས༌ཏེ༌ ཡོད༌པིན༌། ཁོང༌གུན༌ ཐོང༌ང༌ཅིག༌ ཁོ༌ ཐུག༌ག༌ལ༌ སོང༌ ཡང༌ ཀུས༌པ༌ སྟན༌ཏེ༌ གོ༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ སྒུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ཡང༌ ཁོའེ༌ ཟེརས༌, “སྤོན༌བོ༌གུན༌, ཇུ༌ཇུ༌ ཉེ༌ཞའེ༌ ཞབས༌ཏོག༌པའེ༌ ཁང༌པ༌ སྐྱོད༌ད༌ ཛད༌ ཡང༌ རྐང༌པ༌ ཁྲུའ༌ ཛད༌ཏེ༌ ཚན༌ལ༌ ཞུགས༌ས༌ཛད༌, ཏེ༌ནེ༌ ང༌མོ༌ནེ༌ ཞངས༌ཏེ༌ ཉེ༌ཞ༌གུན༌ རང༌ངི༌ བེས༌ལ༌ སྐྱོད༌།” ཁོང༌གུན༌ནི༌ མོལས༌ “ཐུག༌རྗེ༌ཆེ༌, ང༌ཞའེ༌ ཚན༌བོ༌ གྱལ༌སའེ༌ ལམ༌མི༌ཀ༌ ཕུད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ཨིན༌ནའང༌ ཁོའེ༌ རང༌གྱལ༌ ཏངས༌ པ༌སང༌ ཁོང༌གུན༌ ཁོ༌ ཉམ༌པོ༌ ཁོའེ༌ ཁང༌པ༌ སྐྱོདས༌། ལོད༌དི༌ ཁོང༌གུན༌ནི༌ ཕིའ༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ དང༌ དོན༌ཏང༌ གྱས༌པ༌ ཅོ༌ཅུགས༌ ཡང༌ ཁོང༌གུན༌ནི༌ དོནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ཁོང༌གུན༌ ཉིད༌ལོག༌ག༌ སྐྱོད༌དི༌ སང༌ སྔུན༌ལ༌ སོ༌དོམ༌པ༌ ཞུ༌ནུ༌ དང༌ རྒད༌པོ༌ བུ༌ཚ༌ ཚང༌མའེ༌ ལོད༌དི༌ ཁང༌པའ༌ ཐའ༌ སྐོརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ཁོང༌གུན༌ནི༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ ལོད༌ལ༌ ཏྲིས༌, “དི༌རིང༌ ཚན༌ལ༌ ཁྱོ༌རང༌ངི༌ ཁང༌པ༌ དུག༌ག༌ལ༌ ཡོངས༌ཁན༌ནི༌ མི༌གུན༌ ཀ༌ནེ༌ ཡོད༌, ང༌ཞའ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོ༌ཉན༌ཅེས༌ལ༌ ཁོང༌གུན༌ ཕི༌ལོག༌ག༌ ཕིང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ཁོང༌གུན༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏང༌ང༌ལ༌ ལོད༌ ཕི༌ལོག༌ག༌ བིང༌ཏེ༌ སོང༌ ཡང༌ སྒོ༌བོ༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཇུ༌ཇུ༌ ཛ༌འོ༌གུན༌ འི༌ཙོགས༌ ལས༌ ངན༌པ༌ མ༌ཅོ༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ལྟོས༌, ངའ༌ བུ༌ཚ༌ ཉམ༌པོ༌ མ༌ དྲེས༌ཁན༌ནི༌ བུ༌མོ༌ ཉིས༌ ཡོད༌། ངའེ༌ ཁོང༌གུན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕིའ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཨིན༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཅི༌ ཅོ༌ཨིན༌ སམ༌ནའང༌ ཅོས༌, ཨིན༌ནའང༌ འི༌ མི༌གུན༌ལ༌ ཅའང༌ མ༌ཅོ༌ཤིག༌། ཁོང༌གུན༌ ངའེ༌ གྲོན༌པོ༌ ཨིན༌ཅེས༌པོའེ༌ ངའེ༌ ཁོང༌གུན༌ སྐྱོབ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཟེརས༌, “ང༌ཞ༌གུན༌ནི༌ ལམ༌མི༌ ཀ༌ནེ༌ ལོངས༌, ཁྱོད༌ ཞན༌མ༌ ཡུལ༌ལི༌མི༌, ང༌ཞའ༌ ལམ༌སྟོན༌ ཏང༌ཁན༌ ཁྱོ༌རང༌ སུ༌ ཨིན༌། ང༌ཞ༌གུན༌ནི༌ ཁྱོ༌རང༌ང༌ ཁོང༌གུན༌ནི༌ སང༌ མང༌ང༌ ངན༌པ༌ ཅོ༌ཨིན༌།” སྒོ༌བོ༌ ཅག༌ཅེས༌ལ༌ ཁོང༌གུན༌ནི༌ ལོད༌ གྱབ༌བ༌ སྲན༌ཏྲེ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ཨིན༌ནའང༌ ནང༌ཀུག༌ག༌ ཡོད༌ཁན༌ནི༌ མི༌ ཉིས༌ཀོའེ༌ ལོད༌ ནང༌ཀུག༌ག༌ དྲུད༌ཏེ༌ སྒོ༌བོ༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ སྒོའེ༌ དུན༌ལ༌ ཡོད༌ཁན༌ མི༌ཚང༌མ༌ལ༌ སྒོ༌བོ༌ མི༌ཐོང༌ཅེས༌ལ༌ ཞ༌ར༌ གྱུར༌ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ཕོ༌ཉ༌ ཉིས༌ཀོའེ༌ ལོད༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ང༌ འི༌རུ༌ ཞན༌སུ༌ ཡོད༌? བུ༌ཚ༌, བུ༌མོ༌, བུ༌མོའེ༌ མག༌པ༌ ཡ༌ ཞན༌ ཉེན༌གྲུང༌ འི༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌, ཁོང༌གུན༌ འི༌ཀ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱེར༌, ");
INSERT INTO lbj_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ཅིའ༌ཟེར༌ན༌ ང༌ཞའེ༌ འི༌ ནས༌ས༌བོ༌ མེད༌ཁན༌ ཅོ༌ཅེས༌ ཨིན༌། འི༌ མི༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཉད༌གལ༌ ངན༌པ༌བོ༌ ཡ༌ཝའེ༌ སན༌ན༌ ཛདས༌ཏེ༌ ང༌ཞ༌གུན༌ འི༌ ནས༌ས༌ མེད༌ཁན༌ ཅོ༌ཅེས༌ལ༌ ལམ༌ཅུག༌ག༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ཏེ༌ནེ༌ ལོད༌ ཁོའེ༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོ༌ཅེས༌ཅན༌ བུ༌ཚ༌གུན༌ནི༌ཀ༌ སོང༌, ཡང༌ ཟེརས༌, “གྱོགས༌པ༌ འི༌ ནས༌ས༌ནེ༌ བིང༌། ཡ༌ཝའེ༌ འི༌ ནས༌ས༌བོ༌ མེད༌ཁན༌ ཛད༌ཅེས༌ དུག༌།” ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཁོའེ༌ ཡངས༌པ༌ ཏང༌ཏེ༌ ཨིན༌ནོག༌ སམ༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ང༌ཏོག༌ ནམ༌ལངས༌ལ༌ ཕོ༌ཉ༌གུན༌ནི༌ ལོད༌ལ༌ མོལས༌, “གྱོགས༌པ༌ རང༌ངི༌ ན༌མ༌ དང༌ བུ༌མོ༌ ཉིས༌ཀོ༌ ཁྲིད༌ཏེ༌ འི༌ཀ༌ནེ༌ བིང༌ཏེ༌ སོང༌ ཏེ༌མན༌ནེ༌ གྱལ༌ས༌བོ༌ མེད༌ཁན༌ ཅོའ༌ཅིག༌ ཁྱོ༌རང༌ངའང༌ མེད༌ཁན༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ལོད༌དི༌ ཐེ༌ཚོམས༌ ཅོས༌པ༌ ཕོ༌ཉ༌གུན༌ནི༌ ཁོ༌, ཁོའེ༌ ན༌མ༌ དང༌ བུ༌མོ༌ ཉིས༌ཀོ༌ ལག༌པ༌ ཐམས༌ཏེ༌ གྱལ༌ས༌ནེ༌ ཕི༌ལོག༌ག༌ ཕིངས༌ཏེ༌ ཁྱེརས༌, ཡ༌ཝའེ༌ ཁོའེ༌ཀ༌ སྙིང༌རྗེ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ཏེ༌ནེ༌ ཕོ༌ཉ༌ ཅིག༌གི༌ མོལས༌, “ཤོར༌ ཡང༌ རང༌ངི༌ མི༌ཚེའེ༌ སྐྱོབ༌, གྱབ༌ ལོགས༌ཏེ༌ མ༌ལྟ༌, ཡང༌ ཤི༌ མི༌ཤི༌ཅེས༌སི༌ ཕིའ༌ ལུང༌པའེ༌ ནང༌ང༌ མ༌དུག༌ག༌ བྲག༌གུན༌ ཆོགས༌ལ༌ ཤོར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ལོད༌དི༌ ཟེརས༌, “ཇུ༌ཇུ༌ སྤོན༌བོ༌ལེ༌ ང༌ཞ༌གུན༌ལ༌ ཏེ༌ཟུག༌ ཅོ༌ཅུག༌ག༌ མ༌ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ཉེ༌རང༌ངི༌ ངའེ༌ མི༌ཚེ༌ སྐྱོབ༌བ༌ ཛད༌ཏེ༌ ངའ༌ ཐུག༌རྗེ༌ ཆེན༌མོ༌ ཛདས༌། ཨིན༌ནའང༌ ངའ༌ འ༌ ཐག༌རིང༌ང༌ ཡོད༌ཁན༌ནི༌ བྲག༌གུན༌ ཚག༌པ༌ ཤོར༌ཐུབ༌ཅེས༌ མེ༌རག༌། ངའ༌ ཇིགས༌ས༌རག༌ འི༌ རྡུག༌ངལ༌བོ༌ ངའེ༌ཀ༌ ལེབས༌ཏེ༌ ང༌ མེད༌ཁན༌ ཆའ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ཟིགས༌སའང༌, འ༌ གྲོང༌ཁྱེར༌བོ༌ དུན༌ལ༌ དུག༌ལེ༌, ང༌ ཏེ༌རུ༌ ཤོར༌ཅུག༌ག༌ ཛད༌, ཏེ༌བོ༌ ས༌ཆ༌ ཆུ༌ངུན༌ཞིག༌ མ༌ནེ༌ མི༌དུག༌ ཡང༌ ང༌ ཐར༌ཨིན༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ཁོང༌ངི༌ ལན༌སལས༌, “ངའེ༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ འི༌བོའང༌ ཅོ༌ཨིན༌, ང༌ཞའེ༌ གྲོང༌ཁྱེར༌བོ༌ མེད༌ཁན༌ མི༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","གྱོགས༌པ༌ སོང༌ ཁྱོ༌ཞ༌གུན༌ ཏེ༌རུ༌ ལེབས༌ཏེ༌ མ༌ནེ༌ ངའ༌ ཅའང༌ ཅོ༌མི༌ཉན༌།” ལོད༌དི༌ ཏེ༌ གྲོང༌ཁྱེར༌རི༌ མིང༌ང༌ ཟོ༌འར༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ལོད༌ ཟོ༌འར༌ གྲོང༌ཁྱེར༌ལ༌ ལེབ༌བ༌ཅིག༌ ཉི༌མ༌ ཤར༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མེ༌ དང༌ མུ༌ཟི༌ ཆར༌པ༌ ནམ༌ཁའ༌ནེ༌ སོ༌དོམ༌ དང༌ གོ༌མོ༌རའི༌ གྱལ༌ས༌ གུན༌ནི༌ཀ༌ ཕབ༌བ༌ ཛདས༌, ");
INSERT INTO lbj_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ཡང༌ གྱལ༌ས༌གུན༌ དང༌ ལུང༌པ༌ གང༌པོ༌, མ༌ཚད༌ ཏེ༌ནང༌ང༌ དུག༌ཁན༌ དང༌ རྩ༌ཁའ༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ཨིན༌ནའང༌ ལོད༌དི༌ ན༌མའེ༌ གྱབ༌ ལོགས༌ཏེ༌ ལྟས༌པ༌ ཁོ༌ ཚཱའེ༌ ཀ༌ཝ༌ ཞིག༌ག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","སྟིང༌མ༌ཞག༌ག༌ ང༌ཏོག༌ ང༌མོ༌ནེ༌ ཨབ༌ར༌ཧམ༌, ཡ༌ཝ༌ ཉམ༌པོ༌ ཞལ༌ཏ༌ སལ༌ཁན༌ནི༌ ནས༌སའེ༌ཀ༌ ཡང༌སྐྱར༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ཁོའེ༌ ཐུར༌ལ༌ སོ༌དོམ༌, གོ༌མོ༌ར༌ དང༌ ལུང༌པ༌ ཚང༌མ༌ ལྟས༌པ༌ ཁོའ༌ མེ༌ བྲག༌པོ༌ བར༌ ཟ༌ནེ༌ བིང༌ཁན༌ ཙོགས༌ སྐན༌ཏེ༌ ཏུད༌པ༌ ཀེན༌ལ༌ བིང༌ཨིན༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ཏེ༌ ལུང༌པའེ༌ གྱལ༌ས༌གུན༌ མེད༌ཁན༌ ཅོའ༌ ཛད༌ ཟ༌ནེ༌ ཁོང༌ངི༌ ཨབ༌ར༌ཧམ༌ ཨིད༌ཏུ༌ ཛད༌ཏེ༌ ལོད༌ ཏེ༌ གྱལ༌ས༌གུན༌ མེད༌ཁན༌ ཅོའ༌ ཛད༌ཅེས༌སི༌ ཇིགས༌ནང༌ནེ༌ ཕིང༌ཏེ༌ ཁྱོང༌ང༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ལོད༌ ཟོ༌འར༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ དུག༌ག༌ལ༌ ཇིགས༌པ༌, ཁོ༌ དང༌ ཁོའེ༌ བུ༌མོ༌ ཉིས༌ཀོ༌ རི༌གུན༌ནི༌ཀ༌ བྲག༌ཕུགས༌ ཤིག༌གི༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","བུ༌མོ༌ ཆེན༌མོ༌བོའེ༌ ཁོ༌རང༌ངི༌ ནོ༌མོའ༌ ཟེརས༌, “ང༌དང༌ངི༌ ཨ༌བ༌ སྒས༌ཏེ༌ ཨིན༌ནོག༌ ཡང༌ འི༌ ནས༌སའེ༌ ནང༌ང༌ ང༌དང༌གུན༌ནི༌ ན༌མ༌ ཅོས༌ཏེ༌ ཕྲུ༌གུ༌ ཇོར༌ཅེས༌ལ༌ བུ༌ཚ༌ཞིག༌ མེད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ཡོང༌ ང༌དང༌ངི༌ ཨ༌བ༌ ར༌རོས༌ ཅུགས༌ཏེ༌ ང༌དང༌གུན༌ནི༌ པུར༌གྱུད༌ ལུས༌ཤེས༌ལ༌ ཁོང༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ཏེན༌ན༌ ཚན༌ལ༌ ཁོང༌གུན༌ནི༌ ཨ༌བའ༌ ཆང༌ ཐུང༌ཅེས༌ལ༌ ཏངས༌ ཡང༌ བུ༌མོ༌ ཆེན༌མོ༌བོའེ༌ ཁོ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོས༌། ཨིན༌ནའང༌ ལོད༌ མ༌ སྲན༌ཏྲེ༌ ར༌རོས༌ཏེ༌ ཡོད༌ པ༌སང༌ ཁོའ༌ ཏེ༌བོ༌ གྱུས༌ མ༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","སྟིང༌མ༌ཞག༌པོ༌ བུ༌མོ༌ ཆེན༌མོ༌བོའེ༌ ནོ༌མོའ༌ ཟེརས༌, “དའང༌ ཚན༌ལ༌ ང༌ ཨ༌བ༌ ཉམ༌པོ༌ དུགས༌པིན༌, དི༌རིང༌ ཚན༌ལ༌ ཁོང༌ ར༌རོས༌ ཅུག༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཁོང༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོས༌། ཏེ༌ནེ༌ ཨ༌བ༌ གྱུད༌ཏེ༌ ང༌དང༌ངི༌ ང༌དང༌ རང༌ངི༌ པུར༌གྱུད༌ སྐྱོབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ཏེ༌ནེ༌ ཏེ༌ ཚན༌བོའ༌ ཁོང༌གུན༌ནི༌ ཨ༌བ༌ ཆང༌ ཏངས༌ ཡང༌ བུ༌མོ༌ ཆུང༌ང༌བོའེ༌ ཁོ༌ ཉམ༌པོ༌ དུགས༌། ཡང༌སྐྱར༌ ཁོ༌ མ༌ བྲག༌པོ༌ ར༌རོས༌ཏེ༌ ཡོད༌ པ༌སང༌ ཁོའ༌ ཏེ༌བོ༌ གྱུས༌ མ༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ཏེན༌ན༌ ཟུག༌ག༌ ལོད༌དི༌ བུ༌མོ༌ ཉིས༌ཀོ༌ ཁོང༌རང༌གུན༌ནི༌ ཨ༌བ༌ གྱུད༌ཏེ༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","བུ༌མོ༌ ཆེན༌མོའ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ ཀ༌བོའ༌ ཁོའེ༌ མོ༌འབ༌ མིང༌ ཏགས༌། ཁོ༌ ནི༌ འི༌ ཏུས༌སི༌ མོ༌འབ༌པའེ༌ ཕ༌མེས༌པོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","བུ༌མོ༌ ཆུ༌ངུན༌བོའང༌ བུ༌ཚ༌ཞིག༌ སྐྱེས༌, ཀ༌བོའ༌ ཁོའེ༌ བིན༌ཨམ༌མི༌ མིང༌ ཏགས༌། ཁོ༌ ནི༌ འི༌ ཏུས༌སི༌ ཨེམ༌མོན༌པའེ༌ ཕ༌མེས༌པོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ཨབ༌ར༌ཧམ༌ མམ༌རེ༌ནེ༌ ནེ༌གེཝ༌ ཡུལ༌ཇོངས༌ལ༌ སོང༌ ཡང༌ ཀ༌དེཤ༌ དང༌ ཤུར༌རི༌ པར༌རི༌ ནས༌སའེ༌ ནང༌ང༌ ཚུགས༌ཏེ༌ དུགས༌། སྟིང༌ནེ༌ ཁོ༌ གེ༌རར༌རི༌ ནང༌ང༌ དུག༌ ཟ༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ཨབ༌ར༌ཧམ༌མི༌ ཁོའེ༌ ན༌མ༌ སཱ༌ར༌, “ཁོ༌ ངའེ༌ སྲིང༌མོ༌ ཨིན༌” ཟེར༌ པ༌སང༌ གེ༌རར༌རི༌ གྱལ༌པོ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ སཱ༌ར༌ ན༌མ༌ ཅོ༌ཅེས༌ལ༌ ཁོའེ༌ ཁར༌ལ༌ ཁྱོང༌ང༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ཨིན༌ནའང༌ ཚན༌ལ༌ ཁོའ༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ དཀོན༌མཆོག༌ ཇལ༌ཏེ༌ མོལས༌, “ཁྱོ༌རང༌ ཤི༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ངི༌ ཁྱེར༌ཁན༌ནི༌ བུ༌མོ༌ ན༌མ༌ ཅོ༌ཁན༌ཞིག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ཏ༌རོང༌ ཚག༌པ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཁོའ༌ ལག༌པའང༌ མ༌རྩེའ༌ ཨིན༌པིན༌, ཁོའེ༌ ཟེརས༌, “གཙོ༌བོ༌ལེ༌, ཉེ༌རང༌ངི༌ ང༌ཞའེ༌ གྱལ༌ཁམས༌ ནོངས༌མེད༌པོ༌ མེད༌ཁན༌ ཛད༌ཨིན༌ན༌? ");
INSERT INTO lbj_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ཨབ༌ར༌ཧམ༌ ཁོ༌རང༌ངི༌ སཱ༌ར༌ ‘ཁོ༌ ངའེ༌ སྲིང༌མོ༌ ཨིན༌’ ཟེར༌ར༌རག༌པིན༌ ཡང༌ བུ༌མོ༌བོའེང༌ ཟེརས༌, ‘ཁོ༌ ངའེ༌ མིང༌བོ༌ ཨིན༌’ ངའེ༌ ཏེ༌བོ༌ སྐྱོན༌ མ༌ཏང༌ང༌ སེམས༌ ལག༌མོ༌ ཉམ༌པོ༌ ཅོས༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ཏེན༌ན༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ ཁོའ༌ མོལས༌, “འོ༌ན༌ ང༌ གྱུས༌ཡོད༌ ཁྱོ༌རང༌ངི༌ ཏེ༌བོ༌ སེམས༌ ལག༌མོ༌ ཉམ༌པོ༌ ཅོས༌ པ༌སང༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ངའེ༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཅོ༌ མ༌ཅུགས༌པིན༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཁོའ༌ ལག༌པ༌ རྩེ༌ མ༌ཅུགས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ཏ༌ བུ༌མོ༌བོ༌ ཁོ༌རང༌ངི༌ མག༌པ༌ ལོགས༌ཏེ༌ ཏོང༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ ལུང༌སྟོན༌པ༌ཞིག༌ ཨིན༌, ཡང༌ ཁོའེ༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ མོས༌ལམ༌ ཞུ༌ཅེས༌པའེ༌ ཁྱོ༌རང༌ ཤི༌ མི༌ཤི༌། ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ཁོ༌ ལོགས༌ཏེ༌ མ༌ཏང༌ན༌, ཏན༌ཏན༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ མི༌ ཚང༌མ༌ ཤི༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","སྟིང༌མ༌ཞག༌ ང༌མོ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཁོ༌རང༌ངི༌ ལས༌མི༌ ཚང༌མ༌ བོད༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཇུང༌ཁན༌ ཚང༌མ༌ ཤདས༌ ཡང༌ ཁོང༌གུན༌ སྲན༌ཏྲེ༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ཏེ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཨབ༌ར༌ཧམ༌མ༌ བོད༌ཏེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ང༌ཞ༌གུན༌ལ༌ འི༌བོ༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ངའེ༌ གྱལ༌སྲིད༌དི༌ཀ༌ འི༌ ནོད༌པ༌ ཁོང༌ཅེས༌ལ༌ ངའེ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཅི༌ ངན༌པ༌ ཅོས༌། ཁྱོ༌རང༌ངི༌ ཅོས༌ཁན༌ ཙོགས༌ སུ༌ཞིག༌གིའང༌ མི༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ཅི༌ཕིའ༌ ཁྱོ༌རང༌ངི༌ འི༌བོ༌ ཅོས༌པིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ཨབ༌ར༌ཧམ༌མི༌ ལན༌ཏངས༌, “‘འི༌ ནས༌སའེ༌ ནང༌ང༌ དཀོན༌མཆོག༌ག༌ རྩི༌ཝ༌ ཅོ༌ཁན༌ སུ༌ཞིག༌གའང༌ མེད༌གྲོ༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ ན༌མའེ༌ ཕིའ༌ ང༌ སད༌ད༌ནོག༌’ སམ༌། ");
INSERT INTO lbj_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","དེན༌བའ༌ ཟེར༌ན༌ ཁོ༌ ངའེ༌ སྲིང༌མོ༌ ཨིན༌, ཁོ༌ ངའེ༌ ཨ༌བའེ༌ བུ༌མོ༌, ཨིན༌ནའང༌ ང༌ཞའེ༌ ཨ༌མ༌ སོ༌སོ༌ ཨིན༌ ཡང༌ ངའེ༌ ཁོ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","དཀོན༌མཆོག༌གི༌ ངའ༌ ང༌རི༌ ཨ༌བའེ༌ ཁང༌པ༌ནེ༌ ཞན༌ཡུལ༌གུན༌ལ༌ ལམ༌ཅུག༌ ཟ༌ནེ༌, ངའེ༌ ཁོའ༌ ཟེར༌པིན༌, ‘ང༌དང༌ ཀ༌རུ༌ ཆ༌ནའང༌ ཚང༌མ༌ལ༌ ང༌ ཁྱོ༌རང༌ངི༌ མིང༌བོ༌ ཨིན༌ ཟེར༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ ཕིའ༌ ཐུག༌རྗེ༌ ཅོས༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ཏེ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ སཱ༌ར༌ ཨབ༌ར༌ཧམ༌མ༌ ལོགས༌ཏེ༌ ཏངས༌, ཏེ༌ མ༌ཚད༌ ཁོའེ༌ ཁོའ༌ ལུག༌ དང༌ བ༌ལང༌ དང༌ ཚེ༌ཡོག༌ གུན༌ ཏངས༌ ");
INSERT INTO lbj_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ཡང༌ ཟེརས༌, “ཨབ༌ར༌ཧམ༌ ངའེ༌ ས༌ཀྱད༌ ཚང༌མ༌ ལྟོས༌, ཁྱོ༌རང༌ ཀ༌རུ༌ ཚུགས༌ཏེ༌ དུག༌ཨིན༌ སམ༌ནའང༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ཁོའེ༌ སཱ༌ར༌ ཟེརས༌, “ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌ཁན༌གུན༌ལ༌ ཁྱོ༌རང༌ ནོངས༌མེད༌ ཨིན༌ཁན༌ སྟན༌ཅེས༌སི༌ ཕིའ༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ མིང༌བོའ༌ མུལ༌ སྟོང༌ ཅིག༌ ཏང༌ངད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ཏེ༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ དཀོན༌མཆོག༌ག༌ མོས༌ལམ༌ ཞུས༌ ཡང༌ དཀོན༌མཆོག༌གི༌ ཨ༌བི༌མེ༌ལེག༌, ཁོའེ༌ ན༌མ༌ དང༌ ཁོའེ༌ ཡོག༌མོ༌གུན༌ ཕན༌ཅུག༌ག༌ ཛད༌པ༌ ཡང༌སྐྱར༌ ཁོང༌གུན༌ལ༌ ཕྲུ༌གུ༌ ཇོར༌ཐུབ༌, ");
INSERT INTO lbj_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ཅིའ༌ཟེར༌ན༌ ཨབ༌ར༌ཧམ༌མི༌ ན༌མ༌ སཱ༌རའེ༌ ཞས༌ཏེ༌, ཡ༌ཝའེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཁར༌རི༌ ནང༌ང༌ ཡོད༌ཁན༌ བུ༌མོ༌ ཚང༌མའེ༌ ཕྲུ༌གུ༌ ཇོར༌ཅེས༌སི༌ ཁྱུད༌པོ༌ མེད༌ཁན༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ཡ༌ཝའེ༌ སཱ༌ར༌ ཁོང༌རང༌ངི༌ ཞལ༌ཆད༌ ཛད༌ཁན༌ ནང༌ཞིན༌ ཅིན༌ལབས༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ཁོ༌ སྐྱེ༌ཅེས༌མ༌ཞིག༌ གྱུར༌ ཡང༌ ཨབ༌ར༌ཧམ༌ སྒས༌ཏེ༌ ཡོད༌ནའང༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ནི༌ ཏུས༌པོའེ༌ཀ༌ ཁོའེ༌ ན༌མ༌ སཱ༌རའ༌ བུ༌ཚ༌ཞིག༌ སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ཨབ༌ར༌ཧམ༌མི༌ སཱ༌རའ༌ སྐྱེ༌ཁན༌ནི༌ ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ ཨི༌སཱག༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ཡང༌ ཨི༌སཱག༌ག༌ ཞག༌པོ༌ རྒྱད༌ ཆའ༌ཅིག༌, ཨབ༌ར༌ཧམ༌མི༌ ཁོའ༌ སུན༌ནད༌ ཅོས༌ ཀ༌ཟུག༌ དཀོན༌མཆོག༌གི༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ཨི༌སཱག༌ སྐྱེ༌ ཟ༌ནེ༌ ཨབ༌ར༌ཧམ༌མ༌ ལོ༌ གྱ༌ ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ཡང༌ སཱ༌རའེ༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ངའ༌ སྐྱིད༌པོ༌ དང༌ ཧབ༌གོད༌ ཁྱོང༌ང༌ ཛདས༌། འི༌ ནས༌ཚུལ༌ ཚོར༌ཁན༌ ཚང༌མ༌ ང༌ ཉམ༌པོ༌ གའ༌མོ༌ ཅོས༌ཏེ༌ གོད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ཏེ༌ནེ༌ ཁོའེ༌ ཟེརས༌, “སཱ༌རའེ༌ ཕྲུ༌གུ༌གུན༌ལ༌ པི༌བི༌ ཏང༌ཨིན༌ སམས༌ཏེ༌ སུའི༌ ཨབ༌ར༌ཧམ༌མ༌ ཟེར༌ཉན༌ཨིན༌? རྒད༌པོའེ༌ ཏུས༌ལའང༌ ངའེ༌ ཁོའ༌ བུ༌ཚ༌ཞིག༌ ཏངས༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ཕྲུ༌གུ༌ ལྡན༌ཨིན༌ སོང༌ ཡང༌ ཕྲུ༌གུའ༌ པི༌བི༌ ཅད༌དི༌ ཞག༌ག༌ ཨབ༌ར༌ཧམ༌མི༌ གྲོན༌ ཆེན༌མོ༌ཞིག༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ཨིན༌ནའང༌ ཨབ༌ར༌ཧམ༌མི༌ བུ༌ཚ༌, ཨི༌ཇིབ༌པ༌ ཡོག༌མོ༌ ཧཱ༌གར༌ལ༌ སྐྱེ༌ཁན༌ ཨིཤ༌མ༌ཨེལ༌ལི༌ ཨི༌སཱག༌ག༌ ཁྲེལ༌གོད༌ ཏང༌ཨིན༌ ཐོང༌པ༌ ");
INSERT INTO lbj_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","སཱ༌རའེ༌ ཨབ༌ར༌ཧམ༌མ༌ ཟེརས༌, “འི༌ ཚེ༌ཡོག༌ བུ༌མོ༌ དང༌ ཁོའེ༌ བུ༌ཚའ༌ ཕིངས༌ཏེ༌ ཡང༌ ནས༌ས༌ ཞིག༌ག༌ ལམ༌ཅུག༌། ངའེ༌ བུ༌ཚ༌ ཨི༌སཱག༌ག༌ ཐོབ༌ཅེས༌ཅན༌ནི༌ ནོར༌སྐལ༌བོ༌ འི༌ ཚེ༌ཡོག༌གི༌ བུ༌ཚ༌ ཉམ༌པོ༌ བགོ༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ཨབ༌ར༌ཧམ༌མ༌ ཚེར༌ཁའ༌ སྲན༌ཏྲེ༌ ཡོངས༌ ཅིའ༌ཟེར༌ན༌ ཨིཤ༌མ༌ཨེལ༌ལའང༌ ཁོའེ༌ བུ༌ཚ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ཁོའ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ བུ༌ཚ༌ དང༌ ཚེ༌ཡོག༌ ཧཱ༌གར༌རི༌ ཕིའ༌ ཚེར༌ མ༌ཚེར༌། ཁྱོ༌རང༌ངི༌ སཱ༌རའེ༌ ཟེར༌ཁན༌བོ༌ ཅོས༌, ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁ༌ཆད༌ ཅོས༌ཁན༌ ནང༌ཞིན༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ ཨི༌སཱག༌ གྱུད༌ཏེ༌ ཕེལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ངའེ༌ ཚེ༌ཡོག༌གི༌ བུ༌ཚའང༌ པུར༌གྱུད༌ མང༌པོ༌ ཏངས༌ཏེ༌ ཁོང༌གུན༌ གྱལ༌ཁམས༌ གྱུར༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཁོའང༌ ཁྱོ༌རང༌ངི༌ བུ༌ཚ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ཐོ༌རེ༌ཟུག༌པོ༌ ངོ༌ཏོག༌ ང༌མོ༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ ཧཱ༌གར༌ལ༌ ཟའ༌ཅེས༌ དང༌ སྐྱ༌པའེ༌ ནང༌ང༌ ཆུ༌ སྐངས༌ཏེ༌ ཁོའེ༌ གྱབ༌བ༌ ཀལས༌ ཡང༌ ཕྲུ༌གུ༌ ཉམ༌པོ༌ ཁོ༌ ལམ༌ཅུགས༌། ཁོང༌གུན༌ བེར༌ཤེ༌བའེ༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ ཁྱམས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ཆུ༌ ཚང༌མ༌ ཚར༌ར༌ཅིག༌ བུ༌མོའེ༌ ཁོ༌རང༌ངི༌ ཕྲུ༌གུ༌བོ༌ ལྕང༌མ༌ ཆུ༌ངུན༌ཞིག༌གི༌ སིལ༌ལ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ཏེ༌ནེ༌ ཧ༌ལམ༌ མི༌ཀྲར༌ གུབ༌ཅུ༌ ཟམ༌ཤིག༌ ཐག༌རིང༌ང༌ སོང༌ཏེ༌ དུགས༌, ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ སམ༌, “ངའ༌ ང༌རང༌ངི༌ བུ༌ཚ༌ ཤི༌ཨིན༌ ལྟ༌ཉན༌ཅེས༌ མེ༌རག༌།” ཡང༌ ཁོ༌ ཏེ༌ཀ༌ དུགས༌ཏེ༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","དཀོན༌མཆོག༌གི༌ བུ༌ཚ༌ ངུ༌ཁན༌བོ༌ སནས༌ ཡང༌ ནམ༌ཁའ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉའེ༌ ཧཱ༌གར༌ལ༌ མོལས༌, “ཧཱ༌གར༌ ཁྱོ༌རང༌ང༌ ཅི༌ སོང༌? ཇིགས༌ མ༌ཇིགས༌། དཀོན༌མཆོག༌གི༌ བུ༌ཚ༌ ངུ༌ཅེས༌པོ༌ སན༌ན༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","རང༌ངི༌ བུ༌ཚ༌ ལངས༌ཏེ༌ ལག༌པ༌ ཐམས༌ཏེ༌ སོང༌། ངའེ༌ ཁོའེ༌ པུར༌གྱུད༌གུན༌ གྱལ༌ཁམས༌ བྲག༌པོ༌ གྱུར༌ཅུག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ བུ༌མོའེ༌ མིག༌པོ༌ ཕེའ༌ ཛདས༌ ཡང༌ ཁོའ༌ ཆུ༌དོང༌ཞིག༌ ཐོང༌། ཁོ༌ སོང༌ཏེ༌ སྐྱ༌པ༌ ཆུའི༌ སྐངས༌ཏེ༌ བུ༌ཚ༌ ཆུ༌ ཐུང༌ང༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","བུ༌ཚ༌ ལྡན༌ཨིན༌ སོང༌ ཡང༌ དཀོན༌མཆོག༌ ཁོ༌ ཉམ༌པོ༌ ཡོད༌པིན༌། ཁོ༌ པ༌རན༌ ཟེར༌སའེ༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ དུགས༌ ཡང༌ དའ༌ ཞུ༌ ཀོལ༌ཁན༌ མ༌ ཁས༌པ༌ཞིག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ཁོང༌གུན༌ ཏེ༌རུ༌ ཡོད༌ ཟ༌ནེ༌ ཁོའེ༌ ཨ༌མའེ༌ ཁོའེ༌ ཕིའ༌ ན༌མ༌ ཨི༌ཇིབ༌ནེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ཏེ༌ ཏུས༌ལ༌ ཨ༌བི༌མེ༌ལེག༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ནི༌ འུ༌སྐྱོང༌ ཕི༌ཀོལ༌ལི༌ ཨབ༌ར༌ཧམ༌མ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཅོ༌ཁན༌ ཚང༌མའེ༌ ནང༌ང༌ དཀོན༌མཆོག༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ངའ༌, ངའེ༌ ཕྲུ༌གུ༌གུན༌ དང༌ ངའེ༌ མིར༌གྱུད༌གུན༌ལ༌ གོབ༌སྐོར༌ མི༌ཏང༌ ཟེར༌ཏེ༌ དཀོན༌མཆོག༌གི༌ སྐུ༌དུན༌ལ༌ ཁྱོ༌རང༌ངི༌ ནའ༌ ཁུར༌། ངའེ༌ ཁྱོ༌རང༌ང༌ ཐུག༌རྗེ༌ ཅོ༌ཁན༌ ཙོགས༌ ཁྱོ༌རང༌ངིའང༌ འི༌ གྱལ༌ཁམས༌ ཉམ༌པོ༌ ཅོས༌ ཀ༌རུ༌ ཁྱོ༌རང༌ དུགས༌ཏེ༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ཨབ༌ར༌ཧམ༌མི༌ ཟེརས༌, “ངའེ༌ ནའ༌ ཁུར༌རད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ཨབ༌ར༌ཧམ༌མི༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ཁོའེ༌ ཡོག༌པོ༌གུན༌ནི༌ ཆུ༌དོང༌ ཀོགས༌ཏེ༌ ཁྱེར༌ཁན༌ནི༌ ལས༌ ངན༌པའེ༌ སྐོར༌ལ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ཨ༌བི༌མེ༌ལེག༌གི༌ ཟེརས༌, “ངའ༌ གྱུས༌མེད༌, འི༌བོ༌ སུའི༌ ཅོས༌། ཁྱོ༌རང༌ངི༌ ངའ༌ ཤད༌ད༌ མེ༌རག༌ ཡང༌ ངའ༌ དི༌རིང༌ མ༌ནེ༌ འི༌བོའེ༌ སྐོར༌ལ༌ མ༌ ཚོར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ཏེ༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ལུག༌ དང༌ བ༌ལང༌ གུན༌ ཏངས༌ ཡང༌ ཁོང༌ ཉིས༌ཀོའེ༌ ཆད༌དོན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ཁོའེ༌ ལུག༌ཁྱུའི༌ ཕྲོ༌ནེ༌ ལུ༌གུ༌ རྡུན༌ སོ༌སོའ༌ ཕེས༌, ");
INSERT INTO lbj_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ཡང༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཁོའ༌ ཏྲིས༌, “ཁྱོ༌རང༌ངི༌ ལུག༌ཁྱུའི༌ ཕྲོ༌ནེ༌ ལུ༌གུ༌ རྡུན༌ སོ༌སོའ༌ ཕེ༌ཅེས༌སི༌ ཏོན༌བོ༌ ཅི༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ཨབ༌ར༌ཧམ༌མི༌ ལན༌སལས༌, “འི༌ ལུ༌གུ༌ རྡུན༌བོ༌ ལེན༌ན༌ ཛད༌ཏེ༌ འི༌ ཆུ༌དོང༌ ངའེ༌ བྲུས༌ཏེ༌ ཨིན༌ཁན༌བོའེ༌ སྤང༌པོ༌ སལ༌ཅེས༌སི༌ ཆད༌དོན༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ཏེ༌བོའེ༌ཕིའ༌ ཏེ༌ ས༌ཆ༌བོའ༌ བེར༌ཤེ༌བ༌ ཟེརས༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌ཀ༌ ཁོང༌ ཉིས༌ཀོའེ༌ དམ༌ཆའ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ཁོང༌གུན༌ནི༌ བེར༌ཤེ༌བའེ༌ ནང༌ང༌ དམ༌ཆ༌ ཅོས༌ཏེ༌ སྟིང༌ནེ༌, ཨ༌བི༌མེ༌ལེག༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ནི༌ འུ༌སྐྱོང༌ ཕི༌ཀོལ༌ ལོགས༌ཏེ༌ ཕི༌ལིས༌ཏིའ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ཨབ༌ར༌ཧམ༌མི༌ བེར༌ཤེ༌བའེ༌ ནང༌ང༌ ཀྲ༌མ༌རིག༌གི༌ ལྕང༌མ༌ ཙུགས༌ ཡང༌ ཡ༌ཝ༌, ཐའ༌མེད༌པའེ༌ དཀོན༌མཆོག༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ཕི༌ལིས༌ཏིའི༌ ནང༌ང༌ ཨབ༌ར༌ཧམ༌ ཏུས༌ མང༌པོ༌ ཞན༌ཡུལ༌ལི༌ མི༌ ཙོགས༌ལ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ལོ༌ ཁ༌ཅིག༌གི༌ སྟིང༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཨབ༌ར༌ཧམ༌མི༌ ཏད༌པའ༌ ཚོད༌ལྟ༌ ཛདས༌། ཁོང༌ངི༌ ཁོའ༌ བོད༌ད༌ ཛདས༌, “ཨབ༌ར༌ཧམ༌།” ཨབ༌ར༌ཧམ༌མི༌ ཟེརས༌, “ང༌ འི༌ཀ༌ནེ༌ ཡོད༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","དཀོན༌མཆོག༌གི༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ བུ༌ཚ༌ ཅིག༌ཅིག༌ ཨི༌སཱག༌ ཀ༌བོའ༌ ཁྱོ༌རང༌ངི༌ མའ༌ ཡ༌ཤ༌ ཅོའད༌, ཁྲིད༌ཏེ༌ མོ༌རའཧ༌ ཡུལ༌ཇོངས༌ལ༌ སོང༌། ཏེ༌རུ༌ ངའེ༌ སྟན༌ཁན༌ནི༌ རི༌ཀ༌ ཁྱོ༌རང༌ངི༌ ཁོའེ༌ སྲོག༌ ངའེ༌ ཕིའ༌ ཆོད༌པ༌ ཕུལ༌ཏེ༌ མེའ༌ སྲོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌ཏོག༌ ང༌མོ༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ བུང༌བུའ༌ གྱབ༌ཆ༌ སྟདས༌ ཡང༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ ཤིང༌ ཅད༌ཏེ༌ ཀལས༌། ཨི༌སཱག༌ དང༌ ཞན༌ ཡོག༌པོ༌ ཉིས༌ ཁོ༌རང༌ ཉམ༌པོ༌ ཁྲིད༌ཏེ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ནི༌ ནས༌ས༌བོའ༌ ཆ༌ཅེས༌ གོ༌ཟུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ཞག༌ སུམ༌པའེ༌ ཞག༌ག༌ ཨབ༌ར༌ཧམ༌མི༌ ཏེ༌ ནས༌ས༌བོ༌ ཐག༌རིང༌ཞིག༌ནེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ཏེ༌ནེ༌ ཁོའེ༌ ཡོག༌པོ༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞའ༌ འི༌ཀ༌ བུང༌བུ༌ ཉམ༌པོ༌ དུག༌, བུ༌ཚ༌ དང༌ ངའ༌ འ༌ཀ༌ སོང༌ཏེ༌ དཀོན༌མཆོག༌ག༌ ཅོལ༌ཨིན༌, ཅོལ༌ ཚར༌ཏེ༌ སྟིང༌ནེ༌ ང༌ཞའ༌ ལོགས༌ཏེ༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ཨབ༌ར༌ཧམ༌མི༌ ཨི༌སཱག༌ག༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཤིང༌བོ༌ ཁུར༌ཅུགས༌, ཡང༌ ཁོའེ༌ ཀྲི༌ དང༌ སྤར༌ཅེས༌སི༌ ཕིའ༌ སོལ༌ལེ༌ མེ༌ ཁུར༌ཏེ༌ ཁོང༌ ཉིས༌ཀོ༌ གྲུལ༌ཨིན༌ ཆའ༌ ཟ༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ཨི༌སཱག༌གི༌ ཟེརས༌, “ཨ༌བ༌ལེ༌?” ཁོའེ༌ ལན༌ཏངས༌, “ཅི༌ སོང༌ ངའེ༌ བུ༌ཚ༌?” ཨི༌སཱག༌གི༌ ཏྲིས༌, “ང༌དང༌ངི༌ ལག༌ག༌ མེ༌ དང༌ ཤིང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ ལུ༌གུ༌ ཀ༌རེ༌?” ");
INSERT INTO lbj_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ཨབ༌ར༌ཧམ༌མི༌ ལན༌ཏངས༌, “དཀོན༌མཆོག༌ ཁོང༌རང༌ངི༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ ལུ༌གུ༌ སལ༌ལ༌ ཛད༌ཨིན༌” ཡང༌ ཁོང༌ ཉིས༌ཀོ༌ གྲུལ༌ཨིན༌ ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ཁོང༌གུན༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ནི༌ ནས༌སའེ༌ཀ༌ ལེབ༌བ༌ཅིག༌, ཨབ༌ར༌ཧམ༌མི༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌ ཡང༌ ཤིང༌གུན༌ ཏེ༌ཀ༌ རིགས༌། ཏེ༌ནེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཨི༌སཱག༌ ལྡམས༌ཏེ༌ ཆོད༌ཁྲི༌ཀ༌ ཤིང༌གུན༌ནི༌ ཁེ༌ཐོག༌ག༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ཡང༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ སད༌ཅེས༌ལ༌ ཀྲི༌བོ༌ ལེནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ཨིན༌ནའང༌ ཏེན༌ན༌ ཏུས༌ལ༌ ནམ༌ཁའ༌ནེ༌ ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ཁོའ༌ བོད༌ད༌ ཛདས༌, “ཨབ༌ར༌ཧམ༌, ཨབ༌ར༌ཧམ༌།” ཁོའེ༌ ལན༌ཏངས༌, “ང༌ འི༌ཀ༌ནེ༌ ཡོད༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ཁོང༌ངི༌ མོལས༌, “བུ༌ཚའ༌ ལག༌པ༌ མ༌རྩེ༌ ཡ༌ ནོད༌ མ༌སྐྱལ༌། ཁྱོ༌རང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཇིགས༌ དང༌ རྩི༌ཝའེ༌ ནང༌ང༌ མི༌ཚེ༌ ཕུད༌ཁན༌བོ༌ ངའ༌ ཧ༌གོ༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌རང༌ངི༌ རང༌ངི༌ བུ༌ཚ༌ ཅིག༌ཅིག༌པོའང༌ ངའེ༌ ཕིའ༌ ཏང༌ཅེས༌ལ༌ ཐེ༌ཚོམས༌ མ༌ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ཨབ༌ར༌ཧམ༌མི༌ ཀེན༌ལ༌ ལྟས༌, ཁོའ༌ ལུག༌ཕོ༌ ཞིག༌གི༌ ར༌ཅོ༌ ཚེར༌མང༌ངི༌ ནང༌ང༌ ཁད༌ཏེ༌ ཐོང༌། ཏེ༌ནེ༌ ཁོའེ༌ ལུག༌ཕོ༌ ཁྱོངས༌ཏེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ ཚབས༌ལ༌ སྲོག༌ཆོད༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ཨབ༌ར༌ཧམ༌མི༌ ཏེ༌ ནས༌ས༌བོའ༌ “ཡ༌ཝའེ༌ སལ༌ལ༌ ཛད༌ཨིན༌” ཟེར༌ཏེ༌ མིང༌ ཏགས༌། ཡང༌ དང༌དི༌རིང༌ངའང༌ མི༌གུན༌ནི༌, “ཡ༌ཝའེ༌ ཨིན༌ཁན༌ནི༌ རི༌ཀ༌ ཁོང༌ངི༌ སལ༌ལ༌ ཛད༌ཨིན༌” ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ཏེ༌ནེ༌ ནམ༌ཁའ༌ནེ༌ ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ཨབ༌ར༌ཧམ༌མ༌ ལན༌ ཉིས༌པ༌ བོད༌ད༌ ཛད༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","མོལས༌, “ཡ༌ཝའེ༌ མོལས༌, ‘ཁྱོ༌རང༌ངི༌ རང༌ངི༌ བུ༌ཚ༌ ཅིག༌ཅིག༌པོའང༌ ངའེ༌ ཕིའ༌ ཏང༌ཅེས༌ལ༌ ཐད༌ པ༌སང༌ ངའེ༌ ང༌རང༌ངི༌ མིང༌ངི༌ ནང༌ང༌ ནའ༌ ཁུར༌ཏེ༌ ཁ༌ཆད༌ ཅོའད༌, ");
INSERT INTO lbj_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ངའེ༌ ཁྱོ༌རང༌ང༌ ཏན༌ཏན༌ལ༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌, ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ ནམ༌མི༌ སྐར༌མ༌ ཡང༌ ཚོའེ༌ ཐའ༌མའེ༌ པེ༌མ༌ ཙོགས༌ མང༌པོ༌ གྱུར༌ཨིན༌། ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ གྲ༌འོའེ༌ གྱལ༌ས༌གུན༌ ངའ༌ཡོག༌ག༌ ཁྱོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ གྱུད༌ཏེ༌ གྱལ༌ཁམས༌ ཚང༌མ༌ལ༌ ཅིན༌ལབས༌ ཐོབ༌ཨིན༌, ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ བཀའ༌ ཁའ༌ ཉནས༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ཏེ༌ནེ༌ ཁོང༌གུན༌ ཁོང༌རང༌ངི༌ ཡོག༌པོ༌གུན༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ ཁོང༌ ཚང༌མ༌ བེར༌ཤེ༌བའ༌ ལོགས༌ཏེ༌ སོང༌ ཀ༌རུ༌ ཨབ༌ར༌ཧམ༌ ནས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ཏུས༌བན༌ཤིག༌གི༌ སྟིང༌ནེ༌ ཨབ༌ར༌ཧམ༌མ༌ ཁོའེ༌ ནོ༌ ན༌ཧོར༌ལ༌ མིལ༌ཀ༌ གྱུད༌ཏེ༌ ཕྲུ༌གུ༌ ཇོར༌ཁན༌བོ༌ གྱུས༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","གོ༌སྐྱེས༌ བུ༌ཚ༌ ཨུཟ༌, ཁོའེ༌ ནོ༌ བའས༌, ཀེ༌མུའེལ༌ ཨ༌རམ༌མི༌ ཨ༌བ༌, ");
INSERT INTO lbj_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ཀེ༌སིད༌, ཧ༌ཟོ༌, པིལ༌དེས༌, ཡིད༌ལབ༌ དང༌ བེ༌ཐུལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","བེ༌ཐུལ༌ ར༌བེ༌ཀའེ༌ ཨ༌བ༌ གྱུར༌། མིལ༌ཀ༌ གྱུད༌ཏེ༌ ཨབ༌ར༌ཧམ༌མི༌ ནོ༌ ན༌ཧོར༌ལ༌ ཏེ༌ བུ༌ཚ༌ རྒྱད༌ཀོ༌ ཇོར༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","རིའུ༌མ༌ ཟེར༌ཁན༌ནི༌ ཚེ༌ཡོག༌ ན༌མ༌ གྱུད༌ཏེ༌ ན༌ཧོར༌ལ༌ ཁྲི༌བཧ༌, ག༌ཧམ༌, ཏ༌ཧཤ༌ དང༌ མའ༌ཀཧ༌ ཟེར༌ཁན༌ནི༌ བུ༌ཚ༌གུན༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","སཱ༌ར༌ ལོ༌ 127 ཚོག༌པ༌ སོན༌ཏེའ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ཁོ༌ ཀེ༌ནན༌ ཡུལ༌ཇོངས༌སི༌ ཀི༌རི༌འཐ༌ ཨར༌བའི༌ ནང༌ང༌ ཀྲོངས༌ ཀ༌བོའ༌ དག༌ས༌ ཧེབ༌རོན༌ ཟེར༌ར༌ནོག༌ ཡང༌ ཨབ༌ར༌ཧམ༌མི༌ སཱ༌རའེ༌ ཕིའ༌ རྡུག༌པོ༌ ཅོས༌ཏེ༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","སཱ༌རའེ༌ སྤུར༌རི༌ དུན༌ནེ༌ ཁོ༌ ལངས༌ཏེ༌ ཧེད༌དི༌ པུར༌གྱུད༌གུན༌ལ༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ཁྱོ༌ཞ༌གུན༌ནི༌ ཕྲོའ༌ དུག༌ཁན༌ ང༌ ཞན༌ཡུལ༌ལི༌ མི༌ཞིག༌ ཨིན༌, ཇུ༌ཇུ༌ ངའེ༌ ན༌མའེ༌ སྤུར༌ སུབ༌ཅེས༌ལ༌ ངའ༌ ས༌ཀྱད༌ཞིག༌ ཙོང༌ང༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ཧེད༌པའེ༌ བུ༌ཚ༌གུན༌ནི༌ ཨབ༌ར༌ཧམ༌མ༌ ལན༌ཏངས༌, ");
INSERT INTO lbj_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ང༌ཞ༌གུན༌ལ༌ སན༌ནའང༌ ཀ༌ག༌ལེ༌, ང༌ཞའེ༌ ཕྲོའ༌ ཉེ༌རང༌ སྤོན༌བོ༌ ཁྱུད༌ཅན༌ཞིག༌ ཨིན༌ནོག༌། ང༌ཞའེ༌ སྤུར༌ཁང༌ངི༌ ནས༌ས༌ ཉེ༌རང༌ ཐད༌ཁན༌བོའེ༌ ནང༌ང༌ ཉེ༌རང༌ངི༌ ན༌མ༌ སུབ༌བ༌ ཛད༌། ཉེ༌རང༌ང༌ སྤུར༌ཁང༌ངི༌ ནས༌ས༌ ཏང༌ཅེས༌ལ༌ ང༌ཞའ༌ ཚང༌མ༌ ཐད༌པོ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ཏེ༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ གོ༌ སྒུས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཀུས༌པ༌ ཅོས༌ ");
INSERT INTO lbj_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ཡང༌ མོལས༌, “ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌གུན༌ ངའེ༌ ང༌རང༌ངི༌ ན༌མ༌ སུབ༌ཅུག༌ཅེས༌ལ༌ ཐད༌དད༌ན༌, ཇུ༌ཇུ༌ ཟོ༌ཧར༌རི༌ བུ༌ཚ༌ ཨེ༌ཕོ༌རོན༌ལ༌ ");
INSERT INTO lbj_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ཁོའེ༌ ཨིན༌ཁན༌ མེཁ༌ཕི༌ལའི༌ བྲག༌ཕུག༌པོ༌ ངའ༌ ཙོང༌ཅེས༌ལ༌ མོལ༌ལའང༌, ཀ༌བོ༌ ཁོའེ༌ ཞིང༌ངི༌ ཐའ༌མའ༌ དུག༌། ཤི༌ཁན༌གུན༌ སུབ༌ཅེས༌སི༌ ཕིའ༌ ཏེ༌ ནས༌ས༌བོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དུན༌ལ༌ རིན༌ དྲན༌དྲ༌ ཏངས༌ཏེ༌ ངའེ༌ ཉོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","གྱལ༌སའེ༌ སྒོའེ༌ཀ༌ ཛོམས༌ཁན༌ནི༌ ཧེད༌པ༌གུན༌ནི༌ ཕྲོའ༌ ཨེ༌ཕོ༌རོན༌ནའང༌ ཡོད༌པིན༌, ཏེ༌ཀ༌ ཡོད༌ཁན༌ ཚང༌མའེ༌ དུན༌ལ༌ ཁོའེ༌ ཨབ༌ར༌ཧམ༌མ༌ ལན༌ཏངས༌, ");
INSERT INTO lbj_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ཀ༌ག༌ལེ༌ ཉན༌ན༌ཛད༌, ངའེ༌ ཉེ༌རང༌ང༌ ཞིང༌ གང༌པོ༌ དང༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ བྲག༌ཕུག༌པོའང༌ ཏང༌ཨིན༌། འི༌ཀ༌ ཡོད༌ཁན༌ མི༌ཚང༌མའེ༌ དུན༌ལ༌ ཏེ༌བོ༌ ངའེ༌ ཉེ༌རང༌ང༌ ཏང༌ངད༌, ཉེ༌རང༌ངི༌ ཤི༌ཁན༌བོ༌ སུབ༌བ༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ཡང༌སྐྱར༌ ཨབ༌ར༌ཧམ༌མི༌ ཧེད༌པ༌གུན༌ནི༌ དུན༌ལ༌ སྒུས༌ཏེ༌ ཀུས༌པ༌ སྟནས༌, ");
INSERT INTO lbj_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ཡང༌ ཚང༌མའེ༌ དུན༌ལ༌ ཁོའེ༌ ཨེ༌ཕོ༌རོན༌ལ༌ ཟེརས༌, “ཇུ༌ཇུ༌ ངའ༌ ཉན༌ན༌ཛད༌ ངའེ༌ ཞིང༌ གང༌པོའེ༌ རིན༌བོ༌ ཏང༌ཨིན༌, ལེན༌ན༌ ཛད༌དའང༌ ཏེ༌ནེ༌ ངའ༌ ང༌རང༌ངི༌ ན༌མ༌ ཏེ༌རུ༌ སུབ༌ ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ཨེ༌ཕོ༌རོན༌ནི༌ ལན༌ཏངས༌, ");
INSERT INTO lbj_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ཀ༌ག༌ལེ༌ ས༌ཆའེ༌ རིན༌བོ༌ མུལ༌ ཞིབ༌གྱ༌ མ༌ནེ༌ མ༌ནོག༌, ང༌དང༌ ཉིས༌ཀོའེ༌ ཕར༌ལ༌ ཏེ༌བོ༌ ཅི༌ ཨིན༌ནོག༌། ཉེ༌རང༌ངི༌ ན༌མ༌ ཏེ༌ ནང༌ང༌ སུབ༌བ༌ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ཨབ༌ར༌ཧམ༌མི༌ ཨེ༌ཕོ༌རོན༌ ཉམ༌པོ༌ ཁའ༌ཆམས༌ཏེ༌ མི༌ཚང༌མའེ༌ དུན༌ལ༌ ཁོའེ༌ ཟེར༌ཁན༌ནི༌ མུལ༌ 400 སྐར༌ཏེ༌ ཏངས༌, ཀ༌བོ༌ ཏེན༌ན༌ ཏུས༌སི༌ ཚོང༌པའེ༌ ཀོལ༌ཁན༌ནི༌ ཚད༌པོ༌ ནང༌ཞིན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ཏེན༌ན༌ ཟུག༌གི༌ མམ༌རེའེ༌ ཉེ༌མོའ༌ མེཁ༌ཕི༌ལའི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཨེ༌ཕོ༌རོན༌ནི༌ བྲག༌ཕུག༌, ཞིང༌ དང༌ ཏེ༌ ནང༌ཀུག༌ དང༌ ཐའ༌མ༌ ཡོད༌ཁན༌ནི༌ ལྕང༌མ༌ ཚང༌མ༌ ཨབ༌ར༌ཧམ༌མི༌ ཉོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ཡང༌ གྱལ༌སའེ༌ སྒོའེ༌ཀ༌ ཛོམས༌ཏེ༌ ཡོད༌ཁན༌ ཧེད༌པ༌ ཚང༌མའེ༌ དུན༌ལ༌ ཨབ༌ར༌ཧམ༌ ཏེ༌ ནོར༌གུན༌ནི༌ དག༌པོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ཏེ༌སྟིང༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ ཁོ༌རང༌ངི༌ ན༌མ༌ སཱ༌ར༌ མམ༌རེའེ༌ ཉེ༌མོའ༌ མེཁ༌ཕི༌ལའི༌ ཞིང༌ངི༌ བྲག༌ཕུགས༌པོའེ༌ ནང༌ང༌ སུབས༌, ཀ༌བོ༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ཏེན༌ན༌ ཟུག༌གི༌ ཧེད༌པ༌གུན༌ནི༌ ཞིང༌ དང༌ བྲག༌ཕུག༌ ཨབ༌ར༌ཧམ༌མི༌ ནོར༌ གྱུར༌, ཀ༌བོ༌ སྤུར༌ སུབ༌སའེ༌ ས༌ཀྱད༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ཏ༌ ཨབ༌ར༌ཧམ༌མའ༌ ལོ༌ མང༌པོ༌ སོང༌ཏེ༌ རྒད༌པོ༌ གྱུར༌ཏེ༌ ཡོད༌པིན༌, ཡང༌ ཡ༌ཝའེ༌ ཁོའ༌ ཅི༌ས༌ཐོག༌ནེ༌ ཅིན༌ལབས༌ སལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ཞག༌ཤིག༌ ཨབ༌ར༌ཧམ༌མི༌ ཁོ༌རང༌ངི༌ ཡོག༌པོ༌ ཆེ༌ཤོག༌, ཁོའ༌ ཡོད༌ཁན༌ ཚང༌མའེ༌ ཁག༌ཁུར༌པ༌བོའ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ལག༌པ༌ ངའེ༌ ཇང༌བར༌ལ༌ བོར༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ནམ༌ཁའ༌ དང༌ ཇིག༌རྟེན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ མིང༌ངི༌ ནང༌ང༌, ང༌དང༌ དུག༌སའེ༌ ཀེ༌ནན༌པའེ༌ བུ༌མོ༌ ཉམ༌པོ༌ ངའེ༌ བུ༌ཚའ༌ ན༌མའ༌ ཅོ༌ མི༌ཅུག༌ཅེས༌ལ༌ ནའ༌ ཁུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ང༌ སྐྱེས༌ཁན༌ནི༌ ཡུལ༌ལ༌ སོང༌ཏེ༌ ངའེ༌ བུ༌ཚ༌ ཨི༌སཱག༌གི༌ ཕིའ༌ ན༌མའ༌ ང༌རང༌ངི༌ ཉེན༌གྲུང༌གུན༌ནི༌ ནང༌ནེ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ཨིན༌ནའང༌ ཡོག༌པོའེ༌ ཏྲིས༌, “ཀལ༌ཏེས༌ བུ༌མོ༌བོ༌ ཁང༌པ༌ ཕངས༌ཏེ༌ ང༌ ཉམ༌པོ༌ འི༌ ཡུལ༌ལ༌ ཡོང༌ང༌ མ༌ཐད༌ན༌ ཏེ༌ནེ༌ ངའེ༌ ཉེ༌རང༌ངི༌ བུ༌ཚ༌ ཉེ༌རང༌ སྐྱེས༌སའེ༌ ཡུལ༌ལ༌ ལོགས༌ཏེ༌ ཁྱེར༌ར༌ལེ༌?” ");
INSERT INTO lbj_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ཨབ༌ར༌ཧམ༌མི༌ ལན༌ཏངས༌, “མན༌! ཏན༌ཏན༌, ཁྱོ༌རང༌ངི༌ ངའེ༌ བུ༌ཚ༌ ཏེ༌རུ༌ ལོགས༌ཏེ༌ ཁྱེར༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ངའེ༌ ཨ༌བའེ༌ ཁང༌པ༌ དང༌ ངའ༌ སྐྱེས༌སའེ༌ ཡུལ༌ནེ༌ ང༌ ཕིང༌ཏེ༌ ཁོངས༌ཁན༌ ནམ༌ཁའ༌ ཞུགས༌ཁན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ འི༌ ས༌ཆ༌བོ༌ ངའེ༌ པུར༌གྱུད༌གུན༌ལ༌ སལ༌ཨིན༌ མོལ༌ཏེ༌ ཞལ༌ཆད༌ ཅོའ༌ ཛད༌ཏེ༌ ཨིན༌། ཁོང༌ངི༌ ཁོང༌རང༌ངི༌ ཕོ༌ཉ༌ ཁྱོ༌རང༌ངི༌ སང༌ སྔུན༌ལ༌ ཀལ༌ལ༌ ཛད༌ཏེ༌ ཁྱོ༌རང༌ང༌ ངའེ༌ བུ༌ཚའེ༌ ཕིའ༌ ན༌མ༌ ཐོབ༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ཀལ༌ཏེས༌ བུ༌མོ༌བོ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོང༌ང༌ མ༌ཐད༌ན༌, ཁྱོ༌རང༌ ཁྱོ༌རང༌ངི༌ ཁུར༌ཁན༌ནི༌ ནའ༌ནེ༌ ཐར༌ཏེ༌ ཨིན༌, ཨིན༌ནའང༌ ངའེ༌ བུ༌ཚ༌ ཏེ༌རུ༌ ལོགས༌ཏེ༌ ཁྱེར༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ཏེ༌ནེ༌ ཡོག༌པོའེ༌ ཁོ༌རང༌ངི༌ ལག༌པ༌བོ༌ ཁོའེ༌ སྤོན༌བོ༌ ཨབ༌ར༌ཧམ༌མི༌ ཇང༌བར༌ལ༌ བོར༌ཏེ༌ ཁོང༌ངི༌ ཅོས༌ ཟེར༌ཁན༌བོ༌ ཅོ༌ཅེས༌ལ༌ ནའ༌ ཁུརས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོའེ༌ ཁོ༌རང༌ངི༌ སྤོན༌བོའེ༌ རྔ༌བོང༌ རྕུ༌ ཁྲིདས༌ ཡང༌ སྤོན༌བོའེ༌ ཆོགས༌ནེ༌ རིན༌ཅན༌ནི༌ སྟགས༌གུན༌ ཁུར༌ཏེ༌ ན༌ཧོར༌ དུག༌སའེ༌ གྲོང༌ཁྱེར༌ ཨ༌རམ༌ ན༌ཧ༌རཱ༌འིམ༌མི༌ ཡུལ༌ཇོངས༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ཏེ༌རུ༌ ལེབས༌ཏེ༌ ཁོའེ༌ རྔ༌བོང༌གུན༌ གྲོང༌ཁྱེར༌རི༌ ཕི༌ལོག༌ག༌ ཡོད༌ཁན༌ནི༌ ཆུ༌དོང༌ངི༌ དུན༌ལ༌ དུག༌ཅུགས༌, ཏེ༌བོ༌ ཛ༌རེ༌སྟིང༌ནེ༌ ཨིན༌པིན༌ ནམ༌ བུ༌མོ༌གུན༌ ཆུ༌ ལེན༌ན༌ལ༌ ཕི༌ལོག༌ག༌ ཡོང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ཁོའེ༌ མོས༌ལམ༌ ཞུས༌, “ངའེ༌ སྤོན༌བོ༌ ཨབ༌ར༌ཧམ༌མི༌ དཀོན༌མཆོག༌ ཞུགས༌ཁན༌ནི༌ ཀྱེ༌ ཡ༌ཝ༌ལེ༌, དི༌རིང༌ ངའ༌ ཐར༌ཁྱེལ༌ སལ༌ཏེ༌ ངའེ༌ སྤོན༌བོ༌ ཉམ༌པོ༌ ཐུག༌རྗེ༌ སྟན༌ན༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","གྲོང༌ཁྱེར༌རི༌ ཞུ༌ནུ༌མ༌གུན༌ ཆུ༌ ལེན༌ན༌ལ༌ ཡོང༌སེ༌ ཆུ༌དོང༌ངི༌ དུན༌ལ༌ ངའ༌ དུགས༌ཏེ༌ ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ངའེ༌ ཁོང༌ ཅིག༌ག༌ ཟེར༌ཨིན༌, ‘ཇུ༌ཇུ༌ ཆུ༌ ནོད༌པོ༌ ཕབས༌ཏེ༌ ང༌ ཆུ༌ ཐུང༌ཅེས༌ཤིག༌ སལ༌’, ཀལ༌ཏེས༌ ཁོའེ༌ དོན༌ལེ༌ ཡང༌ ངའེ༌ ཉེ༌རང༌ངི༌ རྔ༌བོང༌གུན༌ནི༌ ཕིའང༌ ཆུ༌ ཁྱོང༌ཉིན༌ ཟེར༌ན༌, ཏེ༌ནེ༌ ཁོ༌ ཉེ༌རང༌ངི༌ ཡོག༌པོ༌ ཨི༌སཱག༌གི༌ ཕིའ༌ ཉེ༌རང༌ངི༌ ལྡམ༌ཁན༌ནི༌ བུ༌མོ༌བོ༌ ཨིན༌ ཅུག༌ག༌ ཛད༌། འི༌བོ༌ ཇུང༌ན༌ ཉེ༌རང༌ངི༌ ངའེ༌ སྤོན༌བོའ༌ ཐུག༌རྗེ༌ ཛད༌ཁན༌བོ༌ ང༌ ཧ༌གོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ཁོའེ༌ མོས༌ལམ༌ ཞུ༌ མ༌ཚར༌ར༌, ཆུ༌ ནོད༌ སྤུང༌པའེ༌ཀ༌ ཁུར༌ཏེ༌ ར༌བེ༌ཀ༌ ལེབ༌། ཁོ༌ ནི༌ བེ༌ཐུལ༌ལི༌ བུ༌མོ༌, བེ༌ཐུལ༌ ནི༌ མིལ༌ཀའེ༌ བུ༌ཚ༌ ཨིན༌པིན༌ ཡང༌ མིལ༌ཀ༌ ནི༌ ཨབ༌ར༌ཧམ༌མི༌ ནོ༌ ན༌ཧོར༌རི༌ ན༌མ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","བུ༌མོ༌བོ༌ ན༌ཆུང༌ མ༌ ལྡེ༌མོ༌, བུ༌ཚའ༌ ཉམ༌པོ༌ བྲེལ༌ མ༌ཆའ༌ཁན༌ཞིག༌ ཡོད༌པིན༌། ཁོ༌ ཐུར༌ལ༌ ཆུ༌དོང༌ངི༌ཀ༌ སོང༌ཏེ༌ ཁོ༌རང༌ངི༌ ཆུ༌ ནོད༌པོ༌ སྐངས༌ ཡང༌ ལོགས༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ཡོག༌པོ༌ བང༌ཏངས༌ཏེ༌ བུ༌མོ༌བོའ༌ ཐུག༌ག༌ སོང༌ཏེ༌ ཟེརས༌, “ཇུ༌ཇུ༌ ཉེ༌རང༌ངི༌ ཆུ༌ ནོད༌དི༌ ནང༌ནེ༌ ངའ༌ ཆུ༌ ཐུང༌ཅེས༌ཤིག༌ སལ༌ལའང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ཁོའེ༌ ཟེརས༌, “དོན༌ནའང༌ ཀ༌ག༌ལེ༌!” ཡང༌ གྱོགས༌པ༌ ཁོ༌རང༌ངི༌ ཆུ༌ ནོད༌པོ༌ སྤུང༌པའེ༌ ཀ༌ནེ༌ ཕབས༌ཏེ༌ ཁོའ༌ ཆུ༌ ཐུང༌ཅེས༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ཁོའ༌ ཆུ༌ ཏང༌ ཚར༌ར༌ཅིག༌ བུ༌མོའེ༌ ཟེརས༌, “ངའེ༌ ཉེ༌རང༌ངི༌ རྔ༌བོང༌གུན༌ནི༌ ཕིའང༌ ཆུ༌ ཁྱོང༌ཨིན༌ ཏེ༌གུན༌ སྔོམས༌ སྔོམས༌ ཚག༌པ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ཁོའེ༌ གྱོགས༌པ༌ ཆུ༌ ནོད༌དི༌ ཆུ༌བོ༌ སེམས༌ཅན༌གུན༌ ཆུ༌ ཐུང༌སའེ༌ ནོད༌དི༌ ནང༌ང༌ ལུགས༌ ཡང༌ ཆུ༌ ཁྱོང༌ཅེས༌ལ༌ ཆུ༌དོང༌ ཆོགས༌ལ༌ བང༌ཏངས༌ཏེ༌ སོང༌། བུ༌མོའེ༌ རྔ༌བོང༌ ཚང༌མའེ༌ ཕིའ༌ ཆུ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ཡ༌ཝའེ༌ ཁོའེ༌ བེས༌པོ༌ ཐར༌ཁྱེལ༌ ཛད༌ཏེ༌ ཨིན༌ན༌ མན༌ ལྟའ༌ཅེས༌ལ༌ མི༌བོ༌ ཅུབ༌ཅད༌ཏེ༌ བུ༌མོ༌བོའ༌ ལྟེན༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","རྔ༌བོང༌གུན༌ནི༌ ཆུ༌ ཐུང༌ ཚར༌ར༌ཅིག༌, མི༌བོའེ༌ ན༌ཁུང༌ང༌ ཏག༌ཅེས༌སི༌ སེར༌རི༌ ཀྱི༌ལྡིར༌ ཆེན༌མོ༌ དང༌ སེར༌རི༌ ལྡུ༌གུ༌ ལྕིན༌ཏྲེ༌ ཉིས༌ ཕིངས༌ཏེ༌ བུ༌མོའེ༌ ལག༌པའ༌ སྐརས༌, ");
INSERT INTO lbj_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ཡང༌ ཁོའ༌ ཏྲིས༌, “ཤོད༌དའང༌ ཁྱོ༌རང༌ སུའི༌ བུ༌མོ༌ ཨིན༌? ང༌ཞའ༌ དི༌རིང༌ངི༌ ཚན༌བོ༌ དུག༌ཅེས༌སི༌ ཕིའ༌ ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པའེ༌ ནང༌ང༌ ནས༌ས༌ ཡོད༌ད༌?” ");
INSERT INTO lbj_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","བུ༌མོའེ༌ ཁོའ༌ ལན༌ཏངས༌, “ངའེ༌ ཨ༌བ༌ ནི༌ ན༌ཧོར༌ དང༌ མིལ༌ཀའེ༌ བུ༌ཚ༌, བེ༌ཐུལ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ང༌ཞའེ༌ ཁང༌པ༌ ཕུག༌མ༌ དང༌ ཙ༌ མང༌པོ༌ ཡང༌ ཉེ༌ཞའ༌ དུག༌ཅེས༌སི༌ ཕིའ༌ ནས༌སའང༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ཏེ༌ནེ༌ ཡོག༌པོའེ༌ པིག༌དོང༌ ཙུགས༌ཏེ༌ ཡ༌ཝའ༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ཁོའེ༌ ཟེརས༌, “ངའེ༌ སྤོན༌བོ༌ ཨབ༌ར༌ཧམ༌མི༌ དཀོན༌མཆོག༌ ཞུགས༌ཁན༌ ཡ༌ཝའ༌ སྟོད༌པ༌, ཁོང༌ངི༌ ངའེ༌ སྤོན༌བོའེ༌ ཉམ༌པོ༌ ཁོང༌རང༌ངི༌ ཐུག༌རྗེ༌ དང༌ ཁ༌ཆད༌ སྟན༌པོ༌ བོར༌ར༌ ཛདས༌། ཡ༌ཝའེ༌ ང༌ བེས༌སི༌ ནང༌ང༌ ང༌རང༌ངི༌ སྤོན༌བོའེ༌ ཉེན༌གྲུང༌གུན༌ ཡོད༌ས༌ ཁྱོང༌ང༌ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","བུ༌མོ༌བོ༌ ཁོ༌རང༌ངི༌ ཨ༌མའེ༌ ཁང༌པ༌ བང༌ཏངས༌ཏེ༌ སོང༌ ཡང༌ ཅི༌ཚང༌མ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ཏ༌ ར༌བེ༌ཀ༌ ལ༌བན༌ ཟེར༌ཁན༌ནི༌ ཨ༌ཅོ༌ཞིག༌ ཡོད༌པིན༌, ཡང༌ ལ༌བན༌ བང༌ཏངས༌ཏེ༌ ཕི༌ལོག༌ག༌ ཆུ༌དོང༌ངི༌ཀ༌ ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོ༌ ཡོད༌ས༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ལ༌བན༌ལ༌ ན༌ཁུང༌ངི༌ཀ༌ ཏག༌ཅེས༌སི༌ ཀྱི༌ལྡིར༌ དང༌ ཁོའེ༌ སྲིང༌མོའེ༌ ལག༌པའ༌ ཏགས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ལྡུ༌གུ༌ གུན༌ ཐོང༌ ཡང༌ མི༌བོའེ༌ ཟེར༌ཁན༌ ར༌བེ༌ཀའེ༌ ཤད༌ཁན༌གུན༌ ཚོར༌ར༌ཅིག༌, ཁོ༌ མི༌བོ༌ ཡོད༌ས༌ སོང༌ ཡང༌ རྔ༌བོང༌གུན༌ ཡོད༌ས༌ ཆུ༌དོང༌ངི༌ དུན༌ལ༌ ཁོ༌ ལངས༌ཏེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ཁོའེ༌ ཟེརས༌, “སྐྱོད༌ལེ༌, ཉེ༌རང༌, ཡ༌ཝའེ༌ ཅིན༌ལབས༌ ཐོབ༌ཁན༌ནི༌ མི༌ཞིག༌ ཨིན༌ནོག༌། ཉེ༌རང༌ ཏེ༌ཀ༌ ཅིའ༌ ཞུགས༌སད༌ ནམ༌ ངའེ༌ ཉེ༌རང༌ངི༌ ཕིའ༌ ང༌ཞའེ༌ ཁང༌པ༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ ཡོད༌ ཡང༌ རྔ༌བོང༌གུན༌ བོར༌སའང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ཏེ༌ནེ༌ ཁོ༌ ལ༌བན༌ནི༌ ཁང༌པའ༌ སོང༌ ཡང༌ རྔ༌བོང༌གུན༌ནི༌ ཀ༌ནེ༌ ཁུ༌རུ༌གུན༌ ཕབ༌ ཅུགས༌ཏེ༌ ཏེ༌གུན༌ལ༌ རྩོའ༌ ཏངས༌། ལ༌བན༌ནི༌ ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོ༌ དང༌ ཁོའེ༌ མི༌གུན༌ནི༌ རྐང༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཕིའ༌ ཆུ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ཡང༌ མི༌བོའེ༌ དུན༌ལ༌ ཁར༌ཇི༌ ཟའ༌ཅེས༌ལ༌ ཁྱོང༌ང༌ཅིག༌ ཁོའེ༌ ཟེརས༌, “ངའེ༌ ཟེར༌གོ༌ཤེས༌པོ༌ ཟེར༌ཏེ༌ མ༌ནེ༌ ངའེ༌ འི༌ ཁར༌ཇི༌བོ༌ མི༌ཟ༌།” ཏེ༌ནེ༌ ལ༌བན༌ནི༌ ཟེརས༌, “ང༌ཞའ༌ མོལ༌ལའང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ཁོའེ༌ ཤད༌ཅེས༌ གོ༌ཟུག༌, “ང༌ ནི༌ ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོ༌ཞིག༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ཡ༌ཝའེ༌ ངའེ༌ སྤོན༌བོའ༌ ཅིན༌ལབས༌ མང༌པོ༌ སལ༌ཏེ༌ ཁོང༌ ཆུག༌པོ༌ གྱུར༌ཅུག༌ག༌ ཛདས༌། ཁོང༌ང༌ ལུག༌ དང༌ བ༌ལང༌, མུལ༌ དང༌ སེར༌, བུ༌མོ༌ དང༌ བུ༌ཚའེ༌ ཚེ༌ཡོག༌ དང༌ རྔ༌བོང༌ དང༌ བུང༌བུ༌ གུན༌ནི༌ ཁྱུ༌ མང༌པོ༌ ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ངའེ༌ སྤོན༌བོའེ༌ ན༌མ༌ སཱ༌རའ༌ རྒད༌མོ༌ ཡོད༌ ཟ༌ནེ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ ཡང༌ ངའེ༌ སྤོན༌བོའེ༌ ཁོང༌རང༌ངི༌ ཨིན༌ཁན༌ ཅི༌ཚང༌མ༌ ཁོའ༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ངའེ༌ སྤོན༌བོའེ༌ ངའ༌ ནའ༌ ཁུར༌ཅུགས༌ཏེ༌ མོལས༌, ‘ངའེ༌ བུ༌ཚའ༌ ང༌ དུག༌སའེ༌ ཀེ༌ནན༌ནི༌ ཡུལ༌ནེ༌ ན༌མ༌ མ༌ཁྱོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ཨིན༌ནའང༌ ངའེ༌ ཨ༌བའེ༌ ནང༌ཚངས༌ དང༌ ཉེན༌གྲུང༌གུན༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁོའེ༌ ཕིའ༌ ན༌མ༌ ཁྱོང༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“ཏེ༌ནེ༌ ངའེ༌ སྤོན༌བོའ༌ ཏྲིས༌པིན༌, ‘ཀལ༌ཏེས༌ བུ༌མོ༌བོ༌ ང༌ ཉམ༌པོ༌ ཡོང༌ཅེས༌ལ༌ མ༌ཐད༌ན༌?’” ");
INSERT INTO lbj_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“ཁོང༌ངི༌ ལན༌སལས༌, ‘ངའེ༌ ཏུས༌གྱུན༌ ཁའ༌ ཉན༌ཁན༌ནི༌ ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ ཕོ༌ཉ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཀལ༌ལ༌ ཛད༌ཏེ༌ ཁྱོ༌རང༌ངི༌ བེས༌པོ༌ ཐར༌ཁྱེལ༌ ཛད༌ཨིན༌། ཁྱོ༌རང༌ང༌ ངའེ༌ བུ༌ཚའེ༌ ཕིའ༌ ན༌མ༌ ངའེ༌ ཨ༌བའེ༌ ནང༌ཚངས༌, ང༌རང༌ངི༌ ཉེན༌གྲུང༌གུན༌ནི༌ ནང༌ནེ༌ ཐོབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ཏེ༌ནེ༌ ཁྱོ༌རང༌ ཁྱོ༌རང༌ངི༌ ནའ༌ ཁུར༌ཁན༌ནེ༌ ཐར༌ཏེ༌ ཨིན༌ནོག༌། ཀལ༌ཏེས༌ ཁྱོ༌རང༌ ངའེ༌ ཉེན༌གྲུང༌གུན༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཁྱོ༌རང༌ང༌ བུ༌མོ༌བོ༌ མ༌ཏང༌ན༌ ཁྱོ༌རང༌ངི༌ ནའ༌ ཁུར༌ཁན༌ནེ༌ ཁྱོ༌རང༌ ཐར༌ཏེ༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“དི༌རིང༌ ང༌ ཆུ༌དོང༌ ཡོད༌ས༌ ལེབ༌བ༌ཅིག༌, ངའེ༌ ང༌རང༌ངི༌ སྤོན༌བོའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌པིན༌, ‘ཀལ༌ཏེས༌ ཉེ༌རང༌ ཐུགས༌ཐད༌ན༌ ཇུ༌ཇུ༌ ངའེ༌ བེས༌པོ༌ ཐར༌ཁྱེལ༌ ལུས༌ཤུག༌ག༌ ཛད༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ང༌ ཆུ༌དོང༌ངི༌ དུན༌ལ༌ ཡོད༌ ཟ༌ནེ༌ བུ༌མོ༌ ཆུ༌ ལེན༌ན༌ལ༌ ཡོང༌ཁན༌བོའ༌ ངའེ༌ ཟེར༌ཨིན༌, ‘ཇུ༌ཇུ༌ ཉེ༌རང༌ངི༌ ཆུ༌ནོད༌ནེ༌ ངའ༌ ཐུང༌ཅེས༌ལ༌ ཆུ༌ ཉུ༌ངུན༌ཞིག༌ སལ༌ལའང༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ཀལ༌ཏེས༌ ཁོའེ༌ ‘དོན༌ལེ༌, ཡང༌ ངའེ༌ ཉེ༌རང༌ངི༌ རྔ༌བོང༌གུན༌ནི༌ ཕིའང༌ ཆུ༌ ཁྱོང༌ཨིན༌’ ཟེར༌ན༌, ཏེ༌ བུ༌མོ༌བོ༌ ཉེ༌རང༌ངི༌ ངའེ༌ སྤོན༌བོའེ༌ བུ༌ཚའེ༌ ཕིའ༌ ལྡམ༌མ༌ ཛད༌ཁན༌བོ༌ ཨིན༌ ཅུག༌ག༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“མོས༌ལམ༌ ཞུ༌ཚར༌རི༌ སང༌ སྔུན༌ལ༌ ར༌བེ༌ཀ༌ ཁོ༌རང༌ངི༌ ཆུ༌ནོད༌པོ༌ སྤུང༌པའེ༌ཀ༌ ཁུར༌ཏེ༌ ཡོངས༌ ཡང༌ ཐུར༌ལ༌ ཆུ༌དོང༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཆུ༌ ཕིངས༌། ངའེ༌ ཁོའ༌ ཟེར༌པིན༌, ‘ཇུ༌ཇུ༌ ངའ༌ ཆུ༌ ཐུང༌ཅེས༌ཤིག༌ སལ༌ལའང༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“ཁོའེ༌ ཏེན༌ན༌མལ༌ལ༌ ཁོ༌རང༌ངི༌ ཆུ༌ནོད༌པོ༌ སྤུང༌པའེ༌ ཀ༌ནེ༌ ཕབས༌ཏེ༌ ‘དོན༌ལེ༌ ཡང༌ ངའེ༌ ཉེ༌རང༌ངི༌ རྔ༌བོང༌ངི༌ ཕིའང༌ ཆུ༌ ཁྱོང༌ཨིན༌’ ཟེར༌ར༌རག༌། ཏེ༌ནེ༌ ངའེ༌ ཐུངས༌པིན༌, ཡང༌ ཁོའེ༌ རྔ༌བོང༌གུན༌ལ༌ ཆུ༌ ཏངས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“ངའེ༌ ཏྲིས༌པིན༌, ‘ཁྱོ༌རང༌ སུའི༌ བུ༌མོ༌ ཨིན༌?’ ཁོའེ༌ ལན༌ཏངས༌, ‘ང༌ ནི༌ ན༌ཧོར༌ དང༌ མིལ༌ཀའེ༌ བུ༌ཚ༌ བེ༌ཐུལ༌ལི༌ བུ༌མོ༌ ཨིན༌།’ ངའེ༌ ཁོའ༌ ན༌ཁུང༌ངི༌ཀ༌ སྟག༌ཅེས༌ ཀྱི༌ལྡིར༌ དང༌ ལག༌པའ༌ ལྡུ༌གུ༌གུན༌ ཏགས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ཏེ༌ནེ༌ ངའེ༌ པིག༌དོང༌ ཙུགས༌ཏེ༌ ཡ༌ཝའ༌ ཅོལ༌པིན༌, ངའེ༌ ང༌རང༌ངི༌ སྤོན༌བོ༌ ཨབ༌ར༌ཧམ༌མི༌ དཀོན༌མཆོག༌ ཡ༌ཝ༌ སྟོད༌པ༌ ཕུལ༌པིན༌། ཁོང༌ངི༌ ང༌ ངའེ༌ སྤོན༌བོའེ༌ ཉེན༌གྲུང༌གུན༌ནི༌ ཕྲོའ༌ ཁ༌དྲང༌ང༌ ཁྱོང༌ང༌ ཛད༌ཏེ༌ ཁོང༌ངི༌ བུ༌ཚའེ༌ ན༌མའེ༌ ཕིའ༌ ཁོང༌ངི༌ ནོའེ༌ ཚ༌མོ༌ ལྡམ༌མ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ཏ༌ ང༌ ཤོད༌དའང༌ ཁྱོ༌ཞའེ༌ ངའེ༌ སྤོན༌བོའ༌ ཐུག༌རྗེ༌ དང༌ ཨིད༌ཤེས༌ཅན༌ ཨིན༌ཁན༌ སྟན༌ཨིན༌ན༌ ཡ༌ མི༌སྟན, ཀལ༌ཏེས༌ མ༌སྟན༌ན༌ ཏེན༌ནེ༌ འི༌ སྟིང༌ནེ༌ ཅོ༌གོ༌ཤེས༌པོ༌ ངའ༌ ཧ༌གོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ལ༌བན༌ དང༌ བེ༌ཐུལ༌ལི༌ ལན༌ཏངས༌, “འི༌གུན༌ ཡ༌ཝའེ༌ ཆོགས༌ནེ༌ ཨིན༌ པ༌སང༌, ང༌ཞའ༌ ཐག༌ཅད༌ ཏང༌ཅེས༌སི༌ ཝང༌ཆ༌ མེད༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ར༌བེ༌ཀ༌ ཉེ༌རང༌ངི༌ དུན༌ནེ༌, ཉེ༌རང༌ངི༌ སྤོན༌བོའེ༌ བུ༌ཚའ༌ ན༌མ༌ ཅོ༌ཅེས༌ལ༌ ཁོ༌ ཉེ༌རང༌ ཉམ༌པོ༌ ཁྱེར༌ར༌ཛད༌, ཀ༌ཟུག༌ ཡ༌ཝ༌ ཐག༌ཅདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌, ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོའེ༌ པིག༌དོང༌ ཙུགས༌ཏེ༌ ཡ༌ཝའ༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ཏེ༌ནེ༌ ཁོའེ༌ མུལ༌ དང༌ སེར༌རི༌ གྱན༌ཆ༌ དང༌ ཀོས༌ལག༌ གུན༌ ཁྱོངས༌ཏེ༌ ར༌བེ༌ཀ༌ ཏངས༌། བུ༌མོའེ༌ ཨ༌ཅོ༌ དང༌ ཨ༌མའ༌ ཁོའེ༌ སྟགས༌ རིན༌ཅན༌གུན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ཏེ༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོ༌ དང༌ ཁོ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ནི༌ མི༌གུན༌ནི༌ ཟན༌ ཟོས༌ ཡང༌ ཐུངས༌ ཡང༌ ཚན༌ལ༌ ཏེ༌རུ༌ དུགས༌། ཐོ༌རེ༌ཟུག༌པོ༌ ང༌ཏོག༌ ཁོང༌གུན༌ ལངས༌ཏེ༌ ཁོའེ༌ ཟེརས༌, “ང༌ ང༌རང༌ངི༌ སྤོན༌བོ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ཆ༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ཨིན༌ནའང༌ ར༌བེ༌ཀའེ༌ ཨ༌ཅོ༌ དང༌ ཨ༌མའེ༌ ཟེརས༌, “ཁོ༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཞག༌མ༌ རྕུ༌ དུག༌ཅུག༌ག༌ཛད༌, ཏེ༌སྟིང༌ནེ༌ ཁོ༌ ཆ༌ནའང༌ གྲིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ཨིན༌ནའང༌ ཁོའེ༌ ཟེརས༌, “ཡ༌ཝའེ༌ ངའེ༌ བེས༌པོ༌ ཁྲངས༌པོ༌ ཅོའ༌ ཛདས༌པ༌ ངའ༌ གོར༌ མ༌ཅུག༌ག༌ ངའེ༌ སྤོན༌བོ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ཆ༌ཅུག༌ག༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “བུ༌མོའ༌ བོད༌ཏེ༌ ཁོའེ༌ ཅི༌ ཟེར༌དུག༌ ལྟེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ར༌བེ༌ཀ༌ བོད༌ཏེ༌ ཏྲིས༌, “ཁྱོ༌རང༌ འི༌ མི༌བོ༌ ཉམ༌པོ༌ ཆའ༌ ཐད༌ད༌རག༌ག༌?” ཁོའེ༌ ལན༌ཏངས༌, “ང༌ ཆ༌ ཐད༌ད༌རག༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ར༌བེ༌ཀ༌ དང༌ ཁོའ༌ སྟ༌སྟོག༌ ཅོ༌ཁན༌ནི༌ ཡོག༌པོ༌ གུན༌ ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོ༌ དང༌ ཁོའེ༌ མི༌གུན༌ ཉམ༌པོ༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ཁོང༌གུན༌ནི༌ ར༌བེ༌ཀ༌ ཅིན༌ལབས༌ ཏངས༌ཏེ༌ ཟེརས༌, “ང༌ཞའེ༌ སྲིང༌མོ༌ ཁྱོ༌རང༌ སྟོང༌ཁྲག༌ མ༌ མང༌པོའེ༌ ཨ༌མ༌ གྱུར༌ཤིག༌། ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ནི༌ ཁོང༌རང༌ངི༌ གྲ༌འོའེ༌ གྱལ༌ས༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ཏེ༌ནེ༌ ར༌བེ༌ཀ༌ དང༌ ཁོའེ༌ ཡ༌ཏོ༌ བུ༌མོ༌གུན༌ རྔ༌བོང༌ངི༌ཀ༌ ཞོན༌ཏེ༌ ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོ༌ དང༌ ཁོའེ༌ མི༌གུན༌ ཉམ༌པོ༌ སོང༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ ར༌བེ༌ཀ༌ ཁྲིད༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ཏ༌ ཨི༌སཱག༌ ནེ༌གེཝ༌ ཡུལ༌ཇོངས༌སི༌ བེར༌ལ༌ཧཱའི༌རོའི༌ ཟེར༌སའེ༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ཁོ༌ ཕི༌ཏོག༌ ཞིང༌ངི༌ཀ༌ གྲུལ༌ལ༌ལ༌ སོང༌ ཡང༌ ཀེན༌ལ༌ ལྟས༌པ༌ རྔ༌བོང༌གུན༌ ཡོང༌ང༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ར༌བེ༌ཀའེ༌ ཀེན༌ལ༌ ལྟས༌པ༌ ཨི༌སཱག༌ ཐོང༌ ཡང༌ ཁོ༌ རྔ༌བོང༌ངི༌ ཀ༌ནེ༌ བབས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ཨབ༌ར༌ཧམ༌མི༌ ཡོག༌པོའ༌ ཏྲིས༌, “ཞིང༌ངི༌ ཀ༌ནེ༌ གྲུལ༌ཨིན༌ ང༌དང༌ ཆོགས༌ལ༌ ཡོང༌ཁན༌ནི༌ མི༌བོ༌ སུ༌ ཨིན༌ནོག༌?” ཁོའེ༌ ལན༌ཏངས༌, “ཁོང༌, ངའེ༌ སྤོན༌བོ༌ ཨིན༌ནོག༌།” ཏེ༌ནེ༌ བུ༌མོའེ༌ ལྡོང༌ སྐབ༌ཅེས༌པོ༌ ལེན༌ཏེ༌ ཁོ༌རང༌ངི༌ ལྡོང༌བོ༌ སྐབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ཡོག༌པོའེ༌ ཨི༌སཱག༌ག༌ ཁོའེ༌ ཅོ༌ཁན༌ ཚང༌མ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ཏེ༌ནེ༌ ཨི༌སཱག༌གི༌ ར༌བེ༌ཀ༌ ཁོ༌རང༌ངི༌ ཨ༌མའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཁྱེརས༌ ཡང༌ ཁོ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌། ཨི༌སཱག༌གི༌ ར༌བེ༌ཀ༌ ཡ༌ཤ༌ ཅོའད༌པིན༌ ཡང༌ ཁོ༌རང༌ངི༌ ཨ༌མ༌ ཀྲོངས༌ཏེ༌ སྟིང༌ནེ༌ ཁོའ༌ སེམས༌སོ༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ཨབ༌ར༌ཧམ༌མི༌ ཀེ༌ཏུ༌ར༌ ཟེར༌ཁན༌ནི༌ ཡང༌ བུ༌མོ༌ཞིག༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ཏེ༌ བུ༌མོ༌བོ༌ གྱུད༌ཏེ༌ ཁོའ༌ བུ༌ཚ༌ དྲུག༌ ཇོར༌ ཁོང༌གུན༌ ནི༌ ཟིམ༌རན༌, ཡོག༌ཤན༌, མི༌དན༌, མི༌དིའན༌, འིཤ༌བག༌, དང༌ ཤུའ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ཡོག༌ཤན༌, ཤི༌བ༌ དང༌ དི༌དན༌ ནི༌ ཨ༌བ༌ ཨིན༌པིན༌ ཡང༌ ཨ༌ཤུ༌རམ༌པ༌, ལི༌ཏུ༌ཤམ༌པ༌ དང༌ ལིའུ༌མིམ༌པ༌ གུན༌, དི༌དན༌ ནི༌ པུར༌གྱུད༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","མི༌དིའན༌ ནི༌ བུ༌ཚ༌གུན༌ ཨི༌ཕ༌, ཨི༌ཕེར༌, ཧ༌ནོག༌, ཨ༌བི༌ད༌ དང༌ འེལ༌ལྡ༌ གུན༌ ཨིན༌པིན༌། ཁོང༌ ཚང༌མ༌ ཀི༌ཏུ༌རའ༌ གྱུད༌ཏེ༌ ཨབ༌ར༌ཧམ༌མི༌ པུར༌གྱུད༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ཨབ༌ར༌ཧམ༌མི༌ ཁོའ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཨི༌སཱག༌ག༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ཨིན༌ནའང༌ ཨབ༌ར༌ཧམ༌ མ༌ཤིའ༌ ཡོད༌ཏུས༌, ཁོའེ༌ ཚེ༌ཡོག༌ ན༌མ༌གུན༌ གྱུད༌ཏེ༌ སྐྱེ༌ཁན༌ནི༌ བུ༌ཚ༌གུན༌ལ༌ སྐྱེས༌ ཏངས༌ཏེ༌ ཤར༌ཆོགས༌ལ༌ ཡོད༌ཁན༌ནི༌ ནས༌སའ༌ ཨི༌སཱག༌ནེ༌ ཐག༌རིང༌ང༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","མི༌ཚེ༌ རིང༌མོ༌ གྱལ༌ལ༌ཞིག༌ ཕུད༌ཏེ༌ ལོ༌ 175 སོང༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ཨབ༌ར༌ཧམ༌ ཤི༌ ཡང༌ ཁོ༌རང༌ངི༌ ཕ༌མེས༌པོ༌གུན༌ ཉམ༌པོ༌ ཛོམས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ཁོའེ༌ བུ༌ཚ༌ ཨི༌སཱག༌ དང༌ ཨིཤ༌མ༌ཨེལ༌ལི༌ ཁོང༌ མེཁ༌ཕི༌ལའི༌ བྲག༌ཕུགས༌ ཀ༌བོ༌ ཧེད༌པ༌ ཟོ༌ཧར༌རི༌ བུ༌ཚ༌ ཨེ༌ཕོ༌རོན༌ནི༌ ཞིང༌ མམ༌རེའེ༌ ཤར༌ཆོགས༌ལ༌ ཡོད༌ཁན༌བོའེ༌ ནང༌ང༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","འི༌བོ༌ ཨབ༌ར༌ཧམ༌མི༌ ཧེད༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཉོས༌ཁན༌ནི༌ ཞིང༌བོ༌ ཨིན༌པིན༌། ཏེ༌ནང༌ང༌ ཨབ༌ར༌ཧམ༌ ཁོ༌རང༌ངི༌ ན༌མ༌ སཱ༌རའ༌ ཉམ༌པོ༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ཨབ༌ར༌ཧམ༌ ཀྲོངས༌ཏེ༌ སྟིང༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཁོའེ༌ བུ༌ཚའ༌ ཨི༌སཱག༌ག༌ ཅིན༌ལབས༌ སལས༌ ཡང༌ ཏེ༌ཏུས༌ ཁོ༌ བེར༌ལ༌ཧཱའི༌རོའི༌ ནང༌ང༌ དུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","འི༌བོ༌ ཨབ༌ར༌ཧམ༌མ༌ ཧཱ༌གར༌ ཨི༌ཇིབ༌མ༌ སཱ༌རའེ༌ ཚེ༌ཡོག༌ གྱུད༌ཏེ༌ ཇོར༌ཁན༌ ནི༌ ཨིཤ༌མ༌ཨེལ༌ལི༌ པུར༌གྱུད༌གུན༌ནི༌ ཐོ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","སྐྱེ༌ཚིར༌ལ༌ ཨིཤ༌མ༌ཨེལ༌ལི༌ བུ༌ཚ༌གུན༌ནི༌ མིང༌ ནི༌ ནི༌བེ༌འོད༌, ཀི༌དར༌, ཨད༌བིལ༌, མིབ༌སམ༌, ");
INSERT INTO lbj_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","མིཤ༌མ༌, དུ༌མཧ༌, མས༌ས༌, ");
INSERT INTO lbj_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ཧ༌དད༌, ཏི༌མ༌, ཡི༌ཏུར༌, ན༌ཕིཤ༌ དང༌ ཀི༌དི༌མཧ༌ གུན༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ཁོང༌གུན༌ ཨིཤ༌མ༌ཨེལ༌ལི༌ བུ༌ཚའེ༌ སྡེ༌, ཝང༌སྲུལ༌པ༌ རྕུག༌ཉིས༌སི༌ ཕ༌མེས༌པོ༌གུན༌ ཨིན༌པིན༌, ཁོང༌གུན༌ནི༌ མིང༌ ཁོང༌རང༌གུན༌ནི༌ གྲོང༌སེབ༌ དང༌ དུག༌སའེ༌ ས༌ཆ༌གུན༌ ནང༌ཞིན༌ ཐོགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ལོ༌ 137 སོན༌ཏེའ༌ ལུས༌ཏེ༌ སྟིང༌ནེ༌ ཨིཤ༌མ༌ཨེལ༌ ཤི༌ ཡང༌ ཁོ༌རང༌ངི༌ ཕ༌མེས༌པོ༌གུན༌ ཉམ༌པོ༌ ཛོམས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ཨིཤ༌མ༌ཨེལ༌ལི༌ པུར༌གྱུད༌གུན༌ ཧ༌ཝི༌ལ༌ནེ༌ ཤུར༌ ཚག༌པ༌, ཀ༌བོ༌ ཨི༌ཇིབ༌བི༌ ཤར༌ཆོགས༌, ཨ༌ཤུར༌ ཆོགས༌ལ༌ ཡོད༌པིན༌། ཁོང༌གུན༌ ཨབ༌ར༌ཧམ༌མི༌ ཞན༌ པུར༌གྱུད༌གུན༌ ཉམ༌པོ༌ ཐུན༌ན༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","འི༌བོ༌ ཨི༌སཱག༌གི༌ བུ༌ཚ༌གུན༌ནི༌ སྐོར༌, ཨི༌སཱག༌ ནི༌ ཨབ༌ར༌ཧམ༌མི༌ བུ༌ཚ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ཨི༌སཱག༌ག༌ ལོ༌ 40 ཆའད༌པིན༌ ནམ༌ ཁོའེ༌ ར༌བེ༌ཀ༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌། ར༌བེ༌ཀ༌ པ༌དམ༌ཨ༌རམ༌ནེ༌ ཨིན༌ཁན༌ ཨ༌རམ༌པ༌ བེ༌ཐུལ༌ལི༌ བུ༌མོ༌ དང༌ ལ༌བན༌ནི༌ སྲིང༌མོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ཨི༌སཱག༌གི༌ ར༌བེ༌ཀའེ༌ ཕིའ༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌ ཅིའ༌ཟེར༌ན༌ ཁོའ༌ ཕྲུ༌གུ༌ མེད༌པིན༌། ཡ༌ཝའེ༌ ཁོའེ༌ མོས༌ལམ༌མ༌ ལན༌སལ༌ཏེ༌ ར༌བེ༌ཀ༌ སྐྱེ༌ཅེས༌མ༌ཞིག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ཁོའེ༌ བུ༌སྣོད༌དི༌ ནང༌ང༌ ཙག༌ཕྲུག༌གུན༌ ནོལ༌ པ༌སང༌ ཁོའེ༌ ཟེརས༌, “འི༌ཟུག༌ ང༌ ཉམ༌པོ༌ ཅིའ༌ སོང༌ཏེ༌ ཨིན༌ནོག༌?” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ ཡ༌ཝའ༌ ཏྲིས༌, ");
INSERT INTO lbj_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “གྱལ༌ཁམས༌ ཉིས༌ ཁྱོ༌རང༌ངི༌ ནང༌ང༌ ཡོད༌, ཁྱོ༌རང༌ང༌ སྐྱེ༌ཁན༌ ཉིས༌ཀོ༌ མ༌ནེ༌ མི༌ཐུན༌། ཅིག༌པོ༌ ཞན༌བོའེ༌ སང༌ མང༌ང༌ ཤེད༌ཅན༌ ཡོང༌ཨིན༌, ཆེའ༌བོའེ༌ ཆུ༌ངུན༌བོའ༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ཕྲུ༌གུ༌གུན༌ སྐྱེ༌ཅེས༌སི༌ ཏུས༌པོ༌ ལེབ༌བ༌ཅིག༌ ཁོའ༌ བུ༌ཚ༌ ཙག༌ཕྲུག༌ སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","གོ༌མ༌ སྐྱེ༌ཁན༌བོ༌ མར༌པོ༌ཞིག༌ ཡང༌ ཁོའེ༌ ཟུགས༌པོ༌ སྤུ༌ཅན༌ནི༌ ཀོས༌ལག༌ ཙོགས༌ ཡོད༌པིན༌, ཏེན༌ན༌བོའེ༌ཕིའ༌ ཁོའེ༌ མིང༌ང༌ ཨི༌སུ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ཏེ༌སྟིང༌ནེ༌ ཁོའེ༌ ནོ༌ སྐྱེ༌ཁན༌བོའེ༌ ཨི༌སུའི༌ རྐང༌པའེ༌ སྟིང༌པའ༌ ཐམས༌ཏེ༌ ཡོད༌ པ༌སང༌ ཁོའེ༌ མིང༌ང༌ ཡ༌ཀོབ༌ ཏགས༌། ར༌བེ༌ཀའ༌ ཁོང༌གུན༌ སྐྱེ༌ ཟ༌ནེ༌ ཨི༌སཱག༌ག༌ ལོ༌ དྲུག༌ཅུ༌ ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","བུ༌ཚ༌གུན༌ ལྡན༌ ཡང༌ ཨི༌སུ༌ ལིངས༌པ༌ ཁས༌པ༌ཞིག༌ གྱུར༌ ཡང༌ ཁོ༌ ཕི༌ལོག༌ག༌ ཆའ༌ ཐད༌ཁན༌ ཨིན༌ནའང༌ ཡ༌ཀོབ༌ ཉམ༌ཤུང༌ ནང༌ང༌ དུག༌ག༌ ཐད༌ཁན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ཨི༌སཱག༌གི༌ ཨི༌སུའ༌ མང༌ང༌ ཡ༌ཤ༌ ཅོའད༌པིན༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ ཨི༌སུའི༌ སད༌ཁན༌ནི༌ སེམས༌ཅན༌གུན༌ནི༌ ཤ༌ ཟའ༌ཅེས༌ལ༌ ཐད༌དད༌པིན༌ ཨིན༌ནའང༌ ར༌བེ༌ཀའེ༌ ཡ༌ཀོབ༌བ༌ ཡ༌ཤ༌ མང༌ང༌ ཅོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ཞག༌ཅིག༌ ཡ༌ཀོབ༌བི༌ ཐུག༌པ༌ སྐོལ༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ ཨི༌སུ༌ ལིངས༌ནེ༌ ལོགས༌ཏེ༌ ཡོངས༌ ཡང༌ ཁོ༌ མ༌སྲན༌ཏྲེ༌ སྟོགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ཁོའེ༌ ཡ༌ཀོབ༌བ༌ ཟེརས༌, “ང༌ མ༌སྲན༌ཏྲེ༌ སྟོགས༌ས༌རག༌ ངའ༌ ཐུག༌པ༌ མར༌པོ༌ ཐུང༌ང༌ལ༌ ཏོང༌ངའང༌།” ༼ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ མིང༌ང༌ ཨི༌དོམ༌ ཐོགས༌ ཀ༌བོའེ༌ ཏོན༌ མར༌པོ༌ ཨིན༌ནོག༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “ཁྱོ༌རང༌ གོ༌མ༌ སྐྱེ༌ཁན༌ནི༌ ཐོབ༌ཏང༌བོ༌ ངའ༌ ཏང༌ན༌ ངའེ༌ འི༌བོ༌ ཁྱོ༌རང༌ང༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ཨི༌སུའི༌ ཟེརས༌, “ང༌ སྟོགས༌ཏེ༌ ཤི༌ཅེས༌རག༌, གོ༌སྐྱེས༌སི༌ ཐོབ༌ཏང༌ངི༌ ངའ༌ ཅི༌ ཕན༌ཐོགས༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ཡ༌ཀོབ༌བི༌ ཟེརས༌, “གོ༌མ༌ ནའ༌ ཁུར༌།” ཏེ༌ནེ༌ ཨི༌སུའི༌ ནའ༌ ཁུར༌ཏེ༌ ཁོ༌རང༌ངི༌ གོ༌སྐྱེས༌སི༌ ཐོབ༌ཏང༌བོ༌ ཡ༌ཀོབ༌བ༌ ཙོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཁོའ༌ ཏ༌གི༌ ཁ༌ཅིག༌ དང༌ སྲན༌མའེ༌ ཐུག༌པ༌ ཏངས༌པ༌ ཁོའེ༌ ཟོས༌ ཡང༌ ཐུངས༌། ཏེ༌ནེ༌ ལངས༌ཏེ༌ ཕི༌ལོག༌ག༌ སོང༌། ཏེན༌ན༌ཟུག༌གི༌ ཨི༌སུའི༌ ཁོ༌རང༌ངི༌ གོ༌སྐྱེས༌སི༌ ཐོབ༌ཏང༌བོའ༌ རིན༌མེད༌ ཐེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ཨབ༌ར༌ཧམ༌མི༌ ཏུས༌ལ༌ ཇུང༌ཁན༌ནི༌ མུ༌གེ༌ མན༌པ༌ ཡང༌ མུ༌གེ༌ཞིག༌ ཇུངས༌པ༌, ཨི༌སཱག༌ གེ༌རར༌ལ༌ ཕི༌ལིས༌ཏིའི༌ གྱལ༌པོ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ཀ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ཡ༌ཝ༌ ཨི༌སཱག༌ག༌ ཇལ༌ཏེ༌ མོལས༌, “ཨི༌ཇིབ༌བི༌ ཡུལ༌ལ༌ མ༌ཆ༌, ངའེ༌ སྟན༌ཅེས༌ཅན༌ནི༌ ས༌ཀྱད༌པོའེ༌ཀ༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ཏེ༌རུ༌ ཞན༌ཡུལ༌ལི༌ མི༌ཞིག༌ ཙོགས༌ལ༌ དུག༌ ཡང༌ ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ དུགས༌ཏེ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌། ངའེ༌ ཁྱོ༌རང༌ ཡང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ འི༌ ས༌ཀྱད༌ ཚང༌མ༌ ཏང༌ཨིན༌ ཡང༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ ཨ༌བ༌ ཨབ༌ར༌ཧམ༌ ཉམ༌པོ༌ ནའ༌ ཁུར༌ཁན༌བོ༌ དྲན༌དྲའ༌ གྲུབ༌ཅུག༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ ནམ༌མི༌ སྐར༌མ༌ ཙོགས༌ ཕེལ༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ལ༌ འི༌ ས༌ཀྱད༌ ཚང༌མ༌ ཏང༌ཨིན༌ ཡང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ གྱུད༌ཏེ༌ གྱལ༌ཁམས༌ ཚང༌མ༌ལ༌ ཅིན༌ལབས༌ ཐོབ༌ཨིན༌ ");
INSERT INTO lbj_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ཅིའ༌ཟེར༌ན༌ ཨབ༌ར༌ཧམ༌མི༌ ངའེ༌ ཁའ༌ཉན༌ཏེ༌ ངའེ༌ བཀའ༌ཁྲིམས༌, བཀའ༌རྒྱ༌ དང༌ ལབ༌ཞ༌ གུན༌ནི༌ཀ༌ གྲུལས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཨི༌སཱག༌ གེ༌རར༌རི༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ཏེ༌རུ༌ ཡོད༌ཁན༌ནི༌ མི༌གུན༌ནི༌ ཁོའ༌ ཁོ༌རང༌ངི༌ ན༌མའེ༌ སྐོར༌ལ༌ ཏྲིའ༌ཅིག༌, ཁོའེ༌ ཟེརས༌, “ཁོ༌ ངའེ༌ སྲིང༌མོ༌ ཨིན༌” ཅིའ༌ཟེར༌ན༌ ར༌བེ༌ཀ༌ མའ༌ ལྡེ༌མོ༌ ཡོད༌ པ༌སང༌ ཁོའེ༌ ན༌མ༌ ཨིན༌ ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ར༌བེ༌ཀའེ༌ ཕིའ༌ ཁོ༌ སད༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌ སམས༌ཏེ༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ཨི༌སཱག༌ ཏེ༌རུ༌ དུག༌ཏེ༌ ཏུས༌ མང༌པོའེ༌ སྟིང༌ནེ༌ ཕི༌ལིས༌ཏིའི༌ གྱལ༌པོ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཁོ༌རང༌ངི༌ ཀར༌ཁུང༌ནེ༌ ལྟའ༌ཅིག༌ ཁོའ༌ ཨི༌སཱག༌གི༌ ར༌བེ༌ཀ༌ ཅེས༌པ༌ ཅོ༌ཨིན༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ཨ༌བི༌མེ༌ལེག༌གི༌ ཨི༌སཱག༌ བོད༌ཏེ༌ ཁྱོང༌ཅུགས༌ ཡང༌ ཟེརས༌, “ར༌བེ༌ཀ༌ ཁྱོ༌རང༌ངི༌ ན༌མ༌ ཨིན༌ཀྱག༌ ཏེ༌ནེ༌ ཁོ༌ ཁྱོ༌རང༌ངི༌ སྲིང༌མོ༌ ཨིན༌ ཅིའ༌ ཟེར༌པིན༌?” ཁོའེ༌ ལན༌ཏངས༌, “ར༌བེ༌ཀའེ༌ ཕིའ༌ ཁྱོ༌ཞའེ༌ ང༌ སད༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌ སམ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ཨ༌བི༌མེ༌ལེག༌གི༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ང༌ཞའ༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ང༌ཞའ༌ ཅིག༌གི༌ ཁྱོ༌རང༌ངི༌ ན༌མ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ བོར༌ སྲིད༌ཅེས༌ ཨིན༌ནོག༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ང༌ཞའ༌ གལ༌ཅན༌ གྱུར༌ཅུགས༌ཏེ༌ ཡོད༌གྲོ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ཏེ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ མི༌ཚང༌མ༌ལ༌ སྤང༌པུད༌ཏེ༌ ཟེརས༌, “འི༌ མི༌ དང༌ ཁོའེ༌ ན༌མའ༌ ངན༌པ༌ ཅོ༌ཁན༌གུན༌ སད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ཏེ༌རུ༌ ཨི༌སཱག༌གི༌ སྟོན༌ཐོག༌ ཏབས༌ ཡང༌ ཏེན༌ན༌ ལོའེ༌ ནང༌ང༌ ཁོའེ༌ སྟོན༌ཐོག༌ ཏབ༌ཁན༌ནི༌ གྱ༌ལྡབ༌པོ༌ རྔས༌, ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ ཁོའ༌ ཅིན༌ལབས༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ཁོའེ༌ གྱུ༌ནོར༌གུན༌ གྱས༌ཨིན༌ སོང༌ཏེ༌ ཁོ༌ མའ༌ མི༌ ཆུག༌པོ༌ཞིག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ཁོའ༌ ལུག༌ དང༌ བ༌ལང༌ངི༌ ཁྱུ༌ མང༌པོ༌ ཡང༌ ཡོག༌པོ༌ མང༌པོ༌ ཡོད༌ པ༌སང༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ ཁོའེ༌ཀ༌ ཚིག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ནི༌ ཆུ༌དོང༌ ཚང༌མ༌ སྐངས༌ ཀ༌བོ༌ ཁོའེ༌ ཨ༌བ༌ ཨབ༌ར༌ཧམ༌མི༌ ཏུས༌ལ༌ ཁོའེ༌ ཡོག༌པོ༌གུན༌ནི༌ བྲུས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ཏེ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཨི༌སཱག༌ག༌ ཟེརས༌, “ང༌ཞའེ༌ ཡུལ༌ནེ༌ བིང༌ཏེ༌ སོང༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ ང༌ཞ༌གུན༌ནི༌ སང༌ མང༌ང༌ ཤེད༌ཆེའ༌ གྱུར༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ཏེ༌ནེ༌ ཨི༌སཱག༌ ཏེ༌ ནས༌ས༌ནེ༌ བིང༌ཏེ༌ སོང༌ ཡང༌ གེ༌རར༌རི༌ ལུང༌པའེ༌ ནང༌ང༌ ཁོང༌གུན༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ཁོའེ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཨབ༌ར༌ཧམ༌མི༌ ཏུས༌ལ༌ བྲུས༌ཁན༌ནི༌ ཆུ༌དོང༌གུན༌ ཡང༌སྐྱར༌ བྲུས༌ ཀ༌བོ༌ ཨབ༌ར༌ཧམ༌ ཀྲོངས༌ཏེ༌ སྟིང༌ནེ༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ སྐངས༌ཏེ༌ ཨིན༌པིན༌། ཨི༌སཱག༌གི༌ ཆུ༌དོང༌གུན༌ལ༌ ཁོའེ༌ ཨ༌བའེ༌ ཏགས༌ཁན༌ནི༌ ཏེན༌ན༌ མིང༌གུན༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ཨི༌སཱག༌གི༌ ཡོག༌པོ༌གུན༌ནི༌ ལུང༌པའེ༌ ནང༌ང༌ ཆུ༌དོང༌ སོ༌མ༌ བྲུས༌པ༌ ཆུ༌ ལག༌མོ༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","གེ༌རར༌པའེ༌ ལུག༌རྫི༌གུན༌ནི༌ ཨི༌སཱག༌གི༌ ལུག༌རྫི༌གུན༌ལ༌ ཛིང༌མོ༌ ཏངས༌ཏེ༌ ཟེརས༌, “འི༌ ཆུ༌བོ༌ ང༌ཞའེ༌ ཨིན༌།” ཏེ༌བོའེ༌ཕིའ༌ ཨི༌སཱག༌གི༌ ཏེ༌ ཆུ༌དོང༌བོའ༌, ཨི༌སཱག༌ ཡང༌ན༌ ཛིང༌མོ༌ ཟེར༌ཏེ༌ མིང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ཨི༌སཱག༌གི༌ ཡོག༌པོ༌གུན༌ནི༌ ཡང༌ ཆུ༌དོང༌ཞིག༌ བྲུས༌ ཡང༌ ཏེ༌བོའེ༌ ཕིའང༌ ཛིང༌མོ༌ སོང༌པ༌ ཁོའེ༌ ཏེ༌བོའ༌ “སིཏ༌ནཧ༌ ཡང༌ན༌ གྱབ༌གལ༌” ཟེར༌ཏེ༌ མིང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ཁོ༌ ཏེ༌ཀ༌ནེ༌ ཐག༌རིང༌ང༌ སོང༌ཏེ༌ ཡང༌ ཆུ༌དོང༌ཞིག༌ བྲུས༌། ཏེ༌བོའེ༌ ཕིའ༌ ཅའང༌ ཟེར༌ལེན༌ མ༌སོང༌ པ༌སང༌ ཁོའེ༌ ཏེ༌བོའ༌ རེ༌ཧོ༌བོཐ༌ ཟེར༌ཏེ༌ མིང༌ ཏགས༌ ཡང༌ ཁོའེ༌ ཟེརས༌, “ཏ༌ ཡ༌ཝའེ༌ ང༌དང༌གུན༌ལ༌ དུག༌ཅེས༌སི༌ ཕིའ༌ ས༌ཀྱད༌ ཕལ༌ཅན༌ སལ༌ཏེ༌ ཨིན༌ནོག༌ ཡང༌ ང༌དང༌གུན༌ འི༌ ནས༌སའེ༌ ནང༌ང༌ གྱས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ཏེ༌ཀ༌ནེ༌ བིང༌ཏེ༌ ཨི༌སཱག༌ བེར༌ཤེ༌བ༌ ཟེར༌ཁན༌ནི༌ ནས༌སའ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ཏེ༌ ཚན༌བོའ༌ ཁོའ༌ ཡ༌ཝའ༌ ཇལ༌ཏེ༌ མོལས༌, “ང༌ ནི༌ ཁྱོ༌རང༌ངི༌ ཨ༌བ༌ ཨབ༌ར༌ཧམ༌མི༌ དཀོན༌མཆོག༌ ཨིན༌; ཇིགས༌ མ༌ཇིགས༌; ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌། ངའེ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ ཏངས༌ཏེ༌ ངའེ༌ ཡོག༌པོ༌ ཨབ༌ར༌ཧམ༌མི༌ ཏོན༌ལ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ མང༌པོ༌ གྱས༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ཏེ༌རུ༌ ཨི༌སཱག༌གི༌ ཆོད༌ཁྲི༌ རྩིགས༌ཏེ༌ ཡ༌ཝའ༌ ཅོལས༌། ཏེ༌རུ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཀུར༌བོ༌ ཙུགས༌ ཡང༌ ཁོའེ༌ ཡོག༌པོ༌གུན༌ནི༌ ཆུ༌དོང༌ བྲུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ཨ༌བི༌མེ༌ལེག༌ གེ༌རར༌ནེ༌ ཁོ༌རང༌ངི༌ ལབ༌སྟོན༌པ༌ ཨ༌ཧུ༌ཟཐ༌ དང༌ ཁོའེ༌ མག༌མིའི༌ སྤོན༌བོ༌ ཕི༌ཀོལ༌ ཁྲིད༌ཏེ༌ ཨི༌སཱག༌ ཡོད༌ས༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ཨི༌སཱག༌གི༌ ཁོང༌གུན༌ལ༌ ཏྲིས༌, “ཅི༌ཕིའ༌ ཁྱོ༌ཞ༌གུན༌ ང༌ ཡོད༌ས༌ ཡོངས༌པིན༌? ཁྱོ༌རང༌གུན༌ནི༌ ང༌ ནཕ༌རད༌ ཅོས༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཡུལ༌ནེ༌ ཕིངས༌ཏེ༌ ཏངས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའ༌ གྱུས༌སོང༌ ཡ༌ཝའ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌ ཏེ༌བོའེ༌ཕིའ༌ ང༌དང༌གུན༌ནི༌ པར༌ལ༌ ཆད༌དོན༌ ཡོང༌གོས༌། ཇུ༌ཇུ༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཆད༌དོན༌ཞིག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ཁྱོ༌རང༌ངི༌ ང༌ཞའ༌ ནོད༌སྐྱལ༌ ཏང༌ མ༌གོས༌, ཀ༌ཟུག༌ ང༌ཞའེ༌ ཁྱོ༌རང༌ང༌ གྱལ༌ལ༌ ཅོས༌ཏེ༌ ནོད༌ མ༌སྐྱལ༌ལ༌ ཁྱོ༌རང༌ ཞི༌དེ༌ ཉམ༌པོ༌ ཆ༌ཅུགས༌པིན༌། ཏ༌ ཡ༌ཝའེ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ཏེ༌ནེ༌ ཨི༌སཱག༌གི༌ ཁོང༌གུན༌ནི༌ ཕིའ༌ དོན༌ཏང༌ གྲལ༌གྲིག༌ ཅོས༌ ཡང༌ ཁོང༌གུན༌ ཟོས༌ཏེ༌ ཐུངས༌ཏེ༌ ཐད༌པོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཅིག༌ དང༌ ཅིག༌ག༌ ནོད༌སྐྱལ༌ མི༌ཏང༌ཅེས༌སི༌ ནའ༌ ཁུརས༌། ཏེ༌ནེ༌ ཨི༌སཱག༌གི༌ ཁོང༌གུན༌ ཞི༌དེ༌ ཉམ༌པོ༌ ལོགས༌ཏེ༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ཏེན༌ན༌ ཞག༌ག༌ ཨི༌སཱག༌གི༌ ཡོག༌པོ༌གུན༌ ཡོངས༌ཏེ༌ ཁོའ༌ ཤདས༌, “ང༌ཞའ༌ ཆུ༌དོང༌ བྲུས༌ཏེ༌ ཆུ༌ ཐོབས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ཁོའེ༌ ཏེ༌ ཆུ༌དོང༌བོའ༌ ཤི༌བཧ༌ ཡང༌ན༌ དམ༌ཆའ༌ ཟེར༌ཏེ༌ མིང༌ ཏགས༌ ཡང༌ ཏེན༌ན༌ ནས༌ས༌བོའ༌ དག༌སའང༌ བེར༌ཤེ༌བ༌ གྲོང༌ཁྱེར༌ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ཨི༌སུའ༌ ལོ༌ ཞིབ༌ཅུ༌ ཆའ༌ཅིག༌ ཁོའེ༌ ཧེད༌པ༌ བེ༌རི༌ བུ༌མོ༌ ཡུ༌གྲིད༌ དང༌ ཨི༌ལོན༌ནི༌ བུ༌མོ༌ བེས༌མེད༌ གུན༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ཨི༌སུའི༌ ན༌མ༌གུན༌ནི༌ ཨི༌སཱག༌ དང༌ ར༌བེ༌ཀའེ༌ མི༌ཚེ༌ ནང༌ང༌ རྡུག༌ངལ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ཨི༌སཱག༌ སྒས༌ ཡང༌ ཁོའེ༌ མིག༌ནེའང༌ ཐོང༌ང༌ མེད༌པིན༌, ཏེ༌ཏུས༌ལ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཆེན༌མོ༌ ཨི༌སུའ༌ བོད༌ཏེ༌ ཟེརས༌, “ངའེ༌ བུ༌ཚ༌།” ཁོའེ༌ ལན༌ཏངས༌, “ཧ༌ ཨ༌བ༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ཨི༌སཱག༌གི༌ ཟེརས༌, “ལྟོས༌སའང༌ ང༌ སྒས༌ཏེ༌ ཨིན༌ནོག༌ ཡང༌ ནམ༌ ཤི༌ཨིན༌ གྱུས༌མེད༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ཏེ༌བོའེ༌ཕིའ༌ ཁྱོ༌རང༌ ཞུ༌ དང༌ དའ༌ ཁུར༌ཏེ༌ ལིངས༌ལ༌ སོང༌ ཡང༌ ངའེ༌ ཕིའ༌ སེམས༌ཅན༌ཞིག༌ སད༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ང༌ ཐད༌ཁན༌ནི༌ ཞིམ༌པོ༌ ཁར༌ཇི༌ སྐོལ༌ཏེ༌ ངའ༌ ཟའ༌ཅེས༌ལ༌ ཁྱོང༌། ཏེ༌བོ༌ ཟོས༌ཏེ༌ ངའེ༌ ང༌ ཤིའི༌ སང༌ སྔུན༌ལ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ཨི༌སཱག༌གི༌ ཨི༌སུའ༌ ཏེ༌གུན༌ ཟེར༌ ཟ༌ནེ༌, ར༌བེ༌ཀ༌ ཉན༌ཏེ༌ ཡོད༌པིན༌། ཏེ༌ནེ༌ ཨི༌སུ༌ ལིངས༌ལ༌ སེམས༌ཅན༌ སད༌ཏེ༌ ཁྱོང༌ང༌ ཆའ༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ར༌བེ༌ཀའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཡ༌ཀོབ༌བ༌ ཟེརས༌, “ཉོ༌ནའང༌, ངའེ༌ ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ ཨི༌སུ༌ ཟེར༌ཨིན༌ ཚོར༌, ");
INSERT INTO lbj_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘ངའེ༌ ཕིའ༌ སེམས༌ཅན༌ཞིག༌ སད༌ཏེ༌ ང༌ ཐད༌ཁན༌ནི༌ ཞིམ༌པོ༌ ཁར༌ཇི༌ སྐོལ༌ཏེ༌ ཁྱོང༌ ཏེ༌ནེ༌ ངའེ༌ ང༌ ཤིའི༌ སང༌ སྔུན༌ལ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ཏ༌ ངའེ༌ བུ༌ཚ༌, ངའེ༌ ཁའ༌ཉན༌ཏེ༌ ངའེ༌ ཟེར༌ཁན༌བོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ངའ༌ ཁྱོ༌རང༌ངི༌ ཨ༌བ༌ ཐད༌ཁན༌ནི༌ ཞིམ༌པོ༌ ཁར༌ཇི༌ སྐོལ༌ཉན༌ཅེས༌ལ༌ ཁྱོ༌རང༌ ར༌མའེ༌ ཁྱུའི༌ ཕྲོའ༌ སོང༌ཏེ༌ རི༌གུ༌ ཆུ༌ངུན༌ གྱལ༌ལ༌ ཉིས༌ སད༌ཏེ༌ ཁྱོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ཏེ༌ནེ༌ ཨ༌བའེ༌ ཁྱོ༌རང༌ང༌ ཤི༌ སང༌ སྔུན༌ལ༌ ཅིན༌ལབས༌ ཏང༌ཅེས༌ལ༌ ཁྱོ༌རང༌ངི༌ ཏེ༌བོ༌ ཁོང༌ང༌ ཟའ༌ཅེས༌ལ༌ ཁྱེར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ཨིན༌ནའང༌ ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌མ༌ ཟེརས༌, “ཨི༌སུའི༌ ཟུགས༌པོ༌ སྤུན༌ཇན༌ ཡང༌ ངའ༌ སྤུ༌ མེད༌ཁན༌བོ༌ ཉེ༌རང༌ང༌ གྱུས༌ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ཨ༌བའེ༌ ངའ༌ ལག༌པ༌ རྩེ༌ན༌ ངའེ༌ ཁོང༌ང༌ གོབ༌སྐོར༌ ཏང༌ཁན༌བོ༌ ཧ༌གོ༌ཏེ༌ ངའེ༌ ང༌རང༌ངི༌ཀ༌ ཅིན༌ལབས༌སི༌ ཚབས༌ལ༌ ངན༌ ཁྱོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ཁོའེ༌ ཨ༌མའེ༌ ཟེརས༌, “ངའེ༌ བུ༌ཚ༌, ཁྱོ༌རང༌ང༌ ཏང༌ཁན༌ནི༌ ངན༌, ངའེ༌ཀ༌ བབས༌ཤིག༌། སོང༌ཏེ༌ ངའེ༌ ཟེར༌ཁན༌བོ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ཏེ༌ནེ༌ ཁོ༌ སོང༌ ཡང༌ རི༌གུ༌གུན༌ནི༌ ཤ༌ ཁྱོངས༌ཏེ༌ ཨ༌མའ༌ ཏངས༌ ཡང༌ ཨ༌མའེ༌ ཨ༌བ༌ ཐད༌ཁན༌ནི༌ ཞིམ༌པོ༌ ཁར༌ཇི༌ སྐོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ཏེ༌ནེ༌ ར༌བེ༌ཀའེ༌ ཁང༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཨི༌སུའི༌ ཀོས༌ གྱལ༌ཤོག༌པོ༌ ཁྱོངས༌ཏེ༌ ཡ༌ཀོབ༌བ༌ སྐོནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ཡང༌ ཁོའེ༌ ལག༌པ༌ དང༌ ཇིང༌བ༌ རི༌གུའི༌ པགས༌པ༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ལག༌ག༌ ཁར༌ཇི༌ སྐོལ༌ཁན༌ ཞིམ༌པོ༌ དང༌ ཏ༌གི༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ཡ༌ཀོབ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “ཨ༌བ༌ལེ༌།” ཨ༌བའེ༌ ཟེརས༌, “ང༌ འི༌ཀ༌ནེ༌ ཡོད༌། ངའེ༌ བུ༌ཚ༌གུན༌ནི༌ ནང༌ནེ༌ ཀ༌བོ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌ “ང༌ ཉེ༌རང༌ངི༌ གོ༌སྐྱེས༌ བུ༌ཚ༌ ཨི༌སུ༌ ཨིན༌ལེ༌། ངའེ༌ ཉེ༌རང༌ངི༌ ཟེར༌ཁན༌ ནང༌ཞིན༌ ཅོས༌པིན༌། ཏ༌ ཞུགས༌ཏེ༌ ངའེ༌ སྐོལ༌ཁན༌ནི༌ ཤ༌ དོན༌ན༌ ཛད༌། ཏེ༌ནེ༌ ཉེ༌རང༌ངི༌ ངའ༌ ཅིན༌ལབས༌ སལ༌ ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ཨི༌སཱག༌གི༌ བུ༌ཚའ༌ ཏྲིས༌, “ངའེ༌ བུ༌ཚ༌, ཁྱོ༌རང༌ང༌ འི༌ཟུག༌ གྱོགས༌པ༌ ཏེ༌བོ༌ ཀ༌ཟུག༌གི༌ ཐོབ༌?” ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “ཡ༌ཝ༌ ཉེ༌རང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཏེ༌བོ༌ ཐོབ༌ཅེས༌སི༌ ནང༌ང༌ ངའ༌ རོགས༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ཨི༌སཱག༌གི༌ ཡ༌ཀོབ༌བ༌ ཟེརས༌, “ངའེ༌ བུ༌ཚ༌, ཁྱོ༌རང༌ དེན༌བའ༌ ཨི༌སུ༌ ཨིན༌ན༌ མན༌ ལག༌པ༌ རྩེས༌ཏེ༌ ཉུག༌ཅེས༌ལ༌ ངའེ༌ དུན༌ལ༌ ཡོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ཡ༌ཀོབ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ དུན༌ལ༌ སོང༌ ཡང༌ ཨི༌སཱག༌གི༌ ཉུགས༌ཏེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ སྐད༌ ཡ༌ཀོབ༌ ཙོགས༌ ཨིན༌ནའང༌ ལག༌པ༌ ཨི༌སུའི༌ ཙོགས༌ རག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ཁོའེ༌ ལག༌པ༌ ཨི༌སུའི༌ ལག༌པ༌ ཙོགས༌ སྤུན༌ཇན༌ ཡོད༌ པ༌སང༌ ཨི༌སཱག༌ག༌ ཡ༌ཀོབ༌ ཨིན༌ཁན༌བོ༌ མ༌ཤེས༌ ཡང༌ ཁོའེ༌ ཁོའ༌ ཅིན༌ལབས༌ ཏང༌ཀི༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ཨིན༌ནའང༌ ཡང༌སྐྱར༌ ཏྲིས༌, “ཁྱོ༌རང༌ དེན༌བའ༌ ཨི༌སུ༌ ཨིན༌ན༌?” ཁོའེ༌ ལན༌ཏངས༌, “ང༌ ཨིན༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ཨི༌སཱག༌གི༌ ཟེརས༌, “སྐོལ༌ཁན༌ནི༌ ཤ༌ ངའེ༌ དུན༌ལ༌ ཁྱོང༌, ཏེ༌བོ༌ ཟོས༌ཏེ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌།” ཡ༌ཀོབ༌བི༌ ཁྱོངས༌པ༌ ཁོ༌ ཟོས༌ ཡང༌ རྒུན༌ཆང༌ ཁྱོང༌ཁན༌བོའང༌ ཐུངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ཏེ༌ནེ༌ ཨ༌བའེ༌ ཁོའ༌ ཟེརས༌, “བུ༌ཚ༌ དུན༌ལ༌ ཡོང༌ཏེ༌ ངའ༌ པུག༌ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ཁོ༌ ཡོངས༌ཏེ༌ ཁོའ༌ པུག༌ ཏང༌ང༌ཅིག༌ ཨི༌སཱག༌གི༌ ཁོའེ༌ ཀོས༌ལག༌ག༌ ནུམས༌ཏེ༌ ཏན༌ཏན༌ ཅོས༌, ཏེ༌ནེ༌ ཁོའེ༌ ཁོའ༌ ཅིན༌ལབས༌ ཏངས༌ཏེ༌ ཟེརས༌, “ངའེ༌ བུ༌ཚའེ༌ ཏྲི༌མ༌ ཞིང༌ངི༌ ཏྲི༌མ༌ ཙོགས༌ ཀ༌བོའ༌ ཡ༌ཝའེ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","དཀོན༌མཆོག༌གི༌ ཁྱོ༌རང༌ང༌ ནམ༌ཁའེ༌ ཆུ༌ སལ༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཞིང༌ང༌ སྟོན༌ཐོག༌ གྱལ༌ལ༌ སྨིན༌ཤིག༌། ཁྱོ༌རང༌ང༌ གྲུ༌ དང༌ རྒུན༌ཆང༌ མ༌ མང༌པོ༌ སལ༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","གྱལ༌ཁམས༌གུན༌ནི༌ ཁྱོ༌རང༌ང༌ ཞབས༌ཏོག༌ ཞུ༌ཅུག༌ག༌ ཛད༌ཤིག༌ ཡང༌ མི༌གུན༌ནི༌ ཁྱོ༌རང༌ང༌ ཀུས༌པ༌ ཅོ༌ཅུག༌ག༌ ཛད༌ཤིག༌། ཁྱོ༌རང༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ནི༌ སྤོན༌བོ༌ གྱུར༌ཅུག༌ག༌ ཛད༌ཤིག༌། ཁྱོ༌རང༌ངི༌ ཨ༌མའེ༌ བུ༌ཚ༌གུན༌ལ༌ ཁྱོ༌རང༌ངི༌ དུན༌ལ༌ གོ༌ སྒུ༌ཅུག༌ག༌ ཛད༌ཤིག༌ ཁྱོ༌རང༌ང༌ ངན༌ ཏབ༌ཁན༌གུན༌ལ༌ ངན༌ ཕོག༌ཤིག༌། ཡང༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ ཏང༌ཁན༌གུན༌ལ༌ ཅིན༌ལབས༌ ཐོབ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ཨི༌སཱག༌གི༌ ཅིན༌ལབས༌ ཏང༌ ཚར༌ཏེ༌ ཨ༌བ༌ ཡོད༌ས༌ནེ༌ ཡ༌ཀོབ༌ ཅབ༌ བིངས༌ཏེ༌ ཆའ༌ཅིག༌ ཁོའེ༌ ཨ༌ཅོ༌ ཨི༌སུ༌ ལིངས༌ནེ༌ ལོགས༌ཏེ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ཁོའེང༌ ཞིམ༌པོ༌ ཁར༌ཇི༌ སྐོལས༌ཏེ༌ ཨ༌བ༌ ཁྱེརས༌, ཡང༌ ཟེརས༌, “ཨ༌བ༌ལེ༌ ཞངས༌ཏེ༌ ངའ༌ ཅིན༌ལབས༌ སལ༌ཅེས༌སི༌ ཕིའ༌ ངའེ༌ སྐོལ༌ཁན༌ནི༌ ཁར༌ཇི༌ དོན༌ནའང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ཨི༌སཱག༌གི༌ ཁོའ༌ ཏྲིས༌, “ཁྱོ༌རང༌ སུ༌ ཨིན༌?” ཁོའེ༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ བུ༌ཚ༌ ཆེན༌མོ༌ ཨི༌སུ༌ ཨིན༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ཨི༌སཱག༌ དར༌ཨིན༌ ཏྲིས༌, “ཏེ༌ནེ༌ སེམས༌ཅན༌ སད༌ཏེ༌ ངའ༌ ཁར༌ཇི༌ ཟའ༌ལ༌ ཁྱོང༌ཁན༌བོ༌ སུ༌ ཨིན༌? ཁྱོ༌རང༌ ཡོང༌ངི༌ སང༌ སྔུན༌ལ༌ ཏེ༌བོ༌ ཟོས༌ཏེ༌ ངའེ༌ ཁོའ༌ ང༌རང༌ངི༌ ཅིན༌ལབས༌པོ༌ ཏངས༌པིན༌, ཡང༌ ཏེ༌བོ༌ ཁོ༌ ཉམ༌པོ༌ ལུས༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ ཨི༌སུའི༌ སྲན༌ཏྲེ༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཨ༌བ༌ལེ༌ ངའང༌ ཉེ༌རང༌ངི༌ ཅིན༌ལབས༌པོ༌ སལ༌ལའང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ཨི༌སཱག༌གི༌ ལན༌ཏངས༌, “ཁྱོ༌རང༌ངི༌ ནོ༌ ཡོངས༌ ཡང༌ ངའ༌ གོབ༌སྐོར༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཅིན༌ལབས༌པོ༌ ཁྱེརས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ཨི༌སུ༌ ཟེརས༌, “ཁོའེ༌ མིང༌ང༌ ཡ༌ཀོབ༌ ཤེས༌ཏེ༌ ཏགས༌ཏེ༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ལན༌ ཉིས༌ ངའ༌ གོབ༌སྐོརས༌། གོ༌མ༌ ངའེ༌ གོས༌ སྐྱེས༌སི༌ ཐོབ༌ཏང༌ ཡང༌ དག༌ས༌ ཉེ༌རང༌ངི༌ ངའ༌ སལ༌ཅེས༌ཅན༌ནི༌ ཅིན༌ལབས༌པོ༌, ཅི༌ ཉེ༌རང༌ངི༌ ངའེ༌ ཕིའ༌ ཅིན༌ལབས༌ ཉུ༌ངུན༌ཞིག༌གའང༌ སྲིས༌ཏེ༌ མ༌བོར༌པིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ཨི༌སཱག༌གི༌ ལན༌ཏངས༌, “ངའེ༌ ཁོ༌ ཁྱོ༌རང༌ངི༌ཀ༌ སྤོན༌བོ༌ ཅོ༌ཚར༌ ཡང༌ ཁོའེ༌ ཉེན༌གྲུང༌ ཚང༌མ༌ ཁོའ༌ ཞབས༌ཏོག༌ ཅོ༌ཅེས༌ལ༌ ཏངས༌པིན༌། ངའེ༌ ཁོའ༌ གྲུ༌ དང༌ རྒུན༌ཆང༌ མང༌པོའེ༌ ཅིན༌ལབས༌ ཏང༌ཚར༌། ཏ༌ ཁྱོ༌རང༌ང༌ ཏང༌ཅེས༌ ངའ༌ ཅའང༌ ལུས༌ཏེ༌ མེད༌, བུ༌ཚ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ཨི༌སུའི༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཟེརས༌, “ཉེ༌རང༌ང༌ ཅིན༌ལབས༌ ཅིག༌ཅིག༌ མ༌ནེ༌ མེད༌ད༌? ངའང༌ ཅིན༌ལབས༌ སལ༌ལའང༌ ཨ༌བ༌ལེ༌།” ཏེ༌ནེ༌ ཨི༌སུ༌ སྲན༌ཏྲེ༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ཏེ༌ནེ༌ ཁོའེ༌ ཨ༌བ༌ ཨི༌སཱག༌གི༌ ཟེརས༌, “ཁྱོ༌རང༌ ཚུག༌སའེ༌ ནས༌སའེ༌ ས༌ ཞིང༌ བད༌ཅེས༌ལ༌ སྟོབས༌ཅན༌ གྱལ༌ལ༌ མི༌ཡོང༌ ཡང༌ ནམ༌ཁའ༌ནེ༌ ཆུ༌ མི༌བབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ཁྱོ༌རང༌ངི༌ ར༌འི༌ ཀོལ༌ཏེ༌ མི༌ཚེ༌ ཕུད༌ཨིན༌, ཡང༌ ཁྱོ༌རང༌ངི༌ ཁྱོ༌རང༌ངི༌ ནོའེ༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌། ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ཁོའེ༌ གྱབ༌གལ༌ ཅོ༌ཅེས༌ ཐག༌ཅད༌ད༌ཅིག༌, ཁྱོ༌རང༌ ཁོའེ༌ ཝང༌ངི༌ ཡོག༌ག༌ མ༌དུག༌ག༌ རང༌ཝང༌ ལེན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ཨ༌བའེ༌ ཡ༌ཀོབ༌བ༌ ཅིན༌ལབས༌ ཏང༌ཅེས༌པོའེ༌ ཨི༌སུའི༌ ཡ༌ཀོབ༌བ༌ ནཕ༌རད༌ ཅོའད༌པིན༌། ཁོའེ༌ ཁོ༌རང༌ང༌ ཟེརས༌, “ཨ༌བ༌ ཤིའ༌ཅིག༌, ཉ༌ངན༌ ཅོས༌ཏེ༌ སྟིང༌ནེ༌, ངའེ༌ ཡ༌ཀོབ༌ སད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ཨིན༌ནའང༌ ར༌བེ༌ཀ༌ ཨི༌སུའི༌ ཟེར༌ཁན༌བོ༌ ཚོར༌པ༌ ཁོའེ༌ ཡ༌ཀོབ༌བ༌ བོད༌ཏེ༌ ཟེརས༌, “ཉོན༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨི༌སུའི༌ ཁྱོ༌རང༌ སད༌ཅེས༌སི༌ ཐབས༌ལྡིང༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ཏ༌ བུ༌ཚ༌, ངའེ༌ ཅོས༌ ཟེར༌ཅེས༌པོ༌ ཅོས༌, དག༌ས༌རང༌ ཧ༌རན༌ནི༌ ནང༌ང༌ ངའེ༌ མིང༌བོ༌ ལ༌བན༌ ཡོད༌ས༌ ཤོར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ཡང༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོའེ༌ སྲོ༌ ཞུ༌ཞུ༌ ཚག༌པ༌ ཁོ༌ ཉམ༌པོ༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ཁྱོ༌རང༌ངི༌ ཅོས༌ཁན༌གུན༌ རྗེད༌ཏེ༌ ཁོའེ༌ སྲོ༌ མེད༌ཁན༌ ཆའ༌ཅིག༌, ངའེ༌ ཁྱོ༌རང༌ང༌ ལོགས༌ཏེ༌ ཡོང༌ཅེས༌ལ༌ ལོན༌ ཀལ༌ཨིན༌། ཨི༌སུའི༌ ཁྱོ༌རང༌ སད༌ན༌ ཞན༌གུན༌ནི༌ ཁོ༌ སད༌ད༌ནོག༌། ཞག༌ ཅིག༌གི༌ ནང༌ང༌ ངའེ༌ བུ༌ཚ༌ ཉིས༌ཀ༌ ཅིའ༌ ཤི༌གོས༌?” ");
INSERT INTO lbj_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ར༌བེ༌ཀའེ༌ ཨི༌སཱག༌ག༌ ཟེརས༌, “ངའ༌ ཨི༌སུའི༌ ཧེད༌པ༌ ན༌མ༌གུན༌ ཉམ༌པོ༌ ངལ༌ཏེ༌ རག༌, ཡ༌ཀོབ༌བིའང༌ ཧེད༌པ༌ བུ༌མོ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོ༌ན༌ ངའ༌ སོན༌ཏེའ༌ ལུས༌ཏེ༌ ཅི༌ ཕན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ཏེ༌ནེ༌ ཨི༌སཱག༌གི༌ ཡ༌ཀབ༌བ༌ བོད༌ཏེ༌ ཅིན༌ལབས༌ ཏངས༌ ཡང༌ ཁོའ༌ བཀའ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཀེ༌ནན༌མ༌ བུ༌མོ༌ ཉམ༌པོ༌ བག༌སྟོན༌ མ༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","དག༌ས༌རང༌ ཁྱོ༌རང༌ངི༌ མེ༌མེ༌ བེ༌ཐུལ༌ དུག༌སའེ༌ ཡུལ༌ པ༌དན༌ཨ༌རམ༌མ༌ སོང༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཞང༌ ལ༌བན༌ནི༌ བུ༌མོ༌ ཞིག༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","དཀོན༌མཆོག༌ ཀུན༌ཝང༌ངི༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ ཁྱོ༌རང༌ང༌ ཕྲུ༌གུ༌ མང༌པོ༌ ཇོར༌ཤིག༌ ཡང༌ ཁྱོ༌རང༌ངི༌ མིར༌གྱུད༌ མང༌པོ༌ གྱུར༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ ཚང༌མ༌ལ༌ ཁོང༌ངི༌ ཨབ༌ར༌ཧམ༌མ༌ སལ༌ཁན༌ནི༌ ཅིན༌ལབས༌པོ༌ སལ༌ཤིག༌, ཡང༌ ཁྱོ༌རང༌ ཞན༌ཡུལ༌ལི༌ མི༌ ཚུལ༌ལ༌ དུག༌ཁན༌ནི༌ ས༌ཀྱད༌ ཀ༌བོ༌ དཀོན༌མཆོག༌གི༌ ཨབ༌ར༌ཧམ༌མ༌ སལ༌ལ༌ ཛདས༌ ཏེ༌བོ༌ ཁྱོ༌རང༌ངི༌ གྱུར༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ཏེ༌ནེ༌ ཨི༌སཱག༌གི༌ ཡ༌ཀོབ༌ ལམ༌ཅུགས༌ ཡང༌ ཁོ༌ པ༌དན༌ཨ༌རམ༌མ༌ སོང༌ཏེ༌ ཨ༌རམ༌པ༌ བེ༌ཐུལ༌ལི༌ བུ༌ཚ༌ ར༌བེ༌ཀའེ༌ མིང༌བོ༌ ལ༌བན༌ ཉམ༌པོ༌ དུགས༌, ར༌བེ༌ཀ༌ ནི༌ ཨི༌སུ༌ དང༌ ཡ༌ཀོབ༌བི༌ ཨ༌མ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ཨི༌སཱག༌གི༌ ཡ༌ཀོབ༌བ༌ ཅིན༌ལབས༌ ཏང༌ཏེ༌ པ༌དན༌ཨ༌རམ༌མ༌ ན༌མ༌ ཙལ༌ལ༌ ལམ༌ཅུག༌ཁན༌ ཡང༌ ཀེ༌ནན༌མ༌ བུ༌མོ༌ ཉམ༌པོ༌ ན༌མ༌ མི༌ཅོ༌ཅེས༌ལ༌ ཁོའ༌ བཀའ༌ ཏང༌ཁན༌བོ༌ ཡང༌ ");
INSERT INTO lbj_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ དང༌ ཨ༌མའེ༌ ཁའ༌ ཉན༌ཏེ༌ པ༌དན༌ཨ༌རམ༌མ༌ ཆའ༌ཁན༌བོ༌ ཨི༌སུའ༌ གྱུས༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ཏེ༌ནེ༌ ཨི༌སུའ༌ ཁོའེ༌ ཨ༌བའ༌ ཀེ༌ནན༌མ༌ བུ༌མོའ༌ མ༌ ཐད༌ཁན༌བོ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ཁོའེ༌ སྔུན༌ནི༌ ན༌མ༌གུན༌ནི༌ཀ༌ ནན༌མ༌ ཨབ༌ར༌ཧམ༌མི༌ བུ༌ཚ༌ ཨིཤ༌མ༌ཨེལ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁོའེ༌ བུ༌མོ༌ མ༌ཧ༌ལད༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌ ཁོ༌ ནི༌བེ༌འོད༌དི༌ ནོ༌མོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ཡ༌ཀོབ༌ བེར༌ཤེ༌བའེ༌ གྲོང༌ཁྱེར༌ནེ༌ བིང༌ཏེ༌ ཧ༌རན༌ ཆོགས༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ཁོ༌ ས༌ཆ༌ཞིག༌གི༌ཀ༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ ཏེ༌རུ༌ ཚན༌བོ༌ དུག༌ཨིན༌ སམ༌ ཅིའ༌ཟེར༌ན༌ ཉི༌མ༌ སྐྱོད༌ཏེ༌ ཡོད༌པིན༌། ཏེ༌རུ༌ རྡོའ༌ཞིག༌ ཁོ༌རང༌ངི༌ གོའེ༌ ཡོག༌ག༌ བོར༌ཏེ༌ ཉིད༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ཁོའ༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌ ཀ༌བོའེ༌ ནང༌ང༌ ཁོའ༌ ཇིག༌རྟེན༌ནི༌ ཀ༌ནེ༌ ནམ༌ཁའ༌ ཚོག༌པ༌ སྲེས༌ཀ༌ཞིག༌ རྐྱངས༌ཏེ༌ ཐོང༌ ཡང༌ ཏེ༌བོའེ༌ཀ༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉ༌གུན༌ ཛགས༌བབས༌ ཏང༌ངད༌ པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","སྲེས༌ཀའེ༌ གོའེ༌ཀ༌ ཡ༌ཝ༌ ཞངས༌ཏེ༌ ཁོང༌ངི༌ མོལས༌, “ང༌ ནི༌ ཨབ༌ར༌ཧམ༌ དང༌ ཨི༌སཱག༌གི༌ དཀོན༌མཆོག༌ ཡ༌ཝ༌ ཨིན༌། ངའེ༌ ཁྱོ༌རང༌ ཉིད༌ལོགས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ས༌ཆ༌བོ༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ཁོང༌གུན༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཐལ༌བ༌ ཙོགས༌ལ༌ ཇིག༌རྟེན༌ནི༌ ཆོགས༌ ཚང༌མ༌ལ༌ ཁྱེད༌ཨིན༌ ཡང༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ གུན༌ གྱུད༌ཏེ༌ མི༌ཚང༌མ༌ལ༌ ཅིན༌ལབས༌ ཐོབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ངའ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌, ཀ༌རུ༌ ཆ༌ནའང༌ ངའེ༌ ཁྱོ༌རང༌ སྐྱོབས༌ཏེ༌ བོར༌ཨིན༌ ཡང༌ ངའེ༌ ཁྱོ༌རང༌ འིན༌ན༌ ས༌ཆའེ༌ཀ༌ ལོགས༌ཏེ༌ ཁྱོང༌ཨིན༌, ནམ༌ཚོག༌པ༌ ངའེ༌ ཁ༌ཆད༌ ཅོ༌ཁན༌ ཚང༌མ༌ གྲུབ༌ མི༌གྲུབ༌ ངའེ༌ ཁྱོ༌རང༌གུན༌ ཕང༌མི༌ཕང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ཡ༌ཀོབ༌བ༌ ཉིད༌ཚད༌ ཡང༌ ཁོའེ༌ སམ༌, “ཡ༌ཝ༌ འི༌ ནས༌སའེ༌ ནང༌ང༌ ནས༌ཏེ༌ ཨིན༌ནོག༌ ཡང༌ ངའ༌ དག༌ས༌ མ༌ནེ༌ གྱུས༌ མ༌སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ཁོ༌ ཇིགས༌ ཡང༌ ཟེརས༌, “འི༌ ནས༌ས༌བོ༌ ཙམ༌ཤིག༌གི༌ ཇིགས༌པོ༌ མ༌ནོག༌། ཏན༌ཏན༌ལ༌ འི༌བོ༌ དཀོན༌མཆོག༌གི༌ ཞུགས༌ཁང༌ ཡང༌ ནམ༌ཁའེ༌ གྱས༌སྒོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ཐོ༌རེ༌ཟུག༌པོ༌ ཡ༌ཀོབ༌ ང༌མོ༌ནེ༌ ལངས༌ཏེ༌ གོ༌ བོར༌ཁན༌ནི༌ རྡོའ༌བོ༌ ཁུརས༌ ཡང༌ ཏེ༌བོ༌ ཀ༌ཝ༌ ཙོགས༌ལ༌ ལངས༌ཏེ༌ ཏེ༌བོའེ༌ཀ༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ ལུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ཏེ༌ནེ༌ ཁོའེ༌ ཏེ༌ ནས༌ས༌བོའ༌ བེ༌ཐེལ༌ མིང༌ང༌ ཏགས༌ སྔུན༌ལ༌ ཏེ༌ གྱལ༌ས༌བོའ༌ ལུཟ༌ ཟེར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ནའ༌ ཁུརས༌, “ཀལ༌ཏེས༌ དཀོན༌མཆོག༌ ང༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ འི༌ བེས༌སི༌ ནང༌ང༌ ང༌ སྐྱོབ༌ཏེ༌ ངའ༌ ཁར༌ཇི༌ དང༌ ཀོས༌ལག༌ སལ༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ཡང༌ ང༌ ང༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པ༌ ལོགས༌ཏེ༌ ཁམ༌ཟང༌ ལེབ༌ན༌ ཏེ༌ནེ༌ ངའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝ༌ ཉེ༌རང༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ངའེ༌ འི༌ རྡོའ༌ ལངས༌ཁན༌ནི༌ ནས༌ས༌བོ༌ ཉེ༌རང༌ངི༌ ཞུགས༌ཁང༌ གྱུར༌ཨིན༌ ཡང༌ ཉེ༌རང༌ངི༌ སལ༌ཁན༌ ཚང༌མའེ༌ ནང༌ནེ༌ ངའེ༌ ཉེ༌རང༌ང༌ རྕུ༌ཁག༌པོ༌ ཕུལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ཡང༌སྐྱར༌ ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ བེས༌པོ༌ གོ༌ཟུགས༌ ཡང༌ ཁོ༌ ཀེ༌ནན༌ནི༌ ཤར༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ནི༌ ས༌ཆའ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ཁོའ༌ འ༌ཟམ༌ཤིག༌ནེ༌ ཆུ༌དོང༌ཞིག༌ ཐོང༌ ཀ༌བོའེ༌ དུན༌ལ༌ ལུག༌གི༌ ཁྱུ༌ སུམ༌ དུག༌པིན༌, ཅིའ༌ཟེར༌ན༌ ལུག༌གི༌ ཁྱུ༌གུན༌ལ༌ ཏེ༌ ཆུ༌དོང༌ནེ༌ ཆུ༌ ཏང༌ངད༌པིན༌། ཆུ༌དོང༌ངི༌ ཁའ༌བོའ༌ རྡོའ༌ ཆེན༌མོ༌ཞིག༌ ཀབས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ལུག༌ཁྱུ༌ ཚང༌མ༌ ཏེ༌ཀ༌ ཛོམ༌མ༌ཅིག༌ ལུག༌རྫི༌གུན༌ནི༌ ཏེ༌ རྡོའ༌བོ༌ རིལ༌ཏེ༌ ལུག༌གུན༌ལ༌ ཆུ༌ ཏང༌ངད༌པིན༌། ཆུ༌ ཏང༌ ཚར༌ར༌ཅིག༌ རྡོའ༌བོ༌ ལོགས༌ཏེ༌ ཁའེ༌ཀ༌ ཀབ༌བད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ཡ༌ཀོབ༌བི༌ ཏེ༌ཀ༌ ཡོད༌ཁན༌ནི༌ ལུག༌རྫི༌གུན༌ལ༌ ཏྲིས༌, “ཛ༌འོ༌ ཁྱོ༌ཞ༌གུན༌ ཀ༌ནེ༌ ཨིན༌?” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའ༌ ཧ༌རན༌ནེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ཁོའེ༌ ཏྲིས༌, “ཁྱོ༌ཞའེ༌ ན༌ཧོར༌རི༌ ཚ༌འོ༌ ལ༌བན༌ ཤེས༌ས༌ད༌?” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའེ༌ ཁོ༌ ཤེས༌སད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ཁོའེ༌ ཏྲིས༌, “ཁོང༌ ཁམ༌ཟང༌ དུག༌ག༌?” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཁོ༌ ཁམ༌ཟང༌ དུག༌, ལྟོས༌སའང༌ འ༌ནེ༌ ཁོའེ༌ བུ༌མོ༌ རེ༌ཅལ༌ ལུག༌ཁྱུ༌ ཉམ༌པོ༌ ཡོང༌ང༌ལ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ཟིགས༌སའང༌, ཏ༌རུང༌ ཉི༌མའེ༌ སྐྱིལ༌དུག༌, ལུག༌ ཁྱུ༌ ཚང༌མ༌ ཅིའ༌ ཛོམ༌ ཅུག༌གད༌? ཁྱོ༌ཞའེ༌ ལུག༌གུན༌ལ༌ ཆུ༌ ཏངས༌ཏེ༌ རྩ༌ཟའ༌ལ༌ ལོགས༌ཏེ༌ ཁྱེར༌ར༌ མེད༌ད༌?” ");
INSERT INTO lbj_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ཁོང༌གུན༌ནི༌ ཟེརས༌, “ལུག༌ཁྱུ༌ ཚང༌མ༌ ཛོམ༌ཏེ༌ མ༌ནེ༌ ང༌ཞའེ༌ རྡོའ༌བོ༌ རིལ༌ཏེ༌ ལུག༌གུན༌ལ༌ ཆུ༌ ཏང༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ཁོང༌གུན༌ ཉམ༌པོ༌ ཡ༌ཀོབ༌ སྤེ༌ར༌ ཏང༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ རེ༌ཅལ༌ལི༌ ཚོ༌ཨིན༌ ཡོད༌ཁན༌ ཁོའེ༌ ཨ༌བའེ༌ ལུག༌ཁྱུ༌ ཉམ༌པོ༌ ཏེ༌ཀ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ཡ༌ཀོབ༌བི༌ རེ༌ཅལ༌ ཁོའེ༌ ཨ༌ཞང༌ ལ༌བན༌ནི༌ ལུག༌ཁྱུ༌ ཉམ༌པོ༌ ཐོང༌ང༌ཅིག༌, ཁོ༌ ཆུ༌དོང༌ ཡོད༌ས༌ སོང༌ཏེ༌ རྡོའ༌བོ༌ རིལས༌ ཡང༌ ལུག༌གུན༌ལ༌ ཆུ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ཏེ༌ནེ༌ ཁོའེ༌ རེ༌ཅལ༌ལ༌ པུག༌ ཏངས༌ ཡང༌ སྲན༌ཏྲེ༌ ངུས༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ མང༌པོ༌ ཐད༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ཁོའེ༌ རེ༌ཅལ༌ལ༌ ཁོ༌ ཁོའེ༌ ཉེན༌, ཁོའེ༌ ཨ༌བའེ༌ སྲིང༌མོ༌ ར༌བེ༌ཀའེ༌ བུ༌ཚ༌ ཨིན༌ ཟེརས༌། རེ༌ཅལ༌ བང༌ཏངས༌ཏེ༌ སོང༌ ཡང༌ ཨ༌བ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ལ༌བན༌ལ༌ ཁོའེ༌ ཚ༌འོ༌ ཡ༌ཀོབ༌བི༌ སྐོར༌ལ༌ ཚོར༌ར༌ཅིག༌ ཁོ༌ བང༌ཏངས༌ཏེ༌ ཁོའ༌ ཐུག༌ག༌ལ༌ ཡོངས༌ ཡང༌ ཁྲིལ༌ཏེ༌ པུག༌ ཏངས༌། ཁོ༌ ཁྲིད༌ཏེ༌ ཁང༌པ༌ ཁྱེརས༌, ཏེ༌རུ༌ ཡ༌ཀོབ༌བི༌ ལ༌བན༌ལ༌ ཅི༌ཚང༌མ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ལ༌བན༌ནི༌ ཟེརས༌, “ཁྱོ༌རང༌ ངའེ༌ ཤ༌ཁྲག༌ ཨིན༌ནོག༌།” 29:14-30:24 ཡ༌ཀོབ༌ ཏེ༌རུ༌ དུགས༌ཏེ༌ ཟླ༌ཝ༌ ཅིག༌གི༌ སྟིང༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ལ༌བན༌ནི༌ ཡ༌ཀོབ༌བ༌ ཟེརས༌, “ཁྱོ༌རང༌ ངའེ༌ ཉེན༌གྲུང༌ ཨིན༌ཅེས༌པོའེ༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ ཕིའ༌ ཆོན༌ལ༌ ལས༌ ཅོ༌ མ༌གོས༌། ཟེར༌རའང༌ ཁྱོ༌རང༌ང༌ ལ༌ཆ༌ ཙམ༌ ཏང༌?” ");
INSERT INTO lbj_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ལ༌བན༌ལ༌ བུ༌མོ༌ ཉིས༌ ཡོད༌པིན༌, ཆེན༌མོ༌བོའ༌ ལི༌ཡ༌ ཡང༌ ཆུང༌ང༌བོའ༌ རེ༌ཅལ༌ ཟེར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ལི༌ཡའེ༌ མིག༌ མ༌ ལྡེ༌མོ༌ ཨིན༌ནའང༌ རེ༌ཅལ༌ལ༌ ཟུགས༌ ལྡེ༌མོ༌ དང༌ ཁོ༌ མ༌ཛེས༌མོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ཡ༌ཀོབ༌ རེ༌ཅལ༌ལ༌ ཐད༌པ༌ ཁོའེ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ང༌ རེ༌ཅལ༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོ༌ཅུག༌ན༌ ངའེ༌ ཉེ༌རང༌ངི༌ ཕིའ༌ ལོ༌ རྡུན༌ ལས༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ལ༌བན༌ནི༌ ལན༌ཏངས༌, “ཞན༌མ༌ཞིག༌གི༌ སང༌ ངའེ༌ ཁོ༌ ཁྱོ༌རང༌ང༌ ཏང༌ན༌ གྱལ༌, འི༌རུ༌ ང༌ ཉམ༌པོ༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","རེ༌ཅལ༌ ཐོབ༌ཅེས༌ལ༌ ཡ༌ཀོབ༌བི༌ ལོ༌ རྡུན༌ ལ༌བན༌ནི༌ ཕིའ༌ ལས༌ ཅོས༌, ཡང༌ རེ༌ཅལ༌ལ༌ ཐད༌ཅེས༌པའེ༌ ཁོའ༌ ཏེ༌ ཏུས༌པོ༌ ཞག༌པོ༌ ཁ༌ཅིག༌ ཙོགས༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ལ༌བན༌ལ༌ ཟེརས༌, “ཏུས༌པོ༌ ཚངས༌། ཏ༌ ང༌ ཉེ༌རང༌ངི༌ བུ༌མོ༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌ཏེ༌ ཁོ༌ ཉམ༌པོ༌ དུག༌ཅེས༌ལ༌ སལ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ཏེ༌ནེ༌ ལ༌བན༌ནི༌ ཁྱིམ༌ཚེས༌ ཚང༌མ༌ལ༌ བོད༌ཏེ༌ བག༌སྟོན༌ནི༌ གྲོན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ཨིན༌ནའང༌ ཏེ༌ ཚན༌ལ༌ ལ༌བན༌ནི༌ ཁོའེ༌ བུ༌མོ༌ ལི༌ཡ༌ ཡ༌ཀོབ༌བ༌ ཏངས༌ ཡང༌ ཁོ༌ ཉམ༌པོ༌ ཡ༌ཀོབ༌བི༌ ལུས༌བྲེལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ལ༌བན༌ནི༌ ཁོ༌རང༌ངི༌ ཡོག༌མོ༌ ཟིལ༌པཧ༌, ཁོའེ༌ བུ༌མོ༌ ལི༌ཡ༌ ཡ༌ཏོ༌ ཚུལ༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ང༌མོ༌ ཆའ༌ཅིག༌ ཡ༌ཀོབ༌བ༌ ལི༌ཡ༌ ཨིན༌ཁན༌བོ༌ ཤེས༌པ༌ ཁོའེ༌ ལ༌བན༌ལ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ འི༌བོ༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ངའེ༌ རེ༌ཅལ༌ལི༌ ཕིའ༌ ལས༌ ཅོས༌པིན༌, ཅི༌ཕིའ༌ ཉེ༌རང༌ངི༌ ངའ༌ གོབ༌སྐོར༌ཏེ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ལ༌བན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའེ༌ ཡུལ༌ལི༌ ལུག༌སྲོལ༌ ནང༌ཞིན༌ བུ༌མོ༌ ཆུ༌ངུན༌བོ༌ ཆེན༌མོའེ༌སང༌ སྔུན༌ལ༌ ན༌མ༌ ཏང༌ང༌ མ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","འི༌ གའ༌སྟོན༌ནི༌ རྡུན༌ཞག༌པོ༌ ཚར༌ཅུག༌ ཏེ༌ནེ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ རེ༌ཅལ༌ལའང༌ ཏང༌ཨིན༌, ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ ཕིའ༌ ཡང༌ ལོ༌ རྡུན༌ ལས༌ ཅོ༌ན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ཡ༌ཀོབ༌བི༌ ཁའ༌ ཆམས༌ཏེ༌ གའ༌སྟོན༌ནི༌ རྡུན༌ཞག༌པོ༌ ཚར༌ཅུགས༌ ཏེ༌ནེ༌ ལ༌བན༌ནི༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌ རེ༌ཅལ༌ ཁོའ༌ ན༌མའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ལ༌བན༌ནི༌ ཁོ༌རང༌ངི༌ ཡོག༌མོ༌ བིལ༌ལཧ༌ ཁོའེ༌ བུ༌མོ༌ རེ༌ཅལ༌ལ༌ ཡ༌ཏོ༌ ཚུལ༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ཡ༌ཀོབ༌བི༌ རེ༌ཅལ༌ ཉམ༌པོའང༌ ལུས༌བྲེལ༌ ཅོས༌ ཡང༌ ཁོའེ༌ ཁོའ༌ ལི༌ཡ༌ སང༌ མང༌ང༌ ཡ༌ཤ༌ ཅོའད༌པིན༌། ཁོའེ༌ ལ༌བན༌ནི༌ ཕིའ༌ ཡང༌ ལོ༌ རྡུན༌ ལས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ཡ༌ཝའེ༌ ཡ༌ཀོབ༌བི༌ ལི༌ཡ༌ ཡ༌ཤ༌ མི༌ཅོ༌ཅེས༌པོ༌ ཟིགས༌ཏེ༌ ཁོང༌ངི༌ ཁོའ༌ ཕྲུ༌གུ༌ ཇོར༌ ཅུག༌ག༌ ཛདས༌ ཨིན༌ནའང༌ རེ༌ཅལ༌ལ༌ ཕྲུ༌གུ༌ མ༌ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ལི༌ཡ༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ ཡང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌། ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ རུ༌བེན༌ ཏགས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཟེརས༌, “ཡ༌ཝའེ༌ ངའེ༌ རྡུག༌ངལ༌བོ༌ ཟིགས༌, ཏན༌ཏན༌ ཏ༌ ངའེ༌ མག༌པའེ༌ ངའ༌ ཡ༌ཤ༌ ཅོའ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ཁོ༌ ཡང༌སྐྱར༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ ཡང༌ ཁོའེ༌ ཟེརས༌, “ང༌ ཡ༌ཤ༌ མ༌ཅོ༌ཁན༌བོ༌ ཡ༌ཝའེ༌ སན༌ཏེ༌ ངའ༌ འི༌ བུ༌ཚ༌བོའང༌ སལས༌།” ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ སི༌མི༌འོན༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ཡང༌སྐྱར༌ ཁོ༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ ཁོའ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌། ཁོའེ༌ ཟེརས༌, “ཏ༌ ང༌ དང༌ ངའེ༌ མག༌པའེ༌ སེམས༌ ཉེ༌མོ༌ གྱུར༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁོའ༌ བུ༌ཚ༌ སུམ༌ སྐྱེ༌ཅུགས༌ཏེ༌ ཨིན༌ནོག༌།” ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ ལི༌ཝི༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ཏེ༌ནེ༌ ཁོ༌ ཡང༌སྐྱར༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ ཡང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ ཡང༌ ཁོའེ༌ ཟེརས༌, “འི༌རེས༌ལ༌ ངའེ༌ ཡ༌ཝའ༌ སྟོད༌པ༌ ཕུལ༌ཨིན༌།” ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ ཡ༌ཧུ༌དཱ༌ ཏགས༌། ཏེ༌སྟིང༌ནེ༌ ཁོའ༌ ཕྲུ༌གུ༌ མ༌ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ཨིན༌ནའང༌ རེ༌ཅལ༌ལ༌ ཡ༌ཀོབ༌བི༌ ཕིའ༌ ཕྲུ༌གུ༌ ཅིག༌གའང༌ ཇོར༌ མ༌ཉན༌པ༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅེ༌ཀ༌ ཚིག༌ཅེས༌ ཡོངས༌ ཡང༌ ཡ༌ཀོབ༌བ༌ ཟེརས༌, “ངའ༌ ཕྲུ༌གུ༌ ཏོང༌ ཏེ༌ མ༌ནེ༌ ང༌ ཤི༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ཡ༌ཀོབ༌བ༌ རེ༌ཅལ༌ལི༌ཀ༌ སྲོ༌ ཡོངས༌ཏེ༌ ཟེརས༌, “ཅི༌ ང༌ དཀོན༌མཆོག༌ ཨིན༌ནོག༌ག༌? ཁོང༌ངི༌ ཁྱོ༌རང༌ང༌ ཕྲུ༌གུ༌ ཇོར༌ མ༌ཅུག༌ག༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","རེ༌ཅལ༌ལི༌ ཟེརས༌, “ངའེ༌ ཡོག༌མོ༌ བིལ༌ལཧ༌ ཉམ༌པོ༌ ཁྱོ༌རང༌ དུགས༌ཏེ༌ ངའེ༌ ཕིའ༌ ཕྲུ༌གུ༌ ཇོར༌ཅུག༌ ཡང༌ ཁོ༌ གྱུད༌ཏེ༌ ངའ༌ ཕྲུ༌གུ༌གུན༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ཏེ༌ནེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཡ༌ཏོ༌ བིལ༌ལཧ༌ ཁོ༌རང༌ངི༌ མག༌པའ༌ ན༌མའེ༌ ཚུལ༌ལ༌ ཏངས༌ ཡང༌ ཁོའེ༌ ཁོ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ཁོ༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ ཡ༌ཀོབ༌བི༌ ཕིའ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","རེ༌ཅལ༌ལི༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ངའ༌ ཏམ༌ངན༌ནེ༌ ཕིང༌ང༌ ཛདས༌། ཁོང༌ངི༌ ངའེ༌ མོས༌ལམ༌བོ༌ སན༌ན༌ ཛད༌ཏེ༌ ང༌ བུ༌ཚ༌ཞིག༌ སལས༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ གྲེན༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","རེ༌ཅལ༌ལི༌ ཡ༌ཏོ༌ བིལ༌ལཧ༌ ཡང༌སྐྱར༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ ཡ༌ཀོབ༌བི༌ ཕིའ༌ བུ༌ཚ༌ ཉིས༌པ༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","རེ༌ཅལ༌ལི༌ ཟེརས༌, “ང༌ ང༌རང༌ངི༌ ཨ༌ཅེ༌ ཉམ༌པོ༌ སྲན༌ཏྲེ༌ ནོལ༌ གོས༌ ཨིན༌ནའང༌ ང༌ གྱལ༌ཁའ༌ ཐོབ༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ ནཕ༌ཐལ༌ལི༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ལི༌ཡ༌ ཕྲུ༌གུ༌ མི༌སྐྱེ༌ཅེས༌པོ༌ ཧ༌གོའ༌ཅིག༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཡ༌ཏོ༌ ཟིལ༌པཧ༌ ཡ༌ཀོབ༌བ༌ ན༌མའེ༌ ཚུལ༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ཏེ༌ནེ༌ ཟིལ༌པཧ༌ ཡ༌ཀོབ༌བི༌ ཕིའ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ལི༌ཡའེ༌ ཟེརས༌, “ང༌ སོ༌དེ༌ཅན༌ ཨིན༌ནོག༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ གཱད༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ལི༌ཡའེ༌ ཡ༌ཏོ༌ ཟིལ༌པཧ༌, ཡ༌ཀོབ༌བི༌ ཕིའ༌ ཡང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ཏེ༌ནེ༌ ལི༌ཡའེ༌ ཟེརས༌, “ང༌ མ༌ཐད༌པོ༌ རག༌། ཏ༌ བུ༌མོ༌གུན༌ནི༌ ངའ༌ སྐྱིད༌པོ༌ ཟེར༌ཨིན༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ ཨ༌ཤེར༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ཀྲོའེ༌ རྔབ༌སའེ༌ ཏུས༌ལ༌ རུ༌བེན༌ ཞིང༌ང༌ སོང༌ ཡང༌ ཁོའ༌ མེན༌གྲེགས༌ ཟེར༌ཁན༌ནི༌ རྩཱ༌ ༼ཀ༌བོའེ༌ བུ༌མོ༌གུན༌ལ༌ ཕྲུ༌གུ༌ སྐྱེ༌ཅེས༌སི༌ ནང༌ང༌ རོགས༌ ཅོའ༌ནོག༌༽ ཐོབ༌པ༌ ཁོའེ༌ ཏེ༌བོ༌ ཁོ༌རང༌ངི༌ ཨ༌མ༌ ལི༌ཡ༌ ཕིའ༌ ཁྱོངས༌། རེ༌ཅལ༌ལི༌ ལི༌ཡ༌ ཟེརས༌, “ཇུ༌ཇུ༌ ངའ༌ ཉེ༌རང༌ངི༌ བུ༌ཚའེ༌ ཁྱོངས༌ཁན༌ནི༌ མེན༌གྲེགས༌ ཙ༌པིག༌ སལ༌ལའང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ཨིན༌ནའང༌ ལི༌ཡའེ༌ ཟེརས༌, “ངའེ༌ མག༌པ༌ ཁྱེར༌ཏེ༌ ཁྱོ༌རང༌ མ༌ཚིམས༌ས༌? ཏ༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ བུ༌ཚའེ༌ ཁྱོངས༌ཁན༌ནི༌ མེན༌གྲེགས༌པོའང༌ ཁྱེར༌ཨིན༌ན༌།” རེ༌ཅལ༌ལི༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ངའ༌ མེན༌གྲེགས༌ ཏང༌ན༌ ཁྱོ༌རང༌ དི༌རིང༌ ཚན༌ལ༌ ཡ༌ཀོབ༌ ཉམ༌པོ༌ དུག༌ ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ཕི༌ཏོག༌ ཡ༌ཀོབ༌ ཞིང༌ནེ༌ ཡོང༌ང༌ཅིག༌ ལི༌ཡ༌ ཁོའ༌ ཐུག༌ག༌ལ༌ ཕི༌ལོག༌ག༌ སོང༌ཏེ༌ ཟེརས༌, “དི༌རིང༌ ཉེ༌རང༌ ང༌ ཉམ༌པོ༌ དུག༌གོས༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ བུ༌ཚའེ༌ ཁྱོངས༌ཁན༌ནི༌ མེན༌གྲེགས༌ རེ༌ཅལ༌ལ༌ ཏངས༌ཏེ༌ ངའེ༌ ཉེ༌རང༌ངི༌ ཕིའ༌ རིན༌ ཤལ༌ཏེ༌ ཨིན༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོ༌ ཏེ༌ ཚན༌ལ༌ ལི༌ཡ༌ ཉམ༌པོ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","དཀོན༌མཆོག༌གི༌ ལི༌ཡའེ༌ མོས༌ལམ༌མ༌ ལན༌སལས༌ ཡང༌ ཁོ༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ ཡ༌ཀོབ༌བ༌ བུ༌ཚ༌ ལྔ༌པ༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ལི༌ཡའེ༌ ཟེརས༌, “ངའེ༌ ང༌རང༌ངི༌ ཡ༌ཏོ༌ ང༌རང༌ངི༌ མག༌པ༌ ན༌མའེ༌ ཚུལ༌ལ༌ ཏངས༌པ༌ དཀོན༌མཆོག༌གི༌ ངའ༌ སོལ༌རས༌ སལ༌ལ༌ ཛདས༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ མིང༌ང༌ ཨིས༌ས༌ཁར༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ལི༌ཡ༌ ཡང༌སྐྱར༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ ཡང༌ ཡ༌ཀོབ༌བི༌ ཕིའ༌ བུ༌ཚ༌ དྲུག༌པ༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ཁོའེ༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ངའ༌ སོལ༌རས༌ གྱལ༌ལ༌ཞིག༌ སལ༌ལ༌ ཛདས༌། ཏ༌ ངའེ༌ མག༌པའེ༌ ང༌ རྩི༌ཝ༌ ཅོའ༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁོའ༌ བུ༌ཚ༌ དྲུག༌ ཇོར༌ ཅུགས༌ཏེ༌ ཨིན༌ནོག༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ ཟེ༌བུ༌ལོན༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ཏེ༌སྟིང༌ནེ༌ ཁོའ༌ བུ༌མོ༌ཞིག༌ སྐྱེས༌ ཡང༌ ཁོའེ༌ མིང༌ང༌ དི༌ནཱ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ རེ༌ཅལ༌ལ༌ སྣང༌ང༌ སལ༌ཏེ༌ ཁོའ༌ ཕྲུ༌གུ༌ ཇོར༌ ཅུག༌ག༌ ཛདས༌ ");
INSERT INTO lbj_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ཁོ༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ ཡང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ཏེ༌ ཁོའེ༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ངའ༌ བུ༌ཚ༌ཞིག༌ སལ༌ཏེ༌ ངའ༌ ཕོག༌ཁན༌ནི༌ ཁྲེལ༌བ༌ མེད༌ཁན༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ མིང༌ང༌ ཡོ༌སེབ༌ ཏགས༌ ཡང༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ངའ༌ ཡང༌ བུ༌ཚ༌ཞིག༌ སལ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ཡོ༌སེབ༌ སྐྱེས༌ཏེ༌ སྟིང༌ནེ༌ ཡ༌ཀོབ༌བི༌ ལ༌བན༌ལ༌ ཟེརས༌, “ང༌ ང༌རང༌ངི༌ ཁང༌པ༌ ལོགས༌ཏེ༌ ཆ༌ཉན༌ཅེས༌སི༌ ཕིའ༌ ངའ༌ ལམ༌ཅུག༌ག༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ཉེ༌རང༌ངི༌ ཕིའ༌ ལས༌ ཅོས༌ཏེ༌ ཐོབ༌ཁན༌ནི༌ ངའེ༌ ན༌མ༌ དང༌ ཕྲུ༌གུ༌ གུན༌ ངའ༌ སལ༌ ཏེ༌ནེ༌ ང༌ ཆེན༌། ངའེ༌ ཉེ༌རང༌ང༌ གྱལ༌ལ༌ ཞབས༌ཏོག༌ ཞུས༌ཁན༌བོ༌ ཉེ༌རང༌ང༌ གྱུས༌ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ལ༌བན༌ནི༌ ཁོའ༌ ཟེརས༌, “ངའ༌ འི༌བོ༌ ཟེར༌ཅུག༌, སེམ༌ཉིད༌གུན༌ གྱུད༌ཏེ༌ ང༌ གྱུས༌ སོང༌ ཁྱོ༌རང༌ངི༌ ཞས༌ཏེ༌ ཡ༌ཝའེ༌ ངའ༌ ཅིན༌ལབས༌ སལ༌ལ༌ ཛདས༌, ཇུ༌ཇུ༌ འི༌རུ༌ ང༌ ཉམ༌པོ༌ ཞུགས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ཁོའེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌ནི༌ ལ༌ཆ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ ཕིའ༌ ལས༌ ཅོས༌ཏེ༌ ངའེ༌ སྟ༌སྟོག༌གི༌ ནང༌ང༌ ཉེ༌རང༌ངི༌ སེམས༌ཅན༌ མང༌པོ༌ ཕེལ༌ཁན༌བོ༌ ཉེ༌རང༌ང༌ གྱུས༌ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ངའ༌ ཡོང༌ངི༌ སང༌ སྔུན༌ལ༌ ཉེ༌རང༌ང༌ ཉུ༌ངུན༌ ཡོད༌ཁན༌བོ༌ མང༌པོ༌ ཕེལ༌ཏེ༌ ཡ༌ཝའེ༌ ངའེ༌ ལས༌ ཅོ༌ཁན༌ ཚང༌མའེ༌ ནང༌ང༌ ཉེ༌རང༌ང༌ ཅིན༌ལབས༌ སལས༌། ཏ༌ ངའེ༌ ང༌རང༌ངི༌ ནང༌ཚངས༌སི༌ ཕིའང༌ ལས༌ ཅོ༌ཅེས༌སི༌ ཏུས༌པོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ལ༌བན༌ནི༌ ཟེརས༌, “ངའེ༌ ཁྱོ༌རང༌ང༌ ཙམ༌ཤིག༌ ཏང༌གོས༌?” ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “ངའ༌ ཅའང༌ མ༌ ཏང༌ནའང༌ གྲིག༌། ཀལ༌ཏེས༌ ཉེ༌རང༌ངི༌ འི༌བོ༌ ཅོ༌ན༌ ངའེ༌ ཏ༌རུང༌ངའང༌ ཉེ༌རང༌ངི༌ ཁྱུ༌ ཚང༌མ༌ སྟ༌སྟོག༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","དི༌རིང༌ ང༌ ཉེ༌རང༌ངི༌ ཁྱུ༌ ཚང༌མའེ༌ ནང༌ང༌ སོང༌ཏེ༌ ལུ༌གུ༌ ནག༌པོ༌, ལུག༌ དང༌ ར༌མ༌ ནག༌ཐིག༌ དང༌ ཁྲ༌འོ༌ ཚང༌མ༌ ཕེས༌ཏེ༌ ཁྱེར༌ཨིན༌། ཏེ༌གུན༌ ངའེ༌ ལ༌ཆ༌བོ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ཉེ༌རང༌ སྐྱོད༌ཏེ༌ ངའ༌ ལ༌ཆ༌ ཐོབ༌ཁན༌གུན༌ལ༌ ལྟའ༌ཅིག༌ ང༌ ཀྲང༌པོ༌ ཨིན༌ན༌ མན༌ ཉེ༌རང༌ང༌ གྱུས༌ ཆ༌ཉན༌ཅེས༌ ཨིན༌ནོག༌། ཀལ༌ཏེས༌ ངའེ༌ ཁྱུའི༌ ཕྲོའ༌ ཉེ༌རང༌ང༌ ར༌མ༌ ཁྲ༌འོ༌ ཡ༌ ནག༌ཐིག༌ མན༌ཁན༌ ཡ༌ ལུག༌ ནག༌པོ༌ མན༌ཁན༌ ཐོང༌ན༌ ཏེ༌གུན༌ ངའེ༌ རྐུས༌ཏེ༌ ཨིན༌ཁན༌ ཉེ༌རང༌ང༌ གྱུས༌ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ལ༌བན༌ནི༌ ལན༌ཏངས༌, “ཁྲིག༌རག༌, ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌བོ༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ཨིན༌ནའང༌ ཏེ༌ ཞག༌ག༌ ལ༌བན༌ནི༌ ར༌མ༌ དང༌ ར༌བོ༌ ནག༌ཐིག༌ དང༌ ཁྲ༌འོ༌ ཚང༌མ༌ ཡང༌ ལུ༌གུ༌ ནག༌པོ༌ ཚང༌མའང༌ ཁྱུའི༌ ཕྲོ༌ནེ༌ ཕེས༌ཏེ༌ ཐེནས༌ ཡང༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ ཏེ༌གུན༌ནི༌ སྟ༌སྟོག༌ ཅོའ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ཏེ༌ནེ༌ ཁོའེ༌ ཏེ༌ ཁྱུ༌བོ༌ ཞག༌མ༌ སུམ༌ གྲུལ༌ཏེ༌ ལེབ༌ཅེས༌ ཟམ༌ཤིག༌ ཐག༌རིང༌ངི༌ ནས༌ས༌ ཞིག༌ག༌ ཁྱེརས༌། ཡ༌ཀོབ༌བི༌ ལ༌བན༌ནི༌ ལུས༌ཁན༌ནི༌ ཁྱུ༌བོའེ༌ སྟ༌སྟོག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ཡ༌ཀོབ༌བི༌ ཡར༌པ༌, བ༌དམ༌ དང༌ ཞན༌ ལྕང༌མ༌ གུན༌ནི༌ ཡལ༌ག༌ ཅདས༌ ཡང༌ པར༌པར༌ནེ༌ པགས༌པ༌ ཀོགས༌ཏེ༌ ཏེ༌གུན༌ ཁྲ༌འོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ཁོའེ༌ ཏེ༌ ཡལ༌ག༌ ཚང༌མ༌ ར༌ལུག༌གུན༌ ཆུ༌ཐུང༌སའེ༌ ཞོང༌པའེ༌ དུན༌ལ༌ ཁྱུ༌ ཕྲོའ༌ བོརས༌, ཅིའ༌ཟེར༌ན༌ སེམས༌ཅན༌གུན༌ ཆུ༌ ཐུང༌ ཟ༌ནེ༌ ཛོམས༌ཏེ༌ གྱུད༌སྤེལ༌ ཅོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ཏེ༌ནེ༌ ཏེ༌ཀ༌ ཛོམ༌ཁན༌ནི༌ ར༌ལུག༌གུན༌ལ༌ སྐྱེ༌ཁན༌ནི༌ རི༌གུ༌ དང༌ ལུ༌གུ༌གུན༌ ཁྲ༌འོ༌ ཡ༌ ནག༌ཐིག༌ ཅན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ཡ༌ཀོབ༌བི༌ ཏེ༌ ལུ༌གུ༌གུན༌ སོ༌སོའ༌ ཕེས༌ ཡང༌ ལུས༌ཁན༌ནི༌ ལུག༌གུན༌ ལ༌བན༌ནི༌ ཁྱུ༌ ནག༌པོ༌ དང༌ ཁྲ༌འོ༌ སེམས༌ཅན༌གུན༌ནི༌ ཆོགས༌ལ༌ ལྟ༌ ཅུགས༌ཏེ༌ བོརས༌། འིན༌ན༌ཟུག༌གི༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཕིའ༌ ར༌ལུག༌གི༌ ཁྱུ༌ སོ༌སོ༌ ཅོས༌ ཡང༌ ཏེ༌གུན༌ ལ༌བན༌ནི༌ ཁྱུ༌གུན༌ ཉམ༌པོ༌ སྲེ༌ མ༌སྲེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","མོ༌ ལུག༌ ཤེད༌ཅན༌ ཚང༌མ༌ གྱུད༌སྤེལ༌ལི༌ ཕིའ༌ གྲལ༌གྲིག༌ ཡོད༌ ཟ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཡལ༌ག༌ ཚང༌མ༌ ཏེ༌གུན༌ནི༌ མིག༌ནེ༌ ཐོང༌སའེ༌ ཆུའི༌ ཞོང༌པའེ༌ དུན༌ལ༌ བོརས༌ ཀ༌རུ༌ གྱུད༌སྤེལ༌ལི༌ ཕིའ༌ པོ༌ དང༌ མོ༌ ཛོམ༌མད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ཨིན༌ནའང༌ ཁོའེ༌ ཁྱུ༌ འུ༌ཐུགས༌གུན༌ནི༌ དུན༌ལ༌ ཡལ༌ག༌ མ༌བོརས༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ ལ༌བན༌ལ༌ ར༌ལུག༌གི༌ ཁྱུ༌ འུ༌ཐུགས༌ ཚང༌མ༌ ཐོབ༌ ཡང༌ ཡ༌ཀོབ༌བ༌ ཤེད༌ཅན༌ ཚང༌མ༌། ");
INSERT INTO lbj_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","འིན༌ན༌ཟུག༌གི༌ ཡ༌ཀོབ༌ མའ༌ ཆུག༌པོ༌ གྱུར༌། ཁོའ༌ ར༌ལུག༌གི༌ ཁྱུ༌, རྔ༌བོང༌ དང༌ བུང༌བུ༌ མང༌པོ༌ ཡང༌ ཡོག༌པོའང༌ མང༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ཡ༌ཀོབ༌བ༌ ལ༌བན༌ནི༌ བུ༌ཚ༌གུན༌ནི༌, “ཡ༌ཀོབ༌བི༌ ང༌དང༌ངི༌ ཨ༌བའེ༌ ཨིན༌ཁན༌ ཚང༌མ༌ ཁྱེར༌ཏེ༌ ཨིན༌ནོག༌, ཡང༌ ང༌དང༌ངི༌ ཨ༌བའེ༌ ཞས༌ཏེ༌ ཁོའ༌ གྱུ༌ནོར༌ མང༌པོ༌ ཇོར༌ཏེ༌ ཨིན༌ནོག༌” ཟེར༌ཨིན༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ཡང༌ ལ༌བན༌ནི༌ ལྟ༌ཝ༌ ཁོའེ༌ ཆོགས༌ལ༌ སྔུན༌མ༌ ཙོགས༌ མེད༌ཁན༌བོ༌ ཡ༌ཀོབ༌བ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཡ༌ཀོབ༌བ༌ མོལས༌, “ཁྱོ༌རང༌ ཁྱོ༌རང༌ངི༌ ཕ༌མེས༌པོ༌ དང༌ ཉེན༌གྲུང༌ གུན༌ ཡོད༌སའེ༌ ས༌ཆ༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཡ༌ཀོབ༌བི༌ རེ༌ཅལ༌ དང༌ ལི༌ཡ༌, ཁོའེ༌ སེམས༌ཅན༌ནི༌ ཁྱུ༌ ཡོད༌སའེ༌ ཞིང༌ངི༌ཀ༌ ཡོང༌ཅེས༌ལ༌ ལོན༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ ཨ༌བའེ༌ ལྟ༌ཝ༌ ངའེ༌ ཕིའ༌ གྱུར༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ངའ༌ ཐོང༌དུག༌, ཨིན༌ནའང༌ ངའེ༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌ ང༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ཁྱོ༌ཞའེ༌ ཨ༌བའེ༌ ཕིའ༌ ངའེ༌ རྩོན༌གྲུས༌ ཉམ༌པོ༌ ལས༌ ཅོས༌ཁན༌བོ༌ ཁྱོ༌ཞའ༌ གྱུས༌ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ཁོའེ༌ ངའེ༌ ལ༌ཆའེ༌ ནང༌ང༌ ལན༌ རྕུ༌ གྱུར༌ཇ༌ ཁྱོངས༌ཏེ༌ ངའ༌ གོབ༌སྐོར༌ ཏངས༌། ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ཁོའ༌, ངའ༌ ནོད༌སྐྱལ༌ ཅུག༌ག༌ མ༌ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ལ༌བན༌ནི༌ ར༌ལུག༌ ཁྲ༌འོ༌ ཚང༌མ༌ ཁྱོ༌རང༌ངི༌ ལ༌ཆ༌ ཨིན༌ ཟེར༌ར༌ཅིག༌, ཏེ༌གུན༌ལ༌ ལུ༌གུ༌ དང༌ རི༌གུ༌ གུན༌ ཁྲ༌འོ༌ སྐྱེས༌, ཡང༌ ཁོའེ༌ ནག༌ཐིག༌ཅན༌ ཚང༌མ༌ ཁྱོ༌རང༌ངི༌ ལ༌ཆ༌ ཨིན༌ ཟེར༌ར༌ཅིག༌, ཏེ༌གུན༌ལ༌ ལུ༌གུ༌ དང༌ རི༌གུ༌ གུན༌ ནག༌ཐིག༌ཅན༌ སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞའེ༌ ཨ༌བའེ༌ ཀ༌ནེ༌ སེམས༌ཅན༌གུན༌ ཁྱེར༌ར༌ ཛད༌ཏེ༌ ངའ༌ སལ༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ཁྱུའི༌ གྱུད༌སྤེལ༌ལི༌ ཏུས༌ ངའ༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌ ཡང༌ ཏེ༌ནང༌ང༌ ར༌མ༌ ཉམ༌པོ༌ གྱུད༌སྤེལ༌ ཅོ༌ཁན༌ནི༌ ར༌བོ༌ གུན༌ ཁྲ༌འོ༌ དང༌ ནག༌ཐིག༌ཅན༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ཏེ༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉའེ༌ ངའ༌ མོལས༌, ‘ཡ༌ཀོབ༌’ ངའེ༌ ཟེར༌པིན༌, ‘ངའ༌ འི༌ཀ༌ནེ༌ ཡོད༌ལེ༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ཁོང༌ངི༌ མོལས༌, ‘ལྟོས༌, ཁྱོ༌རང༌ངི༌ ར༌མ༌གུན༌ ཉམ༌པོ༌ གྱུད༌སྤེལ༌ ཅོ༌ཁན༌ནི༌ ར༌བོ༌ ཚང༌མ༌, ཁྲ༌འོ༌ དང༌ ནག༌ཐིག༌ཅན༌ དུག༌, ཅིའ༌ཟེར༌ན༌ ལ༌བན༌ནི༌ ཁྱོ༌རང༌ང༌ ཅོ༌ཁན༌ ཚང༌མ༌ ངའེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ང༌ ཁྱོ༌རང༌ང༌ བེ༌ཐེལ༌ལི༌ ནང༌ང༌ ཐོང༌ཁན༌ནི༌ ཏེན༌ན༌ དཀོན༌མཆོག༌པོ༌ ཨིན༌, ཀ༌རུ༌ ཁྱོ༌རང༌ངི༌ རྡོའ༌ ལངས༌ཏེ༌ ཏེ༌ཀ༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ ལུགས༌ཏེ༌ ནའ༌ ཁུར༌ཏེ༌ ཨིན༌པིན༌། ཏ༌ དག༌ས༌རང༌ འི༌ ས༌ཆའ༌ ཕངས༌ཏེ༌ ཁྱོ༌རང༌ སྐྱེས༌སའེ༌ ནས༌ས༌ ལོགས༌ཏེ༌ སོང༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","རེ༌ཅལ༌ དང༌ ལི༌ཡའེ༌ ཡ༌ཀོབ༌བ༌ ལན༌ཏངས༌, “ཨ༌བའེ༌ ཀ༌ནེ༌ ང༌ཞའ༌ ཅའང༌ ནོར༌སྐལ༌ ཐོབ༌ཅེས༌ མེད༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ཁོང༌ངི༌ ང༌ཞ༌གུན༌ལ༌ ཞན༌མ༌ ཙོགས༌ལ༌ མ༌ཐེས༌ས༌? ཁོང༌ངི༌ ང༌ཞའ༌ ཙོངས༌ ཡང༌ ང༌ཞའེ༌ ཕིའ༌ ཏང༌ཁན༌ནི༌ པེ༌ནེ༌ ཚང༌མ༌ སྐྱགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","དཀོན༌མཆོག༌གི༌ ང༌ཞའེ༌ ཨ༌བའེ༌ ཀ༌ནེ༌ ཁྱེར༌ར༌ ཛད༌ཁན༌ནི༌ གྱུ༌ནོར༌ ཚང༌མ༌ ང༌ཞའ༌ དང༌ ང༌ཞའེ༌ ཕྲུ༌གུ༌གུན༌ནི༌ ཨིན༌ནོག༌། དཀོན༌མཆོག༌གི༌ ཉེ༌རང༌ང༌ ཅོས༌ མོལ༌ཁན༌བོ༌ ཅོས༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ ཕྲུ༌གུ༌གུན༌ དང༌ ན༌མ༌གུན༌ རྔ༌བོང༌གུན༌ནི༌ཀ༌ སྐྱོནས༌, ");
INSERT INTO lbj_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ཡང༌ ཁྱུ༌ ཚང༌མ༌ ཁོ༌རང༌ངི༌ སང༌ སྔུན༌ལ༌ སྲུལ༌ཨིན༌ ཁྱེརས༌, ཏེ༌གུན༌ མ༌ཚད༌ ཁོའ༌ པ༌དན༌ཨ༌རམ༌མི༌ ནང༌ང༌ ཇོར༌ཁན༌ ཞན༌ ནོར༌ ཚང༌མའང༌ ཁུར༌ཏེ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཨི༌སཱག༌ ཡོད༌སའེ༌ ནས༌ས༌ ཀེ༌ནན༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ཡ༌ཀོབ༌ ཉམ༌པོ༌ ཆའེ༌སང༌ སྔུན༌ལ༌, ལ༌བན༌ ཁོ༌རང༌ངི༌ ལུག༌གུན༌ནི༌ བལ༌ བྲག༌ག༌ ཆའ༌ཅིག༌ རེ༌ཅལ༌ལི༌ ཨ༌བའེ༌ ཁང༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ སྐུན༌དྲ༌གུན༌ རྐུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ཡ༌ཀོབ༌བི༌ ཨ༌རམ༌པ༌ ལ༌བན༌ལ༌ ཁོ༌ ཆའད༌ ཟེར༌ཏེ༌ མ༌ཤད༌ད༌ ཁོའ༌ གོབ༌སྐོར༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ཁོའེ༌ ཁོ༌རང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁུར༌ཏེ༌ གྱོགས༌པ༌ ཡུཕ༌རེ༌ཀྲས༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ རི༌ ཡུལ༌ གི༌ལེད༌ ཆོགས༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ཞག༌པོ༌ སུམ༌མི༌ སྟིང༌ནེ༌ ལ༌བན༌ལ༌ ཡ༌ཀོབ༌ ཤོར༌ཏོག༌ ཟེར༌ཏེ༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ཁོའེ༌ ཁོ༌རང༌ངི༌ ཉེན༌གྲུང༌གུན༌ ཁྲིད༌ཏེ༌ གི༌ལེད༌དི༌ རི༌ ཡུལ༌ལ༌ ཡ༌ཀོབ༌ ཐུག༌ཐུག༌ ཚོག༌པ༌ ཞག༌པོ༌ རྡུན༌ ཁོའེ༌ གྱབ༌ནེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ཨིན༌ནའང༌ ཚན༌ལ༌ ཨ༌རམ༌པ༌ ལ༌བན༌ལ༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ སྤང༌ པུད༌ད༌ ཛད༌ཏེ༌ མོལས༌, “སྤེ༌ར༌ ངན༌པ༌ ཟེར༌ཏེ༌ ཡ༌ཀོབ༌བ༌ ཇིགས༌ནང༌ མ༌སྟན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","གི༌ལེད༌དི༌ རི༌ ཡུལ༌ལ༌ ཡ༌ཀོབ༌བི༌ ཀུར༌གུན༌ ཙུགས༌ཏེ༌ ཡོད༌སའ༌ ལ༌བན༌ དང༌ ཁོའེ༌ ཉེན༌གྲུང༌གུན༌ ལེབ༌བ༌ཅིག༌ ཁོང༌གུན༌ནིའང༌ ཀུར༌ ཙུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ལ༌བན༌ནི༌ ཡ༌ཀོབ༌བ༌ ཟེརས༌, “ངའ༌ གོབ༌སྐོར༌ ཏངས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ཁྱོ༌རང༌ངི༌ ངའེ༌ བུ༌མོ༌གུན༌ མག༌གི༌ ནང༌ང༌ ཟུམ༌ཁན༌ནི༌ ཙོན༌པ༌གུན༌ ཙོགས༌ལ༌ ཟུམས༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ཁྱོ༌རང༌ངི༌ ངའ༌ གོབ༌སྐོར༌ཏེ༌ ངའ༌ མ༌ཤད༌ད༌ ཅི༌ཕིའ༌ ཤོར༌པིན༌? ངའེ༌ ཁྱོ༌རང༌ ཐད༌པོ༌ ཉམ༌པོ༌ ཀྲམ༌བུ༌རིན༌ དང༌ ཧརྦ༌ ཕུས༌ཏེ༌ ལུ༌ ཏང༌ཨིན༌ ལམ༌ཅུགས༌ཏེ༌ ཡོད༌གྲོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ཁྱོ༌རང༌ངི༌ ངའེ༌ ཚ༌འོ༌གུན༌ལ༌ པུག༌ ཡང༌ ངའེ༌ བུ༌མོ༌གུན༌ལ༌ ཇུ༌ ཟེར༌ མ༌ཅུག༌ག༌ སམ༌བ༌ མེད༌ཁན༌ནི༌ ལས༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ངའ༌ ཁྱོ༌རང༌ང༌ ནོད༌ སྐྱལ༌ཅེས༌སི༌ ཁྱུད༌ ཡོད༌ ཨིན༌ནའང༌ དའང༌ ཚན༌ལ༌ ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌གི༌ ངའ༌ མོལ༌ལ༌རག༌, ‘སྤེ༌ར༌ ངན༌པ༌ ཟེར༌ཏེ༌ ཡ༌ཀོབ༌བ༌ ཇིགས༌ནང༌ མ༌སྟན༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ང༌ ཧ༌གོ༌, ཁྱོ༌རང༌ང༌ ཁྱོ༌རང༌ངི༌ ཨ༌བ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ཆ༌ཅེས༌སི༌ དོད༌པ༌ སྲན༌ཏྲེ༌ ཡོད༌པ༌ ཁྱོ༌རང༌ ཤོར༌ ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ སྐུན༌དྲ༌གུན༌ ཅིའ༌ རྐུས༌ཏེ༌ ཁྱེར༌པིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ཡ༌ཀོབ༌བི༌ ལ༌བན༌ལ༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ ངའེ༌ ཀ༌ནེ༌ ཝང༌ ཉམ༌པོ༌ ཉེ༌རང༌ངི༌ བུ༌མོ༌གུན༌ ཁྱེར༌ར༌ནོག༌ སམ༌ཏེ༌ ང༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ཉེ༌རང༌ང༌ སུ༌ཞིག༌གི༌ ལག༌ག༌ ཉེ༌རང༌ངི༌ སྐུན༌དྲ༌གུན༌ ཐོབ༌ན༌, ཁོ༌ སོད༌། ང༌དང༌ངི༌ ཉེན༌གྲུང༌གུན༌ནི༌ དུན༌ལ༌, ང༌ཞའེ༌ ལག༌ག༌ ཉེ༌རང༌ངི༌ ཅི༌ཞིག༌ ཡོད༌ནའང༌ ཙལ༌ཏེ༌ ཁྱེར༌ར༌ཛད༌།” ཡ༌ཀོབ༌བ༌ རེ༌ཅལ༌ལི༌ སྐུན༌དྲ༌གུན༌ སྐུ༌ཁན༌བོ༌ གྱུས༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ལ༌བན༌ ཡ༌ཀོབ༌, ལི༌ཡ༌ དང༌ ཡོག༌མོ༌ ན༌མ༌ ཉིས༌ཀོའེ༌ ཀུར༌ གུན༌ནི༌ ནང༌ང༌ ཙལ༌ལ༌ སོང༌ ཨིན༌ནའང༌ ཁོའ༌ ཅའང༌ མ༌ཐོབ༌། ཏེ༌ནེ༌ ཁོ༌ རེ༌ཅལ༌ལི༌ ཀུར༌རི༌ ནང༌ང༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","རེ༌ཅལ༌ལི༌ སྐུན༌དྲ༌གུན༌ རྐུས༌ཏེ༌ ཁོ༌རང༌ངི༌ རྔ༌བོང༌ངི༌ གྱབ༌ཆའེ༌ ནང༌ང༌ སྦས༌ཏེ༌ ཁོ༌ གྱབ༌ཆའེ༌ཀ༌ དུགས༌ཏེ༌ ཡོད༌པིན༌། ལ༌བན༌ནི༌ ཀུར༌རི༌ ནང༌ང༌ ཙལས༌ ཨིན༌ནའང༌ ཁོའ༌ ཅའང༌ མ༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","རེ༌ཅལ༌ལི༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཟེརས༌, “ཐུགས༌སྲོ༌ མ༌སྐྱོད༌ སྤོན༌བོ༌ལེ༌, ང༌ ཉེ༌རང༌ངི༌ དུན༌ལ༌ ལང༌ཉན༌ཅེས༌ མེད༌ ཅིའ༌ཟེར༌ན༌ ང༌ ཟུགས༌པོ༌ ཞིག༌ཅེས༌སི༌ ཏུས༌པོའེ༌ ནང༌ང༌ ཨིན༌།” ཏེ༌ནེ༌ ལ༌བན༌ནི༌ ཀ༌རུང༌ས༌ ཙལས༌ ཨིན༌ནའང༌ ཁོའེ༌ སྐུན༌དྲ༌གུན༌ མ༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བ༌ སྲོ༌ ཡོངས༌ ཡང༌ ལ༌བན༌ལ༌ ཁའ༌ སྐྱེས༌ཏེ༌ ཟེརས༌, “ངའེ༌ ཅི༌ ཁྲིམས༌གལ༌ ཅོས༌? ཁྱོ༌རང༌ངི༌ ང༌ འི༌ ཚག༌པ༌ ཏེད༌ཏེ༌ ཁྱོང༌ཅེས༌ ངའེ༌ ཅི༌ སྡིག༌པ༌ ཅོས༌ཏོག༌? ");
INSERT INTO lbj_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ཏ༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ ཅ༌ལག༌ ཚང༌མ༌ ལོངས༌ཏེ༌ ཁྱོ༌རང༌ང༌ ཁྱོ༌རང༌ངི༌ ཨིན༌ཁན༌ ཅ༌ལག༌ ཅི༌ ཐོབ༌? ང༌དང༌ངི༌ ཉེན༌གྲུང༌གུན༌ནི༌ དུན༌ལ༌ ཁྱོང༌ ཡང༌ ང༌དང༌ ཉིས༌ཀོའེ༌ ནང༌ནེ༌ སུ༌ ཀྲང༌པོ༌ ཨིན༌ཁན༌བོ༌ ཁོང༌གུན༌ལ༌ ཐག༌ཅད༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ལོ༌ ཉི༌ཤུ༌ དུགས༌པིན༌། ཏེ༌ཏུས༌ ཁྱོ༌རང༌ངི༌ ལུག༌ དང༌ ར༌མ༌གུན༌ནི༌ ལུ༌གུ༌ དང༌ རི༌གུ༌གུན༌ མ༌ནེ༌ མ༌སྐྱུརས༌ མ༌ཚད༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ ཁྱུའི༌ ནང༌ནེ༌ ར༌བོ༌ གུན༌ནི༌ ཤ༌ མ༌ཟོས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","རི༌ སེམས༌ཅན༌ནི༌ སད༌ཁན༌ནི༌ ར༌ལུག༌གུན༌ ཁྱོ༌རང༌ངི༌ཀ༌ མ༌ཁྱོང༌ང༌ ཏེ༌གུན༌ནི༌ ཀོད༌ཀ༌ ང༌རང༌ངི༌ ཁུར༌པིན༌། ཉི༌མ༌ ཡ༌ ཚན༌ལ༌ རྐུས༌ཏེ༌ ཁྱེར༌ཁན༌གུན༌ལ༌ ངའ༌ རིན༌ ཤལ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ཏུས༌ མང༌པོ༌ ཉི༌མའེ༌ ཚད༌ དང༌ ཚན༌ ཀྲང༌མོའི༌ བར༌དོ༌ ངའ༌ ཐོང༌, ཡང༌ ཚན༌ མང༌པོ༌ ཉིད༌ མེད༌པ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","བུད༌ཁན༌ནི༌ ལོ༌ ཉི༌ཤུ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ང༌ དུག༌ ཟ༌ནེ༌ ཏེན༌ན༌ ཙོགས༌ སོང༌། ངའེ༌ ཉེ༌རང༌ངི༌ བུ༌མོ༌གུན༌ནི༌ ཕིའ༌ ལོ༌ ཅུབ༌ཞི༌ ལས༌ ཅོ༌པིན༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ཁྱུ༌གུན༌ནི༌ ཕིའ༌ ལོ༌ དྲུག༌, ཏེ༌བོ༌ མ༌ཚད༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ ལ༌ཆའེ༌ ནང༌ང༌ ལན༌ རྕུ༌ གྱུར༌ཇ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ཀལ༌ཏེས༌ ངའེ༌ ཨ༌བ༌ དང༌ ཨབ༌ར༌ཧམ༌མི༌ དཀོན༌མཆོག༌ ཀ༌བོའ༌ ཨི༌སཱག༌ ཇིགས༌སད༌, ང༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ མེད༌པིན༌ན༌ ཁྱོ༌རང༌ངི༌ ང༌ ལག༌པ༌ སྟོང༌པ༌ ལམ༌ཅུག༌ཏེ༌ ཡོད༌གྲོ༌། ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ངའེ༌ རྡུག༌ངལ༌ དང༌ རྩོན༌གྲུས༌ གུན༌ ཛིགས༌ཏེ༌ དའང༌ ཚན༌ལ༌ ཁོང༌ངི༌ ཁྱོ༌རང༌ང༌ ཁའ༌སྐྱེའ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ལ༌བན༌ནི༌ ཡ༌ཀོབ༌བ༌ ལན༌ཏངས༌, “འི༌ ན༌ཆུང༌གུན༌ ངའེ༌ བུ༌མོ༌, འི༌ ཕྲུ༌གུ༌གུན༌ ངའེ༌ ཚ༌འོ༌ དང༌ ཚ༌མོ༌ ཡང༌ འི༌ ཁྱུ༌གུན༌ ངའེ༌ ཁྱུ༌ ཨིན༌། འི༌ཀ༌ ཁྱོ༌རང༌ངི༌ ཐོང༌ཁན༌ ཚང༌མ༌ ངའེ༌ ཨིན༌ནོག༌། ཏ༌ ངའ༌ ང༌རང༌ངི༌ བུ༌མོ༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ ཕྲུ༌གུ༌གུན༌ལ༌ ཅའང༌ ཅོ༌ མི༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ཡོང༌ངའང༌ ང༌དང༌ ཉིས༌ཀོའེ༌ པར༌ལ༌ ཆད༌དོན༌ ཞིག༌ ཅོ༌ཨིན༌ ཀ༌བོ༌ ང༌དང༌གུན༌ནི༌ པར༌ལ༌ སྤང༌པོ༌བོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ རྡོའ༌ཞིག༌ ཁུར༌ཏེ༌ ཏེ༌བོ༌ ཀ༌ཝ༌ ཙོགས༌ལ༌ ལངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ཁོའེ༌ ཁོ༌རང༌ངི༌ ཉེན༌གྲུང༌གུན༌ལ༌ ཟེརས༌, “རྡོའ༌ སྤུང༌ཤིག༌།” ཁོང༌གུན༌ནི༌ རྡོའ༌ སྤུངས༌ ཡང༌ ཏེ༌བོའེ༌ དུན༌ལ༌ ཁར༌ཇི༌ ཟོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ལ༌བན༌ནི༌ ཏེ༌ ནས༌ས༌བོའ༌ ཡི༌གར༌ ཤ༌ཧ༌དུ༌ཐ༌ མིང༌ང༌ ཏགས༌ ཨིན༌ནའང༌ ཡ༌ཀོབ༌བི༌ ཏེ༌ ས༌ཀྱད༌པོའེ༌ མིང༌ང༌ ག༌ལིད༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ལ༌བན༌ནི༌ ཟེརས༌ “དི༌རིང༌ ང༌དང༌ ཉིས༌ཀོའེ༌ པར༌ལ༌ འི༌ རྡོའ༌ སྤུང༌ཁན༌བོ༌ སྤང༌པོ༌ ཨིན༌ནོག༌།” ཏེན༌ན༌བོའེ༌ ཕིའ༌ ཏེ༌ ས༌ཆ༌བོའ༌ ག༌ལིད༌ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ཁོང༌གུན༌ནི༌ ཏེ༌ ནས༌སའེ༌ མིང༌ང༌ མིཟ༌པཧ༌ཧའང༌ ཏགས༌, ཅིའ༌ཟེར༌ན༌ ལ༌བན༌ནི༌ ཟེརས༌, “ང༌དང༌གུན༌ བེ༌ཏེ༌ ཆའ༌ཅིག༌ ཡ༌ཝའེ༌ ང༌དང༌གུན༌ལ༌ ཟིགས༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ བུ༌མོ༌གུན༌ལ༌ ནགས༌ སྟན༌ན༌ ཡ༌ ཁྱོ༌རང༌ངི༌ ཞན༌ བུ༌མོ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོ༌ན༌, ངའ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ མེད༌ནའང༌ ཨིད༌ཏུ༌ བོར༌ དཀོན༌མཆོག༌གི༌ ང༌དང༌ངི༌ ལས༌ ཅོ༌ཁན༌གུན༌ལ༌ ཟིགས༌ས༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ལ༌བན༌ནི༌ ཡ༌ཀོབ༌བ༌ ཟེརས༌, “འི༌ཀ༌ རྡོའ༌ སྤུངས༌ཏེ༌ ང༌དང༌ ཉིས༌ཀོའེ༌ པར༌ལ༌ ཀ༌ཝ༌ ཙོགས༌ལ༌ ལངས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ ངའ༌ འི༌ རྡོའ༌ སྤུང༌ཁན༌བོ༌ རྒལ༌ཏེ༌ ཁྱོ༌རང༌ ཆོགས༌ལ༌ མི༌ཡོང༌ ཡང༌ ཁྱོ༌རང༌ འི༌བོ༌ རྒལ༌ཏེ༌ ང༌ ཆོགས༌ལ༌ མི༌ཡོང༌ཅེས༌ལ༌, འི༌ རྡོའ༌ སྤུང༌ཁན༌བོ༌ ང༌དང༌ ཉིས༌ཀོའེ༌ པར༌ལ༌ སྤང༌པོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ཨབ༌ར༌ཧམ༌ དང༌ ན༌ཧོར༌རི༌ དཀོན༌མཆོག༌, ཡང༌ ཁོང༌གུན༌ནི༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌གི༌ ང༌དང༌ ཉིས༌ཀོའ༌ ཁྲིམས༌ཅད༌ ཛད༌ཤིག༌།” ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཁོའེ༌ ཨ༌བ༌ ཨི༌སཱག༌གི༌ ཇིགས༌སི༌ ནང༌ང༌ རྩི༌ཝ༌ ཅོ༌ཁན༌ དཀོན༌མཆོག༌གི༌ ཚན༌ནི༌ ནང༌ང༌ ནའ༌ ཁུརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ཁོའེ༌ ཏེ༌ རི༌ཀ༌ དཀོན༌མཆོག༌ག༌ སེམས༌ཅན༌ ཆོད༌པའ༌ ཕུལ༌ཏེ༌ ཁོ༌རང༌ངི༌ ཉེན༌གྲུང༌གུན༌ གྲོན༌ལ༌ བོདས༌། ཁོང༌གུན༌ནི༌ དོན༌ཏང༌ ཟོ༌ཚར༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཏེ༌ ཚན༌བོ༌ རི༌ཀ༌ ཕུདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ནེ༌ ལ༌བན༌ནི༌ ཁོ༌རང༌ངི༌ ཚ༌འོ༌, ཚ༌མོ༌ དང༌ བུ༌མོ༌ གུན༌ལ༌ པུག༌ ཏངས༌ཏེ༌ ཇུ༌ ཟེརས༌ ཡང༌ ཁོ༌རང༌ངི༌ ཁང༌པ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ཡ༌ཀོབ༌བའང༌ ཏེ༌ཀ༌ནེ༌ ཁོ༌རང༌ངི༌ བེས༌ལ༌ བིང༌ ཡང༌ ཁོའ༌ ཐུག༌ག༌ལ༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉ༌གུན༌ སྐྱོདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ཁོང༌གུན༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཟེརས༌, “འི༌བོ༌ དཀོན༌མཆོག༌གི༌ མག༌མི༌ ཛོམ༌སའེ༌ ནས༌ས༌ ཨིན༌ནོག༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ ཏེ༌ ས༌ཆ༌བོའེ༌ མིང༌ང༌ མ༌ཧ༌ནཱའིམ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཨི༌དོམ༌ ཡུལ༌ལི༌ སེ༌འིར༌རི༌ ས༌ཆའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨི༌སུའ༌ ལོན༌ ཁྱེར༌ཁན༌གུན༌ སྔུན༌ལ༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ཁོའེ༌ ཁོང༌གུན༌ལ༌ ལབ༌ཞ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ འི༌ཟུག༌ ཟེར༌གོས༌, ‘སྤོན༌བོ༌ ཨི༌སུ༌ ཉེ༌རང༌ངི༌ ཡོག༌པོ༌ ཡ༌ཀོབ༌བི༌ མོལ༌ལ༌རག༌, དི༌རིང༌ ཚག༌པ༌ ང༌ ལ༌བན༌ ཉམ༌པོ༌ དུགས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ཡང༌ ངའ༌ བ༌ལང༌, བུང༌བུ༌, ལུག༌ དང༌ ར༌མ༌, ཡོག༌པོ༌ དང༌ ཡོག༌མོ༌ མང༌པོ༌ ཡོད༌། ང༌ ང༌རང༌ངི༌ སྤོན༌བོའེ༌ ཆོགས༌སྐྱོར༌ ཐོབ༌ཅེས༌ལ༌ ངའེ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ལོན༌ ཀལ༌ལད༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ལོན༌ ཁྱེར༌ཁན༌གུན༌ ཡ༌ཀོབ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ལེབས༌ཏེ༌ ཟེརས༌, “ང༌ཞའ༌ ཉེ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨི༌སུ༌ ཡོད༌ས༌ སོང༌པིན༌, ཁོང༌ ཉེ༌རང༌ང༌ ཐུག༌ག༌ལ༌ ཡོང༌ངད༌ ཡང༌ ཁོང༌ ཉམ༌པོ༌ མི༌ ཞིབ༌གྱ༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ཡ༌ཀོབ༌ ཇིགས༌ ཡང༌ ཚབས༌, ཁོའེ༌ ཁོ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ནི༌ མི༌གུན༌ ཡང༌ ལུག༌, ར༌མ༌ དང༌ བ༌ལང༌ གུན༌ནི༌ ཁྱུ༌, ཡང༌ རྔ༌བོང༌གུན༌ སྡེ༌ ཉིས༌སི༌ ནང༌ང༌ བགོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ཁོའེ༌ སམ༌, “ཀལ༌ཏེས༌ ཨི༌སུ༌ ཡོངས༌ཏེ༌ སྡེ༌ ཅིག༌ག༌ སྤུང༌གོལ༌ ཅོ༌ན༌ ཞན༌ སྡེ༌བོ༌ ཤོར༌ཉན༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ མོས༌ལམ༌ ཞུས༌, “ངའེ༌ མེ༌མེ༌ ཨབ༌ར༌ཧམ༌མི༌ དཀོན༌མཆོག༌ དང༌ ངའེ༌ ཨ༌བ༌ ཨི༌སཱག༌གི༌ དཀོན༌མཆོག༌, ཡ༌ཝ༌ ཉེ༌རང༌ངི༌ ངའ༌ མོལ༌ལ༌ ཛདས༌, ‘རང༌ ཡུལ༌ དང༌ རང༌ངི༌ ཉེན༌གྲུང༌གུན༌ ཡོད༌སའེ༌ ས༌ཆའ༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ ངའེ༌ ཁྱོ༌རང༌ ཅི༌ཚང༌མའེ༌ ནང༌ང༌ ཐར༌ཁྱེལ༌ ཆ༌ཅུག༌ཨིན༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ཉེ༌རང༌ངི༌ ཡོག༌པོའ༌ སྟན༌ན༌ ཛད༌ཁན༌ ཨིད༌ཤེས༌ དང༌ ཐུག༌རྗེ༌ ཚང༌མ༌ ཐོབ༌ཅེས༌སི༌ འོས༌པ༌ ངའ༌ མན༌། ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཆ༌ ཟ༌ནེ༌ ངའེ༌ ལག༌ག༌ རྟེན༌ཅེས༌སི༌ བེར༌ཀ༌བོ༌ མ༌ནེ༌ ཅའང༌ མེད༌པིན༌ ཨིན༌ནའང༌ ཏ༌ ངའེ༌ ལག༌ག༌ སྡེ༌ ཉིས༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ང༌ ངའེ༌ ཨ༌ཅོ༌ ཨི༌སུའི༌ ཀ༌ནེ༌ སྐྱོབ༌བ༌ ཛད༌ཅེས༌ལ༌ ངའེ༌ མོས༌ལམ༌ ཞུའད༌། ང༌ ཇིགས༌ས༌རག༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ ཡོངས༌ཏེ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ང༌ མ༌ཚད༌ ངའེ༌ ན༌མ༌གུན༌ དང༌ ཕྲུ༌གུ༌གུན༌ སད༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ཨིན༌ནའང༌ ཉེ༌རང༌ངི༌ མོལ༌ལ༌ ཛདས༌, ‘ངའེ༌ ཁྱོ༌རང༌ ཅི༌ཚང༌མའེ༌ ནང༌ང༌ ཐར༌ཁྱེལ༌ ཅུགས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ ཚོའེ༌ ཐའ༌མའེ༌ པེ༌མ༌ རྩི༌ མི༌ཉན༌ཅེས༌ ཙོགས༌ གྱུར༌ཅུག༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ཏེ༌ ཚན༌ལ༌ ཡ༌ཀོབ༌ ཏེན༌ན༌རུ༌ དུགས༌ ཡང༌ ཁོ༌རང༌ང༌ ཡོད༌ཁན༌གུན༌ནི༌ ནང༌ནེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨི༌སུའི༌ ཕིའ༌ སྐྱེས༌ ལྡམས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ཏེ༌གུན༌ ར༌མ༌ 200, ར༌ཕོ༌ 20, ལུག༌ 200, ལུག༌ཕོ༌ 20, ");
INSERT INTO lbj_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","རྔ༌བོང༌མོ༌ 30 དང༌ ཏེ༌གུན༌ནི༌ ཕྲུ༌གུ༌གུན༌, བ༌ལང༌ 40 དང༌ ལང༌ཏོ༌ 10, བུང༌མོ༌ 20 དང༌ བུང༌ཕོ༌ 10 ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ཁོའེ༌ ཏེ༌གུན༌ནི༌ ཁྱུ༌ སོ༌སོ༌ ཅོས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཡོག༌པོ༌གུན༌ལ༌ སྟ༌སྟོག༌ ཅོ༌ཅུགས༌། ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ངའེ༌ སང༌ སྔུན༌ལ༌ སོང༌ ཨིན༌ནའང༌ ཁྱུ༌གུན༌ནི༌ པར༌ལ༌ པར༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ཁོའེ༌ གོ༌མ༌ ཆའ༌ཁན༌ནི༌ ཡོག༌པོའ༌ ལབ༌ཞ༌ ཏངས༌, “ངའེ༌ ཨ༌ཅོ༌ ཨི༌སུ༌ ཐུག༌ཏེ༌ ‘ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌ སུ༌ ཨིན༌ ཡང༌ ཁྱོ༌རང༌ ཀ༌རུ༌ ཆའད༌། འི༌ སེམས༌ཅན༌ ཚང༌མའ༌ སུའི༌ ཨིན༌ ཟེར༌ཏེ༌ ཏྲི༌ན༌?’ ");
INSERT INTO lbj_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ཁྱོ༌རང༌ངི༌ ལན༌ འི༌ཟུག༌ ཏང༌གོས༌, ‘འི༌ ཚང༌མ༌ ཉེ༌རང༌ངི༌ ཡོག༌པོ༌ ཡ༌ཀོབ༌བི༌ ཨིན༌ལེ༌། འི༌ ཚང༌མ༌ ཁོང༌ངི༌ སྤོན༌བོ༌ ཨི༌སུའི༌ ཕིའ༌ སྟགས༌ ཀལ༌ཁན༌གུན༌ ཨིན༌ ཡང༌ ཡ༌ཀོབ༌ ཁོང༌རང༌ ང༌ཞའེ༌ སྟིང༌ནེ༌ ཡོང༌ངད༌ལེ༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ཁོའེ༌ ཉིས༌པ༌ དང༌ སུམ༌པ༌ ཁྱུ༌གུན༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ནི༌ ཡོག༌པོ༌གུན༌ལའང༌ ལབ༌ཞའ༌ ཏངས༌, “ཨི༌སུ༌ ཐུག༌ག༌ཅིག༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཏེན༌ན༌ ཙོགས༌ ཟེར༌, ");
INSERT INTO lbj_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘ཉེ༌རང༌ངི༌ ཡོག༌པོ༌ ཡ༌ཀོབ༌ ང༌ཞའེ༌ སྟིང༌ནེ༌ ཡོང༌ངད༌’ ཟེར༌ཅེས༌པོ༌ རྗེད༌ མ༌གོས༌།” ཡ༌ཀོབ༌བི༌ སམ༌, “ཅི༌གྱུས༌, ངའེ༌ སྟགས༌ ཀལ༌ཁན༌བོའེ༌ ཁོ༌ ཐད༌ཅུགས༌ཏེ༌, སྟིང༌ནེ༌ ང༌ ཐུག༌ག༌ཅིག༌ ཁོའེ༌ ཤགས༌པ༌ ཏངས༌ཏེ༌ ངའ༌ སྙིང༌རྗེ༌ སྟན༌ སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ སྟགས༌ ཚང༌མ༌ ཁོ༌རང༌ངི༌ སང༌ སྔུན༌ལ༌ ཀལས༌, ཨིན༌ནའང༌ ཁོ༌རང༌ ཏེ༌ ཚན༌བོ༌ ཏེན༌ན༌རུ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ཏེན༌ན༌ ཚན༌ལ༌ ཡ༌ཀོབ༌ ལངས༌ཏེ༌ ཁོ༌རང༌ངི༌ ན༌མ༌ ཉིས༌ཀོ༌, ཁོའེ༌ ཚེ༌ཡོག༌ ན༌མ༌ ཉིས༌ཀོ༌, ཁོ༌རང༌ངི༌ ཕྲུ༌གུ༌ ཅུག༌ཤིག༌པོ༌ ཁྲིད༌ཏེ༌ ཡབ༌བོག༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཆ༌ཅེས༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ཁོའེ༌ ཁོང༌ དང༌ ཁོའེ༌ གྱུ༌ནོར༌ ཚང༌མ༌ ལྩངས༌པོའེ༌ ཕར༌ཀ༌ ཀལ༌ ཚར༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ཁོ༌རང༌ ཅིག༌པོ༌ ལུས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ མི༌ཞིག༌གི༌ ཁོ༌ ཉམ༌པོ༌ ནམ༌ ལང༌ལངས༌ ཚོག༌པ༌ ནོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","མི༌བོའ༌ ནོལ༌ཅེས༌སི༌ ནང༌ང༌ ཁོང༌ མི༌གྱལ༌ཅེས༌པོ༌ ཧ༌གོའ༌ཅིག༌ ཁོང༌ངི༌ ཡ༌ཀོབ༌བི༌ སྤི༌རུས༌པོའ༌ ཆག༌ རྩེས༌ཏེ༌ ཏེ༌བོ༌ ཚིགས༌སི༌ ནང༌ནེ༌ ཕིངས༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ཏེ༌ནེ༌ མི༌བོའེ༌ མོལས༌, “ང༌ ཆ༌ཅུག༌, ཉི༌མ༌ ཤར༌དུག༌།” ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ ངའ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ མ༌ནེ༌ ངའེ༌ ཉེ༌རང༌ ཆ༌ མི༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","མི༌བོའེ༌ ཏྲིའ༌ ཛདས༌, “ཁྱོ༌རང༌ངི༌ མིང༌ང༌ ཅི༌ ཨིན༌།” ཁོའེ༌ ཟེརས༌, “ཡ༌ཀོབ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ཁོང༌ངི༌ མོལས༌, “ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌རང༌ང༌ ཡ༌ཀོབ༌ མན༌པ༌ ཨིས༌ར༌ཨེལ༌ ཟེར༌ཨིན༌, ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ངི༌ དཀོན༌མཆོག༌ དང༌ མི༌གུན༌ ཉམ༌པོ༌ རད༌ཏེ༌ ཁྱོ༌རང༌ང༌ གྱལ༌ཁའ༌ ཐོབ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ཇུ༌ཇུ༌ ཉེ༌རང༌ངི༌ མིང༌ ཤད༌ད༌ ཛད༌།” ཨིན༌ནའང༌ ཁོང༌ངི༌ ལན༌སལས༌, “ཅི༌ཕིའ༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ མིང༌ ཏྲིའད༌?” ཡང༌ ཁོང༌ངི༌ ཡ༌ཀོབ༌བ༌ ཅིན༌ལབས༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ངའེ༌ ང༌རང༌ངི༌ མིག༌ནེ༌ དཀོན༌མཆོག༌ ཇལ༌ཏེའང༌ ང༌ སོན༌ཏེའ༌ ལུས༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ ཏེ༌ ས༌ཆ༌བོའེ༌ མིང༌ང༌ པེ༌ནིལ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ཡ༌ཀོབ༌ པེ༌ནིལ༌ནེ༌ ཆའ༌ ཟ༌ནེ༌ ཉི༌མ༌ ཤར༌, ཡང༌ ཁོའེ༌ སྤི༌རུས༌པོའེ༌ ཞས༌ཏེ༌ ཁོ༌ ཞ༌འོ༌ རྩེའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ཏེན༌ན༌བོའེ༌ཕིའ༌ དག༌སའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྤི༌ཤ༌ ཟའ༌ མ༌ནོག༌, ཅིའ༌ཟེར༌ན༌ ཡ༌ཀོབ༌བི༌ སྤི༌ཤའེ༌ གྱུས༌པ༌ མ༌སྐྱོན༌ སོང༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ཏེ༌ནེ༌ ཨི༌སུ༌ ཁོ༌རང༌ངི༌ མི༌ ཞིབ༌གྱ༌ ཉམ༌པོ༌ ཡོང༌ང༌ལ༌ ཡ༌ཀོབ༌བི༌ ཐོང༌། ཁོའེ༌ ཕྲུ༌གུ༌གུན༌ ལི༌ཡ༌ དང༌ རེ༌ཅལ༌ གུན༌ནི༌ པར༌ལ༌ གོས༌ ཡང༌ ཚེ༌ཡོག༌ ན༌མ༌ ཉིས༌ཀོའང༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ཁོའེ༌ ཚེ༌ཡོག༌ ན༌མ༌ ཉིས༌ཀོ༌ དང༌ ཁོང༌གུན༌ནི༌ ཕྲུ༌གུ༌གུན༌ ཚང༌མའེ༌སང༌ དུན༌ལ༌, ཏེ༌ནེ༌ ལི༌ཡ༌ དང༌ ཁོའེ༌ ཕྲུ༌གུ༌གུན༌ ཡང༌ རེ༌ཅལ༌ དང༌ ཡོ༌སེབ༌ སྟིང༌ཇུག༌པོའེ༌ཀ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ཡ༌ཀོབ༌ ཁོང༌གུན༌ནི༌ སྔུན༌ལ༌ སོང༌ ཡང༌ ཨ༌ཅོའེ༌ ཉེ༌མོའ༌ ལེབ༌བ༌ཅིག༌ རྩི༌ཝ༌ ཅོས༌ཏེ༌ ཁོའེ༌ དུན༌ལ༌ ལེབ༌ལེབ༌ ཚག༌པ༌ ཡ༌ཀོབ༌བི༌ ལན༌ རྡུན༌ གོ༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ སྒུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ཨིན༌ནའང༌ ཨི༌སུ༌ བང༌ཏངས༌ཏེ༌ ཁོའ༌ ཐུག༌ག༌ལ༌ ཡོངས༌ ཡང༌ ཁོའ༌ ཁྲིལ༌ཏེ༌ པུག༌ ཏངས༌། ཁོང༌ ཉིས༌ཀོ༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ཨི༌སུའི༌ གོ༌ སྟགས༌ཏེ༌ ལྟའ༌ཅིག༌ ཁོའ༌ བུ༌མོ༌ དང༌ ཕྲུ༌གུ༌གུན༌ ཐོང༌ ཡང༌ ཁོའེ༌ ཏྲིས༌, “ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌ཁན༌གུན༌ སུ༌ ཨིན༌?” ཡ༌ཀོབ༌བི༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ཉེ༌རང༌ངི༌ ཡོག༌པོའ༌ ཐུག༌རྗེའེ༌ ཛད༌ཏེ༌ སལ༌ཁན༌ནི༌ ངའེ༌ ཕྲུ༌གུ༌གུན༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ཏེ༌ནེ༌ ཚེ༌ཡོག༌ ན༌མ༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ ཕྲུ༌གུ༌གུན༌ ཡོངས༌ ཡང༌ གོ༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ སྒུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ཏེ༌ སྟིང༌ནེ༌ ལི༌ཡ༌ དང༌ ཁོའེ༌ ཕྲུ༌གུ༌གུན༌ ཡང༌ སྟིང༌ཇུག༌ག༌ ཡོ༌སེབ༌ དང༌ རེ༌ཅལ༌ ཡོངས༌ཏེ༌ གོ༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ སྒུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ཨི༌སུའི༌ ཏྲིས༌, “ངའ༌ ཐུག༌ག༌ལ༌ ཀལ༌ཁན༌ནི༌ མི༌ དང༌ སེམས༌ཅན༌ གུན༌ནི༌ ཏོན༌ ཅི༌ ཨིན༌?” ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “སྤོན༌བོ༌, ཉེ༌རང༌ངི༌ ཆོགས༌སྐྱོར༌ ཐོབ༌ཅེས༌ལ༌ ཨིན༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ཨིན༌ནའང༌ ཨི༌སུའི༌ ཟེརས༌, “ངའ༌ ང༌རང༌ང༌ མ༌མང༌པོ༌ ཡོད༌། ནོ༌, ཁྱོ༌རང༌ངི༌ ཨིན༌ཁན༌གུན༌ རང༌ངི༌ ཕིའ༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ཡ༌ཀོབ༌བི༌ ཟེརས༌, “མན༌, ཇུ༌ཇུ༌ ཀལ༌ཏེས༌ ཉེ༌རང༌ངི༌ ངའ༌ ཆོགས༌སྐྱོར༌ ཛད༌ཏེ༌ ཨིན༌ན༌ འི༌ སྟགས༌གུན༌ ལེན༌ན༌ ཛད༌། ཉེ༌རང༌ངི༌ ཞལ༌དོང༌ ཐོང༌ཅེས༌པོ༌ ནི༌ དཀོན༌མཆོག༌གི༌ ཞལ༌དོང༌ ཇལ༌ཁན༌ ཙོགས༌ ཨིན༌ནོག༌ ཅིའ༌ཞུ༌ན༌ ཉེ༌རང༌ངི༌ ངའེ༌ཀ༌ ཐུག༌རྗེ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ཇུ༌ཇུ༌ ངའེ༌ ཉེ༌རང༌ང༌ ཁྱོང༌ཁན༌ནི༌ སྟགས༌གུན༌ ནམས༌ས༌ ཛད༌ ཅིའ༌ཞུ༌ན༌ དཀོན༌མཆོག༌གི༌ ངའེ༌ཀ༌ ཐུག༌རྗེ༌ ཛད༌ཏེ༌ ངའ༌ སྒོས༌དོམ༌ ཚང༌མ༌ སལས༌།” ཡ༌ཀོབ༌བི༌ འུ༌ཙུག༌ ཏངས༌པ༌ ཨི༌སུའི༌ ཏེ༌གུན༌ ལེནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ཨི༌སུའ༌ ཟེརས༌, “ང༌དང༌ངི༌ བེས༌པོ༌ ཡང༌སྐྱར༌ གོ༌ཟུག༌ ཨིན༌ ཡང༌ ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ངའེ༌ སྤོན༌བོ༌, ཕྲུ༌གུ༌གུན༌ འུ༌ཐུགས༌ ཡང༌ ཕྲུ༌གུ༌གུན༌ལ༌ འོ༌མ༌ སྟེར༌ཁན༌ནི༌ ལུག༌ དང༌ བ༌ལང༌ གུན༌ནི༌ ཕིའ༌ ང༌ སམ༌བ༌ ཏང༌ གོ༌ཤེས༌པོ༌ ཉེ༌རང༌ངི༌ ཧ༌གོའ༌ནོག༌། ཀལ༌ཏེས༌ ཏེ༌གུན༌ ཞག༌ཅིག༌གའང༌ གྱོགས༌པ༌ སྲུལ༌ན༌ ཏེ༌གུན༌ ཤི༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ཇུ༌ཇུ༌ ཉེ༌རང༌ ངའེ༌ སང༌ སྔུན༌ལ༌ སྐྱོད༌། ང༌ ཕྲུ༌གུ༌གུན༌ དང༌ ཀྲུད༌ཏྲོའེ༌ ཁྱུ༌ ཉམ༌པོ༌ ཀུ༌ལེ༌ ཀུ༌ལེའ༌ སེ༌འིར༌ལ༌ ལེབ༌ལེབ༌ ཚག༌པ༌ ཉེ༌རང༌ངི༌ སྟིང༌རང༌ནེ༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ཨི༌སུའི༌ ཟེརས༌, “ང༌ ངའེ༌ མི༌ ཁ༌ཅིག༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ བོར༌ཅུག༌།” ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “ཏེ༌ཟུག༌ མ༌ཛད༌། ངའེ༌ ཕིའ༌ ཉེ༌རང༌ངི༌ ཐུག༌རྗེ༌བོ༌ ཙམ༌ ཐད༌ཐད༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ཏེ༌ནེ༌ ཨི༌སུ༌ ཏེན༌ན༌ ཞག༌ག༌ ལོགས༌ཏེ༌ ཁོ༌རང༌ངི༌ ལམ༌མི༌ཀ༌ སེ༌འིར༌ ཆོགས༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ཨིན༌ནའང༌ ཡ༌ཀོབ༌ སུ༌ཀོད༌ལ༌ སོང༌ ཀ༌རུ༌ ཁོའེ༌ ཁོང༌རང༌ངི༌ ཕིའ༌ ཁང༌པ༌ རྩིགས༌ ཡང༌ སེམས༌ཅན༌ ཚང༌མ༌ ཕིའ༌ དུགས༌ས༌ ཅོས༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ ཏེ༌ ས༌ཀྱད༌པོའེ༌ མིང༌ང༌ སུ༌ཀོད༌ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","པ༌དན༌ཨ༌རམ༌ནེ༌ བིང༌ཏེ༌ ཡ༌ཀོབ༌ ཀེ༌ནན༌ ཡུལ༌ཇོངས༌སི༌ ཤེ༌ཀེམ༌ གྱལ༌སའ༌ ཁམ༌ཟང༌ ལེབ༌ ཡང༌ གྱལ༌ས༌ དང༌ ཉེ༌མོའ༌ ཀུར༌གུན༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ཡ༌ཀོབ༌བི༌ ཁོང༌ དུག༌སའེ༌ ས༌ཀྱད༌པོ༌ ཤེ༌ཀེམ༌མི༌ ཨ༌བ༌ ཧ༌མོར༌རི༌ པུར༌གྱུད༌གུན༌ནི༌ ཀ༌ནེ༌ མུལ༌ལི༌ པེ༌ནེ༌ 100 ཉོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ཁོའེ༌ ཏེ༌ཀ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌ཏེ༌ ཏེ༌བོའ༌ ཨེལ༌ ཨེ༌ལོ༌ཧི༌ ཨིས༌ར༌ཨེལ༌ ༼ཡང༌ན༌ དཀོན༌མཆོག༌, ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌༽ ཟེར༌ཏེ༌ མིང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ལོ༌ ཁ༌ཅིག༌གི༌ སྟིང༌ནེ༌, ཞག༌ཤིག༌ ཡ༌ཀོབ༌ དང༌ ལི༌ཡའེ༌ བུ༌མོ༌ དི༌ནཱ༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ བུ༌མོ༌གུན༌ལ༌ ཐུག༌ག༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ཨིན༌ནའང༌ ཏེ༌ ནས༌སའེ༌ ཝང༌སྲུལ༌པ༌ ཧིཝ༌པ༌ ཧ༌མོར༌རའི༌ བུ༌ཚ༌ ཤེ༌ཀེམ༌མི༌ དི༌ནཱ༌ ཐོང༌ང༌ཅིག༌, ཁོའེ༌ ཁོ༌ ཟུམས༌ཏེ༌ ཝང༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ཁོའེ༌ སེམས༌ དི༌ནཱའེ༌ཀ༌ སོང༌ཏེ༌ ཁོ༌ ཁོའེ༌ཀ༌ མ༌སྲན༌ཏྲེ༌ ཐད༌ ཡང༌ སྤེ༌ར༌ ལྡེ༌མོ༌ ཉམ༌པོ༌ ཁོའེ༌ ཡ༌ཤ༌ ཐོབ༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ཁོའེ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཧ༌མོར༌ལ༌ ཟེརས༌, “འི༌ བུ༌མོ༌བོ༌ ངའ༌ ན༌མའ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ཡ༌ཀོབ༌བ༌ ཁོའེ༌ བུ༌མོ༌ ཉམ༌པོ༌ ངན༌པ༌ ཆའ༌ཁན༌བོ༌ གྱུས༌སོང༌, ཁོའེ༌ བུ༌ཚ༌གུན༌ སེམས༌ཅན༌གུན༌ ཉམ༌པོ༌ ཕི༌ལོག༌ག༌ ཡོད༌ པ༌སང༌ ཁོང༌གུན༌ ལོགས༌ཏེ༌ ཡོང༌ཡོང༌ ཚོག༌པ༌ ཁོའེ༌ སུའང༌ ཅའང༌ མ༌ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ཤེ༌ཀེམ༌མི༌ ཨ༌བ༌ ཧ༌མོར༌ ཡ༌ཀོབ༌བ༌ སྤེ༌ར༌ ཏང༌ང༌ལ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌ ཞིང༌ནེ༌ ལེབས༌ཏེ༌ སྲིང༌མོ༌ ཉམ༌པོ༌ ངན༌པ༌ ཆའ༌ཁན༌བོ༌ ཚོར༌ར༌ཅིག༌ ཁོང༌གུན༌ལ༌ མ༌སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌ ཅིའ༌ཟེར༌ན༌ ཤེ༌ཀེམ༌མི༌ ཝང༌ ཉམ༌པོ༌ ཁོང༌ངི༌ སྲིང༌མོའ༌ ལུས༌བྲེལ༌ ཅོས༌ཏེ༌ ཡ༌ཀོབ༌བི༌ ནང༌ཚངས༌སི༌ཀ༌ ཁྲེལ༌བ༌ ཁྱོངས༌ཏེ༌ ཨིན༌པིན༌, ཏེ༌ཟུག༌ ལས༌ ཅོ༌ཅེས༌པོ༌ འོས༌པ༌ མན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ཧ༌མོར༌རི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ངའེ༌ བུ༌ཚ༌ ཤེ༌ཀེམ༌མི༌ ཉེ༌རང༌ངི༌ བུ༌མོའ༌ སྙིང༌ནེ༌ ཡ༌ཤ༌ ཅོ༌རུག༌། ཐུག༌རྗེ༌ ཛད༌ཏེ༌ ཁོའ༌ དི༌ནཱ༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོ༌ཅུག༌ག༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ང༌ཞའེ༌ བུ༌མོ༌གུན༌ ཁྱོ༌ཞའེ༌ བུ༌ཚ༌གུན༌ ཉམ༌པོ༌ ཡང༌ ཁྱོ༌ཞའེ༌ བུ༌མོ༌གུན༌ ང༌ཞའེ༌ བུ༌ཚ༌གུན༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ཉེ༌ཞའ༌ ང༌ཞའེ༌ ཡུལ༌ལ༌ དུག༌ནའང༌ གྲིག༌, འི༌ ས༌ཀྱད༌པོ༌ ཉེ༌ཞའེ༌ ཕིའ༌ ཕེས༌ཏེ༌ ཨིན༌ ཉེ༌ཞའ༌ ཀ༌རུ༌ ཐད༌ནའང༌ དུགས༌ཏེ༌ ཉོབ༌ཚོང༌ ཏོང༌ ཡང༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཕིའ༌ གྱུ༌ནོར༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ཤེ༌ཀེམ༌མི༌ དི༌ནཱའེ༌ ཨ༌བ༌ དང༌ མིང༌བོ༌གུན༌ལ༌ ཟེརས༌, “འི༌ ཐུག༌རྗེ༌བོ༌ ངའེ༌ཀ༌ ཛད༌ ཡང༌ ངའེ༌ ཉེ༌ཞའེ༌ ཅི༌ཏོང༌ མོལ༌ནའང༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ན༌མའེ༌ རིན༌ ཅོའད༌ ཡང༌ རིན༌ཅན༌ སྐྱེས༌ ངའ༌ ཁྱོང༌ ཟེར༌ཁན༌གུན༌ ངའེ༌ ཁྱོང༌ཨིན༌། ངའ༌ ན༌མ༌ ཅོ༌ཅེས༌ལ༌ དི༌ནཱ༌ ཅིག༌པོ༌ སལ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ཤེ༌ཀེམ༌མི༌ ཁོང༌གུན༌ནི༌ སྲིང༌མོའ༌ ངན༌པ༌ ཅོས༌ཏེ༌ ཨིན༌ པ༌སང༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌ནི༌ ཤེ༌ཀེམ༌ དང༌ ཁོའེ༌ ཨ༌བ༌ ཧ༌མོར༌ལ༌ གོབ༌སྐོར༌ཏེ༌ ལན༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ཁོང༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ང༌ཞའེ༌ སྲིང༌མོ༌ སུན༌ནད༌ མ༌ཅོ༌ཁན༌ནི༌ མི༌ཞིག༌ག༌ མི༌ཏང༌། ཏེ༌བོ༌ ང༌ཞའེ༌ ཕིའ༌ ཁྲེལ༌བ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ཨིན༌ནའང༌ ཁྱོ༌ཞ༌ དང༌ ཁྱོ༌ཞའེ༌ བུ༌ཚ༌གུན༌ནི༌ སུན༌ནད༌ ཅོས༌ཏེ༌ ང༌ཞའ༌ ཙོགས༌ གྱུར༌ན༌, ཁྱོ༌རང༌ངི༌ ཁོ༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོ༌ནའང༌ གྲིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ཏེ༌ནེ༌ ང༌ཞའེ༌ བུ༌མོ༌གུན༌ ཁྱོ༌ཞའ༌ ཏང༌ཉིན༌ ཡང༌ ཁྱོ༌ཞའེ༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ ང༌ཞའེ༌ བག༌སྟོན༌ ཅོ༌ཨིན༌། ཡང༌ ང༌ཞ༌གུན༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ དུགས༌ཏེ༌ ང༌དང༌གུན༌ གྱལ༌ཁག༌ ཅིག༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌ སུན༌ནད༌ ཅོའ༌ མ༌ཐད༌ན༌ ཏེ༌ནེ༌ ང༌ཞའ༌ ང༌ཞ༌རང༌ངི༌ སྲིང༌མོ༌ ཁྲིད༌ཏེ༌ འི༌ ས༌ཀྱད༌པོ༌ ཕངས༌ཏེ༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ཁོང༌གུན༌ནི༌ ཟེར༌ཁན༌བོ༌ ཧ༌མོར༌ དང༌ ཁོའེ༌ བུ༌ཚ༌ ཤེ༌ཀེམ༌མ༌ འོས༌པ༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ཤེ༌ཀེམ༌ ཡ༌ཀོབ༌བི༌ བུ༌མོའ༌ མ༌སྲན༌ཏྲེ༌ ཐད༌པ༌ ཏུས༌ གོད༌ལ༌ མ༌ཏང༌ང༌ ཁོང༌གུན༌ནི༌ ཟེར༌ཁན༌བོ༌ ཅོ༌ཅེས༌ལ༌ ཁའ༌ ཆམས༌། ཁོ༌ ཁོ༌རང༌ངི༌ ནང༌ཚངས༌སི༌ ཚང༌མའེ༌ སང༌ ཀུས༌པ༌ཅན༌ནི༌ བུ༌ཚ༌བོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ཏེ༌ནེ༌ ཧ༌མོར༌ དང༌ ཁོའེ༌ བུ༌ཚ༌ ཤེ༌ཀེམ༌ གྱལ༌སའེ༌ གྱས༌སྒོའེ༌ཀ༌ སོང༌ ཡང༌ གྱལ༌སའེ༌ འུ༌སྐྱོང༌གུན༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏངས༌། ཁོང༌གུན༌ནི༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“འི༌ མི༌གུན༌ནི༌ ཀ༌ནེ༌ ང༌དང༌གུན༌ལ༌ ཅའང༌ ཇིགས༌པ༌ མི༌དུག༌, ཁོང༌གུན༌ནའང༌ ང༌དང༌ངི༌ ས༌ཀྱད༌དི༌ཀ༌ དུག༌ཅུགས༌ཏེ༌ ཚོང༌ ཅོ༌ཅུག༌ཨིན༌, འི༌ ས༌ཆ༌བོའེ༌ ནང༌ང༌ ཁོང༌གུན༌ནའང༌ ཆུད༌ཅེས༌ དུག༌། ཡང༌ ང༌དང༌གུན༌ནི༌ ཁོང༌ངི༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ ཡང༌ ཁོང༌གུན༌ནི༌ ང༌དང༌ངི༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོ༌ཉན༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ཨིན༌ནའང༌ ང༌དང༌གུན༌ནི༌ ང༌དང༌ངི༌ བུ༌ཚ༌ ཚང༌མའེ༌ སུན༌ནད༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ ཙོགས༌ གྱུར༌ཏེ༌ མ༌ནེ༌ ཁོང༌ ང༌དང༌གུན༌ ཉམ༌པོ༌ གྱལ༌ཁག༌ ཅིག༌ མི༌གྱུར༌ ཟེར༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ཁོང༌གུན༌ནི༌ སེམས༌ཅན༌ དང༌ གྱུ༌ནོར༌ ཚང༌མ༌ ང༌དང༌གུན༌ནི༌ མི༌གྱུར༌ར༌? ཏེ༌བོའེ༌ཕིའ༌ ང༌དང༌གུན༌ནི༌ ཁའ༌ ཆམས༌ཏེ༌ ཁོང༌གུན༌ ང༌དང༌ངི༌ ཕྲོའ༌ དུག༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ཧ༌མོར༌ དང༌ ཤེ༌ཀེམ༌མི༌ ཟེར༌ཁན༌བོའེ༌ཀ༌ ཡུལ༌པ༌ ཚང༌མ༌ ཁའ༌ ཆམས༌ཏེ༌ བུ༌ཚ༌ ཚང༌མའ༌ སུན༌ནད༌ ཅོ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ཞག༌ སུམ༌པའེ༌ ཞག༌ག༌ བུ༌ཚ༌གུན༌ནི༌ སུན༌ནད༌ ཅོ༌ཁན༌ནི༌ མ༌ཁའ༌ མ༌གྱལ༌ལ༌ ཡོད༌ཏུས༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌ ཉིས༌ སི༌མེ༌འོན༌ དང༌ ལི༌ཝི༌, དི༌ནཱའེ༌ ཨ༌ཅོ༌གུན༌ནི༌ ར༌འི༌ ཁུར༌ཏེ༌ ཧུན༌མེད༌ལ༌ གྱལ༌སའེ༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ བུ༌ཚ༌ ཚང༌མ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ཁོང༌གུན༌ནི༌ ཧ༌མོར༌ དང༌ ཁོའེ༌ བུ༌ཚ༌ ཤེ༌ཀེམ༌མའང༌ སདས༌ ཡང༌ ཁོའེ༌ ཁང༌པ༌ནེ༌ དི༌ནཱ༌ ཁྲིད༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ཁོང༌གུན༌ནི༌ སྲིང༌མོའ༌ ངན༌པ༌ ཅོ༌ཁན༌བོའེ༌ ལན༌ཏངས༌ཏེ༌ ཡ༌ཀོབ༌བི༌ ཞན༌ བུ༌ཚ༌གུན༌ནི༌ གྱལ༌ས༌བོ༌ ཅོམས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ཁོང༌གུན༌ནི༌ ར༌ལུག༌ དང༌ བ༌ལང༌ངི༌ ཁྱུ༌, བུང༌བུ༌གུན༌ ཡང༌ གྱལ༌ས༌ དང༌ ཞིང༌ངི༌ཀ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ཁོང༌གུན༌ནི༌ ཁང༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ གྱུ༌ནོར༌, བུ༌མོ༌ དང༌ ཕྲུ༌གུ༌ ཚང༌མ༌ ཅོམས༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ཡ༌ཀོབ༌བི༌ སི༌མེ༌འོན༌ དང༌ ལི༌ཝི༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ ངའེ༌ཀ༌ ནགས༌ ཁྱོངས༌ཏེ༌ ཨིན༌ནོག༌། ཀེ༌ནན༌པ༌, པེ༌རིཟ༌པ༌ དང༌ འི༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མའེ༌ ང༌དང༌ང༌ ནཕ༌རད༌ ཅོ༌རུག༌། ང༌དང༌གུན༌ མང༌པོ༌ཞིག༌ མེད༌ཏེ༌ ཨིན༌ནོག༌། ཀལ༌ཏེས༌ ཁོང༌ ཚང༌མའ༌ ང༌དང༌ངི༌ གྱབ༌གལ༌ལ༌ ཅིག༌ སོང༌ཏེ༌ ང༌དང༌ངི༌ཀ༌ སྤུང༌གོལ༌ ཅོ༌ན༌ ང༌དང༌ངི༌ ནང༌ཚངས༌ ཚང༌མ༌ མེད༌ཁན༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཁོའེ༌ ང༌ཞའེ༌ སྲིང༌མོའ༌ ཟུགས༌ཙོང༌མ༌ ཙོགས༌ ཅོ༌གོས༌ས༌?” ");
INSERT INTO lbj_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཡ༌ཀོབ༌བ༌ མོལས༌, “བེ༌ཐེལ༌ལ༌ སོང༌ ཡང༌ ཏེ༌རུ༌ ཚུགས༌ཏེ༌ དུག༌། ཏེ༌རུ༌, ཁྱོ༌རང༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨི༌སུ༌ནེ༌ ཤོར༌ཏེ༌ ཆ༌ ཟ༌ནེ༌ ཁྱོ༌རང༌ངི༌ ཇལ༌ཁན༌ དཀོན༌མཆོག༌གི༌ ཕིའ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ ནང༌ཚངས༌ དང༌ ཁོ༌རང༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ ཚང༌མ༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ ཕྲོའ༌ ཡོད༌ཁན༌ ཏད༌པ༌ མེད༌ཁན༌ནི༌ སྐུན༌དྲ༌གུན༌ ཕངས༌ཏེ༌ ཁྱོ༌ཞ༌རང༌གུན༌ རྩང༌མ༌ ཅོས༌ ཡང༌ ཀོས༌ལག༌གུན༌ སྤོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ཏེ༌ནེ༌ ཡོང༌ ང༌དང༌གུན༌ བེ༌ཐེལ༌ལ༌ ཆེན༌ ཀ༌རུ༌ ངའེ༌ དཀོན༌མཆོག༌གི༌ ཕིའ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིག༌ཨིན༌། ཁོང༌ངི༌ ང༌ བར༌དོའེ༌ ནང༌ང༌ ཡོད༌ ཟ༌ནེ༌ ང༌ རོགས༌ ཛད༌ཏེ༌ ང༌ ཀ༌རུ༌ ཆ༌ནའང༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཡོད༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ ལག༌ག༌ ཡོད༌ཁན༌ སྐུན༌དྲ༌ ཚང༌མ༌ དང༌ ནམ༌ཅོག༌གི༌ ཨ༌ལོང༌གུན༌ ཡ༌ཀོབ༌བ༌ ཏངས༌། ཁོའེ༌ ཏེ༌གུན༌ ཤེ༌ཀེམ༌མི༌ ཉེ༌མོའ༌ ཡོད༌ཁན༌ནི༌ འོག༌གི༌ ལྕང༌མའེ༌ ཡོག༌ག༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ཏེ༌ནེ༌ ཁོང༌གུན༌ བེས༌ལ༌ བིང༌ང༌ཅིག༌ དཀོན༌མཆོག༌གི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ལ༌ སྲན༌ཏྲེ༌ ཇིགས༌ཤུག༌ག༌ ཛད༌ཅེས༌པོའེ༌ སུ༌ཞིག༌གིའང༌ ཁོང༌གུན༌ལ༌ ཏེད༌ཏེ༌ མ༌ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ཡ༌ཀོབ༌ དང༌ ཁོ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ནི༌ མི༌གུན༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ལུཟ༌ ༼ཡང༌ན༌ བེ༌ཐེལ༌༽ ཟེར༌ཁན༌ནི༌ ནས༌ས༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ཁོའེ༌ ཏེ༌རུ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌, ཡང༌ ཏེ༌ ནས༌ས༌བོའ༌ ཨེལ༌ བེ༌ཐེལ༌ ༼ཡང༌ན༌ བེ༌ཐེལ༌ལི༌ དཀོན༌མཆོག༌༽ ཟེར༌ཏེ༌ མིང༌ ཏགས༌, ཅིའ༌ཟེར༌ན༌ ཏེན༌ན༌རུ༌ དཀོན༌མཆོག༌གི༌ ཁོང༌རང༌ ཡ༌ཀོབ༌བ༌ སྔོན༌ཅུག༌ག༌ ཛདས༌ ནམ༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨི༌སུ༌ནེ༌ ཤོར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ཏ༌ ར༌བེ༌ཀའེ༌ མ༌ རྒད༌མོ༌ ཡ༌ཏོ༌ དྲེབ༌རཧ༌ ཤི༌ ཡང༌ ཁོའེ༌ སྤུར༌ བེ༌ཐེལ༌ནེ༌ ཐུར༌ལ༌ ཡོད༌ཁན༌ནི༌ འོག༌གི༌ ལྕང༌མའེ༌ ཡོག༌ག༌ སུབས༌ ཡང༌ ཏེ༌བོའ༌ འེ༌ལོན༌ བ༌ཁཐ༌ ༼ཡང༌ན༌ ངུ༌སའེ༌ འོག༌༽ མིང༌ང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ཡ༌ཀོབ༌ པ༌དན༌ཨ༌རམ༌ནེ༌ ལོགས༌ཏེ༌ ཡོང༌ཏེ༌ སྟིང༌ནེ༌ ཁོའ༌ དཀོན༌མཆོག༌ ཡང༌སྐྱར༌ ཇལ༌ ཡང༌ ཅིན༌ལབས༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","དཀོན༌མཆོག༌གི༌ ཁོའ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ མིང༌ ཡ༌ཀོབ༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌རང༌ངི༌ མིང༌ང༌ ཡ༌ཀོབ༌ མན༌པ༌ ཨིས༌ར༌ཨེལ༌ ཟེར༌ཨིན༌།” ཏེ༌བོའེ༌ཕིའ༌ དཀོན༌མཆོག༌གི༌ ཁོའེ༌ མིང༌ང༌ ཨིས༌ར༌ཨེལ༌ ཏག༌ག༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","དཀོན༌མཆོག༌གི༌ ཁོའ༌ མོལས༌, “ངའ༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌ ཨིན༌, ཕྲུ༌གུ༌ སྐྱེ༌ཅུགས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ གྱས༌ཅུག༌། ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌ནེ༌ གྱལ༌ཁམས༌ མང༌པོ༌ དང༌ གྱལ༌པོ༌གུན༌ བིང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ཨབ༌ར༌ཧམ༌ དང༌ ཨི༌སཱག༌ག༌ ཏང༌ཁན༌ནི༌ ས༌ཆ༌བོ༌ ངའེ༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ཏེ༌ནེ༌ དཀོན༌མཆོག༌, ཁོའ༌ ཞལ༌ཏ༌ སལ༌ཁན༌ནི༌ ས༌ཆའེ༌ ཀ༌ནེ༌ ཀེན༌ལ༌ སྐྱོདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","དཀོན༌མཆོག༌གི༌ ཞལ༌ཏ༌ སལ༌ཁན༌ནི༌ ས༌ཆའེ༌ཀ༌ ཡ༌ཀོབ༌བི༌ རྡོའ༌ ཆེན༌མོ༌ ཞིག༌ ཀ༌ཝ༌ ཙོགས༌ལ༌ ལངས༌ཏེ༌ ཏེ༌བོའེ༌ཀ༌ ཆང༌ དང༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ ལུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","དཀོན༌མཆོག༌གི༌ ཁོའ༌ ཞལ༌ཏ༌ སལ༌ཁན༌ནི༌ ས༌ཆ༌བོའ༌ ཁོའེ༌ བེ༌ཐེལ༌ མིང༌ང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ཡ༌ཀོབ༌ དང༌ ཁོའེ༌ ནང༌ཚངས༌, བེ༌ཐེལ༌ནེ༌ ཡང༌སྐྱར༌ བེས༌ལ༌ བིང༌, ཁོང༌གུན༌ ཏ༌རུང༌ ཨེ༌ཕ༌རེད༌ནེ༌ ཐག༌རིང༌ང༌ ཡོད༌ཏུས༌ རེ༌ཅལ༌ལ༌ ཕྲུ༌གུ༌ ཇོར༌ཅེས༌སི༌ ཏུས༌པོ༌ ལེབས༌ཏེ༌ ཁོའ༌ སྐྱེ༌ཟེར༌ སྲན༌ཏྲེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ཁོའ༌ སྐྱེ༌ཟེར༌ སྲན༌ཏྲེ༌ ཡོང༌ ཟ༌ནེ༌, རོགས༌ ཅོ༌ཨིན༌ ཡོད༌ཁན༌ནི༌ བུ༌མོའེ༌ ཁོའ༌ ཟེརས༌, “ཇིགས༌ མ༌ཇིགས༌, ཁྱོ༌རང༌ང༌ ཡང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","རེ༌ཅལ༌ལི༌ སྟིང༌ཇུག༌གི༌ འུགས༌པོ༌ ལེན༌ཨིན༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ མིང༌ང༌ བིན༌འོ༌ནི༌ ཏགས༌ ༼ཀ༌བོའེ༌ ཏོན༌ རྡུག༌པོའེ༌ བུ༌ཚ༌༽ ཨིན༌ནའང༌ ཁོའེ༌ ཨ༌བའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ བེན༌ཡཱ༌མིན༌ ཏགས༌ ༼ཀ༌བོའེ༌ ཏོན༌ ངའེ༌ ལག༌པ༌ ཡས༌པའེ༌ བུ༌ཚ༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ཏེ༌ནེ༌ རེ༌ཅལ༌ ཤི༌ ཡང༌ ཨེ༌ཕ༌རེད༌ལ༌ ཆ༌སའེ༌ ལམ༌མི༌ཀ༌ ཁོའེ༌ སྤུར༌ སུབས༌ ཀ༌བོའ༌ དག༌ས༌ བེད༌ལེ༌ཧེམ༌ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ཁོའེ༌ སྤུར༌ཁང༌ངི༌ཀ༌ ཡ༌ཀོབ༌བི༌ ཀ༌ཝ༌ ཙོགས༌ལ༌ རྡོའ༌ རྩིགས༌། རེ༌ཅལ༌ལི༌ སྤུར༌ཁང༌ངི༌ཀ༌ རྡོའ༌ རྩིགས༌ཁན༌ནི༌ སྟགས༌ དག༌སའང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ཏ༌ ཨིས༌ར༌ཨེལ༌ ཡང༌ན༌ ཡ༌ཀོབ༌བི༌ ཡང༌སྐྱར༌ བེས༌ གོ༌ཟུགས༌ཏེ༌ ལྷོ༌ ཆོགས༌ལ༌ སོང༌ ཡང༌ ཁོ༌རང༌ངི༌ ཀུར༌བོ༌ མིག༌དལ༌ ཨེ༌དར༌ནེ༌ འ༌ཟམ༌མ༌ སོང༌ཏེ༌ ཙུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ཨིས༌ར༌ཨེལ༌ ཏེ༌ ས༌ཆའེ༌ ནང༌ང༌ དུག༌ ཟ༌ནེ༌ རུ༌བེན༌ནི༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ ཚེ༌ཡོག༌ ན༌མ༌ བིལ༌ལཧ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌ལ༌ གྱུས༌སོང༌། ཨིས༌ར༌ཨེལ༌ ཡང༌ན༌ ཡ༌ཀོབ༌བ༌ ཕྲུ༌གུ༌ རྕུག༌ཉིས༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ལི༌ཡའེ༌ བུ༌ཚ༌གུན༌: རུ༌བེན༌ ཡ༌ཀོབ༌བི༌ གོ༌སྐྱེས༌, སི༌མེ༌འོན༌, ལི༌ཝི༌, ཡ༌ཧུ༌དཱ༌, ཨིས༌ས༌ཁར༌ དང༌ ཟེ༌བུ༌ལོན༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","རེ༌ཅལ༌ལི༌ བུ༌ཚ༌གུན༌: ཡོ༌སེབ༌ དང༌ བེན༌ཡཱ༌མིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","རེ༌ཅལ༌ལི༌ ཡ༌ཏོ༌ བུ༌མོ༌ བིལ༌ལཧའེ༌ བུ༌ཚ༌གུན༌: དཱན༌ དང༌ ནཕ༌ཐལ༌ལི༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ལི༌ཡའེ༌ ཡ༌ཏོ༌ བུ༌མོ༌ ཟིལ༌པཧའེ༌ བུ༌ཚ༌གུན༌: གཱད༌ དང༌ ཨ༌ཤེར༌། ཁོང༌གུན༌ པ༌དན༌ཨ༌རམ༌མི༌ ནང༌ང༌ སྐྱེས༌ཁན༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ཡ༌ཀོབ༌ ཁོང༌རང༌ངི༌ ཨ༌བ༌ ཨི༌སཱག༌ ཡོད༌ས༌ མམ༌རེའ༌ ལོགས༌ཏེ༌ ཡོངས༌ ཀ༌བོ༌ ཀི༌རི༌འཐ༌ ཨར༌བ༌ ༼ཡང༌ན༌ ཧེབ༌རོན༌ནི༌༽ ཉེ༌མོའ༌ ཡོད༌པིན༌ ཀ༌རུ༌ ཨབ༌ར༌ཧམ༌ དང༌ ཨི༌སཱག༌ གུན༌ དུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ཨི༌སཱག༌ ལོ༌ 180 སོན༌ཏེའ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ཏེ༌ནེ༌ མི༌ཚེ༌ རིང༌མོ༌ཞིག༌གི༌ སྟིང༌ནེ༌ ཁོའེ༌ སྟིང༌ཇུག༌གི༌ འུགས༌པོ༌ ལེན༌ཏེ༌ བྲོངས༌ ཡང༌ ཁོ༌རང༌ངི༌ ཕ༌མེས༌པོ༌གུན༌ ཉམ༌པོ༌ ཛོམས༌། ཁོའེ༌ བུ༌ཚ༌ ཨི༌སུ༌ དང༌ ཡ༌ཀོབ༌བི༌ ཁོའེ༌ སྤུར༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","འི༌བོ༌ ཨི༌སུའི༌ པུར༌གྱུད༌གུན༌ ཨིན༌ནོག༌, ཁོའ༌ ཨི༌དོམ༌མའང༌ ཟེར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ཨི༌སུའི༌ ཀེ༌ནན༌མ༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌, ཁོང༌གུན༌ ཧེད༌པ༌ ཨི༌ལོན༌ནི༌ བུ༌མོ༌ ཨ༌ད༌, ཨ༌ནཧའེ༌ བུ༌མོ༌, ཧིཝ༌པ༌ ཟི༌བི༌འོན༌ནི༌ ཚ༌མོ༌ ཨོ༌ཧོ༌ལི༌བ༌མཧ༌, ");
INSERT INTO lbj_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ཡང༌ ཨིཤ༌མ༌ཨེལ༌ལི༌ བུ༌མོ༌ དང༌ ནེ༌བཱའེ༌འོད༌དི༌ སྲིང༌མོ༌ བེས༌མད༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ཨི༌སུའི༌ ན༌མ༌ ཨ༌དའ༌ ཨེ༌ལི༌ཕས༌ ཡང༌ བེས༌མེད༌ལ༌ རི༌འུལ༌ བུ༌ཚ༌ གུན༌ སྐྱེས༌, ");
INSERT INTO lbj_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ཡང༌ ཨོ༌ཧོ༌ལི༌བ༌མཧ༌ ཡི༌འུཤ༌, ཡ༌ལམ༌ དང༌ ཀོ༌རཧ༌ གུན༌ སྐྱེས༌། ཁོང༌ ཚང༌མ༌ ཀེ༌ནན༌ནི༌ ཡུལ༌ལ༌ སྐྱེས༌ཁན༌ ཨི༌སུའི༌ བུ༌ཚ༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ཏེ༌ནེ༌ ཨི༌སུའི༌ ཁོ༌རང༌ངི༌ ན༌མ༌གུན༌, བུ༌ཚ༌གུན༌, བུ༌མོ༌གུན༌ ཡང༌ ཁོ༌རང༌ངི༌ ནང༌མི༌ ཚང༌མ༌, ར༌ལུག༌ དང༌ ཞན༌ ཀྲུད༌ཏྲོ༌ གུན༌ ཡང༌ ཁོ༌རང༌ང༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ཇོར༌ཁན༌ནི༌ ནོར༌གུན༌ ཁུར༌ཏེ༌ ཡ༌ཀོབ༌ནེ༌ ཐག༌རིང༌ང༌ ཡང༌ ས༌ཆ༌ཞིག༌ག༌ སོང༌ ");
INSERT INTO lbj_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ལ༌ གྱུར༌ནོར༌ མ༌མང༌པོ༌ ཡོད༌ཅེས༌པའེ༌ ཏེ༌ ས༌ཆ༌བོའེ༌ ནང༌ང༌ ཁོང༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ སེམས༌ཅན༌ ཚང༌མའེ༌ ཕིའ༌ ཟ༌གྱུ༌ དྲན༌དྲའ༌ བིང༌ མ༌ཐུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ཏེ༌བོའེ༌ཕིའ༌ ཨི༌སུ༌ ཡང༌ན༌ ཨི༌དོམ༌, སེ༌འིར༌ རི༌ལྗོངས༌སི༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","འི༌བོ༌ སེ༌འིར༌ རི༌ལྗོངས༌སི༌ ནང༌ང༌ དུག༌ཁན༌ ཨི༌དོམ༌པ༌གུན༌ནི༌ ཨ༌བ༌ ཨི༌སུའི༌ པུར༌གྱུད༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ཨི༌སུའི༌ བུ༌ཚ༌གུན༌ནི༌ མིང༌ ནི༌ ཨི༌སུའི༌ ན༌མ༌ ཨ༌དའེ༌ བུ༌ཚ༌ ཨེ༌ལི༌ཕས༌ དང༌ ཨི༌སུའི༌ ན༌མ༌ བེས༌མེད༌དི༌ བུ༌ཚ༌ རི༌འུལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ཨེ༌ལི༌ཕས༌སི༌ བུ༌ཚ༌གུན༌ ནི༌ ཏི༌མན༌, ཨོ༌མར༌, ཟེ༌ཕོ༌, ག༌ཏམ༌ དང༌ ཀི༌ནཟ༌ གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ཨི༌སུའི༌ བུ༌ཚ༌ ཨེ༌ལི༌ཕས༌སི༌ ཚེ༌ཡོག༌ ན༌མ༌ ཏིམ༌ན༌, ཨ༌མ༌ལིཀ༌ བུ༌ཚ༌བོ༌ སྐྱེས༌། ཁོང༌གུན༌ ཨི༌སུའི༌ ན༌མ༌ ཨ༌དའེ༌ ཚ༌འོ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ཡང༌ རི༌འུལ༌ལི༌ བུ༌ཚ༌གུན༌ ནི༌ ན༌ཧད༌, ཟེ༌རཧ༌, ཤམ༌མཧ༌ དང༌ མི༌ཟཧ༌ གུན༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ ཨི༌སུའི༌ ན༌མ༌ བེས༌མེད༌དི༌ ཚ༌འོ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ཨི༌སུའི༌ ན༌མ༌, ཨ༌ནཧའེ༌ བུ༌མོ༌ དང༌ ཟི༌བི༌འོན༌ནི༌ ཚ༌མོ༌ ཨོ༌ཧོ༌ལི༌བ༌མཧའེ༌ བུ༌ཚ༌ གུན༌ནི༌ ཡི༌འུཤ༌, ཡ༌ལམ༌ དང༌ ཀོ༌རཧ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","འི༌གུན༌ འུ༌སྐྱོང༌ གྱུར༌ཁན༌ནི༌ ཨི༌སུའི༌ པུར༌གྱུད༌གུན༌ ཨིན༌ནོག༌། ཨི༌སུའི༌ གོ༌སྐྱེས༌ ཨེ༌ལི༌ཕས༌སི༌ བུ༌ཚ༌ ཏི༌མན༌, འོ༌མར༌, ཟེ༌ཕོ༌, ཀི༌ནཟ༌ ");
INSERT INTO lbj_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ཀོ༌རཧ༌, ག༌ཏམ༌ དང༌ ཨ༌མ༌ལིཀ༌ གུན༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ ཨི༌དོམ༌མི༌ ནང༌ང༌ དུག༌ཁན༌ ཨེ༌ལི༌ཕས༌སི༌ པུར༌གྱུད༌གུན༌ནི༌ འུ༌སྐྱོང༌གུན༌ ཡང༌ ཨ༌དའེ༌ ཚ༌འོ༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ཨི༌སུའི༌ བུ༌ཚ༌ རི༌འུལ༌ལི༌ བུ༌ཚ༌གུན༌ ནི༌ ན༌ཧད༌, ཟེ༌རཧ༌, ཤམ༌མཧ༌ དང༌ མི༌ཟཧ༌ གུན༌ ཨིན༌པིན༌, ཁོང༌གུན༌ ཨི༌དོམ༌མི༌ ནང༌ང༌ དུག༌ཁན༌ རི༌འུལ༌ལི༌ པུར༌གྱུད༌གུན༌ནི༌ འུ༌སྐྱོང༌གུན༌ ཡང༌ ཨི༌སུའི༌ ན༌མ༌ བེས༌མེད༌དི༌ ཚ༌འོ༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ཨི༌སུའི༌ ན༌མ༌ ཨོ༌ཧོ༌ལི༌བ༌མཧའེ༌ བུ༌ཚ༌གུན༌ ནི༌ ཡི༌འུཤ༌, ཡ༌ལམ༌ དང༌ ཀོ༌རཧ༌ གུན༌ ཨིན༌པིན༌། ཁོང༌གུན༌ ཨ༌ནཧའེ༌ བུ༌མོ༌ ཨི༌སུའི༌ ན༌མ༌ ཨོ༌ཧོ༌ལི༌བ༌མཧའེ༌ པུར༌གྱུད༌གུན༌ནི༌ འུ༌སྐྱོང༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ཏེ༌གུན༌ ཨི༌སུའི༌ པུར༌གྱུད༌གུན༌, ཏེ༌ མི༌སྡེ༌ ཚང༌མ༌ ཨི༌སུ༌ ཡང༌ན༌ ཨི༌དོམ༌མི༌ གྱུད༌ཟིན༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ཨི༌སུའི༌ སང༌ སྔུན༌ལ༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཧོར༌པ༌ སེ༌འིར༌རི༌ བུ༌ཚ༌གུན༌ ནི༌ ལོ༌ཏན༌, ཤོ༌བལ༌, ཟི༌བིའོན༌, ཨ༌ནཧ༌, ");
INSERT INTO lbj_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","དི༌ཤོན༌, ཨེ༌ཟར༌ དང༌ དི༌ཤན༌ གུན༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ ཧོར༌པ༌གུན༌ནི༌ འུ༌སྐྱོང༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ལོ༌ཏན༌ནི༌ བུ༌ཚ༌གུན༌ ནི༌ ཧོ༌རི༌ དང༌ ཧོ༌མམ༌ ཡང༌ ཏིམ༌ན༌ ལོ༌ཏན༌ནི༌ སྲིང༌མོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ཤོ༌བལ༌ལི༌ བུ༌ཚ༌གུན༌ ནི༌ ཨལ༌ཝན༌, མ༌ནཧ༌ཧད༌, ཨེ༌བལ༌, ཤི༌པོ༌ དང༌ འོ༌ནམ༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ཟི༌བི༌འོན༌ནི༌ བུ༌ཚ༌གུན༌ ནི༌ ཨའེ༌ དང༌ ཨ༌ནཧ༌ ཨིན༌པིན༌། ༼ཨ༌ནཧ༌, ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ བུང༌བུ༌གུན༌ ཚོ༌ ཟ༌ནེ༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ ཆུ༌ཚན༌ ཐོབ༌ཁན༌བོ༌ ཨིན༌ནོག༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ཨ༌ནཧའེ༌ ཕྲུ༌གུ༌གུན༌ ནི༌ དི༌ཤོན༌ དང༌ ཨོ༌ཧོ༌ལི༌བ༌མཧ༌ ཨིན༌པིན༌, ཨོ༌ཧོ༌ལི༌བ༌མཧ༌ ནི༌ ཨ༌ནཧའེ༌ བུ༌མོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","དི༌ཤོན༌ནི༌ བུ༌ཚ༌གུན༌ ནི༌ ཧེམ༌དན༌, ཨེཤ༌བན༌, ཨི༌ཐན༌ དང༌ ཀི༌རན༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ཨེ༌ཟར༌རི༌ བུ༌ཚ༌གུན༌ ནི༌ བིལ༌ཧན༌, ཟ༌ཝན༌ དང༌ ཨ༌ཀེན༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","དི༌ཤན༌ནི༌ བུ༌ཚ༌གུན༌ ནི༌ ཨུཟ༌ དང༌ ཨ༌རན༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ཧོར༌པ༌གུན༌ནི༌ འུ༌སྐྱོང༌གུན༌ ལོ༌ཏན༌, ཤོ༌བལ༌, ཟི༌བིའོན༌, ཨ༌ནཧ༌, ");
INSERT INTO lbj_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","དི༌ཤོན༌, ཨེ༌ཟར༌ དང༌ དི༌ཤན༌ གུན༌ ཨིན༌ནོག༌, ཡང༌ ཁོང༌གུན༌ སེ༌འིར༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ དུག༌ཁན༌ ཧོར༌པ༌གུན༌ནི༌ འུ༌སྐྱོང༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱལ༌པོའེ༌ ཝང༌སྲུལ༌ལི༌ སང༌ སྔུན༌ལ༌ ཨི༌དོམ༌ ཡུལ༌ལི༌ ནང༌ང༌ འི༌ གྱལ༌པོ༌གུན༌ནི༌ ཝང༌སྲུལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","བེ༌འོར༌རི༌ བུ༌ཚ༌ བི༌ལ༌ ཨི༌དོམ༌མི༌ གྱལ༌པོ༌ གྱུར༌ ཡང༌ ཁོའེ༌ གྱལ༌སའ༌ དིན༌ཧ༌བད༌ ཟེར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","བི༌ལ༌ ཤིའ༌ཅིག༌ བོཟ༌རཧ༌ གྱལ༌ས༌ནེ༌ ཨིན༌ཁན༌ ཟེ༌རཧའེ༌ བུ༌ཚ༌ ཡོ༌བབ༌ གྱལ༌པོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ཡོ༌བབ༌ ཤིའ༌ཅིག༌ ཏི༌མན༌པའེ༌ ཡུལ༌ནེ༌ ཨིན༌ཁན༌ ཧུ༌ཤམ༌ གྱལ༌པོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ཧུ༌ཤམ༌ ཤིའ༌ཅིག༌ བེ༌དད༌དི༌ བུ༌ཚ༌ ཧ༌དད༌ གྱལ༌པོ༌ གྱུར༌། མོ༌འབ༌ ཡུལ༌ལི༌ ནང༌ང༌ མི༌དིའན༌པ༌གུན༌ལ༌ ཕམ༌ཀལ༌ཁན༌བོ༌ ཁོ༌ ཨིན༌པིན༌ ཡང༌ ཁོའེ༌ གྱལ༌སའ༌ ཨ༌ཝེད༌ ཟེར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ཧ༌དད༌ ཤིའ༌ཅིག༌ མས༌རེ༌ཀཧ༌ནེ༌ ཨིན༌ཁན༌ སམ༌ལཧ༌ གྱལ༌པོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","སམ༌ལཧ༌ ཤིའ༌ཅིག༌ ལྩངས༌པོའེ༌ ཐའ༌མའ༌ ཡོད༌ཁན༌ རེ༌ཧོ༌བོཐ༌ནེ༌ ཨིན༌ཁན༌ ཤོལ༌ གྱལ༌པོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ཤོལ༌ ཤིའ༌ཅིག༌ ཨཀ༌བོར༌རི༌ བུ༌ཚ༌ བའལ༌ ཧ༌ནན༌ གྱལ༌པོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ཨཀ༌བོར༌རི༌ བུ༌ཚ༌ བའལ༌ ཧ༌ནན༌ ཤིའ༌ཅིག༌ ཧ༌དད༌ གྱལ༌པོ༌ གྱུར༌ ཡང༌ ཁོའེ༌ གྱལ༌ས༌ པ༌འུ༌ ཟེར༌རད༌པིན༌། ཁོའེ༌ ན༌མ༌ ནི༌ མི༌ཧེ༌ཏ༌བེལ༌ ཨིན༌ ཁོ༌ མཏ༌རེད༌དི༌ བུ༌མོ༌ དང༌ མི༌ཟ༌ཧབ༌བི༌ ཚ༌མོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","འི༌གུན༌ སྡེ༌ དང༌ ཡུལ༌ཇོངས༌ སོ༌སོ༌ ནང༌ཞིན༌ ཨི༌སུའི༌ པུར༌གྱུད༌དི༌ འུ༌སྐྱོང༌གུན༌ནི༌ མིང༌ ཨིན༌ནོག༌། ཏེ༌གུན༌ ནི༌ ཏིམ༌ན༌, ཨལ༌ཝ༌, ཡི༌ཐེད༌, ");
INSERT INTO lbj_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ཨོ༌ཧོ༌ལི༌བ༌མཧ༌, ཨེ༌ལཧ༌, པི༌ནོན༌, ");
INSERT INTO lbj_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ཀི༌ནཟ༌, ཏི༌མན༌, མིབ༌ཟར༌, ");
INSERT INTO lbj_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","མག༌དེལ༌ དང༌ ཨི༌རམ༌ ཨིན༌ནོག༌། ཏེ༌གུན༌ ཨི༌དོམ༌མི༌ འུ༌སྐྱོང༌གུན༌ ཨིན༌པིན༌, ཀ༌བོ༌ ཁོང༌རང༌གུན༌ནི༌ ས༌ཀྱད༌ ཟུམས༌ཏེ༌ ཚུགས༌ཏེ༌ དུག༌ཁན༌ ནང༌ཞིན༌ ཐོགས༌ཏེ༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ ཨི༌དོམ༌པའེ༌ ཕ༌མེས༌པོ༌ ཨི༌སུའི༌ པུར༌གྱུད༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ཡ༌ཀོབ༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ཁོའེ༌ ཨ༌བ༌ དུག༌སའེ༌ ཏེན༌ན༌ ཡུལ༌ལ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ཡང༌ འི༌བོ༌ ཡ༌ཀོབ༌བི༌ ནང༌ཚངས༌སི༌ ལོ༌རྒྱུས༌ ཨིན༌ནོག༌། ཡོ༌སེབ༌ ལོ༌ ཅུབ༌དུན༌ ཆའ༌ཁན༌ནི༌ ཞུ༌ནུ༌, ཁོའེ༌ ཨ༌བའེ༌ ན༌མ༌ བིལ༌ལཧ༌ དང༌ ཟིལ༌པཧའེ༌ བུ༌ཚ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ ཉམ༌པོ༌ ར༌ལུག༌ ཚོའད༌པིན༌, ཨ༌ཅོ༌གུན༌ནི༌ ལས༌ ངན༌པ༌ ཅོ༌ཁན༌ཞིག༌གི༌ སྐོར༌ ཁོའེ༌ ཨ༌བ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ཡ༌ཀོབ༌བི༌ ཡོ༌སེབ༌བ༌ ཁོ༌རང༌ངི༌ ཞན༌ བུ༌ཚ༌གུན༌ནི༌ སང༌ མང༌ང༌ ཡ༌ཤ༌ ཅོའད༌པིན༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ སྒས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཡོ༌སེབ༌ སྐྱེས༌ཏེ༌ ཨིན༌པིན༌། ཁོའེ༌ ཡོ༌སེབ༌བི༌ ཕིའ༌ མིག༌སལ༌ ཀོས༌ཤིག༌ ཙེམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ཁོའེ༌ ཨ༌ཅོ༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ ཨ༌བའེ༌ ཡོ༌སེབ༌བ༌ ཚང༌མའེ༌སང༌ མང༌ང༌ ཡ༌ཤ༌ ཅོ༌ཅེས༌པོ༌ ཐོང༌ང༌ཅིག༌, ཁོང༌གུན༌ནི༌ ཁོའ༌ ནཕ༌རད༌ ཅོས༌ཏེ༌ ཁོ༌ ཉམ༌པོ༌ སྤེ༌ར༌ ལྡེ༌མོའ༌ ཏང༌ང༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ཡོ༌སེབ༌བ༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌ ཡང༌ ཁོའེ༌ ཏེ༌བོ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ལ༌ ཤད༌ད༌ཅིག༌ ཁོང༌གུན༌ནི༌ ཁོའ༌ མང༌ང༌ ནཕ༌རད༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ང༌ ཐོང༌ཁན༌ནི༌ ཉི༌ལམ༌བོའ༌ ཉོན༌ནའང༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ང༌དང༌ ཚང༌མའེ༌ ཞིང༌ངི༌ཀ༌ གྲུའི༌ ཞིང༌གུན༌ ལྡམ༌ དུག༌པིན༌། ངའེ༌ གྲུའི༌ ཞིང༌བོ༌ ཀྲོང༌ལངས༌ ཡང༌ ཏེ༌བོའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གྲུའི༌ ཞིང༌གུན༌ ཁོར༌ཏེ༌ གོ༌ སྒུས༌ཏེ༌ དུག༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ཁོའེ༌ ཨ༌ཅོ༌གུན༌ནི༌ ཟེརས༌, “ཅི༌ ཁྱོ༌རང༌ངི༌ ང༌ཞ༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ཨིན༌ སམ༌མ༌ རག༌ག༌?” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ ཟེར༌ཁན༌ དང༌ ཉི༌ལམ༌བོའེ༌ ཞས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཁོའ༌ མང༌ང༌ ནཕ༌རད༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ཏེ༌ནེ༌ ཡོ༌སེབ༌བ༌ ཡང༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌ ཡང༌ ཁོའེ༌ ཨ༌ཅོ༌གུན༌ལ༌ ཟེརས༌, “ཉོན༌ཤིག༌གའང༌, ང༌ ཡང༌ ཉི༌ལམ༌ ཞིག༌གི༌ ནང༌ང༌ ཉི༌མ༌, ཟླ༌ཝ༌, ཡང༌ སྐར༌མ༌ ཅུག༌ཤིག༌ གུན༌ནི༌ ངའེ༌ དུན༌ལ༌ གོ༌ སྒུ༌ཨིན༌ ཐོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ཁོའེ༌ ཉི༌ལམ༌བོ༌ ཁོ༌རང༌ངི༌ ཨ༌བའང༌ ཤདས༌པ༌ ཨ༌བའེ༌ ཁོའ༌ ཁའ༌སྐྱེས༌ཏེ༌ ཟེརས༌, “ཁྱོ༌རང༌ང༌ ཐོང༌ཁན༌ནི༌ ཉི༌ལམ༌བོ༌ ཅི༌ ཨིན༌ནོག༌? ཅི༌ ཁྱོ༌རང༌ངི༌ ཨ༌མ༌, ཨ༌ཅོ༌ནོ༌གུན༌ དང༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ དུན༌ལ༌ གོ༌ སྒུ༌ཨིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ཡོ༌སེབ༌བི༌ ཨ༌ཅོ༌གུན༌ལ༌ ཁོའེ༌ཀ༌ ཚིག༌ཅེས༌ ཡོངས༌, ཨིན༌ནའང༌ ཁོའེ༌ ཨ༌བའེ༌ ཏེ༌ ཚང༌མའེ༌ སྐོར༌ལ༌ སམ༌བ༌ ཏང༌ཨིན༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ཡོ༌སེབ༌བི༌ ཨ༌ཅོ༌གུན༌ ཤེ༌ཀེམ༌མ༌ ཁོ༌རང༌གུན༌ནི༌ ཨ༌བའེ༌ ར༌ལུག༌གི༌ ཁྱུ༌གུན༌ ཚོའ༌ སོང༌ཏེ༌ ཡོད༌ཏུས༌, ");
INSERT INTO lbj_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ཡ༌ཀོབ༌བི༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ ཤེ༌ཀེམ༌མི༌ ནང༌ང༌ ར༌ལུག༌ ཚོ༌ཨིན༌ ཡོད༌ཁན༌བོ༌ ཁྱོ༌རང༌ང༌ གྱུས༌ ཨིན༌ནོག༌། ཡོང༌, ངའེ༌ ཁྱོ༌རང༌ ཁོང༌གུན༌ ཡོད༌ས༌ ལམ༌ ཅུག༌གད༌།” ཡོ༌སེབ༌བི༌ ལན༌ཏངས༌, “ང༌ ཆ༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཨིན༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ཁོའེ༌ ཨ༌བའེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ དང༌ ར༌ལུག༌གུན༌ ཁམ༌ཟང༌ དུག༌ག༌ མི༌དུག༌ ལྟའ༌ སོང༌ཏེ༌ ངའ༌ ཁོང༌གུན༌ནི༌ སྐོར༌ལ༌ ནས༌ཚུལ༌ ཁྱོང༌།” ཏེ༌ནེ༌ ཁོའེ༌ ཡོ༌སེབ༌ ཧེབ༌རོན༌ནི༌ ལུང༌པ༌ནེ༌ ལམ༌ཅུགས༌། ཡོ༌སེབ༌ ཤེ༌ཀེམ༌མ༌ ལེབ༌བ༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","མི༌ཞིག༌གི༌ ཁོ༌ སྤང༌ཐང༌གུན༌ནི༌ ནང༌ང༌ ཁོར༌ཨིན༌ ཐོང༌ཏེ༌ ཏྲིས༌, “ཁྱོ༌རང༌ངི༌ ཅི༌ ཙལ༌ལད༌?” ");
INSERT INTO lbj_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ཁོའེ༌ ཟེརས༌, “ངའེ༌ ང༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ ཙལ༌ལད༌། ཇུ༌ཇུ༌ ང༌ ཤོད༌དའང༌ ཁོང༌གུན༌ནི༌ ར༌ལུག༌གུན༌ ཀ༌རུ༌ ཚོ༌ཨིན༌ དུག༌?” ");
INSERT INTO lbj_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","མི༌བོའེ༌ ཟེརས༌, “ཁོང༌གུན༌ སོང༌ཚར༌། ཁོང༌གུན༌ནི༌ ‘ང༌དང༌ དོ༌ཐན༌ལ༌ ཆེན༌’ ཟེར༌ཨིན༌ ངའེ༌ ཚོར༌།” ཏེ༌བོའེ༌ཕིའ༌ ཡོ༌སེབ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ དོ༌ཐན༌ལ༌ སོང༌ ཡང༌ ཁོང༌གུན༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ཁོང༌གུན༌ནི༌ ཐག༌རིང༌ནེ༌ ཡོ༌སེབ༌ ཡོང༌ཨིན༌ ཐོང༌ ཡང༌ ཁོ༌ དུན༌ལ༌ ལེབ༌བི༌ སང༌ སྔུན༌ལ༌ ཁོང༌གུན༌ནི༌ ཁོ༌ སད༌ཅེས༌སི༌ ཅུས༌ངན༌ ལྡིངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ཁོང༌གུན༌ནི༌ ཅིག༌ དང༌ ཅིག༌ག༌ ཟེརས༌, “འི༌ནེ༌ ཉི༌ལམ༌མི༌ གྱལ༌པོ༌ ཡོང༌ང༌ལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ཡོང༌, ཁོ༌ སད༌ཏེ༌ འི༌ ས༌དོང༌ ཅིག༌གི༌ ནང༌ང༌ ཕང༌ཨིན༌, ཡང༌ ཨ༌བའ༌ ཁོ༌ རིའི༌ སེམས༌ཅན༌ནི༌ སད༌ཏོག༌ ཟེར༌ཨིན༌། ཏེ༌ནེ༌ ཁོའེ༌ ཉི༌ལམ༌གུན༌ལ༌ ཅི༌ ཆ༌རུག༌ ང༌དང༌ངི༌ ལྟེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","རུ༌བེན༌ནི༌ ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ ཡོ༌སེབ༌ སྐྱོབ༌ཅེས༌ལ༌ ཁོའེ༌ ཟེརས༌, “ཁོ༌ སད༌ མ༌སད༌ད༌, ");
INSERT INTO lbj_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","འི༌ རི༌སྟོང༌ངི༌ ས༌དོང༌ ཅིག༌གི༌ ནང༌ང༌ ཕང༌ཨིན༌ ཨིན༌ནའང༌ ཁོའ༌ རྡུང༌ མི༌ རྡུང༌།” ཡོ༌སེབ༌ སྐྱོབས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ཀ༌ ལོགས༌ཏེ༌ ཁྱེར༌ཅེས༌ལ༌ ཁོའེ༌ ཏེ༌བོ༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ཏེ༌ནེ༌ ཡོ༌སེབ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ ཡོད༌ས༌ ལེབ༌བ༌ཅིག༌ ཁོང༌གུན༌ནི༌, ཁོའ༌ ཨ༌བའེ༌ ཏངས༌ཁན༌ནི༌ ཀོས༌པོ༌ ཕུདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཁོ༌ ཟུམས༌ཏེ༌ ཆུ༌ མེད༌ཁན༌ནི༌ ས༌དོང༌ སྐམ༌པོའེ༌ ནང༌ང༌ ཕངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ཁོང༌གུན༌ ཟན༌ཟའ༌ལ༌ དུག༌ག༌ཅིག༌ ཁོང༌གུན༌ནི༌ གི༌ལེད༌ནེ༌ ཡོང༌ཁན༌ ཨིཤ༌མ༌ཨེལ༌པ༌ བེས༌པ༌གུན༌ ཐོང༌། ཁོང༌གུན༌ནི༌ རྔ༌བོང༌གུན༌ལ༌ ཚ༌མིག༌, བའམ༌ དང༌ མའེར༌ སྐངས༌ཁན༌ནི༌ རྒལ༌ ཀལ༌ཏེ༌ ཁོང༌གུན༌ ཨི༌ཇིབ༌ ཡུལ༌ལ༌ ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ཡ༌ཧུ༌དཱའེ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ལ༌ ཟེརས༌, “ང༌དང༌གུན༌ནི༌ ནོ༌ སད༌ཏེ༌ ཁོ༌ སད༌ཁན༌བོ༌ སྦས༌ཏེ༌ བོར༌ན༌ ང༌དང༌གུན༌ལ༌ ཅི༌ ཕན༌ཐོགས༌ ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ཡོང༌, ང༌དང༌ངི༌ ཁོ༌ མ༌སད༌ད༌ འི༌ ཨིཤ༌མ༌ཨེལ༌པ༌ བེས༌པ༌གུན༌ལ༌ ཙོང༌ཨིན༌, ཅིའ༌ཟེར༌ན༌ ཁོ༌ ང༌དང༌ངི༌ ནོ༌, ང༌དང༌ངི༌ ཤ༌ཁྲག༌ ཨིན༌ནོག༌།” ཁོའེ༌ ཨ༌ཅོ༌ནོ༌གུན༌ནི༌ ཁའ༌ ཆམས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ཏེ༌ནེ༌ མི༌དིའན༌པ༌ ཚོང༌པ༌གུན༌ ཉེ༌མོའ༌ ལེབ༌བ༌ཅིག༌, ཁོང༌གུན༌ནི༌ ཡོ༌སེབ༌ ས༌དོང༌ནེ༌ ཕིངས༌ཏེ༌ ཨིཤ༌མ༌ཨེལ༌པ༌གུན༌ལ༌ མུལ༌ལི༌ པེ༌ནེ༌ ཉི༌ཤུའ༌ ཙོངས༌, ཀ༌གུན༌ནི༌ ཁོ༌ ཨི༌ཇིབ༌ ཡུལ༌ལ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","རུ༌བེན༌ ས༌དོང༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ཡོངས༌ ཡང༌ ཁོའ༌ ཡོ༌སེབ༌ ཏེ༌ནང༌ང༌ མེད༌ཁན༌བོ༌ ཐོང༌ཏེ༌ ཁོའ༌ ཚེར༌ཁ༌ ཡོངས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཀོས༌པོ༌ ཤགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ཁོ༌ ལོགས༌ཏེ༌ ཁོ༌རང༌ངི༌ ནོ༌གུན༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “ས༌དོང༌ངི༌ ནང༌ང༌ བུ༌ཚ༌བོ༌ མི༌དུག༌, ཏ༌ ངའེ༌ ཅི༌ ཅོ༌?” ");
INSERT INTO lbj_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ར༌མ༌ཞིག༌ སདས༌ ཡང༌ ཡོ༌སེབ༌བི༌ ཀོས༌པོ༌ ཏེ༌བོའེ༌ ཁྲག༌གི༌ ནང༌ང༌ སྦངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ཁོང༌གུན༌ནི༌ ཏེ༌ ཀོས༌པོ༌ ཁོ༌རང༌གུན༌ནི༌ ཨ༌བའ༌ ཁྱེརས༌ ཡང༌ ཟེརས༌, “འི༌ ཀོས༌པོ༌ ང༌ཞའ༌ ཐོབ༌, ཟིགས༌སའང༌ འི༌བོ༌ ཉེ༌རང༌ངི༌ བུ༌ཚའེ༌ ཏ༌ མ༌ནོག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ཡ༌ཀོབ༌བ༌ ཏེ༌བོ༌ ཁོའེ༌ བུ༌ཚ༌ ཡོ༌སེབ༌བི༌ ཨིན༌ཁན༌ ཤེས༌ ཡང༌ ཟེརས༌, “ཏན༌ཏན༌ རི༌ སེམས༌ཅན༌ནི༌ ངའེ༌ བུ༌ཚ༌ ཡོ༌སེབ༌ སད༌ཏེ༌ ཁོའེ༌ ཟུགས༌པོ༌ ཏུམ༌པ༌ ཏུམ༌པ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ ཀོས༌པོ༌ ཤགས༌ ཡང༌ ཕ༌ཙའེ༌ རས༌ གོན༌ཏེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ ཕིའ༌ ཞག༌ མང༌པོ༌ ཉ༌ངན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ཁོའེ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཚང༌མ༌ ཁོའ༌ སེམས༌སོ༌ ཏང༌ང༌ ཡོངས༌ ཨིན༌ནའང༌ ཁོའེ༌ སེམས༌སོ༌ མ༌ལེནས༌ ཡང༌ ཟེརས༌, “མན༌ ངའེ༌ ཤི༌ཤི༌ ཚོག༌པ༌ ང༌རང༌ངི༌ བུ༌ཚའེ༌ ཕིའ༌ ཉ༌ངན༌ ཅོ༌ཨིན༌།” ཡང༌ ཁོ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ ཕིའ༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ཏེན༌ན༌ ཏུས༌ལ༌ མི༌དིའན༌པ༌གུན༌ནི༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཡོ༌སེབ༌ པོ༌ཏི༌ཕར༌ལ༌ ཙོངས༌, ཁོ༌ གྱལ༌པོ༌ ཕེ༌རོའེ༌ ལས༌ཅེད༌པ༌, གྱལ༌པོ༌ སྲུང༌ཁན༌ནི༌ མག༌མི༌གུན༌ནི༌ འུ༌སྐྱོང༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ཏེན༌ན༌ ཏུས༌ཤིག༌ག༌ ཡ༌ཧུ༌དཱ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ བོར༌ཏེ༌ ཨ༌དུལ༌ལམ༌པ༌ ཧི༌རཧ༌ ཟེར༌ཁན༌ནི༌ མི༌བོ༌ ཉམ༌པོ༌ དུག༌ག༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ཏེ༌རུ༌ ཡ༌ཧུ༌དཱ༌ ཀེ༌ནན༌མ༌ ཤུའ༌ ཟེར༌ཁན༌ནི༌ བུ༌མོ༌ ཐུག༌ ཡང༌ ཁོའེ༌ ཏེ༌ བུ༌མོ༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌ཏེ༌ ལུས༌བྲེལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ཁོ༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ ཁོའ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ ཡང༌ ཡ༌ཧུ༌དཱའེ༌ ཁོའེ༌ མིང༌ང༌ ཨེར༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","བུ༌མོ༌ ཡང༌སྐྱར༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ ཡང༌ ཁོའ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌། ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ འོ༌ནན༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ཀ༌ཟིབ༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ ཁོའ༌ བུ༌ཚ༌ སུམ༌པ༌ ཇོར༌ ཡང༌ ཁོའེ༌ མིང༌ང༌ ཤེ༌ལག༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ཡ༌ཧུ༌དཱའེ༌ ཁོའེ༌ གོ༌བུ༌ བུ༌ཚ༌ ཨེར༌ལ༌ ཏ༌མར༌ ཟེར༌ཁན༌ནི༌ བུ༌མོ༌ ན༌མའ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ཨིན༌ནའང༌ ཡ༌ཧུ༌དཱའེ༌ གོ༌བུ༌ བུ༌ཚ༌ ཨེར༌རི༌ སྕོད༌པ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཡོད༌པ༌ ཡ༌ཝའེ༌ ཁོ༌ ཤི༌ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ཏེ༌ནེ༌ ཡ༌ཧུ༌དཱའེ༌ འོ༌ནན༌ལ༌ ཟེརས༌, “སོང༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོའེ༌ པུར༌གྱུད༌ ལུས༌ཤེས༌ལ༌ ཁོའེ༌ ན༌མ༌ ཉམ༌པོ༌ བྲེལ༌ བོར༌ཏེ༌ ཁོའེ༌ མག༌པའེ༌ ནོ༌ ཨིན༌ཁན༌ནི༌ ཁག༌པོ༌ དྲན༌དྲའ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ཨིན༌ནའང༌ འོ༌ནན༌ལ༌ ཕྲུ༌གུ༌ ཇོར༌ཁན༌གུན༌ ཁོའེ༌ པུར༌གྱུད༌ མི༌ གྱུར༌ཅེས༌པོ༌ ཧ༌གོ༌པ༌ ཁོའེ༌ ཨ༌ཅོའེ༌ ན༌མའ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོ༌ ཟ༌ནེ༌ ཕྲུ༌གུ༌ མི༌ཇོར༌ཅེས༌ལ༌ ཁོའེ༌ ཐིག༌ལེ༌བོ༌ སའེ༌ཀ༌ ཕོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ཨིན༌ནའང༌ ཁོའེ༌ ཅོ༌ཁན༌ནི༌ ལས༌པོ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཨིན༌ པ༌སང༌ ཡ༌ཝའེ༌ ཨོ༌ནན༌ནའང༌ ཤི༌ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ཏེ༌ནེ༌ ཡ༌ཧུ༌དཱའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ ན༌མ༌ ཏ༌མར༌ལ༌ ཟེརས༌, “ངའེ༌ བུ༌ཚ༌ ཤེ༌ལག༌ ཆེན༌མོ༌ ཆ༌ཆ༌ ཚག༌པ༌ ཁྱོ༌རང༌ ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པ༌ ཡུག༌ས༌མོ༌ ཚུལ༌ལ༌ དུག༌” ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ སམ༌, “ཁོའང༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ ཙོགས༌ལ༌ ཤི༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ཏེ༌ནེ༌ ཏ༌མར༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པ༌ དུག༌ག༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ལོ༌ མང༌པོ༌ཞིག༌གི༌ སྟིང༌ནེ༌ ཤུའི༌ བུ༌མོ༌, ཡ༌ཧུ༌དཱའེ༌ ན༌མ༌ ཤི༌། ཉ༌ངན༌ནི༌ ཏུས༌པོ༌ ཚར༌ཏེ༌ ཁོ༌རང༌ངི༌ ཛ༌འོ༌ ཨ༌དུལ༌ལམ༌པ༌ ཧི༌རཧ༌ ཉམ༌པོ༌ ཡ༌ཧུ༌དཱ༌ ཏིམ༌ནཧ༌ ཡུལ༌ལ༌ ཁོ༌རང༌ངི༌ ལུག༌གི༌ བལ༌ བྲག༌ཁན༌གུན༌ ཡོད༌ས༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ཏ༌མར༌ལ༌ ཤདས༌, “ཁྱོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌བ༌, ཁོ༌རང༌ངི༌ ལུག༌གུན༌ནི༌ བལ༌ བྲག༌ག༌ལ༌ ཏིམ༌ནཧ༌ ཆ༌རུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ཁོའེ༌ ཁོ༌རང༌ གོན༌ཁན༌ནི༌ ཡུག༌ས༌མོའི༌ ཀོས༌པོ༌ ཞེབས༌ཏེ༌ མི༌ ཤེ༌ཤེས༌སི༌ ཕིའ༌ ཁོ༌རང༌ངི༌ ལྡོང༌བོ༌ རས༌ ཉམ༌པོ༌ ཀབས༌ ཡང༌ ཏིམ༌ནཧ༌ ཆ༌སའེ༌ ལམ༌མི༌ཀ༌ ཨི༌ནེམ༌ གྲོང༌ཁྱེར༌ལ༌ ཆ༌སའེ༌ཀ༌ དུགས༌, ཅིའ༌ཟེར༌ན༌ ཡ༌ཧུ༌དཱའེ༌ བུ༌ཚ༌ ཤེ༌ལག༌ ལྡན༌ཏེ༌ ཡོད༌ནའང༌ ཁོ༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོ༌ཅེས༌ལ༌ མ༌ཏང༌ང༌ ཨིན༌ཁན༌བོ༌ ཁོའ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ཡ༌ཧུ༌དཱའེ༌ བུ༌མོ༌བོ༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཁོ༌ ཟུགས༌ཙོང༌མ༌ཞིག༌ ཨིན༌ནོག༌ སམ༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ལྡོང༌བོ༌ ཀབས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ཡང༌ ཁོའེ༌ བུ༌ཚའེ༌ ན༌མ༌ ཨིན༌ཁན༌བོ༌ མ༌ཤས༌པ༌ ཁོ༌ ཏེ༌ བུ༌མོའེ༌ དུན༌ལ༌ སོང༌ཏེ༌ ཟེརས༌, “ལུས༌བྲེལ༌ ཅོའ༌ལ༌ ངའ༌ ཉམ༌པོ༌ ཡོང༌།” ཁོའེ༌ ཏྲིས༌, “ཉེ༌རང༌ ཉམ༌པོ༌ དུག༌ཅེས༌ལ༌ ཉེ༌རང༌ངི༌ ང༌ ཅི༌ ཏང༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ཁོའེ༌ ལན༌ཏངས༌, “ང༌རང༌ངི༌ ཁྱུའི༌ ནང༌ནེ༌ རི༌གུ༌ཞིག༌ ཀལ༌ཨིན༌།” བུ༌མོའེ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ དམ༌ཆ༌ ཅོ༌ཁན༌བོའེ༌ སྟགས༌སི༌ ཚུལ༌ལ༌ ང༌ ཅི༌ཏོང༌ཤིག༌ སལ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ཁོའེ༌ ཏྲིས༌, “དམ༌ཆའེ༌ ཚུལ༌ལ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཅི༌ ཏང༌?” བུ༌མོའེ༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ ཐེ༌ཙེ༌ སེར༌དུབ༌, ཏེ༌བོ༌ ཏགས༌ཁན༌ནི༌ རས༌ཀུད༌ དང༌ ཁུར༌ཁན༌ནི༌ བེར༌ཀ༌ གུན༌ སལ༌།” ཁོའེ༌ ཏེ༌ ཚང༌མ༌ ཁོའ༌ ཏངས༌ཏེ༌ ཁོ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོས༌པ༌ བུ༌མོ༌བོ༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ཏ༌མར༌ ལོགས༌ཏེ༌ ཁང༌པ༌ སོང༌ ཡང༌ ལྡོང༌ང༌ ཀབ༌ཁན༌བོ༌ ཕུད༌ཏེ༌ ཁོ༌རང༌ངི༌ ཡུག༌ས༌མོའི༌ ཀོས༌པོ༌ གོནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ཡ༌ཧུ༌དཱའེ༌ ཁོ༌རང༌ངི༌ ཛ༌འོ༌ ཨ༌དུལ༌ལམ༌པ༌ ཧི༌རཧ༌ ཏེ༌ བུ༌མོའ༌ རི༌གུ༌ ཁྱེར༌ཏེ༌ དམ༌ཆ༌ ཅོས༌ཏེ༌ ཏང༌ཁན༌ནི༌ ཅ༌ལག༌གུན༌ ལོགས༌ཏེ༌ ཁྱོང༌ཅེས༌ལ༌ ལམ༌ཅུགས༌, ཨིན༌ནའང༌ ཁོའ༌ བུ༌མོ༌བོ༌ མ༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ཁོའེ༌ ཏེ༌རུ༌ དུག༌ཁན༌ནི༌ མི༌ ཁ༌ཅིག༌ག༌ ཏྲིས༌, “ཨི༌ནེམ༌མི༌ དུན༌ལ༌ འི༌ ལམ༌མི༌ཀ༌ དུག༌ཁན༌ནི༌ ཟུགས༌ཙོང༌མ༌བོ༌ ཀ༌རུ༌ སོང༌?” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “འི༌རུ༌ ཟུགས༌ཙོང༌མ༌ཞིག༌ མ༌ནེ༌ མེད༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ཁོ༌ ལོགས༌ཏེ༌ ཡ༌ཧུ༌དཱ༌ ཡོད༌ས༌ སོང༌ ཡང༌ ཟེརས༌, “ངའ༌ ཏེ༌ བུ༌མོ༌བོ༌ མ༌ཐོབ༌, ཡང༌ ཏེ༌རུ༌ དུག༌ཁན༌གུན༌ནི༌ ‘འི༌རུ༌ ཟུགས༌ཙོང༌མ༌ཞིག༌ མ༌ནེ༌ མེད༌’ ཟེར༌ར༌རག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ཡ༌ཧུ༌དཱའེ༌ ཟེརས༌, “ཁོའེ༌ ལག༌ག༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁོའ༌ བོར༌ཅུག༌ ཏེ༌ མན༌ན༌ ང༌དང༌གུན༌ སམ༌བ༌ མེད༌ཁན༌ ཐེས༌ཏེ༌ ཁྲེལ༌བ༌ ཆེན༌། ངའེ༌ ཁ༌ཆད༌ ཅོ༌ཁན༌ ནང༌ཞིན༌ རི༌གུ༌ ཀལ༌པིན༌ ཨིན༌ནའང༌ ཁྱོ༌རང༌ང༌ ཁོ༌ མ༌ཐོབ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ཟླ༌ཝ༌ སུམ༌མི༌ སྟིང༌ནེ༌ ཡ༌ཧུ༌དཱའ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ ན༌མ༌ ཏ༌མར༌ ཟུགས༌ཙོང༌མ༌ གྱུར༌ཏེ༌ ཁོའ༌ ཕྲུ༌གུ༌ སྐྱེ༌ཅེས༌དུག༌ ཟེར༌ཏེ༌ ཚོར༌། ཡ༌ཧུ༌དཱའེ༌ ཟེརས༌, “བུ༌མོ༌བོ༌ ཕི༌ལོག༌ག༌ ཕིངས༌ཏེ༌ མེའ༌ སྲགས༌ཏེ༌ སོད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","བུ༌མོ༌བོ༌ ཕི༌ལོག༌ག༌ ཁྱོང༌ ཟ༌ནེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌བ༌ ལོན༌ ཀལས༌། ཁོའེ༌ ཟེརས༌, “འི༌ ཅ༌ལག༌གུན༌ནི༌ དག༌པོའེ༌ ང༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཅུགས༌། ཟིགས༌སའང༌, འི༌ ཐེ༌ཙེ༌, ཏེ༌བོ༌ ཏགས༌ཁན༌ནི༌ རས༌ཀུད༌ དང༌ བེར༌ཀ༌ གུན༌ སུའི༌ ཨིན༌ནོག༌?” ");
INSERT INTO lbj_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ཡ༌ཧུ༌དཱའེ༌ ཏེ༌གུན༌ ཤེས༌ ཡང༌ ཟེརས༌, “ང༌ སང༌ མང༌ང༌ བུ༌མོ༌བོ༌ ཀྲང༌པོ༌ ཨིན༌ནོག༌, ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁོའ༌ ང༌རང༌ངི༌ བུ༌ཚ༌ ཤེ༌ལག༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོ༌ མ༌ཅུག༌ག༌ ཨིན༌ནོག༌།” ཡང༌ ཡ༌ཧུ༌དཱའེ༌ ཁོ༌ ཉམ༌པོ༌ ཡང༌སྐྱར༌ ལུས༌བྲེལ༌ མ༌ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ཏ༌མར༌ལ༌ ཕྲུ༌གུ༌ སྐྱེ༌ཅེས༌སི༌ ཏུས༌པོ༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ ཁོག༌པའེ༌ ནང༌ང༌ ཚག༌ཕྲུག༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ཁོའ༌ ཕྲུ༌གུ༌ སྐྱེ༌ ཟ༌ནེ༌ ཅིག༌པོའེ༌ ལག༌པ༌ བིང༌ང༌ཅིག༌ ཡ༌ཏོ༌ ཅོ༌ཁན༌བོའེ༌ སྐུད༌པ༌ མར༌པོ༌ཞིག༌ ལྡམས༌ཏེ༌ ཟེརས༌, “འི༌ བུ༌ཚ༌བོ༌ གོ༌མ༌ སྐྱེས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ཨིན༌ནའང༌ ཁོའེ༌ ལག༌པ༌ ལོགས༌ཏེ༌ ནང༌ཀུག༌ག༌ ཁྱེརས༌ ཡང༌ ཁོའེ༌ སང༌ སྔུན༌ལ༌ ཡང༌ ཅིག༌པོ༌ སྐྱེས༌། ཏེ༌ནེ༌ ཡ༌ཏོ༌བོའེ༌ ཟེརས༌, “ཁྱོ༌རང༌ ཝང༌ ཏངས༌ཏེ༌ ཕི༌ལོག༌ག༌ བིང༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ མིང༌ང༌ པེ༌རེཟ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ཏེ༌ནེ༌ ཁོའེ༌ ནོ༌ ལག༌པའ༌ སྐུད༌པ༌ མར༌པོ༌ ལྡམས༌ཁན༌བོ༌ སྐྱེས༌ ཡང༌ ཁོའེ༌ མིང༌ང༌ ཟེ༌རཧ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ཡོ༌སེབ༌ ཨི༌ཇིབ༌བ༌ ཁྱེརས༌, ཏེ༌རུ༌ ཁོ༌ གྱལ༌པོ༌ ཕེ༌རོ༌ སྲུང༌ཁན༌ མག༌མི༌གུན༌ནི༌ སྤོན༌བོ༌ པོ༌ཏི༌ཕར༌རི༌ ཨིཤ༌མ༌ཨེལ༌པ༌ ཚོང༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཉོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ཡ༌ཝ༌ ཡོ༌སེབ༌ ཉམ༌པོ༌ ཡོད༌པིན༌ ཡང༌ ཁོ༌ ཅི༌ཚང༌མའེ༌ ནང༌ང༌ ཁྲངས༌པོ༌ མི༌ཞིག༌ གྱུར༌, ཁོ༌ ཨི༌ཇིབ༌པ༌ སྤོན༌བོའེ༌ ཁང༌པའེ༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ཡ༌ཝ༌ ཡོ༌སེབ༌ ཉམ༌པོ༌ ཞུགས༌ཁན༌ ཡང༌ ཁོ༌ ཅི༌ཚང༌མའེ༌ ནང༌ང༌ ཁྲངས༌པོ༌ གྱུར༌ ཅུག༌ག༌ ཛད༌ཁན༌བོ༌ ཁོའེ༌ སྤོན༌བོའེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ཡོ༌སེབ༌བ༌ པོ༌ཏི༌ཕར༌རི༌ ཆོགས༌སྐྱོར༌ ཐོབ༌ཏེ༌ ཁོའ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌བོ༌ གྱུར༌། པོ༌ཏི༌ཕར༌རི༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཁང༌པ༌ དང༌ གྱུ༌ནོར༌གུན༌ནི༌ སྟ༌སྟོག༌ ཅོ༌ཁན༌ལ༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","པོ༌ཏི༌ཕར༌རི༌ ཡོ༌སེབ༌ ཁོ༌རང༌ངི༌ ཁང༌པ༌ དང༌ གྱུ༌ནོར༌གུན༌ནི༌ སྟ༌སྟོག༌ ཅོ༌ཁན༌ལ༌ སྐོས༌པ༌ནེ༌ ཕར༌ལ༌ ཡ༌ཝའེ༌ པོ༌ཏི༌ཕར༌རི༌ ནང༌ཚངས༌ལ༌ ཅིན༌ལབས༌ སལས༌། ཡོ༌སེབ༌བི༌ ཞས༌ཏེ༌ ཡ༌ཝའེ༌ ཁོའ༌ ཅི༌ཚང༌མའེ༌ ནང༌ང༌ ཅིན༌ལབས༌ སལས༌, ཁང༌པ༌ དང༌ ཞིང༌ ཉིས༌ཀོའེ༌ ནང༌ང༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ཏེ༌བོའེ༌ཕིའ༌ པོ༌ཏི༌ཕར༌རི༌ ཁོའ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཡོ༌སེབ༌བི༌ ལག༌ག༌ སྟདས༌ ཡང༌ ཁོའ༌ ཁོ༌རང༌ངི༌ ཁར༌ཇི༌ མ༌ནེ༌ ཞན༌ ཅི༌ཞིག༌གི༌ ཕིའང༌ ཚེར༌ཁ༌ མེད༌པིན༌། ཡོ༌སེབ༌ སྒོབ༌ཞག༌ཅན༌ དང༌ ངམས༌ཅན༌ ཡོད༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ཡང༌ ཏུས༌བན༌ཤིག༌གི༌ སྟིང༌ནེ༌ ཁོའེ༌ སྤོན༌བོའེ༌ ན༌མ༌ ཡོ༌སེབ༌བི༌ཀ༌ དོད༌པ༌ སྐྱེས༌ཏེ༌ ཟེརས༌, “མལ༌ཙའེ༌ ནང༌ང༌ ང༌ ཉམ༌པོ༌ དུག༌ག༌ ཡོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ཁོའེ༌ ཁའ༌ མ༌ཉནས༌ ཡང༌ ཟེརས༌, “ངའེ༌ སྤོན༌བོའེ༌ ཁོང༌རང༌ངི༌ ལག༌ག༌ ཅའང༌ མ༌བོར༌ར༌ ལོ༌ཁྱེལ༌ ཉམ༌པོ༌ ཅི༌ཚང༌མའེ༌ཀ༌ ངའ༌ ཝང༌ཆ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","འི༌ ཁང༌པའེ༌ ནང༌ང༌ ངའེ༌ སང༌ ཀྲག༌ག༌ སུའང༌ མེད༌ ཡང༌ ཁོང༌ངི༌ ཉེ༌རང༌ མན༌པ༌ ཞན༌ ཅི༌ཚང༌མ༌ ངའ༌ སལ༌ཏེ༌ དུག༌ ཅིའ༌ཟེར༌ན༌ ཉེ༌རང༌ ཁོང༌ངི༌ ན༌མ༌ ཨིན༌ནོག༌། ཏེ༌ནེ༌ ཀ༌ཟུག༌གི༌ ངའེ༌ འི༌ཟམ༌ ངན༌པ༌ ལས༌ ཡང༌ དཀོན༌མཆོག༌གི༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཅོ༌?” ");
INSERT INTO lbj_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ཁོའེ༌ ཡོ༌སེབ༌བ༌ ཞག༌ཏང༌ ཟེར༌ཨིན༌ དུགས༌ ཨིན༌ནའང༌ ཡོ༌སེབ༌ ཁོ༌ ཉམ༌པོ༌ མལ༌ཙའེ༌ ནང༌ང༌ མི༌དུག༌ཅེས༌ མ༌ཚད༌ ཁོའེ༌ དུན༌ལའང༌ མ༌ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ཞག༌ཤིག༌ ཡོ༌སེབ༌ པོ༌ཏི༌ཕར༌རི༌ ཁང༌པའེ༌ ནང༌ང༌ ལས༌ ཅོའ༌ལ༌ ཆ༌ ཟ༌ནེ༌ ཞན༌ཡང༌ ཡོག༌པོ༌ སུའང༌ ཏེ༌རུ༌ མེད༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","པོ༌ཏི༌ཕར༌རི༌ ན༌མའེ༌ ཁོའེ༌ ཀོས༌པོ༌ ཟུམས༌ཏེ༌ ཟེརས༌, “ང༌ ཉམ༌པོ༌ མལ༌ཙའེ༌ ནང༌ང༌ ཡོང༌།” ཁོ༌ ཤོར༌ཏེ༌ སོང༌ ཨིན༌ནའང༌ ཁོའེ༌ ཁེ༌ཐོག༌གི༌ ཀོས༌པོ༌ བུ༌མོའེ༌ ལག༌ག༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ཡོ༌སེབ༌ ཕི༌ལོག༌ག༌ ཤོར༌ཏེ༌ ཁོའེ༌ ཀོས༌པོ༌ ཁོའེ༌ ལག༌ག༌ ལུས༌ཁན༌བོ༌ ཐོང༌ང༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ཁོའེ༌ ཞན༌ ཡོག༌པོ༌གུན༌ལ༌ བོདས༌ ཡང༌ ཟེརས༌ “ལྟོས༌, ངའེ༌ མག༌པའེ༌ འི༌ ཨིབ༌རི༌པ༌ མི༌བོ༌ ང༌དང༌ང༌ ཁྲེལ༌བ༌ སྟན༌ན༌ལ༌ ཁྱོངས༌ཏེ༌ ཨིན༌ནོག༌། ང༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོ༌ཅེས༌ལ༌ ཁོ༌ ངའེ༌ ནང༌ང༌ ཡོངས༌ ཨིན༌ནའང༌ ངའེ༌ ཀུ༌ཅོ༌ ཏངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ངའེ༌ ཀུ༌ཅོ༌ ཏང༌ང༌ཅིག༌, ཁོ༌ ཕི༌ལོག༌ག༌ ཤོར༌ཏེ༌ སོང༌ ཨིན༌ནའང༌ ཁོའེ༌ ཀོས༌པོ༌ འི༌ཀ༌ ལུས༌ཏེ༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ཁོའེ༌ ཡོ༌སེབ༌བི༌ ཀོས༌པོ༌ ཁོ༌རང༌ངི༌ མག༌པ༌ ལོགས༌ཏེ༌ ཡོང༌ཡོང༌ ཚོག༌པ༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ཏེ༌ནེ༌ ཁོའེ༌ ཏེན༌ན༌ རུངས༌པོ༌ ཁོའ༌ ཤདས༌, “ཉེ༌རང༌ངི༌ ཁྱོང༌ཁན༌ནི༌ ཨིབ༌རི༌པ༌ ངའེ༌ ནང༌ང༌ ཡོངས༌ཏེ༌ ངའ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོ༌ཅེས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ཨིན༌ནའང༌ ངའེ༌ ཀུ༌ཅོ༌ ཏང༌ང༌ཅིག༌ ཁོ༌ ཕི༌ལོག༌ག༌ ཤོར༌ཏེ༌ སོང༌ ཡང༌ ཁོའེ༌ ཀོས༌པོ༌ འི༌ཀ༌ ལུས༌ཏེ༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ཡོ༌སེབ༌བི༌ སྤོན༌བོའ༌ ཁོའེ༌ ན༌མའེ༌ “ཉེ༌རང༌ངི༌ ཡོག༌པོའེ༌ ཏེ༌ཟུག༌ ངན༌པ༌ ངའ༌ ཅོས༌” ཟེར༌ཏེ༌ ཚོར༌ར༌ཅིག༌ པོ༌ཏི༌ཕར༌ལ༌ མ༌སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌, ");
INSERT INTO lbj_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ཡང༌ ཡོ༌སེབ༌ ཟུམས༌ཏེ༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ ཀག༌ཅུགས༌ ཀ༌རུ༌ གྱལ༌པོའེ༌ ཙོན༌པ༌གུན༌ ཀག༌གད༌པིན༌ ཡང༌ ཁོ༌ ཏེ༌ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ཨིན༌ནའང༌ ཡ༌ཝ༌ ཡོ༌སེབ༌ ཉམ༌པོ༌ ཡོད༌པིན༌, ཁོང༌ངི༌ ཁོའ༌ ཐུག༌རྗེ༌ ཟིགས༌ཏེ༌ ཙོན༌ཁང༌ སྲུང༌ཁན༌ནི༌ འུ༌སྐྱོང༌ངི༌ ཆོགས༌སྐྱོར༌ ཐོབ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ཁོའེ༌ ཡོ༌སེབ༌ ཞན༌ ཙོན༌པ༌ ཚང༌མའེ༌ སྟ༌སྟོག༌ ཅོ༌ཅེས༌སི༌ ཕིའ༌ སྐོས༌ ཡང༌ ཙོན༌ཁང༌ངི༌ ལས༌ ཚང༌མའེ༌ ཁག༌ ཁོའ༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ཙོན༌ཁང༌ སྲུང༌ཁན༌ནི༌ འུ༌སྐྱོང༌ང༌ ཡོ༌སེབ༌བ༌ ཁག༌ ཀལ༌ཁན༌གུན༌ལ༌ ལྟ༌གོས༌ས༌ མེད༌པིན༌, ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ ཡོ༌སེབ༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཁོའ༌ ལས༌ ཚང༌མའེ༌ ནང༌ང༌ ཐར༌ཁྱེལ༌ ཅོའ༌ ཛད༌དད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ཏུས༌བན༌ཤིག༌གི༌ སྟིང༌ནེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཁོའེ༌ ཆང༌ལུག༌ཁན༌ དང༌ ཏ༌གི༌ ཅོ༌ཁན༌ ཉིས༌ཀོའེ༌ཀ༌ མ༌ཐད༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","གྱལ༌པོའ༌ ཁོང༌གུན༌ནི༌ཀ༌ སྲོ༌ ཡོངས༌, ");
INSERT INTO lbj_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ཡང༌ སྲུང༌ཁན༌ནི༌ མག༌མི༌ སྤོན༌བོའེ༌ ཝང༌ངི༌ ཡོག༌ག༌ ཡོད༌ཁན༌ནི༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ ཁོང༌གུན༌ ཀག༌ཅུགས༌ ཀ༌རུ༌ ཡོ༌སེབ༌བའང༌ ཀགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ཙོན༌ཁང༌ངི༌ མག༌མི༌ སྤོན༌བོའེ༌ ཡོ༌སེབ༌ ཁོང༌གུན༌ནི༌ ཞབས༌ཏོག༌ ཅོ༌ཁན༌ལ༌ སྐོས༌། ཙོན༌ཁང༌ངི༌ ནང༌ང༌ ཏུས༌ བན༌ཤིག༌གི༌ སྟིང༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ཞག༌ཤིག༌ ཚན༌ལ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ ཆང༌ལུག༌ཁན༌ དང༌ ཏ༌གི༌ ཅོ༌ཁན༌གུན༌ལ༌ ཉི༌ལམ༌ རིག༌ ཐོང༌ ཀ༌གུན༌ནི༌ ཏོན༌ སོ༌སོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌ཏོག༌ ཡོ༌སེབ༌ ཁོང༌གུན༌ ཡོད༌ས༌ ཡོང༌ང༌ཅིག༌, ཁོང༌གུན༌ ཚེར༌ཁའེ༌ ནང༌ང༌ ཡོད༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཏྲིས༌, “དི༌རིང༌ ཉེ༌ཞའ༌ ཚེར༌ཁའེ༌ ནང༌ང༌ ཅིའ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའ༌ ཉི༌ལམ༌ རིག༌ ཐོང༌, ཡང༌ ཏེ༌གུན༌ནི༌ ཏོན༌ ཤད༌ཁན༌ འི༌རུ༌ སུའང༌ མེད༌པ༌ ཨིན༌ནོག༌།” ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཟེརས༌, “ཉི༌ལམ༌ གྱུར༌ཅེས༌སི༌ ཁྱུད༌ དཀོན༌མཆོག༌གི༌ སལ༌ལ༌ ཛད༌ད༌ མ༌ནོག༌ག༌? ཉེ༌ཞའེ༌ ཉི༌ལམ༌གུན༌ ངའ༌ ཤད༌ད༌ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ཏེ༌ནེ༌ ཆང༌ ལུག༌ཁན༌ནི༌ འུ༌སྐྱོང༌ངི༌ ཡོ༌སེབ༌བ༌ ཁོ༌རང༌ངི༌ ཉི༌ལམ༌ ཤདས༌། ཁོའེ༌ ཟེརས༌, “ངའེ༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ ངའེ༌ དུན༌ལ༌ རྒུན༌ནི༌ ལྕང༌མ༌ཞིག༌ ཐོང༌, ");
INSERT INTO lbj_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ཀ༌བོའེ༌ཀ༌ ཡལ༌ག༌ སུམ༌ དུག༌པིན༌། པ༌ཏུམ༌ ཏངས༌ཏེ༌ མེན༌ཏོག༌ བར༌ ཡང༌ རྒུན༌ ཆགས༌ཏེ༌ ཚོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","གྱལ༌པོའེ༌ དོན༌སྐྱོག༌ ངའེ༌ ལག༌པའེ༌ ནང༌ང༌ དུག༌པིན༌ ཡང༌ ངའེ༌ རྒུན༌བོ༌ ཁྱོངས༌ཏེ༌ དོན༌སྐྱོག༌གི༌ ནང༌ང༌ ཙིར༌ཏེ༌ ཁོང༌ང༌ ཏང༌དུག༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ཡོ༌སེབ༌བི༌ ཟེརས༌, “ཡལ༌ག༌ སུམ༌ཀོའེ༌ ཏོན༌བོ༌ ནི༌ ཞག༌པོ༌ སུམ༌བོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ཞག༌པོ༌ སུམ༌མི༌ ནང༌ང༌ གྱལ༌པོའེ༌ ཁྱོ༌རང༌ ཙོན༌ནེ༌ ཕུད༌ཏེ༌ ཁྱོ༌རང༌ངི༌ སྔུན༌ནི༌ ཀོ༌སའེ༌ཀ༌ སྐོ༌ཨིན༌། ཁྱོ༌རང༌ངི༌ ཕེ༌རོའེ༌ དོན༌སྐྱོག༌པོ༌ ཁོང༌ངི༌ ཆག༌ག༌ ཏང༌ཨིན༌ ཀ༌ཟུག༌ སྔུན༌ལ༌ ཁྱོ༌རང༌ ཁོང༌ངི༌ ཆང༌ ལུག༌ཁན༌བོ༌ ཨིན༌ ཟ༌ནེ༌ ཅོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ཨིན༌ནའང༌ ཅི༌ཚང༌མ༌ ཉེ༌རང༌ངི༌ ཕིའ༌ གྱལ༌ལ༌ ཆ༌ ཟ༌ནེ༌ ཇུ༌ཇུ༌ ངའ༌ ཨིད༌ཏུ༌ ཅོའ༌ ཛད༌། གྱལ༌པོའ༌ ངའེ༌ སྐོར༌ལ༌ ཤད༌ཏེ༌ ཇུ༌ཇུ༌ ངའ༌ ཐུག༌རྗེ༌ སྟན༌ན༌ ཛད༌ཏེ༌ ངའ༌ འི༌ ཙོན༌ཁང༌ནེ༌ ཕུད༌ཅུག༌ག༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ཨིབ༌རི༌པའེ༌ ཡུལ༌ནེ༌ ངའ༌ མི༌གུན༌ནི༌ ཝང༌ ཉམ༌པོ༌ ཁྱོངས༌, མ༌ཚད༌ འི༌རུའང༌ ཙོན༌ཁང༌ང༌ ཀག༌ཅེས༌སི༌ འོས༌པ༌ ངའེ༌ ཅའང༌ མ༌ཅོས༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ཏ༌གི༌ ཅོ༌ཁན༌ནི༌ འུ༌སྐྱོང༌ངི༌ ཡོ༌སེབ༌བི༌ ཉི༌ལམ༌ གྱུར༌ཁན༌བོ༌ ཕན༌ཐོགས༌ཅན༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ངའང༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌, ངའེ༌ གོའེ༌ཀ༌ ཏ༌གི༌ ཙེ༌པོ༌ སུམ༌ ཁུར༌ཏེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ངའེ༌ གོའེ༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཁེ༌ཐོག༌གི༌ ཙེ༌པོའེ༌ ནང༌ང༌ གྱལ༌པོའེ༌ ཕིའ༌ སྲགས༌ཁན༌ནི༌ ཏ༌གི༌ སྣ༌ཚོགས༌ དུག༌པིན༌ ཨིན༌ནའང༌ ཏེ༌གུན༌ ཅི༌པ༌གུན༌ནི༌ ཟ༌དུག༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ཡོ༌སེབ༌བི༌ ལན༌ཏངས༌, “ཙེ༌པོ༌ སུམ༌ཀོའེ༌ ཏོན༌བོ༌ ནི༌ ཞག༌པོ༌ སུམ༌བོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ཞག༌པོ༌ སུམ༌མི༌ ནང༌ང༌ གྱལ༌པོའེ༌ ཁྱོ༌རང༌ ཕུད༌ཨིན༌ ཡང༌ ཁྱོ༌རང༌ངི༌ གོ༌ ཅད༌ཅུགས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཟུགས༌པོ༌ ལྡུང༌མའེ༌ཀ༌ ཏག༌ཨིན༌ ཡང༌ ཅི༌པ༌གུན༌ནི༌ ཁྱོ༌རང༌ངི༌ ཤ༌ཟེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ཞག༌ སུམ༌པའེ༌ ཞག༌ག༌ གྱལ༌པོའེ༌ སྐྱེ༌ཞག༌ ཨིན༌པིན༌, ཁོའེ༌ ཁོ༌རང༌ངི༌ ལོན༌པོ༌གུན༌ལ༌ གྲོན༌ ཏངས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཆང༌ ལུག༌ཁན༌ དང༌ ཏ༌གི༌ ཅོ༌ཁན༌ནི༌ འུ༌སྐྱོང༌གུན༌ ཙོན༌ཁང༌ནེ༌ པུད༌ཏེ༌ ཁོ༌རང༌ངི༌ ལོན༌པོ༌གུན༌ནི༌ དུན༌ལ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ཁོའེ༌ ཆང༌ ལུག༌ཁན༌ནི༌ འུ༌སྐྱོང༌, ཁོ༌རང༌ངི༌ སྔུན༌ནི༌ ཀོ༌སའེ༌ཀ༌ སྐོས༌པ༌ ཡང༌སྐྱར༌ ཁོའེ༌ ཕེ༌རོའེ༌ དོན༌སྐྱོག༌པོ༌ གྱལ༌པོའེ༌ ལག༌པའེ༌ ནང༌ང༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ཨིན༌ནའང༌ ཏ༌གི༌ ཅོ༌ཁན༌ནི༌ འུ༌སྐྱོང༌ངི༌ ཟུགས༌པོ༌ ལྡུང༌མའེ༌ཀ༌ ཏགས༌, ཀ༌ཟུག༌ ཡོ༌སེབ༌བི༌ ཉི༌ལམ༌མི༌ ཏོན༌ ཤད༌ ཟ༌ནེ༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ཨིན༌ནའང༌ གྱལ༌པོའེ༌ ཆང༌ ལུག༌ཁན༌ནི༌ འུ༌སྐྱོང༌ང༌ ཡོ༌སེབ༌ ཨིད༌ཏུ༌ མ༌ལུས༌ ཡང༌ ཁོའ༌ ཁོ༌ རྗེད༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ལོ༌ ཉིས༌སི༌ སྟིང༌ནེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའ༌ ཉི༌ལམ༌ ཞིག༌གི༌ ནང༌ང༌ ཁོ༌ ནཱའེལ༌ ལྩངས༌པོའེ༌ དུན༌ལ༌ ལངས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ངད༌ཅན༌ གྱགས༌པ༌ བ༌ལང༌ རྡུན༌ ལྩངས༌པོའེ༌ ནང༌ནེ༌ བིངས༌ཏེ༌ ཡོངས༌ ཡང༌ ཏེ༌ ཐའ༌མ༌ ཡོད༌ཁན༌ནི༌ ལྗངས༌པ༌ ཟེན༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ཏེ༌ནེ༌ ཏེ༌གུན༌ནི༌ སྟིང༌ནེ༌ ཞན༌ཡང༌ རིད༌པ༌ དང༌ ཁམ༌ལོག༌ བ༌ལང༌ རྡུན༌ ལྩངས༌པོའེ༌ ནང༌ནེ༌ བིང༌ཏེ༌ ཡང༌ ཏེ༌ ཐའ༌མ༌ ཡོད༌ཁན༌ནི༌ བ༌ལང༌ གྱགས༌པ༌གུན༌ནི༌ དུན༌ལ༌ ལངས༌ཏེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ཡང༌ བ༌ལང༌ ཁམ༌ལོག༌ རིད༌པ༌གུན༌ནི༌ བ༌ལང༌ ངད༌ཅན༌ གྱགས༌པ༌གུན༌ ཟོས༌། ཏེ༌ནེ༌ གྱལ༌པོའ༌ ཉིད༌ཚད༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","གྱལ༌པོ༌ ཡང༌སྐྱར༌ ཉིད༌ལ༌ སོང༌ཏེ༌ ཉི༌ལམ༌ ཉིས༌པ༌ ཐོང༌; ཁོའ༌ ཞིང༌ངི༌ སོག༌མ༌ ཅིག༌གི༌ཀ༌ ཁྲངས༌པོ༌ གྱལ༌ལ༌ གང༌ཏེ༌ ཡོད༌ཁན༌ནི༌ སྙེ༌མ༌ རྡུན༌ ཆགས༌ཏེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ཏེ༌ སྟིང༌ནེ༌ ཁོའ༌ ཞན༌ཡང༌ སྙེ༌མ༌ རྡུན༌ བིང༌ཨིན༌ ཐོང༌, ཀ༌གུན༌ ཇ༌རོ༌ དང༌ ཤར༌ལུང༌ངི༌ སྲགས༌ཏེ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ཡང༌ ཏེ༌ ཇ༌རོ༌ སྙེ༌མ༌གུན༌ནི༌ ཁྲངས༌པོ༌ སྙེ༌མ༌གུན༌ སྨིད༌ ཏངས༌། ཏེ༌ནེ༌ ཡང༌སྐྱར༌ གྱལ༌པོའ༌ ཉིད༌ཚད༌ ཡང༌ ཁོའ༌ ཉིད༌ལམ༌ ཐོངས༌ཏེ༌ ཨིན༌ཁན༌བོ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ང༌མོ༌ ཉི༌ལམ༌མི༌ ཏོན༌བོ༌ ཅི༌ ཨིན༌ཧེ༌ སམས༌ཏེ༌ གྱལ༌པོ༌ ཚེར༌པ༌ ཁོའེ༌ ཨི༌ཇིབ༌པ༌ སེམ༌ཉིད༌གུན༌ལ༌ བོད༌ཁན༌ དང༌ མི༌ ཤེས༌རབས༌ཅན༌ ཚང༌མ༌ བོད༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཁོ༌རང༌ངི༌ ཉི༌ལམ༌གུན༌ ཤདས༌, ཨིན༌ནའང༌ སུ༌ཞིག༌གའང༌ ཁོའ༌ ཏེ༌གུན༌ནི༌ ཏོན༌ ཤད༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ཏེ༌ནེ༌ ཆང༌ ལུག༌ཁན༌ནི༌ སྤོན༌བོའེ༌ གྱལ༌པོ༌ ཟེརས༌, “དི༌རིང༌ ང༌ ངའེ༌ ནོར༌ཁྲུལ༌ ཅོ༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ཉེ༌རང༌ང༌ ཐུགས༌སྲོ༌ སྐྱོད༌ཏེ༌ ཉེ༌རང༌ངི༌ ཏ༌གི༌ ཅོ༌ཁན༌ནི༌ འུ༌སྐྱོང༌ དང༌ ང༌, སྲུང༌ཁན༌ནི༌ མག༌མི༌ སྤོན༌བོའེ༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ ཀག༌ཅུགས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ཞག༌ཤིག༌ ཚན༌ལ༌ ང༌ཞའ༌ ཏོན༌ཏག༌ སོ༌སོ༌ ཡོད༌ཁན༌ནི༌ ཉི༌ལམ༌ རིག༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ང༌ཞ༌གུན༌ ཉམ༌པོ༌ སྲུང༌ཁན༌ནི༌ མག༌མི༌ འུ༌སྐྱོང༌ངི༌ ཡོག༌པོ༌ ཨིབ༌རི༌པ༌ ཞུ༌ནུ༌ཞིག༌ ཡོད༌པིན༌། ང༌ཞའེ༌ ཁོའ༌ ཉི༌ལམ༌གུན༌ ཤད༌པིན༌ ཡང༌ ཁོའེ༌ ང༌ཞའ༌ རེ༌རེའ༌ ང༌ཞའེ༌ ཉི༌ལམ༌མི༌ ཏོན༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ཁོའེ༌ ཟེར༌ཁན༌ ཚང༌མ༌ དྲན༌དྲའ༌ གྲུབ༌, ཉེ༌རང༌ངི༌ ང༌ ང༌རང༌ངི༌ ཀོ༌ས༌ ལོགས༌ཏེ༌ སལས༌ ཡང༌ ཏ༌གི༌ ཅོ༌ཁན༌ནི༌ ཟུགས༌པོ༌ ལྕང༌མ༌ ཏགས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","གྱལ༌པོའེ༌ ཡོ༌སེབ༌ ཁྱོང༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌ ཡང༌ ཁོ༌ ཏེན༌ན༌མལ༌ལ༌ ཙོན༌ཁང༌ནེ༌ ཕིངས༌ཏེ༌ ཁོའེ༌ སམ༌དལ༌ བྲགས༌ ཡང༌ ཀོས༌ལག༌ སྤོས༌ཏེ༌ གྱལ༌པོའེ༌ དུན༌ལ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","གྱལ༌པོའེ༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ངའ༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌ ཡང༌ སུ༌ཞིག༌གའང༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ མ༌ཉན༌། ཨིན༌ནའང༌ ཁྱོ༌རང༌ང༌ ཉི༌ལམ༌མི༌ ཏོན༌ ཤད༌ཉན༌དུག༌ ཟེར༌ཏེ༌ ངའ༌ ཚོར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ཡོ༌སེབ༌བི༌ ལན༌ཏངས༌, “ངའ༌ ཤད༌ ཉན༌ན༌མེད༌ ཨིན༌ནའང༌ ཉེ༌རང༌ངི༌ ཕན༌ཐོགས༌སི༌ ཕིའ༌ དཀོན༌མཆོག༌གི༌ ཉེ༌རང༌ངི༌ ཉིད༌ལམ༌མི༌ ཏོན༌བོ༌ ཤད༌ད༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","གྱལ༌པོའེ༌ ཟེརས༌, “ཉིད༌ལམ༌མི༌ ནང༌ང༌ ང༌ ནཱའེལ༌ ལྩངས༌པོའེ༌ ཐའ༌མ༌ ལངས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ངད༌ཅན༌ གྱགས༌པ༌ བ༌ལང༌ རྡུན༌ ལྩངས༌པོའེ༌ ནང༌ནེ༌ བིངས༌ཏེ༌ ཡོངས༌ ཡང༌ ཏེ༌ ཐའ༌མའེ༌ ལྗངས༌པ༌ ཟེན༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ཏེ༌གུན༌ནི༌ སྟིང༌ནེ༌ ཞན༌ཡང༌ མ༌ རིད༌པ༌ ཁམ༌ལོག༌ བ༌ལང༌ རྡུན༌ ལྩངས༌པོའེ༌ ནང༌ནེ༌ བིངས༌ཏེ༌ ཡོངས༌, ཏེ༌ཙོགས༌ ཁམ༌ལོག༌ བ༌ལང༌ རིག༌ ངའེ༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ མ༌ནེ༌ མ༌ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","རིད༌པ༌ ཁམ༌ལོག༌ བ༌ལང༌གུན༌ནི༌ གྱགས༌པ༌ རྡུན༌བོ༌ ཟོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ཨིན༌ནའང༌ ཏེ༌གུན༌ནི༌ གྱགས༌པ༌ བ༌ལང༌གུན༌ ཟོས༌ཏེ༌ ཨིན༌ཁན༌བོ༌ སུའིང༌ ཤེས༌ མ༌ཐུབ༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌གུན༌ གོ༌མ༌ ཙོགས༌ལ༌ ཁམ༌ལོག༌ དང༌ རིད༌པ༌ དུག༌པིན༌། ཏེ༌ནེ༌ ངའ༌ ཉིད༌ཚད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ང༌ ཡང༌སྐྱར༌ ཉིད༌ལ༌ སོང༌ཏེ༌ འི༌ ཉི༌ལམ༌བོའང༌ ཐོང༌, ཞིང༌ངི༌ སོག༌མ༌ ཅིག༌གི༌ཀ༌ ཁྲངས༌པོ༌ གྱལ༌ལ༌ གང༌ཏེ༌ ཡོད༌ཁན༌ནི༌ སྙེ༌མ༌ རྡུན༌ ཆགས༌ཏེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ཏེ༌ནེ༌ ཞན༌ཡང༌ སྙེ༌མ༌ རྡུན༌ བིང༌ཨིན༌ ཐོང༌, ཀ༌གུན༌ ཇ༌རོ༌ དང༌ ཤར༌ལུང༌ངི༌ སྲགས༌ཏེ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ཡང༌ ཏེ༌ ཇ༌རོ༌ སྙེ༌མ༌གུན༌ནི༌ ཁྲངས༌པོ༌ སྙེ༌མ༌གུན༌ སྨིད༌ ཏངས༌། ངའེ༌ སེམ༌ཉིད༌ལ༌ བོད༌ཁན༌གུན༌ལ༌ ཉི༌ལམ༌བོ༌ ཤད༌པིན༌ ཨིན༌ནའང༌ སུ༌ཞིག༌གིའང༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ མ༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ཡོ༌སེབ༌བི༌ གྱལ༌པོའ༌ ཟེརས༌, “ཉི༌ལམ༌ ཉིས༌ཀོའེ༌ ཏོན༌ཏག༌ ཙོགས༌ ཨིན༌ནོག༌། དཀོན༌མཆོག༌གི༌ ཅོའ༌ ཛད༌ཅེས༌པོ༌ ཉེ༌རང༌ང༌ སྔོན༌ཅུགས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","བ༌ལང༌ གྱགས༌པ༌ རྡུན༌བོ༌ ནི༌ ལོ༌ རྡུན༌ ཡང༌ ཁྲངས༌པོ༌ གྱལ༌ལ༌ གངས༌ཁན༌ སྙེ༌མ༌ རྡུན༌གུན༌ནའང༌ ལོ༌ རྡུན༌ ཨིན༌ནོག༌། ཉི༌ལམ༌ ཉིས༌ཀོ༌ ཙོགས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","སྟིང༌ནེ༌ བིང༌ཁན༌ནི༌ བ༌ལང༌ རིད༌པ༌ ཁམ༌ལོག༌ རྡུན༌ དང༌ ཤར༌ལུང༌ངི༌ སྲགས༌ཁན༌ སྙེ༌མ༌ ཇ༌རོ༌ རྡུན༌གུན༌, ལོ༌ རྡུན༌ནི༌ མུ༌གེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“ཏེན༌ན༌བོ༌ ཇུང༌ཨིན༌ ཀ༌ཟུག༌ ངའེ༌ ཉེ༌རང༌ང༌ ཟེརས༌, དཀོན༌མཆོག༌གི༌ ཛད༌ཅེས༌ཅན༌བོ༌ ཉེ༌རང༌ང༌ སྟན༌ན༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོའེ༌ ནང༌ང༌ ལོ༌ རྡུན༌ སྟོན༌ཐོག༌ མངས༌ཏེའང༌ མང༌པོ༌ སྨིན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ཏེ༌ སྟིང༌ནེ༌ ལོ༌ རྡུན༌ནི༌ ཕིའ༌ མུ༌གེ༌ ཇུང༌ཨིན༌ ཡང༌ སྟོན༌ཐོག༌ གྱལ༌ལ༌ ཡོང༌ཁན༌ནི༌ ཏུས༌པོ༌ རྫེད༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ མུ༌གེ༌ སྲན༌ཏྲེ༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","མུ༌གེ༌ ཞས༌ཏེ༌ སྕོད༌པའེ༌ ཏུས༌གུན༌ རྫེད༌ཅུག༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ མུ༌གེ༌ ཏུས༌པོ༌ མ༌བར༌དོ༌ཅན༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ཉེ༌རང༌ང༌ ཉི༌ལམ༌ ལྡབས༌ཏེ༌ ཐོང༌ཅེས༌སི༌ ཏོན༌ ནི༌ དཀོན༌མཆོག༌གི༌ ཏེ༌ཟུག༌ ཛད༌ཅེས༌ལ༌ ཐག༌ཅད༌ད༌ ཛད༌ཁན༌ ཡང༌ ཏེ༌བོ༌ གྱོགས༌པ༌ ཇུང༌ཅེས༌པོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ཏ༌ ཕེ༌རོ༌ ཉེ༌རང༌ངི༌ རིག༌པ༌ དང༌ ཤེས༌རབས༌ཅན༌ མི༌ཞིག༌ ལྡམས༌ཏེ༌ ཁོ༌ ཡུལ༌ལི༌ ཁག༌ཁུར༌པ༌ ཅོའ༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","སྟོན༌ཐོག༌ གྱལ༌ལ༌ ཡོང༌ཁན༌ནི༌ ལོ༌ རྡུན༌ནི༌ ཏུས༌ལ༌ ཏེ༌བོའེ༌ ལྔ༌ ཁག༌པོ༌ ཐེན༌ཏེ༌ བོར༌ཅེས༌ལ༌ ཉེ༌རང༌ངི༌ ཞན༌ཡང༌ འུ༌སྐྱོང༌གུན༌ སྐོའ༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","གྱལ༌པོ༌ ཕེ༌རོའེ༌ ཝང༌ཆའེ༌ ནང༌ང༌ ཁོང༌གུན༌ལ༌ ལོ༌ ཟང༌པོ༌གུན༌ནི༌ ནང༌ང༌ སྟོན༌ཐོག༌ ཐེ༌བ༌ སྨིན༌ཁན༌ ཚང༌མ༌ ལྡུ༌ཏེ༌ གྱལ༌ས༌གུན༌ནི༌ ནང༌ང༌ སག༌ཅུག༌ག༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཡོང༌ཅེས༌ཅན༌ནི༌ ལོ༌ རྡུན༌ནི༌ མུ༌གེ༌ ཏུས༌ལ༌ ཡུལ༌པ༌གུན༌ནི༌ ཕིའ༌ ཀོལ༌ཅེས༌ལ༌ ཏེ༌ ཁར༌ཇི༌གུན༌ སགས༌ཏེ༌ བོར༌གོས༌། ཏེ༌ནེ༌ ཡུལ༌མི༌གུན༌ སྟོགས༌ཏེ༌ མི༌ཤི༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","གྱལ༌པོ༌ དང༌ ཁོའེ༌ སྤོན༌བོ༌ ཚང༌མའ༌ ཐབ༌ལྡིངས༌པོ༌ གྱལ༌ལ༌ ཚོར༌ ");
INSERT INTO lbj_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ཏེ༌ནེ༌ ཕེ༌རོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ང༌དང༌གུན༌ལ༌ ཡོ༌སེབ༌ ཙོགས༌སི༌ མི༌ དཀོན༌མཆོག༌གི༌ ཐུག༌ཉིད༌ ཡོད༌ཁན༌ཞིག༌ ཐོབ༌ ཨིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ཁྱོ༌རང༌ང༌ འི༌ ཚང༌མ༌ སྔོན༌ཅུག༌ག༌ ཛད༌ པ༌སང༌ ཏན༌ཏན༌ ཁྱོ༌རང༌ ཚང༌མའེ༌སང༌ ཤེས༌རབས༌ དང༌ རིག༌པ༌ཅན༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ངའེ༌ གྱལ༌སྲིད༌དི༌ ཁག༌པོ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཀལ༌ལད༌, ཡང༌ ངའེ༌ མི༌ཚང༌མའེ༌ ཁྱོ༌རང༌ངི༌ བཀའ༌ ཁའ༌ ཉན༌ཨིན༌། ང༌ མན༌པ༌ ཁྱོ༌རང༌ང༌ ཅི༌ཚང༌མའེ༌ཀ༌ ཝང༌ཆ༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ཏེ༌ནེ༌ ཕེ༌རོའེ༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ཏ༌ ངའེ༌ ཁྱོ༌རང༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ གང༌པོའེ༌ཀ༌ ཝང༌སྲུལ༌པ༌ སྐོའད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ ཛི༌གུའི༌ ཀ༌ནེ༌ ཐེ༌ཙེ༌ སེར༌དུབ༌པོ༌ ཕུད༌ཏེ༌ ཡོ༌སེབ༌བི༌ ཛི༌གུའ༌ སྐརས༌། ཁོའ༌ ཀུས༌པོ༌ ཀོས༌ སྐོནས༌ ཡང༌ ཁོའེ༌ སྐྱེའ༌ སེར༌རི༌ ཉག༌ཐག༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ཕེ༌རོའེ༌ ཝང༌སྲུལ༌པ༌ ཉིས༌པའེ༌ ཚུལ༌ལ༌ ཁོའ༌ རྟ༌རེལ༌ ཞོན༌ཅེས༌ལ༌ ཏངས༌, ཡང༌ མི༌གུན༌ ཁོའེ༌ སྔུན༌སྔུན༌ལ༌ ཆེན༌ ཀུ༌ཅོ༌ ཏང༌ཨིན༌ ཟེརས༌, “གོ༌ སྒུས༌ཏེ༌ ཀུས༌པ༌ ཅོས༌།” གྱལ༌པོའེ༌ ཡོ༌སེབ༌ ཨི༌ཇིབ༌ ཡུལ༌ གང༌པོའེ༌ཀ༌ ཝང༌སྲུལ༌པའ༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","གྱལ༌པོའེ༌ ཁོའ༌ ཟེརས༌, “ང༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཨིན༌ ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ གོངས༌པ༌ མེད༌པ༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ ནང༌ང༌ སུ༌ཞིག༌གའང༌ ཅའང༌ ཅོ༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ཕེ༌རོའེ༌ ཡོ༌སེབ༌བི༌ མིང༌ ཟི༌ཕི༌ནེཐ༌ པེ༌ནེ༌ཨཧ༌ ཏགས༌ ཡང༌ འོན༌ ཡུལ༌ལི༌ བླ༌མ༌ པོ༌ཏི༌ཕར༌རི༌ བུ༌མོ༌ ཨ༌སི༌ནད༌ ཁོའ༌ ན༌མའ༌ ཏངས༌། ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ཀ༌ ཝང༌ སྲུལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ཨི༌ཇིབ༌བི༌ གྱལ༌པོའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌ གོ༌ཟུག༌ ཟ༌ནེ༌ ཡོ༌སེབ༌བ༌ ལོ༌ སུམ༌ཅུ༌ ཆའད༌པིན༌། ཁོ༌ གྱལ༌པོའེ༌ ཁར༌ནེ༌ བིང༌ཏེ༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ སྟ༌སྟོག༌ག༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ལོ༌ རྡུན༌ ས༌ཆའེ༌ ཀ༌ནེ༌ སྟོན༌ཐོག༌ མ༌ མང༌པོ༌ སྨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ཡོ༌སེབ༌བི༌ ལོ༌ རྡུན༌ནི༌ ནང༌ང༌ ཐེ༌བ༌ སྟོན༌ཐོག༌ སྨིན༌ཁན༌གུན༌ ལྡུས༌ཏེ༌ གྱལ༌ས༌གུན༌ནི༌ ཛོད༌ཁང༌ངི༌ ནང༌ང༌ སགས༌། ཁོའེ༌ གྱལ༌ས༌ རེ༌རེ༌ ནང༌ང༌ ཏེ༌ ཉེ༌ཁོར༌རི༌ སྟོན༌ཐོག༌གུན༌ ལྡུས༌ཏེ༌ སགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ཡོ༌སེབ༌བི༌ གྱ༌ཚོའེ༌ པེ༌མ༌ ཙོགས༌ མང༌པོ༌ གྲུ༌ སགས༌, ཁོའ༌ ཏེ༌བོ༌ ཏབ༌ ཁོ༌རང༌ མ༌ཉན༌ ཅིའ༌ཟེར༌ན༌ གྲུ༌ ཏེ༌ཟམ༌ མང༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","མུ༌གེ༌ ཇུང༌ངི༌ སང༌ སྔུན༌ལ༌ ཡོ༌སེབ༌བ༌ བུ༌ཚ༌ ཉིས༌ ཡོད༌པིན༌, ཀ༌གུན༌ འོན༌ ཡུལ༌ལི༌ བླ༌མ༌ པོ༌ཏི༌ཕར༌རི༌ བུ༌མོ༌ ཨ༌སི༌ནད༌ལ༌ ཇོར༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ཁོའེ༌ ཁོ༌རང༌ངི༌ གོ༌མའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ མ༌ནས༌ས༌ ཏགས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ངའེ༌ རྡུག༌ངལ༌ དང༌ ངའེ༌ ཨ༌བའེ༌ ནང༌ཚངས༌ ཚང༌མ༌ རྗེད༌ ཅུག༌ག༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཉིས༌པ༌བོའ༌ ཨེཕ༌ར༌ཡིམ༌ མིང༌ང༌ ཏགས༌ ཡང༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ངའ༌ རྡུག༌ངལ༌ ཐོང༌སའེ༌ ས༌ཆའེ༌ ནང༌ང༌ ཕྲུ༌གུ༌ སལ༌ལ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ཨི༌ཇིབ༌བི༌ ནང༌ང༌ སྟོན༌ཐོག༌ གྱལ༌ལ༌ སྨིན༌ཁན༌ནི༌ སྐྱིད༌པའེ༌ ལོ༌ རྡུན༌བོ༌ ཚར༌ ");
INSERT INTO lbj_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ཡང༌ ཡོ༌སེབ༌བི༌ ཟེར༌ཁན༌ ནང༌ཞིན༌ མུ༌གེ༌ ལོ༌ རྡུན༌བོ༌ གོ༌ཟུག༌ སོང༌། ཞན༌ ཡུལ༌ ཚང༌མའེ༌ ནང༌ངའང༌ མུ༌གེ༌ ཇུང༌, ཨིན༌ནའང༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ ཟ༌གྱུ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ཨི༌ཇིབ༌པ༌གུན༌ལ༌ མུ༌གེ༌ ཞས༌ཏེ༌ སྟོག༌རི༌ ཐོང༌ང༌ཅིག༌ ཁོང༌གུན༌ནི༌ གྱལ༌པོའ༌ ཟའ༌ཅེས༌ ཏོང༌ ཟེར༌ཏེ༌ ཀུ༌ཅོ༌ ཏངས༌། ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཁོང༌ ཚང༌མ༌ ཟེརས༌, “ཡོ༌སེབ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁོའེ༌ ཟེར༌ཁན༌བོ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","མུ༌གེ༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ ཕེལ༌ལ༌ཅིག༌ ཡོ༌སེབ༌བི༌ ཛོད༌ཁང༌ ཚང༌མ༌ ཕེས༌ཏེ༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ གྲུ༌ ཙོངས༌ ཅིའ༌ཟེར༌ན༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ མུ༌གེ༌ མ༌ སྲན༌ཏྲེ༌ ལངས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ཇིག༌རྟེན༌ གང༌པོ༌ནེ༌ མི༌གུན༌ ཨི༌ཇིབ༌བ༌ ཡོ༌སེབ༌བི༌ ཀ༌ནེ༌ གྲུ༌ ཉོའ༌ལ༌ ཡོངས༌ ཅིའ༌ཟེར༌ན༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ ནང༌ང༌ མུ༌གེ༌ སྲན༌ཏྲེ༌ ལངས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ཡ༌ཀོབ༌བ༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ གྲུ༌ ཡོད༌ཁན༌བོ༌ ཚོར༌ར༌ཅིག༌ ཁོའེ༌ ཁོང༌རང༌ངི༌ བུ༌ཚ༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌གུན༌ ཚེར༌ཨིན༌ ཅའང༌ མ༌ཅོའ༌ དུགས༌ཏེ༌ ཅི༌ ཅོའད༌? ");
INSERT INTO lbj_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ཨི༌ཇིབ༌བི༌ ནང༌ང༌ གྲུ༌ དུག༌ ཟེར༌ཏེ༌ ངའེ༌ ཚོར༌, ང༌དང༌གུན༌ སྟོག༌རིའ༌ མི༌ ཤི༌ཅེས༌ལ༌ ཏེ༌རུ༌ སོང༌ཏེ༌ གྲུ༌ ཉོས༌ཏེ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཨ༌ཅོ༌ རྕུ༌ ཨི༌ཇིབ༌བ༌ གྲུ༌ ཉོའ༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ཨིན༌ནའང༌ ཡ༌ཀོབ༌བི༌ ཡོ༌སེབ༌བི༌ ནོ༌ བེན༌ཡཱ༌མིན༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ལམ༌ མ༌ཅུགས༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ ཉམ༌པོ༌ ངན༌པ༌ ཆ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌ སམ༌ཏེ༌ ཁོ༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ཞན༌ མི༌གུན༌ ཉམ༌པོ༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌ གྲུ༌ ཉོ༌ཅེས༌ལ༌ སོང༌ ཅིའ༌ཟེར༌ན༌ ཀེ༌ནན༌ནི༌ ནང༌ངའང༌ མུ༌གེ༌ ཇུང༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ཡོ༌སེབ༌ ཨི༌ཇིབ༌བི༌ ལོན༌པོ༌ ཨིན༌ པ༌སང༌ མི༌ཚང༌མ༌ལ༌ གྲུ༌ ཙོང༌ཅེས༌སི༌ ཁག༌ ཁོའེ༌ ཨིན༌པིན༌། ཡོ༌སེབ༌བི༌ ཨ༌ཅོ༌གུན༌ ཁོ༌ ཡོད༌ས༌ ཡོངས༌ ཡང༌ ཁོའེ༌ དུན༌ལ༌ གོ༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ སྒུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ཨ༌ཅོ༌གུན༌ ཐོང༌ང༌ཅིག༌ ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ ཤེས༌ ཨིན༌ནའང༌ མི༌ཤེས༌ཟུན༌ ཏངས༌ཏེ༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ སྤེ༌ར༌ སྐྱོང༌པོ༌ ཏངས༌ཏེ༌ ཏྲིས༌, “ཁྱོ༌ཞ༌གུན༌ ཀ༌ནེ༌ ཡོངས༌ཏེ༌ ཨིན༌?” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞ༌གུན༌ ཀེ༌ནན༌ནེ༌ ཟའ༌ཅེས༌ ཉོའ༌ལ༌ ཡོངས༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ ཤེས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཡོ༌སེབ༌ མ༌ཤེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ཁོའ༌ ཁོང༌གུན༌ནི༌ སྐོར༌ལ༌ ཉི༌ལམ༌ ཐོང༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ཡོངས༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞའ༌ ང༌ཞའེ༌ གྲ༌འོ༌, སང༌ཝའེ༌ ཐོག༌ནེ༌ ང༌ཞའེ༌ ཡུལ༌ལི༌ སྲུང༌སྐྱོབ༌ འུ༌ཐུགས༌ ཡོད༌ས༌གུན༌ ལྟའ༌ལ༌ ཡོངས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “མན༌, སྤོན༌བོ༌ལེ༌། ཉེ༌རང༌ངི༌ ཡོག༌པོ༌ ང༌ཞའ༌, ཟའ༌ཅེས༌ ཉོའ༌ལ༌ ཡོངས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ང༌ཞའ༌ ཚང༌མ༌ ཨ༌བ༌ ཅིག༌གི༌ བུ༌ཚ༌གུན༌ ཨིན༌། སྤོན༌བོ༌ལེ༌ ང༌ཞ༌གུན༌ ཀྲང༌པོ༌ མི༌རིག༌ ཨིན༌, གྲ༌འོ༌ མན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “མན༌, ཁྱོ༌ཞ༌གུན༌ ང༌ཞའེ༌ ཡུལ༌ལི༌ སྲུང༌སྐྱོབ༌ འུ༌ཐུགས༌ ཡོད༌ས༌གུན༌ ལྟའ༌ལ༌ ཡོངས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ཁོང༌གུན༌ནི༌ ཟེརས༌, “ང༌ཞའ༌ ཨ༌བ༌ ཅིག༌གི༌ བུ༌ཚ༌ ཨ༌ཅོ༌ནོ༌ རྕུག༌ཉིས༌ ཀེ༌ནན༌ ཡུལ༌ལི༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ ཨིན༌། ང༌ཞའེ༌ ནོ༌ ཆུང༌ཤོག༌པོ༌ དག༌ས༌ ང༌ཞའེ༌ ཨ༌བ༌ ཉམ༌པོ༌ ཡོད༌ ཡང༌ ཅིག༌ཅིག༌ ཤི༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ཡོ༌སེབ༌བི༌ ཟེརས༌, “ངའེ༌ ཟེར༌ཁན༌བོ༌ ཏན༌ཏན༌ ཨིན༌ནོག༌ ཁྱོ༌ཞ༌གུན༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ལྟའ༌ ཡོང༌ཁན༌ གྲ༌འོ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ཁྱོ༌ཞ༌གུན༌ནི༌ ཟེར༌ཁན༌བོ༌ ཀྲང༌པོ༌ ཨིན༌ན༌ མན༌ ལྟ༌ཅེས༌ལ༌ ངའེ༌ གྱལ༌པོའེ༌ མིང༌ངི༌ ནའ༌ ཁུར༌རད༌, ཁྱོ༌ཞའེ༌ ནོ༌ ཆུང༌ཤོག༌པོ༌ འི༌རུ༌ ཡོངས༌ཏེ༌ མ༌ནེ༌ ཁྱོ༌ཞའ༌ འི༌ ནས༌ས༌ནེ༌ བིངས༌ཏེ༌ ཆ༌ མི༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ཁྱོ༌ཞའེ༌ ནང༌ནེ༌ ཅིག༌, ནོ༌ ཁྱོང༌ང༌ལ༌ སོང༌, ཞན༌གུན༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ བོར༌ཨིན༌ ནམ༌ཚོག༌པ༌ ཁྱོ༌ཞའེ༌ ཟེར༌ཁན༌བོ༌ ཀྲང༌པོ༌ མི༌བིང༌, ཀལ༌ཏེས༌ ཀྲང༌པོ༌ མ༌བིང༌ན༌ གྱལ༌པོའེ༌ སོན༌པོ༌ འིན༌ན༌ ཙོགས༌ལ༌ ཁྱོ༌ཞའ༌ གྲ༌འོ༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ཡོང༌ཁན༌བོ༌ ཏན༌ཏན༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ཏེ༌ནེ༌ ཁོའེ༌ ཁོང༌གུན༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ ཞག༌པོ༌ སུམ༌མི༌ ཕིའ༌ ཀག༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ཞག༌པོ༌ སུམ༌པའེ༌ ཞག༌ག༌ ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ང༌ དཀོན༌མཆོག༌ག༌ ཇིགས༌ཁན༌ནི༌ མི༌ཞིག༌ ཨིན༌། ངའེ༌ ཟེར༌ཁན༌བོ༌ ཅོ༌ན༌ ཁྱོ༌ཞ༌གུན༌ སོན༌ཏེའ༌ ལུས༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ཁྱོ༌རང༌གུན༌ ཀྲང༌པོ༌ ཨིན༌ན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ནང༌ནེ༌ ཅིག༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ དུག༌, ཞན༌གུན༌ནི༌ ཁྱོ༌ཞའེ༌ ནང༌མི༌ སྟོག༌རིའ༌ ཡོད༌ཁན༌གུན༌ནི༌ ཕིའ༌ གྲུ༌ ཉོས༌ཁན༌བོ༌ ཁྱེར༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ཨིན༌ནའང༌ ཁྱོ༌ཞའེ༌ ཟེར༌ཁན༌བོ༌ ཀྲང༌པོ༌ ཨིན༌ཁན༌ སྟན༌ཅེས༌ལ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ནོ༌ ཆུང༌ཤོག༌པོ༌ ང༌ ཡོད༌ས༌ ཁྲིད༌ཏེ༌ ཁྱོང༌གོས༌། ཏེ༌ནེ༌ ངའེ༌ ཁྱོ༌རང༌གུན༌ སད༌ མི༌སད༌།” ཁོང༌གུན༌ནི༌ ཏེ༌བོ༌ ཅོ༌ཅེས༌ལ༌ ཁའ༌ ཆམས༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ཁོང༌གུན༌ནི༌ ཅིག༌ དང༌ ཅིག༌ག༌ ཟེརས༌, “ཏན༌ཏན༌ལ༌, ང༌དང༌གུན༌ནི༌ ནོ༌ ཉམ༌པོ༌ ཅོ༌ཁན༌བོའེ༌ ཞས༌ཏེ༌ ང༌དང༌གུན༌ལ༌ ཆད༌པ༌ ཕོག༌ཏེ༌ ཨིན༌ནོག༌། ཁོའ༌ ནོད༌པ༌ མི༌སྐྱལ༌ཅེས༌ལ༌ ཞུ༌ཝ༌ ཕུལ༌ ཟ༌ནེ༌ ཁོ༌ ཚེར༌ཁ༌ དང༌ ཇིགས༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ང༌དང༌གུན༌ནི༌ ཐོང༌ ཨིན༌ནའང༌ ང༌དང༌གུན༌ནི༌ ཁོའེ༌ ཞུ༌ཝ༌ མ༌ཉནས༌། ཏེན༌ན༌བོའེ༌ ཞས༌ཏེ༌ དག༌ས༌ ང༌དང༌གུན༌ལ༌ ནགས༌ ཐོང༌ཨིན༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","རུ༌བེན༌ནི༌ ཟེརས༌, “ངའེ༌ ཁྱོ༌ཞའ༌ ཟེར༌ར༌ མེ༌རག༌ག༌ ‘བུ༌ཚའེ༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ མ༌ཅོ༌’ ཨིན༌ནའང༌ ཁྱོ༌ཞའེ༌ མ༌ཉནས༌། ཏ༌ ང༌དང༌གུན༌ལ༌ ཁོའེ༌ སྲོག༌རིན༌ ཤལ༌གོས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ཁོང༌གུན༌ནི༌ ཟེར༌ཁན༌གུན༌ ཡོ༌སེབ༌བ༌ ཧ༌གོ༌ཅེས༌པོ༌ ཁོང༌གུན༌ལ༌ མ༌ཤེས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ སྐད༌གྱུར༌ཁན༌ ཀོལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ཡོ༌སེབ༌ ཁོང༌གུན༌ནེ༌ ཐག༌རིང༌ང༌ སོང༌ཏེ༌ ངུས༌ ཨིན༌ནའང༌ ཡང༌སྐྱར༌ ལོགས༌ཏེ༌ ཡོངས༌ཏེ༌ ཁོང༌གུན༌ལ༌ སྤེ༌ར༌ ཏངས༌། ཁོང༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཁོའེ༌ སི༌མེ༌འོན༌ ཁྱེར༌ཏེ༌ ཚང༌མའེ༌ དུན༌ལ༌ ཁོ༌ ལྡམས༌ཏེ༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ བོར༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ཡོ༌སེབ༌བི༌ ཁོའེ༌ ཨ༌ཅོ༌གུན༌ནི༌ ཕ༌ཙ༌གུན༌ གྲུའི༌ སྐང༌ཅུགས༌, ཁོང༌གུན༌ནི༌ པེ༌ནེ༌ གྲུའི༌ ཕ༌ཙའེ༌ ནང༌ང༌ ལོགས༌ཏེ༌ གྱང༌ཅུགས༌ ཡང༌ ཁོང༌གུན༌ནི༌ བེས༌སི༌ ཕིའ༌ ཁར༌ཇི༌ ཏང༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། ཏེ༌གུན༌ ཅོས༌ ཚར༌ར༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ཨ༌ཅོ༌གུན༌ནི༌ ཁོང༌རང༌ངི༌ བུང༌བུ༌གུན༌ནི༌ཀ༌ གྲུའི༌ ཁུ༌རུ༌ ཀལས༌ ཡང༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ཁོང༌གུན༌ ཚན༌ལ༌ དུགས༌སའེ༌ ནས༌སའེ༌ཀ༌ ཁོང༌ ཅིག༌གི༌ ཁོ༌རང༌ངི༌ བུང༌བུའ༌ གྲུ༌ ཏང༌ཅེས༌ལ༌ ཕ༌ཙ༌བོ༌ ཕེས༌པ༌ ཁོ༌རང༌ངི༌ པེ༌ནེ༌བོ༌ ཕ༌ཙའེ༌ ཁའེ༌ཀ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ཁོའེ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ལ༌ ཟེརས༌, “ངའེ༌ པེ༌ནེ༌ ཕ༌ཙའེ༌ གྲུ༌ ཉམ༌པོ༌ ལོགས༌ཏེ༌ ཏངས༌ཏེ༌ དུག༌།” ཁོང༌གུན༌ ཇིགས༌ཏེ༌ སྲན༌ཏྲེ༌ དར༌ཨིན༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ང༌དང༌གུན༌ ཉམ༌པོ༌ ཅི༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌?” ");
INSERT INTO lbj_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ཁོང༌གུན༌ ཀེ༌ནན༌ལ༌ ཁོ༌རང༌གུན༌ནི༌ ཨ༌བ༌ ཡ༌ཀོབ༌ ཡོད༌ས༌ ལེབ༌བ༌ཅིག༌, ཁོང༌གུན༌ནི༌ ཇུང༌ཁན༌ ཚང༌མ༌ ཁོའ༌ ཤདས༌། ཁོང༌གུན༌ནི༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ཨི༌ཇིབ༌བི༌ ལོན༌པོའི༌ ང༌ཞའ༌ ཉམ༌པོ༌ སྤེ༌ར༌ སྐྱོང༌པོ༌ ཏངས༌ ཡང༌ ‘ང༌ཞའ༌ ཁོའེ༌ ཡུལ༌ལི༌ ནང༌ང༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ལྟའ༌ལ༌ ཡོང༌ཏེ༌ ཨིན༌ནོག༌’ ཟེར༌ཏེ༌ ཉད༌གལ༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ཨིན༌ནའང༌ ང༌ཞའེ༌ ཁོའ༌ ཟེར༌པིན༌ ‘ང༌ཞ༌གུན༌ མི༌ ཀྲང༌པོ༌ ཨིན༌ གྲ༌འོ༌ མན༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ང༌ཞའ༌ ཨ༌ཅོ༌ནོ༌ རྕུག༌ཉིས༌ ཡོད༌, ཨ༌བ༌ ཅིག༌ཅིག༌གི༌ བུ༌ཚ༌གུན༌, ཅིག༌ཅིག༌ ཤི༌ ཡང༌ ཆུང༌ཤོག༌པོ༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ང༌ཞའེ༌ ཨ༌བ༌ ཉམ༌པོ༌ ཡོད༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“ཏེ༌ནེ༌ ཏེ༌ ས༌ཆའེ༌ ལོན༌པོའེ༌ ཟེར༌ར༌རག༌, ‘ཁྱོ༌ཞའེ༌ ཟེར༌ཁན༌བོ༌ ཀྲང༌པོ༌ ཨིན༌ཁན༌ ཏན༌ཏན༌ ཅོ༌ཅེས༌ལ༌ ཁྱོ༌ཞའེ༌ ནང༌ནེ༌ ཅིག༌ འི༌ཀ༌ བོར༌ཏེ༌ ཞན༌གུན༌ནི༌ ཁྱོ༌ཞའེ༌ ནང༌ཚངས༌ལ༌ སྟོག༌རི༌ མི༌ཐོང༌ཅེས༌སི༌ ཕིའ༌ གྲུ༌ ཉོས༌ཁན༌བོ༌ ཁྱེར༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ཡང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ནོ༌ ཆུང༌ཤོག༌པོ༌ ངའ༌ ཡོད༌ས༌ ཁྲིད༌ཏེ༌ ཁྱོང༌ ཏེ༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ མི༌ ཀྲང༌པོ༌, གྲ༌འོ༌ མན༌ཁན༌བོ༌ ངའ༌ གྱུས༌ཆེན༌། ཡང༌ ངའེ༌ ཁྱོ༌རང༌གུན༌ནི༌ ནོ༌ ལོགས༌ཏེ༌ ཏང༌ཨིན༌ ཡང༌ ཁྱོ༌རང༌གུན༌ འི༌རུ༌ དུག༌ཏེ༌ ཚོང༌ ཅོ༌ནའང༌ གྲིག༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ཁོང༌གུན༌ནི༌ རང༌རང༌ངི༌ ཕ༌ཙ༌ ནང༌ནེ༌ གྲུ༌ ལུག༌ ཟ༌ནེ༌ ཁོང༌གུན༌ནི༌ པེ༌ནེ༌ སྒི༌གུ༌བོ༌ ཐོང༌ ཡང༌ ཁོང༌གུན༌ནི༌ པེ༌ནེ༌ སྒི༌གུ༌ ཐོང༌ང༌ཅིག༌ ཁོང༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ ཨ༌བ༌ སྲན༌ཏྲེ༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ཨ༌བའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌གུན༌ནི༌ ངའ༌ ཕྲུ༌གུ༌ མེད༌ཁན༌ ཅོའ༌ནོག༌, ཡོ༌སེབ༌ སྟོར༌, སི༌མེ༌འོན༌ འི༌རུ༌ མེད༌, ཏ༌ བེན༌ཡཱ༌མིན༌ནའང༌ ཁྱེར༌རད༌ད༌? འི༌ ཚང༌མ༌ ངའེ༌ཀ༌ ཇུང༌གོས༌ས༌?” ");
INSERT INTO lbj_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","རུ༌བེན༌ནི༌ ཨ༌བ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ངའེ༌ བེན༌ཡཱ༌མིན༌ ལོགས༌ཏེ༌ མ༌ཁྱོང༌ན༌, ཉེ༌རང༌ངི༌ ངའེ༌ བུ༌ཚ༌ ཉིས༌ཀོ༌ སད༌ནའང༌ གྲིག༌། ལོ༌ཁྱེལ༌ ཛད༌ཏེ༌ ཁོ༌ ངའེ༌ ལག༌ག༌ སལ༌ ཡང༌ ངའེ༌ ཁོ༌ ལོགས༌ཏེ༌ ཁྱོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ཨིན༌ནའང༌ ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ངའེ༌ བུ༌ཚ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ མི༌ཆ༌། ཁོའེ༌ ཨ༌ཅོ༌ ཤི༌, ཏ༌ ཁོ༌ མ༌ནེ༌ ལུས༌ཏེ༌ མེད༌། བེས༌སི༌ ནང༌ང༌ ཀལ༌ཏེས༌ ཁོ༌ ཉམ༌པོ༌ ངན༌པ༌ ཆ༌ན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའ༌ རྒད༌པོ༌ མིའ༌ རྡུག༌ངལ༌ སྟན༌ཏེ༌ ཤི༌ ཅུག༌ག༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ཏ༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ མུ༌གེ༌བོ༌ མང༌ང༌ ཐུའ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ཡ༌ཀོབ༌བི༌ ནང༌ཚང༌གུན༌ནི༌ ཨི༌ཇིབ༌ནེ༌ ཁྱོངས༌ཁན༌ནི༌ གྲུ༌ ཚང༌མ༌ ཟའ༌ ཚར༌ར༌ཅིག༌, ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ལ༌ ཟེརས༌, “ཡང༌སྐྱར༌ ཟའ༌ཅེས༌ ཉོའ༌ལ༌ ཨི༌ཇིབ༌བ༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ཨིན༌ནའང༌ ཡ༌ཧུ༌དཱའེ༌ ཨ༌བའ༌ ཟེརས༌, “གྲུ༌ ཙོང༌ཁན༌ནི༌ མི༌བོའེ༌, ནོ༌ ཆུང༌ཤོག༌པོ༌ ཁྲིད༌ཏེ༌ མ༌ནེ༌ ཁོ༌ ཡོད༌ས༌ མི༌ཡོང༌ཅེས༌ལ༌ ང༌ཞའ༌ སྤང༌པུད༌ད༌ རག༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ཀལ༌ཏེས༌ ཉེ༌རང༌ངི༌ ང༌ཞའེ༌ ནོ༌ ང༌ཞ༌གུན༌ ཉམ༌པོ༌ ཀལ༌ན༌ ང༌ཞ༌གུན༌ ཉེ༌རང༌ངི༌ ཕིའ༌ ཟའ༌ཅེས༌ ཉོའ༌ལ༌ ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ཨིན༌ནའང༌ ནོ༌ མ༌ཀལ༌ན༌ ང༌ཞ༌གུན༌ མི༌ཆ༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌ མི༌བོའེ༌ ང༌ཞའ༌, ནོ༌ ཁྲིད༌ཏེ༌ མ༌ནེ༌ ཁོ༌ ཡོད༌ས༌ མ༌ཡོང༌ ཟེར༌ར༌རག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ཁྱོ༌ཞའ༌ ནོ༌ ཡོད༌ཁན༌བོ༌ ཏེ༌ མི༌བོའ༌ ཤད༌ཏེ༌, ཅི༌ཕིའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའ༌ ནགས༌ སྟན༌ཏེ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “མི༌བོའེ༌ ང༌ཞའ༌ དང༌ ང༌ཞའེ༌ ནང༌ཚངས༌སི༌ སྐོར༌ལ༌ ཏྲི༌ཨིན༌ དུགས༌། ཁོའེ༌ ཏྲིས༌ ‘ཁྱོ༌རང༌གུན༌ནི༌ ཨ༌བ༌ སོན༌ཏེའ༌ ཡོད༌ད༌? ཁྱོ༌རང༌གུན༌ལ༌ ཡང༌ ནོ༌ ཡོད༌ད༌?’ ང༌ཞའེ༌ ཁོའེ༌ ཏྲི༌ཝ༌གུན༌ལ༌ ལན༌ཏངས༌པིན༌། ཁོའེ༌, ‘ཁྱོ༌ཞའེ༌ ནོ༌ ཁྲིད༌ཏེ༌ ཁྱོང༌’ ཟེར༌ཅེས༌པོ༌ ང༌ཞ༌གུན༌ལ༌ ཅི༌གྱུས༌?” ");
INSERT INTO lbj_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ཡ༌ཧུ༌དཱའེ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཟེརས༌, “བུ༌ཚ༌བོ༌ ང༌ ཉམ༌པོ༌ ཀོལ༌ ཡང༌ ང༌ཞ༌གུན༌ དག༌ས༌རང༌ བེས༌ལ༌ བིང༌ཨིན༌། ཏེ༌ནེ༌ ཉེ༌རང༌, ང༌ཞའ༌ དང༌ ང༌ཞའེ༌ ཕྲུ༌གུ༌གུན༌ སྟོག༌རིའ༌ མི༌ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ཁོའེ༌ སྲུང༌སྐྱོབ༌བི༌ དམ༌ཆའ༌ ངའེ༌ ཅོའད༌, ཏེ༌ ཁག༌པོ༌ ངའེ༌ ཁུར༌རད༌། ཀལ༌ཏེས༌ ངའེ༌ ཁོ༌ ཉེ༌རང༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ མ༌ཁྱོང༌ན༌ ཏུས༌གྱུན༌ནི༌ ཕིའ༌ ངའེ༌ཀ༌ ཏེ༌ སྐྱོན༌བོ༌ ཀལ༌ལ༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ཀལ༌ཏེས༌ ང༌དང༌ངི༌ ཏུས༌པོ༌ གོད༌ལ༌ མ༌ ཏངས༌པིན༌ན༌ ང༌ཞ༌གུན༌ ཏེ༌རུ༌ སོང༌ཏེ༌ ལན༌ཕོག༌ ཉིས༌ ལོག༌ཏེ༌ ཡོང༌ ཚར༌ཏེ༌ ཡོད༌གྲོ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཨ༌བ༌ ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཏེ༌བོ༌ ཅོ༌གོས༌ན༌ ཅོ༌ཤིག༌, ཡང༌ ང༌དང༌ངི༌ ས༌ཆའེ༌ ཀ༌ནེ༌ ཐོང༌ཁན༌ ཀྲག༌ཤོག༌པོ༌ ལོན༌པོའ༌ སྟགས༌ལ༌ ཁྱེར༌, ཏྲི༌ཞིམ༌ཅན༌ནི༌ མར༌ནག༌, རང༌རྩི༌, ཚ༌མིག༌ དང༌ མའེར༌, པིས༌ཏ༌ དང༌ བ༌དམ༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","པེ༌ནེ༌ ཉི༌ལྡབ༌ ཁུར༌ ཅིའ༌ཟེར༌ན༌ ཕ༌ཙའེ༌ ཁེ༌ཐོག༌ག༌ ཡོད༌ཁན༌ནི༌ པེ༌ནེ༌གུན༌ ལོགས༌ཏེ༌ ཁྱེར༌གོས༌། ཅི༌གྱུས༌ ཏེ༌བོ༌ ནོར༌ཏེ༌ ཨིན༌གྲོ༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ཁྱོ༌ཞ༌གུན༌ ནོ༌ ཁྲིད༌ཏེ༌ དག༌ས༌རང༌ ཏེ༌ མི༌བོའེ༌ཀ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ངའེ༌ མོས༌ལམ༌ ཞུའད༌, ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ཏེ༌ མི༌བོའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ཀ༌ སྙིང༌རྗེ༌ སྐྱེ༌ཅུག༌ག༌ ཛད༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཨ༌ཅོ༌ དང༌ བེན༌ཡཱ༌མིན༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ལོགས༌ཏེ༌ ལམ༌ཅུག༌ སྲིད༌ཅེས༌ ཨིན༌ནོག༌། ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ངའེ༌ ཕྲུ༌གུ༌གུན༌ ལོགས༌ཏེ༌ མ༌ ལེབ༌ན༌ ངའེ༌ཀ༌ ཏེ༌བོ༌ ཇུང༌གོ༌ཤེས༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ཏེ༌ནེ༌ བུ༌ཚ༌གུན༌ནི༌ སྐྱེས༌གུན༌ དང༌ པེ༌ནེ༌ ཉི༌ལྡབ༌ ཁུརས༌ ཡང༌ ཨི༌ཇིབ༌བ༌ བེན༌ཡཱ༌མིན༌ ཁྲིད༌ཏེ༌ སོང༌, ཡང༌ ཁོང༌གུན༌ ཡོ༌སེབ༌ ཡོད༌ས༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ ཉམ༌པོ༌ བེན༌ཡཱ༌མིན༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཁང༌པའེ༌ སྟ༌སྟོག༌ ཅོ༌ཁན༌བོའ༌ ཟེརས༌, “འི༌ མི༌གུན༌ ངའེ༌ ཁང༌པ༌ ཁྱེར༌, སེམས༌ཅན༌ སད༌ཏེ༌ ཁར༌ཇི༌ གྲལ༌གྲིག༌ ཅོས༌, ཁོང༌གུན༌ ང༌ ཉམ༌པོ༌ ཛ༌ར༌ ཟའེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ཡོ༌སེབ༌བི༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཡོག༌པོའེ༌ ཅོས༌ ཡང༌ ཁོང༌གུན༌ ཡོ༌སེབ༌བི༌ ཁང༌པ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ཨིན༌ནའང༌ ཁང༌པ༌ ཁྱེར༌ར༌ཅིག༌ ཁོང༌གུན༌ སྲན༌ཏྲེ༌ ཇིགས༌ ཡང༌ སམ༌, “ང༌དང༌གུན༌ནི༌ ཕ༌ཙའེ༌ ནང༌ང༌ པེ༌ནེ༌ ལོགས༌ཏེ༌ ཏངས༌ཏེ༌ ཡོད༌ཅེས༌པའེ༌ ང༌དང༌གུན༌ འི༌ཀ༌ ཁྱོངས༌ཏེ༌ ཨིན༌ནོག༌། ཁོའེ༌ ང༌དང༌གུན༌ ཟུམས༌ཏེ༌ ང༌དང༌གུན༌ ཡོག༌པོ༌ ཅོ༌ཅེས༌ ཡང༌ ང༌དང༌ངི༌ བུང༌བུ༌གུན༌ ཁྱེར༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཁང༌པའེ༌ སྒོའེ༌ དུན༌ལ༌ ལེབ༌བ༌ཅིག༌ ཁོང༌གུན༌ནི༌ ཡོག༌པོ༌ ཁག༌ཁུར༌པ༌བོའ༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“སྤོན༌བོ༌ལེ༌, ང༌ཞ༌གུན༌ སྔུན༌ལ༌ གྲུ༌ ཉོའ༌ལ༌ ཨི༌ཇིབ༌བ༌ ཡོངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ཨིན༌ནའང༌ ལམ༌མ༌ ངལ༌ཚོ༌སའེ༌ཀ༌ ང༌ཞའེ༌ ཕ༌ཙའེ༌ ཁའ༌ ཕེའ༌ཅིག༌ རང༌རང༌ངི༌ པེ༌ནེ༌ སྒི༌གུ༌གུན༌ ཐོང༌། ང༌ཞའེ༌ ཏེ༌ པེ༌ནེ༌གུན༌ ལོགས༌ཏེ༌ ཁྱོངས༌ཏེ༌ ཡོད༌ལེ༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","གྲུ༌ ཉོ༌ཅེས༌ལ༌ ང༌ཞ༌གུན༌ནི༌ མུལ༌ལི༌ པེ༌ནེ༌ ཐེ༌བ༌ ཁྱོངས༌ཏེ༌ ཡོད༌། ང༌ཞའེ༌ ཕ༌ཙའེ༌ ནང༌ང༌ པེ༌ནེ༌ སྒི༌གུ༌གུན༌ སུའི༌ བོརས༌ ང༌ཞའ༌ གྱུས༌མེད༌ ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ཡོག༌པོའེ༌ ཟེརས༌, “ཇིགས༌ མ༌ཇིགས༌, ཁྱོ༌ཞའ༌ དང༌ ཁྱོ༌ཞའེ༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞའ༌ ནོར༌ སལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ངའ༌ གྲུའི༌ རིན༌ནི༌ པེ༌ནེ༌ དྲན༌དྲའ༌ ཐོབས༌།” ཏེ༌ནེ༌ ཁོའེ༌ སི༌མོན༌ ཁོང༌གུན༌ནི༌ ཕིའ༌ ཙོན༌ཁང༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ཏེ༌ནེ༌ ཡོག༌པོའེ༌ ཁོང༌གུན༌ ཁང༌པའེ༌ ནང༌ང༌ ཁྱེར༌ཏེ༌ ཆུ༌ ཏངས༌ ཡང༌ ཁོང༌གུན༌ནི༌ རྐང༌པ༌ ཁྲུ༌། ཁོའེ༌ ཁོང༌གུན༌ནི༌ བུང༌བུ༌གུན༌ལ༌ རྩའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ཁོང༌གུན༌ནི༌ ཡོ༌སེབ༌བ༌ སྟགས༌གུན༌ ཏང༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཅོས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཡོ༌སེབ༌ ཛ༌ར༌ དོན༌ཅེས༌ལ༌ སྐྱོད༌ཨིན༌ ཟེར༌ཏེ༌ ཡོག༌པོའེ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ཡོ༌སེབ༌ ཁང༌པ༌ ལེབ༌བ༌ཅིག༌ ཁོང༌གུན༌ནི༌ སྟགས༌ ཁྱོང༌ཁན༌གུན༌ ཁོའ༌ ཕུལ༌ཏེ༌ གོ༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ སྒུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཁམ༌ཟང༌ ཨིན༌ན༌ ཟེར༌ཏེ༌ ཏྲིས༌ ཡང༌ ཟེརས༌, “ངའ༌ མི༌ རྒད༌པོའེ༌ སྐོར༌ལ༌ ཤད༌ཁན༌ ཁྱོ༌ཞའེ༌ ཨ༌བ༌ ཁམ༌ཟང༌, སོན༌ཏེའ༌ ཡོད༌ད༌?” ");
INSERT INTO lbj_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞ༌གུན༌ནི༌ ཨ༌བ༌ ཉེ༌རང༌ངི༌ ཡོག༌པོ༌ ཁམ༌ཟང༌ དང༌ སོན༌ཏེའ༌ ཡོད༌ལེ༌།” ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ གོ༌ སྒུས༌ཏེ༌ ཀུས༌པ༌ སྟནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ཡོ༌སེབ༌བི༌ ལྟའ༌ཅིག༌ ཁོའ༌ ཁོ༌རང༌ངི༌ ནོ༌, ཨ༌མ༌ ཅིག༌གི༌ བུ༌ཚ༌ བེན༌ཡཱ༌མིན༌ ཐོང༌ ཡང༌ ཏྲིས༌, “ཁོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ནོ༌ ཆུང༌ཤོག༌པོ༌ ཨིན༌ན༌ ཀ༌བོའེ༌ སྐོར༌ལ༌ ཁྱོ༌ཞའེ༌ ངའ༌ ཤདས༌? ངའེ༌ བུ༌ཚ༌, ཁྱོ༌རང༌ང༌ དཀོན༌མཆོག༌གི༌ ཅིན༌ལབས༌ སལ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ཁོ༌རང༌ངི༌ ནོའེ༌ ཕིའ༌ ཤ༌ཚ༌ སྐྱེས༌ཏེ༌ ཁོའ༌ ངུ༌ཅེས༌ ཡོངས༌པ༌ ཡོ༌སེབ༌ གྱོགས༌པ༌ ཁོ༌རང༌ངི༌ ནང༌ང༌ སོང༌ ཡང༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ཏེ༌ནེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ལྡོང༌ ཁྲུས༌ཏེ༌ ལོགས༌ཏེ༌ ཡོངས༌ ཡང༌ རང༌སེམས༌ ཅུན༌ཏེ༌ ཁོའེ༌ དོན༌ཏང༌ ཁྱོང༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ཡོ༌སེབ༌བ༌ ཅོག༌ཙེ༌ ཅིག༌གི༌ཀ༌ ཡང༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌གུན༌ལ༌ ཞན༌ ཅོག༌ཙེ༌ ཞིག༌གི༌ཀ༌ ཡང༌ ཁོ༌ ཉམ༌པོ༌ དོན༌ཁན༌ནི༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ སོ༌སོ༌ ཅོག༌ཙེ༌ཀ༌ དོན༌ཏང༌ ཏངས༌ ཅིའ༌ཟེར༌ན༌ ཨི༌ཇིབ༌པ༌གུན༌ ཨིབ༌རི༌པ༌གུན༌ ཉམ༌པོ༌ ཟའ༌ ཆོགས༌ས༌ མེད༌པིན༌, ཏེ༌བོ༌ ཁོང༌གུན༌ནི༌ ཕིའ༌ ཚི༌ཏུའེ༌ ལས༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ཅོག༌ཙེ༌ཀ༌ ཡོ༌སེབ༌བི༌ ཨ༌ཅོ༌ནོ༌གུན༌ ལོ༌ ནང༌ཞིན༌ ཚིར༌ལ༌ དུག༌ཅུགས༌ པ༌སང༌ ཧ༌ལས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཅིག༌ དང༌ ཅིག༌ག༌ ལྟས༌། ");
INSERT INTO lbj_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ཁོང༌གུན༌ལ༌ ཡོ༌སེབ༌བི༌ ཅོག༌ཙེ༌ ཀ༌ནེ༌ ཁར༌ཇི༌ ཏངས༌ ཨིན༌ནའང༌ བེན༌ཡཱ༌མིན༌ནི༌ སྐལ༌ལ༌ ཞན༌གུན༌ནི༌ སང༌ རྔ༌ ལྡབ༌ མང༌ང༌ ཡོད༌པིན༌། ཁོང༌གུན༌ནི༌ ཉན༌ཉན༌ ཟའེན༌ ཐུང༌ཨིན༌ ཡོ༌སེབ༌ ཉམ༌པོ༌ སྐྱིད༌པོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ཡོ༌སེབ༌བི༌ ཁོང༌རང༌ངི༌ ཁང༌པའེ༌ ཁག༌ཁུར༌པའ༌ བཀའ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཁོང༌གུན༌ནི༌ ཕ༌ཙ༌གུན༌ནི༌ ཁའ༌ ཚག༌པ༌ སྐངས༌ཏེ༌ གྲུ༌ གྱོང ཡང༌ པེ༌ནེ༌ གི༌གུ༌ ཁོང༌གུན༌ནི༌ ཕ༌ཙའེ༌ ཁའེ༌ཀ༌ ལོགས༌ཏེ༌ གྱོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ནོ༌ ཆུང༌ཤོག༌གི༌ ཕ༌ཙའེ༌ ཁའེ༌ཀ༌ གྲུ༌ ཉོས༌ཁན༌ནི༌ པེ༌ནེ༌ ཉམ༌པོ༌ ངའེ༌ མུལ༌ལི༌ ཀོ༌རེ༌བོའང༌ གྱོང༌།” ཁོའེ༌ ཡོ༌སེབ༌བི༌ ཅོས༌ ཟེར༌ཁན༌བོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཨ༌ཅོ༌ནོ༌གུན༌ ཁོ༌རང༌གུན༌ནི༌ བུང༌བུ༌ ཉམ༌པོ༌ ལོགས༌ཏེ༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ཁོང༌གུན༌ གྱལ༌ས༌ནེ༌ མ༌ ཐག༌རིང༌ང༌ མེད༌ ཟ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ཁང༌པའེ༌ ཁག༌ཁུར༌པའ༌ ཟེརས༌, “གྱོགས༌པ༌ ཏེ༌ མི༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ སོང༌ ཡང༌ ཁོང༌གུན༌ ཐུག༌ག༌ཅིག༌ ཟེར༌, ‘ཟང༌པོའེ༌ ཚབས༌ལ༌ ངན༌པ༌ ཅིའ༌ ཅོས༌པིན༌? ");
INSERT INTO lbj_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ཁྱོ༌ཞའེ༌ ངའེ༌ སྤོན༌བོའེ༌ དོན༌ཅེས༌ དང༌ མ༌འོངས༌པའེ༌ ཏུས༌སི༌ ནང༌ང༌ ཇུང༌ཅེས༌གུན༌ ལྟའ༌ལ༌ ཀོལ༌ཁན༌ནི༌ མུལ༌ལི༌ ཀོ༌རེ༌ ཅིའ༌ རྐུས༌པིན༌? ཁྱོ༌ཞའེ༌ ངན༌པ༌ ལས༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ཡོག༌པོའེ༌ ཁོང༌གུན༌ ཐུག༌ག༌ཅིག༌, ཁོའེ༌ ཏེན༌ན༌ ཙོགས༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “སྤོན༌བོ༌ལེ༌ ཉེ༌རང༌ངི༌ ཏེ༌ཟུག༌ ཅིའ༌ མོལ༌ལད༌? ཏན༌ཏན༌ ང༌ཞའེ༌ ཏེ༌ཟུག༌ ལས༌ མ༌ཅོས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ཕ༌ཙའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ པེ༌ནེ༌ ང༌ཞའེ༌ ཀེ༌ནན༌ནེ༌ ལོགས༌ཏེ༌ ཁྱོངས༌ཏེ༌ ཉེ༌རང༌ང༌ མ༌ཏངས༌ས༌? ཏེ༌ནེ༌ ཉེ༌རང༌ངི༌ སྤོན༌བོའེ༌ ཁང༌པ༌ནེ༌ མུལ༌ ཡ༌ སེར༌ ང༌ཞ༌གུན༌ནི༌ ཅིའ༌ རྐུ༌ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ང༌ཞའ༌ སུ༌ཞིག༌གི༌ ལག༌ནེ༌ ཏེ༌བོ༌ ཐོབ༌ན༌ ཁོ༌ སད༌ནའང༌ གྲིག༌ ཡང༌ ང༌ཞའ༌ ལུས༌ཁན༌ ཚང༌མ༌ ཉེ༌རང༌ངི༌ སྤོན༌བོའེ༌ ཚེ༌ཡོག༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ཁོའེ༌ ཟེརས༌, “ཁྲིག༌རག༌། ཨིན༌ནའང༌ ཀོ༌རེ༌ ཐོབ༌ཁན༌ ཅིག༌པོ༌ ངའེ༌ ཚེ༌ཡོག༌ གྱུར༌ཨིན༌, ཞན༌གུན༌ ལོགས༌ཏེ༌ ཆ༌ནའང༌ གྲིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ཁོང༌གུན༌ནི༌ གྱོགས༌པ༌ ཁོ༌རང༌གུན༌ནི༌ ཕ༌ཙ༌ སའི༌ཀ༌ ཕབས༌ཏེ༌ ཁའ༌ ཕེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ཏེ༌ནེ༌ ཡོག༌པོའེ༌ ཙལ༌ཅེས༌ གོ༌ཟུག༌, ཆེ༌ཤོག༌ནེ༌ ཏངས༌ཏེ༌ ཆུང༌ཤོག༌ ཚོག༌པ༌ ཡང༌ ཀོ༌རེ༌བོ༌ བེན༌ཡཱ༌མིན༌ནི༌ ཕ༌ཙའེ༌ ནང༌ང༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ཏེ༌བོ༌ ཐོང༌ཏེ༌ ཨ༌ཅོ༌གུན༌ནི༌ ཚེར༌ཁའེ༌ ནང༌ང༌ ཁོ༌རང༌གུན༌ནི༌ ཀོས༌ ཤགས༌ ཡང༌ ཁོ༌རང༌གུན༌ནི༌ བུང༌བུ༌གུན༌ལ༌ གལ༌ ཀལ༌ཏེ༌ གྱལ༌ས༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ཡ༌ཧུ༌དཱ༌ དང༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌གུན༌ནི༌ ཡོ༌སེབ༌བི༌ ཁང༌པ༌ ལེབ༌བ༌ཅིག༌ ཁོ༌ ཏེ༌རུ༌ ཡོད༌པིན༌། ཁོང༌གུན༌ ཁོའེ༌ རྐང༌པའེ༌ཀ༌ གྱེལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ འི༌བོ༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ངའ༌, སྦས༌ཏེ༌ ཅོ༌ཁན༌གུན༌ ཤད༌ ཉན༌ཁན༌ནི༌ མི༌ཞིག༌ ཨིན༌ཁན༌བོ༌ ཁྱོ༌ཞའ༌ གྱུས༌ མེ༌ད༌?” ");
INSERT INTO lbj_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ཡ༌ཧུ༌དཱའེ༌ ལན༌ཏངས༌, “སྤོན༌བོ༌ལེ༌ ང༌ཞའེ༌ ཉེ༌རང༌ང༌ ཅི༌ ཞུ༌? ང༌ཞའེ༌ ཅི༌ ཟེར༌? ཀ༌ཟུག༌གི༌ ང༌ཞའེ༌ ང༌ཞའ༌ ནོངས༌མེད༌ ཨིན༌ཁན༌བོ༌ སྟན༌? དཀོན༌མཆོག༌གི༌ ང༌ཞའེ༌ ཅོ༌ཁན༌ནི༌ སྡིག༌པ༌ སྟན༌ན༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ཏ༌ ཀོ༌རེ༌ ཐོབ༌ཁན༌བོ༌ ཅིག༌པོ༌ མན༌པ༌ ང༌ཞའ༌ ཚང༌མ༌ ཉེ༌རང༌ངི༌ ཚེ༌ཡོག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ཨིན༌ནའང༌ ཡོ༌སེབ༌བི༌ ཟེརས༌, “ངའེ༌ ཏེ༌ཟུག༌ མ༌ནེ༌ མི༌ཅོ༌། ཀོ༌རེ༌ ཐོབ༌ཁན༌བོ༌ ཅིག༌པོ༌ ངའེ༌ ཚེ༌ཡོག༌ གྱུར༌གོས༌། ཞན༌གུན༌ ཞི༌དེ༌ ཉམ༌པོ༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཨ༌བ༌ ཡོད༌ས༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ཡ༌ཧུ༌དཱ༌ ཡོ༌སེབ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “ཇུ༌ཇུ༌ སྤོན༌བོ༌ལེ༌, ཉེ༌རང༌ངི༌ ཡོག༌པོའ༌ སྤེ༌ར༌ ཞིག༌ ཟེར༌ཅུག༌ག༌ ཛད༌། ངའེ༌ཀ༌ ཐུགས༌སྲོ༌ མ༌སྐྱོད༌, ཉེ༌རང༌ང༌ ཝང༌ཆ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཙོགས༌ ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","སྤོན༌བོ༌ལེ༌ ཉེ༌རང༌ངི༌ ང༌ཞའ༌ ཏྲིའ༌ ཛདས༌, ‘ཁྱོ༌ཞ༌གུན༌ལ༌ ཨ༌བ༌ ཡ༌ ཞན༌ ཨ༌ཅོ༌ནོ༌ ཡོད༌ད༌?’ ");
INSERT INTO lbj_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ཡང༌ ང༌ཞའེ༌ ཉེ༌རང༌ང༌ ལན༌ཏངས༌པིན༌, ‘ང༌ཞ༌གུན༌ལ༌ ཨ༌བ༌ རྒད༌པོ༌ ཡང༌ ཁོང༌ང༌ རྒད༌པོའེ༌ ཏུས༌ལ༌ ཇོར༌ཁན༌ནི༌ བུ༌ཚ༌ཞིག༌ ཡོད༌། ཨ༌མ༌ ཅིག༌གི༌ ཕྲུ༌གུ༌ ཁོའེ༌ ཨ༌ཅོ༌ ཤི༌པ༌ ཁོ༌རང༌ ཅིག༌པོ༌ མན༌ནེ༌ མེད༌ ཡང༌ ཁོའེ༌ ཨ༌བའེ༌ ཁོའ༌ མའ༌ སྲན༌ཏྲེ༌ ཡ༌ཤ༌ ཅོའད༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“སྤོན༌བོ༌ལེ༌ ཉེ༌རང༌ངི༌ ང༌ཞའ༌ མོལ༌ལ༌རག༌, ‘ང༌ ཁོ༌ ཐོང༌ཐུབ༌ཅེས༌ལ༌ ཁྱོ༌ཞའེ༌ ཁོ༌ འི༌རུ༌ ཁྲིད༌ཏེ༌ ཁྱོང༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ཡང༌ ང༌ཞའེ༌ ཟེར༌པིན༌, ‘བེན༌ཡཱ༌མིན༌ ཨ༌བ༌ བོར༌ཏེ༌ ཡོང༌མི༌ཉན༌, ཀལ༌ཏེས༌ ཡོང༌ན༌ ཨ༌བ༌ ཀྲོངས༌ས༌ནོག༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ཨིན༌ནའང༌ ཉེ༌རང༌ངི༌ མོལས༌, ‘ཁྱོ༌རང༌གུན༌ ཉམ༌པོ༌ ནོ༌ ཆུང༌ཤོག༌པོ༌ ཡོད༌ཏེ༌ མན༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ ངའེ༌ དུན༌ལ༌ ཡོང༌ མི༌ཆོགས༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ང༌ཞ༌གུན༌ ང༌ཞའེ༌ ཨ༌བའེ༌ཀ༌ ལོགས༌ཏེ༌ སོང༌ཏེ༌ ང༌ཞའེ༌ ཉེ༌རང༌ངི༌ མོལ༌ཁན༌ ཚང༌མ༌ ཁོང༌ང༌ ཤད༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“སྟིང༌ནེ༌ ང༌ཞའེ༌ ཨ༌བའེ༌ ང༌ཞའ༌ གྲུ༌ ཉོའ༌ལ༌ ཡང༌སྐྱར༌ སོང༌ ཟེར༌ར༌རག༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ཨིན༌ནའང༌ ང༌ཞའེ༌ ཁོང༌ང༌ ཟེར༌པིན༌, ‘ནོ༌ ཆུང༌ཤོག༌པོ༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཀལ༌ན༌ ང༌ཞ༌གུན༌ ཆེན༌། ང༌ཞ༌གུན༌ནི༌ ནོ༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཡོད༌ཏེ༌ མན༌ནེ༌ ང༌ཞའ༌ ཏེ༌ མི༌བོའེ༌ དུན༌ལ༌ ཆ༌ མི༌ཉན༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“ཉེ༌རང༌ངི༌ ཡོག༌པོ༌, ང༌ཞའེ༌ ཨ༌བའེ༌ ང༌ཞའ༌ མོལས༌, ‘ཁྱོ༌རང༌གུན༌ལ༌ གྱུས༌ཨིན༌ནོག༌ ངའེ༌ ན༌མ༌ རེ༌ཅལ༌ལི༌ ངའ༌ བུ༌ཚ༌ ཉིས༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ཏེ༌ནང༌ནེ༌ ཅིག༌པོ༌ སྟོར༌, ཏན༌ཏན༌ ཁོ༌ རི༌ སེམས༌ཅན༌གུན༌ནི༌ ཟོས༌ཏེ༌ ཡོད༌གྲོ༌། ཏེ༌ ཏུས༌ནེ༌ ཕར༌ལ༌ ངའེ༌ ཁོ༌ མ༌ཐོང༌ང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁོའང༌ ངའེ༌ ཀ༌ནེ༌ ཁྱེར༌ཏེ༌ ཁོ༌ ཉམ༌པོ༌ ངན༌པ༌ ཆ༌ན༌, ཁྱོ༌ཞ༌གུན༌ནི༌ རྒད༌པོ༌ ངའ༌ རྡུག༌ངལ༌ སྟན༌ཏེ༌ ཤི༌ ཅུག༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“ཏ༌ སྤོན༌བོ༌ལེ༌ ང༌ཞའ༌ བུ༌ཚ༌བོ༌ མ༌ཁྲིད༌ད༌ ཨ༌བ༌ ཡོད༌ས༌ ཆ༌ ཉན༌ཅེས༌ མེད༌། ང༌ཞ༌གུན༌ནི༌ ཨ༌བའེ༌ སྲོག༌, འི༌ བུ༌ཚའེ༌ ནང༌ང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌, ");
INSERT INTO lbj_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","བེན༌ཡཱ༌མིན༌ ང༌ཞའ༌ ཉམ༌པོ༌ མེད༌ཁན༌བོ༌ ཐོང༌ཏེ༌ ཁོང༌ ཀྲོངས༌ཨིན༌། ང༌ཞའེ༌ ང༌ཞ༌རང༌ངི༌ ཨ༌བ༌ རྒད༌པོའ༌ རྡུག༌ངལ༌ སྟན༌ཏེ༌ ཤི༌ ཅུག༌ག༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ངའེ༌ ཁོ༌ ཁམ༌ཟང༌ ཉམ༌པོ༌ ལོགས༌ཏེ༌ ཁྱོང༌ཨིན༌ ཟེར༌ཏེ༌ ང༌རང༌ངི༌ ཨ༌བའ༌ ཁ༌ཆད༌ ཅོས༌ཏེ༌ ཟེར༌པིན༌, ‘ཀལ༌ཏེས༌ མ༌ཁྱོང༌ན༌ མི༌ཚེ༌ གང༌པོ༌ ཏེ༌བོའེ༌ སྐྱོན༌ ངའ༌ ཀལ༌ནའང༌ གྲིག༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“སྤོན༌བོ༌ལེ༌, ཏ༌ ང༌ འི༌རུ༌ ཁོའེ༌ ཚབས༌ལ༌ ཉེ༌རང༌ངི༌ ཚེ༌ཡོག༌ག༌ བོར༌ར༌ ཛད༌ ཡང༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ ཉམ༌པོ༌ ལོགས༌ཏེ༌ ཆའ༌ ཅུག༌ག༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","བུ༌ཚ༌བོ༌ མ༌ཁྲིད༌ད༌ ཀ༌ཟུག༌གི༌ ང༌ ང༌རང༌ངི༌ ཨ༌བ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ཆེན༌། ཨ༌བའ༌ རྡུག༌ངལ༌ ཐོང༌ཅེས༌པོ༌ ངའ༌ ལྟ༌ཐུབ༌ཅེས༌ མེ༌རག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ཡོ༌སེབ༌བ༌ ཁོ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌གུན༌ནི༌ དུན༌ལ༌ སེམས༌ཚེར༌ སྒགས༌ཏེ༌ བོར༌ མ༌ཉན༌པ༌ ཁོའེ༌ ཟེརས༌ “མི༌ཚང༌མ༌ ངའེ༌ དུན༌ནེ༌ སོང༌།” ཏེ༌ནེ༌ ཞན༌སུའང༌ མེད༌ས༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ལ༌ ཁོའེ༌ ཁོ༌རང༌ སྔོན༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ཁོ༌ སྲན༌ཏྲེ༌ ངུས༌པ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཚོར༌, ཡང༌ གྱལ༌པོའེ༌ ཁར༌ལ༌ ཡོད༌ཁན༌གུན༌ནིའང༌ ཏེ༌ ནས༌ཚུལ༌བོ༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ལ༌ ཟེརས༌, “ང༌ ཡོ༌སེབ༌ ཨིན༌, ངའེ༌ ཨ༌བ༌ ཏ༌རུང༌ངའང༌ སོན༌ཏེའ༌ ཡོད༌ད༌?” ཨིན༌ནའང༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌གུན༌ལ༌ ལན༌ཏང༌ མ༌ཉན༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ མ༌སྲན༌ཏྲེ༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ངའེ༌ དུན༌ལ༌ ཡོང༌།” ཁོང༌གུན༌ ཡོང༌ང༌ཅིག༌ ཁོའེ༌ ཟེརས༌, “ངའ༌ ཁྱོ༌ཞའེ༌ ཨི༌ཇིབ༌བ༌ ཆའ༌ཁན༌ནི༌ བེས༌པ༌གུན༌ལ༌ ཚེ༌ཡོག༌ག༌ ཙོང༌ཁན༌ནི༌ ཁྱོ༌ཞའེ༌ ནོ༌ ཡོ༌སེབ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ཏ༌ ཚེར༌ མ༌ཚེར༌ ཡང༌ ང༌ ཙོང༌ཅེས༌སི༌ ཕིའ༌ ཁྱོ༌ཞ༌རང༌ང༌ སྐྱོན༌ མ༌ཀལ༌། ཏེ༌བོ༌ སྲོག༌ སྐྱོབ༌ཅེས༌ལ༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སང༌ སྔུན༌ལ༌ ང༌ ལམ༌ཅུག༌ག༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","མུ༌གེ༌ ཡོངས༌ཏེ༌ ལོ༌ ཉིས༌ སོང༌ཏེ༌ ཨིན༌ནོག༌ ཏ༌རུང༌ ལོ༌ ལྔ༌ ཞིང༌ལོག༌ཅེས༌ དང༌ རྔ༌ཅེས༌ མི༌ཡོང། ");
INSERT INTO lbj_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","འི༌ ཀགས༌པོའེ༌ ཏུས༌སི༌ ནང༌ནེ༌ ང༌དང༌གུན༌ སྐྱོབ༌བ༌ ཛད༌ཏེ༌ ང༌དང༌ངི༌ པུར༌གྱུད༌པོ༌ ལུས༌ཤུགས༌ཅེས༌ལ༌ དཀོན༌མཆོག༌གི༌ ང༌ སྔུན༌ལ༌ ཀལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“ཏེ༌བོའེ༌ཕིའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ མན༌པ༌ དཀོན༌མཆོག༌གི༌ ང༌ འི༌རུ༌ ལམ༌ཅུག༌ག༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ཁོང༌ངི༌ ང༌ གྱལ༌པོའ༌ ལབ༌ཞའ༌ ཏང༌ཁན༌, གྱལ༌པོའེ༌ ཁར༌རི༌ ཁག༌ཁུར༌པ༌ དང༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ཀ༌ ཝང༌སྲུལ༌པ༌ ཅོའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ཏ༌ གྱོགས༌པ༌ ངའེ༌ ཨ༌བ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁོང༌ང༌ ཟེར༌, ‘ཉེ༌རང༌ངི༌ བུ༌ཚ༌ ཡོ༌སེབ༌བི༌ ཟེར༌ར༌རག༌, དཀོན༌མཆོག༌གི༌ ང༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ཀ༌ ཝང༌སྲུལ༌པ༌ ཅོའ༌ ཛདས༌། གོར༌ མ༌ཅུག༌ག༌ ང༌ ཡོད༌ས༌ སྐྱོད༌ད༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ཉེ༌རང༌ ངའེ༌ ཉེ༌མོའ༌ གོ༌ཤེན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ ཞུགས༌, ཉེ༌རང༌ངི༌ ཕྲུ༌གུ༌གུན༌, ཚ༌འོ༌ ཚ༌མོ༌ གུན༌, ར༌ལུག༌གི༌ ཁྱུ༌ ཡང༌ ཉེ༌རང༌ང༌ ཡོད༌ཁན༌ ཚང༌མའང༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ཏེ༌རུ༌ ངའེ༌ ཉེ༌རང༌ང༌ སྟ༌སྟོག༌ ཅོ༌ཉན༌ ཨིན༌། མུ༌གེ༌ ཏ༌རུང༌ ལོ༌ ལྔ༌ ལུས༌ཤེས༌ ཨིན༌ནོག༌། འི༌རུ༌ མ༌སྐྱོད༌ན༌ ཉེ༌རང༌ དང༌ ཉེ༌རང༌ངི༌ ནང༌ཚངས༌གུན༌ ཟ༌གྱུ༌ མེད༌པ༌ སྟོག༌རིའ༌ ཤི༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“ཏ༌ ཁྱོ༌ཞ༌གུན༌ དང༌ ངའེ༌ ནོ༌ བེན༌ཡཱ༌མིན༌ནི༌ ང༌ ཏན༌ཏན༌ ཡོ༌སེབ༌ ཨིན༌ཁན༌བོ༌ ཐོང༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","འི༌རུ༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ང༌ ཙམ༌ཤིག༌གི༌ ཀུས༌པ༌ ཡོད༌ཁན༌ དང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཐོང༌ཁན༌ ཚང༌མ༌ ངའེ༌ ཨ༌བའ༌ ཤོད༌, ཡང༌ ཁོང༌ གྱོགས༌པ༌ འི༌རུ༌ ཁྲིད༌ཏེ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ཁོ༌ ཁོ༌རང༌ངི༌ ནོ༌ བེན༌ཡཱ༌མིན༌ལ༌ ཁྲིལ༌ཏེ༌ ངུས༌ ཡང༌ བེན༌ཡཱ༌མིན༌ནའང༌ ཁོའ༌ ཁྲིལ༌ཏེ༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཚང༌མ༌ པུག༌ ཏངས༌ཏེ༌ ངུས༌། ཏེ༌ནེ༌ ཁོའེ༌ ཨ༌ཅོ༌གུན༌ནི༌ ཁོ༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ཡོ༌སེབ༌བི༌ ཨ༌ཅོ༌ནོ༌གུན༌ ཡོངས༌ཁན༌ནི༌ ནས༌ཚུལ༌ གྱལ༌པོའ༌ ཚོར༌ར༌ཅིག༌ ཁོ༌ དང༌ ཁོའེ༌ སྤོན༌བོ༌གུན༌ ཐད༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","གྱལ༌པོའེ༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ལ༌ ཟེར༌, ‘སེམས༌ཅན༌གུན༌ལ༌ སྒལ༌ཀལ༌ཏེ༌ ཀེ༌ནན༌ལ༌ ལོགས༌ཏེ༌ སོང༌, ");
INSERT INTO lbj_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ཡང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཨ༌བ༌ དང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ནང༌ཚངས༌ གུན༌ ཁྲིད༌ཏེ༌ ངའ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ཡོང༌། ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཨི༌ཇིབ༌བི༌ ཚང༌མའེ༌སང༌ ས༌ཆ༌ གྱལ༌ཤོག༌པོ༌ ཏང༌ཨིན༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ འི༌ ས༌ཆའེ༌ ཟན༌ གྱལ༌ཤོག༌པོ༌ ཟེན༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“ཁོང༌གུན༌ལ༌ འི༌བོའང༌ ཟེར༌, ‘ཁྱོ༌ཞའེ༌ ན༌མ༌, ཕྲུ༌གུ༌ གུན༌ ཞོན༌ཅེས༌ལ༌ ལང༌རེལ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཁྱེར༌ ཡང༌ ཁོང༌གུན༌ དང༌ ཨ༌བ༌ ཁྲིད༌ཏེ༌ ཁྱོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ཁྱོ༌ཞའེ༌ ནོར༌གུན༌ བོར༌ཏེ༌ ཡོང༌ཅེས༌ལ༌ ཚེར༌ཁ༌ ཅོ༌ མ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཨི༌ཇིབ༌བི༌ ཚང༌མའེ༌སང༌ གྱལ༌ཤོག༌ ས༌ཆ༌བོ༌ ཁྱོ༌ཞའེ༌ གྱུར༌ཅེས༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌ནི༌ ཏེན༌ན༌བོ༌ ཅོས༌། གྱལ༌པོའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ལ༌ ལང༌རེལ༌གུན༌ ཏངས༌ ཡང༌ བེས༌སི༌ ནང༌ང༌ ཟའ༌ཅེས༌སི༌ ཟན༌གུན༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ཁོའེ༌ ཁོང༌ རེ༌རེའ༌ ཀོས༌ལག༌ སོ༌མའེ༌ ཆའ༌ཅིག༌ ཏངས༌ ཨིན༌ནའང༌ བེན༌ཡཱ༌མིན༌ལ༌ མུལ༌ལི༌ པེ༌ནེ༌ སུམ༌གྱ༌ དང༌ ཀོས༌ལག༌ ཆའ༌ ལྔ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ཁོའེ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ ཕིའ༌ བུང༌བུ༌ རྕུའི༌ཀ༌ ཨི༌ཇིབ༌བི༌ ཅ༌ལག༌ གྱལ༌ཤོག༌གུན༌ ཀལས༌ ཡང༌ བུང༌མོ༌ རྕུའི༌ཀ༌ གྲུ༌, ཏ༌གི༌ དང༌ ཟ༌གྱུ༌ གུན༌ ཁོང༌ངི༌ བེས༌སི༌ ཕིའ༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ཏེ༌ནེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ ལམ༌ཅུགས༌ ཡང༌ ཁོང༌གུན༌ ཆ༌ ཟ༌ནེ༌ ཁོའེ༌ ལམ༌བར༌ལ༌ ཛིང༌མོ༌ མི༌ཏང༌ཅེས༌ལ༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ཁོང༌གུན༌ ཨི༌ཇིབ༌ནེ༌ བིང༌ཏེ༌ སོང༌ ཡང༌ ཁོ༌རང༌གུན༌ནི༌ ཨ༌བ༌ ཡ༌ཀོབ༌ ཡོད༌ས༌ ཀེ༌ནན༌ལ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ཁོང༌གུན༌ནི༌ ཨ༌བའ༌ ཟེརས༌, “ཡོ༌སེབ༌ སོན༌ཏེའ༌ དུག༌ མ༌ཚད༌ ཁོའེ༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ཀ༌ ཝང༌སྲུལ༌ དུག༌།” ཡ༌ཀོབ༌ ཧ༌ལས༌ ཡང༌ ཁོའ༌ ཁོང༌གུན༌ནི༌ཀ༌ ཨིད༌ མ༌ཤེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ལ༌ ཟེར༌ཁན༌ ཚང༌མ༌ ཤད༌ད༌ཅིག༌ ཡང༌ ཡོ༌སེབ༌བི༌ ཁོ༌ ཁྱོང༌ཅེས༌ལ༌ ཀལ༌ཁན༌ནི༌ ལང༌རེལ༌གུན༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཁོང༌གུན༌ནི༌ ཟེར༌ཁན༌གུན༌ དེན༌ཤེས༌ཏེ༌ ཐད༌པོ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ངའེ༌ བུ༌ཚ༌ ཡོ༌སེབ༌ སོན༌ཏེའ༌ ཡོད༌ཁན༌བོ༌ ཏ༌ ང༌ དེན༌ཤེས༌། ང༌ ཤིའི༌ སང༌ སྔུན༌ལ༌ ཁོའ༌ ཐུག༌ག༌ལ༌ ཆ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁུར༌ཏེ༌ ཨི༌ཇིབ༌བ༌ སོང༌ ཡང༌ བེར༌ཤེ༌བ༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཡབ༌ ཨི༌སཱག༌གི༌ དཀོན༌མཆོག༌ག༌ ཆོད༌པ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ཚན༌ལ༌ ཞལ༌ཟིགས༌ཤིག༌གི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ ཁོའ༌ ཞལ༌ཏ༌ སལ༌ཏེ༌ མོལས༌, “ཡ༌ཀོབ༌། ཡ༌ཀོབ༌།” ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “ང༌ འི༌ཀ༌ནེ༌ ཡོད༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ཁོང༌ངི༌ མོལས༌, “ང༌ དཀོན༌མཆོག༌ ཨིན༌, ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌། ཨི༌ཇིབ༌བ༌ ཆ༌ཅེས༌ལ༌ ཇིགས༌ མ༌ཇིགས༌, ཅིའ༌ཟེར༌ན༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ གྱལ༌ཁམས༌ ཀྲག༌པོ༌ཞིག༌ གྱུར༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཨི༌ཇིབ༌བ༌ ཆེན༌ ཡང༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ ཏེ༌ ས༌ཆའེ༌ ནང༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཨིན༌། ཤི༌ ཟ༌ནེ༌ ཁྱོ༌རང༌ངི༌ མིག༌ ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཉམ༌པོ༌ ཀབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ཏེ༌ནེ༌ ཡ༌ཀོབ༌ བེར༌ཤེ༌བ༌ནེ༌ བིངས༌། ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ཨ༌བ༌ ཡ༌ཀོབ༌, ཁོ༌རང༌གུན༌ནི༌ ན༌མ༌ དང༌ ཕྲུ༌གུ༌གུན༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ ཀལ༌ཁན༌ནི༌ ལང༌རེལ༌གུན༌ནི༌ ནང༌ང༌ སྐྱོན༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ཡ༌ཀོབ༌ དང༌ ཁོའེ༌ པུར༌གྱུད༌ ཚང༌མའེ༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ཇོར༌ཁན༌ནི༌ སེམས༌ཅན༌ དང༌ ནོར༌ གུན༌ ཁུར༌ཏེ༌ ཨི༌ཇིབ༌བ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ཡ༌ཀོབ༌བི༌ ཨི༌ཇིབ༌བ༌ ཁོ༌རང༌ ཉམ༌པོ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌, ཚ༌འོ༌ དང༌ ཚ༌མོ༌ ཡང༌ན༌ ཁོའེ༌ པུར༌གྱུད༌ ཚང༌མ༌ ཁྲིད༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","འི༌ ཚང༌མ༌ ཨི༌ཇིབ༌བ༌ ཆའ༌ཁན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མིང༌ ཨིན༌ནོག༌ ཀ༌གུན༌ ཡ༌ཀོབ༌ དང༌ ཁོའེ༌ པུར༌གྱུད༌གུན༌ ཨིན༌། རུ༌བེན༌, ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌ གོ༌སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","རུ༌བེན༌ ནི༌ བུ༌ཚ༌གུན༌ ཧ༌ནོག༌, པ༌ལུ༌, ཧེས༌རོན༌ དང༌ ཀར༌མི༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","སི༌མེ༌འོན༌ ནི༌ བུ༌ཚ༌གུན༌ ཡེ༌མའུལ༌, ཡ༌མིན༌, ཨོ༌ཧད༌, ཡ༌ཀིན༌, ཟོ༌ཧར༌ དང༌ ཤོལ༌ ༼ཤོལ༌ལི༌ ཨ༌མ༌ ཀེ༌ནན༌མ༌ ཨིན༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ལི༌ཝི༌ བུ༌ཚ༌གུན༌ གེར༌ཤོན༌, ཀོ༌ཧད༌ དང༌ མི༌ར༌རི༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ཡ༌ཧུ༌དཱའེ༌ བུ༌ཚ༌གུན༌ ཨེར༌, ཨོ༌ནན༌, ཤེ༌ལག༌, པེ༌རེཟ༌ དང༌ ཟེ༌རཧ༌ ༼ཨིན༌ནའང༌ ཨེར༌ དང༌ ཨོ༌ནན༌ གུན༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ཤི༌།༽ པེ༌རེཟ༌སི༌ བུ༌ཚ༌གུན༌ ཧེཟ༌རོན༌ དང༌ ཧ༌མུལ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ཨིས༌ས༌ཁར༌རི༌ བུ༌ཚ༌གུན༌ ཏོ༌ལ༌, པུ༌འཧ༌, ཡ༌ཤེབ༌ དང༌ ཤིམ༌རོན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ཟེ༌བུ༌ལོན༌ ནི༌ བུ༌ཚ༌གུན༌ སེ༌རེད༌, ཨི༌ལོན༌ དང༌ ཡ༌ལིལ༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ཁོང༌གུན༌ པ༌དན༌ཨ༌རམ༌མི༌ ནང༌ང༌ ཡ༌ཀོབ༌བ༌ ལི༌ཡ༌ གྱུད༌ཏེ༌ ཇོར༌ཁན༌ནི༌ བུ༌ཚ༌གུན༌, དང༌ དི༌ནཱ༌ ཁོའེ༌ བུ༌མོ༌ ཨིན༌ནོག༌། ལི༌ཡ༌ གྱུད༌ཏེ༌ ཡ༌ཀོབ༌བ༌ ཕྲུ༌གུ༌ དང༌ ཚ༌འོ༌ ཚ༌མོ༌ ཚང༌མ༌ སུམ༌ཅུ༌སོག༌སུམ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","གཱད༌དི༌ བུ༌ཚ༌གུན༌ ནི༌ ཛེ༌ཕོན༌, ཧ༌གི༌, ཤུ༌ནི༌, ཨེཟ༌བོན༌, ཨེ༌རི༌, ཨ༌རོད༌དི༌ དང༌ ཨ༌རེ༌ལི༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ཨ༌ཤེར༌རི༌ བུ༌ཚ༌གུན༌ ནི༌ འིམ༌ནཧ༌, ཨིཤ༌ཝ༌, ཨིཤ༌ཝི༌ དང༌ བེ༌རིའ༌ ཡང༌ ཁོང༌གུན༌ནི༌ སྲིང༌མོ༌ སཱ༌ར༌ ཨིན༌པིན༌། བེ༌རིའ༌འི༌ བུ༌ཚ༌གུན༌ ནི༌ ཧེ༌བེར༌ དང༌ མལ༌ཀེལ༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ཁོང༌གུན༌ ཟིལ༌པཧ༌ གྱུད༌ཏེ༌ སྐྱེ༌ཁན༌ ཡ༌ཀོབ༌བི༌ ཕྲུ༌གུ༌ ཅུ༌རུག༌བོ༌ ཨིན༌ནོག༌, ལ༌བན༌ནི༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌ ལི༌ཡའ༌ ཁོ༌ ཡོག༌མོའ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ཡ༌ཀོབ༌བི༌ ན༌མ༌ རེ༌ཅལ༌ལ༌ བུ༌ཚ༌ ཡོ༌སེབ༌ དང༌ བེན༌ཡཱ༌མིན༌ སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཡོ༌སེབ༌བ༌ མ༌ནས༌ས༌ དང༌ ཨེཕ༌ར༌ཡིམ༌ བུ༌ཚ༌ ཉིས༌ ཡོད༌པིན༌, ཁོང༌གུན༌ འོན༌ནེ༌ ཨིན༌ཁན༌ བླ༌མ༌ པོ༌ཏི༌ཕར༌རི༌ བུ༌མོ༌ ཨ༌སི༌ནད༌ལ༌ སྐྱེས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","བེན༌ཡཱ༌མིན༌ནི༌ བུ༌ཚ༌གུན༌ ནི༌ བི༌ལ༌, བེ༌ཀར༌, ཨཤ༌བེལ༌, གི༌ར༌, ནཱའ༌མན༌, ཨེ༌ཧི༌, རོཤ༌, མུ༌པིམ༌, ཧུ༌པིམ༌ དང༌ ཨ༌རད༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","འི༌ ཅུབ༌ཞི༌བོ༌ རེ༌ཅལ༌ གྱུད༌ཏེ༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌ དང༌ ཚ༌འོ༌ གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","དཱན༌ནི༌ བུ༌ཚ༌ ཧུ༌ཤིམ༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ཡང༌ ནབ༌ཐལ༌ལིའི༌ བུ༌ཚ༌གུན༌ ནི༌ ཡཧ༌ཟིལ༌, གུ༌ནི༌, ཡ༌ཟེར༌ དང༌ ཤི༌ལེམ༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ཏེ༌ བུ༌ཚ༌ རྡུན༌ཀོ༌ བིལ༌ལཧ༌ གྱུད༌ཏེ༌ སྐྱེ༌ཁན༌ ཡ༌ཀོབ༌བི༌ ཕྲུ༌གུ༌གུན༌ ཨིན༌ནོག༌, ལ༌བན༌ནི༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌ རེ༌ཅལ༌ལ༌ ཁོ༌ ཡོག༌མོའ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ཡ༌ཀོབ༌ ཉམ༌པོ༌ ཨི༌ཇིབ༌བ༌ ཆའ༌ཁན༌ ཁོའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ཀྲངས༌ཀ༌ དྲུག༌ཅུ༌ ར༌རུག༌ ཡོད༌པིན༌ ཀ༌བོའེ༌ ནང༌ང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ན༌མ༌ མ༌ཐེའ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཡོ༌སེབ༌བ༌ སྐྱེས༌ཁན༌ནི༌ བུ༌ཚ༌ ཉིས༌ཀོ༌ ཐེས༌ཏེ༌ ཡ༌ཀོབ༌བི༌ ནང༌ཚངས༌ ཨི༌ཇིབ༌བ༌ ཆའ༌ཁན༌གུན༌ནི༌ ཀྲངས༌ཀ༌ རྡུན༌ཅུ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ཡ༌ཀོབ༌བི༌ གོ༌ཤེན༌ལ༌ ཆ༌སའེ༌ ལམ༌ གྱུས༌ཅོ༌ཅེས༌ལ༌ ཡ༌ཧུ༌དཱ༌ སྔུན༌ལ༌ ཡོ༌སེབ༌བི༌ཀ༌ ལམ༌ཅུགས༌། ཁོང༌གུན༌ གོ༌ཤེན༌ནི༌ ས༌ཆའེ༌ཀ༌ ལེབ༌བ༌ཅིག༌ ");
INSERT INTO lbj_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ རྟ༌རེལ༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ གོ༌ཤེན༌ལ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཐུག༌ག༌ སོང༌། ཨ༌བའ༌ ཐུག༌ག༌ཅིག༌ ཡོ༌སེབ༌བི༌ ཨ༌བའ༌ ཁྲིལ༌ཏེ༌ ཏུས༌བན༌ཤིག༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ཡ༌ཀོབ༌བི༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ངའེ༌ ཁྱོ༌རང༌ སོན༌ཏེའ༌ ཐོང༌པ༌ ཏ༌ ང༌ ཤི༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌ དང༌ ཞན༌ ནང༌མི༌གུན༌ལ༌ ཟེརས༌, “ཏ༌ ང༌ གྱལ༌པོའེ༌ཀ༌ སོང༌ཏེ༌ ཟེར༌ཨིན༌ ‘ཀེ༌ནན༌ནི༌ ནང༌ང༌ དུག༌ཁན༌ ངའེ༌ ཨ༌ཅོ༌ནོ༌ དང༌ ངའེ༌ ཨ༌བའེ༌ ནང༌མི༌ ཚང༌མ༌ ཡོང༌ཏེ༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ཁོང༌གུན༌ ལུག༌རྫི༌ ཡང༌ སེམས༌ཅན༌ གུན༌ལ༌ སྟ༌སྟོག༌ ཅོ༌ཁན༌ ཨིན༌ནོག༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌ནི༌ ཁྱུ༌གུན༌ དང༌ ཁོང༌གུན༌ལ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁྱོངས༌ཏེ༌ དུག༌།’ ");
INSERT INTO lbj_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","གྱལ༌པོའེ༌ ཁྱོ༌ཞ༌གུན༌ བོད༌ཏེ༌ ‘ཁྱོ༌རང༌གུན༌ནི༌ ལས༌ ཅི༌ ཅོའད༌?’ ཟེར༌ཏེ༌ ཏྲིའ༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ཁྱོ༌ཞ༌གུན༌ནི༌ ཟེར༌གོས༌, ‘ང༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཙོགས༌ལ༌ ང༌ཞའ༌ ཕྲུ༌གུ༌ནེ༌ པར༌ལ༌ སེམས༌ཅན༌ སྲལ༌ཏེ༌ ཚོ༌ཁན༌གུན༌ ཨིན༌།’ ཏེ༌ནེ༌ ཁོའེ༌ ཁྱོ༌ཞ༌གུན༌ གོ༌ཤེན༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ དུག༌ཅུག༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ སེམས༌ཅན༌ སྲལ༌ཁན༌ནི༌ མི༌གུན༌ རྩང༌མ༌ ཐེའ༌ མེད༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ཏེ༌ནེ༌ ཡོ༌སེབ༌ སོང༌ཏེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཕེ༌རོའ༌ ཟེརས༌, “ངའེ༌ ཨ༌བ༌ དང༌ ཨ༌ཅོ༌ནོ༌གུན༌ ཀེ༌ནན༌ནེ༌ སེམས༌ཅན༌ནི༌ ཁྱུ༌ དང༌ ཁོ༌རང༌གུན༌ལ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཉམ༌པོ༌ ཡོངས༌ཏེ༌ དག༌ས༌ གོ༌ཤེན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ཁོའེ༌ ཁོ༌རང༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ ཨ༌ཅོ༌ རྔ༌བོ༌ གྱལ༌པོའེ༌ དུན༌ལ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","གྱལ༌པོའེ༌ ཁོང༌གུན༌ལ༌ ཏྲིས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ ལས༌སྣ༌ ཅི༌ ཨིན༌?” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “སྤོན༌བོ༌ལེ༌, ང༌ཞ༌གུན༌ ང༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཙོགས༌ལ༌ ལུག༌རྫི༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ཀེ༌ནན༌ནི༌ ནང༌ང༌ མུ༌གེ༌ ཀྲག༌པོ༌ ལངས༌ཏེ༌ སེམས༌ཅན༌གུན༌ལ༌ ཟ༌གྱུ༌ མེད༌ པ༌སང༌ ང༌ཞའ༌ ཏུས༌བན༌ཤིག༌ འི༌ ཡུལ༌ལ༌ དུག༌ག༌ ཡོངས༌པིན༌། ཇུ༌ཇུ༌ ང༌ཞ༌གུན༌ གོ༌ཤེན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ དུག༌ཅེས༌ལ༌ གོངས༌པ༌ སལ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","གྱལ༌པོའེ༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཨ༌བ༌ དང༌ ཨ༌ཅོ༌ནོ༌གུན༌ ཁྱོ༌རང༌ ཡོད༌ས༌ ཡོངས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོ༌ ཁྱོ༌རང༌ངི༌ དུན༌ལ༌ དུག༌, ཏ༌ ཁོང༌གུན༌ ས༌ཆ༌ ཚང༌མའེ༌སང༌ གྱལ༌ཤོག༌ གོ༌ཤེན༌ནི༌ ནང༌ང༌ ནས༌ཏེ༌ དུག༌ཅུག༌། ཡང༌ ཁོང༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཁས༌པ༌གུན༌ལ༌ ངའེ༌ སེམས༌ཅན༌ནི༌ ཁྱུ༌གུན༌ནི༌ སྟ༌སྟོག༌ ཅོ༌ཅེས༌སི༌ ཁག༌ ཀོལ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཡ༌ཀོབ༌ གྱལ༌པོའེ༌ དུན༌ལ༌ ཁྱོངས༌ ཡང༌ ཡ༌ཀོབ༌བི༌ གྱལ༌པོའ༌ ཅིན༌ལབས༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","གྱལ༌པོའེ༌ ཁོའ༌ ཏྲིས༌, “ཉེ༌རང༌ང༌ ལོ༌ ཙམ༌ ཆ༌ཅེན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ཡ༌ཀོབ༌བི༌ ལན༌ཏངས༌, “ཇིག༌རྟེན༌ནི༌ ནང༌ང༌ ཁོར༌ཨིན༌ དུགས༌ཏེ༌ ངའ༌ ལོ༌ གྱ༌ དང༌ སུམ༌ཅུ༌ སོང༌། ངའེ༌ མི༌ཚེའེ༌ རྡུག༌ངལ༌ཅན༌ ཡང༌ ངའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཙོགས༌ལ༌ རིང༌མོ༌ཞིག༌ མེད༌པ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ གྱལ༌པོའ༌ ཅིན༌ལབས༌ ཏངས༌ཏེ༌ ཁོའེ༌ དུན༌ནེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ཕེ༌རོའེ༌ བཀའ༌ ནང༌ཞིན༌ ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ དང༌ ཨ༌ཅོ༌ནོ༌གུན༌ ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ ཚང༌མའེ༌སང༌ གྱལ༌ཤོག༌ རམ༌སིས༌སི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཚུགས༌ཏེ༌ དུག༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ཡང༌ ནང༌ཚངས༌སི༌ ནང༌མི༌ སྤེས༌ཏེ༌ ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ དང༌ ཨ༌ཅོ༌ནོ༌གུན༌ ཡང༌ ཁོང༌གུན༌ནི༌ ནང༌ཚངས༌གུན༌ལ༌ ཟ༌གྱུ༌གུན༌ནའང༌ རིགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","མུ༌གེ༌ མ༌སྲན༌ཏྲེ༌ ཡོང༌ཅེས༌པོའེ༌ ཨི༌ཇིབ༌ དང༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ཟ༌གྱུ༌ མེད༌པིན༌། ནས༌ས༌ གང༌པོའེ༌ ནང༌ང༌ མི༌གུན༌ལ༌ སྟོག༌རི༌ སྲན༌ཏྲེ༌ ཐོང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ཨི༌ཇིབ༌པ༌ དང༌ ཀེ༌ནན༌པ༌ གུན༌ལ༌ གྲུ༌ ཙོང༌ཁན༌ནི༌ པེ༌ནེ༌ ཚང༌མ༌ ཡོ༌སེབ༌བི༌ སགས༌ཏེ༌ ཕེ༌རོའེ༌ ཁར༌ལ༌ ཁྱེར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ཨི༌ཇིབ༌པ༌ དང༌ ཀེ༌ནན༌པ༌ གུན༌ལ༌ པེ༌ནེ༌ ཚང༌མ༌ ཚར༌ར༌ཅིག༌, ཨི༌ཇིབ༌པ༌གུན༌ ཡོ༌སེབ༌ ཡོད༌ས༌ ཡོངས༌ཏེ༌ ཟེརས༌, “ང༌ཞ༌གུན༌ལ༌ ཟ༌གྱུ༌ སལ༌། ཉེ༌རང༌ངི༌ མིག༌གི༌ དུན༌ལ༌ ང༌ཞ༌གུན༌ ཤི༌ ཅུག༌ག༌ མ༌ཛད༌། ང༌ཞའེ༌ པེ༌ནེ༌གུན༌ ཚར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ཡོ༌སེབ༌བི༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌གུན༌ནི༌ པེ༌ནེ༌ ཚང༌མ༌ ཚར༌ཏེ༌ མེད༌ན༌ ཁྱོ༌ཞའེ༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌གུན༌ ཁྱོང༌ ངའེ༌ ཏེ༌གུན༌ནི༌ ཚབས༌ལ༌ ཟ༌གྱུ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ནི༌ སེམས༌ཅན༌ སྲལ༌ཁན༌གུན༌ ཁྱོངས༌ ཡང༌ ཁོའེ༌ ཁོང༌གུན༌ནི༌ ཁྱོང༌ཁན༌ རྟ༌, ལུག༌ དང༌ ར༌མ༌, བ༌ལང༌ དང༌ བུང༌བུ༌ གུན༌ནི༌ ཚབས༌ལ༌ ཟ༌གྱུ༌ ཏངས༌། ཏེ༌ ལོ༌བོ༌ ཁོའེ༌ ཁོང༌ ཚང༌མ༌ལ༌ སེམས༌ཅན༌ སྲལ༌ཁན༌གུན༌ནི༌ ཚབས༌ལ༌ ཟ༌གྱུ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ཏེ༌ ལོ༌ ཚར༌ཏེ༌ སྟིང༌མ༌ ལོ༌ ཁོང༌གུན༌ ཡོ༌སེབ༌ ཡོད༌ས༌ ཡོངས༌ཏེ༌ ཟེརས༌, “སྤོན༌བོ༌ལེ༌, ང༌ཞའེ༌ པེ༌ནེ༌ ཚར༌ ཡང༌ ང༌ཞའེ༌ སེམས༌ཅན༌ ཚང༌མ༌ ཉེ༌རང༌ངི༌ གྱུར༌ཁན༌བོ༌ ང༌ཞའ༌ སྦས༌ཏེ༌ བོར༌ མི༌ཉན༌། ཏ༌ ང༌ཞ༌རང༌ངི༌ ཟུགས༌པོ༌ དང༌ ས༌ཀྱད༌པོ༌ མ༌ནེ༌ ཅའང༌ ལུས༌ཏེ༌ མེད༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ཉེ༌རང༌ངི༌ མིག༌གི༌ དུན༌ལ༌ ང༌ཞའ༌ དང༌ ང༌ཞའེ༌ ཞིང༌གུན༌ ཤི༌ ཅུག༌ག༌ མ༌ཛད༌། ང༌ཞའ༌ དང༌ ང༌ཞའེ༌ ས༌ཀྱད༌གུན༌ནི༌ ཚབས༌ལ༌ ང༌ཞའ༌ ཟ༌གྱུ༌ སལ༌ལ༌ ཛད༌དའང༌, ང༌ཞའེ༌ ས༌ཀྱད༌ དང༌ ང༌ཞ༌གུན༌ གྱལ༌པོའེ༌ ཚེ༌ཡོག༌ གྱུར༌ཨིན༌། ང༌ཞ༌གུན༌ སོན༌ཏེའ༌ ལུས༌ཤེས༌ ཡང༌ ཞིང༌གུན༌ རི༌སྟོང༌ མི༌གྱུར༌ཅེས༌སི༌ ཕིའ༌ ང༌ཞ༌གུན༌ལ༌ གྲུ༌ སལ༌ལ༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ ཚང༌མ༌ གྱལ༌པོའེ༌ ཕིའ༌ ཉོས༌། མུ༌གེ༌ མ༌སྲན༌ཏྲེ༌ གྱས༌པ༌ ཨི༌ཇིབ༌པ༌ ཚང༌མའེ༌ ཁོ༌རང༌གུན༌ནི༌ ས༌ཀྱད༌ ཙོངས༌ ཡང༌ ས༌ཀྱད༌ ཚང༌མ༌ ཕེ༌རོའེ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ཡོ༌སེབ༌བི༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ མི༌གུན༌ གྱལ༌པོའེ༌ ཚེ༌ཡོག༌ གྱུར༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ཨིན༌ནའང༌ ཁོའེ༌ བླ༌མ༌གུན༌ནི༌ ས༌ཀྱད༌ མ༌ཉོས༌ ཅིའ༌ཟེར༌ན༌ གྱལ༌པོའེ༌ ཁོང༌གུན༌ལ༌ ཐག༌ཅད༌ཁན༌ནི༌ ལ༌ཆ༌ ཏང༌ངད༌པིན༌ ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ལ༌ ཟ༌གྱུ༌ ཉོ༌ཅེས༌ལ༌ ཁོ༌རང༌གུན༌ནི༌ ས༌ཀྱད༌ ཙོང༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ཡོ༌སེབ༌བི༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཏ༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ དང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ས༌ཀྱད༌ གྱལ༌པོའེ༌ ཕིའ༌ ཉོས༌ཏེ༌ ཨིན༌, འི༌ཀ༌ནེ༌ ས༌འོན༌, ཁྱེར༌ཏེ༌ ཞིང༌ ཏོབ༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","སྟོན༌ཐོག༌ སྨིན༌ན༌ཅིག༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁག༌ ལྔའེ༌ ནང༌ནེ༌ ཅིག༌ གྱལ༌པོའ༌ ཏང༌གོས༌། ལུས༌ཁན༌ནི༌ ཁག༌ ཞི༌ ཁྱོ༌ཞའེ༌ ནང༌ཚངས༌གུན༌ནི༌ ཁར༌ཇི༌ དང༌ ཞིང༌ངི༌ ས༌འོན༌ནི༌ ཕིའ༌ ཀོལ༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ ང༌ཞ༌གུན༌ནི༌ སྲོག༌ སྐྱོབས༌ཏེ༌ ཨིན༌ནོག༌། སྤོན༌བོ༌ལེ༌, ཉེ༌རང༌ངི༌ ང༌ཞའེ༌ཀ༌ ཐུག༌རྗེ༌ སྟན༌ཅེས༌པོའེ༌ ང༌ཞ༌གུན༌ གྱལ༌པོའེ༌ ཚེ༌ཡོག༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཡོ༌སེབ༌བི༌ ཨི༌ཇིབ༌བི༌ ས༌ཀྱད༌ ནང༌ བྲེལ༌ཏེ༌ བཀའ༌ཁྲིམས༌ཤིག༌ ཅོས༌ ཀ༌བོ༌ སྟོན༌ཐོག༌གི༌ ཁག༌ ལྔའེ༌ ནང༌ནེ༌ ཅིག༌ གྱལ༌པོའ༌ ཏང༌གོ༌ཤེས༌། ཏེ༌ ཁྲིམས༌པོ༌ དག༌སའང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། བླ༌མ༌གུན༌ནི༌ ས༌ཀྱད༌ ཅིག༌པོ༌ གྱལ༌པོའེ༌ མ༌གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ གོ༌ཤེན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཚུགས༌ཏེ༌ དུགས༌། ཏེ༌རུ༌ ཁོང༌གུན༌ལ༌ གྱུ༌ནོར༌ ཇོར༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཀྲངས༌ཀ༌ ཕེལ༌ཨིན༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ཡ༌ཀོབ༌ ཨི༌ཇིབ༌བི༌ གོ༌ཤེན༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ལོ༌ ཅུབ༌དུན༌ སོན༌ཏེའ༌ ལུས༌ ཡང༌ ཁོའ༌ ལོ༌ གྱ༌ དང༌ ཞིབ༌ཅུ༌ཞབ༌དུན༌ ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ཤི༌ཅེས༌སི༌ ཏུས༌པོ༌ ཉེ༌མོའ༌ ལེབ༌བ༌ཅིག༌ ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཡོ༌སེབ༌ བོད༌ཏེ༌ ཁོའ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ངའ༌ ཅམས༌པ༌ ཅོའད༌ན༌ ཁྱོ༌རང༌ངི༌ ལག༌པ༌ ངའེ༌ ཇང༌བར༌ལ༌ བོར༌ཏེ༌ ངའ༌ ཐུག༌རྗེ༌ དང༌ ལོ༌ཁྱེལ༌ སྟན༌ཏེ༌ ངའེ༌ ཟེར༌ཁན༌བོ༌ ཅོ༌ཅེས༌ལ༌ ཁ༌ཆད༌ ཅོས༌། ངའ༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ མ༌སུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ང༌ ཤིའ༌ཅིག༌ ངའེ༌ ཟུགས༌པོ༌ ཨི༌ཇིབ༌ནེ༌ ཕི༌ལོག༌ག༌ ཁྱེར༌ཏེ༌ ངའེ༌ ཕ༌མེས༌པོ༌གུན༌ སུབ༌སའེ༌ ནས༌སའེ༌ཀ༌ སུབ༌ཅུག༌།” ཡོ༌སེབ༌བི༌ ཟེརས༌, “ངའེ༌ ཉེ༌རང༌ངི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ཏེ༌བོ༌ ཅོ༌ཅེས༌ལ༌ ཁྱོ༌རང༌ངི༌ ནའ༌ ཁུར༌།” ཡོ༌སེབ༌བི༌ ནའ༌ ཁུརས༌ ཡང༌ ཡ༌ཀོབ༌བི༌ མལ༌ཙེ༌ཀ༌ གོ༌ སྒུས༌ཏེ༌ དཀོན༌མཆོག༌ག༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ཏུས༌བན༌ཤིག༌གི༌ སྟིང༌ནེ༌ ཡོ༌སེབ༌བ༌, “ཁྱོ༌རང༌ངི༌ ཨ༌བ༌ ཟུ༌མོ༌ དུག༌” ཟེར༌ཏེ༌ ཤདས༌པ༌ ཁོ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ མ༌ནས༌ས༌ དང༌ ཨེཕ༌ར༌ཡིམ༌ ཁྲིད༌ཏེ༌ ཨ༌བ༌ ཐུག༌ག༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ཡ༌ཀོབ༌བ༌, “ཁྱོ༌རང༌ངི༌ བུ༌ཚ༌ ཡོ༌སེབ༌, ཁྱོ༌རང༌ང༌ ཐུག༌ག༌ལ༌ ཡོངས༌ཏེ༌ དུག༌” ཟེར༌ཏེ༌ ཤད༌ད༌ཅིག༌ ཁོའེ༌ ཟུགས༌པོའེ༌ ནང༌ང༌ ཤེད༌ ཡོངས༌ཏེ༌ ཁོ༌ མལ༌ཙེ༌ཀ༌ ལངས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ཡ༌ཀོབ༌བི༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ངའ༌ ཀེ༌ནན༌ནི༌ ས༌ཆ༌ ལུཟ༌སི༌ ནང༌ང༌ དཀོན༌མཆོག༌ ཀུན༌ཝང༌ ཇལས༌ ཡང༌ ཁོང༌ངི༌ ངའ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","མོལས༌, ‘ངའེ༌ ཁྱོ༌རང༌ང༌ ཕྲུ༌གུ༌ མང༌པོ༌ ཇོར༌ ཅུགས༌ཏེ༌ གྱས༌ཅུག༌ ཨིན༌། ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ གྱལ༌ཁམས༌ མང༌པོ༌ གྱུར༌ཏེ༌ ངའེ༌ འི༌ ས༌ཀྱད༌ ཏུས༌གྱུན༌ ལུས༌ཤེས༌སི༌ གྱུ༌ནོར༌རི༌ ཚུལ༌ལ༌ ཁོང༌གུན༌ལ༌ ཏང༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“ང༌ འི༌རུ༌ ཡོང༌ངི༌ སང༌ སྔུན༌ལ༌ ཁྱོ༌རང༌ང༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ སྐྱེས༌ཁན༌ནི༌ བུ༌ཚ༌ ཨེཕ༌ར༌ཡིམ༌ དང༌ མ༌ནས༌ས༌ ཉིས༌ཀོ༌ ངའེ༌ བུ༌ཚ༌ རུ༌བེན༌ དང༌ སི༌མེ༌འོན༌ ཙོགས༌ལ༌ ང༌རང༌ངི༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ཁོང༌གུན༌ནི༌ སྟིང༌ནེ༌ ཁྱོ༌རང༌ང༌ སྐྱེས༌ཁན༌ནི༌ ཞན༌ བུ༌ཚ༌གུན༌ ཁྱོ༌རང༌ངི༌ ཨིན༌ནོག༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཨེཕ༌ར༌ཡིམ༌ དང༌ མ༌ནས༌ས༌ ཡོད༌ཁན༌ནི༌ ས༌ཆ༌གུན༌ནེ༌ ནོར༌སྐལ༌ ཐོབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ཏུས༌མང༌པོའེ༌ སྔུན༌ལ༌ ང༌ པ༌དན༌ཨ༌རམ༌ནེ༌ ལོགས༌ཏེ༌ ཡོང༌ ཟ༌ནེ༌ ཁྱོ༌རང༌ངི༌ ཨ༌མ༌ རེ༌ཅལ༌, ལ༌མ༌ ཀེ༌ནན༌ནི༌ ཡུལ༌ལི༌ ནང༌ང༌ ཤི༌ ཀ༌བོ༌ ཨེ༌ཕ༌རེད༌ནེ༌ ཐག༌རིང༌ ཡོད༌པིན༌། ངའེ༌ ཁོ༌ ཏེ༌རུ༌ ཨེ༌ཕ༌རེད༌ལ༌ ཡོང༌སའེ༌ ལམ༌མི༌ཀ༌ སུབས༌པིན༌” ༼ཏེ༌བོ༌ དག༌ས༌ བེད༌ལེ༌ཧེམ༌ ཨིན༌ནོག༌།༽ ");
INSERT INTO lbj_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ཡ༌ཀོབ༌བི༌ ཡོ༌སེབ༌བི༌ བུ༌ཚ༌གུན༌ ཐོང༌ང༌ཅིག༌ ཁོའ༌ ཏྲིས༌, “ཁོང༌གུན༌ སུ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ཡོ༌སེབ༌བི༌ ལན༌ཏངས༌, “ཁོང༌གུན༌, དཀོན༌མཆོག༌གི༌ ངའ༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ སལ༌ཁན༌ནི༌ ངའེ༌ བུ༌ཚ༌གུན༌ ཨིན༌།” ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཟེརས༌, “ཅིན༌ལབས༌ ཏང༌ཉན༌ཅེས༌ལ༌ ཁོང༌གུན༌ ངའེ༌ དུན༌ལ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","རྒད༌པོ༌ ཡོད༌ཅེས༌པའེ༌ ཡ༌ཀོབ༌བ༌ མིག༌ནེ༌ ལག༌མོ༌ ཐོང༌ང༌ མེད༌པིན༌། ཏེ༌བོའེ༌ཕིའ༌ ཡོ༌སེབ༌བི༌ བུ༌ཚ༌གུན༌ ཨ༌བའེ༌ དུན༌ལ༌ ཁྱོངས༌ ཡང༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཁྲིལ༌ཏེ༌ པུག༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ཡ༌ཀོབ༌བི༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ང༌ ཁྱོ༌རང༌ ཡང༌སྐྱར༌ ཐོང༌ཅེས༌སི༌ རེ༌ཝ༌ མེད༌པིན༌། ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ངའ༌ ཁྱོ༌རང༌ངི༌ ཕྲུ༌གུ༌གུན༌ནའང༌ ཐོང༌ ཅུག༌ག༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ བུ༌ཚ༌གུན༌ ཨ༌བའེ༌ པིག༌མོའེ༌ དུན༌ནེ༌ ཐེན༌ཏེ༌ ཨ༌བའེ༌ དུན༌ལ༌ ཁོ༌རང༌ངི༌ གོ༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ སྒུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ཡོ༌སེབ༌བི༌ ཨེཕ༌ར༌ཡིམ༌ ཁོ༌རང༌ངི༌ ཡས༌པ༌ ཡ༌ཀོབ༌བི༌ ཡོ༌མ༌ ཆོགས༌ལ༌ ཡང༌ མ༌ནས༌ས༌ ཁོ༌རང༌ངི༌ ཡོ༌མ༌ ཡ༌ཀོབ༌བི༌ ཡས༌པ༌ ཆོགས༌ལ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ཡོ༌མ༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ ཨེཕ༌ར༌ཡིམ༌ བུ༌ཚ༌ ཆུ༌ངུན༌བོའེ༌ གོའེ༌ཀ༌ ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཡས༌པ༌བོ༌ བོརས༌, ཡང༌ ཡས༌པ༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ མ༌ནས༌ས༌ བུ༌ཚ༌ ཆེན༌མོའེ༌ གོའེ༌ཀ༌ ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཡོ༌མ༌བོ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ཏེ༌ནེ༌ ཡོ༌སེབ༌བ༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌ ཟེརས༌, “ངའེ༌ མེ༌མེ༌ ཨབ༌ར༌ཧམ༌ དང༌ ཨ༌བ༌ ཨི༌སཱག༌གི༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ནི༌ དཀོན༌མཆོག༌, ངའེ༌ མི༌ཚེ༌ གང༌པོའ༌ སྲུང༌སྐྱོབ༌ ཛད༌ཁན༌ནི༌ ངའེ༌ ལུག༌རྫི༌, ");
INSERT INTO lbj_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ང༌ ནོད༌པ༌ ཚང༌མ༌ནེ༌ སྐྱོབ༌བ༌ ཛད༌ཁན༌ནི༌ ཕོ༌ཉ༌, ཁོང༌ངི༌ འི༌ བུ༌ཚ༌གུན༌ལ༌ ཅིན༌ལབས༌ སལ༌ལ༌ ཛད༌ཤིག༌། འི༌ བུ༌ཚ༌གུན༌ གྱུད༌ཏེ༌ ཨབ༌ར༌ཧམ༌ དང༌ ཨི༌སཱག༌གི༌ ཚན༌ ཡང༌ ངའེ༌ མིང༌ ལུས༌ཤིག༌། ཁོང༌གུན༌ལ༌ ཕྲུ༌གུ༌ མང༌པོ༌ ཇོར༌ཏེ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཁོང༌གུན༌ནི༌ མིར༌གྱུད༌ མང༌པོ༌ ཕེལ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ཡོ༌སེབ༌བ༌ ཨ༌བའེ༌ ལག༌པ༌ ཡས༌པ༌བོ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ གོའེ༌ཀ༌ བོར༌ཁན༌བོ༌ ཐོང༌ང༌ཅིག༌ ཁོ༌ མ༌ཐད༌ ཡང༌ ཁོའེ༌ ཨ༌བའེ༌ ལག༌པ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ གོའེ༌ ཀ༌ནེ༌ ཐེན༌ཏེ༌ མ༌ནས༌སའེ༌ གོའེ༌ཀ༌ བོར༌ཅེས༌ ཅོས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ཟེརས༌, “ཨ༌བ༌ལེ༌, བུ༌ཚ༌ ཆེན༌མོ༌ འི༌བོ༌ ཨིན༌ ཁོའེ༌ གོའེ༌ཀ༌ ཉེ༌རང༌ངི༌ ལག༌པ༌ ཡས༌པ༌བོ༌ བོར༌ར༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ཨིན༌ནའང༌ ཨ༌བའེ༌ མ༌བོརས༌ ཡང༌ ཟེརས༌, “ང༌ གྱུས༌ཡོད༌ བུ༌ཚ༌, ང༌ གྱུས༌ཡོད༌། མ༌ནས༌ས༌ མིར༌གྱུད༌གུན༌ནའང༌ ཀྲག༌པོ༌ གྱུར༌ཨིན༌། ཨིན༌ནའང༌ ཁོའེ༌ ནོ༌ ཁོའེ༌ སང༌ མང༌ང༌ ཀྲག༌ག༌ གྱུར༌ཏེ༌ ཁོའེ༌ མིར༌གྱུད༌གུན༌ གྱལ༌ཁམས༌ མང༌པོ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཏེ༌ ཞག༌ག༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཅིན༌ལབས༌ ཏང༌ ཟ༌ནེ༌ ཁྱོ༌ཞའེ༌ མིང༌ ཀོལ༌ཏེ༌ ཟེར༌ཨིན༌, ‘དཀོན༌མཆོག༌གི༌ ཁྱོ༌རང༌གུན༌ ཨེཕ༌ར༌ཡིམ༌ དང༌ མ༌ནས༌ས༌ ཙོགས༌ གྱུར༌ཅུག༌ག༌ ཛད༌ཤིག༌།’” ཏེན༌ན༌ཟུག༌གི༌ ཡ༌ཀོབ༌བི༌ ཨེཕ༌ར༌ཡིམ༌མི༌ སང༌ མ༌ནས༌ས༌ ཁག༌ཅན༌ ཐེས༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཡོ༌སེབ༌བ༌ ཟེརས༌, “ང༌ ཤི༌ཀྱིས༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ དཀོན༌མཆོག༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཁྱོ༌རང༌ ཁྱོ༌རང༌ངི༌ ཕ༌མེས༌པོའི༌ ས༌ཆ༌ ཀེ༌ནན༌ལ༌ ལོགས༌ཏེ༌ ཁྱེར༌ར༌ ཛད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ནི༌ སང༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ས༌ཆ༌ ཉི༌ལྡབ༌ ཏང༌ཨིན༌ ཀ༌བོ༌ ངའེ༌ ར༌འི༌ དང༌ ཞུ༌ ཉམ༌པོ༌ ཨ༌མོར༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ལེན༌ཏེ༌ ཨིན༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ བོད༌ཏེ༌ ཟེརས༌, “ངའ༌ ཁོར༌ཏེ༌ དུགས༌ཤིག༌, ངའེ༌ ཁྱོ༌རང༌གུན༌ ཉམ༌པོ༌ སྟིང༌ཞིན༌ ཇུང༌ཅེས༌ཅན༌གུན༌ ཤད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌, ཛོམས༌ཏེ༌ ཉོན༌, ཁྱོ༌ཞ༌གུན༌ནི༌ ཨ༌བ༌ ཨིས༌ར༌ཨེལ༌ལ༌ ཉོན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“རུ༌བེན༌ ཁྱོ༌རང༌ ངའེ༌ བུ༌ཚ༌ ཏང༌པོ༌, ངའེ༌ ཤུགས༌, ངའེ༌ ཁྱོག༌ཏོང༌ངི༌ ཤུགས༌སི༌ སྟགས༌ ཏང༌པོ༌, ཚང༌མའེ༌སང༌ སྤལ༌ཅན༌ དང༌ སྟོབས༌ཅན༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ཨིན༌ནའང༌ ཁྱོ༌རང༌ ཆུ༌ལོག༌ ཙོགས༌ལ༌ རང༌སེམས༌ཅུན༌ མ༌ཉན༌ཁན༌, ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌རང༌ ཚང༌མའེ༌སང༌ ཁག༌ཅན༌ མི༌ལུས༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ ངའེ༌ ན༌མ༌ ཉམ༌པོ༌ བྲེལ༌ཏེ༌ ངའེ༌ མལ༌ཙ༌ ཚི༌ཏུ༌ གྱུར༌ཅུགས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“སི༌མི༌འོན༌ དང༌ ལི༌ཝི༌ སྤུན༌ལ༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ ར༌འི༌ ནོད༌སྐྱལ༌ ཏང༌ཅེས༌ལ༌ ཀོལ༌ལ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ང༌ ཁོང༌གུན༌ནི༌ ཚོགས༌དུའི༌ ནང༌ང༌ ཛོམས༌ཏེ༌ ཁོང༌ངི༌ ཐབ༌ལྡིངས༌གུན༌ནི༌ ནང༌ང༌ དྲེས༌ ཅུག༌ག༌ མ༌ཛད༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ སྲོའེ༌ ནང༌ང༌ མི༌གུན༌ སདས༌ ཡང༌ ལང༌ཏོའེ༌ རྐང༌པའེ༌ གྱུས༌པ༌ ཅད༌ཏེ༌ སྟན༌མོ༌ ལྟས༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ཇིགས༌ནང༌ཅན༌, ངན༌པ༌ དང༌ རྩོག༌པོ༌ ཁོང༌གུན༌ནི༌ སྲོའ༌ ངན༌ ཕོག༌ཤིག༌། ཁོང༌གུན༌ནི༌ མིར༌གྱུད༌གུན༌ ཛོམས༌ཏེ༌ མ༌ལུས༌ས༌ ཨིས༌ར༌ཨེལ༌ལི༌ ས༌ཆ༌ གང༌པོའེ༌ ནང༌ང༌ ཡན༌ཏེ༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“ཡ༌ཧུ༌དཱ༌ ཁྱོ༌རང༌ངི༌ གྲ༌འོ༌གུན༌ལ༌ ཕམ༌ཀལ༌ཨིན༌, ཁྱོ༌རང༌ངི༌ སྤུན༌ལ༌གུན༌ནི༌ ཁྱོ༌རང༌ང༌ སྟོད༌ཨིན༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཁྱོ༌རང༌ངི༌ དུན༌ལ༌ གོ༌ སྒུ༌ཨིན༌ ");
INSERT INTO lbj_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ངའེ༌ བུ༌ཚ༌ ཡ༌ཧུ༌དཱ༌ ཁྱོ༌རང༌ སིང༌གེ༌ ཕྲུ༌གུ༌ གྲོད༌པ༌ གྲངས༌ཏེ༌ ཚངས༌སི༌ ནང༌ང༌ ལོགས༌ཏེ༌ ཡོང༌ཁན༌ ཙོགས༌ ཨིན༌ནོག༌། ཡང༌ སིང༌གེ༌ རྐང༌ལག༌ རྐྱངས༌ཏེ༌ ཉིད༌ལོགས༌ཏེ༌ ཡོད༌ཁན༌ ཙོགས༌, སུའི༌ ཁོའ༌ ཉིད༌ཚད༌ཅེས༌སི༌ ཧམ༌པ༌ ཅོ༌ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ཝང༌སྲུལ༌པ༌ ཏུས༌གྱུན༌ ཡ༌ཧུ༌དཱའེ༌ གྱུད༌ནེ༌ ཡོང༌ཨིན༌། གྱལ༌པོའེ༌ ཆག༌བེར༌, ཝང༌ཆ༌ ཡོད༌ཁན༌ནི༌ སྟགས༌པོ༌ ཁོང༌གུན༌ནི༌ ལག༌པའེ༌ ནང༌ང༌ ཐམས༌ཏེ༌ བོར༌ཨིན༌ ནམ༌ཚག༌པ༌ ཏེ༌བོའེ༌ དག༌པོ༌བོ༌ མི༌ཡོང༌། ཡང༌ ཁོང༌ང༌ ཇིག༌རྟེན༌པ༌ ཚང༌མའེ༌ རྩི༌ཝ༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ཁོའེ༌ ཁོ༌རང༌ངི༌ བུང༌བུ༌ རྒུན༌ཚས༌སི༌ ནང༌ང༌, ཡང༌ ཀུ༌རུག༌ རྒུན༌ནི༌ ལྕང༌མ༌ གྱལ༌ཤོག༌ག༌ ཏག༌ཨིན༌། ཁོའེ༌ ཁོ༌རང༌ངི༌ ཀོས༌ལག༌གུན༌ རྒུན༌ཆང༌ངི༌ ནང༌ང༌ ཡང༌ ཀོས༌པོ༌ རྒུན༌ཆང༌ མར༌པོ༌ ཉམ༌པོ༌ ཁྲུ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ཁོའེ༌ མིག༌གུན༌ རྒུན༌ཆང༌ངི༌ སང༌ མང༌ང༌ ནག༌པོ༌ ཡང༌ ཁོའེ༌ སོ༌གུན༌ འོ༌མའེ༌ སང༌ མང༌ང༌ ཀར༌པོ༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“ཟེ༌བུ༌ལོན༌ ཚོའེ༌ ཐའ༌མ༌ ཚུགས༌ཏེ༌ གྲུ༌ཟིང༌གུན༌ བོར༌སའེ༌ ཇིགས༌ནང༌ མེད༌ཁན༌ནི༌ ནས༌ས༌ གྱུར༌ཨིན༌། ཁོའེ༌ ས༌ཆའ༌ སི༌དོན༌ ཚག༌པ༌ གྱས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ཨིས༌ས༌ཁར༌ མ༌ ཤེད༌ཅན༌ བུང༌བུ༌, རྒལ༌གུན༌ནི༌ པར༌ལ༌ སའེ༌ཀ༌ ངལ༌ཚོས༌ཏེ༌ དུག༌ཁན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ངལ༌ཚོ༌སའེ༌ ས༌ཆ༌བོ༌ གྱལ༌ལ༌ ཡང༌ ལྡེ༌མོ༌ ཐོང༌ཏེ༌ ཁོའེ༌ ཁུ༌རུ༌ ཁུར༌ཅེས༌ལ༌ ཁོ༌རང༌ངི༌ སྤུང༌པ༌ སྒུས༌ ཡང༌ ཚེ༌ཡོག༌ གྱུར༌ཅེས༌ལ༌ ཐད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ཨིས༌ར༌ཨེལ༌ལི༌ ཞན༌ཡང༌ མི༌སྡེ༌གུན༌ ཙོགས༌ལ༌ གྲེན༌ནི༌ ཁོ༌རང༌ངི༌ མི༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","གྲེན༌ གྱ༌ལམ༌མི༌ ཐའ༌མ༌ ཡོད༌ཁན༌ནི༌ རུལ༌, ལམ༌མི༌ ཐའ༌མའེ༌ དུག༌རུལ༌ ཙོགས༌, ཀ༌བོའེ༌ རྟའེ༌ རྐང༌པའེ༌ མོང༌ལོའ༌ ཐམས༌ཏེ༌ རྟའེ༌ཀ༌ ཞོན༌ཁན༌བོ༌ གྱབ༌ལོག༌ག༌ གྱེལ༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“ཡ༌ཝ༌, ཉེ༌རང༌ངི༌ ཐར༌པའེ༌ ཕིའ༌ ངའ༌ སྲུངས༌ཏེ༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ཅག༌པའེ༌ སྡེ༌ གཱད༌ལ༌ སྤུང༌གོལ༌ ཅོ༌ཨིན༌། ཨིན༌ནའང༌ ཁོའེ༌ ཁོང༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ སྤུང༌གོལ༌ ཅོའ༌ཅིག༌ ཁོང༌གུན༌ ཤོར༌ཨིན༌ ཨང༌ ཁོའེ༌ ཏེད༌ཏེ༌ ཁྱེར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“ཨ༌ཤེར༌ དུག༌སའེ༌ ས༌ཆའེ༌ཀ༌ སྟོན༌ཐོག༌ གྱལ༌ལ༌ སྨིན༌ཨིན༌། གྱལ༌པོ༌ ཟའ༌ཁན༌ནི༌ ཁར༌ཇི༌ ཞིམ༌པོ༌ ཁོའེ༌ རིག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“ནཕ༌ཐལ༌ལི༌ རང༌ཝང༌ཅན༌ནི༌ ཤ༌ཝ༌ ཙོགས༌, ཀ༌བོའ༌ མ༌ ལྡེ༌མོ༌ ཕྲུ༌གུ༌གུན༌ སྐྱེའ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“ཡོ༌སེབ༌ ཁ༌ཟས༌ ཆགས༌ཁན༌ རྒུན༌ནི༌ ལྕང༌མ༌ ཟང༌པོ༌, ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ ཆུ༌མིག༌གི༌ དུན༌ལ༌ ཡོད༌ཁན༌ནི༌ རྒུན༌ནི༌ ལྕང༌མ༌ ཙོགས༌ ཀ༌བོའེ༌ ཡལ༌ག༌གུན༌ གྱས༌ཏེ༌ གྱང༌ངི༌ཀ༌ ཁྲིལ༌ལད༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","དའ༌ དང༌ ཞུ༌ ཀོལ༌ཁན༌གུན༌ནི༌ ཁོའ༌ སྤུང༌གོལ༌ ཀྲག༌པོ༌ ཅོ༌ཨིན༌, ཡང༌ དའ༌ ཏང༌ཨིན༌ ཁོའ༌ ཏེད༌ཏེ༌ ཁྱེར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ལག༌པ༌ ཤེད༌ཅན༌ནི༌ ནང༌ང༌ ཞུ༌ སྟན༌པོ༌ ཐམས༌ཏེ༌ བོར༌ཨིན༌། ཅིའ༌ཟེར༌ན༌ ངའེ༌ དཀོན༌མཆོག༌ ཀུན༌ཝང༌ངི༌ ཆག༌ ཁྱོ༌རང༌ངི༌ཀ༌ བོར༌ར༌ ཛད༌ཨིན༌, ཁོང༌ ནི༌ ལུག༌རྫི༌, ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ བྲག༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ཁྱོ༌རང༌ངི༌ ཕ༌མེས༌པོའེ༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌རང༌ང༌ རོགས༌ ཛད༌ཤིག༌། དཀོན༌མཆོག༌ ཀུན༌ཝང༌ངི༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ སལ༌ཤིག༌། ནམ༌ཁའ༌ནེ༌ ཆར༌པ༌ དང༌ སའེ༌ ཐིལ༌ནེ༌ ཆུ༌, ཡང༌ སེམས༌ཅན༌ནི༌ ཁྱུ༌ དང༌ པུར༌གྱུད༌ མང༌པོའེ༌ ཅིན༌ལབས༌ སལ༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ཁྱོ༌རང༌ང༌ དཀོན༌མཆོག༌གི༌ ཅིན༌ལབས༌གུན༌ སྔུན༌ཏུས༌སི༌ རི༌ དང༌ བྲག༌ གུན༌ནི༌ ཀ༌ནེ༌ ཐོབ༌ཁན༌ནི༌ ཕན༌ཐོགས༌སི༌ སང༌ ཀྲག༌ག༌ ཡོང༌ཅེས༌ ངའེ༌ ཨིད༌ཤེས༌ ཅོའད༌། ཡོ༌སེབ༌བི༌ གོ༌ དང༌ ཐོད༌པའེ༌ཀ༌ འི༌ ཅིན༌ལབས༌གུན༌ བབས༌ཤིག༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌གུན༌ནི༌ ཕྲོ༌ནེ༌ གྱལ༌ལུ༌བོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“བེན༌ཡཱ༌མིན༌ སྲན༌ཏྲེ༌ སྟོགས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ཤང༌ཀུ༌ ཙོགས༌ ཨིན༌ནོག༌, ང༌ཏོག༌ ཁོའེ༌ ཟའ༌ཅེས༌ལ༌ སེམས༌ཅན༌ སད༌ད༌ནོག༌ ཡང༌ ཕི༌ཏོག༌ ཏེ༌ སད༌ཁན༌ ཚང༌མ༌ བགོའ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ཁོང༌ ཚང༌མ༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌ རྕུག༌ཉིས༌གུན༌ ཨིན༌ནོག༌ ཡང༌ ཏེ༌གུན༌ ཁོང༌གུན༌ནི༌ ཨ༌བའེ༌ བུ༌ཚ༌ རེ༌རེའ༌ འོས༌པའ༌ ནང༌ཞིན༌ ཅིན༌ལབས༌ སལ༌ཁན༌བོ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ལ༌ བཀའ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཏ༌ ངའ༌ ང༌རང༌ངི༌ ཕ༌མེས༌པོ༌གུན༌ ཉམ༌པོ༌ ཛོམ༌ཅེས༌ ཨིན༌ནོག༌། ངའ༌ ང༌རང༌ངི༌ ཨ༌བ༌ དང༌ མེ༌མེ༌ ཉམ༌པོ༌, ཧེད༌པ༌ ཨེ༌ཕོ༌རོན༌ནི༌ ཞིང༌ངི༌ཀ༌ ཡོད༌ཁན༌ནི༌ བྲག༌ཕུགས༌སི༌ ནང༌ང༌ སུབ༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ཏེ༌བོ༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ མམ༌རེ༌ ཉེ༌མོའ༌ མེཁ༌ཕི༌ལའི༌ ཞིང༌ངི༌ བྲག༌ཕུག༌ ཀ༌བོ༌ ཨབ༌ར༌ཧམ༌མི༌ ཧེད༌པ༌ ཨེ༌ཕོ༌རོན༌ནི༌ ཀ༌ནེ༌ རོ༌ སུབ༌ཅེས༌སི༌ ཕིའ༌ ཉོས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ཏེ༌ནང༌ང༌ ཨབ༌ར༌ཧམ༌ དང༌ ཁོང༌ངི༌ ན༌མ༌ སཱ༌ར༌ ཡང༌ ཨི༌སཱག༌ དང༌ ཁོའེ༌ ན༌མ༌ ར༌བེ༌ཀ༌ གུན༌ སུབས༌ཏེ༌ ཨིན༌པིན༌ ཡང༌ ཏེ༌ནང༌ང༌ ངའེ༌ ལི༌ཡ༌ སུབས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ཏེ༌ ཞིང༌ དང༌ བྲག༌ཕུགས༌ གུན༌ ཧེད༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཉོས༌ཏེ༌ ཨིན༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ཡ༌ཀོབ༌བི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ལ༌ ལབ༌ཞ༌ ཏང༌ ཚར༌ར༌ཅིག༌ ཁོ༌རང༌ མལ༌ཙེ༌ཀ༌ ཉལས༌ ཡང༌ སྟིང༌ཇུག༌གི༌ འུགས༌ ལེན༌ཏེ༌ ཁོ༌རང༌ངི༌ ཕ༌མེས༌པོ༌གུན༌ ཉམ༌པོ༌ ཛོམས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ཡོ༌སེབ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཁྲིལ༌ཏེ༌ ངུ༌ཨིན༌ ཁོའ༌ པུག༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌, ཁོའ༌ ཞབས༌ཏོག༌ ཅོ༌ཁན༌ནི༌ ཨམ༌ཅི༌གུན༌ལ༌ ཨ༌བའེ༌ ཟུགས༌པོ༌ མི༌ རུལ༌ཅེས༌སི༌ ཕིའ༌ སྨན༌ སྐུ༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ཏུས༌གྱུན༌ ཙོགས༌ལ༌ ཟུགས༌པོའ༌ སྨན༌ སྐུ༌ཅེས༌ལ༌ ཞག༌མ༌ ཞིབ༌ཅུ༌ གོར༌, ཡ༌ཀོབ༌བི༌ ཕིའ༌ ཨི༌ཇིབ༌པ༌ ཚང༌མའེ༌ ཞག༌པོ༌ རྡུན༌ཅུ༌ ཉ༌ངན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ཉ༌ངན༌ནི༌ ཏུས༌པོ༌ བུད༌ད༌ཅིག༌ ཡོ༌སེབ༌བི༌ གྱལ༌པོའེ༌ འུ༌སྐྱོང༌གུན༌ལ༌ ཟེརས༌, “ང༌ ཐུག༌རྗེ༌ ཛད༌ཏེ༌ ཇུ༌ཇུ༌ འི༌ ལོན༌བོ༌ གྱལ༌པོའ༌ མོལ༌, ");
INSERT INTO lbj_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘ངའེ༌ ཨ༌བའེ༌ ངའ༌, ཀེ༌ནན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ ཁོང༌རང༌ངི༌ ཕིའ༌ སྤུར༌ཁང༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ ཡོད༌ཁན༌བོའེ༌ ནང༌ང༌ ཁོང༌ སུབ༌ཅེས༌ལ༌ ནའ༌ ཁུར༌ཅུགས༌ཏེ༌ ཁ༌ཆད༌ ཅོ༌ཅུགས༌།’ ཏ༌ ང༌ ང༌རང༌ངི༌ ཨ༌བ༌ སུབ༌ཅེས༌ལ༌ ཆའ༌ ཅུག༌ག༌ ཛད༌, ཏེ༌ནེ༌ ང༌ ལོགས༌ཏེ༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","གྱལ༌པོའེ༌ ལན༌ཏངས༌, “སོང༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ཨ༌བ༌ སུབ༌ ཀ༌ཟུག༌ ཁྱོ༌རང༌ངི༌ ཁོང༌ང༌ ཁ༌ཆད༌ ཅོས༌ཏེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ཏེ༌ནེ༌ ཡོ༌སེབ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ སུབ༌བ༌ལ༌ སོང༌། གྱལ༌པོའེ༌ འུ༌སྐྱོང༌ ཚང༌མ༌ དང༌ ཨི༌ཇིབ༌པ༌ འུ༌སྐྱོང༌ ཚང༌མ༌ ཡོ༌སེབ༌ ཉམ༌པོ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ཁོ༌ དང༌ ཁོའེ༌ སྤུན༌ལ༌གུན༌ནི༌ ནང༌ཚངས༌ ཚང༌མ༌ ཡང༌ ཁོང༌ངི༌ ཨ༌བའེ༌ ནང༌མི༌ ཚང༌མ༌ ཁོ༌ ཉམ༌པོ༌ སོང༌། ཁོང༌གུན༌ནི༌ ཕྲུ༌གུ༌གུན༌, ར༌ལུག༌ དང༌ བ༌ལང༌ངི༌ ཁྱུ༌གུན༌ གོ༌ཤེན༌ནི༌ ཡུལ༌ལ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ཤིང༌རྟ༌ དང༌ རྟའེ༌ཀ༌ ཞོན༌ཁན༌ནི༌ མི༌གུན༌ནའང༌ ཁོ༌ ཉམ༌པོ༌ སོང༌། མི༌ཚོགས༌ ཆེན༌མོ༌ཞིག༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ཁོང༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ ཤར༌ ཆོགས༌ལ༌ ཁུ༌ཡུས༌ སྐོར༌སའེ༌ ས༌ཆ༌ ཨ༌ཏད༌ལ༌ ལེབ༌བ༌ཅིག༌ ཁོང༌གུན༌ནི༌ ཤེད༌ཅན༌ ངུས༌ཏེ༌ ཉ༌ངན༌ ཅོས༌ ཡང༌ ཏེ༌རུ༌ ཡོ༌སེབ༌བི༌ ཞག༌པོ༌ རྡུན༌ ཨ༌བའེ༌ ཕིའ༌ ཉ༌ངན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ཀེ༌ནན༌པ༌གུན༌ནི༌ ཨ༌ཏད༌ ཁུ༌ཡུས༌ སྐོར༌སའེ༌ ས༌ཆའེ༌ཀ༌ ཁོང༌གུན༌ནི༌ ཉ༌ངན༌ ཅོ༌ཨིན༌ ཐོང༌ཏེ༌ ཟེརས༌, “འི༌ ཏུས༌པོ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཕིའ༌ ཉ༌ངན༌ སྲན༌ཏྲེ༌ ཏུས༌ཤིག༌ ཨིན༌ནོག༌།” ཏེན༌ན༌བོའེ༌ ཞས༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཉེ༌མོའ༌ ཡོད༌ཁན༌ ཏེ༌ ས༌ཆ༌བོའེ༌ མིང༌ང༌ ཨ༌བེལ༌ མིཟ༌རེམ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ཏེ༌ནེ༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌ནི༌ ཨ༌བའེ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ཁོང༌གུན༌ནི༌ ཁོའེ༌ སྤུར༌ ཀེ༌ནན༌ལ༌ ཁྱེརས༌ ཡང༌ མམ༌རེའེ༌ ཉེ༌མོའ༌ མེཁ༌ཕི༌ལའི༌ ཞིང༌ངི༌ བྲག༌ཕུགས༌སི༌ ནང༌ང༌ སུབས༌ ཀ༌བོ༌ ཨབ༌ར༌ཧམ༌མི༌ ཧེད༌པ༌ ཨེ༌ཕོ༌རོན༌ནི༌ ཀ༌ནེ༌ རོ༌ སུབ༌ཅེས༌སི༌ ཕིའ༌ ཉོས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ཨ༌བའེ༌ སྤུར༌ སུབ༌ ཚར༌ཏེ༌ སྟིང༌ནེ༌ ཡོ༌སེབ༌ ཨི༌ཇིབ༌བ༌ ལོགས༌ཏེ༌ སོང༌། ཁོའེ༌ སྤུན༌ལ༌གུན༌ དང༌ ཁོ༌ ཉམ༌པོ༌ ཡོངས༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མའང༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ཡ༌ཀོབ༌ ཤིའ༌ཅིག༌ ཡོ༌སེབ༌བི༌ ཨ༌ཅོ༌གུན༌ནི༌ ཟེརས༌, “ཡོ༌སེབ༌བ༌ ང༌དང༌གུན༌ནི༌ཀ༌ ཏ༌རུང༌ངའང༌ སྲོ༌ ལུས༌ཏེ༌ ང༌དང༌གུན༌ནི༌ ཁོའ༌ ངན༌པ༌ ཅོ༌ཁན༌བོའེ༌ གྱབ༌གལ༌ལ༌ ལན༌ ཏང༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ནི༌ ཡོ༌སེབ༌བ༌ ལོན༌ ཀལས༌, “ང༌དང༌གུན༌ནི༌ ཨ༌བ༌ ཤི༌ སང༌ སྔུན༌ལ༌, ");
INSERT INTO lbj_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ཁོང༌ངི༌ ང༌ཞའ༌ ཉེ༌རང༌ང༌ འི༌བོ༌ ཟེར༌ཅེས༌ལ༌ མོལས༌, ‘ཇུ༌ཇུ༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌གུན༌ནི༌ ཁྱོ༌རང༌ང༌ ངན༌པ༌ ཅོས༌ཏེ༌ སྡིག༌པ༌ ཅོ༌ཁན༌བོའ༌ གོངས༌པ༌ ཏོང༌།’ ཏ༌ ཇུ༌ཇུ༌ ང༌ཞའ༌ ཉེ༌རང༌ངི༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌གི༌ ཡོག༌པོ༌གུན༌ནི༌ སྡིག༌པ༌ ཅོ༌ཁན༌བོའ༌ གོངས༌པ༌ སལ༌ལ༌ ཛད༌།” ཏེ༌ ལོན༌བོ༌ ཚོར༌ཏེ༌ ཡོ༌སེབ༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ཏེ༌ནེ༌ ཁོའེ༌ ཨ༌ཅོ༌གུན༌ ཡོངས༌ཏེ༌ ཡོ༌སེབ༌བི༌ དུན༌ལ༌ གྱེལ༌ཏེ༌ ཟེརས༌, “ང༌ཞའ༌ ཉེ༌རང༌ངི༌ ཚེ༌ཡོག༌གི༌ ཚུལ༌ལ༌ དུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ཨིན༌ནའང༌ ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཇིགས༌ མ༌ཇིགས༌། ངའ༌ ཁྲིམས༌ཅད༌ ཏང༌ཁན༌ནི༌ དཀོན༌མཆོག༌ མན༌? ");
INSERT INTO lbj_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ གྱབ༌གལ༌ལ༌ ངན༌པ༌ ཅོ༌ཅེས༌ ཅོས༌, ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ཏེ༌བོ༌ གྱལ༌ལ༌ གྱུར༌ཅུག༌ག༌ ཛད༌ཏེ༌ མི༌ མང༌པོའེ༌ སྲོག༌ སྐྱོབ༌བ༌ ཛདས༌, ཀ༌ཟུག༌ དི༌རིང༌ ཇུང༌ཨིན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ཁྱོ༌ཞའ༌ ཇིགས༌གོས༌ མེད༌པ༌ ཨིན༌ནོག༌། ངའེ༌ ཁྱོ༌ཞའ༌ དང༌ ཁྱོ༌ཞའེ༌ ཕྲུ༌གུ༌གུན༌ནི༌ སྒོས༌དོམ༌གུན༌ རིག༌ཨིན༌།” ཏེན༌ན༌ཟུག༌གི༌ ཡོ༌སེབ༌བི༌ ཁོང༌གུན༌ལ༌ སྤེ༌ར༌ ལྡེ༌མོ༌ ཏངས༌ཏེ༌ ལོ༌ཁྱེལ༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ཡོ༌སེབ༌ ཁོའེ༌ ཨ༌བའེ༌ ནང༌མི༌ ཚང༌མ༌ ཉམ༌པོ༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཁོའ༌ ལོ༌ གྱ༌དང༌རྕུ༌ ཆ༌ཆའ༌ ཚག༌པ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ཡོ༌སེབ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ ཕྲུ༌གུ༌གུན༌ དང༌ ཚ༌འོ༌ གུན༌ ཐོང༌ཐོང༌ ཚག༌པ༌ སོན༌ཏེའ༌ ལུས༌། ཡོ༌སེབ༌བི༌ མ༌ནས༌ས༌ བུ༌ཚ༌ མ༌ཀིར༌རི༌ ཕྲུ༌གུ༌གུན༌ སོས༌བུའ༌ ལེནས༌། ");
INSERT INTO lbj_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ལ༌ ཟེརས༌, “ང༌ ཤི༌ཅེས༌ ཨིན༌ནོག༌། ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞ༌གུན༌ལ༌ རོགས༌ ཛད༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ནེ༌ ཕིངས༌ཏེ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌ དང༌ ཡ༌ཀོབ༌ གུན༌ལ༌ ཁ༌ཆད༌ ཛད༌ཁན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱེར༌ར༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌ལ༌ ནའ༌ ཁུར༌ཅུགས༌ཏེ༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞ༌གུན༌ འི༌ ས༌ཆ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱེར༌ར༌ ཛད༌ ཟ༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ རུས༌པ༌གུན༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ཁྱེར༌།” ");
INSERT INTO lbj_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ཏེ༌ནེ༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཡོ༌སེབ༌བ༌ ལོ༌ གྱ༌དང༌རྕུ༌ སོང༌ཏེ༌ ཀྲོངས༌། ཁོའེ༌ ཟུགས༌པོའ༌ སྨན༌ སྐུས༌ཏེ༌ སྤུར༌ སྒམ༌མི༌ ནང༌ང༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","འི༌གུན༌ ཨིས༌ར༌ཨེལ༌ ཡང༌ན༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌ ཁོང༌ ཉམ༌པོ༌ ཨི༌ཇིབ༌བ༌ ཆའ༌ཁན༌གུན༌ ཨིན༌ནོག༌, ཁོང༌ ཚང༌མའེ༌ ནང༌ཚངས༌ གུན༌ནའང༌ ཉམ༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","རུ༌བེན༌, སི༌མེ༌འོན༌, ལི༌ཝི༌, ཡ༌ཧུ༌དཱ༌, ");
INSERT INTO lbj_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ཨིས༌ས༌ཁར༌, ཟེ༌བུ༌ལོན༌, བེན༌ཡཱ༌མིན༌, ");
INSERT INTO lbj_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","དཱན༌, ནཕ༌ཐལ༌ལི༌, གཱད༌ དང༌ ཨ༌ཤེར༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ཡ༌ཀོབ༌ གྱུད༌ཏེ༌ ཁོའེ༌ མིར༌གྱུད༌ ཚང༌མ༌ རྡུན༌ཅུ༌ ཡོད༌པིན༌, ཡོ༌སེབ༌ ཨི༌ཇིབ༌ ནང༌ང༌ སྔུན༌ལ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ཏ༌ ཡོ༌སེབ༌, ཁོའེ༌ ཨ༌ཅོ༌ནོ༌ དང༌ ཁོང༌གུན༌ནི༌ མི༌རབས༌ ཚང༌མ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཕྲུ༌གུ༌ ཇོར༌ ཡང༌ ཁོང༌གུན༌ མ༌མང༌པོ༌ ཕེལ༌ཏེ༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ ནང༌ང༌ གང༌ ཡང༌ མ༌ ཤེད༌ཅན༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ཏེ༌ནེ༌ ཡོ༌སེབ༌བི༌ སྐོར༌ལ༌ ཅའང༌ གྱུས༌ མེད༌ཁན༌ གྱལ༌པོ༌ སོ༌མ༌ཞིག༌ ཨི༌ཇིབ༌བི༌ ཝང༌སྲུལ༌པ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ཁོའེ༌ ཁོང༌རང༌ངི༌ མི༌གུན༌ལ༌ ཟེརས༌, “འི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ང༌དང༌གུན༌ནི༌ སང༌ མང༌ང༌ དང༌ ཤེད༌ཅན༌ གྱུར༌ཏེ༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ཡོང༌ཤིག༌, ང༌དང༌གུན༌ནི༌ ཁོང༌གུན༌ མང༌པོ༌ མི༌ཕེལ༌ཅེས༌སི༌ ཐབས༌ ཙལ༌གོས༌, ཏེ༌མན༌ནེ༌ མག༌གི༌ ཏུས༌ལ༌ ཁོང༌གུན༌ གྲ༌འོ༌གུན༌ ཉམ༌པོ༌ ཛོམས༌ཏེ༌ ང༌དང༌ངི༌ གྱབ༌གལ༌ལ༌ མག༌ ཏངས༌ཏེ༌ འི༌ ཡུལ༌ནེ༌ བིང༌ཏེ༌ ཆའ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཝང༌ ཉམ༌པོ༌ ལས༌ ནགས༌ཅན༌ ཅོ༌ཅུག༌ཅེས༌ལ༌ སྤོན༌བོ༌གུན༌ སྐོས༌, ཀ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ ཕིའ༌ གྲུ༌ སག༌སའེ༌ གྱལ༌ས༌ པི༌ཐོམ༌ དང༌ རམ༌སིས༌ གུན༌ རྩིག༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཙམ༌ཤིག༌ མང༌ང༌ ནགས༌ སྟན༌ནའང༌ ཁོང༌གུན༌ མང༌ང༌ ཕེལ༌ཏེ༌ གྱས༌ཨིན༌ སོང༌། ཏེ༌བོའེ༌ ཕིའ༌ ཨི༌ཇིབ༌པ༌གུན༌ ཁོང༌གུན༌ལ༌ ཇིགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ཁོང༌གུན༌ལ༌ སྙིང༌རྗེ༌ མེད༌པ༌ ནགས༌ཅན༌ ལས༌ ཅོ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མི༌ཚེ༌ མ༌ འུ༌ཐུགས༌ གྱུར༌ཅུགས༌། ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཝང༌ ཏངས༌ཏེ༌ པག༌བུ༌, ཀ༌ལག༌ དང༌ ཞིང༌ངི༌ ལས༌ རིགས༌ ཚང༌མ༌ ཅོ༌ཅུག༌གད༌པིན༌ ཡང༌ ལས༌ ཀགས༌པོ༌ ཅོའ༌ལ༌ ཏང༌ཁན༌ ཚང༌མའེ༌ ནང༌ང༌ ཁོང༌གུན༌ནི༌ སྙིང༌རྗེ༌ སྟན༌ན༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ཏེ༌ནེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ ཕྲུ༌གུ༌ ཇོར༌ ཟ༌ནེ༌ རོགས༌ ཅོ༌ཁན༌ ཤིཕ༌རཧ༌ དང༌ པུ༌འཧ༌ ཨིབ༌རི༌པ༌ བུ༌མོ༌གུན༌ལ༌ བཀའ༌ ཏངས༌ཏེ༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“ཁྱོ༌ཞའེ༌ ཨིབ༌རི༌པ༌ བུ༌མོ༌གུན༌ལ༌ ཕྲུ༌གུ༌ ཇོར༌ཏུས༌ རོགས༌ ཅོ༌ ཟ༌ནེ༌, ཀལ༌ཏེས༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ ཨིན༌ན༌ སོད༌ ཨིན༌ནའང༌ བུ༌མོ༌གུན༌ སོན༌ཏེའ༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ཨིན༌ནའང༌ ཕྲུ༌གུ༌ ཇོར༌ཏུས༌ རོགས༌ ཅོ༌ཁན༌གུན༌ དཀོན༌མཆོག༌ག༌ ཇིགས༌ཏེ༌ གྱལ༌པོའེ༌ ཁའ༌ མ༌ཉནས༌ ཡང༌ ཕྲུ༌གུ༌ བུ༌ཚ༌གུན༌ མ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཕྲུ༌གུ༌ ཇོར༌ཏུས༌ རོགས༌ ཅོ༌ཁན༌ནི༌ བུ༌མོ༌གུན༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཏྲིས༌, “ཁྱོ༌རང༌གུན༌ནི༌ འི༌བོ༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ཕྲུ༌གུ༌ བུ༌ཚ༌གུན༌ ཅིའ༌ མ༌སད༌པིན༌?” ");
INSERT INTO lbj_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ཁོང༌གུན༌ནི༌ གྱལ༌པོ༌ ལན༌ཏངས༌, “ཨིབ༌རི༌པ༌ བུ༌མོ༌གུན༌ ཨི༌ཇིབ༌པ༌ བུ༌མོ༌གུན༌ ཙོགས༌ མེད༌ཏེ༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ལ༌ ཕྲུ༌གུ༌ ལ༌མོའ༌ ཇོར༌དུག༌, ང༌ཞའ༌ ལེབ༌བི༌སང༌ སྔུན༌ལ༌ ཁོང༌གུན༌ལ༌ ཕྲུ༌གུ༌ ཇོར༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","དཀོན༌མཆོག༌གི༌ ཏེ༌ བུ༌མོ༌གུན༌ལ༌ ཐུག༌རྗེ༌ ཛདས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ མང༌ང༌ ཕེལ༌ཨིན༌ སོང༌ཏེ༌ ཤེད༌ཅན༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ཡང༌ ཕྲུ༌གུ༌ ཇོར༌ཏུས༌ རོགས༌ ཅོ༌ཁན༌ནི༌ བུ༌མོ༌གུན༌ དཀོན༌མཆོག༌ག༌ ཇིགས༌ཁན༌ ཡོད༌ པ༌སང༌ དཀོན༌མཆོག༌གི༌ ཁོང༌གུན༌ལའང༌ ཕྲུ༌གུ༌ སལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ བཀའ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཨིབ༌རི༌པ༌གུན༌ལ༌ སྐྱེ༌ཁན༌ བུ༌ཚ༌ ཚང༌མ༌ ནཱའེལ༌ ལྩངས༌པོའེ༌ ནང༌ང༌ ཕང༌གོས༌ ཨིན༌ནའང༌ བུ༌མོ༌ ཚང༌མ༌ སོན༌ཏེའ༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ཏ༌ ལི༌ཝིའི༌ མི༌སྡེ༌ བུ༌ཚ༌ཞིག༌གི༌ ཏེན༌ན༌ མི༌སྡེ༌ བུ༌མོ༌ཞིག༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ཡང༌ བུ༌མོ༌ ཕན༌ཅེས༌མ༌ གྱུར༌ཏེ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌། བུ༌ཚ༌བོ༌ ལྡེ༌མོ༌ ཕྲུ༌གུ༌ ཞིག༌ ཡོད༌པ༌ ཨ༌མའེ༌ ཕྲུ༌གུ༌བོ༌ ཟླ༌ཝ༌ སུམ༌ སྦས༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ཨིན༌ནའང༌ ཨ༌མའ༌ ཕྲུ༌གུ༌བོ༌ ཏེ༌སང༌ མང༌ང༌ སྦས༌ཏེ༌ བོར༌ མ༌ཉན༌ པ༌སང༌ ཁོའེ༌ པེཔ༌རུས༌ ཟེར༌ཁན༌ནི༌ སོག༌མའ༌ ལས༌ཁན༌ནི༌ པག༌ཙེ༌ ཁྱོངས༌ཏེ༌ ཆུ༌ ནང༌ཀུག༌ག༌ མི༌ཡོང༌ཅེས༌ལ༌ ཏར༌ཀོལ༌ སྐུས༌ ཡང༌ ཕྲུ༌གུ༌བོ༌ ཏེ༌ནང༌ང༌ གྱངས༌ཏེ༌ ནཱའེལ༌ ལྩངས༌པོའེ༌ ཐའ༌མའེ༌ ལྡམ༌བུའི༌ ཕྲོའ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ཕྲུ༌གུའི༌ སྲིང༌མོ༌ ཐག༌རིང༌ཞིག༌ནེ༌ ཁོའ༌ ཅི༌ ཆ༌རུག༌ ལྟེན༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","གྱལ༌པོའེ༌ བུ༌མོ༌ ཆུའ༌ཞུག༌ག༌ལ༌ ལྩངས༌པོ༌ ཆོགས༌ལ༌ བབས༌ཏེ༌ སོང༌ ཡང༌ ཁོའེ༌ ཡ༌ཏོ༌གུན༌ ལྩངས༌པོའེ༌ ཐའ༌མ༌ གྲུལ༌ཨིན༌ ཁོང༌ སྲུང༌ངད༌པིན༌། གྱལ༌མོའ༌ ལྡམ༌བུའི༌ ཕྲོའ༌ པག༌ཙེ༌ ཞིག༌ ཐོང༌ ཡང༌ ཡ༌ཏོ༌ཞིག༌ ཏེ༌བོ༌ ཁྱོང༌ང༌ལ༌ ལམ༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ཁོའེ༌ ཏེ༌བོ༌ ཕེའ༌ཅིག༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ཞིག༌ ཐོང༌། ཕྲུ༌གུ༌བོ༌ ངུ༌ཨིན༌ ཡོད༌པ༌ ཁོང༌ང༌ སྙིང༌རྗེ༌ སྐྱེས༌ཏེ༌ ཟེརས༌, “འི༌བོ༌ ཀ༌ནེའང༌ ཨིབ༌རི༌པ༌ ཞིག༌གི༌ ཕྲུ༌གུ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ཏེ༌ནེ༌ ཁོའེ༌ སྲིང༌མོའེ༌ གྱལ༌པོའེ༌ བུ༌མོའ༌ ཏྲིས༌, “ང༌ སོང༌ཏེ༌ ཕྲུ༌གུའ༌ འོ༌མ༌ སྟེར༌ཁན༌ནི༌ ཨིབ༌རི༌པ༌ བུ༌མོ༌ཞིག༌ ཉེ༌རང༌ངི༌ ཕིའ༌ ཙལ༌ཏེ༌ ཁྱོང༌ང༌?” ");
INSERT INTO lbj_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","གྱལ༌མོའེ༌ ཟེརས༌, “སོང༌ ཡང༌ ཙོལ༌།” ཏེ༌ནེ༌ བུ༌མོ༌བོ༌ སོང༌ ཡང༌ ཕྲུ༌གུའི༌ ཨ༌མ༌ ཁྲིད༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","གྱལ༌མོའེ༌ ཏེ༌ བུ༌མོ༌བོའ༌ ཟེརས༌, “འི༌ ཕྲུ༌གུ༌བོ༌ ཁྱེར༌ ཡང༌ ངའེ༌ ཕིའ༌ འོ༌མ༌ སྟེར༌ཏེ༌ སྟ༌སྟོག༌ ཅོས༌། ངའེ༌ ཁྱོ༌རང༌ང༌ ལ༌ཆ༌ ཏང༌ཨིན༌།” ཏེ༌ནེ༌ བུ༌མོའེ༌ ཕྲུ༌གུ༌ ཁྱེརས༌ ཡང༌ འོ༌མ༌ སྟེར༌ཏེ༌ ཁོའ༌ སྟ༌སྟོག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ཕྲུ༌གུ༌ ཆེན༌མོ༌ ཆའ༌ཅིག༌ ཁོའེ༌ ཨ༌མའེ༌ ཁོ༌ གྱལ༌པོའེ༌ བུ༌མོ༌ ཡོད༌ས༌ ཁྱེརས༌ ཡང༌ ཕྲུ༌གུ༌ ཁོའེ༌ བུ༌ཚ༌ གྱུར༌། ཏེ༌ནེ༌ གྱལ༌མོའེ༌ ཟེརས༌, “ངའེ༌ ཁོ༌ ཆུའི༌ ནང༌ནེ༌ ཕིངས༌ཏེ༌ ཨིན༌ པ༌སང༌ ངའེ༌ ཁོའེ༌ མིང༌ང༌ མོ༌ཟེས༌ ཏག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ལྡན༌ཏེ༌ སྟིང༌ནེ༌ མོ༌ཟེས༌ ཞག༌ཤིག༌ ཁོ༌རང༌ངི༌ མི༌ ཨིབ༌རི༌པ༌གུན༌ ཡོད༌ས༌ ཕི༌ལོག༌ག༌ སོང༌ ཡང༌ ཁོའ༌ ཁོང༌གུན༌ལ༌ ནགས༌ཅན༌ ལས༌ ཅོ༌ ཅུག༌ཁན༌བོ༌ ཐོང༌། ཁོའ༌ ཨི༌ཇིབ༌པ༌ ཞིག༌གི༌ ཁོ༌རང༌ངི༌ མི༌ ཨིབ༌རི༌པ༌ཞིག༌ག༌ རྡུང༌ཨིན༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","མོ༌ཟེས༌སི༌ ཉེ༌ཁོར༌ ཚང༌མ༌ལ༌ ལྟས༌ ཡང༌ སུ༌ཞིག༌གའང༌ མ༌ཐོང༌པ༌ ཁོའེ༌ ཨི༌ཇིབ༌པ༌བོ༌ སད༌ཏེ༌ ཁོའེ༌ ཟུགས༌པོ༌ པེ༌མའེ༌ ནང༌ང༌ སྦས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","སྟིང༌མ༌ཞག༌པོ༌ ཁོ༌ ཡང༌སྐྱར༌ ཕི༌ལོག༌ག༌ སོང༌པ༌ ཁོའ༌ ཨིབ༌རི༌པ༌ མི༌ ཉིས༌ ནོལ༌ཨིན༌ ཐོང༌། མོ༌ཟེས༌སི༌ གལ༌ཏེ༌ ཡོད༌ཁན༌ནི༌ མི༌བོའ༌ ཟེརས༌, “ཅི༌ ཕིའ༌ ཁྱོ༌རང༌ངི༌ ཨིབ༌རི༌པ༌ རང༌ངི༌ ཕྲོ༌པ༌ རྡུང༌ངད༌?” ");
INSERT INTO lbj_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ཁོའེ༌ ལན༌ཏངས༌, “སུའི༌ ཁྱོ༌རང༌ ང༌ཞའེ༌ ཝང༌སྲུལ༌པ༌ དང༌ ཁྲིམས༌ཅད༌ཁན༌ལ༌ སྐོས༌? ཅི༌ ཁྱོ༌རང༌ངི༌ ཨི༌ཇིབ༌པ༌བོ༌ སད༌ད༌ ཙོགས༌ལ༌ ངའང༌ སད༌ཨིན༌ན༌?” ཏེ༌ནེ༌ མོ༌ཟེས༌ ཇིགས༌ ཡང༌ སམ༌, “ངའེ༌ ཅོ༌ཁན༌བོ༌ མི༌གུན༌ལ༌ གྱུས༌ སོང༌ཏེ༌ ཨིན༌ཏིག༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","གྱལ༌པོའ༌ ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ ཁོའེ༌ མོ༌ཟེས༌ སད༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོས༌, ཨིན༌ནའང༌ མོ༌ཟེས༌ གྱལ༌པོའེ༌ ཀ༌ནེ༌ ཤོར༌ཏེ༌ མི༌དིའན༌ནི༌ ས༌ཆའ༌ ལེབས༌ཏེ༌ ཁོ༌ ཆུ༌དོང༌ ཞིག༌གི༌ དུན༌ལ༌ སའི༌ཀ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ཏ༌ མི༌དིའན༌པ༌ བླ༌མ༌ཞིག༌ག༌ བུ༌མོ༌ རྡུན༌ ཡོད༌པིན༌། ཁོང༌གུན༌ ཁོ༌རང༌གུན༌ནི༌ ཨ༌བའེ༌ ར༌ལུག༌གུན༌ལ༌ ཆུ༌ ཏང༌ཅེས༌ལ༌ ཡོངས༌ ཡང༌ ཆུ༌ ཕིངས༌ཏེ༌ ཞོང༌པ༌གུན༌ སྐངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ཨིན༌ནའང༌ ཞན༌ ལུག༌རྫི༌ རིག༌ ཡོངས༌ཏེ༌ ཝང༌ ཉམ༌པོ༌ བུ༌མོ༌གུན༌ ཏེ༌ཀ༌ནེ༌ ཆ༌ཅུགས༌པ༌ མོ༌ཟེས༌ ཁོང༌གུན༌ལ༌ རོགས༌ ཅོའ༌ལ༌ ཡོངས༌ཏེ༌ ཁོང༌ངི༌ ར༌ལུག༌གུན༌ལ༌ ཆུ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ཁོང༌གུན༌ ཨ༌བ༌ རི༌འུལ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ ཏྲིས༌, “དི༌རིང༌ ཁྱོ༌ཞ༌གུན༌ འི༌ཟུག༌ གྱོགས༌པ༌ ལོགས༌ཏེ༌ ཀ༌ཟུག༌གི༌ ལེབ༌?” ");
INSERT INTO lbj_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཨི༌ཇིབ༌པ༌ མི༌ཞིག༌གི༌ ལུག༌རྫི༌གུན༌ནི༌ ཀ༌ནེ༌ ང༌ཞའ༌ སྐྱོབས༌ ཡང༌ ཁོའེ༌ ཆུ༌ ཕིངས༌ཏེ༌ ར༌ལུག༌གུན༌ལ༌ ཏངས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ཨ༌བའེ༌ ཏྲིས༌, “ཁོ༌ ཀ༌རེ༌, ཁྱོ༌ཞའ༌ མི༌བོ༌ བོར༌ཏེ༌ ཅིའ༌ ཡོངས༌པིན༌? སོང༌ ཡང༌ ང༌དང༌གུན༌ ཉམ༌པོ༌ ཁར༌ཇི༌ ཟའ༌ལ༌ ཁོ༌ བོད༌ཏེ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","མོ༌ཟེས༌སི༌ ཏེ༌རུ༌ རི༌འུལ༌ ཉམ༌པོ༌ དུག༌ཅེས༌ ཐག༌ཅདས༌། སྟིང༌ནེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌ ཟི༌པོ༌ར༌ མོ༌ཟེས༌ལ༌ ན༌མ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ཟི༌པོ༌ར༌ བུ༌ཚ༌ཞིག༌ སྐྱེས༌ ཡང༌ མོ༌ཟེས༌སི༌ ཟེརས༌, “འི༌ ས༌ཆ༌བོའེ༌ཀ༌ ང༌ ཞན༌ཡུལ༌ལི༌ མི༌ ཚུགས༌ཏེ༌ ཨིན༌ནོག༌།” ཏེ༌བོའེ༌ ཕིའ༌ ཁོའེ༌ བུ༌ཚའེ༌ མིང༌ང༌ གེར༌ཤོམ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ལོ༌ བན༌ཞིག༌གི༌ སྟིང༌ནེ༌, ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཤི༌ ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཏ༌རུང༌ངའང༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ རྡུག༌ངལ༌ སྟན༌པ༌ ཁོང༌གུན༌ ཚེ༌ཡོག༌ནེ༌ ཐར༌ ཅུག༌ག༌ ཛད༌ཅེས༌ལ༌ ཁོང༌གུན༌ནི༌ སྙིང༌ནེ༌ མོས༌ལམ༌ ཞུའད༌པིན༌ ཡང༌ དཀོན༌མཆོག༌གི༌ ཁོང༌གུན༌ནི༌ མོས༌ལམ༌ སན༌ན༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","དཀོན༌མཆོག༌གི༌ ཁོང༌གུན༌ནི༌ རྡུག༌པོའེ༌ སྐད༌གུན༌ སན༌ཏེ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌ དང༌ ཡ༌ཀོབ༌ གུན༌ ཉམ༌པོ༌ ཛད༌ཁན༌ནི༌ ཁོང༌རང༌ངི༌ ཆད༌དོན༌བོ༌ ཨིད༌ཏུ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ནགས༌བར༌དོ༌ ཐོང༌ཁན༌གུན༌ དཀོན༌མཆོག༌གི༌ ཟིགས༌ ཡང༌ ཁོང༌གུན༌ནི༌ཀ༌ སྙིང༌རྗེ༌ སྐྱེའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ཞག༌ཅིག༌ མོ༌ཟེས༌སི༌ ཁོའེ༌ ན༌མའེ༌ ཨ༌བ༌ མི༌དིའན༌པ༌ བླ༌མ༌ ཡེ༌ཐོརོའེ༌ ར༌ལུག༌གུན༌ ཚོ༌ ཟ༌ནེ༌ ཁོའེ༌ ར༌ལུག༌གུན༌ རི༌སྟོང༌ངི༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཁྱེར༌པ༌ དཀོན༌མཆོག༌གི༌ རི༌ སི༌ནཱའི༌ ཟེར༌ས༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ཏེ༌རུ༌ ཁོའ༌ ལྕང༌མ༌ ཆུ༌ངུན༌ མེ༌ བར༌ཁན༌ནི༌ མེ༌ལྗབ༌བི༌ ནང༌ང༌ ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ཇལ༌། ཆུ༌ངུན༌ ལྕང༌མ༌བོའ༌ མེ༌ བར༌ཨིན༌ ཡོད༌ནའང༌ ཏེ༌བོ༌ མེའ༌ ཞེན༌ན༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","མོ༌ཟེས༌སི༌ སམ༌, “ཅི༌ ཕིའ༌ ཏེ༌ ལྕང༌མ༌བོ༌ མེའ༌ ཞེན༌ན༌ མ༌ནོག༌, ང༌ ཏེ༌བོའ༌ ལྟའ༌ ཆ༌ཉིན༌རག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ཡ༌ཝའེ༌ མོ༌ཟེས༌ དུན༌ལ༌ ཡོང༌ང༌ལ༌ ཟིགས༌ས༌ཅིག༌, ལྕང༌མ༌ ཆུ༌ངུན༌ནི༌ སྐྱིལ༌ནེ༌ ཁོང༌ངི༌ མོལས༌, “མོ༌ཟེས༌། མོ༌ཟེས༌།” ཁོའེ༌ ལན༌ཏངས༌, “ང༌ འི༌ཀ༌ནེ༌ ཡོད༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ཡ༌ཝའེ༌ མོལས༌, “ཏེ༌སང༌ ཉེ༌མོའ༌ མ༌ཡོང༌། ཁྱོ༌རང༌ངི༌ པ༌བུ༌ པུད༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ ལངས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ས༌ཀྱད༌པོ༌ ཏམ༌པ༌ཞིག༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ང༌ ནི༌ ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ཕ༌མེས༌པོ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌ དང༌ ཡ༌ཀོབ༌བི༌ དཀོན༌མཆོག༌ ཨིན༌།” ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ ལྡོང༌བོ༌ ཀབས༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ དཀོན༌མཆོག༌ག༌ ལྟའ༌ལ༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ཡ༌ཝའེ༌ མོལས༌, “ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ངའེ༌ མི༌གུན༌ལ༌ ནགས༌ སྲན༌ཏྲེ༌ སྟན༌ཁན༌བོ༌ ངའེ༌ ཐོང༌། ཚེ༌ཡོག༌ སྲུལ༌ཁན༌གུན༌ནི༌ ནགས༌ སྟན༌ཅེས༌པོའེ༌ སེམས༌ཚེར༌ ཉམ༌པོ༌ ཁོང༌གུན༌ནི༌ མོས༌ལམ༌ ཞུས༌པ༌ ངའེ༌ ཚོར༌ ཡང༌ ཁོང༌གུན༌ལ༌ རྡུག༌ངལ༌ ཐོང༌ཁན༌གུན༌ ང༌ གྱུས༌ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ཏ༌ ཁོང༌གུན༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌ཅེས༌ལ༌ ང༌ ཡོག༌ག༌ བབས༌ཏེ༌ ཡོངས༌ཏེ༌ ཨིན༌ ཡང༌ ཁོང༌གུན༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ནེ༌ ཕིངས༌ཏེ༌ ཅུད༌ཅན༌, ཕལ༌ཅན༌, འོ༌མ༌ དང༌ རང༌རྩི༌ གྱུག༌ཁན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱེར༌ཨིན༌། ཀ༌རུ༌ ཀེ༌ནན༌པ༌, ཧེད༌པ༌, ཨ༌མོར༌པ༌, པེ༌རིཟ༌པ༌, ཧིཝ༌པ༌ དང༌ ཡེ༌བས༌པ༌ གུན༌ དུག༌གད༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ངའ༌ ང༌རང༌ངི༌ མི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མོས༌ལམ༌ ཚོར༌ ཡང༌ ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ གོབ༌ནོན༌ ཅོ༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ཏ༌ སོང༌, ཨིས༌ར༌ཨེལ༌པ༌ ངའེ༌ མི༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིང༌ཏེ༌ ཁྱོང༌ཅེས༌ལ༌ ངའེ༌ ཁྱོ༌རང༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ཀ༌ ལམ༌ཅུག༌གད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ དཀོན༌མཆོག༌ག༌ ཟེརས༌, “གྱལ༌པོའེ༌ཀ༌ སོང༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིང༌ཏེ༌ ཁྱོང༌ཁན༌ ང༌ སུ༌ ཨིན༌ནོག༌?” ");
INSERT INTO lbj_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","དཀོན༌མཆོག༌གི༌ ལན༌སལས༌, “ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌། ཁྱོ༌རང༌ངི༌ མི༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ཅིག༌, ཁྱོ༌ཞ༌ ཚང༌མའེ༌ འིན༌ན༌ རི༌བོའི༌ཀ༌ དཀོན༌མཆོག༌ག༌ ཅོལ༌ཨིན༌། ངའེ༌ ཁྱོ༌རང༌ ཀལ༌ཁན༌ནི༌ སྟགས༌པོ༌ ཏེན༌ན༌བོ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ཟེརས༌, “ང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོའེ༌ དཀོན༌མཆོག༌གི༌ ང༌ ཁྱོ༌ཞ༌ ཡོད༌ས༌ ལམ༌ཅུགས༌ ཟེར༌ན༌ ཁོང༌གུན༌ནི༌, ཁོང༌ངི༌ ཚན༌ ཅི༌ ཨིན༌ནོག༌ ཟེར༌ཏེ༌ ཏྲི༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌? ཏེ༌ནེ༌ ངའེ༌ ཁོང༌གུན༌ལ༌ ཅི༌ ཟེར༌?” ");
INSERT INTO lbj_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","དཀོན༌མཆོག༌གི༌ མོལས༌, “ང༌ ནི༌ ང༌ ཨིན༌ཁན༌བོ༌ ཨིན༌། ཁྱོ༌རང༌ངི༌ ཁོང༌གུན༌ལ༌ ཟེར༌གོས༌, ‘ང༌ ཨིན༌’ མོལ༌ཁན༌བོའེ༌ ང༌ ཁྱོ༌ཞ༌གུན༌ ཡོད༌ས༌ ལམ༌ཅུག༌ག༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","དཀོན༌མཆོག༌གི༌ འི༌བོའང༌ མོལས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེར༌, ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌ དང༌ ཡ༌ཀོབ༌བི༌ དཀོན༌མཆོག༌གི༌ ང༌ ཁྱོ༌ཞ༌གུན༌ ཡོད༌ས༌ ལམ༌ཅུག༌ག༌ ཛདས༌། ཏུས༌གྱུན༌ནི༌ ཕིའ༌ ཏེ༌བོ༌ ངའེ༌ མིང༌ ཨིན༌། མི༌རབས༌ནེ༌ མི༌རབས༌ ངའ༌ འིན༌ན༌ མིང༌བོ༌ ཉམ༌པོ༌ ཨིད༌ཏུ༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“སོང༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌ འུ༌སྐྱོང༌གུན༌ ལྡུས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཟེར༌, ‘ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌ དང༌ ཡ༌ཀོབ༌བི༌ དཀོན༌མཆོག༌ ངའ༌ ཇལ༌ཏེ༌ མོལ༌ལ༌རག༌, “ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཅོ༌ཨིན༌ ཡོད༌ཁན༌གུན༌ནི༌ཀ༌ ངའེ༌ གྱལ༌ལ༌ ནང༌སྟག༌ བོར༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌བི༌ ཏེ༌ རྡུག༌ངལ༌ལི༌ ནང༌ནེ༌ ཕིངས༌ཏེ༌ ཀེ༌ནན༌པ༌, ཧེད༌པ༌, ཨ༌མོར༌པ༌, པེ༌རིཟ༌པ༌, ཧིཝ༌པ༌ དང༌ ཡེ༌བས༌པ༌ གུན༌ དུག༌སའེ༌ ས༌ཆ༌ ཁྱེར༌ཨིན༌ ཀ༌རུ༌ འོ༌མ༌ དང༌ རང༌རྩི༌ གྱུག༌ག༌ནོག༌།”’” ");
INSERT INTO lbj_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ཨིས༌ར༌ཨེལ༌པའེ༌ འུ༌སྐྱོང༌གུན༌ནི༌ ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌གུན༌ ཉན༌ཨིན༌། ཏེ༌ནེ༌ ཁྱོ༌རང༌ དང༌ ཁོང༌གུན༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེར༌, ‘ང༌ཞའ༌ ཡ༌ཝ༌ ཨིབ༌རི༌པ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཇལ༌, ཡ༌ཝ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌ལ༌ ང༌ཞ༌གུན༌ ཞག༌ སུམ༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ བེས༌ལ༌ ཆ༌ཅུག༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“ཨིན༌ནའང༌ ང༌ གྱུས༌ཡོད༌ ཝང༌ཅན༌ སྟོབས༌པོ༌ སྟན༌ཏེ༌ མ༌ནེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ ཁྱོ༌ཞ༌གུན༌ ཆ༌ མི༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ཏེ༌བོའེ༌ཕིའ༌ ངའེ༌ ང༌རང༌ངི༌ ལག༌པ༌ རྐྱངས༌ཏེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཕྲོའ༌ ངའེ༌ ལྟས༌ ཚང༌མ༌ སྟན༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཆད༌པ༌ ཅད༌ཨིན༌། ཏེ༌སྟིང༌ནེ༌ ཁོའེ༌ ཁྱོ༌ཞ༌གུན༌ ཆ༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ ཁྱོ༌ཞའ༌ ཀུས༌པ༌ ཅོ༌ཅུགས༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ ཆ༌ ཟ༌ནེ༌ ལག༌པ༌ སྟོང༌ང༌ ཆ༌ མི༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ཨིས༌ར༌ཨེལ༌མ༌ ཚང༌མའེ༌ ཁྱིམ༌ཚེས༌པ༌ ཨི༌ཇིབ༌མ༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཁང༌པའེ༌ ནང༌ང༌ དུག༌ཁན༌ནི༌ བུ༌མོ༌གུན༌ལ༌, ‘སེར༌ དང༌ མུལ༌ལི༌ ཅ༌ལག༌ ཡང༌ ཀོས༌ལག༌ གུན༌ ཏོང༌’ ཟེར༌གོས༌། ཏེ༌གུན༌ ཁྱོ༌ཞའེ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ལ༌ སྐོན༌ ཡ༌ ཏོག༌ ཡང༌ ཏེན༌ན༌ཟུག༌གི༌ ཁྱོ༌ཞའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ གྱུ༌ནོར༌ ཅོམས༌ཏེ༌ ཁྱེར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ཡང༌སྐྱར༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཁོང༌གུན༌ནི༌ ‘ཁྱོ༌རང༌ང༌ ཡ༌ཝ༌ མ༌ ཇལ༌ལ༌ ཨིན༌ནོག༌’ ཟེར༌ཏེ༌ ངའེ༌ཀ༌ ཨིད༌ཤེས༌ མ༌ཅོ༌ན༌ ཡ༌ ངའེ༌ ཟེར༌ཁན༌ལ༌ མ༌ཉན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཁོའ༌ ཏྲིས༌, “ཁྱོ༌རང༌ངི༌ ལག༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌བོ༌ ཅི༌ ཨིན༌?” མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ལུག༌རྫི༌ བེར༌ཀ༌ ཨིན༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “ཏེ༌བོ༌ སའེ༌ཀ༌ ཕངས༌ ཏོང༌།” ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ བེར༌ཀ༌ སའེ༌ཀ༌ ཕངས༌པ༌ ཏེ༌བོ༌ རུལ༌ཞིག༌ག༌ གྱུར༌ ཡང༌ ཁོ༌ རུལ༌ནེ༌ ཐག༌རིང༌ང༌ ཤོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “ལག༌པ༌ རྐྱངས༌ཏེ༌ རུལ༌བོ༌ རྔ༌མ༌ནེ༌ ཟུམ༌།” མོ༌ཟེས༌སི༌ ལག༌པ༌ རྐྱངས༌ཏེ༌ རུལ༌བོ༌ ཟུམས༌པ༌ ཏེ༌བོ༌ ཡང༌སྐྱར༌ ལུག༌རྫིའི༌ བེར༌ཀ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ཡ༌ཝའེ༌ མོལས༌, “འི༌ ལྟས༌པོ༌ སྟོན༌ ཏེ༌ནེ༌ ཡ༌ཝ༌ ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌ དང༌ ཡ༌ཀོབ༌ གུན༌ནི༌ དཀོན༌མཆོག༌ ཁྱོ༌རང༌ང༌ ཇལ༌ཁན༌བོ༌ ཁོང༌གུན༌ནི༌ ཨིད༌ཤེས༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ལག༌པ༌ ཁྱོ༌རང༌ངི༌ ཀོས༌སི༌ ནང༌ཀུག༌ག༌ ཏོང༌།” མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཀོས༌སི༌ ནང༌ང༌ ཏངས༌ཏེ༌ ཕི༌ལོག༌ག༌ ཕིང༌ང༌ཅིག༌ ཁོའེ༌ ལག༌པ༌ མ༌ རྩོག༌པོ༌ ཛེ༌ནད༌ ཡོངས༌ཏེ༌ ཁ༌ ཙོགས༌ ཀར༌པོ༌ གྱུར༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ཡ༌ཝའེ༌ མོལས༌, “ཏ༌ ལག༌པ༌བོ༌ ལོགས༌ཏེ༌ ཀོས༌སི༌ ནང༌ང༌ ཏོང༌།” མོ༌ཟེས༌སི༌ ལག༌པ༌ ལོགས༌ཏེ༌ ནང༌ཀུག༌ག༌ ཏངས༌ཏེ༌ ཕིང༌ང༌ཅིག༌ ཏེ༌བོ༌ ཁོའེ༌ ཟུགས༌པོའེ༌ ཡང༌ ཡན༌ལག༌གུན༌ ཙོགས༌ལ༌ ཁྲངས༌པོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཀལ༌ཏེས༌ ཁོང༌གུན༌ནི༌ ཁྱོ༌རང༌ངི༌ཀ༌ ཨིད༌ མ༌ཤེས༌ན༌ ཡ༌ ལྟས༌ ཏང༌པོ༌བོའ༌ ནང༌སྟག༌ མ༌ཏང༌ན༌, ཁོང༌གུན༌ནི༌ ལྟས༌ ཉིས༌པ༌བོའ༌ ཨིད༌ཤེས༌ ཅོ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ཁོང༌གུན༌ནི༌ འི༌ ལྟས༌ ཉིས༌ཀོའ༌ ཨིད༌ མ༌ཅོ༌ན༌ ཡ༌ ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌བོ༌ མ༌ཉན༌ན༌ ཏེ༌ནེ༌ ནཱའེལ༌ ལྩངས༌པོ༌ནེ༌ ཆུ༌ ཁུར༌ཏེ༌ ས༌ སྐམ༌པོའེ༌ཀ༌ ལུག༌། ཁྱོ༌རང༌ངི༌ ལྩངས༌པོའེ༌ ཆུ༌ ཁྱོང༌ཁན༌བོ༌ སའི༌ཀ༌ ཁྲག༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","མོ༌ཟེས༌སི༌ ཡ༌ཝ༌ ཟེརས༌, “ཡ༌ཝ༌ལེ༌, སྤེ༌ར༌ ཏང༌ཅེས༌སི༌ ནང༌ང༌ ངའ༌ ཁས༌པ༌ མེད༌, བུད༌ཁན༌ནི༌ ཏུས༌སི༌ ནང༌ང༌ ཡང༌ དག༌ས༌ ཉེ༌རང༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏང༌ ཟ༌ནེའང༌། ངའེ༌ ལྕའེ༌ ལྡམས༌ཏེ༌ ངའ༌ ཟེར༌གོ༌ཤེས༌པོ༌ ཟེར༌ ཉན༌ན༌མེད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “མིའ༌ ཁའ༌ སུའི༌ ཏང༌ཏེ༌ ཨིན༌ནོག༌? སུའི༌ མི༌ རྒུད༌ ཡ༌ ཧན༌གྲང༌ ཅོས༌? སུའི༌ ཁོའ༌ ཐོང༌ཅེས༌ལ༌ མིག༌ ཡ༌ ཞ༌ར༌ ཅོས༌? ཏེ༌བོ༌ ང༌, ཡ༌ཝའེ༌ ཅོས༌ཏེ༌ མ༌ནོག༌ག༌? ");
INSERT INTO lbj_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ཏ༌ སོང༌, ངའེ༌ ཁྱོ༌རང༌ང༌ སྤེ༌ར༌ ཏང༌ཅེས༌ལ༌ རོགས༌ ཅོ༌ཨིན༌ ཡང༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཟེར༌གོ༌ཤེས༌པོ༌ ལབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ཡང༌སྐྱར༌ ཞུ༌ཝ༌ ཕུལས༌, “ཡ༌ཝ༌ལེ༌ ཇུ༌ཇུ༌ ཡང༌ སུ༌ཞིག༌ ལམ༌ཅུག༌ག༌ ཛད༌དའང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ཏེ༌ནེ༌ ཡ༌ཝའ༌ མོ༌ཟེས༌སི༌ཀ༌ ཐུགས༌སྲོ༌ སྐྱོད༌ཏེ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ ལི༌ཝི༌པ༌ ཨ༌རོན༌ནི༌ སྐོར༌ལ༌ ཅི༌ སམ༌བ༌ ཨིན༌? ཁོའ༌ སྤེ༌ར༌ གྱལ༌ལ༌ ཏང༌ཉན༌ཁན༌བོ༌ ང༌ གྱུས༌ཡོད༌, ཡང༌ དག༌ས༌ ཁོ༌ ཁྱོ༌རང༌ང༌ ཐུག༌ག༌ལ༌ ཡོང༌དུག༌། ཁྱོ༌རང༌ ཐུགས༌ཏེ༌ ཁོ༌ མ༌ཐད༌པོ༌ ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ཁྱོ༌རང༌ངི༌ ཁོ༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏངས༌ཏེ༌ ཁོའ༌ ཟེར༌གོ༌ཤེས༌སི༌ སྤེ༌ར༌གུན༌ ཤོད༌། ངའེ༌ ཁྱོ༌ཞའ༌ སྤེ༌ར༌ ཏང༌ཅེས༌ལ༌ རོགས༌ ཅོས༌ཏེ༌ ཁྱོ༌ཞའ༌ ཅོ༌གོ༌ཤེས༌གུན༌ ལབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ཨ༌རོན༌ནི༌ ཁྱོ༌རང༌ངི༌ ཚབས༌ ཅོས༌ཏེ༌ མི༌གུན༌ལ༌ སྤེ༌ར༌ ཏང༌ཨིན༌། ཁོ༌ ཁྱོ༌རང༌ངི༌ ཁའ༌ ཡང༌ ཁྱོ༌རང༌ ཁོའེ༌ ཕིའ༌ དཀོན༌མཆོག༌ ཙོགས༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ཨིན༌ནའང༌ ལྟས༌གུན༌ སྟན༌ཅེས༌སི༌ ཕིའ༌ ཁྱོ༌རང༌ངི༌ ལུག༌རྫིའི༌ བེར༌ཀ༌བོ༌ ལག༌པའེ༌ ནང༌ང༌ ཁུར༌ཏེ༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ཏེ༌ནེ༌ མོ༌ཟེས༌ ལོགས༌ཏེ༌ ཡེ༌ཐོརོ༌ ཁོ༌རང༌ངི༌ ན༌མའེ༌ ཨ༌བ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “ཇུ༌ཇུ༌ ངའ༌ ང༌རང༌ངི༌ སྤུན༌གུན༌ སོན༌ཏེའ༌ དུག༌ག༌ མི༌དུག༌ ལྟའ༌ལ༌ ཨི༌ཇིབ༌བ༌ ལོགས༌ཏེ༌ ཆ༌ཅུག༌ག༌ ཛད༌།” ཡེ༌ཐོརོའེ༌ ལན༌ཏངས༌, “ཞི༌དེ༌ ཉམ༌པོ༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","མོ༌ཟེས༌ལ༌ མི༌དི༌ཡའན༌ནི༌ ནང༌ང༌ ཡ༌ཝའེ༌ མོལས༌, “ཨི༌ཇིབ༌བ༌ ལོགས༌ཏེ༌ སོང༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ སད༌ཨིན༌ སམ༌ཁན༌ ཚང༌མ༌ ཤི༌ཏེ༌ མེད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ཏེ༌བོའེ༌ཕིའ༌ མོ༌ཟེས༌སི༌, ཁོ༌རང༌ངི༌ ན༌མ༌ དང༌ བུ༌ཚ༌གུན༌ བུང༌བུའི༌ཀ༌ སྐྱོནས༌ ཡང༌ ལོགས༌ཏེ༌ ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ སོང༌། ཁོའེ༌ ལག༌པའེ༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ནི༌ བེར༌ཀ༌ ཁུར༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ ཨི༌ཇིབ༌བ༌ ལོགས༌ཏེ༌ ལེབ༌བ༌ཅིག༌, གྱལ༌པོའེ༌ དུན༌ལ༌ ལྟས༌ ཚང༌མ༌ ལྟོན༌ ཀ༌གུན༌ ཅོ༌ཅེས༌ལ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཝང༌ཆ༌ ཏངས༌ཏེ༌ ཨིན༌། ཨིན༌ནའང༌ ཁོའེ༌ མི༌གུན༌ ཆ༌ མི༌ཅུག༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁོའེ༌ སྙིང༌སྐྱོང༌པོ༌ གྱུར༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ཏེ༌ནེ༌ ཁྱོ༌རང༌ངི༌ ཁོའ༌ ཟེར༌གོས༌, ‘ཡ༌ཝའེ༌ འི༌ཟུག༌ མོལས༌, ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ངའེ༌ གོ༌མ༌ སྐྱེ༌ཁན༌ནི༌ བུ༌ཚ༌བོ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ངའེ༌ ཁྱོ༌རང༌ང༌ ཟེར༌པིན༌, “ངའ༌ ཅོལ༌ཅེས༌ལ༌ ངའེ༌ བུ༌ཚ༌ ཆ༌ཅུག༌།” ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ཁོ༌ ཆ༌ མ༌ཅུགས༌ པ༌སང༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ གོ༌མའེ༌ བུ༌ཚ༌བོ༌ སད༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ཨི༌ཇིབ༌བ༌ ཆ༌ ཟ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཁོའེ༌ ནང༌ཚངས༌ ཚན༌ལ༌ དུགས༌ཏེ༌ ཡོད༌སའེ༌ ནས༌སའེ༌ཀ༌, ཡ༌ཝའ༌ མོ༌ཟེས༌སི༌ཀ༌ ཐུགས༌སྲོ༌ སྐྱོད༌ཏེ༌ ཡ༌ཝའེ༌ ཁོ༌ སད༌ཅེས༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ན༌མ༌ ཟི༌པོ༌རའེ༌ རྡོའ༌ སྲ༌མོ༌ ནོན༌པོ༌ཞིག༌ ཉམ༌པོ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའ༌ སུན༌ནད༌ ཅོས༌ཏེ༌ ཏེ༌ ཅད༌ཁན༌ནི༌ པགས༌པ༌ མོ༌ཟེས༌སི༌ རྐང༌པ༌ ཐུག༌ཅུགས༌ཏེ༌ ཟེརས༌, “འི༌ ཁྲག༌ཕོ༌ཁན༌བོ༌ གྱུད༌ཏེ༌ ཁྱོ༌རང༌ ཡ༌ཝའེ༌ ཐུག༌སྲོ༌ ནེ༌ ཐར༌ཏེ༌ ཨིན༌ནོག༌། ” ");
INSERT INTO lbj_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ཏེ༌ནེ༌ མོ༌ཟེས༌ སོན༌ཏེའ༌ བོར༌ཏེ༌ ཡ༌ཝ༌ སྐྱོདས༌། ༼བུ༌མོའེ༌ “ཁྲག༌ཕོ༌ཁན༌བོ༌ གྱུད༌ཏེ༌ ཁྱོ༌རང༌ ངའེ༌ ཞིད༌མད༌ ཨིན༌” ཟེར༌ཅེས༌པོ༌ ནི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ སུན༌ནད༌ ཅོ༌ཁན༌བོའེ༌ སྐོར༌ལ༌ ཨིན༌ནོག༌།༽ ");
INSERT INTO lbj_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ཡ༌ཝའེ༌ ཨ༌རོན༌ལ༌ མོལས༌, “མོ༌ཟེས༌ལ༌ ཐུག༌ག༌ལ༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ སོང༌།” ཨ༌རོན༌ སོང༌ ཡང༌ དཀོན༌མཆོག༌གི༌ རིའི༌ཀ༌ མོ༌ཟེས༌ ཉམ༌པོ༌ ཐུག༌ ཡང༌ ཁོའ༌ པུག༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ཁོ༌ ཨི༌ཇིབ༌བ༌ ཀལ༌ལ༌ ཛད༌ཁན༌ནི༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌ ཚང༌མ༌ དང༌ ཁོའ༌ ཅོ༌ཅེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ནི༌ ལྟས༌ ཚང༌མའེ༌ སྐོར༌ ཨ༌རོན༌ལ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌ ཚང༌མ༌ བོད༌ཏེ༌ ཛོམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ཨ༌རོན༌ནི༌ ཁོང༌ ཚང༌མ༌ལ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ ཤད༌ད༌ ཛད༌ཁན༌གུན༌ ཤདས༌ ཡང༌ ཁོའེ༌ ཁོང༌གུན༌ནི༌ དུན༌ལ༌ ལྟས༌གུན༌ སྟནས༌། ");
INSERT INTO lbj_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ནི༌ རྡུག༌ངལ༌གུན༌ ཟིགས༌ཏེ༌ ཁོང༌ངི༌ སྐོར༌ལ༌ ཚེར༌ཁ༌ ཛད༌ཁན༌བོ༌ ཚོར༌ཏེ༌ ཨིད༌ཤེས༌ ཅོས༌པ༌ ཁོང༌གུན༌ནི༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ གོ༌ སྒུས༌ ཡང༌ ཡ༌ཝའ༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ཏེ༌ སྟིང༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “ཡ༌ཝ༌, ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌གི༌ འི༌ཟུག༌ མོལས༌, ‘རི༌སྟོང༌ངི༌ ནང༌ང༌ ངའ༌ རྩི༌ཝ༌ ཅོས༌ཏེ༌ གའ༌སྟོན༌ རྩི༌ཅེས༌ལ༌ ངའེ༌ མི༌གུན༌ ཆ༌ཅུག༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","གྱལ༌པོའེ༌ ཟེརས༌, “ཡ༌ཝ༌ སུ༌ ཨིན༌ནོག༌, ངའེ༌ ཁོའེ༌ ཁའ༌ཉན༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཅིའ༌ ཆ༌ཅུག༌ཨིན༌? ངའེ༌ ཡ༌ཝ༌ ཤེས༌ས༌མེད༌ ཡང༌ ངའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཆ༌ མི༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཨིབ༌རི༌པ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ང༌ཞའེ༌ ཇལ༌, ཏ༌ ཡ༌ཝ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌ལ༌ ང༌ཞ༌གུན༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ ཞག༌ སུམ༌མི༌ བེས༌ལ༌ ཆ༌ཅུག༌། ཏེ༌ མན༌ན༌ ཁོང༌ངི༌ ང༌ཞ༌གུན༌ལ༌ ནད༌ རྩོག༌པོ༌ ཡ༌ ར༌འི༌ ཉམ༌པོ༌ ཤི༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ཨིན༌ནའང༌ གྱལ༌པོའེ༌ ཟེརས༌, “མོ༌ཟེས༌ དང༌ ཨ༌རོན༌, ཅིའ༌ མི༌གུན༌ལ༌ ཁོ༌རང༌གུན༌ནི༌ ལས༌ ཅོ༌ཅུག༌ག༌ མེད༌? རང༌ངི༌ ལས༌ ཅོའ༌ལ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ལྟོས༌, འི༌ ས༌ཆའེ༌ ནང༌ང༌ ང༌ཞའེ༌སང༌ མང༌ང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ མི༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ཁོང༌གུན༌ལ༌ ལས༌ ཅོ༌ཅེས༌ནེ༌ སྒག༌ ཉིན༌རག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ཏེན༌ན༌ ཞག༌ག༌ གྱལ༌པོའེ༌ ཨི༌ཇིབ༌པ༌ ཚེ༌ཡོག༌ སྲུལ༌ཁན༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ལས༌སྤོན༌ གུན༌ལ༌ བཀའ༌ ཏངས༌, ");
INSERT INTO lbj_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“སྔུན༌ ཙོགས༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ པག༌བུ༌ ཅོ༌ཅེས༌ལ༌ ཕུག༌མ༌ མ༌ཏང༌། ཁོང༌རང༌གུན༌ལ༌ ཕུག༌མ༌ ཙལ༌ཏེ༌ པག༌བུ༌ ཅོ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ པག༌བུ༌ སྔུན༌ ཙོགས༌ དྲན༌དྲ༌ ཡོང༌གོས༌, པག༌བུའི༌ རྩི༌རུག༌ ཉུ༌ངུན༌ མ༌ཅོ༌། ཁོང༌གུན༌ལ༌ ལས༌ ཅོ༌མ༌ལམ༌ པ༌སང༌ ཁོང༌གུན༌ནི༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ ‘དཀོན༌མཆོག༌ག༌ ཆོད༌པ༌ ཕུལ༌ལ༌ལ༌ ང༌ཞའ༌ ཆ༌ཅུག༌’ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ཟུན༌ཇན༌ སྤེ༌ར༌གུན༌ལ༌ ནང༌སྟག༌ ཏང༌ལོང༌ མི༌ཡོང༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌གུན༌ལ༌ ལས༌ མ༌སྲན༌ཏྲེ༌ ཅོ༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ཏེ༌ནེ༌ ཚེ༌ཡོག༌ སྲུལ༌ཁན༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ལས༌སྤོན༌ གུན༌ ཕི༌ལོག༌ག༌ སོང༌ཏེ༌ མི༌གུན༌ལ༌ ཟེརས༌, “གྱལ༌པོའེ༌ མོལ༌ལ༌རག༌, ‘ངའེ༌ ཏན༌ནེ༌ པར༌ལ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཕུག༌མ༌ མི༌ཏང༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","སོང༌ ཡང༌ ཀ༌ནེ༌ ཐོབ༌ནའང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕུག༌མ༌ ཙལ༌ཏེ༌ སྔུན༌ ཙོགས༌ལ༌ དྲན༌དྲ༌ པག༌བུ༌ ཅོས༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ ནང༌ང༌ ཡན༌ཏེ༌ ཕུག༌མ༌ ཙལ༌ལ༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ཨི༌ཇིབ༌པ༌ ཚེ༌ཡོག༌ སྲུལ༌ཁན༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ཀ༌ ཝང༌ ཀོལ༌ཏེ༌ ཟེརས༌, “ཕུག༌མ༌ ཏང༌ ཟ༌ནེ༌ ཞག༌ག༌ པག༌བུ༌ ཅོ༌ཁན༌ དྲན༌དྲ༌ དག༌སའང༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ཡང༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌ ལས༌སྤོན༌ལ༌ སྐོས༌ཁན༌ གུན༌ལ༌ རྡུངས༌ཏེ༌ ཏྲིའད༌པིན༌, “སྔུན༌ ཙོགས༌ལ༌ དའང༌ དང༌ དི༌རིང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ པག༌བུ༌ དྲན༌དྲ༌ ཅིའ༌ མ༌ཅོའ༌ ཨིན༌ནོག༌?” ");
INSERT INTO lbj_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ལས༌སྤོན༌གུན༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཞུ༌ཝ༌ ཕུལས༌, “ཉེ༌རང༌ངི༌ ཡོག༌པོ༌གུན༌ལ༌ འི༌ཟུག༌ ནགས༌ ཅིའ༌ སྟན༌ན༌ ཛད༌དད༌? ");
INSERT INTO lbj_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ང༌ཞ༌གུན༌ལ༌ ཕུག༌མ༌ ཏང༌ང༌ མི༌དུག༌ ཨིན༌ནའང༌ ཚེ༌ཡོག༌ སྲུལ༌ཁན༌གུན༌ནི༌ ‘པག༌བུ༌ དྲན༌དྲ༌ ཅོས༌’ ཟེར༌ཏེ༌ ང༌ཞ༌གུན༌ལ༌ རྡུང༌དུག༌། ཨིན༌ནའང༌ ཏེ༌བོ༌ ང༌ཞའེ༌ སྐྱོན༌ མན༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ནི༌ སྐྱོན༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","གྱལ༌པོའེ༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ ལས༌མི༌ལམ༌ གྱུར༌ཏེ༌ ལས༌ ཅོ༌ཉིན༌མེད༌པ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ‘ང༌ཞའ༌ དཀོན༌མཆོག༌ག༌ ཆོད༌པ༌ ཕུལ༌ལ༌ ཆ༌ཅུག༌’ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ཏ༌ ལོགས༌ཏེ༌ ལས༌ ཅོའ༌ལ༌ སོང༌། ཁྱོ༌ཞ༌གུན༌ལ༌ ཕུག༌མ༌ མི༌ཏང༌ ཨིན༌ནའང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ པག༌བུ༌ དྲན༌དྲ༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“པག༌བུའི༌ ཀྲངས༌ཀ༌ དྲན༌དྲ༌ ཡོང༌གོས༌” ཟེར༌ཏེ༌ བཀའ༌ ཏང༌ང༌ཅིག༌ ཨིས༌ར༌ཨེལ༌པ༌ ལས༌སྤོན༌གུན༌ལ༌ ནས༌ལུག༌ ཀགས༌པོ༌ གྱུར༌ཅེས༌པོ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ཡང༌ ཁོང༌གུན༌ གྱལ༌པོའེ༌ ཁར༌ནེ༌ བིང༌ཏེ༌ ཆ༌ ཟ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ ཁོང༌གུན༌ལ༌ ཐུག༌ག༌ སྲུངས༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ལས༌སྤོན༌གུན༌ནི༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ གྱལ༌པོ༌ དང༌ ཁོང༌ངི༌ སྤོན༌བོ༌གུན༌ལ༌ ང༌ཞའེ༌ཀ༌ སྲོ༌ ཡོང༌ཅུགས༌པ༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌ ཁྲིམས༌ཅད༌ དང༌ ཆད༌པ༌ སལ༌ཤིག༌། ཁྱོ༌ཞའེ༌ ཁོང༌གུན༌ལ༌ ང༌ཞའ༌ སད༌ཅེས༌ལ༌ ཉད༌ ཐོབ༌ཅུགས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ཏེ༌ནེ༌ མོ༌ཟེས༌ སོང༌ཏེ༌ ཡང༌སྐྱར༌ ཡ༌ཝ༌ མོས༌ལམ༌ ཞུས༌, “ཡ༌ཝ༌, ཉེ༌རང༌ངི༌ ཅིའ༌ རང༌ངི༌ མི༌གུན༌ལ༌ འི༌ ཙོགས༌སི༌ ནགས༌ སྟན༌ན༌ ཛད༌དད༌? ཅིའ༌ ཉེ༌རང༌ངི༌ ང༌ ཀལ༌ལ༌ ཛད༌པིན༌? ");
INSERT INTO lbj_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ཉེ༌རང༌ངི༌ མོལ༌ཁན༌གུན༌ གྱལ༌པོའ༌ ཟེར༌པ༌ནེ༌ ཕར༌ལ༌ ཁོའེ༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ལ༌ མང༌ང༌ ནགས༌ སྟནས༌ ཡང༌ ཉེ༌རང༌ངི༌ ཁོང༌གུན༌ ཐར༌ཅུག༌ཅེས༌ལ༌ ཅའང༌ ཛད༌ད༌ མི༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཏ༌ ངའེ༌ གྱལ༌པོའ༌ ཅོ༌ཅེས༌ཅན༌གུན༌ ཁྱོ༌རང༌ངི༌ ཐོང༌ཨིན༌། ངའེ༌ ཤེད༌ དང༌ ཁྱུད༌དི༌ ཞས༌ཏེ༌ ཁོའེ༌ ཁོང༌གུན༌ ཆ༌ཅུག༌ཨིན༌། ཏེན༌ན༌ ཁྱུད༌ དང༌ ཤེད༌པོའེ༌ ཁོའེ༌ ཁོང༌གུན༌ འི༌ ས༌ཀྱད༌ནེ༌ ཕིངས༌ཏེ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","དཀོན༌མཆོག༌གི༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ང༌ ནི༌ ཡ༌ཝ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ང༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌ དང༌ ཡ༌ཀོབ༌ གུན༌ལ༌ དཀོན༌མཆོག༌ ཀུན༌ཝང༌ངི༌ ཚུལ༌ལ༌ སྔོན༌ཅུགས༌ཏེ༌ ཨིན༌། ཨིན༌ནའང༌ ངའེ༌ ཁོང༌གུན༌ལ༌ ང༌ ‘ཡ༌ཝའེ༌’ མིང༌ངི༌ ནང༌ང༌ སྔོན༌ མ༌ཅུགས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ངའེ༌ ཀེ༌ནན༌ནི༌ ས༌ཆ༌ ཁོང༌གུན༌ལ༌ ཏང༌ཅེས༌སི༌ ཆད༌དོན༌བོ༌ ཅོས༌པིན༌ ཀ༌རུ༌ ཁོང༌གུན༌ ཞན༌ཡུལ༌ལི༌ མི༌ ཚུལ༌ལ༌ དུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཚེ༌ཡོག༌, ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ རྡུག༌ངལ༌ལི༌ སྐད༌གུན༌ནའང༌ ཚོར༌ ཡང༌ ངའ༌ ངའེ༌ ཆད༌དོན༌ ཅོ༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ཡོངས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ཏེ༌བོའེ༌ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེར༌, ‘ང༌ ཡ༌ཝ༌ ཨིན༌, ཡང༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ རྡུག༌ངལ༌ལི༌ ཡོག༌ནེ༌ ཕིངས༌ཏེ༌ ཁོང༌ངི༌ ཚེ༌ཡོག༌ནེ༌ ཐར༌ཅུག༌ཨིན༌། ངའེ༌ ཤེད༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཆད༌པ༌ སྲན༌ཏྲེ༌ ཏང༌ཅེས༌ གྱུད༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ སྐྱོབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ཁྱོ༌ཞ༌གུན༌ ང༌རང༌ངི༌ མི༌ ཡང༌ ང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌ གྱུར༌ཨིན༌། ཏེ༌ནེ༌ ངའ༌, ཁྱོ༌ཞའ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ སྟན༌ཁན༌ནི༌ ནགས༌བར༌དོ༌ནེ༌ ཐར༌ཅུག༌ག༌ ཛད༌ཁན༌ནི༌ ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ ཨིན༌ཁན༌ ཁྱོ༌ཞའ༌ ཧ༌གོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཏེ༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱེར༌ཨིན༌ ཀ༌བོ༌ ངའེ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌ དང༌ ཡ༌ཀོབ༌བ༌ ཏང༌ཅེས༌སི༌ ནའ༌ ཁུར༌པིན༌། ཏེ༌བོ༌ ཏུས༌གྱུན༌ནི༌ ཕིའ༌ ཁྱོ༌ཞའེ༌ གྱུ༌ནོར༌ གྱུར༌ཨིན༌, ང༌ ཡ༌ཝ༌ ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","མོ༌ཟེས༌སི༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཤདས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ མ༌ཉནས༌ ཅིའ༌ཟེར༌ན༌ ནགས༌ སྲན༌ཏྲེ༌ སྟན༌ཅེས༌པོའེ༌ ཁོང༌གུན༌ནི༌ སེམ༌སྟོབས༌ ཆགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཁོའེ༌ ཡུལ༌ནེ༌ ཆ༌ཅུག༌ ཟེར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ཡ༌ཝའ༌ ཟེརས༌, “ང༌རང༌ངི༌ མི༌གུན༌ནི༌ ངའེ༌ ཁའ༌ ཉན༌ན༌ མི༌དུག༌། ཏེ༌ནེ༌ ང༌ སྤེ༌ར༌ ཏང༌ཁན༌ གྱལ༌ལ༌ མན༌ པ༌སང༌ གྱལ༌པོའེ༌ ངའེ༌ ཁའ༌ ཅིའ༌ ཉན༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ བཀའ༌ སལ༌ཏེ༌ མོལས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ དང༌ གྱལ༌པོའ༌ ངའེ༌ ཁྱོ༌ཞའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིང༌ཏེ༌ ཁྱེར༌ཅེས༌སི༌ ཁག༌ གལ༌ཁན༌བོ༌ ཤོད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","འི༌གུན༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ ཨིན༌ནོག༌: ཨིས༌ར༌ཨེལ༌ལི༌ གོ༌བུ༌ བུ༌ཚ༌ རུ༌བེན༌ ནི༌ བུ༌ཚ༌གུན༌ ཧ༌ནོག༌, པ༌ལུ༌, ཧེཟ༌རོན༌ དང༌ ཀར༌མི༌ གུན༌ ཨིན༌། ཁོང༌གུན༌ནི༌ པུར༌གྱུད༌ རུ༌བེན༌ནི༌ མི༌སྡེ༌གུན༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","སི༌མི༌འོན༌ནི༌ བུ༌ཚ༌གུན༌ ཡེ༌མའུལ༌, ཡ༌མིན༌, ཨོ༌ཧད༌, ཡ༌ཀིན༌, ཟོ༌ཧར༌ དང༌ ཤོལ༌, ཡང༌ ཤོལ༌ལི༌ ཨ༌མ༌ ཀེ༌ནན༌མ༌ ཨིན༌པིན༌། ཁོང༌གུན༌ནི༌ པུར༌གྱུད༌ སི༌མི༌འོན༌ནི༌ མི༌སྡེ༌གུན༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ཐོ༌ ཅོས༌ཏེ༌ ཡོད༌ཁན༌ ནང༌ཞིན༌ ལི༌ཝི༌ བུ༌ཚ༌གུན༌ གེར༌ཤོན༌, ཀོ༌ཧད༌ དང༌ མི༌ར༌རི༌ གུན༌ ཨིན༌པིན༌། ལི༌ཝི༌ ལོ༌ 137 ཚག༌པ༌ སོན༌ཏེའ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","གེར༌ཤོན༌ནི༌ བུ༌ཚ༌གུན༌ ལིབ༌ནི༌ དང༌ ཤི༌མེའི༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ འིན༌ན༌ མིང༌ ཡོད༌ཁན༌ནི༌ མི༌སྡེ༌གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ཀོ༌ཧད༌དི༌ བུ༌ཚ༌གུན༌ ཨམ༌རམ༌, ཨིཟ༌ཧར༌, ཧེབ༌རོན༌ དང༌ འུ༌ཟེལ༌ གུན༌ ཨིན༌ནོག༌། ཀོ༌ཧད༌ ལོ༌ 133 ཚག༌པ༌ སོན༌ཏེའ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","མི༌ར༌རི༌ བུ༌ཚ༌གུན༌ མ༌ཧིལ༌ དང༌ མུ༌ཤི༌ ཨིན༌ནོག༌། ཐོ༌ ནང༌ཞིན༌ ཁོང༌གུན༌ ལི༌ཝི༌ མི༌སྡེ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ཨམ༌རམ༌མི༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ སྲིང༌མོ༌ ཡོ༌ཤེ༌བེད༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌ ཡང༌ ཏེ༌ བུ༌མོའ༌ ཨ༌རོན༌ དང༌ མོ༌ཟེས༌ བུ༌ཚ༌གུན༌ ཇོར༌། ཨམ༌རམ༌ ལོ༌ 137 ཚག༌པ༌ སོན༌ཏེའ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ཨིཟ༌ཧར༌རི༌ བུ༌ཚ༌གུན༌ ཀོ༌རཧ༌, ནི༌ཕེག༌ དང༌ ཟིཀ༌རི༌ གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","འུ༌ཟེལ༌ལི༌ བུ༌ཚ༌གུན༌ མི༌ཤེལ༌, ཨེལ༌ཟ༌ཕན༌ དང༌ སིཐ༌རི༌ གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ཨ༌རོན༌ ནི༌ ཨམ༌མི༌ན༌དབ༌བི༌ བུ༌མོ༌ ན༌ཧ༌ཤོན༌ནི༌ སྲིང༌མོ༌ ཨིལ༌ཤི༌བ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌། ཁོའ༌ བུ༌ཚ༌ ཞི༌ སྐྱེས༌, ཁོང༌གུན༌ ན༌དབ༌, ཨ༌བི༌ཧུ༌, ཨེ༌ལི༌འ༌ཟར༌ དང༌ ཨི༌ཐ༌མར༌ གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ཀོ༌རཧའེ༌ བུ༌ཚ༌གུན༌ ཨ༌སིར༌, ཨེལ༌ཀ༌ནཧ༌ དང༌ ཨ༌བི༌ཨ༌སབ༌ གུན༌ ཨིན༌། ཁོང༌གུན༌ནི༌ པུར༌གྱུད༌ ནི༌ ཀོ༌རཧའེ༌ མི༌སྡེ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ཨ༌རོན༌ནི༌ བུ༌ཚ༌ ཨེ༌ལི༌འ༌ཟར༌རི༌ པུ༌ཀྲེལ༌ལི༌ བུ༌མོ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌ ཡང༌ ཁོའ༌ བུ༌ཚ༌ ཕི༌ནི༌ཧས༌ སྐྱེས༌། མི༌སྡེ༌ ནང༌ཞིན༌ ཁོང༌གུན༌ ལི༌ཝི༌ ནང༌ཚངས༌གུན༌ནི༌ གོ༌སྐྱོང༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ཁོང༌གུན༌ ཏེན༌ན༌ ཨ༌རོན༌ དང༌ མོ༌ཟེས༌ ཨིན༌ནོག༌ ཀ༌གུན༌ལ༌ ཡ༌ཝའེ༌ མོལས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཁོང༌གུན༌ནི༌ སྡེ༌ ནང༌ཞིན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱེར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ཁོང༌གུན༌, ཨི༌ཇིབ༌བི༌ གྱལ༌པོའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱེར༌ཅེས༌སི༌ སྐོར༌ལ༌ ཟེར༌ཁན༌ནི༌ ཏེན༌ན༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ ཨི༌ཇིབ༌བི༌ ས༌ཆའེ༌ ནང༌ང༌ ཞལ༌ཏ༌ སལ༌ ཟ༌ནེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ཁོང༌ངི༌ ཁོའ༌ མོལས༌, “ང༌ ཡ༌ཝ༌ ཨིན༌། ངའེ༌ ཁྱོ༌རང༌ང༌ ཟེར༌ཁན༌ ཚང༌མ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའ༌ ཤོད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ཡ༌ཝའ༌ ཟེརས༌, “ངའ༌ ཏེ༌བོ༌ ཅོ༌ཉན༌ཅེས༌ མེ༌རག༌། ང༌ སྤེ༌ར༌ གྱལ༌ལ༌ ཏང༌ མ༌ཉན༌ཁན༌ ཞིག༌ག༌ གྱལ༌པོའེ༌ ཅིའ༌ ཉན༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ངའེ༌ ཁྱོ༌རང༌ གྱལ༌པོའེ༌ ཕིའ༌ དཀོན༌མཆོག༌ ཙོགས༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨ༌རོན༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ ལུང༌སྟོན༌པ༌ ཙོགས༌ ཅོས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ངའེ༌ ཁྱོ༌རང༌ང༌ བཀའ༌ ཏང༌ཁན༌ ཚང༌མ༌ ཨ༌རོན༌ལ༌ ཤོད༌ ཡང༌ ཁོའེ༌ གྱལ༌པོའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཁོའེ༌ ཡུལ༌ནེ༌ བིང༌ཏེ༌ ཆ༌ཅུག༌ཅེས༌ལ༌ ཟེར༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ཨིན༌ནའང༌ ངའེ༌ གྱལ༌པོའེ༌ སྙིང༌ སྐྱོང༌པོ༌ གྱུར༌ཅུག༌ཨིན༌ ཡང༌ ངའེ༌ ཨི༌ཇིབ༌བི༌ ས༌ཆའེ༌ ནང༌ང༌ ཧ༌ལས༌ཤེས༌སི༌ སྟགས༌ དང༌ ལྟས༌ མང༌པོ༌ སྟན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ཏེ༌ནེའང༌ གྱལ༌པོའེ༌ ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌བོ༌ མི༌ཉན༌། ཏེ༌ནེ༌ ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ཀ༌ ཀྲག༌པོ༌ ཆད༌པ༌གུན༌ གྱུད༌ཏེ༌ ང༌རང༌ངི༌ མི༌གུན༌ ཁོང༌གུན༌ནི༌ སྡེ༌ ནང༌ཞིན༌ ཨི༌ཇིབ༌བི༌ ས༌ཆའེ༌ ནང༌ནེ༌ ཕིང༌ཏེ༌ ཁྱེར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ངའེ༌ ང༌རང༌ངི༌ སྟོབས༌ཤུགས༌ཅན༌ནི༌ ལག༌པ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ རྐྱངས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཕིངས༌ཏེ༌ ཁྱེར༌ར༌ཅིག༌ ང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ ཨིན༌ཁན༌བོ༌ ཁོང༌གུན༌ནི༌ ཧ༌གོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ཏེ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","གྱལ༌པོའ༌ ཏེ༌གུན༌ ཟེར༌ ཟ༌ནེ༌ མོ༌ཟེས༌ལ༌ ལོ༌ 80 ཡང༌ ཨ༌རོན༌ལ༌ ལོ༌ 83 ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“གྱལ༌པོའེ༌ ལྟས༌ ལྟོན༌ ཟེར༌ར༌ཅིག༌, ཨ༌རོན༌ལ༌ ཟེར༌, ‘ཁྱོ༌རང༌ངི༌ བེར༌ཀ༌ ཁུར༌ཏེ༌ གྱལ༌པོའེ༌ དུན༌ལ༌ ཕོང༌ ཡང༌ ཏེ༌བོ༌ རུལ༌ལ༌ གྱུར༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ཏེ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཅོས༌། ཨ༌རོན༌ནི༌ ཁོ༌རང༌ངི༌ བེར༌ཀ༌ གྱལ༌པོ༌ དང༌ ཁོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ དུན༌ལ༌ ཕངས༌པ༌ རུལ༌ལ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ མི༌ ཁས༌པ༌གུན༌ དང༌ སེམ༌ཉིད༌ལ༌ བོད༌ཁན༌གུན༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཏེ༌ ཨི༌ཇིབ༌པ༌ ཆོས༌ངན༌ ཅོ༌ཁན༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ སང༌ཝའེ༌ ཁྱུད༌ གྱུད༌ཏེ༌ ཏེན༌ན༌ ཙོགས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ཁོང༌ རེ༌རེ༌ བེར༌ཀ༌གུན༌ ཕངས༌པ༌ རུལ༌ལ༌ གྱུར༌། ཨིན༌ནའང༌ ཨ༌རོན༌ནི༌ བེར༌ཀ༌ རུལ༌ གྱུར༌ཁན༌བོའེ༌ ཁོང༌གུན༌ནི༌ བེར༌ཀ༌ རུལ༌ གྱུར༌ཁན༌གུན༌ ཟོས༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","གྱལ༌པོའེ༌ སྙིང༌ ཏ༌རུང༌ངའང༌ སྐྱོང༌པོ༌ ལུས༌ ཡང༌ ཁོའེ༌ ཁོང༌གུན༌ནི༌ ཟེར༌ཁན༌གུན༌ལ༌ མ༌ཉནས༌ ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “གྱལ༌པོའེ༌ སྙིང༌ སྐྱོང༌པོ༌ ལུས༌ཏེ༌ ཁོའེ༌ ངའེ༌ མི༌གུན༌ ཆ༌ཅུག༌ག༌ མི༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ང༌མོ༌ གྱལ༌པོ༌ ཐུར༌ལ༌ ལྩངས༌པོའ༌ ཆའ༌ ཟ༌ནེ༌ ཁོའ༌ ཐུག༌ཅེས༌ལ༌ ཁྱོ༌རང༌ ནཱའེལ༌ ལྩངས༌པོའེ༌ ཐའ༌མ༌ ལངས༌ཏེ༌ དུག༌ ཡང༌ རུལ༌ གྱུར༌ཁན༌ནི༌ བེར༌ཀ༌ ཁུར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ཁོའ༌ ཟེར༌ ‘ཡ༌ཝ༌, ཨིབ༌རི༌པའེ༌ དཀོན༌མཆོག༌གི༌ ང༌ ཁྱོ༌རང༌ང༌ འི༌བོ༌ ཟེར༌ར༌ལ༌ ལམ༌ཅུགས༌, “རི༌སྟོང༌ངི༌ ནང༌ང༌ ངའ༌ ཅོལ༌ཅེས༌ལ༌ ངའེ༌ མི༌གུན༌ ཆ༌ཅུག༌།” དག༌ས༌ ཚག༌པ༌, ཁྱོ༌རང༌ངི༌ ཁོང༌ངི༌ མོལ༌ཁན༌བོའ༌ མ༌ཉན༌ན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ཡ༌ཝའེ༌ འི༌ཟུག༌ མོལས༌, “ངའེ༌ ཁྱོ༌རང༌ང༌ ང༌ ཡ༌ཝ༌ ཨིན༌ཁན༌བོ༌ སྟན༌ཨིན༌།” ལྟོས༌, ངའེ༌ ལག༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ བེར༌ཀ༌ ངའེ༌ ནཱའེལ༌ལི༌ ཆུའ༌ གྱབ༌ཨིན༌ ཡང༌ ལྩངས༌པོའེ༌ ཆུ༌ ཁྲག༌ག༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཉ༌གུན༌ ཤི༌ཨིན༌ ཡང༌ ལྩངས༌པོའེ༌ ནང༌ནེ༌ ཏྲི༌མ༌ རྩོག༌པོ༌ ཡོང༌ཨིན༌། ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ནཱའེལ༌ལི༌ ཆུ༌ ཐུང༌ མི༌ཉན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨ༌རོན༌ལ༌ ཟེར༌, ‘ཁྱོ༌རང༌ངི༌ བེར༌ཀ༌ ཁུར༌ཏེ༌ རང༌ངི༌ ལག༌པ༌ ཨི༌ཇིབ༌བི༌ ཆུ༌གུན༌ ཡང༌ན༌ ལྩངས༌པོ༌, ཡུ༌ར༌, ཟིང༌, ཡང༌ ཆུ༌ སགས༌ཏེ༌ བོར༌ས༌ ཚང༌མའེ༌ཀ༌ སྐྱོང༌’ ཡང༌ ཏེ༌ ཆུ༌ ཚང༌མ༌ ཁྲག༌ག༌ གྱུར༌ཨིན༌། ཨི༌ཇིབ༌བི༌ ཆུ༌ ཚང༌མ༌ ཁྲག༌ག༌ གྱུར༌ཨིན༌, ཤིང༌ དང༌ རྡོའེ༌ ཆུ༌སྣོད༌གུན༌ནི༌ ཆུ༌ གུན༌ནའང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཅོས༌། གྱལ༌པོ༌ དང༌ ཁོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ དུན༌ལ༌ ཨ༌རོན༌ནི༌ ཁོ༌རང༌ངི༌ བེར༌ཀ༌ སྟགས༌ཏེ༌ ནཱའེལ༌ ལྩངས༌པོའ༌ གྱབས༌པ༌ ལྩངས༌པོའེ༌ ཆུ༌ གང༌པོ༌ ཁྲག༌ག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ལྩངས༌པོའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཉ༌གུན༌ ཤི༌ ཡང༌ ཆུའི༌ ནང༌ནེ༌ ཏྲི༌མ༌ རྩོག༌པོ༌ ཡོངས༌ ཡང༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཏེ༌ ཆུ༌གུན༌ ཐུང༌ མ༌ཉན༌། ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོའེ༌ ནང༌ང༌ ཁྲག༌ གྱུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ཨིན༌ནའང༌ ཨི༌ཇིབ༌པ༌ ཆོས༌ངན༌ ཅོ༌ཁན༌གུན༌ནིའང༌ ཁོང༌རང༌གུན༌ནི༌ སང༌ཝའེ༌ ཁྱུད༌ གྱུད༌ཏེ༌ ཆུ༌གུན༌ ཁྲག༌ག༌ གྱུར༌ཅུགས༌, ཏེ༌བོའེ༌ཕིའ༌ གྱལ༌པོའེ༌ སྙིང༌ ཏ༌རུང༌ངའང༌ སྐྱོང༌པོ༌ ལུས༌ཏེ༌ ཁོའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཟེར༌ཁན༌བོའ༌ མ༌ཉནས༌ ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","གྱལ༌པོ༌ ཁོ༌རང༌ངི༌ ཁར༌ལ༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ འི༌ ཚང༌མའེ༌ཀ༌ སྣང༌ང༌ མ༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ནཱའེལ༌ལི༌ ཆུ༌ ཐུང༌ མ༌ཉན༌ པ༌སང༌ ཨི༌ཇིབ༌པ༌ ཚང༌མའེ༌ ལྩངས༌པོའེ༌ ཉེ༌ཁོར༌རི༌ ས༌ཀྱད༌གུན༌ བྲུས༌ཏེ༌ ཐུང༌ཅེས༌སི༌ ཆུ༌ ཙལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ཡ༌ཝའེ༌ ནཱའེལ༌ལི༌ ཆུ༌ ཁྲག༌ག༌ གྱུར༌ཅུག༌ག༌ ཛད༌ཏེ༌ ཞག༌མ༌ རྡུན༌ བུད༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ ཡང༌ ཁོའ༌ ཟེར༌, ‘ཡ༌ཝའེ༌ འི༌ཟུག༌ མོལས༌, ངའ༌ ཅོལ༌ཅེས༌ལ༌ ངའེ༌ མི༌གུན༌ ཆ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ཁོང༌གུན༌ ཆ༌ མ༌ཅུག༌ན༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ ས༌ཆ༌ གང༌པོའེ༌ ནང༌ང༌ བལ༌པ༌ གང༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ནཱའེལ༌ ལྩངས༌པོ༌ བལ༌པའེ༌ གང༌ཨིན༌ ཡང༌ ཏེ༌གུན༌ ཆུའི༌ ནང༌ནེ༌ བིངས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཁར༌ དང༌ ཁྱོ༌རང༌ ཉིད༌ལོག༌སའེ༌ ནང༌ དང༌ མལ༌ཙེ༌ ནང༌ང༌ ཡོང༌ཨིན༌། ཏེ༌གུན༌ ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌གུན༌ དང༌ མི༌གུན༌ནི༌ ཁང༌པའེ༌ ནང༌ང༌ ཡང༌ ཁྱོ༌ཞའེ༌ ཁར༌ཇི༌ སྐོལ༌སའེ༌ ཐབ༌ དང༌ པག༌པའེ༌ རུ༌སའེ༌ ཞོང༌པ༌ གུན༌ནི༌ ནང༌ང༌ ཞུགས༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","བལ༌པ༌གུན༌ ཁྱོ༌རང༌, ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌ དང༌ མི༌གུན༌ནི༌ཀ༌ ལྕེབ༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨ༌རོན༌ལ༌ ཟེར༌, ‘ཁྱོ༌རང༌ངི༌ ལག༌ག༌ ཡོད༌ཁན༌ནི༌ བེར༌ཀ༌ ཨི༌ཇིབ༌བི༌ ལྩངས༌པོ༌, ཡུ༌ར༌ དང༌ ཟིང༌ ཚང༌མའེ༌ཀ༌ རྐྱངས༌ཏེ༌ བལ༌པ༌གུན༌ ཨི༌ཇིབ༌བི༌ ས༌ཀྱད༌ གང༌པོའེ༌ ནང༌ང༌ གང༌ཅུག༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ཏེ༌ནེ༌ ཨ༌རོན༌ནི༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཨི༌ཇིབ༌བི༌ ཆུ༌ ཚང༌མའེ༌ཀ༌ རྐྱངས༌པ༌ ཆུའི༌ ནང༌ནེ༌ བལ༌པ༌ བིང༌ཏེ༌ ཨི༌ཇིབ༌བི༌ ས༌ཀྱད༌ གང༌པོ༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ཨིན༌ནའང༌ ཆོས༌ངན༌ ཅོ༌ཁན༌གུན༌ནིའང༌ སང༌ཝའེ༌ ཁྱུད༌ ཀོལ༌ཏེ༌ ཏེན༌ན༌ ཙོགས༌ ཅོས༌། ཁོང༌གུན༌ནིའང༌ ཆུའི༌ ནང༌ནེ༌ བལ༌པ༌ ཨི༌ཇིབ༌བི༌ ས༌ཀྱད༌དི༌ཀ༌ བིང༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ བོད༌ཏེ༌ ཟེརས༌, “ང༌ དང༌ ངའེ༌ མི༌གུན༌ནི༌ ཀ༌ནེ༌ བལ༌པ༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོ༌ཅེས༌ལ༌ ཡ༌ཝ༌ མོས༌ལམ༌ ཞུས༌ ཏེ༌ནེ༌ ཁོང༌ང༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌ལ༌ ངའེ༌ ཁྱོ༌ཞའེ༌ མི༌གུན༌ ཆ༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","མོ༌ཟེས༌སི༌ གྱལ༌པོའ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ལྡམས༌ཁན༌ནི༌ ཏུས༌པོའེ༌ཀ༌ ངའེ༌ ཁྱོ༌རང༌, ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌གུན༌ དང༌ མི༌གུན༌ ཡང༌ ཁྱོ༌ཞའེ༌ ཁང༌པ༌གུན༌ནི༌ ནང༌ནེ༌ བལ༌པ༌གུན༌ མེད༌ཁན༌ ཆ༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུ༌ཨིན༌། ལྩངས༌པོ༌ ནཱའེལ༌ ཅིག༌པོའེ༌ ནང༌ང༌ ཏེ༌གུན༌ ལུས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","གྱལ༌པོའེ༌ ཟེརས༌, “ཐོ༌རེ༌ ཅོས༌།” མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌ ནང༌ཞིན༌ ཏེ༌བོ༌ གྲུབ༌ཨིན༌། ཏེ༌ནེ༌ ཁྱོ༌རང༌ང༌ ཡ༌ཝ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ ཙོགས༌ སུའང༌ མེད༌ཁན༌བོ༌ ཧ༌གོ༌ཡིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","བལ༌པ༌གུན༌ ཁྱོ༌རང༌, ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌གུན༌ དང༌ མི༌གུན༌ནི༌ ཁང༌པ༌གུན༌ནི༌ ནང༌ནེ༌ བིང༌ཏེ༌ ཆེན༌། ལྩངས༌པོ༌ ནཱའེལ༌ ཅིག༌པོའེ༌ ནང༌ང༌ ལུས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ གྱལ༌པོའེ༌ ཁར༌ནེ༌ བིང༌ཏེ༌ སོང༌ ཡང༌ མོ༌ཟེས༌སི༌ ཡ༌ཝ༌ བལ༌པ༌གུན༌ མེད༌ཁན༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌ ཀ༌གུན༌ ཁོང༌ངི༌ གྱལ༌པོའེ༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱོང༌ང༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ཡང༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌སི༌ ཞུ༌ཝ༌ ཕུལ༌ཁན༌བོ༌ ཛདས༌། ཁང༌པ༌, ནང༌སྐོར༌ དང༌ ཞིང༌ གུན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ བལ༌པ༌ ཚང༌མ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","མི༌གུན༌ནི༌ བལ༌པ༌ ཤི༌ཁན༌ ཚང༌མ༌ ལྡུས༌ཏེ༌ སྤུངས༌ ཡང༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ ཏྲི༌ངན༌ གངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ཨིན༌ནའང༌ གྱལ༌པོའ༌ ཏེ༌ རྡུག༌ངལ༌བོ༌ མེད༌ཁན༌ ཆའ༌ ཐོང༌ང༌ཅིག༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌ ནང༌ཞིན༌ ཁོའེ༌ སྙིང༌ ཡང༌སྐྱར༌ སྐྱོང༌པོ༌ གྱུར༌ཏེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཟེར༌ཁན༌བོ༌ མ༌ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨ༌རོན༌ལ༌ ཁོ༌རང༌ངི༌ བེར༌ཀ༌ སྟགས༌ཏེ༌ སའ༌ གྱབ༌ཅེས༌ལ༌ ཟེར༌། ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོའེ༌ ཐལ༌བ༌གུན༌ སོ༌གའ༌ ཏབ༌ཁན༌ནི༌ བུ༌ཙིག༌ འུར༌ཁན༌ ཆུ༌ངུན༌གུན༌ལ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཅོས༌། ཨ༌རོན༌ནི༌ ཁོ༌རང༌ངི༌ བེར༌ཀ༌ སྟགས༌ཏེ༌ སའེ༌ཀ༌ གྱབ༌བ༌ཅིག༌ མི༌གུན༌ དང༌ སེམས༌ཅན༌གུན༌ བུ༌ཙིག༌གི༌ ཀབས༌། ཨི༌ཇིབ༌བི༌ ས༌ཀྱད༌དི༌ ཐལ༌བ༌ ཚང༌མ༌ སོ༌གའ༌ ཏབ༌ཁན༌ནི༌ བུ༌ཙིག༌ འུར༌ཁན༌ ཆུ༌ངུན༌ལ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","གྱལ༌པོའེ༌ ཆོས༌ངན༌ ཅོ༌ཁན༌གུན༌ནིའང༌ ཁོ༌རང༌གུན༌ནི༌ སང༌ཝའེ༌ ཁྱུད༌ གྱུད༌ཏེ༌ ཏེན༌ན༌ ཙོགས༌ ཅོ༌ཅེས༌ ཅོས༌ ཨིན༌ནའང༌ ཅོ༌ མ༌ཉན༌། མི༌གུན༌ དང༌ སེམས༌ཅན༌ ཚང༌མ༌ སོ༌གའ༌ ཏབ༌ཁན༌ནི༌ བུ༌ཙིག༌གུན༌ནི༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ཆོས༌ངན༌ ཅོ༌ཁན༌གུན༌ནི༌ གྱལ༌པོའ༌ ཟེརས༌, “འི༌བོ༌ དཀོན༌མཆོག༌གི༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌།” ཨིན༌ནའང༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌ ནང༌ཞིན༌ གྱལ༌པོའེ༌ སྙིང༌ སྐྱོང༌པོ༌ ལུས༌ཏེ༌ ཁོའེ༌ ཁོང༌གུན༌ནི༌ ཟེར༌ཁན༌བོའ༌ མ༌ཉནས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ང༌མོ༌ གྱལ༌པོ༌ ལྩངས༌པོ༌ ནཱའེལ༌ལ༌ ཆ༌ ཟ༌ནེ༌ ཁྱོ༌རང༌ ལམ༌མི༌ཀ༌ ཁོའ༌ ཐུག༌ག༌ སོང༌ཏེ༌ ཟེར༌, ‘ཡ༌ཝའེ༌ འི༌ཟུག༌ མོལས༌, ངའ༌ ཅོལ༌ཅེས༌ལ༌ ངའེ༌ མི༌གུན༌ ཆ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ཆ༌ མ༌ཅུག༌ན༌ ངའེ༌ ཁྱོ༌རང༌, ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌གུན༌, མི༌གུན༌ དང༌ ཁྱོ༌ཞའེ༌ ཁང༌པ༌གུན༌ནི༌ ནང༌ང༌ ར༌ངུ༌ མང༌པོ༌ ཀལ༌ཏེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཁང༌པ༌ དང༌ ས༌ཀྱད༌ ཚང༌མ༌ ར༌ངུའི༌ ཚོགས༌གུན༌ གང༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“‘ཨིན༌ནའང༌ ཏེ༌ ཞག༌ག༌ ངའེ༌ མི༌གུན༌ དུག༌སའེ༌ ནས༌ས༌ གོ༌ཤེན༌ སྐྱོབ༌ཨིན༌ ཏེ༌རུ༌ ར༌ངུའི༌ ཚོགས༌ ཅིག༌གའང༌ མི༌ཐོབ༌། ཏེ༌ནེ༌ ང༌ ཡ༌ཝ༌ ཁྱོ༌རང༌ངི༌ ས༌ཆའེ༌ ནང༌ང༌ ཡོད༌ཁན༌བོ༌ ཁྱོ༌རང༌ང༌ ཧ༌གོ༌ཡིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ངའེ༌ ང༌རང༌ངི༌ མི༌གུན༌ དང༌ ཁྱོ༌རང༌ངི༌ མི༌གུན༌ སོ༌སོ༌ ཕེ༌ཨིན༌། འི༌ ཧ༌ལས༌ཤེས༌སི༌ སྟགས༌པོ༌ ཐོ༌རེ༌ གྲུབ༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ཡ༌ཝའེ༌ ཏེན༌ན༌ ཟུག༌ ཅོའ༌ ཛདས༌། ར༌ངུའི༌ ཚོགས༌ མང༌པོ༌ གྱལ༌པོའེ༌ ཁར༌ དང༌ ཁོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ཁང༌པ༌གུན༌ནི༌ ནང༌ང༌ གང༌ ཡང༌ ཨི༌ཇིབ༌བི༌ ས༌ཀྱད༌ གང༌པོ༌ ར༌ངུའི༌ ཀབ༌ཅེས༌པོའེ༌ ས༌ཀྱད༌ གང༌པོ༌ དོད༌མེད༌ ཆ༌ཅེས༌ གོ༌ཟུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","གྱལ༌པོའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཟེརས༌, “སོང༌ ཡང༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ འིན༌ན༌ ནས༌སའེ༌ ནང༌ང༌ ཆོད༌པ༌ ཕུལ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ཏེ༌ཟུག༌ ཅོ༌ན༌ གྲིག༌ཅེས༌ མ༌ནོག༌། ང༌ཞ༌རང༌ངི༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ ང༌ཞའེ༌ ཆོད༌པ༌ ཕུལ༌ཁན༌གུན༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཚི༌ཏུ༌ ཐེའ༌ནོག༌ ཡང༌ ཁོང༌གུན༌ནི༌ དུན༌ལ༌ ཏེ༌ཟུག༌ ཅོ༌ན༌ ཁོང༌གུན༌ནི༌ ང༌ཞའ༌ རྡོའ༌ གྱབས༌ཏེ༌ མི༌སད༌ད༌? ");
INSERT INTO lbj_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ཡ༌ཝ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ ང༌ཞ༌གུན༌ ཞག༌མ༌ སུམ༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ བེས༌ལ༌ ཆ༌གོས༌ ཀ༌ཟུག༌ ཁོང༌ངི༌ བཀའ༌ སལ༌ཏེ༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","གྱལ༌པོའེ༌ ཟེརས༌, “ངའེ༌ ཁྱོ༌རང༌གུན༌ རི༌སྟོང༌ང༌, ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ ཆ༌ཅུག༌ཨིན༌ ཀལ༌ཏེས༌ ཁྱོ༌ཞའ༌ མ༌ ཐག༌རིང༌ང༌ མ༌ཆའ༌ན༌། ངའེ༌ ཕིའ༌ མོས༌ལམ༌ ཞུས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ང༌ ཁྱོ༌རང༌ངི༌ ཁར༌ནེ༌ བིང༌ང༌ཅིག༌ ངའེ༌ ཡ༌ཝ༌ མོས༌ལམ༌ ཞུ༌ཨིན༌ ཡང༌ ཐོ༌རེ༌ ཁྱོ༌རང༌, ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌གུན༌ དང༌ མི༌གུན༌ནི༌ ཀ༌ནེ༌ ར༌ངུ༌གུན༌ མེད༌ཁན༌ ཆེན༌། ཨིན༌ནའང༌ ང༌ཞའ༌ ཡ༌ཝ༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌ལ༌ ཆ༌ མ༌ཅུག༌ག༌ གྱལ༌པོའེ༌ ང༌ཞའ༌ ཡང༌སྐྱར༌ གོབ༌སྐོར༌ ཏང༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ཏེ༌ནེ༌ མོ༌ཟེས༌ གྱལ༌པོའེ༌ ཁར༌ནེ༌ སོང༌ ཡང༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ཡ༌ཝའེ༌ མོ༌ཟེས༌སི༌ ཞུ༌ཁན༌ ནང༌ཞིན༌ ཅོའ༌ཛདས༌: གྱལ༌པོ༌, ཁོའེ༌ སྤོན༌བོ༌གུན༌ དང༌ མི༌གུན༌ནི༌ ཀ༌ནེ༌ ར༌ངུའི༌ ཚོགས༌གུན༌ མེད༌ཁན༌ ཛདས༌, ཅིག༌གའང༌ ལུས༌ཤུག༌ག༌ མ༌ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ཨིན༌ནའང༌ ཡང༌སྐྱར༌ གྱལ༌པོའེ༌ སྙིང༌ སྐྱོང༌པོ༌ གྱུར༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཆ༌མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེར༌, ‘ཡ༌ཝ༌ ཨིབ༌རི༌པ༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ འི༌ཟུག༌ མོལས༌, “ངའ༌ ཅོལ༌ཅེས༌ལ༌ ངའེ༌ མི༌གུན༌ ཆ༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ཁོང༌གུན༌ ཏ༌རུང༌ངའང༌ ཆ༌ མ༌ཅུག༌ག༌ བོར༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ཁྱོ༌ཞའེ༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌ རྟ༌གུན༌, བུང༌བུ༌གུན༌, རྔ༌བོང༌གུན༌, བ༌ལང༌གུན༌ དང༌ ར༌ལུག༌གུན༌ལ༌ ང༌ ཡ༌ཝའེ༌ ནད༌ རྩོག༌པོ༌ ཡོང༌ཅུགས༌ཏེ༌ ཤི༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ཨིན༌ནའང༌ ང༌ ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ དང༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌གུན༌ལ༌ ཁྱད༌པར༌ ཅོས༌ཏེ༌, ཨིས༌ར༌ཨེལ༌པའེ༌ སེམས༌ཅན༌ ཅིག༌གའང༌ མི༌ཤི༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ཡ༌ཝའེ༌ ཏུས༌པོ༌ ལྡམ༌མ༌ ཛད༌ཏེ༌ མོལས༌, “ང༌ ཡ༌ཝའེ༌ ཏེ༌བོ༌ འི༌ ས༌ཆའེ༌ ནང༌ང༌ ཐོ༌རེ༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","སྟིང༌མ༌ཞག༌པོ༌ ཡ༌ཝའེ༌ ཁོང༌ངི༌ མོལ༌ལ༌ ཛད༌ཁན༌བོ༌ ཅོའ༌ ཛདས༌། ཨི༌ཇིབ༌པ༌གུན༌ནི༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཚང༌མ༌ ཤི༌, ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སེམས༌ཅན༌ ཅིག༌གའང༌ མ༌ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ མི༌གུན༌ ལྟའ༌ལ༌ ཀལས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཅིག༌གའང༌ མ༌ ཤི༌ཁན༌བོ༌ ཐོང༌། ཨིན༌ནའང༌ གྱལ༌པོའེ༌ སྙིང༌ སྐྱོང༌པོ༌ ལུས༌ཏེ༌ ཁོང༌གུན༌ ཆ༌ མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ མོལས༌, “ཁྱོ༌ཞའེ༌ མེ༌ ཏང༌སའེ༌ ཐབ༌བི༌ ནང༌ནེ༌ ལག༌པ༌ གང༌ངི༌ ཀོག༌ཐལ༌ ཁུར༌ཏེ༌ མོ༌ཟེས༌ལ༌ ཏེ༌བོ༌ གྱལ༌པོའེ༌ དུན༌ལ༌ ལུངས༌པའེ༌ ནང༌ང༌ ཡོག༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ཏེ༌བོ༌ ཐལ༌བ༌ ཇམ༌པོ༌ གྱུར༌ཏེ༌ ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོ༌ ཀབ༌ཨིན༌ ཡང༌ ཨི༌ཇིབ༌པ༌ མི༌ དང༌ ཁོང༌ངི༌ སེམས༌ཅན༌ ཚང༌མ༌ལ༌ ནག༌ གང༌ཁན༌ནི༌ བུར༌རུ༌ བིང༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཐབ༌བི༌ ནང༌ནེ༌ ཀོག༌ཐལ༌ ཁུར༌ཏེ༌ གྱལ༌པོའེ༌ དུན༌ལ༌ ལངས༌ཏེ༌ མོ༌ཟེས༌སི༌ ཏེ༌བོ༌ ལུངས༌པོའེ༌ ནང༌ང༌ ཡོགས༌ ཡང༌ ཨི༌ཇིབ༌པ༌ མི༌ དང༌ སེམས༌ཅན༌ གུན༌ལ༌ ནག༌ གང༌ཁན༌ནི༌ བུར༌རུ༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ཆོས༌ངན༌ ཅོ༌ཁན༌གུན༌ མོ༌ཟེས༌སི༌ དུན༌ལ༌ ཡོང༌མ༌ཉན༌ ཅིའ༌ཟེར༌ན༌ ཞན༌ཡང༌ ཨི༌ཇིབ༌པ༌ ཚང༌མ༌ ཙོགས༌ལ༌ ཁོང༌གུན༌ལའང༌ བུར༌རུ༌ བིང༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ གྱལ༌པོའེ༌ སྙིང༌སྐྱོང༌པོ༌ ཅོའ༌ཛདས༌ ཡང༌ ཁོའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཟེར༌ཁན༌བོའ༌ མ༌ཉནས༌ ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཐོ༌རེ༌ ང༌མོ༌ནེ༌ ལངས༌ཏེ༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ ཡང༌ ཟེར༌, ‘ཡ༌ཝ༌ ཨིབ༌རི༌པ༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ འི༌ཟུག༌ མོལས༌, ངའ༌ ཅོལ༌ཅེས༌ལ༌ ངའེ༌ མི༌གུན༌ ཆ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ཏ༌ ངའེ༌ ཁྱོ༌རང༌, ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌གུན༌ དང༌ མི༌གུན༌ལ༌ སྔུན༌ནི༌སང༌ མང༌ང༌ སྲན༌ཏྲེ༌ ཆད༌པ༌ ཏང༌ཨིན༌། ཏེ༌ནེ༌ འི༌ ཇིག༌རྟེན༌ནི༌ ནང༌ང༌ ང༌ ཙོགས༌ སུའང༌ མེད༌ཁན༌བོ༌ ཁྱོ༌རང༌ངི༌ ཧ༌གོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ངའེ༌ ང༌རང༌ངི༌ ལག༌པ༌ ཁྱུད༌ཅན༌ རྐྱངས༌པིན༌ན༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ མི༌གུན༌ ཤི༌ཏེ༌ འི༌ ཇིག༌རྟེན༌ནི༌ ཀ༌ནེ༌ མེད༌ཁན༌ སོང༌ཏེ༌ ཡོད༌གྲོ༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ཨིན༌ནའང༌ ངའེ༌ སྟོབས༌པོ༌ ཁྱོ༌རང༌ང༌ སྟན༌ཅེས༌ ཡང༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ མི༌གུན༌ནི༌ ང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ ཨིན༌ཁན༌བོ༌ ཤེ༌ཤེས༌སི༌ ཕིའ༌ ངའེ༌ ཁྱོ༌རང༌ སོན༌ཏེའ༌ བོར༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ཁྱོ༌རང༌ངི༌ ཏ༌རུང༌ངའང༌ ངའེ༌ མི༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཝང༌ སྟན༌ཏེ༌ ཁོང༌གུན༌ ཆ༌ ཅུག༌ག༌ མི༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ཏེ༌བོའེ༌ཕིའ༌ ཐོ༌རེ༌ འིན༌ན༌ ཏུས༌ལ༌ ངའེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌རབས༌སི༌ ནང༌ང༌ མེད༌ཁན༌ནི༌ སེ༌ར༌རུ༌ ཀྲག༌པོ༌ བབས༌ ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ཏ༌ ཕི༌ལོག༌ག༌ ཡོད༌ཁན༌ནི༌ སེམས༌ཅན༌ དང༌ ཞན༌ ནོར༌ ཚང༌མ༌ ནང༌ང༌ ཁྱོང༌ཅེས༌ལ༌ བཀའ༌ ཏོང༌ ཅིའ༌ཟེར༌ན༌ ཕི༌ལོག༌ག༌ ལུས༌ཁན༌ནི༌ མི༌ དང༌ སེམས༌ཅན༌ ཚང༌མའེ༌ཀ༌ སེ༌ར༌རུ༌ བབས༌ཏེ༌ ཁོང༌གུན༌ ཤི༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ཡ༌ཝའེ༌ མོལ༌ཁན༌བོའ༌ ཇིགས༌ཁན༌ནི༌ གྱལ༌པོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ ཡོག༌པོ༌གུན༌ དང༌ སེམས༌ཅན༌གུན༌ གྱོགས༌པ༌ ནང༌ཀུག༌ག༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌བོའ༌ སྣང༌ང༌ མ༌ཏང༌ཁན༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ ཡོག༌པོ༌གུན༌ དང༌ སེམས༌ཅན༌གུན༌ ཕི༌ལོག༌ག༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌ “ཁྱོ༌རང༌ངི༌ ལག༌པ༌ ནམ༌ཁའ༌ ཆོགས༌ལ༌ སྐྱོང༌, ཏེ༌ནེ༌ ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོའེ༌ཀ༌ སེ༌ར༌རུ༌ བབས༌ཨིན༌; ཡང༌ན༌ མི༌གུན༌, སེམས༌ཅན༌གུན༌ དང༌ ཞིང༌ངི༌ སྟོན༌ཐོག༌ གུན༌ནི༌ཀ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ བེར༌ཀ༌ ནམ༌ཁའ༌ ཆོགས༌ལ༌ སྟག༌ག༌ཅིག༌ ཡ༌ཝའེ༌ བྲུག༌ལྡིར༌ ཅུག༌ཏེ༌ སེ༌ར༌རུ༌ བབས༌ ཅུག༌ག༌ ཛདས༌ ཡང༌ མེ༌ སའེ༌ཀ༌ བུད༌། ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཨི༌ཇིབ༌བི༌ ས༌ཆའེ༌ ནང༌ང༌ མ༌ མང༌པོ༌ སེ༌ར༌རུ༌ བབས༌ ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","སེར༌ར༌རུ༌ ཉམ༌པོ༌ མེ༌ སའེ༌ཀ༌ བུད༌། ཏེ༌ཙོགས༌སི༌ སེར༌ར༌རུ༌ དང༌ ལུང༌ཚུབ༌ ཀྲག༌པོ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌རབས༌སི༌ ནང༌ང༌ དག༌ས༌ ཚོག༌པ༌ མ༌ཇུང༌ང༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ཨི༌ཇིབ༌ གང༌པོའེ༌ ནང༌ང༌ སེར༌ར༌རུའི༌, ཕི༌ལོག༌ག༌ ཡོད༌ཁན༌ནི༌ མི༌གུན༌, སེམས༌ཅན༌གུན༌ དང༌ ཞིང༌ངི༌ སྟོན༌ཐོག༌ ཚང༌མ༌ ནན༌ཏེ༌ མེད༌ཁན༌ ཅོས༌ ཡང༌ ལྕང༌མ༌ ཚང༌མ༌ ཆགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ དུག༌སའེ༌ གོ༌ཤེན༌ ཡུལ༌ཁག༌ ཅིག༌པོའེ༌ ནང༌ང༌ སེ༌ར༌རུ༌ མ༌བབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","གྱལ༌པོའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཟེརས༌, “འི༌ ལན༌ ངའེ༌ སྡིག༌པ༌ ཅོས༌ཏོག༌། ཡ༌ཝའེ༌ ཀྲང༌པོ༌ ཛད༌ཏེ༌ ཡང༌ ང༌ དང༌ ངའེ༌ མི༌གུན༌ནི༌ ནོར༌ཁྲུལ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ཇུ༌ཇུ༌ ཡ༌ཝ༌ མོས༌ལམ༌ ཞུས༌, ང༌ཞ༌གུན༌ནི༌ཀ༌ བྲུག༌ དང༌ སེ༌ར༌རུ༌ ཙམ༌ཐད༌ཐད༌ བབས༌། ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཆ༌ ཅུག༌ཨིན༌། ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌རང༌གུན༌ འི༌རུ༌ དུག༌གོས༌ མེད༌པ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ང༌ གྱལ༌ས༌ནེ༌ བིང༌ཏེ༌ ཆའ༌ཅིག༌ ངའེ༌ ཡ༌ཝ༌ མོས༌ལམ༌ ཞུ༌ཅེས༌སི༌ ཕིའ༌ ང༌རང༌ངི༌ ལག༌པ༌ རྐྱང༌ཨིན༌། བྲུག༌ལྡིར༌ཅེས༌ མེད༌ཁན༌ ཆེན༌ ཡང༌ སེ༌ར༌རུ༌ མི༌བབས༌, ཏེ༌ནེ༌ ཁྱོ༌རང༌ང༌ ཇིག༌རྟེན༌, ཡ༌ཝའེ༌ ཨིན༌ཁན༌བོ༌ ཧ༌གོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ཨིན༌ནའང༌ ང༌ གྱུས༌ཡོད༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌གུན༌ ཏ༌རུང༌ངའང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ ཇིགས༌ས༌ མི༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","༼སེ༌ར༌རུའི༌ ཕེལེགས༌ མེན༌ཏོག༌ བར༌ཁན༌ དང༌ ནས༌སི༌ སྟོན༌ཐོག༌ སྨིན༌ཏེ༌ ཡོད༌ཁན༌གུན༌ མེད༌ཁན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ཨིན༌ནའང༌ ཀྲོའེ༌ སྟོན༌ཐོག༌ག༌ ནོད༌སྐྱལ༌ མ༌སོང༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌གུན༌ ཏ༌རུང༌ ཆུ༌ངུན༌ ཡོད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","མོ༌ཟེས༌ གྱལ༌པོ༌ བོར༌ཏེ༌ གྱལ༌སའེ༌ ཕི༌ལོག༌ག༌ སོང༌ ཡང༌ ཡ༌ཝ༌ ཆོགས༌ལ༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ སྟགས༌ཏེ༌ མོས༌ལམ༌ ཞུས༌། བྲུག༌ལྡིར༌ དང༌ སེ༌ར༌རུ༌ མེད༌ཁན༌ སོང༌ ཡང༌ ཇིག༌རྟེན༌ནི༌ཀ༌ སྲན༌ཏྲེ༌ ཆར༌པ༌ བབས༌ཤེས༌ ཆད༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","གྱལ༌པོའ༌ ཆར༌པ༌, སེ༌ར༌རུ༌ དང༌ བྲུག༌ལྡིར༌ གུན༌ མེད༌ཁན༌ ཆའ༌ལ༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཡང༌སྐྱར༌ སྡིག༌པ༌ ཅོས༌། ཁོ༌ དང༌ ཁོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ སྙིང༌ ཏ༌རུང༌ངའང༌ སྐྱོང༌པོ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ཡ༌ཝའེ༌ མོ༌ཟེས༌ གྱུད༌ཏེ༌ ལུང༌སྟན༌ སལ༌ཁན༌ ནང༌ཞིན༌ གྱལ༌པོའེ༌ སྙིང༌ སྲན༌ཏྲེ༌ གྱུར༌ཏེ༌ ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཆ༌མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “གྱལ༌པོ༌ ཡོད༌ས༌ ཡང༌སྐྱར༌ སོང༌, ངའེ༌ ཁོ༌ དང༌ ཁོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ཕྲོའ༌ ང༌རང༌ངི༌ ཧ༌ལས༌ཤེས༌སི༌ སྟགས༌གུན༌ སྟན༌ཅེས༌ལ༌ ངའེ༌ ཁོང༌གུན༌ནི༌ སྙིང༌ སྐྱོང༌པོ༌ གྱུར༌ཅུགས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ཏེ༌ནེ༌ ཁྱོ༌ཞའེ༌ ཕྲུ༌གུ༌གུན༌ དང༌ ཚ༌འོ༌ ཚ༌མོ༌ གུན༌ལ༌ ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ སམ༌བ༌ མེད༌ཁན༌ གྱུར༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཧ༌ལས༌ཤེས༌སི༌ སྟགས༌ སྟན༌ཁན༌གུན༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཤད༌ཉན༌ཨིན༌ ཡང༌ ཁྱོ༌ཞའ༌ ཚང༌མའེ༌ ང༌ ཡ༌ཝ༌ ཨིན༌ཁན༌བོ༌ ཤེས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ཏེ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁོའ༌ ཟེརས༌, “ཡ༌ཝ༌ ཨིབ༌རི༌པ༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ འི༌ཟུག༌ མོལས༌, ‘ཏ༌རུང༌ ཙམ༌ཤིག༌ ཁྱོ༌རང༌ ངའེ༌ དུན༌ལ༌ བོལ༌མོ༌ མི༌གྱུར༌? ང༌ ཅོལ༌ཅེས༌ལ༌ ངའེ༌ མི༌གུན༌ ཆ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ཁོང༌གུན༌ ཆ༌ མ༌ཅུག༌ན༌, ཐོ༌རེ༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ ཡུལ༌ལ༌ པར༌པར༌ཙེ༌ ཁྱོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","སུ༌ཞིག༌གིའང༌ ས༌ སྟོང༌པ༌ མི༌ཐོང༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌གུན༌ནི༌ ས༌ཀྱད༌ གང༌པོ༌ ཀབ༌ཨིན༌། སེར༌ར༌རུའི༌ ཁྲེས༌ཏོར༌ མ༌ཅོའ༌ ལུས༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མ༌ མ༌ཚད༌ ཞིང༌ངི༌ཀ༌ ཡོད༌ཁན༌ནི༌ ལྕང༌མ༌ ཚང༌མའང༌ ཏེ༌གུན༌ནི༌ ཟེན༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ཏེ༌གུན༌ ཁྱོ༌རང༌ངི༌ ཁར༌, ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌ ཚང༌མ༌ དང༌ མི༌ ཚང༌མའེ༌ ཁང༌པ༌གུན༌ནི༌ ནང༌ང༌ གང༌ཨིན༌། ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ འི༌ ས༌ཆའེ༌ ནང༌ང༌ ཚུགས༌པ༌ནེ༌ ཕར༌ལ༌ འི༌ཙོགས༌ མ༌ཐོང༌ང༌ ཨིན༌ནོག༌།’” ཏེ༌ནེ༌ མོ༌ཟེས༌ གྱལ༌པོའེ༌ དུན༌ནེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ཏ༌ གྱལ༌པོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ཁོའ༌ ཟེརས༌, “ཏ༌རོང༌ ཙམ༌ཤིག༌ འི༌ མི༌བོའ༌ ང༌ཞ༌གུན༌ལ༌ ནགས༌ སྟན༌ཅུག༌གད༌? ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཡ༌ཝ༌ ཁོང༌གུན༌ནི༌ དཀོན༌མཆོག༌ག༌ ཅོལ༌ཅེས༌ལ༌ ཆ༌ཅུག༌ག༌ ཛད༌། ཨི༌ཇིབ༌ ཁྲེས༌ཏོར༌ ཆའ༌ཁན༌བོ༌ ཉེ༌རང༌ངི༌ ཟིགས༌ས༌ མི༌དུག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ཏེ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ གྱལ༌པོའེ༌ ཡོད༌ས༌ ཡང༌སྐྱར༌ ཁྱོངས༌ ཡང༌ ཁོའེ༌ ཟེརས༌, “ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཅོལ༌ཅེས༌ལ༌ སོང༌། ཨིན༌ནའང༌ ཁྱོ༌ཞའེ༌ ཕྲོ༌ནེ༌ སུ༌ ཆའད༌?” ");
INSERT INTO lbj_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ང༌ཞའ༌ ཚང༌མ༌ ཆའད༌། ཕྲུ༌གུ༌གུན༌ དང༌ རྒད༌པོ༌གུན༌, བུ༌ཚ༌གུན༌ དང༌ བུ༌མོ༌གུན༌ ཡང༌ ང༌ཞའེ༌ ར༌ལུག༌ དང༌ ཞན༌ སེམས༌ཅན༌ནི༌ ཁྱུ༌ གུན༌ནའང༌ ཁྱེར༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ང༌ཞའ༌ ཚང༌མ༌ ཛོམ༌ཏེ༌ གའ༌སྟོན༌ རྩི༌ཨིན༌ ཡ༌ཝ༌ སྟོད༌པ༌ དང༌ ཆོད༌པ༌ ཕུལ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","གྱལ༌པོའེ༌ ཟེརས༌, “ངའེ༌ བུ༌མོ༌གུན༌ དང༌ ཕྲུ༌གུ༌གུན༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ མ༌ནེ༌ ཆ༌ མི༌ཅུག༌, ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌གུན༌ ལོག༌ཏེ༌ མི༌ཡོང༌ཅེས༌སི༌ ཅུས༌ངན༌ ལྡིངས༌ཁན༌བོ༌ ངའ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ཆ༌ མི༌ཅུག༌། ཡ༌ཝ༌ ཆོད༌པ༌ ཕུལ༌ཏེ༌ ཅོལ༌གོ༌ཤེས༌ ཁག༌ཅན༌ ཨིན༌ན༌ བུ༌ཚ༌གུན༌ ཅིག༌པོ༌ སོང༌།” ཏེ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ གྱལ༌པོའེ༌ དུན༌ནེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོ༌ པར༌པར༌ཙེ༌ གང༌ཅེས༌ལ༌ ཁྱོ༌རང༌ངི༌ ལག༌པ༌ ཏེ༌ ས༌ཆའེ༌ཀ༌ སྐྱོང༌། ཞིང༌ངི༌ སྟོན༌ཐོག༌ སེར༌ར༌རུའི༌ ཁྲེས༌ཏོར༌ མ༌ཅོའ༌ ལུས༌ཏེ༌ ཡོད༌ཁན༌ དང༌ སྔོན༌པོ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཏེ༌གུན༌ནི༌ ཟེན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ བེར༌ཀ༌ ཨི༌ཇིབ༌བི༌ཀ༌ རྐྱངས༌ ཡང༌ ཡ༌ཝའེ༌ ཏེ༌ ཉི༌མ༌ དང༌ ཚན༌ གང༌པོ༌ ཤར༌ ཆོགས༌ནེ༌ ལུངས༌པོ༌ ཡོང༌ ཅུག༌ག༌ ཛདས༌། ང༌མོ༌ ཆའ༌ཅིག༌ ལུངས༌པོའེ༌ པར༌པར༌ཙེ༌གུན༌ ཁྱོངས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ཏེ༌གུན༌ ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ ཀ༌རུང༌ས༌ གང༌། དག༌ས༌ ཚག༌པ༌ མ༌ཐོང༌ཁན༌ ཡ༌ ཡོང༌ཅེས༌ཅན༌ནི༌ ཏུས༌སི༌ ནང༌ངའང༌ མ༌ནེ༌ མི༌ཐོང༌, ཏེ༌ཟམ༌ མང༌པོ༌ པར༌པར༌ཙེ༌ ནས༌ས༌ ཚང༌མ༌ གངས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ཏེ༌གུན༌ གངས༌ཏེ༌ ས༌ཀྱད༌ ནག༌པོ༌ སོང༌། ཏེ༌གུན༌ནི༌ ལྕང༌མའེ༌ ཁ༌ཟས༌ དང༌ ཞིང༌ངི༌ སྟོན༌ཐོག༌ སེར༌ར༌རུའི༌ ཁྲེས༌ཏོར༌ མ༌ཅོའ༌ ལུས༌ཁན༌ ཚང༌མ༌ ཟོས༌། ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོའེ༌ ནང༌ང༌ ལྕང༌མ༌ དང༌ ཞིང༌གུན༌ནི༌ཀ༌ སྔོན༌པོ༌ ཅིག༌གའང༌ མ༌ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ གྱོགས༌པ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཟེརས༌, “ངའེ༌ ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌ དང༌ ཁྱོ༌ཞའེ༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཅོས༌ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ཏ༌ འིན༌ན༌ ལན༌ ངའེ༌ སྡིག༌པ༌བོའ༌ ཤགས༌པ༌ ཏོང༌ ཡང༌ ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ངའེ༌ ཀ༌ནེ༌ ཤི༌ཅེས༌སི༌ འི༌ རྡུག༌ངལ༌བོ༌ ཐེན༌ན༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","མོ༌ཟེས༌ གྱལ༌པོ༌ ཡོད༌ས༌ནེ༌ སོང༌ ཡང༌ ཡ༌ཝ༌ མོས༌ལམ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ཡ༌ཝའེ༌ ནུབ༌ ཆོགས༌ནེ༌ ལུངས༌པོ༌ ཤེད༌ཅན༌ ཡོང༌ ཅུག༌ག༌ ཛདས༌ ཀ༌བོའེ༌ པར༌པར༌ཙེ༌གུན༌ ཚོ༌ མར༌པོའེ༌ ནང༌ང༌ ཁྱེརས༌། ཨི༌ཇིབ༌བི༌ ནང༌ང༌ པར༌པར༌ཙེ༌ ཅིག༌གའང༌ མ༌ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ གྱལ༌པོའེ༌ སྙིང༌ སྐྱོང༌པོ༌ ལུས༌ ཅུག༌ག༌ ཛདས༌ ཡང༌ ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཆ༌མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ལག༌པ༌ ནམ༌ཁའ༌ ཆོགས༌ལ༌ སྐྱོང༌ ཡང༌ ཨི༌ཇིབ༌བི༌ ས༌ཆ༌ གང༌པོ༌ མུན༌གྲིག༌ ཆེན༌ ཏེ༌ཟམ༌ མུན༌ནག༌ ཀ༌བོ༌ ཁོང༌གུན༌ནི༌ ཚོར༌ ཐུབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ནམ༌ཁའ༌ ཆོགས༌ལ༌ སྟགས༌ ཡང༌ ཞག༌པོ༌ སུམ༌མི༌ ཕིའ༌ ཨི༌ཇིབ༌ གང༌པོ༌ ཇིགས༌པ༌ མུན༌ནག༌གི༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ཨི༌ཇིབ༌པ༌གུན༌ལ༌ ཐོང༌ མ༌ཐུབ༌ ཡང༌ ཁོང༌གུན༌ ཁང༌པ༌ནེ༌ ཕི༌ལོག༌ག༌ ཆའ༌ མ༌ཉན༌། ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ དུགས༌ཏེ༌ ཡོད༌སའེ༌ ས༌ཆའེ༌ ནང༌ང༌ འོད༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","གྱལ༌པོའེ༌ མོ༌ཟེས༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཟེརས༌, “ཡ༌ཝའ༌ ཅོལ༌ལ༌ སོང༌། ཁྱོ༌ཞའེ༌ ན༌མ༌ དང༌ ཕྲུ༌གུ༌ ཚང༌མ༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ཁྱེར༌ནའང༌ གྲིག༌། ཨིན༌ནའང༌ ཁྱོ༌ཞའེ༌ ར༌ལུག༌ དང༌ ཞན༌ སེམས༌ཅན༌ནི༌ ཁྱུ༌གུན༌ འིན༌ན༌རུ༌ བོར༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ཟེརས༌, “ཡ༌ཝ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ སྲོག༌ཆོད༌ དང༌ མེའ༌ སྲགས༌ཁན༌ནི༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ ཉེ༌རང༌ངི༌ ང༌ཞའ༌ སེམས༌ཅན༌གུན༌ ཁྱེར༌ཅུག༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ང༌ཞའེ༌ སེམས༌ཅན༌གུན༌ ཅིག༌གའང༌ མ༌བོར༌ར༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཁྱེར༌གོས༌། ང༌ཞའེ༌ ཏེ༌གུན༌ནི༌ ནང༌ནེ༌ ཁ༌ཅིག༌ ཡ༌ཝ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཆོད༌པ༌ ཕུལ༌ཨིན༌ ཡང༌ ཏེ༌རུ༌ ལེབ༌ཏེ༌ མ༌ནེ༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌ཅན༌ནི༌ སེམས༌ཅན༌གུན༌ ང༌ཞའ༌ གྱུས༌ མི༌ཆ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ གྱལ༌པོའེ༌ སྙིང༌ སྐྱོང༌པོ༌ གྱུར༌ཅུག༌ག༌ ཛདས༌ ཡང༌ ཁོའེ༌ ཁོང༌གུན༌ ཆ༌ མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ཁོའེ༌ མོ༌ཟེས༌ལ༌ ཟེརས༌, “ང༌ནེ༌ ཐག༌རིང༌ང༌ སོང༌། ཡང༌སྐྱར༌ ཁྱོ༌རང༌ ངའེ༌ དུན༌ལ༌ མི༌ཡོང༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌། ཁྱོ༌རང༌ངི༌ ལྡོང༌ ངའ༌ ཐོང༌ངི༌ ཞག༌ག༌ ཁྱོ༌རང༌ ཤི༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ མོལ༌ཁན༌ ནང༌ཞིན༌, ངའ༌ ཉེ༌རང༌ངི༌ དུན༌ལ༌ ཡང༌སྐྱར༌ མ༌ནེ༌ མི༌ཡོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ངའེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ དང༌ ཁོའེ༌ མི༌གུན༌ལ༌ ཏ༌རུང༌ ཆད༌པ༌ ཅིག༌ ཏང༌ཨིན༌། ཏེ༌སྟིང༌ནེ༌ ཁོའེ༌ ཁྱོ༌ཞ༌གུན༌ འི༌ཀ༌ནེ༌ ཆ༌ཅུག༌ཨིན༌། ཏན༌ཏན༌ ཁོའེ༌ ཁྱོ༌ཞ༌ ཚང༌མ༌ འི༌ ས༌ཆའེ༌ ནང༌ནེ༌ ཕིང༌ཏེ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ཨིས༌ར༌ཨེལ༌པ༌ བུ༌མོ༌ དང༌ བུ༌ཚ༌ གུན༌ལ༌ ཁོ༌རང༌གུན༌ནི༌ ཨི༌ཇིབ༌པ༌ ཁྱིམ༌ཚེས༌པ༌གུན༌ལ༌ སེར༌ དང༌ མུལ༌ལི༌ ཅ༌ལག༌གུན༌ ཏོང༌ ཟེར༌ཅེས༌ལ༌ ཟེར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","༼ཡ༌ཝའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཀུས༌པ༌ ཡང༌ ཨི༌ཇིབ༌བི༌ སྤོན༌བོ༌གུན༌ དང༌ མི༌གུན༌ལ༌, མོ༌ཟེས༌ མི༌ མ༌ ཀྲག༌པོ༌ ཐེ༌ཅུག༌ག༌ ཛདས༌།༽ ");
INSERT INTO lbj_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ གྱལ༌པོའ༌ ཟེརས༌, “ཡ༌ཝའེ༌ འི༌ཟུག༌ མོལས༌, ‘དི༌རིང༌ ཚན༌སྐྱིལ༌ ཟམ༌ཤིག༌ག༌ ང༌ ཨི༌ཇིབ༌ གྱུད༌ཏེ༌ ཆེན༌ ");
INSERT INTO lbj_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ཡང༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ བུ༌ཚ༌ གོ༌བུ༌ ཚང༌མ༌ ཤི༌ཨིན༌, གྱལ༌པོའེ༌ བུ༌ཚ༌ གོ༌བུ༌ ཁྲིས༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཅེས༌ཅན༌ནེ༌ ཏངས༌ཏེ༌ ལག༌པའེ༌ རན༌ཐགས༌གི༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཚེ༌ཡོག༌གི༌ བུ༌ཚ༌ གོ༌བུ༌ ཚག༌པ༌ ཡང༌ སེམས༌ཅན༌གུན༌ནི༌ གོ༌སྐྱེས༌ ཕོ༌ གུན༌ནའང༌ ཤི༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ཨི༌ཇིབ༌ གང༌པོའེ༌ ནང༌ང༌ ངུ༌སྐད༌ སྲན༌ཏྲེ༌ ཚོར༌ཨིན༌ ཀ༌བོ༌ དག༌ས༌ ཚོག༌པ༌ མ༌ཚོར༌ཁན༌ ཡང༌ ཡོང༌ཅེས༌ཅན༌ནི༌ ཏུས༌སི༌ ནང༌ང༌ མི༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕྲོའ༌ ཏེ༌ཟམ༌ ཞི༌དེའེ༌ ཡོང༌ཨིན༌, ཁོང༌གུན༌ནི༌ ཁྱི༌གུན༌ནི༌ མི༌ ཡ༌ སེམས༌ཅན༌ ཞིག༌གའང༌ མི༌མུག༌།’ ཏེ༌ནེ༌ ང༌ ཡ༌ཝའེ༌ ཨི༌ཇིབ༌པ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ གུན༌ནི༌ ནང༌ང༌ ཁྱད༌ ཅོ༌ཁན༌བོ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ གྱུས༌ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","མོ༌ཟེས༌སི༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ སྤོན༌བོ༌ ཚང༌མ༌ ཡོངས༌ཏེ༌ ང༌ ཆག༌ ཕུལ༌ཏེ༌ ཟེར༌ཨིན༌, ‘ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ གྱབ༌ནེ༌ ཡོང༌ཁན༌ ཚང༌མ༌ ཁྲིད༌ཏེ༌ སོང༌།’ ཏེ༌སྟིང༌ནེ༌ ང༌ ཆེན༌།” ཏེ༌ནེ༌ སྲོ༌ སྲན༌ཏྲེ༌ ཉམ༌པོ༌ མོ༌ཟེས༌ གྱལ༌པོ༌ ཡོད༌ས༌ནེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལ༌ཏེ༌ ཨིན༌པིན༌, “ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ངའེ༌ ལྟས༌ མང༌ང༌ སྟན༌ཅེས༌སི༌ ཕིའ༌ གྱལ༌པོའེ༌ ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌ལ༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ལྟས༌གུན༌ གྱལ༌པོའེ༌ དུན༌ལ༌ སྟནས༌, ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ཁོའེ༌ སྙིང༌སྐྱོང༌པོ༌ ཅོའ༌ ཛད༌ཅེས༌པོའེ༌ ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཁོ༌རང༌ངི༌ ཡུལ༌ནེ༌ ཆ༌ མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ཏ༌ནེ༌ཕར༌ལ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕིའ༌ འི༌ ཟླ༌ཝ༌བོ༌ ལོའེ༌ ཟླ༌ཝ༌ ཏང༌པོ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའ༌ ཟེར༌, ‘འི༌ ཟླ༌ཝའེ༌ ཞག༌ རྕུ༌པའེ༌ ཞག༌ག༌ ནང༌ཚངས༌ རེ༌རེའེ༌ སྲོག༌ཆོད༌དི༌ ཕིའ༌ ལུ༌གུ༌ ཡ༌ རི༌གུ༌ ལྡམ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ཀལ༌ཏེས༌ ནང༌ཚངས༌ ཆུ༌ངུན༌ ཡོད༌ཅེས༌པའེ༌ ལུ༌གུ༌ ཡ༌ རི༌གུའི༌ ཤ༌ གང༌པོ༌ ཟའ༌ མ༌ཉན༌ན༌, ཁོང༌རང༌གུན༌ནི༌ ཁྱིམ༌ཚེས༌པ༌ ཉམ༌པོ༌ ཛོམས༌ཏེ༌ བགོ༌གོས༌། ནང༌ཚངས༌སི༌ མི༌ རེ༌རེའེ༌ ཟའ༌ ཉན༌ཅེས༌སི༌ ཚད༌ ནང༌ཞིན༌ ལུ༌གུའི༌ ཤ༌བོ༌ བགོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ཁྱོ༌ཞ༌གུན༌ནི༌ ལྡམ༌ཁན༌ནི༌ ལུ༌གུ༌ ཡ༌ རི༌གུ༌, ལོ༌ ཅིག༌ ཆའ༌ཁན༌ ཕོ༌ ཡང༌ སྐྱོན༌ མེད༌ཁན༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ཏེན༌ན༌ ཟླ༌ཝའེ༌ ཞག༌ ཅུབ༌ཞི༌པ༌ ཚག༌པ༌ ཏེ༌ སེམས༌ཅན༌བོའ༌ སྟ༌སྟོག༌ ཅོ༌གོས༌། ཏེ༌ནེ༌ ཏེན༌ན༌ ཞག༌ག༌ ཉི༌མ༌ སྐྱོད༌ ཟ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ སེམས༌ཅན༌བོ༌ སད༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ཁོང༌གུན༌ནི༌ ཏེ༌བོའེ༌ ཁྲག༌ ཙ༌པིག༌ ཁོ༌རང༌གུན༌ནི༌ ཟན༌ ཟའ༌སའེ༌ ཁང༌པའེ༌ སྒོའེ༌ རིབ༌ཞི༌ ཐའ༌མ༌ དང༌ སྟག༌ གུན༌ནི༌ཀ༌ སྐུ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ཏེན༌ན༌ ཚན༌ལ༌ ཤ༌བོ༌ མེ༌ཀ༌ སྲགས༌ཏེ༌ ཁན༌ཀྲེ༌ ཚ༌མིག༌ དང༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཉམ༌པོ༌ ཟ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ཤ༌བོ༌ ཤར༌ཞེན༌ ཡ༌ ཆུའི༌ ནང༌ང༌ ཙོས༌ཏེ༌ ཟའ༌ མ༌གོས༌ ཨིན༌ནའང༌ གོ༌, རྐང༌པ༌ དང༌ ནང༌ཆ༌ གུན༌ ཐེས༌ཏེ༌ ཤ༌ ཚང༌མ༌ མེའ༌ སྲགས༌ཏེ༌ ཟ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ཁྱོ༌ཞ༌གུན༌ནི༌ ཏེ༌ ནང༌ནེ༌ ཅའང༌ ང༌མོ༌ ཚོག༌པ༌ ལུས༌ཅུག༌ མ༌གོས༌, ཀལ༌ཏེས༌ ལུས༌ན༌ ཏེ༌བོ༌ མེ༌ ནང༌ང༌ སྲག༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ཏེ༌གུན༌ ཟའ༌ ཟ༌ནེ༌ ཁྱོ༌རང༌གུན༌ ཀོས༌སི༌ སྐྱེ༌རགས༌ ལྡམས༌ཏེ༌, རྐང༌པའ༌ པ༌བུ༌ གོན༌ཏེ༌ ལག༌པའེ༌ ནང༌ང༌ གྲུལ༌ཅེས༌སི༌ བེར༌ཀ༌ ཁུར༌ཏེ༌ བེས༌ལ༌ ཆ༌ཅེས༌སི༌ ཕིའ༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ གྱོགས༌པ༌ ཟ༌གོས༌, ཏེ༌བོ༌ ཡ༌ཝ༌ གོམས༌ཏེ༌ སྐྱོད༌ཁན༌ནི༌ ཏུས༌ཆེན༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ཏེན༌ན༌ ཚན༌ལ༌ ང༌ ཨི༌ཇིབ༌བི༌ ནས༌སའེ༌ ནང༌ང༌ སོང༌ཏེ༌ མི༌ དང༌ སེམས༌ཅན༌ གུན༌ནི༌ གོ༌སྐྱེས༌ བུ༌ཚ༌ ཚང༌མ༌ སད༌ཨིན༌ ཡང༌ ཨི༌ཇིབ༌པའེ༌ ལྷ༌ལྷ༌མོ༌ ཚང༌མ༌ལ༌ ཆད༌པ༌ ཏང༌ཨིན༌, ང༌ ཡ༌ཝ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","སྒོའེ༌ཀ༌ ཁྲག༌ སྐུ༌ཁན༌བོ༌ ཁྱོ༌ཞ༌གུན༌ དུག༌ཁན༌ནི༌ ཁང༌པའེ༌ སྟགས༌ ཨིན༌། ཁྲག༌ ཐོང༌ང༌ཅིག༌ ང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁང༌པ༌ གོམས༌ཏེ༌ ཆེན༌ ཡང༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ ཏང༌ཅེས༌ཅན༌ནི༌ ཆད༌པ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ མི༌ཏང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ཁྱོ༌ཞ༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཛད༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ཅོ༌ཨིན༌ འི༌ ཞག༌པོ༌ མི༌རབས༌ནེ༌ མི༌རབས༌ ལོ༌ཞུང༌, ཏུས༌ཆེན༌ནི༌ ཚུལ༌ལ༌ རྩི༌གོས༌། འི༌བོ༌ ཏུས༌གྱུན༌ནི༌ ཕིའ༌ བཀའ༌ཁྲིམས༌ཤིག༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ཞག༌པོ༌ རྡུན༌ནི༌ ཕིའ༌ ཁྱོ༌ཞ༌གུན༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཟ༌གོས༌། ཞག༌ ཏང༌པོའེ༌ ཞག༌ག༌ ཁྱོ༌རང༌གུན༌ནི༌ ཁང༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ སྐྱུར༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོས༌། འི༌ ཞག༌ རྡུན༌ནི༌ རིངས༌ལ༌ སྐྱུར༌ ཡོད༌ཁན༌ནི༌ ཏ༌གི༌ ཟའ༌ཁན༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌ ཐེ༌མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ཞག༌ ཏང༌པོ༌ དང༌ རྡུན༌པའེ༌ ཞག༌ག༌ ཁྱོ༌ཞ༌གུན༌ ཅོལ༌ཅེས༌ལ༌ ཛོམ༌གོས༌། ཏེ༌ ཞག༌གུན༌ལ༌ ཟའ༌ཅེས༌ལ༌ ཁར༌ཇི༌ གྲལ༌གྲིག༌ ཅོ༌ཅེས༌ མ༌སྟོག༌ ཞན༌ལས༌ ཅོ༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཏུས༌ཆེན༌ རྩིས༌ ཅིའ༌ཟེར༌ན༌ འིན༌ན༌ ཞག༌ག༌ ངའེ༌ ཁྱོ༌ཞའེ༌ མི༌སྡེ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོངས༌པིན༌། ཁྱོ༌ཞ༌གུན༌ནི༌ འི༌ ཞག༌པོ༌ ཏུས༌ཆེན༌ནི༌ ཚུལ༌ལ༌ མི༌རབས༌ནེ༌ མི༌རབས༌ རྩིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ཟླ༌ཝ༌ ཏང༌པོའེ༌ ཞག༌ 14 པའེ༌ ཕི༌ཏོག༌ནེ༌ ཞག༌ 21 པའེ༌ ཕི༌ཏོག༌ ཚོག༌པ༌ ཁྱོ༌ཞ༌གུན༌ སྐྱུར༌ཅན༌ནི༌ ཏ༌གི༌ ཟའ༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ཞག༌པོ༌ རྡུན༌ནི༌ ཕིའ༌ ཁྱོ༌ཞའེ༌ ཁང༌པའེ༌ ནང༌ང༌ སྐྱུར༌ ཐོབ༌ མ༌གོས༌། ཀལ༌ཏེས༌ ཏེན༌ན༌ ཡུལ༌ལ༌ སྐྱེ༌ཁན༌ ཨིས༌ར༌ཨེལ༌པ༌ ཡ༌ ཞན༌ཡུལ༌པ༌, སུ༌ཞིག༌གི༌ སྐྱུར༌ ཡོད༌ཁན༌ནི༌ ཏ༌གི༌ ཟའ༌ན༌ ཁོ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཐེ༌མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ཏེ༌ ཏུས༌ལ༌ ཁྱོ༌ཞ༌གུན༌ སྐྱུར༌ ཡོད༌ཁན༌ནི༌ ཟན༌ ཟའ༌ མ༌གོས༌། ཁྱོ༌ཞ༌གུན༌ ཀ༌རུ༌ ཚུགས༌ཏེ༌ ཡོད༌ནའང༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཟའ༌ གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","མོ༌ཟེས༌སི༌ ཨིས༌ར༌ཨེལ༌པ༌ སྤོན༌བོ༌ ཚང༌མ༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཟེརས༌, “ནང༌ཚངས༌ རེ༌རེའེ༌ ལུ༌གུ༌ ཡ༌ རི༌གུ༌ ལྡོམ༌ ཡང༌ ཏེ༌བོ༌ སད༌ཏེ༌ དཀོན༌མཆོག༌ གོམས༌ཏེ༌ སྐྱོད༌ཁན༌ནི༌ ཏུས༌ཆེན༌ རྩིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ཧི༌སོབ༌བི༌ བུར༌སའེ༌ ཁག༌ཞིག༌ ཁྲག༌གི༌ ནང༌ང༌ ཅུགས༌ཏེ༌ ཁྱོ༌ཞའེ༌ སྒོའེ༌ རིབ༌ཞི༌ ཐའ༌མ༌ དང༌ སྟག༌ གུན༌ནི༌ཀ༌ སྐུས༌། ཁྱོ༌ཞའ༌ ཅིག༌གའང༌ ང༌མོ༌ ཚོག༌པ༌ ཁང༌པ༌ནེ༌ ཕི༌ལོག༌ག༌ མ༌ཆ༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ཡ༌ཝ༌ ཨི༌ཇིབ༌པ༌གུན༌ སད༌ད༌ལ༌ སྐྱོད༌ ཟ༌ནེ༌ ཁོང༌ངི༌ སྒོའེ༌ རིབ༌ཞི༌ ཐའ༌མ༌ དང༌ སྟག༌ གུན༌ནི༌ཀ༌ ཁྲག༌ ཟིགས༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁང༌པ༌ གོམས༌ཏེ༌ སྐྱོད༌ཨིན༌ ཡང༌ ཤི༌ཅུག༌ཁན༌ནི༌ ཕོ༌ཉ༌ ཁྱོ༌ཞའེ༌ ཁང༌པའེ༌ ནང༌ང༌ ཆ༌ཅུག༌ག༌ མ༌ཛད༌ད༌ ཁྱོ༌ཞ༌གུན༌ སྐྱོབ༌བ༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“ཁྱོ༌ཞའ༌ དང༌ ཁྱོ༌ཞའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ཏེ༌བོ༌ ཏུས༌ཆེན༌ནི༌ ཚུལ༌ལ༌ ཏུས༌གྱུན༌ རྩི༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ཡ༌ཝའེ༌ ཞལ༌ཆད༌ ཛད༌ཁན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱོ༌ཞ༌གུན༌ ལེབས༌ཏེ༌ སྟིང༌ནེའང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ འི༌ ཏུས༌ཆེན༌བོ༌ རྩི༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ཁྱོ༌ཞའེ༌ ཕྲུ༌གུ༌གུན༌ནི༌ ‘འི༌ ཏུས༌ཆེན༌བོ༌ ཅི༌ ཨིན༌ནོག༌’ ཟེར༌ཏེ༌ ཏྲི༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ཁོང༌གུན༌ལ༌ ཤོད༌, ‘འི༌བོ༌ ཡ༌ཝའ༌ གོམས༌ཏེ༌ སྐྱོད༌ཁན༌ནི༌ ཏུས༌ཆེན༌ནི༌ སྲོག༌ཆོད༌པོ༌ ཨིན༌ནོག༌, ཅིའ༌ཟེར༌ན༌ ཁོང༌ངི༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ ཆད༌པ༌ སལ༌ ཟ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཡོད༌ཁན༌གུན༌ནི༌ ཁང༌པའེ༌ ཀ༌ནེ༌ གོམས༌ཏེ༌ སྐྱོད༌།’” ཏེ༌ནེ༌ མི༌ཚང༌མའེ༌ ས༌ ཐུག༌ ཅུགས༌ཏེ༌ གོ༌ སྒུས༌ཏེ༌ ཡ༌ཝའ༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ཡ༌ཝའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ཚན༌ སྐྱིལ༌ལ༌ ཡ༌ཝའེ༌ ཨི༌ཇིབ༌བི༌ ས༌ཆའེ༌ ནང༌ང༌ གོ༌སྐྱེས༌ བུ༌ཚ༌གུན༌ སད༌ད༌ ཛདས༌, ཁྲིས༌ ཐོབ༌ཅེས༌ཅན༌ནི༌ གྱལ༌པོའེ༌ བུ༌ཚ༌ནེ༌ ཏངས༌ཏེ༌ ཙོན༌པའེ༌ གོ༌སྐྱེས༌ བུ༌ཚ༌ ཚོག༌པ༌, ཡང༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌གུན༌ནི༌ གོ༌སྐྱེས༌ ཕོ༌གུན༌ནའང༌ སད༌ད༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ཏེན༌ན༌ ཚན༌ལ༌ གྱལ༌པོ༌, ཁོའེ༌ སྤོན༌བོ༌གུན༌ དང༌ ཨི༌ཇིབ༌པ༌ ཚང༌མ༌ ལངས༌ ཡང༌ ཨི༌ཇིབ༌ གང༌པོའེ༌ ནང༌ང༌ ངུ༌སྐད༌ ཀྲག༌པོ༌ ཚོར༌ ཅིའ༌ཟེར༌ན༌ ཕྲུ༌གུ༌ མ༌ཤི༌ཁན༌ནི༌ ཁང༌པ༌ ཅིག༌གའང༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ཏེན༌ན༌ ཚན༌ལ༌ གྱལ༌པོའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཟེརས༌, “ཁྱོ༌ཞའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ངའེ༌ ཡུལ༌ནེ༌ བིང༌ཏེ༌ སོང༌། ཁྱོ༌ཞའེ༌ ཟེར༌ཁན༌ ནང༌ཞིན༌ ཡ༌ཝའ༌ ཅོལ༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ཁྱོ༌ཞའེ༌ ར༌ལུག༌ དང༌ ཞན༌ སེམས༌ཅན༌གུན༌ ཁྲིད༌ཏེ༌ ངའེ༌ ཡུལ༌ནེ༌ བིང༌ཏེ༌ སོང༌ ཡང༌ ངའང༌ ཅིན༌ལབས༌ སལ༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ གྱོགས༌པ༌ ཁོང༌ངི༌ ཡུལ༌ནེ༌ ཆ༌ཅེས༌ལ༌ འུ༌ཙུག༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ མ༌ཆའ༌ན༌ ང༌ཞའ༌ ཚང༌མ༌ ཤིའ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱུར༌ མ༌ཏང༌ཁན༌ནི༌ པག༌པའེ༌ ལག༌ཕིས༌སི༌ ནང༌ང༌ ཏུམས༌ཏེ༌ ལ༌གིན༌ནི༌ ནང༌ང༌ ཁོང༌རང༌གུན༌ནི༌ སྤུང༌པའེ༌ཀ༌ ཁུར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མོ༌ཟེས༌སི༌ མོལ༌ཁན༌ ནང༌ཞིན༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ སེར༌ དང༌ མུལ༌ལི༌ ཅ༌ལག༌ དང༌ ཀོས༌ལག༌ གུན༌ ཏོང༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཆོགས༌སྐྱོར༌ ཐོབ༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཏོང༌ ཟེར༌ཁན༌ ཚང༌མ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཏངས༌། ཏེན༌ན༌ཟུག༌གི༌ ཁོང༌གུན༌ནི༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ གྱུ༌ནོར༌གུན༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ རམ༌སིས༌སི༌ གྱལ༌ས༌ནེ༌ སུ༌ཀོད༌དི༌ གྱལ༌ས༌ སོང༌། ལག༌ དྲུག༌གི༌ མི༌ གྲུལ༌ཏེ༌ སོང༌ ཏེ༌ནང༌ང༌ ཕྲུ༌གུ༌ དང༌ བུ༌མོ༌ གུན༌ མ༌ཐེའ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ཨིས༌ར༌ཨེལ༌པ༌ མན༌ཁན༌ནི༌ མི༌ མང༌པོ༌ ཁོང༌ ཉམ༌པོ༌ སོང༌, ར༌ལུག༌ དང༌ ཞན༌ སེམས༌ཅན༌ནི༌ ཁྱུ༌ མང༌པོའང༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ཁོང༌གུན༌ནི༌ ཨི༌ཇིབ༌ནེ༌ ཁྱོང༌ཁན༌ནི༌ པག༌པའེ༌ སྐྱུར༌ མེད༌ཁན༌གུན༌ལ༌ ཏ༌གི༌ ཅོས༌། པག༌པའེ༌ ནང༌ང༌ སྐྱུར༌ མེད༌པིན༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ ཨི༌ཇིབ༌ནེ༌ གྱོགས༌པ༌ བིང༌གོས༌པ༌ ཁོང༌གུན༌ལ༌ ཟན༌ གྲལ༌གྲིག༌ ཅོ༌ཅེས༌སི༌ ཏུས༌ མ༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ལོ༌ 430 དུགས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ལོ༌ 430 སྟིང༌ཇུག༌གི༌ ཞག༌ག༌ ཡ༌ཝའེ༌ མི༌སྡེ༌ ཚང༌མ༌ ཨི༌ཇིབ༌ནེ༌ བིངས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ཏེ༌ ཚན༌ལ༌ ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱོབས༌ཏེ༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱེར༌ར༌ ཛདས༌། ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ མི༌རབས༌ནེ༌ མི༌རབས༌ ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ ཡ༌ཝའེ༌ སྐྱོབས༌ཏེ༌ ཕིང༌ང༌ ཛད༌ཁན༌ནི༌ ཚན༌བོ༌ ཨིད༌ཏུ༌ ཅོ༌ཨིན༌ ལོ༌ཞུང༌ རྩི༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ཡ༌ཝའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ མོལས༌, “འི༌གུན༌ པེ༌སག༌གི༌ ཏུས༌ཆེན༌ནི༌ ཁྲིམས༌གུན༌ ཨིན༌:” “ཞན༌ཡུལ༌ལི༌ མི༌ སུ༌ཞིག༌གའང༌ པེ༌སག༌གི༌ ཁར༌ཇི༌ ཟའ༌ མི༌ཆོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ཁྱོ༌ཞའེ༌ ཉོས༌ཁན༌ ཚེ༌ཡོག༌གུན༌ནི༌ ཀལ༌ཏེས༌ སུན༌ནད༌ ཅོས༌ཏེ༌ ཨིན༌ན༌ ཏེ༌བོ༌ ཟའ༌ནའང༌ གྲིག༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","སྐབ༌སྟོགས༌སི༌ ཕིའ༌ ཁྱོ༌ཞའེ༌ ཡུལ༌ལ༌ དུག༌ཁན༌ནི༌ མི༌ དང༌ ལ༌པ༌ གུན༌ནི༌ ཟའ༌ མི༌ཆོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ཤ༌བོ༌ ཁང༌པའེ༌ ནང༌ང༌ ཟ༌གོས༌ ཏེ༌བོ༌ ཁང༌པ༌ནེ༌ ཕི༌ལོག༌ག༌ ཁྱེར༌ མ༌གོས༌ ཡང༌ རུས༌པ༌ ཅིག༌གའང༌ ཅག༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ཨིས༌ར༌ཨེལ༌པ༌ མི༌ཚོགས༌ གང༌པོའེ༌ འི༌ གའ༌སྟོན༌ རྩི༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“ཨིན༌ནའང༌ ཡ༌ཝ༌ གོམས༌ཏེ༌ སྐྱོད༌ཁན༌ནི༌ གའ༌སྟོན༌ རྩིའ༌ ཐད༌ཁན༌ ཞན༌ཡུལ༌པ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ནང༌ཚངས༌སི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ བུ༌ཚ༌ ཚང༌མའ༌ སུན༌ནད༌ ཅོ༌གོས༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ ཏེན༌ན༌རུ༌ སྐྱེ༌ཁན༌ ཨིས༌ར༌ཨེལ༌པ༌ ཙོགས༌ གྱུར༌ཏེ༌ གའ༌སྟོན༌ནི༌ ནང༌ང༌ ཐུས༌ནའང༌ གྲིག༌ཏེ༌ ཨིན༌ནོག༌། ཨིན༌ནའང༌ སུན༌ནད༌ མ༌ཅོ༌ཁན༌གུན༌ནི༌ ཏེ༌ ཤ༌ ཟའ༌ མི༌ཆོགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ཏེན༌ན༌ བཀའ༌ཁྲིམས༌གུན༌ ཏེ༌རུ༌ སྐྱེས༌ཁན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ དང༌ ཁྱོ༌ཞའེ༌ ཕྲོའ༌ ཡོད༌ཁན༌ནི༌ ཞན༌ཡུལ༌ལི༌ མི༌གུན༌ནི༌ ཕིའང༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ཡང༌ ཏེན༌ན༌ ཞག༌ག༌ ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྡེ༌ སྡེ༌ ནང༌ང༌ ཨི༌ཇིབ༌ནེ༌ ཕིང༌ཏེ༌ ཁྱོང༌ང༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“གོ༌སྐྱེས༌ བུ༌ཚ༌ ཚང༌མ༌ ངའེ༌ ཕིའ༌ ཕེ༌གོས༌, ཨིས༌ར༌ཨེལ༌པ༌ མི༌ དང༌ སེམས༌ཅན༌ གུན༌ནི༌ གོ༌སྐྱེས༌ བུ༌ཚ༌ ཚང༌མ༌ ངའེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌བི༌ ཚེ༌ཡོག༌ནེ༌ བིངས༌ཏེ༌ ཡོང༌ཁན༌ནི༌ འི༌ ཞག༌པོ༌ ཏུས༌གྱུན༌ ཨིད༌ཏུ༌ བོར༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ ཁྱུད༌ ཉམ༌པོ༌ ཁྱོ༌ཞ༌གུན༌ ཏེ༌ནང༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛདས༌། སྐྱུར༌ ཡོད༌ཁན༌ ཟན༌ མ༌ཟའ༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","དི༌རིང༌ ཨ༌བིབ༌ ཟླ༌ཝའེ༌ གོ༌མའེ༌ ཞག༌ག༌ ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ བིངས༌ཏེ༌ ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ཡ༌ཝའེ༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ལ༌ འོ༌མ༌ དང༌ རང༌རྩི༌ གྱུག༌སའེ༌ ཀེ༌ནན༌པ༌གུན༌, ཧེད༌པ༌གུན༌, ཨ༌མོར༌པ༌གུན༌, ཧིཝ༌པ༌གུན༌ དང༌ ཡེ༌བས༌པ༌གུན༌ནི༌ ས༌ཆ༌ ཏང༌ཅེས༌ལ༌ ནའ༌ ཁུར༌ར༌ ཛད༌ཁན༌བོའེ༌ ནང༌ང༌ ཁྱེར༌ར༌ ཛད༌ད༌ཅིག༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ལོ༌ཞུང༌ ཟླ༌ཝ༌ ཏང༌པོའེ༌ ནང༌ང༌ འི༌ གའ༌སྟོན༌བོ༌ རྩི༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ཞག༌པོ༌ རྡུན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཟ༌གོས༌ ཡང༌ ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ ཡ༌ཝའེ༌ རྩི༌ཝའེ༌ ནང༌ང༌ གའ༌སྟོན༌ རྩིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ཏེ༌ ཞག༌མ༌ རྡུན༌ ཁྱོ༌ཞའ༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཟ༌གོས༌། ཁྱོ༌ཞའེ༌ ས༌ཆ༌ གང༌པོའེ༌ ནང༌ང༌ སྐྱུར༌ ཡོད༌ཁན༌ ཅི༌ཞིག༌གའང༌ ཡོང༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“ཏེ༌ ཞག༌ག༌ ཁྱོ༌ཞའེ༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཕྲུ༌གུ༌གུན༌ལ༌ ཤོད༌, ‘ང༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ ཛད༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ཅོ༌ཨིན༌ ངའེ༌ འི༌ གའ༌སྟོན༌ རྩིའད༌།’ ");
INSERT INTO lbj_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","འི༌ གའ༌སྟོན༌ རྩི༌ཅེས༌པོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ལག༌པ༌ དང༌ ཐོད༌པའེ༌ཀ༌ སྟགས༌ ཙོགས༌ ཨིན༌། ཏེ༌བོའེ༌ ཁྱོ༌ཞ༌གུན༌ ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ ཁྱུད༌ཅན༌ ཆག༌གི༌ ཡོག༌ག༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཁན༌བོ༌ ཤད༌ཅེས༌ལ༌ ཨིད༌ཏུ༌ སྐུལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","འི༌ གའ༌སྟོན༌བོ༌ ལོ༌ཞུང༌ འིན༌ན༌ ཏུས༌ལ༌ རྩི༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌ དང༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ལ༌ ནའ༌ ཁུར༌ར༌ ཛད༌ཁན༌ ནང༌ཞིན༌ ཁྱོ༌ཞའ༌ ཀེ༌ནན༌པ༌གུན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱོང༌ང༌ ཛད༌ཏེ༌ སྟིང༌ནེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ཁྱོ༌ཞ༌གུན༌ནི༌ བུ༌ཚ༌ གོ༌སྐྱེས༌ དང༌ ཁྱོ༌ཞའེ༌ སེམས༌ཅན༌གུན༌ནི༌ གོ༌སྐྱེས༌ ཕོ༌ ཚང༌མ༌ ཡ༌ཝའ༌ ཕུལ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ ཚང༌མ༌ ཡ༌ཝའེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ཨིན༌ནའང༌ ཁྱོ༌རང༌གུན༌ནི༌ ཁོང༌ངི༌ ཀ༌ནེ༌ གོ༌སྐྱེས༌ བུང༌བུ༌ ཕོ༌ ཚང༌མ༌ ཏེ༌བོའེ༌ ཚབས༌ལ༌ ལུ༌གུ༌ ཞིག༌ ཆོད༌པ༌ ཕུལ༌ཏེ༌ ལོགས༌ཏེ༌ ཉོ༌ཉན༌ ཨིན༌། ཀལ༌ཏེས༌ ལོགས༌ཏེ༌ མ༌ཉོ༌ན༌ ཏེ༌བོའེ༌ ཇིང༌བ༌ ཅགས༌ཏེ༌ སོད༌། ཁྱོ༌ཞ༌གུན༌ནི༌ གོ༌སྐྱེས༌ ཕྲུ༌གུ༌ བུ༌ཚ༌ ཚང༌མ༌ ལོགས༌ཏེ༌ ཉོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ཡོང༌ཅེས༌ཅན༌ནི༌ ཏུས༌སི༌ ནང༌ང༌ ཁྱོ༌ཞའེ༌ ཕྲུ༌གུ༌གུན༌ནི༌ འི༌ ཏོན༌ ཅི༌ ཨིན༌ནོག༌ ཟེར༌ཏེ༌ ཏྲི༌ན༌, ཁྱོ༌ཞ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཟེར༌, ‘ཡ༌ཝའ༌ ཁྱུད༌ཅན༌ནི༌ ང༌དང༌གུན༌ ཨི༌ཇིབ༌བི༌ ཚེ༌ཡོག༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ སྙིང༌སྐྱོང༌པོ༌ གྱུར༌ཏེ༌ ང༌ཞ༌གུན༌ ཆ༌ མ༌ཅུག༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ མི༌ དང༌ སེམས༌ཅན༌ནི༌ གོ༌སྐྱེས༌ བུ༌ཚ༌ ཚང༌མ༌ སད༌ད༌ ཛད༌། ཏེ༌ གྱུན༌ཚན༌ནི༌ ཕིའ༌ ང༌ཞའེ༌ སེམས༌ཅན༌ནི༌ གོ༌སྐྱེས༌ བུ༌ཚ༌ ཚང༌མ༌ ཡ༌ཝའ༌ ཕུལ༌ལད༌ ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ཀ༌ནེ༌ ང༌ཞའེ༌ ང༌ཞ༌རང༌ངི༌ གོ༌སྐྱེས༌ བུ༌ཚ༌གུན༌ ལོགས༌ཏེ༌ ཉོ༌གོས༌།’ ");
INSERT INTO lbj_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ ཁྱུད༌ ཉམ༌པོ༌ ང༌དང༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཁན༌བོ༌ ཨིད༌ཏུ༌ བོར༌ཅེས༌ལ༌ འི༌བོ༌ ང༌དང༌གུན༌ནི༌ ལག༌པ༌ དང༌ ཐོད༌པའི༌ཀ༌ སྟགས༌ ཙོགས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ མི༌གུན༌ ཆ༌ཅུག༌ག༌ཅིག༌, དཀོན༌མཆོག༌གི༌ ཁོང༌གུན༌ ཕི༌ལིས༌ཏི༌པའེ༌ ས༌ཆའེ༌ ལམ༌ནེ༌ ཁྲིད༌ཏེ༌ ཁྱེར༌ར༌ མ༌ཛདས༌, ཞན༌ ཏེ༌ ལམ༌བོ༌ ཉེ༌ཤོག༌པོ༌ ཨིན༌པིན༌། དཀོན༌མཆོག༌གི༌ མོལས༌, “མག༌ ཏང༌གོས༌ན༌ མི༌གུན༌ནི༌ སམ༌བ༌ གྱུར༌ཏེ༌ ཁོང༌གུན༌ ལོགས༌ཏེ༌ ཨི༌ཇིབ༌བ༌ ཆ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌ངི༌ ཁོང༌གུན༌ ཐང༌སྟོང༌ གྱུད༌ཏེ༌ ཚོ༌ མར༌པོ༌ ཆོགས༌ལ༌ ཁྱེར༌ར༌ ཛདས༌། ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མག༌ ཏང༌ཅེས༌ལ༌ ལག༌ཆ༌ ཁུར༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","མོ༌ཟེས༌སི༌ ཡོ༌སེབ༌བི༌ རུས༌པ༌གུན༌ ཁུརས༌ ཅིའ༌ཟེར༌ན༌ ཡོ༌སེབ༌བི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ནའ༌ ཁུར༌ཅུགས༌ཏེ༌ ཟེརས༌, “དཀོན༌མཆོག༌གི༌ རོགས༌ ཛད༌ཏེ༌ ཁྱོ༌ཞའ༌ ཐར༌ཅུག༌ ཟ༌ནེ༌ ཁྱོ༌ཞའེ༌ ངའེ༌ རུས༌པ༌གུན༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ འི༌ ས༌ཆ༌ནེ༌ ཁྱེར༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","སུ༌ཀོད༌ནེ༌ བིང༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཐང༌སྟོང༌ངི༌ ཟུར༌ལ༌ ཨི༌ཐམ༌ ཟེར༌སའེ༌ ས༌ཆའེ༌ཀ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ཡ༌ཝའ༌ ཉི༌མའ༌ ལམ༌སྟན༌ཁན༌ སྲིན༌ནི༌ ཀ༌ཝ༌ ཡང༌ ཚན༌ལ༌ འོད༌ ཏང༌ཁན༌ མེའེ༌ ཀ༌ཝ༌ ཙོགས༌ལ༌ ཁོང༌གུན༌ནི༌ སྔུན༌སྔུན༌ལ༌ སྐྱོདས༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ ཉི༌མ༌ དང༌ ཚན༌ ཉིས༌ཀོ༌ གྲུལ༌ཐུབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ཉི༌མ༌ སྲིན༌ དང༌ ཚན༌ལ༌ མེའེ༌ ཀ༌ཝ༌ ཏུས༌གྱུན༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ལོགས༌ཏེ༌ ཡོངས༌ཏེ༌ མིག༌དོལ༌ དང༌ ཚོའེ༌ པར༌ལ༌ པི༌ཧ༌ཧི༌རོཐ༌ གྲོང༌ཁྱེར༌རི༌ དུན༌ལ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུག༌ ཟེར༌ ཀ༌བོ༌ བའལ༌ ཟེ༌ཕོན༌ གྲོང༌ཁྱེར༌རི༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","གྱལ༌པོའེ༌ སམ༌ཨིན༌, ‘ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཁད༌ཏེ༌ ཀ༌ངོའ༌ ཆ༌ཅེན༌ ཧ༌མ༌གོའ༌ ཁོར༌རད༌གྲོ༌།’ ");
INSERT INTO lbj_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ངའེ༌ ཡང༌སྐྱར༌ ཁོའེ༌ སྙིང༌སྐྱོང༌པོ༌ ཅོ༌ཨིན༌ ཡང༌ ཁོའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ རྡས༌ཏེ༌ ཁྱོང༌ཨིན༌, ཨིན༌ནའང༌ གྱལ༌པོ༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ གྱུད༌ཏེ༌ ངའ༌ སྤལ༌ ཐོབ༌ཨིན༌ ཡང༌ ང༌ ཡ༌ཝ༌ ཨིན༌ཁན༌བོ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཤེས༌ཨིན༌།” ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌ངི༌ མོལ༌ཁན༌བོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ཨི༌ཇིབ༌བི༌ གྱལ༌པོའ༌ མི༌གུན༌ ཤོར༌ཏོག༌ ཟེར༌ཏེ༌ ཚོར༌ར༌ཅིག༌, ཁོ༌ དང༌ ཁོའེ༌ སྤོན༌བོ༌གུན༌ནི༌ སམ༌བ༌ གྱུར༌ཏེ༌ ཟེརས༌, “ང༌དང༌ངི༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌? ང༌དང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཆ༌ཅུགས༌ཏེ༌ ང༌དང༌ངི༌ ཕིའ༌ ལས༌ ཅོ༌ཁན༌གུན༌ པུད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ཏེ༌བོའེ༌ཕིའ༌ གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ རྟ༌རེལ༌ གྲལ༌གྲིག༌ ཅོ༌ཅུགས༌ཏེ༌ མག༌མི༌གུན༌ ཁྲིད༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ཁོའེ༌ ཚང༌མའེ༌སང༌ གྱལ༌ལ༌ རྟ༌རེལ༌ དྲུག༌རྒྱ༌ དང༌ ཨི༌ཇིབ༌བི༌ ཞན༌ རྟ༌རེལ༌ ཚང༌མ༌ ཁོང༌རང༌ ཉམ༌པོ༌ ཁྱེརས༌ ཀ༌གུན༌ནི༌ ནང༌ང༌ མག༌སྤོན༌ དང༌ ཞན༌ མག༌མི༌གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ཡ༌ཝའེ༌ གྱལ༌པོའེ༌ སྙིང༌སྐྱོང༌པོ༌ གྱུར༌ཅུག༌ག༌ ཛད༌ པ༌སང༌ ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ རྡས༌ཏེ༌ ཁྱེརས༌ ཀ༌གུན༌ མ༌ ཧམ༌པ༌ ཉམ༌པོ༌ གྲུལ༌ཏེ༌ ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ཨི༌ཇིབ༌པ༌ རྟ༌རེལ༌ དང༌ རྟའེ༌ཀ༌ ཞོན༌ཁན༌ ཡང༌ མ༌ཞོན༌ཁན༌ནི༌ གྱལ༌པོའེ༌ མག༌མི༌ ཚང༌མའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ རྡས༌ཏེ༌ ཁྱེརས༌ ཡང༌ བའལ༌ ཟེ༌ཕོན༌ གྲོང༌ཁྱེར༌རི༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཚོའེ༌ ཐའ༌མ༌ པི༌ཧ༌ཧི༌རོཐ༌ གྲོང༌ཁྱེར༌རི༌ ཉེ༌མོའ༌ ཀུར༌ ཏངས༌ཏེ༌ དུག༌ཏེ༌ ཡོད༌སའེ༌ཀ༌ ཁོང༌གུན༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱལ༌པོ༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ ཁོང༌གུན༌ ཆོགས༌ལ༌ ཡོང༌ང༌ ཐོང༌ང༌ཅིག༌ ཁོང༌གུན༌ སྲན༌ཏྲེ༌ ཇིགས༌ ཡང༌ ཡ༌ཝའ༌ རོགས༌ ཛད༌ཅེས༌ལ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ཁོང༌གུན༌ནི༌ མོ༌ཟེས༌ལ༌ ཟེརས༌, “ང༌ཞ༌གུན༌ འི༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཤི༌ཅུག༌ག༌ ཁྱོངས༌ཏེ༌ ཅི༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ རོམ༌ཁང༌ངི༌ ས༌ཀྱད༌ མེད༌ཏེ༌ ཨིན༌ནོག༌ག༌? ཉེ༌རང༌ངི༌ ང༌ཞ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོངས༌ཏེ༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ང༌ཞའེ༌ ཟེར༌ར༌ མེ༌རག༌ག༌ ང༌ཞའ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཡོག༌པོ༌ ཅོ༌ཨིན༌ དུག༌ཅུག༌། འི༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཤིའ༌སང༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ ཞབས༌ཏོག༌ ཅོ༌ཨིན༌ དུགས༌པིན༌ན༌ གྱལ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ ལན༌ཏངས༌, “ཇིགས༌ མ༌ཇིགས༌, ཁྱོ༌ཞ༌གུན༌ནི༌ སེམ༌སྟོབས༌ ཅོས༌ཏེ༌, དི༌རིང༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ ཀ༌ཟུག༌གི༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌བ༌ ཛད༌དུག༌ ལྟོས༌། དི༌རིང༌ ཐོང༌ཁན༌ནི༌ ཨི༌ཇིབ༌པ༌གུན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཡང༌སྐྱར༌ མ༌ནེ༌ མི༌ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕིའ༌ ནོལ༌ལ༌ ཛད༌ཨིན༌། ཁྱོ༌ཞ༌གུན༌ ཅུབ༌ཅད༌ཏེ༌ ཞི༌དེའེ༌ ཉམ༌པོ༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ རོགས༌ ཅོ༌ཅེས༌ལ༌ ཅིའ༌ ཞུའད༌? མི༌གུན༌ལ༌ གྲུལ༌ཅེས༌ལ༌ ཟེར༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ཁྱོ༌རང༌ངི༌ བེར༌ཀ༌ སྟག༌ཏེ༌ རང༌ངི༌ ལག༌པ༌ ཚོའེ༌ཀ༌ སྐྱོང༌། ཏེ༌ནེ༌ ཆུ༌ བེ༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཚོའེ༌ སྐྱིལ༌ནེ༌ ས༌སྐམ༌པོའེ༌ ཀ༌ནེ༌ གྲུལ༌ཏེ༌ ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ སྙིང༌སྐྱོང༌པོ༌ གྱུར༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ ཁྱོ༌ཞའེ༌ སྟིང༌རང༌ནེ༌ ཡོང༌ཅུག༌ཨིན༌, ཡང༌ གྱལ༌པོ༌ དང༌ ཁོའེ༌ མག༌མི༌, རྟ༌རེལ༌ དང༌ རྟའེ༌ཀ༌ ཞོན༌ཁན༌ དང༌ གྲུལ༌ཁན༌ ཚང༌མ༌ གྱུད༌ཏེ༌ ངའ༌ སྤལ༌ ཐོབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","གྱལ༌པོ༌, ཁོའེ༌ རྟ༌རེལ༌ དང༌ རྟའེ༌ཀ༌ ཞོན༌ཁན༌ གུན༌ གྱུད༌ཏེ༌ ངའ༌ སྤལ༌ ཐོབ༌བ༌ཅིག༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ང༌ ཡ༌ཝ༌ ཨིན༌ཁན༌བོ༌ ཤེས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྔུན༌སྔུན༌ལ༌ སྐྱོད༌ཁན༌ནི༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉ༌བོ༌ ཁོང༌གུན༌ནི༌ ཇུག༌ག༌ སྐྱོད༌པ༌ སྲིན༌ནི༌ ཀ༌ཝ༌, དུན༌ནེ༌ སྐྱོད༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཇུག༌ག༌ ");
INSERT INTO lbj_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ཨི༌ཇིབ༌པ༌ མག༌མི༌གུན༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ པར༌ལ༌ ཞུགས༌། སྲིན༌བོའེ༌ ཚན༌ གང༌པོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཆོགས༌ལ༌ འོད༌ སལས༌ ཡང༌ ཨི༌ཇིབ༌པ༌གུན༌ ཆོགས༌ལ༌ མུན༌གྲིག༌ ཛདས༌། ཏེ༌བོའེ༌ཕིའ༌ ལྡལ༌དོ༌ ཉིས༌ཀོ༌ནེ༌ སུའང༌ ཅིག༌ དང༌ ཅིག༌གི༌ ཉེ༌མོའ༌ ཡོང༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཚོའེ༌ཀ༌ རྐྱངས༌ ཡང༌ ཡ༌ཝའེ༌ ཚན༌ གང༌པོ༌ ཤར༌ ཆོགས༌སི༌ ལུངས༌པོ༌ ཤེད༌ཅན༌ ཉམ༌པོ༌ ཚོའེ༌ ཆུ༌ གྱབ༌ལོག༌ག༌ ཁྱེར༌ར༌ ཛདས༌། གྱ༌ཚོ༌ བེ༌ཏེ༌ ས༌སྐམ༌པོ༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ས༌སྐམ༌པོའེ༌ ཀ༌ནེ༌ གྱ༌ཚོ༌ རྒལ༌ཏེ༌ སོང༌, ཁོང༌གུན༌ནི༌ ཆོགས༌ ཉིས༌ཀོའ༌ ཆུའི༌ རྩིག༌པ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ རྡས༌ཏེ༌ ཁྱོངས༌, གྱལ༌པོའེ༌ མག༌མི༌ རྟ༌ དང༌ རྟ༌རེལ༌ གུན༌ནི༌ཀ༌ ཞོན༌ཁན༌ ཚང༌མའ༌ ཚོའེ༌ ནང༌ང༌ ཁོང༌གུན༌ནི༌ གྱབ༌ནེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ནམ༌ ལངས༌སི༌ སང༌ སྔུན༌ལ༌ ཡ༌ཝའེ༌ མེ༌ དང༌ སྲིན༌ནི༌ ཀ༌ཝའེ༌ ནང༌ནེ༌ ཐུར༌ལ༌ ཛིགས༌ཏེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ནང༌ང༌ ཇིགས༌ནང༌ དང༌ ཐེ༌ཚོམས༌ སྐྱེ༌ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ཁོང༌ངི༌ ཁོང༌གུན༌ནི༌ རྟ༌རེལ༌ལི༌ ཁོར༌ལོ༌གུན༌ གད༌ཅུག༌ག༌ ཛདས༌པ༌ ཁོང༌གུན༌ལ༌ ཏེ༌གུན༌ སྲུལ༌ཅེས༌ལ༌ སྲན༌ཏྲེ༌ ནགས༌ ཐོང༌། ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཟེརས༌, “ང༌དང༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཤོར༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ཕིའ༌ ང༌དང༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཡ༌ཝའེ༌ ནོལ༌ལ༌ ཛད༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ལག༌པ༌ ཚོའེ༌ཀ༌ སྐྱོང༌ ཏེ༌ནེ༌ ཆུ༌ ལོགས༌ཏེ༌ ཡོངས༌ཏེ༌ ཨི༌ཇིབ༌པ༌གུན༌, ཁོང༌གུན༌ནི༌ རྟ༌རེལ༌ དང༌ རྟའེ༌ཀ༌ ཞོན༌ཁན༌གུན༌ ཆུའི༌ ཀབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཚོའེ༌ཀ༌ རྐྱངས༌ ཡང༌ ཉི༌མ༌ ཤར༌ ཟ༌ནེ༌ ཆུ༌ སྔུན༌ནི༌ མལ༌ལ༌ ལོགས༌ཏེ༌ སོང༌། ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཆུ༌ནེ༌ ཕི༌ལོག༌ག༌ ཤོར༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོས༌ ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ཆུ༌ གྱབས༌ཏེ༌ ཁོང༌གུན༌ ཚོའེ༌ ནང༌ང༌ ནུབ༌ ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ཆུ༌ ལོགས༌ཏེ༌ ཡོངས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ ཚོའེ༌ ནང༌ང༌ ཡོང༌ཁན༌ནི༌ གྱལ༌པོའེ༌ མག༌མི༌, རྟ༌རེལ༌ དང༌ རྟ༌ གུན༌ནི༌ཀ༌ ཞོན༌ཁན༌ ཡང༌ ཞན༌ ཚང༌མ༌ ཆུའི༌ ནང༌ང༌ ནུབ༌ཏེ༌ ཤི༌། ཁོང༌གུན༌ནི༌ ནང༌ནེ༌ ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ཨིན༌ནའང༌ ཚོ༌ གྱུད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ས༌སྐམ༌པོའེ༌ ཀ༌ནེ༌ གྲུལ༌ཏེ༌ སོང༌, ཁོང༌གུན༌ནི༌ ཆོགས༌ ཉིས༌ཀོའ༌ ཆུའི༌ རྩིག༌པ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ཏེ༌ ཞག༌ག༌ ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌བ༌ ཛདས༌, ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཨི༌ཇིབ༌པ༌ ཤི༌ཁན༌གུན༌ནི༌ རོ༌ ཚོའེ༌ ཐའ༌མའ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཁོང༌རང༌ངི༌ ཀྲག༌པོ༌ ཝང༌ ཀོལ༌ལ༌ ཐོང༌ཏེ༌ ཇིགས༌ དང༌ རྩི༌ཝའེ༌ ནང༌ང༌ ཁོང༌ དང༌ ཁོང༌ངི༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ཀ༌ ཏད༌པ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ཏེ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའ༌ སྟོད༌པ༌ ཕུལ༌ཨིན༌ ལུ༌ ཏངས༌: “ངའེ༌ ཡ༌ཝའ༌ སྟོད༌པའེ༌ ལུ༌ ཏང༌ངད༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ངི༌ གྱལ༌ཁ༌ སྤལ༌ཅན༌ ལེནས༌། ཁོང༌ངི༌ རྟ༌ དང༌ ཏེ༌ཀ༌ ཞོན༌ཁན༌ ཚང༌མ༌ ཚོའེ༌ ནང༌ང༌ ཕང༌ང༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ཡ༌ཝ༌ ནི༌ ངའེ༌ ཤེད༌ ཡང༌ ཁོང༌ང༌ ངའེ༌ སྟོད༌པའེ༌ ལུ༌ ཕུལ༌ཨིན༌, ཁོང༌ ངའེ༌ ཐར༌པ༌བོ༌ གྱུར༌ར༌ ཛདས༌, ཁོང༌ ངའེ༌ དཀོན༌མཆོག༌ ཡང༌ ངའེ༌ ཁོང༌ང༌ སྟོད༌པ༌ ཕུལ༌ལད༌, ངའེ༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌, ངའེ༌ ཁོང༌ང༌ སྟོད༌པ༌ ཕུལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ཁོང༌ མག༌མི༌ ཀྲག༌པོ༌ ཞུགས༌ཏེ༌, ཁོང༌ངི༌ ཚན༌ ཡ༌ཝ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ཁོང༌ངི༌ གྱལ༌པོའེ༌ མག༌མི༌ དང༌ རྟ༌རེལ༌ གུན༌ ཚོའེ༌ ནང༌ང༌ ཕང༌ང༌ ཛདས༌། གྱལ༌པོའེ༌ མག༌མི༌ གྱལ༌ལ༌ ཚང༌མ༌ ཚོ༌ མར༌པོའེ༌ ནང༌ང༌ ནུབ༌ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ཚོའེ༌ ཆུ༌ ཏིང༌ཅན༌ནི༌ ཁོང༌གུན༌ ཀབས༌, ཁོང༌གུན༌ རྡོའ༌ ཙོགས༌ལ༌ ཐིལ༌ལ༌ ནུབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ཡ༌ཝ༌ ཉེ༌རང༌ངི༌ ཆག༌ ཡས༌པ༌ མ༌ སྟོབས༌ཅན༌, ཡ༌ཝ༌, ཉེ༌རང༌ངི༌ ཆག༌ ཡས༌པའེ༌ གྲ༌འོ༌ ཚང༌མ༌ ཁྲེས༌ཏོར༌ ཅོའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ཉེ༌རང༌ངི༌ ཟིར༌རྗིད༌ ཀྲག༌པོའེ༌ ནང༌ང༌ ཉེ༌རང༌ངི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ཁན༌གུན༌ལ༌ ཕམ༌ཀལ༌ལ༌ ཛདས༌། ཉེ༌རང༌ངི༌ ཐུགས༌སྲོའེ༌ ཁོང༌གུན༌ སོག༌མ༌ མེའ༌ སྲག༌ག༌ ཙོགས༌ལ༌ མེད༌ཁན༌ ཅོའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ཉེ༌རང༌ངི༌ འུགས༌ ཉམ༌པོ༌ ཕུ༌ སལ༌ཏེ༌ ཚོའེ༌ ཆུ༌ ལངས༌ཏེ༌ དུག༌ ཅུག༌ག༌ ཛདས༌། ཚོའེ༌ ཆུ༌ གྱུག༌ཁན༌བོ༌ རྩིག༌པ༌ ཙོགས༌ལ༌ ལངས༌ཏེ༌ དུག༌ ཅུག༌ག༌ ཛདས༌, ཚོ༌ ཏིང༌ཅན༌ནི༌ ནང༌ང༌ ཆུ༌ ཁྱགས༌པ༌ ཙོགས༌ སྲན༌ཏྲེ༌ གྱུར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“གྲ༌འོ༌གུན༌ནི༌ ཕོ༌སོ༌ ཅོས༌ཏེ༌ ཟེརས༌, ‘ང༌དང༌ ཁོང༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ སོང༌ཏེ༌ ཁོང༌གུན༌ ཟུམ༌ཨིན༌། ང༌དང༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ ནོར༌ ཅོམས༌ཏེ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ང༌དང༌ ཐད༌ཁན༌ ཅོ༌ཨིན༌། ང༌དང༌ངི༌ ར༌འི༌གུན༌ ཕིངས༌ཏེ༌ ང༌དང༌ངི༌ ལག༌པའེ༌ ཁོང༌གུན༌ མེད༌ཁན༌ ཅོ༌ཨིན༌།’ ");
INSERT INTO lbj_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ཨིན༌ནའང༌ ཡ༌ཝ༌ ཉེ༌རང༌ངི༌ འུགས༌ ཉམ༌པོ༌ ཕུ༌ སལ༌ཏེ༌ ཚོའེ༌ ཆུའ༌ ཁོང༌གུན༌ ཀབ༌ ཅུག༌ག༌ ཛདས༌ ཡང༌ ཁོང༌གུན༌ གྱ༌ཚོའེ༌ ཐིལ༌ལ༌ རྡོའ༌ ཙོགས༌ལ༌ ནུབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ལྷ༌ལྷ༌མོ༌ ཚང༌མའེ༌ ཕྲོ༌ནེ༌ ཡ༌ཝ༌ ཉེ༌རང༌ ཙོགས༌ སུ༌ ཡོད༌གྲོ༌? ཏམ༌པའེ༌ ནང༌ང༌ ཟིར༌རྗིད༌ཅན༌, ཧ༌མི༌གོ༌ཅེས༌སི༌ སྤལ༌ཅན༌ དང༌ ཧ༌ལས༌ཤེས༌སི༌ ཛད༌པ༌ ཛད༌ཁན༌ ཉེ༌རང༌ ཙོགས༌ སུའང༌ མེད༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ཉེ༌རང༌ངི༌ ཤེད༌ཅན༌ ཆག༌ ཡས༌པ༌ རྐྱང༌ང༌ ཛདས༌ ཡང༌ ང༌དང༌ངི༌ གྲ༌འོ༌གུན༌ ས༌ཀྱད༌དི༌ སྨིད༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ཉེ༌རང༌ངི༌ ཡ༌ཤ༌ སྟན༌པོའེ༌ ནང༌ང༌ ཉེ༌རང༌ངི༌ ཉོའ༌ ཛད༌ཁན༌ནི༌ མི༌གུན༌ ཁྲིད༌ད༌ ཛད༌ཨིན༌། སྟོབས༌ཤུགས༌ ཉམ༌པོ༌ ཉེ༌རང༌ངི༌ ཁོང༌གུན༌ལ༌ ལམ༌སྟན༌ ཛད༌ཏེ༌ ཉེ༌རང༌ངི༌ ཨིན༌ཁན༌ནི༌ ཏམ༌པ༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱེར༌ར༌ ཛད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","གྱལ༌ཁམས༌གུན༌ནི༌ ཏེ༌གུན༌ ཚོར༌ཏེ༌ ཇིགས༌ཏེ༌ དར༌ཨིན༌། ཕི༌ལིས༌ཏི༌པ༌གུན༌ མ༌སྲན༌ཏྲེ༌ ཇིགས༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ཨི༌དོམ༌མི༌ སྤོན༌བོ༌གུན༌ སྲན༌ཏྲེ༌ ཇིགས༌ཨིན༌། མོ༌འབ༌པའེ༌ སྤོན༌བོ༌གུན༌ ཇིགས༌ཏེ༌ དར༌ཨིན༌། ཀེ༌ནན༌པ༌གུན༌ནི༌ སྤོས༌པ༌ སྟོར༌ཏེ༌ མུན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ཡ༌ཝ༌ ཉེ༌རང༌ངི༌ ཤེད༌ གྱུད༌ཏེ༌ ཁོང༌གུན༌ནི༌ཀ༌ ཇིགས༌པ༌ དང༌ ཚབས༌ཤེས༌ ལེབ༌ཨིན༌། ཉེ༌རང༌ངི༌ ཁྱུད༌ཅན༌ ཆག༌གི༌ ཁོང༌གུན༌ རྡོའ༌ ཙོགས༌ འུགས༌མེད༌ གྱུར༌ཅུག༌ཨིན༌ ནམ༌ཚོག༌པ༌ ཉེ༌རང༌ངི༌ མི༌, ཚེ༌ཡོག༌ནེ༌ ཐར༌ ཅུག༌ག༌ ཛད༌ཁན༌གུན༌ ཏེ༌ གྱལ༌ཁམས༌གུན༌ གྱུད༌ཏེ༌ ཆ༌ མི༌ཚར༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ཉེ༌རང༌ངི༌ ཨིན༌ཁན༌ནི༌ རི༌ཀ༌ ཉེ༌རང༌ངི༌ ཁོང༌གུན༌ ཁྱོང༌ང༌ ཛད༌ཏེ༌ ཚུག༌ཤུག༌ག༌ ཛད༌ཨིན༌, ཡ༌ཝ༌, ཉེ༌རང༌ ནས༌ཤེས༌སི༌ ཕིའ༌ ཏེ༌ ས༌ཆ༌བོ༌ ཅོའ༌ ཛད༌ཏེ༌ ཨིན༌པིན༌, ཉེ༌རང༌ངི༌ རྩིག༌ག༌ ཛད༌ཁན༌ནི༌ ཏམ༌པའེ༌ ནས༌ས༌ ཞིག༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ཡ༌ཝའེ༌ ཏུས༌གྱུན༌ནེ༌གྱུན༌ ཝང༌ སྲུལ༌ལ༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཚོའེ༌ ཞུང༌ནེ༌ ས༌སྐམ༌པོའེ༌ ཀ༌ནེ༌ གྲུལ༌ཏེ༌ སོང༌, ཨིན༌ནའང༌ གྱལ༌པོའེ༌ རྟ༌རེལ༌ དང༌ ཏེ༌ཀ༌ ཞོན༌ཁན༌གུན༌ ཚོའེ༌ ནང༌ང༌ ཆའ༌ཅིག༌ ཡ༌ཝའེ༌ ཆུ༌ མལ༌ལི༌ཀ༌ ལོགས༌ཏེ༌ ཁྱོང༌ང༌ ཛདས༌ ཡང༌ ཁོང༌གུན༌ ཆུའི༌ ནང༌ང༌ ནུབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ཨ༌རོན༌ནི༌ སྲིང༌མོ༌ ལུང༌སྟོན༌མ༌ མི༌རི༌ཨམ༌མི༌ ལག༌པའེ༌ ནང༌ང༌ དབ༌ ཁུརས༌, ཞན༌ བུ༌མོ༌ ཚང༌མ༌ ཁོའེ༌ སྟིང༌རང༌ནེ༌ དབ༌ ཁུར༌ཏེ༌ རྩེ༌ཨིན༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","མི༌རི༌ཨམ༌མི༌ ལུ༌ ཏངས༌, “ཡ༌ཝའེ༌ ཕིའ༌ ལུ༌ ཏོང༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ངི༌ གྱལ༌ཁ༌ སྤལ༌ཅན༌ ལེན༌ཏེ༌ ཨིན༌ནོག༌། ཁོང༌ངི༌ རྟ༌རེལ༌ དང༌ ཏེ༌ཀ༌ ཞོན༌ཁན༌ ཚང༌མ༌ ཚོའེ༌ ནང༌ང༌ ཕང༌ང༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཚོ༌ མར༌པོ༌ནེ༌ ཁྲིད༌ཏེ༌ ཤུར༌ ཟེར༌སའེ༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ སོང༌། ཁོང༌གུན༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ གྲུལ༌ཨིན༌ ཞག༌པོ༌ སུམ༌ སོང༌ ཨིན༌ནའང༌ ཆུ༌མིག༌ ཅིག༌གའང༌ མ༌ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","མ༌རཧ༌ ཟེར༌ཁན༌ནི༌ ས༌ཆ༌ ལེབ༌བ༌ཅིག༌ ཏེ༌ ནས༌སའེ༌ ཆུ༌གུན༌ ཁན༌ཀྲེ༌ ཡོད༌པ༌ ཁོང༌གུན༌ ཐུང༌ མ༌ཉན༌། ༼ཏེན༌ན༌བོའེ༌ཕིའ༌ ཏེ༌ ས༌ཆ༌བོའ༌ མ༌རཧ༌ ཟེར༌རད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","མི༌གུན༌ནི༌ མོ༌ཟེས༌ལ༌ སྐྱོན༌རྗོད༌ ཅོ༌ཨིན༌ ཟེརས༌, “ང༌ཞ༌གུན༌ནི༌ ཅི༌ ཐུང༌?” ");
INSERT INTO lbj_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","མོ༌ཟེས༌སི༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌པ༌ ཡ༌ཝའེ༌ ཁོའ༌ བེར༌ཀ༌ ཞིག༌ སྟན༌ན༌ ཛདས༌། མོ༌ཟེས༌སི༌ ཏེ༌བོ༌ ཆུའི༌ ནང༌ང༌ ཕངས༌ ཡང༌ ཆུའི༌ ཁན༌ཀྲེ༌ མེད༌ཁན༌ སོང༌ཏེ༌ ཐུང༌ཉན༌། ཏེ༌རུ༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ལ༌ བཀའ༌ཁྲིམས༌ཤིག༌ སལས༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཚོད༌ལྟ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ཁོང༌ངི༌ མོལས༌, “ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ཚང༌མ༌ ཁའ༌ཉན༌ཏེ༌ ཀྲང༌པོ༌བོ༌ ཅོས༌ཏེ༌, བཀའ༌རྒྱ༌ དང༌ བཀའ༌ཁྲིམས༌ ཚང༌མ༌ ནང༌སྟག༌ ཏང༌ན༌ ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ཀ༌ ཁྱོང༌ཁན༌ནི༌ ནད༌ ཅིག༌གའང༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཡོང༌ མི༌ཅུག༌, ཅིའ༌ཟེར༌ན༌ ང༌ ཡ༌ཝ༌, ཕན༌ཅུག༌ག༌ ཛད༌ཁན༌བོ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ཏེ༌ནེ༌ ཁོང༌གུན༌ ཨེ༌ལིམ༌མ༌ ལེབ༌, ཀ༌རུ༌ ཆུ༌མིག༌ རྕུག༌ཉིས༌ དང༌ ཁ༌སོར༌རི༌ ལྕང༌མ༌ རྡུན༌ཅུ༌ ཡོད༌པིན༌, ཏེ༌རུ༌ ཁོང༌གུན༌ནི༌ ཆུའི༌ དུན༌ལ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ཨེ༌ལིམ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྡེ༌ ཚང༌མ༌ བིང༌ཏེ༌ ཨེ༌ལིམ༌ དང༌ སི༌ནཱའི༌ པར༌ལ༌ ཡོད༌ཁན༌ སིན༌ ཟེར༌སའེ༌ ཐང༌སྟོང༌ང༌ ལེབ༌, ཡང༌ ཏེ༌ ཞག༌པོ༌ ཁོང༌གུན༌ ཨི༌ཇིབ༌ནེ༌ བིང༌ཏེ༌ ཟླ༌ཝ༌ ཉིས༌པའེ༌ ཞག༌མ༌ 15 པ༌བོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཁོང༌ ཚང༌མའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ལ༌ མ༌བེབས༌ ཅོས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ཟེརས༌, “ཡ༌ཝའེ༌ ང༌ཞ༌གུན༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ སད༌ད༌ ཛད༌པིན༌ན༌ གྱལ༌, ཏེ༌རུ༌ ང༌ཞ༌གུན༌ལ༌ ཤ༌ ཟང༌བུ༌ སྐངས༌ཏེ༌ གྲོད༌པ༌ གྲང༌ཤེས༌སི༌ ཏ༌གི༌ ཡོད༌པིན༌། ཨིན༌ནའང༌ ཁྱོ༌ཞའེ༌ ང༌ཞ༌གུན༌ འི༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ སྟོག༌རིའ༌ ཤི༌ཅུག༌ཅེས༌སི༌ ཕིའ༌ ཁྲིད༌ཏེ༌ ཁྱོངས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ངའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕིའ༌ ནམ༌ཁའ༌ནེ༌ ཆར༌པ༌ ཙོགས༌ལ༌ ཏ༌གི༌ ཕབ༌ཨིན༌། མི༌གུན༌ ཞག༌ཏང༌ ཕི༌ལོག༌ག༌ སོང༌ཏེ༌ ཏེན༌ན༌ ཞག༌གི༌ ཕིའ༌ ཏ༌གི༌ ཏུས༌ཏེ༌ ཁྱོང༌གོས༌། འིན༌ན༌ཟུག༌གི༌ ངའེ༌ ཁོང༌གུན༌ལ༌ ཚོད༌ལྟས༌ཏེ༌ ངའེ༌ ཟེར༌ཁན༌བོ༌ ཅོ༌ དུག༌ག༌ མི༌དུག༌ ལྟེན༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ཨིན༌ནའང༌ ཞག༌མ༌ དྲུག༌པའི༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ ཉི༌ལྡབ༌ ཏ༌གི༌ ཏུས༌ཏེ༌ ཁྱོངས༌ཏེ༌ ཞག༌ ཉིས༌སི༌ ཕིའ༌ ཁར༌ཇི༌ གྲལ༌གྲིག༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ཏེ༌ནེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ལ༌ ཟེརས༌, “ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཁན༌བོ༌ འིན༌ན༌ ཕི༌ཏོག༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཧ༌གོ༌ཡིན༌, ");
INSERT INTO lbj_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ཡང༌ ང༌མོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཟིར༌རྗིད༌པོ༌ ཐོང༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁོང༌ངི༌ གྱབ༌གལ༌ལ༌ མ༌བེབས༌ ཅོ༌ཁན༌བོ༌ ཁོང༌ངི༌ སན༌ན༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ང༌ཞའེ༌ གྱབ༌གལ༌ལ༌ མ༌བེབས༌ ཅོས༌ཏེ༌ ང༌ཞའ༌ སུ༌ ཨིན༌ནོག༌?” ");
INSERT INTO lbj_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ཟེརས༌, “ཕི༌ཏོག༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཟའ༌ཅེས༌སི༌ ཕིའ༌ ཤ༌ ཡང༌ ང༌མོ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ གོས༌ཁན༌ནི༌ ཏ༌གི༌ སལ༌ལ༌ཅིག༌ ཁོང༌ ཡ༌ཝ༌ ཨིན༌ཁན༌བོ༌ ཧ༌གོ༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌ཞའེ༌ ཁོང༌ངི༌ གྱབ༌གལ༌ལ༌ མ༌བེབས༌ ཅོ༌ཁན༌བོ༌ ཁོང༌ངི༌ སན༌ན༌ ཛདས༌། ང༌ཞའ༌ སུ༌ ཨིན༌ནོག༌? ཁྱོ༌ཞ༌གུན༌ནི༌ མ༌བེབས༌ ཅོ༌ཁན༌བོ༌ ང༌ཞའ༌ མན༌པ༌ ཡ༌ཝའེ༌ གྱབ༌གལ༌ལ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","མོ༌ཟེས༌སི༌ ཨ༌རོན༌ལ༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌ལི༌ སྡེ༌ གང༌པོའ༌ ཡ༌ཝའེ༌ དུན༌ལ༌ ཡོང༌ཅེས༌ལ༌ ཟེར༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ངི༌ ཁོང༌གུན༌ནི༌ མ༌བེབས༌ ཅོ༌ཁན༌བོ༌ སན༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ཨ༌རོན༌ནི༌ ཨིས༌ར༌ཨེལ༌ལི༌ སྡེ༌ གང༌པོའ༌ སྤེ༌ར༌ ཏང༌ ཟ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཐང༌སྟོང༌ ཆོགས༌ལ༌ ལྟས༌པ༌ ཏེ༌རུ༌ ཁོང༌གུན༌ནི༌ སྲིན༌ནི༌ ནང༌ང༌ ཡ༌ཝའེ༌ ཟིར༌རྗིད༌ ཇལ༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ངའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མ༌བེབས༌ ཅོ༌ཁན༌བོ༌ ཚོར༌། ཁོང༌གུན༌ལ༌ ཟེར༌, ‘ཞག༌ཏང༌ ཕི༌ཏོག༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཟའ༌ཅེས༌སི༌ ཕིའ༌ ཤ༌ ཡང༌ ཞག༌ཏང༌ ང༌མོ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ སྒོས༌དོམ༌ ཡོད༌ཁན༌ནི༌ ཏ༌གི༌ ཐོབ༌ཨིན༌། ཏེ༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ང༌ ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ ཨིན༌ཁན༌བོ༌ ཤེས༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ཏེ༌ ཕི༌ཏོག༌ ཅི༌པ༌ ཆུ༌ངུན༌ མང༌པོ༌ ཡོངས༌ཏེ༌ ཁོང༌གུན༌ དུག༌སའེ༌ ས༌ཆ༌ གངས༌ ཡང༌ ང༌མོ༌ ཁོང༌གུན༌ དུག༌སའེ༌ ས༌ཆ༌ གང༌པོ༌ ཟིལ༌པའེ༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ཟིལ༌པ༌ མེད༌ཁན༌ ཆའ༌ཅིག༌ ཐང༌སྟོང༌ངི༌ཀ༌ ཆུ༌ ཁྱགས༌ཁན༌ སྲ༌མོ༌ ཙོགས༌ཤིག༌ ལུས༌ཏེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཏེ༌བོ༌ ཐོང༌ང༌ཅིག༌ ཅིག༌ དང༌ ཅིག༌ག༌ ཏྲིས༌, “འི༌བོ༌ ཅི༌ ཨིན༌ནོག༌?” ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ལ༌ ཏེ༌བོ༌ ཅི༌ ཨིན༌ མ༌ཤེས༌། མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “འི༌བོ༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌ ཟའ༌ཅེས༌ལ༌ སལ༌ཁན༌ནི༌ ཏ༌གི༌བོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ཡ༌ཝའེ༌ འི༌ བཀའ༌བོ༌ སལས༌, ‘ཁྱོ༌ཞའ༌ རེ༌རེའེ༌ སྒོས༌དོམ༌ ནང༌ཞིན༌ ཏེ༌བོ༌ ཏུས༌ཏེ༌ ཁྱོང༌། ཁྱོ༌ཞའེ༌ ཀུར༌རི༌ ནང༌ང༌ དུག༌ཁན༌ རེ༌རེ༌ ཕིའ༌ ལི༌ཏྲར༌ ཉིས༌ ཏུས༌ཏེ༌ ཁྱོང༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ཡ༌ཝའེ༌ མོལ༌ཁན༌བོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཅོས༌, ཁ༌ཅིག༌གི༌ མང༌ང༌ ཡང༌ ཁ༌ཅིག༌གི༌ ཉུ༌ངུན༌ ཏུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ཁོང༌གུན༌ནི༌ ཏེ༌བོ༌ ཏབ༌བ༌ཅིག༌ མང༌ང༌ ཏུས༌ཁན༌གུན༌ནི༌ ལག༌ག༌ མང༌པོ༌ ཡང༌ ཉུ༌ངུན༌ ཏུས༌ཁན༌གུན༌ནི༌ ལག༌ག༌ ཉུ༌ངུན༌ མེད༌པིན༌། མི༌ རེ༌རེའེ༌ ལག༌ག༌ ཁོ༌རང༌ངི༌ སྒོས༌དོམ༌ དྲན༌དྲ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “སུ༌ཞིག༌གིའང༌ འི༌ ནང༌ནེ༌ ཐོ༌རེ༌ ཕིའ༌ བོར༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ཨིན༌ནའང༌ ཁ༌ཅིག༌གི༌ མོ༌ཟེས༌སི༌ ཁའ༌ མ༌ཉན༌ན༌ ཏེ༌བོའེ༌ ནང༌ནེ༌ ཐེན༌ཏེ༌ ང༌མོ༌ ཚོད༌པ༌ བོརས༌པ༌ ཏེ༌བོའ༌ བུ༌ཙིག༌ ཏབས༌ཏེ༌ ཏེ༌བོའེ༌ ནང༌ནེ༌ ཏྲི༌མ༌ ཡོང༌ངད༌པིན༌། ཏེ༌ནེ༌ མོ༌ཟེས༌ལ༌ ཁོང༌གུན༌ནི༌ཀ༌ སྲོ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ཞག༌ཏང༌ ང༌ཏོག༌ མི༌ རེ༌རེའེ༌ ཁོ༌རང༌ང༌ སྒོས༌དོམ༌ ཡོད༌ཁན༌བོ༌ ཏུས༌ ཡང༌ ཉི༌མ༌ ཚན༌ཏེ༌ ཆའ༌ཅིག༌ ལུས༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཞུས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ཞག༌མ༌ དྲུག༌པའི༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ ཉི༌ལྡབ༌ ཏུས༌, མི༌ རེ༌རེ༌ ཕིའ༌ ལི༌ཏྲར༌ ཞི༌། སྡེ༌ ཚང༌མའེ༌ འུ༌སྐྱོང༌གུན༌ནི༌ མོ༌ཟེས༌ལ༌ ཏེ༌གུན༌ནི༌ སྐོར༌ལ༌ ཤད༌ད༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཡ༌ཝའེ༌ བཀའ༌ སལས༌, ‘ཐོ༌རེ༌ ངལ༌ཚོའེ༌ ཞག༌, ཡ༌ཝའེ༌ ཤབ༌བད༌ ཏམ༌པ༌ ཨིན༌ནོག༌། ཏེ༌བོའེ༌ཕིའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དི༌རིང༌ ཏ༌གི༌ མང༌ང༌ སྲོག༌ ཡང༌ ཁར༌ཇི༌ མང༌ང༌ སྐོལ༌། ལུས༌ཁན༌གུན༌ ཐོ༌རེ༌ ཕིའ༌ བོར༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","མོ༌ཟེས༌སི༌ ཟེར༌ཁན༌ ནང༌ཞིན༌ ཁོང༌གུན༌ནི༌ ལུས༌ཁན༌གུན༌ ཐོ༌རེ༌ ཕིའ༌ ཐེན༌ཏེ༌ བོརས༌ ཡང༌ ཏེ༌བོ༌ རུལ༌ཏེ༌ ཏྲི༌མ༌ མ༌ཡོངས༌ ཡ༌ བུ༌ཙིག༌ མ༌ ཏབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","མོ༌ཟེས༌སི༌ ཟེརས༌, “ཏེ༌གུན༌ དི༌རིང༌ ཟོ༌ཤིག༌ ཅིའ༌ཟེར༌ན༌ དི༌རིང༌ ཡ༌ཝའ༌ རྩི༌ཝ༌ ཅོ༌ཅེས༌སི༌ ཤབ༌བད༌དི༌ ངལ༌ཚོའེ༌ ཞག༌ ཨིན༌ནོག༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཕི༌ལོག༌ག༌ ཟའ༌ཅེས༌ མི༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ཁྱོ༌ཞ༌གུན༌ནི༌ ཞག༌མ༌ དྲུག༌ ཟའ༌ཅེས༌ ཏུས༌ཏེ༌ ཁྱོང༌ ཆོག༌ཨིན༌, ཨིན༌ནའང༌ ཞག༌མ༌ རྡུན༌པ༌, ཤབ༌བད༌དི༌ ངལ༌ཚོའེ༌ ཞག༌ག༌ ཏེ༌གུན༌ མི༌ཐོབ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ མི༌ ཁ༌ཅིག༌ ཕི༌ལོག༌ག ཟའ༌ཅེས༌ ཏུ༌ཅེས༌ལ༌ སོང༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ལ༌ ཅའང༌ མ༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཏ༌རོང༌ ཙམ༌ཤིག༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ བཀའ༌ དང༌ ལབ༌ཞའ༌ གུན༌ལ༌ མི༌ཉན༌? ");
INSERT INTO lbj_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ཨིད༌ཏུ༌ བོར༌, ང༌ ཡ༌ཝའེ༌, ཁྱོ༌ཞ༌གུན༌ལ༌ ཤབ༌བད༌དི༌ ངལ༌ཚོའེ༌ ཞག༌ ཏངས༌ཏེ༌ ཨིན༌ ཏེན༌ན༌བོའེ༌ཕིའ༌ ཞག༌ དྲུག༌པའི༌ ཞག༌ག༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཞག༌མ༌ ཉིས༌སི༌ བོས༌ ཟའ༌ཅེས༌ ཏང༌ཨིན༌། ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ ཁྱོ༌ཞའ༌ ཚང༌མ༌ ཀ༌རུ༌ ཡོད༌ནའང༌ ཏེན༌ན༌རུ༌ དུག༌གོས༌, སུ༌ཞིག༌གའང༌ ཕི༌ལོག༌ག༌ ཆ༌མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ཏེ༌བོའེ༌ཕིའ༌ མི༌གུན༌ ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ ངལ༌ཚོས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཏེ༌ ཏ༌གི༌བོའ༌ མན༌ན༌ ཟེར༌རད༌པིན༌, འི༌བོ༌ ཨུ༌སུའི༌ ས༌འོན༌ ཙོགས༌ ཨིན༌ནའང༌ ཀར༌པོ༌ ཡང༌ བྲོད༌པོ༌ རང༌རྩིའ༌ ཅོས༌ཁན༌ནི༌ ཏ༌གི༌ སྲ༌མོ༌ ཙོགས༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","མོ༌ཟེས༌སི༌ ཟེརས༌, “ཡ༌ཝའེ༌ བཀའ༌ སལས༌, ‘ཁྱོ༌ཞའེ༌ པུར༌གྱུད༌གུན༌ལ༌ སྟན༌ཅེས༌སི༌ ཕིའ༌ ལི༌ཏྲར༌ ཉིས༌སི༌ མན༌ན༌ ཐེན༌ཏེ༌ བོར༌གོས༌། ཏེ༌ནེ༌ ངའེ༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཟའ༌ཅེས༌ལ༌ ཏང༌ཁན༌ནི༌ ཏ༌གི༌ ཁོང༌གུན༌ནི༌ ཐོང༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","མོ༌ཟེས༌སི༌ ཨ༌རོན༌ལ༌ ཟེརས༌, “ནོད༌ ཞིག༌ ཁྱོངས༌ཏེ༌ ཏེ༌ནང༌ང༌ ལི༌ཏྲར༌ ཉིས༌སི༌ མན༌ན༌ གྱོང༌ ཡང༌ ང༌དང༌ངི༌ པུར༌གྱུད༌གུན༌ནི༌ ཐོང༌ཅེས༌སི༌ ཕིའ༌ ལུས༌ཤེས༌ལ༌ ཡ༌ཝའེ༌ དུན༌ལ༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཨ༌རོན༌ནི༌ ཏེ༌བོ༌ སྟོར༌ མི༌སྟོར༌ཅེས༌ལ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ དུན༌ལ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ཁོང༌གུན༌ ཚུགས༌ཏེ༌ དུག༌སའེ༌ ས༌ཆ༌ ལེབ༌ལེབ༌ ཚོག༌པ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ལོ༌ ཞིབ༌ཅུ༌ མན༌ན༌ ཟོས༌། ཀེ༌ནན༌ ཡུལ༌ལི༌ སན༌ཚམས༌ལ༌ ལེབ༌ལེབ༌ ཚག༌པ༌ ཁོང༌གུན༌ནི༌ མན༌ན༌ ཟོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ཁོང༌གུན༌ནི༌ ཏབ༌ཅེས༌ལ༌ ཀོལ༌ཁན༌ནི༌ ཚད༌པོའེ༌ ནང༌ང༌ ལི༌ཏྲར༌ ཉི༌ཤུ༌ ཆུད༌དད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ཨིས༌ར༌ཨེལ༌ལི༌ སྡེ༌ གང༌པོ༌ སིན༌ནི༌ ཐང༌སྟོང༌ནེ༌ བིང༌ཏེ༌ ཡ༌ཝའེ༌ བཀའ༌ ནང༌ཞིན༌ ས༌ཆ༌ ཅིག༌ནེ༌ ཅིག༌ག༌ སོང༌། ཁོང༌གུན༌ རེ༌ཕི༌དིམ༌ ཟེར༌སའེ༌ ས༌ཆའེ༌ ནང༌ང༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌, ཨིན༌ནའང༌ ཏེ༌རུ༌ མི༌གུན༌ལ༌ ཐུང༌ཅེས༌སི༌ ཕིའ༌ ཆུ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ཁོང༌གུན༌ནི༌ མོ༌ཟེས༌ལ༌ མ༌བེབས༌ ཅོས༌ཏེ༌ ཟེརས༌, “ང༌ཞ༌གུན༌ལ༌ ཐུང༌ཅེས༌སི༌ ཕིའ༌ ཆུ༌ ཏོང༌།” མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ཅིའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའ༌ མ༌བེབས༌ ཅོའད༌? ཅིའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཡ༌ཝའ༌ ཚོད༌ སྟད༌?” ");
INSERT INTO lbj_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ཨིན༌ནའང༌ མི༌གུན༌ སྲན༌ཏྲེ༌ སྐོམས༌ཏེ༌ ཡོད༌པིན༌ ཡང༌ མོ༌ཟེས༌ལ༌ མ༌བེབས༌ ཅོས༌ཏེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ང༌ཞ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ འི༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ང༌ཞའ༌, ང༌ཞའེ༌ ཕྲུ༌གུ༌གུན༌ དང༌ སེམས༌ཅན༌གུན༌ སྐོམ༌རིའ༌ སད༌ད༌ལ༌ ཁྱོངས༌པིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","མོ༌ཟེས༌སི༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌, “འི༌ མི༌གུན༌ ཉམ༌པོ༌ ངའེ༌ ཅི༌ ཅོ༌? ཁོང༌གུན༌ནི༌ ངའ༌ རྡོའ༌ གྱབས༌ཏེ༌ སད༌ཅེས༌ དུག༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌ ཁ༌ཅིག༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཁྲིད༌ཏེ༌ མི༌གུན༌ནི༌ སང༌ སྔུན༌སྔུན༌ལ༌ སོང༌, ཁྱོ༌རང༌ངི༌ ལག༌པའེ༌ ནང༌ང༌ ནཱའེལ༌ ལྩངས༌པོའ༌ གྱབས༌ཁན༌ནི༌ བེར༌ཀ༌བོ༌ ཁུར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ང༌ ཁྱོ༌རང༌ངི༌ དུན༌ལ༌ ཧོ༌རེབ༌བི༌ ཕོ༌ལོངས༌སི༌ཀ༌ དུག༌ཨིན༌། ཏེ༌ ཕོ༌ལོངས༌པོའ༌ བེར༌ཀ༌བོ༌ གྱོབ༌ ཡང༌ ཏེ༌ནང༌ནེ༌ མི༌གུན༌ ཐུང༌ཅེས༌སི༌ ཕིའ༌ ཆུ༌ བིང༌ཨིན༌།” མོ༌ཟེས༌སི༌ ཨིས༌ར༌ཨེལ༌ལི༌ སྤོན༌བོ༌གུན༌ནི༌ དུན༌ལ༌ ཏེན༌ན༌ ཟུག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","མོ༌ཟེས༌སི༌ ཏེ༌ ས༌ཆ༌བོའ༌ མ༌སཧ༌ དང༌ མེ༌རི༌བཧ༌ མིང༌ ཏགས༌ ཅིའ༌ཟེར༌ན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མོ༌ཟེས༌ལ༌ ཛིང༌མོ༌ ཏངས༌ ཡང༌ ཡ༌ཝའ༌ ཚོད༌ལྟས༌ཏེ༌ ཟེརས༌, “ཡ༌ཝ༌ ང༌དང༌གུན༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཡོད༌ད༌ ཧེ༌?” ");
INSERT INTO lbj_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","རེ༌ཕི༌དིམ༌མི༌ ས༌ཆའེ༌ཀ༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","མོ༌ཟེས༌སི༌ ཡོ༌ཤུའ༌ ཟེརས༌, “ང༌དང༌ངི༌ ཕྲོ༌ནེ༌ མི༌ ཁ༌ཅིག༌ ལྡམས༌ཏེ༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌། ཐོ༌རེ༌ ང༌ བྲག༌གི༌ གོའེ༌ཀ༌ ལངས༌ཏེ༌ དཀོན༌མཆོག༌གི༌ བེར༌ཀ༌བོ༌ ང༌རང༌ངི༌ ལག༌པའེ༌ ནང༌ང༌ ཁུར༌ཏེ༌ དུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ མོ༌ཟེས༌སི༌ ཟེར༌ཁན༌ ནང༌ཞིན༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌ ཡང༌ མོ༌ཟེས༌, ཨ༌རོན༌ དང༌ ཧུར༌ བྲག༌གི༌ གོའ༌ ཛགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","མོ༌ཟེས༌སི༌ ལག༌པ༌ ཀེན༌ལ༌ སྟགས༌ཏེ༌ བོརས༌ ཟ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གྱལ༌ཁ༌ ཐོབ༌, ཨིན༌ནའང༌ ཁོའེ༌ ལག༌པ༌ ཕབ༌བ༌ཅིག༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ལ༌ གྱལ༌ཁ༌ ཐོབ༌བད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","མོ༌ཟེས༌སི༌ ལག༌པ༌ ངལ༌ལ༌ཅིག༌ ཨ༌རོན༌ དང༌ ཧུར༌རི༌ ཁོ༌ དུག༌ཅེས༌སི༌ ཕིའ༌ རྡོའ༌ ཞིག༌ ཁྱོངས༌ ཡང༌ ཁོང༌གུན༌ མོ༌ཟེས༌སི༌ ལྡོའ༌ དུགས༌ཏེ༌ ཁོའེ༌ ལག༌པ༌ ཉི༌མ༌ སྐྱོད༌སྐྱོད༌ ཚོག༌པ༌ སྟན༌པོ༌ སྟགས༌ཏེ༌ ལུས༌ཤེས༌ལ༌ ཐམས༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ཏེན༌ན༌ཟུག༌གི༌ ཡོ༌ཤུའེ༌ ར༌འི༌ ཉམ༌པོ༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ལ༌ ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “འི༌ གྱལ༌ཁ༌ ཐོབ༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ལུས༌ཤེས༌ལ༌ སྤེ༌ཆའེ༌ ནང༌ང༌ བྲིས༌ ཡང༌ ཡོ༌ཤུའ༌ ཚོར༌ཅུགས༌ཏེ༌ སིལ༌། ངའེ༌ ཨ༌མ༌ལིཀ༌པའེ༌ མིར༌གྱུད༌ འི༌ ཇིག༌རྟེན༌ནི༌ ཀ༌ནེ༌ པད༌ མེད༌ཁན༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","མོ༌ཟེས༌སི༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌ ཡང༌ ཏེ༌བོའ༌ “ངའ༌ གྱལ༌ཁའ༌ སལ༌ཁན༌ ཡ༌ཝ༌ ཨིན༌” ཟེར༌ཏེ༌ མིང༌ང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ཁོའེ༌ ཟེརས༌ “ཡ༌ཝའེ༌ ཁྲིས༌ ཆོགས༌ལ༌ ལག༌པ༌གུན༌ ཀེན༌ལ༌ སྟགས༌ པ༌སང༌ མི༌རབས༌ནེ༌ མི༌རབས༌ ཡ༌ཝའེ༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ལ༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","མི༌དིའན༌པ༌ བླ༌མ༌, མོ༌ཟེས༌སི༌ ན༌མའེ༌ ཨ༌བ༌ ཡེ༌ཐོརོའ༌ དཀོན༌མཆོག༌གི༌ མོ༌ཟེས༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཛད༌ཁན༌ ཚང༌མ༌ དང༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཁན༌བོ༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ ན༌མ༌ ཟི༌པོ༌ར༌ དང༌ བུ༌ཚ༌ ཉིས༌ཀོ༌ ཡེ༌ཐོརོ༌, ཁོའེ༌ ན༌མའེ༌ ཨ༌བ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ ལམ༌ཅུགས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","མོ༌ཟེས༌སི༌ བུ༌ཚ༌ ཅིག༌གི༌ མིང༌ གེར༌ཤོམ༌ ཏགས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཟེརས༌, “ང༌ ཞན༌ཡུལ༌ལི༌ མི༌ ཞན༌མའེ༌ ནས༌སའེ༌ ནང༌ང༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ཁོའེ༌ ཞན༌ བུ༌ཚ༌བོའེ༌ མིང༌ང༌ ཨེ༌ལི༌འ༌ཟར༌ ཏགས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཟེརས༌, “ངའེ༌ ཨ༌བའེ༌ དཀོན༌མཆོག༌, ངའ༌ རོགས༌ ཛད༌ཁན༌བོ༌ ཨིན༌, ཁོང༌ངི༌ ང༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ ར༌འི༌ ནེ༌ སྐྱོབ༌བ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","མོ༌ཟེས༌སི༌ ན༌མའེ༌ ཨ༌བ༌ ཡེ༌ཐོརོ༌, མོ༌ཟེས༌སི༌ ན༌མ༌ དང༌ བུ༌ཚ༌ ཉིས༌ཀོ༌ ཁོ༌ ཡོད༌ས༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཡོངས༌ ཀ༌རུ༌ ཁོང༌གུན༌ ཏམ༌པའེ༌ རི༌ཀ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ཡེ༌ཐོརོའེ༌ མོ༌ཟེས༌ལ༌ ལོན༌ ཀལས༌, “ང༌ ཁྱོ༌རང༌ངི༌ ན༌མའེ༌ ཨ༌བ༌ ཁྱོ༌རང༌ངི༌ ན༌མ༌ དང༌ བུ༌ཚ༌གུན༌ ཉམ༌པོ༌ ཡོང༌ངད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","མོ༌ཟེས༌, ཁོ༌རང༌ངི༌ ན༌མའེ༌ ཨ༌བའ༌ ཐུག༌ག༌ལ༌ སོང༌ཏེ༌ ཁོའེ༌ དུན༌ལ༌ སྒུས༌ཏེ༌ ཁོའ༌ པུག༌ ཏངས༌། ཁོང༌གུན༌ནི༌ ཅིག༌ དང༌ ཅིག༌ག༌ ཁམ༌ཟང༌ ཨིན༌ན༌ ཟེར༌ཏེ༌ ཏྲིས༌ ཡང༌ ཀུར༌རི༌ ནང༌ང༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","མོ༌ཟེས༌སི༌ ཁོའེ༌ ན༌མའེ༌ ཨ༌བའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ཡ༌ཝའེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ དང༌ ཁོའེ༌ མི༌གུན༌ལ༌ ཛདས༌ཁན༌ ཚང༌མ༌ ཡང༌ ཁོང༌གུན༌ལ༌ ལམ༌མ༌ བར༌དོ༌ ཐོང༌ཁན༌ ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ སྐྱོབ༌བ༌ ཛད༌ཁན༌ ཚང༌མ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབས༌ཏེ༌ ཁོང༌གུན༌ལ༌ གྱལ༌ལ༌ ཛད༌ཁན༌ ཚང༌མ༌ ཚོར༌ར༌ཅིག༌ ཡེ༌ཐོརོ༌ མ༌སྲན༌ཏྲེ༌ ཐད༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ཟེརས༌, “ཡ༌ཝའ༌ སྟོད༌པ༌ ཕུལ༌, ཁོང༌ངི༌ ཁྱོ༌ཞའ༌ གྱལ༌པོ༌ དང༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌བ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ མི༌གུན༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཚེ༌ཡོག༌ནེ༌ ཕིང༌ང༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ཏ༌ ང༌ ཧ༌གོ༌, ཞན༌གུན༌ནི༌ ཅོལ༌ཁན༌ནི༌ ལྷ༌ལྷ༌མོ༌ ཚང༌མའེ༌ སང༌ ཡ༌ཝ༌ ཀྲག༌ག༌ ཞུགས༌ཏེ༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ངི༌ ཕོ༌སོ༌ཅན༌ནི༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཝང༌ངི༌ ཡོག༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱོབ༌བ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ཏེ༌ནེ༌ ཡེ༌ཐོརོའེ༌ དཀོན༌མཆོག༌ག༌ ཕུལ༌ཅེས༌ལ༌ མེའ༌ སྲག༌ཅེས༌སི༌ ཆོད༌པ༌ དང༌ ཞན༌ཡང༌ ཆོད༌པ༌ གུན༌ ཁྱོངས༌ ཡང༌ དཀོན༌མཆོག༌གི༌ སྐུན༌དུན༌ལ༌, ཡེ༌ཐོརོ༌ ཉམ༌པོ༌ ཟན༌ ཟའ༌ཅེས༌ལ༌ ཨ༌རོན༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌ ཚང༌མ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","སྟིང༌མ༌ཞག༌པོ༌ མོ༌ཟེས༌ མི༌གུན༌ནི༌ ཛིང༌མོའ༌ ཤགས༌ ཅོ༌ཅེས༌ལ༌ དུགས༌ ཡང༌ ང༌མོ༌ནེ༌ ཕི༌ཏོག༌ ཚོག༌པ༌ མི༌གུན༌ ཁོའ༌ ཁོར༌ཏེ༌ ཐག༌ཅད༌དི༌ ཕིའ༌ སྲུངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ཡེ༌ཐོརོའེ༌ མོ༌ཟེས༌སི༌ མི༌གུན༌ནི༌ ཕིའ༌ ཅོ༌ཁན༌བོ༌ ཐོང༌ང༌ཅིག༌ ཁོའ༌ ཏྲིས༌, “ཁྱོ༌རང༌ངི༌ མི༌གུན༌ལ༌ ཅོ༌ཁན༌བོ༌ ཅི༌ ཨིན༌? ཅིའ༌ ཁྱོ༌རང༌ ཅིག༌པོའེ༌ འི༌ ཚང༌མ༌ ཅོའད༌? མི༌གུན༌ ང༌མོ༌ནེ༌ ཕི༌ཏོག༌ ཚོག༌པ༌ ཁྱོ༌རང༌ངི༌ ཐག༌ཅད༌དི༌ ཕིའ༌ སྲུངས༌ཏེ༌ དུག༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ངའེ༌ ཏེ༌བོ༌ ཅོའད༌ ཅིའ༌ཟེར༌ན༌ མི༌གུན༌ ངའ༌ ཡོད༌ས༌ དཀོན༌མཆོག༌གི༌ ཐུགས༌དོད༌ ཧ༌གོ༌ཅེས༌སི༌ ཕིའ༌ ཡོང༌ང༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ཛིང༌མོ༌ ཆ༌ན༌ ཁོང༌གུན༌ ངའ༌ ཡོད༌ས༌ གལ༌ཁན༌ དང༌ མ༌གལ༌ཁན༌ ཕེ༌ཅེས༌སི༌ ཐག༌ཅད༌ ཉན༌ན༌ ཡོང༌ང༌ནོག༌ ཡང༌ ངའེ༌ ཁོང༌གུན༌ལ༌ དཀོན༌མཆོག༌གི༌ བཀའ༌ དང༌ ཁྲིམས༌ གུན༌ ཤད༌དད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ཏེ༌ནེ༌ ཡེ༌ཐོརོའེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ འི༌ ལས༌ ཅོ༌ཚུལ༌བོ༌ སམ༌བ༌ཅན༌ ཤིག༌ མི༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ཏུས༌ མང༌པོ༌ གོར༌ཅེས༌པོའེ༌ ཁྱོ༌རང༌ངི༌ རང༌ དང༌ མི༌གུན༌ འུ༌ཐུག༌ ཤུག༌དུག༌། འི༌ ལས༌པོ༌ མངས༌ཏེའང༌ ལྕིན༌ཏྲེ༌ ཡོད༌ཅེས༌པོའེ༌ ཁྱོ༌རང༌ ཅིག༌པོའེ༌ ཅོ༌ ཉན༌ཅེས༌ མ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ཏ༌ ང༌ ཉོན༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ལབ༌ཞ༌ ཏང༌ཨིན༌ ཡང༌ དཀོན༌མཆོག༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཞུགས༌ཤིག༌། ཁྱོ༌རང༌ དཀོན༌མཆོག༌གི༌ དུན༌ལ༌ མི༌གུན༌ནི༌ ཚབས༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཛིང༌མོ༌གུན༌ ཁོང༌ངི༌ཀ༌ ཁྱོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ཁོང༌གུན༌ལ༌ དཀོན༌མཆོག༌གི༌ བཀའ༌ དང༌ ཁྲིམས༌ གུན༌ ཡང༌ ཁོང༌གུན༌ལ༌ མི༌ཚེ༌ ཀ༌ཟུག༌གི༌ ཕུད༌ཅེས༌ དང༌ ཁོང༌གུན༌ནི༌ ལས༌སི༌ ཁག༌གུན༌ ལོབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ཨིན༌ནའང༌ མི༌ ཚང༌མའེ༌ ཕྲོ༌ནེ༌ ཁྱོ༌རང༌ངི༌ ཇོན༌པོ༌ མི༌, དཀོན༌མཆོག༌ག༌ ཇིགས༌ཁན༌, ཨིད༌ཤེས༌ཅན༌ ཡང༌ ཕག༌སུབ༌བ༌ ནཕ༌རད༌ ཅོ༌ཁན༌ གུན༌ ལྡམས༌ཏེ༌ ཁོང༌གུན༌ སྟོང༌, གྱ༌, ལྔབ༌ཅུ༌, ཡང༌ རྕུ༌ མི༌སྡེ༌ གུན༌ནི༌ཀ༌ སྤོན༌བོའ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ནམ༌ སྒོས༌དོམ༌ ཆ༌ནའང༌ ཐག༌ཅད༌ ཅོ༌ཅེས༌ལ༌ ཁོང༌གུན༌ ཁྲིམ༌སྤོན༌ལ༌ སྐོས༌། ཁོང༌གུན༌ལ༌ ཛིང༌མོ༌ ཆུ༌ངུན༌ ཚང༌མའ༌ ཁོ༌རང༌གུན༌ལ༌ ཐག༌ཅད༌ ཏང༌ཅུག༌, ཨིན༌ནའང༌ ཛིང༌མོ༌ ཆེན༌མོ༌གུན༌ ཁྱོ༌རང༌ངི༌ཀ༌ ཁྱོང༌ཅུག༌། ཏེ༌བོའེ༌ ཁྱོ༌རང༌ངི༌ ལས༌ ལ༌མོ༌ ཆེན༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ཁྱོ༌རང༌ངི༌ ལས༌སི༌ ལྕིད༌པོ༌ བགོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","དཀོན༌མཆོག༌གི༌ བཀའ༌ ནང༌ཞིན༌ ཁྱོ༌རང༌ངི༌ ཏེ༌བོ༌ ཅོ༌ན༌ ཁྱོ༌རང༌ང༌ སེམ༌སྟོབས༌ ཉམ༌པོ༌ ལས༌ ཅོ༌ཉན༌ཨིན༌ ཡང༌ མི༌ ཚང༌མ༌ སེམས༌སི༌ ནང༌ང༌ ཞི༌དེ༌ ཉམ༌པོ༌ ཁོ༌རང༌གུན༌ནི༌ ཁང༌པ༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","མོ༌ཟེས༌སི༌ ཡེ༌ཐོརོའེ༌ ལབ༌ཞ༌གུན༌ ཉན༌ཏེ༌ ལག༌ལེན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ནང༌ནེ༌ མི༌ ཇོན༌པོ༌གུན༌ ལྡམས༌ཏེ༌ ཁོང༌གུན༌ སྟོང༌, གྱ༌, ལྔབ༌ཅུ༌ དང༌ རྕུ༌ མི༌སྡེ༌ གུན༌ནི༌ཀ༌ སྤོན༌བོའ༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ནམ༌ སྒོས༌དོམ༌ ཆ༌ནའང༌ ཁོང༌གུན༌ནི༌ མི༌ཚང༌མའེ༌ ཕིའ༌ ཁྲིམ༌སྤོན༌ནི༌ ལས༌ ཅོས༌། ཛིང༌མོ༌ ཆེན༌མོ༌གུན༌ མོ༌ཟེས༌སི༌ཀ༌ ཁྱོངས༌ ཨིན༌ནའང༌ ཛིང༌མོ༌ ཆུ༌ངུན༌གུན༌ ཁོང༌རང༌གུན༌ནི༌ ཐག༌ཅད༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","མོ༌ཟེས༌སི༌ ན༌མའེ༌ ཨ༌བ༌ ཡེ༌ཐོརོ༌ ཁོང༌རང༌ངི༌ ཁང༌པ༌ ལོགས༌ཏེ༌ ཆའ༌ཅིག༌ མོ༌ཟེས༌སི༌ ཁོའ༌ ཇུ༌ ཞུས༌ཏེ༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ནེ༌ བིངས༌ཏེ༌ སྟིང༌ནེ༌ ཟླ༌ཝ༌ སུམ༌པའེ༌ གོ༌མའེ༌ ཞག༌ག༌ ཁོང༌གུན༌ སི༌ནཱའི༌ ཐང༌སྟོང༌ང༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ རེ༌ཕི༌དིམ༌ནེ༌ བིང༌ཏེ༌ སི༌ནཱའི༌ ཐང༌སྟོང༌ང༌ ལེབ༌ ཡང༌ ཏེ༌རུ༌ ཁོང༌གུན༌ནི༌ སི༌ནཱའི༌ རིའི༌ དུན༌ལ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","མོ༌ཟེས༌ རིའི༌ཀ༌ ཀེན༌ལ༌ དཀོན༌མཆོག༌ག༌ ཐུག༌ག༌ལ༌ སོང༌། ཡ༌ཝའེ༌ ཁོའ༌ རི༌གོ༌ནེ༌ བོད༌ད༌ ཛད༌ཏེ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ཨིས༌ར༌ཨེལ༌པ༌, ཡ༌ཀོབ༌བི༌ པུར༌གྱུད༌གུན༌ལ༌ འི༌བོ༌ ཟེར༌, ");
INSERT INTO lbj_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ ཅོ༌ཁན༌གུན༌ ཁྱོ༌ཞའེ༌ ཐོང༌ཏེ༌ ཨིན༌ནོག༌། ལག༌གི༌ ཤོག༌པའེ༌ ནང༌ང༌ ཕྲུ༌གུ༌ ཁུར༌ཏེ༌ འུར༌ར༌ ཙོགས༌ལ༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཁུར༌ཏེ༌ ང༌རང༌ངི༌ཀ༌ ཁྱོངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ཏ༌ ཀལ༌ཏེས༌ ཁྱོ༌ཞའེ༌ ངའེ༌ ཁའ༌ཉན༌ཏེ༌ ང༌དང༌ངི༌ པར༌ལ༌ ཆད༌དོན༌ ཅོ༌ཁན༌གུན༌ བོར༌ན༌, ཇིག༌རྟེན༌ གང༌པོའེ༌ མི༌ ངའེ༌ ཨིན༌ཁན༌གུན༌ནི༌ ནང༌ནེ༌ ཁྱོ༌ཞའ༌ ཚང༌མའེ༌སང༌ མང༌ང༌ རིན༌ཅན༌བོ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ཡང༌ ཁྱོ༌ཞའ༌ ངའེ༌ བླ༌མ༌གུན༌ནི༌ གྱལ༌སྲིད༌ དང༌ ཏམ༌པ༌ གྱལ༌ཁམས༌པོ༌ གྱུར༌ཨིན༌།’ འི༌ སྤེ༌ར༌གུན༌ ཁྱོ༌རང༌ངི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཤོད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ཏེ༌ནེ༌ མོ༌ཟེས༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ སྤོན༌བོ༌གུན༌ལ༌ བོད༌ཏེ༌ ཡ༌ཝའེ༌ ཤོད༌ མོལ༌ཁན༌ ཚང༌མ༌ ཁོང༌གུན༌ལ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","མི༌ཚང༌མ༌ ཅིག༌ སོང༌ཏེ༌ ལན༌ཏངས༌, “ཡ༌ཝའེ༌ མོལ༌ཁན༌ ཚང༌མ༌ ང༌ཞ༌གུན༌ནི༌ ཅོ༌ཨིན༌” ཡང༌ མོ༌ཟེས༌སི༌ འི༌ ལོན༌བོ༌ ཡ༌ཝའ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “མི༌གུན༌ནི༌ ངའེ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏང༌ཁན༌བོ༌ ཚོར༌ཅེས༌སི༌ ཕིའ༌ སྲིན༌ ཐུག༌མོ༌ཞིག༌གི༌ ནང༌ང༌ ང༌ ཁྱོ༌རང༌ངི༌ཀ༌ ཡོང༌ཨིན༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཁྱོ༌རང༌ངི༌ཀ༌ ཨིད༌ཤེས༌ ཅོ༌ཨིན༌།” ཏེ༌ནེ༌ མི༌གུན༌ནི༌ ཟེར༌ཁན༌གུན༌ མོ༌ཟེས༌སི༌ ཡ༌ཝའ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “མི༌གུན༌ ཡོད༌ས༌ སོང༌ ཡང༌ དི༌རིང༌ དང༌ ཐོ༌རེ༌ ཁོ༌རང༌གུན༌ རྩང༌མ༌ ཅོ༌ཅུགས༌ཏེ༌ ཀོས༌ལག༌གུན༌ ཁྲུ༌ ཟེར༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ཞག༌ སུམ༌པའེ༌ ཞག༌ག༌ ཁོང༌གུན༌ གྲལ༌གྲིག༌ ཡོང༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌ ཞག༌ག༌ མི༌ ཚང༌མའེ༌ དུན༌ལ༌ ང༌ བབས༌ཏེ༌ སི༌ནཱའི༌ རིའི༌ཀ༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","རིའི༌ ལྡན༌ ཀྱིར༌སྐོར༌ཏེ༌ སྟགས༌ ཏོང༌ ཡང༌ ‘མི༌གུན༌ལ༌ ཏེ༌བོ༌ གོམས༌ཏེ༌ རིའི༌ཀ༌ མི༌ཆ༌ཅེས༌ ཡ༌ རིའ༌ ལག༌པ༌ མི༌རྩེ༌ཅེས༌ལ༌ ཟེར༌། ཀལ༌ཏེས༌ སུ༌ཞིག༌གི༌ རིའ༌ ལག༌པ༌ རྩེ༌ན༌ ཁོ༌ སད༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","སུ༌ཞིག༌གིའང༌ ཁོའ༌ ལག༌པ༌ རྩེ༌ མ༌གོས༌, ཁོའ༌ རྡོའ༌ གྱབས༌ཏེ༌ ཡ༌ དའ༌ ཏངས༌ཏེ༌ སད༌གོས༌། མི༌ ཨིན༌གྲོ༌ ཡ༌ སེམས༌ཅན༌ རིའ༌ ལག༌པ༌ རྩེས༌ཁན༌བོ༌ སད༌གོས༌།’ ཏུང༌བོ༌ རིང༌མོ༌ ཤེད༌ཅན༌ ཕུའ༌ཅིག༌ མི༌གུན༌ རིའི༌ཀ༌ ཡོང༌ནའང༌ གྲིག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ཏེ༌ནེ༌ མོ༌ཟེས༌ རི༌ནེ༌ བབས༌ཏེ༌ སོང༌ ཡང༌ མི༌གུན༌ལ༌ ཁོ༌རང༌གུན༌ རྩང༌མ༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཀོས༌ལག༌གུན༌ ཁྲུ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ཡང༌ མོ༌ཟེས༌སི༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌གུན༌ ཞག༌ སུམ༌པའེ༌ ཕིའ༌ གྲལ༌གྲིག༌ ཅོས༌ ཡང༌ འི༌ ཏུས༌ལ༌ ཞིད༌མད༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོ༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ཞག༌མ༌ སུམ༌པའེ༌ ང༌མོ༌ བྲུག༌ལྡིར༌ ཡང༌ སྐམ༌ལག༌ བར༌, རི༌ཀ༌ སྲིན༌ ཐུག༌མོ༌ བབས༌ ཡང༌ མ༌ ཤེད༌ཅན༌ ཏུང༌ སྐད༌ ཚོར༌། ཀུར༌ ཙུག༌སའེ༌ ནས༌སའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ མི༌ ཚང༌མ༌ ཇིགས༌ཏེ༌ དར༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ མི༌གུན༌ ཀུར༌ ཙུག༌སའེ༌ ནས༌ས༌ནེ༌ ཕིངས༌ཏེ༌ དཀོན༌མཆོག༌ ཉམ༌པོ༌ ཐུག༌ག༌ལ༌ ཁྱེརས༌། ཡང༌ ཁོང༌གུན༌ རིའི༌ ལྡན༌ནི༌ཀ༌ ལངས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","སི༌ནཱའི༌ རི༌ ཏུད༌པའེ༌ ཀབས༌ཏེ༌ ཡོད༌པིན༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ མེའེ༌ ནང༌ང༌ ཏེ༌ཀ༌ བབས༌ཏེ༌ སྐྱོདས༌། མེ༌ ཀྲག༌པོ༌ བར༌ཁན༌ནི༌ ཏུད༌པ༌ ཙོགས༌ལ༌ ཏུད༌པ༌ ཀེན༌ལ༌ ཆའད༌པིན༌ ཡང༌ རི༌ གང༌པོ༌ མ༌སྲན༌ཏྲེ༌ སྐུལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ཏུང༌ངི༌ སྐད༌པོ༌ མང༌ནེ༌ མང༌ང༌ ཤེད༌ཅན༌ སོང༌། ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ སྤེ༌ར༌ ཏངས༌ ཡང༌ དཀོན༌མཆོག༌གི༌ བྲུག༌ལྡིར༌ ཙོགས༌ ཤེད༌ཅན༌ སྐད༌དི༌ ནང༌ང༌ ལན༌སལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ཡ༌ཝ༌ སི༌ནཱའི༌ རི༌ གོའེ༌ཀ༌ བབས༌ཏེ༌ སྐྱོདས༌ ཡང༌ མོ༌ཟེས༌ལ༌ རི༌གོའ༌ ཡོང༌ཅེས༌ལ༌ མོལས༌། མོ༌ཟེས༌ རི༌ཀ༌ ཀེན༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “ཐུར༌ལ༌ བབས༌ཏེ༌ སོང༌ ཡང༌ མི༌གུན༌ལ༌ སྤང༌པུད༌ཏེ༌ ཟེར༌, ‘ཡ༌ཝ༌ དཀོན༌མཆོག༌ ལྟའ༌ཅེས༌ལ༌ སྟགས༌ ཏང༌ཁན༌བོ༌ གོམས༌ཏེ༌ མ༌ཡོང༌, ཀལ༌ཏེས༌ ཡོང༌ན༌ ཁྱོ༌ཞའ༌ མང༌པོ༌ ཤི༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ང༌ ཡ༌ཝའེ༌ དུན༌ལ༌ ཡོང༌ཅེས༌ཅན༌ནི༌ བླ༌མ༌གུན༌ནའང༌ རྩང༌མ༌ ཅོ༌གོས༌, ཏེ༌ མ༌ནེ༌ ངའེ༌ ཁོང༌གུན༌ལ༌ ཆད༌པ༌ ཏང༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","མོ༌ཟེས༌སི༌ ཡ༌ཝའ༌ ཟེརས༌, “མི༌གུན༌ རི༌ཀ༌ ཡོང༌ མི༌ཆོགས༌ ཅིའ༌ཞུ༌ན༌ ཉེ༌རང༌ངི༌ ང༌ཞའ༌ རི༌བོ༌ ཏམ༌པ༌ རྩིས༌ཏེ༌ སྟགས༌ ཏང༌ཅེས༌ ཡང༌ ཏེ༌སང༌ ཐལ༌ཏེ༌ མི༌ ཡོང༌ཅེས༌ལ༌ བཀའ༌ སལས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ཡ༌ཝའེ༌ ལན༌སལས༌, “ཡོག༌ག༌ སོང༌ ཡང༌ ཨ༌རོན༌ ཁྲིད༌ཏེ༌ ཁྱོང༌། ཨིན༌ནའང༌ བླ༌མ༌གུན༌ ཡ༌ མི༌གུན༌, སྟགས༌ ཏང༌ཁན༌བོ༌ གོམས༌ཏེ༌ ཡ༌ཝ༌ ཡོད༌སའ༌ ཡོང༌ཅེས༌ ཅོ༌ མ༌གོས༌ ཏེ༌ཟུག༌ ཅོ༌ན༌ ངའེ༌ ཁོང༌གུན༌ལ༌ ཆད༌པ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ཏེ༌ནེ༌ མོ༌ཟེས༌ ཡོག༌ག༌ མི༌གུན༌ ཡོད༌ས༌ སོང༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌གུན༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","དཀོན༌མཆོག༌གི༌ འི༌ ཞལ༌ཏ༌ ཚང༌མ༌ སལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ཁྱོ༌ཞ༌གུན༌, ཨི༌ཇིབ༌བི༌ ནས༌སའེ༌ ནང༌ང༌ ཚེ༌ཡོག༌ག༌ ཡོད༌ཁན༌བོའེ༌ ནང༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཁན༌ ང༌ ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ཁྱོ༌ཞའེ༌, ང༌ ཅིག༌པོ༌ མ༌ནེ༌ ཞན༌ སུའང༌ དཀོན༌མཆོག༌ རྩིས༌ཏེ༌ ཅོལ༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“ཁྱོ༌ཞ༌གུན༌ནི༌ ནམ༌ཁའེ༌ ནང༌ང༌ ཡ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཡ༌ ས༌ཀྱད༌དི༌ ཡོག༌ག༌ ཡ༌ ཚོའེ༌ ནང༌ང༌ ཡོད༌ཁན༌གུན༌ནི༌ ཟོས༌ཏེ༌ ནང༌ང༌ སྐུན༌དྲ༌ ཅོ༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ཏེ༌གུན༌ནི༌ དུན༌ལ༌ གོ༌ མ༌སྒུ༌ ཡ༌ ཏེ༌གུན༌ལ༌ མ༌ཅོལ༌ ཅིའ༌ཟེར༌ན༌ ང༌ ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཚིག༌རི༌ཅན༌ དཀོན༌མཆོག༌ ཨིན༌། ང༌ ཕངས༌ཏེ༌ སྡིག༌པ༌ ཅོ༌ཁན༌གུན༌ནི༌ མི༌རབས༌ སུམ༌པ༌ དང༌ ཞི༌པ༌ ཚག༌པའེ༌ ཕྲུ༌གུ༌གུན༌ལ༌ ངའེ༌ ཆད༌པ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ཨིན༌ནའང༌ ངའ༌ ཅམས༌པ༌ ཅོས༌ཏེ༌ ངའེ༌ ཁྲིམས༌གུན༌ལ༌ ཁའ༌ ཉན༌ཁན༌གུན༌ནི༌ མི༌རབས༌ སྟོང༌ ཚག༌པ༌ ངའེ༌ གྱུར༌ཇ༌ མེད༌ཁན༌ནི༌ ཅམས༌པ༌ སྟན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“ཁྱོ༌ཞ༌གུན༌ནི༌, ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌གི༌ ཚན༌ ཏོན༌མེད༌ལ༌ ཀོལ༌ མ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ ཚན༌ ཏོན༌མེད༌ལ༌ ཀོལ༌ཁན༌གུན༌ལ༌ ཁོང༌ངི༌ སྐྱོན༌མེད༌ ཐེའ༌ མི༌ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ཤབ༌བད༌དི༌ ངལ༌ཚོའེ༌ ཞག༌ ཨིད༌ཏུ༌ ཅོས༌ཏེ༌ ཏེ༌བོ༌ ཏམ༌པ༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ཁྱོ༌ཞ༌གུན༌ནི༌ ཞག༌ དྲུག༌པོའེ༌ ནང༌ང༌ ལས༌ ཚང༌མ༌ ཅོ༌གོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ཨིན༌ནའང༌ ཞག༌ རྡུན༌པ༌བོ༌ ངལ༌ཚོའེ༌ ཞག༌ ཨིན༌ནོག༌ ཀ༌བོ༌ ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཏང༌གོས༌། ཏེ༌ ཞག༌ག༌ སུ༌ཞིག༌གིའང༌ ལས༌ ཅོ༌ མ༌གོས༌། ཁྱོ༌ཞ༌, ཁྱོ༌ཞའེ༌ བུ༌ཚ༌ ཡ༌ བུ༌མོ༌, ཁྱོ༌ཞའེ༌ ཚེ༌ཡོག༌ བུ༌ཚ༌ ཡ༌ བུ༌མོ༌གུན༌, ཁྱོ༌ཞའེ༌ སེམས༌ཅན༌གུན༌ ཡ༌ ཞན༌ཡུལ༌ལི༌ མི༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཡུལ༌ལ༌ དུག༌ཁན༌ ཚང༌མའེ༌ ལས༌ ཅོ༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ཞག༌ དྲུག༌གི༌ ནང༌ང༌ ཡ༌ཝའེ༌ ནམ༌ཁའ༌, ཇིག༌རྟེན༌, ཚོ༌ དང༌ ཏེ༌གུན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཅོའ༌ ཛདས༌ ཨིན༌ནའང༌ ཞག༌ རྡུན༌པའེ༌ ཞག༌ག༌ ཁོང༌ ངལ༌ཚོའ༌ ཛདས༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ ཡ༌ཝའེ༌ ཤབ༌བད༌དི༌ ཞག༌པོའ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ ཏམ༌པ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“རང༌ངི༌ ཨ༌བ༌ དང༌ ཨ༌མའ༌ རྩི༌ཝ༌ ཅོས༌། ཏེ༌ནེ༌ ང༌ ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌གི༌ ཏང༌ཅེས༌ཅན༌ནི༌ ས༌ཆ༌བོའེ༌ ནང༌ང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ མི༌ཚེ༌ རིང༌མོ༌ ཕུད༌ ཐུབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“མི༌ མ༌སད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“རང༌ངི༌ ཞིད༌མད༌ མན༌པ༌ ཞན༌མ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ མ༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“རྐུན༌མ༌ མ༌རྐུ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“སུ༌ཞིག༌གི༌ གྱབ༌གལ༌ལ༌ སྤང༌པོ༌ ཟུན༌བ༌ མ༌ཏང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ཞན༌མའེ༌ ཁང༌པའེ༌ ཕིའ༌ དོད༌པ༌ མ༌ཅོ༌། ཞན༌མའེ༌ ན༌མ༌, བུ༌ཚ༌ ཡ༌ བུ༌མོ༌ ཚེ༌ཡོག༌, ལང༌ཏོ༌ ཡ༌ བུང༌བུ༌, ཡ༌ ཞན༌མའེ༌ ཨིན༌ཁན༌ ཅི༌ཞིག༌གི༌ ཕིའ༌ དོད༌པ༌ མ༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","མི༌གུན༌ནི༌, བྲུག༌ལྡིར༌ དང༌ སྐམ༌ལག༌ ཡང༌ ཏུང༌ངི༌ སྐད༌ ཀྲག༌པོ༌ དང༌ རི༌ནེ༌ ཏུད༌པ༌ བིང༌ང༌ ཐོང༌ང༌ཅིག༌ ཁོང༌གུན༌ ཇིགས༌ཏེ༌ དར༌ཨིན༌ ཐག༌རིང༌ང༌ ལངས༌ཏེ༌ དུགས༌ ");
INSERT INTO lbj_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","མི༌གུན༌ནི༌ མོ༌ཟེས༌ལ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ང༌ཞ༌གུན༌ལ༌ སྤེ༌ར༌ སལ༌ན༌ ང༌ཞའེ༌ ཉན༌ཨིན༌། ཨིན༌ནའང༌ དཀོན༌མཆོག༌ག༌ ང༌ཞའ༌ ཞལ༌ཏ༌ མི༌སལ༌ཅེས༌ལ༌ ཞུ༌ཝ༌ ཕུལ༌, ཏེ༌མན༌ན༌ ང༌ཞ༌གུན༌ ཤིའ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ཇིགས༌ མ༌ཇིགས༌། དཀོན༌མཆོག༌གི༌ ཇིགས༌སི༌ ནང༌ང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སྡིག༌པ༌ མི༌ཅོ༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཚོད༌ལྟ༌ ལེན༌ན༌ལ༌ སྐྱོད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ཨིན༌ནའང༌ མི༌གུན༌ ཐག༌རིང༌ང༌ དུགས༌ ཡང༌ མོ༌ཟེས༌ སྲིན༌ ཐུག༌མོ༌ ནག༌པོའེ༌ དུན༌ལ༌ སོང༌ ཀ༌རུ༌ དཀོན༌མཆོག༌ ཞུགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེར༌, ‘ངའེ༌ ཁྱོ༌ཞའ༌ ནམ༌ཁའ༌ནེ༌ སྤེ༌ར༌ ཏང༌ཁན༌བོ༌ ཁྱོ༌ཞའེ༌ ཐོང༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ངའེ༌ ཚབས༌ལ༌ ཅོལ༌ཅེས༌ལ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ མུལ༌ དང༌ སེར༌རི༌ སྐུན༌དྲ༌གུན༌ ཅོ༌ མ༌གོས༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“‘ངའེ༌ ཕིའ༌ ཀ༌ལག༌གི༌ ཆོད༌ཁྲི༌ རྩིག༌ ཡང༌ ཏེ༌ཀ༌ ར༌ལུག༌ དང༌ བ༌ལང༌ མེའ༌ སྲོགས༌ཁན༌ནི༌ ཆོད༌པ༌ དང༌ ཞི༌དེ༌ ཆོད༌པ༌ ཕུལ༌། ངའེ༌ ཅོལ༌ ཟེརས༌སའེ༌ ནས༌སའེ༌ཀ༌ ངའ༌ ཅོལ༌གོས༌, ཏེ༌ཀ༌ ང༌ ཡོངས༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ ཕིའ༌ རྡོའེ༌ ཆོད༌ཁྲི༌ རྩིག༌ན༌ རྡོའ༌ ལྡེ༌མོ༌ ཅགས༌ཁན༌ མ༌ཀོལ༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌ཞའེ༌ རྡོའ༌ ཅག༌ག༌ལ༌ ལག༌ཆ༌ ཀོལ༌ལ༌ཅིག༌ ཏེ༌བོ༌ ཏམ༌པ༌ མི༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","སྲེས༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཆོད༌ཁྲི༌ ཡོང༌ མ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌ཀ༌ ཛགས༌ ཟ༌ནེ༌ མི༌གུན༌ནི༌ བླ༌མའེ༌ ཟུགས༌པོའེ༌ ཁག༌ མ༌ ཀབ༌ཁན༌བོ༌ ཐོང༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “འི༌ ཁྲིམས༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“ཀལ༌ཏེས༌ ཁྱོ༌ཞའེ༌ ཨིབ༌རི༌པ༌ ཚེ༌ཡོག༌ ཉོ༌ན༌ ཁོའེ༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ལོ༌ དྲུག༌ ལས༌ ཅོ༌གོས༌། ཨིན༌ནའང༌ ལོ༌ རྡུན༌པའེ༌ ནང༌ང༌ ཅའང༌ བུ༌ལོན༌ མེད༌པ༌ ཁོའ༌ རང༌ཝང༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ཀལ༌ཏེས༌ ཚེ༌ཡོག༌གི༌ ལས༌ གོ༌ཟུག༌ ཟ༌ནེ༌ ཁོ༌ ན༌མ༌ མ༌ཅོ༌ཁན༌ ཨིན༌ན༌ ཁོ༌རང༌ ཅིག༌པོའ༌ རང༌ཝང༌ ཏོང༌ ཨིན༌ནའང༌ ལས༌ གོ༌ཟུག༌ ཟ༌ནེ༌ ཁོའ༌ ན༌མ༌ ཡོད༌ན༌ ཁོང༌ ཉིས༌ཀོའ༌ རང༌ཝང༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ཀལ༌ཏེས༌ ཁོའེ༌ སྤོན༌བོའེ༌ ཁོའ༌ ན༌མ༌ ཅོ༌ཅུགས༌ཏེ༌ ཁོའ༌ ཕྲུ༌གུ༌ ཇོར༌ན༌, ཁོ༌རང༌ ཅིག༌པོ༌ མ༌ནེ༌ རང༌ཝང༌ མི༌ ཐོབ༌, ཁོའེ༌ ན༌མ༌ དང༌ ཕྲུ༌གུ༌གུན༌ སྤོན༌བོའེ༌ ཕིའ༌ ལས༌ ཅོ༌ཨིན༌ དུགས༌ གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“ཨིན༌ནའང༌ ཚེ༌ཡོག༌གི༌, ‘ངའེ༌ སྤོན༌བོ༌, ང༌རང༌ངི༌ ན༌མ༌ དང༌ ཕྲུ༌གུ༌ གུན༌ལ༌ ཅམས༌པ༌ ཅོའད༌ ཡང༌ ང༌ རང༌ཝང༌ གོས༌ས༌ མེད༌’ ཟེར༌ན༌ ");
INSERT INTO lbj_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ཏེ༌ནེ༌ ཁོའེ༌ སྤོན༌བོའེ༌ ཁོ༌ ཏམ༌པ༌ ཀུར༌རི༌ དུན༌ལ༌ ཁྱེར༌ཏེ༌ སྒོའེ༌ཀ༌ དུག༌ཅུགས༌ཏེ༌ ལྕགས༌ ཙེབ༌ཙེབ༌ ཤིག༌ ཉམ༌པོ༌ ཁོའེ༌ ནམ༌ཅོག༌ག༌ བི༌ཡང༌ ཕུད༌གོས༌། ཏེ༌ནེ༌ ཁོ༌ མི༌ཚེ༌ གང༌པོའེ༌ ཕིའ༌ ཁོའེ༌ ཚེ༌ཡོག༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ཀལ༌ཏེས༌ མི༌ཞིག༌གི༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌བོ༌ ཚེ༌ཡོག༌ག༌ ཙོང༌ན༌, ཚེ༌ཡོག༌ བུ༌ཚ༌གུན༌ ཙོགས༌ལ༌ ཁོའ༌ རང༌ཝང༌ མ༌ཏང༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ཀལ༌ཏེས༌ སྤོན༌བོ༌ ཏེ༌ བུ༌མོ༌ བོར༌ཅེས༌ལ༌ ཐད༌ད༌ མེད༌ན༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ལོགས༌ཏེ༌ ཙོང༌གོས༌། སྤོན༌བོའེ༌ ཁོའེ༌ ཨ༌བ༌ ཉམ༌པོ༌ ཅོ༌ཁན༌ནི༌ ཆད༌དོན༌ ཅགས༌ཏེ༌ བུ༌མོ༌བོ༌ ཞན༌མི༌ཞིག༌ག༌ ཙོང༌ མི༌ཆོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ཀལ༌ཏེས༌ སྤོན༌བོའེ༌ བུ༌མོ༌ ཉོ༌ཁན༌བོ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཏང༌ན༌ ཁོའེ༌ ཏེ༌ བུ༌མོ༌བོའ༌ རང༌ངི༌ བུ༌མོ༌ ཙོགས༌ ཐོབ༌ཏང༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ཀལ༌ཏེས༌ སྤོན༌བོའེ༌ ཞན༌ཡང༌ ན༌མ༌ ཁྱོང༌ན༌ ཏེ༌ནེ༌ ཁོའེ༌ གོ༌མའེ༌ ན༌མའ༌, སྔུན༌ལ༌ ཏང༌ཁན༌ ཙོགས༌ ཟའ༌ཅེས༌, ཀོས༌ལག༌ དང༌ ཐོབ༌ཏང༌གུན༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ཀལ༌ཏེས༌ ཁོའེ༌ བུ༌མོ༌བོའ༌ ཏེ༌ སུམ༌ཀོ༌ མ༌ཏང༌ན༌ ཏེ༌ནེ༌ པེ༌ནེ༌ ཅིག༌གའང༌ ཤལ༌གོས༌ མེད༌པ༌ ཁོའེ༌ བུ༌མོ༌བོའ༌ རང༌ཝང༌ ཏང༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“མིའ༌ རྡུངས༌ཏེ༌ སད༌ཁན༌ནི༌ མི༌བོ༌ སད༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ཨིན༌ནའང༌ ཏེ༌བོ༌ མིང༌ནའང༌ མ༌ཅོའ༌ དཀོན༌མཆོག༌གི༌ ཇུང༌ཅུགས༌ཏེ༌ ཨིན༌ན༌ ཏེ༌ནེ༌ ཁོ༌ ངའེ༌ ལྡམས༌ཁན༌ནི༌ ས༌ཆའ༌ ཤོར༌ཏེ༌ ཆ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ཨིན༌ནའང༌ སུ༌ཞིག༌གི༌ ཅུས༌ངན༌ ལྡིངས༌ཏེ༌ སུ༌ཞིག༌ མིང༌ནའང༌ སད༌ན༌, ངའེ༌ ཆོད༌ཁྲིའི༌ ཀ༌ནེ༌ ཁོ༌ དྲུད༌ཏེ༌ ཁྱེར༌ ཡང༌ སོད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ཨ༌བ༌ ཡ༌ ཨ༌མ༌ རྡུང༌ཁན༌ནི༌ མི༌བོ༌ སད༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“སུ༌ཞིག༌གི༌ སང༌ཝའེ༌ ནང༌ང༌ མི༌ཞིག༌ རྐུས༌ཏེ༌ ཁོ༌ ཙོང༌ ཚར༌ ཡ༌ མ༌ཚར༌ར༌ ཡོད༌ན༌, རྐུན༌མ༌བོ༌ ཐོབ༌བ༌ཅིག༌ ཁོ༌ སད༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ཨ༌བ༌ ཡ༌ ཨ༌མ༌ རྔན༌ ཏབ༌ཁན༌ནི༌ མི༌བོ༌ སད༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ཀལ༌ཏེས༌ ཛིང༌མོ༌ ཏང༌ ཟ༌ནེ༌ ཅིག༌པོའེ༌ ཅིག༌པོའ༌ རྡོའ༌ ཡ༌ མུལ༌ཁྲུག༌ གྱབ༌ན༌ ཨིན༌ནའང༌ མི༌བོ༌ ཤི༌ མ༌ཤིའ༌ མལ༌ཙེ༌ཀ༌ ལུས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","སྟིང༌ནེ༌ ཁོ༌ གྱལ༌ཏེ༌ ཕི༌ལོག༌ག༌ བེར༌ཀ༌ སྟེན༌ཏེ༌ གྲུལ༌ཉན༌ན༌ རྡུང༌ཁན༌བོའ༌ ཆད༌པ༌ མི༌ཕོག༌ ཨིན༌ནའང༌ ཕོག༌ཁན༌བོའེ༌ ཏུས༌ གོད༌ལ༌ ཆའ༌ཁན༌བོའེ༌ ཕིའ༌ ཁོའེ༌ རིན༌ ཤལ༌གོས༌ ཡང༌ ཁོ༌ སིང༌ གྱལ༌གྱལ༌ ཚག༌པ༌ ཁོའེ༌ སྟ༌སྟོག༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ཀལ༌ཏེས༌ སུ༌ཞིག༌གི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཡ༌ བུ༌མོ༌ ཚེ༌ཡོག༌ག༌ བེར༌ཀ༌ ཉམ༌པོ༌ རྡུངས༌ཏེ༌ ཁོ༌ ཤི༌ན༌ ཏེ༌ནེ༌ དག༌པོ༌བོའ༌ ཆད༌པ༌ ཕོག༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ཨིན༌ནའང༌ ཚེ༌ཡོག༌པོ༌ ཞག༌པོ༌ ཅིག༌ ཡ༌ ཉིས༌ སོན༌ཏེའ༌ ལུས༌ན༌ དག༌པོ༌བོའ༌ ཆད༌པ༌ མི༌ཕོག༌ ཅིའ༌ཟེར༌ན༌ ཡོག༌པོ༌ དག༌པོའེ༌ གྱུ༌ནོར༌ ཨིན༌ནོག༌ ཡང༌ ཏེ༌བོ༌ ཁོའེ༌ ཕིའ༌ ཀོད༌ཀ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ཀལ༌ཏེས༌ བུ༌ཚ༌ ཉིས༌སི༌ ནོལ༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ བུ༌མོ༌ སྐྱེ༌ཅེས༌མ༌ ཞིག༌ག༌ ཕོག༌ཏེ༌ ཁོའེ༌ ཕྲུ༌གུ༌ ཤིགས༌ཏེ༌ ཨིན༌ནའང༌ སྲན༌ཏྲེ༌ མ༌སྐྱོན༌ སོང༌ཏེ༌ མེད༌ན༌, བུ༌མོའེ༌ མག༌པའེ༌ ཏོང༌ ཟེར༌ཁན༌ནི༌ པེ༌ནེ༌, ཁོའེ༌ ཁྲིམ༌སྤོན༌ནི༌ ཐག༌ཅད༌ཁན༌ ནང༌ཞིན༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ཨིན༌ནའང༌ མ༌སྐྱོན༌ སྲན༌ཏྲེ༌ ཆ༌ན༌ ཏེ༌ནེ༌ ཆད༌པ༌བོ༌ མ༌སྐྱོན༌བོ༌ནའང༌ ཟོབས༌ གོས༌, སྲོག༌གི༌ ཚབས༌ལ༌ སྲོག༌, ");
INSERT INTO lbj_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","མིག༌གི༌ ཚབས༌ལ༌ མིག༌, སོ༌ ཚབས༌ལ༌ སོ༌, ལག༌པའེ༌ ཚབས༌ལ༌ ལག༌པ༌, རྐང༌པའེ༌ ཚབས༌ལ༌ རྐང༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","མེའ༌ ཙིག༌ཁན༌ནི༌ ཚབས༌ལ༌ མེའ༌ ཙིག༌ཅུག༌ཅེས༌, མ༌ཁའེ༌ ཚབས༌ལ༌ མ༌ཁའ༌, ཕོག༌ཁན༌ནི༌ ཚབས༌ལ༌ ཕོག༌ཅུག༌ཅེས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ཀལ༌ཏེས༌ སུ༌ཞིག༌གི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཡ༌ བུ༌མོ༌ ཚེ༌ཡོག༌གི༌ མིག༌ག༌ ཕོག༌ ཅུགས༌ཏེ༌ ཞ༌ར༌ གྱུར༌ན༌ ཏེ༌བོའེ༌ ཚབས༌ལ༌ ཁོའེ༌ ཚེ༌ཡོག༌པོའ༌ རང༌ཝང༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ཀལ༌ཏེས༌ ཁོའེ༌ བུ༌ཚ༌ ཡ༌ བུ༌མོ༌ ཚེ༌ཡོག༌གི༌ སོ༌ ཕུད༌ཏེ༌ ཡོད༌ན༌ ཏེ༌བོའེ༌ ཚབས༌ལ༌ ཁོའེ༌ ཡོག༌པོ༌བོའ༌ རང༌ཝང༌ ཏང༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ཀལ༌ཏེས༌ ལང༌ཏོའེ༌ སུ༌ཞིག༌ག༌ ར༌ཅོ༌ གྱབས༌ཏེ༌ སད༌ན༌ ཏེ༌ ལང༌ཏོའ༌ རྡོའ༌ གྱབས༌ཏེ༌ སད༌གོས༌ ཡང༌ ཏེ༌བོའེ༌ ཤ༌ ཟའ༌ མ༌གོས༌ ཨིན༌ནའང༌ ཏེ༌བོའེ༌ དག༌པོའ༌ ཆད༌པ༌ མི༌ཕོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ཨིན༌ནའང༌ ལང༌ཏོའ༌ རྡུང༌ཅེས༌སི༌ ལོབས༌ ཡོད༌ན༌ ཡང༌ དག༌པོའ༌ སྤང༌པུད༌ཏེའང༌ ལང༌ཏོ༌ ལྡམས༌ཏེ༌ མ༌བོར༌ར༌ ཏེ༌བོའེ༌ མི༌ སད༌ན༌ ལང༌ཏོ༌བོའ༌ རྡོའ༌ གྱབས༌ཏེ༌ སོད༌ ཡང༌ དག༌པོ༌བོའང༌ སད༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ཨིན༌ནའང༌ ལང༌ཏོའེ༌ སད༌ཁན༌ནི༌ ཉེན༌གྲུང༌གུན༌ནི༌ ཁོའེ༌ སྲོག༌གི༌ ཚབས༌ལ༌ པེ༌ནེ༌ ཏོང༌ ཟེར༌ན༌ ཏེ༌ནེ༌ དག༌པོའེ༌ ཏོང༌ ཟེར༌ཁན༌ནི༌ པེ༌ནེ༌ ཏངས༌ཏེ༌ ཁོ༌རང༌ངི༌ སྲོག༌ ཉོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ཏེན༌ན༌ ལང༌ཏོའེ༌ སུ༌ཞིག༌གི༌ ཕྲུ༌གུ༌ སད༌ན༌ དག༌པོ༌བོའ༌ ཏེན༌ན༌ ཙོགས༌ ཆད༌པ༌ ཕོག༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ཏེན༌ན༌ ལང༌ཏོའེ༌ བུ༌ཚ༌ ཡ༌ བུ༌མོ༌ ཚེ༌ཡོག༌ ཤིག༌ སད༌ན༌, ལང༌ཏོའེ༌ དག༌པོའེ༌ ཚེ༌ཡོག༌གི༌ དག༌པོའ༌ མུལ༌ལི༌ པེ༌ནེ༌ སུམ༌ཅུ༌ ཤལ༌གོས༌ ཡང༌ ལང༌ཏོའ༌ རྡོའ༌ གྱབས༌ཏེ༌ སད༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“སུ༌ཞིག༌གི༌ ས༌དོང༌ང༌ ཀབ༌ཁན༌བོ༌ ཐེན༌ན༌ ཡ༌ ཁོའེ༌ ས༌དོང༌ བྲུས༌ཏེ༌ ཁའ༌ མ༌ཀབ༌ཁན༌བོའེ༌ ནང༌ང༌ ལང༌ཏོ༌ ཡ༌ བུང༌བུ༌ བུད༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ས༌དོང༌ངི༌ དག༌པོའེ༌ སེམས༌ཅན༌བོའེ༌ ཚབས༌ལ༌ ཏེ༌བོའེ༌ དག༌པོའ༌ པེ༌ནེ༌ ཏང༌གོས༌, ཡང༌ སེམས༌ཅན༌ ཤི༌ཁན༌ནི༌ ཤ༌བོ༌ ཁོའེ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“སུ༌ཞིག༌གི༌ ལང༌ཏོའེ༌ ཞན༌ཞིག༌གི༌ ལང༌ཏོ༌ སད༌ན༌, སོན༌ཏེའ༌ ཡོད༌ཁན༌ནི༌ ལང༌ཏོ༌ ཙོངས༌ཏེ༌ དག༌པོ༌ ཉིས༌ཀོའེ༌ པེ༌ནེ༌ དང༌ སེམས༌ཅན༌ ཤི༌ཁན༌ནི༌ ཤ༌ དྲན༌དྲའ༌ བགོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ཨིན༌ནའང༌ ལང༌ཏོ༌བོའ༌ རྡུང༌ཅེས༌སི༌ ལོབས༌ ཡོད༌ཏེའང༌ དག༌པོའེ༌ ཏེ༌བོ༌ ལྡམས༌ཏེ༌ མ༌བོར༌ར༌ ཨིན༌ན༌, ལང༌ཏོ༌ ཤི༌ཁན༌ནི༌ དག༌པོའ༌ ཁོའེ༌ ཞན༌ ལང༌ཏོ༌ཞིག༌ ཏང༌གོས༌། ཨིན༌ནའང༌ སེམས༌ཅན༌ ཤི༌ཁན༌ནི༌ ཤའ༌ ཁོའེ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཀལ༌ཏེས༌ སུ༌ཞིག༌གི༌ ལང༌ཏོ༌ ཡ༌ ལུག༌ རྐུས༌ཏེ༌ ཏེ༌བོ༌ ཙོང༌ ཡ༌ སད༌ན༌, ཁོའེ༌ ལང༌ཏོ༌ ཅིག༌གི༌ ཚབས༌ལ༌ ལང༌ཏོ༌ ལྔ༌ ཡང༌ ལུག༌ ཅིག༌གི༌ ཚབས༌ལ༌ ལུག༌ ཞི༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ཚན༌ལ༌ རྐུན༌མ༌ ཡོང༌ང༌ ཚོར༌ཏེ༌ རྐུན༌མ༌བོའ༌ བེར༌ཀ༌ གྱབས༌ཏེ༌ སད༌ན༌, མི༌ སད༌ཁན༌བོའེ༌ ཕིའ༌ ཁོ༌ ནོངས༌ཅན༌ ཐེ༌མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ཨིན༌ནའང༌ ཏེ༌བོ༌ ཉི༌མ༌ ཤར༌ཏེ༌ སྟིང༌ནེ༌ ཇུང༌ན༌ ཏེ༌ནེ༌ མི༌ སད༌ཁན༌བོའེ༌ ཕིའ༌ ཁོ༌ ནོངས༌ཅན༌ ཐེ༌གོས༌། རྐུན༌མ༌ མ༌ཤི༌ན༌ ཁོའེ༌ རྐུ༌ཁན༌ནི༌ ནོར༌ ཚང༌མ༌ ཡ༌ རིན༌ གང༌པོ༌ ལོགས༌ཏེ༌ ཤལ༌གོས༌། ཨིན༌ནའང༌ ཁོའ༌ ནོར༌ ཡ༌ རིན༌ ལོགས༌ཏེ༌ ཤལ༌གྱུ༌ མེད༌ན༌ ཁོའེ༌ ཁོ༌རང༌ ཚེ༌ཡོག༌ག༌ ཙོངས༌ཏེ༌ རིན༌ ཤལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ལང༌ཏོ༌ ཡ༌ ལུག༌ ཡ༌ བུང༌བུ༌, རྐུ༌ཁན༌བོ༌ སོན༌ཏེའ༌ ཐོབ༌ན༌, ཁོའེ༌ ཏེ༌བོའེ༌ཀ༌ ནན༌མ༌ ཏེ༌བོའེ༌ ཉི༌ལྡབ༌བོ༌ ལོག༌ཏེ༌ ཤལ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“མི༌ཞིག༌གི༌ ཁོ༌རང༌ངི༌ ཞིང༌ངི༌ཀ༌ ཡ༌ རྒུན༌ཚས༌སི༌ ནང༌ང༌ ཙཱ༌ ཟའ༌ལ༌ ཕུད༌ཁན༌ སེམས༌ཅན༌གུན༌ བིང༌ཏེ༌ ཞན༌མའེ༌ སྟོན༌ཐོག༌གུན༌ ཟའ༌ན༌, ཁོའེ༌ ཁོ༌རང༌ངི༌ ཞིང༌ ཡ༌ རྒུན༌ཚས༌སི༌ སྟོན༌ཐོག༌ གྱལ༌ཤོག༌པོ༌ ཏེ༌ མི༌བོའ༌ ཚབས༌ལ༌ ཏང༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“སུ༌ཞིག༌གི༌ ཁོ༌རང༌ངི༌ ཞིང༌ངི༌ ཙཱ༌ངན༌ མེའ༌ ཏུག༌ ཟ༌ནེ༌ ཏེ༌བོ༌ ཞན༌མའེ༌ ཞིང༌ང༌ ཁྱེབས༌ཏེ༌ ཞིང༌ རྔས༌ཁན༌ ཡ༌ སྐྱེ༌ཨིན༌ ཡོད༌ཁན༌ གུན༌ མེའ༌ ཞེན༌ན༌, མེ༌ གོ༌ཟུག༌ ཅོ༌ཁན༌ནི༌ མི༌བོའེ༌ ཀོད༌ཀ༌ ཆའ༌ཁན༌ནི༌ མི༌བོའ༌ རིན༌ གང༌པོ༌ ཤལ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“སུ༌ཞིག༌གི༌ ཁོ༌རང༌ངི༌ ཁྱིམ༌ཚེས༌པའེ༌ཀ༌ པེ༌ནེ༌ ཡ༌ རིན༌ཅན༌ ཅ༌ལག༌ ཅོལ༌ཏེ༌ བོར༌ཁན༌བོའ༌ རྐུན༌མ༌ ཤོར༌ཏེ༌ རྐུན༌མ༌བོ༌ ཐོབ༌ན༌ ཁོའེ༌ ཏེ༌བོའེ༌ ཉི༌ལྡབ༌ ལོགས༌ཏེ༌ ཤལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ཨིན༌ནའང༌ རྐུན༌མ༌བོ༌ མ༌ཐོབ༌ན༌ ཁོའེ༌ ཏེ༌ ནོར༌བོ༌ ཁོ༌རང༌ངི༌ ཁྱིམ༌ཚེས༌པ༌བོའེ༌ རྐུས༌ཏོག༌ག༌ མ༌རྐུས༌ཏོག༌ ཐག༌ཅད༌ཅེས༌ལ༌ ཁྲིམ༌སྤོན༌གུན༌ནི༌ དུན༌ལ༌ ཁོའེ༌ ཁྱོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ལང༌ཏོ༌, བུང༌བུ༌, ལུག༌, ཀོས༌ལག༌, ཡ༌ ཅི༌ཞིག༌ སྟོར༌ཁན༌བོའེ༌ དག༌པོ༌ ང༌ ཨིན༌ ཟེར༌ཏེ༌ ཛིང༌མོ༌ ཏང༌ཁན༌ནི༌ མི༌གུན༌ ཁྲིམ༌སྤོན༌གུན༌ནི༌ དུན༌ལ༌ ཁྱེར༌གོས༌། གལ༌ཅན༌ ཐེའ༌ ཛད༌ཁན༌བོའེ༌ ཞན༌མ༌བོའ༌ ཉི༌ལྡབ༌ ཤལ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“སུ༌ཞིག༌གི༌ ཁོ༌རང༌ངི༌ ཁྱིམ༌ཚེས༌པ༌ བུང༌བུ༌, ལང༌ཏོ༌, ལུག༌ ཡ༌ ཞན༌ཡང༌ སེམས༌ཅན༌ སྟ༌སྟོག༌ ཅོ༌ཅེས༌ལ༌ ཏང༌ཁན༌བོ༌ ཤི༌ན༌ ཡ༌ མ༌སྐྱོན༌ ཆ༌ན༌ ཡ༌ སུའང༌ མ༌ཐོང༌ང༌ རྐུས༌ཏེ༌ ཁྱེར༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ཁྱིམ༌ཚེས༌པ༌བོ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ སོང༌ཏེ༌ ཏེ༌ སེམས༌ཅན༌གུན༌ ཁོའེ༌ མ༌ རྐུས༌པིན༌ ཟེར༌ཏེ༌ ནའ༌ ཁུར༌ཏེ༌ སྟིང༌ནེ༌ དག༌པོའེ༌ ཏེ༌བོའ༌ ཨིད༌ཤེས༌ ཅོ༌གོས༌ ཡང༌ ཁྱིམ༌ཚེས༌པ༌ ཏེ༌བོའེ༌ རིན༌ ཤལ༌ མི༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ཨིན༌ནའང༌ སེམས༌ཅན༌བོ༌ རྐུས༌ཏེ༌ ཨིན༌ན༌, སྟ༌སྟོག༌ ཅོ༌ཅེས༌སི༌ ཁ༌ཆད༌ ཅོ༌ཁན༌བོའེ༌ སེམས༌ཅན༌ནི༌ དག༌པོའ༌ རིན༌ ཤལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","རིའི༌ སེམས༌ཅན༌ནི༌ སད༌ཏེ༌ ཨིན༌ན༌ སྟ༌སྟོག༌ ཅོ༌ཅེས༌སི༌ ཁ༌ཆད༌ ཅོ༌ཁན༌བོའེ༌ ལུས༌ཁན༌ནི༌ ཤའ༌ སྤང༌པོའེ༌ ཚུལ༌ལ༌ ཁྱོང༌གོས༌ ཡང༌ ཏེ༌བོའེ༌ རིན༌ ཤལ༌ མི༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“རང༌ངི༌ ཁྱིམ༌ཚེས༌པའེ༌ སེམས༌ཅན༌ སྐྱིས༌ཏེ༌ ཁྱོང༌ཁན༌བོའེ༌ དག༌པོ༌ དུན༌ལ༌ མེད༌ ཟ༌ནེ༌ ཏེ༌བོའ༌ མ༌སྐྱོན༌ ཡ༌ ཤི༌ན༌, ཁོའེ༌ དག༌པོའ༌ ཏེ༌བོའེ༌ རིན༌ གང༌པོ༌ ཤལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ཨིན༌ནའང༌ སེམས༌ཅན༌ནི༌ དག༌པོ༌ ཡོད༌ས༌ ཏེ༌ཟུག༌ ཆ༌ན༌ ཁོའ༌ ཏེ༌བོའེ༌ རིན༌ ཤལ༌ མི༌གོས༌། ཏེ༌བོ༌ སྐྱི༌ ཟ༌ནེ༌ ལ༌ ཏང༌ཁན༌བོ༌ ཤི༌ཁན༌ ཡ༌ མ༌སྐྱོན༌ ཆའ༌ཁན༌ནི༌ རིན༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“ཀལ༌ཏེས༌ མི༌ཞིག༌གི༌ ན༌མ༌ མ༌ཏྲིས༌ཁན༌ནི༌ བུ༌མོ༌ ལག༌པ༌ མ༌ཐུག༌ཁན༌ ཞིག༌ག༌ ལུས༌བྲེལ༌ ཅོ༌ཅེས༌སི༌ དོད༌པ༌ སྐྱེ༌ཅུགས༌ཏེ༌ ལུས༌བྲེལ༌ ཅོ༌ན༌ ཁོའེ༌ ཏེ༌ བུ༌མོ༌བོའ༌ ན༌མའེ༌ རིན༌ཐང༌ ཤལ༌ཏེ༌ ཁོ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ཨིན༌ནའང༌ བུ༌མོའེ༌ ཨ༌བ༌ ཁོའ༌ བུ༌མོ༌ ཏང༌ཅེས༌ལ༌ མ༌ཐད༌ནའང༌ ཁོའེ༌ ན༌མའེ༌ རིན༌ཐང༌ ལག༌པ༌ མ༌ཐུག༌ཁན༌ནི༌ བུ༌མོ༌ཞིག༌ག༌ ཤལ༌ཁན༌ དྲན༌དྲ༌ ཤལ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“ཆོས༌ངན༌ ཅོ༌ཁན༌ནི༌ བུ༌མོ༌གུན༌ སོན༌ཏེའ༌ དུག༌ མི༌ཆོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“སེམས༌ཅན༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ བོར༌ཁན༌གུན༌ སད༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ཡ༌ཝ༌ མན༌པ༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཆོད༌པ༌ ཕུལ༌ཁན༌གུན༌ སད༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“ཞན༌ཡུལ༌ལི༌ མི༌གུན༌ལ༌ ངན༌པ༌ ཡ༌ གོབ༌ནོན༌ མ༌ཅོ༌། ཨིད༌ཏུ༌ ཅོས༌, ཁྱོ༌ཞ༌གུན༌ནའང༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཞན༌ཡུལ༌ལི༌ མི༌ ཨིན༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“མག༌པ༌ ཤི༌ཁན༌ནི༌ བུ༌མོ༌ ཡ༌ ཕ༌མ༌ མེད༌ཁན༌ནི༌ ཕྲུ༌གུ༌ གུན༌ལ༌ ངན༌པ༌ མ༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ཀལ༌ཏེས༌ ངན༌པ༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ནི༌ རོགས༌སི༌ ཕིའ༌ ངའ༌ ཞུ༌ན༌ ངའེ༌ ཏན༌ཏན༌ ཁོང༌གུན༌ནི༌ མོས༌ལམ༌གུན༌ ཉན༌ཨིན༌, ");
INSERT INTO lbj_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ཡང༌ ངའེ༌ སྲོ༌ མེ༌ ཙོགས༌ལ༌ བར༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ ར༌འི༌ ཉམ༌པོ༌ སད༌ ཅུག༌ཨིན༌། ཏེ༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ན༌མ༌ མག༌པ༌ མེད༌ཁན༌ ཡང༌ ཕྲུ༌གུ༌ གུན༌ ཨ༌བ༌ མེད༌ཁན༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སྒོས༌དོམ༌ ཡོད༌ཁན༌ནི༌ ངའེ༌ མི༌གུན༌ལ༌ པེ༌ནེ༌ སྐྱིས༌ཏེ༌ ཏང༌ན༌, པེ༌ནེ༌ སྐྱིས༌ཏེ༌ ཏང༌ཁན༌གུན༌ ཙོགས༌ལ༌ ཁོང༌གུན༌ནི༌ ཀ༌ནེ༌ ཕར༌ མ༌ལེན༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ཀལ༌ཏེས༌ ཁྱོ༌ཞའེ༌ ཁོང༌གུན༌ནི༌ ཀོས༌པོ༌ དམ༌ཆའེ༌ ཚུལ༌ལ༌ ཁྱེར༌ན༌ ཉི༌མ༌ སྐྱོད༌དི༌ སང༌ སྔུན༌ལ༌ ཏེ༌བོ༌ ཁོང༌གུན༌ལ༌ ལོགས༌ཏེ༌ ཏང༌གོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ཅིའ༌ཟེར༌ན༌ ཟུགས༌པོ༌ ཀབ༌ཅེས༌ལ༌ ཁོའ༌ ཏེན༌ན༌ ཀོས༌པོ༌ མ༌ནེ༌ མེད༌ཏེ༌ ཨིན༌ནོག༌། ཏེ༌ནེ༌ ཉིད༌ཏང༌ ཟ༌ནེ༌ ཁོ༌ ཅི༌ གོན༌ཨིན༌? ཀལ༌ཏེས༌ ཁོའ༌ ནགས༌ ཐོང༌ཏེ༌ ངའ༌ བོད༌ན༌ ངའེ༌ ཁོའེ༌ མོས༌ལམ༌ ཉན༌ཨིན༌, ང༌ ནི༌ སྙིང༌རྗེ༌ཅན༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ དད༌ལོག༌ མ༌ཅོ༌ ཡ༌ རང༌ངི༌ མི༌གུན༌ནི༌ སྤོན༌བོའ༌ རྔན༌ མ༌ཏབ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“ཁྱོ༌རང༌གུན༌ནི༌ གྲུ༌ནས༌, ཆང༌ དང༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ གུན༌ནི༌ ཆོད༌པ༌ ཕུལ༌གོ༌ཤེས༌སི༌ ཏུས༌པོའེ༌ཀ༌ ངའ༌ ཕུལ༌།” “ཁྱོ༌ཞ༌གུན༌ནི༌ གོ༌སྐྱེས༌ བུ༌ཚ༌གུན༌ ངའ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ཏེན༌ན༌ ཙོགས༌ ཁྱོ༌ཞའེ༌ བ༌ལང༌ དང༌ ལུག༌ གུན༌ནི༌ གོ༌སྐྱེས༌ ཉམ༌པོ༌ ཅོས༌། ཏེ༌གུན༌ ཁོ༌རང༌ངི༌ ཨ༌མ༌ ཉམ༌པོ༌ ཞག༌མ༌ རྡུན༌ དུག༌ཅུག༌ ཨིན༌ནའང༌ ཞག༌མ༌ རྒྱད༌པའེ༌ ཞག༌ག༌ ཏེ༌བོ༌ ངའ༌ ཆོད༌པ༌ ཕུལ༌། ");
INSERT INTO lbj_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","ཁྱོ༌ཞའ༌ ངའེ༌ མི༌ ཏམ༌པ༌གུན༌ ཨིན༌ པ༌སང༌ རིའི༌ སེམས༌ཅན༌ནི༌ སད༌ཁན༌ནི༌ ཤ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཟའ༌ མ༌གོས༌, ཏེ༌བོ༌ ཁྱི༌གུན༌ལ༌ ཟའ༌ ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཟུན༌ཇན༌ སྤེ༌ར༌གུན༌ ཁྱེབས༌ མ༌ཅུག༌ ཡང༌ ངན༌པ༌ མིའ༌ རོགས༌ ཅོས༌ཏེ༌ ཟུས༌མའེ༌ སྤང༌པོ༌ མ༌ཏང༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ངན༌པ༌ ཅོ༌ཁན༌ནི༌ མི༌ཚོགས༌སི༌ སྟིང༌རང༌ནེ༌ མ༌ཆ༌། ཁྲིམས༌ཁུང༌ང༌ སྤང༌པོ༌ ཏང༌ ཟ༌ནེ༌ མི༌ཚོགས༌ ཉམ༌པོ༌ ཁའ༌ཆམས༌ཏེ༌ ཁྲིམ༌སྤོན༌ལ༌ འོས༌པ༌ མན༌ཁན༌ནི༌ ཐག༌ཅད༌ ཏང༌ མ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ཁྲིམས༌ཁུང༌ངི༌ ནང༌ང༌ ཉལ༌བ༌ཅན༌ ཞིག༌གི༌ ཤགས༌སི༌ ཐག༌ཅད༌ ཏང༌ ཟ༌ནེ༌ ཉལ༌བ༌ཅན༌ ཨིན༌ཅེས༌པོའེ༌ ཁོའ༌ ཆོགས༌ མ༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ཀལ༌ཏེས༌ ཁྱོ༌ཞའེ༌ གྲ༌འོའེ༌ ལང༌ཏོ༌ ཡ༌ བུང༌བུ༌ གྲོལ༌ཏེ༌ ཁོར༌ཨིན༌ ཐོང༌ན༌ ཏེ༌བོ༌ ལོགས༌ཏེ༌ ཁོའེ༌ ཁང༌པ༌ ཁྱེར༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ཀལ༌ཏེས༌ ཁྱོ༌ཞའ༌ ནཕ༌རད༌ ཅོ༌ཁན༌བོའེ༌ བུང༌བུ༌ རྒལ༌ལི༌ ནན༌ཏེ༌ གྱེལ༌ཏེ༌ ཐོང༌ན༌ ཏེ༌བོའ༌ སྣང༌མེད༌ མ༌ཅོའ༌, བུང༌བུ༌ ལང༌ཅེས༌ལ༌ ཁོའ༌ རོགས༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ཁྲིམས༌ཁུང༌ངི༌ ནང༌ང༌ ཉལ༌བ༌ཅན༌ནི༌ ཤགས༌པོའ༌ འོས༌པའེ༌ ཐག༌ཅད༌ ཐོབ༌ཅེས༌ ཏན༌ཏན༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ཟུས༌མ༌ སྐྱོན༌ མ༌ནེ༌ མི༌ཀལ༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌, ཡང༌ ནོངས༌མེད༌ ཡ༌ ཀྲང༌པོ༌ མི༌ཞིག༌ག༌ ཤི༌ཅེས༌སི༌ ཁྲིམས༌ཅད༌ མ༌ཏང༌། ཏེ༌ཙོགས༌ ངན༌པ༌ ཅོ༌ཁན༌བོའ༌ ངའེ༌ ཤགས༌པ༌ མི༌ཏང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“ཕག༌སུབ༌ མ༌ལེན༌, ཅིའ༌ཟེར༌ན༌ ཏེ༌བོའེ༌ ཁྱོ༌རང༌ང༌ ཐོང༌ཁན༌བོ༌ སྣང༌མེད༌ ཅོ༌ཅུགས༌ཏེ༌ ཀྲང༌པོ༌ སྤང༌པོ༌ ཏང༌ཅེས༌པོའེ༌ ནང༌ང༌ གྱུར༌ཇ༌ ཁྱོང༌ ཅུག༌ག༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“ཞན༌ཡུལ༌ལི༌ མི༌གུན༌ལ༌ གོབ༌ནོན༌ མ༌ཏང༌, ཏེ༌ཟུག༌ ཅོ༌ན༌ ཀ༌ཟུག༌ཤིག༌ ཡོང༌ཅེན༌ ཁྱོ༌ཞ༌གུན༌ལ༌ གྱུས༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ ཁྱོ༌ཞའ༌ ཏེ༌ཙོགས༌ ཅོས༌ཏེ༌ ཨིན༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ལོ༌ དྲུག༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ས༌ཀྱད༌གུན༌ བད༌ཏེ༌ སྟོན༌ཐོག༌ ལྡུམ༌, ");
INSERT INTO lbj_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ཨིན༌ནའང༌ ལོ༌ རྡུན༌པའེ༌ ནང༌ང༌ ཏེ༌གུན༌ མ༌བད༌ད༌ བོར༌ ཏེ༌ནེ༌ ཏེ༌ཀ༌ སྐྱེས༌ཁན༌གུན༌ ཉལ༌བ༌ཅན༌གུན༌ནི༌ ཟའ༌ལ༌ ཁྱེར༌ཏེ༌ ལག༌ལུས༌པོ༌ རིའི༌ སེམས༌ཅན༌གུན༌ནི༌ ཟའ༌ཉན༌ཨིན༌། ཏེན༌ན༌ ཙོགས༌ ཁྱོ༌ཞ༌གུན༌ནི༌ རྒུན༌ཚས༌ དང༌ ཨོ༌ལིཝ༌ཝི༌ ལྕང༌མ༌གུན༌ ཉམ༌པོའང༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“རྡུན༌ཞག༌གི༌ ཞག༌མ༌ དྲུག༌པོ༌ ལས༌ ཅོས༌ ཨིན༌ནའང༌ ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ ལས༌ མ༌ཅོའ༌ ངལ༌ཚོ༌ གོས༌། ཏེ༌ནེ༌ ཁྱོ༌ཞའེ༌ ཚེ༌ཡོག༌གུན༌, ལས༌ལ༌ ཀོལ༌ཁན༌ནི༌ སེམས༌ཅན༌གུན༌ དང༌ ཞན༌ཡུལ༌ལི༌ མི༌གུན༌ ངལ༌ཚོས༌ཏེ༌ སྟོབས༌གུན༌ སོ༌ ཐུབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ང༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཟེར༌ཁན༌ ཚང༌མ༌ ཅོས༌། ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ མོས༌ལམ༌ མ༌ཞུ༌, ཏེ༌གུན༌ནི༌ མིང༌ངའང༌ མ༌ཁུར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ལོ༌ ཅིག༌གི༌ ནང༌ང༌ ངའ༌ རྩི༌ཝ༌ ཅོ༌ཅེས༌ལ༌ ཏུས༌ཆེན༌ སུམ༌ རྩིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ཏང༌པོ༌, ངའེ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ བིང༌ཏེ༌ ཡོང༌ཁན༌ནི༌ ཨ༌བིབ༌བི༌ ཟླ༌ཝའེ༌ ནང༌ང༌ ལྡམས༌ཁན༌ནི༌ ཏུས༌པོའེ༌ཀ༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཏུས༌ཆེན༌ རྩིས༌། འི༌ ཏུས༌ ཞག༌ རྡུན༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཟོ༌།” “ལག༌པ༌ སྟོང༌པ༌ སུ༌ཞིག༌གའང༌ ངའེ༌ དུན༌ལ༌ མ༌ཡོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“ཉིས༌པ༌; སྟོན༌ཐོག༌ རྔ༌ཅེས༌སི༌ ཏུས༌ཆེན༌ རྩིས༌, ཏེ༌ཏུས༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གོ༌མའེ༌ སྟོན༌ཐོག༌ རྔ༌ཁན༌ནི༌ ཁག༌ཤིག༌ ངའ༌ ཕུལ༌གོས༌།” “སུམ༌པ༌; ལོའེ༌ སྟིང༌ཇུག༌གི༌ སྟོན༌ཐོག༌ ཚང༌མ༌ ནང༌ང༌ ལྡུམས༌ཏེ༌ ཁྱོང༌ཅེས༌སི༌ ཏུས༌ཆེན༌ རྩིས༌, ཀ༌བོའེ༌ ནང༌ང༌ རྒུན༌ དང༌ ཞན༌ ཤིང༌ཏོག༌ གུན༌ནའང༌ ཐེས༌ཏེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“ལོའེ༌ ནང༌ང༌ ལན༌ སུམ༌ ཁྱོ༌ཞའེ༌ བུ༌ཚ༌ ཚང༌མ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ དུན༌ལ༌ ཁོང༌ང༌ ཅོལ༌ཅེས༌ལ༌ ཛོམ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ངའ༌ སེམས༌ཅན༌ སྲོག༌ཆོད༌ལ༌ ཕུལ༌ ཟ༌ནེ༌ ཏེ༌བོ༌ ཉམ༌པོ༌ སྐྱུར༌ཅན༌ནི༌ ཏ༌གི༌ མ༌ཕུལ༌། སེམས༌ཅན༌ནི༌ ཚིལ༌ ཆོད༌པ༌ ཕུལ༌ཁན༌གུན༌ སྟིང༌མ༌ཞག༌གི༌ ང༌མོ༌ ཚོག༌པ༌ བོར༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“ཁྱོ༌ཞའེ༌ ཏབ༌ཁན༌ནི༌ སྟོན༌ཐོག༌གི༌ གོ༌མའེ༌ བྲས༌བུ༌ གྱལ༌ཤོག༌པོ༌ ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ ཆོད༌ཁང༌ང༌ ཁྱོང༌།” “རི༌གུའི༌ ཤ༌ ཏེ༌བོའེ༌ ཨ༌མའེ༌ འོ༌མའེ༌ ནང༌ང༌ མ༌ སྐོལ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ངའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སྔུན༌སྔུན༌ལ༌ ཕོ༌ཉ༌ ཀལ༌ཨིན༌, ཁོའེ༌ བེས༌སི༌ ནང༌ང༌ ཁྱོ༌ཞ༌གུན༌ སྐྱོབས༌ཏེ༌ ངའེ༌ གྲལ༌གྲིག༌ ཅོ༌ཁན༌ནི༌ ནས༌སའེ༌ ནང༌ང༌ ཁྱེར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ནང༌སྟག༌ ཏངས༌ཏེ༌ ཁོའེ༌ ཁའ༌ཉོན༌། ཁོའེ༌ གྱབ༌གལ༌ལ༌ ངོ༌ལོག༌ མ༌ཅོ༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ ངའེ༌ ཚབས༌ ཨིན༌ ཡང༌ ཁོའེ༌ ཁྱོ༌ཞའེ༌ ངོ༌ལོག༌ ཅོ༌ཁན༌གུན༌ལ༌ ཤགས༌པ༌ མི༌ཏང༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁོའེ༌ ཁའ༌ཉན༌ཏེ༌ ངའེ༌ བཀའ༌ ཏང༌ཁན༌ ཚང༌མ༌ ཅོ༌ན༌, ངའ༌ ཁྱོ༌ཞའེ༌ གྲ༌འོ༌གུན༌ནི༌ གྲ༌འོ༌ ཡང༌ ཁྱོ༌ཞའ༌ གྱབ༌གལ༌ ཅོ༌ཁན༌གུན༌ལ༌ ངའེ༌ གྱབ༌གལ༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ངའེ༌ ཕོ༌ཉ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སྔུན༌སྔུན༌ལ༌ ཆེན༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ ཨ༌མོར༌པ༌, ཧེད༌པ༌, པེ༌རིཟ༌པ༌, ཀེ༌ནན༌པ༌, ཧིཝ༌པ༌, ཡང༌ ཡེ༌བས༌པ༌ གུན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱེར༌ཨིན༌ ཡང༌ ངའེ༌ ཁོང༌གུན༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ཁོང༌ངི༌ སྐུན༌དྲ༌གུན༌ནི༌ དུན༌ལ༌ གོ༌ མ༌སྒུ༌ ཡ༌ ཏེ༌གུན༌ལ༌ ཅོལ༌ མ༌ཅོལ༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཆོས༌ ཅོ༌ ཚུལ༌གུན༌ ལེན༌ མ༌ལེན༌། ཁོང༌གུན༌ནི༌ སྐུན༌དྲ༌གུན༌ ཁྲེས༌ཏོར༌ ཅོ༌གོས༌ ཡང༌ ཁོང༌གུན༌ནི༌ རྡོའེ༌ ཀ༌ཝ༌ ཏམ༌པ༌ ཐེ༌ཁན༌གུན༌ ཏུམ༌པ༌ ཏུམ༌པའེ༌ ནང༌ང༌ ཅོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ང༌ ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཅོལ༌ ཡང༌ ངའེ༌ ཁྱོ༌ཞའེ༌ ཟའ༌ཅེས༌ དང༌ ཐུང༌ཅེས༌ གུན༌ནི༌ཀ༌ ཅིན༌ལབས༌ ཏང༌ཨིན༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཟུ༌མོ༌ ཡོང༌ མི༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ཁྱོ༌ཞའེ༌ ཡུལ༌ལ༌ བུ༌མོ༌ སུ༌ཞིག༌གིའང༌ ཕྲུ༌གུ༌ མི༌ཞིག༌ ཡ༌ ཕྲུ༌གུ༌ མ༌ཇོར༌ར༌ མི༌ལུས༌། ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ མི༌ཚེ༌ རིང༌མོ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“ངའེ༌ ཁྱོ༌ཞའེ༌ སྔུན༌ལ༌ ཇིགས༌ནང༌ ཀལ༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ཁན༌ནི༌ མི༌གུན༌ནི༌ ནང༌ང༌ ཐེ༌ཚོམས༌ སྐྱེ༌ཅུག༌ཨིན༌ ཡང༌ ངའེ༌ ཁྱོ༌ཞའེ༌ གྲ༌འོ༌གུན༌ ལོགས༌ཏེ༌ ཤོར༌ ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ངའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གྲ༌འོ༌ ཧིཝ༌པ༌, ཀེ༌ནན༌པ༌, ཧེད༌པ༌ གུན༌ལ༌ ཇིགས༌ནང༌ སྲན༌ཏྲེ༌ སྟན༌ཏེ༌ ཁྱོ༌ཞའེ༌ དུན༌ལ༌ ཁོང༌གུན༌ ཏེ༌ ས༌ཆའེ༌ ནང༌ནེ༌ ཕིང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ངའེ༌ ཁོང༌ ཚང༌མ༌ ལོ༌ ཅིག༌གི༌ ནང༌ང༌ ཕིངས༌ཏེ༌ མི༌ཏང༌, ཀལ༌ཏེས༌ ཏང༌ན༌ ས༌ཆ༌བོ༌ ཐང༌སྟོང༌ གྱུར༌ཏེ༌ རིའི༌ སེམས༌ཅན༌ མང༌པོ༌ ཕེལ༌ཏེ༌ ཁྱོ༌ཞའ༌ ཇིགས༌ནང༌ ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ཁྱོ༌ཞ༌གུན༌ ཕེལ༌ཏེ༌ འི༌ ས༌ཆ༌ ཁྱོ༌ཞའེ༌ གྱུར༌གྱུར༌ ཚག༌པ༌ ངའེ༌ ཁོང༌གུན༌ ཉུ༌ངུན༌ ཉུ༌ངུན༌ ཅོས༌ཏེ༌ ཕིང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“ངའེ༌ ཁྱོ༌ཞའེ༌ སན༌ཚམས༌གུན༌ ཚོ༌ མར༌པོ༌ནེ༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌ ཚོག༌པ༌ ཡང༌ རི༌སྟོང༌ནེ༌ ཡུཕ༌རེ༌ཀྲས༌སི༌ ལྩངས༌པོ༌ ཚོག༌པ༌ ཕེལ༌ ཅུག༌ཨིན༌། ངའེ༌ ཁྱོ༌ཞའེ༌ ལག༌ག༌ ཏེ༌ ས༌ཆའེ༌ ནང༌ང༌ ནས༌ཁན༌ནི༌ མི༌གུན༌ ཏང༌ཨིན༌ ཡང༌ ཁྱོ༌ཞའ༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ཡོང༌ ཟ༌ནེ༌ ཁྱོ༌ཞའེ༌ ཁོང༌གུན༌ ཕིངས༌ཏེ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ཁྱོ༌ཞའེ༌ ཁོང༌གུན༌ ཡ༌ ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ གུན༌ ཉམ༌པོ༌ ཆད༌དོན༌ ཅོ༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ཁོང༌གུན༌ ཁྱོ༌ཞའེ༌ ཡུལ༌ལི༌ ནང༌ང༌ དུག༌ མ༌ཅུག༌, ཀལ༌ཏེས༌ དུག༌ཅུག༌ན༌ ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཅོལ༌ཅེས༌སི༌ ནང༌ང༌ ཁྱོ༌ཞའ༌ ཁད༌ཅུགས༌ཏེ༌ ངའེ༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཅོ༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཁྱོ༌རང༌, ཨ༌རོན༌, ན༌དབ༌, ཨ༌བི༌ཧུ༌ དང༌ ཨིས༌ར༌ཨེལ༌ལི༌ སྤོན༌བོ༌ རྡུན༌ཅུ༌ ང༌ ཡོད༌ས༌ རིའི༌ཀ༌ ཀེན༌ལ༌ ཡོང༌། ཁྱོ༌ཞ༌གུན༌ ཐག༌རིང༌ང༌ དུགས༌ཏེ༌ ངའ༌ ཅོལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","མོ༌ཟེས༌ ཁྱོ༌རང༌ ཅིག༌པོ༌ ང༌ ཡ༌ཝའེ༌ ཉེ༌མོའ༌ ཡོང༌ནའང༌ གྲིག༌ ཨིན༌ནའང༌ ཞན༌གུན༌ ངའེ༌ ཉེ༌མོའ༌ ཡོང༌ མ༌གོས༌། རི༌ ཡོག༌ག༌ ཡོད༌ཁན༌ ཞན༌ མི༌གུན༌ རིའི༌ཀ༌ ཀེན༌ལ༌ ཡོང༌ མི༌ཆོགས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","མོ༌ཟེས༌ ཐུར༌ལ༌ ཡོངས༌ཏེ༌ མི༌གུན༌ལ༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌ ཚང༌མ༌ དང༌ ཁྲིམས༌གུན༌ ཤདས༌། ཏེ༌ནེ༌ མི༌ ཚང༌མའེ༌ སྐད༌ ཅིག༌གི༌ ནང༌ང༌ ལན༌ཏངས༌, “ང༌ཞའེ༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌ ཚང༌མ༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","མོ༌ཟེས༌སི༌ ཡ༌ཝའེ༌ མོལ༌ཁན༌ ཚང༌མ༌ བྲིས༌། ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ནེ༌ ཁོའེ༌ རིའི༌ དུན༌ལ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌ རྕུག༌ཉིས༌སི༌ ཕིའ༌ རྡོའ༌ རྕུག༌ཉིས༌ ཀ༌ཝ༌ ཙོགས༌ལ༌ ལངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ཏེ༌ནེ༌ ཁོའེ༌ ཞུ༌ནུ༌ ཁ༌ཅིག༌ ལྡམས༌ ཡང༌ ཁོང༌གུན༌ནི༌ མེའ༌ སྲག༌ཁན༌ནི༌ ཆོད༌པ༌ དང༌ ཞི༌དེ༌ ཐུན༌བྲེལ༌ལི༌ ཕིའ༌ ལོ༌ ཆུ༌ངུན༌ ལང༌ཏོ༌གུན༌ ཡ༌ཝའ༌ ཆོད༌པ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","མོ༌ཟེས༌སི༌ སེམས༌ཅན༌ནི༌ ཁྲག༌ ཕེད༌པོ༌ ནོད༌དི༌ ནང༌ང༌ བོརས༌ ཡང༌ ཕེད༌པོ༌ ཆོད༌ཁྲི༌ཀ༌ ཡོགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ཏེ༌ནེ༌ ཁོའེ༌ ཆད༌དོན༌ནི༌ སྤེ༌ཆ༌ ཁུར༌ཏེ༌ མི༌གུན༌ནི༌ དུན༌ལ༌ སིལས༌། ཁོང༌གུན༌ནི༌ ཟེརས༌, “ང༌ཞ༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཁའ༌ ཉན༌ཏེ༌ ཁོང༌ངི༌ མོལ༌ཁན༌ ཚང༌མ༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ནོད༌དི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཁྲག༌པོ༌ ཁུར༌ཏེ༌ མི༌གུན༌ནི༌ཀ༌ ཐོར༌མ༌ ཏངས༌ ཡང༌ ཟེརས༌, “འི༌ ཁྲག༌པོ༌, ཆད༌དོན༌ སྟན༌པོ༌ ཅོ༌ཁན༌ནི༌ ཐེ༌ཙེ༌ ཨིན༌ ཀ༌བོ༌ ཡ༌ཝའེ༌ འི༌ ལབ༌ཞ༌གུན༌ སལ༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ ཉམ༌པོ༌ ཅོའ༌ ཛད༌ཏེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","མོ༌ཟེས༌, ཨ༌རོན༌, ན༌དབ༌, ཨ༌བི༌ཧུ༌ དང༌ ཨིས༌ར༌ཨེལ༌ལི༌ སྤོན༌བོ༌ རྡུན༌ཅུ༌ ཀེན༌ལ༌ རིའི༌ཀ༌ སོང༌ ");
INSERT INTO lbj_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ཡང༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཇལ༌། ཁོང༌ངི༌ ཞབས༌སི༌ ཡོག༌ག༌ རིན༌ཅན༌ རྡོའ༌ སྔོན༌པོ༌ ནི༌ལིམ༌ ཏིང༌ཁན༌ ཙོགས༌ ཀ༌བོ༌ ནམ༌ ཙོགས༌ སལ༌པོ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ཨིས༌ར༌ཨེལ༌ལི༌ སྤོན༌བོ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཇལ༌ ཨིན༌ནའང༌ ཁོང༌ངི༌ ཁོང༌གུན༌ལ༌ ནོད༌པ༌ སྐྱལ༌ལ༌ མ༌ཛདས༌ ཡང༌ ཁོང༌གུན༌ ཟེན༌, ཐུང༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ ཁོང༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ང༌ ཡོད༌ས༌ རིའི༌ཀ༌ ཀེན༌ལ༌ ཡོངས༌ཏེ༌ ཏེ༌ཀ༌ དུག༌, ངའེ༌ ཁྱོ༌རང༌ང༌ རྡོའ༌ ལེབ༌ལེབ༌ ཉིས༌སི༌ཀ༌ མི༌གུན༌ལ༌ ལབ༌ཞ༌ ཏང༌ཁན༌ནི༌ བཀའ༌ དང༌ ཁྲིམས༌གུན༌ བྲིས༌ཏེ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","མོ༌ཟེས༌སི༌ ཁོའ༌ རོགས༌ཅོ༌ཁན༌ ཡོ༌ཤུའ༌ ཁྲིད༌ཏེ༌ ཀེན༌ལ༌ དཀོན༌མཆོག༌གི༌ རི༌ཀ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","མོ༌ཟེས༌སི༌ སྤོན༌བོ༌གུན༌ལ༌ ཟེརས༌, “ང༌ཞའ༌ ལོགས༌ཏེ༌ ཡོང༌ཡོང༌ ཚོག༌པ༌ ཁྱོ༌ཞ༌གུན༌ འི༌ཀ༌ སྲུངས༌ཏེ༌ དུག༌། ཨ༌རོན༌ དང༌ ཧུར༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ཨིན༌ནོག༌ ཡང༌ ཛིང༌མོ༌ ཆ༌ན༌ ཁོང༌ ཉིས༌ཀོའ༌ ཐག༌ཅད༌ ཏང༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","མོ༌ཟེས༌ ཀེན༌ལ༌ རི༌ཀ༌ སོང༌ ཡང༌ རི༌བོ༌ སྲིན༌ནི༌ ཀབས༌, ");
INSERT INTO lbj_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ཡང༌ ཡ༌ཝའེ༌ ཟིར༌རྗིད༌ སི༌ནཱའི༌ རི༌ཀ༌ བབས༌ས༌ ཛད༌ཏེ༌ ཞག༌ དྲུག༌ ཏེ༌བོ༌ སྲིན༌ནི༌ ཀབས༌ཏེ༌ ལུས༌ ཡང༌ ཞག༌ རྡུན༌པའེ༌ ཞག༌ག༌ སྲིན༌ནི༌ ནང༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བོད༌ད༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཡ༌ཝའེ༌ ཟིར༌རྗིད༌པོ༌ རི༌གོའ༌ མེ༌ ཞེན༌ཁན༌ ཙོགས༌ ཐོང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","མོ༌ཟེས༌ ཀེན༌ལ༌ རི༌ཀ༌ སྲིན༌ནི༌ ནང༌ང༌ སོང༌ ཡང༌ ཏེ༌རུ༌ ཁོ༌ ཉི༌མ༌ ཞིབ༌ཅུ༌ དང༌ ཚན༌ ཞིབ༌ཅུ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ‘ངའ༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌ ཁྱོང༌’ ཟེར༌། ཐད༌པོ༌ ཉམ༌པོ༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌ལ༌ ཁྱོང༌ཁན༌ ཚང༌མ༌ ལེན༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","མི༌གུན༌ནི༌ ཀ༌ནེ༌ འི༌ ཆོད༌པ༌གུན༌ ལེན༌: སེར༌, མུལ༌ དང༌ ར༌གན༌, ");
INSERT INTO lbj_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","སྔོན༌པོ༌, སྔོ༌མར༌ ཡང༌ མར༌པོ༌ ནས༌མ༌ ཡང༌ གྱལ༌ལ༌ ཀུས༌པོ༌ རས༌ དང༌ ར༌མའེ༌ བལ༌, ");
INSERT INTO lbj_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","རང༌ མར༌པོ༌ ཏང༌ཁན༌ནི༌ ལུག༌ཕོའེ༌ པགས༌པ༌ དང༌ ཀོའ༌ གྱལ༌ལ༌, ཨ༌ཀ༌ཤིའེ༌ ཤིང༌, ");
INSERT INTO lbj_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","འོད༌དི༌ ཕིའ༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌, ཁྲུས༌ཏང༌ཅེས༌སི༌ མར༌ནག༌ དང༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌སི༌ ཕིའ༌ ཚ༌མིག༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ཨེ༌ཕོད༌ དང༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌སི༌ཀ༌ ཏག༌ཅེས༌ལ༌ ཨོ༌ནེཀས༌ དང༌ ཞན༌ ཁྲ༌རྡོའ༌ རིན༌ཅན༌གུན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“མི༌གུན༌ལ༌ ངའེ༌ ཕིའ༌ ཏམ༌པའེ༌ ཀུར༌ ཙེམ༌ཅུག༌, ཏེ༌ནེ༌ ང༌ ཁོང༌གུན༌ ཉམ༌པོ༌ དུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ཀུར༌ དང༌ ཏེ༌ ནང༌ང༌ ཡོང༌གོ༌ཤེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ སྟན༌ཅེས༌ཅན༌ ནང༌ཞིན༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“ཁོང༌གུན༌ལ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ སྒམ༌ཞིག༌ ཅོ༌ཅུག༌ ཀ༌བོའེ༌ རིང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 110, ཞང༌ དང༌ ཐོན༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 66 ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ཏེ༌བོའེ༌ ནང༌ཀུག༌ དང༌ ཕི༌ལོག༌ ཉིས༌ཀོ༌ སེར༌ ཉམ༌པོ༌ ཏུམ༌ ཡང༌ ཏེ༌བོའེ༌ ཐའ༌མ༌ ཚང༌མ༌ ཀིར༌ སྐོར༌ཏེ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","སེར༌རི༌ ཀྱི༌ལྡིར༌ ཞི༌ ཅོས༌ཏེ༌ ཏེ༌བོའེ༌ རྐང༌ ཞི༌ཀོའ༌ ཏག༌གོས༌, འི༌ངོ༌ ཆོགས༌ལ༌ ཉིས༌ ཡང༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཉིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཀྲ༌ལུ༌ ཁྱོངས༌ཏེ༌ ཏེ༌གུན༌ སེར༌རི༌ ཏུམ༌, ");
INSERT INTO lbj_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ཡང༌ སྒམ༌བོ༌ ཁུར༌ཅེས༌ལ༌ ཀྲ༌ལུ༌གུན༌ ཏེ༌བོའེ༌ ཆོགས༌ ཉིས༌ཀོའ༌ ཡོད༌ཁན༌ནི༌ ཀྱི༌ལྡིར༌ གུན༌ནི༌ ནང༌ང༌ གྱུད༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ཀྲ༌ལུ༌གུན༌ ཀྱི༌ལྡིར༌གུན༌ནི༌ ནང༌ནེ༌ མ༌ཕིང༌ང༌ ཏེ༌གུན༌ནི༌ ནང༌ང༌ གྱུད༌ཏེ༌ བོར༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ཏེ༌ནེ༌ ངའེ༌ བཀའ༌རྒྱ༌ རྕུ༌ རྡོའ༌ ལེབ༌ལེབ༌ གུན༌ནི༌ཀ༌ བྲིས༌ཏེ༌ ཏང༌ཅེས༌ཅན༌བོ༌ ཏེ༌ སྒམ༌མི༌ ནང༌ང༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","སྒམ༌བོའ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ སེར༌རི༌ ཁ༌ཅོད༌ ཅོས༌ ཀ༌བོའེ༌ རིང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 110 དང༌ ཞང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 66 ཡོང༌གོས༌། ཏེ༌ ཁའ༌ལེབ༌པོའེ༌ཀ༌ མི༌གུན༌ནི༌ སྡིག༌པའ༌ ཤགས༌པའེ༌ ཕིའ༌ རིན༌ ཤལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","སྒམ༌མི༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌པོའེ༌ ཁེ༌ཐོག༌གི༌ ཐའ༌མ༌ ཉིས༌ཀོའེ༌ཀ༌ སེར༌ རྡུངས༌ཏེ༌ ཆེ༌ར༌བེམ༌ ཉིས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","འི༌ངོ༌ ཐའ༌མ༌ ཅིག༌ ཡང༌ འ༌ངོ༌ ཐའ༌མ༌ ཅིག༌, ཏེ༌གུན༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌པོའ༌ ཐུད༌ཏེ༌ ཅིག༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ཆེ༌ར༌བེམ༌གུན༌ནི༌ ཤོག༌པ༌ ཀེན༌ལ༌ རྐྱངས༌ཏེ༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌པོ༌ ཀབ༌གོས༌། ཏེ༌གུན༌ ཅིག༌ དང༌ ཅིག༌ག༌ ལྟས༌ཏེ༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌ ཆོགས༌ལ༌ གོ༌ སྒུས༌ཏེ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ཏེ༌ སྒམ༌མི༌ ནང༌ང༌ ངའེ༌ བཀའ༌རྒྱ༌ བྲིས༌ཏེ༌ ཏང༌ཅེས༌ཅན༌ནི༌ རྡོའ༌ ལེབ༌གུན༌ བོར༌ཏེ༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌པོ༌ ཀོབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ཏེ༌ ཁེ༌ཐོག༌ག༌ ཁྱོ༌རང༌ང༌ ང༌ ཐུག༌ཨིན༌ ཡང༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌པོའེ༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཆེ༌ར༌བེམ༌ ཉིས༌ཀོའེ༌ པར༌ནེ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ང༌རང༌ངི༌ བཀའ༌ཁྲིམས༌ ཚང༌མ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཅོག༌ཙེ༌ ཞིག༌ ཅོས༌, ཀ༌བོའེ༌ རིང༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 88, ཞང༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 66 དང༌ ཐོན༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 99 ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ཏེ༌བོ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ ཉམ༌པོ༌ ཏུམ༌ ཡང༌ ཐའ༌མ༌ གུན༌ལ༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ཏེ༌བོའ༌ ཀིར༌ སྐོར༌ཏེ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 7 ཞང༌ངི༌ སྐྱོར༌ར༌ ཏོང༌ ཡང༌ ཏེ༌བོའེ༌ ཐའ༌མ༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","སེར༌རི༌ ཀྱི༌ལྡིར༌ ཞི༌ ཅོས༌ ཡང༌ ཏེ༌གུན༌ རྐང༌གུན༌ ཡོད༌སའེ༌ ཀྲུ༌ ཞི༌ཀོའ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ཏེ༌ ཀྱི༌ལྡིར༌གུན༌ སྐྱོར༌རེ༌ ཉེ༌མོའ༌ ཅོག༌ཙེ༌ ཁུར༌ཅེས༌སི༌ ཕིའ༌ ཀྲ༌ལུ༌གུན༌ གྱུད༌ཅེས༌ལ༌ ཏག༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ཀྲ༌ལུ༌གུན༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཡོང༌གོས༌ ཡང༌ ཏེ༌གུན༌ལ༌ སེར༌ ཏུམས༌ཏེ༌ ཏེ༌གུན༌ ཅོག༌ཙེ༌ ཁུར༌ཅེས༌ལ༌ ཀོལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ངའ༌ རྒུན༌ཆང༌ངི༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ ཐལ༌ལི༌, ཀོ༌རེ༌, གོར༌མོ༌ དང༌ ཞན༌ ནོད༌ གུན༌ ཅའང༌ མ༌དྲེས༌ཁན༌ སེར༌རི༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ཆད༌དོན༌ནི༌ སྒམ༌མི༌ དུན༌ལ༌ ཅོག༌ཙེ༌ཀ༌ ཏུས༌གྱུན༌ ང༌ ཕུལ༌ཁན༌ནི༌ ཏམ༌པའེ༌ ཏ༌གི༌བོ༌ བོར༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“ཅའང༌ མ༌དྲེས༌ཁན༌ སེར༌རི༌ འོད༌སྟགས༌ ཅོས༌, ཏེ༌བོའེ༌ ཞབ༌ལྡན༌, རྐང༌གུན༌, མེན༌ཏོག༌ ཙོགས༌ ཀོ༌རེ༌གུན༌, པ༌ཏུམ༌ དང༌ མེན༌ཏོག༌ བར༌ཁན༌ གུན༌ སེར༌ ཅིག༌ཅིག༌ རྡུངས༌ཏེ༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ཏེ༌བོའ༌ རྐང༌ དྲུག༌ ཡོང༌གོས༌, ཆོག༌ ཉིས༌ཀོའ༌ སུམ༌སུམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","རྐང༌ རེ༌རེ༌ཀ༌ བ༌དམ༌མི༌ མེན༌ཏོག༌ བར༌ཁན༌ ཙོགས༌ སུམ༌སུམ༌ ཡང༌ པ༌ཏུམ༌ དང༌ ཏེ༌བོ༌ ཀབས༌ཁན༌ནི༌ ལོ༌མ༌ ཡོང༌གོས༌། ཏེན༌ན༌ ཙོགས༌ འོད༌སྟག༌གི༌ རྐང༌ དྲུག༌ཀོའེ༌ཀ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","འོད༌སྟག༌གི༌ ཞུང༌སྐྱིལ༌ལི༌ རྐང༌བོའེ༌ཀ༌ བ༌དམ༌མི༌ མེན༌ཏོག༌ བར༌ཁན༌ ཙོགས༌ ཞི༌, པ༌ཏུམ༌ དང༌ ཏེ༌བོ༌ ཀབས༌ཁན༌ནི༌ ལོ༌མ༌ ཉམ༌པོ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ཞུང༌ངི༌ རྐང༌ངི༌ཀ༌ ཞན༌ རྐང༌གུན༌ ཐུད༌ཏེ༌ ཡོད༌ས༌ རེ༌རེ༌ ཡོག༌ག༌ པ༌ཏུམ༌ ཡོང༌གོས༌། ཏེ༌བོའེ༌ཕིའ༌ ཞུང༌ངི༌ རྐང༌ངི༌ ཀ༌ནེ༌ ཞན༌རྐང༌ དྲུག༌ རྐྱངས༌ཏེ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌, ལྡལ༌དོ༌ ཉིས༌ཀོའེ༌ཀ༌ སུམ༌སུམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","པ༌ཏུམ༌ དང༌ ཡལ༌ག༌ ཚང༌མ༌ ཐེས༌ཏེ༌ འོད༌སྟགས༌ གང༌པོ༌, ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ གྲོག༌གྲོག༌ ཅིག༌ཅིག༌ རྡུངས༌ཏེ༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“འོད༌སྟག༌གི༌ཀ༌ མར༌ནག༌ ལུགས༌ཏེ༌ འོད༌ ཏུག༌སའེ༌ ཀོ༌རེ༌ རྡུན༌ ཅོས༌ ཀ༌གུན༌ནི༌ ཏེ༌བོའེ༌ དུན༌ཆོགས༌ལ༌ འོད༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","འོད༌དི༌ སར༌ ཅད༌ཅེས༌སི༌ ཅབ༌རྩེ༌ དང༌ བོ༌ཁན༌གུན༌ ལྡུ༌ཅེས༌སི༌ ཏ༌འོ༌གུན༌ ཅའང༌ མ༌དྲེས༌ཁན༌ སེར༌རི༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","འོད༌སྟགས༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌གུན༌ ཅོ༌ཅེས༌ལ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ ཀི༌ལོ༌ 35 ཀོལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ཏེ༌གུན༌ ངའེ༌ ཁྱོ༌རང༌ང༌ རི༌ཀ༌ ལབ༌ཞའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཅོ༌ ཅུག༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཏམ༌པ༌ ཀུར༌བོ༌ རས༌ ཀུས༌པོ༌ ཐགས༌ཁན༌ནི༌ ཡོ༌ལ༌ རྕུའ༌ ཅོས༌། སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཉམ༌པོ༌ ཏེ༌གུན༌ནི༌ཀ༌ ལག༌པ༌ ཁས༌པ༌ མི༌གུན༌ལ༌ ཆེ༌ར༌བེམ༌མི༌ པར༌ སྲུལ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ཡོ༌ལ༌ ཚང༌མ༌ དྲན༌དྲ༌, རིང༌བོ༌ མི༌ཀྲར༌ 12 ཡང༌ ཞང༌བོ༌ མི༌ཀྲར༌ 2 ཟམ༌ཤིག༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ཡོ༌ལ༌ ལྔ༌ལྔ༌ ཐུད༌ཏེ༌ ཆ༌ ཉིས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","རས༌ སྔོན༌པོའེ༌ གུག༌ ཅོས༌ཏེ༌ ཆ༌ ཉིས༌ཀོའེ༌ ཇུག༌གི༌ ཡོ༌ལའེ༌ ཟུར༌གུན༌ནི༌ཀ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ཡོ༌ལའེ༌ ཆ༌ ཅིག༌པོའེ༌ཀ༌ གུག༌ ལྔབ༌ཅུ༌ དང༌ ཞན༌ ཆ༌ ཅིག༌པོའེ༌ཀའང༌ གུག༌ ལྔབ༌ཅུ༌ ཅོས༌། གུག༌གུན༌ ཅིག༌ དང༌ ཅིག༌ག༌ ལྟས༌ཏེ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","སེར༌ཀུག༌ ལྔབ༌ཅུ༌ ཅོས༌ཏེ༌ ཡོ༌ལ༌ ཉིས༌ཀོའེ༌ གུག༌གུན༌ ལྡོམ༌ ཏེ༌ནེ༌ ཏམ༌པ༌ ཀུར༌བོ༌ ཁག༌ཅིག༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ཏམ༌པ༌ ཀུར༌ ཀབ༌ཅེས༌སི༌ ཕིའ༌ ར༌མའེ༌ སྤུའ༌ ཐགས༌ཁན༌ནི༌ ཡོ༌ལ༌ 11 ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ཏེ༌ ཚང༌མ༌ དྲན༌དྲ༌, རིང༌བོ༌ མི༌ཀྲར༌ 13 དང༌ ཞང༌བོ༌ མི༌ཀྲར༌ 2 ཟམ༌ཤིག༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ཡོ༌ལ༌ ལྔ༌བོ༌ ཅིག༌ ཅོས༌ཏེ༌ ཐུད༌, ཞན༌ ཡོ༌ལ༌ དྲུག༌ཀོ༌ ཡང༌ ཁག༌ ཅིག༌གི༌ ནང༌ང༌ ཐུད༌། ཁག༌ དྲུག༌པོའེ༌ ཡོ༌ལ༌བོ༌ ཀུར༌རི༌ དུན༌ལ༌ ཉི༌ལྟབ༌ ཅོས༌ཏེ༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ཆ༌ ཅིག༌པོའེ༌ ཇུག༌གི༌ ཡོ༌ལའེ༌ ཟུར༌རི༌ཀ༌ གུག༌ ལྔབ༌ཅུ༌ ཅོས༌ ཡང༌ ཞན༌ ཆ༌ ཅིག༌པོའེ༌ ཇུག༌གི༌ ཡོ༌ལའེ༌ ཟུར༌རི༌ཀའང༌ གུག༌ ལྔབ༌ཅུ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ར༌གན༌ནི༌ ཀུག༌ཀུག༌ ལྔབ༌ཅུ༌ ཅོས༌ཏེ༌ གུག༌གུན༌ནི ནང༌ང༌ གྱུད༌ ཡང༌ ཀུར༌རི༌ ཁག༌ ཉིས༌པོ༌ ཅིག༌ ཅོས༌ཏེ༌ ཐུད༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ཀབ༌ཅེས༌ ཐེ༌བ༌ ལུས༌ཁན༌བོ༌ ཏམ༌པ༌ ཀུར༌རི༌ གྱབ༌པོའེ༌ཀ༌ ཆར༌ཆར༌ལ༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ཆོག༌ ཉིས༌ཀོའ༌ ཡོ༌ལ༌ མི༌ཀྲར༌ ཕེད༌ ཐེ༌བ༌ ལུས༌ཁན༌བོ༌ ཀུར༌ ཀབ༌ཅེས༌ལ༌ ཆར༌ཆར༌ལ༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ཏེ༌བོའ༌ ཀབ༌ཅེས༌ ལུག༌ཕོའེ༌ པགས༌པ༌ རང༌ མར༌པོ༌ ཏང༌ཁན༌ ཉམ༌པོ༌ ཡང༌ ཏེ༌བོའེ༌ ཁེ༌ཐོག༌ག༌ ཞན༌ ཀབ༌ཅེས༌ཤིག༌ སེམས༌ཅན༌ནི༌ གྱལ༌ལ༌ པགས༌པའ༌ ཅོ༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“ཏམ༌པ༌ ཀུར༌ ལང༌ཅེས༌ལ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ རིབ༌ཞི༌ ཅོ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","རིབ༌ཞི༌ རེ༌རེའེ༌ རིང༌བོ༌ མི༌ཀྲར༌ 4 དང༌ ཞང༌ མི༌ཀྲར༌ ཕེད༌ ཟམ༌ཤིག༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","རིབ༌ཞི༌ རེ༌རེའེ༌ ཁད༌ཅེས༌ལ༌ ཇུག༌པོ༌ ཞོགས༌ཏེ༌ ཟེར༌ ཙོགས༌ ཉིས༌ ཡོང༌གོས༌། ཏམ༌པ༌ ཀུར༌རི༌ རིབ༌ཞི༌ ཚང༌མ༌ ཙོགས༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ཀུར༌རི༌ ལྷོ༌ ཆོགས༌ལ༌ རིབ༌ཞི༌ 20 ཅོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ཡང༌ རིབ༌ཞི༌གུན༌ ལང༌ཅེས༌ལ༌ མུལ༌ལི༌ ཞིབ༌ཅུ༌ ཅོ༌ཅུག༌། རིབ༌ཞི༌ རེ༌རེའ༌ ཞབ༌ལྡན༌ ཉིས༌, ཟེར༌ རེ༌རེ༌ ཡོག༌ག༌ ཞབ༌ལྡན༌ རེ༌རེ༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ཀུར༌རི༌ བྱང༌ ཆོགས༌ལའང༌ རིབ༌ཞི༌ 20 ཅོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ཡང༌ མུལ༌ལི༌ ཞབ༌ལྡན༌ ཞིབ༌ཅུ༌, རིབ༌ཞི༌ རེ༌རེ༌ ཡོག༌ག༌ ཞབ༌ལྡན༌ ཉིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ཀུར༌རི༌ གྱབ༌, ཡང༌ན༌ ནུབ༌ ཆོགས༌ལ༌ རིབ༌ཞི༌ 6 ཅོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ཡང༌ ཏམ༌པ༌ ཀུར༌རི༌ གྱབ༌ ཆོགས༌སི༌ ཀྲུ༌ ཉིས༌ཀོའེ༌ ཕིའ༌ ཐེ༌བ༌ རིབ༌ཞི༌ ཉིས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ཀྲུའི༌ རིབ༌ཞི༌གུན༌ནི༌, ཡོག༌པོ༌ བེ༌ཏེ༌ ཨིན༌ནའང༌ ཁེ༌ཐོག༌པོ༌ སེར༌རི༌ ཀྱི༌ལྡིར༌ ཉམ༌པོ༌ ནང༌ཀུག༌གི༌ རིབ༌ཞིའ༌ ཐུད༌ཏེ༌ ཡོང༌གོས༌། ཏེན༌ན༌ ཙོགས༌ ཞན༌ ཀྲུའི༌ རིབ༌ཞིའི༌ ཉམ༌པོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ཏེ༌ནེ༌ རིབ༌ཞི༌ 8 དང༌ མུལ༌ལི༌ ཞབ༌ལྡན༌ 16 ཡོང༌གོས༌, རིབ༌ཞི༌ རེ༌རེའ༌ ཞབ༌ལྡན༌ ཉིས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“པ༌ར༌ཁ༌ ཏང༌ཅེས༌ལ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ ཀོལ༌། ཏམ༌པ༌ ཀུར༌རི༌ ཆོགས༌ ཅིག༌གི༌ རིབ༌ཞིའི༌ ཕིའ༌ ལྔ༌, ");
INSERT INTO lbj_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ཞན༌ཆོགས༌ ཅིག༌གི༌ ཕིའ༌ ལྔ༌ ཡང༌ ནུབ༌ ཆོགས༌སི༌ རིབ༌ཞིའི༌ ཕིའ༌ ལྔ༌ ཀ༌བོ༌ ཏམ༌པ༌ ཀུར༌རི༌ གྱབ༌བོ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ཞུང༌སྐྱིལ༌ལི༌ པར༌ཁའེ༌ ཀྲ༌ལུ༌བོ༌ ཀུར༌རི༌ གོ༌ནེ༌ ཇུག༌ ཚག༌པ༌ ལེབ༌གོས༌ ཀ༌བོ༌ རིབ༌ཞི༌ ཞུང༌སྐྱིལ༌ལི༌ཀ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","རིབ༌ཞི༌གུན༌ སེར༌རི༌ ཀོབ༌ ཡང༌ པར༌ཁའེ༌ ཀྲ༌ལུ༌ གྱུད༌ཅེས༌སི༌ ཀྱི༌ལྡིར༌གུན༌ སེར༌རི༌ ཡོང༌གོས༌། ཡང༌ པ༌ར༌ཁ༌ ཏང༌ཅེས༌སི༌ ཀྲ༌ལུ༌གུན༌ལའང༌ སེར༌ ཏུམ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“ངའེ༌ རི༌ཀ༌ ཁྱོ༌རང༌ང༌ སྟན༌ཁན༌ ནང༌ཞིན༌ ཏམ༌པ༌ ཀུར༌བོ༌ ཙུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཡང༌ རས༌ ཐགས༌ཁན༌ ཀུས༌པོའེ༌ ཡོ༌ལ༌ ཅོས༌ ཀ༌བོའེ༌ཀ༌ ལག༌ཤེས༌ ཁས༌པ༌གུན༌ལ༌ ཆེ༌ར༌བེམ༌མི༌ པར༌ སྲུལ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཀ༌ཝ༌ སེར༌རི༌ ཏུམ༌ཁན༌ ཞི༌, མུལ༌ལི༌ ཞབ༌ལྡན༌ རེ༌རེ༌ཀ༌ ལངས༌ཏེ༌ སེར༌ཀུག༌ ཉམ༌པོ༌ ཏེ༌གུན༌ནི༌ཀ༌ ཡོ༌ལ༌བོ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ཀུར༌རི༌ ཐོག༌གི༌ཀ༌ ཡོད༌ཁན༌ སེར༌ཀུག༌གུན༌ནི༌ཀ༌ ཡོ༌ལ༌བོ༌ ཆར༌ལ༌ ཏོང༌ ཡང༌ ཡོ༌ལའེ༌ གྱབ༌བ༌ ཆད༌དོན༌ནི༌ སྒམ༌བོ༌ བོར༌། ཡོ༌ལ༌བོའེ༌ ཏམ༌པའེ༌ ནས༌ས༌, ཚང༌མའེ༌ སང༌ ཏམ༌པའེ༌ ནས༌ས༌ནེ༌ སོ༌སོ༌ ཕེ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ཚང༌མའེ༌སང༌ ཏམ༌པ༌ ནས༌སའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ ཆད༌དོན༌ནི༌ སྒམ༌བོའ༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌པོ༌ ཀོབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ཡོ༌ལའེ༌ དུན༌ ཆོགས༌, ཏམ༌པའེ༌ ནས༌སའེ༌ བྱང༌ ཆོགས༌ལ༌ ཅོག༌ཙེ༌ ཡང༌ ལྷོ༌ ཆོགས༌ལ༌ འོད༌སྟག༌པོ༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“ཀུར༌རི༌ ནང༌ང༌ ཞུག༌སའེ༌ སྒོའ༌ ཀབ༌ཅེས༌ལ༌ ཡོ༌ལ༌ རས༌ ཀུས༌པོ༌ ཉམ༌པོ༌ ཙེམས༌ཏེ༌ ཏེ༌བོའེ༌ཀ༌ མི༌ ལག༌ཤེས༌ ཁས༌པ༌གུན༌ལ༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ ལྡེ༌མོ༌ ཅོ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ཏེ༌ ཡོ༌ལ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ང༌ ཞོག༌ཁན༌ནི༌ ཀ༌ཝ༌ སེར༌རི༌ ཏུམ༌ཁན༌ ལྔའེ༌ཀ༌ སེར༌ཀུག༌ ཉམ༌པོ༌ ཆར༌ལ༌ ཏོང༌ ཡང༌ ཀ༌ཝ༌གུན༌ ལང༌ཅེས༌ལ༌ ར༌གན༌ནི༌ ཞབ༌ལྡན༌ ལྔ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཆོད༌ཁྲི༌ཞིག༌ ཅོས༌, ཏེ༌བོ༌ ཀྲུབ༌ཞི༌, རིན༌ དང༌ ཞང༌ མི༌ཀྲར༌ 2 ཡང༌ ཐོན༌བོ༌ མི༌ཀྲར༌ ཅིག༌ དང༌ ཕེད༌ ཟམ༌ཤིག༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ཀྲུ༌ ཞི༌ཀོ༌ ཞོགས༌ཏེ༌ རཱ༌ཅོ༌ ཙོགས༌ ཙེབ༌ཙེབ༌ ཅོས༌། ཆོད༌ཁྲི༌ དང༌ རཱ༌ཅོ༌གུན༌ ཤིང༌ ཅིག༌གི༌ ཀ༌ནེ༌ སྐོས༌ཏེ༌ ཡོང༌གོས༌ ཡང༌ ཆོད༌ཁྲི༌ གང༌པོ༌ ར༌གན༌ ཉམ༌པོ༌ ཏུམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌ ར༌གན༌ནི༌ ཅོས༌, ཀ༌བོ༌ ཀོག༌ཐལ༌ གྱང༌ཅེས༌སི༌ ནོད༌གུན༌, ཁྱེམ༌གུན༌, སྒོར༌མོ༌གུན༌, ཤ༌ ལོག༌ཅེས༌སི༌ མེ༌ལེན༌གུན༌ དང༌ མེ༌ ཏུག༌ཅེས༌སི༌ ཏ༌འོ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ཤིང༌ དང༌ སོལ༌ལ༌ བར༌ཨིན༌ ཡོད༌ཁན༌གུན༌ ཁད༌ཅེས༌ལ༌ ར༌གན༌ནི༌ ཀྲ༌མིག༌ ཅོས༌ ཡང༌ ཏེ༌བོའེ༌ ཀྲུ༌གུན༌ནི༌ཀ༌ ར༌གན༌ནི༌ ཀྱི༌ལྡིར༌ ཞི༌ ཏགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ཏེ༌བོ༌ ནང༌ལོག༌ག༌ ཆོད༌ཁྲིའ༌ ཀྱིར༌སྐོར༌ཏེ༌ ཀོང༌ང༌ ཏགས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ཡོག༌ག༌ བོར༌, ཕེད༌ ཞིག༌གི༌ཀ༌ ཏེ༌བོ༌ ཁད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ཆོད༌ཁྲི༌བོ༌ ཁུར༌ཅེས༌ལ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཀྲ༌ལུ༌ ཞོགས༌ཏེ༌ ཅོས༌ ཡང༌ ཏེ༌བོའ༌ ར༌གན༌ ཏུམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ཏེ༌གུན༌ ཆོད༌ཁྲི༌ ལྡོ༌ ཉིས༌ཀོའ༌ ཡོད༌ཁན༌ནི༌ ཀྱི༌ལྡིར༌གུན༌ནི༌ ནང༌ང༌ ཁུར༌ཅེས༌ལ༌ གྱུད༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ཆོད༌ཁྲི༌བོ༌ ཤིང༌ལེབ༌ ཉམ༌པོ༌ སྟོང༌པ༌ སྒམ༌ ཙོགས༌ ཅོས༌། ཁྱོ༌རང༌ང༌ རིའི༌ཀ༌ སྟན༌ཁན༌ ནང༌ཞིན༌ ཏེ༌བོ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ཏམ༌པ༌ ཀུར༌ལ༌ ནང༌སྐོར༌ ཅོས༌། ལྷོ༌ ཆོགས༌ལ༌ ཐགས༌ཁན༌ནི༌ རས༌ ཀུས༌པོའེ༌ ཡོ༌ལ༌ མི༌ཀྲར༌ 46 རིང༌མོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ཀ༌ཝ༌ ཉི༌ཤུ༌ དང༌ ཏེ༌གུན༌ ལང༌ཅེས༌ལ༌ ར༌གན༌ནི༌ ཞབ༌ལྡན༌ ཉི༌ཤུ༌ ཡང༌ ཀ༌ཝ༌གུན༌ནི༌ཀ༌ མུལ༌ལི༌ ཀུག༌ཀུག༌གུན༌ དང༌ ཀྱི༌ལྡིར༌གུན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ཏེན༌ན༌ ཙོགས༌ བྱང༌ ཆོགས༌སི༌ སྐྱོར༌རེ༌ ཕིའང༌ ཀ༌ཝ༌ ཉི༌ཤུ༌, ར༌གན༌ནི༌ ཞབ༌ལྡན༌ ཉི༌ཤུ༌, མུལ༌ལི༌ ཀུག༌ཀུག༌གུན༌ དང༌, ཀྱི༌ལྡིར༌གུན༌ ཡང༌ མི༌ཀྲར༌ 44 རིང༌ངི༌ ཡོ༌ལ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“ནུབ༌ ཆོགས༌སི༌ སྐྱོར༌རེ༌ ཕིའ༌ མི༌ཀྲར༌ 22 རིང༌ངི༌ ཡོ༌ལ༌ ཅོས༌, ཀ༌བོ༌ ཞབ༌ལྡན༌ རྕུའི༌ཀ༌ ལངས༌ཁན༌ནི༌ ཀ༌ཝ༌ རྕུའི༌ཀ༌ ཆར༌ལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ཤར༌ ཆོགས༌སི༌ སྐྱོར༌ར༌ ཀ༌རུ༌ ནང༌ཀུག༌ག༌ ཞུག༌སའེ༌ སྒོ༌ ཡོད༌, ཏེ༌བོ༌ མི༌ཀྲར༌ 22 ཞང༌ཅན༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","སྒོའེ༌ ཆོགས༌ ཅིག༌པོའེ༌ཀ༌ ཞབ༌ལྡན༌ སུམ༌མི༌ཀ༌ ཀ༌ཝ༌ སུམ༌ ལངས༌ཏེ༌ མི༌ཀྲར༌ དྲུག༌ དང༌ ཕེད༌ ཟམ༌ཤིག༌ རིང༌ངི༌ ཡོ༌ལ༌ ཆར༌ལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","སྒོའེ༌ འ༌ངོ༌ ཆོགས༌པོའང༌ ཞབ༌ལྡན༌ སུམ༌མི༌ཀ༌ ཀ༌ཝ༌ སུམ༌ ལངས༌ཏེ༌ མི༌ཀྲར༌ དྲུག༌ དང༌ ཕེད༌ ཟམ༌ཤིག༌ རིང༌ངི༌ ཡོ༌ལ༌ ཆར༌ལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ཞུག༌སའེ༌ སྒོའ༌ མི༌ཀྲར༌ 9 རིང༌ངི༌ ཡོ༌ལ༌ ཀ༌བོ༌ ཀུས༌པོ༌ རས༌སི༌ཀ༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཉམ༌པོ༌ རི༌མོ༌ སྲུལ༌ཏེ༌ ཡོང༌གོས༌། ཡང༌ ཏེ༌བོ༌ ཞབ༌ལྡན༌ ཞི༌ཀ༌ ལངས༌ཁན༌ནི༌ ཀ༌ཝ༌ ཞི༌ཀ༌ ཆར༌ལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ནང༌སྐོར༌རི༌ སྐྱོར༌རེ༌ ཀ༌ཝ༌ ཚང༌མའེ༌ཀ༌ མུལ༌ལི༌ ཀྱི༌ལྡིར༌, མུལ༌ཀུག༌གུན༌ ཡང༌ ཀ༌ཝ༌ ལང༌ཅེས༌སི༌ ཞབ༌ལྡན༌གུན༌ ར༌གན༌ནི༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","སྐྱོར༌ར༌བོ༌ མི༌ཀྲར༌ 44 རིང༌, མི༌ཀྲར༌ 22 ཞང༌ དང༌ མི༌ཀྲར༌ 2 ཟམ༌ཤིག༌ ཐོན༌པོ༌ ཡོང༌གོས༌། ཡོ༌ལ༌གུན༌ ཐགས༌ཁན༌ནི༌ ཀུས༌པོ༌ རས༌སི༌ ཡང༌ ཞབ༌ལྡན༌གུན༌ ར༌གན༌ནི༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ཏམ༌པ༌ ཀུར༌རི༌ ནང༌ང༌ ཀོལ༌ཁན༌ནི༌ ལག༌ཆ༌ ཚང༌མ༌ ཡང༌ ཀུར༌ དང༌ སྐྱོར༌རེ༌ པུར༌ཆ༌ ཚང༌མ༌ ར༌གན༌ནི༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“འོད༌གུན༌ ཏུས༌གྱུན༌ སྤར༌ཏེ༌ བོར༌ཅེས༌སི༌ ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཨོ༌ལིཝ༌ ཙིར༌ཁན༌ནི༌ མར༌ནག༌ ལག༌མོ༌ ཁྱོང༌ཅེས༌ལ༌ བཀའ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ང༌, ཆད༌དོན༌ནི༌ སྒམ༌མི༌ དུན༌ལ༌ ཡོད༌ཁན༌ནི༌ ཡོ༌ལའེ༌ དུན༌ ཆོགས༌ལ༌ འོད༌སྟག༌པོ༌ བོར༌། ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཏེ༌ འོད༌གུན༌ ཕི༌ཏོག༌ནེ༌ ང༌མོ༌ ཚོག༌པ༌ སྤར༌ཏེ༌ བོར༌གོས༌། ཨིས༌ར༌ཨེལ༌པ༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ པུར༌གྱུད༌ ཚང༌མའེ༌ ཏུས༌གྱུན༌ འི༌ ཁྲིམས༌པོ༌ ཁའ༌ཉན༌ གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌ ན༌དབ༌, ཨ༌བི༌ཧུ༌, ཨེ༌ལི༌འ༌ཟར༌ དང༌ ཨི༌ཐ༌མར༌ གུན༌ བོད༌ཏེ༌ ངའ༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌ལ༌, ཁོང༌གུན༌ ལྡོམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨ༌རོན༌ནི༌ ཕིའ༌ བླ༌མའེ༌ ཏམ༌པ༌ ཀོས༌ལག༌གུན༌ ཙེམ༌ཅུག༌, ཏེ༌བོའེ༌ ཁོའ༌ སྤལ༌ དང༌ རྩི༌ཝ༌ ཁྱོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ངའེ༌ རིག༌པ༌ ཏང༌ཁན༌ནི༌ ལག༌ཁས༌པ༌གུན༌ལ༌ ཨ༌རོན༌ནི༌ ཕིའ༌ ཀོས༌ལག༌ ཙེམ༌ ཟེར༌ ཏེ༌བོའེ༌ ཁོ༌ ངའེ༌ ཕིའ༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ཞབས༌ཏོག༌ ཞུའ༌ ལྡམས༌ཏེ༌ ཨིན༌ཁན༌བོ༌ སྟན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ཁོང༌གུན༌ནི༌ འི༌ ཀོས༌ལག༌གུན༌ ཙེམ༌གོས༌, ཀྲང༌ང༌ ཀབ༌ཅེས༌, ཨེ༌ཕོད༌, ཀོས༌ ཕུ༌ཏུང༌ མེད༌ཁན༌, ཐགས༌ཁན༌ནི༌ ཀོས༌, གོའ༌ སྲིལ༌ཅེས༌ དང༌ སྐྱེ༌རགས༌ གུན༌། ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ཕིའ༌ ཁོང༌གུན༌ནི༌ ཏེ༌ ཏམ༌པ༌ ཀོས༌ལག༌ ཚང༌མ༌ ཙེམ༌གོས༌, ཁོང༌གུན༌ནི༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ངའ༌ ཞབས༌ཏོག༌ ཞུ༌ ཟ༌ནེ༌ ཏེ༌གུན༌ གོན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ཁོང༌གུན༌ནི༌ སེར༌ཀུད༌, སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཡང༌ རས༌ ཀུས༌པོ༌ གུན༌ ཀོལ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“རས༌ ཀུས༌པོའེ༌ཀ༌ སེར༌ཀུད༌ ཡང༌ སྔོན༌པོ༌, སྔོ༌མར༌, མར༌པོ༌ ནས༌མ༌ ཉམ༌པོ༌ ལག༌ཁས༌པ༌གུན༌ལ༌ ལག༌སྲུལ༌ ཏང༌ཅུགས༌ཏེ༌ ཨེ༌ཕོད༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ཏེ༌བོའེ༌ གྱབ༌ དང༌ དུན༌བོ༌ ཐུད༌ཅེས༌ལ༌ སྤུང༌པ༌ ཉིས༌ཀོའེ༌ཀ༌ རས༌སི༌ ཐུད༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","སྐྱེ༌རག༌པོ༌ ཨེ༌ཕོད༌ དང༌ ཙོགས༌ ཀུས༌པོ༌ ཪས༌སི༌ཀ༌ སེར༌ཀུད༌ ཡང༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ ཨེ༌ཕོད༌ ཉམ༌པོ༌ ཐུད༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“ཨོ༌ནེཀས༌ ཟེར༌ཁན༌ནི༌ ཁྲ༌རྡོའ༌ རིན༌ཅན༌ ཉིས༌སི༌ཀ༌ ཨིས༌ར༌ཨེལ༌ལི༌ བུ༌ཚ༌གུན༌ནི༌ མིང༌ སྐོས༌ཏེ༌ བྲིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","མིང༌གུན༌ སྐྱེ༌ ཚིར༌ལ༌, ཁྲ༌རྡོའ༌ ཅིག༌པོའེ༌ཀ༌ དྲུག༌ དང༌ ཡང༌ ཅིག༌པོའེ༌ཀ༌ དྲུག༌ བྲིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ཁྲ༌ ཙོག༌ཁན༌གུན༌ནི༌ ཐེ༌ཙེ༌ སྐོའ༌ ཙོགས༌ལ༌ ཁྲ༌རྡོའ༌ ཉིས༌ཀོའེ༌ཀ༌ མིང༌གུན༌ སྐོས༌ཏེ༌ ཏེ༌བོ༌ སེར༌རི༌ རིབ༌ཞི༌ ནང༌ང༌ ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ཨིས༌ར༌ཨེལ༌ལི༌ སྡེ༌ རྕུག༌ཉིས༌པོ༌ ཨིད༌ཏུ༌ ལུས༌ཤེས༌ལ༌ ཏེ༌གུན༌ ཨེ༌ཕོད༌དི༌ སྤུང༌པའེ༌ རས༌སི༌ཀ༌ ཏག༌ཅུག༌། ཨ༌རོན༌ནི༌ ཏེ༌ མིང༌གུན༌ ཁོ༌རང༌ངི༌ སྤུང༌པའེ༌ཀ༌ ཁུར༌ཏེ༌ ཁོང༌གུན༌ ཨིད༌ཏུ༌ བོར༌ར༌ ཛད༌ཅེས༌པོ༌ ཡ༌ཝའ༌ ཨིད༌ཏུ༌ སྐུལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ཁྲ༌གུན༌ ཅུག༌ཅེས༌ལ༌ སེར༌རི༌ རིབ༌ཞི༌ ཉིས༌ ཅོས༌ ");
INSERT INTO lbj_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ཡང༌ སེར༌ ལྕུས༌ཏེ༌ ཉག༌ཐག༌ ཐུ༌ངུན༌ ཉིས༌ ཅོས༌ཏེ༌ ཏེ༌གུན༌ ཁྲ༌ ཅུག༌ཁན༌ སེར༌རི༌ རིབ༌ཞི༌གུན༌ལ༌ ཐུད༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ལག༌ཁས༌པ༌གུན༌ལ༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌ ཅོ༌ཅུག༌ ཀ༌བོ༌ ཐག༌ཅད༌ ཏང༌ཅེས༌ལ༌ ཀོལ༌ཨིན༌། ཏེ༌བོ༌ ཨེ༌ཕོད༌ ཙོགས༌ ཀུས༌པོ༌ རས༌སི༌ཀ༌ སེར༌ཀུད༌ ཡང༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ཏེ༌བོ༌ ཀྲུབ༌ཞི༌, ལྡོ༌ རེ༌རེ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 22 ཡང༌ ཉི༌ལྡབ༌ གི༌གུ༌ ཙོགས༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ཏེ༌བོའེ༌ཀ༌ ཁྲ༌རྡོའ༌ རིན༌ཅན༌གུན༌ནི༌ ཀྲལ༌ཞི༌ ཅོས༌ ཡང༌ གོ༌མའེ༌ ཀྲལ༌ལི༌ ནང༌ང༌ རུ༌བི༌, ཏོ༌པཟ༌ དང༌ བེ༌རེལ༌; ");
INSERT INTO lbj_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ཀྲལ༌ ཉིས༌པའེ༌ ནང༌ང༌ ཏར༌ཀོའེས༌, ནི༌ལིམ༌ དང༌ ཨི༌མ༌རལད༌; ");
INSERT INTO lbj_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ཀྲལ༌ སུམ༌པའེ༌ ནང༌ང༌ ཇེ༌སིནཐ༌, ཨ༌གཏ༌ དང༌ ཨ༌མེ༌ཐིསཏ༌; ");
INSERT INTO lbj_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ཀྲལ༌ ཞི༌པའེ༌ ནང༌ང༌ ཀརི༌སོ༌ལཱེཏ༌, ཨོ༌ནེཀས༌ དང༌ ཇས༌པར༌ གུན༌ ཡོང༌གོས༌། ཏེ༌ ཚང༌མ༌ སེར༌རི༌ ནང༌ང༌ ཅུགས༌ཏེ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ཁྲ༌ ཙོག༌ཁན༌གུན༌ལ༌ ཏེ༌ ཁྲ༌རྡོའ༌གུན༌ནི༌ཀ༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌གུན༌ནི༌ མིང༌ ཐེ༌ཙེ༌ ཙོགས༌ལ༌ སྐོ༌ཅུག༌, ཀ༌གུན༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྡེ༌ རྕུག༌ཉིས༌པོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ཀྲང༌ང༌ ཀབ༌ཅེས༌པོ༌ ཨེ༌ཕོད༌ ཉམ༌པོ༌ ཐུད༌ཅེས༌ལ༌ སེར༌ ལྕུས༌ཏེ༌ ཉག༌ཐག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","སེར༌རི༌ ཀྱི༌ལྡིར༌ ཉིས༌ ཅོས༌ ཡང༌ ཏེ༌གུན༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌པོའེ༌ སྟག༌གི༌ ཀྲུ༌ ཉིས༌ཀོའེ༌ཀ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ཡང༌ སེར༌རི༌ ཉག༌ཐག༌ ཉིས༌ཀོའེ༌ ཇུག༌ རེ༌རེ༌ གྲང༌ང༌ གྱབ༌ཅེས༌སི༌ ཀྲུའི༌ ཀྱི༌ལྡིར༌ རེ༌རེ༌ཀ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","སེར༌རི༌ ཉག༌ཐག༌གི༌ ཞན༌ ཇུག༌པོ༌ ཨེ༌ཕོད༌དི༌ དུན༌ ཆོགས༌སི༌ སྤུང༌པའེ༌ཀ༌ ཁྲ༌ ཅུག༌ཁན༌ནི༌ སེར༌རི༌ རིབ༌ཞི༌ཀ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","སེར༌རི༌ ཀྱི༌ལྡིར༌ ཡང༌ ཉིས༌ ཅོས༌ཏེ༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌པོའེ༌ ཡོག༌གི༌ ཀྲུ༌ ཉིས༌ཀོའེ༌ ཐིལ༌ལ༌ ཨེ༌ཕོད༌ ཆོགས༌ལ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","སེར༌རི༌ ཀྱི༌ལྡིར༌ ཡང༌ ཉིས༌ ཅོས༌ཏེ༌ ཨེ༌ཕོད༌དི༌ དུན༌ ཆོགས༌ལ༌ སྤུང༌པའེ༌ རས༌སི༌ ཇུག༌པོའེ༌ཀ༌ ཨེ༌ཕོད༌ དང༌ སྐྱེ༌རགས༌ ཐུད༌སའེ༌ སྟག༌པོའེ༌ཀ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ཀྲང༌ང༌ ཀབ༌ཅེས༌སི༌ ཀྱི༌ལྡིར༌གུན༌ དང༌ ཨེ༌ཕོད༌དི༌ སྐྱེ༌རག༌གི༌ ཁེ༌ཐོག༌ག༌ ཡོད༌ཁན༌ནི༌ ཀྱི༌ལྡིར༌གུན༌ སྔོན༌པོ༌ རས༌སི༌ སྐྱེ༌རག༌ ཁྲ༌མོ༌ ཉམ༌པོ༌ ལྡོམ༌། ཏེ༌ནེ༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌པོ༌ གྲུལ༌ མ༌གྲུལ༌ལ༌ ཨེ༌ཕོད༌ ཉམ༌པོ༌ སྟན༌པོ༌ ལུས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“ཨ༌རོན༌ ཁོ༌རང༌ངི༌ སྙིང༌ངི༌ཀ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྡེ༌གུན༌ནི༌ མིང༌ སྐོས༌ཁན༌ནི༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌པོ༌ གོན༌ཏེ༌ ཏམ༌པ༌ ནས༌སའེ༌ ནང༌ང༌ ཆའ༌ཅིག༌ ང༌ ཡ༌ཝའ༌ ཁོང༌གུན༌ མི༌རྗེད༌ཅེས༌པོ༌ ཨིད༌ཏུ༌ སྐུལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ཀྲང༌ང༌ ཀབ༌ཅེས༌པོའེ༌ ནང༌ཀུག༌ག༌ ཨུ༌རིམ༌ དང༌ ཐུ༌མིམ༌ གུན༌ གྱོང༌། ཨ༌རོན༌ ཡ༌ཝའེ༌ དུན༌ལ༌ ཏམ༌པའེ༌ ནས༌སའེ༌ ནང༌ང༌ ཆ༌ ཟ༌ནེ༌ ཏེ༌གུན༌ ཁོའེ༌ སྙིང༌ངི༌ དུན༌ལ༌ ལུས༌ཨིན༌། ཏེ༌ནེ༌ ཨ༌རོན༌ནི༌ ཏེ༌གུན༌ ཀོལ༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ངའེ༌ ཐུག༌གོངས༌པོ༌ སྔོན༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ཨེ༌ཕོད༌དི༌ ཡོག༌ག༌ གོན༌ཅེས༌སི༌ ཀོས༌ གང༌པོ༌ སྔོན༌པོ༌ ཡོང༌གོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","གོའེ༌ ཕིའ༌ བི༌ཡང༌ ཡོང༌གོས༌ ཡང༌ མི༌ཅད༌ཅེས༌སི༌ ཕིའ༌ ཏེ༌བོའེ༌ ཐའ༌མ༌ ལྟབས༌ཏེ༌ ཙེམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","སེར༌རི༌ ཀྲི༌ལུ༌ དང༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཉམ༌པོ༌ ཨ༌ནར༌རི༌ ཟོས༌ཏ༌ ཅོས༌ཏེ༌ ཀོས༌སི༌ ཇུག༌གི༌ ཟུར༌རི༌ཀ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ཀྲ༌ལུ༌ དང༌ ཨ༌ནར༌ གུན༌ སྤེལ༌ཏེ༌ ༼ཨ༌ནར༌ ཅིག༌ ཀྲི༌ལུ༌ ཅིག༌༽ ཀོས༌སི༌ ཇུག༌གི༌ ཟུར༌ ཀྱིར༌སྐོར༌ཏེ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","བླ༌མའེ༌ ཚུལ༌ལ༌ ཡ༌ཝ༌ ཞབས༌ཏོག༌ ཞུ༌ ཟ༌ནེ༌ ཨ༌རོན༌ནི༌ ཏེ༌བོ༌ གོན༌གོས༌། ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཏམ༌པའེ༌ ནས༌སའེ༌ ནང༌ང༌ ཆ༌ ཡ༌ བིང༌ ཟ༌ནེ༌ ཀྲ༌ལུའི༌ སྐད༌པོ༌ སན༌ཏེ༌ ཁོ༌ སད༌ད༌ མི༌ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ རྡུངས༌ཏེ༌ ལེབ༌ལེབ༌ ཀྲུབ༌ཞི༌ ཅོས༌ ཡང༌ ཏེ༌བོའེ༌ཀ༌ ‘ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ ཕིའ༌ ཁོ༌ ཏམ༌པ༌ ཛདས༌’ སྐོས༌ཏེ༌ བྲིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ཏེ༌བོ༌ ཐོད༌དི༌ དུན༌ཆོགས༌ལ༌ ཟུར༌རི༌ཀ༌ སྔོན༌པོ༌ རས༌སི༌ སྐྱེ༌རགས༌ ཁྲ༌མོ༌ ཉམ༌པོ༌ ལྡོམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ཏེ༌བོ༌ ཨ༌རོན༌ནི༌ ཐོད༌པའེ༌ཀ༌ གོན༌གོས༌ ཏེ༌ནེ༌ ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའ༌ ཕུལ༌ཁན༌ནི༌ ཆོད༌པའེ༌ ནང༌ང༌ ནོར༌ཁྲུལ༌ ཆའ༌ཁན༌ནི༌ སྐྱོན༌གུན༌ ཁོའེ༌ ལེན༌ཨིན༌ ཡང༌ ང༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ནི༌ ཆོད༌པ༌ ཕུལ༌ཁན༌གུན༌ ཐད༌པོ༌ ཉམ༌པོ༌ ལེན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“ཨ༌རོན༌ནི༌ ནང༌ཀུག༌གི༌ ཀོས༌ དང༌ ཐོད༌ གུན༌ ཐགས༌ཁན༌ནི༌ ཀུས༌པོ༌ རས༌སི༌ ཡོང༌གོས༌ ཡང༌ སྐྱེ༌རག༌པོའང༌ ལག༌སྲུལ༌ ཏངས༌ཏེ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ཨ༌རོན༌ནི༌ བུ༌ཚ༌གུན༌ནི༌ ཕིའ༌ ནང༌ཀུག༌གི༌ ཀོས༌, སྐྱེ༌རགས༌ དང༌ ཏི༌བི༌ གུན༌ ཅོས༌ ཀ༌བོའེ༌ ཁོང༌གུན༌ལ༌ སྤལ༌ དང༌ རྩི༌ཝ༌ ཁྱོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","འི༌ ཀོས༌ལག༌གུན༌ ཁྱོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌ གུན༌ལ༌ སྐོན༌ ཡང༌ ཁོང༌གུན༌ནི༌ གོའེ༌ཀ༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ ལུགས༌ཏེ༌ བླ༌མའེ༌ ལས༌སི༌ ཕིའ༌ སྐོས༌། བླ༌མའེ༌ ཚུལ༌ལ༌ ང༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌ལ༌ ཁོང༌གུན༌ སོ༌སོ༌ ཕེས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“ཁོང༌གུན༌ ཇང༌སྟོང༌ མེད༌ཅེས༌སི༌ ཕིའ༌ ནང༌ཀུག༌གི༌ ཀང༌ཙེ༌, ཀུས༌པོ༌ རས༌སི༌ ཙེམ༌ ཀ༌བོ༌ སྐྱེད༌པ༌ནེ༌ ཇང༌བར༌ ཚོག༌པ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཆ༌ ཟ༌ནེ༌ ཡ༌ ཆོད༌ཁྲིའི༌ དུན༌ལ༌ ཏམ༌པའེ༌ ནས༌སའེ༌ ནང༌ང༌ ཞབས༌ཏོག༌ ཞུ༌ ཟ༌ནེ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ཏེ༌ ཀོས༌ལག༌གུན༌ གོན༌གོས༌། ཏེ༌ཟུག༌ ཅོ༌ན༌ ཁོང༌གུན༌ལ༌ སྐྱོན༌ ཕོགས༌ཏེ༌ ཤི༌ མི༌ཤི༌། ཏེ༌ ཁྲིམས༌པོ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ཏུས༌གྱུན༌ ཁའ༌ཉན༌ གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ ཏམ༌པ༌ ཅོ༌ཅེས༌ལ༌ འི༌གུན༌ ཅོས༌, ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ངའ༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌། ལང༌ཏོ༌ ལོ༌ ཆུ༌ངུན༌ ཅིག༌ དང༌ ལུག༌ཕོ༌ ཉིས༌ ཁྱོང༌, ཏེ༌གུན༌ སྐྱོན༌མེད༌ཁན༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","པག༌ཕེ༌ གྱལ༌ཤོག༌ ཀོལ༌ཏེ༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ སྣ༌ སུམ༌ ཅོས༌ ཀ༌གུན༌ མར༌ ཡོད༌ཁན༌, མར༌ མེད༌ཁན༌ དང༌ མར༌ སྐུས༌ཁན༌ནི༌ ཏ༌གི༌ སྲ༌མོ༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ཏེ༌གུན༌ པག༌ཙེ༌ ནང༌ང༌ གྱོང༌ ཡང༌ ལང༌ཏོ༌ དང༌ ལུག༌ཕོ༌ ཉིས༌ཀོ༌ ཉམ༌པོ༌ ང༌ ཆོད༌པ༌ ཕུལ༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ ཁྱོངས༌ཏེ༌ ཆུ༌ ཉམ༌པོ༌ ཁྲུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ཏེ༌ནེ༌ ཨ༌རོན༌ལ༌ བླ༌མའེ༌ ཀོས༌ལག༌, ནང༌ཀུག༌གི༌ ཀོས༌, ཨེ༌ཕོད༌དི༌ ཡོག༌གི༌ ཀོས༌, ཨེ༌ཕོད༌ དང༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌ གུན༌ སྐོན༌། ཨེ༌ཕོད༌དི༌ སྐྱེ༌རག༌ ལག༌སྲུལ༌ ཏང༌ཁན༌བོ༌ ཉམ༌པོ༌ ཏེ༌བོ༌ ལྡོམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ཁོའེ༌ གོའེ༌ཀ༌ ཐོད༌ སྐོན༌ ཡང༌ ཏེ༌བོའེ༌ཀ༌ ཐོར༌ཤོག༌ ཏམ༌པ༌བོ༌ ཐོད༌པོའེ༌ཀ༌ ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ཏེ༌ནེ༌ ཁོའེ༌ གོའེ༌ཀ༌ མར༌ ལུགས༌ཏེ༌ ཁོ༌ བླ༌མའེ༌ ལས༌སི༌ ཕིའ༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ཁོའེ༌ བུ༌ཚ༌གུན༌ ཁྱོང༌ ཡང༌ ཁོང༌གུན༌ལའང༌ ནང༌ཀུག༌གི༌ ཀོས༌པོ༌ སྐོན༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ཁོང༌གུན༌ནི༌ སྐྱེད༌པའེ༌ཀ༌ སྐྱེ༌རགས༌ ལྡོམ༌ ཡང༌ གོའེ༌ཀ༌ ཏི༌བི༌ སྐོནས༌། ཏེ༌ནེ༌ ཁྲིམས༌ ནང༌ཞིན༌ ཏུས༌གྱུན༌ནི༌ ཕིའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌སི༌ བླ༌མའེ༌ ལས༌པོ༌ ཁོང༌གུན༌ནི༌ གྱུར༌ཨིན༌། ཏེན༌ན༌ཟུག༌གི༌ ཁྱོ༌རང༌ངི༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ སྐོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ སྒོའེ༌ དུན༌ལ༌ ལང༌ཏོ༌ ཁྱོངས༌ཏེ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ ཏེ༌བོའེ༌ གོའེ༌ཀ༌ ལག༌པ༌ བོར༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ཡ༌ཝའེ༌ དུན༌ལ༌ སྒོའེ༌ཀ༌ ལང༌ཏོའེ༌ སྐེ༌ ཅད༌ཏེ༌ སོད༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ལང༌ཏོའེ༌ ཁྲག༌ ཙ༌པིག༌ཞིག༌ ཁྱོ༌རང༌ངི༌ ཛི༌གུ༌ ཉམ༌པོ༌ ཆོད༌ཁྲི༌ ཀྲུའི༌ རི༌ཅོ༌གུན༌ལ༌ སྐུས༌ ཡང༌ ལུས༌ཁན༌ནི༌ ཁྲག༌པོ༌ ཆོད༌ཁྲིའི༌ མག༌ལྡན༌ནི༌ཀ༌ ལུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ཏེ༌ནེ༌ ནང༌ཆ༌གུན༌ ཀབས༌ཁན༌ནི༌ ཚིལ༌ ཚང༌མ༌, ཆིན༌པའེ༌ ཁག༌ གྱལ༌ཤོག༌པོ༌ ཡང༌ ཁལ༌མ༌ ཉིས༌ཀོ༌ ཚིལ༌ ཉམ༌པོ༌ སྲོག༌ཆོད༌ ཕུལ༌སའེ༌ ཆོད༌ཁྲི༌ཀ༌ མེའ༌ སྲོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ཨིན༌ནའང༌ ལང༌ཏོའེ༌ ཤ༌, པགས༌པ༌ དང༌ གྱུ༌མ༌གུན༌ ལྕ༌ ཉམ༌པོ༌ ཀུར༌ ཙུགས༌ཏེ༌ ཡོད༌སའེ༌ ཕི༌ལོག༌ག༌ མེའ༌ སྲོག༌། ཏེ༌བོ༌ སྡིག༌པའེ༌ ཕིའ༌ ཆོད༌པ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ལུག༌ཕོ༌ ཅིག༌པོ༌ ཁྱོང༌ ཡང༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ ཏེ༌བོའེ༌ གོའེ༌ཀ༌ ལག༌པ༌ བོར༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ཏེ༌བོ༌ སོད༌ ཡང༌ ཏེ༌བོའེ༌ ཁྲག༌གི༌ ཐོར༌མ༌ ཆོད༌ཁྲིའི༌ ཆོགས༌ ཞི༌ཀོའེ༌ཀ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ལུག༌གི༌ ཤ༌ ཏུམ༌པ༌ཏུམ༌པ༌ ཅོས༌ཏེ༌ ནང༌ཆ༌ དང༌ ཡན༌ལག༌ ཚང༌མ༌ ཁྲུས༌ ཡང༌ ཏེ༌གུན༌ གོ༌ དང༌ ཞན༌ ཁག༌གུན༌ ཉམ༌པོ༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ལུག༌ གང༌པོ༌ ཆོད༌ཁྲི༌ཀ༌ མེའ༌ སྲོག༌། ཏེ༌བོ༌ ཡ༌ཝའེ༌ ཕིའ༌ མེའ༌ སྲག༌ཁན༌ནི༌ ཆོད༌པ༌ ཡང༌ ཏེ༌བོའེ༌ ཏྲི༌མའེ༌ ང༌ ཡ༌ཝ༌ ཐད༌ ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ཞན༌ ལུག༌ཕོ༌ ཅིག༌པོ༌ ཁྱོང༌ ཡང༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ ཏེ༌བོའེ༌ གོའེ༌ཀ༌ ལག༌པ༌ བོར༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ཏེ༌བོ༌ སོད༌ ཡང༌ ཏེ༌བོའེ༌ ཁྲག༌ ཙ༌པིག༌ཞིག༌ ཁུར༌ཏེ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ནམ༌ཅོག༌ ཡས༌པ༌, ལག༌པ༌ དང༌ རྐང༌པ༌ ཡས༌པའེ༌ ཐེ༌པོ༌ གུན༌ནི༌ཀ༌ སྐུས༌ ཡང༌ ཆོད༌ཁྲིའི༌ ཆོགས༌ ཞི༌ཀོའེ༌ཀ༌ ལུས༌ཁན༌ནི༌ ཁྲག༌གི༌ ཐོར༌མ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ཆོད༌ཁྲི༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཁྲག༌ ཙ༌པིག༌ དང༌ མར༌ནག༌ ཙ༌པིག༌ ཁུར༌ཏེ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ དང༌ ཁོང༌ ཚང༌མའེ༌ ཀོས༌ལག༌གུན༌ནི༌ཀ༌ ཐོར༌མ༌ ཏོང༌། ཏེ༌ནེ༌ ཁོ༌, ཁོའེ༌ བུ༌ཚ༌གུན༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཀོས༌ལག༌གུན༌ ཏམ༌པ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“འི༌ ལུག༌ཕོ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ བླ༌མའ༌ སྐོས༌ཁན༌བོའེ༌ ཕིའ༌ ཨིན༌ པ༌སང༌ ཏེ༌བོའེ༌ རྔ༌མ༌ དང༌ ནང༌ཆ༌གུན༌ནི༌ ཚིལ༌, ཆིན༌པའེ༌ ཁག༌ གྱལ༌ཤོག༌, ཁལ༌མ༌ ཉིས༌ཀོ༌ ཚིལ༌ ཉམ༌པོ༌ ཡང༌ རྐང༌པ༌ ཡས༌པའེ༌ ཤ༌ ཁུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ཏེ༌ནེ༌ ང༌ ཡ༌ཝའ༌ ཕུལ༌ཁན༌ནི༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ པག༌ཙེ༌ ནང༌ནེ༌ མར༌ ཡོད༌ཁན༌ ཅིག༌, མར༌ མེད༌ཁན༌ ཅིག༌ དང༌ མར༌ སྐུས༌ཁན༌ནི༌ ཏ༌གི༌ སྲ༌མོ༌ ཅིག༌ ཁུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ཏེ༌ ཚང༌མ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ལག༌པའེ༌ ནང༌ང༌ ཏོང༌ ཡང༌ ཏེ༌བོ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ལན༌ ཁ༌ཅིག༌ སྟགས༌ཏེ༌ ཕབ༌ཅུག༌། ཏེ༌བོ༌ ངའེ༌ ཕིའ༌ ཡུག༌ཁན༌ནི༌ ཆོད༌པ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ཏེ༌ནེ༌ ཏེ༌གུན༌ ཁོང༌གུན༌ནི༌ ལག༌ནེ༌ ཁྱེར༌ཏེ༌ ཆོད༌ཁྲི༌ཀ༌ ཞན༌ མེའ༌ སྲག༌ཁན༌ནི༌ ཆོད༌པ༌ ཉམ༌པོ༌ མེའ༌ སྲོག༌། ཏེ༌བོའེ༌ ཏྲི༌མའེ༌ ང༌ ཡ༌ཝ༌ ཐད༌ ཅུག༌ཨིན༌ ཡང༌ ཏེ༌བོ༌ ངའེ༌ ཕིའ༌ མེའ༌ སྲག༌ཁན༌ནི༌ ཆོད༌པ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ཆོད༌པ༌ ཕུལ༌ཁན༌ ལུག༌ཕོ༌ ཉིས༌པ༌བོའེ༌ ཀྲང༌ཤ༌ ཁུར༌ ཡང༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ལན༌ ཁ༌ཅིག༌ སྟགས༌ཏེ༌ ཕབས༌ཏེ༌ ཡུག༌ཁན༌ནི༌ ཆོད༌པ༌ ཕུལ༌། ཏེ༌ནེ༌ ཤའེ༌ ཏེ༌ ཁག༌པོ༌ ཁྱོ༌ཞའེ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ བླ༌མའེ༌ ལས༌སི༌ ཕིའ༌ སྐོ༌ ཟ༌ནེ༌ ལུག༌ཕོའེ༌ ཤ༌ ཕུལ༌ཁན༌གུན༌ ཕེས༌ཏེ༌ བོར༌, ཀ༌བོའེ༌ ནང༌ང༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཡུག༌ཁན༌ནི༌ ལུག༌གི༌ ཀྲང༌ དང༌ སྟག༌ཁན༌ནི༌ རྐང༌པའེ༌ ཤ༌ གུན༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","དཀོན༌མཆོག༌ ཉམ༌པོ༌ ཞི༌དེ༌ བྲེལ༌ལི༌ ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའ༌ ཆོད༌པ༌ ཕུལ༌ཁན༌ནི༌ ཤའེ༌ ཁག༌པོ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ ཏུས༌གྱུན༌ ཏང༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“ཨ༌རོན༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌ ཏམ༌པའེ༌ ཀོས༌ལག༌གུན༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ སྟད༌གོས༌། ཁོང༌གུན༌ལ༌ ཏེ༌གུན༌ སྐོན༌ཏེ༌ ཁོང༌གུན༌ནི༌ གོའེ༌ཀ༌ མར༌ ལུགས༌ཏེ༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌ལ༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ཨ༌རོན༌ནི༌ ཚབས༌ལ༌ བླ༌མ༌ གྱུར༌ཁན༌ནི༌ ཁོའེ༌ བུ༌ཚ༌, ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ཏམ༌པ༌ ནས༌སའེ༌ ནང༌ང༌ ལུག༌སྲོལ༌གུན༌ ཅོ༌ཨིན༌ ཞག༌མ༌ རྡུན༌ དུག༌ ཟ༌ནེ༌ ཏེ༌ ཀོས༌ལག༌གུན༌ གོན༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ སྐོ༌ ཟ༌ནེ༌ ལུག༌ཕོའེ༌ ཤ༌ ཆོད༌པ༌ ཕུལ༌ཁན༌བོ༌ ཏམ༌པ༌ ཀུར༌རི༌ ནང༌སྐོར༌རི༌ ནས༌ས༌ ཞིག༌གི༌ཀ༌ ཁྱེར༌ཏེ༌ སྐོལ༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ལུག༌ཕོའེ༌ ཤ༌ དང༌ པག༌ཙེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཏ༌གི༌ ཏམ༌པ༌ གུན༌ ཀུར༌རི༌ སྒོའེ༌ དུན༌ལ༌ ཟ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","བླ༌མའེ༌ ལས༌སི༌ ཕིའ༌ སྐོ༌ ཟ༌ནེ༌ ཁོང༌གུན༌ནི༌ སྡིག༌པ༌གུན༌ནི༌ ཤགས༌པའེ༌ ཕིའ༌ ཆོད༌པ༌ ཏང༌ཁན༌ནི༌ ཤ༌ ཟ༌གོས༌། བླ༌མ༌གུན༌ མན༌པ༌ ཞན༌སུའིང༌ ཏེ༌གུན༌ ཟའ༌ མི༌ཆོག༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌གུན༌ ཏམ༌པ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ཀལ༌ཏེས༌ ཆོད༌པ༌ ཕུལ༌ཁན༌ནི༌ ཤ༌ ཡ༌ ཏ༌གི༌ ང༌མོ༌ ཚག༌པ༌ ལུས༌ན༌ ཏེ༌གུན༌ མེའ༌ སྲག༌གོས༌། ཏེ༌གུན༌ ཟའ༌ མི༌ཆོག༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌བོ༌ ཏམ༌པ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ངའེ༌ ཁྱོ༌རང༌ང༌ བཀའ༌ ཏང༌ཁན༌ ཚང༌མ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ ཅོས༌། ཁོང༌གུན༌ བླ༌མའེ༌ ལས༌ལ༌ སྐོ༌ཅེས༌སི༌ ལུག༌སྲོལ༌གུན༌ ཅོ༌ཅེས༌ལ༌ ཞག༌པོ༌ རྡུན༌ གོར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ཏེ༌ རྡུན༌ཞག༌པོའེ༌ ནང༌ང༌ སྡིག༌པ༌གུན༌ནི༌ ཤགས༌པའེ༌ ཕིའ༌ ཞག༌ཏང༌ ལང༌ཏོ༌ ཅིག༌ ཆོད༌པ༌ ཕུལ༌, ཆོད༌ཁྲི༌ རྩང༌མ༌ ཅོས༌ ཡང༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ ལུགས༌ཏེ༌ ཏེ༌བོ༌ ཏམ༌པ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ཆོད༌ཁྲི༌ ཏམ༌པ༌ ཅོ༌ཅེས༌ལ༌ ཞག༌མ༌ རྡུན༌ ཆོད༌པ༌ ཕུལ༌། ཏེ༌ནེ༌ ཏེ༌བོ༌ ཏེ༌ཟམ༌ ཏམ༌པ༌ གྱུར༌ཨིན༌ ཏེ༌བོའ༌ ལག༌པ༌ རྩེ༌ཁན༌ ཡ༌ ཐུག༌ཁན༌བོའང༌ ཏམ༌པ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ཞག༌ཏང༌ ཆོད༌ཁྲི༌ཀ༌ ལོ༌ ཅིག༌པ༌ ལུ༌གུ༌ ཉིས༌ ཆོད༌པ༌ ཕུལ༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ཅིག༌པོ༌ ང༌མོ༌, ཡང༌ ཅིག༌པོ༌ ཕི༌ཏོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ལུ༌གུ༌ ཏང༌པོ༌ ཉམ༌པོ༌ ཀྱི༌ལོ༌ ཅིག༌ གྱལ༌ལ༌ པག༌ཕེ༌ ནང༌ང༌ ལི༌ཀྲར༌ ཅིག༌གི༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ སྲེས༌ཁན༌ ཡང༌ རྒུན༌ཆང༌ ལི༌ཀྲར༌ ཅིག༌ ཆོད༌པའ༌ ཕུལ༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ལུ༌གུ༌ ཉིས༌པ༌བོ༌ ཕི༌ཏོག༌ ཆོད༌པ༌ ཕུལ༌ ཡང༌ ཏེ༌བོ༌ ཉམ༌པོ༌ ང༌ཏོག༌ ཕུལ༌ཁན༌ ཟམ༌ཞིག༌གི༌ པག༌ཕེ༌, ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ དང༌ རྒུན༌ཆང༌ གུན༌ ཕུལ༌། ཏེ༌གུན༌ ང༌ ཡ༌ཝའེ༌ ཕིའ༌ ཆོད༌པ༌ མེའ༌སྲགས༌ཁན༌ ཡང༌ ཏེ༌བོའེ༌ ཏྲི༌མའེ༌ ང༌ ཡ༌ཝ༌ ཐད༌ ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“མི༌རབས༌ནེ༌ མི༌རབས༌ འི༌ མེའ༌ སྲག༌ཁན༌ནི༌ ཆོད༌པ༌བོ༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ ཡ༌ཝའེ༌ དུན༌ལ༌ ཅད༌མ༌ཅུག༌ག༌ ཕུལ༌གོས༌། ཏེ༌ཀ༌ ང༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ཐུགས༌ཏེ༌ ཁྱོ༌རང༌ང༌ སྤེ༌ར༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ཏེ༌ཀ༌ ང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཉམ༌པོ༌ ཐུག༌ཨིན༌ ཡང༌ ངའེ༌ སྤལ༌ ཏེ༌ཀ༌ ཡོད༌ཅེས༌པའེ༌ ཏེ༌ ནས༌ས༌བོ༌ ཏམ༌པ༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ངའེ༌ ཀུར༌ དང༌ ཆོད༌ཁྲི༌ ཏམ༌པ༌ ཅོ༌ཨིན༌ ཡང༌ ངའེ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ ཏམ༌པ༌ ཅོས༌ཏེ༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ངའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌ལ༌ སྐོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕྲོའ༌ དུགས༌ཏེ༌ ཁོང༌གུན༌ནི༌ དཀོན༌མཆོག༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ང༌ ཁོང༌གུན༌ནི༌ ཕྲོའ༌ དུག༌ཅེས༌ ཡང༌ ཁོང༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཁན༌ ང༌ ཡ༌ཝ༌ ཁོང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཨིན༌ཁན༌བོ༌ ཁོང༌གུན༌ནི༌ ཧ༌གོ༌ཨིན༌། ང༌ ཡ༌ཝ༌ ཁོང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “སྤོས༌ ཏུག༌ཅེས༌སིི༌ ཕིའ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཆོད༌ཁྲི༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ཏེ༌བོ༌ ཀྲུབ༌ཞི༌, ལྡོ༌གུན༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 45 ཡང༌ ཐོན༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 90 ཡོང༌གོས༌། ཏེ༌བོའེ༌ ཀྲུ༌ ཞི༌ཀོ༌ རཱ༌ཅོ༌ ཙོགས༌ ཙེབ༌ཙེབ༌ ཅོ༌གོས༌ ཡང༌ ཏེ༌གུན༌ ཆོད༌ཁྲི༌ ཉམ༌པོ༌ ཤིང༌ཅིག༌ག༌ ཞོག༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ཆོད༌ཁྲི༌ གང༌པོ༌ ཡང༌ན༌ ཏེ༌བོའེ༌ ཐོག༌, ཆོག༌ ཞི༌ཀོ༌ དང༌ རཱ༌ཅོ༌ གུན༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ ཉམ༌པོ༌ ཏུམ༌ ཡང༌ ཏེ༌བོའེ༌ ཐའ༌མ༌ ཀྱིར༌སྐོར༌ཏེ༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","སེར༌རི༌ ཀྱི༌ལྡིར༌ ཅོས༌ཏེ༌ ཆོགས༌ ཉིས༌ཀོའེ༌ཀ༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏང༌ཁན༌ནི༌ ཡོག༌ག༌ ཏོག༌, ཏེ༌ནེ༌ ཏེ༌བོ༌ ཁུར༌ཅེས༌སི༌ ཀྲ༌ལུ༌ གུན༌ ཏེ༌ནང༌ང༌ གྱུད༌ ཉན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ཏེ༌ ཀྲ༌ལུ༌གུན༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌, སེར༌ ཉམ༌པོ༌ ཏུམས༌ཏེ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ཆོད༌ཁྲི༌བོ༌ ཆད༌དོན༌ནི༌ སྒམ༌ དང༌ མི༌གུན༌ནི༌ སྡིག༌པའ༌ ཤགས༌པ༌ ཏང༌སའེ༌ སྒམ༌མི༌ ཁའ༌ལེབ༌, ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཐུག༌སའེ༌ དུན༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ནི༌ ཡོ༌ལའེ༌ ཉེ༌མོའ༌ ཏམ༌པའེ༌ ནས༌སའེ༌ ནང༌ང༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“ཞག༌ཏང༌ ང༌མོ༌ ཨ༌རོན༌ འོད༌སྟག༌གི༌ འོད༌གུན༌ནི༌ སྟ༌སྟོག༌ ཅོའ༌ ཆ༌ ཟ༌ནེ༌ ཁོའེ༌ ཏེ༌ ཆོད༌ཁྲི༌ཀ༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌ དུག༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ཕི༌ཏོག༌ འོད༌སྟག༌གུན༌ནི༌ འོད༌ སྤར༌ར༌ ཆ༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཁོའེ༌ ཆོད༌ཁྲི༌ཀ༌ སྤོས༌ དུག༌གོས༌། མི༌རབས༌ནེ༌ མི༌རབས༌ ཏེ༌བོ༌ ཅོ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","འི༌ ཆོད༌ཁྲི༌ཀ༌ ཏམ༌པ༌ མན༌ཁན༌ནི༌ སྤོས༌ ཡ༌ ཞན༌ མེའ༌ སྲག༌ཁན༌ནི༌ ཆོད༌པ༌ ཡ༌ ཀྲོ༌ནས༌སི༌ ཆོད༌པ༌ གུན༌ མ༌ཕུལ༌ ཡང༌ ཏེ༌ཀ༌ རྒུན༌ཆང༌ངི༌ ཆོད༌པའང༌ མ༌ཕུལ༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ལོའེ༌ ནང༌ང༌ ལན༌ཅིག༌ ཨ༌རོན༌ནི༌ ཆོད༌ཁྲི༌ རྩང༌མ༌ ཅོ༌ཅེས༌ལ༌ མི༌གུན༌ནི༌ སྡིག༌པའེ༌ ཤགས༌པའེ༌ ཕིའ༌ ཆོད༌པ༌ ཕུལ༌ཁན༌ནི༌ ཁྲག༌ ཏེ༌བོའེ༌ རཱ༌ཅོ༌གུན༌ནི༌ཀ༌ སྐུ༌གོས༌། འི༌བོ༌ མི༌རབས༌ནེ༌ མི༌རབས༌ ཅོ༌གོས༌། ཡ༌ཝའེ༌ འི༌ ཆོད༌ཁྲི༌བོ༌ ཚང༌མའེ༌སང༌ ཏམ༌པ༌ ཐེའ༌ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ཁྱོ༌རང༌ངི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཀྲངས༌ཀ༌ ལེན༌ ཟ༌ནེ༌ མི༌ རེ༌རེའེ༌ ཁོ༌རང༌ངི༌ མི༌ཚེ༌ ཕིའ༌ ཡ༌ཝའ༌ རིན༌ ཤལ༌གོས༌། ཏེ༌ནེ༌ མིང༌ ཅུག༌ ཟ༌ནེ༌ ཁོང༌གུན༌ནི༌ཀ༌ ཅའང༌ ནོད༌སྐྱལ༌ མི༌ཡོང། ");
INSERT INTO lbj_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","མི༌ ཀྲངས༌སི༌ ནང༌ང༌ མིང༌ཆུད༌ཁན༌ རེ༌རེའེ༌ མུལ༌ གརམ༌ 5.5 ཟམ༌ཤིག༌ ཡ༌ཝའ༌ ཆོད༌པའེ༌ ཚུལ༌ལ༌ ཏང༌གོས༌, ཏེ༌བོ༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཏབ༌བ༌ ཀོལ༌ཁན༌ནི༌ ཚད༌ ནང༌ཞིན༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ལོ༌ ཉི༌ཤུ༌ ཡང༌ ཏེ༌སང༌ མང༌ང༌ ཨིན༌ཁན༌ནི༌ མི༌ཚང༌མ༌, མི༌ ཀྲངས༌སི༌ ནང༌ང༌ རྩི༌གོས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝའ༌ ཆོད༌པ༌བོ༌ ཕུལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","མི༌ཚེ༌ སྐྱོབ༌ཅེས༌ལ༌ རིན༌ ཤལ༌ཏེ༌ ཡ༌ཝའ༌ ཆོད༌པ༌ ཕུལ༌ ཟ༌ནེ༌ ཆུག༌པོ༌གུན༌ནི༌ མུལ༌ གརམ༌ 5.5 སང༌ མང༌ང༌ ཡང༌ ཉལ༌བ༌ཅན༌གུན༌ནི༌ ཏེ༌སང༌ ཉུ༌ངུན༌ ཏང༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཆོད༌པ༌ ཕུལ༌ཁན༌ནི༌ པེ༌ནེ༌ ཏམ༌པ༌ ཀུར༌རི༌ ཟོབ༌སྐྱོར༌ དང༌ ཞན༌ ལས༌གུན༌ནི༌ ཕིའ༌ ཀོལ༌གོས༌། ཏེ༌བོའེ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཁོང༌གུན༌ནི༌ མི༌ཚེའེ༌ ཕིའ༌ རིན༌ ཤལ༌ཁན༌བོ༌ ཁོང༌གུན༌ལ༌ ཨིད༌ཏུ༌ སྐུལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ར༌གན༌ནི༌ ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ ཡང༌ ཏེ༌བོ༌ བོར༌ཅེས༌པོའང༌ ར༌གན༌ནི༌ ཅོས༌། ཏེ༌བོ༌ ཏམ༌པ༌ ཀུར༌ དང༌ ཆོད༌པ༌ མེའ༌ སྲག༌སའེ༌ ཆོད༌ཁྲི༌ པར༌ལ༌ བོར༌ཏེ༌ ཆུ༌ སྐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ཏེ༌ ཆུ༌ ཉམ༌པོ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ ལག༌པ༌ དང༌ རྐང༌པ༌ གུན༌ ཁྲུ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ཤི༌ཅུག༌ག༌ མི༌ཛད༌ཅེས༌ལ༌ ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཆའེ༌སང༌ སྔུན༌ལ༌ ཡང༌ ཡ༌ཝའེ༌ ཕིའ༌ ཆོད༌ཁྲི༌ཀ༌ ཆོད༌པ༌ ཕུལ༌ཏེ༌ མེའ༌ སྲག༌གི༌སང༌ སྔུན༌ལ༌ ཁོང༌གུན༌ནི༌ ཏེ༌ ཆུ༌ ཉམ༌པོ༌ ལག༌པ༌ ཁྲུ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ཤི༌ཅུག༌ག༌ མི༌ཛད༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌གུན༌ནི༌ ལག༌པ༌ དང༌ རྐང༌པ༌ གུན༌ ཁྲུ༌གོས༌། འི༌ ཁྲིམས༌པོ༌ མི༌རབས༌ནེ༌ མི༌རབས༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ པུར༌གྱུད༌གུན༌ནི༌ སྲུང༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“འི༌ ཚ༌མིག༌ གྱལ༌ལ༌གུན༌ ཁྱོང༌, མའེར༌ ཟེར༌ཁན༌ནི༌ མར༌ ཀྱི༌ལོ༌ 6, ཏྲི༌ཞིམ༌ཅན༌ནི༌ དཱལ༌ཅིན༌ནི༌ ཀྱི༌ལོ༌ 3 དང༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ ལྡམ༌བུ༌ ཀྱི༌ལོ༌ 3, ");
INSERT INTO lbj_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ཀ༌སིའ༌ ཟེར༌ཁན༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ ཤིང༌ ཀྱི༌ལོ༌ 6 ཡང༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ ལི༌ཀྲར༌ ཞི༌། ཏེ༌གུན༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཏབ༌བ༌ ཀོལ༌ཁན༌ནི༌ ཚད༌ ནང༌ཞིན༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ཏྲི༌ཞིམ༌ ཅོ༌ཁན༌ ཁས༌པ༌ མི༌ ཙོགས༌ལ༌ ཏེ༌གུན༌ སྲེས༌ཏེ༌ ཁྲུས༌ཏང༌ཅེས༌སི༌ ཏམ༌པའེ༌ མར༌ནག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ཏེ༌བོ༌ ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌ དང༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ཀ༌, ");
INSERT INTO lbj_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ཅོག༌ཙེ༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌, འོད༌སྟགས༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌ དང༌ སྤོས༌ དུག༌སའེ༌ ཆོད༌ཁྲི༌, ");
INSERT INTO lbj_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ཆོད༌པ༌ མེའ༌ སྲག༌སའེ༌ ཆོད༌ཁྲི༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌ ཡང༌ ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ དང༌ ཏེ༌བོ༌ བོར༌ས༌ གུན༌ ཏམ༌པ༌ ཅོ༌ཅེས༌ལ༌ ཡོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ཁྱོ༌རང༌ངི༌ ཅ༌ལག༌ ཚང༌མ༌ ཏེ༌ཟུག༌གི༌ རྩང༌མ༌ ཅོས༌ ཏེ༌ནེ༌ ཏེ༌གུན༌ ཏེ༌ཟམ༌ ཏམ༌པ༌ གྱུར༌ཨིན༌, ཏེ༌གུན༌ལ༌ ཐུག༌ཁན༌ གུན༌ ཏམ༌པ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“བླ༌མའེ༌ ཚུལ༌ལ༌ ངའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌སི༌ ཕིའ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ མར༌ནག༌ ལུགས༌ཏེ༌ ཁྲུས༌ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེར༌, ‘འི༌ ཁྲུས༌ཏང༌ཅེས༌སི༌ ཏམ༌པའེ༌ མར༌བོ༌ ཡོང༌ཅེས༌ཅན༌ནི༌ མི༌རབས༌གུན༌ནི༌ ངའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌སི༌ ནང༌ང༌ ཀོལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","འི༌བོ༌ ཨམ༌ མི༌ ཟུགས༌པོའ༌ ལུག༌ མ༌གོས༌ ཡང༌ ཁྱོ༌ཞའེ༌ ཏེ༌ ཚ༌མིག༌གུན༌ སྲེས༌ཏེ༌ ཏེན༌ན༌ ཙོགས༌ མར༌ ཅོ༌ མ༌གོས༌། ཏེ༌བོ༌ ཏམ༌པ༌ ཨིན༌ནོག༌ ཡང༌ ཁྱོ༌ཞེའང༌ ཏེ༌བོ༌ ཏམ༌པ༌ རྩི༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","སུ༌ཞིག༌གི༌ ཏེ༌ ཙོགས༌ ཏྲི༌ཞིམ༌མི༌ མར༌ ཅོ༌ན༌ ཡ༌ ཏེ༌བོ༌ བླ༌མ༌ མན༌ཁན༌ནི༌ མིའ༌ ཁྲུས༌ཏང༌ཅེས༌ལ༌ ཀོལ༌ན༌ ཏེ༌ མི༌བོ༌ ངའེ༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཕིངས༌ཏོང༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “འི༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ ཚ༌མིག༌, ཡང༌ན༌ སྐྲག༌ཀྲེ༌, ཨོ༌ནའི༌ཅ༌, གལ༌བ༌ནམ༌ དང༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ ཕརང༌ཀེན༌སེནས༌ གུན༌ ཁྱོང༌, ཏེ༌ ཚང༌མ༌ དྲན༌དྲའ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ཏྲི༌ཞིམ༌ ཅོ༌ཁན༌ ཁས༌པ༌ མི༌ ཙོགས༌ལ༌ ཏེ༌གུན༌ སྲེས༌ ཡང༌ ཚཱ༌ ཏབས༌ཏེ༌ ཏེ༌བོ༌ ལག༌མོ༌ དང༌ ཏམ༌པ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ཏེ༌བོའེ༌ ནང༌ནེ༌ ཙ༌པིག༌ཤིག༌ ཇམ༌པོ༌ ཀྲལ༌ཏེ༌ ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཐུག༌སའེ༌ ཏམ༌པ༌ ཀུར༌རི༌ ནང༌ང༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ དུན༌ལ༌ བོར༌། ཁྱོ༌ཞའེ༌ ཏེ༌བོ༌ ཚང༌མའེ༌སང༌ ཏམ༌པ༌ རྩི༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ཁྱོ༌ཞ༌རང༌ངི༌ ཕིའ༌ འི༌ ཙོགས༌ སྤོས༌ ཅོ༌ མ༌གོས༌། ཡ༌ཝའེ༌ ཕིའ༌ ཏེ༌བོ༌ ཏམ༌པ༌ རྩིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","སུ༌ཞིག༌གི༌ ཏེ༌ ཙོགས༌ ཏྲི༌ཞིམ༌ ཅོས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཕིའ༌ ཀོལ༌ན༌ ཁོ༌ ངའེ༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཕིངས༌ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ངའེ༌ ཡ༌ཧུ༌དཱའེ༌ སྡེ༌ ནང༌ནེ༌ ཨུ༌རི༌ བུ༌ཚ༌, ཧུར༌རི༌ ཚ༌འོ༌ བེ༌ཟ༌ལེལ༌ ལྡམས༌ཏེ༌ ཨིན༌ ");
INSERT INTO lbj_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ཡང༌ ཁོའེ༌ ནང༌ང༌ ངའེ༌ ཐུག༌ཉིད༌ སྐངས༌ཏེ༌ ཁོ༌ ཟོ༌ལས༌སི༌ རིགས༌ ཚང༌མའེ༌ ནང༌ང༌ ཁས༌པ༌, ཡང༌ ཁོའ༌ ཁྱུད༌ དང༌ རིག༌པ༌ ཏངས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","སེར༌, མུལ༌ དང༌ ར༌གན༌ ཉམ༌པོ༌ མ༌ ཁས༌པ༌ རི༌མོ༌ སྲུལ༌ཁན༌, ");
INSERT INTO lbj_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ཁྲ༌རྡོའ༌ ཅད༌ཏེ༌ སེར༌རི༌ ནང༌ང༌ ཅུག༌ཅེས༌ ཡང༌ ཤིང༌ སྐོས༌ དང༌ ཟོ༌ལས༌སི༌ རིགས༌ ཚང༌མའེ༌ ནང༌ང༌ ཁས༌པ༌ ཅོས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ངའེ༌ དཱན༌ནི༌ སྡེ༌ ནང༌ནེ༌ ཨ༌ཧི༌ས༌མག༌གི༌ བུ༌ཚ༌ ཨོ༌ཧོ༌ལིའབ༌ ཁོའ༌ ཡ༌ཏོ༌ ཅོ༌ཅེས༌ལ༌ ལྡམས༌ཏེ༌ ཨིན༌, ཡང༌ ངའེ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཅོ༌ཅེས༌ལ༌ ངའེ༌ ཞན༌ ལག༌ཤེས༌ ཚང༌མའ༌ ཁས༌པ༌ ལས༌ ཅོ༌ཅེས༌སི༌ ཁྱུད༌ ཏངས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌, ཆད༌དོན༌ནི༌ སྒམ༌ དང༌ ཏེ༌བོ༌ ཀབས༌ཁན༌ནི༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌ ཡང༌ ཀུར༌རི༌ ནང༌ཀུག༌ག༌ ཡོད༌ཁན༌ནི༌ ཅ༌ལག༌ ཚང༌མ༌ ངའེ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཅོ༌གོས༌: ");
INSERT INTO lbj_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ཡང༌ན༌ ཅོག༌ཙེ༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཁན༌ ཚང༌མ༌, ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌རི༌ འོད༌སྟགས༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌, སྤོས༌ དུག༌ཅེས༌སི༌ ཆོད༌ཁྲི༌, ");
INSERT INTO lbj_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ཆོད༌པ༌ མེའ༌ སྲག༌ཅེས༌སི༌ ཆོད༌ཁྲི༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌, ཡང༌ ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ དང༌ ཏེ༌བོ༌ བོར༌ས༌, ");
INSERT INTO lbj_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ཀོས༌ལག༌ ཙེམས༌ཁན༌ ལྡེ༌མོ༌གུན༌ ཡང༌ན༌ ཨ༌རོན༌ བླ༌མའེ༌ ཕིའ༌ ཏམ༌པ༌ ཀོས༌ལག༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ ཟ༌ནེ༌ གོན༌ཅེས༌སི༌ ཀོས༌ལག༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ཏམ༌པ༌ ནས༌སའེ༌ ཕིའ༌ ཁྲུས༌ཏང༌ཅེས༌སི༌ མར༌ནག༌ དང༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌། འི༌ ཚང༌མ༌ ངའེ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེར༌, ‘ཁྱོ༌ཞའེ༌ ངའེ༌ ཤབ༌བད༌, ངལ༌ཚོའེ༌ ཞག༌པོ༌ སྲུང༌གོས༌། ཡོང༌ཅེས༌ཅན༌ནི༌ མི༌རབས༌གུན༌ནི༌ ཕིའ༌ འི༌བོ༌ ཁྱོ༌ཞའ༌ དང༌ ངའེ༌ པར༌ལ༌ སྟགས༌ཤིག༌ ཨིན༌, ཏེ༌ནེ༌ ང༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌ ཏམ༌པ༌ ཅོ༌ཅེས༌པོ༌ ཁྱོ༌ཞའེ༌ ཤེས༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ཁྱོ༌ཞའེ༌ ཤབ༌བད༌དི༌ ངལ༌ཚོའེ༌ ཞག༌ སྲུང༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌ ཞག༌པོ༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ཏམ༌པ༌ ཨིན༌། ཏེ༌ ཞག༌པོ༌ ཏམ༌པ༌ མ༌རྩི༌ཁན༌ནི༌ མི༌བོ༌ སད༌གོས༌, ཡང༌ ཏེ༌ ཞག༌ག༌ ལས༌ ཅོ༌ཁན༌གུན༌ ངའེ༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཕིང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ཞག༌ དྲུག༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ལས༌ ཅོས༌ ཨིན༌ནའང༌ ཞག༌ རྡུན༌པ༌བོ༌ ཡ༌ཝའེ༌ ཕིའ༌ ཏམ༌པ༌, ཤབ༌བད༌ ངལ༌ཚོའེ༌ ཞག༌ ཨིན༌། ཏེ༌ ཞག༌ག༌ ལས༌ ཅོ༌ཁན༌ནི༌ མི༌བོ༌ སད༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མི༌རབས༌ནེ༌ མི༌རབས༌ འི༌ ཤབ༌བད༌དི༌ ཞག༌པོ༌ སྲུང༌གོས༌། འི༌ ཆད༌དོན༌བོ༌ ཁྱོ༌ཞའེ༌ ཏུས༌གྱུན༌ བོར༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","འི༌བོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ དང༌ ངའེ༌ པར༌ལ༌ ཏུས༌གྱུན༌ ལུས༌ཤེས༌ཅན༌ནི༌ སྟགས༌ཤིག༌ ཨིན༌ ཅིའ༌ཟེར༌ན༌ ང༌ ཡ༌ཝའེ༌ ཞག༌པོ༌ དྲུག༌གི༌ ནང༌ང༌ ནམ༌ཁའ༌ དང༌ ཇིག༌རྟེན༌ ཅོས༌པིན༌, ཡང༌ ཞག༌ རྡུན༌པའེ༌ ཞག༌ག༌ ལས༌ མ༌ཅོའ༌ ངལ༌ཚོས༌པ༌ ངའེ༌ ནང༌ང༌ ཡང༌སྐྱར༌ སྟོབས༌ སོ༌མའེ༌ གང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ཡ༌ཝའེ༌ སི༌ནཱའི༌ རི༌ཀ༌ མོ༌ཟེས༌ ཉམ༌པོ༌ ཞལ༌ཏ༌ སལ༌ ཚར༌ར༌ཅིག༌, ཁོང༌ངི༌ ཁོའ༌ རྡོའ༌ ལེབ༌ལེབ༌ ཉིས༌ སལས༌ ཀ༌བོའེ༌ཀ༌ ཡ༌ཝ༌ ཁོང༌རང༌ངི༌ ཆག༌ ཉམ༌པོ༌ བཀའ༌རྒྱ༌གུན༌ བྲིའ༌ ཛད༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","མོ༌ཟེས༌ རི༌ ཀ༌ནེ༌ ལོགས༌ཏེ༌ ཡོང༌ང༌ ཏུས༌ མང༌པོ༌ གོར༌པ༌ མི༌གུན༌ ཨ༌རོན༌ ཡོད༌ས༌ ཛོམས༌ཏེ༌ ཟེརས༌, “ཡོང༌, ང༌དང༌གུན༌ལ༌ ལམ༌སྟན༌ཁན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ ཅོས༌། ཏེ༌ མི༌ མོ༌ཟེས༌, ང༌དང༌ ཨི༌ཇིབ༌ནེ༌ ཕིང༌ཏེ༌ ཁྱོང༌ཁན༌བོའ༌ ཅི༌ སོང༌ ང༌ཞའ༌ གྱུས༌མེད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ཨ༌རོན༌ནི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ ན༌མ༌གུན༌, བུ༌ཚ༌གུན༌ དང༌ བུ༌མོ༌གུན༌ནི༌ ནམ༌ཅོག༌གི༌ སེར༌རི༌ ཨ༌ལོང༌གུན༌ ཕུད༌ཏེ༌ ངའ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ཏེ༌ནེ༌ མི༌ ཚང༌མའེ༌ ནམ༌ཅོག༌གི༌ སེར༌རི༌ ཨ༌ལོང༌གུན༌ ཕུད༌ཏེ༌ ཨ༌རོན༌ནི༌ཀ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ཁོའེ༌ ཁྱོང༌ཁན༌ནི༌ སེར༌གུན༌ ཞུ༌ ཅུགས༌ཏེ༌ བེ༌ཙོའེ༌ ཟོས༌ཏའེ༌ པར༌རི༌ ནང༌ང༌ ལུགས༌ཏེ༌ སྐུན༌དྲ༌ ཞིག༌ ཅོས༌། ཏེ༌ནེ༌ མི༌གུན༌ནི༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌, འི༌བོ༌ ང༌དང༌གུན༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཁན༌ནི༌ དཀོན༌མཆོག༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ཨ༌རོན༌ནི༌ ཏེ༌བོ༌ ཐོང༌ང༌ཅིག༌ སེར༌རི༌ བེ༌ཙོའེ༌ དུན༌ལ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌ཏེ༌ ཟེརས༌, “ཐོ༌རེ༌ ཡ༌ཝའ༌ རྩི༌ཝ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ གའ༌སྟོན༌ རྩི༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ཐོ༌རེ༌ ཟུག༌པོ༌ ང༌ཏོག༌ནེ༌ མི༌གུན༌ནི༌ མེའ༌ སྲག༌ཁན༌ནི༌ ཆོད༌པ༌ དང༌ ཞི༌དེ༌ ཆོད༌པ༌ གུན༌ ཕུལས༌། མི༌གུན༌ ཟའ༌ཅེས༌ དང༌ ཆང༌ ཐུང༌ཅེས༌ལ༌ སའེ༌ཀ༌ དུགས༌ ཡང༌ ལངས༌ཏེ༌ སྕོད༌པ༌ ངན༌པ༌ དང༌ ཁྲེལ༌མེད༌དི༌ ལས༌ ཅོ༌ཅེས༌ གོ༌ཟུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “དག༌ས༌རང༌ ཡོག༌ག༌ བབས༌ཏེ༌ སོང༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ངི༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཁན༌ནི༌ མི༌གུན༌ ངན༌པ༌ གྱུར༌ཏེ༌ སྡིག༌པ༌ ཅོ༌རུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ཁོང༌གུན༌ནི༌ ངའེ༌ བཀའ༌ ཏང༌ཁན༌བོ༌ འི༌ཟམ༌ གྱོགས༌པ༌ རྗེད༌ཏེ༌ ཁོ༌རང༌གུན༌ནི༌ ཕིའ༌ བེ༌ཙོའེ༌ ཟོས༌ཏེ༌ ནང༌ང༌ སེར༌རི༌ སྐུན༌དྲ༌ ཅོས༌ཏེ༌ ཅོལ༌དུག༌ ཡང༌ ཏེ༌བོའ༌ ཆོད༌པ༌ ཕུལ༌ཏེ༌ ‘འི༌བོ༌ ང༌དང༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཁན༌ནི༌ དཀོན༌མཆོག༌ ཨིན༌’ ཟེར༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “འི༌ མི༌གུན༌ནི༌ སྙིང༌ ཙམ༌ཤིག༌གི༌ སྐྱོང༌པོ༌ ཨིན༌ཁན༌བོ༌ ངའེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ཏ༌ ངའེ༌ དུན༌ནེ༌ སོང༌, ང༌ ཁོང༌གུན༌ནི༌ཀ༌ སྲོ༌ སྲན༌ཏྲེ༌ ཡོང༌ཏེ༌ རག༌, ངའེ༌ ཁོང༌གུན༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། ཏེ༌ནེ༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ གྱལ༌ཁམས༌ ཀྲག༌པོ༌ ཞིག༌ གྱུར༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ཁོ༌རང༌ངི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཐུགས༌སྲོ༌ ཞུ༌ཅུག༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོས༌ཏེ༌ ཟེརས༌, “ཡ༌ཝ༌ལེ༌, ཉེ༌རང༌ངི༌ སྟོབས༌ དང༌ ཝང༌ ཀྲག༌པོ༌ ཉམ༌པོ༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཁན༌ནི༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ནི༌ཀ༌ ཅིའ༌ ཐུགས༌སྲོ༌ སྐྱོད༌དད༌? ");
INSERT INTO lbj_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ཅིའ༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ ཟེར༌ཅུག༌ག༌ ཛད༌དད༌, ‘ངན༌པ༌ ཐབས༌ ཅོས༌ཏེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ མི༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིང༌ཏེ༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ སད༌ཏེ༌ མེད༌ཁན༌ ཅོའ༌ལ༌ ཁྱེར༌ཏེ༌ ཨིན༌ནོག༌?’ ཇུ༌ཇུ༌ ཐུགས༌སྲོ༌ སྐྱོད༌ད༌ མ༌ཛད༌། ཉེ༌རང༌ངི༌ ཐུགས༌སམ༌ གྱུར༌ར༌ ཛད༌ཏེ༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ལ༌ ཆད༌པ༌ སལ༌ལ༌ མ༌ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ཉེ༌རང༌ངི༌ ཞབས༌ཏོག༌པ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌, དང༌ ཡ༌ཀོབ༌ གུན༌ལ༌ ཞལ༌ཆད༌ དང༌ ནའ༌ ཁུར༌ར༌ ཛད༌ཏེ༌, ‘ཁྱོ༌ཞའེ༌ མིར༌གྱུད༌ ནམ༌ཁའེ༌ སྐར༌མ༌ ཙོགས༌ མང༌པོ༌ ཡང༌ འི༌ ས༌ཀྱད༌ ཚང༌མ༌ ཁྱོ༌ཞའེ༌ པུར༌གྱུད༌གུན༌ལ༌ སལ༌ལ༌ ཛད༌ཏེ༌ ཏུས༌གྱུན༌ནི༌ ཕིའ༌ ཁོང༌གུན༌ནི༌ ནོར༌སྐལ༌ གྱུར༌ཨིན༌’ མོལ༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ ཐུགས༌སམ༌ གྱུར༌ར༌ ཛད༌ཏེ༌ ཁོང༌རང༌ངི༌ མི༌གུན༌ལ༌ ཇིགས༌ནང༌ཅན༌ནི༌ ཆད༌པ༌ སལ༌ཨིན༌ མོལ༌ཁན༌བོ༌ ཅོའ༌ མ༌ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","མོ༌ཟེས༌སི༌ བཀའ༌རྒྱ༌ བྲིའ༌ཛད༌ཁན༌ནི༌ རྡོའེ༌ ལེབ༌ལེབ༌ ཉིས༌ཀོ༌ ལག༌པའེ༌ ནང༌ང༌ ཁུར༌ཏེ༌ རི༌ནེ༌ བབས༌ཏེ༌ ཡོངས༌། ཏེ༌གུན༌ནི༌ དུན༌ དང༌ གྱབ༌ ཉིས༌ཀོའེ༌ཀ༌ བྲིའ༌ཛད༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","རྡོའ༌ ལེབ༌ལེབ༌ གུན༌ དཀོན༌མཆོག༌གི༌ ཆག༌ལས༌ ཡང༌ བྲིའ༌ ཛད༌ཁན༌བོ༌ དཀོན༌མཆོག༌གི༌ ཆག༌བྲིས༌ རྡོའེ༌ཀ༌ སྐོའ༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ཡོ༌ཤུའ༌ མི༌གུན༌ནི༌ ཀུ༌ཅོ༌ ཏང༌ཨིན༌ ཚོར༌ར༌ཅིག༌ ཁོའེ༌ མོ༌ཟེས༌ལ༌ ཟེརས༌, “ཀུར༌ ཙུགས༌ཏེ༌ ཡོད༌ས༌ནེ༌ མག༌གི༌ སྐད༌ ཚོར༌ར༌རག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “འི༌བོ༌ གྱལ༌ཁའ༌ ཐོབ༌ཁན༌ནི༌ ཡ༌ མག༌ ཕམས༌ཁན༌ནི༌ སྐད༌ མ༌ནོག༌། ངའེ༌ ཚོར༌ཁན༌བོ༌ ནི༌ ལུ༌ ཏང༌ཁན༌ནི༌ སྐད༌ ཨིན༌རག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","མོ༌ཟེས༌ ཀུར༌ ཙུགས༌ཏེ༌ ཡོད༌སའེ༌ ཉེ༌མོའ༌ ལེབས༌ཏེ༌ བེ༌ཙོའེ༌ སྐུན༌དྲ༌ དང༌ མི༌གུན༌ རྩེའ༌ ཐོང༌པ༌ ཁོའ༌ སྲོ༌ སྲན༌ཏྲེ༌ ཡོངས༌ ཡང༌ ལག༌པའེ༌ ནང༌ང༌ ཁུར༌ཏེ༌ ཡོད༌ཁན༌ནི༌ རྡོའ༌ ལེབ༌ལེབ༌གུན༌ རི༌ ཀ༌ནེ༌ ཡོག༌ག༌ གྱབས༌ ཏངས༌ ཡང༌ ཏེ༌གུན༌ ཆག༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ཏེ༌ནེ༌ ཁོའེ༌ བེ༌ཙོའེ༌ སྐུན༌དྲ༌ མེ༌ ནང༌ང༌ ཕངས༌ཏེ༌ ཞུ༌ ཅུགས༌། སྟིང༌ནེ༌ ཏེ༌བོ༌ ཐགས༌ཏེ༌ ཆུའི༌ ནང༌ང༌ སྲེས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཐུང༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ཁོའེ༌ ཨ༌རོན༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ འི༌ མི༌གུན༌ལ༌ འི༌ཟམ༌ ངན༌པ༌ སྡིག༌པ༌ ཅོ༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཁྱོ༌རང༌ང༌ ཅི༌ ཅོས༌?” ");
INSERT INTO lbj_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ཨ༌རོན༌ནི༌ ལན༌ཏངས༌, “ངའེ༌ཀ༌ སྲོ༌ མ༌ཡོང༌། འི༌ མི༌གུན༌ལ༌ ཏུས༌གྱུན༌ ངན༌པ༌ ཅོ༌ཅེས༌སི༌ དོད༌པ༌ ཡོད༌ཁན༌བོ༌ ཁྱོ༌རང༌ང༌ གྱུས༌ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ཁོང༌གུན༌ནི༌ ང༌ ཟེར༌ར༌རག༌, ‘ང༌དང༌གུན༌ལ༌ ལམ༌སྟན༌ཁན༌ནི༌ དཀོན༌མཆོག༌ ཤིག༌ ཅོས༌། ཏེ༌ མི༌ མོ༌ཟེས༌, ང༌དང༌ ཨི༌ཇིབ༌ནེ༌ ཕིང༌ཏེ༌ ཁྱོང༌ཁན༌བོའ༌ ཅི༌ སོང༌ ང༌ཞའ༌ གྱུས༌མེད༌།’ ");
INSERT INTO lbj_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ཏེ༌ནེ༌ ངའེ༌ ཁོང༌གུན༌ལ༌ ཟེར༌པིན༌, ‘ཁྱོ༌རང༌གུན༌ནི༌ སེར༌རི༌ གྱན༌ཆ༌གུན༌ ཕུད༌ཏེ༌ ཁྱོང༌’ ཡང༌ ཁོང༌གུན༌ནི༌ ཁྱོང༌ཁན༌ ཚང༌མ༌ ངའེ༌ མེའེ༌ ནང༌ང༌ ཕངས༌པ༌ འི༌ སེར༌རི༌ བེ༌ཙོ༌བོ༌ བིང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ཨ༌རོན༌ལ༌ མི༌གུན༌ ཅུན༌ མ༌ཉན༌ན༌ ཉོན༌བ༌ ཙོགས༌, གྲ༌འོ༌གུན༌ནི༌ ཕིའ༌ སྟན༌མོ༌ གྱུར༌ཏེ༌ ཡོད༌ཁན༌བོ༌ མོ༌ཟེས༌ལ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ཏེ༌བོའེ༌ཕིའ༌ ཁོ༌ ཁོང༌གུན༌ ཚུགས༌ཏེ༌ ཡོད༌སའེ༌ སྒོའེ༌ཀ༌ ལངས༌ཏེ༌ ཟེརས༌, “ཡ༌ཝའེ༌ ཆོགས༌ལ༌ ཨིན༌ཁན༌གུན༌ ང༌ ཡོད༌ས༌ ཡོང༌” ཡང༌ ལི༌ཝི༌པ༌ ཚང༌མ༌ ཁོ༌ ཡོད༌ས༌ ཛོམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ཏེ༌ནེ༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཡ༌ཝ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌གི༌ མོལས༌, ‘ཁྱོ༌ཞ༌ རེ༌རེ༌ ར༌འི༌གུན༌ ལྡོའ༌ ཏགས༌ཏེ༌ ང༌དང༌ ཚུགས༌ཏེ༌ ཡོད༌སའེ༌ གོ༌ནེ༌ ཇུག༌ ཚག༌པ༌ སོང༌ཏེ༌ རང༌ངི༌ སྤུན༌, ཛ༌འོ༌ དང༌ ཁྱིམ༌ཚེས༌ གུན༌ སོད༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ལི༌ཝི༌པ༌གུན༌ནི༌ མོ༌ཟེས༌སི༌ བཀའ༌ ཏང༌ཁན༌བོ༌ ཅོས༌ ཡང༌ ཏེ༌ ཞག༌ག༌ མི༌ ཧ༌ལམ༌ སྟོང༌སུམ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","མོ༌ཟེས༌སི༌ ལི༌ཝི༌པ༌གུན༌ལ༌ ཟེརས༌, “དི༌རིང༌ ཁྱོ༌རང༌གུན༌ནི༌ ཁྱོ༌ཞ༌རང༌ ཡ༌ཝའེ༌ ཞབས༌ཏོགས༌སི༌ འོས༌པ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ རང༌ངི༌ བུ༌ཚ༌གུན༌ དང༌ སྤུན༌ལ༌གུན༌ སདས༌ ཡང༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ དི༌རིང༌ ཅིན༌ལབས༌ སལས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","སྟིང༌མ༌ཞག༌པོ༌ མོ༌ཟེས༌སི༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ སྡིག༌པ༌ ཆེན༌མོ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། ཨིན༌ནའང༌ ང༌ རི༌ཀ༌ ཡ༌ཝ༌ ཡོད༌ས༌ ཤགས༌པ༌ ཞུའ༌ ཆེན༌, ཅི༌གྱུས༌ ཁོང༌ངི༌ ཐུགས༌སམ༌ གྱུར༌ཏེ༌ ཁྱོ༌ཞའེ༌ སྡིག༌པ༌ ཤགས༌པ༌ སལ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ཏེ༌ནེ༌ མོ༌ཟེས༌ རི༌ཀ༌ ཡ༌ཝ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ ཟེརས༌, “འི༌ མི༌གུན༌ནི༌ སེར༌རི༌ སྐུན༌དྲ༌ ཅོས༌ ཡང༌ ཏེ༌བོའ༌ ཅོལ༌ཏེ༌ སྡིག༌པ༌ ཆེན༌མོ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ཇུ༌ཇུ༌ ཁོང༌གུན༌ནི༌ སྡིག༌པ༌ ཤགས༌པ༌ སལ༌ལ༌ ཛད༌། ཨིན༌ནའང༌ མ༌ སལ༌ན༌ ཏེ༌ནེ༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ནི༌ མིང༌ བྲིའ༌ ཛད༌ཁན༌ནི༌ སྤེ༌ཆའེ༌ ནང༌ནེ༌ ངའེ༌ མིང༌ ཐེན༌ན༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ཡ༌ཝའེ༌ ལན༌སལས༌, “ངའེ༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཅོ༌ཁན༌གུན༌ནི༌ མིང༌ ངའེ༌ སྤེ༌ཆའེ༌ ནང༌ནེ༌ ཐེན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ཏ༌ སོང༌ ཡང༌ མི༌གུན༌ ངའེ༌ ཤད༌ཁན༌ནི༌ ནས༌སའེ༌ ནང༌ང༌ ཁྲིད༌ ཡང༌ ངའེ༌ ཕོ༌ཉ༌ ཁྱོ༌རང༌ངི༌ སྔུན༌ལ༌ ཆེན༌། ཨིན༌ནའང༌ ཏུས༌པོ༌ ལེབ༌བ༌ཅིག༌ ངའེ༌ ཁོང༌གུན༌ནི༌ སྡིག༌པ༌ ཅོ༌ཁན༌བོའ༌ ཆད༌པ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ཡང༌ ཡ༌ཝའེ༌ མ༌ སད༌ཁན༌ནི༌ མི༌གུན༌ལ༌ ནད༌ རྩོག༌པོ༌ ཡོང༌ ཅུག༌ག༌ ཛདས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ཨ༌རོན༌ལ༌ སེར༌རི༌ བེ༌ཙོའེ༌ སྐུན༌དྲ༌ ཅོ༌ཅུགས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཁན༌ ཚང༌མ༌ འི༌ ས༌ཆ༌ནེ༌ བིང༌ཏེ༌ ངའེ༌ ཨབ༌ར༌ཧམ༌, ཨི༌སཱག༌, ཡ༌ཀོབ༌ གུན༌ལ༌ ‘ངའེ༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ ཏེ༌བོ༌ ཏང༌ཨིན༌’ ཟེར༌ཏེ༌ ཁ༌ཆད༌ ཅོ༌ཁན༌ནི༌ ས༌ཆ༌བོའ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ངའེ༌ ཁྱོ༌རང༌ངི༌ སང༌ སྔུན༌ལ༌ ཕོ༌ཉ༌ ལམ༌ཅུགས༌ཏེ༌ ཀེ༌ནན༌པ༌, ཨ༌མོར༌པ༌, ཧེད༌པ༌, པེ༌རིཟ༌པ༌, ཧིཝ༌པ༌ ཡང༌ ཡེ༌བས༌པ༌ གུན༌ ཕིང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ཁྱོ༌ཞ༌གུན༌ འོ༌མ༌ དང༌ རང༌རྩི༌ གྱུག༌སའེ༌ ས༌ཆ༌ སོང༌། ཨིན༌ནའང༌ ང༌ ཁྱོ༌ཞ༌གུན༌ ཉམ༌པོ༌ མི༌ཡོང༌, ཁྱོ༌ཞ༌གུན༌ མི༌ མ༌སྐྱོང༌པོ༌ ཨིན༌ པ༌སང༌ ངའེ༌ ལམ༌བར༌ལ༌ ཁྱོ༌ཞའ༌ མེད༌ཁན༌ ཅོ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","མི༌གུན༌ནི༌ ཏེ༌ སྤེ༌ར༌ སྐྱོང༌པོ༌ ཚོར༌ར༌ཅིག༌ ཁོང༌གུན༌ནི༌ ཉ༌ངན༌ ཅོས༌ཏེ༌ གྱན༌ཆ༌གུན༌ མ༌ཏགས༌ ");
INSERT INTO lbj_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལ༌ཏེ༌ ཨིན༌པིན༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེར༌, ‘ཁྱོ༌ཞ༌གུན༌ མི༌ མ༌སྐྱོང༌པོ༌ ཨིན༌ནོག༌། ཀལ༌ཏེས༌ ང༌ ཁྱོ༌རང༌གུན༌ ཉམ༌པོ༌ ཏུས༌ ཙ༌པིག༌ཤིག༌གི༌ ཕིའ༌ ཆ༌ནའང༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ མེད༌ཁན༌ ཅོ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌། ཏ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གྱན༌ཆ༌གུན༌ ཕུད༌ ཡང༌ ཁྱོ༌རང༌གུན༌ ཉམ༌པོ༌ ཅི༌ ཅོ༌གོ༌ཤེས༌པོ༌ ངའེ༌ ཐག༌ཅད༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ཏེན༌ན༌བོའེ༌ཕིའ༌ སི༌ནཱའི༌ རི༌ཀ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱན༌ཆ༌གུན༌ ཕུད༌ཏེ༌ ཡང༌སྐྱར༌ མ༌ནེ༌ མ༌ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ཏུས༌གྱུན༌ མོ༌ཟེས༌སི༌ ཀུར༌ ཙུགས༌ཏེ༌ དུག༌སའེ༌ ས༌ཆའེ༌ བན༌ཤིག༌ ཐག༌རིང༌ང༌ ཀུར༌ཞིག༌ ཙུགས༌ཏེ༌ ཏེ༌བོའ༌ ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌ ཟེར༌རད༌པིན༌། ཡང༌ ཡ༌ཝའ༌ ཏྲི༌ཝ༌ ཏྲི༌ཉིན༌ ཡོད༌ཁན༌གུན༌ ཀུར༌ ཙུགས༌ཏེ༌ ཡོད༌སའེ༌ ཕི༌ལོག༌ག༌ ཏམ༌པ༌ ཀུར༌རི༌ཀ༌ ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","མོ༌ཟེས༌ ཏེ༌ ཀུར༌རི༌ ནང༌ང༌ ཆ༌ ཟ༌ནེ༌ མི༌གུན༌ རང༌རང༌ངི༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ ལངས༌ཏེ༌ མོ༌ཟེས༌ ཏེ༌ནང༌ཀུག༌ག༌ ཞུགས༌ ཞུགས༌ ཚོག༌པ༌ ལྟའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","མོ༌ཟེས༌ ཏེ༌ནང༌ང༌ ཞུགས༌ ཚར༌ར༌ཅིག༌ སྲིན༌ནི༌ ཀ༌ཝ༌ བབས༌ཏེ༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ དུག༌གད༌པིན༌ ཡང༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ ཞལ༌ཏ༌ སལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","མི༌གུན༌ནི༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ སྲིན༌ནི༌ ཀ༌ཝ༌ ཐོང༌ང༌ཅིག༌ ཁོང༌ ཚང༌མའེ༌ རང༌རང༌ངི༌ ཀུར༌རི༌ སྒོའེ༌ དུན༌ལ༌ ཆག༌ཕུལ༌ཏེ༌ ཡ༌ཝའ༌ ཅོལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ཛ༌འོ༌ དུན༌ལ༌ ཡོད༌ཏེ༌ སྤེ༌ར༌ ཏང༌ཁན༌ ཙོགས༌ལ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ ཉམ༌པོ༌ ཞལ༌ཏ༌ སལ༌ལད༌པིན༌། ཏེ༌ སྟིང༌ནེ༌ མོ༌ཟེས༌ ཞན༌ ཀུར༌གུན༌ ཙུགས༌ཏེ༌ ཡོད༌སའ༌ ལོགས༌ཏེ༌ ཡོང༌ངད༌པིན༌, ཨིན༌ནའང༌ ཁོའ༌ རོགས༌ཅོ༌ཁན༌ ཡོ༌ཤུའ༌ ནུན༌ནི༌ བུ༌ཚ༌ ཡ༌ཝ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ནེ༌ བིངས༌ཏེ༌ མ༌ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","མོ༌ཟེས༌སི༌ ཡ༌ཝའ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ངའ༌ མོལས༌, ‘འི༌ མི༌གུན༌ ངའེ༌ ཁ༌ཆད༌ ཅོ༌ཁན༌ནི༌ ས༌ཆ༌ ཁྱེར༌། ངའེ༌ ཁྱོ༌རང༌ གྱལ༌ལ༌ ཅོས༌ཏེ༌ ཤེས༌སད༌ ཡང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ང༌ ཐད༌པོ༌ ཨིན༌།’ ཨིན༌ནའང༌ ཉེ༌རང༌ངི༌ སུ༌ ངའ༌ རོགས༌ ཅོའ༌ལ༌ ཀལ༌ལ༌ ཛད༌ཅེས༌པོ༌ སྔོན༌ཅུག༌ག༌ མ༌ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ཀལ༌ཏེས༌ ཉེ༌རང༌ ང༌ ཉམ༌པོ༌ དེན༌བ༌ ཐད༌པོ༌ ཨིན༌ན༌ ཉེ༌རང༌ངི༌ ལམ༌མི༌ཀ༌ ངའ༌ ཁྲིད༌ད༌ ཛད༌ ཏེ༌ནེ༌ ངའེ༌ ཉེ༌རང༌ངི༌ ཐུག༌གོངས༌ ཤེས༌ཏེ༌ ངའེ༌ ཏུས༌གྱུན༌ ཉེ༌རང༌ ཐུགས༌ཐད༌ཅུག༌ ཉན༌ཨིན༌། ཨིད༌ཏུ༌ ཛད༌དའང༌, འི༌ གྱལ༌ཁམས༌པོ༌ ཉེ༌རང༌ངི༌ མི༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ཡ༌ཝའེ༌ མོལས༌, “ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཆེན༌ ཡང༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ སྙིང༌ངི༌ ནང༌ང༌ ཞི༌དེ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","མོ༌ཟེས༌སི༌ ལན༌ཏངས༌, “ཀལ༌ཏེས༌ ཉེ༌རང༌ ང༌ཞ༌གུན༌ ཉམ༌པོ༌ མ༌སྐྱོད༌ན༌ ང༌ཞའ༌, འི༌ ས༌ཆ༌ བོར༌ཏེ༌ ཆ༌ཅུག༌ག༌ མ༌ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ཀལ༌ཏེས༌ ཉེ༌རང༌ ང༌ཞ༌གུན༌ ཉམ༌པོ༌ མ༌སྐྱོད༌ན༌ ཉེ༌རང༌ ང༌ དང༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ ཉམ༌པོ༌ ཐུག༌ཉེས༌ཁན༌ ཇིག༌རྟེན༌པ༌གུན༌ལ༌ ཀ༌ཟུག༌གི༌ ཧ༌གོ༌ཨིན༌། ཉེ༌རང༌ ང༌ཞ༌གུན༌ ཉམ༌པོ༌ སྐྱོད༌ན༌, ང༌ཞའ༌ ཇིག༌རྟེན༌ནི༌ ཞན༌ མི༌ ཚང༌མའེ༌ སང༌ སོ༌སོ༌ ཨིན༌ཁན༌བོ༌ ཧ༌གོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ངའེ༌ ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌བོ༌ ཅོ༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁྱོ༌རང༌ གྱལ༌ལ༌ ཅོས༌ཏེ༌ ཤེས༌སད༌ ཡང༌ ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཐད༌པོ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ཞུ༌ཝ༌ ཕུལས༌, “ཉེ༌རང༌ངི༌ སྤལ༌ ངའ༌ སྟན༌ན༌ ཛད༌དའང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ཡ༌ཝའེ༌ ལན༌སལས༌, “ངའེ༌ ང༌རང༌ངི༌ ཟང༌པོ༌ ཚང༌མ༌ ཁྱོ༌རང༌ངི༌ དུན༌ནེ༌ ཆ༌ཅུག༌ཨིན༌ ཡང༌ སལ༌པོ༌ ཅོས༌ཏེ༌ ཁྱོ༌རང༌ང༌ ངའེ༌ མིང༌ ཡ༌ཝ༌ ཨིན༌ཁན༌བོ༌ ཟེར༌ཨིན༌། སྙིང༌རྗེ༌ སྟན༌ན༌ ཐད༌ཁན༌གུན༌ལ༌ ངའེ༌ སྙིང༌རྗེ༌ སྟན༌ཨིན༌ ཐུག༌རྗེ༌ སྟན༌ན༌ ཐད༌ཁན༌གུན༌ལ༌ ངའེ༌ ཐུག༌རྗེ༌ སྟན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ ལྡོང༌ང༌ ལྟ༌ མི༌ཆོག༌ ཅིའ༌ཟེར༌ན༌ སུ༌ཞིག༌གའང༌ ངའེ༌ ལྡོང༌ ཐོང༌ཏེ༌ སྟིང༌ནེ༌ སོན༌ཏེའ༌ མི༌ལུས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ཡ༌ཝའེ༌ མོལས༌, “འི༌ཀ༌ ངའེ༌ དུན༌ལ༌ ཡོད༌ཁན༌ནི༌ བྲག༌གི༌ཀ༌ ཁྱོ༌རང༌ ལངས༌ཏེ༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ངའེ༌ ཟིར༌རྗིད༌ ཁྱོ༌རང༌ངི༌ དུན༌ནེ༌ ཆའ༌ཅིག༌ ངའེ༌ ཁྱོ༌རང༌ བྲག༌གི༌ པར༌ལ༌ བོར༌ཏེ༌ ང༌ ཏེ༌ཀ༌ནེ༌ ཆ༌ ཚར༌ཚར༌ ཚག༌པ༌ ང༌རང༌ངི༌ ལག༌པ༌ ཁྱོ༌རང༌ངི༌ ལྡོང༌ང༌ ཀབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ཆ༌ ཚར༌ཏེ༌ སྟིང༌ནེ༌ ངའེ༌ ལག༌པ༌བོ༌ ཐེན༌ཨིན༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ གྱབ༌པོ༌ ཐོང༌ཨིན༌ ཨིན༌ནའང༌ ངའེ༌ ལྡོང༌ མི༌ཐོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “གོ༌མའེ༌ ཙོགས༌ རྡོའ༌ ལེབ༌ལེབ༌ ཉིས༌ ཅོད༌, ཡང༌ ཁྱོ༌རང༌ངི༌ ཅག༌ཁན༌ སྔོན༌ནི༌ རྡོའ༌ ལེབ༌ལེབ༌གུན༌ནི༌ཀ༌ བྲིས༌ཁན༌ནི༌ ཚིགས༌གུན༌ ངའེ༌ འི༌གུན༌ནི༌ཀ༌ བྲི༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ཐོ༌རེ༌ ང༌མོ༌ནེ༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ ཀེན༌ལ༌ སི༌ནཱའི༌ རིའི༌ གོའེ༌ཀ༌ ང༌ ཉམ༌པོ༌ ཐུག༌ག༌ལ༌ ཡོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","སུ༌ཞིག༌གའང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ རི༌ཀ༌ ཡ༌ རིའི༌ དུན༌ལ༌ ཡོང༌ མ༌གོས༌, ཡང༌ ལུག༌ དང༌ བ༌ལང༌ གུན༌ རི༌ དུན༌ལ༌ ཚོའ༌ལ༌ ཁྱོང༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ སྔུན༌མ༌ ཙོགས༌ རྡོའ༌ ལེབ༌ལེབ༌ ཉིས༌ ཅདས༌ ཡང༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ནེ༌ ཏེ༌གུན༌ ཁུར༌ཏེ༌ ཁོ༌ སི༌ནཱའི༌ རི༌ཀ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ཡ༌ཝ༌ སྲིན༌ནི༌ ནང༌ང༌ བབས༌ཏེ༌ སྐྱོདས༌, ཡང༌ ཁོ༌ ཉམ༌པོ༌ ཏེ༌རུ༌ ཞངས༌ཏེ༌ ཁོང༌རང༌ངི༌ ཚན༌ ཡ༌ཝ༌ ཨིན༌ཁན༌བོ༌ ཁོའ༌ ཤད༌ད༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","མོ༌ཟེས༌སི༌ དུན༌ནེ༌ སྐྱོད༌ཨིན༌ ཡ༌ཝའེ༌ མོལས༌, “ཡ༌ཝ༌, ཡ༌ཝ༌, སྙིང༌རྗེ༌ དང༌ ཐུག༌རྗེ༌ གངས༌ཁན༌ དཀོན༌མཆོག༌, སྲོ༌ གྱོགས༌པ༌ མ༌ ཡོང༌ཁན༌, གྱུར༌ཇ༌ མེད༌ཁན༌ནི༌ ཅམས༌པ༌ སྟན༌ཁན༌ དང༌ ཨིད༌ཤེས༌ཅན༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ངའེ༌ མི༌རབས༌ སྟོང༌ ཚག༌པ༌ ཅམས༌པ༌ སྟན༌ཨིན༌ ཡང༌ ངན༌པ༌, ངོ༌ལོག༌ དང༌ སྡིག༌པ༌ ཅོ༌ཁན༌གུན༌ལ༌ ཤགས༌པ༌ ཏང༌ཨིན༌། ཨིན༌ནའང༌ ནོངས༌ཅན༌གུན༌ལ༌ ཆད༌པ༌ མ༌ཏང༌ང༌ མི༌བོར༌, ཁོང༌གུན༌ ཅིག༌པོའ༌ མན༌པ༌ ཁོང༌གུན༌ནི༌ ཕྲུ༌གུ༌གུན༌ དང༌ ཚ༌འོ༌ ཚ༌མོ༌ གུན༌, མི༌རབས༌ སུམ༌ ཡང༌ ཞི༌ ཚག༌པ༌ ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོའེ༌ ཅོ༌ཁན༌ནི༌ སྡིག༌པའེ༌ ཞས༌ཏེ༌ ཆད༌པ༌ ཕོག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","མོ༌ཟེས༌སི༌ གྱོགས༌པ༌ སའེ༌ཀ༌ གོ༌ སྒུས༌ཏེ༌ ཁོང༌ང༌ ཅོལས༌ ");
INSERT INTO lbj_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ཡང༌ ཟེརས༌, “ཡ༌ཝ༌ལེ༌ ཀལ༌ཏེས༌ ཉེ༌རང༌ ངའེ༌ཀ༌ ཐུག༌ཉེས༌ས༌ ཛད༌དད༌ན༌, ཉེ༌རང༌ ང༌ཞའ༌ ཉམ༌པོ༌ སྐྱོད༌ད༌ ཛད༌། འི༌ མི༌གུན༌ སྐྱོང༌པོ༌ ཨིན༌ནའང༌ ང༌ཞ༌གུན༌ནི༌ ངན༌པ༌ དང༌ སྡིག༌པ༌གུན༌ལ༌ ཤགས༌པ༌ སལ༌ལ༌ ཛད༌ཏེ༌ ང༌ཞའ༌ ཉེ༌རང༌ངི༌ མིག༌སལ༌ལི༌ མི༌གུན༌ནི༌ ཚུལ༌ལ༌ ལེན༌ན༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “ངའེ༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ཆད༌དོན༌ ཅོའད༌། ཇིག༌རྟེན༌ ཡ༌ གྱལ༌ཁམས༌ ཚང༌མའེ༌ ནང༌ང༌ སུ༌ཞིག༌གིའང༌ མ༌ཅོ༌ཁན༌ ཧ༌ལས༌ཤེས༌སི༌ ལྟས༌ རིག༌ ངའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ དུན༌ལ༌ ཅོ༌ཨིན༌། ང༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ཅོ༌ཁན༌ནི༌ ལས༌གུན༌ ཏེ༌ཟམ༌ ཧ༌ལས༌ཤེས༌ ཡོད༌ཁན༌བོ༌ མི༌ཚང༌མའེ༌ ཐོང༌ཨིན༌ ཀ༌གུན༌ནི༌ ཕྲོའ༌ ཁྱོ༌ཞའ༌ དུག༌གད༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","དི༌རིང༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ བཀའ༌ ཏང༌ཁན༌གུན༌ ཅོས༌ ཡང༌ ངའེ༌ ཁྱོ༌ཞའེ༌ དུན༌ལ༌ འི༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཨ༌མོར༌པ༌, ཀེ༌ནན༌པ༌, ཧེད༌པ༌, པེ༌རིཟ༌པ༌, ཧིཝ༌པ༌ ཡང༌ ཡེ༌བས༌པ༌ གུན༌ ཕིང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ཁྱོ༌ཞའ༌ ཆ༌ཅེས༌ཅན༌ནི༌ ནས༌སའེ༌ མི༌གུན༌ ཉམ༌པོ༌ ཞི༌དེའེ༌ ཆད༌དོན༌ མ༌ཅོ༌, ཀལ༌ཏེས༌ ཅོ༌ན༌ ཁོང༌གུན༌ནི༌ ངན༌པ༌ མི༌ཚེ༌ ཕུད༌ཨིན༌ ཡོད༌ཁན༌བོའེ༌ ནང༌ང༌ ཁྱོ༌ཞ༌གུན༌ ཁད༌ད༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ཁོང༌གུན༌ནི༌ ཆོད༌ཁྲི༌གུན༌ ཤིག༌, ཁོང༌ངི༌ ཏམ༌པ༌ ཀ༌ཝ༌གུན༌ ཅོག༌ ཡང༌ ཨ༌ཤེ༌རཧ༌ ཟེར༌ཁན༌ནི༌ ཁོང༌གུན༌ནི༌ ལྷ༌མོའེ༌ རྡུང༌མ༌ ལངས༌ཁན༌གུན༌ མེད༌ཁན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ཞན༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཅོལ༌ མ༌ཅོལ༌ ཅིའ༌ཟེར༌ན༌ ང༌ ཡ༌ཝ༌ ཅིག༌པོ༌ མ༌ནེ༌ སུ༌ཞིག༌གའང༌ ཏེ༌ སྤལ༌ལི༌ འོས༌པ༌ མན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ཏེ༌ ཡུལ༌ལི༌ མི༌གུན༌ ཉམ༌པོ༌ ཞི༌དེའེ༌ ཆད༌དོན༌ མ༌ཅོ༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ཁོང༌རང༌གུན༌ནི༌ ལྷ༌ དང༌ ལྷ༌མོ༌ གུན༌ལ༌ ཅོལ༌ཏེ༌ སྲོག༌ཆོད༌ ཏང༌ཁན༌ནི༌ ཁར༌ཇི༌ ཁྱོ༌ཞའ༌ ཟའ༌ལ༌ བོད༌ན༌ ཁྱོ༌ཞའ༌ ཏེ༌བོ༌ ཟའ༌ལ༌ ཆ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌ ");
INSERT INTO lbj_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ཡང༌ ཁྱོ༌ཞའེ༌ བུ༌ཚ༌གུན༌ནི༌ ཏེ༌ ཡུལ༌ལི༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ བག༌མ༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཁྱོ༌ཞའེ༌ བུ༌ཚ༌གུན༌ནི༌ སེམས༌ གྱུར༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཅོལ༌ ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ཁྱོ༌ཞ༌གུན༌ནི༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཕིའ༌ སེར༌ ཡ༌ མུལ༌ ཡ༌ ཞན༌ ལྕགས༌ རིགས༌གུན༌ནི༌ སྐུན༌དྲ༌ ཅོ༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཏུས༌ཆེན༌ རྩིས༌། ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཨ༌བིབ༌བི༌ ཟླ༌ཝའེ༌ ནང༌ང༌ ཞག༌མ༌ རྡུན༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཟོ༌ ཅིའ༌ཟེར༌ན༌ འི༌ ཟླ༌ཝའེ༌ ནང༌ང༌ ཁྱོ༌ཞའ༌ ཨི༌ཇིབ༌ནེ༌ བིངས༌ཏེ༌ ཡོངས༌ཏེ༌ ཨིན༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“གོ༌སྐྱེས༌ བུ༌ཚ༌ ཚང༌མ༌ ངའེ༌ ཨིན༌, ཏེ༌ནང༌ང༌ ཁྱོ༌ཞའེ༌ སྲལ༌ཁན༌ནི༌ སེམས༌ཅན༌ ཚང༌མའེ༌ གོ༌སྐྱེས༌ ཕོ༌གུན༌ནའང༌ ཐེས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ལུ༌གུ༌ཞིག༌ ཚབས༌ལ༌ ཏངས༌ཏེ༌ གོ༌སྐྱེས༌ བུང༌བུ༌ ལོགས༌ཏེ༌ ཉོ༌ཉན༌ཨིན༌། ཀལ༌ཏེས༌ ལོགས༌ཏེ༌ མ༌ཉོ༌ན༌ ཏེ༌བོའེ༌ ཇིང༌བ༌ ཅགས༌ཏེ༌ སད༌ཏོང༌། ཁྱོ༌ཞའེ༌ གོ༌སྐྱེས༌ བུ༌ཚ༌ ཚང༌མ༌ ལོགས༌ཏེ༌ ཉོ༌གོས༌།” “ལག༌པ༌ སྟོང༌པ༌ སུ༌ཞིག༌གའང༌ ངའེ༌ དུན༌ལ༌ མ༌ཡོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ཁྱོ༌ཞའེ༌ ཞག༌མ༌ དྲུག༌ ལས༌ ཅོས༌ ཨིན༌ནའང༌ ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ ལས༌ མ༌ཅོའ༌ ངལ༌ཚོ༌གོས༌། སྟོན༌ཐོག༌ ཏབ༌ཅེས༌ དང༌ རྔ༌ཅེས༌སི༌ ཏུས༌ལའང༌ ཏེ༌ བཀའ༌ཁྲིམས༌པོ༌ སྲུང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","ཁྱོ༌ཞའེ༌ གོ༌མའེ༌ ཀྲོའེ༌ སྟོན༌ཐོག༌པོ༌ རྔའ༌ཅིག༌ རྔབ༌སའེ༌ ཏུས༌ཆེན༌ ཡང༌ སྟོན༌ལ༌ ཁྱོ༌ཞའེ༌ ཁ༌ཟས༌གུན༌ ལྡུམ༌ ཚར༌ར༌ཅིག༌ སྟོན༌ཐོག༌ ནང༌ང༌ ཁྱོང༌ཅེས༌སི༌ ཏུས༌ཆེན༌ རྩི༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ལོའེ༌ ནང༌ང༌ ལན༌ སུམ༌ ཁྱོ༌ཞའེ༌ བུ༌ཚ༌ ཚང༌མ༌ ཡ༌ཝ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌གི༌ དུན༌ལ༌ ཁོང༌ང༌ ཅོལ༌ཅེས༌ལ༌ ཛོམ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ངའེ༌ ཁྱོ༌ཞའེ༌ དུན༌ལ༌ ཞན༌ ཡུལ༌ལི༌ མི༌གུན༌ ཐེན༌ཏེ༌ ཁྱོ༌ཞའེ༌ ས༌ཆའེ༌ སན༌ཚམས༌ སྐྱེད༌ཨིན༌ ཡང༌ ཡ༌ཝའེ༌ དུན༌ལ༌ ལོ༌ཞུང༌ ལན༌ སུམ༌ ཏུས༌ཆེན༌ རྩེའ༌ ཆ༌ ཟ༌ནེ༌ ཞན༌ གྱལ༌ཁམས༌གུན༌ནི༌ ཁྱོ༌ཞའེ༌ ས༌ཆའ༌ ཀོགས༌ཏེ༌ མི༌ཁྱེར༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ངའ༌ སེམས༌ཅན༌ སྲོག༌ཆོད༌ལ༌ ཕུལ༌ ཟ༌ནེ༌ ཏེ༌བོ༌ ཉམ༌པོ༌ སྐྱུར༌ཅན༌ནི༌ ཏ༌གི༌ མ༌ཕུལ༌ ཡང༌ པེ༌སག༌གི༌ ཏུས༌ཆེན༌ནི༌ ཕིའ༌ སད༌ཁན༌ནི༌ སེམས༌ཅན༌ནི༌ ཤའ༌ ཐོ༌རེ༌ ང༌མོ༌ ཚག༌པ༌ བོར༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“ཁྱོ༌ཞའེ༌ ཏབ༌ཁན༌ནི༌ སྟོན༌ཐོག༌གི༌ གོ༌མའེ༌ བྲས༌བུ༌ གྱལ༌ཤོག༌པོ༌ ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ ཆོད༌ཁང༌ང༌ ཁྱོང༌།” “རི༌གུའི༌ ཤ༌ ཏེ༌བོའེ༌ ཨ༌མའེ༌ འོ༌མའེ༌ ནང༌ང༌ མ༌ སྐོལ༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, “འི༌ ཚིགས༌གུན༌ བྲིས༌ ཅིའ༌ཟེར༌ན༌ འི༌ བཀའ༌ཁྲིམས༌གུན༌ གྱུད༌ཏེ༌ ངའེ༌ ཁྱོ༌རང༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཉམ༌པོ༌ ཆད༌དོན༌ ཅོའད༌།” ");
INSERT INTO lbj_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ཟའ༌ཅེས༌ ཡ༌ ཐུང༌ཅེས༌ མེད༌ད༌ ཉི༌མ༌ ཞིབ༌ཅུ༌ དང༌ ཚན༌ ཞིབ༌ཅུ༌ མོ༌ཟེས༌ རི༌ཀ༌ ཡ༌ཝ༌ ཉམ༌པོ༌ དུགས༌། ཁོའེ༌ རྡོའ༌ ལེབ༌ལེབ༌གུན༌ནི༌ཀ༌ ཆད༌དོན༌ནི༌ ཚིགས༌གུན༌ བྲིས༌ ཡང༌ན༌ བཀའ༌རྒྱ༌ རྕུ༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","མོ༌ཟེས༌ བཀའ༌རྒྱ༌ རྕུ༌ བྲིའ༌ཛད༌ཁན༌ནི༌ རྡོའ༌ ལེབ༌ལེབ༌ ཉིས༌ཀོ༌ ཁུར༌ཏེ༌ སི༌ནཱའི༌ རི༌ནེ༌ བབས༌ཏེ༌ ཡོང༌ ཟ༌ནེ༌, ཡ༌ཝ༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏང༌ པ༌སང༌ ཁོའེ༌ ལྡོང༌ འོད༌ ཙོགས༌ ལྡང༌ཤན༌ ཡོད༌ཁན༌བོ༌ ཁོའ༌ གྱུས༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ཨ༌རོན༌ དང༌ མི༌ཚང༌མའེ༌ མོ༌ཟེས༌ལ༌ ལྟའ༌ཅིག༌ ཁོའེ༌ ལྡོང༌ འོད༌ ཙོགས༌ ལྡང༌ཤན༌ ཐོང༌པ༌ ཁོང༌གུན༌ ཁོའེ༌ དུན༌ལ༌ ཆ༌ཅེས༌ལ༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ བོདས༌པ༌ ཨ༌རོན༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌ ཚང༌མ༌ ཁོ༌ ཡོད༌ས༌ སོང༌ ཡང༌ མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ སྤེ༌ར༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ཏེ༌ སྟིང༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཁོའེ༌ དུན༌ལ༌ ཛོམ༌ ཡང༌ ཡ༌ཝའེ༌ སི༌ནཱའི༌ རི༌ཀ༌ ཁོའ༌ སལ༌ལ༌ ཛད༌ཁན༌ནི༌ བཀའ༌ཁྲིམས༌ ཚང༌མ༌ མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏང༌ ཚར༌ར༌ཅིག༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ལྡོང༌བོ༌ རས༌ཤིག༌ ཉམ༌པོ༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","མོ༌ཟེས༌ ཡ༌ཝ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཁོང༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏང༌ང༌ ཆ༌ ཟ༌ནེ༌ ཁོའེ༌ ལྡོང༌ ཀབས༌ཁན༌ནི༌ རས༌པོ༌ ཐེན༌ནད༌པིན༌། ཕི༌ལོག༌ག༌ ཡོངས༌ཏེ༌ ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ཚང༌མ༌ ཤད༌དད༌པིན༌ ");
INSERT INTO lbj_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ཡང༌ ཁོའེ༌ ལྡོང༌ ལྡང༌ཤན༌བོ༌ ཁོང༌གུན༌ནི༌ ཐོང༌ངད༌པིན༌, ཏེ༌ནེ༌ མོ༌ཟེས༌ ཡང༌སྐྱར༌ ཡ༌ཝ༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏང༌ང༌ ཆ༌ཆ༌ ཚག༌པ༌ ཁོའེ༌ ལྡོང༌ ཀབས༌ཏེ༌ བོར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","མོ༌ཟེས༌སི༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའ༌ ཛོམ༌ཅེས༌ལ༌ བོདས༌ ཡང༌ ཟེརས༌, “ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌, འི༌གུན༌ ཅོ༌ཅེས༌ལ༌ བཀའ༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ཁྱོ༌ཞ༌གུན༌ནི༌ ཞག༌མ༌ དྲུག༌ ལས༌ ཅོས༌ ཨིན༌ནའང༌ ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ ལས༌ མ༌ཅོའ༌ ངལ༌ཚོས༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌ ཞག༌པོ༌ ཏམ༌པ༌ ཨིན༌ ཡང༌ ཏེ༌བོ༌ ཡ༌ཝའེ༌ ཕིའ༌ ཏང༌གོས༌། ཏེ༌ ཞག༌ག༌ ལས༌ ཅོ༌ཁན༌གུན༌ སད༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ཤབ༌བད༌དི༌ ཞག༌ག༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁང༌པའེ༌ ནང༌ང༌ མེ༌ ཏུག༌ མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","མོ༌ཟེས༌སི༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ལ༌ མོལས༌, “ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌བོ༌ འི༌གུན༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ཁྱོ༌ཞའ༌ ཡོད༌ཁན༌གུན༌ནི༌ ནང༌ནེ༌ ཁྱོ༌ཞའེ༌ ཡ༌ཝའེ༌ ཕིའ༌ ཆོད༌པ༌ ཕུལ༌། ཏང༌ང༌ ཐད༌ཁན༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཕིའ༌ སེར༌, མུལ༌, དང༌ ར༌གན༌ནི༌ ཆོད༌པ༌ ཁྱོང༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌, གྱལ༌ལ༌ ཀུས༌པོ༌ རས༌ དང༌ ར༌མའེ༌ བལ༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","རང༌ མར༌པོ༌ ཏང༌ཁན༌ནི༌ ལུག༌ཕོའེ༌ པགས༌པ༌ དང༌ ཀོའ༌ གྱལ༌ལ༌, ཨ༌ཀ༌ཤིའེ༌ ཤིང༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","འོད༌དི༌ ཕིའ༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌, ཁྲུས༌ཏང༌ཅེས༌སི༌ མར༌ནག༌ ཏང༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌སི༌ ཕིའ༌ ཚ༌མིག༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ཨེ༌ཕོད༌ དང༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌སི༌ཀ༌ ཏག༌ཅེས༌ལ༌ ཨོ༌ནེཀས༌ དང༌ ཞན༌ ཁྲ༌རྡོའ༌ རིན༌ཅན༌གུན༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“ཁྱོ༌ཞ༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ལག༌ཁས༌པ༌གུན༌ ཡོངས༌ཏེ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཅི༌ཚང༌མ༌ ཅོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ཏེ༌གུན༌ ཏམ༌པ༌ ཀུར༌, ཏེ༌བོའ༌ ཀབ༌ཅེས༌, ཏེ༌བོའེ༌ ལྕག༌ཀུག༌གུན༌ དང༌ རིབ༌ཞི༌གུན༌, པ༌ར༌ཁ༌ ཏང༌ཅེས༌སི༌ ཀྲ༌ལུ༌གུན༌, ཀ༌ཝ༌གུན༌ དང༌ ཏེ༌གུན༌ ལང༌ཅེས༌སི༌ ཞབ༌ལྡན༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ཆད༌དོན༌ནི༌ སྒམ༌ དང༌ ཏེ༌བོ༌ ཁུར༌ཅེས༌སི༌ ཀྲ༌ལུ༌གུན༌, ཐུག༌རྗེ༌ ཁའ༌ལེབ༌ ཡང༌ པར༌ ཕེ༌ཅེས༌ལ༌ ཡོ༌ལ༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ཅོག༌ཙེ༌, ཏེ༌བོ༌ ཁུར༌ཅེས༌སི༌ ཀྲ༌ལུ༌གུན༌ ཏང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ནོད༌ ཚང༌མ༌, དཀོན༌མཆོག༌ག༌ ཕུལ༌ཁན༌ནི༌ ཏམ༌པ༌ ཏ༌གི༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","འོད༌དི༌ ཕིའ༌ འོད༌སྟགས༌ ཡང༌ ཏེ༌བོའེ༌ ལག༌ཆ༌གུན༌, འོད༌གུན༌ དང༌ ཏེ༌གུན༌ནི༌ ཕིའ༌ མར༌ནག༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","སྤོས༌ དུག༌སའེ༌ ཆོད༌ཁྲི༌ ཡང༌ ཏེ༌བོ༌ ཁུར༌ཅེས༌སི༌ ཀྲ༌ལུ༌, ཁྲུས༌ཏང༌ཅེས༌སི༌ མར༌ནག༌, ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌, ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཞུག༌སའེ༌ སྒོའེ༌ ཕིའ༌ ཡོ༌ལ༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ཆོད༌པ༌ མེའ༌ སྲག༌ཅེས༌སི༌ ཕིའ༌ ཆོད༌ཁྲི༌, ཏེ༌བོའེ༌ ར༌གན༌ནི༌ ཀྲ༌མིག༌, ཏེ༌བོ༌ ཁུར༌ཅེས༌སི༌ ཀྲ༌ལུ༌ དང༌ ཏེ༌བོའེ༌ ལག༌ཆ༌ ཚང༌མ༌ ཡང༌ ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ དང༌ ཏེ༌བོ༌ བོར༌སའེ༌ ཕོས༌སྟག༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ནང༌སྐོར༌རི༌ ཕིའ༌ ཡོ༌ལ༌, ཏེ༌བོའེ༌ ཀ༌ཝ༌ དང༌ ཞབ༌ལྡན༌ གུན༌, ཏེ༌ནང༌ང༌ ཞུག༌སའེ༌ སྒོའེ༌ ཕིའ༌ ཡོ༌ལ༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ཏམ༌པའེ༌ ཀུར༌ དང༌ ནང༌སྐོར༌རི༌ ཕིའ༌ ཕུར༌ཅ༌གུན༌ དང༌ ཐག༌པ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ ཟ༌ནེ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ གོན༌ཅེས༌སི༌ ཀོས༌ལག༌ ཏམ༌པ༌ གུན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","མོ༌ཟེས༌སི༌ སྤེ༌ར༌ ཟེར༌ ཚར༌ར༌ཅིག༌, ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཁོའེ༌ དུན༌ནེ༌ སོང༌ ");
INSERT INTO lbj_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ཡང༌ སེམས༌སི༌ ཐིལ༌ནེ༌ ཐད༌ཁན༌གུན༌ནི༌ ཡ༌ཝའ༌ ཆོད༌པ༌ ཕུལས༌ ཡང༌ན༌ ཏམ༌པ༌ ཀུར༌, ཏེ༌ནང༌ང༌ སྒོས༌དོམ༌ ཡོད༌ཁན༌ དང༌ བླ༌མ༌གུན༌ནི༌ ཏམ༌པ༌ ཀོས༌ལག༌, ཏེ༌ ཚང༌མ༌ ཅོ༌ཅེས༌སི༌ ཕིའ༌ ཆོད༌པ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ཏང༌ང༌ ཐད༌ཁན༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཚང༌མའེ༌ སེར༌རི༌ གྱན༌ཆ༌ སྣ༌ཚོགས༌; ནམ༌ཅོག༌གི༌ ཨ༌ལི༌, སྐྱེ༌ཆ༌, སེར༌དུབ༌, ཀྲང༌ངི༌ཀ༌ ཏག༌ཅེས༌ དང༌ ཞན༌གུན༌ ཁྱོངས༌། ཁོང༌གུན༌ནི༌ རང༌ངི༌ སེར༌གུན༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ལན༌ ཁ༌ཅིག༌ སྟགས༌ ཡང༌ ཕབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","སྔོན༌པོ༌, ཡ༌ སྔོ༌མར༌ ཡ༌ མར༌པོ༌ ནས༌མ༌ ཡ༌ ཀུས༌པོ༌ རས༌ ཡ༌ ར༌མའེ༌ སྤུ༌ ཡ༌ རང༌ མར༌པོ༌ ཏང༌ཁན༌ ལུག༌ཕོའེ༌ པགས༌པ༌ ཡ༌ ཀོའ༌ གྱལ༌ལ༌ ཡོད༌ཁན༌གུན༌ནི༌ ཏེ༌གུན༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ཏང༌ ཉན༌ཁན༌གུན༌ནི༌ མུལ༌ ཡ༌ ར༌གན༌ནི༌ ཆོད༌པ༌ ཡ༌ཝའ༌ ཕུལས༌, ཡང༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ ཡོད༌ཁན༌གུན༌ནི༌ ཏེ༌གུན༌ ཏེ༌ ལས༌སི༌ ནང༌ང༌ ཀོལ༌ཅེས༌ལ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ལག༌ཤེས༌ ཁས༌པ༌ བུ༌མོ༌གུན༌ནི༌ རས༌ ཐགས༌ཁན༌ ཀུས༌པོ༌ ཡང༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཁལ༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ཁས༌པ༌ ཡང༌ སྙིང༌ནེ༌ ཅོའ༌ལ༌ ཐད༌ཁན༌ བུ༌མོ༌གུན༌ནི༌ ར༌མའེ༌ སྤུ༌ ཁལ༌ཏེ༌ ནས༌མ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","སྤོན༌བོ༌གུན༌ནི༌ ཨོ༌ནེཀས༌ དང༌ ཞན༌ ཁྲ༌རྡོའ༌ གུན༌ ཨེ༌ཕོད༌ དང༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌སི༌ཀ༌ ཅུག༌ཅེས༌ལ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ཁོང༌གུན༌ནི༌ འོད༌, ཁྲུས༌ཏང༌ཅེས༌ དང༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌སི༌ ཕིའ༌ ཨོ༌ལིཝ༌ཝི༌ མར༌ནག༌ དང༌ ཚ༌མིག༌གུན༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ཡ༌ཝའེ༌ མོ༌ཟེས༌ གྱུད༌ཏེ༌ བཀའ༌ སལ༌ཁན༌ནི༌ ལས༌གུན༌ ཅོ༌ཅེས༌སི༌ ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ རང༌རང༌ ཐད༌ཁན༌ནི༌ ཆོད༌པ༌ ཐད༌པོ༌ ཉམ༌པོ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ཏེ༌ནེ༌ མོ༌ཟེས༌སི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེརས༌, “ཡ༌ཝའེ༌ ཡ༌ཧུ༌དཱའེ༌ སྡེ༌ ནང༌ནེ༌ ཨུ༌རི༌ བུ༌ཚ༌, ཧུར༌རི༌ ཚ༌འོ༌ བེ༌ཟ༌ལེལ༌ ལྡམ༌མ༌ ཛདས༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ཡང༌ དཀོན༌མཆོག༌གི༌ ཁོའེ༌ ནང༌ང༌ ཁོང༌རང༌ངི༌ ཐུག༌ཉིད༌ སྐང༌ང༌ ཛད༌ཏེ༌ ཁོའ༌ ཟོ༌ལས༌ ཚང༌མའེ༌ ནང༌ང༌ ཁས༌པ༌, རིག༌པ༌ དང༌ ཁྱུད༌ སལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ཏེ༌གུན༌ སེར༌, མུལ༌ དང༌ ར༌གན༌ ཉམ༌པོ༌ ཁས༌པ༌ རི༌མོ༌ སྲུལ༌ཅེས༌, ");
INSERT INTO lbj_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ཁྲ༌རྡོའ༌ ཅད༌ཅེས༌, ཤིང༌ སྐོས༌ཏང༌ཅེས༌ ཡང༌ ཟོ༌ལས༌སི༌ ལས༌ སྣ༌ཚོགས༌ ཅོ༌ཅེས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ཡ༌ཝའེ༌ ཁོ༌ དང༌ དཱན༌ནི༌ སྡེ༌ ནང༌ནེ༌ ཨ༌ཧི༌ས༌མག༌གི༌ བུ༌ཚ༌ ཨོ༌ཧོ༌ལིའབ༌ ཉིས༌ཀོའ༌, ཞན༌ཡང༌ ཟོ༌ལས༌པ༌གུན༌ལ༌ ལབ༌ཅེས༌སི༌ ཁྱུད༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ཡ༌ཝའེ༌ ཁོང༌གུན༌ལ༌, ཟོ༌ལས༌ སྣ༌ཚོགས༌ ཅོ༌ཁན༌, རི༌མོ༌ སྲུལ༌ཁན༌, ཀུས༌པོ༌ རས༌སི༌ཀ༌ ནས༌མ༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ཉམ༌པོ༌ རི༌མོ༌ སྲུལ༌ཁན༌ ཡང༌ ཐགས༌ཐག༌ཁན༌ གུན༌ནི༌ ཅོ༌ཁན༌ནི༌ ལས༌ རིགས༌ ཚང༌མ༌ ཅོ༌ཅེས༌སི༌ ཁྱུད༌ སལས༌། ཁོང༌ ཉིས༌ཀོ༌ ཟོ༌ལས༌ དང༌ རི༌མོ༌ སྲུལ༌ཅེས༌སི༌ ནང༌ང༌ མ༌ ཁས༌པ༌ ཡོད༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","མོ༌ཟེས༌སི༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཡ༌ཝའེ༌ བེ༌ཟ༌ལེལ༌, ཨོ༌ཧོ༌ལིའབ༌ དང༌ ཞན༌ ཟོ༌ལས༌པ༌གུན༌ལ༌ ཏམ༌པའེ༌ ཀུར༌ ཅོ༌ཅེས༌སི༌ ནང༌ང༌ སྒོས༌དོམ༌མི༌ ལས༌གུན༌ ཅོ༌ཅེས༌ལ༌ ཧ༌གོ༌ དང༌ ཁྱུད༌ སལ༌ཏེ༌ ཨིན༌ནོག༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝའེ༌ བཀའ༌ ནང༌ཞིན༌ ལས༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","མོ༌ཟེས༌སི༌ བེ༌ཟ༌ལེལ༌ དང༌ ཨོ༌ཧོ༌ལིའབ༌ ཡང༌ ཡ༌ཝའེ༌ ཁྱུད༌ སལ༌ཏེ༌ ལས༌ ཅོའ༌ལ༌ ཐད༌པོ༌ ཡོད༌ཁན༌ ཚང༌མ༌ལ༌ བོད༌ཏེ༌ ལས༌ གོ༌ཟུག༌ ཅོ༌ཅེས༌སི༌ ཕིའ༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ཏམ༌པའེ༌ ཀུར༌ ཅོ༌ཅེས༌སི༌ ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁྱོངས༌ཁན༌ནི༌ ཆོད༌པ༌ ཚང༌མ༌ མོ༌ཟེས༌སི༌ ཀ༌ནེ༌ ཁོང༌གུན༌ནི༌ ལེནས༌། མི༌གུན༌ནི༌ ཆད༌མ༌ཅུག༌ག༌ ཞག༌ཏང༌ ང༌མོ༌ ཆོད༌པ༌གུན༌ ཕུལ༌ཅེས༌ལ༌ ཁྱོང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ཏེ༌ནེ༌ ཟོ༌ལས༌སི༌ ལས༌ སྣ༌ཚོགས༌ ཅོ༌ཨིན༌ ཡོད༌ཁན༌ནི༌ ཁས༌པ༌ མི༌ ཚང༌མ༌ སོང༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","མོ༌ཟེས༌ལ༌ ཟེརས༌, “ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ནི༌ ལས༌སི༌ ནང༌ང༌ སྒོས༌དོམ༌ ཡོད༌ཁན༌ནི༌ སང༌ མང༌ང༌ མི༌གུན༌ནི༌ ཁྱོང༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ཏེ༌བོའེ༌ཕིའ༌ མོ༌ཟེས༌སི༌ མི༌ཚང༌མ༌ལ༌ ལོན༌ ཀལ༌ཏེ༌ ཟེརས༌, “བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ཕིའ༌ ཆོད༌པ༌ མ༌ཁྱོང༌ཤིག༌།” ཏེ༌ནེ༌ མི༌གུན༌ལ༌ ཆོད༌པ༌ ཁྱོང༌ ཚར༌ཁན༌བོའེ༌སང༌ མང༌ང༌ ཁྱོང༌ མ༌ཅུགས༌, ");
INSERT INTO lbj_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ཅིའ༌ཟེར༌ན༌ ཁྱོང༌ཚར༌ཁན༌ནི༌ ཆོད༌པ༌གུན༌, ལས༌ ཚང༌མ༌ ཅོ༌ཅེས༌ལ༌ སྒོས༌དོམ༌ ཡོད༌ཁན༌ནི༌ སང༌ མང༌ང༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ཟོ༌ལས༌ལ༌ ཁས༌པ༌ ཚང༌མའེ༌ ཏམ༌པའེ༌ ཀུར༌བོ༌ ཐགས༌ཁན༌ནི༌ རས༌ ཀུས༌པོའེ༌ཀ༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཉམ༌པོ༌ ཆེ༌ར༌བེམ༌མི༌ པར༌ སྲུལ༌ཏེ༌ ཡོ༌ལ༌ 10 ཉམ༌པོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ཏེ༌ ཡོ༌ལ༌ ཚང༌མ༌ དྲན༌དྲ༌, རིང༌བོ༌ མི༌ཀྲར༌ 12 ཡང༌ ཞང༌བོ༌ མི༌ཀྲར༌ 2 ཟམ༌ཤིག༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ཁོང༌གུན༌ནི༌ ཡོ༌ལ༌ ལྔ༌བོ༌ ཙེམས༌ཏེ༌ ཆའ༌ཅིག༌ ཅོས༌, ཏེན༌ན༌ ཙོགས༌ ཞན༌ ལྔ༌བོ༌ ཉམ༌པོའང༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ཁོང༌གུན༌ནི༌ ཡོ༌ལའེ༌ ཆ༌ ཉིས༌ཀོའེ༌ ཟུར༌གུན༌ནི༌ཀ༌ རས༌ སྔོན༌པོའེ༌ གུག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ཡོ༌ལའེ༌ ཆ༌ ཅིག༌པོའེ༌ཀ༌ གུག༌ ལྔབ༌ཅུ༌, ཡང༌ ཞན༌ ཆ༌ ཅིག༌པོའེ༌ཀའང༌ གུག༌ ལྔབ༌ཅུ༌ ཅོས༌། གུག༌གུན༌ ཅིག༌ དང༌ ཅིག༌ག༌ ལྟས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ཁོང༌གུན༌ནི༌ སེར༌ཀུག༌ ལྔབ༌ཅུ༌ ཅོས༌ཏེ༌ ཡོ༌ལའེ༌ ཆ༌ ཉིས༌ཀོ༌ ཐུད༌ཅེས༌སི༌ ཕིའ༌ ཀོལས༌། ཏེན༌ན༌ཟུག༌གི༌ ཀུར༌བོ༌ ཁག༌ཅིག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཏམ༌པའེ༌ ཀུར༌ལ༌ ཀབ༌ཅེས༌ ར༌མའེ༌ སྤུའེ༌ ཡོ༌ལ༌ ཅུག༌ཤིག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ཏེ༌ ཚང༌མ༌ དྲན༌དྲ༌, རིང༌བོ༌ མི༌ཀྲར༌ 13.5 ཡང༌ ཞང༌བོ༌ མི༌ཀྲར༌ 2 ཟམ༌ཤིག༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ཁོང༌གུན༌ནི༌ ཏེ༌ ལྔ༌བོ༌ ཙེམས༌ཏེ༌ ཆའ༌ཅིག༌ ཅོས༌། ཏེན༌ན༌ ཙོགས༌ ཞན༌ དྲུག༌པོ༌ ཙེམས༌ཏེ༌ ཆའ༌ཅིག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ཁོང༌གུན༌ནི༌ ཆ༌ ཅིག༌གི༌ ཟུར༌རི༌ཀ༌ གུག༌ ལྔབ༌ཅུ༌ ཡང༌ ཆ༌ ཅིག༌པོའེ༌ ཟུར༌རི༌ཀའང༌ གུག༌ ལྔབ༌ཅུ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ཁོང༌གུན༌ནི༌ ཏེ༌ ཆ༌ ཉིས༌ཀོ༌ ཐུད༌ཅེས༌སི༌ ཕིའ༌ ར༌གན༌ནི༌ ཀུག༌ཀུག༌ ལྔབ༌ཅུ༌ ཅོས༌, ཏེན༌ན༌ཟུག༌གི༌ ཀབ༌ཅེས༌པོ༌ ཁག༌ཅིག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ཁོང༌གུན༌ནི༌ ཀུར༌ལ༌ ཀབ༌ཅེས༌པོ༌ ལུག༌ཕོའེ༌ པགས༌པ༌ རང༌ མར༌པོ༌ ཏང༌ཁན༌ ཉམ༌པོ༌ ཡང༌ ཏེ༌བོའེ༌ ཁེ༌ཐོག༌ག༌ ཞན༌ ཀབ༌ཅེས༌ཤིག༌ སེམས༌ཅན༌ནི༌ གྱལ༌ལ༌ པགས༌པའ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ཁོང༌གུན༌ནི༌ ཏམ༌པའེ༌ ཀུར༌ ལང༌ཅེས༌ལ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ རིབ༌ཞི༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","རིབ༌ཞི༌ རེ༌རེ༌ རིང༌བོ༌ མི༌ཀྲར༌ 4.5 ཡང༌ ཞང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 66 ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","རིབ༌ཞི༌ རེ༌རེའེ༌ ཁད༌ཅེས༌ལ༌ ཇུག༌པོ༌ ཞོགས༌ཏེ༌ ཟེར༌ ཙོགས༌ ཉིས༌ ཅོས༌། ཏམ༌པ༌ ཀུར༌རི༌ རིབ༌ཞི༌ ཚང༌མ༌ ཙོགས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ཁོང༌གུན༌ནི༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ལྷོ༌ ཆོགས༌སི༌ ཕིའ༌ རིབ༌ཞི༌ ཉི༌ཤུ༌ ཅོས༌ ");
INSERT INTO lbj_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ཡང༌ ཏེ༌གུན༌ ལང༌ཅེས༌ལ༌ མུལ༌ལི༌ ཞབ༌ལྡན༌ ཞིབ༌ཅུ༌, རིབ༌ཞི༌ ཅིག༌ག༌ ཞབ༌ལྡན༌ ཉིས༌, ཟེར༌ ཅིག༌གི༌ ཡོག༌ག༌ ཞབ༌ལྡན༌ ཅིག༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ཁོང༌གུན༌ནི༌ ཏམ༌པའེ༌ ཀུར༌རི༌ བྱང༌ ཆོགས༌ལ༌ རིབ༌ཞི༌ ཉི༌ཤུ༌ ");
INSERT INTO lbj_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ཡང༌ མུལ༌ལི༌ ཞབ༌ལྡན༌ ཞིབ༌ཅུ༌ ཅོས༌, རིབ༌ཞི༌ རེ༌རེའེ༌ ཡོག༌ག༌ ཞབ༌ལྡན༌ ཉིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ཏམ༌པའེ༌ ཀུར༌རི༌ གྱབ༌, ནུབ༌ ཆོགས༌ལ༌ ཁོང༌གུན༌ནི༌ རིབ༌ཞི༌ དྲུག༌ ཅོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ཡང༌ རིབ༌ཞི༌ ཐེ༌བ༌ ཉིས༌ ཏམ༌པའེ༌ ཀུར༌རི༌ གྱབ༌བི༌ ཀྲུ༌གུན༌ནི༌ ཕིའ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ཀྲུའི༌ རིབ༌ཞི༌གུན༌ ཡོག༌ནེ༌ བེ༌ཏེ༌ ཨིན༌ནའང༌ ཁེ༌ཐོག༌པོ༌ སེར༌རི༌ ཀྱི༌ལྡིར༌ ཉམ༌པོ༌ ཐུདས༌, ཏེ༌ རིབ༌ཞིའི༌ ཉིས༌ཀོ༌ ཙོགས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ཏ༌ རིབ༌ཞི༌ 8 ཡང༌ མུལ༌ལི༌ ཞབ༌ལྡན༌ 16 ཡོད༌པིན༌, རིབ༌ཞི༌ རེ༌རེའེ༌ ཡོག༌ག༌ ཞབ༌ལྡན༌ ཉིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ཁོང༌གུན༌ནི༌ པ༌ར༌ཁ༌ ཏང༌ཅེས༌གུན༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཅོས༌, ཏམ༌པའེ༌ ཀུར༌རི༌ འི༌ངོ༌ ཆོགས༌སི༌ རིབ༌ཞི༌ ཕིའ༌ ལྔ༌, ");
INSERT INTO lbj_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","འ༌ངོ༌ ཆོགས༌སི༌ རིབ༌ཞི༌ ཕིའ༌ ལྔ༌ ཡང༌ ཏམ༌པ༌ ཀུར༌རི༌ གྱབ༌ ནུབ༌ ཆོགས༌སི༌ རིབ༌ཞི༌ ཕིའ༌ ལྔ༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ཞུང༌སྐྱིལ༌ལི༌ པར༌ཁའེ༌ ཀྲ༌ལུ༌བོ༌ ཀུར༌རི༌ གོ༌ནེ༌ ཇུག༌ ཚག༌པ༌ ལེབ༌ཅེས༌ ཅོས༌ ཀ༌བོ༌ རིབ༌ཞི༌ ཞུང༌སྐྱིལ༌ལི༌ཀ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ཁོང༌གུན༌ནི༌ རིབ༌ཞི༌གུན༌ སེར༌རི༌ ཏུམས༌ ཡང༌ ཏེ༌གུན༌ནི༌ཀ༌ པ༌ར༌ཁ༌ ཏང༌ཅེས༌སི༌ ཤིང༌གུན༌ གྱུད༌ཅེས༌ལ༌ སེར༌རི༌ ཀྱི༌ལྡིར༌ ཅོས༌། པ༌ར༌ཁ༌ ཏང༌ཅེས༌སི༌ ཤིང༌གུན༌ནའང༌ སེར༌རི༌ ཏུམས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ཁོང༌གུན༌ནི༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཡང༌ རས༌ ཐགས༌ཁན༌ ཀུས༌པོའེ༌ ཡོ༌ལ༌ ཅོས༌ ཀ༌བོའེ༌ཀ༌ ལག༌ཤེས༌ ཁས༌པ༌གུན༌ནི༌ ཆེ༌ར༌བེམ༌མི༌ པར༌ སྲུལ༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ཁོང༌གུན༌ནི༌ ཡོ༌ལའེ༌ ཕིའ༌ སེར༌ཀུག༌ དང༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཀ༌ཝ༌ ཞི༌ ཅོས༌ཏེ༌ སེར༌རི༌ ཏུམས༌ ཡང༌ ཏེ༌གུན༌ ལང༌ཅེས༌ལ༌ མུལ༌ལི༌ ཞབ༌ལྡན༌ ཞི༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ཀུར༌རི༌ ནང༌ང༌ ཆ༌ཅེས༌སི༌ སྒོའ༌ ཡོ༌ལ༌ རས༌ ཐགས༌ཁན༌ ཀུས༌པོའེ༌ཀ༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མའེ༌ རི༌མོ༌ སྲུལ༌ཏེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ཏེ༌བོའེ༌ ཕིའ༌ ཀ༌ཝ༌ ལྔ༌ དང༌ ཏེ༌གུན༌ནི༌ ལྕག༌ཀུག༌གུན༌ ཅོས༌ ཡང༌ ཏེ༌ ཀ༌ཝ༌གུན༌ནི༌ ཁེ༌ཐོག༌པོ༌ དང༌ ཏེ༌གུན༌ནི༌ ཀྱི༌ལྡིར༌གུན༌ སེར༌རི༌ ལྡུམ༌ ཨང༌ ཏེ༌གུན༌ ལང༌ཅེས༌ལ༌ ར༌གན༌ནི༌ ཞབ༌ལྡན༌ ལྔ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","བེ༌ཟ༌ལེལ༌ལི༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ང༌ ཆད༌དོན༌ནི༌ སྒམ༌བོ༌ ཅོས༌ ཀ༌བོའེ༌ རིང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 110, ཞང༌ དང༌ ཐོན༌ དྲན༌དྲའ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 66 ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ཁོའེ༌ ཏེ༌བོའེ༌ ནང༌ཀུག༌ དང༌ ཕི༌ལོག༌ ཉིས༌ཀོ༌ སེར༌རི༌ ཏུམས༌ ཡང༌ ཕི༌ལོག༌གི༌ ཟུར༌ལ༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ཁོའེ༌ སེར༌རི༌ ཀྱི༌ལྡིར༌ ཞི༌ ཅོས༌ ཡང༌ ཏེ༌གུན༌ ཏེ༌བོའེ༌ རྐང༌ ཞི༌ཀོའེ༌ཀ༌ ཏགས༌, ཆོག༌ རེ༌རེ༌ཀ༌ ཀྱི༌ལྡིར༌ ཉིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ཁོའེ༌ སྒམ༌བོ༌ ཁུར༌ཅེས༌ལ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཀྲ༌ལུའ༌ སེར༌ ཏུམས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ཏེ༌བོའེ༌ ལྡ༌ལྡོ༌ ཉིས༌ཀོའ༌ ཡོད༌ཁན༌ནི༌ ཀྱི༌ལྡིར༌གུན༌ནི༌ ནང༌ང༌ ཏེ༌གུན༌ གྱུད༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ཁོའེ༌ ཏེ༌ སྒམ༌མ༌ མི༌གུན༌ནི༌ སྡིག༌པའ༌ ཤགས༌པ༌ སལ༌ཁན༌ སེར༌རི༌ ཁའ༌ལེབ༌ ཅོས༌, ཏེ༌བོའེ༌ རིང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 110 ཡང༌ ཞང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 66 ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ཁོའེ༌ ཏེ༌བོའེ༌ ཐའ༌མ༌ ཉིས༌ཀོའ༌ སེར༌ རྡུངས༌ཏེ༌ ཆེ༌ར༌བེམ༌ ཉིས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","འི༌ངོ༌ ཆོགས༌སི༌ ཐའ༌མ༌ ཅིག༌ ཡང༌ འ༌ངོ༌ ཆོགས༌སི༌ ཐའ༌མ༌ ཅིག༌, ཏེ༌གུན༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌ ཉམ༌པོ༌ ཐུད༌ཏེ༌ སེར༌ ཅིག༌ཅིག༌ག༌ ཅོས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ཆེ༌ར༌བེམ༌གུན༌ནི༌ ཤོག༌པ༌ ཀེན༌ལ༌ རྐྱངས༌ཏེ༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌པོ༌ ཀབས༌ཏེ༌ ཡོད༌པིན༌། ཏེ༌གུན༌ ཅིག༌ དང༌ ཅིག༌ག༌ ལྟས༌ཏེ༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌ ཆོགས༌ལ༌ གོ༌ སྒུས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","བེ༌ཟ༌ལེལ༌ལི༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཅོག༌ཙེ༌ ཅོས༌ ཀ༌བོའེ༌ རིང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 88, ཞང༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 44 དང༌ ཐོན༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 66 ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ཁོའེ༌ ཏེ༌བོ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ ཉམ༌པོ༌ ཏུམས༌ ཡང༌ ཐའ༌མ༌ གུན༌ལ༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ཏེ༌བོའ༌ ཀིར༌ སྐོར༌ཏེ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 7 ཞང༌ངི༌ སྐྱོར༌ར༌ ཏངས༌ ཡང༌ ཏེ༌བོའེ༌ ཐའ༌མ༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","སེར༌རི༌ ཀྱི༌ལྡིར༌ ཞི༌ ཅོས༌ ཡང༌ ཏེ༌གུན༌ ཀྲུ༌ ཞི༌ཀོའེ༌ རྐང༌ངི༌ཀ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ཅོག༌ཙེ༌ ཁུར༌ཅེས༌སི༌ ཀྲ༌ལུ༌གུན༌ གྱུད༌ཅེས༌ལ༌ ཀྱི༌ལྡིར༌གུན༌ ཏེ༌བོའེ༌ ཐོག༌གི༌ ཟུར༌རི༌ དུན༌ལ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ཀྲ༌ལུ༌གུན༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ང༌ སེར༌ ཏུམས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ཅོག༌ཙེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌གུན༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ལ༌ ཅོས༌། ཏེ༌གུན༌ ཐལ༌ལི༌, ཀོ༌རེ༌, སྒོར༌མོ༌ ཡང༌ རྒུན༌ཆང༌ངི༌ ཆོད༌པ༌ ལུག༌ཅེས༌སི༌ ནོད༌ གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ཁོའེ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ སེར༌རི༌ འོད༌སྟགས༌ ཅོས༌, ཏེ༌བོའེ༌ ཞབ༌ལྡན༌, རྐང༌གུན༌, མེན༌ཏོག༌ ཙོགས༌ ཀོ༌རེ༌གུན༌, པ༌ཏུམ༌ དང༌ མེན༌ཏོག༌ བར༌ཁན༌ གུན༌ སེར༌ ཅིག༌ཅིག༌ རྡུངས༌ཏེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ཏེ༌བོའ༌ རྐང༌ དྲུག༌ ཅོས༌, ལྡོ༌ རེ༌རེའ༌ རྐང༌ སུམ༌སུམ༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","རྐང༌ རེ༌རེ༌ཀ༌ བ༌དམ༌མི༌ མེན༌ཏོག༌ བར༌ཁན༌ ཙོགས༌ སུམ༌སུམ༌ ཡང༌ པ༌ཏུམ༌ དང༌ ཏེ༌བོ༌ ཀབས༌ཁན༌ནི༌ ལོ༌མ༌ གུན༌ ཅོས༌། ཏེན༌ན༌ ཙོགས༌ འོད༌སྟག༌གི༌ རྐང༌ དྲུག༌པོའེ༌ཀ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","འོད༌སྟག༌གི༌ ཞུང༌སྐྱིལ༌ལི༌ རྐང༌ངི༌ཀ༌ བ༌དམ༌མི༌ མེ༌ཏོག༌ བར༌ཁན༌ ཙོགས༌ ཞི༌ ཡང༌ པ༌ཏུམ༌ དང༌ ཏེ༌བོ༌ ཀབས༌ཁན༌ནི༌ ལོ༌མ༌ གུན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ཞུང༌ངི༌ རྐང༌ངི༌ཀ༌ ཞན༌ རྐང༌ ཆ༌ སུམ༌ཀོ༌ ཐུད༌ཏེ༌ ཡོད༌ས༌ རེ༌རེ༌ ཡོག༌ག༌ པ༌ཏུམ༌ ཅོས༌, ཏེ༌ ཚང༌མ༌ ཁོའེ༌ སེར༌ ཅིག༌ རྡུངས༌ཏེ༌ ཅོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","པ༌ཏུམ༌ དང༌ རྐང༌ ཚང༌མ༌ འོད༌སྟགས༌ ཉམ༌པོ༌ སེར༌ ཅིག༌ཅིག༌ རྡུངས༌ཏེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ཁོའེ༌ འོད༌སྟག༌གི༌ ཕིའ༌ མར༌ནག༌ སྐང༌ཅེས༌ལ༌ ཀོ༌རེ༌ རྡུན༌, སར༌ ཀྲུམ༌ཅེས༌ དང༌ ཏེ༌བོའེ༌ ཏ༌བག༌ ཚང༌མ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","འོད༌སྟགས༌ དང༌ ཏེ༌བོའེ༌ ལག༌ཆ༌ ཚང༌མ༌ ཅོ༌ཅེས༌ལ༌ ཁོའེ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ ཀི༌ལོ༌ 35 ཀོལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ཁོའེ༌ སྤོས༌ ཏུག༌ཅེས༌སི༌ ཕིའ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཆོད༌ཁྲི༌ ཅོས༌། ཐོན༌བོ༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 90 ཡང༌ ཏེ༌བོའེ༌ ཐོག༌པོ༌ ཀྲུབ༌ཞི༌, རིང༌ དང༌ ཞང༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 45 ཡོད༌པིན༌། ཀྲུ༌ ཞི༌ཀོ༌ ཙེབ༌ཙེབ༌ ར༌ཅོ༌ ཙོགས༌, ཆོད༌ཁྲི༌ ཉམ༌པོ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ ཅིག༌ཅིག༌ག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ཁོའེ༌ ཆོད༌ཁྲི༌ གང༌པོ༌ ཡང༌ན༌ ཏེ༌བོའེ༌ ཐོག༌, ཆོག༌ ཞི༌ཀོ༌ དང༌ རཱ༌ཅོ༌ གུན༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ ཉམ༌པོ༌ ཏུམས༌ ཡང༌ ཏེ༌བོའེ༌ ཐའ༌མ༌ ཀྱིར༌སྐོར༌ཏེ༌ སེར༌རི༌ ཐའ༌རིལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ཟུར༌རི༌ ཡོག༌ག༌ ཆོགས༌ ཉིས༌ཀོའེ༌ཀ༌ སེར༌རི༌ ཀྱི༌ལྡིར༌ ཉིས༌ཉིས༌ ཏེ༌བོ༌ ཁུར༌ཅེས༌སི༌ ཀྲ༌ལུ༌གུན༌ གྱུད༌ཅེས༌ལ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ཁོའེ༌ ཀྲ༌ལུ༌གུན༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ང༌ ཅོས༌ཏེ༌ སེར༌ ཏུམས༌། ");
INSERT INTO lbj_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ཏྲི༌ཞིམ༌ ཅོ༌ཁན༌ནི༌ ལས༌ ཙོགས༌, ཁོང༌གུན༌ནི༌ ཁྲུས༌ཏང༌ཅེས༌སི༌ མར༌ནག༌ ཡང༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌ གུན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","བེ༌ཟ༌ལེལ༌ དང༌ ཁོའ༌ ཡ༌ཏོ༌ ཅོ༌ཁན༌གུན༌ནི༌ ཆོད༌པ༌ མེའ༌ སྲག༌ཅེས༌སི༌ ཕིའ༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ངི༌ ཆོད༌ཁྲི༌ ཅོས༌། ཏེ༌བོ༌ ཀྲུབ༌ཞི༌, ལྡོ༌ རེ༌རེ༌ ཞང༌ མི༌ཀྲར༌ 2 དང༌ ཐོན༌བོ༌ མི༌ཀྲར༌ 1.5 ཟམ༌ཤིག༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ཁོང༌གུན༌ནི༌ ཀྲུ༌ ཞི༌ཀོ༌ ཙེབ༌ཙེབ༌ ར༌ཅོ༌ ཙོགས༌ ཅོས༌། ཆོད༌ཁྲི༌ དང༌ ར༌ཅོ༌ གུན༌ ཤིང༌ཅིག༌ག༌ ཅོས༌ ཡང༌ ཆོད༌ཁྲི༌ གང༌པོའ༌ ར༌གན༌ ཏུམས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ཆོད༌ཁྲི༌ཀ༌ ཀོལ༌ཁན༌ནི༌ ཅ༌ལག༌: ཀོག༌ཐལ༌ གྱང༌ཅེས༌སི༌ ནོད༌གུན༌, ཁྱེམ༌གུན༌, ཐོར༌མ༌ ཏང༌ཅེས༌སི༌ སྒོར༌མོ༌གུན༌, ཤ༌ ལོག༌ཅེས༌སི༌ མེ༌ལེན༌གུན༌ ཡང༌ མེ༌ ཕིང༌ཅེས༌སི༌ ཏ༌འོ༌གུན༌ ར༌གན༌ནི༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ཁོའེ༌ ར༌གན༌ནི༌ ཀྲ༌མིག༌ ཅོས༌ཏེ༌ ཏེ༌བོ༌ ཆོད༌ཁྲིའི༌ ནང༌ཀུག༌ག༌ ཕེད༌ ཟོད༌ ཅིག༌ག༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ཏེ༌བོ༌ ཁུར༌ཅེས༌སི༌ ཀྲ༌ལུ༌གུན༌ གྱུད༌ཅེས༌ལ༌ ཁོའེ༌ ར༌གན༌ནི༌ ཀྱི༌ལྡིར༌ ཞི༌ ཅོས༌ཏེ༌ ཀྲ༌མིག༌གི༌ ཀྲུ༌ ཞི༌ཀོའེ༌ཀ༌ ཕི༌ལོག༌ ཆོགས༌ལ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ཏེ༌གུན༌ ཨ༌ཀ༌ཤིའེ༌ ཤིང༌ང༌ ཀྲ༌ལུ༌ ར༌གན༌ ཏུམས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ཆོད༌ཁྲི༌ ཁུར༌ཅེས༌ལ༌ ཀྲ༌ལུ༌གུན༌ ཀྱི༌ལྡིར༌གུན༌ནི༌ ནང༌ང༌ གྱུདས༌, ཆོད༌ཁྲི༌བོ༌ སྤང༌ལེབ༌བ༌ ཅོས༌ཏེ༌ ཁོག༌སྟོང༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ཡ༌ཝ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ ལས༌ ཅོ༌ཁན༌ བུ༌མོ༌གུན༌ནི༌ ར༌གན༌ནི༌ མེ༌ལོང༌ ཕུལ༌ཁན༌གུན༌ ཉམ༌པོ༌ བེ༌ཟ༌ལེལ༌ལི༌ ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ དང༌ ཏེ༌བོ༌ བོར༌ཅེས༌པོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ཏེ༌ནེ༌ བེ༌ཟ༌ལེལ༌ དང༌ ཁོའ༌ ཡ༌ཏོ༌ ཅོ༌ཁན༌གུན༌ནི༌ ཀུར༌རི༌ ནང༌སྐོར༌རི༌ ཕིའ༌ ཀུས༌པོ༌ ཐགས༌ཁན༌ནི༌ ཡོ༌ལ༌ ཅོས༌། ལྷོ༌ ཆོགས༌སི༌ ཡོ༌ལ༌ མི༌ཀྲར༌ 46 རིང༌མོ༌ ཡོད༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ཏེ༌གུན༌ ཅར༌ཅེས༌ལ༌ ར༌གན༌ནི༌ ཀ༌ཝ༌ ཉི༌ཤུ༌ དང༌ ཞབ༌ལྡན༌ ཉི༌ཤུ༌ ཡང༌ མུལ༌ཀུག༌གུན༌ དང༌ མུལ༌ལི༌ ཀྱི༌ལྡིར༌གུན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","བྱང༌ ཆོགས༌སི༌ ཕིའང༌ ཏེན༌ན༌ ཙོགས༌ ཡོ༌ལ༌ མི༌ཀྲར༌ 46 རིང༌མོ༌, ར༌གན༌ནི༌ ཀ༌ཝ༌ ཉི༌ཤུ༌ དང༌ ཞབ༌ལྡན༌ ཉི༌ཤུ༌ ཡང༌ མུལ༌ལི༌ ཀུག༌ཀུག༌གུན༌ དང༌ ཀྱི༌ལྡིར༌གུན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ཁོང༌གུན༌ནི༌ ནུབ༌ ཆོགས༌སི༌ ཡོ༌ལ༌ མི༌ཀྲར༌ 23 རིང༌མོ༌, ཀ༌ཝ༌ རྕུ༌ དང༌ ཞབ༌ལྡན༌ རྕུ༌ ཡང༌ ཀ༌ཝ༌གུན༌ནི༌ཀ༌ མུལ༌ཀུག༌ དང༌ མུལ༌ལི༌ ཀྱི༌ལྡིར༌གུན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","དུན༌ ཡང༌ན༌ ཤར༌ ཆོགས༌སི༌ ཡོ༌ལ༌ མི༌ཀྲར༌ 22 རིང༌མོ༌ ཡང༌ ནང༌ཀུག༌ག༌ ཞུག༌སའེ༌ སྒོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","སྒོའེ༌ ཡས༌ ཆོགས༌སི༌ ཡོ༌ལ༌ མི༌ཀྲར༌ 6.5 ཟམ༌ཤིག༌ རིང༌མོ༌ ཡང༌ ཀ༌ཝ༌ སུམ༌ དང༌ ཞབ༌ལྡན༌ སུམ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","སྒོའེ༌ ཡོ༌མ༌ ཆོགས༌སི༌ ཡོ༌ལ༌ མི༌ཀྲར༌ 6.5 ཟམ༌ཤིག༌ རིང༌མོ༌ ཡང༌ ཀ༌ཝ༌ སུམ༌ དང༌ ཞབ༌ལྡན༌ སུམ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ནང༌སྐོར༌རི༌ ཡོ༌ལ༌ ཚང༌མ༌ ཐགས༌ཁན༌ནི༌ རས༌ རིན༌ཅན༌ལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ཀ༌ཝ༌ ལང༌ཅེས༌སི༌ ཞབ༌ལྡན༌གུན༌ ར༌གན༌ལ༌ ཡང༌ ཀ༌ཝ༌གུན༌ནི༌ ལྕག༌ཀུག༌གུན༌ དང༌ ཀྱི༌ལྡིར༌གུན༌ མུལ༌ལ༌ ཅོས༌། ཀ༌ཝ༌གུན༌ནི༌ ཁེ༌ཐོག༌པོ༌ མུལ༌ ཏུམས༌ ཡང༌ ཏེ༌ཀ༌ མུལ༌ལི༌ ཀྱི༌ལྡིར༌གུན༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ནང༌སྐོར༌རི༌ ནང༌ང༌ ཞུག༌སའེ༌ ཡོ༌ལ༌ ཐགས༌ཁན༌ནི༌ རས༌རིན༌ཅན༌ནི༌ཀ༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ ཅོས༌། ཏེ༌བོའེ༌ རིང༌བོ༌ མི༌ཀྲར༌ 9 ཡང༌ ཐོན༌བོ༌ མི༌ཀྲར༌ 2 ཟམ༌ཤིག༌, ཀ༌ཟུག༌ ནང༌སྐོར༌རི༌ ཞན༌ ཡོ༌ལ༌གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ཏེ༌བོའ༌ ཀ༌ཝ༌ ཞི༌ དང༌ ར༌གན༌ནི༌ ཞབ༌ལྡན༌ ཞི༌ ཡང༌ མུལ༌ལི༌ ཀུག༌ཀུག༌གུན༌ དང༌ ཀྱི༌ལྡིར༌གུན༌, ཀ༌ཝ༌གུན༌ནི༌ ཁེ༌ཐོག༌པོ༌ མུལ༌ལི༌ ཏུམས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ཏམ༌པ༌ ཀུར༌ དང༌ ནང༌སྐོར༌རི༌ ཡོ༌ལ༌གུན༌ནི༌ པུར༌ཆ༌ ཚང༌མ༌ ར༌གན༌ནི༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","མོ༌ཟེས༌སི༌ བཀའ༌ ཏངས༌པ༌, ཏམ༌པ༌ ཀུར༌ ཅོ༌ཅེས༌ལ༌ ཀོལ༌ཁན༌ནི༌ གྱུ༌ ཚང༌མའེ༌ ཐོ༌ བླ༌མ༌ ཨ༌རོན༌ནི༌ བུ༌ཚ༌ ཨི༌ཐ༌མར༌རི༌ ལམ༌སྟན༌ ནང༌ཞིན༌ ལི༌ཝི༌པ༌གུན༌ནི༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ཡ༌ཧུ༌དཱའེ༌ སྡེ༌ ནང༌ནེ༌ ཧུར༌རི༌ ཚ༌འོ༌ ཨུ༌རི༌ བུ༌ཚ༌ བེ༌ཟ༌ལེལ༌ལི༌, ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཅི༌ཚང༌མ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ཁོའ༌ རོགས༌ཅོ༌ཁན༌ ཨ༌ཧི༌ས༌མག༌གི༌ བུ༌ཚ༌ ཨོ༌ཧོ༌ལིའབ༌, དཱན༌ནི༌ སྡེ༌ ནང༌ནེ༌ ཨིན༌པིན༌, ཁོ༌ རི༌མོ༌, ཟོ༌ལས༌ལ༌ ཡང༌ རས༌ ཀུས༌པོའེ༌ཀ༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཁན༌ ཁས༌པ༌ ཞིག༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ཡ༌ཝའ༌ མིག༌སལ༌ལི༌ ཆོད༌པ༌ ཕུལ༌ཁན༌ནི༌ ནང༌ནེ༌ སེར༌ ཀི༌ལོ༌ 1,000 ཏམ༌པའེ༌ ཀུར༌ ཅོ༌ཅེས༌སི༌ ལས༌སི༌ ནང༌ང༌ ཀོལས༌, ཏེ༌བོ༌ སྐར༌ཅེས༌ལ༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཏབ༌བ༌ ཀོལ༌ཁན༌ནི༌ ཚད༌པོ༌ ཀོལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","མི༌ཀྲངས༌ རྩི༌ ཟ༌ནེ༌ མི༌གུན༌ནི༌ ཀ༌ནེ༌ མུལ༌ ཀི༌ལོ༌ 3,400 ལྡུས༌, ཏེ༌བོ༌ སྐར༌ཅེས༌ལ༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཏབ༌བ༌ ཀོལ༌ཁན༌ནི༌ ཚད༌པོ༌ ཀོལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ལོ༌ ཉི༌ཤུ༌ ཡང༌ ཉི༌ཤུའི༌ སང༌ མང༌ང༌ ཨིན༌ཁན༌ མི༌ རེ༌རེའེ༌ ཀ༌ནེ༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཏབ༌བ༌ ཀོལ༌ཁན༌ནི༌ ཚད༌པོ༌ ནང༌ཞིན༌ མུལ༌ གརམ༌ 5.5 ལེནས༌། ཁོང༌གུན༌ནི༌ ཀྲངས༌ཀ༌ 6,03,550 ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ཏམ༌པའེ༌ ཀུར༌རི༌ ཡོ༌ལའེ༌ ཕིའ༌ ཀ༌ཝ༌ ལང༌ཅེས༌སི༌ ཞབ༌ལྡན༌ རེ༌རེ༌ ཅོ༌ཅེས༌ལ༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཏབ༌བ༌ ཀོལ༌ཁན༌ནི༌ ཚད༌པོ༌ ནང༌ཞིན༌ མུལ༌ ཀི༌ལོ༌ 34 ཀོལས༌། ཀ༌ཝ༌ གྱའེ༌ ཕིའ༌ མུལ༌ ཀི༌ལོ༌ 3,400 ཀོལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ལུས༌ཁན༌ནི༌ མུལ༌ ཀི༌ལོ༌ 30 ཅ༌ཀུག༌གུན༌, ཀྱི༌ལྡིར༌གུན༌ དང༌ ཀ༌ཝ༌གུན༌ནི༌ ཁེ༌ཐོག༌པོ༌ ཏུམ༌ཅེས༌ལ༌ ཀོལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ཡ༌ཝའེ༌ ཕིའ༌ ཕུལ༌ཁན༌ནི༌ ར༌གན༌ ཀི༌ལོ༌ 2,425 ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ཏེ༌བོ༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཞུག༌སའེ༌ སྒོའེ༌ ཞབ༌ལྡན༌, ཆོད༌ཁྲི༌, ཏེ༌བོའེ༌ ཀྲ༌མིག༌ དང༌ ཆོད༌ཁྲི༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌, ");
INSERT INTO lbj_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ནང༌སྐོར༌རི༌ ཀ༌ཝ༌གུན༌ དང༌ སྒོའེ༌ ཞབ༌ལྡན༌གུན༌ ཡང༌ ཏམ༌པའེ༌ ཀུར༌ དང༌ ནང༌སྐོར༌རི༌ པུར༌ཆ༌ ཚང༌མ༌ ཅོ༌ཅེས༌ལ༌ ཀོལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ཁོང༌གུན༌ནི༌, བླ༌མ༌གུན༌ནི༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཞབས༌ཏོག༌ ཞུ༌ ཟ༌ནེ༌ གོན༌ཅེས༌, སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཐགས༌ཁན༌ནི༌ ཀོས༌གུན༌ ཅོས༌། ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཁོང༌གུན༌ནི༌ ཨ༌རོན༌ནི༌ ཕིའ༌ བླ༌མའེ༌ ཀོས༌པོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ཁོང༌གུན༌ནི༌ ཨེ༌ཕོད༌, རས༌ རིན༌ཅན༌ནི༌ཀ༌ སེར༌ ཡང༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ཁོང༌གུན༌ནི༌ ལག༌ཤེས༌ ཁས༌པའེ༌ ལས༌, སེར༌ སྲ༌མོ༌ རྡུངས༌ཏེ༌ ཏེ༌བོ༌ སྐུད༌པ༌ ཙོགས༌ ཁྲ༌མོ༌ ཅད༌ཏེ༌ རས༌ རིན༌ཅན༌ནི༌ཀ༌ སེར༌ དང༌ སྔོན༌པོ༌, སྔོ༌མར༌, མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ཁོང༌གུན༌ནི༌ ཨེ༌ཕོད༌དི༌ གྱབ༌ དང༌ དུན༌ ཐུད༌ཅེས༌ལ༌ སྤུང༌པའེ༌ རས༌པོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ཁོང༌གུན༌ནི༌ ཨེ༌ཕོད༌དི༌ སྐྱེ༌རག༌པོའང༌ ཏེན༌ན༌ ཙོགས༌ རས༌ རིན༌ཅན༌ནི༌ཀ༌ སེར༌ དང༌ སྔོན༌པོ༌, སྔོ༌མར༌, མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ ཅོས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ཁོང༌གུན༌ནི༌ ཨོ༌ནེཀས༌ ཁྲ༌རྡོ༌གུན༌ནི༌ཀ༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌ རྕུག༌ཉིས༌སི༌ མིང༌གུན༌ སྐོས༌ཏེ༌ སེར༌རི༌ རིབ༌ཞི༌ ནང༌ང༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌ རྕུག༌ཉིས༌ ཨིད༌ཏུ༌ བོར༌ཅེས༌ལ༌ ཏེ༌བོ༌ ཨེ༌ཕོད༌དི༌ སྤུང༌པའེ༌ རས༌སི༌ཀ༌ ཏགས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ཁོང༌གུན༌ནི༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌ ཅོས༌, ལག༌ཤེས༌ ཁས༌པའེ༌ ལས༌ ཙོགས༌། ཏེ༌བོ༌ ཨེ༌ཕོད༌ ཙོགས༌ རས༌ རིན༌ཅན༌ནི༌ཀ༌ སེར༌ དང༌ སྔོན༌པོ༌, སྔོ༌མར༌, མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ཏེ༌བོ༌ ཀྲུབ༌ཞི༌, རིང༌ དང༌ ཞང༌ སེན༌ཀྲི༌མི༌ཀྲར༌ 22 ཡང༌ ཉི༌ལྟབ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ཁོང༌གུན༌ནི༌ ཏེ༌བོའེ༌ཀ༌ ཁྲ༌རྡོའ༌ རིན༌ཅན༌གུན༌ནི༌ ཀྲལ༌ཞི༌ ཅོས༌ ཡང༌ གོ༌མའེ༌ ཀྲལ༌ལི༌ ནང༌ང༌ རུ༌བི༌, ཏོ༌པཟ༌ དང༌ ཡུ༌; ");
INSERT INTO lbj_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ཀྲལ༌ ཉིས༌པའེ༌ ནང༌ང༌ ཏར༌ཀོའེས༌, ནི༌ལིམ༌ དང༌ ཨི༌མ༌རལད༌; ");
INSERT INTO lbj_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ཀྲལ༌ སུམ༌པའེ༌ ནང༌ང༌ ཇེ༌སིནཐ༌, ཨ༌གཏ༌ དང༌ ཨ༌མེ༌ཐིསཏ༌; ");
INSERT INTO lbj_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ཀྲལ༌ ཞི༌པའེ༌ ནང༌ང༌ ཀརི༌སོ༌ལཱེཏ༌, ཨོ༌ནེཀས༌ དང༌ ཇས༌པར༌ གུན༌། ཏེ༌ ཚང༌མ༌ སེར༌རི༌ རིབ༌ཞི༌ ནང༌ང༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ཁྲ༌རྡོའ༌ རྕུག༌ཉིས༌པོའེ༌ཀ༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌ རྕུག༌ཉིས༌སི༌ མིང༌གུན༌ ཐེ༌ཙེ༌ ཙོགས༌ལ༌ སྐོས༌ ཀ༌གུན༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌ རྕུག༌ཉིས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ཀྲང༌ང༌ ཀབ༌ཅེས༌པོ༌ ཨེ༌ཕོད༌ ཉམ༌པོ༌ ཐུད༌ཅེས༌ལ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌, ཁྲ༌མོ༌ ལྕུས༌ཏེ༌ ཉག༌ཐག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ཁོང༌གུན༌ནི༌ སེར༌རི༌ རིབ༌ཞི༌ དང༌ ཀྱི༌ལྡིར༌ ཉིས༌ ཅོས༌ ཡང༌ ཀྱི༌ལྡིར༌གུན༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌པོའེ༌ སྟག༌གི༌ ཀྲུ༌ ཉིས༌ཀོའེ༌ཀ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","སེར༌རི༌ ཉག༌ཐག༌གུན༌ནི༌ ཇུག༌ཅིག༌པོ༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌སི༌ ཀྱི༌ལྡིར༌ ཉིས༌ཀོའེ༌ཀ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ཉག༌ཐག༌གི༌ ཞན༌ ཇུག༌པོ༌ ཨེ༌ཕོད༌དི༌ དུན༌ ཆོགས༌སི༌ སྤུང༌པའེ༌ཀ༌ ཁྲ༌ ཅུག༌ཁན༌ སེར༌རི༌ རིབ༌ཞི༌ཀ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","སེར༌རི༌ ཀྱི༌ལྡིར༌ ཡང༌ ཉིས༌ ཅོས༌ཏེ༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌པོའེ༌ ཡོག༌གི༌ ཀྲུ༌ ཉིས༌ཀོའེ༌ ཐིལ༌ལ༌ ཨེ༌ཕོད༌ ཆོགས༌ལ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ཁོང༌གུན༌ནི༌ སེར༌རི༌ ཀྱི༌ལྡིར༌ ཡང༌ ཉིས༌ ཅོས༌ཏེ༌ ཨེ༌ཕོད༌དི༌ དུན༌ ཆོགས༌ལ༌ སྤུང༌པའེ༌ རས༌སི༌ ཇུག༌པོའེ༌ཀ༌, ཨེ༌ཕོད༌ དང༌ སྐྱེ༌རག༌ ཐུད༌སའེ༌ སྟག༌པོའེ༌ཀ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ཀྲང༌ང༌ ཀབ༌ཅེས༌སི༌ ཀྱི༌ལྡིར༌གུན༌ དང༌ ཨེ༌ཕོད༌དི༌ སྐྱེ༌རག༌གི༌ ཁེ༌ཐོག༌ག༌ ཡོད༌ཁན༌ནི༌ ཀྱི༌ལྡིར༌གུན༌ སྔོན༌པོ༌ རས༌ ཁྲ༌མོ༌ ཉམ༌པོ༌ ལྡམས༌། ཏེ༌ནེ༌ ཀྲང༌ང༌ ཀབ༌ཅེས༌པོ༌ གྲུལ༌ མ༌གྲུལ༌ལ༌ ཨེ༌ཕོད༌ ཉམ༌པོ༌ སྟན༌པོ༌ ལུས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ཨེ༌ཕོད༌དི༌ ཡོག༌ག༌ གོན༌ཅེས༌སི༌ ཀོས༌པོ༌ ཐགས༌ཁན༌ནི༌ རས༌ སྔོན༌པོའ༌ ཙེམས༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","གོ༌ ཕིང༌ཅེས༌སི༌ ཕིའ༌ ཏེ༌བོའེ༌ སྐྱིལ༌ལ༌ བི༌གའང༌ ཅོས༌ཏེ༌ མི༌ ཆད༌ཅེས༌ལ༌ ཐའ༌རིལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ཏེ༌བོའེ༌ ཡོག༌གི༌ ཟུར༌རི༌ཀ༌ སྔོན༌པོ༌, སྔོ༌མར༌ དང༌ མར༌པོ༌ ནས༌མ༌ ཉམ༌པོ༌ ཨ༌ནར༌རི༌ ཟོས༌ཏ༌ ཙོགས༌ ཅོས༌ཏེ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ཡང༌ ཁོང༌གུན༌ནི༌ ཅའང༌ མ༌དྲེས༌ཁན༌ སེར༌རི༌ ཀྲི༌ལུ༌ ཅོས༌ཏེ༌ ཀོས༌སི༌ ཡོག༌གི༌ ཟུར༌རི༌ཀ༌ ཨ༌ནར༌གུན༌ནི༌ པར༌ལ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ཞབས༌ཏོག༌ ཞུ༌ ཟ༌ནེ༌ བླ༌མ༌ གོན༌ཅེས༌, ཏེ༌ ཀོས༌སི༌ ཟུར༌ལ༌ ཀྲི༌ལུ༌ དང༌ ཨ༌ནར༌ གུན༌ སྤེལ༌ཏེ༌ ཏགས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ཁོང༌གུན༌ནི༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ལ༌ ཐགས༌ཁན༌ནི༌ རས༌ གྱལ༌ལ༌ ཉམ༌པོ༌ ནང༌ཀུག༌གི༌ ཀོས༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","རས༌ རིན༌ཅན༌ ཉམ༌པོ༌ གོའ༌ སྲིལ༌ཅེས༌སི༌ ཐོད༌, ཏི༌བི༌གུན༌ དང༌ ནང༌ཀུག༌ག༌ གོན༌ཅེས༌གུན༌ ཙེམས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ཡང༌ ལག༌ཤེས༌ ཁས༌པ༌གུན༌ནི༌ ཀུས༌པོ༌ རས༌སི༌ཀ༌ སེར༌ དང༌ སྔོན༌པོ༌, སྔོ༌མར༌, མར༌པོ༌ ནས༌མ༌ སྲུལ༌ཏེ༌ སྐྱེ༌རགས༌གུན༌ ཅོས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ཁོང༌གུན༌ནི༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌ རྡུངས༌ཏེ༌ ལེབ༌ལེབ༌ ཀྲུབ༌ཞི༌, ཐོར༌ཤོག༌ ཏམ༌པ༌ ཅོས༌ཏེ༌ ཏེ༌ཀ༌ “ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ ཕིའ༌ ཁོ༌ ཏམ༌པ༌ ཛདས༌” སྐོས༌ཏེ༌ བྲིས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ཏེ༌བོ༌ ཐོད༌དི༌ དུན༌ལ༌ སྐྱེ༌རགས༌ ཁྲ༌མོ༌ སྔོན༌པོ༌ཞིག༌ ཉམ༌པོ༌ ལྡམས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ཏ༌ ཡ༌ཝའ༌ ཐུག༌སའེ༌, ཏམ༌པ༌ ཀུར༌ ཅོ༌ཅེས༌སི༌ ལས༌ ཚང༌མ༌ གྲུབ༌། ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཅི༌ཚང༌མ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཏམ༌པའེ༌ ཀུར༌བོ༌ མོ༌ཟེས༌སི༌ དུན༌ལ༌ ཁྱོངས༌, ཀུར༌ དང༌ ཏེ༌བོའེ༌ ཅ༌ལག༌ ཚང༌མ༌; ཅ༌ཀུག༌གུན༌, རིབ༌ཞི༌གུན༌, པ༌ར༌ཁ༌ ཏང༌ཅེས༌སི༌ ཀྲ༌ལུ༌གུན༌, ཀ༌ཝ༌གུན༌ ཡང༌ ཏེ༌བོའེ༌ ཞབ༌ལྡན༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ལུག༌ཕོའེ༌ པགས༌པ༌ མར༌པོའེ༌ ཀབ༌ཅེས༌, གྱལ༌ལ༌ ཀོའེ༌ ཀབ༌ཅེས༌, ཡོ༌ལ༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ཀྲ༌ལུ༌གུན༌ ཉམ༌པོ༌ ཆད༌དོན༌ནི༌ སྒམ༌ དང༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ཅོག༌ཙེ༌ དང༌ ཏེ༌བོའེ༌ ཅ༌ལག༌ ཚང༌མ༌ ཡང༌ དཀོན༌མཆོག༌ག༌ ཕུལ༌ཁན༌ནི༌ ཏ༌གི༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","སྐྱོང༌ཙེ༌གུན༌ ཉམ༌པོ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ནི༌ སེར༌རི༌ འོད༌སྟགས༌ དང༌ ཏེ༌བོའེ༌ ཅ༌ལག༌ ཚང༌མ༌ ཡང༌ འོད༌དི༌ ཕིའ༌ མར༌ནག༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","སེར༌རི༌ ཆོད༌ཁྲི༌, ཁྲུས༌ཏང༌ཅེས༌སི༌ མར༌ནག༌, ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌, ཀུར༌རི༌ ནང༌ང༌ ཞུག༌སའེ༌ སྒོའེ༌ ཡོ༌ལ༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ར༌གན༌ནི༌ ཀྲ༌མིག༌ ཉམ༌པོ༌ ར༌གན༌ནི༌ ཆོད༌ཁྲི༌, ཏེ༌བོའེ༌ ཀྲ༌ལུ༌གུན༌ ཡང༌ ཆོད༌ཁྲིའི༌ ཅ༌ལག༌ ཚང༌མ༌, ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ དང༌ ཏེ༌བོ༌ བོར༌ས༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ནང༌སྐོར༌རི༌ ཡོ༌ལ༌, ཏེ༌བོའེ༌ ཀ༌ཝ༌གུན༌ དང༌ ཞབ༌ལྡན༌གུན༌, ཏེ༌ནང༌ང༌ ཆ༌སའེ༌ སྒོའེ༌ ཡོ༌ལ༌, ཏེ༌བོའེ༌ ཐག༌པ༌ དང༌ པུར༌ཆ༌ གུན༌, ཡ༌ཝ༌ ཐུག༌སའེ༌, ཏམ༌པ༌ ཀུར༌རི༌ ནང༌ང༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌, ");
INSERT INTO lbj_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ཡང༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ ཟ༌ནེ༌ ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ གོན༌ཅེས༌སི༌ ཀོས༌ལག༌ ཏམ༌པ༌ གུན༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ལས༌ ཚང༌མ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ཁོང༌གུན༌ནི༌ ཏེ༌ ཚང༌མ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཅོ༌ཁན༌བོ༌ མོ༌ཟེས༌སི༌ ཐོང༌པ༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཅིན༌ལབས༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ཟླ༌ཝ༌ ཀྲང༌པོའེ༌ ཞག༌ཏང༌པོའེ༌ ཞག༌ག༌ ཡ༌ཝ༌ ཐུག༌སའེ༌, ཏམ༌པ༌ ཀུར༌བོ༌ ཙུག༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","བཀའ༌རྒྱ༌ རྕུ༌ བྲིས༌ཁན༌ནི༌ རྡོའ༌ ལེབ༌ལེབ༌ གྱངས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ཆད༌དོན༌ནི༌ སྒམ༌བོ༌ ཏེ༌ ནང༌ང༌ བོར༌ ཡང༌ ཏེ༌བོའེ༌ དུན༌ལ༌ ཡོ༌ལ༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ཏེ༌ནེ༌ ཅོག༌ཙེ༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌ ཁྱོངས༌ཏེ༌ ཀུར༌རི༌ ཏམ༌པ༌ ནས༌སའེ༌ ནང༌ང༌ བོར༌, ཡང༌ འོད༌སྟགས༌ ཁྱོངས༌ཏེ༌ ཏེ༌ཀ༌ སྐྱོང༌ཙེ༌ གུན༌ རིག༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ཆད༌དོན༌ནི༌ སྒམ༌མི༌ ཡོ༌ལའེ༌ དུན༌ལ༌ སྤོས༌ དུག༌ཅེས༌སི༌ སེར༌རི༌ ཆོད༌ཁྲི༌ བོར༌ ཡང༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཆ༌སའེ༌ སྒོའེ༌ཀ༌ ཡོ༌ལ༌ ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“ཡ༌ཝ༌ ཐུག༌སའེ༌ ཏམ༌པ༌ ཀུར༌རི༌ ནང༌ང༌ ཆ༌སའེ༌ སྒོ༌ དུན༌ལ༌ ཆོད༌པ༌ མེའ༌ སྲག༌སའེ༌ ཆོད༌ཁྲི༌བོ༌ བོར༌, ");
INSERT INTO lbj_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ ཀུར༌ དང༌ ཏེ༌ ཆོད༌ཁྲི༌ པར༌ལ༌ བོར༌ཏེ༌ ཆུ༌ སྐོང༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ཀུར༌རི༌ ནང༌སྐོར༌རི༌ ཡོ༌ལ༌གུན༌ ཏོག༌ ཡང༌ ཏེ༌ནང༌ང༌ ཆ༌སའེ༌ སྒོའ༌ ཡོ༌ལ༌ ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ཏེ༌ནེ༌ ཏམ༌པའེ༌ ཀུར༌ དང༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཅ༌ལག༌ ཚང༌མ༌ ཁྲུས༌ཏང༌ཅེས༌སི༌ མར༌ནག༌ ལུགས༌ཏེ༌ རྩང༌མ༌ ཅོས༌། ཏེ༌ནེ༌ ཏེ༌ ཚང༌མ༌ ཏམ༌པ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ཏེ༌ སྟིང༌ནེ༌ ཆོད༌པ༌ མེའ༌ སྲག༌སའེ༌ ཆོད༌ཁྲི༌ དང༌ ཏེ༌ཀ༌ ཀོལ༌ཅེས༌སི༌ ཅ༌ལག༌ གུན༌ནི༌ཀ༌ མར༌ ལུགས༌ཏེ༌ རྩང༌མ༌ ཅོས༌, ཏེ༌ནེ༌ ཏེ༌གུན༌ མ༌ ཏམ༌པ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ཡང༌ ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ དང༌ ཏེ༌བོ༌ བོར༌ཅེས༌པོའང༌ མར༌ ལུགས༌ཏེ༌ རྩང༌མ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ ཡ༌ཝ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ ཁྱོངས༌ཏེ༌ ཁོང༌གུན༌ ཆུ༌ ཉམ༌པོ༌ ཁྲུས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ཏེ༌ནེ༌ ཨ༌རོན༌ལ༌ བླ༌མའེ༌ ཀོས༌ལག༌ ཏམ༌པ༌ སྐོན༌ ཡང༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ངའ༌ ཞབ༌ཞི༌ ཞུ༌ཅེས༌ལ༌ ཁོའ༌ མར༌ ལུགས༌ཏེ༌ སོ༌སོ༌ ཕེས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ཁོའེ༌ བུ༌ཚ༌གུན༌ ཁྱོངས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ནང༌ཀུག༌གི༌ ཀོས༌ ཏམ༌པ༌ སྐོན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ཡང༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ངའ༌ ཞབ༌ཞི༌ ཞུ༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌གུན༌ནི༌ ཨ༌བ༌ ཙོགས༌ལ༌ མར༌ ལུགས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཁྲུས༌ཏོང༌། མར༌ ལུགས༌ཏེ༌ ཁྲུས༌ ཏང༌ཅེས༌པོའེ༌ ཁོང༌གུན༌ནི༌ མིར༌གྱུད༌ ཚང༌མའེ༌, བླ༌མའེ༌ ཚུལ༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ མོ༌ཟེས༌སི༌ ཅི༌ ཚང༌མ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ཏེ༌ནེ༌ ཨི༌ཇིབ༌ནེ༌ བིངས༌ཏེ༌ ལོ༌ ཉིས༌པའེ༌ ཟླ༌ཝ༌ ཏང༌པོའེ༌, ཞག༌ ཏང༌པོའེ༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ ཏམ༌པ༌ ཀུར༌བོ༌ ཙུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","མོ༌ཟེས༌སི༌ ཏམ༌པའེ༌ ཀུར༌ ལང༌ ཟ༌ནེ༌ ཏེ༌བོའེ༌ ཞབ༌ལྡན༌གུན༌ ཏིངས༌, རིབ༌ཞི༌གུན༌ ལངས༌, པ༌ར༌ཁ༌གུན༌ ཐུདས༌ ཡང༌ ཀ༌ཝ༌གུན༌ ཙུགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ཏེ༌ནེ༌ ཐིལ༌ དང༌ ཁེ༌ཐོག༌གི༌ ཀབ༌ཅེས༌གུན༌ ཀྱངས༌ཏེ༌ ཏམ༌པའེ༌ ཀུར༌ལ༌ ཀབས༌, ཀ༌ཟུག༌ མོ༌ཟེས༌ལ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ཏེ༌ནེ༌ ཁོའེ༌ བཀའ༌རྒྱ༌ རྕུ༌ བྲིས༌ཁན༌ནི༌ རྡའ༌ ལེབ༌ལེབ༌གུན༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ ནང༌ང༌ བོར༌ཏེ༌ ཀྲ༌ལུ༌གུན༌ ཀྱི༌ལྡིར༌རི༌ ནང༌ང༌ ཅུགས༌ ཡང༌ ཐུག༌རྗེ༌ ཁའ༌ལེབ༌པོ༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ཁོའེ༌ སྒམ༌བོ༌ ཏམ༌པའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཁྱོངས༌ ཡང༌ སྒམ༌བོ༌ མི༌ཐོང༌ཅེས༌ལ༌ ཡོ༌ལ༌ ཏངས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ཁོའེ༌ ཅོག༌ཙེ༌ ཡ༌ཝ༌ ཐུག༌སའེ༌, ཏམ༌པ༌ ཀུར༌རི༌ ནང༌ང༌ བྱང༌ ཆོགས༌ལ༌ ཡོ༌ལའེ༌ ཕི༌ལོག༌ག༌ བོརས༌, ");
INSERT INTO lbj_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ཡང༌ ཏེ༌བོའེ༌ཀ༌ ཡ༌ཝའ༌ ཕུལ༌ཁན༌ནི༌ ཏ༌གི༌ བོརས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ ཁོའ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ཁོའེ༌ འོད༌སྟག༌པོ༌ ཡ༌ཝ༌ ཐུག༌སའེ༌, ཏམ༌པ༌ ཀུར༌རི༌ ནང༌ང༌ ལྷོ༌ ཆོགས༌ལ༌ ཅོག༌ཙེའེ༌ འ༌ངོ༌ ཆོགས༌པོའེ༌ཀ༌ བོརས༌ ");
INSERT INTO lbj_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ཡང༌ ཡ༌ཝའེ༌ དུན༌ལ༌ ཁོའེ༌ སྐྱོང༌ཙེ༌གུན༌ ཏུགས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ ཁོའ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","མོ༌ཟེས༌སི༌ སེར༌རི༌ ཆོད༌ཁྲི༌ ཡ༌ཝ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཡོ༌ལའེ༌ དུན༌ལ༌ བོརས༌ ");
INSERT INTO lbj_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ཡང༌ ཏེ༌ཀ༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌ ཏུགས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ ཁོའ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ཁོའེ༌ ཏམ༌པ༌ ཀུར༌རི༌ ནང༌ང༌ ཆ༌སའེ༌ སྒོའེ༌ ཡོ༌ལ༌ ཆར༌ལ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ཁོའེ༌ ཏམ༌པ༌ ཀུར༌རི༌ ཕི༌ལོག༌ག༌ སྒོའེ༌ ཉེ༌མོའ༌ ཆོད༌པ༌ མེའ༌ སྲག༌སའེ༌ ཆོད༌ཁྲི༌བོ༌ བོརས༌, ཡང༌ ཏེ༌བོའེ༌ཀ༌ ཁོའེ༌ མེའ༌ སྲག༌ཅེས༌ དང༌ ཀྲོ༌ནས༌སི༌ ཆོད༌པ༌ ཕུལས༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ ཁོའ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ཁོའེ༌ ལག༌པ༌ ཁྲུ༌ཅེས༌སི༌ ཞོང༌པ༌ ཏམ༌པ༌ ཀུར༌ དང༌ ཆོད༌ཁྲི༌ པར༌ལ༌ བོརས༌ ཡང༌ ཏེ༌བོ༌ ཆུའི༌ སྐངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","མོ༌ཟེས༌, ཨ༌རོན༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ལག༌པ༌ དང༌ རྐང༌པ༌ གུན༌ ཏེ༌ ནང༌ང༌ ཁྲུའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ཡ༌ཝ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཡ༌ ཆོད༌ཁྲི༌ཀ༌ ཆ༌ ཟ༌ནེ༌ ཁོང༌གུན༌ནི༌ ལག༌པ༌ དང༌ རྐང༌པ༌ གུན༌ ཁྲུའད༌པིན༌, ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","མོ༌ཟེས༌སི༌ ཏམ༌པ༌ ཀུར༌རི༌ ནང༌སྐོར༌རི༌ རིབ༌ཞི༌གུན༌ ཙུགས༌ཏེ༌ ཏེ༌ནང༌ང༌ ཆོད༌ཁྲི༌ བོརས༌ ཡང༌ ནང༌ཀུག༌ག༌ ཆ༌སའེ༌ སྒོའེ༌ཀ༌ ཡོ༌ལ༌ ཏགས༌། ཏེ༌ནེ༌ ཁོའེ༌ ལས༌གུན༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ཏེ༌ནེ༌ ཡ༌ཝ༌ ཐུག༌སའེ༌, ཏམ༌པ༌ ཀུར༌བོ༌ སྲིན༌ནི༌ ཀབས༌ ཡང༌ ཡ༌ཝའེ༌ ཟིར༌རྗིད༌ ཏེ༌བོའེ༌ ནང༌ང༌ གངས༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","མོ༌ཟེས༌ ཡ༌ཝ༌ ཐུག༌སའེ༌ ཀུར༌རི༌ ནང༌ང༌ ཆ༌ མ༌ཉན༌ ཅིའ༌ཟེར༌ན༌ ཏམ༌པའེ༌ ཀུར༌ སྲིན༌ནི༌ ཀབས༌ཏེ༌ ཡ༌ཝའེ༌ ཟིར༌རྗིད༌ ཏེ༌བོའེ༌ ནང༌ང༌ གངས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ཏམ༌པ༌ ཀུར༌རི༌ ཀ༌ནེ༌ སྲིན༌ ཐེན༌ན༌ ཛད༌ད༌ཅིག༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཏེ༌ ནས༌ས༌ནེ༌ བེས༌ལ༌ བིང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ཀལ༌ཏེས༌ སྲིན༌ ཐེན༌ན༌ མ༌ཛད༌ན༌ ཁོང༌གུན༌ སྲིན༌ ཐེན༌ཐེན༌ ཚོག༌པ༌ ཏེན༌ན༌ ནས༌སའེ༌ཀ༌ དུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ བེས༌ གང༌པོའེ༌ ནང༌ང༌ ཁོང༌ ཚང༌མའེ༌ མིག༌གི༌ དུན༌ལ༌, ཉི༌མའེ༌ ཏུས༌ལ༌ ཡ༌ཝའེ༌ སྲིན༌ ཏམ༌པའེ༌ ཀུར༌ལ༌ ཀབས༌ཏེ༌ ཡང༌ ཚན༌ནི༌ ཏུས༌ལ༌ སྲིན༌ནི༌ ནང༌ང༌ མེ༌ བར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌ ཀྲོངས༌ཏེ༌ སྟིང༌ནེ༌, མོ༌ཟེས༌ལ༌ རོགས༌ཅོ༌ཁན༌ ནུན༌ནི༌ བུ༌ཚ༌ ཡོ༌ཤུའ༌ ཡ༌ཝའེ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“ངའ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ མོ༌ཟེས༌ ཤི༌ཏེ༌ མེད༌, ཏ༌ ཁྱོ༌རང༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཅོས༌ ཡང༌ གོ༌ཁྲིད༌ ཅོས༌ཏེ༌ ཁྱོ༌ཞའ༌ ངའེ༌ ཏང༌ཅེས༌ཅན༌ནི༌ ས༌ཀྱད༌ལ༌ ཁོང༌གུན༌ ཁྱེར༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","མོ༌ཟེས༌ལ༌ ཁ༌ཆད༌ ཅོ༌ཁན༌ ནང༌ཞིན༌, ངའེ༌ ཁྱོ༌ཞའེ༌ རྐང༌པ༌ བོར༌ཅེས༌ཅན༌ནི༌ ས༌ཀྱད༌ ཚང༌མ༌ ཁྱོ༌ཞའ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","ལྷོ༌ ཆོགས༌སི༌ ཐང༌སྟོང༌ ནེ༌ བྱང༌ ཆོགས༌སི༌ ལེ༌བ༌ནོན༌ནི༌ རི༌གུན༌ ཚོག༌པ༌ ཡང༌ ཤར༌ ཆོགས༌སི༌ ལྩངས༌པོ༌ ཆེན༌མོ༌ ཡུཕ༌རེ༌ཀྲས༌ ནེ༌ ནུབ༌ ཆོགས༌སི༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌ ཚོག༌པ༌ ཁྱོ༌ཞའེ༌ ས༌ཀྱད༌ ཁྱེད༌ཨིན༌, ཏེ༌ ནང༌ང༌ ཧེད༌པ༌གུན༌ནི༌ ཡུལ༌ ཚང༌མ༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","ཡོ༌ཤུའ༌, ཁྱོ༌རང༌ངི༌ མི༌ཚེའེ༌ གང༌པོའེ༌ ནང༌ང༌ ཁྱོ༌རང༌ང༌ མག༌ ཏངས༌ཏེ༌ སུ༌ཞིག༌གིའང༌ ཕམ༌ཀལ༌ མི༌ཉན༌། མོ༌ཟེས༌ ཉམ༌པོ༌ དུག༌ག༌ ཙོགས༌ལ༌ ང༌ ཏུས༌གྱུན༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ དུག༌ཨིན༌། ངའེ༌ ཁྱོ༌རང༌ མ༌ནེ༌ མི༌ཕང༌།” ");
INSERT INTO lbj_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","“སེམས༌སི༌ ནང༌ང༌ ཤེད༌ཅན༌ གྱུར༌ཏེ༌ སྤོས༌པ༌ ལེན༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ནའ༌ ཁུར༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ལ༌ ཏང༌ཅེས༌སི༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱོ༌རང༌ངི༌ གོ༌ཁྲིད༌ ཅོས༌ཏེ༌ འི༌ མི༌གུན༌ ཁྱེར༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","ཤེད༌ཅན༌ གྱུར༌ཏེ༌ སྤོས༌པ༌ ཀྲག༌པོ༌ ལེན༌། ངའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ ཁྱོ༌རང༌ང༌ ཏངས༌ཁན༌ནི༌ ཁྲིམས༌ ཚང༌མ༌ ཁའ༌ཉན༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌། ཏེ༌གུན༌ནེ༌ གྱུར༌ཏེ༌ ཡས༌པ༌ ཡ༌ ཡོ༌མ༌ མ༌ཆ༌ ཏེ༌ནེ༌ ཁྱོ༌རང༌ ཀ༌རུ༌ ཆ༌ནའང༌ ཁྲངས༌པོ༌ ལུས༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","མི༌གུན༌ ཛོམས༌ས༌ འི༌ ཁྲིམས༌སི༌ སྤེ༌ཆ༌ ཏུས༌གྱུན༌ ཁྱོ༌རང༌ངི༌ སིལ༌གོས༌། ཉིན༌ཚན༌ མེད༌པ༌ ཏེ༌གུན༌ ཇངས༌ཏེ༌ ཏེ༌ནང༌ང༌ བྲིས༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁྱོ༌རང༌ངི༌ ཅོ༌ཅེས༌ལ༌ ནང༌ང༌ བོར༌། ཏེ༌ནེ༌ ཁྱོ༌རང༌ ཁྲངས༌པོ༌ ལུས༌ཏེ༌ ཡར༌གྱས༌ ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","ངའེ༌ ཁྱོ༌རང༌ང༌ བཀའ༌ ཏང༌ངད༌, ཤེད༌ཅན༌ གྱུར༌ཏེ༌ སྤོས༌པ༌ ལེན༌། ཇིགས༌ མ༌ཇིགས༌ ཡ༌ སེམ༌ཤུག༌ ཆག༌ མ༌ཅུག༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ ཁྱོ༌རང༌ངི༌ དཀོན༌མཆོག༌ ཁྱོ༌རང༌ ཀ༌རུ༌ ཆ༌ནའང༌ ཉམ༌པོ༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ གོ༌སྐྱོང༌གུན༌ལ༌ བཀའ༌ ཏངས༌, ");
INSERT INTO lbj_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“ཀུར༌ ཙུག༌ཏེ༌ ཡོད༌སའེ༌ ནས༌ས༌ ཚང༌མ༌ སོང༌ཏེ༌ མི༌གུན༌ལ༌ ཟན༌ གྲལ༌གྲིག༌ ཅོ༌ཅེས༌ལ༌ ཟེར༌ ཅིའ༌ཟེར༌ན༌ ཞག༌ སུམ༌པའེ༌ ཞག༌ག༌ ང༌དང༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ ང༌དང༌ང༌ སལ༌ཅེས༌ཅན༌ནི༌ ས༌ཀྱད༌པོ༌ ལེན༌ན༌ལ༌ ཆ༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ སྡེ༌ གང༌པོ༌ ཡང༌ མ༌ནས༌སའེ༌ སྡེ༌ ཕེད༌པོའ༌ བོདས༌ ཡང༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ ཁྱོ༌ཞའ༌ བཀའ༌ སལ༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ཅོ༌ཤིག༌། ང༌དང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌ ཚུགས༌ཏེ༌ དུག༌ཅེས༌ལ༌ འི༌ ས༌ཀྱད༌པོ༌ སལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","ཁྱོ༌ཞའེ༌ ན༌མ༌, ཕྲུ༌གུ༌ དང༌ སེམས༌ཅན༌ ཚང༌མ༌ འི༌ཀ༌ མོ༌ཟེས༌སི༌ ཁྱོ༌ཞའ༌ སལ༌ཁན༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ དུག༌ཅུག༌ ཨིན༌ནའང༌ ཁྱོ༌ཞའེ༌ མི༌ གྱལ༌ལ༌ ནོལ༌ཁན༌ ཚང༌མ༌ ཚོན༌ཆ༌ ཁུར༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཞན༌ སྡེ༌གུན༌ནི༌ སང༌ སྔུན༌ལ༌ སོང༌ཏེ༌ ཁྱོ༌ཞ༌རང༌ངི༌ སྤུན༌གུན༌ལ༌ རོགས༌ ཅོ༌གོས༌, ");
INSERT INTO lbj_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ནམ༌ཚོག༌པ༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌ སལ༌ཁན༌ ཙོགས༌ ཁོང༌གུན༌ལ༌ ངལ༌ཚོ༌ མི༌སལ༌ ཡང༌ ནམ༌ཚོག༌པ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ཁོང༌གུན༌ལ༌ སལ༌ཅེས༌ཅན༌ནི༌ ས༌ཀྱད༌པོ༌ ཁོང༌གུན༌ནི༌ མི༌ལེན༌། ཏེ༌སྟིང༌ནེ༌ མོ༌ཟེས༌སི༌ ཁྱོ༌ཞའ༌ སལ༌ཁན༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌སི༌ འི༌ ས༌ཆའེ༌ ནང༌ང༌ ཞི༌དེ༌ ཉམ༌པོ༌ དུག༌ག༌ ཁྱོ༌ཞའ༌ ལོགས༌ཏེ༌ ཆ༌ནའང༌ གྲིག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","ཁོང༌གུན༌ནི༌ ཡོ༌ཤུའ༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ ང༌ཞའ༌ བཀའ༌ སལ༌ཁན༌ ཚང༌མ༌ ང༌ཞའེ༌ ཅོ༌ཨིན༌ ཡང༌ ཉེ༌རང༌ངི༌ ང༌ཞའ༌ ཀ༌རུ༌ ལམ༌ཅུག༌ནའང༌ ང༌ཞ༌གུན༌ ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","ཏུས༌གྱུན༌ ང༌ཞ༌གུན༌ནི༌ མོ༌ཟེས༌སི༌ ཁའ༌ ཉན༌ན༌ ཙོགས༌ལ༌ ཉེ༌རང༌ངི༌ ཁའ༌ ཉན༌ཨིན༌ ཡང༌ མོ༌ཟེས༌ ཉམ༌པོ༌ ཞུག༌ས༌ ཙོགས༌ལ༌ ཡ༌ཝ༌ ཉེ༌རང༌ངི༌ དཀོན༌མཆོག༌ ཉེ༌རང༌ ཉམ༌པོ༌ ཞུགས༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","ཉེ༌རང༌ངི༌ བཀའ༌ ཏང༌ཁན༌གུན༌ལ༌ ཁའ༌ མ༌ཉན༌ན༌ ཉེ༌རང༌ངི༌ གོ༌ཁྲིད༌ ཅོ༌ཁན༌ནི༌ གྱབ༌གལ༌ ཅོ༌ཁན༌ ཚང༌མ༌ སད༌ཨིན༌། ཤེད༌ཅན༌ གྱུར༌ ཡང༌ སྤོས༌པ༌ ལེན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ གྱལ༌སའེ༌ སྲུང༌སྐྱོབ༌ ལྟའ༌ལ༌ ཤིཏ༌ཏིམ༌ ནེ༌ མི༌ ཉིས༌ ཀལ༌ཏེ༌ ཟེརས༌, “ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ འ༌ངོ༌ ཆོགས༌སི༌ ས༌ཀྱད༌, མིག༌སལ༌ལི༌ ཡེ༌རི༌ཀོའེ༌ ནང༌ང༌ སོང༌ཏེ༌ སྟག༌ཅད༌ ཅོས༌།” ཏེ༌ནེ༌ ཁོང༌ ཉིས༌ཀོ༌ སོང༌ ཡང༌ ཟུགས༌ཙོང༌མ༌ ར༌ཧབ༌བི༌ ཁང༌པའེ༌ ནང༌ང༌ ཏེ༌ ཚན༌བོ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","ཨིན༌ནའང༌ ཡེ༌རི༌ཀོའེ༌ གྱལ༌པོའ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཁ༌ཅིག༌ ཏེ༌ ཚན༌ལ༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ཁོའེ༌ ཡུལ༌ལ༌ སྟག༌ཅད༌ ཅོའ༌ ཡོང༌ཁན༌བོ༌ གྱུས༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ར༌ཧབ༌བ༌ ལོན༌ ཀལ༌ཏེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཁང༌པའ༌ ཡོང༌ཁན༌ནི༌ མི༌གུན༌ ཁྲིད༌ཏེ༌ ཁྱོང༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ང༌དང༌ངི༌ ཡུལ༌ལི༌ སྲུང༌སྐྱོབ༌ ཚང༌མ༌ གྱུས༌ ཅོའ༌ལ༌ ཡོངས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","ཨིན༌ནའང༌ ར༌ཧབ༌བི༌ མི༌ ཉིས༌ཀོ༌ སྦས༌ཏེ༌ བོརས༌། ཁོའེ༌ ལོན༌ ཁྱོང༌ཁན༌གུན༌ལ༌ ལན༌ཏངས༌, “འོ༌ན༌ མི༌ ཉིས༌ འི༌རུ༌ ཡོངས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ ཀ༌ནེ༌ ཡོངས༌ཏེ༌ ཨིན༌ ང༌ གྱུས༌མེད༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","མུན༌ཅུ༌རུབ༌ཀྱིས༌ལ༌ གྱས༌སྒོ༌ ཅུག༌གི༌ སང༌ སྔུན༌ལ༌ ཁོང༌གུན༌ གྱལ༌ས༌ ནེ༌ བིང༌ཏེ༌ སོང༌། ཁོང༌གུན༌ ཀ༌ངོ༌ ཆོགས༌ལ༌ སོང༌ ང༌ གྱུས༌མེད༌, ཀལ༌ཏེས༌ ཉེ༌ཞའ༌ གྱོགས༌པ༌ ཆ༌ན༌ ཁོང༌གུན༌ ཟུམ༌ ཉན༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","༼བུ༌མོའེ༌ མི༌ ཉིས༌ཀོ༌ ཁང༌པའེ༌ ཁེ༌ཐོག༌ག༌ ཁྱེར༌ཏེ༌ ཐོག༌གི༌ཀ༌ ཏིངས༌ཏེ༌ ཡོད༌ཁན༌ རྩའེ༌ ཡོག༌ག༌ ཀབས༌ཏེ༌ བོརས༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","གྱལ༌པོའེ༌ ལོན༌ ཁྱོང༌ཁན༌གུན༌ གྱལ༌ས༌ ནེ༌ བིང༌ཏེ༌ ཆ༌ ཚར༌ར༌ཅིག༌ གྱས༌སྒོ༌ ཅུགས༌། ཏེ༌ མི༌གུན༌ ཙལ༌ཨིན༌ ཁོང༌གུན༌ ལམ༌ གྱུད༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌, རྒལ༌ཏེ༌ ཆ༌སའེ༌ ནས༌ས༌ ཚག༌པ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","ལྟའ༌ ཡོང༌ཁན༌གུན༌ ཉིད༌ ཏང༌ངི༌ སང༌ སྔུན༌ལ༌, ར༌ཧབ༌ ཁོང༌གུན༌ ཡོད༌ས༌ སོང༌ ");
INSERT INTO lbj_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ཡང༌ ཟེརས༌, “ཡ༌ཝའེ༌ འི༌ ས༌ཀྱད༌ ཁྱོ༌ཞའ༌ སལ༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཇིགས༌ནང༌ ང༌ཞའེ༌ཀ༌ བབས༌ཏེ༌ ཨིན༌ཁན༌བོ༌ ང༌ གྱུས༌ཡོད༌། འི༌ ས༌ཆའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ མ༌ སྲན༌ཏྲེ༌ ཇིགས༌ཏེ༌ ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌ ནེ༌ བིངས༌ཏེ༌ ཡོང༌ ཟ༌ནེ༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ཚོ༌ མར༌པོའེ༌ ཆུ༌ སྐམས༌ཅུག༌ག༌ ཛད༌ཁན༌ ཡང༌ ཁྱོ༌ཞའེ༌ ཡོར༌དཱན༌ནི༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌སི༌ ཨ༌མོར༌པ༌ གྱལ༌པོ༌ སི༌ཧོན༌ དང༌ ཨོག༌ ཡང༌ ཁོང༌གུན༌ནི༌ མི༌ ཚང༌མ༌ ཁྲེས༌ཏོར༌ ཅོ༌ཁན༌བོ༌ ང༌ཞ༌གུན༌ནི༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","ཏེ༌གུན༌ ཚོར༌ཏེ༌ ང༌ཞའེ༌ སྙིང༌ ཇིགས༌པའེ༌ གངས༌ ཡང༌ ནོལ༌ཅེས༌སི༌ སྤོས༌པ༌ མེད༌ཁན༌ སོང༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ནམ༌ཁའ༌ དང༌ ཇིག༌རྟེན༌ ཉིས༌ཀོའེ༌ཀ༌ ཝང༌ སྲུལ༌ལ༌ ཛད༌ད༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","ངའེ༌ ཁྱོ༌ཞའ༌ སྙིང༌རྗེ༌ སྟན༌ པ༌སང༌ ཏ༌ ཁྱོ༌ཞའེ༌ ང༌ དང༌ ངའེ༌ ནང༌ཚངས༌ལ༌ སྙིང༌རྗེ༌ སྟན༌ཅེས༌, ཡ༌ཝའེ༌ ཚན༌ནི༌ ནང༌ང༌ ནའ༌ ཁུར༌ར༌ ཛད༌ ཡང༌ ཏན༌ཏན༌ ཆ༌ཅེས༌ལ༌ ང༌ སྟགས༌ཤིག༌ སལ༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ ཨ༌བ༌ དང༌ ཨ༌མ༌, ངའེ༌ ཨ༌ཅོ༌ནོ༌ དང༌ ཨ༌ཅེ༌ ནོ༌མོ༌ ཡང༌ ཁོང༌གུན༌ནི༌ ནང༌ཚངས༌ སད༌ མ༌སད༌ད༌ སྐྱོབ༌ཅེས༌སི༌ ཁ༌ཆད༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","མི༌ ཉིས༌ཀོའེ༌ བུ༌མོ༌བོའ༌ ཟེརས༌, “ང༌ཞའེ༌ ཁྱོ༌ཞའ༌ མ༌སྐྱོབ༌ན༌, དཀོན༌མཆོག༌གི༌ ང༌ཞའེ༌ སྲོག༌ ལེན༌ཤིག༌། ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ང༌ཞ༌གུན༌ནི༌ ལས༌སི༌ ཐབ༌ལྡིངས༌པོ༌ སུའང༌ མ༌ཤད༌ན༌ ཡ༌ཝའེ༌ འི༌ ས༌ཀྱད༌པོ༌ ང༌ཞའ༌ སལ༌ལ༌ཅིག༌ ང༌ཞའ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ སྙིང༌རྗེ༌ཅན༌ དང༌ ཨིད༌ཤེས༌ཅན༌ ལུས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","ར༌ཧབ༌བི༌ ཁང༌པ༌ གྱལ༌སའེ༌ རྩིག༌པའེ༌ཀ༌ ཡོད༌ པ༌སང༌ ཁོའེ༌ ཀར༌ཁུང༌ ནེ༌ ཐག༌པ༌ ཏངས༌ཏེ༌ ཁོང༌གུན༌ གྱལ༌སའེ༌ ཕི༌ལོག༌ ཆོགས༌ལ༌ ཕབས༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","བུ༌མོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཙལ༌ཁན༌གུན༌ལ༌ ཁྱོ༌ཞའ༌ མི༌ ཐོབ༌ཅེས༌སི༌ ཕིའ༌ རི༌ ཆོགས༌ལ༌ སོང༌ཏེ༌ ཞག༌མ༌ སུམ༌ ཨིབས༌ཏེ༌ དུག༌, ཙལ༌ཁན༌གུན༌ ལོགས༌ཏེ༌ ཡོང༌ང༌ཅིག༌ ཁྱོ༌ཞའ༌ ལོགས༌ཏེ༌ སོང༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","ཁོང༌གུན༌ནི༌ བུ༌མོའ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ང༌ཞའེ༌ ཟེར༌ཁན༌བོ༌ མ༌ཅོ༌ན༌, ཁྱོ༌རང༌ང༌ ཅོ༌ཁན༌ནི༌ ཁ༌ཆད༌པོའེ༌ ཀ༌ནེ༌ ང༌ཞའ༌ བུད༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","ང༌ཞའ༌ འི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཡོང༌ ཟ༌ནེ༌ ཁྱོ༌རང༌ངི༌ ང༌ཞའ༌ ཕབས༌ཁན༌ནི༌ ཀར༌ཁུང༌ངི༌ཀ༌ འི༌ རས༌ མར༌པོ༌བོ༌ ཏགས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཨ༌བ༌ དང༌ ཨ༌མ༌, ཨ༌ཅོ༌ནོ༌ ཡང༌ ཁྱོ༌རང༌ངི༌ ཉེན༌གྲུང༌ ཚང༌མ༌ ཁྱོ༌རང༌ངི༌ ཁང༌པའེ༌ ནང༌ང༌ ཁྱོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","ཀལ༌ཏེས༌ སུ༌ཞིག༌ ཕི༌ལོག༌ག༌ སོང༌ཏེ༌ ལམ༌མི༌ཀ༌ སད༌ན༌ ཏེ༌བོ༌ ང༌ཞའེ༌ སྐྱོན༌ མན༌, ཨིན༌ནའང༌ སུ༌ཞིག༌གི༌ འི༌ ཁང༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌གུན༌ནི༌ཀ༌ ལག༌པ༌ རྐྱངས༌ཏེ༌ སད༌ན༌, ཏེ༌བོ༌ ཕིའ༌ ང༌ཞའ༌ ནོངས༌ཅན༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","ཁྱོ༌རང༌ངི༌ ང༌ཞའེ༌ ཐབ༌ལྡིངས༌གུན༌ ཤད༌ན༌, ཏེ༌ནེ༌ ང༌ཞ༌གུན༌ འི༌ ནའ༌ ཁུར༌ཁན༌བོའེ༌ ཀ༌ནེ༌ བུད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","བུ༌མོའེ༌ ལན༌ཏངས༌, “ཁྱོ༌ཞའེ༌ ཟེར༌ཁན༌བོ༌ ངའེ༌ ཅོ༌ཨིན༌།” ཁོའེ༌ ཁོང༌གུན༌ ལོགས༌ཏེ༌ ལམ༌ཅུགས༌ ཡང༌ རས༌ མར༌པོ༌བོ༌ ཀར༌ཁུང༌ངི༌ཀ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","ཙལ༌ཁན༌གུན༌ནི༌ ཀ༌རུང༌ས༌ ཙལ༌ཏེ༌ ཁོང༌གུན༌ མ༌ཐོབ༌བ༌ ལོགས༌ཏེ༌ ཆ༌ཆ༌ ཚག༌པ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཉིས༌ཀོ༌ རི༌ ནང༌ང༌ ཨིབས༌ཏེ༌ ཞག༌མ༌ སུམ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","ཏེ༌ནེ༌ ཁོང༌ ཉིས༌ཀོ༌ རི༌ནེ༌ བབས༌ཏེ༌ ཡོངས༌ ཡང༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཡོ༌ཤུའ༌ ཡོད༌ས༌ སོང༌ ཡང༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཇུང༌ཁན༌ ཚང༌མ༌ ཁོའ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","ཁོང༌གུན༌ནི༌ ཟེརས༌, “ཏན༌ཏན༌ ཡ༌ཝའེ༌ ང༌དང༌གུན༌ལ༌ ཏེ༌ ས༌ཀྱད༌ གང༌པོ༌ སལ༌ཏེ༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌རུ༌ དུག༌ཁན༌ མི༌ཚང༌མ༌ ང༌དང༌གུན༌ལ༌ མ༌སྲན༌ཏྲེ༌ ཇིགས༌ཏེ༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","ཐོ༌རེ༌ ཟུག༌པོ༌ ང༌མོ༌ ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཤིཏ༌ཏིམ༌ ནེ༌ བིང༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ ཆོགས༌ལ༌ སོང༌ ཡང༌ ལྩངས༌པོ༌ རྒལ༌ལི༌ སང༌ སྔུན༌ལ༌ ཁོང༌གུན༌ ཏེ༌བོའེ༌ ཐའ༌མ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","ཞག༌མ༌ སུམ༌མི༌ སྟིང༌ནེ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ གོ༌སྐྱོང༌གུན༌ ཀུར༌ ཙུག༌སའེ༌ ནས༌ས༌ གང༌པོའེ༌ ནང༌ང༌ སོང༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","མི༌གུན༌ལ༌ ལབ༌ཞ༌ ཏང༌ཨིན༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ ལི༌ཝི༌པ༌ བླ༌མ༌གུན༌ནི༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཏེ༌ ཆའ༌ ཐོང༌ང༌ཅིག༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ ཁྱོ༌ཞའ༌ ཁོང༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ ཆ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","ཏེ༌ནེ༌ ཁྱོ༌ཞའ༌ ཆ༌ཅེས༌སི༌ ལམ༌བོ༌ ཤེས༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ང༌དང༌ འི༌ ལམ༌ ནེ༌ མ༌ནེ༌ མ༌ཆའ༌ ཨིན༌ནོག༌། ཨིན༌ནའང༌ ཁྱོ༌ཞའ༌ དང༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ ནང༌ང༌ མི༌ཀྲར༌ 900 པར༌ བོར༌གོས༌, སྒམ༌མི༌ ཉེ༌མོའ༌ མི༌ ཡོང༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞ༌རང༌གུན༌ རྩང༌མ༌ ཅོས༌ ཅིའ༌ཟེར༌ན༌ ཐོ༌རེ༌ ཡ༌ཝའེ༌ ང༌དང༌གུན༌ནི༌ ཕྲོའ༌ ཧ༌ལས༌ཤེས༌སི༌ ཆག༌ལས༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","ང༌ཏོག༌ ཡོ༌ཤུའེ༌ བླ༌མ༌གུན༌ལ༌ ཟེརས༌, “ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཏེ༌ མི༌གུན༌ནི༌ སང༌ སྔུན༌ལ༌ གྲུལ༌།” ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཏེ༌ མི༌གུན༌ནི༌ སང༌ སྔུན༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “དི༌རིང༌ ནེ༌ པར༌ལ༌ ངའེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཕྲོའ༌ ཁྱོ༌རང༌ གོ༌སྐྱོང༌ ཀྲག༌པོ༌ཞིག༌ གྱུར༌ཅུག༌ཨིན༌, ཏེ༌ནེ༌ ཁོང༌གུན༌ལ༌ ང༌ མོ༌ཟེས༌ ཉམ༌པོ༌ ཡོད༌ད༌ ཙོགས༌ ཁྱོ༌རང༌ ཉམ༌པོའང༌ ཡོད༌ཁན༌བོ༌ ཧ༌གོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ནི༌ བླ༌མ༌གུན༌ལ༌ ཟེར༌, ‘ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཐའ༌མ༌ ལེབ༌བ༌ཅིག༌, ལྩངས༌པོའེ༌ ཆུའི༌ ནང༌ང༌ ཀོམ༌པ༌ ཁ༌ཅིག༌ སོང༌ ཡང༌ ཏེ༌ཀ༌ ལངས༌ཏེ༌ དུག༌།’” ");
INSERT INTO lbj_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེརས༌, “ཡོང༌, ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌གུན༌ ངའེ༌ ཁྱོ༌ཞའ༌ ཤད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","དི༌རིང༌ སོན༌པོ༌ དཀོན༌མཆོག༌ ང༌དང༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཁོང༌ངི༌ ཀེ༌ནན༌པ༌, ཧེད༌པ༌, ཧིཝ༌པ༌, པེ༌རིཟ༌པ༌, གིར༌གཤ༌པ༌, ཨ༌མོར༌པ༌ དང༌ ཡེ༌བས༌པ༌ གུན༌ འི༌ ས༌ཆའེ༌ ནང༌ནེ༌ ཏན༌ཏན༌ ཕིང༌ང༌ ཛད༌ཅེས༌པོ༌ ང༌དང༌གུན༌ལ༌ ཧ༌གོ༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","ལྟོས༌། ཇིག༌རྟེན༌ གང༌པོའེ༌ཀ༌ ཝང༌སྲུལ༌ལ༌ ཛད༌ཁན༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ ང༌དང༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཁྲིད༌ཏེ༌ ཁྱེར༌ར༌ ཛད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","ཏ༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌གུན༌ ནེ༌ མི༌ རྕུག༌ཉིས༌ ལྡོམ༌ཤིག༌, སྡེ༌ རེ༌རེ༌ ནེ༌ མི༌ རེ༌རེ༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","ཇིག༌རྟེན༌ གང༌པོའ༌ ཝང༌སྲུལ༌ལ༌ ཛད༌ཁན༌ནི༌ ཡ༌ཝའེ༌ སྒམ༌ ཁུར༌ཁན༌ བླ༌མ༌གུན༌ནི༌ རྐང༌པ༌ ཆུའ༌ ཐུག༌ག༌ཅིག༌ གྱེན༌ནེ༌ ཡོང༌ཁན༌ནི༌ ཆུ༌ གྱུག༌མ༌གྱུག༌ག༌ རྩིག༌པ༌ ཙོགས༌ལ༌ ལངས༌ཏེ༌ དུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","ཏེ༌ནེ༌ མི༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཅེས༌ལ༌ ཀུར༌གུན༌ ལྡུམས༌ཏེ༌ བིང༌ ཡང༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ བླ༌མ༌གུན༌ ཁོང༌གུན༌ནི༌ སྔུན༌སྔུན༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","༼ཏ༌ ཏེ༌ཏུས༌པོ༌ རྔབ༌སའེ༌ ཏུས༌ ཡང༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཆུ༌ ཕེལ༌ཏེ༌ ཐའ༌མ༌ནེ༌ ཐལ༌ཏེ༌ ཆའད༌པིན༌༽ ཨིན༌ནའང༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ནི༌ བླ༌མ༌གུན༌ནི༌ རྐང༌པ༌ ལྩངས༌པོའེ༌ ཆུའ༌ ཐུག༌ག༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","གྱེན༌ནེ༌ ཡོང༌ཁན༌ནི༌ ཆུ༌ གྱུག༌མ༌གྱུག༌ག༌, མ༌ཐག༌རིང༌ང༌ ཡོད༌ཁན༌ ཟ༌རེ༌ཐན༌ནི༌ ཉེ༌མོའ༌ ཨ༌དམ༌མི༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ རྩིག༌པ༌ ཙོགས༌ལ༌ ཁྱིལ༌ཏེ༌ དུགས༌ ཡང༌ ཐུར༌ལ༌ ཨ༌ར༌བཧའེ༌ ཚོ༌ ཡང༌ན༌ ཚོ༌རུལ༌ ཆོགས༌ལ༌ གྱུག༌ཁན༌ནི༌ ཆུ༌ ཆད༌། ཏེ༌ནེ༌ མི༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཡེ༌རི༌ཀོ༌ ཆོགས༌ལ༌ ཆ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","ས༌སྐམ༌པོའེ༌ ཀ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ལེབ༌ལེབ༌ ཚག༌པ༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ བླ༌མ༌གུན༌ ལྩངས༌པོའེ༌ སྐྱིལ༌ལ༌ ས༌སྐམ༌པོའེ༌ཀ༌ ལངས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","མི༌ཚང༌མ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ ཚར༌ར༌ཅིག༌ ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“ཏ༌ མི༌ རྕུག༌ཉིས༌ ལྡོམ༌, སྡེ༌ རེ༌རེ༌ནེ༌ མི༌ རེ༌རེ༌, ");
INSERT INTO lbj_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ཡང༌ ཁོང༌གུན༌ལ༌, ‘བླ༌མ༌གུན༌ ལངས༌ཏེ༌ ཡོད༌སའེ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ སྐྱིལ༌ནེ༌ རྡོའ༌ རྕུག༌ཉིས༌ ཁུར༌ཏེ༌ ང༌དང༌གུན༌ དི༌རིང༌ ཚན༌ལ༌ དུག༌སའེ༌ ནས༌སའེ༌ཀ༌ ཁྱོང༌’ ཟེར༌།” ");
INSERT INTO lbj_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ མི༌ རྕུག༌ཉིས༌, སྡེ༌ རེ༌རེ༌ནེ༌ མི༌ རེ༌རེ༌ ལྡམས༌ཁན༌གུན༌ བོད༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཡོར༌དཱན༌ནི༌ སྐྱིལ༌ལ༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁྱོ༌ཞའ༌ རེ༌རེ༌ རྡོའ༌ རེ༌རེ༌ སྤུང༌པའེ༌ཀ༌ ཁུར༌ཏེ༌ ཁྱོང༌། ཨིས༌ར༌ཨེལ༌ལི༌ སྡེའེ༌ རེ༌རེའེ༌ ཕིའ༌ རྡའ༌ རེ༌རེ༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","འི༌ རྡོའ༌གུན༌ནི༌ ཡ༌ཝའེ༌ ང༌དང༌ངི༌ ཕིའ༌ ཛད༌ཁན༌ ཚང༌མ༌ ཨིད༌ཏུ༌ སྐུལ༌ཨིན༌། མ༌ཡོངས༌པའེ༌ ཏུས༌སི༌ ནང༌ང༌ ནམ༌ ང༌དང༌ངི༌ ཕྲུ༌གུ༌གུན༌ནི༌, ‘འི༌ རྡོའ༌གུན༌ནི༌ ཏོན༌ ཅི༌ ཨིན༌ནོག༌?’ ཟེར༌ཏེ༌ ཏྲི༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","ཁྱོ༌ཞའེ༌ ཁོང༌གུན༌ལ༌ ཟེར༌, ‘ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ དུན༌ལ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ གྱུག༌མ༌གྱུག༌ག༌ དུགས༌། བླ༌མ༌གུན༌ནི༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཏེ༌ ཆའ༌ཅིག༌ ལྩངས༌པོའེ༌ ཆུ༌ གྱུག༌མ༌གྱུག༌ག༌ དུགས༌། ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ འི༌ རྡོའ༌གུན༌ ཏུས༌གྱུན༌ ལུས༌ཤེས༌སི༌ དྲན༌སོའེ༌ སྟགས༌ཤིག༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཏེ༌ མི༌གུན༌ནི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ སྐྱིལ༌ནེ༌ རྡོའ༌ རྕུག༌ཉིས༌, སྡེ༌ རེ༌རེ༌ ཕིའ༌ རྡའ༌ རེ༌རེ༌ ཁུར༌ཏེ༌ ཁོང༌གུན༌ ཚན༌ལ༌ དུག༌སའེ༌ ནས༌སའེ༌ཀ༌ ཁྱོངས༌ ཡང༌ ཏེ༌གུན༌ རྩིགས༌ཏེ༌ དྲན༌སོའེ༌ སྟགས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ སྐྱིལ༌ལ༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ བླ༌མ༌གུན༌ ལངས༌ཏེ༌ དུག༌སའེ༌ཀ༌ ཡོ༌ཤུའེ༌ ཞན༌ རྡོའ༌ རྕུག༌ཉིས༌ སྤུངས༌། དག༌སའང༌ ཏེ༌གུན༌ ཏེན༌ན༌ ནས༌སའེ༌ཀ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","ཡ༌ཝའེ༌ མོ༌ཟེས༌ གྱུད༌ཏེ༌ ཡོ༌ཤུའ༌ སལ༌ཁན༌ བཀའ༌ ཚང༌མ༌ གྲུབ༌གྲུབ༌ ཚག༌པ༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ བླ༌མ༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ སྐྱིལ༌ལ༌ ལངས༌ཏེ༌ དུགས༌། ཏེན༌ན༌ ཏུས༌ལ༌ མི༌གུན༌ ས༌སྐམ༌པོའེ༌ ཀ༌ནེ༌ གྱོགས༌པ༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","མི༌ ཚང༌མ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཁམ༌ཟང༌ ལེབས༌ཏེ༌ ལྟེན༌ཡོད༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ སྒམ༌ ཁུར༌ཁན༌ བླ༌མ༌གུན༌ནའང༌ འ༌ངོ༌ ཆོགས༌ལ༌ བིང༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","མོ༌ཟེས༌སི༌ བཀའ༌ ནང༌ཞིན༌ རུ༌བེན༌ དང༌ གཱད༌ སྡེ༌ ཡང༌ མ༌ནས༌སའེ༌ སྡེ༌ ཕེད༌དི༌ མག༌མི༌གུན༌ མག༌ཆ༌ ཁུར༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གོ༌ཁྲིད༌ ཅོས༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","མག༌ཆ༌ ཁུར༌ཁན༌ནི༌ མག༌མི༌ ནོལ༌ ཆོག༌ཆོག༌ ཡོད༌ཁན༌ ཧ༌ལམ༌ 40,000 ལྩངས༌པོ༌ རྒལ༌ཏེ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཡེ༌རི༌ཀོའེ༌ ཐང༌ང༌ སོང༌ ཡང༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཡ༌ཝ༌ ཞུགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","ཏེན༌ན༌ ཞག༌ག༌ ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ དུན༌ལ༌ ཡོ༌ཤུའ༌ སྤལ༌ ཐོབ༌ཅུག༌ག༌ ཛདས༌། ཡང༌ ཁོང༌གུན༌ནི༌ ཡོ༌ཤུའ༌, མི༌ཚེའེ༌ གང༌པོ༌ རྩི༌ཝ༌ སྟནས༌ ཀ༌ཟུག༌ ཁོང༌གུན༌ནི༌ མོ༌ཟེས༌ལ༌ སྟན༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ བླ༌མ༌གུན༌ལ༌ ལྩངས༌པོའེ༌ ནང༌ནེ༌ བིང༌ཏེ༌ ཡོང༌ཅེས༌ལ༌ བཀའ༌ ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ བླ༌མ༌གུན༌ལ༌ བིང༌ཏེ༌ ཡོང༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ བླ༌མ༌གུན༌ ལྩངས༌པོ༌ ནང༌ནེ༌ ཕི༌ལོག༌ག༌ བིང༌ཏེ༌ ཡོངས༌ ཡང༌ ཁོང༌གུན༌ནི༌ རྐང༌པ༌ ལྩངས༌པོའེ༌ ཐའ༌མའེ༌ ས༌ཀྱད༌དི༌ཀ༌ བོར༌ར༌ཅིག༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ སྔུན༌མ༌ ཙོགས༌ལ༌ གྱུགས༌ ཡང༌ ཆུ༌ ཐའ༌མ༌ནེ༌ ཐལ༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","ཟླ༌ཝ༌ ཏང༌པོའེ༌ ཞག༌ 10 པའེ༌ ཞག༌ག༌ མི༌ཚང༌མ༌ ཡོར༌དཱན༌ནེ༌ སོང༌ཏེ༌ ཡེ༌རི༌ཀོའེ༌ ཤར༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ གིལ༌གལ༌ ནས༌སའེ༌ ནང༌ང༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","ཡོ༌ཤུའེ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ནང༌ནེ༌ ཁྱོང༌ཁན༌ རྡོའ༌ རྕུག༌ཉིས༌པོ༌ འིན༌ན༌ གིལ༌གལ༌ལི༌ ནས༌སའེ༌ཀ༌ རྩིགས༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེརས༌, “མ༌ཡོངས༌པའེ༌ ཏུས༌སི༌ ནང༌ང༌ ཁྱོ༌ཞའེ༌ ཕྲུ༌གུ༌གུན༌ནི༌ ‘འི༌ རྡོའ༌ རྩིགས༌ཁན༌བོའེ༌ ཏོན༌ ཅི༌ ཨིན༌ནོག༌?’ ཟེར༌ཏེ༌ ཏྲི༌ན༌ ");
INSERT INTO lbj_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","ཁོང༌གུན༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ས༌སྐམ༌པོའེ༌ ཀ༌ནེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཡོངས༌ཁན༌བོ༌ ཤོད༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","ང༌དང༌ ཚང༌མ༌ རྒལ༌ཏེ༌ ཆ༌ ཚར༌ཚར༌ ཚག༌པ༌ ང༌དང༌ངི༌ མིག༌གི༌ དུན༌ལ༌ ང༌དང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ལྩངས༌པོ༌ སྐམ༌པོ༌ བོར༌ར༌ ཛདས༌། ཡ༌ཝའེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ སྐམ༌ ཤུག༌ག༌ ཛདས༌ ཀ༌ཟུག༌ ང༌དང༌ངི༌ ཕ༌མ༌གུན༌ནི༌ མིག༌གི༌ དུན༌ལ༌ ཁོང༌གུན༌ རྒལ༌ཏེ༌ ཆ༌ ཚར༌ཚར༌ ཡ༌ཝའེ༌ ཚོ༌ མར༌པོ༌ སྐམས༌ ཤུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","ཇིག༌རྟེན༌པ༌ ཚང༌མའེ༌ ཁོང༌ སྟོབས༌ཤུགས༌ཅན༌ ཨིན༌ཁན༌བོ༌ ཧ༌གོ༌ཅེས༌ ཡང༌ ཏུས༌གྱུན༌ ཁྱོ༌ཞའེ༌ ཁོང༌ངི༌ ཇིགས༌སི༌ ནང༌ང༌ མི༌ཚེའེ༌ པུད༌ཅེས༌ལ༌ ཡ༌ཝའེ༌ ཏེ༌བོ༌ ཅོའ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","ཏ༌ ཡོར༌དཱན༌ནི༌ ནུབ༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ ཨ༌མོར༌པའེ༌ གྱལ༌པོ༌ ཚང༌མའ༌ ཡང༌ ཚོའེ༌ ཐའ༌མ༌ དུག༌ཁན༌ ཀེ༌ནན༌པ༌ གྱལ༌པོ༌ ཚང༌མའེ༌, ཡ༌ཝའེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ སྐམས༌ཅུག༌ག༌ ཛད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ རྒལ༌ཏེ༌ ཡོང༌ཁན༌བོ༌ ཚོར༌ར༌ཅིག༌ ཁོང༌གུན༌ མ༌ སྲན༌ཏྲེ༌ ཇིགས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ཅེས༌སི༌ སྤོས༌པ༌ ཆགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","ཏེན༌ན༌ ཏུས༌ལ༌ ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “རྡོའ༌ སྲ༌མོའེ༌ ཀྲི༌གུན༌ ཅོས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌ མི༌རབས༌ ཉིས༌པའེ༌ བུ༌ཚ༌གུན༌ལ༌ སུན༌ནད༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཡོ༌ཤུའེ༌ རྡོའ༌ སྲ༌མོའེ༌ ཀྲི༌གུན༌ ཅོས༌ཏེ༌ གི༌བེ༌འད༌ ཧ༌ར༌ལོད༌དི༌ ནང༌ང༌ ཨིས༌ར༌ཨེལ༌པ༌ བུ༌ཚ༌ ཚང༌མའ༌ སུན༌ནད༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","ཁོང༌གུན༌ལ༌ སུན༌ནད༌ ཅོ༌ ཅུགས༌ ཅིའ༌ཟེར༌ན༌ ཨི༌ཇིབ༌ནེ༌ བིངས༌ཏེ༌ ཡོངས༌ཏེ༌ སྟིང༌ནེ༌ མག༌གི༌ ནང༌ང༌ ནོལ༌ ཉན༌ཅེས༌ཅན༌ བུ༌ཚ༌ ཚང༌མ༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཤི༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","ཨི༌ཇིབ༌ནེ༌ ཡོངས༌ཁན༌ བུ༌ཚ༌ ཚང༌མའ༌ སུན༌ནད༌ ཅོས༌ཏེ༌ ཨིན༌ནའང༌ ཐང༌སྟོང༌ང༌ བེས༌སི༌ ནང༌ང༌ ཡོད༌ཏུས༌ སྐྱེས༌ཁན༌ བུ༌ཚ༌ ཚང༌མའ༌ སུན༌ནད༌ མ༌ཅོའ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ལོ༌ ཞིབ༌ཅུ༌ ཁོར༌ཨིན༌ ལུས༌ ཡང༌ ཨི༌ཇིབ༌ནེ༌ བིངས༌ཏེ༌ ཡོང༌ཁན༌ མག༌གི༌ ནང༌ང༌ ནོལ༌ ཉན༌ཅེས༌ཅན༌ བུ༌ཚ༌ ཚང༌མ༌ ཡ༌ཝའེ༌ ཁའ༌ མི༌ཉན༌ཅེས༌པའེ༌ ཤི༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ ང༌དང༌ངི༌ ཕ༌མེས༌པོ༌གུན༌ལ༌ འོ༌མ༌ དང༌ རང༌རྩི༌ གྱུག༌ཁན༌ནི༌ ས༌ཆའ༌ ང༌དང༌ང༌ སལ༌ཨིན༌ མོལ༌ཏེ༌ ཆད༌དོན༌ ཛད༌ཁན༌ནི༌ ཏེ༌ ས༌ཆའ༌, ཁོང༌གུན༌ལ༌ མི༌ཐོང༌ མོལ༌ཏེ༌ ཡ༌ཝའེ༌ ནའ༌ ཁུར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","ཏེ༌ ཁའ༌ མ༌ཉན༌ཁན༌གུན༌ནི༌ བུ༌ཚ༌གུན༌ལ༌ ཡོ༌ཤུའེ༌ སུན༌ནད༌ ཅོ༌ཅུགས༌། ཐང༌སྟོང༌ངི༌ ནང༌ང༌ བེས༌ལ༌ ཡོད༌ཏུས༌ ཁོང༌གུན༌ལ༌ སུན༌ནད༌ མ༌ཅོའ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","བུ༌ཚ༌ ཚང༌མའ༌ སུན༌ནད༌ ཅོས༌ཏེ༌ སྟིང༌ནེ༌ ཁོང༌ ཚང༌མ༌ ཕན༌ཕན༌, ཏེན༌ན༌ ནས༌སའེ༌ཀ༌ ངལ༌ཚོས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཚེ༌ཡོག༌ག༌ དུག༌གོས༌ཁན༌ནི༌ ཁྲེལ༌བ༌བོ༌ དི༌རིང༌ ངའེ༌ ཁྱོ༌ཞའེ༌ ཀ༌ནེ༌ ཐེན༌ནད༌།” ཏེ༌བོའེ༌ཕིའ༌ ཏེ༌ ས༌ཀྱད༌པོའ༌ དག༌སའང༌ གིལ༌གལ༌ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","ཏེན༌ན༌ ཟླ༌ཝའེ༌ ཞག༌ 14 པའེ༌ ཕི༌ཏོག༌ ཀུར༌ ཙུགས༌ཏེ༌ དུག༌ས༌ ཡེ༌རི༌ཀོའེ༌ སྤང༌ཐང༌ངི༌ གིལ༌གལ༌ ནས༌སའེ༌ ནང༌ང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ པེ༌སག༌གི༌ ཏུས༌ཆེན༌ རྩིས༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","སྟིང༌མ༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ ཏེན༌ན༌ ས༌ཀྱད༌ནེ༌ སྨིན༌ཁན༌ སྙེ༌མ༌ སྲགས༌ཁན༌ དང༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཟོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཏེ༌ ནས༌སའེ༌ སྟོན༌ཐོག༌ ཟའེ༌ ཞག༌ནེ༌ ཕར༌ལ༌ ནམ༌ཁའ༌ནེ༌ མན༌ན༌ མ༌བབས༌, ཁོང༌གུན༌ནི༌ ཏེ༌བོ༌ ཡང༌སྐྱར༌ མ༌ནེ༌ མ༌ཟོས༌། ཁོང༌གུན༌ནི༌ ཏེན༌ན༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ སྨིན༌ཁན༌ སྟོན༌ཐོག༌ ཟོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","ཡོ༌ཤུའ༌ ཡེ༌རི༌ཀོའེ༌ གྱལ༌སའེ༌ ཉེ༌མོའ༌ ཡོད༌ ཟ༌ནེ༌ ཁོའེ༌ ཀེན༌ལ༌ ལྟས༌པ༌ ཁོའ༌, ལག༌པའེ༌ ནང༌ང༌ ར༌འི༌ ཁུར༌ཁན༌ མི༌ཞིག༌ ཁོའེ༌ དུན༌ལ༌ ལངས༌ཏེ༌ ཐོང༌། ཡོ༌ཤུའ༌ ཁོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཏྲིས༌, “ཁྱོ༌རང༌ ང༌ཞའེ༌ ཆོགས༌ལ༌ ཨིན༌ན༌ ཡ༌ གྲ༌འོའེ༌?” ");
INSERT INTO lbj_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","མི༌བོའེ༌ ལན༌ཏངས༌, “སུའི༌ ཆོགས༌ལའང༌ མན༌། ང༌ ཡ༌ཝའེ༌ མག༌མི༌གུན༌ནི༌ སྤོན༌བོ༌ ཨིན༌།” ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ སྐུས༌པ༌ སྟན༌ཏེ༌ ཁོང༌ངི༌ ཞབས༌སི༌ དུན༌ལ༌ ཆག༌ཕུལས༌ ཡང༌ ཟེརས༌, “ངའེ༌ སྤོན༌བོ༌, ཉེ༌རང༌ངི༌ ཡོག༌པོའེ༌ ཕིའ༌ ཅི༌ ལོན༌ ཁྱོང༌ང༌ ཛད༌ཏེ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","ཡ༌ཝའེ༌ མག༌མི༌ སྤོན༌བོའེ༌ ལན༌སལས༌, “ཁྱོ༌རང༌ངི༌ པ༌བུ༌ ཕུད༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ ལངས༌ཏེ༌ ཡོད༌སའེ༌ ནས༌ས༌ ཏམ༌པ༌ ཨིན༌།” ཡོ༌ཤུའེ༌ ཁོང༌ངི༌ མོལ༌ཁན༌བོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","ཏ༌ ཡེ༌རི༌ཀོའེ༌ གྱལ༌སའེ༌ གྱས༌སྒོ༌ སྟན༌པོ༌ ཅུགས༌ཏེ༌ སུའང༌ གྱལ༌ས༌ནེ༌ ཕི༌ལོག༌ ཡ༌ ནང༌ང༌ ཆ༌ཡོང༌ མ༌ཏངས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཇིགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “ངའེ༌ ཡེ༌རི༌ཀོ༌ གྱལ༌ས༌, ཏེ༌བོའེ༌ གྱལ༌པོ༌ དང༌ མག༌མི༌གུན༌ ཁྱོ༌རང༌ངི༌ ལག༌ག༌ སྟད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ མག༌མི༌ ཚང༌མའེ༌ ཞག༌མ༌ དྲུག༌, གྱལ༌སའ༌ ཞག༌ཏང༌ ལན༌ ཅིག༌ སྐོར༌ར༌ ཏོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","བླ༌མ༌ རྡུན༌ལ༌ ར༌ཅོའེ༌ ཏུང༌ ཁུར༌ཏེ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ སྔུན༌ལ༌ གྲུལ༌ཅུག༌། ཞག༌ རྡུན༌པའེ༌ ཞག༌ག༌ བླ༌མ༌གུན༌ནི༌ ཏུང༌ ཕུ༌ཨིན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གྱལ༌སའ༌ ལན༌ རྡུན༌ སྐོར༌ར༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","བླ༌མ༌གུན༌ནི༌ ཏུང༌སྐད༌ རིང༌མོ༌ ཕུའ༌ ཚོར༌ར༌ཅིག༌ ཁྱོ༌ཞའ༌ ཚང༌མའེ༌ ཀུ༌ཅོ༌ སྲན༌ཏྲེ༌ ཏང༌གོས༌། ཏེ༌ནེ༌ གྱལ༌སའེ༌ རྩིག༌པ༌ རྡིབས༌ཏེ༌ ཁྱོ༌ཞའ༌ ཚང༌མ༌ ནོལ༌ཅེས༌ལ༌ གྱལ༌སའེ༌ ནང༌ང༌ རྒྱུགས༌ཏེ༌ ཆ༌ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","ཡོ༌ཤུའེ༌ བླ༌མ༌གུན༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཟེརས༌, “ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ ཡང༌ བླ༌མ༌ རྡུན༌ལ༌ ར༌ཅོའེ༌ ཏུང༌ ཁུར༌ཏེ༌ སྒམ༌མི༌ སྔུན༌ལ༌ གྲུལ༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","ཏེ༌ནེ༌ ཁོའེ༌ མག༌མི༌གུན༌ལ༌ བཀའ༌ ཏངས༌, “ཚོན༌ཆ༌ ཁུར༌ཁན༌ནི༌ མག༌མི༌ ཁ༌ཅིག༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ སྔུན༌ལ༌ གྲུལ༌ ཅུག༌ཨིན༌ ཁོང༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ མག༌མི༌ ཚང༌མ༌ གྱང༌སྐོར༌རི༌ ཕི༌ལོག༌ནེ༌ གྱལ༌སའ༌ སྐོར༌ར༌ ཏང༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","ཡོ༌ཤུའེ༌ མི༌གུན༌ལ༌ བཀའ༌ ཏངས༌ ཚར༌ར༌ཅིག༌, ཏུང༌ ཁུར༌ཁན༌ནི༌ བླ༌མ༌ རྡུན༌བོ༌ ཏུང༌ ཕུ༌ཨིན༌ གྲུལ༌ཅེས༌ གོ༌ཟུག༌ ཡང༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌གུན༌ ཁོང༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","ཚོན༌ཆ༌ ཁུར༌ཁན༌ནི༌ མག༌མི༌གུན༌ ཏུང༌ ཕུ༌ཁན༌ནི༌ བླ༌མ༌གུན༌ནི༌ སྔུན༌ལ༌ ཡང༌ ཞན༌ མག༌མི༌གུན༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ གྱབ༌ནེ༌ གྲུལས༌། ཏུས༌ གང༌པོ༌ བླ༌མ༌གུན༌ནི༌ ཏུང༌ ཕུའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","ཡོ༌ཤུའེ༌ བཀའ༌ ཏངས༌, “ཀུ༌ཅོ༌ མ༌ཏང༌, སྤེ༌རའང༌ མ༌ཏང༌, ནམ༌ཚོག༌པ༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཀུ༌ཅོ༌ ཏང༌ཅེས༌ལ༌ མི༌ཟེར༌། ངའེ༌ ཟེར༌རི༌ ཞག༌ག༌ ཁྱོ༌ཞའེ༌ ཀུ༌ཅོ༌ ཏོང༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ལ༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཏེ༌ གྱལ༌ས༌ སྐོར༌ར༌ ལན༌ཅིག༌ ཏང༌ཅུགས༌། ཏེ༌ སྟིང༌ནེ༌ ཚན༌ ཕུད༌ད༌ལ༌ ཚང༌མ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུག༌ས༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","ཐོ༌རེ༌ཟུག༌པོ༌ ཡོ༌ཤུའ༌ ང༌མོ༌ནེ༌ ལངས༌ ཡང༌ བླ༌མ༌གུན༌ནི༌ ཡང༌སྐྱར༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌ ཁུརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","ཏུང༌ ཁུར༌ཁན༌ བླ༌མ༌ རྡུན༌ཀོ༌ ཏུང༌ ཕུ༌ཨིན༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ དུན༌ལ༌ གྲུལས༌། ཡང༌སྐྱར༌ ཚོན༌ཆ༌ ཁུར༌ཁན༌ནི༌ མག༌མི༌གུན༌ ཏུང༌ ཁུར༌ཁན༌ནི༌ བླ༌མ༌གུན༌ནི༌ སྔུན༌ལ༌ ཡང༌ ཞན༌ མག༌མི༌གུན༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ གྱབ༌ནེ༌ གྲུལས༌། བླ༌མ༌གུན༌ནི༌ ཏུས༌ གང༌པོ༌ ཏུང༌ ཕུས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ཞག༌ ཉིས༌པའེ༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ གྱལ༌ས༌ སྐོར༌ར༌ ཏངས༌ ཡང༌ ཁོང༌རང༌གུན༌ དུག༌ས༌ ལོགས༌ཏེ༌ སོང༌། ཏེན༌ན༌ ཙོགས༌ ཁོང༌གུན༌ནི༌ ཞག༌པོ༌ དྲུག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ཞག༌ རྡུན༌པའེ༌ ཞག༌ག༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ནམ༌ལངས༌ལ༌ ལངས༌ཏེ༌ སྔུན༌ ཙོགས༌ལ༌ གྱལ༌ས༌ སྐོར༌ར༌ ཏངས༌། ཨིན༌ནའང༌ ཏེ༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ སྐོར༌ར༌ ལན༌ རྡུན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","ལན༌ རྡུན༌པའེ༌ཀ༌ བླ༌མ༌གུན༌ནི༌ ཏུང༌ རིང༌མོ༌ ཕུའ༌ཅིག༌ ཡོ༌ཤུའེ༌ མི༌གུན༌ལ༌ བཀའ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཀུ༌ཅོ༌ ཏོང༌ཤིག༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ ང༌དང༌གུན༌ལ༌ གྱལ༌ས༌ སལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","ཡ༌ཝའ༌ ཆོད༌པའེ༌ ཚུལ༌ལ༌ གྱལ༌ས༌ དང༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁྲེས༌ཏོར༌ ཅོ༌གོས༌། ཟུགས༌ཙོང༌མ༌ ར༌ཧབ༌ དང༌ ཁོའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ སད༌ མ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ང༌དང༌ངི༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ལྟའ༌ ཀལ༌ཁན༌ ཉིས༌ཀོ༌ སྐྱོབས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","ཁྲེས༌ཏོར༌ ཅོས༌ཏེ༌ ཡ༌ཝའ༌ ཕུལ༌ཁན༌ནི༌ ནང༌ནེ༌ ཅའང༌ མི༌ ཁྱེར༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌ ཏེ༌མན༌ན༌ ཁྱོ༌ཞ༌རང༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ཀ༌ རྡུག༌ངལ༌ ཀྲག༌པོ༌ ཁྱོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","མུལ༌ དང༌ སེར༌ ཡང༌ ར༌གན༌ དང༌ ལྕགས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌ ཏམ༌པ༌ ཨིན༌ པ༌སང༌ ཡ༌ཝའེ༌ ཨིན༌ནོག༌། ཏེ༌གུན༌ ཁོང༌ངི༌ བང༌ཛོད༌དི༌ ནང༌ང༌ ཁྱོང༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","ཏུང༌ སྐད༌ རིང༌མོ༌ ཚོར༌ར༌ཅིག༌ མག༌མི༌གུན༌ནི༌ ཀུ༌ཅོ༌ སྲན༌ཏྲེ༌ ཏངས༌, ཧུན༌མེད༌ལ༌ ཡེ༌རི༌ཀོའེ༌ གྱང༌སྐོར༌ རྡིབས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌ མག༌མི༌གུན༌ གྱལ༌སའེ༌ ནང༌ང༌ རྒྱུགས༌ཏེ༌ སོང༌ ཡང༌ ཏེ༌བོ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","ཁོང༌གུན༌ནི༌ ར༌འི༌ ཉམ༌པོ༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌, ཞུ༌ནུ༌ དང༌ རྒད༌པོ༌, བ༌ལང༌, ལུག༌, ར༌མ༌ དང༌ བུང༌བུ༌ ཚང༌མ༌ སད༌ཏེ༌ མེད༌ཁན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","ཏེན༌ན༌ ཟ༌ནེ༌ ཡོ༌ཤུའེ༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ལྟའ༌ ཀལ༌ཁན༌ མི༌ ཉིས༌ཀོའ༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ ཁ༌ཆད༌ ནང༌ཞིན༌ ཟུགས༌ཙོང༌མའེ༌ ཁང༌པ༌ སོང༌ཏེ༌ ཁོ༌ དང༌ ཁོའེ༌ ནང༌ཚངས༌ གུན༌ ཕི༌ལོག༌ག༌ ཕིངས༌ཏེ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","ཁོང༌ ཉིས༌ཀོ༌ སོང༌ཏེ༌ ར༌ཧབ༌, ཁོའེ༌ ཨ༌བ༌, ཨ༌མ༌, ཨ༌ཅོ༌ནོ༌ དང༌ ཉེན༌གྲུང༌, ཁོ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཕིངས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ དུགས༌སའེ༌ ཕི༌ལོག༌ག༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱལ༌ས༌ དང༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེའ༌ ཏུགས༌། མུལ༌, སེར༌, ར༌གན༌ དང༌ ལྕགས༌སི༌ ཅ༌ལག༌ ཚང༌མ༌ ཡ༌ཝའེ༌ བང༌ཛོད༌དི༌ ནང༌ང༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","ཨིན༌ནའང༌ ཡོ༌ཤུའེ༌ ཟུགས༌ཙོང༌མ༌ ར༌ཧབ༌ དང༌ ཁོའེ༌ ཉེན༌གྲུང༌གུན༌ མ༌ སདས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཡེ༌རི༌ཀོའེ༌ ནང༌ང༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ལྟའ༌ ཀལ༌ཁན༌ མི༌གུན༌ སྐྱོབས༌ཏེ༌ ཨིན༌པིན༌ ཡང༌ ཏེ༌ བུ༌མོ༌ དི༌རིང༌ངའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕྲོའ༌ དུག༌ཨིན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","ཏེ༌ཏུས༌ལ༌ ཡོ༌ཤུའེ༌ འི༌ཟུག༌ ཟེར༌ཏེ༌ སྤང༌ པུདས༌, “ཡེ༌རི༌ཀོའེ༌ གྱལ༌ས༌ ཡང༌སྐྱར༌ རྩིག༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོ༌ཁན༌གུན༌ལ༌ ཡ༌ཝའེ༌ ངན༌ ཕོག༌ཤིག༌།” “‘ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ གོ༌བུའི༌ སྲོག༌ རིན༌ ཤལ༌ཏེ༌ ཏེ༌བོའེ༌ མག༌ལྡན༌ ཏང༌ཨིན༌། ཡང༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཆུང༌ཤོག༌གི༌ སྲོག༌ རིན༌ ཤལ༌ཏེ༌ ཏེ༌བོའེ༌ གྱས༌སྒོ༌ ཏག༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","ཡ༌ཝ༌ ཡོ༌ཤུའ༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཡོད༌པིན༌ ཡང༌ ཁོ༌ ཏེ༌ ས༌ཀྱད༌ གང༌པོའེ༌ ནང༌ང༌ མིང༌ཅན༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","ནོར༌ ཏམ༌པ༌གུན༌ ཡ༌ཝའ༌ ཕུལ༌ཅེས༌སི༌ བཀའ༌ ཏང༌ཁན༌བོ༌ ཁའ༌ ཉན༌ཅེས༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཁྲངས༌པོ༌ མ༌ལུས༌། ཟིམ༌རིའི༌ ཚ༌འོ༌, ཀར༌མི༌ བུ༌ཚ༌ ཨ༌ཀེན༌ནི༌ ཏེ༌ ཏམ༌པ༌ ནོར༌གུན༌ནི༌ ནང༌ནེ༌ ཁ༌ཅིག༌ རྐུས༌ཏེ༌ ཁྱེརས༌། ཏེ༌བོའེ༌ཕིའ༌ ཡ༌ཝའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ མ༌སྲན༌ཏྲེ༌ ཐུག༌སྲོ༌ སྐྱོདས༌། ཟིམ༌རི༌ ཟེ༌རཧའེ༌ པུར༌གྱུད༌ ཨིན༌པིན༌ ཡང༌ ཁོང༌གུན༌ ཡ༌ཧུ༌དཱའེ༌ མི༌སྡེ༌ནེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","ཡོ༌ཤུའེ༌ ཡེ༌རི༌ཀོ༌ནེ༌ མི༌ ཁ༌ཅིག༌ བེ༌ཐེལ༌ལི༌ ཤར༌ ཆོགས༌, བེཐ༌ ཨ༌ཝིན༌ནི༌ ཉེ༌མོའ༌ ཡོད༌ཁན༌ ཨའི༌ གྱལ༌སའེ༌ སྲུང༌སྐྱོབ༌གུན༌ གྱུས༌ ཅོའ༌ལ༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ལམ༌ཅུགས༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","ཁོང༌གུན༌ ལོགས༌ཏེ༌ ཡོངས༌ཏེ༌ ཡོ༌ཤུའ༌ ཟེརས༌, “ཨའི༌ གྱལ༌ས༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌, མག༌མི༌ ཚང༌མ༌ ཀལ༌ཅེས༌སི༌ སྒོས༌དོམ༌ མི༌དུག༌། མག༌མི༌ ཚང༌མ༌ བར༌དོ༌ མ༌སྟན༌ན༌, སྟོང༌ ཉིས༌ ཡ༌ སུམ༌ ནོལ༌ལ༌ ཀལ༌ན༌ གྲིག༌ཅེས༌ དུག༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌རུ༌ མི༌ ཉུ༌ངུན༌ཞིག༌ མ༌ནེ༌ མི༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","ཏེ༌ནེ༌ མག༌མི༌ སྟོང༌སུམ༌ ནོལ༌ལ༌ སོང༌ ཨིན༌ནའང༌ ཨའི༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཕམ༌ སྲན༌ཏྲེ༌ ཀལས༌ ཡང༌ ཁོང༌གུན༌ ཏེ༌ཀ༌ནེ༌ ཤོར༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","ཁོང༌གུན༌ནི༌ གྱལ༌སའེ༌ གྱས༌སྒོའེ༌ ཕི༌ལོག༌ག༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌གུན༌ལ༌ རི༌ནེ༌ ཐུར༌ལ༌ ལུང༌པའེ༌ ནང༌ང༌ ཏེད༌ཏེ༌ ཁྱེརས༌ ཡང༌ མག༌མི༌ 36 སདས༌། ཏེ༌བོ༌ ཐོང༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྲན༌ཏྲེ༌ ཇིགས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ནོལ༌ཅེས༌སི༌ སྤོས༌པ༌ ཆགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","ཡོ༌ཤུའེ༌ ཁོང༌རང༌ངི༌ ཀོས༌ ཤགས༌ ཡང༌ ཁོང༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ འུ༌སྐྱོང༌གུན༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ དུན༌ལ༌ སའེ༌ཀ༌ གྱེལ༌ཏེ༌ ཕི༌ཏོག༌ ཚོག༌པ༌ དུགས༌ ཡང༌ ཁོང༌རང༌གུན༌ནི༌ གོའེ༌ཀ༌ ཐལ༌བ༌ ཡོགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཟེརས༌, “ཡ༌ཝ༌ ཀུན༌ཝང༌ལེ༌, ཉེ༌རང༌ངི༌ ང༌ཞའ༌ ཨ༌མོར༌པ༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ཏེ༌ སད༌ ཅུག༌ཅེས༌ལ༌ ང༌ཞ༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཏེ༌ ཨིན༌ན༌? ང༌ཞའ༌ འ༌ངོ༌ ཆོགས༌ལ༌ དུགས༌པིན༌ན༌ འི༌ཟུག༌ སོང༌ཏེ༌ མེད༌གྲོ༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","ཡ༌ཝ༌ལེ༌ ང༌ཞའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ གྲ༌འོ༌གུན༌ནི༌ ཀ༌ནེ༌ ཤོར༌ པ༌སང༌ ཏ༌ ངའེ༌ ཅི༌ ཟེར༌གོས༌? ");
INSERT INTO lbj_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","ཀེ༌ནན༌པ༌གུན༌ དང༌ ཞན༌ འི༌རུ༌ དུག༌ཁན༌གུན༌ནི༌ འི༌བོ༌ ཚོར༌ར༌ཅིག༌, ཁོང༌གུན༌ནི༌ ང༌ཞ༌གུན༌ལ༌ ནོལ༌ཏེ༌ ང༌ཞའེ༌ མིང༌ ཇིག༌རྟེན༌ནི༌ ཀ༌ནེ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། ཏེ༌ནེ༌ ཉེ༌རང༌ སྤལ༌ཅན༌ དང༌ སྟོབས༌ཅན༌ དཀོན༌མཆོག༌ ཞུགས༌ཁན༌ སྟན༌ན༌ ཛད༌ཅེས༌ལ༌ ཉེ༌རང༌ངི༌ ཅི༌ ཛད༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “ལོངས༌། ཁྱོ༌རང༌ སའེ༌ཀ༌ གྱེལ༌ཏེ༌ རྡུག༌པོ༌ ཅི༌ ཅོའད༌? ");
INSERT INTO lbj_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྡིག༌པ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ནི༌ ངའེ༌ ཟེར༌ཁན༌བོ༌ མ༌ཅོའ༌ ངའེ༌ ཆད༌དོན༌བོ༌ ཅགས༌། ཁོང༌གུན༌ནི༌ ངའ༌ ཕུལ༌ཁན༌ནི༌ ཏམ༌པ༌ ནོར༌ ཁ༌ཅིག༌ རྐུས༌ཏེ༌ ཁྱེརས༌ ཡང༌ ཏེ༌གུན༌ རྐུ༌ཅེས༌ མ༌ཚད༌ ཟུན༌ ཏངས༌ཏེ༌ ཁོང༌རང༌གུན༌ནི༌ གྱུ༌ནོར༌རི༌ ཕྲོའ༌ སྦས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ གྲ༌འོ༌གུན༌ནི༌ ཀ༌ནེ༌ ཕམས༌ཏེ༌ ཤོར༌གོས༌། ཏ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌རང༌གུན༌ ཁྲེས༌ཏོར༌ ཆ༌ཅེས༌སི༌ ཕིའ༌ ལྡམས༌ཏེ༌ ཨིན༌ནོག༌། ནམ༌ཚོག༌པ༌ ཁྱོ༌རང༌ངི༌, ཁྱོ༌ཞའ༌ ཚི༌ཏུ༌ གྱུར༌ ཅུག༌ཁན༌གུན༌ ཁྲེས༌ཏོར༌ མི༌ཅོ༌ ང༌ ཁྱོ༌ཞ༌གུན༌ ཉམ༌པོ༌ མི༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“ལོངས༌, མི༌གུན༌ རྩང༌མ༌ ཅོས༌། ཁོང༌གུན༌ལ༌ ཁོང༌རང༌གུན༌ རྩང༌མ༌ ཅོ༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌ཏེ༌ ཟེར༌, ‘ཡ༌ཝ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌གི༌ མོལས༌, “ཝ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌, ཁྱོ༌ཞའེ༌ ཕྲོའ༌ ངའ༌ ཕུལ༌གོ༌ཤེས༌ཅན༌ནི༌ ནོར༌གུན༌ དུག༌། ནམ༌ཚོག༌པ༌ ཏེ༌གུན༌ མེད༌ཁན༌ མི༌ ཅོ༌ ཁྱོ༌ཞའེ༌ ཁྱོ༌ཞ༌རང༌ངི༌ གྲ༌འོ༌གུན༌ལ༌ ཕམ༌ཀལ༌ མི༌ཉན༌།”’” ");
INSERT INTO lbj_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","“ཐོ༌རེའེ༌ ང༌མོ༌ ཁྱོ༌ཞ༌གུན༌ རང༌རང༌ངི༌ མི༌སྡེ༌གུན༌ ཉམ༌པོ༌ ང༌ ཡོད༌ས༌ ཡོང༌གོས༌, ཡང༌ ངའེ༌ བོད༌ད༌ཅིག༌ མི༌སྡེ༌ ནང༌ནེ༌ མི༌རིགས༌ རེ༌རེ༌ དུན༌ལ༌ ཡོང༌གོས༌། ཡང༌ མི༌རིགས༌ ལྡམ༌ཁན༌བོའེ༌ ནང༌ནེ༌ ནང༌ཚངས༌ རེ༌རེ༌ དུན༌ལ༌ ཡོང༌གོས༌ ཡང༌ ནང༌ཚངས༌ ལྡམ༌ཁན༌བོའེ༌ ནང༌ནེ༌ མི༌ རེ༌རེ༌ དུན༌ལ༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","ང༌ ཕུལ༌ཁན༌ནི༌ ཏམ༌པ༌ ནོར༌ རྐུ༌ཁན༌ནི༌ མི༌ ཟུམ༌ཁན༌ ཡང༌ ཁོའེ༌ ཨིན༌ཁན༌ ཚང༌མ༌ མེའེ༌ ནང༌ང༌ སྲག༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ངའེ༌ ཆད༌དོན༌བོ༌ ཅགས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ ཁྲེལ༌མེད༌དི༌ ལས༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","ཐོ༌རེ༌ཟུག༌པོ༌ མ༌ ང༌མོ༌ནེ༌ ཡོ༌ཤུའེ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ མི༌སྡེ༌ རེ༌རེ༌ ཅོས༌ཏེ༌ ཡོང༌ཅུགས༌ ཡང༌ ཡ༌ཧུ༌དཱའེ༌ སྡེ༌ ལྡམ༌མ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","ཏེ༌ནེ༌ ཡ༌ཧུ༌དཱའེ༌ སྡེའེ༌ ནང༌ནེ༌ མི༌རིགས༌ རེ༌རེ༌ དུན༌ལ༌ ཡོངས༌ ཡང༌ ཟེ༌རཧའེ༌ མི༌རིགས༌ ལྡམ༌མ༌ ཛདས༌། ཏེ༌ནེ༌ ཟེ༌རཧའེ༌ མི༌རིགས༌སི༌ ནང༌ཚངས༌ རེ༌རེ༌ དུན༌ལ༌ ཡོངས༌ ཡང༌ ཟིམ༌རིའི༌ ནང༌ཚངས༌ ལྡམ༌མ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","ཏེ༌ནེ༌ ཟིམ༌རིའི༌ ནང༌ཚངས༌སི༌ མི༌ རེ༌རེ༌ དུན༌ལ༌ ཡོངས༌ ཡང༌ ཨ༌ཀེན༌ ལྡམ༌མ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཨ༌ཀེན༌ལ༌ ཟེརས༌, “ངའེ༌ བུ༌ཚ༌, རང༌ངི༌ སྡིག༌པ༌ ཅོ༌ཁན༌བོ༌ ཤད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའ༌ སྤལ༌ ཁྱོང༌། ཁྱོ༌རང༌ངི༌ ཅོས༌ཁན༌བོ༌ སྦས༌ཏེ༌ མ༌བོར༌ར༌ ངའ༌ ཀྲང༌པོ༌ ཤོད༌།” ");
INSERT INTO lbj_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","ཨ༌ཀེན༌ནི༌ ལན༌ཏངས༌, “འི༌བོ༌ དེན༌བ༌ ཨིན༌། ངའེ༌ ཡ༌ཝའ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌གི༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཅོས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","ཅོམས༌ཏེ༌ ཁྱོང༌ཁན༌ནི༌ ནོར༌གུན༌ནི༌ ཕྲོའ༌ ངའེ༌ མུལ༌ ཀི༌ལོ༌ 2 སང༌ མང༌ང༌ ཞིག༌, ཀི༌ལོ༌ ཕེད༌དི༌ སེར༌རི༌ པག༌བུ༌ དང༌ བ༌བེ༌ལོན༌ནེ༌ ཨིན༌ཁན༌ ཀོས༌ ལྡེ༌མོ༌ ཐོང༌ང༌ཅིག༌, ངའ༌ ཏེ༌གུན༌ནི༌ དོད༌པ༌ ཡོངས༌པ༌ ངའེ༌ རྐུས༌པིན༌། ཏེ༌གུན༌ ངའེ༌ ང༌རང༌ངི༌ ཀུར༌རི༌ ནང༌ང༌ སའེ༌ ཐིལ༌ལ༌ སྦས༌ཏེ༌ ཡོད༌, ཚང༌མའེ༌ སང༌ ཐིལ༌ལ༌ མུལ༌།” ");
INSERT INTO lbj_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ མི༌ ཁ༌ཅིག༌ ཏེ༌གུན༌ ཙལ༌ལ༌ ལམ༌ཅུགས༌། ཁོང༌གུན༌ ཀུར༌རི༌ ནང༌ང༌ བང༌ཏངས༌ཏེ༌ སོང༌ ཡང༌ ཨ༌ཀེན༌ནི༌ ཟེར༌ཁན༌ ནང༌ཞིན༌ ཏེ༌རུ༌ སྦས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ནོར༌ ཚང༌མ༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","ཁོང༌གུན༌ནི༌ ཀུར༌རི༌ ནང༌ནེ༌ ཏེ༌ ནོར༌གུན༌ ཁྱོངས༌ ཡང༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཡོད༌ས༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ སའེ༌ཀ༌ ཏིངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཨ༌ཀེན༌, ཀོས༌, མུལ༌, སེར༌, ཁོའེ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ གུན༌, བ༌ལང༌གུན༌, བུང༌བུ༌གུན༌, ལུག༌གུན༌, ར༌མ༌གུན༌, ཀུར༌ དང༌ ཁོའ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཨ༌ཁོར༌རི༌ ལུང༌པའེ༌ ནང༌ང༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","ཡོ༌ཤུའེ༌ ཨ༌ཀེན༌ལ༌ ཟེརས༌, “ཅིའ༌ ཁྱོ༌རང༌ངི༌ ང༌ཞ༌གུན༌ནི༌ཀ༌ རྡུག༌ངལ༌ ཁྱོངས༌པིན༌། ཏ༌ ཡ༌ཝའེ༌ ཁྱོ༌རང༌ངི༌ཀ༌ རྡུག༌ངལ༌ ཁྱོང༌ང༌ ཛད༌ཨིན༌།” ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཁོང༌ ཚང༌མ༌ལ༌ རྡོའ༌ གྱབས༌ཏེ༌ སདས༌ ཡང༌ ཏེ༌ ཚང༌མ༌ མེའ༌ སྲགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྲགས༌ཁན༌ནི༌ སོལ༌ལེ༌ ཁེ༌ཐོག༌ག༌ རྡོའ༌ སྤུངས༌ ཀ༌བོ༌ དི༌རིང༌ངའང༌ ལུས༌ཏེ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ཏེན༌ན༌བོའེ༌ ཕིའ༌ ཏེ༌ ས༌ཀྱད༌པོའ༌ རྡུག༌ངལ༌ལི༌ ལུང༌པ༌ ཟེར༌ར༌ནོག༌། ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཐུག༌སྲོ༌ ཁོང༌གུན༌ནི༌ཀ༌ བབས༌ཁན༌བོ༌ མེད༌ཁན༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “ཇིགས༌ མ༌ཇིགས༌ ཡང༌ སྤོས༌པ༌ མ༌ཆག༌། ཁྱོ༌རང༌ངི༌ མག༌མི༌ ཚང༌མ༌ ཁྲིད༌ཏེ༌ ཨའི༌ གྱལ༌ས༌ སྤུང༌གོལ༌ ཅོས༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཨའི༌ གྱལ༌པོ༌, ཁོའེ༌ མི༌གུན༌ དང༌ གྱལ༌ས༌ ཡང༌ ཁོའེ༌ ས༌ཀྱད༌གུན༌ ཏངས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","ཡེ༌རི༌ཀོ༌ དང༌ ཏེ༌བོའེ༌ གྱལ༌པོའ༌ ཅོའ༌ ཙོགས༌, ཁྱོ༌རང༌ངི༌ འི༌གུན༌ནའང༌ ཁྲེས༌ཏོར༌ ཅོ༌ཨིན༌། ཨིན༌ནའང༌ ཅོམས༌ཁན༌ནི༌ ནོར༌ དང༌ སེམས༌ཅན༌གུན༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཕིའ༌ བོར༌ནང༌ གྲིག༌། ཁོང༌གུན༌ལ༌ གྱུས༌ཆའ༌ མ༌ཅུག༌ག༌, གྱལ༌སའེ༌ གྱབ༌བ༌ ཨིབས༌ཏེ༌ ཡོད༌ཁན༌ མག༌མི༌གུན༌ལ༌ ཁོང༌གུན༌ནི༌ཀ༌ ཧུན༌མེད༌ལ༌ སྤུང༌གོལ༌ ཅོ༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ མག༌མི༌ ཚང༌མ༌ ཨའི༌ཀ༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ སོང༌། ཡོ༌ཤུའེ༌ ཚང༌མའེ༌སང༌ གྱལ༌ལ༌ མག༌གི༌ 30,000 ལྡམས༌ ཡང༌ ཁོང༌གུན༌ ཚན༌ལ༌ ལམ༌ཅུགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","བཀའ༌ ཏངས༌, “གྱལ༌སའེ༌ གྱབ༌ ཆོགས༌ལ༌ ཨིབས༌ཏེ༌ དུག༌ ཨིན༌ནའང༌ མ༌ ཐག༌རིང༌ང༌ མ༌ཆ༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ ཤང༌ཅོས༌ཏེ༌ དུག༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","ང༌ དང༌ ང༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ མག༌མི༌ ཚང༌མའེ༌ གྱལ༌སའེ༌ཀ༌ སྤུང༌གོལ༌ ཅོ༌ཨིན༌, སྔུན༌ ཙོགས༌ལ༌ ཨའི༌པ༌གུན༌ ནོལ༌ལ༌ ཡོང༌ང༌ཅིག༌ ང༌ཞ༌གུན༌ ཤོར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","གྱལ༌ས༌ནེ༌ ཐག༌རིང༌ང༌ ལེབ༌ལེབ༌ ཚག༌པ༌ ང༌ཞའེ༌ ཁོང༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱོང༌ཅུག༌ཨིན༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཟེར༌ཨིན༌, ‘སྔུན༌ ཙོགས༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ང༌དང༌གུན༌ནི༌ ཀ༌ནེ༌ ཤོར༌ཏེ༌ ཨིན༌ནོག༌།’ ཏེ༌ནེ༌ ང༌ཞའ༌ ཤོར༌ ཟ༌ནེ༌ ");
INSERT INTO lbj_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ཁྱོ༌ཞ༌གུན༌ ཨིབས༌ཏེ༌ ཡོད༌སའེ༌ ནས༌ས༌ནེ༌ བིངས༌ཏེ༌ ཡོང༌ ཡང༌ གྱལ༌ས༌ ང༌ཡོག༌ག༌ ལེན༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཏེ༌བོ༌ ང༌དང༌གུན༌ལ༌ སལ༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","གྱལ༌ས༌ ལེན༌ཏེ༌ སྟིང༌ནེ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཏེ༌བོ༌ མེའ༌ སྲོག༌། ཁྱོ༌རང༌གུན༌ལ༌ འི༌བོ༌ ངའེ༌ བཀའ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ ལམ༌ཅུགས༌, ཁོང༌གུན༌ ཨའི༌ ནུབ༌ ཆོགས༌ལ༌ བེ༌ཐེལ༌ དང༌ ཨའི༌ པར༌ལ༌ ཡོད༌ཁན༌ནི༌ ནས༌སའེ༌ ནང༌ང༌ ཨིབས༌ཏེ༌ དུགས༌། ཨིན༌ནའང༌ ཡོ༌ཤུའ༌ ཏེ༌ ཚན༌བོ༌ ཁོ༌རང༌ངི༌ མག༌མི༌གུན༌ ཉམ༌པོ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ནེ༌ ཡོ༌ཤུའེ༌ ཁོ༌རང༌ངི༌ མག༌མི༌གུན༌ ཛོམ༌ཅུགས༌ཏེ༌ ཁོ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ འུ༌སྐྱོང༌གུན༌ནི༌ གོ༌ཁྲིད༌ ཅོས༌ཏེ༌ ཨའི༌ ཆོགས༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","ཡོ༌ཤུའ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ མག༌མི༌ ཚང༌མ༌ གྲུལ༌ཏེ༌ གྱལ༌སའེ༌ ཉེ༌མོའ༌ ལེབ༌ཏེ༌ ཨའི༌ བྱང༌ ཆོགས༌ལ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ཁོང༌གུན༌ དང༌ གྱལ༌སའེ༌ པར༌ལ༌ ལུང༌པ༌ཞིག༌ མན༌ནེ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","ཏེ༌ ཚན༌ལ༌ ཡོ༌ཤུའེ༌ མག༌མི༌ 5,000 ལྡམས༌ཏེ༌ གྱལ༌སའེ༌ ནུབ༌ ཆོགས༌ལ༌ བེ༌ཐེལ༌ དང༌ ཨའི༌ པར༌ལ༌ ཨིབས༌ཏེ༌ དུག༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","ཏེ༌ནེ༌ ཨིབས༌ཏེ༌ དུག༌ཁན༌ མག༌མི༌ གྱལ༌སའེ༌ ནུབ༌ ཆོགས༌ལ༌ ཡང༌ བྱང༌ ཆོགས༌ལ༌ ཞན༌ མག༌མི༌ ཚང༌མ༌ དུགས༌ ཨིན༌ནའང༌ ཏེན༌ན༌ ཚན༌ལ༌ ཡོ༌ཤུའ༌ ལུང༌པའེ༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","ཨའི༌ གྱལ༌པོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཐོང༌ང༌ཅིག༌ ཁོ༌ དང༌ ཁོའེ༌ མག༌མི༌ ཚང༌མ༌ ང༌མོ༌ནེ༌ གྱོགས༌པ༌ ཡོར༌དཱན༌ ལུང༌པའེ༌ ནང༌ང༌ ཁོང༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌། ཨིན༌ནའང༌ གྱལ༌སའེ༌ གྱབ༌བ༌ སྤུང༌གོལ༌ ཅོའ༌ལ༌ མག༌མི༌ ཨིབས༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ཁོང༌གུན༌ལ༌ གྱུས༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","ཕམས༌ཁན༌ནི༌ མག༌མི༌ ཙོགས༌ལ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ མག༌མི༌ ཚང༌མ༌ ཐང༌སྟོང༌ ཆོགས༌ལ༌ ཤོར༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེར༌ཅེས༌ལ༌ གྱལ༌སའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ བུ༌ཚ༌ ཚང༌མ༌ བོདས༌, ཏེན༌ན༌ཟུག༌གི༌ ཁོང༌གུན༌ གྱལ༌ས༌ནེ༌ ཐག༌རིང༌ང༌ ཕིངས༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","ཨའི༌ ཡ༌ བེ༌ཐེལ༌ལི༌ ནང༌ང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཏེད༌ཏེ༌ མ༌ ཁྱེར༌ཁན༌ བུ༌ཚ༌ ཅིག༌གའང༌ ལུས༌ཏེ༌ མེད༌པིན༌། གྱལ༌སའེ༌ སྒོ༌ སང༌ ཕེས༌ཏེ༌ ཁོང༌ ཚང༌མའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ལག༌ག༌ ཡོད༌ཁན༌ནི༌ རྡུང༌ ཨའི༌ ཆོགས༌ལ༌ སྟོག༌, ངའེ༌ གྱལ༌ས༌བོ༌ ཁྱོ༌རང༌ངི༌ ལག༌ག༌ ཏང༌ངད༌།” ཏེན༌ན༌བོའེ༌ ཕིའ༌ ཡོ༌ཤུའེ༌ ཁོ༌རང༌ངི༌ རྡུང༌ ཨའི༌ ཆོགས༌ལ༌ སྟགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","ཡོ༌ཤུའེ༌ ཏེ༌ཟུག༌ ཅོའ༌ཅིག༌ ཨིབས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ མག༌མི༌ ཚང༌མ༌ ཏེ༌ ནས༌ས༌ནེ༌ བིངས༌ཏེ༌ གྱལ༌སའེ༌ ནང༌ང༌ སོང༌ ཡང༌ ཏེ༌བོ༌ ང༌ཡོག༌ག༌ ལེན༌ཏེ༌ མེའ༌ ཏུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","ཨའི༌པ༌གུན༌ནི༌ གྱབ༌ ལོགས༌ཏེ༌ ལྟའ༌ཅིག༌ གྱལ༌སའེ༌ ནང༌ནེ༌ ཏུད༌པ༌ བིངས༌ཏེ༌ ནམ༌ཁའ༌ གངས༌ཁན༌བོ༌ ཐོང༌། ཨིན༌ནའང༌ ཁོང༌གུན༌ ཀ༌ངོ༌ ཆོགས༌ལའང༌ ཤོར༌ མ༌ཉན༌ ཅིའ༌ཟེར༌ན༌ ཨིས༌ར༌ཨེལ༌པ༌ ཐང༌སྟོང༌ ཆོགས༌ལ༌ ཤོར༌ཁན༌གུན༌ ཁོང༌ང༌ ཏེད༌ཅེས༌ལ༌ གྱབ༌ གྱུར༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","ཨིབས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ མག༌མི༌གུན༌ནི༌ གྱལ༌ས༌ ལེན༌ཏེ༌ ཏུད༌པ༌ བིང༌ཨིན༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཐོང༌ང༌ཅིག༌ ཁོང༌གུན༌ནི༌ གྱབ༌ ལོགས༌ཏེ༌ ཨའི༌པ༌ མག༌མི༌གུན༌ལ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","ཏེན༌ན༌ ཟ༌ནེ༌ གྱལ༌ས༌ ལེན༌ཁན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ བིང༌ཏེ༌ ཨའི༌པ༌ མག༌མི༌གུན༌ནི༌ གྱབ༌ནེ༌ ནོལ༌ལ༌ ཡོངས༌ པ༌སང༌ ཁོང༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌ མག༌མི༌གུན༌ནི༌ ཞུང༌ང༌ ཁད༌། ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ ཡང༌ མི༌ ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌ལུས༌ ཡ༌ ཤོར༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","ཨིན༌ནའང༌ ཨའི༌ གྱལ༌པོ༌ ཅིག༌པོ༌ སོན༌ཏེའ༌ ཟུམས༌ཏེ༌ ཡོ༌ཤུའ༌ ཡོད༌ས༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཏེད༌ཏེ༌ ཨའི༌པ༌ མག༌མི༌ ཚང༌མ༌ སད༌ ཚར༌ར༌ཅིག༌ ཁོང༌གུན༌ ལོགས༌ཏེ༌ གྱལ༌ས༌ སོང༌ ཡང༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མའང༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ཏེ༌ ཞག༌ག༌ ཨའི༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མ༌, བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཐེས༌ཏེ༌ མི༌ 12,000 ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","ཨའི༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོ༌ ཚར༌ཚར༌ ཡོ༌ཤུའེ༌ ཁོ༌རང༌ངི༌ རྡུང༌བོ༌ ཨའི༌ ཆོགས༌ལ༌ སྟགས༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སེམས༌ཅན༌ དང༌ ནོར༌ ཅོམས༌ཁན༌ ཚང༌མ༌ ཁོང༌རང༌གུན༌ནི༌ ཕིའ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཨའི༌ གྱལ༌ས༌ མེའ༌ སྲགས༌ ཡང༌ ཁྲེས༌ཏོར༌ ཅོས༌ཁན༌ནི༌ ལག༌ལུས༌གུན༌ སྤུངས༌ཏེ༌ བོརས༌ ཀ༌བོ༌ དག༌སའང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","ཡོ༌ཤུའེ༌ ཨའི༌ གྱལ༌པོ༌ རྡུང༌མའེ༌ཀ༌ ཏགས༌ཏེ༌ ཕི༌ཏོག༌ ཚོག༌པ༌ བོརས༌། ཉི༌མ༌ སྐྱོད༌ད༌ཅིག༌ ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཁོའེ༌ རོ༌བོ༌ ཕབས༌ཏེ༌ གྱལ༌སའེ༌ གྱས༌སྒོའེ༌ ཕི༌ལོག༌ག༌ ཕངས༌ཏེ༌ ཏེ༌བོའེ༌ཀ༌ རྡོའ༌ སྤུངས༌ཏེ༌ ཀབ༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། ཏེ༌བོ༌ དག༌སའང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","31","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ མོ༌ཟེས༌སི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཡོ༌ཤུའེ༌ ཨེ༌བལ༌ རི༌ཀ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཕིའ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌། མོ༌ཟེས༌སི༌ བཀའ༌ཁྲིམས༌སི༌ ལྡེབ༌བི༌ ནང༌ང༌ བྲིས༌ཏེ༌ ཡོད༌ཁན༌ ནང༌ཞིན༌ ཁོའེ༌ ཏེ༌བོ༌ རྡོའ༌ མ༌ཅག༌ཁན༌ ཡང༌ན༌ ལྕགས༌སི༌ ལག༌ཆའ༌ མ༌ ཀོལ༌ཁན༌ནི༌ རྡོའ༌ ཉམ༌པོ༌ རྩིགས༌། ཏེ༌ ཆོད༌ཁྲི༌ཀ༌ ཁོང༌གུན༌ནི༌ མེའ༌ སྲོགས༌ཁན༌ནི༌ ཆོད༌པ༌ དང༌ ཞི༌དེ༌ ཆོད༌པ༌གུན༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ དུན༌ལ༌ ཡོ༌ཤུའེ༌ ཞན༌ རྡོ༌གུན༌ནི༌ཀ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ སལ༌ཁན༌ནི༌ བཀའ༌རྒྱ༌ གུན༌ བྲིས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","ཏེ༌ནེ༌ ཞན༌ཡུལ༌ དང༌ ཏེན༌ན༌རུ༌ སྐྱེས༌ཁན༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌, ཁོང༌གུན༌ནི༌ འུ༌སྐྱོང༌གུན༌, སྤོན༌བོ༌གུན༌ དང༌ ཁྲིམ༌སྤོན༌གུན༌, ཆད༌དོན༌ནི༌ སྒམ༌ ཁུར༌ཁན༌ནི༌ ལི༌ཝི༌པ༌ བླ༌མ༌གུན༌ ཁོང༌གུན༌ནི༌ དུན༌ཆོགས༌ལ༌ ཡང༌ ཁོང༌ ཚང༌མ༌ ཡ༌ཝའེ༌ ཆད༌དོན༌ནི༌ སྒམ༌མི༌ ལྡོ༌ ཉིས༌ཀོའ༌ ལངས༌ཏེ༌ དུགས༌, ཕེད༌པོ༌ གེ༌རི༌ཟིམ༌ རི༌ དུན༌ཆོགས༌ལ༌ ཡང༌ ཕེད༌པོ༌ ཨེ༌བལ༌ རི༌ དུན༌ཆོགས༌ལ༌ ལངས༌ཏེ༌ ཡོད༌པིན༌། ཀ༌ཟུག༌ ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ ལབ༌ཞ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། བླ༌མ༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཅིན༌ལབས༌པོ༌ མི༌མངས༌གུན༌ལ༌ ཏང༌ཅེས༌ལ༌ མོ༌ཟེས༌སི༌ ཏེ༌ ལབ༌ཞ༌བོ༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ལ༌ ཅིན༌ལབས༌ དང༌ ཆད༌པའེ༌ སྐྱོར༌, མོ༌ཟེས༌སི༌ བཀའ༌ཁྲིམས༌སི༌ ལྡེབ༌བི༌ ནང༌ང༌ བྲིས༌ཏེ༌ ཡོད༌ཁན༌ བཀའ༌ཁྲིམས༌སི༌ ཚིགས༌ ཚང༌མ༌ སིལས༌། ");
INSERT INTO lbj_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌པ༌ བུ༌མོ༌ དང༌ ཕྲུ༌གུ༌ གུན༌ ཡང༌ ཞན༌ཡུལ༌ལི༌ མི༌གུན༌ ཐེས༌ཏེ༌ ཛོམས༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མའེ༌ དུན༌ལ༌, མོ༌ཟེས༌སི༌ བཀའ༌ཁྲིམས༌སི༌ ལྡེབ༌བི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཚིགས༌ རེ༌རེ༌ ལུས༌ མ༌ཅུག༌ག༌ སིལས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","ཏ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ནུབ༌ ཆོགས༌སི༌ གྱལ༌པོ༌ ཚང༌མའེ༌ ཏེ༌ ཇུང༌ཁན༌གུན༌ ཚོར༌། ཁོང༌གུན༌ རི༌ ཡུལ༌གུན༌, ནུབ༌ ཆོགས༌སི༌ རི༌ ཡོག༌གི༌ ཡུལ༌ ཡང༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ ཚོའེ༌ ཐའ༌མ༌, ལེ༌བ༌ནོན༌ནི༌ རི༌ ཚོག༌པ༌ དུག༌ཁན༌ ཧེད༌པ༌, ཨ༌མོར༌པ༌, ཀེ༌ནན༌པ༌, པེ༌རིཟ༌པ༌, ཧིཝ༌པ༌ དང༌ ཡེ༌བས༌པའེ༌ གྱལ༌པོ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","ཏེ༌ གྱལ༌པོ༌ ཚང༌མ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཅིག༌གྲིལ༌ སོང༌ཏེ༌ ནོལ༌ཅེས༌ལ༌ ཛོམས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","ཨིན༌ནའང༌ གི༌བེ༌འོན༌པ༌གུན༌ནི༌ ཡོ༌ཤུའེ༌ ཡེ༌རི༌ཀོ༌ དང༌ ཨའི༌ གྱལ༌ས༌གུན༌ལ༌ ཅོ༌ཁན༌བོ༌ ཚོར༌ར༌ཅིག༌ ");
INSERT INTO lbj_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","ཁོ༌རང༌གུན༌ སྐྱོབ༌ཅེས༌ལ༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གོབ༌སྐོར༌ ཏང༌ཅེས༌ ཐག༌ཅདས༌། ཁོང༌གུན༌ནི༌ ཡོ༌ཤུའེ༌ ཡོད༌ས༌ ཐུས༌མི༌གུན༌ ལམ༌ཅུགས༌, བུང༌བུ༌གུན༌ནི༌ཀ༌ གལ༌ ཉིང༌པ༌ དང༌ ཆང༌ངི༌ པགས༌པ༌ ལན༌བ༌ ཏབ༌ཁན༌གུན༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","ཐུས༌མི༌གུན༌ནི༌ ལན༌བ༌ ཏབ༌ཁན༌ནི༌ པ༌བུ༌ དང༌ ཀོས༌ལག༌ ཆད༌ཁན༌ གོནས༌ ཡང༌ སྐམས༌ཏེ༌ ཧམ༌བོར༌ ཆགས༌ཁན༌ནི༌ ཏ༌གི༌གུན༌ ཁུརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","ཁོང༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཀུར༌ ཙུགས༌ཏེ༌ དུག༌ས༌ གིལ༌གལ༌ལ༌ ལེབས༌ཏེ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཟེརས༌, “ང༌ཞ༌གུན༌ ས༌ཆ༌ མའ༌ ཐག༌རིང༌ནེ༌ ཉེ༌ཞ༌གུན༌ ཉམ༌པོ༌ ཞི༌དེའེ༌ ཆད༌དོན༌ ཅོ༌ཅེས༌ལ༌ ཞུ༌ཝ༌ ཁུར༌ཏེ༌ ཡོངས༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཧིཝ༌པ༌ ཡང༌ན༌ གི༌བེ༌འོན༌པ༌གུན༌ལ༌ ཟེརས༌, “ཅི༌ གྱུས༌ ཁྱོ༌ཞ༌གུན༌ ང༌ཞའེ༌ ཉེ༌མོའ༌ དུག༌གད༌ གྲོ༌, ཏེ༌ནེ༌ ང༌ཞའེ༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ཞི༌དེ༌ ཆད༌དོན༌ ཀ༌ཟུག༌གི༌ ཅོ༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","ཁོང༌གུན༌ནི༌ ཟེརས༌, “ང༌ཞ༌གུན༌ ཁྱོ༌ཞའེ༌ ཡོག༌པོ༌ ཨིན༌།” ཨིན༌ནའང༌ ཡོ༌ཤུའེ༌ ཏྲིས༌, “ཁྱོ༌ཞ༌གུན༌ སུ༌ ཨིན༌ ཡང༌ ཀ༌ནེ༌ ཡོངས༌ཏེ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཡ༌ཝའ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌གི༌ གང༌ཤན༌ ཆག༌ལས༌ ཛད༌ཁན༌གུན༌ ཚོར༌ཏེ༌ ང༌ཞའ༌ ཉེ༌རང༌ངི༌ ཡོག༌པོ༌གུན༌ ས༌ཆ༌ མའ༌ ཐག༌རིང༌ནེ༌ ཡོངས༌ཏེ༌ ཨིན༌། ཡ༌ཝའེ༌ ཨི༌ཇིབ༌བི༌ ནང༌ང༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ཛད༌ཁན༌ ཚང༌མ༌ ང༌ཞ༌གུན༌ནི༌ ཚོར༌, ");
INSERT INTO lbj_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ཏེ༌ མ༌ཛད༌ ང༌ཞ༌གུན༌ནི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌སི༌ ཨ༌མོར༌པའེ༌ གྱལ༌པོ༌, ཧེཤ༌བོན༌ནི༌ གྱལ༌པོ༌ སི༌ཧོན༌ དང༌ ཨཤ༌ཏ༌རོཐ༌ ནང༌ང༌ དུག༌ཁན༌ བ༌ཤན༌ནི༌ གྱལ༌པོ༌ ཨོག༌ ཉིས༌ཀོའ༌ ཛདས༌ཁན༌ ཚང༌མ༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","ང༌ཞའེ༌ འུ༌སྐྱོང༌ དང༌ མི༌ཚང༌མའེ༌ ང༌ཞ༌གུན༌ལ༌ ཟེརས༌, ‘བེས༌སི༌ ཕིའ༌ ཟ༌གྱུ༌ ཁུར༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཐུག༌ག༌ སོང༌ཏེ༌ ཟེར༌, “ང༌ཞའ༌ ཉེ༌རང༌ངི༌ ཡོག༌པོ༌གུན༌ ཨིན༌, ཇུ༌ཇུ༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཞི༌དེའེ༌ ཆད༌དོན༌ ཅོའ༌ ཛད༌།”’ ");
INSERT INTO lbj_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","ང༌ཞ༌གུན༌ ཉེ༌རང༌ང༌ ཐུག༌ག༌ ཁང༌པ༌ནེ༌ བིང༌ ཟ༌ནེ༌ འི༌ ཏ༌གི༌གུན༌ ཚན༌ཏེ༌ ཡོད༌པིན༌ ཨིན༌ནའང༌ ཏ༌ ཟིགས༌སའང༌ འི༌གུན༌ སྐམས༌ཏེ༌ ཧམ༌བོར༌ ཆགས༌ཏེ༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","ང༌ཞའེ༌ རྒུན༌ཆང༌ སྐང༌ ཟ༌ནེ༌ འི༌ སྐྱ༌པ༌གུན༌ སོ༌མ༌ ཡོད༌པིན༌ ཨིན༌ནའང༌ ཏ༌ འི༌གུན༌ ཉིང༌པ༌ སོང༌ཏེ༌ ཆད༌དུག༌ ཡང༌ ང༌ཞ༌གུན༌ནི༌ ཀོས༌ལག༌ དང༌ པ༌བུ༌ གུན༌ བེས༌ རིང༌མོའེ༌ ཞས༌ཏེ༌ ཆད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཞི༌དེའེ༌ ཆད༌དོན༌ ཅོ༌ཁན༌ནི༌ སྟགས༌ སྟན༌ཅེས༌ལ༌ ཏ༌གི༌ ཟོས༌ ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ཐུག༌གོངས༌ ཏྲིའ༌ མ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཞི༌དེའེ༌ ཆད༌དོན༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ མི༌ སད༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ཏེན༌ན༌ ཙོགས༌ ཅོ༌ཅེས༌ལ༌ ནའ༌ ཁུརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","ཆད༌དོན༌ ཅོས༌ཏེ༌ ཞག༌པོ༌ སུམ༌མི༌ སྟིང༌ནེ༌ ཁོང༌གུན༌ལ༌ ཏེ༌ མི༌གུན༌ ཁོང༌གུན༌ནི༌ ཉེ༌མོའ༌ དུག༌ཁན༌བོ༌ གྱུས༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","ཏེ༌བོ༌ ཏན༌ཏན༌ ཅོའ༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཏེན༌ན༌མལ༌ལ༌ བིང༌ ཡང༌ ཞག༌པོ༌ སུམ༌མི༌ ནང༌ང༌ ཁོང༌གུན༌ནི༌ གྱལ༌ས༌གུན༌ལ༌ ལེབ༌། ཏེ༌གུན༌ གི༌བེ༌འོན༌, ཀེ༌ཕི༌རཧ༌, བེ༌རོཐ༌ དང༌ ཀི༌རི༌འཐ༌ ཡེ༌རིམ༌ གྱལ༌ས༌གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ མ༌ཅོས༌ ཅིའ༌ཟེར༌ན༌ ཨིས༌ར༌ཨེལ༌ལི༌ སྤོན༌བོ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཚན༌ནི༌ ནང༌ང༌ ནའ༌ ཁུར༌ཏེ༌ ཨིན༌པིན༌། ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌, འུ༌སྐྱོང༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཟེར༌གྱུ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","སྤོན༌བོ༌གུན༌ནི༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཚན༌ནི༌ ནང༌ང༌ ང༌དང༌གུན༌ནི༌ ནའ༌ ཁུར༌ པ༌སང༌ ང༌དང༌ངི༌ ཁོང༌གུན༌ལ༌ ལག༌པ༌ རྩེ༌ མི༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","ཨིན༌ནའང༌ ང༌དང༌གུན༌ནི༌ ནའ༌ ཁུར༌ཅེས༌པོའེ༌ དཀོན༌མཆོག༌གི༌ ཐུག༌སྲོ༌ ང༌དང༌གུན༌ནི༌ཀ༌ མི༌བབས༌ཤེས༌ལ༌ ང༌དང༌གུན༌ནི༌ ཁོང༌གུན༌ སོན༌ཏེའ༌ བོར༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","ཁོང༌གུན༌ སོན༌ཏེའ༌ བོར༌གོས༌།” ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཕིའ༌ ཁོང༌གུན༌ ཤིང༌ཅད༌ཁན༌ དང༌ ཆུ༌སྐྱེ༌ཁན༌ གུན༌ ཅོས༌། ཏེན༌ན༌ ཟུག༌གི༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ནའ༌ ཁུར༌ཁན༌བོ༌ མ༌ཅགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","ཡོ༌ཤུའེ༌ གི༌བེ༌འོན༌པ༌གུན༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཏྲིས༌, “ཅི༌ཕིའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཁྱོ༌ཞའ༌ ཐག༌རིང༌ ཡུལ༌ནེ༌ ཨིན༌ ཟེར༌ཏེ༌ ཟུན༌ ཏངས༌ཏེ༌ ང༌ཞའ༌ གོབ༌སྐོར༌པིན༌ ནམ༌ ཁྱོ༌ཞ༌གུན༌ ང༌ཞའེ༌ ཉེ༌མོའ༌ དུག༌ཨིན༌ ཨིན༌ནོག༌? ");
INSERT INTO lbj_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","ཏ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ངན༌ ཕོགས༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ ང༌ཞའེ༌ ཚེ༌ཡོག༌ གྱུར༌ཏེ༌ ཏུས༌གྱུན༌ དཀོན༌མཆོག༌ག༌ ཅོལ༌སའེ༌ ཁང༌པའེ༌ ཕིའ༌ ཤིང༌ ཅད༌ཅེས༌ དང༌ ཆུ༌ སྐྱེ༌ཅེས༌སི༌ ལས༌གུན༌ ཅོ༌གོས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","ཁོང༌གུན༌ནི༌ ཡོ༌ཤུའ༌ ཟེརས༌, “ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌གི༌ ཁོང༌ངི༌ ཡོག༌པོ༌ མོ༌ཟེས༌ལ༌ འི༌ ས༌ཀྱད༌ གང༌པོ༌ ཁྱོ༌ཞའ༌ ཏང༌ཅེས༌ ཡང༌ ཏེ༌ ནང༌ང༌ དུག༌ཁན༌ མི༌ ཚང༌མ༌ སད༌ཅེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ཚོར༌ཏེ༌ ང༌ཞའ༌ མ༌སྲན༌ཏྲེ༌ ཇིགས༌ པ༌སང༌ ང༌ཞ༌རང༌ངི༌ སྲོག༌ སྐྱོབ༌ཅེས༌ལ༌ ང༌ཞའེ༌ ཏེ༌བོ༌ ཅོས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","ཏ༌ ང༌ཞ༌གུན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ལག༌ག༌ ཨིན༌ནོག༌, ཁྱོ༌ཞའེ༌ འོས༌པ༌ སམ༌ཁན༌བོ༌ ང༌ཞ༌གུན༌ ཉམ༌པོ༌ ཅོའ༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཁོང༌གུན༌ སད༌ མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","ཨིན༌ནའང༌ ཏེན༌ན༌ ཞག༌ག༌ ཁོའེ༌ གི༌བེ༌འོན༌པ༌གུན༌ ཡ༌ཝའེ༌ ལྡམ༌མ༌ ཛད༌ཅེས༌ཅན༌ནི༌ ནས༌སའེ༌ཀ༌ ཆོད༌ཁྲིའི༌ ཕིའ༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ཤིང༌ཅད༌ཁན༌ དང༌ ཆུ༌སྐྱེ༌ཁན༌ གུན༌ ཅོས༌། ཁོང༌གུན༌ནི༌ ཏེན༌ན༌ ལས༌པོ༌ དི༌རིང༌ངའང༌ ཅོ༌ཨིན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","ཡོ༌ཤུའེ༌ ཡེ༌རི༌ཀོ༌ གྱལ༌ས༌ དང༌ ཏེ༌བོའེ༌ གྱལ༌པོའ༌ ཅོས༌ཁན༌ ཙོགས༌ ཨའི༌ དང༌ ཏེ༌བོའེ༌ གྱལ༌པོ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ ཁྲེས༌ཏོར༌ ཅོ༌ཁན༌ ཡང༌ གི༌བེ༌འོན༌པ༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཉམ༌པོ༌ ཞི༌དེའེ༌ ཆད༌དོན༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཉེ༌མོའ༌ དུག༌ཁན༌གུན༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌པོ༌ ཨ༌དོ༌ནི༌ཟེ༌དེག༌ག༌ ཚོར༌ར༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","ཁོ༌ དང༌ ཁོའེ༌ མི༌གུན༌ མ༌སྲན༌ཏྲེ༌ ཇིགས༌ ཅིའ༌ཟེར༌ན༌ གི༌བེ༌འོན༌ གྱལ༌པོ༌ མང༌པོའེ༌ཀ༌ ཝང༌སྲུལ༌ཁན༌ མ༌ གྱལ༌ས༌ ཁག༌ཅན༌, ཨའི༌ གྱལ༌ས༌ སང༌ ཆེའ༌ ཡང༌ གི༌བེ༌འོན༌པ༌ མག༌མི༌གུན༌ མ༌ ཀྲག༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","ཏེ༌བོའེ༌ཕིའ༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌པོ༌ ཨ༌དོ༌ནི༌ཟེ༌དེག༌གི༌ ཧེབ༌རོན༌ནི༌ གྱལ༌པོ༌ ཧོ༌ཧམ༌, ཡར༌མུཐ༌ཐི༌ གྱལ༌པོ༌ པི༌རམ༌, ལ༌ཀིཤ༌ཤི༌ གྱལ༌པོ༌ ཡ༌ཕིའ༌ དང༌ ཨེག༌ལོན༌ནི༌ གྱལ༌པོ༌ དེ༌བིར༌ གུན༌ལ༌ ལོན༌ ཀལ༌ཏེ༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“ངའ༌ རོགས༌ ཅོས༌ཏེ༌ གི༌བེ༌འོན༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ལ༌ ཡོང༌ཤིག༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཉམ༌པོ༌ ཞི༌དེ༌ ཆད༌དོན༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","ཏེ༌ནེ༌ ཨ༌མོར༌པའེ༌ གྱལ༌པོ༌ ལྔ༌, ཡེ༌རུ༌ཤ༌ལེམ༌, ཧེབ༌རོན༌, ཡར༌མུཐ༌, ལ༌ཀིཤ༌ དང༌ ཨེག༌ལོན༌ནི༌ གྱལ༌པོ༌གུན༌ ཅིག༌གྲིལ༌ སོང༌། ཁོང༌གུན༌ནི༌ མག༌མི༌ ཚང༌མ༌ ལྡུས༌ཏེ༌ གི༌བེ༌འོན༌ནི༌ གྱལ༌ས༌ སྐོར༌ཏེ༌ ཁོང༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","གི༌བེ༌འོན༌པ༌གུན༌ནི༌ ཡོ༌ཤུའ༌ དུགས༌ཏེ༌ ཡོད༌ས༌ གིལ༌གལ༌ལ༌ ལོན༌ ཀལ༌ཏེ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ཡོག༌པོ༌གུན༌ ཕང༌ང༌ མ༌ཛད༌། གྱོགས༌པ༌ ང༌ཞའ༌ རོགས༌ ཛད༌ད༌ སྐྱོད༌ཏེ༌ ང༌ཞ༌གུན༌ སྐྱོབ༌བ༌ ཛད༌ ཅིའ༌ཟེར༌ན༌ རི༌ ཡུལ༌ལ༌ དུག༌ཁན༌ ཨ༌མོར༌པའེ༌ གྱལ༌པོ༌ ཚང༌མ༌ ཛོམས༌ཏེ༌ ང༌ཞའེ༌ཀ༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","ཏེ༌བོའེ༌ཕིའ༌ ཡོ༌ཤུའ༌ ཁོ༌རང༌ངི༌ མག༌མི༌ ཚང༌མ༌ ཀ༌བོའེ༌ ནང༌ང༌ ཁོའེ༌ ནོལ༌ཁན༌ ཀྲག༌པོ༌ ཚང༌མ༌ ཐེས༌ཏེ༌ གི༌བེ༌འོན༌པ༌གུན༌ལ༌ རོགས༌ ཅོའ༌ལ༌ གིལ༌གལ༌ནེ༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “ཁོང༌གུན༌ལ༌ མ༌ཇིགས༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁོང༌གུན༌ ཁྱོ༌རང༌ངི༌ ལག༌ག༌ ཏངས༌ཏེ༌ ཨིན༌། ཁོང༌ ཅིག༌གིའང༌ ཁོ༌རང༌གུན༌ སྐྱོབ༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","ཡོ༌ཤུའ༌ དང༌ མག༌མི༌གུན༌ གིལ༌གལ༌ནེ༌ ཚན༌ གང༌པོ༌ གྲུལ༌ཏེ༌ ཨ༌མོར༌པ༌གུན༌ནི༌ཀ༌ ཧུན༌མེད༌ལ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","ཡ༌ཝའེ༌, ཁོང༌གུན༌ནི༌ ནང༌ང༌ ཇིགས༌ནང༌ སྐྱེས༌ཏེ༌ ཧན༌གྲང༌ ཆ༌ཅུག༌ག༌ ཛད༌ཅེས༌པོའེ༌ གི༌བེ༌འོན༌ནི༌ ནང༌ང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌ མང༌པོ༌ སད༌ ཉན༌ཏེ༌ ཕམ༌ ཀྲག༌པོ༌ ཀལས༌། ཁོང༌གུན༌ནི༌ ཨ༌མོར༌པ༌གུན༌ལ༌ བེཐ༌ ཧོ༌རོན༌ནི༌ ལམ༌ནེ༌ ཏེད༌ཏེ༌ ཁྱེར༌ཏེ༌ ཨ༌ཟེ༌ཀཧ༌ དང༌ མཀ༌ཀེ༌དཧ༌ གྱལ༌ས༌གུན༌ལ༌ ལེབ༌ལེབ༌ ཚག༌པ༌ ཁོང༌གུན༌ སད༌ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","ཨ༌མོར༌པ༌གུན༌ བེཐ༌ ཧོ༌རོན༌ནི༌ ལམ༌ནེ༌ ཐུར༌ལ༌ ཤོར༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ ཨ༌ཟེ༌ཀཧ༌ ཚོག༌པ༌ ནམ༌ཁའ༌ནེ༌ ཇིགས༌ནང༌ཅན༌ནི༌ སེར༌ར༌རུ༌ མ༌ ཆེན༌མོ༌ ཕབ༌བ༌ ཛདས༌། ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ར༌འི༌ ཉམ༌པོ༌ སད༌ཁན༌ནི༌ སང༌ ཇིགས༌ནང༌ཅན༌ནི༌ སེར༌ར༌རུ༌ ཞས༌ཏེ༌ མང༌ང༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","ཡ༌ཝའེ༌ ཨ༌མོར༌པ༌གུན༌ནི༌ཀ༌ གྱལ༌ཁ༌ སལ༌ཁན༌ནི༌ ཞག༌གི༌ གོ༌ཟུག༌གི༌ཀ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ དུན༌ལ༌ ཡོ༌ཤུའེ༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌ཏེ༌ ཟེརས༌, “ཉི༌མ༌ མ༌སྐྱོད༌ད༌ གི༌བེ༌འོན༌ནི༌ཀ༌ ལུས༌ཤུག༌ག༌ ཛད༌ཤིག༌། ཡང༌ ཨའི༌ཡ༌ལོན༌ ལུང༌པའེ༌ཀ༌ ལྫ༌ཝ༌ ལུས༌ཤུག༌ག༌ ཛད༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","ཏེ༌བོའེ༌ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གྲ༌འོ༌གུན༌ནི༌ཀ༌ གྱལ༌ཁ༌ ཐོབ༌ཐོབ༌ ཚོག༌པ༌ ཉི༌མ༌ གྲུལ༌ མ༌གྲུལ༌ལ༌ ཡང༌ ལྫ༌ཝ༌ ནས༌ས༌ ཅིག༌གི༌ཀ༌ དུགས༌།” འི༌ ཇུང༌ཁན༌ནི༌ སྐོར༌གུན༌ ཡ༌ཤར༌རི༌ ལྡེབ༌བི༌ ནང༌ང༌ བྲིས༌ཏེ༌ མི༌དུག༌ག༌། ཉི༌མ༌ ནམ༌ཁའེ༌ སྐྱིལ༌ལ༌ མ༌གྲུལ༌ལ༌ དུགས༌ཏེ༌ མ༌སྐྱོད༌ད༌ ཐེ༌བ༌ ཞག༌ཅིག༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","མོས༌ལམ༌ ཞུ༌ཁན༌བོའ༌ ཡ༌ཝའེ༌ ལན༌ སལ༌ལ༌ ཛད༌ཁན༌ནི༌ ཏེ༌ ཙོགས༌སི ཞག༌ དི༌རིང༌ ཚོགས༌པ༌ མ༌ནེ༌ མ༌ཇུང༌ ཡ༌ ཡོང༌ཅེས༌སི༌ ཏུས༌སི༌ ནང༌ངའང༌ མི༌ཇུང༌། དེན༌བའ༌, ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ཡ༌ཝའེ༌ ནོལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌ ཚང༌མ༌ ཉམ༌པོ༌ ཁོ༌རང༌གུན༌ དུགས༌ཏེ༌ ཡོད༌ས༌ གིལ༌གལ༌ལ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","ཏེན༌ན༌ ཟ༌ནེ༌ གྱལ༌པོ༌ ལྔ༌ཀོའང༌ ཤོར༌ཏེ༌ མཀ༌ཀེ༌དཧ༌ གྲོང༌ཁྱེར༌རི༌ བྲག༌ཕུགས༌སི༌ ནང༌ང༌ ཨིབས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","ཁོང༌གུན༌ མཀ༌ཀེ༌དཧ༌ གྲོང༌ཁྱེར༌རི༌ བྲག༌ཕུགས༌སི༌ ནང༌ང༌ ཨིབས༌ཏེ༌ དུགས༌ ཟེར༌ཏེ༌ ཡོ༌ཤུའ༌ ཚོར༌ར༌ཅིག༌ ");
INSERT INTO lbj_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","ཁོའེ༌ བཀའ༌ ཏངས༌, “བྲག༌ཕུགས༌སི༌ ཁའེ༌ཀ༌ རྡོའ༌ ཆེན༌མོ༌གུན༌ ཀབས༌ཏེ༌ ཏེ༌ཀ༌ སྲུང༌ཁན༌ མག༌མི༌ ཁ༌ཅིག༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","ཏེ༌རུ༌ དུག༌ མ༌དུག༌ ཨིན༌ནའང༌ གྲ༌འོའེ༌ མག༌མི༌གུན༌ལ༌ ཏེད༌ཏེ༌ གྱབ༌ནེ༌ སྤུང༌གོལ༌ ཅོས༌། ཁོང༌གུན༌ལ༌ ལོགས༌ཏེ༌ ཁོང༌རང༌གུན༌ནི༌ གྲོང༌ཁྱེར༌ལ༌ ཆ༌ཅེས༌སི༌ སྐབས༌ མ༌ཏང༌ ཅིའ༌ཟེར༌ན༌ ང༌དང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ ང༌དང༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","ཏེ༌བོའེ༌ཕིའ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྲ༌འོ༌ ཚང༌མ༌ སད༌ཏེ༌ མེད༌ཁན༌ ཅོས༌། ཨིན༌ནའང༌ གྱལ༌སའེ༌ གྱང༌སྐོར༌ སྟན༌པོའེ༌ ནང༌ང༌ ཞུགས༌ ཉན༌ཁན༌ ཉུ༌ངུན༌ཞིག༌ མ༌ཤིའ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌གུན༌ མཀ༌ཀེ༌དཧ༌ ནང༌ང༌ ཡོ༌ཤུའ༌ ཡོད༌ས༌ ཁམ༌ཟང༌ ལོགས༌ཏེ༌ ཡོངས༌, ཏེ༌ནེ༌ ཕར༌ལ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ གྲ༌འོ༌ སུ༌ཞིག༌གིའང༌ ཁོང༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ སྤེ༌ར༌ ཚིགས༌ ཅིག༌ ཟེར༌ཅེས༌སི༌ ཧམ༌པ༌ མ༌ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","ཡོ༌ཤུའེ༌ ཟེརས༌, “བྲག༌ཕུགས༌སི༌ ཁའ༌ ཀབས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ རྡོའ༌གུན༌ ཐེན༌ཏེ༌ གྱལ༌པོ༌ ལྔ༌ཀོ༌ ང༌ ཡོད༌ས༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཡེ༌རུ༌ཤ༌ལེམ༌, ཧེབ༌རོན༌, ཡར༌མུཐ༌, ལ༌ཀིཤ༌ དང༌ ཨེག༌ལོན༌ནི༌ གྱལ༌པོ༌ ལྔ༌ཀོ༌ བྲག༌ཕུགས༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","ཁོང༌གུན༌ ཁྱོང༌ང༌ཅིག༌ ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌ ཚང༌མ༌ བོད༌ཏེ༌ ཁྱོངས༌ཏེ༌ མག༌མི༌ འུ༌སྐྱོང༌གུན༌ལ༌ ཟེརས༌, “ཡོང༌, གྱལ༌པོ༌གུན༌ནི༌ ཇིང༌བའེ༌ཀ༌ ཁྱོ༌ཞའེ༌ རྐང༌པ༌ བོར༌།” ཡང༌ ཁོང༌གུན༌ནི༌ ཡོ༌ཤུའེ༌ ཟེར༌ཁན༌བོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཇིགས༌ མ༌ ཇིགས༌ ཡང༌ སྤོས༌པ༌ མ༌ཆག༌། ཤེད༌ཅན༌ དང༌ སེམས༌ཤུགས༌ཅན༌ གྱུར༌། ང༌དང༌ངི༌ གྲ༌འོ༌ ཚང༌མ༌ ཉམ༌པོ༌ ཡ༌ཝའེ༌ འིན༌ན༌ ཙོགས༌ ཅོའ༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ གྱལ༌པོ༌ ལྔ༌ཀོ༌ སད༌ཏེ༌ ཁོང༌གུན༌ནི༌ རོ༌ རྡུང༌མ༌ ལྔའེ༌ཀ༌ ཕི༌ཏོག༌ ཚོག༌པ༌ ཏགས༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","ཉི༌མ༌ སྐྱོད༌ད༌ཅིག༌ གྱལ༌པོ༌གུན༌ནི༌ རོ༌ རྡུང༌མའེ༌ ཀ༌ནེ༌ ཕབས༌ཏེ༌ ཁོང༌གུན༌ ཨིབས༌ཏེ༌ དུག༌སའེ༌ བྲག༌ཕུགས༌སི༌ ནང༌ང༌ ཕང༌ཏེ༌ ཁའེ༌ཀ༌ རྡོའ༌ ཆེན༌མོ༌གུན༌ ཀབ༌ཅེས༌ལ༌ ཡོ༌ཤུའེ༌ བཀའ༌ ཏངས༌། ཁོང༌གུན༌ནི༌ རོ༌ ཏེ༌རུ༌ དག༌སའང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","ཏེན༌ན༌ ཞག༌ག༌ ཡོ༌ཤུའེ༌ མཀ༌ཀེ༌དཧའེ༌ གྲོང༌ཁྱེར༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ ཡང༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ གྱལ༌པོ༌ ཐེས༌ཏེ༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོས༌, སུ༌ཞིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ཁོའེ༌ ཡེ༌རི༌ཀོའེ༌ གྱལ༌པོའ༌ ཅོ༌ཁན༌ ཙོགས༌ མཀ༌ཀེ༌དཧའེ༌ གྱལ༌པོ༌ ཉམ༌པོའང༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌ ཚང༌མ༌ མཀ༌ཀེ༌དཧའེ༌ གྲོང༌ཁྱེར༌ནེ༌ ལིབ༌ནཧ༌ གྱལ༌ས༌ སོང༌ཏེ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","ཡ༌ཝའེ༌ ཏེ༌ གྱལ༌ས༌ དང༌ གྱལ༌པོ༌ ཁོང༌གུན༌ནི༌ ལག༌ག༌ སལས༌། ཁོང༌གུན༌ནི༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོས༌, སུ༌ ཞིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ཡོ༌ཤུའེ༌ ཡེ༌རི༌ཀོའེ༌ གྱལ༌པོའ༌ ཅོ༌ཁན༌ ཙོགས༌ ལིབ༌ནཧའེ༌ གྱལ༌པོ༌ ཉམ༌པོའང༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","ལིབ༌ནཧ༌ ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌ ཚང༌མ༌ ལ༌ཀིཤ༌ གྱལ༌ས༌ སོང༌ ཡང༌ ཏེ༌བོའ༌ མག༌མི༌ སྐོར༌ཏེ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","ཞག༌ ཉིས༌པའེ༌ ཞག༌ག༌, ཡ༌ཝའེ༌ ཁོང༌གུན༌ནི༌ ལག༌ག༌ ཏེ༌ གྱལ༌ས༌ སལ༌ལ༌ ཛདས༌། ཁོང༌གུན༌ནི༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ སདས༌ ཀ༌ཟུག༌ ཁོང༌ངི༌ ལིབ༌ནཧ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","ཏེ༌ཏུས༌ གེ༌ཟེར༌ གྱལ༌སའེ༌ གྱལ༌པོ༌ ཧོ༌རམ༌ ལ༌ཀིཤ༌ཤི༌ གྱལ༌པོའ༌ རོགས༌ ཅོ༌ཅེས༌ལ༌ ཁོང༌རང༌ངི༌ མག༌མི༌ ཁྲིད༌ཏེ༌ ཡོངས༌ ཨིན༌ནའང༌ ཡོ༌ཤུའེ༌ མག༌མི༌གུན༌ནི༌ ཁོ༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ སད༌ཏེ༌ སུའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ མག༌མི༌ ཚང༌མ༌ ཨེག༌ལོན༌ གྱལ༌ས༌ སོང༌ ཡང༌ ཏེ༌བོའ༌ མག༌མི༌ སྐོར༌ཏེ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","ཏེན༌ན༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ ཏེ༌ གྱལ༌ས༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ ཡང༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ སདས༌ ཀ༌ཟུག༌ ཁོང༌གུན༌ནི༌ ལ༌ཀིཤ༌ལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ མག༌མི༌ ཚང༌མ༌ ཨེག༌ལོན༌ ནེ༌ ཧེབ༌རོན༌ནི༌ གྱལ༌ས༌ སོང༌ཏེ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","ཁོང༌གུན༌ནི༌ གྱལ༌ས༌ དང༌ ཏེ༌ ཉེ༌ཁོར༌རི༌ གྲོང༌ཁྱེར༌ ཚང༌མ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ ཡང༌ གྱལ༌པོ༌ ཐེས༌ཏེ༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ སདས༌, སུའང༌ སོན༌ཏེའ༌ མ༌བོརས༌ ཀ༌ཟུག༌ ཁོང༌གུན༌ནི༌ ཨེག༌ལོན༌ལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌ ཚང༌མ༌ ལོགས༌ཏེ༌ ལྷོ༌ ཆོགས༌ལ༌ སོང༌ ཡང༌ དེ༌བིར༌ གྱལ༌སའེ༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","ཁོང༌ངི༌ གྱལ༌ས༌, ཏེ༌བོའེ༌ གྱལ༌པོ༌ ཡང༌ ཏེ༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ ཏེ༌ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོས༌, སུ༌ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ཁོང༌ངི༌ ཧེབ༌རོན༌ དང༌ ལིབ༌ནཧ༌ ཡང༌ ཏེ༌གུན༌ནི༌ གྱལ༌པོའ༌ ཅོས༌ཁན༌ ཙོགས༌ དེ༌བིར༌ དང༌ ཏེ༌བོའེ༌ གྱལ༌པོ༌ ཉམ༌པོའང༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","ཡོ༌ཤུའེ༌ ཡུལ༌ཇོངས༌ གང༌པོ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ཏེ༌གུན༌ ནི༌ རི༌ ཡུལ༌གུན༌, ནེ༌གེཝ༌, ནུབ༌ ཆོགས༌སི༌ རི༌ ཡོག༌, རི༌ ཁྲེད༌དི༌ ཡུལ༌གུན༌ དང༌ གྱལ༌པོ༌གུན༌ ཨིན༌པིན༌, ཁོང༌ངི༌ མི༌ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ བཀའ༌ ནང༌ཞིན༌ ཁོང༌ངི༌ འུགས༌ ལེན༌ཁན༌ ཚང༌མ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","ཡོ༌ཤུའེ༌ ཀ༌དེཤ༌ བར༌ནེའ༌ནེ༌ ཏངས༌ཏེ༌ ག༌ཟ༌ ཡང༌ གོ༌ཤེན༌ནི༌ ཡུལ༌ ཚང༌མ༌ གི༌བེ༌འོན༌ ཚོག༌པ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","འིན༌ན༌ ཏུས༌ལ༌ ཡོ༌ཤུའེ༌ ཏེ༌ གྱལ༌པོ༌ དང༌ ཁོང༌གུན༌ནི༌ ས༌ཀྱད༌ ཚང༌མ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ ཅིའ༌ཟེར༌ན༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌, ཁོང༌རང༌ངི༌ མི༌གུན༌ནི༌ ཕིའ༌ ནོལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌ ཚང༌མ༌ ལོགས༌ཏེ༌ ཁོང༌གུན༌ ཀུར༌ ཙུགས༌ཏེ༌ དུག༌ས༌ གིལ༌གལ༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","ཧ༌ཟོར༌རི༌ གྱལ༌པོ༌ ཡ༌བིན༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌ གྱལ༌ཁ༌ ཐོབ༌ཁན༌ ཚང༌མའེ༌ ནས༌ཚུལ༌ ཚོར༌ར༌ཅིག༌ ཁོའེ༌ མ༌དོན༌ནི༌ གྱལ༌པོ༌ ཡོ༌བབ༌, ཤིམ༌རོན༌ནི༌ གྱལ༌པོ༌ དང༌ ཨཀ༌ཤཕ༌ཕི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","བྱང༌ ཆོགས༌སི༌ རི༌ ཡུལ༌ལི༌ གྱལ༌པོ༌གུན༌, གཱ༌ལིལ༌ལི༌ ཚོའེ༌ ལྷོ༌ ཆོགས༌ དང༌ ནུབ༌ ཆོགས༌སི༌ རི༌ཡུལ༌ ཡོར༌དཱན༌ ལུང༌པའེ༌ གྱལ༌པོ༌གུན༌, ནུབ༌ ཆོགས༌སི༌ ན༌ཕོཐ༌ དོར༌རི༌ གྱལ༌པོ༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ཀེ༌ནན༌ནི༌ ཤར༌ དང༌ ནུབ༌བི༌ གྱལ༌པོ༌གུན༌, རི༌ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཨ༌མོར༌པ༌, ཧེད༌པ༌, པེ༌རིཟ༌པ༌ དང༌ ཡེ༌བས༌པ༌ ཡང༌ མིཟ༌པཧ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ རི༌ ཧེར༌མོན༌ནི༌ ཡོག༌ག༌ དུག༌ཁན༌ ཧིཝ༌པའེ༌ གྱལ༌པོ༌གུན༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ལ༌ ཡོང༌ཅེས༌ལ༌ ལོན༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","ཏེ༌ གྱལ༌པོ༌ ཚང༌མ༌ མག༌མི༌, རྟ༌ དང༌ རྟ༌རེལ༌ མ༌མང༌པོ༌ ཉམ༌པོ༌ ནོལ༌ལ༌ ཡོངས༌། ཁོང༌གུན༌ནི༌ མག༌མི༌གུན༌ ཛོམ༌མ༌ཅིག༌ ཚོའེ༌ ཐའ༌མའེ༌ པེ༌མ༌ དང༌ ཙོགས༌ མ༌མང༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","ཏེ༌ གྱལ༌པོ༌ ཚང༌མའེ༌ མག༌མི༌ ཛོམས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ནོལ༌ཅེས༌ལ༌ མེ༌རོམ༌མི༌ ཆུའི༌ ཉེ༌མོའ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, “ཁོང༌གུན༌ལ༌ མ༌ཇིགས༌ ཅིའ༌ཟེར༌ན༌ ཐོ༌རེ༌ འིན༌ན༌ ཏུས༌ལ༌ ངའེ༌ ཁོང༌ ཚང༌མ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ཏེ༌ སད༌ཨིན༌། ཁྱོ༌ཞའེ༌ ཁོང༌གུན༌ནི༌ རྟ༌གུན༌ ཞ༌འོ༌ ཅོས༌ཏེ༌ རྟ༌རེལ༌གུན༌ མེའ༌ སྲག༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཁོའེ༌ མག༌མི༌ ཚང༌མ༌ མེ༌རོམ༌མི༌ ཆུའི༌ ཉེ༌མོའ༌ སོང༌ཏེ༌ ཧུན༌མེད༌ལ༌ ཁོང༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","ཡང༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ལག༌ག༌ སྟདས༌། ཁོང༌གུན༌ནི༌ གྲ༌འོ༌གུན༌ལ༌ བྱང༌ ཆོགས༌སི༌ སི༌དོན༌ གྱལ༌ས༌ དང༌ མིས༌རེ༌ཕོཐ༌ མཱའིམ༌ ཡང༌ ཤར༌ ཆོགས༌ལ༌ མིཟ༌པཧ༌ ལུང༌པ༌ ཚོག༌པ༌ ཏེད༌ཏེ༌ ཁྱེརས༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཕམ༌ཀལ༌ཏེ༌ ཁོང༌ ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","ཡ༌ཝའེ༌ མོལ༌ཁན༌ ནང༌ཞིན༌ ཡོ༌ཤུའེ༌ གྲ༌འོའེ༌ རྟ༌གུན༌ ཞ༌འོ༌ ཅོས༌ཏེ༌ རྟ༌རེལ༌གུན༌ མེའ༌ ཏུག༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","ཏེ༌ནེ༌ ཡོ༌ཤུའ༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ ལོགས༌ཏེ༌ ཧ༌ཟོར༌ལ༌ སོང༌ ཡང༌ ཏེ༌བོ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ གྱལ༌པོ༌ སདས༌། ༼ཧ༌ཟོར༌རི༌ གྱལ༌པོའེ༌ ཏེ༌ གྱལ༌ཁམས༌ ཚང༌མའེ༌ཀ༌ ཝང༌སྲུལ༌ལད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱལ༌སའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོས༌, ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌, ཅིག༌གའང༌ མ༌ཕུདས༌ ཡང༌ ཡོ༌ཤུའེ༌ གྱལ༌ས༌བོ༌ མེའ༌ ཏུག༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","ཡོ༌ཤུའེ༌ ཏེ༌ གྱལ༌པོ༌ ཚང༌མ༌ དང༌ ཁོང༌གུན༌ནི༌ གྱལ༌ས༌ ཚང༌མ༌ ང༌ཡོག༌ག༌ ལེནས༌ ཡང༌ ཁོང༌ ཚང༌མ༌ སད༌ཏེ༌ སིང༌ མེད༌ཁན༌ ཅོས༌ ཀ༌ཟུག༌ ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","ཨིན༌ནའང༌ ཡོ༌ཤུའེ༌ མེའ༌ ཏུག༌ཁན༌ ཧ༌ཟོར༌རི༌ གྱལ༌ས༌ ཅིག༌པོ༌ མ༌སྟོག༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མག༌གི༌ ནང༌ང༌ ཤིག༌ཁན༌ གྱལ༌སའེ༌ རོ༌ཏོའི༌ཀ༌ རྩིགས༌ཏེ༌ ཡོད༌ཁན༌ ཞན༌ གྱལ༌ས༌གུན༌ མེའ༌ མ༌ ཏུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཏེ༌ གྱལ༌ས༌གུན༌ནེ༌ ཅོམས༌ཁན༌ནི༌ ཅ༌ལག༌ དང༌ ཀྲུད༌ཏྲོ༌ གུན༌ ཁོང༌རང༌གུན༌ནི༌ ཕིའ༌ ཁྱེརས༌། ཨིན༌ནའང༌ མི༌ཚང༌མ༌ སདས༌, ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","ཡ༌ཝའེ༌ ཁོང༌ངི༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ཙོགས༌ལ༌ མོ༌ཟེས༌སི༌ ཡོ༌ཤུའ༌ བཀའ༌ ཏངས༌ ཡང༌ ཡོ༌ཤུའེ༌ བཀའ༌ ནང༌ཞིན༌ ཅོས༌། ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ཚང༌མ༌ ཁོའེ༌ ཅའང༌ ལུས༌ མ༌ཅུག༌ག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","ཡོ༌ཤུའེ༌ ཡུལ༌ཇོངས༌ གང༌པོ༌ ཁོ༌རང༌ངི༌ ང༌ཡོག༌ག༌ ཁྱོངས༌, ཡང༌ན༌ རི༌ཡུལ༌, ནེ༌གེཝ༌ གང༌པོ༌, གོ༌ཤེན༌ནི༌ ནས༌ས༌ གང༌པོ༌, ནུབ༌ ཆོགས༌སི༌ རི༌ ཡུལ༌གུན༌, ཡོར༌དཱན༌ ལུང༌པ༌, ཨིས༌ར༌ཨེལ༌ལི༌ རི༌གུན༌ དང༌ གཱ༌ལིལ༌ལིའི༌ རི༌ ཡུལ༌གུན༌, ");
INSERT INTO lbj_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","ཨིས༌ར༌ཨེལ༌ལི༌ ས༌ཀྱད༌ ཧ༌ལག༌གི༌ རི༌ནེ༌ ལྷོ༌ ཆོགས༌སི༌ རི༌ཡུལ༌ སེ༌འིར༌, ཧེར༌མོན༌ རི༌ ཡོག༌ག༌ ལེ༌བ༌ནོན༌ནི༌ ལུང༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ བའལ༌ གཱད༌ ཚག༌པ༌། ཡོ༌ཤུའེ༌ ཏེ༌ ཡུལ༌ གང༌པོ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ ཏེ༌གུན༌ནི༌ གྱལ༌པོ༌ དང༌ མི༌ ཚང༌མ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","ཏེ༌ གྱལ༌པོ༌ ཚང༌མ༌ ཉམ༌པོ༌ ཏུས༌ མང༌པོ༌ ཞིག༌ ཡོ༌ཤུའེ༌ མག༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","གི༌བེ༌འོན༌ནི༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཧེད༌པ༌གུན༌ མ༌སྟོག༌ ཞན༌ གྱལ༌ཁམས༌ སུའིང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཉམ༌པོ༌ ཞི༌དེ༌ ཆད༌དོན༌ མ༌ཅོས༌, ཁོང༌གུན༌ནི༌ མག༌ ཏངས༌ཏེ༌ ཏེ༌ ནས༌ས༌ ཚང༌མ༌ ང༌ཡོག༌ག༌ ལེནས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ སྙིང༌རྗེ༌ མ༌ནེ༌ མེད༌པ༌ ཁོང༌གུན༌ སིང༌ མེད༌ཁན༌ ཅོ༌ཅེས༌ལ༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ནི༌ སྙིང༌ སྐྱོང༌པོ༌ ཛད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཉམ༌པོ༌ ནོལ༌ ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","ཏེན༌ན༌ ཏུས༌ལ༌ ཡོ༌ཤུའེ༌ མག༌མི༌གུན༌ནི༌ ཧེབ༌རོན༌, དེ༌བིར༌ དང༌ ཨ༌ནབ༌ གྱལ༌ས༌གུན༌ནི༌ ཉེ༌མོའ༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ དུག༌ཁན༌ ཨ༌ནཀ༌པ༌ ཚང༌མ༌ མ༌ཚད༌ ཡ༌ཧུ༌དཱ༌ དང༌ ཨིས༌ར༌ཨེལ༌ རི༌ཡུལ༌གུན༌ནི༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མའང༌ སད༌ཏེ༌ མེད༌ཁན༌ ཅོས༌། ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ དང༌ ཁོང༌གུན༌ནི༌ གྲོང༌ཁྱེར༌ ཚང༌མ༌ སིང༌ མེད༌ཁན༌ ཅོ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","ཕི༌ལིས༌ཏི༌པའེ༌ ནས༌ས༌ ག༌ཟ༌, གཱད༌, དང༌ ཨཤ༌དོད༌ གུན༌ནི༌ ནང༌ང༌ ལུས༌ཁན༌ ཁ༌ཅིག༌ མ༌སྟོགས༌ ཨིས༌ར༌ཨེལ༌པའེ༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཁོང༌གུན༌ནི༌ ཨ༌ནཀ༌པ༌ ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","ཡོ༌ཤུའེ༌ ཏེ༌ ས༌ཆའ༌ གང༌པོ༌ ཁོ༌རང༌ངི༌ ཝང༌ངི༌ ཡོག༌ག༌ ཁྱོངས༌ ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌, ཡང༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ ཁོང༌ངི༌ ཏེ༌ ས༌ཀྱད༌པོ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མི༌སྡེ༌གུན༌ལ༌ བགོས༌ཏེ༌ ཏངས༌། ཏེ༌ སྟིང༌ནེ༌ ཏེ༌ ས༌ཆའེ༌ ནང༌ང༌ མག༌ ཏང༌ཅེས༌ མེད༌ཁན༌ སོང༌ཏེ༌ ཞི༌དེ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌སི༌ གྱལ༌པོ༌གུན༌ སད༌ཏེ༌ ཁོང༌གུན༌ནི༌ ས༌ཀྱད༌ ལེན༌ཏེ༌ ཨིན༌པིན༌, ཏེ༌བོ༌ ཨར༌ནོན༌ ལུང༌པ༌ ནེ༌ ཏངས༌ཏེ༌ ཧེར༌མོན༌ རི༌ ཚག༌པ༌ ཀ༌བོའེ༌ ནང༌ང༌ ཡོར༌དཱན༌ ལུང༌པའེ༌ ཤར༌ ཆོགས༌སི༌ ནས༌ས༌ ཚང༌མ༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","ཏེ༌ གྱལ༌པོ༌གུན༌: ཧེཤ༌བོན༌ནི༌ ནང༌ང༌ དུག༌ཁན༌ ཨ༌མོར༌པ༌ གྱལ༌པོ༌ སི༌ཧོན༌, ཁོའེ༌ གྱལ༌ཁམས༌གུན༌ནི༌ ནང༌ང༌ ཨར༌ནོན༌ ལུང༌པའེ༌ ཐའ༌མ༌ ཡོད༌ཁན༌ ཨ༌རོ༌འེར༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌, ཏེ༌བོ༌ ཨར༌ནོན༌ ལུང༌པའེ༌ སྐྱིལ༌ནེ༌ ཡབ༌བོག༌ ལྩངས༌པོ༌ ཚག༌པ༌ ཀ༌བོ༌ ཨེམ༌མོན༌པ༌གུན༌ནི༌ སན༌ཚམས༌ ཨིན༌པིན༌། འི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ གི༌ལེད༌དི༌ ལྷོ༌ ཆོགས༌སི༌ ཡུལ༌ ཕེད༌པོ༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","གྱལ༌པོ༌ སི༌ཧོན༌ནི༌ ཡོར༌དཱན༌ནི༌ ལུང༌པ༌ དང༌ ཤར༌ ཆོགས༌སི༌ ཡུལ༌ཇོངས༌གུན༌ནི༌ ནང༌ང༌ ཝང༌སྲུལ༌ ལད༌པིན༌, ཏེ༌བོ༌ བྱང༌ ཆོགས༌སི༌ གཱ༌ལིལ༌ལིའི༌ ཚོ༌ ནེ༌ ལྷོ༌ ཆོགས༌སི༌ ཚོ༌རུལ༌ ཚག༌པ༌ ཡང༌ བེཐ༌ ཡེ༌ཤི༌མོཐ༌ཐི༌ ལྷོ༌ ཆོགས༌ནེ༌ པིས༌གཧའེ༌ ཁྲེད༌ ཚག༌པ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","བ༌ཤན༌ནི༌ གྱལ༌པོ༌ ཨོག༌, རེ༌ཕ༌པ༌ མིར༌གྱུད༌དི༌ སྟིང༌ཇུག༌གི༌ མི༌ ཨིན༌པིན༌, ཁོའེ༌ ཨཤ༌ཏ༌རོཐ༌ དང༌ ཨེད༌རེའི༌ གྱལ༌ས༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","ཁོའེ༌ ཧེར༌མོན༌ རི༌ནེ༌ ཏངས༌ཏེ༌ བྱང༌ ཆོགས༌སི༌ ས༌ལ༌ཀཧ༌ ཚག༌པ༌, ཤར༌ལ༌ བ༌ཤན༌ གང༌པོ༌, ནུབ༌བ༌ གེ༌ཤུར༌ དང༌ མའ༌ཀཧའེ༌ སན༌ཚམས༌ ཚག༌པ༌, གི༌ལེད༌དི༌ བྱང༌ ཆོགས༌ ཕེད༌ ཡང༌ ཧེཤ༌བོན༌ནི༌ གྱལ༌པོ༌ སི༌ཧོན༌ནི༌ སན༌ཚམས༌ ཚོག༌པ༌ ཝང༌སྲུལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཏེ༌ གྱལ༌པོ༌ ཉིས༌ཀོའ༌ ཕམ༌ཀལས༌ ཡང༌ མོ༌ཟེས༌སི༌ ཏེ༌ ས༌ཀྱད༌གུན༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མི༌སྡེ༌ ཡང༌ མ༌ནས༌ས༌ མི༌སྡེ༌ ཕེད༌ གུན༌ལ༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ བགོས༌ཏེ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ མག༌མི༌གུན༌ནི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ནུབ༌ ཆོགས༌ལ༌ ཕམ༌ཀལ༌ཁན༌ནི༌ གྱལ༌པོ༌གུན༌ནི༌ མིང༌ངི༌ ཐོ༌ འི༌བོ༌ ཨིན༌ནོག༌། ལེ༌བ༌ནོན༌ནི༌ ལུང༌པའེ༌ བའལ༌ གཱད༌ནེ༌ ཏངས༌ཏེ༌ ཧ༌ལཀ༌ རི༌ ཚོག༌པ༌ ཀ༌བོ༌ སེ༌འིར༌ ཡུལ༌ཇོངས༌སི༌ ཉེ༌མོའ༌ ཨིན༌ནོག༌ ༼ཡོ༌ཤུའེ༌ ཏེ༌ ས༌ཀྱད༌ ཚང༌མ༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌ ལུས༌ཁན༌གུན༌ལ༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ བགོས༌ཏེ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","ཏེ༌བོའེ༌ ནང༌ང༌ རི༌ཡུལ༌ དང༌ ནུབ༌ ཆོགས༌སི༌ རི༌ཡོག༌ གུན༌, ཡོར༌དཱན༌ནི༌ ལུང༌པ༌, རི༌ ཁྲེད༌གུན༌, ཡ༌ཧུ༌དཱའེ༌ ཐང༌སྟོང༌ དང༌ ནེ༌གེཝ༌ ཨིན༌པིན༌། འི༌ ཡུལ༌ཇོངས༌གུན༌ནི༌ ནང༌ང༌ ཧེད༌པ༌, ཨ༌མོར༌པ༌, ཀེ༌ནན༌པ༌, པེ༌རིཟ༌པ༌, ཧིཝ༌པ༌ དང༌ ཡེ༌བས༌པ༌ གུན༌ དུག༌གད༌པིན༌།༽ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕམ༌ཀལ༌ཁན༌ནི༌ གྱལ༌པོ༌གུན༌ ནི༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","ཡེ༌རི༌ཀོའེ༌ གྱལ༌པོ༌, བེ༌ཐེལ༌ལི༌ ཉེ༌མོའ༌ ཡོད༌ཁན༌ ཨའི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌པོ༌, ཧེབ༌རོན༌ནི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ཡར༌མུཐ༌ཐི༌ གྱལ༌པོ༌, ལ༌ཀིཤ༌ཤི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ཨེག༌ལོན༌ནི༌ གྱལ༌པོ༌, གེ༌ཟེར༌རི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","དེ༌བིར༌རི༌ གྱལ༌པོ༌, གེ༌དེར༌རི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ཧོར༌མཧའེ༌ གྱལ༌པོ༌, ཨ༌རད༌དི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ལིབ༌ནཧའེ༌ གྱལ༌པོ༌, ཨ༌དུལ༌ལམ༌མི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","མཀ༌ཀེ༌དཧའེ༌ གྱལ༌པོ༌, བེ༌ཐེལ༌ལི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ཏཔ༌པུ༌འཧའེ༌ གྱལ༌པོ༌, ཧེ༌ཕེར༌རི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ཨ༌ཕེཀ༌ཀི༌ གྱལ༌པོ༌, ལ༌ཤ༌རོན༌ནི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","མ༌དོན༌ནི༌ གྱལ༌པོ༌, ཧ༌ཟོར༌རི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ཤིམ༌རོན༌ མེ༌རོན༌ནི༌ གྱལ༌པོ༌, ཨཀ༌ཤཕ༌ཕི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ཏའ༌ནག༌གི༌ གྱལ༌པོ༌, མེ༌གིད༌དོའེ༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ཀེ༌དེཤ༌ཤི༌ གྱལ༌པོ༌, ཀར༌མེལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཡོཀ༌ནེའམ༌མི༌ གྱལ༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ནཕ༌ཕོཐ༌ དོར༌རི༌ ནང༌ང༌ ཡོད༌ཁན༌ དོར༌རི༌ གྱལ༌པོ༌, གིལ༌གལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ གོ༌ཡིམ༌མི༌ གྱལ༌པོ༌ ");
INSERT INTO lbj_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","དང༌ ཏིར༌ཟཧཱི༌ གྱལ༌པོ༌ གུན༌ ཨིན༌པིན༌། ཚང༌མ༌ རྩི༌ན༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌གུན༌ནི༌ གྱལ༌པོ༌ 31 ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","ཡོ༌ཤུའ༌ རྒད༌པོ༌ སོང༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “ཁྱོ༌རང༌ མ༌རྒད༌པོ༌ སོང༌ཏེ༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ ཏ༌རུང༌ ང༌ཡོག༌ག༌ ཁྱོང༌ཅེས༌ལ༌ ས༌ཀྱད༌ མང༌པོ༌ ལུས༌ཏེ༌ ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","ལུས༌ཁན༌ནི༌ ས༌ཀྱད༌གུན༌ ནི༌ ཕི༌ལིས༌ཏི༌ དང༌ གེ༌ཤུར༌རི༌ ཡུལ༌ཇོངས༌ ཚང༌མ༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","ཨི༌ཇིབ༌བི༌ ཤར༌ ཆོགས༌སི༌ སན༌ཚམས༌སི༌ཀ༌ ཡོད༌ཁན༌ ཤི༌ཧོར༌རི༌ ཀྲོག༌པོ༌ ནེ༌ ཏངས༌ཏེ༌ བྱང༌ ཆོགས༌ལ༌ ཨེཀ༌རོན༌ནི༌ སན༌ཚམས༌ ཚོག༌པ༌, ༼ཏེ༌ནང༌ང༌ ཀེ༌ནན༌ནི༌ གྱལ༌ས༌ ལྔ༌ ག༌ཟ༌, ཨཤ༌དོད༌, ཨཤ༌ཀེ༌ལོན༌, གཱད༌ དང༌ ཨེཀ༌རོན༌, ཕི༌ལིས༌ཏི༌པའེ༌ ཝང༌སྲུལ༌པ༌གུན༌ནི༌ ཡོག༌ག༌ ཡོད༌ཁན༌གུན༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌༽, དང༌ ཨཝ༌པ༌གུན༌ནི༌ ས༌ཀྱད༌ ལྷོ༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","འི༌ ས༌ཀྱད༌ ཚང༌མ༌ ཏ༌རུང༌ ང༌ཡོག༌ག༌ མ༌ ཁྱོང༌ང༌ ཨིན༌ནོག༌, ཀེ༌ནན༌པ༌གུན༌ནི༌ ས༌ཀྱད༌ གང༌པོ༌ ཡང༌ན༌ སི༌དོན༌པ༌གུན༌ནི༌ ས༌ཀྱད༌ མེའེ༌རཧ༌ ནེ༌ ཨ༌ཕེཀ༌ ཚག༌པ༌ ཀ༌བོ༌ ཨ༌མོར༌པ༌གུན༌ནི༌ སན༌ཚམས༌སི༌ཀ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","གི༌བལ༌པ༌གུན༌ནི༌ ས༌ཀྱད༌ དང༌ ཤར༌ ཆོགས༌ལ༌ ལེ༌བ༌ནོན༌ནི༌ རི༌ ཚང༌མ༌, ཡང༌ན༌ ཧེར༌མོན༌ རིའི༌ ཡོག༌ བའལ༌ གཱད༌ ནེ༌ ཏངས༌ཏེ༌ ལེ༌བོ༌ ཧ༌མཐ༌ ཚག༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","རི༌ ཡུལ༌གུན༌ནི༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མ༌, ལེ༌བ༌ནོན༌ ནེ༌ མིས༌རེ༌ཕོཐ༌ མཱའིམ༌ ཚག༌པ༌ ཀ༌བོའེ༌ ནང༌ང༌ སི༌དོན༌པ༌ ཚང༌མ༌ ཨིན༌ནོག༌།” ཏ༌རུང༌ ཡ༌ཝའེ༌ མོལས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མིག༌གི༌ དུན༌ལ༌ ངའེ༌ ཁོང༌གུན༌ ཕིངས༌ཏེ༌ ཏང༌ཨིན༌། ངའེ༌ བཀའ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཏེ༌ ས༌ཀྱད༌པོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ ཏང༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","ལུས༌ཁན༌ནི༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌ རྒུ༌ དང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌པོའ༌ ཏེ༌གུན༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ བགོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","མ༌ནས༌སའེ༌ ཞན༌ མི༌སྡེ༌ ཕེད༌ ཡང༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མི༌སྡེ༌ གུན༌ལ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌སི༌ ས༌ཀྱད༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ ཐོབ༌ ཀ༌བོ༌ སྔུན༌ལ༌ ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ བགོས༌ཏེ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","ཏེ༌ ས༌ཀྱད༌, ཨར༌ནོན༌ནི༌ ལུང༌པའེ༌ ཐའ༌མ༌ ཡོད༌ཁན༌ ཨ༌རོ༌འེར༌ ནེ༌ ཏངས༌ཏེ༌ མེ༌དི༌བའེ༌ ཐང༌ངི༌ སང༌ ཐག༌རིང༌ དི༌བོན༌ གྲོང༌ཁྱེར༌ ཚག༌པ༌ ཁྱེད༌ཏེ༌ ཨིན༌ནོག༌། ཏེ༌ ནང༌ང༌ ཨར༌ནོན༌ ལུང༌པའེ༌ སྐྱིལ༌ལ༌ ཡོད༌ཁན༌ནི༌ གྲོང༌ཁྱེར༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","ཏེ༌ ནང༌ང༌ ཨ༌མོར༌པའེ༌ གྱལ༌པོ༌ སི༌ཧོན༌ནི༌ གྲོང༌ཁྱེར༌ ཚང༌མ༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌, ཁོའེ༌ ཧེཤ༌བོན༌ གྱལ༌ས༌ནེ༌ ཝང༌སྲུལ༌ལད༌པིན༌ ཡང༌ ཁོའེ༌ གྱལ༌སྲིད༌ ཨེམ༌མོན༌པའེ༌ སན༌ཚམས༌ ཚོག༌པ༌ ཁྱེད༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","ཏེ༌བོའེ༌ ནང༌ང༌ གི༌ལེད༌, གེ༌ཤུར༌ དང༌ མའ༌ཀཧ༌ ཡུལ༌ཇོངས༌གུན༌, ཧེར༌མོན༌ནི༌ རི༌ གང༌པོ༌, བ༌ཤན༌ གང༌པོ༌ ས༌ལ༌ཀཧ༌ ཚོག༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","བ༌ཤན༌ནི༌ གྱལ༌པོ༌ ཨོག༌གི༌ ཡུལ༌ ཚང༌མ༌། ཁོའེ༌ ཨཤ༌ཏ༌རོཐ༌ དང༌ ཨེད༌རིའི༌ ནང༌ང༌ ཝང༌སྲུལ༌ལད༌པིན༌ ཡང༌ ཁོ༌ རེ༌ཕ༌པ༌ མིར༌གྱུད༌དི༌ སྟིང༌ཇུག༌གི༌ མི༌བོ༌ ཨིན༌པིན༌། མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ ཕམ༌ཀལ༌ཏེ༌ ཏེ༌ ས༌ཀྱད༌པོ༌ ལེན༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གེ༌ཤུར༌ དང༌ མའ༌ཀཧའེ༌ མི༌གུན༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕྲོའ༌ ཁོང༌གུན༌ དི༌རིང༌ངའང༌ དུག༌ཨིན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","མོ༌ཟེས༌སི༌ ལི༌ཝི༌ མི༌སྡེ༌ ཅིག༌པོའ༌ ས༌ཀྱད༌ བགོས༌ཏེ༌ མ༌ཏངས༌ ཅིའ༌ཟེར༌ན༌ ཆོད༌ཁྲི༌ཀ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའ༌ ཆོད༌པ༌ མེའ༌ སྲགས༌ཏེ༌ ཕུལ༌ཁན༌བོ༌ ཁོང༌གུན༌ནི༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ བགོ༌ཅེས༌ལ༌ ཡ༌ཝའེ༌ མོལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","མོ༌ཟེས༌སི༌ རུ༌བེན༌ནི༌ སྡེའ༌ མི༌རིགས༌ རེ༌རེའ༌ འི༌ ས༌ཀྱད༌གུན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","ཏེ༌ ས༌ཀྱད༌གུན༌ ཨར༌ནོན༌ནི༌ ལུང༌པའེ༌ ཐའ༌མའེ༌ ཨ༌རོ༌འེར༌ནེ༌ ཏངས༌ཏེ༌ མེ༌དི༌བའེ༌ ཐང༌ངི༌ སང༌ ཐག༌རིང༌, ཏེ༌ནང༌ང༌ ལུང༌པའེ༌ སྐྱིལ༌ལི༌ གྲོང༌ཁྱེར༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","ཏེ༌བོའེ༌ ནང༌ང༌ ཧེཤ༌བོན༌ ཡང༌ ཐང༌ངི༌ཀ༌ ཡོད༌ཁན༌ འི༌ གྲོང༌ཁྱེར༌ ཚང༌མ༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌ ཏེ༌གུན༌ དི༌བོན༌, བ༌མོཐ༌ བའལ༌, བེཐ༌ བའལ༌ མེ༌འོན༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ཡ༌ཧཟ༌, ཀེ༌དེ༌མོཐ༌, མེ༌ཕའཐ༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ཀི༌རིའ༌ཐ༌ཡེམ༌, སིབ༌མཧ༌, ལུང༌པའེ༌ རི༌ཀ༌ ཡོད༌ཁན༌ ཟེ༌རེཐ༌ ཤ༌ཧར༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","བེཐ༌ པེ༌འོར༌, པིས༌གཧའེ༌ རི༌ ཁྲེད༌གུན༌ དང༌ བེཐ༌ ཡེ༌ཤི༌མོཐ༌ གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","རུ༌བེན༌པ༌གུན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཐང༌ངི༌ཀ༌ ཡོད༌ཁན༌ནི༌ གྲོང༌ཁྱེར༌ ཚང༌མ༌ དང༌ སི༌ཧོན༌ནི༌ གྱལ༌ཁམས༌ གང༌པོ༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ཨ༌མོར༌པའེ༌ གྱལ༌པོ༌ སི༌ཧོན༌ནི༌ ཧེཤ༌བོན༌ ནེ༌ ཝང༌སྲུལ༌ལད༌པིན༌ ཡང༌ མོ༌ཟེས༌སི༌ ཁོ༌ དང༌ ཁོའེ༌ ང༌ཡོག༌ག༌ ཡོད༌ཁན༌ མི༌དིའན༌པ༌ སྤོན༌བོ༌ ཨེ༌ཝི༌, རེ༌ཀེམ༌, ཟུར༌, ཧུར༌ དང༌ རེ༌བ༌ གུན༌ལ༌ ཕམ༌ཀལ༌ཏེ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","ཨིས༌ར༌ཨེལ༌པའེ༌ སད༌ཁན༌གུན༌ནི༌ ཕྲོའ༌ བེ༌འོར༌རི༌ བུ༌ཚ༌ བ༌ལའམ༌ ཆོས༌ངན༌ ཅོ༌ཁན༌བོའང༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","རུ༌བེན༌ནི༌ མི༌སྡེ༌ ཕིའ༌ ནུབ༌ ཆོགས༌སི༌ སན༌ཚམས༌པོ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཐའ༌མ༌ ཨིན༌པིན༌། ཏེ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཡོད༌ཁན༌ གྲོང༌ཁྱེར༌ དང༌ གྲོང༌སེབ༌ གུན༌ རུ༌བེན༌ནི༌ སྡེའེ༌ མི༌རིགས༌ རེ༌རེའ༌ ནོར༌སྐལ༌ལ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","མོ༌ཟེས༌སི༌ གཱད༌དི༌ སྡེ༌ མི༌རིགས༌ རེ༌རེའ༌ འི༌ ས༌ཀྱད༌གུན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","ཏེ༌ ས༌ཀྱད༌གུན༌ ཡ༌ཟེར༌, གི༌ལེད༌དི༌ གྲོང༌ཁྱེར༌ ཚང༌མ༌ དང༌ ཨེམ༌མོན༌པའེ༌ ས༌ཀྱད༌ ཕེད༌, རབ༌བཧའེ༌ ཤར༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ ཨ༌རོ༌འེར༌ གྲོང༌ཁྱེར༌ ཚོག༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","ཧེཤ༌བོན༌ ནེ༌ ཏངས༌ཏེ༌ ར༌མཐ༌ མིཟ༌པཧ༌ དང༌ བེ༌ཏོ༌ནིམ༌ ཡང༌ མ༌ཧ༌ནཱའིམ༌ ནེ༌ ཏངས༌ཏེ༌ དེ༌བིར༌རི༌ ཡུལ༌ ཚོག༌པ༌ ཁྱེད༌ཏེ༌ ཡོད༌ཁན༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","ཡང༌ ཡོར༌དཱན༌ ལུང༌པའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ བེཐ༌ ཧ༌རམ༌, བེཐ༌ ནིམ༌རཧ༌, སུ༌ཀོད༌ དང༌ ཟ༌ཕོན༌ ཡང༌ ཧེཤ༌བོན༌ནི༌ གྱལ༌པོ༌ སི༌ཧོན༌ནི༌ ཝང༌སྲུལ༌ཁན༌ ས༌ཀྱད༌ ལུས༌ཁན༌གུན༌ ༼ཡང༌ན༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ནེ༌ གཱ༌ལིལ༌ལིའི༌ ཚོ༌ ཚོག༌པ༌༽ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","ཏེ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཡོད༌ཁན༌ གྲོང༌ཁྱེར༌ དང༌ གྲོང༌སེབ༌ གུན༌ གཱད༌དི༌ སྡེའེ༌ མི༌རིགས༌ རེ༌རེའ༌ ནོར༌སྐལ༌ལ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","མོ༌ཟེས༌སི༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌དི༌ མི༌རིགས༌ རེ༌རེའ༌ འི༌ ས༌ཀྱད༌གུན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","ཏེ༌ ས༌ཀྱད༌གུན༌ ནི༌ མ༌ཧ༌ནཱའིམ༌ དང༌ བ༌ཤན༌ ཡུལ༌ཇོངས༌ གང༌པོ༌ ཀ༌བོ༌ གྱལ༌པོ༌ ཨོག༌གི༌ གྱལ༌ཁམས༌ གང༌པོ༌ ཨིན༌པིན༌, ཀ༌བོའེ༌ ནང༌ང༌ ཡཱའིར༌རི༌ ང༌ཡོག༌ག༌ ཁྱོང༌ཁན༌ གྲོང༌ཁྱེར༌ དྲུག༌ཅུ༌, ");
INSERT INTO lbj_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","གི༌ལེད༌ ཡུལ༌ཇོངས༌སི༌ ཕེད༌ ཡང༌ གྱལ༌པོ༌ ཨོག༌གི༌ གྱལ༌ས༌ ཨཤ༌ཏ༌རོཐ༌ དང༌ ཨེད༌རིའི༌ གུན༌ ཨིན༌ནོག༌། ཏེ༌ ནས༌ས༌གུན༌ མ༌ནས༌སའེ༌ བུ༌ཚ༌ མ༌ཀིར༌རི༌ པུར༌གྱུད༌ ཕེད༌པོའེ༌ མི༌རིགས༌ རེ༌རེའ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","ཁོང༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ འ༌ངོ༌ ཆོགས༌ ཡེ༌རི༌ཀོའེ༌ ཤར༌ ཆོགས༌ལ༌ མོ༌འབ༌བི༌ ཐང༌ངི༌ ནང༌ང༌ ཡོད༌ ཟ༌ནེ༌ འི༌ ས༌ཀྱད༌གུན༌ མོ༌ཟེས༌སི༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ བགོས༌ཏེ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ ལི༌ཝི༌ མི༌སྡེའ༌ ས༌ཀྱད༌ བགོས༌ཏེ༌ མ༌ཏངས༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཁོང༌རང༌ ཁོང༌གུན༌ནི༌ ནོར༌སྐལ༌ ཨིན༌ མོལ༌ཏེ༌ ཁ༌ཆད༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","ཨིས༌ར༌ཨེལ༌ལི༌ ལུས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ མི༌སྡེ༌གུན༌ལ༌ ཀེ༌ནན༌ནི༌ འི༌ ས༌ཀྱད༌གུན༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ ཀ༌བོ༌ བླ༌མ༌ ཨེ༌ལི༌འ༌ཟར༌, ནུན༌ནི༌ བུ༌ཚ༌ ཡོ༌ཤུའ༌ དང༌ སྡེ༌ ཚང༌མའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ བགོས༌ཏེ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ སྡེ༌ 9 དང༌ ཕེད༌པོའ༌ ནོར༌སྐལ༌ལི༌ ས༌ཀྱད༌ ཁོང༌གུན༌ནི༌ ཏག༌རིལ༌ གྱུད༌ཏེ༌ བགོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","མོ༌ཟེས༌སི༌ སྡེ༌ ཉིས༌ དང༌ ཕེད༌པོའ༌ ས༌ཀྱད༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ ཏང༌ཏེ༌ ཨིན༌པིན༌ ཨིན༌ནའང༌ ཁོང༌ངི༌ ལི༌ཝི༌ མི༌སྡེའ༌ ས༌ཀྱད༌ མ༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌གུན༌ སྡེ༌ ཉིས༌ ཡོད༌པིན༌, མ༌ནས༌ས༌ དང༌ ཨེཕ༌ར༌ཡིམ༌། ལི༌ཝི༌པ༌གུན༌ལ༌ ས༌ཀྱད༌དི༌ སྐལ༌ལ༌ མ༌ཏངས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ལ༌ དུག༌སའེ༌ གྲོང༌ཁྱེར༌ དང༌ ཁོང༌གུན༌ནི༌ སེམས༌ཅན༌གུན༌ནི༌ རྩ༌ཁའེ༌ ཕིའ༌ ས༌ཀྱད༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ས༌ཀྱད༌གུན༌ བགོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","ཀེ༌ནས༌པ༌ ཡེ༌ཕུན༌ནེཧའེ༌ བུ༌ཚ༌ ཀེ༌ལེབ༌, ཡ༌ཧུ༌དཱ༌ སྡེའེ༌ མི༌ ཁག༌ཅིག༌ ཉམ༌པོ༌ གིལ༌གལ༌ལི༌ ནང༌ང༌ ཡོ༌ཤུའ༌ ཡོད༌ས༌ ཡོངས༌ ཡང༌ ཁོའ༌ ཟེརས༌, “ཡ༌ཝའེ༌ ཀ༌དེཤ༌ བར༌ནེའ༌ ནང༌ང༌ ང༌དང༌ ཉིས༌ཀའེ༌ སྐོར༌ལ༌ དཀོན༌མཆོག༌གི༌ མི༌ མོ༌ཟེས༌ལ༌ མོལ༌ཁན༌བོ༌ ཨིད༌ཏུ༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ ང༌ ཀ༌དེཤ༌ བར༌ནེའ༌ནེ༌ ཀེ༌ནན༌ནི༌ ས༌ཀྱད༌པོ༌ ལྟའ༌ལ༌ ལམ༌ཅུག༌ ཟ༌ནེ༌ ང༌ ལོ༌ ཞིབ༌ཅུ༌ ཆའད༌པིན༌། ལོགས༌ཏེ༌ ཡོངས༌ཏེ༌ ངའེ༌ ཏེ༌ ནས༌སའེ༌ སྐོར༌ལ༌ ཀྲང༌པོ༌ ནས༌ཚུལ༌ ཤད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","ཨིན༌ནའང༌ ངའེ༌ སྤུན༌ ང༌ ཉམ༌པོ༌ ཆའ༌ཁན༌གུན༌ནི༌, ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ནང༌ང༌ ཇིགས༌ནང༌ སྐྱེ༌ཅུགས༌། ཏེ༌ནེའང༌ ཡ༌ཝ༌ ངའེ༌ དཀོན༌མཆོག༌གི༌ འི༌ ནས༌ས༌ ང༌དང༌ང༌ སལ༌ལ༌ ཛད༌ཅེས༌པོའ༌ ངའེ༌ སྙིང༌ ཐག༌པ༌ནེ༌ ཨིད༌ཤེས༌ ཅོས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","ཏེན༌ན༌ ཞག༌ག༌ མོ༌ཟེས༌སི༌ ངའ༌ ཁ༌ཆད༌ ཛད༌ཏེ༌ མོལས༌, ‘ཏེ༌ ནས༌ས༌ ལྟའ༌ ཆ༌ ཟ༌ནེ༌ ཁྱོ༌རང༌ངི༌ རྐང༌པ༌ བོར༌ཁན༌ ས༌ཀྱད༌ ཏུས༌གྱུན༌ནི༌ཕིའ༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ པུར༌གྱུད༌གུན༌ལ༌ ཐོབ༌ཅེས༌ཅན༌ནི༌ ནོར༌སྐལ༌བོ༌ ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ངི༌ ཡ༌ཝ༌ ངའེ༌ དཀོན༌མཆོག༌གི༌ཀ༌ སྙིང༌ ཐག༌པ༌ནེ༌ ཨིད༌ཤེས༌ ཅོས༌།’” ");
INSERT INTO lbj_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","“ཏ༌ ཉེ༌རང༌ངི༌ ཟིགས༌སའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཁོར༌ཨིན༌ ཡོད༌ཏུས༌ མོ༌ཟེས༌སི༌ ཁ༌ཆད༌ ཛད༌པ༌ནེ༌ དག༌ས༌ ཚག༌པ༌ ལོ༌ 45 ཡ༌ཝའེ༌ ང༌ སོན༌ཏེའ༌ བོར༌ར༌ ཛདས༌། དི༌རིང༌ ང༌ ལོ༌ 85 སོང༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","མོ༌ཟེས༌སི༌ ལམ༌ཅུག༌ ཟ༌ནེ༌ ཤེད༌ཅན༌ ཡོད༌ཁན༌ ཙོགས༌ ངའ༌ དག༌སའང༌ ཨིན༌, ཏེ༌ ཟ༌ནེ༌ ཙོགས༌ ཏ༌རུང༌ངའང༌ མག༌ ཏང༌ང༌ ཆ༌ཅེས༌སི༌ ཤེད༌ ངའེ༌ ནང༌ང༌ ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","ཏེ༌ ཞག༌ག༌ ཡ༌ཝའེ༌ ཁ༌ཆད༌ ཛད༌ཁན༌ནི༌ འི༌ རི༌ཡུལ༌བོ༌ ཏ༌ ངའ༌ སལ༌། ཏེ༌རུ༌ ཨ༌ནཀ༌པ༌གུན༌ གྱང༌སྐོར༌ ཐོན༌པོ༌ཅན༌ནི༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌བོ༌ ཉེ༌རང༌ང༌ ཚོར༌ཏེ༌ ཨིན༌ནོག༌། ཨིན༌ནའང༌ ཡ༌ཝའེ༌ རོགས༌ ཉམ༌པོ༌ ངའེ༌ ཁོང༌གུན༌ ཏེ༌ ས༌ཀྱད༌ནེ༌ ཕིང༌ཨིན༌ ཀ༌ཟུག༌ ཡ༌ཝའེ༌ མོལ༌ལ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","ཡོ༌ཤུའེ༌ ཀེ༌ལེབ༌བ༌ ཅིན༌ལབས༌ སལ༌ཅེས༌ལ༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌ ཡང༌ ཧེབ༌རོན༌ནི༌ གྱལ༌ས༌ ཁོའ༌ ནོར༌སྐལ༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","ཏེ༌ནེ༌ ཕར༌ལ༌ ཧེབ༌རོན༌ ཀེ༌ལེབ༌བི༌ པུར༌གྱུད༌གུན༌ནི༌ ས༌ཀྱད༌ གྱུར༌ ཡང༌ དག༌སའང༌ ཨིན༌ནོག༌, ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ སྙིང༌ ཐག༌པ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ཀ༌ ཨིད༌ཤེས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","ཀེ༌ལེབ༌བི༌ ཧེབ༌རོན༌ ལེན༌ནི༌སང༌ སྔུན༌ལ༌ ཏེ༌བོའ༌ ཨ༌ནཀ༌པའེ༌ སྤའ༌འོ༌ ཀྲག༌པོ༌ ཞིག༌གི༌ མིང༌ངི༌ གྱབ༌ནེ༌ ཀི༌རི༌འཐ༌ ཨར༌བའ༌ ཟེར༌རད༌པིན༌། ཏེ༌ནེ༌ ཕར༌ལ༌ ཏེ༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ མག༌ མ༌ཆ༌ ཞི༌དེ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","ཡ༌ཧུ༌དཱ༌ སྡེའེ༌ མིར༌གྱུད༌གུན༌ལ༌ ས༌ཀྱད༌ ཏངས༌ཁན༌བོ༌ ལྷོ༌ ཆོགས༌ལ༌ ཨི༌དོམ༌མི༌ སན༌ཚམས༌, ཟིན༌ནི༌ ཐང༌སྟོང༌ ཚོག༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","ཁོང༌གུན༌ནི༌ ལྷོ༌ ཆོགས༌སི༌ སན༌ཚམས༌པོ༌ ཚོ༌རུལ༌ལི༌ ལྷོ༌ ཆོགས༌སི༌ ཇུག༌ནེ༌ གོ༌ཟུགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","སྡིག༌པ༌རཱ༌ཙེ༌ ལའེ༌ ལྷོ༌ ཆོགས༌ གྱུད༌ཏེ༌ ཟིན༌ནི༌ ཐང༌སྟོང༌ནེ༌ ཀ༌དེཤ༌ བར༌ནེའེ༌ ལྷོ༌ ཆོགས༌ ཡང༌ ཧེཟ༌རོན༌ གྱུད༌ཏེ༌ ཀེན༌ལ༌ ཨད༌དར༌ ཚོག༌པ༌ ལེབ༌ཏེ༌ ཀར༌ཀ༌ ཆོགས༌ལ༌ ཀྱོགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","ཏེ༌ཀ༌ནེ༌ ཨཟ༌མོན༌ གྱུད༌ཏེ༌ ཨི༌ཇིབ༌བི༌ སན༌ཚམས༌སི༌ ཀྲོག༌པོའ༌ ཐུད༌ཏེ༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌ ཚོག༌པ༌ ལེབ༌, ཏེ༌བོ༌ ཁོང༌གུན༌ནི༌ ལྷོ༌ ཆོགས༌སི༌ སན༌ཚམས༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","ཤར༌ ཆོགས༌སི༌ སན༌ཚམས༌པོ༌ རུལ༌ཁན༌ནི༌ ཚོ༌, ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཁའ༌ ཚོག༌པ༌ ཨིན༌པིན༌། བྱང༌ ཆོགས༌སི༌ སན༌ཚམས༌པོ༌ རུལ༌ཁན༌ནི༌ ཚོ༌, ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཁའེ༌ ཀ༌ནེ༌ གོ༌ཟུགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","ཀེན༌ལ༌ བེཐ༌ ཧོག༌ལཧ༌ གྲོང༌ཁྱེར༌ ཚོག༌པ༌ ཡང༌ བེཐ༌ ཨ༌ར༌བཧ༌ གྲོང༌ཁྱེར༌རི༌ བྱང༌ ཆོགས༌ནེ༌ རུ༌བེན༌ནི༌ བུ༌ཚ༌ བོ༌ཧན༌ནི༌ རྡོའ༌ ཚག༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","ཏེ༌ནེ༌ ཨ༌ཁོར༌རི༌ ལུང༌པ༌ནེ༌ དེ༌བིར༌ ཚོག༌པ༌, བྱང༌ ཆོགས༌སི༌ གིལ༌གལ༌ གྱལ༌ས༌ ཆོགས༌ལ༌ ཀྱོགས༌ཏེ༌ ཀ༌བོ༌ ལུང༌པའེ༌ ལྷོ༌ ཆོགས༌ལ༌ ཨ༌གྲུམ༌མིམ༌ ཁྲེད༌དི༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཡོད༌། ཏེ༌ཀ༌ནེ༌ སན༌ཚམས༌པོ༌ ཨེན༌ ཤེ༌མེཤ༌ ཆུ༌མིག༌ གྱུད༌ཏེ༌ ཨེན༌ རོ༌གེལ༌ ཚོག༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","ཏེ༌ནེ༌ ཏེ༌བོ༌ བེན༌ ཧིན༌ནོམ༌མི༌ ལུང༌པ༌ གྱུད༌ཏེ༌, ཡེ༌བས༌ ཡང༌ན༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌སའེ༌ ལྷོ༌ ཆོགས༌སི༌ ཁྲེད༌ གྱུད༌ཏེ༌ ཀེན༌ལ༌ ཧིན༌ནོམ༌མི༌ ལུང༌པའེ༌ ནུབ༌ ཆོགས༌སི༌ རིའི༌ གོ༌, རེ༌ཕ༌འིམ༌མི༌ ལུང༌པའེ༌ བྱང༌ ཆོགས༌སི༌ ཇུག༌ ཚོག༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","སན༌ཚམས༌པོ༌ ཏེ༌ རི༌གོ༌ནེ༌ ནེཕ༌ཏོ༌འཧའེ༌ ཆུ༌མིག༌ ཚོག༌པ༌ ཡང༌ ཏེ༌ཀ༌ནེ༌ ཨེ༌ཕོ༌རོན༌ རི༌ གྲོང༌ཁྱེར༌གུན༌ ཚོག༌པ༌། ཏེ༌ནེ༌ བའ༌ལཧ༌ ཆོགས༌ལ༌ ཀྱོགས༌ ཀ༌བོ༌ ཀི༌རི༌འཐ༌ ཡེ༌རིམ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","བའ༌ལཧ༌ ནེ༌ ནུབ༌ ཆོགས༌ལ༌ ཀྱོགས༌ཏེ༌ སེ༌འིར༌ རི༌ གྱུད༌ཏེ༌ ཡེ༌རིམ༌ རི༌ བྱང༌ ཆོགས༌སི༌ ཁྲེད༌ ཚོག༌པ༌ ༼ཀ༌བོའ༌ དག༌ས༌ རི༌ ཀེ༌ས༌ལོན༌ ཟེར༌ར༌ནོག༌༽ ཡང༌ ཐུར༌ལ༌ བེཐ༌ ཤེ༌མེཤ༌ གྱལ༌ས༌ ནེ༌ ཏིམ༌ནཧ༌ གྱལ༌ས༌ ཚོག༌པ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","སན༌ཚམས༌པོ༌ ཨེཀ༌རོན༌ གྱལ༌སའེ༌ བྱང༌ ཆོགས༌སི༌ རི༌ ཁྲེད༌ ནེ༌ ཤིཀ༌ཀི༌རོན༌ གྲོང༌ཁྱེར༌ ཆོགས༌ལ༌ ཀྱོགས༌ ཡང༌ རི༌ བའ༌ལཧ༌ གྱུད༌ཏེ༌ ཡབ༌ནེལ༌ གྲོང༌ཁྱེར༌ ཚག༌པ༌ ལེབ༌ཏེ༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོའེ༌ཀ༌ ཚར༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","ནུབ༌ ཆོགས༌སི༌ སན༌ཚམས༌པོ༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོའེ༌ ཐའ༌མ༌གུན༌ ཨིན༌ནོག༌། ཡ༌ཧུ༌དཱ༌ སྡེའེ༌ མི༌རིགས༌གུན༌ནི༌ སན༌ཚམས༌ ཏེ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","ཡ༌ཝའེ༌ བཀའ༌ ནང༌ཞིན༌ ཡོ༌ཤུའེ༌ ཀེ༌ལེབ༌བ༌ ཡ༌ཧུ༌དཱ༌ མི༌སྡེའེ༌ ས༌ཀྱད༌དི༌ ཁག༌ཤིག༌ ཏངས༌། ཏེ༌བོ༌ ཀི༌རི༌འཐ༌ ཨར༌བའ༌ ཡང༌ན༌ ཧེབ༌རོན༌ གྱལ༌ས༌ ཨིན༌ནོག༌། ༼ཨར༌བའ༌ ཨ༌ནཀ༌པའེ༌ ཕ༌མེས༌པོ༌ ཞིག༌ ཨིན༌ནོག༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","ཀེ༌ལེབ༌བི༌ ཧེབ༌རོན༌ནི༌ ནང༌ནེ༌ ཨ༌ནཀ༌པ༌ སྡེ༌ སུམ༌ ཕིངས༌, ཁོང༌གུན༌ ཨ༌ནཀ༌པའེ༌ པུར༌གྱུད༌ ཤེ༌ཤཱའི༌, ཨ༌ཧི༌མན༌ དང༌ ཏལ༌མཱའི༌ གུན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","ཏེ༌ཀ༌ནེ༌ ཁོ༌ དེ༌བིར༌རི༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌ ༼ཏེ༌བོའ༌ སྔུན༌ལ༌ ཀི༌རི༌འཐ༌ སེ༌ཕེར༌ ཟེར༌རད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","ཀེ༌ལེབ༌བི༌ ཟེརས༌, “ཀི༌རི༌འཐ༌ སེ༌ཕེར༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ང༌ཡོག༌ག༌ ཁྱོང༌ཁན༌ནི༌ མི༌བོའ༌ ངའེ༌ ང༌རང༌ངི༌ བུ༌མོ༌ ཨཀ༌སཧ༌ ན༌མ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","ཀེ༌ལེབ༌བི༌ ནོ༌ ཀེ༌ནཟ༌ཟི༌ བུ༌ཚ༌ ཨོཐ༌ནི༌འེལ༌ལི༌ ཏེ༌བོ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌པ༌ ཀེ༌ལེབ༌བི༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌ ཨཀ༌སཧ༌ ཁོའ༌ ན༌མ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","ན༌མ༌ ཅོས༌ཏེ༌ སྟིང༌ནེ༌ ཨོཐ༌ནི༌འེལ༌ལི༌ ཨཀ༌སཧ༌ ཨ༌བ༌ ཀེ༌ལེབ༌བ༌ ཞིང༌ ཏོང༌ ཟེར༌ ཅུགས༌། ཏེ༌ནེ༌ ཨཀ༌སཧ༌ ཁོ༌རང༌ངི༌ ཨ༌བའ༌ སྤེ༌ར༌ ཏང༌ང༌ སོང༌ ཡང༌ ཁོ༌ བུང༌བུའི༌ ཀ༌ནེ༌ བབ༌བ༌ཅིག༌ ཀེ༌ལེབ༌བི༌ ཏྲིས༌, “ངའེ༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ ཅི༌ ཅོ༌?” ");
INSERT INTO lbj_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","ཁོའེ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ནེ༌གེཝ༌ཝི༌ ས༌ཀྱད༌ ངའ༌ ཏངས༌ཏེ༌ ཨིན༌ནོག༌ ཏ༌ ཇུ༌ཇུ༌ ངའ༌ ཆུ༌མིག༌གི༌ ཆུའང༌ སལ༌ ལེ༌།” ཏེ༌ནེ༌ ཀེ༌ལེབ༌བི༌ ཁོའ༌ ཧེབ༌རོན༌ནི༌ ཉེ༌མོའ༌ ཡོད༌ཁན༌ སྟག༌ཡོག༌ ཉིས༌ཀའེ༌ ཆུ༌མིག༌གུན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","འི༌གུན༌ ཡ༌ཧུ༌དཱ༌ སྡེའེ༌ མི༌རིགས༌ རེ༌རེའ༌ ནོར༌སྐལ༌ལ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌ ཨིན༌ནོག༌: ");
INSERT INTO lbj_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","ཨི༌དོམ༌མི༌ སན༌ཚམས༌སི༌ ཉེ༌མོའ༌ ཚང༌མའེ༌སང༌ ལྷོ༌ ཆོགས༌སི༌ ཡ༌ཧུ༌དཱའེ༌ གྲོང༌ཁྱེར༌གུན༌ ནི༌ ཀབ༌ཟེའེལ༌, ཨེ༌དེར༌ དང༌ ཡ༌གུར༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ཀི༌ནཧ༌, དི༌མོ༌ནཧ༌, ཨ༌ད༌དཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ཀེ༌དེཤ༌, ཧ༌ཟོར༌, ཨིཐ༌ནན༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ཟིཕ༌, ཏེ༌ལེམ༌, བེའ༌ལོཐ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ཧ༌ཟོར༌ ཧ༌དཏ༌ཏཧ༌, ཀེ༌རི༌འོཐ༌ ཧེཟ༌རོན༌ ༼ཡང༌ན༌ ཧ༌ཟོར༌༽, ");
INSERT INTO lbj_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","ཨ༌མམ༌, ཤེ༌མ༌, མོ༌ལ༌དཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ཧ༌ཟར༌ གད༌དཧ༌, ཧེཤ༌མོན༌, བེཐ༌ པེ༌ལེཏ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ཧ༌ཟར༌ ཤུ༌འལ༌, བེར༌ཤེ༌བ༌, བི༌ཟིའོ༌ཐི༌འཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","བའ༌ལཧ༌, ཨིམ༌, ཨེ༌ཟེམ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ཨེལ༌ཀྲོ༌ལད༌, ཀེ༌སིལ༌, ཧོར༌མཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ཟིག༌ལག༌, མད༌མན༌ནཧ༌, སན༌སན༌ནཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ལེ༌བཱ༌འོཐ༌, ཤིལ༌ཧིམ༌, ཨའིན༌ དང༌ རིམ༌མོན༌ གྲོང༌ཁྱེར༌ གུན༌ ཨིན༌པིན༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 29 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","ནུབ༌ ཆོགས༌སི༌ རི༌ཡོག༌ག༌ ཡོད༌ཁན༌ནི༌ ཡ༌ཧུ༌དཱ༌ མི༌སྡེའེ༌ གྲོང༌ཁྱེར༌གུན༌ ནི༌ ཨེཤ༌ཏ༌འོལ༌, ཟོ༌རཧ༌, ཨཤ༌ནཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ཟ༌ནོ༌འཧ༌, ཨེན༌ གན༌ནིམ༌, ཏཔ༌པུ༌འཧ༌, ཨེ༌ནམ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ཡར༌མུཐ༌, ཨ༌དུལ༌ལམ༌, སོ༌ཀོཧ༌, ཨ༌ཟེ༌ཀ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ཤའ༌ར༌འིམ༌, ཨ༌དི༌ཐ༌འིམ༌, གེ༌དེ༌རཧ༌ ཡ༌ གེ༌དེ༌རོ༌ཐཱ༌འིམ༌ གུན༌ ཨིན༌པིན༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 14 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","ཟེ༌ནན༌, ཧ༌ད༌ཤཧ༌, མིག༌དལ༌ གཱད༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","དི༌ལེའན༌, མིཟ༌པཧ༌, ཡོཀ༌ཐེལ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ལ༌ཀིཤ༌, བོཟ༌ཀཐ༌, ཨེག༌ལོན༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ཀབ༌བོན༌, ལཧ༌མས༌, ཀིཏ༌ལིཤ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","གེ༌དེ༌རོཐ༌, བེཐ༌ གྲ༌གོན༌, ནའམ༌མཧ༌ དང༌ མཀ༌ཀེ༌དཧ༌ གུན༌ནའང༌ ཨིན༌ནོག༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 16 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","ཏེ༌གུན༌ མ༌ཚད༌ ལིབ༌ནཧ༌, ཨེ༌ཐེར༌, ཨ༌ཤན༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ཨིཕ༌ཏཧ༌, ཨཤ༌ནཧ༌, ནེ༌ཟིབ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ཀེའི༌ལཧ༌, ཨཀ༌ཟིབ༌ དང༌ མ༌རེ༌ཤཧ༌ གྲོང༌ཁྱེར༌ གུན༌ ཨིན༌ནོག༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 9 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","ཡ༌ཧུ༌དཱ༌ མི༌སྡེའེ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཨེཀ༌རོན༌ དང༌ ཏེ༌བོའ༌ ཐའ༌མའ༌ ཡོད༌ཁན༌ གྲོང༌ཁྱེར༌ དང༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","སན༌ཚམས༌པོ༌ ཨེཀ༌རོན༌ ནེ༌ ནུབ༌ ཆོགས༌ལ༌ ཁྱེད༌ཏེ༌ ཨཤ༌དོད༌དི༌ གྲོང༌ཁྱེར༌ དང༌ ཏེ༌བོའེ༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","ཨཤ༌དོད༌ དང༌ ཏེ༌བོའེ༌ ཉེ༌ཁོར༌ལ༌ ཚུགས༌ཏེ༌ ཡོད༌ཁན༌ དང༌ གྲོང༌སེབ༌གུན༌, ག༌ཟ༌ དང༌ ཏེ༌བོའེ༌ ཉེ༌ཁོར༌ལ༌ ཚུགས༌ཏེ༌ ཡོད༌ཁན༌གུན༌ དང༌ གྲོང༌སེབ༌གུན༌ ཀ༌བོ༌ ཐག༌རིང༌ ཨི༌ཇིབ༌བི༌ སན༌ཚམས༌སི༌ ཀྲོག༌པོ༌ དང༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོའེ༌ ཐའ༌མ༌ ཚག༌པ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","ཡང༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཤ༌མིར༌, ཡཏ༌ཏིར༌, སོ༌ཀོཧ༌ ");
INSERT INTO lbj_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","དན༌ནཧ༌, ཀི༌རི༌འཐ༌ སན༌ནཧ༌ ༼ཡང༌ན༌ དེ༌བིར༌༽, ");
INSERT INTO lbj_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","ཨ༌ནབ༌, ཨེཤ༌ཏེ༌མོཧ༌, ཨ༌ནིམ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","གོ༌ཤེན༌, ཧོ༌ལོན༌ དང༌ གི༌ལོཧ༌ གྱལ༌ས༌གུན༌ ཨིན༌ནོག༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 11 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","ཨ༌རབ༌, དུ༌མཧ༌, ཨེ༌ཤན༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ཡ༌ནིམ༌, བེཐ༌ ཏཔ༌པུ༌འཧ༌, ཨ༌ཕེ༌ཀཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ཧུམ༌ཏཧ༌, ཀི༌རི༌འཐ༌ ཨར༌བ༌ ༼ཡང༌ན༌ ཧེབ༌རོན༌༽ དང༌ ཟི༌འོར༌ གྲོང༌ཁྱེར༌གུན༌ ཨིན༌ནོག༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 9 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","འི༌གུན༌ མ༌ཚད༌ མ༌འོན༌, ཀར༌མེལ༌, ཟིཕ༌, ཡུཏ༌ཏཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","ཡེཟ༌རེ༌འེལ༌, ཡོཀ༌དེ༌འམ༌, ཟ༌ནོ༌འཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ཀ༌འིན༌, གི༌བེའཧ༌ དང༌ ཏིམ༌ནཧ༌ གྲོང༌ཁྱེར༌གུན༌ ཨིན༌ནོག༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 10 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","ཧལ༌ཧུལ༌, བེཐ༌ ཟུར༌, གེ༌དོར༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","མའ༌རཐ༌, བེཐ༌ ཨ༌ནོཐ༌ དང༌ ཨེལ༌ཀྲེ༌ཀོན༌ གྲོང༌ཁྱེར༌གུན༌ ཨིན༌ནོག༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 6 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","ཀི༌རི༌འཐ༌ བའལ༌ ༼ཡང༌ན༌ ཀི༌རི༌འཐ༌ ཡེ༌རིམ༌༽ དང༌ རབ༌བཧ༌ གྲོང༌ཁྱེར༌ ཉིས༌ཀོ༌ ཡང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","ཐང༌སྟོང༌ངི༌ ནང༌ང༌ བེཐ༌ ཨ༌ར༌བཧ༌, མིད༌དིན༌, སེ༌ཀ༌ཀཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ནིབ༌ཤན༌, ཚའེ༌ གྱལ༌ས༌ དང༌ ཨེན༌ གི༌གྲི༌ གྲོང༌ཁྱེར༌གུན༌ ཨིན༌ནོག༌། ལྡོམས༌ གྲོང༌ཁྱེར༌ 6 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","ཨིན༌ནའང༌ ཡ༌ཧུ༌དཱ༌ མི༌སྡེའ༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ནི༌ ཡེ༌བས༌པ༌གུན༌ ཕིང༌ མ༌ཉན༌། ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ དག༌སའང༌ ཡ༌ཧུ༌དཱའེ༌ མི༌གུན༌ནི༌ ཕྲོའ༌ དུག༌ཨིན༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌གུན༌ལ༌ ཏངས༌ཁན༌ནི༌ ས༌ཀྱད༌ ཡེ༌རི༌ཀོའེ༌ ཆུ༌མིག༌ ཤར༌ ཆོགས༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ ནེ༌ གོ༌ཟུགས༌ཏེ༌ ཐང༌སྟོང༌ གྱུད༌ཏེ༌ ཀེན༌ལ༌ བེ༌ཐེལ༌ལི༌ རི༌ཡུལ༌ ཡང༌ ");
INSERT INTO lbj_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","བེ༌ཐེལ༌ ༼ཡང༌ན༌ ལུས༌༽ ནེ༌ ཨ༌ཏ༌རོཐ༌དི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཨར༌ཀ༌པའེ༌ ཡུལ༌ ཚོག༌པ༌། ");
INSERT INTO lbj_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","ཏེ༌ཀ༌ནེ༌ ནུབ༌ ཆོགས༌ ཐུར༌ལ༌ ཡཕ༌ལེཀྲ༌པའེ༌ ཡུལ༌ཇོངས༌, ཏེ༌ནེ༌ ཡོག༌གི༌ བེཐ༌ ཧོ༌རོན༌ ཏང༌ གེ༌ཟེར༌ ཚོག༌པ༌ ཡང༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོའེ༌ཀ༌ ཚར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","ཏེ༌བོ༌ ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌ མ༌ནས༌ས༌ དང༌ ཨེཕ༌ར༌ཡིམ༌ མི༌སྡེ༌གུན༌ནི༌ ནོར༌སྐལ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","འི༌གུན༌ ཨེཕ༌ར༌ཡིམ༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌ ཨིན༌ནོག༌, ཁོང༌གུན༌ནི༌ སན༌ཚམས༌ ཤར༌ ཆོགས༌སི༌ ཨ༌ཏ༌རོཐ༌ ཨད༌དར༌ ནེ༌ གོ༌ཟུགས༌ཏེ༌ ཀེན༌ལ༌ བེཐ༌ ཧོ༌རོན༌ ཆོགས༌ལ༌ ");
INSERT INTO lbj_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌ ཚག༌པ༌, བྱང༌ ཆོགས༌སི༌ མིག༌མེ༌ཐཐ༌ནེ༌ ཤར༌ ཆོགས༌ལ༌ ཏའ༌ནཐ༌ ཤི༌ལོཧ༌ ཆོགས༌ལ༌ ཀྱོགས༌ཏེ༌ ཤར༌ ཆོགས༌སི༌ ཡ༌ནོ༌འཧ༌ ཚག༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","ཡ༌ནོ༌འཧ༌ནེ༌ ཐུར༌ལ༌ ཨ༌ཏ༌རོཐ༌ དང༌ ནའ༌རཧ༌ ཆོགས༌ལ༌ ཡེ༌རི༌ཀོའ༌ ཐུགས༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ ཚག༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","སན༌ཚམས༌པོ༌ ཏཔ༌པུ༌འཧ༌ནེ༌ ནུབ༌ ཆོགས༌སི༌ ཀ༌ནཧ༌ ལུང༌པ༌ ཆོགས༌ལ༌ ཀྱོགས༌ཏེ༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌ ཚག༌པ༌ ཨིན༌ནོག༌། ཏེ༌བོ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཏངས༌ཁན༌ནི༌ ནོར༌སྐལ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","ཏེ༌བོའེ༌ཀ༌ ནན༌མ༌ མ༌ནས༌ས༌ མི༌སྡེ༌ ནོར༌སྐལ༌ལི༌ ཕྲོའ༌ ཨེཕ༌ར༌ཡིམ༌ མི༌སྡེ༌ ཕིའ༌ ཐེན༌ཏེ༌ བོར༌ཁན༌ གྲོང༌ཁྱེར༌ དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","ཁོང༌གུན༌ནི༌ གེ༌ཟེར༌རི༌ ནང༌ང༌ དུག༌ཁན༌ ཀེ༌ནན༌པ༌གུན༌ མ༌ ཕིངས༌། ཏེ༌བོའེ༌ཕིའ༌ ཀེ༌ནན༌པ༌གུན༌ དག༌སའང༌ ཨེཕ༌ར༌ཡིམ༌པ༌གུན༌ནི༌ ཕྲོའ༌ ཚེ༌ཡོག༌གི༌ ཚུལ༌ལ༌ དུག༌ཨིན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","ཡོ༌སེབ༌བི༌ བུ༌ཚ༌ གོ༌བུ༌ མ༌ནས༌སའེ༌ པུར༌གྱུད༌ ཕེད༌པོའ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌ འི༌གུན༌ ཨིན༌ནོག༌། མ༌ནས༌སའེ༌ གོ༌བུ༌ བུ༌ཚ༌ མ༌ཀིར༌ གི༌ལེད༌པ༌གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌། ཁོའེ༌ པུར༌གྱུད༌གུན༌ མག༌མི༌ ཐོང༌ངོམས༌ཅན༌ ཀྲག༌པོ༌ ཡོད༌ པ༌སང༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌སི༌ ནས༌ས༌ གི༌ལེད༌ དང༌ བ༌ཤན༌ ཁོང༌གུན༌ལ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","མ༌ནས༌སའེ༌ སྡེའེ༌ ནང༌ནེ༌ ལུས༌ཁན༌ ཨ༌བིའེ༌ཟེར༌, ཧེ༌ལེག༌, ཨས༌རི༌འེལ༌, ཤེ༌ཀེམ༌, ཧེ༌ཕེར༌ དང༌ ཤེ༌མི༌ད༌ མི༌རིགས༌གུན༌ལ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ནུབ༌ ཆོགས༌སི༌ ས༌ཀྱད༌པོ༌ ཏངས༌། ཁོང༌གུན༌ ཡོ༌སེབ༌བི༌ བུ༌ཚ༌ མ༌ནས༌སའེ༌ ཞན༌ བུ༌ཚ༌གུན༌ནི༌ པུར༌གྱུད༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","མ༌ནས༌སའེ༌ བུ༌ཚ༌ མ༌ཀིར༌, མ༌ཀིར༌རི༌ བུ༌ཚ༌ གི༌ལེད༌, གི༌ལེད༌དི༌ བུ༌ཚ༌ ཧེ༌ཕེར༌, ཧེ༌ཕེར༌རི༌ བུ༌ཚ༌ ཟེ༌ལོ༌ཕེ༌ཧད༌ལ༌ ཕྲུ༌གུ༌ བུ༌མོ༌ མན༌ནེ༌ བུ༌ཚ༌ མེད༌པིན༌། ཁོང༌གུན༌ མཧ༌ལཧ༌, ནོ༌འཧ༌, ཧོག༌ལཧ༌, མིལ༌ཀ༌ དང༌ ཏིར༌ཟཧ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","འི༌ བུ༌མོ༌ ཚང༌མ༌ བླ༌མ༌ ཨེ༌ལི༌འ༌ཟར༌, ནུན༌ནི༌ བུ༌ཚ༌ ཡོ༌ཤུའ༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌གུན༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ ང༌ཞའ༌ ང༌ཞ༌རང༌ངི༌ མི༌སྡེའེ༌ ཕྲོའ༌ ས༌ཀྱད༌ ཏང༌ཅེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌།” ཏེ༌བོའེ༌ཕིའ༌ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ལ༌ ས༌ཀྱད༌ ཁོང༌རང༌གུན༌ནི༌ ཉེན༌གྲུང༌གུན༌ ཉམ༌པོ༌ ཏངས༌ ཀ༌ཟུག༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","མ༌ནས༌སའེ༌ མི༌སྡེའ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌ ལྡོམས༌ ཁག༌ རྕུ༌ ཡོད༌པིན༌ ཀ༌བོའེ༌ ནང༌ང༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌སི༌ ས༌ཀྱད༌ གི༌ལེད༌ དང༌ བ༌ཤན༌ མ༌ཐེའ༌ ཨིན༌ནོག༌ ");
INSERT INTO lbj_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","ཅིའ༌ཟེར༌ན༌ མ༌ནས༌སའེ༌ པུར༌གྱུད༌ བུ༌མོ༌གུན༌ལའང༌ བུ༌ཚ༌གུན༌ ཙོགས༌ ནོར༌སྐལ༌ ཐོབ༌། གི༌ལེད༌དི༌ ས༌ཀྱད༌གུན༌ མ༌ནས༌སའེ༌ ལུས༌ཁན༌ནི༌ པུར༌གྱུད༌གུན༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","མ༌ནས༌སའེ༌ སྡེ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌ ཤེ༌ཀེམ༌མི༌ གྱལ༌སའེ༌ ཉེ༌མོའ༌ ཨ༌ཤེར༌ དང༌ མིག༌མེ༌ཐཐ༌ གྲོང༌ཁྱེར༌རི༌ པར༌ལ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌ ཡང༌ སན༌ཚམས༌པོ༌ ལྷོ༌ ཆོགས༌ལ༌ ཏཔ༌པུ༌འཧའེ༌ ཆུ༌མིག༌ ཚག༌པ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","༼ཏཔ༌པུ༌འཧའེ༌ ཉེ༌ཁོར༌རི༌ ས༌ཀྱད༌ མ༌ནས༌ས༌པ༌གུན༌ནི༌ ཨིན༌པིན༌ ཨིན༌ནའང༌ མ༌ནས༌ས༌པའེ༌ སན༌ཚམས༌སི༌ཀ༌ ཡོད༌ཁན༌ ཏཔ༌པུ༌འཧའེ༌ གྲོང༌ཁྱེར༌ ཨེཕ༌ར༌ཡིམ༌པ༌གུན༌ནི༌ ཨིན༌ནོག༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","ཏཔ༌པུ༌འཧའེ༌ ཆུ༌མིག༌ ནེ༌ མ༌ནས༌སའེ༌ སན༌ཚམས༌ ཀ༌ནཧ༌ ལུང༌པ༌ གྱུད༌ཏེ༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌ ཚོག༌པ༌ ཨིན༌ནོག༌། ཨེཕ༌ར༌ཡིམ༌པའེ༌ ཨིན༌ཁན༌ ལུང༌པའེ༌ བྱང༌ ཆོགས༌སི༌ གྲོང༌ཁྱེར༌ མང༌པོ༌ ཞིག༌ མ༌ནས༌ས༌པའེ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","ལུང༌པའེ༌ ལྷོ༌ ཆོགས༌སི༌ ས༌ཀྱད༌ ཨེཕ༌ར༌ཡིམ༌པ༌གུན༌ནི༌ ཡང༌ ལུང༌པའེ༌ བྱང༌ ཆོགས༌སི༌ ས༌ཀྱད༌ མ༌ནས༌ས༌པ༌གུན༌ནི༌ ཨིན༌པིན༌། མ༌ནས༌ས༌པའེ༌ སན༌ཚམས༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌, བྱང༌ ཆོགས༌ལ༌ ཨ༌ཤེར༌རི༌ སན༌ཚམས༌ དང༌ ཤར༌ ཆོགས༌ལ༌ ཨིས༌ས༌ཁར༌རི༌ སན༌ཚམས༌ ཚོག༌པ༌ ལེབ༌བད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","ཨིས༌ས༌ཁར༌ དང༌ ཨ༌ཤེར༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཡོད༌ཁན༌ བེཐ༌ ཤན༌, ཨིབ༌ལེ༌འམ༌, དོར༌ ༼གྱ༌ཚོའེ༌ ཐའ༌མ༌ ཡོད༌ཁན༌༽, ཨེན༌གྲོར༌, ཏའ༌ནག༌ དང༌ མེ༌གིད༌དོ༌ གྱལ༌ས༌གུན༌ དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌ལ༌ ཚུགས༌ཏེ༌ དུག༌ཁན༌གུན༌ མ༌ནས༌ས༌པ༌གུན༌ནི༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","ཨིན༌ནའང༌ མ༌ནས༌ས༌པ༌གུན༌ལ༌ ཏེ༌ གྲོང༌ཁྱེར༌གུན༌ནི༌ ནང༌ང༌ དུག༌ཁན༌ ཀེ༌ནན༌པ༌གུན༌ ཕིངས༌ཏེ༌ ཏེ༌བོ༌ ང༌ཡོག༌ག༌ ཁྱོང༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","སྟིང༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཤེད༌ཅན༌ གྱུར༌ར༌ཅིག༌ ཁོང༌གུན༌ནི༌ ཀེ༌ནན༌པ༌གུན༌ ཚེ༌ཡོག༌ ཅོས༌ཏེ༌ བོརས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ ཏེ༌ ས༌ཀྱད༌ནེ༌ མ༌ ཕིངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌གུན༌ནི༌ ཡོ༌ཤུའ༌ ཟེརས༌, “ཅི༌ཕིའ༌ ཉེ༌རང༌ངི༌ ང༌ཞ༌གུན༌ལ༌ ས༌ཀྱད༌དི༌ ཁག༌ཅིག༌ མ༌ནེ༌ མ༌ཏང༌ང༌ ཨིན༌? ཡ༌ཝའེ༌ ང༌ཞའ༌ ཅིན༌ལབས༌ སལ༌ལ༌ ཛད༌ཏེ༌ ང༌ཞ༌གུན༌ མ༌མང༌པོ༌ གྱུར༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","ཡོ༌ཤུའེ༌ ལན༌ཏངས༌, “ཀལ༌ཏེས༌ ཁྱོ༌ཞའ༌ མང༌པོ༌ ཕེལ༌ཏེ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕིའ༌ ཆུ༌ངུན༌ ཆའད༌ན༌ པེ༌རིཟ༌པ༌ དང༌ རེ༌ཕ༌པ༌ དུག༌སའེ༌ ནག༌ཚོགས༌ ཆད༌ཏེ༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཕིའ༌ ས༌ཀྱད༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌གུན༌ནི༌ ལན༌ཏངས༌, “དེན༌བ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ ང༌ཞ༌གུན༌ནི༌ ཕིའ༌ ཆུ༌ངུན༌ སོང༌ཏེ༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ བེཐ༌ ཤན༌ དང༌ ཏེ༌བོའེ༌ ཉེ༌ཁོར༌ལ༌ ཚུགས༌ཏེ༌ དུག༌ཁན༌ ཡང༌ ཡེཟ༌རེ༌འེལ༌ལི༌ ལུང༌པའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཀེ༌ནན༌པ༌ མག༌མི༌གུན༌ལ༌ ལྕགས༌སི༌ རྟ༌རེལ༌ ཡོད༌ པ༌སང༌ ཁོང༌གུན༌ མ༌ ཤེད༌ཅན༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌ ཨེཕ༌ར༌ཡིམ༌ དང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ མང༌པོ༌ དང༌ ཤེད༌ཅན༌ ཡོད༌ པ༌སང༌ ངའེ༌ ཁྱོ༌ཞའ༌ ས༌ཀྱད༌ ཁག༌ ཅིག༌གི༌ སང༌ མང༌ང༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","རི༌ཡུལ༌ལི༌ ནག༌ཚོགས༌ ཁྱོ༌ཞའེ༌ ཨིན༌, ཙམ༌ཤིག༌ ཉན༌ན༌ ཆད༌ཏེ༌ ཁྱོ༌རང༌གུན༌ནི༌ ཕིའ༌ ས༌ཀྱད༌ ཅོས༌། ཀེ༌ནན༌པ༌གུན༌ལ༌ ལྕགས༌སི༌ རྟ༌རེལ༌ ཡང༌ ཤེད༌ཅན༌ ཡོད༌ནའང༌ ཁྱོ༌ཞའ༌ ཁོང༌གུན༌ ཏེ༌ ས༌ཀྱད༌ནེ༌ ཕིང༌ ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ ཇོམས༌ ཡང༌ ཡ༌ཝའ༌ ཐུག༌སའེ༌ ཀུར༌བོ༌ ཏེ༌རུ༌ ཙུགས༌། ཁོང༌གུན༌ནི༌ ཁྱོང༌ཉན༌ཁན༌ནི༌ ས༌ཀྱད༌ ཚང༌མ༌ ཝང༌ངི༌ ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ ཨིན༌ནའང༌ ");
INSERT INTO lbj_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","ཏ༌རོང༌ ནོར༌སྐལ༌ལི༌ ས༌ཀྱད༌ མ༌ཐོབ༌ཁན༌ མི༌སྡེ༌ རྡུན༌ ལུས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཡ༌ཝ༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞའ༌ སལ༌ཁན༌ནི༌ ས༌ཀྱད༌པོ༌ ང༌ཡོག༌ག༌ མ༌ ལེན༌ན༌ ཙམ༌ཞིག༌ སྲུངས༌ཏེ༌ དུག༌ཅེན༌? ");
INSERT INTO lbj_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","མི༌སྡེ༌ རེ༌རེ༌ནེ༌ མི༌ སུམ༌སུམ༌ ལྡོམ༌, ཡང༌ ངའེ༌ ཁོང༌གུན༌ ལུས༌ཏེ༌ ཡོད༌ཁན༌ ས༌ཀྱད༌དི༌ སྟ༌སྟོག༌ ཅོ༌ཅེས༌ལ༌ ཀལ༌ཨིན༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཁོང༌རང༌གུན༌ལ༌ ནོར༌སྐལ༌ལ༌ བགོས༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ སན༌ཚམས༌སི༌ ནག༌ཤ༌ ཅོས༌ཏེ༌ ངའེ༌ཀ༌ ཁྱོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","ཁྱོ༌ཞ༌གུན༌ནི༌ ས༌ཀྱད༌པོ༌ པོ༌ རྡུན༌ནི༌ ནང༌ང༌ བགོ༌གོས༌ ཀ༌བོའེ༌ ནང༌ང༌ ལྷོ༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ ཡ༌ཧུ༌དཱའེ༌ ས༌ཀྱད༌ ཡང༌ བྱང༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ ཡོ༌སེབ༌བི༌ ས༌ཀྱད༌ ཐེ༌མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","ཁྱོ༌ཞའེ༌ ས༌ཀྱད༌ པོ༌ རྡུན༌ནི༌ ནང༌ང༌ བགོས༌ཁན༌ནི༌ ནག༌ཤ༌ ངའ༌ ཁྱོང༌ ཏེ༌ནེ༌ ངའེ༌ ཡ༌ཝ༌ ང༌དང༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ སྐུན༌དུན༌ལ༌ ཏག༌རིལ༌ ཏངས༌ཏེ༌ སྡེ༌ རེ༌རེའ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌པོ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","“ལི༌ཝི༌པ༌གུན༌ལ༌ ས༌ཀྱད༌ ནོར༌སྐལ༌ལ༌ མི༌ཐོབ༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ བླ༌མའེ༌ ཚུལ༌ལ༌ ཡ༌ཝའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌པོ༌ ཁོང༌གུན༌ནི༌ ནོར༌སྐལ༌ ཨིན༌ནོག༌། ཡང༌ གཱད༌ དང༌ རུ༌བེན༌ནི༌ མི༌སྡེ༌གུན༌ ཡང༌ མ༌ནས༌ས༌ མི༌སྡེ༌ ཕེད༌པོའ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ ནོར༌སྐལ༌ལི༌ ས༌ཀྱད༌ ཐོབ༌ཚར༌ཏེ༌ ཨིན༌ནོག༌, ཀ༌བོ༌ ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ ཁོང༌གུན༌ལ༌ སལས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","ཏེ༌ནེ༌ ས༌ཀྱད༌དི༌ ནག༌ཤ༌ ཅོའ༌ལ༌ མི༌གུན༌ ཆ༌ཅེས༌ གོ༌ཟུག༌ག༌ཅིག༌ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “སོང༌ ཡང༌ ས༌ཀྱད༌དི༌ སྟ༌སྟོག༌ ཅོས༌ ཡང༌ ནག༌ཤ༌ ཅོས༌ཏེ༌ ཏེ༌བོའེ༌ སྐོར༌ལ༌ བྲིས༌ ཡང༌ ལོགས༌ཏེ༌ ཡོང༌ང༌ཅིག༌ ཏེ༌གུན༌ ངའེ༌ཀ༌ ཁྱོང༌། ངའེ༌ འི༌རུ༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཏག༌རིལ༌ ཏངས༌ཏེ༌ ཏེ༌གུན༌ བགོས༌ཏེ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","མི༌གུན༌ སོང༌ཏེ༌ ཡུལ༌ གང༌པོ༌ ལྟས༌ ཡང༌ ཤོག༌རིལ༌ལི༌ཀ༌ ཏེ༌བོ༌ ཁག༌ རྡུན༌ནི༌ ནང༌ང༌ བགོས༌ཁན༌ནི༌ ནག༌ཤ༌ ཅོས༌ཏེ༌ གྲོང༌ཁྱེར༌ རེ༌རེ༌ མིང༌གུན༌ བྲིས༌, ཡང༌ ཡོ༌ཤུའ༌ ཡོད༌ས༌ ཤི༌ལོཧ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","ཏེ༌ནེ༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ ཡོ༌ཤུའེ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཏག༌རིལ༌ ཏངས༌ཏེ༌ སྡེ༌ རེ༌རེའ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌པོ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","ས༌ཀྱད༌དི༌ ཁག༌ ཏང༌པོ༌ བེན༌ཡཱ༌མིན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌། ཡ༌ཧུ༌དཱ༌ དང༌ ཡོ༌སེབ༌བི༌ སྡེའ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ པར༌ལ༌ ཁོང༌གུན༌ནི༌ ཁག༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","བེན༌ཡཱ༌མིན༌པའེ༌ བྱང༌ ཆོགས༌སི༌ སན༌ཚམས༌པོ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ནེ༌ གོ༌ཟུགས༌ཏེ༌ བྱང༌ ཆོགས༌སི༌ ཡེ༌རི༌ཀོའེ༌ ཁྲེད༌ གྱུད༌ཏེ༌ ནུབ༌ ཆོགས༌སི༌ རི༌ ཡུལ༌གུན༌ དང༌ བེཐ༌ ཨེ༌ཝན༌ནི༌ ཐང༌སྟོང༌ ཚག༌པ༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","ཏེ༌ཀ༌ནེ༌ ལྷོ༌ ཆོགས༌ལ༌ ལུཟ༌སི༌ ཁྲེད༌ ༼ཡང༌ན༌ བེ༌ཐེལ༌༽ གྱུད༌ཏེ༌ ཐུར༌ལ༌ རི༌ཀ༌ ཡོད༌ཁན༌ ཨ༌ཏ༌རོཐ༌ ཨད༌དར༌ ཚག༌པ༌ ལེབ༌, ཀ༌བོ༌ ཡོག༌གི༌ བེཐ༌ ཧོ༌རོན༌ནི༌ ལྷོ༌ ཆོགས༌ལ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","ཏེ༌ནེ༌ སན༌ཚམས༌པོ༌ ཀྱོགས༌ཏེ༌ ལྷོ༌ ཆོགས༌ལ༌, བེཐ༌ ཧོ༌རོན༌ ཐོང༌ཁན༌ནི༌ རི༌ ལྷོ༌ ཆོགས༌སི༌ ཟུར༌ གྱུད༌ཏེ༌ ཡ༌ཧུ༌དཱའེ༌ སྡེའེ༌ ཨིན༌ཁན༌ ཀི༌རི༌འཐ༌ བའལ༌ ༼ཡང༌ན༌ ཀི༌རི༌འཐ༌ ཡེ༌རིམ༌༽ གྲོང༌ཁྱེར༌ ཚག༌པ༌ ལེབ༌། འི༌གུན༌ ནུབ༌ ཆོགས༌སི༌ སན༌ཚམས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","ལྷོ༌ ཆོགས༌སི༌ སན༌ཚམས༌, ནུབ༌ ཆོགས༌སི༌ ཀི༌རི༌འཐ༌ ཡེ༌རིམ༌ནེ༌ གོ༌ཟུགས༌ཏེ༌ ནེཕ༌ཏོ༌འཧའེ༌ ཆུ༌མིག༌ ཚོག༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","ཡང༌ ཐུར༌ལ༌ རི༌ཡོག༌, བེན༌ ཧིན༌ནོམ༌མི༌ ལུང༌པ༌ ལྟས༌ཏེ༌ རེ༌ཕ༌འིམ༌མི༌ ལུང༌པའེ༌ བྱང༌ ཆོགས༌ ཚག༌པ༌, ཏེ༌ནེ༌ ཐུར༌ལ༌ ཧིན༌ནོམ༌མི༌ ལུང༌པ༌ ཆོགས༌ལ༌, ཡེ༌བས༌པ༌གུན༌ནི༌ གྱལ༌སའེ༌ ལྷོ༌ ཆོགས༌སི༌ ཁྲེད༌ གྱུད༌ཏེ༌ ཨེན༌ རོ༌གེལ༌ ཚག༌པ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","ཏེ༌ཀ༌ནེ༌ ཨེན༌ ཤེ༌མེཤ༌, བྱང༌ ཆོགས༌ལ༌ ཀྱོགས༌ཏེ༌ གེ༌ལི༌ལོཐ༌ལ༌ ལེབ༌ ཀ༌བོ༌ ཨ༌དུམ༌མིམ༌ ལའེ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཨིན༌ནོག༌། ཏེ༌ནེ༌ ཏེ༌བོ༌ ཐུར༌ལ༌ རུ༌བེན༌ནི༌ བུ༌ཚ༌ བོ༌ཧན༌ནི༌ རྡོའ༌ ཚོག༌པ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","ཏེ༌ཀ༌ནེ༌ ཏེ༌བོ༌ བེཐ༌ ཨ༌ར༌བཧའེ༌ བྱང༌ ཆོགས༌སི༌ ཁྲེད༌ གྱུད༌ཏེ༌ ཐུར༌ལ༌ ལུང༌པའེ༌ ནང༌ང༌, ");
INSERT INTO lbj_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ཡང༌ བེཐ༌ ཧོག༌ལཧའེ༌ བྱང༌ ཆོགས༌སི༌ ཁྲེད༌ གྱུད༌ཏེ༌ ཚོ༌རུལ༌ལི༌ བྱང༌ ཆོགས༌སི༌ ཐའ༌མ༌ ཚག༌པ༌ ལེབ༌ ཀ༌བོ༌ ལྷོ༌ ཆོགས༌སི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཁའ༌ ཨིན༌ནོག༌། ཏེ༌གུན༌ ལྷོ༌ ཆོགས༌སི༌ སན༌ཚམས༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","ཤར༌ ཆོགས༌སི༌ སན༌ཚམས༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ ཨིན༌ནོག༌། ཏེ༌གུན༌ བེན༌ཡཱ༌མིན༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ སན༌ཚམས༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","བེན༌ཡཱ༌མིན༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཏང༌ཁན༌ནི༌ གྲོང༌ཁྱེར༌གུན༌ འི༌གུན༌ ཨིན༌། ཡེ༌རི༌ཀོ༌, བེཐ༌ ཧོག༌ལཧ༌, ཨེ༌མེག༌ ཀེ༌ཟིཟ༌, ");
INSERT INTO lbj_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","བེཐ༌ ཨ༌ར༌བཧ༌, ཟེ༌མ༌ར༌འིམ༌, བེ༌ཐེལ༌, ");
INSERT INTO lbj_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","ཨཝ༌ཝིམ༌, པ༌རཧ༌, ཨོཕ༌རཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ཀེ༌ཕར༌ ཨམ༌མོ༌ནི༌, ཨོཕ༌ནི༌ དང༌ གེ༌བ༌, གྲོང༌ཁྱེར༌ རྕུག༌ཉིས༌ དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","ཡང༌ གི༌བེ༌འོན༌, ར༌མཧ༌, བེ༌རོཐ༌, ");
INSERT INTO lbj_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","མིཟ༌པཧ༌, ཀེ༌ཕི༌རཧ༌, མོ༌ཟཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","རེ༌ཀེམ༌, འིར༌པེལ༌, ཏ༌ར༌ལཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ཟི༌ལཧ༌, ཧཱའེ༌ལེབ༌, ཡེ༌བས༌པའེ༌ གྱལ༌ས༌ ༼ཡང༌ན༌ ཡེ༌རུ༌ཤ༌ལེམ༌༽, གི༌བེའཧ༌ དང༌ ཀི༌རི༌འཐ༌, གྲོང༌ཁྱེར༌ ཅུབ༌ཞི༌ དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ཏེ༌གུན༌ བེན༌ཡཱ༌མིན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ནི༌ ནོར༌སྐལ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","ཏག༌རིལ༌ གྱུད༌ཏེ༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌ ཉིས༌པ༌ སི༌མི༌འོན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌། ཁོང༌གུན༌ནི༌ ས༌ཀྱད༌ ཡ༌ཧུ༌དཱའེ༌ མི༌སྡེའེ༌ ས༌ཀྱད༌གུན༌ནི༌ སྐོར༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","སི༌མི༌འོན༌ནི༌ མི༌སྡེའེ༌ ས༌ཀྱད༌གུན༌ ནི༌ བེར༌ཤེ༌བ༌ ༼ཡང༌ན༌ ཤེ༌བ༌༽, མོ༌ལ༌དཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ཧ༌ཟར༌ ཤུ༌འལ༌, བ༌ལཧ༌, ཨེ༌ཟེམ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ཨེལ༌ཀྲོ༌ལད༌, བེ༌ཐུལ༌, ཧོར༌མཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ཟིག༌ལག༌, བེཐ༌ མར༌ཀ༌བོཐ༌, ཧ༌ཟར༌ སུ༌སཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","བེཐ༌ ལེ༌བཱ༌འོཐ༌ དང༌ ཤ༌རུ༌ཧེན༌, གྲོང༌ཁྱེར༌ 13 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌ལ༌ ཡོད༌ཁན༌ནི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","ཨའིན༌, རིམ༌མོན༌, ཨེ༌ཐེར༌ དང༌ ཨ༌ཤན༌། གྲོང༌ཁྱེར༌ ཞི༌ དང༌ ཏེ༌གུན༌ནི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","ཡང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌, ཐག༌རིང༌ ལྷོ༌ ཆོགས༌སི༌ བའ༌ལཐ༌ བེར༌ ཚག༌པ༌ ཨིན༌ནོག༌ ཀ༌བོའ༌ ནེ༌གེཝ༌ཝི༌ ར༌མཧ༌ཧའང༌ ཟེར༌ར༌ནོག༌། ཏེ༌གུན༌ སི༌མི༌འོན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","ཁོང༌གུན༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌གུན༌ ཡ༌ཧུ༌དཱའེ༌ མི༌སྡེའ༌ ཏངས༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཕྲོའ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཧུ༌དཱའེ༌ མི༌སྡེའ༌ ཏང༌ཁན༌ནི༌ ཁག༌པོ༌ ཁོང༌གུན༌ནི༌ སྒོས༌དོམ༌མི༌ སང༌ མང༌ང༌ ཡོད༌པིན༌། ཏེ༌བོའེ༌ཕིའ༌ སི༌མི༌འོན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ནེ༌ ས༌ཀྱད༌དི༌ ནོར༌སྐལ༌ ཐོབས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","ཏག༌རིལ༌ གྱུད༌ཏེ༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌ སུམ༌པ༌བོ༌ ཟེ༌བུ༌ལོན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌། ཟེ༌བུ༌ལོན༌ནི༌ སྡེའེ༌ སན༌ཚམས༌ ས༌རིད༌ གྱལ༌ས༌ ཚག༌པ༌ ལེབ༌བད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","ནུབ༌ ཆོགས༌ལ༌ མ༌ར༌ལཧ༌ གྱལ༌ས༌ནེ༌ དབ༌བེ༌ཤེཐ༌ གྱལ༌ས༌ ཐུགས༌ཏེ༌ ཡོཀ༌ནེའམ༌མི༌ ཉེ༌མོའ༌ ཡོད༌ཁན༌ ལུང༌པ༌ ཚོག༌པ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","ས༌རིད༌ནེ༌ ཤར༌ ཆོགས༌ ཉི༌མ༌ ཤར༌སའ༌ ཀྱོགས༌ཏེ༌ ཀིས༌ལོཐ༌ ཏྲ༌བོར༌རི༌ ཡུལ༌ཇོངས༌ ཚག༌པ༌, ཏེ༌ཀ༌ནེ༌ ད༌བེ༌རཐ༌ ཡང༌ ཡ༌ཕིའ༌ ཚོག༌པ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","ཏེ༌ནེ༌ ཏེ༌བོ༌ ཤར༌ ཆོགས༌ལ༌ གཱད༌ ཧེ༌ཕེར༌ དང༌ ཨེཐ༌ ཀ༌ཟིན༌ གྱུད༌ཏེ༌ རིམ༌མོན༌ ཚག༌པ༌ ཡང༌ ནེའཧ༌ ཆོགས༌ལ༌ ཀྱོགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","ཁོང༌གུན༌ནི༌ བྱང༌ ཆོགས༌སི༌ སན༌ཚམས༌པོ༌ ཧན༌ན༌ཐོན༌ གྱུད༌ཏེ༌ ཨིཕ༌ཏཧ༌ ཨེལ༌ ལུང༌པ༌ ཚོག༌པ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","ཀཏ༌ཏཐ༌, ན༌ཧ༌ལལ༌, ཤིམ༌རོན༌, ཨི༌ད༌ལཧ༌ དང༌ བེད༌ལེ༌ཧེམ༌, གྲོང༌ཁྱེར༌ 12 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཏེ༌ནང༌ང༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","ཟེ༌བུ༌ལོན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཏེ༌ གྲོང༌ཁྱེར༌གུན༌ དང༌ ཏེ༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","ཏག༌རིལ༌ གྱུད༌ཏེ༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌ ཞི༌པ༌བོ༌ ཨིས༌ས༌ཁར༌རི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","ཁོང༌གུན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ འི༌ གྲོང༌ཁྱེར༌གུན༌ ཨིན༌ནོག༌, ཡེཟ༌རེ༌འེལ༌, ཀེ༌སུལ༌ལོཐ༌, ཤུ༌ནེམ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ཧ༌ཕ༌རཱའིམ༌, ཤི༌འོན༌, ཨ༌ན༌ཧ༌རཐ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","རབ༌བིཐ༌, ཀི༌ཤི༌འོན༌, ཨེ༌བེཟ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","རེ༌མེཐ༌, ཨེན༌ གན༌ནིམ༌, ཨེན༌ ཧད༌དཧ༌ དང༌ བེཐ༌ པཟ༌ཟེཟ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","སན༌ཚམས༌པོ༌ ཏྲ༌བོར༌, ཤ༌ཧ༌ཟུ༌མཧ༌ དང༌ བེཐ༌ ཤེ༌མེཤ༌ གུན༌ལ༌ ཐུགས༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ཀ༌ ཚར༌རད༌པིན༌། གྲོང༌ཁྱེར༌ 16 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","ཏེ༌ གྲོང༌ཁྱེར༌གུན༌ དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིས༌ས༌ཁར༌རི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌ཁན༌ནི༌ ནོར༌སྐལ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","ཏག༌རིལ༌ གྱུད༌ཏེ༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌ ལྔ༌པ༌བོ༌ ཨ༌ཤེར༌རི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","ཁོང༌གུན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ འི༌ གྲོང༌ཁྱེར༌གུན༌ ཨིན༌ནོག༌། ཧེལ༌ཀཐ༌, ཧ༌ལི༌, བེ༌ཏེན༌, ཨཀ༌ཤཕ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","ཨལ༌ལམ༌མེ༌ལེཆ༌, ཨ༌མད༌ དང༌ མི༌ཤལ༌། ནུབ༌ ཆོགས༌སི༌ སན༌ཚམས༌ ཀར༌མེལ༌ དང༌ ཤི༌ཧོར༌ ལིབ༌ནཐ༌ལ༌ ཐུགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ཤར༌ ཆོགས༌ལ༌ བེཐ༌ གྲ༌གོན༌ ཆོགས༌ལ༌ ཀྱོགས༌ཏེ༌ ཐག༌རིང༌ ཨིཕ༌ཏཧ༌ ཨེལ༌ལི༌ ལུང༌པའེ༌ ཟེ༌བུ༌ལོན༌ ཚོག༌པ༌ ལེབ༌། ཏེ༌ཀ༌ནེ༌ ཀ༌བུལ༌, ཡོ༌མ༌ ཆོགས༌ལ༌ བོར༌ཏེ༌ བྱང༌ ཆོགས༌ལ༌ བེཐ༌ ཨེ༌མེག༌ དང༌ ནེའི༌ཨེལ༌ ཚོག༌པ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","ཡང༌ ཨབ༌གྲོན༌, རེ༌ཧོབ༌, ཧམ༌མོན༌, ཀ༌ནཧ༌ ཡང༌ ཐག༌རིང༌ ཁག༌ཅན༌ གྱལ༌ས༌ སི༌དོན༌ ཚོག༌པ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","ཏེ༌ནེ༌ ར༌མཧ༌ ཆོགས༌ལ༌ ཀྱོགས༌ཏེ༌ གྱང༌སྐོར༌ ཐོན༌པོ༌ ཏང༌ཁན༌ནི༌ ཏཱ༌ཡིར༌རི༌ གྱལ༌ས༌ ཚག༌པ༌ ལེབ༌ཏེ༌ ཧོ༌སཧ༌ ཆོགས༌ལ༌ ཀྱོགས༌ ཡང༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌ ཡོད༌ས༌ ལེབ༌། ཁོང༌གུན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ མ༌ཧ༌བལ༌, ཨཀ༌ཟིབ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ཨུམ༌མཧ༌, ཨ༌ཕེཀ༌ དང༌ རེ༌ཧོབ༌ གྲོང༌ཁྱེར༌གུན༌ ཨིན༌ནོག༌། གྲོང༌ཁྱེར༌ 22 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","ཨ༌ཤེར༌རི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌ཁན༌ནི༌ ནོར༌སྐལ༌ལི༌ ནང༌ང༌ ཏེ༌ གྲོང༌ཁྱེར༌གུན༌ དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","ཏག༌རིལ༌ གྱུད༌ཏེ༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌ དྲུག༌པ༌བོ༌ ནཕ༌ཐལ༌ལི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","ཁོང༌གུན༌ནི༌ སན༌ཚམས༌པོ༌ ཧེ༌ལེཕ༌ཕི༌ ཉེ༌མོའ༌ ཟའ༌ནན༌ནིམ༌མི༌ ནང༌ང༌ ཡོད༌ཁན༌ འོག༌གི༌ ལྕང༌མ༌ནེ༌ ཨ༌ད༌མི༌ ནེ༌ཀེབ༌ དང༌ ཡབ༌ནེལ༌ གྱུད༌ཏེ༌ ལཀ༌ཀུམ༌ ཚོག༌པ༌ ལེབ༌ཏེ༌ ཡོར༌དཱན༌ནི༌ ལྩངས༌པོའེ༌ཀ༌ ཚར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","ནུབ༌ ཆོགས༌སི༌ སན༌ཚམས༌ ཨཟ༌ནོཐ༌ ཏྲ༌བོར༌ནེ༌ ཧུཀ༌ཀོཀ༌ ཚག༌པ༌ ཡང༌ ལྷོ༌ ཆོགས༌ལ༌ ཟེ༌བུ༌ལོན༌ནི༌ སན༌ཚམས༌, ནུབ༌ ཆོགས༌ལ༌ ཨ༌ཤེར༌རི༌ སན༌ཚམས༌ དང༌ ཤར༌ ཆོགས༌ལ༌ ཡོར༌དཱན༌ ལྩངས༌པོའ༌ ཐུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","གྱང༌སྐོར༌ ཐོན༌པོའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ གྱལ༌ས༌གུན༌ ནི༌ ཟིད༌དིམ༌, ཟེར༌, ཧམ༌མཐ༌, རཀ༌ཀཐ༌, ཀིན༌ནེ༌རེཐ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","ཨད༌མཧ༌, ར༌མཧ༌, ཧ༌ཟོར༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ཀེ༌དེཤ༌, ཨེད༌རེའི༌, ཨེན༌ ཧ༌ཟོར༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ཨི༌རོན༌, མིག༌དལ༌ ཨེལ༌, ཧོ༌རེམ༌, བེཐ༌ ཨ༌ནཐ༌ དང༌ བེཐ༌ ཤེ༌མེཤ༌ གུན༌ ཨིན༌ནོག༌། གྲོང༌ཁྱེར༌ 19 དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌ལ༌ ཡོད༌ཁན༌ནི༌ གྲོང༌སེབ༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","ནཕ༌ཐལ༌ལི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཏངས༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཏེ༌ གྲོང༌ཁྱེར༌གུན༌ དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","ཏག༌རིལ༌ གྱུད༌ཏེ༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ཁག༌ རྡུན༌པ༌བོ༌ དཱན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","ཁོང༌གུན༌ལ༌ ཏངས༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ འི༌ གྲོང༌ཁྱེར༌གུན༌ ཨིན༌ནོག༌, ཟོ༌རཧ༌, ཨེཤ༌ཏ༌འོལ༌, ཨིར༌ ཤེ༌མེཤ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ཤའ༌ལབ༌བིན༌, ཨའི༌ཡ༌ལོན༌, ཨིཐ༌ལཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ཨེ༌ལོན༌, ཏིམ༌ནཧ༌, ཨེཀ༌རོན༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ཨེལ༌ཏེ༌ཀེཧ༌, གིབ༌བེ༌ཐོན༌, བའ༌ལཐ༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ཡེ༌ཧུད༌, བེ༌ནེ༌ བེ༌རཀ༌, གཱད༌ རིམ༌མོན༌, ");
INSERT INTO lbj_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","མེ༌ཡར༌ཀོན༌, རཀ༌ཀོན༌ དང༌ ཡོཔ༌པའེ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ནི༌ ཡུལ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","ཨིན༌ནའང༌ དཱན༌ནི༌ མི༌སྡེའ༌ ཏེ༌ ས༌ཀྱད༌ ལེན༌ཅེས༌ལ༌ ཀགས༌པོ༌ སོང༌ ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ནི༌ ལེ༌ཤེམ༌མི༌ གྲོང༌ཁྱེར༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ ཡང༌ ཏེ༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མ༌ སད༌ཏེ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ཚུགས༌ཏེ༌ དུགས༌ ཡང༌ ཁོང༌རང༌གུན༌ནི༌ ཕ༌མེས༌པོའེ༌ མིང༌ངི༌ གྱབ༌ནེ༌ ཏེ༌བོའ༌ དཱན༌ མིང༌ང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","དཱན༌ནི༌ སྡེའེ༌ མི༌རིགས༌གུན༌ལ༌ ཏང༌ཁན༌ནི༌ ནོར༌སྐལ༌ལི༌ ནང༌ང༌ ཏེ༌ གྲོང༌ཁྱེར༌གུན༌ དང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","མི༌སྡེ༌གུན༌ནི༌ པར༌ལ༌ ས༌ཀྱད༌ གང༌པོ༌ བགོ༌ ཚར༌ཏེ༌ སྟིང༌ནེ༌, ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ནུན༌ནི༌ བུ༌ཚ༌ ཡོ༌ཤུའ༌ ཁོང༌རང༌གུན༌ནི༌ ཕྲོའ༌ ས༌ཀྱད༌དི༌ ནོར༌སྐལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཁོང༌གུན༌ནི༌ ཡོ༌ཤུའ༌ ཁོའེ༌ ཏོང༌ ཟེར༌ཁན༌ནི༌ གྲོང༌ཁྱེར༌ ཏངས༌། ཡོ༌ཤུའེ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ ཏིམ༌ནཐ༌ སེ༌རཧ༌ ལྡམས༌ ཡང༌ གྲོང༌ཁྱེར༌བོ༌ ཡང༌སྐྱར༌ རྩིགས༌ཏེ༌ ཏེ༌རུ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","བླ༌མ༌ ཨེ༌ལི༌འ༌ཟར༌, ནུན༌ནི༌ བུ༌ཚ༌ ཡོ༌ཤུའ༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཁོང༌ ཐུག༌སའེ༌ ཀུར༌རི༌ སྒོའེ༌ཀ༌ གྱན༌ གྱབས༌ཏེ༌ ཏངས༌ཁན༌ནི༌ ས༌ཀྱད༌, ཏེ༌ ཚང༌མ༌ ཨིན༌ནོག༌། ཏེ༌ནེ༌ ས༌ཀྱད༌ བགོས༌ཏེ༌ ཏང༌ཅེས༌པོ༌ ཚར༌། ");
INSERT INTO lbj_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","ཡ༌ཝའེ༌ ཡོ༌ཤུའ༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“ཏ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ སྐྱབ༌སའེ༌ གྱལ༌ས༌གུན༌ ལྡམ༌ཅེས༌ལ༌ ཟེར༌ ཀ༌ཟུག༌ ངའེ༌ མོ༌ཟེས༌ལ༌ ལབས༌ཏེ༌ ཨིན༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ཅིའ༌ཟེར༌ན༌ ཀལ༌ཏེས༌ མི༌ཞིག༌གི༌ མིང༌ནའང༌ མན༌པ༌ ཡ༌ སྐྱེན༌ངན༌ནི༌ ཞས༌ཏེ༌ མི༌ཞིག༌ སད༌ན༌ ཁོང༌གུན༌ ཏེ༌ གྱལ༌ས༌ ཤོར༌ཏེ༌ མི༌ སད༌ཁན༌ནི༌ ལན༌ ལེན༌ན༌ ཐད༌ཁན༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌ ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","“ཏེ༌ གྱལ༌ས༌ ཤོར༌ཁན༌ནི༌ མི༌བོ༌ གྱལ༌སའེ༌ སྒོའེ༌ དུན༌ལ༌ ལངས༌ཏེ༌ ཏེ༌ གྱལ༌སའེ༌ འུ༌སྐྱོང༌གུན༌ནི༌ དུན༌ལ༌ རང༌ངི༌ ཅོ༌ཁན༌བོ༌ ཤད༌གོས༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཁོ༌ གྱལ༌སའེ༌ ནང༌ང༌ ཡོང༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཕྲོའ༌ ཁོའ༌ དུག༌སའེ༌ ནས༌ས༌ ཏང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","ཀལ༌ཏེས༌ ཤི༌ཁན༌ནི༌ ཉེན༌གྲུང༌ ཁྲག༌ལན༌ ལེན༌ན༌ ཡོང༌ན༌ འུ༌སྐྱོང༌གུན༌ནི༌ ཏེ༌ མི༌བོ༌ ཁོང༌གུན༌ལ༌ སྟད༌ མ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ མིང༌ནའང༌ ཡ༌ ཁོན༌ ཡོད༌ཏེ༌ མི༌བོ༌ སད༌ཏེ༌ མ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","ཨིན༌ནའང༌ ཏེ༌ མི༌བོ༌ ཏེ༌ ཡུལ༌ལི༌ ཐུས༌མི༌གུན༌ནི༌ ཤགས༌ ཅད༌ཅད༌ ཡང༌ ཏེ༌ ཏུས༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ བླ༌མ༌ ཆེན༌མོ༌ ཤི༌ཤི༌ ཚོག༌པ༌ ཏེན༌ན༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌གོས༌། ཏེ༌སྟིང༌ནེ༌ ཁོ༌ ཤོར༌ཏེ༌ ཡོང༌ཁན༌ ཁོ༌རང༌ངི༌ གྲོང༌ཁྱེར༌ལ༌ ལོགས༌ཏེ༌ ཆ༌ནའང༌ གྲིག༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","ཏེ༌བོའེ༌ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ནཕ༌ཐལ༌ལི༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ གཱ༌ལིལ༌ལི༌ ཡུལ༌ ཀེ༌དེཤ༌, ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཤེ༌ཀེམ༌ དང༌ ཡ༌ཧུ༌དཱའེ༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཀི༌རི༌འཐ༌ ཨར༌བ༌ ༼ཡང༌ན༌ ཧེབ༌རོན༌༽ གྱལ༌ས༌གུན༌ ལྡམས༌། ");
INSERT INTO lbj_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","ཁོང༌གུན༌ནི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ ཡེ༌རི༌ཀོའེ༌ ཉེ༌མོའ༌ རུ༌བེན༌ནི༌ མི༌སྡེའེ༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཡོད༌ཁན༌ བེ༌ཟེར༌, གཱད༌དི༌ མི༌སྡེའེ༌ གི༌ལེད༌དི༌ ནང༌ང༌ ཡོད༌ཁན༌ ར༌མོཐ༌ ཡང༌ མ༌ནས༌ས༌ མི༌སྡེའེ༌ བ༌ཤན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ གོ༌ལན༌ གྱལ༌ས༌གུན༌ ལྡམས༌། ");
INSERT INTO lbj_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཡ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ དུག༌ཁན༌ ཞན༌ཡུལ༌ལི༌ མི༌ སུ༌ཞིག༌གི༌ མིང༌ནའང༌ མན༌པ༌ ཡ༌ སྐྱེན༌ངན༌ནི༌ ཞས༌ཏེ༌ མི༌ སད༌ཁན༌གུན༌ འི༌ གྱལ༌ས༌གུན༌ནི༌ ནང༌ང༌ ཤོར༌ཏེ༌ མི༌ སད༌ཁན༌ནི༌ ལན༌ ལེན༌ན༌ ཐད༌ཁན༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌ ཉན༌ཨིན༌། ཏེ༌རུ༌ འུ༌སྐྱོང༌གུན༌ལ༌ ཁོའེ༌ ཤགས༌སི༌ ཐག༌ཅད༌ཏེ༌ མ༌ནེ༌ ལན༌ ལེན༌ན༌ ཐད༌ཁན༌གུན༌ནི༌ ཁོའ༌ སད༌ མི༌ཆོགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","2","ཀེ༌ནན༌ནི༌ ས༌ཀྱད༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ བླ༌མ༌ ཨེ༌ལི༌འ༌ཟར༌, ནུན༌ནི༌ བུ༌ཚའེ༌ ཡོ༌ཤུའ༌ དང༌ ཞན༌ ཨིས༌ར༌ཨེལ༌པའེ༌ འུ༌སྐྱོང༌གུན༌ ཡོད༌ས༌ ལི༌ཝི༌ མི༌སྡེའེ༌ འུ༌སྐྱོང༌གུན༌ ཡོངས༌ཏེ༌ ཟེརས༌, “ང༌ཞ༌གུན༌ལ༌ དུག༌སའེ༌ གྲོང༌ཁྱེར༌ དང༌ ང༌ཞའེ༌ སེམས༌ཅན༌གུན༌ནི༌ ཕིའ༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌ སལ༌ཅེས༌ལ༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཏེ༌ ཨིན༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ལི༌ཝི༌པ༌གུན༌ལ༌ འི༌ གྲོང༌ཁྱེར༌གུན༌ དང༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌, ཁོང༌རང༌གུན༌ནི༌ ནོར༌སྐལ༌ལི༌ ས༌ཀྱད༌གུན༌ནི༌ ནང༌ནེ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","ལི༌ཝི༌ མི༌སྡེའེ༌ ཨ༌རོན༌ནི༌ པུར༌གྱུད༌ ཀོ༌ཧཐ༌ཐི༌ མི༌རིགས༌གུན༌ལ༌ ཡ༌ཧུ༌དཱའ༌, སི༌མི༌འོན༌ དང༌ བེན༌ཡཱ༌མིན༌ནི༌ མི༌སྡེ༌གུན༌ནི༌ སྐལ༌ལེ༌ ནང༌ནེ༌ གྲོང༌ཁྱེར༌ 13 ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","ལུས༌ཁན༌ནི༌ ཀོ༌ཧཐ༌ཐི༌ མི༌རིགས༌གུན༌ལ༌ ཨེཕ༌ར༌ཡིམ༌ དང༌ དཱན༌ མི༌སྡེ༌ ཡང༌ མ༌ནས༌ས༌ མི༌སྡེ༌ ཕེད༌དི༌ སྐལ༌ལེ༌ ནང༌ནེ༌ གྲོང༌ཁྱེར༌ རྕུ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","གེར༌ཤོན༌ནི༌ མི༌རིགས༌གུན༌ལ༌ ཨིས༌ས༌ཁར༌, ཨ༌ཤེར༌ དང༌ ནཕ༌ཐལ༌ལི༌ མི༌སྡེ༌གུན༌ ཡང༌ བ༌ཤན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ མ༌ནས༌ས༌ མི༌སྡེ༌ ཕེད༌དི༌ སྐལ༌ལེ༌ ནང༌ནེ༌ གྲོང༌ཁྱེར༌ 13 ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","མི༌ར༌རི༌ མི༌རིགས༌གུན༌ལ༌ རུ༌བེན༌, གཱད༌ དང༌ ཟེ༌བུ༌ལོན༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ གྲོང༌ཁྱེར༌ 12 ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའེ༌ མོ༌ཟེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཏེ༌ གྲོང༌ཁྱེར༌ དང༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ ཏག༌རིལ༌ ཏངས༌ཏེ༌ ལི༌ཝི༌པ༌གུན༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཧུ༌དཱ༌ དང༌ སི༌མི༌འོན༌ནི༌ མི༌སྡེ༌གུན༌ནི༌ ནང༌ནེ༌ འི༌ གྲོང༌ཁྱེར༌གུན༌ ཏངས༌ ");
INSERT INTO lbj_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","ཏག༌རིལ༌ ཏང༌པོའེ༌ ནང༌ཞིན༌ ལྡམ༌ཁན༌ནི༌ ས༌ཀྱད༌གུན༌ ལི༌ཝི༌ མི༌སྡེའེ༌ ཨ༌རོན༌ནི༌ པུར༌གྱུད༌ ཀོ༌ཧཐ༌ཐི༌ མི༌རིགས༌གུན༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","ཁོང༌གུན༌ལ༌ ཡ༌ཧུ༌དཱའེ༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ ཀི༌རི༌འཐ༌ ཨར༌བ༌ ༼ཡང༌ན༌ ཧེབ༌རོན༌༽ དང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌ གུན༌ ཏངས༌། ༼ཨར༌བ༌ ནི༌ ཨ༌ནཀ༌པའེ༌ ཕ༌མེས༌པོ༌ ཨིན༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","ཨིན༌ནའང༌ ཏེ༌ གྱལ༌སའེ༌ ཞིང༌ དང༌ ཉེ༌ཁོར༌རི༌ གྲོང༌སེབ༌གུན༌ ཡེ༌ཕུན༌ནེཧའེ༌ བུ༌ཚ༌ ཀེ༌ལེབ༌བ༌ ནོར༌སྐལ༌ལ༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","ཏེ༌ནེ༌ ཨ༌རོན༌ བླ༌མའེ༌ པུར༌གྱུད༌གུན༌ལ༌ ཧེབ༌རོན༌ གྱལ༌ས༌ ༼སྐྱེན༌ངན༌ནི༌ ནང༌ང༌ མི༌ སད༌ཁན༌གུན༌ སྐྱོབ༌སའེ༌ གྱལ༌ས༌༽, ལིབ༌ནཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","ཡཏ༌ཏིར༌, ཨེཤ༌ཏེ༌མོའ༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","ཧོ༌ལོན༌, དེ༌བིར༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ཨའིན༌, ཡུཏ༌ཏཧ༌ དང༌ བེཐ༌ ཤེ༌མེཤ༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ ཏངས༌། ཏེ༌ མི༌སྡེ༌ ཉིས༌ཀོའེ༌ ནང༌ནེ༌ གྲོང༌ཁྱེར༌ རྒུ༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","ཁོང༌གུན༌ལ༌ བེན༌ཡཱ༌མིན༌ནི༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ གི༌བེ༌འོན༌, གེ༌བ༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","ཨ༌ན༌ཐོཐ༌ དང༌ ཨལ༌མོན༌, གྲོང༌ཁྱེར༌ ཞི༌ དང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","ཚང༌མ༌ རྩི༌ན༌ གྲོང༌ཁྱེར༌ 13 དང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ ཨ༌རོན༌ནི༌ པུར༌གྱུད༌ བླ༌མ༌གུན༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","ལུས༌ཁན༌ནི༌ ཀོ༌ཧཐ༌ཐི༌ མི༌རིགས༌གུན༌ལ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ ས༌ཀྱད༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","ཨེཕ༌ར༌ཡིམ༌ རི༌ཡུལ༌ལི༌ ནང༌ནེ༌, ཤེ༌ཀེམ༌ ༼སྐྱེན༌ངན༌ནི༌ ནང༌ང༌ མི༌ སད༌ཁན༌གུན༌ སྐྱོབ༌སའེ༌ གྱལ༌ས༌༽, གེ༌ཟེར༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ཀིབ༌ཟ༌འིམ༌ དང༌ བེཐ༌ ཧོ༌རོན༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌, ལྡོམས༌ གྲོང༌ཁྱེར༌ ཞི༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","ཏེ༌བོའེ༌ཀ༌ ནན༌མ༌ དཱན༌ནི༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ ཁོང༌གུན༌ལ༌ ཨེལ༌ཏེ༌ཀེཧ༌, གིབ༌བེ༌ཐོན༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","ཨའི༌ཡ༌ལོན༌ དང༌ གཱད༌ རིམ༌མོན༌ གྲོང༌ཁྱེར༌གུན༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌, ལྡོམས༌ གྲོང༌ཁྱེར༌ ཞི༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","མ༌ནས༌ས༌ མི༌སྡེ༌ ཕེད༌དི༌ སྐལ༌ལེ༌ ནང༌ནེ༌ ཁོང༌གུན༌ལ༌ ཏའ༌ནག༌ དང༌ གཱད༌ རིམ༌མོན༌, གྲོང༌ཁྱེར༌ ཉིས༌ དང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","ཏེ༌ གྲོང༌ཁྱེར༌ རྕུ༌ དང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ ལུས༌ཁན༌ནི༌ ཀོ༌ཧཐ༌ཐི༌ མི༌རིགས༌གུན༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","ལི༌ཝི༌ མི༌སྡེའེ༌ གེར༌ཤོན༌ནི༌ མི༌རིགས༌གུན༌ལ༌ མ༌ནས༌ས༌ མི༌སྡེ༌ ཕེད༌དི༌ སྐལ༌ལེ༌ ནང༌ནེ༌ བ༌ཤན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ གོ༌ལན༌ ༼སྐྱེན༌ངན༌ནི༌ ནང༌ང༌ མི༌ སད༌ཁན༌གུན༌ སྐྱོབ༌སའེ༌ གྱལ༌ས༌༽ དང༌ བེ༌ཨེཤ༌ཏེ༌རཧ༌ གྲོང༌ཁྱེར༌ ཉིས༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","ཨིས༌ས༌ཁར༌རི༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ ཀི༌ཤི༌འོན༌, ད༌བེ༌རཐ༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","ཡར༌མུཐ༌, དང༌ ཨེན༌ གན༌ནིམ༌ གྲོང༌ཁྱེར༌གུན༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌, ལྡོམས༌ གྲོང༌ཁྱེར༌ ཞི༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","ཨ༌ཤེར༌རི༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ མི༌ཤལ༌, ཨབ༌གྲོན༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","ཧེལ༌ཀཐ༌ དང༌ རེ༌ཧོབ༌ གྲོང༌ཁྱེར༌གུན༌ ཡང༌ ཏེ༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌, ལྡོམས༌ གྲོང༌ཁྱེར༌ ཞི༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","ནཕ༌ཐལ༌ལི༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ གཱ༌ལིལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཀེ༌དེཤ༌ ༼སྐྱེན༌ངན༌ནི༌ ནང༌ང༌ མི༌ སད༌ཁན༌གུན༌ སྐྱོབ༌སའེ༌ གྱལ༌ས༌༽, ཧམ༌མོཐ༌ དོར༌ དང༌ ཀར༌ཏན༌ གྲོང༌ཁྱེར༌གུན༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌, ལྡོམས༌ གྲོང༌ཁྱེར༌ སུམ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","ཚང༌མ༌ རྩི༌ན༌ གྲོང༌ཁྱེར༌ 13 དང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ གེར༌ཤོན༌ནི༌ མི༌རིགས༌གུན༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","ལི༌ཝི༌པ༌ ལུས༌ཏེ༌ ཡོད༌ཁན༌ མི༌ར༌རི༌འི༌ མི༌རིགས༌གུན༌ལ༌ ཟེ༌བུ༌ལོན༌ནི༌ མི༌སྡེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ ཡོཀ༌ནེའམ༌, ཀར༌ཏཧ༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","དིམ༌ནཧ༌ དང༌ ན༌ཧ༌ལལ༌ གྲོང༌ཁྱེར༌གུན༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ ཏངས༌, ལྡོམས༌ གྲོང༌ཁྱེར༌ ཞི༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","རུ༌བེན༌ནི༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ བེ༌ཟེར༌, ཡ༌ཧཟ༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","ཀེ༌དེ༌མོཐ༌ དང༌ མེ༌ཕའཐ༌ གྲོང༌ཁྱེར༌གུན༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌, ལྡོམས༌ གྲོང༌ཁྱེར༌ ཞི༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","གཱད༌དི༌ མི༌སྡེའེ༌ སྐལ༌ལེ༌ ནང༌ནེ༌ གི༌ལེད༌དི༌ ནང༌ང༌ ཡོད༌ཁན༌ ར༌མོཐ༌ ༼སྐྱེན༌ངན༌ནི༌ ནང༌ང༌ མི༌ སད༌ཁན༌གུན༌ སྐྱོབ༌སའེ༌ གྱལ༌ས༌༽, མ༌ཧ༌ནཱའིམ༌, ");
INSERT INTO lbj_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","ཧེཤ༌བོན༌ དང༌ ཡ༌ཟེར༌ གྲོང༌ཁྱེར༌གུན༌ ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌, ལྡོམས༌ གྲོང༌ཁྱེར༌ ཞི༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","ཚང༌མ༌ རྩི༌ན༌ ལི༌ཝི༌ མི༌སྡེའེ༌ ལུས༌ཁན༌ མི༌ར༌རི༌འི༌ མི༌རིགས༌གུན༌ལ༌ གྲོང༌ཁྱེར༌ 12 ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","ཨིས༌ར༌ཨེལ༌ལི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ནེ༌ ལི༌ཝི༌པ༌གུན༌ལ༌ ལྡོམས༌ གྲོང༌ཁྱེར༌ 48 ཡང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","འི༌ གྲོང༌ཁྱེར༌ ཚང༌མ༌ དང༌ ཉེ༌ཁོར༌རི༌ རྩཱ༌ཁའེ༌ ས༌ཀྱད༌གུན༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ ཕ༌མེས༌པོ༌གུན༌ལ༌ སལ༌ཅེས༌ལ༌ ནའ༌ ཁུར༌ར༌ ཛད༌ཁན༌ནི༌ ས༌ཀྱད༌ གང༌པོ༌ སལ༌ལ༌ ཛདས༌། ཁོང༌གུན༌ནི༌ ཏེ༌གུན༌ ཝང༌ངའི༌ ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ ཏེ༌རུ༌ ཚུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","ཡ༌ཝའེ༌ ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ལ༌ ནའ༌ ཁུར༌ར༌ ཛད༌ཁན༌ ནང༌ཞིན༌ ཆོགས༌ ཚང༌མ༌ནེ༌ ཁོང༌གུན༌ལ༌ ཞི༌དེ༌ སལ༌ལ༌ ཛདས༌། གྲ༌འོ༌ ཅིག༌གའང༌ ཁོང༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ལངས༌ མ༌ཉནས༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ ཁོང༌ངི༌ གྲ༌འོ༌གུན༌ ཁོང༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ད༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཛད༌ཁན༌ནི༌ ཞལ༌ཆད༌ ཟང༌པོ༌གུན༌ནི༌ ནང༌ནེ༌ ཅིག༌གའང༌ མ༌གྲུབ༌བ༌ མ༌ལུས༌། ཁོང༌ངི༌ མོལ༌ཁན༌ ཚང༌མ༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མི༌སྡེ༌ ཡང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌པོའ༌ བོད༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ བཀའ༌ སལ༌ཁན༌ ཚང༌མ༌ ཅོས༌ ཡང༌ ངའེ༌ ཟེར༌ཁན༌ ཚང༌མ༌ ཁའ༌ཉནས༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","ཏུས༌ མ༌ རིང༌མོ༌ དི༌རིང༌ ཚོག༌པ༌ ཁྱོ༌ཞའེ༌ ཁྱོ༌ཞ༌རང༌ངི༌ སྤུན༌གུན༌ལ༌ རོགས༌ ཅོས༌ཏེ༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ བཀའ༌ སལ༌ཁན༌གུན༌ ཁའ༌ཉནས༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","ཏ༌ ང༌དང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཞལ༌ཆད༌ ནང༌ཞིན༌ ཁྱོ༌ཞའེ༌ སྤུན༌གུན༌ལ༌ ཞི༌དེ༌ སལ༌ པ༌སང༌ ཡ༌ཝའེ༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ ཁྱོ༌ཞའ༌ སལ༌ཁན༌ ནས༌ས༌, ཁྱོ༌ཞ༌རང༌ངི༌ ཁང༌པ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","ཨིན༌ནའང༌ མོ༌ཟེས༌སི༌ སལ༌ཁན༌ནི༌ བཀའ༌ཁྲིམས༌གུན༌ དང༌ བཀའ༌རྒྱ༌གུན༌ལ༌ སྲུང༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌། ང༌དང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའ༌ ཅམས༌པ༌ ཅོ༌, ཁོང༌ངི༌ སྟན༌ན༌ ཛད༌ཁན༌ནི༌ ལམ༌མི༌ཀ༌ གྲུལ༌, ཁོང༌ངི༌ བཀའ༌གུན༌ལ༌ ཁའ༌ ཉོན༌, ཁོང༌ང༌ སྟན༌པོ༌ ཐམས༌ཏེ༌ དུག༌ ཡང༌ སྙིང༌ གང༌པོ༌ དང༌ སེམས༌ གང༌པོ༌ནེ༌ ཁྱོ༌ཞའེ༌ ཁོང༌ང༌ ཞབས༌ཏོག༌ ཞུས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ལ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ ཁོང༌གུན༌ ལམ༌ཅུགས༌ ཡང༌ ཁོང༌གུན༌ ཁང༌པ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","༼མོ༌ཟེས༌སི༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌པོའ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ བ༌ཤན༌ནི༌ ས༌ཀྱད༌ ཡང༌ ཞན༌ ཕེད༌པོའ༌ ཡོར༌དཱན༌ནི༌ ནུབ༌ ཆོགས༌ལ༌ ས༌ཀྱད༌ ཏངས༌ཏེ༌ ཨིན༌པིན༌༽ ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ ལོགས༌ཏེ༌ ལམ༌ཅུག༌ ཟ༌ནེ༌ ཁོང༌གུན༌ལ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ ཁང༌པ༌ གྱུ༌ནོར༌ མང༌པོ༌ ཉམ༌པོ༌ ལོགས༌ཏེ༌ སོང༌, སེམས༌ཅན༌ནི༌ ཁྱུ༌ མང༌པོ༌, མུལ༌, སེར༌, ར༌གན༌, ལྕགས༌ ཡང༌ ཀོས༌ལག༌ མང༌པོ༌, གྲ༌འོ༌གུན༌ནི༌ ཀ༌ནེ༌ ཅོམས༌ཏེ༌ ཁྱོང༌ཁན༌ནི༌ གྱུ༌ནོར༌གུན༌ ཁྱོ༌ཞའེ༌ ཉེན༌གྲུང༌གུན༌ ཉམ༌པོ༌ བགོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","ཏེ༌ནེ༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མི༌སྡེ༌ ཡང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌པོའ༌ ཞན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཀེ༌ནན༌ནི༌ ནས༌ས༌ ཤི༌ལོཧའ༌ བོར༌ཏེ༌ ཁོང༌རང༌གུན༌ནི༌ ས༌ཀྱད༌ གི༌ལེད༌ལ༌ ལོགས༌ཏེ༌ སོང༌ ཀ༌བོ༌ མོ༌ཟེས༌ གྱུད༌ཏེ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཁོང༌གུན༌ལ༌ ཐོབ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","ཁོང༌གུན༌ ཀེ༌ནན༌ནི༌ ནང༌ང༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཉེ༌མོའ༌ ཡོད༌ཁན༌ གེ༌ལི༌ལོཐ༌ ནས༌སའེ༌ཀ༌ ལེབ༌བ༌ཅིག༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མི༌སྡེ༌ ཡང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌ གུན༌ནི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ དུན༌ལ༌ ཆོད༌ཁྲི༌ ཆེན༌མོ༌ ཞིག༌ རྩིགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","ཏེ༌ནེ༌ ཞན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མི༌སྡེ༌ ཡང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌ གུན༌ནི༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ནུབ༌ ཆོགས༌ ཀེ༌ནན༌ནི༌ ས༌ཀྱད༌དི༌ ཐའ༌མ༌ གེ༌ལི༌ལོཐ༌ཐི༌ ནང༌ང༌ ཆོད༌ཁྲི༌ རྩིགས༌ཁན༌བོ༌ ཚོར༌ར༌ཅིག༌ ");
INSERT INTO lbj_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ ཛོམས༌ཏེ༌ ཁོང༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ མག༌ ཏང༌ཅེས༌སི༌ གྲལ༌གྲིག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","ཁོང༌གུན༌ནི༌ བླ༌མ༌ ཨེ༌ལི༌འ༌ཟར༌རི༌ བུ༌ཚ༌ ཕི༌ནི༌ཧས༌སི༌ གོ༌ཁྲིད༌ ཅོས༌ཏེ༌ ཐུས༌མི༌གུན༌ རུ༌བེན༌, གཱད༌ དང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌ གུན༌ལ༌ སྤེ༌ར༌ ཏང༌ང༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","འི༌ ཐུས༌མི༌གུན༌ནི༌ ནང༌ང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌ རྕུ༌, མི༌སྡེ༌ རེ༌རེ༌ ནེ༌ མི༌ རེ༌རེ༌, ཁོང༌གུན༌ རང༌རང༌ངི༌ མི༌རིགས༌སི༌ ནང༌ང༌ ནང༌ཚངས༌སི༌ གོ༌སྐྱོང༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","ཁོང༌གུན༌ གི༌ལེད༌དི༌ ནས༌ས༌ ལེབས༌ཏེ༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མི༌སྡེ༌ ཡང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌ གུན༌ལ༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“ཡ༌ཝའེ༌ ཆོས༌ཚོགས༌ ཚང༌མའེ༌ ཏྲི༌དུག༌, ‘ཁྱོ༌ཞའེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ དཀོན༌མཆོག༌གི༌ཀ༌ ཏད༌པ༌ ཕངས༌ཏེ༌ ཁོང༌ང༌ གྱབ༌གལ༌ ཅོས༌ཏེ༌ འི༌ ཆོད༌ཁྲི༌ ཅིའ༌ རྩིགས༌ཏེ༌ ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","པེ༌འོར༌རི༌ ནང༌ང༌ ང༌དང༌གུན༌ནི༌ ཅོ༌ཁན༌ནི༌ སྡིག༌པ༌ ཐའ༌ཐད༌ མ༌ནོག༌ག༌? ཡ༌ཝའེ༌ མི༌གུན༌ནི༌ཀ༌ ཏེ༌ ནད༌པོ༌ ཡོངས༌ཏེའང༌, དི༌རིང༌ ཚག༌པ༌ ང༌དང༌གུན༌ ཏེ༌ སྡིག༌པ༌ནེ༌ ལག༌མོ༌ མ༌ཆ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","ཁྱོ༌ཞ༌གུན༌ དི༌རིང༌ ཡ༌ཝ༌ ནེ༌ ཐག༌རིང༌ང༌ ཤོར༌ཏེ༌ ཨིན༌ན༌?’” “དི༌རིང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཡ༌ཝའེ༌ གྱབ༌གལ༌ ཅོ༌ན༌ ཐོ༌རེ༌ ཁོང༌ ང༌དང༌ ཚང༌མའེ༌ཀ༌ ཐུག༌སྲོ༌ སྐྱོད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","ཁྱོ༌ཞའ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌ ཏམ༌པ༌ མན༌ན༌ ཡ༌ཝའེ༌ ཀུར༌ ཡོད༌སའེ༌ ཁོང༌ངི༌ ས༌ཀྱད༌ ཆོགས༌ལ༌ ཡོང༌ ཡང༌ ང༌ཞའེ༌ ཕྲོའ༌ ཁྱོ༌ཞའེ༌ སྐལ༌ལའེ༌ ས༌ཀྱད༌ ལེན༌། ཨིན༌ནའང༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌ ཅིག༌པོའེ༌ ཆོད༌ཁྲི༌ མན༌པ༌ ཞན༌ ཡང༌ ཆོད༌ཁྲི༌ རྩིགས༌ཏེ༌ ཡ༌ཝ༌ ཡ༌ ང༌ཞ༌གུན༌ནི༌ གྱབ༌གལ༌ མ༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","ཟེ༌རཧའེ༌ བུ༌ཚ༌ ཨ༌ཀེན༌ནི༌ ཡ༌ཝའ༌ ཕུལ༌ཅེས༌སི༌ ཅ༌ལག༌གུན༌ནི༌ ནང༌ནེ༌ སྐུས༌ཏེ༌ སྡིག༌པ༌ ཅོ༌ཅེས༌པའེ༌ ཡ༌ཝའེ༌ ཐུག༌སྲོ༌ ཨིས༌ར༌ཨེལ༌ གང༌པོའེ༌ཀ༌ མ༌བབས༌ས༌? ཁོའེ༌ སྡིག༌པའེ༌ ཞས༌ཏེ༌ ཁོ༌རང༌ ཅིག༌པོ༌ མན༌པ༌ ཞན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནའང༌ ཤི༌།” ");
INSERT INTO lbj_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","ཏེ༌ནེ༌ རུ༌བེན༌, གཱད༌ དང༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕེད༌པོའེ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མི༌རིགས༌གུན༌ནི༌ གོ༌སྐྱོང༌གུན༌ལ༌ ལན༌ཏངས༌, ");
INSERT INTO lbj_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“ཡ༌ཝ༌, དཀོན༌མཆོག༌ ཀུན༌ཝང༌། ཡ༌ཝ༌, དཀོན༌མཆོག༌ ཀུན༌ཝང༌། ཁོང༌ངི༌ ཁྱེན༌ན༌ ཛད༌ད༌ནོག༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལའང༌ གྱུས༌ ཆ༌གོས༌། ང༌ཞ༌གུན༌ནི༌ འི༌ ཆོད༌ཁྲི༌ རྩིགས༌ཏེ༌ ཡ༌ཝའེ༌ གྱབ༌གལ༌ ཅོས༌ཏེ༌ ཨིན༌ན༌ ང༌ཞ༌གུན༌ སད༌ནའང༌ གྲིག༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","ཀལ༌ཏེས༌ ང༌ཞའེ༌ ཡ༌ཝ༌ ནེ༌ ཐག༌རིང༌ང༌ ཆ༌ཅེས༌ལ༌ ང༌ཞ༌རང༌ངི༌ ཕིའ༌ མེའ༌ སྲག༌ཅེས༌ ཡ༌ གྲུའི༌ ཡ༌ ཞི༌དེ༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ འི༌ ཆོད༌ཁྲི༌ རྩིགས༌ཏེ༌ ཨིན༌ན༌ ཡ༌ཝ༌ ཁོང༌རང༌ངི༌ ང༌ཞ༌གུན༌ལ༌ ཆད༌པ༌ སལ༌ལ༌ ཛད༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","མན༌། ང༌ཞའེ༌ ཏེ༌བོ༌ ཅོས༌པིན༌ ཅིའ༌ཟེར༌ན༌ ང༌ཞ༌གུན༌ ཇིགས༌ས༌ རག༌, ཞག༌ཤིག༌ ཁྱོ༌ཞའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ཟེར༌ སྲིད༌ཅེས༌ ཨིན༌ནོག༌, ‘ང༌ཞའེ༌ ཅོལ༌ཁན༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཆོད༌པ༌ ཕུལ༌ མི༌ ཆོགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","ཡ༌ཝའེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ ང༌ཞ༌གུན༌ དང༌ ཁྱོ༌ཞའ༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མིར༌གྱུད༌གུན༌ནི༌ པར༌ལ༌ སན༌ཚམས༌ ཅོའ༌ཛདས༌, ཁྱོ༌ཞ༌གུན༌ནི༌ ཡ༌ཝའ༌ ཅོལ༌ མི༌ ཆོགས༌།’ ཏེ༌ཟུག༌ ཟེར༌ཏེ༌ ཁྱོ༌ཞའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ང༌ཞའེ༌ པུར༌གྱུད༌གུན༌ལ༌ ཡ༌ཝའ༌ ཅོལ༌ཅེས༌ སྒག༌ སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“ཏེ༌ གྱུན༌ཚན༌ནི༌ ཕིའ༌ ང༌ཞ༌གུན༌ནི༌ ཆོད༌ཁྲི༌ རྩིགས༌པིན༌། ཆོད༌པ༌ མེའ༌ སྲག༌ཅེས༌ ཡ༌ སྲོག༌ཆོད༌ ཕུལ༌ཅེས༌སི༌ ཕིའ༌ མ༌རྩིགས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","འི༌བོ༌ ང༌ཞའ༌ དང༌ ཁྱོ༌ཞའ༌ ཡང༌ ང༌དང༌གུན༌ནི༌ པུར༌གྱུད༌ གུན༌ནི༌ ཕིའ༌, ང༌ཞ༌གུན༌ནི༌ མེའ༌ སྲག༌ཅེས༌, སྲོག༌ཆོད༌ དང༌ ཞི༌དེའེ༌ ཆོད༌པ༌ གུན༌ ཡ༌ཝའེ༌ ཏམ༌པ༌ ཀུར༌ ཡོད༌ས༌ ཅིག༌པོའེ༌ཀ༌ ཕུལ༌ཏེ༌ ཁོང༌ང༌ ཅོལ༌ཅེས༌སི༌ སྤང༌པོ༌ཞིག༌ ཨིན༌ནོག༌། ཏེ༌ནེ༌ ཁྱོ༌ཞའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ང༌ཞའེ༌ པུར༌གྱུད༌གུན༌ལ༌, ‘ཁྱོ༌ཞའ༌ ཡ༌ཝའེ༌ མི༌གུན༌ མན༌’ ཟེར༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","“ཀལ༌ཏེས༌ ཁོང༌གུན༌ནི༌ ཏེ༌ཟུག༌ ཟེར༌ན༌ ང༌ཞའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ཟེར༌ཉན༌ཨིན༌, ‘ལྟོས༌, ང༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ རྩིགས༌ཁན༌ནི༌ ཆོད༌ཁྲི༌ ཡ༌ཝའེ༌ ཆོད༌ཁྲི༌ ཙོགས༌ དུག༌, ཡང༌ ཏེ༌བོ༌ སྲག༌ཅེས༌ ཡ༌ སྲོག༌ཆོད༌དི༌ ཆོད༌པ༌ ཕུལ༌ལ༌ མན༌པ༌ ང༌ཞའ༌ དང༌ ཁྱོ༌ཞའ༌ ཉིས༌ཀོ༌ ཡ༌ཝའེ༌ ཨིན༌ཁན༌ནི༌ སྤང༌པོ༌ ཏང༌ང༌ནོག༌།’ ");
INSERT INTO lbj_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","ཡ༌ཝའེ༌ གྱབ༌གལ༌ ང༌ཞ༌གུན༌ནི༌ མན༌ནེ༌ མི༌ཅོ༌ ཡང༌ མེའ༌ སྲག༌ཅེས༌, སྲོག༌ཆོད༌ དང༌ ཞི༌དེའེ༌ ཆོད༌པ༌ གུན༌ ཕུལ༌ཅེས༌སི༌ ཆོད༌ཁྲི༌ རྩིགས༌ཏེ༌ ང༌ཞའ༌ ཁོང༌ནེ༌ ཐག༌རིང༌ང༌ མན༌ནེ༌ མི༌ཆ༌། ཏེ༌གུན༌ ཕུལ༌སའེ༌ ནས༌ས༌ ཡ༌ཝའེ༌ ཏམ༌པ༌ ཀུར༌རི༌ དུན༌ལ༌ ཡོད༌ཁན༌ནི༌ ཆོད༌ཁྲི༌ ཅིག༌པོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","རུ༌བེན༌, གཱད༌ དང༌ མ༌ནས༌ས༌ མི༌སྡེ༌ ཕེད༌ གུན༌ནི༌ ཟེར༌ཁན༌བོ༌ བླ༌མ༌ ཕི༌ནི༌ཧས༌ དང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ཚོར༌ར༌ཅིག༌ ཁོང༌གུན༌ ཐད༌པོ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","ཨེ༌ལི༌འ༌ཟར༌རི༌ བུ༌ཚ༌ བླ༌མ༌ ཕི༌ནི༌ཧས༌སི༌ ཁོང༌གུན༌ལ༌ ལན༌ཏངས༌, “ཡ༌ཝ༌ ང༌དང༌གུན༌ནི༌ ཕྲོའ༌ ཞུགས༌ཏེ༌ ཨིན༌ཁན༌བོ༌ དི༌རིང༌ ང༌དང༌གུན༌ལ༌ ཧ༌གོ༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌ཞའེ༌ ཡ༌ཝའེ༌ གྱབ༌གལ༌ལ༌ འི༌ ལས༌པོ༌ མ༌ཅོའ༌ ཨིན༌ནོག༌ ཀ༌ཟུག༌ ང༌ཞའེ༌ སམ༌། ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌གི༌ ཆད༌པ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱོབས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","ཏེ༌ནེ༌ བླ༌མ༌ ཕི༌ནི༌ཧས༌ དང༌ སྤོན༌བོ༌གུན༌ རུ༌བེན༌ དང༌ གཱད༌དི༌ མི༌སྡེ༌གུན༌ གི༌ལེད༌དི༌ ནང༌ང༌ བོར༌ཏེ༌ ཀེ༌ནན༌ནི༌ ས༌ཀྱད༌ལ༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཇུང༌ཁན༌གུན༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཐད༌པོ༌ སོང༌ཏེ༌ དཀོན༌མཆོག༌ག༌ སྟོད༌པ༌ ཕུལས༌ ཡང༌ རུ༌བེན༌ དང༌ གཱད༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ མག༌ ཏངས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ནས༌ས༌ མེད༌ཁན༌ ཅོ༌ཅེས༌སི༌ སྤེ༌ར༌ མ༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","རུ༌བེན༌ དང༌ གཱད༌པ༌གུན༌ནི༌ ཆོད༌ཁྲི༌བོའ༌ “སྤང༌པོ༌” མིང༌ ཏགས༌ཏེ༌ ཟེརས༌, “འི༌བོ༌ ང༌ཞའ༌ དང༌ ཁོང༌གུན༌ནི༌ པར༌ལ༌ ཡ༌ཝ༌ ང༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཞུགས༌ཁན༌ནི༌ སྤང༌པོ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཁོང༌གུན༌ནི༌ གྲ༌འོ༌ ཚང༌མའེ༌ ཀ༌ནེ༌ ཞི༌དེ༌ སལ༌ཏེ༌ ལོ༌ མང༌པོའེ༌ སྟིང༌ནེ༌, ཡོ༌ཤུའ༌ མ༌རྒད༌པོ༌ སོང༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","ཁོང༌ངི༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌, འུ༌སྐྱོང༌, ཁྲིམ༌སྤོན༌ དང༌ མག༌མི༌ སྤོན༌བོ༌ ཚང༌མ༌ བོདས༌ ཡང༌ ཟེརས༌, “ང༌ ལོ༌ མང༌པོ༌ སོང༌ཏེ༌ སྲན༌ཏྲེ༌ སྒས༌ཏེ༌ ཨིན༌ནོག༌ ");
INSERT INTO lbj_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཏོན༌ལ༌ གྱལ༌ཁམས༌ ཚང༌མ༌ ཉམ༌པོ༌ ཛད༌ཁན༌བོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཐོང༌ཏེ༌ ཨིན༌ནོག༌། ང༌དང༌ངི༌ གྲ༌འོ༌གུན༌ལ༌ ནོལ༌ལ༌ ཛད༌ཁན༌བོ༌ ཡ༌ཝ༌ ང༌དང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཞུགས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ནོར༌སྐལ༌ལི༌ ཚུལ༌ལ༌ ཤར༌ ཆོགས༌སི༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ནེ༌ ཏངས༌ཏེ༌ ནུབ༌ ཆོགས༌ལ༌ མེ༌གྲི༌ཀྲེ༌རིའན༌ནི༌ ཚོ༌ ཚོག༌པ༌ བགོས༌ཏེ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌ ང༌ཡོག༌ག༌ ཁྱོང༌ཁན༌ ཡང༌ མ༌ ཁྱོང༌ཁན༌ ཚང༌མ༌ ལྟོས༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","ཏེ༌ ས༌ཀྱད༌ ཚང༌མ༌ ཁྱོ༌ཞའེ༌ གྱུར༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཏེ༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མ༌ ཕིང༌ང༌ ཛད༌ཨིན༌། ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཞལ༌ཆད༌ ཛད༌ཁན༌ ནང༌ཞིན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཏེ༌ ས༌ཀྱད༌གུན༌ ལེན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“མོ༌ཟེས༌སི༌ ཁྲིམས༌སི༌ སྤེ༌ཆའེ༌ ནང༌ང༌ བྲིས༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མ༌ ཁའ༌ ཉན༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌, ཏེ༌གུན༌ནེ༌ གྱུར༌ཏེ༌ ཡས༌པ༌ ཡ༌ ཡོ༌མ༌ མ༌ཆ༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","འི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ དུག༌ཁན༌ མི༌གུན༌ ཉམ༌པོ༌ བྲེལ༌ མི༌བོར༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ གུན༌ནི༌ མིང༌ ཡ༌ ཏེ༌གུན༌ནི༌ མིང༌ངི༌ ནང༌ང༌ ནའ༌ མ༌ཁུར༌ ཡང༌ ཏེ༌གུན༌ལ༌ ཞབས༌ཏོག༌ མ༌ཞུ༌ ཡ༌ ཅོལ༌ མ༌ཅོལ༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","ཨིན༌ནའང༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌ག༌ སྟན༌པོ༌ ཐམས༌ཏེ༌ དུག༌ ཀ༌ཟུག༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དག༌ས༌ ཚག༌པ༌ ཅོ༌ཨིན༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“ཡ༌ཝའེ༌ གྱལ༌ཁག༌ ཝང༌ཅན༌ དང༌ ཤུགས༌ཅན༌ ཚང༌མ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕིའ༌ ཕིངས༌ཏེ༌ ཁྱོ༌ཞའ༌ ཏང༌ང༌ ཛདས༌། དག༌ས༌ ཚག༌པ༌ ཁྱོ༌ཞའེ༌ གྱབ༌གལ༌ལ༌ གྱལ༌ཁམས༌ ཅིག༌གའང༌ ལངས༌ མ༌ཉན༌ན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","མག༌གི༌ ནང༌ང༌ ཁྱོ༌ཞའ༌ རེ༌རེའེ༌ གྲ༌འོ༌ སྟོང༌ ཤོར༌ ཅུག༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞའེ༌ ཏོན༌ལ༌ ནོལ༌ལ༌ ཛད༌ཨིན༌ ཀ༌ཟུག༌ ཁོང༌ངི༌ ཞལ༌ཆད༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","ཏེ༌བོའེ༌ཕིའ༌ ཡ༌ཝ༌ ཁྱོ༌ཞ༌རང༌ངི༌ དཀོན༌མཆོག༌ག༌ ཅམས༌པ༌ ཅོ༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ཁྱོ༌ཞའ༌ ཁོང༌ནེ༌ གྱུར༌ཏེ༌ འི༌ གྱལ༌ཁམས༌སི༌ མི༌ མ༌ཕིང༌ང༌ ལུས༌ཁན༌གུན༌ནི༌ ལུག༌སྲོལ༌ ཡང༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌ཏེ༌ བྲེལ༌ བོར༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","ཏེ༌ནེ༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ཁོང༌གུན༌ འི༌ ས༌ཀྱད༌དི༌ ནང༌ནེ༌ ཕིང༌ང༌ མི༌ ཛད༌ཅེས༌པོ༌ སལ༌པོ༌ ཧ༌གོ༌གོས༌ མ༌ཚད༌ ཁོང༌གུན༌ ཁྱོ༌ཞའ༌ ཁད༌ཅེས༌སི༌ སྙི༌འུ༌, ཁྱོ༌ཞའེ༌ གྱབ༌བ༌ ཕོག༌ཁན༌ ལྟལ༌ཅགས༌ ཡང༌ ཁྱོ༌ཞའེ༌ མིག༌གི༌ ནང༌ང༌ ཙེར༌མང༌ ཙོགས༌ གྱུར༌ཨིན༌ ཡང༌ ཡ༌ཝ༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞའ༌ སལ༌ཁན༌ནི༌ འི༌ ས༌ཀྱད༌ ཟང༌པོའེ༌ ནང༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ ཕིང༌ང༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“ཏ༌ ང༌ ཤི༌ཅེས༌སི༌ ཏུས༌ ལེབ༌ཏེ༌ ཨིན༌ནོག༌། ཁྱོ༌ཞ༌གུན༌ལ༌ སྙིང༌ནེ༌ ཧ༌གོ༌ཏེ༌ ཨིན༌ནོག༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཞལ༌ཆད༌ ཛད༌ཁན༌ ཟང༌པོ༌ ཅིག༌གའང༌ དྲན༌དྲའ༌ མ༌གྲུབ༌བ༌ མ༌ལུས༌། ཚང༌མ༌ དྲན༌དྲའ༌ གྲུབ༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","ཨིན༌ནའང༌ ཡ༌ཝ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ ཞལ༌ཆད༌ ཛད༌ཁན༌ ཚང༌མ༌ དྲན༌དྲའ༌ གྲུབ༌བ༌ ཙོགས༌ལ༌ ཁོང༌ངི༌ ཁྱོ༌ཞ༌གུན༌ནི༌ཀ༌ ངན༌པ༌ ཚང༌མ༌ ཇུང༌ཅེས༌སི༌ སྤང༌པུད༌ད༌ ཛད༌ཁན༌གུན༌ནའང༌ དྲན༌དྲའ༌ གྲུབ༌ཨིན༌ ནམ༌ཚག༌པ༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞའ༌ སལ༌ཁན༌ནི༌ འི༌ ས༌ཀྱད༌ ཟང༌པོའེ༌ ནང༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ མེད༌ཁན༌ མི༌ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","ཀལ༌ཏེས༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌གུན༌ ཅགས༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཅོལ༌ ཡ༌ ཞབས༌ཏོག༌ ཞུས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཆག༌ ཕུལ༌ན༌ ཁོང༌ངི༌ ཐུག༌ སྲོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ཀ༌ ཀྲག༌པོ༌ མེ༌ བར༌ཁན༌ ཙོགས༌ བབས༌ཨིན༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ ཁོང༌ངི༌ སལ༌ཁན༌ནི༌ འི༌ ས༌ཀྱད༌ ཟང༌པོ༌ ནང༌ནེ༌ མ༌ གྱོགས༌པ༌ མེད༌ཁན༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌ ཚང༌མ༌ ཤེ༌ཀེམ༌མི༌ ནང༌ང༌ ཛོམ༌ཅུགས༌། ཁོང༌ངི༌ འུ༌སྐྱོང༌གུན༌, སྤོན༌བོ༌གུན༌, ཁྲིམ༌སྤོན༌གུན༌ དང༌ མག༌གི༌ སྤོན༌བོ༌གུན༌ལ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཛོམ༌ཅེས༌ལ༌ ཟེརས༌ ཡང༌ ཁོང༌གུན༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ མི༌ ཚང༌མ༌ལ༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ མོལས༌, ‘ཏུས༌ མང༌པོའེ༌ སྔུན༌ལ༌ ཨབ༌ར༌ཧམ༌ དང༌ ན༌ཧོར༌རི༌ ཨ༌བ༌ ཏི༌རཧ༌ ཐེས༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཡུཕ༌རེ༌ཀྲས༌སི༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ དུག༌གད༌པིན༌ ཡང༌ ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཅོལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","ཨིན༌ནའང༌ ངའེ༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌ ཨབ༌ར༌ཧམ༌ ཡུཕ༌རེ༌ཀྲས༌སི༌ ཤར༌ ཆོགས༌ནེ༌ ཀེ༌ནན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཁྱོངས༌པིན༌། ངའེ༌ ཁོའ༌, ཁོའེ༌ བུ༌ཚ༌ ཨི༌སཱག༌ གྱུད༌ཏེ༌ པུར༌གྱུད༌ མང༌པོ༌ ཏངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","ངའེ༌ ཨི༌སཱག༌ག༌ ཡ༌ཀོབ༌ དང༌ ཨི༌སུ༌ བུ༌ཚ༌གུན༌ ཏངས༌པིན༌། ངའེ༌ ཨི༌སུའ༌ སེ༌འིར༌རི༌ རི༌ཡུལ༌ ཏངས༌པིན༌ ཨིན༌ནའང༌ ཡ༌ཀོབ༌ དང༌ ཁོའེ༌ ཕྲུ༌གུ༌ གུན༌ ཐུར༌ལ༌ ཨི༌ཇིབ༌བ༌ སོང༌།’” ");
INSERT INTO lbj_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“‘ཏེ༌ནེ༌ ངའེ༌ མོ༌ཟེས༌ དང༌ ཨ༌རོན༌ ལམ༌ཅུགས༌པིན༌ ཡང༌ ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ རྡུག༌ངལ༌ སྲན༌ཏྲེ༌ སྟན༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ ཏེ༌ནང༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཚོ༌ མར༌པོའེ༌ཀ༌ ལེབ༌བ༌ཅིག༌ ཨི༌ཇིབ༌པ༌གུན༌ནི༌ རྟ༌ དང༌ ཤིང༌རྟ༌ སྲུལ༌ཁན༌ མག༌མི༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཏེ༌རུ༌ ཏེད༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝའ༌ རོགས༌ ཛད༌ཅེས༌ལ༌ ཞུས༌ ཡང༌ ངའེ༌ ཨིས༌ར༌ཨེལ༌པ༌ དང༌ ཨི༌ཇིབ༌པ༌ གུན༌ནི༌ པར༌ལ༌ མུན༌གྲིག༌ ཅོས༌པིན༌། ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ ཚོའེ༌ ཆུ༌ ཉམ༌པོ༌ ཀབས༌པིན༌། ངའེ༌ ཨི༌ཇིབ༌པ༌གུན༌ལ༌ ཅོ༌ཁན༌བོ༌ ཁྱོ༌ཞའེ༌ མིག༌ནེ༌ ཐོང༌ཏེ༌ ཨིན༌ནོག༌། ཏེ༌སྟིང༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ལོ༌ མང༌པོ༌ དུགས༌ཏེ༌ ཨིན༌པིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“‘ཏེ༌ནེ༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ ཨ༌མོར༌པ༌གུན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཁྱོངས༌པིན༌། ཁོང༌གུན༌ནི༌ ཁྱོ༌ཞའེ༌ གྱབ༌གལ༌ལ༌ ནོལས༌ ཨིན༌ནའང༌ ངའེ༌ ཁོང༌གུན༌ ཁྱོ༌ཞའེ༌ དུན༌ལ༌ མེད༌ཁན༌ ཅོས༌པིན༌ ཡང༌ ཁྱོ༌ཞའེ༌ ཁོང༌གུན༌ནི༌ ས༌ཀྱད༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","ཏེ༌ནེ༌ ཟིཔ༌པོར༌རི༌ བུ༌ཚ༌, མོ༌འབ༌བི༌ གྱལ༌པོ༌ བ༌ལག༌གི༌ ཨིས༌ར༌ཨེལ༌པའེ༌ གྱབ༌གལ༌ལ༌ མག༌ ཏང༌ཅེས༌ གྲལ༌གྲིག༌ ཅོས༌། ཁོའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ངན༌ ཏབ༌ཅེས༌སི༌ ཕིའ༌ བེ༌འོར༌རི༌ བུ༌ཚ༌ བ༌ལའམ༌ བོད༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","ཨིན༌ནའང༌ ངའེ༌ བ༌ལའམ༌མི༌ ཞུ༌ཝ༌ མ༌ཉན༌པིན༌ མ༌ཚད༌ ངའེ༌ ཁོའ༌ ཁྱོ༌ཞའ༌ ཅིན༌ལབས༌ ཏང༌ ཅུགས༌པིན༌ ཡང༌ ཏེན༌ན༌ ཟུག༌གི༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ བ༌ལག༌ནེ༌ ཐར༌ཅུགས༌པིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“‘ཏེ༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཡེ༌རི༌ཀོའ༌ ལེབ༌བ༌ཅིག༌ ཡེ༌རི༌ཀོའེ༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ནི༌ ཁྱོ༌ཞའེ༌ གྱབ༌གལ༌ལ༌ ནོལས༌། ཨ༌མོར༌པ༌, པེ༌རིཟ༌པ༌, ཀེ༌ནན༌པ༌, ཧེད༌པ༌, གིར༌གཤ༌པ༌, ཧིཝ༌པ༌ དང༌ ཡེ༌བས༌པ༌ གུན༌ནིའང༌ ཏེན༌ན༌ ཙོགས༌ ཅོས༌ ཨིན༌ནའང༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཁོང༌གུན༌ནི༌ ཀ༌ནེ༌ གྱལ༌ཁ༌ ཏངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","ཡང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སང༌ སྔུན༌ལ༌ ཇིགས༌ནང༌ ཀལ༌ཏེ༌ ངའེ༌ ཨ༌མོར༌པའེ༌ གྱལ༌པོ༌ ཉིས༌ཀོ༌ ཕིངས༌ཏེ༌ ཏངས༌པིན༌། ཁྱོ༌ཞའེ༌ ར༌འི༌ དང༌ ཞུ༌ གུན༌ གྱུད༌ཏེ༌ ཁྱོ༌ཞའ༌ གྱལ༌ཁ༌ ཐོབས༌ཏེ༌ མན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","ཁྱོ༌ཞའེ༌ མ༌བད༌ཁན༌ནི༌ ས༌ཀྱད༌ ཡང༌ ཁྱོ༌ཞའེ༌ མ༌ རྩིག༌ཁན༌ནི༌ གྱལ༌ས༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཏངས༌པིན༌ ཡང༌ ཏེ༌རུ༌ ཁྱོ༌ཞའ༌ དུགས༌ཏེ༌ ཁྱོ༌ཞའེ༌ མ༌བད༌ཁན༌ནི༌ རྒུན༌ཚས༌ དང༌ ཨོ༌ལིཝ༌ཝི༌ ཚས༌ གུན༌ནེ༌ ཟོས༌།’” ");
INSERT INTO lbj_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཏ༌ ཡ༌ཝའེ༌ ཇིགས༌སི༌ ནང༌ང༌ ཨིད༌ཤེས༌ ཉམ༌པོ༌ ཁོང༌ང༌ སྙིང༌ནེ༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུས༌། ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཨི༌ཇིབ༌ ཡང༌ ཡུཕ༌རེ༌ཀྲས༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ དུག༌ ཟ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཅོལ༌ཁན༌ནི༌ སྐུན༌དྲ༌གུན༌ ཕངས༌ཏེ༌ ཡ༌ཝའ༌ ཅིག༌པོའ༌ ཞབས༌ཏོག༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ཁྱོ༌ཞའེ༌ ཡ༌ཝའ༌ ཞབས༌ཏོག༌ མི༌ཞུ༌ སམ༌ན༌ ཏེ༌ནེ༌ དི༌རིང༌རང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སུའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེན༌ ཏེ༌བོ༌ ལྡོམ༌, ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ ཡུཕ༌རེ༌ཀྲས༌སི༌ ཤར༌ ཆོགས༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ ལྷ༌ལྷ༌མོ༌ གུན༌ ཡ༌ ཨ༌མོར༌པ༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ གུན༌, ཀ༌གུན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ དག༌ས༌ ཁྱོ༌ཞ༌གུན༌ དུག༌ཨིན༌ ཨིན༌ནོག༌། ཨིན༌ནའང༌ ང༌ དང༌ ངའེ༌ ནང༌ཚངས༌གུན༌ནི༌ ཡ༌ཝའ༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","མི༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའེ༌ ཡ༌ཝ༌ སྤངས༌ཏེ༌ ཞན༌མའེ༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཞབས༌ཏོག༌ མན༌ནེ༌ མི༌ཞུ༌, ");
INSERT INTO lbj_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ ང༌དང༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ ང༌དང༌ དང༌ ང༌དང༌ངི༌ ཕ༌མེས༌པོ༌གུན༌ ཨི༌ཇིབ༌བི༌ ཚེ༌ཡོག༌ནེ༌ ཐར༌ ཅུག༌ག༌ ཛད༌ཏེ༌ ཧ༌ལས༌ཤེས༌སི༌ སྟགས༌གུན༌ ང༌དང༌གུན༌ནི༌ མིག༌གི༌ དུན༌ལ༌ སྟན༌ན༌ ཛདས༌། ཁོང༌ངི༌ ང༌དང༌གུན༌ བེས༌ གང༌པོའེ༌ ནང༌ང༌ ཡང༌ གྱལ༌ཁམས༌ ཚང༌མ༌ གྱུད༌ཏེ༌ ཆ༌ ཟ༌ནེ༌ སྐྱོབས༌ཏེ༌ བོར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","ཡ༌ཝའེ༌ ཨ༌མོར༌པ༌གུན༌ ཐེས༌ཏེ༌ འི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ དུག༌ཁན༌ ཞན༌ གྱལ༌ཁམས༌སི༌ མི༌གུན༌ ཕིང༌ང༌ ཛདས༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ ང༌ཞ༌གུན༌ནིའང༌ ཡ༌ཝ༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ ཅིག༌པོ༌ ང༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཞུགས༌ཏེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཡ༌ཝའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌ ལ༌མོ༌ཞིག༌ མ༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ ཏམ༌པ༌ དང༌ ཚིག༌རི༌ཅན༌ དཀོན༌མཆོག༌ ཞུགས༌ཏེ༌ ཨིན༌ནོག༌། ཁྱོ༌ཞའེ༌ ཁོང༌ང༌ གྱབ༌གལ༌ ཡང༌ སྡིག༌པ༌ ཅོ༌ན༌ ཁོང༌ངི༌ ཤགས༌པ༌ སལ༌ལ༌ མི༌ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","ཁོང༌ངི༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ཆག༌ལས༌ ཟང༌པོ༌ ཛད༌ཏེ༌ ཨིན༌ནའང༌, ཀལ༌ཏེས༌ ཁྱོ༌ཞའེ༌ ཡ༌ཝའ༌ ཕངས༌ཏེ༌ ཞན༌ མི༌གུན༌ནི༌ ཅོལ༌ཁན༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌ན༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གྱབ༌གལ༌ ཛད༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ མེད༌ཁན༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","ཨིན༌ནའང༌ མི༌གུན༌ནི༌ ཡོ༌ཤུའ༌ ལན༌ཏངས༌, “མན༌ ང༌ཞ༌གུན༌ནི༌ ཡ༌ཝ༌ ཅིག༌པོའ༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ ཡ༌ཝའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌སི༌ ཐག༌ཅད༌ཁན༌ནི༌ སྤང༌པོ༌ ཁྱོ༌ཞ༌རང༌ ཨིན༌ནོག༌།” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “འོ༌ན༌, ཏེ༌བོའེ༌ སྤང༌པོ༌ ང༌ཞ༌རང༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","ཡོ༌ཤུའེ༌ ཟེརས༌, “ཏེ༌ནེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕྲོའ༌ ཡོད༌ཁན༌ནི༌ སྐུན༌དྲ༌གུན༌ ཕངས༌ཏེ༌ མེད༌ཁན༌ ཅོས༌ ཡང༌ ཁྱོ༌ཞའེ༌ སྙིང༌གུན༌ ཡ༌ཝ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཆོགས༌ལ༌ སྟན༌པོ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","མི༌གུན༌ནི༌ ཡོ༌ཤུའ༌ ཟེརས༌, “ང༌ཞ༌གུན༌ནི༌ ཡ༌ཝའ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ག༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌ ཡང༌ ཁོང༌ ཅིག༌པོའེ༌ ཁའ༌ ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ ཏེན༌ན༌ ཞག༌ག༌ ཤེ༌ཀེམ༌མི༌ ནང༌ང༌ མི༌གུན༌ དང༌ ཡ༌ཝའེ༌ པར༌ལ༌ ཆད༌དོན༌ ཅོས༌། ཡོ༌ཤུའེ༌ ཁོང༌གུན༌ནི༌ ཕིའ༌ ཏེ༌ ཁྲིམས༌ དང༌ བཀའ༌ཁྲིམས༌ ཚང༌མ༌ བྲིས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","ཡོ༌ཤུའེ༌ འི༌ ཚང༌མ༌ ཁྲིམས༌སི༌ སྤེ༌ཆའེ༌ ནང༌ང༌ བྲིས༌། ཁོང༌ངི༌ རྡོའ༌ ཆེན༌མོ༌ ཞིག༌ ཡ༌ཝའེ༌ ཏམ༌པ༌ ཀུར༌རི༌ དུན༌ལ༌ ཡོད༌ཁན༌ ཨོག༌གི༌ ལྕང༌མ༌ ཆེན༌མོའེ༌ ཡོག༌ག༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","ཡང༌ ཁོང༌ངི༌ མི༌ ཚང༌མའ༌ ཟེརས༌, “འི༌ རྡོའ༌བོའེ༌ ཡ༌ཝའེ༌ ང༌དང༌གུན༌ལ༌ མོལ༌ཁན༌ ཚང༌མ༌ ཚོར༌ཏེ༌ ཨིན༌ནོག༌། ཀལ༌ཏེས༌ ཁྱོ༌ཞ༌གུན༌ ཡ༌ཝའ༌ ཅོ༌ཁན༌ནི༌ ཁ༌ཆད༌གུན༌ནི༌ ནང༌ང༌ ཨིད༌ཤེས༌ཅན༌ མ༌ལུས༌ན༌ འི༌བོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ སྤང༌པོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","ཏེ༌ནེ༌ ཡོ༌ཤུའེ༌ མི༌ ཚང༌མ༌ ལོགས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌གུན༌ལ༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","ཏེ༌བོའེ༌ སྟིང༌ནེ༌ ཡ༌ཝའ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ ནུན༌ནི༌ བུ༌ཚ༌ ཡོ༌ཤུའ༌ ཀྲོངས༌, ཁོང༌ང༌ ལོ༌ 110 ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡོ༌ཤུའ༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌, གའཤ༌ཤི༌ རི༌ བྱང༌ ཆོགས༌ལ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ ཏིམ༌ནཐ༌ སེ༌རཧའེ༌ ནང༌ང༌ ཁོང༌ངི༌ སྤུར༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡོ༌ཤུའེ༌ མི༌ཚེའེ༌ གང༌པོ༌ ཡང༌ ཁོང༌ངི༌ སྟིང༌ནེ༌ ཞན༌ འུ༌སྐྱོང༌གུན༌ནི༌ ཏུས༌ལ༌ ཡ༌ཝའ༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུས༌། ཏེ༌ འུ༌སྐྱོང༌གུན༌ལ༌ ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ཛད༌ཁན༌ ཚང༌མའེ༌ ཐོང༌ངོམས༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཨི༌ཇིབ༌ནེ༌ ཁྱོངས༌ཁན༌ནི༌ ཡོ༌སེབ༌བི༌ རུས༌པ༌ ཤེ༌ཀེམ༌མི༌ ནང༌ང༌ སུབས༌, ཏེ༌བོ༌ ཡ༌ཀོབ༌བི༌ ཧ༌མོར༌རི༌ བུ༌ཚ༌གུན༌ནི༌ ཀ༌ནེ༌ མུལ༌ལི༌ པེ༌ནེ༌ གྱ༌ ཏངས༌ཏེ༌ ཉོས༌ཏེ༌ ཨིན༌པིན༌། ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌གུན༌ལ༌ ནོར༌སྐལ༌ལ༌ ཏང༌ཁན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཏེ༌ ས༌ཀྱད༌པོ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","ཨ༌རོན༌ནི༌ བུ༌ཚ༌ ཨེ༌ལི༌འ༌ཟར༌རའང༌ ཀྲོངས༌། ཁོང༌ངི༌ སྤུར༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ སུབས༌ ཀ༌བོ༌ ཁོའེ༌ བུ༌ཚ༌ ཕི༌ནི༌ཧས༌ལ༌ ཏང༌ཁན༌ གི༌བེའཧའེ༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","ཡོ༌ཤུའ༌ ཀྲོངས༌ཏེ༌ སྟིང༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའ༌ ཏྲིའ༌ ཛདས༌, “ཀེ༌ནན༌པ༌གུན༌ལ༌ སྤུང༌གོལ༌ ཅོའ༌ལ༌ གོ༌མ༌ ཀ༌ སྡེའེ༌ མི༌གུན༌ ཆ༌ལེ༌?” ");
INSERT INTO lbj_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","ཡ༌ཝའེ༌ ལན༌ སལས༌, “ཡ༌ཧུ༌དཱའེ༌ མི༌སྡེ༌ ཆ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁོང༌གུན༌ནི༌ ལག༌ག༌ ཏེ༌ ས༌ཀྱད༌པོ༌ ཏངས༌ཏེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","ཏེ༌ནེ༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ནི༌ ཁོང༌ངི༌ སྤུན༌ལ༌ སི༌མི༌འོན༌པ༌གུན༌ལ༌ ཟེརས༌, “ང༌ཞའ༌ སལ༌ཁན༌ནི༌ ས༌ཀྱད༌ ཀེན༌ལ༌ ཡོངས༌ཏེ༌ ཀེ༌ནན༌པ༌གུན༌ལ༌ ནོལ༌ཅེས༌ལ༌ ང༌ཞའ༌ རོགས༌ ཅོས༌, ཏེ༌ནེ༌ ང༌ཞེའང༌ ཁྱོ༌ཞའ༌ ཏེན༌ན༌ ཙོགས༌ལ༌ རོགས༌ ཅོ༌ཨིན༌།” ཏེ༌བོའེ༌ཕིའ༌ སི༌མི༌འོན༌པ༌གུན༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ལ༌ རོགས༌ ཅོའ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","ཡ༌ཧུ༌དཱ༌པ༌གུན༌ནི༌ སྤུང༌གོལ༌ ཅོའ༌ཅིག༌ ཡ༌ཝའེ༌ ཀེ༌ནན༌པ༌གུན༌ དང༌ པེ༌རིཟ༌པ༌གུན༌ ཁོང༌གུན༌ནི༌ ལག༌ག༌ སལས༌ ཡང༌ ཁོང༌གུན༌ནི༌ བེ༌ཟེག༌གི༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ གྲ༌འོ༌ 10,000 སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","བེ༌ཟེག༌གི༌ ནང༌ང༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ལ༌ གྱལ༌པོ༌ ཨ༌དོ༌ནི༌ བེ༌ཟེག༌ ཐོང༌ ཡང༌ ཁོ༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ལ༌ ནོལ༌ཏེ༌ ཀེ༌ནན༌པ༌ དང༌ པེ༌རིཟ༌པ༌ གུན༌ལ༌ ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","གྱལ༌པོ༌ ཨ༌དོ༌ནི༌ བེ༌ཟེག༌ ཤོར༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཁོའ༌ ཏེད༌ཏེ༌ ཁྱེར༌ཏེ༌ ཟུམས༌ ཡང༌ ཁོའེ༌ ལག༌པ༌ དང༌ རྐང༌པའེ༌ ཐེ༌བོ༌གུན༌ ཅདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","ཨ༌དོ༌ནི༌ བེ༌ཟེག༌གི༌ ཟེརས༌, “ཏུས༌ཤིག༌ག༌ ངའེ༌ གྱལ༌པོ༌ 70 ལག༌པ༌ དང༌ རྐང༌པའེ༌ ཐེ༌བོ༌གུན༌ ཅད༌པིན༌ ཡང༌ ངའེ༌ ཅོག༌ཙེའེ༌ ཡོག༌ག༌ བུད༌ཁན༌གུན༌ ཁོང༌གུན༌ནི༌ ཟའད༌པིན༌། ཏ༌ དཀོན༌མཆོག༌གི༌ ངའེ༌ ཅོ༌ཁན༌བོའ༌ ལན༌སལ༌ཏེ༌ ཨིན༌ནོག༌།” ཡ༌ཧུ༌དཱ༌པ༌གུན༌ནི༌ ཁོ༌ ཡེ༌རུ༌ཤ༌ལེམ༌མ༌ ཁྲིད༌ཏེ༌ ཁྱེརས༌ ཡང༌ ཁོ༌ ཏེ༌རུ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","ཡ༌ཧུ༌དཱ༌པ༌གུན༌ནི༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ཀའང༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ཏེ༌ ནང༌ང༌ དུག༌ཁན༌ མི༌ཚང༌མ༌ སདས༌ ཡང༌ གྱལ༌སའ༌ མེ༌ ཏུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","ཏེ༌ སྟིང༌ནེ༌ ཁོང༌གུན༌ ཐུར༌ལ༌ རི༌ ཡུལ༌, ནེ༌གེཝ༌ དང༌ ནུབ༌ ཆོགས༌སི༌ ཕལ༌ཅན༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ དུག༌ཁན༌ ཀེ༌ནན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","ཏེ༌ནེ༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ ཧེབ༌རོན༌ནི༌ ༼ཀ༌བོའ༌ ཀི༌རི༌འཐ༌ ཨར༌བ༌ ཟེར༌རད༌པིན༌༽ ཀེ༌ནན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌ཏེ༌ ཤེ༌ཤཱའི༌, ཨ༌ཧི༌མན༌ དང༌ ཏལ༌མཱའི༌ པུར༌གྱུད༌གུན༌ལ༌ ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","ཏེ༌ཀ༌ནེ༌ ཁོང༌གུན༌ དེ༌བིར༌རི༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌ ༼ཀ༌བོའ༌ ཀི༌རི༌འཐ༌ སེ༌ཕེར༌ ཟེར༌རད༌པིན༌༽། ");
INSERT INTO lbj_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","ཀེ༌ལེབ༌བི༌ ཟེརས༌, “ཀི༌རི༌འཐ༌ སེ༌ཕེར༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ང༌ཡོག༌ག༌ ཁྱོང༌ཁན༌ནི༌ མི༌བོའ༌ ངའེ༌ ང༌རང༌ངི༌ བུ༌མོ༌ ཨཀ༌སཧ༌ ན༌མ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","ཀེ༌ལེབ༌བི༌ ནོ༌ ཀི༌ནཟ༌སི༌ བུ༌ཚ༌ ཨོཐ༌ནི༌འེལ༌ལི༌ ཏེ༌ ཡུལ༌བོ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ཏེ༌བོའེ༌ཕིའ༌ ཀེ༌ལེབ༌བི༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌ ཨཀ༌སཧ༌ ཁོའ༌ ན༌མ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","ན༌མ༌ ཅོས༌ཏེ༌ སྟིང༌ནེ༌ ཨོཐ༌ནི༌འེལ༌ལི༌ ཨཀ༌སཧ༌ ཁོའེ༌ ཨ༌བ༌ ཀེ༌ལེབ༌བ༌ ཞིང༌ ཏོང༌ ཟེར༌ ཅུགས༌། ཏེ༌ནེ༌ ཨཀ༌སཧ༌ ཁོ༌རང༌ངི༌ ཨ༌བའ༌ སྤེ༌ར༌ ཏང༌ང༌ སོང༌ ཡང༌ ཁོ༌ བུང༌བུའི༌ ཀ༌ནེ༌ བབ༌བ༌ཅིག༌ ཀེ༌ལེབ༌བི༌ ཏྲིས༌, “ངའེ༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ ཅི༌ ཅོ༌?” ");
INSERT INTO lbj_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","ཁོའེ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ནེ༌གེཝ༌ཝི༌ ས༌ཀྱད༌ ངའ༌ ཏངས༌ཏེ༌ ཨིན༌ནོག༌ ཏ༌ ཇུ༌ཇུ༌ ངའ༌ ཆུ༌མིག༌གི༌ ཆུའང༌ སལ༌ ལེ༌།” ཏེ༌ནེ༌ ཀེ༌ལེབ༌བི༌ ཁོའ༌ སྟག༌ཡོག༌ ཉིས༌ཀའེ༌ ཆུ༌མིག༌གུན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","ཡ༌ཧུ༌དཱ༌པ༌གུན༌ དང༌ མོ༌ཟེས༌སི༌ ན༌མའེ༌ ཨ༌བའེ༌ པུར༌གྱུད༌ ཀེན༌པ༌གུན༌ ཁ༌སོར༌རི༌ ལྕང༌མའེ༌ གྱལ༌ས༌ ཡེ༌རི༌ཀོ༌ནེ༌ བིང༌ཏེ༌ ནེ༌གེཝ༌ ཐང༌སྟོང༌ངི༌ ནང༌ང༌ ཨ༌རད༌དི༌ ཉེ༌མོའ༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ནི༌ ཕྲོའ༌ དུག༌ག༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","ཏེ༌ནེ༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ སི༌མི༌འོན༌པ༌གུན༌ ཉམ༌པོ༌ ཟེ༌ཕཐ༌ལ༌ དུག༌ཁན༌ནི༌ ཀེ༌ནན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌ ཡང༌ ཏེ༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མ༌ སདས༌། ཏེ༌བོའེ༌ཕིའ༌ ཏེ༌ གྱལ༌སའེ༌ མིང༌ང༌ ཧོར༌མཧ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","ཡ༌ཧུ༌དཱ༌པ༌གུན༌ནི༌ ག༌ཟ༌, ཨཤ༌ཀེ༌ལོན༌ དང༌ ཨེཀ༌རོན༌ནི༌ གྱལ༌ས༌གུན༌ དང༌ ཏེ༌ ཉེ༌ཁོར༌རི༌ ས༌ཀྱད༌གུན༌ ནའང༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","ཡ༌ཧུ༌དཱ༌པ༌གུན༌ ཉམ༌པོ༌ ཡ༌ཝའ༌ ཞུགས༌ཏེ༌ ཡོད༌པིན༌། ཁོང༌གུན༌ནི༌ རི༌ ཡུལ༌གུན༌ ཝང༌ངི༌ ཡོག༌ག༌ ཁྱོངས༌ ཨིན༌ནའང༌ སྤང༌ཐང༌ངི༌ ནང༌ང༌ དུག༌ཁན༌ནི༌ མི༌གུན༌ ཕིང༌ཅེས༌ལ༌ ཁྲངས༌པོ༌ མ༌ལུས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ གྲ༌འོའེ༌ མག༌མི༌ ལག༌ག༌ ཚོན༌ཆ༌ གྱས༌པ༌ སྤེར༌ན༌ ལྕགས༌སི༌ རྟ༌རེལ༌གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","མོ༌ཟེས༌སི༌ ཁ༌ཆད༌ ཅོ༌ཁན༌ ནང༌ཞིན༌ ཧེབ༌རོན༌ནི༌ གྱལ༌ས༌ ཀེ༌ལེབ༌བ༌ ཏངས༌ ཡང༌ ཁོའེ༌ ཏེ༌རུ༌ དུག༌ཁན༌ ཨ༌ནཀ༌ཀི༌ བུ༌ཚ༌ སུམ༌མི༌ པུར༌གྱུད༌གུན༌ ཕིངས༌ཏེ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","བེན༌ཡཱ༌མིན༌ནི༌ མི༌སྡེའེ༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ ནང༌ང༌ དུག༌ཁན༌ ཡེ༌བས༌པ༌གུན༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌ པ༌སང༌ དི༌རིང༌ངའང༌ ཡེ༌བས༌པ༌གུན༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ ནང༌ང༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ ཉམ༌པོ༌ དུག༌ཨིན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌གུན༌ བེ༌ཐེལ༌ལི༌ གྱལ༌ས༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ སོང༌ ཡང༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ལ༌ རོགས༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","བེ༌ཐེལ༌ གྱལ༌སའེ༌ ༼ཀ༌བོའ༌ ལུཟ༌ ཟེར༌རད༌པིན༌༽ སྲུང༌སྐྱོབ༌གུན༌ ཤེད༌ཅན༌ དུག༌ག༌ ཡ༌ འུ༌ཐུགས༌, ལྟའ༌ལ༌ ཁོང༌གུན༌ནི༌ མི༌ ཁ༌ཅིག༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ལམ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","ལྟའ༌ ཆའ༌ཁན༌གུན༌ལ༌ མི༌ཞིག༌ གྱལ༌སའེ༌ ནང༌ནེ༌ བིངས༌ཏེ༌ ཡོང༌ང༌ ཐོང༌ ཡང༌ ཁོའ༌ ཟེརས༌, “གྱལ༌སའེ༌ ནང༌ང༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ཆ༌སའེ༌ ལམ༌ ང༌ཞའ༌ སྟན༌ན༌ ང༌ཞའེ༌ ཁྱོ༌རང༌ངི༌ སྲོག༌ སྐྱོབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","ཏེ༌ནེ༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ གྱལ༌སའེ༌ ནང༌ཀུག༌ག༌ ཆ༌སའེ༌ ལམ༌ སྟནས༌ ཡང༌ ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌གུན༌ནི༌ ཁོ༌ དང༌ ཁོའེ༌ ནང༌ཚང༌གུན༌ མ༌སྟོག༌ ཏེ༌ གྱལ༌སའེ༌ ཞན༌ མི༌ ཚང༌མ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","སྟིང༌ནེ༌ ཏེ༌ མི༌བོ༌ བིང༌ཏེ༌ ཧེད༌པ༌གུན༌ནི༌ ས༌ཀྱད༌ལ༌ དུག༌ག༌ སོང༌ ཡང༌ ཏེ༌རུ༌ ཁོའེ༌ གྱལ༌ས༌ ཞིག༌ རྩིགས༌ཏེ༌ ཏེ༌བོའེ༌ མིང༌ང༌ ལུཟ༌ ཏགས༌ ཀ༌བོ༌ དི༌རིང༌ངའང༌ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","བེཐ༌ ཤན༌, ཏའ༌ནག༌, དོར༌, ཨིབ༌ལེ༌འམ༌, མེ༌གིད༌དོ༌ གྱལ༌ས༌གུན༌ ཡང༌ ཏེ༌གུན༌ནི༌ ཉེ༌ཁོར༌ལ༌ ཚུགས༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མ༌ མ༌ནས༌སའེ༌ མི༌སྡེ༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌ ཅིའ༌ཟེར༌ན༌ ཀེ༌ནན༌པ༌གུན༌ བིང༌ཏེ༌ མ༌ཆའ༌ ཏེན༌ན༌ ནས༌སའེ༌ ནང༌ང༌ རངས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཀྲངས༌ཀ༌ གྱས༌ཏེ༌ སྟོབས༌ཅན༌ གྱུར༌ནའང༌ ཁོང༌གུན༌ནི༌ ཀེ༌ནན༌པ༌ ཚང༌མ༌ ཕིངས༌ཏེ༌ མ༌ཏང༌ང༌ ཁོང༌གུན༌ལ༌ ཝང༌ ཉམ༌པོ༌ ཚེ༌ ཡོག༌གི༌ ལས༌ ཅོ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","ཨེཕ༌ར༌ཡིམ༌ མི༌སྡེའེ༌ གེ༌ཟེར༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཀེ༌ནན༌པ༌གུན༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌ ཏེ༌བོའེ༌ཕིའ༌ ཏེ༌རུ༌ ཀེ༌ནན༌པ༌གུན༌ ཁོང༌གུན༌ནི༌ ཕྲོའ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","ཟེ༌བུ༌ལོན༌ མི༌སྡེའེ༌ ཀི༌ཀྲོན༌ དང༌ ན༌ཧ༌ལོལ༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌ པ༌སང༌ ཀེ༌ནན༌པ༌གུན༌ ཁོང༌གུན༌ནི༌ ཕྲོའ༌ དུག༌ཨིན༌ ཨིན༌ནོག༌། ཟེ༌བུ༌ལོན༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཝང༌ ཉམ༌པོ༌ ཚེ༌ ཡོག༌གི༌ ལས༌ ཅོ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","ཨཀ༌ཀོ༌, སི༌དོན༌, ཨཧ༌ལབ༌, ཨཀ༌ཟིབ༌, ཧེལ༌བཧ༌, ཨ༌ཕེཀ༌ དང༌ རེ༌ཧོབ༌ གྱལ༌ས༌གུན༌ནི༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ ཨ༌ཤེར༌ མི༌སྡེ༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌ ");
INSERT INTO lbj_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","མ༌ཚད༌ ཨ༌ཤེར༌པ༌གུན༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ཝང༌སྲུལ༌ཁན༌ ཀེ༌ནན༌པ༌གུན༌ནི༌ ཕྲོའ༌ སོང༌ཏེ༌ དུགས༌། ཨ༌ཤེར༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","ཏེན༌ན༌ ཙོགས༌ལ༌ ནཕ༌ཐལ༌ལི༌ མི༌སྡེའེ༌ བེཐ༌ ཤེ༌མེཤ༌ ཡ༌ བེཐ༌ ཨ༌ནཐ༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌ མ༌ཚད༌ ཏེ༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཝང༌སྲུལ༌ཁན༌ ཀེ༌ནན༌པ༌གུན༌ནི༌ ཕྲོའ༌ སོང༌ཏེ༌ དུགས༌། ནཕ༌ཐལ༌ལི༌པ༌གུན༌ནི༌ བེཐ༌ ཤེ༌མེཤ༌ ཡ༌ བེཐ༌ ཨ༌ནཐ༌ཐི༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ལ༌ ཝང༌ ཉམ༌པོ༌ ཚེ༌ཡོག༌གི༌ ལས༌ ཅོ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","ཨ༌མོར༌པ༌གུན༌ནི༌ དཱན༌པ༌གུན༌ ཐང༌ངི༌ ནང༌ང༌ དུག༌ མ༌ཅུག༌ག༌ ཝང༌ ཉམ༌པོ༌ རི༌ཡུལ༌ ཆོགས༌ལ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","ཨ༌མོར༌པ༌གུན༌ བིང༌ཏེ༌ མ༌ཆའ༌ ཧེ༌རེས༌སི༌ རི༌, ཨའི༌ཡ༌ལོན༌ དང༌ ཤའལ༌བིམ༌ གུན༌ནི༌ ནང༌ང༌ རངས༌ཏེ༌ དུགས༌ ཨིན༌ནའང༌ ཡོ༌སེབ༌བི༌ པུར༌གྱུད༌གུན༌ནི༌ ཀྲངས༌ཀ༌ གྱས༌ཏེ༌ ཤེད༌ཅན༌ གྱུར༌ར༌ཅིག༌ ཁོང༌གུན༌ནི༌ ཨ༌མོར༌པ༌གུན༌ལ༌ ཝང༌ ཉམ༌པོ༌ ཚེ༌ཡོག༌གི༌ ལས༌ ཅོ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","ཨ༌མོར༌པའེ༌ སན༌ཚམས༌ སྡིག༌པ༌རཱ༌ཙེ༌ ལ༌ནེ༌ ཏངས༌ཏེ༌ སེ༌ལ༌ ཡང༌ ཏེ༌སང༌ ཀེན༌ ཚག༌པ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","ཡ༌ཝའེ༌ ཕོ༌ཉ༌ གིལ༌གལ༌ནེ༌ ཀེན༌ལ༌ བོ༌ཀིམ༌མ༌ སྐྱོད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ མོལས༌, “ངའེ༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཏང༌ཅེས༌ལ༌ ནའ༌ ཁུར༌ཁན༌ནི༌ འི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཁྱོ༌ཞ༌གུན༌ ཁྱོངས༌པིན༌། ངའེ༌ ཟེར༌པིན༌, ‘ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཉམ༌པོ༌ ཅོ༌ཁན༌ནི༌ ང༌རང༌ངི༌ ཆད༌དོན༌ མ༌ནེ༌ མི༌ཅག༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","ཁྱོ༌ཞ༌གུན༌ནི༌ འི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ ཉམ༌པོ༌ ཆད༌དོན༌ མ༌ཅོ༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཆོད༌ཁྲི༌གུན༌ ཤིག༌གོས༌།’ ཨིན༌ནའང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ ཁའ༌ མ༌ཉན༌ན༌ ཅི༌ ཅོས༌ཏེ༌ ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","ངའེ༌ འི༌བོའང༌ ཟེར༌པིན༌, འི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ ངའེ༌ ཕིངས༌ཏེ༌ མི༌ཏང༌། ཁོང༌གུན༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕྲོའ༌ ཚེར༌མངས༌ ཙོགས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ ཅོལ༌ཅེས༌པོ༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ཚོད༌ལྟ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཏེ༌གུན༌ མོལ༌ ཚར༌ར༌ཅིག༌, མི༌གུན༌ ཤེད༌ནང༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","ཁོང༌གུན༌ནི༌ ཏེ༌ ས༌ཀྱད༌པོའ༌ བོ༌ཀིམ༌ མིང༌ ཏགས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཏེ༌རུ༌ ཡ༌ཝའ༌ ཆོད༌པ༌གུན༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","ཡོ༌ཤུའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ལོགས༌ཏེ༌ ལམ༌ཅུག༌གི༌ ཏུས༌ལ༌ མི༌སྡེ༌ རེ༌རེ༌ ཁོ༌རང༌གུན༌ལ༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","ཡོ༌ཤུའེ༌ མི༌ཚེ༌ ཏང༌ ཁོང༌ངི༌ སྟིང༌ནེ༌ སོན༌ཏེའ༌ ལུས༌ཁན༌ འུ༌སྐྱོང༌གུན༌ནི༌ ཏུས༌ གང༌པོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའ༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུས༌། ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ཧ༌ལས༌ཤེས༌སི༌ ཛད༌པ༌ ཛད༌ཁན༌གུན༌ ཏེ༌ འུ༌སྐྱོང༌ ཚང༌མའེ༌ ཐོང༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","ཡ༌ཝའ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ ནུན༌ནི༌ བུ༌ཚ༌ ཡོ༌ཤུའ༌ ཤི༌ ཟ༌ནེ༌ ལོ༌ 110 ཆའད༌པིན༌ ། ");
INSERT INTO lbj_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","ཁོང༌གུན༌ནི༌ ཡོ༌ཤུའེ༌ སྤུར༌ ཁོའ༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཁན༌ ཏིམ༌ནཐ༌ ཧེ༌རེས༌སི༌ ནང༌ང༌ སུབས༌། ཏེ༌ ནས༌ས༌བོ༌ གའཤ༌ རི༌ བྱང༌ ཆོགས༌ལ༌ ཨེཕ༌ར༌ཡིམ༌པའེ༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","ཏེ༌ མི༌རབས༌པོ༌ ཤི༌ཏེ༌ མི༌རབས༌ སོ༌མ༌ཞིག༌ ལྡནས༌། ཁོང༌གུན༌ལ༌ ཡ༌ཝ༌ ཡ༌ ཁོང༌ངི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ཛད༌ཁན༌གུན༌ གྱུས༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཅོས༌ ཡང༌ བའལ༌ ཟེར༌ཁན༌ནི༌ སྐུན༌དྲ༌གུན༌ལ༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཁན༌ དཀོན༌མཆོག༌ ཡ༌ཝ༌ ཁོང༌གུན༌ནི༌ ཕངས༌། ཁོང༌གུན༌ནི༌ ཉེ༌ཁོར༌ལ༌ དུག༌ཁན༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ ཅོལས༌ ཡང༌ ཞབས༌ཏོག༌ ཞུས༌ཏེ༌ ཡ༌ཝའ༌ ཐུག༌སྲོ༌ སྐྱོད༌ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝ༌ ཕངས༌ཏེ༌ བའལ༌ དང༌ ཨཤ༌ཏོ༌རེཐ༌ སྐུན༌དྲ༌གུན༌ལ༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","ཡ༌ཝའེ༌ ཐུག༌སྲོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཡོད༌ཅེས༌པོའེ༌ ཁོང༌ངི༌ ཁོང༌གུན༌ ཀོག༌ཅོམ༌ ཏང༌ཁན༌གུན༌ནི༌ ལག༌ག༌ སྟདས༌ ཀ༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ ནོར༌གུན༌ ཅོམས༌ཏེ༌ ཁྱེརས༌། ཡ༌ཝའེ༌ ཁོང༌གུན༌ ཆོགས༌ ཚང༌མ༌ནེ༌ གྲ༌འོ༌གུན༌ནི༌ ལག༌ག༌ སྟདས༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཏེ༌ སྤུང༌གོལ༌གུན༌ནེ༌ ཁོ༌རང༌གུན༌ སྐྱོབ༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","ཏུས༌གྱུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ མག༌ག༌ ཆ༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ནི༌ གྱབ༌གལ༌ ཛད༌ཏེ༌ ཁོང༌གུན༌ ཕམ༌ ཅུག༌ག༌ ཛདས༌ ཀ༌ཟུག༌ ཁོང༌ངི༌ ནའ༌ ཁུར༌ར༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ཁོང༌གུན༌ མ༌སྲན༌ཏྲེ༌ རྡུག༌ངལ༌ལི༌ ནང༌ང༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","ཏེ༌ནེ༌ ཏེ༌ སྤུང༌གོལ༌ ཅོ༌ཁན༌གུན༌ནི༌ ཀ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཐར༌ཅུག༌ཅེས༌སི༌ ཕིའ༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ སྐྱོབ༌ཁན༌ནི༌ གོ༌ཁྲིད༌ རིག༌ ལྡམ༌མ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","ཏེ༌ནེའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཏེ༌ གོ༌ཁྲིད༌གུན༌ནི༌ ཁའ༌ མ༌ཉན༌ན༌ ཡ༌ཝ༌ ཕངས༌ཏེ༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ ཅོལས༌། ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ ཡ༌ཝའེ༌ བཀའ༌ ཁའ༌ཉན༌ཏེ༌ གྲུལ༌ཁན༌ནི༌ ལམ༌མི༌ ཀ༌ནེ༌ ཁོང༌གུན༌ གྱོགས༌པ༌ གྱུར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","ཁོང༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཡ༌ཝའེ༌ སྐྱོབ༌ཁན༌ གོ༌ཁྲིད༌ ལྡམ༌མ༌ ཛད༌ཏེ༌ སྟིང༌ནེ༌ ཁོ༌ ཤི༌ཤི༌ ཚག༌པ༌ ཡ༌ཝ༌ ཁོ༌ ཉམ༌པོ༌ ཞུགས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ གྲ༌འོ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌བ༌ ཛདས༌། རྡུག༌ངལ༌ལི༌ ནན༌ཏེ༌ སྙིང༌ཤུགས༌ ཏངས༌ པ༌སང༌ ཁོང༌གུན༌ནི༌ཀ༌ ཡ༌ཝའ༌ སྙིང༌རྗེ༌ སྐྱེའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","ཨིན༌ནའང༌ སྐྱོབ༌ཁན༌ནི༌ གོ༌ཁྲིད༌ ཤིའ༌ཅིག༌ མི༌གུན༌ ཁོང༌རང༌གུན༌ནི༌ ངན༌པ༌ མི༌ཚེ༌ ནང༌ང༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ ཁོ༌རང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ སང༌ མང༌ང༌ ངན༌པ༌ ཅོས༌། ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ ཁའ༌ ཉན༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཞབས༌ཏོག༌ ཞུས༌ཏེ༌ ཅོལས༌། ཁོང༌གུན༌ སྙིང༌སྐྱོང༌པོ༌ ཡང༌ ཏེ༌ ལས༌ ངན༌པ༌གུན༌ ཕང༌ཅེས༌ལ༌ མ༌ཐད༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","ཏེ༌བོའེ༌ཕིའ༌ ཡ༌ཝ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ མ༌སྲན༌ཏྲེ༌ ཐུག༌སྲོ༌ སྐྱོད༌ཏེ༌ མོལས༌, “འི༌ མི༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ ང༌ ཉམ༌པོ༌ ཅོ༌ཁན༌ ཆད༌དོན༌བོ༌ ཅགས༌ཏེ༌ ཁའ༌ མ༌ཉན༌ པ༌སང༌, ");
INSERT INTO lbj_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","ཡོ༌ཤུའེ༌ ཤི༌ སང༌ སྔུན༌ལ༌ ང༌ཡོག༌ག༌ མ༌ཁྱོང༌ཁན༌ནི༌ གྱལ༌ཁག༌གུན༌ནི༌ ནང༌ནེ༌ མི༌གུན༌ ངའེ༌ ཕིངས༌ཏེ༌ མི༌ཏང༌། ");
INSERT INTO lbj_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ གྲུལ༌ལ༌ ཙོགས༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཡ༌ཝའེ༌ ལམ༌མི༌ཀ༌ གྲུལ༌ དུག༌ག༌ མི༌དུག༌ ཚོད༌ ལྟ༌ཅེས༌ལ༌ ངའེ༌ འི༌ མི༌གུན༌ ཀོལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","ཏེ༌བོའེ༌ཕིའ༌ ཡ༌ཝའེ༌ ཏེ༌ གྱལ༌ཁག༌གི༌ མི༌གུན༌ ཏེན༌ན༌རུ༌ བོར༌ར༌ ཛད༌། ཁོང༌ངི༌ ཏེན༌ན༌མལ༌ལ༌ ཁོང༌གུན༌ ཕིང༌ང༌ ཛད༌ཏེ༌ ཡོ༌ཤུའེ༌ ལག༌ག༌ ཏང༌ང༌ མ༌ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","ཀེ༌ནན༌ནི༌ ནང༌ང༌ མག༌གི༌ ཐོང༌ངོམས༌ མ༌ཆའ༌ཁན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཚོད༌ ལྟ༌ཅེས༌ལ༌ འི༌ གྱལ༌ཁམས༌གུན༌ ཡ༌ཝའེ༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ བོར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","མག༌གི༌ ཐོང༌ངོམས༌ མེད༌ཁན༌ ཨིས༌ར༌ཨེལ༌ལི༌ པུར༌གྱུད༌གུན༌ལ༌ མག༌གི༌ ནང༌ང༌ ནོལ༌ཅེས༌ ལབ༌ཅེས༌ལ༌ ཁོང༌ངི༌ ཏེ༌བོ༌ ཅོའ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","ཏེ༌ གྱལ༌ཁམས༌གུན༌ ཕི༌ལིས༌ཏི༌ ནང༌ང༌ ཝང༌སྲུལ༌ཁན༌ རྔ༌, ཀེ༌ནན༌པ༌ ཚང༌མ༌, སི༌དོན༌པ༌ ཚང༌མ༌ ཡང༌ བའལ༌ ཧེར༌མོན༌ རི༌ནེ༌ ལེ༌བོ༌ ཧ༌མཐ༌ ཚག༌པ༌ ལེ༌བ༌ནོན༌ རི༌གུན༌ནི༌ཀ༌ དུག༌ཁན༌ནི༌ ཧིཝ༌པ༌ ཚང༌མ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","ཏེ༌ མི༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ཚོད༌ ལྟ༌ཅེས༌ ཡང༌ན༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌གུན༌ལ༌ མོ༌ཟེས༌ གྱུད༌ཏེ༌ སལ༌ཁན༌ བཀའ༌གུན༌ལ༌ ཁའ༌ ཉན༌དུག༌ག༌ མི༌དུག༌ ལྟ༌ཅེས༌ལ༌ བོར༌ར༌ ཛད༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཀེ༌ནན༌པ༌, ཧེད༌པ༌, ཨ༌མོར༌པ༌, པེ༌རིཟ༌པ༌, ཧིཝ༌པ༌, དང༌ ཡེ༌བས༌པ༌ གུན༌ནི༌ ཕྲོའ༌ དུགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","ཨིས༌ར༌ཨེལ༌པའེ༌ བུ༌ཚ༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌ བུ༌མོ༌གུན༌ ཁོང༌གུན༌ནི༌ བུ༌ཚ༌གུན༌ལ༌ བག༌མའ༌ ཏངས༌ མ༌ཚད༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཅོས༌། ཁོང༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝ༌ རྗེད༌ཏེ༌ བའལ༌ དང༌ ཨ༌ཤེ༌རཧའེ༌ སྐུན༌དྲ༌གུན༌ལ༌ ཅོལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","ཏེ༌ནེ༌ ཡ༌ཝའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ ཐུགས༌སྲོའེ༌ སྲན༌ཏྲེ༌ སྐྱོད༌ པ༌སང༌ ཁོང༌ངི༌ ཁོང༌གུན༌ ཨ༌རམ༌ ན༌ཧ༌རཱ༌འིམ༌མི༌ གྱལ༌པོ༌ ཀུ༌ཤན༌ རི༌ཤ༌ཐཱ༌འིམ༌མི༌ ལག༌ག༌ སྟད༌ད༌ ཛདས༌ ཡང༌ ཁོང༌གུན༌ ཏེ༌ གྱལ༌པོའེ༌ ང༌ཡོག༌ག༌ ལོ༌ རྒྱད༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ རོགས༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌པ༌ ཁོང༌ངི༌ ཀེ༌ལེབ༌བི༌ ནོ༌ ཀེ༌ནཟ༌ཟི༌ བུ༌ཚ༌ ཨོཐ༌ནི༌འེལ༌ ཐར༌ཅུག༌ཁན༌བོ༌ ལམ༌ཅུག༌ག༌ ཛད༌ཏེ༌ ཁོང༌གུན༌ སྐྱོབ༌བ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","ཡ༌ཝའེ༌ ཐུག༌ཉིད༌ ཨོཐ༌ནི༌འེལ༌ལི༌ ནང༌ང༌ སྐྱོད༌ཏེ༌ ཁོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ གྱུར༌ཏེ༌ མག༌ ཏང༌ང༌ སོང༌། ཡ༌ཝའེ༌ ཨ༌རམ༌མི༌ གྱལ༌པོ༌ ཀུ༌ཤན༌ རི༌ཤ༌ཐཱ༌འིམ༌ ཨོཐ༌ནི༌འེལ༌ལི༌ ལག༌ག༌ སལས༌ ཡང༌ ཁོའ༌ གྱལ༌ཁ༌ ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","ཏེ༌ནེ༌ ཀེ༌ནཟ༌ཟི༌ བུ༌ཚ༌ ཨོཐ༌ནི༌འེལ༌ ཤི༌ཤི༌ ཚག༌པ༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ལོ༌ 40 ཞི༌དེ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡང༌སྐྱར༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཅོས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ངན༌པ༌ ཅོ༌ཅེས༌པའེ༌ ཡ༌ཝའེ༌ མོ༌འབ༌བི༌ གྱལ༌པོ༌ ཨེག༌ལོན༌ལ༌ ཁོང༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","ཨེག༌ལོན༌ནི༌ ཨེམ༌མོན༌པ༌ དང༌ ཨ༌མ༌ལིཀ༌པ༌ གུན༌ནི༌ རོགས༌ ཉམ༌པོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ནོལ༌ཏེ༌ ཁ༌སོར༌རི༌ ལྕང༌མའེ༌ གྱལ༌ས༌ ཡང༌ན༌ ཡེ༌རི༌ཀོ༌ ང༌ཡོག༌ག༌ ལེནས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","ཡང༌ ཁོང༌གུན༌ མོ༌འབ༌བི༌ གྱལ༌པོ༌ ཨེག༌ལོན༌ནི༌ ཝང༌སྲུལ༌ལི༌ ཡོག༌ག༌ ལོ༌ 18 ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","ཡང༌སྐྱར༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའ༌ རོགས༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌པ༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ སྐྱོབ༌ཅེས༌སི༌ ཕིའ༌ བེན༌ཡཱ༌མིན༌ནི༌ སྡེ༌ནེ༌ ལག༌པ༌ ཡོ༌མ༌ ཀོལ༌ཁན༌ གེ༌རཱ༌རི༌ བུ༌ཚ༌ ཨི༌ཧུད༌ ཐར༌ཅུག༌ཁན༌བོ༌ ལྡམ༌མ༌ ཛདས༌། ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོ༌ མོ༌འབ༌བི༌ གྱལ༌པོ༌ ཨེག༌ལོན༌ནི༌ཀ༌ ཁྲལ༌ལི༌ པེ༌ནེ༌ ཀལ༌ཏེ༌ ལམ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","ཨི༌ཧུད༌དི༌ མི༌ཀྲར༌ ཕེད༌ ཟམ༌ཤིག༌ རིང༌མོ༌ ཟུར༌ ཉིས༌ཅན༌ནི༌ ར༌འི༌ ཅོས༌ཏེ༌ ཏེ༌བོ༌ ཀོས༌ལག༌གི༌ ནང༌ཀུག༌ག༌ ཁོང༌རང༌ངི༌ རྐང༌པ༌ ཡས༌པའེ༌ ཤལ༌དིག༌གི༌ཀ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","ཁོའེ༌ མོ༌འབ༌བི༌ གྱལ༌པོ༌ ཨེག༌ལོན༌ལ༌ ཁྲལ༌ལི༌ པེ༌ནེ༌ ཕུལས༌, མོ༌འབ༌བི༌ གྱལ༌པོ༌ མ༌ རོམ༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","ཁྲལ༌ལི༌ པེ༌ནེ༌ ཕུལ༌ ཚར༌ཏེ༌ སྟིང༌ནེ༌ ཨི༌ཧུད༌ དང༌ པེ༌ནེ༌ ཁུར༌ཁན༌ནི༌ ཞན༌ མི༌གུན༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","ཨིན༌ནའང༌ གིལ༌གལ༌ལི༌ ཉེ༌མོའ༌ ཡོད༌ཁན༌ རྡོའེ༌ སྐུན༌དྲའེ༌ཀ༌ ལེབ༌བ༌ཅིག༌ ཨི༌ཧུད༌ ཨེག༌ལོན༌ ཡོད༌ས༌ ཅིག༌པོ༌ ལོགས༌ཏེ༌ ཡོངས༌ ཡང༌ ཁོའ༌ ཟེརས༌, “གྱལ༌པོ༌, ངའ༌ ཉེ༌རང༌ངི༌ ཕིའ༌ སང༌ཝའེ༌ ལོན༌ཞིག༌ ཡོད༌།” གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ ཞབ༌ཤི༌གུན༌ལ༌ བཀའ༌ ཏངས༌ཏེ༌ ཟེརས༌, \"ཕི༌ལོག༌ག༌ སོང༌\" ཡང༌ ཁོང༌གུན༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","ཏེ༌ནེ༌ ཡར༌ ཏུས༌སི༌ ཁར༌རི༌ ཁེ༌ཐོག༌གི༌ ནང༌ང༌ གྱལ༌པོ༌ ཨེག༌ལོན༌ ཅིག༌པོ༌ ཡོད༌ས༌ ཨི༌ཧུད༌ ཁོའེ༌ ཉེ༌མོའ༌ སོང༌ཏེ༌ “ངའ༌ ཉེ༌རང༌ངི༌ ཕིའ༌ དཀོན༌མཆོག༌གི༌ ཆོགས༌ནེ༌ ལོན༌ཞིག༌ ཡོད༌” ཟེར༌ར༌ཅིག༌ གྱལ༌པོ༌ ཁོ༌རང༌ངི༌ ཁྲིས༌སི༌ ཀ༌ནེ༌ ལངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","ཏེན༌ན༌མལ༌ལ༌ ཨི༌ཧུད༌དི༌ ལག༌པ༌ ཡོ༌མ༌ ཉམ༌པོ༌ ཁོ༌རང༌ངི༌ རྐང༌པ༌ ཡས༌པའེ༌ ཤལ༌དིག༌གི༌ཀ༌ ཏགས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ར༌འི༌བོ༌ ཕིངས༌ཏེ༌ གྱལ༌པོའེ༌ གྲོད༌པའེ༌ ནང༌ང༌ ཙུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","ལུང༌ ཐེས༌ཏེ༌ ར༌འི༌ གང༌པོ༌ གྱལ༌པོའེ༌ ཚིལ༌ལི༌ ནང༌ང༌ ནུབ༌ཏེ༌ ར༌འི༌ གོ༌ གྱབ༌ནེ༌ བིང༌, ཨི༌ཧུད༌དི༌ ར༌འི༌ མ༌ ཕིངས༌ ཡང༌ གྱལ༌པོའེ༌ གྱུ༌མ༌ ཆད༌ཏེ༌ ཏེ༌ ནང༌ང༌ ཡོད༌ཁན༌གུན༌ ཕི༌ལོག༌ག༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","ཏེ༌ནེ༌ ཨི༌ཧུད༌དི༌ ཁེ༌ཐོག༌གི༌ ནང༌ངི༌ སྒོ༌གུན༌ སྲན༌ཏྲེ༌ ཅུགས༌ཏེ༌ ཁོ༌ ཡབས༌སི༌ ཀ༌ནེ༌ བིང༌ཏེ༌ ཤོར༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","ཨི༌ཧུད༌ ཤོར༌ཏེ༌ སྟིང༌ནེ༌ གྱལ༌པོའེ༌ ཞབ༌ཤི༌གུན༌ ཡོངས༌ ཡང༌ ཁེ༌ཐོག༌གི༌ ནང༌ངི༌ སྒོ༌གུན༌ ཅུགས༌ཁན༌བོ༌ ཐོང༌ང༌ཅིག༌ ཁོང༌གུན༌ནི༌ གྱལ༌པོ༌ དེ༌ཆོད༌དི༌ ནང༌ང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌ སམ༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","ཁོང༌གུན༌ ངལ༌ངལ༌ སྲུངས༌ཏེ༌ དུགས༌ཏེའང༌ གྱལ༌པོ༌ བིངས༌ཏེ༌ མ༌ཡོངས༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཀུ༌ལིག༌ ཁྱོངས༌ཏེ༌ སྒོ༌གུན༌ ཕེའ༌ཅིག༌ ཁོང༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ སྤོན༌བོ༌ སའེ༌ཀ༌ གྱེལ༌ཏེ༌ ཤི༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","ཞབ༌ཤི༌གུན༌ སྲུངས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཨི༌ཧུད༌ ཤོར༌ ཡང༌ རྡོའེ༌ སྐུན༌དྲ༌གུན༌ནི༌ དུན༌ནེ༌ སོང༌ཏེ༌ སེའི༌རཧ༌ ཆོགས༌ལ༌ ཤོར༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","ཨི༌ཧུད༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ སེའི༌རཧ༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ ཏུང༌ ཕུས༌ ཡང༌ གོ༌ཁྲིད༌ ཅོས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཐུར༌ལ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ ཆོགས༌ལ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","ཨི༌ཧུད༌དི༌ ཟེརས༌, “ངའེ༌ སྟིང༌རང༌ནེ༌ ཡོང༌ཤིག༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ ང༌དང༌ངི༌ གྲ༌འོ༌ མོ༌འབ༌པ༌གུན༌ ང༌དང༌ངི༌ ལག༌ག༌ སལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌།” ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ ཁོའེ༌ སྟིང༌རང༌ནེ༌ སོང༌ ཡང༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ ཉན༌སའེ༌ ནས༌ས༌ ཏེལ༌མོ༌, མོ༌འབ༌བ༌ ཆ༌སའེ༌ ལམ༌གུན༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ ཡང༌ མོ༌འབ༌པ༌ ཅིག༌གའང༌ ལྩངས༌པོ༌ གལ༌ཏེ༌ ཡོང༌ མ༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","ཏེ༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ མོ༌འབ༌པ༌ མག༌མི༌ ཀྲག༌པོ༌ དང༌ ཤེད༌ཅན༌ སྟོང༌ རྕུ༌ ཟམ༌ཤིག༌ སདས༌, སུ༌ཅིག༌གའང༌ ཤོར༌ཏེ༌ ཆ༌ མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","ཏེན༌ན༌ ཞག༌ག༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མོ༌འབ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ ཡང༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ལོ༌ 80 ཞི༌དེ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","ཨི༌ཧུད༌དི༌ སྟིང༌ནེ༌ ཨ༌ནཐ༌ཐི༌ བུ༌ཚ༌ ཤམ༌གར༌རིའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཐར༌ཅུགས༌། ཁོའེ༌ སེམས༌ཅན༌ལ༌ ལམ༌ སྟན༌ན༌ ཀོལ༌ཁན༌ནི༌ བེར༌ཀ༌ ཉམ༌པོ༌ ཕི༌ལིས༌ཏི༌པ༌ 600 སད༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","ཨི༌ཧུད༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡང༌སྐྱར༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ ཀེ༌ནན༌པ༌ ཧ༌ཟོར༌རི༌ གྱལ༌པོ༌ ཡ༌བིན༌ནི༌ ལག༌ག༌ སྟདས༌། སི༌སེ༌ར༌ ཡ༌བིན༌ནི༌ མག༌མི༌ མག༌སྤོན༌ ཨིན༌པིན༌, ཁོ༌ ཧ༌རོ༌ཤེཐ༌ ཧག༌གོ༌ཡིམ༌མི༌ ནང༌ང༌ དུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","སི༌སེ༌རའེ༌ ལག༌ག༌ ལྕགས༌སི༌ རྟ༌རེལ༌ 900 ཡོད༌པིན༌ ཡང༌ ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ ལོ༌ ཉི༌ཤུ༌ སྙིང༌རྗེ༌ མེད༌པ༌ ཝང༌སྲུལ༌པ༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ རོགས༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","ཏེ༌ཏུས༌ལ༌ ལཔ༌པི༌དོཐ༌དི༌ ན༌མ༌ དྲེབ༌རཧ༌ དཀོན༌མཆོག༌གི༌ ལོན༌ ཁྱོང༌ཁན༌ ལུང༌སྟོན༌མ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","ཁོའེ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ ར༌མཧ༌ དང༌ བེ༌ཐེལ༌ལི༌ པར༌ལ༌ ཡོད༌ཁན༌ ཁ༌སོར༌རི༌ ལྕང༌མ༌ ཀ༌བོའ༌ དྲེབ༌རཧའེ༌ ལྕང༌མའང༌ ཟེར༌རད༌པིན༌ ཏེ༌བོའེ༌ ཡོག༌ག༌ དུགས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཛིང༌མོ༌ ཏངས༌ཏེ༌ ཁོའེ༌ཀ༌ ཡོང༌ཁན༌གུན༌ལ༌ ཐག༌ཅད༌ ཏང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","ཞག༌ཤིག༌ དྲེབ༌རཧའེ༌ ནཕ༌ཐལ༌ལིའི༌ ས༌ཀྱད༌ ཀེ༌དེཤ༌ཤི༌ ནང༌ང༌ དུག༌ཁན༌ ཨ༌བི༌ནོ༌འམ༌མི༌ བུ༌ཚ༌ བ༌རག༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཁོའེ༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཁྱོ༌རང༌ང༌ བཀའ༌ སལས༌, ‘ནཕ༌ཐལ༌ལི༌ དང༌ ཟེ༌བུ༌ལོན༌ སྡེ༌ནེ༌ མག༌མི༌ སྟོང༌ རྕུ༌ ཁྲིད༌ཏེ༌ ཏྲ༌བོར༌རི༌ རི༌ཀ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","ངའེ༌ ཡ༌བིན༌ནི༌ མག༌སྤོན༌ སི༌སེ༌ར༌, རྟ༌རེལ༌ དང༌ མག༌མི༌ གུན༌ ཁྲིད༌ཏེ༌ ཀི༌ཤོན༌ནི༌ ལྩངས༌པོའེ༌ཀ༌ ཡོང༌ཅུག༌ཨིན༌ ཡང༌ ངའེ༌ ཁོང༌ ཚང༌མ༌ ཁྱོ༌རང༌ངི༌ ལག༌ག༌ ཏང༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","བ༌རག༌གི༌ དྲེབ༌རཧ༌ ཟེརས༌, “ཉེ༌རང༌ ང༌ ཉམ༌པོ༌ སྐྱོད༌ཏེ༌ མ༌ནེ༌ ངའ༌ མི༌ཆ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","དྲེབ༌རཧའེ༌ ལན༌ཏངས༌, “ཏན༌ཏན༌ ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཆེན༌ ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ཏེ༌ཟུག༌ ཟེར༌ཏེ༌ ཡ༌ཝའེ༌ཀ༌ ཨིད༌ཤེས༌ མ༌ཅོས༌ པ༌སང༌ འི༌ གྱལ༌ཁའེ༌ རྩི༌ཝ༌ ཁྱོ༌རང༌ང༌ མི༌ཐོབ༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ སི༌སེ༌ར༌ བུ༌མོ༌ ཞིག༌གི༌ ལག༌ག༌ སྟད༌ད༌ ཛད༌ཨིན༌།” ཏེ༌ནེ༌ དྲེབ༌རཧ༌ བ༌རག༌ ཉམ༌པོ༌ ཀེ༌དེཤ༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","ཀ༌དེཤ༌སི༌ ནང༌ང༌ བ༌རག༌གི༌ ཟེ༌བུ༌ལོན༌ དང༌ ནཕ༌ཐལ༌ལི༌ སྡེ༌གུན༌ བོད༌ཏེ༌ ཁྱོངས༌ ཡང༌ མག༌མི༌ སྟོང༌ རྕུ༌ ཁོ༌ ཉམ༌པོ༌ སོང༌། དྲེབ༌རཧའང༌ ཁོ༌ ཉམ༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","ཏ༌ མོ༌ཟེས༌སི༌ ན༌མའེ༌ མིང༌བོ༌ ཧོ༌བབ༌བི༌ མིར༌གྱུད༌ ཀེན༌པ༌ ཧེ༌བེར༌ ཁོ༌རང༌ངི༌ མི༌སྡེ༌ ཕྲོ༌ནེ༌ བེ༌ཏེ༌ ཀེ༌དེཤ༌ཤི༌ ཉེ༌མོའ༌ ཟའ༌ནན༌ནིམ༌མི༌ ཨོག༌ ལྕང༌མའེ༌ དུན༌ལ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","ཨ༌བི༌ནོ༌འམ༌མི༌ བུ༌ཚ༌ བ༌རག༌ རི༌ ཏྲ༌བོར༌ལ༌ ཆའ༌ཁན༌བོ༌ སི༌སེ༌རའ༌ ཚོར༌ར༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","ཁོའེ༌ ཁོ༌རང༌ངི༌ ལྕགས༌སི༌ རྟ༌རེལ༌ 900 དང༌ མག༌མི༌ ཚང༌མ༌ ཛོམ༌ཅུགས༌ཏེ༌ ཧ༌རོ༌ཤེཐ༌ ཧག༌གོ༌ཡིམ༌ ནེ༌ ཀི༌ཤོན༌ནི༌ ལྩངས༌པོ༌ ཆོགས༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","ཏེ༌ནེ༌ དྲེབ༌རཧའེ༌ བ༌རག༌ག༌ ཟེརས༌, “གྲལ༌གྲིག༌ ཅོས༌། དི༌རིང༌ འིན༌ན༌ ཞག༌ག༌, ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ལག༌ག༌ སི༌སེ༌རའེ༌ མག༌མི༌ ཚང༌མ༌ སྟད༌ད༌ ཛད༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝ༌ སྔུན༌ལ༌ སྐྱོད༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཕིའ༌ ལམ༌ གྲལ༌གྲིག༌ ཛད༌ཨིན༌།” ཏེ༌ནེ༌ བ༌རག༌ ཁོ༌རང༌ངི༌ མག༌མི༌ སྟོང༌ རྕུ༌ ཉམ༌པོ༌ ཏྲ༌བོར༌རི༌ ནེ༌ ཐུར༌ལ༌ མག༌ ཏང༌ང༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","བ༌རག༌གི༌ སྤུང༌གོལ༌ ཅོའ༌ཅིག༌ ཡ༌ཝའེ༌ སི༌སེ༌ར༌, ཁོའེ༌ རྟ༌རེལ༌ སྲུལ༌ཁན༌ དང༌ མག༌མི༌ ཚང༌མའེ༌ ནང༌ང༌ ཐེ༌ཚོམས༌ དང༌ ཇིགས༌ནང༌ སྐྱེ༌ཅུག༌ག༌ ཛདས༌། སི༌སེ༌ར༌ ཁོ༌རང༌ངི༌ རྟ༌རེལ༌ལི༌ ནང༌ནེ༌ བབས༌ཏེ༌ ཤོར༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","ཏེ༌ནེ༌ བ༌རག༌གི༌ གྲ༌འོའེ༌ རྟ༌རེལ༌གུན༌ དང༌ ཞན༌ མག༌མི༌གུན༌ལ༌ ཧ༌རོ༌ཤེཐ༌ ཧག༌གོ༌ཡིམ༌ ཚོག༌པ༌ ཏེད༌ཏེ༌ ཁྱེརས༌ ཡང༌ སི༌སེ༌རའེ༌ མག༌མི༌ ཚང༌མ༌ སདས༌, ཅིག༌གའང༌ སོན༌ཏེའ༌ མ༌བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","སི༌སེ༌ར༌ ཀེན༌པ༌ ཧེ༌བེར༌རི༌ ན༌མ༌ ཡ༌འེལ༌ལི༌ ཀུར༌ ཡོད༌ས༌ ཤོར༌ཏེ༌ སོང༌ ཅིའ༌ཟེར༌ན༌ ཧ༌ཟོར༌རི༌ གྱལ༌པོ༌ ཡ༌བིན༌ ཉམ༌པོ༌ ཧེ༌བེར༌རི༌ ནང༌ཚངས༌སི༌ བྲེལ༌ ཉེ༌མོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","ཡ༌འེལ༌ སི༌སེ༌ར༌ ཐུག༌ག༌ལ༌ བིང༌ཏེ༌ ཁོའ༌ ཟེརས༌, “ཀུར༌རི༌ ནང༌ང༌ སྐྱོད༌ སྤོན༌བོ༌ལེ༌, ནང༌ཀུག༌ག༌ སྐྱོད༌, ཇིགས༌ས༌ མ༌ཛད༌།” ཏེ༌ནེ༌ ཁོ༌ ཀུར༌རི༌ ནང༌ང༌ ཡོངས༌ ཡང༌ བུ༌མོའེ༌ ཁོའེ༌ཀ༌ ཙ༌ཟར༌ཤིག༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","སི༌སེ༌རའེ༌ ཟེརས༌, “ང༌ སྐོམས༌ས༌ རག༌, ཇུ༌ཇུ༌ ཐུང༌ཅེས༌ལ༌ ཆུ༌ཞིག༌ སལ༌།” ཏེ༌ནེ༌ བུ༌མོའེ༌ ཁོའ༌ འོ༌མ༌ གྱངས༌ཁན༌ནི༌ ཀོའེ༌ སྒི༌གུ༌ ཕེས༌ཏེ༌ འོ༌མ༌ ལུགས༌ ཡང༌ ཐུང༌ང༌ ཏངས༌ཏེ༌ སྟིང༌ནེ༌ ཡང༌སྐྱར༌ ཁོའ༌ ཙ༌ཟར༌ ཀབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","ཁོའེ༌ ཏེ༌ བུ༌མོའ༌ ཟེརས༌, “ཀུར༌རི༌ སྒོའེ༌ དུན༌ལ༌ ལངས༌ཏེ༌ དུག༌, ཀལ༌ཏེས༌ སུ༌ཞིག༌ ཡོངས༌ཏེ༌ ཁྱོ༌རང༌ང༌ ‘ཀུར༌རི༌ ནང༌ང༌ སུ༌ ཡོད༌?’ ཟེར༌ཏེ༌ ཏྲི༌ན༌ ‘སུའང༌ མེད༌’ ཟེར༌།” ");
INSERT INTO lbj_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","སི༌སེ༌ར༌ མ༌སྲན༌ཏྲེ༌ ངལ༌ཏེ༌ ཡོད༌ པ༌སང༌ ཉིད༌ལ༌ སོང༌, ཏེན༌ན༌ ཏུས༌ ཀུར༌རི༌ པུར༌ཆ༌ དང༌ ཐོའ༌ ཁུར༌ཏེ༌ ཡ༌འེལ༌ ཀུ༌ལེའ༌ སོང༌ཏེ༌ ཁོའེ༌ ཐོད༌པའེ༌ ལྡོ༌ནེ༌ པུར༌ཆ༌ གྱབས༌པ༌ འ༌ངོ༌ ཆོགས༌ལ༌ བིང༌ཏེ༌ སའེ༌ ནང༌ང༌ ཟུག༌ ཡང༌ ཁོ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","བ༌རག༌ སི༌སེ༌ར༌ ཙལ༌ཨིན༌ ཡོང༌ང༌ཅིག༌ ཡ༌འེལ༌ ཁོའ༌ ཐུག༌ག༌ལ༌ བིང༌ཏེ༌ ཟེརས༌, “སྐྱོད༌ ངའེ༌ ཉེ༌རང༌ངི༌ ཙལ༌ཁན༌ནི༌ མི༌བོ༌ སྟན༌ཨིན༌།” ཏེ༌ནེ༌ ཁོ༌ བུ༌མོ༌ ཉམ༌པོ༌ ཀུར༌རི༌ ནང༌ང༌ སོང༌ ཡང༌ སི༌སེ༌རའེ༌ ཐོད༌པའེ༌ ལྡོ༌ནེ༌ ཀུར༌རི༌ པུར༌ཆ༌ ཟུགས༌ཏེ༌ ཁོ༌ ཤི༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","ཏེ༌ ཞག༌ག༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ དུན༌ལ༌ དཀོན༌མཆོག༌གི༌ ཀེ༌ནན༌པ༌ གྱལ༌པོ༌ ཡ༌བིན༌ལ༌ ཕམ༌ཀལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","ཡང༌ གྱལ༌པོ༌ ཡ༌བིན༌ནི༌ གྱབ༌གལ༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཤེད༌ཅན༌ གྱུར༌ཨིན༌ སོང༌ ནམ༌ཚག༌པ༌ ཁོང༌གུན༌ནི༌ གྱལ༌པོ༌ དང༌ ཁོའེ༌ མི༌ ཚང༌མ༌ སད༌ཏེ༌ མེད༌ཁན༌ མ༌ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","ཏེན༌ན༌ ཞག༌ག༌ དྲེབ༌རཧ༌ དང༌ ཨ༌བི༌ནོ༌འམ༌མི༌ བུ༌ཚ༌ བ༌རག༌གི༌ འི༌ སྟོད༌པའེ༌ ལུ༌ ཏངས༌, ");
INSERT INTO lbj_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“ཡ༌ཝའ༌ སྟོད༌པ༌ ཕུལ༌ལད༌། ཨིས༌ར༌ཨེལ༌པའེ༌ གོ༌ཁྲིད༌གུན༌ནི༌ ཁག༌ ཀལ༌ཁན༌བོ༌ ཅོའ༌ཅིག༌ མི༌གུན༌ ཐད༌པོ༌ ཉམ༌པོ༌ ཁོང༌གུན༌ནི༌ གྱབ༌ནེ༌ གྲུལས༌, ");
INSERT INTO lbj_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","གྱལ༌པོ༌གུན༌ ཉོན༌ཤིག༌, ཝང༌སྲུལ༌ཁན༌གུན༌ ནང༌སྟག༌ ཏོང༌ཤིག༌, ངའེ༌ ཡ༌ཝའེ༌ ཕིའ༌ ལུ༌ ཏང༌ངད༌, ངའེ༌ ཡ༌ཝའ༌ ལུ༌ཡངས༌ ཕུལ༌ལད༌, ཁོང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཞུགས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","ཡ༌ཝ༌ལེ༌ ཉེ༌རང༌ སེ༌འིར༌ནེ༌ བིངས༌ཏེ༌ ཨི༌དོམ༌མི༌ ཡུལ༌ཇོངས༌ རྒལ༌ཏེ༌ སྐྱོད༌ད༌ཅིག༌ ཇིག༌རྟེན༌ དར༌ ཡང༌ ནམ༌ཁའེ༌ ཆུ༌ ལུགས༌ སྲིན༌གུན༌ནི༌ ནང༌ནེ༌ ཆར༌པ༌ བབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","རི༌ སི༌ནཱའི༌ ཙོགས༌ལ༌, ཡ༌ཝ༌ ཉེ༌རང༌ངི༌ རི༌གུན༌ སྲུག༌ག༌ ཛདས༌། ང༌ཞའ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌, ཉེ༌རང༌ངི༌ རི༌གུན༌ སྐུལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","ཨ༌ནཐ༌ཐི༌ བུ༌ཚ༌ ཤམ༌གར༌ དང༌ ཡ༌འེལ༌ གུན༌ནི༌ ཝང༌སྲུལ༌ལི༌ ཏུས༌, མི༌གུན༌ དང༌ ཚོང༌པ༌གུན༌ གྱ༌ལམ༌གུན༌ནེ༌ གྲུལ༌ཅེས༌ ཇིགས༌ནང༌ཅན༌ ཡོད༌པ༌, ཁོང༌གུན༌ གྱབ༌ལམ༌ ཀགས༌པོ༌གུན༌ནེ༌ གྲུལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྲོང༌སེབ༌བི༌ ནང༌ང༌ དུག༌ཅེས༌ ཕངས༌། ནམ༌ ཚག༌པ༌ ང༌, དྲེབ༌རཧ༌ ཁོང༌གུན༌ནི༌ ཨ༌མ༌ ཙོགས༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ གྱུར༌ཏེ༌ ཁོང༌གུན༌ སྐྱོབ༌ མ༌སྐྱོབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སོ༌མ༌ ལྷ༌ལྷ༌མོ༌གུན༌ ལྡམ༌མ༌ཅིག༌, གྱལ༌སའེ༌ གྱས༌སྒོ༌ གུན༌ནི༌ཀ༌ མག༌ ལེབ༌, ཡང༌ ཨིས༌ར༌ཨེལ༌ལི༌ མག༌མི༌ སྟོང༌ ཞིབ༌ཅུའི༌ ལག༌ག༌, དུང༌ ཡ༌ ཀྲང༌ང༌ཀབ༌ཅེས༌ མག༌ཆ༌ ཅིག༌གའང༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","ངའེ༌ སྙིང༌ ཨིས༌ར༌ཨེལ༌ལི༌ མག༌སྤོན༌གུན༌ ཉམ༌པོ༌ ཡོད༌ ཀ༌གུན༌ ཐད༌པོ༌ ཉམ༌པོ༌ མག༌གི༌ ནང༌ང༌ ནོལ༌ལ༌ ཡོངས༌། ཡ༌ཝའ༌ སྟོད༌པ༌ ཕུལ༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","བུང༌བུ༌ ཀར༌པོའེ༌ཀ༌ གྱབ༌ཆ༌ ཀྲག༌པོ༌ སྟད༌ཏེ༌ ཞོན༌ཁན༌གུན༌, ཡང༌ གྱ༌ལམ༌ནེ༌ གྲུལ༌ཁན༌གུན༌ ནང༌སྟག༌ ཏངས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","གྲོང༌ཁྱེར༌རི༌ ཆུ༌དོང༌ ཡོད༌ས༌ ཛོམས༌ཏེ༌ ལུ༌ ཏང༌ཁན༌གུན༌ལ༌ ཉོན༌ཤིག༌། ཁོང༌གུན༌ནི༌ ཡ༌ཝའེ༌ ཀྲང༌པོ༌ ཆག༌ལས༌གུན༌ ཤད༌ཏེ༌ ཨིན༌ནོག༌ ནམ༌ ཁོང༌ངི༌ ཨིས༌ར༌ཨེལ༌པ༌ ནོལ༌ཁན༌ ཀྲག༌པོ༌གུན༌ལ༌ གྱལ༌ཁ༌ སལས༌། ཏེ༌ནེ༌ ཡ༌ཝའེ༌ མི༌གུན༌ ཐུར༌ལ༌ གྱལ༌སའེ༌ གྱས༌སྒོ༌གུན༌ ཚོག༌པ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","ལོངས༌, དྲེབ༌རཧ༌, ལོངས༌; ལངས༌ཏེ༌ ལུ༌ ཏོང༌། ལོངས༌ བ༌རག༌, ཨ༌བི༌ནོ༌འམ༌མི༌ བུ༌ཚ༌ ལངས༌ཏེ༌ གྲ༌འོ༌ ཚང༌མ༌ ཟུམས༌ཏེ༌ ཁྱོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","ཏེ༌ནེ༌ མག༌གི༌ ནང༌ང༌ སོན༌ཏེའ༌ ལུས༌ཁན༌གུན༌ ཐུར༌ལ༌ ཁོང༌གུན༌ སྐྱོབ༌ཁན༌ནི༌ གོ༌ཁྲིད༌གུན༌ ཉམ༌པོ༌ ཡོངས༌། ཡ༌ཝའེ༌ མི༌གུན༌ ཁོང༌ངི༌ ཕིའ༌ ཀྲག༌པོ༌ ནོལ༌ཁན༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ལ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","ཏུས༌ཤིག༌ག༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ནི༌ ཨིན༌ཁན༌ ས༌ཀྱད༌ ཨེཕ༌ར༌ཡིམ༌ནེ༌ ཁ༌ཅིག༌ ཡོངས༌ ཁོང༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནའང༌ ཡོངས༌། མ༌ཀིར༌རི༌ནེ༌ མག༌སྤོན༌གུན༌ ཡོངས༌། ཟེ༌བུ༌ལོན༌ནི༌ སྡེ༌ནེ༌ ཆག༌བེར༌ ཡོད༌ཁན༌ མག༌སྤོན༌གུན༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","ཨིས༌ས༌ཁར༌ སྡེའེ༌ འུ༌སྐྱོང༌གུན༌, ང༌ དང༌ བ༌རག༌ ཉམ༌པོ༌ ཡོད༌པིན༌། ཁོང༌གུན༌ བ༌རག༌གི༌ གྱབ༌ནེ༌ ལུང༌པའེ༌ ནང༌ང༌ གྱུགས༌ཏེ༌ སོང༌, ཨིན༌ནའང༌ རུ༌བེན༌ནི༌ མི༌སྡེ༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཡོང༌ཅེས༌ལ༌ ཐེ༌ཚོམས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","ཁྱོ༌ཞའ༌ ལུག༌ར༌ ཡོད༌ས༌ ཅི༌ཕིའ༌ དུགས༌པིན༌? ཅི༌ ལུག༌རྫི༌གུན༌ནི༌ ལུག༌གུན༌ ཀག༌ག༌ལ༌ བོད༌ཁན༌བོ༌ ཉན༌ན༌ དུགས༌པིན༌ན༌? རུ༌བེན༌ནི༌ མི༌སྡེ༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཡོང༌ཅེས༌ལ༌ ཐེ༌ཚོམས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","གི༌ལེད༌པ༌གུན༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌ལ༌ དུགས༌། ཡང༌ གྲེན༌ནི༌ མི༌སྡེ༌ ཁོ༌རང༌གུན༌ནི༌ གྲུ༌ཟིང༌གུན༌ནི༌ དུན༌ལ༌ དུགས༌། ཨ༌ཤེར༌ མི༌སྡེ༌ ཚོའེ༌ ཐའ༌མ༌ ཡོད༌ཁན༌ ཁོ༌རང༌གུན༌ནི༌ ཁང༌པའེ༌ ནང༌ནེ༌ མ༌བིངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","ཨིན༌ནའང༌ ཟེ༌བུ༌ལོན༌ མི༌སྡེ༌ ཁོང༌གུན༌ནི༌ སྲོག༌ ཇིགས༌པའེ༌ ནང༌ང༌ ཏངས༌ཏེ༌ ནོལ༌ལ༌ ཡོངས༌། ནཕ༌ཐལ༌ལི༌ མི༌སྡེའང༌ ཏེན༌ན༌ ཙོགས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","ཏའ༌ནག༌གི༌ ནང༌ང༌ མེ༌གིད༌དོའེ༌ ཆུ༌མིག༌གི༌ ཉེ༌མོའ༌ ཀེ༌ནན༌པ༌ གྱལ༌པོ༌གུན༌ མག༌ཏང༌ང༌ ཡོངས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ལ༌ མུལ༌ ཡ༌ ནོར༌ ཅོམས༌ཁན༌ ཅའང༌ ཁྱེར༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","ནམ༌ཁའེ༌ སྐར༌མ༌གུན༌ནི༌ ནོལས༌, རང༌ ལམ༌མི༌ ནང༌ང༌ གྲུལ༌ཁན༌ སྐར༌མ༌གུན༌ནི༌ སི༌སེ༌རའེ༌ གྱབ༌གལ༌ལ༌ ནོལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","ཀི༌ཤོན༌ནི༌ ལྩངས༌པོའེ༌ ཁོང༌གུན༌ ཁུར༌ཏེ༌ ཁྱེརས༌, སྔུན༌མའེ༌ ཏུས༌སི༌ ཁྱུད༌ཅན༌ ལྩངས༌པོ༌ ཀི༌ཤོན༌། ནོལ༌ ངའེ༌ སེམས༌, སེམས༌ཤུགས༌ ཉམ༌པོ༌ ནོལ༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","ཏེ༌ནེ༌ སི༌སེ༌རའེ༌ རྟ༌གུན༌ནི༌ རྐང༌པའེ༌ སྐད༌དི༌ ས༌ཀྱད༌ སྐུལས༌། རྟ༌ ཀྲག༌པོའེ༌ མག༌མི༌གུན༌ གྱུགས༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ མོལས༌, ‘མེ༌རོཟ༌པ༌གུན༌ལ༌ ངན༌ ཕོག༌ཤིག༌། ཁོང༌གུན༌ལ༌ ངན༌ རྩོག༌པོ༌ ཕོག༌ཤིག༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ ཡ༌ཝའ༌ རོགས༌ ཅོའ༌ལ༌ མ༌ཡོངས༌ ཀེ༌ནན༌པ༌ མག༌མི༌ ཀྲག༌པོ༌གུན༌ལ༌ ནོལ༌ལ༌ མ༌ཡོངས༌།’ ");
INSERT INTO lbj_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","ཚང༌མའེ༌ སང༌ ཅིན༌ལབས༌ཅན༌ བུ༌མོ༌, ཀེ༌ནན༌པ༌ ཧེ༌བེར༌རི༌ ན༌མ༌ ཡ༌འེལ༌ ཨིན༌། ཀུར༌རི༌ ནང༌ང༌ དུག༌ཁན༌ནི༌ བུ༌མོ༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཁོ༌ ཚང༌མའེ༌ སང༌ ཅིན༌ལབས༌ཅན༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","སི༌སེ༌རའེ༌ ཆུ༌ ཏོང༌ ཟེརས༌ ཨིན༌ནའང༌ ཁོའེ༌ འོ༌མ༌ ཏངས༌, སྐུ༌ཁྲགས༌གུན༌ལ༌ ཏང༌ཅེས༌སི༌ ཕོ༌ཀྲོའེ༌ ནང༌ང༌ བུ༌མོའེ༌ ཁོའ༌ ཞོ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","བུ༌མོའེ༌ ལག༌པ༌ ཡོ༌མའེ༌ ནང༌ང༌ ཀུར༌རི༌ པུར༌ཆ༌ ཡང༌ ཡས༌པའེ༌ ནང༌ང༌ ལག༌ཤེས༌པའེ༌ ཐོའ༌ ཁུརས༌། ཁོའེ༌ སི༌སེ༌རའེ༌ གོ༌ ཅགས༌, ཁོའེ༌ སི༌སེ༌རའེ༌ ཐོད༌པའེ༌ ལྡོ༌ནེ༌ པུར༌ཆ༌ གྱབས༌ཏེ༌ ཁོ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","སི༌སེ༌ར༌ ཏེ༌ བུ༌མོའེ༌ རྐང༌པའེ༌ཀ༌ བུད༌, ཁོའེ༌ རྐང༌པའེ༌ཀ༌ གྱེལ༌ཏེ༌ ཤི༌, གྱེལ༌སའེ༌ ཏེན༌ན༌ ནས༌སའེ༌ཀ༌ ཁོ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","སི༌སེ༌རའེ༌ ཨ༌མའེ༌ ཀར༌ཁུང༌ནེ༌ ལྟེན༌ ཁོ༌ ལོགས༌ཏེ༌ ཡོང༌ཅེས༌ལ༌ སྲུངས༌ཏེ༌ ཟེརས༌, ‘ཁོའེ༌ རྟ༌རེལ༌ ལེབ༌ཅེས༌ལ༌ འི༌ཟམ༌ ཏུས༌རིང༌མོ༌ ཅིའ༌ གོར༌? ཁོའེ༌ རྟ༌རེལ༌ལི༌ སྐད༌ ང༌ ཅིའ༌ ཚོར༌ར༌ མ༌ནོག༌?’ ");
INSERT INTO lbj_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","ཁོའེ༌ ཞབ༌ཤི༌ བུ༌མོ༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཤེས༌རབས༌ཅན༌བོའེ༌ ལན༌ཏངས༌, ཏན༌ཏན༌ ཁོའེ༌ འི༌ སྤེ༌ར༌གུན༌ ལྡབས༌ཏེ༌ ཁོ༌རང༌ང༌ སེམས༌སོ༌ ཏང༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","‘ཁོང༌གུན༌ནི༌ ཅོམས༌ཁན༌ནི༌ ནོར༌གུན༌ བགོ༌ཨིན༌ ཡོད༌གྲོ༌, མག༌མི༌ རེ༌རེའ༌ བུ༌མོ༌ ཅིག༌ ཡ༌ ཉིས༌། སི༌སེ༌རའེ༌ ཕིའ༌ ཚོན༌དོག༌ཅན༌ དང༌ ཚེམ༌སྲུལ༌ ཏང༌ཁན༌ནི༌ ཀོས༌ལག༌གུན༌, ངའེ༌ ཕིའང༌ ཚེམ༌སྲུལ༌ ཏང༌ཁན༌ནི༌ ཀོས༌ ཁྱོང༌ཨིན༌། ཏེ༌ ཚང༌མ༌ ཅོམས༌ཁན༌ནི༌ ནོར༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","ཡ༌ཝ༌ལེ༌, ཉེ༌རང༌ངི༌ གྲ༌འོ༌ ཚང༌མ༌ སི༌སེ༌ར༌ ཙོགས༌ལ༌ ཤི༌ཤིག༌། ཨིན༌ནའང༌ ཉེ༌རང༌ང༌ ཅམས༌པ༌ ཅོ༌ཁན༌གུན༌ ཤེད༌ཅན༌ གྱུར༌ཏེ༌ ཉི༌མ༌ ཙོགས༌ལ༌ ཤར༌ཤིག༌།” ཏེ༌ནེ༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ལོ༌ 40 ཞི༌དེ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","ཡང༌སྐྱར༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཅོས༌ ཡང༌ ཡ༌ཝའེ༌ ལོ༌ རྡུན༌ནི༌ ཕིའ༌ ཁོང༌གུན༌ མི༌དིའན༌པ༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ད༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","མི༌དིའན༌པ༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ནགས༌ སྲན༌ཏྲེ༌ སྟན༌ པ༌སང༌ ཁོང༌གུན༌ རི༌, བྲག༌ཕུགས༌ ཡང༌ ཇིགས༌ནང༌ མེད༌སའེ༌ ས༌ཀྱད༌གུན༌ནི༌ ནང༌ང༌ ཨིབ༌སའེ༌ ནས༌ས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྟོན༌ཐོག༌ ཏབ༌བ༌ཅིག༌ མི༌དིའན༌པ༌, ཨ༌མ༌ལིཀ༌པ༌ ཡང༌ ཤར༌ ཆོགས༌སི༌ མི༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","ཏེ༌རུ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌ཏེ༌ ག༌ཟ༌ ཚོག༌པ༌ ཁོང༌གུན༌ནི༌ སྟོན༌ཐོག༌གུན༌ མེད༌ཁན༌ ཅོའད༌པིན༌། ཁོང༌གུན༌ནི༌ ལུག༌, བ༌ལང༌ དང༌ བུང༌བུ༌ ཚང༌མའང༌ ཁྱེར༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕིའ༌ ཟའ༌ཅེས༌ ཅའང༌ ལུས༌ཤུག༌ག༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","ཁོང༌གུན༌ ཁོང༌རང༌གུན༌ནི༌ སེམས༌ཅན༌ དང༌ ཀུར༌གུན༌ ཉམ༌པོ༌ པར༌པར༌ཙེ༌ ཚོགས༌ ཙོགས༌ལ༌ མ༌མང༌པོ༌ ཡོང༌ངད༌པིན༌། མི༌གུན༌ དང༌ རྔ༌བོང༌གུན༌ རྩི༌ མི༌ཉན༌ཅེས༌ མང༌པོ༌ ཡོངས༌ཏེ༌ ཏེ༌ ནས༌ས༌ སྟོང༌པ༌ ཆ༌ཆ༌ དུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","མི༌དིའན༌པ༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ མ༌ ཉལ༌བ༌ཅན༌ གྱུར༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ལ༌ རྡུག༌པོ༌ ཐོང༌ ཅུགས༌ པ༌སང༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝའ༌ རོགས༌ ཅོའ༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","མི༌དིའན༌པ༌གུན༌ནི༌ ཞས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུའ༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","ཁོང༌ངི༌ ཁོང༌གུན༌ནི༌ཀ༌ ལུང༌སྟོན༌པ༌ཞིག༌ ཀལ༌ལ༌ ཛདས༌ ཡང༌ ཁོའེ༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌ལི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ འི༌ཟུག༌ མོལ༌ལ༌རག༌, ‘ངའེ༌ ཁྱོ༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཚེ༌ཡོག༌ག༌ ཡོད༌ཁན༌ ཨི༌ཇིབ༌བི༌ ནས༌ས༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","ཨི༌ཇིབ༌པ༌གུན༌ ཐེས༌ཏེ༌ ཞན༌ ཁྱོ༌ཞའ༌ ནགས༌ སྟན༌ཁན༌ ཚང༌མའེ༌ ཀ༌ནེ༌ ངའེ༌ ཁྱོ༌རང༌གུན༌ སྐྱོབས༌ཏེ༌ ཁྱོངས༌པིན༌། ངའེ༌ ཁྱོ༌ཞའེ༌ གྲ༌འོ༌གུན༌ ཕིངས༌ཏེ༌ ཁོང༌གུན༌ནི༌ ས༌ཀྱད༌ ཁྱོ༌ཞའ༌ ཏངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཟེར༌པིན༌, ‘ང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝ༌ ཡང༌ ཁྱོ༌ཞའེ༌ ཨ༌མོར༌པ༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ ཅོལ༌ མ༌གོས༌, ཀ༌གུན༌ནི༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ ཁྱོ༌ཞའ༌ དུག༌ཨིན༌ ཨིན༌ནོག༌།’ ཨིན༌ནའང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ ཁའ༌ མ༌ཉནས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","ཡ༌ཝའེ༌ ཕོ༌ཉ༌ སྐྱོདས༌ཏེ༌ ཨོཕ༌རཧ༌ ནང༌ང༌ ཨ༌བིའེ༌ཟེར༌པ༌ ཡོ༌འཤ༌ཤི༌ ཨིན༌ཁན༌ ཨོག༌གི༌ ལྕང༌མ༌ ཆེན༌མོའེ༌ ཡོག༌ག༌ ཞུགས༌། ཏེ༌ཀ༌ མི༌དིའན༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཨིབས༌ཏེ༌ ཡོ༌འཤ༌ཤི༌ བུ༌ཚ༌ གི༌དི༌འོན༌ནི༌ རྒུན༌ཆང༌ ཙིར༌སའེ༌ ནང༌ང༌ སྙེ༌མ༌ དུངས༌ཏེ༌ གྲོ༌ ཕིང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","ཡ༌ཝའེ༌ ཕོ༌ཉའ༌ ཁོ༌ ཡོད༌ས༌ སྐྱོད༌ཏེ༌ མོལས༌, “ནོལ༌ཁན༌ ཀྲག༌པོ༌ གི༌དི༌འོན༌, ཡ༌ཝ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","གི༌དི༌འོན༌ནི༌ ལན༌ཏངས༌, “སྤོན༌བོ༌ལེ༌ ཀལ༌ཏེས༌ ཡ༌ཝ༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཡོད༌ན༌ ང༌ཞ༌གུན༌ནི༌ཀ༌ འི༌ ཚང༌མ༌ ཅིའ༌ ཇུངས༌ཏེ༌ ཨིན༌ནོག༌? ‘ཡ༌ཝའེ༌ ང༌དང༌གུན༌ ཨི༌ཇིབ༌བི༌ ནང༌ནེ༌ ཕིངས༌ཏེ༌ མ༌ཁྱོངས༌ས༌’ ཟེར༌ཏེ༌ ང༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ ཤད༌ཁན༌ ཁོང༌ངི༌ ཧ༌ལས༌ཤེས༌སི༌ ཛད༌པ༌གུན༌ ཀ༌རུ༌ སོང༌? ཨིན༌ནའང༌ ཏ༌ ཡ༌ཝའེ༌ ང༌ཞའ༌ ཕང༌ང༌ ཛད༌ཏེ༌ མི༌དིའན༌པ༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ད༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","ཏེ༌ནེ༌ ཡ༌ཝ༌ ཁོ༌ ཆོགས༌ལ༌ གྱུར༌ར༌ ཛད༌ཏེ༌ མོལས༌, “ངའེ༌ ཁྱོ༌རང༌ ཀལ༌ཏེ༌ མ༌ནོག༌ག༌? སོང༌, ཁོ༌རང༌ང༌ ཡོད༌ཁན༌ནི༌ ཤེད༌ ཀོལ༌ཏེ༌ མི༌དིའན༌པ༌གུན༌ནི༌ ལག༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱོབས༌ཏེ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","ཨིན༌ནའང༌ གི༌དི༌འོན༌ནི༌ ཟེརས༌, “ཡ༌ཝ༌ལེ༌, ཀ༌ཟུག༌གི༌ ངའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱོབ༌ཨིན༌? མ༌ནས༌སའེ༌ མི༌སྡེ༌ གང༌པོའེ༌ ནང༌ནེ༌ ང༌ཞའེ༌ མི༌རིགས༌པོ༌ ཚང༌མའེ༌སང༌ ཤེད༌མེད༌ ཡང༌ ངའེ༌ ནང༌ཚངས༌སི༌ ནང༌ནེ༌ ང༌ ཆུང༌ཤོག༌ རྩིས༌མེད༌པོ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “ཨིན༌ནའང༌ ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ཡོད༌ ཡང༌ ཁྱོ༌རང༌ངི༌ མི༌དིའན༌པ༌ ཚང༌མའ༌ ཕམ༌ཀལ༌ཏེ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","གི༌དི༌འོན༌ནི༌ ལན༌ཏངས༌, “ཀལ༌ཏེས༌ ཉེ༌རང༌ ངའེ༌ཀ༌ དེན༌བའ༌ ཐུག༌ཉེས༌ན༌, ཡ༌ཝའེ༌ ཞལ༌ཏ༌ སལ༌ཁན༌བོ༌ དེན༌བ༌ ཨིན༌ཁན༌ནི༌ སྟགས༌ཤིག༌ ངའ༌ སྟན༌ན༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","ངའེ༌ ཉེ༌རང༌ང༌ ཕུལ༌ཅེས༌སི༌ ཆོད༌པ༌ ཁྱོང༌ཁྱོང༌ ཚག༌པ༌ ཉེ༌རང༌ སྐྱོད༌ མ༌སྐྱོད༌ད༌ འི༌ཀ༌ ཞུགས༌ལེ༌།” ཁོང༌ངི༌ ལན༌སལས༌, “ཁྱོ༌རང༌ ལོགས༌ཏེ༌ ཡོང༌ཡོང༌ ཚག༌པ༌ ང༌ འིན༌ནི༌ཀ༌ དུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","གི༌དི༌འོན༌ གྱོགས༌པ༌ ཁང༌པ༌ སོང༌ཏེ༌ ར༌མ༌ ཆུ༌ངུན༌ནི༌ ཤ༌ སྐོལས༌ ཡང༌ གི༌གུ༌ ཆེན༌མོ༌ གང༌ངི༌ པག༌པའེ༌ ཁྱོངས༌ཏེ༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ ཅོས༌། ཏེ༌ནེ༌ ཁོའེ༌ ཤ༌ པག༌ཙེ༌ ནང༌ང༌ ཡང༌ ཤ༌ཁུའ༌ ཟང༌བུའི༌ ནང༌ང༌ གྱངས༌ཏེ༌ ཁྱོངས༌ ཡང༌ ལྕང༌མ༌ ཆེན༌མོའེ༌ ཡོག༌ག༌ ཞུགས༌ཁན༌ནི༌ ཕོ༌ཉའ༌ ཆོད༌པ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","དཀོན༌མཆོག༌གི༌ ཕོ༌ཉའེ༌ ཁོའ༌ མོལས༌, “ཤ༌ དང༌ སྐྱུར༌ མེད༌ཁན༌ནི༌ ཏ༌གི༌ འི༌ ཕོ༌ལོངས༌སི༌ཀ༌ བོར༌ཏེ༌ ཤ༌ཁུའ༌ ཏེ༌བོའེ༌ ཁེ༌ཐོག༌ག༌ ལུག༌།” ཡང༌ གི༌དི༌འོན༌ནི༌ ཁོང༌ངི༌ མོལ༌ཁན༌བོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ཁོང༌རང༌ངི༌ ཆག༌ག༌ ནམས༌ཁན༌ནི༌ བེར༌ཀའེ༌ གོ༌ ཤ༌ དང༌ ཏ༌གིའ༌ ཐུག༌ ཅུག༌ག༌ ཛད༌ད༌ཅིག༌ ཕོ༌ལོངས༌སི༌ ནང༌ནེ༌ མེ༌ བིང༌ཏེ༌ ཟན༌ ཚང༌མ༌ མེའ༌ སྲག༌ཏེ༌ མེད༌ཁན༌ ཛདས༌ ཡང༌ ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ཏེ༌ཀ༌ནེ༌ སྟོར༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","གི༌དི༌འོན༌ལ༌ ཁོང༌ ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ཨིན༌ཁན༌བོ༌ ཧ༌གོའ༌ཅིག༌ ཁོའེ༌ ཟེརས༌, “ཡ༌ཝ༌ ཀུན༌ཝང༌ལེ༌། ཝའོ༌, ངའེ༌ ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ང༌རང༌ངི༌ མིག༌ནེ༌ ཇལ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ལན༌སལས༌, “ཇིགས༌ མ༌ཇིགས༌, ཞི༌དེ༌ ཉམ༌པོ༌ དུག༌། ཁྱོ༌རང༌ ཤི༌ མི༌ཤི༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ ཏེ༌ཀ༌ ཡ༌ཝའེ༌ ཕིའ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌ ཡང༌ ཏེ༌བོའ༌ ‘ཡ༌ཝ༌ ཞི༌དེ༌ཅན༌’ མིང༌ང༌ ཏགས༌། ཏེ༌ ཆོད༌ཁྲི༌ དི༌རིང༌ངའང༌ ཨ༌བིའེ༌ཟེར༌པ༌གུན༌ནི༌ ནས༌ས༌ ཨོཕ༌རཧའེ༌ ནང༌ང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","ཏེན༌ན༌ ཚན༌ལ༌ ཡ༌ཝའེ༌ གི༌དི༌འོན༌ལ༌ མོལས༌, “ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ བ༌ལང༌ངི༌ ཁྱུའི༌ ནང༌ནེ༌ ལོ༌ རྡུན༌ ཆའ༌ཁན༌ནི༌ ལང༌ཏོ༌ ཉིས༌པ༌བོ༌ ཁྱོང༌། ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ བའལ༌ལ༌ ཅོལ༌ཅེས༌སི༌ ཕིའ༌ རྩིག༌ཁན༌ནི༌ ཆོད༌ཁྲི༌ ཤིག༌ ཡང༌ ཏེ༌བོའེ༌ དུན༌ལ༌ ཨ༌ཤེ༌རཧ༌ ལྷ༌མོའེ༌ ཕིའ༌ ལངས༌ཁན༌ནི༌ རྡུང༌མ༌བོ༌ ཏུམ༌པ༌ཏུམ༌པའེ༌ ནང༌ང༌ ཅོད༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","ཏེ༌ནེ༌ འི༌ རིའི༌ གོའེ༌ཀ༌ ང༌ ཁྱོ༌ཞའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཕིའ༌ རྡོའ༌གུན༌ རིགས༌ཏེ༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌། ཨ༌ཤེ༌རཧའེ༌ རྡུང༌མ༌ ཅད༌ཁན༌ནི༌ ཤིང༌ ཀོལ༌ཏེ༌ ཏེ༌ ཆོད༌ཁྲི༌ཀ༌ ལང༌ཏོ༌ ཉིས༌པའེ༌ ཤ༌ མེའ༌ སྲགས༌ཏེ༌ ཆོད༌པའ༌ ཕུལ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ ཁོ༌རང༌ངི༌ ཡོག༌པོ༌ རྕུ༌ ཁྲིད༌ཏེ༌ ཡ༌ཝའེ༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཅོས༌། ཨིན༌ནའང༌ ཁོ༌རང༌ངི༌ ནང༌ཚངས༌ དང༌ གྲོང༌ཁྱེར༌རི༌ མི༌གུན༌ལ༌ ཇིགས༌ པ༌སང༌ ཁོའེ༌ ཏེ༌བོ༌ ཚན༌ལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ གྲོང༌ཁྱེར༌རི༌ མི༌གུན༌ལ༌ བའལ༌ལི༌ ཆོད༌ཁྲི༌ ཤིགས༌ཏེ༌ ཏེ༌བོའེ༌ དུན༌ལ༌ ཡོད༌ཁན༌ནི༌ ཨ༌ཤེ༌རཧའེ༌ རྡུང༌མ༌ ཅད༌ཏེ༌ ཏེ༌ ནས༌སའེ༌ཀ༌ ཆོད༌ཁྲི༌ སོ༌མ༌ཞིག༌ རྩིགས༌ཏེ༌ ལང༌ཏོ༌ ཉིས༌པ༌ ཆོད༌པ༌ ཕུལ༌ཁན༌ནི༌ རོ༌ཏོ༌གུན༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","མི༌གུན༌ནི༌ ཅིག༌ དང༌ ཅིག༌ག༌ ཟེརས༌, “འི༌བོ༌ སུའི༌ ཅོས༌ཧེ༌?” ཡང༌ ཉེ༌ཁོར༌ལ༌ ཞིབ༌སལ༌ ཅོས༌ཏེ༌ སྟག༌ཅད༌ ཅོས༌པ༌ ཁོང༌གུན༌ལ༌ ཡོ༌འཤ༌ཤི༌ བུ༌ཚ༌ གི༌དི༌འོན༌ནི༌ ཅོས༌ཁན༌བོ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","གྲོང༌ཁྱེར༌རི༌ མི༌གུན༌ནི༌ ཡོ༌འཤ༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ བུ༌ཚ༌ ཕིངས༌ཏེ༌ ཁྱོང༌, ཁོ༌ སད༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ བའལ༌ལི༌ ཆོད༌ཁྲི༌ ཤིགས༌ཏེ༌ ཏེ༌ དུན༌ལ༌ ཡོད༌ཁན༌ ཨ༌ཤར༌རི༌ རྡུང༌མ༌ ཅད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","ཨིན༌ནའང༌ སྲོ༌ ཡོངས༌ཁན༌ནི༌ མི༌གུན༌ལ༌ ཡོ༌འཤ༌ཤི༌ ཟེརས༌, “ཅི༌ཕིའ༌ ཁྱོ༌རང༌གུན༌ནི༌ བའལ༌ སྐྱོབ༌བད༌? ཅིའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ བའལ༌ལི༌ ཕིའ༌ ནོལ༌ལད༌? བའལ༌ལ༌ ཆོགས༌སྐྱོར༌ ཅོས༌ཏེ༌ ནོལ༌ཁན༌ནི༌ མི༌ ང༌མོ༌ ཚོག༌པ༌ སོན༌ཏེའ༌ མི༌ལུས༌། ཀལ༌ཏེས༌ བའལ༌ དེན༌བའེ༌ ལྷ༌ ཨིན༌ན༌ ཁོའེ༌ ཆོད༌ཁྲི༌ ཤིག༌ཁན༌གུན༌ལ༌ ཆད༌པ༌ ཏངས༌ཏེ༌ ཁོ༌རང༌ སྐྱོབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","ཏེ༌ ཏུས༌ནེ༌ ཕར༌ལ༌ གི༌དི༌འོན༌ལ༌ ཡེ༌རུབ༌བའལ༌ མིང༌ང༌ ཏགས༌ ཀ༌བོའེ༌ དོན༌ནི༌ “བའལ༌ལ༌ ཁོ༌རང༌ སྐྱོབ༌ཅུག༌” ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཤིག༌ཁན༌ནི༌ ཆོད༌ཁྲི༌ ཁོའེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","ཏ༌ མི༌དིའན༌པ༌, ཨ༌མ༌ལིཀ༌པ༌ ཡང༌ ཤར༌ ཆོགས༌སི༌ ཞན༌ མི༌ ཚང༌མ༌ ཐུན༌བྲེལ༌ སོང༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཡེཟ༌རེ༌འེལ༌ལི༌ ལུང༌པའེ༌ ནང༌ང༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཐུག༌ཉིད༌ གི༌དི༌འོན༌ནི༌ཀ༌ བབས༌པ༌ ཁོའེ༌ ཨ༌བིའེ༌ཟེར༌པ༌གུན༌ལ༌ ཁོའེ༌ གྱབ༌ནེ༌ ནོལ༌ལ༌ ཡོང༌ཅེས༌ལ༌ ཏུང༌ ཕུས༌ཏེ༌ བོདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","ཁོའེ༌ མ༌ནས༌ས༌, ཨ༌ཤེར༌, ཟེ༌བུ༌ལོན༌ དང༌ ནཕ༌ཐལ༌ལི༌ མི༌སྡེ༌གུན༌ལ༌ ལོན༌ ཀལ༌ཏེ༌ བོདས༌ ཡང༌ ཁོང༌ངི༌ མག༌མི༌ ཚང༌མ༌ རོགས༌ ཅོ༌ཅེས༌ལ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ དཀོན༌མཆོག༌ག༌ མོལས༌, “ཉེ༌རང༌ངི༌ ཞལ༌ཆད༌ ནང༌ཞིན༌ ཀལ༌ཏེས༌ ཉེ༌རང༌ངི༌ ང༌ གྱུད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱོབ༌བ༌ ཛད༌ཅེས༌ ཨིན༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","དི༌རིང༌ ཚན༌ལ༌ ངའེ༌ ཁུ༌ཡུས༌ སྐོར༌སའེ༌ ནས༌སའེ༌ཀ༌ ལུག༌གི༌ བལ༌ བོར༌ཨིན༌, ང༌མོ༌ བལ༌ ཟིལ༌པའེ༌ ལོན༌པ༌ ཨིན༌ནའང༌ ས༌ཀྱད༌པོ༌ སྐམ༌པོ༌ ཡོད༌ན༌ ཏེ༌ནེ༌ ཉེ༌རང༌ངི༌ ཞལ༌ཆད༌ ནང༌ཞིན༌ ང༌ གྱུད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱོབ༌བ༌ ཛད༌ཅེས༌པོ༌ ང༌ ཧ༌གོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","ཡང༌ ཏེན༌ན༌བོ༌ ཇུང༌། ང༌མོ༌ གི༌དི༌འོན༌ ལངས༌ཏེ༌ བལ༌བོ༌ ཙིར༌ར༌ཅིག༌ གོར༌མོ༌ གང༌ངི༌ ཆུ༌ ཕིངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ དཀོན༌མཆོག༌ག༌ མོལས༌, “ཇུ༌ཇུ༌ ངའེ༌ཀ༌ ཐུག༌སྲོ༌ མ༌སྐྱོད༌། ཡང༌སྐྱར༌ སྟགས༌ཤིག༌ སྟན༌ན༌ ཛད༌ཅེས༌ལ༌ ང༌ ཞུ༌ཝ༌ ཕུལ༌ཅུག༌། འི༌ ལན༌ བལ༌ སྐམ༌པོ༌ ཨིན༌ནའང༌ ས༌ཀྱད༌ ལོན༌པ༌ ལུ༌ ཤུག༌ག༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","ཏེན༌ན༌ ཚན༌ལ༌ དཀོན༌མཆོག༌གི༌ གི༌དི༌འོན༌ནི༌ ཟེར༌ཁན༌བོ༌ ཛདས༌། ང༌མོ༌ བལ༌ སྐམ༌པོ༌ ཡང༌ ས༌ཀྱད༌ ཟིལ༌པའེ༌ ཀབས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","ཡེ༌རུབ༌བའལ༌ ཡང༌ན༌ གི༌དི༌འོན༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ ང༌མོ༌ནེ༌ ལངས༌ཏེ༌ ཐག༌རིང༌ ཧེ༌རོད༌ ཟེར༌ཁན༌ནི༌ ཆུ༌མིག༌ ཚོག༌པ༌ སོང༌། ཁོང༌གུན༌ནི༌ བྱང༌ ཆོགས༌ལ༌ རི༌ མོ༌རེཧའེ༌ ཉེ༌མོའ༌ ལུང༌པའེ༌ ནང༌ང༌ མི༌དིའན༌པ༌ མག༌མི༌གུན༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","ཡ༌ཝའེ༌ གི༌དི༌འོན༌ལ༌ མོལས༌, “ངའེ༌ མི༌དིའན༌པ༌གུན༌ ཁྱོ༌རང༌ངི༌ ལག༌ག༌ སྟད༌ཨིན༌ ཨིན༌ནའང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ མག༌མི༌ མངས༌ཏེའང༌ མང༌པོ༌ ཡོད༌ པ༌སང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕོ༌སོ༌ ཅོས༌ཏེ༌ ཁོང༌རང༌གུན༌ནི༌ ཁྱུད༌ གྱུད༌ཏེ༌ གྱལ༌ཁ༌ ཐོབ༌ ཟེར༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","ཏེ༌བོའེ༌ཕིའ༌ ‘སེམས༌ཤུག༌ ཆགས༌ཁན༌ ཡ༌ ཇིགས༌ཁན༌ མི༌གུན༌ རི༌ གི༌ལེད༌ནེ༌ ལོགས༌ཏེ༌ ཁང༌པ༌ ཆ༌ནའང༌ གྲིག༌’ ཟེར༌།” ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ནང༌ནེ༌ 22,000 ཁང༌པ༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ 10,000 མན༌ནེ༌ མ༌ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","ཨིན༌ནའང༌ ཡ༌ཝའེ༌ གི༌དི༌འོན༌ལ༌ མོལས༌, “ཏ༌རུང༌ངའང༌ མག༌མི༌ མངས༌ཏེའང༌ མང༌པོ༌ དུག༌། ཁོང༌གུན༌ ཐུར༌ལ༌ ཆུ༌མིག༌ ཡོད༌ས༌ ཁྱེར༌ ཡང༌ ངའེ༌ ཏེ༌རུ༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ ནོལ༌ལ༌ ཆ༌ཅེས༌ཅན༌ དང༌ མི༌ཆ༌ཅེས༌ཅན༌ གུན༌ ཕེ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ མག༌མི༌གུན༌ ཐུར༌ལ༌ ཆུ༌མིག༌ ཡོད༌ས༌ ཁྱེརས༌ ཡང༌ ཡ༌ཝའེ༌ ཁོའ༌ མོལས༌, “ལག༌པའེ༌ ནང༌ང༌ ཆུ༌ ཁྱོངས༌ཏེ༌ ཁྱི༌ ཙོགས༌ལ༌ ལྕེ༌ ཉམ༌པོ༌ ཆུ༌ ཐུང༌ཁན༌གུན༌ དང༌ པིག༌མོ༌ ཙུགས༌ཏེ༌ ཁའ༌ ཉམ༌པོ༌ ཆུ༌ ཐུང༌ཁན༌གུན༌ སོ༌སོ༌ ཕེས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","མི༌ 300 ཁོང༌རང༌གུན༌ནི༌ ལག༌པའེ༌ ནང༌ང༌ ཆུ༌ ཁྱོངས༌ཏེ༌ ཐུངས༌ ཨིན༌ནའང༌ ཞན༌ གུན༌ནི༌ པིག༌མོ༌ ཙུགས༌ཏེ༌ ཁའ༌ ཉམ༌པོ༌ ཆུ༌ ཐུངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","ཡ༌ཝའེ༌ གི༌དི༌འོན༌ལ༌ མོལས༌, “འི༌ མི༌ 300, ཁྱི༌ ཙོགས༌ལ༌ ལྕེ༌ ཉམ༌པོ༌ ཆུ༌ ཐུང༌ཁན༌གུན༌ གྱུད༌ཏེ༌ ངའེ༌ ཁྱོ༌ཞའ༌ ཐར༌ཅུགས༌ཏེ༌ མི༌དིའན༌པ༌གུན༌ནི༌ཀ༌ གྱལ༌ཁ༌ ཐོབ༌ཅུག༌ཨིན༌། ཏ༌ ཞན༌ ཚང༌མ༌ ཁང༌པ༌ ལོགས༌ཏེ༌ ལམ༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ ཏེ༌ མག༌མི༌ 300 མ༌སྟོགས༌ ཞན༌ ཚང༌མ༌ ལོགས༌ཏེ༌ ལམ༌ཅུགས༌ ཡང༌ ལྡམ༌ཁན༌ནི༌ མག༌མི༌ སུམ༌གྱའེ༌ ཁོ༌རང༌གུན༌ནི༌ ཕིའ༌ ཁར༌ཇི༌ དང༌ ར༌ཅོའེ༌ ཏུང༌ གུན༌ ཁུརས༌། ཏ༌ ཁོང༌གུན༌ནི༌ ཡོག༌ག༌ ལུང༌པའེ༌ ནང༌ང༌ མི༌དིའན༌པ༌གུན༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","ཏེ༌ ཚན༌ལ༌ ཡ༌ཝའེ༌ གི༌དི༌འོན༌ལ༌ མོལས༌, “ལོངས༌, ཐུར༌ལ༌ མི༌དིའན༌པ༌གུན༌ དུགས༌ཏེ༌ ཡོད༌ས༌ སྤུང༌གོལ༌ ཅོའ༌ལ༌ སོང༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ལག༌ག༌ ཁོང༌གུན༌ སྟད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","ཨིན༌ནའང༌ ཀལ༌ཏེས༌ ཁྱོ༌རང༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ ཇིགས༌སད༌ན༌, ཁྱོ༌རང༌ ཁྱོ༌རང༌ངི༌ ཡ༌ཏོ༌ པུ༌རཧ༌ ཉམ༌པོ༌ ཐུར༌ལ༌ ཀུར༌གུན༌ ཡོད༌ས༌ སོང༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","མི༌དིའན༌པ༌གུན༌ནི༌ ཟེར༌ཨིན༌ ཡོད༌ཁན༌གུན༌ ཉོན༌། ཏེ༌གུན༌ ཚོར༌ཏེ༌ ཁྱོ༌རང༌ང༌ སྤོས༌པ༌ སྐྱེས༌ཏེ༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ མི༌ཚབས༌།” ཏེ༌ནེ༌ གི༌དི༌འོན༌ པུ༌རཧ༌ ཁྲིད༌ཏེ༌ ཐུར༌ལ༌ གྲ༌འོ༌གུན༌ ཀུར༌ ཙུགས༌ཏེ༌ དུག༌སའེ༌ ཉེ༌མོའ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","པར༌པར༌ཙེ༌ ཚོགས༌ ཙོགས༌ལ༌ མི༌དིའན༌པ༌, ཨ༌མ༌ལིཀ༌པ༌ ཡང༌ ཤར༌ ཆོགས༌སི༌ མི༌ ཚང༌མ༌ ལུང༌པའེ༌ ནང༌ང༌ ཛོམས༌ཏེ༌ ཁོང༌གུན༌ནི༌ རྔ༌བོང༌གུན༌ ཚོའེ༌ ཐའ༌མའེ༌ པེ༌མ༌ ཙོགས༌ རྩི༌ མི༌ཉན༌ཅེས༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","གི༌དི༌འོན༌ ལེབ༌ ཟ༌ནེ༌ མག༌མི༌ཞིག༌གི༌ ཁོ༌རང༌ངི༌ ཕྲོ༌པའ༌ ཁོ༌རང༌ངི༌ ཉི༌ལམ༌ ཤད༌ཨིན༌ ཟེར༌རད༌པིན༌, “ང༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌, ནས༌སི༌ ཏ༌གི༌ ཀིར༌ཀིར༌ ཆེན༌མོ༌ཞིག༌ མི༌དིའན༌པ༌གུན༌ དུགས༌སའེ༌ ནས༌སའེ༌ ནང༌ང༌ རི༌ལིག༌ག༌ ཡོངས༌ཏེ༌ ཏེ༌ཟམ༌ ཤེད༌ ཉམ༌པོ༌ ཀུར༌ལ༌ ཕོག༌པ༌ ཀུར༌བོ༌ གོའེ༌ཀ༌ ལོགས༌ ཡང༌ ལྡིབས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","ཁོའེ༌ ཕྲོ༌པའེ༌ ལན༌ཏངས༌, “ཏེ༌བོའེ༌ ཏོན༌ ཨིས༌ར༌ཨེལ༌པ༌ ཡོ༌འཤ༌ཤི༌ བུ༌ཚ༌ གི༌དི༌འོན༌ནི༌ ང༌དང༌གུན༌ལ༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌པོ༌ ཨིན༌ནོག༌། དཀོན༌མཆོག༌གི༌ མི༌དིའན༌པ༌ དང༌ ཞན༌ ཚང༌མ༌ ཁོའེ༌ ལག༌ག༌ སལ༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","གི༌དི༌འོན༌ལ༌ ཉི༌ལམ༌ དང༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ཁན༌བོ༌ ཚོར༌ར༌ཅིག༌ ཁོའེ༌ པུག༌དོང༌ ཙུགས༌ཏེ༌ གོ༌ སྒུས༌ ཡང༌ ཡ༌ཝའ༌ ཅོལས༌། ཏེ༌ནེ༌ ཁོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ དུགས༌ཏེ༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ ཁོང༌གུན༌ལ༌ བོད༌ཏེ༌ ཟེརས༌, “ལོང༌ཤིག༌། ཡ༌ཝའེ༌ ཁྱོ༌ཞའེ༌ ལག༌ག༌ མི༌དིའན༌པ༌ དང༌ ཞན༌ ཚང༌མ༌ སལ༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","ཁོའེ༌ མི༌ སུམ༌གྱ༌བོ༌ སྡེ༌ སུམ༌མི༌ ནང༌ང༌ བགོས༌ ཡང༌ མི༌ རེ༌རེའ༌ ར༌ཅོའེ༌ ཏུང༌ དང༌ འོད༌ ཡོད༌ཁན༌ནི༌ ཟ༌མ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","ཡང༌ གི༌དི༌འོན༌ནི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ ང༌ ལྟེན༌ དུག༌། ང༌ གྲ༌འོ༌གུན༌ དུག༌སའེ༌ ཀུར༌རི༌ དུན༌ལ༌ ལེབ༌བ༌ཅིག༌ ངའེ༌ ཅོ༌ཁན༌ ཙོགས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","ང༌ དང༌ ང༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ ཚང༌མའེ༌ ཏུང༌ ཕུའ༌ཅིག༌ ཁྱོ༌ཞའ༌ ཀུར༌གུན༌ ཡོད༌སའེ༌ ནས༌ས༌ སྐོར༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མེའང༌ ཏུང༌ ཕུས༌ཏེ༌ ‘ཡ༌ཝ༌ དང༌ གི༌དི༌འོན༌ནི༌ ཕིའ༌’ ཟེར༌ཏེ༌ ཀུ༌ཅོ༌ ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","ཚན༌ སྐྱིལ༌ལི༌ སང༌ སྔུན༌ལ༌, སྲུང༌ཁན༌གུན༌ སྤོས༌ཏེ༌ སྟིང༌ནེ༌ གི༌དི༌འོན༌ དང༌ ཁོ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ མག༌མི༌ 100 མི༌དིའན༌པའེ༌ ཀུར༌གུན༌ནི༌ དུན༌ལ༌ ལེབ༌བ༌ཅིག༌ ཁོང༌གུན༌ནི༌ ཏུང༌ ཕུས༌ཏེ༌ ཟ༌མ༌གུན༌ ཅགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","ཏེ༌ནེ༌ ཞན༌ སྡེ༌ གུན༌ནིའང༌ ཏུང༌ ཕུས༌ ཡང༌ ཟ༌མ༌གུན༌ ཅགས༌། ཁོང༌གུན༌ནི༌ ལག༌པ༌ ཡོ༌མའེ༌ ནང༌ང༌ འོད༌ ཡང༌ ཡས༌པའེ༌ ནང༌ང༌ ཏུང༌ ཁུར༌ཏེ༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཡ༌ཝ༌ དང༌ གི༌དི༌འོན༌ནི༌ ཕིའ༌ ང༌ཞའེ༌ ར༌འི༌གུན༌ ཀོལ༌ལད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","གི༌དི༌འོན༌ནི༌ མག༌མི༌ ཀུར༌གུན༌ ཡོད༌སའེ༌ ནས༌ས༌ གང༌པོ༌ སྐོར༌ཏེ༌ ཁོང༌རང༌གུན༌ནི༌ ནས༌སའེ༌ཀ༌ སྟན༌པོ༌ དུགས༌ ཡང༌ མི༌དིའན༌པ༌ ཚང༌མ༌ ཐེ༌ཚོམས༌སི༌ ནང༌ང༌ ཀུ༌ཅོ༌ ཏང༌ཨིན༌ ཤོར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","ཨིས༌ར༌ཨེལ༌པ༌ སུམ༌ གྱའེ༌ ཏུང༌གུན༌ ཕུའ༌ཅིག༌ ཡ༌ཝའེ༌ མི༌དིའན༌པའེ༌ མག༌མི༌ ཁོ༌རང༌ ཅིག༌ དང༌ ཅིག༌གི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ཏེ༌ ར༌འི༌ ཉམ༌པོ༌ སད༌ ཅུག༌ག༌ ཛདས༌། མ༌ ཤི༌ཁན༌གུན༌ ཟེ༌རེ༌རཧ༌ ཆོགས༌ལ༌ བེཐ༌ ཤིཏ༌ཏཧ༌, ཐག༌རིང༌ ཏབ༌བཐ༌ཐི༌ ཉེ༌མོའ༌ ཨ༌བེལ༌ མེ༌ཧོ༌ལཧའེ༌ སན༌ཚམས༌ ཚོག༌པ༌ ཤོར༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ མ༌ནས༌ས༌, ནཕ༌ཐལ༌ལི༌ དང༌ ཨ༌ཤེར༌ སྡེ༌གུན༌ནི༌ མག༌མི༌གུན༌ བོདས༌ ཡང༌ ཁོང༌གུན༌ནི༌ མི༌དིའན༌པ༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","གི༌དི༌འོན༌ནི༌ ཨེཕ༌ར༌ཡིམ༌པའེ༌ རི༌ཡུལ༌ གང༌པོའེ༌ ནང༌ང༌ ལོན༌ ཀལ༌ཏེ༌ ཟེརས༌, “ཐུར༌ལ༌ བབས༌ཏེ༌ མི༌དིའན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ ཐག༌རིང༌ བེཐ༌ བ༌རཧ༌ ཚག༌པ༌ ཡོངས༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཆ༌སའེ༌ ནས༌ས༌ ཚང༌མ༌ ཀོའག༌ཤིག༌།” ཏེ༌བོའེ༌ཕིའ༌ ཨེཕ༌ར༌ཡིམ༌པ༌ ཚང༌མ༌ ཡོངས༌ཏེ༌ ཐག༌རིང༌ བེཐ༌ བ༌རཧ༌ ཚག༌པའེ༌ ནས༌ས༌གུན༌ ཀགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","ཁོང༌གུན༌ནི༌ མི༌དིའན༌པའེ༌ མག༌སྤོན༌ ཨོ༌རེབ༌ དང༌ ཟེའེབ༌ ཉིས༌ཀོ༌ ཟུམས༌ཏེ༌ ཨོ༌རེབ༌ ཨོ༌རེབ༌བི༌ རྡོའེ༌ཀ༌ ཡང༌ ཟེའེབ༌ ཟེའེབ༌བི༌ རྒུན༌ཆང༌ ཙིར༌སའེ༌ ནས༌སའེ༌ཀ༌ སདས༌། ཁོང༌གུན༌ནི༌ མི༌དིའན༌པ༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེརས༌ ཡང༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ དུན༌ལ༌ དུགས༌ཏེ༌ ཡོད༌ཁན༌ གི༌དི༌འོན༌ལ༌ ཨོ༌རེབ༌ དང༌ ཟེའེབ༌ ཉིས༌ཀོའེ༌ གོ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","ཏེ༌ནེ༌ ཨེཕ༌ར༌ཡིམ༌པ༌གུན༌ནི༌ གི༌དི༌འོན༌ལ༌ ཏྲིས༌, “ཉེ༌རང༌ངི༌ ང༌ཞའ༌ ཉམ༌པོ༌ ཏེ༌ཟུག༌ ཅིའ༌ ཅོས༌པིན༌? མི༌དིའན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ ཆ༌ ཟ༌ནེ༌ ཉེ༌རང༌ངི༌ ང༌ཞ༌གུན༌ལ༌ ཅིའ༌ མ༌བོད༌པིན༌?” ཁོང༌གུན༌ནི༌ སྲོ༌ ཉམ༌པོ༌ གི༌དི༌འོན༌ལ༌ སྐྱོན༌རྗོད༌ སྲན༌ཏྲེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","ཨིན༌ནའང༌ གི༌དི༌འོན༌ནི༌ ལན༌ཏངས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ ཅོ༌ཁན༌བོ༌ ཉམ༌པོ༌ ལྡུར༌ན༌ ངའེ༌ ཅའང༌ མ༌ཅོའ༌ ཨིན༌ནོག༌། ང༌ཞའ༌ ཨ༌བིའེ༌ཟེར༌པ༌གུན༌ནི༌ སྟོན༌ཐོག༌ གང༌པོ༌ རྔ༌ཁན༌བོའེ༌ སང༌ ཁྱོ༌ཞའ༌ ཨེཕ༌ར༌ཡིམ༌པ༌གུན༌ནི༌ ལུས༌ཁན༌ནི༌ སྟོན༌ཐོག༌ ལྡུམ༌ཁན༌བོ༌ མང༌ང༌ རིན༌ཅན༌ མ༌ནོག༌ག༌? ");
INSERT INTO lbj_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","དཀོན༌མཆོག༌གི༌ ཨོ༌རེབ༌ དང༌ ཟེའེབ༌ མི༌དིའན༌པ༌ མག༌སྤོན༌གུན༌ ཁྱོ༌ཞའེ༌ ལག༌ག༌ སལས༌། ཁྱོ༌ཞ༌གུན༌ནི༌ ཅོ༌ཁན༌བོ༌ ཉམ༌པོ༌ ལྡུར༌ན༌, ངའེ༌ ཅའང༌ མ༌ཅོའ༌ ཨིན༌ནོག༌།” ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ ཨེཕ༌ར༌ཡིམ༌པ༌གུན༌ནི༌ སྲོ༌ ཞུ༌ཏེ༌ མེད༌ཁན༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","གི༌དི༌འོན༌ དང༌ ཁོའེ༌ མི༌ 300 ངལ༌ཏེ༌ ཡོད༌ནའང༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ གྲ༌འོ༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","ཁོང༌གུན༌ སུ༌ཀོད༌ལ༌ ལེབ༌བ༌ཅིག༌ གི༌དི༌འོན༌ནི༌ གྲོང༌ཁྱེར༌པ༌གུན༌ལ༌ ཟེརས༌, “ཇུ༌ཇུ༌ ངའེ༌ མི༌གུན༌ལ༌ ཟའ༌ཅེས༌ལ༌ ཟན༌ སལ༌, ཁོང༌གུན༌ མ༌སྲན༌ཏྲེ༌ ངལ༌ཏེ༌ ཡོད༌། ང༌ཞའེ༌ མི༌དིའན༌པའེ༌ གྱལ༌པོ༌ ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ན༌ གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེར༌ཅེས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","ཨིན༌ནའང༌ སུ༌ཀོད༌དི༌ སྤོན༌བོ༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའེ༌ ཁྱོ༌རང༌ངི༌ མག༌མི༌གུན༌ལ༌ ཟའ༌ཅེས༌ལ༌ ཟན༌ ཏང༌ཅེས༌, ཅི༌ ཁྱོ༌རང༌ངི༌ ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ན༌ ཟུམས༌ཏེ༌ ཁྱོངས༌པིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ ཟེརས༌, “ཡ༌ཝའེ༌ ང༌ཞའ༌ ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ནའེ༌ཀ༌ གྱལ༌ཁ༌ སལ༌ལ༌ཅིག༌ ང༌ཞའ༌ ལོགས༌ཏེ༌ ཡོང༌ཏེ༌ ཁྱོ༌ཞའ༌ ཤ༌རྗེན༌ ཅོས༌ཏེ༌ ཐང༌ངི༌ ཚེར༌མང༌ དང༌ སེ༌ཡའ༌ མེན༌ཏོག༌གི༌ སྐང༌ ཉམ༌པོ༌ ཆད༌པ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","ཏེ༌ཀ༌ནེ༌ གི༌དི༌འོན༌ ཀེན༌ལ༌ པེ༌ནིལ༌ལ༌ སོང༌ ཡང༌ ཁོང༌གུན༌ལའང༌ ཟའ༌ཅེས༌ལ༌ ཟན༌ ཏོང༌ ཟེརས༌། ཁོང༌གུན༌ནིའང༌ སུ༌ཀོད༌པ༌གུན༌ ཙོགས༌ ལན༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","ཁོའེ༌ པེ༌ནིལ༌པ༌གུན༌ལ༌ ཟེརས༌, “གྱལ༌ཁ༌ ཐོབ༌ཏེ༌ སྟིང༌ནེ༌ ང༌ ཡོངས༌ཏེ༌ འི༌ པི༌འུ༌ ཁྲེས༌ཏོར༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","ཏ༌ ཤར༌ ཆོགས༌སི༌ མག༌མི༌ 1,20,000 ཤི༌, ཨིན༌ནའང༌ མ༌ཤིའ༌ ལུས༌ཁན༌ 15,000 ཀཪ༌ཀོར༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ན༌ ཉམ༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","ནོ༌བཧ༌ དང༌ ཡོག༌བེ༌ཧཧ༌ གྲོང༌སེབ༌གུན༌ནི༌ ཤར༌ཆོགས༌, རེ༌བོ༌ ཁུར༌ཁན༌གུན༌ གྲུལ༌སའེ༌ ལམ༌ནེ༌ གི༌དི༌འོན༌ སོང༌ ཡང༌ ཧུན༌མེད༌ལ༌ མི༌དིའན༌པའེ༌ མག༌མི༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ ཧ༌ལས༌ཤུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","མི༌དིའན༌པའེ༌ གྱལ༌པོ༌ ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ན༌ གུན༌ ཤོར༌ཏེ༌ སོང༌ ཨིན༌ནའང༌ གི༌དི༌འོན༌ནི༌ ཁོང༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེརས༌ ཡང༌ ཁོང༌གུན༌ ཟུམས༌། ཏེ༌ནེ༌ མག༌མི༌ ཚང༌མའེ༌ ནང༌ང༌ ཇིགས༌ནང༌ སྐྱེས༌ཏེ༌ ཧན༌གྲང༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","གི༌དི༌འོན༌ ཧེ༌རེས༌སི༌ ལ༌ གྱུད༌ཏེ༌ ལོགས༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","ཏེ༌རུ༌ ཁོའེ༌ སུ༌ཀོད༌པ༌ ཞུ༌ནུ༌ ཞིག༌ ཟུམས༌ཏེ༌ གྲོང༌ཁྱེར༌རི༌ སྤོན༌བོ༌ དང༌ འུ༌སྐྱོང༌ 77 ནི༌ མིང༌གུན༌ བྲི༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","ཏེ༌ནེ༌ གི༌དི༌འོན༌ སོང༌ཏེ༌ སུ༌ཀོད༌པ༌གུན༌ལ༌ ཟེརས༌, “ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ན༌ འི༌ཀ༌ནེ༌, ངའ༌ མ༌བེབས༌ ཅོས༌ཏེ༌ ཁྱོ༌རང༌གུན༌ནི༌ ཟེརས༌, ‘ང༌ཞའེ༌ ཁྱོ༌རང༌ངི༌ ངལ༌ཏེ༌ ཡོད༌ཁན༌ མག༌མི༌གུན༌ལ༌ ཟའ༌ཅེས༌ ཅིའ༌ ཏང༌ཨིན༌, ཅི༌ ཁྱོ༌རང༌ངི༌ ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ན༌ ཟུམས༌ཏེ༌ ཁྱོངས༌པིན༌ན༌?’” ");
INSERT INTO lbj_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","གི༌དི༌འོན༌ནི༌ གྲོང༌ཁྱེར༌རི༌ འུ༌སྐྱོང༌ དང༌ སྤོན༌བོ༌ གུན༌ ཁྱེརས༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཐང༌སྟོང༌ངི༌ ཚེར༌མངས༌ དང༌ སེ༌ཡའ༌ མེན༌ཏོག༌གི༌ སྐང༌ ཉམ༌པོ༌ ཆད༌པ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","ཁོའེ༌ པེ༌ནིལ༌ལི༌ པི༌འུའང༌ ཤིགས༌ཏེ༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ དུག༌ཁན༌ནི༌ བུ༌ཚ༌ ཚང༌མ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ན༌ ཏྲིས༌, “ཏྲ༌བོར༌རི༌ ནང༌ང༌ ཀ༌ཟུག༌ མི༌རིག༌ ཁྱོ༌རང༌གུན༌ནི༌ སད༌པིན༌?” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཉེ༌རང༌ ཙོགས༌ མི༌ རིག༌། ཁོང༌ ཚང༌མ༌ གྱལ༌པོའེ༌ བུ༌ཚ༌ ཙོགས༌ ཐོང༌ དུག༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","གི༌དི༌འོན༌ནི༌ ལན༌ཏངས༌, “ཁོང༌གུན༌ ངའེ༌ སྤུན༌ལ༌, ངའེ༌ ཨ༌མའེ༌ བུ༌ཚ༌གུན༌ ཨིན༌པིན༌། ཡ༌ཝ༌ སོན༌པོའེ༌ ཚན༌ནི༌ ནང༌ང༌ ཀལ༌ཏེས༌ ཁྱོ༌རང༌གུན༌ནི༌ ཁོང༌གུན༌ མ༌སད༌པིན༌ན༌ ངའེ༌ ཁྱོ༌རང༌གུན༌ མ༌སད༌ད༌ ཡོད༌གྲོ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","གི༌དི༌འོན༌ནི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཆེ༌ཤོག༌ ཡེ༌ཐེར༌ ཆོགས༌ལ༌ ལྟས༌ཏེ༌ ཟེརས༌, “ཁོང༌གུན༌ སོད༌” ཨིན༌ནའང༌ ཡེ༌ཐེར༌ ཞུ༌ནུ༌ཞིག༌ ཨིན༌ཅེས༌པའེ༌ ཁོ༌ ཇིགས༌ཏེ༌ ཁོ༌རང༌ངི༌ ར༌འི༌ མ༌ ཕིངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","ཏེ༌ནེ༌ ཟེ༌བཧ༌ དང༌ ཟལ༌མུན༌ནའེ༌ གི༌དི༌འོན༌ལ༌ ཟེརས༌, “བུ༌ཚའེ༌ ལས༌པོ༌ ཕྲུ༌གུ༌ཞིག༌ག༌ ཅིའ༌ སྟད༌དད༌? ལོངས༌། ཁྱོ༌རང༌ རང༌ངི༌ ང༌ཞའ༌ སོད༌།” ཏེ༌ནེ༌ གི༌དི༌འོན༌ནི༌ ཁོང༌ ཉིས༌ཀོ༌ སདས༌ ཡང༌ ཁོང༌ངི༌ རྔ༌བོང༌གུན༌ནི༌ ཇིང༌བའེ༌ཀ༌ ཏགས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ སེར༌རི༌ གྱན༌ཆ༌གུན༌ པུད༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གི༌དི༌འོན༌ལ༌ ཟེརས༌, “ང༌ཞའེ༌ སྤོན༌བོ༌ གྱུར༌། ཉེ༌རང༌, ཉེ༌རང༌ངི༌ བུ༌ཚ༌ དང༌ ཚ༌འོ༌ གུན༌ནི༌ ང༌ཞ༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ གོས༌ ཅིའ༌ཟེར༌ན༌ ཉེ༌རང༌ངི༌ ང༌ཞའ༌ མི༌དིའན༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","ཨིན༌ནའང༌ གི༌དི༌འོན༌ནི༌ ལན༌ཏངས༌, “ང༌ དང༌ ངའེ༌ བུ༌ཚ༌གུན༌ནི༌ ཁྱོ༌ཞའེ༌ཀ༌ ཝང༌ མི༌སྲུལ༌། ཡ༌ཝའེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","ཨིན༌ནའང༌ ངའ༌ ཞུ༌ཝ༌ཞིག༌ ཡོད༌, ཁྱོ༌ཞའ༌ རེ༌རེའེ༌ ཅོམས༌ཁན༌ནི༌ གྱུ༌ནོར༌ ཁྱོ༌ཞའེ༌ ཁག༌གི༌ ནང༌ནེ༌ ངའ༌ ནམ༌ཅོག༌གི༌ ཨ༌ལི༌ ཅིག༌ ཏོང༌།” ༼མི༌དིའན༌པ༌གུན༌ ཨིཤ༌མ༌ཨེལ༌ལི༌ གྱུད༌ནེ༌ ཨིན༌ཅེས༌པའེ༌ སེར༌རི༌ ནམ༌ཅོག༌གི༌ ཨ༌ལི༌ ཏག༌གད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཐད༌པོ༌ ཉམ༌པོ༌ ཏང༌ཨིན༌།” ཁོང༌གུན༌ནི༌ རས༌ཤིག༌ ཏིངས༌ ཡང༌ མི༌ རེ༌རེའེ༌ ཅོམས༌ཁན༌ནི༌ གྱུ༌ནོར༌ ཁོ༌རང༌གུན༌ནི༌ ཁག༌གི༌ ནང༌ནེ༌ སེར༌རི༌ ནམ༌ཅོག༌གི༌ ཨ༌ལི༌ ཅིག༌ ཕངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","ལྡུམས༌ཁན༌ནི༌ སེར༌རི༌ ནམ༌ཅོག༌གི༌ ཨ༌ལི༌ ལྕིད༌པོ༌ ཀི༌ལོ༌ 19.5 ཡོད༌པིན༌། ཏེ༌བོའེ༌ ནང༌ང༌ མི༌དིའན༌ནི༌ གྱལ༌པོ༌གུན༌ནི༌ གྱན༌ཆ༌ དང༌ ཀོས༌ལག༌ ཡང༌ ཁོང༌ངི༌ རྔ༌བོང༌གུན༌ནི༌ ཀ༌ནེ༌ པུད༌ཏེ༌ ཁྱོང༌ཁན༌ནི༌ གྱན༌ཆ༌གུན༌ མ༌ཐེའ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","གི༌དི༌འོན༌ནི༌ ཏེ༌ སེར༌ ཉམ༌པོ༌ ཏམ༌པ༌ ཨེ༌ཕོད༌ ཡང༌ན༌ སྟུད༌ཏུང༌ ཞིག༌ ཅོས༌ཏེ༌ ཁོ༌རང༌ངི༌ གྲོང༌ཁྱེར༌ ཨོཕ༌རཧ༌ ནང༌ང༌ བོརས༌། ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཏེ༌བོའ༌ ཅོལ༌ཅེས༌ གོ༌ཟུག༌ ཡང༌ གི༌དི༌འོན༌ དང༌ ཁོའེ༌ ནང༌ཚ ངས༌ ཚང༌མའང༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ མ༌ཅོལ༌ལ༌ ཏེ༌བོའ༌ ཅོལ༌ཅེས༌སི༌ ནང༌ང༌ ཁད༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","ཏེན༌ན༌ ཟུག༌གི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མི༌དིའན༌པ༌གུན༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། མི༌དིའན༌པ༌གུན༌ ཤེད༌ཅན༌ གྱུར༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ མ༌ནེ༌ ནོལ༌ མ༌ཐུབ༌། གི༌དི༌འོན༌ སོན༌ཏེའ༌ ཡོད༌ཏུས༌ ལོ༌ 40 ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ཞི༌དེ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","ཡོ༌འཤ༌ཤི༌ བུ༌ཚ༌ གི༌དི༌འོན༌ ལོགས༌ཏེ༌ ཁང༌པ༌ མི༌ཚེ༌ པུད༌ད༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","ཁོ༌ བུ༌ཚ༌ རྡུན༌ཅུའི༌ ཨ༌བ༌ གྱུར༌ ཅིའ༌ཟེར༌ན༌ ཁོའ༌ ན༌མ༌ མང༌པོ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","ཤེ༌ཀེམ༌མི༌ ནང༌ང༌ ཁོའེ༌ ཚེ༌ཡོག༌ ན༌མའ༌ བུ༌ཚ༌ཞིག༌ སྐྱེས༌ ཀ༌བོའེ༌ མིང༌ང༌ ཁོའེ༌ ཨ༌བི༌མེ༌ལེག༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","གི༌དི༌འོན༌ རྒད༌པོ༌ སོང༌ཏེ༌ ཤི༌ ཡང༌ ཁོའེ༌ སྤུར༌ ཨོཕ༌རཧ༌ ནང༌ང༌ ཨ༌བིའེ༌ཟེར༌རི༌ གྱུད༌ཟིན༌ ཡོ༌འཤ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ སྤུར༌ཁང༌ངི༌ ནང༌ང༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","གི༌དི༌འོན༌ ཤི༌ཏེ༌, ཏུས༌ མང༌པོ༌ མ༌ཆ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ བའལ༌ ཟེར༌ཁན༌ནི༌ སྐུན༌དྲ༌གུན༌ལ༌ ཅོལ༌ཅེས༌ གོ༌ཟུག༌། ཁོང༌གུན༌ནི༌ བའལ༌ བེ༌རིཐ༌ ལྷ༌ ཅོས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","ཆོགས༌ ཚང༌མ༌ནེ༌ ཡོང༌ཁན༌ནི༌ གྲ༌འོ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌བ༌ ཛད༌ཁན༌ནི༌ ཁོ༌རང༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝ༌ རྗེདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","ཁོང༌གུན༌ནི༌ ཡེ༌རུབ༌བའལ༌ ཡང༌ན༌ གི༌དི༌འོན༌ནི༌, ཁོང༌གུན༌ནི༌ ཕིའ༌ ཟང༌པོ༌ ལས༌ ཅོ༌ཁན༌ ཚང༌མ༌ རྗེད༌ཏེ༌ ཁོའེ༌ ནང༌ཚངས༌ལ༌ ཆོགས༌སྐྱོར༌ མ༌ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","ཞག༌ཤིག༌ གི༌དི༌འོན༌ནི༌ བུ༌ཚ༌ ཨ༌བི༌མེ༌ལེག༌ ཤེ༌ཀེམ༌མ༌ ཁོའེ༌ ཨ༌མའེ༌ མིང༌བོ༌གུན༌ལ༌ ཐུག༌ག༌ སོང༌ ཡང༌ ཁོང༌གུན༌ དང༌ ཁོའེ༌ ཨ༌མའེ༌ ཉེན༌ ཚང༌མ༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“ཤེ༌ཀེམ༌མི༌ འུ༌སྐྱོང༌ ཚང༌མ༌ ཏྲིས༌, ‘ཁྱོ༌ཞ༌གུན༌ནི༌ཀ༌ གི༌དི༌འོན༌ནི༌ བུ༌ཚ༌ 70 ཝང༌ སྲུལ༌ན༌ གྱལ༌ཅེས༌ རག༌ག༌ ཡ༌ མི༌ ཅིག༌གི༌?’ ང༌ ཁྱོ༌ཞའེ༌ ཤ༌ཁྲག༌ ཨིན༌ཁན༌བོ༌ ཨིད༌ཏུ༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","ཏེ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཨ༌ཞང༌གུན༌ནི༌ ཁོའེ༌ ཟེར༌ཁན༌ ཚང༌མ༌ ཤེ༌ཀེམ༌མི༌ འུ༌སྐྱོང༌གུན༌ལ༌ ཤདས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ཆོགས༌སྐྱོར༌ ཅོ༌ཅེས༌ ཐག༌ཅད༌ཏེ༌ ཟེརས༌, “ཁོ༌ ང༌དང༌གུན༌ནི༌ ཉེན༌གྲུང༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","ཁོང༌གུན༌ནི༌ བའལ༌ བེ༌རིཐ༌ཐི༌ ཆོད༌ཁང༌ངི༌ ནང༌ནེ༌ མུལ༌ལི༌ པེ༌ནེ༌ 70 ཁོའ༌ ཏངས༌ ཡང༌ ཁོའེ༌ ཏེ༌བོ༌ ཁྲིམས༌མེད༌དི༌ མི༌གུན༌ ཁོའེ༌ སྟིང༌རང༌ནེ༌ ཁྱོང༌ཅེས༌ལ༌ ཀོལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","ཁོ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པ༌ ཨོཕ༌རཧ༌ སོང༌ཏེ༌ ཕོ༌ལོངས༌ ཅིག༌གི༌ཀ༌ གི༌དི༌འོན༌ནི༌ བུ༌ཚ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌ 70 སདས༌། ཨིན༌ནའང༌ གི༌དི༌འོན༌ནི༌ བུ༌ཚ༌ ཆུང༌ཤོག༌ ཡོ༌ཐམ༌ ཨིབས༌ཏེ༌ ཤོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","ཏེ༌ནེ༌ ཤེ༌ཀེམ༌པ༌ དང༌ བེཐ༌ མིལ༌ལོ༌པ༌ ཚང༌མ༌ ཤེ༌ཀེམ༌མི༌ རྡོའེ༌ཀ༌ ཨོག༌ ལྕང༌མའེ༌ དུན༌ལ༌ ཛོམས༌ཏེ༌ ཨ༌བི༌མེ༌ལེག༌ ཁོང༌གུན༌ནི༌ གྱལ༌པོའ༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","ཏེ༌བོའེ༌ སྐོར༌ལ༌ ཡོ༌ཐམ༌མའ༌ ཚོར༌ར༌ཅིག༌ ཁོ༌ གེ༌རི༌ཟིམ༌ རི༌ གོའ༌ ཛགས༌ ཡང༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཤེ༌ཀེམ༌པ༌གུན༌ ངའེ༌ སྤེ༌ར༌ ཉོན༌ཤིག༌, ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌ཞ༌གུན༌ལ༌ སན༌ སྲིད༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","ཞག༌ཤིག༌ ལྕང༌མ༌གུན༌ནི༌ གྱལ༌པོ༌ ལྡམ༌ཅེས༌ ཐག༌ཅད༌། གོ༌མ༌ ཏེ༌གུན༌ནི༌ ཨོ༌ལི༌ཝིའི༌ ལྕང༌མ༌ ཟེརས༌, ‘ང༌ཞ༌གུན༌ནི༌ གྱལ༌པོ༌ གྱུར༌།’ ");
INSERT INTO lbj_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","ཨིན༌ནའང༌ ཨོ༌ལི༌ཝིའི༌ ལྕང༌མེའེ༌ ཟེརས༌, ‘ཁྱོ༌ཞ༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ཅེས༌ལ༌ ཅི༌ ངའེ༌ ལྷ༌ལྷ༌མོ༌ དང༌ མི༌ གུན༌ལ༌ རྩི༌ཝ༌ ཏང༌ཁན༌ནི༌ ཨོ༌ལི༌ཝིའི༌ མར༌ནག༌ ཕིང༌ཅེས༌པོ༌ ཕང༌ང༌?’” ");
INSERT INTO lbj_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","“ཏེ༌ནེ༌ ཏེ༌གུན༌ནི༌ ཕིག༌གི༌ ལྕང༌མ༌ ཟེརས༌, ‘ང༌ཞ༌གུན༌ནི༌ གྱལ༌པོ༌ གྱུར༌།’ ");
INSERT INTO lbj_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","ཨིན༌ནའང༌ ཕིག༌གི༌ ལྕང༌མའེ༌ ཟེརས༌, ‘ཁྱོ༌ཞ༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ཅེས༌ལ༌ ཅི༌ ངའེ༌ ང༌རང༌ངི༌ ཁ༌ཟས༌ ངར༌མོ༌ དང༌ ཞིམ༌པོ༌ ཆག༌ཤེས༌པོ༌ ཕང༌ང༌?’” ");
INSERT INTO lbj_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","“ཏེ༌ནེ༌ ཏེ༌གུན༌ནི༌ རྒུན༌ནི༌ ལྕང༌མ༌ ཟེརས༌, ‘ང༌ཞ༌གུན༌ནི༌ གྱལ༌པོ༌ གྱུར༌།’ ");
INSERT INTO lbj_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","ཨིན༌ནའང༌ རྒུན༌ནི༌ ལྕང༌མའེ༌ ཟེརས༌, ‘ཁྱོ༌ཞ༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ཅེས༌ལ༌ ཅི༌ ངའེ༌ ལྷ༌ལྷ༌མོ༌ དང༌ མི༌ གུན༌ ཐད༌ ཅུག༌ཁན༌ནི༌ རྒུན༌ཆང༌ ཕིང༌ཅེས༌པོ༌ ཕང༌ང༌?’” ");
INSERT INTO lbj_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","“ཏེ༌ནེ༌ ཏེ༌གུན༌ནི༌ སྟིང༌ཇུག༌ག༌ ཚེར༌མང༌ངི༌ ལྕང༌མ༌ ཟེརས༌, ‘སྐྱོད༌ ཡང༌ ང༌ཞ༌གུན༌ནི༌ གྱལ༌པོ༌ གྱུར༌།’” ");
INSERT INTO lbj_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","“ཚེར༌མང༌ངི༌ ལྕང༌མ༌གུན༌ལ༌ ལན༌ཏངས༌, ‘ཀལ༌ཏེས༌ ཁྱོ༌ཞའེ༌ དེན༌བའ༌ ང༌ གྱལ༌པོ༌ ཅོའ༌ ཐད༌དད༌ན༌, ཡོང༌ ངའེ༌ ཡལ༌གའེ༌ ཡོག༌ག༌ སྲུང༌སྐྱོབ༌ ལེན༌, ཀལ༌ཏེས༌ མ༌ལེན༌ན༌ ངའེ༌ ནང༌ནེ༌ མེ༌ བིང༌ཏེ༌ ལེ༌བ༌ནོན༌ནི༌ སི༌གྲར༌ ལྕང༌མ༌གུན༌ མེད༌ཁན༌ ཆ༌ཤིག༌།’” ");
INSERT INTO lbj_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","ཡོ༌ཐམ༌མི༌ ཏ༌རུང༌ངའང༌ ཟེརས༌, “ཅི༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཀྲང༌པོ༌ དང༌ སྙིང༌ ལག༌མོ༌ ཉམ༌པོ༌ ཨ༌བི༌མེ༌ལེག༌ ཁྱོ༌ཞའེ༌ གྱལ༌པོ༌ སྐོས༌ཏེ༌ ཨིན༌ན༌? ཅི༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གི༌དི༌འོན༌ དང༌ ཁོང༌ངི༌ ནང༌ཚངས༌ ཉམ༌པོ༌ འོས༌པ༌ ཅོས༌ཏེ༌ ཨིན༌ན༌ ཡང༌ ཁོང༌ང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ འོས༌པ༌ ཨིན༌ཁན༌བོ༌ ཏངས༌ཏེ༌ ཨིན༌ན༌? ");
INSERT INTO lbj_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","ངའེ༌ ཨ༌བའེ༌ ཁོང༌རང༌ངི༌ སྲོག༌ ཇིགས༌པའེ༌ ནང༌ང༌ ཏངས༌ཏེ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཕིའ༌ ནོལས༌ ཡང༌ མི༌དིའན༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཁྱོ༌ཞའ༌ ཐར༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","ཨིན༌ནའང༌ དི༌རིང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའེ༌ ཨ༌བ༌ དང༌ ཁོང༌ངི༌ ནང༌ཚངས༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ངོ༌ལོག༌ ཅོས༌ཏེ༌ ཁོང༌ངི༌ བུ༌ཚ༌ 70 ཕོ༌ལོངས༌ ཅིག༌གི༌ཀ༌ སདས༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཉེན༌གྲུང༌ ཨིན༌ཅེས༌པོའེ༌ ཁོང༌ངི༌ ཚེ༌ཡོག༌ ན༌མའེ༌ བུ༌ཚ༌ ཨ༌བི༌མེ༌ལེག༌ གྱལ༌པོའ༌ ལྡམས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","ཀལ༌ཏེས༌ དི༌རིང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ གི༌དི༌འོན༌ དང༌ ཁོའེ༌ ནང༌ཚངས༌གུན༌ལ༌ སྙིང༌ ཀྲང༌པོ༌ནེ༌ རྩི༌ཝ༌ ཏངས༌ཏེ༌ ཨ༌བི༌མེ༌ལེག༌ གྱལ༌པོའ༌ ལྡམས༌ཏེ༌ ཨིན༌ན༌ ཁྱོ༌ཞའེ༌ ཁོའ༌ ཡང༌ ཁོའེ༌ ཁྱོ༌ཞའ༌ ཐད༌པོ༌ དང༌ གའ༌མོ༌ ཁྱོང༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","ཨིན༌ནའང༌ ཏེ༌ཟུག༌ མན༌ན༌ ཏེ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ནང༌ནེ༌ མེ༌ བིང༌ཏེ༌ ཤེ༌ཀེམ༌ དང༌ བེཐ༌ མིལ༌ལོ༌པ༌ ཚང༌མ༌ མེད༌ཁན༌ ཆ༌ཤིག༌ ཡང༌ ཁྱོ༌ཞའེ༌ ནང༌ནེ༌ མེ༌ བིང༌ཏེ༌ ཁོ༌ མེད༌ཁན༌ ཆ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","ཏེ༌ནེ༌ ཡོ༌ཐམ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ཇིགས༌ པ༌སང༌ ཁོ༌ ཤོར༌ཏེ༌ བེར༌རི༌ ནས༌སའེ༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཝང༌སྲུལ༌ཏེ༌ ལོ༌ སུམ༌ ཆའ༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","དཀོན༌མཆོག༌གི༌ ངན༌པའེ༌ སེམས༌ཉིད༌ ཀལ༌ལ༌ ཛད༌ཏེ༌ ཨ༌བི༌མེ༌ལེག༌ དང༌ ཤེ༌ཀེམ༌པ༌ གུན༌ནི༌ པར༌ལ༌ དྲའ༌ལངས༌ ཅུག༌ག༌ ཛདས༌པ༌ ཁོང༌གུན༌ནི༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ངོ༌ལོག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","དཀོན༌མཆོག༌གི༌ ཏེ༌བོ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ གི༌དི༌འོན༌ནི༌ བུ༌ཚ༌ 70 སད༌ཅེས༌ ཡང༌ ཤེ༌ཀེམ༌པ༌གུན༌ནི༌ ཁོའ༌ ཏེ༌བོའེ༌ ནང༌ང༌ རོགས༌ ཅོ༌ཅེས༌ལ༌ ཆད༌པ༌ སལ༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","ཨ༌བི༌མེ༌ལེག༌ སད༌ཅེས༌ལ༌ ཤེ༌ཀེམ༌པ༌ འུ༌སྐྱོང༌གུན༌ནི༌ ཀལ༌ཁན༌ནི༌ མི༌གུན༌ རི༌ ནང༌ང༌ ཨིབས༌ཏེ༌ དུགས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཏེ༌ ལམ༌ནེ༌ གྲུལ༌ཁན༌གུན༌ནའང༌ ཅོམ༌མད༌པིན༌། ཨིན༌ནའང༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ཏེ༌བོའེ༌ སྐོར༌ལ༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","ཏ༌ ཨེ༌བེད༌དི༌ བུ༌ཚ༌ གའལ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ ཉམ༌པོ༌ ཤེ༌ཀེམ༌མ༌ དུག༌ག༌ ཡོངས༌ ཡང༌ ཤེ༌ཀེམ༌པ༌གུན༌ནི༌ ཁོའ༌ ལོ༌ཁྱེལ༌ ཅོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","ཤེ༌ཀེམ༌པ༌གུན༌ནི༌ རྒུན༌ནི༌ སྟོན༌ཐོག༌ ལྡུམས༌ཏེ༌ རྒུན༌ཆང༌ ཙིར༌ཏེ༌ སྟིང༌ནེ༌ ཁོ༌རང༌གུན༌ནི༌ ལྷའེ༌ ཆོད༌ཁང༌ངི༌ ནང༌ང༌ ཏུས༌ཆེན༌ རྩིའད༌པིན༌། ཏེ༌ཏུས༌ ཁོང༌གུན༌ནི༌ ཆང༌ ཐུང༌ཨིན༌ ཟན༌ཟེན༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ངན༌ ཏབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","ཏེ༌ནེ༌ གའལ༌ལི༌ ཟེརས༌, “ཨ༌བི༌མེ༌ལེག༌ སུ༌ ཨིན༌ནོག༌ ཡང༌ ང༌དང༌ ཤེ༌ཀེམ༌པ༌གུན༌ནི༌ ཁོའ༌ ཞབས༌ཏོག༌ ཅིའ༌ ཞུ༌ཨིན༌? ཁོ༌ གི༌དི༌འོན༌ནི༌ བུ༌ཚ༌ ཡང༌ ཟེ༌བུལ༌ ཁོའེ༌ ལྡམས༌ཁན༌ནི༌ སྤོན༌བོ༌ མ༌ནོག༌ག༌? ང༌དང༌ངི༌ ཤེ༌ཀེམ༌པ༌གུན༌ནི༌ ཨ༌བ༌ ཧ༌མོར༌རི༌ བུ༌ཚ༌གུན༌ལ༌ ཞབས༌ཏོག༌ ཞུ༌གོས༌, ཨ༌བི༌མེ༌ལེག༌ག༌ ཞབས༌ཏོག༌ ཅིའ༌ ཞུ༌ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","ཀལ༌ཏེས༌ ངའ༌ ཝང༌ཆ༌ ཡོད༌པིན༌ན༌ ངའེ༌ ཨ༌བི༌མེ༌ལེག༌ ཕིངས༌ཏེ༌ ཏང༌ཅེས༌རག༌། ངའེ༌ ཁོའ༌ ཟེར༌ཨིན༌, ‘མག༌མི༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ ནོལ༌ལ༌ ཡོང༌།’” ");
INSERT INTO lbj_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","ཨིན༌ནའང༌ གྱལ༌སའེ༌ ཀའ༌ལོན༌ ཟེ༌བུལ༌ལ༌ གའལ༌ལི༌ ཟེར༌ཁན༌གུན༌ ཚོར༌ར༌ཅིག༌ ཁོའ༌ སྲོ༌ སྲན༌ཏྲེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","ཁོའེ༌ ཨ༌རུ༌མཧའེ༌ ནང༌ང༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ལོན༌ ཀལ༌ཏེ༌ ཟེརས༌, “ཤེ༌ཀེམ༌མི༌ ནང༌ང༌ དུག༌ག༌ ཡོངས༌ཁན༌ ཨེ༌བེད༌དི༌ བུ༌ཚ༌ གའལ༌ དང༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌གུན༌ནི༌ གྱལ༌སའེ༌ མི༌གུན༌ལ༌ ཉེ༌རང༌ངི༌ གྱབ༌གལ༌ ཅོ༌ཅེས༌ལ༌ ཕུགས༌ ཏང༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","ཉེ༌རང༌ མག༌མི༌ ཉམ༌པོ༌ ཚན༌ལ༌ སྐྱོད༌ཏེ༌ ཞིང༌ངི༌ ནང༌ང༌ ཨིབས༌ཏེ༌ ཞུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","ང༌མོ༌ ཉི༌མ༌ ཤར༌ར༌ཅིག༌ གྱལ༌ས༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ གའལ༌ དང༌ ཁོ༌ ཉམ༌པོ༌ ཡོད༌ཁན༌གུན༌ ཉེ༌རང༌ང༌ ནོལ༌ལ༌ ཡོང༌ང༌ཅིག༌ ཉེ༌རང༌ངི༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཉེ༌རང༌ ཐད༌ཁན༌བོ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","ཏེ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌ དང༌ ཁོའེ༌ མག༌མི༌ ཚང༌མ༌ ཚན༌ལ༌ སོང༌ ཡང༌ སྡེ༌ ཞི༌ ནང༌ང༌ བགོས༌ཏེ༌ ཤེ༌ཀེམ༌མི༌ ཉེ༌མོའ༌ ཞིང༌ངི༌ ནང༌ང༌ ཨིབས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","ང༌མོ༌ གའལ༌ གྱལ༌སའེ༌ སྒོའེ༌ཀ༌ ལངས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌ དང༌ ཁོའེ༌ མག༌མི༌གུན༌ ཨིབ༌སའེ༌ ནས༌ས༌ནེ༌ བིང༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","གའལ༌ལི༌ ཁོང༌གུན༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཟེ༌བུལ༌ལ༌ ཟེརས༌, “ལྟོས༌སའང༌, རི༌ནེ༌ ཐུར༌ལ༌ མི༌གུན༌ ཡོང༌ང༌ལ༌།” ཟེ༌བུལ༌ལི༌ ལན༌ཏངས༌, “མ༌ནོག༌, ཁོ༌རང༌ང༌ རི༌ ཀྲིབ༌ཀྱག༌གུན༌ མི༌ ཙོགས༌ ཐོང༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","ཨིན༌ནའང༌ ཡང༌སྐྱར༌ གའལ༌ལི༌ ཟེརས༌, “ལྟོས༌སའང༌, རི༌ནེ༌ ཐུར༌ལ༌ མི༌གུན༌ ཡོང༌དུག༌ ཡང༌ མཱོ༌ཏབ༌ཁན༌གུན༌ དུག༌སའེ༌ ཨོག༌གི༌ ལྕང༌མའེ༌ ཆོགས༌ནེ༌ ཞན༌ སྡེ༌ཞིག༌ ཡོང༌ང༌ལ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","ཏེ༌ནེ༌ ཟེ༌བུལ༌ལི༌ ཁོ༌ ཟེརས༌, “ཏ༌ ཁྱོ༌རང༌ངི༌ ཨ༌བི༌མེ༌ལེག༌ སུ༌ ཨིན༌ནོག༌ ཡང༌ ང༌དང༌གུན༌ནི༌ ཁོའ༌ ཞབས༌ཏོག༌ ཅིའ༌ ཞུ༌ཨིན༌ ཟེར༌ཏེ༌ སྤེ༌ར༌ ཆེན༌མོ༌ ཏང༌ཁན༌བོ༌ ཀ༌རེ༌? ཁྱོ༌རང༌ངི༌ སྨད༌གྲ༌ ཏང༌ཁན༌ནི༌ མི༌གུན༌, ཁོང༌གུན༌ མ༌ནོག༌ག༌? ཕི༌ལོག༌ག༌ སོང༌ཏེ༌ ཁོང༌གུན༌ལ༌ ནོལ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","ཏེ༌ནེ༌ གའལ༌ལི༌ གོ༌ཁྲིད༌ ཅོས༌ཏེ༌ ཤེ༌ཀེམ༌པ༌གུན༌ ཨ༌བི༌མེ༌ལེག༌གི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","ཨ༌བི༌མེ༌ལེག༌གི༌ མག༌མི༌ ཏེད༌ཏེ༌ ཁྱོངས༌པ༌ གའལ༌ དང༌ ཁོའེ༌ མི༌གུན༌ ཤོར༌ ཡང༌ གྱལ༌སའེ༌ གྱས༌སྒོ༌ ནང༌ཀུག༌ག༌ ལེབ༌བི༌སང༌ སྔུན༌ལ༌ ཤེ༌ཀེམ༌པ༌ མང༌པོ༌ མ༌སྐྱོན༌ སོང༌ཏེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","ཨ༌བི༌མེ༌ལེག༌ ལོགས༌ཏེ༌ ཨ༌རུ༌མཧ༌ སོང༌ ཡང༌ ཟེ༌བུལ༌ལི༌ གའལ༌ དང༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌ གུན༌ ཤེ༌ཀེམ༌ནེ༌ ཕིངས༌ཏེ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","སྟིང༌མ༌ ཞག༌པོ༌ ཤེ༌ཀེམ༌པ༌གུན༌ བིང༌ཏེ༌ ཞིང༌ངི༌ཀ༌ ལས༌ ཅོའ༌ལ༌ སོང༌, ཡང༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ཏེ༌བོའེ༌ སྐོར༌ལ༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","ཁོའེ༌ ཁོ༌རང༌ངི༌ མག༌མི༌གུན༌ སྡེ༌ སུམ༌མི༌ ནང༌ང༌ བགོས༌ ཡང༌ ཞིང༌ངི༌ ནང༌ང༌ ཨིབས༌ཏེ༌ དུགས༌། མི༌གུན༌ གྱལ༌ས༌ནེ༌ ཕི༌ལོག༌ག༌ བིང༌ཏེ༌ ཡོང༌ང༌ཅིག༌ ཁོང༌གུན༌ ཨིབས༌ཏེ༌ ཡོད༌ས༌ནེ༌ བིང༌ཏེ༌ མི༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","ཨ༌བི༌མེ༌ལེག༌ ཉམ༌པོ༌ ཡོད༌ཁན༌ནི༌ སྡེ༌བོ༌ གྱུགས༌ཏེ༌ སོང༌ ཡང༌ གྱལ༌སའེ༌ སྒོ༌ སྒགས༌ཏེ༌ སུའང༌ ནང༌ཀུག༌ག༌ ཆ༌ མ༌ཅུགས༌། ཞན༌ སྡེ༌ ཉིས༌ཀོའེ༌ ཞིང༌གུན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ མི༌གུན༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","ཨ༌བི༌མེ༌ལེག༌གི༌ མག༌མི༌ ཉི༌མ༌ གང༌པོ༌ ནོལས༌ ཡང༌ གྱལ༌ས༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ མི༌གུན༌ སདས༌། ཁང༌པ༌ ཚང༌མ༌ ཤིགས༌ཏེ༌ སྟོན༌ཐོག༌ ཏབ༌སའེ༌ ས༌ཀྱད༌ གང༌པོའ༌ ཚཱ༌ ཡོགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","ཤེ༌ཀེམ༌མི༌ སྟན༌པོ༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ འུ༌སྐྱོང༌གུན༌ནི༌ ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ ཁོང༌གུན༌ ཤོར༌ཏེ༌ ཨེལ༌ བེ༌རིཐ༌ཐི༌ ཆོད༌ཁང༌ངི༌ ཐིལ༌ལ༌ ཨིབ༌སའེ༌ ནས༌སའེ༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","ཨ༌བི༌མེ༌ལེག༌ག༌ ཁོང༌གུན༌ ཆོད༌ཁང༌ངི༌ ནང༌ང༌ ཡོད༌ཁན༌བོ༌ ཚོར༌ར༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","ཁོ༌ ཁོ༌རང༌ངི༌ མག༌མི༌གུན༌ ཉམ༌པོ༌ ཟལ༌མོན༌ རིའ༌ སོང༌ ཡང༌ ཁོའེ༌ སྟ༌རི༌ ཁུར༌ཏེ༌ ལྕང༌མའེ༌ ཡལ༌ག༌ ཁ༌ཅིག༌ ཅད༌ཏེ༌ ཁོ༌རང༌ངི༌ སྤུང༌པའེ༌ཀ༌ ཁུརས༌། ཁོའེ༌ ཁོ༌རང༌ངི༌ མི༌གུན༌ལ༌ ཟེརས༌, “གྱོགས༌པ༌, ངའེ༌ ཅོ༌ཁན༌ ཙོགས༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","ཏེ༌ནེ༌ མག༌མི༌ ཚང༌མའེ༌ ཡལ༌ག༌ ཁུར༌ཏེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ སྟིང༌རང༌ནེ༌ སོང༌། ཁོང༌གུན༌ནི༌ ཡལ༌ག༌གུན༌ ཆོད༌ཁང༌ངི༌ སྒོ༌ དང༌ རྩིག༌པའེ༌ཀ༌ སྤུངས༌ཏེ༌ མེ༌ ཏུགས༌། ཏེ༌ནེ༌ ཤེ༌ཀེམ༌མི༌ སྟན༌པོ༌ ནས༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཧ༌ལམ༌ 1,000 ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","ཏེ༌ སྟིང༌ནེ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཐེ༌བེཟ༌ གྲོང༌ཁྱེར༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","ཨིན༌ནའང༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ ཨིབ༌སའེ༌ པི༌འུ༌ སྟན༌པོ༌ ཡོད༌ཁན༌བོའེ༌ ནང༌ང༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ ཡང༌ འུ༌སྐྱོང༌ ཐེས༌ཏེ༌ གྲོང༌ཁྱེར༌རི༌ མི༌ ཚང༌མ༌ ཤོར༌། ཁོང༌གུན༌ནི༌ ཏེ༌བོའ༌ ནང༌ཀུག༌ནེ༌ ཀུ༌ལིག༌ ཅུགས༌ཏེ༌ པི༌འུའི༌ ཐོག༌གི༌ཀ༌ སོང༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","ཨ༌བི༌མེ༌ལེག༌གི༌ ཏེ༌ པི༌འུའ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ཏེ༌ནང༌ང༌ ཆ༌སའེ༌ སྒོའ༌ མེའ༌ ཐུག༌ཅེས༌ གྲལ༌གྲིག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","ཐོག༌གི༌ཀ༌ ཡོད༌ཁན༌ནི༌ བུ༌མོ༌ཞིག༌གི༌ ལག༌ཐག༌གི༌ རྡོའ༌ ཡོག༌ག༌ ཕངས༌པ༌ ཨ༌བི༌མེ༌ལེག༌གི༌ གོའ༌ ཕོག༌ཏེ༌ ཁོའེ༌ གོའེ༌ རུས༌པ༌ ཅགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","ཨ༌བི༌མེ༌ལེག༌གི༌ ཁོ༌རང༌ངི༌ མག༌ཆ༌ ཁུར༌ཁན༌བོའ༌ ཟེརས༌, “བུ༌མོ༌ཞིག༌གི༌ ངའ༌ སད༌ཏོག༌ མི༌ ཟེར༌ཅེས༌ལ༌ ཁྱོ༌རང༌ངི༌ ར༌འི༌ ཕིང༌ཏེ༌ ང༌ སོད༌།” ཏེ༌ནེ༌ ཁོའེ༌ ཨ༌བི༌མེ༌ལེག༌ག༌ ར༌འི༌ ཙུགས༌ ཡང༌ ཁོ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","ཨ༌བི༌མེ༌ལེག༌གི༌ མག༌མི༌གུན༌ནི༌ ཁོ༌ ཤི༌ཁན༌བོ༌ ཐོང༌ང༌ཅིག༌ ཁོང༌གུན༌ ལོགས༌ཏེ༌ ཁོང༌རང༌གུན༌ནི༌ ཁང༌པ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","ཏེན༌ན༌ ཟུག༌གི༌ དཀོན༌མཆོག༌གི༌ ཨ༌བི༌མེ༌ལེག༌གི༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌ 70 སད༌ཏེ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ གྱབ༌གལ༌ལ༌ ངན༌པ༌ ཅོ༌ཁན༌བོའ༌ ལན༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","དཀོན༌མཆོག༌གི༌ ཤེ༌ཀེམ༌པ༌གུན༌ནི༌ ངན༌པ༌ ཅོ༌ཁན༌བོའང༌ ཆད༌པ༌ སལས༌། གི༌དི༌འོན༌ནི༌ བུ༌ཚ༌ ཡོ༌ཐམ༌མི༌ ངན༌ ཏབ༌ཁན༌བོ༌ དྲན༌དྲའ༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","ཨ༌བི༌མེ༌ལེག༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌ གྲོ༌གྲོའེ༌ ཚ༌འོ༌ ཕུ༌འཧའེ༌ བུ༌ཚ༌ ཏོ༌ལཱ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཐར༌ཅུག༌ཁན༌བོ༌ གྱུར༌། ཁོ༌ ཨིས༌ས༌ཁར༌ མི༌སྡེ༌ནེ༌ ཨིན༌པིན༌ ཡང༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཤ༌མིར༌རི༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ དུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ ལོ༌ 23 ཅོས༌ཏེ༌ སྟིང༌ནེ༌ ཁོ༌ ཤི༌ ཡང༌ ཁོའེ༌ སྤུར༌ ཤ༌མིར༌རི༌ ནང༌ང༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","ཏོ༌ལཱའེ༌ སྟིང༌ནེ༌ གི༌ལེད༌པ༌ ཡ༌འིར༌རི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གོ༌ཁྲིད༌ ལོ༌ 22 ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","ཁོའ༌ བུ༌ཚ༌ སུམ༌ཅུ༌ ཡོད༌པིན༌, ཡང༌ ཁོང༌གུན༌ རང༌རང༌ངི༌ བུང༌བུའི༌ཀ༌ ཞོན༌ཏེ༌ གྲུལ༌ལད༌པིན༌། ཁོང༌གུན༌ནི༌ ཝང༌ངི༌ ཡོག༌ག༌ གི༌ལེད༌ ཡུལ༌ཇོངས༌སི༌ གྲོང༌ཁྱེར༌ 30 ཡོད༌པིན༌ ཀ༌གུན༌ལ༌ དག༌སའང༌ ཡ༌འིར༌རི༌ གྲོང༌ཁྱེར༌ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","ཡ༌འིར༌ ཤི༌ ཡང༌ ཁོའེ༌ སྤུར༌ ཀ༌མོན༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","ཡང༌སྐྱར༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཅོས༌། ཁོང༌གུན༌ནི༌ བའལ༌ དང༌ ཨཤ༌ཏོ༌རེཐ༌ སྐུན༌དྲ༌གུན༌ལ༌ ཡང༌ ཨ༌རམ༌པ༌, སི༌དོན༌པ༌, མོ༌འབ༌པ༌, ཨེམ༌མོན༌པ༌ དང༌ ཕི༌ལིས༌ཏི༌པ༌ གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུས༌། ཁོང༌གུན༌ནི༌ ཡ༌ཝའ༌ ཅོལ༌ཅེས༌ ཕངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ ཡ༌ཝའ༌ ཐུག༌སྲོ༌ སྐྱོདས༌ ཡང༌ ཁོང༌ངི༌ ཕི༌ལིས༌ཏི༌པ༌ དང༌ ཨེམ༌མོན༌པ༌ གུན༌ལ༌ ཁོང༌གུན༌ནི༌ཀ༌ གྱལ༌ཁའ༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","ཡ༌འིར༌ ཤི༌ཁན༌ནི༌ ཏེན༌ན༌ ལོའེ༌ ནང༌ང༌ གྲ༌འོ༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ སྙིང༌རྗེ༌ མེད༌པ༌ ཝང༌སྲུལ༌ཏེ༌ ནགས༌ སྲན༌ཏྲེ༌ སྟནས༌། ཡོར༌དཱན༌ནི༌ ལྩངས༌པོའེ༌ ཤར༌ཆོགས༌ལ༌ ཡོད༌ཁན༌ ཨ༌མོར༌པའེ༌ ས༌ཀྱད༌, གི༌ལེད༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ཀ༌ ལོ༌ 18 ཝང༌སྲུལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","ཨེམ༌མོན༌པ༌གུན༌ནི༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ནུབ༌ ཆོགས༌ལ༌ ཡ༌ཧུ༌དཱ༌པ༌, བེན༌ཡཱ༌མིན༌པ༌ དང༌ ཨེཕ༌ར༌ཡིམ༌པ༌ གུན༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ རྡུག༌ངལ༌ ཀྲག༌པོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཡ༌ཝའ༌ རོགས༌ ཅོའ༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌ཏེ༌ ཟེརས༌, “ང༌ཞ༌གུན༌ནི༌ ཉེ༌རང༌ ཕངས༌ཏེ༌ བའལ༌ལི༌ སྐུན༌དྲ༌གུན༌ལ༌ ཅོལ༌ཏེ༌ ཉེ༌རང༌ངི༌ སྐུན༌དུན༌ལ༌ སྡིག༌པ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","ཡ༌ཝའེ༌ ལན༌སལས༌, “ཅི༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཨི༌ཇིབ༌པ༌, ཨ༌མོར༌པ༌, ཨེམ༌མོན༌པ༌, ཕི༌ལིས༌ཏི༌པ༌, ");
INSERT INTO lbj_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","སི༌དོན༌པ༌, ཨ༌མ༌ལིཀ༌པ༌ དང༌ མ༌འོན༌པ༌ གུན༌ནི༌ རྡུག༌ངལ༌ ཀྲག༌པོ༌ སྟནས༌ ཟ༌ནེ༌ རོགས༌ ཅོའ༌ལ༌ མོས༌ལམ༌ ཞུའ༌ཅིག༌ ངའེ༌ ཁྱོ༌ཞའ༌ ཁོང༌གུན༌ནི༌ ལག༌ནེ༌ སྐྱོབས༌ཏེ༌ མ༌ ཁྱོངས༌ས༌?” ");
INSERT INTO lbj_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","ཏེ༌ནེའང༌ ཁྱོ༌རང༌གུན༌ནི༌ ང༌ ཕངས༌ཏེ༌ ཞན༌ཡང༌ ལྷ༌ལྷ༌མོ༌ གུན༌ལ༌ ཅོལ༌ཏེ༌ ཞབས༌ཏོག༌ ཞུས༌ ཏེ༌བོའེ༌ཕིའ༌ ཏ༌ ངའེ༌ ཁྱོ༌རང༌གུན༌ མི༌ སྐྱོབ༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","སོང༌ ཡང༌ ཁྱོ༌རང༌གུན༌ནི༌ ལྡམ༌ཁན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ རོགས༌ ཅོ༌ཅེས༌ལ༌ བོད༌། ཁྱོ༌ཞའ༌ རྡུག༌ངལ༌ལི༌ ནང༌ནེ༌ ཏེ༌གུན༌ལ༌ སྐྱོབ༌ ཅུག༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌, “ང༌ཞའེ༌ སྡིག༌པ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། འོས༌པ༌ ཨིན༌ཁན༌ནི༌ ཆད༌པ༌ ཉེ༌རང༌ངི༌ ང༌ཞའ༌ སལ༌ལ༌ ཛད༌། ཨིན༌ནའང༌ ཇུ༌ཇུ༌ དག༌ས༌ ང༌ཞ༌གུན༌ ཐར༌ཅུག༌ག༌ ཛད༌” ");
INSERT INTO lbj_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྐུན༌དྲ༌གུན༌ མེད༌ཁན༌ ཅོས༌ཏེ༌ ཡ༌ཝའ༌ དཀོན༌མཆོག༌ག༌ ཅོལས༌། ཁོང༌གུན༌ལ༌ རྡུག༌ངལ༌ སྲན༌ཏྲེ༌ ཐོང༌ཨིན༌ ཡོད༌ཁན༌བོ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ ཟིགས༌ མ༌ཐུབ༌ པ༌སང༌ ཁོང༌ང༌ ཁོང༌གུན༌ནི༌ཀ༌ སྙིང༌རྗེ༌ སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","ཨེམ༌མོན༌པའེ༌ མག༌མི༌གུན༌ གི༌ལེད༌དི༌ ནང༌ང༌ ཛོམས༌ཏེ༌ ཡོད༌ཏུས༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌གུན༌ མིཟ༌པཧའེ༌ ནང༌ང༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","གི༌ལེད༌དི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྤོན༌བོ༌གུན༌ནི༌ ཅིག༌ དང༌ ཅིག༌ག༌ ཟེརས༌, “ཨེམ༌མོན༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ གོ༌ཁྲིད༌ ཅོ༌ཁན༌བོ༌ ང༌ཞའ༌ ཚང༌མའེ༌ཀ༌ ཝང༌སྲུལ༌པ༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","ཏ༌ གི༌ལེད༌པ༌ ཡེཕ༌ཐཧ༌, མག༌ ཏང༌ཁན༌ ཀྲག༌པོ༌ ཨིན༌པིན༌། ཁོའེ༌ ཨ༌བ༌ གི༌ལེད༌ ཡང༌ ཨ༌མ༌ ཟུགས༌ཙོང༌མ༌ཞིག༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","ཨིན༌ནའང༌ གི༌ལེད༌ལ༌ ཁོ༌རང༌ངི༌ ན༌མ༌ གྱུད༌ཏེ༌ ཞན༌ བུ༌ཚ༌གུན༌ ཇོར༌། ཏེ༌ བུ༌ཚ༌གུན༌ ལྡན༌ཏེ༌ སྟིང༌ནེ༌ ཁོང༌གུན༌ནི༌ ཡེཕ༌ཐཧ༌ ཁང༌པ༌ནེ༌ ཕིངས༌ཏེ༌ ཟེརས༌, “ང༌ཞའེ༌ ཁྱོ༌རང༌ང༌ ཨ༌བའེ༌ ནོར༌སྐལ༌ ཅའང༌ མི༌ཏང༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ ཟུགས༌ཙོང༌མའེ༌ བུ༌ཚ༌, ང༌ཞའེ༌ ཨ༌མའེ༌ ཕྲུ༌གུ༌ མ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","ཏེ༌ནེ༌ ཡེཕ༌ཐཧ༌ ཁོ༌རང༌ངི༌ ཨ༌ཅོ༌ནོ༌གུན༌ནེ༌ ཤོར༌ཏེ༌ ཏོབ༌ ནས༌སའེ༌ ནང༌ང༌ དུགས༌, ཏེ༌རུ༌ ཁྲིམས༌ མ༌སྲུང༌ཁན༌ནི༌ མི༌ བན༌ཤིག༌ ཁོའེ༌ གྱབ༌ནེ༌ ཡོངས༌ ཡང༌ ཁོའེ༌ ཕྲོ༌པ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","ཏུས༌ བན༌ཤིག༌གི༌ སྟིང༌ནེ༌ ཨེམ༌མོན༌པ༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ མག༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","གི༌ལེད༌པའེ༌ འུ༌སྐྱོང༌གུན༌ ཏོབ༌བ༌ ཡེཕ༌ཐཧ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","“ཡོང༌, ང༌ཞ༌གུན༌ནི༌ མག༌སྤོན༌ གྱུར༌ཏེ༌ ཨེམ༌མོན༌པ༌གུན༌ལ༌ མག༌ ཏང༌ཅེས༌ལ༌ ང༌ཞའ༌ རོགས༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","ཨིན༌ནའང༌ ཡེཕ༌ཐཧའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ ངའ༌ ནཕ༌རད༌ ཅོས༌ཏེ༌ ང༌ ང༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པ༌ནེ༌ ཕིངས༌ཏེ༌ མ༌ཏངས༌པིན༌ན༌? ཏ༌ ཀགས༌པོ༌ ཐོང༌ང༌ཅིག༌ ཅི༌ཕིའ༌ ཁྱོ༌རང༌གུན༌ ངའེ༌ཀ༌ ཡོངས༌ཏེ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","འུ༌སྐྱོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའ༌ ཁྱོ༌རང༌ངི༌ རོགས༌ གོས༌སད༌། ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ང༌ཞའ༌ ཨེམ༌མོན༌པའེ༌ གྱབ༌གལ༌ལ༌ མག༌ ཏང༌ཅེས༌ལ༌ རོགས༌ ཅོ༌ན༌ ང༌ཞའེ༌ གི༌ལེད༌དི༌ ནང༌ང༌ དུག༌ཁན༌ ཚང༌མའེ༌ཀ༌ ཁྱོ༌རང༌ ཝང༌སྲུལ༌པ༌ སྐོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","ཡེཕ༌ཐཧའེ༌ ལན༌ཏངས༌, “ཀལ༌ཏེས༌ ང༌ ཁྱོ༌ཞ༌གུན༌ལ༌ རོགས༌ ཅོའ༌ ཡོངས༌ཏེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ངའ༌ ཨེམ༌མོན༌པ༌གུན༌ནི༌ཀ༌ གྱལ༌ཁ༌ སལ༌ན༌, དེན༌བའ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ངའ༌ ཁྱོ༌ཞའེ༌ འུ༌སྐྱོང༌ ལྡམ༌ ཨིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","འུ༌སྐྱོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཡ༌ཝ༌ སྤང༌པོ༌ ཞུགས༌ཏེ༌ ཨིན༌, ཏན༌ཏན༌ ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌བོ༌ ང༌ཞའེ༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","ཏེ༌ནེ༌ ཡེཕ༌ཐཧ༌ གི༌ལེད༌པ༌ འུ༌སྐྱོང༌གུན༌ ཉམ༌པོ༌ སོང༌, ཡང༌ ཁོང༌གུན༌ནི༌ ཁོ༌ ཁོང༌གུན༌ནི༌ཀ༌ འུ༌སྐྱོང༌ དང༌ མག༌མིའི༌ སྤོན༌བོའ༌ སྐོས༌། མིཟ༌པཧའེ༌ ནང༌ང༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཡེཕ༌ཐཧའེ༌ ཟེར༌ཁན༌གུན༌ ཡང༌སྐྱར༌ ལྡབས༌ཏེ༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","ཏེ༌ནེ༌ ཡེཕ༌ཐཧའེ༌ ཨེམ༌མོན༌པ༌གུན༌ནི༌ གྱལ༌པོའ༌ ལོན༌ ཀལ༌ཏེ༌ ཏྲིས༌, “ང༌ཞའ༌ ནོལ༌ལ༌ ཡོང༌ཅེས༌ ང༌ཞའེ༌ ཁྱོ༌ཞའེ༌ གྱབ༌གལ༌ལ༌ ཅི༌ ཅོས༌?” ");
INSERT INTO lbj_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","ཨེམ༌མོན༌ནི༌ གྱལ༌པོའེ༌ ཡེཕ༌ཐཧའེ༌ ལོན༌ ཁྱོང༌ཁན༌གུན༌ལ༌ ཟེརས༌, “ཨི༌ཇིབ༌ནེ༌ ཡོངས༌ཏེ༌ སྟིང༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨར༌ནོན༌ ལྩངས༌པོ༌ ནེ༌ ཡབ༌བོག༌ ལྩངས༌པོ༌ ཚོག༌པ༌, ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ཤར༌ ཆོགས༌སི༌ ངའེ༌ ས༌ཀྱད༌ གང༌པོ༌ ཀོགས༌ཏེ༌ ཁྱེརས༌། ཏ༌ ཞི༌དེ༌ ཉམ༌པོ༌ ཏེ༌ ས༌ཀྱད༌གུན༌ ལོགས༌ཏེ༌ ཏོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","ཡེཕ༌ཐཧའེ༌ ལོན༌ཁྱེར༌ཁན༌གུན༌ ཨེམ༌མོན༌པའེ༌ གྱལ༌པོའེ༌ཀ༌ ལོགས༌ཏེ༌ ལམ༌ཅུགས༌, ");
INSERT INTO lbj_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","ཁོང༌གུན༌ནི༌ ཟེརས༌, “ཡེཕ༌ཐཧའེ༌ ཟེར༌དུག༌, ‘ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མོ༌འབ༌ ཡ༌ ཨེམ༌མོན༌པའེ༌ ས༌ཀྱད༌ ཀོགས༌ཏེ༌ མ༌ཁྱེར༌ར༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ བིང༌ཏེ༌ ཐང༌སྟོང༌ གྱུད༌ཏེ༌ ཚོ༌ མར༌པོ༌ རྒལ༌ཏེ༌ ཀ༌དེཤ༌ལ༌ ལེབ༌ ཟ༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","ཁོང༌གུན༌ནི༌ ཨི༌དོམ༌པའེ༌ གྱལ༌པོའ༌ ལོན༌ ཀལ༌ཏེ༌ ཟེརས༌, “ཁྱོ༌ཞའེ༌ ས༌ཀྱད༌ གྱུད༌ཏེ༌ ང༌ཞའ༌ ཆ༌ཅེས༌ལ༌ གོངས༌པ༌ སལ༌།” ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཆ༌ མ༌ཅུགས༌། ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མོ༌འབ༌བི༌ གྱལ༌པོའ༌ ཏེན༌ན༌ ཙོགས༌ ཞུ༌ཝ༌ ཕུལས༌ ཨིན༌ནའང༌ ཁོང༌ངིའང༌ ཁོང༌གུན༌ ཆ༌ མ༌ཅུགས༌། ཏེ༌བོའེ༌ཕིའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཀ༌དེཤ༌སི༌ ནང༌ང༌ དུགས༌།’” ");
INSERT INTO lbj_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","“སྟིང༌ནེ༌ ཁོང༌གུན༌ ཐང༌སྟོང༌ གྱུད༌ཏེ༌ ཨི༌དོམ༌ དང༌ མོ༌འབ༌ ཡུལ༌གུན༌ནི༌ ཐའ༌མ༌ནེ༌ སོང༌ ཡང༌ མོ༌འབ༌བི༌ ཤར༌ ཆོགས༌སི༌ སན༌ཚམས༌ ཨར༌ནོན༌ ལྩངས༌པོའེ༌ འ༌ངོ༌ ཆོགས༌ལ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ཁོང༌གུན༌ ཨར༌ནོན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ མོ༌འབ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ མན༌ནེ༌ མ༌སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","“ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཧེཤ༌བོན༌ གྱལ༌སའེ༌ ནང༌ང༌ དུག༌ཁན༌ ཨ༌མོར༌པའེ༌ གྱལ༌པོ༌ སི༌ཧོན༌ལ༌ ཁོང༌གུན༌ ཁོང༌ངི༌ ས༌ཀྱད༌ གྱུད༌ཏེ༌ ཆ༌ཅུག༌ཅེས༌ལ༌ གོངས༌པ༌ སལ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","ཨིན༌ནའང༌ གྱལ༌པོ༌ སི༌ཧོན༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཁོའེ༌ ས༌ཀྱད༌ གྱུད༌ཏེ༌ ཆ༌ཅེས༌པོའ༌ ཨིད༌ཤེས༌ མ༌ཅོས༌པ༌ ཁོའེ༌ ཡ༌ཧཟ༌ཟི༌ ནང༌ང༌ ཁོ༌རང༌ངི༌ མག༌མི༌གུན༌ བོད༌ཏེ༌ ཁོང༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","“ཨིན༌ནའང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ གྱལ༌པོ༌ སི༌ཧོན༌ དང༌ ཁོང༌ངི༌ མག༌མི༌ ཚང༌མ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ལག༌ག༌ སལས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཏེ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ དུག༌ཁན༌ ཨ༌མོར༌པ༌གུན༌ནི༌ ས༌ཀྱད༌ གང༌པོ༌, ");
INSERT INTO lbj_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","ལྷོ༌ ཆོགས༌སི༌ ཨར༌ནོན༌ ལྩངས༌པོ༌ནེ༌ བྱང༌ ཆོགས༌སི༌ ཡབ༌བོག༌ ལྩངས༌པོ༌ ཚོག༌པ༌ ཡང༌ ཤར༌ ཆོགས༌སི༌ ཐང༌སྟོང༌ནེ༌ ནུབ༌ ཆོགས༌སི༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ ཚོག༌པ༌ ང༌ཡོག༌ག༌ ཁྱོངས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","“ཏ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ཨ༌མོར༌པ༌གུན༌ནི༌ ས༌ཀྱད༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ སལ༌ལ༌ ཛད༌ པ༌སང༌ ཏེ༌ནེ༌ ཅིའ༌ ང༌ཞའེ༌ འི༌གུན༌ ཁྱོ༌ཞའ༌ ལོགས༌ཏེ༌ ཏང༌ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","ཁྱོ༌ཞའེ༌ ལྷ༌ ཀེ༌མོཤ༌ཤི༌ ཏང༌ཁན༌བོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ མི༌ལེན༌ན༌? ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ ང༌ཞའ༌ སལ༌ཁན༌བོ༌ ང༌ཞའེ༌ བོར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","ཅི༌ ཁྱོ༌ཞའ༌ མོ༌འབ༌བི༌ གྱལ༌པོ༌ ཟིཔ༌པོར༌རི༌ བུ༌ཚ༌ བ༌ལག༌གི༌ སང༌ ཇིགས༌ས༌ ཨིན༌ན༌? ཅི༌ ཁོའེ༌ ས༌ཀྱད༌དི༌ ཛིང༌མོའེ༌ ཕིའ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ གྱབ༌གལ༌ལ༌ ཁྲིམས༌ ཙུགས༌ས༌? ཅི༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ མག༌ ཏངས༌ས༌? ");
INSERT INTO lbj_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ལོ༌ 300 ནེ༌ ཕར༌ལ༌ ཧེཤ༌བོན༌, ཨ༌རོ༌འེར༌ དང༌ ཏེ༌བོའེ༌ ཉེ༌ཁོར༌རི༌ ནས༌ས༌ ཡང༌ ཨར༌ནོན༌ ལྩངས༌པོའེ༌ གྲོང༌ཁྱེར༌ ཚང༌མའེ༌ ནང༌ང༌ དུགས༌ཏེ༌ ཨིན༌ནོག༌། ཏེ༌ཏུས༌ གང༌པོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ འི༌ ས༌ཀྱད༌གུན༌ ལོགས༌ཏེ༌ ཅིའ༌ མ༌ ཁྱེར༌པིན༌? ");
INSERT INTO lbj_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","ངའེ༌ ཁྱོ༌ཞའ༌ ནོར༌ཁྲུལ༌ མ༌ཅོས༌པིན༌ ཨིན༌ནའང༌ ཁྱོ༌ཞ༌གུན༌ ང༌ཞའ༌ སྤུང༌གོལ༌ ཅོའ༌ལ༌ ཡོངས༌ཏེ༌ ནོར༌ཁྲུལ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། དི༌རིང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཡ༌ ཨེམ༌མོན༌པ༌ ཉིས༌ཀོའེ༌ ནང༌ནེ༌ སུ༌ ཀྲང༌པོ༌ ཨིན༌ ནམ༌ཁའ༌ ཞུགས༌ཁན༌ནི༌ ཁྲིམ༌སྤོན༌ ཡ༌ཝའེ༌ ཐག༌ཅད༌ ཛད༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","ཨིན༌ནའང༌ ཨེམ༌མོན༌པའེ༌ གྱལ༌པོའེ༌ ཡེཕ༌ཐཧའེ༌ ལོན༌ ཀལ༌ཁན༌བོའ༌ ནང༌སྟག༌ མ༌ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","ཏེ༌ནེ༌ ཡེཕ༌ཐཧའེ༌ ནང༌ང༌ ཡ༌ཝའེ༌ ཐུག༌ཉིད༌ གངས༌ ཡང༌ ཁོ༌ གི༌ལེད༌ དང༌ མ༌ནས༌སའེ༌ ཡུལ༌ཇོངས༌ གྱུད༌ཏེ༌ སོང༌ཏེ༌ གི༌ལེད༌དི༌ མིཟ༌པཧ༌ གྱལ༌སའེ༌ ནང༌ང༌ མག༌མི༌གུན༌ ཛོམ༌ཅུགས༌ཏེ༌ ཨེམ༌མོན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","ཡང༌ ཡེཕ༌ཐཧའེ༌ ནའ༌ ཁུར༌ཏེ༌ ཡ༌ཝའ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཉེ༌རང༌ངི༌ ངའ༌ ཨེམ༌མོན༌པ༌གུན༌ནི༌ཀ༌ གྱལ༌ཁ༌ སལ༌ན༌ ");
INSERT INTO lbj_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","ང༌ ལོགས༌ཏེ༌ ཆ༌ ཟ༌ནེ༌ ངའེ༌ ཁང༌པའེ༌ ནང༌ནེ༌ གོ༌མ༌རང༌ ངའ༌ ཐུག༌ག༌ ཡོང༌ཁན༌བོ༌ ངའེ༌ མེའ༌ སྲགས༌ཏེ༌ ཉེ༌རང༌ང༌ ཆོད༌པ༌ ཕུལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","ཏེ༌ནེ༌ ཡེཕ༌ཐཧ༌ མག༌མི༌གུན༌ ཉམ༌པོ༌ ཨེམ༌མོན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌ ཡང༌ ཡ༌ཝའེ༌ ཁོའ༌ ཁོང༌གུན༌ནི༌ཀ༌ གྱལ༌ཁ༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","ཁོའེ༌ ཨ༌རོ༌འེར༌ནེ༌ ཏངས༌ཏེ༌ མིན༌ནིཐ༌, ཐག༌རིང༌ ཨ༌བེལ༌ ཀེ༌ར༌མིམ༌ ཚོག༌པ༌ ཨེམ༌མོན༌པའེ༌ གྲོང༌ཁྱེར༌ ཉི༌ཤུ༌ ཁྲེས༌ཏོར༌ ཅོས༌། ཏེན༌ན༌ ཟུག༌གི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཨེམ༌མོན༌པ༌གུན༌ལ༌ ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","མིཟ༌པཧའ༌ ཡེཕ༌ཐཧ༌ ཁོ༌རང༌ངི༌ ཁང༌པ༌ ལོགས༌ཏེ༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ བུ༌མོ༌ ཀྲམ༌བུ༌རིན༌ རྡུང༌ཨིན༌ རྩེས༌ ཏང༌ཨིན༌ ཁོའ༌ ཐུག༌ག༌ལ༌ བིངས༌ཏེ༌ ཡོངས༌། ཁོ༌ ཁོའེ༌ ཕྲུ༌གུ༌ ཅིག༌ཅིག༌པོ༌ ཨིན༌པིན༌། ཏེན༌ན༌ བུ༌མོ༌བོ༌ མན༌ནེ༌ ཁོའ༌ ཞན༌ ཕྲུ༌གུ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","བུ༌མོ༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཀོས༌ ཤགས༌ ཡང༌ སེམ༌རྡུག༌ ཉམ༌པོ༌ ཟེརས༌, “ཨོ༌, ངའེ༌ བུ༌མོ༌། ཁྱོ༌རང༌ངི༌ ང༌ སེམ༌རྡུག༌ དང༌ རྡུག༌པོ༌ སྲན༌ཏྲེ༌ ཁྱོངས༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཡ༌ཝའ༌ ནའ༌ ཁུར༌པིན༌ ཡང༌ ཏེ༌བོ༌ ཅག༌ ཉན༌ཅེས༌ མེད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","བུ༌མོའེ༌ ཟེརས༌, “ཨ༌བ༌ལེ༌, ཉེ༌རང༌ངི༌ ཡ༌ཝ༌ ཉམ༌པོ༌ ནའ༌ ཁུར༌ར༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ཡ༌ཝའེ༌ ཉེ༌རང༌ང༌ ཨེམ༌མོན༌པ༌གུན༌ནི༌ཀ༌ གྱལ༌ཁ༌ སལ༌ལ༌ ཛད༌པ༌ ཏ༌ ཉེ༌རང༌ངི༌ ཁ༌ཆད༌ ཛད༌ཁན༌བོ༌ ང༌ ཉམ༌པོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","ཨིན༌ནའང༌ ངའེ༌ ཞུ༌ཝ༌ ཅིག༌ཅིག༌པོ༌ ང༌ སལ༌ལེ༌། ང༌ རི༌ ཡུལ༌གུན༌ལ༌ ཁོར༌ཏེ༌ ང༌རང༌ངི༌ ཛ༌མོ༌གུན༌ ཉམ༌པོ༌ རྡུག༌པོ༌ ཅོ༌ཅེས༌ལ༌ ཟླ༌ཝ༌ ཉིས༌ སལ༌ལ༌ ཛད༌ ཅིའ༌ཟེར༌ན༌ ངའ༌ ན༌མ༌ ཅོས༌ཏེ༌ ཕྲུ༌གུ༌ ཇོར༌ཅེས༌སི༌ སྐབས༌ མེད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","ཡེཕ༌ཐཧའེ༌ ཟེརས༌, “ཁྱོ༌རང༌ ཆ༌ནའང༌ གྲིག༌།” ཡང༌ ཁོའེ༌ བུ༌མོ༌ ཟླ༌ཝ༌ ཉིས༌སི༌ ཕིའ༌ ཆ༌ཅུགས༌། བུ༌མོ༌ དང༌ ཁོའེ༌ ཛ༌མོ༌གུན༌ རི༌ཡུལ༌གུན༌ལ༌ སོང༌ ཡང༌ རྡུག༌པོ༌ ཅོས༌ ཅིའ༌ཟེར༌ན༌ ཁོའ༌ ན༌མ༌ ཅོས༌ཏེ༌ ཕྲུ༌གུ༌ ཇོར༌ཅེས༌སི༌ སྐབས༌ མེད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","ཟླ༌ཝ༌ ཉིས༌སི༌ སྟིང༌ནེ༌ བུ༌མོ༌ ལོགས༌ཏེ༌ ཁང༌པ༌ ཡོང༌ང༌ཅིག༌ ཨ༌བའེ༌ ནའ༌ ཁུར༌ཁན༌ ནང༌ཞིན༌ ཁོ༌ ཉམ༌པོ༌ ཅོས༌། ཏེ༌ བུ༌མོའ༌ ན༌མ༌ ཅོས༌ཏེ༌ ཕྲུ༌གུ༌ ཇོར༌ཅེས༌སི༌ སྐབས༌ མ༌ཐོབ༌བ༌ ཤི༌། ཏེ༌བོའེ༌ ཞས༌ཏེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ ལུག༌སྲོལ༌ཞིག༌ གོ༌ཟུག༌། ");
INSERT INTO lbj_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","གི༌ལེད༌པ༌ ཡེཕ༌ཐཧའེ༌ བུ༌མོའེ༌ དྲན༌སོའེ༌ ནང༌ང༌ ཨིས༌ར༌ཨེལ༌པ༌ བུ༌མོ༌ ན༌ཆུང༌གུན༌ ལོ༌ཞུང༌ ཞག༌པོ༌ ཞིའི༌ ཕིའ༌ རི༌ཡུལ༌ལ༌ དུག༌ག༌ ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","ཏེ༌ནེ༌ ཨེཕ༌ར༌ཡིམ༌པའེ༌ བུ༌ཚ༌གུན༌ ཛོམས༌ཏེ༌ ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ཏེ༌ ཟ༌ཕོན༌ ཆོགས༌ལ༌ སོང༌ ཡང༌ ཡེཕ༌ཐཧའ༌ ཟེརས༌, “ཨེམ༌མོན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ ཆ༌ ཟ༌ནེ༌ ཁྱོ༌རང༌ངི༌ རོགས༌ ཅོ༌ཅེས༌ལ༌ ང༌ཞའ༌ ཅིའ༌ མ༌བོད༌པིན༌? ང༌ཞའེ༌ ཁྱོ༌ཞའ༌ རགས༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཁང༌པ༌གུན༌ མེའ༌ ཏུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","ཡེཕ༌ཐཧའེ༌ ལན༌ཏངས༌, “ཨེམ༌མོན༌པ༌གུན༌ནི༌ ང༌ཞའ༌ སྲན༌ཏྲེ༌ གོབ༌ནོན༌ ཅོ༌ ཟ༌ནེ༌ ངའེ༌ ཁྱོ༌ཞའ༌ རོགས༌ ཅོ༌ཅེས༌ལ༌ བོད༌པིན༌ ཨིན༌ནའང༌ ཁྱོ༌ཞའ༌ ང༌ཞའ༌ སྐྱོབ༌བ༌ མ༌ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","ཁྱོ༌ཞའ༌ རོགས༌ ཅོའ༌ལ༌ མི༌ཡོང༌ཅེས༌པོ༌ ཧ༌གོའ༌ཅིག༌, ངའེ༌ ང༌རང༌ངི༌ སྲོག༌ ཇིགས༌པའེ༌ ནང༌ང༌ ཏངས༌ཏེ༌ ཨེམ༌མོན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌པིན༌ ཡང༌ ཡ༌ཝའེ༌ ངའ༌ ཁོང༌གུན༌ནི༌ཀ༌ གྱལ༌ཁ༌ སལ༌ལ༌ ཛདས༌། ཏ༌ དི༌རིང༌ ཁྱོ༌ཞའ༌ ང༌ཞ༌གུན༌ལ༌ ནོལ༌ལ༌ ཅི༌ཕིའ༌ ཡོངས༌ཏེ༌ ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","“ཁྱོ༌ཞའ༌ ཨེཕ༌ར༌ཡིམ༌ དང༌ མ༌ནས༌ས༌ སྡེ༌གུན༌ནེ༌ ཤོར༌ཏེ༌ ཆའ༌ཁན༌གུན༌ ཨིན༌ནོག༌” ཟེར༌ཏེ༌ ཨེཕ༌ར༌ཡིམ༌པ༌གུན༌ནི༌ གི༌ལེད༌པ༌གུན༌ལ༌ མ༌བེབས༌ ཅོས༌པ༌ ཡེཕ༌ཐཧའེ༌ གི༌ལེད༌པ༌ ཚང༌མ༌ ཛོམ༌ཅུགས༌ཏེ༌ ཁོང༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ཕམ༌ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","ཡོར༌དཱན༌ ལྩངས༌པོ༌ རྒལ༌ ཉན༌སའེ༌ ནས༌ས༌ ཏེལ༌མོ༌ ཚང༌མ༌ གི༌ལེད༌པ༌གུན༌ནི༌ ང༌ཡོག༌ག༌ ཁྱོངས༌། ཨེཕ༌ར༌ཡིམ༌པ༌ སོན༌ཏེའ༌ ལུས༌ཁན༌གུན༌ ཆུ༌ རྒལ༌ཏེ༌ ཆ༌ཅེས༌ལ༌ ཡོང༌ང༌ཅིག༌ གི༌ལེད༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ “ཁྱོ༌ཞའ༌ ཨེཕ༌ར༌ཡིམ༌པ༌ ཨིན༌ན༌” ཟེར༌ཏེ༌ ཏྲིའད༌པིན༌? ཀལ༌ཏེས༌ ཁོང༌གུན༌ནི༌ མན༌ ཟེར༌ན༌, ");
INSERT INTO lbj_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","གི༌ལེད༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ “ཤིབ༌བོ༌ལེཐ༌” ཟེར༌ ཅུག༌གད༌པིན༌ ཀལ༌ཏེས༌ ཁོང༌གུན༌ནི༌ “སིབ༌བོ༌ལེཐ༌” ཟེར༌ན༌ ཁོང༌གུན༌ནི༌ ཁོང༌གུན༌ ཏེན༌ནེ༌ཀ༌ སད༌དད༌པིན༌ ཅིའ༌ཟེར༌ན༌ ཨེཕ༌ར༌ཡིམ༌པ༌གུན༌ལ༌ ཏེ༌ ཚིགས༌པོ༌ སལ༌པོ༌ ཟེར༌ ཉན༌ན༌ མེད༌པིན༌། ཏེན༌ན༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ ཨེཕ༌ར༌ཡིམ༌པ༌ 42,000 སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","ཡེཕ༌ཐཧའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ ལོ༌ 6 ཅོས༌། ཁོ༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌ ཁོའེ༌ སྤུར༌ གི༌ལེད༌དི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཁོའེ༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","ཡེཕ༌ཐཧའེ༌ སྟིང༌ནེ༌ བེད༌ལེ༌ཧེམ༌པ༌ ཨིབ༌ཟན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","ཁོའ༌ བུ༌ཚ༌ 30 དང༌ བུ༌མོ༌ 30 ཡོད༌པིན༌། ཁོའེ༌ ཁོ༌རང༌ངི༌ སྡེ༌ནེ༌ མན༌ཁན༌གུན༌ལ༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌གུན༌ ན༌མ༌ ཏངས༌ ཡང༌ ཁོ༌རང༌ངི༌ སྡེ༌ནེ༌ མན༌ཁན༌ བུ༌མོ༌གུན༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ལ༌ ན༌མའ༌ ཁྱོངས༌། ཨིབ༌ཟན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གོ༌ཁྲིད༌ ལོ༌ 7 ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","ཁོ༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌ ཁོའེ༌ སྤུར༌ བེད༌ལེ༌ཧེམ༌མི༌ ནང༌ང༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","ཨིབ༌ཟན༌ནི༌ སྟིང༌ནེ༌ ཟེ༌བུ༌ལོན༌ནི༌ སྡེ༌ནེ༌ ཨིན༌ཁན༌ ཨེ༌ལོན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གོ༌ཁྲིད༌ ལོ༌ 10 ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","ཁོ༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌ ཁོའེ༌ སྤུར༌ ཟེ༌བུ༌ལོན༌པའེ༌ ནས༌ས༌ ཨའི༌ཡ༌ལོན༌ནི༌ ནང༌ང༌ སུབས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","ཨེ༌ལོན༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌ ཕི༌ར༌ཐོན༌པ༌ ཧིལ༌ལེལ༌ལི༌ བུ༌ཚ༌ ཨབ༌དོན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","ཁོའ༌ བུ༌ཚ༌ 40 དང༌ ཚ༌འོ༌ 30 ཡོད༌པིན༌, ཁོང༌ རེ༌རེའ༌ ཞོན༌ཏེ༌ གྲུལ༌ཅེས༌ལ༌ བུང༌བུ༌ རེ༌རེ༌ ཡོད༌པིན༌། ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གོ༌ཁྲིད༌ ལོ༌ 8 ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","ཁོ༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌ ཁོའེ༌ སྤུར༌ ཨེཕ༌ར༌ཡིམ༌པའེ༌ ནས༌ས༌ ཕི༌ར༌ཐོན༌ནི༌ ནང༌ང༌ སུབས༌ ཀ༌བོ༌ ཨ༌མ༌ལིཀ༌པ༌གུན༌ནི༌ རི༌ཡུལ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","ཡང༌སྐྱར༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངན༌པ༌ ཅོས༌། ཏེ༌བོའེ༌ཕིའ༌ ཡ༌ཝའེ༌ ཁོང༌གུན༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ད༌ ཛདས༌, ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ ལོ༌ 40 ཝང༌ སྲུལ༌ཏེ༌ ཁོང༌གུན༌ལ༌ ནགས༌ སྟནས༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","ཏེ༌ཏུས༌ལ༌ ཟོ༌རཧ༌ གྲོང༌ཁྱེར༌རི༌ དཱན༌ནི༌ མི༌སྡེ༌ནེ༌ མ༌ནོ༌འཧ༌ ཟེར༌ཁན༌ མི༌ཞིག༌ ཡོད༌པིན༌། ཁོའེ༌ ན༌མའ༌ ཕྲུ༌གུ༌ ཇོར༌ མ༌ཐུབ༌པ༌ ཁོང༌གུན༌ལ༌ ཕྲུ༌གུ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","མ༌ནོ༌འཧའེ༌ ན༌མའ༌ ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ཇལ༌ཏེ༌ མོལས༌, “ཁོ༌རང༌ང༌ ཕྲུ༌གུ༌ ཇོར༌ མ༌ཐུབ༌བ༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ ཏ༌ ཁྱོ༌རང༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ ཁོ༌རང༌ང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","ཏ༌ ནང༌སྟག༌ ཅོས༌ཏེ༌ ཁྱོ༌རང༌ རྒུན༌ དང༌ ཞན༌ ར༌རོས༌ཤེས༌ ཆང༌གུན༌ ཐུང༌ མ༌གོས༌ ཡང༌ རྩང༌མ༌ མན༌ཁན༌ནི༌ ཟན༌ ཟའ༌ མ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","ཁྱོ༌རང༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ ཁྱོ༌རང༌ང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ཨིན༌། ཁོའེ༌ སྲ༌ མ༌ནེ༌ མ༌ བྲག༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ ན༌ཟི༌རཱའིགྲ༌ ཡང༌ན༌ ཁོ༌ སྐྱེས༌པ༌ནེ༌ ཕར༌ལ༌ དཀོན༌མཆོག༌གི༌ ཕིའ༌ ལྡམས༌ཁན༌ ཡང༌ ཁོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཐར༌ཅུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","ཏེ༌ནེ༌ བུ༌མོ༌ ཁོ༌རང༌ངི༌ མག༌པ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “ང༌ ཡོད༌ས༌ དཀོན༌མཆོག༌གི༌ མི༌ཞིག༌ སྐྱོདས༌། ཁོང༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉ༌ ཙོགས༌, ཁྱུད༌ཅན༌ ཇིགས༌པོ༌ ཐོང༌དུག༌པིན༌། ངའེ༌ ཁོང༌ང༌ ཀ༌ནེ༌ སྐྱོད༌པིན༌ ཟེར༌ཏེ༌ མ༌ ཏྲིས༌པིན༌ ཡང༌ ཁོང༌ངི༌ ཁོ༌རང༌ངི༌ ཚན༌ ཤད༌ད༌ མ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","ཨིན༌ནའང༌ ཁོང༌ངི༌ ང༌ མོལ༌ལ༌རག༌, ‘ཁྱོ༌རང༌ སྐྱེ༌ཅེས༌མ༌ གྱུར༌ཏེ༌ ཁྱོ༌རང༌ང༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ཨིན༌། ཁྱོ༌རང༌ རྒུན༌ དང༌ ཞན༌ ར༌རོས༌ཤེས༌ ཆང༌གུན༌ ཐུང༌ མ༌གོས༌ ཡང༌ རྩང༌མ༌ མན༌ཁན༌ནི༌ ཟན༌ ཟའ༌ མ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོ༌ ན༌ཟི༌རཱའིགྲ༌ ཡང༌ན༌ སྐྱེས༌པ༌ནེ༌ ཤི༌ཤི༌ ཚག༌པ༌ དཀོན༌མཆོག༌གི༌ ཕིའ༌ ལྡམས༌ཁན༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","ཏེ༌ནེ༌ མ༌ནོ༌འཧའེ༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌, “ཡ༌ཝ༌ལེ༌ ཇུ༌ཇུ༌ ང༌ཞའ༌ ཇོར༌ཅེས༌ཅན༌ནི༌ བུ༌ཚ༌ ལྡན༌ཅུག༌ཅེས༌སི༌ སྐོར༌ལ༌ ལབ༌ཞ༌ སལ༌ཅེས༌ལ༌ ཉེ༌རང༌ངི༌ ཀལ༌ལ༌ ཛད༌ཁན༌ནི༌ དཀོན༌མཆོག༌གི༌ མི༌བོ༌ ཡང༌སྐྱར༌ ལམ༌ཅུག༌ག༌ ཛད༌ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","དཀོན༌མཆོག༌གི༌ མ༌ནོ༌འཧའེ༌ མོས༌ལམ༌མ༌ ལན༌སལས༌ ཡང༌ ཁོའེ༌ ན༌མ༌ ཞིང༌ངི༌ཀ༌ ཡོད༌ ཟ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉ༌ ཡང༌སྐྱར༌ ཇལ༌ ཨིན༌ནའང༌ ཁོའེ༌ མག༌པ༌ མ༌ནོ༌འཧ༌ ཁོ༌ ཉམ༌པོ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","ཁོ༌ གྱོགས༌པ༌ སོང༌ཏེ༌ ཁོ༌རང༌ངི༌ མག༌པ༌ ཟེརས༌, “ཞག༌ ཁ༌ཅིག༌གི༌ སྔུན༌ལ༌ ངའ༌ ཐོང༌ཁན༌ནི༌ མི༌བོ༌ ཡང༌སྐྱར༌ སྐྱོད༌ཏེ༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","མ༌ནོ༌འཧ༌ ཁོ༌རང༌ངི༌ ན༌མ༌ ཉམ༌པོ༌ བང༌ ཏངས༌ཏེ༌ སོང༌ ཡང༌ ཏྲིས༌, “ངའེ༌ ན༌མ༌ ཞལ༌ཏ༌ སལ༌ཁན༌ནི༌ མི༌བོ༌ ཉེ༌རང༌ ཨིན༌ན༌?” ཁོང༌ངི༌ ལན༌སལས༌, “ང༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","ཏེ༌ནེ༌ མ༌ནོ༌འཧའེ༌ ཁོང༌ང༌ ཏྲིས༌, “ཉེ༌རང༌ངི༌ མོལ༌ཁན༌བོ༌ དྲན༌དྲའ༌ གྲུབ༌བ༌ཅིག༌, མི༌ཚེའེ༌ ཕུད༌ཅེས༌ དང༌ ལས༌ ཅོ༌ཅེས༌སི༌ ནང༌ང༌ ཁོའེ༌ ཀ༌ཟུག༌ ཁྲིམས༌ ཁའ༌ ཉན༌གོས༌?” ");
INSERT INTO lbj_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ལན༌སལས༌, “ངའེ༌ ཁྱོ༌རང༌ངི༌ ན༌མའ༌ ལབ༌ཞ༌ ཏང༌ཁན༌གུན༌ ཅོ༌ ཅུག༌ཅེས༌ ཏན༌ཏན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","ཁོ༌ རྒྱུན༌ ཡ༌ བ༌ཤོ༌ ཟ༌མ༌གོས༌, རྒུན༌ དང༌ ཞན༌ ར༌རོས༌ཤེས༌ ཆང༌གུན༌ ཐུང༌ མ༌གོས༌ ཡང༌ རྩང༌མ༌ མན༌ཁན༌ནི༌ ཟན༌ ཟའ༌ མ༌གོས༌། ངའེ༌ ལབ༌ཞ༌ ཏང༌ཁན༌ ཚང༌མ༌ ཁོའེ༌ ཅོ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","ཏེ༌ནེ༌ མ༌ནོ༌འཧའེ༌ ཡ༌ཝའེ༌ ཕོ༌ཉའ༌ ཟེརས༌, “ཇུ༌ཇུ༌ ང༌ཞའེ༌ ར༌མ༌ ཆུ༌ངུན༌ནི༌ ཤ༌ སྐོལ༌ཏེ༌ ཁྱོང༌ཁྱོང༌ ཚོག༌པ༌ ཉེ༌རང༌ འི༌ཀ༌ ཞུགས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ལན༌སལས༌, “ང༌ དུག༌ཨིན༌། ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ཁྱོང༌ཁན༌ནི༌ ཁར༌ཇི༌ ངའེ༌ མི༌ཟ༌། ཏེ༌སང༌ཏ༌ ཁྱོ༌རང༌ངི༌ མེའ༌ སྲག༌ཅེས༌སི༌ ཆོད༌པ༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ ཡ༌ཝའ༌ ཕུལ༌ཉན༌ཅེས༌ ཨིན༌ནོག༌།” ༼ཁོང༌ ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ཨིན༌ཁན༌བོ༌ མ༌ནོ༌འཧ༌ ངོ༌ མ༌ཤེས༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","ཏེ༌ནེ༌ ཁོའེ༌ ཕོ༌ཉ༌ ཏྲིས༌, “ཉེ༌རང༌ངི༌ ཚན༌ལ༌ ཅི༌ ཞུ༌ཅེན༌? ཅིའ༌ཟེར༌ན༌ ཉེ༌རང༌ངི༌ མོལ༌ཁན༌བོ༌ གྲུབ༌བ༌ཅིག༌ ང༌ཞའེ༌ ཉེ༌རང༌ང༌ རྩི༌ཝ༌ ཕུལ༌ ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ལན༌སལས༌, “ཁྱོ༌རང༌ངི༌ ངའེ༌ མིང༌ ཅིའ༌ ཏྲིས༌ཏེ༌ ཨིན༌? ངའེ༌ མིང༌ངི༌ ཏོན༌ ཁྱོ༌རང༌གུན༌ལ༌ ཧ༌གོ༌ མི༌ ཐུབ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","ཏེ༌ནེ༌ མ༌ནོ༌འཧའེ༌ ར༌མ༌ ཆུ༌ངུན༌ དང༌ གྲུ༌ ཁྱོངས༌ ཡང༌ ཕོ༌ལོངས༌སི༌ཀ༌ མེའ༌ སྲགས༌ཏེ༌ ཡ༌ཝའ༌ ཆོད༌པ༌ ཕུལས༌། མ༌ནོ༌འཧ༌ དང༌ ཁོའེ༌ ན༌མ༌ ལྟས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ ཕོ༌ཉའེ༌ ཧ༌ལས༌ཤེས༌སི༌ ཆག༌ལས༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","ཏེ༌ ཆོད༌ཁྲི༌ ཀ༌ནེ༌ མེ༌ལྗབ༌ བིངས༌ཏེ༌ ཀེན༌ལ༌ ཆ༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ཏེ༌ མེའེ༌ ནང༌ང༌ ནམ༌ཁའ༌ སྐྱོདས༌། མ༌ནོ༌འཧ༌ དང༌ ཁོའེ༌ ན༌མའེ༌ ཏེ༌བོ༌ ཐོང༌ང༌ཅིག༌ རྩི༌ཝ༌ དང༌ ཇིགས༌སི༌ ནང༌ང༌ སའེ༌ཀ༌ གྱེལ༌ཏེ༌ ཆག༌ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","ཡ༌ཝའེ༌ ཕོ༌ཉ༌ ཏེ༌ མེའེ༌ ནང༌ང༌ ནམ༌ཁའ༌ སྐྱོད༌ཏེ༌ ཡང༌སྐྱར༌ མ༌ཐོང༌ པ༌སང༌ མ༌ནོ༌འཧ༌ ཁོང༌ ཡ༌ཝ༌ ཞུགས༌ཁན༌བོ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","ཡང༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ན༌མ༌ ཟེརས༌, “ང༌དང༌གུན༌ ཤིའ༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ང༌དང༌ངི༌ དཀོན༌མཆོག༌ ཇལ༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","ཨིན༌ནའང༌ ཁོའེ༌ ན༌མའེ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཡ༌ཝའེ༌ ང༌དང༌གུན༌ སད༌ད༌ ཛད༌ཅེས༌ ཨིན༌པིན༌ན༌, ཁོང༌ངི༌ ང༌དང༌ངི༌ མེའ༌ སྲག༌ཁན༌ དང༌ གྲུའི༌ ཆོད༌པ༌ མ༌ ནམས༌ས༌ ཡོད༌གྲོ༌ ཡང༌ ཁོང༌ངི༌ ང༌དང༌ང༌ འི༌ ཚང༌མ༌ སྟན༌ན༌ ཡང༌ མོལ༌ལ༌ ཛད༌ཏེ༌ མེད༌གྲོ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","ཁོའ༌ བུ༌ཚ༌ ཞིག༌ ཇོར༌ ཡང༌ ཁོའེ༌ མིང༌ང༌ སམ༌སོན༌ ཏགས༌། བུ༌ཚ༌བོ༌ ལྡན༌ཨིན༌ སོང༌ ཡང༌ ཡ༌ཝའེ༌ ཁོའ༌ ཅིན༌ལབས༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","ཟོ༌རཧ༌ དང༌ ཨེཤ༌ཏ༌འོལ༌ གྲོང༌ཁྱེར༌གུན༌ནི༌ པར༌ལ༌ ཡོད༌ཁན༌ མ༌ཧ༌ནེཧ༌ དཱན༌ ནས༌སའེ༌ ནང༌ང༌ ཁོ༌ དུག༌ ཟ༌ནེ༌ ཡ༌ཝའེ༌ ཐུག༌ཉིད༌དི༌ ཁོའེ༌ ནང༌ང༌ ཆག༌ལས༌ ཛད༌ཅེས༌ གོ༌ཟུག༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","ཞག༌ཤིག༌ སམ༌སོན༌ ཏིམ༌ནཧའེ༌ ནང༌ང༌ ཡོད༌ཏུས༌ ཁོའ༌ ཕི༌ལིས༌ཏི༌པ༌ བུ༌མོ༌ཞིག༌ ལྡེ༌མོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","ཁོ༌ ལོགས༌ཏེ༌ ཁང༌པ༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཕ༌མ༌གུན༌ལ༌ ཟེརས༌, “ཏིམ༌ནཧའེ༌ ནང༌ང༌ ངའ༌ ཕི༌ལིས༌ཏི༌པ༌ བུ༌མོ༌ཞིག༌ ལྡེ༌མོ༌ ཐོང༌, ཁོ༌ ང༌ ན༌མའ༌ ཁྱོང༌ང༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","ཁོའེ༌ ཨ༌བ༌ དང༌ ཨ༌མའེ༌ ལན༌ཏངས༌, “ཅི༌ ང༌དང༌ངི༌ སྡེ༌ ཡ༌ ཨིས༌ར༌ཨེལ༌ གང༌པོའེ༌ ནང༌ང༌ ཁྱོ༌རང༌ ཐད༌ཁན༌ནི༌ བུ༌མོ༌ ཅིག༌གའང༌ མི༌དུག༌ག༌? ཅིའ༌ ཁྱོ༌རང༌ ཡ༌ཝའ༌ མ༌ཅོལ༌ཁན༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ཕྲོའ༌ ན༌མ༌ ཙལ༌ལ༌ སོང༌པིན༌?” ཨིན༌ནའང༌ སམ༌སོན༌ནི༌ ཁོ༌རང༌ངི༌ ཨ༌བའ༌ ཟེརས༌, “ཏེན༌ན༌ བུ༌མོ༌བོ༌ ངའ༌ ན༌མ༌ ཁྱོང༌། ང༌ ཁོའ༌ ཐད༌ད༌ རག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","༼ཁོའེ༌ ཨ༌བ༌ དང༌ ཨ༌མ༌ འི༌བོ༌ ཡ༌ཝའེ༌ ཛད༌ཏེ༌ ཨིན༌ཁན༌བོ༌ ཧ༌ མ༌གོ༌, ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ཀ༌ ཝང༌ སྲུལ༌ཁན༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ལ༌ སམ༌སོན༌ གྱུད༌ཏེ༌ ནོལ༌ཅེས༌ལ༌ སྐབས༌ ཙལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","སམ༌སོན༌ དང༌ ཁོའེ༌ ཕ༌མ༌གུན༌ ཐུར༌ལ༌ ཏིམ༌ནཧའ༌ ཆ༌ ཟ༌ནེ༌ ཏིམ༌ནཧའེ༌ རྒུན༌ཚས༌སི༌ དུན༌ལ༌ ལེབ༌བ༌ཅིག༌ ཧུན༌མེད༌ལ༌ ལྡན༌ཁན༌ སིང༌གེ༌ཞིག༌ སམ༌སོན༌ ཆོགས༌ལ༌ བང༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","ཏེ༌ནེ༌ ཁོ༌ ཡ༌ཝའེ༌ ཐུག༌ཉིད༌དི༌ ཤེད༌དི༌ གངས༌ཏེ༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཉམ༌པོ༌ སིང༌གེ༌ ཁག༌ ཉིས༌སི༌ ནང༌ང༌ ཤགས༌ ཏངས༌། རི༌གུ༌ཞིག༌ ཤག༌ག༌ ཙོགས༌ལ༌ ཁོའེ༌ ཏེ༌བོ༌ མ༌ ལ༌མོ༌ ཉམ༌པོ༌ ཅོས༌། ཨིན༌ནའང༌ ཁོའེ༌ ཅོ༌ཁན༌བོ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ ཡ༌ ཨ༌མ༌ མ༌ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","སམ༌སོན༌ ཏིམ༌ནཧའེ༌ ནང༌ང༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ བུ༌མོ༌བོ༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏངས༌ ཡང༌ ཁོ༌ ཏེ༌ བུ༌མོའེ༌ཀ༌ སྲན༌ཏྲེ༌ ཐད༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","ཏུས༌ བན༌ཤིག༌གི༌ སྟིང༌ནེ༌ སམ༌སོན༌ ཏིམ༌ནཧའ༌ བག༌སྟོན༌ ཅོའ༌ལ༌ ཡོང༌ ཟ༌ནེ༌ ལམ༌བར༌ལ༌ ཁོ༌, ཁོའེ༌ སད༌ཁན༌ནི༌ སིང༌གེ༌བོའ༌ ལྟའ༌ལ༌ སོང༌ ཡང༌ ཏེ༌ ནང༌ང༌ བུང༌ང༌གུན༌ནི༌ རང༌རྩི༌ རྩགས༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","ཁོའེ༌ ཁོ༌རང༌ངི༌ ལག༌པ༌ ཉམ༌པོ༌ རང༌རྩི༌ ཁྱོངས༌ཏེ༌ གྲུལ༌ཨིན༌ ཟོས༌ ཡང༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཨ༌བ༌ དང༌ ཨ༌མ༌ ཏངས༌པ༌ ཁོང༌གུན༌ནིའང༌ ཟོས༌། ཨིན༌ནའང༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ རང༌རྩི༌ སིང༌གེ༌ རོའེ༌ ནང༌ནེ༌ ཁྱོངས༌ཏེ༌ ཨིན༌ཁན༌བོ༌ མ༌ཤདས༌ ། ");
INSERT INTO lbj_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","སམ༌སོན༌ནི༌ ཨ༌བ༌ ཁོའེ༌ ན༌མའེ༌ ཁང༌པ༌ སོང༌ ཡང༌ སམ༌སོན༌ནི༌ ལུག༌སྲོལ༌ ནང༌ཞིན༌ ཏིམ༌ནཧའེ༌ ནང༌ང༌ ཞུ༌ནུ༌ བུ༌ཚ༌གུན༌ལ༌ གྲོན༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","ཏིམ༌ནཧ༌པ༌གུན༌ནི ཏེ༌ གྲོན༌ནི༌ ནང༌ང༌ ཐུས༌ཏེ༌ ཁོའ༌ ཕྲོ༌པ༌ ཅོ༌ཅེས༌ལ༌ ཞུ༌ནུ༌ 30 ལྡམས༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","སམ༌སོན༌ནི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ངའེ༌ ཁྱོ༌ཞའ༌ ཚོད༌ལེན༌ཞིག༌ ཏྲི༌ཨིན༌། ཀལ༌ཏེས༌ གྲོན༌ནི༌ ཞག༌པོ༌ རྡུན༌ནི༌ ནང༌ང༌ ཁྱོ༌ཞའེ༌ ཏེ༌བོའ༌ ལན༌ཏང༌ ཉན༌ན༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཀོས༌ ཇམ༌པོ༌ རིན༌ཅན༌ 30 དང༌ གའ༌སྟོན༌ལ༌ གོན༌ཅེས༌སི༌ ཀོས༌ལག༌ 30 ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","ཨིན༌ནའང༌ ཁྱོ༌ཞའ༌ ལན༌ ཏང༌ མ༌ཉན༌ན༌ ཁྱོ༌ཞའེ༌ ངའ༌ ཀོས༌ ཇམ༌པོ༌ རིན༌ཅན༌ 30 དང༌ གའ༌སྟོན༌ལ༌ གོན༌ཅེས༌སི༌ ཀོས༌ལག༌ 30 ཏང༌གོས༌།” ཁོང༌གུན༌ནི༌ ཟེརས༌, “ཁྲིག༌ རག༌། ཚོད༌ལེན༌བོ༌ ཤོད༌, ང༌ཞའེ༌ ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","ཏེ༌ནེ༌ ཁོའེ༌ ཟེརས༌, “ཟའ༌ཁན༌ནི༌ ནང༌ནེ༌ ཟའ༌ཅེས༌ ཤིག༌། ཤེད༌ཅན༌ནི༌ ནང༌ནེ༌ ངར༌མོ༌ བིང༌།” ཞག༌མ༌ སུམ༌ ཁོང༌གུན༌ནི༌ ཏེ༌བོ༌ སེལ༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","ཞག༌མ༌ ཞི༌པའེ༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ སམ༌སོན༌ལ༌ ན༌མ༌ ཏྲིས༌ཁན༌ནི༌ བུ༌མོའ༌ ཟེརས༌, “གོབ༌སྐོར༌ཏེ༌ ཁྱོ༌རང༌ངི༌ མག༌པ༌ ཚོད༌ལེན༌ནི༌ ལན༌བོ༌ ཏྲིས༌ ཏེ༌མན༌ན༌ ང༌ཞའེ༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ ཨ༌བའེ༌ ནང༌ཚངས༌ མེའ༌ ཏུགས༌ཏེ༌ སད༌ཨིན༌། ཁྱོ༌རང༌ངི༌ ང༌ཞ༌གུན༌ བག༌སྟོན༌ནི༌ ནང༌ང༌ ཅོམ༌ཅེས༌ལ༌ བོད༌ པིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","ཏེ༌ནེ༌ སམ༌སོན༌ནི༌ ན༌མ༌ ཏྲིས༌ཁན༌ནི༌ བུ༌མོ༌ ངུ༌ཨིན༌ ཁོ༌ ཡོད༌ས༌ ཡོངས༌ཏེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ང༌ ཅེས༌པ༌ མ༌ཅོའ༌, ནཕ༌རད༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། ཁྱོ༌རང༌ངི༌ ངའེ༌ མི༌གུན༌ལ༌ ཚོད༌ལེན༌ཞིག༌ ཏྲིས༌ཏོག༌ ཨིན༌ནའང༌ ཁྱོ༌རང༌ངི༌ ངའ༌ ཏེ༌བོའེ༌ ལན༌ མ༌ཤདས༌།” ཁོའེ༌ ལན༌ཏངས༌, “ངའེ༌ ང༌རང༌ངི༌ ཨ༌བ༌ ཡ༌ ཨ༌མ༌ ཏེ༌བོའེ༌ ལན༌ མ༌ཤདས༌པིན༌། ཏེ༌ནེ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཅིའ༌ ཤད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","ཏེ༌ནེ༌ བུ༌མོ༌ གའ༌སྟོན༌ནི༌ ཞག༌ རྡུན༌བོ༌ ངུ༌ཨིན༌ དུགས༌། ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ སམ༌སོན༌ནི༌ ཁོའ༌ ལན༌བོ༌ ཤདས༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཞག༌ཏང༌ ཏྲི༌ཨིན༌ དུགས༌ཏེ༌ ཁོའ༌ སྣང༌ང༌ཚེར༌ ཅུགས༌། ཏེ༌ནེ༌ བུ༌མོའེ༌ ཚོད༌ལེན༌ནི༌ ཏོན༌བོ༌ ཞུ༌ནུ༌ གུན༌ལ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","ཞག༌མ༌ རྡུན༌པའེ༌ ཞག༌ག༌ ཉི༌མ༌ སྐྱོད༌དི༌ སང༌ སྔུན༌ལ༌, གྲོང༌ཁྱེར༌རི༌ ཞུ༌ནུ༌གུན༌ སམ༌སོན༌ ཡོད༌ས༌ ཡོངས༌ཏེ༌ ཟེརས༌, “རང༌རྩི༌ སང༌ ངར༌མོ༌ ཅི༌ ཡོད༌? སིང༌གེ༌ སང༌ ཤེད༌ཅན༌ སུ༌ ཨིན༌?” སམ༌སོན༌ནི༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཁྱོ༌རང༌གུན༌ནི༌ ངའེ༌ ན༌མ༌ ཇིགས༌ནང༌ མ༌སྟན༌པིན༌ན༌ ཁྱོ༌ཞའ༌ འི༌བོའེ༌ ལན༌ མ༌ ཐོབ༌བ༌ ཡོད༌གྲོ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","ཏེ༌ནེ༌ ཡ༌ཝའེ༌ ཐུག༌ཉིད༌དི༌ ཤེད༌དི༌ གངས༌ཏེ༌ ཁོ༌ ཐུར༌ལ༌ ཨཤ༌ཀེ༌ལོན༌ གྲོང༌ཁྱེར༌ལ༌ སོང༌ཏེ༌ བུ༌ཚ༌ སུམ༌ཅུ༌ སདས༌ ཡང༌ ཁོང༌གུན༌ གོན༌ཏེ༌ ཡོད༌ཁན༌གུན༌ པུད༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཚོད༌ལེན༌ནི༌ ཏོན༌ ཤད༌ཁན༌ནི༌ ཞུ༌ནུ༌གུན༌ལ༌ ཁོང༌གུན༌ནི༌ ཀོས༌གུན༌ ཏངས༌། ཨིན༌ནའང༌ སམ༌སོན༌ལ༌ སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌ ཡང༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","ཡང༌ སམ༌སོན༌ལ༌ ན༌མ༌ ཏྲིས༌ཁན༌ནི༌ བུ༌མོ༌ ཁོའེ༌ ཛ༌འོ༌ ཉེ༌མོ༌བོའ༌ ན༌མ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","སྟིང༌ནེ༌ ཀྲོའེ༌ རྔབ༌སའེ༌ ཏུས༌ལ༌ སམ༌སོན༌ནི༌ ལོ༌ ཆུ༌ངུན༌ ར༌མ༌ཞིག༌ ཁུར༌ཏེ༌ ཁོའ༌ ན༌མ༌ ཏྲི༌ཁན༌ནི༌ བུ༌མོའ༌ ཐུག༌ག༌ ཏིམ༌ནཧ༌ སོང༌། ཁོའེ༌ ཟེརས༌, “ང༌ ང༌རང༌ངི༌ ན༌མ༌ ཏྲི༌ཁན༌ནི༌ བུ༌མོའེ༌ ནང༌ང༌ ཆའད༌།” ཨིན༌ནའང༌ བུ༌མོའེ༌ ཨ༌བའེ༌ ཁོ༌ ཆ༌མ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","ཁོའེ༌ སམ༌སོན༌ལ༌ ཟེརས༌, “ངའེ༌ སམ༌, ཁྱོ༌རང༌ང༌ སྲོ༌ ཡོངས༌ཏེ༌ ཁོའ༌ ནཕ༌རད༌ ཅོའ༌ནོག༌། ཏེ༌བོའེ༌ཕིའ༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ ཛ༌འོ༌ ཉེ༌མོ༌བོའ༌ ཁོ༌ ན༌མ༌ ཏངས༌པིན༌། ཨིན༌ནའང༌ ལྟོས༌སའང༌ ཁོའེ༌ ནོ༌མོ༌ ཁོའེ༌ སང༌ མང༌ང༌ ལྡེ༌མོ༌ དུག༌, ཁོ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","སམ༌སོན༌ནི༌ ཟེརས༌, “ཏ༌ འི༌ལན༌, ངའ༌ ཁྱོ༌ཞའ༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ལ༌ ནོད༌པ༌ ཏང༌ཅེས༌ལ༌ ཏོན༌ཚན༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","ཏེ༌ནེ༌ ཁོ༌ ཕི༌ལོག༌ག༌ སོང༌ ཡང༌ ཝ༌ཙེ༌ 300 ཟུམས༌ ཡང༌ ཆ༌ ཅོས༌ཏེ༌ ཏེ༌གུན༌ནི༌ ང༌མ༌ ལྡམས༌། ང༌མ༌གུན༌ནི༌ཀ༌ པམ༌བར༌ ཏགས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","མེ༌ ཏུགས༌། ཏེ༌ནེ༌ ཝ༌ཙེ༌གུན༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ཀྲོའེ༌ ཞིང༌གུན༌ནི༌ ནང༌ང༌ བང༌ཏངས༌པ༌ རྔས༌ཁན༌ དང༌ མ༌ རྔས༌ཁན༌ ཞིང༌ ཡང༌ རྒྱུན༌ དང༌ ཨོ༌ལིཝ༌ཝི༌ ཚས༌ ཚང༌མ༌ མེ༌ ཞེན༌ཏེ༌ མེད༌ཁན༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ཏྲིས༌, “འི༌བོ༌ སུའི༌ ཅོས༌?” “ཏིམ༌ནཧ༌པ༌ སམ༌སོན༌ནི༌ ན༌མ༌ ཏྲི༌ཁན༌ནི༌ བུ༌མོའེ༌ ཨ༌བའེ༌ ཁོའེ༌ བུ༌མོ༌ སམ༌སོན༌ནི༌ ཛ༌འོ༌ ཉེ༌མོ༌བོའ༌ ན༌མའ༌ ཏངས༌ པ༌སང༌ ཁོའེ༌ ཅོས༌” ཟེར༌ཏེ༌ ཤདས༌། ཏེ༌ནེ༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ སོང༌ཏེ༌ ཏེ༌ བུ༌མོ༌ དང༌ ཁོའེ༌ ཨ༌བ༌ མེའ༌ སྲགས༌ཏེ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","ཁོང༌གུན༌ནི༌ ཏེ༌ཟུག༌ ཅོས༌ པ༌སང༌ སམ༌སོན༌ནི༌ ཟེརས༌, “ཁྱོ༌རང༌གུན༌ནི༌ ཅོ༌ཁན༌བོའ༌ ལན༌ཏངས༌ཏེ༌ མ༌ནེ༌ ང༌ ངལ༌ མི༌ཚོ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ཁོང༌ མང༌པོ༌ སྙིང༌རྗེ༌ མེད༌པ༌ སདས༌། ཏེ༌ནེ༌ ཁོ༌ སོང༌ཏེ༌ ཨེ༌ཏམ༌མི༌ རི༌ བྲག༌ཕུགས༌སི༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","ཕི༌ལིས༌ཏི༌པ༌གུན༌ ཀེན༌ལ༌ སོང༌ཏེ༌ ཡ༌ཧུ༌དཱའེ༌ ནང༌ང༌ ལེ༌ཧིའི༌ གྲོང༌ཁྱེར༌རི༌ ཉེ༌ཁོར༌ལ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","ཡ༌ཧུ༌དཱ༌པ༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཏྲིས༌, “ཁྱོ༌ཞའ༌ ང༌ཞ༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོའ༌ལ༌ ཅིའ༌ ཡོངས༌ཏེ༌ ཨིན༌?” ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞ༌གུན༌ནི༌ སམ༌སོན༌ ཟུམས༌ཏེ༌ ཁོའེ༌ ང༌ཞའ༌ ཅོ༌ཁན༌ ཙོགས༌ ཁོའ༌ ཅོའ༌ལ༌ ཡོངས༌ཏེ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","ཏེ༌ནེ༌ ཡ༌ཧུ༌དཱ༌པ༌ མི༌ སྟོང༌ སུམ༌ ཐུར༌ལ༌ ཨེ༌ཏམ༌མི༌ རི༌ བྲག༌ཕུགས༌སི༌ ནས༌ས༌ སོང༌ཏེ༌ སམ༌སོན༌ལ༌ ཟེརས༌, “ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ང༌དང༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌ཅེས༌པོ༌ ཁྱོ༌རང༌ང༌ ཧ༌ མ༌གོའ༌ ཨིན༌ན༌? ཁྱོ༌རང༌ངི༌ ང༌ཞ༌གུན༌ལ༌ འི༌ཟུག༌ ཅིའ༌ ཅོས༌ཏེ༌ ཨིན༌?” སམ༌སོན༌ནི༌ ལན༌ཏངས༌, “ཁོང༌གུན༌ནི༌ ངའ༌ ཅོས༌ཁན༌བོ༌ ཙོགས༌ ངའེ༌ ཁོང༌གུན༌ལ༌ ཅོས༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","ཨིན༌ནའང༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ནི༌ ཁོའ༌ ཟེརས༌, “ང༌ཞའ༌ འི༌རུ༌ ཁྱོ༌རང༌ ལྡམས༌ཏེ༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ད༌ལ༌ ཡོངས༌པིན༌།” སམ༌སོན༌ནི༌ ཟེརས༌, “ཁྱོ༌ཞ༌རང༌ངི༌ ང༌ མི༌སད༌ ཟེར༌ཏེ༌ ནའ༌ ཁུར༌།” ");
INSERT INTO lbj_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ང༌ཞའེ༌ ཁྱོ༌རང༌ མི༌སད༌ ཨིན༌ནའང༌ ལྡམས༌ཏེ༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ལག༌ག༌ སྟད༌ཨིན༌།” ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཁོ༌ ཐག༌པ༌ སོ༌མ༌ ཉིས༌ ཉམ༌པོ༌ ལྡམས༌ ཡང༌ ཁོ༌ བྲག༌ཕུགས༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","སམ༌སོན༌ ལེ༌ཧི༌ གྲོང༌ཁྱེར༌རི༌ ཉེ༌མོའ༌ ལེབ༌བ༌ཅིག༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ གྱལ༌ཁའ༌ ཐོབ༌ཁན༌ནི༌ ཀུ༌ཅོ༌ ཏང༌ཨིན༌ ཡོངས༌། ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ཐུག༌ཉིད༌དི༌ ཤེད༌དི༌ གངས༌ཏེ༌ ཁོའེ༌ ལྡམས༌ཁན༌ནི༌ ཐག༌པ༌ སོ༌མ༌བོ༌ རུལ༌ཁན༌ནི༌ ཐག༌པ༌ ཉིང༌པ༌ ཙོགས༌ལ༌ ལ༌མོ༌ ཉམ༌པོ༌ ཅདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","ཡང༌ ཁོའེ༌ ཉེ༌ཐུབ༌རང༌ ཤི༌ཁན༌ བུང༌བུའི༌ གྲམ༌པའེ༌ རུས༌པ༌ ཁུར༌ཏེ༌ ཕི༌ལིས༌ཏི༌པ༌ སྟོང༌ཅིག༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","ཏེ༌ནེ༌ སམ༌སོན༌ནི༌ ཟེརས༌, “བུང༌བུའི༌ གྲམ༌པའེ༌ རུས༌པ༌ ཉམ༌པོ༌ ངའེ༌ ཁོང༌གུན༌ནི༌ རོ༌གུན༌ སྤུངས༌པིན༌། བུང༌བུའི༌ གྲམ༌པའེ༌ རུས༌པ༌ ཉམ༌པོ༌ ངའེ༌ མི༌ སྟོང༌ཅིག༌ སད༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","ཏེ༌བོ༌ ཟེར༌ ཚར༌ཏེ༌ སྟིང༌ནེ༌ ཁོའེ༌ གྲམ༌པའེ༌ རུས༌པ༌བོ༌ ཐག༌རིང༌ང༌ ཕངས༌། ཏེ༌ ས༌ཀྱད༌པོའ༌ གྲམ༌པའེ༌ རུས༌པའེ༌ རི༌ ཟེར༌ཏེ༌ མིང༌ ཐོགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","སམ༌སོན༌ མ༌སྲན༌ཏྲེ༌ སྐོམས༌ཏེ༌ ཡོད༌པ༌ ཁོའེ༌ ཡ༌ཝའ༌ ཞུས༌, “ཉེ༌རང༌ངི༌, ཉེ༌རང༌ངི༌ ཡོག༌པོའ༌ གྱལ༌ཁ༌ ཀྲག༌པོ༌ སལ༌ལ༌ ཛདས༌། ཏ༌ ང༌ སྐོམས༌ཏེ༌ ཤི༌ ཅུག༌ག༌ ཛད༌ཏེ༌ ཡ༌ཝའ༌ མ༌ཅོལ༌ཁན༌ འི༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ལག༌ག༌ ང༌ སལ༌ལ༌ ཛད༌ཅེས༌ ཨིན༌ན༌?” ");
INSERT INTO lbj_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","ཏེ༌ནེ༌ དཀོན༌མཆོག༌གི༌ ལེ༌ཧི༌ ས༌ཀྱད༌ ཁོ༌ ཡོད༌སའེ༌ཀ༌ ཆུ༌ བིང༌ ཅུག༌ག༌ ཛདས༌། སམ༌སོན༌ ཆུ༌ ཐུངས༌ ཡང༌ ཁོའེ༌ ཟུགས༌པོའེ༌ ནང༌ང༌ ཡང༌སྐྱར༌ སྟོབས༌ སྐྱེས༌། ཏེ༌ནེ༌ ཁོའེ༌ ཏེ༌ ཆུ༌མིག༌པོའ༌ “བོད༌ཁན༌ནི༌ ཆུ༌མིག༌” ཟེར༌ཏེ༌ མིང༌ ཏགས༌ ཡང༌ ཏེ༌བོ༌ དག༌སའང༌ ལེ༌ཧི༌ ནང༌ང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","སམ༌སོན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ ལོ༌ 20 ཅོས༌། ཏེ༌ཏུས༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ཏེ༌ ནས༌སའེ༌ ནང༌ང༌ ཝང༌སྲུལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","ཞག༌ཤིག༌ སམ༌སོན༌ ག༌ཟ༌ གྲོང༌ཁྱེར༌ལ༌ སོང༌, ཏེ༌རུ༌ ཁོའ༌ ཟུགས༌ཙོང༌མ༌ཞིག༌ ཐུག༌ ཡང༌ ཏེ༌ ཚན༌བོ༌ སམ༌སོན༌ ཁོ༌ ཉམ༌པོ༌ དུག༌ག༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","སམ༌སོན༌ ཏེ༌རུ༌ ཡོད༌ཁན༌བོ༌ ག༌ཟ༌པ༌གུན༌ལ༌ ཚོར༌ པ༌སང༌ ཁོང༌གུན༌ནི༌ ཏེ༌ ནས༌སའ༌ ཐའ༌ སྐོར༌ཏེ༌ ཚན༌ གང༌པོ༌ གྱལ༌སའེ༌ སྒོའེ༌ཀ༌ སྲུང༌ཏེ༌ དུགས༌། ཚན༌ལ༌ སྲུངས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཟེརས༌, “ནམ༌ ལངས༌ས༌ཅིག༌ ང༌དང༌གུན༌ནི༌ ཁོ༌ སད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","ཨིན༌ནའང༌ སམ༌སོན༌ ཏེ༌རུ༌, ཚན༌ ཕེད༌ ཚོག༌པ༌ མ༌ནེ༌ མ༌དུགས༌། ཚན༌ ཕེད༌ལ༌ ཁོ༌ སོང༌ཏེ༌ གྱལ༌སའེ༌ གྱས༌སྒོའེ༌ ཀ༌ཝ༌ ཉིས༌ཀོ༌ ཐམས༌ཏེ༌ རིབ༌ཞི༌ རགས༌ཏེ༌ ཀོགས༌ ཡང༌ སྤུང༌པའེ༌ཀ༌ ཁུར༌ཏེ༌ ཧེབ༌རོན༌ནི༌ དུན༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ནི༌ རི༌ གོའེ༌ཀ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","ཏུས༌ བན༌ཞིག༌གི༌ སྟིང༌ནེ༌ སོ༌རེག༌ ལུང༌པའེ༌ ནང༌ང༌ དུག༌ཁན༌ བུ༌མོ༌ དེ༌ལཱེ༌ལཧ༌ལ༌ སམ༌སོན༌ སྲན༌ཏྲེ༌ ཐད༌དད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","ཕི༌ལིས༌ཏི༌པའེ༌ ཝང༌སྲུལ༌པ༌གུན༌ ཏེ༌ བུ༌མོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ལུས༌ཏེ༌ སམ༌སོན༌ནི༌ ཤེད༌དི༌ སང༌ཝ༌ ཡང༌ ང༌ཞའ༌ ཏེ༌ཀ༌ ཝང༌ ཅོ༌ཉན༌ཅེས༌པོ༌ གྱུས༌ཅོ༌ན༌, ང༌ཞའ༌ རེ༌རེ༌ ཁྱོ༌རང༌ང༌ མུལ༌ལི༌ པེ༌ནེ༌ 1,100 ཏང༌ཨིན༌། ཏེ༌ནེ༌ ང༌ཞ༌གུན༌ནི༌ ཁོ༌ ལྡམས༌ཏེ༌ ཝང༌ངི༌ ཡོག༌ག༌ ཁྱོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","དེ༌ལཱེ༌ལཧའེ༌ སམ༌སོན༌ལ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ཤེད༌ ཀྲག༌པོ༌ ཡང༌ ཉེ༌རང༌ ལྡམས༌ཏེ༌ ཝང༌ངི༌ ཡོག༌ག༌ ཁྱོང༌ ཉན༌ཅེས༌སི༌ སང༌ཝ༌བོ༌ ང༌ ཤོད༌དའང།” ");
INSERT INTO lbj_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","སམ༌སོན༌ནི༌ ལན༌ཏངས༌, “ཀལ༌ཏེས༌ ངའ༌ ཞུའི༌ སྐུད༌པ༌ ལོན༌པ༌ རྡུན༌ ཉམ༌པོ༌ ལྡམ༌ན༌, ང༌ ཞན༌གུན༌ ཙོགས༌ ཤེད༌མེད༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","ཏེ༌ནེ༌ ཕི༌ལིས༌ཏི༌པའེ༌ ཝང༌སྲུལ༌པ༌གུན༌ནི༌ བུ༌མོ༌བོའ༌ ཞུའི༌ སྐུད༌པ༌ ལོན༌པ༌ རྡུན༌ ཏངས༌ ཡང༌ ཁོའེ༌ ཏེ༌གུན༌ ཉམ༌པོ༌ སམ༌སོན༌ ལྡམས༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","ཁོའེ༌ ཁང༌པའེ༌ ནང༌ང༌ མི༌གུན༌ ཨིབས༌ཏེ༌ ཡོད༌པིན༌། ཁོའེ༌ སམ༌སོན༌ལ༌ བོད༌ཏེ༌ ཟེརས༌, “སམ༌སོན༌, ཕི༌ལིས༌ཏི༌པ༌གུན༌ ཁྱོ༌རང༌ ཟུམ༌མ༌ ཡོངས༌ཏེ༌ དུག༌།” ཨིན༌ནའང༌ ཁོའེ༌ ཏེ༌ ཀོའེ༌ སྐུད༌པ༌གུན༌ མེའ༌ ཚིག༌ཏེ༌ ཆད༌ཁན༌ ཙོགས༌ལ༌ མ༌ ལ༌མོ༌ ཉམ༌པོ༌ ཅདས༌། ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ ཤེད༌དི༌ སང༌ཝ༌བོ༌ གྱུས༌ མ༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","ཏེ༌ནེ༌ དེ༌ལཱེ༌ལཧའེ༌ སམ༌སོན༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཟུན༌ ཏངས༌ཏེ༌ ང༌ བུང༌བུ༌ ཅོས༌, ཤོད༌དའང༌ ཀ༌ཟུག༌གི༌ ཁྱོ༌རང༌ སྟན༌པོ༌ ཅོས༌ཏེ༌ ལྡམ༌ ཉན༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","ཁོའེ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ངའ༌ མ༌ནེ༌ མ༌ ཀོལ༌ཁན༌ ཐག༌པ༌ སོ༌མ༌ ཉམ༌པོ༌ ལྡམ༌ན༌ ང༌ ཞན༌གུན༌ ཙོགས༌ ཤེད༌མེད༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","ཏེ༌ནེ༌ དེ༌ལཱེ༌ལཧའེ༌ ཐག༌པ༌ སོ༌མ༌ ཁྱོངས༌ཏེ༌ ཁོ༌ སྟན༌པོ༌ ཅོས༌ཏེ༌ ལྡམས༌། ཁོའེ༌ ཁང༌པའེ༌ ནང༌ང༌ མི༌གུན༌ ཨིབས༌ཏེ༌ ཡོད༌པིན༌། ཁོའེ༌ སམ༌སོན༌ལ༌ བོད༌ཏེ༌ ཟེརས༌, “སམ༌སོན༌, ཕི༌ལིས༌ཏི༌པ༌གུན༌ ཁྱོ༌རང༌ ཟུམ༌མ༌ ཡོངས༌ཏེ༌ དུག༌།” ཨིན༌ནའང༌ སམ༌སོན༌ནི༌ ལག༌པའ༌ ལྡམས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ ཐག༌པ༌བོ༌ སྐུད༌པ༌ ཙོགས༌ལ༌ ཅདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","དེ༌ལཱེ༌ལཧའེ༌ སམ༌སོན༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཟུན༌ ཏངས༌ཏེ༌ དག༌ས༌ ཚོག༌པ༌ ངའ༌ བུང༌བུ༌ ཅོས༌། ཤོད༌དའང༌ ཀ༌ཟུག༌གི༌ ངའེ༌ ཁྱོ༌རང༌ ལྡམ༌ ཉན༌ཨིན༌།” ཁོའེ༌ ལན༌ཏངས༌, “ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ སྲའེ༌ ཏུམ༌པ༌ རྡུན༌ ཁྲི༌ཤའེ༌ ནང༌ང༌ ཐགས༌ཏེ༌ པུར༌ཆ༌ གྱབ༌ན༌, ང༌ ཞན༌གུན༌ ཙོགས༌ ཤེད༌མེད༌ གྱུར༌ཨིན༌།” ཏེ༌ནེ༌ དེ༌ལཱེ༌ལཧའེ༌ སམ༌སོན༌ ཉིད༌ལོགས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཁོའེ༌ སྲའེ༌ ཏུམ༌པ༌ རྡུན༌ ཁྲི༌ཤའེ༌ ནང༌ང༌ ཐགས༌ ");
INSERT INTO lbj_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","ཡང༌ པུར༌ཆ༌ གྱབས༌ཏེ༌ སྟན༌པོ༌ ཅོས༌། ཡང༌སྐྱར༌ ཁོའ༌ ཟེརས༌, “སམ༌སོན༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ ཁྱོ༌རང༌ ཟུམ༌མ༌ ཡོངས༌ཏེ༌ དུག༌།” ཁོའེ༌ ཉིད༌ཚད༌ ཡང༌ པུར༌ཆ༌ དང༌ ཁྲི༌ཤ༌ ཉིས༌ཀོ༌ ཐགས༌ཁན༌ནི༌ སྲའ༌ ཉམ༌པོ༌ ཕུད༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","ཏེ༌ནེ༌ བུ༌མོའེ༌ ཁོའ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ང༌ ཅེས༌པ༌ ཅོའད༌ ཟེར༌ཏེ༌ ཀ༌ཟུག༌གི༌ ཟེར༌རད༌ ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ ངའེ༌ཀ༌ ལོ༌ཁྱེལ༌ ཅོའ༌ མེད༌ན༌? ཁྱོ༌རང༌ངི༌ ཤེད༌ ཀྲག༌པོའེ༌ སང༌ཝ༌བོ༌ མ༌ཤད༌ད༌ ཁྱོ༌རང༌ངི༌ ང༌ ལན༌ སུམ༌པ༌ བུང༌བུ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","ཏེ༌ནེ༌ བུ༌མོའེ༌ ཞག༌ཏང༌ ཏེན༌ན༌བོ༌ ཏྲི༌ཨིན༌ དུགས༌ཏེ༌ ཁོའ༌ མ༌ སྲན༌ཏྲེ༌ སྣང༌ང༌ ཚེར༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ བུ༌མོའ༌ སང༌ཝ༌བོ༌ ཤདས༌, “ང༌ སྐྱེས༌པ༌ནེ༌ ཕར༌ལ༌ ན༌ཟི༌རཱའིགྲ༌ ཡང༌ན༌ དཀོན༌མཆོག༌གི༌ ཕིའ༌ ལྡམས༌ཁན༌ ཨིན༌ཅེས༌པའེ༌ ངའེ༌ སྲའ༌ མ༌ནེ༌ མ༌ བྲག༌ག༌ ཨིན༌། ཀལ༌ཏེས༌ ངའེ༌ སྲའ༌ བྲག༌ན༌, ངའེ༌ ཤེད༌པོ༌ ངའེ༌ ནང༌ནེ༌ བིང༌ཏེ༌ ཆེན༌ ཡང༌ ང༌ ཞན༌གུན༌ ཙོགས༌ ཤེད༌མེད༌ གྱུར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","ཁོའེ༌ ཟེར༌ཁན༌བོའ༌ དེ༌ལཱེ༌ལཧ༌ དེན༌ཤེས༌ ཡང༌ ཕི༌ལིས༌ཏི༌པའེ༌ ཝང༌སྲུལ༌པ༌གུན༌ལ༌ ལོན༌ ཀལས༌, “ཡང༌ ལན༌ཅིག༌ ལོགས༌ཏེ༌ སྐྱོད༌, ཁོའེ༌ ང༌ ཅི༌ཚང༌མ༌ ཤད༌ད༌རག༌།” ཏེ༌ནེ༌ ཕི༌ལིས༌ཏི༌པའེ༌ ཝང༌སྲུལ༌པ༌གུན༌ མུལ༌ ཁུར༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","བུ༌མོའེ༌ ཁོ༌རང༌ངི༌ པང༌ངི༌ཀ༌ ཁོ༌ ཉིད༌ལ༌ ཏངས༌ ཡང༌ མི༌ཞིག༌ བོད༌ཏེ༌ ཁོའེ༌ སྲའ༌ ཏུམ༌པ༌ རྡུན༌བོ༌ བྲག༌ ཅུགས༌། ཏེན༌ན༌ ཟུག༌གི༌ སམ༌སོན༌ ཤེད༌མེད༌ གྱུར༌ཅུགས༌ ཡང༌ ཁོའེ༌ ཤེད༌པོ༌ ཁོ༌ ཕངས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","ཏེ༌ནེ༌ བུ༌མོ༌བོའེ༌ ཟེརས༌, “སམ༌སོན༌, ཕི༌ལིས༌ཏི༌པ༌གུན༌ ཁྱོ༌རང༌ ཟུམ༌མ༌ ཡོངས༌ཏེ༌ དུག༌།” ཁོའ༌ ཉིད༌ཚད༌ ཡང༌ སམ༌, “སྔུན༌ ཙོགས༌ལ༌ ངའེ༌ ཐག༌པ༌གུན༌ ཅད༌ཏེ༌ ང༌རང༌ སྐྱོབ༌ཨིན༌ ཨིན༌ནའང༌ ཡ༌ཝའ༌ ཁོ༌ ཕངས༌ཏེ༌ སྐྱོད༌ཁན༌བོ༌ ཁོའ༌ གྱུས༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","ཏེ༌ནེ༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ཁོ༌ ཟུམས༌ཏེ༌ ཁོའེ༌ མིག༌གུན༌ བྲུས༌ཏེ༌ ཕིངས༌ ཡང༌ ཁོ༌ ཐུར༌ལ༌ ག༌ཟ༌ གྲོང༌ཁྱེར༌ལ༌ ཁྱེརས༌། ཏེ༌རུ༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ ཁོའ༌ ལྕག༌ཐག༌ ཏགས༌ཏེ༌ གྲུ༌ ཐག༌ཅེས༌སི༌ རན༌ཐག༌ སྐོར༌ ཅུག༌གད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","ཨིན༌ནའང༌ ཁོའེ༌ སྲའ༌ ཡང༌སྐྱར༌ སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","ཏ༌ ཕི༌ལིས༌ཏི༌པའེ༌ ཝང༌སྲུལ༌པ༌གུན༌ ཁོང༌གུན༌ནི༌ ལྷ༌ གྲ༌གོན༌ལ༌ ཆོད༌པ༌ ཕུལ༌ཏེ༌ གའ༌སྟོན༌ རྩི༌ཅེས༌ལ༌ ཛོམས༌ ཡང༌ ཟེརས༌, “ང༌དང༌ངི༌ ལྷའེ༌ ང༌དང༌གུན༌ནི༌ གྲ༌འོ༌ སམ༌སོན༌ ང༌དང༌ངི༌ ལག༌ག༌ སལ༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","སམ༌སོན༌ ཐོང༌ང༌ཅིག༌ མི༌གུན༌ནི༌ ཁོང༌རང༌གུན༌ནི༌ ལྷ༌ སྟོད༌པ༌ ཕུལ༌ཏེ༌ ཟེརས༌, “ང༌ཞའེ༌ ལྷའེ༌ ང༌ཞ༌གུན༌ནི༌ གྲ༌འོ༌ ང༌ཞ༌གུན༌ནི༌ ལག༌ག༌ སལ༌ཏེ༌ ཨིན༌ནོག༌། ཁོའེ༌ ང༌དང༌གུན༌ནི༌ སྟོན༌ཐོག༌ ཚང༌མ༌ མེད༌ཁན༌ ཅོས༌ ཡང༌ ང༌དང༌ མང༌པོ༌ སདས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","ཁོང༌གུན༌ནི༌ སྐྱིད༌པོ༌ ཅོ༌ཨིན༌ ར༌རོས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ང༌དང༌གུན༌ལ༌ སེམས༌སྐྱིད༌ ཁྱོང༌ཅེས༌སི༌ ཕིའ༌ སམ༌སོན༌ ཙོན༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོང༌།” ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ སམ༌སོན༌ ཙོན༌ཁང༌ནེ༌ ཕིངས༌ཏེ༌ ཁྱོངས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཟེར༌ཁན༌གུན༌ ཁོའ༌ ཅོ༌ཅུགས༌ཏེ༌ སེམས༌སྐྱིད༌ ལེནས༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ སམ༌སོན༌ ཀ༌ཝ༌གུན༌ནི༌ པར༌ལ༌ ལངས༌ཏེ༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","སམ༌སོན༌ནི༌ ཁོའེ༌ ལག༌པ༌ ཟུམས༌ཏེ༌ ཡོད༌ཁན༌བོའ༌ ཟེརས༌, “ཆོད༌ཁང༌ངི༌ ལྕིད༌ ཁུར༌ཁན༌ ཀ༌ཝ༌ ཁག༌ཅན༌གུན༌ནི༌ཀ༌ ངའེ༌ ལག༌པ༌ བོར༌ ང༌ ཏེ༌ཀ༌ སྟེན༌ཏེ༌ ངལ༌ཚོ༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","ཏ༌ ཆོད༌ཁང༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ མང༌པོའེ༌ གངས༌ཏེ༌ ཡོད༌པིན༌, ཏེ༌ ཕྲོའ༌ ཕི༌ལིས༌ཏི༌པའེ༌ ཝང༌སྲུལ༌པ༌ ཚང༌མ༌ ཡང༌ ཐོག༌གི༌ཀ༌ ཡོད༌ཁན༌ ཧ༌ལམ༌ བུ༌ཚ༌ དང༌ བུ༌མོ༌ སྟོང༌ སུམ༌མི༌ སམ༌སོན༌ལ༌ ཁོང༌གུན༌ ཐད༌ཁན༌ ཅོ༌ཅུགས༌ཏེ༌ སེམས༌སྐྱིད༌ ལེན༌ཁན༌བོ༌ ལྟའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","སམ༌སོན༌ནི༌ ཡ༌ཝའ༌ མོས༌ལམ༌ ཞུས༌, “ནམ༌ཁའེ༌ གྱལ༌པོ༌ ཡ༌ཝ༌ལེ༌ ང༌ ཨིད༌ཏུ༌ ཛད༌། དཀོན༌མཆོག༌ལེ༌ ཇུ༌ཇུ༌ ངའ༌ ཡང༌ ལན༌ཅིག༌ ཤེད༌སྟོབས༌ སལ༌ལ༌ ཛད༌། འིན༌ན༌ ལན༌ཅིག༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ནི༌ ངའེ༌ མིག༌གུན༌ བྲུས༌ཁན༌ནི༌ ཕིའ༌ ངའ༌ ལན༌ ཏང༌ཅུག༌ག༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","ཏེ༌ནེ༌ སམ༌སོན༌ནི༌ ཆོད༌ཁང༌ངི༌ ཞུང༌སྐྱིལ༌ལི༌ ཀ༌ཝ༌ ཉིས༌ཀོའེ༌ཀ༌ ལག༌པ༌ བོརས༌, ཡས༌པ༌ ཅིག༌གི༌ཀ༌ ཡང༌ ཡོ༌མ༌ ཅིག༌ག༌, ");
INSERT INTO lbj_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","ཡང༌ ཟེརས༌ “ང༌ ཕི༌ལིས༌ཏི༌པ༌གུན༌ ཉམ༌པོ༌ ཤི༌ཅུག༌ག༌ ཛད༌།” ཏེ༌ནེ༌ ཤེད༌ གང༌པོ༌ ཉམ༌པོ༌ ཁོའེ༌ ཀ༌ཝ༌གུན༌ ཕུལས༌། ཆོད༌ཁང༌ ཞིགས༌ཏེ༌ སྤོན༌བོ༌གུན༌ དང༌ ཏེ༌བོའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ མི༌ཚང༌མའེ༌ཀ༌ ཐོག༌ ལྡིབས༌། ཏེ༌ཟུག༌གི༌ ཁོའེ༌ ཁོ༌རང༌ སོན༌ཏེའ༌ ཡོད༌དི༌ ཏུས༌སི༌ སང༌ མང༌ང༌ མི༌ ཁོ༌ ཤི༌ ཟ༌ནེ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","ཁོའེ༌ ཨ༌བའེ༌ ནང༌ཚངས༌ ཚང༌མ༌ དང༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌གུན༌ ཁོའེ༌ སྤུར༌ ཁྱོང༌ང༌ལ༌ ག༌ཟ༌ སོང༌། ཁོང༌གུན༌ནི༌ ཁོའེ༌ སྤུར༌ ཁྱོངས༌ཏེ༌ ཁོའེ༌ ཨ༌བ༌ མ༌ནོ༌འཧའེ༌ སྤུར༌ཁང༌ངི༌ ནང༌ང༌ སུབས༌ ཀ༌བོ༌ ཟོ༌རཧ༌ དང༌ ཨེཤ༌ཏ༌འོལ༌ གྲོང༌ཁྱེར༌གུན༌ནི༌ པར༌ལ༌ ཡོད༌པིན༌། སམ༌སོན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གོ༌ཁྲིད༌ ལོ༌ 20 ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","ཏ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ལ༌ དུག༌ཁན༌ མི༌ཀཧ༌ ཟེར༌ཁན༌ནི༌ མི༌ ཞིག༌ ཡོད༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","ཁོའེ༌ ཁོ༌རང༌ངི༌ ཨ༌མ༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ཀ༌ནེ༌ མུལ༌ལི༌ པེ༌ནེ༌ 1,100 རྐུས༌ཏེ༌ ཁྱེར༌ཁན༌བོའ༌ ཉེ༌རང༌ངི༌ ངན༌ ཏབ༌ཁན༌བོ༌ ངའེ༌ ཚོར༌། ཏེ༌ པེ༌ནེ༌ ངའེ༌ རྐུས༌པིན༌, ཏ༌ ངའེ༌ ཉེ༌རང༌ང༌ ལོགས༌ཏེ༌ ཏང༌ཨིན༌།” ཁོའེ༌ ཨ༌མའེ༌ ཟེརས༌, “འི༌བོ༌ ཤད༌ཅེས༌སི༌ ཕིའ༌ ཡ༌ཝའེ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ སལ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","བུ༌ཚའེ༌ པེ༌ནེ༌ ལོགས༌ཏེ༌ ཏང༌ང༌ཅིག༌ ཨ༌མའེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ པེ༌ནེ༌ ལོགས༌ཏེ༌ ཏང༌ཁན༌ནི༌ ལས༌པོའ༌ རྩི༌ཝ༌ ཏངས༌ཏེ༌ ངའེ༌ འི༌ པེ༌ནེ༌ ཁག༌ཤིག༌ ཡ༌ཝའ༌ ཕུལ༌ཏེ༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ སྐུན༌དྲ༌ཞིག༌ ཞང༌ཅེས༌ལ༌ ཀོལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","ཏེ༌ནེ༌ བུ༌ཚའེ༌ ལོགས༌ཏེ༌ ཏང༌ཁན༌ནི༌ པེ༌ནེ༌བོའེ༌ ནང༌ནེ༌ ཨ༌མའེ༌ མུལ༌ལི༌ པེ༌ནེ༌ 200 མུལ༌ལས༌ ཅོ༌ཁན༌ལ༌ ཏངས༌། ཁོའེ༌ ཏེ༌གུན༌ ཉམ༌པོ༌ སྐུན༌དྲ༌ཞིག༌ ཅོས༌ཏེ༌ མི༌ཀཧ༌ ཏངས༌ ཡང༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཁང༌པའེ༌ ནང༌ང༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","ཏ༌ མི༌ཀཧ༌ ཆོས༌ ཅོ༌སའེ༌ ནས༌ས༌ཞིག༌ ཡོད༌པིན༌། ཁོའེ༌ ཞན༌ སྐུན༌དྲ༌ རིག༌ ཞངས༌, ཨེ༌ཕོད༌ ཡང༌ན༌ ཏམ༌པ༌ སྟུད༌ཏུང༌ ཙེམས༌ ཡང༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ ཅིག༌ བླ༌མ༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","ཏེ༌ ཏུས༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གྱལ༌པོ༌ མེད༌པིན༌, ཚང༌མའེ༌ རང༌རང༌ ཐད༌ཁན༌བོ༌ ཅོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","ཞག༌ཤིག༌ ཡ༌ཧུ༌དཱའེ༌ མི༌སྡེ༌ ཕྲོའ༌ བེད༌ལེ༌ཧེམ༌མ༌ དུག༌ཁན༌ ལི༌ཝི༌པ༌ ཞུ༌ནུ༌ཞིག༌, ");
INSERT INTO lbj_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","བེད༌ལེ༌ཧེམ༌ནེ༌ བིང༌ཏེ༌ ནས༌ཏེ༌ དུག༌ཅེས༌ལ༌ ཞན༌ ས༌ཆ༌ཞིག༌ ཙལ༌ཨིན༌ སོང༌། བེས༌སི༌ ནང༌ང༌ ཁོ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ལ༌ དུག༌ཁན༌ མི༌ཀཧའེ༌ ཁང༌པ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","མི༌ཀཧའེ༌ ཁོའ༌ ཏྲིས༌, “ཁྱོ༌རང༌ ཀ༌ནེ༌ ཨིན༌?” ཁོའེ༌ ལན༌ཏངས༌, “ང༌ ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌ བེད༌ལེ༌ཧེམ༌ནེ༌ ལི༌ཝི༌པ༌ ཞིག༌ ཨིན༌ ཡང༌ ངའེ༌ ནས༌ཏེ༌ དུག༌ཅེས༌ལ༌ ས༌ཀྱད༌ ཞིག༌ ཙལ༌ལད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","མི༌ཀཧའེ༌ ཟེརས༌, “ཁྱོ༌རང༌ འི༌རུ༌ ང༌ ཉམ༌པོ༌ དུགས༌ཏེ༌ ངའེ༌ བླ༌མ༌ དང༌ ང༌ ལབ༌ཞ༌ ཏང༌ཁན༌བོ༌ གྱུར༌། ཀོས༌ལག༌ དང༌ ཁར༌ཇི༌ མ༌ཐེའ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ལོའེ༌ ལ༌ཆ༌ མུལ༌ལི༌ པེ༌ནེ༌ རྕུ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","ཏེ༌ནེ༌ ལི༌ཝི༌པ༌ ཞུ༌ནུ༌ ཏེ༌རུ༌ དུགས༌ ཡང༌ མི༌ཀཧའེ༌ ཕིའ༌ ཁོ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌ཅིག༌ ཙོགས༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","མི༌ཀཧའེ༌ ཁོ༌རང༌ངི༌ ཕིའ༌ ལི༌ཝི༌པ༌ ཞུ༌ནུ༌ བླ༌མ༌ སྐོས༌ ཡང༌ ཁོ༌ མི༌ཀཧའེ༌ ཁང༌པའེ༌ ནང༌ང༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","མི༌ཀཧའེ༌ ཟེརས༌, “ཏ༌ ངའེ༌ ལི༌ཝི༌པ༌ ཞིག༌ བླ༌མ༌ སྐོས༌ པ༌སང༌ ཡ༌ཝའེ༌ ང༌ ཅིན༌ལབས༌ སལ༌ལ༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","ཏེ༌ཏུས༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གྱལ༌པོ༌ མེད༌པིན༌། དཱན༌པ༌ མི༌སྡེའེ༌ ཚུགས༌ཏེ༌ དུག༌ཅེས༌ལ༌ ས༌ཀྱད༌ཞིག༌ ཙལ༌ལད༌པིན༌ ཅིའ༌ཟེར༌ན༌ ཞན༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མི༌སྡེ༌གུན༌ནི༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཆ༌ ང༌ཡོག༌ག༌ ལེན༌ ཚར༌ཏེ༌ ཨིན༌ནའང༌ དཱན༌པ༌ མི༌སྡེའེ༌ ཏ༌རུང༌ ཁོ༌རང༌གུན༌ནི༌ ས༌ཆ༌ ང༌ཡོག༌ག༌ ལེན༌ མ༌ཉན༌ན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","དཱན༌པ༌གུན༌ནི༌ ཟོ༌རཧ༌ དང༌ ཨེཤ༌ཏ༌འོལ༌ གྲོང༌ཁྱེར༌པ༌ མག༌མི༌ ཀྲག༌པོ༌ ལྔ༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ས༌ཀྱད༌གུན༌ལ༌ ལྟའ༌ལ༌ ལམ༌ཅུགས༌ཏེ༌ ཟེརས༌, “སོང༌, ང༌དང༌ དུག༌ཅེས༌ལ༌ ས༌ཀྱད༌ཞིག༌ ལྟོས༌།” མི༌གུན༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ལི༌ ནང༌ང༌ མི༌ཀཧའེ༌ ཁང༌པ༌ ལེབ༌ ཡང༌ ཏེ༌རུ༌ ཁོང༌གུན༌ནི༌ ཚན༌བོ༌ ཕུདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","ཁོང༌གུན༌ མི༌ཀཧའེ༌ ཁང༌པའེ༌ ནང༌ང༌ ཡོད༌ ཟ༌ནེ༌ ཁོང༌གུན༌ལ༌ སྤེ༌ར༌ ཏང༌ཚུལ༌བོའེ༌ ཀ༌ནེ༌ ཞུ༌ནུ༌བོ༌ ལི༌ཝི༌པ༌ ཨིན༌ཁན༌ ཤེས༌། ཁོང༌གུན༌ ཁོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཏྲིས༌, “ཁྱོ༌རང༌ འི༌རུ༌ སུའི༌ ཁྱོངས༌? འི༌ ས༌ཆའེ༌ ནང༌ང༌ ཁྱོ༌རང༌ ཅི༌ ཅོའད༌? ཁྱོ༌རང༌ འི༌རུ༌ ཅི༌ཕིའ༌ ཡོངས༌པིན༌?” ");
INSERT INTO lbj_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","མི༌ཀཧའེ༌ ཁོའེ༌ ཕིའ༌ ཅོ༌ཁན༌གུན༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཤདས༌ ཡང༌ ཟེརས༌, “ཁོའེ༌ ང༌ ལ༌ཆ༌ ཏངས༌ཏེ༌ བླ༌མའེ༌ ལས༌ ཅོ༌ཅེས༌ལ༌ སྐོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཁོའ༌ ཟེརས༌, “ཇུ༌ཇུ༌ ང༌ཞ༌གུན༌ནི༌ བེས༌པོ༌ ཁྲངས༌པོ༌ ལུས༌སོག༌ག༌ མི༌ ལུས༌སོག༌ མོལ༌ཏེ༌ དཀོན༌མཆོག༌ག༌ ཏྲིའ༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","བླ༌མའེ༌ ཁོང༌གུན༌ལ༌ ལན༌སལས༌, “ཞི༌དེ༌ ཉམ༌པོ༌ སོང༌། ཁྱོ༌ཞའེ༌ བེས༌པོའ༌ ཡ༌ཝའེ༌ ཆོགས༌སྐྱོར༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","ཏེ༌ནེ༌ མི༌ ལྔ༌ཀོ༌ ཏེ༌ནེ༌ བིང༌ ཡང༌ ལཱ༌འིཤ༌ གྲོང༌ཁྱེར༌ལ༌ ལེབ༌། ཁོང༌གུན༌ནི༌ ཏེ༌རུ༌ དུག༌ཁན༌ནི༌ མི༌གུན༌ སི༌དོན༌པ༌ ཙོགས༌, སྤུང༌གོལ༌ལི༌ ཇིགས༌ནང༌ མེད༌པ༌ ཞི༌དེ༌ ནང༌ང༌ དུག༌ཁན༌, ཁོང༌གུན༌ནི༌ ས༌ཆའེ༌ ནང༌ང༌ ཅི༌ཚང༌མ༌ སྨིན༌ པ༌སང༌ ཁོང༌གུན༌ སྐྱིད༌པོ༌ དང༌ ཆུག༌པོ༌, ཁོང༌གུན༌ སི༌དོན༌པ༌གུན༌ནེ༌ མ༌ ཐག༌རིང༌ ཡང༌ ཉེ༌ཁོར༌རི༌ ཞན༌ གྱལ༌ཁམས༌གུན༌ ཉམ༌པོ༌ བྲེལ༌བྲུགས༌ མེད༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","མི༌ ལྔ༌ཀོ༌ ཟོ༌རཧ༌ དང༌ ཨེཤ༌ཏ༌འོལ༌ལ༌ ལོགས༌ཏེ༌ ལེབ༌བ༌ཅིག༌ ཁོང༌ངི༌ ཉེན༌གྲུང༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ཏྲིས༌, “ཁྱོ༌ཞ༌གུན༌ལ༌ ཅི༌ གྱུས༌སོང༌?” ");
INSERT INTO lbj_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཡོང༌ཤིག༌, ཁོང༌གུན༌ལ༌ སྤུང༌གོལ༌ ཅོ༌ཨིན༌། ཏེ༌ ས༌ཀྱད༌ མ༌ གྱལ༌ལ༌ ཡོད༌ཁན༌བོ༌ ང༌ཞ༌གུན༌ནི༌ ཐོང༌། ང༌དང༌གུན༌ ཅི༌ཕིའ༌ སྲུངས༌ཏེ༌ ཨིན༌? ཐེ༌ཚོམས༌ མ༌ཅོ༌, སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ང༌ཡོག༌ག༌ ལེན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","ཏེ༌རུ༌ ལེབ༌བ༌ཅིག༌ ཁྱོ༌ཞའེ༌ ཁོང༌གུན༌ སྤུང༌གོལ༌ལི༌ ཇིགས༌ནང༌ མེད༌པ༌ དུག༌ཁན༌བོ༌ ཐོང༌ཨིན༌། དཀོན༌མཆོག༌གི༌ མ༌ གྱ༌ཤན༌ དང༌ ཅའང༌ སྒོས༌དོམ༌ མེད༌ཁན༌ནི༌ ཏེ༌ ས༌ཀྱད༌པོ༌ ང༌དང༌གུན༌ནི༌ ལག༌ག༌ སལ༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","ཏེ༌ནེ༌ དཱན༌ནི༌ མི༌སྡེའེ༌ ནང༌ནེ༌ མག༌མི༌ 600 མག༌གི༌ ཕིའ༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ ཟོ༌རཧ༌ དང༌ ཨེཤ༌ཏ༌འོལ༌ནེ༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","ལམ༌བར༌ལ༌ ཁོང༌གུན༌ནི༌ ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌ ཀི༌རི༌འཐ༌ ཡེ༌རིམ༌མི༌ ཉེ༌མོའ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ཏེན༌ན༌བོའེ༌ ཞས༌ཏེ༌ ཀི༌རི༌འཐ༌ ཡེ༌རིམ༌མི༌ ནུབ༌ ཆོགས༌སི༌ ས༌ཀྱད༌པོའ༌ དག༌སའང༌ མ༌ཧ༌ནེཧ༌ དཱན༌ ཟེར༌ར༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","ཏེ༌ཀ༌ནེ༌ ཁོང༌གུན༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ལ༌ སོང༌ ཡང༌ མི༌ཀཧའེ༌ ཁང༌པའེ༌ ཉེ༌མོའ༌ ལེབ༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","ཏེ༌ནེ༌ ལཱ༌འིཤ༌ ས༌ཀྱད༌དི༌ ནང༌ང༌ སང༌ཝ༌ ཐོག༌ནེ༌ ལྟ༌ ཆའ༌ཁན༌ནི༌ མི༌ ལྔ༌ཀོའེ༌ ཁོ༌རང༌གུན༌ནི༌ ཕྲོ༌པ༌གུན༌ལ༌ ཟེརས༌, “འི༌ ཁང༌པ༌ ཅིག༌གི༌ ནང༌ང༌ ཨེ༌ཕོད༌, ལྷ༌ལྷ༌མོ༌གུན༌, ཤིང༌ང༌ སྐོས༌ཏེ༌ མུལ༌ ཏུམས༌ཁན༌ནི༌ སྐུན༌དྲ༌ ཡོད༌ཁན༌བོ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ གྱུས༌ཡོད༌ད༌? ཏ༌ ཅོ༌གོ༌ཤེས༌པོ༌ ང༌དང༌གུན༌ལ༌ གྱུས༌ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","ཏེ༌ནེ༌ ཁོང༌གུན༌ མི༌ཀཧའེ༌ ཁང༌པ༌ ཆོགས༌ལ༌ སོང༌ ཀ༌རུ༌ ལི༌ཝི༌པ༌ ཞུན༌ནུ༌ དུག༌གད༌པིན༌ ཡང༌ ཁོའ༌ ཇུ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","དཱན༌པ༌ མག༌ཆ༌ གོན༌ཁན༌ནི༌ མག༌མི༌ 600 ཏེ༌ ཁང༌པའེ༌ གྱས༌སྒོའེ༌ཀ༌ ལངས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","བླ༌མ༌ དང༌ ལག༌ཆ༌ ཁུར༌ཏེ༌ ཡོད༌ཁན༌ནི༌ མག༌མི༌ 600 སྒོའེ༌ཀ༌ དུགས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ ས༌ཆའ༌ ལྟ༌ ཆའ༌ཁན༌ནི༌ མི༌ ལྔ༌ཀོ༌ ནང༌ཀུག༌ག༌ སོང༌ཏེ༌ ཤིང༌ང༌ སྐོས༌ཏེ༌ མུལ༌ ཏུམས༌ཁན༌ནི༌ སྐུན༌དྲ༌, ཨེ༌ཕོད༌ དང༌ ལྷ༌ལྷ༌མོ༌གུན༌ ཁུར༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","མི༌ ལྔ༌ཀོ༌ མི༌ཀཧའེ༌ ཁང༌པའེ༌ ནང༌ང༌ སོང༌ཏེ༌ ཤིང༌ང༌ སྐོས༌ཏེ༌ མུལ༌ ཏུམས༌ཁན༌ནི༌ སྐུན༌དྲ༌, ཨེ༌ཕོད༌ དང༌ ལྷ༌ལྷ༌མོ༌གུན༌ ཁུར༌ཏེ༌ ཁྱོང༌ ཟ༌ནེ༌ བླ༌མའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌གུན༌ནི༌ ཅི༌ ཅོའད༌?” ");
INSERT INTO lbj_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","ཁོང༌གུན༌ནི༌ ཁོའ༌ ལན༌ཏངས༌, “ཅུབ༌ ཅོད༌། སྤེ༌ར༌ ཅིག༌གའང༌ མ༌ཟེར༌། ང༌ཞ༌གུན༌ ཉམ༌པོ༌ ཡོངས༌ཏེ༌ ང༌ཞའེ༌ བླ༌མ༌ དང༌ ང༌ཞའ༌ ལབ༌ཞ༌ ཏང༌ཁན༌བོ༌ གྱུར༌, མི༌ ཅིག༌གི༌ བླ༌མ༌ སང༌ ཨིས༌ར༌ཨེལ༌པ༌ མི༌སྡེ༌ དང༌ མི༌རིགས༌གུན༌ནི༌ བླ༌མ༌ ཅོ༌ན༌ མི༌གྱལ༌ལ༌?” ");
INSERT INTO lbj_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","བླ༌མ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཆའ༌ལ༌ ཐད༌། ཨེ༌ཕོད༌, ལྷ༌ལྷ༌མོ༌གུན༌ དང༌ སྐོས༌ཁན༌ནི༌ སྐུ༌ ཁུར༌ཏེ༌ ཁོ༌ མག༌མི༌གུན༌ ཉམ༌པོ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","ཤེད༌མེད༌ མི༌གུན༌, སེམས༌ཅན༌གུན༌ དང༌ ནོར༌གུན༌ དུན༌ལ༌ ཏངས༌ཏེ༌ དཱན༌པ༌གུན༌ནི༌ བེས༌ ཡང༌སྐྱར༌ གོ༌ཟུག༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","ཁོང༌གུན༌ མི༌ཀཧའེ༌ ཁང༌པ༌ནེ༌ བན༌ཤིག༌ ཐག༌རིང༌ང༌ སོང༌ ཚར༌ར༌ཅིག༌ མི༌ཀཧའེ༌ ཁོའེ༌ ཉེ༌ཁོར༌ལ༌ དུག༌ཁན༌ མི༌གུན༌ བོད༌ཏེ༌ དཱན༌པ༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","ཁོང༌གུན༌ནི༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ བོད༌ད༌ཅིག༌ དཱན༌པ༌གུན༌ནི༌ གྱབ༌ལོགས༌ཏེ༌ ལྟས༌ ཡང༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ འི༌ མི༌གུན༌ ང༌ཞའ༌ ནོལ༌ལ༌ལ༌ བོད༌ཏེ༌ ཅི༌ སམ༌མ༌རག༌?” ");
INSERT INTO lbj_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","མི༌ཀཧའེ༌ ལན༌ཏངས༌, “ངའེ༌ ཅོ༌ཁན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ དང༌ ངའེ༌ བླ༌མ༌ ཁྱོ༌ཞའེ༌ ཀོགས༌ཏེ༌ ཁྱེརས༌ པ༌སང༌ ངའེ༌ ལག༌ག༌ ཅའང༌ ལུས༌ཏེ༌ མེད༌། ཏེ༌ནེ༌ ཁྱོ༌རང༌ང༌ ཅི༌ སོང༌ ཟེར༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཅིའ༌ ཏྲིའད༌?” ");
INSERT INTO lbj_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","དཱན༌པ༌གུན༌ནི༌ ལན༌ཏངས༌, “རང༌ངི༌ ལྕེའ༌ ཉ༌ར༌ གྱོབ༌, ཏེ༌ མན༌ན༌ ང༌ཞའེ༌ ཕྲོ༌ནེ༌ སྲོན༌ཇན༌ མི༌གུན༌ནི༌ ཁྱོ༌ཞའ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ཁྱོ༌རང༌ དང༌ ཁྱོ༌རང༌ངི༌ ནང༌མི༌གུན༌ སད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","ཏེ༌ནེ༌ དཱན༌པ༌གུན༌ ཁོང༌གུན༌ ཆེན༌ ཡོད༌ཁན༌ནི༌ ལམ༌ནེ༌ སོང༌ ཡང༌ མི༌ཀཧ༌ ཁོང༌གུན༌ མ༌ ཤེད༌ཅན༌ ཡོད༌ཁན༌བོ༌ ཧ༌གོ༌ པ༌སང༌ ཁོ༌ ལོགས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཁང༌པ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","ཏེ༌ ཟུག༌གི༌ ཁོང༌གུན༌ནི༌ མི༌ཀཧའེ༌ སྐུན༌དྲ༌གུན༌ དང༌ ཁོའེ༌ བླ༌མ༌ ཁྲིད༌ཏེ༌ ཞི༌དེ༌ དང༌ ཇིགས༌ནང༌ མེད༌ད༌ དུག༌ཁན༌ ལཱ༌འིཤ༌པ༌གུན༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ཁོང༌གུན༌ ར༌འི༌ ཉམ༌པོ༌ སདས༌ ཡང༌ གྱལ༌ས༌ མེའ༌ སྲག༌ཏེ༌ མེད༌ཁན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","ཁོང༌གུན༌ སྐྱོབ༌བ༌ སུའང༌ མ༌ཡོངས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌གུན༌ སི༌དོན༌ནེ༌ མ༌ ཐག༌རིང༌ང༌ དུག༌གད༌པིན༌ ཡང༌ ཉེ༌མོ༌ ཡོད༌ཁན༌ ཞན༌གུན༌ ཉམ༌པོ༌ ཁོང༌གུན༌ནི༌ བྲེལ༌ མེད༌པིན༌། ཏེ༌ གྱལ༌ས༌ བེཐ༌ རེ༌ཧོབ༌ ལུང༌པའེ༌ ནང༌ང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། དཱན༌པ༌གུན༌ནི༌ ཡང༌སྐྱར༌ གྱལ༌ས༌ རྩིགས༌ ཡང༌ ཏེ༌རུ༌ ཚུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","སྔུན༌ལ༌ ཏེ༌ གྱལ༌ས༌ ལཱ༌འིཤ༌ ཟེར༌ནའང༌ དཱན༌པ༌གུན༌ནི༌ ཏེ༌བོའ༌ ཁོང༌རང༌གུན༌ནི༌ ཕ༌མེས༌པོ༌ ཨིས༌ར༌ཨེལ༌ ཡང༌ན༌ ཡ༌ཀོབ༌བི༌ བུ༌ཚ༌ དཱན༌ མིང༌ང༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","ཏེ༌རུ༌ དཱན༌པ༌གུན༌ནི༌ སྐུན༌དྲའ༌ ཅོལས༌ ཡང༌ མོ༌ཟེས༌སི༌ ཚ༌འོ༌ གེར༌ཤོམ༌མི༌ བུ༌ཚ༌ ཡོ༌ན༌ཐན༌ ཁོ༌རང༌གུན༌ནི༌ བླ༌མ༌ སྐོས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨ༌སི༌རི༌ཡཱ༌ ཟུམས༌ཏེ༌ ཁྱེར༌ཁྱེར༌ ཚག༌པ༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ དཱན༌པ༌གུན༌ནི༌ བླ༌མ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","དཀོན༌མཆོག༌ག༌ ཅོལ༌སའེ༌ ཏམ༌པའེ༌ ཀུར༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ ཡོད༌ཏེའང༌ ཁོང༌གུན༌ནི༌ མི༌ཀཧའེ༌ ཅོ༌ཁན༌ནི༌ སྐུན༌དྲའ༌ ཅོལ༌ལད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","ཏེ༌ ཏུས༌ ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ གྱལ༌པོ༌ མེད༌པིན༌། ཏ༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌ལི༌ གམ༌ཡུལ༌ལི༌ ནང༌ང༌ དུག༌ཁན༌ ལི༌ཝི༌པ༌ མི༌ཞིག༌གི༌ ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌སི༌ བེད༌ལེ༌ཧེམ༌ནེ༌ ཚེ༌ཡོག༌ ན༌མ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","ཨིན༌ནའང༌ ཏེ༌ བུ༌མོའ༌ ཁོའེ༌ཀ༌ སྲོ༌ ཡོངས༌པ༌ ཁོ༌ ཕངས༌ཏེ༌ བེད༌ལེ༌ཧེམ༌མ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པ༌ ལོགས༌ཏེ༌ སོང༌། ཁོ༌ ཏེ༌རུ༌ དུགས༌ཏེ༌ ཟླ༌ཝ༌ ཞི༌ སོང༌ ");
INSERT INTO lbj_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","ཏེ༌ནེ༌ ཁོའེ༌ མག༌པ༌ ཁོའ༌ ཧ༌གོ༌ཅུགས༌ཏེ༌ ལོགས༌ཏེ༌ ཁྱོང༌ང༌ བེད༌ལེ༌ཧེམ༌མ༌ སོང༌། ཁོ༌ ཉམ༌པོ༌ ཡོག༌པོ༌ དང༌ བུང༌བུ༌ ཉིས༌ ཡོད༌པིན༌། བུ༌མོའེ༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཨ༌བའེ༌ ཁང༌པའེ༌ ནང༌ང༌ ཁྲིད༌ཏེ༌ ཁྱེརས༌ ཡང༌ ཁོ༌ ཐོང༌ང༌ཅིག༌ ཨ༌བའེ༌ མ༌ཐད༌པོ༌ ཉམ༌པོ༌ ཁོའ༌ གའ༌སུས༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","ཁོའེ༌ ན༌མའེ༌ ཨ༌བའེ༌ ཁོའ༌ ཞག༌ ཁ༌ཅིག༌ དུགས༌ཅེས༌ལ༌ ཟེར༌པ༌ ཁོ༌ ཨ༌བ༌ ཉམ༌པོ༌ ཟའ༌ཨིན༌, ཐུང༌ཨིན༌ ཏེ༌རུ༌ ཉིད༌ལོགས༌ཏེ༌ ཞག༌མ༌ སུམ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","ཞག༌ ཞི༌པའེ༌ ཞག༌ག༌ ཁོང༌གུན༌ ང༌མོ༌ནེ༌ ལངས༌ ཡང༌ ལོགས༌ཏེ༌ ཆ༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཅོས༌, ཨིན༌ནའང༌ ཨ༌བའེ༌ ཁོ༌རང༌ངི༌ བུ༌མོའེ༌ མག༌པ༌ ཟེརས༌, “ཟན༌ ཟོས༌ཏེ༌ ཀྲོད༌པ༌ བྲངས༌ ཅུག༌ཏེ༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","ཏེ༌ནེ༌ ཁོང༌ ཉིས༌ཀོ༌ ཟའ༌ཅེས༌ དང༌ ཐུང༌ཅེས༌ལ༌ སའེ༌ཀ༌ དུགས༌། བུ༌མོའེ༌ ཨ༌བའེ༌ ཟེརས༌, “དི༌རིང༌ ཚན༌བོ༌ དུག༌ཏེ༌ སྐྱིད༌པོ༌ ཅོའ༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","ཡང༌ ཁོ༌ ཆ༌ཅེས༌ལ༌ ལངས༌ས༌ཅིག༌ ཁོའེ༌ ན༌མའེ༌ ཨ༌བའེ༌ ཁོའ༌ དུག༌ཅེས༌ལ༌ རང༌གྱལ༌ ཏངས༌པ༌ ཁོ༌ ཏེ༌ ཚན༌བོ༌ ཏེ༌རུ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","ཞག༌ ལྔ༌པའི༌ ཞག༌ག༌ ང༌མོ༌ནེ༌ ཁོ༌ ཆ༌ཅེས༌ལ༌ ལངས༌ས༌ཅིག༌ བུ༌མོའེ༌ ཨ༌བའེ༌ ཟེརས༌, “ཟན༌ ཟོས༌ཏེ༌ ཀྲོད༌པ༌ བྲངས༌ ཅུག༌ཏེ༌ ཉིང༌གུང༌ ཚོག༌པ༌ སྲུང༌།” ཁོང༌ ཉིས༌ཀོ༌ དུགས༌ཏེ༌ ཟོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","ཏེ༌ནེ༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཚེ༌ཡོག༌ ན༌མ༌ དང༌ ཡོག༌པོ༌ ཉམ༌པོ༌ ཆ༌ཅེས༌ལ༌ ལངས༌ས༌ཅིག༌ ཁོའེ༌ ན༌མའེ༌ ཨ༌བའེ༌ ཁོའ༌ ཟེརས༌, “ལྟོས༌སའང༌ ཕི༌ཏོག༌ ཆ༌ ཚར༌ཏོག༌, ཚན༌བོ༌ འི༌རུ༌ དུག༌། ཉི༌མ༌ བུད༌ ཚར༌ཀྱིས༌ དུག༌, དུགས༌ཏེ༌ སྐྱིད༌པོ༌ ཅོས༌། ཐོ༌རེ༌ ང༌མོ༌ནེ༌ ལངས༌ཏེ༌ ཁྱོ༌རང༌ ཁང༌པ༌ ལོགས༌ཏེ༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","ཨིན༌ནའང༌ ཡང༌ ཚན༌ཞིག༌ དུག༌ཉིན༌ མེད༌པ༌ ཁོ༌ ཁོ༌རང༌ངི༌ གྱབ༌ཆ༌ སྟད༌ཁན༌ནི༌ བུང༌བུ༌ ཉིས༌ཀོ༌ དང༌ ན༌མ༌ ཁྲིད༌ཏེ༌ ཡེ༌བས༌ ཡང༌ན༌ ཡེ༌རུ༌ཤ༌ལེམ༌ ཆོགས༌ལ༌ བིངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","ཁོང༌གུན༌ ཡེ༌བས༌སི༌ གྱལ༌སའེ༌ ཉེ༌མོའ༌ ལེབ༌བ༌ཅིག༌ མུན༌གྲིག༌ ཆ༌ཀྱིས༌ ཡོད༌པིན༌། ཡོག༌པོའེ༌ ཁོ༌རང༌ངི༌ སྤོན༌བོའ༌ ཟེརས༌, “སྐྱོད༌, ཡེ༌བས༌པའེ༌ གྱལ༌སའེ༌ ནང༌ང༌ ཚན༌བོ༌ དུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","སྤོན༌བོའེ༌ ལན༌ཏངས༌, “མན༌ ཨིས༌ར༌ཨེལ༌པ༌ མན༌ཁན༌ ཞན༌མི༌གུན༌ནི༌ གྱལ༌སའེ༌ ནང༌ང༌ ང༌དང༌ མི༌ དུག༌། ང༌དང༌གུན༌ གི༌བེའཧ༌ ནང༌ང༌ དུག༌ག༌ ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","ཡོང༌, ང༌དང༌གུན༌ གི༌བེའཧ༌ ཡ༌ ར༌མཧ༌ ལེབ༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོ༌ཨིན༌ ཡང༌ ཏེ༌ ཉིས༌ཀོའེ༌ ནང༌ནེ༌ ཅིག༌པོའེ༌ ནང༌ང༌ ང༌དང༌ངི༌ ཚན༌བོ༌ པུད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","ཏེ༌ནེ༌ ཁོང༌གུན༌ སོང༌ ཡང༌ ཁོང༌གུན༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ དུག༌སའེ༌ གི༌བེའཧ༌ ཉེ༌མོའ༌ ལེབ༌བ༌ཅིག༌ ཉི༌མ༌ སྐྱོད༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","ཏེ༌རུ༌ ཚན༌བོ༌ དུག༌ཅེས༌ལ༌ ཁོང༌གུན༌ གྱལ༌སའེ༌ སྐྱིལ༌ལ༌ ཡོད༌ཁན༌ ཁྲོམས༌སི༌ ནང༌ང༌ སོང༌ཏེ༌ དུགས༌། ཨིན༌ནའང༌ སུ༌ཞིག༌གིའང༌ ཁོང༌གུན༌ ཁོ༌རང༌ངི༌ ཁང༌པའེ༌ ནང༌ང༌ ཚན༌བོ༌ དུག༌ཅེས༌ལ༌ མ༌ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","ཏེན༌ན༌ ཕི༌ཏོག༌ ཨེཕ༌ར༌ཡིམ༌མི༌ རི༌ཡུལ༌པ༌ གི༌བེའཧ༌ ནང༌ང༌ དུག༌ཁན༌ མི༌རྒད༌པོ༌ ཞིག༌ ཞིང༌ངི༌ཀ༌ ལས༌ ཅོས༌ཏེ༌ ལོགས༌ཏེ༌ ཡོང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","ཁོའ༌ གྱལ༌སའེ༌ སྐྱིལ༌ལ༌ ཁྲོམས༌སི༌ ནང༌ང༌ བེས༌པ༌ རིག༌ ཐོང༌ང༌ཅིག༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཏྲིས༌, “ཁྱོ༌ཞའ༌ ཀ༌རུ༌ ཆ༌ཅེན༌ ཡང༌ ཀ༌ནེ༌ ཡོངས༌པིན༌?” ");
INSERT INTO lbj_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","བུ༌ཚའེ༌ ལན༌ཏངས༌, “ང༌ཞ༌གུན༌ ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌སི༌ བེད༌ལེ༌ཧེམ༌ནེ༌ ཡོངས༌པིན༌ ཡང༌ ཨེཕ༌ར༌ཡིམ༌ རི༌ཡུལ༌ལི༌ གམ༌ཡུལ༌ལ༌ ཆ༌ཅེས༌ ཨིན༌ ཀ༌རུ༌ ང༌ དུག༌གད༌། ཡང༌ ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌སི༌ བེད༌ལེ༌ཧེམ༌མ༌ སོང༌པིན༌ ཡང༌ དག༌ས༌ ང༌ ཡ༌ཝ༌ ཅོལ༌སའེ༌ ནས༌ས༌ ཆ༌ཅེས༌ ཨིན༌། ཨིན༌ནའང༌ སུ༌ཞིག༌གིའང༌ ང༌ ཁོ༌རང༌གུན༌ནི༌ ཁང༌པའེ༌ ནང༌ང༌ མ༌ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","ང༌ཞའེ༌ ལག༌ག༌ ང༌ཞའ༌ རང༌ངི༌ བུང༌བུའི༌ ཕིའ༌ ཕུག༌མ༌ དང༌ རྩའ༌ ཡང༌ ང༌རང༌, བུ༌མོ༌ དང༌ ངའེ༌ ཡོག༌པོའེ༌ ཕིའ༌ ཏ༌གི༌ དང༌ རྒུན༌ཆང༌ ཡོད༌། ང༌ཞ༌གུན༌ལ༌ ཅའང༌ སྒོས༌དོམ༌ མེད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","མི༌རྒད༌པོའེ༌ ཟེརས༌, “ཉེ༌ཞའ༌ ངའེ༌ ཁང༌པའེ༌ ནང༌ང༌ གའ༌སུས༌ ཞུའད༌། ཉེ༌ཞའ༌ སྒོས༌དོམ༌ ཡོད༌ཁན༌གུན༌ ངའེ༌ ཏང༌ཨིན༌, གྱལ༌སའེ༌ ཁྲོམས༌སི༌ ནང༌ང༌ ཚན༌ ཕུད༌ད༌ མ༌ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","ཏེ༌ནེ༌ ཁོའེ༌ ཁོང༌གུན༌ ཁོ༌རང༌ངི༌ ཁང༌པ༌ ཁྱེརས༌ ཡང༌ བུང༌བུ༌གུན༌ལ༌ རྩའ༌ ཏངས༌། ཁོང༌རང༌གུན༌ནི༌ རྐང༌པ༌ ཁྲུས༌ཏེ༌ སྟིང༌ནེ༌ ཁོང༌གུན༌ནི༌ ཟན༌ ཟོས༌ ཡང༌ ཐུངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","ཁོང༌གུན༌ནི༌ ཟེན༌ ཐུང༌ཨིན༌ སྐྱིད༌པོ༌ ཅོ༌ ཟ༌ནེ༌ གྱལ༌སའེ༌ བུ༌ཚ༌ ངན༌པ༌གུན༌ནི༌ ཁང༌པའ༌ སྐོར༌ཏེ༌ སྒོ༌ སྲན༌ཏྲེ༌ རྡུང༌ཨིན༌ ཁང༌པའེ༌ དག༌པོ༌ མི༌རྒད༌པོ༌བོའ༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཁང༌པའ༌ ཁྱོང༌ཁན༌ བེས༌པ༌ བུ༌ཚ༌ ཉམ༌པོ༌ ང༌ཞའ༌ ལུས༌བྲེལ༌ ཅོ༌ཉན༌ཅེས༌ལ༌ ཁོ༌ ཕི༌ལོག༌ག༌ ཕིངས༌ཏེ༌ ཁྱོང༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","ཁང༌པའེ༌ དག༌པོ༌བོ༌ ཕི༌ལོག༌ག༌ སོང༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “མན༌, ངའེ༌ ཛ༌འོ༌གུན༌ འི༌ཟུག༌ ངན༌པ༌ ལས༌ མ༌ཅོ༌ཤིག༌། ཁོ༌ ངའེ༌ གྲོན༌པོ༌ ཨིན༌ནོག༌, ཇུ༌ཇུ༌ ཏེ༌ཟུག༌ ཁྲེལ༌མེད༌དི༌ ལས༌ མ༌ཅོ༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","ལྟོས༌, བུ༌ཚ༌ ལག༌པ༌ མ༌ཐུག༌ཁན༌ ངའེ༌ བུ༌མོ༌ དང༌ ཁོའེ༌ ཚེ༌ཡོག༌ ན༌མ༌ འི༌ཀ༌ནེ༌, ངའེ༌ ཁོང༌གུན༌ ཕི༌ལོག༌ག༌ ཕིངས༌ཏེ༌ ཁྱོང༌ཨིན༌ ཡང༌ ཁོང༌གུན༌ ཉམ༌པོ༌ ཁྱོ༌ཞའེ༌ ཅི༌ ཅོ༌ཨིན༌ སམ༌ནའང༌ ཅོས༌ ཨིན༌ནའང༌ འི༌ བུ༌ཚ༌ ཉམ༌པོ༌ ཏེ༌ཟུག༌ ཁྲེལ༌མེད༌དི༌ ལས༌ མ༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","ཁོང༌གུན༌ནི༌ ཁོའེ༌ ཟེར༌ཁན༌བོའ༌ མ༌ཉནས༌། ཏེ༌ནེ༌ ལི༌ཝི༌པ༌བོའེ༌ ཁོ༌རང༌ངི༌ ཚེ༌ཡོག༌ ན༌མ༌ ཁོང༌གུན༌ ཡོད༌ས༌ ཕི༌ལོག༌ག༌ ཕིངས༌ཏངས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཚན༌ གང༌པོ༌ བུ༌མོ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ དང༌ ངན༌པ༌ ཅོས༌ཏེ༌ ནམ༌ལངས༌ལ༌ ཁོ༌ ཆ༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","བུ༌མོ༌ ཁོའེ༌ སྤོན༌བོ༌ དུག༌སའེ༌ ཁང༌པ༌ ལོགས༌ཏེ༌ སོང༌ ཨིན༌ནའང༌ སྒོའེ༌ཀ༌ གྱེལ༌པ༌ ཏེ༌ཀ༌ ཉི༌མ༌ ཤར༌ཤར༌ ཚག༌པ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","ང༌མོ༌ ཁོའེ༌ སྤོན༌བོ༌ ལངས༌ཏེ༌ ཁང༌པའ༌ ཆ༌ཅེས༌ལ༌ སྒོ༌ ཕེའ༌ཅིག༌ ཁོའ༌ ཁོ༌རང༌ངི༌ ཚེ༌ཡོག༌ ན༌མ༌ སྒོ༌ཐེམས༌སི༌ཀ༌ ལག༌པ༌ ཐམས༌ཏེ༌ གྱེལ༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","ཁོའེ༌ བུ༌མོའ༌ ཟེརས༌, “ལོངས༌, ང༌དང༌ ཆེན༌།” ཨིན༌ནའང༌ ལན༌ མ༌ཐོབ༌པ༌ ཁོའེ༌ བུ༌མོའེ༌ རོ༌ ཁོ༌རང༌ངི༌ བུང༌བུའི༌ཀ༌ ཀལ༌ཏེ༌ ཁང༌པ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","ཁང༌པ༌ ལེབ༌བ༌ཅིག༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ ཚེ༌ཡོག༌ ན༌མའེ༌ རོ༌ ཀྲི༌ ཉམ༌པོ༌ ཏུམ༌པ༌ རྕུག༌ཉིས༌སི༌ ནང༌ང༌ ཅདས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མི༌སྡེ༌ རེ༌རེའ༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","ཏེ༌བོ༌ ཐོང༌ཁན༌ ཚང༌མའེ༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཨི༌ཇིབ༌ནེ༌ བིངས༌ཏེ༌ ཡོངས༌པ༌ནེ༌ དག༌ས༌ ཚོག༌པ༌ འི༌ ཙོགས༌ཤིག༌ མ༌ནེ༌ མ༌ཐོང༌ ཡ༌ མ༌ཚོར༌། འི༌བོའེ༌ སྐོར༌ལ༌ སམ༌བ༌ སྲན༌ཏྲེ༌ ཏངས༌ཏེ༌ ཐག༌ཅོད༌ཤིག༌ ང༌དང༌གུན༌ནི༌ ཅི༌ ཅོ༌གོས༌?” ");
INSERT INTO lbj_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","ཏེ༌ནེ༌ བྱང༌ ཆོགས༌སི༌ གྱལ༌ས༌ དཱན༌ནེ༌ ཏངས༌ཏེ༌ ལྷོ༌ ཆོགས༌སི༌ གྱལ༌ས༌ བེར༌ཤེ༌བ༌ ཚོག༌པ༌ ཡང༌ ཤར༌ ཆོགས༌སི༌ གི༌ལེད༌དི༌ ཡུལ༌ཇོངས༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ བིངས༌ ཡང༌ ཅིག༌གྲིལ༌ སོང༌ཏེ༌ མིཟ༌པཧའེ༌ ནང༌ང༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཛོམས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","དཀོན༌མཆོག༌གི༌ མི༌གུན༌ ཛོམས༌ཏེ༌ ཡོད༌ས༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌ 11པོའེ༌ སྤོན༌བོ༌གུན༌ ཁོང༌རང༌གུན༌ནི༌ ནས༌སའེ༌ཀ༌ དུགས༌, ཏེ༌རུ༌ ར༌འི༌ ཁུར༌ཁན༌ མག༌མི༌ 400,000 ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","༼བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ཞན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཀེན༌ལ༌ མིཟ༌པཧའ༌ སོང༌ཁན༌བོ༌ ཚོར༌།༽ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཟེརས༌, “འི༌ ནས༌ལུག༌ ངན༌པ༌བོ༌ ཀ༌ཟུག༌གི༌ ཇུང༌ ང༌ཞའ༌ ཤོད༌དའང?” ");
INSERT INTO lbj_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","ཏེ༌ནེ༌ སད༌ཁན༌ནི༌ བུ༌མོའེ༌ མག༌པ༌ ལི༌ཝི༌པ༌བོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ང༌ དང༌ ངའེ༌ ཚེ༌ཡོག༌ ན༌མ༌ ཉིས༌ཀོ༌ བེན༌ཡཱ༌མིན༌ནི༌ ཡུལ༌ཇོངས༌ གི༌བེའཧ༌ ནང༌ང༌ ཚན༌བོ༌ དུག༌ག༌ལ༌ སོང༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","ཚན༌ནི༌ ཏུས༌ལ༌ གི༌བེའཧ༌པ༌ བུ༌ཚ༌གུན༌ ཡོངས༌ཏེ༌ ང༌ཞའ༌ དུག༌སའེ༌ ཁང༌པ༌ ཐའ༌ སྐོརས༌། ང༌ སད༌ཅེས༌ ཅོས༌ ཡང༌ ཚན༌ གང༌པོ༌ ངའེ༌ ཚེ༌ཡོག༌ ན༌མ༌ ཝང༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ ཅོས༌པ༌ ཁོ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ ཏེ༌ཙོགས༌ ཁྲེལ༌མེད༌དི༌ ལས༌ ཅོ༌ཁན༌བོ༌ གྱུས༌ ཆ༌ཅེས༌ལ༌ ངའེ༌ ང༌རང༌ངི༌ ཚེ༌ཡོག༌ ན༌མའེ༌ རོ༌ ཁྱོངས༌ཏེ༌ ཏུམ༌པ༌ 12 ནང༌ང༌ ཅད༌ཏེ༌ ཁྱོ༌ཞའེ༌ མི༌སྡེ༌ རེ༌རེའ༌ ཀལ༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","ཏ༌ ཏེ༌བོའེ༌ སྐོར༌ལ༌ ཅི༌ ཅོ༌གོས༌ཤེས༌པོ༌ ཁྱོ༌ཞའ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཐག༌ཅོད༌།” ");
INSERT INTO lbj_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","མི༌ ཚང༌མ༌ ཅིག༌གྲིལ༌ སོང༌ཏེ༌ ཟེརས༌, “ང༌དང༌ སུའང༌ ཁང༌པ༌ མི༌ཆ༌། ང༌དང༌ སུ༌ཞིག༌གའང༌ རང༌ངི༌ ཁང༌པ༌ ལོགས༌ཏེ༌ མི༌ཆ༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","ཨིན༌ནའང༌ ཏ༌ གི༌བེའཧ༌པ༌གུན༌ལ༌ ང༌དང༌ངི༌ འི༌བོ༌ ཅོ༌ཨིན༌། ཏག༌རིལ༌ ཏངས༌ཏེ༌ བིང༌ཁན༌ ནང༌ཞིན༌ ང༌དང༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","ང༌དང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌ མག༌མི༌ ཚང༌མའེ༌ ནང༌ནེ༌ རྕུ༌ཁག༌པོ༌, ཁར༌ཇི༌ གྲལ༌གྲིག༌ ཅོ༌ཅེས༌ལ༌ སྐོས༌ཏེ༌ ཞན༌ ཚང༌མ༌, ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ ཏེ༌ཟུག༌ ཁྲེལ༌མེད༌དི༌ ལས༌ ཅོ༌ཅེས༌སི༌ ཕིའ༌ བེན༌ཡཱ༌མིན༌ ཡུལ༌ཇོངས༌སི༌ གི༌བེའཧ༌པ༌གུན༌ལ༌ འོས༌པ༌ ཨིན༌ཁན༌ནི༌ ཆད༌པ༌ ཏང༌ང༌ ཆེན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཛོམས༌ ཡང༌ ཏེ༌ གྱལ༌སའེ༌ གྱབ༌གལ༌ལ༌ ཅིག༌གྲིལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌གུན༌ནི༌ བེན༌ཡཱ༌མིན༌ནི༌ མི༌སྡེའེ༌ གང༌པོའེ༌ ནང༌ང༌ མི༌གུན༌ ལམ༌ཅུགས༌ཏེ༌ ཏྲིས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ ཕྲོའ༌ མི༌ངན༌པ༌ ཁ༌ཅིག༌གི༌ ཁྲེལ༌མེད༌ ལས༌ ཅོས༌ཁན༌བོ༌ ཁྱོ༌ཞའ༌ གྱུས༌ ཡོད༌ད༌? ");
INSERT INTO lbj_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","ཏ༌ གི༌བེའཧ༌པ༌ ཏེ༌ མི༌ངན༌གུན༌ ང༌ཞའེ༌ ལག༌ག༌ སྟོད༌ ཏེ༌ནེ༌ ང༌ཞ༌གུན༌ནི༌ ཁོང༌གུན༌ སད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ ཅོ༌ཁན༌ནི༌ ངན༌པ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌།” ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཟེར༌ཁན༌བོའ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ མ༌ཉེནས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","གྲོང༌ཁྱེར༌གུན༌ནེ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ ཡོངས༌ཏེ༌ གི༌བེའཧ༌ ནང༌ང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ལ༌ལ༌ ཛོམས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","ཏེན༌ན༌ ཞག༌ག༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ གྲོང༌ཁྱེར༌གུན༌ནེ༌ ར༌འི༌ སྲུལ༌ ཉན༌ཁན༌ མི༌ 26,000 མག༌མི༌ ནང༌ང༌ ཅུགས༌ ཀ༌གུན༌ གི༌བེའཧ༌ ནང༌ང༌ དུག༌ཁན༌ མག༌མི༌ གྱལ༌ཤོག༌ 700 གུན༌ནི༌ཀ༌ ནན༌མ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","ཏེ༌ མག༌མི༌ ཚང༌མའེ༌ ཕྲོའ༌ ལག༌པ༌ ཡོ༌མ༌ ཀོལ༌ཁན༌ མག༌མི༌ 700 ཡོད༌པིན༌། ཁོང༌གུན༌ནི༌ སྲའེ༌ སྲལ༌ཉག༌ག༌ ཡུག༌དོ༌ ཏང༌ན༌ མ༌ཕོག༌ག༌ ལུས༌ས༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","བེན༌ཡཱ༌མིན༌པ༌གུན༌ མ༌ཐེའ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ ར༌འི༌ ཁུར༌ཁན༌ ཐོང༌ངོམས༌ཅན༌ མག༌མི༌ 400,000 ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","དཀོན༌མཆོག༌ག༌ ཅོལ༌སའེ༌ ནས༌ས༌ བེ༌ཐེལ༌ལ༌ སོང༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌ང༌ ཏྲིའ༌ཛདས༌, “བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ ང༌ཞ༌གུན༌ནི༌ ནང༌ནེ༌ གོ༌མ༌ སུ༌ ཆ༌ལེ༌?” ཡ༌ཝའེ༌ ལན༌སལས༌, “གོ༌མ༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ ཆ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སོང༌ཏེ༌ གི༌བེའཧ༌ ཉེ༌མོའ༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ གི༌བེའཧ༌ སོང༌ཏེ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ མག༌ ཏང༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ རང༌རང༌ངི༌ ནས༌ས༌ ཐམས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","བེན༌ཡཱ༌མིན༌པ༌གུན༌ གྱལ༌ས༌ནེ༌ བིང༌ཏེ༌ ཡོངས༌ ཡང༌ ཏེན༌ན༌ ཞག༌ག༌ མག༌ཐང༌ངི༌ཀ༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པའེ༌ མག༌མི༌ 22,000 སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","23","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཡ༌ཝ༌ ཅོལ༌སའེ༌ ནས༌ས༌ སོང༌ཏེ༌ ཕི༌ཏོག༌ ཚོག༌པ༌ ངུ༌ཨིན༌ རྡུག༌པོ༌ ཅོས༌ ཡང༌ ཁོང༌ང༌ ཏྲིའ༌ ཛདས༌, “ང༌ཞའ༌ ང༌ཞའེ༌ སྤུན༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ མག༌ ཏང༌ང༌ ཡང༌སྐྱར༌ ཆ༌ལེ༌?” ཡ༌ཝའེ༌ ལན༌སལས༌, “སོང༌, ཁོང༌གུན༌ལ༌ ནོལ༌ལ༌ ཡང༌སྐྱར༌ སོང༌།” ཞག༌ ཉིས༌པའེ༌ ཞག༌ག༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཅིག༌ ཏང༌ ཅིག༌ག༌ སྤོས༌པ༌ ཏངས༌ཏེ༌ ཡང༌སྐྱར༌ ནོལ༌ཅེས༌ལ༌ རང༌རང༌ངི༌ ནས༌ས༌ ལེནས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ལན༌ ཉིས༌པ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ལ༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","གི༌བེའཧ༌ ནེ༌ བིང༌ཏེ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ ནོལ༌ལ༌ ཡོངས༌ ཡང༌ འི༌ ལན༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌ ར༌འི༌ ཁུར༌ཁན༌ ཐོང༌ངོམས༌ཅན༌ མག༌མི༌ 18,000 སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ བེ༌ཐེལ༌ལ༌ སོང༌ཏེ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ངུས༌། ཏེ༌ ཞག༌ག༌ ཕི༌ཏོག༌ ཚོག༌པ༌ ཁོང༌གུན༌ ཉེ༌ནས༌ལ༌ དུགས༌ཏེ༌ མེའ༌ སྲག༌ཅེས༌སི༌ ཆོད༌པ༌ དང༌ ཞི༌དེ༌ ཐུན༌བྲེལ༌ལི༌ ཆོད༌པ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌ཝའ༌ ཏྲིའ༌ ཛདས༌, ༼ཏེ༌ ཏུས༌ལ༌ དཀོན༌མཆོག༌གི༌ ཆད༌དོན༌ནི༌ སྒམ༌བོ༌ བེ༌ཐེལ༌ལི༌ ནང༌ང༌ ཡོད༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","ཡང༌ ཨ༌རོན༌ནི༌ ཚ༌འོ༌ ཨེ༌ལི༌འ༌ཟར༌རི༌ བུ༌ཚ༌ ཕི༌ནི༌ཧས༌ བླ༌མ༌ ཨིན༌པིན༌༽ “ང༌ཞའ༌ ང༌ཞའེ༌ སྤུན༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ཡང༌སྐྱར༌ མག༌ ཏང༌ང༌ ཆ༌ ཡ༌ མ༌ཆ༌ ལེ༌?” ཡ༌ཝའེ༌ ལན༌སལས༌, “སོང༌, ཐོ༌རེ༌ ཁོང༌གུན༌ ངའེ༌ ཁྱོ༌ཞའེ༌ ལག༌ག༌ སྟད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","ཨིས༌ར༌ཨེལ༌པ༌ མག༌མི༌ 10,000 སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ གི༌བེའཧ༌ གྱལ༌སའེ༌ ཉེ༌ཁོར༌ལ༌ ཨིབས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","ཞག༌ སུམ༌པའེ༌ ཞག༌ག༌ ཨིས༌ར༌ཨེལ༌ལི༌ ཞན༌ མག༌མི༌གུན༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ནོལ༌ལ༌ སོང༌ཏེ༌ སྔུན༌ ཙོགས༌ལ༌ ནོལ༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཅོས༌ཏེ༌ རང༌རང༌ངི༌ ནས༌ས༌ ཟུམས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","བེན༌ཡཱ༌མིན༌པ༌གུན༌ ནོལ༌ལ༌ བིང༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཏེད༌ཏེ༌ ཁྱེར༌ པ༌སང༌ གྱལ༌ས༌ནེ༌ ཐག༌རིང༌ང༌ ལེབ༌། སྔུན༌ ཙོགས༌ལ༌ ཁོང༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌ མང༌པོའ༌ མ༌སྐྱོན༌ ཅོས༌པ༌ ཧ༌ལམ༌ མི༌ 30 ཐང༌སྟོང༌ ཡང༌ བེ༌ཐེལ༌ དང༌ གི༌བེའཧ༌ ཆ༌སའེ༌ ལམ༌གུན༌ནི༌ཀ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ ཟེརས༌ “སྔུན༌ ཙོགས༌ལ༌ ང༌དང༌ངི༌ ཁོང༌གུན༌ལ༌ ཕམ༌ཀལ༌ཏེ༌ ཨིན༌ནོག༌” ཏེན༌ན༌ ཏུས༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཟེརས༌, “ཁོང༌གུན༌ གྱལ༌ས༌ནེ༌ ཐག༌རིང༌ང༌ ལམ༌ ཆོགས༌ལ༌ ཁྱེར༌ཅེས༌སི༌ ཕིའ༌ ང༌དང༌གུན༌ ལོགས༌ཏེ༌ ཤོར༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌ ཤོར༌ཏེ༌ བའལ༌ ཏ༌མར༌ལ༌ ལེབ༌བ༌ཅིག༌ ནོལ༌ཅེས༌ལ༌ རང༌རང༌ངི༌ ནས༌ས༌ ཐམས༌ཏེ༌ དུགས༌, ཏེ༌ནེ༌ གི༌བེའཧ༌ ནུབ༌ ཆོགས༌ལ༌ ཨིབས༌ཏེ༌ ཡོད༌ཁན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ བིང༌ ཡང༌ གྱུགས༌ཏེ༌ ནོལ༌ལ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","ཨིས༌ར༌ཨེལ༌ལི༌ ནོལ༌ཁན༌ ཀྲག༌པོ༌ མག༌མི༌ 10,000 འི༌ གི༌བེའཧ༌པ༌གུན༌ལ༌ དུན༌ ཆོགས༌ནེ༌ སྤུང༌གོལ༌ ཅོས༌། མག༌ མ༌ སྲན༌ཏྲེ༌ སོང༌ ཡང༌ ཁོང༌ང༌ ཕམ༌ སྲན༌ཏྲེ༌ ཕོག༌ཅེས༌པོ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ཧ༌ མ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","ཡ༌ཝའེ༌ ཁོང༌གུན༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཀ༌ནེ༌ ཕམ༌ཀལ༌ལ༌ ཛདས༌ ཡང༌ ཏེན༌ན༌ ཞག༌ག༌ ཁོང༌གུན༌ནི༌ རའི༌ ཀོལ༌ཁན༌ ཐོང༌ངོམས༌ཅན༌ བེན༌ཡཱ༌མིན༌པ༌ མག༌མི༌ 25,100 སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","ཏེ༌ནེ༌ ཁོང༌གུན༌ ཕམ༌ཁན༌བོ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ ཧ༌གོ༌། ཨིས༌ར༌ཨེལ༌པའེ༌ ཞན༌ མག༌མི༌གུན༌ལ༌ གི༌བེའཧ༌ ཉེ༌ཁོར༌ལ༌ ཨིབས༌ཏེ༌ ཡོད༌ཁན༌ མག༌མི༌གུན༌ནི༌ ནང༌ང༌ ལོ༌ཁྱེལ༌ སྟན༌པོ༌ ཡོད༌ པ༌སང༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ནོལ༌ཅེས༌ ཕངས༌ཏེ༌ ཁོང༌གུན༌ ཤོར༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","ཏེ༌ནེ༌ ཨིབས༌ཏེ༌ ཡོད༌ཁན༌ མག༌མི༌གུན༌ གྱུགས༌ཏེ༌ སོང༌ ཡང༌ གི༌བེའཧ༌པ༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ གྱལ༌སའེ༌ ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ ར༌འི༌ ཉམ༌པོ༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","ཏ༌ ཨིས༌ར༌ཨེལ༌པ༌ ཨིབས༌ཏེ༌ ཡོད༌ཁན༌གུན༌ནི༌ ཞན༌ མག༌མི༌གུན༌ལ༌ གྱལ༌སའེ༌ ནང༌ནེ༌ ཏུད༌པ༌ བིང༌ཨིན༌ ཐོང༌ང༌ཅིག༌ སྤུང༌གོལ༌ ཅོས༌ ཟེར༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","ཏུད༌པ༌ བིང༌ཨིན༌ ཐོང༌ང༌ཅིག༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ལོགས༌ཏེ༌ སྤུང༌གོལ༌ ཅོས༌། བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ ཨིས༌ར༌ཨེལ༌པ༌ ཧ༌ལམ༌ 30 སདས༌ ཡང༌ ཟེརས༌, “སྔུན༌ ཙོགས༌ལ༌ ང༌དང༌ངི༌ ཁོང༌གུན༌ལ༌ ཕམ༌ཀལ༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","ཨིན༌ནའང༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ ལོགས༌ཏེ༌ ལྟའ༌ཅིག༌ ཁོང༌གུན༌ལ༌ གྱལ༌ས༌ གང༌པོའེ༌ ནང༌ནེ༌ ཏུད༌པ༌ ཀེན༌ལ༌ ནམ༌ཁའ༌ ཆེན༌ ཡོད༌ཁན༌བོའ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཁོང༌གུན༌ལ༌ ནོལ༌ཅེས༌ལ༌ གྱབ༌ གྱུར༌ར༌ཅིག༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ཁོང༌གུན༌ནི༌ཀ༌ རྐྱེན༌ངན༌ ལེབ༌ཁན༌བོ༌ ཧ༌གོ༌ ཡང༌ ཁོང༌གུན༌ སྲན༌ཏྲེ༌ ཇིགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ དུན༌ནེ༌ ཐང༌སྟོང༌ ཆོགས༌ལ༌ ཤོར༌ཅེས༌ ཅོས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ ཤོར༌ མ༌ཉན༌། ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌ གྱལ༌སའེ༌ ནང༌ནེ༌ བིངས༌ཏེ༌ ཡོང༌ཁན༌གུན༌ནི༌ ཁོང༌གུན༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","ཁོང༌གུན༌ནི༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ སྐོརས༌ ཡང༌ གི༌བེའཧའེ༌ ཤར༌ ཆོགས༌སི༌ ནས༌ས༌ ཚག༌པ༌ ཏེད༌ཏེ༌ ཁྱེར༌ཏེ༌ ལ༌མོ༌ ཉམ༌པོ༌ ཁོང༌གུན༌ སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","བེན༌ཡཱ༌མིན༌པ༌ 18,000 ཤི༌, ཁོང༌ ཚང༌མ༌ སྤོས༌པ༌ ཉམ༌པོ༌ ནོལ༌ཁན༌ ཀྲག༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","ལུས༌ཁན༌གུན༌ རིམ༌མོན༌ནི༌ བྲག༌ ཡོད༌ས༌ རི༌སྟོང༌ ཆོགས༌ལ༌ ཤོར༌, ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ལམ༌ནེ༌ ཤོར༌ཁན༌ མི༌ 5,000 སདས༌ ཡང༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ གི༌དོམ༌ ཚོག༌པ༌ ཏེད༌ཏེ༌ ཁྱེར༌ཏེ༌ 2,000 སདས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","ཏེ༌ ཞག༌ག༌ བེན༌ཡཱ༌མིན༌པ༌ ར༌འི༌ སྲུལ༌ཁན༌ མག༌མི༌ 25,000 ཤི༌, ཁོང༌ ཚང༌མ༌ སྤོས༌པ༌ ཉམ༌པོ༌ ནོལ༌ཁན༌ ཀྲག༌པོ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","ཨིན༌ནའང༌ བེན༌ཡཱ༌མིན༌པ༌ 600 རིམ༌མོན༌ནི༌ བྲག༌ ཡོད༌སའེ༌ ནས༌ས༌ ཤོར༌ ཡང༌ ཏེ༌རུ༌ ཟླ༌ཝ༌ ཞི༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","ཨིས༌ར༌ཨེལ༌པ༌གུན༌ བེན༌ཡཱ༌མིན༌ ཡུལ༌ཇོངས༌ལ༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ སེམས༌ཅན༌ ཐེས༌ཏེ༌ གྲོང༌ཁྱེར༌གུན༌ནི༌ ནང༌ང༌ ཡོད༌ཁན༌ ཚང༌མ༌ ར༌འི༌ ཉམ༌པོ༌ སདས༌ ཡང༌ ཅ༌ལག༌ ཚང༌མ༌ ཁྲེས༌ཏོར༌ ཅོས༌། ཁོང༌གུན༌ ཆའ༌ཁན༌ནི༌ གྲོང༌ཁྱེར༌ ཚང༌མ༌ ཁོང༌གུན༌ནི༌ མེའ༌ ཏུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","“ང༌དང༌གུན༌ནི༌ ནང༌ནེ༌ སུ༌ཞིག༌གིའང༌ ང༌དང༌ངི༌ བུ༌མོ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ན༌མ༌ མི༌ཏང༌” ཟེར༌ཏེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ མིཟ༌པཧའེ༌ ནང༌ང༌ ནའ༌ ཁུར༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","ཁོང༌གུན༌ བེ༌ཐེལ༌ལ༌ སོང༌ཏེ༌ དཀོན༌མཆོག༌གི༌ སྐུན༌དུན༌ལ༌ ཕི༌ཏོག༌ ཚོག༌པ༌ སྲན༌ཏྲེ༌ ངུ༌ཨིན༌ ཞུས༌, ");
INSERT INTO lbj_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","“ཨིས༌ར༌ཨེལ༌ལི༌ དཀོན༌མཆོག༌ ཡ༌ཝ༌ལེ༌, ང༌ཞ༌གུན༌ནི༌ཀ༌ འི༌བོ༌ ཅི༌ ཇུངས༌ཏེ༌ ཨིན༌ནོག༌? དི༌རིང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕྲོ༌ནེ༌ སྡེ༌ ཅིག༌ སྟོར༌ཏེ༌ ཨིན༌ནོག༌?” ");
INSERT INTO lbj_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","ཐོ༌རེ༌ཟུག༌པོ༌ ང༌མོ༌ མི༌གུན༌ནི༌ ཆོད༌ཁྲི༌ཞིག༌ རྩིགས༌ ཡང༌ ཏེ༌ཀ༌ མེའ༌ སྲག༌ཅེས༌སི༌ ཆོད༌པ༌ དང༌ ཐུན༌བྲེལ༌ལི༌ ཆོད༌པ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཏྲིས༌, “ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྡེ༌ ཚང༌མའེ༌ ནང༌ནེ༌ ཀ༌བོ༌ མ༌ཛོམ༌མ༌ ཨིན༌ནོག༌?” ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ མ༌ཛོམ༌ཁན༌གུན༌ སད༌ཨིན༌ ཟེར༌ཏེ༌ ཁོང༌གུན༌ནི༌ མིཟ༌པཧའེ༌ ནང༌ང༌ ནའ༌ ཁུར༌ཏེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","ཏ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཁོང༌རང༌གུན༌ནི༌ སྤུན༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ ཕིའ༌ ཉ༌ངན༌ ཅོས༌ཏེ༌ ཟེརས༌, “དི༌རིང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ནང༌ནེ༌ མི༌སྡེ༌ ཅིག༌ མེད༌ཁན༌ སོང༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","ཏ༌ ལུས༌ཏེ༌ ཡོད༌ཁན༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ ཕིའ༌ ན༌མ༌ ཀ༌ནེ༌ ཙལ༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ང༌དང༌གུན༌ནི༌ ང༌དང༌ངི༌ བུ༌མོ༌གུན༌ ཁོང༌གུན༌ལ༌ ན༌མ༌ མི༌ཏང༌ ཟེར༌ཏེ༌ ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ནའ༌ ཁུར༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ ཏྲིས༌, “ཡ༌ཝའེ༌ སྐུན༌དུན༌ལ༌ ཨིས༌ར༌ཨེལ༌པའེ༌ སྡེ༌ ཚང༌མའེ༌ ནང༌ནེ༌ ཀ༌བོ༌ མ༌ཛོམ༌མ༌ ཨིན༌ནོག༌?” ཀུར༌ ཙུགས༌ཏེ༌ ཛོམས༌ཏེ༌ ཡོད༌ས༌ ཡ༌བེཤ༌ གི༌ལེད༌ནེ༌ སུ༌ཞིག༌གའང༌ མ༌ཡོང༌ཁན༌བོ༌ ཁོང༌གུན༌ལ༌ གྱུས༌སོང༌ ");
INSERT INTO lbj_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","ཅིའ༌ཟེར༌ན༌ མི༌ རྩིས༌ ཏང༌ ཟ༌ནེ༌ ཡ༌བེཤ༌ གི༌ལེད༌ནེ༌ སུའང༌ ཏེ༌རུ༌ ཡོངས༌ཏེ༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","ཏེ༌བོའེ༌ཕིའ༌ ཛོམས༌ཏེ༌ ཡོད༌ཁན༌གུན༌ནི༌ ཁོང༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ནོལ༌ཁན༌ ཀྲག༌པོ༌ 12,000 ལབ༌ཞ༌ ཏངས༌ཏེ༌ བུ༌མོ༌ དང༌ ཕྲུ༌གུ༌གུན༌ ཐེས༌ཏེ༌ ཡ༌བེཤ༌ གི༌ལེད༌དི༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ ར༌འི༌ ཉམ༌པོ༌ སད༌ཅེས༌ལ༌ ལམ༌ཅུག༌ ");
INSERT INTO lbj_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","ཡང༌ ཟེརས༌, “ཁྱོ༌ཞ༌གུན༌ནི༌ འི༌བོ༌ ཅོ༌གོས༌, བུ༌ཚ༌ དང༌ ན༌མ༌ ཅོ༌ཁན༌ནི༌ བུ༌མོ༌ ཚང༌མ༌ སོད༌ ཨིན༌ནའང༌ ན༌མ༌ མ༌ཅོ༌ཁན༌ བུ༌མོ༌གུན༌ མ༌སད༌ད༌ སོན༌ཏེའ༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","ཁོང༌གུན༌ལ༌ ཡ༌བེཤ༌ གི༌ལེད༌དི༌ ནང༌ང༌ དུག༌ཁན༌གུན༌ནི༌ ཕྲོའ༌ བུ༌ཚ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ མ༌ཅོ༌ཁན༌ནི༌ ན༌ཆུང༌ 400 ཐོབ༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཏེ༌ བུ༌མོ༌གུན༌ ཀེ༌ནན༌ ཡུལ༌ཇོངས༌སི༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ ཀུར༌ ཙུགས༌ཏེ༌ དུགས༌ས༌ ཁྲིད༌ཏེ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","ཏེ༌རུ༌ ཛོམས༌ཏེ༌ ཡོད༌ཁན༌ ཚང༌མའེ༌ རིམ༌མོན༌ནི༌ བྲག༌གི༌ ནས༌སའ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ཞི༌དེ༌ ཐུན༌བྲེལ༌ ཅོ༌ཅེས༌ལ༌ ལོན༌ ཀལས༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","ཏེ༌ནེ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ ལོགས༌ཏེ༌ ཡོངས༌ ཡང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཡ༌བེཤ༌ གི༌ལེད༌ནེ༌ མ༌ སད༌ད༌ ཁྱོང༌ཁན༌ ན༌ཅུང༌གུན༌ ཁོང༌གུན༌ལ༌ ན༌མ༌ ཏངས༌། ཨིན༌ནའང༌ ཁོང༌ ཚང༌མའེ༌ ཕིའ༌ དྲན༌དྲ༌ མ༌སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","ཡ༌ཝའེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ མི༌སྡེ༌གུན༌ནི༌ ནང༌ང༌ པར༌ ཕེའ༌ ཛད༌ པ༌སང༌ ཁོང༌གུན༌ནི༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ ཕིའ༌ ཉ༌ངན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","ཡང༌ ཛོམས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ འུ༌སྐྱོང༌གུན༌ནི༌ ཟེརས༌, “བེན༌ཡཱ༌མིན༌པ༌ བུ༌མོ༌ ཚང༌མ༌ སད༌ པ༌སང༌ ཏ༌ ལུས༌ཁན༌ འི༌ བུ༌ཚ༌གུན༌ནི༌ ཕིའ༌ ང༌དང༌ངི༌ ན༌མ༌ ཀ༌ནེ༌ ཁྱོང༌ཨིན༌? ");
INSERT INTO lbj_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","ཨིས༌ར༌ཨེལ༌པའེ༌ མི༌སྡེ༌ ཅིག༌གའང༌ སྟོར༌ མི༌སྟོར༌ཅེས༌ལ༌ བེན༌ཡཱ༌མིན༌པ༌ སོན༌ཏེའ༌ ལུས༌ཁན༌གུན༌ལ༌ པུར༌གྱུད༌ ཡོང༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","‘བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ བུ༌མོ༌ ན༌མ༌ ཏང༌ཁན༌གུན༌ལ༌ ངན༌ ཕོག༌ཤིག༌’ ཟེར༌ཏེ༌ ང༌དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ནའ༌ ཁུར༌ཏེ༌ ཨིན༌ པ༌སང༌ ང༌དང༌གུན༌ནི༌ ཁོང༌གུན༌ལ༌ ང༌དང༌ངི༌ བུ༌མོ༌གུན༌ ན༌མ༌ ཏང༌ མི༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","ཨིན༌ནའང༌ ལྟོས༌སའང༌, བེ༌ཐེལ༌ལི༌ བྱང༌ ཆོགས༌ ཡང༌ བེ༌ཐེལ༌ནེ༌ ཤེ༌ཀེམ༌མ༌ ཆའ༌ཁན༌ ཤར༌ ཆོགས༌སི༌ ལམ༌ ཡང༌ ལེ༌བོ༌ནཧའེ༌ ལྷོ༌ ཆོགས༌ལ༌ ཡོད༌ཁན༌ ཤི༌ལོཧའེ༌ ནང༌ང༌ ཡ༌ཝའེ༌ ཕིའ༌ ལོ༌ཞུང༌ རྩི༌ཁན༌ གའ༌སྟོན༌ དག༌ས༌ རྩི༌ཨིན༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ལ༌ ལབ༌ཞ༌ ཏངས༌ཏེ༌ ཟེརས༌, “སོང༌ ཡང༌ རྒུན༌ཚས༌གུན༌ནི༌ ནང༌ང༌ ཨིབས༌ཏེ༌ སྲུང༌ ");
INSERT INTO lbj_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","ཡང༌ ལྟོས༌། ཤི༌ལོཧ༌པ༌ བུ༌མོ༌གུན༌ རྩེས༌སི༌ ནང༌ང༌ ཁག༌ ལེན༌ན༌ལ༌ བིངས༌ཏེ༌ ཡོང༌ང༌ཅིག༌, རྒུན༌ཚས༌སི༌ ནང༌ནེ༌ གྱོགས༌པ༌ བིང༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཤི༌ལོཧ༌པ༌ བུ༌མོ༌ རེ༌རེ༌ ཟུམས༌ཏེ༌ ན༌མ༌ ཅོའ༌ལ༌ ཁྱོང༌ ཡང༌ བེན༌ཡཱ༌མིན༌ནི༌ ས༌ཆ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","ཀལ༌ཏེས༌ ཁོང༌གུན༌ནི༌ ཨ༌བ༌ ཡ༌ ཨ༌ཅོ༌ནོ༌ ང༌ཞ༌གུན༌ནི༌ཀ༌ སྐྱོན༌རྗོད༌ ཅོའ༌ ཡོང༌ན༌ ང༌ཞའེ༌ ཟེར༌ཨིན༌, ‘ཁོང༌གུན༌ལ༌ རོགས༌ ཅོས༌ཏེ༌ ང༌ཞ༌གུན༌ལ༌ ཐུག༌རྗེ༌ ཛད༌ ཅིའ༌ཟེར༌ན༌ མག༌གི༌ ནང༌ང༌ ང༌ཞའ༌ ཁོང༌ ཚང༌མའེ༌ ཕིའ༌ ན༌མ༌ མ༌ཐོབ༌ ཡང༌ ཁྱོ༌ཞ༌གུན༌ནི༌ རང༌ངི༌ བུ༌མོ༌ ཁོང༌གུན༌ལ༌ ན༌མ༌ མ༌ཏངས༌ པ༌སང༌ ཁྱོ༌ཞའ༌ ནའ༌ ཁུར༌ཁན༌བོ༌ ཅག༌ཅེས༌སི༌ ནང༌ང༌ མ༌གལ༌ལ༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","ཏེ༌ནེ༌ བེན༌ཡཱ༌མིན༌པ༌གུན༌ནི༌ ལབ༌ཞ༌ ཏང༌ཁན༌ ནང༌ཞིན༌ ཅོས༌, བུ༌མོ༌གུན༌ རྩེ༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ ཁོང༌ རེ༌རེ༌ བུ༌མོ༌ རེ༌རེ༌ ཟུམས༌ཏེ༌ ན༌མ༌ ཅོའ༌ལ༌ ཁྱོངས༌། ཁོང༌གུན༌ ཁོང༌རང༌གུན༌ལ༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌ལ༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ གྲོང༌ཁྱེར༌བོ༌ ཡང༌སྐྱར༌ རྩིགས༌ཏེ༌ ཏེ༌རུ༌ ཚུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","ཏེ༌ནེ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ ཏེ༌ ནས༌ས༌ནེ༌ ལོགས༌ཏེ༌ ཁང༌པ༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཁན༌ནི༌ ས༌ཀྱད༌ ཁོང༌རང༌གུན༌ནི༌ མི༌སྡེ༌ དང༌ མི༌རིགས༌གུན༌ ཡོད༌ས༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","ཏེ༌ ཏུས༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ལ༌ གྱལ༌པོ༌ མེད༌པིན༌, ཚང༌མའེ༌ རང༌རང༌ ཐད༌ཁན༌བོ༌ ཅོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ སྐྱོབ༌ཁན༌ གོ༌ཁྲིད༌གུན༌ནི༌ ཝང༌སྲུལ༌ལི༌ ཏུས༌ མུ༌གེ༌ ཇུང༌, ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌སི༌ བེད༌ལེ༌ཧེམ༌པ༌ མི༌ཞིག༌ ཁོང༌རང༌ངི༌ ན༌མ༌ དང༌ བུ༌ཚ༌ ཉིས༌ཀོ༌ ཁྲིད༌ཏེ༌ མོ༌འབ༌བི༌ ཡུལ༌ལ༌ དུག༌ག༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","ཏེ༌ མི༌བོའེ༌ མིང༌ ཨེ༌ལི༌མེ༌ལེག༌ ཨིན༌པིན༌, ཁོའེ༌ ན༌མ༌ ནཱའོ༌མི༌ ཡང༌ མཧ༌ལོན༌ དང༌ ཀི༌ལི༌འོན༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ ཨིན༌པིན༌། ཁོང༌གུན༌ ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌སི༌ བེད༌ལེ༌ཧེམ༌ནེ༌ ཨེ༌ཕ༌རེད༌ མིར༌གྱུད༌ནེ༌ ཨིན༌པིན༌ ཡང༌ ཁོང༌གུན༌ མོ༌འབ༌བ༌ སོང༌ཏེ༌ ཏེ༌རུ༌ ཚུགས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","ཏེ༌རུ༌ ནཱའོ༌མི༌ མག༌པ༌ ཨེ༌ལི༌མེ༌ལེག༌ ཤི༌ ཡང༌ ཁོ༌ དང༌ ཁོའེ༌ བུ༌ཚ༌ ཉིས༌ཀོ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","བུ༌ཚ༌ ཉིས༌ཀོའེ༌ མོ༌འབ༌མ༌ བུ༌མོ༌ ཨོར༌པཧ༌ ཏང༌ རུཐ༌ ཉམ༌པོ༌ བག༌སྟོན༌ ཅོས༌། ཁོང༌གུན༌ ཧ༌ལམ༌ ལོ༌ རྕུ༌ ཏེ༌རུ༌ དུགས༌ཏེ༌ སྟིང༌ནེ༌, ");
INSERT INTO lbj_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","མཧ༌ལོན༌ དང༌ ཀི༌ལི༌འོན༌ ཉིས༌ཀོའང༌ ཤི༌, བུ༌ཚ༌ ཉིས༌ཀོ༌ དང༌ མག༌པ༌ ཤི༌པ༌ ནཱའོ༌མི༌ ཅིག༌པོ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","ཏེ༌ནེ༌ ཡ༌ཧུ༌དཱའེ༌ ནང༌ང༌ ཡ༌ཝའེ༌ ཁོང༌རང༌ངི༌ མི༌གུན༌ལ༌ ཅིན༌ལབས༌ སལ༌ཏེ༌ སྟོན༌ཐོག༌ གྱལ༌ལ༌ སལ༌ཁན༌བོ༌ མོ༌འབ༌བི༌ ནང༌ང༌ ནཱའོ༌མིའ༌ ཚོར༌ར༌ཅིག༌ ཁོ༌ དང༌ ཁོའེ༌ བུ༌ཚ༌གུན༌ནི༌ ན༌མ༌ མོ༌འབ༌ནེ༌ བིང༌ཏེ༌ ནཱའོ༌མིའི༌ ཡུལ༌ལ༌ ཆ༌ཅེས༌ གྲལ༌གྲིག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","ནཱའོ༌མི༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ནི༌ ན༌མ༌ ཁྲིད༌ཏེ༌ ཁོང༌གུན༌ དུག༌ཁན༌ནི༌ ཡུལ༌ནེ༌ བིངས༌ཏེ༌ ཡ༌ཧུ༌དཱ༌ ཆོགས༌ལ༌ ཆ༌སའེ༌ ལམ༌ནེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","ཨིན༌ནའང༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ བུ༌ཚ༌གུན༌ནི༌ ན༌མ༌ ཟེརས༌, “ཁྱོ༌ཞའ༌ ལོགས༌ཏེ༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཨ༌མའེ༌ ཁང༌པ༌ སོང༌ཤིག༌། ཁྱོ༌ཞའེ༌ ངའ༌ དང༌ ཤི༌ཁན༌གུན༌ལ༌ བཀའ༌དྲིན༌ སྟན༌ པ༌སང༌ ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌ ཐུག༌རྗེ༌ ཛད༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","ཡ༌ཝའེ༌ ཁྱོ༌ཞའ༌ ཡང༌སྐྱར༌ མག༌པ༌ སལ༌ཏེ༌ ཁྱོ༌ཞའ༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཁང༌པའེ༌ ནང༌ང༌ སྲུང༌སྐྱོབ༌ ཛད༌ཤིག༌།” ཏེ༌ནེ༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ ཇུ༌ ཟེར༌ཏེ༌ པུག༌ ཏངས༌ ཡང༌ ཁོང༌གུན༌ སྲན༌ཏྲེ༌ ངུས༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","བུ༌མོ༌གུན༌ནི༌ ཟེརས༌, “མན༌། ང༌ཞའ༌ ཉེ༌རང༌ ཉམ༌པོ༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ ཡོད༌ས༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","ཨིན༌ནའང༌ ནཱའོ༌མིའི༌ ལན༌ཏངས༌ “ངའེ༌ བུ༌མོ༌གུན༌, ཁང༌པའ༌ ལོགས༌ཏེ༌ སོང༌། ཁྱོ༌ཞའ༌ ང༌ ཉམ༌པོ༌ ཅིའ༌ ཆ༌ཉིན༌རག༌? ཁྱོ༌ཞའེ༌ བག༌སྟོན༌ ཅོ༌ཉན༌ཅེས༌ལ༌ ཅི༌ ང༌ ཞན༌ཡང༌ བུ༌ཚ༌ ཇོར༌ཨིན༌ན༌? ");
INSERT INTO lbj_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","མན༌ ངའེ༌ བུ༌མོ༌གུན༌, ཁྱོ༌ཞའ༌ ལོགས༌ཏེ༌ ཁྱོ༌ཞ༌རང༌ངི༌ ཁང༌པ༌ སོང༌, ང༌ ཡང༌སྐྱར༌ བག༌སྟོན༌ ཅོ༌ཅེས༌ལ༌ མ༌ རྒད༌མོ༌ སོང༌ཏེ༌ ཨིན༌ནོག༌། ཀལ༌ཏེས༌ ཏེ༌བོ༌ ཇུངས༌ཏེ༌ ང༌ དི༌རིང༌ ཚན༌ལ༌ ན༌མ༌ ཅོས༌ཏེ༌ བུ༌ཚ༌གུན༌ ཇོར༌ ནའང༌, ");
INSERT INTO lbj_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ཁྱོ༌ཞའ༌ ཁོང༌གུན༌ ལྡན༌ལྡན༌ སྲུངས༌ཏེ༌ དུག༌ཨིན༌ན༌? ཅི༌ ཁྱོ༌ཞའ༌ ཁོང༌གུན༌ནི༌ ཕིའ༌ ན༌མ༌ མ༌ཅོའ༌ དུག༌ཨིན༌ན༌? མན༌, མ༌ནེ༌ མན༌། ངའེ༌ བུ༌མོ༌གུན༌ འི༌བོ༌ ཁྱོ༌ཞ༌གུན༌ནི༌ སང༌ ངའེ༌ ཕིའ༌ མང༌ང༌ སྐྱོ༌མོ༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཡ༌ཝའེ༌ ངའ༌ ཐུག༌རྗེ༌ སྟན༌ན༌ མ༌ཛད༌ད༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","ཡང༌སྐྱར༌ ཁོང༌གུན༌ སྲན༌ཏྲེ༌ ངུས༌། ཏེ༌ནེ༌ ཨོར༌པཧའེ༌ ཁོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌མ༌ པུག༌ ཏངས༌ ཡང༌ ཇུ༌ ཟེར༌ཏེ༌ ལོགས༌ཏེ༌ སོང༌ ཨིན༌ནའང༌ རུཐ༌ ནཱའོ༌མིའ༌ ཐམས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","ནཱའོ༌མིའི༌ ཁོའ༌ ཟེརས༌, “ལྟོས༌, ཁྱོ༌རང༌ངི༌ མག༌པའེ༌ ནོའེ༌ ན༌མ༌ ཁོ༌རང༌ངི༌ མི༌གུན༌ དང༌ ལྷ༌ལྷ༌མོ༌ གུན༌ནི༌ཀ༌ ལོགས༌ཏེ༌ ཆའ༌ལ༌, ཁྱོ༌རང༌ངའང༌ ཁོ༌ ཉམ༌པོ༌ ལོགས༌ཏེ༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","ཨིན༌ནའང༌ རུཐ༌ཐི༌ ལན༌ཏངས༌, “ངའ༌ ཉེ༌རང༌ ཕངས༌ཏེ༌ ལོགས༌ཏེ༌ ཆ༌ཅེས༌ལ༌ འུ༌ཙུག༌ མ༌སལ༌། ཉེ༌རང༌ ཀ༌རུ༌ སྐྱོད༌ནའང༌ ང༌ ཆེན༌ ཡང༌ ཉེ༌རང༌ ཀ༌རུ༌ ཞུགས༌ནའང༌ ང༌ དུག༌ཨིན༌། ཉེ༌རང༌ངི༌ མི༌ ངའེ༌ མི༌ ཡང༌ ཉེ༌རང༌ངི༌ དཀོན༌མཆོག༌ ངའེ༌ དཀོན༌མཆོག༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","ཉེ༌རང༌ ཀ༌རུ༌ ཀྲོངས༌ན༌ ང༌ ཏེན༌ན༌རུ༌ ཤི༌ཨིན༌ ཡང༌ ཏེན༌ན༌རུ༌ སུབ༌ཨིན༌། ཤི༌ཅེས༌ མ༌སྟོག༌ ཞན༌ ཅི༌ཞིག༌གིའང༌ ང༌དང༌ ཉིས༌ཀོ༌ ཕེ༌ན༌ ཡ༌ཝའེ༌ ངའ༌ སྲན༌ཏྲེ༌ ཆད༌པ༌ སལ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","རུཐ༌ ལོགས༌ཏེ༌ མ༌ཆ༌ རངས༌ཏེ༌ དུག༌ཅེས༌པོ༌ ནཱའོ༌མིའ༌ ཧ༌གོའ༌ཅིག༌ ཁོའེ༌ ཡང༌ ཅའང༌ མ༌ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","ཏེ༌ནེ༌ ཁོང༌ ཉིས༌ཀོའེ༌ བེས༌ གོ༌ཟུགས༌ཏེ༌ བེད༌ལེ༌ཧེམ༌ ཆོགས༌ལ༌ སོང༌། ཁོང༌གུན༌ ཏེ༌རུ༌ ལེབ༌བ༌ཅིག༌ གྲོང༌ཁྱེར༌ གང༌པོ༌ ཁོང༌གུན༌ ལོགས༌ཏེ༌ ཡོང༌ང༌ ཐོང༌ཏེ༌ སྲན༌ཏྲེ༌ ཧ༌ལས༌ ཡང༌ ཟེརས༌, “ཅི༌ འི༌བོ༌ ཏན༌ཏན༌ ནཱའོ༌མི༌ ཨིན༌ནོག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","ནཱའོ༌མི༌ ལན༌ཏངས༌, “ངའ༌ ནཱའོ༌མི༌ མ༌ཟེར༌ར༌ མ༌ར༌ ཟེར༌ཤིག༌ ཅིའ༌ཟེར༌ན༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ངའེ༌ མི༌ཚེའེ༌ མ༌ སྐྱོ༌མོ༌ ཅོའ༌ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","ཆ༌ ཟ༌ནེ༌ ངའེ༌ ལག༌ག༌ ཅི༌ཚང༌མ༌ ཡོད༌པིན༌ ཨིན༌ནའང༌ ཡ༌ཝའེ༌ ངའ༌ ལོགས༌ཏེ༌ ཁང༌པའ༌ ལག༌པ༌ སྟོང༌པ༌ ཁྱོང༌ང༌ ཛདས༌། ངའ༌ ནཱའོ༌མི༌ ཅིའ༌ ཟེར༌ཨིན༌ ནམ༌ ཡ༌ཝའེ༌ ངའ༌ རྡུག༌ངལ༌ སལ༌ཏེ༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ངའ༌ རྡུག༌པོ༌ ཇུང༌ཅུག༌ག༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","ཏེན༌ན༌ ཟུག༌གི༌ ནཱའོ༌མི༌ མོ༌འབ༌ནེ༌ ལོགས༌ཏེ༌ ཡོངས༌ ཡང༌ ཁོ༌ ཉམ༌པོ༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ ན༌མ༌ མོ༌འབ༌མ༌ རུཐ༌ ཡོད༌པིན༌། ཁོང༌གུན༌ བེད༌ལེ༌ཧེམ༌མ༌ ལེབ༌ ཟ༌ནེ༌ ནས༌སི༌ སྟོན༌ཐོག༌ རྔ༌ཅེས༌ གོ༌ཟུགས༌ཏེ༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","ཏ༌ བེད༌ལེ༌ཧེམ༌མི༌ ནང༌ང༌ ཆུག༌པོ༌ རྩི༌ཝ༌ཅན༌ བོ༌འཟ༌ ཟེར༌ཁན༌ མི༌ཞིག༌ ཡོད༌པིན༌, ཁོ༌ ནཱའོ༌མིའི༌ མག༌པ༌ ཨེ༌ལི༌མེ༌ལེག༌གི༌ ཉེན༌གྲུང༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","ཞག༌ཤིག༌ མོ༌འབ༌པ༌ རུཐ༌ཐི༌ ནཱའོ༌མིའ༌ ཟེརས༌, “ཀའ༌ཀྲིན༌ སྟན༌ཏེ༌ ཏུ༌ཅུག༌ཁན༌ནི༌ མི༌ ཞིང༌ངི༌ཀ༌, ལུས༌ཏེ༌ ཡོད༌ཁན༌ནི༌ སྟོན༌ཐོག༌ ཏུས༌ཏེ༌ ཁྱོང༌ང༌ལ༌ ང༌ ཆ༌ཅུག༌ག༌ ཛད༌།” ནཱའོ༌མིའི༌ ལན༌ཏངས༌, “ངའེ༌ བུ༌མོ༌ སོང༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","ཏེ༌ནེ༌ རུཐ༌, སྟོན༌ཐོག༌ རྔ༌ཁན༌གུན༌ནི༌ གྱབ༌ནེ༌ སོང༌ཏེ༌ ལུས༌ཁན༌ནི༌ སྟོན༌ཐོག༌ ཏུ༌ཅེས༌ གོ༌ཟུག༌། ཏེ༌ ཞིང༌ ཁོའེ༌ མག༌པའེ༌ ཨ༌བ༌ ཨེ༌ལི༌མེ༌ལེག༌གི༌ ཉེན༌གྲུང༌ བོ༌འཟ༌སི༌ ཨིན༌ཁན༌བོ༌ ཁོའ༌ གྱུས༌མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","ཁོ༌ ཏེ༌རུ༌ ཡོད༌ ཟ༌ནེ༌ བོ༌འཟ༌ བེད༌ལེ༌ཧེམ༌ནེ༌ ལེབ༌ ཡང༌ སྟོན༌ཐོག༌ རྔ༌ཁན༌གུན༌ལ༌ ལོན༌སྲུལ༌ཏེ༌ ཟེརས༌, “ཡ༌ཝ༌ དཀོན༌མཆོག༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ཞུགས༌ཤིག༌།” ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཡ༌ཝའེ༌ ཉེ༌རང༌ང༌ ཅིན༌ལབས༌ སལ༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","ཏེ༌ནེ༌ བོ༌འཟ༌སི༌ ཞིང༌ རྔ༌ཁན༌གུན༌ནི༌ ཁག༌ཁུར༌པ༌ བོད༌ཏེ༌ ཏྲིས༌, “འ༌ ན༌ཆུང༌བོ༌ སུའི༌ བུ༌མོ༌ ཨིན༌ནོག༌?” ");
INSERT INTO lbj_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","ཁག༌ཁུར༌པ༌བོའེ༌ ལན༌ཏངས༌, “མོ༌འབ༌ནེ༌ ནཱའོ༌མི༌ ལོགས༌ཏེ༌ ཡོང༌ ཟ༌ནེ༌ འི༌ ན༌ཆུང༌བོ༌ ཁོ༌ ཉམ༌པོ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","‘ཞིང༌ རྔ༌ཁན༌གུན༌ནི༌ གྱབ༌ནེ༌ སོང༌ཏེ༌ སྟོན༌ཐོག༌ ལུས༌ཁན༌གུན༌ ཏུ༌ཅུག༌ག༌ཛད༌’ ཟེར༌ཏེ༌ ཁོའེ༌ ངའ༌ ཏྲིའ༌རག༌། ཁོ༌ ང༌མོ༌ནེ༌ ཕར༌ལ༌ ལས༌ ཅོ༌ཨིན༌ དུགས༌ཏེ༌ སིལ༌ལི༌ ནང༌ང༌ ངལ༌ སྲིབ༌ཅིག༌ མ༌ནེ༌ མ༌ ཚོས༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","ཏེ༌ནེ༌ བོ༌འཟ༌སི༌ རུཐ༌ལ༌ ཟེརས༌, “ཉོན༌ ངའེ༌ བུ༌མོ༌, ཁྱོ༌རང༌ སྟོན༌ཐོག༌ ལུས༌ཁན༌ ཏུའ༌ལ༌ ཞན༌མའེ༌ ཞིང༌ངི༌ཀ༌ མ༌ཆ༌, འིན༌ནེ༌ཀ༌ ང༌ཞ༌གུན༌ ཡོད༌ས༌ དུག༌། ངའེ༌ ལས༌ ཅོ༌ཁན༌ ན༌ཆུང༌གུན༌ ཉམ༌པོ༌ དུག༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","བུ༌ཚ༌གུན༌ནི༌ ཞིང༌ངི༌ ཀ༌ཁག༌པོ༌ རྔ༌རུག༌ ལྟོས༌ ཡང༌ ཁོང༌གུན༌ནི༌ སྟིང༌རང༌ནེ༌ ན༌ཆུང༌གུན༌ ཉམ༌པོ༌ སོང༌། ཁྱོ༌རང༌ང༌ ལག༌པ༌ རྩེས༌ཏེ༌ ངན༌པ༌ མི༌ཅོ༌ཅེས༌ལ༌ ངའེ༌ བུ༌ཚ༌གུན༌ལ༌ བཀའ༌ ཏངས༌པིན༌། ཡང༌ ཁྱོ༌རང༌ སྐོམས༌ ཟ༌ནེ༌ ལས༌ ཅོ༌ཁན༌གུན༌ནི༌ སྐངས༌ཁན༌ནི༌ རྫའ༌མེ༌ ནང༌ནེ༌ ཆུ༌ ཕིངས༌ཏེ༌ ཐུང༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","ཏེ༌ནེ༌ རུཐ༌ ཁོའེ༌ རྐང༌པའེ༌ དུན༌ལ༌ གྱེལ༌ཏེ༌ ཟེརས༌, “ང༌ ཞན༌ཡུལ༌ལི༌ མིའ༌ འི༌ཟམ༌ ཐུག༌རྗེ༌ སྟན༌ན༌ ཛད༌ཏེ༌ ངའེ༌ ཉེ༌རང༌ང༌ ཕིའ༌ ཅི༌ ཅོས༌?” ");
INSERT INTO lbj_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","བོ༌འཟ༌སི༌ ལན༌ཏངས༌, “ཁྱོ༌རང༌ངི༌ མག༌པ༌ ཀྲོངས༌པ༌ ནེ༌ ཕར༌ལ༌ ཁྱོ༌རང༌ངི༌ རང༌ངི༌ མག༌པའེ༌ ཨ༌མའེ༌ ཕིའ༌ ཅོ༌ཁན༌ ཚང༌མ༌ ངའ༌ གྱུས༌སོང༌, ཁྱོ༌རང༌ རང༌ངི༌ ཨ༌བ༌, ཨ༌མ༌ དང༌ རང༌ཡུལ༌ ཕངས༌ཏེ༌ འི༌རུ༌ མི༌ མ༌ཤེས༌ཁན༌གུན༌ ཉམ༌པོ༌ དུག༌ག༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","ཁྱོ༌རང༌ངི༌ ཅོས༌ཁན༌ ལས༌གུན༌ནི༌ ཕིའ༌ ཡ༌ཝའེ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ སལ༌ཤིག༌། ཨིས༌ར༌ཨེལ༌པའེ༌ དཀོན༌མཆོག༌ ཡ༌ཝའེ༌ ནང༌ང༌ ཁྱོ༌རང༌ངི༌ སྲུང༌སྐྱོབ༌ ལེན༌ པ༌སང༌ ཁྱོ༌རང༌ང༌ ཁོང༌ངི༌ སོལ༌རས༌ སལ༌ལ༌ ཛད༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","ཁོའེ༌ ལན༌ཏངས༌, “སྤོན༌བོ༌ལེ༌, ཉེ༌རང༌ངི༌ ཆོགས༌སྐྱོར༌ ང༌ ཉམ༌པོ༌ ཏ༌རུང༌ངའང༌ ལུས༌ཤིག༌། ངའ༌ ཉེ༌རང༌ངི༌ ལས༌ ཅོ༌ཁན༌ མན༌ནའང༌ ཉེ༌རང༌ངི༌ ངའ༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཟང༌པོ༌ ཏངས༌ཏེ༌ ང༌ ཞི༌དེ༌ སལས༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","ཁར༌ཇི༌ ཟའ༌ཅེས༌སི༌ ཏུས༌ ལེབ༌བ༌ཅིག༌ བོ༌འཟ༌སི༌ རུཐ༌ལ༌ བོད༌ཏེ༌ ཟེརས༌, “འི༌རུ༌ ཡོང༌ ཡང༌ ཏ༌གི༌ ལེན༌ཏེ༌ རྒུན༌ཆང༌ སྐྱུར༌མོའེ༌ ནང༌ང༌ སྤགས༌ཏེ༌ ཟོ༌།” ཏེ༌ནེ༌ ཁོ༌ སྟོན༌ཐོག༌ རྔོ༌ཁན༌གུན༌ ཉམ༌པོ༌ དུགས༌ ཡང༌ བོ༌འཟ༌སི༌ ཁོའ༌ རྔོ༌ཁན༌ནི༌ གྲུ༌ ཟའ༌ལ༌ ཏངས༌། ཁོ༌ ཟའ༌ ཉན༌ཁན༌བོ༌ ཟོས༌ ཡང༌ ལག༌མ༌ ལུས༌ཁན༌བོ༌ ཐེན༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","རུཐ༌ སྟོན༌ཐོག༌ ཏུའ༌ལ༌ ཆའ༌ཅིག༌ བོ༌འཟ༌སི༌ ཁོ༌རང༌ངི༌ མི༌གུན༌ལ༌ ཟེརས༌, “ཁོའེ༌ སྟོན༌ཐོག༌ རྔ༌ཁན༌ནི༌ དུན༌ནེ༌ ཏུ༌ནའང༌ ཁོའ༌ ཅའང༌ མ༌ཟེར༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","མ༌ཚད༌ ལྡམས༌ཁན༌ནི༌ སྟོན༌ཐོག༌གི༌ ནང༌ནེ༌ ཁག༌རིག༌ བིངས༌ཏེ༌ ཁོའ༌ ཏུ༌ཅེས༌ལ༌ བོར༌ཤིག༌, ཁོའ༌ ཁའ༌ མ༌ སྐྱེའ༌ ཏེ༌ ཚང༌མ༌ ཏུ༌ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","ཏེ༌བོའེ༌ཕིའ༌ རུཐ༌ཐི༌ ཏེ༌རུ༌ ཕི༌ཏོག༌ ཚག༌པ༌ སྟོན༌ཐོག༌ ཏུས༌ ཡང༌ གྲུ༌ ཕིང༌ཅེས༌ལ༌ ཏེ༌གུན༌ རྡུང༌ང༌ཅིག༌ ཧ༌ལམ༌ ཀི༌ལོ༌ རྕུག༌ཤིག༌གི༌ གྲུ༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","ཏེ༌བོ༌ ཁུར༌ཏེ༌ ཁོ༌ གྲོང༌ཁྱེར༌ལ༌ ལོགས༌ཏེ༌ སོང༌ ཡང༌ ཁོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌མའ༌ སྟནས༌། རྔོ༌ཁན༌ནི༌ གྲུ༌ ཟོས༌ཏེ༌ ལུས༌ཁན༌ ཐེན༌ཏེ༌ བོར༌ཁན༌བོ༌ རུཐ༌ཐི༌ ཁོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌མའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","ནཱའོ༌མིའི༌ ཁོའ༌ ཏྲིས༌, “དི༌རིང༌ ཁྱོ༌རང༌ངི༌ སྟོན༌ཐོག༌ ལུས༌ཁན༌ སུའི༌ ཞིང༌ངི༌ཀ༌ ཏུས༌པིན༌? ཁྱོ༌རང༌ངི༌ ཀ༌རུ༌ ལས༌ ཅོས༌པིན༌? ཁྱོ༌རང༌ང༌ ཀའ༌ཀྲིན༌ སྟན༌ཁན༌ མི༌བོའ༌ ཡ༌ཝའེ༌ ཅིན༌ལབས༌ སལ༌ལ༌ ཛད༌ཤིག༌།” ཏེ༌ནེ༌ རུཐ༌ཐི༌ ཁོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌མའ༌ ཁོའེ༌ སྟོན༌ཐོག༌ ཏུ༌ཁན༌ དག༌པོའེ༌ སྐོར༌ལ༌ ཤདས༌, “དི༌རིང༌ ངའེ༌ ལས༌ ཅོ༌ཁན༌ དག༌པོའེ༌ མིང༌ང༌ བོ༌འཟ༌ ཟེར༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","ནཱའོ༌མིའི༌ ཁོ༌རང༌ངི༌ བུ༌ཚའེ༌ ན༌མ༌ ཟེརས༌, “ཡ༌ཝའེ༌ ཁོའ༌ ཅིན༌ལབས༌ སལ༌ཤིག༌། ཁོའེ༌ ང༌དང༌ སོན༌ཏེའ༌ ཡོད༌ཁན༌ དང༌ ཤི༌ཁན༌ ཚང༌མའ༌ ཐུག༌རྗེ༌ སྟན༌ཏེ༌ ཨིན༌ནོག༌། ཏེ༌ མི༌བོ༌ ཀགས༌པོའེ༌ ཏུས༌ལ༌ ང༌དང༌ངི༌ ནང༌ཚངས༌ལ༌ སྟ༌སྟོག༌ ཅོ༌ཁན༌ ང༌དང༌ངི༌ ཉེན༌གྲུང༌ ཉེ༌མོ༌ཞིག༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","ཏེ༌ནེ༌ རུཐ༌ཐི༌ ཟེརས༌, “ཁོང༌ངི༌ ངའ༌ ཟེར༌ར༌རག༌, ‘ངའེ༌ སྟོན༌ཐོག༌ ཚང༌མ༌ རྔ༌ ཚར༌ཚར༌ ཁྱོ༌རང༌ ངའེ༌ སྟོན༌ཐོག༌ རྔོ༌ཁན༌གུན༌ ཉམ༌པོ༌ དུག༌།’” ");
INSERT INTO lbj_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","ནཱའོ༌མི༌ རུཐ༌ལ༌ ཟེརས༌, “ངའེ༌ བུ༌མོ༌, ཁོའེ༌ ཟེར༌ཁན༌བོ༌ ཅོས༌། ཁོའེ༌ ལས༌ ཅོ༌ཁན༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ ཁོའེ༌ ཞིང༌ངི༌ཀ༌ དུག༌, ཏེ༌མན༌ན༌ ཞན༌མའེ༌ ཞིང༌ངི༌ཀ༌ ལས༌ ཅོ༌ཁན༌གུན༌ནི༌ ཁྱོ༌རང༌ང༌ ལག༌པ༌ རྩེས༌ཏེ༌ ངན༌པ༌ ཅོ༌སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","ཏེ༌བོའེ༌ཕིའ༌ རུཐ༌ བོ༌འཟ༌སི༌ ཞིང༌ངི༌ཀ༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ ཀྲོ༌ནས༌ ཉིས༌ཀོའེ༌ སྟོན༌ཐོག༌ རྔ༌ ཚར༌ཚར༌ སྟོན༌ཐོག༌ ལུས༌ཁན༌གུན༌ ཏུས༌ ཡང༌ ཏེ༌ཏུས༌ གང༌པོ༌ ཁོ༌ ཁོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌མ༌ ཉམ༌པོ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","ཞག༌ཤིག༌ ནཱའོ༌མིའི༌ རུཐ༌ལ༌ ཟེརས༌, “ངའེ༌ བུ༌མོ༌, ཁྱོ༌རང༌ང༌ སྟ༌སྟོག༌ ཅོ༌ཁན༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ མག༌པ༌ ཞིག༌ ཙལ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","བོ༌འཟ༌ ང༌དང༌ངི༌ ཉེན༌གྲུང༌ ཉེ༌མོ༌ ཡང༌ ཁོའེ༌ ཁྱོ༌རང༌ང༌ ལས༌ཅོ༌ཁན༌ བུ༌མོ༌གུན༌ ཉམ༌པོ༌ སྟོན༌ཐོག༌ བུད༌ཁན༌ ཏུ༌ ཅུགས༌ཏེ༌ ཀའ༌ཀྲིན༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། དི༌རིང༌ ཚན༌ལ༌ ཁོ༌ ནས༌སི༌ འོངས༌ཅར༌ཨིན༌ ཡུལ༌ཐག༌ག༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","ཏ༌ ངའེ༌ ཟེར༌ཁན༌བོ༌ ཅོས༌, ཆུའ༌ ཞུགས༌ཏེ༌ ཏྲི༌ཞིམ༌ ལུག༌ ཡང༌ ཀོས༌ལག༌ ཚང༌མའེ༌སང༌ ལྡེ༌མོ༌བོ༌ གོན༌ཏེ༌ བོ༌འཟ༌ ཡོད༌ས༌ ཡུལ༌ཐག༌ག༌ སོང༌ ཨིན༌ནའང༌ ཁོ༌ ཟའ༌ ཐུང༌ ཚར༌ཚར༌ ཁྱོ༌རང༌ ཏེ༌རུ༌ ཡོད༌ཁན༌བོ༌ གྱུས༌ ཆ༌ མ༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","ཁོ༌ ཉིད༌ལོག༌ག༌ ཆའ༌ཅིག༌, ཁོ༌ ཉིད༌ལོག༌སའེ༌ ནས༌ས༌བོ༌ སྟན༌པོ༌ ཨིད༌ཏུ༌ ཅོས༌། ཏེ༌ནེ༌ སོང༌ཏེ༌ ཁོ༌ གོན༌ཁན༌ནི༌ མལ༌ཙ༌ རྐང༌པའེ༌ ཀ༌ནེ༌ ཐེན༌ཏེ༌ ཁོའེ༌ རྐང༌པའེ༌ དུན༌ལ༌ ཉལ༌ཏེ༌ དུག༌། ཁོའེ༌ ཁྱོ༌རང༌ང༌ ཅོ༌གོས༌ཤེས༌པོ༌ ཤད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","རུཐ༌ཐི༌ ལན༌ཏངས༌, “ཉེ༌རང༌ངི༌ མོལ༌ཁན༌ ཚང༌མ༌ ངའེ༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","ཏེ༌ནེ༌ ཁོ༌ ཐུར༌ལ༌ ཡུལ༌ཐག༌ག༌ སོང༌ ཡང༌ ཁོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌མའེ༌ ལབ༌ཞ༌ ཏང༌ཁན༌བོ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","བོ༌འཟ༌ ཟའ༌ ཐུང༌ ཚར༌ཏེ༌ སེམས༌ ཐད༌པོའེ༌ ནང༌ང༌ ཡོད༌པིན༌། ཏེ༌ནེ༌ ཁོ༌ གྲུའི༌ ལབ༌ཙེ༌ སྤུངས༌ཏེ༌ ཡོད༌སའེ༌ ཇུག༌ག༌ སོང༌ཏེ༌ ཉིད༌ལོགས༌། རུཐ༌ ཀུ༌ལེའ༌ སྐད༌ མ༌ཕིང༌ང༌ སོང༌ཏེ༌ ཁོའེ༌ རྐང༌པའེ༌ ཀ༌ནེ༌ མལ༌ཙ༌ ཐེནས༌ ཡང༌ ཏེ༌ཀ༌ ཉལ༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","ཚན༌སྐྱིལ༌ ཞིག༌ག༌ ཧུན༌མེད༌ལ༌ བོ༌འཟ༌སི༌ ཉིད༌ཚད༌ ཡང༌ བུ༌མོ༌ཞིག༌ ཁོའེ༌ རྐང༌པའེ༌ དུན༌ལ༌ ཉིད༌ལོགས༌ཏེ༌ ཡོད༌ཁན༌བོ༌ ཐོང༌ཏེ༌ ཧ༌ལས༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","ཁོའེ༌ ཏྲིས༌, “ཉེ༌རང༌ སུ༌ ཨིན༌།” ཁོའེ༌ ལན༌ཏངས༌, “ང༌ ཉེ༌རང༌ངི༌ ཞབ༌ཤི༌ རུཐ༌ ཨིན༌། ཉེ༌རང༌ ངའེ༌ མག༌པའེ༌ ཉེན༌གྲུང༌ ཉེ༌མོ༌ ཡང༌ ཀགས༌པོའེ༌ ཏུས༌ལ༌ ང༌ཞའེ༌ ནང༌ཚངས༌ལ༌ སྟ༌སྟོག༌ ཅོ༌ཁན༌ ཨིན༌ པ༌སང༌ ཉེ༌རང༌ངི༌ མལ༌ཙ༌ རྐྱངས༌ཏེ༌ ངའ༌ ཀབ༌བ༌ ཛད༌། ” ");
INSERT INTO lbj_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","བོ༌འཟ༌སི༌ ཟེརས༌, “ངའེ༌ བུ༌མོ༌, ཡ༌ཝའེ༌ ཁྱོ༌རང༌ང༌ ཅིན༌ལབས༌ སལ༌ཤིག༌། ཁྱོ༌རང༌ངི༌ ན༌མ༌ ཅོ༌ཅེས༌ལ༌ ཆུག༌པོ༌ ཡ༌ ཉལ༌བ༌ཅན༌ ཞུ༌ནུ༌ བུ༌ཚ༌ མ༌ ཙལ༌ལ༌ ང༌ ཡོད༌ས༌ ཡོངས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ སྔུན༌ནི༌ སང༌ དག༌ས༌ མང༌ང༌ རང༌ངི༌ ནང༌ཚངས༌སི༌ ཕིའ༌ དད༌ སྟན༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","ཏ༌ ཚེར༌ མ༌ཚེར༌ ངའེ༌ བུ༌མོ༌, ཁྱོ༌རང༌ངི༌ ཟེར༌ཁན༌ ཚང༌མ༌ ངའེ༌ ཅོ༌ཨིན༌། ཁྱོ༌རང༌ སྕོད༌ལམ༌ ཟང༌པོ༌ཅན༌ནི༌ བུ༌མོ༌ ཨིན༌ཁན༌བོ༌ གྲོང༌ཁྱེར༌རི༌ མི༌ ཚང༌མ༌ གྱུས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","ང༌ ཁྱོ༌རང༌ངི༌ མག༌པའེ༌ ཉེན༌གྲུང༌ ཉེ༌མོ༌ ཨིན༌ཁན༌བོ༌ ཀྲང༌པོ༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ ངའེ༌ སང༌ མང༌ང༌ ཁྱོ༌རང༌ང༌ ཉེ༌མོ༌ ཉེན༌གྲུང༌ ཞན༌ མི༌ཞིག༌ ཡོད༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","དི༌རིང༌ ཚན༌བོ༌ འི༌རུ༌ དུག༌ ཡང༌ ང༌མོ༌ ངའེ༌ ཁོའ༌ སྤེ༌ར༌ ཏངས༌ཏེ༌ ཏྲི༌ཨིན༌ ཀལ༌ཏེས༌ ཁོའེ༌ ཁྱོ༌རང༌ང༌ སྟ༌སྟོག༌ ཅོ༌ཅེས༌སི༌ ཁག༌པོ༌ ལེན༌ན༌ གྱལ༌ལ༌ རག༌ ཨིན༌ནའང༌ ཁོ༌ ཏེ༌བོ༌ ཅོའ༌ ཐད༌ད༌ མེད༌ན༌ ཏེ༌ནེ༌ ཡ༌ཝ༌ སོན༌པོའེ༌ ཚན༌ནི༌ ནང༌ང༌ ངའེ༌ ཏེ༌ ཁག༌པོ༌ ལེན༌ཨིན༌། ཏ༌ ང༌མོ༌ ཚོག༌པ༌ འི༌རུ༌ ཉིད༌ལོགས༌ཏེ༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","ཏེ༌ནེ༌ རུཐ༌ བོ༌འཟ༌སི༌ རྐང༌པའེ༌ དུན༌ལ༌ ང༌མོ༌ ཚོག༌པ༌ ཉལ༌ཏེ༌ དུགས༌ ཨིན༌ནའང༌ ནམ༌ ལངས༌ཏེ༌ མི༌ངོ༌ཤེས༌སི༌སང༌ སྔུན༌ལ༌ ཁོ༌ ལངས༌ཏེ༌ སོང༌ ཅིའ༌ཟེར༌ན༌ བོ༌འཟ༌སི༌ ཟེར༌ཏེ༌ ཨིན༌པིན༌ “འི༌ ཡུལ༌ཐག༌ག༌ བུ༌མོ༌ ཡོང༌ཁན༌བོ༌ སུའང༌ གྱུས༌ ཆ༌མ༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","བོ༌འཟ༌སི༌ ཁོའ༌ ཟེརས༌, “ཁྱོ༌རང༌ གོན༌ཁན༌ནི༌ ཙ༌ཟར༌བོ༌ ཁྱོངས༌ཏེ༌ ཟུམ༌།” ཁོའེ༌ ཏེ༌ ནང༌ང༌ ཀི༌ལོ༌ 24 ནས༌ ལུགས༌ ཡང༌ བུ༌མོའེ༌ གྱབ༌བ༌ ཀལས༌། ཏེ༌ནེ༌ བོ༌འཟ༌ གྲོང༌ཁྱེར༌ལ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","རུཐ༌ ལོགས༌ཏེ༌ ཁོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌མ༌ ཡོད༌ས༌ ལེབ༌བ༌ཅིག༌ ནཱའོ༌མིའི༌ ཁོའ༌ ཏྲིས༌, “ཅི༌ སོང༌, ངའེ༌ བུ༌མོ༌།” བོ༌འཟ༌སི༌ ཁོའ༌ ཟེར༌ཁན༌ ཚང༌མ༌ རུཐ༌ཐི༌ ནཱའོ༌མིའ༌ ཤདས༌ ");
INSERT INTO lbj_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","ཡང༌ ཟེརས༌, “‘ཁྱོ༌རང༌ངི༌ མག༌པའེ༌ ཨ༌མ༌ ཡོད༌ས༌ ལག༌སྟོང༌ང༌ མ༌ཆའ༌’ ཟེར༌ཨིན༌ ཁོང༌ངི༌ ངའ༌ ནས༌ ཀི༌ལོ༌ 24 ཏངས༌།” ");
INSERT INTO lbj_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","ཏེ༌ནེ༌ ནཱའོ༌མིའི༌ ཁོའ༌ ཟེརས༌, “ངའེ༌ བུ༌མོ༌, ཟོད༌པ༌ ཉམ༌པོ༌ ཅི༌ ཆ༌རུག༌ ལྟོས༌། འི༌ ནས༌ལུག༌པོ༌ དི༌རིང༌ སེལ༌ཏེ༌ མན༌ནེ༌ ཁོ༌ ངལ༌ མི༌ཚོ༌།” ");
INSERT INTO lbj_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","བོ༌འཟ༌ གྲོང༌ཁྱེར༌རི༌ གྱས༌སྒོའེ༌ཀ༌ སོང༌ཏེ༌ དུགས༌། རུཐ༌ལ༌ ཤད༌ཁན༌ནི༌ ནཱའོ༌མིའི༌ མག༌པའེ༌ ཉེན༌གྲུང༌ ཉེ༌མོ༌ ཏེ༌རུ༌ ཡོང༌ང༌ཅིག༌ བོ༌འཟ༌སི༌ ཁོའ༌ ཟེརས༌, “འི༌ཀ༌ ཡོངས༌ཏེ༌ སའེ༌ཀ༌ དུག༌, ང༌ ཁྱོ༌རང༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏང༌གོ༌ཤེས༌ ཡོད༌།” ཁོང༌གུན༌ སའི༌ཀ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","ཏེ༌ནེ༌ བོ༌འཟ༌སི༌ གྲོང༌ཁྱེར༌རི༌ འུ༌སྐྱོང༌ རྕུ༌ ཁོའེ༌ ཞུ༌ཝ༌ ཕུལ༌ཏེ༌ ཡོང༌ཁན༌གུན༌ལ༌ སའེ༌ཀ༌ ཞུགས༌ ཟེརས༌ ཡང༌ ཁོང༌གུན༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","བོ༌འཟ༌སི༌ ནཱའོ༌མིའི༌ མག༌པའེ༌ ཉེན༌གྲུང༌ ཉེ༌མོ༌བོའ༌ ཟེརས༌, “མོ༌འབ༌ནེ༌ ལོགས༌ཏེ༌ ཡོང༌ཁན༌ནི༌ ནཱའོ༌མིའི༌ ང༌དང༌ངི༌ ཉེན༌གྲུང༌ ཨེ༌ལི༌མེ༌ལེག༌གི༌ ས༌ཀྱད༌པོ༌ ཙོང༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","ངའེ༌ ཏེ༌བོའེ༌ སྐོར༌ལ༌ ཤད༌ཏེ༌ ཁྱོ༌རང༌ང༌ ཏེ༌བོ༌ ཉོ༌ཅེས༌སི༌ སྐབས༌ ཏང༌ཨིན༌ སམ༌ ཀལ༌ཏེས༌ ཁྱོ༌རང༌ ཐད༌དད༌ན༌ འི༌ འུ༌སྐྱོང༌གུན༌ནི༌ དུན༌ལ༌ ཏེ༌བོ༌ ཉོ༌གོས༌ ཨིན༌ནའང༌ ཐད༌ད༌ མེད༌ན༌ དག༌ས༌ ངའ༌ ཟེར༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ངི༌ སྟིང༌ནེ༌ ཏེ༌བོ༌ ཉོ༌ཅེས༌སི༌ ཁག༌ ང༌ ཕོག༌ག༌ནོག༌།” མི༌བོའེ༌ ལན༌ཏངས༌, “ངའེ༌ ཏེ༌བོ༌ ཉོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","ཏེ༌ནེ༌ བོ༌འཟ༌སི༌ ཁོའ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ནཱའོ༌མི༌ ཀ༌ནེ༌ ས༌ཀྱད༌ ཉོ༌ན༌, མག༌པ༌ ཀྲོངས༌ཁན༌ མོ༌འབ༌མ༌ རུཐ༌ ཉམ༌པོའང༌ ཁྱོ༌རང༌ངི༌ ན༌མ༌ ཅོ༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཤི༌ཁན༌ནི༌ ས༌ཀྱད༌ དང༌ མིར༌གྱུད༌ ལུས༌ཤེས༌ལ༌ ཁོའ༌ ཕྲུ༌གུ༌ ཇོར༌གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ ཉེན༌གྲུང༌ བུ༌ཚའེ༌ ཟེརས༌, “ཏེ༌ཟུག༌ ཨིན༌ན༌ ངའེ༌ ཏེ༌ ས༌ཀྱད༌པོ༌ མི༌ ཉོ༌ ཅིའ༌ཟེར༌ན༌ ཏེ༌བོ༌ ངའེ༌ ཕྲུ༌གུ༌གུན༌ལ༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཅེས༌ མེ༌རག༌། ཉེ༌རང༌ངི༌ ས༌ཀྱད༌པོ༌ ཉོའ༌ ཛད༌, ཏེ༌བོ༌ ངའེ༌ མི༌ཉོ༌།” ");
INSERT INTO lbj_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","༼ཏ༌ ཏེ༌ ཏུས༌ལ༌ ས༌ཀྱད༌ ཉོ༌ཅེས༌ ཡ༌ ཙོང༌ཅེས༌ སྟན༌པོ༌ ཅོ༌ཅེས༌ལ༌, ཅིག༌པོའེ༌ ཞན༌ ཅིག༌པོའ༌ རང༌ངི༌ པ༌བུ༌ ཕུད༌ཏེ༌ ཏང༌ངད༌པིན༌། ཏེན༌ན༌ ཟུག༌གི༌ ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ ཁྲིམས༌ ནང༌ཞིན༌ ཚོང༌ལེན༌གུན༌ ཐག༌ ཅད༌དད༌པིན༌།༽ ");
INSERT INTO lbj_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","ཏེ༌བོའེ༌ཕིའ༌ ཉེན༌གྲུང༌ ཉེ༌མོ༌བོའེ༌ ཁོ༌རང༌ངི༌ པ༌བུ༌ པུད༌ཏེ༌ བོ༌འཟ༌ལ༌ ཏངས༌ ཡང༌ ཟེརས༌, “ཉེ༌རང༌ངི༌ ས༌ཀྱད༌པོ༌ ཉོའ༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","ཏེ༌ནེ༌ བོ༌འཟ༌སི༌ ཏེ༌རུ༌ ཡོད༌ཁན༌ འུ༌སྐྱོང༌གུན༌ དང༌ མི༌གུན༌ལ༌ ཟེརས༌, “དི༌རིང༌ ཨེ༌ལི༌མེ༌ལེག༌, ཀི༌ལི༌འོན༌ དང༌ མཧ༌ལོན༌ གུན༌ནི༌ ཨིན༌ཁན༌ ཅི༌ཚང༌མ༌ ནཱའོ༌མིའི༌ ཀ༌ནེ༌ ངའེ༌ ཉོས༌ཁན༌ནི༌ སྤང༌པོ༌ ཁྱོ༌ཞ༌གུན༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","ཤི༌ཁན༌ནི༌ ས༌ཀྱད༌ དང༌ མིར༌གྱུད༌ ལུས༌ཤེས༌ ཡང༌ ཁོའེ༌ ཕྲུ༌གུ༌གུན༌ལ༌ ཁོའེ༌ གྱུ༌ནོར༌ ནོར༌སྐལ༌ལ༌ ཐོབ༌ཅེས༌སི༌ ཕིའ༌ མོ༌འབ༌མ༌ མཧ༌ལོན༌ ཀྲོངས༌ཁན༌ནི༌ ན༌མ༌ རུཐ༌ ཉམ༌པོ༌ ངའེ༌ བག༌སྟོན༌ ཅོད༌། འི༌བོའེ༌ སྤང༌པོ༌ དི༌རིང༌ ཁྱོ༌ཞའ༌ ཚང༌མ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","ཏེ༌ནེ༌ གྱས༌སྒོའེ༌ དུན༌ལ༌ ཡོད༌ཁན༌ནི༌ འུ༌སྐྱོང༌གུན༌ དང༌ མི༌ཚང༌མའེ༌ ལན༌ཏངས༌, “ང༌ཞ༌གུན༌ སྤང༌པོ༌ ཨིན༌། ཡ༌ཝའེ༌ ཉེ༌རང༌ངི༌ ཁང༌པའ༌ ཡོང༌ཁན༌ནི༌ བུ༌མོ༌བོ༌ རེ༌ཅལ༌ དང༌ ལི༌ཡ༌ ཙོགས༌ ཛད༌ཤིག༌, ཁོང༌གུན༌ གྱུད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ མིར༌གྱུད༌ ཚང༌མ༌ ཇུངས༌ཏེ༌ ཨིན༌ནོག༌། ཨེཕ༌ར༌ཐཧ༌ མི༌རིགས༌སི༌ ནང༌ང༌ ཉེ༌རང༌ ཅི༌ས༌ཐོག༌ནེ༌ ཆུག༌པོ༌ གྱུར༌ཏེ༌ བེད༌ལེ༌ཧེམ༌མི༌ ནང༌ང༌ མིང༌ཅན༌ གྱུར༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","ཡང༌ འི༌ ན༌ཆུང༌ གྱུད༌ཏེ༌ ཡ༌ཝའེ༌ ཉེ༌རང༌ང༌ པུར༌གྱུད༌ སལ༌ཁན༌གུན༌, ཏ༌མར༌ལ༌ སྐྱེ༌ཁན༌ ཡ༌ཧུ༌དཱའེ༌ བུ༌ཚ༌ པེ༌རེཟ༌ ཙོགས༌ ཡོང༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","ཏེ༌ནེ༌ བོ༌འཟ༌སི༌ རུཐ༌ ཁོ༌རང༌ངི༌ ཁང༌པའ༌ ཁྱེརས༌ ཡང༌ ཁོ༌ ཁོའེ༌ ན༌མ༌ གྱུར༌། ཁོང༌ ཉིས༌ཀོ༌ ཛོམས༌ཏེ༌ ཡ༌ཝའེ༌ རུཐ༌ སྐྱེ༌ཅེས༌མ༌ཞིག༌ གྱུར༌ཅུག༌ག༌ ཛདས༌ ཡང༌ ཁོའ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","ཏེ༌ནེ༌ གྲོང༌ཁྱེར༌རི༌ བུ༌མོ༌གུན༌ནི༌ ནཱའོ༌མིའ༌ ཟེརས༌, “ཡ༌ཝའ༌ སྟོད༌པ༌། ཁོང༌ངི༌ ཁྱོ༌རང༌ང༌ གྱུད༌ཟིན༌ སྐྱོབ༌ཁན༌ བུ༌ཚ༌ཞིག༌ སལ༌ལ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ཨིས༌ར༌ཨེལ༌ལི༌ ནང༌ང༌ ཁོ༌ མིང༌ཅན༌ གྱུར༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","ཁོའེ༌ ཉེ༌རང༌ངི༌ མི༌ཚེ༌ སོས༌ཏེ༌ རྒད༌པོའེ༌ ཏུས༌ལ༌ ཉེ༌རང༌ང༌ སྟ༌སྟོག༌ ཅོ༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ བུ༌ཚ༌ རྡུན༌ནི༌ སང༌ མང༌ང༌ ཉེ༌རང༌ང༌ ཅེས༌པ༌ ཅོ༌ཁན༌ ཉེ༌རང༌ངི༌ བུ༌ཚའེ༌ ན༌མའ༌ ཏེ༌ བུ༌ཚ༌ ཇོར༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","ཏེ༌ནེ༌ ནཱའོ༌མིའི༌ ཕྲུ༌གུ༌བོ༌ པང༌ང༌ ཁུར༌ཏེ༌ ཁོའ༌ སྟ༌སྟོག༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","ཁྱིམ༌ཚེས༌པའེ༌ བུ༌མོ༌གུན༌ནི༌ ཟེརས༌, “ཏ༌ འི༌ བུ༌ཚ༌ ནཱའོ༌མི༌ ཚ༌འོ༌ ཨིན༌ནོག༌།” ཡང༌ ཁོང༌གུན༌ནི༌ ཏེ༌ ཕྲུ༌གུ༌བོའེ༌ མིང༌ང༌ ཨོ༌བེད༌ ཏགས༌། ཁོང༌ ཡེ༌ཤེའེ༌ ཨ༌བ༌ གྱུར༌ ཡང༌ ཡེ༌ཤེའ༌ དཱ༌བིད༌དི༌ ཨ༌བ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","པེ༌རེཟ༌སི༌ པུར༌གྱུད༌གུན༌ནི༌ ཐོ༌ འི༌བོ༌ ཨིན༌། པེ༌རེཟ༌ ཧེཟ༌རོན༌ ནི༌ ཨ༌བ༌, ");
INSERT INTO lbj_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","ཧེཟ༌རོན༌ རམ༌མི༌ ཨ༌བ༌, རམ༌ ཨམ༌མི༌ན༌དབ༌བི༌ ཨ༌བ༌, ");
INSERT INTO lbj_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","ཨམ༌མི༌ན༌དབ༌ ནཧ༌ཤོན༌ནི༌ ཨ༌བ༌, ནཧ༌ཤོན༌ སལ༌མོན༌ནི༌ ཨ༌བ༌, ");
INSERT INTO lbj_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","སལ༌མོན༌ བོ༌འཟ༌སི༌ ཨ༌བ༌, བོ༌འཟ༌ ཨོ༌བེད༌དི༌ ཨ༌བ༌, ");
INSERT INTO lbj_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","ཨོ༌བེད༌ ཡེ༌ཤེའེ༌ ཨ༌བ༌, ཡེ༌ཤེ༌ དཱ༌བིད༌དི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","1","ཡ༌ཧུ༌དཱ༌པའེ༌ གྱལ༌པོ༌ ཡ༌ཧོའ༌ཀིམ༌མི༌ ཝང༌སྲུལ༌ལི༌ ལོ༌ སུམ༌པའེ༌ ནང༌ང༌ བ༌བེ༌ལོན༌ནི༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ གྱལ༌སའ༌ མག༌མི༌ སྐོར༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_2","028_1_2","DAN","1","2","2","ཡ༌ཝའེ༌ ཡ༌ཧུ༌དཱ༌པའེ༌ གྱལ༌པོ༌ ཡ༌ཧོའ༌ཀིམ༌ དང༌ དཀོན༌མཆོག༌གི༌ ཆོད༌ཁང༌ངི༌ ཅ༌ལག༌ ཁ༌ཅིག༌ ཁོའེ༌ ལག༌ག༌ སྟདས༌ ཡང༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཏེ༌ ཅ༌ལག༌གུན༌ བ༌བེ༌ལོན༌ནི༌ ནང༌ང༌ ཁོ༌རང༌ངི༌ ལྷའེ༌ ཆོད༌ཁང༌ངི༌ བང༌ཛོད༌དི༌ ནང༌ང༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ ལོན༌པོ༌ རྩད༌ཅན༌ ཨཤ༌ཕེ༌ནེས༌ལ༌ ཟེརས༌, “ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ ཕྲོ༌ནེ༌ གྱལ༌གྱུད༌ ཡང༌ ཀྲག༌ཞན༌ ཁ༌ཅིག༌ ཁར༌ལ༌ ཁྱོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","ཁོང༌གུན༌ ཞུ༌ནུ༌, ཟུགས༌སི༌ ཐོག༌ནེ༌ སྐྱོན༌ མེད༌ཁན༌, ངམ༌ཤན༌, ཤེས༌རབས༌ དང༌ རིག༌པ༌ཅན༌, ལོབ༌ཇོང༌ གྱལ༌ལ༌ ལེན༌ཁན༌, གྱོགས༌པ༌ ཧ༌གོ༌ཁན༌, གྱལ༌པོའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌ལ༌ ཇོན༌པོ༌ ཡོང༌གོས༌། ཁོང༌གུན༌ལ༌ བ༌བེ༌ལོན༌པའེ༌ སྤེ༌ཆ༌ སྣ༌ཚོགས༌ སིལ༌ཅེས༌ དང༌ སྐད༌ ལབ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","ཁོང༌གུན༌ནི༌ ཕིའ༌ ཞག༌ཏང༌ ཚད༌ ནང༌ཞིན༌ ཁར༌ཇི༌ དང༌ རྒུན༌ཆང༌ གྱལ༌པོའེ༌ ཁར༌ནེ༌ ཏོང༌ ཡང༌ ལོ༌ སུམ༌ ལོབ༌ཇོང༌ ལེན༌ཏེ༌ སྟིང༌ནེ༌ ཁོང༌གུན༌ནི༌ གྱལ༌པོའ༌ ཞབས༌ཏོག༌ ཞུ༌ཅེས༌ གོ༌ཟུག༌ ཅོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","ཁོང༌གུན༌ནི༌ ཕྲོའ༌ ཡ༌ཧུ༌དཱ༌པ༌ དཱ༌ནི༌ཨེལ༌, ཧ༌ན༌ནཱི༌ཡཱ༌, མི༌ཤཱེལ༌ དང༌ ཨ༌ཟར༌ཡཱ༌ གུན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_7","028_1_7","DAN","1","7","7","གྱལ༌པོའེ༌ ལོན༌པོ༌ རྩད༌ཅན༌ནི༌ ཏེ༌ ཁྱོག༌ཏོང༌གུན༌ནི༌ མིང༌ སྤོས༌ཏེ༌ དཱ༌ནི༌ཨེལ༌ལ༌ བེལ༌ཏེ༌ཤ༌ཟར༌, ཧ༌ན༌ནཱི༌ཡཱ༌ ཤཱད༌རག༌, མི༌ཤཱེལ༌ལ༌ མེ༌ཤཱག༌ དང༌ ཨ༌ཟར༌ཡཱ༌ ཨ༌བེད༌ནི༌གོ༌ ཏགས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_8","028_1_8","DAN","1","8","8","ཨིན༌ནའང༌ དཱ༌ནི༌ཨེལ༌ལི༌ གྱལ༌པོའེ༌ ཟན༌ དང༌ རྒུན༌ཆང༌ ཐུངས༌ཏེ༌ ཁོ༌རང༌ ཚི༌ཏུ༌ མི༌ཅོ༌ཅེས༌ སྟན༌པོ༌ ཐག༌ཅདས༌ ཡང༌ ཏེ༌ ཚི༌ཏུ༌ ཅོ༌ཁན༌ནི༌ ཟན༌ ཡང༌ རྒུན༌ཆང༌ མི༌ཐུང༌ཅེས༌ལ༌ ཁོའ༌ གོངས༌པ༌ སལ༌ ཟེར༌ཏེ༌ ཁོའེ༌ ལོན༌པོ༌ རྩད༌ཅན༌ལ༌ ཞུ༌ཝ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_9","028_1_9","DAN","1","9","9","ཡང༌ དཀོན༌མཆོག༌གི༌ ཏེ༌ ལོན༌པོའ༌ དཱ༌ནི༌ཨེལ༌ལི༌ཀ༌ སྙིང༌རྗེ༌ སྐྱེས༌ཏེ༌ ཆོགས༌སྐྱོར༌ ཅོ༌ཅུག༌ག༌ ཛདས༌, ");
INSERT INTO lbj_vpl VALUES ("DN1_10","028_1_10","DAN","1","10","10","ཨིན༌ནའང༌ ལོན༌པོའེ༌ དཱ༌ནི༌ཨེལ༌ལ༌ ཟེརས༌, “ཁྱོ༌ཞའ༌ འི༌གུན༌ ཟའ༌ དང༌ ཐུང༌ ཅུག༌ཅེས༌ལ༌ ངའ༌ བཀའ༌ ཏང༌ཁན༌ ངའེ༌ གཙོ༌བོ༌ གྱལ༌པོའ༌ ངའ༌ ཇིགས༌ས༌ རག༌, ཅིའ༌ཟེར༌ན༌ གྱལ༌པོའེ༌ ཁྱོ༌ཞའ༌ དང༌ ལོ༌ ཅིག༌པོའེ༌ ཞན༌ ཞུ༌ནུ༌གུན༌ནི༌ སང༌ ཁྱོ༌ཞའ༌ རིད༌པ༌ ཐོང༌ན༌, ཁོང༌ངི༌ ང༌ ཆད༌པ༌ སལ༌ཏེ༌ ངའེ༌ གོ༌ ཅད༌ཅུག༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN1_11","028_1_11","DAN","1","11","11","ཏེ༌ནེ༌ ལོན༌པོ༌ རྩད༌ཅན༌ནི༌ དཱ༌ནི༌ཨེལ༌, ཧ༌ན༌ནཱི༌ཡཱ༌, མི༌ཤཱེལ༌, དང༌ ཨ༌ཟར༌ཡཱ༌ སྲུང༌ང༌ སྐོས༌ཁན༌ནི༌ མི༌བོའ༌ དཱ༌ནི༌ཨེལ༌ལི༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("DN1_12","028_1_12","DAN","1","12","12","“ཞག༌པོ༌ རྕུ༌, ང༌ཞའ༌ ཆུ༌ དང༌ ཚོད༌མ༌ ཟའ༌ལ༌ ཏངས༌ཏེ༌ ལྟའ༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_13","028_1_13","DAN","1","13","13","ཞག༌པོ༌ རྕུའི༌ སྟིང༌ནེ༌ གྱལ༌པོའེ༌ ཁར༌ཇི༌ ཟའ༌ཁན༌ནི༌ ཞུ༌ནུ༌གུན༌ ཉམ༌པོ༌ ང༌ཞའ༌ ལྡུར༌ར༌ ཛད༌, ཏེ༌ནེ༌ ཉེ༌རང༌ང༌ ཐོང༌ཁན༌ ནང༌ཞིན༌ ཐག༌ཅད༌ད༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("DN1_14","028_1_14","DAN","1","14","14","ཁོའེ༌ ཏེ༌བོའ༌ ཁའ༌ཆམས༌ཏེ༌ ཞག༌པོ༌ རྕུ༌ སྟག༌ཅད༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_15","028_1_15","DAN","1","15","15","ཞག༌པོ༌ རྕུའི༌ སྟིང༌ནེ༌ ཁོང༌གུན༌ནི༌ ཟུགས༌པོ༌, གྱལ༌པོའེ༌ ཁར༌ཇི༌ ཟའ༌ཁན༌ནི༌ ཞུ༌ནུ༌གུན༌ནི༌ སང༌ མང༌ང༌ ཁྲངས༌པོ༌ དང༌ ཤེད༌ཅན༌ ཐོང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_16","028_1_16","DAN","1","16","16","ཏེ༌ནེ༌ སྲུང༌ཁན༌ནི༌ མི༌བོའེ༌ ཁོང༌གུན༌ལ༌ གྱལ༌པོའེ༌ ཁར༌ཇི༌ དང༌ རྒུན༌ཆང༌ གུན༌ནི༌ ཚབས༌ལ༌ ཁོང༌གུན༌ལ༌ ཚོད༌མ༌ ཟའ༌ལ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","དཀོན༌མཆོག༌གི༌ ཁོང༌ ཞི༌ཀོའ༌ སྤེ༌ཆ༌ སྣ༌ཚོགས༌ ཚང༌མ༌ སིལ༌ཅེས༌སི༌ ཤེས༌རབས༌ དང༌ རིག༌པ༌ སལ༌ལ༌ ཛདས༌། དཱ༌ནི༌ཨེལ༌ལ༌ ཞལ༌ཟིགས༌ དང༌ ཉི༌ལམ༌ སྣ༌ཚོགས༌ ཚང༌མའེ༌ ཏོན༌ ཧ༌གོ༌ཅེས༌སི༌ ཁྱུད༌ སལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","ཏེ༌ནེ༌ ལོབ༌ཇོང༌ངི༌ ལོ༌ སུམ༌ ཚར༌ར༌ཅིག༌ ལོན༌པོ༌ རྩད༌ཅན༌ནི༌ ཁོང༌ ཚང༌མ༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ དུན༌ལ༌ ཁྱེརས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","19","ཡང༌ གྱལ༌པོའེ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ སྤེ༌ར༌ ཏངས༌། དཱ༌ནི༌ཨེལ༌, ཧ༌ན༌ནཱི༌ཡཱ༌, མི༌ཤཱེལ༌, དང༌ ཨ༌ཟར༌ཡཱ༌ ཞི༌ཀོ༌ ཙོགས༌ ཤེས༌རབས༌ཅན༌ སུའང༌ མ༌བིང༌, ཏེན༌ན༌བོའེ༌ཕིའ༌ ཁོང༌གུན༌ གྱལ༌པོའེ༌ ཞབས༌ཏོག༌གི༌ ལས༌སི༌ ནང༌ང༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_20","028_1_20","DAN","1","20","20","ཤེས༌རབས༌ དང༌ རིག༌པ༌ ཚང༌མའེ༌ སྐོར༌ལ༌ གྱལ༌པོའེ༌ ཏྲི༌ཝ༌ ཏྲི༌ཁན༌ནི༌ ལན༌, གྱལ༌སྲིད༌ གང༌པོའེ༌ མོ༌ ཏབ༌ཁན༌ དང༌ ཤི༌ཁན༌ནི༌ སེམས༌ཉིད༌ བོད༌ཁན༌ ཚང༌མའེ༌ སང༌ ཁོང༌གུན༌ནི༌ རྕུ༌ལྡབ༌ གྱལ༌ལ༌ ཏང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN1_21","028_1_21","DAN","1","21","21","ཡང༌ དཱ༌ནི༌ཨེལ༌ གྱལ༌པོ༌ སཱའི༌རས༌སི༌ ཝང༌སྲུལ༌ལི༌ ལོ༌ ཏང༌པོ༌ ཚག༌པ༌ གྱལ༌པོའེ༌ ལས༌གུན༌ ཅོ༌ཨིན༌ ཏེ༌རུ༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","1","ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཝང༌སྲུལ༌ལི༌ ལོ༌ ཉིས༌པའེ༌ ནང༌ང༌ གྱལ༌པོའ༌ མིན༌དྲ༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌ ཀ༌བོའེ༌ ཁོའེ༌ སེམས༌ལ༌ ནགས༌ སྲན༌ཏྲེ༌ སྟན༌པ༌ ཁོའ༌ ཉིད༌ མ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_2","028_2_2","DAN","2","2","2","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཉི༌ལམ༌ ཐོང༌ཁན༌བོ༌ ཤད༌ཅེས༌ལ༌ ཁོ༌རང༌ངི༌ མོ༌ ཏབ༌ཁན༌, ཤི༌ཁན༌ནི༌ སེམས༌ཉིད༌ བོད༌ཁན༌, སྐར༌མ༌ རྩི༌ཁན༌ དང༌ ཆོས༌ངན༌ ཅོ༌ཁན༌ གུན༌ བོདས༌། ཁོང༌ ཚང༌མ༌ ཡོངས༌ཏེ༌ གྱལ༌པོའེ༌ དུན༌ལ༌ ལངས༌ཏེ༌ དུག༌ག༌ཅིག༌, ");
INSERT INTO lbj_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","3","གྱལ༌པོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ང༌ ངའེ༌ སེམས༌ལ༌ ནགས༌ སྲན༌ཏྲེ༌ སྟན༌ཁན༌ནི༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌, ངའ༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ ཧ༌གོ༌ ཉིན༌ རག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_4","028_2_4","DAN","2","4","4","ཏེ༌ནེ༌ སྐར༌མ༌ རྩི༌ཁན༌གུན༌ནི༌ ཨ༌རམ༌པའེ༌ སྐད༌དི༌ ནང༌ང༌ གྱལ༌པོའ༌ ལན༌ཏངས༌, “གྱལ༌པོ༌ སྐུན༌དུན༌ནི༌ སྐུ༌ཚེ༌ རིང༌ཤིག༌། ཉེ༌རང༌ངི༌ ཞབ༌ཤི༌གུན༌ལ༌ ཉི༌ལམ༌བོ༌ ཤད༌ད༌ ཛད༌ ཏེ༌ནེ༌ ང༌ཞའེ༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ ཤད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_5","028_2_5","DAN","2","5","5","ཨིན༌ནའང༌ གྱལ༌པོའེ༌ ཁོང༌གུན༌ལ༌ ཟེརས༌, “ཀལ༌ཏེས༌ ཁྱོ༌རང༌གུན༌ནི༌ ངའེ༌ ཉི༌ལམ༌ དང༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ མ༌ཤད༌ན༌ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ ཏུམ༌པ༌ ཏུམ༌པའེ༌ ནང༌ང༌ ཅད༌ཏེ༌ ཁྱོ༌ཞའེ༌ ཁང༌པ༌ ཤིགས༌ཏེ༌ མེད༌ཁན༌ ཅོ༌ཅེས༌པོ༌ ངའེ༌ ཐག༌ཅད༌ ཏན༌ཏན༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_6","028_2_6","DAN","2","6","6","ཨིན༌ནའང༌ ཉི༌ལམ༌ དང༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ཁན༌བོའ༌ ངའེ༌ སོལ༌རས༌ དང༌ རྩི༌ཝ༌ ཀྲག༌པོ༌ ཏང༌ཨིན༌། ཏེ༌བོའེ༌ཕིའ༌ ཉི༌ལམ༌ དང༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ ངའ༌ ཤོད༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_7","028_2_7","DAN","2","7","7","ཁོང༌གུན༌ནི༌ ཡང༌སྐྱར༌ ཟེརས༌, “གྱལ༌པོ༌ ཉེ༌རང༌ངི༌ ཞབ༌ཤི༌གུན༌ལ༌ ཉི༌ལམ༌བོ༌ ཤད༌ད༌ ཛད༌ ཏེ༌ནེ༌ ང༌ཞའེ༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ ཤད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_8","028_2_8","DAN","2","8","8","གྱལ༌པོའེ༌ ལན༌ཏངས༌, “ང༌ གྱུས༌ཡོད༌ ཁྱོ༌ཞ༌གུན༌ནི༌ ཏུས༌ ཕུད༌ཨིན༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ ཟེར༌ཁན༌བོ༌ ཏན༌ཏན༌ ཁྱོ༌ཞའ༌ ཉམ༌པོ༌ ཅོ༌ཅེས༌ ཁྱོ༌ཞའ༌ གྱུས༌ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_9","028_2_9","DAN","2","9","9","ཁྱོ༌ཞའེ༌ ཉི༌ལམ༌ མ༌ཤད༌ན༌ ཁྱོ༌ཞའ༌ ཚང༌མ༌ ཆད༌པ༌ ཕོག༌ཅེས༌ ཏན༌ཏན༌ ཨིན༌ནོག༌། ང༌ གོབ༌སྐོར༌ཅེས༌ལ༌ ཁའ༌ ཆམས༌ཏེ༌ ཁྱོ༌ཞའེ༌ ངའེ༌ སམ༌བའེ༌ ནང༌ང༌ གྱུར༌ཇ༌ ཡོང༌ང༌ནོག༌ སམ༌མ༌ རག༌ག༌? ཏ༌ ཉི༌ལམ༌བོ༌ ཤོད༌ ཏེ༌ནེ༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ཁན༌བོའེ༌ཀ༌ ང༌ དེན༌ ཤེས༌ཤེས༌ རག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_10","028_2_10","DAN","2","10","10","ཏེ༌ནེ༌ སྐར༌རྩིས༌ ཏང༌ཁན༌གུན༌ནི༌ གྱལ༌པོའ༌ ལན༌ ཏངས༌, “ཇིག༌རྟེན༌ནི༌ ནང༌ང༌ སུའང༌ ཉེ༌རང༌ངི༌ ཉི༌ལམ༌ ཤད༌ མི༌ ཉན༌། ཀྲག༌པོ༌ ཡ༌ ཝང༌ཅན༌ གྱལ༌པོ༌ སུ༌ཞིག༌གིའང༌ ཁོ༌རང༌ངི༌ མོ༌ ཏབ༌ཁན༌ ཡ༌ ཤི༌ཁན༌ནི༌ སེམས༌ཉིད༌ བོད༌ཁན༌ ཡ༌ སྐར༌རྩིས༌ ཏང༌ཁན༌ གུན༌ལ༌ འི༌ ཙོགས༌སི༌ ཏྲི༌ཝ༌ མ༌ནེ༌ མ༌ ཏྲིའ༌ ཡོད༌གྲོ༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_11","028_2_11","DAN","2","11","11","གྱལ༌པོ༌ ཉེ༌རང༌ངི༌ ཏྲི༌ཝ༌བོ༌ མ༌ ཀགས༌པོ༌ཞིག༌ ཨིན༌ནོག༌། ལྷ༌ལྷ༌མོ༌གུན༌ མན༌པ༌ ཞན༌ སུའང༌ ཏེ༌བོ༌ ཤད༌ མི༌ཐུབ༌ ཨིན༌ནའང༌ ལྷ༌ལྷ༌མོ༌གུན༌ མི༌ ཕྲོའ༌ དུག༌ག༌ མ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_12","028_2_12","DAN","2","12","12","ཏེ༌བོའེ༌ ཞས༌ཏེ༌ གྱལ༌པོའ༌ མ༌ སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌ ཡང༌ ཁོའེ༌ བ༌བེ༌ལོན༌ནི༌ ནང༌ང༌ ཁོང༌གུན༌ ཙོགས༌ ཤེས༌རབ༌ཅན༌ མི༌ ཚང༌མ༌ སད༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_13","028_2_13","DAN","2","13","13","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ བཀའ༌ ནང༌ཞིན༌ ཤེས༌རབ༌ཅན༌ མི༌ ཚང༌མ༌ སད༌ཅེས༌སི༌ བཀའ༌རྒྱ༌ སྤེལས༌ ཡང༌ མག༌མི༌གུན༌ནི༌ དཱ༌ནི༌ཨེལ༌ དང༌ ཁོའེ༌ ཛ༌འོ༌གུན༌ སད༌ཅེས༌ལ༌ ཙལས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","14","གྱལ༌པོ༌ སྲུང༌ཁན༌ནི༌ མག༌མི༌ འུ༌སྐྱོང༌ ཨ༌རི༌འོཅ༌ ཁོང༌གུན༌ སད༌ད༌ ཡོང༌ང༌ཅིག༌ དཱ༌ནི༌ཨེལ༌ལི༌ མ༌ ཤེས༌རབས༌ དང༌ རིག༌པ༌ ཉམ༌པོ༌ ཁོའ༌ ཏྲིས༌, ");
INSERT INTO lbj_vpl VALUES ("DN2_15","028_2_15","DAN","2","15","15","“གྱལ༌པོའེ༌ འི༌ཙོགས༌ སྙིང༌རྗེ༌ མེད༌ཁན༌ནི༌ བཀའ༌ ཅིའ༌ སལ༌ཏེ༌ ཨིན༌ནོག༌?” ཏེ༌ནེ༌ ཨ༌རི༌འོཅ༌ཅི༌ ཁོའ༌ ཏེ༌བོའེ༌ སྐོར༌ ཞིབ༌སལ༌ ཅོས༌ཏེ༌ ཤདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_16","028_2_16","DAN","2","16","16","ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ དཱ༌ནི༌ཨེལ༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁོའེ༌ ཉི༌ལམ༌མི༌ ཏོན༌བོ༌ ཤད༌ཅེས༌ལ༌ ཁོའ༌ ཏུས༌ སལ༌ ཞུས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_17","028_2_17","DAN","2","17","17","ཏེ༌ནེ༌ དཱ༌ནི༌ཨེལ༌ ལོགས༌ཏེ༌ ཁང༌པ༌ སོང༌ ཡང༌ ཁོ༌རང༌ངི༌ ཛ༌འོ༌ ཧ༌ན༌ནཱི༌ཡཱ༌, མི༌ཤཱེལ༌ དང༌ ཨ༌ཟར༌ཡཱ༌ གུན༌ལ༌ ཏེ༌ ཚང༌མ༌ ཤདས༌ ");
INSERT INTO lbj_vpl VALUES ("DN2_18","028_2_18","DAN","2","18","18","ཡང༌ བ༌བེ༌ལོན༌པ༌ ཤེས༌རབས༌ཅན༌ མི༌གུན༌ ཐེས༌ཏེ༌ ཁོང༌ ཚང༌མ༌ མི༌སད༌ཅེས༌ལ༌ ནམ༌ཁའེ༌ དཀོན༌མཆོག༌ག༌ ཁོང༌གུན༌ལ༌ སྙིང༌རྗེ༌ ཛད༌ཏེ༌ ཏེ༌ སང༌ཝའེ༌ ཉི༌ལམ༌ དང༌ ཏེ༌བོའེ༌ ཏོན༌ སྔོན༌ཅུག༌ག༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུས༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_19","028_2_19","DAN","2","19","19","ཚན༌ལ༌ ཞལ༌ཟིགས༌སི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ དཱ༌ནི༌ཨེལ༌ལ༌ ཉི༌ལམ༌ དང༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ སྔོན༌ཅུག༌ག༌ ཛདས༌ ཡང༌ ཁོའེ༌ ནམ༌ཁའེ༌ དཀོན༌མཆོག༌ག༌ སྟོད༌པ༌ ཕུལ༌ཏེ༌ ཟེརས༌, ");
INSERT INTO lbj_vpl VALUES ("DN2_20","028_2_20","DAN","2","20","20","“དཀོན༌མཆོག༌གི༌ ཚན༌ལ༌ ཏུས༌གྱུན༌ནེ༌གྱུན༌ སྟོད༌པ༌ ཕུལ༌, ཤེས༌རབས༌ དང༌ ཁྱུད༌ ཁོང༌ངི༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_21","028_2_21","DAN","2","21","21","ཁོང༌ང༌ ནམ༌ལ༌ དང༌ ཏུས༌ གྱུར༌ ཐུབ༌བ༌ནོག༌། གྱལ༌པོ༌གུན༌ སྟག༌ཅེས༌ དང༌ ཕབ༌ཅེས༌ ཁོང༌ངི༌ ཛད༌ད༌ནོག༌། ཁོང༌ངི༌ མི༌ ཁས༌པ༌གུན༌ལ༌ ཤེས༌རབས༌, དང༌ ཧ༌གོའ༌ ཐད༌ཁན༌གུན༌ལ༌ རིག༌པ༌ སལ༌ལ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_22","028_2_22","DAN","2","22","22","ཁོང༌ངི༌ ཏིང༌ཅན༌ སྦས༌ཏེ༌ བོར༌ཁན༌གུན༌ སྔོན༌ཅུག༌ག༌ ཛད༌ད༌ནོག༌། མུན༌གྲིག༌གི༌ ནང༌ང༌ ཡོད༌ཁན༌གུན༌ ཁོང༌ངི༌ ཁྱེན༌ན༌ ཛད༌ད༌ནོག༌ ཅིའ༌ཞུ༌ན༌ ཁོང༌ངི༌ ནང༌ང༌ འོད༌ ནས༌ཏེ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_23","028_2_23","DAN","2","23","23","ངའེ༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ དཀོན༌མཆོག༌ལེ༌ ཉེ༌རང༌ང༌ ངའེ༌ སྟོད༌པ༌ ཕུལ༌ཏེ༌ ཐུག༌རྗེ༌ཆེ༌ ཞུའད༌། ཉེ༌རང༌ངི༌ ང༌ ཤེས༌རབས༌ དང༌ སྟོབས༌ སལ༌ལ༌ ཛདས༌། ང༌ཞའེ༌ ཏྲིའ༌ ཛད༌ཁན༌བོ༌ ཉེ༌རང༌ངི༌ ངའ༌ སྔོན༌ཅུག༌ག༌ ཛདས༌། ཉེ༌རང༌ངི༌ གྱལ༌པོའེ༌ ཉི༌ལམ༌བོ༌ ང༌ཞའ༌ ཤད༌ད༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_24","028_2_24","DAN","2","24","24","ཏེ༌ནེ༌ དཱ༌ནི༌ཨེལ༌, བ༌བེ༌ལོན༌པ༌ ཤེས༌རབས༌ཅན༌ མི༌གུན༌ སད༌ཅེས༌ལ༌ གྱལ༌པོའེ༌ སྐོས༌ཁན༌ ཨ༌རི༌འོཅ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “བ༌བེ༌ལོན༌པ༌ ཤེས༌རབས༌ཅན༌ མི༌གུན༌ སད༌ད༌ མ༌ཛད༌, ང༌ གྱལ༌པོ༌ ཡོད༌ས༌ ཁྱེར༌ ཡང༌ ངའེ༌ ཁོང༌ངི༌ ཉི༌ལམ༌མི༌ ཏོན༌བོ༌ ཤད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","25","ཨ༌རི༌འོཅ༌ཅི༌ ཁོ༌ ཏེན༌ན༌མལ༌ལ༌ གྱལ༌པོ༌ ཡོད༌ས༌ ཁྱེརས༌ ཡང༌ ཟེརས༌, “ཡ༌ཧུ༌དཱ༌པ༌ ཟུམས༌ཏེ༌ ཁྱོང༌ཁན༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ངའ༌ ཉེ༌རང༌ངི༌ ཉི༌ལམ༌མི༌ ཏོན༌ ཤད༌ ཉན༌ཁན༌ མི༌ཞིག༌ ཐོབ༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_26","028_2_26","DAN","2","26","26","གྱལ༌པོའེ༌ བེལ༌ཏེ༌ཤ༌ཟར༌ ཟེར༌ཁན༌ དཱ༌ནི༌ཨེལ༌ལ༌ ཏྲིས༌, “ཁྱོ༌རང༌ང༌ ངའ༌ ཐོང༌ཁན༌ནི༌ ཉི༌ལམ༌བོ༌ ཤད༌ཏེ༌ ཏེ༌བོའེ༌ ཏོན༌ གྱུར༌ ཉན༌ཅེས༌ རག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("DN2_27","028_2_27","DAN","2","27","27","དཱ༌ནི༌ཨེལ༌ལི༌ ལན༌ ཏངས༌, “ཤེས༌རབ༌ཅན༌ མི༌ ཡ༌ ཆོས༌ངན༌ ཅོ༌ཁན༌ ཡ༌ སྐར༌མ༌ རྩི༌ཁན༌ ཡ༌ ཤི༌ཁན༌ནི༌ སེམས༌ཉིད༌ བོད༌ཁན༌ སུ༌ཞིག༌གའང༌ གྱལ༌པོའེ༌ ཉི༌ལམ༌མི༌ སང༌ཝ༌བོ༌ ཤད༌ མི༌ཉན༌, ");
INSERT INTO lbj_vpl VALUES ("DN2_28","028_2_28","DAN","2","28","28","ཨིན༌ནའང༌ ནམ༌ཁའེ༌ ནང༌ང༌ ཞུགས༌ཁན༌ དཀོན༌མཆོག༌གི༌ སང༌ཝ༌བོ༌ ཤད༌ ཐུབ༌བ༌ནོག༌། ཁོང༌ངི༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ལ༌ ཡོང༌ཅེས༌ཅན༌ནི༌ ཏུས༌སི༌ སྐོར༌ལ༌ ཤད༌ད༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ཉེ༌རང༌ ཉིད༌ལོགས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཐོང༌ཁན༌ནི༌ ཉི༌ལམ༌བོ༌ ནི༌:” ");
INSERT INTO lbj_vpl VALUES ("DN2_29","028_2_29","DAN","2","29","29","“ཉེ༌རང༌ ཉིད༌ལོགས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ཉེ༌རང༌ངི༌ སམ༌བ༌ ཡོང༌ཅེས༌ཅན༌ནི༌ ཏུས༌སི༌ ཆོགས༌ལ༌ སོང༌ཏེ༌ སང༌ཝ༌ སྔོན༌ཅུག༌ག༌ ཛད༌ཁན༌ དཀོན༌མཆོག༌གི༌ ཉེ༌རང༌ང༌ ཇུང༌ཅེས༌ཅན༌གུན༌ སྟན༌ན༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_30","028_2_30","DAN","2","30","30","ཞན༌ ཚང༌མའེ༌ སང༌ ཤེས༌རབས༌ཅན༌ ཨིན༌ཅེས༌པོའེ༌ ང༌ འི༌ སང༌ཝའེ༌ ཉི༌ལམ༌མི༌ ཏོན༌ ཤེས༌ཏེ༌ མ༌ནོག༌ ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ ཉེ༌རང༌ང༌ འི༌ ཉི༌ལམ༌ ཐོང༌ཁན༌ནི༌ ཏོན༌ དང༌ ཏེ༌བོའེ༌ སྐོར༌ལ༌ ཉེ༌རང༌ངི༌ སམ༌ཁན༌བོ༌ ཧ༌གོ༌ཅུག༌ག༌ ཛད༌ཅེས༌པོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_31","028_2_31","DAN","2","31","31","“ཉི༌ལམ༌མི༌ ནང༌ང༌ གྱལ༌པོ༌ ཉེ༌རང༌, མ༌ ཆེན༌མོ༌, ལྡང༌ཤན༌, མ༌ ཧ༌ལས༌ཤེས༌ དང༌ ཇིགས༌ནང༌ཅན༌ནི༌ སྐུན༌དྲ༌ ཞིག༌གི༌ དུན༌ལ༌ ལངས༌ཏེ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_32","028_2_32","DAN","2","32","32","ཏེ༌ སྐུན༌དྲའེ༌ གོ༌ ཅའང༌ མ༌དྲེས༌ཁན༌ སེར༌རི༌ དྲང༌ དང༌ ལག༌པ༌གུན༌ མུལ༌ལི༌, ཀྲོད༌པ༌ དང༌ རྐང༌པའེ༌ ཤལ༌དིག༌ ཟངས༌སི༌, ");
INSERT INTO lbj_vpl VALUES ("DN2_33","028_2_33","DAN","2","33","33","རྐང༌གུན༌ ལྕགས༌སི༌ ཡང༌ རྐང༌པ༌ ཉིས༌ཀོ༌ ལྕགས༌ དང༌ མར༌ཀ༌ལག༌ དྲེས༌ཁན༌ནི༌ ཅོས༌ཏེ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_34","028_2_34","DAN","2","34","34","ཉེ༌རང༌ངི༌ ཟིགས༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ མི༌ ལག༌པ༌ནེ༌ མ༌ཅད༌ཁན༌ ཕོ༌ལོངས༌ བུད༌ཏེ༌ མར༌ཀ༌ལག༌ དང༌ ལྕགས༌ལ༌ ཅོ༌ཁན༌ནི༌ སྐུན༌དྲའེ༌ རྐང༌པ༌ ཕོག༌ཏེ༌ ཏེ༌གུན༌ ཁྲེས༌ཏོར༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_35","028_2_35","DAN","2","35","35","ཏེ༌ནེ༌ སྐུན༌དྲའ༌ གང༌པོ༌ གྱེལ༌ཏེ༌ སེར༌, མུལ༌ དང༌ ལྕགས༌ ཚང༌མ༌ ཁྲེས༌ཏོར༌ སོང༌ ཡང༌ ཡར༌རི༌ ཏུས༌ལ༌ ཡུལ༌ཐག༌ག༌ ཡོད༌ཁན༌ནི༌ ཕུག༌མ༌ ཙོགས༌ལ༌ ལུངས༌པོའེ༌ ཐག༌རིང༌ང༌ ཁྱེར༌ཏེ༌ ཏེ༌བོ༌ ཡོད༌ཁན༌ནི༌ མལ༌ལའང༌ མ༌ལུས༌ ཨིན༌ནའང༌ སྐུན༌དྲའ༌ ཕོག༌ཁན༌ནི༌ རྡོའ༌བོ༌ རི༌ ཆེན༌མོ༌ཞིག༌ གྱུར༌ཏེ༌ ཇིག༌རྟེན༌ གང༌པོ༌ གང༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_36","028_2_36","DAN","2","36","36","“ཏེ༌བོ༌ ཉེ༌རང༌ངི༌ ཉི༌ལམ༌བོ༌ ཨིན༌པིན༌, ཏ༌ ངའེ༌ གྱལ༌པོའ༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ ཤད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_37","028_2_37","DAN","2","37","37","གྱལ༌པོ༌ལེ༌, ཉེ༌རང༌ ཚང༌མའེ༌ སང༌ ཀྲག༌པོ༌ གྱལ༌པོ༌, ནམ༌ཁའེ༌ དཀོན༌མཆོག༌གི༌ ཉེ༌རང༌ང༌ གྱལ༌སྲིད༌, ཁྱུད༌, ཝང༌ དང༌ རྩི༌ཝ༌ སལ༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_38","028_2_38","DAN","2","38","38","ཁོང༌ངི༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ མི༌, ནམ༌ཁའེ༌ ཅ༌ དང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ ཚང༌མ༌ ཉེ༌རང༌ངི༌ ཆག༌ག༌ སལ༌ལ༌ ཛད༌ཏེ༌ ཉེ༌རང༌ ཏེ༌ ཚང༌མའེ༌ཀ༌ ཝང༌ སྲུལ༌ཁན༌བོ༌ ཛདས༌། ཉེ༌རང༌ སེར༌རི༌ གོ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_39","028_2_39","DAN","2","39","39","“ཨིན༌ནའང༌ ཉེ༌རང༌ངི༌ སྟིང༌ནེ༌ ཉེ༌རང༌ངི༌ སང༌ འུ༌ཐུག༌ ཡོད༌ཁན༌ གྱལ༌སྲིད༌ ཞག༌གི༌ ཉེ༌རང༌ངི༌ ནས༌ས༌ ལེན༌ཨིན༌། ཏེ༌ སྟིང༌ནེ༌ ཟངས༌སི༌ ཨིན༌ཁན༌ གྱལ༌སྲིད༌ སུམ༌པའེ༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ཀ༌ ཝང༌ སྲུལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_40","028_2_40","DAN","2","40","40","སྟིང༌ཇུག༌པོའེ༌ཀ༌ ལྕགས༌ ཙོགས༌ སྲན༌ཏྲེ༌ ཡོད༌ཁན༌ གྱལ༌སྲིད༌ ཞི༌པ༌ བིང༌ཨིན༌། ལྕགས༌སི༌ ཞན༌ ཅ༌ལག༌གུན༌ ཁྲེས༌ཏོར༌ ཅོའ༌ ཙོགས༌ལ༌ ཏེ༌ གྱལ༌སྲིད༌པོའེ༌ ཞན༌ གྱལ༌སྲིད༌ ཚང༌མ༌ ཅགས༌ཏེ༌ ཁྲེས༌ཏོར༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_41","028_2_41","DAN","2","41","41","ཉེ༌རང༌ངི༌ ཐོང༌ཁན༌ མར༌ཀ༌ལག༌ དང༌ ལྕགས༌ དྲེས༌ཁན༌ནི༌ རྐང༌པ༌གུན༌ ཙོགས༌ལ༌ ཏེ༌ གྱལ༌སྲིད༌པོའ༌ པོ༌བུད༌ཏེ༌ ཅིག༌གྲིལ༌ མེད༌ཁན༌ ཆེན༌ ཨིན༌ནའང༌ མར༌ཀ༌ལག༌ དང༌ ལྕགས༌ དྲེས༌ཁན༌ ཙོགས༌ལ༌ ཏེ༌གུན༌ནི༌ ནང༌ང༌ ལྕགས༌ ཙོགས༌ ཤེད༌ ཙ༌པིག༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_42","028_2_42","DAN","2","42","42","ལྕགས༌ དང༌ མར༌ཀ༌ལག༌ དྲེས༌ཁན༌ ཀང༌པ༌ ཙོགས༌ལ༌ ཏེ༌ གྱལ༌སྲིད༌དི༌ ཁག༌ ཁ༌ཅིག༌ ཤེད༌ཅན༌ ཡང༌ ཁག༌ ཁ༌ཅིག༌ ཆག༌ ཆོག༌ཆོག༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_43","028_2_43","DAN","2","43","43","ལྕགས༌ དང༌ མར༌ཀ༌ལག༌ དྲེས༌ཁན༌ ཙོགས༌ལ༌ ཏེ༌ གྱལ༌སྲིད༌དི༌ ནང༌ང༌ མི༌ སྣ༌ཙོགས༌ དྲེས༌ཏེ༌ ཅིག༌གྲིལ༌ མི༌ ལུས༌ ཀ༌ཟུག༌ ལྕགས༌ དང༌ མར༌ཀ༌ལག༌ གྱལ༌ལ༌ དྲེས༌ས༌ མ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_44","028_2_44","DAN","2","44","44","“ཏེ༌ གྱལ༌པོ༌གུན༌ནི༌ ཝང༌སྲུལ༌ལི༌ ཏུས༌ལ༌ ནམ༌ཁའེ༌ དཀོན༌མཆོག༌གི༌, མ༌ནེ༌ ཤིག༌ མི༌ ཉན༌ཅེས༌ ཡ༌ སུའང༌ ང༌ཡོག༌ག༌ ཁྱོང༌ མི༌ཉན༌ཁན༌ གྱལ༌སྲིད༌ཞིག༌ ཙུག༌ག༌ ཛད༌ཨིན༌། ཏེ༌ གྱལ༌སྲིད༌དི༌ ཞན༌ གྱལ༌སྲིད༌གུན༌ མེད༌ཁན༌ ཅོས༌ཏེ༌ ཁོང༌རང༌ངི༌ གྱལ༌སྲིད༌པོ༌ ཏུས༌གྱུན༌ནི༌ཕིའ༌ ཙུག༌ག༌ ཛད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_45","028_2_45","DAN","2","45","45","མི༌ ལག༌པ༌ ཉམ༌པོ༌ མ༌ ཅག༌ཁན༌ རིའི༌ རྡོའ༌ བུད༌ཁན༌བོའེ༌ ལྕགས༌, མར༌ཀ༌ལག༌, ཟངས༌, མུལ༌ དང༌ སེར༌ གུན༌ ཁྲེས༌ཏོར༌ ཅོ༌ཁན༌ནི༌ ཏོན༌བོ༌ ཏེ༌བོ༌ ཨིན༌ནོག༌།” “ཀྲག༌པོ༌ དཀོན༌མཆོག༌གི༌ གྱལ༌པོ༌ ཉེ༌རང༌ང༌, མ༌ཡོངས༌པའེ༌ ཏུས༌སི༌ ནང༌ང༌ ཇུང༌ཅེས༌པོ༌ སྟན༌ན༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། འི༌བོ༌ ཏན༌ཏན༌ལ༌ ཉེ༌རང༌ངི༌ ཉི༌ལམ༌ ཡང༌ ཏེ༌བོའེ༌ ཏོན༌ ཨིད༌ཤེས༌ ཐུབ༌བ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN2_46","028_2_46","DAN","2","46","46","ཏེ༌ནེ༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ དཱ༌ནི༌ཨེལ༌ལི༌ དུན༌ལ༌ གྱེལ༌ཏེ༌ ཁོའ༌ རྩི༌ཝ༌ སྟནས༌ ཡང༌ ཁོའེ༌ ཕིའ༌ ཆོད༌པ༌ དང༌ སྤོས༌ ཁྱོང༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_47","028_2_47","DAN","2","47","47","གྱལ༌པོའེ༌ དཱ༌ནི༌ཨེལ༌ལ༌ ཟེརས༌, “ཏན༌ཏན༌ ཁྱོ༌རང༌ངི༌ དཀོན༌མཆོག༌ ནི༌, ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ དཀོན༌མཆོག༌ ཡང༌ གྱལ༌པོ༌གུན༌ནི༌ གཙོ༌བོ༌ དང༌ སང༌ཝའེ༌ ནང༌ང༌ ཇུང༌ཅེས༌གུན༌ སྔོན༌ཅུག༌ག༌ ཛད༌ཁན༌ ཞུགས༌ཏེ༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ང༌ འི༌ སང༌ཝ༌བོ༌ ཤད༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_48","028_2_48","DAN","2","48","48","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ དཱ༌ནི༌ཨེལ༌ ཁར༌རི༌ ནང༌ང༌ ཀོ༌ས༌ ཐོན༌པོའེ༌ཀ༌ སྐོས༌ ཡང༌ ཁོའ༌ སོལ༌རས༌ མང༌པོ༌ ཏངས༌། གྱལ༌པོའེ༌ ཁོ༌ བ༌བེ༌ལོན༌ནི༌ ཡུལ༌ཇོངས༌ གང༌པོའེ༌ཀ༌ ཝང༌ སྲུལ༌པ༌ ཅོས༌ ཡང༌ ཁོ༌ ཤེས༌རབ༌ཅན༌ མི༌ ཚང༌མའེ༌ཀ༌ གོ༌སྐྱོང༌ང༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN2_49","028_2_49","DAN","2","49","49","ཏེ༌བོ༌ མན༌པ༌ དཱ༌ནི༌ཨེལ༌ལི༌ ཞུ༌ཝ༌ ནང༌ཞིན༌ གྱལ༌པོའེ༌ ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌ གུན༌ བ༌བེ༌ལོན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ཝང༌སྲུལ༌པ༌ ཅོས༌ ཨིན༌ནའང༌ དཱ༌ནི༌ཨེལ༌ ཁར༌རི༌ ནང༌ང༌ དུགས༌ཏེ༌ གྱལ༌པོའེ༌ ཕིའ༌ ལས༌ ཅོའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","1","གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ སེར༌རི༌ སྐུན༌དྲ༌ མི༌ཀྲར༌ 27 ཐོན༌པོ༌ ཡང༌ མི༌ཀྲར༌ 3 ཟམ༌ཤིག༌ ཞང༌ཅན༌ ཞང༌ཅུགས༌ཏེ༌ བ༌བེ༌ལོན༌ ཡུལ༌ཇོངས༌སི༌ དུ༌རའེ༌ ཐང༌ངི༌ཀ༌ ལངས༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_2","028_3_2","DAN","3","2","2","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཀོ༌ས༌ ཐོན༌པོའེ༌ ཀའ༌ལོན༌གུན༌, ཞན༌ སྤོན༌བོ༌གུན༌, ལོན༌པོ༌གུན༌, ཁ༌དའ༌ ཏང༌ཁན༌གུན༌, བང༌ཛོད༌དི༌ ལོན༌པོ༌གུན༌, ཁྲིམ༌སྤོན༌ རྩད༌ཅན༌གུན༌ དང༌ ཞན༌ ཁྲིམ༌སྤོན༌གུན༌, ཡུལ༌ཇོངས༌གུན༌ནི༌ འུ༌སྐྱོང༌ ཚང༌མ༌, ཏེ༌ སྐུན༌དྲའ༌ ཅོལ༌ཅེས༌ གོ༌ཟུག༌ ཅོ༌ཅེས༌སི༌ གའ༌སྟོན༌ རྩི༌ཅེས༌ལ༌ བོདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_3","028_3_3","DAN","3","3","3","ཏེ༌བོའེ༌ཕིའ༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཞང༌ཅུག༌ཁན༌ནི༌ སྐུན༌དྲའ༌ ཅོལ༌ཅེས༌སི༌ གའ༌སྟོན༌ རྩིའ༌ལ༌ ཝང༌སྲུལ༌པ༌ ཚང༌མ༌ ཛོམས༌ ཡང༌ ཏེ༌བོའེ༌ དུན༌ལ༌ ལངས༌ཏེ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_4","028_3_4","DAN","3","4","4","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཁྱབ༌གྲགས༌ ཅོ༌ཁན༌བོའེ༌ སྐད༌ ཆེན༌མོའེ༌ ནང༌ང༌ ཟེརས༌, “གྱལ༌ཁམས༌, སྐད༌ དང༌ མི༌ ཚང༌མ༌, གྱལ༌པོའེ༌ བཀའ༌ སལ༌དུག༌, ");
INSERT INTO lbj_vpl VALUES ("DN3_5","028_3_5","DAN","3","5","5","ཏུང༌, ལིང༌བུ༌, སུར༌ན༌, ཏར༌ཅན༌ནི༌ རོལ༌མོ༌, ཧརྦ༌ དང༌ ཞན༌ རོལ༌མོ༌ གུན༌ ཕུའ༌ ཚོར༌ར༌ཅིག༌ ཁྱོ༌ཞ༌གུན༌ སའེ༌ཀ༌ གྱེལ༌ཏེ༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཞང༌ཅུག༌ཁན༌ སེར༌རི༌ སྐུན༌དྲ༌ ཆག༌ཕུལ༌ གོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_6","028_3_6","DAN","3","6","6","ཆག༌ མ༌ ཕུལ༌ཁན༌གུན༌ ཏེན༌ན༌མལ༌ལ༌ མེ༌ ཀྲག༌པོ༌ བར༌ཨིན༌ ཡོད༌ཁན༌ནི༌ དོང༌ངི༌ ནང༌ང༌ ཕང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN3_7","028_3_7","DAN","3","7","7","ཏེ༌ནེ༌ ཏུང༌, ལིང༌བུ༌, སུར༌ན༌, ཏར༌ཅན༌ནི༌ རོལ༌མོ༌, ཧརྦ༌ དང༌ ཞན༌ རོལ༌མོ༌ གུན༌ནི༌ སྐད༌ ཚོར༌ར༌ཅིག༌ གྱལ༌ཁམས༌, སྐད༌ དང༌ མི༌ ཚང༌མ༌ སའེ༌ཀ༌ གྱེལ༌ཏེ༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཞང༌ཅུག༌ཁན༌ སེར༌རི༌ སྐུན༌དྲ༌ ཆག༌ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","8","ཨིན༌ནའང༌ སྐར༌རྩིས༌ ཏང༌ཁན༌ ཁ༌ཅིག༌ གྱལ༌པོའེ༌ཀ༌ སོང༌ཏེ༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ནི༌ སྐོར༌ལ༌ མ༌བེབས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_9","028_3_9","DAN","3","9","9","ཁོང༌གུན༌ནི༌ གྱལ༌པོའ༌ ཟེརས༌, “གྱལ༌པོའེ༌ སྐུ༌ཚེ༌ རིང༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_10","028_3_10","DAN","3","10","10","ཉེ༌རང༌ངི༌ ཏུང༌, ལིང༌བུ༌, སུར༌ན༌, ཏར༌ཅན༌ནི༌ རོལ༌མོ༌, ཧརྦ༌ དང༌ ཞན༌ རོལ༌མོ༌ གུན༌ནི༌ སྐད༌ ཚོར༌ར༌ཅིག༌ མི༌ཚང༌མ༌ སའེ༌ཀ༌ གྱེལ༌ཏེ༌ ཉེ༌རང༌ངི༌ ཞང༌ཅུག༌ཁན༌ སེར༌རི༌ སྐུན༌དྲ༌ ཆག༌ཕུལ༌ ");
INSERT INTO lbj_vpl VALUES ("DN3_11","028_3_11","DAN","3","11","11","ཡང༌ ཆག༌ མ༌ ཕུལ༌ཁན༌གུན༌ མེ༌ ཀྲག༌པོ༌ བར༌ཨིན༌ ཡོད༌ཁན༌ནི༌ དོང༌ངི༌ ནང༌ང༌ ཕང༌ཨིན༌ མོལ༌ཏེ༌ བཀའ༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_12","028_3_12","DAN","3","12","12","ཨིན༌ནའང༌ ཉེ༌རང༌ངི༌ བ༌བེ༌ལོན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཝང༌སྲུལ༌པ༌ ཛདས༌ཁན༌ ཡ༌ཧུ༌ད༌པ༌ ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌ གུན༌ནི༌ ཉེ༌རང༌ངི༌ མོལ༌ཁན༌བོའ༌ ནང༌སྟག༌ མ༌ཏང༌ང༌, ཉེ༌རང༌ངི༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ ཞབས༌ཏོག༌ མ༌ཞུའ༌ ཡང༌ ཉེ༌རང༌ངི༌ ཞང༌ཅུག༌ཁན༌ སེར༌རི༌ སྐུན༌དྲ༌ ཅོལ༌ཏེ༌ ཆག༌ མ༌ཕུལས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","13","ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ གྱལ༌པོའ༌ མ༌སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌ ཡང༌ ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌ གུན༌ལ༌ བོདས༌ ཡང༌ ཁོང༌གུན༌ ཡོང༌ང༌ཅིག༌ ");
INSERT INTO lbj_vpl VALUES ("DN3_14","028_3_14","DAN","3","14","14","གྱལ༌པོའེ༌ ཁོང༌གུན༌ལ༌ ཏྲིས༌, “ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌, ཁྱོ༌ཞའེ༌ ངའེ༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ ཞབས༌ཏོག༌ མ༌ཞུའ༌ ཡང༌ ངའེ༌ ཞང༌ཅུག༌ཁན༌ སེར༌རི༌ སྐུན༌དྲའ༌ ཆག༌ མ༌ཕུལ༌ཁན༌བོ༌ ཀྲང༌པོ༌ ཨིན༌ནོག༌ག༌? ");
INSERT INTO lbj_vpl VALUES ("DN3_15","028_3_15","DAN","3","15","15","ངའེ༌ ཁྱོ༌ཞའ༌ སྐབས༌ ཅིག༌ ཏང༌ཨིན༌ ཏུང༌, ལིང༌བུ༌, སུར༌ན༌, ཏར༌ཅན༌ནི༌ རོལ༌མོ༌, ཧརྦ༌ དང༌ ཞན༌ རོལ༌མོ༌ གུན༌ནི༌ སྐད༌ ཚོར༌ར༌ཅིག༌, སྐུན༌དྲའ༌ ཆག༌ཕུལ༌ཏེ༌ ཅོལ༌ན༌ གྱལ༌ལ༌ ཆེན༌, མ༌ ཅོལ༌ན༌ ངའེ༌ ཁྱོ༌ཞའ༌ ཏེན༌ན༌མལ༌ལ༌ མེ༌ ཀྲག༌པོ༌ བར༌ཨིན༌ ཡོད༌ཁན༌ནི༌ དོང༌ངི༌ ནང༌ང༌ ཕང༌ ཅུག༌ཨིན༌། ཏེ༌ནེ༌ ཁྱོ༌ཞའ༌ ངའེ༌ ལག༌ནེ༌ ཀ༌ ལྷ༌ལྷ༌མོ༌བོ༌ སྐྱོབ༌ ཐུབ༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("DN3_16","028_3_16","DAN","3","16","16","ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌ གུན༌ནི༌ ལན༌ ཏངས༌, “ཀྱེ༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ ལེ༌, ང༌ཞའེ༌ ང༌ཞ༌རང༌ སྐྱོན༌མེད༌ སྟན༌ཅེས༌སི༌ རྩོན༌གྲུས༌ མི༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","ཀལ༌ཏེས༌ ང༌ཞའ༌ མེ༌ ནང༌ང༌ ཕང༌ང༌ ཛད༌ན༌, ང༌ཞའེ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ནི༌ དཀོན༌མཆོག༌གི༌ ང༌ཞའ༌ སྐྱོབ༌ ཐུབ༌ཨིན༌། ཁོང༌ངི༌ ང༌ཞའ༌ ཉེ༌རང༌ངི༌ ལག༌པ༌ནེ༌ སྐྱོབ༌བ༌ ཛད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_18","028_3_18","DAN","3","18","18","ཁོང༌ངི༌ སྐྱོབ༌བ༌ མ༌ཛད༌ནའང༌ ཉེ༌རང༌ང༌ འི༌བོ༌ གྱུས༌ ཆ༌གོས༌, ང༌ཞའེ༌ ཉེ༌རང༌ངི༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ ཞབས༌ཏོག༌ ཡ༌ ཉེ༌རང༌ངི༌ ཞང༌ཅུག༌ཁན༌ སེར༌རི༌ སྐུན༌དྲའ༌ མན༌ནེ༌ ཆག༌ མི༌ཕུལ༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","19","ཏེ༌ནེ༌ གྱལ༌པོའ༌ ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌ གུན༌ནི༌ཀ༌ མ༌སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌ ཡང༌ ཁོང༌གུན༌ནི༌ ཆོགས༌ལ༌ ཁོའེ༌ སེམས༌ གྱུར༌ཏེ༌ མེ༌བོ༌ རྡུན༌ ལྡབ༌ ཚན༌ཏེ༌ ཅོ༌ཅེས༌ལ༌ ཟེརས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","20","གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ ཚང༌མའེ༌ སང༌ ཤེད༌ཅན༌ མག༌མི༌ ཁ༌ཅིག༌ག༌ ཁོང༌གུན༌ ལྡམས༌ཏེ༌ ཏེ༌ ནང༌ང༌ ཕང༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_21","028_3_21","DAN","3","21","21","ཏེ༌ནེ༌ མག༌མི༌གུན༌ནི༌ ཀོས༌, ཀང༌ཙེ༌, ཏི༌བི༌ དང༌ ཞན༌ ཀོས༌ལག༌ གུན༌ གོན༌གོན༌པ༌ ཁོང༌གུན༌ ལྡམས༌ཏེ༌ མེ༌ ནང༌ང༌ ཕངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_22","028_3_22","DAN","3","22","22","གྱལ༌པོའ༌ མ༌ སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌ཏེ༌ མེ༌བོ༌ ཏེ༌ཟམ༌ ཚན༌ཏེ༌ ཅོ༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌ པ༌སང༌ ཁོང༌གུན༌ མེ༌ ནང༌ང༌ ཕང༌ཁན༌ནི༌ མག༌མི༌གུན༌ མེའ༌ ཞེན༌ཏེ༌ ཤི༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_23","028_3_23","DAN","3","23","23","ཏེ༌ མི༌ སུམ༌ཀོ༌ སྟན༌པོ༌ ལྡམས༌ཏེ༌ ཀྲག༌པོ༌ མེ༌ ནང༌ང༌ ཕངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","24","ཏེ༌ནེ༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ ཧེ༌རཱན༌ སོང༌ཏེ༌ ཆོམས༌ ཡང༌ ཁོ༌རང༌ངི༌ ཁ༌དའ༌ ཏང༌ཁན༌གུན༌ལ༌ ཏྲིས༌, “ང༌དང༌ངི༌ མེ༌ ནང༌ང༌ མི༌ སུམ༌ ལྡམས༌ཏེ༌ མ༌ཕངས༌ པིན༌ན༌?” ཁོང༌གུན༌ནི༌ ལན༌ ཏངས༌, “ཏན༌ཏན༌ ཕངས༌པིན༌ ལེ༌།” ");
INSERT INTO lbj_vpl VALUES ("DN3_25","028_3_25","DAN","3","25","25","གྱལ༌པོའེ༌ ཟེརས༌, “ལྟོས༌སའང༌། མེ༌ ནང༌ང༌ མ༌ལྡམ༌ཁན༌ དང༌ མེ༌ མ༌ཚིག༌ཁན༌ མི༌ ཞི༌ གྲུལ༌ལ༌ལ༌ ཡང༌ ཞི༌པ༌བོ༌ ཕོ༌ཉ༌ ཙོགས༌ཤིག༌ དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","26","ཏེ༌ནེ༌ གྱལ༌པོ༌ མེ༌ དོང༌ངི༌ ཁའེ༌ དུན༌ལ༌ སོང༌ཏེ༌ ཟེརས༌, “ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌, དཀོན༌མཆོག༌ ཀུན༌ཝང༌ངི༌ ཞབས༌ཏོག༌པ༌གུན༌ བིང༌ཏེ༌ ཡོང༌།” ཏེ༌ནེ༌ ཁོང༌གུན༌ མེ༌ ནང༌ནེ༌ བིང༌ཏེ༌ ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_27","028_3_27","DAN","3","27","27","ཀོ༌ས༌ ཐོན༌པོའེ༌ ཀའ༌ལོན༌གུན༌, ཞན༌ སྤོན༌བོ༌གུན༌, ལོན༌པོ༌གུན༌, ཁ༌དའ༌ ཏང༌ཁན༌གུན༌, བང༌ཛོད༌དི༌ ལོན༌པོ༌གུན༌, ཁྲིམ༌སྤོན༌ རྩད༌ཅན༌གུན༌, ཁྲིམ༌སྤོན༌གུན༌ དང༌ ཡུལ༌ཇོངས༌གུན༌ནི༌ འུ༌སྐྱོང༌ ཚང༌མ༌ ཁོང༌གུན༌ལ༌ ཁོར༌ཏེ༌ ལྟས༌། མེ༌ ཁོང༌གུན༌ནི༌ ཟུགས༌པོའ༌ ཅའང༌ ནོད༌པ༌ མ༌ཏང༌ང༌ མ༌ཚད༌ སྲའེ༌ སྲལ༌ཉག༌ ཅིག༌ ཡ༌ ཀོས༌ལག༌ མེའ༌ མ༌ཚིག༌ག༌ ཡང༌ ཁོང༌གུན༌ལ༌ ཏུད༌པའེ༌ ཏྲི༌མའང༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_28","028_3_28","DAN","3","28","28","གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཟེརས༌, “ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌ གུན༌ནི༌ དཀོན༌མཆོག༌ག༌ སྟོད༌པ༌ ཕུལ༌། ཁོང༌ངི༌ ཁོང༌རང༌ངི༌ ཕོ༌ཉ༌ ཀལ༌ལ༌ ཛད༌ཏེ༌ ཁོང༌ང༌ ཨིད༌ཤེས༌ ཅོ༌ཁན༌ནི༌ ཁོང༌ངི༌ ཞབས༌ཏོག༌པ༌གུན༌ སྐྱོབ༌བ༌ ཛདས༌། ཁོང༌གུན༌ནི༌ གྱལ༌པོའེ༌ བཀའ༌ ཁའ༌ མ༌ཉན༌ན༌ ཁོ༌རང༌གུན༌ནི༌ དཀོན༌མཆོག༌ མ༌སྟོག༌ ཞན༌ཞིག༌ག༌ ཅོལ༌ལི༌སང༌ ཤི༌ཅེས༌ལ༌ ཐད༌། ");
INSERT INTO lbj_vpl VALUES ("DN3_29","028_3_29","DAN","3","29","29","གྱལ༌ཁམས༌, སྐད༌ དང༌ མི༌ ཚང༌མའེ༌ ཕྲོ༌ནེ༌ ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌ གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ གྱབ༌གལ༌ལ༌ ཟེར༌ཁན༌གུན༌ ཏུམ༌པ༌ ཏུམ༌པའེ༌ ནང༌ང༌ ཅད༌ཏེ༌ ཁོང༌གུན༌ནི༌ ཁང༌པ༌ ཤིགས༌ཏེ༌ མེད༌ཁན༌ ཅོ༌ཅེས༌ལ༌ ངའེ༌ བཀའ༌ ཏང༌ངད༌ ཅིའ༌ཟེར༌ན༌ ཞན༌ ལྷ༌ལྷ༌མོ༌ སུ༌ཞིག༌གའང༌ འི༌ ཙོགས༌ལ༌ སྐྱོབ༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN3_30","028_3_30","DAN","3","30","30","ཏེ༌ནེ༌ གྱལ༌པོའེ༌ བ༌བེ༌ལོན༌ནི༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཤཱད༌རག༌, མེ༌ཤཱག༌ དང༌ ཨ༌བེད༌ནི༌གོ༌ གུན༌ ཀོ༌ས༌ ཆེན༌མོའེ༌ཀ༌ སྟགས༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_1","028_4_1","DAN","4","1","1","གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ གྱལ༌ཁམས༌, སྐད༌ དང༌ མི༌ ཚང༌མ༌ལ༌ འི༌ ལོན༌བོ༌ ཀལས༌, “ཞི༌དེ༌ དང༌ ཡར༌གྱས༌ ཇུང༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_2","028_4_2","DAN","4","2","2","ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ངའ༌ ཧ༌ལས༌ཤེས༌སི༌ ལྟས༌ དང༌ སྟགས༌ སྟན༌ན༌ ཛད༌ཁན༌བོ༌ ཁྱོ༌ཞའ༌ ཤད༌ ཉིན༌རག༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_3","028_4_3","DAN","4","3","3","ཁོང༌ངི༌ སྟགས༌གུན༌ ཀྲག༌པོ༌ ཡང༌ ཁོང༌ངི༌ ལྟས༌གུན༌ ཁྱུད༌ཅན༌ ཨིན༌ནོག༌། ཁོང༌ངི༌ གྱལ༌སྲིད༌ ཐའ༌ མེད༌ཁན༌ ཡང༌ ཁོང༌ངི༌ ཝང༌སྲུལ༌ མི༌རབས༌ནེ༌ མི༌རབས༌ ལུས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN4_4","028_4_4","DAN","4","4","4","“ང༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ ང༌རང༌ངི༌ ཁར༌རི༌ ནང༌ང༌ སྐྱིད༌པོ༌ དང༌ ཚིམས༌ཏེ༌ ཡོད༌ཏུས༌ ");
INSERT INTO lbj_vpl VALUES ("DN4_5","028_4_5","DAN","4","5","5","ངའ༌ ཇིགས༌ནང༌ཅན༌ནི༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌། མལ༌ཙེ༌ཀ༌ ཉལ༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ངའ༌ ཇིགས༌ནང༌ཅན༌ནི༌ ཞལ༌ཟིགས༌ཤིག༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_6","028_4_6","DAN","4","6","6","ཏེ༌ནེ༌ ཏེ༌ ཉི༌ལམ༌མི༌ ཏོན༌ ཤད༌ཅེས༌ལ༌ བ༌བེ༌ལོན༌ནི༌ ཤེས༌རབ༌ཅན༌ མི༌ ཚང༌མ༌ བོད༌ཅེས༌ལ༌ ངའེ༌ བཀའ༌ ཏངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_7","028_4_7","DAN","4","7","7","མོ༌ ཏབ༌ཁན༌, ཤི༌ཁན༌ནི༌ སེམས༌ཉིད༌ བོད༌ཁན༌, སྐར༌རྩིས༌ཏང༌ཁན༌ ཏང༌ མ༌ཡོངས༌པའེ༌ ཏུས༌སི༌ སྐོར༌ལ༌ ཤད༌ཁན༌ ཚང༌མ༌ ཡོང༌ང༌ཅིག༌ ངའེ༌ ཉི༌ལམ༌བོ༌ ཤད༌པིན༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ལ༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_8","028_4_8","DAN","4","8","8","སྟིང༌ཇུག༌པའེ༌ཀ༌ དཱ༌ནི༌ཨེལ༌ ཡོངས༌ ཡང༌ ངའེ༌ ཁོའ༌ ཉི༌ལམ༌བོ༌ ཤད༌པིན༌། ༼ངའེ༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ མིང༌ངི༌ གྱབ༌ནེ༌ ངའེ༌ ཁོའ༌ བེལ༌ཏེ༌ཤ༌ཟར༌ ཟེར༌རད༌པིན༌ ཡང༌ ཁོའེ༌ ནང༌ང༌ ཏམ༌པ༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ ཐུག༌ཉིད༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌།༽” ");
INSERT INTO lbj_vpl VALUES ("DN4_9","028_4_9","DAN","4","9","9","“ངའེ༌ ཟེར༌པིན༌, ‘ཆོས༌ངན༌ ཅོ༌ཁན༌གུན༌ནི༌ འུ༌སྐྱོང༌ བེལ༌ཏེ༌ཤ༌ཟར༌, ཏམ༌པ༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ ཐུག༌ཉིད༌ ཁྱོ༌རང༌ངི༌ ནང༌ང༌ ཡོད༌ཁན༌བོ༌ ང༌ གྱུས༌ཡོད༌། སང༌ཝ༌ ཅི༌ཞིག༌གའང༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ ཀགས༌པོ༌ མ༌ནོག༌། ང༌ འི༌ ཉི༌ལམ༌བོ༌ ཐོང༌, འི༌བོའེ༌ ཏོན༌ ངའ༌ ཤོད༌དའང༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_10","028_4_10","DAN","4","10","10","མལ༌ཙའེ༌ ནང༌ང༌ ཡོད༌ཏུས༌ ངའ༌ འི༌ ཉི༌ལམ༌བོ༌ ཐོང༌, ཇིགས༌རྟེན༌ནི༌ ཞུང༌སྐྱིལ༌ལ༌ མ༌ ཆེན༌མོ༌ ལྕང༌མ༌ཞིག༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_11","028_4_11","DAN","4","11","11","ཏེ༌ ལྕང༌མ༌བོ༌ ལྡན༌ཨིན༌ སོང༌ཏེ༌ མ༌ ཤེད༌ཅན༌ གྱུར༌ཏེ༌ ནམ༌མ༌ ཐུགས༌ ཡང༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ མི༌གུན༌ནི༌ ཐོང༌ངད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_12","028_4_12","DAN","4","12","12","ཏེ༌བོའེ༌ ལོ༌མ༌གུན༌ མ༌ ལྡེ༌མོ༌ ཡང༌ ཚང༌མའ༌ གབ༌ཅེས༌ ཁ༌ཟས༌ མ༌མང༌པོ༌ ཆགས༌ཏེ༌ དུག༌པིན༌། ནམ༌མི༌ ཅ༌གུན༌ནི༌ ཏེ༌བོའེ༌ ཡལ༌ག༌གུན༌ནི༌ ནང༌ང༌ ཚངས༌ སགས༌ཏེ༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌གུན༌ ཏེ༌བོའེ༌ ཡོག༌ག༌ དུག༌དུག༌པིན༌། ཇིག༌རྟེན༌ནི༌ སྲོག༌ ཡོད༌ཁན༌ ཚང༌མའ༌ ཏེ༌ ལྕང༌མའེ༌ ཀ༌ནེ༌ ཟན༌ ཟ༌དུག༌པིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("DN4_13","028_4_13","DAN","4","13","13","“མལ༌ཙའེ༌ཀ༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ ལོན༌ ཁྱོང༌ཁན༌ ཏམ༌པ༌བོ༌ ནམ༌ཁའ༌ནེ༌ བབས༌ཏེ༌ སྐྱོད༌ཨིན༌ ང༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_14","028_4_14","DAN","4","14","14","ཁོང༌ངི༌ ཤེད༌ནའང༌ མོལས༌, ‘ལྕང༌མ༌བོ༌ ཅོད༌ ཡང༌ ཡལ༌ག༌གུན༌ རྒོར༌, ལོ༌མ༌གུན༌ ཅད༌ཏེ༌ ཁ༌ཟས༌གུན༌ ཡོག༌། ཏེ༌བོའེ༌ ཡོག༌ག༌ ཡོད༌ཁན༌ནི༌ སེམས༌ཅན༌གུན༌ དང༌ ཡལ༌གའེ༌ཀ༌ ཡོད༌ཁན༌ནི༌ ཅ༌གུན༌ ཤོར༌ ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_15","028_4_15","DAN","4","15","15","ཨིན༌ནའང༌ ཏེ༌བོའེ༌ ལྡིམས༌པོ༌ ལྕགས༌ དང༌ ར༌གན༌ནི༌ ཏར༌ ཉམ༌པོ༌ ལྡམས༌ཏེ༌ པ༌ཀྲག༌གུན༌ སའེ༌ ནང༌ང༌ རྩའ༌ སྔོན༌པོའེ༌ སྐོར༌ཏེ༌ བོར༌།’” “‘ནམ༌ཁའེ༌ ཟིལ༌པའེ༌ ཆུའ༌ ཁོ༌ ཕོག༌ཅུག༌ ཡང༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ དང༌ ཞིང༌ངི༌ རྩའེ༌ ཕྲོའ༌ ཁོ༌ དུག༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_16","028_4_16","DAN","4","16","16","ལོ༌ རྡུན༌ ཚར༌ཚར༌ ཁོའ༌ མི༌ ལྡད༌པའེ༌ ཚབས༌ལ༌ སེམས༌ཅན༌ནི༌ ལྡད༌པ༌ ཡོད༌ ཅུག༌།’” ");
INSERT INTO lbj_vpl VALUES ("DN4_17","028_4_17","DAN","4","17","17","“‘ཐག༌ཅད༌ ཛད༌ཁན༌བོ༌ ལོན༌ ཁྱོང༌ཁན༌གུན༌ནི༌ ཤད༌ད༌ ཛདས༌, ཏམ༌པ༌ ཞུགས༌ཁན༌གུན༌ནི༌ ཁོང༌ངི༌ ཁྲིམས༌ཅད༌བོ༌ ཤད༌ད༌ ཛདས༌། ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ཇིག༌རྟེན༌ནི༌ གྱལ༌སྲིད༌ ཚང༌མའེ༌ཀ༌ ཝང༌སྲུལ༌ལ༌ ཛད༌ཅེས༌པོ༌ མི༌ཚང༌མ༌ལ༌ ཧོ༌གོ༌ཅུག༌ཅེས༌ལ༌ ཏེ༌བོ༌ ཛདས༌། ཁོང༌ངི༌ ཏེ༌གུན༌ ཁོང༌ ཐུགས༌ཐད༌ཁན༌བོའ༌ སལ༌ལ༌ ཛད༌ད༌ནོག༌ ཏེ༌ནང༌ང༌ སེམས༌པས༌མོ༌ཅན༌གུན༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌།’” ");
INSERT INTO lbj_vpl VALUES ("DN4_18","028_4_18","DAN","4","18","18","“བེལ༌ཏེ༌ཤ༌ཟར༌, ཏེ༌ ཉི༌ལམ༌བོ༌ ང༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ལ༌ ཐོང༌། ཏ༌ ཏེ༌བོའེ༌ ཏོན༌ ཤོད༌དའང༌ ཅིའ༌ཟེར༌ན༌ ངའེ༌ གྱལ༌སྲིད༌ གང༌པོའེ༌ ཤེས༌རབ༌ཅན༌ མི༌ ཅིག༌གའང༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ མ༌ཉན༌། ཨིན༌ནའང༌ ཁྱོ༌རང༌ང༌ ཤད༌ ཉན༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ཏམ༌པ༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ ཐུག༌ཉིད༌ ཁྱོ༌རང༌ངི༌ ནང༌ང༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN4_19","028_4_19","DAN","4","19","19","ཏེ༌ནེ༌ ཏུས༌ བན༌ཤིག༌གི༌ ཕིའ༌ དཱ༌ནི༌ཨེལ༌ ཐེ༌ཚོམས༌ སོང༌ ཡང༌ ཉི༌ལམ༌མི༌ ཏོན༌བོ༌ སམས༌ཏེ༌ ཁོའེ༌ སེམས༌ལ༌ སྲན༌ཏྲེ༌ བར༌དོ༌ ཐོང༌། ཏེ༌ནེ༌ གྱལ༌པོའེ༌ ཟེརས༌, “བེལ༌ཏེ༌ཤ༌ཟར༌, ཉི༌ལམ༌ ཡ༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ སམས༌ཏེ༌ ཁྱོ༌རང༌ངི༌ སེམས༌ལ༌ ནགས༌ མ༌སྟན༌།” ཁོའེ༌ ལན༌ ཏངས༌, “སྤོན༌བོ༌ ལེ༌, ཉི༌ལམ༌བོ༌ ཉེ༌རང༌ མན༌པ༌ ཉེ༌རང༌ངི༌ གྲ༌འོ༌གུན༌ ཡང༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ ཉེ༌རང༌ང༌ གྱབ༌གལ༌ ཅོ༌ཁན༌གུན༌ལ༌ ཇུང༌ཤིག༌པིའང༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_20","028_4_20","DAN","4","20","20","ཉེ༌རང༌ང༌ ཐོང༌ཁན༌ནི༌ ལྕང༌མ༌ ལྡན༌ཏེ༌ ཤེད༌ཅན༌ གྱུར༌ ཡང༌ ཇིག༌རྟེན༌ནི༌ མི༌ ཚང༌མའེ༌ ཐོང༌ཅེས༌སི༌ ཕིའ༌ ཏེ༌བོའེ༌ གོ༌ ནམ༌མ༌ ཐུག༌, ");
INSERT INTO lbj_vpl VALUES ("DN4_21","028_4_21","DAN","4","21","21","ཏེ༌བོའེ༌ ལོ༌མ༌གུན༌ མ༌ ལྡེ༌མོ༌, ཏེ༌བོའེ༌ཀ༌ ཚང༌མའ༌ གབ༌ཅེས༌ ཁ༌ཟས༌ མ༌མང༌པོ༌ ཆགས༌ཏེ༌ ནམ༌མི༌ ཅ༌གུན༌ནི༌ ཏེ༌བོའེ༌ ཡལ༌ག༌གུན༌ནི༌ ནང༌ང༌ ཚངས༌ སགས༌ཏེ༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌གུན༌ ཏེ༌བོའེ༌ ཡོག༌ག༌ དུག༌དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_22","028_4_22","DAN","4","22","22","གྱལ༌པོ༌ལེ༌ ཏེ༌ ལྕང༌མ༌བོ༌ ཉེ༌རང༌ ཨིན༌ནོག༌། ཉེ༌རང༌ ཀྲག༌པོ༌ དང༌ ཤེད༌ཅན༌ ཡང༌ ཉེ༌རང༌ངི༌ སྤལ༌ ནམ༌ཁའ༌ ཚོག༌པ༌ ལེབ༌ཏེ༌ ཇིག༌རྟེན༌ གང༌པོའ༌ ཉེ༌རང༌ངི༌ ཝང༌སྲུལ༌ལ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN4_23","028_4_23","DAN","4","23","23","“གྱལ༌པོ༌ ཉེ༌རང༌ང༌ ལོན༌ ཁྱོང༌ཁན༌ ཏམ༌པ༌བོ༌ ནམ༌ཁའ༌ནེ༌ ཡོག༌ག༌ ཡོང༌ཨིན༌ ཐོང༌ ཡང༌ ཁོང༌ངི༌ མོལས༌, ‘ལྕང༌མ༌ ཅད༌ཏེ༌ མེད༌ཁན༌ ཅོས༌ ཨིན༌ནའང༌ ལྡིམས༌པོ༌ བོར༌ཏེ༌ ལྕགས༌ དང༌ ར༌གན༌ནི༌ ཏར༌ ཉམ༌པོ༌ ལྡོམ༌ ཡང༌ རྩའ༌ སྔོན༌པོའེ༌ སྐོར༌ཏེ༌ པ༌ཀྲག༌ སའེ༌ ནང༌ང༌ བོར༌། ནམ༌ཁའེ༌ ཟིལ༌པའེ༌ ཆུ༌ ཁོའ༌ ཕོག༌ཅུག༌ ཡང༌ ཁོ༌ ལོ༌ རྡུན༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ ཉམ༌པོ༌ དུག༌ཅུག༌།’” ");
INSERT INTO lbj_vpl VALUES ("DN4_24","028_4_24","DAN","4","24","24","“གྱལ༌པོ༌ ཁྱེན༌ ཉི༌ལམ༌མི༌ ཏོན༌བོ༌ ནི༌, ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ཐག༌ཅད༌ ཛད༌ཁན༌བོ༌ ཉེ༌རང༌ངི༌ཀ༌ ཇུང༌ཅེས༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_25","028_4_25","DAN","4","25","25","ཉེ༌རང༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ བིང༌ཏེ༌ སེམས༌ཅན༌གུན༌ ཉམ༌པོ༌ དུག༌ཨིན༌, རྩའ༌ ཟེན༌ ཡང༌ ནམ༌ཁའེ༌ ཟིལ༌པའེ༌ ཆུ༌ ཉེ༌རང༌ང༌ ཕོག༌ཨིན༌། ཀུན༌ཝང༌ དཀོན༌མཆོག༌ གྱལ༌སྲིད༌ ཚང༌མའེ༌ཀ༌ ཝང༌སྲུལ༌ལ༌ ཛད༌ཁན༌ ཡང༌ ཏེ༌བོ༌ ཁོང༌རང༌ ཐུགས༌ཐད༌ཁན༌བོའ༌ སལ༌ལ༌ ཛད༌ཅེས༌པོ༌, ཉེ༌རང༌ངི༌ ལོ༌ རྡུན༌ནི༌ སྟིང༌ནེ༌ མན༌ནེ༌ ཁས༌ལེན༌ མི༌ཅོ༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_26","028_4_26","DAN","4","26","26","ལྕང༌མའེ༌ ལྡིམས༌ དང༌ པ༌ཀྲག༌ བོར༌ཅེས༌ལ༌ བཀའ༌ སལ༌ཁན༌ནི༌ ཏོན༌ནི༌ ཉེ༌རང༌ངི༌ དཀོན༌མཆོག༌ ཀུན༌ཝང༌ ཞུགས༌ཁན༌བོ༌ ཁས༌ལེན༌ ཅོའ༌ཅིག༌ ཉེ༌རང༌ང༌ ཉེ༌རང༌ངི༌ གྱལ༌སྲིད༌ ལོགས༌ཏེ༌ ཐོབ༌ཅེས༌པོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_27","028_4_27","DAN","4","27","27","གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ ཁྱེན༌, ངའེ༌ ལབ༌ཞའ༌ ཉན༌ན༌ ཛད༌, སྡིག༌པ༌ ཅོ༌ཅེས༌ ཕངས༌ཏེ༌ ཀྲང༌པོ༌ ཅོའ༌ ཛད༌། ངན༌པའེ༌ སྕོད༌པ༌ ཕངས༌ཏེ༌ ཉལ༌བ༌ཅན༌གུན༌ལ༌ སྙིང༌རྗེ༌ སྟན༌ན༌ ཛད༌། ཅི༌པ༌ཏ༌ ཉེ༌རང༌ངི༌ འི༌ སྐྱིད༌པོ༌ མི༌ཚེ༌བོ༌ ཡུན༌རིངས༌ ལུས༌ སྲིད༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN4_28","028_4_28","DAN","4","28","28","གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ཀ༌ ཏེ༌ ཚང༌མ༌ ཇུང༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_29","028_4_29","DAN","4","29","29","ཟླ༌ 12 སྟིང༌ནེ༌ གྱལ༌པོ༌ བ༌བེ༌ལོན༌ནི༌ ཁར༌རི༌ ཐོག༌གི༌ཀ༌ གྲུལ༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ ");
INSERT INTO lbj_vpl VALUES ("DN4_30","028_4_30","DAN","4","30","30","ཁོའེ༌ ཟེརས༌, “ང༌ དུག༌སའེ༌ འི༌ བ༌བེ༌ལོན༌ནི༌ གྱལ༌སའ༌ ཇིགས༌པོ༌ ངའེ༌ རྩིགས༌ཏེ༌ མ༌ནོག༌ག༌? ཏེ༌བོ༌ ངའེ༌ སྤེལ༌ དང༌ ཁྱུད༌ སྟན༌ཅེས༌ལ༌ ཅོས༌ཏེ༌ མ༌ནོག༌ག༌?” ");
INSERT INTO lbj_vpl VALUES ("DN4_31","028_4_31","DAN","4","31","31","ཏེ༌ སྤེ༌ར༌གུན༌ ཁོའེ༌ ཁའ༌ནེ༌ བིང༌ མ༌ཚར༌ར༌ ནམ༌ཁའ༌ནེ༌ སྐད༌ཅིག༌གི༌ མོལས༌, “གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ འི༌ བཀའ༌བོ༌ ཁྱོ༌རང༌ངི༌ ཕིའ༌ ཨིན༌, གྱལ༌པོའེ༌ ཝང༌བོ༌ ངའེ༌ ཁྱོ༌རང༌ངི༌ ཀ༌ནེ༌ ཁྱེར༌རད༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_32","028_4_32","DAN","4","32","32","ཁྱོ༌རང༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཕིངས༌ཏེ༌ ནག༌ཚོགས༌སི༌ སེམས༌ཅན༌ནི༌ ཕྲོའ༌ དུག༌ཨིན༌ ཡང༌ བ༌ལང༌ ཙོགས༌ལ༌ རྩའ༌ ཟེན༌། ཀུན༌ཝང༌ དཀོན༌མཆོག༌ གྱལ༌སྲིད༌ ཚང༌མའེ༌ཀ༌ ཝང༌སྲུལ༌ལ༌ ཛད༌ཁན༌ ཡང༌ ཏེ༌བོ༌ ཁོང༌རང༌ ཐུགས༌ཐད༌ཁན༌བོའ༌ སལ༌ལ༌ ཛད༌ཅེས༌པོ༌ ཁས༌ལེན༌ ཅོ༌ཅོ༌ ལོ༌ རྡུན༌ ཁྱོ༌རང༌ ཏེ༌ ཙོགས༌ལ༌ དུག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN4_33","028_4_33","DAN","4","33","33","ཏེན༌ན༌མལ༌ལ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ སྐོར༌ལ༌ མོལ༌ཁན༌ ཚང༌མ༌ དྲན༌དྲའ༌ གྲུབ༌། ཁོ༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཕིངས༌ཏེ༌ བ༌ལང༌ ཙོགས༌ལ༌ རྩའ༌ ཟོས༌། ཁོའེ༌ སྲའ༌ ལག༌གི༌ ཤོག༌པ༌ ཙོགས༌ རིང༌མོ༌ ཡང༌ སེན༌མོ༌ ཅའེ༌ སེན༌མོ༌ ཙོགས༌ གྱུར༌གྱུར༌ ཚོག༌པ༌ ཁོའེ༌ ཟུགས༌པོའ༌ ནམ༌ཁའེ༌ ཟིལ༌པའེ༌ ཆུ༌ ཕོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_34","028_4_34","DAN","4","34","34","“ཏེ༌ ཏུས༌པོ༌ བུད༌ཏེ༌ སྟིང༌ནེ༌ ང༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ནམ༌ཁའེ༌ ཆོགས༌ལ༌ ལྟས༌པིན༌ ཡང༌ ངའེ༌ ལྡད༌པ༌ ཁྱོར༌ཁན༌བོ༌ གྱལ༌། ཏེ༌ནེ༌ ངའེ༌, ཀུན༌ཝང༌ དཀོན༌མཆོག༌ག༌ སྟོད༌པ༌ ཕུལ༌པིན༌། ཏུས༌གྱུན༌ སོན༌པོ༌ དཀོན༌མཆོག༌ག༌ ངའེ༌ རྩི༌ཝ༌ དང༌ སྤལ༌ ཕུལ༌པིན༌། ཁོང༌ངི༌ གྱལ༌སྲིད༌ ཐའ༌མེད༌ཁན༌ནི༌ གྱལ༌སྲིད༌, ཡང༌ ཁོང༌ངི༌ གྱལ༌སྲིད༌ མི༌རབས༌ནེ༌ མི༌རབས༌ ལུས༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_35","028_4_35","DAN","4","35","35","ཁོང༌ངི༌ སྐུན༌དུན༌ལ༌ ཇིག༌རྟེན༌པ༌ ཚང༌མ༌ ཅའང༌ མ༌ནོག༌། ཇིག༌རྟེན༌ནི༌ མི༌ དང༌ ནམ༌ཁའེ༌ ཝང༌གུན༌ ཉམ༌པོ༌ ཁོང༌ངི༌ ཁོང༌རང༌ ཐད༌ཁན༌ ཛད༌ད༌ནོག༌། སུ༌ཞིག༌གའང༌ ཁོང༌ངི༌ ཆག༌ ལྡམས༌ཏེ༌ བོར༌ མི༌ཉན༌ ཡ༌ འི༌བོ༌ ཅི༌ ཛད༌ཏེ༌ ཨིན༌ ཟེར༌ མི༌ཉན༌?” ");
INSERT INTO lbj_vpl VALUES ("DN4_36","028_4_36","DAN","4","36","36","“ཏེན༌ན༌ ཏུས༌ལ༌ ངའེ༌ ལྡད༌པ༌ ཁྱོར༌ཁན༌བོ༌ གྱལ༌ ཡང༌ ངའ༌ སྤལ༌, རྩི༌ཝ༌ དང༌ གྱལ༌སྲིད༌ གུན༌ ལོགས༌ཏེ༌ ཐོབ༌། ངའ༌ ཁ༌དའ༌ ཏང༌ཁན༌ དང༌ ངའེ༌ ལོན༌པོ༌ གུན༌ནི༌ ང༌ ཙལ༌དུག༌པིན༌། ང༌ ང༌རང༌ངི༌ ཁྲིས༌སི༌ཀ༌ སྟགས༌ ཡང༌ ང༌ སྔུན༌ནི༌ སང༌ ཀྲག༌ག༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("DN4_37","028_4_37","DAN","4","37","37","ཏ༌ ང༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ནམ༌ཁའེ༌ གྱལ༌པོའ༌ སྟོད༌པ༌, ཀུས༌པ༌ དང༌ སྤལ༌ ཕུལ༌ལད༌ ཅིའ༌ཞུ༌ན༌ ཁོང༌ངི༌ ཆག༌ལས༌ ཚང༌མ༌ ཀྲང༌པོ༌ ཨིན༌ནོག༌ ཡང༌ ཁོང༌ངི༌ ཐག༌ཅད༌ ཚང༌མ༌ འོས༌པ༌ཅན༌ ཨིན༌ནོག༌། ཀྲག༌པོ༌ ཚོར༌ཁན༌གུན༌ ཁོང༌ངི༌ པས༌མོ༌ ཛད༌ད༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","1","གྱལ༌པོ༌ བེལ༌ཤའེ༌ཟར༌རི༌ ཁོ༌རང༌ངི༌ 1000 ལོན༌པོ༌གུན༌ལ༌ གྲོན༌ ཀྲག༌པོ༌ ཏངས༌ཏེ༌ ཁོང༌གུན༌ ཉམ༌པོ༌ རྒུན༌ཆང༌ ཐུངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_2","028_5_2","DAN","5","2","2","གྱལ༌པོ༌ ར༌རོས༌ པ༌སང༌ ཁོ༌རང༌, ཁོའེ༌ ན༌མ༌གུན༌, ཚེ༌ཡོག༌ ན༌མ༌གུན༌ ཡང༌ ལོན༌པོ༌གུན༌ ཆང༌ ཐུང༌ཅེས༌སི༌ ཕིའ༌ ཁོའེ༌ ཨ༌བ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ ཆོད༌ཁང༌ནེ༌ ཁྱོང༌ཁན༌ནི༌ སེར༌ དང༌ མུལ༌ལི༌ ཀོ༌རེ༌གུན༌ ཁྱོང༌ཅེས༌ལ༌ གྱལ༌པོའེ༌ བཀའ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_3","028_5_3","DAN","5","3","3","ཏེ༌ནེ༌ ཞབ༌ཤི༌གུན༌ནི༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ དཀོན༌མཆོག༌གི༌ ཆོད༌ཁང༌ནེ༌ ཁྱོང༌ཁན༌ནི༌ སེར༌རི༌ ཀོ༌རེ༌གུན༌ ཁྱོངས༌ ཡང༌ གྱལ༌པོ༌, ཁོའེ༌ ན༌མ༌གུན༌ དང༌ ལོན༌པོ༌གུན༌ནི༌ ཏེ༌ནང༌ང༌ རྒུན༌ཆང༌ ཐུངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_4","028_5_4","DAN","5","4","4","ཆང༌ ཐུང༌ཨིན༌ ཁོང༌གུན༌ནི༌ སེར༌, མུལ༌, ར༌གན༌, ལྕགས༌, ཤིང༌ དང༌ རྡོའ༌ ཅོ༌ཁན༌ ཁོ༌རང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ སྟོད༌པ༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_5","028_5_5","DAN","5","5","5","ཧུན༌མེད༌ལ༌ ལག༌པ༌ཞིག༌ སྔོན༌ཏེ༌ འོད༌སྟག༌གི༌ དུན༌ལ༌ ཁར༌རི༌ རྩིག༌པའེ༌ཀ༌ བྲིའ༌ ཛདས༌། གྱལ༌པོའེ༌ ཏེ༌ ལག༌པའེ༌ བྲི༌ཨིན༌ ཡོད༌ཁན༌བོའ༌ ལྟའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_6","028_5_6","DAN","5","6","6","ཁོའེ༌ ལྡོང༌ སེར༌པོ༌ གྱུརས༌ ཡང༌ ཁོ༌ མ༌ སྲན༌ཏྲེ༌ ཇིགས༌ཏེ༌ ཁོའེ༌ པིག༌མོ༌ དང༌ སྐང༌གུན༌ དར༌ཨིན༌ གྱལ༌པོ༌ སའེ༌ཀ༌ མ༌ཁད༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_7","028_5_7","DAN","5","7","7","གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ ཤི༌ཁན༌ནི༌ སེམས༌ཉིད༌ བོད༌ཁན༌, སྐར༌རྩིས༌ ཏང༌ཁན༌ དང༌ མ༌ཡོངས༌པའེ༌ ཏུས༌སི༌ སྐོར༌ལ༌ ཤད༌ཁན༌ ཚང༌མ༌ ཀུ༌ཅོ༌ ཏངས༌ཏེ༌ བོདས༌། གྱལ༌པོའེ༌ ཏེ༌ ཤེས༌རབས༌ཅན༌ མི༌གུན༌ལ༌ ཟེརས༌, “འི༌ བྲིས༌ཁན༌བོ༌ སིལ༌ཏེ༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ཁན༌བོའ༌ ངའེ༌ གྱལ༌པོ༌ ཙོགས༌སི༌ ཀོས༌ སྐོན༌ཏེ༌ སེར༌རི༌ ཉག༌ཐག༌ སྐྱེའ༌ སྐར༌ཨིན༌ ཡང༌ ཁོའ༌ གྱལ༌སྲིད༌དི༌ ནང༌ང༌ ཐོ༌ཤོག༌ ཀོ༌ས༌ སུམ༌པ༌བོ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN5_8","028_5_8","DAN","5","8","8","གྱལ༌པོའེ༌ ཤེས༌རབ༌ཅན༌ མི༌ ཚང༌མ༌ ཡོངས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ལ༌ ཏེ༌ བྲིའ༌ ཛད༌ཁན༌བོ༌ སིལ༌ ཡ༌ ཏེ༌བོའེ༌ ཏོན༌ ཤད༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_9","028_5_9","DAN","5","9","9","ཏེ༌ནེ༌ གྱལ༌པོ༌ བེལ༌ཤའེ༌ཟར༌ མ༌ སྲན༌ཏྲེ༌ ཇིགས༌ཏེ༌ ཁོང༌ངི༌ ལྡོང༌ མང༌ང༌ སེར༌པོ༌ གྱུར༌། ཁོང༌ངི༌ ལོན༌པོ༌གུན༌ ཐེ༌ཚོམས༌ སོང༌ཏེ༌ ཅི༌ ཅོ༌ཅེས༌པོ༌ ཧ༌མ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_10","028_5_10","DAN","5","10","10","གྱལ༌པོ༌ དང༌ ལོན༌པོ༌ གུན༌ནི༌ སྐད༌ ཚོར༌ཏེ༌ ཨ༌མ༌ གྱལ༌མོ༌ གྲོན༌ ཏང༌སའེ༌ ནང༌ང༌ ཡོངས༌ཏེ༌ ཟེརས༌, “གྱལ༌པོའེ༌ སྐུ༌ཚེ༌ སྟན༌ཤིག༌། ཇིགས༌ཏེ༌ སེར༌པོ༌ ཆའ༌ མ༌ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_11","028_5_11","DAN","5","11","11","ཉེ༌རང༌ངི༌ གྱལ༌སྲིད༌དི༌ ནང༌ང༌ ཏམ༌པ༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ ཐུག༌ཉིད༌ ཡོད༌ཁན༌ མི༌ཞིག༌ ཡོད༌། ཉེ༌རང༌ངི༌ ཨ༌བ༌ གྱལ༌པོ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌རི༌ ཏུས༌ལ༌ ཁོ༌ ལྷ༌ལྷ༌མོ༌གུན༌ ཙོགས༌ ཤེས༌རབས༌ཅན༌, རིག༌པ༌ཅན༌ དང༌ ཁས༌པ༌ ཡོད༌ཁན༌བོ༌ ཐོང༌ཏེ༌ ཁོའ༌ མོ༌ ཏབ༌ཁན༌, ཤི༌ཁན༌ནི༌ སེམས༌ཉིད༌ བོད༌ཁན༌, སྐར༌རྩིས༌ཏང༌ཁན༌ ཏང༌ མ༌ཡོངས༌པའེ༌ ཏུས༌སི༌ སྐོར༌ལ༌ ཤད༌ཁན༌ གུན༌ནི༌ འུ༌སྐྱོང༌ང༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_12","028_5_12","DAN","5","12","12","ཏེ༌ མི༌ དཱ༌ནི༌ཨེལ༌ལ༌ གྱལ༌པོའེ༌ བེལ༌ཏེ༌ཤ༌ཟར༌ ཟེར༌རད༌པིན༌, ཁོ༌ མ༌ ཤེས༌རབས༌ཅན༌, རིག༌པ༌ཅན༌ དང༌ ཁས༌པ༌ ཡོད༌ཁན༌བོ༌ གྱུས༌སོང༌ ཡང༌ ཁོའ༌ ཉི༌ལམ༌མི༌ ཏོན༌, སྐ༌ལས༌ ཀགས༌པོ༌ ཡང༌ ཚོད༌ལེན༌ གུན༌ སེལ༌ ཉན༌ནད༌པིན༌། དཱ༌ནི༌ཨེལ༌ལ༌ བོད༌ཏེ༌ འི༌ བྲིའ༌ ཛད༌ཁན༌ནི༌ ཏོན༌བོ༌ ཤད༌ ཅུག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN5_13","028_5_13","DAN","5","13","13","ཏེ༌ནེ༌ དཱ༌ནི༌ཨེལ༌ གྱལ༌པོའེ༌ དུན༌ལ༌ ཁྱོངས༌ ཡང༌ ཁོའེ༌ ཟེརས༌, “ཁྱོ༌རང༌ ངའེ༌ ཨ༌བ༌ གྱལ༌པོའེ༌ ཡ༌ཧུ༌དཱ༌ནེ༌ ཟུམས༌ཏེ༌ ཁྱོང༌ཁན༌ དཱ༌ནི༌ཨེལ༌ ཨིན༌ན༌? ");
INSERT INTO lbj_vpl VALUES ("DN5_14","028_5_14","DAN","5","14","14","ཁྱོ༌རང༌ངི༌ ནང༌ང༌ ལྷ༌ལྷ༌མོ༌གུན༌ནི༌ ཐུག༌ཉིད༌ གངས༌ཏེ༌ ཁྱོ༌རང༌ མ༌ རིག༌པ༌ཅན༌, ཤེས༌རབས༌ཅན༌ དང༌ ཁས༌པ༌ ཡོད༌ཁན༌བོ༌ ངའེ༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_15","028_5_15","DAN","5","15","15","ངའེ༌ མི༌ ཤེས༌རབ༌ཅན༌ དང༌ སྐར༌རྩིས༌ ཏང༌ཁན༌ གུན༌ལ༌ བོད༌པིན༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ལ༌ འི༌བོའེ༌ ཏོན༌ ཤད༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_16","028_5_16","DAN","5","16","16","ཁྱོ༌རང༌ང༌ ཉི༌ལམ༌མི༌ ཏོན༌ དང༌ སྐ༌ལས༌ ཀགས༌པོ༌གུན༌ སེལ༌ ཉན༌དུག༌ ཟེར༌ཏེ༌ ངའ༌ ཚོར༌། ཀལ༌ཏེས༌ ཁྱོ༌རང༌ངི༌ འི༌ བྲིས༌ཁན༌བོ༌ སིལ༌ཏེ༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ ཤད༌ན༌ ངའེ༌ ཁྱོ༌རང༌ང༌ གྱལ༌པོ༌ ཙོགས༌སི༌ ཀོས༌ སྐོན༌ཏེ༌ སེར༌རི༌ ཉག༌ཐག༌ སྐྱེའ༌ སྐར༌ཨིན༌ ཡང༌ གྱལ༌སྲིད༌དི༌ ནང༌ང༌ ཐོ༌ཤོག༌ ཀོ༌ས༌ སུམ༌པ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN5_17","028_5_17","DAN","5","17","17","ཏེ༌ནེ༌ དཱ༌ནི༌ཨེལ༌ལི༌ གྱལ༌པོའ༌ ལན༌ཏངས༌, “སོལ༌རས༌གུན༌ ཉེ༌རང༌ངི༌ བོར༌ར༌ ཛད༌ ཡ༌ ཞན༌ཞིག༌ག༌ སལ༌ལ༌ ཛད༌ ཨིན༌ནའང༌ ངའེ༌ ཉེ༌རང༌ང༌ འི༌ བྲིས༌ཁན༌བོ༌ སིལ༌ཏེ༌ ཏེ༌བོའེ༌ ཏོན༌བོ༌ ཤད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_18","028_5_18","DAN","5","18","18","“གྱལ༌པོ༌ ཁྱེན༌, ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌, ཉེ༌རང༌ངི༌ ཨ༌བ༌ ནེ༌བུ༌ཀཱ༌ནེ༌ཟཱར༌ལ༌ ཝང༌, ཁྱུད༌, སྤལ༌ དང༌ རྩི༌ཝ༌ སལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_19","028_5_19","DAN","5","19","19","ཁོའ༌ ཀོ༌ས༌ ཇིགས༌པོ༌ སལ༌ལ༌ ཛད༌ཅེས༌པོའེ༌ གྱལ༌ཁམས༌, སྐད༌ དང༌ མི༌ ཚང༌མ༌ ཁོང༌ང༌ ཇིགས༌ཏེ༌ དར༌རད༌པིན༌། གྱལ༌པོའེ༌ སད༌ ཉིན༌ གྲོ༌ཁན༌གུན༌ སད༌དད༌པིན༌, པུད༌ད༌ ཐད༌ཁན༌གུན༌ པུད༌དད༌པིན༌, སྟག༌ག༌ ཐད༌ཁན༌གུན༌ སྟག༌གད༌པིན༌ ཡང༌ ཕབ༌བ༌ ཐད༌ཁན༌གུན༌ ཕབ༌བད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_20","028_5_20","DAN","5","20","20","ཨིན༌ནའང༌ ཁོའེ༌ སྙིང༌ ཕོ༌སོ༌ཅན༌ སྐྱོང༌པོ༌ གྱུར༌ར༌ཅིག༌, དཀོན༌མཆོག༌གི༌ ཁོ༌ གྱལ༌པོའེ༌ ཁྲིས༌སི༌ ཀ༌ནེ༌ ཕབས༌ཏེ༌ ཁོའེ༌ སྤལ༌བོ༌ མེད༌ཁན༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_21","028_5_21","DAN","5","21","21","ཁོ༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཕིངས༌ཏེ༌ ཁོའ༌ སེམས༌ཅན༌ནི༌ ལྡད༌པ༌ སལས༌། ཁོ༌ ནག༌ཚོགས༌སི༌ བུང༌བུ༌གུན༌ ཉམ༌པོ༌ དུགས༌ཏེ༌ བ༌ལང༌ ཙོགས༌ལ༌ རྩའ༌ ཟོས༌ ཡང༌ ཁོའེ༌ ཟུགས༌པོའ༌ ཟིལ༌པའེ༌ ཆུ༌ ཕོག༌ ནམ༌ ཚག༌པ༌ ཁོའེ༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ཇིག༌རྟེན༌ནི༌ གྱལ༌སྲིད༌ ཚང༌མའེ༌ཀ༌ ཝང༌སྲུལ༌ལ༌ ཛད༌ཅེས༌ ཡང༌ ཁོང༌ ཐུགས༌ཐད༌ཁན༌བོ༌ ཏེ༌གུན༌ནི༌ཀ༌ ཝང༌སྲུལ༌པ༌ སྐོའ༌ ཛད༌ཅེས༌པོ༌ ཁས༌ལེན༌ མ༌ཅོས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN5_22","028_5_22","DAN","5","22","22","“ཨིན༌ནའང༌ ཁོང༌ངི༌ བུ༌ཚ༌ བེལ༌ཤའེ༌ཟར༌ ཉེ༌རང༌ང༌ ཏེ༌གུན༌ གྱུས༌ཡོད༌ཏེའང༌ པས༌མོ༌ མ༌གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_23","028_5_23","DAN","5","23","23","མ༌ཚད༌ ཉེ༌རང༌ངི༌ ནམ༌ཁའེ༌ གཙོ༌བོ༌ དཀོན༌མཆོག༌གི༌ གྱབ༌གལ༌ ཅོས༌ཏེ༌ ཁོང༌ངི༌ ཆོད༌ཁང༌ངི༌ ཏམ༌པ༌ ཀོ༌རེ༌གུན༌ ཁྱོངས༌ཏེ༌ ཉེ༌རང༌, ཉེ༌རང༌ངི༌ ན༌མ༌གུན༌, ཚེ༌ཡོག༌ ན༌མ༌གུན༌ ཡང༌ ལོན༌པོ༌གུན༌ལ༌ རྒུན༌ཆང༌ ཐུང༌ཅེས༌ལ༌ ཏངས༌། ཉེ༌རང༌ངི༌ མ༌ཐོང༌ཁན༌, མ༌ཚོར༌ཁན༌ དང༌ ཧ༌མ༌གོ༌ཁན༌ སེར༌, མུལ༌, ར༌གན༌, ལྕགས༌, ཤིང༌ དང༌ རྡོའེ༌ སྐུན༌དྲའ༌གུན༌ལ༌ སྟོད༌པ༌ ཕུལས༌ ཨིན༌ནའང༌ ཉེ༌རང༌ངི༌ སྲོག༌ དང༌ ཉེ༌རང༌ངི༌ མི༌ཚེ༌ ནང༌ང༌ ཅོ༌ཅེས༌ཅན༌ ཚང༌མའེ༌ཀ༌ ཝང༌ ཡོད༌ཁན༌ དཀོན༌མཆོག༌ག༌ ཉེ༌རང༌ངི༌ རྩི༌ཝ༌ མ༌སལས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_24","028_5_24","DAN","5","24","24","ཏེ༌བོའེ༌ཕིའ༌ ཁོང༌ངི༌ བྲི༌ཅེས༌ལ༌ འི༌ ལག༌པ༌ ཀལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_25","028_5_25","DAN","5","25","25","ཏེ༌ བྲིས༌ཁན༌བོ༌ འི༌བོ༌ ཨིན༌ནོག༌: མེ༌ནེ༌, མེ༌ནེ༌, ཏེ༌ཀེལ༌, པར༌སིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_26","028_5_26","DAN","5","26","26","མེ༌ནེ༌ ཏོན༌ ནི༌ དཀོན༌མཆོག༌གི༌ ཉེ༌རང༌ངི༌ ཝང༌སྲུལ༌ལི༌ ཞག༌པོ༌ རྩིའ༌ ཛད༌ཏེ༌ མེད༌ཁན༌ ཅོའ༌ ཛད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_27","028_5_27","DAN","5","27","27","ཏེ༌ཀེལ༌ལི༌ ཏོན༌ ནི༌ ཉེ༌རང༌ སྐར༌ར༌ ཛདས༌ ཨིན༌ནའང༌ མ༌ ཡང༌མོ༌ བིང༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_28","028_5_28","DAN","5","28","28","པར༌སིན༌ནི༌ ཏོན༌ ནི༌ ཉེ༌རང༌ངི༌ གྱལ༌སྲིད༌ལ༌ ཁག༌ པུད༌ཏེ༌ མེ༌དིའ༌པ༌ དང༌ པར༌ཤིའ༌པ༌ གུན༌ལ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN5_29","028_5_29","DAN","5","29","29","ཏེ༌ནེ༌ བེལ༌ཤའེ༌ཟར༌རི༌ བཀའ༌ ནང༌ཞིན༌ དཱ༌ནི༌ཨེལ༌ལ༌ གྱལ༌པོ༌ ཙོགས༌ ཀོས༌ སྐོན༌ཏེ༌ སྐྱེའ༌ སེར༌རི༌ ཉག༌ཐག༌ སྐརས༌ ཡང༌ ཁོའ༌ གྱལ༌སྲིད༌དི༌ ནང༌ང༌ ཐོ༌ཤོག༌ ཀོ༌ས༌ སུམ༌པའེ༌ཀ༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN5_30","028_5_30","DAN","5","30","30","ཏེན༌ན༌ ཚན༌ལ༌ གྲ༌འོ༌གུན༌ནི༌ བ༌བེ༌ལོན༌ནི༌ གྱལ༌པོ༌ བེལ༌ཤའེ༌ཟར༌ སད༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("DN5_31","028_5_31","DAN","5","31","31","མེ༌དིའ༌པ༌ གྲ༌རི༌ཡས༌སི༌ གྱལ༌སྲིད༌པོ༌ ང༌ཡོག༌ག༌ ལེནས༌། ཏེ༌ ཏུས༌ གྲ༌རི༌ཡས༌ལ༌ ལོ༌ 62 ཆའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","1","གྱལ༌པོ༌ གྲ༌རི༌ཡས༌སི༌ ཁོ༌རང༌ངི༌ གྱལ༌སྲིད༌པོ༌ ཡུལ༌ཇོངས༌ 120 ནང༌ང༌ བགོས༌ ཡང༌ ཏེ༌ རེ༌རེ༌ཀ༌ ཝང༌ སྲུལ༌ཁན༌ནི༌ ཀའ༌ལོན༌ སྐོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_2","028_6_2","DAN","6","2","2","ཏེ༌ ཀའ༌ལོན༌གུན༌ནི༌ གྱལ༌པོའེ༌ ཕན༌ཐོགས༌སི༌ ཕིའ༌ ལས༌ ཅོ༌ཅེས༌ ཏན༌ཏན༌ ཅོ༌ཅེས༌ལ༌ གྱལ༌པོའེ༌ ལྟའ༌ཁན༌ནི༌ མི༌ སུམ༌ སྐོས༌, དཱ༌ནི༌ཨེལ༌ ཁོང༌གུན༌ནི༌ ནང༌ནེ༌ ཅིག༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_3","028_6_3","DAN","6","3","3","ཏུས༌ ཉུ༌ངུན༌ ཞིག༌གི༌ ནང༌ང༌ དཱ༌ནི༌ཨེལ༌ལི༌ ལས༌ མ༌ གྱལ༌ལ༌ ཅོས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཕྲོ༌པ༌གུན༌ དང༌ ཀའ༌ལོན༌གུན༌ནི༌ སང༌ མང༌ང༌ ཇོན༌པོ༌ ཨིན༌ཁན༌བོ༌ སྟནས༌ ཏེ༌བོའེ༌ཕིའ༌ གྱལ༌པོའེ༌ ཁོ༌ གྱལ༌སྲིད༌ གང༌པོའེ༌ཀ༌ འུ༌སྐྱོང༌ང༌ སྐོ༌ཅེས༌ ཐག༌ཅདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_4","028_6_4","DAN","6","4","4","ཏེ༌བོའེ༌ ཞས༌ཏེ༌ ཁོའེ༌ ཕྲོ༌པ༌ ཉིས༌ཀོ༌ དང༌ ཀའ༌ལོན༌གུན༌ནི༌ དཱ༌ནི༌ཨེལ༌ལི༌ ལས༌སི༌ ནང༌ང༌ སྐྱོན༌ ཙལས༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ལ༌ ཅའང༌ མ༌ཐོབ༌ ཅིའ༌ཟེར༌ན༌ དཱ༌ནི༌ཨེལ༌ ཨིད༌ཤེས༌ཅན༌, ཁོ༌རང༌ངི༌ ལས༌ལ༌ སྣང༌མེད༌ མ༌ཅོ༌ཁན༌ ཡང༌ ཕག༌སུབ༌བི༌ པེ༌ནེ༌ མ༌ནེ༌ ལེན༌ན༌ མེད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_5","028_6_5","DAN","6","5","5","སྟིང༌ཇུག༌ག༌ ཁོང༌གུན༌ནི༌ ཟེརས༌, “ཁོའེ༌ ཁོ༌རང༌ངི༌ དཀོན༌མཆོག༌གི༌ ཁྲིམས༌ མི༌ཅག༌ཅེས༌ མ༌སྟོག༌ ང༌དང༌ང༌ འི༌ མི༌བོའེ༌ ནང༌ང༌ ཅའང༌ སྐྱོན༌ མི༌ ཐོབ༌།” ");
INSERT INTO lbj_vpl VALUES ("DN6_6","028_6_6","DAN","6","6","6","ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ ཕྲོ༌པ༌ ཉིས༌ཀོ༌ དང༌ ཀའ༌ལོན༌གུན༌ གྱལ༌པོའེ༌ཀ༌ སོང༌ཏེ༌ ཟེརས༌, “གྱལ༌པོ༌ གྲ༌རི༌ཡས༌སི༌ སྐུ༌ཚེ༌ སྟན༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_7","028_6_7","DAN","6","7","7","ང༌ཞའ༌, ཉེ༌རང༌ངི༌ ལས༌གུན༌ལ༌ ལྟའ༌ཁན༌, ཀའ༌ལོན༌གུན༌, ཁ༌དའ༌ ཏང༌ཁན༌གུན༌ དང༌ སྤོན༌བོ༌ ཚང༌མ༌ ཁའ༌ ཆམས༌ཏེ༌ གྱལ༌པོའ༌ བཀའ༌ཁྲིམས༌ ཤིག༌ སལ༌ཅེས༌ལ༌ ཞུ༌ཝ༌ ཕུལ༌ལད༌། ཡོང༌ཅེས༌ཅན༌ནི༌ ཞག༌ སུམ༌ཅུའི༌ ནང༌ང༌ སུ༌ཞིག༌གི༌ ཉེ༌རང༌ མན༌པ༌ ཞན༌ མི༌ ཡ༌ ལྷ༌ལྷ༌མོ༌ སུ༌ཞིག༌ག༌ ཅོལ༌ན༌ ཏེ༌ མི༌བོ༌ སིང༌གེ༌ དོང༌ངི༌ ནང༌ང༌ ཕང༌ཅེས༌སི༌ བཀའ༌ སལ༌ལ༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_8","028_6_8","DAN","6","8","8","གྱལ༌པོ༌ ཁྱེན༌, ཏེ༌ ཁྲིམས༌པོ༌ བྲི༌ཅེས༌ལ༌ བཀའ༌ སལ༌ ཏེ༌ནེ༌ ཏེ༌བོའ༌ སུ༌ཞིག༌གིའང༌ གྱབ༌གལ༌ ཅོ༌མི༌ཉན༌ ཡང༌ མེ༌དིའ༌པ༌ དང༌ པར༌ཤིའ༌པ༌ གུན༌ནི༌ ཁྲིམས༌ ནང༌ཞིན༌ སུ༌ཞིག༌གིའང༌ ཏེ༌བོ༌ གྱུར༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN6_9","028_6_9","DAN","6","9","9","ཏེ༌ནེ༌ གྱལ༌པོ༌ གྲ༌རི༌ཡས༌སི༌ ཏེ༌ ཁྲིམས༌པོ༌ བྲི༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","10","དཱ༌ནི༌ཨེལ༌ལ༌ གྱལ༌པོའེ༌ བཀའ༌ ཁྲིམས༌པོ༌ གྱུས༌ ཡོད༌ཏེའང༌ ཁོ༌ ཁོ༌རང༌ངི༌ ཁང༌པའེ༌ ཡེ༌རུ༌ཤ༌ལེམ༌ ཆོགས༌ལ༌ ཀར༌ཁུང༌ ཡོད༌ཁན༌ ཁེ༌ཐོག༌གི༌ ནང༌ང༌ སོང༌ ཡང༌ ཏུས༌གྱུན༌ ཙོགས༌ལ༌ ཞག༌ཏང༌ ལན༌ སུམ༌ པིག༌དོང༌ ཙུགས༌ཏེ༌ དཀོན༌མཆོག༌ག༌ ཐུག༌རྗེ༌ཆེ༌ ཞུ༌ཨིན༌ མོས༌ལམ༌ ཞུའད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_11","028_6_11","DAN","6","11","11","ཏེ༌ནེ༌ ཁྲིམས༌ བྲི༌ ཅུག༌ཁན༌ནི༌ མི༌གུན༌ དཱ༌ནི༌ཨེལ༌ལི༌ ཁང༌པ༌ སོང༌ ཡང༌ ཁོའེ༌ དཀོན༌མཆོག༌ག༌ རོགས༌ ཛད༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུ༌ཨིན༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_12","028_6_12","DAN","6","12","12","ཁོང༌གུན༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཁྲིམས༌པོ༌ ཨིད༌ཏུ༌ སྐུལས༌, “ཡོང༌ཅེས༌ཅན༌ནི༌ ཞག༌ སུམ༌ཅུའི༌ ནང༌ང༌ ཉེ༌རང༌ མན༌པ༌ ཞན༌ མི༌ ཡ༌ ལྷ༌ལྷ༌མོ༌ སུ༌ཞིག༌ག༌ ཅོལ༌ན༌ ཏེ༌ མི༌བོ༌ སིང༌གེ༌ དོང༌ངི༌ ནང༌ང༌ ཕང༌ཅེས༌སི༌ བཀའ༌ སལ༌ལ༌ མ༌ཛད༌པིན༌ན༌?” གྱལ༌པོའེ༌ ལན༌ཏངས༌, “ཁྲིམས༌པོ༌ སྟན༌པོ༌ ཨིན༌། མེ༌དིའ༌པ༌ དང༌ པར༌ཤིའ༌པ༌ གུན༌ནི༌ ཁྲིམས༌ ནང༌ཞིན༌ ཏེ༌བོ༌ སུའང༌ གྱུར༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN6_13","028_6_13","DAN","6","13","13","ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ གྱལ༌པོའ༌ ཟེརས༌, “ཡ༌ཧུ༌དཱ༌ནེ༌ ཁྱོང༌ཁན༌ནི༌ མི༌ དཱ༌ནི༌ཨེལ༌ལི༌ ཉེ༌རང༌ དང༌ ཉེ༌རང༌ངི༌ ཁྲིམས༌པོ༌ ཁའ༌ མ༌ཉན༌ན༌ ཞག༌ཏང༌ ལན༌ སུམ༌ ཁོ༌རང༌ངི༌ དཀོན༌མཆོག༌ག༌ མོས༌ལམ༌ ཞུ༌དུག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN6_14","028_6_14","DAN","6","14","14","ཏེ༌བོ༌ ཚོར༌ར༌ཅིག༌ གྱལ༌པོའ༌ སྲན༌ཏྲེ༌ ཚེར༌ཁ༌ ཡོངས༌ ཡང༌ ཁོང༌ངི༌ ཉི༌མ༌ སྐྱོད༌ སྐྱོད༌ ཚག༌པ༌ དཱ༌ནི༌ཨེལ༌ སྐྱོབ༌ཅེས༌སི༌ རྩོན༌གྲུས༌ སྲན༌ཏྲེ༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_15","028_6_15","DAN","6","15","15","ཏེ༌ནེ༌ ཏེ༌ མི༌གུན༌ གྱལ༌པོ༌ ཡོད༌ས༌ སོང༌ཏེ༌ ཟེརས༌, “གྱལ༌པོ༌ ལེ༌, ཨིད༌ཏུ༌ ཛད༌, མེ༌དིའ༌པ༌ དང༌ པར༌ཤིའ༌པ༌ གུན༌ནི༌ ཁྲིམས༌ ནང༌ཞིན༌ གྱལ༌པོའེ༌ སལ༌ཁན༌ནི༌ བཀའ༌ཁྲིམས༌ གྱུར༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","16","ཏེ༌བོའེ༌ཕིའ༌ གྱལ༌པོའེ༌ བཀའ༌ ཏངས༌ ཡང༌ ཁོང༌གུན༌ནི༌ དཱ༌ནི༌ཨེལ༌ ཁྱོངས༌ཏེ༌ སིང༌གེ༌ དོང༌ངི༌ ནང༌ང༌ ཕངས༌། གྱལ༌པོའེ༌ དཱ༌ནི༌ཨེལ༌ལ༌ ཟེརས༌, “ཁྱོ༌རང༌ངི༌ ཨིད༌ཤེས༌ ཅོས༌ཏེ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ དཀོན༌མཆོག༌གི༌ ཁྱོ༌རང༌ སྐྱོབ༌བ༌ ཛད༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN6_17","028_6_17","DAN","6","17","17","རྡོའ༌ རིལ༌ཏེ༌ དོང༌ངི༌ ཁའེ༌ཀ༌ ཀབས༌ ཡང༌ སུའང༌ དཱ༌ནི༌ཨེལ༌ སྐྱོབ༌ མི༌ཉན༌ཅེས༌ལ༌ གྱལ༌པོ༌ ཏང༌ ལོན༌པོ༌གུན༌ནི༌ ཐེ༌ཙེ༌ ཏེ༌ཀ༌ ཏངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_18","028_6_18","DAN","6","18","18","ཏེ༌ནེ༌ གྱལ༌པོ༌ ཁར༌ལ༌ སོང༌ཏེ༌ ཏེ༌ ཚན༌བོ༌ ཟན༌ མ༌ཟོས༌ ཡང༌ སྐྱིད༌པོ༌ མ༌ཅོས༌ ཡང༌ ཁོའ༌ ཉིད༌དའང༌ མ༌ཡོངས༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_19","028_6_19","DAN","6","19","19","ང༌མོ༌ ནམ༌ལངས༌ས༌ཅིག༌ གྱལ༌པོ༌ ལངས༌ཏེ༌ གྱོགས༌པ༌ སིང༌གེ༌ དོང༌ ཡོད༌ས༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_20","028_6_20","DAN","6","20","20","དུན༌ལ༌ ལེབ༌བ༌ཅིག༌ ཁོང༌ངི༌ དཱ༌ནི༌ཨེལ༌ལ༌ བོད༌ཏེ༌ སེམས༌ཚེར༌ ཉམ༌པོ༌ ཟེརས༌, “ཨིད༌ཤེས༌ ཅོས༌ཏེ༌ དཀོན༌མཆོག༌ སོན༌པོའ༌ ཞབས༌ཏོག༌ ཞུ༌ཁན༌ དཱ༌ནི༌ཨེལ༌, སིང༌གེ༌གུན༌ནི༌ ཀ༌ནེ༌ ཁོང༌ང༌ ཁྱོ༌རང༌ སྐྱོབ༌ཐུབ༌བ༌?” ");
INSERT INTO lbj_vpl VALUES ("DN6_21","028_6_21","DAN","6","21","21","དཱ༌ནི༌ཨེལ༌ལི༌ ལན༌ ཏངས༌, “གྱལ༌པོའེ༌ སྐུ༌ཚེ༌ སྟན༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_22","028_6_22","DAN","6","22","22","ངའེ༌ དཀོན༌མཆོག༌གི༌ ཁོང༌རང༌ངི༌ ཕོ༌ཉ༌ ཀལ༌ལ༌ ཛད༌ཏེ༌ སིང༌གེ༌གུན༌ནི༌ ཁའ༌ ལྡམ༌མ༌ ཛདས༌། ཏེ༌གུན༌ནི༌ ང༌ ཅའང༌ ནོད༌པ༌ མ༌ཏངས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ངི༌ སྐུན༌དུན༌ལ༌ ང༌ ནོངས༌མེད༌ ཨིན༌པིན༌ ཡང༌ ངའེ༌, གྱལ༌པོ༌ ཉེ༌རང༌ངའང༌ ངན༌པ༌ མ༌ ཅོས༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN6_23","028_6_23","DAN","6","23","23","གྱལ༌པོ༌ མ༌སྲན༌ཏྲེ༌ ཐད༌ ཡང༌ དཱ༌ནི༌ཨེལ༌ དོང༌ནེ༌ ཕིང༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌། དོང༌ནེ༌ ཕིང༌ང༌ཅིག༌ དཱ༌ནི༌ཨེལ༌ལི༌ ཟུགས༌པོའ༌ ཅའང༌ མ༌སྐྱོན༌ སོང༌ཏེ༌ མེད༌པིན༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཁོ༌རང༌ངི༌ དཀོན༌མཆོག༌གི༌ཀ༌ ཨིད༌ཤེས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_24","028_6_24","DAN","6","24","24","གྱལ༌པོའེ༌ བཀའ༌ ནང༌ཞིན༌, ན༌མ༌ དང༌ ཕྲུ༌གུ༌གུན༌ ཐེས༌ཏེ༌ དཱ༌ནི༌ཨེལ༌ལ༌ སེམས༌ངན༌ ཉམ༌པོ༌ གྱབ༌གལ༌ ཅོ༌ཁན༌གུན༌ ཁྱོངས༌ཏེ༌ སིང༌གེ༌ དོང༌ངི༌ ནང༌ང༌ ཕངས༌། དོང༌ངི༌ སའེ༌ཀ༌ ལེབ༌བི༌ སང༌ སྔུན༌ལ༌ སིང༌གེ༌གུན༌ ཁོང༌གུན༌ནི༌ཀ༌ ཆོམས༌ ཡང༌ ཤ༌ ཟོས༌ཏེ༌ རུས༌པ༌ ཚང༌མ༌ ཅགས༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_25","028_6_25","DAN","6","25","25","ཏེ༌ནེ༌ གྱལ༌པོ༌ གྲ༌རི༌ཡས༌སི༌ གྱལ༌ཁམས༌, སྐད༌ དང༌ མི༌ ཚང༌མ༌ བྲིས༌, “ཁྱོ༌ཞའ༌ ཡར༌གྱས༌ ཀྲག༌པོ༌ ཆ༌ཤིག༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_26","028_6_26","DAN","6","26","26","ངའེ༌ བཀའ༌ ཏང༌ངད༌, གྱལ༌སྲིད༌ གང༌པོའེ༌ མི༌ ཚང༌མའེ༌ དཱ༌ནི༌ཨེལ༌ལི༌ དཀོན༌མཆོག༌གི༌ ཇིགས༌ དང༌ རྩི༌ཝའེ༌ ནང༌ང༌ མི༌ཚེ༌ ཕུད༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ སོན༌པོ༌ དཀོན༌མཆོག༌, ཁོང༌ ཏུས༌གྱུན༌ ཞུགས༌ཁན༌, ཁོང༌ངི༌ གྱལ༌སྲིད༌ མ༌ནེ༌ མི༌ཞིག༌ ཡང༌ ཁོང༌ངི༌ ཝང༌སྲུལ༌ལ༌ ཐའ༌མ༌ མེད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN6_27","028_6_27","DAN","6","27","27","ཁོང༌ངི༌ ཁོང༌རང༌ངི༌ མི༌གུན༌ སྐྱོབ༌ཅེས༌ དང༌ ཐར༌ཅུག༌ག༌ ཛད༌ད༌ནོག༌, ཁོང༌ངི༌ ནམ༌ཁའ༌ དང༌ ས༌ཞི༌ཀ༌ སྟགས༌ དང༌ ལྟས༌ གུན༌ ཛད༌ད༌ནོག༌། ཁོང༌ངི༌ དཱ༌ནི༌ཨེལ༌ ཤེད༌ཅན༌ སིང༌གེ༌གུན༌ནི༌ ཀ༌ནེ༌ སྐྱོབ༌བ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN6_28","028_6_28","DAN","6","28","28","པར༌ཤིའ༌པ༌ གྱལ༌པོ༌ གྲ༌རི༌ཡས༌ དང༌ སཱེ༌རས༌སི༌ ཝང༌སྲུལ༌ལི༌ ཏུས༌ལ༌ དཱ༌ནི༌ཨེལ༌ མ༌ ཁྲངས༌པོ༌ ལུས༌ཏེ༌ ཡར༌གྱས༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_1","028_7_1","DAN","7","1","1","བ༌བེ༌ལོན༌ནི༌ གྱལ༌པོ༌ བེལ༌ཤའེ༌ཟར༌རི༌ ཝང༌སྲུལ༌ལི༌ གོ༌མའེ༌ ལོའེ༌ ནང༌ང༌ དཱ༌ནི༌ཨེལ༌ལ༌ ཉི༌ལམ༌ཞིག༌ ཐོང༌། ཁོ༌ མལ༌ཙའེ༌ཀ༌ ཡོད༌ ཟ༌ནེ༌ ཁོའ༌ ཞལ༌ཟིགས༌ཤིག༌ ཐོང༌ ཡང༌ ཁོའེ༌ ཏེ༌ ནང༌ང༌ ཐོང༌ཁན༌གུན༌ བྲིས༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_2","028_7_2","DAN","7","2","2","དཱ༌ནི༌ཨེལ༌ལི༌ བྲིས༌, “ཚན༌ལ༌ ངའ༌ ཐོང༌ཁན༌ནི༌ ཉི༌ལམ༌མི༌ ནང༌ང༌, ཆོགས༌ ཞི༌ཀོ༌ནེ༌ ལུངས༌པོ༌ ཀྲག༌པོ༌ ཡོངས༌ཏེ༌ གྱ༌ཚོའེ༌ ཆུ༌ སྲན༌ཏྲེ༌ སྲུག༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_3","028_7_3","DAN","7","3","3","གྱ༌ཚོའེ༌ ནང༌ནེ༌ ཇིགས༌ནང༌ཅན༌ནི༌ སེམས༌ཅན༌ ཞི༌ བིངས༌ཏེ༌ ཡོངས༌ ཡང༌ ཏེ༌གུན༌ སོ༌སོ༌, ཅིག༌གའང༌ ཙོགས༌ མི༌དུག༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_4","028_7_4","DAN","7","4","4","“སེམས༌ཅན༌ ཏང༌པོ༌ ལག༌གི༌ ཤོག༌པ༌ ཡོད༌ཁན༌ སིང༌གེ༌ ཙོགས༌ དུག༌པིན༌། ངའེ༌ ལྟེན༌ ཡོད༌ཏུས༌ ཏེ༌བོའེ༌ ཤོག༌པ༌ ཀོགས༌ཏེ༌ ཕེས༌ ཡང༌ ཏེ༌བོ༌ མི༌ ཙོགས༌ལ༌ གྱབ༌བི༌ ཀང༌པའེ༌ཀ༌ ལངས༌ཏེ༌ དུག༌ཅུགས༌། ཏེ༌བོའ༌ མི༌ ལྡད༌པ༌ ཏངས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_5","028_7_5","DAN","7","5","5","“སེམས༌ཅན༌ ཉིས༌པ༌ དྲེན༌མོ༌ ཙོགས༌, པིག༌མོའེ༌ཀ༌ ལངས༌ཏེ༌ སོའེ༌ པར༌ལ༌ རྩིབ༌མའེ༌ རུས༌པ༌ སུམ༌ ཁུར༌ཏེ༌ དུག༌པིན༌ ཡང༌ སྐད༌ཅིག༌གི༌ ཏེ༌བོའ༌, ‘ལོངས༌, མི༌ མང༌པོ༌ སད༌ཏེ༌ ཟའ༌ ཉན༌ཁན༌ ཟོ༌’ ཟེར༌ཁན༌བོ༌ ངའ༌ ཚོར༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_6","028_7_6","DAN","7","6","6","“ལྟེན༌ ཡོད༌ཏུས༌ སེམས༌ཅན༌ སུམ༌པ༌ བིང༌ཏེ༌ ཡོངས༌ ཡང༌ ཏེ༌བོ༌ ཤན༌ ཙོགས༌ དུག༌། ཏེ༌ སེམས༌ཅན༌ནི༌ གྱབ༌པོའེ༌ཀ༌ ཅི༌པའེ༌ ཤོག༌པ༌ ཞི༌ དང༌ གོ༌ ཞི༌ དུག༌ ཡང༌ ཏེ༌བོའ༌ ཝང༌སྲུལ༌ཅེས༌སི༌ ཝང༌ཆ༌ ཏངས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_7","028_7_7","DAN","7","7","7","“ཏེ༌ནེ༌ ངའ༌ སེམས༌ཅན༌ ཞི༌པ༌ ཐོང༌། ཏེ༌བོ༌ མ༌ ཇིགས༌ནང༌ཅན༌ དང༌ ཇིགས༌པ༌ ཡང༌ མ༌ ཤེད༌ཅན༌ དུག༌པིན༌། ཏེ༌བོའ༌ ལྕགས༌སི༌ སོ༌ ཆེན༌མོ༌ ཀ༌བོའེ༌ ཅི༌ཚང༌མ༌ ཅད༌ཏེ༌ སྟུབས༌ཏེ༌ ཟོས༌ཏེ༌ ལུས༌ཁན༌བོ༌ ཀང༌པའེ༌ ཐིལ༌ལ༌ ཉེས༌ཏེ༌ མེད༌ཁན༌ ཅོ༌ དུག༌པིན༌། ཞི༌པ༌བོ༌ ཞན༌གུན༌ནི༌ སང༌ སོ༌སོ༌, ཏེ༌བོའ༌ རཱ༌ཅོ༌ རྕུ༌ དུག༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_8","028_7_8","DAN","7","8","8","“ཏེ༌ རཱ༌ཅོ༌གུན༌ནི༌ སྐོར༌ལ༌ སམ༌བ༌ ཏང༌ཨིན༌ ཡོད༌ཏུས༌ ཏེ༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཡང༌ རཱ༌ཅོ༌ ཆུ༌ངུན༌ཞིག༌ བིང༌ཏེ༌ སྔུན༌ནི༌ རཱ༌ཅོ༌ སུམ༌བོ༌ པ༌ཀྲག༌ནེ༌ མེད༌ཁན༌ ཅོས༌། རཱ༌ཅོ༌ ཆུ༌ངུན༌བོའ༌ མི༌ ཙོགས༌སི༌ མིག༌ ཡང༌ ཕོ༌སོ༌ཅན༌ནི༌ སྤེ༌ར༌ ཏང༌ཁན༌ནི༌ ཁའ༌ དུག༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_9","028_7_9","DAN","7","9","9","“ལྟེན༌ ཡོད༌ཏུས༌, ཁྲིས༌གུན༌ ནས༌སའེ༌ཀ༌ བོརས༌ ཡང༌ ཏུས༌གྱུན༌ སོན༌པོ༌ ཞུགས༌ཁན༌བོ༌ ཁོང༌རང༌ངི༌ ཁྲིས༌སི༌ཀ༌ ཞུགས༌། ཁོང༌ངི༌ ནམ༌ཟ༌ ཁ༌ ཙོགས༌ ཀར༌པོ༌, ཁོང༌ངི༌ ཨུ༌སྲ༌ བལ༌ ཙོགས༌ ཀར༌པོ༌, ཁོང༌ངི༌ ཁྲིས༌ མེའེ༌ མེལ༌ཇབ༌ ཡང༌ ཏེ༌བོའེ༌ ཁོར༌ལོ༌གུན༌ མེའ༌ཞེན༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_10","028_7_10","DAN","7","10","10","ཁོང༌ངི༌ ནང༌ནེ༌ མེ༌ ལྩངས༌པོ༌ བིངས༌ཏེ༌ གྱུག༌དུག༌པིན༌། སྟོང༌ཁྲག༌ ཕོ༌ཉ༌གུན༌ནི༌ ཁོང༌ང༌ ཞབ༌ཞི༌ ཞུ༌ དུག༌པིན༌ ཡང༌ བུམ༌ཁྲག༌ མང༌པོའེ༌ ཁོང༌ང༌ ཁོར༌ཏེ༌ དུག༌པིན༌། ཁྲིམས༌ཁུང༌ངི༌ ལས༌ གོ༌ཟུག༌ ཡང༌ སྤེ༌ཆ༌གུན༌ ཕེས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_11","028_7_11","DAN","7","11","11","“ངའ༌ རཱ༌ཅོ༌ ཆུ༌ངུན༌ནི༌ ཕོ༌སོ༌ཅན༌ནི༌ སྤེ༌རའ༌ ཏང༌ཅེས༌པའེ༌ ངའེ༌ ཏེ༌བོའ༌ ལྟེན༌ དུགས༌པིན༌། ཏེ༌ ཇིགས༌ནང༌ཅན༌ནི༌ སེམས༌ཅན༌བོ༌ སད༌ཏེ༌ ཁོའེ༌ ཟུགས༌པོ༌ མེ༌ ནང༌ང༌ ཕངས༌ཏེ༌ མེད༌ཁན༌ ཅོ༌ཅོ༌ ང༌ ལྟེན༌ དུགས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_12","028_7_12","DAN","7","12","12","ཞན༌ ཇིགས༌ནང༌ཅན༌ནི༌ སེམས༌ཅན༌ སུམ༌ཀོའེ༌ ཝང༌ཆ༌གུན༌ ཀོགས༌ཏེ༌ ཁྱོངས༌ ཨིན༌ནའང༌ ཏེ༌གུན༌ ཏུས༌ བན༌ཤིག༌ སོན༌ཏེའ༌ བོར༌ར༌ ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","“ཏེ༌ ཚན༌ལ༌ ཞལ༌ཟིགས༌སི༌ ནང༌ང༌ ངའ༌ མི༌རིགས༌སི༌བུ༌ ཙོགས༌ཤིག༌ ནམ༌ཁའ༌ནེ༌ སྲིན༌གུན༌ནི༌ ནང༌ང༌ སྐྱོད༌ཨིན༌ ཐོང༌། ཁོང༌ ཏུས༌གྱུན༌ སོན༌པོ༌ ཞུགས༌ཁན༌བོའེ༌ཀ༌ སྐྱོདས༌ ཡང༌ ཁོང༌ ཁོང༌ངི༌ སྐུན༌དུན༌ལ༌ ཁྱེར༌ར༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","གྱལ༌ཁམས༌, སྐད༌ དང༌ མི༌ ཚང༌མའེ༌ ཅོལ༌ཅེས༌སི༌ ཕིའ༌ ཁོང༌ངི༌ མི༌རིགས༌སི༌བུའ༌ ཝང༌ཆ༌, སྤལ༌ དང༌ གྱལ༌པོའེ༌ ཝང༌ཆ༌ སལ༌ལ༌ ཛདས༌། ཁོང༌ངི༌ ཝང༌སྲུལ༌ ཏུས༌གྱུན༌ ལུས༌ཨིན༌, མེད༌ཁན༌ མི༌ཆ༌ ཡང༌ ཁོང༌ངི༌ གྱལ༌སྲིད༌ མེད༌ཁན༌ མ༌ནེ༌ ཅོ༌ མི༌ཉན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_15","028_7_15","DAN","7","15","15","“ང༌ དཱ༌ནི༌ཨེལ༌ལ༌ སེམས༌ཉིད༌དི༌ ནང༌ང༌ མ༌སྲན༌ཏྲེ༌ ནགས༌ ཐོང༌ ཡང༌ ཞལ༌ཟིགས༌སི༌ ངའེ༌ སེམས༌ལ༌ རྡུག༌ངལ༌ ཐོང༌ ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_16","028_7_16","DAN","7","16","16","ཏེ༌ཀ༌ ཞུགས༌ཏེ༌ ཡོད༌ཁན༌ ཕོ༌ཉ༌ ཅིག༌གི༌ དུན༌ལ༌ ངའ༌ སོང༌ཏེ༌ འི༌ ཚང༌མའེ༌ ཏོན༌ ཏྲིས༌པིན༌། “ཁོང༌ངི༌ ང༌ ཏེ༌གུན༌ནི༌ ཏོན༌ ཤད༌ད༌ ཛདས༌, ");
INSERT INTO lbj_vpl VALUES ("DN7_17","028_7_17","DAN","7","17","17","‘ཇིགས༌ནང༌ཅན༌ནི༌ སེམས༌ཅན༌ ཞི༌ ནི༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཇུང༌ཅེས༌ཅན༌ གྱལ༌སྲིད༌ ཞི༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_18","028_7_18","DAN","7","18","18","ཨིན༌ནའང༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ཏམ༌པ༌ མི༌གུན༌ལ༌ ཁོ༌རང༌གུན༌ནི༌ གྱལ༌སྲིད༌ ཏང༌ཨིན༌ ཡང༌ ཏེ༌བོ༌ ཁོང༌གུན༌ནི༌ ལག༌ག༌ ཏུས༌གྱུན༌ནེ༌གྱུན༌ ལུས༌ཨིན༌, འོ༌ན༌ ཏུས༌གྱུན༌ནེ༌གྱུན༌།’” ");
INSERT INTO lbj_vpl VALUES ("DN7_19","028_7_19","DAN","7","19","19","“ཏེ༌ནེ༌ ང༌ སེམས༌ཅན༌ ཞི༌པ༌ ཀ༌བོ༌ ཞན༌གུན༌ནི༌ སང༌ སོ༌སོ༌, མ༌ ཇིགས༌ནང༌ཅན༌, ལྕགས༌སི༌ སོ༌ དང༌ ཀང༌པའེ༌ སེན༌མོ༌གུན༌ ཟངས༌སི༌ ཡོད༌ཁན༌བོའེ༌ ཏོན༌བོ༌ ཧ༌གོ༌ཉིན༌ ཡོད༌པིན༌། ཏེ༌བོའེ༌ ཅི༌ཚང༌མ༌ ཅད༌ཏེ༌ སྟུབས༌ཏེ༌ ཟོས༌ཏེ༌ ལུས༌ཁན༌བོ༌ ཀང༌པའེ༌ ཐིལ༌ལ༌ ཉེས༌ཏེ༌ མེད༌ཁན༌ ཅོ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_20","028_7_20","DAN","7","20","20","ཏེ༌བོའེ༌ གོའེ༌ཀ༌ ཡོད༌ཁན༌ རཱ༌ཅོ༌ རྕུ༌ ཡང༌ ར༌ཅོ༌ ཆུ༌ངུན༌ བིང༌ཏེ༌ ཞན༌ རཱ༌ཅོ༌ སུམ༌ མེད༌ཁན༌ ཅོ༌ཁན༌, མི༌ མིག༌ ཙོགས༌ དང༌ ཕོ༌སོ༌ཅན༌ནི༌ སྤེ༌ར༌ ཏང༌ཁན༌ནི༌ ཏོན༌བོའང༌ ངའ༌ ཧ༌གོ༌ཉིན༌ ཡོད༌པིན༌། ཏེ༌བོ༌ ཞན༌གུན༌ནི༌ སང༌ མང༌ང༌ ཇིགས༌ནང༌ཅན༌ ཡོད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_21","028_7_21","DAN","7","21","21","ལྟེན༌ ཡོད༌ཏུས༌ ཏེ༌ རཱ༌ཅོའེ༌ དཀོན༌མཆོག༌གི༌ ཏམ༌པ༌ མི༌གུན༌ ཉམ༌པོ༌ མག༌ ཏངས༌ཏེ༌ ཁོང༌གུན༌ལ༌ ཕམ༌ ཀལ༌ལད༌པིན༌, ");
INSERT INTO lbj_vpl VALUES ("DN7_22","028_7_22","DAN","7","22","22","ནམ༌ ཚོག༌པ༌ ཏུས༌གྱུན༌ སོན༌པོ༌ ཞུགས༌ཁན༌བོ༌ སྐྱོད༌ཏེ༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ཏམ༌པ༌ མི༌གུན༌ནི༌ ཆོག༌སྐྱོར༌ལ༌ ཐག༌ཅད༌ མ༌སལས༌། ཏེ༌ནེ༌ ཁོང༌གུན༌ནི༌ གྱལ༌སྲིད༌ ལེན༌ཅེས༌སི༌ ཏུས༌པོ༌ ལེབ༌།” ");
INSERT INTO lbj_vpl VALUES ("DN7_23","028_7_23","DAN","7","23","23","“ཁོང༌ངི༌ ང༌ ཏོན༌བོ༌ ཤད༌ད༌ ཛདས༌, ‘སེམས༌ཅན༌ ཞི༌པ༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཇུང༌ཅེས༌ཅན༌ གྱལ༌སྲིད༌ ཞི༌པ༌བོ༌ ཨིན༌ནོག༌། ཏེ༌བོ༌ ཞན༌ གྱལ༌སྲིད༌གུན༌ནི༌ སང༌ སོ༌སོ༌ ཡང༌ ཏེ༌བོའེ༌ ཇིག༌རྟེན༌ གང༌པོ༌ ཅད༌ཏེ༌ སྟུབས༌ཏེ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_24","028_7_24","DAN","7","24","24","རཱ༌ཅོ༌ རྕུ༌བོ༌ ཏེ༌ གྱལ༌སྲིད༌དི༌ ནང༌ནེ༌ བིང༌ཁན༌ གྱལ༌པོ༌ རྕུ༌ ཨིན༌ནོག༌། ཁོང༌གུན༌ནི༌ སྟིང༌ནེ༌ ཞན༌ གྱལ༌པོ༌ སོ༌སོ༌ཞིག༌ བིང༌ཨིན༌ ཀ༌བོའེ༌ ཁོང༌གུན༌ནི༌ ཕྲོ༌ནེ༌ སུམ༌མ༌ ཕམ༌ཀལ༌ཏེ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_25","028_7_25","DAN","7","25","25","ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ གྱབ༌གལ༌ལ༌ ཟེར༌ཏེ༌ ཁོའེ༌ ཁོང༌ངི༌ ཏམ༌པ༌ མི༌གུན༌ལ༌ ནགས༌ སྟན༌ཨིན༌ ཡང༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ ཏུས༌ དང༌ ཁྲིམས༌ གུན༌ གྱུར༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོ༌ཨིན༌། ཏམ༌པ༌ མི༌གུན༌ ཁོའེ༌ ལག༌ག༌ སྟད༌ད༌ ཛད༌ཨིན༌ ཡང༌ ཁོའེ༌ ཁོང༌གུན༌ ལོ༌ སུམ༌ ནང༌ ཕེད༌ ཁོ༌རང༌ངི༌ ཝང༌ངི༌ ཡོག༌ག༌ བོར༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("DN7_26","028_7_26","DAN","7","26","26","“‘ཨིན༌ནའང༌ ནམ༌ཁའེ༌ ཁྲིམས༌ཁུང༌ ཙུགས༌ཏེ༌ ཁོའེ༌ ཀ༌ནེ༌ ཝང༌བོ༌ ཁྱེར༌ཏེ༌ ཏུས༌གྱུན༌ནི༌ ཕིའ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN7_27","028_7_27","DAN","7","27","27","ཏེ༌ནེ༌ ནམ༌ཁའེ༌ ཡོག༌ག༌ ཡོད༌ཁན༌ གྱལ༌སྲིད༌གུན༌ནི༌ ཝང༌, ཁྱུད༌ དང༌ སྟོབས༌ ཚང༌མ༌, ཀུན༌ཝང༌ དཀོན༌མཆོག༌གི༌ ཏམ༌པ༌ མི༌གུན༌ནི༌ ལག༌ག༌ སལ༌ལ༌ ཛད༌ཨིན༌། ཁོང༌ངི༌ གྱལ༌སྲིད༌ ཏུས༌གྱུན༌ནེ༌གྱུན༌ ལུས༌ཨིན༌ ཡང༌ ཝང༌སྲུལ༌པ༌ ཚང༌མའེ༌ ཁོང༌ངི༌ ཁའ༌ཉན༌ཏེ༌ ཁོང༌ང༌ ཞབས༌ཏོག༌ ཞུ༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("DN7_28","028_7_28","DAN","7","28","28","“ཞལ༌ཟིགས༌པོའེ༌ ནང༌ང༌ ངའ༌ ཏེན༌ན༌བོ༌ ཐོང༌། ང༌, དཱ༌ནི༌ཨེལ༌ལི༌ སེམས༌ལ༌ སྲན༌ཏྲེ༌ ནགས༌ ཐོང༌ ཡང༌ ངའེ༌ ལྡོང༌ སེར༌པོ༌ གྱུར༌ ཨིན༌ནའང༌ ངའེ༌ ཏེ༌ ཞལ༌ཟིགས༌པོ༌ སུའང༌ མ༌ཤད༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN8_1","028_8_1","DAN","8","1","1","གྱལ༌པོ༌ བེལ༌ཤའེ༌ཟར༌རི༌ ཝང༌སྲུལ༌ལི༌ ལོ༌ སུམ༌པའེ༌ ནང༌ང༌ ང༌, དཱ༌ནི༌ཨེལ༌ལ༌ ཡང༌སྐྱར༌ ཞལ༌ཟིགས༌ཤིག༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_2","028_8_2","DAN","8","2","2","ཏེ༌ ཞལ༌ཟིགས༌པོའེ༌ ནང༌ང༌ ང༌ ཨེ༌ལམ༌ ཡུལ༌ཇོངས༌སི༌ གྱང༌སྐོར༌ ཐོན༌པོ༌ ཡོད༌སའེ༌ གྱལ༌ས༌ སུ༌སཱའེ༌ ནང༌ང༌ ཨུ༌ལཱའེ༌ ཡུ༌རའེ༌ ཐའ༌མའ༌ ལངས༌ཏེ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_3","028_8_3","DAN","8","3","3","ངའེ༌ ཀེན༌ལ༌ ལྟའ༌ཅིག༌ ངའ༌ རཱ༌ཅོ༌ རིང༌མོ༌ ཉིས༌ ཡོད༌ཁན༌ ལུག༌ཕོ༌ཞིག༌ ཡུ༌རའེ༌ ཐའ༌མའ༌ ལངས༌ཏེ༌ ཐོང༌། སྟིང༌ནེ༌ སྐྱེ༌ཁན༌ནི༌ རཱ༌ཅོ༌ སྔུན༌ལ༌ སྐྱེ༌ཁན༌བོའེ༌ སང༌ རིང༌ང༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_4","028_8_4","DAN","8","4","4","ལུག༌ཕོ༌བོའེ༌ ནུབ༌, བྱང༌ དང༌ ལྷོ༌ ཆོགས༌ ཚང༌མ༌ ནོལ༌ཅེས༌ལ༌ གྱུགས༌ ཡང༌ ཁོའེ༌ དུན༌ལ༌ སེམས༌ཅན༌ ཅིག༌གའང༌ ལངས༌ མ༌ཉན༌ ཡ༌ མ༌སྐྱོན༌ ཆ༌ཅེས༌ནེ༌ སྐྱོབ༌ མ༌ཉན༌། ཏེ༌ ལུག༌ཕོ༌བོའེ༌ ཁོ༌རང༌ ཐད༌ཁན༌བོ༌ ཅོས༌ ཡང༌ ཀྲག༌པོ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_5","028_8_5","DAN","8","5","5","ངའེ༌ ཏེ༌བོ༌ ལྟེན༌ ཡོད༌ ཟ༌ནེ༌ ཧུན༌མེད༌ལ༌ མིག༌གུན༌ནི༌ པར༌ལ༌ རཱ༌ཅོ༌ ཆེན༌མོ༌ ཡོད༌ཁན༌ནི༌ ར༌བོ༌ཞིག༌ ནུབ༌ ཆོགས༌ནེ༌ བིང༌ཏེ༌ རྐང༌པ༌ སའ༌ མ༌ཐུག༌ཁན༌ ཙོགས༌ འི༌ཟམ༌ གྱོགས༌པ༌ ཇིག༌རྟེན༌ གང༌པོའེ༌ཀ༌ བང༌ཏང༌ཨིན༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_6","028_8_6","DAN","8","6","6","ཁོ༌ ངའ༌ ཡུ༌རའེ༌ དུན༌ལ༌ ལངས༌ཏེ༌ ཐོང༌ཁན༌ རཱ༌ཅོ༌ ཉིས༌ ཡོད༌ཁན༌ནི༌ ལུག༌ཕོ༌ ཡོད༌ས༌ གྱུགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_7","028_8_7","DAN","8","7","7","ར༌བོའེ༌ ལུག༌ཕོ༌བོའ༌ གོ༌ཙུག༌ སྲན༌ཏྲེ༌ ཏངས༌ཏེ༌ ཁོའེ༌ རཱ༌ཅོ༌ ཉིས༌ཀོ༌ ཅགས༌། ལུག༌ཕོ༌ ཤེད༌མེད༌ གྱུར༌ཏེ༌ ར༌བོའེ༌ གྱབ༌གལ༌ལ༌ ནོལ༌ མ༌ཉན༌། ར༌བོའེ༌ ལུག༌ཕོ༌ སའེ༌ཀ༌ ལྡབས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཀང༌པའེ༌ ཡོག༌ག༌ ནནས༌ ཡང༌ སུའང༌ ཁོ༌ ར༌བོའེ༌ ཀ༌ནེ༌ སྐྱོབ༌ མ༌ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_8","028_8_8","DAN","8","8","8","ར༌བོ༌ མ༌ ཤེད༌ཅན༌ གྱུར༌ ཡང༌ ཁོའེ༌ ཝང༌སྲུལ༌བོ༌ ཚང༌མའེ༌ སང༌ ཤེད༌ཅན༌ ཡོད༌དི༌ ཏུས༌ལ༌ ཁོའེ༌ རཱ༌ཅོ༌ ཆག༌། ཏེ༌བོའེ༌ ཚབས༌ལ༌ ཇིག༌རྟེན༌ནི༌ ཆོགས༌ ཞི༌ཀོ༌ ཆོགས༌ལ༌ ཆའ༌ཁན༌ནི༌ རཱ༌ཅོ༌ ཤེད༌ཅན༌ ཆེན༌མོ༌ ཞི༌ སྐྱེས༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_9","028_8_9","DAN","8","9","9","ཏེན༌ན༌ ཅིག༌གི༌ ནང༌ནེ༌ ཡང༌ རཱ༌ཅོ༌ ཆུ༌ངུན༌ཞིག༌ བིང༌ ཀ༌བོ༌ ཤར༌ དང༌ ནུབ༌ ཡང༌ ལྡེ༌མོ༌ ས༌ཀྱད༌ ཡང༌ན༌ ཨིས༌ར༌ཨེལ༌ གུན༌ ཆོགས༌ལ༌ མ༌ ཤེད༌ཅན༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_10","028_8_10","DAN","8","10","10","ཏེ༌བོའེ༌ ཤེད༌པོ༌ ནམ༌ཁའ༌ ཚག༌པ༌ ལེབ༌ ཡང༌ ཁོའེ༌ ནམ༌ཁའེ༌ མག༌མི༌ དང༌ སྐར༌མ༌ ཁ༌ཅིག༌ ཇིག༌རྟེན༌ནི༌ཀ༌ ཕངས༌ཏེ༌ ཀང༌པའེ༌ ཡོག༌ག༌ ནནས༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_11","028_8_11","DAN","8","11","11","ཁོའེ༌ ནམ༌ཁའེ༌ མག༌མི༌ གྱལ༌ལུའི༌ སང༌ ཁོ༌རང༌ ཀྲག༌ག༌ ཐེས༌ཏེ༌ ཁོང༌ང༌ ཕུལ༌ཁན༌ནི༌ ཆོད༌པ༌གུན༌ ཕུལ༌ མ༌ཅུགས༌ ཡང༌ ཆོད༌ཁང༌ངི༌ ནས༌ས༌ ཚི༌ཏུ༌ གྱུར༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_12","028_8_12","DAN","8","12","12","ཏེ༌བོའེ༌ ཞས༌ཏེ༌ ནམ༌ཁའེ༌ མག༌མི༌གུན༌ ཁོའེ༌ ལག༌ག༌ སྟད༌ཏེ༌ ཆོད༌པ༌གུན༌ ཁོའ༌ ཕུལ༌ཅུག༌ག༌ ཛདས༌། ཁོ༌ ཅི༌ ཚང༌མའེ༌ ནང༌ང༌ ཡར༌གྱས༌ ཅོ༌ཨིན༌ སོང༌ཏེ༌ ཀྲང༌པོ༌ ལས༌གུན༌ མེད༌ཁན༌ ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_13","028_8_13","DAN","8","13","13","ཏེ༌ནེ༌ ང༌ ཏམ༌པ༌ ཕོ༌ཉ༌ ཉིས༌སི༌ ཞལ༌ཏ༌ སལ༌ཨིན༌ ཚོར༌། ཁོང༌ ཅིག༌པོའེ༌ ཞན༌ ཅིག༌པོའ༌ མོལས༌, “འི༌ ཞལ༌ཟིགས༌པོ༌ གྲུབ༌ཅེས༌ལ༌ ཏུས༌ ཙམ༌ཤིག༌ གོར༌ཅེས༌ ཨིན༌ནོག༌? ནམ༌ ཚག༌པ༌ དཀོན༌མཆོག༌ག༌ གྱབ༌གལ༌ ཅོ༌ཁན༌བོའེ༌ ཆོད༌ཁང༌ངི༌ ནང༌ང༌ ཚི༌ཏུ༌ བོར༌ཏེ༌ བླ༌མ༌གུན༌ལ༌ ཆོད༌པ༌ ཕུལ༌ མི༌ཅུག༌? ཁོའེ༌ ནམ༌ཁའེ༌ མག༌མི༌གུན༌ ཀང༌པའེ༌ ཡོག༌ག༌ བོར༌ཏེ༌ ཆོད༌ཁང༌ ཁོའེ༌ ཝང༌ངི༌ ཡོག༌ག༌ ནམ༌ ཚོག༌པ༌ ལུས༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("DN8_14","028_8_14","DAN","8","14","14","ཞན༌ ཏམ༌པ༌ ཕོ༌ཉ༌བོའེ༌ མོལས༌, “2,300 ང༌མོ༌ དང༌ ཕི༌ཏོག༌གི༌ སྟིང༌ནེ༌ ཆོད༌ཁང༌ ཡང༌སྐྱར༌ ཏམ༌པ༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN8_15","028_8_15","DAN","8","15","15","ང༌, དཱ༌ནི༌ཨེལ༌ལི༌ ཞལ༌ཟིགས༌པོ༌ ཧ༌གོ༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོ༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ ངའེ༌ དུན༌ལ༌ མི༌ ཙོགས༌ ཐོང༌ཁན༌ནི༌ ཕོ༌ཉ༌ཞིག༌ ཞངས༌ཏེ༌ ཞུགས༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_16","028_8_16","DAN","8","16","16","ཡང༌ ངའ༌ ཨུ༌ལཱའེ༌ ཡུ༌རའེ༌ ནང༌ནེ༌, “གྱེབ༌རི༌ཨེལ༌ འི༌ མི༌བོའ༌ ཞལ༌ཟིགས༌སི༌ ཏོན༌བོ༌ ཤོད༌” མོལ༌ཨིན༌ ཚོར༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_17","028_8_17","DAN","8","17","17","ཁོང༌ ངའེ༌ དུན༌ལ༌ སྐྱོད༌ ཟ༌ནེ༌ ང༌ སྲན༌ཏྲེ༌ ཇིགས༌ཏེ༌ སའེ༌ཀ༌ གྱེལ༌ ཨིན༌ནའང༌ ཁོང༌ངི༌ ང༌ མོལས༌, “མིའི༌ ཕྲུ༌གུ༌, འི༌ ཞལ༌ཟིགས༌ ཐའ༌མའེ༌ ཏུས༌སི༌ སྐོར༌ལ༌ ཨིན༌ཁན༌ ཁོ༌རང༌ང༌ ཧ༌གོ༌ གོས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN8_18","028_8_18","DAN","8","18","18","ཁོང༌ངི༌ ཞལ༌ཏ༌ སལ༌ ཟ༌ནེ༌ ང༌ མུན༌ཏེ༌ སའེ༌ཀ༌ གྱེལ༌། ཏེ༌ནེ༌ ཁོང༌ངི༌ ཆག༌རྩེའ༌ ཛད༌ཏེ༌ ང༌ ལང༌ཅེས༌ལ༌ རོགས༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_19","028_8_19","DAN","8","19","19","ཁོང༌ངི༌ མོལས༌, “དཀོན༌མཆོག༌ག༌ ཐུག༌སྲོ༌ སྐྱོད༌དི༌ ཏུས༌ལ༌ ཇུང༌ཅེས༌ཅན༌གུན༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཤད༌ཨིན༌། འི༌གུན༌ ཇིག༌རྟེན༌ནི༌ ཐའ༌མའེ༌ ཏུས༌ལ༌ ཇུང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_20","028_8_20","DAN","8","20","20","རཱ༌ཅོ༌ ཉིས༌ ཡོད༌ཁན༌ནི༌ ལུག༌ཕོ༌ ནི༌ མེ༌དིའ༌པ༌ དང༌ པར༌ཤིའ༌པ༌ གྱལ༌པོ༌གུན༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_21","028_8_21","DAN","8","21","21","ར༌བོ༌ གརིས༌སི༌ གྱལ༌སྲིད༌ ཡང༌ ཁོའེ༌ མིག༌གུན༌ནི༌ པར༌རི༌ རཱ༌ཅོ༌ གྱལ༌པོ༌ ཏང༌པོ༌བོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_22","028_8_22","DAN","8","22","22","ཏེ༌བོའེ༌ ཚབས༌ལ༌ རཱ༌ཅོ༌ ཞི༌ སྐྱེ༌ཁན༌ནི༌ ཏོན༌བོ༌, ཏེ༌ གྱལ༌སྲིད༌པོའ༌ ཁག༌ ཞི༌ བུད༌ཅེས༌ ཨིན༌ནའང༌ ཁོང༌ ཅིག༌གའང༌ གྱལ༌པོ༌ ཏང༌པོ༌ ཙོགས༌ ཀྲག༌པོ༌ མི༌ཡོང། ");
INSERT INTO lbj_vpl VALUES ("DN8_23","028_8_23","DAN","8","23","23","ཏེ༌ ཝང༌སྲུལ༌ལི༌ སྟིང༌ཇུག༌གི༌ ཏུས༌ ནམ༌ ངན༌པ༌ ཚད༌ནེ༌ ཐལ༌ཏེ༌ གྱས༌ས༌ཅིག༌ གོབ༌སྐོར༌ཁན༌, ཕོ༌སོ༌ཅན༌ མ༌ ངན༌པ༌ གྱལ༌པོ༌ཞིག༌ བིང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_24","028_8_24","DAN","8","24","24","ཁོ༌ མ༌ ཤེད༌ཅན༌ གྱུར༌ཨིན༌ ཨིན༌ནའང༌ ཁོ༌རང༌ངི༌ ཁྱུད༌དི༌ ཞས༌ཏེ༌ མི༌གྱུར༌། ཁོའེ༌ གྱལ༌སྲིད༌ མང༌པོ༌ ཁྲེས༌ཏོར༌ ཅོ༌ཨིན༌ ཡང༌ ཁོའེ༌ ཅོ༌ཁན༌ནི༌ ལས༌ ཚང༌མའེ༌ ནང༌ང༌ ཁོ༌ ཁྲངས༌པོ༌ ལུས༌ཨིན༌། ཁོའེ༌ ཤེད༌ཅན༌ མི༌གུན༌ དང༌ དཀོན༌མཆོག༌གི༌ ཏམ༌པ༌ མི༌གུན༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN8_25","028_8_25","DAN","8","25","25","ཁོའེ༌ ངན༌པ༌ ཏར༌ ཅུགས༌ཏེ༌ ཁོ༌ མ༌ ཕོ༌སོ༌ཅན༌ གྱུར༌ཨིན༌། ཞི༌དེ༌ ཡོད༌དི༌ ཏུས༌ ཧུན༌མེད༌ལ༌ ཁོའེ༌ མི༌མང༌པོ༌ སད༌ཏེ༌ གྱལ༌པོ༌གུན༌ནི༌ གྱལ༌པོའ༌ གྱབ༌གལ༌ ཅོ༌ཨིན༌། ཨིན༌ནའང༌ མི༌ ཤེད༌ གྱུད༌ཏེ༌ མན༌པ༌ དཀོན༌མཆོག༌ ཁོང༌རང༌ངི༌ ཁོ༌ མེད༌ཁན༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN8_26","028_8_26","DAN","8","26","26","“ང༌མོ༌ དང༌ ཕི༌ཏོག༌གི༌ ཞལ༌ཟིགས༌ ཐོང༌ཁན༌བོ༌ ཀྲང༌པོ༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ ཏེ༌བོ༌ ཏུས༌རིང༌མོའེ༌ སྟིང༌ནེ༌ མན༌ནེ༌ ཇུང༌ཅེས༌ མན༌ པ༌སང༌ ཏེ༌བོ༌ སང༌ཝའེ༌ ནང༌ང༌ བོར༌།” ");
INSERT INTO lbj_vpl VALUES ("DN8_27","028_8_27","DAN","8","27","27","ང༌, དཱ༌ནི༌ཨེལ༌ མ༌ སྲན༌ཏྲེ༌ ངལ༌ ཡང༌ ཞག༌ ཁ༌ཅིག༌ ཟུ༌མོ༌ ཡོངས༌ཏེ༌ ལུས༌། ཟུ༌མོ༌ གྱལ༌ཏེ༌ སྟིང༌ནེ༌ ངའེ༌ ཡང༌སྐྱར༌ གྱལ༌པོའེ༌ ཞབ༌ཞི༌ ཞུ༌ཅེས༌ གོ༌ཟུག༌ ཅོས༌པིན༌། ཏེ༌ ཞལ༌ཟིགས༌པོའེ༌ ང༌ ཧ༌ལས༌ཏེ༌ ཐེ༌ཚོམས༌ ཆ༌ཅུགས༌ ཡང༌ ཏེ༌བོ༌ ངའེ༌ ཧ༌གོ༌ནེ༌ ཐལ༌ཏེ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_1","028_9_1","DAN","9","1","1","བ༌བེ༌ལོན༌ནི༌ ནང༌ང༌ ཟེརཀ༌སེས༌སི༌ བུ༌ཚ༌ མེ༌དིའ༌པ༌ གྲ༌རི༌ཡས༌ གྱལ༌པོའེ༌ ཝང༌སྲུལ༌ལི༌ གོ༌མའེ༌ ལོའེ༌ ནང༌ང༌ ");
INSERT INTO lbj_vpl VALUES ("DN9_2","028_9_2","DAN","9","2","2","ལུང༌སྟོན༌པ༌ ཡེ༌རེམ༌ཡཱའི༌ གྱུད༌ཏེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌གི༌ སལ༌ཁན༌ བཀའ༌ ནང༌ཞིན༌ ཡེ༌རུ༌ཤ༌ལེམ༌ ཁྲེས༌ཏོར༌ སོང༌ཏེ༌ ལོ༌ རྡུན༌ཅུ༌ སྟོང༌པ༌ ལུས༌ཤེས༌པོ༌ ང༌ དཱ༌ནི༌ཨེལ༌ལ༌ ཧ༌གོ༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_3","028_9_3","DAN","9","3","3","ཏེ༌ནེ༌ ངའེ༌ ཉེ༌ནས༌ བོར༌ཏེ༌, ཕ༌ཙའ༌ གོན༌ཏེ༌ ཀོག༌ཐལ༌ ཡོགས༌ཏེ༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ ཞུ༌ཝ༌ ཕུལ༌ཨིན༌ མོས༌ལམ༌ ཞུས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_4","028_9_4","DAN","9","4","4","ངའེ༌ མོས༌ལམ༌ ཞུ༌ཨིན༌ ང༌ཞའེ༌ སྡིག༌པ༌ ཅོ༌ཁན༌གུན༌ ཡ༌ཝའ༌ ཤད༌ཏེ༌ ཟེར༌པིན༌, “གཙོ༌བོ༌ལེ༌ ཉེ༌རང༌ ཀྲག༌པོ༌ དང༌ ཁྱུད༌ཅན༌, ཆད༌དོན༌ ཛད༌ཁན༌ནི༌ ནང༌ང༌ ཨིད༌ཤེས༌ཅན༌ ཡང༌ ཉེ༌རང༌ངི༌ བཀའ༌རྒྱ༌ ཁའ༌ཉན༌ཏེ༌ ཉེ༌རང༌ང༌ ཡ༌ཤ༌ ཅོ༌ཁན༌གུན༌ལ༌ ཉེ༌རང༌ངི༌ ཏུས༌གྱུན༌ ཡ༌ཤ༌ ཛད༌ཅེས༌ ཁ༌ཆད༌ ཛད༌དུག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_5","028_9_5","DAN","9","5","5","ང༌ཞའེ༌ སྡིག༌པ༌ དང༌ ངན༌པ༌ ཡང༌ ཉེ༌རང༌ངི༌ གྱབ༌གལ༌ ཅོས༌ཏེ༌ ཉེ༌རང༌ངི༌ བཀའ༌ ཏང༌ ཁྲིམས༌ གུན༌ ཕངས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_6","028_9_6","DAN","9","6","6","ཉེ༌རང༌ངི༌ ལུང༌སྟོན༌པ༌གུན༌ གྱུད༌ཏེ༌ ང༌ཞའེ༌ གྱལ༌པོ༌, གྱལ༌ལུ༌, ཕ༌མེས༌པོ༌ དང༌ མི༌ ཚང༌མ༌ལ༌ མོལ༌ལ༌ ཛད༌ཁན༌ ཚང༌མ༌ ང༌ཞའེ༌ མ༌ཉནས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN9_7","028_9_7","DAN","9","7","7","“གཙོ༌བོ༌ ཉེ༌རང༌ངི༌ ཐག༌ཅད༌ ཀྲང༌པོ༌ ཨིན༌ནའང༌ ཉེ༌རང༌ ཉམ༌པོ༌ ཨིད༌ཤེས༌ཅན༌ མི༌དུག༌ཅེས༌པའེ༌ འི༌ཏུས༌ལ༌ ང༌ཞའ༌ ཡ༌ཧུ༌དཱ༌པ༌, ཡེ༌རུ༌ཤ༌ལེམ༌པ༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མ༌, ཉེ༌མོ༌ དང༌ ཐག༌རིང༌ ཡང༌ ང༌ཞའ༌ ཕེའ༌ ཛད༌ཁན༌ནི༌ ཡུལ༌ ཚང༌མའེ༌ ནང༌ང༌ ཁྲེལ༌བ༌ སོང༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_8","028_9_8","DAN","9","8","8","གཙོ༌བོ༌ལེ༌ ཉེ༌རང༌ངི༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཅོ༌ཅེས༌པའེ༌ ང༌ཞའ༌, ང༌ཞའེ༌ གྱལ༌པོ༌, གྱལ༌ལུ༌ དང༌ ཕ༌མེས༌པོ༌ ཚང༌མ༌ ཁྲེལ༌བའེ༌ གང༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_9","028_9_9","DAN","9","9","9","ང༌ཞའེ༌ ཉེ༌རང༌ངི༌ གྱབ༌གལ༌ ཅོ༌ནའང༌ གཙོ༌བོ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ ཉེ༌རང༌ སྙིང༌རྗེའེ༌ དང༌ ཤགས༌པ༌ ཛད༌ཁན༌ ཞུགས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_10","028_9_10","DAN","9","10","10","ཡ༌ཝ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌ ཉེ༌རང༌ངི༌ ཁའ༌ ང༌ཞའེ༌ མ༌ཉན༌ན༌ ཡང༌ ཉེ༌རང༌ངི༌ ལུང༌སྟོན༌པ༌གུན༌ གྱུད༌ཏེ༌ སལ༌ཁན༌ནི༌ ཁྲིམས༌གུན༌ མ༌ སྲུང༌ང༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_11","028_9_11","DAN","9","11","11","ཨིས༌ར༌ཨེལ༌པ༌ ཚང༌མའེ༌ ཉེ༌རང༌ངི༌ ཁྲིམས༌ ཅགས༌ཏེ༌ ཉེ༌རང༌ནེ༌ ཐག༌རིང༌ང༌ སོང༌ཏེ༌ ཉེ༌རང༌ངི༌ ཁའ༌ མ༌ཉན༌ན༌ ཨིན༌ནོག༌།” “ཏེ༌བོའེ༌ཕིའ༌ ཉེ༌རང༌ངི༌ ཞབས༌ཏོག༌པ༌ མོ༌ཟེས༌སི༌ ཁྲིམས༌སི༌ ནང༌ང༌ བྲིས༌ཁན༌ནི༌ ངན༌ དང༌ ཆད༌པ༌ གུན༌ ང༌ཞའེ༌ཀ༌ བབས༌ཏེ༌ ཨིན༌ནོག༌ ཅིའ༌ཟེར༌ན༌ ང༌ཞའེ༌ ཉེ༌རང༌ངི༌ གྱབ༌གལ༌ལ༌ སྡིག༌པ༌ ཅོས༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_12","028_9_12","DAN","9","12","12","ཉེ༌རང༌ངི༌ ང༌ཞའེ༌ ཝང༌སྲུལ༌པ༌ དང༌ ང༌ཞ༌གུན༌ནི༌ཀ༌ ཆད༌པ༌ ཀྲག༌པོ༌ སལ༌ཏེ༌ ཉེ༌རང༌ངི༌ ང༌ཞའེ༌ གྱབ༌གལ༌ལ༌ མོལ༌ཁན༌བོ༌ གྲུབ༌ཅུག༌ག༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌། ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌སའ༌ ཛད༌ཁན༌ ཙོགས༌ ནམ༌ཁའེ༌ ཡོག༌ག༌ ཡོད༌ཁན༌ ཀ༌རུའང༌ མ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_13","028_9_13","DAN","9","13","13","མོ༌ཟེས༌སི༌ ཁྲིམས༌སི༌ ནང༌ང༌ བྲིས༌ཁན༌ ནང༌ཞིན༌ ཏེ༌ རྡུག༌ངལ༌ ཚང༌མ༌ ང༌ཞའེ༌ཀ༌ བབས༌ཏེ༌ ཨིན༌ནོག༌ ཏེ༌ནེའང༌ ང༌ཞའེ༌ སྡིག༌པ༌གུན༌ ཕངས༌ཏེ༌ ཉེ༌རང༌ ཆོགས༌ལ༌ སེམས༌ གྱུར༌ཏེ༌ ཉེ༌རང༌ངི༌ ཀྲང༌པོ༌ ལམ༌མི༌ཀ༌ མ༌གྲུལས༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_14","028_9_14","DAN","9","14","14","ཏེན༌ན༌བོའེ༌ཕིའ༌ ཡ༌ཝ༌ ཉེ༌རང༌ངི༌ གྲལ༌གྲིག༌ ཛད༌ཁན༌ ཀྲག༌པོ༌ རྡུག༌ངལ༌ ང༌ཞའེ༌ཀ༌ ཁྱོང༌ང༌ ཛདས༌ ཅིའ༌ཟེར༌ན༌ དཀོན༌མཆོག༌གི༌ འོས༌པ༌ ཨིན༌ཁན༌བོ༌ ཛད༌ད༌ནོག༌ ཨིན༌ནའང༌ ང༌ཞའེ༌ ཁོང༌ངི༌ ཁའ༌ མ༌ཉན༌ན༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN9_15","028_9_15","DAN","9","15","15","“ཏ༌ གཙོ༌བོ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌, ཉེ༌རང༌ངི༌ ཨི༌ཇིབ༌ནེ༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ ཁྱུད༌ ཀྲག༌པོ༌ ཉམ༌པོ༌ ཕིངས༌ཏེ༌ ཁྱོང༌ང༌ ཛད༌ཏེ༌ ཉེ༌རང༌ངི༌ ཚན༌ ཀྲག༌པོ༌ ཏུས༌གྱུན༌ ལུས༌ཤུག༌ག༌ ཛདས༌ ཨིན༌ནའང༌ ང༌ཞ༌གུན༌ ངན༌པ༌ དང༌ སྡིག༌པའེ༌ གངས༌ཏེ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_16","028_9_16","DAN","9","16","16","གཙོ༌བོ༌ལེ༌ ཉེ༌རང༌ངི༌ ཨིད༌ཤེས༌ཅན༌ སྙིང༌རྗེ༌ ནང༌ང༌ ཉེ༌རང༌ངི༌ ཐུག༌སྲོ༌ སྲན༌ཏྲེ༌ དང༌ ཆད༌པ༌ གུན༌ ཡེ༌རུ༌ཤ༌ལེམ༌, ཉེ༌རང༌ངི༌ ཏམ༌པ༌ གྱལ༌སའེ༌ ཀ༌ནེ༌ ཐེན༌ན༌ ཛད༌། ང༌ཞའ༌ དང༌ ང༌ཞའེ༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ སྡིག༌པ༌ ཅོས༌ཏེ༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌ས༌ དང༌ ཉེ༌རང༌ངི༌ མི༌གུན༌ལ༌ ཉེ༌ཁོར༌རི༌ གྱལ༌ཁམས༌གུན༌ནི༌ ཚིག༌ ཏང༌ང༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN9_17","028_9_17","DAN","9","17","17","“ཏ༌ ང༌ཞའེ༌ དཀོན༌མཆོག༌, ངའེ༌ མོས༌ལམ༌ དང༌ ཞུ༌ཝ༌ གུན༌ སན༌ན༌ ཛད༌། ཉེ༌རང༌ངི༌ ཏོན༌ལ༌ གཙོ༌བོ༌ལེ༌, ཁྲེས༌ཏོར༌ ཆའ༌ཁན༌ནི༌ ཉེ༌རང༌ངི༌ ཆོད༌ཁང༌ངི༌ཀ༌ ཡང༌སྐྱར༌ ཐུག༌རྗེ༌ ཟིགས༌ས༌ ཛད༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_18","028_9_18","DAN","9","18","18","ང༌ཞའེ༌ དཀོན༌མཆོག༌, གུའ༌ཛད༌ཏེ༌ ཉན༌ན༌ ཛད༌དའང༌; མིག༌ ཕེའ༌ ཛད༌ཏེ༌ ཉེ༌རང༌ངི༌ ཚན༌ ནམས༌ཁན༌ནི༌ གྱལ༌ས༌ ཞིག༌ཁན༌བོའ༌ ཟིགས༌སའང༌། ང༌ཞ༌གུན༌ ཀྲང༌པོ༌ ཨིན༌ཅེས༌པའེ༌ མན༌པ༌ ཉེ༌རང༌ངི༌ སྙིང༌རྗེ༌ ཀྲག༌པོའེ༌ ཞས༌ཏེ༌ ངའེ༌ ཞུ༌ཝ༌ ཕུལ༌ལད༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_19","028_9_19","DAN","9","19","19","གཙོ༌བོ༌ལེ༌, གཙོ༌བོ༌ལེ༌ ཤགས༌པ༌ ཛད༌དའང༌། གཙོ༌བོ༌ལེ༌ ཉན༌ན༌ ཛད༌ཏེ༌ ལག༌ལེན༌ ཛད༌དའང༌། ཉེ༌རང༌ངི༌ ཏོན༌ལ༌ གཙོ༌བོ༌ལེ༌, གོར༌ ཅུག༌ག༌ མ༌ཛད༌ ཅིའ༌ཟེར༌ན༌ ཉེ༌རང༌ངི༌ གྱལ༌ས༌ དང༌ མི༌གུན༌ནི༌ ཉེ༌རང༌ངི༌ ཚན༌ ནམས༌ཏེ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN9_20","028_9_20","DAN","9","20","20","ངའེ༌ མོས༌ལམ༌ ཞུ༌ཨིན༌ ང༌རང༌ དང༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ནི༌ སྡིག༌པ༌གུན༌ ཤད༌ཨིན༌ ཡ༌ཝ༌ དཀོན༌མཆོག༌ག༌ ཏམ༌པའེ༌ རིའི༌ཀ༌ ཁོང༌ངི༌ ཆོད༌ཁང༌ངི༌ ཕིའ༌ ཞུ༌ཝའ༌ ཕུལ༌ཨིན༌ ཡོད༌ ཟ༌ནེ༌ ");
INSERT INTO lbj_vpl VALUES ("DN9_21","028_9_21","DAN","9","21","21","སྔོན༌ནི༌ ལྟས༌སི༌ ནང༌ང༌ ངའ༌ ཇལ༌ཁན༌ ཕོ༌ཉ༌ གབ༌རི༌ཨེལ༌, ཕི༌ཏོག༌གི༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌སི༌ ཏུས༌ལ༌ ང༌ ཡོད༌ས༌ སྐྱོདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_22","028_9_22","DAN","9","22","22","ཁོང༌ངི༌ ང༌ མོལ༌ལ༌ རག༌, “དཱ༌ནི༌ཨེལ༌ ང༌ དཀོན༌མཆོག༌གི༌ ལུང༌སྟོན༌པ༌ ཡེ༌རེམ༌ཡཱའི༌ སལ༌ཁན༌ནི༌ ལོན༌བོའེ༌ ཏོན༌ སལ༌པོ༌ ཅོས༌ཏེ༌ ཁྱོ༌རང༌ང༌ ཧ༌གོ༌ ཅུག༌ག༌ ཡོངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_23","028_9_23","DAN","9","23","23","ཁྱོ༌རང༌ངི༌ མོས༌ལམ༌ ཞུ༌ཅེས༌ གོ༌ཟུག༌ག༌ཅིག༌ བཀའ༌ཞིག༌ སལས༌། ང༌ ཏེ༌བོ༌ ཁྱོ༌རང༌ང༌ ཤད༌ད༌ ཡོངས༌པིན༌ ཅིའ༌ཟེར༌ན༌ ཁྱོ༌རང༌ དཀོན༌མཆོག༌གི༌ ཕིའ༌ མ༌ རིན༌ཅན༌ ཨིན༌ནོག༌། ཏེ༌བོའེ༌ཕིའ༌ ལོན༌བོ༌ ཉོན༌ ཡང༌ ཡེ༌རེམ༌ཡཱའི༌ སལ༌ཁན༌ནི༌ ལོན༌བོ༌ ཧ༌གོ༌།” ");
INSERT INTO lbj_vpl VALUES ("DN9_24","028_9_24","DAN","9","24","24","“ཁྱོ༌རང༌ངི༌ མི༌གུན༌ དང༌ ཏམ༌པ༌ གྱལ༌སའེ༌ དཀོན༌མཆོག༌ག༌ གྱབ༌གལ༌ ཅོ༌ཅེས༌ མེད༌ཁན༌ ཆ༌ཅེས༌, ཁོང༌གུན༌ནི༌ སྡིག༌པའེ༌ སྐྱོན༌ མེད༌ཁན༌ ཅོས༌ཏེ༌ རྩང༌མ༌ ཅོ༌ཅེས༌, ཐའ༌མེད༌པའེ༌ ཀྲང༌པོ༌ ཁྱོང༌ཅེས༌, ཡེ༌རེམ༌ཡཱའི༌ ལུང༌སྟན༌པོ༌ དྲན༌དྲའ༌ གྲུབ༌བ༌ ཛད༌ཅེས༌ ཡང༌ ཚང༌མའེ༌ སང༌ ཏམ༌པ༌ ནས༌ས༌ རྩང༌མ༌ ཛད༌ཅེས༌ལ༌ ལོ༌ རྡུན༌ཅུ༌ ལྡབ༌ རྡུན༌ གོར༌ཅེས༌ ཐག༌ཅད༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_25","028_9_25","DAN","9","25","25","ཏ༌ ཉོན༌ ཡང༌ ཧ༌གོ༌། ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌ས༌ ཡང༌སྐྱར༌ རྩིག༌ཅེས༌ལ༌ བཀའ༌ ཏངས༌ཏེ༌ སྟིང༌ནེ༌ ལྡམ༌མ༌ ཛད༌ཁན༌ ཝང༌སྲུལ༌པ༌ སྐྱོད༌ཅེས༌ལ༌ རྡུན༌ ལྡབ༌ རྡུན༌ དང༌ དྲུག༌ཅུ༌རག༌ཉིས༌ ལྡབ༌ རྡུན༌ ལོ༌ གོར༌ཨིན༌། ཏུས༌ ཀགས༌པོ༌ ཡོད༌ནའང༌ ལམ༌གུན༌ དང༌ སྲུང༌སྐྱོབ༌ སྟན༌པོ༌ཅན༌ ཡེ༌རུ༌ཤ༌ལེམ༌ ཡང༌སྐྱར༌ རྩིག༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN9_26","028_9_26","DAN","9","26","26","དྲུག༌ཅུ༌རག༌ཉིས༌ ལྡབ༌ རྡུན༌ ལོའེ༌ སྟིང༌ནེ༌ ལྡམ༌མ༌ ཛད༌ཁན༌བོ༌ སད༌ཏེ༌ ཅའང༌མི༌ཏང༌ ཡང༌ ཡོང༌ཅེས༌ཅན༌ ཝང༌སྲུལ༌པའེ༌ མི༌གུན༌ནི༌ ཏམ༌པ༌ གྱལ༌ས༌ དང༌ ཆོད༌ཁང༌ མེད༌ཁན༌ ཅོ༌ཨིན༌། སྟིང༌ཇུག༌པོ༌ མ༌ གྱོགས༌པ༌ ཆུ༌ལོག༌ ཙོགས༌ལ༌ ཡོང༌ཨིན༌: དཀོན༌མཆོག༌གི༌ བཀའ༌ སལ༌ཁན༌ ནང༌ཞིན༌ ཏེ༌བོ༌ མག༌ དང༌ ཁྲེས༌ཏོར༌ ཅོ༌ཅེས༌སི༌ གོ༌ཟུག༌པོ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN9_27","028_9_27","DAN","9","27","27","ཝང༌སྲུལ༌ཁན༌བོའེ༌ མི༌གུན༌ ཉམ༌པོ༌ ལོ༌ རྡུན༌ནི༌ ཕིའ༌ ཆད༌དོན༌ ཅོ༌ཨིན༌ ཨིན༌ནའང༌ ཏེ༌ ཏུས༌པོ༌ ཕེད༌ ཆའ༌ཅིག༌ ཁོའེ༌ ཆོད༌པ༌ དང༌ བུལ༌དུད༌ ཕུལ༌ཅེས༌ལ༌ སྒག༌ཞའ༌ ཏངས༌ཏེ༌ ཆོད༌ཁང༌ངི༌ ཏམ༌པ༌ ནས༌སའེ༌ཀ༌ ཁམ༌ལོག༌ ཚི༌ཏུ༌ ཅོ༌ཁན༌བོ༌ བོར༌ཨིན༌ ཡང༌ ཏེ༌བོ༌ ཏེན༌ནེ༌ཀ༌ ལུས༌ཨིན༌ ནམ༌ཚག༌པ༌ དཀོན༌མཆོག༌གི༌ ཏེ༌ ཝང༌སྲུལ༌ཁན༌བོ༌ མེད༌ཁན༌ མི༌ཛད༌།” ");
INSERT INTO lbj_vpl VALUES ("DN10_1","028_10_1","DAN","10","1","1","པར༌ཤིའ༌པ༌ གྱལ༌པོ༌ སཱེ༌རས༌སི༌ ཝང༌སྲུལ༌ལི༌ ལོ༌ སུམ༌པའེ༌ ནང༌ང༌ བེལ༌ཏེ༌ཤ༌ཟར ཡང༌ན༌ དཱ༌ནི༌ཨེལ༌ལ༌ དཀོན༌མཆོག༌གི༌ ཆོགས༌ནེ༌ ལོན༌ཞིག༌ ཐོབ༌། ཏེ༌ ནང༌ང༌ མོལ༌ཁན༌གུན༌ ཀྲང༌པོ༌ ཡང༌ ཏེ༌བོ༌ མག༌ ཀྲག༌པོ༌ ཞིག༌གི༌ སྐོར༌ ཨིན༌པིན༌། ཏེ༌ ལོན༌བོ༌ ཁོའ༌ ཞལ༌ཟིགས༌ཤིག༌ གྱུད༌ཏེ༌ ཧ༌གོ༌ཅུག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_2","028_10_2","DAN","10","2","2","ཏེ༌ ཏུས༌ ང༌ དཱ༌ནི༌ཨེལ༌ལི༌ རྡུན༌ཞག༌ སུམ༌ རྡུག༌པོ༌ ཅོས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_3","028_10_3","DAN","10","3","3","ཏེ༌ ཏུས༌ གང༌པོ༌ ངའེ༌ ཟན༌ ཞིམ༌པོ༌ མ༌ ཟའ༌, ཤ༌ ཡ༌ རྒུན༌ཆང༌ ཁའ༌ མ༌ ཏུག༌ག༌ ཡང༌ མར༌ མ༌ སྐུའ༌ དུགས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_4","028_10_4","DAN","10","4","4","ཟླ༌ཝ༌ ཏང༌པོའེ༌ ཞག༌ 24 པའེ༌ ཞག༌ག༌ ངའ༌ ལྩངས༌པོ༌ ཀྲག༌པོ༌ ཏྲེག༌རིས༌སི༌ ཐའ༌མ༌ ལངས༌ཏེ༌ ཡོད༌ ཟ༌ནེ༌ ");
INSERT INTO lbj_vpl VALUES ("DN10_5","028_10_5","DAN","10","5","5","ཀེན༌ལ༌ ལྟའ༌ཅིག༌ ངའ༌ ངའེ༌ དུན༌ལ༌ རས༌ རིན༌ཅན༌ནི༌ ཀོས༌ གོན༌ཁན༌ མི༌ཞིག༌ ཐོང༌ ཡང༌ ཁོང༌ངི༌ སྐྱེད༌པ༌ ཅའང༌ མ༌ གྲེས༌ཁན༌ སེར༌རི༌ སྐྱེ༌རག༌ ཅིངས༌ཏེ༌ དུག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_6","028_10_6","DAN","10","6","6","ཁོང༌ངི༌ ཟུགས༌པོ༌ ཁྲ༌ རིན༌ཅན༌ ཙོགས༌, ལྡོང༌ སྐམ༌ལག༌ བར༌ཁན༌ ཙོགས༌, མིག༌ མེའེ༌ པམ༌བར༌ ཙོགས༌, རྐང༌ལག༌གུན༌ རྩི༌ ཏང༌ཁན༌ནི༌ ཟངས༌ ཙོགས༌ ཡང༌ སྐད༌ མི༌མངས༌སི༌ སྐད༌ ཙོགས༌ རག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_7","028_10_7","DAN","10","7","7","ང༌ དཱ༌ནི༌ཨེལ༌ ཅིག༌པོའ༌ ཏེ༌ ལྟས༌པོ༌ ཐོང༌, ང༌ ཉམ༌པོ༌ ཡོད༌ཁན༌གུན༌ལ༌ ཏེ༌བོ༌ མ༌ ཐོང༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ མ༌སྲན༌ཏྲེ༌ ཇིགས༌ཏེ༌ ཤོར༌ ཡང༌ ཨིབས༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_8","028_10_8","DAN","10","8","8","ཏེ༌བོའེ༌ཕིའ༌ ཏེ༌ ཞལ༌ཟིགས༌ ཀྲག༌པོའ༌ ལྟའ༌ལ༌ ང༌ ཅིག༌པོ༌ ལུས༌། ང༌ ཤེད༌མེད༌ གྱུར༌, ངའེ༌ ལྡོང༌ སེར༌པོ༌ སོང༌ ཡང༌ ངའེ༌ ནང༌ང༌ ཤེད༌ ལུས༌ཏེ༌ མེ༌རག༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_9","028_10_9","DAN","10","9","9","ཏེ༌ནེ༌ ང༌ ཁོང༌ངི༌ མོལ༌ཨིན༌ ཚོར༌ ཡང༌ ངའེ༌ ཁོང༌ང༌ ཉན༌པིན༌། ངའ༌ ཉིད༌ ལྕིན༌ཏྲེ༌ ཡོངས༌ཏེ༌ གྱེལ༌ ཡང༌ ངའེ༌ ལྡོང༌ སའ༌ ཐུག༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_10","028_10_10","DAN","10","10","10","ཏེན༌ན༌ ཏུས༌, ཆག༌ཤིག༌གི༌ ཐམས༌ཏེ༌ ངའ༌ ལག༌པ༌ དང༌ པིག༌མོའེ༌ཀ༌ ལང༌ང༌ ཛདས༌ ཨིན༌ནའང༌ ང༌ དར༌རད༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_11","028_10_11","DAN","10","11","11","ཁོང༌ངི༌ མོལས༌, “དཱ༌ནི༌ཨེལ༌ དཀོན༌མཆོག༌གི༌ སྐུན༌དུན༌ལ༌ ཁྱོ༌རང༌ རིན༌ཅན༌ ཨིན༌ནོག༌། ངའ༌ ཁྱོ༌རང༌ ཡོད༌ས༌ ཀལ༌ཏེ༌ ཨིན༌ནོག༌ ཏེ༌བོའེ༌ཕིའ༌ ལངས༌ཏེ༌ ངའེ༌ ཟེར༌ཅེས༌ཅན༌བོའ༌ གྱལ༌ལ༌ ཅོས༌ཏེ༌ ཉོན༌།” ཁོང༌ངི༌ ཏེ༌ཟུག༌ མོལ༌ལ༌ཅིག༌ ངའ༌ དར༌ཨིན༌ ལངས༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_12","028_10_12","DAN","10","12","12","ཏེ༌ནེ༌ ཁོང༌ངི༌ མོལས༌, “ཇིགས༌ མ༌ ཇིགས༌, དཱ༌ནི༌ཨེལ༌། གོ༌མའེ༌ ཞག༌ག༌ ཁྱོ༌རང༌ངི༌ དཀོན༌མཆོག༌གི༌ སྐུན༌དུན༌ལ༌ བོལ༌མོ༌ གྱུར༌ཏེ༌ ཧ༌གོ༌ཅེས༌ལ༌ མོས༌ལམ༌ ཞུ༌ཁན༌གུན༌, ཁོང༌ངི༌ སན༌ན༌ ཛད༌ཏེ༌ ཏེ༌བོའེ༌ ལན༌ལ༌ ང༌ ཀལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_13","028_10_13","DAN","10","13","13","ཨིན༌ནའང༌ པར༌ཤིའ༌པའེ༌ གྱལ༌སྲིད༌ སྐྱོབ༌ཁན༌ནི༌ ངན༌པ༌ ཕོ༌ཉའེ༌ ཞག༌ 21 ང༌ སྒགས༌ཏེ༌ བོརས༌། ཏེ༌ནེ༌ མའེ༌ཀལ༌, ཕོ༌ཉ༌གུན༌ནི༌ འུ༌སྐྱོང༌ ཅིག༌ ངའ༌ རོགས༌ ཛད༌ད༌ སྐྱོད༌ ཅིའ༌ཟེར༌ན༌ ང༌ ཏེ༌རུ༌ ཏེ༌ ངན༌པ༌ ཕོ༌ཉའེ༌ སྒགས༌ཏེ༌ བོརས༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_14","028_10_14","DAN","10","14","14","ཏ༌ ཁྱོ༌རང༌ང༌ ཡོང༌ཅེས༌ཅན༌ནི༌ ཏུས༌སི༌ ནང༌ང༌ ཁྱོ༌རང༌ངི༌ མི༌གུན༌ ཉམ༌པོ༌ ཇུང༌ཅེས༌ཅན༌བོ༌ ཤད༌ད༌ལ༌ ང༌ ཡོངས༌པིན༌། འི༌ ཞལ༌ཟིགས༌པོ༌ མ༌ཡོངས༌པའེ༌ ཏུས༌སི༌ སྐོར༌ལ༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN10_15","028_10_15","DAN","10","15","15","ཁོང༌ངི༌ ཏེ༌གུན༌ མོལ༌ ཟ༌ནེ༌ ངའེ༌ གོ༌ སྒུས༌ཏེ༌ ས༌ ལྟས༌པིན༌ ཡང༌ ངའ༌ ཅའང༌ ཟེར༌ མ༌ ཉན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_16","028_10_16","DAN","10","16","16","ཏེ༌ནེ༌ མི༌ ཙོགས༌ ཐོང༌ཁན༌བོའེ༌ ངའེ༌ ཁལ༌པག༌ག༌ ཆག༌ རྩེའ༌ ཛདས༌ ཡང༌ ངའ༌ སྤེ༌ར༌ ཏང༌ཉན༌། ངའེ༌ དུན༌ལ༌ ཞངས༌ཏེ༌ ཡོད༌ཁན༌བོའ༌ ངའེ༌ ཟེར༌པིན༌, “ཞལ༌ཟིགས༌པོའེ༌ ཞས༌ཏེ༌ ངའ༌ རྡུག༌ངལ༌ སྲན༌ཏྲེ༌ ཐོང༌པ༌ ངའེ༌ གཙོ༌བོ༌, ངའེ༌ ནང༌ང༌ ཤེད༌ ལུས༌ཏེ༌ མེ༌རག༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_17","028_10_17","DAN","10","17","17","ངའེ༌ གཙོ༌བོ༌, ཉེ༌རང༌ངི༌ ཡོག༌པོ༌ ང༌ ཙོགས༌ཤིག༌གི༌ ཉེ༌རང༌ང༌ སྤེ༌ར༌ ཏང༌ཅེས༌སི༌ ཧམ༌པ༌ ཀ༌ཟུག༌གི༌ ཅོ༌ཨིན༌? ངའེ༌ ཤེད༌པོ༌ མེད༌ཁན༌ སོང༌ཏེ༌ ང༌ འུགས༌ ལེན༌ཅེས༌ལའང༌ ཀགས༌པོ༌ ཆའ༌རག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN10_18","028_10_18","DAN","10","18","18","མི༌ ཙོགས༌ ཐོང༌ཁན༌བོའེ༌ ཡང༌སྐྱར༌ ང༌ ཐམས༌ས༌ ཛད༌ཏེ༌ ངའ༌ ཤེད༌ སལས༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_19","028_10_19","DAN","10","19","19","ཁོང༌ངི༌ མོལས༌, “དཀོན༌མཆོག༌གི༌ སྐུན༌དུན༌ལ༌ རིན༌ཅན༌ མི༌, ཇིགས༌ མ༌ ཇིགས༌, ཤེད༌ཅན༌ གྱུར༌།” ཁོང༌ངི༌ ཞལ༌ཏ༌ སལ༌ལ༌ཅིག༌ ང༌ ཤེད༌ཅན༌ གྱུར༌ཏེ༌ ངའེ༌ ཟེར༌པིན༌, “མོལ༌ལ༌ ཛད༌ གཙོ༌བོ༌ལེ༌ ཅིའ༌ཟེར༌ན༌ ཉེ༌རང༌ངི༌ ང༌ ཤེད༌ སལ༌ལ༌ ཛདས༌།” ");
INSERT INTO lbj_vpl VALUES ("DN10_20","028_10_20","DAN","10","20","20","ཁོང༌ངི༌ མོལས༌, “ཁྱོ༌རང༌ ཡོད༌ས༌ ང༌ ཅི༌ཕིའ༌ ཡོངས༌, གྱུས༌ ཡོད༌ད༌? ངའ༌ པར༌ཤིའ༌པའེ༌ གྱལ༌སྲིད༌ སྐྱོབ༌ཁན༌ ངན༌པ༌ ཕོ༌ཉ༌ ཉམ༌པོ༌ ནོལ༌ལ༌ ལོགས༌ཏེ༌ ཡོང༌ཨིན༌ ཡང༌ ཁོའ༌ ཕམ༌ཀལ༌ཏེ༌ ང༌ ཆའ༌ཅིག༌ གི༌རིས༌པའེ༌ གྱལ༌སྲིད༌ སྐྱོབ༌ཁན༌ ངན༌པ༌ ཕོ༌ཉ༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN10_21","028_10_21","DAN","10","21","21","ཨིན༌ནའང༌ ཁྱོ༌རང༌ང༌ ཀྲང༌པོ༌ སྤེ༌ཆའེ༌ ནང༌ང༌ བྲིས༌ཁན༌བོ༌ ཤད༌ཨིན༌། ༼ཏེ༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཨིས༌ར༌ཨེལ༌པ༌གུན༌ སྐྱོབ༌ཁན༌ནི༌ ཕོ༌ཉ༌ མའེ༌ཀལ༌ ཅིག༌པོའེ༌ ངའ༌ རོགས༌ ཅོའ༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_1","028_11_1","DAN","11","1","1","“གྲ༌རི༌ཡས༌ མེ༌དིའ༌པ༌ གྱལ༌པོའེ༌ ཝང༌སྲུལ༌ལི༌ གོ༌མའེ༌ ལོའེ༌ ཏུས༌ ངའེ༌ ཕོ༌ཉའེ༌ འུ༌སྐྱོང༌ ཅིག༌ མའེ༌ཀལ༌ལ༌ རོགས༌ ཅོས༌ཏེ༌ སྐྱོབས༌པིན༌།༽” ");
INSERT INTO lbj_vpl VALUES ("DN11_2","028_11_2","DAN","11","2","2","“ཏ༌ ངའེ༌ ཁྱོ༌རང༌ང༌ ཀྲང༌པོ༌བོ༌ སྔོན༌ ཅུག༌ཨིན༌། པར༌ཤིའ༌པ༌ ཞན༌ གྱལ༌པོ༌ སུམ༌མི༌ ཝང༌ སྲུལ༌ཨིན༌, ཏེ༌སྟིང༌ནེ༌ ཁོང༌ ཚང༌མའེ༌ སང༌ མང༌ང༌ ཆུག༌པོ༌ གྱལ༌པོ༌ ཞི༌པ༌ ཡོང༌ཨིན༌། ཁོ༌རང༌ངི༌ གྱུ༌ནོར༌ གྱུད༌ཏེ༌ ཁོ༌ ཝང༌ཅན༌ གྱུར༌ར༌ཅིག༌ ཁོའེ༌ ཞན༌ གྱལ༌པོ༌ ཚང༌མ༌ གརིས༌སི༌ གྱལ༌པོའེ༌ གྱབ༌གལ༌ ཅོ༌ཅེས༌ལ༌ ལང༌ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_3","028_11_3","DAN","11","3","3","ཏེ༌ནེ༌ ཁྱུད༌ཅན༌ གྱལ༌པོ༌ཞིག༌ བིང༌ཏེ༌ ཝང༌ ཀྲག༌པོ༌ སྲུལ༌ཏེ༌ ཁོ༌རང༌ ཐད༌ཁན༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_4","028_11_4","DAN","11","4","4","ཝང༌སྲུལ༌ ཀྲག༌པོ༌ ཡོད༌དི༌ ཏུས༌ ཁོ༌ ཤི༌ཨིན༌ ཡང༌ ཁོའེ༌ གྱལ༌སྲིད༌ལ༌ པོ༌བུད༌ཏེ༌ ཁག༌ ཞི༌ གྱུར༌ཨིན༌། གྱལ༌པོའེ༌ པུར༌གྱུད༌གུན༌ནི༌ ཝང༌ མི༌སྲུལ༌ ཡ༌ ཁོ༌ ཙོགས༌ ཁྱུད༌ཅན༌ མི༌ཡོང༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ གྱལ༌སྲིད༌པོ༌ པ༌ཀྲག༌ནེ༌ ཕུད༌ཏེ༌ ཞན༌གུན༌ལ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_5","028_11_5","DAN","11","5","5","ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཤེད༌ཅན༌ གྱུར༌ཨིན༌ ཨིན༌ནའང༌ ཁོའེ༌ མག༌སྤོན༌ ཅིག༌ཅིག༌ ཁོའེ༌ སང༌ ཁྱུད༌ཅན༌ གྱུར༌ཏེ༌ ཁོ༌རང༌ངི༌ གྱལ༌སྲིད༌དི༌ཀ༌ ཝང༌ ཀྲག༌པོ༌ སྲུལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_6","028_11_6","DAN","11","6","6","ལོ༌ ཁ༌ཅིག༌གི༌ སྟིང༌ནེ༌ སི༌རི༌ཡཱ༌ དང༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ གུན༌ནི༌ ཅིག༌ དང༌ ཅིག༌ག༌ རོགས༌ ཅོ༌ཅེས༌ལ༌ ཆད༌དོན༌ ཅོས༌ཏེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོའ༌ ན༌མ༌ ཏང༌ཨིན༌ ཨིན༌ནའང༌ ཆད༌དོན༌བོ༌ ཁྲངས༌པོ༌ མི༌ལུས༌ ཅིའ༌ཟེར༌ན༌ བུ༌མོ༌, ཁོའེ༌ མག༌པ༌, ཕྲུ༌གུ༌ དང༌ ཁོའ༌ ཆོགས༌སྐྱོར༌ ཅོ༌ཁན༌གུན༌ ཕིངས༌ཏེ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_7","028_11_7","DAN","11","7","7","“ཁོའེ༌ གྱུད༌དི༌ ནང༌ནེ༌ བུ༌ཚ༌ ཅིག༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ གྱུར༌ཨིན༌ ཡང༌ ཁོའེ༌ མག༌མིའི༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོའ༌ མག༌ ཏངས༌ཏེ༌ ཕམ༌ཀལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_8","028_11_8","DAN","11","8","8","ཁོ༌ ལོགས༌ཏེ༌ ཡོང༌ ཟ༌ནེ༌ ཁོའེ༌ ཁོང༌གུན༌ནི༌ ལྷ༌ལྷ༌མོའེ༌ སྐུན༌དྲ༌གུན༌ ཡང༌ སེར༌ དང༌ མུལ༌ལི༌ ཅ༌ལག༌གུན༌ ཁུར༌ཏེ༌ ཨི༌ཇིབ༌བ༌ ཁྱོང༌ཨིན༌། ཁོའེ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོ༌ ལོ༌ ཁ༌ཅིག༌གི༌ ཕིའ༌ ཅིག༌པོ༌ བོར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_9","028_11_9","DAN","11","9","9","ཏེ༌ སྟིང༌ནེ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོའེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌སྲིད༌དི༌ཀ༌ སྤུང༌གོལ༌ ཅོ༌ཨིན༌ ཨིན༌ནའང༌ ཁོ༌རང༌ངི༌ ཡུལ༌ལ༌ གྱོགས༌པ༌ ལོགས༌ཏེ༌ ཆ༌གོས༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_10","028_11_10","DAN","11","10","10","སི༌རི༌ཡཱའེ༌ གྱལ༌པོའེ༌ བུ༌ཚ༌གུན༌ནི༌ མག༌མི༌ མང༌པོ༌ ཛོམས༌ ཅུགས༌ཏེ༌ མག༌ ཏང༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཅོ༌ཨིན༌། ཁོའེ༌ མག༌མི༌ མ༌མང༌པོ༌ ཨིས༌ར༌ཨེལ༌ གང༌པོའེ༌ ནང༌ང༌ ཆུ༌ལོག༌ ཡོང༌ཁན༌ ཙོགས༌ལ༌ ཕེལ༌ཏེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ གྱལ༌སའེ༌ གྱང༌སྐོར༌ ཚོག༌པ༌ ལེབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_11","028_11_11","DAN","11","11","11","ཏེ༌ནེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའ༌ སྲོ༌ སྲན༌ཏྲེ༌ ཡོངས༌ཏེ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོའ༌ མག༌ ཏང༌ང༌ བིང༌ཨིན༌། ཁོའེ༌ གྱབ༌གལ༌ལ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོའེ༌ མག༌མི༌ མ༌ མང༌པོའེ༌ ནོལ༌ཨིན༌ ཨིན༌ནའང༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ ཁོང༌གུན༌ལ༌ ཕམ༌ ཀལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_12","028_11_12","DAN","11","12","12","ཏེ༌ཟམ༌ མང༌པོ༌ མག༌མི༌ ཟུམས༌ཏེ༌ ཕམ༌ཀལ༌ པ༌སང༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ མ༌ ཕོ༌སོ༌ཅན༌ གྱུར༌ཏེ༌ སྟོང༌ཁྲག༌གི༌ ནང༌ང༌ མག༌མི༌གུན༌ སད༌ཨིན༌ ཨིན༌ནའང༌ ཁོའེ༌ གྱལ༌ཁ༌བོ༌ ཏུས༌རིང༌མོ༌ མི༌ ལུས༌ ");
INSERT INTO lbj_vpl VALUES ("DN11_13","028_11_13","DAN","11","13","13","ཅིའ༌ཟེར༌ན༌ ལོ༌ ཁ༌ཅིག༌གི༌ སྟིང༌ནེ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོ༌ སྔུན༌ནི༌ སང༌ མང༌ང༌ མག༌མི༌ དང༌ ཚོན༌ཆ༌ ཉམ༌པོ༌ ཡང༌སྐྱར༌ མག༌ཏང༌ང༌ ཡོང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_14","028_11_14","DAN","11","14","14","“ཏེ༌ ཏུས༌ལ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ གྱབ༌གལ༌ལ༌ ཞན༌ མང༌པོ༌ ལང༌ཨིན༌། ཞལ༌ཟིགས༌པོ༌ དྲན༌དྲའ༌ གྲུབ༌ཅེས༌ལ༌ ཏེ༌ནང༌ང༌ ཁྱོ༌རང༌ངི༌ མི༌གུན༌ནི༌ ཕྲོ༌ནེ༌ སྲོན༌ཇན༌ ནོལ༌ལ༌ ཐད༌ཁན༌ མང༌པོ༌ ཐེས༌ཏེ༌ ཨིན༌ནོག༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ ཁྲངས༌པོ༌ མི༌ ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_15","028_11_15","DAN","11","15","15","ཏེ༌ཏུས༌ལ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོ༌ ཡོངས༌ཏེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌སའེ༌ ནང༌ང༌ ཞུག༌ཅེས༌ལ༌ ལམ༌ ཁྲེད༌ཁྲེད༌ རྩིགས༌ཏེ༌ ཏེ༌བོ༌ ང༌ཡོག༌ག༌ ལེན༌ཨིན༌། ཨི༌ཇིབ༌པ༌ མག༌མི༌གུན༌ལ༌ ཏེ༌བོ༌ སྒག༌ མི༌ཐུབ༌, མག༌མི༌ ཀྲག༌ཤོག༌ གུན༌ནའང༌ ཁོང༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ མི༌ཐུབ༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_16","028_11_16","DAN","11","16","16","སྤུང༌གོལ༌ ཅོ༌ཁན༌གུན༌ནི༌ ཁོ༌རང༌གུན༌ ཐད༌ཁན༌ ཅོ༌ཨིན༌, སུའང༌ ཁོང༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ནོལ༌ མི༌ཐུབ༌། ཁོ༌ ཨིས༌ར༌ཨེལ༌ལི༌ ས༌ཀྱད༌ ལྡེ༌མོའེ༌ ནང༌ང༌ ཚུགས༌ཏེ༌ ཏེ༌བོ༌ མེད༌ཁན༌ ཅོ༌ཅེས༌སི༌ ཝང༌ ཁོའ༌ ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_17","028_11_17","DAN","11","17","17","ཁོའེ༌ ཁོ༌རང༌ངི༌ གྱལ༌སྲིད༌ གང༌པོའེ༌ མག༌མི༌ ཉམ༌པོ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ གོབ༌སྐོར༌ཅེས༌ལ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོ༌ ཉམ༌པོ༌ ཐུན༌བྲེལ༌ ཅོ༌ཅེས༌སི༌ ཐབ༌ལྡིངས༌། ཁོའེ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌སྲིད༌ མེད༌ཁན༌ ཅོ༌ཅེས༌ལ༌ ཁོ༌རང༌ངི༌ བུ༌མོ༌ ཁོའ༌ ན༌མ༌ ཏང༌ཨིན༌ ཨིན༌ནའང༌ ཏེ༌ ཐབས༌པོ༌ ཁྲངས༌པོ༌ མི༌ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_18","028_11_18","DAN","11","18","18","ཏེ༌ནེ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོའེ༌ གྱ༌ཚོའེ༌ ཐའ༌མའེ༌ ཡུལ༌གུན༌ལ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ གྱལ༌སའ༌ མང༌པོ༌ ང༌ཡོག༌ག༌ ཁྱོང༌ཨིན༌ ཨིན༌ནའང༌ མག༌མི༌ འུ༌སྐྱོང༌ཞིག༌གི༌ ཁོའ༌ ཕམ༌ཀལ༌ཏེ༌ ཁོའེ༌ ཕོ༌སོ༌བོ༌ མེད༌ཁན༌ ཅོ༌ཨིན༌ ཡང༌ ཞན༌གུན༌ལ༌ ཁོའེ༌ ཅོ༌ཁན༌ ཙོགས༌ ཁོའ༌ ཅོས༌ཏེ༌ ཁྲེལ༌བ༌ སྟན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_19","028_11_19","DAN","11","19","19","ཏེ༌ནེ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོ༌ ཁོ༌རང༌ངི༌ ཡུལ༌ལ༌ གྱང༌སྐོར༌ ཐོན༌པོ༌ ཡོད༌སའེ༌ ཁོ༌རང༌ངི༌ གྱལ༌ས༌ ལོགས༌ཏེ༌ ཆེན༌ ཨིན༌ནའང༌ ཁོའ༌ མག༌གི༌ ནང༌ང༌ ཕམ༌ ཀལ༌ཏེ༌ སད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_20","028_11_20","DAN","11","20","20","“ཁོའེ༌ སྟིང༌ནེ༌ ཡོང༌ཁན༌ནི༌ གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ གྱལ༌སྲིད༌དི༌ སྤལ༌གུན༌ ལུས༌ཤུག༌ཅེས༌ལ༌ མི༌གུན༌ནི༌ཀ༌ ཁྲལ༌ ལྕིན༌ཏྲེ༌ ཀལ༌ཨིན༌། ཏུས༌ ཉུ༌ངུན༌ ཞིག༌གི༌ སྟིང༌ནེ༌ ཁོ༌ ཤི༌ཨིན༌ ཨིན༌ནའང༌ མག༌ ཡ༌ ཛིང༌མོའེ༌ ཞས༌ཏེ༌ མི༌ཤི༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_21","028_11_21","DAN","11","21","21","“ཁོའེ༌ སྟིང༌ནེ༌ གྱལ༌པོ༌ གྱུར༌ཁན༌བོ༌ གྱལ༌གྱུད༌ནེ༌ མན༌ཁན༌ ངན༌པ༌ མི༌ཞིག༌ ཡོང༌ཨིན༌། ཞི༌དེ༌ ཡོད༌ཏུས༌ མི༌གུན༌ལ༌ ཁས༌པ༌ ཉམ༌པོ༌ སྐྱོན༌ ཀོལ༌ཏེ༌ ཁོ༌ གྱལ༌པོ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_22","028_11_22","DAN","11","22","22","ཏེ༌ནེ༌ ཁོའེ༌ མག༌མི༌གུན༌ནི༌ ཁོའ༌ གྱབ༌གལ༌ ཅོ༌ཁན༌ནི༌ མག༌མི༌གུན༌ སད༌ཨིན༌། ཁོང༌གུན༌ནི༌ དཀོན༌མཆོག༌གི༌ བླ༌མ༌ ཆེན༌མོའང༌ སད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_23","028_11_23","DAN","11","23","23","ཁོའེ༌ གོབ༌སྐོར༌ར༌ལ༌ ཞན༌ ཝང༌སྲུལ༌པ༌གུན༌ ཉམ༌པོ༌ ཐུན༌བྲེལ༌ལི༌ ཁ༌ཆད༌ ཅོ༌ཨིན༌། ཁོའ༌ ཆོགས༌སྐྱོར༌ ཅོ༌ཁན༌ ཉུང༌ངུན༌ཞིག༌ མ༌ནེ༌ མེད༌ནའང༌ ཁོ༌ མ༌ ཤེད༌ཅན༌ ཝང༌ སྲུལ༌པ༌ གྱུར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_24","028_11_24","DAN","11","24","24","ཆུག༌པོ༌ ཡུལ༌གུན༌ནི༌ ནང༌ང༌ ཞི༌དེ༌ དང༌ ཡར༌གྱས༌ ཡོད༌ཏུས༌ ཏེ༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོས༌ཏེ༌ ཁོའེ༌ ཕ༌མེས༌པོ༌གུན༌ ཁྲངས༌པོ༌ མ༌ ལུས༌ཁན༌ནི༌ ལས༌གུན༌ གྲུབ༌ཅུག༌ཨིན༌། མག༌གི༌ ནང༌ང༌ ཕམ༌ཀལ༌ཁན༌གུན༌ནི༌ ཀ༌ནེ༌ ཅོམས༌ཁན༌ གྱུ༌ནོར༌ དང༌ ས༌ཀྱད༌གུན༌ ཁོའ༌ ཆོགས༌སྐྱོར༌ ཅོ༌ཁན༌གུན༌ལ༌ བགོས༌ཏེ༌ ཏང༌ཨིན༌ ཡང༌ ཁོའེ༌ གྱལ༌ས༌གུན༌ ཁྲེས༌ཏོར༌ ཅོ༌ཅེས༌ལ༌ ཐབས༌ལྡིང༌ཨིན༌། ཨིན༌ནའང༌ ཁོའེ༌ ཝང༌སྲུལ༌ལི༌ ཏུས༌ རིང༌མོ༌ མི༌ལུས༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_25","028_11_25","DAN","11","25","25","ཨི༌ཇིབ༌བི༌ གྱལ༌པོའ༌ སྤུང༌གོལ༌ ཅོ༌ཅེས༌ལ༌ ཁོའེ༌ སྟོབས༌ དང༌ སྤོས༌པ༌ ཉམ༌པོ༌ མག༌མི༌ ཆེན༌མོ༌ ལྡུམ༌ཨིན༌། ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ མ༌ སྟོབས༌ཅན༌ མག༌མི༌ མང༌པོ༌ ཉམ༌པོ༌ ནོལ༌ཅེས༌ལ༌ གྲལ༌གྲིག༌ ཅོ༌ཨིན༌ ཨིན༌ནའང༌ ཁོའེ༌ གྱབ༌གལ༌ལ༌ ཅུས༌ངན༌གུན༌ ལྡིང༌ཅེས༌པོའེ༌ ཁོའ༌ གྱལ༌ཁའ༌ མི༌ཐོབ༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_26","028_11_26","DAN","11","26","26","གྱལ༌པོ༌ ཉམ༌པོ༌ ཟན༌ ཟའ༌ཁན༌གུན༌ནི༌ ཁོ༌ མེད༌ཁན༌ ཅོ༌ཅེས༌སི༌ རྩོན༌གྲུས༌ ཅོ༌ཨིན༌། ཁོའེ༌ མག༌མིའ༌ ཕམ༌ ཀྲག༌པོ༌ ཀལ༌ཏེ༌ མག༌གི༌ ནང༌ང༌ མང༌པོ༌ ཤི༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_27","028_11_27","DAN","11","27","27","ངན༌ སེམས༌ཅན༌ནི༌ གྱལ༌པོ༌ ཉིས༌ཀོ༌ ཅོག༌ཙེ༌ ཅིག༌གི༌ཀ༌ དུགས༌ཏེ༌ ཟན༌ ཟེན༌ ཅིག༌ དང༌ ཅིག༌ག༌ ཟུན༌ ཏང༌ཨིན༌ ཨིན༌ནའང༌ ཏེ༌བོ༌ ཁྲངས༌པོ༌ མི༌ལུས༌ ཅིའ༌ཟེར༌ན༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ ཏུས༌སི༌ཀ༌ ཁོང༌གུན༌ནི༌ ཐའ༌མ༌ ལེབ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_28","028_11_28","DAN","11","28","28","སི༌རི༌ཡཱའེ༌ གྱལ༌པོ༌ གྱུ༌ནོར༌ མང༌པོ༌ ཉམ༌པོ༌ ཁོ༌རང༌ངི༌ ཡུལ༌ལ༌ ལོགས༌ཏེ༌ ཆེན༌ ཡོད༌ ཟ༌ནེ༌ ཁའེ༌ སེམས༌སི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ ཆད༌དོན༌ ཁ༌ ཉན༌ཁན༌ ཏམ༌པ༌ མི༌གུན༌ནི༌ ཆོགས༌ལ༌ ངན༌པ༌ ལངས༌ཏེ༌ ཁོའེ༌ ཁོང༌གུན༌ལ༌ ནོད༌པ༌ མང༌པོ༌ སྐྱལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_29","028_11_29","DAN","11","29","29","“ལྡམས༌ཁན༌ནི༌ ཏུས༌སི༌ཀ༌ ཁོའེ༌ ཡང༌སྐྱར༌ ཨི༌ཇིབ༌བ༌ སྤུང༌གོལ༌ ཅོ༌ཨིན༌ ཨིན༌ནའང༌ འི༌ཏུས༌ ཇུག༌བྲས༌པོ༌ སྔུན༌ནི༌ སང༌ སོ༌སོ༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_30","028_11_30","DAN","11","30","30","རོམ༌མི༌ མག༌གི༌ གྲུ༌ཟིང༌གུན༌ནི༌ ཁོའེ༌ གྱབ༌གལ༌ ཅོ༌ཅེས༌པའེ༌ ཁོའེ༌ སེམ༌སྟོབས༌ ཆག༌ཨིན༌། ཏེ༌བོའེ༌ཕིའ༌ ཁོའེ༌ དཀོན༌མཆོག༌གི༌ ཆད༌དོན༌ ཁ༌ ཉན༌ཁན༌ནི༌ ཏམ༌པ༌ མི༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ ཁོ༌རང༌ངི༌ སྲོ༌ སྲུག༌ཨིན༌། ཁོའེ༌ དཀོན༌མཆོག༌གི༌ ཏམ༌པ༌ ཆད༌དོན༌ ཕང༌ཁན༌གུན༌ལ༌ རྩི༌ཝ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_31","028_11_31","DAN","11","31","31","“ཁོའེ༌ མག༌མི༌གུན༌ནི༌ ཏམ༌པ༌ ཆོད༌ཁང༌ ང༌ཡོག༌ག༌ ཁྱོངས༌ཏེ༌ ཏེ༌བོ༌ ཚི༌ཏུ༌ ཅོ༌ཨིན༌། ཞག༌ཏང༌ངི༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌གུན༌ སྒག༌ཨིན༌ ཡང༌ ཏེ༌ ནང༌ང༌ ཁམ༌ལོག༌ ཚི༌ཏུ༌ ཅོ༌ཁན༌བོ༌ བོར༌ཏེ༌ ཆོད༌ཁང༌ ཚི༌ཏུ༌ གྱུར༌ ཅུག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_32","028_11_32","DAN","11","32","32","ཁོའེ༌ སྐྱོན༌ ཀོལ༌ཏེ༌ ཏད༌པ༌ ཕང༌ཁན༌གུན༌ ཁོ༌རང༌ངི༌ ཆོགས༌ལ༌ ཁྱོངས༌ཏེ༌ ཁོ༌ ཐད༌ཁན༌བོ༌ ཅོ༌ཅུག༌ཨིན༌ ཨིན༌ནའང༌ དཀོན༌མཆོག༌ ཤེས༌ཁན༌གུན༌ ཏད༌པའེ༌ ནང༌ང༌ སྟན༌པོ༌ དུགས༌ཏེ༌ ཁོའེ༌ གྱབ༌ནེ༌ མི༌ཆ༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_33","028_11_33","DAN","11","33","33","“ཤེས༌རབས༌ཅན༌གུན༌ནི༌ མང༌པོའ༌ ལབ༌ཞ༌ ཏང༌ཨིན༌ ཨིན༌ནའང༌ ཏུས༌ ཉུ༌ངུན༌ཞིག༌གི༌ ཕིའ༌ ཁོང༌གུན༌ ར༌འི༌ ཉམ༌པོ༌ སད༌ཨིན༌ ཡ༌ མེའ༌ སྲག༌ཨིན༌ ཡ༌ ཁོང༌གུན༌ ཅོམ༌ཨིན༌ ཡ༌ ཙོན༌ཁང༌ངི༌ ནང༌ང༌ ཀག༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_34","028_11_34","DAN","11","34","34","ཁོང༌གུན༌ལ༌ རྡུག༌ངལ༌ ཐོང༌ ཟ༌ནེ༌ ཁོང༌ང༌ རོགས༌ ཙ༌པིག༌ ཐོབ༌ཨིན༌ ཨིན༌ནའང༌ ཁོང༌གུན༌ནི༌ ཕྲོ༌ནེ༌ ཁ༌ཅིག༌གི༌ དོད༌པ༌ ངན༌པ༌ ཉམ༌པོ༌ རོགས༌ ཅོ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_35","028_11_35","DAN","11","35","35","ཞན༌ མང༌པོ༌ ཏམ༌པ༌ གྱུར༌ཅེས༌སི༌ ཕིའ༌ ཐའ༌མའེ༌ ཏུས༌ ཚོག༌པ༌ ཤེས༌རབས༌ཅན༌ ཁ༌ཅིག༌ ཤི༌ གོས༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ ལྡམས༌ཁན༌ནི༌ ཏུས༌ ལེབ༌ཅེས༌ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_36","028_11_36","DAN","11","36","36","“ཏེ༌ནེ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོའེ༌ ཁོ༌རང༌ ཐད༌ཁན༌ ཅོ༌ཨིན༌། ཁོའེ༌ ཁོ༌རང༌ང༌ སྤལ༌ ཏངས༌ཏེ༌ ཁོ༌རང༌ ལྷ༌ལྷ༌མོ༌ ཚང༌མའེ༌ སང༌ ཀྲག༌ག༌ ཐེན༌ ཡང༌ ཀུན༌ཝང༌ དཀོན༌མཆོག༌གའང༌ དད༌ལོག༌ ཞུ༌ཨིན༌། དཀོན༌མཆོག༌གི༌ ཆད༌པའེ༌ ཏུས༌ ལེབ༌ལེབ༌ ཚག༌པ༌ ཁོའེ༌ ཡར༌གྱས༌ ཅོ༌ཨིན༌ ཅིའ༌ཟེར༌ན༌ དཀོན༌མཆོག༌གི༌ ཐབས༌ལྡིང༌ང༌ ཛད༌ཁན༌བོ༌ གྲུབ༌གོས༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_37","028_11_37","DAN","11","37","37","གྱལ༌པོའེ༌ ཁོ༌རང༌ངི༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ ལྷ༌ལྷ༌མོ༌ ཡ༌ བུ༌མོ༌གུན༌ནི༌ ཅམས༌པ༌ ཅོ༌ཁན༌ ལྷ༌ ཡ༌ ཞན༌ ལྷ༌ལྷ༌མོ༌གུན༌ལ༌ རྩི༌ཝ༌ མི༌ཏང༌ ཅིའ༌ཟེར༌ན༌ ཁོའེ༌ ཁོ༌རང༌ ཁོང༌ ཚང༌མའེ༌ སང༌ ཀྲག༌པོ༌ ཐེས༌ཏེ༌ ཕོ༌སོ༌ ཅོའ༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_38","028_11_38","DAN","11","38","38","ཏེ༌གུན༌ནི༌ ཚབས༌ལ༌ ཁོའེ༌ གྱང༌སྐོར༌ ཐོན༌པོའེ༌ གྱལ༌ས༌ སྐྱོབ༌ཁན༌ནི༌ ལྷའ༌ རྩི༌ཝ༌ ཏང༌ཨིན༌ ཡང༌ ཁོའེ༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ མ༌ཤེས༌ཁན༌ནི༌ ལྷའ༌ སེར༌, མུལ༌, གྱན༌ཆ༌ དང༌ ཞན༌ རིན༌ཅན༌ སྐྱེས༌གུན༌ ཕུལ༌ཏེ༌ རྩི༌ཝ༌ ཏང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_39","028_11_39","DAN","11","39","39","ཞན༌ ལྷ༌ལྷ༌མོའེ༌ རོགས༌ ལེན༌ཏེ༌ ཁོའེ༌ གྱང༌སྐོར༌ ཐོན༌པོ༌ཅན༌ནི༌ གྱལ༌ས༌གུན༌ནི༌ཀ༌ སྤུང༌གོལ༌ ཅོ༌ཨིན༌ ཡང༌ ཁོའེ༌ ཆོགས༌པ༌གུན༌ལ༌ རྩི༌ཝ༌ ཀྲག༌པོ༌ ཏངས༌ཏེ༌ ཁོང༌གུན༌ ཝང༌སྲུལ༌པ༌ སྐོ༌ཨིན༌། ཁོང༌གུན༌ལ༌ རྔན༌པའེ༌ ཚུལ༌ལ༌ ས༌ཀྱད༌གུན༌ བགོས༌ཏེ༌ ཏང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN11_40","028_11_40","DAN","11","40","40","“སྟིང༌ཇུག༌གི༌ ཏུས༌ལ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའེ༌ སི༌རི༌ཡཱའེ༌ གྱལ༌པོའ༌ མག༌ ཏང༌ཨིན༌ ཨིན༌ནའང༌ ཁོའེ༌ རྟ༌རེལ༌ དང༌ རྟའེ༌ཀ༌ ཞོན༌ཁན༌ ཡང༌ མག༌གི༌ གྲུ༌ཟིང༌ མང༌པོ༌ ཉམ༌པོ༌ ཨི༌ཇིབ༌བི༌ གྱལ༌པོའ༌ སྤུང༌གོལ༌ ཀྲག༌པོ༌ ཅོ༌ཨིན༌། ཆུ༌ལོག༌ ཡོང༌ང༌ ཙོགས༌ལ༌ ཁོ༌ གྱལ༌ས༌ མང༌པོའེ༌ ནང༌ང༌ ཞུགས༌ཏེ༌ མི༌གུན༌ སད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_41","028_11_41","DAN","11","41","41","ཁོའེ༌ ལྡེ༌མོ༌ ནས༌ས༌ ཨིས༌ར༌ཨེལ༌ལི༌ཀའང༌ སྤུང༌གོལ༌ ཅོ༌ཨིན༌། གྱལ༌ཁམས༌ མང༌པོ༌ མེད༌ཁན༌ ཆེན༌ ཨིན༌ནའང༌ ཨི༌དོམ༌པ༌ དང༌ མོ༌འབ༌པ༌ ཡང༌ ཨ༌མོན༌པའེ༌ འུ༌སྐྱོང༌གུན༌ ཤོར༌ ཉན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_42","028_11_42","DAN","11","42","42","ཁོའེ༌ ཡུལ༌ མང༌པོ༌ ང༌ཡོག༌ག༌ ཁྱོང༌ཨིན༌, ཨི༌ཇིབ༌པ༌གུན༌ནའང༌ ཁོའེ༌ ཀ༌ནེ༌ མི༌ ཐར༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_43","028_11_43","DAN","11","43","43","ཁོའེ༌ ཨི༌ཇིབ༌བི༌ སེར༌, མུལ༌ དང༌ ཞན༌ གྱུ༌ནོར༌ ཚང༌མ༌ ཁོ༌རང༌ངི༌ ཝང༌ངི༌ ཡོག༌ག༌ ལེན༌ཨིན༌། ལི༌བི༌ཡན༌པ༌ དང༌ ཨི༌ཐིའོ༌པིའ༌པ༌ ཁོའེ༌ ཝང༌སྲུལ༌ལི༌ ཡོག༌ག༌ ཡོང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_44","028_11_44","DAN","11","44","44","ཨིན༌ནའང༌ ཤར༌ ཆོགས༌ དང༌ བྱང༌ ཆོགས༌ནེ༌ འུ༌ཡ༌ གྱུགས༌ཏེ༌ ཁོ༌ ཇིགས༌ཅུགས༌ ཡང༌ ཁོ༌ སྲོ༌ སྲན༌ཏྲེ༌ ནང༌ང༌ ཁྲེས༌ཏོར༌ ཅོའ༌ བིངས༌ ཡང༌ ངན༌པའེ༌ ཚུལ༌ལ༌ མི༌ མང༌པོ༌ སད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN11_45","028_11_45","DAN","11","45","45","ཁོའེ༌ གྱལ༌པོའེ༌ ཀུར༌བོ༌ མེ༌གྲི༌ཏྲེ༌རི༌ཡན༌ ཚོ༌ དང༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ ཏམ༌པ༌ ཆོད༌ཁང༌ རྩིགས༌ཁན༌ནི༌ རི༌ པར༌ལ༌ ཙུག༌ཨིན༌། ཨིན༌ནའང༌ ཁོ༌ མེད༌ཁན༌ ཆ༌ཅེས༌སི༌ ཏུས༌པོ༌ ལེབ༌ཨིན༌ ཡང༌ ཁོའ༌ སུའིང༌ རོགས༌ མི༌ཅོ༌།” ");
INSERT INTO lbj_vpl VALUES ("DN12_1","028_12_1","DAN","12","1","1","“ཏེ༌ཏུས༌, ཁྱོ༌རང༌ངི༌ མི༌གུན༌ སྐྱོབ༌ཁན༌ ཕོ༌ཉ༌ འུ༌སྐྱོང༌ མའེ༌ཀལ༌ སྐྱོད༌ཨིན༌། ཇིག༌རྟེན༌ ཞང༌ང༌ ཛད༌པ༌ནེ༌ ཕར༌ལ༌ མ༌ཇུང༌ཁན༌ནི༌ རྡུག༌ངལ༌ལི༌ ཏུས༌ ཇུང༌ཨིན༌། ཨིན༌ནའང༌ དཀོན༌མཆོག༌གི༌ སྤེ༌ཆའེ༌ ནང༌ང༌ མིང༌ བྲིའ༌ ཛད༌ཁན༌ ཁྱོ༌རང༌ངི༌ མི༌གུན༌ སྐྱོབ༌བ༌ ཛད༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN12_2","028_12_2","DAN","12","2","2","སྔུན༌ལ༌ ཤི༌ཏེ༌ སུབས༌ཁན༌ མ༌ མང༌པོ༌ སོན༌ཏེའ༌ ལང༌ང༌ ཛད༌ཨིན༌, ཁ༌ཅིག༌ ཐའ༌མེད༌པའེ༌ མི༌ཚེའེ༌ ནང༌ང༌ ཡང༌ ཁ༌ཅིག༌ ཁྲེལ༌བ༌ ཉམ༌པོ༌ ཐའ༌མེད༌པའེ༌ ཉལ༌ཝའེ༌ ནང༌ང༌ ལང༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN12_3","028_12_3","DAN","12","3","3","ཤེས༌རབས༌ཅན༌གུན༌ ནམ༌ཁའེ༌ འོད༌ ཙོགས༌ ལྡང༌ཤན༌ ཡང༌ མི༌གུན༌ ཀྲང༌པོ༌ ཆོགས༌ལ༌ ཁྲིད༌ཁན༌ མང༌པོ༌ སྐར༌མ༌ ཙོགས༌ལ༌ ཏུས༌གྱུན༌ བར༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("DN12_4","028_12_4","DAN","12","4","4","ཨིན༌ནའང༌ དཱ༌ནི༌ཨེལ༌ ཁྱོ༌རང༌ངི༌ འི༌ སྤེ༌ར༌གུན༌ བྲིས༌ ཡང༌ སྲིལ༌ཏེ༌ ཐེ༌ཙེ༌ གྱབས༌ཏེ༌ ཐའ༌མའེ༌ ཏུས༌ ཚོག༌པ༌ བོར༌། མི༌མང༌པོ༌ འི༌ངོ༌ འ༌ངོ༌ ཚང༌མ༌ལ༌ ཆེན༌ ཡང༌ ཁོང༌གུན༌ལ༌ ལས༌ མང༌པོ༌ ལོབས༌ཏེ༌ རིག༌པའེ༌ ནང༌ང༌ གྱས༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN12_5","028_12_5","DAN","12","5","5","“ཏེ༌ནེ༌ ང༌ དཱ༌ནི༌ཨེལ༌ལི༌ ལྟས༌པ༌, ངའ༌ ལྩངས༌པོའེ༌ ཐའ༌མ༌ ཉིས༌ཀོའེ༌ཀ༌ ཡང༌ ཕོ༌ཉ༌ ཉིས༌ ཞངས༌ཏེ༌ ཐོང༌། ");
INSERT INTO lbj_vpl VALUES ("DN12_6","028_12_6","DAN","12","6","6","ཕོ༌ཉ༌ ཅིག༌པོའེ༌ རས༌ ཀུས༌པོའེ༌ ཀོས༌ གོན༌ཁན༌, ལྩངས༌པོའེ༌ ཆུའི༌ ཁེ༌ཐོག༌ག༌ ཡོད༌ཁན༌བོའ༌ མོལས༌, “འི༌ ཇིགས༌ནང༌ དང༌ ཧ༌ལས༌ཤེས༌སི༌ ལྟས༌གུན༌ ཇུང༌ཅེས༌ལ༌ ཏུས༌ ཙམ༌ཤིག༌ གོར༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("DN12_7","028_12_7","DAN","12","7","7","རས༌ ཀུས༌པོའེ༌ ཀོས༌ གོན༌ཁན༌, ལྩངས༌པོའེ༌ ཆུའི༌ ཁེ༌ཐོག༌ག༌ ཡོད༌ཁན༌བོའེ༌ ཁོང༌རང༌ངི༌ ཆག༌ ཉིས༌ཀོ༌ ནམ༌ཁའ༌ སྟགས༌ཏེ༌ ཏུས༌གྱུན༌ སོན༌པོ༌ ཞུགས༌ཁན༌ནི༌ ཚན༌ནི༌ ནང༌ང༌ ནའ༌ ཁུར༌ཏེ༌ མོལས༌, “ཏེ༌བོ༌ ལོ༌ སུམ༌ དང༌ ཕེད༌། རྡུག༌ངལ༌ སྟན༌ཁན༌གུན༌ནི༌ གྱབ༌གལ༌ལ༌ དཀོན༌མཆོག༌གི༌ ཏམ༌པ༌ མི༌གུན༌ནི༌ སྟོབས༌ དང༌ ཁྱུད༌ ཚང༌མ༌ མེད༌ཁན༌ ཆའ༌ཅིག༌, འི༌ ཚང༌མ༌ གྲུབ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN12_8","028_12_8","DAN","12","8","8","ངའེ༌ ཁོང༌ངི༌ མོལ༌ཁན༌བོ༌ ཚོར༌ ཨིན༌ནའང༌ ཧ༌མ༌གོ༌། ཏེ༌བོའེ༌ཕིའ༌ ངའེ༌ ཏྲིས༌པིན༌, “གཙོ༌བོ༌ལེ༌, འི༌གུན༌ནི༌ ཇུག༌བྲས༌པོ༌ ཀ༌ཟུག༌ཤིག༌ ཡོང༌ཨིན༌?” ");
INSERT INTO lbj_vpl VALUES ("DN12_9","028_12_9","DAN","12","9","9","ཁོང༌ངི༌ ལན༌ སལས༌, “དཱ༌ནི༌ཨེལ༌ ཁྱོ༌རང༌ ཞི༌དེ༌ ཉམ༌པོ༌ སོང༌ ཡང༌ འི༌ ཚང༌མ༌ ཐའ༌མའེ༌ ཏུས༌ ཚོག༌པ༌ ཐེ༌ཙེ༌ གྱབས༌ཏེ༌ སང༌ཝའེ༌ ནང༌ང༌ བོར༌། ");
INSERT INTO lbj_vpl VALUES ("DN12_10","028_12_10","DAN","12","10","10","མི༌མང༌པོ༌ ཁྲུས༌ཏེ༌ རྩང༌མ༌ ཅོས༌ཏེ༌ ལག༌མོ༌ ཀར༌པོ༌ ཅོ༌ཨིན༌ ཨིན༌ནའང༌ ངན༌པ༌གུན༌ནི༌ ཏ༌རུང༌ངའང༌ ངན༌པ༌ ཅོ༌ཅེས༌ མི༌ཕང༌། ངན༌པ༌གུན༌ལ༌ ཧ༌མི༌གོ༌ ཨིན༌ནའང༌ ཤེས༌རབས༌ཅན༌གུན༌ལ༌ ཧ༌གོ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN12_11","028_12_11","DAN","12","11","11","ཞག༌ཏང༌ངི༌ ཆོད༌པ༌ ཕུལ༌ཅེས༌གུན༌ སྒགས༌ཏེ༌ ཏེ༌ ཁམ༌ལོག༌ ཚི༌ཏུ༌ ཅོ༌ཁན༌བོ༌ ཆོད༌ཁང༌ངི༌ ནང༌ང༌ བོར༌ཏེ༌ ཞག༌ 1,290 ཆེན༌། ");
INSERT INTO lbj_vpl VALUES ("DN12_12","028_12_12","DAN","12","12","12","ཞག༌ 1,335 སྟིང༌ཇུག༌ ཚོག༌པ༌ སྲུངས༌ཏེ༌ དུག༌ཁན༌གུན༌ ཅིན༌ལབས༌ཅན༌ ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("DN12_13","028_12_13","DAN","12","13","13","“ཏེ༌བོའེ༌ཕིའ༌ སོན༌ཏེའ༌ ལུས༌ལུས༌ ཁྱོ༌རང༌ངི༌ ཏད༌པ༌ དཀོན༌མཆོག༌གི༌ཀ༌ སྟན༌པོ༌ བོར༌། ཁྱོ༌རང༌ ཤི༌ཨིན༌ ཨིན༌ནའང༌ ཐའ༌མའེ༌ ཏུས༌ལ༌ ཐེན༌ཏེ༌ བོར༌ཁན༌ནི༌ ནོར༌སྐལ༌ ལེན༌ཅེས༌ལ༌ ཁྱོ༌རང༌ སོན༌ཏེའ༌ ལང༌ཨིན༌།”");
INSERT INTO lbj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","འི༌བོ༌ ནི༌ གཙོ༌བོ༌ ཡེ༌ཤུ༌ མ༌ཤི༌ཀའེ༌ ཕ༌མེས༌པོ༌གུན༌ནི༌ ཐོ༌ཨིན༌, ཁོང༌ གྱལ༌པོ༌ དཱ༌བིད༌ དང༌ ཨབ༌ར༌ཧམ༌མི༌ པུར༌གྱུད༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ཨབ༌ར༌ཧམ༌ ནི༌ ཨི༌སཱག༌གི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨི༌སཱག༌ ནི༌ ཡ༌ཀོབ༌བི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཡ༌ཀོབ༌ ནི༌ ཡ༌ཧུ༌དཱ༌ དང༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌ ཚང༌མའེ༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ཡ༌ཧུ༌དཱ༌ ནི༌ ཕེ༌རེས༌ དང༌ ཟེ༌རཧ༌ གུན༌ནི༌ ཨ༌བ༌, ཡང༌ ཁོང༌གུན༌ནི༌ ཨ༌མ༌ ནི༌ ཐ༌མར༌ ཨིན༌པིན༌། ཕེ༌རེས༌ ནི༌ ཧེས༌རོན༌ནི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཧེས༌རོན༌ ནི༌ རམ༌མི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","རམ༌ ནི༌ ཨམ༌མི༌ན༌དབ༌བི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨམ༌མི༌ན༌དབ༌ ནི༌ ན༌ཧ༌ཤོན༌ནི༌ ཨ༌བ༌ ཨིན༌པིན༌། ན༌ཧ༌ཤོན༌ ནི༌ སལ༌མོན༌ནི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","སལ༌མོན༌ ནི༌ བོ༌ཨཟ༌ཟི༌ ཨ༌བ༌, ཡང༌ ཁོའེ༌ ཨ༌མ༌ ནི༌ ར༌ཧབ༌ ཨིན༌པིན༌། བོ༌ཨཟ༌ ནི༌ ཨོ༌བེད༌དི༌ ཨ༌བ༌, ཡང༌ ཁོའེ༌ ཨ༌མ༌ ནི༌ རུཐ༌ ཨིན༌པིན༌། ཨོ༌བེད༌ ནི༌ ཡེ༌ཤེའེ༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ཡེ༌ཤེ༌ ནི༌ གྱལ༌པོ༌ དཱ༌བིད༌དི༌ ཨ༌བ༌ ཨིན༌པིན༌། དཱ༌བིད༌ ནི༌ སོ༌ལོ༌མོན༌ནི༌ ཨ༌བ༌, ཡང༌ ཁོའེ༌ ཨ༌མ༌ ནི༌ ཨུ༌རི༌ཡཱཧ༌ཧའེ༌ ན༌མ༌ བད༌ཤི༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","སོ༌ལོ༌མོན༌ ནི༌ རེ༌ཧབ༌བོ༌འམ༌མི༌ ཨ༌བ༌ ཨིན༌པིན༌། རེ༌ཧབ༌བོ༌འམ༌ ནི༌ ཨ༌བི༌ཡཱའེ༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨ༌བི༌ཡཱ༌ ནི༌ ཨ༌སའེ༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ཨ༌ས༌ ནི༌ ཡེ༌ཧོ༌ཤ༌ཕད༌དི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཡེ༌ཧོ༌ཤ༌ཕད༌ ནི༌ ཡེ༌ཧོ༌རམ༌མི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཡེ༌ཧོ༌རམ༌ ནི༌ ཨུཟ༌ཟི༌ཡཱའི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ཨུཟ༌ཟི༌ཡཱ༌ ནི༌ ཡོ༌ཐམ༌མི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཡོ༌ཐམ༌ ནི༌ ཨ༌ཧ༌ཟིའི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨ༌ཧ༌ཟི༌ ནི༌ ཧི༌ཟི༌ཀི༌ཡའི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ཧི༌ཟི༌ཀི༌ཡ༌ ནི༌ མ༌ན༌ཤེའེ༌ ཨ༌བ༌ ཨིན༌པིན༌། མ༌ན༌ཤེ༌ ནི༌ ཨ༌མོན༌ནི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨ༌མོན༌ ནི༌ ཡོ༌ཤི༌ཡཱའི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ཡང༌ མག༌གི༌ སྟིང༌ནེ༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ བ༌བེ༌ལོན༌ལ༌ ཁྱེར༌རི༌ ཏུས༌ ཡོ༌ཤི༌ཡཱ༌ ནི༌ ཡེ༌ཀོ༌ནི༌ཡཱ༌ དང༌ ཁོའེ༌ ཨ༌ཅོ༌ནོ༌གུན༌ནི༌ མེ༌མེ༌ གྱུར༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","བ༌བེ༌ལོན༌ལ༌ ཁྱེར༌ཏེ༌ སྟིང༌ནེ༌ ཡེ༌ཀོ༌ནི༌ཡཱ༌ ནི༌ ཤའལ༌ཏི༌ཡེལ༌ལི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཤའལ༌ཏི༌ཡེལ༌ ནི༌ ཟེ༌རུཔ༌བ༌བེལ༌ལི༌ མེ༌མེ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ཟེ༌རུཔ༌བ༌བེལ༌ ནི༌ ཨ༌བི༌ཧུད༌དི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨ༌བི༌ཧུད༌ ནི༌ ཨེ༌ལི༌ཡ༌ཀིམ༌མི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨེ༌ལི༌ཡ༌ཀིམ༌ ནི༌ ཨ༌ཟོར༌རི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ཨ༌ཟོར༌ ནི༌ ཟ༌དོག༌གི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཟ༌དོག༌ ནི༌ ཨ༌ཀིམ༌མི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨ༌ཀིམ༌ ནི༌ ཨེ༌ལི༌ཧུད༌དི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ཨེ༌ལི༌ཧུད༌ ནི༌ ཨེ༌ལི༌འ༌ཟར༌རི༌ ཨ༌བ༌ ཨིན༌པིན༌། ཨེ༌ལི༌འ༌ཟར༌ ནི༌ མད༌ཐན༌ནི༌ ཨ༌བ༌ ཨིན༌པིན༌། མད༌ཐན༌ ནི༌ ཡ༌ཀོབ༌བི༌ ཨ༌བ༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ཡ༌ཀོབ༌ ནི༌ ཡོ༌སེབ༌བི༌ ཨ༌བ༌ ཡང༌ ཡོ༌སེབ༌བི༌ ན༌མ༌ ནི༌ མིར༌ཡམ༌ ཨིན༌པིན༌, ཁོའ༌ ཡེ༌ཤུ༌, དཀོན༌མཆོག༌གི༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ མ༌ཤི༌ཀ༌ ལྟམས༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ལྡུས༌ཏེ༌ ཟེར༌ན༌ ཨབ༌ར༌ཧམ༌ནེ༌ གྱལ༌པོ༌ དཱ༌བིད༌དི༌ པར༌ལ༌ མི༌རབས༌ 14, ཡང༌ གྱལ༌པོ༌ དཱ༌བིད༌དི༌ ཏུས༌ནེ༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ བ༌བེ༌ལོན༌ནི༌ ཡུལ༌ལ༌ ཁྱེར༌ཁྱེར༌ ཚག༌པ༌ མི༌རབས༌ 14, ཡང༌ ཡ༌ཧུ༌དཱ༌པ༌གུན༌ བ༌བེ༌ལོན༌ལ༌ ཁྱེར༌ཁན༌ནི༌ ཏུས༌ནེ༌ མ༌ཤི༌ཀའེ༌ ཏུས༌ ཚག༌པ༌ མི༌རབས༌ 14 ཡོད༌ཏེ༌ ཨིན༌ནོག༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","གཙོ༌བོ༌ ཡེ༌ཤུ༌, དཀོན༌མཆོག༌གི༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ མ༌ཤི༌ཀའེ༌ ཁྲུང༌ ཚུལ༌ ནི༌ འི༌ཟུག༌གི༌ ཇུངས༌ཏེ༌ ཨིན༌པིན༌, ཁོང༌ངི༌ ཨ༌མ༌ མིར༌ཡམ༌ ཡོ༌སེབ༌བ༌ ན༌མ༌ ཏྲིས༌ཏེ༌ ཨིན༌པིན༌། ཨིན༌ནའང༌ ཁོང༌གུན༌ ཛོམས༌ཏེ༌ ཉམ༌པོ༌ དུག༌གི༌ སང༌ སྔུན༌ལ༌ ཏམ༌པའེ༌ ཐུག༌ཉིད༌དི༌ མིར༌ཡམ༌ སྐྱེ༌ཅེས༌མ༌ཞིག༌ གྱུར༌ཅུགས༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ཁོ༌ ན༌མ༌ ཏྲི༌ཁན༌ ཡོ༌སེབ༌, མི༌ ཀྲང༌པོ༌ཞིག༌ ཨིན༌པ༌, མིར༌ཡམ༌མ༌ མི༌གུན༌ནི༌ དུན༌ལ༌ ཁྲེལ༌བ༌ ཆ༌ མི༌ཅུག༌ སམས༌ཏེ༌, ཁོ༌རང༌ངི༌ སམ༌བའེ༌ ནང༌ང༌ སང༌ཝའེ༌ ཐོག༌ནེ༌ མིར༌ཡམ༌ ཉམ༌པོ༌ ན༌མ༌ མི༌ཅོ༌ སམས༌ཏེ༌ ཐག༌ཅདས༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ཏེ༌ཟུག༌ ཐག༌ཅད༌ཏེ༌ སྟིང༌ནེ༌, ཡོ༌སེབ༌བི༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉའེ༌ འི༌ཟུག༌ མོལ༌ཨིན༌ ཇལ༌, “གྱལ༌པོ༌ དཱ༌བིད༌དི༌ པུར༌གྱུད༌ ཡོ༌སེབ༌, མིར༌ཡམ༌མ༌ ན༌མ༌ ཅོས༌ཏེ༌ ཁྱེར༌ཅེས༌ལ༌ ཇིགས༌ མ༌ཇིགས༌, མིར༌ཡམ༌མི༌ ནང༌ང༌ ཆགས༌ཁན༌ནི༌ ཕྲུ༌གུ༌བོ༌ ཏམ༌པའེ༌ ཐུག༌ཉིད༌དི༌ ཞས༌ཏེ༌ ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","མིར༌ཡམ༌མ༌ བུ༌ཚ༌ཞིག༌ སྐྱེ༌ཨིན༌, ཡང༌ ཁྱོ༌རང༌ངི༌ ཁོང༌ངི༌ ཚན༌ལ༌ ཡེ༌ཤུ༌ ཏག༌གོས༌ ཅིའ༌ཟེར༌ན༌ ཁོང༌ངི༌ ཁོང༌རང༌ངི༌ མི༌གུན༌ ཁོང༌གུན༌ནི༌ སྡིག༌པའེ༌ ཀ༌ནེ༌ སྐྱོབ༌བ༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ལུང༌སྟོན༌པ༌ ཡེ༌ཤ༌ཡཱ༌ གྱུད༌ཏེ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌ ཚང༌མ༌ གྲུབ༌ཅེས༌སི༌ ཕིའ༌ ཏེ༌ ཚང༌མ༌ ཇུངས༌ཏེ༌ ཨིན༌ནོག༌། ཡེ༌ཤ༌ཡཱའེ༌ བྲིས༌ཁན༌བོ༌ ནི༌, ");
INSERT INTO lbj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ལྟོས༌ ན༌ཆུང༌, བུ༌ཚ༌ ཉམ༌པོ༌ བྲེལ༌ མ༌ཆའ༌ཁན༌ ཞིག༌གི༌ ནང༌ང༌ ཕྲུ༌གུ༌ ཆགས༌ཏེ༌ བུ༌ཚ༌ཞིག༌ ཇོར༌ཨིན༌, ཡང༌ ཁོང༌ངི༌ ཚན༌ལ༌ ཨེམ༌མ༌ནུ༌ཨེལ༌ ཞུ༌ཨིན༌ , ཀ༌བོའེ༌ ཏོན༌ཏག༌པོ༌ ནི༌ ‘དཀོན༌མཆོག༌ ང༌དང༌ ཉམ༌པོ༌’ ཨིན༌ནོག༌།” ");
INSERT INTO lbj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ཡོ༌སེབ༌བ༌ ཉིད༌ཚད༌ད༌ཅིག༌, གཙོ༌བོའེ༌ ཕོ༌ཉའེ༌ མོལ༌ཁན༌ ནང༌ཞིན༌ མིར༌ཡམ༌ ཉམ༌པོ༌ ན༌མ༌ ཅོས༌ཏེ༌ ཁོ༌རང༌ངི༌ ཁང༌པ༌ ཁྱོངས༌། ");
INSERT INTO lbj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ཨིན༌ནའང༌ སྲས༌པོ༌ ཇོར༌ཇོར༌ ཚོག༌པ༌ ཡོ༌སེབ༌བི༌ མིར༌ཡམ༌ ཉམ༌པོ༌ ལུས༌བྲེལ༌ མ༌ནེ༌ མ༌བོརས༌, ཡང༌ སྲས༌པོའེ༌ ཚན༌ལ༌ ཡོ༌སེབ༌བི༌ ཡེ༌ཤུ༌ ཏག༌ག༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ཧེ༌རོད༌ གྱལ༌པོ༌ ཨིན༌ ཟ༌ནེ༌, ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ལི༌ བེད༌ལེ༌ཧེམ༌མི༌ ནང༌ང༌ ཡེ༌ཤུ༌ སྐུ༌ ལྟམས༌། ཏེ༌ཏུས༌ལ༌ ཤར༌ ཆོགས༌ནེ༌ ཤེས༌རབས༌ཅན༌ སྐར༌མ༌ སིལ༌ཁན༌ནི༌ མི༌ ཁ༌ཅིག༌ ཡེ༌རུ༌ཤ༌ལེམ༌མི༌ གྱལ༌ས༌ ཡོངས༌ཏེ༌ ");
INSERT INTO lbj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ཏྲིས༌, “ཡ༌ཧུ༌དཱ༌པའེ༌ གྱལ༌པོ༌ ལྟམས༌ཁན༌བོ༌ ཀ༌ནེ༌ དུག༌? ང༌ཞའ༌ ཁོང༌ངི༌ སྐར༌མ༌ ཤར༌ ཆོགས༌ལ༌ ཐོང༌པ༌, ཁོང༌ ཇལ༌ལ༌ ཡོངས༌པིན༌།” ");
INSERT INTO lbj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ཏེ༌ སྤེ༌ར༌བོ༌ ཚོར༌ར༌ཅིག༌, གྱལ༌པོ༌ ཧེ༌རོད༌ ཧ༌ལས༌ཏེ༌ ཇིགས༌ ཡང༌ ཡེ༌རུ༌ཤ༌ལེམ༌པ༌ ཚང༌མའང༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","གྱལ༌པོ༌ ཧེ༌རོད༌དི༌ བླ༌མ༌ འུ༌སྐྱོང༌ དང༌ ཆོས༌ཁྲིམས༌ལ༌ ཁས༌པ༌ ཚང༌མ༌ བོད༌ཏེ༌ “དཀོན༌མཆོག༌གི༌ ལྡམ༌མ༌ ཛད༌ཁན༌ནི༌ མ༌ཤི༌ཀ༌ ཀ༌རུ༌ ཁྲུངས༌ཤེས༌ དུག༌” ཟེར༌ཏེ༌ ཏྲིས༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ཁོང༌གུན༌ནི༌ ལན༌ཏངས༌, “ཡ༌ཧུ༌དཱའེ༌ གྲོང༌ཁྱེར༌ བེད༌ལེ༌ཧེམ༌མ༌: ཀ༌ཟུག༌ ལུང༌སྟོན༌པ༌ མི༌ཀའི༌ དཀོན༌མཆོག༌གི༌ མོལ༌ལ༌ ཛད༌ཁན༌བོ༌ བྲིའ༌ ཛད༌ཏེ༌ ཨིན༌ནོག༌, ");
INSERT INTO lbj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘ཡ༌ཧུ༌དཱའེ༌ གྲོང༌ཁྱེར༌ བེད༌ལེ༌ཧེམ༌, ཡ༌ཧུ༌དཱ༌པའེ༌ ཡུལ༌ཇོངས༌སི༌ ནང༌ང༌ ཁྱོ༌ཞའེ༌ གྲོང༌ཁྱེར༌ ཆུ༌ངུན༌བོའང༌, གྲོང༌ཁྱེར༌ མ༌ ཁག༌ཅན༌ཞིག༌ གྱུར༌ཨིན༌, ཅིའ༌ཟེར༌ན༌ ཁྱོ༌ཞའེ༌ ཕྲོ༌ནེ༌ ཏེ༌ཟུག༌ ཝང༌སྲུལ༌པ༌ཞིག༌ ཡོང༌ཨིན༌, ཀ༌བོའེ༌ ཨིས༌ར༌ཨེལ༌པ༌ ངའེ༌ མི༌གུན༌ལ༌ ལུག༌རྫི༌ ཚུལ༌ལ༌ སྟ༌སྟོག༌ ཅོ༌ཨིན༌།’” ");
INSERT INTO lbj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ཏེ༌ནེ༌ ཧེ༌རོད༌དི༌ ཤར༌ ཆོགས༌སི༌ ཤེས༌རབས༌ཅན༌གུན༌ སུའང༌ གྱུས༌ཆའ༌ མ༌ཅུག༌ག༌ ཅིག༌པོ༌ བོད༌ཏེ༌ སྐར༌མ༌ གོ༌མ༌རང༌ ཐོང༌ཁན༌ནི༌ ཏུས༌པོ༌ གྱུས༌ཅོས༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ཁོའེ༌ ཁོང༌གུན༌ བེད༌ལེ༌ཧེམ༌མ༌ ལམ༌ཅུགས༌ཏེ༌ ཟེརས༌, “སོང༌, ཞིབ༌སལ༌ ཅོས༌ཏེ༌ ཕྲུ༌གུ༌བོ༌ ཙོལ༌, ཡང༌ ཁོང༌ ཐོབ༌བ༌ཅིག༌ ལོགས༌ཏེ༌ ཡོངས༌ཏེ༌ ངའ༌ ཤོད༌, ཅིའ༌ཟེར༌ན༌ ངའ༌ ཁོང༌ ཇལ༌ལ༌ སོང༌ཏེ༌ ཁོང༌ང༌ ཅོལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","གྱལ༌པོའེ༌ སྤེ༌ར༌ ཟེར༌ཁན༌གུན༌ ཉན༌ཏེ༌ སྟིང༌ནེ༌, ཁོང༌གུན༌ ཤར༌ ཆོགས༌ལ༌ ཐོང༌ཁན༌ནི༌ སྐར༌མའེ༌ གྱབ༌ནེ༌ སོང༌, ཀ༌བོ༌ ཕྲུ༌གུ༌ ཡོད༌སའེ༌ ནས༌སའེ༌ཀ༌ ལེབ༌བ༌ཅིག༌, ནམ༌ཁའེ༌ ནང༌ང༌ གྲུལ༌ མ༌གྲུལ༌ལ༌ དུགས༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","སྐར༌མ༌བོ༌ གྲུལ༌ མ༌གྲུལ༌ལ༌ དུགས༌ཏེ༌ ཐོང༌ང༌ཅིག༌, ཁོང༌གུན༌ནི༌ སེམས༌ ཐད༌པོའེ༌ གངས༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ཁང༌པའེ༌ ནང༌ང༌ ཆའ༌ཅིག༌, ཁོང༌གུན༌ནི༌ ཕྲུ༌གུ༌ ཁོང༌རང༌ངི༌ ཨ༌མ༌ མིར༌ཡམ༌ ཉམ༌པོ༌ ཐོང༌, ཡང༌ ཁོང༌གུན༌ནི༌ པིག༌དོང༌ ཙུགས༌ཏེ༌ ཆག༌ཕུལས༌། ཏེ༌ནེ༌ སྟེར༌སྒམ༌གུན༌ ཕེས༌ཏེ༌ སེར༌, ཕརང༌ཀེན༌སེནས༌ དང༌ མའེར༌ ཟེར༌ཁན༌ནི༌ ཏྲི༌ཞིམ༌ཅན༌ནི༌ སྤོས༌ དང༌ མར༌རི༌ སྐྱེས༌གུན༌ ཁོང༌ང༌ ཕུལས༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ཡང༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ ཁོང༌གུན༌ལ༌ གྱལ༌པོ༌ ཧེ༌རོད༌ ཡོད༌ས༌ ལོགས༌ཏེ༌ མི༌ཆ༌ཅེས༌ལ༌ སྤང༌པུད༌པ༌, ལམ༌ སོ༌སོ༌ཞིག༌ནེ༌ རང༌ཡུལ༌ལ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ཤེས༌རབས༌ཅན༌གུན༌ ལོགས༌ཏེ༌ ཆའ༌ཅིག༌, དཀོན༌མཆོག༌གི༌ ཕོ༌ཉ༌ཞིག༌ ཡོ༌སེབ༌བི༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ མོལ༌ཨིན༌ ཇལ༌, “ལོངས༌, ཕྲུ༌གུ༌ དང༌ ཁོང༌ངི༌ ཨ༌མའ༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ཇོངས༌ལ༌ ཁྲིད༌ཏེ༌ ཤོར༌། ཡང༌ ནམ༌ཚོག༌པ༌ ངའེ༌ མི༌ཟེར༌ ཏེ༌ཏེ༌ཚོག༌པ༌ ཏེ༌རུ༌ དུག༌, ཅིའ༌ཟེར༌ན༌ གྱལ༌པོ༌ ཧེ༌རོད༌དི༌ འི༌ ཕྲུ༌གུ༌བོ༌ སད༌ཅེས༌ལ༌ ཙལ༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ཡོ༌སེབ༌ ལངས༌ཏེ༌ ཕྲུ༌གུ༌ དང༌ ཕྲུ༌གུའི༌ ཨ༌མ༌ མིར༌ཡམ༌ ཉིས༌ཀོ༌ ཁྲིད༌ཏེ༌ ཏེན༌ན༌ ཚན༌ལ༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ལ༌ ཤོར༌ཏེ༌ སོང༌, ");
INSERT INTO lbj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ཀ༌རུ༌ ཁོང༌གུན༌ གྱལ༌པོ༌ ཧེ༌རོད༌ ཤི༌ཤི༌ ཚོག༌པ༌ ཞུགས༌། ཀ༌ཟུག༌གི༌ དཀོན༌མཆོག༌གི༌ ལུང༌སྟོན༌པ༌ གྱུད༌ཏེ༌, “ངའེ༌ ཨི༌ཇིབ༌ ཡུལ༌ནེ༌ ཕི༌ལོག༌ག༌ ང༌རང༌ངི༌ བུ༌ཚ༌ བོད༌པིན༌” མོལ༌ཏེ༌ ཡོད༌ཁན༌བོ༌ དྲན༌དྲ༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","གྱལ༌པོ༌ ཧེ༌རོད༌དི༌ ཤེས༌རབས༌ཅན༌གུན༌ནི༌ གོབ༌སྐོར༌ ཏང༌ཁན༌བོ༌ ཧ༌གོ༌པ༌ མ༌སྲན༌ཏྲེ༌ སྲོ༌ ཡོངས༌། ཁོའེ༌ བེད༌ལེ༌ཧེམ༌ དང༌ ཏེ༌ ཉེ༌ཁོར༌རི༌ ཡུལ༌ལི༌ ནང༌ང༌ ཡོད༌ཁན༌ནི༌ བུ༌ཚ༌ ལོ༌ ཉིས༌ ཡང༌ ཏེ༌སང༌ ཆུང༌ང༌ ཚང༌མ༌ སོད༌ ཟེར༌ཏེ༌ བཀའ༌ ཏངས༌, ཀ༌བོ༌ ཤེས༌རབས༌ཅན༌གུན༌ནི༌ ཏང༌པོ༌རང༌ སྐར༌མ༌བོ༌ ཐོང༌ ཟེར༌ཁན༌ནི༌ ཏུས༌ ནང༌ཞིན༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ཏེ༌ནེ༌ ལུང༌སྟོན༌པ༌ ཡེ༌རེམ༌ཡཱ༌ གྱུད༌ཏེ༌ དཀོན༌མཆོག༌གི༌ མོལ༌ཁན༌གུན༌ གྲུབ༌། ཏེ༌བོ༌ ནི༌, ");
INSERT INTO lbj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ར༌མཧའེ༌ ཡུལ༌ནེ༌ སྐད༌ ཚོར༌ཨིན༌, ངུ༌ཨིན༌ ཡང༌ རྡུག༌པོ༌ ཅོ༌ཨིན༌། རེ༌ཅལ༌ལི༌ པུར༌གྱུད༌ རང༌ངི༌ ཕྲུ༌གུ༌གུན༌ནི༌ ཕིའ༌ ངུ༌ཨིན༌, ཨིན༌ནའང༌ སེམས༌སོ༌ མི༌གོས༌, ཅིའ༌ཟེར༌ན༌ ཕྲུ༌གུ༌གུན༌ ཤི༌ཏེ༌ མེད༌།” ");
INSERT INTO lbj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","གྱལ༌པོ༌ ཧེ༌རོད༌ ཤི༌ཏེ༌ སྟིང༌ནེ༌, ཡོ༌སེབ༌ ཨི༌ཇིབ༌བི༌ ཡུལ༌ལ༌ ཡོད༌དི༌ ཏུས༌ལ༌ ཁོའ༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ དཀོན༌མཆོག༌གི༌ ཕོ༌ཉ༌ཞིག༌གི༌ མོལས༌, ");
INSERT INTO lbj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ལོངས༌, ཕྲུ༌གུ༌ དང༌ ཁོང༌ངི༌ ཨ༌མ༌ ཁྲིད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ ཡུལ༌ལ༌ སོང༌ ཅིའ༌ཟེར༌ན༌ ཕྲུ༌གུ༌ སད༌ད༌ལ༌ ཙལ༌ཁན༌གུན༌ ཤི༌ཏེ༌ མེད༌།” ");
INSERT INTO lbj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ཏེ༌བོའེ༌ཕིའ༌ ཡོ༌སེབ༌ ལངས༌ཏེ༌ ཕྲུ༌གུ༌ དང༌ ཨ༌མ༌ ཁྲིད༌ཏེ༌ ཨིས༌ར༌ཨེལ༌ལི༌ ཡུལ༌ལ༌ ལོགས༌ཏེ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ཨིན༌ནའང༌ ཡོ༌སེབ༌བ༌ ཧེ༌རོད༌དི༌ ཚབས༌ལ༌ ཁོའེ༌ བུ༌ཚ༌ ཨར༌ཁེ༌ལཱིས༌ ཡ༌ཧུ༌དཱའེ༌ གྱལ༌པོ༌ ཅོ༌ཁན༌བོ༌ ཚོར༌ར༌ཅིག༌, ཁོ༌ ཡ༌ཧུ༌དཱའེ༌ ཡུལ༌ཇོངས༌ལ༌ ལོགས༌ཏེ༌ ཆ༌ཅེས༌ལ༌ ཇིགས༌། ཁོའ༌ ཉི༌ལམ༌མི༌ ནང༌ང༌ སྤང༌པུད༌ད༌ ཛད༌ པ༌སང༌ གཱ༌ལིལ༌ལིའི༌ ཡུལ༌ཇོངས༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ཁོང༌གུན༌ སོང༌ཏེ༌ ན༌ཙ༌རེད༌ ཟེར༌ཁན༌ནི༌ གྲོང༌ཁྱེར༌རི༌ ནང༌ང༌ དུགས༌། ཏེན༌ན༌བོའེ༌ཕིའ༌ སྔུན༌མའེ༌ ལུང༌སྟོན༌པ༌གུན༌ནི༌ ཁོང༌ངི༌ སྐོར༌ལ༌ “ཁོང༌ང༌ ན༌ཙ༌རེད༌པ༌ ཞུའ༌ཨིན༌” མོལ༌ཁན༌བོ༌ དྲན༌དྲ༌ གྲུབ༌། ");
INSERT INTO lbj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ལོ༌ མང༌པོའེ༌ སྟིང༌ནེ༌ ཁྲུས༌སལ༌ཁན༌ ཡོ༌ཧཱ༌ནན༌ནི༌ ཆོས༌ཤད༌ཅེས༌ གོ༌ཟུགས༌, ཁོང༌ངི༌ ཡ༌ཧུ༌དཱའེ༌ རི༌སྟོང༌ངི༌ ནང༌ང༌ མི༌གུན༌ལ༌ ཆོས༌ཤད༌ཨིན༌ ");
INSERT INTO lbj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","མོལས༌, “ནམ༌ཁའེ༌ གྱལ༌སྲིད༌ ཉེ༌མོའ༌ ལེབས༌ཏེ༌ ཨིན༌ནོག༌, གྱོད༌པ༌ ཅོས༌ཏེ༌ དཀོན༌མཆོག༌ ཆོགས༌ལ༌ སེམས༌ གྱུར༌ཤིག༌།” ");
INSERT INTO lbj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ལུང༌སྟོན༌པ༌ ཡེ༌ཤ༌ཡཱའེ༌ ཁྲུས༌སལ༌ཁན༌ ཡོ༌ཧཱ༌ནན༌ནི༌ སྐོར༌ལ༌ མོལ༌དུག༌, “རི༌སྟོང༌ངི༌ ནང༌ང༌ སྐད༌ ཆེན༌མོ༌ཞིག༌གི༌ མོལ༌ཨིན༌, ‘གཙོ༌བོ༌ ཕེབ༌ཤེས༌ལ༌ གྲལ༌གྲིག༌ ཅོས༌, ཡང༌ ཁོང༌ངི༌ ཕེབས༌ལམ༌བོ༌ ཀྲང༌པོ༌ ཅོས༌།’” ");
INSERT INTO lbj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ཡོ༌ཧཱ༌ནན༌ནི༌ རྔ༌བོང༌ངི༌ བལ༌ལ༌ ཐགས༌ཁན༌ནི༌ ཀོས༌ དང༌ སྐེད༌པ༌ ཀོའེ༌ སྐྱེ༌རགས༌ ཅིང༌ངད༌པིན༌། ཁོང༌ངི༌ ཁར༌ཇི༌ ནི༌ པར༌པར༌ཙེ༌ དང༌ རི༌སྟོང༌ངི༌ རང༌རྩི༌ ཨིན༌པིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ཏེ༌ཏུས༌ ཡེ༌རུ༌ཤ༌ལེམ༌, ཡ༌ཧུ༌དཱ༌ གང༌པོ༌ དང༌ ཡོར༌དཱན༌ ལུང༌པ༌ གང༌པོའེ༌ མི༌གུན༌ ཁོང༌ང༌ ལྟ༌ཅེས༌ དང༌ ཉན༌ན༌ལ༌ སོང༌། ");
INSERT INTO lbj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ཁོང༌གུན༌ནི༌ རང༌རང༌ངི༌ སྡིག༌པའེ༌ ལས༌གུན༌ མི༌གུན༌ནི༌ དུན༌ལ༌ ཤདས༌ པ༌སང༌ ཡོ༌ཧཱ༌ནན༌ནི༌ ཁོང༌གུན༌ལ༌ ཡོར༌དཱན༌ ལྩངས༌པོའེ༌ ནང༌ང༌ ཁྲུས༌སལ༌ལ༌ ཛདས༌། ");
INSERT INTO lbj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ཨིན༌ནའང༌ ཕ༌རུ༌ཤི༌པ༌ དང༌ སད༌དུ༌ཀི༌པ༌ མང༌པོ༌ཞིག༌ ཁྲུས༌ལེན༌ན༌ ཡོང༌ཨིན༌ ཟིགས༌ཏེ༌ ཡོ༌ཧཱ༌ནན༌ནི༌ མོལས༌, “ཁྱོ༌ཞའ༌ ཏུག༌རུལ༌ལི༌ པུར༌གྱུད༌གུན༌, ཡོང༌ཅེས༌ཅན༌ནི༌ དཀོན༌མཆོག༌གི༌ ཆད༌པ༌ནེ༌ ཤོར༌ ཟེར༌ཏེ༌ ཁྱོ༌ཞའ༌ སྤང༌ སུའི༌ ཕུདས༌། ");
INSERT INTO lbj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","སྡིག༌པ༌ ཅོ༌ཅེས༌ སྤངས༌ཏེ༌ དཀོན༌མཆོག༌གི༌ ལམ༌མི༌ཀ༌ གྲུལ༌ཁན༌ནི༌ བྲས༌བུ༌ སྨིན༌ཅུག༌། ");
INSERT INTO lbj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ཡང༌ ཁྱོ༌ཞའེ༌ མ༌སམ༌ཤིག༌ ‘ང༌ཞའ༌ ཨབ༌ར༌ཧམ༌མི༌ པུར༌གྱུད༌ ཨིན༌ པ༌སང༌ ཐར༌ཨིན༌།’ ངའེ༌ ཁྱོ༌ཞ༌གུན༌ལ༌ ཟེར༌རད༌, དཀོན༌མཆོག༌གི༌ འི༌ རྡོའ༌གུན༌ནི༌ ནང༌ནེ༌ ཨབ༌ར༌ཧམ༌མི༌ ཕིའ༌ པུར༌གྱུད༌ ཛད༌ཉན༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ཤང༌ ཅོ༌ཤིག༌། སྟ༌རི༌ ནི༌ ལྕང༌མ༌གུན༌ནི༌ རྩའི༌ཀ༌ གྱབ༌ཆོག༌ཆོག༌ དུག༌, བྲས༌བུ༌ ཟང༌པོ༌ མ༌སྨིན༌ཁན༌ནི༌ ལྕང༌མ༌ ཚང༌མ༌ ཅད༌ཏེ༌ མེའེ༌ ནང༌ང༌ ཕང༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“ངའེ༌ ཁྱོ༌ཞའ༌ གྱོད༌པ༌ ཅོས༌ཏེ༌ དཀོན༌མཆོག༌གི༌ ཆོགས༌ལ༌ སེམས༌ གྱུར༌ཅེས༌ལ༌ ཆུའི༌ཁྲུས༌ ཏང༌ངད༌། ཨིན༌ནའང༌ ངའེ༌ སྟིང༌ནེ༌ སྐྱོད༌ཅེས༌ཅན༌, ཁོང༌ ངའེ༌ སང༌ མང༌ང༌ ཝང༌ཅན༌, ཡང༌ ང༌ ནི༌ ཞབ༌ཤི༌ ཙོགས༌ལ༌ ཁོང༌ངི༌ ཞབ༌པུལ༌ ཁུར༌ཅེས༌སི༌ འོས༌པ༌ མེད༌། ཁོང༌ངི༌ ཏམ༌པའེ༌ ཐུག༌ཉིད༌ དང༌ མེའེ༌ ཁྲུས༌སལ༌ཨིན༌། ");
INSERT INTO lbj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ཞིང༌བད༌པའེ༌ ཡུལ༌ཐག༌ག༌ ཟར༌ ཉམ༌པོ༌, ཀྲོ༌ དང༌ ཕུག༌མ༌ ཕེས༌ཏེ༌ ཀྲོ༌ ཁོ༌རང༌ངི༌ བང༌ངེ༌ ནང༌ང༌ ཡང༌ ཕུག༌མ༌ མེའེ༌ ནང༌ང༌ སྲག༌ག༌ ཙོགས༌ལ༌ ཁོང༌ངིའང༌ ཁོང༌རང༌ངི༌ མི༌གུན༌ དང༌ མི༌ ངན༌པ༌གུན༌ སོ༌སོའ༌ ཕེའ༌ ཛད༌ཨིན༌།” ");
INSERT INTO lbj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ཏེ༌ནེ༌ གཙོ༌བ