﻿USE sofia;
DROP TABLE IF EXISTS sofia.lbb_vpl;
CREATE TABLE lbb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lbb_vpl WRITE;
INSERT INTO lbb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ine a risan a mangis a tarai tagun nating ning e Iesu Karisito i hanot tagun la. E Iesu, a nat e Dewit, e Dewit a nat e Abaram. ");
INSERT INTO lbb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","E Abaram e tamana e Aisak, E Aisak e tamana e Jekop, pa e Jekop e tamana e Juda pa na tastasna. ");
INSERT INTO lbb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","E Juda i aitna e Peres dia ma e Serah, pa e Tamar e kabatnandiau. E Peres e tamana e Hesron, e Hesron e tamana e Ram, ");
INSERT INTO lbb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","pa e Ram e tamana e Aminadap, e Aminadap e tamana e Nason, pa e Nason e tamana e Salmon, ");
INSERT INTO lbb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","e Salmon e tamana e Boas, pa e tana a risana e Rehap. E Boas e tamana e Obet, pa e tana a risana e Rut. E Obet e tamana e Jesi, ");
INSERT INTO lbb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","pa e Jesi e tamana e Dewit, i ning a king. E Dewit e tamana e Solomon pa e tana a hane ning i taulai pas oe Uria. ");
INSERT INTO lbb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","E Solomon e tamana e Rehoboam e Rehoboam e tamana e Abia e Abia e tamana e Asa ");
INSERT INTO lbb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","e Asa e tamana e Jehosapat e Jehosapat e tamana e Jehoram pa e Jehoram e tamana e Usia ");
INSERT INTO lbb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","e Usia e tamana e Jotam e Jotam e tamana e Ahas pa e Ahas e tamana e Hesekia ");
INSERT INTO lbb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","e Hesekia e tamana e Manase e Manase e tamana e Amon pa e Amon e tamana e Josaia ");
INSERT INTO lbb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","e Josaia i aitna pas e Jekonia taum ana tastasnala. Lamur tana, a tarai Babilon la dat pas a tarai Israel utumo e Babilon sur lar kes na karabus. ");
INSERT INTO lbb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lamur tana tinan utumo e Babilon: E Jekonia i aitna e Salatiel, e Salatiel e tamana e Serubabel, ");
INSERT INTO lbb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","e Serubabel e tamana e Abiut, e Abiut e tamana e Eliakim, pa e Eliakim e tamana e Asor, ");
INSERT INTO lbb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","e Asor e tamana e Sadok, e Sadok e tamana e Akim, pa e Akim e tamana e Eliut, ");
INSERT INTO lbb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","e Eliut e tamana e Eliaser, e Eliaser e tamana e Matan, pa e Matan e tamana e Jekop, ");
INSERT INTO lbb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","e Jekop e tamana e Josep, i ning i taulai oe Maria. E Maria i agon e Iesu, ning di atongi a Karisito, i ning e God i sune seni. ");
INSERT INTO lbb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","I arlar ana ning a bonot pa pisir diat a tumtubunla turpasi oe Abaram tuk oe Dewit, pa turpasi oe Dewit tuk ana tinan na karabus tumo e Babilon ning a bonot pa pisir diat otleng la, pa turpasi ana tinan na karabus tumo e Babilon tuk ana Karisito ning a bonot pa pisir diat a tumtubunla otleng. ");
INSERT INTO lbb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Di agon pas e Iesu Karisito larne: E tana, e Maria, di ka aslang tari sur ir taulai e Josep, ika lanigo ana nundiau a tinaulai, e Maria ka tasmani mang i tianan tana Talngan Tabu. ");
INSERT INTO lbb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","E Josep ning di ka aslang tar e Maria suri, ai a tena tostos, pa bel i mang sur ir ame e Maria na matan a tarai. Pa i nuki mang ir kutus kumnan sen anundiau a lele sur a tinaulai. ");
INSERT INTO lbb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ning i nuknuk kol ot ana utna ne, a angelo ana Leklek i hanot teteki ana reresa pa i atongi mang, “Josep, a nat e Dewit, gong u urmatana nuknuk oe Maria, ur ben pasi ka sur anum a hane. Anasa a kaklik ning i tianan pasi, i hanot tagun a Talngan Tabu. ");
INSERT INTO lbb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ir agon pas a kaklik barsan pa ur pasar a risana e Iesu, anasa ir alaun pas anuna tarai kusun anunla na toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A ututnala rop ne i hanot sur dir tolsot pas a warwarala ana Leklek ning anuna propet ka apuasa tari mang, ");
INSERT INTO lbb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Oroi i, a basbas a hane ir tianan pa ir agon pas a kaklik barsan pa dir atongi e Emanuel,” a kamkamna mang, “E God i kes taum ondala.” ");
INSERT INTO lbb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ning e Josep i mata, i muri larotning a angelo ana Leklek i ka atai tari ono, pa i ben pas e Maria sur anuna hane. ");
INSERT INTO lbb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ika bel dia borbor taum pas tuk ning e Maria i agon pas a kaklik barsan. Pa e Josep i pasar a risana e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Di agon e Iesu tumo na hanua Betlihem ting na papar Judia, ana rau ning e Herot i king. Lamur dingla na tena tastasmaila tagun a nangnangla, la han miting na pukna ning a kamis i pusa ot ia, pa la hanot saot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pa la deke mang, “Kanaha a kaklik ning di agoni, sur ir king anuna tarai Juda? Anasa mila oroi anuna nangnang ting na pukna ning a kamis i pusa ot ia, pa ine mila han ute sur milar lotu teteki.” ");
INSERT INTO lbb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ning e king Herot i longori, a nuknukna i talar pa nuknuk a tarai Jerusalem rop otleng. ");
INSERT INTO lbb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Lamur i ben taum rop pas a leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai. Pa i deken la mang, “A Karisito ning e God ir sune i, dir agoni tahaia?” ");
INSERT INTO lbb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","La kelesi mang, “Tumo e Betlihem ana papar Judia, anasa a propet ka tumus tari mang, ");
INSERT INTO lbb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ika u, e Betlihem, ana piu anuna mangis a tarai Juda, Bel u natarna kol tana ningnigola anuna mangis a tarai Juda, Anasa a ningnigo ir hanot tagun u, ning ir nigon anuk a tarai Israel arlar ana tena tai alar anuna sipsipla.’” ");
INSERT INTO lbb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lamur e Herot i arsune kumnan pas a tena tastasmaila tagun a nangnangla sur ir talapor pas tanla mang, nangse momol ning a nangnang i hanot. ");
INSERT INTO lbb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I sune sen la utumo e Betlihem ana warwara larne, “Mulor han pa mulor tai wakak sur a kaklik. Pa ning mulo ka pastek pasi, mulor atai iau, sur iau maleng ar han pa ar lotu teteki.” ");
INSERT INTO lbb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ning la ka longor tar a king, la han. La oroi ulak pas a nangnang ning la ka oroi tari ting na pukna ning a kamis i pusa ot ia. I nigon amon la tuk ning i tur saot na pukna ning a kaklik kaning ia. ");
INSERT INTO lbb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ning la oroi a nangnang ning, la kilang a tnan gasgas. ");
INSERT INTO lbb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","La kas ting na rumai pa la oroi pas a kaklik, pa e tana e Maria. La kes ana bokona hanla pa la lotu tetek a kaklik. Lamur la sapang pas anunla na bek pa la tabari ana artabarla ne: a gol, pa paura di tuni pa sasawana i toboh wakak ning di atongi a insens, pa torok ning i toboh wakak otleng ning di atongi a mira. ");
INSERT INTO lbb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","E God ka atumarang tar la ana reresa, sur gong la ulak tar sur e Herot. Pa la ulak sur anunla a hanua ana maskana ngas kama. ");
INSERT INTO lbb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ning la ka han tar, a angelo ana Leklek i hanot tetek e Josep ana reresa pa i atongi mang, “Ur kamtur, ur ben pas ditana, pa mutol ar liu kumna utumo e Ijip. Pa mutol ar kes tumo ia, tuk ning ar atai ulak u, anasa e Herot ir tai sur a kaklik sur ir umkoli.” ");
INSERT INTO lbb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pa i kamtur, i ben pas ditana ana morom, pa ditol han utumo e Ijip. ");
INSERT INTO lbb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ditol kes tingia tuk ning e Herot i mat. Ana nunditol a keskes tingia, di tolsot pas a warwara anuna Leklek, ning a propet ka warwara nigo tar ono larne, “A kabah pas a natuklik mitumo e Ijip.” ");
INSERT INTO lbb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ning e Herot i oroi i mang a tena tastasmaila tagun a nangnangla la ka asongo tari, i balakut kol pa i arsune sur dir umkol arop sen a kakak barsanla tumo e Betlihem pa ting na hananuala otleng ning la kes milau. I saran a warkurai sur dir umkol la ning naur a rau anunla, pa la otleng ning belot naur a rau anunla, arlar ana warwara anuna tena tastasmaila ning la ka atai tari ana rau anuna kaklik. ");
INSERT INTO lbb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pa di ka tolsot pasi bot a warwara ning a propet Jeremaia i warwara nigo tar onoi mang, ");
INSERT INTO lbb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tumo e Rama di longor a elngen takai, a tintinangis pa agaia, E Rakel i domos na natnatnala, anasa la ka mat rop, pa bel di tolsot pasi sur dir amanahi.” ");
INSERT INTO lbb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","E Herot ka mat, pa angelo anuna Leklek i hanot tetek e Josep ana reresa tumo e Ijip. ");
INSERT INTO lbb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Pa i atongi tana mang, “Ur kamtur, ur ben pas ditana, pa mutol ar han utumo e Israel, anasa la ning la mang sur lar umkol a kaklik, la ka mat.” ");
INSERT INTO lbb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lamur i kamtur, i ben pas ditana, pa ditol han utumo e Israel. ");
INSERT INTO lbb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ika i longori mang, e Akelaus i keles tar e tamana e Herot, sur i maleng a king tumo na papar Judia, pa e Josep i matmataut sur ir han utumo e Judia. Pa e God i sairas tari ana reresa, sur gong ditol han utumo na papar Judia. Pa ditol han kama utumo na papar Galili. ");
INSERT INTO lbb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pa ditol han pa ditol kes ana hanua a risana e Nasaret. Ana anunditol a keskes tingia, di tolsot pas a warwara anuna propetla mang, “Dir atongi a te Nasaret.” ");
INSERT INTO lbb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dingla na rau lamur, e Jon a Tena Baptais i hanot, pa i warawai ting na hanua bel tumo na papar Judia, ");
INSERT INTO lbb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","pa i atongi mang, “Mulor lingir a nuknukimulo, anasa a matanitu misaot na langit ka milau.” ");
INSERT INTO lbb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","E Jon otne a propet Aisaia ka warwara nigo tar onoi mang, “A elngena mainla i arkabah ting na hanua bel mang, ‘Mulor sang a ngas anuna Leklek, mulor atostos anuna ngasla.’” ");
INSERT INTO lbb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","E Jon i mermer ana kaen di toli ana hih a kamel, pa i dot ahati ana let di toli ana palaona bulumakau. I sira ien a mumla pa polo na tatos. ");
INSERT INTO lbb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A tarai misaot e Jerusalem, pa miting na hananuala rop tumo na papar Judia, pa miting na hananuala ning la kes milau a malum Jodan, la han teteki. ");
INSERT INTO lbb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","La patuai talapor ana nunla na toltol laulaula, pa i baptais la ting na malum Jodan. ");
INSERT INTO lbb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","E Jon i oroi a galis a Parisaiola pa Sadusila la han sur ir baptais la, pa i atongi tanla mang, “Ai, mulo na natnat a soi! Bel mulor tolsot sur mulor liu kumna kusun a balakut ane God, ning ir hanot. ");
INSERT INTO lbb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ning mulo ka lingir momol a nuknukimulo, mulor tol a ututnala ning ir apuasa i mang mulo ka lingir a nuknukimulo. ");
INSERT INTO lbb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pa gong mulo nuki mang, e God bel ir warkurai mulo anasa mulo a mangis a tarai ane Abaram. A atai mulo mang, e God i tolsot sur ir tol otnan a mangis a tarai ane Abaram tagun a hatatla ne. ");
INSERT INTO lbb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Di ka suah tar a hek ting na kama rakaila, pa rakaila rop ning bel la suah al wakak a wanala, dir ting sen la, pa dir migen la uting na iah. ");
INSERT INTO lbb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","A baptais mulo ana malum sur ir apuasa i mang mulo ka lingir a nuknukimulo. Ika esaning ir mur tak, a rakrakaina i itna tana rakrakaik. Bel a tostos sur ar los anuna su. A natarna kol tana. I ir baptais mulo ana Talngan Tabu pa iah. ");
INSERT INTO lbb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I tong pas anuna saol ana naur a kuna sur ir migen a witla usaot sur a wuwu ir wus sen a palpalnala kusun a patnala. Ning ka tol rop tari, ir suah taum anuna wit ting na rumai a wit, pa ir tun sen a palpalnala ting na iah ning bel i sira mat.” ");
INSERT INTO lbb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","E Iesu i han mitisa na papar Galili uting na malum Jodan tetek e Jon sur ir baptaisi. ");
INSERT INTO lbb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","E Jon i mang sur ir sairasi, pa i atongi tana mang, “I mangasa ning u han tetek iau sur ar baptais u? Ir wakak ning u ur baptais iau.” ");
INSERT INTO lbb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pa e Iesu i kelesi mang, “Ur baptais iau ka. I wakak ning ur toli, sur dar tolsot pas asa rop ning i tostos na matana e God.” Pa e Jon i longor tana. ");
INSERT INTO lbb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ning ka baptais tari, ono otning e Iesu i saur miting la malum, pa langit i sapang, pa i oroi a Inguna e God i han purum arlar ana tabun pa i kes saot ono. ");
INSERT INTO lbb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lamur a elngena mainla misaot na langit i atongi mang, “Ine a natuklik, a katnani, a gas kol onoi.” ");
INSERT INTO lbb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lamur a Talngan Tabu i nigon e Iesu uting na hanua bel sur e Satan ir lari. ");
INSERT INTO lbb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ning ka tamai pas diat a bonot a pukakiar a morom pa diat a bonot a pukakiar a kabakiar, i murak. ");
INSERT INTO lbb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pa tena alam i hanot teteki, pa i atongi tana mang, “Ning u a Nat e God, ur atai a hatatla ne sur lar hanot a bret.” ");
INSERT INTO lbb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","E Iesu i kelesi mange, “Di ka tumus tari ting na Buk Tabu mang, ‘A tarai bel la sira laun ka ana utna na hangan, la laun ana warwarala rop ning i purum kusun a pahana e God.’” ");
INSERT INTO lbb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Lamur e Satan i ben pasi usaot e Jerusalem, a hanua ane God, pa i atur tari sot ot na pukul a rumai artabar. ");
INSERT INTO lbb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pa i atongi tana mang, “Ning u a Nat e God, ur sirok purum, anasa di ka tumus tari ting na Buk Tabu mang, ‘Ir sune anuna angelola sur lar tai alar u. Lar tong pas u ana kunla, sur gong u buh a ham ana ta hat.’” ");
INSERT INTO lbb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","E Iesu i kelesi mang, “Di ka tumus tari otleng ting na Buk Tabu mang, ‘Gong u lar a Leklek anum a God.’” ");
INSERT INTO lbb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","E Satan i ben ulak pasi usaot lamagit ana tnan mangir, pa i asangan tar a hananuala rop te na rakrakan hanua pa matatarinla rop otleng tana. ");
INSERT INTO lbb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Pa i atongi tana mang, “Ning ur kes ana bokona ham pa ur lotu tetek iau, a ututnala rop ne ar sarani tam.” ");
INSERT INTO lbb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","E Iesu i atongi tana mang, “Satan, ur han masik, anasa di ka tumus tari ting na Buk Tabu mange, ‘Ur lotu tetek a Leklek anum a God, pa ur longor ka tana.’” ");
INSERT INTO lbb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Lamur e Satan i han pas kusuni, pa angelola la han teteki, pa la nangani. ");
INSERT INTO lbb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","E Iesu i longori mang, di ka akas tar e Jon uting na karabus, pa i ulak utumo na papar Galili. ");
INSERT INTO lbb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pa i han mitumo e Nasaret, i kes tingia e Kapernaum, a hanua ning i kes ting na hang napir a puka tasi Galili, ana piu anuna mangis a tarai Sebulon pa mangis a tarai Naptali, ");
INSERT INTO lbb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","sur ir tolsot pas a warwara ane God ning a propet Aisaia ka warwara nigo tar onoi mang, ");
INSERT INTO lbb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A piu anuna mangis a tarai Sebulon pa piu anuna mangis a tarai Naptali, milau a ngas ning i han utumo latasi, ting na ris a malum Jodan utumo, dia kes ting na papar Galili, ning a tarai ning bel a tarai Juda la kes ia. ");
INSERT INTO lbb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A tarai ning la kes ana mormorom la ka oroi a tnan talapor, pa la ning a mormorom a minat i poroi alar la, a talapor ka hanot tetek la.” ");
INSERT INTO lbb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Turpasi ana rau ning, e Iesu i warawai mang, “Mulor lingir a nuknukimulo, anasa a matanitu misaot na langit ka milau.” ");
INSERT INTO lbb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ning a pukakiar e Iesu i asal tumokorot na hang a puka tasi Galili, pa i oroi tetek e Saimon, di atongi otleng oe Pita, pa e tasnalik e Endru. Dia migen a uben tisa latasi, anasa diau naur a tena migen uben. ");
INSERT INTO lbb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I atongi tandiau mang, “Mu lamut, mu mur iau, sur ar asaer mu sur mu naur a tena ben tarai.” ");
INSERT INTO lbb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ono otning, dia kamtur pas kusun a ubenla, pa dia muri. ");
INSERT INTO lbb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ning i han mitingia, i oroi pas maleng naur a tas, e Jems pa e Jon, naur a nat e Sebedi. La tamana kes tar ting na mon pa ditol suk anunditol na ubenla. Pa e Iesu i kabah diau. ");
INSERT INTO lbb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ono otning, dia kamtur pa dia han kusun a mon pa e tamandiau, pa dia mur e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","E Iesu i han taltal ting na papar Galili rop, pa i sira asaer a tarai ting na nunla na rumai lotula. I sira warawai ana Wakak a Warwara ana matanitu misaot na langit. Pa i alangolango pas a tarai kusun a urmatana ngas a tinsamanla rop. ");
INSERT INTO lbb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pa warwara oe Iesu i han sarara ting na papar Siria rop. Pa la ben rop pas a tarai ning a urmatana ngas a tinsaman i alaulau la, a tarai ning a rakrakai a kankan i alaulau la, pa la ning a motla kaning onla, la otleng ning la sira mat lalang pa la ning a palaonla i mat. Pa e Iesu i alangolango pas la rop. ");
INSERT INTO lbb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pa tnan kunum a tarai mitisa na papar Galili pa miting na papar Dekapolis, pa misaot e Jerusalem, pa misaot na papar Judia pa mitumo na ris a malum Jodan la mur e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","E Iesu i oroi pas a kunum a tarai, pa i han kas ting na mangir, pa i kes. Anun a tarai a asaer la han teteki. ");
INSERT INTO lbb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pa i asaer la mang, ");
INSERT INTO lbb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“La ning la tasmani mang la kapan ana ingunla, la angis, anasa a matanitu misaot na langit anunla. ");
INSERT INTO lbb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","La ning la domos, la angis, anasa e God ir amoro la. ");
INSERT INTO lbb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","La ning la anatarna pas la, la angis, anasa lar kibas pas a rakrakan hanua sur anunla. ");
INSERT INTO lbb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","La ning la murak pa la mos sur a tostos a toltol, la angis, anasa lamur lar masur. ");
INSERT INTO lbb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","La ning na tena marmaris, la angis, anasa e God ir maris la otleng. ");
INSERT INTO lbb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","La ning a nuknukinla i totoh, la angis, anasa lar oroi e God. ");
INSERT INTO lbb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","La ning la sira amolmol a tarai, la angis, anasa e God ir atong la na natnatna. ");
INSERT INTO lbb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","La ning di alaulau la anasa la mur a tostos a toltol, la angis, anasa anunla a matanitu misaot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mulo angis ning di atong laulau mulo, pa di alaulau mulo, pa di atong a asasongo na warwarala omulo mang mulo tol na toltol laulaula, anasa mulo anuki. ");
INSERT INTO lbb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mulor gas, anasa anumulo a arlou saot na langit i itna kol. Anasa mangotleng larning di ka alaulau nigon a propetla ning la laun nigo tamulo. ");
INSERT INTO lbb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mulo arlar ana sol sur a tarai te na rakrakan hanua. Ika, ning a makmakana ka rop, dir amakmakan ulak mangmangasa pasi? Bel ta utna ma i to pasi. Dir migen purum seni utumo lapiu, pa tarai lar papas kama saot ono. ");
INSERT INTO lbb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mulo arlar ana talapor te na rakrakan hanua. Ta hanua ning i kes saot na mangir, bel ir parau sot pas. ");
INSERT INTO lbb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bel tik ir asot tar ta lam pa ir aroh alari ana paket. Dir suahi ot saot na turtur ngasna sur ir talapor tetek la rop ning la kes ting na rumai. ");
INSERT INTO lbb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Larotleng ning, anumulo a talapor ir sasai na matan a tarai, sur lar oroi anumulo a wakak a titolla, pa lar atong aitna pas e Tamamulo ning i kes saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gong mulo nuki mang a hanot sur ar kibas sen a warkuraila ane Moses pa asaerla anuna propetla. Bel a hanot sur ar kibas sen la, a hanot sur ar tolsot pas la. ");
INSERT INTO lbb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A atong momoli tamulo, bel ta natar a tumtumus lik o ta akinalang lik tagun a warkuraila ne ir rarop, tuk ning a bakut pa rakrakan hanua diar rarop. A warkuraila lar kes ot, tuk ning dir tolsot pasi. ");
INSERT INTO lbb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Esining ir lakai ta natar a warkurai mite na warkuraila ne, pa ir asaer rongon a tarai sur la otleng lar lakai i, dir atongi mang, i natarna kol ana matanitu saot na langit. Ika esining ir mur a warkuraila ne, pa ir asaer a tarai ono, dir atongi mang, i itna ana matanitu saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Larne, a atongi tamulo, ning anumulo a tostos a toltol bel ir itna bolos a tostos a toltol ana tena asaerla tagun a warkurai pa Parisaiola, bel mulor tolsot pasi sur mulor kas ting na matanitu saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mulo ka longor tari ning lanigo di ka atong tari tana tarai mang, ‘Gong u umkol tik. Esining ir umkol tik dir warkurai i.’ ");
INSERT INTO lbb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ika iau, a atongi tamulo mang, esining ir balakut tetek ta tasnalik, dir warkurai i, pa esining ir atongi tetek ta tasnalik mang, ‘Bel ta pukulum,’ dir warkurai i na matan a tarai a kiwung. Pa esining ir atongi mang, ‘A longlong u,’ ngandek a warkurai ono, dir migeni ting na tnan iah. ");
INSERT INTO lbb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ning ur han sur ur saran anum a artabar ting na logo na tun artabar, pa ur nuk pas ta utna ning e tasimlik i tiu u ono, ");
INSERT INTO lbb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ur suah tar anum a artabar ting napir a logo na tun artabar. Ur han kaba, pa mur armoro nigo pas oe tasimlik. Lamur ur ulak, pa ur sarani bot anum a artabar. ");
INSERT INTO lbb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ning tik ir suah tar u ana warkurai, mur armoro nigo ning mu kaning ot mu han amon ting na numu a tinan, sakana ir saran tar u tetek a tena warkurai. Pa tena warkurai ir saran tar u tetek a tena tai alar pa ir akas tar u ting na karabus. ");
INSERT INTO lbb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A atong momoli tam, bel ur purum tuk ot ning ur saran a ararop a toia ana num a arlou. ");
INSERT INTO lbb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mulo ka longor tari ning di ka atong tari mang, ‘Gong u tol a toltol laulau ana ta hane anuna tik o ta barsan anuna tik.’ ");
INSERT INTO lbb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ika iau, a atongi tamulo mang, ning ta barsan ir oroi tar ta hane pa nuknukna i laulau teteki, ting na nuknukna ka tol tar a toltol laulau ana hane ning. ");
INSERT INTO lbb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ning a sot a matam ir ben rongon u, ur liok seni, pa ur migen masik seni. Ir wakak ning takai a puka palaom ka dir migen seni, sakana dir migen a palaom rop uting na tnan iah. ");
INSERT INTO lbb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ning a sot a kum ir ben rongon u, ur kutus seni, pa ur migen masik seni. Ir wakak ning takai a puka palaom ka dir migen seni, sakana dir migen a palaom rop uting na tnan iah. ");
INSERT INTO lbb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Di ka atong tari otleng mang, ‘Esining i kepsen anuna hane, ir saran tar a paka buk na kutus tinaulai tana.’ ");
INSERT INTO lbb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ika iau, a atongi tamulo mang, ning tik ir kepsen anuna hane ning bel i tol ta toltol laulau taum ana ta barsan masik, pa hane i taulai ulak, i tol a toltol laulau. Ika anuna barsan, i kamkamna ana laulau ning. Ning ta barsan ir taulai ta hane ning anuna barsan i kepseni, i otleng ka tol a toltol laulau, anasa a hane ning, i taulai ot. ");
INSERT INTO lbb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mulo ka longor tari otleng ning lanigo di ka atong tari tana tarai mang, ‘Gong u lele asasongo. A utna ning u ka lele tar ono tetek a Leklek, ur tolsoti ot.’ ");
INSERT INTO lbb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ika iau, a atongi tamulo mang, gong mulo arakrakai a lele ana ta ngas a warwara otleng. Gong mulo lele ana langit, anasa a langit a keskes a king ane God. ");
INSERT INTO lbb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Gong mulo lele ana rakrakan hanua, anasa a rakrakan hanua a pukna ning i suah naur a hana ono. Gong mulo lele oe Jerusalem, anasa e Jerusalem a hanua ana tnan King. ");
INSERT INTO lbb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gong u lele ana pukulum, anasa bel ur lingir sot pas ta hih a pukulum sur ir kokok, o ir mutmut. ");
INSERT INTO lbb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mulor atongi ka mang ‘ma’ o ‘bel’. Anasa, ning mulor atong ta ngas a warwara otleng, i ning i hanot kama tana Tena Laulau. ");
INSERT INTO lbb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mulo ka longor tari mang di ka atong tari mang, ‘Ning tik ir liok sen ta matan tik, dir kelesi otleng teteki, dir liok seni otleng ta matana. Pa ning tik ir tubul kuben sen ta ngesen tik, dir kelesi otleng teteki, dir tubul kuben sen otleng ta ngesena.’ ");
INSERT INTO lbb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ika iau, a atongi tamulo mang, gong mulo keles a laulau anuna tik ning i toli tetek mulo. Ning tik ir pasar a ris a sot a paham, ur saran otleng ning a ris tana. ");
INSERT INTO lbb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ning tik i mang sur ir dat tar u ana warkurai pa dir saran a warkurai tam sur ur saran anum a siot tana, ur noren tar otleng anum a saket. ");
INSERT INTO lbb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ning tik ir angongos u sur mur han taum uting na ta hanua ning i milau ka, ur han taum ono uting na hanua ning i bakbak siklik. ");
INSERT INTO lbb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ur tabar tik ning i nunung u. Pa ning tik ir nunung u sur ir los pasi kaba ta utna kusun u, ur sarani kaba tana. ");
INSERT INTO lbb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mulo ka longor tari ning di ka atong tari mang, ‘Ur mang sur a halim, pa ur nget anum a hirua.’ ");
INSERT INTO lbb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ika iau, a atongi tamulo mang, mulor mang sur anumulo na hirua, pa mulor araring sur la ning la alaulau mulo. ");
INSERT INTO lbb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ning mulor toli larning, ir asangani mang mulo na natnat e Tamamulo, ning i kes saot na langit. Anasa i saran tar a kamis sur ir talapor ana laulau a tarai pa wakak a taraila otleng, pa i saran tar a kiar tetek na tena tostos pa tetek la otleng ning bel la tostos. ");
INSERT INTO lbb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ning mulor mang sur la ka ning la mang sur mulo, asa ma anumulo a arlou? Na tena los totokom, ning bel la lasan ana marmaris la toli otleng larne, gepi? ");
INSERT INTO lbb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ning mulor gas pas ka sur na halalimulo, mulor wakak mangmangasa tana tarai masikla? A tarai otleng ning bel la tortorot la gasgas pas ka sur na halalinla, gepi? ");
INSERT INTO lbb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mulor tostos momol, larning e Tamamulo ning i kes saot na langit, i tostos momol. ");
INSERT INTO lbb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mulor tumarang sur gong mulo tol anumulo na wakak a titol na matan a tarai ka, sur lar oroi i pa lar atong aitna pas mulo. Ning mulo toli larne, bel ta arlou anumulo tana Tamamulo ning i kes saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ning ur tabar a kapan a taraila, gong u warwara nigo sur a tarai lar oroi u. A tarai ning bel la artabar ana momol a balanla, la sira warwara nigo ana anunla na artabar ting na rumai lotula pa ting na ngasla otleng, sur a tarai lar atong aitna pas la ono. Gong mulo toli arlar onla. A atong momoli tamulo, ning a tarai la aitna pas la, i ot ning anunla a kidol a arlou. ");
INSERT INTO lbb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ning ur tabar a kapan a taraila, gong a kair a kum i tasman asaning a sot a kum i toli, ");
INSERT INTO lbb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","sur ur artabar kumna ka. Pa e Tamam ning i oroi asaning u tol kumnani, ir saran a arlou tam. ");
INSERT INTO lbb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ning mulor araring, gong mulo arlar ana tena asasongola. La mang kol sur lar tur pa lar araring ting na rumai lotu, pa ting na pukpuknala ning a tarai la hanan taum tingia, sur a tarai lar oroi la pa lar atong aitna pas la. A atong momoli tamulo, ning a tarai la aitna pas la, i ot ning anunla a kidol a arlou. ");
INSERT INTO lbb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ika u, ning ur araring, ur kas ting na num a rumai pa ur tagar alar pas u, pa ur araring tetek e Tamam ning bel tik i oroi i. Pa e Tamam ning i oroi asaning u tol kumnani, ir saran anum a arlou. ");
INSERT INTO lbb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ning mulor araring, gong mulo abereng wara oros ka, arlar ana niaring ana taraila ning bel la tasman e God. La nuki mang dir longor la anasa la atong a galis a warwara. ");
INSERT INTO lbb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gong mulo arlar onla, anasa a Tamamulo ka tasman tar asa rop ning mulo kapan suri, ning belot mulo araring. ");
INSERT INTO lbb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Mulor araring larne, ‘Tamamila saot na langit, i wakak ning dir hanrawai a risam. ");
INSERT INTO lbb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","I wakak ning anum a matanitu ir hanot. I wakak ning dir mur a nuknukim te na rakrakan hanua, larot ning di sira muri saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","A pukakiar ne ur tabar mila ana utna na hangan amilai. ");
INSERT INTO lbb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ur kepsen anumila na toltol laulaula, larning mila otleng mila ka nuk duman sen anunla na toltol laulaula tetek mila. ");
INSERT INTO lbb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gong u ben mila uting na arlam. Ur alaun mila kusun a Tena Laulau.’ ");
INSERT INTO lbb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ning mulor nuk duman sen na toltol laulaula ning a tarai la toli tetek mulo, e Tamamulo, ning i kes saot na langit, ir kepsen anumulo na toltol laulaula otleng. ");
INSERT INTO lbb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ika, ning bel mulo nuk duman sen na toltol laulaula, ning a tarai la tol tari tetek mulo, e Tamamulo otleng bel ir kepsen anumulo na toltol laulaula. ");
INSERT INTO lbb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ning mulor tamai sur mulor araring, gong mulo tatatai arlar ana tena asasongola, anasa la tai na balmaris sur a tarai lar oroi i mang la tamai. A atong momoli tamulo, ning a tarai la aitna pas la, i ot ning anunla a kidol a arlou. ");
INSERT INTO lbb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ning ur tamai, ur kom a hihim, pa ur damus a patarim, ");
INSERT INTO lbb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sur gong a tarai la tasmani mang u tamai. E Tamam ka, ning bel tik i oroi i, ir tasmani. Pa e Tamam ning i oroi asaning u tol kumnani, ir saran anum a arlou. ");
INSERT INTO lbb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Gong mulo suah taum a gongonla te lapiu, ning a koropos pa ros diar alaulau sen la ka, pa na tena kinkinaula lar kas pa lar kinau i. ");
INSERT INTO lbb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mulor suah taum a gongonla saot na langit, ning a koropos pa ros bel diar alaulau i, pa na tena kinkinau otleng bel lar kinau lar pasi. ");
INSERT INTO lbb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Anasa ting na hanua ning anum a gongonla kaning ia, anum a lalaun otleng kaning ia. ");
INSERT INTO lbb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Naur a matandala dia arlar ana lam ana palaondala. Ning naur a matam dia wakak, a palaom rop ir bukus ana talapor. ");
INSERT INTO lbb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ika, ning naur a matam dia laulau, a palaom rop ir bukus ana mormorom. Ning anum a talapor i mormorom ka, a mormorom ning ir itna kol! ");
INSERT INTO lbb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Bel tik ir titol sot pas tetek ir naur a ningnigo. Ir nget ning a halindiau, pa ir mang sur ning a halindiau, ir katnan ning, pa takai ir saran a kaba hina kusuni. Bel mulor titol sot pas tetek e God pa tetek a mani otleng. ");
INSERT INTO lbb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“I maining, a atongi tamulo mang, gong mulo nuknuk kol ana numulo a lalaun mang asaning mulor ieni, pa sa mulor gangi. Pa gong mulo nuknuk kol ana palaomulo otleng mang asa mulor mermer ono. A lalaun i itna tana utna na hangan, gepi? Pa palaondi otleng i itna tana kaenla, gepi? ");
INSERT INTO lbb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mulor oroi a manila. Bel la oman tar ta utna, pa bel la sol tar al utna, pa bel la susuah taum ana ta rumai, ika e Tamamulo ning i kes saot na langit, i sira tabar la. Pa mulo, mulo itna kol tanla. ");
INSERT INTO lbb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Esi tamulo ning i nuknuk kol ana nuna lalaun, ir tolsot sur ir tugus barah siklik anuna lalaun? Bel tik. ");
INSERT INTO lbb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Sur asaning mulo nuknuk kol sur a kaenla? Mulor oroi a wakak a purpurla misa na bual, mang la gomo mangmangasa. Bel la sira titol pa bel la sira tol kaen. ");
INSERT INTO lbb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ika a atongi tamulo, e King Solomon ot ning anuna mermer rop i tai wakak, ika bel i tai wakak arlar ana purpurla ning. ");
INSERT INTO lbb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E God i amermer a ulai sakas na bual ana wakak a purpurinla, ning anone i tapalas, pa latu dir tun seni ting na iah. Ning i toli larning ana ulai, i momol kol mang ir amermer mulo otleng. Anumulo a tortorot i natarna kol. ");
INSERT INTO lbb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Gong mulo nuknuk kol pa mulo atongi mang, ‘Asa dalar ieni?’, o ‘Asa dalar gangi?’, o ‘Asa dalar mermer ono?’ ");
INSERT INTO lbb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Anasa a taraila ning bel la tasman e God la rakrakai sur a ututnala rop ning, ika e Tamamulo ning i kes saot na langit i tasmani mang mulo kapan sur a ututnala rop ning. ");
INSERT INTO lbb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mulor rakrakai nigo sur anuna matanitu pa anuna tostos a toltol, pa ir tabar mulo otleng ana ututnala rop ne. ");
INSERT INTO lbb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pa gong mulo nuknuk kol sur a pukakiar latu, anasa latu ir nuknuk ot suri. A mamahatla ona taktakai a pukakiar i to pasi ot a pukakiar ning.” ");
INSERT INTO lbb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Gong mulo warkurai a toltol ana tik, sakana e God otleng ir warkurai a toltol anumulo. ");
INSERT INTO lbb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anasa e God ir warkurai mulo arlar larning mulo warkurai tik. Pa ngas a warkurai ning mulo warkurai tik ono, i ot ning e God ir warkurai ulak mulo ono. ");
INSERT INTO lbb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sur asaning u oroi pas ka a beren kaning na matana e tasimlik, pa bel u nuk pas a puka rakai kaning na matam? ");
INSERT INTO lbb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ning a puka rakai kaning na matam, ur atong mangmangasa i tetek e tasimlik mang, ‘Ar kepsen a beren kusun a matam’? ");
INSERT INTO lbb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","U a tena asasongo, ur kepsen nigon a puka rakai kusun a matam, pa ur tai wakak, sur ur kepsen a beren kusun a matana e tasimlik. ");
INSERT INTO lbb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gong mulo tabar a papla ana utna ane God, sakana lar talingir, pa lar harat gingini mulo. Pa gong mulo migen anumulo a sar tetek a boroila, sakana lar pas gingini i ka ana hanla. ");
INSERT INTO lbb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mulor nunung, pa dir tabar mulo, mulor sereni, pa mulor pasteteki, mulor pinpidir, pa dir sapang pas mulo. ");
INSERT INTO lbb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Anasa la rop ning la nunung lar kibasi, pa esining i sereni ir pasteteki, pa esining i pinpidir, dir sapang pasi. ");
INSERT INTO lbb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Esi na halimulo, ning e natnalik ir nunungi sur ta bret, ir tabari ka ana ta hat? ");
INSERT INTO lbb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pa ning ir nunungi otleng sur ta sis, ir tabari ka ana ta soi? ");
INSERT INTO lbb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mulo na laulau a tarai, ika mulo tasman ot a wakak a artabarla sur mulor tabar na natnatumulola ono. Ning mulo sira toli larne, i momol kol mang, e Tamamulo ning i kes saot na langit ir saran a wakak a ututnala tetek esining ir nunungi. ");
INSERT INTO lbb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","A ututnala rop ning mulo mang sur a tarai lar toli tetek mulo, mulo otleng, mulor sira toli tetek la. Ine a kamkama warkurai ane Moses, pa asaerla ana propetla. ");
INSERT INTO lbb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mulor kas ana natar a taman lik. Anasa a taman pa ngas ning i han sur a hinirua tikin, i palar pa i langolango, pa galis a tarai kol la sira kas ono. ");
INSERT INTO lbb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ika a taman pa ngas ning i han sur a lalaun, i natarna, pa siklik tarai ka la sira pastek pasi. ");
INSERT INTO lbb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mulor tumarang ana asasongo na propetla. La sira han tetek mulo ana wakak a gininla arlar ana sipsipla, ika tingui na balanla, la mang sur lar alaulau mulo arlar ana ngalngaliah na papla. ");
INSERT INTO lbb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mulor oroi lalan a asasongo na propetla ana gininla. I mangasa, dir git pas ta wana wain miting na kadas, pa ta wana fig miting na rosros? Bel! ");
INSERT INTO lbb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Larka otleng ning a wakak a rakaila rop la sira suah a wakak a wanala, ika a laulau a rakaila rop la sira suah a laulau a wanala. ");
INSERT INTO lbb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A wakak a rakai bel ir suah ta laulau a wana, pa laulau a rakai otleng bel ir suah ta wakak a wana. ");
INSERT INTO lbb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","A rakaila rop ning bel la suah a wakak a wanala, dir ting sen la, pa dir migen la ting na iah. ");
INSERT INTO lbb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Manglarning, mulor oroi lalan a asasongo na propetla ana gininla. ");
INSERT INTO lbb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Bel la rop ning la atong iau mang, ‘Leklek, Leklek,’ lar kas uting na matanitu saot na langit. La ka, ning la sira mur a nuknuk e Tata, ning i kes saot na langit, lar kas uting na nuna matanitu. ");
INSERT INTO lbb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ana pukakiar a warkurai a galis lar atongi tak mang, ‘Leklek, Leklek, mila warwara na propet ana risam, pa mila kepsen a motla otleng ana risam, pa mila tol a galis a ututnala na kulkulan ana risam.’ ");
INSERT INTO lbb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ar keles la mang, ‘Bel a tasman mulo. Mulo na tena laulau, mulor han masik kusun iau.’ ");
INSERT INTO lbb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“La rop ning la longor anuk a warwarala ne, pa la muri, la arlar ana tena tastasmai, ning i tol tar anuna rumai saot na hat. ");
INSERT INTO lbb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A kiar i punga, pa lomom i hanot, pa wuwu i ragati pa i um a rumai ning, ika bel i taroh, anasa di atur tari saot na hat. ");
INSERT INTO lbb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","La rop ning la longor anuk a warwarala ne, ika bel la muri, la arlar ana longlong, ning i tol tar anuna rumai saot na woio, pa bel i por rakrakai a posla. ");
INSERT INTO lbb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A kiar i punga, pa lomom i hanot, pa wuwu i ragati pa i um a rumai ning, pa i taroh, pa i tarege kakat.” ");
INSERT INTO lbb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ning e Iesu ka atong rop tar a warwarala ne, a kunum a tarai la kulkulan ana nuna asaer, ");
INSERT INTO lbb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","anasa i asaer la arlar o esaning a warkurai kaning tana. Bel i asaer la arlar ana anunla na tena asaer tagun a warkurai la sira toli. ");
INSERT INTO lbb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ning e Iesu i han purum misaot na mangir, a galis a kunum a tarai la muri. ");
INSERT INTO lbb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ning a barsan, a lepra, i han teteki, i kes ana bokona hana ting napirna, pa i atongi mang, “Leklek, ning u mang, ur tolsot sur ur alangolango pas iau.” ");
INSERT INTO lbb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","E Iesu i tuslan a kuna, pa i tong a palaona, pa i atongi tana mang, “A mang ot, ur langolango.” Ono otning a lepra i rop kusuni. ");
INSERT INTO lbb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lamur e Iesu i atongi tana mang, “Gong u atai tar tik ono. Ur han pa ur asangan u tetek a tena artabar tetek e God, pa ur saran a artabar tetek e God larning e Moses ka atong tari. Ning ur toli larne, ir talapor tetek a taraila mang a palaom ka wakak ulak.” ");
INSERT INTO lbb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ning e Iesu ka hanot tumo e Kapernaum, ning a ningnigo anuna tena harumla mitumo e Rom i han teteki, pa i atai i sur ir nangani. ");
INSERT INTO lbb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","I atongi mang, “Leklek, ning a tena titol anuki kanumo na rumai i borbor, a palaona rop i mat, pa i kilang a tnan kankan kol.” ");
INSERT INTO lbb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","E Iesu i atongi tana mang, “Ar han par alangolango pasi.” ");
INSERT INTO lbb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A ningnigo ning i kelesi mang, “Leklek, bel a tostos sur ur kas ting na rumai ngasik. Ur atong ta warwara ka, pa anuk a tena titol ir langolango. ");
INSERT INTO lbb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Anasa iau a barsan ning a sira longor ana warkurai anunla ning la leklek tak, pa di saran tar a warkurai otleng tak sur ar nigon a tarai a harum. Ning ar atongi tana tik mang, ‘Ur han,’ ir han ka. Pa tetek tik otleng larne, ‘Ur han ute,’ ir han ka ute. Pa tetek anuk a tena titol oros mang, ‘Ur tol a utna ne,’ ir toli ka.” ");
INSERT INTO lbb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ning e Iesu i longor anuna warwara, i kulkulan kol onoi, pa i atongi tetek a tarai ning la muri mang, “A atong momoli tamulo, bel a oroi ta te Israel ning anuna tortorot i itna arlar ana barsan ne. ");
INSERT INTO lbb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A atai mulo mang kaning lamur a galis a tarai lar han miting na matana tobar pa matana labur, pa lar kes taum oe Abaram, e Aisak pa e Jekop ana ngasa ting na matanitu saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ika, a tarai Israel ning lanigo e God i aslang pas la sur lar kes ana nuna matanitu, ir lu purum sen a galis kusun la uting na mormorom. Pa lar tangtangis pa lar arngingit ngesenla tingia.” ");
INSERT INTO lbb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pa e Iesu i atongi tana ningnigo anuna tena harumla mang, “Ur han ka. Dir tol a utna ot ning u tortorot suri.” Ana taim ot ning anuna tena titol i langolango kakat. ");
INSERT INTO lbb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","E Iesu i kas uting na rumai ane Pita, pa i oroi a hane, a anmuna e Pita, i sasam, a palaona i laplapang, kaning i borbor ting na logo. ");
INSERT INTO lbb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","E Iesu i tong a kuna, pa laplapang i rop kakat kusuni. I kamtur, pa i tabar e Iesu ana utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ning a kamis ka sup tar, di ben otnan a galis a tarai, ning a motla kaning onla, tetek e Iesu. I kepsen a motla ana warwara ka, pa i alangolango pas la rop, ning la sasam. ");
INSERT INTO lbb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A utna ne i hanot sur dir tolsot pas a warwarala, ning a propet Aisaia ka warwara tar ono mang, “I ot i los pas anundala na kankan, pa i kibas sen anundala na tinsamanla.” ");
INSERT INTO lbb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ning e Iesu i oroi a kunum a tarai ning la tur talilis pasi, i atongi tana anuna kakak a asaerla mang, “Dalar han utumo na ris a puka tasi.” ");
INSERT INTO lbb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pa ning a tena asaer tagun a warkurai i han teteki, pa i atongi tana mang, “Tena Asaer, ar mur u uting na hananuala rop ning ur han ia.” ");
INSERT INTO lbb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Pa e Iesu i atongi tana mang, “Na rokoio na pap anunla na tung ot, pa manila otleng anunla na pios ot, ika a Nat a Barsan bel ta pukna sur ir borbor onoi.” ");
INSERT INTO lbb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pa ning a barsan otleng, tagun anuna tarai a asaer i atongi tana mang, “Leklek, ur noren sen iau kaba sur ar han, sur ar por sen tar e tata.” ");
INSERT INTO lbb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ika e Iesu i atongi tana, “Ur mur iau, pa ur noren sen a minatla lar por anunla na minatla.” ");
INSERT INTO lbb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","E Iesu i kas ana mon, pa anuna kakak a asaerla la kas namurna. ");
INSERT INTO lbb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lamur a rakrakai a wuwu i hanot kulkulan pa i ragati tetek la ting na puka tasi. A top i takube saot na mon. Ika e Iesu i borbor duman, ");
INSERT INTO lbb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","pa la han teteki, la amata pasi, pa la atai i mang, “Leklek, ur alaun dala. Dala kar hirua.” ");
INSERT INTO lbb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pa i atongi tanla mang, “Anumulo a tortorot i natarna kol. Sur asaning mulo matmataut?” I kamtur pa i sairas a wuwu pa top, pa i mililo rop. ");
INSERT INTO lbb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pa kakak a asaerla la kulkulan ono, pa la atongi mang, “Esi na ngas a barsan momol ne? A wuwu pa top dia longor tana!” ");
INSERT INTO lbb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ning e Iesu i sot tumo na ning a ris a tasi, ting na papar anuna tarai Gadara, naur a barsan ning a motla la solong diau, dia han miting na kulam ngas a minatla, pa dia han barati. Dia ngalngaliah kol, pa bel tik i sira han bolos tingia na ngas ning. ");
INSERT INTO lbb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Dia woiwoi mang, “Nat e God, asa u mang ur toli omiau? I mangasa, u han ute sur ur akadik mila ning belot a pukakiar a warkurai i sot?” ");
INSERT INTO lbb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A kaba liur a boroi la hangan milau ka tingia. ");
INSERT INTO lbb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pa motla la nunung rakrakai e Iesu mang, “Ning ur kepsen mila, ur sune kas tar mila uting na liur a boroi.” ");
INSERT INTO lbb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","E Iesu i atongi tanla mang, “Mulor han!” Pa motla la purum kusun naur a barsan ning, pa la kas tar ana boroila. A boroila la liu purum uting na palis sur utumo na puka tasi, pa la dom rop. ");
INSERT INTO lbb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A tarai ning la tai alar a boroila ning, la dun ulak sur a hanua ngasinla. Ning la hanot, la atatai ana ututnala rop ning i hanot, pa ondiau otleng, ning a motla la solong diau. ");
INSERT INTO lbb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A tarai rop miting na hanua ning, la han sur lar oroi e Iesu. Ning la ka oroi tari, la nunungi sur ir han miting na nunla papar. ");
INSERT INTO lbb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","E Iesu i kas ana mon, pa i han lakai utumo na ning a ris a puka tasi pa i hanot ting na anuna hanua. ");
INSERT INTO lbb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pa dingla na tarai la los otnan ning a barsan teteki, a palaona i mat pa i borbor tar ka ting na logo ngasna. Ning e Iesu i oroi anunla tortorot, i atai a barsan ning mang, “Natuklik, gong u matmataut, di ka kepsen tar anum na toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dingla na tena asaer tagun a warkurai la warwara artalai tetek la ot mang, “A barsan ne i atong saksakan e God anasa i warwara larning i e God.” ");
INSERT INTO lbb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","E Iesu ka tasman tar a nuknukinla, pa i deken la mang, “Sur asa mulo nuknuk laulau? ");
INSERT INTO lbb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Esi na ngas a warwara ning bel i ngangaten sur ar atongi? Ar atongi mang, ‘Di ka kepsen anum na toltol laulaula,’ o, ar atongi mang, ‘Ur kamtur, pa ur han’? ");
INSERT INTO lbb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ar atongi larne, sur mulor tasmani mang, e God ka saran tar a warkurai tetek a Nat a Barsan, sur ir kepsen a toltol laulaula te lapiu.” Pa i atongi tetek a barsan ning a palaona i mat mange, “Ur kamtur, ur kibas a logo ngasim, pa ur han uting na rumai ngasim.” ");
INSERT INTO lbb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","I kamtur, pa i han uting na rumai ngasna. ");
INSERT INTO lbb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ning a kunum a tarai la oroi a utna ne, la kulkulan kol ono, pa la rakan aleklek pas e God, anasa i saran a rakrakai larne tetek a tarai. ");
INSERT INTO lbb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ning e Iesu i han miting ia, i oroi pas ning a barsan, a risana e Matiu, i kes ting na rumai a los totokom. E Iesu i atai i mang, “Ur mur iau.” Pa e Matiu i kamtur pa i muri. ");
INSERT INTO lbb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lamur ning e Iesu taum ana anuna kakak a asaerla, la hangan ting na rumai ngas e Matiu, a galis a tena los totokom pa tena laulaula la han tetek e Iesu, pa la hangan taum onla. ");
INSERT INTO lbb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ning a Parisaiola la oroi i, la deken anuna kakak a asaerla mang, “Sur asa anumulo a tena asaer i hangan taum ana tena los totokomla pa tena laulaula?” ");
INSERT INTO lbb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","E Iesu i longori pa i atongi mang, “A dokta bel i hanot sur la ning la langolango. I hanot sur la ka ning la sasam. ");
INSERT INTO lbb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mulor han, pa mulor asaer sur mulor tastasim ana kamkama warwara ne miting na Buk Tabu, ‘A mang sur a marmaris, pa bel a mang sur a artabar ning di sira tuni.’ Anasa bel a hanot sur ar kabah pas a tena tostosla. A hanot sur ar kabah pas a tena laulaula.” ");
INSERT INTO lbb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A kakak a asaerla ane Jon la han tetek e Iesu, pa la dekeni mang, “Sur asaning mila ma na Parisaiola mila sira tamai, ika anum a kakak a asaerla bel?” ");
INSERT INTO lbb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","E Iesu i keles la mang, “Ning ta barsan ir taulai totoh, na halalna lar domos mangmangasa ning a barsan ning kaning ot i kes taum onla? Ika ta pukakiar ir hanot, ning dir ben maskan pas a barsan ning kusun la, pa lar bot tamai. ");
INSERT INTO lbb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Bel tik ir suk ahat ta tona diah kaen ana turai a kaen ning i taksilir, sakana a tona diah kaen ir taksilir se kusun a turai a kaen, pa kaen ning ir taksilir kol. ");
INSERT INTO lbb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bel tik ir tere a tona wain uting na turai a koto na wainla ning di toli ana palaona inagoi, sakana a kotola lar tapuros pa lar laulau, pa wain ir tapek. Dir tere ot a tona wain uting na tona koto na wain, sur dia rop diar kes wakak.” ");
INSERT INTO lbb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ning e Iesu kaning ot i warwara tetek la, ning a ningnigo i han teteki, pa i kes ana bokona hana salanigo tana, pa i atongi mang, “A natuk hane, ono kane i mat. Lamut, dar han pa ur suah a kum saot ono, pa ir laun.” ");
INSERT INTO lbb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pa e Iesu i kamtur pa dia han taum ana nuna kakak a asaerla. ");
INSERT INTO lbb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ning a hane i sasam ana tinsaman a suluk arlar ana ning a bonot pa pisir naur a rau. I nuki mang, ning ir tuk ka a saket ane Iesu, ir langolango. Pa i han tumo lamur ta e Iesu, pa i tuk a ris a tuka saket anunai. ");
INSERT INTO lbb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","E Iesu i talingir pa i oroi a hane ning, pa i atai mang, “Natuklik, gong u matmataut, anum a tortorot ka alangolango pas u.” Pa ono otning a hane ning i langolango. ");
INSERT INTO lbb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ning e Iesu i kas ting na rumai ana ningnigo, i oroi a tarai ning la asangan anunla a balmaris ana minat. La wus a tulalla, pa kunum a tarai otleng la domos. ");
INSERT INTO lbb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I atongi mang, “Mulor purum kusuni. A hane lik ne bel i mat, kaning ka i borbor duman.” Pa la malani ka. ");
INSERT INTO lbb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ning e Iesu ka sune purum sen a taraila, i kas pa i tong a kuna kaklik hane ning, pa i kamtur kakat. ");
INSERT INTO lbb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A warwara ana utna ne i han sarara ting na papar rop ning. ");
INSERT INTO lbb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ning e Iesu i han mitingia, naur a barsan, naur a kut, dia muri, dia arkabah rakrakai mang, “Nat e Dewit, ur maris miau.” ");
INSERT INTO lbb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ning i kas ting na rumai, naur a kut dia han teteki, pa i deken diau mang, “I mangasa, mu tortorot ot hok sur ar tolsot pas a utna ne?” Dia kelesi mang, “Ma Leklek.” ");
INSERT INTO lbb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pa i tong naur a matandiau pa i atai diau mang, “Dir toli tetek mu anasa mu tortorot.” ");
INSERT INTO lbb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pa dia ka tai kakat. Pa e Iesu i sairas rakrakai tar diau mang, “Gong mu atai tar tik ono.” ");
INSERT INTO lbb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ika dia han pa dia atatai amon oe Iesu ting na papar rop ning. ");
INSERT INTO lbb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ning naur a kut dia kaning ot dia han amon kusun e Iesu, di ben otnan tar ning a barsan teteki, i ngat, a mot kaning ono. ");
INSERT INTO lbb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","E Iesu i kepsen a mot kusuni, pa barsan ning i ngat i bot warwara. Pa kunum a tarai la kulkulan, pa la atongi mang, “Bel ta utna larne di oroi tari te e Israel. I bot ne di oroi.” ");
INSERT INTO lbb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ika a Parisaiola la atongi mang, “I sira kepsen a motla ana rakrakai ana leklek anuna motla.” ");
INSERT INTO lbb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","E Iesu i han uting na tatatnan hananuala pa nanatar a hananuala rop. I sira asaer a taraila ting na nunla na rumai lotula, pa i sira warawai ana Wakak a Warwara ana matanitu ane God, pa i alangolango pas a tarai kusun a urmatana ngas a tinsamanla rop. ");
INSERT INTO lbb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ning i oroi a kunum a tarai, i maris kol la, anasa i talar a nuknukinla, pa bel ta harnanai tetek la, arlar ana sipsipla ning bel ta tena tai alar anunlai. ");
INSERT INTO lbb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pa i atongi tan anun a kakak a asaerla mang, “A barim ka makos, pa i galis kol, ika bel al galis a tena sol. ");
INSERT INTO lbb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mulor nunung a Leklek, esaning a taman a barim, sur ir sune a tena solla uting na nuna barim.” ");
INSERT INTO lbb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","E Iesu i kabah pas anuna ning a bonot pa pisir naur a kakak a asaerla pa i saran tar a rakrakai tanla sur lar kepsen a motla pa lar alangolango pas a tarai kusun a urmatana ngas a tinsamanla rop. ");
INSERT INTO lbb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ine a risan ning a bonot pa pisir naur a aposella: A ningnigona, e Saimon ning a risana otleng e Pita, ditas ma e Endru, e Jems pa e Jon ditas, naur a nat e Sebedi, ");
INSERT INTO lbb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","e Pilip, Batolomiu, Tomas, pa e Matiu a tena los totokom, Jems a nat e Alpius, Tadius, ");
INSERT INTO lbb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","pa e Saimon ning tagun a kunum Silot, pa e Judas Iskariot, esaning i asobor tar e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","E Iesu i sune sen ning a bonot pa pisir naur a kakak a asaerla, pa i atai la mang, “Gong mulo han tetek a tarai ning bel a tarai Israel, pa gong mulo han uting na hananuala ana te Samariala. ");
INSERT INTO lbb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mulor han ka tetek a tarai Israel, ning la rongo arlar ana sipsipla. ");
INSERT INTO lbb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ning mulo han, mulor warawai amon larne, ‘A matanitu misaot na langit ka milau.’ ");
INSERT INTO lbb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mulor alangolango pas a tinsamanla, pa mulor alaun pas a minatla, mulor alangolango pas a leprala, pa mulor kepsen a motla. Di tabar oros mulo ka, larka otleng ning, mulor artabar oros ka. ");
INSERT INTO lbb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gong mulo asubaran ta mani ting na numulo a kaenla. ");
INSERT INTO lbb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gong mulo los ta bek ting na numulo a tinan, gong al kelkeles, gong ta su, pa gong ta bulse. Anasa i tostos sur dir tabar a tena titol ana utna anai. ");
INSERT INTO lbb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ning mulor han uting na tatatnan hananuala, pa nanatar a hananuala, mulor tai sur tik ning i wakak, pa mulor kes napirna tuk ana pukakiar ning mulor han kusun a hanua ning. ");
INSERT INTO lbb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ning mulor kas ting na ta rumai, mulor warwara agasgas pas la. ");
INSERT INTO lbb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ning a tarai miting na rumai ning lar gas pas mulo, mulor atongi mang, ‘A balmolmol ir kes tetek mulo.’ Ika ning bel lar gas pas mulo, anumulo a balmolmol ir ulak tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ning tik bel i gas pas mulo, pa bel i longor anumulo a warwara, ning mulor han kusun a rumai ngasna, o a hanua ning, mulor tang sen a kubus kusun a hamulo. ");
INSERT INTO lbb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A atong momoli tamulo, ana pukakiar a warkurai, a warkurai a arkeles tetek a hanua ning ir rakrakai kol tana warkurai tetek e Sodom pa e Gomora.” ");
INSERT INTO lbb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Oroi, a sune sen mulo arlar ana sipsipla na arpotor tana ngalngaliah na pap. Mulor mananos wakak arlar ana soila, sur gong tik i ben rongon mulo, pa mulor tostos arlar ana tabunla, ning bel ta rongo kaning onla. ");
INSERT INTO lbb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mulor tumarang mulo, anasa a tarai lar saran tar mulo tetek a tena warkuraila, pa lar miras mulo ting na nunla na rumai lotula. ");
INSERT INTO lbb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pa dir dat mulo uting na warkuraila lanigo tana tatatnan ningnigola pa kingla, anasa mulo anuki. Mulor warwara talapor hok tetek la pa tetek a tarai ning bel a tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ning dir dat pas mulo, gong mulo matmataut sur asa mulor atongi, pa mulor warwara mangmangasa, anasa ana taim ot ning, e God ir saran tar a warwara ning mulor atongi. ");
INSERT INTO lbb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Anasa bel mulo mulor warwara, a Ingun a Tamamulo ot ir suah a warwara ting na pahamulo sur mulor atongi. ");
INSERT INTO lbb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tik ir saran sen e tasnalik sur dir umkoli, pa ta barsan ir saran sen e natnalik sur dir umkoli. Pa kakakla lar tur na harum tetek e tamanla pa kabatnanla pa lar saran sen diau sur dir umkol diau. ");
INSERT INTO lbb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pa taraila rop lar nget mulo anasa mulo anuki, ika esining ir tur rakrakai tuk anuna lalaun ir rop, e God ir alauni. ");
INSERT INTO lbb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ning lar alaulau mulo ting na ta hanua, mulor liu uting on ta hanua masik. A atong momoli tamulo, ning bel mulor han rop ot uting na hananuala te e Israel, a Nat a Barsan ir hanot. ");
INSERT INTO lbb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“A kaklik a asaer bel i leklek tan anuna tena asaer, pa tena titol oros otleng bel i leklek tan anuna ningnigo. ");
INSERT INTO lbb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","I tostos sur a kaklik a asaer ir arlar ana nuna tena asaer pa tena titol oros ir arlar ana nuna ningnigo. Ning di ka atong iau e Belsebul, mulo otleng ning mulo kes taum hok, dir atong mulo ana rising ning i laulau kol tana. ");
INSERT INTO lbb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Gong mulo matatan a taraila. A ututnala rop ning di bunur tari, lamur ir kes puasa, pa ututnala rop ning i kes kumna, lamur dir tasmani. ");
INSERT INTO lbb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Asaning a atai mulo ono ana mormorom, mulor atatai ono ana kabakiar, pa asaning di wasisik ka ono tetek mulo, mulor tur saot na rumai, pa mulor atong puasai. ");
INSERT INTO lbb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gong mulo matatan la ning la umkol ka a palaondi, ika bel lar tolsot sur lar umkol a ingundi. Mulor matatan esaning ir tol sot sur ir alaulau a palaondi pa ingundi otleng ting na tnan iah. ");
INSERT INTO lbb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Di sira lou naur a tek ana toia ka, gepi? Ika bel ta halindiau ir hirua, ning a Tamamulo bel i malmaling ono. ");
INSERT INTO lbb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","I momol kol, e God ka tasman naisa rop a hih a pukulumulo. ");
INSERT INTO lbb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","I maining gong mulo matmataut, anasa mulo itna kol na matana e God, mulo itna tana galis a tekla. ");
INSERT INTO lbb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Esining ir atong puasai na matan a taraila mang, i tagun iau, iau otleng ar atong puasai, na matana e Tata ning i kes saot na langit mang, i tagun iau. ");
INSERT INTO lbb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ika esining ir puain sen iau na matan a tarai, iau otleng ar puain seni na matana e Tata ning i kes saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gong mulo nuki mang a hanot sur ar saran a balmolmol te na rakrakan hanua. Bel a hanot sur ar saran a balmolmol, a hanot ana liwan a harum. ");
INSERT INTO lbb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A hanot sur a tarai lar kes na harum, i kamna hok. ‘A kaklik barsan ir nget e tamana, pa kaklik hane ir nget e tana, pa tinaulai a hane ir nget e tubuna. ");
INSERT INTO lbb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","La ning la kes ting na rumai anuna ning a barsan, la ot ning anun na hiruala.’ ");
INSERT INTO lbb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Esining i maris kol e tamana pa e tana, ika anuna marmaris tetek iau bel i itna larning, bel i to pasi sur i anuk a kaklik a asaer. Pa esining i maris kol e natnalik, a natar barsan o a hane, ika anuna marmaris tetek iau bel i itna larning, bel i to pasi sur i anuk a kaklik a asaer. ");
INSERT INTO lbb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Esining bel i kibas pas anuna rakai kutus pa i mur iau, bel i sot sur anuk a kaklik a asaer. ");
INSERT INTO lbb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Esining i mangan alar anuna lalaun, ir hirua, pa esining i noren sen anuna lalaun sur iau, ir laun. ");
INSERT INTO lbb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Esining ir gas pas mulo, i gas pas iau, pa esining i gas pas iau, i gas pas esaning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Esining ir gas pas a propet anasa a propet, ir kibas a ngas a arlou arlar ana propet ir kibasi. Pa esining ir gas pas a tena tostos, anasa a tena tostos, ir kibas a ngas a arlou arlar ana arlou ning a tena tostos ir kibasi. ");
INSERT INTO lbb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Esining ir tabar anuk ta kaklik a asaer, ning bel i sot na matan a tarai, ana ta kap a kotkoto na malum, anasa anuk a kaklik a asaer, a atong momoli tamulo, ir kibas ot anuna arlou.” ");
INSERT INTO lbb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ning e Iesu ka warwara rop tar tetek anuna ning a bonot pa pisir naur a kakak a asaer, i han mitingia sur ir asaer a tarai pa ir warawai ting na hananuala, tumo na papar Galili. ");
INSERT INTO lbb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E Jon i kes ting na karabus pa i longor a titolla anuna Karisito. Pa i sune anuna kakak a asaerla sur lar deke mang, ");
INSERT INTO lbb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“U ma ning di warwara nigo tar hom mang ur hanot, o milar harnanai ot sur tik?” ");
INSERT INTO lbb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Pa e Iesu i keles la mang, “Mulor ulak, pa mulor atai e Jon ana ututnala ne mulo ka longori pa mulo ka oroi tari: ");
INSERT INTO lbb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","A kutla la ka tai, la ning a hanla i mat la ka han tostos, a leprala la ka langolango, na talngana kutkut la ka longor, a minatla la ka kamtur, pa di warawai ana Wakak a Warwara tetek a kapan a tarai. ");
INSERT INTO lbb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Esining i oroi a ututnala ne a toli, pa anuna tortorot bel i punga, ka angis.” ");
INSERT INTO lbb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ning kaning a kakak a asaerla ane Jon la han, e Iesu i atai a kunum a tarai oe Jon mang, “Lanigo ning mulo han uting na hanua bel tetek e Jon, asaning mulo tai suri? Ngandek a kunai ning i maler ana wuwu? Bel. ");
INSERT INTO lbb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Asaning mulo han sur mulor oroi i? A barsan ning i mermer ana wakak a kaenla? Bel. Oroi, la ning la sira mermer ana ngangaten a kaenla la sira kes ting na rumai ana kingla. ");
INSERT INTO lbb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Asaning mulo han sur mulor oroi i? A propet? Momol, a atai mulo, e Jon i leklek kol tana propetla. ");
INSERT INTO lbb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Di ka tumtumus tar onoi ting na Buk Tabu mange, ‘Oroi, ar sune anuk a tena los warwara sur ir nigon u, pa ir atalapor anum a ngas.’ ");
INSERT INTO lbb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A atong momoli tamulo, e Jon a Tena Baptais i leklek kol tana taraila rop mite lapiu. Ika esining i natarna kol ana matanitu misaot na langit, i leklek tana. ");
INSERT INTO lbb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Turpasi ana rau ning e Jon a Tena Baptais i turpas a warawai tuk onone, a matanitu misaot na langit i han rakrakai amon, pa tarai la rakrakai kol sur lar kas tingia. ");
INSERT INTO lbb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A propetla rop pa Warkuraila ane Moses la apuasa a warwara ana matanitu ane God, tuk ana rau ning e Jon i turpas a titol ono. ");
INSERT INTO lbb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","La warwara ana propet Elaija ning ir hanot. Ning mulo mang sur mulor tortorot ana warwara ning, anone, e Jon a propet Elaija ning ir hanot. ");
INSERT INTO lbb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Esining a talngana kaning, i wakak ning ir longor ono. ");
INSERT INTO lbb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Esi na warwara larlar ning ar atongi ana tarai tagun onone? La arlar ana kakakla ning la kes ting na tinine hanua pa la arkabah tetek na halalinla mang, ");
INSERT INTO lbb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mila pasar kudu, ika bel mulo tortor ono, pa mila saken a saksak a balmaris, ika bel mulo domos ono.’ ");
INSERT INTO lbb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","E Jon i hanot, bel i ien ta wakak a utna pa bel i gang a wain, pa la atongi onoi mang, ‘A mot kaning onoi.’ ");
INSERT INTO lbb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A Nat a Barsan i hanot, i hangan pa i gang, pa la atongi onoi mang, ‘Oroi, a barsan ne a tena hangan pa tena gang, a hal a tena los totokomla pa tena laulaula.’ Ika a titolla ane God i apuasa i mang, anuna tastasman i a tastasmai momol.” ");
INSERT INTO lbb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pa e Iesu i warwara na balakut tetek a tarai ting na hananuala ning ka tol tar anuna galis a utna na kulkulan kol tingia, anasa bel la lingir a nuknukinla. ");
INSERT INTO lbb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","I atongi mang, “Ir laulau tetek mulo a tarai Korasin, pa ir laulau otleng tetek mulo a tarai Betsaida. Ning di kar tol tar a ututnala na kulkulan ne tetek a tarai Tair pa tarai Saidon, arlar larning di ka tol tari tetek mulo, la kar lingir kapit a nuknukinla pa lar tobo, lar mermer ana kaenla na tobo pa lar sabar a palaonla ana kubus a iah. Ika mulo, bel mulo lingir a nuknukimulo. ");
INSERT INTO lbb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A atongi tamulo mang, ana pukakiar a warkurai, a warkurai a arkeles tetek mulo a tarai Korasin pa tarai Betsaida, ir rakrakai kol tana warkurai tetek a tarai Tair pa tarai Saidon. ");
INSERT INTO lbb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pa mulo otleng a tarai Kapernaum, mangasa, mulo nuki mang dir aleklek pas mulo usaot? Bel! Dir migen purum mulo uting na tnan iah. Ning di kar tol tar a ututnala na kulkulan tetek a tarai Sodom, arlar larning di ka tol tari tetek mulo, e Sodom kanet. ");
INSERT INTO lbb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A atongi tamulo mang, ana pukakiar a warkurai, a warkurai a arkeles tetek mulo a tarai Kapernaum ir rakrakai kol tana warkurai tetek a tarai Sodom.” ");
INSERT INTO lbb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ana taim ning, e Iesu i atongi mang, “Tata, u a Leklek saot na langit pa te na rakrakan hanua rop. Ar rakan aleklek pas u, anasa u bunur a ututnala ne kusun a tena tastasmaila pa la ning la tastasman, pa u apuasa i tetek la ning la arlar ana kakakla. ");
INSERT INTO lbb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A momolna, Tata, anasa u mang ot sur ir manglarning. ");
INSERT INTO lbb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“E Tata ka saran tar a ututnala rop tak. Bel tik i tasman e Natnalik, e Tamana ka, pa bel tik otleng i tasman e Tamana, e Natnalik ka, pa la otleng ning e Natnalik i mang sur ir apuasa e Tamana tetek la. ");
INSERT INTO lbb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mulo rop ning a palaomulo i ngol pa mamahatla i monong mulo, mulor han tetek iau, sur ar amanah mulo. ");
INSERT INTO lbb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mulor los anuk a ikep, pa mulor noren iau ar asaer mulo, anasa a magirak i wowowon pa sira anatarna pas iau. Mulor los anuk a ikep sur a ingumulo ir manah. ");
INSERT INTO lbb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Anasa a ikep ar sarani tamulo bel i ngangaten, pa lolos ar sarani tamulo bel i mamahat.” ");
INSERT INTO lbb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lamur, ana ning a Pukakiar Sabat, e Iesu i han potor ting na barim a wit. Anuna kakak a asaerla la murak, pa la turpas a kumut kutus a witla pa la ieni. ");
INSERT INTO lbb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ning a Parisaiola la oroi i, la atai i mang, “Oroi, anum na kakak asaer la tol a utna ning, pa bel la mur a warkurai tagun a Pukakiar Sabat.” ");
INSERT INTO lbb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","E Iesu i keles la mang, “I mangasa, belot mulo was asaning e Dewit i toli, ning la murak taum ana taraila ning la armuri? ");
INSERT INTO lbb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I kas uting na rumai ane God, pa i ien a bret ning di ka tabar tar e God ono. Pa la otleng ning la han taum onoi la hangan ono. A bret ning, a warkurai ono i manglarne, na tena artabar tetek e God ka lar ieni, pa tarai oros gong. ");
INSERT INTO lbb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","I mangasa, belot mulo was a warwara miting na Buk a Warkurai? I atongi mang, na tena artabar tetek e God la sira titol ting na rumai artabar ana Pukakiar Sabat, ika bel la rongo ono. ");
INSERT INTO lbb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A atongi tamulo mang, takai kane i itna tana rumai artabar. ");
INSERT INTO lbb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ning ngandek mulo ka tasman a kamkam a warwara ne, ‘A mang sur a marmaris, pa bel a mang sur a artabar ning di sira tuni,’ bel mulor tiu la ning bel la rongo. ");
INSERT INTO lbb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Anasa a Nat a Barsan a Leklek tagun a Pukakiar Sabat.” ");
INSERT INTO lbb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E Iesu i han mitingia, pa i kas uting na nunla a rumai lotu. ");
INSERT INTO lbb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ning a barsan kaning ia, a kuna i del. La tai sur ta ngas ning lar tiu e Iesu ono, pa la dekeni mang, “I mangasa, i tostos ot arlar ana anundala a Warkuraila sur dir alangolango pas tik ana Pukakiar Sabat o bel?” ");
INSERT INTO lbb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pa i keles la mang, “Ning ta halimulo anuna ta sipsip ir punga tar uting na ta tung ana Pukakiar Sabat, mangmangasa, bel ir tong akesi pa ir dat kas ulaki? ");
INSERT INTO lbb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A sipsip a utna oros ka, ika a barsan i itna kol. Larning, i tostos sur dir tol a wakakna ana Pukakiar Sabat.” ");
INSERT INTO lbb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pa i atai a barsan ning mang, “Ur kodos a kum.” I kodosi, pa kuna i tostos ulak, arlar ana ning a kuna ning i wakak. ");
INSERT INTO lbb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A Parisaiola la purum, pa la warwara taum pas sur ta ngas ning lar umkol e Iesu ono. ");
INSERT INTO lbb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ning e Iesu i tasmani mang la warwara taum sur lar umkoli, i han masik mitingia. A galis a tarai la muri, pa i alangolango pas la rop ning la sasam. ");
INSERT INTO lbb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pa i atumarang la, sur gong la atai tar tik mang, i esi. ");
INSERT INTO lbb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I atongi larne sur ir tolsot pas a warwara ane God ning e Aisaia a propet ka warwara nigo tar ono mang, ");
INSERT INTO lbb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ine anuk a tena titol ning ia ka aslang pasi, a katnani, a gas kol ono. Ar akas tar a Inguk ono, pa ir apuasa a warkurai ning i tostos tetek na tarai miting na matanitula. ");
INSERT INTO lbb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bel ir warwara na balakut, pa bel ir agaia, bel dir longor a elngena ting na ngasla. ");
INSERT INTO lbb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bel ir kuben a kunai ning i talikun, pa bel ir wus kol a lam ning bel i kubar wakak. Ir toli larne tuk a tostos a warkurai ir tolsot pas a toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na tarai miting na matanitula lar tortorot ana risana pa lar harnanai sur ir alaun la.” ");
INSERT INTO lbb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","La ben otnan tar ning a barsan tetek e Iesu, i ngat pa i kut, pa mot kaning ono. E Iesu i alangolango pasi, pa barsan ning i warwara pa i tai kakat. ");
INSERT INTO lbb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pa tarai rop la kulkulan, pa la deke mang, “Ngandek a Nat e Dewit ot ne?” ");
INSERT INTO lbb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ika a Parisaiola la longori pa la atongi mang, “A barsan ne, i sira kepsen a motla ana rakrakai e Belsebul, a leklek anuna motla.” ");
INSERT INTO lbb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","E Iesu ka tasman tar a nuknukinla, pa i atongi tanla mang, “Ning a tarai miting na ta matanitu lar harum artalai tanla ot, a matanitu ning ir rarop. Ning ta hanua, o al tarai miting na ta rumai, lar harum artalai tanla ot, bel ma lar kes taum. ");
INSERT INTO lbb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ning e Satan ir kepsen anuna tena titolla, bel lar tur taum ulak ma, lar han sarara. Manglarning, anuna matanitu ir tur rakrakai mangmangasa? ");
INSERT INTO lbb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ning iau a kepsen a motla ana rakrakai e Belsebul, anumulo na tarai la sira kepsen la ana rakrakai esi? Mulo tasmani mang la kepsen a motla ana rakrakai e God, pa ine i asangani mang anumulo a artitiu hok i rongo. ");
INSERT INTO lbb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ika, ning a kepsen a motla ana rakrakai a Inguna e God, mulor tasmani mang a matanitu ane God ka hanot tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bel tik ir tolsot pas sur ir kas uting na rumai anuna ta rakrakai a barsan, pa ir los pas a ututnala mitisaui na rumai, ning bel ir dot akes nigon tari. Ning ot ir dot akes nigon tari, ir bot los a ututnala anuna barsan ning. ");
INSERT INTO lbb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Esining bel i nangan iau, i sairas iau ka. Pa esining bel i nangan iau ona ben a tarai, i lu sarara la ka. ");
INSERT INTO lbb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pa atongi tamulo mang, e God ir kepsen na toltol laulau rop anuna tarai, pa nunla na laulau a warwara otleng oe God, ika a warwara laulau ana Talngan Tabu, e God bel ir kepseni. ");
INSERT INTO lbb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Esi otleng ning ir atong tar ta laulau a warwara ana Nat a Barsan, e God ir kepsen anuna toltol laulau ning, ika esining ir atong laulau a Talngan Tabu, e God bel ir kepsen anuna toltol laulau ning, ana lalaun anone pa ana lalaun lamur otleng. ");
INSERT INTO lbb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ning a rakai i wakak, ir sira suah a wakak a wana, pa ning a rakai i laulau, ir sira suah a laulau a wana. Dir oroi lalan a rakai miting na wana. ");
INSERT INTO lbb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mulo na natnat a soila! Mulo ning a laulau a taraila, mulor atong mangasa ta wakak a warwara? Anasa a pahana tarai i atong puasa a toltol ning i bukus ting na balanla. ");
INSERT INTO lbb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A wakak a barsan i asangan anuna wakak a toltol ning kaning na balana, pa laulau a barsan otleng, i asangan anuna toltol laulau ning kaning na balana. ");
INSERT INTO lbb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A atongi tamulo mang, a warwara laulaula rop ning a tarai la ka atong tari, lamur bot, ana pukakiar a warkurai, e God ir deken la ono. ");
INSERT INTO lbb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ana pukakiar ning, anum a warwara ot ir alangolango u, o ir saran a warkurai a arkeles tetek u.” ");
INSERT INTO lbb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lamur dingla na tarai tagun na tena asaer tagun a warkurai pa Parisaiola la atongi tana mang, “Tena Asaer, ur tol ta akinalang sur milar tasmani mang, u a tena titol ane God.” ");
INSERT INTO lbb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","I keles la mang, “A tarai tagun onone, a laulau a tarai, anunla a lalaun i bakbak kusun e God. La nunung sur ta akinalang, ika bel dir tol tar tik tetek la. Dir tol ka a akinalang arlar larning di tol tari oe Jona a propet. ");
INSERT INTO lbb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Arlar oe Jona i laun natol a pukakiar ting na balan a tnan sis, larka otleng ning a Nat a Barsan ir borbor pas natol a pukakiar tingui na piu. ");
INSERT INTO lbb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ana pukakiar a warkurai, a tarai Niniwe lar tur pa lar tiu rakrakai a tarai tagun onone, anasa la lingir a nuknukinla ana warawai ane Jona, ika onone, esaning i leklek ta e Jona kanet. ");
INSERT INTO lbb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ana pukakiar a warkurai, a kwin mitumo na matana tobar ir tur pa ir tiu rakrakai a tarai tagun onone, anasa i hanot miting bakbak sur ir longor a mananos ana King Solomon, pa onone, esaning i leklek ta e Solomon kanet. ");
INSERT INTO lbb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ning ta mot ir purum kusun ta barsan, ir han uting na puknala ning bel al malum ia, sur ir manah, ika bel ir pastek ta pukna ning ir manah ia. ");
INSERT INTO lbb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pa ir atongi mange, ‘Ar ulak sur anuk a rumai, ning a purum tar kusuni.’ Ning ir hanot, ir oroi mang ka belbel, di ka surupu tar, pa di ka atostos tari. ");
INSERT INTO lbb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Lamur ir han pa ir ben ulak pas mais a mot, ning la laulau kol tana, pa lar kas rop ting na rumai ning, pa lar kes tingia. Pa lalaun anuna barsan ning ir laulau kol tan anuna lalaun nating. Ir mang ka otleng tetek a laulau a tarai tagun anone, anunla lalaun lamur ir laulau kol.” ");
INSERT INTO lbb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ning e Iesu kaning ot i warwara tetek a kunum a tarai, e tana pa na tastasna la hanot, pa la tur tumo lapiu, anasa la mang sur lar warwara taum onoi. ");
INSERT INTO lbb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pa ning a barsan i atai e Iesu mang, “E tnam pa na tastasim, kanumo la tur tumo lapiu. La mang sur lar warwara taum hom.” ");
INSERT INTO lbb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pa i kelesi mange, “Esi e nang, pa esi la na tastasik?” ");
INSERT INTO lbb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pa i tusu tetek anuna tarai a asaer pa i atongi mang, “Oroi, la ne e nang pa na tastasik! ");
INSERT INTO lbb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Anasa esining i sira mur a nuknuk e Tata ning i kes saot na langit, i ka ning a tasik barsan, pa tasik hane, pa e nang.” ");
INSERT INTO lbb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ana pukakiar ning, e Iesu i purum kusun a rumai pa i kes ting napir a puka tasi Galili. ");
INSERT INTO lbb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A tnan kunum a tarai la tur talilis pasi. Pa i kas uting na mon pa i kes, pa tarai rop la tur tumokorot na hang. ");
INSERT INTO lbb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","I warwara tetek la ana galis a utna ana warwara larlarla. I atongi mang, “A tena omomai i han sur ir sapran a pat a witla. ");
INSERT INTO lbb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ning i sapran amon la, dingla la punga ting na ngas, pa manila la rowoi ot pa la ien sen la. ");
INSERT INTO lbb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dingla otleng la punga ting na pukna ning i hatat, pa bel al galis a piu ono, pa la gomo kapit, anasa a piu bel i but. ");
INSERT INTO lbb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ika ning a kamis i sasai ot, la main pa la marang rop, anasa bel al wakirinla. ");
INSERT INTO lbb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dingla na patna otleng la punga tar ting na tinine rosrosla, pa rosrosla la gomo ot pa la rau alar pas la. ");
INSERT INTO lbb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pa dingla na patna otleng la punga ting na wakak a piu pa la wai. Dingla la wai takai a mar a wanala, dingla otleng diono na bonot, pa dingla natol a bonot. ");
INSERT INTO lbb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Esining a talngana kaning, i wakak ning ir longor ono.” ");
INSERT INTO lbb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anuna kakak a asaerla la han teteki pa la dekeni mang, “Sur asa u warwara tetek a tarai ana warwara larlarla?” ");
INSERT INTO lbb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Pa i keles la mang, “E God ka saran tar a tastasmai tamulo, sur mulor talapor ana ututnala ana matanitu misaot na langit, ning nating i kes kumna. Ika, bel i sarani tetek a tarai rop. ");
INSERT INTO lbb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Anasa esining a tastasman kaning tana, dir tabar ulaki ana tnan, pa ir tastasmai kol. Pa esining bel ta tastasman kaning tana, dir kepsen otleng siklik ning kaning tana. ");
INSERT INTO lbb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","A asaer la ana warwara larlarla, anasa la oroi, ika bel la oroi lalani, la longori, ika bel la longor lalani, pa bel la tastasmai ono. ");
INSERT INTO lbb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A warwara na propet ane Aisaia ka sot onla, ning i atongi mang, ‘Mulor longor pa mulor longor, ika bel mulor longor lalani, mulor tai pa mulor tai, ika bel mulor oroi lalani. ");
INSERT INTO lbb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Anasa a tarai ne na balanla i rakrakai, na taltalnganla i kutkut, pa na matmatanla i kut. Sakana lar oroi lalani ana matmatanla, pa lar longor lalani ana taltalnganla, pa lar tastasman ana nuknukinla, pa lar talingir, par alaun pas la.’ ");
INSERT INTO lbb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ika mulo, mulo angis, anasa mulo tai ot ana matamulola, pa mulo longlongor ot ana talngamulola otleng. ");
INSERT INTO lbb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A atong momoli tamulo, lanigo a galis a propet pa galis a tena tostos la tekes kol sur lar oroi a ututnala ning a toli na matamulo, ika bel la oroi i. Pa la tekes kol otleng sur lar longor a ututnala ne mulo longori, ika bel la longori. ");
INSERT INTO lbb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mulor longor a kamkama a warwara larlar ana tena omomai. ");
INSERT INTO lbb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Esining i longor a warwara ana matanitu misaot na langit, pa bel i tastasmai onoi, i arlar ana pat a witla ning la punga ting na ngas. A barsan laulau i hanot pa i kibas sen a warwara ning di ka oman tari ting na balana. ");
INSERT INTO lbb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pa patnala ning la punga ting na pukna ning i hatat, la arlar ana barsan ning i longor a warwara, pa ono otning, i tong akesi ana gasgas. ");
INSERT INTO lbb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ika a warwara bel i kes rakrakai ting na balana, pa barsan ning bel ir tur bongnani arlar ana wit ning bel al wakirna. Ning a mamahatla ir hanot, pa dir alaulau i, anasa i tortorot ana warwara ane God, ir punga kapit. ");
INSERT INTO lbb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A patnala ning la punga tar ting na tinine rosrosla, la arlar ana barsan ning i longor a warwara, ika a nuknukna sur a wakak a keskes te lapiu, pa nuknuk otleng sur anuna gongon ning i asongo a nuknukna, la rau alar a warwara ane God, pa bel i wai. ");
INSERT INTO lbb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ika a patnala ning la punga ting na wakak a piu, la arlar ana barsan ning i longor a warwara, pa i tastasmai ono. Ir suah takai a mar, o diono na bonot, o natol a bonot a wana.” ");
INSERT INTO lbb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","E Iesu i atong takai a warwara larlar otleng tetek la mang, “A matanitu misaot na langit i arlar ana barsan ning i sapran a wakak a pata witla ting na nuna barim. ");
INSERT INTO lbb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ning a tarai la borbor, anuna hirua i hanot pa i sapran tar a pata karapala ting na tinine witla, pa i han. ");
INSERT INTO lbb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ning a pata wit i gomo ot pa i mang sur ir wai, di oroi otleng a karapa i gomo na tinine. ");
INSERT INTO lbb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A tena titolla ana taman a barim la han teteki, pa la atongi tana mang, ‘Leklek, mangmangasa, a pata wakak a witla rop ka ning u sapran tari ting na num a barim? Mitaha otleng a karapala?’ ");
INSERT INTO lbb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I keles la mang, ‘A hirua i tol a toltol ning.’ Pa la dekeni mang, ‘U mang sur milar han, pa milar gat arop sen la?’ ");
INSERT INTO lbb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","I sairas la mang, ‘Gong kaba, sakana mulor gat taum seni ana witla. ");
INSERT INTO lbb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Noren seni, diar gomo taum tuk ana kalang a sol. Ana taim ning, ar atongi tana tena solla mang: Mulor kibas nigon sen a karapala, mulor dot taum tar a butanala sur dir tun sen la ting na iah. Pa lamur mulor los taum maleng a witla uting na nuk a rumai a gongon.’” ");
INSERT INTO lbb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","E Iesu i atong ning a warwara larlar otleng tanla mang, “A matanitu misaot na langit i arlar ana pat a mastad, ning takai a barsan i kibas pasi, pa i oman tari ting na nuna barim. ");
INSERT INTO lbb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","I natarna kol tana pat a rakaila rop, ika ning i gomo, i itna kol tana rakai a hanganla rop. Pa manila la sira tol pios saot na rakrakana.” ");
INSERT INTO lbb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","E Iesu i atong ning a warwara larlar otleng tanla mang, “A matanitu misaot na langit i arlar ana is, ning a hane i kibas pasi, pa i tol taumi ana tnan palawa, pa palawa rop i bubus onoi.” ");
INSERT INTO lbb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","E Iesu i asaer a kunum a tarai ana ututnala rop ne ana warwara larlarla. Pa bel i warwara tetek la ana ta maskana warwara, a warwara larlarla rop ka. ");
INSERT INTO lbb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I atongi larning sur dir tolsot pas a warwara anuna propet mang, “Ar warwara ana warwara larlarla, ar atong a ututnala ning i kes kumna, turpasi nating ot, ning e God i akes a rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Lamur e Iesu i han kusun a kunum a tarai, pa i kas ting na rumai. Anuna kakak a asaerla la kas teteki pa la atai i mang, “Ur pak a kamkama a warwara larlar ne tamila ana karapa ning i gomo ting na tinine barim.” ");
INSERT INTO lbb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I keles la mang, “Esaning i sapran a pata witla, a Nat a Barsan. ");
INSERT INTO lbb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A barim, a rakrakan hanua, pa wakak a pata witla, la a tarai tagun a matanitu misaot na langit, pa karapala, la na natnat a laulau a barsan, ");
INSERT INTO lbb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","pa hirua ning i sapran la, e Satan. A kalang a sol, a ararop ana rakrakan hanua, pa na tena sol, a angelola. ");
INSERT INTO lbb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na tena sol la los taum a karapala pa la tun sen la ting na iah. Ir mang ka otleng larning ana ararop a pukakiar. ");
INSERT INTO lbb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A Nat a Barsan ir sune sen anuna angelola, pa lar kibas arop sen a ututnala ning i ben rongon a tarai, pa la otleng ning la sira tol a toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pa lar migen la uting na tnan iah. Lar tangtangis pa lar arngingit ngesenla tingia. ");
INSERT INTO lbb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pa na tena tostos lar sasai arlar ana kamis ting na matanitu anun e Tamanla. Esining a talngana kaning, i wakak ning ir longor ono. ");
INSERT INTO lbb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“A matanitu misaot na langit i arlar ana utna ning a matana i abit kol, ning di bunur tari ting na barim. Ning a barsan i pastek pasi pa i bunur ulak tari. Pa i han ana gasgas, pa i siuran arop sen anuna ututnala, pa i lou pas a barim ning ono. ");
INSERT INTO lbb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“A matanitu misaot na langit i arlar otleng ana ning a tena siusiurai, i tai sur a wakak a hatatla kol ning i sira kes ting na tinine kabokabol. ");
INSERT INTO lbb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ning i pastek pas ning a hat a matana i abit kol, i siuran arop sen anuna ututnala, pa i lou pas a hat ning ono. ");
INSERT INTO lbb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“A matanitu misaot na langit i arlar otleng ana uben, ning di migen tari sakas latasi, pa urmatana ngas a sis la hirua tar ono. ");
INSERT INTO lbb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ning a uben i bukus, na tena migen uben la dat masmasa tari ting na hang. La kes pa la timlan sen a wakak a sisla uting na ratla, pa laulaunala la migen sen la. ");
INSERT INTO lbb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ana ararop a pukakiar dir toli ot larne: A angelola lar hanot pa lar asalar sen a tena laulaula kusun a tena tostosla. ");
INSERT INTO lbb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pa lar migen a tena laulaula uting na tnan laplapang a iah. Lar tangtangis pa lar arngingit ngesenla tingia.” ");
INSERT INTO lbb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","E Iesu i deken la mang, “I mangmangasa, mulo ka talapor ana kamkama a ututnala rop ne, o bel?” Anuna kakak a asaerla la kelesi mang, “Ma!” ");
INSERT INTO lbb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pa e Iesu i atai la mang, “Na tena asaerla rop tagun a warkurai, ning la ka asaer pas ana matanitu misaot na langit, la arlar ana barsan ning i gon a wakak a ututnala ting na nuna rumai. Pa i apurum a wakak a ututnala ning kusun anuna rumai sur ir titol onoi, dingla na utna, na tona, pa dingla otleng, na turaina.” ");
INSERT INTO lbb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ning e Iesu ka atong rop tar a warwara larlarla ning, i han mitingia, ");
INSERT INTO lbb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","pa i hanot ting na hanua ngasna, tumo e Nasaret. I turpasi sur ir asaer a tarai tingia na nunla a rumai lotu, pa la kulkulan kol pa la atongi mang, “A barsan ne i kibas a tastasmaila ne tahaia? Pa mitaha otleng a rakrakai ning i tol a ututnala na kulkulan ne onoi? ");
INSERT INTO lbb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","E Tamana a tena tol rumai ka, pa e tana e Maria. Na tastasnala otleng, e Jems, Josep, Saimon pa e Judas ");
INSERT INTO lbb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","pa na tastasna hane otleng kane dala laun taum te. Pa mitahaia a rakrakai ning a barsan ne i tol a ututnala ne onoi?” ");
INSERT INTO lbb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pa bel la gas ono. Ika e Iesu i atai la mang, “Di sira hanrawai a propet ting na hanua masik, ika la ot ting na hanua ngasna pa ting na rumai ngasna bel la hanrawai i.” ");
INSERT INTO lbb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pa bel i tong a galis a utna na kulkulan tingia, anasa bel la tortorot ono. ");
INSERT INTO lbb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ana rau ning, e Herot a ningnigo tagun a matanitu i longor a warwara oe Iesu, ");
INSERT INTO lbb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","pa i atai anuna tena titolla mang, “A barsan ning, e Jon a Tena Baptais, ka kamtur ulak kusun a minat. I maining i tol a ututnala na kulkulan.” ");
INSERT INTO lbb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Lanigo e Herot i sune sen anuna tena harumla sur lar tong pas e Jon. La doti, pa la akasi ting na karabus. E Herot i toli larne, anasa e Jon ka usur tari ono mang, “Bel i tostos ning u taulai e Herodias, e harimlik.” I atongi larne, anasa e Herot ka dat pas e Herodias, a hane ane Pilip, e tasnalik, pa i taulai i. ");
INSERT INTO lbb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pa e Herot i mang sur ir umkol e Jon, ika i matatan a tarai, anasa la tasmani mang e Jon a propet. ");
INSERT INTO lbb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ana pukakiar ning di aslang pas a agon ane Herot, e natna hane e Herodias, i tortor napirinla. E Herot i gas kol onoi, ");
INSERT INTO lbb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","pa i lele rakrakai tar oe nat e Herodias mang, “Asa ka ma ning ur nunungi tak ar sarani ka.” ");
INSERT INTO lbb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pa i atai i mang, “Ur suah a pukul e Jon a Tena Baptais ting na ta pelet pa ur sarani tak.” I atongi larne anasa e tana ka atai tari onoi. ");
INSERT INTO lbb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A king i balmaris kol. Ika i sune a tena harumla sur lar longor ana nunung ana basbas ning, anasa ka lele tar mang, asa kama ning ir nunung suri ir sarani ka, pa tarai ning la kes taum onoi ana utna na hangan, la ka longor tar a warwara. ");
INSERT INTO lbb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Na tena harum la han utumo na karabus pa la umsem ana ruana e Jon. ");
INSERT INTO lbb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","La suah a pukulna ting na pelet pa la sarani tana basbas, pa i losi tetek e tana. ");
INSERT INTO lbb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pa kakak a asaerla ane Jon la hanot pa la los pas a minatna, pa la pori. Lamur la han tetek e Iesu pa la atai i ono. ");
INSERT INTO lbb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ning e Iesu i longori mang e Jon ka mat, i kas ana mon pa i han mitingia sur uting na hanua bel, sur i sot ka ir kes. Ning a tarai la longori, a kunum a tarai miting na hananuala la muri ting na ngas sur uting na pukna ning. ");
INSERT INTO lbb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ning i sot tingia, i oroi a tnan kunum a tarai. I maris kol la, pa i alangolango pas a tinsamanla. ");
INSERT INTO lbb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ning ka rah, anuna kakak a asaerla la han teteki, pa la atai i mang, “A pukna ne i bakbak kusun a hananuala, pa ka rah otleng. Ur sune sen a kunum a tarai sur lar han uting na hananuala, sur lar lou pas anla al utna na hangan.” ");
INSERT INTO lbb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","E Iesu i keles la mang, “Lar han sur asa? Mulo ot mulor tabar la.” ");
INSERT INTO lbb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","La atai i mang, “Dilima na bret ka, pa naur a sis kane mila losi.” ");
INSERT INTO lbb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","I atai la mang, “Mulor losi ute tak.” ");
INSERT INTO lbb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pa i arsune sur a kunum a tarai lar kes ting na ulai. I kibas pas dilima na bret pa naur a sis, i tadai usaot na langit, i atong wakak tetek e God onoi, i kibik dilima na bret, pa i sarani tan anuna kakak a asaerla. Pa la asalar a kunum a tarai ono. ");
INSERT INTO lbb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","La rop la hangan pa la masur. Pa la song bukus pas ning a bonot pa pisir naur a rat ana mah a utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A wawas ana tarai ka i arlar ana dilima na rip, pa gurarala pa kakakla otleng la hangan taum onla. ");
INSERT INTO lbb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ono otning, e Iesu i sune sen anuna kakak a asaerla, sur lar kas ana mon, pa lar nigo utumo na ning a ris a puka tasi. Pa i, i kes ot sur ir sune sen a tarai. ");
INSERT INTO lbb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ning ka sune rop sen la, i sot kama i han usaot na mangir sur ir araring. Ning ka rah morom i kama kaning i kes. ");
INSERT INTO lbb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A mon ka han potor pa i turangin amon ana top, anasa a wuwu i harum misa lanigo. ");
INSERT INTO lbb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ana lar, e Iesu i han saot na palai a puka tasi tetek la. ");
INSERT INTO lbb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ning anuna kakak a asaerla la oroi pasi ning i han saot na palai a puka tasi, la matmataut kol pa la atongi mang, “A ingun ka ning!” Pa la woiwoi ana matmataut. ");
INSERT INTO lbb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ono otning e Iesu i atai la mang, “Mulor kosom, iau ka ne. Gong mulo matmataut.” ");
INSERT INTO lbb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","E Pita i atai e Iesu mang, “Leklek, ning u ot ning, ur atai iau sur iau otleng ar han saot na palai a tasi tetek u.” ");
INSERT INTO lbb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","E Iesu i atai i mang, “Ur han ute.” Pa e Pita i sirok kusun a mon, pa i han saot na tasi tetek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ika, ning i oroi a rakrakai a wuwu, i matmataut. Pa i turpas a murung, i arkabah mang, “Leklek, ur alaun iau.” ");
INSERT INTO lbb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ono otning, e Iesu i kodos a kuna teteki, i dat kasi, pa i atai mang, “Anum a tortorot i natarna kol. I mangasa ning u urmatana nuknuk?” ");
INSERT INTO lbb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ning dia kas uting na mon, a wuwu i rop kakat. ");
INSERT INTO lbb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","La ning la kes ting na mon la lotu tetek e Iesu, pa la atongi mang, “I momol ot, u a Nat e God.” ");
INSERT INTO lbb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ning la ka han lakai tumo na ning a ris a puka tasi, la sot tumo na papar Genesaret. ");
INSERT INTO lbb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ning a tarai mitingia la oroi lalan pas e Iesu, la saran warwara uting na hananuala rop ting na papar ning. Lamur la ben arop pas a tinsamanla teteki. ");
INSERT INTO lbb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pa la nunungi sur a tinsamanla lar tuk tar ka a tuka kaen anunai. Pa la rop ning la tuk tari, la langolango kakat. ");
INSERT INTO lbb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dingla na Parisaio pa tena asaerla tagun a warkurai la han misaot e Jerusalem tetek e Iesu, pa la dekeni mang, ");
INSERT INTO lbb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sur asaning anum a kakak a asaerla bel la sira mur a asaerla ana nundala na tarai tagun nating? Bel la gos nigon pas a kunla ning la hangan.” ");
INSERT INTO lbb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pa i keles la mang, “Sur asaning bel mulo mur a warkurai ane God? Mulo mur ka a asaerla ana numulo a tarai tagun nating. ");
INSERT INTO lbb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anasa e God i atongi mang, ‘Ur hanrawai e tamam pa e tnam,’ pa i atongi otleng mang, ‘Esining ir warwara laulau oe tamana pa e tana, dir umkoli.’ ");
INSERT INTO lbb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ika mulo, mulo asaer a tarai mang, i wakak ka ning tik ir atongi ta e tamana pa e tana mang, ‘Asaning ar nangan mu ono, ia ka saran tari tetek e God.’ ");
INSERT INTO lbb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ika ning bel i nangan e tamana, bel i hanrawai i. Ning mulo toli larning, mulo anatarna pas a warwara ane God sur mulor mur ka a asaerla ana numulo na tarai tagun nating. ");
INSERT INTO lbb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mulo a tena asasongola. A warwara ane Aisaia i momol ot, ning i warwara na propet nigo tar omulo mang, ");
INSERT INTO lbb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘A tarai ne la hanrawai iau ka ana pahanla, ika a balanla i bakbak kol kusun iau. ");
INSERT INTO lbb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","La lotu oros ka tetek iau, anasa la asaer a taraila ana warkuraila ka anuna taraila.’” ");
INSERT INTO lbb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","E Iesu i kabah a kunum a tarai teteki, pa i atongi mang, “Mulor longor iau pa mulor talapor ana nuk a warwara. ");
INSERT INTO lbb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Asaning ir kas uting na pahana barsan, bel ir aduri na matana e God. Ika, asaning ir atongi ana pahana, i ning ir aduri na matana e God.” ");
INSERT INTO lbb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lamur anuna kakak a asaerla la han teteki pa la dekeni mang, “U ka tasmani mang a Parisaiola la bal mamahat ana num a warwara?” ");
INSERT INTO lbb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","I keles la mang, “A rakaila ning e Tata, ning i kes saot na langit, bel i oman la, dir gat arop sen la. ");
INSERT INTO lbb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mulor noren sen a Parisaiola. La na ningnigola, la arlar ka ana kutla. Ning ta kut ir ben ta kut, dia rop diar punga lorong ting na tung.” ");
INSERT INTO lbb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pa e Pita i atai i mang, “Ur pak a warwara larlar ne tetek mila.” ");
INSERT INTO lbb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Pa e Iesu i kelesi mang, “I mangasa mulo otleng bel mulo talapor? ");
INSERT INTO lbb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","I mangasa bel mulo tasmani mang, a ututnala rop ning i kas ting na pahan tik, i kas ting na balana pa i apurum ulak seni? ");
INSERT INTO lbb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ika a warwarala rop ning i atongi ana pahana, i purum miting na nuknukna, i ning ir aduri. ");
INSERT INTO lbb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ine a ututnala ning i sira purum miting na nuknukna: a nuknuk laulau, umkol a mainla, a toltol laulau ana ta hane anuna tik o ta barsan anuna tik, na toltol a pamuk, a kinkinau, a artitiu asasongo, pa arle. ");
INSERT INTO lbb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A ututnala ne la adur a tarai. Ika ning la hangan pa bel la gos nigon pas a kunla, bel ir adur la na matana e God.” ");
INSERT INTO lbb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","E Iesu i han mitingia, pa i hanot milau a hanua Tair pa e Saidon. ");
INSERT INTO lbb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ning a hane Kenan miting na papar ning, i hanot pa i kabah e Iesu mang, “Leklek, a Nat e Dewit ur maris iau. A natuk hane, a mot kaning ono, pa i sira alaulau i.” ");
INSERT INTO lbb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ika e Iesu bel i kelesi. Anuna kakak a asaerla la han teteki, pa la atai rakrakai i mang, “Ur sune seni, anasa i woiwoi tumo lamur tandala.” ");
INSERT INTO lbb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","E Iesu i keles a hane mang, “E God i sune sen iau ute sur a tarai Israel ka, ning la rongo lar a sipsipla.” ");
INSERT INTO lbb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ika a hane ning i han tetek e Iesu, i kes ana bokona hana salanigo tana pa i atongi tana mang, “Leklek, ur nangan iau.” ");
INSERT INTO lbb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pa e Iesu i kelesi mang, “Bel i tostos sur dir los pas a utna na hangan ana kakakla, pa dir migeni tana papla.” ");
INSERT INTO lbb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A hane i kelesi mang, “Leklek, a momolna ot ning. Ika, a papla otleng la sira ien a mumut a utna na hangan ning i sira punga miting na logo na hangan anuna tamtamanla.” ");
INSERT INTO lbb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pa e Iesu i kelesi mang, “Lak, i itna kol anum a tortorot! A utna ning u mang suri, ar toli ot tetek u.” Pa ono otning, e natnalik i langolango. ");
INSERT INTO lbb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","E Iesu i han mitingia, pa i asal amon tumo na hang ting na puka tasi Galili. Lamur i han kas usaot na mangir pa i kes. ");
INSERT INTO lbb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pa tnan kunum a tarai la han teteki. La ben la ning na hanla i mat, pa na kut, na pio, na ngat, pa galis a tinsaman otleng teteki. Pa la aborbor tar la napirna, pa i alangolango pas la. ");
INSERT INTO lbb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A kunum a tarai la oroi na ngat la warwara, pa na pio la langolango, pa la ning a hanla i mat la han tostos, pa kutla otleng la tai. La kulkulan kol pa la rakan aleklek pas a God anuna tarai Israel. ");
INSERT INTO lbb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","E Iesu i kabah pas anuna kakak a asaerla teteki pa i atongi tanla mang, “A maris kol a taraila ne, anasa la ka kes taum hok te natol a pukakiar, pa bel al utna sur lar ieni. Bel a mang sur ar sune oros sen la taum ana munurak, sakana lar suah mat ting na ngas.” ");
INSERT INTO lbb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Anuna kakak a asaerla la atai i mang, “A hanua bel ka ine. Mitaha al utna na hangan sur dalar tabar a kunum a tarai ne ono?” ");
INSERT INTO lbb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","E Iesu i deken la mang, “Naisa na bret kaning mulo losi?” La kelesi mang, “A mais a bret pa siklik nanatar a sis.” ");
INSERT INTO lbb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pa i atai a kunum a tarai sur lar kes ting na piu. ");
INSERT INTO lbb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","I kibas pas mais a bret pa naisa na sis ning, i atong wakak pas onoi tetek e God, pa i kibiki pa i sarani tetek a kakak a asaerla sur lar tabar a taraila ono. ");
INSERT INTO lbb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A tarai rop la hangan pa la masur. Lamur a kakak a asaerla la song bukus pas mais a rat ana mah a utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A wawas ana tarai ka i arlar ana diat a rip, ika a gurarala pa kakakla otleng la hangan taum onla. ");
INSERT INTO lbb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lamur e Iesu i sune sen a kunum a tarai, i kas uting na mon, pa i han utumo na papar Magadan. ");
INSERT INTO lbb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A Parisaiola pa Sadusila la han tetek e Iesu pa la tohoi. I maining la nunungi sur ir tol ta akinalang na matanla, sur ir asangani mang i titol ana rakrakai e God. ");
INSERT INTO lbb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pa i keles la mang, “Ning ka rah, mulo sira atongi mang, ‘Latu bel ir kiar, anasa a bakut ka kubar rop.’ ");
INSERT INTO lbb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pa ana kobot mulo sira atongi otleng mang, ‘Onone ir kiar, anasa a bakut ka kubar, pa ka bagubagu rop.’ Mulo tastasman sur mulor pak a tatatai misaot na bakut, ika bel mulo tastasman sur mulor pak a kamkama akinalangla, ning ia ka tol tari ana pukakiarla ne. ");
INSERT INTO lbb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A tarai tagun anone, a laulau a tarai, anunla a lalaun i bakbak kusun e God. La mang sur lar oroi ta akinalang, ika bel dir tol tar tik tetek la. Dir tol ka a akinalang arlar larning di tol tari oe Jona.” Lamur e Iesu i han kusun la. ");
INSERT INTO lbb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","E Iesu taum ana anuna kakak a asaerla la han lakai a puka tasi, pa kakak a asaerla la dumani sur lar los al bret. ");
INSERT INTO lbb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","E Iesu i atai la mang, “Mulor tumarang ana is anuna Parisaiola pa Sadusila.” ");
INSERT INTO lbb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pa la warwara artalai tetek la ana kamkama warwara ane Iesu, pa la atongi mang, “I atongi larne anasa bel dala los al bret.” ");
INSERT INTO lbb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","E Iesu i tasman anunla na warwara pa i atai la mang, “I natarna kol anumulo a tortorot. Sur asaning mulo warwara artalai omulo ning bel al bret? ");
INSERT INTO lbb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","I mangasa, belot mulo tastasmai? Bel mulo nuk pas dilima na bret ning a kibiki tetek dilima na rip a barsan? Pa bel mulo nuk pas otleng naisa na rat ning mulo song bukus pasi? ");
INSERT INTO lbb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bel mulo nuk pas mais a bret ning a kibiki tetek diat a rip a tarai? Pa bel mulo nuk pas otleng naisa na rat ning mulo song bukus pasi? ");
INSERT INTO lbb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","I mangasa ning bel mulo tastasmai? Bel a warwara ana bret. Mulor tumarang mulo ana is anuna Parisaiola pa Sadusila.” ");
INSERT INTO lbb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pa la tasmani bot mang bel i sairas la kusun a is ning i kes ana bret, ika i atongi larne, sur lar tumarang la ana asaer anuna Parisaiola pa Sadusila. ");
INSERT INTO lbb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","E Iesu i hanot tumo milau a hanua Sisaria Pilipai. Pa i deken anuna kakak a asaerla mang, “A tarai la atong a Nat a Barsan o esi?” ");
INSERT INTO lbb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","La kelesi mang, “Dingla na tarai la atong u e Jon a Tena Baptais. Dingla la atong u, e Elaija, dingla la atong u, e Jeremaia, pa dingla otleng la atong u, ning a hal a propetla.” ");
INSERT INTO lbb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I deken la mang, “Pa mulo, mulo atong iau o esi?” ");
INSERT INTO lbb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pa e Saimon Pita i kelesi mang, “U a Karisito, a Nat e God ning i laun.” ");
INSERT INTO lbb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pa e Iesu i atongi tana mang, “Saimon, a nat e Jona, u ka angis, anasa bel tik i atai u ana warwara ning. E Tata ot ning i kes saot na langit i anuknuk tar u onoi. ");
INSERT INTO lbb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pa a atongi tam mang, u e Pita, a hat kes. Ar atur anuk a tarai a lotu ana hat ne. A rakrakai ana minat bel ir tolsot pas anuk a tarai a lotu. ");
INSERT INTO lbb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ar saran a kila tagun a matanitu misaot na langit tetek u, pa asaning u kubusi te na rakrakan hanua, dir kubusi otleng saot na langit, pa asaning u paki te na rakrakan hanua, dir paki otleng saot na langit.” ");
INSERT INTO lbb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pa e Iesu i sairas anuna kakak a asaerla mang gong la atai tar tik mang ai a Karisito. ");
INSERT INTO lbb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Turpasi ana pukakiar ning, e Iesu i atalapor anuna kakak a asaerla mang, ir han ot usaot e Jerusalem. Pa ir kilang a galis a mamahat miting na kun a ningnigola, a leklek a tena artabarla tetek e God, pa tena asaerla tagun a warkurai, pa dir umkoli. Pa ana natol a pukakiar lamur ir kamtur ulak. ");
INSERT INTO lbb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pa e Pita i ben masik pas e Iesu pa i warwara rakrakai tana mang, “Gong Leklek! Gong ot di tol tar a utna ne hom.” ");
INSERT INTO lbb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","E Iesu i talingir tetek e Pita pa i atongi tana mang, “Satan, ur han utumo lamur tak! U alar iau, anasa u mur ka a nuknuk a tarai, pa bel u mur a nuknuk e God.” ");
INSERT INTO lbb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pa e Iesu i atai anuna kakak a asaerla mang, “Ning tik i mang sur ir mur iau, gong i mur a nuknukna. Ir pamar anuna rakai kutus pa ir mur iau. ");
INSERT INTO lbb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Esining i mangan alar anuna lalaun, ir hirua, ika esining i noren sen anuna lalaun sur iau, ir laun. ");
INSERT INTO lbb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ning tik ir tong akes a ututnala rop mite na rakrakan hanua, pa anuna lalaun ir hirua, ir wakak mangmangasa teteki? Ir lou keles anuna lalaun ana sa? ");
INSERT INTO lbb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anasa a Nat a Barsan ir hanot taum ana matatar anun e Tamana, la taum ana nuna angelola, pa ir saran arlou tetek a tarai taktakai arlar ana nuna titol. ");
INSERT INTO lbb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A atong momoli tamulo, dingla omulo ning mulo tur te, belot mulor mat, pa mulo kar oroi a Nat a Barsan ir hanot taum ana nuna matanitu.” ");
INSERT INTO lbb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lamur tana diono na pukakiar, e Iesu i ben pas e Pita, Jems pa e Jon, a tas e Jems, pa i ben maskan pas ditol usaot na mangir ning i tur kas. ");
INSERT INTO lbb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tisaotia, ditol oroi a palaona e Iesu i ries. A patarna i sasai arlar ana kamis, pa nuna kaenla otleng i kokok kol arlar ana talapor. ");
INSERT INTO lbb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ono otning, ditol oroi pas e Moses pa e Elaija dia hanot pa ditol warwara taum oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","E Pita i atai e Iesu mang, “Leklek, i wakak ning dalar kes kama te. Ning u mang, ar tol ir natol a turturup, takai anumi, takai ane Moses, pa takai ane Elaija.” ");
INSERT INTO lbb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ning kaning ot i warwara, a laukap ning i talapor kol i poroi alar pas la. Pa elngen takai misaot na laukap, i atongi mang, “Ine a Natuklik, a katnan koli, a gas kol onoi. Mulor longor tana.” ");
INSERT INTO lbb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ning natol a kaklik a asaer ditol longori, ditol matmataut kol, pa ditol punga purum ana patarinditol ting na piu. ");
INSERT INTO lbb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ika e Iesu i han tetek ditol, pa i tong pas ditol pa i atongi mang, “Mutol kamtur, gong mutol matmataut.” ");
INSERT INTO lbb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ning ditol tadai, bel ditol oroi ulak tik, e Iesu kama kaning. ");
INSERT INTO lbb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ning la han purum amon misaot na mangir, e Iesu i sairas ditol mang, “Gong mutol atai tar tik ana saning mutol ka oroi tari, tuk ning a Nat a Barsan ir kamtur ulak kusun a minat.” ");
INSERT INTO lbb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pa natol a kaklik a asaer ditol dekeni mang, “Asa kamkamna ning a tena asaerla tagun a warkurai la atongi mang e Elaija ir hanot nigo?” ");
INSERT INTO lbb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","I keles ditol mang, “A momolna ot, e Elaija ir hanot pa ir atostos ulak a ututnala rop. ");
INSERT INTO lbb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ika onone ar atai mutol mang, e Elaija ka hanot pas, pa bel la tasman lalani, la tol a toltol laulaula onoi, arlar ot ana nuknukinla. Larka otleng ning lar akadik a Nat a Barsan.” ");
INSERT INTO lbb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pa natol a kaklik a asaer ditol tasmani bot mang, i warwara tetek ditol oe Jon a Tena Baptais. ");
INSERT INTO lbb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","E Iesu pa natol a kaklik a asaer la hanot tetek a kunum a tarai, pa ning a barsan i han tetek e Iesu, i kes ana bokona hana salanigo tana, ");
INSERT INTO lbb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","pa i atongi mang, “Leklek, ur maris a natuk barsan, i sira suah mat, pa i sira kibas hirua. A galis a pukakiar i sira punga ting na iah pa ting na malum. ");
INSERT INTO lbb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ia ka ben tari kaba tetek anum na kakak a asaerla, ika bel la tolsot sur lar alangolango i.” ");
INSERT INTO lbb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","E Iesu i kelesi mang, “Mulo na tarai tagun onone, bel mulo tortorot pa mulo na tena laulau. Ia ka kes bongnan iau te napirimulo. Nangse mulor tortorot? Mulor ben a kaklik ning ute tetek iau.” ");
INSERT INTO lbb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","E Iesu i warwara rakrakai tetek a mot, pa i purum kusun a kaklik. Pa ono otning i langolango. ");
INSERT INTO lbb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Lamur a kakak a asaerla la han tetek e Iesu, pa la deken kumnani mang, “Asa kamkamna ning bel mila tolsot sur milar kepsen a mot kusuni?” ");
INSERT INTO lbb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Pa i keles la mang, “Anasa anumulo a tortorot i natarna kol. A atong momoli tamulo, ning anumulo a tortorot i natarna arlar ana pata mastad, mulor tolsot pasi sur mulor atongi tana mangir ne mang, ‘Ur susur mite utumo,’ pa ir susur ka. Bel ta utna ir ngangaten tetek mulo.” ");
INSERT INTO lbb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ning e Iesu pa anuna kakak a asaerla la han taum tumo na papar Galili, i atai la mang, “Dir saran tar a Nat a Barsan uting na kuna taraila ");
INSERT INTO lbb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","pa lar umkoli. Ana natol a pukakiar lamur e God ir akamtur ulaki.” Ning a kakak a asaerla la longori, la balmaris kol ono. ");
INSERT INTO lbb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","E Iesu pa anuna kakak a asaerla la hanot tumo e Kapernaum, pa la ning la sira los totokom ana rumai artabar, la han tetek e Pita pa la dekeni mang, “Anumulo a tena asaer i sira saran a totokom ana rumai artabar o bel?” ");
INSERT INTO lbb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pa i kelesi mang, “Ma.” Ning e Pita i kas ting na rumai, e Iesu i warwara nigo, pa i dekeni mang, “Saimon, asa u nuki? A kingla mite lapiu la sira los a totokom pa arlou ta esi? Tan a natnatunla o tana tarai masik?” ");
INSERT INTO lbb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pa i kelesi mang, “Tan a tarai masik.” E Iesu i atai i mang, “Manglarning, na natnatunla, la langolango, bel lar lou a totokom. ");
INSERT INTO lbb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ika, gong da akutkut balanla, ur han usa latasi pa ur boko. A ningnigo na sis ning ur dati, ur sapang a pahana, pa ur pastek a mani. Ur los pasi pa ur los tari tetek la sur a totokom anundau rop.” ");
INSERT INTO lbb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ana taim ning, a kakak a asaerla la han tetek e Iesu, pa la dekeni mang, “Esining i leklek kol ana matanitu misaot na langit?” ");
INSERT INTO lbb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","I kabah pas ning a kaklik teteki, i atur potor tari tanla, ");
INSERT INTO lbb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","pa i atongi mang, “A atong momoli tamulo, ning bel mulor lingir a nuknukimulo sur mulor arlar ana kakakla, bel mulor tolsot pasi sur mulor kas ana matanitu misaot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Esining i anatarna pasi, arlar ana kaklik ne, i leklek kol ana matanitu misaot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Esining ir gas pas ta kaklik larne ana risak, i gas pas iau. ");
INSERT INTO lbb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ika, ning tik ir ben rongon ta halin a kakakla ne, ning i tortorot hok, ir laulau kol a warkurai teteki tan tik ning dir dot tar ta tnan hat ting na ruana, pa dir migen murungi sa na laman. ");
INSERT INTO lbb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ir laulau tetek a tarai mite na rakrakan hanua, anasa ana ututnala ning i dat a tarai sur lar punga ana laulau. A ututnala ning ir hanot ot, ika ir laulau kol tetek esining i tol otnan pasi. ");
INSERT INTO lbb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ning a kum, o a ham ir ben rongon u, ur kutus seni pa ur migen seni. Ir wakak ning ur kas uting na lalaun tikin a takumut ka, sur gong di migen u taum ana naur a kum, pa naur a ham, uting na tnan iah ning bel i sira rop. ");
INSERT INTO lbb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ning a matam ir ben rongon u, ur liok seni pa ur migen seni. Ir wakak ning ur kas ana lalaun tikin ana takai a matam ka, sakana dir migen u taum ana naur a matam rop uting na tnan iah ning bel i sira mat. ");
INSERT INTO lbb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Gong mulo oroi purpurum pas ta halin na kakakla ne. A atai mulo, anunla na angelola saot na langit la sira oroi a patar e Tata ning i kes saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Asa a nuknukimulo? Ning ta barsan anuna ta mar a sipsip, pa ta halinla i rongo, i mangasa, bel ir han kusun a siuk a bonot pa pisir siuk tingia na mangirla, pa ir tai sur takai ning i rongo? ");
INSERT INTO lbb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A atong momoli tamulo, ning kar pastek pasi, a gasgas anunai ono, ir itna tana gasgas anunai ana siuk a bonot pa pisir siuk ning bel la rongo. ");
INSERT INTO lbb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Larka otleng ning, a Tamamulo ning i kes saot na langit, bel i mang sur ta halin a kakakla ne ir hirua. ");
INSERT INTO lbb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ning e tasimlik i tol a toltol laulau tetek u, ur han teteki, pa mu ka mur kes. Pa ur apuasa anuna rongo teteki. Ning ir longor u, u ka amoro ulak pasi. ");
INSERT INTO lbb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ning bel ir longor u, ur ben ulak pas tik o ir naur sur diar nangan u. Anasa a Buk Tabu i atongi larne, ‘Ning ir naur o ir natol, anunditol a warwara na artitiu i takai ka, anunditol a warwara i momol.’ ");
INSERT INTO lbb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ning bel ir longor diau, ur apuasa i tetek a tarai a lotu. Ning bel ir longor otleng a tarai a lotu, i wakak sur ur oroi i arlar o esaning bel a tena tortorot, o arlar ana tena los totokom. ");
INSERT INTO lbb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“A atong momoli tamulo, asaning mulo kubusi te na rakrakan hanua, dir kubusi otleng saot na langit, pa asaning mulo paki te na rakrakan hanua, dir paki otleng saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A atongi otleng tamulo, ning ir naur omulo te na rakrakan hanua dia malmaling ana ta utna ning dia nunung suri, e Tata ning i kes saot na langit ir tolsoti ot tetek diau. ");
INSERT INTO lbb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ning ir naur o ir natol ditol kes taum ana risak, iau ar kes taum onditol.” ");
INSERT INTO lbb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","E Pita i han tetek e Iesu, pa i dekeni mang, “Leklek, ar munaisa na nuk duman sen a toltol laulau ning a tasiklik i toli tetek iau? Mais a taim?” ");
INSERT INTO lbb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","E Iesu i kelesi mang, “Bel a atongi tam mang mais a taim ka. A atongi mang mais a bonot pa pisir mais a taim. ");
INSERT INTO lbb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Oroi i, a matanitu misaot na langit i arlar ana king, ning i mang sur anuna tena titol orosla lar atostos a mani ning la dinau pasi tana. ");
INSERT INTO lbb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ning i turpas a deke, di ben otnan takai a tena titol oros teteki. A tena titol ning i dinau pas ning a bonot a rip a mani, ");
INSERT INTO lbb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ika bel ta mani sur ir kelesi ono. Pa anuna leklek i arsune sur dir siuran a barsan ning, taum oe nuna hane, pa na natnatna, pa nuna ututnala rop, sur dir keles a mani ning ono. ");
INSERT INTO lbb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pa tena titol ning, i kes ana bokona hana na matan anuna leklek, pa ka nunungi mang, ‘Ur noren sen iau kaba, lamur ar keles rop anum na mani.’ ");
INSERT INTO lbb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pa leklek anuna tena titol ning i marisi, pa ka atai i mang, ‘Ur han. Gong kama u kelesi.’ ");
INSERT INTO lbb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ning a tena titol oros i purum utumo lapiu, i han barat a tena titol oros, ning nating i dinau pas ka ning a bonot a mani tana. I tong akes pasi, i bing a pogolna, pa ka atai i mang, ‘Ur keles anuk a mani ning u dinau pasi.’ ");
INSERT INTO lbb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A halna ning i kes ana bokona hana na matana pa ka nunungi mang, ‘Ur noren sen iau kaba, lamur ar keles anum a mani.’ ");
INSERT INTO lbb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ika bel i longor pasi. I beni pa i akas tari ting na karabus, tuk ning ir keles a mani ning i dinau pasi. ");
INSERT INTO lbb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dingla na tena titol oros la oroi a toltol ning, pa la kilang laulaui. La han tetek anunla a leklek, pa la atai i ana ututnala ning a tena titol oros ka tol tari. ");
INSERT INTO lbb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Anuna leklek i kabah pasi, pa ka atai i mang, ‘U a laulau a tena titol oros. A noren sen u sur gong ma u keles a mani ning u dinau pasi tak, anasa u nunung iau. ");
INSERT INTO lbb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","I mangasa ning bel u maris a halim arlar hok ning a maris u?’ ");
INSERT INTO lbb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Anuna leklek i balakut teteki, pa i saran tari tetek na tena tai alar ting na karabus sur lar akadik laulau i tuk ning ir keles a manila rop ning i dinau pasi. ");
INSERT INTO lbb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“E Tata ning i kes saot na langit ir toli otleng larning tetek mulo taktakai, ning bel mulo nuk duman momol sen a toltol laulau ning na tastasimulo la tol tari tetek mulo.” ");
INSERT INTO lbb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ning e Iesu ka atong rop tar a warwarala ne, i han mitumo e Galili, utumo na papar Judia, ting na ning a ris a malum Jodan. ");
INSERT INTO lbb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pa tnan kunum a tarai la muri, pa i alangolango pas na tinsamanla tingia. ");
INSERT INTO lbb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dingla na Parisaio la han teteki sur lar tohoi. La dekeni mang, “I tostos arlar ana nundala na Warkurai, sur a barsan ir kepsen anuna hane na palai ta utna oros ka, o bel?” ");
INSERT INTO lbb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I keles la mang, “I mangasa, belot mulo was a warwara ting na Buk Tabu? I atongi larne: Ana kamkam a akakes, a Tena Akakes ‘i akes a tarai, sur lar barsan pa lar hane,’ ");
INSERT INTO lbb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","pa i atongi mang, ‘Ine a kamna ning a barsan ir han kusun e tamana pa e tana, pa ir kes taum oe nuna hane, pa diar hanot takai ka ana palaondiau.’ ");
INSERT INTO lbb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pa bel ma dia areur, dia takai ka. Asaning e God ka dot taum tari, gong ulak ma tik i kutusi.” ");
INSERT INTO lbb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","La deken ulaki mang, “Sur asaning e Moses i saran a warkurai sur a barsan ir tumus a paka buk na kutus tinaulai pa ir sarani tetek anuna hane, pa ir kepseni?” ");
INSERT INTO lbb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","I keles la mang, “E Moses i malmaling sen mulo sur mulor kepsen anumulo a gurarala, anasa a balamulo i rakrakai kol. Ika ana kamkama akakes bel i manglarne. ");
INSERT INTO lbb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A atongi tamulo, ning tik ir kepsen anuna hane ning bel i tol ta toltol laulau taum ana ta barsan masik, pa barsan ning ir taulai ulak ta hane, a barsan ning ka tol a toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pa anuna kakak a asaerla la atongi tana mang, “Ning i manglarning tetek ta barsan pa anuna hane, i wakak sur gong tik i taulai.” ");
INSERT INTO lbb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","I keles la mang, “Bel a tarai rop lar tolsoti sur lar kibas a warwara ne. La ka ning e God ka saran tar a rakrakai tanla. ");
INSERT INTO lbb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Urmatana kamkamna ning a tarai bel lar taulai. Dingla na tarai di agon la larotning. Dingla na tarai, a tarai la alaulau la, pa dingla na tarai otleng, bel lar taulai anasa la molot ana titol ana matanitu misaot na langit. Esining i tolsoti, ir mur a warwara ne.” ");
INSERT INTO lbb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Di ben a kakakla tetek e Iesu sur ir suah naur a kuna saot onla pa ir araring onla. Ika anuna kakak a asaerla la sairas la. ");
INSERT INTO lbb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","E Iesu i atongi mang, “Mulor noren sen a kakakla sur lar han tetek iau. Gong mulo sairas la, anasa a matanitu misaot na langit anunla ning la manglarne.” ");
INSERT INTO lbb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ning ka suah tar naur a kuna saot onla, i han mitingia. ");
INSERT INTO lbb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ning a barman i han tetek e Iesu, pa i dekeni mang, “Tena Asaer, esi na wakak a utna ning ar toli sur ar kibas a lalaun tikin?” ");
INSERT INTO lbb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","E Iesu i kelesi mang, “Asa kamkamna ning u deken iau ana saning i wakak? Takai sot ka i wakak. Ning u mang sur ur kibas a lalaun tikin, ur longor ana warkuraila.” ");
INSERT INTO lbb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pa i dekeni mang, “Esi na warkuraila?” E Iesu i kelesi mang, “‘Gong u umkol tik, gong u tol a toltol laulau ana ta hane anuna tik o ta barsan anuna tik, gong u kinkinau, gong u artitiu asasongo, ");
INSERT INTO lbb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ur hanrawai e tamam pa e tnam,’ pa ‘ur mang sur a halim larning u mang sur u ot.’” ");
INSERT INTO lbb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A barman ning i atai i mang, “A warkuraila rop ning ia ka mur sot pasi. Asa ulak ma ar toli?” ");
INSERT INTO lbb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","E Iesu i kelesi mang, “Ning u mang sur ur tostos momol, ur han pa ur siuran sen anum a gongonla rop, pa mani onoi, ur tabar a kapan a tarai ono. Ning ur toli larne, anum a wakak a gongon kanisaot na langit. Lamur ur han ute pa ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ning a barman i longor a warwara ne, i han taum ana balmaris, anasa anuna gongon i galis kol. ");
INSERT INTO lbb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pa e Iesu i atongi tan anuna kakak a asaerla mang, “A atong momoli tamulo, i ngangaten kol tetek a tena gongon sur ir kas ting na matanitu misaot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A atongi otleng tamulo mang, ir ngangaten sur a kamel ir kas ting na mosol a sur a susuk, ika, i ngangaten kol sur a tena gongon ir kas ting na matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ning anuna kakak a asaerla la longori, la kulkulan kol pa la atongi mang, “Manglarning, esi ma ning dir alauni?” ");
INSERT INTO lbb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","E Iesu i tai tetek la pa i atongi mang, “A tarai bel lar tolsot pasi, ika e God ir tolsot pas a ututnala rop.” ");
INSERT INTO lbb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","E Pita i kelesi mang, “Oroi, mila ka han kusun anumila na ututnala rop, pa mila mur u. Asaning milar kibasi lamur?” ");
INSERT INTO lbb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","E Iesu i atongi tanla mang, “A atong momoli tamulo, ning dir atona a ututnala rop, a Nat a Barsan ir kes na king ana nuna keskes a matatar. Pa mulo ning mulo ka mur iau, mulor kes ana ning a bonot pa pisir naur a keskes a king, pa mulor warkurai ning a bonot pa pisir naur a mangis a tarai Israel. ");
INSERT INTO lbb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pa la rop ning la ka han kusun anunla na rumai, o kusun a tastasinla taraila pa gurarala, o kusun na tamtamanla, o na kabatnanla, o na natnatunla, o kusun anunla na piu, anasa la anuki, dir saran a marmar a utna larne tanla, pa lar kibas otleng a lalaun tikin. ");
INSERT INTO lbb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ika a galis ning onone la nigo, lar mur, pa la ning onone la mur, lar nigo.” ");
INSERT INTO lbb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“A matanitu misaot na langit i arlar ana taman a barim a wain, i purum ana kobot ning ot sur ir deke sur al tena titol sur lar titol ting na nuna barim a wain. ");
INSERT INTO lbb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","La kubus warwara taum pas ana tena titolla sur lar kibas arlou tagun takai a pukakiar a titol, pa i sune la uting na nuna barim a wain. ");
INSERT INTO lbb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ana 9 kilok i han ulak pa i oroi pas dingla na tarai maleng la tur ororos ka ting na pukna na tinan taum. ");
INSERT INTO lbb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pa i atai la mang, ‘Mulo otleng, mulor han, pa mulor titol ting na nuk a barim a wain, par tokom mulo ana saning i tostos.’ ");
INSERT INTO lbb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pa la han. “Ana tnan kamis i han pa i deke ulak sur al tena titol, pa ana 3 kilok ana rah i han ulak sur al tarai. ");
INSERT INTO lbb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ana 5 kilok ana rah i han ulak, pa i oroi pas dingla na tarai maleng la tur ororos ka. Pa i atai la mang, ‘Sur asaning mulo tur ororos ka a kidol a pukakiar ne?’ ");
INSERT INTO lbb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","La kelesi mang, ‘Bel tik i ben mila sur ta titol.’ I atai la mang, ‘Mulo otleng mulor han pa mulor titol ting na nuk a barim a wain.’ ");
INSERT INTO lbb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ning ka rah morom, a taman a barim a wain, i atongi tana ningnigo tagun anuna tena titolla mang, ‘Kabah pas a tena titolla ute, pa ur tokom la. Ur turpasi sur tokom nigon la ning la hanot murmur pa ir han tuk onla ning la hanot nigo.’ ");
INSERT INTO lbb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Na tena titol ning di ben pas la ana 5 kilok ana rah la hanot, pa di tokom la taktakai ana arlou tagun takai a pukakiar a titol. ");
INSERT INTO lbb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","La ning di ben nigon pas la, la hanot. La nuki mang lar kibas a tnan arlou. Ika, bel! La otleng di tokom la taktakai ana arlou tagun takai a pukakiar a titol ka. ");
INSERT INTO lbb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ning la ka lolos pas, la ururai tetek a taman a barim a wain, ");
INSERT INTO lbb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","la atongi mang, ‘La ning la hanot murmur bel la titol bongnan la, ika mila, mila tol a rakrakai a titol pa kamis i rang mila, pa u tokom la otleng arlar omila.’ ");
INSERT INTO lbb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pa i keles ning a halinla mang, ‘Halik, bel a alaulau u. I mangasa, bel da kubus warwara pas sur a arlou tagun takai a pukakiar a titol? ");
INSERT INTO lbb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ur kibas pas anum a mani, pa ur han. A mang sur ar tokom la ning la hanot murmur arlar hom ning u nigo. ");
INSERT INTO lbb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","I mangasa, bel i sot sur ar tol asaning a mang suri ana nuk a mani? I mangasa, u nuknuk laulau hok, anasa a asangan a wakak a toltol tetek a tarai ne?’ ");
INSERT INTO lbb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Larne, la ning onone la mur, lar nigo, pa la ning onone la nigo, lar mur.” ");
INSERT INTO lbb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ning e Iesu i han amon usaot e Jerusalem, i ben maskan pas anuna ning a bonot pa pisir naur a kakak a asaer, pa i atai la mang, ");
INSERT INTO lbb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Oroi, onone dala han amon usaot e Jerusalem. Dir saran tar a Nat a Barsan tetek a leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai. Lar warkurai i sur ir hirua, ");
INSERT INTO lbb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","pa lar saran tari tetek la, ning bel a tarai Juda sur lar morot laulau ono, lar mirasi, pa lar sai ahati saot na rakai kutus. Ana natol a pukakiar lamur ir kamtur ulak.” ");
INSERT INTO lbb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Lamur e kabatnan naur a nat e Sebedi i han tetek e Iesu taum ana naur a natnalik. I kes ana bokona hana na matana pa i nunungi sur ta utna. ");
INSERT INTO lbb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pa e Iesu i dekeni mang, “Asaning u mang suri?” Pa i kelesi mang, “Ur malmaling sur naur a natuklik ne, diar kes taum hom ting na num a matanitu, takai ting na sot a kum, pa takai ting na kair.” ");
INSERT INTO lbb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","E Iesu i kelesi mang, “Bel mutol tasman asaning mutol nunung suri. I mangasa, mu tolsot sur mur gang ana kap a mamahat ning ar gang ono?” Dia kelesi mang, “Miar tolsot pasi ka.” ");
INSERT INTO lbb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I atai diau mang, “A momolna ot, a kap a mamahat ning ar gang ono, mu otleng mur gang ono. Ika ana keskes ting na sot a kuk pa kair, bel anuk a titol sur ar sarani. E Tata ir sarani tetek la ning ka sang tari sur la.” ");
INSERT INTO lbb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ning a bonot a kakak a asaer la longori, la balakut tetek ditas ning. ");
INSERT INTO lbb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","E Iesu i kabah taum pas la, pa i atongi mang, “Mulo tasmani mang a tena warkuraila anuna tarai ning bel a tarai Juda, la warkurai a tarai pa la oroi purpurum la. Pa anunla na ningnigo la saran a rakrakai a warkuraila tetek anunla na tarai. ");
INSERT INTO lbb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ika tetek mulo bel ir manglarne. Esining i mang sur ir leklek tamulo, ir anatarna pasi sur ir tena titol anumulo. ");
INSERT INTO lbb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pa esining i mang sur ir ningnigo tamulo, ir tena titol oros anumulo. ");
INSERT INTO lbb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Larka otleng ning a Nat a Barsan bel i hanot sur dir titol teteki. I hanot sur i ot ir titol tetek a tarai, pa ir saran tar anuna lalaun, a arlou, sur ir lou langolango pas a galis a tarai.” ");
INSERT INTO lbb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ning e Iesu pa nuna kakak a asaerla la han mitumo e Jeriko, a tnan kunum a tarai la mur la. ");
INSERT INTO lbb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Naur a barsan naur a kut dia kes tar ting na ris a ngas. Ning dia longori mang e Iesu ka han milau, dia arkabah rakrakai mang, “Leklek, Nat e Dewit, ur maris miau.” ");
INSERT INTO lbb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pa kunum a tarai la sairas diau sur diar kes wowowon. Ika dia arkabah rakrakai kol mang, “Leklek, Nat e Dewit, ur maris miau.” ");
INSERT INTO lbb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","E Iesu i tur suai, pa i kabah pas diau, pa i deken diau mang, “Asaning mu mang sur ar toli omu?” ");
INSERT INTO lbb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dia kelesi mang, “Leklek, mia mang sur miar tai.” ");
INSERT INTO lbb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E Iesu i maris kol diau, pa i tong naur a matandiau. Ono otning dia ka tai, pa dia muri. ");
INSERT INTO lbb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ning la han milau e Jerusalem, pa la hanot ting e Betpage ting na Mangir Oliw, e Iesu i sune naur a kaklik a asaer. ");
INSERT INTO lbb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","I atai diau mang, “Mur han uting na hanua kaning lanigo tamu. Ning mur hanot, mur han tar ana ning a dongki kaning di dot akes tari, taum ana natnalik. Mur pak sen diau, pa mur ben diau ute tetek iau. ");
INSERT INTO lbb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ning tik ir deken mu, mur atongi mang, ‘A Leklek i mang sur diau,’ pa ono otning ir noren sen diau tetek mu.” ");
INSERT INTO lbb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Di tol a utna ne sur dir tolsot pas a warwara ane God ning a propet ka atong tari nating mang, ");
INSERT INTO lbb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mulor atai a tarai Saion mang, ‘Oroi, anumulo a king anone i hanot tetek mulo, i anatarna pasi, pa i kas ana dongki, a barman a dongki.’” ");
INSERT INTO lbb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Naur a kaklik a asaer dia han, pa dia toli arlar ana warwara ning e Iesu ka atong tari tandiau. ");
INSERT INTO lbb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dia ben pas a dongki taum ana natnalik, dia kepsen anundiau naur a saket, pa dia suahi saot na palai naur a dongki, pa e Iesu i kes saot ondiau. ");
INSERT INTO lbb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A tnan kunum a tarai otleng la sagen anunla na saket ting na ngas. Pa dingla na tarai otleng la ting pas a rakarakaila pa la suahi ting na ngas. ");
INSERT INTO lbb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A kunum a tarai ning la nigo tana, pa la ning la mur, la kukuk mang, “Hosana tetek a Nat e Dewit! Esaning i hanot ana risan a Leklek i angis.” “Hosana saot kol!” ");
INSERT INTO lbb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ning e Iesu i hanot saot e Jerusalem, a tarai Jerusalem rop la aregaia pa la deke mang, “Esi ning?” ");
INSERT INTO lbb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pa kunum a tarai ning la han taum onoi la atongi mang, “A barsan ne e Iesu, a propet mitumo e Nasaret ana papar Galili.” ");
INSERT INTO lbb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","E Iesu i kas uting na woroh na rumai artabar, pa i lu purum sen la rop ning la sisiurai, pa la otleng ning la lolou tingia. I migen lingir a logola anuna tena keles manila, pa keskesla anun la ning la siuran a tabunla. ");
INSERT INTO lbb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pa i atai la mang, “Di ka tumus tari ting na Buk Tabu mang, ‘Dir atong anuk a rumai ana rumai a niaring.’ Ika mulo ka tol lingir pasi sur ir arlar ana ‘pukna na mumun ana tena kinkinaula.’” ");
INSERT INTO lbb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A kutla pa la ning a hanla i mat la han teteki ting na rumai artabar pa i alangolango pas la. ");
INSERT INTO lbb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ika, ning a leklek na tena artabarla tetek e God pa na tena asaer tagun a warkurai la oroi a wakak a ututnala kol ning i toli, pa la longori otleng a kakakla la kukukuk ting na woroh a rumai artabar mang, “Hosana tetek a Nat e Dewit,” la balakut kol. ");
INSERT INTO lbb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Pa la deken e Iesu mang, “U ka longor tar a warwarala ne anuna kakakla?” E Iesu i keles la mang, “Ma! I mangasa, belot mulo was a warwara miting na Buk Tabu? I atongi mang, ‘U ka asaer tar a kakakla sur lar rakan aleklek pas u.’” ");
INSERT INTO lbb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pa i han kusun la tingia, pa i han utumo e Betani pa i borbor pas ning a puka morom tumo. ");
INSERT INTO lbb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ana kobot ning ot, ning e Iesu i ulak usaot e Jerusalem i murak. ");
INSERT INTO lbb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I oroi pas a rakai a fig i tur tar ting na ris a ngas. I han milau i, ika bel i oroi al wana, a pakanala ka. Pa i atongi tana rakai ning mang, “Turpasi onone pa lamur, bel ulak ma ur wai.” Ono otning, a rakai i marang. ");
INSERT INTO lbb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ning a kakak a asaerla la oroi i, la kulkulan, pa la dekeni mang, “A rakai a fig ne, i marang kapit mangasa?” ");
INSERT INTO lbb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","E Iesu i keles la mang, “A atong momoli tamulo, ning mulo tortorot, pa bel mulor urmatana nuknuk, mulor tol a titol ne a toli ana rakai a fig. Bel i ka ine ning mulor toli. Ning mulor atongi otleng tetek a mangir ne mang, ‘Ur takakan pa ur sirok parung usa latasi,’ ir toli ka. ");
INSERT INTO lbb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ning mulo tortorot, a ututnala rop ning mulo nunung suri, mulor kibasi.” ");
INSERT INTO lbb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E Iesu i kas uting na woroh na rumai artabar, pa i asaer a tarai. A leklek a tena artabarla tetek e God pa ningnigola anuna tarai la han teteki. Pa la dekeni mang, “Esi na ngas a rakrakai ning u tol a ututnala ne ono? Esi i saran a rakrakai ne tam?” ");
INSERT INTO lbb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pa e Iesu i keles la mang, “Iau otleng ar deken mulo ana ning a kabah. Ning mulor kelesi, ar atai mulo ana rakrakai ning a sira tol a ututnala ne ono. ");
INSERT INTO lbb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mitaha a rakrakai ning e Jon i baptais a tarai ono? Misaot na langit, o tana tarai ka?” Pa la warwara artalai tanla mang, “Ning dalar atongi mang, ‘Misaot na langit,’ ir keles dala ka mang, ‘Sur asaning bel mulo tortorot onoi?’ ");
INSERT INTO lbb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ika ning dalar atongi mang, ‘Tan a tarai,’ dalar matatan a tarai, sakana lar balakut dala, anasa la rop la tortorot oe Jon mang, i a propet.” ");
INSERT INTO lbb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pa la keles e Iesu mang, “Bel mila tasmani.” Lamur e Iesu i atai la mang, “Iau otleng, bel ar atai mulo ana rakrakai ning a sira tol a ututnala ne ono.” ");
INSERT INTO lbb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","E Iesu i atai la mang, “Asa mulo nuki? Ning a barsan naur a natnalik, naur a kaklik barsan. I han tetek a ningnigona, pa i atai i mang, ‘Natuklik, anone ur han uting na barim a wain pa ur titol.’ ");
INSERT INTO lbb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pa i kelesi mang, ‘Bel ar han,’ ika lamur i lingir a nuknukna, pa i han. ");
INSERT INTO lbb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pa e tamana i han maleng tetek ning a halindiau, pa i atai i otleng larning, pa e natnalik i kelesi mang, ‘I wakak ka tata, ar han ot,’ ika bel i han. ");
INSERT INTO lbb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Esi na halindiau ning i longor ta e tamandiau?” La kelesi mang, “A ningnigona.” E Iesu i atai la mang, “A atong momoli tamulo, na tena los totokom pa pamuk a gurarala, kaning la kas ting na matanitu ane God lanigo tamulo. ");
INSERT INTO lbb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Anasa e Jon i hanot pa i asaer mulo ana tostos a toltol, pa bel mulo tortorot ono, ika na tena los totokom pa na pamuk a gurara la tortorot ono. Mulo oroi tar la ot, ika bel mulo lingir a nuknukimulo pa bel mulo tortorot onoi.” ");
INSERT INTO lbb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Mulor longor ning a warwara larlar maleng ne: Ning a barsan i oman tar a barim a wain, pa i tol alar tari ana woroh. Ting na barim a wain, i kel tar a tung sur dir pas miren a wana wain tingia, sur a polona ir hanot. Pa i tol tar a natar a rumai i tur kas sur ana tena tai alar. Lamur i saran tar kaba a barim ning tana dingla na tena titol sur lar tai alari, pa i han uting na ning a hanua masik. ");
INSERT INTO lbb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ning ka milau a kalang sur dir git taum a wana wain, i sune sen anuna tena titol orosla tetek a tena titolla, sur lar los pas anuna al wana wain. ");
INSERT INTO lbb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","A tena titolla ning, la tong akes pas anuna tena titol orosla. La um ning na halinla, takai la umkoli pa takai otleng la wolot koli ana hatatla. ");
INSERT INTO lbb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","I sune ulak dingla na tena titol oros, la galis tanla ning i sune nigon tar la. Ika a tena titolla la tol ulaki ka larning tetek la. ");
INSERT INTO lbb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lamur i sune e natnalik tetek la. I atongi mang, ‘Lar hanrawai a natuklik.’ ");
INSERT INTO lbb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ika, ning a tena titolla la oroi pas e natnalik la warwara artalai tanla mang, ‘Esaning ir keles e tamana, i ma ine ot. Mulo lamut, dalar umkoli, sur anundalai ma a barim a wain.’ ");
INSERT INTO lbb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pa la tong akes pasi, la migen purum seni kusun a barim, pa la umkoli.” ");
INSERT INTO lbb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ning a taman a barim ir hanot, asaning ir toli tetek a tena titolla?” ");
INSERT INTO lbb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","La kelesi mang, “Ir umkol arop sen a laulau a tarai ning, pa ir saran tar anuna barim a wain tetek al tena titol masik, sur lar tai alari. A tena titolla ning, lar bot saran tar anuna al wana wain ana kalang a sol.” ");
INSERT INTO lbb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","E Iesu i atai la mang, “I mangasa, belot mulo was a warwara ne ting na Buk Tabu? I atongi mang, ‘A hat ning na tena tol rumai la kepseni, i ot ning, a wakak a hat kes, ning di tol a rumai saot ono. A utna ne, a Leklek ot ka tol tari, pa i wakak kol ana numila a tatatai.’ ");
INSERT INTO lbb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","I maining a atongi tamulo mang, dir rakan sen a matanitu ane God kusun mulo, pa dir saran tari tan al tarai ning lar suah a wakak a wanala ning i sot.” ");
INSERT INTO lbb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Esining ir punga tar ana hat ne, ir tagingini, ika esining a hat ne ir punga tar ono, ir tamire arlar ana kubus. ");
INSERT INTO lbb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ning a leklek a tena artabarla tetek e God pa Parisaiola la longor a warwara larlarla ane Iesu, la tasmani ot mang i warwara ka onla. ");
INSERT INTO lbb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pa la tai sur ta ngas sur lar tong akes pasi, ika la matatan a kunum a tarai, anasa a tarai la tortorot onoi mang i a propet. ");
INSERT INTO lbb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","E Iesu i warwara ulak tetek la ana warwara larlar mang, ");
INSERT INTO lbb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A matanitu misaot na langit i arlar ana king ning i sang tar a ngasa na tinaulai sur e natna barsan. ");
INSERT INTO lbb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pa i sune anuna tena titol orosla tetek la, ning di ka atai nigon tar la, sur lar ben pas la sur a ngasa. Ika la rop la ngongoio ka. ");
INSERT INTO lbb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","I sune maleng anuna dingla na tena titol oros ana warwara mang, ‘Mulor atai la ning di ka atai nigon tar la mang, “Ia ka sang rop tar a utna na hangan. Ia ka umkol tar na barsan a bulumakau pa na butbut a bulumakau, a ututnala rop ka sang. Mulor han ute na ngasa na tinaulai.” ’ ");
INSERT INTO lbb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ika bel la longor, la han masik ka. Takai i han uting na nuna barim, takai otleng uting na nuna rumai a sisiurai. ");
INSERT INTO lbb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pa dingla na tarai otleng ning di han sur la, la tong akes pas na tena titol oros ning, pa la alaulau la pa la umkol la. ");
INSERT INTO lbb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A king ning, a balana i kut kol, i sune sen anuna tarai a harum, pa la umkol sen na tena umumkol a taraila ning, pa la tun sen anunla a hanua. ");
INSERT INTO lbb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“I atongi tana anuna tena titol orosla mang, ‘Di ka sang tar a ngasa na tinaulai, ika la ning ia ka atai nigon tar la, bel la tostos sur lar kes ana ngasa. ");
INSERT INTO lbb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mulo han ana ngasla, pa esining mulor pasteki, mulor atai i mang ir han ute sur a ngasa.’ ");
INSERT INTO lbb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pa na tena titol oros la han uting na ngasla, pa la ben taum la rop ning la pastek la, na laulau a tarai pa wakak a taraila otleng, pa ngasa na tinaulai i bukus ana wasirala. ");
INSERT INTO lbb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ika ning a king i kas sur ir oroi a tarai, i oroi tetek pas ning a barsan ning bel i mermer ana ta kaen a ngasa na tinaulai. ");
INSERT INTO lbb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pa i dekeni mang, ‘Lak, u kas mangmangasa tar ute? Bel anum ta kaen a ngasa na tinaulai.’ A barsan ning bel i kelesi. ");
INSERT INTO lbb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lamur a king i atai anuna tena titolla mang, ‘Mulor dot pas naur a hana pa naur a kuna pa mulor migen purum seni utumo lapiu na mormorom. Di tangtangis pa di arngingit ngesendi tingia.’ ");
INSERT INTO lbb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Di ka kabah pas a galis, ika di aslang pas siklik tarai kama.” ");
INSERT INTO lbb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lamur a Parisaiola la han taum tar, pa la warwara taum pas mang lar toho e Iesu sur ta warwara anunai, ning lar tiwi ono. ");
INSERT INTO lbb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","La sune sen anunla na kakak a asaerla pa halalna e Herot tetek e Iesu, pa la atongi mang, “Tena Asaer, mila tasmani mang u a tostos a barsan, pa u asaer a tarai ana ngas ane God ana momol. Bel u nuknuk kol ana saning a tarai la atongi hom, anasa a ginim i arlar ka tetek a tarai rop. ");
INSERT INTO lbb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ur atai mila, asa a nuknukim? I mangasa, i tostos sur dir lou a totokom tetek a Sisar o bel?” ");
INSERT INTO lbb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ika, e Iesu i tasmani mang, a nuknukinla i laulau, pa i atai la mang, “Mulo na tena asasongo, sur asaning mulo mang sur mulor toho iau? ");
INSERT INTO lbb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mulor asangan iau ana ta mani na totokom.” Pa la saran tar a mani tana. ");
INSERT INTO lbb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pa i deken la mang, “A manar pa tumtumus ne onoi an esi?” ");
INSERT INTO lbb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","La kelesi mang, “Anuna Sisar.” Pa i atai la mang, “Asaning anuna Sisar, mulor sarani tetek a Sisar, pa saning ane God, mulor sarani otleng tetek e God.” ");
INSERT INTO lbb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ning la longori, la kulkulan kol pa la han kusuni. ");
INSERT INTO lbb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ana pukakiar ot ning a Sadusila, ning la sira puai ka mang bel ta lalaun ulak kusun a minat, la han tetek e Iesu, pa la dekeni mang, ");
INSERT INTO lbb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tena Asaer, e Moses i atongi mang, ning ta barsan ir mat pas kusun anuna hane, pa bel ta natundiau, e tasnalik ir ben pasi pa ir taulai i, sur ir aitna tar al kakakla ana risana e tasnalik ning ka mat. ");
INSERT INTO lbb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","26","Ning a kabaitas mais a barsan rop ka, la kes na arpotor tamila. A ningnigona i taulai, pa i mat pas kusun anuna hane, pa bel ta natundiau. Pa murmur tana maleng i taulai a hane ning, pa i le i mat ka kusuni, ika bel ta natna. Lamur a munatol a tasnalik maleng. Pa i arlar larning tetek mais la rop, ning la taulai i. ");
INSERT INTO lbb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pa lamur a hane maleng i mat. ");
INSERT INTO lbb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Ana lalaun ulak kusun a minat, a hane ning, anun esi na halinla ma? Anasa la rop la ka taulai tari.” ");
INSERT INTO lbb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","E Iesu i keles la mang, “Mulo rongo kol, anasa bel mulo tasman a Buk Tabu pa rakrakai e God otleng. ");
INSERT INTO lbb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ana lalaun ulak kusun a minat, bel lar taulai ulak, lar arlar kama ana angelola saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ika ning mulo puai mang a minatla bel lar laun ulak kusun a minat, mangmangasa, belot mulo was a warwara ning e God ka atong tari tamulo? I atongi mang, ");
INSERT INTO lbb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iau a God ane Abaram, a God ane Aisak pa God ane Jekop.’ E God bel a God ana minatla, a God anun la ning la laun.” ");
INSERT INTO lbb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ning a kunum a tarai la longori, la kulkulan kol ana nuna asaer. ");
INSERT INTO lbb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ning a Parisaiola la longori mang, e Iesu ka wolot sot pas a Sadusila, la han taum teteki. ");
INSERT INTO lbb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pa ning a halinla, a tena tastasmai ana warkurai, i tohoi ana kabah mang, ");
INSERT INTO lbb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tena Asaer, esi na warkurai ning i itna kol tanla rop?” ");
INSERT INTO lbb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Pa i kelesi mang, “‘Ur mang sur a Leklek anum a God ana balam rop, a ingum rop, pa nuknukim rop.’ ");
INSERT INTO lbb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A warkurai ne i itna kol tanla rop, pa ai a ningnigo na warkurai. ");
INSERT INTO lbb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pa ine a munaurna, ning i arlar otleng larning, ‘Ur mang sur a halim larning u mang sur u ot.’ ");
INSERT INTO lbb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Naur a warkurai ne, diau a kamkama warkurai rop ane Moses pa asaerla anuna propetla.” ");
INSERT INTO lbb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ning a Parisaiola la kes taum, e Iesu i deken la mang, ");
INSERT INTO lbb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Asaning mulo nuki ana Karisito? Ai a nat esi?” La kelesi mang, “A nat e Dewit.” ");
INSERT INTO lbb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","E Iesu i atai la mang, “Manglarning, i mangmangasa a Talngan Tabu i nigon e Dewit pa i atong a Karisito mang ‘anuk a Leklek’? Anasa e Dewit i atongi mang, ");
INSERT INTO lbb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘A Leklek i atongi tetek anuk a Leklek, “Ur kes te na sot a kuk, tuk ning ar tolsot pas anum na hiruala sur lar kes nahaim.” ’ ");
INSERT INTO lbb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ning e Dewit i atong a Karisito mang anuna Leklek, di tamana mangmangasa?” ");
INSERT INTO lbb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pa bel tik i nuk pas ta warwara ulak sur ir kelesi ono. Turpasi ana pukakiar ning, bel ulak ma tik i deken e Iesu ana ta kabah, anasa la matmataut. ");
INSERT INTO lbb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lamur e Iesu i atongi tana kunum a tarai pa nuna kakak a asaerla mang, ");
INSERT INTO lbb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na tena asaer tagun a warkurai pa Parisaiola la asaer a tarai ana warkuraila arlar onoi ning e Moses i toli. ");
INSERT INTO lbb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","I maining, a ututnala rop ning la asaer mulo ono, mulor longor ono, pa mulor toli. Ika, gong mulo mur anunla a toltol, anasa bel la tol asaning la sira atongi. ");
INSERT INTO lbb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","La saran tar a mamahat a utnala sur a tarai lar losi, ika la ot, bel la arnangai ono. ");
INSERT INTO lbb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Anunla na titol rop, la toli ka, sur a tarai lar oroi la. Mulo sira akas tar dingla na warwara na Buk Tabu ting na nanatar a boksla, pa mulo doti ting na patarimulola. Ika a Parisaiola, anunla na nanatar a boksla i palar kol. Pa mulo sira dot a kulola ting na sinir ana numulo a kaen a niaring. Ika a Parisaiola, anunla na kulo i barah kol. ");
INSERT INTO lbb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","La mang sur a keskes a leklek salanigo na ngasala, pa keskes otleng salanigo na rumai lotula. ");
INSERT INTO lbb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pa la mang sur a tarai lar saran a tnan hanrawai tetek la ting na puknala na tinan taum, pa lar atong la otleng a tena asaerla. ");
INSERT INTO lbb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ika, gong di atong mulo a tena asaerla, anasa takai a Tena Asaer sot ka anumulo. Pa mulo tas. ");
INSERT INTO lbb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pa gong mulo atong tik mite lapiu a tamamulo, anasa takai a Tamamulo sot ka, ning i kes saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pa gong di atong mulo otleng a ningnigola, anasa takai sot ka anumulo a ningnigo, a Karisito ka. ");
INSERT INTO lbb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pa esining i leklek tamulo, ir tena titol anumulo. ");
INSERT INTO lbb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Anasa esining i aleklek pasi, e God ir anatarna i. Pa esining i anatarna pasi, e God ir alekleki.” ");
INSERT INTO lbb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","E Iesu i atongi mang, “Ir laulau kol tetek mulo a tena asaerla tagun a warkurai pa Parisaiola, mulo na tena asasongo. Mulo tagar alar a tarai sur gong la kas ana matanitu misaot na langit. Pa mulo ot, bel mulo kas ono, pa tarai ning la mang sur lar kas, bel mulo noren la sur lar kas. ");
INSERT INTO lbb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ir laulau kol tetek mulo a tena asaerla tagun a warkurai pa Parisaiola, mulo na tena asasongo. Mulo han taltal tisa latasi pa sa na bual, sur mulor dat lingir tik, sur ir hanot a kaklik a asaer anumulo. Pa ning ka longor, mulo tarai tar ono, sur ir han uting na tnan iah, pa anuna toltol laulau ir itna tan anumulo a toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ir laulau kol tetek mulo a ningnigola, mulo arlar ka ana kutla, anasa mulo atongi mang, ‘Esining i lele ana rumai artabar, bel i mamahat, ika ning tik i lele ana gol ana rumai artabar, a lele ning i momol.’ ");
INSERT INTO lbb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mulo na longlong a kut! Asaning i itna tandiau? A gol, o a rumai artabar ning i atotoh a gol sur ir totoh na matana e God? ");
INSERT INTO lbb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mulo atongi otleng mang, ‘Esining i lele ana logo na tun artabar, bel i mamahat, ika ning tik i lele ana artabar ning di suahi ono, a lele ning i momol.’ ");
INSERT INTO lbb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mulo na kut! Asaning i itna tandiau? A artabar, o a logo na tun artabar ning i atotoh a artabar sur ir totoh na matana e God? ");
INSERT INTO lbb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Esining i lele ana logo na tun artabar, i lele otleng ana ututnala rop ning kaning ono. ");
INSERT INTO lbb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Esining i lele ana rumai artabar, i lele otleng oe God ning i kes tingia. ");
INSERT INTO lbb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Esining i lele ana langit, i lele ot ana keskes a king ane God, pa i lele otleng o esaning i kes ono. ");
INSERT INTO lbb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ir laulau kol tetek mulo a tena asaerla tagun a warkurai pa Parisaiola, mulo na tena asasongo. Mulo nuknuk kol ana nanatar a warkurai, larne mulo saran taktakai rakai tetek e God miting na ning a bonot a nanatar a rakai ning i toboh wakak, ika bel mulo nuk pas na tatatnan utna na warkuraila. La ne: a tostos a warkurai, a marmaris tetek a tarai, pa momol a toltol. I wakak ning mulor tol a ututnala ne, pa gong otleng mulo duman sen taktakai miting na ning a bonot, sur mulor sarani tetek e God. ");
INSERT INTO lbb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mulo a ningnigola, mulo arlar ka ana kutla. Ning mulo gang, mulo kepsen a sinip kusun a kap, ika, a kamel ning kaning na kap, mulo gangi ka! ");
INSERT INTO lbb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ir laulau kol tetek mulo a tena asaerla tagun a warkurai pa Parisaiola, mulo na tena asasongo. Mulo gos pas ka a risris a kap pa pelet, ika a balamulo i bukus ana toltol a angongos pas a utna ana tik, pa toltol ning tik i nuk pasi ot. ");
INSERT INTO lbb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","U a kut a Parisaio! Ur dur nigon pas a balan a kap pa pelet, sur a risrisindiau otleng ir talapor. ");
INSERT INTO lbb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ir laulau kol tetek mulo a tena asaerla tagun a warkurai pa Parisaiola, mulo na tena asasongo. Mulo arlar ana kulam a minatla ning di pen tar la. Ning di oroi la tumo lapiu la wakak, ika ting na balanla i bukus ana sur a minatla pa ututnala rop ning i dur. ");
INSERT INTO lbb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Larka otleng ning, a tarai la oroi a palaomulo mang, mulo na tena tostos, ika tingui omulo i bukus ana asasongo, pa toltol laulaula. ");
INSERT INTO lbb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ir laulau kol tetek mulo a tena asaerla tagun a warkurai pa Parisaiola, mulo na tena asasongo. Mulo sira awakak a kulam a minatla anuna propetla, pa mulo sira amermer a tung a minatla anuna tena tostosla. ");
INSERT INTO lbb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pa mulo atongi mang, ‘Ning milar laun taum ana tumtubumila nating, bel milar nangan la ning la umkol a propetla.’ ");
INSERT INTO lbb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","I maining mulo apuasa mulo mang, mulo na tumtubunla ning la umkol a propetla. ");
INSERT INTO lbb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mulo ma, mulor arop a toltol laulaula ning na tumtubumulo la ka akamtur tari nating. ");
INSERT INTO lbb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mulo na soila! Mulo na natnat a laulau a soila! Mulor liu kumna mangmangasa kusun a warkurai a arkeles ana tnan iah? ");
INSERT INTO lbb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","I maining, ar sune a propetla, na tena tastasmai, pa na tena asaer tetek mulo. Al tarai onla, mulor umkol la, pa al tarai, mulor sai ahat la saot na rakai kutusla, pa al tarai otleng, mulor miras la ting na numulo na rumai lotu, pa mulor lu sen la kusun anumulo na hananuala, pa lar liu uting na hananua masik. ");
INSERT INTO lbb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dir saran a warkurai a arkeles tetek mulo, sur a suluk a tena tostosla rop, ning di ka umkol tar la. Turpasi ning di umkol e Abel, a tena tostos, pa i han tuk oe Sekaria, a nat e Berekia, esaning mulo umkoli na arpotor a logo na tun artabar pa pukna ning i Tabu, tingui na rumai artabar. ");
INSERT INTO lbb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A atong momoli tamulo, dir saran a warkurai a arkeles tetek a tarai tagun onone ana ututnala rop ne. ");
INSERT INTO lbb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem, u ning u sira umkol a propetla, pa la ning di sune la tetek u, u wolot amat la ka ana hatatla. A galis a pukakiar a mang sur ar kibas taum na natnatum tetek iau, arlar ana kakaruk ning i roroh alar na natnatna nahai naur a dehelna, ika bel mulo mang. ");
INSERT INTO lbb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Oroi! Anumulo a hanua ir hanot a hanua bel. ");
INSERT INTO lbb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Anasa a atai mulo, bel mulor oroi ulak iau tuk ning mulor atongi mang, ‘Esaning i hanot ana risan a Leklek i angis.’” ");
INSERT INTO lbb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","E Iesu i purum kusun a rumai artabar. Ning i han amon, anuna kakak a asaerla la han teteki, pa la atai i sur ir oroi na rumai ting napir a rumai artabar, ning la tatatai wakak. ");
INSERT INTO lbb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pa i atai la mang, “Mulo oroi i ot na rumai ne, gepi? A atong momoli tamulo, lamur bel ta hat ir borbor saot on ta hat, dir regen arop sen la.” ");
INSERT INTO lbb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ning e Iesu i kes saot na Mangir Oliw, a kakak a asaerla ka la hanot teteki, pa la atongi tana mang, “Ur atai mila, nangse a ututnala ne ir hanot? Pa esi na akinalang ana num a tinan ot ulak pa ararop a rakrakan hanua?” ");
INSERT INTO lbb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","E Iesu i keles la mang, “Mulor tai alar mulo, sakana tik ir asongo pas mulo. ");
INSERT INTO lbb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Anasa a galis lar hanot ana risak, lar atongi mang, ‘Iau a Karisito,’ pa lar asongo al galis a tarai. ");
INSERT INTO lbb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mulor longor a harumla pa al arkaltai ana harumla, ika gong mulo matmataut. A ututnala ne lar hanot, ika a ararop ana rakrakan hanua kaning ot. ");
INSERT INTO lbb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ning a mangis a tarai ir tur na harum tetek ning a mangis a tarai, pa ning a matanitu ir tur na harum tetek ning a matanitu. A tatatnan munurak, pa mamaisla ir hanot ting na hananuala. ");
INSERT INTO lbb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A ututnala rop ne, i arlar ana ningnigo na kankanla, ning i sira hanot ana hane ning i mang sur ir agon. ");
INSERT INTO lbb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kaning lamur, dir saran tar mulo sur dir alaulau mulo, pa dir umkol mulo, pa na tarai miting na matanitu rop lar nget mulo, anasa mulo anuki. ");
INSERT INTO lbb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ana pukakiarla ning, a galis lar han kusun a tortorot. Lar saran artalai la tetek a hiruala, pa lar nget artalai la. ");
INSERT INTO lbb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A galis a asasongo na propet otleng lar hanot, pa lar asongo pas a galis a tarai. ");
INSERT INTO lbb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A marmaris anuna galis ir rop, anasa na toltol laulaula ir itna kas amon. ");
INSERT INTO lbb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ika esining ir tur rakrakai tuk anuna lalaun ir rop, e God ir alauni. ");
INSERT INTO lbb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dir warawai ana Wakak a Warwara ana matanitu ane God tetek a tarai mite na rakrakan hanua rop, sur a warwara talapor ir han tetek na tarai miting na matanitu rop, lamur bot a rakrakan hanua ir rop. ");
INSERT INTO lbb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mulor oroi ning a laulau a utna kol ir hanot, ir kes ting na rumai ane God pa ir alaulau a rumai ning. A utna ning, e Daniel a propet ka warwara nigo tar ono nating ot. Esining ir was a warwara ne, i wakak sur ir talapor ono. ");
INSERT INTO lbb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ana pukakiar ning, la ning la kes ting na papar Judia, lar liu kumna usaot na mangirla. ");
INSERT INTO lbb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ning tik ir kes saot na nuna rumai, gong i purum sur ir los pas ta utna tingui na rumai. ");
INSERT INTO lbb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ning tik ir kes ting na barim, gong i ulak utumo lahanua sur anuna saket. ");
INSERT INTO lbb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ana pukakiarla ning, ir laulau kol tetek a tiananla, pa la otleng ning la aresus. ");
INSERT INTO lbb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mulor nunung sur gong mulo liu song ana kalangla na kotkoto, o ana Pukakiar Sabat. ");
INSERT INTO lbb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Anasa ana pukakiarla ning, ir itna kol a mamahatla. Ir itna tana mamahatla ning i sira hanot te na rakrakan hanua, turpasi ana kamkama rakrakan hanua tuk onone, pa lamur otleng, bel ta mamahat ir arlar ono. ");
INSERT INTO lbb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ning e God bel ir kutus purum a pukakiarla ning, bel tik ir laun. Ika ir kutus purum seni sur la ning ka aslang pas la, lar laun. ");
INSERT INTO lbb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ana pukakiarla ning, ning tik ir atongi tamulo mang, ‘Oroi, a Karisito ine,’ o ir atongi mang, ‘Numo e,’ gong mulo tortorot onoi. ");
INSERT INTO lbb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Anasa al asasongo na Karisito, pa al asasongo na propet lar hanot. Lar tol al tatatnan akinalang pa al ututna na kulkulan sur lar asongo a taraila ning e God ka aslang pas la. Ning lar tolsot, lar asasongo a tarai ning e God ka aslang pas la. ");
INSERT INTO lbb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Oroi, ia ka atai nigon tar mulo ono. ");
INSERT INTO lbb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ning lar atai mulo mang, ‘A Karisito kaning na hanua bel,’ gong mulo han suri, pa ning lar atongi otleng mang, ‘Kaningui na rumai,’ gong mulo tortorot ono. ");
INSERT INTO lbb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Anasa a tinan ot anuna Nat a Barsan, ir arlar ana pil, ning i pil mitumo na matana tobar, pa di oroi tuk to na matana labur. ");
INSERT INTO lbb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A pukna ning a minat i borbor tingia, a kotkotla lar han taum tingia. ");
INSERT INTO lbb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ning ka rop a mamahatla ana pukakiarla ning, ono otning ‘a kamis ir mormorom, a kalang bel ir talapor, a nangnangla lar punga purum misaot na bakut, pa ututnala saot na bakut lar maler.’ ");
INSERT INTO lbb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ana taim ning, a akinalang ana Nat a Barsan ir hanot ana bakut. Pa na tarai miting na matanitu rop te na rakrakan hanua lar domos. Pa lar oroi a Nat a Barsan ir hanot ana didiah bakutla, taum ana rakrakai pa tnan matatar. ");
INSERT INTO lbb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A tawuru ir tangis kol pa Nat a Barsan ir sune anuna angelola, sur lar ben taum anuna tarai ning ka aslang pas la. Lar ben taum la miting na diat a matana wuwu, miting na ning a ris a rakrakan hanua tuk utumo na ning a ris. ");
INSERT INTO lbb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mulor asaer ana rakai a fig. Ning a rakrakanala ir sibul ot ulak, pa pakpakana ir tapalas, mulo ka tasmani mang a kalangla na laplapang ka milau. ");
INSERT INTO lbb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lar otleng ning, ning mulor oroi a ututnala rop ning ia ka warwara tar ono ir hanot, mulor tasmani mang, ka milau. ");
INSERT INTO lbb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A atong momoli tamulo, a tarai tagun onone belot lar mat pa ututnala rop ne ir hanot. ");
INSERT INTO lbb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A langit pa rakrakan hanua diar rarop, ika anuk a warwarala bel ir rarop. ");
INSERT INTO lbb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Bel tik i tasman a pukakiar pa awa ning a ututnala ne ir hanot. A angelola saot na langit bel la tasmani, pa e Natnalik otleng bel i tasmani, e Tamana ka i tasmani. ");
INSERT INTO lbb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A tinan ot ulak anuna Nat a Barsan, ir arlar ana pukakiarla ane Noa. ");
INSERT INTO lbb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ana pukakiarla ning a lomom belot i hanot, la hangan, la gang, pa la ataulai la, tuk ana pukakiar ning e Noa i kas ana sip. ");
INSERT INTO lbb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pa bel la tasman asaning ir hanot, tuk ning a lomom i hanot, pa i los arop sen la. Ir arlar ka otleng ana tinan ot ana Nat a Barsan. ");
INSERT INTO lbb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ana pukakiar ning, ning ir naur a barsan diar titol tisa na barim, dir kibas pas ta halindiau, pa ning a halindiau bel. ");
INSERT INTO lbb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ning ir naur a hane otleng diar miren a wit, dir kibas pas ta halindiau, pa ning a halindiau bel. ");
INSERT INTO lbb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“I maining mulor tumarang, anasa bel mulo tasman a pukakiar ning anumulo a Leklek ir hanot ono. ");
INSERT INTO lbb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mulor tasmani mang: Ning a tamana rumai ir tasman a puka morom ning a tena kinkinau ir hanot, ir kes pa ir tai alar anuna rumai. Bel ir noreni sur dir kinau i. ");
INSERT INTO lbb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mulo otleng, mulor sang, anasa a Nat a Barsan ir hanot nangse ning bel mulo nuki mang ir hanot. ");
INSERT INTO lbb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“A tena titol oros ning i momol ana nuna titol pa i tastasman otleng, anuna leklek ir akes tari sur ir ningnigo ting na nuna rumai, sur ir tabar a tena titol orosla otleng, ana utna na hangan anlai ana taim na hangan. ");
INSERT INTO lbb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A tena titol oros ning, ir angis ning anuna leklek ir hanot pa ir oroi i ning i tolsot pas anuna titolla. ");
INSERT INTO lbb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A atong momoli tamulo, anuna leklek ir suahi sur ir tena tai alar ana nuna ututnala rop. ");
INSERT INTO lbb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ika ning a tena titol oros ning, a laulau a tena titol oros, pa i nuki mang, anuna leklek bel ir hanot kapit, ");
INSERT INTO lbb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ir turpasi sur ir um a tena titol orosla ning la titol taum onoi, pa ir hangan pa ir gang taum ana tena gangla, ");
INSERT INTO lbb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","anuna leklek ir hanot ana pukakiar ning a tena titol oros bel ir tasmani, pa ana awa ning bel i nuki mang ir hanot ono. ");
INSERT INTO lbb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pa leklek ir ting kutkutusi, pa ir saran tar a warkurai a arkeles teteki, sur ir kes taum ana tena asasongola, ting na pukna ning di tangtangis pa di arngingit ngesendi tingia. ");
INSERT INTO lbb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ana pukakiarla ning, a matanitu misaot na langit ir arlar ana ning a bonot a basbas, ning la kibas pas anunla na lam, pa la han sur lar barat a barsan ning i mang ir taulai. ");
INSERT INTO lbb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dilima onla, la tastasmai, pa dilima, bel la tastasmai. ");
INSERT INTO lbb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","La ning bel la tastasmai la los anunla na lam, ika bel la los al koto na wel otleng taum onla. ");
INSERT INTO lbb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ika, la ning la tastasmai la los anunla na lam pa la los otleng na koto na wel taum onla. ");
INSERT INTO lbb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A barsan ning i mang ir taulai bel i hanot kapit, pa matanla i sulam, pa la borbor duman rop. ");
INSERT INTO lbb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ana tnan morom di arkabah mang, ‘Wo, a barsan ning i mang ir taulai i ma ine! Mulo iap, mulor barati.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A basbasla rop la mata, pa la sang anunla na lam. ");
INSERT INTO lbb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","La ning bel la tastasmai, la nunung la ning la tastasmai mang, ‘Mulor tabar mila anal siklik wel, anasa anumila na lam la ka mang sur lar mat.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","La keles la mang, ‘Bel, sakana bel ir arlar ondala rop. Mulor han tetek la ning la siuran wel pa mulor lolou pas anumulo.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ika ning la han sur lar lolou, a barsan ning i mang ir taulai i hanot. Dilima ning la ka sang tar, la han taum onoi sur a ngasa na tinaulai, pa di tagar alar a taman. ");
INSERT INTO lbb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Lamur dilima otleng la hanot, pa la arkabah mang, ‘Leklek, leklek, sapang pas mila.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","I keles la mang, ‘A atong momoli tamulo, bel a tasman mulo.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Larning, mulor tumarang mulo, anasa bel mulo tasman a pukakiar o a awa ning a Leklek ir hanot ono. ");
INSERT INTO lbb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“A matanitu misaot na langit i arlar otleng ana ning a barsan ning i sang sur ir han ana tinan bakbak. I kabah pas anuna natol a tena titol oros, pa i saran tar anuna gongonla tanditol sur ditol ir titol ono. ");
INSERT INTO lbb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I saran tar dilima na rip a mani tana ning, pa naur a rip tana ning, pa ning a rip otleng tetek ning a halinditol. I saran tari tetek ditol taktakai arlar ot ana nunditol a tastasmai. Pa lamur i han ana nuna tinan. ");
INSERT INTO lbb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Esaning di saran tar dilima na rip tana, ono otning i han pa i titol ono, pa i agomo ulak pas dilima na rip a mani taguni. ");
INSERT INTO lbb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Larka otleng tetek esaning di saran tar naur a rip tana, i agomo ulak pas naur a rip a mani taguni. ");
INSERT INTO lbb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ika, esaning di saran tar ning a rip tana, i han, i kel pas a tung, pa i por kumnan tar a mani anuna leklek. ");
INSERT INTO lbb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ning ka bongnani, a leklek anuna natol a tena titol oros, i hanot pa i kabah pas ditol sur ditol ir atai talapori ana nuna mani. ");
INSERT INTO lbb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Esaning di saran tar dilima na rip a mani tana i han teteki ana dilima na rip ulak, pa i atongi tana mang, ‘Leklek, u saran tar dilima na rip a mani tak. Oroi, ia ka agomo otnan pas dilima na rip taguni.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Anuna leklek i kelesi mang, ‘Wakak kol, u a wakak a tena titol oros, u momol ana num a titol. Ar suah tar u sur ur tai alar on al galis a utna, anasa u momol ana natar a utna ne. Lamut, pa dar gas taum.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Esaning di saran tar naur a rip a mani tana i han teteki, pa i atongi mang, ‘Leklek u saran tar naur a rip a mani tak. Oroi, ia ka agomo otnan pas naur a rip taguni.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Anuna leklek i kelesi mang, ‘Wakak kol, u a wakak a tena titol oros, u momol ana num a titol. Ar suah tar u sur ur tai alar on al galis a utna, anasa u momol ana natar a utna ne. Lamut, pa dar gas taum.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Lamur esaning di saran tar ning a rip a mani tana i han teteki, pa i atongi mang, ‘Leklek, a tasmani mang u a tena ngalngaliah. U sol a utna ning bel u oman tari, pa u git pas a wana utna ning bel u sapran tari. ");
INSERT INTO lbb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","A matatan u, pa a han a por kumnan tar anum a mani. Oroi, anum a mani i ulak mane.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Anun a leklek i kelesi mang, ‘U a laulau a tena titol oros, a tabun a titol u. U ka tasmani mang, a sol a utna ning bel a oman tari, pa a git pas a wana utna ning bel a sapran tari. ");
INSERT INTO lbb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sur asaning bel u suah tar anuk a mani ting na beng, sur ar kibas pas anuk a mani pa ta tuk otleng saot ono, ana pukakiar ning ar hanot? ");
INSERT INTO lbb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mulor los sen a mani kusuni, pa mulor sarani tetek esaning anuna ning a bonot a rip a mani. ");
INSERT INTO lbb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Anasa esining anuna al ututna, dir tabar ulaki sur anuna ututnala ir galis kol, pa esining bel anuna al utna, dir kepsen otleng siklik ning kaning tana. ");
INSERT INTO lbb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pa tena titol oros ne, ning bel i tolsot pas ta utna, mulor migen purum seni uting na mormorom, a pukna ning di tangtangis pa di arngingit ngesendi tingia.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“A Nat a Barsan ir hanot ana nuna matatar, taum ana nuna angelola, pa ir kes ana nuna keskes a king. A keskes ning a tnan matatarna. ");
INSERT INTO lbb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A taraila miting na matanitu rop lar han taum na matana, pa ir asalar la, arlar ana tena tai alar anuna sipsipla i asalar a sipsipla kusun a memela. ");
INSERT INTO lbb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ir sune a sipsipla uting na sot a kuna, pa memela uting na kair. ");
INSERT INTO lbb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","A king ir atai la ning kaning na sot a kuna mang, ‘Mulo han ute, mulo ning e Tata ka angis tar mulo. Mulor kibas pas a matanitu ning ka sang tari sur anumulo, tagun nating ot na kamkama rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Anasa a murak pa mulo tabar iau, a mos pa mulo agang iau, a wasira pa mulo ben kas iau uting na rumai. ");
INSERT INTO lbb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bel ta kaen anuki pa mulo saran a kaen tak, a sasam pa mulo tai alar iau, pa a kes ting na karabus pa mulo geren iau.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Na tena tostos lar dekeni mang, ‘Leklek, nangse mila oroi u ning u murak pa mila tabar u, pa u mos pa mila agang u? ");
INSERT INTO lbb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nangse mila oroi u ning u wasira pa mila ben kas u uting na rumai, pa bel ta kaen anumi pa mila saran a kaen tam? ");
INSERT INTO lbb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nangse mila oroi u ning u sasam, o u kes ting na karabus, pa mila geren u?’ ");
INSERT INTO lbb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“A king ir keles la mang, ‘A atong momoli tamulo, asaning mulo toli tetek ta barsan oros ka tagun a tastasikla ne, mulo toli hok.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Lamur ir atai la otleng kaning na kair a kuna mang, ‘Mulor han masik kusun iau. A rakrakai a warkurai a arkeles ka kes omulo. Mulor han uting na tnan iah ning bel i sira mat, ning di ka sang tari sur e Satan pa nuna angelola. ");
INSERT INTO lbb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Anasa a murak pa bel mulo tabar iau, a mos pa bel mulo agang iau. ");
INSERT INTO lbb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","A wasira pa bel mulo ben kas iau uting na rumai, bel ta kaen anuki pa bel mulo saran ta kaen tak, a sasam pa a kes ting na karabus pa bel mulo geren iau.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“La maleng lar dekeni mang, ‘Leklek, nangse mila oroi u ning u murak, u mos, u wasira, bel ta kaen anumi, u sasam, pa u kes ting na karabus, pa bel mila nangan u?’ ");
INSERT INTO lbb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ir keles la mang, ‘A atong momoli tamulo, asaning bel mulo tol tari tetek ta barsan oros ka, bel mulo toli hok.’ ");
INSERT INTO lbb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Lamur lar han sur a akadik tikin. Ika a tena tostosla lar han sur a lalaun tikin.” ");
INSERT INTO lbb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ning e Iesu ka atong arop tar a warwarala ne, i atai anuna kakak a asaerla mang, ");
INSERT INTO lbb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mulo ka tasmani, ning naur a pukakiar kar rop, dir turpas a tnan pukakiar a lotu na Han Lakai, pa dir saran tar a Nat a Barsan sur dir sai ahati saot na rakai kutus.” ");
INSERT INTO lbb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ana taim ot ning a leklek a tena artabarla tetek e God pa na ningnigo anuna tarai, la kes taum ting na tnan rumai ane Kaiapas, a ningnigo na tena artabar. ");
INSERT INTO lbb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","La pinpidaiwol pas sur lar tong kumnan pas e Iesu, pa lar umkoli. ");
INSERT INTO lbb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","La atongi mang, “Gong dala toli ana tnan pukakiar a lotu, sakana a tarai lar arsakai.” ");
INSERT INTO lbb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","E Iesu i kes tumo e Betani, ting na rumai ane Saimon, esaning nating i sasam ana lepra. ");
INSERT INTO lbb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ning a hane i han tetek e Iesu ana polo na tomtoboh, a matana i abit kol, kaning na koto ning di toli ana hat. I peki saot na pukul e Iesu, ning kaning ot e Iesu i hangan. ");
INSERT INTO lbb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ning a kakak a asaerla la oroi, la balakut kol ono, pa la atongi mang, “Sur asaning di amus oros ka a tomtoboh ne? ");
INSERT INTO lbb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sur asaning bel di siuran pasi sur al galis a mani sur dir tabar na kapan a tarai ono?” ");
INSERT INTO lbb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","E Iesu ka tasman asaning la warwara ono, pa i atai la mang, “Sur asaning mulo saran a mamahat tetek a hane ne? I ka tol tar a wakak a titol hok. ");
INSERT INTO lbb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A kapan a taraila lar laun bolbolos taum ot omulo. Ika iau, bel ar kes tikin napirimulo. ");
INSERT INTO lbb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A hane ne i pek tar a polo na tomtoboh ne te na palaok sur ir sang iau sur a pukakiar ning ar mat pa dir akas a minatik ting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A atong momoli tamulo, te na rakrakan hanua rop, ning dir warawai ana Wakak a Warwara ne, dir warwara otleng ana saning a hane ne ka tol tari, sur a tarai lar nuk akes a hane ne.” ");
INSERT INTO lbb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","E Judas Iskariot, ning a halin ning a bonot pa pisir naur a kakak a asaer, i han tetek a leklek na tena artabarla tetek e God. ");
INSERT INTO lbb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Pa i deken la mang, “Ning ar saran tar e Iesu tetek mulo, asa mulor lou iau ono?” Pa la saran tar natol a bonot a silwa tana. ");
INSERT INTO lbb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Turpasi ana pukakiar ning i nuknuk sur ta wakak a pukakiar ning ir saran tar e Iesu uting na kunla. ");
INSERT INTO lbb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ana ningnigo na pukakiar ana lotu na bret ning bel al is ono, na kakak a asaer la han tetek e Iesu, pa la dekeni mang, “U mang sur milar han utaha, sur milar sang andala utna na hangan sur a lotu na Han Lakai?” ");
INSERT INTO lbb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pa i keles la mang, “Mur han kas usaot e Jerusalem, mur barat ning a barsan, pa mur atai i mang, ‘A Tena Asaer i atongi mang: Anuk a pukakiar ka milau. Mila taum ana nuk a kakak a asaerla milar asilang a tnan pukakiar a lotu na Han Lakai ting na num a rumai.’” ");
INSERT INTO lbb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Naur a kakak a asaer dia tol ot asaning e Iesu ka atong tari tandiau, pa dia sang a ututnala na Han Lakai. ");
INSERT INTO lbb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ning a rah ma, e Iesu taum ana nuna ning a bonot pa pisir naur a kakak a asaer la kes ana utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","La hangan pa i atongi mang, “A atong momoli tamulo, ning a halimulo ir saran tar iau uting na kuna hiruala.” ");
INSERT INTO lbb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","La balmaris kol pa la rop taktakai la turpas a deke teteki mang, “Leklek, bel iau gepi?” ");
INSERT INTO lbb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","E Iesu i keles la mang, “Esaning mia amurung taum amiau naur a diah bret te na besen, i ning ir saran tar iau na kun a hiruala. ");
INSERT INTO lbb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A Nat a Barsan ir hirua lar otning di ka tumus tari ting na Buk Tabu. Ika ir laulau kol tetek a barsan ning ir saran tari tetek a hiruala. Ir wakak teteki ning bel dir agoni.” ");
INSERT INTO lbb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","E Judas, esaning ir saran tari tetek a hiruala, i dekeni mang, “Tena Asaer, bel iau gepi?” I kelesi mang, “U ka.” ");
INSERT INTO lbb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ning kaning ot la hangan, e Iesu i kibas pas a bret, i atong wakak onoi, i kibiki, pa i tabar anuna kakak a asaerla ono, pa i atongi mang, “Mulor kibasi pa mulor ieni. Ine a palaok.” ");
INSERT INTO lbb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Lamur i los pas a kap, i atong wakak pas ono pa i sarani tanla. I atongi mang, “Mulo rop mulor gang ono. ");
INSERT INTO lbb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ine a sulukik, ning i amomol tar a kunubus ning i dat taum tar e God pa tarai. A sulukik ne, i tapek sur ir kepsen na toltol laulau anuna galis a tarai. ");
INSERT INTO lbb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A atongi tamulo mang, bel ar gang ulak al wain, tuk ning dalar gang a tona wain saot na matanitu ane Tata.” ");
INSERT INTO lbb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ning la ka saken tar a saksak a lotu, la han usaot na Mangir Oliw. ");
INSERT INTO lbb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","E Iesu i atongi tanla mang, “Mese na morom, mulo rop mulor han kusun iau. Anasa di ka tumus tari ting na Buk Tabu mang, E God i atongi mang, ‘Ar um a tena tai alar ana sipsipla, pa sipsipla lar liu sarara.’ ");
INSERT INTO lbb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ika ning ia ka kamtur ulak kusun a minat, ar nigo utumo e Galili.” ");
INSERT INTO lbb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","E Pita i atai i mang, “Ning la rop lar han kusun u, ika iau bel.” ");
INSERT INTO lbb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","E Iesu i kelesi mang, “A atong momoli tam, mese na morom, ning a kakaruk belot ir kurkurirakuk, ur puai munatol mang bel u tasman iau.” ");
INSERT INTO lbb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","E Pita i atai i mang, “Bel ar puain sen u. Noren iau, ar hirua taum hom.” Pa kakak a asaerla rop otleng la atongi larning. ");
INSERT INTO lbb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","E Iesu taum ana nuna kakak a asaer la hanot ting na ning a pukna di atongi e Getsemani, pa i atai la mang, “Mulor kes ka te, pa iau ar han utumo, sur ar araring.” ");
INSERT INTO lbb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","I ben pas e Pita taum ana naur a nat e Sebedi. I turpas a balmaris pa i mamahat kol a nuknukna. ");
INSERT INTO lbb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","I atai ditol mang, “Anuk a lalaun i mamahat kol ana balmaris, milau ar mat ono. Mutol ar kes ka te, pa mutol ar kokohoi tar taum hok.” ");
INSERT INTO lbb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I han siklik tar usa lanigo, i punga purum ana patarna ting na piu, pa i araring mang, “Tata, ning ir sot, ur kibas sen a kap a mamahat ne kusun iau. Ika gong u mur a nuknukik, ur mur ot a nuknukim.” ");
INSERT INTO lbb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","I ulak tetek natol a kakak a asaer, pa i oroi ditol, ditol ka borbor duman. I deken e Pita mang, “Bel mutol tolsot sur mutol ar kokohoi taum hok on ta tuk a kamis lik ka? ");
INSERT INTO lbb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mutol ar kokohoi, pa mutol ar araring, sur gong mutol punga ana larlarla. A ingumutol i mang sur ir longor, ika a palaomutol i ngol.” ");
INSERT INTO lbb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Munaur a tinan ulak i han kusun ditol, pa i araring mang, “Tata, ning bel i sot sur ur kibas sen a kap a mamahat ne kusun iau, i wakak ka sur ar kilangi. Ar muri ot a nuknukim.” ");
INSERT INTO lbb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ning i ulak, i oroi ditol, ditol ka borbor duman ulak, anasa a matanditol ka sulam kol. ");
INSERT INTO lbb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pa i han ulak kusun ditol, pa ana munatol a niaring anunai, i paliu ulak a niaring ning ka atong tari kaba. ");
INSERT INTO lbb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Lamur i ulak tetek natol a kaklik a asaer, i atai ditol mang, “Mutol borbor liklik kama pa mutol manah? Oroi, a taim ka milau, ning dir saran tar a Nat a Barsan uting na kuna tena laulaula. ");
INSERT INTO lbb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mutol kamtur, dala kar han! Oroi, a barsan ning ir saran tar iau uting na kuna hiruala, ka hanot.” ");
INSERT INTO lbb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ning e Iesu kaning ot i warwara, e Judas, ning a halin ning a bonot pa pisir naur a kakak a asaer, i hanot taum ana tnan kunum a tarai. La los na liwan a harum pa puka buturla. A leklek a tena artabarla tetek e God pa na ningnigo anuna tarai, la sune sen la. ");
INSERT INTO lbb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Esaning ir saran tar e Iesu uting na kuna hiruala ka atai nigon tar a kunum a tarai ana akinalang ning ir toli larne, “Esaning ar goro a ris a pahana, i ot ning. Mulor tong akesi.” ");
INSERT INTO lbb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ono otning e Judas i han tetek e Iesu pa i atongi mang, “Wakak a morom, Tena Asaer!” Pa i goro i. ");
INSERT INTO lbb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","E Iesu i kelesi mang, “Halik, ur tol ka asaning u han ute suri.” Pa taraila ning, la han tetek e Iesu, la tong akes pasi pa la dati. ");
INSERT INTO lbb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Takai onla ning la han taum oe Iesu, i lasur pas anuna liwan a harum, pa i umsem a talngan a tena titol oros anuna ningnigo na tena artabar tetek e God. ");
INSERT INTO lbb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","E Iesu i atai i mang, “Akas ulak anum a liwan ting na ngasna, anasa la rop ning la arting ana liwanla na harum, lar hirua ana liwanla na harum. ");
INSERT INTO lbb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","I mangasa, u nuki mang, bel ar tolsot sur ar nunung e Tata sur al galis a rip a angelo, pa ono otne ir sune sen la tetek iau? ");
INSERT INTO lbb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ika, ning ar toli larne, bel dir tolsot pas a warwarala ting na Buk Tabu ana ututnala ning i sot sur dir toli hok.” ");
INSERT INTO lbb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ana taim ning, e Iesu i atai a kunum a tarai mang, “I mangasa, ngandek iau a tena harum pa tena kinkinau, sur i ma ine mulo hanot taum ana liwanla na harum pa puka buturla sur mulor tong akes iau? Ana pukakiarla rop a sira kes ting na woroh na rumai artabar, a sira asaer a taraila, pa bel mulo tong akes iau. ");
INSERT INTO lbb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ika a ututnala rop ne i hanot sur dir tolsot pas na tumtumus anuna propetla.” Lamur anuna kakak a asaerla rop la liu pas kusuni. ");
INSERT INTO lbb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","La ning la ka tong akes pas e Iesu, la beni uting na rumai ane Kaiapas a ningnigo na tena artabar tetek e God. Na tena asaer tagun a warkurai pa ningnigola kaning la kes taum. ");
INSERT INTO lbb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","E Pita i mur amon e Iesu, ika i bakbak ot kusuni, sur uting na pukna anuna ningnigo na tena artabar tetek e God. I kas uting na pukna ning, pa i kes taum ana tena tai alarla sur ir oroi asaning dir toli oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A leklek a tena artabarla tetek e God pa tarai a kiwung rop, la tai sur ta asasongo na warwara ana ta rongo ning e Iesu ka tol tari, sur lar tiwi ono, pa lar umkoli. ");
INSERT INTO lbb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","A galis a tena asasongo la hanot, ika bel la pastek ta utna ning lar tiwi ono. Naur ning dia hanot murmur, ");
INSERT INTO lbb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","dia atongi mang, “A barsan ne i atongi mang, ‘Ar regen sen a rumai artabar ane God, par tol ulak pasi ana natol a pukakiar ka.’” ");
INSERT INTO lbb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A ningnigo na tena artabar tetek e God i tur, pa i deken e Iesu mang, “I mangasa, bel ur keles la? Asaning ur keles a warwarala na artitiu ne tetek u ono?” ");
INSERT INTO lbb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ika e Iesu bel i warwara. A tena artabar ning, i atongi tana mang, “Ana risana e God, ning i laun, ur atai mila ning u a Karisito a Nat e God, o bel.” ");
INSERT INTO lbb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","E Iesu i kelesi mang, “I ot ning u atongi. Pa atai mulo mang, turpasi onone, mulor oroi a Nat a Barsan ir kes ting na ris a sot a kuna e God, esaning i rakrakai kol, pa lamur mulor oroi i ning ir hanot ana didiah bakutla misaot na langit.” ");
INSERT INTO lbb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A ningnigo na tena artabar i balakut pa i silir anuna kaen ot pa i atongi mang, “Onone ka atong laulau e God. Dala mang ulak sur al warwara na artitiu sur asa? Mulo ka longor tar anuna na warwara laulau oe God. ");
INSERT INTO lbb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Asa mulo nuki?” Pa la kelesi mang, “I wakak sur ir hirua.” ");
INSERT INTO lbb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pa la namis a patarna, pa la tubuli, pa dingla na tarai la pasari, ");
INSERT INTO lbb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","pa la atai i mang, “Karisito, u a propet, atai mila, esining i tubul u.” ");
INSERT INTO lbb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ning e Pita kaning i kes tar tumo lapiu ting na rumai ning, ning a basbas, a tena titol i han teteki pa i atai i mang, “U otleng taum oe Iesu a te Galili.” ");
INSERT INTO lbb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ika i puai na matanla rop, i atongi mang, “Bel a tasman asaning u warwara ono.” ");
INSERT INTO lbb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lamur i han utumo napir a taman a woroh, ning a hane maleng i oroi pasi, pa i atai a taraila tingia mang, “A barsan ne, dia ma e Iesu a te Nasaret.” ");
INSERT INTO lbb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pa i puai ulak, i lele mang, “A momolna, bel a tasman a barsan ning.” ");
INSERT INTO lbb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lamur siklik, la ning la tur tingia la han tetek e Pita, la atai i mang, “A momolna, u otleng ning a halinla. Anasa mila longor lalan u ka ana num a liu a warwara.” ");
INSERT INTO lbb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pa i lele tetek la, i atongi mang, “E God ir warkurai laulau iau ning ar asongo. Bel a tasman a barsan ning.” Pa ono otning a kakaruk i kurkurirakuk. ");
INSERT INTO lbb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pa e Pita i nuk pas a warwara ning e Iesu ka atong tari tana mang, “Ning a kakaruk belot ir kurkurirakuk, ur puai munatol mang, bel u tasman iau.” Pa i purum kusun a pukna ning, pa i tangis koli. ");
INSERT INTO lbb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ana kobot ning ot, a leklek a tena artabarla rop tetek e God pa na ningnigo anuna tarai, la warwara taum oe Iesu sur dir umkoli. ");
INSERT INTO lbb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","La dot pas naur a kuna, la beni pa la saran tari tetek e Pailat, a tnan ningnigo ana matanitu. ");
INSERT INTO lbb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","E Judas, esaning i saran tar e Iesu uting na kuna hiruala, ning ka tasmani mang di ka warkurai tar e Iesu sur ir mat, a tnan balmaris i kibasi. I ulak ana natol a bonot a silwa tetek a leklek a tena artabarla tetek e God pa ningnigola. ");
INSERT INTO lbb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Pa i atongi mang, “Ia ka tol tar a toltol laulau, anasa ia ka asobor tar esaning bel i tol ta laulau.” Pa la kelesi mang, “Mila, mila mangasa? U ot!” ");
INSERT INTO lbb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","I migen sen natol a bonot a silwa ting na rumai artabar, pa i han pa i popos. ");
INSERT INTO lbb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","A leklek a tena artabarla tetek e God la kibas pas a silwala, pa la atongi mang, “Bel i tostos ana warkurai sur dalar suah a mani ne ting na gongon a mani, anasa a mani ne a arlou tagun a barsan ning di umkoli.” ");
INSERT INTO lbb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pa la warwara taum pas ono, pa la lou pas a puka piu kusun a tena tol kuro ana piopap, sur dir por a minat a wasirala tingia. ");
INSERT INTO lbb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","I maining di atong a pukna ning “A piu a suluk,” pa tarai la atongi larning tuk onone. ");
INSERT INTO lbb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Larne di tolsot pas a warwara ning e Jeremaia a propet ka atong tari nating mang, “La kibas pas natol a bonot a silwa, a matana ning a tarai Israel la suah tari ana barsan ning. ");
INSERT INTO lbb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pa di lou pas a puka piu anuna tena tol kuro ana piopap, ana silwala, larning a Leklek i atong tari tak.” ");
INSERT INTO lbb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","E Iesu i tur na matana e Pailat, a ningnigo tagun a matanitu, pa ningnigo i dekeni mang, “U a king anuna tarai Juda?” Pa e Iesu i kelesi mang, “I ot ning u atongi.” ");
INSERT INTO lbb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ning a leklek a tena artabarla tetek e God pa na ningnigo la tiwi, bel i keles la. ");
INSERT INTO lbb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pa e Pailat i dekeni mang, “Bel u longor a warwara ne la tiu u ono?” ");
INSERT INTO lbb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bel i keles la ana ta artitiu ning la tiwi ono. Pa ningnigo tagun a matanitu i kulkulan kol ono. ");
INSERT INTO lbb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ana raula rop ana lotu na Han Lakai, a ningnigo tagun a matanitu i sira pak sen ta mainla ning i kes ting na karabus, ning a tarai la mang suri. ");
INSERT INTO lbb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ana rau ning, ning a barsan a risana e Barabas i kes ting na karabus ana nuna tatatnan toltol laulau, pa taraila rop la tasman a ginina. ");
INSERT INTO lbb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ning a kunum a tarai la hanot taum tetek e Pailat, i deken la mang, “Esining mulo mang sur ar pak seni tetek mulo? E Barabas o e Iesu, esaning di atongi a Karisito?” ");
INSERT INTO lbb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I atongi larne, anasa ka tasmani mang, a Parisaiola la saran tar e Iesu teteki ana nuknuk laulau. ");
INSERT INTO lbb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ning e Pailat kaning ot i tol a warkurai, anuna hane i saran sen a warwara teteki mang, “Gong u tol ta utna tetek a tena tostos ning, bel ta rongo anunai. Anasa nangana morom, a reresa, pa ututnala a oroi ana barsan ning, i alaulau anuk a lalaun.” ");
INSERT INTO lbb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ika a leklek a tena artabarla tetek e God pa ningnigola la akamtur a balan a kunum a tarai sur lar nunung sur e Barabas, pa dir umkol e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A ningnigo tagun a matanitu i deken la mang, “Esi na halindiau ning mulo mang sur ar pak seni tetek mulo?” La kelesi mang, “E Barabas.” ");
INSERT INTO lbb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","E Pailat i deken la mang, “Asaning ar toli oe Iesu, esaning di atongi a Karisito?” La rop la kelesi mang, “Sai ahati saot na rakai kutus!” ");
INSERT INTO lbb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pa i deken la mang, “Sur asa? Esi na rongo ning ka tol tari?” Ika la kukukuk rakrakai mang, “Sai ahati saot na rakai kutus!” ");
INSERT INTO lbb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ning e Pailat i oroi i mang, bel i tolsot pas ta utna, pa tnan arsakai milau ir hanot, i kibas pas a malum, i gos pas naur a kuna na matan a kunum a tarai, pa i atongi mang, “A langolango kusun a suluk a tena tostos ne. Mulo ot dir warkurai mulo ono.” ");
INSERT INTO lbb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A tarai rop la kelesi mang, “I wakak ka, a warkurai a arkeles ona sulukna ir kes omila pa na natnatumila otleng.” ");
INSERT INTO lbb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","E Pailat i pak sen e Barabas tetek la. Ning di ka miras tar e Iesu, i saran tari tetek a tena harumla sur lar sai ahati saot na rakai kutus. ");
INSERT INTO lbb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na tena harum anuna ningnigo tagun a matanitu la dat kas e Iesu uting na tnan rumai ana nunla a ningnigo. Pa la ben taum arop pas a kunum a tarai a harum rop teteki. ");
INSERT INTO lbb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","La pak sen anuna kaenla, pa la amermer tari ana kubar a kaen. ");
INSERT INTO lbb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pa la iris pas a inau ning a suksukna pa la suah tari ana pukulna arlar ana kukuh anuna king. La atongtong tari ana bulse ting na sot a kuna pa la kes ana bokona hanla na matana, pa la morot laulau ono mang, “U a king anuna tarai Juda!” ");
INSERT INTO lbb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pa la namisi, la kibas pas a bulse ning kusuni, pa la dapdapis a pukulna ono. ");
INSERT INTO lbb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ning la ka morot laulau tar ono, la pak sen a kubar a kaen kusuni. La amermer ulak tari ana nuna kaenla, pa la ben purumi sur dir sai ahati saot na rakai kutus. ");
INSERT INTO lbb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ning la purum la barat pas ning a te Sairini, a risana e Saimon, pa la angongosi sur ir los a rakai kutus ane Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","La hanot ting na pukna di atongi e Golgota, a kamkamna “A Pukna ana Lasa na Pukulundi.” ");
INSERT INTO lbb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","La saran tar a wain ta e Iesu, ning di ka tol taman tari ana utna ning i mapak. Ika, ning i tohoi, bel i mang sur ir gangi. ");
INSERT INTO lbb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ning la ka sai ahat tari saot na rakai kutus, la pilai laki sur lar asalar anuna kaenla tetek la taktakai. ");
INSERT INTO lbb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lamur la kes pa la tai alar e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Saot na pukul e Iesu ting na rakai kutus, la suah tar a warwara na artitiu ono, di tumus tari mang, ");
INSERT INTO lbb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pa di sai ahati otleng naur a tena kinkinau taum ono saot na naur a rakai kutus, takai ting na sot, pa takai ting na kair. ");
INSERT INTO lbb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","La ning la han bolos e Iesu, la atong laulaui pa la halalen pukulunla teteki. ");
INSERT INTO lbb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Pa la atongi mang, “U ma ning u atongi mang ur regen sen a rumai artabar pa ur tol ulak pasi ana natol a pukakiar, onone ur alaun pas u ot. Ning u a Nat e God, ur purum kusun a rakai kutus.” ");
INSERT INTO lbb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Arlar ka otleng tetek a leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai pa ningnigola, la morot laulau oe Iesu, la atongi mang, ");
INSERT INTO lbb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“I alaun pas a tarai masik, ika bel ir tolsot sur ir alaun pasi. Ning i a King anuna tarai Israel, ono otne ir purum kusun a rakai kutus pa dalar tortorot onoi. ");
INSERT INTO lbb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I tortorot oe God. Ning e God i mang, ono otne ir alaun pasi, anasa i ot ka atong tari mang, ‘Iau a Nat e God.’” ");
INSERT INTO lbb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Naur a tena kinkinau otleng ning dia kulam taum ono, dia otleng dia atong laulaui. ");
INSERT INTO lbb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Turpasi ana matana kamis tostos, tuk ana 3 kilok ana rah, a hananua rop i mormorom. ");
INSERT INTO lbb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ning i 3 kilok ana rah, e Iesu i kukuk rakrakai mang, “Eloi, Eloi, lema sabakatani?” A kamkama warwara ning i manglarne, “Anuk a God, anuk a God, sur asaning u han kusun iau?” ");
INSERT INTO lbb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dingla na tarai onla ning la tur milau la longori, pa la atongi mang, “I arkabah sur e Elaija.” ");
INSERT INTO lbb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ono otning, ning a halinla i dun, pa i kibas pas a utna ning i sira dop a polo. I amurung pasi ting na wain ning i mititir, i suahi ana rakai pa i tuslani usaot sur e Iesu ir gangi. ");
INSERT INTO lbb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dingla na tarai otleng onla, la atongi mang, “Te, dalar noreni kaba. Dalar oroi ning e Elaija ir han purum sur ir alaun pasi, o bel.” ");
INSERT INTO lbb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","E Iesu i kukuk rakrakai ulak, pa i suah sen a malwasna. ");
INSERT INTO lbb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ono otning a kaen na alalar kutus tingui na rumai artabar i taksilir potor sur naur a dihna, turpasi saot utumo lain. A mamais i hanot, pa hatatla la tapagal. ");
INSERT INTO lbb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na kulam a minatla la sapang, pa galis a tarai ane God ning la ka mat, la kamtur ulak. ");
INSERT INTO lbb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","La purum kusun na kulam a minatla. Pa lamur tana kamkamtur ulak ane Iesu, la hanot saot e Jerusalem, a hanua ane God, pa la turot tetek a galis a tarai. ");
INSERT INTO lbb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","A ningnigo anuna tena harumla, pa la otleng ning la tur taum onoi sur lar tai alar e Iesu, la kilang a mamais, pa la oroi a ututnala ning i hanot, pa la matmataut kol. La atongi mang, “I momol ot, a barsan ne a Nat e God.” ");
INSERT INTO lbb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A galis a gurarala otleng ning la mur e Iesu mitumo e Galili sur lar nangani, la tur bakbak tar ot pa la oroi a ututnala ne. ");
INSERT INTO lbb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ting na arpotor tanla, natol a hane otleng ne, e Maria Makdalen, pa e Maria e tana e Jems pa e Josep, pa kabatnan naur a nat e Sebedi. ");
INSERT INTO lbb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ning a rah ma, ning a tena gongon, a te Arimatia, a risana e Josep, i otleng ning a kaklik a asaer ane Iesu, ");
INSERT INTO lbb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","i han tetek e Pailat pa i nunung sur a minat e Iesu. Pa e Pailat i arsune sur dir saran tari tana. ");
INSERT INTO lbb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","E Josep i kibas pas a minatna, pa i irisi ana wakak a tona kaen, ");
INSERT INTO lbb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","pa i aborbor tari ting na nuna tona kulam a minat, ning ka kot tari ting na ris a hat. I lakir alar tar a taman a kulam a minat ana tnan hat, pa i han kusuni. ");
INSERT INTO lbb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","E Maria Makdalen pa ning a halindia maurana otleng, dia kes tar salanigo na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ana pukakiar lamur, a Pukakiar Sabat, a leklek a tena artabarla tetek e God pa Parisaiola la han tetek e Pailat. ");
INSERT INTO lbb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","La atai i mang, “Leklek, mila nuk pas a warwara anuna tena asasongo ne. Ning kaning ot i laun, i atongi mang, ana natol a pukakiar lamur ir kamtur ulak. ");
INSERT INTO lbb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ur sune sen al tarai sur lar tai alar wakak a kulam a minat, arlar ana natol a pukakiar, sakana anuna tarai a asaer lar hanot pa lar kinau pas a minatna, pa lar atai a tarai mang ka kamtur ulak kusun a minat. Pa a asasongo ne, ir laulau kol tana asasongo ning nating e Iesu ka atong tari.” ");
INSERT INTO lbb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","E Pailat i atai la mang, “Mulor ben pas na tena tai alar pa mulor han. Mulor tai alar wakak a kulam a minat arlar ot ana numulo a tastasmai.” ");
INSERT INTO lbb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pa la han, pa la arakrakai alar tar a kulam a minat. La suah a ngas a asilang sur lar tasmani ning tik ka sapang tari. Pa la atur tar na tena tai alar sur lar tai alari. ");
INSERT INTO lbb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lamur tana Pukakiar Sabat, ana kobot ning ot ana ningnigo na pukakiar ana wik, e Maria Makdalen, pa ning a halindia maurana otleng dia han sur diar oroi a kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pa tnan mamais i hanot, anasa ning a angelo anuna Leklek i han purum misaot na langit sur a kulam a minat, pa i lakir sen a hat, pa i kes saot ono. ");
INSERT INTO lbb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A patarna i talapor arlar ana pil, pa anuna kaen i kokok arlar ana busa na top. ");
INSERT INTO lbb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na tena tai alar la matatan koli, la koloron, pa la arlar kama ana minatla. ");
INSERT INTO lbb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A angelo i atai naur a hane ning mang, “Gong mu matmataut. A tasmani mang, mu tai sur e Iesu, esaning di sai ahat tari saot na rakai kutus. ");
INSERT INTO lbb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bel i ma te, ka kamtur ulak arlar ana nuna warwara. Mu han ute, mu oroi a pukna ning i borbor tar ia. ");
INSERT INTO lbb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lamur mur han kapit, pa mur atai anuna kakak a asaerla mang, ‘Ka kamtur ulak kusun a minat. Onone ir nigo utumo e Galili. Mulor oroi tumo.’ Oroi, ia ka atai mu onoi.” ");
INSERT INTO lbb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dia han kapit kusun a kulam a minat. Dia matmataut, ika a tnan gasgas otleng i kibas diau. Dia dun sur diar atai anuna kakak a asaerla. ");
INSERT INTO lbb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ono otning e Iesu i hanot kulkulan tetek diau. Pa i atai diau mang, “Wakak a kobot tamu.” Dia han teteki, dia tong naur a hana pa dia lotu teteki. ");
INSERT INTO lbb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pa e Iesu i atai diau mang, “Gong mu matmataut. Mur han pa mur atai a tastasikla, sur lar han utumo e Galili, pa lar oroi iau tumo.” ");
INSERT INTO lbb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ning naur a hane dia han amon, dingla na tena harum ning la tai alar a kulam a minat, la han usaot e Jerusalem. Pa la atai a leklek a tena artabarla tetek e God ana ututnala rop ning i hanot tumo na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ning a leklek a tena artabarla pa ningnigola la kes taum, la warwara taum sur ta ngas ning lar muri. Pa la saran tar a galis a mani tetek na tena harum, ");
INSERT INTO lbb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","pa la atai la mang, “Mulor atongi ka larne, ‘Ana morom ning mila borbor duman, anuna kakak a asaerla la hanot, pa la kinau pas a minatna.’ ");
INSERT INTO lbb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ning a ningnigo tagun a matanitu ir longor a warwara ana utna ne, pa ir deke ono, milar nangan mulo, pa milar pak sen mulo kusun a warkurai.” ");
INSERT INTO lbb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pa na tena harum la kibas pas a mani, pa la toli arlar onoi ning di ka atai tar la ono. Pa warwara ne i han sarara tetek a tarai Juda tuk onone. ");
INSERT INTO lbb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ning a bonot pa pisir takai a kakak a asaer ane Iesu la han utumo e Galili ting na mangir ning e Iesu ka atai tar la sur lar han tingia. ");
INSERT INTO lbb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ning la oroi e Iesu, la lotu teteki, ika dingla onla, la urmatana nuknuk. ");
INSERT INTO lbb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","E Iesu i han milau tetek la, pa i atongi tanla mang, “E God ka saran arop tar a rakrakai tak, sur ar warkurai a ututnala rop saot na langit pa te otleng lapiu. ");
INSERT INTO lbb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pa ning mulor han, mulor asaer a taraila miting na matanitu rop, sur la otleng anuk na kakak a asaer. Mulor baptais la ana risana e Tata, pa e Natnalik, pa Talngan Tabu. ");
INSERT INTO lbb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pa mulor asaer la sur lar mur a warwarala rop ning ia ka atong tari tamulo. I momol ot, iau ar kes taum omulo tuk ana araropna.” ");
INSERT INTO lbb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ine a kamkamna ana Wakak a Warwara oe Iesu Karisito, a Nat e God. ");
INSERT INTO lbb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A warwara ane God ning di ka tumus tari ting na buk anuna propet Aisaia mange, “Oroi, ar sune anuk a tena los warwara sur ir nigon u, pa ir atalapor anum a ngas. ");
INSERT INTO lbb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","A elngen a mainla i arkabah ting na hanua bel mang, ‘Mulor sang a ngas anuna Leklek, mulor atostos anuna ngasla.’” ");
INSERT INTO lbb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","E Jon a Tena Baptais i hanot ting na hanua bel, pa i sira baptais pa i warawai sur a tarai lar lingir a nuknukinla pa dir baptais la, pa e God ir kepsen anunla na toltol laulaula. ");
INSERT INTO lbb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","A taraila rop misaot e Jerusalem pa miting na hananuala rop tumo na papar Judia rop, la han teteki. La patuai talapor ana nunla na toltol laulaula, pa i baptais la ting na malum Jodan. ");
INSERT INTO lbb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","E Jon i mermer ana kaen di toli ana hih a kamel, pa i dot ahati ana let di toli ana palaona bulumakau. I sira ien a mumla pa polo na tatos. ");
INSERT INTO lbb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","I warwara talapor mange, “Esaning i mur tak i leklek tak. Pa bel a tolsot sur ar tudu purum par pak sen a inau ana anuna su. A natarna kol tana. ");
INSERT INTO lbb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iau ar baptais mulo ana malum, pa i ir baptais mulo ana Talngan Tabu.” ");
INSERT INTO lbb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ana pukakiarla ning e Jon i baptais a taraila, e Iesu i hanot mitisa na hanua Nasaret ana papar Galili. Pa e Jon i baptaisi ting na malum Jodan. ");
INSERT INTO lbb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ning e Iesu i saur miting la malum, i oroi a langit i sapang, pa Talngan Tabu i han purum arlar ana tabun pa i kes saot ono. ");
INSERT INTO lbb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pa elngena mainla misaot na langit i atongi mang, “U a Natuklik, a katnan u, a gas kol hom.” ");
INSERT INTO lbb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pa ono otning a Talngan Tabu i sune sen e Iesu uting na hanua bel. ");
INSERT INTO lbb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","I kes tingia diat a bonot a pukakiar pa e Satan i lari. I kes taum ona rokoiola pa angelola la nangani. ");
INSERT INTO lbb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ning di ka akas tar e Jon uting na karabus, e Iesu i hanot utumo na papar Galili, pa i warwara talapor ana Wakak a Warwara ane God, ");
INSERT INTO lbb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","i atongi mange, “A pukakiar ka hanot, pa matanitu ane God ka milau. Mulor lingir a nuknukimulo pa mulor tortorot ana Wakak a Warwara.” ");
INSERT INTO lbb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ning i asal tumokorot na hang a puka tasi Galili, i oroi tetek naur a tas, e Saimon pa e Endru kaning dia migen a uben tisa latasi, anasa diau naur a tena migen uben. ");
INSERT INTO lbb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","I atai diau mang, “Mu lamut, mu mur iau, sur ar asaer mu sur mu naur a tena ben tarai.” ");
INSERT INTO lbb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ono otning dia kamtur pas kusun a ubenla pa dia muri. ");
INSERT INTO lbb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ning i asal siklik kale, i oroi pas maleng naur a tas e Jems pa e Jon, naur a nat e Sebedi, dia kes tingui na mon pa dia suk anundia na ubenla. ");
INSERT INTO lbb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ono otning e Iesu i kabah pas diau, pa dia han kusun e tamandiau taum ana tarai a titol ting na mon, pa dia muri. ");
INSERT INTO lbb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pa la han utumo e Kapernaum, pa ana Pukakiar Sabat, e Iesu i kas uting na rumai lotu, pa i asaer la. ");
INSERT INTO lbb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","La kulkulan ana nuna asaer, anasa i asaer la arlar o esaning a warkurai kaning tana. Bel i asaer la arlar ana anunla na tena asaer tagun a warkurai la sira toli. ");
INSERT INTO lbb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ning a barsan, a mot i solongi, i kes ting na rumai lotu, ono otning i kukuk mange, ");
INSERT INTO lbb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“U e Iesu a te Nasaret. Ur tol asa omila? U hanot sur ur alaulau mila? A tasman u ot, u a Tena Totoh ane God.” ");
INSERT INTO lbb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","E Iesu i sairasi mange, “Gong u warwara! Purum kusun a barsan ning!” ");
INSERT INTO lbb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A mot i gulen rakrakai tari, pa i kukuk, pa i purum kusuni. ");
INSERT INTO lbb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A tarai rop la kulkulan kol, pa la deke artalai la mang, “Asa ine? A tona asaer. A barsan ne a warkurai kaning tana pa ana nuna warwara i kepsen sen a motla, pa la longor tana.” ");
INSERT INTO lbb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pa warwara oe Iesu i han sarara ting na hananuala rop tumo na papar Galili. ");
INSERT INTO lbb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ning e Iesu taum ana kakak a asaer la purum miting na rumai lotu, la han taum ma e Jems pa e Jon, sur uting na rumai ane Saimon pa e Endru. ");
INSERT INTO lbb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","E anmuna e Saimon, a hane i sasam, pa i borbor taum ana laplapang, pa la atai e Iesu ono. ");
INSERT INTO lbb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pa e Iesu i han teteki, i tong pas a kuna, pa i dat atur pasi, pa laplapang i rop kusuni. Pa hane ning i tabar la ana utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ning a kamis ka sup tar, a tarai la ben pas a tinsamanla rop pa la otleng ning a motla kaning onla tetek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A tarai rop miting na hanua ning, la bukus ting na taman. ");
INSERT INTO lbb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pa i alangolango pas a galis a tarai ning la sasam ana urmatana tinsaman, pa i kepsen a galis a mot. Pa i sairas a motla sur gong la warwara, anasa la tasman ot e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ana lar, e Iesu i mata pa i purum. I han uting na hanua bel pa i araring tetek e God. ");
INSERT INTO lbb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pa e Saimon taum onla ning la han taum, la seren e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pa ning la pasteteki, la atai i mange, “A tarai rop la seren u.” ");
INSERT INTO lbb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pa e Iesu i atai la mange, “Dalar han uting anal hanua milau, sur ar warawai otleng tetek la. Ine a kamkamna ning a hanot suri.” ");
INSERT INTO lbb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pa i han taltal ting na papar Galili rop. I sira warawai ting na rumai lotula anunla, pa i sira kepsen a motla kusun a taraila. ");
INSERT INTO lbb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ning a barsan, a lepra, i han tetek e Iesu, i kes ana bokona hana, pa i nunung rakrakai i mang, “Ning u mang, ur tolsot sur ur alangolango pas iau.” ");
INSERT INTO lbb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pa e Iesu i marisi, pa i tuslan a kuna, i tong a palaona, pa i atai i mang, “A mang ot, ur langolango.” ");
INSERT INTO lbb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ono otning a lepra i rop kusuni, pa i langolango ulak. ");
INSERT INTO lbb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pa e Iesu i sune seni taum ana rakrakai a warwara mang, ");
INSERT INTO lbb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Gong u atai tar tik ono. Ur han pa ur asangan u tetek a tena artabar tetek e God, pa ur saran a artabar tetek e God larning e Moses ka atong tari. Ning ur toli larne ir talapor tetek a taraila mang a palaom ka wakak ulak.” ");
INSERT INTO lbb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ika ning i purum, i warwara taltal onoi tetek a taraila. Ana toltol ning, i asanan tar e Iesu, pa bel ma i tolsot sur ir hanot talapor ting na ta hanua. I taltal kama ting na hanua bel, ika a taraila miting na hananua la hanot teteki. ");
INSERT INTO lbb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dingla na pukakiar i rop, e Iesu i han ulak utumo e Kapernaum. A tarai la longori mang ka hanot tar ting na rumai, ");
INSERT INTO lbb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","pa galis onla, la hanot teteki, pa bel al pukna tingui na rumai, pa tumo lapiu na taman otleng. Pa e Iesu i warawai ana warwara ane God tetek la. ");
INSERT INTO lbb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dingla na tarai la hanot taum ana ning a barsan a palaona i mat. Diat a barsan la losi tetek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ika bel la tolsot sur lar kas onoi, anasa a tnan kunum a tarai. La abit taum onoi usaot na rumai, pa la regen pas ning a ris a pukul a rumai tostos ana pukna ning e Iesu i tur ia. Pa la alorong purum a barsan ning a palaona i mat taum ana logo ngasna. ");
INSERT INTO lbb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ning e Iesu i oroi anunla tortorot, i atai a barsan ning a palaona i mat mange, “Natuklik, di ka kepsen tar anum na toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dingla na tena asaer tagun a warkurai la kes tingia. La nuknuk mange, ");
INSERT INTO lbb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Sur asa a barsan ne i atongi larne? I atong saksakan e God anasa i warwara larning i e God. Esi ir kepsen a toltol laulaula? E God ka.” ");
INSERT INTO lbb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aiap ka, e Iesu ka tasman tar a nuknukinla, pa i deken la mange, “Sur asa mulo nuknuk larne? ");
INSERT INTO lbb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Esi na ngas a warwara ning bel i ngangaten sur ar atongi tana barsan ne? Ar atongi mang, ‘Di ka kepsen tar anum na toltol laulaula,’ o ar atongi mang, ‘Ur kamtur, los pas a logo ngasim pa ur han’? ");
INSERT INTO lbb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ar atongi larne sur mulor tasmani mang e God ka saran tar a warkurai tetek a Nat a Barsan sur ir kepsen a toltol laulaula te lapiu.” Pa i atai a barsan ning a palaona i mat mange, ");
INSERT INTO lbb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A atai u, ur kamtur, ur kibas a logo ngasim, pa ur han uting na rumai ngasim.” ");
INSERT INTO lbb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","I kamtur, i kibas a logo ngasna, pa i purum na matanla rop. La rop la kulkulan pa la rakan aleklek pas e God mange, “Bel mila sira oroi ta utna manglarne. Ono bot ne mila oroi i.” ");
INSERT INTO lbb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E Iesu i han purum ulak utumo na ris a puka tasi Galili, pa tnan kunum a tarai la hanot teteki, pa i turpas a asaer la ana warwara ane God. ");
INSERT INTO lbb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ning i han amon, i oroi tetek e Liwai, a nat e Alpius, i kes ting na rumai a los totokom, pa e Iesu i atongi tana mang, “Ur mur iau.” Pa e Liwai i kamtur pa i muri. ");
INSERT INTO lbb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lamur, ning e Iesu i kes ana utna na hangan ting na rumai ngas e Liwai, a galis a tena los totokom pa tena laulaula, la hangan taum oe Iesu pa kakak a asaerla anunai. Anasa galis a tarai la mur e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dingla na tena asaer tagun a warkurai, ning a Parisaiola, la oroi e Iesu ning i hangan taum ana tarai laulaula pa tena kibas totokomla. La deken anuna kakak a asaerla mang, “Sur asa i hangan taum ana tena los totokomla pa tena laulaula?” ");
INSERT INTO lbb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ning e Iesu i longori, i atai la, “A dokta bel i hanot sur la ning la langolango. I hanot sur la ka ning la sasam. Bel a hanot sur a tena tostosla. A hanot sur ar kabah pas a tena laulaula.” ");
INSERT INTO lbb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","A kakak a asaerla ane Jon taum ana Parisaiola la tamai. Dingla na tarai la han tetek e Iesu, pa la dekeni mang, “Sur asaning a kakak a asaerla ane Jon pa kakak a asaerla anuna Parisaiola, la sira tamai, ika anum na kakak a asaerla bel?” ");
INSERT INTO lbb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","E Iesu i keles la mange, “Ning ta barsan ir taulai totoh, na halalna lar tamai mangmangasa ning a barsan ning kaning ot i kes taum onla? Ning kaning ot i kes taum onla, bel lar tamai. ");
INSERT INTO lbb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ika ta pukakiar ir hanot ning dir ben maskan pas a barsan ning kusun la, pa ana pukakiar ning lar bot tamai. ");
INSERT INTO lbb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Bel tik ir suk ahat ta tona diah kaen ana turai a kaen ning i taksilir, sakana a tona diah kaen ir taksilir se kusun a turai a kaen, pa kaen ning ir taksilir kol. ");
INSERT INTO lbb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pa bel tik ir tere a tona wain uting na turai a koto na wainla ning di toli ana palaona inagoi, sakana a kotola lar tapuros pa wain pa kotola lar laulau. Dir tere ot a tona wain uting na tona koto na wainla.” ");
INSERT INTO lbb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ana ning a Pukakiar Sabat, e Iesu i han potor ting na barim a wit. Ning la han amon, anuna kakak a asaerla la turpas a kumut kutus a witla. ");
INSERT INTO lbb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A Parisaiola la deken e Iesu mang, “Oroi! Sur asaning la tol a utna ning, pa bel la mur a warkurai tagun a Pukakiar Sabat?” ");
INSERT INTO lbb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","E Iesu i keles la mange, “I mangasa, belot mulo was asaning e Dewit i toli ning la murak taum ana taraila ning la armuri, pa bel al utna anlai? ");
INSERT INTO lbb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ning e Abiatar i ningnigo na tena artabar tetek e God, e Dewit i kas uting na rumai ane God pa i ien a bret ning di ka tabar tar e God ono. Pa i tabar la otleng ning la armuri. A bret ning di sairasi kusun a tarai oros. I arlar ana Warkuraila sur a tena artabarla ka tetek e God lar ieni.” ");
INSERT INTO lbb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pa e Iesu i atai la mange, “Di tol tar a Pukakiar Sabat sur ir nangan a taraila, bel a tarai lar nangan a Pukakiar Sabat. ");
INSERT INTO lbb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","I maining a Nat a Barsan ot a Leklek tagun a Pukakiar Sabat.” ");
INSERT INTO lbb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","E Iesu i kas ulak uting na rumai lotu, pa ning a barsan kaning ia a kuna i del. ");
INSERT INTO lbb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pa tarai la tai sur ta ngas ning lar tiu e Iesu ono, pa la ngoson murmuri mang ir alangolango a tinsaman ana Pukakiar Sabat, o bel. ");
INSERT INTO lbb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pa i atai a barsan ning a kuna i del mang, “Ur tur ting lanigo tanla rop.” ");
INSERT INTO lbb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pa e Iesu i deken la mange, “Asaning a Warkuraila i atongi sur dir toli ana Pukakiar Sabat? Dir tol a wakakna o dir tol a laulauna, dir alangolango tik o dir sai kol tik?” Ika bel la kelesi. ");
INSERT INTO lbb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","E Iesu i tai taltal ana balakut tetek la. I nuk maris la anasa a balanla i rakrakai. Pa i atai a barsan ning mang, “Ur kodos a kum.” I kodosi, pa kuna i tostos ulak. ");
INSERT INTO lbb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ning a Parisaiola la purum, la han tetek a taraila ane Herot, pa la warwara taum pas sur ta ngas ning lar umkol e Iesu ono. ");
INSERT INTO lbb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","E Iesu taum ana nuna kakak a asaer la han utumo purum na puka tasi, pa tnan kunum a tarai mitisa na papar Galili la muri. ");
INSERT INTO lbb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pa galis a tarai otleng la muri misaot na papar Judia pa e Jerusalem, pa miting na papar Idumea, pa mitumo na ning a ris a malum Jodan pa mitumo e Tair pa e Saidon otleng. A tnan kunum la hanot, anasa la ka longor tar a tatatnan utna ning e Iesu ka tol tari. ");
INSERT INTO lbb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ka alangolango pas a galis a tinsaman, pa la ning la kurah la sur sauran pas la, sur lar susur milau e Iesu pa lar tuki. Pa i atai anuna kakak a asaerla sur lar dulan parung a mon, sur ning a tnan kunum a tarai la kar atalilis pasi, pa ir kas onoi. ");
INSERT INTO lbb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","La ning a mot i solsolong la, ning la oroi e Iesu lar punga purum na matana. Pa motla lar kukuk mange, “U a Nat e God.” ");
INSERT INTO lbb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ika i atumarang la sur gong la atai tar tik mang, i esi. ");
INSERT INTO lbb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lamur e Iesu i han usaot na mangir, pa i kabah pas la ning i mang sur la, pa la han teteki. ");
INSERT INTO lbb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","I aslang pas ka ning a bonot pa pisir naur, pa i atong la a aposella. I kabah pas la sur lar han taum, pa ir sune sen la sur lar warawai ana warwara ane God. ");
INSERT INTO lbb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","I saran tar a rakrakai tanla sur lar kepsen a motla kusun a taraila. ");
INSERT INTO lbb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ine ning a bonot pa pisir naur ning i aslang pas la. E Saimon ning e Iesu i saran tar ning a risana otleng e Pita. ");
INSERT INTO lbb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","E Jems ditas ma e Jon naur a nat e Sebedi, ning e Iesu i saran ulak a risandiau mang e Boarnerges, a kamkamna mang naur a barsan dia manglar a pungpugur, ");
INSERT INTO lbb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endru, Pilip, Batolomiu, Matiu, Tomas, Jems a nat e Alpius, pa e Tadius, pa e Saimon ning tagun a kunum Silot, ");
INSERT INTO lbb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pa e Judas Iskariot, esaning i asobor tar e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lamur e Iesu i kas ting na rumai pa tnan kunum a tarai kale la han teteki, pa e Iesu taum ana nuna kakak a asaerla bel la tolsot sur lar hangan. ");
INSERT INTO lbb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ning anuna mangis a tarai la longor a utna ne, la han sur lar ben pasi, anasa a tarai la atongi mang bel ma i tostos a nuknukna. ");
INSERT INTO lbb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A tena asaerla tagun a warkurai mitisaot e Jerusalem, la atongi mange, “E Belsebul, a leklek anuna motla, kaning oe Iesu, pa i sira kepsen a motla ana rakrakai e Belsebul.” ");
INSERT INTO lbb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pa e Iesu i kabah la teteki, pa i warwara larlar mange, “E Satan bel ir tolsot sur ir kepsen e Satan. ");
INSERT INTO lbb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ning a tarai miting na ta matanitu lar harum artalai tanla ot, a matanitu ning bel ir tur rakrakai. ");
INSERT INTO lbb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pa ning ta kabaitamana lar harum artalai tanla ot, bel ma lar kes taum. ");
INSERT INTO lbb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ning e Satan ir harum taum ana nuna tena titolla, anuna matanitu bel ma ir tur rakrakai, ir rarop ka. ");
INSERT INTO lbb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Bel tik ir tolsot pas sur ir kas uting na rumai anuna ta rakrakai a barsan, pa ir los pas a ututnala mitisaui na rumai, ning bel ir dot akes nigon tari. Ning ot ir dot nigon tari, ir bot los a ututnala anuna barsan ning. ");
INSERT INTO lbb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A atong momoli tamulo: E God ir kepsen na toltol laulau rop anuna tarai, pa nunla na warwara laulau oe God. ");
INSERT INTO lbb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ika ning tik ir atong laulau a Talngan Tabu, bel tik ulak ma ir kepsen pasi. A toltol laulau ning ir kes tikin.” ");
INSERT INTO lbb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","E Iesu i atongi manglarne anasa la atongi ono mang, “A mot kaning ono.” ");
INSERT INTO lbb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","E tana e Iesu pa na tastasna la hanot, la tur tumo lapiu pa la arsune suri. ");
INSERT INTO lbb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A kunum a tarai la kes talilis pasi pa la atai i mang, “E tnam pa na tastasim la ne lapiu. La tai sur u.” ");
INSERT INTO lbb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pa i deken la mang, “Esi e nang, pa esi la na tastasik?” ");
INSERT INTO lbb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pa i tai tetek la rop ning la kes talilis pasi. Pa i atongi larne, “Oroi, la ne, e nang pa na tastasik. ");
INSERT INTO lbb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anasa esining i sira mur a nuknuk e God, i ka ning a tasik barsan, pa tasik hane pa e nang.” ");
INSERT INTO lbb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","E Iesu i tur ulak pas a asaer tumokorot na puka tasi. Pa tnan kunum a tarai la tur talilis pasi. Pa i kas uting na mon pa i kes sa na puka tasi. A tnan kunum a tarai rop la tur tumokorot na hang. ");
INSERT INTO lbb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pa i asaer la ana galis a utna ana warwara larlar. I asaer la mange, ");
INSERT INTO lbb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Longor! A tena omomai i han sur ir sapran a pat a witla. ");
INSERT INTO lbb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ning i sapran amon la, dingla la punga ting na ngas pa manila la rowoi ot pa la ien sen la. ");
INSERT INTO lbb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dingla otleng la punga ting na pukna ning i hatat, pa bel al galis a piu ono, pa la gomo kapit, anasa a piu bel i but. ");
INSERT INTO lbb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ika ning a kamis i sasai ot, la main pa la marang rop, anasa bel al wakirinla. ");
INSERT INTO lbb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dingla na patna otleng la punga tar ting na tinine rosrosla, pa rosrosla la gomo ot pa la rau alar pas la, pa bel la wai. ");
INSERT INTO lbb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pa dingla na patna otleng la punga ting na wakak a piu. La gomo pa la itna amon pa la wai, dingla natol a bonot a wanala, dingla diono na bonot, pa dingla takai a mar.” ");
INSERT INTO lbb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lamur e Iesu i mang, “Esining a talngana kaning, i wakak ning ir longor ono.” ");
INSERT INTO lbb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ning e Iesu kama taum ana ning a bonot pa pisir naur a kakak a asaer pa dingla na tarai la kes, la dekeni ana warwara larlarla. ");
INSERT INTO lbb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Pa i atai la mang, “E God ka saran tar a tastasmai tamulo sur mulor talapor ana ututnala ana nuna matanitu, ning nating i kes kumna. Ika tetek a tarai masik, dir asaer la ona utnala rop ana warwara larlarla, ");
INSERT INTO lbb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","sur, ‘lar tai pa lar tai, ika bel lar oroi lalani, lar longor pa lar longor, ika bel lar longor lalani, pa bel lar tastasmai ono. Sakana lar tasman lalani, pa lar talingir, pa ir kepsen a toltol laulau anunla.’” ");
INSERT INTO lbb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pa e Iesu i deken la mange, “Bel mulo talapor ana kamkama warwara larlar ne? Mulor tasman mangmangasa a kamkama ana dingla na warwara larlar otleng? ");
INSERT INTO lbb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A tena omomai i arlar ana tena warawai ning i asaer ana warwara ane God. ");
INSERT INTO lbb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A pat a witla ning la punga ting na ngas, la arlar ana tarai ning la longor a warwara, pa e Satan i hanot, pa i kepsen a warwara miting na balanla. ");
INSERT INTO lbb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Dingla na tarai otleng la arlar ana pat a witla ning la punga ting na pukna ning i hatat. Ning la longor a warwara la tong akesi ana gasgas. ");
INSERT INTO lbb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ika a warwara bel i kes rakrakai ting na balanla, bel lar tur bongnan la arlar ana witla ning bel al wakirinla. Ning a mamahatla ir hanot, pa dir alaulau la anasa la tortorot ana warwara ane God, lar punga kapit. ");
INSERT INTO lbb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Dingla na tarai la arlar ona pat a witla ning la punga tar ting na tinine rosrosla. La longor a warwara, ");
INSERT INTO lbb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ika a nuknukinla sur a wakak a keskes te lapiu, pa nuknuk otleng sur anunla na gongon ning i asongo a nuknukinla, pa nuknuk sur a ututnala masik, la rau alar a warwara ane God, pa bel i wai. ");
INSERT INTO lbb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dingla na tarai la arlar ana pat a witla ning la punga ting na wakak a piu. La longor a warwara pa la muri, pa la wai natol a bonot, o diono na bonot, o takai a mar a wana.” ");
INSERT INTO lbb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pa e Iesu i atai la mange, “Bel tik ir los pas ta lam pa ir aroh alari ana paket, pa bel ir suahi otleng ting nahai a logo. Ir suahi ot saot na turtur ngasna. ");
INSERT INTO lbb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A ututnala rop ning i kes kumna, lamur ir kes puasa. Pa ututnala rop ning di bunur tari, lamur ir hanot talapor. ");
INSERT INTO lbb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Esining a talngana kaning, i wakak ning ir longor ono.” ");
INSERT INTO lbb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","E Iesu i atai la mange, “Mulor nuknuk wakak ana saning mulo longori. Ning mulor longor wakak, dir saran a wakak a tastasman tamulo. Pa mulor kibasi, ir itna kol. ");
INSERT INTO lbb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Esining i tong akes anuk a asaerla, dir tabar ulaki ana wakak a nuknuk, pa tik ning bel i tong akes anuk a asaerla, dir kepsen otleng anuna siklik wakak a nuknuk kusuni.” ");
INSERT INTO lbb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","E Iesu i atongi otleng mange, “A matanitu ane God i arlar ana barsan ning i sapran tar a pat a witla ting na kabalapiu. ");
INSERT INTO lbb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ning i borbor ana moromla pa i sira mata ana kabakiarla, a pat a witla la pusa ot pa la gomo, pa barsan bel i tasmani mang la pusa ot pa la gomo mangmangasa. ");
INSERT INTO lbb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A piu ot i agomo a rakai a wit larne: a pakana i pusa nigo, pa lamur a sarna i gomo ot, pa patna i mur ot. ");
INSERT INTO lbb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ning a patnala ka makos pa kalang a sol ka hanot, a barsan ir pirat pas la.” ");
INSERT INTO lbb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","E Iesu i atai la mange, “A matanitu ane God i arlar ana sa? Esi na warwara larlar ar atongi sur ar papak ana matanitu ane God? ");
INSERT INTO lbb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I arlar ana pat a mastad. I natarna kol tana pat a rakaila rop, ning di omani ting na kabalapiu. ");
INSERT INTO lbb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ning di ka oman tari, pa i gomo, i itna kol tana rakai a hanganla rop pa i suah sarara a tatatnan rakrakana, pa manila la sira tol pios saot na rakrakana ning i molmol.” ");
INSERT INTO lbb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","E Iesu i warwara tetek la ana galis a warwara larlar ning i arlar ana nunla na mananos, ");
INSERT INTO lbb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","pa bel i warwara tetek la ana ta maskana warwara, a warwara larlarla rop ka. Pa ning la kama taum ana nuna kakak a asaer lar kes, ir papak bot ana kamkama warwara larlarla. ");
INSERT INTO lbb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ning a rah ma ana pukakiar ning, e Iesu i atai anuna kakak a asaerla mang, “Dalar han lakai utumo na ris a puka tasi.” ");
INSERT INTO lbb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","La kas tetek e Iesu ting na mon, pa la han kusun a kunum a taraila. Pa dingla na mon otleng la han taum onla. ");
INSERT INTO lbb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pa rakrakai a wuwu i hanot, pa top i song a mon pa siklik ir murung. ");
INSERT INTO lbb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","E Iesu i borbor tumo lamur ana mon pa i ululnge ana pilo. A kakak a asaer la amata i, pa la atai i mange, “Tena Asaer, dala kar hirua! Mangmangasa, bel u maris dala?” ");
INSERT INTO lbb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pa i kamtur, i sairas a wuwu, pa i atai a top, “Ur manah! Ur mililo.” Pa wuwu i manah pa tasi i mililo rop. ");
INSERT INTO lbb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","E Iesu i atai la mange, “Sur asaning mulo matmataut? I mangasa, belot mulo tortorot?” ");
INSERT INTO lbb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","La matmataut kol, pa la deken artalai la mange, “Esi na ngas a barsan ne? A wuwu pa top dia longor tana.” ");
INSERT INTO lbb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","E Iesu taum ana nuna kakak a asaerla la sot ting na ris a puka tasi Galili, ting na papar anuna tarai Gerasa. ");
INSERT INTO lbb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ning i purum kusun a mon, ning a barsan miting na kulam ngas a minatla, ning a mot i solong tari, i han barati. ");
INSERT INTO lbb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A barsan ning i laun ka ting na kulam ngas a minatla. Bel tik i tolsot sur ir dot akes pasi, a sen otleng bel i to pasi. ");
INSERT INTO lbb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Di sira dot naur a kuna pa naur a hana ana senla, ika i sira dat kutus ka a sen kusun naur a kuna, pa i sira sai siksiklik a sen miting na naur a hana. Pa bel tik i tolsot sur ir amolmol pasi. ");
INSERT INTO lbb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pa i sira kukuk mokos ana iahkamisla pa ana moromla ting na kulam a minatla, pa ting na mangirla otleng, pa i kotkot a palaonala ana hatatla. ");
INSERT INTO lbb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ning i oroi bakbak pas e Iesu, i dun teteki pa i kes ana naur a bokona hana salanigo tana. ");
INSERT INTO lbb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","A barsan ning i kukuk kol mange, “Iesu, a Nat e God esaning i Leklek Kol, asaning ur toli hok? A nunung u ana risana e God sur gong u akadik iau.” ");
INSERT INTO lbb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","I atongi larne, anasa e Iesu ka atai tari mang, “U a mot, purum kusun a barsan ne!” ");
INSERT INTO lbb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pa e Iesu i dekeni mange, “Esi na risam?” I kelesi mang, “A risak a liur a mot, anasa mila galis kol.” ");
INSERT INTO lbb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pa i nunung rakrakai e Iesu sur gong i sune sen la kusun a pukna ning. ");
INSERT INTO lbb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A kaba liur a boroi la hangan ting na mangir ning i milau. ");
INSERT INTO lbb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A motla la nunung rakrakai e Iesu mang, “Ur sune mila tetek a boroila sur milar kas uting onla.” ");
INSERT INTO lbb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","E Iesu i malmaling sen la. La purum kusun a barsan ning, pa la kas tar ana boroila. A boroila la liu purum uting na palis sur utumo na puka tasi, pa la dom rop. A boroila rop la arlar ana naur a rip. ");
INSERT INTO lbb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","La ning la tai alar a boroila, la dun ulak, pa la atatai ana utna ne ting na hanua ngasinla pa dingla na hananuala otleng. Pa tarai la han sur lar oroi asaning i hanot. ");
INSERT INTO lbb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ning la hanot tetek e Iesu, la oroi a barsan ning a kaba liur a motla la ka purum tar kusuni. Kaning i kes, ka pipis pas pa ka mananos ulak. Pa la matmataut. ");
INSERT INTO lbb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","La oroi asaning e Iesu i toli, pa la atai a tarai ana utna ning i hanot ana barsan ning a motla la solong tari, pa ana boroila otleng. ");
INSERT INTO lbb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lamur la nunung ngongos e Iesu sur ir han kusun anunla papar. ");
INSERT INTO lbb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ning e Iesu i kas ana mon, a barsan ning nating a motla la solong tari, i nunung e Iesu sur diar armuri. ");
INSERT INTO lbb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ika e Iesu bel i malmaling, i atai i ka mange, “Ur han uting na rumai ngasim tetek a maimla, pa ur atai la ana tnan utna ning a Leklek ka tol tari hom, pa ana nuna marmaris tetek u.” ");
INSERT INTO lbb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pa i han, pa i warwara amon utumo na papar Dekapolis ana tnan utna ning e Iesu ka tol tari onoi. Pa tarai rop la kulkulan. ");
INSERT INTO lbb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","E Iesu i kas ana mon pa i ulak uto na ris a puka tasi. Ning i kes tumokorot, a tnan kunum a tarai la atalilis pasi. ");
INSERT INTO lbb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ning a ningnigo tagun a rumai lotu a risana e Jairus, i hanot. Ning i oroi e Iesu, i punga na hanrawai salanigo tana. ");
INSERT INTO lbb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Pa i nunung kol mange, “A natuk hane, milau ir mat. Lamut, dar han pa ur suah naur a kum saot ono, sur ir langolango ulak pa ir laun.” ");
INSERT INTO lbb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ning dia han taum, a kunum a tarai la mur e Iesu, pa la tur alar pasi. ");
INSERT INTO lbb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ning a hane tingia i sasam ana tinsaman a suluk arlar ana ning a bonot pa pisir naur a rau. ");
INSERT INTO lbb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ka han pas tetek a galis a doktala sur lar nangani, ika la saran a tnan kankan teteki pa la amus pas anuna mani. I rakrakai kol ma a tinsaman ning ono. ");
INSERT INTO lbb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ning i longor a warwara oe Iesu, i nuki mang, “Ning ar tuk ka anuna mermer ar langolango ulak.” Pa i han na tinine a kunum a tarai, tumo lamur ta e Iesu, pa i tuk anuna saket. ");
INSERT INTO lbb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pa suluk i manah kakat, pa hane ning i kilang a palaona mang a tinsaman ka rop. ");
INSERT INTO lbb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ning e Iesu i kilangi mang a rakrakai i purum kusuni, i talingir na tinine kunum a tarai, pa i deke mange, “Esining i tuk anuk a kaen?” ");
INSERT INTO lbb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Anuna kakak a asaer la atai i mang, “U oroi ot a kunum a tarai ne la tur talilis pas u, sur asaning u kabah mang, ‘Esining i tuk iau?’” ");
INSERT INTO lbb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ika e Iesu i tatatai taltal sur esining i tuk tari. ");
INSERT INTO lbb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A hane ning i matmataut, pa i koloron, anasa i tasman a utna ning i hanot ono. I han tetek e Iesu, i punga salanigo tana, pa i atong puasa a utna ning ka tol tari. ");
INSERT INTO lbb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pa e Iesu i atai i mange, “Natuklik, anum a tortorot ka alangolango pas u. Ur han taum ana balmolmol, anum a tinsaman ka rop.” ");
INSERT INTO lbb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ning e Iesu kaning ot i warwara, dingla na tarai la hanot miting na rumai ane Jairus, a ningnigo tagun a rumai lotu, pa la atai i mang, “Sur asaning u amolot a Tena Asaer? E natum hane ka mat.” ");
INSERT INTO lbb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","E Iesu bel i nuk pas a warwara ning, i atai ka e Jairus mang, “Gong u matmataut. Ur tortorot ka.” ");
INSERT INTO lbb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bel i malmaling pas tik sur ir muri, ika i ben pas e Pita, e Jems ditas ma e Jon. ");
INSERT INTO lbb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pa ning la hanot ting na rumai ane Jairus, e Iesu i longor a totbor, pa aregaia na domos. ");
INSERT INTO lbb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I kas pa i atai la mange, “A totbor pa tintinangis na saining? A kaklik ning bel i mat, kaning ka i borbor duman.” ");
INSERT INTO lbb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","La malani ka. I sune purum sen la rop, i ben pas a tamana kaklik pa e tana, pa ditol otleng ning ditol han taum ono, pa la kas tetek a kaklik. ");
INSERT INTO lbb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","E Iesu i tong pas a kuna kaklik hane ning, pa i atai i mange, “Talita koum!” A kamkama warwara ne, “Hanelik, a atai u, ur kamtur.” ");
INSERT INTO lbb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aiap ka i kamtur pa i han taltal. A hanelik ning ka takai a bonot pa pisir naur a rau anunai. Pa la kulkulan kol. ");
INSERT INTO lbb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","E Iesu i sairas rakrakai tar la sur gong la warwara ana utna ne. Pa i atai diau sur diar tabar a hanelik ning. ");
INSERT INTO lbb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E Iesu taum ana nuna kakak a asaer la han mitingia pa la hanot ting na hanua ngas e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ana Pukakiar Sabat i asaer a taraila ting na rumai lotu, pa galis a tarai ning la longori la kulkulan kol, pa la kabah mang, “A barsan ne i kibas a tastasmaila ne tahaia? Esi na ngas a tastasman ning di ka saran tari tana sur ir tol a tatatnan utna na kulkulan? ");
INSERT INTO lbb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ai a tena tol rumai ka, a nat e Maria. Na tastasnala otleng, e Jems, Josep, Judas pa e Saimon, pa na tastasna hane kane ka dala laun taum.” Pa bel la gas ono. ");
INSERT INTO lbb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","E Iesu i atai la mang, “Di sira hanrawai a propet ting na hanua masik, ika la ot ting na hanua ngasna, na mainala pa la ot ting na rumai ngasna bel la hanrawai i.” ");
INSERT INTO lbb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E Iesu bel i tolsot pas al galis a utna na kulkulan tingia, ika i suah naur a kuna ana dingla na tinsaman, pa i alangolango pas la. ");
INSERT INTO lbb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pa e Iesu i kulkulan anasa bel la tortorot ono. Lamur e Iesu i han uting na hananuala pa i asaer a taraila. ");
INSERT INTO lbb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I kabah pas ning a bonot pa pisir naur a kakak a asaerla, pa i sune naunaur onla, pa i saran tar a rakrakai tanla sur lar kepsen a motla. ");
INSERT INTO lbb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","I atai la mang, “Gong mulo los tar al utna ting na numulo a tinan, mulor los ka a bulse. Gong mulo los al utna na hangan, gong ta bek pa gong mulo los tar al mani ting na bak. ");
INSERT INTO lbb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mulor han ka ana su ting na hamulo, pa gong mulo los al kelkeles.” ");
INSERT INTO lbb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","I atai la otleng mange, “Ning mulor kas ting na ta rumai, mulor kes ot tingia tuk ana pukakiar ning mulor han kusun a hanua ning. ");
INSERT INTO lbb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ning ta hanua bel lar gas pas mulo, pa bel lar longor anumulo na warwarala, ning mulor han kusun a hanua ning, mulor tang sen a kubus kusun a hamulo, sur a asilang na atumarang tetek la.” ");
INSERT INTO lbb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pa la han pa la warawai tetek a taraila sur lar lingir a nuknukinla. ");
INSERT INTO lbb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","La kepsen a galis a mot, la sabar a galis a tinsaman ana wel, pa la alangolango pas la. ");
INSERT INTO lbb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","E King Herot i longor a warwara oe Iesu, anasa a tarai la rop la ka tasman e Iesu. Dingla la atongi ono mang, “A barsan ning, e Jon a Tena Baptais, ka kamtur ulak kusun a minat. I maining i tol a ututnala na kulkulan.” ");
INSERT INTO lbb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dingla la mang, “Ai e Elaija.” Dingla otleng la atongi ono mang, “E Iesu i ning a propet arlar ana propetla tagun nating.” ");
INSERT INTO lbb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ika ning e Herot i longor a ututnala ne oe Iesu, i atongi mange, “Ia ka umsem tar ana ruana e Jon, pa ka kamtur ulak kusun a minat!” ");
INSERT INTO lbb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Lanigo e Herot i sune sen anuna tena harumla pa la tong pas e Jon, la doti pa la akasi ting na karabus. E Herot i toli larne anasa e Jon ka usur tari ono mang, “Bel i tostos ning u taulai e Herodias, e harimlik.” E Jon i atongi larne anasa e Herot ka dat pas e Herodias, a hane ane Pilip e tasnalik, pa i taulai i. ");
INSERT INTO lbb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","E Herodias i nget e Jon pa i mang sur ir umkoli anasa i warwara ondiau ana nundiau a tinaulai. Bel i tolsot pasi sur ir umkoli, ");
INSERT INTO lbb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","anasa e Herot i matatan e Jon, pa i tasmani mang i a wakak a barsan pa tena tostos. Pa e Herot i tai alar e Jon. I gas sur ir longor anuna warwarala, maika i loklokron a nuknukna ono. ");
INSERT INTO lbb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","E Herot i aslang pas a pukakiar ning di agoni ono, pa i tol a tnan ngasa sur a ningnigola miting na nuna matanitu, pa ningnigola anuna tena harumla, pa ningnigola mitisa e Galili. E Herodias i nuk pas ning a ngas sur dir umkol e Jon. ");
INSERT INTO lbb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ning la kes ana ngasa, e natna hane e Herodias i kas pa i tortor. E Herot pa taraila ning la hangan taum ano, la gas kol ono. Pa i atai a basbas ning mange, “Ar tabar u ana ta utna ning ur mang suri tak.” ");
INSERT INTO lbb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pa i lele rakrakai tana mange, “Asa kama ning ur nunung iau suri ar sarani ka. Ning ur nunung iau sur ta tuk a matanitu ar sarani ka.” ");
INSERT INTO lbb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pa i han tetek e tana pa i dekeni mang, “Asaning ar nunung suri?” E tana i kelesi mang, “Ur nunungi sur a pukul e Jon a Tena Baptais.” ");
INSERT INTO lbb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aiap ka a basbas ning i kas tetek e King Herot, pa i atai i mange, “Ano otne a mang sur ur suah a pukul e Jon a Tena Baptais ting na ta pelet pa ur sarani tak.” ");
INSERT INTO lbb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A king i balmaris kol. Ika bel ma i tolsot sur ir ngongoio, anasa ka lele tar mang, asa kama ning ir nunung suri, ir sarani ka, pa tarai ning la kes taum ono ting na ngasa, la ka longor tar anuna warwara. ");
INSERT INTO lbb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","I sune kapit ning a tena harum sur ir los tar a pukul e Jon teteki. A tena harum i kas uting na karabus, pa i umsem ana ruana e Jon. ");
INSERT INTO lbb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","I suah a pukulna ting na pelet pa i sarani tana basbas, pa i sarani ta e tana. ");
INSERT INTO lbb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pa ning a kakak a asaerla ane Jon la longori, la hanot pa la los pas a minatna pa la akasi ting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A aposella, la atalilis pas e Iesu, pa la atai i ana ututna rop ning la ka tol tari, pa la ka asaer tar a taraila ono. ");
INSERT INTO lbb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pa e Iesu i atai la, “Mulo lamut, dalar han uting na hanua bel, sur mulor manah pas.” I atongi larne anasa a galis a tarai la hananot, pa bel ta taim sur e Iesu pa nuna aposella lar hangan ono. ");
INSERT INTO lbb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pa la kas ana mon pa la han uting na hanua bel. ");
INSERT INTO lbb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A galis a tarai ning la oroi la ning la soi, la oroi lalan pas e Iesu taum ana nuna kakak a asaerla. La dun kusun a hananuala, pa la nigo ot uting na pukna ning lar sot ia. ");
INSERT INTO lbb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ning e Iesu i sot tingia, i oroi a tnan kunum a tarai. I maris kol la, anasa la arlar ana sipsipla ning bel ta tena tai alar anunlai. Pa i turpasi sur ir asaer la ana galis a ututnala. ");
INSERT INTO lbb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ning ka rah anuna kakak a asaerla la han teteki, pa la atai i mang, “A hanua bel ka ine, pa ka rah otleng. ");
INSERT INTO lbb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ur sune sen a taraila ne sur lar han uting na hananuala milau, pa tatatnan hanua otleng sur lar lou pas al utna na hangan sur lar ieni.” ");
INSERT INTO lbb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","E Iesu i keles la mange, “Mulo ot mulor tabar la.” La atai i mang, “Ning milar tabar la, ir arlar ana arlou tagun a siwal a kalang. Mangasa, milar sai a tnan mani ne? ” ");
INSERT INTO lbb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","E Iesu i deken la mang, “Naisa bret kaning mulo losi? Mulor han pa mulor tai.” Ning la ka talapor pas, la atai e Iesu mang, “Dilima na bret pa naur a sis.” ");
INSERT INTO lbb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pa e Iesu i sune anuna kakak a asaerla sur lar atai a taraila, sur lar kes anal kunum ting na ulai. ");
INSERT INTO lbb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pa la kes ana taktakai kunum, dingla na kunum taktakai a mar, pa dingla dildilima na bonot. ");
INSERT INTO lbb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pa e Iesu i kibas pas dilima na bret pa naur a sis, i tadai usaot na langit, i atong wakak tetek e God onoi. I kibik dilima na bret, pa i sarani tan anuna kakak a asaerla sur lar asalar a taraila ono. I tabar la otleng ana naur a sis. ");
INSERT INTO lbb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","La rop la hangan pa la masur. ");
INSERT INTO lbb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pa la song bukus pas ning a bonot pa pisir naur a rat ana mah a bret pa sis. ");
INSERT INTO lbb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A wawas ana tarai ka i arlar ana dilima na rip, pa gurarala pa kakakla otleng la hangan taum onla. ");
INSERT INTO lbb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aiapiap ka e Iesu i sune sen anuna kakak a asaerla sur lar kas ana mon pa lar nigo utumo e Betsaida tumo na ris a puka tasi. Pa i, i kes ot sur ir sune sen a tarai. ");
INSERT INTO lbb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ning a tarai la ka han sarara, e Iesu i han usaot na mangir sur ir araring. ");
INSERT INTO lbb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ning ka rah morom, a mon i han potor a puka tasi, pa e Iesu kama kaning i kes tumokorot latasi. ");
INSERT INTO lbb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","E Iesu i oroi la mang ka tekes la ana ulusu, anasa a wuwu i harum misa lanigo. Ana lar, e Iesu i han saot na palai a puka tasi tetek la. Pa siklik ir han bolos la. ");
INSERT INTO lbb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ning la oroi pasi ning i han saot na palai a puka tasi, la nuki mang a ingun, pa la kukukuk, ");
INSERT INTO lbb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","anasa la rop la oroi, pa la matmataut kol. Pa e Iesu i warwara kapit tetek la mang, “Mulor kosom, iau ka ne. Gong mulo matmataut.” ");
INSERT INTO lbb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","E Iesu i kas tetek la uting na mon, pa wuwu i rop kakat. Pa la kulkulan kol, ");
INSERT INTO lbb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","anasa bel la tastasman wakak ana utna na kulkulan ning e Iesu ka tol tari ana dilima na bret pa naur a sis. Anasa a balanla i rakrakai. ");
INSERT INTO lbb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ning la ka han lakai tumo na ning a ris a puka tasi, la sot tumo na papar Genesaret pa la dot akes tar a mon. ");
INSERT INTO lbb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ning la purum kusun a mon, a tarai la oroi lalan kapit pas e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","La dun sur a tinsamanla ting na hananuala rop ting na papar ning. La los a tinsamanla ana logola teteki, ana esi na hanua ning la longori mang e Iesu kaning ia. ");
INSERT INTO lbb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ana nanatar a hananua pa tatatnan hananua ning e Iesu i han ia, la aborbor a tinsamanla ting na arpotor a hanua. Pa tinsamanla la nunung e Iesu sur lar tuk tar ka a tuka kaen anunai. La rop ning la tuk tari la langolango. ");
INSERT INTO lbb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A Parisaiola pa tena asaerla tagun a warkurai misaot e Jerusalem, la han taum tetek e Iesu, ");
INSERT INTO lbb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","pa la oroi dingla na kakak a asaer ane Iesu, la hangan ka ana dur a kunla, bel la gos nigon pas a kunla. ");
INSERT INTO lbb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A Parisaiola pa tarai Juda rop bel lar hangan ning bel la gos kunla, anasa la sira mur a asaerla ana nunla a tarai tagun nating. ");
INSERT INTO lbb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ning la ulak miting na pukna na sisiurai, lar gos nigon pas ot a kunla, lamur lar hangan. A galis a asaerla otleng la sira muri, la sira gos a kapla, a kurola pa ketella. ");
INSERT INTO lbb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A Parisaiola pa tena asaerla tagun a warkurai la deken e Iesu mang, “Sur asaning anum a kakak a asaerla bel la sira mur a asaerla ana nundala na tarai tagun nating? La hangan ka ana dur a kunla.” ");
INSERT INTO lbb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pa e Iesu i keles la mange, “A warwara ane Aisaia i momol ot, ning i warwara na propet nigo tar omulo a tena asasongola mang, ‘A tarai ne la hanrawai iau ka ana pahanla, ika a balanla i bakbak kol kusun iau. ");
INSERT INTO lbb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","La lotu oros ka tetek iau, anasa la asaer a taraila ana warkuraila ka anuna taraila.’ ");
INSERT INTO lbb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mulo ka han kusun tar a Warkuraila ane God, pa mulo mur kama asaer anuna taraila.” ");
INSERT INTO lbb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pa e Iesu i atai la mange, “A momolna ot, mulo longor orsan a warkurai ane God, sur mulor mur a asaerla ana numulo a tarai tagun nating. ");
INSERT INTO lbb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","E Moses i atongi mange, ‘Ur hanrawai e tamam pa e tnam.’ Pa i atongi otleng mang, ‘Esining ir warwara laulau oe tamana pa e tana dir umkoli.’ ");
INSERT INTO lbb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ika mulo, mulo asaer a taraila mang, i wakak ka ning tik ir atai e tamana pa e tana mang, ‘Asaning ar nangan mu ono, ia ka saran tari tetek e God.’ ");
INSERT INTO lbb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ana asaer ning, mulo sairasi sur gong i nangan e tamana pa e tana. ");
INSERT INTO lbb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ning mulo toli larning, mulo anatarna pas a warwara ane God, pa mulo mur ot a asaerla ning mulo kibasi tan anumulo na tarai tagun nating. Pa galis a ututna otleng larne ning bel i tostos mulo sira toli.” ");
INSERT INTO lbb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","E Iesu i kabah ulak a kunum a tarai teteki, pa i atongi mang, “Mulo rop mulor longor iau, pa mulor talapor ana nuk a warwara. ");
INSERT INTO lbb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Asaning tik ir ien pasi pa i kas ting na balana, bel ir aduri na matana e God. Ika asaning i purum kusun a nuknukna, i ning ir aduri na matana e God”. ");
INSERT INTO lbb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ning e Iesu i han kusun a kunum a taraila, pa i kas uting ui na rumai, anuna kakak a asaer la dekeni ana warwara larlar ne. ");
INSERT INTO lbb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Pa i atai la mange, “I mangasa mulo otleng bel mulo talapor? I mangasa bel mulo tasmani mang a ututnala rop ning i kas ting na balan tik, bel ir aduri na matana e God? ");
INSERT INTO lbb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Anasa bel i kas uting na nuknukna, i kas ka uting na balana pa ir kepseni.” Ning i atong a warwara ne, i atong talapori mang a utna na hangan rop i wakak. ");
INSERT INTO lbb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","I atongi otleng mange, “A utna ning i purum pas miting na nuknukin tik, i ning ir aduri. ");
INSERT INTO lbb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ine a ututnala ning i sira purum miting na nuknuk a taraila: a nuknuk laulau, na toltol a pamuk, a kinkinau, umkol a mainla, a toltol laulau ana ta hane anuna tik o ta barsan anuna tik, ");
INSERT INTO lbb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","a toltol a muk, a laulau a ginina, a asasongo, a nuknuk sur a toltol ning a tarai lar meme ono, a ram, a arle, a toltol na dat abarah a pukulundi, pa longlong a toltol. ");
INSERT INTO lbb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A ututna laulaula rop ne la purum miting na nuknuk a taraila, pa ir adur la na matana e God.” ");
INSERT INTO lbb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E Iesu i han mitingia, pa i hanot milau a hanua Tair. I kas uting na ning a rumai. Bel i mang sur tik ir tasmani, ika bel i tolsot sur ir mumun. ");
INSERT INTO lbb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ning a hane, a natna hane a mot kaning ono. Ning i longor a warwara oe Iesu, aiap ka i han pa i punga tuntudu salanigo ta e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A hane ning, a hane Ponisia miting na papar Siria, bel a hane Juda. I nunung e Iesu sur ir kepsen a mot kusun e natnalik. ");
INSERT INTO lbb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pa e Iesu i atai i mang, “Dir tabar masur nigon a kakakla. Bel i tostos sur dir los pas a utna na hangan ana kakakla pa dir migeni tana papla.” ");
INSERT INTO lbb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pa hane i kelesi mang, “Leklek, a momolna ot ning. Ika a papla otleng ting nahai a logo, la sira ien a mumut a utna na hangan ana kakakla.” ");
INSERT INTO lbb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pa e Iesu i atai i mange, “Ana num a wakak a arkeles, ur han ka, a mot ka purum tar kusun e natumlik.” ");
INSERT INTO lbb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ning a hane i ulak, i oroi e natnalik, kaning i borbor tar ting na logo ngasna. A mot ka purum kusuni. ");
INSERT INTO lbb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","E Iesu i han kusun a hanua Tair pa i han potor e Saidon sur a puka tasi Galili, pa i hanot ting na papar Dekapolis. ");
INSERT INTO lbb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A tarai la ben pas ning a barsan a talngana kutkut tetek e Iesu, pa la nunungi sur ir suah a kuna ono. ");
INSERT INTO lbb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","E Iesu i ben masik pasi kusun a kunum a tarai, pa i suah naur a pitlai kuna ting na naur a talngana barsan ning. Lamur i namis pas, pa i tong a laigerem a barsan ning. ");
INSERT INTO lbb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","I tadai usaot na langit, i los wuwu pas, pa i atai i mang, “Epata!” A kamkamna mange: “Ur Sapang!” ");
INSERT INTO lbb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pa talngana i talapor, a laigeremna i tapalas pa i warwara talapor kakat. ");
INSERT INTO lbb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pa e Iesu i sairas rakrakai a taraila sur gong la atai tar tik ono. Ika ning i sairas la, bel la longor pasi, a warwara ono i han sarara ka. ");
INSERT INTO lbb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","La ning la longor a utna ne, la kulkulan kol ono, pa la atongi larne, “E Iesu i tol wakak pas a ututnala rop. I awakak pas a talngana kutkutla sur lar longor, pa ngatlaula sur lar warwara!” ");
INSERT INTO lbb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na tinine pukakiarla ning, a tnan kunum a tarai la hanot taum, pa bel al utna na hangan sur lar ieni. E Iesu i kabah pas anuna kakak a asaerla teteki pa i atai la mang, ");
INSERT INTO lbb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“A maris kol a taraila ne, anasa la ka kes taum hok te natol a pukakiar, pa bel al utna sur lar ieni. ");
INSERT INTO lbb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ning ar sune oros sen la sur anunla na rumai taum ana munurak, lar suah mat ting na ngas, anasa dingla onla, la hanot miting na bakbak.” ");
INSERT INTO lbb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Anuna kakak a asaer la dekeni mang, “Mitaha al utna na hangan sur dalar tabar la ono? Anasa a hanua bel ka ine.” ");
INSERT INTO lbb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","E Iesu i deken la mang, “Naisa na bret kaning mulo losi?” La kelesi mang, “Mais ka.” ");
INSERT INTO lbb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","E Iesu i atai a kunum a tarai sur lar kes ting na piu. I kibas pas mais a bret, i atong wakak pas onoi tetek e God, i kibiki pa i sarani tan anuna kakak a asaerla, sur lar tabar a taraila ono. Pa la tolsoti. ");
INSERT INTO lbb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","La los pas naisa na nanatar a sis otleng, pa i atong wakak pas ono, pa i sarani sur lar asaurani tana taraila. ");
INSERT INTO lbb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A tarai la hangan pa la masur. Lamur a kakak a asaerla la song bukus pas mais a rat ana mah a utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A wawas ana tarai ka i arlar ana diat a rip, ika a gurarala pa kakakla otleng la hangan taum onla. Pa lamur e Iesu i sune sen la. ");
INSERT INTO lbb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","E Iesu taum ana nuna kakak a asaer la kas uting na mon, pa la han utumo na papar Dalmanuta. ");
INSERT INTO lbb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A Parisaiola la hanot tetek e Iesu pa la arlak na warwara tataum ono. La mang sur lar tohoi. I maining la nunungi sur ir tol ta akinalang sur ir asangani mang i titol ana rakrakai e God. ");
INSERT INTO lbb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","E Iesu i los wuwu pas pa i mang, “Sur asa a tarai tagun anone la nunung sur ar tol ta akinalang? A atong momoli tamulo, bel dir tol ta akinalang tamulo.” ");
INSERT INTO lbb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pa i kas ulak ana mon, pa la han kusun la utumo na ris a puka tasi. ");
INSERT INTO lbb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A kakak a asaerla la dumani sur lar los al bret, takai sot ning la losi ting na mon. ");
INSERT INTO lbb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pa e Iesu i warwara na atumarang tetek la mang, “Mulor tumarang ana is anuna Parisaiola pa e Herot.” ");
INSERT INTO lbb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pa la warwara taum ana kamkama warwara ane Iesu, pa la atongi mang, “I atongi larning, anasa bel al bret andalai.” ");
INSERT INTO lbb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","E Iesu i tasman anunla na warwara pa i atai la mang, “Sur asaning mulo warwara artalai omulo ning bel al bret? Bel mulo tasmani, pa belot mulo talapor? I mangmangasa ning mulo arakrakai a balamulo sur gong mulo kibas anuk na asaerla? ");
INSERT INTO lbb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A matamulo i kes, ika bel mulo tai ono. A talngamulo kaning ika bel mulo longor ono. Mangasa, bel mulo nuk pas asaning ia ka tol tari? ");
INSERT INTO lbb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ning a kibik dilima na bret tetek dilima na rip a barsan, naisa na rat ning mulo song bukus pasi ana mah a utna na hangan?” La kelesi mange, “Ning a bonot pa pisir naur.” ");
INSERT INTO lbb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Pa e Iesu i deken la mange, “Ning a kibik mais a bret tetek diat a rip a tarai, naisa na rat ning mulo song bukus pasi ana mah a utna na hangan?” La kelesi mange, “Mais a rat.” ");
INSERT INTO lbb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pa i deken la mang, “Belot mulo talapor?” ");
INSERT INTO lbb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E Iesu taum ana kakak a asaerla anunai la hanot tisa e Betsaida, pa tarai la ben pas ning a matana kut teteki, pa la nunungi sur ir suah a kuna saot ono sur ir tai. ");
INSERT INTO lbb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","I tong pas a kuna kut, pa i ben maskani kusun a hanua. Ning ka namis tar naur a matana pa ka suah tar naur a kuna ono, i dekeni mang, “U ka oroi ta utna?” ");
INSERT INTO lbb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Pa barsan ning i tai tostos, pa i atongi mang, “A oroi a tarai la arlar ana rakaila ning la han.” ");
INSERT INTO lbb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","E Iesu i suah ulak naur a kuna ona matana kut, pa matana i bot talapor wakak, pa i oroi a ututnala rop. ");
INSERT INTO lbb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","E Iesu i sune sen a barsan ning, pa i atai i mang, “Ur han tostos sur anum a rumai. Gong u han ting na tinine hanua.” ");
INSERT INTO lbb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","E Iesu taum ana nuna kakak a asaerla la han uting na hananua milau e Sisaria Pilipai. Ning la han amon, i deken la mang, “A tarai la atongi mang iau esi?” ");
INSERT INTO lbb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","La kelesi mang, “Dingla la atong u e Jon a Tena Baptais. Dingla la atong u, e Elaija, pa dingla otleng la atong u, ning a hal a propetla.” ");
INSERT INTO lbb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pa i deken la mang, “Pa mulo, mulo atong iau o esi?” Pa e Pita i kelesi mang, “U a Karisito.” ");
INSERT INTO lbb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pa i sairas la mang gong la atai tar tik onoi. ");
INSERT INTO lbb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","E Iesu i turpasi sur ir asaer anuna kakak a asaerla mange, “A Nat a Barsan ir kilang a galis a mamahat, pa ningnigola, a leklek a tena artabarla tetek e God, pa tena asaerla tagun a warkurai lar gilam ris kusuni pa dir umkoli. Pa ana natol a pukakiar lamur ir kamtur ulak.” ");
INSERT INTO lbb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A warwara ne ane Iesu i talapor kol. Pa e Pita i ben masik pasi pa i warwara rakrakai tana. ");
INSERT INTO lbb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","E Iesu i talingir pa i tai tetek anuna kakak a asaerla, pa i warwara rakrakai tetek e Pita mange, “Satan, ur han utumo lamur tak! Anasa u mur ka a nuknuk a tarai, pa bel u mur a nuknuk e God.” ");
INSERT INTO lbb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","E Iesu i kabah pas a kunum a taraila taum ana kakak a asaerla teteki, pa i atai la mang, “Ning tik i mang sur ir mur iau, gong i mur a nuknukna. Ir pamar anuna rakai kutus pa ir mur iau. ");
INSERT INTO lbb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Esining i mangan alar anuna lalaun ir hirua, ika esining i noren sen anuna lalaun sur iau pa ana Wakak a Warwara otleng ir laun. ");
INSERT INTO lbb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ning tik ir tong akes a ututnala rop mite na rakrakan hanua, pa anuna lalaun ir hirua, ir wakak mangmangasa teteki? ");
INSERT INTO lbb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ir lou keles anuna lalaun ana sa? ");
INSERT INTO lbb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pa tik ning ir meme hok pa ana nuk na warwara na matana tarai tagun onone ning anunla lalaun i bakbak kusun e God pa la sira tol a toltol laulau, a Nat a Barsan otleng ir meme ono ning ir hanot taum ana nuna angelola pa matatar anun e Tamana.” ");
INSERT INTO lbb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pa i atai la mang, “A atong momoli tamulo, dingla omulo ning mulo tur te, belot mulor mat, pa mulo kar oroi a matanitu ane God ir hanot taum ana rakrakai.” ");
INSERT INTO lbb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lamur tana diono na pukakiar, e Iesu i ben pas e Pita, Jems pa e Jon, pa i ben maskan pas ditol usaot na mangir ning i tur kas. Tisaotia ditol oroi a palaona e Iesu i ries. ");
INSERT INTO lbb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Anuna kaenla i pil pa i kokok rakrakai kol, pa bel tik mite lapiu ir gos pas ta kaen pa ir kokok manglarning. ");
INSERT INTO lbb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pa natol a kakak a asaer ditol oroi pas e Elaija pa e Moses dia hanot pa ditol warwara taum oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pa natol a kakak a asaer ditol matmataut kol pa e Pita bel i tasman asa ir atongi, pa i atai kama e Iesu mang, “Tena Asaer, i wakak ning dalar kes kama te. Mitol ar tol ir natol a turturup, takai anumi, takai ane Moses, pa takai ane Elaija.” ");
INSERT INTO lbb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Lamur a laukap i poroi alar pas la. Pa elngen takai misaot na laukap i atongi mang, “Ine a Natuklik, a katnan koli. Mulor longor tana.” ");
INSERT INTO lbb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aiapiap ka ditol gilam taltal, ika bel ditol oroi ulak tik, e Iesu kama kaning taum onditol. ");
INSERT INTO lbb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ning la han purum amon misaot na mangir, e Iesu i sairas ditol sur gong ditol atai tar tik ana saning ditol ka oroi tari, tuk ning a Nat a Barsan ir kamtur ulak kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ditol mur a warwara ning, pa ditol deken artalai ditol mang, “Asa momol a kamkamtur ulak kusun a minat?” ");
INSERT INTO lbb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pa ditol deken e Iesu mang, “Asa kamkamna ning a tena asaerla tagun a warkurai la atongi mang e Elaija ir hanot nigo?” ");
INSERT INTO lbb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I keles ditol mang, “A momolna ot, e Elaija ir hanot nigo pa ir atostos ulak a ututnala rop. Pa asa kamkamna ning di ka tumus tari ting na Buk Tabu mang a Nat a Barsan ir kilang a galis a kankan pa bel dir mang suri? ");
INSERT INTO lbb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ika onone ar atai mutol mang e Elaija ka hanot pas, pa la tol a toltol laulaula onoi, arlar ot ana nuknukinla, larotning di ka tumus tari onoi ting na Buk Tabu.” ");
INSERT INTO lbb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ning e Iesu taum ana natol a kaklik a asaer la han purum tetek a kakak a asaerla, la oroi a tnan kunum a taraila kaning la tur talilis pas la, pa tena asaerla tagun a warkurai kaning la arlak ana warwara taum ana kakak a asaerla. ");
INSERT INTO lbb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ning a tarai la oroi pas e Iesu, la kulkulan kol, pa la dun barati pa la gasgas pasi. ");
INSERT INTO lbb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pa e Iesu i deken anuna kakak a asaerla mang, “Asaning mulo arlak na warwara onoi?” ");
INSERT INTO lbb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ning a barsan miting na kunum i kelesi mang, “Tena Asaer, a ben a natuk barsan tetek u, ning a mot i kas tar onoi pa bel i tolsot sur ir warwara. ");
INSERT INTO lbb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ning a mot ne i sira solongi, i sira migen purumi ting lapiu, pa busa i purum ting na pahana, i arngingit pa palaona i rakrakai. A nunung anum na kakak a asaerla sur lar kepsen a mot kusuni, ika bel la tolsot pasi.” ");
INSERT INTO lbb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","E Iesu i keles la mange, “Mulo na tarai tagun onone, bel mulo tortorot! Ia ka kes bongnan iau te napirimulo. Nangse mulor tortorot? Mulor ben a kaklik ning tetek iau.” ");
INSERT INTO lbb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pa la ben pasi tetek e Iesu. Ning a mot i oroi pas e Iesu, aiapiap ka i migen purum tar a kaklik ning ting lapiu, pa i pele, pa i busa a pahana. ");
INSERT INTO lbb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pa e Iesu i deken a taman a kaklik mang, “Nangse i turpasi?” Pa i kelesi mang, “I turpasi onoi ning ot i kaklik. ");
INSERT INTO lbb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A galis a pukakiar a mot i sira migen tari uting na iah pa uting na malum otleng sur ir umkoli. Ning ur tolsot sur ur kepsen a mot kusuni, ur maris miau, pa ur nangan miau.” ");
INSERT INTO lbb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","E Iesu i atongi tana mang, “U ot! Esining i tortorot i tolsot pas a ututnala rop.” ");
INSERT INTO lbb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pa a taman a kaklik i kukuk kapit mange, “A tortorot! Nangan iau ana nuk siklik tortorot.” ");
INSERT INTO lbb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ning e Iesu i oroi a kunum a taraila ning la dun taum, i warwara rakrakai tetek a mot mang, “U a mot, a ngat pa talngana kutkut, a atai u ur purum kusun a kaklik, pa gong ulak ma u kas onoi.” ");
INSERT INTO lbb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A mot i kukuk pas, i gulen rakrakai tar a kaklik ning, pa i purum pas kusuni. A kaklik ning i arlar kama lar a minat, pa galis la atongi mang ka mat. ");
INSERT INTO lbb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ika e Iesu i tong pas a kuna kaklik, pa i dat atur pasi. ");
INSERT INTO lbb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ning la kas uting na ning a rumai, anuna kakak a asaerla la deken kumnani mang, “Asa kamkamna ning bel mila tolsot sur milar kepsen a mot kusuni?” ");
INSERT INTO lbb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","E Iesu i keles la mang, “A ngas a mot larne ir purum ka ana niaring, bel ana ta utna otleng.” ");
INSERT INTO lbb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","La han misaot, pa la han bolos utumo na papar Galili. E Iesu bel i mang sur tik ir tasman a pukna ning lar kes ia, anasa i mang sur ir asaer anuna kakak a asaerla. Pa i atongi mang, “Dir saran tar a Nat a Barsan uting na kuna taraila pa lar umkoli. Pa ana natol a pukakiar lamur ir kamtur ulak.” ");
INSERT INTO lbb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bel la talapor ana kamkama warwara ne, pa la matmataut sur lar dekeni. ");
INSERT INTO lbb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","La hanot utumo e Kapernaum. Pa ning la kas ting na rumai, e Iesu i deken la mange, “Asaning mulo arlak na warwara ono ting na ngas?” ");
INSERT INTO lbb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ika bel la kelesi, anasa la arlak mang esi na halinla i leklek kol. ");
INSERT INTO lbb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pa e Iesu i kes pa i kabah pas anuna ning a bonot pa pisir naur a kakak a asaerla, pa i atai la mange, “Ning tik i mang sur ir leklek kol, i wakak sur ir anatarna pasi, ir tena titol ka tetek a tarai rop.” ");
INSERT INTO lbb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","I ben pas ning a kaklik, pa i atur potor tari tanla. Lamur i rawan pasi, pa i atai la mang, ");
INSERT INTO lbb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Esining ir gas pas a kakakla ne ana risak, i gas pas iau. Pa esining ir gas pas iau, bel i gas pas iau ka, i gas pas esaning i sune iau ute.” ");
INSERT INTO lbb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","E Jon i atai e Iesu mange, “Tena Asaer, mila oroi ning a barsan i kepsen a motla ana risam, pa mila sairasi, anasa bel a halindala.” ");
INSERT INTO lbb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","E Iesu i kelesi mange, “Gong mulo sairasi. Ning tik ir tol ta utna na kulkulan ana risak, bel ir atong kapit ta laulau a warwara hok. ");
INSERT INTO lbb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Anasa esining bel i sairas dala, i nangan dala ka. ");
INSERT INTO lbb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A atong momoli tamulo, ning tik ir tabar mulo ana ta kap a malum, anasa mulo ane Karisito, ir kibas ot anuna arlou. ");
INSERT INTO lbb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ning tik ir ben rongon ta halin a kakakla ne ning i tortorot hok, ir laulau kol a warkurai teteki tan tik ning dir dot tar ta tnan hat ting na ruana, pa dir migen murungi salatasi. ");
INSERT INTO lbb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ning a kum ir ben rongon u, ur kutus seni. Ir wakak ning ur kas ting na lalaun tikin a takumut ka, sur gong di migen u taum ana naur a kum uting na tnan iah ning bel i sira rop. ");
INSERT INTO lbb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ning a ham ir ben rongon u, ur kutus seni. Ir wakak ning ur kas ting na lalaun tikin a takumut ka, sur gong di migen u taum ana naur a ham uting na tnan iah. ");
INSERT INTO lbb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ning a matam ir ben rongon u, ur liok seni. Ir wakak ning ur kas ting na matanitu ane God ana takai a matam ka, sakana dir migen u taum ana naur a matam rop uting na tnan iah. ");
INSERT INTO lbb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tingia ‘a soisoila bel lar mat, pa iah otleng bel ir mat.’ ");
INSERT INTO lbb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dir atotoh a taraila rop ana iah arlar ana artabar tetek e God ning di atotohi ana sol. ");
INSERT INTO lbb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A sol i wakak, ika ning a makmakana ka rop, mulor amakmakan ulak mangmangasa pasi? Bel! I wakak sur a sol ir kes omulo, pa mulor kes na balmolmol taum.” ");
INSERT INTO lbb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E Iesu i han misaot utumo na papar Judia, pa ting na ning a ris a malum Jodan. A kunum a tarai la han teteki, pa i asaer ulak la larotning i sira toli. ");
INSERT INTO lbb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dingla na Parisaio la han teteki sur lar tohoi. La dekeni mang, “I tostos arlar ana nundala na Warkurai, sur a barsan ir kepsen anuna hane, o bel?” ");
INSERT INTO lbb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Pa e Iesu i deken la mange, “Esi na warkurai ning e Moses i saran tari tamulo?” ");
INSERT INTO lbb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pa la kelesi mange, “E Moses i malmaling tari ka sur a barsan ir tumus tar a paka buk na kutus tinaulai, pa ir kepsen anuna hane.” ");
INSERT INTO lbb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","E Iesu i atai la mange, “E Moses i tumus a warkurai ning sur mulo, anasa a balamulo i rakrakai kol. ");
INSERT INTO lbb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ika ana kamkam a akakes, e God ‘i akes a tarai, sur lar barsan pa lar hane.’ ");
INSERT INTO lbb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ine a kamna ning a barsan ir han kusun e tamana pa e tana, pa ir kes taum oe nuna hane, ");
INSERT INTO lbb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","pa diar hanot takai ka ana palaondiau.’ Pa bel ma dia areur, dia takai ka. ");
INSERT INTO lbb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Asaning e God ka dot taum tari, gong ulak ma tik i kutusi.” ");
INSERT INTO lbb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lamur, ning la kes ting na rumai, a kakak a asaer la deken ulak e Iesu ana utna ne. ");
INSERT INTO lbb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Pa i atai la mang, “Ning tik ir kepsen anuna hane, pa ir taulai ta hane ulak, a barsan ning i tol a toltol laulau tetek anuna ningnigo na hane. ");
INSERT INTO lbb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pa ning ta hane i han kusun anuna barsan, pa i taulai ulak tik masik, a hane otleng ning i tol a toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A tarai la ben a kakakla tetek e Iesu sur ir suah naur a kuna saot onla. Ika anuna kakak a asaerla la sairas la. ");
INSERT INTO lbb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ning e Iesu i oroi, i balakut pa i atai la mange, “Mulor noren sen a kakakla sur lar han tetek iau. Gong mulo sairas la, anasa a matanitu ane God anunla ning la manglarne. ");
INSERT INTO lbb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A atong momoli tamulo, ning tik bel ir kibas a matanitu ane God arlar ana kaklik, bel ir tolsot sur ir kas tingia.” ");
INSERT INTO lbb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pa i los pas a kakakla, pa i suah naur a kuna saot onla, pa i angisngis la. ");
INSERT INTO lbb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ning e Iesu i han amon ulak, ning a barsan i dun teteki, i kes ana bokona hana na matana, pa i dekeni mange, “Wakak a Tena Asaer, asaning ar toli sur ar kibas a lalaun tikin?” ");
INSERT INTO lbb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","E Iesu i kelesi mang, “Asa kamkamna ning u atong iau mang a wakak? Bel tik i wakak, e God ka. ");
INSERT INTO lbb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","U tasman a Warkuraila: ‘Gong u umkol tik, gong u tol a toltol laulau ana ta hane anuna tik o ta barsan anuna tik, gong u kinkinau, gong u artitiu asasongo, gong u asongo pas ta utna nuna tik pa u los pasi, ur hanrawai e tamam pa e tnam.’” ");
INSERT INTO lbb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A barsan ning i kelesi mange, “Tena Asaer, turpasi ning a kaklik ot tuk onone, a sira mur a warkuraila rop ne.” ");
INSERT INTO lbb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","E Iesu i tai teteki, i marisi pa i atai mang, “Ning a utna ot u kapan suri. Ur han pa ur siuran sen anum a ututnala rop, pa mani onoi, ur tabar a kapan a tarai ono. Ning ur toli larne, anum a wakak a gongon kanisaot na langit. Lamur ur han ute pa ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ning i longor a warwara ne, a patarna i main, pa i han taum ana balmaris, anasa anuna gongon i galis kol. ");
INSERT INTO lbb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","E Iesu i gilam taltal tetek anuna kakak a asaerla pa i atai la mang, “I ngangaten kol tetek a tena gongonla sur lar kas ting na matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A kakak a asaer la kulkulan kol ana warwara ne. E Iesu i atai ulak la mang, “A natnatukla, i ngangaten kol tetek a taraila sur lar kas ting na matanitu ane God. ");
INSERT INTO lbb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","“Ir ngangaten sur a kamel ir kas ting na mosol a sur a susuk, ika i ngangaten kol tetek a tena gongon sur ir kas ting na matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A kakak a asaerla la kulkulan kol, pa la deken artalai la mang, “Manglarning, esi ma ning dir alauni?” ");
INSERT INTO lbb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","E Iesu i tai tetek la pa i atongi mang, “A tarai bel lar tolsot pasi, ika e God ir tolsot pas a ututnala rop.” ");
INSERT INTO lbb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","E Pita i atai e Iesu mange, “Oroi, mila ka han kusun anumila na ututnala rop, pa mila mur u.” ");
INSERT INTO lbb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","E Iesu i atongi mang, “A atong momoli tamulo, ning tik ir han kusun anuna rumai, o kusun na tastasna barsan pa gurarala, o kusun e tana, o e tamana, o na natnatna, o kusun anuna na piu, kamkamna hok pa ana Wakak a Warwara, ");
INSERT INTO lbb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ana lalaun ne, dir saran tar takai a mar a rumai tana, takai a mar a tastasna barsan, takai a mar a tastasna hane, takai a mar a kabatnana, takai a mar a natnatna, pa takai a mar a piu, pa dir alaulau i otleng. Pa ana lalaun lamur dir tabari ana lalaun tikin. ");
INSERT INTO lbb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ika a galis ning onone la nigo, lar mur, pa la ning onone la mur, lar nigo.” ");
INSERT INTO lbb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ning e Iesu taum ana nuna kakak a asaerla la mur a ngas usaot e Jerusalem, e Iesu i nigon la, pa anuna kakak a asaerla la nuknuk kol, pa taraila otleng ning la muri la matmataut. Pa e Iesu i ben maskan pas anuna ning a bonot pa pisir naur a kakak a asaerla, pa i atai la ana ututnala ning ir hanot teteki manglarne, ");
INSERT INTO lbb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Oroi, onone dala han amon usaot e Jerusalem. Dir saran tar a Nat a Barsan tetek a leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai. Lar warkurai i sur ir hirua, pa lar saran tari tetek la ning bel a tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Lar morot laulau ono, lar namisi, lar mirasi pa lar umkoli. Pa ana natol a pukakiar lamur ir kamtur ulak.” ");
INSERT INTO lbb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naur a nat e Sebedi, e Jems pa e Jon, dia han tetek e Iesu pa dia atongi tana mange, “Tena Asaer, mia nunung u sur ur tol asa ne mia mang suri tam.” ");
INSERT INTO lbb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Pa i deken diau mange, “Asaning mu mang suri tak?” ");
INSERT INTO lbb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Dia kelesi mange, “Ur akes tar miau ana num a matatar, pa datol ar warkurai taum, ning a halimiau ting na sot a kum pa ning ting na kair.” ");
INSERT INTO lbb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","E Iesu i atai diau mange, “Bel mu tasman asaning mu nunung suri. I mangasa, mu tolsot sur mu otleng mur gang ana kap a mamahat ning ar gang ono? Mu tolsot otleng sur dir baptais mu ana baptais ning dir baptais iau ono?” ");
INSERT INTO lbb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pa dia kelesi mange, “Miar tolsot pasi ka.” E Iesu i atai diau mange, “A kap a mamahat ning ar gang ono, mu otleng mur gang ono, pa baptais ning dir baptais iau ono, dir baptais mu otleng ono. ");
INSERT INTO lbb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ika ana keskes ting na sot a kuk pa kair, bel anuk a titol sur ar sarani. E God ir sarani tetek la ning ka sang tari sur la.” ");
INSERT INTO lbb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ning a bonot a kakak a asaer la longori, la balakut e Jems pa e Jon. ");
INSERT INTO lbb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","E Iesu i kabah taum pas la, pa i atongi mang, “Mulo tasmani mang la ning di atong la a tena warkuraila anuna tarai ning bel a tarai Juda, la warkurai a tarai pa la oroi purpurum la. Pa anunla na ningnigo la saran a rakrakai a warkuraila tetek anunla na tarai. ");
INSERT INTO lbb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ika tetek mulo bel ir manglarne. Esining i mang sur ir leklek tamulo, ir anatarna pasi sur ir tena titol anumulo. ");
INSERT INTO lbb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pa esining i mang sur ir ningnigo tamulo, ir tena titol oros anuna taraila rop. ");
INSERT INTO lbb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Anasa a Nat a Barsan bel i hanot sur dir titol teteki. I hanot sur i ot ir titol tetek a tarai pa ir saran tar anuna lalaun, a arlou, sur ir lou langolango pas a galis a tarai.” ");
INSERT INTO lbb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","La hanot tumo e Jeriko. Ning e Iesu pa nuna kakak a asaerla pa kunum a tarai otleng la han mitingia, ning a barsan, a kut, a risana e Batimaias (a kamkamna mang a nat e Timaio), i kes tar ting na ris a ngas, pa i sira nunung utna. ");
INSERT INTO lbb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","I longori mang e Iesu a te Nasaret ka han milau, i arkabah rakrakai mang, “Iesu, Nat e Dewit, ur maris iau.” ");
INSERT INTO lbb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pa galis a tarai la sairasi sur ir kes wowowon. Ika i arkabah rakrakai kol mang, “Nat e Dewit, ur maris iau.” ");
INSERT INTO lbb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","E Iesu i tur suai pa i atai la mang, “Mulo kabah pasi.” La kabah pas a matana kut, pa la atai i mang, “Ur gas! Tur! E Iesu i kabah u.” ");
INSERT INTO lbb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","E Batimaias i kepsen anuna kaen ning i polpol alar anuna mermer ono, i kamtur, pa i han tetek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Pa e Iesu i dekeni mange, “Asaning u mang sur ar toli hom?” A matana kut i kelesi mang, “Tena Asaer, a mang sur ar tai.” ");
INSERT INTO lbb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","E Iesu i atongi tana mang, “Ur han, anum a tortorot ka alangolango pas u.” Ono otning ka tai, pa i mur e Iesu ana ngas. ");
INSERT INTO lbb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ning la han milau e Jerusalem, pa la hanot ting e Betpage pa e Betani ting na Mangir Oliw, e Iesu i sune naur miting na nuna kakak a asaerla. ");
INSERT INTO lbb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Pa i atai diau mang, “Mur han uting na hanua kaning lanigo tamu. Ning mur han kas, mur han tar ana ning a barman a dongki kaning di dot akes tari, belot tik i kes tar ono. Mur pak seni pa mur beni ute. ");
INSERT INTO lbb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ning tik ir deken mu mang, ‘Asaning mu toli manglarning suri?’ mur atai i mange, ‘A Leklek i mang suri, pa bel ir bongnani pa ir aulaki kale.’” ");
INSERT INTO lbb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ning dia han, dia oroi tetek a barman a dongki ning di dot akes tari tumo lapiu na ris a taman ana rumai, milau a ngas, pa dia pak seni. ");
INSERT INTO lbb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Dingla na tarai ning la tur tingia la deken diau mang, “Ai, mu pak sen a barman a dongki ning sur asa?” ");
INSERT INTO lbb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dia keles la ana warwara ning e Iesu ka atong tari, pa la noreni ka tandiau. ");
INSERT INTO lbb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dia ben pas a barman a dongki tetek e Iesu, pa dia kepsen anundiau naur a saket, pa dia suahi saot na palaina, pa e Iesu i kes saot ono. ");
INSERT INTO lbb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pa galis a tarai otleng la sagen anunla na saket ting na ngas. Pa dingla na tarai otleng la ting pas a rakarakaila miting na bual, pa la suahi ting na ngas. ");
INSERT INTO lbb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","La ning la nigo pa la ning la mur, la kukuk mang, “Hosana! Esaning i hanot ana risan a Leklek i angis.” ");
INSERT INTO lbb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“A matanitu ana tamandala e Dewit ning ir hanot i angis! Hosana usaot kol!” ");
INSERT INTO lbb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ning e Iesu i hanot saot e Jerusalem, i kas uting na rumai artabar. Ning ka oroi tar a ututnala rop, i ulak utumo e Betani taum ana nuna ning a bonot pa pisir naur a kakak a asaerla, anasa ka rah morom. ");
INSERT INTO lbb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A pukakiar lamur, ning la han mitumo e Betani, e Iesu i murak. ");
INSERT INTO lbb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I oroi pas a rakai a fig miting bakbak, i gomgomo wakak. Pa i han sur ir oroi, sur ta wana. Ning i hanot tingia, bel i oroi al wana, a pakanala ka, anasa belot a kalang sur ir wai. ");
INSERT INTO lbb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pa i atai a rakai a fig mange, “Turpasi onone pa lamur, bel tik ulak ma ir ien pas ta waim.” Pa anuna kakak a asaer la longor akes pas a warwara ning. ");
INSERT INTO lbb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ning la hanot saot e Jerusalem, e Iesu i kas uting na woroh na rumai artabar, pa i lu purum sen la ning la sisiurai, pa la otleng ning la lolou tingia. I migen lingir a logola anuna tena keles manila pa keskesla anun la ning la siuran a tabunla. ");
INSERT INTO lbb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pa bel i noren tar a taraila sur lar los anunla ututnala na sisiurai ting na arpotor na woroh a rumai artabar. ");
INSERT INTO lbb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","I asaer la mang, “Di ka tumus tari ting na Buk Tabu mang, ‘Dir atong anuk a rumai ana rumai a niaring sur a taraila miting na matanitu rop.’ Ika mulo ka tol lingir pasi sur ir arlar ana ‘pukna na mumun ana tena kinkinaula.’” ");
INSERT INTO lbb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","A leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai la longori, pa la nuknuk sur ta ngas sur lar umkol e Iesu ono, anasa la matatani, anasa a tarai rop la kulkulan ana nuna asaer. ");
INSERT INTO lbb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ning a rah ma, e Iesu taum ana nuna kakak a asaer la han kusun a hanua Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ana kobot ning ot, ning la ulak usaot e Jerusalem, la oroi mang a rakai a fig ka marang mitumo ot na wakwakirna usaot. ");
INSERT INTO lbb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pa e Pita i nuk pas a warwara ane Iesu, pa i atai i mange, “Tena Asaer, oroi! A rakai a fig ning u warwara rakrakai tar teteki, ka marang rop.” ");
INSERT INTO lbb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","E Iesu i kelesi mange, “Mulor tortorot oe God. ");
INSERT INTO lbb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A atong momoli tamulo, ning tik ir atai a mangir ne mange, ‘Ur takakan, pa ur sirok parung usa latasi,’ pa bel i urmatana nuknuk, i tortorot mang dir tol asaning ka atong tari, dir toli ot. ");
INSERT INTO lbb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Manglarning a atongi tamulo, a ututnala rop ning mulo nunung suri, mulor tortorot ka mang mulo ka kibasi, pa ir hanot tamulo larotning. ");
INSERT INTO lbb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","“Ning mulo araring, pa mulo nuk pas ta utna ning tik i tol laulau tari omulo, mulor nuk duman seni, sur e Tamamulo saot na langit ir kepsen anumulo na toltol laulaula otleng.” ");
INSERT INTO lbb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","La hanot ulak saot e Jerusalem. Ning e Iesu i han amon ting na woroh na rumai artabar, a leklek a tena artabarla tetek e God, pa tena asaerla tagun a warkurai pa ningnigola la han teteki. ");
INSERT INTO lbb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","La dekeni mang, “Esi na ngas a rakrakai ning u tol a ututnala ne ono? Esi i saran a rakrakai tam sur ur tol a ututnala ne?” ");
INSERT INTO lbb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","E Iesu i keles la mang, “Iau otleng ar deken mulo ana ning a kabah. Pa ning mulor kelesi, ar atai mulo ana rakrakai ning a sira tol a ututnala ne ono. ");
INSERT INTO lbb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mitaha a rakrakai ning e Jon i baptais a tarai ono? Misaot na langit, o tana tarai ka? Mulor atai iau.” ");
INSERT INTO lbb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pa la warwara artalai tanla mang, “Ning dalar atongi mang, ‘Misaot na langit,’ ir keles dala ka mang, ‘Sur asaning bel mulo tortorot onoi?’ ");
INSERT INTO lbb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ika ning dalar atongi mang, ‘Tan a tarai,’ a tarai lar balakut dala.” La matatan a tarai, anasa a tarai la tortorot oe Jon mang i a propet. ");
INSERT INTO lbb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pa la keles e Iesu mang, “Bel mila tasmani.” Pa e Iesu i atai la mang, “Iau otleng bel ar atai mulo ana rakrakai ning a sira tol a ututnala ne ono.” ");
INSERT INTO lbb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","E Iesu i asaer la ana ning a warwara larlar, mange, “Ning a barsan i oman tar a barim a wain, pa i tol alar tari ana woroh. Ting na barim a wain, i kel tar a tung sur dir pas miren a wana wain tingia, sur a polona ir hanot. Pa i tol tar a natar a rumai i tur kas sur ana tena tai alar. Lamur i saran tar kaba a barim ning tana dingla na tena titol sur lar tai alari, pa i han uting na ning a hanua masik. ");
INSERT INTO lbb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ning a kalang ka sot sur dir git taum a wana wain, i sune sen ning a tena titol oros tetek a tena titolla, sur lar los pas al wana wain miting na barim sur anunai otleng. ");
INSERT INTO lbb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ika a tena titolla la tong akes pasi, la umi, pa la sune ulak oros seni. ");
INSERT INTO lbb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pa i sune ulak ning a tena titol oros tetek la, la um laulau tar a pukulna, pa la ame tari. ");
INSERT INTO lbb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A taman a barim i sune ulak ning a tena titol oros, la umkoli. Lamur i sune ulak a galis, la um dingla na tarai, pa dingla la umkol la. ");
INSERT INTO lbb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Takai kama kaning napirna, a natnalik ot, esaning i katnani. I sune i tetek la, pa i atongi mang, ‘Lar hanrawai a natuklik.’ ");
INSERT INTO lbb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ika a tena titolla la warwara artalai tanla mang, ‘Esaning ir keles e tamana, i ma ine ot. Mulo lamut, dalar umkoli, sur anundalai ma a barim a wain.’ ");
INSERT INTO lbb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pa la tong akes pasi, la umkoli, pa la migen purum seni kusun a barim. ");
INSERT INTO lbb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Asaning a taman a barim ir toli? Ir hanot pa ir umkol a tena titolla, pa ir saran tar a barim tetek al tarai masik. ");
INSERT INTO lbb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Mangmangasa, bel mulo was a warwara ne ting na Buk Tabu? I atongi mange, ‘A hat ning na tena tol rumai la kepseni, i ot ning a wakak a hat kes, ning di tol a rumai saot ono. ");
INSERT INTO lbb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A utna ne a Leklek ot ka tol tari, pa i wakak kol ana numila a tatatai.’” ");
INSERT INTO lbb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A ningnigola anuna tarai Juda la tai sur ta ngas sur lar tong akes pas e Iesu, anasa la tasmani mang i atong ka a warwara larlar ne onla. Ika la matatan a kunum a tarai, pa la han kusuni. ");
INSERT INTO lbb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","La sune sen a Parisaiola pa halalna e Herot tetek e Iesu sur lar longor anuna ta warwara sur ta utna lar tiwi ono. ");
INSERT INTO lbb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ning la hanot teteki, la atai i mange, “Tena Asaer, mila tasmani mang u a tostos a barsan. Bel u nuknuk kol ana saning a tarai la atongi hom, anasa a ginim i arlar rop ka tetek a tarai rop, pa u asaer la ana ngas ane God ana momol. I mangasa, i tostos sur dir lou a totokom tetek a Sisar o bel? ");
INSERT INTO lbb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dalar lowi, o gong?” I tasman lalan anunla na asasongo, pa i deken la mang, “Sur asaning mulo mang sur mulor toho iau? Ta mani ute ar oroi.” ");
INSERT INTO lbb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pa la saran tar ning a mani tana. Pa i deken la mang, “A manar pa tumtumus ne onoi an esi?” La kelesi mang, “Anuna Sisar.” ");
INSERT INTO lbb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","E Iesu i atai la mang, “Asaning anuna Sisar mulor sarani tetek a Sisar, pa saning ane God mulor sarani otleng tetek e God.” Ning la longori, la kulkulan kol ono. ");
INSERT INTO lbb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A Sadusila ning la sira puai ka mang bel ta lalaun ulak kusun a minat, la han tetek e Iesu, pa la dekeni mang, ");
INSERT INTO lbb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tena Asaer, e Moses i tumus tari tetek dala mang, ning ta barsan ir mat pas kusun anuna hane, pa bel ta natundiau, e tasnalik ir ben pasi pa ir taulai i, sur ir aitna tar al kakakla ana risana e tasnalik ning ka mat. ");
INSERT INTO lbb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ning a kabaitas, mais a barsan rop ka. A ningnigona i taulai, pa i mat pas kusun anuna hane, pa bel ta natundiau. ");
INSERT INTO lbb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pa murmur tana maleng i taulai a hane ning, i le i mat ka kusuni, pa bel ta natundiau. Mang otleng larning tetek a munatolna. ");
INSERT INTO lbb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","A mais la rop, la taulai i, ika a hane ning bel i agon tar ta kaklik tanla. Pa hane i mat murmur tanla rop. ");
INSERT INTO lbb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ana lalaun ulak kusun a minat, a hane ning anun esi na halinla? Anasa mais la rop la ka taulai pas onoi.” ");
INSERT INTO lbb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","E Iesu i keles la mang, “Mulo rongo kol, anasa bel mulo tasman a Buk Tabu pa rakrakai e God otleng. ");
INSERT INTO lbb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ning a tarai lar kamtur ulak kusun a minat, bel lar taulai ulak, lar arlar kama ana angelola saot na langit. ");
INSERT INTO lbb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ning mulo puai mang a minatla bel lar laun ulak kusun a minat, mangmangasa belot mulo was a Buk ane Moses ning i warwara ana rakai ning i irnga? E God i atongi tetek e Moses mange, ‘Iau a God ane Abaram, a God ane Aisak pa God ane Jekop.’ ");
INSERT INTO lbb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mulo rongo kol. E God bel a God ana minatla, a God anun la ning la laun.” ");
INSERT INTO lbb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ning a hala tena asaerla tagun a warkurai i hanot, pa i longor e Iesu taum ana Sadusila la warwara. I longori mang e Iesu i keles wakak la, pa i dekeni mange, “Esi na warkurai ning i itna kol tanla rop?” ");
INSERT INTO lbb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","E Iesu i kelesi mange, “Ine a warkurai ning i itna kol, ‘A tarai Israel mulor longor, a Leklek anundala God i takai sot ka. ");
INSERT INTO lbb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mulor mang sur a Leklek anumulo a God ana balamulo rop, a ingumulo rop, a nuknukimulo rop, pa rakrakaimulo rop.’ ");
INSERT INTO lbb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ine a munaurna, ‘Ur mang sur a halim larning u mang sur u ot.’ Bel ta warkurai i itna tana naur a warkurai ne.” ");
INSERT INTO lbb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A tena asaer tagun a warkurai i atai e Iesu mange, “I momol ot, Tena Asaer. I tostos anum a warwara, mang e God i takai sot ka, pa bel tik ulak ma. ");
INSERT INTO lbb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dalar mang sur e God ana balandala rop, a nuknukindala rop, pa rakrakaindala rop, pa dalar mang sur a halalindala larning dala mang sur dala ot. Ning dalar mur naur a warkurai ne, i itna kol tana artabarla ning dala sarani tetek e God, pa artabarla ning di tuni teteki.” ");
INSERT INTO lbb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ning e Iesu i oroi mang i warwara na tastasman, i atai i mange, “Bel u bakbak kusun a matanitu ane God.” Pa bel ulak ma tik i deken e Iesu ana ta kabah, anasa la matmataut. ");
INSERT INTO lbb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","E Iesu i asaer la ting na woroh a rumai artabar, i atongi mange, “Sur asaning a tena asaerla tagun a warkurai la atongi mang a Karisito a nat e Dewit? ");
INSERT INTO lbb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A Talngan Tabu i nigon e Dewit pa i atongi mange, ‘A Leklek i atongi tetek anuk a Leklek, “Ur kes te na sot a kuk, tuk ning ar tolsot pas anum na hiruala sur lar kes nahaim.” ’ ");
INSERT INTO lbb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","E Dewit ot i atong a Karisito mang anuna Leklek. Manglarning, di tamana mangmangasa?” A tnan kunum a tarai la gas kol ning la longor a warwara ane Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ning i asaer la, i atongi mange, “Mulor tumarang mulo kusun a tena asaerla tagun a warkurai. La mang sur lar taltal ana wakak a kaenla, pa la mang sur a tarai lar saran a tnan hanrawai tetek la ting na puknala na tinan taum. ");
INSERT INTO lbb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pa la mang sur a keskes salanigo na rumai lotula, pa keskes a leklek salanigo na ngasala. ");
INSERT INTO lbb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","La sira arop a gongon ana laola, pa la sira kep la ana tol barah a niaringla. Ir itna kol a warkurai a arkeles ane God tetek la.” ");
INSERT INTO lbb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E Iesu i kes milau tar a pukna na suah mani ting na rumai artabar, pa i oroi a taraila ning la migen anunla mani onoi. A galis a tena gongon la migen a tnan mani ting na pukna na suah mani. ");
INSERT INTO lbb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ika ning a kapan a lao, i migen tar ka naur a toia ting na pukna na suah mani. ");
INSERT INTO lbb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pa e Iesu i kabah pas anuna kakak a asaerla teteki, pa i atai la mange, “A atong momoli tamulo, a kapan a lao ne, ka saran tar a tnan mani tanla rop ning la migen tar anunla a mani ting na pukna na suah mani. ");
INSERT INTO lbb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","La saran tukna tar ka miting na tnan gongon anunlai, ika a lao ne, i kapan, ka saran arop sen asaning ir to pas anuna keskes.” ");
INSERT INTO lbb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ning e Iesu i purum kusun a rumai artabar, ning tagun anuna kakak a asaerla i atai i mange, “Oroi, Tena Asaer! A wakak a rumaila ne, di toli ana tatatnan hatat!” ");
INSERT INTO lbb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pa e Iesu i atai i mange, “U oroi a tatatnan rumaila ne? Kaning lamur bel ta hat ir borbor saot on ta hat, dir regen arop sen la.” ");
INSERT INTO lbb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ning e Iesu i kes saot na Mangir Oliw ning di tai solsol sur a rumai artabar, e Pita, Jems, Jon pa e Endru la deken kumnani mange, ");
INSERT INTO lbb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ur atai mila, nangse a ututnala ne ir hanot? Pa esi na akinalang ning ir asangani mang ka milau sur lar hanot?” ");
INSERT INTO lbb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","E Iesu i atai la mang, “Mulor tai alar mulo, sakana tik ir asongo pas mulo. ");
INSERT INTO lbb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A galis lar hanot ana risak, lar atongi mang, ‘Iau a Karisito,’ pa lar asongo pas al galis a tarai. ");
INSERT INTO lbb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ning mulor longor a harumla pa al arkaltai ana harumla, gong mulo matmataut anasa a ututnala ne lar hanot, ika a ararop ana rakrakan hanua kaning ot. ");
INSERT INTO lbb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ning a mangis a tarai ir tur na harum tetek ning a mangis a tarai, pa ning a matanitu ir tur na harum tetek ning a matanitu. Pa mamaisla pa tatatnan munurak ir hanot ting na hananuala. A ututnala ne i arlar ana ningnigo na kankanla, ning i sira hanot ana hane ning i mang sur ir agon. ");
INSERT INTO lbb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mulor tai alar mulo. A tarai lar saran tar mulo tetek a tena warkuraila, pa lar dapis mulo ting na rumai lotula. Mulor tur ana warkurai lanigo tana tatatnan ningnigola pa kingla, anasa mulo anuki. Pa mulor warwara talapor hok tanla. ");
INSERT INTO lbb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dir warawai nigo ana Wakak a Warwara tetek a taraila miting na matanitu rop. ");
INSERT INTO lbb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ning lar dat pas mulo sur a warkurai, gong mulo nuknuk nigo sur asaning mulor atongi. Ana taim ning mulor atong ka a warwara ning di anuknuk tari tamulo, anasa bel mulo ning mulor warwara, a Talngan Tabu ot. ");
INSERT INTO lbb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Tik ir saran sen e tasnalik sur dir umkoli, pa ta barsan ir saran sen e natnalik sur dir umkoli. Pa kakakla lar tur na harum tetek e tamanla pa kabatnanla, pa lar saran sen diau sur dir umkol diau. ");
INSERT INTO lbb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pa taraila rop lar nget mulo anasa mulo anuki, ika esining ir tur rakrakai tuk anuna lalaun ir rop, e God ir alauni. ");
INSERT INTO lbb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mulor oroi ning a laulau a utna kol ir hanot, ir kes ting na pukna ning bel i sot sur ir kes ia, pa ir alaulau a pukna ning. Esining ir was a warwara ne, i wakak sur ir talapor ono. Ana pukakiar ning, la ning la kes ting na papar Judia, lar liu kumna usaot na mangirla. ");
INSERT INTO lbb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pa ning tik ir kes saot na nuna rumai, gong i purum pa gong i kas sur ir los pas ta utna tingui na rumai. ");
INSERT INTO lbb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ning tik ir kes ting na barim, gong i ulak utumo lahanua sur anuna saket. ");
INSERT INTO lbb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ana pukakiarla ning, ir laulau kol tetek a tiananla, pa la otleng ning la aresus. ");
INSERT INTO lbb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mulor araring sur gong a utna ne ir hanot ana kalangla na kotkoto. ");
INSERT INTO lbb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Anasa ana pukakiarla ning, ir itna kol a mamahatla. Ir itna kol tana mamahatla ning i sira hanot te na rakrakan hanua, turpasi ning e God i akes a rakrakan hanua tuk onone, pa lamur otleng bel ta mamahat ir arlar ono. ");
INSERT INTO lbb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ning a Leklek bel ir kutus purum a pukakiarla ning, bel tik ir laun. Ika ka kutus purum seni sur la ning ka aslang pas la, lar laun. ");
INSERT INTO lbb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ana pukakiarla ning, ning tik ir atongi tamulo mang, ‘Oroi, a Karisito ine!’ o ir atongi mang, ‘Oroi, numo e!’ gong mulo tortorot onoi. ");
INSERT INTO lbb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Anasa al asasongo na Karisito, pa al asasongo na propet lar hanot, lar tol al akinalang pa al ututna na kulkulan sur lar asongo a taraila ning e God ka aslang pas la. Ning lar tolsot, lar asasongo a tarai ning e God ka aslang pas la. ");
INSERT INTO lbb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mulor tumarang! Ia ka atai nigon tar mulo ana ututnala rop ning ir hanot! ");
INSERT INTO lbb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ning a mamahatla ning ir rop, ana pukakiarla ning, ‘a kamis ir mormorom, a kalang bel ir talapor, ");
INSERT INTO lbb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","a nangnangla lar punga purum misaot na bakut, pa ututnala saot na bakut lar maler.’ ");
INSERT INTO lbb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ana taim ning, a tarai lar oroi a Nat a Barsan ir hanot ana didiah bakutla taum ana tnan rakrakai pa matatar. ");
INSERT INTO lbb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pa ir sune anuna angelola sur lar ben taum anuna tarai ning ka aslang pas la. Lar ben taum la miting na diat a matana wuwu, miting na ning a ris a rakrakan hanua tuk utumo otleng ana ning a ris a rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mulor asaer ana rakai a fig. Ning a rakrakanala ir sibul ot ulak pa pakpakana ir tapalas, mulo ka tasmani mang a kalangla na laplapang ka milau. ");
INSERT INTO lbb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lar otleng ning, ning mulor oroi a ututnala ning ia ka warwara tar ono ir hanot, mulor tasmani mang ka milau. ");
INSERT INTO lbb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A atong momoli tamulo, a tarai tagun onone belot lar mat pa ututnala rop ne ir hanot. ");
INSERT INTO lbb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A langit pa rakrakan hanua diar rop, ika anuk a warwarala bel ir rarop. ");
INSERT INTO lbb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Bel tik i tasman a pukakiar pa awa ning a ututnala ne ir hanot. A angelola saot na langit bel la tasmani, pa e Natnalik otleng bel i tasmani, e Tamana ka i tasmani. ");
INSERT INTO lbb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mulor tumarang, pa mulor tai alar mulo, anasa bel mulo tasmani nangse a ututnala ne ir hanot. ");
INSERT INTO lbb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“I arlar ana ning a barsan i sang sur ir han ana ning a tinan. I saran tar anuna rumai tetek anuna tena titol orosla, sur lar tai alari. I saran taktakai a titol tanla rop, pa i atai a barsan ning i sira tai alar a taman sur ir tai alar, pa i han. ");
INSERT INTO lbb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“I maining mulor tumarang, anasa bel mulo tasmani nangse a taman a rumai ir hanot, ana rah, o ana tnan morom, o ana lar ning a kakaruk i kurkurirakuk, o ana kobot. ");
INSERT INTO lbb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Sakana ir hanot kulkulan, pa ir pastetek mulo kaning mulo borbor duman. ");
INSERT INTO lbb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Asaning a atai mulo ono, ar atai a taraila otleng mang: Mulor tai alar mulo!” ");
INSERT INTO lbb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Naur a pukakiar lanigo tana lotu na Han Lakai, pa lotu na bret ning bel al is ono, a leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai la nuknuk sur ta ngas sur lar tong kumnan pas e Iesu pa lar umkoli. ");
INSERT INTO lbb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","La atongi mange, “Gong dala toli ana tnan pukakiar a lotu, sakana a tarai lar arsakai.” ");
INSERT INTO lbb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","E Iesu kaning ot e Betani, ting na rumai ane Saimon, esaning nating i sasam ana lepra. Kaning ot i hangan, ning a hane i hanot teteki taum ana koto na tomtoboh ning di atongi a nad. A matana i abit kol, pa kaning na koto di toli ana hat. I pagal sen a matana koto, pa i peki saot na pukul e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dingla na tarai ning la kes tingia, la balakut pa la awara artalai mange, “Sur asaning di amus oros ka a tomtoboh ne? ");
INSERT INTO lbb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I to pasi sur dir siurani, pa dir kibas a mani arlar ana arlou miting na ning a rau ning di titol pasi, sur dir tabar a kapan a taraila ono.” Pa la balakut a hane ning. ");
INSERT INTO lbb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","E Iesu i atai la mange, “Mulo noreni. Sur asaning mulo saran a mamahat teteki? I ka tol tar a wakak a titol hok. ");
INSERT INTO lbb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A kapan a tarai lar laun bolbolos taum ot omulo. Ning mulo mang sur mulor awakak la, mulor toli ka. Ika iau, bel ar kes tikin napirimulo. ");
INSERT INTO lbb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A hane ne ka tolsot pas a utna ning i to pasi sur ir toli. I pek tar a polo na tomtoboh te na palaok sur ir sang nigon iau sur a pukakiar ning ar mat pa dir akas a minatik ting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A atong momoli tamulo, te na rakrakan hanua rop, ning dir warawai ana Wakak a Warwara, dir warwara otleng ana saning a hane ka tol tari, sur a tarai lar nuk akes a hane ne.” ");
INSERT INTO lbb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","E Judas Iskariot, ning a halin ning a bonot pa pisir naur a kakak a asaer, i han tetek a leklek a tena artabarla tetek e God, sur ir saran tar e Iesu tetek la. ");
INSERT INTO lbb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ning la longori, la gas, pa la lele sur lar lowi. Pa e Judas i nuknuk sur ta ngas ning ir saran tar e Iesu tetek la. ");
INSERT INTO lbb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ana ningnigo na pukakiar ana lotu na bret ning bel al is ono, ning di sira umkol a barman a sipsip, sur a lotu na Han Lakai, a kakak a asaerla ane Iesu la dekeni, “U mang sur milar han utaha, sur milar sang andala utna na hangan sur a lotu na Han Lakai?” ");
INSERT INTO lbb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","I sune sen naur tagun anuna kakak a asaerla, pa i atai diau mange, “Mur han kas usaot e Jerusalem. Pa ning a barsan i los a tnan koto na malum, ir pastetek mu, pa mur muri. ");
INSERT INTO lbb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ning ir kas uting na ta rumai, mur atai a tamana rumai mange, ‘A Tena Asaer i atongi mang: Kanaha a tuk a rumai ning mila taum ana nuk a kakak a asaerla, milar ien a utna na Han Lakai tingia?’ ");
INSERT INTO lbb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pa ir asangan tar mu ana tnan tuk a rumai saot, ning di ka sang tari, pa mur sang andala utna na hangan tingia.” ");
INSERT INTO lbb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Naur a kakak a asaer dia han usaot e Jerusalem, pa dia pastek rop ot a ututnala ning e Iesu ka atong tari tandiau. Pa dia sang a ututnala na Han Lakai. ");
INSERT INTO lbb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ning a rah ma, e Iesu taum ana nuna ning a bonot pa pisir naur a kakak a asaer la hanot. ");
INSERT INTO lbb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kaning ot la hangan, i atongi mange, “A atong momoli tamulo, ning a halimulo ir saran tar iau uting na kuna hiruala, takai ot ne dala hangan taum.” ");
INSERT INTO lbb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","La balmaris, pa la rop taktakai la dekeni mange, “Bel iau gepi?” ");
INSERT INTO lbb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Pa e Iesu i keles la mange, “Ning a halimulo ot ning a bonot pa pisir naur, ning mia amurung taum amiau naur a bret te na besen. ");
INSERT INTO lbb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A Nat a Barsan ir hirua lar otning di ka tumus tari ting na Buk Tabu. Ika ir laulau kol tetek a barsan ning ir saran tari tetek a hiruala. Ir wakak teteki ning bel dir agoni.” ");
INSERT INTO lbb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kaning ot la hangan, e Iesu i los pas a bret, i atong wakak onoi, i kibiki, pa i tabar anuna kakak a asaerla ono. I atongi mang, “Mulor kibasi, ine a palaok.” ");
INSERT INTO lbb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lamur i los pas a kap, i atong wakak pas onoi, i sarani tanla, pa la rop la gang onoi. ");
INSERT INTO lbb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","I atai la mang, “Ine a sulukik, ning i amomol tar a kunubus ning i dat taum tar e God pa tarai. A sulukik ne i tapek sur a galis a tarai. ");
INSERT INTO lbb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A atong momoli tamulo mang, bel ar gang ulak al wain, tuk ning ar gang a tona wain ting na matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ning la ka saken tar a saksak a lotu, la han usaot na Mangir Oliw. ");
INSERT INTO lbb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","E Iesu i atai la mange, “Mulo rop mulor han kusun iau, anasa di ka tumus tari ting na Buk Tabu mang, E God i atongi mange, ‘Ar um a tena tai alar ana sipsipla, pa sipsipla lar liu sarara.’ ");
INSERT INTO lbb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ika ning ia ka kamtur ulak kusun a minat, ar nigo utumo e Galili.” ");
INSERT INTO lbb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","E Pita i atai i mange, “Ning la rop lar han kusun u, ika iau bel.” ");
INSERT INTO lbb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","E Iesu i atai i mange, “A atong momoli tam, onone na morom, ning a kakaruk belot ir areur a kurkurirakuk, ur puai munatol mang bel u tasman iau.” ");
INSERT INTO lbb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ika e Pita i warwara rakrakai teteki mange, “Bel ar puain sen u. Noren iau, ar hirua taum hom.” A kakak a asaerla rop otleng la atongi larning. ");
INSERT INTO lbb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","E Iesu taum ana nuna kakak a asaer la hanot ting na ning a pukna di atongi e Getsemani, pa i atai la mange, “Mulor kes ka te, pa iau ar araring pas.” ");
INSERT INTO lbb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pa i ben pas e Pita, e Jems pa e Jon. Ana taim ning i kilang a tnan balmaris pa i nuknuk kol. ");
INSERT INTO lbb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","I atai ditol mange, “Anuk a lalaun i mamahat kol ana balmaris, milau ar mat ono. Mutol ar kes ka te, pa mutol ar kokohoi.” ");
INSERT INTO lbb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I han siklik usa lanigo, i punga tuntudu ting lapiu, pa i araring sur a pukakiar a minat ir han lakai, ning ir wakak manglarning. ");
INSERT INTO lbb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I araring mange, “Tata, Tata, a ututnala rop i to pas u sur ur toli, ur kibas sen a kap a mamahat ne kusun iau. Ika gong u mur a nuknukik, ur mur ot a nuknukim.” ");
INSERT INTO lbb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ning i ulak, i oroi ditol ka borbor duman. I deken e Pita mange, “Saimon, kaning ot u borbor duman? Bel ur tolsot sur ur kokohoi on ta tuk a kamis lik ka? ");
INSERT INTO lbb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mutol ar kokohoi, pa mutol ar araring, sur gong mutol punga ana larlarla. A ingumutol i mang sur ir longor, ika a palaomutol i ngol.” ");
INSERT INTO lbb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pa i han, pa i araring ulak ana niaring ning ka atong tari kaba. ");
INSERT INTO lbb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ning i ulak, i oroi ditol ka borbor duman ulak, anasa a matanditol ka sulam kol. Bel ditol tasman asaning ditol ar kelesi ono. ");
INSERT INTO lbb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ning i aretol a tinan anunai tetek ditol, i atongi mange, “Mutol borbor liklik kama? I sot ka! A taim ka hanot. Oroi, dir saran tar a Nat a Barsan uting na kuna tena laulaula. ");
INSERT INTO lbb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mutol kamtur, dala kar han! Oroi, a barsan ning ir saran tar iau uting na kuna hiruala, ka hanot.” ");
INSERT INTO lbb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kaning ot e Iesu i warwara, e Judas, ning a halin ning a bonot pa pisir naur a kakak a asaer, i hanot taum ana kunum a tarai. La los na liwan a harum pa puka buturla. A leklek a tena artabarla tetek e God, pa na tena asaerla tagun a warkurai pa ningnigola la sune sen la. ");
INSERT INTO lbb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Esaning ir saran tar e Iesu uting na kuna hiruala ka atai nigon tar a kunum a tarai ana akinalang ning ir toli larne, “Esaning ar goro a ris a pahana, i ot ning. Mulor tong akesi, mulor ben maskan pasi pa mulor tai alar wakaki.” ");
INSERT INTO lbb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ono otning e Judas i han tetek e Iesu, pa i atai i mange, “Tena Asaer!” Pa i goro i. ");
INSERT INTO lbb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","A tarai la tong akes pas e Iesu pa la dati. ");
INSERT INTO lbb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A halinla ning i tur milau, i lasur pas anuna liwan a harum, pa i umsem a talngan a tena titol oros anuna ningnigo na tena artabar tetek e God. ");
INSERT INTO lbb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pa e Iesu i atai la mang, “I mangasa, ngandek iau a tena harum pa tena kinkinau, sur i ma ine mulo hanot taum ana liwanla na harum pa puka buturla sur mulor tong akes iau? ");
INSERT INTO lbb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ana pukakiarla rop dala sira kes taum ting na woroh na rumai artabar, a sira asaer a taraila, pa bel mulo tong akes iau. Ika di toli larne sur dir tolsot pas a warwara ting na Buk Tabu.” ");
INSERT INTO lbb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pa kakak a asaerla rop la liu pas kusuni. ");
INSERT INTO lbb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ning a barman, i mermer pas ka ana kaen, i mur e Iesu. La tong akes pasi, ");
INSERT INTO lbb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","i migen sen anuna kaen, pa i liu mengere kama. ");
INSERT INTO lbb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","La ben pas e Iesu tetek a ningnigo na tena artabar tetek e God. Pa leklek a tena artabarla rop tetek e God, a ningnigola, pa tena asaerla tagun a warkurai la hanot taum tingia. ");
INSERT INTO lbb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","E Pita i mur amon e Iesu, ika i bakbak ot kusuni, pa i kas uting na pukna anuna ningnigo na tena artabar tetek e God. Pa i marnan a iah taum ana tena tai alarla. ");
INSERT INTO lbb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A leklek a tena artabarla tetek e God, pa tarai a kiwung rop la tai sur ta rongo ning e Iesu ka tol tari, sur lar tiwi ono, pa lar umkoli, ika bel la tai pas ta utna. ");
INSERT INTO lbb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A galis la atong a asasongo na warwara oe Iesu, ika anunla na warwara bel i han taum. ");
INSERT INTO lbb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dingla na tarai la tur pa la atong a asasongo na warwara oe Iesu mange, ");
INSERT INTO lbb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mila longori i atongi mange, ‘Ar regen sen a rumai artabar ne ning a tarai la toli, pa ana natol a pukakiar ka, ar tol pas tik ning bel a tarai la toli.’” ");
INSERT INTO lbb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ika anunla na warwara otleng bel i han taum. ");
INSERT INTO lbb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A ningnigo na tena artabar tetek e God i tur salanigo tanla, pa i deken e Iesu mange, “I mangasa, bel ur keles la? Asaning ur keles a warwarala na artitiu ne tetek u ono?” ");
INSERT INTO lbb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ika e Iesu bel i warwara. A tena artabar ne i deken ulaki mange, “U a Karisito, a Nat e God, ning i angis, o bel?” ");
INSERT INTO lbb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","E Iesu i kelesi mange, “Iau ot ning, pa lamur mulor oroi a Nat a Barsan ir kes ting na ris a sot a kuna e God, esaning i rakrakai kol, pa lamur mulor oroi i ning ir hanot ana didiah bakutla misaot na langit.” ");
INSERT INTO lbb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A ningnigo na tena artabar i balakut pa i silir anuna kaen ot, pa i atongi mange, “Dala mang ulak sur al warwara na artitiu sur asa? ");
INSERT INTO lbb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mulo ka longor tar anuna na warwara laulau oe God. Asa mulo nuki?” Pa la rop la malmaling sur dir umkol e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dingla na tarai tagun la, la namis e Iesu, la poroi alar tar a matana, la tubuli pa la atai i mange, “U a propet, atai mila, esining i tubul u!” A tena tai alarla la ben pasi pa la umi. ");
INSERT INTO lbb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ning e Pita kanumo ot lapiu ana rumai, ning a basbas, a tena titol anuna ningnigo na tena artabar tetek e God i hanot. ");
INSERT INTO lbb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ning i oroi e Pita kaning i marmarim, i ngoson rakrakai i, pa i atai i mange, “U otleng u keskes taum oe Iesu a te Nasaret.” ");
INSERT INTO lbb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ika i puai mange, “Bel a tasman asaning u warwara ono, pa bel a talapor ono.” Pa i purum utumo ana taman a woroh. Pa kakaruk i kurkurirakuk kakat. ");
INSERT INTO lbb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A hane ning i oroi ulak pasi, pa i atai la ning la tur tingia mange, “A barsan ne i otleng takai tagun la.” ");
INSERT INTO lbb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E Pita i puai ulak. Lamur siklik, la ning la tur milau e Pita, la atai i mange, “A momolna, u otleng ning a halinla, anasa u a te Galili.” ");
INSERT INTO lbb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pa i lele tetek la, i atongi mange, “E God ir warkurai laulau iau ning ar asongo. Bel a tasman a barsan ning mulo warwara ono.” ");
INSERT INTO lbb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pa kakaruk i munaur na kurkurirakuk kakat. Pa e Pita i nuk pas a warwara ning e Iesu ka atong tari tana mange, “Ning a kakaruk belot ir areur a kurkurirakuk, ur puai munatol mang bel u tasman iau.” I nuk pasi pa i tangis koli. ");
INSERT INTO lbb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ana kabakiar kobot ning ot, a leklek a tena artabarla tetek e God, a ningnigola, pa tena asaerla tagun a warkurai pa tarai a kiwung rop, la warwara taum. La dot pas naur a kuna e Iesu, la beni pa la saran tari tetek e Pailat. ");
INSERT INTO lbb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","E Pailat i dekeni mange, “U a king anuna tarai Juda?” Pa e Iesu i kelesi mange, “I ot ning u atongi.” ");
INSERT INTO lbb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A leklek a tena artabarla tetek e God la tiu e Iesu ana galis a utna. ");
INSERT INTO lbb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","E Pailat i deken ulaki mange, “Bel anum ta warwara na arkeles? Oroi, a galis a utna kol la tiu u ono.” ");
INSERT INTO lbb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ika e Iesu bel i kelesi, pa e Pailat i kulkulan. ");
INSERT INTO lbb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ana raula rop ana lotu na Han Lakai, e Pailat i sira pak sen ta mainla ning i kes ting na karabus ning a tarai la nunung suri. ");
INSERT INTO lbb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ning a barsan a risana e Barabas i kes ting na karabus. A halin la ning la harum taum ana matanitu, pa la umkol a taraila ana arsakai. ");
INSERT INTO lbb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ning a kunum a tarai la hanot tetek e Pailat, la nunungi mang ir pak sen ulak ta mainla ning i karabus. ");
INSERT INTO lbb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pa e Pailat i deken la mange, “Mulo mang sur ar pak sen a ‘king anuna tarai Juda’ tetek mulo?” ");
INSERT INTO lbb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I atongi manglarne anasa ka tasmani mang a leklek a tena artabarla tetek e God la saran tar e Iesu teteki ana nuknuk laulau. ");
INSERT INTO lbb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ika a leklek a tena artabarla tetek e God la angongos a kunum a tarai sur lar nunung e Pailat sur ir pak sen tar e Barabas tetek la. ");
INSERT INTO lbb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","E Pailat i deken ulak la mange, “Asaning ar toli o esane ning mulo atongi mang a king anuna tarai Juda?” ");
INSERT INTO lbb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pa la kukuk rakrakai mange, “Sai ahati saot na rakai kutus!” ");
INSERT INTO lbb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","E Pailat i deke mang, “Sur asa? Esi na rongo ning ka tol tari?” Ika la kukuk rakrakai ka mange, “Sai ahati saot na rakai kutus!” ");
INSERT INTO lbb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","E Pailat i mang sur ir agasgas a taraila, pa i pak sen e Barabas tetek la. Ning di ka miras tar e Iesu, e Pailat i saran tari tetek a tena harumla sur lar sai ahati saot na rakai kutus. ");
INSERT INTO lbb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A tarai a harum la ben e Iesu utisaui ana woroh ana tnan rumai anuna ningnigo, pa la kabah arop pas a kunum a tarai a harum. ");
INSERT INTO lbb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","La apipis tari ana pepol a kaen, la iris pas a inau ning a suksukna pa la suah tari ana pukulna arlar ana kukuh anuna king. ");
INSERT INTO lbb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pa la turpas a arkabah teteki mange, “U a king anuna tarai Juda!” ");
INSERT INTO lbb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","La dapdapis a pukulna ana bulse, la namisi, la kes ana bokona hanla pa la saran a hanrawai teteki. ");
INSERT INTO lbb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ning la ka morot laulau tar ono, la pak sen a pepol a kaen kusuni. La amermer ulak tari ana nuna kaenla, pa la ben purumi sur dir sai ahati saot na rakai kutus. ");
INSERT INTO lbb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ting na ngas a tena harumla la pastetek pas ning a te Sairini, a risana e Saimon, e tamana e Aleksanda pa e Rupus, i han miting na ning a hanua sur ir han usaot e Jerusalem. La angongosi sur ir los a rakai kutus ane Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","La ben e Iesu sur a pukna ning di atongi e Golgota, a kamkamna “A Pukna ana Lasa na Pukulundi.” ");
INSERT INTO lbb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","La saran a wain tana, ning di tol taman tari ana mira, ika bel i gangi. ");
INSERT INTO lbb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","La sai ahat tari saot na rakai kutus. La asalar pas anuna kaenla ana pilai laki, sur esi onla ir los ta kaen. ");
INSERT INTO lbb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","La sai ahati saot na rakai kutus ana 9 kilok ana kobot. ");
INSERT INTO lbb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","La tumus a warwara na artitiu onoi saot na rakai kutus mang, ");
INSERT INTO lbb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","La sai ahat otleng naur a tena kinkinau taum ono saot na naur a rakai kutus, takai ting na sot, pa takai ting na kair. ");
INSERT INTO lbb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pa la ning la han bolos e Iesu, la atong laulaui pa la halalen pukulunla teteki. Pa la atongi mange, “U ma ning u atongi mang ur regen sen a rumai artabar, pa ur tol ulak pasi ana natol a pukakiar, ");
INSERT INTO lbb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","purum kusun a rakai kutus pa ur alaun pas u ot.” ");
INSERT INTO lbb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","A leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai la otleng la morot laulau oe Iesu. La awara artalai tanla mange, “I alaun pas a taraila masik, ika bel ir tolsot sur ir alaun pasi. ");
INSERT INTO lbb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ning i a Karisito, a King anuna tarai Israel, ono otne ir purum kusun a rakai kutus, sur dalar oroi, pa dalar tortorot onoi.” Pa diau otleng, ning di sai ahat tar diau ana naur a rakai kutus ting napirna, dia atong laulaui. ");
INSERT INTO lbb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ana matana kamis tostos, a hananua rop i mormorom tuk ana 3 kilok ana rah. ");
INSERT INTO lbb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ana 3 kilok ana rah ning, e Iesu i kukuk rakrakai mange, “Eloi, Eloi, lema sabakatani?” A kamkam a warwara ning i manglarne, “Anuk a God, anuk a God, sur asaning u han kusun iau?” ");
INSERT INTO lbb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dingla na tarai ning la tur milau, la longori pa la atongi mange, “Longori, i arkabah sur e Elaija.” ");
INSERT INTO lbb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ning a barsan i dun pa i los pas ning a utna ning i sira dop a polo. I amurung pasi ting na wain ning i mititir, i suahi ana rakai pa i tuslani usaot sur e Iesu ir gangi. Pa i atai la mange, “Nanani, dalar oroi, ning e Elaija ir han purum sur ir los purum pasi kusun a rakai kutus, o bel.” ");
INSERT INTO lbb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","E Iesu i kukuk rakrakai pas, pa i suah sen a malwasna. ");
INSERT INTO lbb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A kaen na alalar kutus tingui na rumai artabar i taksilir potor sur naur a dihna, turpasi saot utumo lain. ");
INSERT INTO lbb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A ningnigo anuna tena harumla i tur salanigo ta e Iesu, i longor e Iesu i kukuk, pa i oroi a ngas a minat anunai, pa i atongi mange, “I momol ot, a barsan ne a Nat e God.” ");
INSERT INTO lbb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dingla na gurarala otleng la ororoi miting na bakbak. Ting na arpotor inla, e Maria Makdalen, pa e Salome pa e Maria otleng tana e Josep pa e Jems a barman. ");
INSERT INTO lbb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ditol ne ditol murmur e Iesu ning i kes tumo e Galili, pa ditol sira nangani. Pa a galis a gurarala otleng, ning la han taum onoi usaot e Jerusalem, la kes tingia. ");
INSERT INTO lbb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ning a barsan a risana e Josep, a te Arimatia, ning a halin a tarai a kiwung, a tnan barsan ning a tarai la hanrawai i, i harnanai sur a matanitu ane God. Ning a rah ma ana pukakiar a sang, a pukakiar lanigo ana Pukakiar Sabat, i han tetek e Pailat, bel i matmataut, pa i nunung sur a minat e Iesu. ");
INSERT INTO lbb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","E Pailat i kulkulan ning i longori mang e Iesu ka mat. I kabah pas a ningnigo anuna tena harumla, i dekeni mange, “E Iesu ka mat?” ");
INSERT INTO lbb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ning ka mananos pas tana ningnigo ne, i malmaling sen a minat e Iesu tetek e Josep. ");
INSERT INTO lbb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","E Josep i lou pas a wakak a kaen, i los purum pas e Iesu, pa i irisi ana kaen ning. Lamur i aborbor tari ting na kulam a minat, ning di ka kot tari ting na ris a hat, pa i lakir alar a taman a kulam a minat ana tnan hat. ");
INSERT INTO lbb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E Maria Makdalen pa e Maria, tana e Josep, dia oroi a pukna ning di aborbor e Iesu tingia. ");
INSERT INTO lbb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ning a Pukakiar Sabat ka rop, e Maria Makdalen, pa e Maria tana e Jems, pa e Salome ditol lou pas a ututnala ning i tomtoboh sur ditol ar atomtoboh a minat e Iesu ono. ");
INSERT INTO lbb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ana kobot ning ot ana ningnigo na pukakiar ana wik, ditol han sur uting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ning ditol han amon ditol deken artalai ditol, “Esi ma ir nangan datol sur ir lakir sen a hat numo kusun a taman a kulam a minat?” ");
INSERT INTO lbb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ning ditol tai tostos utumo, ditol oroi mang di ka lakir sen tar a tnan hat ning. ");
INSERT INTO lbb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ning ditol kas uting na kulam a minat, ditol oroi ning a barman, i kes tar ana sot a kunditol, i mermer ana kokok a kaen. Pa ditol matmataut. ");
INSERT INTO lbb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","I atai ditol mange, “Gong mutol matmataut. A tasmani mang mutol tai sur e Iesu a te Nasaret, esaning di sai ahat tari saot na rakai kutus. Bel i ma te, ka kamtur ulak. Mutol oroi a pukna ne di aborbor tari ano. ");
INSERT INTO lbb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mutol han, mutol ar atai anuna kakak a asaerla pa e Pita otleng mange, ‘E Iesu ir nigo utumo e Galili. Mulor oroi tumo, larot ning ka atai nigon tar mulo.’” ");
INSERT INTO lbb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pa ditol purum pa la dun kusun a kulam a minat taum ana nuknuk kol pa ditol koloron. Bel ditol atai tik ana ta warwara anasa ditol matmataut kol.  ");
INSERT INTO lbb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ning e Iesu ka kamtur ulak kusun a minat ana kobot ning ot ana ningnigo na pukakiar ana wik, i hanot tetek e Maria Makdalen, esaning i kepsen tar mais a mot kusuni. ");
INSERT INTO lbb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","E Maria Makdalen i han pa i atai la ning la sira mur e Iesu, ning la balmaris pa la tangis suri. ");
INSERT INTO lbb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ning la longori mang e Iesu ka kamtur ulak pa e Maria ka oroi tari, bel la tortorot ono. ");
INSERT INTO lbb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lamur e Iesu i hanot tetek naur a kaklik asaer ning dia han amon ana ngas. A palaona e Iesu i ries. ");
INSERT INTO lbb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dia ulak, pa dia atai a kakak a asaerla, ika bel la tortorot otleng ondiau. ");
INSERT INTO lbb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lamur i hanot pas tetek ning a bonot pa pisir takai a kakak a asaerla kaning la hangan. Pa i warwara rakrakai tanla, anasa bel la tortorot, pa balanla i rakrakai, pa bel la tortorot onla ning la ka oroi tari ning ka kamtur ulak. ");
INSERT INTO lbb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I atai la mange, “Mulor han uting na rakrakan hanua rop, pa mulor warawai ana Wakak a Warwara tetek a taraila rop. ");
INSERT INTO lbb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Esining i tortorot pa di baptaisi, e God ir alauni. Ika esining bel i tortorot, e God ir saran a rakrakai a warkurai teteki sur ir mat. ");
INSERT INTO lbb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A tena tortorotla lar tol a ututnala na kulkulan larne: Lar kepsen a motla ana risak, lar warwara ana urmatana tona warwara, ");
INSERT INTO lbb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","lar tong a soila, pa ning lar gang a malum laulau, bel ir alaulau la, pa lar suah a kunla ana tinsamanla, pa lar langolango.” ");
INSERT INTO lbb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ning a Leklek e Iesu ka warwara tar tanla, e God i los kas pasi usaot na langit, pa i kes ting na sot a kuna. ");
INSERT INTO lbb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Anuna kakak a asaerla la han, pa la warawai ana hananua rop. Pa a Leklek i nangan la, pa i amomol tar anuna warwarala ana ututnala na kulkulan ning i han taum ono. ");
INSERT INTO lbb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tetek e Tiopilus, A galis la tohoi pa la ka tolsot pas a tumtumus ana ututnala ning i hanot arpotor imila. ");
INSERT INTO lbb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","La ning la ka oroi tar a ututnala ne tur pasi ana taim ning a ututnala ne i hanot, pa la sira asaer a tarai ana Wakak a Warwara, la atai mila ana ututnala ne. ");
INSERT INTO lbb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pa iau otleng, ia ka tikin otnan pas a ututnala ne tur pasi ana taim ning i hanot. I maining a nuki mang i wakak sur ar tumus tari tetek u, Tiopilus a leklek. Ar tumus a ututnala ne arlar ana armuri ot anunla, ");
INSERT INTO lbb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","sur ur tasmani mang a ututnala di ka asaer tar u onoi, i momol. ");
INSERT INTO lbb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ana rau ning e Herot i king ting na papar Judia, ning a tena artabar tetek e God a risana e Sekaria, miting na kunum a tena artabarla oe Abia. E Sekaria, anuna hane a risana e Elisabet, i otleng a mangis a tarai ane Aron. ");
INSERT INTO lbb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dia naur a tena tostos na matana e God, dia mur wakak a Warkuraila rop anuna Leklek. ");
INSERT INTO lbb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ika bel ta natundiau, anasa e Elisabet i pombo, pa dia ka lapun otleng. ");
INSERT INTO lbb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ning a pukakiar, ana pukakiarla na artabar anuna kunum ane Sekaria, e Sekaria i tol anuna titol a artabar na matana e God. ");
INSERT INTO lbb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Arlar ana toltol a aslang ning a tena artabarla tetek e God la sira muri, la aslang pas e Sekaria sur i ot ir kas ting na rumai artabar anuna Leklek, pa ir tun a utna ning a sasawana i toboh wakak. ");
INSERT INTO lbb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ning i tun a utna ning a sasawana i toboh wakak, a tarai a lotu ning la tur tumo lapiu la araring. ");
INSERT INTO lbb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A angelo anuna Leklek i hanot tetek e Sekaria, pa i tur ting na ris a sot ana logo na tun artabar, ning di tun a utna ning a sasawana i toboh wakak onoi. ");
INSERT INTO lbb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ning e Sekaria i oroi i, a palaona i suren, pa i matmataut kol onoi. ");
INSERT INTO lbb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ika a angelo i atai i mange, “Sekaria, gong u matmataut, e God ka longor anum a niaring, pa anum a hane e Elisabet ir agon pas a natum barsan, pa ur pasar a risana e Jon. ");
INSERT INTO lbb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ur gas kol onoi, pa galis otleng lar gas ana nuna agon, ");
INSERT INTO lbb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","anasa ir itna na matan a Leklek. Bel ir gang a wain pa gang laulaula, pa ning belot dir agoni, ka bukus ana Talngan Tabu. ");
INSERT INTO lbb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pa ir ben ulak a galis a tarai Israel tetek a Leklek a God anunla. ");
INSERT INTO lbb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ir rakrakai arlar ana propet Elaija, pa magirana otleng ir arlar onoi. Ir nigo tana Leklek, sur ir ben taum na tamtamana kakakla tetek na natnatunla sur lar aremoro ulak, pa ir ben a tarai a tabun longor sur a wakak a nuknuk anuna tostos a tarai, sur ir sang a tarai anuna Leklek sur anuna tinan ot.” ");
INSERT INTO lbb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","E Sekaria i deken a angelo mange, “Ar tasman mangasa i mang a utna ne ir hanot? Anasa mia ka lapun.” ");
INSERT INTO lbb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Pa angelo i kelesi mange, “Iau e Gebriel, a sira tur na matana e God. I ot i sune iau sur ar atai u, pa ar los a wakak a warwara ne tetek u. ");
INSERT INTO lbb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Oroi, onone bel ur tolsot sur warwara tuk ana pukakiar ning a utna ne ir hanot. Bel ur warwara, anasa bel u tortorot ana nuk a warwara, ning ir hanot tostos ana pukakiarna.” ");
INSERT INTO lbb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A tarai la nanan e Sekaria, pa la nuknuk kol mang sur asaning ka bongnani ting na rumai artabar. ");
INSERT INTO lbb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ning i purum, bel i tolsot sur ir warwara tetek la. Pa la tasmani mang e Sekaria ka oroi tar ta tatatai ting na rumai artabar, anasa i akinalang kama tetek la ana naur a kuna. ");
INSERT INTO lbb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ning ka rop anuna pukakiarla na titol, i ulak sur a hanua ngasna. ");
INSERT INTO lbb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pa lamur, e Elisabet anuna hane i tianan, pa dilima na kalang bel i han masik pas kusun a rumai. ");
INSERT INTO lbb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Pa i atongi mang, “Onone bot a Leklek i nangan iau pa ka kepsen a utna ning a meme onoi tana tarai.” ");
INSERT INTO lbb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ning ka diono na kalang ane Elisabet, e God i sune a angelo Gebriel utumo e Galili ana ning a hanua a risana e Nasaret. ");
INSERT INTO lbb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","I han tetek a basbas a risana e Maria, ning di ka aslang tari sur ir taulai e Josep, i ning miting na mangis a tarai ane king Dewit. ");
INSERT INTO lbb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A angelo i han tetek e Maria pa i atai i mange, “Ur gas, u angis kol! A Leklek i kes taum hom.” ");
INSERT INTO lbb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pa e Maria i nuknuk loklokron kol ana warwara ne, mang asa a kamkamna. ");
INSERT INTO lbb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pa angelo i atai i mange, “Maria, gong u matmataut, e God i gas kol hom. ");
INSERT INTO lbb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Longor! Ur tianan, ur agon pas a kaklik barsan, pa ur pasar a risana e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pa risana ir rarang, pa dir atongi mang a Nat e God esaning i Leklek Kol. Pa Leklek e God, ir akesi ana keskes a king ane tubuna e Dewit, ");
INSERT INTO lbb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","pa ir king tikin ana mangis a tarai ane Jekop, pa anuna matanitu bel ir rarop.” ");
INSERT INTO lbb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","E Maria i deken a angelo mang, “Ir mangmangasa? Anasa bel a lasan taum ana ta barsan.” ");
INSERT INTO lbb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A angelo i kelesi mang, “A Talngan Tabu ir kes hom, pa rakrakai e God i Leklek Kol ir poroi alar u. Larning a Tena Totoh ning ur agon pasi, dir atongi mang a Nat e God. ");
INSERT INTO lbb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oroi, a maim e Elisabet ka lapun, pa di atongi mang a pombo, ika onone ka tianan, pa ka diono na kalang anunai. ");
INSERT INTO lbb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anasa bel ta utna i ngangaten tetek e God.” ");
INSERT INTO lbb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pa e Maria i atongi mang, “Iau a tena titol oros anuna Leklek, i wakak ka ning dir toli hok arlar ana num a warwara.” Lamur a angelo i han kusuni. ");
INSERT INTO lbb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lamur e Maria i sang pas, pa i han kas kapit sur a hanua ning i kes saot na mangir ana papar Judia. ");
INSERT INTO lbb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","I kas ting na rumai ane Sekaria, pa i kabah na gasgas pas e Elisabet. ");
INSERT INTO lbb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ning e Elisabet i longor a arkabah na gasgas ane Maria teteki, a kaklik i pele ting na balana, pa e Elisabet i bukus ana Talngan Tabu. ");
INSERT INTO lbb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Pa i warwara ana tnan elngena mang, “U angis tana gurarala rop, pa kaklik otleng ning ur agoni i angis. ");
INSERT INTO lbb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Iau esi na ngas a hane ning e tana Leklek anuki ir han tetek iau? ");
INSERT INTO lbb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ning a longor anum a arkabah na gasgas tetek iau, a kaklik i gas, pa i pele te na balak. ");
INSERT INTO lbb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","U angis anasa u tortorot mang a warwara anuna Leklek tetek u ir hanot momol.” ");
INSERT INTO lbb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","E Maria i atongi mang, “A inguk i aleklek pas a Leklek, ");
INSERT INTO lbb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","pa balak i gas oe God, anuk a Tena Alaun, ");
INSERT INTO lbb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","anasa i maris iau anuna tena titol oros, ning iau a hane oros ka. Turpasi anone a mangis a taraila rop lar atongi hok mang a angis, ");
INSERT INTO lbb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","anasa esaning i Leklek Kol, ka tol tar a tatatnan ututnala hok, a risana i totoh. ");
INSERT INTO lbb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anuna marmaris i kes tetek la ning la hanrawai i, i kes tetek a tarai tagun onone, pa tagun lamur. ");
INSERT INTO lbb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I tol a rakrakai a titol ana kuna, pa ana rakrakaina i sune sarara la ning la rakan aleklek la ana nuknukinla. ");
INSERT INTO lbb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I kepsen purum a kingla kusun anunla keskes a leklek, pa i aleklek pas la ning la sira anatarna pas la. ");
INSERT INTO lbb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I tabar a kapan a tarai ana wakak a ututnala pa i sune oros sen a tena gongonla. ");
INSERT INTO lbb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","I nangan anuna tena titolla, a tarai Israel, pa i nuk pas anuna marmaris ");
INSERT INTO lbb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","tetek e Abaram pa anuna mangis a tarai tikin, larning ka atong tari tetek anundala mangis a tarai tagun nating.” ");
INSERT INTO lbb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pa e Maria i kes napirna e Elisabet arlar ana natol a kalang, pa lamur i ulak sur a hanua ngasna. ");
INSERT INTO lbb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ning a pukakiar ane Elisabet i sot sur ir agon onoi, i agon pas a kaklik barsan. ");
INSERT INTO lbb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A halalna pa na mainala la longori mang a Leklek i maris kol e Elisabet, pa la gas taum onoi. ");
INSERT INTO lbb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ning ka siwal a pukakiar anuna kaklik, la sang sur dir kot talilisi, pa la mang sur lar pasar a risana e tamana e Sekaria onoi. ");
INSERT INTO lbb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ika e tana i atongi mange, “Gong! A risana ot e Jon.” ");
INSERT INTO lbb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","La atongi tana mang, “Bel ta maim i kibas a rising ning.” ");
INSERT INTO lbb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lamur la tol a asilang ana kunla tetek e tamana, sur lar dekeni mang esi na rising ning i mang sur dir pasar a kaklik ono. ");
INSERT INTO lbb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pa i akinalang sur ta utna ning ir tumtumus onoi, pa i tumusi mang, “A risana e Jon.” La rop la kulkulan. ");
INSERT INTO lbb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ono otne a pahana e Sekaria i sapang, pa laigeremna i tapalas, pa i tur pas kakat a warwara, i atong leklek pas e God. ");
INSERT INTO lbb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pa na halalindiau rop, la matmataut kol. A warwarala ana ututnala ne, i han sarara ana hananuala ning la kes saot na mangir ana papar Judia. ");
INSERT INTO lbb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","La rop ning la longori, la nuknuk kol onoi, pa la atongi mang, “A kaklik ne ir hanot esi na ngas a barsan?” Anasa la oroi mang a rakrakai ana Leklek i kes onoi. ");
INSERT INTO lbb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","E Sekaria e tamana e Jon, i bukus ana Talngan Tabu, pa i warwara na propet mange, ");
INSERT INTO lbb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dalar aleklek pas a Leklek, a God anuna tarai Israel, anasa ka hanot tetek anuna tarai, pa ka alangolango pas la. ");
INSERT INTO lbb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ka saran tar a rakrakai a Tena Alaun tetek dala, miting na mangis a tarai ane Dewit, anuna tena titol, ");
INSERT INTO lbb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","larning ka atong tari nating ot ana pahana nuna totoh a propetla. ");
INSERT INTO lbb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ka saran tari sur ir alaun pas dala kusun anundala hiruala, pa kusun a kunla rop ning la nget dala, ");
INSERT INTO lbb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","pa sur ir maris anundala mangis a tarai tagun nating pa ir tolsot pas anuna totoh na kunubus. ");
INSERT INTO lbb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I lele tar tetek a tubundala e Abaram, ");
INSERT INTO lbb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","mang ir alaun dala kusun a kuna nundala hiruala, sur dalar titol teteki pa bel dalar matmataut. ");
INSERT INTO lbb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dalar titol teteki ana toltol ning i totoh pa i tostos na matana, ana nundala pukakiarla ana lalaun rop. ");
INSERT INTO lbb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pa u a natuklik, dir atong u, a propet ane God esaning i Leklek Kol, anasa ur han nigo tana Leklek, sur ur tol nigon anuna ngas, ");
INSERT INTO lbb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","sur ur atalapor anuna tarai mang dir alaun pas la mangmangasa. Dir kepsen tar anunla na toltol laulaula, ");
INSERT INTO lbb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","anasa ana tnan marmaris anuna God anundala. Pa ana nuna marmaris a talapor misaot ir sasai ot tetek dala. ");
INSERT INTO lbb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ir sasai onla ning la kes ana mormorom, pa ana mormorom a minat, sur ir nigon dala ana ngas a balmolmol.” ");
INSERT INTO lbb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pa kaklik i itna amon, pa i rakrakai ana inguna. Pa i kes ting na hanua bel tuk ning i turot tetek a tarai Israel. ");
INSERT INTO lbb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ana rau ning, e Sisar Augustus i warkurai i sur dir tumus a risana tarai ting na hananuala rop ning la kes nahai a matanitu Rom. ");
INSERT INTO lbb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ine a ningnigo na pukakiar ning di tumus a risandi, ning e Kwirinius i a ningnigo tumo na papar Siria. ");
INSERT INTO lbb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pa taraila rop la han uting na anunla na hananuala momol sur dir tumus a risanla. ");
INSERT INTO lbb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","E Josep otleng i han miting na hanua Nasaret ana papar Galili to e Betlihem ana papar Judia. E Betlihem, a hanua ning di agon e Dewit ia, pa e Josep i han uto, anasa i miting na mangis a tarai ane Dewit. ");
INSERT INTO lbb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I han sur dir tumus a risana, taum ana risana e Maria ning di ka aslang tari sur ir taulai i. Ning dia han e Maria ka tianan. ");
INSERT INTO lbb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pa ning dia kes to e Betlihem, a pukakiar i sot sur e Maria ir agon, ");
INSERT INTO lbb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","pa i agon pas a ningnigo na natnalik, a kaklik barsan. Pa i poroi i ana kaenla anuna kakakla, pa i aborbori ting na bok ning a inagoila la sira hangan onoi, anasa a rumai wasira ka bukus pas kusun ditol. ");
INSERT INTO lbb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dingla na tena tai alar ana sipsipla, la tai alar anunla na liur a sipsip ana morom saot milau a hanua ning. ");
INSERT INTO lbb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pa angelo anuna Leklek i hanot tetek la, pa matatar anuna Leklek i talapor talilis la, pa la matmataut kol. ");
INSERT INTO lbb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A angelo i atai la mange, “Gong mulo matmataut. Mulo oroi, a hanot tetek mulo ana wakak a warwara ning ir agasgas a taraila rop. ");
INSERT INTO lbb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Onone, ting na hanua ane Dewit, di ka agon tar anumulo a Tena Alaun, ai a Karisito, a Leklek. ");
INSERT INTO lbb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pa mulor tai sur ta asilang mang: A kaklik di poroi tari ana kaenla ana kakakla, pa di aborbor tari ting na bok a hangan ana inagoila.” ");
INSERT INTO lbb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bel i bongnani pa tnan kunum a angelo misaot na langit la hanot tetek a angelo ning, pa la atong leklek pas e God mange, ");
INSERT INTO lbb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dalar atong leklek a risana e God tisaot kol, pa balmolmol te na rakrakan hanua rop tetek la ning i gas onla.” ");
INSERT INTO lbb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ning a angelola la ka han kusun la usaot na langit, a tena tai alarla ana sipsipla, la warwara artalai la mang, “Ano otne dala kar han utumo e Betlihem, dalar oroi a utna ne ka hanot, ning a Leklek ka atai tar dala onoi.” ");
INSERT INTO lbb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pa la han kapit, pa la pastetek pas e Maria pa e Josep pa kaklik betbete ning i borbor tar ting na bok a hangan ana inagoila. ");
INSERT INTO lbb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ning la ka oroi tar a kaklik, la patuai talapor ana warwara ning a angelo ka atai tar la onoi ana kaklik ning. ");
INSERT INTO lbb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pa la rop ning la longor a warwara anuna tena tai alarla ana sipsipla, la kulkulan onoi. ");
INSERT INTO lbb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ning e Maria i longor a warwara ne, i tong akesi ana balana pa i nuknuk kol onoi. ");
INSERT INTO lbb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A tena tai alarla ana sipsipla la ulak, la aleklek pas e God pa la atong leklek ana utna ning la longori pa la ka oroi tari, arlar ana warwara anuna angelo tetek la. ");
INSERT INTO lbb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ning ka siwal a pukakiar anuna kaklik, pa ka sot sur dir kot talilis a palaona, di pasar a risana e Iesu. A rising ning, a angelo ot ka atong tari nating, ning e Maria belot i tianan. ");
INSERT INTO lbb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","E Josep pa e Maria dia tolsot pas a pukakiarla na atotoh, arlar ana warkurai ane Moses. Pa ning ka rop, dia han usaot e Jerusalem sur diar artabar ana “naur a tabun o naur a barman a balus,” arlar ana warwara na warkurai anuna Leklek. Pa dia los e Iesu otleng usaot e Jerusalem, sur diar saran tari tetek a Leklek, larning di ka tumus tari ana warkurai anuna Leklek mang, “A ningnigo na kakak barsanla rop pa ningnigo na barsan a inagoila, dir saran la tetek a Leklek.” ");
INSERT INTO lbb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ning a barsan i kes saot e Jerusalem a risana e Simion, a tena tostos pa tena hanrawai tetek e God. I harnanai sur e God ir alaun a tarai Israel, pa Talngan Tabu i kes onoi. ");
INSERT INTO lbb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A Talngan Tabu ka atalapor tari teteki mang bel ir mat tuk ning ir oroi tar ot a Karisito anuna Leklek. ");
INSERT INTO lbb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A Talngan Tabu i nigon kasi uting na woroh na rumai artabar. Ning disuana los kas a kaklik e Iesu sur diar tol a artabar larning di ka tumus tari ana warkurai, ");
INSERT INTO lbb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","e Simion i kibas pas e Iesu ana naur a kuna. Pa i atong leklek e God mange, ");
INSERT INTO lbb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Leklek, onone ur alangolango iau, anum a tena titol oros, sur ar han ana balmolmol, arlar ana num a lele. ");
INSERT INTO lbb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Anasa a matak ka oroi tar a Tena Alaun, ");
INSERT INTO lbb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ning u ka sang tari na matana mangis a taraila rop. ");
INSERT INTO lbb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ai a talapor ning ir atalapor anum a ngas tetek la ning bel a tarai Israel, a talapor sur a matatar tetek anum a tarai Israel.” ");
INSERT INTO lbb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E Tamana pa e tana dia kulkulan kol ana warwara ne e Simion i atongi oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","E Simion i angis ditol, pa i atai e Maria, e tana e Iesu, mang, “A kaklik ne, e God i aslang pasi sur a galis a tarai Israel lar hirua onoi pa galis otleng lar laun onoi, pa ai a akinalang ning a galis a tarai lar bilbilori. ");
INSERT INTO lbb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ning lar bilbilori dir atalapor a nuknuk miting na balana a galis a tarai. Pa u, a bal mamahat ning ur kilangi ir arlar ana liwan a harum ning ir so anum a lalaun.” ");
INSERT INTO lbb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Pa ning a hane, a propet, a risana e Ana, ano otning i hanot tetek ditol. A hane ne a nat e Panuel, miting na mangis a tarai e Aser. Ka wan laulau, ka siwal a bonot pa pisir diat a rau anunai pa ka lao. Dia taulai pas ka mais a rau pa lamur anuna barsan i mat. A hane ne bel i han kusun a rumai artabar, i lotlotu ana kabakiarla pa moromla, i sira tamai pa i sira araring. Ning i hanot na pirinditol i atong wakak tetek e God, pa i warwara ana kaklik tetek la rop ning la harnanai sur e God ir alaun pas a tarai Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ning e Josep pa e Maria dia ka tolsot pas a ututnala rop arlar ana warkurai anuna Leklek, ditol ulak utumo e Galili sur anunla hanua Nasaret. ");
INSERT INTO lbb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pa kaklik i itna amon pa i rakrakai, pa i bukus ana tastasman, pa marmaris ane God i kes onoi. ");
INSERT INTO lbb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ana raula rop, e tamana e Iesu pa e tana dia sira han usaot e Jerusalem ana lotu na Han Lakai. ");
INSERT INTO lbb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ning ka ning a bonot pa pisir naur a rau ane Iesu, ditol han usaot e Jerusalem sur a lotu na Han Lakai, larotning la sira toli. ");
INSERT INTO lbb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ning a lotu ka rop pa la ulak amon, e Iesu i kes suai saot e Jerusalem, ika e tamana pa e tana bel dia tasmani. ");
INSERT INTO lbb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dia nuki mang e Iesu i han taum ana taraila. Ning ka takai a pukakiar ana nunla tinan ulak, dia turpasi sur diar tai sur e Iesu ting na arpotor na mainditol, pa halalinditol. ");
INSERT INTO lbb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ning dia tai panai tar suri, dia ulak usaot e Jerusalem, sur diar tai suri tisaot. ");
INSERT INTO lbb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ning dia ka tai pas natol a pukakiar, dia pastetek pas e Iesu tingui na woroh na rumai artabar. I kes taum ana tena asaerla tagun a warkurai, i longor la, pa i deken la ana kabahla. ");
INSERT INTO lbb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pa la rop ning la longori, la kulkulan ana nuna tastasim, pa ana nuna arkeles tetek la. ");
INSERT INTO lbb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ning dia oroi pasi, dia kulkulan, pa e tana i atai i mange, “Natuklik, sur asaning u toli larne omiau? Mia ma e tamam mia ka seren panan tar u, pa mia matmataut kol hom.” ");
INSERT INTO lbb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pa i deken diau mange, “Asaning mu seren iau suri? Bel mu tasmani mang i tostos sur ar kes te na rumai ane Tata?” ");
INSERT INTO lbb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ika bel dia talapor ana nuna warwara. ");
INSERT INTO lbb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lamur ditol ulak utumo e Nasaret, pa i sira longlongor kol tandiau, pa e tana i nuk akes a ututnala rop ning. ");
INSERT INTO lbb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A palaona e Iesu i itna amon pa nuna tastasman otleng i gomo, pa gasgas ane God pa anuna tarai otleng i gomo ono. ");
INSERT INTO lbb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ka takai a bonot pa pisir dilima na rau ana matanitu ane Sisar Tiberius, e Pontius Pailat a tnan ningnigo tumo na papar Judia, pa e Herot a ningnigo ting na papar Galili, pa e tasnalik e Pilip a ningnigo ting na naur a papar Ituria pa e Trakonitis, pa e Lisanias a ningnigo ting na papar Abilene ");
INSERT INTO lbb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","pa e Anas pa e Kaiapas dia kibas a titol a ningnigo na tena artabar tetek e God. Ana rau ning, a warwara ane God i hanot tetek e Jon, a nat e Sekaria, ning i kes saot na hanua bel. ");
INSERT INTO lbb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pa i han uting na puknala rop milau a malum Jodan, i warawai sur a tarai lar lingir a nuknukinla pa dir baptais la, pa e God ir kepsen anunla na toltol laulaula. ");
INSERT INTO lbb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Larning di ka tumus tari ting na buk anuna propet Aisaia mang, “A elngena mainla i arkabah ting na hanua bel mang, ‘Mulor sang a ngas anuna Leklek, mulor atostos anuna ngasla. ");
INSERT INTO lbb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A lawala rop dir por la pa pukaleklekla rop pa mangirla dir kel tostos la. A ngasla rop ning la ngokngok dir atostos la, pa puknala ning la tungtung, dir por tostos la. ");
INSERT INTO lbb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pa taraila rop lar oroi a titol ane God ning i alaun a tarai ono.’” ");
INSERT INTO lbb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A kunum a tarai la hanot tetek e Jon sur ir baptais la. Pa i atai la mang, “Ai, mulo na natnat a soi! Bel mulor tolsot sur mulor liu kumna kusun a balakut ane God ning ir hanot. ");
INSERT INTO lbb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ning mulo ka lingir momol a nuknukimulo, mulor tol a ututnala ning ir apuasa i mang mulo ka lingir a nuknukimulo. Pa gong mulo nuki mang e God bel ir warkurai mulo anasa mulo a mangis a tarai ane Abaram. A atai mulo, e God i tolsot sur ir tol otnan a mangis a tarai ane Abaram tagun a hatatla ne. ");
INSERT INTO lbb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Di ka suah tar a hek ting na kama rakaila, pa rakaila rop ning bel la suah al wakak a wanala, dir ting sen la, pa dir migen la uting na iah.” ");
INSERT INTO lbb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A kunum a tarai la dekeni mang, “Asa milar toli?” ");
INSERT INTO lbb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","I keles la mang, “Esining anuna ir naur a kaen a mermer, ir saran tik tana tik ning bel anuna ta kaen a mermer, mang otleng larning ana utna na hangan.” ");
INSERT INTO lbb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pa dingla na tena los totokom la hanot sur ir baptais la. Pa la dekeni mange, “Tena asaer, asa milar toli?” ");
INSERT INTO lbb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Pa i keles la mange, “Gong mulo kibas totokom i itna tana asaning a matanitu ka suah tari.” ");
INSERT INTO lbb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pa dingla na tena harum la dekeni mang, “Pa mila, asa milar toli?” Pa i keles la mang, “Gong mulo angongos pas ta mani kusun a tarai, pa gong mulo artitiu asasongo, mulor gas ka ana numulo na arlou.” ");
INSERT INTO lbb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A tarai la harnanai sur e Karisito. Ning la longor e Jon, la nuki mang ngandek ai a Karisito. ");
INSERT INTO lbb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pa e Jon i atai la rop mang, “A baptais mulo ana malum, ika esaning a rakrakaina i itna tana rakrakaik ir hanot. Pa bel a tolsot sur ar pak sen a inau ana anuna su. A natarna kol tana. I ir baptais mulo ana Talngan Tabu pa iah. ");
INSERT INTO lbb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I tong pas anuna saol ana naur a kuna sur ir migen a witla usaot sur a wuwu ir wus sen a palpalnala kusun a patnala. Ning ka tol rop tari, ir suah taum anuna wit ting na rumai a wit, pa ir tun sen a palpalnala ting na iah ning bel i sira mat.” ");
INSERT INTO lbb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ning e Jon i warawai tetek la ana Wakak a Warwara i arakrakai la ana galis a warwara sur lar lingir anunla na toltol. ");
INSERT INTO lbb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pa e Jon i warwara rakrakai tetek e Herot a ningnigo tagun a matanitu, anasa i taulai ulak e Herodias, a hane ane tasnalik, pa i tol otleng a laulau a ututnala. ");
INSERT INTO lbb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pa e Herot i tol ulak a toltol laulau ning i akas e Jon ting na karabus. ");
INSERT INTO lbb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ning e Jon i baptais amon a taraila rop, i baptais otleng e Iesu. Pa ning i araring, a langit i sapang, ");
INSERT INTO lbb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","pa Talngan Tabu i han purum, i suah a palaona lar a tabun, pa i kes saot oe Iesu. Pa elngena mainla misaot na langit i atongi mang, “U a Natuklik, a katnan u, a gas kol hom.” ");
INSERT INTO lbb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","E Iesu i turpas anuna titol ning ngandek i natol a bonot a rau a lalaun anunai. A tarai la nuki mang ai a nat e Josep. E Josep a nat e Heli, ");
INSERT INTO lbb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","e Heli a nat e Matat, e Matat a nat e Liwai, e Liwai a nat e Melki, e Melki a nat e Janai, e Janai a nat e Josep, ");
INSERT INTO lbb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","e Josep a nat e Matatias, e Matatias a nat e Amos, e Amos a nat e Nahum, e Nahum a nat e Esli, e Esli a nat e Nagai, ");
INSERT INTO lbb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","e Nagai a nat e Mat, e Mat a nat e Matatias, e Matatias a nat e Semen, e Semen a nat e Josek, e Josek a nat e Joda, ");
INSERT INTO lbb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","e Joda a nat e Joanan, e Joanan a nat e Resa, e Resa a nat e Serubabel, e Serubabel a nat e Salatiel, e Salatiel a nat e Neri, ");
INSERT INTO lbb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","e Neri a nat e Melki, e Melki a nat e Adi, e Adi a nat e Kosam, e Kosam a nat e Elmadam, e Elmadam a nat e Er, ");
INSERT INTO lbb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","e Er a nat e Josua, e Josua a nat e Elieser, e Elieser a nat e Jorim, e Jorim a nat e Matat, e Matat a nat e Liwai, ");
INSERT INTO lbb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","e Liwai a nat e Simion, e Simion a nat e Juda, e Juda a nat e Josep, e Josep a nat e Jonam, e Jonam a nat e Eliakim, ");
INSERT INTO lbb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","e Eliakim a nat e Melea, e Melea a nat e Mena, e Mena a nat e Matata, e Matata a nat e Natan, e Natan a nat e Dewit, ");
INSERT INTO lbb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","e Dewit a nat e Jesi, e Jesi a nat e Obet, e Obet a nat e Boas, e Boas a nat e Salmon, e Salmon a nat e Nason, ");
INSERT INTO lbb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","e Nason a nat e Aminadap, e Aminadap a nat e Atmin, e Atmin a nat e Arni, e Arni a nat e Hesron, e Hesron a nat e Peres, e Peres a nat e Juda, ");
INSERT INTO lbb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","e Juda a nat e Jekop, e Jekop a nat e Aisak, e Aisak a nat e Abaram, e Abaram a nat e Tera, e Tera a nat e Nahor, ");
INSERT INTO lbb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","e Nahor a nat e Seruk, e Seruk a nat e Reu, e Reu a nat e Pelek, e Pelek a nat e Eber, e Eber a nat e Sela, ");
INSERT INTO lbb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","e Sela a nat e Kainan, e Kainan a nat e Arpaksat, e Arpaksat a nat e Sem, e Sem a nat e Noa, e Noa a nat e Lamek, ");
INSERT INTO lbb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","e Lamek a nat e Metusela, e Metusela a nat e Enok, e Enok a nat e Jaret, e Jaret a nat e Mahalalel, e Mahalalel a nat e Kenan, ");
INSERT INTO lbb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","e Kenan a nat e Enos, e Enos a nat e Set, e Set a nat e Adam, e Adam a nat e God. ");
INSERT INTO lbb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","E Iesu i bukus ana Talngan Tabu. Ning i han mito na malum Jodan, a Talngan Tabu i nigoni uting na hanua bel. ");
INSERT INTO lbb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","I kes tingia diat a bonot a pukakiar pa bel i hangan, pa e Satan i lari. Ning ka rop a pukakiarla ning, i murak. ");
INSERT INTO lbb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pa e Satan i atai i mange, “Ning u a Nat e God, ur atai a hat ne sur ir hanot a bret.” ");
INSERT INTO lbb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","E Iesu i kelesi mang, “Di ka tumus tari ting na Buk Tabu mange, ‘A tarai bel la sira laun ka ana utna na hangan.’” ");
INSERT INTO lbb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","E Satan i ben pasi uting na ning a pukna tisaot, pa ana tuka kamis ka, i asangan tar a hananuala rop te na rakrakan hanua tana. ");
INSERT INTO lbb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Pa i atongi tana mang, “Ar saran tar a matatarinla pa a rakrakainla rop tam sur ur warkurai sur la rop, anasa di ka saran tari tak, pa ar sarani tetek tik ning a mang suri. ");
INSERT INTO lbb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ning ur lotu tetek iau, a ututnala rop ne anumi ka.” ");
INSERT INTO lbb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","E Iesu i atongi tana mang, “Di ka tumus tari ting na Buk Tabu mange, ‘Ur lotu tetek a Leklek anum a God, pa ur longor ka tana.’” ");
INSERT INTO lbb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pa e Satan i ben pasi usaot e Jerusalem, pa i atur tari sot ot na pukul a rumai artabar. Pa i atongi tana mang, “Ning u a Nat e God, ur sirok purum mite, ");
INSERT INTO lbb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","anasa di ka tumus tari ting na Buk Tabu mang, ‘Ir sune anuna angelola sur lar tai alar wakak u. ");
INSERT INTO lbb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Lar tong pas u ana kunla, sur gong u buh a ham ana ta hat.’” ");
INSERT INTO lbb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","E Iesu i kelesi mang, “Di ka atong tari ting na Buk Tabu mang, ‘Gong u lar a Leklek anum a God.’” ");
INSERT INTO lbb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ning e Satan ka lar tari, i han pas kaba kusuni. ");
INSERT INTO lbb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","E Iesu i ulak utumo na papar Galili ana rakrakai ana Talngan Tabu, pa warwara onoi i han sarara ting na papar rop ning. ");
INSERT INTO lbb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pa e Iesu i asaer a tarai ting na nunla na rumai lotula, pa la rop la atong leklek pasi. ");
INSERT INTO lbb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ning e Iesu i hanot to e Nasaret, a hanua ning i itna tar ia, i kas uting na rumai lotu ana Pukakiar Sabat, arlar ot ana nuna toltol, pa i tur sur ir wawas. ");
INSERT INTO lbb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pa di saran tar a buk anuna propet Aisaia teteki. I sapang a buk ning di ka hin tari, pa i pastek pas a pukna ning di ka tumus tari onoi mange, ");
INSERT INTO lbb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“A inguna Leklek i kes hok, anasa ka aslang pas iau sur ar warawai ana wakak a warwara tana kapan a tarai. I sune iau sur ar warawai mange, dir pak sen la ning di dot akes tar la, dir apalpalas ulak la ning a matanla i kut, pa dir alangolango la ning la kilang a mamahatla ning di tol tari onla, ");
INSERT INTO lbb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","pa ar warwara ana rau ning a Leklek ir asangan anuna marmaris.” ");
INSERT INTO lbb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","I hin ulak a buk ning, i sarani tetek a tena titol, pa i kes. A taraila rop tingui na rumai lotu la ngoson rakrakai i, ");
INSERT INTO lbb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","pa i atai la mange, “A warwara ne mulo longori, onone di ka tolsot pasi.” ");
INSERT INTO lbb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","La gas pasi, pa la kulkulan ana nuna wakak a warwara. Pa la atongi onoi mang, “A barsan ne a nat e Josep ka, gepi?” ");
INSERT INTO lbb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Pa i atai la mang, “Sakana mulor atong a ngas a warwarala ne hok: ‘Dokta, ur alangolango pas u ot! A ututnala ning mila longori mang u ka tol tari to e Kapernaum, i wakak ning ur toli otleng te na hanua ngasim.’” ");
INSERT INTO lbb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pa e Iesu i atai la mang, “A atong momoli tamulo, bel ta propet di sira gas pasi ting na hanua ngasna. ");
INSERT INTO lbb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A momolna ot mang a galis a lao la kes tumo e Israel ana rau ane Elaija, ning natol a rau pa diono na kalang bel al kiar, pa tnan munurak i kibas a hananuala rop. ");
INSERT INTO lbb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ika e God bel i sune e Elaija tetek ta te Israel, tetek a lao ka ting na hanua Sarepat tumo na papar Saidon. Esaning bel a hane Israel. ");
INSERT INTO lbb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pa galis a lepra la kes tumo e Israel ana rau anuna propet Elisa, ika e God bel i alangolango tik onla, e Naman ka a barsan misaot e Siria, ning bel a te Israel.” ");
INSERT INTO lbb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A taraila rop ning la kes ting na rumai lotu, la bukus ana balakut, ning la longor a warwarala ne. ");
INSERT INTO lbb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","La kamtur, pa la lu sen e Iesu kusun anunla hanua. La ben pasi saot na mangir ning la ka tol anunla hanua onoi, sur lar migen purumi ting na ris a hat. ");
INSERT INTO lbb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ika i han potor ting na kunum a tarai, pa i han ana nuna tinan. ");
INSERT INTO lbb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lamur e Iesu i han utumo e Kapernaum, ting na papar Galili, pa ana Pukakiar Sabat i asaer a tarai. ");
INSERT INTO lbb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","La kulkulan ana nuna asaer, anasa i asaer la arlar o esaning a warkurai kaning tana. ");
INSERT INTO lbb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tingui na rumai lotu, ning a barsan kaning, a mot i solongi, i kukuk rakrakai mange, ");
INSERT INTO lbb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ai! U e Iesu a te Nasaret. Ur tol asa omila? U hanot sur ur alaulau mila? A tasman u ot, u a Tena Totoh ane God.” ");
INSERT INTO lbb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","E Iesu i sairasi mange, “Gong u warwara! Purum kusun a barsan ning!” A mot i migen purum tari na matanla rop, i purum kusuni, pa bel ta puka palaona i laulau. ");
INSERT INTO lbb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A tarai rop la kulkulan kol, pa la deke artalai la mang, “Esi na ngas a warwara ine? A warkurai pa rakrakai kaning tana, pa ana nuna warwara i kepsen sen a motla, pa la purum kakat.” ");
INSERT INTO lbb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pa warwara oe Iesu i han sarara ting na hananuala rop tumo na papar ning. ");
INSERT INTO lbb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","E Iesu i purum kusun a rumai lotu, pa i han sur uting na rumai ane Saimon. Pa e anmuna e Saimon, a hane, i sasam ana laplapang, pa la nunung e Iesu sur ir nangani. ");
INSERT INTO lbb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pa e Iesu i tur ting na ngasna, pa i kepsen a laplapang kusuni, pa hane ning i langolango. Ano otning i kamtur, pa i tabar la ana utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ning ka rah morom, a tarai la ben pas la ning la sasam ana urmatana tinsaman tetek e Iesu. Pa i suah naur a kuna onla taktakai, pa la langolango. ");
INSERT INTO lbb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pa motla otleng la purum kusun a galis, pa la kukuk mang, “U a Nat e God.” Ika e Iesu i sairas la, sur gong la warwara, anasa la tasmani ot mang ai a Karisito. ");
INSERT INTO lbb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ning ka kabakiar, e Iesu i han sur uting na hanua bel. A kunum a tarai la sereni. Ning la pasteteki, la tohi sur lar sairasi sur gong i han kusun la. ");
INSERT INTO lbb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ika i keles la mang, “Ar warawai ana Wakak a Warwara ana matanitu ane God ting na dingla na hananua masik otleng. Anasa ine a kamkamna ning i sune iau ute.” ");
INSERT INTO lbb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pa i sira warawai amon ting na rumai lotula ting na papar Judia. ");
INSERT INTO lbb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ning a pukakiar, ning e Iesu i tur tumo latasi ana puka tasi Genesaret, a tarai la tur talilis pasi, sur lar longor a warwara ane God. ");
INSERT INTO lbb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pa i oroi pas naur a mon ting latasi, ning dingla na tena migen uben la ka han kusun diau, kaning la gos anunla na uben. ");
INSERT INTO lbb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pa e Iesu i kas ana ning halindiau, a mon ning ane Saimon, pa i atai i mang ir sugut siklik tar a mon usa latasi. Pa e Iesu i kes onoi, pa i asaer a kunum a tarai. ");
INSERT INTO lbb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ning ka rop anuna warwara, i atai e Saimon mang, “Mulor han usa na laman, pa mulor migen anumulo na uben sur al sis.” ");
INSERT INTO lbb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","E Saimon i atai i mang, “Tena Asaer, mila tol panai kol ana kidol a morom, pa bel mila dat pas al sis. Ika, ar migen ulak tar na uben, anasa u arsune.” ");
INSERT INTO lbb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ning la migen tar la, la dat pas a galis a sis, pa nunla na uben milau lar taksilir. ");
INSERT INTO lbb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","La kali pas na halalinla miting na ning a mon sur lar nangan la. Pa la han tetek la, pa la abukus pas naur a mon rop, pa milau diar murung. ");
INSERT INTO lbb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ning e Saimon Pita i oroi a utna ne, i punga purum napir a hana e Iesu pa i atai i mang, “Leklek, han kusun iau, iau a tena laulau.” ");
INSERT INTO lbb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","I atongi larne anasa e Saimon pa la ning la armuri la kulkulan ana sisla ning la dat pasi, ");
INSERT INTO lbb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","mang otleng larning tetek naur a halalna, e Jems pa e Jon, naur a nat e Sebedi. E Iesu i kelesi mang, “Gong u matmataut. Turpasi onone, ur dat a taraila.” ");
INSERT INTO lbb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ning la ka dat tar naur a mon, la han kusun anunla ututnala rop, pa la mur e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","E Iesu i kes ting na ning a hanua, pa ning a barsan a palaona rop i laulau ana lepra i kes tingia. Ning i oroi pas e Iesu, i punga purum ana patarna ting na piu pa i nunung rakrakai i mang, “Leklek, ning u mang, ur tolsot sur ur alangolango pas iau.” ");
INSERT INTO lbb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pa e Iesu i tuslan a kuna, i tong a palaona pa i atai i mang, “A mang ot, ur langolango.” Ono otning a lepra i rop kusuni. ");
INSERT INTO lbb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lamur e Iesu i warwara rakrakai teteki mang, “Gong u atai tar tik ono. Ur han pa ur asangan u tetek a tena artabar tetek e God, pa ur saran a artabar tetek e God larning e Moses ka atong tari. Ning ur toli larne ir talapor tetek a taraila mang a palaom ka wakak ulak.” ");
INSERT INTO lbb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ika a warwara oe Iesu ka han sarara, pa galis a tarai la han taum sur lar longori, pa sur ir alangolango pas la kusun anunla na tinsaman. ");
INSERT INTO lbb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ika a galis a pukakiar e Iesu i sira han masik utumo na hanua bel, sur ir araring. ");
INSERT INTO lbb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ning a pukakiar ning e Iesu i asaer a tarai, dingla na Parisaio pa dingla na tena asaerla tagun a warkurai, la kes tingia. La hanot miting na hananuala rop ting na papar Galili pa papar Judia pa misaot e Jerusalem otleng. Pa rakrakai ana Leklek i kes oe Iesu sur ir alangolango na tinsaman. ");
INSERT INTO lbb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dingla na barsan la los a barsan ting na logo ngasna. A barsan ning a palaona i mat. La tohoi sur lar kas onoi, sur lar aborbori salanigo ta e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ika bel la tolsot sur lar kas onoi, anasa a tnan kunum a tarai. La abit taum onoi usaot na rumai, la kepsen pas ning a pukna tisaot, pa la alorong purum amoni ana logo ngasna na arpotor a kunum a tarai, tostos ting lanigo ta e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ning e Iesu i oroi anunla tortorot, i atai i mang, “Halik, di ka kepsen tar anum na toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A tena asaerla tagun a warkurai pa Parisaiola, la nuknuk ana nuknukinla mang, “Esi na ngas a barsan ne? Ning i warwara larning, i atong saksakan e God anasa i warwara larning i e God. Esi ir kepsen a toltol laulaula? E God ka.” ");
INSERT INTO lbb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ika e Iesu ka tasman tar a nuknukinla, pa i deken la mange, “Sur asa mulo nuknuk larne? ");
INSERT INTO lbb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Esi na ngas a warwara ning bel i ngangaten sur ar atongi? Ar atongi mang, ‘Di ka kepsen tar anum na toltol laulaula,’ o ar atongi mang, ‘Ur kamtur, pa ur han’? ");
INSERT INTO lbb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ar atongi larne sur mulor tasmani mang e God ka saran tar a warkurai tetek a Nat a Barsan sur ir kepsen a toltol laulaula te lapiu.” Pa i atai a barsan ning a palaona i mat mange, “A atai u, ur kamtur, ur kibas a logo ngasim, pa ur han uting na rumai ngasim.” ");
INSERT INTO lbb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ano otning i tur salanigo tanla rop, i kibas a logo ngasna, pa i han uting na rumai ngasna. Ning i han amon i atong leklek pas e God. ");
INSERT INTO lbb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pa la rop la kulkulan, la rakan aleklek pas e God, a palaonla i suren, pa la atongi mang, “Onone, dala oroi a maskana utna i totoh ana ororoi anundala.” ");
INSERT INTO lbb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ning ka rop a ututnala ne, e Iesu i han pa i oroi pas a tena los totokom, a risana e Liwai, i kes ting na rumai a los totokom, pa e Iesu i atai i mange, “Ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pa e Liwai i kamtur pa i han kusun anuna ututnala rop, pa i muri. ");
INSERT INTO lbb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lamur e Liwai i tol a tnan utna na hangan oe Iesu ting na rumai ngasna. A galis a tena los totokom pa dingla na tarai otleng la kes taum oe Iesu ana utna na hangan ne. ");
INSERT INTO lbb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dingla na Parisaio pa anunla na tena asaerla tagun a warkurai, la warwara na ururai tetek anuna kakak a asaerla mange, “Sur asa mulo hangan pa mulo gang taum ana tena los totokomla pa tena laulaula?” ");
INSERT INTO lbb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","E Iesu i keles la mange, “A dokta bel i hanot sur la ning la langolango. I hanot sur la ka ning la sasam. ");
INSERT INTO lbb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bel a hanot sur a tena tostosla. A hanot sur ar kabah pas a tena laulaula sur lar lingir a nuknukinla.” ");
INSERT INTO lbb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dingla na tarai la atai e Iesu mange, “A kakak a asaerla ane Jon la sira tamai pa la sira araring, mangotleng lar a kakak a asaerla anuna Parisaiola. Ika anum na kakak a asaerla la hangan pa la gang.” ");
INSERT INTO lbb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","E Iesu i keles la mange, “Ning ta barsan ir taulai totoh, na halalna lar tamai mangmangasa ning a barsan ning kaning ot i kes taum onla? ");
INSERT INTO lbb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ika ta pukakiar ir hanot, ning dir ben maskan pas a barsan ning kusun la, pa ana pukakiar ning lar bot tamai.” ");
INSERT INTO lbb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","E Iesu i warwara larlar otleng tetek la mange, “Bel tik ir silir pas ta diah kaen miting na tona kaen, sur ir suk ahati ana turai a kaen. Ning ir toli larning, ir silir laulau a tona kaen, pa tona diah kaen bel ir arlar taum ana turai a kaen. ");
INSERT INTO lbb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pa bel tik ir tere a tona wain uting na turai a koto na wainla ning di toli ana palaona inagoi, sakana a kotola lar tapuros pa lar laulau, pa wain ir tapek. ");
INSERT INTO lbb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dir tere ot a tona wain uting na tona koto na wainla. ");
INSERT INTO lbb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bel tik ning ka gang pas a turai a wain, ir mang ulak sur a tona wain, ir atongi ka mang, ‘A turaina ot i wakak.’” ");
INSERT INTO lbb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ana ning a Pukakiar Sabat, e Iesu i han potor ting na barim a wit, pa anuna kakak a asaerla la turpas a kumut kutus a witla, la gisgisi ana kunla pa la ieni. ");
INSERT INTO lbb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dingla na Parisaio la deken e Iesu mange, “Sur asaning mulo tol a utna ning pa bel mulo mur a warkurai tagun a Pukakiar Sabat?” ");
INSERT INTO lbb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pa e Iesu i keles la mange, “I mangasa, belot mulo was asaning e Dewit i toli ning la murak taum ana taraila ning la armuri? ");
INSERT INTO lbb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I kas uting na rumai ane God, i kibas pas a bret ning di tabar tar e God ono, i ieni, pa i tabar la otleng ning la armuri. A bret ning di sairasi kusun a tarai oros. I arlar ana Warkuraila sur a tena artabarla ka tetek e God lar ieni.” ");
INSERT INTO lbb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pa e Iesu i atai la mange, “A Nat a Barsan a Leklek tagun a Pukakiar Sabat.” ");
INSERT INTO lbb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ana ning a Pukakiar Sabat ulak, e Iesu i kas uting na rumai lotu, pa i asaer a taraila. Pa ning a barsan kaning ia, a sot a kuna i del. ");
INSERT INTO lbb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A Parisaiola pa tena asaerla tagun a warkurai la tai sur ta ngas ning lar tiu e Iesu ono, pa la ngoson murmuri mang ir alangolango a tinsaman ana Pukakiar Sabat, o bel. ");
INSERT INTO lbb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ika e Iesu ka tasman a nuknukinla pa i atai a barsan ning a kuna i del mang, “Kamtur! Pa ur tur ting lanigo tanla rop.” I kamtur, pa i tur salanigo tanla. ");
INSERT INTO lbb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lamur e Iesu i atai la mange, “Ar deken mulo: Asaning a Warkuraila i atongi sur dir toli ana Pukakiar Sabat? Dir tol a wakakna o dir tol a laulauna, dir alangolango tik o dir alaulau tik?” ");
INSERT INTO lbb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pa i tai taltal tetek la rop, pa i atai a barsan mang, “Ur kodos a kum.” Pa i kodosi, pa kuna i tostos ulak. ");
INSERT INTO lbb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pa balanla i bukus ana balakut, pa la warwara artalai tanla sur ta utna lar toli oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ning a pukakiar, e Iesu i han usaot na mangir sur ir araring. A kidol a morom ning, i araring tetek e God. ");
INSERT INTO lbb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ning i kabakiar, i kabah pas anuna tarai a asaer teteki, pa i aslang pas ning a bonot pa pisir naur tagun la, pa i atong la a aposella. ");
INSERT INTO lbb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na risanla ne: E Saimon ning e Iesu i saran tar ning a risana otleng e Pita, ditas ma e Endru, Jems, Jon, Pilip, Batolomiu, ");
INSERT INTO lbb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, e Jems a nat e Alpius, e Saimon ning di atongi mang takai tagun a kunum Silot, ");
INSERT INTO lbb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Judas a nat e Jems, pa e maurana otleng e Judas Iskariot esaning i asobor tar e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","E Iesu pa anuna tarai a asaer la han purum misaot na mangir, pa i tur ting na puka tostosna, taum ana nuna kunum a tarai a asaer. A galis a tarai misaot na papar Judia pa e Jerusalem pa miting na hananuala tumo latasi milau e Tair pa e Saidon otleng, ");
INSERT INTO lbb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","la hanot sur lar longori, pa ir alangolango pas la kusun anunla na tinsamanla. Pa i kepsen a motla kusun la rop ning a motla la alaulau la. ");
INSERT INTO lbb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pa taraila rop, la mang sur lar tuk a palaona e Iesu, anasa a rakrakai i purum taguni, pa i alangolango la rop. ");
INSERT INTO lbb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","E Iesu i ngoson anuna tarai a asaer pa i atongi mang, “Mulo ning mulo kapan, mulo angis, anasa a matanitu ane God anumuloi. ");
INSERT INTO lbb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mulo ning mulo murak onone, mulo angis, anasa lamur mulor masur. Mulo ning mulo domos onone, mulo angis, anasa lamur mulor lagar. ");
INSERT INTO lbb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mulo angis ning a tarai la nget mulo, pa ning la kepsen mulo pa la atong laulau mulo, pa ning la atong laulau a risamulo, anasa mulo na halal a Nat a Barsan. ");
INSERT INTO lbb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ana pukakiar ning dir tol a ututnala ning tetek mulo, mulor gas, mulor sirok ana gasgas, anasa anumulo arlou saot na langit i itna kol. Pa toltolla ning, anunla mangis a tarai tagun nating la ka tol tari tetek a propetla. ");
INSERT INTO lbb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ika ir laulau tetek mulo ning anumulo na ututnala i galis, anasa mulo ka kibas pas anumulo a wakakna. ");
INSERT INTO lbb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ir laulau tetek mulo ning mulo masur onone, anasa lamur mulor murak. Ir laulau tetek mulo ning mulo langlagar onone, anasa lamur mulor balmaris pa mulor domos. ");
INSERT INTO lbb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ir laulau tetek mulo ning a taraila rop la atong leklek pas mulo, anasa a toltol ning, anunla mangis a tarai tagun nating la ka tol tari tetek a propet asasongola. ");
INSERT INTO lbb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“A atai mulo ning mulo longor iau, mulor mang sur anumulo na hirua, pa mulor tol a wakakna tetek la ning la nget mulo. ");
INSERT INTO lbb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mulor angis la ning la nunung sur e God ir alaulau mulo, pa mulor araring sur la ning la alaulau mulo. ");
INSERT INTO lbb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ning tik ir pasar a ris a paham, ur saran otleng ning a ris tana. Ning tik ir ras pas anum a kaen na polpol alar anum a mermer, ur noren tar otleng anum a siot tana. ");
INSERT INTO lbb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ur tabar la rop ning la nunung u. Pa ning tik ir kibas pas ta utna anumi, gong u nunung ulak suri. ");
INSERT INTO lbb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mulor tol al ngas a utna tetek a tarai ning mulo mang sur lar toli tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ning mulor mang sur la ka, ning la mang sur mulo, dir aleklek mangmangasa pas mulo? Anasa a tena laulaula otleng la mang sur la ning la mang sur la. ");
INSERT INTO lbb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ning mulor tol a wakakna tetek la ning la wakak tetek mulo, dir aleklek mangmangasa pas mulo? Anasa a tena laulaula otleng la toli larning. ");
INSERT INTO lbb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ning a tarai lar mang sur lar kibas pas ta utna kaba tamulo, pa mulo sarani ka tetek la ning mulo tasmani mang lar kelesi ot tetek mulo, dir aleklek mangmangasa pas mulo? Anasa a tena laulaula otleng la saran a ututnala tana tena laulaula, pa la nuki mang lar kelesi. ");
INSERT INTO lbb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ika mulor mang sur anumulo na hirua, pa mulor tol a wakakna tetek la. Pa ning a tarai lar mang sur lar kibas pas ta utna kaba tamulo, mulor sarani ka tanla, pa gong mulo mang sur lar kelesi. Ning mulor toli larning, anumulo a arlou ir itna kol, pa mulo na natnat e God i Leklek Kol, anasa i mang sur la ning bel la sira atong wakak teteki, pa tena laulaula otleng. ");
INSERT INTO lbb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mulor asangan a marmaris, larning e Tamamulo a tena marmaris. ");
INSERT INTO lbb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Gong mulo warkurai a toltol ana tik, sakana e God otleng ir warkurai a toltol anumulo. Gong mulo tiu tik sur ir los a warkurai a arkeles, sakana e God otleng ir tiu mulo sur mulor los a warkurai a arkeles. Mulor nuk duman sen a toltol laulaula ning a tarai la toli tetek mulo, pa e God ir kepsen anumulo na toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mulor artabar, pa e God ir tabar mulo. A artabar ane God tetek mulo ir bukus, pa dir gulen purumi, pa ir bukus ulak, pa ir taptapek. Pa esi na ngas a artabar ning mulor sarani, i itna o i natarna, mangotleng larning e God ir sarani tamulo.” ");
INSERT INTO lbb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","E Iesu i atong otleng a warwara larlar tetek la mange, “A kut bel ir ben sot pas ta kut, sakana dia rop diar punga lorong ting na tung. ");
INSERT INTO lbb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A kaklik a asaer bel i leklek tan anuna tena asaer. Ika esining ka arop pas anuna asaer, ir arlar ana nuna tena asaer. ");
INSERT INTO lbb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Sur asaning u oroi pas ka a beren kaning na matana e tasimlik, pa bel u nuk pas a puka rakai kaning na matam? ");
INSERT INTO lbb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ning a puka rakai kaning na matam, ur atong mangmangasa i tetek e tasimlik mang, ‘Tasiklik, ar kepsen a beren kusun a matam’? U a tena asasongo, ur kepsen nigon a puka rakai kusun a matam, pa ur tai wakak sur ur kepsen a beren kusun a matana e tasimlik. ");
INSERT INTO lbb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“A wakak a rakai bel ir sira suah ta laulau a wana, pa laulau a rakai otleng bel ir sira suah ta wakak a wana. ");
INSERT INTO lbb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Dir oroi lalan a rakai miting na wana. Bel tik ir git pas ta wana fig miting na kadas, pa ta wana wain miting na rosros. ");
INSERT INTO lbb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A wakak a barsan i asangan anuna wakak a toltol ning kaning na balana, pa laulau a barsan otleng i asangan anuna toltol laulau ning kaning na balana. Anasa a pahana tarai i atong puasa a toltol ning i bukus ting na balanla. ");
INSERT INTO lbb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Sur asa mulo atong iau mang ‘Leklek, Leklek,’ pa bel mulo tol asala ning a atongi tamulo? ");
INSERT INTO lbb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Esining i han tetek iau pa i longor anuk na warwarala, pa i muri, i arlar ana barsan ning ar atai mulo onoi. ");
INSERT INTO lbb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I arlar ana barsan ning i tol a rumai. I kel tungen pas a tung, pa i atur tar a pos ana rumai saot na hat. Ning a lomom i hanot, pa i saler uting na rumai ning, bel i gulen sot pasi, anasa di ka tol wakak tari. ");
INSERT INTO lbb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ika tik ning ir longor anuk a warwarala pa bel i muri, i arlar ana barsan ning i atur anuna rumai saot na kabalapiu pa bel i tol nigon tar a kama rumai. Ning a lomom i saler tar ono, i punga, pa i tarege kakat!” ");
INSERT INTO lbb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ning e Iesu ka atong arop tar a warwara ning tetek a tarai, i han utumo e Kapernaum. ");
INSERT INTO lbb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ning a ningnigo anuna tena harumla mito e Rom i kes tingia. Ning a halinla anuna tena titol oros i sasam, milau ir mat. A tena titol oros ning, anuna ningnigo i mang kol suri. ");
INSERT INTO lbb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ning a ningnigo anuna tena harumla i longor a warwara oe Iesu, i sune dingla na ningnigola anuna tarai Juda sur lar nunungi sur ir han teteki, pa ir alangolango pas anuna tena titol oros. ");
INSERT INTO lbb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ning la hanot tetek e Iesu, la nunung rakrakai i mange, “A barsan ning a wakak a barsan, i wakak ning ur longor tana, ");
INSERT INTO lbb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","anasa i mang kol sur anundala a tarai, pa i lou tar anumila rumai lotu.” ");
INSERT INTO lbb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pa e Iesu i mur la. Ning la ka milau a rumai, a ningnigo anuna tena harumla i sune dingla na halalna tetek e Iesu ana warwara mange, “Leklek, gong a angoro u, anasa bel a tostos sur ur kas ting na rumai ngasik. ");
INSERT INTO lbb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bel a nuki otleng mang a tostos sur ar han tetek u. Ur atong ta warwara ka, pa anuk a tena titol oros ir langolango. ");
INSERT INTO lbb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Anasa iau a barsan ning a sira longor ana warkurai anunla ning la leklek tak, pa di saran tar a warkurai otleng tak sur ar nigon a tarai a harum. Ning ar atongi tana tik mang, ‘Ur han,’ ir han ka. Pa tetek tik otleng larne, ‘Ur han ute,’ ir han ka ute. Pa tetek anuk a tena titol oros mang, ‘Ur tol a utna ne,’ ir toli ka.” ");
INSERT INTO lbb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ning e Iesu i longor a warwara ne, i kulkulan kol onoi, pa i talingir tetek a tarai ning la muri, pa i atongi mang, “A atongi tamulo mang, bel a oroi ta te Israel, ning anuna tortorot i itna arlar ana barsan ning.” ");
INSERT INTO lbb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pa la ning di sune tar la, la ulak uting na rumai, la oroi mang a tena titol oros ning ka langolango. ");
INSERT INTO lbb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bel i bongnani, pa e Iesu i han uting na hanua di atongi e Nain, pa anuna kakak a asaerla pa tnan kunum a tarai otleng la han taum onoi. ");
INSERT INTO lbb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ning ka hanot milau ting na taman a hanua, a tarai la los purum ning a minat mito na hanua. A minat ning, a barman, a natna ning a lao, takai sot ka. A galis a tarai mito na hanua la armuri taum onoi. ");
INSERT INTO lbb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ning a Leklek i oroi a hane ning, i marisi pa i atai i mang, “Gong u domos.” ");
INSERT INTO lbb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","I han milau, pa i tong a logo ning di los a minat onoi, pa tarai ning la los a minat la tur suai. E Iesu i atongi mang, “Barman, a atai u, ur kamtur.” ");
INSERT INTO lbb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A minat i kes pa i turpas a warwara. Pa e Iesu i saran ulak tari tetek e tana. ");
INSERT INTO lbb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A taraila rop ning la matmataut, pa la aleklek pas e God pa la atongi mang, “A tnan propet ka hanot na arpotor indala. E God ka hanot sur ir nangan dala, anuna tarai.” ");
INSERT INTO lbb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pa warwara oe Iesu, i han sarara to na papar Judia rop, pa hananuala milau otleng. ");
INSERT INTO lbb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","A kakak a asaerla ane Jon a Tena Baptais la atai i ana ututnala rop ne oe Iesu. E Jon i kabah pas naur a halinla, ");
INSERT INTO lbb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","pa i sune diau tetek a Leklek sur diar dekeni mang, “U ma ning di warwara nigo tar hom mang ur hanot, o milar harnanai ot sur tik?” ");
INSERT INTO lbb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ning dia hanot tetek e Iesu, dia atongi mang, “E Jon, a Tena Baptais i sune miau tetek u, sur miar deken u mang, ‘U ma ning di warwara nigo tar hom mang ur hanot, o milar harnanai ot sur tik?’” ");
INSERT INTO lbb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ano otning, e Iesu i alangolango pas a galis kusun anunla na kankan pa nunla na tinsamanla, pa i kepsen a motla kusun la, pa i apalpalas pas a galis a kut. ");
INSERT INTO lbb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pa i keles diau mange, “Mur ulak, pa mur atai e Jon ana ututnala ne mu ka oroi tari, pa mu ka longor tari: A kutla la ka tai, la ning a hanla i mat la ka han tostos, a leprala la ka langolango, na talngana kutkut la ka longor, a minatla la ka kamtur, pa di warawai ana Wakak a Warwara tetek a kapan a tarai. ");
INSERT INTO lbb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Esining i oroi a ututnala ne a toli, pa anuna tortorot bel i punga, ka angis.” ");
INSERT INTO lbb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ning naur a kaklik a asaer ane Jon dia ka han, e Iesu i turpas a warwara tetek a kunum a tarai oe Jon mang, “Lanigo ning mulo han uting na hanua bel tetek e Jon, asaning mulo tai suri? Ngandek a kunai ning i maler ana wuwu? Bel. ");
INSERT INTO lbb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Asaning mulo han sur mulor oroi i? A barsan ning i mermer ana wakak a kaenla? Bel. Oroi, la ning la sira mermer ana ngangaten a kaenla, pa la angis ana wakak a ututnala, la sira kes ting na rumai ana kingla. ");
INSERT INTO lbb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Asaning mulo han sur mulor oroi i? A propet? Momol, a atai mulo, e Jon i leklek kol tana propetla. ");
INSERT INTO lbb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Di ka tumtumus tar onoi ting na Buk Tabu mange, ‘Oroi, ar sune anuk a tena los warwara sur ir nigon u pa ir atalapor anum a ngas.’ ");
INSERT INTO lbb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A atai mulo, e Jon i leklek kol tana taraila rop mite lapiu. Ika esining i natarna kol ana matanitu ane God, i leklek tana.” ");
INSERT INTO lbb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ning la longori, a taraila rop pa na tena los totokom otleng, la oroi lalani mang a ngas ane God i tostos, anasa la ka kibas tar a baptais ta e Jon. ");
INSERT INTO lbb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ika a Parisaiola pa tena asaerla tagun a warkurai la gilam ris ana ngas ning e God i sarani sur la, anasa bel la kibas a baptais ta e Jon. ");
INSERT INTO lbb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Pa e Iesu i atong ulaki mang, “Esi na warwara larlar ning ar atongi ana tarai tagun onone? La arlar ana sa? ");
INSERT INTO lbb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","La arlar ana kakakla ning la kes ting na tinine hanua pa la arkabah tetek na halalinla mang, ‘Mila pasar kudu, ika bel mulo tortor ono, pa mila saken a saksak a balmaris, ika bel mulo tangis ono.’ ");
INSERT INTO lbb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","E Jon a Tena Baptais i hanot, bel i ien ta wakak a utna pa bel i gang a wain, pa mulo atongi onoi mang, ‘A mot kaning onoi.’ ");
INSERT INTO lbb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A Nat a Barsan i hanot, i hangan pa i gang, pa mulo atongi onoi mang, ‘Oroi, a barsan ne a tena hangan pa tena gang, a hal a tena los totokomla pa tena laulaula.’ ");
INSERT INTO lbb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ika a taraila rop ning la mur a tastasman ane God, la asangani mang a tastasman ning i tostos.” ");
INSERT INTO lbb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ning a Parisaio i ben pas e Iesu sur diar hangan taum. E Iesu i kas ting na rumai ana Parisaio ning, pa i kes sur ir hangan. ");
INSERT INTO lbb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pa ning a hane miting na hanua ning, a tena tol a toltol laulau. Ning i tasmani mang e Iesu kaning i hangan ting na rumai ana Parisaio, i kas taum ana polo na tomtoboh kaning na koto ning di toli ana hat. ");
INSERT INTO lbb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pa i tur tumo lamur ta e Iesu, ting napir naur a hana. Pa i domos, a luru matana i punga tar saot na naur a hana e Iesu, pa i sah diau ana hihna, i goro diau, pa i pek a polo na tomtoboh ondiau. ");
INSERT INTO lbb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ning a Parisaio, esaning ka ben tar e Iesu, i oroi a utna ne, i nuki mang, “Ning a barsan ne a propet, ir tasman a hane ne i tong naur a hana, pa ir tasman otleng a ginina, mang ai a tena tol a toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","E Iesu i atai i mang, “Saimon a mang sur ar atai tar u ana ning a utna.” Pa i kelesi mang, “Tena Asaer, ur atai iau ka.” ");
INSERT INTO lbb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","E Iesu i atai i mang, “Naur a barsan dia dinau mani pas tana ning a barsan. Ning a halindiau i dinau pas dilima na mar a kina, pa ning a halindiau otleng dilima na bonot a kina. ");
INSERT INTO lbb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Naur a barsan ning bel dia tolsot sur diar keles a dinau. Pa barsan ning i atai diau mang, ‘Gong kama mu keles anumu na dinau.’ Esi na halindiau anuna marmaris ir itna kol?” ");
INSERT INTO lbb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","E Saimon i kelesi mang, “Ngandek esaning di kepsen anuna dinau ning i itna kol.” E Iesu i atai e Saimon mang, “I tostos anum a arkeles.” ");
INSERT INTO lbb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","E Iesu i gilam tetek a hane, pa i atai e Saimon mang, “Oroi a hane ne. Ning a kas te na rumai ngasim bel u saran al malum sur dir gos naur a hak onoi. Ika, a hane ne, i gos naur a hak ana luru matana, pa i sah diau ana hihna. ");
INSERT INTO lbb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bel u asangan anum a gasgas tetek iau ana argoro, ika a hane ne i goro naur a hak turpasi ot ning a hanot te. ");
INSERT INTO lbb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bel u sabar a pukuluk ana wel, ika a hane ne i pek a polo na tomtoboh te na naur a hak. ");
INSERT INTO lbb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","A atai u mang, anuna tnan marmaris tetek iau i asangani mang e God ka kepsen tar anuna galis a toltolla. Ika esining di kepsen ka anuna siklik toltol laulau, anuna marmaris bel ir itna.” ");
INSERT INTO lbb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pa e Iesu i atai a hane ning mang, “Di ka kepsen tar anum a toltol laulaula.” ");
INSERT INTO lbb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A tarai ning la kes ana utna na hangan, la warwara artalai arpotor inla mang, “Esi na ngas a barsan ne i kepsen a toltol laulaula?” ");
INSERT INTO lbb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","E Iesu i atai a hane ning mang, “Ana num a tortorot ot, di ka alaun pas u. Ur han ana balmolmol.” ");
INSERT INTO lbb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lamur e Iesu i han taltal uting na tatatnan hananuala pa nanatar a hananuala otleng, pa i sira warawai ana Wakak a Warwara ana matanitu ane God tetek la. La armuri taum ana nuna ning a bonot pa pisir naur a kakak a asaerla, ");
INSERT INTO lbb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","pa gurarala otleng ning ka kepsen tar a motla kusun la, pa ka alangolango pas la kusun a tinsamanla. Ine a risanla: E Maria, ning di atongi e Maria Makdalen, esaning mais a motla la purum kusuni, ");
INSERT INTO lbb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","pa e Joana pa e Susana, pa galis otleng. E Joana a hane ane Kusa, a barsan ning a ningnigo ana rumai ane Herot. A gurarala ne la nangan e Iesu pa nuna kakak a asaerla ana nunla na gongon ot. ");
INSERT INTO lbb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ning a tnan kunum a tarai miting na hananuala la hanot tetek e Iesu, i atong a warwara larlar tetek la mange, ");
INSERT INTO lbb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ning a tena omomai i han sur ir sapran a pat a witla. Ning i sapran amon la, dingla la punga ting na ngas, pa tarai la papas saot onla, pa manila otleng la ien sen la. ");
INSERT INTO lbb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dingla otleng la punga ting na pukna ning i hatat, pa ning la gomo ot, la main, anasa a piu i sengsenge kol. ");
INSERT INTO lbb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dingla na patna otleng la punga tar ting na tinine rosrosla, pa rosrosla la gomo taum onla, pa la rau alar pas la. ");
INSERT INTO lbb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dingla na patna otleng la punga ting na wakak a piu, la gomo pa la wai. Taktakai a rakai i suah takai a mar a wanala.” Ning ka atong tar a warwara ne tetek la, i atongi mang, “Esining a talngana kaning, i wakak ning ir longor ono.” ");
INSERT INTO lbb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Anuna kakak a asaerla la dekeni sur ir papak talapor ana warwara larlar ning ka atong tari. ");
INSERT INTO lbb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pa i atai la mange, “E God ka saran tar a tastasmai tamulo sur mulor talapor ana ututnala ana nuna matanitu, ning nating i kes kumna. Ika tetek a tarai masik a asaer la ana warwara larlarla, sur ‘lar oroi pa bel lar oroi lalani, lar longori pa bel lar tastasmai ono.’ ");
INSERT INTO lbb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“A kamkama warwara larlar ne i mange, a pat a wit i arlar ana warwara ane God. ");
INSERT INTO lbb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A pat a witla ning la punga ting na ngas, la arlar ana tarai ning la longor a warwara, pa e Satan i hanot, pa i kepsen a warwara miting na balanla, sur gong la tortorot, pa gong di alaun la. ");
INSERT INTO lbb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pa patnala ning la punga ting na pukna ning i hatat, la arlar ana tarai ning la longor a warwara, pa la tong akesi ana gasgas. Ika, bel al wakirinla, anunla tortorot bel i tur bongnani, pa ning a larlar ir hanot tetek la, lar punga ka. ");
INSERT INTO lbb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pa patnala ning la punga tar ting na tinine rosrosla, la arlar ana tarai ning la longor a warwara, ika ana nunla lalaun, a nuknuk kol, a gongonla, pa gasgas tagun a lalaun anone, la rau alar a warwara, pa bel la makos. ");
INSERT INTO lbb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ika patnala ning la punga ting na wakak a piu, la arlar ana tarai ning a balanla i wakak pa i tostos. La longor a warwara, la tong rakrakai i, pa la tur rakrakai, tuk ning lar wai. ");
INSERT INTO lbb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ Bel tik ir asot tar ta lam pa ir aroh alari ana paket, pa bel ir suahi otleng ting nahai a logo. Ir suahi ot saot na turtur ngasna, sur la ning lar kas, lar oroi a talaporna. ");
INSERT INTO lbb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pa ututnala rop ning i kes kumna, ir hanot talapor. Pa ututnala rop ning i kes mumun, lamur ir hanot talapor. ");
INSERT INTO lbb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mulor nuknuk wakak ana warwara ning mulo longori. Esining i tastasman ana warwara ane God, dir tabar ulaki ana galis. Ika, esining bel ta tastasman kaning tana, dir kepsen otleng siklik tastasman ning kaning tana.” ");
INSERT INTO lbb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","E tana e Iesu pa na tastasna la hanot sur lar oroi i, ika bel la tolsot sur lar han milau i, anasa a kunum a tarai la tur alar pasi. ");
INSERT INTO lbb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pa di atai e Iesu mang, “E tnam pa na tastasim, kanumo la tur tumo lapiu. La mang sur lar oroi u.” ");
INSERT INTO lbb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pa i atai la mang, “La ning la longor a warwara ane God pa la muri, la ning e nang pa na tastasik.” ");
INSERT INTO lbb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ning a pukakiar e Iesu i atai anuna kakak a asaerla mang, “Dalar han lakai utumo na ris a puka tasi.” La kas uting na mon, pa la han. ");
INSERT INTO lbb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ning la dun amon ana sel, e Iesu i borbor duman. A rakrakai a wuwu i ragati tanla ting na tasi, pa top i song a mon, pa milau lar hirua. ");
INSERT INTO lbb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A kakak a asaerla la han teteki, la amata i, pa la atai i mang, “Tena Asaer, Tena Asaer, dala kar hirua!” I kamtur, i sairas a wuwu pa tatatnan top sur diar manah. Dia manah, pa tasi i mililo rop. ");
INSERT INTO lbb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pa i atongi tana kakak a asaerla mang, “Kanahaia numulo a tortorot?” La matmataut, pa la kulkulan, la deken artalai la mang, “Esi na ngas a barsan ne? I warkurai a wuwu pa top pa dia longor tana.” ");
INSERT INTO lbb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","E Iesu taum ana nuna kakak a asaerla la sot ting na papar anuna tarai Gerasa, ning i kes to na ris a puka tasi tumo na papar Galili. ");
INSERT INTO lbb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ning e Iesu i purum kusun a mon, ning a barsan miting na hanua ning, a motla la solongi, i han barati. Ka bongnani, bel i pipis ta kaen, pa bel i kes otleng ting na ta rumai, i keskes ka ting na kulam ngas a minatla. ");
INSERT INTO lbb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ning i oroi pas e Iesu, i kukuk, pa i punga purum tar ting na naur a hana, pa i kukuk kol mange, “Iesu, a Nat e God esaning i Leklek Kol, asaning ur toli hok? A nunung u, gong u akadik iau.” ");
INSERT INTO lbb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I atongi larne, anasa e Iesu ka warwara rakrakai pas tetek a mot sur ir purum kusun a barsan ne. A galis a taim a mot i solsolongi. A tarai la sira tai alar a barsan ne, la sira dot naur a kuna pa naur a hana ana sen, ika i sira dat kutus la ka, pa mot i sira angongosi usaot na hanua bel. ");
INSERT INTO lbb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","E Iesu i dekeni mange, “Esi na risam?” Pa i kelesi mange, “A risak a liur a mot,” anasa a galis a mot la solongi. ");
INSERT INTO lbb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pa la nunung rakrakai e Iesu sur gong i sune kas la uting na tnan tung ning bel ta araropna. ");
INSERT INTO lbb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A kaba liur a boroi la hangan ting na mangir, pa motla la nunung rakrakai e Iesu sur lar kas ana boroi. Pa i malmaling sen la. ");
INSERT INTO lbb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","A motla la purum kusun a barsan ning, pa la kas tar ana boroila. Pa boroila la liu purum uting na palis sur utumo na puka tasi, pa la dom rop. ");
INSERT INTO lbb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","La ning la tai alar a boroila, la oroi a utna ne, la dun ulak. La atatai ana utna ne ting na hanua ngasinla, pa dingla na hananuala otleng. ");
INSERT INTO lbb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pa tarai la han sur lar oroi asaning i hanot. Ning la hanot tetek e Iesu, la oroi a barsan ning a motla la ka purum tar kusuni, i kes milau tar naur a hana e Iesu, ka pipis pas pa ka mananos ulak. Pa la matmataut. ");
INSERT INTO lbb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","La ning la oroi asaning e Iesu i toli, la atai a tarai ana saning e Iesu i toli sur a barsan ning ir langolango kusun a motla. ");
INSERT INTO lbb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pa taraila rop miting na papar anuna Gerasala la nunung e Iesu sur ir han kusun la, anasa la matmataut kol. Lamur e Iesu i kas ulak ana mon pa i han. ");
INSERT INTO lbb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A barsan ning a motla la ka purum tar kusuni, i nunung e Iesu sur diar armuri. Ika e Iesu i sune seni ka mang, ");
INSERT INTO lbb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ur han uting na hanua ngasim, pa ur warwara ana tnan utna ning e God ka tol tari hom.” Pa i han, i warwara ting na hanua ning ana tnan utna ning e Iesu ka tol tari onoi. ");
INSERT INTO lbb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ning e Iesu i ulak, a kunum a tarai la gasgas pasi, anasa la rop la harnanai ka suri. ");
INSERT INTO lbb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ning a barsan, a risana e Jairus, a ningnigo tagun a rumai lotu, i hanot pa i punga na hanrawai tar ting na ris a hana e Iesu. I nunungi sur ir han usa na rumai ngasna, ");
INSERT INTO lbb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","anasa takai ka natna hane, ning anuna rau i ning a bonot pa pisir naur, milau ir mat. Pa ning e Iesu i han, a tnan kunum a tarai la arsugut alar pasi. ");
INSERT INTO lbb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ning a hane tingia i sasam ana tinsaman a suluk, arlar ana ning a bonot pa pisir naur a rau, ika bel tik i tolsot sur ir alangolango pasi. ");
INSERT INTO lbb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","I han tumo lamur ta e Iesu, pa i tuk a ris a tuka saket anunai, pa suluk i manah kakat. ");
INSERT INTO lbb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pa e Iesu i deke mange, “Esining i tuk iau?” La rop la puai, e Pita i atongi mang, “Tena Asaer, a tnan kunum a tarai ne la tur talilis u pa la arsugut alar pas u.” ");
INSERT INTO lbb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","E Iesu i atongi mange, “Ning a halinla ka tuk tar iau, a kilangi mang a rakrakai i purum kusun iau.” ");
INSERT INTO lbb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lamur a hane i tasmani mang di ka pastetek pasi, pa i koloron ot, pa i punga salanigo ta e Iesu. Na matana taraila rop, i atai e Iesu ana kamkamna ning i tuk tari, pa i atai i otleng ning i langolango kakat. ");
INSERT INTO lbb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pa e Iesu i atai i mange, “Natuklik, anum a tortorot ka alangolango pas u. Ur han taum ana balmolmol.” ");
INSERT INTO lbb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ning e Iesu kaning ot i warwara, takai i hanot mito na rumai ane Jairus, a ningnigo tagun a rumai lotu, pa i atai i mange, “Gong u amolot a Tena Asaer. E natum hane ka mat.” ");
INSERT INTO lbb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ning e Iesu i longor a warwara ning, i atai e Jairus mange, “Gong u matmataut, ur tortorot ka, pa dir alaun ulak pasi.” ");
INSERT INTO lbb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ning i hanot ting na rumai, bel i malmaling pas tik sur ir kas taum onoi. I malmaling pas ka e Pita, e Jon pa e Jems, pa e taman a kaklik pa e tana otleng. ");
INSERT INTO lbb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A taraila rop la kunkun pogol ana domos, pa e Iesu i atai la mang, “Gong mulo domos. A kaklik ning bel i mat, kaning ka i borbor duman.” ");
INSERT INTO lbb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pa la malani ka, anasa la tasmani mang ka mat. ");
INSERT INTO lbb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ika e Iesu i tong pas a kuna kaklik hane, pa i atai i mang, “Natuklik, ur kamtur.” ");
INSERT INTO lbb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pa inguna i ulak teteki, pa i kamtur kakat. Pa e Iesu i arsune sur ta utna ana hane lik ning sur ir ieni. ");
INSERT INTO lbb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamana pa e tana dia kulkulan kol, pa e Iesu i sairas diau sur gong dia atai tik ana saning i hanot. ");
INSERT INTO lbb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ning e Iesu i kabah taum pas ning a bonot pa pisir naur a kakak a asaerla, i saran tar a rakrakai pa warkurai tetek la sur lar kepsen a motla rop, pa lar alangolango otleng a taraila kusun a tinsamanla. ");
INSERT INTO lbb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pa i sune sen la sur lar warawai ana matanitu ane God, pa lar alangolango a tinsamanla. ");
INSERT INTO lbb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pa i atai la mange, “Gong mulo los tar al utna ting na numulo a tinan, gong ta bulse, gong ta bek, pa gong ta utna na hangan, gong al mani pa gong al kelkeles. ");
INSERT INTO lbb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ning mulor kas ting na ta rumai, mulor kes ot tingia tuk ana pukakiar ning mulor han kusun a hanua ning. ");
INSERT INTO lbb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ning al tarai bel lar gas pas mulo, ning mulor han kusun a hanua ngasinla, mulor tang sen a kubus kusun a hamulo, sur a asilang na atumarang tetek la.” ");
INSERT INTO lbb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A kakak a asaerla la han taltal ting na hananuala, la warawai ana Wakak a Warwara, pa la alangolango a tarai ting na hananuala rop. ");
INSERT INTO lbb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","E Herot, a ningnigo tagun a matanitu, i longor a ututnala ning i hanot. A nuknukna i talar onoi, anasa dingla na tarai la atongi mang e Jon ka kamtur ulak kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pa dingla na tarai otleng la atongi mang e Elaija ka hanot. Dingla na tarai otleng la atongi mang ning a halin a propetla tagun nating ka laun ulak. ");
INSERT INTO lbb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ika e Herot i atongi mang, “Ia ka umsem tar ana ruana e Jon. Pa esi na barsan ulak ning, a longor a ututnala ne onoi?” Pa i tohoi sur ir oroi e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ning a aposella la ulak, la atai e Iesu ana ututnala ning la ka tol tari. I ben pas la, pa la han masik uting na hanua a risana e Betsaida. ");
INSERT INTO lbb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","A kunum a tarai la longori, pa la muri. I gas pas la, pa i warwara tetek la ana matanitu ane God, pa i alangolango pas la ning la sasam. ");
INSERT INTO lbb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ning ka rah, ning a bonot pa pisir naur a kakak a asaerla la han teteki, pa la atai i mang, “Ur sune sen a kunum a tarai sur lar han uting na hananuala, pa na nanatar a hananuala milau, sur lar hangan pa lar borbor tingia, anasa a hanua bel ka ine.” ");
INSERT INTO lbb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","E Iesu i atai la mang, “Mulo ot mulor tabar la.” Pa la kelesi mange, “Dilima na bret ka pa naur a sis kane mila losi. Ngandek u mang sur milar lou pas al utna sur ir arlar ana kunum a tarai rop ne?” ");
INSERT INTO lbb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A wawas ana tarai ka i arlar ana dilima na rip, pa gurarala pa kakakla otleng kaning. I atongi tetek anuna kakak a asaerla mang, “Mulor sune la sur lar kes anal kunum, sur dildilima na bonot ting na ning a kunum.” ");
INSERT INTO lbb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pa kakak a asaerla la toli larning, pa taraila rop la kes. ");
INSERT INTO lbb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","E Iesu i kibas pas dilima na bret pa naur a sis, i tadai usaot na langit, i atong wakak pas tetek e God onoi, i kibiki pa i sarani tana kakak a asaerla, sur lar asalar a kunum a tarai ono. ");
INSERT INTO lbb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","La rop la hangan pa la masur. Pa la song bukus pas ning a bonot pa pisir naur a rat ana mah a utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ning a pukakiar, ning e Iesu ka i kes pa i araring, a kakak a asaerla la han teteki, pa i deken la mange, “A tarai la atongi mang iau esi?” ");
INSERT INTO lbb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pa la kelesi mange, “Dingla la atong u, e Jon a Tena Baptais. Dingla otleng la atong u, e Elaija, pa dingla otleng la atong u, ning a hal a propetla tagun nating, ning ka kamtur ulak.” ");
INSERT INTO lbb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pa e Iesu i deken la mange, “Pa mulo, mulo atong iau o esi?” E Pita i kelesi mang, “U a Karisito ning e God i sune sen u ute.” ");
INSERT INTO lbb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pa i sairas la mang gong la atai tar tik ono. ");
INSERT INTO lbb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","E Iesu i atongi tanla mange, “A Nat a Barsan ir kilang a galis a mamahat, pa ningnigola, a leklek a tena artabarla tetek e God, pa tena asaerla tagun a warkurai lar gilam ris kusuni pa dir umkoli. Pa ana natol a pukakiar lamur, ir kamtur ulak.” ");
INSERT INTO lbb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pa i atai la rop mange, “Ning tik i mang sur ir mur iau, gong i mur a nuknukna. Ir pamar anuna rakai kutus ana pukakiarla rop pa ir mur iau. ");
INSERT INTO lbb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Esining i mangan alar anuna lalaun ir hirua, ika esining i noren sen anuna lalaun sur iau, ir laun. ");
INSERT INTO lbb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ning tik ir tong akes a ututnala rop mite na rakrakan hanua, pa ir alaulau anuna lalaun ono pa ir hirua, ir wakak mangmangasa teteki? ");
INSERT INTO lbb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ning tik ir meme hok pa ana nuk a warwarala, a Nat a Barsan otleng ir meme ono ning ir hanot ana nuna matatar, pa matatar otleng ane Tamana pa anuna angelola. ");
INSERT INTO lbb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A atong momoli tamulo, dingla omulo ning mulo tur te, belot mulor mat, pa mulo kar oroi a matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ngandek ka siwal a pukakiar alar tar a warwara ning, e Iesu i ben pas e Pita, Jon pa e Jems, pa la han usaot na mangir sur lar araring. ");
INSERT INTO lbb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ning kaning ot i araring, a patarna i ries, pa nuna kaenla i kokok pa i pil. ");
INSERT INTO lbb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ono otning naur a barsan, e Moses pa e Elaija ");
INSERT INTO lbb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","dia hanot ana matatar, pa ditol warwara taum ma e Iesu. Ditol warwara ana minat ane Iesu, ning ir songo i saot e Jerusalem, sur ir tolsot pas a nuknuk e God. ");
INSERT INTO lbb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","E Pita ditol, ditol borbor duman. Ning ditol mata ot, ditol oroi a matatar ane Iesu, pa naur a barsan otleng kaning ditol tur taum tar. ");
INSERT INTO lbb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ning naur a barsan dia mang sur diar han kusun e Iesu, e Pita i atai i mange, “Tena Asaer, i wakak ning dalar kes kama te. Mitol ar tol ir natol a turturup, takai anumi, takai ane Moses, pa takai ane Elaija”. Ika e Pita bel i tasman asaning i atongi. ");
INSERT INTO lbb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ning kaning ot i warwara, a laukap i hanot pa i poroi alar pas la, pa ditol matmataut ning ditol kas tingui na laukap. ");
INSERT INTO lbb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pa elngen takai misaot na laukap i atongi mang, “Ine a Natuklik, ning ia ka aslang pasi. Mulor longor tana.” ");
INSERT INTO lbb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ning ka warwara rop, e Iesu kama kaning. Pa bel ditol warwara onoi. Pa ana pukakiarla ning, bel ditol atai tar tik ana saning ditol ka oroi tari. ");
INSERT INTO lbb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ana pukakiar lamur, ning e Iesu pa natol a kaklik a asaer la ka han purum misaot na mangir, a tnan kunum a tarai la han tetek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pa ning a barsan miting na kunum i arkabah mange, “Tena Asaer, a nunung u sur ur oroi a natuk barsan, takai sot ka kaklik. ");
INSERT INTO lbb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A mot i sira solongi, pa i sira kukuk kakat. A mot i sira akoloroni, pa busa i purum ting na pahana kaklik ning. A mot bel i sira han kusuni, pa i sira akankan kol a palaona. ");
INSERT INTO lbb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A nunung kaba anum na kakak a asaerla sur lar kepsen a mot kusuni, ika bel la tolsot pasi.” ");
INSERT INTO lbb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","E Iesu i atongi mang, “Mulo na tarai tagun onone, bel mulo tortorot, pa mulo na tena laulau. Ia ka kes bongnan iau te napirimulo. Nangse mulor tortorot? Ur ben e natumlik ute.” ");
INSERT INTO lbb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ning a kaklik i han tetek e Iesu, a mot i migen purumi utumo lapiu pa i akoloroni. Ika e Iesu i warwara rakrakai tetek a mot pa i kepseni, pa kaklik ning i langolango ulak. I saran ulaki tetek e tamana. ");
INSERT INTO lbb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pa la rop la kulkulan ana tnan rakrakai e God. La rop la kulkulan ana utna ning e Iesu ka tol tari, pa i atai anuna kakak a asaerla mange, ");
INSERT INTO lbb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mulor longor wakak a warwara ne: Dir saran tar a Nat a Barsan uting na kuna taraila.” ");
INSERT INTO lbb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ika a kakak a asaerla bel la talapor ana kamkama warwara ne. Di bunuri ka tanla, sur gong la tasman lalani. Pa la matmataut sur lar deken e Iesu onoi. ");
INSERT INTO lbb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A kakak a asaerla la arlak na arpotor inla mang esi na halinla ir leklek kol. ");
INSERT INTO lbb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","E Iesu ka tasman tar a nuknukinla, i ben pas ning a kaklik pa i aturi ting napirna. ");
INSERT INTO lbb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pa i atai la mang, “Esining ir gas pas a kaklik ne ana risak, i gas pas iau. Pa esining ir gas pas iau, i gas pas esaning i sune iau ute. Anasa esining i natarna tamulo rop, i ning i leklek kol.” ");
INSERT INTO lbb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","E Jon i atai e Iesu mange, “Tena Asaer, mila oroi ning a barsan i kepsen a motla ana risam, pa mila tohoi sur milar sairasi, anasa bel a halindala.” ");
INSERT INTO lbb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","E Iesu i kelesi mange, “Gong mulo sairasi, anasa esining bel i sairas mulo, i nangan mulo.” ");
INSERT INTO lbb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ning ka milau a pukakiar sur dir los e Iesu usaot na langit, a nuknukna i rakrakai sur ir han usaot e Jerusalem, pa i turpas a tinan. ");
INSERT INTO lbb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","I sune dingla na tena titol, sur lar nigo tana. La hanot ana ning a hanua ting na papar Samaria, sur lar sang sur e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ika a te Samariala bel la gas pasi tingia, anasa i han sur usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ning naur a kaklik asaer anunai, e Jems pa e Jon dia oroi a toltol ning, dia dekeni mang, “Leklek, u mang sur miar nunung e God sur ir sune purum a iah sur ir tun arop la?” ");
INSERT INTO lbb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ika e Iesu i talingir, pa i sairas diau. ");
INSERT INTO lbb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pa e Iesu pa anuna kakak a asaerla la han sur uting na ning a hanua masik. ");
INSERT INTO lbb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ning e Iesu pa anuna kakak a asaerla la han amon ting na ngas, ning a barsan i atai i mang, “Ar mur u uting na hananuala rop ning ur han ia.” ");
INSERT INTO lbb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","E Iesu i kelesi mange, “Na rokoio na pap anunla na tung ot, pa manila otleng anunla na pios ot, ika a Nat a Barsan bel ta pukna sur ir borbor onoi.” ");
INSERT INTO lbb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","I atai ning a barsan otleng mang, “Ur mur iau.” Ika i kelesi mange, “Leklek, ur noren sen iau kaba sur ar han, sur ar por sen tar e tata.” ");
INSERT INTO lbb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","E Iesu i atai i mange, “Ur noren sen a minatla lar por anunla na minatla. Ur han pa ur warawai ana matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ning male, i atai e Iesu mange, “Leklek, ar mur u, ika ur noren tar iau kaba sur ar han, pa milar tai taum pas onla ting na rumai ngasik.” ");
INSERT INTO lbb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","E Iesu i atai i mang, “Ning tik ir turpas a oma, pa i gilam utumo lamur, bel i to pas ta titol ana matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lamur a Leklek i aslang pas mais a bonot pa pisir naur a tarai otleng, pa i sune naunaur onla sur lar nigoni uting na tatatnan hanua, pa ting na nanatar a hanua, ning i otleng ir han ia. ");
INSERT INTO lbb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pa i atai la mange, “A barim ka makos, pa i galis kol, ika bel al galis a tena sol. Mulor nunung a Leklek, esaning a taman a barim, sur ir sune a tena solla uting na nuna barim. ");
INSERT INTO lbb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mulor han! Onone a sune sen mulo arlar ana barman a sipsipla ting na arpotor tana ngalngaliah na pap. ");
INSERT INTO lbb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gong mulo los ta paus na suah mani, gong ta bek, pa gong ta su. Gong otleng mulo awara tar tik ning mulor arpastek ting na ngas. ");
INSERT INTO lbb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ning mulor kas ting na ta rumai, mulor atong nigoni mange, ‘A balmolmol tetek mulo.’ ");
INSERT INTO lbb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ning ta tena balmolmol i kes tingia, anumulo a balmolmol ir kes onoi. Ning bel, a balmolmol ir ulak tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pa mulor kes ot tingia ana rumai ning, mulor hangan pa mulor gang a utna ning di tabar mulo onoi, anasa i tostos sur a tena titol ir kibas ot anuna arlou. Gong mulo borbor anal rumai masik. ");
INSERT INTO lbb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ning mulor hanot ting na ta hanua, pa di ben kas mulo, mulor ien a ututnala ning di tabar mulo onoi. ");
INSERT INTO lbb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mulor alangolango a tinsamanla, pa mulor atai a taraila mang, ‘A matanitu ane God ka milau tetek mulo!’ ");
INSERT INTO lbb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ning mulor hanot ting na ta hanua, pa bel dir ben kas mulo, mulor tur ka ting na ngas pa mulor atongi mange, ");
INSERT INTO lbb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘A kubus miting na hanua ngasimulo kane na hamila, milar sah seni sur a atumarang tetek mulo. Ika mulor tasmani mang a matanitu ane God ka milau.’ ");
INSERT INTO lbb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A atongi tamulo, ana pukakiar a warkurai, a warkurai a arkeles tetek a hanua ning ir rakrakai kol tana warkurai tetek e Sodom.” ");
INSERT INTO lbb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ir laulau tetek mulo a tarai Korasin, pa ir laulau otleng tetek mulo a tarai Betsaida. Ning di kar tol tar a ututnala na kulkulan ne tetek a tarai Tair pa tarai Saidon, arlar larning di ka tol tari tetek mulo, a tarai Tair pa tarai Saidon la kar lingir kapit a nuknukinla pa lar tobo, lar mermer ana kaenla na tobo pa lar sabar a palaonla ana kubus a iah. Ika mulo, bel mulo lingir a nuknukimulo. ");
INSERT INTO lbb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A warkurai a arkeles tetek mulo a tarai Korasin pa tarai Betsaida ir rakrakai kol tana warkurai tetek a tarai Tair pa tarai Saidon. ");
INSERT INTO lbb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pa mulo otleng a tarai Kapernaum, mangasa, mulo nuki mang dir aleklek pas mulo usaot? Bel! Dir migen purum mulo uting na tnan iah.” ");
INSERT INTO lbb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","E Iesu i atai anuna kakak a asaerla mang, “Esining i longor mulo, i longor iau. Pa esining i puain sen mulo, i puain sen iau otleng. Pa esining i puain sen iau, i puain sen otleng esaning i sune iau ute.” ");
INSERT INTO lbb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pa mais a bonot pa pisir naurla, la ulak ana gasgas pa la atongi mang, “Leklek, ning mila kepsen a motla ana risam, la longor ot.” ");
INSERT INTO lbb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Pa e Iesu i atai la mang, “A oroi e Satan i punga misaot na langit arlar ana pil. ");
INSERT INTO lbb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ia ka saran tar a rakrakai tamulo sur mulor pas gorgoron a soila pa radamla otleng, pa mulor tolsot pas a rakrakai ana hirua, pa bel ta utna ir alaulau mulo. ");
INSERT INTO lbb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ika, gong mulo gas anasa a motla la longor tamulo. Mulor gas, anasa di ka tumus tar a risamulo saot na langit.” ");
INSERT INTO lbb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ana taim ning, e Iesu i bukus ana gasgas ana Talngan Tabu pa i atongi mang, “Tata, u a Leklek saot na langit pa te na rakrakan hanua rop. Ar rakan aleklek pas u, anasa u bunur a ututnala ne kusun a tena tastasmaila pa la ning la tastasman, pa u apuasa i tetek la ning la arlar ana kakakla. A momolna, Tata, u mang ot sur ir manglarning. ");
INSERT INTO lbb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“E Tata ka saran tar a ututnala rop tak. Bel tik i tasman e Natnalik, e Tamana ka, pa bel tik otleng i tasman e Tamana, e Natnalik ka, pa la otleng ning e Natnalik i mang sur ir apuasa e Tamana tetek la.” ");
INSERT INTO lbb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ning e Iesu taum ana nuna kakak a asaerla kama la kes, i talingir tetek la pa i atongi mang, “Mulo angis ning mulo oroi a ututnala ne! ");
INSERT INTO lbb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","A atai mulo, a galis a propet pa galis a king la mang sur lar oroi a ututnala ning a toli na matamulo, ika bel la oroi i. Pa la mang sur lar longor a ututnala ne mulo longori, ika bel la longori.” ");
INSERT INTO lbb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ning a tena tastasmai ana Warkurai i tur pa i toho e Iesu mang, “Tena Asaer, asaning ar toli sur ar kibas a lalaun tikin?” ");
INSERT INTO lbb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Pa e Iesu i kelesi mang, “Asaning di tumus tari ana Warkuraila? Pa asaning u nuki onoi?” ");
INSERT INTO lbb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A barsan ning i kelesi mang, “‘Ur mang sur a Leklek anum a God ana balam rop, a ingum rop, a rakrakaim rop, pa nuknukim rop.’ Pa ‘Ur mang sur a halim larning u mang sur u ot.’” ");
INSERT INTO lbb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","E Iesu i atai i mang, “I tostos ot anum a warwara, ur toli larning, pa ur laun.” ");
INSERT INTO lbb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ika i mang sur ir atostos pasi na matana e Iesu, pa i dekeni mang, “Esi a halik?” ");
INSERT INTO lbb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","E Iesu i kelesi ana warwara larlar mange, “Ning a barsan i han misaot e Jerusalem utumo e Jeriko. Ning i han amon, a tena kinkinaula la han alar pasi. La kepsen anuna kaenla, la um laulau tari, pa la han kusuni pa milau ir mat. ");
INSERT INTO lbb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pa ning a tena artabar tetek e God i han ting na ngas, pa ning i oroi a barsan ning, i han liliesi ting na ris. ");
INSERT INTO lbb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ning a barsan kale ana mangis a tarai ane Liwai, i han tar ana barsan ning, i han liliesi ting na ris a ngas. ");
INSERT INTO lbb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ika ning a te Samaria i han amon, i han tar ana barsan ning, pa ning i oroi, i maris koli. ");
INSERT INTO lbb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I han teteki, i pek tar a wel pa wain ting na mangmangrasla ting na palaona pa i poroi alar tari. I akas pasi ana nuna dongki, pa i asirok tari ting na rumai a wasira, pa i tai alari. ");
INSERT INTO lbb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ana pukakiar lamur tana, i los pas naur a denaria, pa i saran tari tetek a tamana rumai, pa i atai i mang, ‘Ur tai alari. Pa ning ur tabari otleng anal utna, ning ar ulak, ar keles ulaki tetek u.’ ");
INSERT INTO lbb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Esi na halin natol a barsan a halna a barsan ning a tena kinkinaula la umi?” ");
INSERT INTO lbb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pa tena asaer ana Warkuraila i kelesi mang, “Esaning i marisi.” Pa e Iesu i atai i mang, “Ur han pa ur toli larning.” ");
INSERT INTO lbb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ning e Iesu pa nuna kakak a asaerla la han amon, la hanot ting na ning a hanua, pa ning a hane, a risana e Mata, i ben pas e Iesu uting na nuna rumai. ");
INSERT INTO lbb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pa e tasna hane a risana e Maria, i kes milau ting na naur a hana Leklek, pa i longor anuna warwarala. ");
INSERT INTO lbb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ika e Mata i molot kol ana titol na sang a utna na hangan, pa i han tetek e Iesu pa i atai i mang, “Leklek, bel u nuk pas iau? Oroi, tasik hane bel i nangan iau. Iau kama a tol a titol. Atai i sur ir nangan iau.” ");
INSERT INTO lbb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A Leklek i kelesi mang, “Mata, Mata, u nuknuk kol ana galis a utna! ");
INSERT INTO lbb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Takai a utna ka, ning ur nuknuk kol suri. E Maria ka aslang pas a wakak a utna, pa bel tik ir kepseni kusuni.” ");
INSERT INTO lbb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ning a pukakiar e Iesu i araring ting na ning a pukna. Ning ka araring rop, ning a halin anuna kakak a asaerla i atai i mang, “Leklek, ur asaer mila ana niaring, larning e Jon i asaer anuna kakak a asaerla.” ");
INSERT INTO lbb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pa e Iesu i atai la mang, “Ning mulo araring, mulor atongi mange, ‘Tamamila, i wakak ning dir hanrawai a risam. I wakak ning anum a matanitu ir hanot. ");
INSERT INTO lbb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ana pukakiar rop ur tabar mila ana utna na hangan amilai. ");
INSERT INTO lbb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ur kepsen anumila na toltol laulaula, anasa mila otleng mila ka nuk duman sen anunla na toltol laulaula tetek mila. Gong u ben mila uting na arlam.’” ");
INSERT INTO lbb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Lamur e Iesu i atai anuna kakak a asaerla mang, “Ning tik omulo ir han tetek a halna ana tnan morom, pa ir nunungi mang, ‘Halik, a mang sur ir natol a bret. ");
INSERT INTO lbb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Anasa a halik ka hanot tetek iau ana nuna tinan, pa bel al utna sur ar tabari ono.’ ");
INSERT INTO lbb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pa halna ning ui ir atai i mang, ‘Gong u amolot iau! Mila ka tagar, pa mila taum ana natnatuk mila ka borbor. Bel ma ar kamtur sur ar los tar ta utna tetek u.’ ");
INSERT INTO lbb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A atai mulo, ir kamtur pa ir saran tar a bret tana, bel a kamkamna mang dia halna, i kamkamna ka mang i nunung ngongosi. ");
INSERT INTO lbb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Onone a atai mulo, mulor nunung pa dir tabar mulo, mulor sereni pa mulor pasteteki, mulor pinpidir pa dir sapang pas mulo. ");
INSERT INTO lbb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Anasa la rop ning la nunung lar kibasi, pa esining i sereni ir pasteteki, pa esining i pinpidir, dir sapang pasi. ");
INSERT INTO lbb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Esi na halimulo, ning e natnalik ir nunungi sur ta sis, ir tabari ka ana ta soi? ");
INSERT INTO lbb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pa ning i nunungi sur ta kiau, ir tabari ka ana ta radam? ");
INSERT INTO lbb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mulo na laulau a tarai, ika mulo tasman ot a wakak a artabarla sur mulor tabar na natnatumulola ono. Ning mulo sira toli larne, i momol kol mang, e Tamamulo ning i kes saot na langit, ir saran a Talngan Tabu tetek la ning la nunungi.” ");
INSERT INTO lbb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","E Iesu i kepsen a mot ning i ngat kusun ning a barsan. Ning a mot i purum kusuni, a barsan ning i ngat i bot warwara. Pa kunum a tarai la kulkulan. ");
INSERT INTO lbb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ika dingla na tarai onla, la atongi ka mang, “I sira kepsen a motla ana rakrakai e Belsebul, a leklek anuna motla.” ");
INSERT INTO lbb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dingla otleng la tohoi, la nunungi sur ir tol ta akinalang sur ir asangani mang i titol ana rakrakai e God. ");
INSERT INTO lbb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ika e Iesu ka tasman tar a nuknukinla, pa i atai la mang, “Ning a tarai miting na ta matanitu lar harum artalai tanla ot, a matanitu ning ir rarop. Pa ning ta kabaitamana lar harum artalai tanla ot, bel ma lar kes taum. ");
INSERT INTO lbb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ning e Satan ir harum taum ana nuna tena titolla, anuna matanitu ir tur rakrakai mangmangasa? A atongi larne anasa mulo atongi hok mang a kepsen ka a mot ana rakrakai e Belsebul. ");
INSERT INTO lbb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ning iau a kepsen a motla ana rakrakai e Belsebul, anumulo na tarai la sira kepsen la ana rakrakai esi? Mulo tasmani mang la kepsen a motla ana rakrakai e God, pa ine i asangani mang anumulo a artitiu hok i rongo. ");
INSERT INTO lbb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ika ning a kepsen a motla ana rakrakai e God, mulor tasmani mang a matanitu ane God ka hanot tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ning ta rakrakai a barsan ka mermer pas ana nuna ututnala na harum, pa i tai alar anuna rumai, anuna ututnala lar kes wakak. ");
INSERT INTO lbb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ika, ning tik i rakrakai tana ir hanot teteki pa ir tolsot pasi, ir rasen anuna utnala na harum ning i tortorot onoi, pa ir kibas pas a ututnala rop anuna barsan ning pa ir sarani tan al tarai. ");
INSERT INTO lbb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Esining bel i nangan iau, i sairas iau ka. Pa esining bel i nangan iau ona ben a tarai, i lu sarara la ka. ");
INSERT INTO lbb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ning ta mot ir purum kusun ta barsan, ir han uting na puknala ning bel al malum ia, sur ir manah, ika bel ir pastek ta pukna ning ir manah ia. Pa ir atongi mange, ‘Ar ulak sur anuk a rumai, ning a purum tar kusuni.’ ");
INSERT INTO lbb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ning ir hanot, ir oroi mang di ka surupu tar, pa di ka atostos tari. ");
INSERT INTO lbb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lamur ir han pa ir ben ulak pas mais a mot, ning la laulau kol tana, pa lar kas rop ting na rumai ning, pa lar kes tingia. Pa lalaun anuna barsan ning, ir laulau kol tan anuna lalaun nating.” ");
INSERT INTO lbb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ning e Iesu kaning ot i warwara, ning a hane miting na kunum a tarai, i kukuk mange, “A hane ning i agon pas u pa i asus u, i angis.” ");
INSERT INTO lbb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ika e Iesu i kelesi mang, “La ning la longor a warwara ane God pa la muri, la angis kol.” ");
INSERT INTO lbb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ning a kunum a tarai la bukus amon, e Iesu i atai la mang, “A tarai tagun onone, a laulau a tarai. La mang sur ta akinalang, ika bel dir tol tar tik tetek la. Dir tol ka a akinalang arlar larning di tol tari oe Jona. ");
INSERT INTO lbb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Anasa e Jona i akinalang tar tetek a tarai Niniwe, mang otleng larning a Nat a Barsan ir akinalang tar tetek a tarai tagun onone. ");
INSERT INTO lbb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ana pukakiar a warkurai, a kwin mitumo na matana tobar ir tur pa ir tiu rakrakai a tarai tagun onone, anasa i hanot miting bakbak sur ir longor a mananos ana King Solomon, pa onone, esaning i leklek ta e Solomon kanet. ");
INSERT INTO lbb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ana pukakiar a warkurai, a tarai Niniwe lar tur pa lar tiu rakrakai a tarai tagun onone, anasa la lingir a nuknukinla ana warawai ane Jona, ika onone esaning i leklek ta e Jona kanet. ");
INSERT INTO lbb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Bel tik ir asot tar ta lam pa ir bunuri, pa ir aroh alari ana paket. Ir suahi ot saot na turtur ngasna, sur la ning lar kas lar oroi a talaporna. ");
INSERT INTO lbb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Naur a matam dia arlar ana lam ana palaom. Ning naur a matam dia wakak, a palaom rop ir bukus ana talapor. Ika ning dia laulau, a palaom rop ir bukus ana mormorom. ");
INSERT INTO lbb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ur tumarang, sakana a talapor kaning hom ir mormorom. ");
INSERT INTO lbb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ning a palaom rop ir bukus ana talapor, pa bel ta mormorom onoi, ir talapor kol, arlar ana lam ning a talaporna i sasai hom.” ");
INSERT INTO lbb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ning e Iesu ka warwara rop, ning a Parisaio i ben pasi sur ir hangan taum onoi. E Iesu i kas pa i kes sur diar hangan. ");
INSERT INTO lbb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A Parisaio i kulkulan, anasa i oroi mang e Iesu bel i gos nigon pas a kuna. ");
INSERT INTO lbb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A Leklek i atai i mang, “Mulo a Parisaiola mulo gos pas ka a risris a kap pa pelet, ika a balamulo i bukus ana kinkinau pa toltol laulaula. ");
INSERT INTO lbb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mulo na longlongla, bel mulo tasmani mang esaning i tol a risris a ututnala i tol otleng a balanla? ");
INSERT INTO lbb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ika, mulor tabar a kapan a tarai ana utna kaning na kap pa pelet, sur a ututnala rop ir totoh tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ir laulau kol tetek mulo a Parisaiola. Mulo nuknuk kol ana nanatar a warkurai larne, mulo saran taktakai rakai tetek e God miting na ning a bonot a nanatar a rakai miting na barim, ning i toboh wakak, ika bel mulo tol a tostos a warkurai tetek a tarai pa bel mulo mang sur e God. I wakak ning mulor tol a tostos a warkurai tetek a tarai pa mulor mang sur e God, pa gong otleng mulo duman sen taktakai miting na ning a bonot, sur mulor sarani tetek e God. ");
INSERT INTO lbb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ir laulau kol tetek mulo a Parisaiola, anasa mulo mang sur a keskes salanigo na rumai lotula, pa mulo mang sur a tarai lar saran a tnan hanrawai tetek mulo ting na puknala na tinan taum. ");
INSERT INTO lbb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ir laulau kol tetek mulo, ning mulo arlar ana tungtung a minat ning bel ta akinalang onla, pa tarai la han saot onla anasa bel la tasmani.” ");
INSERT INTO lbb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ning a halin a tena asaerla tagun a warkurai i keles e Iesu mang, “Tena Asaer, ning u atongi larne, u atong laulau mila otleng.” ");
INSERT INTO lbb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pa e Iesu i kelesi mang, “Ir laulau kol otleng tetek mulo a tena asaerla tagun a warkurai, anasa mulo saran a mamahat a warkuraila sur a tarai lar muri, ika mulo ot bel mulo nangan la. ");
INSERT INTO lbb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ir laulau kol tetek mulo, anasa anumulo na mangis a tarai ot tagun nating la umkol tar a propetla, pa mulo sira awakak a kulam a minatla anunla. ");
INSERT INTO lbb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","I maining mulo apuasa mulo mang mulo malmaling taum ana numulo na mangis a tarai tagun nating ana nunla titol, anasa la umkol a propetla, pa mulo, mulo awakak a kulam a minatla anunla. ");
INSERT INTO lbb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","I maining, e God, esaning i tastasman kol, i atongi mang, ‘Ar sune a propetla pa aposella tetek a tarai, pa tarai lar umkol halala onla, pa al tarai otleng lar akadik la.’ ");
INSERT INTO lbb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","I maining mulo, a tarai tagun onone, dir saran a warkurai a arkeles tetek mulo sur a suluk a propetla rop, ning di umkol tar la, turpasi ana kamkama rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Turpasi ning di umkol e Abel pa i han tuk oe Sekaria, esaning di umkoli na arpotor a logo na tun artabar pa rumai artabar. Momol, a atai mulo, dir saran a warkurai a arkeles tetek a tarai tagun onone ana ututnala rop ne. ");
INSERT INTO lbb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ir laulau kol tetek mulo a tena asaerla tagun a warkurai, anasa mulo kepsen sen a ki na taman a tastasman. Mulo ot bel mulo kas tingui, pa mulo sairas la ning la mang sur lar kas.” ");
INSERT INTO lbb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ning e Iesu i purum utumo lapiu, a tena asaerla tagun a warkurai pa Parisaiola la balakut pa la deken ngalngaliah i ana galis a kabah. ");
INSERT INTO lbb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pa la kes nanan e Iesu sur ta ngas a warwara sur lar tiwi onoi. ");
INSERT INTO lbb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ning a riprip a tarai la ka hanot taum, pa la sugut artalai la, e Iesu i atai nigon anuna kakak a asaerla mang, “Mulor tumarang ana is anuna Parisaiola. A warwara ana nunla na toltol a asasongo. ");
INSERT INTO lbb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A ututnala rop ning di polpol alar tari, lamur lar kes puasa, pa ututnala ning la kes kumna, lamur dir tasmani. ");
INSERT INTO lbb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Asaning mulo ka atong tari ana mormorom, lamur dir longori ana kabakiar, pa asaning mulo wasisik ka onoi tingui taum tik, lamur dir tur saot na rumai, pa dir atong puasai. ");
INSERT INTO lbb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“A atai mulo na halalik: Gong mulo matatan la ning la umkol ka a palaondi. Ning la ka tol tari larning, bel lar tolsot sur lar tol ulak ta utna. ");
INSERT INTO lbb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ika ar atai talapor mulo o esaning mulor matmataut suri: Mulor matatan esaning a rakrakaina i itna sur ir umkol mulo pa lamur ir migen otleng a ingumulo ting na tnan iah. Momol, a atai mulo, e God ka, ning mulor matmataut suri. ");
INSERT INTO lbb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Di sira lou dilima na tek ana naur a toia ka, gepi? Ika e God bel i duman ta halinla. ");
INSERT INTO lbb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","I momol kol, e God ka tasman naisa rop a hih a pukulumulo. Gong mulo matmataut, mulo itna kol na matana e God tana galis a tekla. ");
INSERT INTO lbb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“A atai mulo mang, esining ir atong puasai na matana tarai mang, i tagun iau, a Nat a Barsan otleng ir atong puasai na matan a angelola ane God mang i tagun iau. ");
INSERT INTO lbb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ika esining ir puain sen iau na matan a tarai, a Nat a Barsan otleng ir puain seni na matan a angelola ane God. ");
INSERT INTO lbb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Esining ir atong tar ta laulau a warwara ana Nat a Barsan, e God ir kepsen anuna toltol laulau ning, ika esining ir atong laulau a Talngan Tabu, e God bel ir kepsen anuna toltol laulau ning. ");
INSERT INTO lbb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ning la dat pas mulo sur a warkurai ting na rumai lotula, pa na matan a tena warkuraila pa ningnigola, gong mulo matmataut sur asa mulor warwara alar mulo onoi pa asa mulor atongi. ");
INSERT INTO lbb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Anasa ana pukakiar ning, a Talngan Tabu ot ir asaer mulo ana saning mulor atongi.” ");
INSERT INTO lbb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ning tagun a kunum a tarai i atai e Iesu mang, “Tena Asaer, ur atai a tasiklik sur ir asauran a gongonla omiau, ning e tamamiau i mat kusun tari.” ");
INSERT INTO lbb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pa e Iesu i kelesi mang, “Lak, esi i suah tar iau sur ar tena warkurai sur ar asauran anumu na gongon omu?” ");
INSERT INTO lbb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pa i atai la, “Mulor tumarang, pa mulor tai alar mulo kusun a nuknuk ana galis a gongon, anasa a lalaun anuna tik bel i kamkamna ana nuna galis a gongon.” ");
INSERT INTO lbb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pa i atai la ana ning a warwara larlar mange, “A barim anuna ning a tena gongon i wai pa i suah a galis a wanala. ");
INSERT INTO lbb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pa ka nuki mang, ‘Asa ar toli? Anasa bel ma ta pukna ning ar suah a utna na hangan tingia.’ ");
INSERT INTO lbb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pa ka atongi mang, ‘Ar toli mange, ar regen anuk na rumaila ning a sira suah taum a ututnala ono, pa ar tol al tatatnan, sur ar suah a utna na hangan pa anuk na gongon tingia. ");
INSERT INTO lbb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pa ar atai a inguk mange, “Inguk, anum a gongon i galis kol sur al galis a rau. Ur manah, ur hangan, ur gang pa ur gas.” ’ ");
INSERT INTO lbb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ika e God i atai i mange, ‘U a longlong! Onone na morom, ur mat! Esi ir kibas a gongon ning u ka sang tari sur u?’ ");
INSERT INTO lbb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ir manglarning tetek la ning la gongon tetek la ot, ika bel la gongon na matana e God.” ");
INSERT INTO lbb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","E Iesu i atai anuna kakak a asaerla mang, “I maining a atongi tamulo mang, gong mulo nuknuk kol ana numulo a lalaun mang asaning mulor ieni, pa ana palaomulo otleng mang asa mulor mermer ono. ");
INSERT INTO lbb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Anasa a lalaun i itna tana utna na hangan, pa palaomulo otleng i itna tana kaenla. ");
INSERT INTO lbb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mulor oroi a kotkotla. Bel la oman tar ta utna, pa bel la sol tar al utna, bel al rumai a gongon anunlai, ika e God i tabar la. Pa mulo, mulo itna kol tana manila. ");
INSERT INTO lbb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Esi tamulo ning i nuknuk kol ana nuna lalaun, ir tolsot sur ir tugus barah siklik anuna lalaun? Bel tik. ");
INSERT INTO lbb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ning bel mulo tolsot pas a siklik utna ne, sur asaning mulo nuknuk kol sur al ututnala otleng? ");
INSERT INTO lbb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Mulor oroi a wakak a purpurla misa na bual, mang la gomo mangmangasa. Bel la sira titol pa bel la sira tol kaen. Ika a atai mulo, e King Solomon ot ning anuna mermer rop i tai wakak, ika bel i tai wakak arlar ana purpurla ning. ");
INSERT INTO lbb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","E God i amermer a ulai sakas na bual ana wakak a purpurinla, ning anone i tapalas, pa latu dir tun seni ting na iah. Ning i toli larning ana ulai, i momol kol mang ir amermer mulo otleng. Anumulo a tortorot i natarna kol. ");
INSERT INTO lbb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Gong mulo tai sur asaning mulor ieni, pa asaning mulor gangi, pa gong mulo nuknuk kol onoi. ");
INSERT INTO lbb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Anasa a taraila mite na rakrakan hanua ning bel la tasman e God, la rakrakai sur a ututnala rop ning, ika e Tamamulo i tasmani mang mulo kapan sur a ututnala. ");
INSERT INTO lbb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mulor rakrakai sur anuna matanitu, pa ir tabar mulo otleng ana ututnala ne. ");
INSERT INTO lbb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“A natar a liur a sipsip, gong mulo matmataut, anasa e Tamamulo i gas sur ir saran a matanitu tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mulor siuran sen anumulo na gongonla sur ta mani, pa mulor tabar a kapan a taraila onoi. Mulor sang pas al paus anumulo ning bel ir marot, a gongonla saot na langit ning bel ir rarop, pa bel ta tena kinkinau ir han milau i, pa koropos bel ir alaulau i. ");
INSERT INTO lbb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Anasa ting na hanua ning anumulo a gongonla kaning ia, anumulo a lalaun otleng kaning ia. ");
INSERT INTO lbb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mulor mermer pa mulor asot anumulo na lamla, pa mulor kes na sang kama. ");
INSERT INTO lbb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Pa mulor arlar ana tena titolla ning la harnanai sur anunla leklek ning ir ulak kusun a ngasa ana tona tintaulai. Ning ir hanot pa ir pinpidir, dir sapang kapit pasi. ");
INSERT INTO lbb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ning a leklek ir hanot, pa anuna tena titolla la sang, lar angis. A momolna ot ne a atongi tamulo, ir mermer pas sur ir suk a utna na hangan, pa ir akes la ting na logo na hangan pa ir tabar la. ");
INSERT INTO lbb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ning ir hanot ana tnan morom, o ana lar, pa ir pastetek la ning la sang suri, a tena titolla ning lar angis. ");
INSERT INTO lbb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mulor tasmani mang: Ning a tamana rumai ir tasmani nangse a tena kinkinau ir hanot, bel ir noren anuna rumai sur dir kinau i. ");
INSERT INTO lbb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mulo otleng, mulor sang, anasa a Nat a Barsan ir hanot nangse ning bel mulo nuki mang ir hanot.” ");
INSERT INTO lbb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","E Pita i deken e Iesu mang, “Leklek, u warwara larlar omila ka o ana taraila rop?” ");
INSERT INTO lbb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A Leklek i kelesi mange, “A tena titol ning i momol ana nuna titol pa i tastasman otleng, anuna leklek ir akes tari sur ir ningnigo ting na nuna rumai, sur ir tabar a tena titolla ana utna na hangan anlai ana taim na hangan. ");
INSERT INTO lbb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A tena titol ning, ir angis ning anuna leklek ir hanot pa ir oroi i ning i tolsot pas anuna titolla. ");
INSERT INTO lbb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A atong momoli tamulo, anuna leklek ir suahi sur ir tena tai alar ana nuna ututnala rop. ");
INSERT INTO lbb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ika ning a tena titol i nuki mang anuna leklek bel ir hanot kapit, pa i turpasi sur ir um a tena titol a barsanla pa tena titol a gurarala, pa ir hangan, pa ir gang pa ir sipak, ");
INSERT INTO lbb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","anuna leklek ir hanot ana pukakiar ning a tena titol ning bel ir tasmani pa ana awa ning bel i nuki mang ir hanot ono. Pa leklek ir ting kutkutusi, pa ir saran tar a warkurai a arkeles teteki, sur ir kes taum ana tabun longorla. ");
INSERT INTO lbb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“A tena titol ning ka tasman tar a nuknuk a leklek anunai, ika bel i sang, pa bel i titol arlar ana nuknuk a leklek anunai, dir miras koli. ");
INSERT INTO lbb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ika a tena titol ning bel i tasman a nuknuk a leklek anunai, pa i tol a utna ning bel i tostos, dir miras sikliki ka. Pa tetek esining di saran a tnan tana, dir mang sur al galis ot tana, pa esining di saran a galisna tana, dir atai i ot sur ir kelesi anal galisna. ");
INSERT INTO lbb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“A hanot sur ar atna tar a iah te na rakrakan hanua, pa a mang kol suri ning ka sot. ");
INSERT INTO lbb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A baptais kaning ot ning dir baptais iau onoi, pa onone a los a tnan mamahat tuk ning ir rarop. ");
INSERT INTO lbb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mangasa, mulo nuki mang a hanot sur ar saran a balmolmol te na rakrakan hanua? Bel! A hanot sur a taraila lar taptapagal sarara. ");
INSERT INTO lbb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Turpasi onone, dilima onla ting na ning a rumai lar tapagal, natol kusun naur, pa naur kusun natol. ");
INSERT INTO lbb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lar tapagal sarara, a barsan kusun e natna barsan, pa kaklik barsan kusun e tamana, a hane kusun e natna hane, pa kaklik hane kusun e tana, pa ning naur a tubuna diar balakut artalai tetek diau.” ");
INSERT INTO lbb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","E Iesu i atai a kunum a taraila mang, “Ning mulor oroi a bual ir aturi toui na matana labur, mulor atong kapiti mang, ‘Milau a kiar kar punga,’ pa i momol ot. ");
INSERT INTO lbb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ning a tobar ir wuwut, mulor atongi mang, ‘A kamis kar rakrakai,’ pa i momol ot. ");
INSERT INTO lbb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mulo na tena asasongo! Mulo tastasman sur mulor pak a tatatai te na rakrakan hanua pa misaot na bakut. Mangmangasa ning bel mulo tastasman sur mulor pak a kamkama ututnala ning i hanot ana pukakiarla ne? ");
INSERT INTO lbb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“I mangasa ning mulo ot bel mulo nuknuk wakak sur asaning i tostos? ");
INSERT INTO lbb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ning tik ir suah tar u ana warkurai, ur rakrakai sur mur baltaum ting na numu a tinan, sakana ir dat pas u tetek a tena warkurai, pa tena warkurai ir saran tar u tetek a tena tai alar, pa tena tai alar ir akas tar u ting na karabus. ");
INSERT INTO lbb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A atai u, bel ur purum tuk ot ning ur saran a ararop a toia ana num a arlou.” ");
INSERT INTO lbb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ana pukakiar ning, dingla na tarai la atai e Iesu ana dingla na tarai Galili ning e Pailat i umkol la, ning kaning ot la tun artabar tetek e God. ");
INSERT INTO lbb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","E Iesu i keles la mang, “Mangasa, mulo nuki mang la laulau tana tarai Galili rop, anasa la hirua manglarne? ");
INSERT INTO lbb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bel! Ika a atai mulo, ning bel mulo lingir a nuknukimulo kusun anumulo na toltol laulaula, mulo otleng mulor hirua rop. ");
INSERT INTO lbb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Pa asaning mulo nuki ana ning a bonot pa pisir siwal a tarai saot e Jerusalem ning a rumai leklek tumo e Siloam i taroh pa i umkol arop la? Mangasa, la laulau tanla ning la kes saot e Jerusalem rop? ");
INSERT INTO lbb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bel! Ika a atai mulo, ning bel mulo lingir a nuknukimulo kusun anumulo na toltol laulaula, mulo otleng mulor hirua.” ");
INSERT INTO lbb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lamur e Iesu i atong a warwara larlar ne tetek la, “Ning a barsan anuna rakai a fig i tur potor ting na barim a wain anunai. I han pa i tai sur ta wana, ika bel i pastetek tik. ");
INSERT INTO lbb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lamur i atai a tena tai alar ana barim, ‘Ana natol a rau ne a tol panai sur ta wana rakai a fig ne. Ting seni! Anasa i tur alalar.’ ");
INSERT INTO lbb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ika a tena tai alar i kelesi mang, ‘Leklek, ur noreni ning a rau kale ne, sur ar tol talapori, pa ar kel pori. ");
INSERT INTO lbb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ning ir wai ana rau ning lamur, ir wakak. Ning bel, ur ting seni.’” ");
INSERT INTO lbb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ana ning a Pukakiar Sabat e Iesu i asaer a taraila ting na ning a rumai lotu. ");
INSERT INTO lbb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ning a hane i kes tingia, a mot kaning onoi. A intauruna i talugun ning a bonot pa pisir siwal a rau, pa bel i tolsot sur ir tur tostos. ");
INSERT INTO lbb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ning e Iesu i oroi, i atongi mang, “Lak, u ka langolango kusun anum a tinsaman.” ");
INSERT INTO lbb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pa e Iesu i suah naur a kuna saot onoi, aiap ka a hane ning i tur tostos, pa i aleklek pas e God. ");
INSERT INTO lbb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A ningnigo tagun a rumai lotu i balakut, anasa e Iesu i alangolango pas a hane ana Pukakiar Sabat. Pa i atai a taraila mang, “Diono na pukakiar kaning sur dir titol. Mulor hanot onoi, sur dir alangolango mulo, ika a Pukakiar Sabat gong.” ");
INSERT INTO lbb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A Leklek i kelesi mang, “Mulo na tena asasongo! Mulo rop taktakai, mulo sira pak sen anumulo a bulumakau o a dongki kusun anuna rumai, pa mulo ben purumi ana Pukakiar Sabat sur ir gang. ");
INSERT INTO lbb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A hane ne miting na mangis a tarai ane Abaram, e Satan i dot tari ning a bonot pa pisir siwal a rau. Asa kamkamna ning bel dir pak sen a inau ne kusuni ana Pukakiar Sabat?” ");
INSERT INTO lbb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ning i atong tari larne, la rop ning la lingir a titol ane Iesu, la meme, ika a kunum a tarai la gas ana wakak a ututnala ning e Iesu i toli. ");
INSERT INTO lbb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","E Iesu i deke mang, “A matanitu ane God i arlar ana sa? Esi na warwara larlar ar atongi sur ar papak ana matanitu ane God? ");
INSERT INTO lbb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I arlar ana pat a mastad, ning takai a barsan i kibas pasi, pa i oman tari ting na nuna barim. I gomo, pa i hanot a rakai, pa manila la sira tol pios saot na rakrakana.” ");
INSERT INTO lbb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","E Iesu i deke ulak mang, “Esi na warwara larlar ar atongi sur ar papak ana matanitu ane God? ");
INSERT INTO lbb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I arlar ana is ning a hane i kibas pasi pa i tol taumi ana tnan palawa, pa palawa rop i bubus onoi.” ");
INSERT INTO lbb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ning e Iesu i han amon usaot e Jerusalem, i asaer a taraila ting na tatatnan hanua pa na nanatar a hanua. ");
INSERT INTO lbb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pa takai i deken e Iesu mang, “Leklek, mangmangasa, al siklik tarai ka e God ir alaun pas la?” Pa i atai la mang, ");
INSERT INTO lbb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mulor rakrakai kol sur mulor kas ana natar a taman lik, anasa a galis a tarai lar tohoi sur lar kas onoi ika bel lar tolsot pasi. ");
INSERT INTO lbb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A tamana rumai ir tur pa ir tagar alar a taman, pa mulor tur tumo lapiu, mulor pinpidir ting na taman pa mulor atongi mang, ‘Leklek, sapang pas mila.’ Ir keles mulo mang, ‘Bel a tasman mulo pa mulo mitaha.’ ");
INSERT INTO lbb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Lamur mulor atai i mang, ‘Mila hangan pa mila gang taum hom, pa u sira asaer ting na numila na hananuala.’ ");
INSERT INTO lbb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ika ir keles mulo mang, ‘Bel a tasman mulo pa mulo mitaha. Mulo na tena laulau rop, mulor han masik kusun iau.’ ");
INSERT INTO lbb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dir kepsen purum mulo, pa ning mulor oroi e Abaram, Aisak pa e Jekop pa propetla ana matanitu ane God, mulor tangtangis, pa mulor arngingit ngesemulola tingia. ");
INSERT INTO lbb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pa taraila lar han miting na matana tobar pa matana labur, lar kes ana ngasa ting na matanitu ane God. ");
INSERT INTO lbb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Oroi, dingla na tarai ning onone la mur, lar nigo, pa dingla ning onone la nigo, lar mur.” ");
INSERT INTO lbb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ana pukakiar ning, dingla na Parisaio la hanot tetek e Iesu, pa la atai i mang, “Ur han mite sur ta hanua masik, anasa e Herot i mang sur ir umkol u.” ");
INSERT INTO lbb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","E Iesu i keles la mang, “Mulor han pa mulor atai a rokoio na pap ning mange, onone pa latu ar kepsen a motla pa ar alangolango a taraila, pa ana pukakiar lanigo ar arop anuk a titol ono. ");
INSERT INTO lbb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ar han onone pa latu pa ana pukakiar lamur tana pukakiar latu, anasa bel ta propet ir hirua ting na ta pukna masik, ir hirua ka saot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, u ning u sira umkol a propetla, pa la ning di sune la tetek u, u sira wolot amat la ka ana hatatla. A galis a pukakiar a mang sur ar kibas taum na natnatum tetek iau, arlar ana kakaruk ning i roroh alar na natnatna nahai naur a dehelna, ika bel mulo mang. ");
INSERT INTO lbb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Oroi! Anumulo a hanua ir hanot a hanua bel. A atai mulo, bel mulor oroi ulak iau tuk ning mulor atongi mang, ‘Esaning i hanot ana risan a Leklek i angis.’” ");
INSERT INTO lbb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ana ning a Pukakiar Sabat, e Iesu i kas sur ir hangan ting na rumai ana ning a ningnigo anuna Parisaiola, pa taraila la oroi sursuri sur ta utna ning ir toli. ");
INSERT INTO lbb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pa ning a barsan i sasam, a palaona i sursurung, i kes tar salanigo ta e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","E Iesu i deken a tena asaerla tagun a warkurai pa Parisaiola mange, “Mangasa, i tostos ana warkurai sur dir alangolango a taraila ana Pukakiar Sabat o bel?” ");
INSERT INTO lbb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ika bel la kelesi. E Iesu i tong pas a barsan ning, i alangolango pasi, pa i sune seni. ");
INSERT INTO lbb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pa e Iesu i deken la mang, “Esi na halimulo ning e natnalik o anuna ta bulumakau ir punga tar uting na ta tung a malum ana Pukakiar Sabat bel ir dat kas kapit pasi?” ");
INSERT INTO lbb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pa bel la keles sot pas anuna kabah. ");
INSERT INTO lbb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ning e Iesu i kes ana utna na hangan ne, i oroi a taraila ning la hanot, la aslang pas ot a keskes salanigo. Pa i atong ning a warwara larlar tetek la mange, ");
INSERT INTO lbb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ning tik ir ben pas u uting na ngasa ana tona tintaulai, gong u kes ana ngasa salanigo, sakana ir ben pas tik ning i leklek hom. ");
INSERT INTO lbb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Pa esaning i arbebe ana ngasa ir hanot pa ir atai u mang, ‘Ur kes pisir kusun a barsan ne.’ Pa ur han ana meme sur a keskes tumo lamur. ");
INSERT INTO lbb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ning di ben pas u, ur han pa ur kes ana keskes tumo lamur, sur esaning i arbebe ir hanot tetek u, pa ir atai u mang, ‘Halik, ur tur pa ur han ute lanigo.’ Pa dir aleklek pas u na matanla ning mulo kes taum ana utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anasa esining i aleklek pasi, e God ir anatarna i. Pa esining i anatarna pasi, e God ir alekleki.” ");
INSERT INTO lbb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Lamur e Iesu i atai a Parisaio ning i ben pasi sur a utna na hangan mange, “Ning u mang sur ur sang a utna na hangan, gong u ben pas na halalim, na tastasimla, na maimla, pa leklekla ning la kes milau u. Anasa la ne lar ben pas u pa lar kelesi tetek u. ");
INSERT INTO lbb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ika, ning u sang a utna na hangan, ur ben ka a kapan a tarai, la ning a palaonla i mat, la ning la kaukawar ka, pa kutla. ");
INSERT INTO lbb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ning ur toli larne ur angis. Anasa bel al utna na hangan anlai sur lar kelesi tetek u, e God ir kelesi tetek u ana pukakiar ning a tena tostosla lar laun ulak.” ");
INSERT INTO lbb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ning a halinla ning la hangan taum oe Iesu i longor a warwarala ne, i atai i mang, “La ning lar hangan ana ngasa ting na matanitu ane God, la angis.” ");
INSERT INTO lbb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pa e Iesu i atai i mang, “Ning a barsan i sang a tnan ngasa, pa i atai a galis a tarai sur lar hanot. ");
INSERT INTO lbb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ning a pukakiar ana ngasa ka hanot, i sune anuna tena titol oros tetek la, ning di ka atai nigon tar la ana warwara mange, ‘Mulor han ute, anasa a ututnala ka sang rop.’ ");
INSERT INTO lbb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ika la rop la warwara alalar la ka. A ningnigona i atongi ka tana mang, ‘Ia ka lou tar a puka kabalapiu sur a barim. Ar han par oroi. A nunung u sur dir noren iau kama.’ ");
INSERT INTO lbb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pa ning otleng i atongi mang, ‘Ia ka lou tar ning a bonot a bulumakau, ar han sur ar toho la. A nunung u sur dir noren iau kama.’ ");
INSERT INTO lbb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pa ning otleng ka atongi mang, ‘Onone ia ka taulai, pa bel ar tolsot sur ar han.’ ");
INSERT INTO lbb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Pa tena titol oros i ulak pa i atai anuna leklek ana warwarala ning. A leklek ning i balakut, pa i atai anuna tena titol oros mang, ‘Ur han kapit uting na tatatnan ngas pa uting na nanatar a ngas ting na hanua, pa ur ben pas a kapan a taraila, la ning a palaonla i mat, a kutla, pa la ning la kaukawar ka.’ ");
INSERT INTO lbb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lamur a tena titol oros i atongi mang, ‘Leklek, ia ka tol tar a ututnala rop ning u sune iau sur ar toli, ika dingla na pukna kaning ot na rumai.’ ");
INSERT INTO lbb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","A leklek i atai a tena titol oros mang, ‘Ur han sur a tatatnan ngas pa nanatar a ngas ting na bual, pa ur angongos pas a taraila sur lar kas, sur anuk a rumai ir bukus. ");
INSERT INTO lbb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A atai mulo, bel tik ta halinla, ning di atai nigon tar la, ir hangan ana nuk a ngasa.’” ");
INSERT INTO lbb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A tnan kunum a tarai la armuri taum oe Iesu. I talingir tetek la pa i atai la mang, ");
INSERT INTO lbb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ning tik i mang sur ir mur iau, ika i katnan e tamana, pa e tana, anuna hane pa na natnatna, na tastasna pa anuna lalaun otleng, pa bel i katnan kol iau, ai bel anuk a kaklik a asaer. ");
INSERT INTO lbb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Esining bel i pamar pas anuna rakai kutus pa i mur iau, bel i sot sur ir hanot anuk a kaklik a asaer. ");
INSERT INTO lbb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ning tik ta halimulo i mang sur ir tol ta tnan rumai, ir kes kaba pa ir tol otnan nigon a matana rumai rop, sur ir tasmani mang anuna mani ir sot sur ir arop a rumai o bel. ");
INSERT INTO lbb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sakana ir tol tar ka a kama rumai, pa bel ir tolsot sur ir aropi. Pa taraila rop ning la oroi, lar morot onoi ");
INSERT INTO lbb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","mang, ‘A barsan ne i tol tar ka a kama rumai, ika bel i tolsot sur ir aropi.’ ");
INSERT INTO lbb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ning ta king, ning a bonot a rip a tarai a harum ir han ana harum sur ning a king otleng anuna naur a bonot a rip a tarai a harum, i wakak sur a king ning anuna ning a bonot a rip ir kes pa ir nuknuk nigo larne, la to pas naur a bonot a rip o bel. ");
INSERT INTO lbb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ning bel ir tolsot, ir sune anuna tena titolla, sur lar atostos warwara taum ana king, ning kaning ot bakbak, sur a balmolmol ir kes. ");
INSERT INTO lbb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mang otleng larning, ning tik ta halimulo bel i noren sen tar anuna ututnala rop, ai bel anuk a kaklik a asaer. ");
INSERT INTO lbb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“A sol i wakak, ika ning a makmakana ka rop, dir amakmakan ulak mangmangasa pasi? ");
INSERT INTO lbb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bel i to pas ta titol ting na barim pa bel i awakak otleng a kabalapiu, dir migeni kama. Esining a talngana kaning, i wakak ning ir longor ono.” ");
INSERT INTO lbb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ning a pukakiar a tena los totokomla pa tena tol a toltol laulaula la hanot tetek e Iesu sur lar longori. ");
INSERT INTO lbb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ika a Parisaiola pa tena asaerla tagun a warkurai la ururai oe Iesu mang, “A barsan ne i lasan ka taum ana tena tol a toltol laulaula, pa i hangan taum onla.” ");
INSERT INTO lbb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pa e Iesu i atong a warwara larlar tetek la mange: ");
INSERT INTO lbb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ning tik ta halimulo anuna ta mar a sipsip, pa ta halinla i rongo, i mangasa, bel ir han kusun a siuk a bonot pa pisir siuk ting na pukna ning la hangan ia, pa ir tai sur takai ning i rongo, tuk ning ir pasteteki? ");
INSERT INTO lbb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ning kar pastek pasi, ir pamar pasi, pa ir gas. ");
INSERT INTO lbb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ning ir ulak onoi, ir kabah taum na halalna pa la ning la kes milau, pa ir atai la mang, ‘Dalar gas, anasa ia ka pastetek ulak pas anuk a sipsip ning i rongo.’ ");
INSERT INTO lbb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A atai mulo, i mang otleng larning saot na langit a gasgas ana ning a tena tol a toltol laulau ning ka lingir a nuknukna. Momol, di sira gas ana siuk a bonot pa pisir siuk ning la ka tostos tar, pa bel la kapan sur lar lingir a nuknukinla. Ika, ning ta tena tol a toltol laulau ka lingir a nuknukna, a gasgas ning, ir itna kol tana gasgas ana siuk a bonot pa pisir siuk. ");
INSERT INTO lbb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ning ta hane anuna ir takai a bonot a mani, pa i arongon takai. Mangmangasa, bel ir asot pas a lam, pa ir surupu a rumai, pa ir tai wakak suri, tuk ning ir pasteteki? ");
INSERT INTO lbb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ning kar pastetek pasi, ir kabah taum pas na halalna pa la ning la kes milau, pa ir atai la mang, ‘Dalar gas, anasa ia ka pastetek ulak pas takai a mani ning a arongon tari.’ ");
INSERT INTO lbb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A atai mulo, mang otleng larning a gasgas na arpotor ana angelola ane God anasa ning a tena tol a toltol laulau ka lingir a nuknukna.” ");
INSERT INTO lbb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","E Iesu i atongi mange, “Ning a barsan naur a natna barsan. ");
INSERT INTO lbb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pa murmur i atai e tamana mang, ‘Tata, ur saran tar anuk a tiniba miting na num a gongon.’ Pa e tamandiau i asauran anuna gongon tetek diau. ");
INSERT INTO lbb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Naisa na pukakiar alar tari, a murmur i suah taum pas anuna gongon rop, pa i han uting na hanua kaning bakbak, pa i arop tar anuna gongon ana ngas a lalaun ning bel i wakak. ");
INSERT INTO lbb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ning ka arop sen tari, a tnan munurak i hanot ting na hanua ning, pa i murak. ");
INSERT INTO lbb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pa i han, pa i titol tetek ning a barsan ting na hanua ning. Pa barsan ning i sune i sur anuna woroh na boroi sur ir tabar la. ");
INSERT INTO lbb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I mang sur ir masur ana palpal a utna ning a boroila la ienieni, ika bel tik i tabari. ");
INSERT INTO lbb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ning a wakak a nuknuk ka hanot teteki, i atongi mang, ‘A tena titolla ane tata, la sira hangan pa la sira masmasur pas ka kusun a ututnala, ika iau, kane ia ka mat murak! ");
INSERT INTO lbb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Onone ar kamtur pa ar han ulak tetek e tata. Ar atai i mange, “Tata, ia ka tol tar a toltol laulau tetek e God pa tetek u otleng. ");
INSERT INTO lbb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Bel a wakak sur ur atong iau e natumlik. Ur suah iau kama sur ar arlar ana num a tena titol.” ’ ");
INSERT INTO lbb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pa i kamtur pa i ulak tetek e tamana. “Kaning ot bakbak, e tamana i oroi pasi, pa i bukus ana marmaris. I dun teteki, i pos pasi pa i goro i. ");
INSERT INTO lbb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pa e natnalik ka atai i mang, ‘Tata, ia ka tol tar a toltol laulau tetek e God pa tetek u otleng. Bel a wakak sur ur atong iau e natumlik.’ ");
INSERT INTO lbb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ika e tamana i atai anuna tena titolla mang, ‘Aiap! Mulor kibas kapit pas ta kaen ning i wakak kol ute, pa mulor apipisi ono. Mulor suah a ring ting na kuna, pa naur a su ting na naur a hana otleng. ");
INSERT INTO lbb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mulor han, mulor dat pas ta nat a bulumakau ning i butbut ute, mulor umkoli, pa dalar hangan pa dalar gasgas taum. ");
INSERT INTO lbb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Anasa a natuklik ne ka mat, pa onone ka laun ulak, i rongo tar pa ne ka hanot.’ Pa ngasa i turpasi. ");
INSERT INTO lbb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ika e natnalik, ning a ningnigo, kanisaot na barim. Ning i hanot utumo lahanua milau a rumai, ka longor a tinangis a goto pa saksak a tortor, ");
INSERT INTO lbb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","pa i kabah pas ning a tena titol, pa i dekeni ana saning i hanot. ");
INSERT INTO lbb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Pa i kelesi mang, ‘E tasimlik ka hanot, pa e tamam i umkol pas a nat a bulumakau ning i butbut sur lar tol a ngasa onoi, anasa dia tai taum ulak ana wakak a lalaun.’ ");
INSERT INTO lbb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pa ningnigo na tasnalik i balakut, pa i ngongoio, bel i mang sur ir kas. Pa e tamana i purum teteki, pa i amoro pasi. ");
INSERT INTO lbb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ika i atai e tamana mang, ‘Oroi! A galis a rau a titol tetek u arlar ana tena titol, bel a tabun longor ana num a warkuraila. Ika bel u tabar iau ana ta natar a meme, sur mila taum ana halalikla milar gasgas taum ono. ");
INSERT INTO lbb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ika ning e natumlik ne i hanot, esaning i alaulau anum a ututnala ana laulau a gurarala, u umkol pas ot a nat a bulumakau ning i butbut sur ir ieni.’ ");
INSERT INTO lbb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","E Tamana i kelesi mange, ‘Natuklik, u kanet u kes napirik, pa anuk na gongon rop, anumi ka. ");
INSERT INTO lbb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I wakak sur dalar gasgas pa dalar hangan, anasa e tasimlik ne ka mat pa onone ka laun ulak, i rongo tar, pa onone ka hanot ulak.’” ");
INSERT INTO lbb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","E Iesu i atai anuna kakak a asaerla mang, “Ning a tena gongon, anuna ning a tena titol i tai alar anuna ututnala, pa di tiwi mang i tol oros ka a ututnala ana ningnigo anunai. ");
INSERT INTO lbb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A tena gongon i kabah pasi, pa i dekeni mang, ‘Asa ne a longori hom? Ur tumus a warwara talapor ana num a titol na tai alar pa ur sarani tak, anasa bel ur tena tai alar ulak ma anuki.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pa tena tai alar ning i nuki mang, ‘Asaning ar toli, ning anuk a leklek ir kepsen tar iau kusun a titol ne? A palaok bel i rakrakai sur a kekel, pa ar meme otleng sur ar nunung utna. ");
INSERT INTO lbb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","I maining, a nuk pas ning a utna sur ar toli, sur a tarai lar gasgas pas iau ot ting na nunla na rumaila, ning dir kepsen iau kusun a titol ne.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pa i arsune sur la rop ning la ka dinau pas tan anuna leklek. Pa i deken a ningnigo na barsan mang, ‘Naisa ning u dinau pasi tan anuk a leklek?’ ");
INSERT INTO lbb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Pa i kelesi mange, ‘Takai a mar a tatatnan koto na wel a oliw.’ Pa tena titol i atai mang, ‘Ur los pas anum a paka buk a dinau. Ur kes pa ur tumus kapit tar dilima na bonot ka onoi.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pa i deken male takai, ‘Naisa ning u dinau pasi?’ Pa i kelesi mange, ‘Takai a mar a bek a wit.’ Pa i atai i, ‘Ur los pas anum a paka buk a dinau. Ur tumus tar siwal a bonot ka onoi.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Anuna ningnigo i aleklek pas a tena titol ning i asongo pasi, anasa i tastasman kol sur ir alah kusun a mamahat. Anasa a taraila mite na rakrakan hanua, la tastasman kol ana urmatana ngas ana nunla na titol, ika a taraila miting na talapor bel la tastasman kol onoi. ");
INSERT INTO lbb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A atai mulo, mulor amoro pas al halalimulo ana gongon mite na rakrakan hanua, sur ning ka rop, e God ir gasgas pas mulo ting na rumaila ning lar kes tikin pa bel lar rarop. ");
INSERT INTO lbb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Esining i momol ana natar a utna ka, ir momol otleng ana tnan utna, pa esining bel i momol ana natar a utna, bel ir momol otleng ana tnan utna. ");
INSERT INTO lbb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ning bel mulo momol sur mulor tai alar wakak a ututnala mite lapiu, esi ir tortorot omulo sur mulor tai alar a ututnala misaot? ");
INSERT INTO lbb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ning bel mulo momol ana ta utna anun tik, esi ir saran ulak anumulo na ututna tetek mulo? ");
INSERT INTO lbb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bel ta tena titol ir titol sot pas tetek ir naur a ningnigo. Ir nget ning a halindiau, pa ir mang sur ning a halindiau, ir katnan ning pa takai ir saran a kaba hina kusuni. Bel mulor titol sot pas tetek e God pa tetek a mani otleng.” ");
INSERT INTO lbb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A Parisaiola la longor a warwarala ne, pa la morot oe Iesu, anasa la mang sur a mani. ");
INSERT INTO lbb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pa e Iesu i atai la, “Mulo, mulo atostos pas mulo na matana taraila. Ika e God i tasman a balamulo. Anasa a utna ning i itna na matana taraila i bilbilor na matana e God. ");
INSERT INTO lbb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“A Warkuraila pa asaerla anuna propetla i tuk tar oe Jon. Turpasi ana pukakiarla ning, mila warawai ana Wakak a Warwara ana matanitu ane God pa taraila rop la ngongos sur lar kas tingia. ");
INSERT INTO lbb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bel i ngangaten sur a langit pa rakrakan hanua diar rarop, ika i ngangaten kol sur ta diah warwara ir rarop kusun a Warkuraila. ");
INSERT INTO lbb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ning tik ir kepsen anuna hane, pa ir taulai ta hane ulak, a barsan ning i tol a toltol laulau. Pa esining ir taulai ta hane ning anuna barsan i kepseni, i otleng ka tol a toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ning a gongon a barsan, i sira mermer ana wakak a kaenla, pa i sira hangan wakak ana pukakiarla rop. ");
INSERT INTO lbb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Di aborbor tar takai a barsan a tena nunung utna ting na taman tana, a risana e Lasarus, a palaona i masmasik. ");
INSERT INTO lbb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","I mang sur ir ien a mumut a utna na hangan ning i punga miting na logo na hangan ana leklek. Pa papla la damdam otleng a masmasikla ting na palaona. ");
INSERT INTO lbb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Lamur a tena nunung utna i mat, pa angelola la los pasi pa la akesi ting na ris e Abaram. Pa gongon a barsan kale i mat, pa di por seni. ");
INSERT INTO lbb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pa i kes ana tnan iah. I kankan kol a palaona pa i tadai usaot, i oroi e Abaram i bakbak kol, pa e Lasarus otleng ting na risna. ");
INSERT INTO lbb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pa i arkabah mange, ‘Tata Abaram, ur maris iau, ur sune e Lasarus sur ir tuk pas al siklik malum ana pitlai a kuna sur ir akotkoto tar a laigerek onoi, anasa a kilang a tnan kankan kol te na iah.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“E Abaram i kelesi mang, ‘Natuklik, ur nuk pasi, ning kaning ot u laun, u kibas anum a wakak a ututnala, pa mang otleng larning tetek e Lasarus, i kibas a laulau a ututnala. Ika onone, i kibas a gasgas, pa u, u kilang a tnan kankan kol. ");
INSERT INTO lbb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ning a utna otleng, a tnan lawa kane na arpotor indala. Bel tik mite ir tolsot pasi sur ir han uting tetek mulo, pa bel tik otleng miting ir tolsot pasi sur ir han ute tetek mila.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Pa tena gongon ning i atongi mange, ‘Tata, a nunung u sur ur sune e Lasarus uting na rumai ane tata. ");
INSERT INTO lbb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Anasa dilima na tastasik barsan la kaning ia, pa ir atumarang tar la, sakana la otleng lar han ute na hanua na kankan ne.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pa e Abaram i kelesi mange, ‘A warwara ane Moses pa propetla kaning i kes taum onla. I wakak sur lar longori.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A tena gongon ning i atai i mang, ‘Bel, Tata Abaram, ning tik ning ka kamtur ulak kusun a minat ir hanot tetek la, lar lingir a nuknukinla.’ ");
INSERT INTO lbb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pa e Abaram i kelesi mang, ‘Ning bel la longor e Moses pa propetla, bel tik otleng, ning ir kamtur kusun a minat ir tolsot sur ir atur anunla tortorot.’” ");
INSERT INTO lbb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","E Iesu i atai anuna kakak a asaerla mange, “A ututnala ir hanot ot, ning ir apungan a taraila ana toltol laulau, ika ir laulau kol tetek esaning i tol otnan a ututnala ne pa i ben rongon tik ta halinla. ");
INSERT INTO lbb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ning dir dot tar ta tnan hat ting na ruana tik ning i toli larne, pa dir migen murungi salatasi a warkurai a arkeles ning i natarna ka. Ika esaning ir apungan tik miting na kakakla ne ana toltol laulau, e God ir saran a tnan warkurai a arkeles kol tana. ");
INSERT INTO lbb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Mulor tai alar mulo! Ning e tasimlik ir tol ta toltol laulau, ur warwara rakrakai teteki, pa ning ka lingir a nuknukna, ur nuk duman sen anuna rongo. ");
INSERT INTO lbb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ning i tol a toltol laulau tetek u mais a taim ana ning a pukakiar, pa i han tetek u mais a taim pa i atai u mang, ‘Ia ka tol tar a toltol laulau tetek u. Onone a lingir a nuknukik.’ Ur nuk duman sen anuna rongo.” ");
INSERT INTO lbb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A aposella la atongi tana Leklek, “Ur aitna anumila tortorot.” ");
INSERT INTO lbb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pa Leklek i atongi mang, “Ning anumulo a tortorot i natarna arlar ana pata mastad, mulor tolsot pasi sur mulor atai a rakai ne mang, ‘Ur takakan, pa ur tur tisa latasi!’ pa ir longor ka. ");
INSERT INTO lbb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ning tik ta halimulo anuna tena titol i bair pas, o i tai alar a sipsipla, ning ir ulak kusun a barim, mangasa, ur atai i mang, ‘Ur han kakat ute, ur kes pa ur hangan’? Bel ur toli larne. ");
INSERT INTO lbb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ur atai i mange, ‘Ur sang angak a utna na hangan, pa ur sang sur ur malngan iau, ning ar hangan pa ar gang. Pa lamur u kale ur hangan pa ur gang.’ ");
INSERT INTO lbb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bel ir atong wakak tetek a tena titol, anasa i tolsot pas ka anuna titol. ");
INSERT INTO lbb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mang otleng larning tetek mulo, ning mulo ka tolsot pas a ututnala ning di saran tari tamulo, mulor atongi mang, ‘Bel mila tostos sur dir aleklek pas mila. Mila na tena titol oros ka, mila tolsot pas ka anumila a titol.’” ");
INSERT INTO lbb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ning e Iesu i han amon usaot e Jerusalem, i han ting na arpotor naur a papar, Samaria pa e Galili. ");
INSERT INTO lbb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ning i hanot ting na ning a hanua, la arsongo ana ning a bonot a barsan ning la lepra. La tur bakbak tar ot, ");
INSERT INTO lbb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","pa la kukuk rakrakai mange, “Iesu, Leklek, ur maris mila.” ");
INSERT INTO lbb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ning e Iesu i oroi la, i atai la mang, “Mulor han, mulor asangan mulo tetek a tena artabarla tetek e God.” Ning la han amon, la langolango kakat. ");
INSERT INTO lbb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ning na halinla ning i oroi mang ka langolango, i ulak, pa i aleklek pas e God ana tnan elngena. ");
INSERT INTO lbb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pa i kes ana bokona hana milau naur a hana e Iesu pa i atong wakak teteki. A barsan ne a te Samaria. ");
INSERT INTO lbb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","E Iesu i dekeni mang, “Bel di alangolango pas ning a bonot omulo rop? Siuk otleng la kanaha ma? ");
INSERT INTO lbb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","I mangasa ning bel tik i ulak sur ir aleklek pas e God? A wasira lik ka ne i ulak.” ");
INSERT INTO lbb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pa i atai i mang, “Ur kamtur, pa ur han. Anum a tortorot ka alangolango pas u.” ");
INSERT INTO lbb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dingla na Parisaio la deken e Iesu mang, “Nangse a matanitu ane God ir hanot?”, pa i keles la mang, “A matanitu ane God bel ir hanot taum ona akinalangla ning dir oroi. ");
INSERT INTO lbb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pa bel dir atongi mang, ‘I ma ine!’ o, ‘I ma i ning!’ Anasa a matanitu ane God kaning ot omulo.” ");
INSERT INTO lbb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","E Iesu i atai anuna kakak a asaerla, “A pukakiar ir hanot ning mulor mang sur mulor oroi ta pukakiar ana pukakiarla anuna Nat a Barsan, ika bel mulor oroi. ");
INSERT INTO lbb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Al tarai lar atai mulo mange, ‘I ot no!’ o, ‘I ka ine!’ Gong mulo mur la. ");
INSERT INTO lbb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Anasa ana pukakiar a tinan ot anuna Nat a Barsan, a taraila rop lar oroi. Ir arlar ana pil, ning i ienieni mito na ris a puka solsolna, tuk ting na ning a ris otleng. ");
INSERT INTO lbb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ika a Nat a Barsan ir kilang nigon a galis a mamahat, pa taraila tagun onone lar gilam ris kusuni. ");
INSERT INTO lbb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“A pukakiarla anuna Nat a Barsan ir arlar ana pukakiarla ane Noa. ");
INSERT INTO lbb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","A taraila la hangan, la gang, pa la ataulai la, tuk ana pukakiar ning e Noa i kas ana sip, pa kiar i punga pa lomom i hanot pa la hirua rop. ");
INSERT INTO lbb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mang otleng larning ana pukakiarla ane Lot. A taraila la hangan, pa la gang, la lolou, pa la sisiurai, la oman utna, pa la tol rumai. ");
INSERT INTO lbb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ika ana pukakiar ning e Lot i han kusun a hanua Sodom, a iah pa salfa i punga misaot na langit arlar ana kiar, pa la rop la hirua onoi. ");
INSERT INTO lbb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ir mang otleng larning ana pukakiar ning a Nat a Barsan ir hanot talapor onoi. ");
INSERT INTO lbb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ana pukakiar ning, ning tik ir kes saot na nuna rumai, gong i purum sur ir los pas anuna ututnala tingui na rumai. Mang otleng larning, ning tik ir kes ting na barim, gong i ulak utumo lahanua sur ta utna. ");
INSERT INTO lbb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mulor nuk pas a hane ane Lot. ");
INSERT INTO lbb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Esining i mang kol sur ir mangan alar anuna lalaun, ir hirua. Ika esining i noren sen anuna lalaun, ir laun. ");
INSERT INTO lbb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A atai mulo, ana morom ning ir naur diar borbor ana ning a mat, dir kibas pas ta halindiau, pa ning a halindiau bel. ");
INSERT INTO lbb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ning ir naur a hane otleng diar miren a wit, dir kibas pas ta halindiau, pa ning a halindiau bel.” ");
INSERT INTO lbb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pa kakak a asaerla la dekeni mang, “Leklek, a ututnala ne ir hanot tahaia?” Pa i keles la mang, “A pukna ning a minat i borbor tingia, a kotkotla lar han taum tingia.” ");
INSERT INTO lbb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","E Iesu i warwara ana warwara larlar tetek anuna kakak a asaerla sur ir asaer la sur lar araring bolbolos pa gong la ngoro. ");
INSERT INTO lbb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I atongi mang, “Ning a tena warkurai i kes ting na ning a hanua, bel i matmataut sur e God, pa bel i nuk pas a taraila. ");
INSERT INTO lbb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ning a lao miting na hanua ning, i han liklik ka teteki, pa i sira nunungi mang, ‘Ur atostos tar iau kusun anuk a hirua.’ ");
INSERT INTO lbb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ka bongnani pa bel i longor tana, pa lamur i nuki mang, ‘Bel a matmataut sur e God, pa bel a sira nuk pas a taraila, ");
INSERT INTO lbb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ika, ar atostos a lao ne, anasa i atikidis kol iau, sakana ir angoro iau ana nuna tinan ot ute.’” ");
INSERT INTO lbb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A Leklek i atongi tanla, “Mulor longor a warwara ne anuna tena warkurai ning bel i tostos. ");
INSERT INTO lbb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","I mangasa, e God bel ir atostos anuna tarai a aslang, ning la tangis teteki ana kamis pa morom otleng? I mangasa, ir molmolot pa bel ir atostos kapit la? ");
INSERT INTO lbb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A atongi tamulo, ir atostos kapit la. Ika, ning a Nat a Barsan ir hanot, i mangmangasa, ir pastek pas ot al tarai ning la tortorot ono te lapiu?” ");
INSERT INTO lbb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E Iesu i atong a warwara larlar ne tetek la ning la tortorot pas ot onla, mang la na tena tostos, pa la nuk natarna pas a tarai rop. ");
INSERT INTO lbb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Naur a barsan dia han usaot na rumai artabar sur diar araring. Ning a halindiau a Parisaio, pa ning a halindiau otleng a tena los totokom. ");
INSERT INTO lbb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A Parisaio i tur pa i araring ot mange, ‘God, a atong wakak tetek u anasa bel a arlar ana taraila rop, a tena kinkinaula, a tena tol orosla, pa taraila ning la tol a toltol laulau ana gurarala, pa bel a arlar otleng ana tena los totokom ne. ");
INSERT INTO lbb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","A sira tamai naur a pukakiar ana ning a wik, pa sira saran taktakai miting na ning a bonot ana ututnala ning a sira tol otnan pasi.’ ");
INSERT INTO lbb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ika a tena los totokom i tur masik tar, bel i tadai usaot na langit, anasa i meme. I dapis ka a malwasna ana balmaris, pa ka atongi mang, ‘God, ur maris iau, iau a tena tol a toltol laulau.’ ");
INSERT INTO lbb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","A atongi tamulo, a barsan ne, ning i ulak sur anuna rumai, i ka tostos na matana e God, pa ning a halindiau bel. Anasa esining i aleklek pasi, e God ir anatarna i. Ika esining i anatarna pasi, e God ir alekleki.” ");
INSERT INTO lbb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A tarai la los a kakak betbetela tetek e Iesu sur ir suah naur a kuna saot onla. Ika ning anuna kakak a asaerla la oroi i, la sairas la. ");
INSERT INTO lbb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ika e Iesu i kabah pas a kakakla teteki, pa i atongi mange, “Mulor noren sen a kakakla sur lar han tetek iau. Gong mulo sairas la, anasa a matanitu ane God anunla ning la manglarne. ");
INSERT INTO lbb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A atong momoli tamulo, ning tik bel ir kibas a matanitu ane God arlar ana kaklik, bel ir tolsot sur ir kas tingia.” ");
INSERT INTO lbb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ning a ningnigo i deken e Iesu mang, “Wakak a Tena Asaer, asaning ar toli sur ar kibas a lalaun tikin?” ");
INSERT INTO lbb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","E Iesu i kelesi mang, “Asa kamkamna ning u atong iau mang a wakak? Bel tik i wakak, e God ka. ");
INSERT INTO lbb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","U tasman a warkuraila: ‘Gong u tol a toltol laulau ana ta hane anuna tik o ta barsan anuna tik, gong u umkol tik, gong u kinkinau, gong u artitiu asasongo, ur hanrawai e tamam pa e tnam.’” ");
INSERT INTO lbb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A barsan ning i kelesi mang, “Turpasi ning a kaklik ot tuk onone, a sira mur a warkuraila rop ne.” ");
INSERT INTO lbb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ning e Iesu i longori, i atongi tana, “Ning a utna ot u kapan suri. Ur siuran sen anum a ututnala rop, pa mani onoi, ur tabar a kapan a tarai ono. Ning ur toli larne, anum a wakak a gongon kanisaot na langit. Lamur ur han ute pa ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ning i longor a warwara ne i balmaris kol, anasa anuna gongon i galis kol. ");
INSERT INTO lbb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","E Iesu i tai teteki pa i atongi mang, “I ngangaten kol tetek a tena gongonla sur lar kas ting na matanitu ane God! ");
INSERT INTO lbb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ir ngangaten sur a kamel ir kas ting na mosol a sur a susuk, ika i ngangaten kol tetek a tena gongon sur ir kas ting na matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ning la longor a warwara ne, la deke mang, “Manglarning, esi ma ning dir alauni?” ");
INSERT INTO lbb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","E Iesu i keles la mang, “Asaning a tarai bel lar tolsoti, e God ir tolsoti.” ");
INSERT INTO lbb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","E Pita i atongi tana mang, “Oroi, mila ka han kusun anumila na ututnala rop, pa mila mur u.” ");
INSERT INTO lbb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","E Iesu i atongi tanla mang, “A atong momoli tamulo, ning tik ir han kusun anuna rumai, o kusun anuna hane, o na tastasna, o kusun e tana, o e tamana, o na natnatna, kamkamna ana matanitu ane God, ");
INSERT INTO lbb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ana lalaun onone ir kibas a galis kol ana tarai pa utna ka han pas kusuni. Pa ana lalaun lamur dir tabari ana lalaun tikin.” ");
INSERT INTO lbb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","E Iesu i ben maskan pas anuna ning a bonot pa pisir naur a kakak a asaer, pa i atongi tanla mang, “Oroi, onone dala han amon usaot e Jerusalem, pa dir tolsot pas a ututnala rop ning a propetla la ka tumus tari ana Nat a Barsan. ");
INSERT INTO lbb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Anasa dir saran tari tetek la ning bel a tarai Juda. Lar morot laulau ono, lar atong laulau i, lar namisi, lar mirasi, pa lar umkoli. ");
INSERT INTO lbb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pa ana natol a pukakiar lamur ir kamtur ulak.” ");
INSERT INTO lbb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A kakak a asaerla bel la talapor ana ututnala rop ne. A kamkamna i kes mumun kusun la, pa bel la tasman asaning i warwara ono. ");
INSERT INTO lbb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ning e Iesu i han milau e Jeriko, ning a barsan a kut i kes tar ting na ris a ngas, i sira nunung utna. ");
INSERT INTO lbb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ning i longor a kunum a tarai la han milau amon, i deke mang, “Asaning?” ");
INSERT INTO lbb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pa la atai i mang, “E Iesu a te Nasaret i han bolos dala.” ");
INSERT INTO lbb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pa i kukuk mang, “Iesu, Nat e Dewit, ur maris iau.” ");
INSERT INTO lbb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pa la ning la nigo la sairasi sur ir kes wowowon. Ika i arkabah rakrakai kol mang, “Nat e Dewit, ur maris iau.” ");
INSERT INTO lbb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","E Iesu i tur suai, pa i arsune sur dir ben pasi teteki. Ning ka han milau teteki, i dekeni mang, ");
INSERT INTO lbb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Asaning u mang sur ar toli hom?” I kelesi mang, “Leklek, a mang sur ar tai.” ");
INSERT INTO lbb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pa e Iesu i atai i mang, “Ur tai! Anum a tortorot ka alangolango pas u.” ");
INSERT INTO lbb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ono otning ka tai, pa i mur e Iesu, pa i atong aitna pas e God. Pa tarai rop otleng ning la oroi, la rakan aleklek e God. ");
INSERT INTO lbb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E Iesu i kas tumo e Jeriko, pa i han bolos sur usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ning a barsan i kes tingia, a risana e Sakias, a ningnigo anuna tena los totokomla, pa i gongon kol. ");
INSERT INTO lbb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I mang kol sur ir oroi e Iesu, ika e Sakias a potpot a barsan ka, pa bel i tolsot pasi sur ir oroi i, anasa a kunum a tarai la tur alar pasi. ");
INSERT INTO lbb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pa i dun usa lanigo, pa i abit kas ana rakai, sur ir oroi e Iesu, anasa ir han bolos ting na ngas ning. ");
INSERT INTO lbb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ning e Iesu i hanot tingia, i tadai usaot na rakai, pa i atongi tana mang, “Sakias, ur purum kapit ute. Anone ar kes taum hom ting na rumai ngasim.” ");
INSERT INTO lbb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pa i purum kapit, pa i ben pas e Iesu uting na rumai ngasna ana gasgas. ");
INSERT INTO lbb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ning a tarai rop la oroi, la ururai mang, “A barsan ne i han sur ir kes taum ana tena laulau ting na nuna rumai.” ");
INSERT INTO lbb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","E Sakias i tur pa i atongi tana Leklek mang, “Oroi, Leklek, ning a tuk ana nuk a gongon, ar tabar a kapan a taraila ono, pa ning ia kar asongo pas ta utna tana tik, ar mundiat na kelesi teteki.” ");
INSERT INTO lbb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pa e Iesu i atongi ta e Sakias mang, “Ono otne, e God i alaun la ning la kes te na rumai ne, anasa e Sakias otleng mitingia na mangis a tarai ane Abaram. ");
INSERT INTO lbb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Anasa a Nat a Barsan i hanot sur ir tai sur la ning la rongo pa ir alaun pas la.” ");
INSERT INTO lbb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A tarai la longor a warwarala ne, pa la nuki mang a matanitu ane God ir hanot kapit, anasa e Iesu ka milau e Jerusalem. Pa i atong otleng ning a warwara larlar ");
INSERT INTO lbb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","mang, “Ning a ningnigo ka sang sur ir han uting na hanua kaning bakbak, sur dir malmaling tari sur ir king, pa lamur ir ulak. ");
INSERT INTO lbb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lanigo ana nuna tinan, i kabah pas anuna ning a bonot a tena titol oros teteki pa i saran tar taktakai tuk a mani tanla, pa i atongi mang, ‘Mulor aitna i, tuk ning ar ulak.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ika a taraila miting na nuna hanua la ngeti, pa la sune sen dingla na tarai sur lar muri, pa la atongi mang, ‘Bel mila mang sur a barsan ne ir king anumila i.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ning di ka akes tari sur ir king, i ulak. I arsune sur anuna tena titol orosla ning i saran tar a mani tanla, sur ir tasman asaning ka hanot ana anunla a titol ana mani. ");
INSERT INTO lbb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pa ningnigona i han teteki pa i atongi mang, ‘Leklek, anum a mani ia ka tol tar ning a bonot saot onoi.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A leklek i atongi tana mang, ‘Wakak kol, u a wakak a tena titol oros! Ar suah tar u sur ur ningnigo ana ning a bonot a tatatnan hanua, anasa u momol ana natar a utna.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pa munaurna i han teteki pa i atongi mang, ‘Leklek, anum a mani ia ka tol tar dilima saot onoi.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pa leklek i atongi tana mang, ‘U otleng ur ningnigo ana dilima na tatatnan hanua.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ning a tena titol oros kale i han teteki pa i atongi tana mang, ‘Leklek, anum a mani kane ulak ma, a poroi tari ana kaen pa suah wakak tari. ");
INSERT INTO lbb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A matatan u, anasa u a tena ngalngaliah. U los a utna ning bel anumi, pa u sol a utna ning bel u oman tari.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A leklek i atongi tana mang, ‘U a laulau a tena titol oros, ar warkurai u arlar ana num a warwara ot. U ka tasmani mang iau a tena ngalngaliah. A los a utna ning bel anuki, pa sol a utna ning bel a oman tari. ");
INSERT INTO lbb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Sur asaning bel u suah tar anuk a mani ting na beng sur ning ar hanot, ar kibas pas anuk a mani pa ta tuk otleng saot ono?’ ");
INSERT INTO lbb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Lamur i atongi tanla ning la tur tingia mang, ‘Mulor los sen a mani kusuni, pa mulor sarani tetek esaning anuna ning a bonot.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pa la atongi tana mang, ‘Leklek, anuna ning a bonot a mani kaning ma.’ ");
INSERT INTO lbb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","I keles la mang, ‘A atongi tamulo, esining i tong akes a galis, dir tabar ulaki ana galis. Ika esining bel i tong akes ta utna, dir kepsen otleng anuna siklik utna kusuni. ");
INSERT INTO lbb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“‘Ika mulor ben pas anuk a hiruala ning bel la mang sur ar king anunla, pa mulor umkol la ot te na matak.’” ");
INSERT INTO lbb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ning e Iesu ka atong tar a warwara larlar ne, i nigo usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ning i han milau e Betpage pa e Betani ting na mangir di atongi a Mangir Oliw, i sune naur miting na kakak a asaerla, ana warwara mang, ");
INSERT INTO lbb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mur han uting na hanua kaning lanigo tamu. Ning mur han kas, mur han tar ana ning a barman a dongki kaning di dot akes tari, belot tik i kes tar ono. Mur pak seni pa mur beni ute. ");
INSERT INTO lbb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ning tik ir deken mu mang, ‘Asaning mu paki suri?’ mur atongi mang, ‘A Leklek i mang suri.’” ");
INSERT INTO lbb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dia han pa dia pastek pas a ututnala rop ning e Iesu ka atong tari tandiau. ");
INSERT INTO lbb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ning dia pak a barman a dongki la ning anunla, la deken diau mang, “Asaning mu pak sen a barman a dongki ning suri?” ");
INSERT INTO lbb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dia keles la mang, “A Leklek i mang suri.” ");
INSERT INTO lbb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pa dia ben pas a barman a dongki tetek e Iesu, pa dia kepsen anundiau naur a saket, pa dia suahi saot na palai a dongki pa dia akes tar e Iesu saot onoi. ");
INSERT INTO lbb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ning i han amon, dingla na tarai la sagen anunla na saket ting na ngas. ");
INSERT INTO lbb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ning ka milau a ngas ning i sel purum ana Mangir Oliw, a tnan gasgas i los a tarai a asaerla rop pa la rakan aleklek pas e God ana tnan elngenla ana ututnala na kulkulan ning la ka oroi pa la kukuk mang, ");
INSERT INTO lbb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“A king ning i hanot ana risan a Leklek i angis! A balmolmol saot na langit, pa matatar saot tetek e God!” ");
INSERT INTO lbb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dingla na Parisaio ting na kunum a tarai la atongi mang, “Tena Asaer, ur sairas anum a tarai a asaer.” ");
INSERT INTO lbb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pa e Iesu i keles la mang, “A atongi tamulo, ning a taraila ne bel lar kukuk, a hatatla ot lar kukuk.” ");
INSERT INTO lbb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ning e Iesu i han milau e Jerusalem i oroi i, pa i tangis suri, pa i atongi, ");
INSERT INTO lbb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“A mang sur mulor tasman a ngas ning ir to pas a balmolmol onone. Ika i mumun kusun mulo! ");
INSERT INTO lbb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta pukakiar ir hanot, pa anumulo na hirua lar tur talilis anumulo a hanua, lar atur a woroh talilis alar mulo, lar tur alar anumulo na ngas a kaskas pa purpurum, pa lar um mulo kusun a risrisnala. ");
INSERT INTO lbb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pa lar regen gingini sen a rumrumai, pa lar umkol mulo taum ana natnatumulo otleng ning mulo kes tingia. Pa bel lar noren sen tar ta hat ir borbor saot on ta hat, anasa bel mulo tasman lalan a taim ning e God ka hanot tetek mulo.” ");
INSERT INTO lbb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","E Iesu i kas uting na woroh na rumai artabar, pa i lu purum sen la ning la sisiurai. ");
INSERT INTO lbb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Pa i atongi tanla mang, “Di ka tumus tari ting na Buk Tabu mang, ‘Dir atong anuk a rumai ana rumai a niaring.’ Ika mulo ka tol lingir pasi sur ir arlar ana ‘pukna na mumun ana tena kinkinaula.’” ");
INSERT INTO lbb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","E Iesu i asaer a tarai ting na rumai artabar ana pukakiarla rop. Ika a leklek a tena artabarla tetek e God, pa tena asaerla tagun a warkurai pa ningnigo anuna taraila, la nuknuk sur ta ngas ning lar umkoli ono. ");
INSERT INTO lbb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ika la nuknuk panai tar sur ta utna ning lar toli, anasa a taraila rop la mang kol sur a warwarala ane Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ning a pukakiar, ning e Iesu i asaer a tarai ting na woroh na rumai artabar, pa i warawai ana Wakak a Warwara, a leklek a tena artabarla tetek e God, pa tena asaerla tagun a warkurai, pa ningnigola la han teteki. ");
INSERT INTO lbb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Pa la atongi tana mang, “Ur atai mila, esi na ngas a rakrakai ning u tol a ututnala ne ono? Esi i saran a rakrakai ne tam?” ");
INSERT INTO lbb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","E Iesu i keles la mang, “Iau otleng ar deken mulo ana ning a kabah. Mulor atai iau. ");
INSERT INTO lbb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Mitaha a rakrakai ning e Jon i baptais a tarai ono? Misaot na langit, o tana tarai ka?” ");
INSERT INTO lbb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pa la warwara artalai tanla mang, “Ning dalar atongi mang, ‘Misaot na langit,’ ir keles dala ka mang, ‘Sur asaning bel mulo tortorot onoi?’ ");
INSERT INTO lbb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ika ning dalar atongi mang, ‘Tan a tarai,’ a tarai rop lar wolot kol dala ana hatatla, anasa la tortorot oe Jon mang i a propet.” ");
INSERT INTO lbb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","La kelesi mang, “Bel mila tasmani mitaha.” ");
INSERT INTO lbb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Pa e Iesu i atongi tanla mang, “Iau otleng bel ar atai mulo ana rakrakai ning a sira tol a ututnala ne ono.” ");
INSERT INTO lbb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","E Iesu i atong a warwara larlar ne tetek a tarai, “Ning a barsan i oman tar a barim a wain, pa lamur i sarani kaba tana dingla na tena titol sur lar tai alari, pa i han uting na ning a hanua masik, pa i kes bongnan pasi tingia. ");
INSERT INTO lbb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ning a kalang ka sot sur dir git taum a wana wain, i sune sen ning a tena titol oros tetek a tena titolla, sur lar saran al wana wain miting na barim sur anunai otleng. Ika a tena titolla la umi, pa la sune ulak oros seni. ");
INSERT INTO lbb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","I sune ulak ning a tena titol oros tetek la, pa la umi otleng, la ame tari, pa la sune ulak oros seni. ");
INSERT INTO lbb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lamur i sune a munatol a tena titol oros, la um laulau tari, pa la kepsen seni. ");
INSERT INTO lbb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pa taman a barim a wain i atongi mang, ‘Asa ma ning ar toli? Ar sune sen a natuklik, ning a katnani, ngandek lar hanrawai i.’ ");
INSERT INTO lbb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ika ning a tena titolla la oroi pasi, la warwara taum mang, ‘Esaning ir keles e tamana, i ma ine ot. Dalar umkoli, sur anundalai ma a barim a wain.’ ");
INSERT INTO lbb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pa la migen purum seni kusun a barim, pa la umkoli. “Asaning a taman a barim ir toli onla? ");
INSERT INTO lbb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ir hanot pa ir umkol a tena titolla, pa ir saran tar a barim tetek al tarai masik.” Ning la longor a warwara ne, la atongi mang, “Gong i hanot larne!” ");
INSERT INTO lbb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pa e Iesu i oroi la, pa i atongi mang, “Ning mulo nuki larne, asa kamkama warwara ne di ka tumus tari ting na Buk Tabu? ‘A hat ning na tena tol rumai la kepseni, i ot ning a wakak a hat kes, ning di tol a rumai saot ono.’ ");
INSERT INTO lbb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","La rop ning la punga tar ana hat ne, lar tagingini, ika esining a hat ne ir punga tar ono, ir tamire arlar ana kubus.” ");
INSERT INTO lbb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A tena asaerla tagun a warkurai pa leklek a tena artabarla tetek e God la tai sur ta ngas sur lar tong akes kapit pas e Iesu, anasa la tasmani mang i atong ka a warwara larlar ne onla. Ika la matatan a taraila. ");
INSERT INTO lbb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A tena asaerla tagun a warkurai pa leklek a tena artabarla tetek e God la ngoson murmuri, pa la sune sen dingla na tarai sur lar batnani pa lar asongo mang la a momol a taraila. Pa la kes longoroi sur ta warwara ning ir atongi sur lar tiwi ono pa lar saran tari nahai a warkurai pa rakrakai anuna ningnigo tagun a matanitu Rom. ");
INSERT INTO lbb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pa la atongi mang, “Tena Asaer, mila tasmani mang i tostos anum a warwara pa anum a asaer. Bel u purpurngis tetek a taraila, pa u asaer la ana ngas ane God ana momol. ");
INSERT INTO lbb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","I mangasa, i tostos sur dir lou a totokom tetek a Sisar o bel?” ");
INSERT INTO lbb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","E Iesu ka tasman sen anunla a asasongo, pa i atongi tanla mang, ");
INSERT INTO lbb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mulor asangan iau ana ta mani. A manar pa tumtumus ne onoi an esi?” Pa la kelesi mang, “Anuna Sisar.” ");
INSERT INTO lbb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pa i atongi tanla mang, “Asaning anuna Sisar mulor sarani tetek a Sisar, pa saning ane God mulor sarani otleng tetek e God.” ");
INSERT INTO lbb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pa bel la tolsot sur lar asobori ana matana tarai ana nuna warwarala. La kulkulan ana nuna warwara na arkeles, pa bel ma ta warwara inla. ");
INSERT INTO lbb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dingla na Sadusi, ning la sira puai ka mang bel ta lalaun ulak kusun a minat, la han tetek e Iesu, pa la dekeni mang, ");
INSERT INTO lbb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tena Asaer, e Moses i tumus tari tetek dala mang, ning ta barsan ir mat pas kusun anuna hane, pa bel ta natundiau, e tasnalik ir ben pasi pa ir taulai i, sur ir aitna tar al kakakla ana risana e tasnalik ning ka mat. ");
INSERT INTO lbb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ning a kabaitas, mais a barsan rop ka. A ningnigona i taulai, pa i mat pas kusun anuna hane, pa bel ta natundiau. ");
INSERT INTO lbb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pa murmur tana maleng i taulai a hane ning, pa i le i mat ka kusuni. ");
INSERT INTO lbb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Lamur a munatolna le. I arlar larning tetek mais la rop, la taulai i, la mat rop ka, ika a hane ning bel i agon tar ta kaklik tanla. ");
INSERT INTO lbb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pa lamur a hane otleng i mat. ");
INSERT INTO lbb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ana lalaun ulak kusun a minat, a hane ning anun esi na halinla? Anasa mais la rop la ka taulai pas onoi.” ");
INSERT INTO lbb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","E Iesu i atongi tanla mang, “A tarai tagun a raula ne la tautaulai, ");
INSERT INTO lbb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ika a tarai ning la tostos sur lar kamtur ulak kusun a minat, pa lar laun ana lalaun lamur, bel lar taulai ulak. ");
INSERT INTO lbb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pa bel lar mat ulak, anasa la arlar kama ana angelola. La na natnat e God, anasa la ka laun ot kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ning a Buk Tabu i warwara ana rakai ning i irnga, e Moses i asangani mang a minatla lar kamtur ulak, anasa i atong a Leklek mang, ‘A God ane Abaram, a God ane Aisak pa God ane Jekop.’ ");
INSERT INTO lbb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","E God bel a God ana minatla, a God anun la ning la laun, anasa la rop la laun na matana.” ");
INSERT INTO lbb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pa dingla na tena asaerla tagun a warkurai la atongi mang, “Tena Asaer, anum a warwara i wakak kol.” ");
INSERT INTO lbb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pa bel ulak ma tik i deken e Iesu ana ta kabah, anasa la matmataut. ");
INSERT INTO lbb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","E Iesu i atongi tanla, “Sur asaning di atongi mang a Karisito a nat e Dewit? ");
INSERT INTO lbb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Anasa e Dewit ot i atongi ana Saksakla ting na Buk Tabu mang, ‘A Leklek i atongi tetek anuk a Leklek, “Ur kes te na sot a kuk, ");
INSERT INTO lbb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tuk ning ar tolsot pas anum na hiruala sur lar kes nahaim.” ’ ");
INSERT INTO lbb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","E Dewit i atong a Karisito mang anuna Leklek. Manglarning, di tamana mangmangasa?” ");
INSERT INTO lbb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ning a taraila rop la longor e Iesu, i atongi tan anuna kakak a asaerla mang, ");
INSERT INTO lbb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mulor tumarang mulo kusun a tena asaerla tagun a warkurai. La mang sur lar taltal ana wakak a kaenla, pa la mang sur a tarai lar saran a tnan hanrawai tetek la ting na puknala na tinan taum. Pa la mang sur a keskes salanigo na rumai lotula, pa keskes a leklek salanigo na ngasala. ");
INSERT INTO lbb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","La sira arop a gongon ana laola, pa la sira kep la ana tol barah a niaringla. Ir itna kol a warkurai a arkeles ane God tetek la.” ");
INSERT INTO lbb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ning e Iesu i kes ting na rumai artabar, i tai tostos, pa i oroi a leklekla la migen tar anunla a artabar ting na pukna na suah mani. ");
INSERT INTO lbb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pa i oroi pas otleng ning a kapan a lao i migen tar ka naur a toia. ");
INSERT INTO lbb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pa e Iesu i atongi mang, “A atong momoli tamulo, a kapan a lao ne ka saran tar a tnan mani tanla rop ne. ");
INSERT INTO lbb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","La saran tar ka a tuk miting na tnan manila anunla, pa lao ne, i kapan, ika, ka saran arop sen asaning ir to pas anuna keskes.” ");
INSERT INTO lbb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dingla na kakak asaer la warwara ona rumai artabar mang di ka mermer tari ana wakak a hatatla pa artabarla ning di saran tari tetek e God. Ika e Iesu i atongi mang, ");
INSERT INTO lbb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“A pukakiar ir hanot lamur ning a ututnala ne ning mulo oroi la, bel ta hat ir borbor saot on ta hat, dir regen arop sen la.” ");
INSERT INTO lbb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","La deken e Iesu mang, “Tena Asaer, nangse a ututnala ne ir hanot? Pa esi na akinalang ning ir asangani mang ka milau sur lar hanot?” ");
INSERT INTO lbb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","I keles la mang, “Mulor tai alar mulo, sakana dir asongo pas mulo. Anasa a galis lar hanot ana risak, lar atongi mang, ‘Iau a Karisito,’ o, ‘A pukakiar ka milau.’ Gong mulo mur la. ");
INSERT INTO lbb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ning mulor longor a harumla pa tatatnan mamahatla, gong mulo matmataut, anasa a ututnala ne lar hanot nigo, ika belot a ararop ana rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lamur e Iesu i atongi tanla mang, “Ning a mangis a tarai ir tur na harum tetek ning a mangis a tarai, pa ning a matanitu ir tur na harum tetek ning a matanitu. ");
INSERT INTO lbb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A tatatnan mamaisla, munurak, a urmatana rakrakai a tinsaman ting na hananuala, pa urmatana ututnala misaot na bakut, ning ir amatmataut a tarai, pa tatatnan akinalangla misaot na bakut, lar hanot. ");
INSERT INTO lbb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Lanigo ning a ututnala ne belot la hanot, dir dat pas mulo, dir akadik mulo, pa dir dat mulo uting na rumai lotula sur dir warkurai mulo, pa dir akas mulo uting na karabusla. Pa mulor tur ana warkurai lanigo tana kingla, pa tatatnan ningnigola, anasa mulo anuki. ");
INSERT INTO lbb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A ututnala ne ir sapang a ngas sur mulor warwara talapor hok tetek la. ");
INSERT INTO lbb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ika lanigo tana, gong mulo nuknuk nigo sur asaning mulor warwara alar mulo onoi. ");
INSERT INTO lbb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Anasa iau ot, ar anuknuk tar a warwara pa tastasmai otleng ting na nuknukimulo, pa anumulo a hiruala rop bel lar keles sot pasi, pa bel lar puain seni. ");
INSERT INTO lbb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A tamtamamulola pa kaba tnamulola, a tastasimulola, a maimulola, pa halalimulola, lar saran sen mulo sur dir umkol al tarai omulo. ");
INSERT INTO lbb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A taraila rop lar nget mulo anasa mulo anuki. ");
INSERT INTO lbb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ika e God ir tai alar mulo. ");
INSERT INTO lbb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ning mulor tur rakrakai mulor kibas a lalaun. ");
INSERT INTO lbb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ning mulor oroi a kunum a tarai a harum lar tur talilis pas e Jerusalem, mulor tasmani mang ka milau sur dir kamar seni. ");
INSERT INTO lbb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","La ning la kes ting na papar Judia, lar liu kumna usaot na mangirla, pa la ning la kes saot e Jerusalem lar purum, pa la ning la kes sa na bual gong ulak ma la kas. ");
INSERT INTO lbb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Anasa a pukakiarla ning, a pukakiarla na arkeles sur e God ir tolsot pas a ututnala rop ning di ka tumus tari ting na Buk Tabu. ");
INSERT INTO lbb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ana pukakiarla ning, ir laulau kol tetek a tiananla, pa la otleng ning la aresus. A tnan kankan ir hanot ana hanua Israel, pa balakut ane God ir han tar ana tarai ne. ");
INSERT INTO lbb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Al tarai dir umkol la ana liwan a harum, pa al tarai dir ben pas la sur lar karabus ting na hananuala rop. Pa la ning bel a tarai Juda lar pas ahat e Jerusalem tuk ana pukakiar ning e God ka asilang tari sur anunla keskes a ningnigo ir rop ono. ");
INSERT INTO lbb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“A akinalangla saot na kamis, pa kalang, pa nangnangla ir hanot. Pa te lapiu a tarai miting na matanitula lar laulau ana matmataut pa nuknukinla ir talar ana top ning ir harum pa tinangisna otleng. ");
INSERT INTO lbb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A tarai lar mat palpal ana matmataut ana ututnala ning ir um a rakrakan hanua, anasa a ututnala saot na bakut lar maler. ");
INSERT INTO lbb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ana pukakiar ning, lar oroi a Nat a Barsan ir hanot ana diah bakut, ana rakrakai pa tnan matatar. ");
INSERT INTO lbb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ning a ututnala ne ir turpasi sur ir hanot, mulor tur, pa mulor tadai, anasa a pukakiar ning e God ir alaun pas mulo ono ka milau.” ");
INSERT INTO lbb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","E Iesu i atong a warwara larlar ne tanla mang, “Mulo tasman ot a rakai a fig pa rakaila rop. ");
INSERT INTO lbb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ning mulo oroi a pakpakanla ir sibul ot ulak, mulo ka tasmani mang a kalangla na laplapang ka milau. ");
INSERT INTO lbb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Larotleng ning, ning mulor oroi a ututnala ning ia ka warwara tar ono ir hanot, mulor tasmani mang a matanitu ane God ka milau. ");
INSERT INTO lbb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A atong momoli tamulo, a tarai tagun onone belot lar mat pa ututnala rop ne ir hanot. ");
INSERT INTO lbb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A langit pa rakrakan hanua diar rop, ika anuk a warwarala bel ir rarop. ");
INSERT INTO lbb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mulor tai alar mulo, sakana mulor molot ana tol ngasa pa sipak, pa nuknuk kol ana ututnala ana lalaun te lapiu, pa pukakiar ning ir hanot tetek mulo arlar ana kun ning ir akulkulan mulo. ");
INSERT INTO lbb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Anasa ir hanot tetek a taraila rop te na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mulor tai alar mulo ana pukakiarla rop, mulor araring sur mulor rakrakai sur mulor alah kusun a ututnala ne, ning milau lar hanot, pa mulor araring otleng sur mulor tolsot pasi sur mulor tur ana matana Nat a Barsan.” ");
INSERT INTO lbb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pa e Iesu i sira asaer a tarai ting na rumai artabar ana pukakiarla rop, pa ana pukakiarla ana morom i sira purum, pa i kes ting na mangir, a risana Oliw. ");
INSERT INTO lbb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pa ana pukakiarla ana kobot ning ot, a taraila rop la sira han teteki ting na rumai artabar sur lar longori. ");
INSERT INTO lbb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ka milau a lotu na bret ning bel al is ono, di atongi ana lotu na Han Lakai. ");
INSERT INTO lbb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pa leklek a tena artabarla tetek e God, pa tena asaerla tagun a warkurai, la nuknuk sur ta ngas sur lar um kumnan e Iesu ono, anasa la matatan a tarai. ");
INSERT INTO lbb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pa e Satan i kas tar oe Judas, ning a risana otleng e Iskariot, i ning a halin ning a bonot pa pisir naur a kakak a asaer. ");
INSERT INTO lbb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","I han tetek a leklek a tena artabarla tetek e God, pa ningnigola ana tena tai alarla ting na rumai artabar, pa la warwara taum onoi sur ir asobor mangmangasa tar e Iesu tetek la. ");
INSERT INTO lbb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","La gas, pa la atongi mang lar lowi. ");
INSERT INTO lbb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","E Judas i malmaling, pa i nuknuk sur ta wakak a pukakiar ning bel al galis a tarai, sur ir saran tar e Iesu uting na kunla. ");
INSERT INTO lbb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","A pukakiar a lotu na bret ning bel al is ono i hanot, ning di sira umkol a barman a sipsip sur a lotu na Han Lakai. ");
INSERT INTO lbb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pa e Iesu i sune sen e Pita pa e Jon pa i atongi tandiau mang, “Mur han pa mur sang andala utna na hangan sur a lotu na Han Lakai.” ");
INSERT INTO lbb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pa dia dekeni mang, “U mang sur miar sangi taha?” ");
INSERT INTO lbb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","I keles diau mang, “Ning mur hanot saot e Jerusalem, ning a barsan i los a tnan koto na malum ir pastetek mu, pa mur muri uting na rumai ning ir kas tingia. ");
INSERT INTO lbb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pa mur atongi tetek a taman a rumai mang, ‘A Tena Asaer i atongi mang: Kanaha a tuk a rumai ning mila taum ana nuk a kakak a asaerla, milar ien a utna na Han Lakai tingia?’ ");
INSERT INTO lbb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pa ir asangan tar mu ana tnan tuk a rumai saot, ning di ka sang tari, pa mur sang a ututnala tingia.” ");
INSERT INTO lbb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dia han, pa dia pastek rop ot a ututnala ning e Iesu ka atong tari tandiau. Pa dia sang a ututnala na Han Lakai. ");
INSERT INTO lbb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ning a pukakiar ka sot, e Iesu pa aposella la kes ana utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pa e Iesu i atongi tanla mang, “A mang kol sur ar ien a utna na Han Lakai taum omulo ning belot a kilang a kankan, ");
INSERT INTO lbb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","anasa a atongi tamulo mang, bel ar ien ulak ta utna na Han Lakai tuk ana pukakiar ning dir tolsot pasi ana matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","E Iesu i los pas a kap pa i atong wakak pas ono, pa i atongi tanla, “Mulor los pas a kap ne, pa mulor gang sauran pasi. ");
INSERT INTO lbb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Anasa a atongi tamulo mang, bel ar gang ulak al wain, tuk ning a matanitu ane God ir hanot.” ");
INSERT INTO lbb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pa i los pas a bret, i atong wakak onoi, i kibiki, pa i tabar la ono. I atongi mang, “Ine a palaok, a sarani sur mulo. Mulor toli larne, sur mulor sira nuk pas iau.” ");
INSERT INTO lbb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lar otleng ning, lamur ning ka rop a utna na hangan, i los pas a kap pa i atongi mang, “A kap ne, a tona kunubus, ana sulukik ning ir tapek omulo. ");
INSERT INTO lbb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ika a kuna esaning ir asobor tar iau, kane mia lolos taum ana logo na utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A Nat a Barsan ir mat arlar larning e God ka warkurai tari, ika ir laulau kol tetek a barsan ning ir saran tari tetek a hiruala.” ");
INSERT INTO lbb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pa la deken artalai la mang, “Esi na halindala ir tol a utna ne?” ");
INSERT INTO lbb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","La arlak mang esi na halinla dir atongi mang i leklek kol. ");
INSERT INTO lbb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pa e Iesu i atongi tanla mang, “A kingla anun la ning bel a tarai Juda, la warkurai a tarai pa la oroi purpurum la. Pa anunla ningnigola ot ulak la atong la a wakak a tena arnangaila. ");
INSERT INTO lbb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ika mulo, gong mulo manglarne. Esining i leklek tamulo ir arlar ka o esaning i natarna, pa esining i ningnigo ir arlar ka ana tena titol oros. ");
INSERT INTO lbb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Esining i leklek ta diau? Esaning i kes ana utna na hangan, o esaning i longor mut? I ot ning i kes ana utna na hangan, gepi? Ika iau, a kes ting na arpotor imulo arlar o esaning i sira longor mut. ");
INSERT INTO lbb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ika mulo, mulo tur taum hok ana mamahatla ning i hanot tetek iau. ");
INSERT INTO lbb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pa ar saran tar a keskes a king tamulo, arlar oe Tata i saran tari tak, ");
INSERT INTO lbb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","sur dalar hangan pa dalar gang ana nuk a logo ana nuk a matanitu. Pa mulor kes ana keskesla na king, pa mulor warkurai ning a bonot pa pisir naur a mangis a tarai Israel.” ");
INSERT INTO lbb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","E Iesu i atongi mang, “Saimon, Saimon, oroi i, e Satan ka nunung pas sur ir lar mulo, arlar ana tena omomai ning i tang sauran a wit kusun a palpalna. ");
INSERT INTO lbb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ika ia ka araring hom, Saimon, sur gong anum a tortorot i punga kol. Ning u ka lingir ulak a nuknukim, ur arakrakai na tastasimla.” ");
INSERT INTO lbb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","E Pita i atongi tana mang, “Leklek, bel a matmataut ning ar mur u uting na karabus pa ana minat.” ");
INSERT INTO lbb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pa e Iesu i kelesi mange, “Pita, a atongi tam, onone ning a kakaruk belot ir kurkurirakuk ur puai munatol mang bel u tasman iau.” ");
INSERT INTO lbb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Lamur e Iesu i deken anuna kakak a asaerla mang, “Ning a sune sen mulo, pa bel anumulo ta paus a suah mani o ta rat o ta su, i mangasa, mulo kapan ot sur ta utna?” Pa la kelesi mang, “Bel.” ");
INSERT INTO lbb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pa e Iesu i atongi tanla, “Ika onone, esining anuna ta paus a suah mani, i wakak ning ir losi ot, pa rat otleng. Pa esining bel ta liwan a harum, i wakak ning ir siuran sen anuna ta kaen pa ir lou pas tik. ");
INSERT INTO lbb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","A atongi tamulo, dir tolsot pas a tumtumus ne hok, ‘Di atong taum la ana tena laulaula.’ Anasa a ututnala ne di ka tumus tari hok, milau dir tolsot pasi.” ");
INSERT INTO lbb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pa kakak a asaerla la atongi mang, “Oroi i, Leklek, naur a liwan a harum kanet.” Pa e Iesu i keles la mang, “I sot ka.” ");
INSERT INTO lbb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","E Iesu i purum kusun a hanua, pa i han usaot na Mangir Oliw, arlar ot larning i sira toli. Pa kakak a asaerla la muri. ");
INSERT INTO lbb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ning la hanot ting na pukna ning, i atongi tanla mang, “Mulor araring, sur gong mulo punga ana larlarla.” ");
INSERT INTO lbb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","I han siklik tar kusun la, i tur ana bokona hana, pa i araring mang, ");
INSERT INTO lbb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tata, ning u mang, ur kibas sen a kap a mamahat ne kusun iau. Ika gong u mur a nuknukik, ur mur ot a nuknukim.” ");
INSERT INTO lbb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ning a angelo misaot na langit i hanot teteki pa i arakrakai i. ");
INSERT INTO lbb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","I araring rakrakai kol, anasa i kilang a rakrakai a balmaris kol, pa maragusna i arlar ana tutu na suluk i punga purum ting na piu. ");
INSERT INTO lbb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ning ka araring rop, i kamtur pa i han ulak tetek a kakak a asaerla, pa i oroi la ning la ka borbor duman, anasa a palaonla i ngol ana balmaris. ");
INSERT INTO lbb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pa i atongi tanla mang, “Sur asaning mulo borbor duman ka? Mulo kamtur, pa mulor araring sur gong mulo punga ana larlarla.” ");
INSERT INTO lbb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ning e Iesu kaning ot i warwara, a kunum a tarai la hanot. Pa e Judas, ning a halin ning a bonot pa pisir naur a kakak a asaer, i nigon pas la. I han tetek e Iesu sur ir goro a ris a pahana. ");
INSERT INTO lbb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ika e Iesu i dekeni mang, “Judas, i mangasa, u ka asobor tar a Nat a Barsan ana argoro?” ");
INSERT INTO lbb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ning a tarai ning la han taum oe Iesu la oroi a ututnala ne ir hanot, la dekeni mang, “Leklek, u mang sur milar harum ana liwanla a harum?” ");
INSERT INTO lbb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pa ning a halinla i umsem a talngana tena titol oros anuna ningnigo na tena artabar tetek e God. ");
INSERT INTO lbb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ika e Iesu i sairasi mang, “Gong!” Pa i tong a talngana a tena titol oros, pa i awakak ulak pasi. ");
INSERT INTO lbb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","E Iesu i warwara tetek a leklek a tena artabarla tetek e God, pa ningnigola anuna tena tai alarla miting na rumai artabar, pa ningnigola ana taraila ning la hanot suri. I atongi mange, “I mangasa, ngandek iau a tena harum pa tena kinkinau, sur i ma ine mulo hanot ana liwanla na harum pa puka buturla sur mulor tong akes iau? ");
INSERT INTO lbb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ana pukakiarla rop dala sira kes taum ting na woroh na rumai artabar pa bel mulo tong akes iau. Ika ine anumulo a pukakiar, ning a rakrakai ana mormorom i nigon mulo.” ");
INSERT INTO lbb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","La tong akes pas e Iesu, pa la ben maskan seni. La beni uting na rumai anuna ningnigo na tena artabar tetek e God. Pa e Pita i mur amon e Iesu, ika i bakbak ot kusuni. ");
INSERT INTO lbb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ning la ka atna tar a iah ting na arpotor a pukna tumo lapiu, pa la kes taum, e Pita otleng i kes taum ot onla. ");
INSERT INTO lbb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ning a basbas, a tena titol oros, i oroi pasi ning i kes tar milau a irnga na iah, pa i ngoson rakrakai i, pa i atongi mang, “A barsan ne dia sira armuri taum otleng oe Iesu.” ");
INSERT INTO lbb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ika e Pita i puai mang, “Lak, bel a tasman e Iesu.” ");
INSERT INTO lbb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lamur kale, ning a barsan male i oroi pas e Pita pa i atongi mang, “U otleng mulo.” Ika e Pita i kelesi mang, “Barsan, iau bel.” ");
INSERT INTO lbb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lamur, ning ulak i warwara rakrakai, i atongi mang, “I momol ot, a barsan ne dia sira armuri taum ot oe Iesu, anasa i a te Galili.” ");
INSERT INTO lbb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","E Pita i kelesi mang, “Barsan, bel a tasman asaning u warwara ono.” Ning kaning ot i warwara, a kakaruk i kurkurirakuk. ");
INSERT INTO lbb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A Leklek i talingir, i tai tostos tetek e Pita, pa e Pita i nuk pas a warwara anuna Leklek ning ka atong tari tana mang, “Onone, ning a kakaruk belot ir kurkurirakuk ur puai munatol mang bel u tasman iau.” ");
INSERT INTO lbb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pa i purum kusun a pukna ning, pa i tangis koli. ");
INSERT INTO lbb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","La ning la tai alar e Iesu, la morot laulau ono, pa la mirasi. ");
INSERT INTO lbb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","La poroi alar tar a matana, pa la atongi tana mang, “U a propet, atai mila. Esi i dapis u?” ");
INSERT INTO lbb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pa la atong saksakani ana galis a warwara otleng. ");
INSERT INTO lbb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ana kabakiar kobot, a ningnigola anuna tarai, a leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai la han taum. Pa la ben pas e Iesu tetek a tarai a kiwung ning, ");
INSERT INTO lbb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","pa la atongi tana mang, “Ning u a Karisito, ur atai mila.” Pa e Iesu i keles la mang, “Ning ar atai mulo, bel mulor tortorot ana nuk a warwara. ");
INSERT INTO lbb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pa ning ar deken mulo ana ta deke, bel mulor kelesi. ");
INSERT INTO lbb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ika, turpasi onone, a Nat a Barsan ir kes ting na ris a sot a kuna e God, esaning i rakrakai kol.” ");
INSERT INTO lbb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pa la rop la deken e Iesu mang, “U a Nat e God gepi?” Pa i keles la mang, “Mulo ka atong sot pasi, iau ot ne.” ");
INSERT INTO lbb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Lamur la atongi mang, “Sur asaning dalar mang ulak sur al warwara na artitiu? Anasa dala ka longor tar anuna warwarala ne, ning dalar tiwi ono.” ");
INSERT INTO lbb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lamur a tarai a kiwung rop la tur, pa la ben pas e Iesu tetek e Pailat. ");
INSERT INTO lbb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pa la turpasi sur lar tiwi mang, “Mila oroi a barsan ne i ben rongon anumila na tarai, i sairas mila sur gong mila saran a totokomla tetek a Sisar, pa i atongi otleng mang ai a Karisito, a king.” ");
INSERT INTO lbb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","E Pailat i dekeni mang, “U a King anuna tarai Juda?” Pa e Iesu i kelesi mang, “I ot ning u atongi.” ");
INSERT INTO lbb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","E Pailat i atongi tana leklek a tena artabarla tetek e God pa kunum a tarai mang, “Bel a deke tetek ta toltol ning a barsan ne i rongo ono.” ");
INSERT INTO lbb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ika la ngongos ka mang, “I akamtur a balan a tarai sur lar kutus a warkurai anuna matanitu, ana nuna asaer ting na papar Judia rop. I turpasi saot e Galili pa i tuk te.” ");
INSERT INTO lbb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ning e Pailat i longori, i deken la oe Iesu mang, “Ai a te Galili?” ");
INSERT INTO lbb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ning ka tasmani mang e Iesu mitisa na papar Galili ning e Herot i ningnigo tingia, i sune seni teteki. Ana pukakiar ning e Herot otleng i kes tisaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ning e Herot i oroi pas e Iesu, i gas kol, anasa tagun lanigo ot i mang sur ir oroi i, anasa ka longor tar a warwara ono, pa i mang sur ir oroi ta utna na kulkulan ning ir toli. ");
INSERT INTO lbb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","E Herot i deken e Iesu ana galis a kabah, ika e Iesu bel i kelesi. ");
INSERT INTO lbb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A leklek a tena artabarla tetek e God pa tena asaerla tagun a warkurai kaning la tur tingia, la tiu rakrakai e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","E Herot pa anuna tarai a harum la morot laulau ono, pa la malani, la mer tari ana wakak a kaen kol, pa la sune sen ulaki tetek e Pailat. ");
INSERT INTO lbb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lanigo e Herot pa e Pailat bel dia armoro taum, ika ana pukakiar ning dia bot armoro. ");
INSERT INTO lbb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","E Pailat i kabah taum pas a leklek a tena artabarla tetek e God, pa ningnigola, pa tarai, ");
INSERT INTO lbb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","pa i atongi tanla mang, “Mulo ka ben tar a barsan ne tetek iau, arlar o esaning i ben rongon a taraila. Pa ia ka deken tari na matamulo, pa bel a deke tetek pas ta toltol ning a barsan ne i rongo ono. ");
INSERT INTO lbb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","E Herot otleng bel i pastek pas ta toltol ono, pa i sune sen ulaki ka tetek dala. Oroi i, bel i tol tar ta utna ning ir hirua ono. ");
INSERT INTO lbb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ar dapis tari ka, pa ar pak seni.” ");
INSERT INTO lbb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pa taraila rop la kukuk ana tnan elngenla mang, “A barsan ne ir hirua, pa ur pak sen tar e Barabas tetek mila.” ");
INSERT INTO lbb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","E Barabas i ning a barsan ning di akas tari uting na karabus anasa i harum ana matanitu saot na hanua Jerusalem, pa i sira umkol a taraila otleng. ");
INSERT INTO lbb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","E Pailat i deken ulak la, anasa i mang sur ir pak sen e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ika la kukuk rakrakai ka mang, “Sai ahati saot na rakai kutus! Sai ahati saot na rakai kutus!” ");
INSERT INTO lbb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pa i munatol na deken la mang, “Sur asa? Esi na rongo ning ka tol tari? Bel a deke tetek pas ta toltol laulau ning ir hirua ono. Ar dapis tari ka, pa ar pak seni.” ");
INSERT INTO lbb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ika la kukuk ngongos ana tnan elngenla sur dir sai ahati saot na rakai kutus. Pa la tolsot pasi ot. ");
INSERT INTO lbb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pa e Pailat i malmaling kama sur dir mur a nuknukinla. ");
INSERT INTO lbb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Lamur i pak sen e Barabas ning i kes ting na karabus anasa i tur na harum tetek a matanitu pa i umkol a taraila, esaning la nunung suri. I saran tar e Iesu tetek a tena harumla arlar ana nuknuk a taraila. ");
INSERT INTO lbb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ning la ben pas e Iesu sur lar sai ahati saot na rakai kutus, la dat pas ning a te Sairini, a risana e Saimon, ning i han miting na ning a hanua sur ir han usaot e Jerusalem. Pa la los tar a rakai kutus usaot na palaina, sur ir los murmur e Iesu ono. ");
INSERT INTO lbb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A tnan kunum a taraila la mur e Iesu. Arpotor inla, a gurarala otleng, ning la balmaris pa la tangsani. ");
INSERT INTO lbb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","E Iesu i talingir pa i atongi tanla mang, “A gurara Jerusalem, gong mulo tangsan iau, mulor tangsan mulo ot taum ana natnatumulola. ");
INSERT INTO lbb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Anasa a pukakiarla ana kankan ir hanot tetek mulo pa mulor atongi mang, ‘A pombo na gurarala, ning bel la agon pa bel la asus al kakakla, la angis.’ ");
INSERT INTO lbb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lamur ‘lar atongi tetek a mangirla, “Mulor punga tar omila!” pa tetek na puka leklek, “Mulor pol alar mila!” ’ ");
INSERT INTO lbb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ning lar tol a ututnala ne, ning a rakai kaning ot i laun, asa lar toli ning a rakai ka marang?” ");
INSERT INTO lbb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pa naur otleng, naur a laulau a barsan, di ben taum diau oe Iesu sur ditol ir hirua taum. ");
INSERT INTO lbb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ning la hanot ting na pukna di atongi “A Lasa na Pukulundi,” la sai ahat e Iesu saot na rakai kutus tingia, pa naur a laulau a barsan otleng, ning a halindiau ting na sot, pa takai ting na kair. ");
INSERT INTO lbb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","E Iesu i atongi mang, “Tata, ur kepsen anunla na toltol laulau, anasa bel la tasman asaning la toli.” Pa la pilai laki sur lar asalar anuna kaenla tetek la taktakai. ");
INSERT INTO lbb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A taraila la tur pa la oroi i, pa ningnigola la morot laulau oe Iesu, la atongi mang, “I alaun pas a tarai masik. Ning ai a Karisito ane God, ning e God ka aslang tari, i wakak ning ir alaun pasi ot.” ");
INSERT INTO lbb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pa tena harumla otleng la morot laulau onoi. La han teteki, la saran tar a wain ning i mititir tana, ");
INSERT INTO lbb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","pa la atongi, “Ning u a king anuna tarai Juda, onone ur alaun pas u ot.” ");
INSERT INTO lbb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Di tumus tar otleng a tumtumus saot na palai a rakai kutus mang, ");
INSERT INTO lbb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ning tagun naur a barsan laulau ning di akulam taum tar ditol, i morot oe Iesu mang, “Ning u a Karisito, ur alaun pas u pa miau!” ");
INSERT INTO lbb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pa ning a halindiau i balakut teteki pa i atongi mang, “I mangasa, u bel u matmataut sur e God? Anasa u otleng datol rop datol kilang ning a ngas a kankan ka. ");
INSERT INTO lbb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","I tostos ot ondau, anasa di keles anundau a toltol laulau. Ika a barsan ne bel i tol ta toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lamur i atongi ta e Iesu, “Iesu, nuk pas iau, ning ur king ana num a matanitu.” ");
INSERT INTO lbb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pa i kelesi mang, “A atong momoli tam, ono otne ur kes taum hok saot na Paradais.” ");
INSERT INTO lbb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ning ka matana kamis tostos, a hananua rop i mormorom tuk ana 3 kilok ana rah, ");
INSERT INTO lbb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","anasa a kamis bel i sasai. Pa kaen a alalar kutus tingui na rumai artabar i taksilir potor sur naur a dihna. ");
INSERT INTO lbb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","E Iesu i kukuk rakrakai mang, “Tata a saran tar a inguk uting na naur a kum.” Ning ka atong tari larning, i suah sen a malwasna. ");
INSERT INTO lbb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ning a ningnigo anuna tena harumla i oroi asaning i hanot, i rakan aleklek pas e God mang, “I momol ot, a barsan ne a tena tostos.” ");
INSERT INTO lbb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A kunum a taraila ning kaning la tur taum sur lar oroi a utna ne, ning la oroi i, la dapdapis a malwasinla ana balmaris pa la han. ");
INSERT INTO lbb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ika na halalna e Iesu, pa gurarala ning la muri mitumo e Galili, la tur bakbak tar ot, pa la oroi a ututnala ne. ");
INSERT INTO lbb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ning a barsan, a risana e Josep, mitumo e Arimatia, ting na papar Judia. I ning a wakak a barsan, pa tena tostos, ning i harnanai sur a matanitu ane God. I ning a halin a tarai a kiwung, ika bel i malmaling taum onla ana nunla a warkurai pa utna ning la toli. ");
INSERT INTO lbb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I han tetek e Pailat pa i nunung sur a minat e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","I los purum pasi, i irisi ana wakak a kaen, pa i aborbor tari ting na kulam a minat ning di ka kot tari ting na ris a hat, ning belot di aborbor tar ta minat tingia. ");
INSERT INTO lbb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A pukakiar ning, a pukakiar a sang, pa milau a Pukakiar Sabat ir turpasi. ");
INSERT INTO lbb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pa gurarala ning la han taum oe Iesu mitumo e Galili, la mur e Josep, pa la oroi tar a kulam a minat pa ngas a aborbor ning di toli ana minat e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ning la ulak, la sang pas a ututnala ning i tomtoboh wakak pa wel ning i tomtoboh otleng. Pa ana Pukakiar Sabat, la manah arlar ot ana warkurai. ");
INSERT INTO lbb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ana kobot ning ot, ana ningnigo na pukakiar ana wik, a gurarala la han uting na kulam a minat, pa la los a ututnala ning i tomtoboh ning la ka sang tari. ");
INSERT INTO lbb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pa la oroi i ning di ka lakir sen tar a hat kusun a taman a kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","La kas, ika bel ma la oroi a minat a Leklek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ning a nuknukinla i loklokron onoi, naur a barsan, anundiau naur a kaen i pil kol, dia hanot kulkulan tetek la. ");
INSERT INTO lbb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","La matmataut pa la kes tudu, la suah purum a patarinla ting na piu. Dia atongi tanla, “Sur asaning mulo tai sur a lalauna te napir a minatla? ");
INSERT INTO lbb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Bel i ma te, ka kamtur ulak. Mulor nuk pas a warwara ning ka atong tari tamulo, ning i kes ot tumo e Galili. ");
INSERT INTO lbb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","I atong tari mang, ‘Dir saran tar a Nat a Barsan ting na kuna laulau a tarai, pa dir sai ahati saot na rakai kutus, pa ana natol a pukakiar lamur ir kamtur ulak.’” ");
INSERT INTO lbb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pa la nuk pas a warwara ane Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ning la ulak kusun a kulam a minat, la atatai ana ututnala rop ne tetek ning a bonot pa pisir takai a kakak a asaerla pa tetek la rop otleng ning la sira mur e Iesu. ");
INSERT INTO lbb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A gurarala ning la atai a aposella ana ututnala ne, la ne: E Maria Makdalen, e Joana, pa e Maria e tana e Jems, pa dingla na gurara otleng ning la han taum onditol. ");
INSERT INTO lbb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ika a aposella la longor a warwara ana gurarala arlar ana warwara oros ka, pa bel la tortorot onla. ");
INSERT INTO lbb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ika e Pita i tur, i dun sur a kulam a minat. I roh purum, pa i sidok pa i oroi a kaenla kama, la borbor masik tar. Pa i ulak, pa i nuknuk kol ana utna ne i hanot. ");
INSERT INTO lbb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ana pukakiar ot ning, naur onla ning la sira mur e Iesu, dia han uting na hanua a risana e Imaus. A barah ana ngas ning i arlar ana ning a bonot pa pisir takai a kilomita misaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ning dia han amon dia warwara ana ututnala rop ne ka hanot. ");
INSERT INTO lbb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ning dia warwara, pa dia deken artalai diau, e Iesu ot i hanot tetek diau, pa ditol han taum. ");
INSERT INTO lbb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ika ning a utna i poroi alar pas a matandiau pa bel dia oroi lalan pasi. ");
INSERT INTO lbb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","E Iesu i deken diau mang, “Asaning mu warwara amon ono ting na numu a tinan?” Dia tur tar ka pa dia tatatai na balmaris. ");
INSERT INTO lbb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pa ning a halindiau a risana e Kliopas, i dekeni mang, “Ngandek u ka ning a wasira saot e Jerusalem, ning bel u tasman a ututnala ning i hanot saot ana pukakiarla ne?” ");
INSERT INTO lbb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Pa i deken diau, “A ututnala na sa?” Pa dia kelesi mang, “A ututnala oe Iesu a te Nasaret, a propet, ning i asangani mang i rakrakai ana nuna titolla pa anuna warwarala otleng, ana matana e God pa taraila rop. ");
INSERT INTO lbb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","A leklek a tena artabarla tetek e God pa anundala ningnigola la saran tari ana warkurai sur ir mat, pa di sai ahati saot na rakai kutus. ");
INSERT INTO lbb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mila tortorot ono mang i ning ir alangolango a tarai Israel. Pa onone otleng, ka natol a pukakiar alar a ututnala ning la toli. ");
INSERT INTO lbb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ine otleng, dingla na gurara omila, la akulkulan mila. Ning la han kobot uting na kulam a minat, ");
INSERT INTO lbb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","la tatatai panai tar sur a minatna. Ning la ulak la atongi mang la oroi tar naur a angelo ana tatatai, pa dia atai la mang ka laun ulak. ");
INSERT INTO lbb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lamur dingla na tarai otleng omila, la han pas uting na kulam a minat, pa la oroi tari mang ot larning a gurarala la ka atatai ono, ika bel la oroi e Iesu.” ");
INSERT INTO lbb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pa e Iesu i atongi tandiau, “Mu longlong ka, bel mu tortorot kapit ana warwarala rop ning a propetla ka atong tari. ");
INSERT INTO lbb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","La atongi mang a Karisito ir kilang a kankanla ne, pa lamur ir kas ana nuna matatar.” ");
INSERT INTO lbb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Turpasi ana bukla ane Moses pa propetla, e Iesu i papak tetek diau ana ututnala rop di ka tumus tari onoi ot ting na Buk Tabu. ");
INSERT INTO lbb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ning ditol ka han milau a hanua ning dia han sur uting ia, e Iesu i tohoi sur ir han bolos ka. ");
INSERT INTO lbb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pa dia sairasi, dia atongi mang, “Ur kes taum omiau, anasa ka rah, a kamis ka mang ir sup ne.” I kas pa i kes taum ondiau. ");
INSERT INTO lbb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ning ditol kes sur ditol ar hangan, e Iesu i los pas a bret, i atong wakak pas ono, i kibik pasi, pa i tabar diau ono. ");
INSERT INTO lbb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lamur, a matandiau i tapalas, pa dia bot oroi lalan pasi, pa i rorom pas kusun diau. ");
INSERT INTO lbb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pa dia warwara artalai tetek diau mang, “I momol ot, a balandau i pirok ana gasgas ning i warwara tetek dau ning datol han ting na ngas, pa i pak tar a warwara na Buk Tabu tetek dau.” ");
INSERT INTO lbb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ana pukakiar ot ning, dia kamtur pa dia ulak usaot e Jerusalem, pa dia han tetek ning a bonot pa pisir takai a kakak a asaerla pa dingla na tarai otleng ning la kes taum. ");
INSERT INTO lbb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","La atongi mang, “I momol ot! A Leklek ka kamtur ulak, pa ka hanot pas tetek e Saimon.” ");
INSERT INTO lbb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lamur dia atatai ana saning i hanot tetek diau ting na ngas, pa ana nundiau a ororoi lalan ono ning i kibik a bret. ");
INSERT INTO lbb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ning kaning ot dia warwara ana ututnala ne, e Iesu ot i turot na arpotor inla, pa i atongi mang, “A balmolmol tetek mulo!” ");
INSERT INTO lbb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","La matmataut kol pa palaonla i suren ono, la nuki mang a inguna ka ning la oroi i. ");
INSERT INTO lbb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pa i atongi tanla mang, “Sur asa mulo matmataut pa mulo urmatana nuknuk? ");
INSERT INTO lbb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mulo oroi naur a kuk pa naur a hak. Iau momol ot ne. Mulor tuk iau, pa mulor oroi iau. A ingun bel al palpalna, pa bel al sursurna otleng. Ika mulo oroi i mang iau a palaok ot pa sursurik otleng.” ");
INSERT INTO lbb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ning ka atong tari larne, i asangan tar naur a kuna pa naur a hana tanla. ");
INSERT INTO lbb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","La gas pa la kulkulan, ika belot la tortorot. Pa i deken la mang, “Bel ta utna kane sur ar ieni?” ");
INSERT INTO lbb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pa la tabari ana diah sis ning di ka tun tari. ");
INSERT INTO lbb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pa i los pasi, pa i ieni na matanla. ");
INSERT INTO lbb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pa i atongi tanla, “Nating ning a kes taum omulo, ia ka atong tar a warwara ne tetek mulo mang: A ututnala rop ning di ka tumus tari hok, ana warkuraila ane Moses, ana warwara anuna propetla pa ana Saksakla dir tolsot pasi.” ");
INSERT INTO lbb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pa e Iesu i atalapor a nuknukinla sur lar tastasmai ana Buk Tabu. ");
INSERT INTO lbb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","I atongi tanla mang, “Di ka tumus tari mang, a Karisito ir hirua, pa ana natol a pukakiar lamur ir kamtur ulak kusun a minat, ");
INSERT INTO lbb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","pa dir warawai ana risana tetek a taraila miting na matanitu rop, turpasi saot e Jerusalem. Dir warawai tetek la mang lar lingir a nuknukinla pa e God ir kepsen anunla na toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mulo a tena warwarala ana ututnala ne mulo ka oroi tari. ");
INSERT INTO lbb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Oroi i, ar sune sen esaning e Tata ka lele tar onoi. Mulor kes ot te na hanua ne, tuk ning dir mermer tar mulo ana rakrakai misaot.” ");
INSERT INTO lbb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lamur i ben purum pas la misaot e Jerusalem, pa la hanot ting na ning a pukna milau e Betani, pa i tuslan tostos naur a kuna, pa i atong angis la. ");
INSERT INTO lbb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ning kaning ot i atong angis la, i han kusun la, pa e God i los kas pasi usaot na langit. ");
INSERT INTO lbb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","La lotu teteki, pa la ulak usaot e Jerusalem ana tnan gasgas. ");
INSERT INTO lbb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pa la keskes ting na rumai artabar, la atong aleklek pas e God. ");
INSERT INTO lbb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Natnating ot ning belot di akes a rakrakan hanua, a Warwara ka kes nigo. A Warwara i kes taum oe God, pa Warwara i ot e God. ");
INSERT INTO lbb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Natnating ot i kes taum oe God. ");
INSERT INTO lbb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ana Warwara ot, e God i akes a ututnala rop. Bel ta ngas ulak ning e God i akes la. E God i akes a ututnala rop ana Warwara ka. ");
INSERT INTO lbb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A lalaun i kes onoi, pa lalaun ning, i a talapor anuna taraila rop. ");
INSERT INTO lbb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A talapor i atalapor ana mormorom, pa mormorom bel i tolsot pasi. ");
INSERT INTO lbb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","E God i sune sen ning a barsan, a risana e Jon. ");
INSERT INTO lbb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I hanot sur ir warwara talapor ana talapor, sur a taraila rop lar tortorot onoi. ");
INSERT INTO lbb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","I ot bel a talapor, i hanot ka sur ir warwara talapor ana talapor. ");
INSERT INTO lbb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Anasa a talapor momol ning ir atalapor a taraila rop, ir hanot ute na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A Warwara i kes te na rakrakan hanua. Ana Warwara e God i akes a rakrakan hanua, ika a taraila te na rakrakan hanua bel la oroi lalani. ");
INSERT INTO lbb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I hanot sur anuna taraila, ika anuna taraila ot bel la gas pasi. ");
INSERT INTO lbb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ika, la rop ning la gas pasi, pa la tortorot ana risana, i malmaling pas la sur la na natnat e God. ");
INSERT INTO lbb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bel la na natnat e God anasa di agon la ana mangis a tarai, o ana nuknukin tik mite lapiu, o ana nuknuk a tinaulai. E God ot e tamanla. ");
INSERT INTO lbb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A Warwara i hanot a barsan momol, pa i kes potor tamila. Mila ka oroi tar a matatarna, a matatar e Natnalik takai sot ka, ning i han misaot ta e Tamana, i bukus ana marmaris pa momolna. ");
INSERT INTO lbb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","E Jon i warwara talapor onoi, pa i warwara ana tnan elngena mange, “I ka esaning a warwara nigo tar onoi mang, ‘Esaning ir mur tak, i leklek kol hok, anasa i laun nigo tak.’” ");
INSERT INTO lbb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","I bukus ana marmaris, pa ana nuna tnan marmaris, i sira angisngis dala ana galis a wakak a utna. ");
INSERT INTO lbb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Oe Moses, e God i saran tar a warkurai tandala, ika oe Iesu Karisito i saran tar a marmaris pa momolna tetek dala. ");
INSERT INTO lbb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Bel tik i oroi tar e God tuk onone. Ika e Natnalik, takai ka, ning i kes ting na ris e Tamana, ka asangan tar e God tetek dala. Pa i ot e God. ");
INSERT INTO lbb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A ningnigola ana tarai Juda la mitisa e Jerusalem, la sune sen a tena artabarla, pa dingla na tarai tagun a mangis a tarai Liwai, tetek e Jon sur lar dekeni mang, “U esi?” ");
INSERT INTO lbb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","E Jon bel i warwara alari, i warwara talapor ot onoi mang, “Bel iau a Karisito.” ");
INSERT INTO lbb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","La deken ulaki mang, “U esi? U e Elaija?” Pa i keles la mange, “Bel! Iau bel e Elaija.” La deken ulaki mange, “U a propet ning di atongi mang ir hanot?” I keles la mang, “Bel.” ");
INSERT INTO lbb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Lamur la atai i mange, “U esi? Ur atai mila sur milar atai la ning la sune mila ute. Asaning ur atongi hom?” ");
INSERT INTO lbb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","E Jon i keles la mange, “Iau a barsan ning a propet Aisaia i warwara nigo onoi mang, ‘A elngena mainla i arkabah ting na hanua bel mang: Mulor atostos a ngas anuna Leklek.’” ");
INSERT INTO lbb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A Parisaiola ning di sune la tetek e Jon, ");
INSERT INTO lbb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","la dekeni mange, “U atongi mang, bel u a Karisito, pa bel otleng u e Elaija, pa bel u a propet, ning di atongi mang ir hanot. Ning i manglarning, sur asa u baptais a taraila?” ");
INSERT INTO lbb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","E Jon i keles la mange, “A baptais mulo ana malum. Ika takai kaning i tur potor mulo, bel mulo tasmani. ");
INSERT INTO lbb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Esaning ir mur tak, i leklek tak. Pa bel a tolsot sur ar pak sen a inau ana nuna su. A natarna kol tana.” ");
INSERT INTO lbb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A ututnala ne, la hanot tumo e Betani ting na ris a malum Jodan ning e Jon i baptais a taraila ano. ");
INSERT INTO lbb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ning a pukakiar lamur, e Jon i oroi pas e Iesu i han amon teteki, pa i atongi mange, “Mulo oroi i, a Nat a Sipsip ane God, ning ir kepsen a toltol laulau anuna taraila mite na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A barsan kane, ning a warwara nigo tar ono mange, ‘A barsan ning ir mur tak, i leklek kol hok, anasa i laun nigo tak.’ ");
INSERT INTO lbb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Lanigo iau otleng bel a tasmani. Ika a baptais ana malum sur ar apuasa a barsan ne tetek a tarai Israel.” ");
INSERT INTO lbb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Pa e Jon i warwara talapor mange, “Bel a tasmani esi a Karisito. Ika e God, ning i sune iau sur ar baptais ana malum, i atai iau mang, ‘Ur oroi a Talngan Tabu ir han purum pa ir kes saot na palai ning a barsan. A barsan ning, ir baptais ana Talngan Tabu.’ Pa a oroi a Talngan Tabu i han purum misaot na langit, i arlar ana tabun pa i kes saot oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ia ka oroi tar a utna ning i hanot, pa a warwara talapor onoi mang, ai a Nat e God.” ");
INSERT INTO lbb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ning a pukakiar lamur, e Jon taum ana naur a kaklik tagun a kakak a asaerla anunai, ditol tur tar ulak tingia. ");
INSERT INTO lbb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ning i oroi e Iesu i bolos ditol, i atongi ono mange, “Oroi, a Nat a Sipsip ane God.” ");
INSERT INTO lbb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ning naur a kaklik a asaer dia longor a warwara ning, dia mur e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ning e Iesu i talingir, i oroi diau ning dia muri, pa i deken diau mange, “Asaning mu mang suri?” Dia kelesi mange, “Rabi” (a kamkamna mang Tena Asaer), “u kes taha?” ");
INSERT INTO lbb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","E Iesu i keles diau mange, “Mur han ute sur mur oroi.” Pa dia muri, pa dia oroi a pukna ning e Iesu i kes ia. Ning ditol hanot, ka 4 kilok pas pa ditol kes a rah kidol ning tingia. ");
INSERT INTO lbb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ning a halindiau ning dia longor a warwara ane Jon pa dia mur e Iesu, a risana e Endru, a tas e Saimon Pita. ");
INSERT INTO lbb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A ningnigo na utna ning e Endru i toli, i seren pas e tasnalik e Saimon, pa i atai i mange, “Mila ka pastetek pas a Mesaia!” (a kamkamna a Karisito). ");
INSERT INTO lbb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","E Endru i ben e Saimon tetek e Iesu. Ning e Iesu i oroi i, i atai i mange, “U e Saimon, a nat e Jon, dir atong a risam e Kepas.” (Ana warwara Grik di atongi e Pita, a kamkamna a hat.) ");
INSERT INTO lbb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ning a pukakiar ulak, e Iesu i mang sur ir han utumo e Galili. I pastetek pas e Pilip, pa i atai i mange, “Ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","E Pilip, mitumo e Betsaida, a hanua ane Endru pa e Pita. ");
INSERT INTO lbb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","E Pilip i pastetek pas e Natanael, pa i atai i mange, “Mila ka pastetek pas a Karisito ning e Moses i warwara nigo tar onoi ting na Buk a Warkurai, pa propetla otleng la ka warwara nigo tar ono ana nunla na tumtumus, i e Iesu a te Nasaret, a nat e Josep.” ");
INSERT INTO lbb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ika e Natanael i kelesi mange, “Nasaret! Mangmangasa, ta wakak a utna ot ir hanot mitingia?” E Pilip i kelesi mange, “Lamut, pa dar han sur ur oroi.” ");
INSERT INTO lbb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ning e Iesu i oroi pas e Natanael i hanot teteki, i atongi ono mange, “A te Israel momol, bel i tasman a asasongo.” ");
INSERT INTO lbb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","E Natanael i deken e Iesu mange, “U tasman mangmangasa iau?” I kelesi mange, “Ning belot e Pilip i ben u ute, ia ka oroi nigon tar u, ning u kes ting nahai a rakai a fig.” ");
INSERT INTO lbb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","E Natanael i atai i mange, “Tena asaer, u a Nat e God, u a King anuna tarai Israel.” ");
INSERT INTO lbb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","E Iesu i atai i mange, “Mangasa, u tortorot hok, anasa a atai u mang u kes tar nahai a rakai a fig? Lamur ur oroi a tatatnan utna kol ir hanot, ir itna tana utna ne.” ");
INSERT INTO lbb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lamur e Iesu i atai i mange, “A atong momoli tamulo, mulor oroi a langit ir sapang, pa angelola ane God lar hanan kas pa lar hanan purum saot na Nat a Barsan.” ");
INSERT INTO lbb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lamur tana naur a pukakiar di tol a ngasa na tona tinaulai tumo e Kana, ting na papar Galili. E tana e Iesu i han ana ngasa ning. ");
INSERT INTO lbb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Di nunung e Iesu pa nuna kakak a asaerla sur lar han ana ngasa na tona tinaulai. ");
INSERT INTO lbb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ning a wain ka rop, e tana e Iesu i atai e Iesu mange, “Bel ma al wain.” ");
INSERT INTO lbb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","E Iesu i kelesi mange, “Nang, sur asa u atai iau ono? A taim ning ar titol ono belot i sot.” ");
INSERT INTO lbb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tana e Iesu i atai a tarai a titol mange, “Mulor tol asaning ir atai mulo sur mulor toli.” ");
INSERT INTO lbb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Diono na tatatnan koto na hat la tur tingia sur na gosgos kundi, i arlar ot ana titol ana lotu anuna tarai Juda ning la sira toli sur lar toh na matana e God. Taktakai a koto ne, di sira abukusi ana naur a bonot o natol a bonot a galan a malum. ");
INSERT INTO lbb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","E Iesu i atai a tarai a titol mange, “Mulor tere bukus a kotola anal malum.” Pa la tere abukus la. ");
INSERT INTO lbb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lamur, e Iesu i atai la mange, “Mulor ituh pas al malum miting na kotola, pa mulor losi tetek esaning i ningnigo ana ngasa.” Pa la toli larning. ");
INSERT INTO lbb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A ningnigo ana ngasa i gang tumusnan a malum ning ka wain rop. Bel i tasmani mang a wain ne i han mitaha, a tarai a titol ka la tasmani. I kabah maskan pas a barsan ning i taulai ana pukakiar ning, ");
INSERT INTO lbb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","pa i atai i mange, “A taraila rop la sira tabar nigon a taraila ana wakak a wain. Ning la ka gang kol, la tabar kama a taraila ana wain ning bel i wakak kol. Ika u, u bot artabar ana wain ning i wakak kol.” ");
INSERT INTO lbb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ine a ningnigo na akinalang ning e Iesu i toli. I toli tumo e Kana ting na papar Galili. Ana akinalang ne, e Iesu i apuasa a matatarna, pa anuna kakak a asaer la tortorot ono. ");
INSERT INTO lbb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lamur tana ngasa, i han utumo e Kapernaum taum oe tana pa na tastasnala pa anuna kakak a asaerla. La kes pas dingla na pukakiar ot tingia. ");
INSERT INTO lbb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ning a lotu na Han Lakai anuna tarai Juda ka milau, e Iesu i han usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ting na woroh na rumai artabar, i oroi a tarai la siuran a bulumakaula, a sipsipla, pa tabunla, pa i oroi otleng na tena keles mani, la kes ting na nunla na logo. ");
INSERT INTO lbb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","I iris pas a inaula sur a inau a harum, pa i lu purum la rop ono. I lu purum a bulumakaula pa sipsipla, pa i migen sarara a mani anuna tena keles manila, pa i migen lingir anunla na logola. ");
INSERT INTO lbb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pa i atai la ning la siuran a tabunla mange, “Mulor los purum la mite! Gong mulo keles pas a rumai ane Tata sur a rumai a sisiurai!” ");
INSERT INTO lbb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Anuna kakak a asaerla la nuk pas a warwara ting na Buk Tabu mange, “A tnan nuknukik sur anum a rumai i arlar ana iah ning i ien iau.” ");
INSERT INTO lbb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A tarai Juda la hanot ulak tetek e Iesu pa la dekeni mange, “Esi na akinalang ur asangan mila ono, sur milar tasmani mang e God i sune u sur ur tol a ututnala ne?” ");
INSERT INTO lbb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","E Iesu i keles la mange, “Mulor regen sen a rumai ne ane God pa ar atur ulak pasi ana natol a pukakiar ka.” ");
INSERT INTO lbb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","La keles e Iesu mange, “Di tol tar a rumai ne ana diat a bonot pa pisir diono na rau, pa u, ur tol ulak pasi ana natol a pukakiar ka?” ");
INSERT INTO lbb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ning e Iesu i warwara ana rumai ane God, i warwara larlar ot ana palaona. ");
INSERT INTO lbb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Lamur ning e Iesu ka kamtur ulak kusun a minat, anuna kakak a asaerla la nuk pas a warwara ne. Pa la bot tortorot ana Buk Tabu, pa ana warwara ning e Iesu ka atong tari. ");
INSERT INTO lbb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ning e Iesu i kes saot e Jerusalem ana lotu na Han Lakai, a galis a tarai la oroi a akinalangla ning i toli, pa la tortorot ana risana. ");
INSERT INTO lbb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ika e Iesu bel i tortorot ana tik, anasa i tasman a taraila rop. ");
INSERT INTO lbb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bel i kapan sur tik ir atai i ana toltol anuna taraila, anasa i ot i tasman asaning kaning na balanla. ");
INSERT INTO lbb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ning a barsan tagun a Parisaiola, a risana e Nikadimos, a ningnigo anuna tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","I han tetek e Iesu ana ning a morom pa i atai i mange, “Tena asaer, mila tasman u mang u a tena asaer ning e God i sune u. Bel ta barsan ir tolsot pas a akinalangla ning u sira toli, ning e God bel ir kes taum onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","E Iesu i kelesi mange, “A atong momoli tam, ning tik bel di agon tona pasi, bel ir tolsot sur ir oroi a matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","E Nikadimos i dekeni mange, “Dir agon tona mangmangasa pas tik ning ka bun? Mangmangasa, ir kas ulak tingui na balana e tana sur ir agon ulaki?” ");
INSERT INTO lbb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","E Iesu i kelesi mange, “A atong momoli tam, esining bel di agon tona pasi ana malum pa ana Talngan Tabu, bel ir tolsot sur ir kas ting na matanitu ane God. ");
INSERT INTO lbb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Esining di agoni ana palaona, ir laun ana palaona ka, pa esining di agoni ana Talngan Tabu, ir laun ana inguna. ");
INSERT INTO lbb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gong u kulkulan ning a atai u mang dir agon tona pas mulo. ");
INSERT INTO lbb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A wuwu i han taltal ana nuknukna, u longor a malwasna, ika bel u tasmani mang i han mitaha, pa ir han utaha. Mang otleng larning tetek la rop ning a Talngan Tabu i agon tona la.” ");
INSERT INTO lbb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","E Nikadimos i dekeni mange, “Dir tol mangasa a utna ne?” ");
INSERT INTO lbb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","E Iesu i kelesi mange, “U a tena asaer anuna tarai Israel. I mangasa ning bel u tasman a ututnala ne? ");
INSERT INTO lbb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A atong momoli tam, mila warwara ana saning mila tasmani, pa mila warwara talapor ana saning mila ka oroi tari, ika bel mulo tortorot ana numila na warwara talapor. ");
INSERT INTO lbb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A atai mulo ana ututnala mite lapiu pa bel mulo tortorot onoi. Mulor tortorot mangmangasa ning ar atai mulo ana ututnala misaot na langit? ");
INSERT INTO lbb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Bel tik i han pas usaot na langit. A Nat a Barsan ka, esaning i han purum misaot na langit. ");
INSERT INTO lbb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nating e Moses i akulam a soi saot na rakai, ting na hanua bel. Mang otleng larning dir akulam a Nat a Barsan usaot, ");
INSERT INTO lbb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","sur la rop ning la tortorot onoi lar laun tikin. ");
INSERT INTO lbb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“E God i maris a rakrakan hanua, pa i saran tar e Natnalik takai sot ka, sur esining ir tortorot onoi, ir laun tikin, pa bel ir hirua. ");
INSERT INTO lbb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","E God bel i sune e Natnalik ute na rakrakan hanua sur ir warkurai a taraila sur lar hirua. I sune i sur ir alaun la. ");
INSERT INTO lbb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Esining i tortorot onoi, bel dir warkurai i sur ir hirua. Ika, esining bel i tortorot, di ka warkurai tari sur ir hirua, anasa bel i tortorot oe Nat e God takai sot ka. ");
INSERT INTO lbb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ine a kamkama warkurai ning e God i sarani: A talapor ka hanot te na rakrakan hanua, ika a tarai la mang ka sur a mormorom, pa talapor bel, anasa anunla toltol i laulau kol. ");
INSERT INTO lbb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","La rop ning la sira tol a toltol laulaula, la nget ka a talapor, pa bel la han tetek a talapor, sakana dir oroi puasa anunla na toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ika, esining i sira mur a momolna, i hanot ana talapor, sur dir oroi puasai mang anuna titolla i kamkamna ot ta e God.” ");
INSERT INTO lbb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lamur e Iesu pa nuna kakak a asaer la han misaot e Jerusalem sur ning a natar a hanua kaning ot na papar Judia, pa la kes pas tingia, pa i baptais a taraila. ");
INSERT INTO lbb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pa e Jon otleng i baptais tumo e Ainon milau e Salim, anasa a galis a malum tingia. A tarai la hanot amon teteki sur ir baptais la. ");
INSERT INTO lbb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A titol ne i hanot ning belot di akas e Jon ting na karabus. ");
INSERT INTO lbb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Dingla na kakak a asaer ane Jon la arlak na warwara taum ana ning a te Juda ona munmun ning a tarai Juda la sira toli sur lar toh na matana e God. ");
INSERT INTO lbb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","La han tetek e Jon pa la atai i mange, “Tena Asaer, a barsan ning mu kes taum pas tumo na ris a malum Jodan, pa u warwara talapor tar ono, kanumo ma i baptais, pa taraila rop la han teteki.” ");
INSERT INTO lbb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","E Jon i atai la mange, “Ning e God saot na langit bel i saran tar ta utna tetek tik, bel ir kibasi. ");
INSERT INTO lbb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mulo ot mulo ka longor tari ning a atongi mang, ‘Bel iau a Karisito. E God i sune iau sur ar nigo tana, pa i, ir mur.’ ");
INSERT INTO lbb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A barsan ning i taulai ta hane, anunai ot a hane ning. A halin a barsan ning, ir harnanai pa ir longlongor suri. Ning ir longor a elngena barsan ning i taulai, ir gas kol. Onone anuk a gasgas i arlar ana gasgas anuna halin a barsan ning i taulai, pa anuk a gasgas i bot sot. ");
INSERT INTO lbb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","I ot ir leklek amon pa iau ar natarna amon. ");
INSERT INTO lbb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Esaning i han misaot na langit, i leklek kol tana taraila rop. A barsan ning mite lapiu, mitet lapiu, pa i warwara ka ana ututnala mite lapiu. Esaning i han misaot na langit, i leklek kol tana taraila rop. ");
INSERT INTO lbb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pa i warwara talapor ana saning i oroi i pa i longori, ika bel tik i tortorot ana nuna warwara talapor. ");
INSERT INTO lbb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ika esining i tortorot ana nuna warwara talapor, i amomoli mang e God a momolna. ");
INSERT INTO lbb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Esaning e God i sune i, i warwara ana warwara ane God, anasa e God i saran arop tar a Talngan Tabu teteki. ");
INSERT INTO lbb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","E Tamana i mang kol sur e Natnalik, pa i saran arop tar a ututnala uting na kuna. ");
INSERT INTO lbb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Esining i tortorot ona Nat e God i kibas a lalaun tikin. Ika esining i gilam ris kusun e Natnalik, bel ir kibas a lalaun, anasa a balakut ane God ka kes tar onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","A Parisaiola la longori mang a galis a tarai a asaer la mur e Iesu, pa i baptais la. La galis tana tarai a asaer ane Jon. ");
INSERT INTO lbb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ika e Iesu ot bel i baptais tik, anuna kakak a asaer ka, la baptais. ");
INSERT INTO lbb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ning e Iesu ka tasmani mang a Parisaiola la ka longori, i kamtur misaot na papar Judia pa i ulak utumo na papar Galili. ");
INSERT INTO lbb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ana nuna tinan i mur a ngas ning i han potor a papar Samaria. ");
INSERT INTO lbb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tumo e Samaria, i hanot ting na hanua Sikar, milau a puka kabalapiu, ning nating ot e Jekop i tabar tar e natnalik e Josep onoi. ");
INSERT INTO lbb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ning a kabut e Jekop ka kel tari tingia. A palaona e Iesu ka ngol ana tinan barah, pa i kes ting napir a kabut ning, ana iahkamis tostos. ");
INSERT INTO lbb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ning a hane Samaria i hanot sur ir ituh, pa e Iesu i atai i mange, “Ur tabar iau anal malum.” ");
INSERT INTO lbb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Anuna kakak a asaer, la ka han uting na hanua, sur lar lou utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A hane Samaria i keles e Iesu mange, “U a te Juda, pa iau a hane Samaria. Sur asa u nunung iau sur al malum?” Anasa a tarai Juda bel la baltaum ana Samariala. ");
INSERT INTO lbb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ika e Iesu i kelesi mange, “Ning u ka tasman tar a artabar ane God, pa u ka tasman otleng esaning i nunung u sur al malum, ur nunungi, pa ir tabar u ana malum a lalaun.” ");
INSERT INTO lbb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A hane i atai i mange, “Leklek, bel ta itituh anumi, sur ur ituh al malum ono, pa kabut otleng i kes purum kol. Mitaha a malum a lalaun ning? ");
INSERT INTO lbb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","U nuki mang u leklek ta e tubundala e Jekop ning i tabar mila ana kabut ne? I taum ana natnatnala pa nuna na inagoi otleng, la rop la gang ono.” ");
INSERT INTO lbb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","E Iesu i kelesi mange, “La rop ning la gang a malum ne, lar mos ulak ka. ");
INSERT INTO lbb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ika esining ir gang a malum ning ar tabari ono, bel ir mos ulak. A malum ning ar tabari ono, i arlar ana matana malum ting na nuna lalaun, ning ir burburak ot, pa ir tabari ana lalaun tikin.” ");
INSERT INTO lbb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A hane i atai i mange, “Leklek, tabar iau ana malum ning, sur gong ma a mos ulak, pa gong ma a ulak sur ar ituh.” ");
INSERT INTO lbb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","E Iesu i atai i mange, “Ur han, ben pas anum a barsan pa mur ulak ute.” ");
INSERT INTO lbb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A hane i kelesi mange, “Bel anuk ta barsan.” E Iesu i atai i mange, “I tostos ot ning u atongi mang, bel anum ta barsan. ");
INSERT INTO lbb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","U ka taulai tar dilima na barsan, pa i ning u kes taum ono onone, bel anum a barsan. A momolna ot ning u atongi tak.” ");
INSERT INTO lbb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A hane i kelesi mange, “Leklek, a tasmani mang u a propet. ");
INSERT INTO lbb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A tumtubumila nating la lotu tetek e God saot na mangir ne, ika mulo a tarai Juda mulo atongi mang dir lotu tetek e God saot e Jerusalem.” ");
INSERT INTO lbb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","E Iesu i kelesi mange, “Oroi, a momolna ne a atongi tam, a taim ir hanot, ning bel ma mulor lotu tetek e Tata saot na mangir ne, pa saot otleng e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mulo a Samariala bel mulo tasman esining mulo lotu teteki. Ika mila a tarai Juda, mila tasman ot esaning mila lotu teteki, anasa mila tasman a ngas ning e God i alaun a taraila ono. ");
INSERT INTO lbb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A taim ir hanot pa ka hanot, ning na tena lotu momol lar lotu tetek e Tata ana ingunla pa ana momolna. A ngas a tena lotula larning, e Tata i mang kol sur la. ");
INSERT INTO lbb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","E God a Ingun, pa la ning lar lotu teteki, lar lotu ot ana ingunla pa ana momolna.” ");
INSERT INTO lbb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A hane i atai i mange, “A tasmani mang a Mesaia ning di atongi mang a Karisito, ir hanot, pa ir papak ana ututnala rop tetek dala.” ");
INSERT INTO lbb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","E Iesu i kelesi mange, “Iau ne, a warwara tam.” ");
INSERT INTO lbb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ano otning, anuna kakak a asaerla la ulak, la kulkulan kol ning la oroi e Iesu i warwara taum ana hane. Ika, bel tik onla i dekeni mang, “U mang sur asa?” pa, “Asa kamkamna ning u warwara taum ono?” ");
INSERT INTO lbb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A hane ning i han kusun anuna koto, pa i ulak sur a hanua pa i atai a taraila mang, ");
INSERT INTO lbb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mulo lamut, mulor oroi ning a barsan i atai iau ana ututnala rop ning ia ka tol tari nating. Ngandek a Mesaia ma?” ");
INSERT INTO lbb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pa taraila ning, la han kusun a hanua pa la han tetek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ning a hane ka han, a kakak a asaer la nunung kol teteki mange, “Tena asaer, ur hangan pas.” ");
INSERT INTO lbb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ika e Iesu i keles la mange, “Aka utna na hangan kanet, ning bel mulo tasmani.” ");
INSERT INTO lbb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","A kakak a asaer la deken artalai la mange, “Ngandek tik ka tabar tari anal utna na hangan?” ");
INSERT INTO lbb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","E Iesu i atai la mange, “Aka utna na hangan ine, ar mur a nuknuk esaning i sune iau ute, par tol arop anuna titol. ");
INSERT INTO lbb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mulo sira atongi mange, ‘Diat a kalang kaning ot sur dir sol.’ Ika a atai mulo mange: Mulor tai usa lanigo, pa mulor oroi a barimla, la ka makos rop, pa ka sang sur dir sol. ");
INSERT INTO lbb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A tena sol ning i sol a utna na hangan, i los arlou ono. Pa utna ning i sol pasi, ai a tarai ning la kibas a lalaun tikin. A tena omomai pa tena sol, diar gas taum. ");
INSERT INTO lbb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","I momol ot, a warwara ning a tarai la sira atongi mange, ‘Takai i omomai, pa takai otleng i sol.’ ");
INSERT INTO lbb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A sune mulo sur mulor sol ting na barim ning mulo ot bel mulo oman tari. Dingla na tarai masik ot la tol tari, pa mulo ka los pas a arlou ana nunla na titol.” ");
INSERT INTO lbb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A galis a Samaria ting na hanua ning, la tortorot oe Iesu, anasa a hane ning i warwara talapor mange, “I atai iau ana ututnala rop ning ia ka tol tari nating.” ");
INSERT INTO lbb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A tarai Samaria la han tetek e Iesu pa la angongosi sur ir kes taum onla, pa i kes pas naur a pukakiar tingia. ");
INSERT INTO lbb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pa galis ulak la tortorot, anasa ana nuna warwarala. ");
INSERT INTO lbb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","La atai a hane mange, “Onone mila ka tortorot, bel ana warwara ning u atongi oe Iesu. Mila ot mila ka longori, pa mila ka tasman momoli mang ai a Tena Alaun sur a taraila mite na rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Lamur tana naur a pukakiar, e Iesu i han utumo e Galili. ");
INSERT INTO lbb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","E Iesu ot ka atong tari mange, “A taraila bel la hanrawai a propet ting na hanua ngasna.” ");
INSERT INTO lbb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","A taraila mitumo e Galili la ka han pas ana lotu na Han Lakai saot e Jerusalem, pa la ka oroi tar a ututnala ning e Iesu i toli ting na lotu. Pa ning e Iesu i hanot tumo e Galili, a tarai la gas pasi. ");
INSERT INTO lbb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","E Iesu i ulak utumo e Kana ting na papar Galili, a hanua ning i keles tar a malum sur a wain. Ning a ningnigo tagun a matanitu, e natna barsan i sasam tumo e Kapernaum. ");
INSERT INTO lbb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ning i longori mang e Iesu i han misaot na papar Judia utumo e Galili, i han teteki pa i nunungi sur ir han utumo e Kapernaum sur ir alangolango e natna barsan ning milau ir mat. ");
INSERT INTO lbb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","E Iesu i atai i mange, “Ning bel mulo oroi al ututna na kulkulan pa al akinalang, bel mulor tortorot.” ");
INSERT INTO lbb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","A ningnigo anuna matanitu i atai i mange, “Leklek, dar han kapit sakana natuklik ir mat!” ");
INSERT INTO lbb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","E Iesu i kelesi mange, “Ur han ka, e natumlik ir laun.” A barsan ning i tortorot ana warwara ane Iesu, pa i ulak. ");
INSERT INTO lbb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ning belot i hanot, anuna tena titol orosla la han barati pa la atai i mang, e natumlik ka laun. ");
INSERT INTO lbb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I deken la mange, “Esi na taim momol ning a natuklik i laun ulak ono?” La kelesi mange, “Nabong, ana 1 kilok, a laplapang i rop kusuni.” ");
INSERT INTO lbb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tamana kaklik i nuk ulak pas a taim ning e Iesu i atai i mange, “E natumlik ir laun.” Pa i oroi lalani mang a taim ot ning e Iesu i atai ono, a laplapang i rop kusun e natnalik. Pa latamana rop la tortorot oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ine a munaur a akinalang, ning e Iesu i toli tumo e Galili, ning i han misaot e Judia. ");
INSERT INTO lbb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lamur e Iesu i han usaot e Jerusalem sur a tnan lotu anuna tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ning a tnan kabapolo, di atongi ana warwara Hibru mang e Betesda, kanisaot e Jerusalem, milau a tnan taman ning di atongi mang “Taman ngas a sipsip”. Pa dilima na parada la tur talilis a kabapolo ning. ");
INSERT INTO lbb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","A galis a tarai ning la kurah ana urmatana tinsaman, la sira borbor tingia. La ning la kut, la ning bel la han, pa la ning a palaonla i mat. ");
INSERT INTO lbb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pa ning a barsan i kes tingia ka kurah pas natol a bonot pa pisir siwal a rau. ");
INSERT INTO lbb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ning e Iesu i oroi i ning i borbor tar tingia, pa i talapor teteki mang a barsan ning ka bongnani ana tinsaman, i dekeni mange, “Mangasa, u mang sur ur langolango?” ");
INSERT INTO lbb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A barsan ning i kelesi mange, “Leklek, ning a kabapolo i tonton, bel tik ir nangan iau sur ir los tar iau. Ning a tohi sur ar han ar munmun, tik masik ka ir dun nigo alar iau.” ");
INSERT INTO lbb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","E Iesu i atai i mange, “Ur kamtur, ur kibas a mat ngasim, pa ur han.” ");
INSERT INTO lbb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ono otning a barsan ning i langolango, i kamtur, i kibas a mat ngasna, pa i han. A utna ne i hanot ana Pukakiar Sabat. ");
INSERT INTO lbb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Dingla na tarai Juda la atai a barsan ning e Iesu i alangolango pasi mange, “A Sabat ne! A warkurai i mang, gong di los a mat ono.” ");
INSERT INTO lbb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pa i keles la mange, “A barsan ning i alangolango pas iau, i atai iau mang, ar los a mat ngasik par han.” ");
INSERT INTO lbb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","La dekeni mange, “Esi na barsan ning i atai u mang ur los pas a mat ngasim pa ur han?” ");
INSERT INTO lbb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ika a barsan ning bel i tasman esining i alangolango pasi, anasa e Iesu i han potor a kunum a taraila ning. ");
INSERT INTO lbb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lamur ot, e Iesu i pastetek pas a barsan ning ting na rumai artabar. I atai i mange, “Oroi, u ka langolango ne. Gong ulak u tol ta toltol laulau, sakana ta laulau a utna kol ir hanot hom.” ");
INSERT INTO lbb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A barsan ning i han pa i atai a tarai Juda mange, “E Iesu ot i alangolango pas iau.” ");
INSERT INTO lbb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ono otning, a tarai Juda la turpas a tol a gininla tetek e Iesu, anasa i tol a ututnala ne ana Pukakiar Sabat. ");
INSERT INTO lbb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","E Iesu i atai la mange, “E Tata bel i manah ana titol, larning iau otleng bel ar manah.” ");
INSERT INTO lbb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ine a kamkamna ning a tarai Juda la mang kol sur lar umkol e Iesu. La balakuti, bel i kamkamna, mang i titol ana Pukakiar Sabat ka, i kamkamna otleng mang i ot i atong e God mang e Tamana, pa ana warwara ne, i arlar i ot oe God. ");
INSERT INTO lbb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","E Iesu i keles la mange, “A atong momoli tamulo, a Nat e God bel ir tol ta utna ana nuknukna ot, i tol ka asaning i oroi e Tamana i toli. Anasa asaning e Tamana i toli, e Natnalik otleng ir toli. ");
INSERT INTO lbb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","E Tamana i mang kol sur e Natnalik, pa i asangani ana ututnala rop ning i sira toli. Ir asangani otleng ana tatatnan utna tan dingla ne, pa mulor kulkulan onoi. ");
INSERT INTO lbb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","E Tamana i akamtur a minatla pa i tabar la ana lalaun, mang otleng larning tetek e Natnalik, ir tabar la ning i mang sur ir tabar la ana lalaun. ");
INSERT INTO lbb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","E Tamana bel ir warkurai tik. Ika ka saran tar a warkuraila rop ta e Natnalik, sur ir warkurai ono, ");
INSERT INTO lbb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","sur a taraila rop lar hanrawai e Natnalik larning la hanrawai e Tamana. Esining bel i hanrawai e Natnalik, bel i hanrawai e Tamana otleng, ning i sune i ute. ");
INSERT INTO lbb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“A atong momoli tamulo, esining i longor anuk na warwara pa i tortorot o esaning i sune iau ute, ka kibas a lalaun tikin, pa bel ir hirua ana warkurai. Ka han kusun a minat sur a lalaun tikin. ");
INSERT INTO lbb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A atong momoli tamulo, a taim ir hanot, pa ka hanot, ning a minatla lar longor a Nat e God, pa la ning la longori lar laun. ");
INSERT INTO lbb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","E God a kama lalaun pa i sarani otleng tetek e Natnalik, sur i otleng a kama lalaun. ");
INSERT INTO lbb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","E God i saran tar a warkurai tana sur ir warkurai a taraila ono, anasa ai a Nat a Barsan. ");
INSERT INTO lbb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Gong mulo kulkulan ana warwara ne, anasa a taim ir hanot, pa la rop ning la borbor ting na kulam a minat lar longor a elngena. ");
INSERT INTO lbb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lar kamtur kusun a tung a minatla. La ning la ka tol tar a wakak a toltol lar kamtur kusun a minat sur a lalaun tikin. Pa la otleng ning la ka tol tar a toltol laulau, lar kamtur kusun a minat sur a hinirua tikin.” ");
INSERT INTO lbb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","E Iesu i warwara ot tetek a tarai Juda mange, “Bel ar tol ta utna ana nuknukik ot, a warkurai a taraila ana utna ning a longori ta e Tata. Pa anuk a warkurai i tostos, anasa bel a mur a nuknukik, a mur ot a nuknukna esaning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ning ar warwara talapor ulak ot hok, anuk a warwara bel ir mamahat. ");
INSERT INTO lbb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tik masik ot i warwara talapor hok, pa a tasmani mang anuna warwara talapor hok i momol kol. ");
INSERT INTO lbb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Mulo sune dingla na tarai tetek e Jon a Tena Baptais, pa i warwara talapor hok, pa anuna warwara talapor i momol. ");
INSERT INTO lbb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bel a kapan sur tik ning ir warwara talapor hok, ika a atongi larne sur dir alaun mulo. ");
INSERT INTO lbb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","E Jon i arlar ana lam, ning i irnga pa i talapor, pa mulo gas ning mulo tai siklik pas ka ana talaporna. ");
INSERT INTO lbb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ika ar atongi tetek mulo ana warwara talapor hok ning i itna tana warwara talapor ane Jon. A titolla ning a sira toli, la warwara talapor hok. Anasa a titolla ning e Tata i sarani tak sur ar tol asoti, i asangani mang i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pa e Tata, ning i sune iau ute, i ot ka warwara talapor tar hok. Bel mulo longor a elngena, pa bel mulo oroi tar a matana otleng. ");
INSERT INTO lbb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pa bel mulo tong akes anuna warwarala ting na balamulo, anasa bel mulo tortorot o esaning i sune i ute. ");
INSERT INTO lbb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mulo sira was wakak a Buk Tabu, anasa mulo nuki mang mulor kibas a lalaun tikin ono. Ika a Buk Tabu otleng i warwara talapor ka hok! ");
INSERT INTO lbb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ika bel mulo mang sur mulor han tetek iau, sur mulor kibas a lalaun. ");
INSERT INTO lbb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Bel a mang sur a tarai lar atong aleklek iau. ");
INSERT INTO lbb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Anasa a tasman mulo ot, mang bel mulo mang sur e God ting na balamulo. ");
INSERT INTO lbb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A hanot ana risana e Tata, pa bel mulo gas pas iau. Ika ning tik masik ir hanot ana risana ot, mulor gas pasi. ");
INSERT INTO lbb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mulo mang kol sur a tarai lar atong aleklek pas mulo, pa bel mulo rakrakai sur e God ir atong aleklek mulo, e God esaning i takai sot ka. Ning i manglarning, bel mulo tortorot hok. ");
INSERT INTO lbb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Gong mulo nuki mang iau, ar tiu mulo tetek e Tata. E Moses ning mulo tortorot mang ir nangan mulo, i ot ir tiu mulo. ");
INSERT INTO lbb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ning mulo tortorot oe Moses, mulor tortorot otleng hok, anasa ka tumtumus nigo tar hok. ");
INSERT INTO lbb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ika ning bel mulo tortorot ana tumtumusla ane Moses, mulor tortorot mangmangasa ana nuk a warwarala?” ");
INSERT INTO lbb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lamur e Iesu i han lakai a puka tasi Galili, ning di atongi otleng mang a puka tasi Tiberias. ");
INSERT INTO lbb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A tnan kunum a tarai la muri, anasa la ka oroi tar a akinalangla e Iesu i toli, ning i alangolango la ning la kurah. ");
INSERT INTO lbb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","E Iesu i han kas usaot na mangir, pa i kes taum ana nuna kakak a asaerla. ");
INSERT INTO lbb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A lotu na Han Lakai anuna tarai Juda ka milau. ");
INSERT INTO lbb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ning e Iesu i tai tar, i oroi pas a tnan kunum a tarai la han teteki. I atai e Pilip mange, “Dalar lou al utna na hangan taha, sur dalar tabar a taraila ne ono?” ");
INSERT INTO lbb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","E Iesu i atongi larne sur ir toho e Pilip. I ot ka tasman asaning ir toli. ");
INSERT INTO lbb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","E Pilip i kelesi mange, “A arlou tagun a siwal a kalang ning dir lou pas a utna na hangan ono, bel ir arlar onla.” ");
INSERT INTO lbb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ning a hala nuna kakak a asaerla, a risana e Endru, a tas e Saimon Pita, i atai e Iesu mange, ");
INSERT INTO lbb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ning a kaklik barsan kane i los dilima na bret ning di toli ana bali, pa naur a natar a sis. Ika ir arlar mangmangasa ona taraila ne?” ");
INSERT INTO lbb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A ulai rop ka, ting na pukna ning, pa e Iesu i sune anuna kakak a asaerla sur lar akes a taraila tingia. Pa la kes. A wawas ana tarai ka i arlar ana dilima na rip, pa gurarala pa kakakla otleng la hangan taum onla. ");
INSERT INTO lbb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","E Iesu i kibas pas dilima na bret, i atong wakak pas tetek e God onoi. Pa i asalari tana taraila ning la kes tingia. I toli otleng larning ana sis, pa la ieni arlar larning la mang suri. ");
INSERT INTO lbb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ning la ka masur rop, i atai anuna kakak a asaerla mange, “Mulor suah taum wakak a mah a utna na hanganla, sur gong di alaulau a utna na hangan.” ");
INSERT INTO lbb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pa la suah taum a mah a utna na hangan tagun dilima na bret ning, pa la song bukus pas ning a bonot pa pisir naur a rat. ");
INSERT INTO lbb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ning a tarai la oroi a akinalang ne i toli, la atongi mange, “I momol ot, a barsan ne, ai a Propet ning di atongi mang ir hanot ute na rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ning e Iesu i tasmani mang la mang sur lar han teteki sur lar angongosi sur ir king, i han masik kusun la usaot na ning a mangir. ");
INSERT INTO lbb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ning ka rah morom, a kakak a asaerla ane Iesu la han utumo na puka tasi. ");
INSERT INTO lbb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","La kas ana mon, pa la turpas a lakai a puka tasi sur e Kapernaum. Ka morom, pa e Iesu belot i hanot tetek la. ");
INSERT INTO lbb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A tnan wuwu i ragati pa tatatnan top i kamtur. ");
INSERT INTO lbb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ning la ka ulusu bakbak, arlar ana dilima na kilomita, la oroi pas e Iesu i han saot na palai a puka tasi tetek la. Pa la matmataut kol. ");
INSERT INTO lbb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ika e Iesu i atai la mange, “Gong mulo matmataut, iau ka ne.” ");
INSERT INTO lbb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","La gas pasi pa la akasi uting na mon. Pa la sot kakat ting na pukna ning la han suri. ");
INSERT INTO lbb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ana ning a pukakiar lamur, a kunum a taraila ning la kes tumo na ris a puka tasi, la tasmani mang ning a mon ka i kes tingia. Pa la tasmani mang a kakak a asaerla ka la han, e Iesu bel i kas taum onla. ");
INSERT INTO lbb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lamur dingla na mon mitumo e Tiberias la sot milau ting na pukna ning a Leklek i atong wakak ana bret pa kunum a tarai la hangan ano. ");
INSERT INTO lbb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ning a kunum a tarai la oroi mang e Iesu taum ana nuna kakak a asaerla bel la kes tingia, la kas ana monla, pa la han utumo e Kapernaum sur lar tai sur e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ning a tarai la pastetek pas e Iesu tumo na ris a puka tasi, la dekeni mange, “Tena Asaer, nangse u han tar ute?” ");
INSERT INTO lbb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","E Iesu i keles la mange, “A atong momoli tamulo, bel mulo tai sur iau anasa mulo oroi a akinalangla ning a toli, bel. Mulo tai ka sur iau anasa mulo ien a bret pa mulo masur ono. ");
INSERT INTO lbb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gong mulo rakrakai ka sur a utna na hangan ning i sira marase. Mulor rakrakai sur a utna ning ir kes sur a lalaun tikin, ning a Nat a Barsan ir tabar mulo ono. Anasa e God e Tata ka saran tar a rakrakai tak sur ar toli larne.” ");
INSERT INTO lbb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","La dekeni mange, “Asaning milar toli sur milar tol a titolla ning e God i mang suri?” ");
INSERT INTO lbb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","E Iesu i keles la mange, “A titolla ning e God i mang suri, mulor tortorot o esaning i sune i ute.” ");
INSERT INTO lbb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pa la dekeni mange, “Ur tol esi na akinalang sur milar oroi pa milar tortorot hom onoi? Asaning ur toli? ");
INSERT INTO lbb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na tubumila la ien a mana ting na hanua bel, larotning di ka tumus tari ting na Buk Tabu mange, ‘I tabar la ana bret misaot na langit pa la ieni.’” ");
INSERT INTO lbb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","E Iesu i atai la mange, “A atong momoli tamulo, bel e Moses ning i tabar la ana bret misaot na langit, e Tata i tabar la. Pa onone i tabar mulo ana bret momol misaot na langit. ");
INSERT INTO lbb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Esaning i han purum misaot na langit, i ot a bret ane God, ning i saran a lalaun tetek a taraila rop te na rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","La atai i mange, “Leklek, ur tabar mila ana bret ning, ana pukakiarla rop.” ");
INSERT INTO lbb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","E Iesu i atai la mange, “Iau a bret a lalaun. Esila ning lar han tetek iau, bel lar murak, pa esila ning lar tortorot hok, bel lar mos ulak. ");
INSERT INTO lbb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ia ka atai tar mulo mang mulo ka oroi tar iau, ika bel mulo tortorot. ");
INSERT INTO lbb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","La rop ning e Tata i saran tar la tak, lar han tetek iau, pa esining ir han tetek iau, bel ar kepseni, bel. ");
INSERT INTO lbb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Anasa a han purum misaot na langit, bel sur ar mur a nuknukik, ika sur ar mur ot a nuknuk esaning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ine a nuknuk esaning i sune iau ute, gong tik ta halinla ning i saran tar la tak ir hirua. Ar akamtur ulak la rop kusun a minat ana ararop a pukakiar. ");
INSERT INTO lbb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A nuknuk e Tata i mange, la rop ning la tai tetek e Natnalik pa la tortorot onoi, lar laun tikin, pa iau ar akamtur la kusun a minat ana ararop a pukakiar.” ");
INSERT INTO lbb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Dingla na Juda la ururai oe Iesu, anasa i atongi mange, “Iau a bret ning i han purum misaot na langit.” ");
INSERT INTO lbb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pa la atongi mange, “E Iesu a nat e Josep ka. Dala tasman ot e tamana pa e tana. Pa sur asaning i atongi mang i han purum misaot na langit?” ");
INSERT INTO lbb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","E Iesu i keles la mange, “Gong mulo ururai. ");
INSERT INTO lbb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Bel tik ir han sot pas tetek iau. Ika e Tata ot ning i sune iau, ir ben tari tetek iau, par akamturi kusun a minat ana ararop a pukakiar. ");
INSERT INTO lbb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A propetla la ka tumus tari mange, ‘E God ir asaer la rop.’ Pa la rop ning la longor e Tata pa la asaer tana, lar han tetek iau. ");
INSERT INTO lbb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bel tik i oroi e Tata. Esan kaning i han pas misaot ta e God, i oroi tar e Tamana. ");
INSERT INTO lbb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A atong momoli tamulo, esining i tortorot hok, ka kibas a lalaun tikin. ");
INSERT INTO lbb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Iau a bret a lalaun. ");
INSERT INTO lbb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nating na tubumulo la ien a mana ting na hanua bel, ika la ka mat. ");
INSERT INTO lbb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ika a bret ne i han purum misaot na langit, ning tik ir ieni, bel ir mat. ");
INSERT INTO lbb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iau a bret ning i laun, ning i han purum misaot na langit. Esining ir hangan ana bret ne, ir laun tikin. A bret ne ar artabar ono, a palaok. A sarani sur a taraila te na rakrakan hanua lar kibas lalaun onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dingla na tarai Juda, la arlak artalai la, pa la atongi mange, “A barsan ne ir tabar mangmangasa dala ana palaona sur dalar ieni?” ");
INSERT INTO lbb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pa e Iesu i atai la mange, “A atong momoli tamulo, ning bel mulor ien a palaona Nat a Barsan pa bel mulor gang a sulukna, bel al lalaun momol ir kes omulo. ");
INSERT INTO lbb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Esining ir ien a palaok pa ir gang a sulukik, ka kibas a lalaun tikin, pa iau ar akamturi kusun a minat ana ararop a pukakiar. ");
INSERT INTO lbb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Anasa a palaok a utna na hangan momol, pa sulukik a malum a gang momol. ");
INSERT INTO lbb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Esining ir ien a palaok pa ir gang a sulukik, ir laun hok, pa iau ar laun onoi. ");
INSERT INTO lbb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","E Tata ning i laun i sune iau, pa a laun anasa oe Tata. Mangotleng larning tetek esining ir ien a palaok, ir laun anasa hok. ");
INSERT INTO lbb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ine a bret ning i han misaot na langit. Bel i arlar ana mana ning na tubumulola nating la ieni, pa la ka mat. Ika esining ir hangan ana bret ne, ir laun tikin.” ");
INSERT INTO lbb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","A warwarala ne, e Iesu i atongi ning i asaer a taraila ting na rumai lotu tumo e Kapernaum. ");
INSERT INTO lbb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A galis miting na nuna tarai a asaerla ning la longor a warwarala ne la atongi mange, “A asaer ne i ngangaten kol, esi ir tong akes pasi?” ");
INSERT INTO lbb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","E Iesu i tasmani mang anuna tarai a asaer la ururai onoi. I deken la mange, “I mangasa, a warwara ne i alaulau mulo? ");
INSERT INTO lbb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ir mangasa tetek mulo ning mulor oroi a Nat a Barsan ir ulak usaot sur a hanua ning nating ka kes pas ano? ");
INSERT INTO lbb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A Talngan Tabu i saran a lalaun. A rakrakai ana palaona tik bel i to pas ta utna. A warwarala ning a atongi tamulo, i hanot tagun a Talngan Tabu, pa i saran a lalaun. ");
INSERT INTO lbb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ika dingla omulo bel la tortorot.” Anasa e Iesu ka tasman la ning bel lar tortorot onoi, pa esan otleng ning ir saran tari uting na kuna hiruala. ");
INSERT INTO lbb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pa i atongi otleng mange, “Ine a kamkamna ning a atai mulo mang bel tik ir tolsot sur ir han tetek iau. Ika, ning e Tata ir sarani tetek iau, ir han tetek iau.” ");
INSERT INTO lbb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pa galis miting na nuna tarai a asaer la ulak kusuni, pa bel ma la muri. ");
INSERT INTO lbb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","E Iesu i deken ning a bonot pa pisir naur a kakak a asaer anunai mange, “I mangasa, mulo otleng, mulo mang sur mulor ulak kusun iau?” ");
INSERT INTO lbb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","E Saimon Pita i kelesi mange, “Leklek, milar han tetek esi? Anasa a warwarala na lalaun tikin anumi ka. ");
INSERT INTO lbb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mila ka tortorot pa mila tasmani mang u a Tena Totoh ane God.” ");
INSERT INTO lbb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","E Iesu i atai la mange, “Ia ka aslang pas mulo ning a bonot pa pisir naur a kakak a asaerla, gepi? Ika takai omulo a mot ka!” ");
INSERT INTO lbb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I warwara oe Judas, a nat e Saimon Iskariot, takai miting na ning a bonot pa pisir naur a kakak a asaer, ning ir saran tar e Iesu uting na kuna hiruala. ");
INSERT INTO lbb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lamur tana, e Iesu i taltal ting na hananuala tumo e Galili. Bel i mang sur ir taltal saot na papar Judia, anasa dingla na Juda la sang sur lar umkoli. ");
INSERT INTO lbb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ning a lotu na Palturturup anuna tarai Judala ka milau, ");
INSERT INTO lbb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","na tastasna e Iesu la atai i mange, “I wakak sur ur kamtur mite pa ur han usaot e Judia sur anum a kakak a asaer lar oroi a ututna na kulkulan ning ur toli. ");
INSERT INTO lbb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ning tik i mang sur a tarai lar tasmani, bel i sira tol kumnan a ututnala. Ning u sira tol a ututnala ne, i wakak ning ur tol talapori sur a taraila te na rakrakan hanua rop lar tasman u!” ");
INSERT INTO lbb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Na tastasna la warwara larne, anasa la otleng bel la tortorot onoi. ");
INSERT INTO lbb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","E Iesu i atai la mange, “Anuk a taim belot i sot sur ar han, ika tetek mulo, a pukakiarla i langolango ka sur mulor han. ");
INSERT INTO lbb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A taraila te na rakrakan hanua bel lar nget mulo, ika la nget iau, anasa a atai la ana nunla na toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mulo, mulor han usaot na lotu na Palturturup. Iau bel ar han kapit, anasa anuk a taim belot i sot.” ");
INSERT INTO lbb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ning ka warwara tar, i kes suai tumo e Galili. ");
INSERT INTO lbb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ning na tastasna e Iesu la ka han sur a lotu na Palturturup, e Iesu i mur la, ika bel i asangan talapori tetek a taraila. I han kumna ka. ");
INSERT INTO lbb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Dingla na Juda la tai sur e Iesu ting na lotu, la deke mang, “A barsan ne kanahaia?” ");
INSERT INTO lbb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A galis a tarai la wasisik oe Iesu. Dingla na tarai la atongi mang, “Ai a wakak a barsan,” pa dingla otleng la atongi mang, “Bel i a wakak a barsan. I sira asongo a taraila ka.” ");
INSERT INTO lbb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pa bel tik i warwara talapor onoi, anasa la matatan dingla na tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ning la ka kes potor ana pukakiarla na lotu na Palturturup, e Iesu i kas uting na woroh na rumai artabar, pa i turpas a asaer a taraila. ");
INSERT INTO lbb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Dingla na tarai Juda la kulkulan kol pa la deke mange, “A barsan ne bel i asaer pas. I tasman mangasa a tastasmanla ne?” ");
INSERT INTO lbb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","E Iesu i keles la mange, “A asaerla ne a asaer ono, bel anuki, anun esaning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ning tik i mang sur ir mur a nuknuk e God, ir tasman lalani, mang anuk a asaer ne ta e God, o mite ka na nuknukik. ");
INSERT INTO lbb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Esining i warwara ka ana nuknukna, i mang ka sur dir aleklek pasi. Ika esining i mang sur dir aleklek pas e God ning i sune i ute, i atong a momolna, pa bel ta asasongo tingia. ");
INSERT INTO lbb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","E Moses ka saran tar a Warkuraila tamulo, ika bel tik ta halimulo i muri. Sur asa mulo mang sur mulor umkol iau?” ");
INSERT INTO lbb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A kunum a tarai la kelesi mange, “A mot ka solong tar u. Esi i mang sur ir umkol u?” ");
INSERT INTO lbb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","E Iesu i keles la mange, “A tol ning a utna na kulkulan, pa mulo kulkulan rop onoi. ");
INSERT INTO lbb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","E Moses i saran tar a warkurai tamulo sur mulor kot a palaona kakak barsanla. Ika a warkurai ne, bel ane Moses, a taraila ot nating la turpasi. Pa dingla na Pukakiar Sabat otleng mulo kot a palaona kakak barsanla. ");
INSERT INTO lbb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mulo sira kot a palaona kakak barsanla ana Pukakiar Sabat, sur gong di lakai a warkurai ane Moses. Ning mulo toli larne, sur asa mulo balakut tetek iau ning a alangolango pas a barsan ana Pukakiar Sabat? ");
INSERT INTO lbb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gong mulo warkurai ana numulo na tatatai ka, mulor warkurai ana warkurai ning i tostos.” ");
INSERT INTO lbb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Dingla na tarai misaot e Jerusalem la deke mange, “I ka a barsan ning la mang sur lar umkoli, gepi? ");
INSERT INTO lbb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Oroi, onone i tur pa i warwara na matana taraila, pa bel la kelesi. Ngandek na ningnigo la ka tasmani mang ai a Karisito? ");
INSERT INTO lbb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ning a Karisito ir hanot, bel tik ir tasmani mang ir hanot mitaha. Ika a barsan ne dala tasman ka a hanua ngasna.” ");
INSERT INTO lbb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kaning ot e Iesu i asaer ting na woroh na rumai artabar, i warwara kol mange, “I mangasa, mulo tasman momol iau ot, pa hanua otleng ning a han mitingia? Bel a hanot ute ana nuknukik. Esaning i sune iau i atong a momolna. Pa mulo, bel mulo tasman esaning i sune iau. ");
INSERT INTO lbb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ika iau, a tasmani, anasa a han misaot tana pa i ot i sune iau.” ");
INSERT INTO lbb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pa tarai Juda la mang sur lar tong akes pasi, ika bel tik i toli, anasa anuna taim belot i sot. ");
INSERT INTO lbb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A galis miting na kunum a tarai la tortorot oe Iesu pa la atongi mange, “A barsan ne i tol tar a galis a akinalangla. Ngandek a Karisito ot ne?” ");
INSERT INTO lbb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ning a Parisaiola la longor a kunum a tarai la wasisik larne oe Iesu, a leklek a tena artabarla pa Parisaiola, la sune sen a tena tai alarla tagun a rumai artabar, sur lar tong akes pasi. ");
INSERT INTO lbb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pa e Iesu i atai la mange, “Bel ar kes bongnan iau napirimulo, ar han ulak tetek esaning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mulor tai sur iau, ika bel mulor oroi tetek iau. Pa hanua ning ar han suri, bel mulo tolsot sur mulor han tingia.” ");
INSERT INTO lbb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dingla na tarai Juda la deke artalai la mange, “A barsan ne ir han ma utaha, ning bel dalar pasteki? Ir han uting na hananuala anuna tarai Grik, ning anundala na tarai la kes ia? Ngandek ir asaer a tarai Grik? ");
INSERT INTO lbb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","I atongi mang dalar tai suri, ika bel dalar pasteki, pa bel dala tolsot sur dalar han otleng uting na hanua ning ir kes ia. Esi na kamkama warwara ne?” ");
INSERT INTO lbb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ana ararop a pukakiar ana lotu na Palturturup, a pukakiar ning i itna kol, e Iesu i tur pa i warwara kol mange, “Ning tik ir mos, i wakak sur ir han tetek iau par agangi. ");
INSERT INTO lbb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Esining ir tortorot hok, ‘na malum a lalaun lar dun ot miting na nuna lalaun,’ larning di ka tumus tari ting na Buk Tabu.” ");
INSERT INTO lbb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","E Iesu i warwara ana Talngan Tabu. La ning la tortorot o e Iesu lamur dir tabar la ono. Belot di saran a Talngan Tabu, anasa e Iesu belot i kibas anuna matatar. ");
INSERT INTO lbb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dingla na taraila miting na kunum ning la longor a warwara ne, la atongi mange, “A momolna ot, a barsan ne a propet ning e God i sune i ute.” ");
INSERT INTO lbb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dingla otleng la atongi mang, “Ai a Karisito.” Pa dingla la atongi mang, “ A Karisito bel ir hanot mitumo e Galili. ");
INSERT INTO lbb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","A Buk Tabu i atongi mange, a Karisito ir hanot miting na mangis a tarai ane Dewit. Ir hanot mitumo e Betlihem, a hanua ning nating e Dewit i kes ia.” ");
INSERT INTO lbb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pa la taptapagal anasa oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Dingla na tarai la mang sur lar tong akesi, ika bel ta halinla i tolsoti. ");
INSERT INTO lbb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ning na tena tai alar miting na rumai artabar la ulak, a leklek a tena artabarla tetek e God pa Parisaiola la deken la mange, “Sur asa bel mulo dat pas e Iesu ute?” ");
INSERT INTO lbb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","A tena tai alarla miting na rumai artabar la keles la mange, “Bel tik i sira warwara lar a barsan ne!” ");
INSERT INTO lbb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A Parisaiola la deken la mange, “Mangasa, mulo otleng ka ben rongon pas mulo? ");
INSERT INTO lbb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mangasa mulo nuki mang ta halimila a ningnigola pa Parisaiola ka tortorot onoi? Bel! ");
INSERT INTO lbb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A kunum a taraila ne, ning la tortorot oe Iesu, bel la tasman a Warkuraila ane Moses. A balakut ane God i kes onla.” ");
INSERT INTO lbb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ning a hala Parisaiola, a risana e Nikadimos, esaning nating i hanot pas tetek e Iesu, i atai la mange, ");
INSERT INTO lbb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ana warkurai anundala, bel dalar tiu oros ka tik ning belot di longori, sur dir talapor ana saning i toli.” ");
INSERT INTO lbb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","La kelesi ka mange, “Ge, u otleng mitumo e Galili? Ur asaer ana Buk Tabu pa ur mananos onoi mang a propet bel i hanot mitumo e Galili.”  ");
INSERT INTO lbb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pa taraila rop la han sarara sur anunla na hananua. ");
INSERT INTO lbb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ika e Iesu i han kas usaot na Mangir Oliw. ");
INSERT INTO lbb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ana kobot ning ot ana pukakiar lamur, e Iesu i hanot ulak ting na woroh na rumai artabar, pa taraila rop la han taum teteki. I kes pa i asaer la. ");
INSERT INTO lbb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A tena asaerla tagun a warkurai pa Parisaiola, la ben kas pas ning a hane tetek e Iesu. A hane ning di pastetek pasi ning i tol a toltol laulau taum ning a barsan. La arakrakai pasi sur ir tur salanigo na matana taraila. ");
INSERT INTO lbb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","La atai e Iesu mange, “Tena Asaer, a hane ne di pastek pasi ning i tol a toltol laulau taum ning a barsan. ");
INSERT INTO lbb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ana warkurai ane Moses, ning ta hane ir toli manglarning, dir wolot amati ana hatatla. Pa u, ur atong asa onoi?” ");
INSERT INTO lbb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","La dekeni larning, anasa la mang sur lar toho e Iesu, sur ta warwara ir atongi, pa lar tiwi ono. Ika e Iesu i tudu purum, pa i tumtumus ana pitlai kuna ting na kabalapiu. ");
INSERT INTO lbb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ning la dekeni pa la dekeni larning, i tur pa i atai la mange, “Ning tik ta halimulo bel i tol tar ta toltol laulau, ir wolot nigon a hane ne ana ta hat.” ");
INSERT INTO lbb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","E Iesu i tudu purum ulak, pa i tumtumus ulak ting na kabalapiu. ");
INSERT INTO lbb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ning la longor a warwara ne, la rop la purum taktakai. A lapunla la purum nigo, tuk e Iesu kama kaning ia, taum ana hane ning di atur tari napirna. ");
INSERT INTO lbb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","E Iesu i tur, pa i deken a hane ning mange, “Lak, la ning la tiu u, la kanaha ma? Bel ta halinla i warkurai u?” ");
INSERT INTO lbb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A hane i kelesi mange, “Bel.” Pa e Iesu i atai i mange, “Iau otleng bel ar warkurai u. Ur han, pa gong ulak u tol tar ta toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","E Iesu i warwara ulak tetek a taraila, pa i atongi mange, “Iau a talapor anuna rakrakan hanua. Esining i mur iau, bel ir han ting na mormorom, ir kibas a talapor ana lalaun.” ");
INSERT INTO lbb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A Parisaiola la atai i mange, “Anum a warwara talapor hom bel i mamahat, anasa u ot u warwara.” ");
INSERT INTO lbb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pa e Iesu i keles la mange, “Ning iau ot a warwara talapor hok, anuk a warwara talapor i momol, anasa iau ot a tasman a hanua ning a han mitingia, pa hanua ning ar han suri. Ika mulo, bel mulo tasman a hanua ning a han mitingia, pa hanua ning ar han suri. ");
INSERT INTO lbb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mulo, mulo warkurai ka ana warkurai anuna taraila, ika iau bel a warkurai tik. ");
INSERT INTO lbb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ika ning ar warkurai, anuk a warkurai ir tostos, anasa bel iau ka a toli, miau ot ma e Tata, ning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Di ka tumus tari ting na numulo a warkurai mange, ‘Ning a warwara anuna naur i arlar ka ana ta utna, anundiau a warwara i momol.’ ");
INSERT INTO lbb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Iau ne a warwara talapor hok, pa e Tata ning i sune iau ute, i otleng i warwara talapor hok.” ");
INSERT INTO lbb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","La dekeni mange, “E tamam kanaha?” E Iesu i keles la mange, “Bel mulo tasman iau, pa bel mulo tasman otleng e Tata. Ning mulor tasman iau, mulor tasman e Tata otleng.” ");
INSERT INTO lbb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","E Iesu i atong a warwarala ne ting na rumai artabar, ting na pukna ning di sira suah mani na artabar ono. Ika bel tik i tong akesi, anasa anuna taim belot i sot. ");
INSERT INTO lbb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","E Iesu i atai ulak a taraila mange, “Ar han kusun mulo, mulor tai sur iau, pa mulor mat taum ana numulo na toltol laulau. A hanua ning ar han suri, bel mulo tolsot sur mulor han tingia.” ");
INSERT INTO lbb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dingla na tarai Juda la atongi mange, “Asa kamkamna ning i atongi mang, ‘A hanua ning ar han suri, bel mulor tolsot sur mulor han tingia’? Ngandek ir umkol pasi ma?” ");
INSERT INTO lbb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","E Iesu i keles la mange, “Mulo mite lapiu, pa iau, misaot. Mulo mite na rakrakan hanua, iau bel mite na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ine a kamkamna ning a atai mulo mang mulor mat ana numulo na toltol laulau. Ning bel mulo tortorot hok mang iau ot ne, mulor mat taum ana numulo na toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pa la dekeni mange, “Esi u?” E Iesu i keles la mange, “Ia ka atai tar mulo turpasi ana kamkama nuk a titol, tuk onone. ");
INSERT INTO lbb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","A galis a utna ar atongi omulo ning ar warkurai mulo onoi, anasa esaning i sune iau i momol, pa iau, a atai ka a taraila te na rakrakan hanua ana saning a longori tana.” ");
INSERT INTO lbb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bel la tasmani mang e Iesu i warwara tetek la oe Tamana. ");
INSERT INTO lbb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pa e Iesu i atongi mange, “Ning mulor akulam a Nat a Barsan saot, mulor tasmani mang iau ning, pa mulor tasmani otleng mang bel a tol ta utna ana nuknukik, e Tata i asaer iau ana saning a atongi. ");
INSERT INTO lbb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Esaning i sune iau i kes taum hok, bel i han kusun iau, anasa a sira tol asaning i gas onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A galis ning la longor a warwarala ne, la tortorot oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","E Iesu i atai a tarai Juda ning la tortorot onoi mange, “Ning mulor kibas anuk a asaerla, mulo anuk na tarai a asaer momol. ");
INSERT INTO lbb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pa mulor tasman a momolna, pa momolna ir alangolango mulo.” ");
INSERT INTO lbb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","La keles e Iesu mange, “Mila na tumtubuna e Abaram, bel mila titol lar a tena titol orosla tana tik tuk onone. Asa kamkamna ning u atongi mang a momolna ir alangolango mila?” ");
INSERT INTO lbb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","E Iesu i keles la mange, “A atong momoli tamulo, la rop ning la tol na toltol laulau, la na tena titol oros ana toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A tena titol oros tetek ta kabaitamana, bel ir kes tikin tetek la, ika ning ir naur a suana ta natundiau, i ning tagun diau momol. ");
INSERT INTO lbb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ning a Nat e God i alangolango mulo, mulor langolango momol. ");
INSERT INTO lbb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A tasmani ot mang mulo na tumtubuna e Abaram. Ika, mulo sang sur mulor umkol iau, anasa anuk a warwara bel i kes omulo. ");
INSERT INTO lbb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A warwara ana saning a oroi ta e Tata, pa mulo otleng, mulo tol asaning mulo longori ta e tamamulo.” ");
INSERT INTO lbb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","La kelesi mange, “E Abaram a tamamila.” E Iesu i keles la mange, “Ning e Abaram a tamamulo momol, mulor tol asaning i toli. ");
INSERT INTO lbb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mulo mang sur mulor umkol iau, anasa a atai mulo ana momolna ning a longori ta e God. E Abaram bel i tol ta utna larne. ");
INSERT INTO lbb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mulo, mulo tol ot a titolla ning a tamamulo i toli.” La keles e Iesu mange, “Bel di agon oros mila ka ting na ngas, tamamila ot e God.” ");
INSERT INTO lbb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","E Iesu i atai la mang, “Ning e God a Tamamulo, mulor mang sur iau, anasa a han misaot ta e God, pa onone a kes te. Bel a hanot ana nuknukik, i ot i sune iau. ");
INSERT INTO lbb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sur asa bel mulo tasman lalan anuk a warwara? Anasa bel mulo tolsot sur mulor longor asaning a atongi. ");
INSERT INTO lbb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","E tamamulo e Satan, pa mulo mang ot sur mulor mur na nuknukna. Tagun nating ot, ai a tena umkol a taraila, pa bel i tasman a momolna, anasa bel ta momolna i kes onoi. Ning i asasongo, i warwara ana nuna warwara momol ot, anasa i ot a tena asasongo pa tamana asasongo. ");
INSERT INTO lbb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bel mulo tortorot hok, anasa a atong a momolna. ");
INSERT INTO lbb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Esi na halimulo ir tiu sot pas iau ana ta toltol laulau? Ning a atong a momolna, i mangasa ning bel mulo tortorot hok? ");
INSERT INTO lbb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Esining ane God i longor a warwarala ane God. Ika mulo, bel mulo longori, anasa bel mulo ane God.” ");
INSERT INTO lbb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dingla na tarai Juda la atai e Iesu mange, “Mila tasman momoli mang u a te Samaria, pa mot kaning hom.” ");
INSERT INTO lbb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pa e Iesu i keles la mange, “Bel ta mot kane hok. A hanrawai e Tata, ika mulo, bel mulo hanrawai iau. ");
INSERT INTO lbb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Bel a mang sur a tarai lar aleklek pas iau, ika takai sot ka, a tnan tena warkurai, ir aleklek pas iau. ");
INSERT INTO lbb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A atong momoli tamulo, esining ir mur anuk a warwara, bel ir mat.” ");
INSERT INTO lbb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dingla na tarai Juda la atai i mange, “Onone mila tasman momoli mang a mot kaning hom! E Abaram ka mat, pa propetla otleng la ka mat, ika u atongi mang esining ir mur anum a warwara bel ir mat. ");
INSERT INTO lbb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mangasa, u nuki mang u leklek tana tamamila e Abaram? E Abaram ka mat, pa propetla otleng la ka mat. U nuki mang u esi na ngas a barsan?” ");
INSERT INTO lbb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","E Iesu i keles la mange, “Ning ar aleklek pas iau ot, anuk a warwara bel i to pas ta utna. E Tata ot ir aleklek pas iau, esaning mulo atongi mang anumulo a God. ");
INSERT INTO lbb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mulo, bel mulo tasman e God, ika iau, a tasmani. Ning ar atongi mang bel a tasmani, iau otleng a tena asasongo lar mulo. A tasman e God, pa a mur anuna warwarala. ");
INSERT INTO lbb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tamamulo e Abaram i gas sur ir oroi anuk a tinan ot. I oroi, pa i gas kol onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A tarai Juda la atai i mange, “Belot i dilima na bonot a rau a lalaun anumi. I mangasa ning u atongi mang u ka oroi tar e Abaram?” ");
INSERT INTO lbb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","E Iesu i keles la mange, “A atong momoli tamulo, ning belot di agon e Abaram, ia ka laun nigo tar.” ");
INSERT INTO lbb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ning e Iesu i atongi larne, la los pas a hatatla sur lar woloti, ika i mumun pa i han kusun a rumai artabar. ");
INSERT INTO lbb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ning e Iesu i han amon, i oroi pas ning a barsan, ning e tana i agoni a kut. ");
INSERT INTO lbb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Anuna kakak a asaer la dekeni mange, “Tena Asaer, asa kamkamna ning di agon pasi ka kut? Esi i tol a toltol laulau? I ot, o e tamana pa e tana?” ");
INSERT INTO lbb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","E Iesu i atongi mange, “A barsan ne bel i tol ta toltol laulau, e tamana pa e tana otleng bel. I kut ka sur a tarai lar oroi a rakrakai a titol ane God onoi. ");
INSERT INTO lbb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ning kanet i kabakiar, i wakak sur dalar tol a titolla anun esaning i sune iau ute. Ning kar morom, bel ma tik ir titol. ");
INSERT INTO lbb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ning a kes te na rakrakan hanua, iau a talapor anuna rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ning e Iesu ka atong tari larne, i namis ting lapiu, i gis pas a namisna taum ana kabalapiu, pa i sabari ting na naur a matana. ");
INSERT INTO lbb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","E Iesu i atai i mange, “Ur han, pa ur gos pas naur a matam ting na kabapolo Siloam.” (Siloam a kamkamna mang di arsune.) Pa i han, i gos pas naur a matana. Ning i ulak, ka tai. ");
INSERT INTO lbb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na halalna pa taraila ning la oroi tari nating ning i sira nunung utna, la deke mange, “Ngandek i ka a barsan ning i kes pa i sira nunung, gepi?” ");
INSERT INTO lbb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dingla na tarai la atongi mange, “Ai ot ning.” Dingla otleng la atongi mange, “Bel. I tai arlar ka ana barsan ning.” Ika, i ot i atongi mang, “Iau ka.” ");
INSERT INTO lbb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","La dekeni mange, “Di apalpalas mangmangasa naur a matam?” ");
INSERT INTO lbb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I keles la mange, “A barsan ning di atongi e Iesu, i gis pas a namisna taum ana kabalapiu, pa i sabar tar naur a matak ono. Pa i atai iau mange, ‘Ur han utumo na kabapolo Siloam sur ur gos pas naur a matam.’ Pa a han, a gos pas naur a matak, pa a tai kakat.” ");
INSERT INTO lbb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","La dekeni mange, “Kanaha ma a barsan ning?” I keles la mange, “Bel a tasmani.” ");
INSERT INTO lbb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","La ben pas a barsan ning nating i kut tetek a Parisaiola, ");
INSERT INTO lbb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","anasa e Iesu i gis pas a namisna taum ana kabalapiu, pa i apalpalas pas naur a matana ana Pukakiar Sabat. ");
INSERT INTO lbb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","A Parisaiola otleng la deken a barsan ning mange, “Di apalpalas mangmangasa pas naur a matam?” I keles la mange, “I sabar tar naur a matak ana kabalapiu ning i gis pasi taum ana namisna, pa a gos pasi, pa a tai.” ");
INSERT INTO lbb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dingla na Parisaio la atongi mange, “A barsan ning i tol a utna ne, bel misaot ta e God, anasa i titol ana Pukakiar Sabat.” Dingla na taraila otleng la atongi mange, “Ning a barsan ne a laulau a barsan, ir tol mangmangasa a akinalangla ne?” Pa la taptapagal. ");
INSERT INTO lbb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lamur na Parisaio la deken a barsan ning mange, “Ur atong asa ana barsan ning i apalpalas pas naur a matam?” I keles la mange, “Ai a propet.” ");
INSERT INTO lbb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Dingla na tarai Juda bel la tortorot mang, a barsan ne lanigo i kut pa di apalpalas a matana. Pa la arsune pas e tamana pa e tana, pa la deken diau mange, ");
INSERT INTO lbb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“A natumu ine, ning mu atongi mang mu agon pasi ka kut? Asa kamkamna ning onone ka tai?” ");
INSERT INTO lbb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","E tamana pa e tana dia keles la mange, “Mia tasmani mang a natumiau ot ne, pa mia tasmani mang mia agon pasi ka kut. ");
INSERT INTO lbb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ika bel mia tasmani mang i tai mangmangasa, bel mia tasmani otleng mang esining i apalpalas pas naur a matana. Ka itna, mulor dekeni, i ot ir warwara talapor onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","E tamana pa e tana dia warwara larne, anasa dia matatan a tarai Juda, ning la atongi mang, ning tik ir tortorot oe Iesu mang ai a Karisito, dir sairasi kusun a rumai lotu. ");
INSERT INTO lbb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ine a kamkamna ning e tamana pa e tana dia atongi mang, “Ka itna, mulor dekeni.” ");
INSERT INTO lbb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Munaur ono la ben ulak pas a barsan ning di agon pasi ka kut, pa la atai i mange, “Ur aleklek e God ana saning i toli hom! Mila tasmani mang a barsan ning i apalpalas pas naur a matam, a tena tol a toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","I keles la mange, “Bel a tasmani mang a tena tol a toltol laulau o bel. Ning a utna ka a tasmani: Nating a kut, pa onone ia ka tai.” ");
INSERT INTO lbb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","La dekeni mange, “Asaning i toli hom? I apalpalas mangasa pas naur a matam?” ");
INSERT INTO lbb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","I keles la mange, “Ia ka atong tari tamulo, pa bel mulo longori. Sur asa mulo mang sur mulor longor ulaki? Ngandek mulo otleng mulo mang sur mulo anuna kakak a asaerla?” ");
INSERT INTO lbb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","La anani, pa la atongi mange, “U a kaklik asaer anunai, ika mila a kakak a asaerla ane Moses. ");
INSERT INTO lbb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mila tasmani mang e God i warwara tetek e Moses, ika a barsan ning bel mila tasmani mang i han mitaha.” ");
INSERT INTO lbb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A barsan i keles la mange, “Ine a utna na kulkulan! Bel mulo tasmani mang i han mitaha, ika ka apalpalas pas naur a matak. ");
INSERT INTO lbb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dala tasmani mang e God bel ir longor a niaring anuna tena tol a toltol laulau, ir longor ka esining i hanrawai i pa i sira mur a nuknukna. ");
INSERT INTO lbb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nating ot tuk onone, bel di tasman tar tik ning ir apalpalas pas ta kut, ning di agon pasi ka kut. ");
INSERT INTO lbb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ning a barsan ne bel misaot ta e God, bel ir tolsot pas ta utna.” ");
INSERT INTO lbb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","La kelesi mange, “Di agon pas u ana toltol laulau, pa u mang sur ur asaer mila!” Pa la kepseni kusun a rumai lotu. ");
INSERT INTO lbb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ning e Iesu i longori mang di ka kepsen a barsan ning, i tai suri. Ning ka pastek pasi, i dekeni mange, “U tortorot ot ona Nat a Barsan?” ");
INSERT INTO lbb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","I kelesi mange, “Leklek, ur atai iau, ‘Esi a Nat a Barsan?’, sur ar tortorot onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","E Iesu i kelesi mange, “Onone u ka oroi i, iau ka ne a warwara tam.” ");
INSERT INTO lbb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A barsan ning i atongi mang, “Leklek, a tortorot!” I kes ana naur a bokona hana pa i lotu teteki. ");
INSERT INTO lbb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","E Iesu i atongi mange, “A hanot ute na rakrakan hanua sur ar saran a warkurai mang: la ning la kut lar tai, pa la ning la tai lar kut.” ");
INSERT INTO lbb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Dingla na Parisaio kaning taum ono, la longor a warwara ne, pa la dekeni mange, “U nuki mang mila otleng mila kut?” ");
INSERT INTO lbb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","I keles la mange, “ Ning mulor kut bel tik ir tiu mulo ana ta toltol laulau. Ika onone mulo atongi mang mulo tai. I maining anumulo na toltol laulau kaning ot i kes.” ");
INSERT INTO lbb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","E Iesu i atongi mange, “A atong momoli tamulo, esining bel i kas ting na taman a woroh na sipsip, pa i abit kas ka usaui, ai a tena kinkinau pa tena ras oros a ututnala. ");
INSERT INTO lbb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ika a barsan ning i kas tostos ting na taman, a tena tai alar momol anuna sipsipla. ");
INSERT INTO lbb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A tena tai alar miting na taman ir sapang pasi sur ir kas. A sipsipla la longor lalan a elngena. I kabah la ana risanla, pa i ben purum la. ");
INSERT INTO lbb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ning ka ben purum rop pas anuna sipsipla, i nigon la pa la muri, anasa la longor lalan a elngena. ");
INSERT INTO lbb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bel lar mur ta wasira, lar liu kusuni ka, anasa bel la longor lalan a elngena.” ");
INSERT INTO lbb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","E Iesu i atong a warwara larlar ne tanla, ika bel la kibas lalan asaning i warwara larlar onoi. ");
INSERT INTO lbb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","I maining e Iesu i atong ulaki mange, “A atong momoli tamulo, iau a taman anuna sipsipla. ");
INSERT INTO lbb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","La rop ning la hanot nigo tak, a tena kinkinaula pa tena ras oros pas a ututnala, ika a sipsipla bel la longor tanla. ");
INSERT INTO lbb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iau a taman. Esining ir han tetek iau pa ir kas te hok dir alauni. Ir kas, pa ir purum pa ir pastek ana utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A tena kinkinau i hanot ka sur ir kinkinau, pa ir umkol a sipsipla pa ir alaulau la. Ika iau, a hanot sur lar kibas a lalaun, a lalaun ning i bukus ana wakakna. ");
INSERT INTO lbb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iau a wakak a tena tai alar anuna sipsipla. A saran tar anuk a lalaun sur ar mat sur la. ");
INSERT INTO lbb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","A barsan ning di lowi ka, bel a tena tai alar momol anuna sipsipla, pa sipsipla bel anunai. Ning ir oroi pas ta ngalngaliah na pap ir hanot, ir liu ka kusun a sipsipla, anasa i titol ka sur a mani, pa bel i nuknuk sur a sipsipla. Pa ngalngaliah na pap ir harat la pa ir lu sauran la. ");
INSERT INTO lbb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Iau a wakak a tena tai alar anuna sipsipla. A tasman anuk a sipsipla, pa anuk a sipsipla otleng la tasman iau, ");
INSERT INTO lbb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","arlar lar e Tata i tasman iau, pa iau a tasmani, pa a saran tar anuk a lalaun sur ar mat sur la. ");
INSERT INTO lbb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Anuk dingla na sipsip otleng, bel la kes ting na woroh na sipsip ne. Ar ben pas la otleng, pa lar longor a elngek, sur la rop lar kes ka ana takai a woroh, pa takai sot ka ir tena tai alar anunla. ");
INSERT INTO lbb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“E Tata i mang sur iau, anasa iau ot a saran tar anuk a lalaun, sur lamur ar los ulak pasi. ");
INSERT INTO lbb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Bel tik ir kepsen anuk a lalaun, iau ot ar saran tari. Iau ot a warkurai sur ar saran tari, par los ulak pasi. A titol ne ning e Tata i sune iau sur ar toli.” ");
INSERT INTO lbb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A tarai Juda la taptapagal ana warwarala ane Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A galis onla, la atongi mange, “A mot i solongi, pa nuknukna ka talar. Sur asaning mulo longor pasi?” ");
INSERT INTO lbb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dingla na tarai la atongi mange, “A ngas a warwara ne bel anuna tik ning a mot i kas tar onoi. Mangasa, tik ning a mot i kas onoi i tolsot sur ir apalpalas a matana kutla?” ");
INSERT INTO lbb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lamur la tol a tnan lotu sur lar nuk pas a pukakiar ning la sapang a rumai artabar onoi. La tol a lotu ne saot e Jerusalem ana kalang na kotkoto. ");
INSERT INTO lbb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","E Iesu i han amon ting na parada ane Solomon ting na rumai artabar. ");
INSERT INTO lbb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A tarai Juda la tur talilis pasi, pa la dekeni mange, “Nangse ma ur atai momol mila? Ning u a Karisito, ur atai talapor mila.” ");
INSERT INTO lbb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","E Iesu i keles la mange, “Ia ka atong tari tamulo, ika bel mulo tortorot. A titolla ning a toli ana risana e Tata, la warwara talapor hok. ");
INSERT INTO lbb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ika bel mulo tortorot, anasa mulo bel anuk a sipsipla. ");
INSERT INTO lbb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Anuk na sipsip la longor a elngek, pa a tasman la, pa la sira mur iau. ");
INSERT INTO lbb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A saran a lalaun tikin tanla, pa bel lar hirua. Pa bel tik ir rasen la kusun a kuk. ");
INSERT INTO lbb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","E Tata ning i saran tar la tak, i leklek tana ututnala rop, pa bel tik ir rasen la kusun a kuna. ");
INSERT INTO lbb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Miau ma e Tata, miau takai ka.” ");
INSERT INTO lbb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","A tarai Juda la los ulak pas a hatatla sur lar wolot e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","E Iesu i atai la mange, “Ia ka asangan tar a galis a ututnala na kulkulan na matamulo, ning e Tata i saran tari tak sur ar toli. Esi na utna mite na ututnala ne, ning mulo mang sur mulor wolot iau onoi?” ");
INSERT INTO lbb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","La kelesi mange, “Mila mang sur milar wolot u, bel i kamkamna ana ta utna na kulkulan ning u toli, i kamkamna mang u anatarna pas e God! U a barsan ka u, pa u atongi mang u e God.” ");
INSERT INTO lbb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","E Iesu i atai la mange, “Mulo tasmani ot mang di ka tumus tari ana numulo na Warkurai mang e God i atongi mang ‘Mulo a godla’. ");
INSERT INTO lbb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","I atong la mang la a godla, la ning di saran tar a warwarala ane God tanla. Bel tik i tolsot sur ir kepsen a warwara na Buk Tabu. ");
INSERT INTO lbb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Pa iau, e Tata ot i aslang pas iau, pa i sune iau ute na rakrakan hanua. Pa sur asa mulo tiu iau mang a warwara laulau oe God, ning a atongi mang iau a Nat e God? ");
INSERT INTO lbb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ning bel a tol a titolla ane Tata, gong mulo tortorot hok. ");
INSERT INTO lbb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","A tol ot anuna titolla. Ika ning bel mulo tortorot ana nuk a warwara, mulor tortorot hok anasa ana titolla ning a toli, sur mulor tasmani mang e Tata kane hok, pa iau kaning ono.” ");
INSERT INTO lbb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Lamur la mang ulak sur lar tong akesi, ika i han ka kusun la. ");
INSERT INTO lbb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","E Iesu i kotop ulak a malum Jodan sur a pukna ning e Jon i sira baptais nigo ono, pa i kes tingia. ");
INSERT INTO lbb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A galis a tarai la han tetek e Iesu pa la atongi mange, “E Jon bel i tol al akinalang, ika a warwarala rop ning i atongi ana barsan ne, i momol ot.” ");
INSERT INTO lbb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pa galis a taraila tingia la tortorot oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ning a barsan mitumo e Betani, a risana e Lasarus, i kurah. Latas ma e Maria pa e Mata. E Maria ning i pek tar a malum na tomtoboh ting na naur a hana Leklek, pa i sah sengsenge diau ana hihna. ");
INSERT INTO lbb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ditas hane dia sarai warwara sur e Iesu mange, “Leklek, a halim ning u katnani i kurah.” ");
INSERT INTO lbb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ning e Iesu i longori, i atongi mange, “E Lasarus bel ir mat ana tinsaman ne. I kurah ka sur dir oroi a matatar ane God, sur a matatar a Nat e God ir hanot talapor.” ");
INSERT INTO lbb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","E Iesu i maris e Mata pa tasna hane e Maria pa tasindiau e Lasarus. ");
INSERT INTO lbb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ning ka longor tari mang e Lasarus i kurah, i kes ulak pas naur a pukakiar ting na hanua ning i kes ia. ");
INSERT INTO lbb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lamur e Iesu i atai a kakak a asaerla mange, “Dalar ulak utumo na papar Judia.” ");
INSERT INTO lbb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pa la atai i mange, “Tena Asaer, nating ka a tarai Juda la mang sur lar wolot amat u, pa onone u mang sur ulak utumo?” ");
INSERT INTO lbb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","E Iesu i keles la mange, “Ning a pukakiar i arlar ana ning a bonot pa pisir naur a awa (12 awa) gepi? Ning tik ir taltal ana kamis bel ir buh a hana, anasa i tai ana talapor te na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ika ning tik ir taltal ana morom ir loloko, anasa bel ta talapor.” ");
INSERT INTO lbb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lamur i atongi otleng mange, “A halindala e Lasarus ka borbor duman, par han sur ar amata pasi.” ");
INSERT INTO lbb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A kakak a asaer la kelesi mange, “Leklek, ning i borbor duman ka, ir langolango ulak ka.” ");
INSERT INTO lbb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","E Iesu i warwara ana minat e Lasarus, ika a kakak a asaer la nuki mang e Lasarus i borbor duman ka. ");
INSERT INTO lbb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pa e Iesu i atai talapor la mange, “E Lasarus ka mat. ");
INSERT INTO lbb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pa iau, a gas ning bel a kes tumo, sur mulor tortorot. Dalar han teteki.” ");
INSERT INTO lbb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","E Tomas, ning di atongi otleng mang a Kasang, i atai a kakak a asaerla mange, “Dalar han taum sur dala otleng dalar mat taum onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ning e Iesu i hanot, i longori mang di ka akas tar a minat e Lasarus ting na kulam a minat, pa ka diat a pukakiar alari. ");
INSERT INTO lbb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","E Betani i milau ka e Jerusalem, i arlar ka ana natol a kilomita, ");
INSERT INTO lbb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","pa galis a tarai Juda la hanot tetek e Mata pa e Maria sur lar kes amahat diau ana tasindiau ning i mat. ");
INSERT INTO lbb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ning e Mata i longori mang e Iesu kaning ma ot, i purum sur ir han barati, ika e Maria i kes ka ting na rumai. ");
INSERT INTO lbb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","E Mata i atai e Iesu mange, “Leklek, ning ur kes ot te, a tasiklik bel ir mat. ");
INSERT INTO lbb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ika a tasmani mang, ning onone ur nunung e God sur ta utna, ir sarani ka tam.” ");
INSERT INTO lbb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","E Iesu i atai i mange, “A tasimlik ir kamtur ulak ka.” ");
INSERT INTO lbb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","E Mata i kelesi mange, “A tasmani mang ir kamtur ulak ana ararop a pukakiar.” ");
INSERT INTO lbb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","E Iesu i atai i mange, “Iau a lalaun ulak kusun a minat, pa iau a lalaun momol. Esining i tortorot hok, ning ir mat, ir laun ulak, ");
INSERT INTO lbb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","pa esining i laun pa i tortorot hok, bel ir mat. U tortorot ot ana warwara ne?” ");
INSERT INTO lbb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","E Mata i kelesi mange, “Leklek, i momol. A tortorot mang u a Karisito, a Nat e God, ning di ka atai tari mang ir han ute na rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Lamur ning e Mata ka atong tari larne, i ulak pa i kabah kumnan pas e tasna hane e Maria, pa i atai i mange, “A Tena Asaer ka hanot pa i deke sur u.” ");
INSERT INTO lbb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ning e Maria i longori, i purum kapit pa i han teteki. ");
INSERT INTO lbb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","E Iesu belot i hanot ting na hanua, i kaning ot na pukna ning e Mata i pastetek tari ia. ");
INSERT INTO lbb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A tarai Juda ning la kes taum oe Maria ting na rumai sur lar kes amahati, la oroi mang i purum kapit kusun la utumo lapiu, pa la muri. Anasa la nuki mang ir han uting na kulam a minat sur ir domos. ");
INSERT INTO lbb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ning e Maria i hanot ting na pukna ning e Iesu i kes ia, i oroi teteki, i kes ana bokona hana salanigo tana, pa i atongi mange, “Leklek, ning ur kes tar ot te, a tasiklik bel ir mat.” ");
INSERT INTO lbb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ning e Iesu i oroi e Maria pa tarai Juda ning la han taum ono la domos, tingui na inguna i balakut pa balana i mamahat kol. ");
INSERT INTO lbb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","E Iesu i deken la mange, “Mulo aborbor tar a minatna taha?” La kelesi mange, “Leklek, han ute sur ur oroi i.” ");
INSERT INTO lbb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Pa e Iesu i domos. ");
INSERT INTO lbb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A tarai Juda la atongi mange, “Mulo oroi, i katnan koli!” ");
INSERT INTO lbb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ika dingla onla, la mang, “I apalpalas pas a matana kutla, pa i mangasa ning bel i alangolango pas a barsan ne, sur gong i mat?” ");
INSERT INTO lbb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","E Iesu i balmaris kol, ning i hanot ting na kulam a minat. A kulam a minat ning di suah alar tari ana tnan hat. ");
INSERT INTO lbb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","E Iesu i atai la mange, “Mulor lakir sen a hat.” Pa e Mata, a tas a barsan ning i mat, i kelesi mange, “Leklek, kar goh, anasa ka diat a pukakiar alari!” ");
INSERT INTO lbb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","E Iesu i atongi mange, “Mangasa, bel a atai nigon tar u mang, ning ur tortorot, ur oroi a matatar ane God?” ");
INSERT INTO lbb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pa la lakir sen a hat. E Iesu i tadai usaot, pa i atongi mange, “Tata, a atong wakak tetek u, anasa u ka longor iau. ");
INSERT INTO lbb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A tasmani mang u sira longor tak, ika a warwara larne, kamkamna ana taraila ne, sur lar tortorot mang u sune iau.” ");
INSERT INTO lbb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ning ka atong tari larne, i arkabah ana tnan elngena mange, “Lasarus, ur purum!” ");
INSERT INTO lbb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","E Lasarus i purum, taum ana kaba iriris a kaen, pa ning a diah kaen otleng di poroi alar tar a patarna ono. E Iesu i atai la mange, “Mulor pak sen a kaen na minatla kusuni sur ir han.” ");
INSERT INTO lbb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","A galis a tarai Juda ning la kes napire Maria, la oroi a utna ning e Iesu i toli, pa la tortorot onoi. ");
INSERT INTO lbb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ika dingla onla, la han tetek a Parisaiola pa la atai la ana utna ning e Iesu i toli. ");
INSERT INTO lbb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A leklek a tena artabarla tetek e God pa na Parisaio la kabah taum a tarai a kiwung, pa la deken la mange, “Dalar tol asa? A barsan ning i tol a galis a akinalangla. ");
INSERT INTO lbb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ning dalar noreni, a taraila rop lar tortorot ono, pa tarai a harum mitumo e Rom lar hanot pa lar regen sen a rumai artabar anundala pa lar kepsen otleng anundala matanitu.” ");
INSERT INTO lbb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ning a halinla a risana e Kaiapas, a ningnigo na tena artabar tetek e God ana rau ning, i atongi mange, “Bel mulo tastasman. ");
INSERT INTO lbb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bel mulo tasmani mang ir wakak tetek mulo ning tik ir mat alar a tarai, sur gong a tarai Juda rop dalar hirua.” ");
INSERT INTO lbb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Bel i atong orosi ka. I warwara na propet larning, anasa i a ningnigo na tena artabar tetek e God ana rau ning. I warwara oe Iesu mang ir mat sur a tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pa bel la ka, sur a taraila rop otleng ane God ning la kes sarara ting na hananua masik, sur ir ben taum pas la sur lar takai ka. ");
INSERT INTO lbb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ana pukakiar ot ning, a ningnigola ana tarai Juda la turpas a warwara sur al ngas sur lar umkol e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Suri ma i ning e Iesu bel ma i taltal na matanla. I kamtur mitingia, sur a hanua Epraim milau a hanua bel, pa la kes tingia taum ana nuna kakak a asaerla. ");
INSERT INTO lbb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ning ka milau a lotu na Han Lakai anuna tarai Juda, a galis a tarai miting na hananuala la nigo usaot e Jerusalem, sur lar atotoh nigon pas la na matana e God, i arlar ana toltol ana nunla lotu. ");
INSERT INTO lbb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","La tatatai sur e Iesu. Ning la tur taum tar ting na rumai artabar, la deken artalai la mange, “Asa mulo nuki? Ir han ot ute ana lotu, o bel?” ");
INSERT INTO lbb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A leklek a tena artabarla pa na Parisaio la ka sarai warwara tar sur tik ning ka oroi tar e Iesu, ir atatai talapor ono mang i kes taha, sur lar tong akes pasi. ");
INSERT INTO lbb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Diono na pukakiar kaning ot lanigo tana lotu na Han Lakai, e Iesu i hanot saot e Betani, a hanua ane Lasarus, a barsan ning e Iesu i alaun pasi kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pa la tol a utna na hangan na kes taum oe Iesu tingia. E Mata i susuk anlai, pa e Lasarus, ning a halinla ning la kes taum oe Iesu ana utna na hangan. ");
INSERT INTO lbb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","E Maria i los pas a koto na polo na tomtoboh ning di atongi a nad, a matana i abit kol. Pa i peki ting na naur a hana e Iesu, pa i sah diau ana hihna. A tobohna i tatah tingui na rumai. ");
INSERT INTO lbb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ning a halin a kakak a asaerla ane Iesu, e Judas Iskariot, ning ir saran tar e Iesu uting na kuna hiruala, i atongi mange, ");
INSERT INTO lbb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sur asa bel di siuran a tomtoboh ne sur a ngas a arlou miting na ning a rau, sur dir tabar a kapan a tarai ono?” ");
INSERT INTO lbb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Bel i maris a kapan a taraila. I atongi larne, anasa i sira tai alar anunla mani pa i sira kinau kumnani, anasa ai a tena kinkinau. ");
INSERT INTO lbb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ning e Iesu i longor a warwara ane Judas, i kelesi mange, “Noren a hane ning, i tol a titol ne hok sur a pukakiar ning ar mat pa dir akas iau uting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A kapan a tarai lar laun bolbolos taum omulo, ika iau bel ar kes tikin napirimulo.” ");
INSERT INTO lbb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ning a kunum a tarai tagun a tarai Juda la longori mang e Iesu kano e Betani, la han uto. Bel la han sur lar oroi e Iesu ka, la han otleng sur lar oroi e Lasarus, ning e Iesu i alaun pasi kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pa leklek a tena artabarla la wol sur lar umkol e Lasarus otleng, ");
INSERT INTO lbb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","anasa a galis a tarai Juda la han kusun la pa la tortorot oe Iesu, kamkamna oe Lasarus. ");
INSERT INTO lbb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ana pukakiar lamur a tnan kunum a taraila ning la hanot sur a lotu na Han Lakai, la longori mang e Iesu otleng kaning i han amon usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","La los pas a paka baibaila pa la han sur lar barat e Iesu. La kukuk mange, “Hosana! Esaning i hanot ana risan a Leklek i angis. A King anuna tarai Israel i angis!” ");
INSERT INTO lbb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","E Iesu i ben pas a dongki, pa i kes saot onoi, larning a Buk Tabu ka atong tari ono mange, ");
INSERT INTO lbb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“A tarai Saion, gong mulo matmataut. Oroi, anumulo a king i hanot, i kes saot na nat a dongki.” ");
INSERT INTO lbb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A kakak a asaerla ane Iesu bel la tasmani mang a ututnala ning, di ka tumus nigon tari ting na Buk Tabu. Ika, ning e Iesu ka kes ana nuna matatar, la bot nuk lalani mang di ka tumus tar a ututnala ne oe Iesu, pa di ka tol tar a ututnala ne onoi. ");
INSERT INTO lbb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A galis a tarai ning la tur taum oe Iesu ning i kabah purum pas e Lasarus kusun a kulam a minat pa i alaun pasi, la ning la warwara talapor onoi. ");
INSERT INTO lbb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","A galis a tarai la han sur lar barat e Iesu, anasa la ka longor tar a warwara ana akinalang ning. ");
INSERT INTO lbb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","A Parisaiola la atai artalai la mange, “Mulo oroi, bel dalar tolsot pas ta utna ning dala mang sur dalar toli. Anasa a tarai mite na rakrakan hanua rop la ka muri.” ");
INSERT INTO lbb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Dingla na tarai Grik otleng la han usaot e Jerusalem ana lotu na Han Lakai, sur lar lotu. ");
INSERT INTO lbb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pa la han tetek e Pilip, a te Betsaida. E Betsaida a hanua ting na papar Galili. Pa la atai i mange, “Lak, mila mang sur milar oroi e Iesu.” ");
INSERT INTO lbb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","E Pilip i han pa i atai e Endru, pa dia han sur diar atai e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pa e Iesu i keles diau mange, “A pukakiar ka hanot ning dir mermer a Nat a Barsan. ");
INSERT INTO lbb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A atong momoli tamulo, ning a pat a wit bel ir punga ting na kabalapiu pa bel ir mat pas, ir kes ot larning, takai ka. Ika ning ir mat pas, ir wai pa ir suah a galis a patna. ");
INSERT INTO lbb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Esining i mang kol sur anuna lalaun, ir hirua, pa esining i nget anuna lalaun te na rakrakan hanua, ir suahi sur a lalaun tikin. ");
INSERT INTO lbb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Esining ir titol tetek iau, i wakak ning ir mur iau, pa i anuk a tena titol pa ir kes taum hok ting na pukna ning ar kes ia. Esining ir titol tetek iau, e Tata ir aleklek pasi. ");
INSERT INTO lbb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Onone anuk a lalaun i mamahat kol. Asaning ar atongi? Mangasa, ar atongi larne, ‘Tata, gong u noren tar a mamahat ne ir hanot tetek iau’? Bel! Bel ar araring larne. Ine a kamkamna ning a hanot suri. ");
INSERT INTO lbb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, ur aleklek a risam!” Pa elngen takai misaot na langit i atongi mange, “Ia ka aleklek tari, par aleklek ulaki.” ");
INSERT INTO lbb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A kunum a tarai ning la tur tingia la longori. Dingla na tarai la atongi mang a pungpugur, pa dingla otleng la atongi mange, “Ning a angelo i warwara teteki.” ");
INSERT INTO lbb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ika e Iesu i atongi mange, “A elngen takai ne bel i warwara sur ir nangan iau, sur ir nangan mulo ot. ");
INSERT INTO lbb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Onone ka taim sur dir warkurai a rakrakan hanua, pa dir alulu sen e Satan, a ningnigo mite na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ika iau, ning dir akulam iau mite lapiu usaot, ar dat a taraila rop tetek iau.” ");
INSERT INTO lbb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","I atongi larne sur ir atalapori mang ir mat mangmangasa. ");
INSERT INTO lbb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pa kunum a tarai la atai i mange, “Mila longori ting na Buk a Warkurai mange, e Karisito ir kes tikin. Sur asa u atongi mang dir akulam a Nat a Barsan usaot? Esi a Nat a Barsan?” ");
INSERT INTO lbb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","E Iesu i atai la mange, “A talapor bel ir kes kol ma napirimulo. Mulor taltal ning a talapor kanet, lamur a mormorom ir poroi alar mulo. Esining ir taltal ana mormorom bel ir tasmani mang ir han utaha. ");
INSERT INTO lbb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ning a talapor kanet, mulor tortorot onoi, sur mulo na natnat a talapor.” Ning e Iesu ka atong arop tar a warwara ne, i kamtur pa i han kumna kusun la. ");
INSERT INTO lbb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E Iesu ka tol tar a galis a akinalang na matanla, ika bel la tortorot onoi, ");
INSERT INTO lbb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","sur a warwara ning a propet Aisaia i warwara tar onoi ir hanot momol. I atongi mange, “Leklek, esi ka tortorot ana numila warwara? Pa esi di ka asangan tar a rakrakai anuna Leklek tana?” ");
INSERT INTO lbb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Pa ka atong tari otleng manglarne, “E God ka bing akut tar a matanla, pa ka san alar tar a nuknukinla, sur gong la tai ana matanla, pa gong la tasman lalani ting na nuknukinla, pa bel lar talingir tetek iau, sur ar alaun la.” Ine a kamkamna, ning bel la tortorot. ");
INSERT INTO lbb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","E Aisaia i atongi larne, anasa ka oroi tar a matatar ane Iesu, pa i warwara oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pa galis a ningnigola otleng miting na tarai Juda la tortorot oe Iesu, ika bel la warwara talapor onoi, sakana a Parisaiola lar kepsen la kusun a rumai lotula. ");
INSERT INTO lbb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bel la warwara talapor onoi anasa la mang sur a tarai lar aleklek la, pa bel la mang kol sur e God ir aleklek la. ");
INSERT INTO lbb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","E Iesu i warwara kol mange, “Esining i tortorot hok, bel i tortorot ka hok, i tortorot otleng o esaning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Pa esining i oroi iau, ka oroi tar esaning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A hanot ute na rakrakan hanua lar a talapor, sur esining i tortorot hok, bel ir kes ana mormorom. ");
INSERT INTO lbb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ning tik i longor anuk na warwara pa bel i muri, iau, bel ar warkurai i. Anasa bel a hanot sur ar warkurai a rakrakan hanua, a hanot sur ar alauni. ");
INSERT INTO lbb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Esining i gilam ris kusun iau pa bel i kibas anuk na warwara, anuk na warwara ot ning, lar warkurai i ana ararop a pukakiar. ");
INSERT INTO lbb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Anasa a warwarala ning ia ka atong tari bel anuki, e Tata ot i sune iau ono ute sur ar atongi par atong mangmangasa i. ");
INSERT INTO lbb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A tasmani mang anuna warkuraila ir saran a lalaun tikin. A warwarala a atongi, e Tata i sune iau ono sur ar atongi.” ");
INSERT INTO lbb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ning ka milau a lotu na Han Lakai, e Iesu ka tasmani mang ka milau sur ir han kusun a rakrakan hanua, pa ir han tetek e Tamana. I maris kol anuna taraila ning la kes te na rakrakan hanua, pa ine i asangan anuna tnan marmaris tetek la, a marmaris ning bel ta araropna. ");
INSERT INTO lbb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ana morom, e Iesu pa nuna na kakak a asaer la hangan taum. Lanigo sur lar hangan, e Satan i anuknuk tar e Judas Iskariot, a nat e Saimon, sur ir saran tar e Iesu uting na kuna hiruala. ");
INSERT INTO lbb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","E Iesu i tasmani mang e Tamana ka saran arop tar a ututnala rop na kuna, pa i tasmani mang i han misaot ta e God, pa ir ulak tetek e God. ");
INSERT INTO lbb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pa i kamtur kusun a utna na hangan, i kepsen anuna kaen ning i polpol alar anuna mermer onoi, i los pas a tawol pa i dot potor pasi onoi. ");
INSERT INTO lbb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","I pek pas a malum uting na besen, pa i gos a hana kakak a asaerla anunai, pa i sah sengsenge la ana tawol ning i dot potor pasi onoi. ");
INSERT INTO lbb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","I han tetek e Saimon Pita, pa e Pita i dekeni mange, “Leklek, ur gos naur a hak?” ");
INSERT INTO lbb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","E Iesu i kelesi mange, “A utna ne a toli bel u tasmani, ika lamur ur tasmani.” ");
INSERT INTO lbb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","E Pita i atongi mange, “Gong! Gong u gos naur a hak.” E Iesu i kelesi mange, “Ning bel ar gos naur a ham, u bel a halik.” ");
INSERT INTO lbb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","E Saimon Pita i kelesi mange, “Leklek, ning ur gos naur a hak, i wakak ning ur gos naur a kuk pa pukuluk otleng!” ");
INSERT INTO lbb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","E Iesu i kelesi mange, “Esining ka munmun pas, a palaona rop ka toh, dir gos tar kama naur a hana. Mulo, mulo ka toh, ika bel mulo rop.” ");
INSERT INTO lbb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","E Iesu i atongi larne, “bel mulo rop mulo toh,” anasa ka tasman esaning ir saran tari uting na kuna hiruala. ");
INSERT INTO lbb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ning ka gos tar na hanla, i suah ulak pas anuna kaen ning i kepsen tari, i kes pa i deken la mange, “Mulo tasman ot a utna ne a toli omulo? ");
INSERT INTO lbb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mulo atong iau mang ‘Tena Asaer’ pa ‘a Leklek’. I tostos ot anumulo na atatong, a risak ot ning. ");
INSERT INTO lbb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iau anumulo a Leklek pa Tena Asaer, ka gos tar a hamulo, i wakak sur mulo otleng mulor gos artalai a hamulola. ");
INSERT INTO lbb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ia ka tol tar a toltol ne tetek mulo, i wakak sur mulo otleng mulor toli larne. ");
INSERT INTO lbb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A atong momoli tamulo, a tena titol oros bel i leklek tana nuna ningnigo. Pa esining di sira sune i bel i leklek ta esaning i arsune. ");
INSERT INTO lbb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mulo ka tasman a ututnala ne. Ning mulor toli, dir angis mulo. ");
INSERT INTO lbb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Bel a warwara omulo rop, a tasman la ot ning ia ka aslang pas la. Ika dir tolsot pas ot asaning di ka tumus tari ting na Buk Tabu mange, ‘A barsan ning mia hangan taum ana bret, ka talingir kusun iau pa i hirua tetek iau.’ ");
INSERT INTO lbb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","A atai nigon tar mulo ana utna ne ning ir hanot. Pa ning ir hanot, mulor tortorot mang iau a Mesaia. ");
INSERT INTO lbb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A atong momoli tamulo, esining ir gas pas esaning a sune i, i gas pas iau. Esining ir gas pas iau, i gas pas esaning i sune iau ute.” ");
INSERT INTO lbb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ning e Iesu ka atong tari larne, i kilang a tnan mamahat ana inguna, pa i warwara talapor mange, “A atong momoli tamulo, ning a halimulo ir saran tar iau uting na kuna hiruala.” ");
INSERT INTO lbb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na kakak a asaer la ngoson artalai la, ika bel la tasmani mang esi na halinla ning i atong a warwara ne onoi. ");
INSERT INTO lbb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ning a kaklik asaer, ning e Iesu i katnani, i kes milau i. ");
INSERT INTO lbb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","E Saimon Pita i apit kilang pas a kaklik asaer ning pa i atai i mange, “Ur deken e Iesu mang esi na halindala ning i warwara onoi.” ");
INSERT INTO lbb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A kaklik asaer ning, i tan oe Iesu pa i dekeni mange, “Leklek, esining u warwara onoi?” ");
INSERT INTO lbb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","E Iesu i kelesi mange, “Esaning ar amurung pas a diah bret te na besen par sarani tana, i ka.” Pa i amurung pas a diah bret, pa i sarani ta e Judas Iskariot, a nat e Saimon. ");
INSERT INTO lbb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ning e Judas i kibas pas a bret, e Satan i kas kakat ono. E Iesu i atai e Judas mange, “Asaning u mang sur ur toli, ur tol kapiti.” ");
INSERT INTO lbb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ika bel tik ta halinla ning la kes ana utna na hangan i tasman lalan asa kamkamna ning e Iesu i atongi larne tana. ");
INSERT INTO lbb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","E Judas i sira tai alar anunla na mani. Pa dingla na kakak a asaer la nuki mang e Iesu i atai i sur ir lou al utna ning la kapan suri ting na tnan lotu. Dingla otleng la nuki mang e Iesu i atai i sur ir tabar a kapan a taraila. ");
INSERT INTO lbb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ning e Judas ka los pas a diah bret, i purum kakat. Ka morom. ");
INSERT INTO lbb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ning e Judas ka han, e Iesu i atai la mange, “Onone dir apuasa a matatar a Nat a Barsan, pa Nat a Barsan ir apuasa otleng a matatar e God. ");
INSERT INTO lbb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ning a Nat a Barsan ir apuasa a matatar e God, e God ir apuasa a matatar a Nat a Barsan. Ono otne e God ir apuasa a matatarna. ");
INSERT INTO lbb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Na natnatuk, bel ma ar kes kol napirimulo. Mulor tai sur iau. A warwara ia ka atai tar a tarai Juda, onone ar atai mulo otleng mange, ‘A hanua ning ar han suri, bel mulo tolsot sur mulor han tingia.’ ");
INSERT INTO lbb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A saran a tona warkurai tetek mulo mange, mulor mang artalai sur mulo. Mulor mang artalai sur mulo larning a mang sur mulo. ");
INSERT INTO lbb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ning mulor mang artalai sur mulo, a taraila rop lar tasmani mang mulo anuk na kakak a asaer.” ");
INSERT INTO lbb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","E Saimon Pita i dekeni mange, “Leklek, ur han utaha?” E Iesu i kelesi mange, “A hanua ning ar han tingia, onone bel u tolsot sur han tingia, ika lamur ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","E Pita i dekeni mange, “Leklek, sur asaning bel ar mur u onone? A sang sur ar saran anuk a lalaun sur u.” ");
INSERT INTO lbb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","E Iesu i kelesi mange, “Mangasa, i momol ot ning ur saran anum a lalaun sur iau? A atong momoli tam, ning a kakaruk belot ir kurkurirakuk, ur puai munatol mang bel u tasman iau.” ");
INSERT INTO lbb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","E Iesu i atai la mange, “Gong mulo nuknuk kol. Mulor tortorot oe God, pa mulor tortorot otleng hok. ");
INSERT INTO lbb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ting na rumai ane Tata, a galis a rum. Ning bel, ar atai mulo otleng ono. Ar han sur ar sang tar a pukna sur mulo. ");
INSERT INTO lbb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ning ia ka sang tar a pukna sur mulo, ar ulak, par ben pas mulo tetek iau, sur mulo otleng mulor kes ting na hanua ning ar kes ia. ");
INSERT INTO lbb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mulo tasman ot a ngas uting na hanua ning ar han utingia.” ");
INSERT INTO lbb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","E Tomas i atai i mange, “Leklek, bel mila tasman a hanua ning ur han utingia, pa milar tasman mangmangasa a ngas utingia?” ");
INSERT INTO lbb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","E Iesu i kelesi mange, “Iau a ngas, pa iau a momolna, pa iau a lalaun. Bel tik ir han tetek e Tata ana ta ngas masik, hok ka. ");
INSERT INTO lbb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ning mulo tasman momol iau, mulor tasman e Tata otleng. Pa onone mulo ka tasmani, pa mulo ka oroi.” ");
INSERT INTO lbb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","E Pilip i atai i mange, “Leklek, ur asangan tar e Tamam tamila, i ka ning mila mang suri.” ");
INSERT INTO lbb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","E Iesu i kelesi mange, “Pilip, ia ka kes kol taum omulo, pa belot u tasman iau? Esining ka oroi iau, ka oroi tar e Tata. Sur asa u atongi mang ar asangan tar e Tata tamulo? ");
INSERT INTO lbb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bel u tortorot mang iau kaning oe Tata, pa e Tata kane hok? A warwarala ning a atongi tamulo, bel anuki. E Tata ning kane hok i tol anuna titol. ");
INSERT INTO lbb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mulor tortorot hok ning a atongi mang iau kaning oe Tata, pa e Tata kane hok. Ning bel mulo tortorot ana nuk a warwara, mulor tortorot ka hok kamkamna ana ututnala ning a toli. ");
INSERT INTO lbb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“A atong momoli tamulo, esining i tortorot hok, ir tol a ututnala larning a sira toli, pa ir tol a tatatnan utna tana ututnala ning ia ka tol tari, anasa ar han tetek e Tata. ");
INSERT INTO lbb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pa ututnala rop ning mulo nunungi ana risak, ar tolsot pasi, sur e Natnalik ir apuasa a matatar oe Tamana. ");
INSERT INTO lbb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ning mulo araring sur ta utna ana risak, ar tolsot pasi. ");
INSERT INTO lbb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ning mulo mang sur iau, mulor mur anuk na warkuraila. ");
INSERT INTO lbb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Par nunung e Tata, pa ir sune ning a Tena Arnangai otleng tetek mulo, sur ir kes tikin taum omulo, ");
INSERT INTO lbb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","a Talngan Tabu na momolna. A taraila mite na rakrakan hanua bel la maling pasi, anasa bel la oroi lalani pa bel la tasmani. Ika mulo, mulo tasman a Tena Arnangai anasa i kes taum omulo pa ir kes omulo. ");
INSERT INTO lbb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ning ar han kusun mulo, bel mulor kes na biasui, ar ulak ka tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Bel ma i bongnani, sur a taraila mite na rakrakan hanua bel lar oroi iau. Ika mulo, mulor oroi iau. Mulor laun anasa a laun. ");
INSERT INTO lbb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ana pukakiar ning ar laun ulak kusun a minat, mulor tasmani mang iau kaning oe Tata, pa mulo otleng kane hok, pa iau kaning omulo. ");
INSERT INTO lbb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Esining i tong akes anuk na warkurai pa i muri, i ning i mang sur iau. Pa e Tata ir mang suri, pa iau otleng ar mang suri, par asangan iau tana.” ");
INSERT INTO lbb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","E Judas (bel e Judas Iskariot) i deken e Iesu mange, “Leklek, sur asaning ur asangan tar u tamila ka, pa bel tana taraila te na rakrakan hanua?” ");
INSERT INTO lbb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","E Iesu i kelesi mange, “Ning tik ir mang sur iau, ir longor ana nuk na asaer. Pa e Tata ir mang suri, pa miar han teteki, pa miar kes taum onoi. ");
INSERT INTO lbb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ika esining bel i mang sur iau, bel ir longor ana nuk na asaer. A warwarala ning mulo longori bel anuki, anun e Tata, ning i sune iau. ");
INSERT INTO lbb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“A atong a warwarala ne tamulo ning kanet a kes napirimulo. ");
INSERT INTO lbb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A Tena Arnangai, a Talngan Tabu, ning e Tata ir sune i ana risak, ir asaer mulo ana ututnala rop, pa ir anuknuk mulo ana warwarala ning ia ka atai tar mulo ono. ");
INSERT INTO lbb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","A saran a balmolmol tetek mulo, anuk a balmolmol ning a tabar mulo ono. Bel a tabar mulo larning a rakrakan hanua i artabar. Gong mulo nuknuk kol, pa gong mulo matmataut. ");
INSERT INTO lbb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Mulo ka longor tar asaning ia ka atong tari mang, ‘Ar han pas par ulak tetek mulo.’ Ning mulo mang sur iau, mulor gas mang ar han tetek e Tata, anasa i leklek tak. ");
INSERT INTO lbb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ia ka atai nigon tar mulo ana ututnala ning lamur ir hanot, pa ning ka hanot, mulor tortorot. ");
INSERT INTO lbb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Bel ma ar awara kol mulo, anasa e Satan, a ningnigo mite na rakrakan hanua, milau ir hanot. Bel al rakrakaina sur ir tol ta utna hok, ");
INSERT INTO lbb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ika ar tolsot arop pas a ututnala ning e Tata i sune iau sur ar toli, sur a rakrakan hanua ir tasmani mang a mang sur e Tata. “Mulor tur pa dala kar han.” ");
INSERT INTO lbb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","E Iesu i atongi mange, “Iau a rakai a wain momol, pa e Tata a tena tai alar. ");
INSERT INTO lbb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","I ting arop sen a rakrakanala hok ning bel la wai, pa i buri sen la rop ning la wai, sur lar wai kol. ");
INSERT INTO lbb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mulo ka toh anasa ana warwara ning ia ka atong tari tamulo. ");
INSERT INTO lbb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mulor patap hok, pa iau ar patap omulo. Bel mulor wai ning bel mulo patap hok, arlar ana rak a wain, bel ir wai oros ka, ning bel i patap ana rakaina. ");
INSERT INTO lbb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iau ot a rakai a wain, pa mulo a rakrakanala. Esining i patap hok, pa a patap onoi, ir wai kol. Ika ning mulo laun masik kusun iau, bel mulor tolsot pas ta utna. ");
INSERT INTO lbb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ning tik bel i patap hok, i arlar ana rak a rakai ning di migen seni pa ir marang. Dir suah taum la, pa dir migeni ting na iah, sur lar sot rop. ");
INSERT INTO lbb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ning mulo patap hok, pa anuk a warwara ir laun omulo, mulor nunung sur ta utna mulo mang suri, pa dir sarani ot tamulo. ");
INSERT INTO lbb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","“Ning mulor wai kol, mulor apuasa a matatar e Tata, pa waimulo ir asangani mang mulo anuk na kakak a asaerla. ");
INSERT INTO lbb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","E Tata i mang sur iau, larning iau otleng a mang sur mulo. Mulor laun ana nuk a marmaris. ");
INSERT INTO lbb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ning mulo longor ana nuk na warkurai, mulor laun ana nuk a marmaris, larning a longor ana warkuraila ane Tata, pa a laun ana nuna marmaris. ");
INSERT INTO lbb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“A atong a warwarala ne tamulo, sur anuk a gasgas ir kes omulo, pa anumulo a gasgas ir bukus momol. ");
INSERT INTO lbb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ine anuk a warkurai tetek mulo: Mulor mang artalai sur mulo, larning a mang sur mulo. ");
INSERT INTO lbb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ning tik i saran anuna lalaun sur ir mat sur na halalna, anuna marmaris i itna kol. Bel al marmaris anuna tik i arlar ono. ");
INSERT INTO lbb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mulo na halalik ning mulo longor ana nuk na warkuraila. ");
INSERT INTO lbb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bel a atong ulak mulo mang a tena titol orosla, anasa a tena titol oros bel i tasman a utna ning anuna ningnigo i toli. Ika a atong mulo na halalik, anasa ia ka atong arop tar a warwarala tamulo ning a longori ta e Tata. ");
INSERT INTO lbb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bel mulo aslang pas iau, iau ot a aslang pas mulo. Pa a saran a titol tamulo sur mulor han pa mulor wai, pa waimulo ir kes tikin. Pa e Tata ir tabar mulo ana saning mulo araring suri ana risak. ");
INSERT INTO lbb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ine anuk a warkurai: Mulor mang artalai sur mulo. ");
INSERT INTO lbb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ning a taraila mite na rakrakan hanua lar nget mulo, mulor nuk pasi mang la nget nigon iau. ");
INSERT INTO lbb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ning mulo mite na rakrakan hanua, lar mang sur mulo larning mulo anunlai. Ika mulo bel mite na rakrakan hanua, ia ka aslang pas mulo kusuni. Ine a kamkamna ning a taraila mite na rakrakan hanua la nget mulo. ");
INSERT INTO lbb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mulor nuk pas a warwara ning ia ka atong tari tamulo mange, ‘A tena titol oros bel i leklek tan anuna ningnigo.’ Ning la alaulau iau, lar alaulau mulo otleng. Ning la longor ana nuk na warwara, lar longor otleng ana numulo na warwara. ");
INSERT INTO lbb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lar alaulau mulo anasa mulo anuki, anasa bel la tasman esaning i sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ning bel ar hanot pa bel ar warwara tanla, bel dir tiu la ana nunla na toltol laulaula, pa lar langolango. Ika onone, bel al warwara anunla sur lar alar la onoi kusun anunla na toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Esining i nget iau, i nget e Tata otleng. ");
INSERT INTO lbb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ia ka tol tar a titolla ning bel tik i tolsot tari. Ning bel ar tol tar al titol ne tanla, bel dir tiu la ana nunla na toltol laulau pa lar langolango. Pa onone, la ka oroi tar a titolla ning a toli, ika la nget mia rop ma e Tata. ");
INSERT INTO lbb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Di toli larne, sur dir tolsot pas a warwara ning di ka tumus tari ting na Buk a Warkurai mange, ‘La nget iau, pa bel ta kamkamna.’ ");
INSERT INTO lbb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ar sune a Tena Arnangai tetek mulo misaot ta e Tata, i a Talngan Tabu na momolna. Ning ir hanot ir warwara talapor hok. ");
INSERT INTO lbb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pa mulo otleng mulor warwara talapor hok, anasa mulo kes taum hok ana nuk a kamkama titol tuk onone. ");
INSERT INTO lbb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“A atong a warwarala ne tamulo sur gong a tortorot anumulo ir punga. ");
INSERT INTO lbb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Lar sairas mulo kusun a rumai lotula. A taim ir hanot lamur, ning a tarai ning lar umkol mulo, lar nuki mang la tol a titol ane God. ");
INSERT INTO lbb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A tarai lar tol a ututnala ne tetek mulo, anasa bel la tasman miau ma e Tata. ");
INSERT INTO lbb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A atai tar mulo ana warwarala ne, sur ning ir hanot, mulor tasmani mang ia ka atumarang nigon tar mulo. Ana kamkama nuk a titol, bel a atai tar mulo ana warwarala ne, anasa kanet a kes taum omulo. ");
INSERT INTO lbb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Onone, ar han tetek esaning i sune iau ute. Ika bel tik ta halimulo i deken iau mang, ‘Ur han utaha?’ ");
INSERT INTO lbb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mulo balmaris kol anasa a atai mulo ana warwarala ne. ");
INSERT INTO lbb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","A atong momoli tamulo mang, ir wakak tetek mulo ning ar han. Ning bel ar han, a Tena Arnangai bel ir hanot tetek mulo. Ika ning ar han, ar sune i ute tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ning ir hanot, ir asangan a taraila te na rakrakan hanua ana toltol laulau, pa ana tostosna pa ana warkurai ane God. ");
INSERT INTO lbb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ir asangan la ana toltol laulau anasa bel la tortorot hok. ");
INSERT INTO lbb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pa ir asangan la otleng ana tostosna, anasa ar han tetek e Tata pa bel mulor oroi ulak iau. ");
INSERT INTO lbb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pa ir asangan la otleng ana warkurai ane God anasa e God ka warkurai tar a ningnigo mite na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“A galis a utna ning ar atongi tamulo, ika onone bel mulor nuk lalani. ");
INSERT INTO lbb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ning a Talngan Tabu na momolna ir hanot, ir atalapor mulo ana momolna rop. A warwarala ning ir atongi bel anunai, ir atong ka a warwarala ning i longori, pa ir atai mulo ana ututnala ning ir hanot lamur. ");
INSERT INTO lbb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ning ir los pas anuk na warwara pa ir atai mulo onoi, ir apuasa a matatarik. ");
INSERT INTO lbb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","A ututnala rop ning ane Tata, anuki. Ine a kamkamna ning a atongi mang a Talngan Tabu ir los pas anuk na warwara pa ir atai mulo onoi. ");
INSERT INTO lbb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Bel ir bongnani, pa bel mulor oroi iau. Pa bel ir bongnani kale, mulor oroi iau.” ");
INSERT INTO lbb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Anuna dingla na kakak a asaer la deken artalai la mange, “Esi na kamkamna ana nuna warwara ne, bel ir bongnani pa bel dalar oroi, pa bel ir bongnani kale dalar oroi? Pa ning a warwara otleng anunai ne, anasa ir han tetek e Tamana? ");
INSERT INTO lbb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Esi na kamkamna ana nuna warwara ne ‘bel ir bongnani’? Bel dala tasman a utna ne i warwara onoi!” ");
INSERT INTO lbb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","E Iesu i tasmani mang la mang sur lar dekeni, pa i atai la, “A atong tari mange, ‘Bel ir bongnani bel mulor oroi iau, pa bel ir bongnani kale mulor oroi iau.’ I mangasa, a warwara ne mulo deken artalai mulo onoi? ");
INSERT INTO lbb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A atong momoli tamulo, mulor balmaris pa mulor domos, ika a taraila mite na rakrakan hanua lar gas. Mulor balmaris, ika lamur anumulo a balmaris ir keles sur a gasgas, ");
INSERT INTO lbb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","arlar ana hane ning i milau sur ir agon, i kilang a tnan kankan, ika, ning ka agon sen tar a kaklik, ir duman sen a kankan pa ir gas, anasa ka agon tar a kaklik ute na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mang otleng larning tetek mulo, onone mulo balmaris, ika ar oroi ulak mulo, pa mulor gas. A gasgas ne, bel tik ir kepseni kusun mulo. ");
INSERT INTO lbb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ana pukakiar ning, bel mulor deken ulak iau ana ta utna. A atong momoli tamulo, e Tata ir tabar mulo ana saning mulo araring suri ana risak. ");
INSERT INTO lbb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tuk onone, bel mulo nunung sur ta utna ana risak. Mulor nunung pa dir tabar mulo, sur anumulo a gasgas ir bukus momol. ");
INSERT INTO lbb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“A atong a warwarala ne tamulo ana warwara larlar, ika a taim ir hanot ning bel ar warwara ulak tetek mulo ana warwara larlar, ar atai talapor mulo oe Tata. ");
INSERT INTO lbb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ana pukakiar ning, mulor nunung ana risak. Bel a atongi mang iau ar nunung e Tata sur ir nangan mulo, ");
INSERT INTO lbb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","anasa e Tata ot i mang sur mulo. I mang sur mulo anasa mulo mang sur iau, pa mulo tortorot mang a han misaot ta e God. ");
INSERT INTO lbb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ia ka han pas misaot ta e Tata, pa a han ute na rakrakan hanua. Pa onone, ar han kusun a rakrakan hanua, par ulak tetek e Tata.” ");
INSERT INTO lbb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Anuna kakak a asaer la atai i mange, “Onone bel u warwara ana warwara larlar, u bot warwara talapor. ");
INSERT INTO lbb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Onone mila ka tasmani mang u tasman a ututnala rop. Bel u kapan sur tik ir deken u anal deke, anasa u ka tasman arop tar a nuknukimila. Onone mila bot tortorot mang u han misaot ta e God.” ");
INSERT INTO lbb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","E Iesu i atai la mange, “Mulo bot tortorot? ");
INSERT INTO lbb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","A taim ir hanot, pa ka hanot, sur dir asarara mulo kusun iau, pa mulor han uting na numulo na hananuala, pa iau kama ar kes. Ika bel iau ka ar kes, miau ot ma e Tata. ");
INSERT INTO lbb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“A atong a warwarala ne tamulo sur mulor laun te hok pa balmolmol ir kes omulo. Te na rakrakan hanua, mulor kilang a mamahat. Ika gong mulo matmataut, anasa ia ka tolsot pas a rakrakai mite na rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ning e Iesu ka atong arop tar a warwarala ne, i tai usaot na langit, pa i atongi mange, Tata, a taim ka hanot, ur apuasa a matatar e Natumlik, sur e Natumlik ir apuasa a matatarim. ");
INSERT INTO lbb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","U saran tar a warkurai tak sur a taraila rop lar kes nahaik, sur ar saran a lalaun tikin tanla rop ning u saran tar la tak. ");
INSERT INTO lbb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A lalaun tikin i manglarne: A tarai lar tasman u, ning u ka a God momol, pa lar tasman otleng e Iesu Karisito, ning u sune i ute. ");
INSERT INTO lbb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ia ka asangan tar a matatarim te na rakrakan hanua, ana titolla ning ia ka tol arop tari. A titolla ning u sune iau ono. ");
INSERT INTO lbb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tata, onone, ning ar kes taum ulak hom, ur apuasa a matatarik. A matatar ning nating kane hok pa kaning hom, ning belot di akes a rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","La ning u ka aslang pas la kusun a rakrakan hanua, pa u saran tar la tak, ia ka atalapor tar u tetek la. La anumi pa u saran tar la tak, pa la ka mur anum na warwara. ");
INSERT INTO lbb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Onone la ka tasmani mang a ututnala rop ning u saran tari tak, i hanot misaot tam. ");
INSERT INTO lbb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ia ka atai tar la ana warwarala ning u saran tari tak, pa la ka kibasi. Pa la tasman momoli mang a hanot misaot tam, pa la ka tortorot mang u sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","A araring sur la. Bel a araring sur a taraila mite na rakrakan hanua, a araring sur la ning u saran tar la tak, anasa la anumi. ");
INSERT INTO lbb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","La ning anuki, anumi, pa la ning anumi, anuki. Pa la ka apuasa a matatarik. ");
INSERT INTO lbb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Onone ar han tetek u, bel ma ar kes te na rakrakan hanua, ika la, kanet na rakrakan hanua. Tata u totoh, ur tai alar la ana rakrakai a risam, a risam ning u sarani tak. Ur tai alar la sur lar takai ka, larning dau takai ka. ");
INSERT INTO lbb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ning a kes taum onla, a tai alar la ana rakrakai a risam, ning u saran tari tak, pa bel tik ta halinla i hirua. Takai sot ka i hirua, esaning ir han sur a hinirua tikin. Larning, a warwara ning di ka tumus tari ting na Buk Tabu ir hanot momol. ");
INSERT INTO lbb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Onone ar han tetek u, ika a atong a warwarala ne ning kanet a kes te na rakrakan hanua, sur anuk a tnan gasgas ir bukus ting na nunla lalaun. ");
INSERT INTO lbb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ia ka atong tar anum a warwarala tanla, pa rakrakan hanua i nget la, anasa bel la mite na rakrakan hanua, larning iau otleng, bel iau mite na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Bel a araring sur ur kepsen la kusun a rakrakan hanua. A araring sur ur tai alar la kusun a Tena Laulau. ");
INSERT INTO lbb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bel la mite na rakrakan hanua, larning iau otleng, bel iau mite na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Anum a warwara i momol. Ur atotoh la ana num a momolna sur la anumi. ");
INSERT INTO lbb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","A sune la uting na rakrakan hanua larning u sune iau otleng ute na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A saran tar iau tam, sur la otleng anum a tarai ana momolna. ");
INSERT INTO lbb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Bel a araring ka sur la. A araring otleng sur la ning lamur lar tortorot hok, anasa ana warwara talapor anuna tena tortorotla. ");
INSERT INTO lbb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tata, a araring mang la rop ning la tortorot hok, lar takai ka, larning u kane hok pa iau kaning hom. I wakak sur la kane ondau, sur a taraila te na rakrakan hanua lar tortorot mang u sune iau. ");
INSERT INTO lbb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A saran tar a matatar tanla, a matatar ning u saran tari tak, sur lar takai ka, larning dau takai ka. ");
INSERT INTO lbb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iau kaning onla, pa u kane hok, sur lar takai kama, sur a taraila te na rakrakan hanua lar tasmani mang u sune iau ute, pa u mang sur la larning u mang sur iau. ");
INSERT INTO lbb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, la ning u ka saran tar la tak, a mang sur lar kes taum hok ting na hanua ning ar kes ia, sur lar oroi a matatarik, ning u saran tari tak, anasa u mang sur iau nating ot ning belot di akes a rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata, u tostos, a taraila te na rakrakan hanua bel la tasman u, ika iau, a tasman u, pa anuk na tarai a asaer la tasmani mang u sune iau ute. ");
INSERT INTO lbb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ia ka atalapor tar u tetek la, pa bel ar manah ana warwara tetek la, sur lar tasman u, pa marmaris ning u mang sur iau onoi, ir kes onla pa iau otleng kaning onla.” ");
INSERT INTO lbb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ning e Iesu ka araring pas, i ben pas anuna kakak a asaerla, pa la lakai a natar a malum Kidron. Ting na ning a ris a malum, a barim a rakai oliw kaning ia, pa la han kas tingia. ");
INSERT INTO lbb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","E Judas, ning i saran tar e Iesu na kuna hiruala, i tasman a pukna ning, anasa a galis a pukakiar e Iesu taum ana nuna kakak a asaer la sira han taum tingia. ");
INSERT INTO lbb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pa e Judas i nigon pas a tena harumla anuna tarai Rom, taum ana tena tai alarla miting na rumai artabar. A leklek a tena artabarla pa Parisaiola la sune sen la. La los a ututnala na harum, a lamla pa ututnala ning i sot sur lar sulu talapor la ono. Pa la hanot ting na barim. ");
INSERT INTO lbb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ika e Iesu ka tasman a ututnala rop ning ir hanot teteki, pa i han tetek la, pa i deken la mange, “Esining mulo tai suri?” ");
INSERT INTO lbb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","La kelesi mang, “E Iesu a te Nasaret.” E Iesu i atongi mange, “Iau ka ne.” Pa e Judas, ning ir saran tar e Iesu na kuna hiruala, kaning ot i tur taum onla. ");
INSERT INTO lbb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ning e Iesu i atai la mange, “Iau ka ne,” la suahi utumo lamur, pa la punga ting lapiu. ");
INSERT INTO lbb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","E Iesu i deken ulak la mange, “Esining mulo tai suri?” La kelesi mange, “E Iesu a te Nasaret.” ");
INSERT INTO lbb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","E Iesu i keles la mange, “Ia ka atai tar mulo mang, iau ka ne. Ning mulo tai ot sur iau, mulor noren sen a tarai ne lar han.” ");
INSERT INTO lbb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","E Iesu i atongi larne sur dir tolsot pas a warwara ning ka atong tari mange, “Tata, la rop ning u saran tar la tak, bel ta halinla i hirua.” ");
INSERT INTO lbb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","E Saimon Pita i los ot anuna liwan a harum. I dat pasi pa i umsem ana sot a talngana e Malkus, ning a tena titol oros anuna ningnigo na tena artabar tetek e God. ");
INSERT INTO lbb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","E Iesu i atai e Pita mange, “Akas ulak anum a liwan ting na ngasna. Mangasa, bel ar gang ana kap a mamahat ning e Tata i saran tari tak?” ");
INSERT INTO lbb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A tena harumla mitumo e Rom taum ana nunla ningnigo, pa tena tai alarla miting na rumai artabar anuna tarai Juda, la tong akes pas e Iesu, pa la dot akes naur a kuna. ");
INSERT INTO lbb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pa la ben nigoni tetek e Anas, ning dia anmuna ma e Kaiapas, a ningnigo na tena artabar tetek e God ana rau ning. ");
INSERT INTO lbb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","E Kaiapas, esaning i atai a tarai Juda mang i wakak sur tik ir mat alar a taraila rop. ");
INSERT INTO lbb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","E Saimon Pita pa ning a kaklik asaer otleng dia han namur e Iesu. Pa ningnigo na tena artabar i tasman a kaklik asaer, ning dia han taum ma e Pita. A kaklik asaer ning i han taum oe Iesu utingui na pukna anuna ningnigo ning. ");
INSERT INTO lbb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ika e Pita i harnanai tumo lapiu na taman. Pa kaklik asaer ning a ningnigo i tasmani, i ulak, pa i warwara tetek a basbas ning i tai alar a taman, sur ir sapang pas e Pita. ");
INSERT INTO lbb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","A basbas ning i deken e Pita mange, “U otleng ning a hala kakak a asaerla anuna barsan ne, ge?” E Pita i kelesi mange, “Iau bel.” ");
INSERT INTO lbb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A morom ning i kotkoto kol. Pa tena titol orosla taum ana tena tai alarla miting na rumai artabar, la sur taum a barangla, la tur talilis pasi pa la marmarim. E Pita otleng i tur taum onla pa i marmarim. ");
INSERT INTO lbb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","E Anas, a ningnigo na tena artabar tetek e God i deken e Iesu ana nuna kakak a asaerla pa asaerla ning i sira asaer a taraila onoi. ");
INSERT INTO lbb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","E Iesu i kelesi mange, “Ia ka warwara talapor na matana taraila rop, pa a sira asaer la ting na rumai lotula pa ting na rumai artabar ning a tarai Juda la sira han taum tingia. Bel a atong kumnan tar ta utna. ");
INSERT INTO lbb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Gong u deken iau. Ur deken a taraila ning la sira longor iau. La tasman a ututnala ning a atong tari.” ");
INSERT INTO lbb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ning e Iesu i atongi larning, ning a hala tena tai alarla i pasar a patarna, pa i atai i mange, “Sur asa u keles a warwara anuna ningnigo na tena artabar larning?” ");
INSERT INTO lbb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","E Iesu i kelesi mange, “Ning ia ka atong tar ta utna i rongo, ur atong talapori tetek a taraila rop ne. Ika ning a atong a momolna, sur asa u pasar iau?” ");
INSERT INTO lbb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","E Anas i sune seni tetek e Kaiapas, ning a ningnigo otleng na tena artabar tetek e God. Ika bel di pak sen naur a kuna. ");
INSERT INTO lbb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ning e Pita kaning ot i marmarim, la dekeni mange, “U otleng ning a hala nuna kakak a asaerla, ge?” E Pita i puai mange, “Iau bel.” ");
INSERT INTO lbb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ning a tena titol oros anuna ningnigo na tena artabar, a maina esaning e Pita i umsem a talngana, i atongi mange, “Ngandek u ka, anasa a oroi taum tar mu ma e Iesu saot na barim a rakai oliw?” ");
INSERT INTO lbb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","E Pita i puai ulak mange, “Bel.” Pa ono otning, a kakaruk i kurkurirakuk. ");
INSERT INTO lbb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ana kobot ning ot, di ben pas e Iesu miting na rumai ane Kaiapas sur uting na tnan rumai ane Pailat, a ningnigo ana matanitu Rom. A tarai Juda bel la mang sur lar kas ting na nuna rumai, anasa la ka atotoh pas la sur lar hangan ana utna na hangan na Han Lakai. Pa esining ir kas tetek tik, ning bel a te Juda, ir dur na matana e God. ");
INSERT INTO lbb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","E Pailat i purum tetek la pa i deken la mange, “Mulo tiu a barsan ne ona sa?” ");
INSERT INTO lbb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pa la kelesi mange, “A barsan ne, ning bel ir tol ta rongo, bel milar sarani tam sur ur warkurai i.” ");
INSERT INTO lbb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","E Pailat i atai la mange, “Mulor ben pasi, pa mulo ot mulor warkurai i arlar ana numulo na warkurai.” A tarai Juda la atai i mange, “ I tabu sur milar umkol tik.” ");
INSERT INTO lbb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A utna ne i hanot sur dir tolsot pas a warwara ane Iesu, ning ka atong nigon tari ana nuna ngas a minat. ");
INSERT INTO lbb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Lamur e Pailat i kas ulak, i kabah pas e Iesu, pa i dekeni mange, “U a king anuna tarai Juda?” ");
INSERT INTO lbb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","E Iesu i kelesi ka ana kabah mange, “Mangasa, u ot u atong iau larning, o la atai u ka hok?” ");
INSERT INTO lbb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","E Pailat i keles e Iesu mange, “Bel iau a te Juda. Anum a taraila pa leklek a tena artabarla tetek e God, la ot ning la saran tar u tetek iau sur ar warkurai u. Asaning u ka tol tari?” ");
INSERT INTO lbb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","E Iesu i kelesi mange, “Anuk a matanitu bel mite na rakrakan hanua. Ning anuk a matanitu mite na rakrakan hanua, anuk na tena titol lar harum alar iau kusun a warkurai anuna tarai Juda. Ika anuk a matanitu bel mite.” ");
INSERT INTO lbb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","E Pailat i dekeni mange, “I momol ot, u a king?” E Iesu i kelesi mange, “I momol ot ning u atongi mang iau a king. Di agon iau, pa a hanot te na rakrakan hanua, sur ar warwara talapor ana momolna. La rop ning la mur a momolna, la longor a elngek.” ");
INSERT INTO lbb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pa e Pailat i dekeni mange, “Asaning a momolna?” Ning e Pailat ka deken tari larne, i purum ulak tetek a tarai Juda. I atai la mange, “Bel a pastek anuna ta rongo. ");
INSERT INTO lbb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ika, ning a toltol a sira toli tetek mulo, ana raula rop ana lotu na Han Lakai, a sira pak sen ta mainla ning i kes ting na karabus, tetek mulo. Mangasa, mulo mang sur ar pak sen a ‘king anuna tarai Juda’ tetek mulo?” ");
INSERT INTO lbb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","La kukuk kelesi mange, “Gong! Gong e Iesu. Paksen e Barabas!” E Barabas a tnan tena laulau. ");
INSERT INTO lbb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","E Pailat i arsune sur lar ben masik pas e Iesu pa lar mirasi ana inau a harum. ");
INSERT INTO lbb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A tarai a harum la iris pas a inau ning a suksukna pa la suahi ana pukulna arlar ana kukuh anuna king, pa la apipisi ana pepol a kaen. ");
INSERT INTO lbb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","La ululak teteki, pa la atai i mange, “U a king anuna tarai Juda!” Pa la paspasar a patarna. ");
INSERT INTO lbb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","E Pailat i purum ulak pa i atai la mange, “Mulo oroi, a ben purum tari na matamulo, sur mulor tasmani mang, bel a pastek anuna ta rongo.” ");
INSERT INTO lbb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ning e Iesu i purum, di ka suah tar a inau ning a suksukna ting na pukulna, pa di ka apipis tari ana pepol a kaen. E Pailat i atai la mange, “Mulo oroi a barsan ne!” ");
INSERT INTO lbb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ning a leklek a tena artabarla tetek e God, pa tena tai alarla miting na rumai artabar la oroi e Iesu, la kukuk mange, “Sai ahati saot na rakai kutus! Sai ahati saot na rakai kutus!” E Pailat i atai ulak la mange, “Mulor ben pasi, sur mulo ot mulor sai ahati saot na rakai kutus. Ika iau, bel a pastek anuna ta rongo.” ");
INSERT INTO lbb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A tarai Juda la kelesi mange, “Anumila warkurai i mange, dir umkoli, anasa i iaunani mang ai a Nat e God.” ");
INSERT INTO lbb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ning e Pailat i longor a warwara ne, i matmataut kol. ");
INSERT INTO lbb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","I kas ulak utisaui, pa i deken e Iesu mange, “U mitaha?” Ika e Iesu bel i kelesi. ");
INSERT INTO lbb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","E Pailat i atai i mange, “Mangasa, bel u mang sur ur keles iau? Bel u tasmani mang a tong akes a warkurai sur ar alangolango sen u, o ar sai ahat u saot na rakai kutus?” ");
INSERT INTO lbb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","E Iesu i kelesi mange, “U tolsot sur ur warkurai iau, anasa e God i saran tar a rakrakai tam. Ika esaning i saran tar iau tetek u sur ur warkurai iau, anuna toltol laulau i laulau kol tan anum a toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ning e Iesu i atong tari larning, e Pailat i tohoi sur ir alangolango seni. Ika a tarai Juda la kukuk mange, “Ning ur pak seni, bel mur baltaum ana Sisar! Anasa tik ning i iaunani mang ai a king, i kutus a warkurai ana Sisar.” ");
INSERT INTO lbb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ning e Pailat i longor a warwarala ne, i ben purum pas e Iesu utumo lapiu. Lamur e Pailat i kes ting na keskes a warkurai ting na pukna di atongi ana warwara Hibru mang Gabata, a kamkamna mang di suah alar a kabalapiu ana hatatla. ");
INSERT INTO lbb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ana iahkamis tostos, e Pailat i atai a tarai Juda mange, “Mulo oroi, anumulo a king ma ne.” A utna ne i hanot ana pukakiar na sang, a pukakiar nigo tana pukakiar a lotu na Han Lakai. ");
INSERT INTO lbb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","A tarai Juda la kukuk mang, “Ben seni! Ben seni! Sai ahati saot na rakai kutus!” E Pailat i deken la mange, “Mulo mang sur ar sai ahat anumulo a king saot na rakai kutus?” A leklek a tena artabarla tetek e God la kelesi mange, “A Sisar sot ka anumila king!” ");
INSERT INTO lbb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pa e Pailat i saran tar e Iesu tetek a tarai a harum, sur lar sai ahati saot na rakai kutus. Pa la ben pas e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","E Iesu i pamar pas anuna rakai kutus pa i han uting na pukna ning di atongi “A Lasa na Pukulundi,” ning ana warwara Hibru di atongi e Golgota. ");
INSERT INTO lbb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tingia, la sai ahati saot na rakai kutus. La sai ahat tar otleng naur a barsan taum onoi, ting na naur a ris, pa e Iesu i kulam na arpotor indiau. ");
INSERT INTO lbb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pa e Pailat i tumus a warwara sur dir sai ahati saot na rakai kutus, mange: ");
INSERT INTO lbb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A galis a tarai Juda la was a warwara ne, anasa a pukna ning di sai ahat e Iesu ono, i milau ka e Jerusalem, pa di tumus a warwara ne ana natol a ngas a warwara, a warwara Hibru, Latin pa Grik. ");
INSERT INTO lbb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","A leklek a tena artabarla tetek e God la atai e Pailat mange, “Gong u tumusi mang, ‘a King anuna tarai Juda.’ Ur tumusi ka mang, ‘A barsan ne i iaunani mang ai a king anuna tarai Juda.’” ");
INSERT INTO lbb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","E Pailat i keles la mange, “A warwara ning ia ka tumus tari, ir mang ot larning.” ");
INSERT INTO lbb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ning a tarai a harum la ka sai ahat tar e Iesu saot na rakai kutus, la los pas anuna kaenla ning i polpol alar anuna mermer onoi, pa la asaurani ana diat a tiniba. Ning a tena harum, anuna ning a tiniba. La los pas otleng anuna kaen ning i pipisi. A kaen ning bel ta sunusuk onoi, a kidol a kaen ka. ");
INSERT INTO lbb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","A tarai a harum la awara artalai la mange, “Gong dala siliri, dalar pilai laki, sur esi na halindala ir losi.” La toli manglarning sur dir tolsot pas a warwara ting na Buk Tabu. I atongi mange, “La asauran anuk a kaenla onla, pa la pilai laki suri.” A ututnala ne, ning a tarai a harum la toli. ");
INSERT INTO lbb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tana e Iesu i tur milau a rakai kutus ane Iesu, taum oe tasna hane, pa e Maria otleng a hane ane Kilopas, pa e Maria Makdalen. ");
INSERT INTO lbb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ning e Iesu i oroi e tana tingia, dia tur taum ana kaklik asaer ning e Iesu i katnani, i atai e tana mange, “Nana, i ning a natumlik.” ");
INSERT INTO lbb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","I atai a kaklik asaer otleng mange, “I ning e tnam.” Turpasi ot ana pukakiar ning, a kaklik asaer ning, i ben pas e tana e Iesu, sur ir kes ting na nuna rumai. ");
INSERT INTO lbb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","E Iesu i tasmani mang ka tol arop tar a titolla, pa i atongi mange, “A mos.” I atongi larning, sur ir tolsot pas a warwara ning di ka tumus tari ting na Buk Tabu. ");
INSERT INTO lbb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ning a koto na mititir a wain kaning ia. La los pas ning a utna i sira dop a polo, pa la amurungi ting na koto na wain ning i mititir. La suah pasi ana rakai, di atongi a hisop, pa la tuslani usaot sur a pahana e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ning e Iesu ka dop pas a wain, i atongi mang, “Ka rop.” I lugun purum a pukulna, pa i suah sen a malwasna. ");
INSERT INTO lbb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A tarai Juda la nunung e Pailat sur ir malmaling sur dir kuben a handitol, sur ditol ar mat kapit, pa dir los purum a palaonditol kusun natol a rakai kutus, anasa a pukakiar ning, a pukakiar nigo tana tnan Pukakiar Sabat, pa bel la mang sur a palaonditol ir kulam saot na rakai kutus ana Pukakiar Sabat. ");
INSERT INTO lbb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pa tarai a harum la han pa la kuben naur a hana a ningnigo na barsan, pa lamur ning a halindiau kale, ning di sai ahat diau taum oe Iesu ana natol a rakai kutus. ");
INSERT INTO lbb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ika ning la han tetek e Iesu, la oroi mang ka mat, pa bel ma la kuben naur a hana. ");
INSERT INTO lbb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ning a tena harum i so a kabarangragaina ana turai, a suluk taum ana malum i tapek purum kakat kusuni. ");
INSERT INTO lbb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A kaklik asaer ning i oroi a ututnala ne, i warwara talapor onoi sur mulo otleng mulor tortorot. A warwara talapor ne i momol, pa i ot i tasmani mang i momol. ");
INSERT INTO lbb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Di tol a ututnala ne, sur dir tolsot pas a warwara, ning di ka tumus tari ting na Buk Tabu mange, “Bel dir kuben ta surna.” ");
INSERT INTO lbb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Di tolsot pas otleng a warwara na Buk Tabu mange, “Lar ngoson esaning la so tari.” ");
INSERT INTO lbb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lamur, e Josep a te Arimatia i nunung e Pailat sur a minat e Iesu. I otleng, a kaklik asaer ning i murmur kumnan e Iesu, anasa i matatan a tarai Juda. Pa e Pailat i malmaling sur ir han pa ir pak purum pas a minat e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","E Nikadimos, ning lanigo i han tetek e Iesu ana ning a morom, i otleng i hanot. I los ning a tomtoboh, ning di toli ana alo pa mira. A mamahat onoi, i arlar ana natol a bonot a kilogrem. ");
INSERT INTO lbb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dia los pas a minat e Iesu, dia irisi ana wakak a kaenla taum ana tomtoboh, arlar ana toltol anuna tarai Juda, ning la sira toli ana minatla. ");
INSERT INTO lbb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ning a barim kaning milau a pukna ning di sai ahat e Iesu saot ia, pa ning a tona kulam a minat kaning ia, ning belot di aborbor tar ta minat tingia. ");
INSERT INTO lbb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pa la aborbor e Iesu tingui na kulam a minat ning, anasa i milau ka. La toli larning, anasa a pukakiar ning a tarai Juda la sang sur a Pukakiar Sabat. ");
INSERT INTO lbb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ana kobot ning ot ana ningnigo na pukakiar ana wik, kaning ot i mormorom, e Maria Makdalen i hanot ting na kulam a minat. I oroi mang di ka lakir sen tar a tnan hat kusun a taman a kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","I dun tetek e Saimon Pita pa kaklik asaer ning e Iesu i katnani, pa i atai diau mange, “Di ka kepsen pas a Leklek kusun a kulam a minat, pa bel mila tasmani di aborbori taha.” ");
INSERT INTO lbb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","E Pita pa kaklik a asaer ning, dia han sur uting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dia rop dia dun, ika ning a halindiau i dun ot nigo ta e Pita uting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","I roh purum, pa i sidok pa i oroi a kaenla kaning ia, ika bel i kas. ");
INSERT INTO lbb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ning e Saimon Pita i hanot murmur tana, i kas uting na kulam a minat, pa i oroi a kaenla kama kaning la borbor tar. ");
INSERT INTO lbb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ika a kaen ning di iris tar a pukul e Iesu ono, bel i kes taum on dingla na kaen, di ka hin tari pa di suah masik tari. ");
INSERT INTO lbb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pa kaklik asaer ning i nigo ot tar uting na kulam a minat, i otleng i kas. I oroi pa i tortorot. ");
INSERT INTO lbb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Belot dia talapor ana warwara na Buk Tabu mang e Iesu ir kamtur ulak kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pa naur a kaklik asaer dia ulak sur a hanua. ");
INSERT INTO lbb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","E Maria Makdalen i tur tumo lapiu na kulam a minat pa i domos. Ning kaning ot i domos, i roh purum pa i sidok uting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","I oroi pas naur a angelo kaning ia, dia mermer ana kokok a kaenla, pa dia kes ting na pukna ning di aborbor tar a minat e Iesu ono. Ning i kes ting na ululnge, pa ning a halindiau i kes ting na kamkama. ");
INSERT INTO lbb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dia dekeni mange, “Wan, u domos sur asa?” I keles diau mange, “La ka los masik pas anuk a Leklek, pa bel a tasmani la aborbori taha.” ");
INSERT INTO lbb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ning i gilam, i oroi e Iesu kaning i tur tingia, ika bel i oroi lalani mang e Iesu ot ning. ");
INSERT INTO lbb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","E Iesu i dekeni mange, “Wan, u domos sur asa? U tai sur esi?” E Maria i nuki mang a barsan ning a tena tai alar ana barim, pa i atai i mange, “Lak, ning u los masik pas a minat e Iesu, ur atai iau, u aborbori taha, sur ar han par los pasi.” ");
INSERT INTO lbb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","E Iesu i kabahi mange, “Maria!” E Maria i gilam teteki pa i kabahi ana warwara Hibru mange, “Raboni!” a kamkamna mang a Tena Asaer. ");
INSERT INTO lbb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","E Iesu i atai i mange, “Gong u tong a palaok, anasa belot a han kas usaot tetek e Tata. Ur han tetek na tastasikla, pa ur atai la mang, ar han usaot tetek e Tata pa e Tamamulo, tetek anuk a God pa anumulo a God.” ");
INSERT INTO lbb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","E Maria Makdalen i han pa i atai a kakak a asaerla mange, “Ia ka oroi tar a Leklek.” Pa i atai la otleng ana warwarala ning e Iesu i atai tari ono. ");
INSERT INTO lbb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ana rah morom, ana ningnigo na pukakiar ana wik, a kakak a asaer la kes taum, pa la tagar alar la tingui na rumai, anasa la matatan a tarai Juda. Pa e Iesu i turot na arpotor inla, pa i atai la mange, “A balmolmol tetek mulo.” ");
INSERT INTO lbb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ning ka atong tari larne, i asangan tar naur a kuna pa kabarangragaina tanla. A kakak a asaerla, la gas kol ning la oroi a Leklek. ");
INSERT INTO lbb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","E Iesu i atong ulaki tanla mange, “A balmolmol tetek mulo. E Tata i sune iau, mang otleng larning ar sune mulo.” ");
INSERT INTO lbb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ning ka atong tar a warwara ne, i wus a wuwu na pahana onla, pa i atai la mange, “A Talngan Tabu ne, mulor kibasi ting na lalaun anumuloi. ");
INSERT INTO lbb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ning mulor nuk duman sen a toltol laulaula anuna tik, e God otleng ir kepseni kusuni. Ning bel mulor nuk duman sen a toltol laulau anuna tik, e God otleng bel ir kepseni kusuni.” ");
INSERT INTO lbb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","E Tomas, ning di atongi otleng mang a Kasang, i ning a hala bonot pa pisir naur a kakak a asaerla, bel i kes taum onla ning e Iesu i turot tetek la. ");
INSERT INTO lbb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","A kakak a asaer la atai i mange, “Mila ka oroi tar a Leklek!” Ika e Tomas i atai la mange, “Ning bel ar oroi tar a ngen a barbar ana naur a kuna pa bel ar subaran tar a pitlai kuk onoi, pa bel ar subaran a kuk ting na kabarangragaina, bel ar tortorot.” ");
INSERT INTO lbb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ning a wik alari, a kakak a asaer la kes taum ulak ting na rumai, la taum oe Tomas. La tagar alar pas la. Ika e Iesu i turot na arpotor inla, pa i atai la mange, “A balmolmol tetek mulo!” ");
INSERT INTO lbb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lamur i atai e Tomas mange, “Subaran a pitlai kum ute, pa ur oroi naur a kuk. Atostos a kum ute, pa ur subarani te na kabarangragaik. Pa gong ma u urmatana nuknuk, ur tortorot ka.” ");
INSERT INTO lbb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","E Tomas i atai i mange, “Anuk a Leklek pa nuk a God!” ");
INSERT INTO lbb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","E Iesu i atai i mange, “U bot tortorot anasa u oroi iau. La ning bel la oroi iau pa la tortorot, la angis.” ");
INSERT INTO lbb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","E Iesu i tol a galis a akinalang otleng na matana anuna kakak a asaerla, ning bel di tumusi te na buk ne. ");
INSERT INTO lbb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ika di tumus pas ka a ututnala ne, sur mulor tortorot mang e Iesu ai a Karisito, a Nat e God. Pa ning mulor tortorot onoi, mulor kibas ot a lalaun ana risana. ");
INSERT INTO lbb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lamur e Iesu i turot ulak tetek anuna kakak a asaerla tumo na hang a puka tasi Tiberias. A utna ne i hanot larne: ");
INSERT INTO lbb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","E Saimon Pita pa e Tomas, esaning di atongi otleng mang a kasang, pa e Natanael a te Kana miting na papar Galili, pa naur a nat e Sebedi, pa naur otleng a hala kakak a asaerla, la kes taum. ");
INSERT INTO lbb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Pa e Saimon Pita i atai la mange, “Ar han, ar migen a uben.” La kelesi mange, “Dala taum.” La kas ana mon pa la han. Ika ana morom ning, bel la dat pas ta sis. ");
INSERT INTO lbb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ana kobot ning ot, e Iesu i tur tumokorot latasi, ika a kakak a asaerla bel la oroi lalani mang e Iesu. ");
INSERT INTO lbb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pa e Iesu i deken la mange, “Kakakla, mulo dat pas ot al sis?” La puai mang, “Bel al.” ");
INSERT INTO lbb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","E Iesu i atai la mange, “Mulor migen a uben ting na ris a sot a kumulo, sur mulor dat pas al sis.” Pa la migeni larning i atai la. Pa la datdat panan a uben, anasa ka bukus ana sisla. ");
INSERT INTO lbb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","A kaklik asaer ning e Iesu i katnani, i atai e Pita mange, “A Leklek ot numo!” Ning e Saimon Pita i longori mang a Leklek, i pipis ulak pas a kaen ning i pak sen tari, pa i sirok uting latasi. ");
INSERT INTO lbb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A kakak a asaer la mur ana mon utumo latasi. Pa la dat purum a uben ning i bukus ana sisla, anasa bel la kes bakbak kusun a hang, i arlar ka ona takai a mar a mita. ");
INSERT INTO lbb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ning la sot ana mon, la oroi a barang a iah taum ana sisla kaning onoi, pa la oroi otleng a bretla. ");
INSERT INTO lbb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","E Iesu i atai la mange, “Mulor los al sis ute miting na sisla ning nokane mulo uben pasi.” ");
INSERT INTO lbb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pa e Pita i kas ana mon, pa i dat purum a uben utumo latasi. I bukus ana tatatnan sis, a wawas onla i arlar ana takai a mar dilima na bonot pa pisir natol (153). La galis kol, ika a uben bel i taksilir. ");
INSERT INTO lbb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","E Iesu i atai la mange, “Mulo han ute pa mulor hangan.” Bel tik tagun anuna kakak a asaerla i tolsot sur ir dekeni mang, “U esi?” La ka tasmani mang a Leklek ot ning. ");
INSERT INTO lbb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","E Iesu i los pas a bret pa i tabar la ono, pa lamur i tabar la kale ana sis. ");
INSERT INTO lbb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ine a munatol a tinanot ane Iesu tetek anuna kakak a asaerla lamur tana kamkamtur anunai kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ning la ka hangan pas, e Iesu i deken e Saimon Pita mange, “Saimon, nat e Jon, u mang kol sur iau tanla ne?” I kelesi mange, “Momol, Leklek, u tasmani mang a mang sur u.” E Iesu i atai i mange, “Ur tabar anuk na tona sipsipla.” ");
INSERT INTO lbb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","E Iesu i deken ulaki mange, “Saimon, nat e Jon, u mang kol sur iau?” I kelesi mange, “Momol, Leklek, u tasmani mang a mang sur u.” E Iesu i atai i mange, “Ur tai alar anuk na sipsip.” ");
INSERT INTO lbb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Munatol onoi e Iesu i dekeni mange, “Saimon, nat e Jon, u mang sur iau?” E Pita i nuk lingiri, anasa e Iesu ka dekeni munatol mang, “U mang sur iau?” I atai i mange, “Leklek, u tasman a ututnala rop. U tasmani mang a mang sur u.” E Iesu i atai i mange, “Ur tabar anuk na sipsip. ");
INSERT INTO lbb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“A atong momoli tam, ning u barman, u ot u amermer pas u, pa u han ting na pukna ning u mang sur ur han ia. Ika ning u ka bun, ur atostos naur a kum, pa tik ot ir amermer u, pa ir ben u ting na pukna ning bel u mang sur ur han ia.” ");
INSERT INTO lbb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E Iesu i atongi larne, sur ir aslang a ngas a hinirua ning ir kibas e Pita. Ana nuna hinirua ning ir aleklek e God. Lamur i atai i mange, “Ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","E Pita i talingir pa i oroi a kaklik asaer ning e Iesu i katnani kaning i mur diau. Esaning i tan tar oe Iesu ning la ka hangan, pa i deken e Iesu mange, “Leklek, esi ma ir saran tar u uting na kuna hiruala?” ");
INSERT INTO lbb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ning e Pita i oroi, i deken e Iesu mange, “Leklek, mangmangasa ma a barsan ne?” ");
INSERT INTO lbb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","E Iesu i kelesi mange, “Ning a mang sur ir laun tuk ning ar ulak, bel a utna anumi. Ika u, ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A warwara ne, i kamkamna sur ning a warwara otleng i han sarara tetek la ning la tortorot, mang a kaklik asaer ne bel ir mat. Ika e Iesu bel i atongi mang bel ir mat, i atongi ka mange, “Ning a mang sur ir laun tuk ning ar ulak, bel a utna anumi.” ");
INSERT INTO lbb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ine a kaklik asaer, ning i warwara talapor ana ututnala ne, pa i tumus akesi. Pa dala tasmani mang anuna warwara talapor, i momol kol. ");
INSERT INTO lbb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","E Iesu ka tol tar a galis a ututnala otleng. Ning dir tumus arop la, a nuki mang a rakrakan hanua bel i itna sur dir suah a bukla rop onoi. ");
INSERT INTO lbb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","3","Tetek e Tiopilus, Ana nuk a ningnigo na buk a tumus a ututnala rop ning e Iesu ka tol tari, pa ka asaer tar a taraila onoi, turpasi ana kamkama titol anunai, tuk ana pukakiar ning e God i los pasi usaot na langit. Lamur tan anuna minat, i hananot ulak tetek anuna aposella, pa a ututnala ning i toli i amomol tari mang ka laun ulak kusun a minat. Diat a bonot a pukakiar ning i kes ulak pasi te lapiu, i sira hananot tetek la, pa i warwara ana matanitu ane God. I asaer tar anuna aposella ana rakrakai ana Talngan Tabu, a aposella ning ka aslang pas la. ");
INSERT INTO lbb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ona ning a pukakiar miting na pukakiarla ning, ning ka kamtur ulak kusun a minat, la hangan taum pa i sairas la mang, “Gong mulo han kusun e Jerusalem, mulor kes nanan esaning e Tata ka lele tar onoi, ning ia ka atai tar mulo ono. ");
INSERT INTO lbb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","E Jon i baptais ana malum, pa bel i bongnani ning dir baptais mulo ana Talngan Tabu.” ");
INSERT INTO lbb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ning a aposella la kes taum oe Iesu, la dekeni mang, “Leklek, onone ur saran ulak a matanitu tetek mila, a tarai Israel, sur milar kes langolango kusun a matanitu Rom?” ");
INSERT INTO lbb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","I keles la mange, “Bel a utna anumuloi sur mulor tasman a pukakiar pa rau ning e Tata i warkurai tari sur ir sarani ono. ");
INSERT INTO lbb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ning a Talngan Tabu ir kes omulo, mulor kibas a rakrakai, pa ututnala ning mulo oroi tak mulor warwara talapor ono saot e Jerusalem, pa ting na hananuala rop tumo na naur a papar Judia pa e Samaria, pa ting na rakrakan hanua rop.” ");
INSERT INTO lbb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ning i arop anuna warwara, e God i los kas pasi usaot na langit na matmatanla. Lamur a laukap i poroi alari kusun la. ");
INSERT INTO lbb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kaning ot la tadai murmur e Iesu, ning i han kusun la usaot na langit, naur a barsan dia mermer taum ana kokok a kaenla, dia turot kakat ting na risinla. ");
INSERT INTO lbb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Pa dia atongi mang, “A tarai Galili, sur asaning mulo tur pa mulo tadai tikin usaot na langit? E Iesu ning di ka los pasi kusun mulo usaot na langit, ir hanot ulak ute, larotne mulo ka oroi i, ning i han usaot.” ");
INSERT INTO lbb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lamur a aposella la ulak usaot e Jerusalem, misaot na mangir di atongi a Mangir Oliw. I milau ka e Jerusalem, i arlar ka ana takai a kilomita. ");
INSERT INTO lbb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ning la hanot saot e Jerusalem, la kas usaot na tuka rumai, ning la borborbor pa la keskes ia. La ne, la kes taum tingia: E Pita, Jon, Jems, Endru, Pilip, Tomas, Batolomiu, Matiu, Jems a nat e Alpius, e Saimon ning tagun a kunum Silot, pa e Judas, a nat a maskan a Jems. ");
INSERT INTO lbb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","La taum ma e Maria, e tana e Iesu, pa na tastasna e Iesu, pa dingla na gurarala otleng. La rop bel la manah ona niaring ana pukakiarla. ");
INSERT INTO lbb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ona ning a pukakiar na arpotor tana pukakiarla ning, a tena tortorotla la kes taum, la rop la arlar ana takai a mar pa pisir naur a bonot. E Pita i tur pa i atongi mang, ");
INSERT INTO lbb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Na tastasikla, a warwara anuna Talngan Tabu, ning e Dewit i warwara tar onoi nating ting na Buk Tabu, onone di ka tolsot pasi. I warwara oe Judas esaning i nigon la ning la tong pas e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","I ning a halimila, pa i arnangai ana titol ne.” ");
INSERT INTO lbb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","E Judas i lou pas ning a puka kabalapiu ana mani tagun anuna toltol laulau. Tingia na nuna kabalapiu i punga purum, pa balana i tapuros potor, pa suan na balana i purum rop. ");
INSERT INTO lbb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","La rop ning la kes tisa e Jerusalem, la longori, pa la atong a kabalapiu ning ana nunla warwara mang Akeldama, a kamkamna mange, a kabalapiu a suluk. ");
INSERT INTO lbb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","E Pita i atongi mang, “Di ka tumus tari ting na Saksakla ane Dewit mang, ‘Anuna rumai ir belbel, pa gong tik i kes tingia.’ Pa di tumusi otleng manglarne, ‘Tik ir kelesi ana nuna titol.’ ");
INSERT INTO lbb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","I wakak ning dalar aslang pas ta barsan sur i otleng a tena warwara talapor taum ondala oe Iesu, ana nuna kamkamtur ulak kusun a minat. I wakak ning ta halindala, ning dala keskes taum oe Iesu. A barsan ning i kes taum ondala turpasi ning e Jon i baptais tuk ana pukakiar ning di los pas e Iesu kusun dala usaot na langit.” ");
INSERT INTO lbb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pa la atong otnan pas naur: E Josep, di atongi e Barsabas, pa ning a risana otleng e Jastus, diau ma e Matias. ");
INSERT INTO lbb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pa la araring mang, “Leklek, u tasman a balana taraila rop, ur asangan mila, esi na halindiau momol ning u ka aslang tari, ");
INSERT INTO lbb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","sur ir kibas a titol na aposel, ning e Judas ka mat pas kusuni pa ka han uting na hanua ning i arlar taum ana nuna toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pa la tol a titol na aslang ana naur a hat, pa hat ane Matias i hanot. Pa la was taman e Matias tetek ning a bonot pa pisir takai a aposella. ");
INSERT INTO lbb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ning a pukakiar a Pentikos i hanot, a tena tortorotla rop la kes taum ting na ning a rumai. ");
INSERT INTO lbb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pa unga misaot na langit i arlar ana unga ana tnan wuwu, i hanot kulkulan tetek la, pa i abukus pas a rumai ning la kes ono. ");
INSERT INTO lbb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pa la oroi a ututnala la arlar ana irnga na iah, la han sarara pa la kes saot onla taktakai. ");
INSERT INTO lbb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pa la rop la bukus ana Talngan Tabu, pa la turpas a warwara ana urmatana warwarala, ning a Talngan Tabu i sarani tanla. ");
INSERT INTO lbb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pa galis a te Judala otleng la kes tisaot e Jerusalem, la na tena lotu miting na matanitula rop te na rakrakan hanua. ");
INSERT INTO lbb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ning la longor a unga ne, la dun ot taum, pa i loklokron a nuknukinla onoi, anasa la taktakai la longor anunla na warwara, ning a tena tortorotla la warwara ono. ");
INSERT INTO lbb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pa la rop la kulkulan pa la nuknuk kol ana utna ne, pa la atongi mange, “Oroi, la ne, ning la warwara, a tarai Galili rop ka! ");
INSERT INTO lbb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Asa kamkamna ning dala rop taktakai, dala longor lalan anundala na warwara? ");
INSERT INTO lbb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Dala na te Partiala, a te Midiala, a te Elamla, pa dala mitumo na paparla ne Mesopotemia, Judia, Kapadosia, Pontus, Esia, ");
INSERT INTO lbb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigia, Pampilia pa e Ijip. Dala mitumo na papar Libia ning i milau e Sairini, pa dingla na tarai mitumo e Rom. Dala na tarai Juda pa dingla ondala ning la kas ting na lotu Juda. ");
INSERT INTO lbb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Pa dala miting e Krit pa papar Arebia. Dala rop dala longor la ning la warwara ana tatatnan titol ane God ana nundala na warwara.” ");
INSERT INTO lbb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Pa la kulkulan, pa i loklokron a nuknukinla, pa la deken artalai la mang, “Asa kamkamna a utna ne?” ");
INSERT INTO lbb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ika dingla na tarai la morot onla, pa la atongi mang, “La gang a wain pa la sipak ono.” ");
INSERT INTO lbb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lamur e Pita i tur taum ana ning a bonot pa pisir takai aposella, pa i warwara kol tetek a taraila mange, “Mulo a tarai Juda, pa mulo rop ning mulo kes te Jerusalem, ar atalapor a utna ne tamulo, pa mulor longor wakaki. ");
INSERT INTO lbb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mulo atongi mang la sipak. Ika bel, anasa i 9 kilok ot ne ana kobot. ");
INSERT INTO lbb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","A utna ne mulo oroi, a propet Joel ka warwara nigo tar onoi mang, ");
INSERT INTO lbb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘E God i atongi mange: Ana ararop a pukakiarla ar saran purum a Inguk tetek a taraila rop. A natnatumulola, a taraila pa gurarala, lar warwara na propet. Anumulo na barmanla lar oroi a tatataila, pa numulo na bun lar resnan a reresala. ");
INSERT INTO lbb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ana pukakiarla ning, ar saran a Inguk tetek la otleng ning anuk na tena titol oros, a taraila pa gurarala, pa lar warwara na propet. ");
INSERT INTO lbb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Par asangan a ututnala na kulkulan saot na langit, pa akinalangla te lapiu na rakrakan hanua, lar a suluk, a iah, pa a tnan sasawan. ");
INSERT INTO lbb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A kamis ir mormorom, pa kalang ir kubar, lar a suluk, pa lamur a pukakiar ana Leklek ir hanot, a tnan pukakiar ning, a pukakiar a matatar. ");
INSERT INTO lbb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pa la rop ning la araring tetek a Leklek, ir alaun la.’ ");
INSERT INTO lbb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“A tarai Israel, mulor longor iau. Ar atai mulo oe Iesu, a te Nasaret. Mulo ot mulo tasmani mang ana rakrakai e God, i tol a ututnala na kulkulan, pa rakrakai a titolla pa akinalangla. I toli na arpotor imulo, sur e God ir asangani tetek mulo mang i ot i sune seni. ");
INSERT INTO lbb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Di saran tar e Iesu tamulo, pa mulo taum ana laulau a taraila, mulo sai ahati saot na rakai kutus. E God ka tasman nigon tari mang a ututnala ne ir hanot arlar ana nuknukna. ");
INSERT INTO lbb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ika e God i akamtur ulak pasi, pa i kepsen a kankan a minat kusuni, anasa a minat bel i tolsot sur ir tong akesi. ");
INSERT INTO lbb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","E Dewit ka atong tari oe Iesu mang, ‘A tasmani mang a Leklek i kes bolbolos na matak. Bel ar koloron, anasa i kes te na sot a kuk. ");
INSERT INTO lbb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","A balak i gas kol, pa a warwara taum ana gasgas, pa a tortorot mang ur alaun a palaok, ");
INSERT INTO lbb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","anasa bel ur noren sen iau ting na kulam a minat, pa bel ur noren tar a Tena Totoh anumi sur ir marase. ");
INSERT INTO lbb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","U ka asangan tar iau ana ngasla sur a lalaun. Ning ar kes taum hom, ur abukus iau ana gasgas.’ ");
INSERT INTO lbb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Na tastasikla, ar warwara talapor tetek mulo oe Dewit, a tubundala tagun nating. I mat pa di akasi ting na kulam a minat, pa anuna kulam a minat kanet tandala tuk onone. ");
INSERT INTO lbb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ika e Dewit ai a propet, pa i tasmani mang e God ka lele tar teteki mang i ot ir akes tar tik miting na mangis a tarai anunai, sur ir kelesi ana nuna keskes a king. ");
INSERT INTO lbb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","E Dewit ka tasman nigon tar a utna ning ir hanot, pa i atong a warwara ne ana kamkamtur ulak ane Karisito, mang bel di noren seni ting na kulam a minat pa a palaona bel i marase. ");
INSERT INTO lbb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","E Iesu ot ning, e God i akamtur pasi kusun a minat, pa mila rop mila oroi pa mila warwara talapor onoi. ");
INSERT INTO lbb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Di aleklek pasi pa di akesi ting na sot a kuna e God, pa e God e Tamana ka saran tar a Talngan Tabu teteki larning i lele tari, pa onone e Iesu ka saran purum tar a utna ne mulo oroi pa mulo longori. ");
INSERT INTO lbb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","E Dewit bel i han usaot na langit, ika i atongi mange, ‘A Leklek i atongi tetek anuk a Leklek, “Ur kes te na sot a kuk, ");
INSERT INTO lbb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tuk ning ar tolsot pas anum na hiruala sur lar kes nahaim.” ’ ");
INSERT INTO lbb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ Mulo a tarai Israel rop mulor tasman wakaki, mang e Iesu ning mulo sai ahati saot na rakai kutus, e God ka akes tari sur ai a Leklek pa Karisito otleng.” ");
INSERT INTO lbb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ning la longor a warwara ne, i so na balanla, pa la deken e Pita pa dingla na aposel mang, “Na tastasimila, asaning milar toli?” ");
INSERT INTO lbb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","E Pita i keles la mang, “Mulo rop taktakai mulor lingir a nuknukimulo, pa dir baptais mulo ana risana e Iesu Karisito, sur dir kepsen anumulo na toltol laulaula, pa mulor kibas a Talngan Tabu. ");
INSERT INTO lbb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","A artabar ne e God ka lele tar ono, ir han tetek mulo, pa na natnatumulo, pa la otleng ning la kes bakbak. Pa ir han tetek la rop, ning a Leklek anundala a God, ir kabah pas la teteki.” ");
INSERT INTO lbb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pa i atumarang la ana galis a warwara otleng, pa i nunung rakrakai la mang, “Mulor tai alar mulo, pa mulor tur masik kusun a toltol laulau anuna tarai tagun onone, sur gong e God i saran a warkurai a arkeles tetek mulo.” ");
INSERT INTO lbb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","La ning la kibas a warwara ane Pita di baptais la. La arlar ana natol a rip, pa di was taman la ana tena tortorotla. ");
INSERT INTO lbb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Pa la saran tar la ot ana asaer anuna aposella, ana keskes taum ana marmaris, pa ana keskes taum ana utna na hangan, pa ana niaring. ");
INSERT INTO lbb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A aposella la tol a galis a utna na kulkulan, pa galis a akinalang otleng, pa taraila rop la hanrawai e God. ");
INSERT INTO lbb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A tena tortorot rop la kes taum, pa ututnala rop ning anunla taktakai, anunla rop ka. ");
INSERT INTO lbb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","La siuran anunla na puka kabalapiu pa nunla na ututnala, pa mani taguni la salari tetek esining i kapan. ");
INSERT INTO lbb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","La sira kes taum ting na woroh na rumai artabar ana pukakiarla rop. La hangan taum ting na nunla na rumaila ana gasgas pa momolna ting na balanla. ");
INSERT INTO lbb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pa la rakan aleklek pas e God, pa taraila rop la gas onla. Pa ana pukakiarla rop a Leklek i alaun a galis a tarai, pa di was taman la ana tena tortorotla. ");
INSERT INTO lbb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ning a pukakiar e Pita pa e Jon dia han usaot na rumai artabar, sur a lotu na niaring, ona 3 kilok ana rah. ");
INSERT INTO lbb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A tarai la los ning a barsan bel i sira han, di agon pasi mang ot larning. Pa ana pukakiarla rop, la akakesi ting na taman na rumai artabar, di atongi mang a wakak a taman, sur ir nununung utna tanla ning la kas. ");
INSERT INTO lbb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ning i oroi e Pita pa e Jon dia mang sur diar kas, i nunung diau sur al mani. ");
INSERT INTO lbb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pa dia tai tostos teteki, pa e Pita i atai i mang, “Ur ngoson miau!” ");
INSERT INTO lbb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","I ngoson diau, pa i kes nanan diau sur al utna tandiau. ");
INSERT INTO lbb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pa e Pita i atai i mange, “Iau bel al mani, ika ar tabar u ana utna ning anuki. Ana risana e Iesu Karisito, a te Nasaret, ur tur pa ur han!” ");
INSERT INTO lbb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","E Pita i tong pas a sot a kuna, i dat atur pasi, pa ano otning naur a hana dia rakrakai. ");
INSERT INTO lbb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","I tur kapit, pa i han. Pa ditol kas uting na woroh na rumai artabar, i hanan, i sirsirok pa i rakan aleklek e God. ");
INSERT INTO lbb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ning a taraila rop la oroi ning i han, pa i rakan aleklek e God, ");
INSERT INTO lbb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","la oroi lalani mang i ka, esaning i keskes, pa i sira nunung utna ting na wakak a taman, pa la kulkulan kol ana utna ne di toli onoi. ");
INSERT INTO lbb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pa barsan ne i tong akes e Pita pa e Jon, pa taraila rop la kulkulan kol pa la dun tetek ditol ting na parada na rumai artabar, ning di atongi mang a Parada ane Solomon. ");
INSERT INTO lbb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ning e Pita i oroi la, i atai la mang, “Mulo a tarai Israel, sur asaning mulo kulkulan ana utna ne pa mulo ngoson rakrakaimiau? Mangasa, mulo nuki mang mia alangolango pas a barsan ne ana rakrakaimiau ot, o anasa mia tol a toltol ning e God i mang suri? Bel! ");
INSERT INTO lbb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","E God ot i toli. A God ane Abaram, Aisak pa e Jekop, a God anuna nundala mangis a tarai tagun nating, i aleklek e Iesu anuna tena titol. Mulo saran tari sur dir sai koli, pa mulo puain seni na matana e Pailat, ning i mang sur ir pak seni. ");
INSERT INTO lbb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mulo puain sen a Tena Totoh pa Tena Tostos, pa mulo nunung sur dir pak sen a tena umkol a tarai tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pa mulo umkol e Iesu, ning a kama lalaun, ika e God i akamtur ulak pasi kusun a minat. Pa mila oroi i, pa mila warwara talapor onoi. ");
INSERT INTO lbb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ana tortorot ana risana e Iesu, di arakrakai pas naur a hana barsan ning mulo oroi i, pa mulo tasmani. Ana tortorot ana risana e Iesu di alangolango pas a barsan ne na matamulo rop. ");
INSERT INTO lbb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Na tastasik, a tasmani mang mulo taum ana numulo na ningnigo otleng bel mulo tasman asaning mulo toli oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ika ana ututnala ne mulo toli, e God i tolsot pas a ututnala ning ka atong tari nating ana warwara anuna propetla rop mang, anuna Karisito ir mat. ");
INSERT INTO lbb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mulor lingir a nuknukimulo, pa mulor han tetek e God, sur ir kepsen anumulo na toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Pa mulor kilang a wakak a lalaun tana Leklek, pa ir sune a Karisito tetek mulo, e Iesu ning e God ka aslang tari. ");
INSERT INTO lbb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ir kes saot na langit, tuk ana pukakiar ning e God ir atona ulak a ututnala rop, ning ka lele nigo tar onoi ana warwara anuna tostos a propetla anunai. ");
INSERT INTO lbb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Anasa e Moses i atongi mang, ‘A Leklek anumulo a God ir sune ta propet arlar hok tetek mulo, miting na numulo a mangis a tarai. Mulor longor a ututnala rop ning ir atongi tamulo. ");
INSERT INTO lbb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Esining bel i longor tana propet ning, dir umsem onoi kusun a taraila ane God.’ ");
INSERT INTO lbb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“A propetla rop ning la warwara ana warwara ane God, turpasi oe Samuel, pa la ning la hanot lamur tana, la warwara nigo ana pukakiarla ne. ");
INSERT INTO lbb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A warwara anuna propetla anumuloi ka, pa kunubus otleng ning e God i tol tari tetek anumulo a mangis a tarai nating, ning i atongi tetek e Abaram mang, ‘Oe tubum ar angis a mangis a tarai rop te na rakrakan hanua.’ ");
INSERT INTO lbb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ning e God i sune sen anuna Tena Titol, i sune nigoni tetek mulo, sur ir angisngis mulo, ning ir ben ulak mulo rop kusun anumulo na toltol laulau.” ");
INSERT INTO lbb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ning e Pita pa e Jon dia warwara tetek a taraila, a tena artabarla tetek e God, pa ningnigo anuna tena tai alarla miting na rumai artabar, pa Sadusila, la han tetek diau. ");
INSERT INTO lbb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","La balakut diau, anasa dia asaer a taraila mange, a minatla lar kamtur ulak kusun a minat, arlar lar a kamkamtur ane Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","La dat pas diau pa la akas diau uting na karabus, sur diar kes tuk latu, anasa ka rah. ");
INSERT INTO lbb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ika, a galis ning la longor a warwara ane Pita pa e Jon, la tortorot. Pa wawas ana taraila ka ning la tortorot i arlar ana dilima na rip. ");
INSERT INTO lbb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ana pukakiar lamur tana, a ningnigola, pa tarai a kiwung pa tena asaerla tagun a warkurai, la kes taum saot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","La taum ma e Anas, a ningnigo na tena artabar tetek e God, pa na maina ne: E Kaiapas, e Jon, e Aleksanda, pa dingla na tarai otleng. ");
INSERT INTO lbb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","La ben pas e Pita pa e Jon pa dia tur na matanla, pa la deken diau mang, “Esi na ngas a rakrakai, pa ana risana esi, ning mu tol a utna ne onoi?” ");
INSERT INTO lbb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","E Pita i bukus ana Talngan Tabu, pa i atai la mang, “Mulo a ningnigola anuna taraila pa tarai a kiwung otleng, ");
INSERT INTO lbb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","onone mulo deken miau ana wakak a titol ne mia toli ana barsan, ning bel i sira han pa di alangolango mangasa pasi. ");
INSERT INTO lbb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mulo taum ana tarai Juda rop, mulor tasmani mang, a barsan ne i tur salanigo tamulo, di alangolango pasi ana risana e Iesu Karisito a te Nasaret, esaning mulo sai ahat tari saot na rakai kutus, pa e God i akamtur ulak pasi kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","E Iesu ‘A hat ning mulo na tena tol rumai mulo kepseni, i ot ning a wakak a hat kes, ning di tol a rumai saot ono.’ ");
INSERT INTO lbb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bel tik masik ir alaun dala, pa bel ta risana tik otleng te na rakrakan hanua, ning e God i saran tari tetek a taraila sur dir alaun dala onoi.” ");
INSERT INTO lbb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","La tasmani mang e Pita pa e Jon naur a barsan oros ka, bel dia asaer pas on ta tnan asaer. Pa la kulkulan kol ondiau ning dia warwara pa bel dia matmataut. Pa la tasmani mang nating ditol sira armuri taum ma e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ika ning la oroi a barsan ning di alangolango pasi, i tur taum ondiau, bel al warainla ma sur lar keles diau. ");
INSERT INTO lbb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","La sune maskan sen ditol kaba kusun a kiwung, pa la warwara taum pas mange, ");
INSERT INTO lbb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Dalar tol asa ana naur a barsan ne? Anasa dia ka tol tar ning a tnan utna na kulkulan, pa ka talapor tetek la rop ning la kes te e Jerusalem. Pa dalar puai mangmangasa? ");
INSERT INTO lbb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Dalar sairas rakrakai diau, sur gong ulak ma dia warwara tetek tik ana risana e Iesu, sakana a warwara ne ir han sarara tetek a taraila rop.” ");
INSERT INTO lbb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lamur la kabah ulak pas diau, pa la sairas diau sur gong ma dia warwara pa dia asaer halala ana risana e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ika e Pita pa e Jon dia keles la mange, “Mangasa, i tostos na matana e God ning miar longor tetek mulo, pa tetek e God gong? Mulo ot mulor oroi sursuri. ");
INSERT INTO lbb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ika miau, bel mia tolsot sur miar sairas miau ana warwara ona ututnala ning mila ka oroi tari, pa mila ka longor tari.” ");
INSERT INTO lbb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ning la ka sairas rakrakai tar diau, la pak sen diau. Bel la pastek ta utna ning lar um diau onoi, anasa a tarai la rakan aleklek pas e God ana utna na kulkulan ning dia ka tol tari. ");
INSERT INTO lbb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Anasa a barsan ning di tol tar a utna na kulkulan onoi pa i langolango, anuna rau a lalaun ka bolos tar diat a bonot a rau. ");
INSERT INTO lbb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ning di ka pak sen e Pita pa e Jon, dia ulak tetek na halalindiau, pa dia atai la ana warwarala rop ning a leklek a tena artabarla tetek e God pa ningnigola la ka atong tari tandiau. ");
INSERT INTO lbb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ning la longori, la araring taum tetek e God mange, “Leklek, u akes a langit, a rakrakan hanua, a tasi, pa ututnala rop tingia onditol. ");
INSERT INTO lbb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pa ana Talngan Tabu u warwara tetek a tubumila e Dewit anum a tena titol mange, ‘Asa kamkamna ning a taraila ning bel a tarai Israel la balakut kol, pa la pinpidaiwol sur lar tol na toltol laulau? Ika anunla pinpidaiwol i utna oros ka. ");
INSERT INTO lbb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","A kingla mite na rakrakan hanua la tur na harum, pa ningnigola la han taum, sur lar alaulau a Leklek pa anuna Mesaia, ning i aslang pasi.’ ");
INSERT INTO lbb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","A momolna, e Herot pa e Pontius Pailat la han taum ana taraila ning bel a tarai Israel, pa tarai Israel otleng, te na hanua ne, sur lar alaulau anum a Totoh na Tena Titol e Iesu, ning u ka aslang pasi. ");
INSERT INTO lbb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ning la toli manglarning, la tolsot pas a ututnala ning nating u ka sang tari ana rakrakaim pa nuknukim sur ir hanot. ");
INSERT INTO lbb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Leklek, onone ur nuk pas anunla na rakrakai a warwara, pa ur arakrakai mila, anum a tena titol orosla, sur gong mila matmataut ning milar warwara talapor ana num a warwara. ");
INSERT INTO lbb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pa ur nangan mila ana rakrakaim sur a tinsamanla lar langolango, a ututna na kulkulan pa akinalangla lar hanot ana risana e Iesu, anum a Totoh a Tena Titol.” ");
INSERT INTO lbb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ning la ka araring pas, a rumai ning la kes onoi, i gulgule, pa la rop la bukus ana Talngan Tabu, pa la warwara ana warwara ane God, pa bel la matmataut. ");
INSERT INTO lbb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A tena tortorotla rop, takai ka a nuknukinla pa balanla, pa bel tik ta halinla i atong tar ta utna mang anunai ka. La suah taum a ututnala sur anunla rop. ");
INSERT INTO lbb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A aposella la warwara talapor taum ana tnan rakrakai, ana lalaun ulak ana Leklek e Iesu kusun a minat ning la ka oroi tari. Pa tnan marmaris ane God i kes onla rop. ");
INSERT INTO lbb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bel tik ta halinla i kapan sur ta utna, anasa la ning anunla na puka kabalapiula pa la otleng ning anunla na rumaila, la siuran la, pa mani ono, ");
INSERT INTO lbb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","la losi tetek a aposella. Pa la salari tetek esining i kapan. ");
INSERT INTO lbb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pa e Josep otleng, a barsan misaot na lolo Saiprus, i miting na mangis a tarai Liwai, ning a aposella la atongi e Barnabas, a kamkamna mang a Tena Wunan. ");
INSERT INTO lbb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I siuran pas ning a puka kabalapiu anunai, pa i los a mani onoi tetek a aposella. ");
INSERT INTO lbb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ning a barsan a risana e Ananias taum oe nuna hane a risana e Sapaira dia otleng dia siuran ning a puka kabalapiu. ");
INSERT INTO lbb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pa dia malmaling taum sur diar tong akes ta tuka mani ning di lou tar a kabalapiu ono, pa ta tuka mani ka e Ananias i losi tetek a aposella. ");
INSERT INTO lbb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pa e Pita i atai i mang, “Ananias, sur asaning u malmaling pas e Satan sur ir solong a balam pa u asongo a Talngan Tabu? Sur asaning u bunur pas a tuka mani ning di lou tar a puka kabalapiu onoi? ");
INSERT INTO lbb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ning a kabalapiu kaning ot tam, anumi ot. Pa ning u siuran pasi, u ot u warkurai sur a mani onoi. Asa kamkamna ning u nuk pas a laulau a toltol ne? Bel u asongo a taraila, u asongo ot e God.” ");
INSERT INTO lbb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ning e Ananias i longor a warwara ne, i punga purum pa i mat. Pa la rop ning la longor a arkaltai onoi, la matmataut kol. ");
INSERT INTO lbb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","A kakak tarai la hanot, la poroi pas a minatna, la los purumi, pa la pori. ");
INSERT INTO lbb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ning natol a awa alar tar a minat e Ananias, e nuna hane i kas, ika bel i tasman a utna ning i hanot. ");
INSERT INTO lbb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pa e Pita i dekeni mang, “Ur atai iau, a matana kabalapiu rop ot ne, ning mu siuran pasi?” Pa i kelesi mang, “Momol, a matana ot ning.” ");
INSERT INTO lbb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","E Pita i atongi tana mang, “Sur asa mu taum ma e num mese mu malmaling pas sur mur lar a Ingun a Leklek? Oroi, la ning la por e num mese, la kane na taman, onone lar los purum u otleng.” ");
INSERT INTO lbb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ano otning i punga purum salanigo ta e Pita, pa i mat. Pa kakak tarai la kas, la oroi mang ka mat, la los purum a minatna, pa la pori ting napir e nuna mese. ");
INSERT INTO lbb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Pa tarai a lotula rop la matmataut kol, pa la rop otleng ning la longor a ututnala ne. ");
INSERT INTO lbb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","A aposella la tol a galis a akinalang pa galis a utna na kulkulan tana taraila. Pa tena tortorotla rop la sira kes taum ting na parada na rumai artabar ning di atongi mang a Parada ane Solomon. ");
INSERT INTO lbb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","A taraila masik, la hanrawai kol la, ika la matmataut sur lar kes taum onla. ");
INSERT INTO lbb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ika a galis, a taraila pa gurarala kale, la bot tortorot ona Leklek, pa di was taman la ana tarai a lotula. ");
INSERT INTO lbb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ning a tarai la oroi a titol anuna aposella, la los la ning la kurah pa di aborbor la ting na ris a ngas saot na logo ngasinla pa ting na matla, sur ning e Pita ir bolos la, a manarna ir han saot on hala onla pa lar langolango. ");
INSERT INTO lbb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pa galis a taraila mitumo na hananuala milau e Jerusalem, la hanot. La los a tinsamanla pa la ning a motla la alaulau la, pa di alangolango arop la. ");
INSERT INTO lbb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","A ningnigo na tena artabar tetek e God, pa halalnala rop miting na kunum a Sadusila, la bal laulau kol ona aposella. ");
INSERT INTO lbb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pa la dat pas a aposella, pa la akas la utingui na karabus. ");
INSERT INTO lbb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ika ana morom, ning a angelo anuna Leklek i sapang a tamanla ting na karabus, pa i ben purum la pa i atongi mang, ");
INSERT INTO lbb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mulor han, pa mulor tur ting na woroh na rumai artabar, pa mulor atai a taraila ana warwarala rop ana tona lalaun ne.” ");
INSERT INTO lbb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pa kobot ning ot, la kas uting na woroh na rumai artabar pa la asaer a taraila, larning di ka atai tar la. Ning a ningnigo na tena artabar tetek e God pa halalnala la hanot, la kabah taum a tarai a kiwung rop, a ningnigola anuna tarai Israel. Pa la arsune utumo na karabus sur dir ben pas a aposella. ");
INSERT INTO lbb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ika ning a tena tai alarla miting na rumai artabar la hanot, bel ma la oroi la ting na karabus. La ulak, pa la warwara mang, ");
INSERT INTO lbb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ning mila hanot ting na karabus, mila oroi mang di ka tagar rakrakai tar ot, pa tena tai alarla kaning ot la tur ting na tamanla, ika ning mila sapang a tamanla, bel ma mila oroi la.” ");
INSERT INTO lbb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ning a ningnigo anuna tena tai alarla pa leklek a tena artabarla tetek e God la longor a warwara ne, i loklokron a nuknukinla onoi, mang asa ma ir hanot. ");
INSERT INTO lbb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lamur ning a barsan i hanot, pa i atai la mang, “Oroi, a tarai ning mulo akas tar la te na karabus, la kanumo ma na woroh na rumai artabar, pa la asaer a taraila.” ");
INSERT INTO lbb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","A tena tai alarla taum ana nunla ningnigo la ben pas a aposella. La ben wakak pas la ka, anasa la matatan a taraila, sakana lar wolot la. ");
INSERT INTO lbb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ning la ka ben pas a aposella, la atur la na matana tarai a kiwung. Pa ningnigo na tena artabar tetek e God i atai la mang, ");
INSERT INTO lbb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Mila ka sairas rakrakai tar mulo mang gong mulo asaer a taraila ana risana e Iesu. Ika onone, a hanua Jerusalem ka bukus ana numulo na asaer, pa mulo mang sur mulor tiu mila ona minat e Iesu.” ");
INSERT INTO lbb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","E Pita pa aposella la kelesi mang, “Milar longor ot ta e God, pa bel milar longor tana tik. ");
INSERT INTO lbb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","A God anuna nundala mangis a tarai tagun nating i akamtur ulak e Iesu, esaning mulo ka umkol tari saot na rakai kutus. ");
INSERT INTO lbb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","I ot ning e God i aleklek pasi pa i akesi ting na sot a kuna, sur a Ningnigo pa Tena Alaun, pa ir tol a ngas sur a tarai Israel lar lingir a nuknukinla, pa dir kepsen anunla na toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mila oroi a ututnala ne, pa mila warwara talapor onoi, pa Talngan Tabu i amomol tar anumila na warwara. A Talngan Tabu, ai a artabar ane God tetek la ning la longor tana.” ");
INSERT INTO lbb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ning la longor a warwara ne, la balakut kol, pa la mang sur lar umkol a aposella. ");
INSERT INTO lbb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ika ning a Parisaio, a risana e Gamaliel, a tena asaer ana Warkuraila ane Moses, esaning a taraila rop la hanrawai i, i tur ting na kiwung, pa i atongi mang a aposella lar purum kaba. ");
INSERT INTO lbb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pa i atai a tarai a kiwung mang, “Mulo a tarai Israel, mulor nuknuk wakak ana saning mulor toli ona taraila ne. ");
INSERT INTO lbb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dingla na rau nating e Teudas i hanot, pa i iaunani mang i itna, pa galis a tarai, ngandek i arlar ana diat a mar, la muri. Ika ning di umkoli, la rop ning la muri la han sarara, pa anuna titol i rop oros ka. ");
INSERT INTO lbb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lamur ta e Teudas, ning kale, e Judas, a te Galili, i hanot ana rau na tumus risandi, pa i ben maskan pas dingla na tarai sur lar harum taum ana matanitu. I otleng i hirua, pa la rop ning la muri, la han sarara. ");
INSERT INTO lbb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“I maining, onone a atai mulo mang: Gong mulo tol ta utna onla, mulor pak sen la. Ning a utna ne la toli i kamna ka tana taraila, ir rarop ka. ");
INSERT INTO lbb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ika ning i kamna ot oe God, mulor tol panai sur mulor sairas la. Sakana lamur ir talapor tetek mulo mang mulo harum taum oe God.” ");
INSERT INTO lbb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","La malmaling ana nuna warwarala, pa la kabah ulak a aposella, la miras la, pa la sairas la mang gong ma la warwara ana risana e Iesu. Pa lamur la pak sen la. ");
INSERT INTO lbb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pa a aposella la purum miting na kiwung, la gas, anasa e God i oroi la mang, la wakak sur lar kilang a meme ana risana e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ana pukakiarla rop ting na woroh na rumai artabar, pa ting na rumai ngasinla, bel la manah ana asaer pa warawai ana Wakak a Warwara mang e Iesu ai a Karisito. ");
INSERT INTO lbb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ana pukakiarla ning, a tarai a asaerla la galis amon. Dingla na tarai Juda la warwara ana warwara Grik, pa dingla onla la warwara ana warwara Hibru. La ning la warwara Grik la warwara na ururai onla ning la warwara Hibru, anasa la hanan lakai a laola anuna Grikla, ning la sira asauran a utna na hangan tana laola ana pukakiarla rop. ");
INSERT INTO lbb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pa ning a bonot pa pisir naur a aposel la kabah taum a tarai a asaerla rop, pa la atai la mang, “Bel i tostos ning milar molot ka ana artabar ana utna na hangan, pa bel milar tol a titol na warwara talapor ana warwara ane God. ");
INSERT INTO lbb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Na tastasimila, mulor aslang pas ir mais a wakak a barsan miting omulo, ning la tastasman pa la bukus ana Talngan Tabu, sur milar saran tar a titol na artabar ne tanla. ");
INSERT INTO lbb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pa mila, milar molot ka ana niaring pa titol na warwara talapor ana warwara ane God.” ");
INSERT INTO lbb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pa la rop la gas ana warwara ne. Pa la aslang pas e Stiwen, a barsan ning i bukus ana tortorot pa a Talngan Tabu. Pa la aslang pas otleng e Pilip, e Prokorus, e Nikano, e Timon, e Pamenas, pa e Nikolas, a barsan mitumo e Antiok ning bel a te Juda, ika i kas uting na lotu Juda. ");
INSERT INTO lbb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","La ben la tetek a aposella. Pa la suah a kunla saot onla, pa la araring. ");
INSERT INTO lbb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A warwara ane God i han sarara, pa tarai a asaerla la galis amon saot e Jerusalem. Pa galis a tena artabar tetek e God la tortorot pa la longor ana Wakak a Warwara. ");
INSERT INTO lbb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","E Stiwen i bukus ana rakrakai pa marmaris ane God, pa i tol a tatatnan utna na kulkulanla, pa akinalangla na arpotor a taraila. ");
INSERT INTO lbb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ika dingla na tarai Juda la arngaras taum oe Stiwen. A taraila ne miting na ning a kunum ning di atongi A Rumai Lotu anuna Langolango na Tarai. La miting na naur a hanua, e Sairini, pa e Aleksandria pa mitumo na naur a papar Silisia pa e Esia. ");
INSERT INTO lbb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","La tol panai sur lar keles anuna warwara anasa a Talngan Tabu ot i saran a mananos tana. ");
INSERT INTO lbb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pa la arakrakai kumnan pas dingla na tarai, sur lar atongi mang, “Mila longor tari ot ning i warwara laulau oe Moses pa oe God otleng.” ");
INSERT INTO lbb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pa la akutkut balan a ningnigola, pa tena asaerla tagun a warkurai pa taraila oros otleng. La han tetek e Stiwen, la tong akes pasi, pa la beni sur ir tur salanigo tana tarai a kiwung. ");
INSERT INTO lbb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pa la ben pas a taraila, ning lar tiwi ana asasongo na warwarala mang, “A barsan ne bel i manah ana warwara laulau ana totoh a rumai artabar pa ana Warkuraila otleng anun e Moses. ");
INSERT INTO lbb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mila longori i atongi mang e Iesu, a te Nasaret, ir regen sen a rumai ne, pa ir keles sen a toltolla ning e Moses ka asaer tar dala onoi.” ");
INSERT INTO lbb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pa la rop ning la kes ana kiwung la ngoson rakrakai e Stiwen, pa la oroi mang a patarna i arlar ana patar a angelo. ");
INSERT INTO lbb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A ningnigo na tena artabar tetek e God i deken e Stiwen mange, “I momol ot a warwarala ne?” ");
INSERT INTO lbb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Pa i kelesi mange, “Na tastasik pa na tamang, mulor longor tak. A God a matatar i hanot tetek a tubundala e Abaram, ning kaning ot i kes ting e Mesopotemia, pa belot i kes tumo e Haran. ");
INSERT INTO lbb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Pa e God i atongi tana mang, ‘Ur han kusun anum a hanua, pa na maimla otleng, pa ur han uting na hanua ning ar asangan u onoi.’ ");
INSERT INTO lbb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Pa i han kusun a hanua anuna Kaldiala, pa i kes tumo e Haran. Lamur tana minat ane tamana, e God i sune ulaki sur a hanua ne, onone dala kes ono. ");
INSERT INTO lbb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Belot i saran ta puka kabalapiu tana sur anunai, o ta natar a pukna kama. Ika, i lele tari mang lamur ir saran tar a kabalapiu ne tana pa tetek na tumtubunala. Ning e God i lele, e Abaram belot ta natnalik. ");
INSERT INTO lbb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pa e God i atai i mang, ‘Na tumtubum lamur tam lar kes na wasira ting na ta wasira na hanua, pa lar titol na karabus, pa dir alaulau la ona diat a mar a rau. ");
INSERT INTO lbb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ika ar akadik a taraila miting na matanitu ning la dat pas na tumtubum sur lar titol na karabus. Pa lamur la ning la titol na karabus lar han kusun a hanua ning, pa lar lotu tetek iau te na hanua ne.’ ");
INSERT INTO lbb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","E God i saran tar a kunubus ta e Abaram. Pa asilang ana kunubus ning, a kot talilis a palaona kaklik barsan. E Abaram i aitna e Aisak, pa ning ka siwal a pukakiar anoi, e Abaram i kot talilis a palaona e Aisak. Lamur e Aisak i aitna e Jekop, pa e Jekop i aitna pas ning a bonot pa pisir naur a tumtubundala. ");
INSERT INTO lbb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na tubundala tagun nating la bal laulau oe Josep, a tasinla, pa la siurani sur ir titol na karabus tumo e Ijip. Ika e God i kes taum onoi, ");
INSERT INTO lbb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","pa i alauni kusun a mamahatla ning i kilangi. I saran a wakak a mananos tana, pa i nangani sur e Pero, a king mitumo e Ijip, ir gas onoi. E Pero i suahi sur ir ningnigo ting na hanua Ijip pa ir ningnigo otleng ting na rumai ane Pero. ");
INSERT INTO lbb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Pa tnan munurak i hanot rop tumo e Ijip, pa e Kenan otleng, pa galis a mamahat i kibas a taraila, pa bel al utna na hangan ana tumtubundala. ");
INSERT INTO lbb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ning e Jekop i tasmani mang a wit kanumo e Ijip, i sune na natnatnala, a tumtubundala, la han mitumo e Kenan uto e Ijip a ningnigo na tinan. ");
INSERT INTO lbb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ning ka munaur a tinan anunla, e Josep i atai talapor la mang ai a tasinla. Pa e Pero otleng i talapor bot ana tastasna e Josep. ");
INSERT INTO lbb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lamur e Josep i arsune sur e tamana, e Jekop, la taum ana mainala. La rop mais a bonot pa pisir dilima. ");
INSERT INTO lbb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pa e Jekop taum ana mainala la han pa la kes tumo e Ijip. Lamur e Jekop pa na natnatna la mat tumo ia. ");
INSERT INTO lbb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A galis a raula lamur di los pas a sursurinla pa di akas la ting na kulam a minat tumo e Kenan ting na hanua Sikem. A kulam a minat ning e Abaram ka lou tari tana natnatna e Hamor. ");
INSERT INTO lbb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ning i milau amon a taim sur e God ir tolsot pas anuna lele tetek e Abaram, anundala na tarai la ka galis rop tumo e Ijip. ");
INSERT INTO lbb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pa ning a tona king i turpasi sur ir warkurai e Ijip, pa bel i talapor ana titol ane Josep nating. ");
INSERT INTO lbb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pa i asongo tar anundala na tarai, pa i alaulau la, pa i warkurai tari sur lar kepsen anunla na kakak betbetela sur lar mat. ");
INSERT INTO lbb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ana rau ning, di agon e Moses. Ai a wakak a kaklik kol na matana e God, pa di tai alari ana natol a kalang ting na rumai ane tamana. ");
INSERT INTO lbb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ning di apurumi tumo lapiu, a natna hane e Pero i los pasi, pa i lawati sur a natnalik. ");
INSERT INTO lbb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Pa di asaer e Moses ana ngas a mananosla rop anuna tarai Ijip, pa ai a rakrakai a barsan ana nuna na warwara pa titolla. ");
INSERT INTO lbb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ning ka diat a bonot a rau a lalaun ane Moses, i nuknuk sur ir han pa ir oroi anuna tarai Israel. ");
INSERT INTO lbb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","I oroi ning a te Ijip i um laulau ning a te Israel, i dun tetek diau pa i umkol a te Ijip, sur ir keles pas ning a halna. ");
INSERT INTO lbb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","E Moses i nuki mang anuna tarai lar tasman lalani mang e God i sune i sur ir alaun pas la, ika bel la tasmani. ");
INSERT INTO lbb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Ning a pukakiar lamur tana, i oroi naur a te Israel dia harum, pa e Moses i mang sur ir amolmol diau mange, ‘Naur a barsan, mu ka. Mangasa ning mu alaulau artalai mu?’ ");
INSERT INTO lbb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pa esaning i um laulau tar ning a halna i sugut sen e Moses, pa i atai i mang, ‘Esi i suah tar u sur ningnigo pa ur tena warkurai anumila? ");
INSERT INTO lbb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","U mang sur umkol iau, larning u umkol a te Ijip nabong, gepi?’ ");
INSERT INTO lbb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ning e Moses i longor a warwara ne, i liu kumna utumo na hanua Midian. Ana nuna keskes na wasira tumo, i aitna naur a natna, naur a kaklik barsan. ");
INSERT INTO lbb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ning ka diat a bonot a rau ana nuna keskes tumo e Midian, ning a angelo i hanot teteki ana irnga na iah tingui na natar a rakai ning i irnga, ting na hanua bel milau a mangir Sinai. ");
INSERT INTO lbb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ning e Moses i oroi, i kulkulan ono. I han milau sur ir oroi wakaki, pa i longor a elngena Leklek i mang, ");
INSERT INTO lbb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iau a God anuna tumtubumla tagun nating, a God ane Abaram, Aisak pa e Jekop.’ Pa e Moses i koloron, pa i matmataut sur ir oroi. ");
INSERT INTO lbb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pa Leklek i atai i mange, ‘Ur pak sen naur a su kusun naur a ham, anasa a kabalapiu ne u tur onoi, anuki. ");
INSERT INTO lbb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ia ka oroi a mamahatla ning i kibas anuk a tarai ning la kes tumo e Ijip, pa ia ka longor anunla na tinangis. Pa ia ka han purum, sur ar alangolango pas la. Lamut, par sune ulak u utumo e Ijip.’ ");
INSERT INTO lbb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“A tarai Israel ning la aliu sen e Moses ana nunla na warwara mang, ‘Esi i suah tar u sur ningnigo pa ur tena warkurai anumila?’ Ika, e God ot i sune i sur ir ningnigo pa ir alangolango a taraila. I sune i ana warwara anuna angelo ning i hanot teteki ting na natar a rakai. ");
INSERT INTO lbb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","E Moses i nigon purum la mitumo e Ijip, i tol a ututnala na kulkulan, pa akinalangla tumo e Ijip pa tumo na Tasi Kubar, pa ting na hanua bel otleng, arlar ana diat a bonot a rau. ");
INSERT INTO lbb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","E Moses, esaning i atai tar a tarai Israel mang, ‘E God ir saran ta propet arlar hok miting ot na numulo a mangis a tarai.’ ");
INSERT INTO lbb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","E Moses i kes taum ona maindala tagun nating, a tarai Israel, ting na hanua bel, pa angelo i warwara teteki saot na mangir Sinai. Pa i kibas a warwara ning i laun pa i tumus akesi sur dala. ");
INSERT INTO lbb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ika na maindala tagun nating bel la mang sur lar longor ta e Moses. La gilam ris kusuni, pa la nuknuk ulak utumo e Ijip. ");
INSERT INTO lbb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pa la atai e Aron mang, ‘Ur tol pas anundala al god sur lar nigon dala, anasa e Moses, esaning i nigon purum pas dala mitumo e Ijip, bel ma dala tasman asaning ka hanot onoi.’ ");
INSERT INTO lbb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ana pukakiarla ning, la tol pas a natar a bulumakau ana gol, pa la gas ana ngen kunla pa la artabar teteki. ");
INSERT INTO lbb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pa e God i talingir kusun la, pa i noren la, sur lar lotu tetek a nangnangla, larning di ka tumus tari ting na buk anuna propetla mange, ‘Mulo a tarai Israel, diat a bonot a rau ning mulo kes ting na hanua bel, bel mulo artabar, pa bel mulo umkol ta inagoi sur mulor artabar onoi tetek iau. ");
INSERT INTO lbb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mulo los a rumai lotu anuna asasongo na god Molek, pa manar a nangnang anuna numulo a asasongo na god Repan. A ututnala ning mulo toli, sur mulor lotu tetek la. Ar kepsen sen mulo’ pa mulor han bolos e Babilon pa utumot. ");
INSERT INTO lbb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Na maindala tagun nating la los amon a rumai a sel ting na hanua bel. A rumai a sel ning, i apuasa i mang e God i kes taum onla. Di toli muri ot a warwara ane God tetek e Moses arlar ana manar ning i oroi tari. ");
INSERT INTO lbb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pa na tubundala tagun nating la sarani tetek na natnatunla. Pa la male la los amoni ning e Josua i nigon la, sur lar kibas a hananuala kusun a taraila miting na matanitula ning e God i lu sen la. Pa i kes tingia tuk ana rau ane Dewit, ");
INSERT INTO lbb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","esaning e God i mang kol suri. Pa e Dewit i nunung e God sur ir malmaling sur ir tol ta rumai, sur a tarai lar lotu tingia tetek e God, a God ane Jekop. ");
INSERT INTO lbb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","A rumai ning, e Solomon i toli. ");
INSERT INTO lbb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ika e God ning i Leklek Kol bel i kes ting na rumaila ning a tarai la toli, larning a propet i atongi mange, ");
INSERT INTO lbb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘A Leklek i atongi mange: A langit anuk a keskes a king, pa rakrakan hanua a utna ning a suah naur a hak saot ono. Esi na ngas a rumai ning mulor toli anuki? Kanaha anuk a pukna na manah? ");
INSERT INTO lbb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mangasa, bel a ngen kuk ana ututnala rop ne?’” ");
INSERT INTO lbb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pa e Stiwen i atai a tarai a kiwung mange, “Mulo na tabun longorla, a balamulo i bakbak kusun e God pa talngamulo i kutkut. Mulo sairas liknan a Talngan Tabu, arlar ana numulo na mangis a tarai tagun nating. ");
INSERT INTO lbb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Esi na propet ning anumulo a mangis a tarai tagun nating, bel la alaulau i? La umkol la, ning la warwara nigo ana tinan ot anuna Tena Tostos ute, ning mulo ka saran tari uting na kuna hiruala, pa mulo ka umkol tari, ");
INSERT INTO lbb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","mulo ning mulo ka los a Warkuraila ane God, ning a angelola la sarani tetek mulo, ika bel mulo muri.” ");
INSERT INTO lbb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ning a tarai a kiwung la longor a warwarala ane Stiwen, la balakut kol, pa la harat pap suri. ");
INSERT INTO lbb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","E Stiwen i bukus ana Talngan Tabu, i tadai usaot na langit, pa i oroi a matatar e God, pa e Iesu ning i tur ting na sot a kuna e God. ");
INSERT INTO lbb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Pa i atongi mang, “Oroi! A oroi a langit i sapang, pa a Nat a Barsan i tur ting na sot a kuna e God.” ");
INSERT INTO lbb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pa la bari ana tnan elngenla, la tong alar a talnganla, pa la dun alari. ");
INSERT INTO lbb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","La rihi kusun a hanua, pa la wololoti. Pa la ning la tiu e Stiwen, la pak sen anunla na kaenla ning la polpol alar anunla na mermer ono, pa la suahi ting na naur a hana ning a barman a risana e Sol. ");
INSERT INTO lbb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ning kaning ot la wololoti, e Stiwen i araring mange, “Leklek e Iesu, ur los pas a inguk.” ");
INSERT INTO lbb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pa i kes ana bokona hana, pa i kukuk mang, “Leklek, gong u keles a toltol laulau ne la toli.” Ning ka atong aropi larne, i mat. ");
INSERT INTO lbb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","E Sol i malmaling taum onla sur dir umkol e Stiwen. Ana pukakiar ning di umkol e Stiwen, a tarai la turpasi sur lar alaulau a tarai a lotula saot e Jerusalem, pa tarai a lotula la han sarara ting na naur a papar Judia pa e Samaria. Ika, a aposella bel la han. ");
INSERT INTO lbb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Na tena lotu ning la mur a nuknuk e God, la por e Stiwen, pa la domos rakrakai suri. ");
INSERT INTO lbb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ika e Sol i alaulau a tarai a lotula, i kas uting na nunla na rumai, pa i dat a taraila pa gurarala, pa i akas la uting na karabus. ");
INSERT INTO lbb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","La ning la han sarara misaot e Jerusalem, la warawai ana Wakak a Warwara ting na hananuala ning la han ia. ");
INSERT INTO lbb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pa e Pilip i han uting na ning a tnan hanua tumo na papar Samaria, pa i warawai oe Karisito tetek la. ");
INSERT INTO lbb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ning a kunum a tarai la longor a warwara ane Pilip, pa la oroi a ututnala na kulkulan ning i toli, la mang kol sur lar longor a warwarala ning i atongi. ");
INSERT INTO lbb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","I kepsen a motla kusun a galis, pa ning a motla la purum, la kukuk rakrakai. Pa i alangolango pas a galis ning a palaonla i mat, pa la ning bel la tolsot pas a tinan. ");
INSERT INTO lbb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Pa taraila misaot na hanua ning, la gas kol. ");
INSERT INTO lbb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ning a barsan mitingia, a risana e Saimon, i sira wah pa i akulkulan a tarai Samaria ana ututnala ning i toli. Pa i iaunani na matana taraila. ");
INSERT INTO lbb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pa taraila rop, a leklekla pa tarai oros ka, la hanrawai i, pa la atongi onoi mang, “A barsan ne i tong akes a rakrakai ane God, a rakrakai ning di atongi mang A Tnan Rakrakai.” ");
INSERT INTO lbb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Pa la longor wakaki, anasa ka bongnan la, la sira kulkulan ana nuna toltol na wahla. ");
INSERT INTO lbb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ika ning e Pilip i warawai ana matanitu ane God, pa ana risana e Iesu Karisito, a taraila pa gurarala la tortorot pa di baptais la. ");
INSERT INTO lbb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","E Saimon otleng i tortorot, pa ning di ka baptais tari, i mur mokos e Pilip. Ning e Saimon i oroi a akinalangla pa a ututna na kulkulan i toli, i kulkulan kol onoi. ");
INSERT INTO lbb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","A aposella ning la kes saot e Jerusalem, la longori mang a tarai Samariala otleng la ka longor ana warwara ane God, pa la sune e Pita pa e Jon tetek la. ");
INSERT INTO lbb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ning dia hanot, dia araring sur la, sur lar kibas a Talngan Tabu, ");
INSERT INTO lbb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","anasa belot i kes on ta halinla, di baptais tar la ka ana risan a Leklek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pa e Pita pa e Jon dia suah a kundiau saot onla pa la bot kibas a Talngan Tabu. ");
INSERT INTO lbb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ning e Saimon i oroi mang di tabar la ana Talngan Tabu ning naur a aposel dia suah a kundiau saot onla, i los a mani tetek diau. ");
INSERT INTO lbb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Pa i atongi mang, “Mur saran a rakrakai ning tak, sur iau otleng ar suah a kuk saot on tik, pa dir tabari ana Talngan Tabu.” ");
INSERT INTO lbb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pa e Pita i kelesi mang, “U taum ana num a mani mur hirua, anasa u nuki mang ur lou a artabar ane God ana mani. ");
INSERT INTO lbb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bel anum ta tiniba pa ta tukna ana titol ne, anasa a balam bel i tostos na matana e God. ");
INSERT INTO lbb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ur lingir a nuknukim kusun a laulau a ginim ne, pa ur araring tetek a Leklek. Ngandek ir kepsen a laulau a nuknukim. ");
INSERT INTO lbb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Anasa a oroi u mang u bukus ana laulau a nuknuk, pa laulau a ginim i dot akes u.” ");
INSERT INTO lbb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pa e Saimon i kelesi mang, “Mur araring tetek a Leklek sur iau, sur gong ta utna ning mu atong tari, ir hanot hok.” ");
INSERT INTO lbb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ning e Pita pa e Jon dia ka warwara talapor tar ana ututnala ning a Leklek i toli, pa dia ka warawai tar ana nuna warwarala, dia ulak usaot e Jerusalem. Ning dia han, dia warawai amon ana Wakak a Warwara ting na galis a hanua ting na papar Samaria. ");
INSERT INTO lbb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ning a angelo anuna Leklek i atai e Pilip mang, “Ur tur, pa ur han utumo na matana tobar sur a ngas misaot e Jerusalem utumo e Gasa, a ngas ning i han potor a hanua bel.” ");
INSERT INTO lbb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pa e Pilip i kamtur, pa i han. Pa dia arsongo taum ana ning a barsan mitumo e Itiop, a ningnigo na tena tai alar ana ututna anuna Kandake, a kwin anuna tarai Itiop. A barsan ne ka han pas saot e Jerusalem pa ka lotu pas tetek e God. ");
INSERT INTO lbb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ning i ulak sur uting na hanua ngasna, i kes saot na karis, pa i was a buk ana propet Aisaia. ");
INSERT INTO lbb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pa Talngan Tabu i atai e Pilip mang, “Ur han uting na karis ning, pa ur han amon taum ono.” ");
INSERT INTO lbb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pa e Pilip i dun teteki, pa i longor a barsan ning i was a buk ane propet Aisaia, pa i dekeni mang, “I mangmangasa, u talapor ot ana saning u wasi?” ");
INSERT INTO lbb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Pa i kelesi mang, “Ar tasman mangmangasa i, ning bel tik ir atalapori tetek iau?” Pa i nunung e Pilip sur ir abit teteki pa diar kes taum. ");
INSERT INTO lbb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ine a warwarala ting na Buk Tabu ning i wasi: “Di beni arlar ana sipsip, sur dir umkoli. Bel i warwara, arlar ana barman a sipsip ning i tur longoroi tetek esining ir kumur a hihna. ");
INSERT INTO lbb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Di ame tari, pa bel di atostos a warkurai onoi. Bel tik i tolsot sur ir warwara ana tumtubunala lamur. Anasa di kepsen anuna lalaun mite na rakrakan hanua.” ");
INSERT INTO lbb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","A te Itiop i deken e Pilip mange, “Ur atai iau, a propet i warwara o esi? Ono i ot, o ana tik masik?” ");
INSERT INTO lbb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pa e Pilip i turpas a papak teteki. I atai i ana Wakak a Warwara oe Iesu, turpasi ot ana buk ning a te Itiop i wasi. ");
INSERT INTO lbb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ning dia han amon ting na ngas, dia hanot ting na ning a malum, pa te Itiop i atai e Pilip mange, “Oroi, a malum ne. Asa ir sairas iau sur gong di baptais iau?” ");
INSERT INTO lbb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pa i sairas a karis sur ir tur. Pa dia han purum uting na malum pa e Pilip i baptaisi. ");
INSERT INTO lbb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ning dia saur kusun a malum, a inguna Leklek i kepsen e Pilip. Pa te Itiop bel ma i oroi ulaki, pa i han ana nuna tinan taum ana tnan gasgas ting na nuna lalaun. ");
INSERT INTO lbb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pa e Pilip i oroi mang i kanumo ma na hanua Asdot. Pa ning i han mitingia, i warawai amon ana Wakak a Warwara ting na hananuala tuk ning i hanot tumo e Sisaria. ");
INSERT INTO lbb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ana pukakiarla ning, e Sol i mang kol sur ir um amat a tarai a asaer anuna Leklek. I han tetek a ningnigo na tena artabar tetek e God, ");
INSERT INTO lbb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","pa i nunungi mang, “Ur tumus al pas sur ar losi utumo na rumai lotula to e Demaskas. Ur tumusi mang, ning ar pastek al tarai pa al gurarala ning la mur a Ngas ane Karisito, ar dat pas la usaot e Jerusalem, sur lar karabus.” ");
INSERT INTO lbb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ning i han milau e Demaskas, a tnan talapor misaot na langit i hanot kulkulan pa i sasai talilisi. ");
INSERT INTO lbb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","I punga purum tumo lapiu, pa i longor a elngena mainla i atai i mange, “Sol, Sol, sur asa u alaulau iau?” ");
INSERT INTO lbb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Pa e Sol i dekeni mange, “Leklek, esi u?” Pa i kelesi mange, “Iau e Iesu ning u alaulau iau. ");
INSERT INTO lbb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Onone ur tur pa ur han utumo e Demaskas, pa dir atai u ana saning ur toli.” ");
INSERT INTO lbb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pa taraila ning la armuri, la kulkulan pa la matmataut pa bel la warwara, anasa la longor a elngena mainla, ika bel la oroi. ");
INSERT INTO lbb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","E Sol i kamtur miting lapiu, pa ning i palpalas matana, bel i oroi sot pas ta utna. Pa la tong benben tari kama utumo e Demaskas. ");
INSERT INTO lbb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Pa i kes tingia natol a pukakiar, a matana i kut, bel i hangan pa bel i gang. ");
INSERT INTO lbb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ning a barsan miting na tarai a asaer, a risana e Ananias, i kes tumo e Demaskas. A Leklek i kabahi ana tatatai mange, “Ananias!” Pa e Ananias i kelesi mange, “Leklek, iau ot ne.” ");
INSERT INTO lbb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pa a Leklek i atai i mange, “Ur tur, pa ur han uting na rumai ane Judas, ting na ngas ning di atongi a Tostos a Ngas. Pa ur kabah sur e Sol, a te Taso, kanumo i araring. ");
INSERT INTO lbb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ana tatatai, e Sol i oroi ning a barsan, a risana e Ananias, i kas teteki, pa i suah naur a kuna saot onoi sur ir tai ulak.” ");
INSERT INTO lbb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pa e Ananias i kelesi mang, “Leklek, ia ka longor tar a galis a warwara ana barsan ne, pa toltol laulau ning i toli ana num a tarai saot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pa leklek a tena artabarla tetek e God la malmaling seni sur ir dat la rop ning la lotu ana risam. Pa i hanot te e Demaskas.” ");
INSERT INTO lbb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ika a Leklek i atai i mange, “Ur han ka, anasa ia ka aslang tari sur i anuk a tena titol, ir warwara talapor ana risak tetek a taraila ning bel a tarai Israel, tetek a kingla, pa tetek a tarai Israel otleng. ");
INSERT INTO lbb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Par asangani mang ir kilang a galis a kankan ana risak.” ");
INSERT INTO lbb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Lamur e Ananias i han, pa i kas ting na rumai ning e Sol i kes ia. I suah naur a kuna saot onoi, pa i atai i mange, “Sol, tasiklik, a Leklek e Iesu, i ning i turot tetek u ting na ngas ning u han ute, i sune iau ute sur ur tai ulak, pa ur bukus ana Talngan Tabu.” ");
INSERT INTO lbb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Pa ning a utna i arlar ana palakotoi a sis i punga purum kakat kusun naur a matana, pa i tai ulak. I tur pa di baptaisi. ");
INSERT INTO lbb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ning i hangan pas, a palaona i rakrakai ulak. E Sol i kes ulak pas napir a tarai a asaer tumo e Demaskas. ");
INSERT INTO lbb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ono otning i turpasi sur ir warawai ting na rumai lotula anuna tarai Juda, mang e Iesu a Nat e God. ");
INSERT INTO lbb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Pa la rop ning la longori, la kulkulan onoi pa la atongi mang, “A barsan kaning, i umkol la ning la lotu tetek e Iesu saot e Jerusalem. Pa onone i hanot ute sur ir dat pas a tarai a lotu ane Iesu, tetek a leklek a tena artabarla tetek e God.” ");
INSERT INTO lbb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ika a warawai ane Sol i rakrakai pa i atong a ututnala ning i amomol pasi mang e Iesu ot a Karisito. Pa tarai Juda ning la kes tumo e Demaskas la nuknuk kol ana nuna warwarala, pa bel la tolsot sur lar kelesi. ");
INSERT INTO lbb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ning a galis a pukakiar ka rop, a tarai Juda la warwara taum sur lar umkol e Sol. ");
INSERT INTO lbb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ika e Sol ka tasmani mang la warwara taum suri. Ana moromla pa kabakiarla a matanla i makas ting na tamanla ana hanua sur e Sol, sur lar umkoli. ");
INSERT INTO lbb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ika anuna kakak a asaer la ben pasi ana morom, pa la alorong purumi ana rat ting na mosol ting na ris a woroh ning di tol alar a hanua ono. ");
INSERT INTO lbb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ning e Sol i hanot saot e Jerusalem, i tohoi sur ir kes taum ana tarai a asaerla, ika la rop la matatani, anasa bel la tortorot onoi mang i otleng ning a hala tarai a asaer. ");
INSERT INTO lbb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ika e Barnabas i ben pasi, pa dia armuri tetek a aposella, pa i atai la mang, “E Sol ka oroi tar a Leklek, pa Leklek i warwara teteki ana nuna tinan utumo e Demaskas. Pa ning i kes tumo e Demaskas, i warawai ana risana e Iesu pa bel i matmataut.” ");
INSERT INTO lbb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pa e Sol i kes taum ana tarai a lotu saot e Jerusalem, i han taltal, pa i warwara ana risana Leklek, pa bel i matmataut. ");
INSERT INTO lbb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","I warwara pa i keles a kabahla anuna tarai Juda ning la warwara Grik, ika la mang sur lar umkoli. ");
INSERT INTO lbb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ning na tastasna ana tortorot la longori, la beni utumo e Sisaria, pa lamur la sune seni utumo e Taso. ");
INSERT INTO lbb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Lamur a tarai a lotu ting na hananuala rop ting na natol a papar Judia, e Galili pa e Samaria, la kes ana balmolmol. Pa lotu i rakrakai, pa la kes na hanrawai tetek a Leklek, a Talngan Tabu i wunan la, pa wawas ana tarai a lotu i han kas. ");
INSERT INTO lbb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ning e Pita i han amon ting na hananuala, i geren a tarai ane God otleng tumo e Lida. ");
INSERT INTO lbb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tingia, i pastek ning a barsan, a risana e Aineas, a palaona i mat. Ka arlar ana siwal a rau, i borbor ka ting na logo ngasna. ");
INSERT INTO lbb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pa e Pita i atai i mange, “Aineas, e Iesu Karisito i alangolango u. Ur tur, pa ur hin a logo ngasim.” Pa i tur kakat. ");
INSERT INTO lbb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","La rop ning la kes ting na hanua Lida pa e Saron, la oroi a barsan ning, pa la lingir a nuknukinla tetek a Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ning a hane miting na tarai a asaer i kes tumo e Jopa, a risana e Tabita, ana warwara Grik mang e Dokas. A hane ne, ka tol tar a galis a wakak a titol, pa tena artabar tetek a kapan a tarai. ");
INSERT INTO lbb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ana pukakiarla ning e Pita i titol tumo e Lida, e Dokas i kurah, pa i mat. Ning la ka pukur tari, la aborbor tari ting na ning a tuka rumai saot. ");
INSERT INTO lbb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","E Lida i kes milau e Jopa, pa ning a tarai a asaer miting e Jopa la longori mang e Pita kanumo e Lida, la sune naur a barsan teteki pa dia angongosi mang, “Maris mila, ur lamut kapit tetek mila.” ");
INSERT INTO lbb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","E Pita i han taum ondiau. Ning i hanot, la beni usaot na tuka rumai. Pa laola rop la tur talilisi pa la domos. Pa la asangan a kolosla pa kaenla, ning e Dokas i suk tar la ning kaning ot i laun. ");
INSERT INTO lbb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","E Pita i sune purum la rop miting na tuka rumai ning, pa i kes ana bokona hana, pa i araring. I talingir tetek a hane ning i mat, i atongi mang, “Tabita, ur tur.” Pa e Tabita i palpalas matana, pa ning i oroi e Pita, i kes kakat. ");
INSERT INTO lbb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pa e Pita i tuslan a kuna teteki, pa i dat aturi. Pa i kabah pas a tena tortorotla pa a laola, pa i saran tar e Tabita tetek la, ka laun. ");
INSERT INTO lbb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A utna ne i talapor pa la rop tumo e Jopa la tasmani, pa galis la tortorot ona Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","E Pita i kes suai ulak ting e Jopa taum ning a barsan a risana e Saimon, a tena toltol utna ana palaona inagoila. ");
INSERT INTO lbb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ning a barsan kanumo e Sisaria, a risana e Konilius, i ning a ningnigo anuna ning a mar a tarai a harum, la miting na tnan kunum a tarai a harum mitumo e Itali. ");
INSERT INTO lbb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","E Konilius pa la rop ning la kes ting na nuna rumai la na momol a tena lotu pa na tena hanrawai tetek e God. E Konilius ning a tena artabar tetek a kapan a tarai, pa pukakiarla rop i araring tetek e God. ");
INSERT INTO lbb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ning a rah ana 3 kilok i oroi ning a tatatai. I oroi talapor a angelo ane God i hanot teteki pa i kabah i mang, “Konilius!” ");
INSERT INTO lbb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pa e Konilius i ngoson rakrakai i ana matmataut, pa i dekeni mang, “Leklek, asaning?” Pa angelo i kelesi mange, “Anum a niaringla pa artabarla tetek a kapan a tarai la han usaot tetek e God, pa la tur na matana, pa i gas ana saning u toli. ");
INSERT INTO lbb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Onone ur sune al tarai utumo e Jopa, sur lar ben pas ning a barsan, e Saimon, esaning a risana otleng e Pita. ");
INSERT INTO lbb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kaning i kes napir e maurana e Saimon, esaning a tena toltol utna ana palaona inagoila. Anuna rumai i tur milau a tasi.” ");
INSERT INTO lbb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","A angelo ning i warwara teteki i han, e Konilius i kabah pas naur miting na nuna tena titolla, pa ning a tena lotu miting na nuna tarai a harum. ");
INSERT INTO lbb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","I atai ditol ana ututnala rop ne, pa i sune ditol utumo e Jopa. ");
INSERT INTO lbb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ana pukakiar lamur tana, ditol han, pa ana tnan kamis ning ditol han milau sur a hanua Jopa, e Pita i abit kas usaot na pukul a rumai, sur ir araring. ");
INSERT INTO lbb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ning i araring, i kilang a munurak pa i mang sur ir hangan. Kaning ot di sang a utna na hangan, i oroi a tatatai. ");
INSERT INTO lbb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I oroi a langit i sapang, pa ning a utna i arlar ana tnan kaen a polpol, di tong pas diat a ris ono pa di alorong purumi teteki. ");
INSERT INTO lbb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tingui onoi a urmatana inagoi, pa la ning la kawar, pa manila otleng. ");
INSERT INTO lbb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","A elngen takai i atai e Pita mange, “Pita, tur, ur umkol la, pa ur ien la.” ");
INSERT INTO lbb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pa e Pita i kelesi mange, “Leklek, bel! Bel a ien tar ta utna ning di arsairas ono pa i dur na matam.” ");
INSERT INTO lbb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pa elngen takai i keles ulaki mange, “A utna ning e God ka atotoh tari, gong u atongi mang a dur a utna.” ");
INSERT INTO lbb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A utna ne di toli munatol, pa di dat kas kakat a kaen usaot na langit. ");
INSERT INTO lbb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kaning ot e Pita i nuknuk kol ana kamkama tatatai ne, natol a barsan, ning e Konilius i sune ditol, ditol ka seren pas a rumai ane Saimon, pa ditol tur ting na taman. ");
INSERT INTO lbb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ditol arkabah kas mange, “E Saimon ning a risana otleng e Pita kaningui?” ");
INSERT INTO lbb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kaning ot e Pita i nuknuk ana tatatai, a Talngan Tabu i atai i mange, “Oroi! Natol a barsan kaning ditol tai sur u. ");
INSERT INTO lbb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tur, pa ur han purum. Gong u nuknuk kol, ur han pa mulor armuri, anasa iau ot a sune ditol ute.” ");
INSERT INTO lbb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","E Pita i purum tetek ditol pa i atai ditol mange, “Iau kane ning mutol seren iau. Asaning mutol seren iau suri?” ");
INSERT INTO lbb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ditol kelesi mang, “E Konilius, a ningnigo anuna ning a mar a tarai a harum i sune mitol. E Konilius i ning a tena tostos pa tena hanrawai tetek e God, pa tarai Juda rop la hanrawai i. A angelo ane God i atai tari mang ir arsune pas u utumo na nuna rumai, sur ir longor anum ta warwara.” ");
INSERT INTO lbb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","E Pita i ben kas ditol sur ditol ar borbor pas. Ning ka kabakiar ot, e Pita i tur pa la han, pa dingla na tarai ning la tas ana tortorot misaot e Jopa la armuri. ");
INSERT INTO lbb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","E Konilius i tasmani mang lar hanot, i ben taum pas na mainala, pa na halalna, pa la kes nanan e Pita. Pa ning ka takai a pukakiar alar tar a tinan ane Pita la, la hanot tumo e Sisaria. ");
INSERT INTO lbb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ning e Pita i kas, e Konilius i han barati, pa i punga purum ana hanrawai ting na naur a hana. ");
INSERT INTO lbb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ika e Pita i dat atur pasi, pa i atai i mange, “Ur tur, iau otleng a barsan ka.” ");
INSERT INTO lbb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ning dia warwara amon, e Pita i kas tar tetek a kunum a tarai kaning la ka kes taum. ");
INSERT INTO lbb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pa i atai la mange, “Mulo tasmani mang di arsairas ting na warkurai mang mila na te Judala, milar lasan taum tik ning bel miting na tarai Juda, pa milar gereni otleng. Ika e God ka asangan tar iau mang gong a atong tik mang i dur na matana e God, pa gong a nuki mang di arsairas tetek mila mang milar lasan taum onoi. ");
INSERT INTO lbb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Pa bel a ngongoio ning di arsune sur iau ute. Pa ar deken mulo: Mulo arsune sur iau sur asa?” ");
INSERT INTO lbb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pa e Konilius i kelesi mange, “Ka diat a pukakiar alar tar anuk a niaring ting na nuk a rumai ana taim larne, ana 3 kilok ana rah. A oroi ning a barsan i mermer ana kaen ning i pilpil, i hanot kulkulan pa i tur salanigo tak, ");
INSERT INTO lbb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","pa i mang, ‘Konilius, e God ka longor anum na niaring, pa ka tasman anum na artabarla tetek a kapan a taraila. ");
INSERT INTO lbb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ur arsune utumo e Jopa, sur e Saimon, ning a risana otleng e Pita. I wasira ting na rumai ane Saimon, a tena toltol utna ana palaona inagoila, i kes milau a tasi.’ ");
INSERT INTO lbb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Pa a arsune kakat sur u. I wakak kol ning u hanot te. Onone mila rop mila kes na matana e God, sur milar longor a warwarala rop ning a Leklek ka atai tar u sur ur atai mila ono.” ");
INSERT INTO lbb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Lamur e Pita i atongi mange, “A tasman momoli mang, e God bel i sira purpurngis. ");
INSERT INTO lbb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","I sira gas pas a taraila miting na matanitula rop, ning la hanrawai i pa la titol ana tostosna. ");
INSERT INTO lbb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mulo tasmani mang e God ka saran sen anuna warwara tetek a tarai Israel. A warwara ne, a Wakak a Warwara ana balmolmol kamna oe Iesu Karisito, i ning a Leklek anuna tarai rop. ");
INSERT INTO lbb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mulo ka tasman asaning i hanot ting na hananuala tumo e Israel, turpasi tumo e Galili lamur tana baptais ning e Jon i warawai ono. ");
INSERT INTO lbb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mulo tasmani mang e God ka saran tar a Talngan Tabu pa rakrakai tetek e Iesu, a te Nasaret. Ning i han taltal, i tol a wakak a titolla, pa i alangolango pas la, ning la kes nahai a warkurai ane Satan. E Iesu i tol a ututnala ne, anasa e God i kes taum onoi. ");
INSERT INTO lbb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Pa mila na tena warwara talapor ana ututnala rop ning mila oroi, ning i sira toli ting na hananuala anumila a tarai Juda, pa saot e Jerusalem. Di umkoli saot na rakai kutus, ");
INSERT INTO lbb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ika natol a pukakiar lamur, e God i akamtur ulak pasi kusun a minat, pa i asangani tetek a tarai. ");
INSERT INTO lbb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Bel tetek a tarai rop, tetek la ning e God ka aslang nigon tar la sur lar oroi pa lar warwara talapor ono, mila ning mila hangan pa mila gang taum onoi, ning i kamtur ulak kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","I sune mila, sur milar warawai pa milar warwara talapor tetek a tarai, mang i ot ning e God ka aslang pasi sur ir tena warkurai anunla ning la laun pa la ning la ka mat. ");
INSERT INTO lbb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A propetla rop la warwara oe Iesu, mang esining i tortorot onoi, dir kepsen anuna toltol laulaula ana risana.” ");
INSERT INTO lbb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kaning ot e Pita i warwara ting na rumai ane Konilius, a Talngan Tabu i han purum onla rop, ning la longor a warwara ne. ");
INSERT INTO lbb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Dingla na tena tortorot miting na tarai Juda ning la armuri taum oe Pita, la kulkulan, mang e God i artabar otleng ana Talngan Tabu tetek a tarai ning bel a tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Anasa la longor la, ning la warwara ana urmatana warwara, pa la atong leklek pas e God. ");
INSERT INTO lbb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Lamur e Pita i atongi mange, “Bel tik i tolsot sur ir sairas la ne sur gong di baptais la ana malum. Anasa a Talngan Tabu ka kes onla arlar larning i kes ondala.” ");
INSERT INTO lbb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pa i arsune sur dir baptais la ana risana e Iesu Karisito. Lamur la nunung e Pita sur ir kes taum onla al pukakiar. ");
INSERT INTO lbb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","A aposella pa la ning la tas ana tortorot ning la kes tumo e Judia, la longori mang a tarai otleng ning bel a tarai Juda la ka tortorot ana warwara ane God. ");
INSERT INTO lbb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pa ning e Pita i han usaot e Jerusalem, a taraila ning la mang sur a tena tortorotla rop dir kot talilis a palaonla, la bori. ");
INSERT INTO lbb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","La atai i mange, “U kas uting na rumai anuna tarai ning bel di kot talilis a palaonla, pa u hangan taum onla.” ");
INSERT INTO lbb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","E Pita i papak tostos tetek la ana ututnala rop ning i hanot mange, ");
INSERT INTO lbb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ning a kes ting na hanua Jopa, a araring, pa a oroi ning a tatatai. A oroi ning a utna i arlar ana tnan kaen a polpol ning di tong pas diat a ris pa di alorong purumi misaot na langit tetek iau. ");
INSERT INTO lbb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ning a tai tingui ono, a oroi a inagoila, la ning di lawat la pa dingla na rokoiona, pa la ning la kawar, pa manila. ");
INSERT INTO lbb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Pa a longor a elngen takai i atai iau mange, ‘Pita, ur tur, ur umkol la, pa ur ien la.’ ");
INSERT INTO lbb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pa kelesi mange, ‘Leklek, a momolna ot! Bel a ien tar ta utna ning di arsairas ono pa i dur na matam.’ ");
INSERT INTO lbb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pa a elngen takai misaot na langit i atong ulaki mange, ‘A utna ning e God ka atotoh tari, gong u atongi mang a dur a utna.’ ");
INSERT INTO lbb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A utna ne di toli munatol, pa di dat kas ulaki usaot na langit. ");
INSERT INTO lbb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ono otning, natol a barsan ning di sune ditol mitumo e Sisaria tetek iau, ditol hanot ting na rumai ning a kes ia. ");
INSERT INTO lbb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pa Talngan Tabu i atai iau sur ar han taum onditol, pa gong a nuknuk kol. Diono na barsan otleng ne, ning mila tas ana tortorot, mila han taum onditol utumo e Sisaria pa mila kas uting na rumai ane Konilius. ");
INSERT INTO lbb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pa i atai mila mang i oroi a angelo i hanot ting na nuna rumai pa i atai i mange, ‘Ur arsune utumo e Jopa sur e Saimon, ning a risana otleng e Pita. ");
INSERT INTO lbb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pa ir atai u on al warwara ning ir alaun u pa la rop ning la kes ting na num a rumai.’ ");
INSERT INTO lbb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ning a turpas a warwara, a Talngan Tabu i kes onla, larning i toli ondala nating. ");
INSERT INTO lbb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Pa nuk pas a warwara anuna Leklek, ning i atongi mange, ‘E Jon i baptais ana malum, pa lamur dir baptais mulo ana Talngan Tabu.’ ");
INSERT INTO lbb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","E God ka saran tar a artabar tanla, larning ka saran tari tandala, ning dala tortorot ana Leklek e Iesu Karisito. Pa esi na ngas a barsan iau, ning ar sairas e God?” ");
INSERT INTO lbb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ning la longor a warwara ne, bel ulak ma la warwara, pa la atong leklek e God mange, “E God ka tol tar a ngas sur la ning bel a tarai Juda lar lingir a nuknukinla pa lar laun.” ");
INSERT INTO lbb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A tarai a lotu ning la han sarara misaot e Jerusalem anasa a tarai la alaulau la lamur tana minat e Stiwen, la han bakbak utumo na papar Ponisia, a lolo Saiprus, pa hanua Antiok. La warwara ka tetek a tarai Juda ana Wakak a Warwara oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ika dingla na tarai miting na tarai a lotu ning, a tarai Saiprus pa tarai Sairini, la hanot tumo e Antiok pa la atai a tarai ning bel a tarai Juda otleng ana Wakak a Warwara ona Leklek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A rakrakai ana Leklek i kes onla ning la warwara talapor, pa galis kol la tortorot pa la lingir a nuknukinla tetek a Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ning a tarai a lotu saot e Jerusalem la longor a warwara ne, la sune e Barnabas utumo e Antiok. ");
INSERT INTO lbb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","E Barnabas, esaning a wakak a barsan, i bukus ana Talngan Tabu pa tortorot. Ning i hanot pa i oroi a marmaris ane God ning i titol onla, i gas ono, pa i wunan la rop sur lar tur momol ana tortorot ana nunla lalaun tetek a Leklek. Pa galis a tarai la lingir a nuknukinla tetek a Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lamur e Barnabas i han utumo e Taso, sur ir tai sur e Sol. ");
INSERT INTO lbb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ning i seren pasi, i beni utumo e Antiok. Ning a kidol a rau dia kes taum ana tarai a lotu tumo, pa dia asaer a galis a tarai. A rising “a te Karisitola”, di atong nigoni ana tarai a asaer tumo e Antiok. ");
INSERT INTO lbb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ana taim ning, dingla na propet la han misaot e Jerusalem utumo e Antiok. ");
INSERT INTO lbb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ning a halinla, a risana e Agabus, i tur, pa i warwara ana rakrakai ana Talngan Tabu. I warwara nigo tar ana tnan munurak ning ir kibas a hananuala rop. A munurak ne i hanot ning e Klodius i warkurai tumo e Rom. ");
INSERT INTO lbb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pa a tarai a asaer la warkurai pas mang la rop taktakai lar artabar arlar ana nunla na gongonla tetek a tarai a lotula ning la kes ting na papar Judia. ");
INSERT INTO lbb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","La migen taum tar a mani, pa e Barnabas diau ma e Sol dia losi tetek a ningnigola ana lotu saot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ana pukakiarla ning, king Herot i dat pas dingla na tarai miting na tarai a lotu, sur ir alaulau la. ");
INSERT INTO lbb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","I arsune tar sur e Jems, a tas e Jon, pa di umkoli ana liwan a harum. ");
INSERT INTO lbb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ning i oroi a tarai Juda la gas ana minat e Jems, i dat pas e Pita otleng ana ning a pukakiar arpotor ana tatatnan pukakiar ana lotu na bret ning bel al is ono. ");
INSERT INTO lbb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ning ka dat pas e Pita, lamur i akasi uting na karabus. Pa diat a kunum a tarai a harum la tai alari, la areiat ana ning a kunum. E Herot i mang sur ir beni sur dir warkurai i na matana tarai, lamur tana lotu na Han Lakai. ");
INSERT INTO lbb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ning e Pita i kes ting na karabus, a tarai a lotu rop bel la manah ana niaring tetek e God suri. ");
INSERT INTO lbb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ana morom lanigo tana pukakiar ning e Herot ir ben pas e Pita sur a warkurai, e Pita i borbor tar na arpotor tana naur a tena harum. La ka dot tar naur a kuna taum ana naur a sen. Pa dingla na tena harum la tur ting na taman pa la tai alar a karabus. ");
INSERT INTO lbb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","A angelo anuna Leklek i hanot kulkulan teteki, pa talapor i sasai tingui na karabus. I dapis amata e Pita ting na risna, pa i atai i mange, “Tur kapit!” Pa naur a sen i tapapak kusun naur a kuna. ");
INSERT INTO lbb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Pa angelo i atai i mange, “Ur mermer, pa ur suah pas anum naur a su.” Pa i toli larning. Pa angelo i atai ulaki mange, “Ur polpol alar u ana num a kaen, pa ur mur iau.” ");
INSERT INTO lbb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","E Pita i mur purumi kusun a karabus. E Pita i nuki mang a utna ne a angelo i toli, bel a momolna, i nuki mang i oroi a tatatai ka. ");
INSERT INTO lbb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Dia bolos a ningnigo na tena tai alar, pa munaurna otleng, lamur dia hanot ting na taman a aen, ning di purpurum onoi utumo na tnan hanua. Ning dia tur tingia, a taman i sapang oros ka, pa dia purum. Ning dia hanot ting na pukna ning a ngas i han sarara, angelo i rorom kakat kusuni. ");
INSERT INTO lbb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ning a nuknukna e Pita i talapor, i atongi mange, “A tasman momoli mang a Leklek i sune anuna angelo, pa i alaun pas iau kusun a kuna e Herot, pa ututnala ning a tarai Juda la mang sur lar toli hok.” ");
INSERT INTO lbb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ning i tasman lalani mang ka langolango, i han uting na rumai ane Maria, tana e Jon ning a risana otleng e Mak. A galis a tarai la kes taum tingia, pa la araring. ");
INSERT INTO lbb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","E Pita i pinpidir ting na taman, pa ning a tena titol a basbas, a risana e Roda, i dun sur a taman. ");
INSERT INTO lbb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ning i longor lalan pas a elngena e Pita, i gas. Pa ana nuna gasgas, bel i sapang pasi, i dun ulak, pa i atai la mange, “E Pita kanumo na taman i tur.” ");
INSERT INTO lbb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pa la atai i mang, “U longlong.” Pa i ngongos mang, “I momol ot, i ot ne lapiu.” Pa la atai i mang, “Ngandek anuna angelo ka.” ");
INSERT INTO lbb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ika e Pita i pinpidir ngongos, pa ning la sapang pa la oroi i, la kulkulan onoi. ");
INSERT INTO lbb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pa i sairas la ana kuna, sur lar kes longoroi, pa i atalapor la ana ngas ning a Leklek i ben purum pasi kusun a karabus. Pa i atai la mang, “Mulor atai e Jems pa na tastasindala ana tortorot ana utna ne.” Pa i han kusun la sur ning a hanua masik. ");
INSERT INTO lbb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ana kobot a tena harumla la tai sur e Pita pa nuknukinla i loklokron mang kanaha i ma. ");
INSERT INTO lbb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ning e Herot i longori mang bel ma i kes ting na karabus, i arsune sur lar tai suri. Ika bel la seren pasi. Lamur i warkurai a tena harumla ning la tai alar a karabus, pa i arsune sur la sur dir umkol la. Lamur e Herot i han miting na papar Judia utumo e Sisaria, sur ir kes tumo. ");
INSERT INTO lbb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","E Herot i balakut tetek a tarai ting na naur a hanua Tair pa e Saidon. Pa tarai miting na naur a hanua ning, la han taum sur lar oroi i, pa lar nunungi sur a balmolmol. Anasa anunla naur a hanua la laun ka ana utna na hangan miting na papar anuna king Herot. La baltaum nigo taum oe Blastus, a tnan tena tai alar anuna king, pa i nangan la sur lar oroi a king. ");
INSERT INTO lbb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ana pukakiar ning e Herot i kubus tari tanla, i mermer pas ana kaenla anuna king, pa i kes tar ana keskes a king, pa i warwara tetek a tarai. ");
INSERT INTO lbb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pa tarai la kukuk na gasgas, pa la atongi mang, “A elngen a god ot ne, bel a barsan i.” ");
INSERT INTO lbb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ono otning, a angelo anuna Leklek i umi, anasa bel i atong leklek e God, pa pompobola la ien a palaona, pa i mat. ");
INSERT INTO lbb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ika a warwara ane God i gomo, pa i han sarara uting na hananuala. ");
INSERT INTO lbb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ning e Sol pa e Barnabas dia titol rop saot e Jerusalem, dia ulak utumo e Antiok. Dia ben e Jon, ning a risana otleng e Mak, pa ditol han taum. ");
INSERT INTO lbb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A propetla pa tena asaerla tagun a tarai a lotu tumo e Antiok a risanla ne: e Barnabas, e Simion ning a risana otleng e Niger, pa e Lusius a te Sairini, e Sol pa e Manain ning di lawat taum diau ma e Herot a ningnigo. ");
INSERT INTO lbb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ning la lotu tetek a Leklek pa la tamai, a Talngan Tabu i atongi mang, “Mulor aslang tar e Barnabas pa e Sol sur anuki, sur a titol ning a kabah pas diau suri.” ");
INSERT INTO lbb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lamur tana tamai pa niaring, la suah a kunla saot ondiau, pa la sune sen diau. ");
INSERT INTO lbb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","A Talngan Tabu i sune e Barnabas pa e Sol, pa dia han utumo e Selusia. Dia kas ana sip pa dia han utumo na lolo Saiprus. ");
INSERT INTO lbb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ning dia hanot tumo e Salamis, dia warawai ana warwara ane God ting na rumai lotula anuna tarai Juda. Ditol armuri taum ma e Jon, anundiau a tena arnangai. ");
INSERT INTO lbb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Ditol han taltal ting na lolo rop ning, tuk tumo e Papos. A ningnigo miting na lolo ning, a risana e Sergius Pol, a tena tastasmai, i arsune pas e Barnabas pa e Sol anasa i mang sur ir longor a warwara ane God. Ika ning a hal e Sergius Pol, a risana e Bar-Iesu, i sairas diau. I ning a te Juda, a asasongo na propet, pa di atongi mang e Elimas, a kamkamna mang a tena wah. I mang sur ir sairas a ningnigo sur gong i tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pa e Sol ning di atongi otleng mang e Pol, i bukus ana Talngan Tabu, i ngoson rakrakai e Elimas, ");
INSERT INTO lbb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","pa i atai i mange, “U a nat e Satan, u a hirua ana tostos a toltol rop. U bukus ana urmatana asasongo pa ana asobor. Nangse ma ur manah kusun anum a toltol ning u lingir kol a tostos a ngas anuna Leklek? ");
INSERT INTO lbb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Onone a warkurai anuna Leklek ir hanot tetek u, a matam ir kut bongnani ot, pa bel ur oroi a talapor ana kamis.” Ono otning a laukap taum ana mormorom i hanot teteki, pa i tabah taltal sur tik ning ir tong pas a kuna pa ir beni. ");
INSERT INTO lbb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ning a ningnigo i oroi a utna ne i hanot, i tortorot, anasa i kulkulan ana asaer ana Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","E Pol pa naur a halna ning ditol han taum, ditol kas ana sip miting e Papos, pa ditol han utumo e Perga, ting na papar Pampilia. Pa e Jon i han kusun diau tingia, pa i ulak usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","E Pol pa e Barnabas dia han mitumo e Perga sur e Antiok ting na papar Pisidia. Pa ana Pukakiar Sabat dia kas uting na rumai lotu anuna tarai Juda, pa dia kes. ");
INSERT INTO lbb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ning di ka was tar a warwarala ting na Buk a warkurai ane Moses pa tumtumus ana propetla, a ningnigola ana rumai lotu la arsune tetek diau mang, “Naur a tasimila, ning ta warwara na wunan kaning sur mur atai a taraila ono, mur warwara ka ono.” ");
INSERT INTO lbb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","E Pol i tur, pa i sairas la taum ana kuna sur lar kes longoroi, pa i atongi mange, “A tarai Israel pa mulo a tarai masik otleng ning mulo lotu tetek e God, mulor longor iau. ");
INSERT INTO lbb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","E God anumila a tarai Israel i aslang pas na tumtubumila, pa i aburese pas la ning la kes tumo e Ijip, pa i ben purum pas la mitumo ana rakrakaina. ");
INSERT INTO lbb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ana diat a bonot a rau ning la kes ting na hanua bel, i noren la ana toltolla anunla. ");
INSERT INTO lbb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pa ning ka kamar sen tar a taraila miting na mais a matanitu ning la kes tumo e Kenan, lamur i saran tar a kabalapiu Kenan sur anuna tarai Israel. ");
INSERT INTO lbb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","A ututnala rop ne i hanot na arpotor diat a mar pa dilima na bonot (450) a rau. “Lamur e God i suah tar a tena warkuraila sur lar nigon la, tuk ana propet Samuel. ");
INSERT INTO lbb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Lamur la nunung sur ta king, pa e God i saran tar e Sol tetek la. E Sol, a nat e Kis, miting na mangis a tarai Benjamin, pa i nigon la diat a bonot a rau. ");
INSERT INTO lbb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ning e God ka kepsen tar e Sol, i suah tar e Dewit sur ir king anunla. Pa i atongi onoi mang, ‘A oroi e Dewit a nat e Jesi, a barsan ne a katnani, i sot ana nuknukik, pa ir tol arop a ututnala ning a mang suri.’ ");
INSERT INTO lbb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Pa miting na mangis a tarai ane Dewit, e God i saran a Tena Alaun, e Iesu, tetek a tarai Israel, arlar ana nuna lele. ");
INSERT INTO lbb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Lanigo tana tinan ot ane Iesu, e Jon a Tena Baptais i warawai tetek a tarai Israel rop sur lar lingir a nuknukinla pa dir baptais la. ");
INSERT INTO lbb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ning milau ma anuna titol ir rarop, i atai la mang, ‘Mulo nuki mang iau esi? Iau bel esaning mulo harnanai suri. Ika esaning ir mur tak, bel a tolsot sur ar pak sen a inau ana nuna su. A natarna kol tana.’ ");
INSERT INTO lbb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Tastasikla, a mangis a tarai ane Abaram, pa mulo a tarai masik otleng ning mulo lotu tetek e God, di ka saran tar a warwara tetek dala mang e God i alaun a tarai. ");
INSERT INTO lbb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","A tarai Jerusalem, pa nunla na ningnigola, bel la oroi lalan e Iesu mang ai a Tena Alaun ning a propetla la ka tumus tari ono. Ika ning la warkurai tar e Iesu sur ir mat, la tolsot pas a warwara anuna propetla, ning di wasi ana Pukakiar Sabatla rop. ");
INSERT INTO lbb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bel la pastek pas ta laulau a ginina e Iesu sur ir mat ono, ika la nunung e Pailat sur ir saran tar e Iesu sur dir umkoli. ");
INSERT INTO lbb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ning la ka tolsot rop tar a warwarala ning la ka tumus tari onoi, la pak purumi kusun a rakai kutus, pa la aborbori ting na kulam a minat. ");
INSERT INTO lbb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ika e God i akamtur ulaki kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Pa galis a pukakiar, la ning nating la armuri taum onoi mitumo e Galili usaot e Jerusalem la oroi. Pa onone la warwara talapor onoi tetek a tarai Israel. ");
INSERT INTO lbb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Pa mila atai mulo ana Wakak a Warwara mange: A lele ning e God ka saran tari tetek na tumtubundala tagun nating, ");
INSERT INTO lbb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","onone ka tolsot pasi tetek dala, na tumtubunla, ning i akamtur ulak pas e Iesu. Larning di ka tumus tari ting na areur a Saksak mange, ‘U a Natuklik, pa onone ia ka hanot e Tamam.’ ");
INSERT INTO lbb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","E God ka akamtur pas e Iesu kusun a minat, pa bel ir marase. Larning e God ka atong tari mange, ‘A wakak a ututna ning a lele tar onoi tetek e Dewit, ar angisngis mulo onoi. A angisngis ne i totoh pa ir hanot momol ot.’ ");
INSERT INTO lbb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Pa ka atong tari otleng ting na ning a Saksak mange, ‘Bel ur noren tar a Tena Totoh anumi sur ir marase.’ ");
INSERT INTO lbb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“E Dewit i tolsot rop pas a nuknuk e God ana nuna pukakiarla na lalaun. Lamur i mat, pa di pori taum ana dingla na tumtubunala, pa palaona i marase. ");
INSERT INTO lbb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ika, esaning e God i akamtur pasi kusun a minat bel i marase. ");
INSERT INTO lbb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Manglarning, na tastasik, mila warawai tetek mulo mange: Mulor tasmani mang e Iesu i hanot sur ir kepsen anumulo na toltol laulau. ");
INSERT INTO lbb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","A Warkuraila ane Moses bel i tolsot sur ir kepsen anumulo na toltol laulau, sur dir atong mulo mang na tena tostos. Ika, la rop ning la tortorot oe Iesu, dir atong la mang na tena tostos. ");
INSERT INTO lbb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mulor tai alar mulo sakana a ututnala ning a propetla ka warwara tar onoi ir sot omulo. La atongi larne, ");
INSERT INTO lbb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Oroi, mulo na tena morot laulau, mulor kulkulan pa mulor hirua, anasa ar tol ta utna ting na numulo na pukakiar a lalaun. Ning tik ir atai mulo ana utna ning ar toli, bel mulor tortorot onoi.’” ");
INSERT INTO lbb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ning e Pol pa e Barnabas dia purum miting na rumai lotu, a tarai la nunung diau sur diar warwara ulak ana ututnala ne ana Pukakiar Sabat lamur. ");
INSERT INTO lbb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ning a tarai la han sarara miting na rumai lotu, a galis a te Juda pa dingla na tarai masik ning la kas uting na lotu Juda pa la lotu ana momolna, la mur e Pol pa e Barnabas. Dia warwara tetek la, pa dia arakrakai la, sur lar tur rakrakai ana marmaris ane God. ");
INSERT INTO lbb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ana Pukakiar Sabat ning la ka kubus tari, milau sur la rop miting na hanua ning la hanot taum, sur lar longor a warwara anuna Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ning a te Judala la oroi a kunum a tarai, a balanla i laulau tetek e Pol pa e Barnabas, pa la lingir ka a warwarala ning e Pol i warwara ono, pa la atong saksakani. ");
INSERT INTO lbb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ika bel dia matmataut pa dia keles la mange, “I wakak, mia ka atalapor nigon tar a warwara ane God tamulo. Ika ning mulo gilam ris kusuni pa mulo san alar mulo sur gong mulo los a lalaun tikin, onone, miar han tetek a tarai ning bel a tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Anasa a Leklek, i sune miau mange, ‘A suah tar u sur u a talapor tetek a tarai ning bel a tarai Juda, sur ur los a warwara tetek a taraila te na rakrakan hanua rop mang, ar alaun pas la.’” ");
INSERT INTO lbb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ning a taraila ning bel a tarai Juda la longor a warwara ne la gas kol, pa la atong leklek pas a warwara anuna Leklek. Pa la ning e God ka aslang pas la sur a lalaun tikin, la tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A warwara anuna Leklek i han sarara uting na hananuala rop ting na papar ning. ");
INSERT INTO lbb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ika a te Judala, la akutkut balan a ningnigo na gurarala ning la sira hanrawai e God, pa ningnigo na tarai otleng miting na hanua ning. La akutkut balan dingla otleng, sur lar balakut tetek e Pol pa e Barnabas, pa la alulu sen diau kusun anunla papar. ");
INSERT INTO lbb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pa dia tang sen a kubus kusun a handiau sur a akinalang mang a toltol ning la toli i laulau, pa dia han utumo e Ikonion. ");
INSERT INTO lbb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pa tarai a asaer tumo e Antiok la bukus taum ana gasgas, pa Talngan Tabu. ");
INSERT INTO lbb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","E Pol pa e Barnabas dia kas uting na rumai lotu anuna tarai Juda tumo e Ikonion, larot ning dia sira toli ting na hananuala. Ning dia warwara, anundia na warwara i talapor, pa galis a tarai Juda pa dingla na tarai otleng, la tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ika dingla na tarai Juda ning bel la mang sur lar tortorot, la akamtur a balan dingla na tarai ning bel a tarai Juda, pa la alaulau a nuknukinla sur a nuknukinla ir laulau tetek la ning la tas ana tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","E Pol pa e Barnabas dia kes bongnan diau tumo e Ikonion, pa bel dia matmataut, dia rakrakai ana warwara ana risana Leklek. Pa Leklek i amomol tar anundia na warwara ana nuna tnan marmaris ning i saran a rakrakai tandiau sur diar tol a ututnala na kulkulan, pa akinalangla. ");
INSERT INTO lbb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A tarai miting na hanua ning la taptapagal, dingla la tur taum ana tarai Juda ning bel la tortorot, pa dingla la tur taum ana naur a aposel. ");
INSERT INTO lbb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dingla na tarai Juda pa dingla na tarai otleng ning bel a tarai Juda pa anunla na ningnigola, la warwara taum pas sur lar alaulau e Pol pa e Barnabas, pa lar wolot amat diau ana hatatla. ");
INSERT INTO lbb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ika, ning e Pol pa e Barnabas dia longori, dia han masik uto na papar Likonia, sur uting na naur a hanua Listra pa e Derbe, pa dingla na hananua otleng ning la kes milau. ");
INSERT INTO lbb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Pa dia warawai amon tetek la tingia ana Wakak a Warwara. ");
INSERT INTO lbb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tumo e Listra, ning a barsan i kes, naur a hana dia mat. Di agon pasi ot larning, bel i tolsot sur ir han. ");
INSERT INTO lbb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","I longor e Pol i warwara. Pa e Pol i ngosoni, pa i oroi mang a barsan ning i tortorot sur dir alangolango i. ");
INSERT INTO lbb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pa e Pol i warwara kol teteki, “Ur tur tostos ana naur a ham.” Ono otning i sirok kas pa i turpas a han. ");
INSERT INTO lbb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ning a kunum a tarai la oroi asaning e Pol i toli, la warwara kol ana warwara Likonia mange, “Naur a god dia ka han purum arlar ana naur a momolna tetek dala!” ");
INSERT INTO lbb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","La atong e Barnabas a god Sus pa e Pol a god Hermes, anasa ai a tena warwara tandiau. ");
INSERT INTO lbb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A rumai artabar anuna god Sus i tur tumo lapiu milau a ris a hanua ning. Pa tena artabar tetek a god Sus i ben a barsan a bulumakaula sur uting na taman na hanua pa i los otleng a purpurla ning di ka suk tari. I toli larning suri taum ana kunum a tarai lar artabar tetek e Pol pa e Barnabas sur lar lotu tetek diau. ");
INSERT INTO lbb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ika ning naur a aposel dia ka tasman a utna ning a tarai la mang sur lar toli, dia silir anundiau na kaenla, pa dia dun potor a taraila, pa dia kukuk kol mange, ");
INSERT INTO lbb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mulo a taraila, asa kamkamna ning mulo tol a ututnala ne? Mia naur a barsan ka, mia arlar ka omulo! Mia hanot ka ana Wakak a Warwara tetek mulo, pa mia atai mulo sur mulor talingir kusun a ututna oros ka, ning mulo sira lotlotu tetek la, sur mulor mur e God, esaning i laun. Esaning i tol a langit, a rakrakan hanua, a tasi, pa ututnala rop tingia onditol. ");
INSERT INTO lbb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nating i noren tar a taraila miting na matanitula rop sur lar laun arlar ana nuknukinla. ");
INSERT INTO lbb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ika e God i akes tar a ututnala sur mulor tasmani mang i ot e God. Ana nuna marmaris i tabar mulo ana kiar misaot na langit, a rakaila la wai ana kalang inla ot, i tabar mulo ana galis a utna na hangan, pa i abukus mulo ana gasgas.” ");
INSERT INTO lbb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Dia atong a warwara ne, ika a tarai la mang ot sur lar lotu tetek diau taum ana artabar ning di tun tari. Pa dia sairas rakrakai la tuk ning la manah. ");
INSERT INTO lbb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lamur dingla na te Judala la han mitumo e Antiok pa e Ikonion, la lingir a nuknuk a kunum a tarai kusun e Pol pa e Barnabas. La wolot e Pol ana hatatla, pa la rih purumi kusun a hanua, pa la nuki mang ka mat. ");
INSERT INTO lbb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ika ning a tarai a asaer la tur talilis pasi, i tur, pa i kas ulak uting na hanua. Ana pukakiar lamur, i han taum oe Barnabas utumo e Derbe. ");
INSERT INTO lbb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ning e Pol pa e Barnabas dia ka warawai pas ana Wakak a Warwara tumo e Derbe pa dia ka asaer tar a galis a tarai sur la a kakak a asaerla, dia ulak utumo e Listra, Ikonion, pa e Antiok. ");
INSERT INTO lbb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Dia arakrakai a tarai a asaer miting na natol a hanua ning, pa dia wunan la, sur lar tur rakrakai ana nunla tortorot. Dia atai la mange, “A galis a mamahat ir kibas nigon tar dala, lamur dalar kas ting na matanitu ane God.” ");
INSERT INTO lbb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Dia aslang tar dingla na tarai sur lar ningnigo anuna tarai a lotu ting na taktakai hanua. Dia araring pa dia tamai, pa dia saran tar la tetek a Leklek, esaning la tortorot ono. ");
INSERT INTO lbb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ning dia ka han pas ting na hananuala ting na papar Pisidia, lamur dia hanot tumo na papar Pampilia. ");
INSERT INTO lbb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ning dia ka warawai pas tumo e Perga, dia han utumo e Atalia. ");
INSERT INTO lbb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Dia kas ana sip mitumo e Atalia sur uto e Antiok. E Antiok a hanua ning a tena tortorotla la saran tar diau ana marmaris ane God, sur a titol ne dia ka arop tari. ");
INSERT INTO lbb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ning dia hanot, dia kabah taum pas a tarai a lotu, pa dia atai la ana ututnala rop ning dia toli ana rakrakai e God. Dia atai la otleng mang e God ka tol a ngas sur a tarai ning bel a tarai Juda lar tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pa dia kes bongnan diau tingia taum ana tarai a asaerla. ");
INSERT INTO lbb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Dingla na tarai misaot e Judia la han uto e Antiok, pa la asaer la ning la tas ana tortorot mange, “Ning bel di kot talilis a palaona ta kaklik barsan arlar ana warkurai ane Moses, bel dir alaun mulo.” ");
INSERT INTO lbb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","E Pol pa e Barnabas dia arlak kol taum onla. Pa tarai a lotu la aslang tar e Pol pa e Barnabas pa dingla na tarai a tortorot otleng, sur lar han usaot e Jerusalem tetek a aposella pa ningnigola anuna tarai a lotu, sur lar deken la ana utna ne. ");
INSERT INTO lbb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","A tarai a lotu la tur tulan la, pa la solong naur a papar Ponisia pa e Samaria. Ning la han, la warwara amon tetek a tarai a lotu ting na hananuala, mang a tarai ning bel a tarai Juda la lingir a nuknukinla. Pa la ning la tas ana tortorot, la gas kol ning la longori. ");
INSERT INTO lbb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ning la hanot saot e Jerusalem, a tarai a lotu pa aposella pa ningnigola ana lotu la agasgas pas la. Pa dia atai la ana ututnala ning dia toli ana rakrakai e God. ");
INSERT INTO lbb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Dingla na Parisaio ning la tortorot oe Iesu, la tur pa la atongi mang, “I tostos ot sur dir kot talilis a tarai ning bel a tarai Juda ning la lingir a nuknukinla. Pa dir asaer la sur lar mur a Warkuraila ane Moses.” ");
INSERT INTO lbb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","A aposella pa ningnigola la kes taum sur lar nuknuk wakak ana utna ne. ");
INSERT INTO lbb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ning la ka warwara kol pas onoi, e Pita i tur pa i atai la mange, “Na tastasik, mulo tasmani mang nating ot, e God i aslang pas iau, a halimulo, sur ar warawai ana Wakak a Warwara tetek la ning bel a tarai Juda, sur lar longori pa lar tortorot ono. ");
INSERT INTO lbb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","E God, esaning i tasman a nuknuk a taraila rop, i asangani tetek dala mang i gas pas la ning bel a tarai Juda, ning i saran a Talngan Tabu tetek la, larning i sarani tetek dala. ");
INSERT INTO lbb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Anuna titol tetek dala pa tetek la bel i maskana. I atotoh la otleng ning la tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sur asaning mulo mang sur mulor lar e God, ning mulo saran tar a mamahat a titol tetek a tarai a asaer ning mulo atongi mang lar mur a Warkuraila ane Moses? Anundala mangis a tarai tagun nating bel la tolsot sur lar muri, pa dala otleng onone bel dala tolsoti. ");
INSERT INTO lbb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ika dala tortorot mang dir alaun dala anasa ana marmaris ana nundala Leklek e Iesu, arlar ka otleng onla.” ");
INSERT INTO lbb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pa tarai rop ning la kes taum, la kes longoroi, ning la longor e Pol pa e Barnabas, dia warwara ana akinalangla pa ututna na kulkulan ning dia toli ana rakrakai e God tetek a taraila ning bel a tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ning dia manah ana warwara, e Jems i atongi mang, “Na tastasik, mulor longor iau. ");
INSERT INTO lbb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","E Saimon i atai dala ana ningnigo na pukakiar ning e God i maris la ning bel a tarai Juda, pa i ben pas dingla na tarai onla sur la anunai ot. ");
INSERT INTO lbb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A utna ne e God i toli i arlar ana warwara anuna propetla. Larning di ka tumus tari mange, ");
INSERT INTO lbb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Lamur tana, ar ulak, par tol ulak a rumai ane Dewit, ning ka taroh. Par atur ulak pas a rumai ning i taroh, par tol wakak ulaki. ");
INSERT INTO lbb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Pa tarai masik otleng, a tarai ning bel a tarai Juda, lar talingir tetek a Leklek, la ning ia ka kabah pas la sur anuki. A warwarala ne ana Leklek, esaning ka warwara talapor tar ana ututnala ne’ nating ot. ");
INSERT INTO lbb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Pa a nuknukik i manglarne, gong dala saran a mamahat tetek a taraila ning bel a tarai Juda, ning la talingir tetek e God. ");
INSERT INTO lbb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Dalar tumtumus tetek la, pa dalar atai la mang gong la ien ta utna ning di ka artabar tar ono tetek a asasongo na godla, anasa a lotu ning i adur a utna na hangan, gong la tol a toltol a pamuk, gong la ien ta utna ning bel di gos wakak a suluk kusuni, pa gong la ien ta inagoi ning di pos koli ka, anasa a suluk kaning ot ono. ");
INSERT INTO lbb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Anasa tagun nating ot ting na hananuala rop, di was a Warkuraila ane Moses, pa la warawai onoi ting na rumai lotula ana Pukakiar Sabatla.” ");
INSERT INTO lbb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","A aposella pa dingla na ningnigo, taum ana tarai a lotu rop, la warwara taum sur lar aslang pas ir naur a barsan miting onla, sur diar han taum oe Pol pa e Barnabas utumo e Antiok. La aslang pas e Judas, ning a risana otleng e Barsabas, pa e Sailas, naur a ningnigo miting onla ning la tas ana tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pa la tumus tar a pas sur lar losi. A pas i atongi mange: Mila a aposella pa ningnigola, na tastasimulo, mila tumtumus tetek mulo a tena tortorotla miting na tarai ning bel a tarai Juda ning mulo kes tumo e Antiok, pa ting na naur a papar Siria pa e Silisia: A marmaris tetek mulo, ");
INSERT INTO lbb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mila ka longori mang dingla na tarai omila, la atongi mang mulor mur a Warkuraila rop ane Moses, pa la aloklokron a nuknukimulo ono. Bel mila sune la. ");
INSERT INTO lbb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Onone mila ka warwara taum pas, pa mila rop mila nuki mang i wakak sur milar aslang pas naur a barsan, pa milar sune diau tetek mulo taum ana naur a halimila, e Barnabas pa e Pol, ");
INSERT INTO lbb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","naur a barsan ning bel dia mangan alar anundiau a lalaun ana risana anundala Leklek e Iesu Karisito. ");
INSERT INTO lbb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","I maining milar sune e Judas pa e Sailas tetek mulo, pa diar atai mulo ana warwarala ne mila tumusi te na pas ne. ");
INSERT INTO lbb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","A Talngan Tabu i asangan mila sur gong mila saran tar ta mamahat tetek mulo. Dingla na ututnala ka ne mulor muri: ");
INSERT INTO lbb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Gong mulo ien ta utna ning di artabar ono tetek a asasongo na godla. Gong mulo ien ta utna ning bel di gos wakak a suluk kusuni, pa ta inagoi ning di pos koli ka, anasa a suluk kaning ot ono. Pa gong mulo tol a toltol a pamuk. Ir wakak kol tetek mulo ning bel mulor tol a ututnala ne. Ai ka, pa marmaris tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Di sune sen la pa la han utumo e Antiok. Pa la kabah taum pas a tarai a lotu, pa la saran tar a pas ning tanla. ");
INSERT INTO lbb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ning la wasi, la gas kol ana wakak a warwara na wunan. ");
INSERT INTO lbb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","E Judas pa e Sailas dia wunan la pa dia arakrakai la ning la tas ana tortorot ana galis a warwara, anasa diau naur a propet. ");
INSERT INTO lbb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Ning dia ka kes bongnan diau tingia, na tastasindiau ana tortorot la tur tulan diau taum ana balmolmol, sur diar ulak usaot e Jerusalem tetek la ning la sune diau. ");
INSERT INTO lbb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ika e Pol pa e Barnabas dia kes ot tumo e Antiok. Dia taum ana galis a tarai onla, la asaer a tarai, pa la warawai ana warwara anuna Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Dingla na pukakiar lamur, e Pol i atai e Barnabas mang, “Dar ulak uting na hananuala rop, ning da ka warawai pas tingia ana warwara anuna Leklek, sur dar oroi na tastasindau ana tortorot mang la ka mangmangasa.” ");
INSERT INTO lbb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pa e Barnabas i mang sur diar ben e Jon, ning a risana otleng e Mak. ");
INSERT INTO lbb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ika e Pol i nuki mang bel i wakak ning diar beni, anasa i han kusun diau tumo e Pampilia, pa bel i mur diau tuk ning a titol i rop. ");
INSERT INTO lbb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pa dia warwara na balakut kol ono, pa lamur dia han sarara. E Barnabas i ben pas e Mak, pa dia kas ana sip uto na lolo Saiprus. ");
INSERT INTO lbb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pa e Pol i aslang pas e Sailas, sur diar han. Pa na tastasindiau ana tortorot la saran tar diau ana marmaris ana Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Dia solong naur a papar Siria pa e Silisia, pa dia arakrakai a tarai a lotu ting na hananuala. ");
INSERT INTO lbb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ana tinan ane Pol pa e Sailas dia hanot tumo e Derbe pa lamur tumo e Listra. Ning a hala tarai a asaer i kes ting na hanua Listra, a risana e Timoti, a nat a hane Juda, a tena tortorot, pa e tamana a te Grik. ");
INSERT INTO lbb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","La ning la tas ana tortorot tumo e Listra pa e Ikonion la warwara oe Timoti mang ai a wakak a barsan. ");
INSERT INTO lbb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pa e Pol i mang sur ditol ar han taum. I ben pasi, pa i kot talilisi, anasa a te Judala ning la kes ting na hananuala ning, la tasmani mang e tamana a te Grik. ");
INSERT INTO lbb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ning ditol han uting na hananuala, ditol warwara amon ana warkurai anuna aposella pa ningnigola saot e Jerusalem, sur a tarai lar muri. ");
INSERT INTO lbb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Di arakrakai a tortorot anuna tarai a lotu ting na hananuala, pa wawas onla i han kas amon ana pukakiarla rop. ");
INSERT INTO lbb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","A Talngan Tabu i sairas ditol sur gong kaba ditol warawai ana Wakak a Warwara tumo na papar Esia. Ditol han ka utumo na naur a papar Prigia pa e Galesia. ");
INSERT INTO lbb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ning ditol hanot ting na ararop a papar Misia, ditol mang sur ditol ar han uto e Bitinia, ika a Inguna e Iesu bel i malmaling sur ditol ar han uto. ");
INSERT INTO lbb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pa ditol bolos a papar Misia, pa ditol han uto e Troas. ");
INSERT INTO lbb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ana morom, e Pol i oroi a tatatai. I oroi pas ning a barsan a te Masedonia i tur pa i nunungi mange, “Ur lamut ute e Masedonia, pa ur nangan mila.” ");
INSERT INTO lbb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ning ka oroi tar a tatatai, ono otning mila sang sur a tinan uto e Masedonia, anasa mila tasmani mang e God ot i kabah pas mila, sur milar warawai tetek la ana Wakak a Warwara. ");
INSERT INTO lbb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ning mila han mitumo e Troas mila kas ana sip, pa mila han tostos uto na lolo Samotres. Ning a pukakiar ulak mila han kale uto e Neapolis. ");
INSERT INTO lbb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Pa mila han miting e Neapolis uto e Pilipai, a tnan hanua kol tana hananuala tumo na papar Masedonia, pa tarai Rom la kes tingia. Mila kes pas dingla na pukakiar tingia. ");
INSERT INTO lbb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ana Pukakiar Sabat mila purum ting na taman a hanua ning, sur a malum, anasa mila nuki mang ta pukna na niaring kaning ia. Mila kes, pa mila warwara tetek a gurarala ning la kes taum tingia. ");
INSERT INTO lbb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ning a halinla ning la longor mila a risana e Lidia, a hane mitumo e Tiatira, a tena siuran pepol a kaen, pa tena lotu tetek e God. Pa Leklek i lingir anuna lalaun sur ir longor ana warwarala ning e Pol i atongi. ");
INSERT INTO lbb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ning di ka baptais tar e Lidia, pa la otleng ning la kes ting na nuna rumai, i ben pas mila, pa i atongi mang, “Ning mulo nuki mang a tortorot ana Leklek, mulor kas ute na nuk a rumai, pa mulor kes napirik.” Pa i angongos pas mila tuk ning mila malmaling. ");
INSERT INTO lbb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ning a pukakiar mila han sur uting na pukna na niaring, mila songo pas ning a tena titol oros, a hane, a mot kaning onoi, pa i tolsot pasi sur ir warwara nigo ana utna ning ir hanot lamur. Anuna ningnigola la sira kibas a tnan mani ana nuna titol. ");
INSERT INTO lbb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","A hane ne i mur mila ma e Pol, pa i warwara kol mange, “A taraila ne, la na tena titol oros ane God i Leklek Kol, pa la atai mulo ana ngas ning dir alaun mulo ono.” ");
INSERT INTO lbb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A galis a pukakiar i toli larne. Ning e Pol i ngoro onoi, i talingir, pa i atai a mot mange, “A atai u ana risana e Iesu Karisito, ur purum kusun a hane ne.” Pa ono otning, a mot i purum kusuni. ");
INSERT INTO lbb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A ningnigola anuna hane ne la tasmani mang bel ma lar oroi ulak ta mani taguni. La tong akes pas e Pol pa e Sailas, pa la dat diau uting na tinine hanua, pa la atur diau na matana ningnigola. ");
INSERT INTO lbb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","La ben diau tetek a tena warkuraila pa la atongi mange, “Naur a barsan ne, naur a te Juda, dia tol a tnan mamahat te na anundala hanua. ");
INSERT INTO lbb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Pa dia asaer a tarai ana ututnala ning bel i tostos sur dala a tarai Rom dalar longor ono, pa dalar muri.” ");
INSERT INTO lbb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A kunum a tarai otleng la warwara kol ana artitiu ondiau, pa tena warkuraila la arsune sur dir silir sen anundiau na kaenla pa dir miras diau. ");
INSERT INTO lbb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ning di ka miras rakrakai tar diau, di akas diau ting na karabus, pa di atai a tena tai alar mang ir tai alar rakrakai diau sur gong dia purum. ");
INSERT INTO lbb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ning a tena tai alar i longor a warwara ne, i akas diau ting na tuka rumai na arpotor ana karabus, pa i suah alar tar diat a handiau ana palang. ");
INSERT INTO lbb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ana tnan morom, e Pol pa e Sailas dia araring, pa dia saken a saksakla tetek e God, pa tarai otleng ning la karabus, la longor diau. ");
INSERT INTO lbb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bel i bongnani, pa tnan mamais i hanot kulkulan, pa i gulen a kaba pos na rumai. Ono otning a tamanla rop la sapang, pa senla miting na kuna tarai a karabus rop la tapapak. ");
INSERT INTO lbb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","A tena tai alar i mata, pa ning i oroi a tamanla i sapang, i dat pas anuna liwan a harum sur ir umkol i ot onoi, anasa i nuki mang a tarai a karabus la ka liu rop. ");
INSERT INTO lbb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ika e Pol i arkabah rakrakai teteki mange, “Gong u alaulau u, mila rop kanet.” ");
INSERT INTO lbb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pa tena tai alar i arkabah sur a lamla, i dun kas kapit, i matmataut pa i koloron, i punga purum salanigo ta e Pol pa e Sailas. ");
INSERT INTO lbb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pa i ben purum pas diau, pa i deken diau mange, “Naur a barsan, asaning ar toli sur dir alaun iau?” ");
INSERT INTO lbb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pa dia kelesi mange, “Ur tortorot ana Leklek e Iesu pa dir alaun u, pa la otleng ning la kes ting na num a rumai.” ");
INSERT INTO lbb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pa dia warwara ana warwara anuna Leklek tetek la rop ning la kes ting na nuna rumai. ");
INSERT INTO lbb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ana morom ot ning, a tena tai alar i ben pas diau, pa i gos a mangmangrasla kaning na palaondiau. Pa ana pukakiar ot ning di baptais a tena tai alar, pa la rop ning la kes ting na nuna rumai. ");
INSERT INTO lbb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","I ben pas diau uting na nuna rumai, pa i tabar diau ana utna na hangan. Pa i bukus ana gasgas, la taum ana nuna tarai, anasa la tortorot oe God. ");
INSERT INTO lbb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ana kobot ning ot a tena warkuraila la sune naur a polis tetek a tena tai alar ana warwara mange, “Ur pak sen naur a barsan ning.” ");
INSERT INTO lbb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Pa tena tai alar i atai e Pol mange, “A tena warkuraila la arsune sur dir pak sen mu. Onone mur purum, mur han taum ana balmolmol.” ");
INSERT INTO lbb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ika e Pol i atai naur a polis mange, “Belot tik i warkurai miau, la miras miau na matana tarai, ika miau naur a te Rom ot. La akas tar miau uting na karabus, pa onone la mang sur lar pak kumnan sen miau. Ika bel! I wakak sur la ot lar lamut pa lar pak sen miau.” ");
INSERT INTO lbb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Naur a polis dia ulak, pa dia atai a tena warkuraila ana warwarala ne. Ning la longori mang diau naur a te Rom, la matmataut. ");
INSERT INTO lbb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pa la han, la apuasa anunla na rongo tetek diau. La ben purum diau kusun a karabus, pa la nunung diau sur diar han masik kusun anunla hanua. ");
INSERT INTO lbb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pa ning dia ka han kusun a karabus, dia han sur uting na rumai ane Lidia. Pa dia oroi la ning la tas ana tortorot tingia. Dia wunan tar la, lamur dia han kusun a hanua. ");
INSERT INTO lbb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ning e Pol pa e Sailas dia bolos e Ampipolis pa e Apolonia, dia hanot tumo e Tesalonika. Ning a rumai lotu anuna tarai Juda kaning ia. ");
INSERT INTO lbb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pa e Pol i kas tetek la ting na rumai lotu, larning i sira toli. Ana natol a Pukakiar Sabat ot, i warwara taum onla ana Buk Tabu. ");
INSERT INTO lbb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","I papak, pa i atong talapori mang i sot ot sur e Karisito ir mat pa ir kamtur ulak kusun a minat. Pa i atongi mange, “E Iesu ning a atai mulo onoi, i ot a Karisito.” ");
INSERT INTO lbb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Dingla na tarai Juda pa galis a te Grik ning la lotu tetek e God, pa galis a ningnigo na gurarala otleng la tortorot ning la longor a warwara, pa la mur e Pol pa e Sailas. ");
INSERT INTO lbb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ika, dingla na tarai Juda la bal laulau ondiau, pa la ben pas a tarai laulaula miting na tinine hanua. La han taum, pa la tol a tnan mamahat ting na hanua. La dun kas uting na rumai ane Jeson, la seren e Pol pa e Sailas sur lar ben purum diau tetek a taraila. ");
INSERT INTO lbb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ika bel la pastek diau. La dat pas e Jeson pa dingla na tarai otleng ning la tas ana tortorot, tetek a ningnigola miting na hanua ning, pa la warwara kol mange, “A taraila ne la tol a tatatnan mamahatla ting na hananuala te na rakrakan hanua, pa onone, la hanot kale tetek dala! ");
INSERT INTO lbb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Pa e Jeson i ben kas la uting na nuna rumai. La rop ne la lakai a warkuraila anuna Sisar, a king anuna tarai Rom, pa la atongi mang ning a barsan, a risana e Iesu, i ning a king.” ");
INSERT INTO lbb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ning a taraila pa ningnigola la longor a warwara ne, la loklokron kol ono. ");
INSERT INTO lbb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","La los mani kusun e Jeson pa la otleng ning di dat taum pas la, sur dir lou purum la ono. Lamur la pak sen la. ");
INSERT INTO lbb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ning i morom purum, la ning la tas ana tortorot la sune e Pol pa e Sailas uto e Beria. Ning dia ka hanot tingia, dia kas uting na rumai lotu anuna tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","La ne la wakak tanla tumo e Tesalonika, anasa la mang kol sur lar kibas a warwara ne, pa la was wakak a warwarala miting na Buk Tabu ana pukakiarla rop, sur lar tasmani mang a warwara ane Pol i momol o bel. ");
INSERT INTO lbb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pa galis a tarai Juda, pa galis a tarai Grik otleng, pa galis a gurara Grik ning a ningnigola, la tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ning a tarai Juda mitumo e Tesalonika la longori mang e Pol i warawai ana warwara ane God tumo e Beria, la han utumo pa la akutkut a balan a kunum a tarai pa la akamtur a balanla. ");
INSERT INTO lbb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pa la ning la tas ana tortorot la sune kapit e Pol utumo latasi. Ika e Sailas dia ma e Timoti dia kes ot tumo e Beria. ");
INSERT INTO lbb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A taraila ning la ben e Pol, la han taum onoi uto e Atens. Lamur i sune ulak la ana warwara tetek e Sailas pa e Timoti mang diar han kapit teteki. ");
INSERT INTO lbb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ning e Pol i nanan diau tumo e Atens, i balmaris kol, ning i oroi mang a hanua ning i bukus ana manarla ning la sira lotu tetek la. ");
INSERT INTO lbb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pa i warwara ting na rumai lotu taum ana tarai Juda, pa dingla na tarai masik otleng ning la lotu tetek e God. Pa ana pukakiarla rop i warwara otleng tanla ning la arsongo ting na tinine hanua. ");
INSERT INTO lbb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","A tena tastasmanla ana asaer anuna kunum Epikurian pa kunum Stoik la harum na warwara taum oe Pol. Dingla na tarai la deke mang, “Asane a tena abereng wara ne i atai dala ono?” Pa dingla otleng la atongi mange, “Ngandek i atai dala ana tona godla miting na ta hanua masik.” La atongi larne, anasa e Pol i warawai oe Iesu pa ana lalaun ulak kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","La ben pas e Pol usaot na kiwung di atongi mang e Areopagus, pa la atai i mange, “Mila mang sur milar tastasmai ana tona warwara ning u asaer mila ono. ");
INSERT INTO lbb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","A utna ning u warwara ono, i maskana tetek mila, pa mila mang sur milar tasman a kamkamna.” ");
INSERT INTO lbb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","La atongi larning anasa a te Atensla pa wasirala otleng ning la kes tingia, la arnore ka ana pukakiarla ana warwara pa longlongor sur al tona asaer. ");
INSERT INTO lbb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","E Pol i tur potor a tarai a kiwung Areopagus, pa i atongi mange, “A tarai Atens, ting na titolla ning mulo toli, a oroi mang mulo na tena lotu. ");
INSERT INTO lbb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Anasa, ning a han taltal te, a oroi a manarla ning mulo sira lotu tetek la, pa ia ka oroi tar otleng ning a logo ning di tun a artabarla onoi, a tumtumus kaning ono i mange, ‘Tetek a god ning bel di tasmani’. Esaning mulo lotu teteki, ika bel mulo tasmani, i ot ne, a warawai onoi tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","E God ot ning i tol a rakrakan hanua pa ututnala rop ning la kes tingia, ai a Leklek ana langit pa rakrakan hanua, pa bel i kes ting na rumai lotula ning a tarai la toli. ");
INSERT INTO lbb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pa bel i kapan sur tik ir nangani, anasa i ot i tabar a taraila rop ana lalaun, pa wuwu na lalaun, pa ututnala rop. ");
INSERT INTO lbb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","E God i akes tar a ningnigo na barsan. Pa tarai miting na matanitula rop la hanot taguni, pa la kes te na rakrakan hanua rop. Ting na nuknuk e God i nuki mang lar kes tahaia, pa nangse lar hanot, pa nangse lar rop ulak. ");
INSERT INTO lbb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","E God i tol a ututnala ne sur a tarai lar tai suri, pa ngandek lar tai taltal suri pa lar seren pasi. Ika, e God bel i kes bakbak kusun dala rop. ");
INSERT INTO lbb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Larning di ka atong tari, ‘Dala laun, dala han taltal, pa dala tong akes a lalaun, i kamkamna ot oe God.’ Arlar ana numulo na tena pak saksak la atongi mange, ‘Dala otleng na natnatnala ot.’ ");
INSERT INTO lbb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Ning dala na natnat e God, bel i wakak sur dalar nuki mang e God i arlar ana manar a gol, o a silwa, o a hat, ning a tarai la nuk otnan pasi pa la toli ana kunla. ");
INSERT INTO lbb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ana raula nating, e God i noren a taraila ning bel la nuk pasi, ika onone, i atai a taraila rop ting na hananuala sur lar lingir a nuknukinla. ");
INSERT INTO lbb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Anasa ka kubus tar a pukakiar, sur ir warkurai a rakrakan hanua ana tostos a warkurai. Pa ka aslang tar ning a mainla ning ir tol a warkurai, pa i amomoli tetek a taraila rop, ning i akamtur ulak pas a barsan ning kusun a minat.” ");
INSERT INTO lbb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ning la longor a warwara ana lalaun ulak kusun a minat, dingla na tarai miting onla, la morot laulau onoi, ika dingla la atai i mange, “Mila mang sur ur warwara ulak tetek mila ana utna ne.” ");
INSERT INTO lbb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pa e Pol i purum kusun la. ");
INSERT INTO lbb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pa dingla na tarai la tortorot, pa la mur e Pol. La ne: E Dionisius, i miting na tarai a kiwung Areopagus, pa ning a hane, a risana e Damaris, pa dingla na tarai otleng. ");
INSERT INTO lbb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ning a ututnala ne ka rop, e Pol i han mitumo e Atens uto e Korin. ");
INSERT INTO lbb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Dia arsongo taum ana ning a te Juda tingia, a risana e Akuila, i mitumo e Pontus, pa nuna hane, a risana e Prisila. Nating ka dia han mitumo e Itali, anasa e Sisar Klodius i warkurai i mang a tarai Juda rop lar han mitumo e Rom, a tnan hanua tumo e Itali. Pa e Pol i han sur ir geren diau. ");
INSERT INTO lbb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","I kes taum ondiau pa ditol titol taum, anasa ditol natol a tena tol rumai a sel. ");
INSERT INTO lbb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ana Pukakiar Sabatla i warwara taum onla ting na rumai lotu, sur ir dat atur a nuknuk a tarai Juda pa la otleng ning bel a tarai Juda sur lar tortorot oe Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ning e Sailas pa e Timoti dia hanot mitumo na papar Masedonia, e Pol bel i manah ana warawai ana warwara ane God, pa i apuasa i tetek a tarai Juda mang e Iesu a Karisito esaning e God i sune i ute. ");
INSERT INTO lbb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ika a tarai Juda la warwara alalar ka a asaer ane Pol pa la atong saksakani. Pa e Pol i daplan anuna kaen, a asilang mang bel ma ir warwara ulak tetek la. Pa i atai la mange, “Ning mulor hirua ana warkurai ane God, mulo ot a kamkamna, pa ia ka langolango. Turpasi onone, ar han kama tetek la ning bel a tarai Juda.” ");
INSERT INTO lbb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pa i purum kusun a rumai lotu, pa i kas uting na rumai anuna ning a barsan, a risana e Titius Jastus, a tena lotu tetek e God, pa anuna rumai i tur milau a rumai lotu. ");
INSERT INTO lbb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","E Krispus a ningnigo miting na rumai lotu pa la rop otleng ning la kes ting na nuna rumai, la tortorot ana Leklek. Pa galis a tarai Korin, ning la longor a warawai ane Pol, la tortorot, pa di baptais la. ");
INSERT INTO lbb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ning a morom a Leklek i warwara tetek e Pol ana tatatai mange, “Gong u matmataut, ur warwara ka. Gong u kes longoroi, ");
INSERT INTO lbb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","anasa a kes taum hom, pa bel tik ir alaulau u, anasa anuk a galis a tarai kane na hanua ne.” ");
INSERT INTO lbb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pa e Pol i kes tingia ning a rau pa diono na kalang, pa i asaer la ana warwara ane God. ");
INSERT INTO lbb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ana rau ning e Galio i ningnigo tumo na papar Akaia, a tarai Juda la tur taum sur lar um e Pol, pa la beni sur ir tur ana warkurai. ");
INSERT INTO lbb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Pa la atongi mange, “A barsan ne i asaer a tarai sur lar lotu tetek e God ana toltol ning bel i arlar ana Warkuraila anumila a tarai Juda.” ");
INSERT INTO lbb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ning e Pol i mang sur ir warwara, e Galio i atai a tarai Juda mang, “Mulo a tarai Juda, ning a utna ne i toli ir laulau, pa bel i mur a warkurai anuna matanitu, ir tostos sur ar longor mulo ono. ");
INSERT INTO lbb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ika ning mulo tiwi ka ana warwarala, pa ana risingla, pa ana numulo na warkuraila ot, i wakak ning mulo ot mulor warkurai i. Iau bel ar warkurai a toltolla larne.” ");
INSERT INTO lbb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Pa i kepsen la kusun a keskes a warkurai. ");
INSERT INTO lbb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Pa la rop la tong akes pas e Sostenes, a ningnigo miting na rumai lotu anuna tarai Juda, pa la umi na matana keskes a warkurai. Ika e Galio bel i pos balana ana utna ne. ");
INSERT INTO lbb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ning e Pol ka kes bongnani tumo e Korin, i han kusun la ning la tas ana tortorot pa i han uto e Senkria. Ning i kes tingia di kumur arop a hihna, anasa ka tolsot pas anuna lele tetek e God. E Prisila pa e Akuila taum oe Pol ditol kas ana sip utumo na papar Siria. ");
INSERT INTO lbb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ning a sip i sot to e Epeses, e Pol i han kusun diau tingia, pa i kas uting na rumai lotu, pa i warwara taum ana tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ning la nunungi sur ir kes al siklik taum onla, bel i longor tanla. ");
INSERT INTO lbb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pa ning la han sarara, i atai la mange, “Ning a nuknuk e God, ar ulak tetek mulo.” Pa i han mitumo e Epeses ana sip. ");
INSERT INTO lbb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ning i sot to e Sisaria i han usaot e Jerusalem pa i oroi tar a tarai a lotu, pa lamur i han uto e Antiok. ");
INSERT INTO lbb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ning ka kes pas dingla na pukakiar tingia, i han kusun la. Pa i han taltal ting na hananuala ting na naur a papar Galesia pa e Prigia, pa i arakrakai a tortorot anuna tarai a asaer rop. ");
INSERT INTO lbb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ning a te Juda mitumo e Aleksandria, a risana e Apolos, i hanot to e Epeses. I ning a wakak a tena warwara, pa i tastasman kol ana Buk Tabu. ");
INSERT INTO lbb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Di ka asaer tari ana ngas anuna Leklek, pa i gas kol sur ir warawai. I asaer wakak oe Iesu, ika i tasman ka a baptais ane Jon. ");
INSERT INTO lbb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","I han uting na rumai lotu pa i turpas a warwara pa bel i matmataut. Ning e Prisila pa e Akuila dia longori, dia ben pasi, pa dia atong talapor a ngas ane God teteki. ");
INSERT INTO lbb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ning e Apolos i mang sur ir han utumo na papar Akaia, la ning la tas ana tortorot to e Epeses, la wunan tari, pa la tumtumus tetek a tarai a asaer tumo e Akaia, sur lar gas pasi. Pa ning ka hanot tumo na papar Akaia, ai a wakak a tena arnangai tetek la, ning e God ka lingir pas la ana tnan marmaris anunai sur lar tortorot. ");
INSERT INTO lbb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Anasa i keles rakrakai a warwara anuna tarai Juda na matana tarai ning la puai mang e Iesu bel a Karisito. Pa i amomol tari ana warwara na Buk Tabu mang e Iesu ot a Karisito. ");
INSERT INTO lbb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ning e Apolos i kes ting e Korin, e Pol i mur a ngas bual pa i hanot to e Epeses, pa i pastek pas dingla na tarai a asaer tingia. ");
INSERT INTO lbb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pa i deken la mange, “Mangasa, a Talngan Tabu i kes omulo ning mulo tortorot?” Pa la kelesi mange, “Bel. Bel di atai mila ana Talngan Tabu.” ");
INSERT INTO lbb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pa i deken la mange, “Di baptais mulo on esi na ngas a baptais?” Pa la kelesi mange, “A baptais ane Jon.” ");
INSERT INTO lbb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pa e Pol i atongi mange, “E Jon i baptais ana baptais na lingir a nuknuk, pa i atai a tarai, sur lar tortorot o esaning ir hanot lamur tana. I e Iesu.” ");
INSERT INTO lbb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ning la ka longor tar a warwara ane Pol, di baptais la ana risana Leklek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ning e Pol i suah naur a kuna saot onla, a Talngan Tabu i kes onla, pa la warwara ana urmatana warwara, pa la warwara na propet. ");
INSERT INTO lbb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ngandek la takai a bonot pa pisir naur, pa la a taraila ka. ");
INSERT INTO lbb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","E Pol i sira kas uting na rumai lotu, i warwara pa bel i matmataut, pa i papak wakak ana matanitu ane God sur lar tortorot. I toli larning arlar ana natol a kalang. ");
INSERT INTO lbb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ika a balan dingla na tarai onla i rakrakai kol, pa bel la mang sur lar tortorot, pa la atong laulau a Ngas ane Karisito na matana taraila. Pa e Pol i han kusun la sur uting na rumai a asaer ane Tiranus. A tarai a asaer la muri pa la warwara taum ana pukakiarla ting na rumai ning. ");
INSERT INTO lbb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ana naur a rau i sira toli manglarning. Pa la rop, a tarai Juda pa tarai ning bel a tarai Juda, ning la kes ting na papar Esia, la longor a warwara anuna Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","E Pol i tol a maskan a ututnala na kulkulan ana rakrakai e God. ");
INSERT INTO lbb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pa tarai la los pas anunla na diah tawolla pa didiah kaenla otleng, la suah pasi ting na palaona e Pol, lamur la suahi ana tinsamanla pa la langolango, pa motla otleng la purum kusun la. ");
INSERT INTO lbb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Dingla na te Juda, la sira han taltal uting na hananuala, sur lar kepsen a motla kusun a tarai. Pa la tohoi sur lar kepsen otleng a motla taum ana risana e Iesu. La sira atongi mange, “A kepsen mulo ana risana e Iesu, ning e Pol i warawai onoi.” ");
INSERT INTO lbb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Mais a nat e Skewa a te Juda, a tnan tena artabar tetek e God, la toli larne. ");
INSERT INTO lbb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ning a pukakiar a mot i keles la mange, “A tasman ot e Iesu, pa a tasman otleng e Pol. Ika mulo, esila mulo?” ");
INSERT INTO lbb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pa barsan ning a mot i kas tar onoi, i sirok pas la, pa i um laulau la pa i silir anunla na kaen pa la dun mengere kama utumo lapiu. ");
INSERT INTO lbb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","A warwara ana utna ne, i hanot tetek a tarai Juda pa taraila ning bel a tarai Juda ning la kes to e Epeses, pa la matmataut rop, pa la hanrawai a risan a Leklek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","A galis onla ning la tortorot, la hanot pa la patuai ana laulau a gininla. ");
INSERT INTO lbb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Pa galis otleng onla ning la wah, la los taman pas anunla na buk a wah, pa la tun la na matana taraila. Ning la was taman a matana bukla, i arlar ot ana dilima na bonot a rip (50,000) a mani. ");
INSERT INTO lbb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","A warwara anuna Leklek i han sarara, pa i gomo ana rakrakai. ");
INSERT INTO lbb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ning a ututnala ne ka rop, e Pol i mang sur ir han usaot e Jerusalem, pa ir bolos ting na papar Masedonia pa papar Akaia. Pa i atongi mange, “Ning ia kar han pas saot e Jerusalem, ar han kale uto e Rom.” ");
INSERT INTO lbb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","I sune nigon e Timoti pa e Erastus utumo e Masedonia. Dia naur a halinla ning la sira nangani. Pa e Pol i kes kaba to na papar Esia. ");
INSERT INTO lbb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ana pukakiarla ning, a tnan mamahat i hanot, anasa a taraila bel la mang sur a Ngas anuna Leklek. ");
INSERT INTO lbb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ning a barsan a risana e Demitrius, a tena tol manar ana silwa. I toltol a nanatar a rumai lotu ane Artemis a hane na god, ana silwa. Pa titol ne i tol otnan a tnan mani ane Demitrius pa tarai a titol. ");
INSERT INTO lbb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","I ben taum pas anuna tarai a titol, pa dingla na tarai otleng ning anunla na titol i arlar, pa i atai la mange, “Taraila, mulo tasmani mang dala sira tol otnan a tnan mani miting na titol ne. ");
INSERT INTO lbb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Te e Epeses, pa ting na hananuala rop te na papar Esia, a barsan ne, e Pol, ka ben rongon pas a galis a tarai. I atai la mang a ututnala ne dala sira toli ana kundala, bel a godla. ");
INSERT INTO lbb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ning a utna ne ir hanot tetek dala, bel ir alaulau ka a wakak a risana nundala titol, lar nuk anatarna pas otleng a rumai lotu ane Artemis a hane na god, pa lar anatarna pas a risana. Anundala a god, ning onone a tarai Esia rop pa rakrakan hanua otleng la lotu teteki.” ");
INSERT INTO lbb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ning la longor a utna ne, la balakut kol, pa la warwara kol mange, “Artemis anuna tarai Epeses, i itna kol!” ");
INSERT INTO lbb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pa taraila rop miting na hanua ning la arsakai. La dun pa la tong akes pas e Gaius pa e Aristarkus, naur a te Masedonia ning ditol armuri ma e Pol, pa la kas taum ondiau uting na nunla tnan pukna na han taum. ");
INSERT INTO lbb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ning e Pol i mang sur ir kas tetek a tarai, a tarai a asaer la sairasi. ");
INSERT INTO lbb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pa dingla na ningnigo ana matanitu ting na papar Esia, a halalna e Pol, la saran a warwara teteki sur gong i kas uting na rumai a kiwung. ");
INSERT INTO lbb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pa nuknuk a kunum a tarai i loklokor. Dingla na tarai la atong ning a warwara ot, pa dingla otleng la atong maskana warwara, pa galis onla bel la tasmani mang asaning la hanot suri. ");
INSERT INTO lbb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","A tarai Juda la sugut otnan e Aleksanda tetek a kunum a tarai, pa la ben pasi usa lanigo. Pa dingla la atai i ana saning ir atongi. E Aleksanda i sairas la ana kuna, sur lar kes longoroi, pa i mang sur ir warwara alar i ot na matana tarai. ");
INSERT INTO lbb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ika ning a tarai Epeses la tasmani mang e Aleksanda a te Juda, bel la longor, la warwara kol ana naur a awa mange, “E Artemis anuna tarai Epeses, i leklek kol!” ");
INSERT INTO lbb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ning a tena tumtumus anuna hanua ning i sairas a tarai sur lar kes longoroi, i atai la mange, “A tarai Epeses, esi na hanua kane ning bel i tasmani mang a tarai mite e Epeses la tai alar a rumai lotu anuna tnan god Artemis, pa manarna otleng ning i punga purum misaot na langit? ");
INSERT INTO lbb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Bel tik ir puai ana ututnala ne, i wakak ning mulor kes longoroi pa gong mulo tol oros. ");
INSERT INTO lbb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mulo ka ben tar naur a barsan ne ute, ika bel dia kinkinau ting na rumai lotula, pa bel dia atong laulau anundala a hane na god. ");
INSERT INTO lbb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","A keskes a warkurai pa a tena warkuraila kanet. Ning e Demitrius pa tena titolla ning la armuri, la mang sur lar tiu tik on ta utna, lar atai a keskes a warkurai onoi. Pa la, lar atostos a warkurai onoi. ");
INSERT INTO lbb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ning ta utna kaning ot mulo mang sur mulor warwara ono, dir atostosi ot ting na kiwung na hanua. ");
INSERT INTO lbb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Sakana dir tiu dala ana mamahat ning i hanot ana pukakiar ne. Pa asa ma dalar atong alar dala ono? Anasa bel ta kamkamna.” ");
INSERT INTO lbb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ning ka atong tari larning, i sune sauran sen a taraila kusun a kiwung. ");
INSERT INTO lbb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ning a mamahat ning ka rop, e Pol i arsune pas a tarai a asaer, i wunan tar la, pa i artulai tanla, lamur i han utumo na papar Masedonia. ");
INSERT INTO lbb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ning ka han pas ting na hananuala ning, pa ka wunan tar la ana galis a wakak a warwara, i hanot tumo na papar Grik. ");
INSERT INTO lbb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","I kes tingia natol a kalang. Ning i sang sur ir kas ana sip utumo na papar Siria, i tasmani mang a te Judala la pinpidaiwol sur lar umkoli. Pa i nuki mang i wakak sur ir han potor ting na papar Masedonia ana nuna tinan ulak. ");
INSERT INTO lbb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pa e Sopater, a nat e Pirus, mitumo e Beria, pa e Aristarkus pa e Sekundus mitumo e Tesalonika, e Gaius mitumo e Derbe, pa e Tikikus pa e Tropimus mitumo e Esia, pa e Timoti otleng, la armuri taum oe Pol. ");
INSERT INTO lbb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","La ne la nigo utumo e Troas, pa la kes nanan mila tumo. ");
INSERT INTO lbb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ning ka rop a lotu na bret ning bel al is ono, mila han ana sip mito e Pilipai. Ning dilima na pukakiar ka rop, mila sot tumo e Troas tetek la ning la nigo kusun mila, pa mila kes pas mais a pukakiar tingia. ");
INSERT INTO lbb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ana ningnigo na pukakiar ana wik, mila kes taum sur milar hangan. E Pol i warwara tetek la, pa i dat abarah anuna warwara, tuk ana tnan morom, anasa i mang sur ir han kusun la ana pukakiar lamur. ");
INSERT INTO lbb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ting na tuka rumai tisaot ning mila kes taum ono a galis a lam kol tingia. ");
INSERT INTO lbb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ning a barman, a risana e Utikus, i kes saot na windo. Ning e Pol i warwara amon, a matana e Utikus i sulam kol, pa i borbor duman, pa i punga purum misaot na aretol a dek ana rumai ning, utumo na kabalapiu. Pa la los pasi, ka mat. ");
INSERT INTO lbb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","E Pol i purum, pa i borbor saot ono, pa i pos pasi, pa i atongi mang, “Gong mulo matmataut, ka laun.” ");
INSERT INTO lbb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Lamur e Pol i han kas ulak, i kibik pas a bret pa i hangan. I warwara bongnani ot tetek la, tuk ning a kamis i pusa ot, pa lamur i han kusun la. ");
INSERT INTO lbb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A tarai la han sarara taum oe Utikus, ka laun, pa la gas kol. ");
INSERT INTO lbb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Mila kas nigo ana sip utumo e Asos sur milar akas pas e Pol tumoia, lar i ot ka warkurai tari larning, anasa i mur a ngas. ");
INSERT INTO lbb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ning mila arsongo taum onoi tumo e Asos, mila akas pasi pa mila han utumo e Mitilini. ");
INSERT INTO lbb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ana pukakiar lamur mila han mitumo pa mila hanot milau ning a lolo, a risana e Kios. I kabakiar ulak, mila bolos e Samos, pa ana pukakiar lamur, mila sot to e Miletus. ");
INSERT INTO lbb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","E Pol ka warkurai tari mang ir bolos sen ka e Epeses, sur gong i molot to na papar Esia, anasa i mang sur ir han kapit usaot e Jerusalem. Ning i tolsot, i mang sur ir kes tisaot ana pukakiar a Pentikos. ");
INSERT INTO lbb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ning mila hanot ting na hanua Miletus, e Pol i arsune uto e Epeses sur a ningnigola anuna tarai a lotu sur lar lamut teteki. ");
INSERT INTO lbb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ning la hanot teteki, i atai la mange, “Mulo tasman ot a ngas a keskes anuki ana pukakiarla ning a kes napirimulo, turpasi ana ningnigo na pukakiar ning a bot hanot te na papar Esia. ");
INSERT INTO lbb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","A tarai Juda la warwara taum sur lar alaulau iau, pa kilang a mamahat onoi. Ika, a titol ot tetek a Leklek, a anatarna pas iau pa luru matak i punga. ");
INSERT INTO lbb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ning a warawai pa asaer mulo, na matana tarai pa ting na numulo na rumai, bel a matmataut pa bel a bunur ta utna ning ir nangan mulo. ");
INSERT INTO lbb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","A warawai tetek a taraila rop, a tarai Juda pa tarai masik otleng, sur lar lingir a nuknukinla tetek e God pa lar tortorot ana nundala Leklek e Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Pa onone a Talngan Tabu i angongos iau sur ar han usaot e Jerusalem, pa bel a tasman asaning ar pasteki tisaot. ");
INSERT INTO lbb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","A tasmani ka mang ting na hananuala rop, a Talngan Tabu i atai iau mang a karabus pa mamahatla la kes pas iau. ");
INSERT INTO lbb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ika bel a nuk pas anuk a lalaun, pa bel a maris alari. A saran tari ka sur ar tolsot pas anuk a tinan pa titol, ning a Leklek e Iesu i saran tari tak, sur ar warwara talapor ana Wakak a Warwara ana marmaris ane God. ");
INSERT INTO lbb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“A tasmani mang mulo rop, ning a han taltal tetek mulo ana warawai ana matanitu ane God, bel ma mulor oroi ulak a matak. ");
INSERT INTO lbb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Pa onone ar atai talapor mulo, ning ta halimulo ir hirua ana warkurai ane God, a sulukna bel ir tiu iau, ia ka langolango. ");
INSERT INTO lbb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Anasa, bel a matmataut pa bel a bunur ta utna ting na nuknuk e God, ning a warawai tetek mulo. ");
INSERT INTO lbb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Mulor tai alar wakak mulo ot, pa kunum a sipsip otleng ning a Talngan Tabu i saran tari tamulo sur mulor tai alar la. Mulor tai alar a tarai a lotu ane God, ning ka lou pas la ana sulukna ot. ");
INSERT INTO lbb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A tasmani mang, ning ar han kusun mulo, al tarai lar arlar ana ngalngaliah na papla, lar kas tetek mulo, pa lar alaulau a kunum a sipsipla. ");
INSERT INTO lbb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Pa al tarai otleng omulo lar turot, pa lar lingir a momolna, sur a tarai a lotu lar mur la. ");
INSERT INTO lbb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mulor tumarang mulo! Pa mulor nuk pas natol a rau ning a kes taum omulo. Bel a manah ana warwara na atumarang tetek mulo, ana moromla pa kabakiarla, pa luru matak i punga omulo. ");
INSERT INTO lbb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Onone a saran tar mulo tetek e God sur ir tai alar mulo, pa saran tar mulo ana nuna warwara ning i apuasa anuna marmaris. A warwara ning i tolsot sur ir arakrakai mulo, pa ir tabar mulo ana wakak a artabarla ning e God i sira tabar anuna totoh a tarai onoi. ");
INSERT INTO lbb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","A nuknukik bel i ram sur ta mani pa ta kaen anuna tik. ");
INSERT INTO lbb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mulo ot mulo tasmani mang a titol ot ana naur a kuk sur a ututnala ning i to pas iau, pa la otleng ning mila armuri. ");
INSERT INTO lbb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Iau ot a pas nigon mulo ana rakrakai a titol sur mulo otleng mulor sira toli larning, pa mulor nangan la ning bel al rakrakainla, pa mulor nuk pas a warwara ning a Leklek e Iesu ka atong tari mange, ‘La ning la artabar la angis tanla ning la kibas a utna.’” ");
INSERT INTO lbb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ning ka atong arop tar a warwara ne, e Pol taum ana taraila rop la kes ana bokona hanla, pa la araring. ");
INSERT INTO lbb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","La rop la tangis, pa la pos pas e Pol, pa la goro a ris a pahana. ");
INSERT INTO lbb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pa tarai la balmaris kol, anasa ka atai tar la mang bel ma lar tai taum ulak. Pa lamur la tur tulani sur ir kas ana sip. ");
INSERT INTO lbb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ning mila ka han kusun la, mila kas ana sip sur milar han tostos utumo na lolo Kos. Pa ana pukakiar lamur, mila han utumo na lolo Rodes, mitingia mila han utumo e Patara. ");
INSERT INTO lbb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pa mila pastek pas ning a sip tingia, ning ir han utumo na papar Ponisia. Mila kas ono, pa mila han. ");
INSERT INTO lbb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mila oroi a lolo Saiprus i kes ting na ris a kair imila, mila bolosi. Pa mila han utumo na papar Siria, pa mila sot tumo e Tair, sur a sip ir asirok a ututnala. ");
INSERT INTO lbb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ning mila pastek pas a tarai a asaer tingia mila kes pas mais a pukakiar taum onla. Pa Talngan Tabu i anuknuk la ana warwara mang, e Pol gong i han usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ika ning ka rop anumila na pukakiar na keskes tingia, mila ulak, pa tarai a asaer rop taum ana nunla na gurara pa na natnatunla la tur tulan mila miting na hanua utumo latasi. Lamur mila tur ana bokona hamila, pa mila araring. ");
INSERT INTO lbb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ning mila ka artulai tar, mila kas ana sip, pa la, la ulak sur uting na nunla na rumai. ");
INSERT INTO lbb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Mila han mitumo e Tair pa mila sot to e Tolemes, pa mila gas pas la ning la tas ana tortorot, pa mila kes taum onla ning a pukakiar. ");
INSERT INTO lbb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ana pukakiar lamur, mila han ulak, pa mila hanot to e Sisaria, pa mila kes ting na rumai ane Pilip, a tena warawai ana Wakak a Warwara, i ning a hala mais a barsan, ning a aposella la ka aslang pas la. ");
INSERT INTO lbb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A barsan ne, diat a natna hane, ning bel la taulai pa la sira warwara na propet. ");
INSERT INTO lbb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ning mila ka kes tingia a galis a pukakiar, ning a propet, a risana e Agabus, i hanot misaot na papar Judia. ");
INSERT INTO lbb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","I han tetek mila, i los pas a let ane Pol, pa i dot pas naur a hana pa naur a kuna ot ono, pa i atongi mange, “A Talngan Tabu i atongi mange, a tarai Juda saot e Jerusalem lar dot a barsan ning anuna let ne larotne a toli, pa lar sarani uting na kuna tarai ning bel a tarai Juda.” ");
INSERT INTO lbb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ning mila longor a warwara ne, mila taum ana tarai miting na hanua ning, mila sairas e Pol sur gong i han usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ika e Pol i keles la mange, “Sur asaning mulo domos, pa mulo abalmaris iau? Ia ka saran tar iau sur lar dot iau pa dir umkol iau otleng saot e Jerusalem, anasa ana risana Leklek e Iesu.” ");
INSERT INTO lbb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ning mila tol panai sur milar sairasi, mila noreni kama, pa mila atongi mange, “I wakak ning dir tolsot pas a nuknuk a Leklek.” ");
INSERT INTO lbb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pa lamur, mila sang pas, pa mila han usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Mila armuri taum ana tarai a asaer mitumo e Sisaria. La tulan tar mila tetek ning a barsan, a risana e Nason, a te Saiprus, sur milar kes napirna. I ning a hala tarai a asaer tagun nating. ");
INSERT INTO lbb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ning mila hanot saot e Jerusalem, na tastasimila ana tortorot la ben pas mila ana gasgas. ");
INSERT INTO lbb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ana pukakiar lamur, mila ma e Pol, mila han sur milar oroi e Jems. Pa ningnigola rop miting na lotu la kaning ma. ");
INSERT INTO lbb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ning e Pol ka warwara na gasgas pas la, i atai la ana taktakai utna ning ka tol tari ana rakrakai e God ana nuna titol tetek la ning bel a tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ning la longori, la rakan aleklek pas e God. La atai e Pol mange, “Tasimila, u tasmani mang a galis a rip ondala a tarai Juda, la ka tortorot, pa la rop la rakrakai sur lar mur a Warkuraila ane Moses. ");
INSERT INTO lbb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","La ka longor a asasongo na warwara hom, mang u asaer a tarai Juda rop ning la kes napir a tarai ning bel a tarai Juda, sur lar suah sen a Warkuraila ane Moses, pa u atai la otleng mang gong la kot talilis a natnatunla, pa gong la mur a toltolla ana lotu Juda. ");
INSERT INTO lbb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lar longori ot mang u ka hanot ute. Pa asa ma dalar toli? ");
INSERT INTO lbb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ur tol a utna ne mila atai u ono: Diat a barsan omila, la ka lele tar tetek e God. ");
INSERT INTO lbb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ur ben pas la, pa mulor atotoh pas mulo arlar ana warwara na warkurai, pa u, ur lou a ututnala na artabar ning lar artabar ono, sur dir bot kokor arop a hihinla. Ning ur toli larne, a taraila rop lar tasmani mang a warwarala ning la longori, bel i momol, pa u otleng u mur ot a warkurai. ");
INSERT INTO lbb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pa tetek a tena tortorotla miting onla ning bel a tarai Juda, dala ka tumtumus tar tetek la mange: Gong la ien ta utna ning di artabar ono tetek a asasongo na godla. Gong la ien ta utna ning bel di gos wakak sen a suluk kusuni, pa ta inagoi ning di pos koli ka, anasa a suluk kaning ot ono. Pa gong la tol a pamuk a toltol.” ");
INSERT INTO lbb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ana pukakiar lamur, e Pol i ben pas diat a barsan ning, pa la taum la atotoh la. E Pol i kas uting na rumai artabar, sur ir atong tar a pukakiar ning a titol na atotoh ir rop ono, pa dir tun otleng a artabar anunla taktakai. ");
INSERT INTO lbb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ning a mais a pukakiar na atotoh milau ir rarop, dingla na tarai Juda mitumo na papar Esia, la oroi e Pol ting na rumai artabar. Pa la angangas a tarai sur lar balakut e Pol pa la tong akesi. ");
INSERT INTO lbb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Pa la warwara kol mange, “A tarai Israel, mulor nangan mila. A barsan ne, i asaer a taraila rop te na rakrakan hanua sur lar nget dala, pa Warkuraila ane Moses, pa rumai artabar. Pa ka ben kas pas otleng a te Grikla ute na rumai artabar pa ka adur tar a rumai ning e God i atotoh tari sur anunai. ” ");
INSERT INTO lbb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","La atongi larne anasa nating, la ka oroi tar diau ma e Tropimus, a te Epeses, tumo na hanua, pa la nuki mang e Pol i ben kas pasi uting na rumai artabar. ");
INSERT INTO lbb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","A taraila rop la arlak pa la dun taum, la tong akes pas e Pol, pa la dat purum pasi kusun a rumai artabar, pa la tagar kapit a tamanla. ");
INSERT INTO lbb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ning la mang sur lar umkoli, a warwara i kibas a tnan ningnigo anuna tarai a harum mitumo e Rom, mang a tarai Jerusalem rop la arlak pa la tol a tnan mamahat. ");
INSERT INTO lbb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","I ben taum kapit pas a tarai a harum pa nunla ningnigola, pa la dun purum tetek la. Ning a tarai la oroi a tnan ningnigo pa tarai a harum, la manah ana um e Pol. ");
INSERT INTO lbb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","A tnan ningnigo i han tetek e Pol, pa i tong akes pasi, pa i arsune sur dir dot akesi ana naur a sen. Pa i deken la mange, “Esi na barsan ne? Asaning i tol rongon tari?” ");
INSERT INTO lbb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Dingla na tarai miting na kunum, la atong ning a warwara, pa dingla otleng la atong ning a warwara masik. A tnan ningnigo bel i kibas sot pas a momolna, anasa ana tnan arlak, pa i arsune sur dir ben e Pol uting na rumai anuna tarai a harum. ");
INSERT INTO lbb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ning e Pol i hanot ting na leta na rumai, a tarai a harum la losi, anasa a kunum a tarai la ngalngaliah kol. ");
INSERT INTO lbb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pa kunum a tarai ning la mur la, bel la manah na arkabah mange, “Sai koli!” ");
INSERT INTO lbb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ning la mang sur lar kas taum oe Pol uting na rumai anuna tarai a harum, i deken a tnan ningnigo mange, “I wakak ka ning ar atong ta utna tam?” Pa tnan ningnigo i dekeni mang, “Ai, u tasman ot a warwara Grik? ");
INSERT INTO lbb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","A nuki mang u a te Ijip, esaning nating i akamtur a harum taum ana matanitu, pa i ben diat a rip a tena tol arlak usaot na hanua bel.” ");
INSERT INTO lbb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pa e Pol i kelesi mange, “Iau a te Juda mitumo e Taso, ting na papar Silisia, iau bel miting na ta hanua oros ka. Lak, ur malmaling sen iau, sur ar awara a taraila ne.” ");
INSERT INTO lbb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ning a tnan ningnigo ka malmaling tar e Pol, i tur ting na leta na rumai, pa i sairas la ana kuna. Ning la tur longoroi, i atai la ana warwara Hibru mange, ");
INSERT INTO lbb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Na tastasik, pa na tamtamang mulor longor a warwara ning ar atalapor iau ono.” ");
INSERT INTO lbb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ning la longori ning i warwara ana warwara Hibru tetek la, la rop la tur longoroi. Pa i atongi mange, ");
INSERT INTO lbb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Iau a te Juda, di agon iau tumo e Taso ting na papar Silisia. A barman tar ot te e Jerusalem, pa iau a kaklik a asaer ot ane Gamaliel, pa i asaer wakak iau ana Warkuraila anuna tumtubundala, pa titol rakrakai tetek e God larotne mulo toli. ");
INSERT INTO lbb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pa alaulau a tarai ning la mur a Ngas ane Karisito. A umkol dingla na tarai, pa dat pas dingla na tarai pa dingla na gurara otleng, pa akas la uting na karabus. ");
INSERT INTO lbb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","A ningnigo na tena artabar tetek e God pa tarai a kiwung rop la talapor ana utna ne sur lar warwara talapor ono, pa los pas a bukla kusun la ning la tumusi tetek na tastasinla a te Judala tumo e Demaskas. Manglarning ia ka han pas uto, sur ar tong akes pas a taraila, pa ar dot akes la, pa ar ben la, sur dir alaulau la saot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ning a han milau e Demaskas, ana tnan kamis, a tnan talapor misaot na langit i hanot kulkulan pa i pil talilis pas iau. ");
INSERT INTO lbb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","A punga purum ting lapiu, pa a longor a elngena mainla i atai iau mange, ‘Sol, Sol, sur asa u alaulau iau?’ ");
INSERT INTO lbb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Pa dekeni mange, ‘Leklek, esi u?’ Pa i keles iau mange, ‘Iau e Iesu, a te Nasaret, ning u alaulau iau.’ ");
INSERT INTO lbb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Pa tarai ning mila armuri, la oroi a talapor, ika bel la longor a elngena mainla ning i warwara tetek iau. ");
INSERT INTO lbb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Pa dekeni, ‘Leklek, asaning ar toli?’ Pa Leklek i keles iau mange, ‘Ur tur pa ur han utumo e Demaskas, pa dir atai u ana ututnala ning di ka aslang tari sur ur toli.’ ");
INSERT INTO lbb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","La ning mila armuri la tong benben otnan iau utumo e Demaskas, anasa a matak i kut ana rakrakai a talapor. ");
INSERT INTO lbb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ning a barsan, a risana e Ananias, a tena lotu momol ning i sira mur asot a Warkuraila, pa tarai Juda rop ning la kes tingia, la hanrawai koli. I hanot tetek iau, ");
INSERT INTO lbb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","pa i tur milau iau, i atongi mange, ‘Sol, a tasiklik, ur tai ulak.’ Pa ono otning, a matak i tapalas pa a oroi e Ananias. ");
INSERT INTO lbb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Pa e Ananias i atai iau mange, ‘E God anuna tumtubundala nating ka aslang tar u, sur ur tasman a nuknukna, pa ur oroi a Tena Tostos, pa ur longor anuna warwara miting na pahana. ");
INSERT INTO lbb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Pa ur tena warwara talapor anunai tetek a taraila rop ana ututnala ne ning u ka oroi tari pa u ka longor tari. ");
INSERT INTO lbb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","U kes pas asa? Ur tur, pa dir baptais u, pa ur araring ana risana, sur dir kepsen anum na toltol laulau.’ ");
INSERT INTO lbb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","“Ning a ulak usaot e Jerusalem, pa araring ting na rumai artabar, a oroi a Leklek ana tatatai, i atai iau mange, ‘Tur kapit! Ur han kapit mite e Jerusalem, anasa bel lar kibas anum a warwara talapor hok.’ ");
INSERT INTO lbb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Pa kelesi mange, ‘Leklek, la tasmani mang a sira kas uting na rumai lotula rop, pa akas la ning la tortorot hom uting na karabus, pa dapis la. ");
INSERT INTO lbb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pa ning di umkol e Stiwen, esaning i warwara talapor hom, iau otleng a tur tingia, a malmaling taum onla, pa tai alar a kaenla anunla ning la umkoli.’ ");
INSERT INTO lbb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pa Leklek i atai iau mange, ‘Ur han, ar sune bakbak u tetek a tarai ning bel a tarai Juda.’” ");
INSERT INTO lbb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","A tarai la longor a warwara ane Pol tuk ot ana warwara ne. Lamur la kukuk ana tnan elngenla mange, “A barsan ne ir rarop mite na rakrakan hanua, bel i tostos sur ir laun.” ");
INSERT INTO lbb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ning la kukuk larne, la kepsen anunla na kaen ning la polpol alar anunla na mermer ono, pa la migen sarara a kubus usaot. ");
INSERT INTO lbb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Pa tnan ningnigo i arsune sur dir ben e Pol uting na rumai anuna tena harumla, pa dir dapisi pa dir dekeni sur dir tasman asa a kamkamna ning a tarai la kukuk larne ono. ");
INSERT INTO lbb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ning la dot tari taum ana senla, sur lar dapisi, e Pol i atai a ningnigo anuna tena harumla ning i tur milau mang, “Mangasa, i tostos ka ning mulor dapis ta te Rom, ning belot di warkurai i?” ");
INSERT INTO lbb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ning a ningnigo anuna tarai a harum i longori, i han tetek anuna ningnigo, pa i atai i mange, “Asaning u mang sur ur toli? A barsan ne a te Rom.” ");
INSERT INTO lbb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","A tnan ningnigo i han tetek e Pol pa i dekeni mange, “Atai iau. U a te Rom?” Pa i kelesi mange, “Momol. Iau a te Rom.” ");
INSERT INTO lbb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Pa tnan ningnigo i atai i mange, “Iau a arlou ana tnan mani sur ar hanot a te Rom.” Pa e Pol i kelesi mange, “Ika iau, di agon iau ot a te Rom.” ");
INSERT INTO lbb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pa la ning la mang sur lar dekeni, la tur sarara kapit kusuni. Ning a tnan ningnigo i tasmani mang e Pol a te Rom, i matmataut, anasa ka dot tari ana sen. ");
INSERT INTO lbb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ana pukakiar lamur, ning a tnan ningnigo i mang sur ir tasman wakak asaning a tarai Juda la tiu e Pol onoi, i pak sen a sen, pa i arsune sur a leklek a tena artabarla tetek e God, pa tarai a kiwung rop sur lar han taum. Pa i ben purum pas e Pol, pa i aturi na matanla. ");
INSERT INTO lbb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","E Pol i tai tostos sur a tarai a kiwung, pa i atai la mange, “Na tastasik, anuk a lalaun ka tostos na matana e God, pa balak bel i tiu iau ana ta utna.” ");
INSERT INTO lbb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pa e Ananias a ningnigo na tena artabar tetek e God, i sune la ning la tur milau e Pol sur lar pasar a pahana. ");
INSERT INTO lbb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pa e Pol i atai i mange, “E God ir pasar u, u arlar ana ris a rumai ning di sabar tari ana kokok, ika tingui i laulau kol. U kes sur ur warkurai iau arlar ana Warkuraila, ika u kutus a Warkuraila ning u arsune sur dir pasar iau.” ");
INSERT INTO lbb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","La ning la tur milau i la atongi mange, “Mangasa, u asa u, sur ur atong laulau a ningnigo na tena artabar tetek e God?” ");
INSERT INTO lbb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","E Pol i keles la mange, “Na tastasik, bel a tasmani mang ai a ningnigo na tena artabar tetek e God. Ning ar tasmani, bel ar toli larning, anasa di ka tumus tari ting na Buk Tabu mange, ‘Gong u atong laulau ta ningnigo ana num a taraila.’” ");
INSERT INTO lbb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ning e Pol i tasmani mang dingla na tarai tagun la, a Sadusila, pa dingla otleng a Parisaiola, i kukuk ting na kiwung mange, “Na tastasik, iau a Parisaio, pa nat a Parisaio, onone di tiu iau kamna ana nuk a tortorot ana lalaun ulak kusun a minat.” ");
INSERT INTO lbb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ning ka atong tari larning, a Parisaiola pa Sadusila la turpas a arlak, pa kiwung i taptapagal. ");
INSERT INTO lbb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Anasa a Sadusila bel la tortorot ana lalaun ulak kusun a minat, pa angelola, pa motla, ika a Parisaiola la tortorot onditol rop. ");
INSERT INTO lbb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pa la turpas a tnan arbalakut, pa dingla na Parisaio, la ning a tena asaerla tagun a warkurai, la tur, pa la arlak kol, pa la atongi mange, “Bel mila pastek ta laulau a utna ning a barsan ne i rongo ono. Sakana ta mot, o ta angelo kar awarwara tari.” ");
INSERT INTO lbb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ning a arlak ka itna pa la turpas a harum, a tnan ningnigo anuna tena harumla i matmataut, sakana lar dat kakahal e Pol. I sune a tarai a harum, sur lar han pa lar dat pasi kusun a taraila, pa lar beni usaot na rumai anuna tarai a harum. ");
INSERT INTO lbb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ana morom ning, a Leklek i hanot tetek e Pol, pa i atai i mange, “Gong u matmataut, ur tur rakrakai. U ka warwara talapor tar hok te e Jerusalem, mangotleng larning ur warwara talapor hok tumo e Rom.” ");
INSERT INTO lbb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Ana kabakiar kobot ulak, dingla na te Judala, i arlar ona diat a bonot pa i apapisir, ning la warwara taum sur lar lele, mang bel lar hangan, pa bel lar gang, tuk ot ning lar umkol tar e Pol. ");
INSERT INTO lbb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","La han tetek a leklek a tena artabarla tetek e God, pa ningnigola miting na lotu, pa la atongi mange, “Mila ka lele tar mang bel milar ien ta utna tuk ot ning milar umkol tar e Pol. ");
INSERT INTO lbb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mila mang sur mulo pa tarai a kiwung, mulor saran a warwara tetek a tnan ningnigo anuna tena harumla pa mulor asongo pas e Pol kusuni, sur ir sune i tetek mulo. Mulor atongi mang mulo mang sur mulor longor ta warwara talapor ulak tana. Pa mila ka sang sur milar umkoli ting na ngas ning belot ir hanot tetek mulo.” ");
INSERT INTO lbb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ning a etna ane Pol i longor a pinpidaiwol ne, i han uting na rumai anuna tena harumla, pa i atai e Pol ono. ");
INSERT INTO lbb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pa e Pol i kabah pas ning a ningnigo ana tena harumla, pa i atai i mange, “Ur ben a barman ne tetek anumulo a tnan ningnigo, anasa i mang sur ir atai i ana ning a warwara.” ");
INSERT INTO lbb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Pa i beni tetek a tnan ningnigo, pa i atai i mange, “E Pol, ning i karabus, i arsune sur iau, pa i nunung iau sur ar ben tar a barman ne tetek u, anasa i mang sur ir atai u ana ning a warwara.” ");
INSERT INTO lbb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","A tnan ningnigo i tong pas a kuna pa i ben masik pasi, pa i dekeni mange, “Asaning u mang ur atai iau ono?” ");
INSERT INTO lbb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Pa i atongi mange, “A tarai Juda la ka pinpidaiwol pas sur lar asongo pas e Pol kusun u, sur ur tulani latu tetek a tarai a kiwung, sur lar longor ta warwara talapor ulak tana. ");
INSERT INTO lbb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Gong u longor tanla, anasa diat a bonot pa i apapisir, la mumun suri. La ka lele tar mang, bel lar hangan pa bel lar gang, tuk ot ning lar umkol tar e Pol. Pa la harnanai kama sur ur malmaling.” ");
INSERT INTO lbb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Pa tnan ningnigo i atumarangi mang, “Gong u atai tar tik mang u ka atai tar iau ana utna ne.” Pa lamur i sune seni. ");
INSERT INTO lbb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","A tnan ningnigo anuna tena harumla, i kabah pas naur a ningnigo teteki pa i atai diau mange, “Mur sang naur a mar a tena harum, pa mais a bonot a tena harum ning la kas ana hosla, pa naur a mar a tena harum ning la los a turaila, pa mulor han ana 9 kilok onone na morom uto e Sisaria. ");
INSERT INTO lbb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mur ben ir naur a hos, sur e Pol ir han ono. Mulor tai alar wakaki tuk mulor hanot onoi tetek e Feliks, a tnan ningnigo ana matanitu.” ");
INSERT INTO lbb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Pa i tumus a pas teteki mange: ");
INSERT INTO lbb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Iau e Klodius Lisia, a tumtumus tetek u Feliks, a tnan ningnigo ana matanitu. A marmaris tetek u. ");
INSERT INTO lbb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","A barsan ne a sune i tetek u, a tarai Juda la tong akes pasi, pa milau lar umkoli. Ika mila ma na tena harum, mila hanot, pa mila alaun pasi, anasa ia ka tasman tari mang ai a te Rom. ");
INSERT INTO lbb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Pa mang sur ar tasman asaning di tiwi ono, pa ben tari uting na nunla kiwung. ");
INSERT INTO lbb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Onone a talapor onoi mang di tiu orosi ka ana toltol ana warkuraila miting na nunla na lotu, ika bel i tol ta laulau a utna sur ir karabus ono, pa dir umkoli ono. ");
INSERT INTO lbb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ning di atai iau ana pinpidaiwol sur a barsan ne mang lar umkoli, a sune kapiti tetek u. Pa atai la ning la tiwi, sur lar atalapor anunla na artitiu tetek u. Ai ka i ning. Ka rop. ");
INSERT INTO lbb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Pa tarai a harum la ben pas e Pol ana morom uto e Antipatris, larning di atai tar la. ");
INSERT INTO lbb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ana pukakiar lamur, a tarai a harum ning la kas ana hosla, la bolos taum oe Pol, pa tarai a harum otleng la ulak usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ning la hanot ting e Sisaria, la saran tar a pas tetek e Feliks, a tnan ningnigo miting na matanitu, pa la saran tar e Pol uting na kuna. ");
INSERT INTO lbb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ning e Feliks ka was tar a pas, i deken e Pol mange, “U miting na si na papar?” Pa ning ka tasman tari mang e Pol a te Silisia, ");
INSERT INTO lbb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","i atai i mange, “Ning a tarai a artitiu lar hanot ute, ar longor a utna ning lar tiu u ono.” Pa i arsune sur dir tai alari ting na rumai ane Herot. ");
INSERT INTO lbb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Dilima na pukakiar lamur, e Ananias, a ningnigo na tena artabar tetek e God pa dingla na ningnigola miting na lotu, pa e Tertulus, a tena tastasmai ana Warkuraila, la hanot tumo e Sisaria, pa la atalapor anunla a warwara na artitiu oe Pol tetek e Feliks a tnan ningnigo ana matanitu. ");
INSERT INTO lbb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ning di ka kabah pas e Pol, e Tertulus i turpas a warwara teteki mange, “Feliks, u leklek kol. Mila kes bongnan mila ana balmolmol nahai a warkurai anumi. A galis a utna i hanot ting na nundala papar anasa anum a tai alar i wakak kol. ");
INSERT INTO lbb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mila taum ana tarai miting na hananuala rop, mila gas ana num a warkuraila pa mila atong wakak kol tetek u ono. ");
INSERT INTO lbb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Pa bel ar angoro u anal warwara. A nunung u sur ur maris mila pa ur longor anumila al siklik warwara. ");
INSERT INTO lbb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Mila oroi a barsan ne a tena tol arsakai, pa i akamtur a arsakai na arpotor a tarai Juda te na rakrakan hanua rop. Pa ai a ningnigo ana asasongo na lotu di atongi mang a lotu Nasaret. ");
INSERT INTO lbb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Pa i mang sur ir tol adur a rumai artabar sur ir dur na matana e God. Ika mila tong akes pasi. Ning u ot ur dekeni, ur tasman a momolna ana saning mila tiwi ono.” ");
INSERT INTO lbb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ning e Tertulus ka warwara rop, dingla na tarai Juda otleng la arnangai ana artitiu, la atongi mang i momol ot a artitiula ne. ");
INSERT INTO lbb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ning e Feliks, a tnan ningnigo ana matanitu, i amaler a pukulna tetek e Pol sur ir warwara, e Pol i atai i mange, “A gas ning ar atalapor iau kusun u, anasa a tasmani mang u ka warkurai a galis a rau sur a papar ne. ");
INSERT INTO lbb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ning ur deke, ur tasmani mang ning a bonot pa pisir naur a pukakiar alar tari ka, a hanot saot e Jerusalem, sur ar lotu. ");
INSERT INTO lbb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Pa bel la oroi tar tik ning mia arlak taum ting na rumai artabar, pa bel la oroi tar iau otleng mang a akamtur ta arsakai ting na rumai lotula, pa ting na tinine hanua. ");
INSERT INTO lbb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Pa bel lar amomol sot pas anunla na artitiu tetek u ana saning la tiu iau ono. ");
INSERT INTO lbb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Ar atai talapor u mang, iau a mur a Ngas ane Karisito, ning la atongi ana asasongo na lotu. Ika ana lotu ne, a lotu ot tetek a God anuna tumtubumila tagun nating, pa tortorot ana ututnala rop ning di ka tumus tari ting na Warkuraila pa ting na bukla anuna propetla. ");
INSERT INTO lbb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Anuk a tortorot oe God i arlar ana tarai ne. Iau otleng a harnanai ana tortorot mang e God ir akamtur ulak pas a wakak a tarai pa laulau a tarai kusun a minat. ");
INSERT INTO lbb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ine a kamkamna ning a sira rakrakai sur anuk a lalaun ir kes talapor na matana e God, pa na matana taraila otleng. ");
INSERT INTO lbb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“A galis a rau bel a kes saot e Jerusalem, pa lamur a ulak usaot sur ar abaran a mani na artabar tetek a kapan a taraila, pa ar saran otleng a artabarla ning dir tuni sur a artabar tetek e God. ");
INSERT INTO lbb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Lanigo ning belot a kas uting na woroh na rumai artabar ia ka tol arop tar a warkuraila sur ar totoh na matana e God. Ning a kas sur ar tol a titol a artabar, bel la pastetek iau taum ana galis a tarai, pa bel a arsakai taum ana tik. ");
INSERT INTO lbb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ika dingla na tarai Juda mitumo na papar Esia la kes tingia ana pukakiar ning la tong akes pas iau. Ning ta utna lar tiu iau ono, i wakak sur la ot lar han ute pa lar tiu iau na matam. ");
INSERT INTO lbb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Pa i wakak sur la ning kane, lar warwara talapor anal laulau a utna ning la pasteteki hok, ning a tur na matana tarai a kiwung saot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ngandek la tiu iau ana ning a warwara ka. Ning a tur na matanla, a warwara kol mange, ‘A tur ana warkurai na matamulo onone, anasa a tortorot ana lalaun ulak kusun a minat.’” ");
INSERT INTO lbb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","E Feliks i talapor wakak ot ana lotu ning di atongi a Ngas ane Karisito, pa i amanah tar kaba a warkurai, pa i atongi mange, “Ning e Lisia, a tnan ningnigo anuna tarai a harum ir hanot, ar bot suah ta warkurai a artitiu ne.” ");
INSERT INTO lbb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pa i atai a ningnigo anuna tena harumla mange, “E Pol ir kes na karabus ana num a warkurai. Ur noreni, pa gong u sairas na halalnala ning lar nangani.” ");
INSERT INTO lbb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Dingla na pukakiar lamur, e Feliks i hanot ulak taum ana nuna hane e Darusila, a hane Juda. I arsune sur e Pol, pa i longor anuna warwara ana tortorot oe Karisito Iesu. ");
INSERT INTO lbb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ning e Pol i warwara ana tostos a toltol, pa a toltol ning tik ir warkurai tostos pas anuna lalaun, pa pukakiar a warkurai ning ir hanot, e Feliks i matmataut, pa i atongi mange, “Pol, ur han kaba. Ning ar langolango, ar arsune ulak sur u.” ");
INSERT INTO lbb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pa i mang otleng sur e Pol ir bing kuna on ta mani, sur ir pak seni. Pa i tikai arsune ot suri, pa dia warwara taum. ");
INSERT INTO lbb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ning naur a rau ka rop, e Porsius Festus i keles e Feliks. Ika e Feliks belot i pak sen e Pol, anasa i mang sur ir agasgas a tarai Juda. ");
INSERT INTO lbb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ning ka natol a pukakiar alar a tinan ot ane Festus ting na hanua Sisaria ting na papar ning ir warkurai i, i han usaot e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Pa leklek a tena artabarla tetek e God pa ningnigola anuna tarai Juda, la hanot teteki pa la warwara na artitiu oe Pol. ");
INSERT INTO lbb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Pa la nunung e Festus sur ir longor tanla, pa la atai i mange, “Ur maris mila pa ur sune e Pol ute e Jerusalem.” Anasa la ka pinpidaiwol pas sur lar umkoli na arpotor ana nuna tinan. ");
INSERT INTO lbb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pa e Festus i keles la mange, “E Pol i karabus ot tumo e Sisaria, pa iau otleng ka milau sur ar ulak utumo. ");
INSERT INTO lbb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","I wakak ning al ningnigo omulo lar han taum hok utumo, pa ning ta utna a barsan ne i rongo ono, mulor tiwi ono tumo.” ");
INSERT INTO lbb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ning e Festus ka kes taum pas onla ngandek siwal o ning a bonot a pukakiar, i ulak utumo e Sisaria. Pa ana pukakiar lamur tana, i turpas a warkurai, pa i arsune sur dir ben e Pol teteki. ");
INSERT INTO lbb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ning e Pol i hanot, a tarai Juda misaot e Jerusalem la tur talilis pasi, pa la tiwi ana galis a rakrakai a warwara na artitiu, ika bel la atong pas ta utna ning ir amomol tari. ");
INSERT INTO lbb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pa e Pol i atalapori mange, “Bel a tol ta rongo ana warkurai anuna tarai Juda, pa ana rumai artabar, pa tetek a Sisar.” ");
INSERT INTO lbb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","E Festus i mang sur ir agasgas pas a tarai Juda, pa i deken e Pol mange, “Mangasa, ur malmaling ka sur ur han usaot e Jerusalem, sur ar warkurai u ana artitiula ne tisaot?” ");
INSERT INTO lbb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pa e Pol i kelesi mange, “Onone a tur ana warkurai ana Sisar, pa i tostos ning dir warkurai iau ot te. Bel a tol ta rongo tetek a tarai Juda, pa u otleng u tasmani. ");
INSERT INTO lbb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ning ia ka tol ta laulauna ning i arlar sur ar hirua ono, i wakak ka ning ar hirua. Ika ning a warwara na artitiu ne la tiu iau onoi bel i momol, bel i tostos sur tik ir saran tar iau tetek la. A nunung sur a Sisar ot ir longor a warkurai hok.” ");
INSERT INTO lbb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ning e Festus ka warwara taum tar ana nuna tena arnangai na warwara, i atongi mang, “U ka nunung sur ur han tetek a Sisar, par sune sen u uto e Rom tetek a Sisar.” ");
INSERT INTO lbb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Dingla na pukakiar lamur, King Agripa ditas ma e Bernaisi a hane, dia hanot tumo e Sisaria, sur diar saran a hanrawai tetek e Festus ana nuna keskes na ningnigo. ");
INSERT INTO lbb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ning dia ka kes a galis a pukakiar tingia, e Festus i atai a king oe Pol, pa i atongi mange, “E Feliks ka manah kusun anuna titol, ika i noren tar ning a barsan kanet na karabus. ");
INSERT INTO lbb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Pa ning a han usaot e Jerusalem, a leklek na tena artabar tetek e God pa ningnigola anuna tarai Juda la atai iau ana warwara na artitiu onoi, pa la nunung iau sur ar warkurai i sur dir umkoli. ");
INSERT INTO lbb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Pa a atai la mange, ‘Bel a toltol anuna tarai Rom mang dir saran tar ta barsan sur dir warkurai i sur ir mat, ning belot i tur na matan la ning la tiwi, sur ir atalapori ana nunla na artitiula.’ ");
INSERT INTO lbb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Ning mila hanot taum te, bel a harnanai sur ar longor a warkurai. A pukakiar lamur ka tana, a tol a warkurai, pa arsune sur dir ben pas a barsan ning. ");
INSERT INTO lbb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ning a tarai a artitiu la tur sur lar warwara, bel la tiwi ana ta laulau a utna larning a nuki. ");
INSERT INTO lbb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ika la tiwi ana ututnala ana lotu anunla, pa ana ning a barsan ning ka mat, a risana e Iesu, ning e Pol i atongi mang ka laun ulak. ");
INSERT INTO lbb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Bel a tasmani mang ar tikin mangmangasa a ututnala ne. A nunungi sur ir han usaot e Jerusalem pa dir warkurai i ana warwara na artitiu tisaot. ");
INSERT INTO lbb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ika, ning e Pol i nunung sur a Sisar ir warkurai i, a arsune sur ir kes kaba ting na karabus, tuk ning ar tulani utumo e Rom tetek a Sisar.” ");
INSERT INTO lbb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Lamur e Agripa i atai e Festus mange, “Iau ot, a mang sur ar longor a barsan ne.” E Festus i kelesi mange, “Latu ur longori.” ");
INSERT INTO lbb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ana pukakiar lamur, e Agripa pa e Bernaisi dia hanot pa di amermer diau ana urmatana minmar anuna leklek a tarai. Pa diau taum ana ningnigola anuna tarai a harum, pa dingla na ningnigola miting na hanua ning, la kas uting na rumai a kiwung. E Festus i arsune sur e Pol, pa di ben pasi. ");
INSERT INTO lbb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pa e Festus i atongi mange, “King Agripa, pa mulo otleng a tarai ning dala keskes taum te, mulo oroi a barsan ne. A tarai Juda rop saot e Jerusalem pa te Sisaria otleng, la nunung iau sur ar warkurai i, pa la kukuk mang bel ma i tostos sur ir laun. ");
INSERT INTO lbb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ika bel a pastek pas ta utna ning dir umkoli ono. Pa ning i nunung sur a Sisar ir warkurai i, a nuki mang ar sune i utumo e Rom. ");
INSERT INTO lbb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bel a tasman ta momolna ning ar tumus akesi onoi tetek a Sisar. I maining a ben otnani tetek mulo rop pa tetek u, King Agripa, sur dalar deken tari sur ar tasman asaning ar tumusi. ");
INSERT INTO lbb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Anasa a nuki mang bel i sot sur ar sune tik ning i karabus tetek a Sisar, pa bel di tumus akes asaning di tiwi ono.” ");
INSERT INTO lbb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","E Agripa i atai e Pol mange, “A malmaling sur u ot ur warwara talapor hom.” Pa e Pol i kodos kas a kuna pa i turpasi sur ir atalapori mange, ");
INSERT INTO lbb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“King Agripa, a angis kol sur ar tur te lanigo tam, par atalapor iau ana ututnala rop ning a tarai Juda la tiu iau onoi. ");
INSERT INTO lbb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Anasa u tasman wakak a toltol anuna tarai Juda pa utna otleng ning la arlak ono. Mang larning, a nunung u sur ur kes longoroi pa ur longor iau. ");
INSERT INTO lbb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“A tarai Juda rop la tasman anuk a ngas a lalaun turpasi ot ning a kaklik, ting na nuk a hanua, pa saot otleng e Jerusalem. ");
INSERT INTO lbb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","La tasman iau tagun nating, ning la mang, lar warwara talapor mang a mur ot a toltolla anuna Parisaiola. Mila ning a kunum miting na tarai Juda ning mila mur sot pas a Warkuraila ana numila lotu. ");
INSERT INTO lbb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Pa onone a tur ana warkurai anasa a tortorot ana lele ning e God ka tol tari tetek na tumtubumila tagun nating. ");
INSERT INTO lbb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Anumila ning a bonot pa pisir naur a mangis a tarai la harnanai ana tortorot sur dir tolsot pas a lele ning tetek la, pa la lotlotu tetek e God ana kabakiarla pa ana moromla rop. King, a tarai Juda la tiu iau, anasa a tortorot ana lele ning. ");
INSERT INTO lbb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Sur asaning tik ta halimulo i nuki mang e God bel i tolsot sur ir akamtur ulak a minatla? ");
INSERT INTO lbb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Iau otleng, nating a nuki mang i wakak ning ar toh arop tar a rakrakai a ngasla sur ar sairas a taraila mang gong la tortorot ana risana e Iesu, a te Nasaret. ");
INSERT INTO lbb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Pa tol a titolla ne saot e Jerusalem. Ana malmaling anuna leklek a tena artabarla tetek e God, a han pa akas a galis a tena tortorot ting na karabus. Pa ning di umkol la, iau otleng, a malmaling sur lar mat. ");
INSERT INTO lbb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","A galis a taim a kas ting na rumai lotula sur ar alaulau la, pa angongos la sur lar warwara laulau oe Iesu. A sira balakut rakrakai tetek la, pa han otleng ting na dingla na hananuala masik, sur ar tai pas la par alaulau la. ");
INSERT INTO lbb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ona ning a tinan anuki, a han ulak utumo e Demaskas ana malmaling pa arsune anuna leklek a tena artabarla tetek e God. ");
INSERT INTO lbb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","King, ning a kamis i kes tostos, a han ting na ngas pa a oroi a tnan talapor misaot na langit, i tapgar kol tana talapor a kamis, pa i sasai talilis iau taum onla ning mila armuri. ");
INSERT INTO lbb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Mila rop mila punga purum uting lapiu, pa a longor a elngen takai i warwara tetek iau ana warwara Hibru mange, ‘Sol, Sol, sur asa u alaulau iau? U ot u alaulau pas u ana mamahatla ning u toli hok.’ ");
INSERT INTO lbb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Pa deke mange, ‘Leklek, esi u?’ Pa Leklek i keles iau mange, ‘Iau e Iesu, ning u alaulau iau. ");
INSERT INTO lbb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ur kamtur. A hanot tetek u, anasa a aslang pas u, sur ur tol anuk a titol pa ur warwara talapor ana ututnala, ning u ka oroi tari tak, pa ututnala otleng ning ar asangani tam. ");
INSERT INTO lbb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Par alaun u kusun anum a tarai, pa tarai otleng ning bel a tarai Juda, la ning ar sune u tetek la. ");
INSERT INTO lbb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ur apalpalas a matanla sur lar talingir kusun a mormorom sur a talapor, pa kusun a rakrakai ane Satan tetek e God, sur dir kepsen anunla na toltol laulau, pa lar kes taum onla ning a aslang pas la sur anuk a tostos a tarai, la ning la tortorot hok.’ ");
INSERT INTO lbb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“King Agripa, bel a longor orsan a tatatai ne misaot na langit. ");
INSERT INTO lbb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","A warawai nigo tumo e Demaskas pa e Jerusalem pa ting na hananuala ting na papar Judia rop, pa lamur tetek la ning bel a tarai Juda, mang lar lingir a nuknukinla, pa lar talingir tetek e God, pa lar tol a titolla, sur ir asangani mang la ka lingir a nuknukinla. ");
INSERT INTO lbb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ine a kamkamna ning a tarai Juda la tong akes pas iau ting na woroh na rumai artabar, pa la tohi sur lar umkol iau. ");
INSERT INTO lbb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ika, tuk onone, e God i nangan iau pa tur te na matam pa warwara talapor tetek la ning bel al risanla pa la ning la leklek. Bel a atong ta tona utna, a warwara ka ana utna ning e Moses pa propetla la ka warwara tar ono ning ir hanot. ");
INSERT INTO lbb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","La atongi mang e Karisito ir mat, pa ai a ningnigona ning ir kamtur kusun a minat pa ir warwara ana talapor tetek a tarai Juda pa tarai masik otleng.” ");
INSERT INTO lbb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ning kaning ot i atalapori, e Festus i warwara kol teteki mange, “Pol, u talar. Anum a tnan asaer ka atalar pas u.” ");
INSERT INTO lbb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","E Pol i kelesi mange, “Festus, u u leklek, bel a talar. Asaning a warwara onoi i momol, pa kamkamna ot. ");
INSERT INTO lbb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","A king i tasman wakak a ututnala ne, pa langolango sur ar warwara talapor onoi. A tasmani mang bel ta utna i mumun na matana pa ana longlongor anuna i, anasa a ututnala ne i hanot, bel di tol kumnani. ");
INSERT INTO lbb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","King Agripa, mangasa, u tortorot ana warwarala ana propetla? A tasmani mang u tortorot.” ");
INSERT INTO lbb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","E Agripa i deken e Pol mange, “Mangasa, u nuki mang bel ir bongnani ur lingir pas a nuknukik, sur iau otleng ar te Karisito?” ");
INSERT INTO lbb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","E Pol i kelesi mange, “Ning i bongnani o bel i bongnani, ar araring tetek e God sur u. Ika bel sur u ka, sur mulo rop ning mulo longor iau onone, sur mulor arlar hok, ika gong di dot akes mulo.” ");
INSERT INTO lbb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pa king i kamtur, taum oe Festus pa e Bernaisi, pa la otleng ning la kes taum. ");
INSERT INTO lbb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ning la han purum, la warwara pa la atongi mange, “A barsan ne bel i tol ta utna ning i laulau sur ir hirua onoi, pa ir karabus ono.” ");
INSERT INTO lbb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Pa e Agripa i atai e Festus mange, “Ning a barsan ne bel i nunung sur a Sisar ir warkurai i, i wakak ka sur dir pak seni.” ");
INSERT INTO lbb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ning di ka kubus tari sur milar kas ana sip utumo na papar Itali, di saran tar e Pol, pa dingla otleng ning la karabus, tetek a ningnigo, a risana e Julius, miting na tarai a harum ana Sisar. ");
INSERT INTO lbb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Mila kas ana ning a sip misaot e Adramitium, ning ir han sur ir sot amon ting na hananuala ting na papar Esia. Ning mila ka kas tar, a sip i dun. Mila armuri taum oe Aristarkus misaot e Tesalonika ting na papar Masedonia. ");
INSERT INTO lbb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ana pukakiar lamur mila sot te e Saidon. E Julius i maris e Pol, i malmaling seni sur ir han pas tetek na halalna, sur lar tabari ana saning i kapan suri. ");
INSERT INTO lbb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ning a sip i dun ulak, mila dun rait a lolo Saiprus, anasa a wuwu i um mila misalanigo. ");
INSERT INTO lbb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Lamur, mila kutus milau naur a papar Silisia pa e Pampilia, pa mila sot tumo e Maira, ting na papar Lisia. ");
INSERT INTO lbb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tingia, e Julius i pastek ning a sip mitumo e Aleksandria, ning ir han utumo e Itali, pa i akas tar mila onoi. ");
INSERT INTO lbb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Pa galis a pukakiar mila dun wowon ka, anasa i rakrakai kol anumila tinan utumo e Nidus. A wuwu i rakrakai, pa bel mila tolsot sur milar dun tostos, pa mila dun rait a lolo Krit milau e Salmone. ");
INSERT INTO lbb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Mila rarat tumokorot, anasa a wuwu i rakrakai, pa mila hanot ting na ning a pukna, di atongi A Wakak a Mulukun, milau a hanua Lasea. ");
INSERT INTO lbb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mila ka kes a galis a pukakiar, pa tinan salatasi ka laulau, anasa a Pukakiar na Tamai ka rop pa milau na kalangla na wuwu ir hanot. Pa e Pol i atumarang la mange, ");
INSERT INTO lbb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“A taraila! A oroi mang, ning dalar han ka, a sip ir hirua taum ana ututnala, pa dala otleng dalar hirua.” ");
INSERT INTO lbb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ika e Julius bel i longor ana warwara ane Pol, i longor pas ka a warwara anuna kiapten pa tamana sip. ");
INSERT INTO lbb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","A mulukun ning la kes ia, bel i wakak sur lar nanan sen a kalangla na wuwu tingia, pa galis onla, la malmaling mang, i wakak ning lar dun bolos ka utumo e Poniks, sur lar nanan sen a kalangla na wuwu tingia. E Poniks a wakak a mulukun tumo na lolo Krit, ning i tai sur a pukna ning a kamis i sup ia. ");
INSERT INTO lbb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ning a wakak a wuwu na tobar i hanot, la nuki mang i wakak ka sur a tinan. La dat kas a aga, pa la rarat amon tumokorot na lolo Krit. ");
INSERT INTO lbb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Pa bel i bongnani, a rakrakai a wuwu i hanot, di atongi mang e Urakilon. I harum purum misa na lolo. ");
INSERT INTO lbb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ning a wuwu i tong kes ana sip, bel i tolsot sur ir dun, pa mila lingir seni sur ir mur a wuwu. ");
INSERT INTO lbb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ning mila dun rait ting na natar a lolo Kauda, i rakrakai kol tetek mila sur milar dat kas a gigi. ");
INSERT INTO lbb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ning la dat kas pasi usaot, la rau rakrakai a sip ana inaula. La matmataut sakana lar dun tar na palai a puka woio ning i masmasa milau Sirtis, pa la dat purum sen a sel, pa sip i saler kama, a wuwu i wus amoni. ");
INSERT INTO lbb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","A pukakiar lamur, a sip milau ir tarege ana tnan wuwu, pa la migen parung a ututnala. ");
INSERT INTO lbb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Pa ana pukakiar lamur, a boskurula la migen parung a ututnala miting na sip. ");
INSERT INTO lbb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Pa galis a pukakiar a kamis pa nangnangla bel la sasai, pa rakrakai a wuwu bel i manah, pa bel ma mila nuki mang milar laun. ");
INSERT INTO lbb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","A galis a pukakiar bel la hangan. Lamur e Pol i tur na matanla pa i atai la mange, “A taraila! Ning mulo ka longor tar anuk a warwara pa bel dala han mitumo e Krit, bel ta utna larne ir kibas dala, a sip pa ututnala bel ir laulau. ");
INSERT INTO lbb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Pa onone, a nunung mulo mang, gong mulo matmataut, anasa bel tik ta halimulo ir hirua, a sip ka ir hirua. ");
INSERT INTO lbb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nangana morom, ning a angelo ane God i hanot tetek iau, a God ning a titol teteki, pa iau anunai. ");
INSERT INTO lbb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Pa angelo i atongi mange, ‘Pol, gong u matmataut, ur turot ana warkurai na matana Sisar. Pa e God ir alaun la rop ning mulo han taum ting na sip.’ ");
INSERT INTO lbb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Pa tastasikla, gong mulo matmataut, anasa a tortorot oe God mang ir tolsot asaning ka atai tar iau onoi. ");
INSERT INTO lbb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ika a sip ir kes ot na palai a masmasa milau ta lolo.” ");
INSERT INTO lbb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ana ning a bonot pa pisir diat a pukakiar ana morom, a wuwu kaning ot i wus amon mila ting na tasi Adria. Ana tnan morom, a boskurula la nuki mang mila ka saler milau ta hanua. ");
INSERT INTO lbb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Pa la toho a laman ana tasi, pa la pasteki mang i diat a bonot a mita. Lamur siklik ka, la toho ulaki, pa la pasteki mang natol a bonot a mita kama. ");
INSERT INTO lbb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Pa la matmataut sakana milar saler tar ting na ta masmasa, pa la migen purum diat a aga tumo lamur ana sip, pa la araring sur ir kabakiar kapit. ");
INSERT INTO lbb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","A boskurula la mang sur lar liu kumna kusun a sip ana gigi. La alorong purumi uting na tasi, pa la asongo mang lar s