﻿USE sofia;
DROP TABLE IF EXISTS sofia.latVUC_vpl;
CREATE TABLE latVUC_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES latVUC_vpl WRITE;
INSERT INTO latVUC_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In principio creavit Deus cælum et terram. ");
INSERT INTO latVUC_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Terra autem erat inanis et vacua, et tenebræ erant super faciem abyssi: et spiritus Dei ferebatur super aquas. ");
INSERT INTO latVUC_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dixitque Deus: Fiat lux. Et facta est lux. ");
INSERT INTO latVUC_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Et vidit Deus lucem quod esset bona: et divisit lucem a tenebris. ");
INSERT INTO latVUC_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Appellavitque lucem Diem, et tenebras Noctem: factumque est vespere et mane, dies unus. ");
INSERT INTO latVUC_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Dixit quoque Deus: Fiat firmamentum in medio aquarum: et dividat aquas ab aquis. ");
INSERT INTO latVUC_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Et fecit Deus firmamentum, divisitque aquas, quæ erant sub firmamento, ab his, quæ erant super firmamentum. Et factum est ita. ");
INSERT INTO latVUC_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Vocavitque Deus firmamentum, Cælum: et factum est vespere et mane, dies secundus. ");
INSERT INTO latVUC_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dixit vero Deus: Congregentur aquæ, quæ sub cælo sunt, in locum unum: et appareat arida. Et factum est ita. ");
INSERT INTO latVUC_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Et vocavit Deus aridam Terram, congregationesque aquarum appellavit Maria. Et vidit Deus quod esset bonum. ");
INSERT INTO latVUC_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Et ait: Germinet terra herbam virentem, et facientem semen, et lignum pomiferum faciens fructum juxta genus suum, cujus semen in semetipso sit super terram. Et factum est ita. ");
INSERT INTO latVUC_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Et protulit terra herbam virentem, et facientem semen juxta genus suum, lignumque faciens fructum, et habens unumquodque sementem secundum speciem suam. Et vidit Deus quod esset bonum. ");
INSERT INTO latVUC_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Et factum est vespere et mane, dies tertius. ");
INSERT INTO latVUC_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dixit autem Deus: Fiant luminaria in firmamento cæli, et dividant diem ac noctem, et sint in signa et tempora, et dies et annos: ");
INSERT INTO latVUC_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ut luceant in firmamento cæli, et illuminent terram. Et factum est ita. ");
INSERT INTO latVUC_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Fecitque Deus duo luminaria magna: luminare majus, ut præesset diei: et luminare minus, ut præesset nocti: et stellas. ");
INSERT INTO latVUC_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Et posuit eas in firmamento cæli, ut lucerent super terram, ");
INSERT INTO latVUC_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","et præessent diei ac nocti, et dividerent lucem ac tenebras. Et vidit Deus quod esset bonum. ");
INSERT INTO latVUC_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Et factum est vespere et mane, dies quartus. ");
INSERT INTO latVUC_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Dixit etiam Deus: Producant aquæ reptile animæ viventis, et volatile super terram sub firmamento cæli. ");
INSERT INTO latVUC_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Creavitque Deus cete grandia, et omnem animam viventem atque motabilem, quam produxerant aquæ in species suas, et omne volatile secundum genus suum. Et vidit Deus quod esset bonum. ");
INSERT INTO latVUC_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Benedixitque eis, dicens: Crescite, et multiplicamini, et replete aquas maris: avesque multiplicentur super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Et factum est vespere et mane, dies quintus. ");
INSERT INTO latVUC_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dixit quoque Deus: Producat terra animam viventem in genere suo, jumenta, et reptilia, et bestias terræ secundum species suas. Factumque est ita. ");
INSERT INTO latVUC_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Et fecit Deus bestias terræ juxta species suas, et jumenta, et omne reptile terræ in genere suo. Et vidit Deus quod esset bonum, ");
INSERT INTO latVUC_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","et ait: Faciamus hominem ad imaginem et similitudinem nostram: et præsit piscibus maris, et volatilibus cæli, et bestiis, universæque terræ, omnique reptili, quod movetur in terra. ");
INSERT INTO latVUC_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Et creavit Deus hominem ad imaginem suam: ad imaginem Dei creavit illum, masculum et feminam creavit eos. ");
INSERT INTO latVUC_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Benedixitque illis Deus, et ait: Crescite et multiplicamini, et replete terram, et subjicite eam, et dominamini piscibus maris, et volatilibus cæli, et universis animantibus, quæ moventur super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Dixitque Deus: Ecce dedi vobis omnem herbam afferentem semen super terram, et universa ligna quæ habent in semetipsis sementem generis sui, ut sint vobis in escam: ");
INSERT INTO latVUC_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","et cunctis animantibus terræ, omnique volucri cæli, et universis quæ moventur in terra, et in quibus est anima vivens, ut habeant ad vescendum. Et factum est ita. ");
INSERT INTO latVUC_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Viditque Deus cuncta quæ fecerat, et erant valde bona. Et factum est vespere et mane, dies sextus. ");
INSERT INTO latVUC_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Igitur perfecti sunt cæli et terra, et omnis ornatus eorum. ");
INSERT INTO latVUC_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Complevitque Deus die septimo opus suum quod fecerat: et requievit die septimo ab universo opere quod patrarat. ");
INSERT INTO latVUC_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Et benedixit diei septimo, et sanctificavit illum, quia in ipso cessaverat ab omni opere suo quod creavit Deus ut faceret. ");
INSERT INTO latVUC_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Istæ sunt generationes cæli et terræ, quando creata sunt, in die quo fecit Dominus Deus cælum et terram, ");
INSERT INTO latVUC_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","et omne virgultum agri antequam oriretur in terra, omnemque herbam regionis priusquam germinaret: non enim pluerat Dominus Deus super terram, et homo non erat qui operaretur terram: ");
INSERT INTO latVUC_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","sed fons ascendebat e terra, irrigans universam superficiem terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Formavit igitur Dominus Deus hominem de limo terræ, et inspiravit in faciem ejus spiraculum vitæ, et factus est homo in animam viventem. ");
INSERT INTO latVUC_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Plantaverat autem Dominus Deus paradisum voluptatis a principio, in quo posuit hominem quem formaverat. ");
INSERT INTO latVUC_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Produxitque Dominus Deus de humo omne lignum pulchrum visu, et ad vescendum suave lignum etiam vitæ in medio paradisi, lignumque scientiæ boni et mali. ");
INSERT INTO latVUC_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Et fluvius egrediebatur de loco voluptatis ad irrigandum paradisum, qui inde dividitur in quatuor capita. ");
INSERT INTO latVUC_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nomen uni Phison: ipse est qui circuit omnem terram Hevilath, ubi nascitur aurum: ");
INSERT INTO latVUC_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","et aurum terræ illius optimum est; ibi invenitur bdellium, et lapis onychinus. ");
INSERT INTO latVUC_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Et nomen fluvii secundi Gehon; ipse est qui circumit omnem terram Æthiopiæ. ");
INSERT INTO latVUC_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nomen vero fluminis tertii, Tigris: ipse vadit contra Assyrios. Fluvius autem quartus, ipse est Euphrates. ");
INSERT INTO latVUC_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tulit ergo Dominus Deus hominem, et posuit eum in paradiso voluptatis, ut operaretur, et custodiret illum: ");
INSERT INTO latVUC_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","præcepitque ei, dicens: Ex omni ligno paradisi comede; ");
INSERT INTO latVUC_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","de ligno autem scientiæ boni et mali ne comedas: in quocumque enim die comederis ex eo, morte morieris. ");
INSERT INTO latVUC_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Dixit quoque Dominus Deus: Non est bonum esse hominem solum: faciamus ei adjutorium simile sibi. ");
INSERT INTO latVUC_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Formatis igitur Dominus Deus de humo cunctis animantibus terræ, et universis volatilibus cæli, adduxit ea ad Adam, ut videret quid vocaret ea: omne enim quod vocavit Adam animæ viventis, ipsum est nomen ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Appellavitque Adam nominibus suis cuncta animantia, et universa volatilia cæli, et omnes bestias terræ: Adæ vero non inveniebatur adjutor similis ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Immisit ergo Dominus Deus soporem in Adam: cumque obdormisset, tulit unam de costis ejus, et replevit carnem pro ea. ");
INSERT INTO latVUC_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Et ædificavit Dominus Deus costam, quam tulerat de Adam, in mulierem: et adduxit eam ad Adam. ");
INSERT INTO latVUC_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Dixitque Adam: Hoc nunc os ex ossibus meis, et caro de carne mea: hæc vocabitur Virago, quoniam de viro sumpta est. ");
INSERT INTO latVUC_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Quam ob rem relinquet homo patrem suum, et matrem, et adhærebit uxori suæ: et erunt duo in carne una. ");
INSERT INTO latVUC_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Erat autem uterque nudus, Adam scilicet et uxor ejus: et non erubescebant. ");
INSERT INTO latVUC_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Sed et serpens erat callidior cunctis animantibus terræ quæ fecerat Dominus Deus. Qui dixit ad mulierem: Cur præcepit vobis Deus ut non comederetis de omni ligno paradisi? ");
INSERT INTO latVUC_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Cui respondit mulier: De fructu lignorum, quæ sunt in paradiso, vescimur: ");
INSERT INTO latVUC_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","de fructu vero ligni quod est in medio paradisi, præcepit nobis Deus ne comederemus, et ne tangeremus illud, ne forte moriamur. ");
INSERT INTO latVUC_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Dixit autem serpens ad mulierem: Nequaquam morte moriemini. ");
INSERT INTO latVUC_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Scit enim Deus quod in quocumque die comederitis ex eo, aperientur oculi vestri, et eritis sicut dii, scientes bonum et malum. ");
INSERT INTO latVUC_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Vidit igitur mulier quod bonum esset lignum ad vescendum, et pulchrum oculis, aspectuque delectabile: et tulit de fructu illius, et comedit: deditque viro suo, qui comedit. ");
INSERT INTO latVUC_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Et aperti sunt oculi amborum; cumque cognovissent se esse nudos, consuerunt folia ficus, et fecerunt sibi perizomata. ");
INSERT INTO latVUC_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Et cum audissent vocem Domini Dei deambulantis in paradiso ad auram post meridiem, abscondit se Adam et uxor ejus a facie Domini Dei in medio ligni paradisi. ");
INSERT INTO latVUC_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Vocavitque Dominus Deus Adam, et dixit ei: Ubi es? ");
INSERT INTO latVUC_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Qui ait: Vocem tuam audivi in paradiso, et timui, eo quod nudus essem, et abscondi me. ");
INSERT INTO latVUC_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Cui dixit: Quis enim indicavit tibi quod nudus esses, nisi quod ex ligno de quo præceperam tibi ne comederes, comedisti? ");
INSERT INTO latVUC_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Dixitque Adam: Mulier, quam dedisti mihi sociam, dedit mihi de ligno, et comedi. ");
INSERT INTO latVUC_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Et dixit Dominus Deus ad mulierem: Quare hoc fecisti? Quæ respondit: Serpens decepit me, et comedi. ");
INSERT INTO latVUC_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Et ait Dominus Deus ad serpentem: Quia fecisti hoc, maledictus es inter omnia animantia, et bestias terræ: super pectus tuum gradieris, et terram comedes cunctis diebus vitæ tuæ. ");
INSERT INTO latVUC_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Inimicitias ponam inter te et mulierem, et semen tuum et semen illius: ipsa conteret caput tuum, et tu insidiaberis calcaneo ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Mulieri quoque dixit: Multiplicabo ærumnas tuas, et conceptus tuos: in dolore paries filios, et sub viri potestate eris, et ipse dominabitur tui. ");
INSERT INTO latVUC_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adæ vero dixit: Quia audisti vocem uxoris tuæ, et comedisti de ligno, ex quo præceperam tibi ne comederes, maledicta terra in opere tuo: in laboribus comedes ex ea cunctis diebus vitæ tuæ. ");
INSERT INTO latVUC_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Spinas et tribulos germinabit tibi, et comedes herbam terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","In sudore vultus tui vesceris pane, donec revertaris in terram de qua sumptus es: quia pulvis es et in pulverem reverteris. ");
INSERT INTO latVUC_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Et vocavit Adam nomen uxoris suæ, Heva: eo quod mater esset cunctorum viventium. ");
INSERT INTO latVUC_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Fecit quoque Dominus Deus Adæ et uxori ejus tunicas pelliceas, et induit eos: ");
INSERT INTO latVUC_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","et ait: Ecce Adam quasi unus ex nobis factus est, sciens bonum et malum: nunc ergo ne forte mittat manum suam, et sumat etiam de ligno vitæ, et comedat, et vivat in æternum. ");
INSERT INTO latVUC_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Et emisit eum Dominus Deus de paradiso voluptatis, ut operaretur terram de qua sumptus est. ");
INSERT INTO latVUC_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ejecitque Adam: et collocavit ante paradisum voluptatis cherubim, et flammeum gladium, atque versatilem, ad custodiendam viam ligni vitæ. ");
INSERT INTO latVUC_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam vero cognovit uxorem suam Hevam, quæ concepit et peperit Cain, dicens: Possedi hominem per Deum. ");
INSERT INTO latVUC_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Rursumque peperit fratrem ejus Abel. Fuit autem Abel pastor ovium, et Cain agricola. ");
INSERT INTO latVUC_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Factum est autem post multos dies ut offerret Cain de fructibus terræ munera Domino. ");
INSERT INTO latVUC_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel quoque obtulit de primogenitis gregis sui, et de adipibus eorum: et respexit Dominus ad Abel, et ad munera ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ad Cain vero, et ad munera illius non respexit: iratusque est Cain vehementer, et concidit vultus ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Dixitque Dominus ad eum: Quare iratus es? et cur concidit facies tua? ");
INSERT INTO latVUC_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","nonne si bene egeris, recipies: sin autem male, statim in foribus peccatum aderit? sed sub te erit appetitus ejus, et tu dominaberis illius. ");
INSERT INTO latVUC_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Dixitque Cain ad Abel fratrem suum: Egrediamur foras. Cumque essent in agro, consurrexit Cain adversus fratrem suum Abel, et interfecit eum. ");
INSERT INTO latVUC_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Et ait Dominus ad Cain: Ubi est Abel frater tuus? Qui respondit: Nescio: num custos fratris mei sum ego? ");
INSERT INTO latVUC_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Dixitque ad eum: Quid fecisti? vox sanguinis fratris tui clamat ad me de terra. ");
INSERT INTO latVUC_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nunc igitur maledictus eris super terram, quæ aperuit os suum, et suscepit sanguinem fratris tui de manu tua. ");
INSERT INTO latVUC_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Cum operatus fueris eam, non dabit tibi fructus suos: vagus et profugus eris super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Dixitque Cain ad Dominum: Major est iniquitas mea, quam ut veniam merear. ");
INSERT INTO latVUC_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ecce ejicis me hodie a facie terræ, et a facie tua abscondar, et ero vagus et profugus in terra: omnis igitur qui invenerit me, occidet me. ");
INSERT INTO latVUC_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Dixitque ei Dominus: Nequaquam ita fiet: sed omnis qui occiderit Cain, septuplum punietur. Posuitque Dominus Cain signum, ut non interficeret eum omnis qui invenisset eum. ");
INSERT INTO latVUC_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Egressusque Cain a facie Domini, habitavit profugus in terra ad orientalem plagam Eden. ");
INSERT INTO latVUC_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cognovit autem Cain uxorem suam, quæ concepit, et peperit Henoch: et ædificavit civitatem, vocavitque nomen ejus ex nomine filii sui, Henoch. ");
INSERT INTO latVUC_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Porro Henoch genuit Irad, et Irad genuit Maviaël, et Maviaël genuit Mathusaël, et Mathusaël genuit Lamech. ");
INSERT INTO latVUC_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Qui accepit duas uxores, nomen uni Ada, et nomen alteri Sella. ");
INSERT INTO latVUC_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Genuitque Ada Jabel, qui fuit pater habitantium in tentoriis, atque pastorum. ");
INSERT INTO latVUC_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Et nomen fratris ejus Jubal: ipse fuit pater canentium cithara et organo. ");
INSERT INTO latVUC_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sella quoque genuit Tubalcain, qui fuit malleator et faber in cuncta opera æris et ferri. Soror vero Tubalcain, Noëma. ");
INSERT INTO latVUC_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Dixitque Lamech uxoribus suis Adæ et Sellæ: Audite vocem meam, uxores Lamech; auscultate sermonem meum: quoniam occidi virum in vulnus meum, et adolescentulum in livorem meum. ");
INSERT INTO latVUC_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Septuplum ultio dabitur de Cain: de Lamech vero septuagies septies. ");
INSERT INTO latVUC_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Cognovit quoque adhuc Adam uxorem suam: et peperit filium, vocavitque nomen ejus Seth, dicens: Posuit mihi Deus semen aliud pro Abel, quem occidit Cain. ");
INSERT INTO latVUC_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sed et Seth natus est filius, quem vocavit Enos: iste cœpit invocare nomen Domini. ");
INSERT INTO latVUC_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hic est liber generationis Adam. In die qua creavit Deus hominem, ad similitudinem Dei fecit illum. ");
INSERT INTO latVUC_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Masculum et feminam creavit eos, et benedixit illis: et vocavit nomen eorum Adam, in die quo creati sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Vixit autem Adam centum triginta annis: et genuit ad imaginem et similitudinem suam, vocavitque nomen ejus Seth. ");
INSERT INTO latVUC_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Et facti sunt dies Adam, postquam genuit Seth, octingenti anni: genuitque filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Et factum est omne tempus quod vixit Adam, anni nongenti triginta, et mortuus est. ");
INSERT INTO latVUC_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Vixit quoque Seth centum quinque annis, et genuit Enos. ");
INSERT INTO latVUC_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Vixitque Seth, postquam genuit Enos, octingentis septem annis, genuitque filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Et facti sunt omnes dies Seth nongentorum duodecim annorum, et mortuus est. ");
INSERT INTO latVUC_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Vixit vero Enos nonaginta annis, et genuit Cainan. ");
INSERT INTO latVUC_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Post cujus ortum vixit octingentis quindecim annis, et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Factique sunt omnes dies Enos nongenti quinque anni, et mortuus est. ");
INSERT INTO latVUC_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Vixit quoque Cainan septuaginta annis, et genuit Malaleel. ");
INSERT INTO latVUC_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Et vixit Cainan, postquam genuit Malaleel, octingentis quadraginta annis, genuitque filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Et facti sunt omnes dies Cainan nongenti decem anni, et mortuus est. ");
INSERT INTO latVUC_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Vixit autem Malaleel sexaginta quinque annis, et genuit Jared. ");
INSERT INTO latVUC_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Et vixit Malaleel, postquam genuit Jared, octingentis triginta annis, et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Et facti sunt omnes dies Malaleel octingenti nonaginta quinque anni, et mortuus est. ");
INSERT INTO latVUC_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Vixitque Jared centum sexaginta duobus annis, et genuit Henoch. ");
INSERT INTO latVUC_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Et vixit Jared, postquam genuit Henoch, octingentis annis, et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Et facti sunt omnes dies Jared nongenti sexaginta duo anni, et mortuus est. ");
INSERT INTO latVUC_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Porro Henoch vixit sexaginta quinque annis, et genuit Mathusalam. ");
INSERT INTO latVUC_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Et ambulavit Henoch cum Deo: et vixit, postquam genuit Mathusalam, trecentis annis, et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Et facti sunt omnes dies Henoch trecenti sexaginta quinque anni. ");
INSERT INTO latVUC_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ambulavitque cum Deo, et non apparuit: quia tulit eum Deus. ");
INSERT INTO latVUC_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Vixit quoque Mathusala centum octoginta septem annis, et genuit Lamech. ");
INSERT INTO latVUC_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Et vixit Mathusala, postquam genuit Lamech, septingentis octoginta duobus annis, et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Et facti sunt omnes dies Mathusala nongenti sexaginta novem anni, et mortuus est. ");
INSERT INTO latVUC_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Vixit autem Lamech centum octoginta duobus annis, et genuit filium: ");
INSERT INTO latVUC_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","vocavitque nomen ejus Noë, dicens: Iste consolabitur nos ab operibus et laboribus manuum nostrarum in terra, cui maledixit Dominus. ");
INSERT INTO latVUC_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Vixitque Lamech, postquam genuit Noë, quingentis nonaginta quinque annis, et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Et facti sunt omnes dies Lamech septingenti septuaginta septem anni, et mortuus est. Noë vero cum quingentorum esset annorum, genuit Sem, Cham et Japheth. ");
INSERT INTO latVUC_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Cumque cœpissent homines multiplicari super terram, et filias procreassent, ");
INSERT INTO latVUC_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","videntes filii Dei filias hominum quod essent pulchræ, acceperunt sibi uxores ex omnibus, quas elegerant. ");
INSERT INTO latVUC_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Dixitque Deus: Non permanebit spiritus meus in homine in æternum, quia caro est: eruntque dies illius centum viginti annorum. ");
INSERT INTO latVUC_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Gigantes autem erant super terram in diebus illis: postquam enim ingressi sunt filii Dei ad filias hominum, illæque genuerunt, isti sunt potentes a sæculo viri famosi. ");
INSERT INTO latVUC_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Videns autem Deus quod multa malitia hominum esset in terra, et cuncta cogitatio cordis intenta esset ad malum omni tempore, ");
INSERT INTO latVUC_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","pœnituit eum quod hominum fecisset in terra. Et tactus dolore cordis intrinsecus, ");
INSERT INTO latVUC_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Delebo, inquit, hominem, quem creavi, a facie terræ, ab homine usque ad animantia, a reptili usque ad volucres cæli: pœnitet enim me fecisse eos. ");
INSERT INTO latVUC_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noë vero invenit gratiam coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hæ sunt generationes Noë: Noë vir justus atque perfectus fuit in generationibus suis; cum Deo ambulavit. ");
INSERT INTO latVUC_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Et genuit tres filios, Sem, Cham et Japheth. ");
INSERT INTO latVUC_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Corrupta est autem terra coram Deo, et repleta est iniquitate. ");
INSERT INTO latVUC_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Cumque vidisset Deus terram esse corruptam (omnis quippe caro corruperat viam suam super terram), ");
INSERT INTO latVUC_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","dixit ad Noë: Finis universæ carnis venit coram me: repleta est terra iniquitate a facie eorum, et ego disperdam eos cum terra. ");
INSERT INTO latVUC_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fac tibi arcam de lignis lævigatis; mansiunculas in arca facies, et bitumine linies intrinsecus et extrinsecus. ");
INSERT INTO latVUC_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Et sic facies eam: trecentorum cubitorum erit longitudo arcæ, quinquaginta cubitorum latitudo, et triginta cubitorum altitudo illius. ");
INSERT INTO latVUC_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Fenestram in arca facies, et in cubito consummabis summitatem ejus: ostium autem arcæ pones ex latere; deorsum, cœnacula et tristega facies in ea. ");
INSERT INTO latVUC_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ecce ego adducam aquas diluvii super terram, ut interficiam omnem carnem, in qua spiritus vitæ est subter cælum: universa quæ in terra sunt, consumentur. ");
INSERT INTO latVUC_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ponamque fœdus meum tecum: et ingredieris arcam tu et filii tui, uxor tua, et uxores filiorum tuorum tecum. ");
INSERT INTO latVUC_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Et ex cunctis animantibus universæ carnis bina induces in arcam, ut vivant tecum: masculini sexus et feminini. ");
INSERT INTO latVUC_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","De volucribus juxta genus suum, et de jumentis in genere suo, et ex omni reptili terræ secundum genus suum: bina de omnibus ingredientur tecum, ut possint vivere. ");
INSERT INTO latVUC_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tolles igitur tecum ex omnibus escis, quæ mandi possunt, et comportabis apud te: et erunt tam tibi, quam illis in cibum. ");
INSERT INTO latVUC_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Fecit igitur Noë omnia quæ præceperat illi Deus. ");
INSERT INTO latVUC_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Dixitque Dominus ad eum: Ingredere tu et omnis domus tua in arcam: te enim vidi justum coram me in generatione hac. ");
INSERT INTO latVUC_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ex omnibus animantibus mundis tolle septena et septena, masculum et feminam: de animantibus vero immundis duo et duo, masculum et feminam. ");
INSERT INTO latVUC_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Sed et de volatilibus cæli septena et septena, masculum et feminam: ut salvetur semen super faciem universæ terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Adhuc enim, et post dies septem ego pluam super terram quadraginta diebus et quadraginta noctibus: et delebo omnem substantiam, quam feci, de superficie terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Fecit ergo Noë omnia quæ mandaverat ei Dominus. ");
INSERT INTO latVUC_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Eratque sexcentorum annorum quando diluvii aquæ inundaverunt super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Et ingressus est Noë et filii ejus, uxor ejus et uxores filiorum ejus cum eo in arcam propter aquas diluvii. ");
INSERT INTO latVUC_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","De animantibus quoque mundis et immundis, et de volucribus, et ex omni quod movetur super terram, ");
INSERT INTO latVUC_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","duo et duo ingressa sunt ad Noë in arcam, masculus et femina, sicut præceperat Dominus Noë. ");
INSERT INTO latVUC_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Cumque transissent septem dies, aquæ diluvii inundaverunt super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Anno sexcentesimo vitæ Noë, mense secundo, septimodecimo die mensis, rupti sunt omnes fontes abyssi magnæ, et cataractæ cæli apertæ sunt: ");
INSERT INTO latVUC_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","et facta est pluvia super terram quadraginta diebus et quadraginta noctibus. ");
INSERT INTO latVUC_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","In articulo diei illius ingressus est Noë, et Sem, et Cham, et Japheth filii ejus; uxor illius, et tres uxores filiorum ejus cum eis in arcam: ");
INSERT INTO latVUC_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ipsi et omne animal secundum genus suum, universaque jumenta in genere suo, et omne quod movetur super terram in genere suo, cunctumque volatile secundum genus suum, universæ aves, omnesque volucres, ");
INSERT INTO latVUC_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ingressæ sunt ad Noë in arcam, bina et bina ex omni carne, in qua erat spiritus vitæ. ");
INSERT INTO latVUC_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Et quæ ingressa sunt, masculus et femina ex omni carne introierunt, sicut præceperat ei Deus: et inclusit eum Dominus deforis. ");
INSERT INTO latVUC_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Factumque est diluvium quadraginta diebus super terram: et multiplicatæ sunt aquæ, et elevaverunt arcam in sublime a terra. ");
INSERT INTO latVUC_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Vehementer enim inundaverunt, et omnia repleverunt in superficie terræ: porro arca ferebatur super aquas. ");
INSERT INTO latVUC_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Et aquæ prævaluerunt nimis super terram: opertique sunt omnes montes excelsi sub universo cælo. ");
INSERT INTO latVUC_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Quindecim cubitis altior fuit aqua super montes, quos operuerat. ");
INSERT INTO latVUC_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Consumptaque est omnis caro quæ movebatur super terram, volucrum, animantium, bestiarum, omniumque reptilium, quæ reptant super terram: universi homines, ");
INSERT INTO latVUC_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","et cuncta, in quibus spiraculum vitæ est in terra, mortua sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Et delevit omnem substantiam quæ erat super terram, ab homine usque ad pecus, tam reptile quam volucres cæli: et deleta sunt de terra. Remansit autem solus Noë, et qui cum eo erant in arca. ");
INSERT INTO latVUC_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Obtinueruntque aquæ terram centum quinquaginta diebus. ");
INSERT INTO latVUC_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Recordatus autem Deus Noë, cunctorumque animantium, et omnium jumentorum, quæ erant cum eo in arca, adduxit spiritum super terram, et imminutæ sunt aquæ. ");
INSERT INTO latVUC_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Et clausi sunt fontes abyssi, et cataractæ cæli: et prohibitæ sunt pluviæ de cælo. ");
INSERT INTO latVUC_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Reversæque sunt aquæ de terra euntes et redeuntes: et cœperunt minui post centum quinquaginta dies. ");
INSERT INTO latVUC_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Requievitque arca mense septimo, vigesimo septimo die mensis, super montes Armeniæ. ");
INSERT INTO latVUC_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","At vero aquæ ibant et decrescebant usque ad decimum mensem: decimo enim mense, primo die mensis, apparuerunt cacumina montium. ");
INSERT INTO latVUC_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Cumque transissent quadraginta dies, aperiens Noë fenestram arcæ, quam fecerat, dimisit corvum, ");
INSERT INTO latVUC_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","qui egrediebatur, et non revertebatur, donec siccarentur aquæ super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Emisit quoque columbam post eum, ut videret si jam cessassent aquæ super faciem terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Quæ cum non invenisset ubi requiesceret pes ejus, reversa est ad eum in arcam: aquæ enim erant super universam terram: extenditque manum, et apprehensam intulit in arcam. ");
INSERT INTO latVUC_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Expectatis autem ultra septem diebus aliis, rursum dimisit columbam ex arca. ");
INSERT INTO latVUC_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","At illa venit ad eum ad vesperam, portans ramum olivæ virentibus foliis in ore suo: intellexit ergo Noë quod cessassent aquæ super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Expectavitque nihilominus septem alios dies: et emisit columbam, quæ non est reversa ultra ad eum. ");
INSERT INTO latVUC_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Igitur sexcentesimo primo anno, primo mense, prima die mensis, imminutæ sunt aquæ super terram: et aperiens Noë tectum arcæ, aspexit, viditque quod exsiccata esset superficies terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mense secundo, septimo et vigesimo die mensis arefacta est terra. ");
INSERT INTO latVUC_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Locutus est autem Deus ad Noë, dicens: ");
INSERT INTO latVUC_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Egredere de arca, tu et uxor tua, filii tui et uxores filiorum tuorum tecum. ");
INSERT INTO latVUC_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Cuncta animantia, quæ sunt apud te, ex omni carne, tam in volatilibus quam in bestiis et universis reptilibus, quæ reptant super terram, educ tecum, et ingredimini super terram: crescite et multiplicamini super eam. ");
INSERT INTO latVUC_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Egressus est ergo Noë, et filii ejus: uxor illius, et uxores filiorum ejus cum eo. ");
INSERT INTO latVUC_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sed et omnia animantia, jumenta, et reptilia quæ reptant super terram, secundum genus suum, egressa sunt de arca. ");
INSERT INTO latVUC_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ædificavit autem Noë altare Domino: et tollens de cunctis pecoribus et volucribus mundis, obtulit holocausta super altare. ");
INSERT INTO latVUC_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Odoratusque est Dominus odorem suavitatis, et ait: Nequaquam ultra maledicam terræ propter homines: sensus enim et cogitatio humani cordis in malum prona sunt ab adolescentia sua: non igitur ultra percutiam omnem animam viventem sicut feci. ");
INSERT INTO latVUC_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Cunctis diebus terræ, sementis et messis, frigus et æstus, æstas et hiems, nox et dies non requiescent. ");
INSERT INTO latVUC_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Benedixitque Deus Noë et filiis ejus. Et dixit ad eos: Crescite, et multiplicamini, et replete terram. ");
INSERT INTO latVUC_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Et terror vester ac tremor sit super cuncta animalia terræ, et super omnes volucres cæli, cum universis quæ moventur super terram: omnes pisces maris manui vestræ traditi sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Et omne, quod movetur et vivit, erit vobis in cibum: quasi olera virentia tradidi vobis omnia. ");
INSERT INTO latVUC_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Excepto, quod carnem cum sanguine non comedetis. ");
INSERT INTO latVUC_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sanguinem enim animarum vestrarum requiram de manu cunctarum bestiarum: et de manu hominis, de manu viri, et fratris ejus requiram animam hominis. ");
INSERT INTO latVUC_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Quicumque effuderit humanum sanguinem, fundetur sanguis illius: ad imaginem quippe Dei factus est homo. ");
INSERT INTO latVUC_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Vos autem crescite et multiplicamini, et ingredimini super terram, et implete eam. ");
INSERT INTO latVUC_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hæc quoque dixit Deus ad Noë, et ad filios ejus cum eo: ");
INSERT INTO latVUC_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ecce ego statuam pactum meum vobiscum, et cum semine vestro post vos: ");
INSERT INTO latVUC_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","et ad omnem animam viventem, quæ est vobiscum, tam in volucribus quam in jumentis et pecudibus terræ cunctis, quæ egressa sunt de arca, et universis bestiis terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Statuam pactum meum vobiscum, et nequaquam ultra interficietur omnis caro aquis diluvii, neque erit deinceps diluvium dissipans terram. ");
INSERT INTO latVUC_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Dixitque Deus: Hoc signum fœderis quod do inter me et vos, et ad omnem animam viventem, quæ est vobiscum in generationes sempiternas: ");
INSERT INTO latVUC_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","arcum meum ponam in nubibus, et erit signum fœderis inter me et inter terram. ");
INSERT INTO latVUC_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Cumque obduxero nubibus cælum, apparebit arcus meus in nubibus: ");
INSERT INTO latVUC_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","et recordabor fœderis mei vobiscum, et cum omni anima vivente quæ carnem vegetat: et non erunt ultra aquæ diluvii ad delendum universam carnem. ");
INSERT INTO latVUC_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Eritque arcus in nubibus, et videbo illum, et recordabor fœderis sempiterni quod pactum est inter Deum et omnem animam viventem universæ carnis quæ est super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dixitque Deus ad Noë: Hoc erit signum fœderis, quod constitui inter me et omnem carnem super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Erant ergo filii Noë, qui egressi sunt de arca, Sem, Cham et Japheth: porro Cham ipse est pater Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Tres isti filii sunt Noë: et ab his disseminatum est omne genus hominum super universam terram. ");
INSERT INTO latVUC_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Cœpitque Noë vir agricola exercere terram, et plantavit vineam. ");
INSERT INTO latVUC_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Bibensque vinum inebriatus est, et nudatus in tabernaculo suo. ");
INSERT INTO latVUC_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Quod cum vidisset Cham, pater Chanaan, verenda scilicet patris sui esse nudata, nuntiavit duobus fratribus suis foras. ");
INSERT INTO latVUC_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","At vero Sem et Japheth pallium imposuerunt humeris suis, et incedentes retrorsum, operuerunt verenda patris sui: faciesque eorum aversæ erant, et patris virilia non viderunt. ");
INSERT INTO latVUC_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Evigilans autem Noë ex vino, cum didicisset quæ fecerat ei filius suus minor, ");
INSERT INTO latVUC_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ait: Maledictus Chanaan, servus servorum erit fratribus suis. ");
INSERT INTO latVUC_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Dixitque: Benedictus Dominus Deus Sem, sit Chanaan servus ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Dilatet Deus Japheth, et habitet in tabernaculis Sem, sitque Chanaan servus ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Vixit autem Noë post diluvium trecentis quinquaginta annis. ");
INSERT INTO latVUC_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Et impleti sunt omnes dies ejus nongentorum quinquaginta annorum: et mortuus est. ");
INSERT INTO latVUC_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hæ sunt generationes filiorum Noë, Sem, Cham et Japheth: natique sunt eis filii post diluvium. ");
INSERT INTO latVUC_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Filii Japheth: Gomer, et Magog, et Madai, et Javan, et Thubal, et Mosoch, et Thiras. ");
INSERT INTO latVUC_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Porro filii Gomer: Ascenez et Riphath et Thogorma. ");
INSERT INTO latVUC_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Filii autem Javan: Elisa et Tharsis, Cetthim et Dodanim. ");
INSERT INTO latVUC_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ab his divisæ sunt insulæ gentium in regionibus suis, unusquisque secundum linguam suam et familias suas in nationibus suis. ");
INSERT INTO latVUC_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Filii autem Cham: Chus, et Mesraim, et Phuth, et Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Filii Chus: Saba, et Hevila, et Sabatha, et Regma, et Sabatacha. Filii Regma: Saba et Dadan. ");
INSERT INTO latVUC_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Porro Chus genuit Nemrod: ipse cœpit esse potens in terra, ");
INSERT INTO latVUC_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","et erat robustus venator coram Domino. Ob hoc exivit proverbium: Quasi Nemrod robustus venator coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Fuit autem principium regni ejus Babylon, et Arach et Achad, et Chalanne, in terra Sennaar. ");
INSERT INTO latVUC_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De terra illa egressus est Assur, et ædificavit Niniven, et plateas civitatis, et Chale. ");
INSERT INTO latVUC_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resen quoque inter Niniven et Chale: hæc est civitas magna. ");
INSERT INTO latVUC_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","At vero Mesraim genuit Ludim, et Anamim et Laabim, Nephthuim, ");
INSERT INTO latVUC_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","et Phetrusim, et Chasluim: de quibus egressi sunt Philisthiim et Caphtorim. ");
INSERT INTO latVUC_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Chanaan autem genuit Sidonem primogenitum suum. Hethæum, ");
INSERT INTO latVUC_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","et Jebusæum, et Amorrhæum, Gergesæum, ");
INSERT INTO latVUC_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hevæum, et Aracæum: Sinæum, ");
INSERT INTO latVUC_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","et Aradium, Samaræum, et Amathæum: et post hæc disseminati sunt populi Chananæorum. ");
INSERT INTO latVUC_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Factique sunt termini Chanaan venientibus a Sidone Geraram usque Gazam, donec ingrediaris Sodomam et Gomorrham, et Adamam, et Seboim usque Lesa. ");
INSERT INTO latVUC_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hi sunt filii Cham in cognationibus, et linguis, et generationibus, terrisque et gentibus suis. ");
INSERT INTO latVUC_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","De Sem quoque nati sunt, patre omnium filiorum Heber, fratre Japheth majore. ");
INSERT INTO latVUC_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Filii Sem: Ælam, et Assur, et Arphaxad, et Lud, et Aram. ");
INSERT INTO latVUC_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Filii Aram: Us, et Hul, et Gether, et Mes. ");
INSERT INTO latVUC_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","At vero Arphaxad genuit Sale, de quo ortus est Heber. ");
INSERT INTO latVUC_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Natique sunt Heber filii duo: nomen uni Phaleg, eo quod in diebus ejus divisa sit terra: et nomen fratris ejus Jectan. ");
INSERT INTO latVUC_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Qui Jectan genuit Elmodad, et Saleph, et Asarmoth, Jare, ");
INSERT INTO latVUC_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","et Aduram, et Uzal, et Decla, ");
INSERT INTO latVUC_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","et Ebal, et Abimaël, Saba, ");
INSERT INTO latVUC_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","et Ophir, et Hevila, et Jobab: omnes isti, filii Jectan. ");
INSERT INTO latVUC_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Et facta est habitatio eorum de Messa pergentibus usque Sephar montem orientalem. ");
INSERT INTO latVUC_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Isti filii Sem secundum cognationes, et linguas, et regiones in gentibus suis. ");
INSERT INTO latVUC_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hæ familiæ Noë juxta populos et nationes suas. Ab his divisæ sunt gentes in terra post diluvium. ");
INSERT INTO latVUC_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Erat autem terra labii unius, et sermonum eorumdem. ");
INSERT INTO latVUC_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Cumque proficiscerentur de oriente, invenerunt campum in terra Sennaar, et habitaverunt in eo. ");
INSERT INTO latVUC_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Dixitque alter ad proximum suum: Venite, faciamus lateres, et coquamus eos igni. Habueruntque lateres pro saxis, et bitumen pro cæmento: ");
INSERT INTO latVUC_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","et dixerunt: Venite, faciamus nobis civitatem et turrim, cujus culmen pertingat ad cælum: et celebremus nomen nostrum antequam dividamur in universas terras. ");
INSERT INTO latVUC_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Descendit autem Dominus ut videret civitatem et turrim, quam ædificabant filii Adam, ");
INSERT INTO latVUC_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","et dixit: Ecce, unus est populus, et unum labium omnibus: cœperuntque hoc facere, nec desistent a cogitationibus suis, donec eas opere compleant. ");
INSERT INTO latVUC_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Venite igitur, descendamus, et confundamus ibi linguam eorum, ut non audiat unusquisque vocem proximi sui. ");
INSERT INTO latVUC_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Atque ita divisit eos Dominus ex illo loco in universas terras, et cessaverunt ædificare civitatem. ");
INSERT INTO latVUC_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Et idcirco vocatum est nomen ejus Babel, quia ibi confusum est labium universæ terræ: et inde dispersit eos Dominus super faciem cunctarum regionum. ");
INSERT INTO latVUC_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hæ sunt generationes Sem: Sem erat centum annorum quando genuit Arphaxad, biennio post diluvium. ");
INSERT INTO latVUC_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Vixitque Sem, postquam genuit Arphaxad, quingentis annis: et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Porro Arphaxad vixit triginta quinque annis, et genuit Sale. ");
INSERT INTO latVUC_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Vixitque Arphaxad, postquam genuit Sale, trecentis tribus annis: et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sale quoque vixit triginta annis, et genuit Heber. ");
INSERT INTO latVUC_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Vixitque Sale, postquam genuit Heber, quadringentis tribus annis: et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Vixit autem Heber triginta quatuor annis, et genuit Phaleg. ");
INSERT INTO latVUC_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Et vixit Heber postquam genuit Phaleg, quadringentis triginta annis: et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Vixit quoque Phaleg triginta annis, et genuit Reu. ");
INSERT INTO latVUC_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Vixitque Phaleg, postquam genuit Reu, ducentis novem annis: et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Vixit autem Reu triginta duobus annis, et genuit Sarug. ");
INSERT INTO latVUC_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Vixit quoque Reu, postquam genuit Sarug, ducentis septem annis: et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Vixit vero Sarug triginta annis, et genuit Nachor. ");
INSERT INTO latVUC_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Vixitque Sarug, postquam genuit Nachor, ducentis annis: et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Vixit autem Nachor viginti novem annis, et genuit Thare. ");
INSERT INTO latVUC_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Vixitque Nachor, postquam genuit Thare, centum decem et novem annis: et genuit filios et filias. ");
INSERT INTO latVUC_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Vixitque Thare septuaginta annis, et genuit Abram, et Nachor, et Aran. ");
INSERT INTO latVUC_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Hæ sunt autem generationes Thare: Thare genuit Abram, Nachor et Aran. Porro Aran genuit Lot. ");
INSERT INTO latVUC_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Mortuusque est Aran ante Thare patrem suum, in terra nativitatis suæ, in Ur Chaldæorum. ");
INSERT INTO latVUC_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Duxerunt autem Abram et Nachor uxores: nomen uxoris Abram, Sarai: et nomen uxoris Nachor, Melcha filia Aran, patris Melchæ, et patris Jeschæ. ");
INSERT INTO latVUC_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Erat autem Sarai sterilis, nec habebat liberos. ");
INSERT INTO latVUC_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tulit itaque Thare Abram filium suum, et Lot filium Aran, filium filii sui, et Sarai nurum suam, uxorem Abram filii sui, et eduxit eos de Ur Chaldæorum, ut irent in terram Chanaan: veneruntque usque Haran, et habitaverunt ibi. ");
INSERT INTO latVUC_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Et facti sunt dies Thare ducentorum quinque annorum, et mortuus est in Haran. ");
INSERT INTO latVUC_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Dixit autem Dominus ad Abram: Egredere de terra tua, et de cognatione tua, et de domo patris tui, et veni in terram quam monstrabo tibi. ");
INSERT INTO latVUC_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Faciamque te in gentem magnam, et benedicam tibi, et magnificabo nomen tuum, erisque benedictus. ");
INSERT INTO latVUC_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Benedicam benedicentibus tibi, et maledicam maledicentibus tibi, atque in te benedicentur universæ cognationes terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Egressus est itaque Abram sicut præceperat ei Dominus, et ivit cum eo Lot: septuaginta quinque annorum erat Abram cum egrederetur de Haran. ");
INSERT INTO latVUC_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Tulitque Sarai uxorem suam, et Lot filium fratris sui, universamque substantiam quam possederant, et animas quas fecerant in Haran: et egressi sunt ut irent in terram Chanaan. Cumque venissent in eam, ");
INSERT INTO latVUC_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","pertransivit Abram terram usque ad locum Sichem, usque ad convallem illustrem: Chananæus autem tunc erat in terra. ");
INSERT INTO latVUC_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Apparuit autem Dominus Abram, et dixit ei: Semini tuo dabo terram hanc. Qui ædificavit ibi altare Domino, qui apparuerat ei. ");
INSERT INTO latVUC_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Et inde transgrediens ad montem, qui erat contra orientem Bethel, tetendit ibi tabernaculum suum, ab occidente habens Bethel, et ab oriente Hai: ædificavit quoque ibi altare Domino, et invocavit nomen ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Perrexitque Abram vadens, et ultra progrediens ad meridiem. ");
INSERT INTO latVUC_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Facta est autem fames in terra: descenditque Abram in Ægyptum, ut peregrinaretur ibi: prævaluerat enim fames in terra. ");
INSERT INTO latVUC_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Cumque prope esset ut ingrederetur Ægyptum, dixit Sarai uxori suæ: Novi quod pulchra sis mulier: ");
INSERT INTO latVUC_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","et quod cum viderint te Ægyptii, dicturi sunt: Uxor ipsius est: et interficient me, et te reservabunt. ");
INSERT INTO latVUC_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dic ergo, obsecro te, quod soror mea sis: ut bene sit mihi propter te, et vivat anima mea ob gratiam tui. ");
INSERT INTO latVUC_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Cum itaque ingressus esset Abram Ægyptum, viderunt Ægyptii mulierem quod esset pulchra nimis. ");
INSERT INTO latVUC_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Et nuntiaverunt principes Pharaoni, et laudaverunt eam apud illum: et sublata est mulier in domum Pharaonis. ");
INSERT INTO latVUC_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Abram vero bene usi sunt propter illam: fueruntque ei oves et boves et asini, et servi et famulæ, et asinæ et cameli. ");
INSERT INTO latVUC_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Flagellavit autem Dominus Pharaonem plagis maximis, et domum ejus, propter Sarai uxorem Abram. ");
INSERT INTO latVUC_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Vocavitque Pharao Abram, et dixit ei: Quidnam est hoc quod fecisti mihi? quare non indicasti quod uxor tua esset? ");
INSERT INTO latVUC_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","quam ob causam dixisti esse sororem tuam, ut tollerem eam mihi in uxorem? Nunc igitur ecce conjux tua, accipe eam, et vade. ");
INSERT INTO latVUC_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Præcepitque Pharao super Abram viris: et deduxerunt eum, et uxorem illius, et omnia quæ habebat. ");
INSERT INTO latVUC_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ascendit ergo Abram de Ægypto, ipse et uxor ejus, et omnia quæ habebat, et Lot cum eo, ad australem plagam. ");
INSERT INTO latVUC_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Erat autem dives valde in possessione auri et argenti. ");
INSERT INTO latVUC_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Reversusque est per iter, quo venerat, a meridie in Bethel, usque ad locum ubi prius fixerat tabernaculum inter Bethel et Hai, ");
INSERT INTO latVUC_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","in loco altaris quod fecerat prius: et invocavit ibi nomen Domini. ");
INSERT INTO latVUC_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Sed et Lot qui erat cum Abram, fuerunt greges ovium, et armenta, et tabernacula. ");
INSERT INTO latVUC_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nec poterat eos capere terra, ut habitarent simul: erat quippe substantia eorum multa, et nequibant habitare communiter. ");
INSERT INTO latVUC_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Unde et facta est rixa inter pastores gregum Abram et Lot. Eo autem tempore Chananæus et Pherezæus habitabant in terra illa. ");
INSERT INTO latVUC_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Dixit ergo Abram ad Lot: Ne quæso sit jurgium inter me et te, et inter pastores meos et pastores tuos: fratres enim sumus. ");
INSERT INTO latVUC_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ecce universa terra coram te est: recede a me, obsecro: si ad sinistram ieris, ego dexteram tenebo: si tu dexteram elegeris, ego ad sinistram pergam. ");
INSERT INTO latVUC_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Elevatis itaque Lot oculis, vidit omnem circa regionem Jordanis, quæ universa irrigabatur antequam subverteret Dominus Sodomam et Gomorrham, sicut paradisus Domini, et sicut Ægyptus venientibus in Segor. ");
INSERT INTO latVUC_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Elegitque sibi Lot regionem circa Jordanem, et recessit ab oriente: divisique sunt alterutrum a fratre suo. ");
INSERT INTO latVUC_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram habitavit in terra Chanaan; Lot vero moratus est in oppidis, quæ erant circa Jordanem, et habitavit in Sodomis. ");
INSERT INTO latVUC_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Homines autem Sodomitæ pessimi erant, et peccatores coram Domino nimis. ");
INSERT INTO latVUC_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Dixitque Dominus ad Abram, postquam divisus est ab eo Lot: Leva oculos tuos et vide a loco, in quo nunc es, ad aquilonem et meridiem, ad orientem et occidentem. ");
INSERT INTO latVUC_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Omnem terram, quam conspicis, tibi dabo, et semini tuo usque in sempiternum. ");
INSERT INTO latVUC_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Faciamque semen tuum sicut pulverem terræ: si quis potest hominum numerare pulverem terræ, semen quoque tuum numerare poterit. ");
INSERT INTO latVUC_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Surge, et perambula terram in longitudine et in latitudine sua: quia tibi daturus sum eam. ");
INSERT INTO latVUC_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Movens igitur tabernaculum suum Abram, venit, et habitavit juxta convallem Mambre, quæ est in Hebron: ædificavitque ibi altare Domino. ");
INSERT INTO latVUC_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Factum est autem in illo tempore, ut Amraphel rex Sennaar, et Arioch rex Ponti, et Chodorlahomor rex Elamitarum, et Thadal rex gentium ");
INSERT INTO latVUC_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","inirent bellum contra Bara regem Sodomorum, et contra Bersa regem Gomorrhæ, et contra Sennaab regem Adamæ, et contra Semeber regem Seboim, contraque regem Balæ, ipsa est Segor. ");
INSERT INTO latVUC_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Omnes hi convenerunt in vallem Silvestrem, quæ nunc est mare salis. ");
INSERT INTO latVUC_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Duodecim enim annis servierunt Chodorlahomor, et tertiodecimo anno recesserunt ab eo. ");
INSERT INTO latVUC_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Igitur quartodecimo anno venit Chodorlahomor, et reges qui erant cum eo: percusseruntque Raphaim in Astarothcarnaim, et Zuzim cum eis, et Emim in Save Cariathaim, ");
INSERT INTO latVUC_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","et Chorræos in montibus Seir, usque ad Campestria Pharan, quæ est in solitudine. ");
INSERT INTO latVUC_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Reversique sunt, et venerunt ad fontem Misphat, ipsa est Cades: et percusserunt omnem regionem Amalecitarum, et Amorrhæum, qui habitabat in Asasonthamar. ");
INSERT INTO latVUC_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Et egressi sunt rex Sodomorum, et rex Gomorrhæ, rexque Adamæ, et rex Seboim, necnon et rex Balæ, quæ est Segor: et direxerunt aciem contra eos in valle Silvestri: ");
INSERT INTO latVUC_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","scilicet adversus Chodorlahomor regem Elamitarum, et Thadal regem Gentium, et Amraphel regem Sennaar, et Arioch regem Ponti: quatuor reges adversus quinque. ");
INSERT INTO latVUC_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Vallis autem Silvestris habebat puteos multos bituminis. Itaque rex Sodomorum, et Gomorrhæ, terga verterunt, cecideruntque ibi: et qui remanserant, fugerunt ad montem. ");
INSERT INTO latVUC_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tulerunt autem omnem substantiam Sodomorum et Gomorrhæ, et universa quæ ad cibum pertinent, et abierunt: ");
INSERT INTO latVUC_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","necnon et Lot, et substantiam ejus, filium fratris Abram, qui habitabat in Sodomis. ");
INSERT INTO latVUC_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Et ecce unus, qui evaserat, nuntiavit Abram Hebræo, qui habitabat in convalle Mambre Amorrhæi, fratris Escol, et fratris Aner: hi enim pepigerant fœdus cum Abram. ");
INSERT INTO latVUC_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Quod cum audisset Abram, captum videlicet Lot fratrem suum, numeravit expeditos vernaculos suos trecentos decem et octo: et persecutus est usque Dan. ");
INSERT INTO latVUC_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Et divisis sociis, irruit super eos nocte: percussitque eos, et persecutus est eos usque Hoba, quæ est ad lævam Damasci. ");
INSERT INTO latVUC_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Reduxitque omnem substantiam, et Lot fratrem suum cum substantia illius, mulieres quoque et populum. ");
INSERT INTO latVUC_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Egressus est autem rex Sodomorum in occursum ejus postquam reversus est a cæde Chodorlahomor, et regum qui cum eo erant in valle Save, quæ est vallis regis. ");
INSERT INTO latVUC_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","At vero Melchisedech rex Salem, proferens panem et vinum, erat enim sacerdos Dei altissimi, ");
INSERT INTO latVUC_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","benedixit ei, et ait: Benedictus Abram Deo excelso, qui creavit cælum et terram: ");
INSERT INTO latVUC_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","et benedictus Deus excelsus, quo protegente, hostes in manibus tuis sunt. Et dedit ei decimas ex omnibus. ");
INSERT INTO latVUC_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Dixit autem rex Sodomorum ad Abram: Da mihi animas, cetera tolle tibi. ");
INSERT INTO latVUC_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Qui respondit ei: Levo manum meam ad Dominum Deum excelsum possessorem cæli et terræ, ");
INSERT INTO latVUC_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","quod a filo subtegminis usque ad corigiam caligæ, non accipiam ex omnibus quæ tua sunt, ne dicas: Ego ditavi Abram: ");
INSERT INTO latVUC_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","exceptis his, quæ comederunt juvenes, et partibus virorum, qui venerunt mecum, Aner, Escol et Mambre: isti accipient partes suas. ");
INSERT INTO latVUC_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","His itaque transactis, factus est sermo Domini ad Abram per visionem dicens: Noli timere, Abram: ego protector tuus sum, et merces tua magna nimis. ");
INSERT INTO latVUC_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Dixitque Abram: Domine Deus, quid dabis mihi? ego vadam absque liberis, et filius procuratoris domus meæ iste Damascus Eliezer. ");
INSERT INTO latVUC_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Addiditque Abram: Mihi autem non dedisti semen, et ecce vernaculus meus, hæres meus erit. ");
INSERT INTO latVUC_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Statimque sermo Domini factus est ad eum, dicens: Non erit hic hæres tuus, sed qui egredietur de utero tuo, ipsum habebis hæredem. ");
INSERT INTO latVUC_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Eduxitque eum foras, et ait illi: Suspice cælum, et numera stellas, si potes. Et dixit ei: Sic erit semen tuum. ");
INSERT INTO latVUC_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Credidit Abram Deo, et reputatum est illi ad justitiam. ");
INSERT INTO latVUC_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Dixitque ad eum: Ego Dominus qui eduxi te de Ur Chaldæorum ut darem tibi terram istam, et possideres eam. ");
INSERT INTO latVUC_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","At ille ait: Domine Deus, unde scire possum quod possessurus sim eam? ");
INSERT INTO latVUC_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Et respondens Dominus: Sume, inquit, mihi vaccam triennem, et capram trimam, et arietem annorum trium, turturem quoque et columbam. ");
INSERT INTO latVUC_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Qui tollens universa hæc, divisit ea per medium, et utrasque partes contra se altrinsecus posuit; aves autem non divisit. ");
INSERT INTO latVUC_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Descenderuntque volucres super cadavera, et abigebat eas Abram. ");
INSERT INTO latVUC_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Cumque sol occumberet, sopor irruit super Abram, et horror magnus et tenebrosus invasit eum. ");
INSERT INTO latVUC_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Dictumque est ad eum: Scito prænoscens quod peregrinum futurum sit semen tuum in terra non sua, et subjicient eos servituti, et affligent quadringentis annis. ");
INSERT INTO latVUC_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Verumtamen gentem, cui servituri sunt, ego judicabo: et post hæc egredientur cum magna substantia. ");
INSERT INTO latVUC_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tu autem ibis ad patres tuos in pace, sepultus in senectute bona. ");
INSERT INTO latVUC_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Generatione autem quarta revertentur huc: necdum enim completæ sunt iniquitates Amorrhæorum usque ad præsens tempus. ");
INSERT INTO latVUC_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Cum ergo occubuisset sol, facta est caligo tenebrosa, et apparuit clibanus fumans, et lampas ignis transiens inter divisiones illas. ");
INSERT INTO latVUC_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","In illo die pepigit Dominus fœdus cum Abram, dicens: Semini tuo dabo terram hanc a fluvio Ægypti usque ad fluvium magnum Euphraten, ");
INSERT INTO latVUC_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Cinæos, et Cenezæos, Cedmonæos, ");
INSERT INTO latVUC_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","et Hethæos, et Pherezæos, Raphaim quoque, ");
INSERT INTO latVUC_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","et Amorrhæos, et Chananæos, et Gergesæos, et Jebusæos. ");
INSERT INTO latVUC_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Igitur Sarai, uxor Abram, non genuerat liberos: sed habens ancillam ægyptiam nomine Agar, ");
INSERT INTO latVUC_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","dixit marito suo: Ecce, conclusit me Dominus, ne parerem. Ingredere ad ancillam meam, si forte saltem ex illa suscipiam filios. Cumque ille acquiesceret deprecanti, ");
INSERT INTO latVUC_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","tulit Agar ægyptiam ancillam suam post annos decem quam habitare cœperant in terra Chanaan: et dedit eam viro suo uxorem. ");
INSERT INTO latVUC_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Qui ingressus est ad eam. At illa concepisse se videns, despexit dominam suam. ");
INSERT INTO latVUC_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Dixitque Sarai ad Abram: Inique agis contra me: ego dedi ancillam meam in sinum tuum, quæ videns quod conceperit, despectui me habet: judicet Dominus inter me et te. ");
INSERT INTO latVUC_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Cui respondens Abram: Ecce, ait, ancilla tua in manu tua est, utere ea ut libet. Affligente igitur eam Sarai, fugam iniit. ");
INSERT INTO latVUC_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Cumque invenisset eam angelus Domini juxta fontem aquæ in solitudine, qui est in via Sur in deserto, ");
INSERT INTO latVUC_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","dixit ad illam: Agar ancilla Sarai, unde venis? et quo vadis? Quæ respondit: A facie Sarai dominæ meæ ego fugio. ");
INSERT INTO latVUC_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Dixitque ei angelus Domini: Revertere ad dominam tuam, et humiliare sub manu illius. ");
INSERT INTO latVUC_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Et rursum: Multiplicans, inquit, multiplicabo semen tuum, et non numerabitur præ multitudine. ");
INSERT INTO latVUC_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ac deinceps: Ecce, ait, concepisti, et paries filium: vocabisque nomen ejus Ismaël, eo quod audierit Dominus afflictionem tuam. ");
INSERT INTO latVUC_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Hic erit ferus homo: manus ejus contra omnes, et manus omnium contra eum: et e regione universorum fratrum suorum figet tabernacula. ");
INSERT INTO latVUC_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Vocavit autem nomen Domini qui loquebatur ad eam: Tu Deus qui vidisti me. Dixit enim: Profecto hic vidi posteriora videntis me. ");
INSERT INTO latVUC_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Propterea appellavit puteum illum Puteum viventis et videntis me. Ipse est inter Cades et Barad. ");
INSERT INTO latVUC_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Peperitque Agar Abræ filium: qui vocavit nomen ejus Ismaël. ");
INSERT INTO latVUC_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Octoginta et sex annorum erat Abram quando peperit ei Agar Ismaëlem. ");
INSERT INTO latVUC_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Postquam vero nonaginta et novem annorum esse cœperat, apparuit ei Dominus, dixitque ad eum: Ego Deus omnipotens: ambula coram me, et esto perfectus. ");
INSERT INTO latVUC_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ponamque fœdus meum inter me et te, et multiplicabo te vehementer nimis. ");
INSERT INTO latVUC_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Cecidit Abram pronus in faciem. ");
INSERT INTO latVUC_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Dixitque ei Deus: Ego sum, et pactum meum tecum, erisque pater multarum gentium. ");
INSERT INTO latVUC_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nec ultra vocabitur nomen tuum Abram, sed appellaberis Abraham: quia patrem multarum gentium constitui te. ");
INSERT INTO latVUC_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Faciamque te crescere vehementissime, et ponam te in gentibus, regesque ex te egredientur. ");
INSERT INTO latVUC_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Et statuam pactum meum inter me et te, et inter semen tuum post te in generationibus suis, fœdere sempiterno: ut sim Deus tuus, et seminis tui post te. ");
INSERT INTO latVUC_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Daboque tibi et semini tuo terram peregrinationis tuæ, omnem terram Chanaan in possessionem æternam, eroque Deus eorum. ");
INSERT INTO latVUC_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dixit iterum Deus ad Abraham: Et tu ergo custodies pactum meum, et semen tuum post te in generationibus suis. ");
INSERT INTO latVUC_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Hoc est pactum meum quod observabitis inter me et vos, et semen tuum post te: circumcidetur ex vobis omne masculinum: ");
INSERT INTO latVUC_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","et circumcidetis carnem præputii vestri, ut sit in signum fœderis inter me et vos. ");
INSERT INTO latVUC_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Infans octo dierum circumcidetur in vobis, omne masculinum in generationibus vestris: tam vernaculus, quam emptitius circumcidetur, et quicumque non fuerit de stirpe vestra: ");
INSERT INTO latVUC_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","eritque pactum meum in carne vestra in fœdus æternum. ");
INSERT INTO latVUC_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Masculus, cujus præputii caro circumcisa non fuerit, delebitur anima illa de populo suo: quia pactum meum irritum fecit. ");
INSERT INTO latVUC_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dixit quoque Deus ad Abraham: Sarai uxorem tuam non vocabis Sarai, sed Saram. ");
INSERT INTO latVUC_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Et benedicam ei, et ex illa dabo tibi filium cui benedicturus sum: eritque in nationes, et reges populorum orientur ex eo. ");
INSERT INTO latVUC_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Cecidit Abraham in faciem suam, et risit, dicens in corde suo: Putasne centenario nascetur filius? et Sara nonagenaria pariet? ");
INSERT INTO latVUC_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Dixitque ad Deum: Utinam Ismaël vivat coram te. ");
INSERT INTO latVUC_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Et ait Deus ad Abraham: Sara uxor tua pariet tibi filium, vocabisque nomen ejus Isaac, et constituam pactum meum illi in fœdus sempiternum, et semini ejus post eum. ");
INSERT INTO latVUC_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Super Ismaël quoque exaudivi te: ecce, benedicam ei, et augebo, et multiplicabo eum valde: duodecim duces generabit, et faciam illum in gentem magnam. ");
INSERT INTO latVUC_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pactum vero meum statuam ad Isaac, quem pariet tibi Sara tempore isto in anno altero. ");
INSERT INTO latVUC_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Cumque finitus esset sermo loquentis cum eo, ascendit Deus ab Abraham. ");
INSERT INTO latVUC_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Tulit autem Abraham Ismaël filium suum, et omnes vernaculos domus suæ, universosque quos emerat, cunctos mares ex omnibus viris domus suæ: et circumcidit carnem præputii eorum statim in ipsa die, sicut præceperat ei Deus. ");
INSERT INTO latVUC_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham nonaginta et novem erat annorum quando circumcidit carnem præputii sui. ");
INSERT INTO latVUC_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Et Ismaël filius tredecim annos impleverat tempore circumcisionis suæ. ");
INSERT INTO latVUC_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Eadem die circumcisus est Abraham et Ismaël filius ejus: ");
INSERT INTO latVUC_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","et omnes viri domus illius, tam vernaculi, quam emptitii et alienigenæ pariter circumcisi sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Apparuit autem ei Dominus in convalle Mambre sedenti in ostio tabernaculi sui in ipso fervore diei. ");
INSERT INTO latVUC_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Cumque elevasset oculos, apparuerunt ei tres viri stantes prope eum: quos cum vidisset, cucurrit in occursum eorum de ostio tabernaculi, et adoravit in terram. ");
INSERT INTO latVUC_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Et dixit: Domine, si inveni gratiam in oculis tuis, ne transeas servum tuum: ");
INSERT INTO latVUC_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","sed afferam pauxillum aquæ, et lavate pedes vestros, et requiescite sub arbore. ");
INSERT INTO latVUC_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ponamque buccellam panis, et confortate cor vestrum: postea transibitis: idcirco enim declinastis ad servum vestrum. Qui dixerunt: Fac ut locutus es. ");
INSERT INTO latVUC_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Festinavit Abraham in tabernaculum ad Saram, dixitque ei: Accelera, tria sata similæ commisce, et fac subcinericios panes. ");
INSERT INTO latVUC_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ipse vero ad armentum cucurrit, et tulit inde vitulum tenerrimum et optimum, deditque puero: qui festinavit et coxit illum. ");
INSERT INTO latVUC_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tulit quoque butyrum et lac, et vitulum quem coxerat, et posuit coram eis: ipse vero stabat juxta eos sub arbore. ");
INSERT INTO latVUC_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Cumque comedissent, dixerunt ad eum: Ubi est Sara uxor tua? Ille respondit: Ecce in tabernaculo est. ");
INSERT INTO latVUC_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Cui dixit: Revertens veniam ad te tempore isto, vita comite, et habebit filium Sara uxor tua. Quo audito, Sara risit post ostium tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Erant autem ambo senes, provectæque ætatis, et desierant Saræ fieri muliebria. ");
INSERT INTO latVUC_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Quæ risit occulte dicens: Postquam consenui, et dominus meus vetulus est, voluptati operam dabo? ");
INSERT INTO latVUC_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Dixit autem Dominus ad Abraham: Quare risit Sara, dicens: Num vere paritura sum anus? ");
INSERT INTO latVUC_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Numquid Deo quidquam est difficile? juxta condictum revertar ad te hoc eodem tempore, vita comite, et habebit Sara filium. ");
INSERT INTO latVUC_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Negavit Sara, dicens: Non risi, timore perterrita. Dominus autem: Non est, inquit, ita: sed risisti. ");
INSERT INTO latVUC_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Cum ergo surrexissent inde viri, direxerunt oculos contra Sodomam: et Abraham simul gradiebatur, deducens eos. ");
INSERT INTO latVUC_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Dixitque Dominus: Num celare potero Abraham quæ gesturus sum: ");
INSERT INTO latVUC_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","cum futurus sit in gentem magnam, ac robustissimam, et benedicendæ sint in illo omnes nationes terræ? ");
INSERT INTO latVUC_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Scio enim quod præcepturus sit filiis suis, et domui suæ post se ut custodiant viam Domini, et faciant judicium et justitiam: ut adducat Dominus propter Abraham omnia quæ locutus est ad eum. ");
INSERT INTO latVUC_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Dixit itaque Dominus: Clamor Sodomorum et Gomorrhæ multiplicatus est, et peccatum eorum aggravatum est nimis. ");
INSERT INTO latVUC_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Descendam, et videbo utrum clamorem qui venit ad me, opere compleverint; an non est ita, ut sciam. ");
INSERT INTO latVUC_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Converteruntque se inde, et abierunt Sodomam: Abraham vero adhuc stabat coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Et appropinquans ait: Numquid perdes justum cum impio? ");
INSERT INTO latVUC_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","si fuerint quinquaginta justi in civitate, peribunt simul? et non parces loco illi propter quinquaginta justos, si fuerint in eo? ");
INSERT INTO latVUC_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Absit a te ut rem hanc facias, et occidas justum cum impio, fiatque justus sicut impius, non est hoc tuum: qui judicas omnem terram, nequaquam facies judicium hoc. ");
INSERT INTO latVUC_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Dixitque Dominus ad eum: Si invenero Sodomis quinquaginta justos in medio civitatis, dimittam omni loco propter eos. ");
INSERT INTO latVUC_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Respondensque Abraham, ait: Quia semel cœpi, loquar ad Dominum meum, cum sim pulvis et cinis. ");
INSERT INTO latVUC_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Quid si minus quinquaginta justis quinque fuerint? delebis, propter quadraginta quinque, universam urbem? Et ait: Non delebo, si invenero ibi quadraginta quinque. ");
INSERT INTO latVUC_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Rursumque locutus est ad eum: Sin autem quadraginta ibi inventi fuerint, quid facies? Ait: Non percutiam propter quadraginta. ");
INSERT INTO latVUC_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ne quæso, inquit, indigneris, Domine, si loquar: quid si ibi inventi fuerint triginta? Respondit: Non faciam, si invenero ibi triginta. ");
INSERT INTO latVUC_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Quia semel, ait, cœpi loquar ad Dominum meum: quid si ibi inventi fuerint viginti? Ait: Non interficiam propter viginti. ");
INSERT INTO latVUC_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Obsecro, inquit, ne irascaris, Domine, si loquar adhuc semel: quid si inventi fuerint ibi decem? Et dixit: Non delebo propter decem. ");
INSERT INTO latVUC_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Abiitque Dominus, postquam cessavit loqui ad Abraham: et ille reversus est in locum suum. ");
INSERT INTO latVUC_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Veneruntque duo angeli Sodomam vespere, et sedente Lot in foribus civitatis. Qui cum vidisset eos, surrexit, et ivit obviam eis: adoravitque pronus in terram, ");
INSERT INTO latVUC_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","et dixit: Obsecro, domini, declinate in domum pueri vestri, et manete ibi: lavate pedes vestros, et mane proficiscemini in viam vestram. Qui dixerunt: Minime, sed in platea manebimus. ");
INSERT INTO latVUC_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Compulit illos oppido ut diverterent ad eum: ingressisque domum illius fecit convivium, et coxit azyma, et comederunt. ");
INSERT INTO latVUC_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Prius autem quam irent cubitum, viri civitatis vallaverunt domum a puero usque ad senem, omnis populus simul. ");
INSERT INTO latVUC_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Vocaveruntque Lot, et dixerunt ei: Ubi sunt viri qui introierunt ad te nocte? educ illos huc, ut cognoscamus eos. ");
INSERT INTO latVUC_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Egressus ad eos Lot, post tergum occludens ostium, ait: ");
INSERT INTO latVUC_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Nolite, quæso, fratres mei, nolite malum hoc facere. ");
INSERT INTO latVUC_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Habeo duas filias, quæ necdum cognoverunt virum: educam eas ad vos, et abutimini eis sicut vobis placuerit, dummodo viris istis nihil mali faciatis, quia ingressi sunt sub umbra culminis mei. ");
INSERT INTO latVUC_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","At illi dixerunt: Recede illuc. Et rursus: Ingressus es, inquiunt, ut advena; numquid ut judices? te ergo ipsum magis quam hos affligemus. Vimque faciebant Lot vehementissime: jamque prope erat ut effringerent fores. ");
INSERT INTO latVUC_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Et ecce miserunt manum viri, et introduxerunt ad se Lot, clauseruntque ostium: ");
INSERT INTO latVUC_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","et eos, qui foris erant, percusserunt cæcitate a minimo usque ad maximum, ita ut ostium invenire non possent. ");
INSERT INTO latVUC_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Dixerunt autem ad Lot: Habes hic quempiam tuorum? generum, aut filios, aut filias, omnes, qui tui sunt, educ de urbe hac: ");
INSERT INTO latVUC_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","delebimus enim locum istum, eo quod increverit clamor eorum coram Domino, qui misit nos ut perdamus illos. ");
INSERT INTO latVUC_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Egressus itaque Lot, locutus est ad generos suos qui accepturi erant filias ejus, et dixit: Surgite, egredimini de loco isto: quia delebit Dominus civitatem hanc. Et visus est eis quasi ludens loqui. ");
INSERT INTO latVUC_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Cumque esset mane, cogebant eum angeli, dicentes: Surge, tolle uxorem tuam, et duas filias quas habes: ne et tu pariter pereas in scelere civitatis. ");
INSERT INTO latVUC_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Dissimulante illo, apprehenderunt manum ejus, et manum uxoris, ac duarum filiarum ejus, eo quod parceret Dominus illi. ");
INSERT INTO latVUC_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Eduxeruntque eum, et posuerunt extra civitatem: ibique locuti sunt ad eum, dicentes: Salva animam tuam: noli respicere post tergum, nec stes in omni circa regione: sed in monte salvum te fac, ne et tu simul pereas. ");
INSERT INTO latVUC_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Dixitque Lot ad eos: Quæso, domine mi, ");
INSERT INTO latVUC_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","quia invenit servus tuus gratiam coram te, et magnificasti misericordiam tuam quam fecisti mecum, ut salvares animam meam, nec possum in monte salvari, ne forte apprehendat me malum, et moriar: ");
INSERT INTO latVUC_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","est civitas hæc juxta, ad quam possum fugere, parva, et salvabor in ea: numquid non modica est, et vivet anima mea? ");
INSERT INTO latVUC_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Dixitque ad eum: Ecce etiam in hoc suscepi preces tuas, ut non subvertam urbem pro qua locutus es. ");
INSERT INTO latVUC_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Festina, et salvare ibi: quia non potero facere quidquam donec ingrediaris illuc. Idcirco vocatum est nomen urbis illius Segor. ");
INSERT INTO latVUC_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Sol egressus est super terram, et Lot ingressus est Segor. ");
INSERT INTO latVUC_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Igitur Dominus pluit super Sodomam et Gomorrham sulphur et ignem a Domino de cælo: ");
INSERT INTO latVUC_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","et subvertit civitates has, et omnem circa regionem, universos habitatores urbium, et cuncta terræ virentia. ");
INSERT INTO latVUC_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Respiciensque uxor ejus post se, versa est in statuam salis. ");
INSERT INTO latVUC_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham autem consurgens mane, ubi steterat prius cum Domino, ");
INSERT INTO latVUC_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","intuitus est Sodomam et Gomorrham, et universam terram regionis illius: viditque ascendentem favillam de terra quasi fornacis fumum. ");
INSERT INTO latVUC_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Cum enim subverteret Deus civitates regionis illius, recordatus Abrahæ, liberavit Lot de subversione urbium in quibus habitaverat. ");
INSERT INTO latVUC_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ascenditque Lot de Segor, et mansit in monte, duæ quoque filiæ ejus cum eo (timuerat enim manere in Segor) et mansit in spelunca ipse, et duæ filiæ ejus cum eo. ");
INSERT INTO latVUC_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Dixitque major ad minorem: Pater noster senex est, et nullus virorum remansit in terra, qui possit ingredi ad nos juxta morem universæ terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Veni, inebriemus eum vino, dormiamusque cum eo, ut servare possimus ex patre nostro semen. ");
INSERT INTO latVUC_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Dederunt itaque patri suo bibere vinum nocte illa. Et ingressa est major, dormivitque cum patre; at ille non sensit, nec quando accubuit filia, nec quando surrexit. ");
INSERT INTO latVUC_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Altera quoque die dixit major ad minorem: Ecce dormivi heri cum patre meo, demus ei bibere vinum etiam hac nocte, et dormies cum eo, ut salvemus semen de patre nostro. ");
INSERT INTO latVUC_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Dederunt etiam et illa nocte patri suo bibere vinum, ingressaque minor filia, dormivit cum eo: et ne tunc quidem sensit quando concubuerit, vel quando illa surrexerit. ");
INSERT INTO latVUC_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Conceperunt ergo duæ filiæ Lot de patre suo. ");
INSERT INTO latVUC_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Peperitque major filium, et vocavit nomen ejus Moab: ipse est pater Moabitarum usque in præsentem diem. ");
INSERT INTO latVUC_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Minor quoque peperit filium, et vocavit nomen ejus Ammon, id est, Filius populi mei: ipse est pater Ammonitarum usque hodie. ");
INSERT INTO latVUC_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Profectus inde Abraham in terram australem, habitavit inter Cades et Sur: et peregrinatus est in Geraris. ");
INSERT INTO latVUC_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Dixitque de Sara uxore suo: Soror mea est. Misit ergo Abimelech rex Geraræ, et tulit eam. ");
INSERT INTO latVUC_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Venit autem Deus ad Abimelech per somnium nocte, et ait illi: En morieris propter mulierem quam tulisti: habet enim virum. ");
INSERT INTO latVUC_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech vero non tetigerat eam, et ait: Domine, num gentem ignorantem et justam interficies? ");
INSERT INTO latVUC_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","nonne ipse dixit mihi: Soror mea est: et ipsa ait: Frater meus est? In simplicitate cordis mei, et munditia manuum mearum feci hoc. ");
INSERT INTO latVUC_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dixitque ad eum Deus: Et ego scio quod simplici corde feceris: et ideo custodivi te ne peccares in me, et non dimisi ut tangeres eam. ");
INSERT INTO latVUC_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nunc ergo redde viro suo uxorem, quia propheta est: et orabit pro te, et vives: si autem nolueris reddere, scito quod morte morieris tu, et omnia quæ tua sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Statimque de nocte consurgens Abimelech, vocavit omnes servos suos: et locutus est universa verba hæc in auribus eorum, timueruntque omnes viri valde. ");
INSERT INTO latVUC_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Vocavit autem Abimelech etiam Abraham, et dixit ei: Quid fecisti nobis? quid peccavimus in te, quia induxisti super me et super regnum meum peccatum grande? quæ non debuisti facere, fecisti nobis. ");
INSERT INTO latVUC_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Rursumque expostulans, ait: Quid vidisti, ut hoc faceres? ");
INSERT INTO latVUC_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Respondit Abraham: Cogitavi mecum, dicens: Forsitan non est timor Dei in loco isto: et interficient me propter uxorem meam: ");
INSERT INTO latVUC_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","alias autem et vere soror mea est, filia patris mei, et non filia matris meæ, et duxi eam in uxorem. ");
INSERT INTO latVUC_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Postquam autem eduxit me Deus de domo patris mei, dixi ad eam: Hanc misericordiam facies mecum: in omni loco, ad quem ingrediemur, dices quod frater tuus sim. ");
INSERT INTO latVUC_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tulit igitur Abimelech oves et boves, et servos et ancillas, et dedit Abraham: reddiditque illi Saram uxorem suam, ");
INSERT INTO latVUC_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","et ait: Terra coram vobis est, ubicumque tibi placuerit habita. ");
INSERT INTO latVUC_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saræ autem dixit: Ecce mille argenteos dedi fratri tuo, hoc erit tibi in velamen oculorum ad omnes qui tecum sunt, et quocumque perrexeris: mementoque te deprehensam. ");
INSERT INTO latVUC_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Orante autem Abraham, sanavit Deus Abimelech et uxorem, ancillasque ejus, et pepererunt: ");
INSERT INTO latVUC_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","concluserat enim Dominus omnem vulvam domus Abimelech propter Saram uxorem Abrahæ. ");
INSERT INTO latVUC_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Visitavit autem Dominus Saram, sicut promiserat: et implevit quæ locutus est. ");
INSERT INTO latVUC_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Concepitque et peperit filium in senectute sua, tempore quo prædixerat ei Deus. ");
INSERT INTO latVUC_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Vocavitque Abraham nomen filii sui, quem genuit ei Sara, Isaac: ");
INSERT INTO latVUC_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","et circumcidit eum octavo die, sicut præceperat ei Deus, ");
INSERT INTO latVUC_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","cum centum esset annorum: hac quippe ætate patris, natus est Isaac. ");
INSERT INTO latVUC_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Dixitque Sara: Risum fecit mihi Deus: quicumque audierit, corridebit mihi. ");
INSERT INTO latVUC_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Rursumque ait: Quis auditurus crederet Abraham quod Sara lactaret filium, quem peperit ei jam seni? ");
INSERT INTO latVUC_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Crevit igitur puer, et ablactatus est: fecitque Abraham grande convivium in die ablactationis ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Cumque vidisset Sara filium Agar Ægyptiæ ludentem cum Isaac filio suo, dixit ad Abraham: ");
INSERT INTO latVUC_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ejice ancillam hanc, et filium ejus: non enim erit hæres filius ancillæ cum filio meo Isaac. ");
INSERT INTO latVUC_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Dure accepit hoc Abraham pro filio suo. ");
INSERT INTO latVUC_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Cui dixit Deus: Non tibi videatur asperum super puero, et super ancilla tua: omnia quæ dixerit tibi Sara, audi vocem ejus: quia in Isaac vocabitur tibi semen. ");
INSERT INTO latVUC_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Sed et filium ancillæ faciam in gentem magnam, quia semen tuum est. ");
INSERT INTO latVUC_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Surrexit itaque Abraham mane, et tollens panem et utrem aquæ, imposuit scapulæ ejus, tradiditque puerum, et dimisit eam. Quæ cum abiisset, errabat in solitudine Bersabee. ");
INSERT INTO latVUC_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Cumque consumpta esset aqua in utre, abjecit puerum subter unam arborum, quæ ibi erant. ");
INSERT INTO latVUC_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Et abiit, seditque e regione procul quantum potest arcus jacere: dixit enim: Non videbo morientem puerum: et sedens contra, levavit vocem suam et flevit. ");
INSERT INTO latVUC_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Exaudivit autem Deus vocem pueri: vocavitque angelus Dei Agar de cælo, dicens: Quid agis Agar? noli timere: exaudivit enim Deus vocem pueri de loco in quo est. ");
INSERT INTO latVUC_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Surge, tolle puerum, et tene manum illius: quia in gentem magnam faciam eum. ");
INSERT INTO latVUC_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Aperuitque oculos ejus Deus: quæ videns puteum aquæ, abiit, et implevit utrem, deditque puero bibere. ");
INSERT INTO latVUC_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Et fuit cum eo: qui crevit, et moratus est in solitudine, factusque est juvenis sagittarius. ");
INSERT INTO latVUC_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Habitavitque in deserto Pharan, et accepit illi mater sua uxorem de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Eodem tempore dixit Abimelech, et Phicol princeps exercitus ejus, ad Abraham: Deus tecum est in universis quæ agis. ");
INSERT INTO latVUC_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Jura ergo per Deum, ne noceas mihi, et posteris meis, stirpique meæ: sed juxta misericordiam, quam feci tibi, facies mihi, et terræ in qua versatus es advena. ");
INSERT INTO latVUC_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Dixitque Abraham: Ego jurabo. ");
INSERT INTO latVUC_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Et increpavit Abimelech propter puteum aquæ quem vi abstulerunt servi ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Responditque Abimelech: Nescivi quis fecerit hanc rem: sed et tu non indicasti mihi, et ego non audivi præter hodie. ");
INSERT INTO latVUC_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tulit itaque Abraham oves et boves, et dedit Abimelech: percusseruntque ambo fœdus. ");
INSERT INTO latVUC_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Et statuit Abraham septem agnas gregis seorsum. ");
INSERT INTO latVUC_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Cui dixit Abimelech: Quid sibi volunt septem agnæ istæ, quas stare fecisti seorsum? ");
INSERT INTO latVUC_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","At ille: Septem, inquit, agnas accipies de manu mea: ut sint mihi in testimonium, quoniam ego fodi puteum istum. ");
INSERT INTO latVUC_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Idcirco vocatus est locus ille Bersabee: quia ibi uterque juravit. ");
INSERT INTO latVUC_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Et inierunt fœdus pro puteo juramenti. ");
INSERT INTO latVUC_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Surrexit autem Abimelech, et Phicol princeps exercitus ejus, reversique sunt in terram Palæstinorum. Abraham vero plantavit nemus in Bersabee, et invocavit ibi nomen Domini Dei æterni. ");
INSERT INTO latVUC_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Et fuit colonus terræ Palæstinorum diebus multis. ");
INSERT INTO latVUC_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Quæ postquam gesta sunt, tentavit Deus Abraham, et dixit ad eum: Abraham, Abraham. At ille respondit: Adsum. ");
INSERT INTO latVUC_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ait illi: Tolle filium tuum unigenitum, quem diligis, Isaac, et vade in terram visionis, atque ibi offeres eum in holocaustum super unum montium quem monstravero tibi. ");
INSERT INTO latVUC_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Igitur Abraham de nocte consurgens, stravit asinum suum, ducens secum duos juvenes, et Isaac filium suum: cumque concidisset ligna in holocaustum, abiit ad locum quem præceperat ei Deus. ");
INSERT INTO latVUC_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Die autem tertio, elevatis oculis, vidit locum procul: ");
INSERT INTO latVUC_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","dixitque ad pueros suos: Expectate hic cum asino: ego et puer illuc usque properantes, postquam adoraverimus, revertemur ad vos. ");
INSERT INTO latVUC_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Tulit quoque ligna holocausti, et imposuit super Isaac filium suum: ipse vero portabat in manibus ignem et gladium. Cumque duo pergerent simul, ");
INSERT INTO latVUC_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","dixit Isaac patri suo: Pater mi. At ille respondit: Quid vis, fili? Ecce, inquit, ignis et ligna: ubi est victima holocausti? ");
INSERT INTO latVUC_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Dixit autem Abraham: Deus providebit sibi victimam holocausti, fili mi. Pergebant ergo pariter. ");
INSERT INTO latVUC_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Et venerunt ad locum quem ostenderat ei Deus, in quo ædificavit altare, et desuper ligna composuit; cumque alligasset Isaac filium suum, posuit eum in altare super struem lignorum. ");
INSERT INTO latVUC_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Extenditque manum, et arripuit gladium, ut immolaret filium suum. ");
INSERT INTO latVUC_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Et ecce angelus Domini de cælo clamavit, dicens: Abraham, Abraham. Qui respondit: Adsum. ");
INSERT INTO latVUC_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Dixitque ei: Non extendas manum tuam super puerum, neque facias illi quidquam: nunc cognovi quod times Deum, et non pepercisti unigenito filio tuo propter me. ");
INSERT INTO latVUC_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Levavit Abraham oculos suos, viditque post tergum arietem inter vepres hærentem cornibus, quem assumens obtulit holocaustum pro filio. ");
INSERT INTO latVUC_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Appellavitque nomen loci illius, Dominus videt. Unde usque hodie dicitur: In monte Dominus videbit. ");
INSERT INTO latVUC_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Vocavit autem angelus Domini Abraham secundo de cælo, dicens: ");
INSERT INTO latVUC_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Per memetipsum juravi, dicit Dominus: quia fecisti hanc rem, et non pepercisti filio tuo unigenito propter me: ");
INSERT INTO latVUC_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","benedicam tibi, et multiplicabo semen tuum sicut stellas cæli, et velut arenam quæ est in littore maris: possidebit semen tuum portas inimicorum suorum, ");
INSERT INTO latVUC_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","et benedicentur in semine tuo omnes gentes terræ, quia obedisti voci meæ. ");
INSERT INTO latVUC_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Reversus est Abraham ad pueros suos, abieruntque Bersabee simul, et habitavit ibi. ");
INSERT INTO latVUC_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","His ita gestis, nuntiatum est Abrahæ quod Melcha quoque genuisset filios Nachor fratri suo: ");
INSERT INTO latVUC_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Hus primogenitum, et Buz fratrem ejus, et Camuel patrem Syrorum, ");
INSERT INTO latVUC_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","et Cased, et Azau, Pheldas quoque et Jedlaph, ");
INSERT INTO latVUC_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ac Bathuel, de quo nata est Rebecca: octo istos genuit Melcha, Nachor fratri Abrahæ. ");
INSERT INTO latVUC_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Concubina vero illius, nomine Roma, peperit Tabee, et Gaham, et Thahas, et Maacha. ");
INSERT INTO latVUC_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Vixit autem Sara centum viginti septem annis. ");
INSERT INTO latVUC_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Et mortua est in civitate Arbee, quæ est Hebron, in terra Chanaan: venitque Abraham ut plangeret et fleret eam. ");
INSERT INTO latVUC_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Cumque surrexisset ab officio funeris, locutus est ad filios Heth, dicens: ");
INSERT INTO latVUC_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Advena sum et peregrinus apud vos: date mihi jus sepulchri vobiscum, ut sepeliam mortuum meum. ");
INSERT INTO latVUC_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Responderunt filii Heth, dicentes: ");
INSERT INTO latVUC_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Audi nos, domine: princeps Dei es apud nos: in electis sepulchris nostris sepeli mortuum tuum, nullusque te prohibere poterit quin in monumento ejus sepelias mortuum tuum. ");
INSERT INTO latVUC_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Surrexit Abraham, et adoravit populum terræ, filios videlicet Heth: ");
INSERT INTO latVUC_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","dixitque ad eos: Si placet animæ vestræ ut sepeliam mortuum meum, audite me, et intercedite pro me apud Ephron filium Seor: ");
INSERT INTO latVUC_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ut det mihi speluncam duplicem, quam habet in extrema parte agri sui: pecunia digna tradat eam mihi coram vobis in possessionem sepulchri. ");
INSERT INTO latVUC_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Habitabat autem Ephron in medio filiorum Heth. Responditque Ephron ad Abraham, cunctis audientibus qui ingrediebantur portam civitatis illius, dicens: ");
INSERT INTO latVUC_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nequaquam ita fiat, domine mi, sed tu magis ausculta quod loquor. Agrum trado tibi, et speluncam quæ in eo est, præsentibus filiis populi mei; sepeli mortuum tuum. ");
INSERT INTO latVUC_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Adoravit Abraham coram populo terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Et locutus est ad Ephron circumstante plebe: Quæso ut audias me: dabo pecuniam pro agro: suscipe eam, et sic sepeliam mortuum meum in eo. ");
INSERT INTO latVUC_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Responditque Ephron: ");
INSERT INTO latVUC_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Domine mi, audi me: terra, quam postulas, quadringentis siclis argenti valet: istud est pretium inter me et te: sed quantum est hoc? sepeli mortuum tuum. ");
INSERT INTO latVUC_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Quod cum audisset Abraham, appendit pecuniam, quam Ephron postulaverat, audientibus filiis Heth, quadringentos siclos argenti probatæ monetæ publicæ. ");
INSERT INTO latVUC_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Confirmatusque est ager quondam Ephronis, in quo erat spelunca duplex, respiciens Mambre, tam ipse, quam spelunca, et omnes arbores ejus in cunctis terminis ejus per circuitum, ");
INSERT INTO latVUC_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abrahæ in possessionem, videntibus filiis Heth, et cunctis qui intrabant portam civitatis illius. ");
INSERT INTO latVUC_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Atque ita sepelivit Abraham Saram uxorem suam in spelunca agri duplici, quæ respiciebat Mambre. Hæc est Hebron in terra Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Et confirmatus est ager, et antrum quod erat in eo, Abrahæ in possessionem monumenti a filiis Heth. ");
INSERT INTO latVUC_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Erat autem Abraham senex, dierumque multorum: et Dominus in cunctis benedixerat ei. ");
INSERT INTO latVUC_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Dixitque ad servum seniorem domus suæ, qui præerat omnibus quæ habebat: Pone manum tuam subter femur meum, ");
INSERT INTO latVUC_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ut adjurem te per Dominum Deum cæli et terræ, ut non accipias uxorem filio meo de filiabus Chananæorum, inter quos habito: ");
INSERT INTO latVUC_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","sed ad terram et cognationem meam proficiscaris et inde accipias uxorem filio meo Isaac. ");
INSERT INTO latVUC_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Respondit servus: Si noluerit mulier venire mecum in terram hanc, numquid reducere debeo filium tuum ad locum, de quo egressus es? ");
INSERT INTO latVUC_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Dixitque Abraham: Cave nequando reducas filium meum illuc. ");
INSERT INTO latVUC_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Dominus Deus cæli, qui tulit me de domo patris mei, et de terra nativitatis meæ, qui locutus est mihi, et juravit mihi, dicens: Semini tuo dabo terram hanc: ipse mittet angelum suum coram te, et accipies inde uxorem filio meo: ");
INSERT INTO latVUC_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","sin autem mulier noluerit sequi te, non teneberis juramento: filium meum tantum ne reducas illuc. ");
INSERT INTO latVUC_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Posuit ergo servus manum sub femore Abraham domini sui, et juravit illi super sermone hoc. ");
INSERT INTO latVUC_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tulitque decem camelos de grege domini sui, et abiit, ex omnibus bonis ejus portans secum, profectusque perrexit in Mesopotamiam ad urbem Nachor. ");
INSERT INTO latVUC_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Cumque camelos fecisset accumbere extra oppidum juxta puteum aquæ vespere, tempore quo solent mulieres egredi ad hauriendam aquam, dixit: ");
INSERT INTO latVUC_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Domine Deus domini mei Abraham, occurre, obsecro, mihi hodie, et fac misericordiam cum domino meo Abraham. ");
INSERT INTO latVUC_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ecce ego sto prope fontem aquæ, et filiæ habitatorum hujus civitatis egredientur ad hauriendam aquam. ");
INSERT INTO latVUC_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Igitur puella, cui ego dixero: Inclina hydriam tuam ut bibam: et illa responderit: Bibe, quin et camelis tuis dabo potum: ipsa est quam præparasti servo tuo Isaac: et per hoc intelligam quod feceris misericordiam cum domino meo. ");
INSERT INTO latVUC_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Necdum intra se verba compleverat, et ecce Rebecca egrediebatur, filia Bathuel, filii Melchæ uxoris Nachor fratris Abraham, habens hydriam in scapula sua: ");
INSERT INTO latVUC_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","puella decora nimis, virgoque pulcherrima, et incognita viro: descenderat autem ad fontem, et impleverat hydriam, ac revertebatur. ");
INSERT INTO latVUC_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Occurritque ei servus, et ait: Pauxillum aquæ mihi ad bibendum præbe de hydria tua. ");
INSERT INTO latVUC_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Quæ respondit: Bibe, domine mi: celeriterque deposuit hydriam super ulnam suam, et dedit ei potum. ");
INSERT INTO latVUC_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Cumque ille bibisset, adjecit: Quin et camelis tuis hauriam aquam, donec cuncti bibant. ");
INSERT INTO latVUC_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Effundensque hydriam in canalibus, recurrit ad puteum ut hauriret aquam: et haustam omnibus camelis dedit. ");
INSERT INTO latVUC_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ipse autem contemplabatur eam tacitus, scire volens utrum prosperum iter suum fecisset Dominus, an non. ");
INSERT INTO latVUC_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Postquam autem biberunt cameli, protulit vir inaures aureas, appendentes siclos duos, et armillas totidem pondo siclorum decem. ");
INSERT INTO latVUC_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Dixitque ad eam: Cujus es filia? indica mihi, est in domo patris tui locus ad manendum? ");
INSERT INTO latVUC_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Quæ respondit: Filia sum Bathuelis, filii Melchæ, quem peperit ipsi Nachor. ");
INSERT INTO latVUC_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Et addidit, dicens: Palearum quoque et fœni plurimum est apud nos, et locus spatiosus ad manendum. ");
INSERT INTO latVUC_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Inclinavit se homo, et adoravit Dominum, ");
INSERT INTO latVUC_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","dicens: Benedictus Dominus Deus domini mei Abraham, qui non abstulit misericordiam et veritatem suam a domino meo, et recto itinere me perduxit in domum fratris domini mei. ");
INSERT INTO latVUC_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Cucurrit itaque puella, et nuntiavit in domum matris suæ omnia quæ audierat. ");
INSERT INTO latVUC_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Habebat autem Rebecca fratrem nomine Laban, qui festinus egressus est ad hominem, ubi erat fons. ");
INSERT INTO latVUC_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Cumque vidisset inaures et armillas in manibus sororis suæ, et audisset cuncta verba referentis: Hæc locutus est mihi homo: venit ad virum qui stabat juxta camelos, et prope fontem aquæ: ");
INSERT INTO latVUC_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","dixitque ad eum: Ingredere, benedicte Domini: cur foris stas? præparavi domum, et locum camelis. ");
INSERT INTO latVUC_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Et introduxit eum in hospitium: ac destravit camelos, deditque paleas et fœnum, et aquam ad lavandos pedes ejus, et virorum qui venerant cum eo. ");
INSERT INTO latVUC_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Et appositus est in conspectu ejus panis. Qui ait: Non comedam, donec loquar sermones meos. Respondit ei: Loquere. ");
INSERT INTO latVUC_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","At ille: Servus, inquit, Abraham sum: ");
INSERT INTO latVUC_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","et Dominus benedixit domino meo valde, magnificatusque est: et dedit ei oves et boves, argentum et aurum, servos et ancillas, camelos et asinos. ");
INSERT INTO latVUC_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Et peperit Sara uxor domini mei filium domino meo in senectute sua, deditque illi omnia quæ habuerat. ");
INSERT INTO latVUC_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Et adjuravit me dominus meus, dicens: Non accipies uxorem filio meo de filiabus Chananæorum, in quorum terra habito: ");
INSERT INTO latVUC_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","sed ad domum patris mei perges, et de cognatione mea accipies uxorem filio meo. ");
INSERT INTO latVUC_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ego vero respondi domino meo: Quid si noluerit venire mecum mulier? ");
INSERT INTO latVUC_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Dominus, ait, in cujus conspectu ambulo, mittet angelum suum tecum, et diriget viam tuam: accipiesque uxorem filio meo de cognatione mea, et de domo patris mei. ");
INSERT INTO latVUC_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Innocens eris a maledictione mea, cum veneris ad propinquos meos, et non dederint tibi. ");
INSERT INTO latVUC_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Veni ergo hodie ad fontem aquæ, et dixi: Domine Deus domini mei Abraham, si direxisti viam meam, in qua nunc ambulo, ");
INSERT INTO latVUC_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ecce sto juxta fontem aquæ, et virgo, quæ egredietur ad hauriendam aquam, audierit a me: Da mihi pauxillum aquæ ad bibendum ex hydria tua: ");
INSERT INTO latVUC_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","et dixerit mihi: Et tu bibe, et camelis tuis hauriam: ipsa est mulier, quam præparavit Dominus filio domini mei. ");
INSERT INTO latVUC_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Dumque hæc tacitus mecum volverem, apparuit Rebecca veniens cum hydria, quam portabat in scapula: descenditque ad fontem, et hausit aquam. Et aio ad eam: Da mihi paululum bibere. ");
INSERT INTO latVUC_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Quæ festinans deposuit hydriam de humero, et dixit mihi: Et tu bibe, et camelis tuis tribuam potum. Bibi, et adaquavit camelos. ");
INSERT INTO latVUC_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Interrogavique eam, et dixi: Cujus es filia? Quæ respondit: Filia Bathuelis sum, filii Nachor, quem peperit ei Melcha. Suspendi itaque inaures ad ornandam faciem ejus, et armillas posui in manibus ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Pronusque adoravi Dominum, benedicens Domino Deo domini mei Abraham, qui perduxit me recto itinere, ut sumerem filiam fratris domini mei filio ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Quam ob rem si facitis misericordiam et veritatem cum domino meo, indicate mihi: sin autem aliud placet, et hoc dicite mihi, ut vadam ad dextram, sive ad sinistram. ");
INSERT INTO latVUC_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Responderuntque Laban et Bathuel: A Domino egressus est sermo: non possumus extra placitum ejus quidquam aliud loqui tecum. ");
INSERT INTO latVUC_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","En Rebecca coram te est, tolle eam, et proficiscere, et sit uxor filii domini tui, sicut locutus est Dominus. ");
INSERT INTO latVUC_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Quod cum audisset puer Abraham, procidens adoravit in terram Dominum. ");
INSERT INTO latVUC_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Prolatisque vasis argenteis, et aureis, ac vestibus, dedit ea Rebeccæ pro munere: fratribus quoque ejus et matri dona obtulit. ");
INSERT INTO latVUC_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Inito convivio, vescentes pariter et bibentes manserunt ibi. Surgens autem mane, locutus est puer: Dimitte me, ut vadam ad dominum meum. ");
INSERT INTO latVUC_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Responderuntque fratres ejus et mater: Maneat puella saltem decem dies apud nos, et postea proficiscetur. ");
INSERT INTO latVUC_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Nolite, ait, me retinere, quia Dominus direxit viam meam: dimittite me ut pergam ad dominum meum. ");
INSERT INTO latVUC_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Et dixerunt: Vocemus puellam, et quæramus ipsius voluntatem. ");
INSERT INTO latVUC_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Cumque vocata venisset, sciscitati sunt: Vis ire cum homine isto? Quæ ait: Vadam. ");
INSERT INTO latVUC_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Dimiserunt ergo eam, et nutricem illius, servumque Abraham, et comites ejus, ");
INSERT INTO latVUC_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","imprecantes prospera sorori suæ, atque dicentes: Soror nostra es, crescas in mille millia, et possideat semen tuum portas inimicorum suorum. ");
INSERT INTO latVUC_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Igitur Rebecca et puellæ illius, ascensis camelis, secutæ sunt virum: qui festinus revertebatur ad dominum suum. ");
INSERT INTO latVUC_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Eo autem tempore deambulabat Isaac per viam quæ ducit ad puteum, cujus nomen est Viventis et videntis: habitabat enim in terra australi: ");
INSERT INTO latVUC_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","et egressus fuerat ad meditandum in agro, inclinata jam die: cumque elevasset oculos, vidit camelos venientes procul. ");
INSERT INTO latVUC_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebecca quoque, conspecto Isaac, descendit de camelo, ");
INSERT INTO latVUC_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","et ait ad puerum: Quis est ille homo qui venit per agrum in occursum nobis? Dixitque ei: Ipse est dominus meus. At illa tollens cito pallium, operuit se. ");
INSERT INTO latVUC_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Servus autem cuncta, quæ gesserat, narravit Isaac. ");
INSERT INTO latVUC_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Qui introduxit eam in tabernaculum Saræ matris suæ, et accepit eam uxorem: et in tantum dilexit eam, ut dolorem, qui ex morte matris ejus acciderat, temperaret. ");
INSERT INTO latVUC_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham vero aliam duxit uxorem nomine Ceturam: ");
INSERT INTO latVUC_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","quæ peperit ei Zamran et Jecsan, et Madan, et Madian, et Jesboc, et Sue. ");
INSERT INTO latVUC_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jecsan quoque genuit Saba et Dadan. Filii Dadan fuerunt Assurim, et Latusim, et Loomin. ");
INSERT INTO latVUC_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","At vero ex Madian ortus est Epha, et Opher, et Henoch, et Abida, et Eldaa: omnes hi filii Ceturæ. ");
INSERT INTO latVUC_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Deditque Abraham cuncta quæ possederat, Isaac: ");
INSERT INTO latVUC_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","filiis autem concubinarum largitus est munera, et separavit eos ab Isaac filio suo, dum adhuc ipse viveret, ad plagam orientalem. ");
INSERT INTO latVUC_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Fuerunt autem dies vitæ Abrahæ, centum septuaginta quinque anni. ");
INSERT INTO latVUC_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Et deficiens mortuus est in senectute bona, provectæque ætatis et plenus dierum: congregatusque est ad populum suum. ");
INSERT INTO latVUC_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Et sepelierunt eum Isaac et Ismaël filii sui in spelunca duplici, quæ sita est in agro Ephron filii Seor Hethæi, e regione Mambre, ");
INSERT INTO latVUC_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","quem emerat a filiis Heth: ibi sepultus est ipse, et Sara uxor ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Et post obitum illius benedixit Deus Isaac filio ejus, qui habitabat juxta puteum nomine Viventis et videntis. ");
INSERT INTO latVUC_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hæ sunt generationes Ismaël filii Abrahæ, quem peperit ei Agar Ægyptia, famula Saræ: et ");
INSERT INTO latVUC_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","hæc nomina filiorum ejus in vocabulis et generationibus suis. Primogenitus Ismaëlis Nabaioth, deinde Cedar, et Adbeel, et Mabsam, ");
INSERT INTO latVUC_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Masma quoque, et Duma, et Massa, ");
INSERT INTO latVUC_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, et Thema, et Jethur, et Naphis, et Cedma. ");
INSERT INTO latVUC_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isti sunt filii Ismaëlis: et hæc nomina per castella et oppida eorum, duodecim principes tribuum suarum. ");
INSERT INTO latVUC_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Et facti sunt anni vitæ Ismaëlis centum triginta septem, deficiensque mortuus est, et appositus ad populum suum. ");
INSERT INTO latVUC_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Habitavit autem ab Hevila usque Sur, quæ respicit Ægyptum introëuntibus Assyrios; coram cunctis fratribus suis obiit. ");
INSERT INTO latVUC_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hæ quoque sunt generationes Isaac filii Abraham: Abraham genuit Isaac: ");
INSERT INTO latVUC_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","qui cum quadraginta esset annorum, duxit uxorem Rebeccam filiam Bathuelis Syri de Mesopotamia, sororem Laban. ");
INSERT INTO latVUC_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Deprecatusque est Isaac Dominum pro uxore sua, eo quod esset sterilis: qui exaudivit eum, et dedit conceptum Rebeccæ. ");
INSERT INTO latVUC_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Sed collidebantur in utero ejus parvuli; quæ ait: Si sic mihi futurum erat, quid necesse fuit concipere? perrexitque ut consuleret Dominum. ");
INSERT INTO latVUC_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Qui respondens ait: Duæ gentes sunt in utero tuo, et duo populi ex ventre tuo dividentur, populusque populum superabit, et major serviet minori. ");
INSERT INTO latVUC_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Jam tempus pariendi advenerat, et ecce gemini in utero ejus reperti sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Qui prior egressus est, rufus erat, et totus in morem pellis hispidus: vocatumque est nomen ejus Esau. Protinus alter egrediens, plantam fratris tenebat manu: et idcirco appellavit eum Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sexagenarius erat Isaac quando nati sunt ei parvuli. ");
INSERT INTO latVUC_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Quibus adultis, factus est Esau vir gnarus venandi, et homo agricola: Jacob autem vir simplex habitabat in tabernaculis. ");
INSERT INTO latVUC_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac amabat Esau, eo quod de venationibus illius vesceretur: et Rebecca diligebat Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Coxit autem Jacob pulmentum: ad quem cum venisset Esau de agro lassus, ");
INSERT INTO latVUC_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ait: Da mihi de coctione hac rufa, quia oppido lassus sum. Quam ob causam vocatum est nomen ejus Edom. ");
INSERT INTO latVUC_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Cui dixit Jacob: Vende mihi primogenita tua. ");
INSERT INTO latVUC_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ille respondit: En morior, quid mihi proderunt primogenita? ");
INSERT INTO latVUC_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ait Jacob: Jura ergo mihi. Juravit ei Esau et vendidit primogenita. ");
INSERT INTO latVUC_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Et sic, accepto pane et lentis edulio, comedit et bibit, et abiit, parvipendens quod primogenita vendidisset. ");
INSERT INTO latVUC_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Orta autem fame super terram post eam sterilitatem, quæ acciderat in diebus Abraham, abiit Isaac ad Abimelech regem Palæstinorum in Gerara. ");
INSERT INTO latVUC_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Apparuitque ei Dominus, et ait: Ne descendas in Ægyptum, sed quiesce in terra quam dixero tibi, ");
INSERT INTO latVUC_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","et peregrinare in ea: eroque tecum, et benedicam tibi: tibi enim et semini tuo dabo universas regiones has, complens juramentum quod spopondi Abraham patri tuo. ");
INSERT INTO latVUC_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Et multiplicabo semen tuum sicut stellas cæli: daboque posteris tuis universas regiones has: et benedicentur in semine tuo omnes gentes terræ, ");
INSERT INTO latVUC_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","eo quod obedierit Abraham voci meæ, et custodierit præcepta et mandata mea, et cæremonias legesque servaverit. ");
INSERT INTO latVUC_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Mansit itaque Isaac in Geraris. ");
INSERT INTO latVUC_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Qui cum interrogaretur a viris loci illius super uxore sua, respondit: Soror mea est: timuerat enim confiteri quod sibi esset sociata conjugio, reputans ne forte interficerent eum propter illius pulchritudinem. ");
INSERT INTO latVUC_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Cumque pertransissent dies plurimi, et ibidem moraretur, prospiciens Abimelech rex Palæstinorum per fenestram, vidit eum jocantem cum Rebecca uxore sua. ");
INSERT INTO latVUC_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Et accersito eo, ait: Perspicuum est quod uxor tua sit: cur mentitus es eam sororem tuam esse? Respondit: Timui ne morerer propter eam. ");
INSERT INTO latVUC_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Dixitque Abimelech: Quare imposuisti nobis? potuit coire quispiam de populo cum uxore tua, et induxeras super nos grande peccatum. Præcepitque omni populo, dicens: ");
INSERT INTO latVUC_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Qui tetigerit hominis hujus uxorem, morte morietur. ");
INSERT INTO latVUC_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Sevit autem Isaac in terra illa, et invenit in ipso anno centuplum: benedixitque ei Dominus. ");
INSERT INTO latVUC_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Et locupletatus est homo, et ibat proficiens atque succrescens, donec magnus vehementer effectus est: ");
INSERT INTO latVUC_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","habuit quoque possessiones ovium et armentorum, et familiæ plurimum. Ob hoc invidentes ei Palæstini, ");
INSERT INTO latVUC_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","omnes puteos, quos foderant servi patris illius Abraham, illo tempore obstruxerunt, implentes humo: ");
INSERT INTO latVUC_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","in tantum, ut ipse Abimelech diceret ad Isaac: Recede a nobis, quoniam potentior nobis factus es valde. ");
INSERT INTO latVUC_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Et ille discedens, ut veniret ad torrentem Geraræ, habitaretque ibi, ");
INSERT INTO latVUC_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","rursum fodit alios puteos, quos foderant servi patris sui Abraham, et quos, illo mortuo, olim obstruxerant Philisthiim: appellavitque eos eisdem nominibus quibus ante pater vocaverat. ");
INSERT INTO latVUC_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Foderuntque in torrente, et repererunt aquam vivam. ");
INSERT INTO latVUC_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Sed et ibi jurgium fuit pastorum Geraræ adversus pastores Isaac, dicentium: Nostra est aqua, quam ob rem nomen putei ex eo, quod acciderat, vocavit Calumniam. ");
INSERT INTO latVUC_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Foderunt autem et alium: et pro illo quoque rixati sunt, appellavitque eum Inimicitias. ");
INSERT INTO latVUC_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Profectus inde fodit alium puteum, pro quo non contenderunt: itaque vocavit nomen ejus Latitudo, dicens: Nunc dilatavit nos Dominus, et fecit crescere super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ascendit autem ex illo loco in Bersabee, ");
INSERT INTO latVUC_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ubi apparuit ei Dominus in ipsa nocte, dicens: Ego sum Deus Abraham patris tui: noli timere, quia ego tecum sum: benedicam tibi, et multiplicabo semen tuum propter servum meum Abraham. ");
INSERT INTO latVUC_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Itaque ædificavit ibi altare: et invocato nomine Domini, extendit tabernaculum, præcepitque servis suis ut foderent puteum. ");
INSERT INTO latVUC_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ad quem locum cum venissent de Geraris Abimelech, et Ochozath amicus illius, et Phicol dux militum, ");
INSERT INTO latVUC_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","locutus est eis Isaac: Quid venistis ad me, hominem quem odistis, et expulistis a vobis? ");
INSERT INTO latVUC_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Qui responderunt: Vidimus tecum esse Dominum, et idcirco nos diximus: Sit juramentum inter nos, et ineamus fœdus, ");
INSERT INTO latVUC_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ut non facias nobis quidquam mali, sicut et nos nihil tuorum attigimus, nec fecimus quod te læderet: sed cum pace dimisimus auctum benedictione Domini. ");
INSERT INTO latVUC_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Fecit ergo eis convivium, et post cibum et potum ");
INSERT INTO latVUC_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","surgentes mane, juraverunt sibi mutuo: dimisitque eos Isaac pacifice in locum suum. ");
INSERT INTO latVUC_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ecce autem venerunt in ipso die servi Isaac annuntiantes ei de puteo, quem foderant, atque dicentes: Invenimus aquam. ");
INSERT INTO latVUC_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Unde appellavit eum Abundantiam: et nomen urbi impositum est Bersabee, usque in præsentem diem. ");
INSERT INTO latVUC_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau vero quadragenarius duxit uxores, Judith filiam Beeri Hethæi, et Basemath filiam Elon ejusdem loci: ");
INSERT INTO latVUC_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","quæ ambæ offenderant animum Isaac et Rebeccæ. ");
INSERT INTO latVUC_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Senuit autem Isaac, et caligaverunt oculi ejus, et videre non poterat: vocavitque Esau filium suum majorem, et dixit ei: Fili mi? Qui respondit: Adsum. ");
INSERT INTO latVUC_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Cui pater: Vides, inquit, quod senuerim, et ignorem diem mortis meæ. ");
INSERT INTO latVUC_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sume arma tua, pharetram, et arcum, et egredere foras: cumque venatu aliquid apprehenderis, ");
INSERT INTO latVUC_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","fac mihi inde pulmentum sicut velle me nosti, et affer ut comedam: et benedicat tibi anima mea antequam moriar. ");
INSERT INTO latVUC_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Quod cum audisset Rebecca, et ille abiisset in agrum ut jussionem patris impleret, ");
INSERT INTO latVUC_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","dixit filio suo Jacob: Audivi patrem tuum loquentem cum Esau fratre tuo, et dicentem ei: ");
INSERT INTO latVUC_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Affer mihi de venatione tua, et fac cibos ut comedam, et benedicam tibi coram Domino antequam moriar. ");
INSERT INTO latVUC_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nunc ergo, fili mi, acquiesce consiliis meis: ");
INSERT INTO latVUC_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","et pergens ad gregem, affer mihi duos hædos optimos, ut faciam ex eis escas patri tuo, quibus libenter vescitur: ");
INSERT INTO latVUC_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","quas cum intuleris, et comederit, benedicat tibi priusquam moriatur. ");
INSERT INTO latVUC_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Cui ille respondit: Nosti quod Esau frater meus homo pilosus sit, et ego lenis: ");
INSERT INTO latVUC_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","si attrectaverit me pater meus, et senserit, timeo ne putet me sibi voluisse illudere, et inducam super me maledictionem pro benedictione. ");
INSERT INTO latVUC_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ad quem mater: In me sit, ait, ista maledictio, fili mi: tantum audi vocem meam, et pergens, affer quæ dixi. ");
INSERT INTO latVUC_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Abiit, et attulit, deditque matri. Paravit illa cibos, sicut velle noverat patrem illius. ");
INSERT INTO latVUC_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Et vestibus Esau valde bonis, quas apud se habebat domi, induit eum: ");
INSERT INTO latVUC_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","pelliculasque hædorum circumdedit manibus, et colli nuda protexit: ");
INSERT INTO latVUC_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","deditque pulmentum, et panes, quos coxerat, tradidit. ");
INSERT INTO latVUC_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Quibus illatis, dixit: Pater mi? At ille respondit: Audio. Quis es tu, fili mi? ");
INSERT INTO latVUC_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Dixitque Jacob: Ego sum primogenitus tuus Esau: feci sicut præcepisti mihi: surge, sede, et comede de venatione mea, ut benedicat mihi anima tua. ");
INSERT INTO latVUC_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Rursumque Isaac ad filium suum: Quomodo, inquit, tam cito invenire potuisti, fili mi? Qui respondit: Voluntas Dei fuit ut cito occurreret mihi quod volebam. ");
INSERT INTO latVUC_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Dixitque Isaac: Accede huc, ut tangam te, fili mi, et probem utrum tu sis filius meus Esau, an non. ");
INSERT INTO latVUC_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Accessit ille ad patrem, et palpato eo, dixit Isaac: Vox quidem, vox Jacob est: sed manus, manus sunt Esau. ");
INSERT INTO latVUC_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Et non cognovit eum, quia pilosæ manus similitudinem majoris expresserant. Benedicens ergo illi, ");
INSERT INTO latVUC_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ait: Tu es filius meus Esau? Respondit: Ego sum. ");
INSERT INTO latVUC_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","At ille: Affer mihi, inquit, cibos de venatione tua, fili mi, ut benedicat tibi anima mea. Quos cum oblatos comedisset, obtulit ei etiam vinum. Quo hausto, ");
INSERT INTO latVUC_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","dixit ad eum: Accede ad me, et da mihi osculum, fili mi. ");
INSERT INTO latVUC_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Accessit, et osculatus est eum. Statimque ut sensit vestimentorum illius fragrantiam, benedicens illi, ait: Ecce odor filii mei sicut odor agri pleni, cui benedixit Dominus. ");
INSERT INTO latVUC_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Det tibi Deus de rore cæli et de pinguedine terræ abundantiam frumenti et vini. ");
INSERT INTO latVUC_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Et serviant tibi populi, et adorent te tribus: esto dominus fratrum tuorum, et incurventur ante te filii matris tuæ: qui maledixerit tibi, sit ille maledictus, et qui benedixerit tibi, benedictionibus repleatur. ");
INSERT INTO latVUC_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Vix Isaac sermonem impleverat, et egresso Jacob foras, venit Esau, ");
INSERT INTO latVUC_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","coctosque de venatione cibos intulit patri, dicens: Surge, pater mi, et comede de venatione filii tui, ut benedicat mihi anima tua. ");
INSERT INTO latVUC_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Dixitque illi Isaac: Quis enim es tu? Qui respondit: Ego sum filius tuus primogenitus Esau. ");
INSERT INTO latVUC_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Expavit Isaac stupore vehementi: et ultra quam credi potest admirans, ait: Quis igitur ille est qui dudum captam venationem attulit mihi, et comedi ex omnibus priusquam tu venires; benedixique ei, et erit benedictus? ");
INSERT INTO latVUC_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Auditis Esau sermonibus patris, irrugiit clamore magno: et consternatus, ait: Benedic etiam et mihi, pater mi. ");
INSERT INTO latVUC_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Qui ait: Venit germanus tuus fraudulenter, et accepit benedictionem tuam. ");
INSERT INTO latVUC_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","At ille subjunxit: Juste vocatum est nomen ejus Jacob: supplantavit enim me en altera vice: primogenita mea ante tulit, et nunc secundo surripuit benedictionem meam. Rursumque ad patrem: Numquid non reservasti, ait, et mihi benedictionem? ");
INSERT INTO latVUC_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Respondit Isaac: Dominum tuum illum constitui, et omnes fratres ejus servituti illius subjugavi; frumento et vino stabilivi eum: et tibi post hæc, fili mi, ultra quid faciam? ");
INSERT INTO latVUC_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Cui Esau: Num unam, inquit, tantum benedictionem habes, pater? mihi quoque obsecro ut benedicas. Cumque ejulatu magno fleret, ");
INSERT INTO latVUC_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","motus Isaac, dixit ad eum: In pinguedine terræ, et in rore cæli desuper, ");
INSERT INTO latVUC_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","erit benedictio tua. Vives in gladio, et fratri tuo servies: tempusque veniet, cum excutias et solvas jugum ejus de cervicibus tuis. ");
INSERT INTO latVUC_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Oderat ergo semper Esau Jacob pro benedictione qua benedixerat ei pater: dixitque in corde suo: Venient dies luctus patris mei, et occidam Jacob fratrem meum. ");
INSERT INTO latVUC_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Nuntiata sunt hæc Rebeccæ: quæ mittens et vocans Jacob filium suum, dixit ad eum: Ecce Esau frater tuus minatur ut occidat te. ");
INSERT INTO latVUC_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nunc ergo, fili mi, audi vocem meam, et consurgens fuge ad Laban fratrem meum in Haran: ");
INSERT INTO latVUC_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","habitabisque cum eo dies paucos, donec requiescat furor fratris tui, ");
INSERT INTO latVUC_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","et cesset indignatio ejus, obliviscaturque eorum quæ fecisti in eum: postea mittam, et adducam te inde huc: cur utroque orbabor filio in uno die? ");
INSERT INTO latVUC_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Dixitque Rebecca ad Isaac: Tædet me vitæ meæ propter filias Heth: si acceperit Jacob uxorem de stirpe hujus terræ, nolo vivere. ");
INSERT INTO latVUC_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Vocavit itaque Isaac Jacob, et benedixit eum, præcepitque ei dicens: Noli accipere conjugem de genere Chanaan: ");
INSERT INTO latVUC_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","sed vade, et proficiscere in Mesopotamiam Syriæ, ad domum Bathuel patris matris tuæ, et accipe tibi inde uxorem de filiabus Laban avunculi tui. ");
INSERT INTO latVUC_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Deus autem omnipotens benedicat tibi, et crescere te faciat, atque multiplicet, ut sis in turbas populorum. ");
INSERT INTO latVUC_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Et det tibi benedictiones Abrahæ, et semini tuo post te: ut possideas terram peregrinationis tuæ, quam pollicitus est avo tuo. ");
INSERT INTO latVUC_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Cumque dimisisset eum Isaac, profectus venit in Mesopotamiam Syriæ ad Laban filium Bathuel Syri, fratrem Rebeccæ matris suæ. ");
INSERT INTO latVUC_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Videns autem Esau quod benedixisset pater suus Jacob, et misisset eum in Mesopotamiam Syriæ, ut inde uxorem duceret; et quod post benedictionem præcepisset ei, dicens: Non accipies uxorem de filiabus Chanaan: ");
INSERT INTO latVUC_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","quodque obediens Jacob parentibus suis isset in Syriam: ");
INSERT INTO latVUC_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","probans quoque quod non libenter aspiceret filias Chanaan pater suus: ");
INSERT INTO latVUC_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ivit ad Ismaëlem, et duxit uxorem absque iis, quas prius habebat, Maheleth filiam Ismaël filii Abraham, sororem Nabaioth. ");
INSERT INTO latVUC_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Igitur egressus Jacob de Bersabee, pergebat Haran. ");
INSERT INTO latVUC_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Cumque venisset ad quemdam locum, et vellet in eo requiescere post solis occubitum, tulit de lapidibus qui jacebant, et supponens capiti suo, dormivit in eodem loco. ");
INSERT INTO latVUC_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Viditque in somnis scalam stantem super terram, et cacumen illius tangens cælum: angelos quoque Dei ascendentes et descendentes per eam, ");
INSERT INTO latVUC_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","et Dominum innixum scalæ dicentem sibi: Ego sum Dominus Deus Abraham patris tui, et Deus Isaac: terram, in qua dormis, tibi dabo et semini tuo. ");
INSERT INTO latVUC_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Eritque semen tuum quasi pulvis terræ: dilataberis ad occidentem, et orientem, et septentrionem, et meridiem: et benedicentur in te et in semine tuo cunctæ tribus terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Et ero custos tuus quocumque perrexeris, et reducam te in terram hanc: nec dimittam nisi complevero universa quæ dixi. ");
INSERT INTO latVUC_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Cumque evigilasset Jacob de somno, ait: Vere Dominus est in loco isto, et ego nesciebam. ");
INSERT INTO latVUC_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Pavensque, Quam terribilis est, inquit, locus iste ! non est hic aliud nisi domus Dei, et porta cæli. ");
INSERT INTO latVUC_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Surgens ergo Jacob mane, tulit lapidem quem supposuerat capiti suo, et erexit in titulum, fundens oleum desuper. ");
INSERT INTO latVUC_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Appellavitque nomen urbis Bethel, quæ prius Luza vocabatur. ");
INSERT INTO latVUC_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Vovit etiam votum, dicens: Si fuerit Deus mecum, et custodierit me in via, per quam ego ambulo, et dederit mihi panem ad vescendum, et vestimentum ad induendum, ");
INSERT INTO latVUC_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","reversusque fuero prospere ad domum patris mei: erit mihi Dominus in Deum, ");
INSERT INTO latVUC_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","et lapis iste, quem erexi in titulum, vocabitur Domus Dei: cunctorumque quæ dederis mihi, decimas offeram tibi. ");
INSERT INTO latVUC_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Profectus ergo Jacob venit in terram orientalem. ");
INSERT INTO latVUC_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Et vidit puteum in agro, tres quoque greges ovium accubantes juxta eum: nam ex illo adaquabantur pecora, et os ejus grandi lapide claudebatur. ");
INSERT INTO latVUC_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Morisque erat ut cunctis ovibus congregatis devolverent lapidem, et refectis gregibus rursum super os putei ponerent. ");
INSERT INTO latVUC_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Dixitque ad pastores: Fratres, unde estis? Qui responderunt: De Haran. ");
INSERT INTO latVUC_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Quos interrogans, Numquid, ait, nostis Laban filium Nachor? Dixerunt: Novimus. ");
INSERT INTO latVUC_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Sanusne est? inquit. Valet, inquiunt: et ecce Rachel filia ejus venit cum grege suo. ");
INSERT INTO latVUC_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Dixitque Jacob: Adhuc multum diei superest, nec est tempus ut reducantur ad caulas greges: date ante potum ovibus, et sic eas ad pastum reducite. ");
INSERT INTO latVUC_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Qui responderunt: Non possumus, donec omnia pecora congregentur, et amoveamus lapidem de ore putei, ut adaquemus greges. ");
INSERT INTO latVUC_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Adhuc loquebantur, et ecce Rachel veniebat cum ovibus patris sui: nam gregem ipsa pascebat. ");
INSERT INTO latVUC_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Quam cum vidisset Jacob, et sciret consobrinam suam, ovesque Laban avunculi sui, amovit lapidem quo puteus claudebatur. ");
INSERT INTO latVUC_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Et adaquato grege, osculatus est eam: et elevata voce flevit, ");
INSERT INTO latVUC_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","et indicavit ei quod frater esset patris sui, et filius Rebeccæ: at illa festinans nuntiavit patri suo. ");
INSERT INTO latVUC_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Qui cum audisset venisse Jacob filium sororis suæ, cucurrit obviam ei: complexusque eum, et in oscula ruens, duxit in domum suam. Auditis autem causis itineris, ");
INSERT INTO latVUC_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","respondit: Os meum es, et caro mea. Et postquam impleti sunt dies mensis unius, ");
INSERT INTO latVUC_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","dixit ei: Num quia frater meus es, gratis servies mihi? dic quid mercedis accipias. ");
INSERT INTO latVUC_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Habebat vero duas filias: nomen majoris Lia, minor vero appellabatur Rachel. ");
INSERT INTO latVUC_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Sed Lia lippis erat oculis: Rachel decora facie, et venusto aspectu. ");
INSERT INTO latVUC_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Quam diligens Jacob, ait: Serviam tibi pro Rachel filia tua minore, septem annis. ");
INSERT INTO latVUC_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Respondit Laban: Melius est ut tibi eam dem quam alteri viro: mane apud me. ");
INSERT INTO latVUC_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Servivit ergo Jacob pro Rachel septem annis: et videbantur illi pauci dies præ amoris magnitudine. ");
INSERT INTO latVUC_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Dixitque ad Laban: Da mihi uxorem meam: quia jam tempus impletum est, ut ingrediar ad illam. ");
INSERT INTO latVUC_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Qui vocatis multis amicorum turbis ad convivium, fecit nuptias. ");
INSERT INTO latVUC_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Et vespere Liam filiam suam introduxit ad eum, ");
INSERT INTO latVUC_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","dans ancillam filiæ, Zelpham nomine. Ad quam cum ex more Jacob fuisset ingressus, facto mane vidit Liam: ");
INSERT INTO latVUC_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","et dixit ad socerum suum: Quid est quod facere voluisti? nonne pro Rachel servivi tibi? quare imposuisti mihi? ");
INSERT INTO latVUC_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Respondit Laban: Non est in loco nostro consuetudinis, ut minores ante tradamus ad nuptias. ");
INSERT INTO latVUC_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Imple hebdomadam dierum hujus copulæ: et hanc quoque dabo tibi pro opere quo serviturus es mihi septem annis aliis. ");
INSERT INTO latVUC_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Acquievit placito: et hebdomada transacta, Rachel duxit uxorem: ");
INSERT INTO latVUC_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","cui pater servam Balam tradiderat. ");
INSERT INTO latVUC_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tandemque potitus optatis nuptiis, amorem sequentis priori prætulit, serviens apud eum septem annis aliis. ");
INSERT INTO latVUC_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Videns autem Dominus quod despiceret Liam, aperuit vulvam ejus, sorore sterili permanente. ");
INSERT INTO latVUC_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Quæ conceptum genuit filium, vocavitque nomen ejus Ruben, dicens: Vidit Dominus humilitatem meam: nunc amabit me vir meus. ");
INSERT INTO latVUC_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Rursumque concepit et peperit filium, et ait: Quoniam audivit me Dominus haberi contemptui, dedit etiam istum mihi; vocavitque nomen ejus Simeon. ");
INSERT INTO latVUC_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Concepitque tertio, et genuit alium filium: dixitque: Nunc quoque copulabitur mihi maritus meus: eo quod pepererim ei tres filios: et idcirco appellavit nomen ejus Levi. ");
INSERT INTO latVUC_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Quarto concepit, et peperit filium, et ait: Modo confitebor Domino, et ob hoc vocavit eum Judam: cessavitque parere. ");
INSERT INTO latVUC_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Cernens autem Rachel quod infecunda esset, invidit sorori suæ, et ait marito suo: Da mihi liberos, alioquin moriar. ");
INSERT INTO latVUC_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Cui iratus respondit Jacob: Num pro Deo ego sum, qui privavit te fructu ventris tui? ");
INSERT INTO latVUC_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","At illa: Habeo, inquit, famulam Balam: ingredere ad illam, ut pariat super genua mea, et habeam ex illa filios. ");
INSERT INTO latVUC_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Deditque illi Balam in conjugium: quæ, ");
INSERT INTO latVUC_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ingresso ad se viro, concepit, et peperit filium. ");
INSERT INTO latVUC_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Dixitque Rachel: Judicavit mihi Dominus, et exaudivit vocem meam, dans mihi filium, et idcirco appellavit nomen ejus Dan. ");
INSERT INTO latVUC_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rursumque Bala concipiens, peperit alterum, ");
INSERT INTO latVUC_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","pro quo ait Rachel: Comparavit me Deus cum sorore mea, et invalui: vocavitque eum Nephthali. ");
INSERT INTO latVUC_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Sentiens Lia quod parere desiisset, Zelpham ancillam suam marito tradidit. ");
INSERT INTO latVUC_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Qua post conceptum edente filium, ");
INSERT INTO latVUC_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","dixit: Feliciter, et idcirco vocavit nomen ejus Gad. ");
INSERT INTO latVUC_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Peperit quoque Zelpha alterum. ");
INSERT INTO latVUC_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Dixitque Lia: Hoc pro beatitudine mea: beatam quippe me dicent mulieres: propterea appellavit eum Aser. ");
INSERT INTO latVUC_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Egressus autem Ruben tempore messis triticeæ in agrum, reperit mandragoras, quas matri Liæ detulit. Dixitque Rachel: Da mihi partem de mandragoris filii tui. ");
INSERT INTO latVUC_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Illa respondit: Parumne tibi videtur quod præripueris maritum mihi, nisi etiam mandragoras filii mei tuleris? Ait Rachel: Dormiat tecum hac nocte pro mandragoris filii tui. ");
INSERT INTO latVUC_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Redeuntique ad vesperam Jacob de agro, egressa est in occursum ejus Lia, et Ad me, inquit, intrabis: quia mercede conduxi te pro mandragoris filii mei. Dormivitque cum ea nocte illa. ");
INSERT INTO latVUC_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Et exaudivit Deus preces ejus, concepitque et peperit filium quintum, ");
INSERT INTO latVUC_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","et ait: Dedit Deus mercedem mihi, quia dedi ancillam meam viro meo: appellavitque nomen ejus Issachar. ");
INSERT INTO latVUC_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Rursum Lia concipiens, peperit sextum filium, ");
INSERT INTO latVUC_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","et ait: Dotavit me Deus dote bona: etiam hac vice mecum erit maritus meus, eo quod genuerim ei sex filios: et idcirco appellavit nomen ejus Zabulon. ");
INSERT INTO latVUC_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Post quem peperit filiam, nomine Dinam. ");
INSERT INTO latVUC_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Recordatus quoque Dominus Rachelis, exaudivit eam, et aperuit vulvam ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Quæ concepit, et peperit filium, dicens: Abstulit Deus opprobrium meum. ");
INSERT INTO latVUC_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Et vocavit nomen ejus Joseph, dicens: Addat mihi Dominus filium alterum. ");
INSERT INTO latVUC_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Nato autem Joseph, dixit Jacob socero suo: Dimitte me ut revertar in patriam, et ad terram meam. ");
INSERT INTO latVUC_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Da mihi uxores, et liberos meos, pro quibus servivi tibi, ut abeam: tu nosti servitutem qua servivi tibi. ");
INSERT INTO latVUC_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ait illi Laban: Inveniam gratiam in conspectu tuo, experimento didici, quia benedixerit mihi Deus propter te: ");
INSERT INTO latVUC_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","constitue mercedem tuam quam dem tibi. ");
INSERT INTO latVUC_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","At ille respondit: Tu nosti quomodo servierim tibi, et quanta in manibus meis fuerit possessio tua. ");
INSERT INTO latVUC_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Modicum habuisti antequam venirem ad te, et nunc dives effectus es: benedixitque tibi Dominus ad introitum meum. Justum est igitur ut aliquando provideam etiam domui meæ. ");
INSERT INTO latVUC_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Dixitque Laban: Quid tibi dabo? At ille ait: Nihil volo: sed si feceris quod postulo, iterum pascam, et custodiam pecora tua. ");
INSERT INTO latVUC_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Gyra omnes greges tuos, et separa cunctas oves varias, et sparso vellere; quodcumque furvum, et maculosum, variumque fuerit, tam in ovibus quam in capris, erit merces mea. ");
INSERT INTO latVUC_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Respondebitque mihi cras justitia mea, quando placiti tempus advenerit coram te: et omnia quæ non fuerint varia, et maculosa, et furva, tam in ovibus quam in capris, furti me arguent. ");
INSERT INTO latVUC_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Dixitque Laban: Gratum habeo quod petis. ");
INSERT INTO latVUC_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Et separavit in die illa capras, et oves, et hircos, et arietes varios, atque maculosos: cunctum autem gregem unicolorem, id est albi et nigri velleris, tradidit in manu filiorum suorum. ");
INSERT INTO latVUC_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Et posuit spatium itineris trium dierum inter se et generum, qui pascebat reliquos greges ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tollens ergo Jacob virgas populeas virides, et amygdalinas, et ex platanis, ex parte decorticavit eas: detractisque corticibus, in his, quæ spoliata fuerant, candor apparuit: illa vero quæ integra fuerant, viridia permanserunt: atque in hunc modum color effectus est varius. ");
INSERT INTO latVUC_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Posuitque eas in canalibus, ubi effundebatur aqua: ut cum venissent greges ad bibendum, ante oculos haberent virgas, et in aspectu earum conciperent. ");
INSERT INTO latVUC_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Factumque est ut in ipso calore coitus, oves intuerentur virgas, et parerent maculosa, et varia, et diverso colore respersa. ");
INSERT INTO latVUC_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Divisitque gregem Jacob, et posuit virgas in canalibus ante oculos arietum: erant autem alba et nigra quæque, Laban; cetera vero, Jacob, separatis inter se gregibus. ");
INSERT INTO latVUC_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Igitur quando primo tempore ascendebantur oves, ponebat Jacob virgas in canalibus aquarum ante oculos arietum et ovium, ut in earum contemplatione conciperent: ");
INSERT INTO latVUC_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","quando vero serotina admissura erat, et conceptus extremus, non ponebat eas. Factaque sunt ea quæ erant serotina, Laban: et quæ primi temporis, Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ditatusque est homo ultra modum, et habuit greges multos, ancillas et servos, camelos et asinos. ");
INSERT INTO latVUC_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Postquam autem audivit verba filiorum Laban dicentium: Tulit Jacob omnia quæ fuerunt patris nostri, et de illius facultate ditatus, factus est inclytus: ");
INSERT INTO latVUC_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","animadvertit quoque faciem Laban, quod non esset erga se sicut heri et nudiustertius, ");
INSERT INTO latVUC_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","maxime dicente sibi Domino: Revertere in terram patrum tuorum, et ad generationem tuam, eroque tecum. ");
INSERT INTO latVUC_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Misit, et vocavit Rachel et Liam in agrum, ubi pascebat greges, ");
INSERT INTO latVUC_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","dixitque eis: Video faciem patris vestri quod non sit erga me sicut heri et nudiustertius: Deus autem patris mei fuit mecum. ");
INSERT INTO latVUC_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Et ipsæ nostis quod totis viribus meis servierim patri vestro. ");
INSERT INTO latVUC_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Sed et pater vester circumvenit me et mutavit mercedem meam decem vicibus: et tamen non dimisit eum Deus ut noceret mihi. ");
INSERT INTO latVUC_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Si quando dixit: Variæ erunt mercedes tuæ: pariebant omnes oves varios fœtus; quando vero e contrario, ait: Alba quæque accipies pro mercede: omnes greges alba pepererunt. ");
INSERT INTO latVUC_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tulitque Deus substantiam patris vestri, et dedit mihi. ");
INSERT INTO latVUC_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Postquam enim conceptus ovium tempus advenerat, levavi oculos meos, et vidi in somnis ascendentes mares super feminas, varios et maculosos, et diversorum colorum. ");
INSERT INTO latVUC_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Dixitque angelus Dei ad me in somnis: Jacob? Et ego respondi: Adsum. ");
INSERT INTO latVUC_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Qui ait: Leva oculos tuos, et vide universos masculos ascendentes super feminas, varios, maculosos, atque respersos. Vidi enim omnia quæ fecit tibi Laban. ");
INSERT INTO latVUC_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ego sum Deus Bethel, ubi unxisti lapidem, et votum vovisti mihi. Nunc ergo surge, et egredere de terra hac, revertens in terram nativitatis tuæ. ");
INSERT INTO latVUC_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Responderuntque Rachel et Lia: Numquid habemus residui quidquam in facultatibus et hæreditate domus patris nostri? ");
INSERT INTO latVUC_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","nonne quasi alienas reputavit nos, et vendidit, comeditque pretium nostrum? ");
INSERT INTO latVUC_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Sed Deus tulit opes patris nostri, et eas tradidit nobis, ac filiis nostris: unde omnia quæ præcepit tibi Deus, fac. ");
INSERT INTO latVUC_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Surrexit itaque Jacob, et impositis liberis ac conjugibus suis super camelos, abiit. ");
INSERT INTO latVUC_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Tulitque omnem substantiam suam, et greges, et quidquid in Mesopotamia acquisierat, pergens ad Isaac patrem suum in terram Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Eo tempore ierat Laban ad tondendas oves, et Rachel furata est idola patris sui. ");
INSERT INTO latVUC_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Noluitque Jacob confiteri socero suo quod fugeret. ");
INSERT INTO latVUC_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Cumque abiisset tam ipse quam omnia quæ juris sui erant, et amne transmisso pergeret contra montem Galaad, ");
INSERT INTO latVUC_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","nuntiatum est Laban die tertio quod fugeret Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Qui, assumptis fratribus suis, persecutus est eum diebus septem: et comprehendit eum in monte Galaad. ");
INSERT INTO latVUC_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Viditque in somnis dicentem sibi Deum: Cave ne quidquam aspere loquaris contra Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jamque Jacob extenderat in monte tabernaculum: cumque ille consecutus fuisset eum cum fratribus suis, in eodem monte Galaad fixit tentorium. ");
INSERT INTO latVUC_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Et dixit ad Jacob: Quare ita egisti, ut clam me abigeres filias meas quasi captivas gladio? ");
INSERT INTO latVUC_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","cur ignorante me fugere voluisti, nec indicare mihi, ut prosequerer te cum gaudio, et canticis, et tympanis, et citharis? ");
INSERT INTO latVUC_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Non es passus ut oscularer filios meos et filias: stulte operatus es: et nunc quidem ");
INSERT INTO latVUC_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","valet manus mea reddere tibi malum: sed Deus patris vestri heri dixit mihi: Cave ne loquaris contra Jacob quidquam durius. ");
INSERT INTO latVUC_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Esto, ad tuos ire cupiebas, et desiderio erat tibi domus patris tui: cur furatus es deos meos? ");
INSERT INTO latVUC_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Respondit Jacob: Quod inscio te profectus sum, timui ne violenter auferres filias tuas. ");
INSERT INTO latVUC_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Quod autem furti me arguis: apud quemcumque inveneris deos tuos, necetur coram fratribus nostris: scrutare, quidquid tuorum apud me inveneris, et aufer. Hæc dicens, ignorabat quod Rachel furata esset idola. ");
INSERT INTO latVUC_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ingressus itaque Laban tabernaculum Jacob, et Liæ, et utriusque famulæ, non invenit. Cumque intrasset tentorium Rachelis, ");
INSERT INTO latVUC_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","illa festinans abscondit idola subter stramenta cameli, et sedit desuper: scrutantique omne tentorium, et nihil invenienti, ");
INSERT INTO latVUC_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ait: Ne irascatur dominus meus quod coram te assurgere nequeo: quia juxta consuetudinem feminarum nunc accidit mihi: sic delusa sollicitudo quærentis est. ");
INSERT INTO latVUC_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tumensque Jacob, cum jurgio ait: Quam ob culpam meam, et ob quod peccatum meum sic exarsisti post me, ");
INSERT INTO latVUC_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","et scrutatus es omnem supellectilem meam? quid invenisti de cuncta substantia domus tuæ? pone hic coram fratribus meis, et fratribus tuis, et judicent inter me et te. ");
INSERT INTO latVUC_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Idcirco viginti annis fui tecum? oves tuæ et capræ steriles non fuerunt, arietes gregis tui non comedi: ");
INSERT INTO latVUC_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","nec captum a bestia ostendi tibi, ego damnum omne reddebam: quidquid furto peribat, a me exigebas: ");
INSERT INTO latVUC_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","die noctuque æstu urebar, et gelu, fugiebatque somnus ab oculis meis. ");
INSERT INTO latVUC_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Sicque per viginti annos in domo tua servivi tibi, quatuordecim pro filiabus, et sex pro gregibus tuis: immutasti quoque mercedem meam decem vicibus. ");
INSERT INTO latVUC_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nisi Deus patris mei Abraham, et timor Isaac affuisset mihi, forsitan modo nudum me dimisisses: afflictionem meam et laborem manuum mearum respexit Deus, et arguit te heri. ");
INSERT INTO latVUC_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Respondit ei Laban: Filiæ meæ et filii, et greges tui, et omnia quæ cernis, mea sunt: quid possum facere filiis et nepotibus meis? ");
INSERT INTO latVUC_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Veni ergo, et ineamus fœdus, ut sit in testimonium inter me et te. ");
INSERT INTO latVUC_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tulit itaque Jacob lapidem, et erexit illum in titulum: ");
INSERT INTO latVUC_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","dixitque fratribus suis: Afferte lapides. Qui congregantes fecerunt tumulum, comederuntque super eum: ");
INSERT INTO latVUC_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","quem vocavit Laban Tumulum testis: et Jacob, Acervum testimonii, uterque juxta proprietatem linguæ suæ. ");
INSERT INTO latVUC_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Dixitque Laban: Tumulus iste erit testis inter me et te hodie, et idcirco appellatum est nomen ejus Galaad, id est, Tumulus testis. ");
INSERT INTO latVUC_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Intueatur et judicet Dominus inter nos quando recesserimus a nobis, ");
INSERT INTO latVUC_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","si afflixeris filias meas, et si introduxeris alias uxores super eas: nullus sermonis nostri testis est absque Deo, qui præsens respicit. ");
INSERT INTO latVUC_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Dixitque rursus ad Jacob: En tumulus hic, et lapis quem erexi inter me et te, ");
INSERT INTO latVUC_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","testis erit: tumulus, inquam, iste et lapis sint in testimonium, si aut ego transiero illum pergens ad te, aut tu præterieris, malum mihi cogitans. ");
INSERT INTO latVUC_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Deus Abraham, et Deus Nachor, judicet inter nos, Deus patris eorum. Juravit ergo Jacob per timorem patris sui Isaac: ");
INSERT INTO latVUC_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","immolatisque victimis in monte, vocavit fratres suos ut ederent panem. Qui cum comedissent, manserunt ibi: ");
INSERT INTO latVUC_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban vero de nocte consurgens, osculatus est filios, et filias suas, et benedixit illis: reversusque est in locum suum. ");
INSERT INTO latVUC_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob quoque abiit itinere quo cœperat: fueruntque ei obviam angeli Dei. ");
INSERT INTO latVUC_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Quos cum vidisset, ait: Castra Dei sunt hæc: et appellavit nomen loci illius Mahanaim, id est, Castra. ");
INSERT INTO latVUC_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Misit autem et nuntios ante se ad Esau fratrem suum in terram Seir, in regionem Edom: ");
INSERT INTO latVUC_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","præcepitque eis, dicens: Sic loquimini domino meo Esau: Hæc dicit frater tuus Jacob: Apud Laban peregrinatus sum, et fui usque in præsentem diem. ");
INSERT INTO latVUC_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Habeo boves, et asinos, et oves, et servos, et ancillas: mittoque nunc legationem ad dominum meum, ut inveniam gratiam in conspectu tuo. ");
INSERT INTO latVUC_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Reversique sunt nuntii ad Jacob, dicentes: Venimus ad Esau fratrem tuum, et ecce properat tibi in occursum cum quadringentis viris. ");
INSERT INTO latVUC_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Timuit Jacob valde: et perterritus divisit populum qui secum erat, greges quoque et oves, et boves, et camelos, in duas turmas, ");
INSERT INTO latVUC_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","dicens: Si venerit Esau ad unam turmam, et percusserit eam, alia turma, quæ relicta est, salvabitur. ");
INSERT INTO latVUC_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Dixitque Jacob: Deus patris mei Abraham, et Deus patris mei Isaac: Domine qui dixisti mihi: Revertere in terram tuam, et in locum nativitatis tuæ, et benefaciam tibi: ");
INSERT INTO latVUC_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","minor sum cunctis miserationibus tuis, et veritate tua quam explevisti servo tuo. In baculo meo transivi Jordanem istum: et nunc cum duabus turmis regredior. ");
INSERT INTO latVUC_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Erue me de manu fratris mei Esau, quia valde eum timeo: ne forte veniens percutiat matrem cum filiis. ");
INSERT INTO latVUC_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tu locutus es quod benefaceres mihi, et dilatares semen meum sicut arenam maris, quæ præ multitudine numerari non potest. ");
INSERT INTO latVUC_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Cumque dormisset ibi nocte illa, separavit de his quæ habebat, munera Esau fratri suo, ");
INSERT INTO latVUC_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","capras ducentas, hircos viginti, oves ducentas, et arietes viginti, ");
INSERT INTO latVUC_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","camelos fœtas cum pullis suis triginta, vaccas quadraginta, et tauros viginti, asinas viginti et pullos earum decem. ");
INSERT INTO latVUC_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Et misit per manus servorum suorum singulos seorsum greges, dixitque pueris suis: Antecedite me, et sit spatium inter gregem et gregem. ");
INSERT INTO latVUC_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Et præcepit priori, dicens: Si obvium habueris fratrem meum Esau, et interrogaverit te: Cujus es? aut, Quo vadis? aut, Cujus sunt ista quæ sequeris? ");
INSERT INTO latVUC_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","respondebis: Servi tui Jacob, munera misit domino meo Esau, ipse quoque post nos venit. ");
INSERT INTO latVUC_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Similiter dedit mandata secundo, et tertio, et cunctis qui sequebantur greges, dicens: Iisdem verbis loquimini ad Esau cum inveneritis eum. ");
INSERT INTO latVUC_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Et addetis: Ipse quoque servus tuus Jacob iter nostrum insequitur. Dixit enim: Placabo illum muneribus quæ præcedunt, et postea videbo illum: forsitan propitiabitur mihi. ");
INSERT INTO latVUC_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Præcesserunt itaque munera ante eum, ipse vero mansit nocte illa in castris. ");
INSERT INTO latVUC_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Cumque mature surrexisset, tulit duas uxores suas, et totidem famulas cum undecim filiis, et transivit vadum Jaboc. ");
INSERT INTO latVUC_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Traductisque omnibus quæ ad se pertinebant, ");
INSERT INTO latVUC_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","mansit solus: et ecce vir luctabatur cum eo usque mane. ");
INSERT INTO latVUC_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Qui cum videret quod eum superare non posset, tetigit nervum femoris ejus, et statim emarcuit. ");
INSERT INTO latVUC_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Dixitque ad eum: Dimitte me: jam enim ascendit aurora. Respondit: Non dimittam te, nisi benedixeris mihi. ");
INSERT INTO latVUC_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ait ergo: Quod nomen est tibi? Respondit: Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","At ille: Nequaquam, inquit, Jacob appellabitur nomen tuum, sed Israël: quoniam si contra Deum fortis fuisti, quanto magis contra homines prævalebis? ");
INSERT INTO latVUC_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Interrogavit eum Jacob: Dic mihi, quo appellaris nomine? Respondit: Cur quæris nomen meum? Et benedixit ei in eodem loco. ");
INSERT INTO latVUC_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Vocavitque Jacob nomen loci illius Phanuel, dicens: Vidi Deum facie ad faciem, et salva facta est anima mea. ");
INSERT INTO latVUC_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ortusque est ei statim sol, postquam transgressus est Phanuel: ipse vero claudicabat pede. ");
INSERT INTO latVUC_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Quam ob causam non comedunt nervum filii Israël, qui emarcuit in femore Jacob, usque in præsentem diem: eo quod tetigerit nervum femoris ejus, et obstupuerit. ");
INSERT INTO latVUC_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Elevans autem Jacob oculos suos, vidit venientem Esau, et cum eo quadringentos viros: divisitque filios Liæ et Rachel, ambarumque famularum: ");
INSERT INTO latVUC_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","et posuit utramque ancillam, et liberos earum, in principio: Liam vero, et filios ejus, in secundo loco: Rachel autem et Joseph novissimos. ");
INSERT INTO latVUC_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Et ipse progrediens adoravit pronus in terram septies, donec appropinquaret frater ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Currens itaque Esau obviam fratri suo, amplexatus est eum: stringensque collum ejus, et osculans flevit. ");
INSERT INTO latVUC_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Levatisque oculis, vidit mulieres et parvulos earum, et ait: Quid sibi volunt isti? et si ad te pertinent? Respondit: Parvuli sunt quos donavit mihi Deus servo tuo. ");
INSERT INTO latVUC_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Et appropinquantes ancillæ et filii earum, incurvati sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Accessit quoque Lia cum pueris suis: et cum similiter adorassent, extremi Joseph et Rachel adoraverunt. ");
INSERT INTO latVUC_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Dixitque Esau: Quænam sunt istæ turmæ quas obviam habui? Respondit: Ut invenirem gratiam coram domino meo. ");
INSERT INTO latVUC_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","At ille ait: Habeo plurima, frater mi, sint tua tibi. ");
INSERT INTO latVUC_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Dixitque Jacob: Noli ita, obsecro: sed si inveni gratiam in oculis tuis, accipe munusculum de manibus meis. Sic enim vidi faciem tuam, quasi viderim vultum Dei: esto mihi propitius, ");
INSERT INTO latVUC_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","et suscipe benedictionem quam attuli tibi, et quam donavit mihi Deus tribuens omnia. Vix fratre compellente, suscipiens, ");
INSERT INTO latVUC_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ait: Gradiamur simul, eroque socius itineris tui. ");
INSERT INTO latVUC_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Dixitque Jacob: Nosti, domine mi, quod parvulos habeam teneros, et oves, et boves fœtas mecum: quas si plus in ambulando fecero laborare, morientur una die cuncti greges. ");
INSERT INTO latVUC_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Præcedat dominus meus ante servum suum: et ego sequar paulatim vestigia ejus, sicut videro parvulos meos posse, donec veniam ad dominum meum in Seir. ");
INSERT INTO latVUC_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Respondit Esau: Oro te, ut de populo qui mecum est, saltem socri remaneant viæ tuæ. Non est, inquit, necesse: hoc uno tantum indigeo, ut inveniam gratiam in conspectu tuo, domine mi. ");
INSERT INTO latVUC_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Reversus est itaque illo die Esau itinere quo venerat in Seir. ");
INSERT INTO latVUC_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Et Jacob venit in Socoth: ubi ædificata domo et fixis tentoriis appellavit nomen loci illius Socoth, id est, Tabernacula. ");
INSERT INTO latVUC_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Transivitque in Salem urbem Sichimorum, quæ est in terra Chanaan, postquam reversus est de Mesopotamia Syriæ: et habitavit juxta oppidum. ");
INSERT INTO latVUC_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Emitque partem agri, in qua fixerat tabernacula, a filiis Hemor patris Sichem centum agnis. ");
INSERT INTO latVUC_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Et erecto ibi altari, invocavit super illud fortissimum Deum Israël. ");
INSERT INTO latVUC_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Egressa est autem Dina filia Liæ ut videret mulieres regionis illius. ");
INSERT INTO latVUC_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Quam cum vidisset Sichem filius Hemor Hevæi, princeps terræ illius, adamavit eam: et rapuit, et dormivit cum illa, vi opprimens virginem. ");
INSERT INTO latVUC_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Et conglutinata est anima ejus cum ea, tristemque delinivit blanditiis. ");
INSERT INTO latVUC_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Et pergens ad Hemor patrem suum: Accipe, inquit, mihi puellam hanc conjugem. ");
INSERT INTO latVUC_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Quod cum audisset Jacob absentibus filiis, et in pastu pecorum occupatis, siluit donec redirent. ");
INSERT INTO latVUC_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Egresso autem Hemor patre Sichem ut loqueretur ad Jacob, ");
INSERT INTO latVUC_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ecce filii ejus veniebant de agro: auditoque quod acciderat, irati sunt valde, eo quod fœdam rem operatus esset in Israël et, violata filia Jacob, rem illicitam perpetrasset. ");
INSERT INTO latVUC_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Locutus est itaque Hemor ad eos: Sichem filii mei adhæsit anima filiæ vestræ: date eam illi uxorem: ");
INSERT INTO latVUC_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","et jungamus vicissim connubia: filias vestras tradite nobis, et filias nostras accipite, ");
INSERT INTO latVUC_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","et habitate nobiscum: terra in potestate vestra est: exercete, negotiamini, et possidete eam. ");
INSERT INTO latVUC_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sed et Sichem ad patrem et ad fratres ejus ait: Inveniam gratiam coram vobis: et quæcumque statueritis, dabo: ");
INSERT INTO latVUC_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","augete dotem, et munera postulate, et libenter tribuam quod petieritis: tantum date mihi puellam hanc uxorem. ");
INSERT INTO latVUC_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Responderunt filii Jacob Sichem et patri ejus in dolo, sævientes ob stuprum sororis: ");
INSERT INTO latVUC_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Non possumus facere quod petitis, nec dare sororem nostram homini incircumciso: quod illicitum et nefarium est apud nos. ");
INSERT INTO latVUC_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sed in hoc valebimus fœderari, si volueritis esse similes nostri, et circumcidatur in vobis omne masculini sexus; ");
INSERT INTO latVUC_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","tunc dabimus et accipiemus mutuo filias vestras ac nostras: et habitabimus vobiscum, erimusque unus populus. ");
INSERT INTO latVUC_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Si autem circumcidi nolueritis, tollemus filiam nostram, et recedemus. ");
INSERT INTO latVUC_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Placuit oblatio eorum Hemor, et Sichem filio ejus, ");
INSERT INTO latVUC_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","nec distulit adolescens quin statim quod petebatur expleret: amabat enim puellam valde, et ipse erat inclytus in omni domo patris sui. ");
INSERT INTO latVUC_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ingressique portam urbis, locuti sunt ad populum: ");
INSERT INTO latVUC_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Viri isti pacifici sunt, et volunt habitare nobiscum: negotientur in terra, et exerceant eam, quæ spatiosa et lata cultoribus indiget: filias eorum accipiemus uxores, et nostras illis dabimus. ");
INSERT INTO latVUC_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Unum est quo differtur tantum bonum: si circumcidamus masculos nostros, ritum gentis imitantes. ");
INSERT INTO latVUC_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Et substantia eorum, et pecora, et cuncta quæ possident, nostra erunt: tantum in hoc acquiescamus, et habitantes simul, unum efficiemus populum. ");
INSERT INTO latVUC_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Assensique sunt omnes, circumcisis cunctis maribus. ");
INSERT INTO latVUC_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Et ecce, die tertio, quando gravissimus vulnerum dolor est: arreptis duo filii Jacob, Simeon et Levi fratres Dinæ, gladiis, ingressi sunt urbem confidenter: interfectisque omnibus masculis, ");
INSERT INTO latVUC_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hemor et Sichem pariter necaverunt, tollentes Dinam de domo Sichem sororem suam. ");
INSERT INTO latVUC_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Quibus egressis, irruerunt super occisos ceteri filii Jacob: et depopulati sunt urbem in ultionem stupri. ");
INSERT INTO latVUC_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Oves eorum, et armenta, et asinos, cunctaque vastantes quæ in domibus et in agris erant, ");
INSERT INTO latVUC_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","parvulos quoque eorum et uxores duxerunt captivas. ");
INSERT INTO latVUC_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Quibus patratis audacter, Jacob dixit ad Simeon et Levi: Turbastis me, et odiosum fecistis me Chananæis, et Pherezæis habitatoribus terræ hujus: nos pauci sumus; illi congregati percutient me, et delebor ego, et domus mea. ");
INSERT INTO latVUC_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Responderunt: Numquid ut scorto abuti debuere sorore nostra? ");
INSERT INTO latVUC_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Interea locutus est Deus ad Jacob: Surge, et ascende Bethel, et habita ibi, facque altare Deo qui apparuit tibi quando fugiebas Esau fratrem tuum. ");
INSERT INTO latVUC_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jacob vero convocata omni domo sua, ait: Abjicite deos alienos qui in medio vestri sunt, et mundamini, ac mutate vestimenta vestra. ");
INSERT INTO latVUC_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Surgite, et ascendamus in Bethel, ut faciamus ibi altare Deo: qui exaudivit me in die tribulationis meæ, et socius fuit itineris mei. ");
INSERT INTO latVUC_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Dederunt ergo ei omnes deos alienos quos habebant, et inaures quæ erant in auribus eorum: at ille infodit ea subter terebinthum, quæ est post urbem Sichem. ");
INSERT INTO latVUC_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Cumque profecti essent, terror Dei invasit omnes per circuitum civitates, et non sunt ausi persequi recedentes. ");
INSERT INTO latVUC_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Venit igitur Jacob Luzam, quæ est in terra Chanaan, cognomento Bethel: ipse et omnis populus cum eo. ");
INSERT INTO latVUC_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ædificavitque ibi altare, et appellavit nomen loci illius, Domus Dei: ibi enim apparuit ei Deus cum fugeret fratrem suum. ");
INSERT INTO latVUC_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Eodem tempore mortua est Debora nutrix Rebeccæ, et sepulta est ad radices Bethel subter quercum: vocatumque est nomen loci illius, Quercus fletus. ");
INSERT INTO latVUC_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Apparuit autem iterum Deus Jacob postquam reversus est de Mesopotamia Syriæ, benedixitque ei ");
INSERT INTO latVUC_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","dicens: Non vocaberis ultra Jacob, sed Israël erit nomen tuum. Et appellavit eum Israël, ");
INSERT INTO latVUC_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","dixitque ei: Ego Deus omnipotens: cresce, et multiplicare: gentes et populi nationum ex te erunt, reges de lumbis tuis egredientur, ");
INSERT INTO latVUC_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","terramque quam dedi Abraham et Isaac, dabo tibi et semini tuo post te. ");
INSERT INTO latVUC_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Et recessit ab eo. ");
INSERT INTO latVUC_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ille vero erexit titulum lapideum in loco quo locutus fuerat ei Deus: libans super eum libamina, et effundens oleum: ");
INSERT INTO latVUC_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","vocansque nomen loci illius Bethel. ");
INSERT INTO latVUC_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Egressus autem inde, venit verno tempore ad terram quæ ducit Ephratam: in qua cum parturiret Rachel, ");
INSERT INTO latVUC_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ob difficultatem partus periclitari cœpit. Dixitque ei obstetrix: Noli timere, quia et hunc habebis filium. ");
INSERT INTO latVUC_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Egrediente autem anima præ dolore, et imminente jam morte, vocavit nomen filii sui Benomi, id est, Filius doloris mei: pater vero appellavit eum Benjamin, id est, Filius dextræ. ");
INSERT INTO latVUC_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Mortua est ergo Rachel, et sepulta est in via quæ ducit Ephratam, hæc est Bethlehem. ");
INSERT INTO latVUC_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Erexitque Jacob titulum super sepulchrum ejus: hic est titulus monumenti Rachel, usque in præsentem diem. ");
INSERT INTO latVUC_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Egressus inde, fixit tabernaculum trans Turrem gregis. ");
INSERT INTO latVUC_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Cumque habitaret in illa regione, abiit Ruben, et dormivit cum Bala concubina patris sui: quod illum minime latuit. Erant autem filii Jacob duodecim. ");
INSERT INTO latVUC_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Filii Liæ: primogenitus Ruben, et Simeon, et Levi, et Judas, et Issachar, et Zabulon. ");
INSERT INTO latVUC_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Filii Rachel: Joseph et Benjamin. ");
INSERT INTO latVUC_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Filii Balæ ancillæ Rachelis: Dan et Nephthali. ");
INSERT INTO latVUC_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Filii Zelphæ ancillæ Liæ: Gad et Aser: hi sunt filii Jacob, qui nati sunt ei in Mesopotamia Syriæ. ");
INSERT INTO latVUC_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Venit etiam ad Isaac patrem suum in Mambre, civitatem Arbee, hæc est Hebron, in qua peregrinatus est Abraham et Isaac. ");
INSERT INTO latVUC_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Et completi sunt dies Isaac centum octoginta annorum. ");
INSERT INTO latVUC_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Consumptusque ætate mortuus est: et appositus est populo suo senex et plenus dierum: et sepelierunt eum Esau et Jacob filii sui. ");
INSERT INTO latVUC_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hæ sunt autem generationes Esau, ipse est Edom. ");
INSERT INTO latVUC_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau accepit uxores de filiabus Chanaan: Ada filiam Elon Hethæi, et Oolibama filiam Anæ filiæ Sebeon Hevæi: ");
INSERT INTO latVUC_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basemath quoque filiam Ismaël sororem Nabaioth. ");
INSERT INTO latVUC_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Peperit autem Ada Eliphaz: Basemath genuit Rahuel: ");
INSERT INTO latVUC_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oolibama genuit Jehus et Ihelon et Core. Hi filii Esau qui nati sunt ei in terra Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Tulit autem Esau uxores suas et filios et filias, et omnem animam domus suæ, et substantiam, et pecora, et cuncta quæ habere poterat in terra Chanaan: et abiit in alteram regionem, recessitque a fratre suo Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Divites enim erant valde, et simul habitare non poterant: nec sustinebat eos terra peregrinationis eorum præ multitudine gregum. ");
INSERT INTO latVUC_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Habitavitque Esau in monte Seir, ipse est Edom. ");
INSERT INTO latVUC_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Hæ autem sunt generationes Esau patris Edom in monte Seir, ");
INSERT INTO latVUC_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","et hæc nomina filiorum ejus: Eliphaz filius Ada uxoris Esau: Rahuel quoque filius Basemath uxoris ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Fueruntque Eliphaz filii: Theman, Omar, Sepho, et Gatham, et Cenez. ");
INSERT INTO latVUC_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Erat autem Thamna concubina Eliphaz filii Esau: quæ peperit ei Amalech. Hi sunt filii Ada uxoris Esau. ");
INSERT INTO latVUC_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Filii autem Rahuel: Nahath et Zara, Samma et Meza: hi filii Basemath uxoris Esau. ");
INSERT INTO latVUC_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isti quoque erant filii Oolibama filiæ Anæ filiæ Sebeon, uxoris Esau, quos genuit ei, Jehus et Ihelon et Core. ");
INSERT INTO latVUC_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hi duces filiorum Esau: filii Eliphaz primogeniti Esau: dux Theman, dux Omra, dux Sepho, dux Cenez, ");
INSERT INTO latVUC_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","dux Core, dux Gathan, dux Amalech. Hi filii Eliphaz in terra Edom, et hi filii Ada. ");
INSERT INTO latVUC_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Hi quoque filii Rahuel filii Esau: dux Nahath, dux Zara, dux Samma, dux Meza: hi autem duces Rahuel in terra Edom: isti filii Basemath uxoris Esau. ");
INSERT INTO latVUC_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Hi autem filii Oolibama uxoris Esau: dux Jehus, dux Ihelon, dux Core: hi duces Oolibama filiæ Anæ uxoris Esau. ");
INSERT INTO latVUC_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Isti sunt filii Esau, et hi duces eorum: ipse est Edom. ");
INSERT INTO latVUC_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Isti sunt filii Seir Horræi, habitatores terræ: Lotan, et Sobal, et Sebeon, et Ana, ");
INSERT INTO latVUC_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","et Dison, et Eser, et Disan: hi duces Horræi, filii Seir in terra Edom. ");
INSERT INTO latVUC_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Facti sunt autem filii Lotan: Hori et Heman. Erat autem soror Lotan, Thamna. ");
INSERT INTO latVUC_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Et isti filii Sobal: Alvan et Manahat et Ebal, et Sepho et Onam. ");
INSERT INTO latVUC_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Et hi filii Sebeon: Aja et Ana. Iste est Ana qui invenit aquas calidas in solitudine, cum pasceret asinos Sebeon patris sui: ");
INSERT INTO latVUC_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","habuitque filium Dison, et filiam Oolibama. ");
INSERT INTO latVUC_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Et isti filii Dison: Hamdan, et Eseban, et Jethram, et Charan. ");
INSERT INTO latVUC_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Hi quoque filii Eser: Balaan, et Zavan, et Acan. ");
INSERT INTO latVUC_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Habuit autem filios Disan: Hus et Aram. ");
INSERT INTO latVUC_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hi duces Horræorum: dux Lotan, dux Sobal, dux Sebeon, dux Ana, ");
INSERT INTO latVUC_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","dux Dison, dux Eser, dux Disan: isti duces Horræorum qui imperaverunt in terra Seir. ");
INSERT INTO latVUC_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Reges autem qui regnaverunt in terra Edom antequam haberent regem filii Israël, fuerunt hi: ");
INSERT INTO latVUC_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela filius Beor, nomenque urbis ejus Denaba. ");
INSERT INTO latVUC_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Mortuus est autem Bela, et regnavit pro eo Jobab filius Zaræ de Bosra. ");
INSERT INTO latVUC_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Cumque mortuus esset Jobab, regnavit pro eo Husam de terra Themanorum. ");
INSERT INTO latVUC_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hoc quoque mortuo, regnavit pro eo Adad filius Badad, qui percussit Madian in regione Moab: et nomen urbis ejus Avith. ");
INSERT INTO latVUC_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Cumque mortuus esset Adad, regnavit pro eo Semla de Masreca. ");
INSERT INTO latVUC_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Hoc quoque mortuo regnavit pro eo Saul de fluvio Rohoboth. ");
INSERT INTO latVUC_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Cumque et hic obiisset, successit in regnum Balanan filius Achobor. ");
INSERT INTO latVUC_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Isto quoque mortuo regnavit pro eo Adar, nomenque urbis ejus Phau: et appellabatur uxor ejus Meetabel, filia Matred filiæ Mezaab. ");
INSERT INTO latVUC_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Hæc ergo nomina ducum Esau in cognationibus, et locis, et vocabulis suis: dux Thamna, dux Alva, dux Jetheth, ");
INSERT INTO latVUC_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","dux Oolibama, dux Ela, dux Phinon, ");
INSERT INTO latVUC_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","dux Cenez, dux Theman, dux Mabsar, ");
INSERT INTO latVUC_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","dux Magdiel, dux Hiram: hi duces Edom habitantes in terra imperii sui, ipse est Esau pater Idumæorum. ");
INSERT INTO latVUC_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Habitavit autem Jacob in terra Chanaan, in qua pater suus peregrinatus est. ");
INSERT INTO latVUC_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Et hæ sunt generationes ejus: Joseph cum sedecim esset annorum, pascebat gregem cum fratribus suis adhuc puer: et erat cum filiis Balæ et Zelphæ uxorum patris sui: accusavitque fratres suos apud patrem crimine pessimo. ");
INSERT INTO latVUC_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israël autem diligebat Joseph super omnes filios suos, eo quod in senectute genuisset eum: fecitque ei tunicam polymitam. ");
INSERT INTO latVUC_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Videntes autem fratres ejus quod a patre plus cunctis filiis amaretur, oderant eum, nec poterant ei quidquam pacifice loqui. ");
INSERT INTO latVUC_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Accidit quoque ut visum somnium referret fratribus suis: quæ causa majoris odii seminarium fuit. ");
INSERT INTO latVUC_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Dixitque ad eos: Audite somnium meum quod vidi: ");
INSERT INTO latVUC_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","putabam nos ligare manipulos in agro: et quasi consurgere manipulum meum, et stare, vestrosque manipulos circumstantes adorare manipulum meum. ");
INSERT INTO latVUC_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Responderunt fratres ejus: Numquid rex noster eris? aut subjiciemur ditioni tuæ? Hæc ergo causa somniorum atque sermonum, invidiæ et odii fomitem ministravit. ");
INSERT INTO latVUC_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Aliud quoque vidit somnium, quod narrans fratribus, ait: Vidi per somnium, quasi solem, et lunam, et stellas undecim adorare me. ");
INSERT INTO latVUC_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Quod cum patri suo, et fratribus retulisset, increpavit eum pater suus, et dixit: Quid sibi vult hoc somnium quod vidisti? num ego et mater tua, et fratres tui adorabimus te super terram? ");
INSERT INTO latVUC_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Invidebant ei igitur fratres sui: pater vero rem tacitus considerabat. ");
INSERT INTO latVUC_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Cumque fratres illius in pascendis gregibus patris morarentur in Sichem, ");
INSERT INTO latVUC_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","dixit ad eum Israël: Fratres tui pascunt oves in Sichimis: veni, mittam te ad eos. Quo respondente, ");
INSERT INTO latVUC_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Præsto sum, ait ei: Vade, et vide si cuncta prospera sint erga fratres tuos, et pecora: et renuntia mihi quid agatur. Missus de valle Hebron, venit in Sichem: ");
INSERT INTO latVUC_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","invenitque eum vir errantem in agro, et interrogavit quid quæreret. ");
INSERT INTO latVUC_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","At ille respondit: Fratres meos quæro: indica mihi ubi pascant greges. ");
INSERT INTO latVUC_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Dixitque ei vir: Recesserunt de loco isto: audivi autem eos dicentes: Eamus in Dothain. Perrexit ergo Joseph post fratres suos, et invenit eos in Dothain. ");
INSERT INTO latVUC_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Qui cum vidissent eum procul, antequam accederet ad eos, cogitaverunt illum occidere: ");
INSERT INTO latVUC_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","et mutuo loquebantur: Ecce somniator venit: ");
INSERT INTO latVUC_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","venite, occidamus eum, et mittamus in cisternam veterem: dicemusque: Fera pessima devoravit eum: et tunc apparebit quid illi prosint somnia sua. ");
INSERT INTO latVUC_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Audiens autem hoc Ruben, nitebatur liberare eum de manibus eorum, et dicebat: ");
INSERT INTO latVUC_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Non interficiatis animam ejus, nec effundatis sanguinem: sed projicite eum in cisternam hanc, quæ est in solitudine, manusque vestras servate innoxias: hoc autem dicebat, volens eripere eum de manibus eorum, et reddere patri suo. ");
INSERT INTO latVUC_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Confestim igitur ut pervenit ad fratres suos, nudaverunt eum tunica talari et polymita: ");
INSERT INTO latVUC_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","miseruntque eum in cisternam veterem, quæ non habebat aquam. ");
INSERT INTO latVUC_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Et sedentes ut comederent panem, viderunt Ismaëlitas viatores venire de Galaad, et camelos eorum portantes aromata, et resinam, et stacten in Ægyptum. ");
INSERT INTO latVUC_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Dixit ergo Judas fratribus suis: Quid nobis prodest si occiderimus fratrem nostrum, et celaverimus sanguinem ipsius? ");
INSERT INTO latVUC_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","melius est ut venundetur Ismaëlitis, et manus nostræ non polluantur: frater enim et caro nostra est. Acquieverunt fratres sermonibus illius. ");
INSERT INTO latVUC_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Et prætereuntibus Madianitis negotiatoribus, extrahentes eum de cisterna, vendiderunt eum Ismaëlitis, viginti argenteis: qui duxerunt eum in Ægyptum. ");
INSERT INTO latVUC_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reversusque Ruben ad cisternam, non invenit puerum: ");
INSERT INTO latVUC_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","et scissis vestibus pergens ad fratres suos, ait: Puer non comparet, et ego quo ibo? ");
INSERT INTO latVUC_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tulerunt autem tunicam ejus, et in sanguine hædi, quem occiderant, tinxerunt: ");
INSERT INTO latVUC_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","mittentes qui ferrent ad patrem, et dicerent: Hanc invenimus: vide utrum tunica filii tui sit, an non. ");
INSERT INTO latVUC_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Quam cum agnovisset pater, ait: Tunica filii mei est: fera pessima comedit eum, bestia devoravit Joseph. ");
INSERT INTO latVUC_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Scissisque vestibus, indutus est cilicio, lugens filium suum multo tempore. ");
INSERT INTO latVUC_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Congregatis autem cunctis liberis ejus ut lenirent dolorem patris, noluit consolationem accipere, sed ait: Descendam ad filium meum lugens in infernum. Et illo perseverante in fletu, ");
INSERT INTO latVUC_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Madianitæ vendiderunt Joseph in Ægypto Putiphari eunucho Pharaonis, magistro militum. ");
INSERT INTO latVUC_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Eodem tempore, descendens Judas a fratribus suis, divertit ad virum Odollamitem, nomine Hiram. ");
INSERT INTO latVUC_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Viditque ibi filiam hominis Chananæi, vocabulo Sue: et accepta uxore, ingressus est ad eam. ");
INSERT INTO latVUC_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Quæ concepit, et peperit filium, et vocavit nomen ejus Her. ");
INSERT INTO latVUC_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Rursumque concepto fœtu, natum filium vocavit Onan. ");
INSERT INTO latVUC_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Tertium quoque peperit: quem appellavit Sela; quo nato, parere ultra cessavit. ");
INSERT INTO latVUC_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Dedit autem Judas uxorem primogenito suo Her, nomine Thamar. ");
INSERT INTO latVUC_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Fuit quoque Her primogenitus Judæ nequam in conspectu Domini: et ab eo occisus est. ");
INSERT INTO latVUC_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Dixit ergo Judas ad Onan filium suum: Ingredere uxorem fratris tui, et sociare illi, ut suscites semen fratri tuo. ");
INSERT INTO latVUC_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ille sciens non sibi nasci filios, introiens ad uxorem fratris sui, semen fundebat in terram, ne liberi fratris nomine nascerentur. ");
INSERT INTO latVUC_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Et idcirco percussit eum Dominus, quod rem detestabilem faceret. ");
INSERT INTO latVUC_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Quam ob rem dixit Judas Thamar nurui suæ: Esto vidua in domo patris tui, donec crescat Sela filius meus: timebat enim ne et ipse moreretur, sicut fratres ejus. Quæ abiit, et habitavit in domo patris sui. ");
INSERT INTO latVUC_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Evolutis autem multis diebus, mortua est filia Sue uxor Judæ: qui, post luctum consolatione suscepta, ascendebat ad tonsores ovium suarum, ipse et Hiras opilio gregis Odollamites, in Thamnas. ");
INSERT INTO latVUC_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Nuntiatumque est Thamar quod socer illius ascenderet in Thamnas ad tondendas oves. ");
INSERT INTO latVUC_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Quæ, depositis viduitatis vestibus, assumpsit theristrum: et mutato habitu, sedit in bivio itineris, quod ducit Thamnam: eo quod crevisset Sela, et non eum accepisset maritum. ");
INSERT INTO latVUC_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Quam cum vidisset Judas, suspicatus est esse meretricem: operuerat enim vultum suum, ne agnosceretur. ");
INSERT INTO latVUC_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ingrediensque ad eam, ait: Dimitte me ut coëam tecum: nesciebat enim quod nurus sua esset. Qua respondente: Quid dabis mihi ut fruaris concubitu meo? ");
INSERT INTO latVUC_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","dixit: Mittam tibi hædum de gregibus. Rursumque illa dicente: Patiar quod vis, si dederis mihi arrhabonem, donec mittas quod polliceris. ");
INSERT INTO latVUC_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ait Judas: Quid tibi vis pro arrhabone dari? Respondit: Annulum tuum, et armillam, et baculum quem manu tenes. Ad unum igitur coitum mulier concepit, ");
INSERT INTO latVUC_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","et surgens abiit: depositoque habitu quem sumpserat, induta est viduitatis vestibus. ");
INSERT INTO latVUC_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Misit autem Judas hædum per pastorem suum Odollamitem, ut reciperet pignus quod dederat mulieri: qui cum non invenisset eam, ");
INSERT INTO latVUC_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","interrogavit homines loci illius: Ubi est mulier quæ sedebat in bivio? Respondentibus cunctis: Non fuit in loco ista meretrix. ");
INSERT INTO latVUC_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Reversus est ad Judam, et dixit ei: Non inveni eam: sed et homines loci illius dixerunt mihi, numquam sedisse ibi scortum. ");
INSERT INTO latVUC_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ait Judas: Habeat sibi, certe mendacii arguere nos non potest, ego misi hædum quem promiseram: et tu non invenisti eam. ");
INSERT INTO latVUC_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ecce autem post tres menses nuntiaverunt Judæ, dicentes: Fornicata est Thamar nurus tua, et videtur uterus illius intumescere. Dixitque Judas: Producite eam ut comburatur. ");
INSERT INTO latVUC_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Quæ cum duceretur ad pœnam, misit ad socerum suum, dicens: De viro, cujus hæc sunt, concepi: cognosce cujus sit annulus, et armilla, et baculus. ");
INSERT INTO latVUC_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Qui, agnitis muneribus, ait: Justior me est: quia non tradidi eam Sela filio meo. Attamen ultra non cognovit eam. ");
INSERT INTO latVUC_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Instante autem partu, apparuerunt gemini in utero: atque in ipsa effusione infantium unus protulit manum, in qua obstetrix ligavit coccinum, dicens: ");
INSERT INTO latVUC_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Iste egredietur prior. ");
INSERT INTO latVUC_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Illo vero retrahente manum, egressus est alter: dixitque mulier: Quare divisa est propter te maceria? et ob hanc causam, vocavit nomen ejus Phares. ");
INSERT INTO latVUC_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Postea egressus est frater ejus, in cujus manu erat coccinum: quem appellavit Zara. ");
INSERT INTO latVUC_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Igitur Joseph ductus est in Ægyptum, emitque eum Putiphar eunuchus Pharaonis, princeps exercitus, vir ægyptius, de manu Ismaëlitarum, a quibus perductus erat. ");
INSERT INTO latVUC_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Fuitque Dominus cum eo, et erat vir in cunctis prospere agens: habitavitque in domo domini sui, ");
INSERT INTO latVUC_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","qui optime noverat Dominum esse cum eo, et omnia, quæ gerebat, ab eo dirigi in manu illius. ");
INSERT INTO latVUC_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Invenitque Joseph gratiam coram domino suo, et ministrabat ei: a quo præpositus omnibus gubernabat creditam sibi domum, et universa quæ ei tradita fuerant: ");
INSERT INTO latVUC_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","benedixitque Dominus domui Ægyptii propter Joseph, et multiplicavit tam in ædibus quam in agris cunctam ejus substantiam: ");
INSERT INTO latVUC_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","nec quidquam aliud noverat, nisi panem quo vescebatur. Erat autem Joseph pulchra facie, et decorus aspectu. ");
INSERT INTO latVUC_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Post multos itaque dies injecit domina sua oculos suos in Joseph, et ait: Dormi mecum. ");
INSERT INTO latVUC_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Qui nequaquam acquiescens operi nefario, dixit ad eam: Ecce dominus meus, omnibus mihi traditis, ignorat quid habeat in domo sua: ");
INSERT INTO latVUC_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","nec quidquam est quod non in mea sit potestate, vel non tradiderit mihi, præter te, quæ uxor ejus es: quomodo ergo possum hoc malum facere, et peccare in Deum meum? ");
INSERT INTO latVUC_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hujuscemodi verbis per singulos dies, et mulier molesta erat adolescenti: et ille recusabat stuprum. ");
INSERT INTO latVUC_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Accidit autem quadam die ut intraret Joseph domum, et operis quippiam absque arbitris faceret: ");
INSERT INTO latVUC_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","et illa, apprehensa lacinia vestimenti ejus, diceret: Dormi mecum. Qui relicto in manu ejus pallio fugit, et egressus est foras. ");
INSERT INTO latVUC_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Cumque vidisset mulier vestem in manibus suis, et se esse contemptam, ");
INSERT INTO latVUC_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","vocavit ad se homines domus suæ, et ait ad eos: En introduxit virum hebræum, ut illuderet nobis: ingressus est ad me, ut coiret mecum: cumque ego succlamassem, ");
INSERT INTO latVUC_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","et audisset vocem meam, reliquit pallium quod tenebam, et fugit foras. ");
INSERT INTO latVUC_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","In argumentum ergo fidei retentum pallium ostendit marito revertenti domum, ");
INSERT INTO latVUC_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","et ait: Ingressus est ad me servus hebræus quem adduxisti, ut illuderet mihi: ");
INSERT INTO latVUC_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","cumque audisset me clamare, reliquit pallium quod tenebam, et fugit foras. ");
INSERT INTO latVUC_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","His auditis dominus, et nimium credulus verbis conjugis, iratus est valde: ");
INSERT INTO latVUC_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","tradiditque Joseph in carcerem, ubi vincti regis custodiebantur, et erat ibi clausus. ");
INSERT INTO latVUC_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Fuit autem Dominus cum Joseph, et misertus illius dedit ei gratiam in conspectu principis carceris. ");
INSERT INTO latVUC_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Qui tradidit in manu illius universos vinctos qui in custodia tenebantur: et quidquid fiebat, sub ipso erat. ");
INSERT INTO latVUC_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Nec noverat aliquid, cunctis ei creditis: Dominus enim erat cum illo, et omnia opera ejus dirigebat. ");
INSERT INTO latVUC_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","His ita gestis, accidit ut peccarent duo eunuchi, pincerna regis Ægypti, et pistor, domino suo. ");
INSERT INTO latVUC_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Iratusque contra eos Pharao (nam alter pincernis præerat, alter pistoribus), ");
INSERT INTO latVUC_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","misit eos in carcerem principis militum, in quo erat vinctus et Joseph. ");
INSERT INTO latVUC_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","At custos carceris tradidit eos Joseph, qui et ministrabat eis: aliquantulum temporis fluxerat, et illi in custodia tenebantur. ");
INSERT INTO latVUC_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Videruntque ambo somnium nocte una, juxta interpretationem congruam sibi: ");
INSERT INTO latVUC_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ad quos cum introisset Joseph mane, et vidisset eos tristes, ");
INSERT INTO latVUC_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","sciscitatus est eos, dicens: Cur tristior est hodie solito facies vestra? ");
INSERT INTO latVUC_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Qui responderunt: Somnium vidimus, et non est qui interpretetur nobis. Dixitque ad eos Joseph: Numquid non Dei est interpretatio? referte mihi quid videritis. ");
INSERT INTO latVUC_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Narravit prior, præpositus pincernarum, somnium suum: Videbam coram me vitem, ");
INSERT INTO latVUC_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","in qua erant tres propagines, crescere paulatim in gemmas, et post flores uvas maturescere: ");
INSERT INTO latVUC_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","calicemque Pharaonis in manu mea: tuli ergo uvas, et expressi in calicem quem tenebam, et tradidi poculum Pharaoni. ");
INSERT INTO latVUC_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Respondit Joseph: Hæc est interpretatio somnii: tres propagines, tres adhuc dies sunt: ");
INSERT INTO latVUC_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","post quos recordabitur Pharao ministerii tui, et restituet te in gradum pristinum: dabisque ei calicem juxta officium tuum, sicut ante facere consueveras. ");
INSERT INTO latVUC_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tantum memento mei, cum bene tibi fuerit, et facias mecum misericordiam: ut suggeras Pharaoni ut educat me de isto carcere: ");
INSERT INTO latVUC_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","quia furto sublatus sum de terra Hebræorum, et hic innocens in lacum missus sum. ");
INSERT INTO latVUC_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Videns pistorum magister quod prudenter somnium dissolvisset, ait: Et ego vidi somnium: quod tria canistra farinæ haberem super caput meum: ");
INSERT INTO latVUC_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","et in uno canistro quod erat excelsius, portare me omnes cibos qui fiunt arte pistoria, avesque comedere ex eo. ");
INSERT INTO latVUC_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Respondit Joseph: Hæc est interpretatio somnii: tria canistra, tres adhuc dies sunt: ");
INSERT INTO latVUC_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","post quos auferet Pharao caput tuum, ac suspendet te in cruce, et lacerabunt volucres carnes tuas. ");
INSERT INTO latVUC_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Exinde dies tertius natalitius Pharaonis erat: qui faciens grande convivium pueris suis, recordatus est inter epulas magistri pincernarum, et pistorum principis. ");
INSERT INTO latVUC_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Restituitque alterum in locum suum, ut porrigeret ei poculum: ");
INSERT INTO latVUC_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","alterum suspendit in patibulo, ut conjectoris veritas probaretur. ");
INSERT INTO latVUC_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Et tamen succedentibus prosperis, præpositus pincernarum oblitus est interpretis sui. ");
INSERT INTO latVUC_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Post duos annos vidit Pharao somnium. Putabat se stare super fluvium, ");
INSERT INTO latVUC_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","de quo ascendebant septem boves, pulchræ et crassæ nimis: et pascebantur in locis palustribus. ");
INSERT INTO latVUC_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Aliæ quoque septem emergebant de flumine, fœdæ confectæque macie: et pascebantur in ipsa amnis ripa in locis virentibus: ");
INSERT INTO latVUC_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","devoraveruntque eas, quarum mira species et habitudo corporum erat. Expergefactus Pharao, ");
INSERT INTO latVUC_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","rursum dormivit, et vidit alterum somnium: septem spicæ pullulabant in culmo uno plenæ atque formosæ: ");
INSERT INTO latVUC_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","aliæ quoque totidem spicæ tenues, et percussæ uredine oriebantur, ");
INSERT INTO latVUC_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","devorantes omnium priorum pulchritudinem. Evigilans Pharao post quietem, ");
INSERT INTO latVUC_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","et facto mane, pavore perterritus, misit ad omnes conjectores Ægypti, cunctosque sapientes, et accersitis narravit somnium, nec erat qui interpretaretur. ");
INSERT INTO latVUC_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tunc demum reminiscens pincernarum magister, ait: Confiteor peccatum meum: ");
INSERT INTO latVUC_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","iratus rex servis suis, me et magistrum pistorum retrudi jussit in carcerem principis militum: ");
INSERT INTO latVUC_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ubi una nocte uterque vidimus somnium præsagum futurorum. ");
INSERT INTO latVUC_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Erat ibi puer hebræus, ejusdem ducis militum famulus: cui narrantes somnia, ");
INSERT INTO latVUC_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","audivimus quidquid postea rei probavit eventus; ego enim redditus sum officio meo, et ille suspensus est in cruce. ");
INSERT INTO latVUC_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Protinus ad regis imperium eductum de carcere Joseph totonderunt: ac veste mutata obtulerunt ei. ");
INSERT INTO latVUC_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Cui ille ait: Vidi somnia, nec est qui edisserat: quæ audivi te sapientissime conjicere. ");
INSERT INTO latVUC_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Respondit Joseph: Absque me Deus respondebit prospera Pharaoni. ");
INSERT INTO latVUC_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Narravit ergo Pharao quod viderat: Putabam me stare super ripam fluminis, ");
INSERT INTO latVUC_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","et septem boves de amne conscendere, pulchras nimis, et obesis carnibus: quæ in pastu paludis virecta carpebant. ");
INSERT INTO latVUC_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Et ecce, has sequebantur aliæ septem boves, in tantum deformes et macilentæ, ut numquam tales in terra Ægypti viderim: ");
INSERT INTO latVUC_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","quæ, devoratis et consumptis prioribus, ");
INSERT INTO latVUC_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","nullum saturitatis dedere vestigium: sed simili macie et squalore torpebant. Evigilans, rursus sopore depressus, ");
INSERT INTO latVUC_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","vidi somnium. Septem spicæ pullulabant in culmo uno plenæ atque pulcherrimæ. ");
INSERT INTO latVUC_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Aliæ quoque septem tenues et percussæ uredine, oriebantur e stipula: ");
INSERT INTO latVUC_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","quæ priorum pulchritudinem devoraverunt. Narravi conjectoribus somnium, et nemo est qui edisserat. ");
INSERT INTO latVUC_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Respondit Joseph: Somnium regis unum est: quæ facturus est Deus, ostendit Pharaoni. ");
INSERT INTO latVUC_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Septem boves pulchræ, et septem spicæ plenæ, septem ubertatis anni sunt: eamdemque vim somnii comprehendunt. ");
INSERT INTO latVUC_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Septem quoque boves tenues atque macilentæ, quæ ascenderunt post eas, et septem spicæ tenues, et vento urente percussæ, septem anni venturæ sunt famis. ");
INSERT INTO latVUC_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Qui hoc ordine complebuntur: ");
INSERT INTO latVUC_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ecce septem anni venient fertilitatis magnæ in universa terra Ægypti, ");
INSERT INTO latVUC_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","quos sequentur septem anni alii tantæ sterilitatis, ut oblivioni tradatur cuncta retro abundantia: consumptura est enim fames omnem terram, ");
INSERT INTO latVUC_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","et ubertatis magnitudinem perditura est inopiæ magnitudo. ");
INSERT INTO latVUC_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Quod autem vidisti secundo ad eamdem rem pertinens somnium: firmitatis indicium est, eo quod fiat sermo Dei, et velocius impleatur. ");
INSERT INTO latVUC_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Nunc ergo provideat rex virum sapientem et industrium, et præficiat eum terræ Ægypti: ");
INSERT INTO latVUC_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","qui constituat præpositos per cunctas regiones: et quintam partem fructuum per septem annos fertilitatis, ");
INSERT INTO latVUC_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","qui jam nunc futuri sunt, congreget in horrea: et omne frumentum sub Pharaonis potestate condatur, serveturque in urbibus. ");
INSERT INTO latVUC_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Et præparetur futuræ septem annorum fami, quæ oppressura est Ægyptum, et non consumetur terra inopia. ");
INSERT INTO latVUC_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Placuit Pharaoni consilium et cunctis ministris ejus: ");
INSERT INTO latVUC_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","locutusque est ad eos: Num invenire poterimus talem virum, qui spiritu Dei plenus sit? ");
INSERT INTO latVUC_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Dixit ergo ad Joseph: Quia ostendit tibi Deus omnia quæ locutus es, numquid sapientiorem et consimilem tui invenire potero? ");
INSERT INTO latVUC_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tu eris super domum meam, et ad tui oris imperium cunctus populus obediet: uno tantum regni solio te præcedam. ");
INSERT INTO latVUC_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Dixitque rursus Pharao ad Joseph: Ecce, constitui te super universam terram Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tulitque annulum de manu sua, et dedit eum in manu ejus: vestivitque eum stola byssina, et collo torquem auream circumposuit. ");
INSERT INTO latVUC_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Fecitque eum ascendere super currum suum secundum, clamante præcone, ut omnes coram eo genu flecterent, et præpositum esse scirent universæ terræ Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Dixit quoque rex ad Joseph: Ego sum Pharao: absque tuo imperio non movebit quisquam manum aut pedem in omni terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Vertitque nomen ejus, et vocavit eum, lingua ægyptiaca, Salvatorem mundi. Deditque illi uxorem Aseneth filiam Putiphare sacerdotis Heliopoleos. Egressus est itaque Joseph ad terram Ægypti ");
INSERT INTO latVUC_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","(triginta autem annorum erat quando stetit in conspectu regis Pharaonis), et circuivit omnes regiones Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Venitque fertilitas septem annorum: et in manipulos redactæ segetes congregatæ sunt in horrea Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Omnis etiam frugum abundantia in singulis urbibus condita est. ");
INSERT INTO latVUC_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tantaque fuit abundantia tritici, ut arenæ maris coæquaretur, et copia mensuram excederet. ");
INSERT INTO latVUC_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nati sunt autem Joseph filii duo antequam veniret fames: quos peperit ei Aseneth filia Putiphare sacerdotis Heliopoleos. ");
INSERT INTO latVUC_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Vocavitque nomen primogeniti Manasses, dicens: Oblivisci me fecit Deus omnium laborum meorum, et domus patris mei. ");
INSERT INTO latVUC_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nomen quoque secundi appellavit Ephraim, dicens: Crescere me fecit Deus in terra paupertatis meæ. ");
INSERT INTO latVUC_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Igitur transactis septem ubertatis annis, qui fuerant in Ægypto, ");
INSERT INTO latVUC_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","cœperunt venire septem anni inopiæ, quos prædixerat Joseph: et in universo orbe fames prævaluit, in cuncta autem terra Ægypti panis erat. ");
INSERT INTO latVUC_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Qua esuriente, clamavit populus ad Pharaonem, alimenta petens. Quibus ille respondit: Ite ad Joseph: et quidquid ipse vobis dixerit, facite. ");
INSERT INTO latVUC_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Crescebat autem quotidie fames in omni terra: aperuitque Joseph universa horrea, et vendebat Ægyptiis: nam et illos oppresserat fames. ");
INSERT INTO latVUC_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Omnesque provinciæ veniebant in Ægyptum, ut emerent escas, et malum inopiæ temperarent. ");
INSERT INTO latVUC_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Audiens autem Jacob quod alimenta venderentur in Ægypto, dixit filiis suis: Quare negligitis? ");
INSERT INTO latVUC_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","audivi quod triticum venundetur in Ægypto: descendite, et emite nobis necessaria, ut possimus vivere, et non consumamur inopia. ");
INSERT INTO latVUC_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Descendentes igitur fratres Joseph decem, ut emerent frumenta in Ægypto, ");
INSERT INTO latVUC_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Benjamin domi retento a Jacob, qui dixerat fratribus ejus: Ne forte in itinere quidquam patiatur mali: ");
INSERT INTO latVUC_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ingressi sunt terram Ægypti cum aliis qui pergebant ad emendum. Erat autem fames in terra Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Et Joseph erat princeps in terra Ægypti, atque ad ejus nutum frumenta populis vendebantur. Cumque adorassent eum fratres sui, ");
INSERT INTO latVUC_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","et agnovisset eos, quasi ad alienos durius loquebatur, interrogans eos: Unde venistis? Qui responderunt: De terra Chanaan, ut emamus victui necessaria. ");
INSERT INTO latVUC_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Et tamen fratres ipse cognoscens, non est cognitus ab eis. ");
INSERT INTO latVUC_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Recordatusque somniorum, quæ aliquando viderat, ait ad eos: Exploratores estis: ut videatis infirmiora terræ venistis. ");
INSERT INTO latVUC_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Qui dixerunt: Non est ita, domine, sed servi tui venerunt ut emerent cibos. ");
INSERT INTO latVUC_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Omnes filii unius viri sumus: pacifici venimus, nec quidquam famuli tui machinantur mali. ");
INSERT INTO latVUC_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Quibus ille respondit: Aliter est: immunita terræ hujus considerare venistis. ");
INSERT INTO latVUC_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","At illi: Duodecim, inquiunt, servi tui, fratres sumus, filii viri unius in terra Chanaan: minimus cum patre nostro est, alius non est super. ");
INSERT INTO latVUC_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Hoc est, ait, quod locutus sum: exploratores estis. ");
INSERT INTO latVUC_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Jam nunc experimentum vestri capiam: per salutem Pharaonis non egrediemini hinc, donec veniat frater vester minimus. ");
INSERT INTO latVUC_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mittite ex vobis unum, et adducat eum: vos autem eritis in vinculis, donec probentur quæ dixistis utrum vera an falsa sint: alioquin per salutem Pharaonis exploratores estis. ");
INSERT INTO latVUC_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Tradidit ergo illos custodiæ tribus diebus. ");
INSERT INTO latVUC_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Die autem tertio eductis de carcere, ait: Facite quæ dixi, et vivetis: Deum enim timeo. ");
INSERT INTO latVUC_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si pacifici estis, frater vester unus ligetur in carcere: vos autem abite, et ferte frumenta quæ emistis, in domos vestras, ");
INSERT INTO latVUC_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","et fratrem vestrum minimum ad me adducite, ut possim vestros probare sermones, et non moriamini. Fecerunt ut dixerat, ");
INSERT INTO latVUC_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","et locuti sunt ad invicem: Merito hæc patimur, quia peccavimus in fratrem nostrum, videntes angustiam animæ illius, dum deprecaretur nos, et non audivimus: idcirco venit super nos ista tribulatio. ");
INSERT INTO latVUC_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","E quibus unus Ruben, ait: Numquid non dixi vobis: Nolite peccare in puerum: et non audistis me? en sanguis ejus exquiritur. ");
INSERT INTO latVUC_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nesciebant autem quod intelligeret Joseph, eo quod per interpretem loqueretur ad eos. ");
INSERT INTO latVUC_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Avertitque se parumper, et flevit: et reversus locutus est ad eos. ");
INSERT INTO latVUC_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Tollensque Simeon, et ligans illis præsentibus, jussit ministris ut implerent eorum saccos tritico, et reponerent pecunias singulorum in sacculis suis, datis supra cibariis in viam: qui fecerunt ita. ");
INSERT INTO latVUC_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","At illi portantes frumenta in asinis suis, profecti sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Apertoque unus sacco, ut daret jumento pabulum in diversorio, contemplatus pecuniam in ore sacculi, ");
INSERT INTO latVUC_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","dixit fratribus suis: Reddita est mihi pecunia, en habetur in sacco. Et obstupefacti, turbatique, mutuo dixerunt: Quidnam est hoc quod fecit nobis Deus? ");
INSERT INTO latVUC_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Veneruntque ad Jacob patrem suum in terram Chanaan, et narraverunt ei omnia quæ accidissent sibi, dicentes: ");
INSERT INTO latVUC_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Locutus est nobis dominus terræ dure, et putavit nos exploratores esse provinciæ. ");
INSERT INTO latVUC_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Cui respondimus: Pacifici sumus, nec ullas molimur insidias. ");
INSERT INTO latVUC_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Duodecim fratres uno patre geniti sumus: unus non est super, minimus cum patre nostro est in terra Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Qui ait nobis: Sic probabo quod pacifici sitis: fratrem vestrum unum dimittite apud me, et cibaria domibus vestris necessaria sumite, et abite, ");
INSERT INTO latVUC_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","fratremque vestrum minimum adducite ad me, ut sciam quod non sitis exploratores: et istum, qui tenetur in vinculis, recipere possitis: ac deinceps quæ vultis, emendi habeatis licentiam. ");
INSERT INTO latVUC_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","His dictis, cum frumenta effunderent, singuli repererunt in ore saccorum ligatas pecunias, exterritisque simul omnibus, ");
INSERT INTO latVUC_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","dixit pater Jacob: Absque liberis me esse fecistis: Joseph non est super, Simeon tenetur in vinculis, et Benjamin auferetis: in me hæc omnia mala reciderunt. ");
INSERT INTO latVUC_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Cui respondit Ruben: Duos filios meos interfice, si non reduxero illum tibi: trade illum in manu mea, et ego eum tibi restituam. ");
INSERT INTO latVUC_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","At ille: Non descendet, inquit, filius meus vobiscum: frater ejus mortuus est, et ipse solus remansit: si quid ei adversi acciderit in terra ad quam pergitis, deducetis canos meos cum dolore ad inferos. ");
INSERT INTO latVUC_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Interim fames omnem terram vehementer premebat. ");
INSERT INTO latVUC_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Consumptisque cibis quos ex Ægypto detulerant, dixit Jacob ad filios suos: Revertimini, et emite nobis pauxillum escarum. ");
INSERT INTO latVUC_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Respondit Judas: Denuntiavit nobis vir ille sub attestatione jurisjurandi, dicens: Non videbitis faciem meam, nisi fratrem vestrum minimum adduxeritis vobiscum. ");
INSERT INTO latVUC_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si ergo vis eum mittere nobiscum, pergemus pariter, et ememus tibi necessaria: ");
INSERT INTO latVUC_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","sin autem non vis, non ibimus: vir enim, ut sæpe diximus, denuntiavit nobis, dicens: Non videbitis faciem meam absque fratre vestro minimo. ");
INSERT INTO latVUC_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Dixit eis Israël: In meam hoc fecistis miseriam, ut indicaretis ei et alium habere vos fratrem. ");
INSERT INTO latVUC_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","At illi responderunt: Interrogavit nos homo per ordinem nostram progeniem: si pater viveret: si haberemus fratrem: et nos respondimus ei consequenter juxta id quod fuerat sciscitatus: numquid scire poteramus quod dicturus esset: Adducite fratrem vestrum vobiscum? ");
INSERT INTO latVUC_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judas quoque dixit patri suo: Mitte puerum mecum, ut proficiscamur, et possimus vivere: ne moriamur nos et parvuli nostri. ");
INSERT INTO latVUC_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ego suscipio puerum: de manu mea require illum: nisi reduxero, et reddidero eum tibi, ero peccati reus in te omni tempore. ");
INSERT INTO latVUC_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Si non intercessisset dilatio, jam vice alter venissemus. ");
INSERT INTO latVUC_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Igitur Israël pater eorum dixit ad eos: Si sic necesse est, facite quod vultis: sumite de optimis terræ fructibus in vasis vestris, et deferte viro munera, modicum resinæ, et mellis, et storacis, stactes, et terebinthi, et amygdalarum. ");
INSERT INTO latVUC_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Pecuniam quoque duplicem ferte vobiscum: et illam, quam invenistis in sacculis, reportate, ne forte errore factum sit: ");
INSERT INTO latVUC_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","sed et fratrem vestrum tollite, et ite ad virum. ");
INSERT INTO latVUC_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Deus autem meus omnipotens faciat vobis eum placabilem: et remittat vobiscum fratrem vestrum quem tenet, et hunc Benjamin: ego autem quasi orbatus absque liberis ero. ");
INSERT INTO latVUC_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tulerunt ergo viri munera, et pecuniam duplicem, et Benjamin: descenderuntque in Ægyptum, et steterunt coram Joseph. ");
INSERT INTO latVUC_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Quos cum ille vidisset et Benjamin simul, præcepit dispensatori domus suæ, dicens: Introduc viros domum, et occide victimas, et instrue convivium: quoniam mecum sunt comesturi meridie. ");
INSERT INTO latVUC_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Fecit ille quod sibi fuerat imperatum, et introduxit viros domum. ");
INSERT INTO latVUC_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ibique exterriti, dixerunt mutuo: Propter pecuniam, quam retulimus prius in saccis nostris, introducti sumus: ut devolvat in nos calumniam, et violenter subjiciat servituti et nos, et asinos nostros. ");
INSERT INTO latVUC_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Quam ob rem in ipsis foribus accedentes ad dispensatorem domus, ");
INSERT INTO latVUC_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","locuti sunt: Oramus, domine, ut audias nos. Jam ante descendimus ut emeremus escas: ");
INSERT INTO latVUC_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","quibus emptis, cum venissemus ad diversorium, aperuimus saccos nostros, et invenimus pecuniam in ore saccorum: quam nunc eodem pondere reportavimus. ");
INSERT INTO latVUC_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Sed et aliud attulimus argentum, ut emamus quæ nobis necessaria sunt: non est in nostra conscientia quis posuerit eam in marsupiis nostris. ");
INSERT INTO latVUC_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","At ille respondit: Pax vobiscum, nolite timere: Deus vester, et Deus patris vestri, dedit vobis thesauros in saccis vestris: nam pecuniam, quam dedistis mihi, probatam ego habeo. Eduxitque ad eos Simeon. ");
INSERT INTO latVUC_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Et introductis domum, attulit aquam, et laverunt pedes suos, deditque pabulum asinis eorum. ");
INSERT INTO latVUC_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Illi vero parabant munera, donec ingrederetur Joseph meridie: audierant enim quod ibi comesturi essent panem. ");
INSERT INTO latVUC_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Igitur ingressus est Joseph domum suam, obtuleruntque ei munera, tenentes in manibus suis: et adoraverunt proni in terram. ");
INSERT INTO latVUC_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","At ille, clementer resalutatis eis, interrogavit eos, dicens: Salvusne est pater vester senex, de quo dixeratis mihi? adhuc vivit? ");
INSERT INTO latVUC_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Qui responderunt: Sospes est servus tuus pater noster, adhuc vivit. Et incurvati, adoraverunt eum. ");
INSERT INTO latVUC_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Attollens autem Joseph oculos, vidit Benjamin fratrem suum uterinum, et ait: Iste est frater vester parvulus, de quo dixeratis mihi? Et rursum: Deus, inquit, misereatur tui, fili mi. ");
INSERT INTO latVUC_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Festinavitque, quia commota fuerant viscera ejus super fratre suo, et erumpebant lacrimæ: et introiens cubiculum flevit. ");
INSERT INTO latVUC_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Rursumque lota facie egressus, continuit se, et ait: Ponite panes. ");
INSERT INTO latVUC_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Quibus appositis, seorsum Joseph, et seorsum fratribus, Ægyptiis quoque qui vescebantur simul, seorsum (illicitum est enim Ægyptiis comedere cum Hebræis, et profanum putant hujuscemodi convivium) ");
INSERT INTO latVUC_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","sederunt coram eo, primogenitus juxta primogenita sua, et minimus juxta ætatem suam. Et mirabantur nimis, ");
INSERT INTO latVUC_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","sumptis partibus quas ab eo acceperant: majorque pars venit Benjamin, ita ut quinque partibus excederet. Biberuntque et inebriati sunt cum eo. ");
INSERT INTO latVUC_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Præcepit autem Joseph dispensatori domus suæ, dicens: Imple saccos eorum frumento, quantum possunt capere: et pone pecuniam singulorum in summitate sacci. ");
INSERT INTO latVUC_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Scyphum autem meum argenteum, et pretium quod dedit tritici, pone in ore sacci junioris. Factumque est ita. ");
INSERT INTO latVUC_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Et orto mane, dimissi sunt cum asinis suis. ");
INSERT INTO latVUC_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Jamque urbem exierant, et processerant paululum: tunc Joseph accersito dispensatore domus, Surge, inquit, et persequere viros: et apprehensis dicito: Quare reddidistis malum pro bono? ");
INSERT INTO latVUC_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","scyphus, quem furati estis, ipse est in quo bibit dominus meus, et in quo augurari solet: pessimam rem fecistis. ");
INSERT INTO latVUC_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Fecit ille ut jusserat: et apprehensis per ordinem locutus est. ");
INSERT INTO latVUC_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Qui responderunt: Quare sic loquitur dominus noster, ut servi tui tantum flagitii commiserint? ");
INSERT INTO latVUC_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","pecuniam, quam invenimus in summitate saccorum, reportavimus ad te de terra Chanaan: et quomodo consequens est ut furati simus de domo domini tui aurum vel argentum? ");
INSERT INTO latVUC_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","apud quemcumque fuerit inventum servorum tuorum quod quæris, moriatur, et nos erimus servi domini nostri. ");
INSERT INTO latVUC_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Qui dixit eis: Fiat juxta vestram sententiam: apud quemcumque fuerit inventus, ipse sit servus meus, vos autem eritis innoxii. ");
INSERT INTO latVUC_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Itaque festinato deponentes in terram saccos, aperuerunt singuli. ");
INSERT INTO latVUC_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Quos scrutatus, incipiens a majore usque ad minimum, invenit scyphum in sacco Benjamin. ");
INSERT INTO latVUC_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","At illi, scissis vestibus, oneratisque rursum asinis, reversi sunt in oppidum. ");
INSERT INTO latVUC_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Primusque Judas cum fratribus ingressus est ad Joseph (necdum enim de loco abierat) omnesque ante eum pariter in terram corruerunt. ");
INSERT INTO latVUC_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Quibus ille ait: Cur sic agere voluistis? an ignoratis quod non sit similis mei in augurandi scientia? ");
INSERT INTO latVUC_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Cui Judas: Quid respondebimus, inquit, domino meo? vel quid loquemur, aut juste poterimus obtendere? Deus invenit iniquitatem servorum tuorum: en omnes servi sumus domini mei, et nos, et apud quem inventus est scyphus. ");
INSERT INTO latVUC_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Respondit Joseph: Absit a me ut sic agam: qui furatus est scyphum, ipse sit servus meus: vos autem abite liberi ad patrem vestrum. ");
INSERT INTO latVUC_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Accedens autem propius Judas, confidenter ait: Oro, domini mi, loquatur servus tuus verbum in auribus tuis, et ne irascaris famulo tuo: tu es enim post Pharaonem ");
INSERT INTO latVUC_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","dominus meus. Interrogasti prius servos tuos: Habetis patrem aut fratrem? ");
INSERT INTO latVUC_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","et nos respondimus tibi domino meo: Est nobis pater senex, et puer parvulus, qui in senectute illius natus est: cujus uterinus frater mortuus est: et ipsum solum habet mater sua, pater vero tenere diliget eum. ");
INSERT INTO latVUC_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Dixistique servis tuis: Adducite eum ad me, et ponam oculos meos super illum. ");
INSERT INTO latVUC_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Suggessimus domino meo: Non potest puer relinquere patrem suum: si enim illum dimiserit, morietur. ");
INSERT INTO latVUC_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Et dixisti servis tuis: Nisi venerit frater vester minimus vobiscum, non videbitis amplius faciem meam. ");
INSERT INTO latVUC_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Cum ergo ascendissemus ad famulum tuum patrem nostrum, narravimus ei omnia quæ locutus est dominus meus. ");
INSERT INTO latVUC_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Et dixit pater noster: Revertimini, et emite nobis parum tritici. ");
INSERT INTO latVUC_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Cui diximus: Ire non possumus: si frater noster minimus descenderit nobiscum, proficiscemur simul: alioquin illo absente, non audemus videre faciem viri. ");
INSERT INTO latVUC_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ad quæ ille respondit: Vos scitis quod duos genuerit mihi uxor mea. ");
INSERT INTO latVUC_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Egressus est unus, et dixistis: Bestia devoravit eum: et hucusque non comparet. ");
INSERT INTO latVUC_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si tuleritis et istum, et aliquid ei in via contigerit, deducetis canos meos cum mœrore ad inferos. ");
INSERT INTO latVUC_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Igitur si intravero ad servum tuum patrem nostrum, et puer defuerit (cum anima illius ex hujus anima pendeat), ");
INSERT INTO latVUC_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","videritque eum non esse nobiscum, morietur, et deducent famuli tui canos ejus cum dolore ad inferos. ");
INSERT INTO latVUC_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ego proprie servus tuus sim qui in meam hunc recepi fidem, et spopondi dicens: Nisi reduxero eum, peccati reus ero in patrem meum omni tempore. ");
INSERT INTO latVUC_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Manebo itaque servus tuus pro puero in ministerio domini mei, et puer ascendat cum fratribus suis. ");
INSERT INTO latVUC_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Non enim possum redire ad patrem meum, absente puero: ne calamitatis, quæ oppressura est patrem meum, testis assistam. ");
INSERT INTO latVUC_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Non se poterat ultra cohibere Joseph multis coram astantibus: unde præcepit ut egrederentur cuncti foras, et nullus interesset alienus agnitioni mutuæ. ");
INSERT INTO latVUC_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Elevavitque vocem cum fletu, quam audierunt Ægyptii, omnisque domus Pharaonis. ");
INSERT INTO latVUC_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Et dixit fratribus suis: Ego sum Joseph: adhuc pater meus vivit? Non poterant respondere fratres nimio terrore perterriti. ");
INSERT INTO latVUC_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ad quos ille clementer: Accedite, inquit, ad me. Et cum accessissent prope: Ego sum, ait, Joseph, frater vester, quem vendidistis in Ægyptum. ");
INSERT INTO latVUC_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nolite pavere, neque vobis durum esse videatur quod vendidistis me in his regionibus: pro salute enim vestra misit me Deus ante vos in Ægyptum. ");
INSERT INTO latVUC_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Biennium est enim quod cœpit fames esse in terra: et adhuc quinque anni restant, quibus nec arari poterit, nec meti. ");
INSERT INTO latVUC_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Præmisitque me Deus ut reservemini super terram, et escas ad vivendum habere possitis. ");
INSERT INTO latVUC_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Non vestro consilio, sed Dei voluntate huc missum sum: qui fecit me quasi patrem Pharaonis, et dominum universæ domus ejus, ac principem in omni terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Festinate, et ascendite ad patrem meum, et dicetis ei: Hæc mandat filius tuus Joseph: Deus fecit me dominum universæ terræ Ægypti: descende ad me, ne moreris, ");
INSERT INTO latVUC_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","et habitabis in terra Gessen: erisque juxta me tu, et filii tui, et filii filiorum tuorum, oves tuæ, et armenta tua, et universa quæ possides: ");
INSERT INTO latVUC_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ibique te pascam (adhuc enim quinque anni residui sunt famis) ne et tu pereas, et domus tua, et omnia quæ possides. ");
INSERT INTO latVUC_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","En oculi vestri, et oculi fratris mei Benjamin, vident quod os meum loquatur ad vos. ");
INSERT INTO latVUC_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Nuntiate patri meo universam gloriam meam, et cuncta quæ vidistis in Ægypto: festinate, et adducite eum ad me. ");
INSERT INTO latVUC_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Cumque amplexatus recidisset in collum Benjamin fratris sui, flevit: illo quoque similiter flente super collum ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Osculatusque est Joseph omnes fratres suos, et ploravit super singulos: post quæ ausi sunt loqui ad eum. ");
INSERT INTO latVUC_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Auditumque est, et celebri sermone vulgatum in aula regis: Venerunt fratres Joseph: et gavisus est Pharao, atque omnis familia ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Dixitque ad Joseph ut imperaret fratribus suis, dicens: Onerantes jumenta, ite in terram Chanaan, ");
INSERT INTO latVUC_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","et tollite inde patrem vestrum et cognationem, et venite ad me: et ego dabo vobis omnia bona Ægypti, ut comedatis medullam terræ. ");
INSERT INTO latVUC_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Præcipe etiam ut tollant plaustra de terra Ægypti, ad subvectionem parvulorum suorum ac conjugum: et dicito: Tollite patrem vestrum, et properate quantocius venientes. ");
INSERT INTO latVUC_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nec dimittatis quidquam de supellectili vestra: quia omnes opes Ægypti vestræ erunt. ");
INSERT INTO latVUC_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Feceruntque filii Israël ut eis mandatum fuerat. Quibus dedit Joseph plaustra, secundum Pharaonis imperium, et cibaria in itinere. ");
INSERT INTO latVUC_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Singulis quoque proferri jussit binas stolas: Benjamin vero dedit trecentos argenteos cum quinque stolis optimis: ");
INSERT INTO latVUC_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","tantumdem pecuniæ et vestium mittens patri suo, addens et asinos decem, qui subveherent ex omnibus divitiis Ægypti, et totidem asinas, triticum in itinere, panesque portantes. ");
INSERT INTO latVUC_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Dimisit ergo fratres suos, et proficiscentibus ait: Ne irascamini in via. ");
INSERT INTO latVUC_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Qui ascendentes ex Ægypto, venerunt in terram Chanaan ad patrem suum Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Et nuntiaverunt ei, dicentes: Joseph filius tuus vivit: et ipse dominatur in omni terra Ægypti. Quo audito Jacob, quasi de gravi somno evigilans, tamen non credebat eis. ");
INSERT INTO latVUC_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Illi e contra referebant omnem ordinem rei. Cumque vidisset plaustra et universa quæ miserat, revixit spiritus ejus, ");
INSERT INTO latVUC_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","et ait: Sufficit mihi si adhuc Joseph filius meus vivit: vadam, et videbo illum antequam moriar. ");
INSERT INTO latVUC_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Profectusque Israël cum omnibus quæ habebat, venit ad Puteum juramenti: et mactatis ibi victimis Deo patris sui Isaac, ");
INSERT INTO latVUC_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","audivit eum per visionem noctis vocantem se, et dicentem sibi: Jacob, Jacob. Cui respondit: Ecce adsum. ");
INSERT INTO latVUC_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ait illi Deus: Ego sum fortissimus Deus patris tui: noli timere, descende in Ægyptum, quia in gentem magnam faciam te ibi. ");
INSERT INTO latVUC_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ego descendam tecum illuc, et ego inde adducam te revertentem: Joseph quoque ponet manus suas super oculos tuos. ");
INSERT INTO latVUC_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Surrexit autem Jacob a Puteo juramenti: tuleruntque eum filii cum parvulis et uxoribus suis in plaustris quæ miserat Pharao ad portandum senem, ");
INSERT INTO latVUC_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","et omnia quæ possederat in terra Chanaan: venitque in Ægyptum cum omni semine suo, ");
INSERT INTO latVUC_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","filii ejus, et nepotes, filiæ, et cuncta simul progenies. ");
INSERT INTO latVUC_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Hæc sunt autem nomina filiorum Israël, qui ingressi sunt in Ægyptum, ipse cum liberis suis. Primogenitus Ruben. ");
INSERT INTO latVUC_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Filii Ruben: Henoch et Phallu et Hesron et Charmi. ");
INSERT INTO latVUC_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Filii Simeon: Jamuel et Jamin et Ahod, et Jachin et Sohar, et Saul filius Chanaanitidis. ");
INSERT INTO latVUC_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Filii Levi: Gerson et Caath et Merari. ");
INSERT INTO latVUC_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Filii Juda: Her et Onan et Sela et Phares et Zara; mortui sunt autem Her et Onan in terra Chanaan. Natique sunt filii Phares: Hesron et Hamul. ");
INSERT INTO latVUC_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Filii Issachar: Thola et Phua et Job et Semron. ");
INSERT INTO latVUC_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Filii Zabulon: Sared et Elon et Jahelel. ");
INSERT INTO latVUC_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hi filii Liæ quos genuit in Mesopotamia Syriæ cum Dina filia sua: omnes animæ filiorum ejus et filiarum, triginta tres. ");
INSERT INTO latVUC_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Filii Gad: Sephion et Haggi et Suni et Esebon et Heri et Arodi et Areli. ");
INSERT INTO latVUC_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Filii Aser: Jamne et Jesua et Jessui et Beria, Sara quoque soror eorum. Filii Beria: Heber et Melchiel. ");
INSERT INTO latVUC_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hi filii Zelphæ, quam dedit Laban Liæ filiæ suæ: et hos genuit Jacob sedecim animas. ");
INSERT INTO latVUC_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Filii Rachel uxoris Jacob: Joseph et Benjamin. ");
INSERT INTO latVUC_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Natique sunt Joseph filii in terra Ægypti, quos genuit ei Aseneth filia Putiphare sacerdotis Heliopoleos: Manasses et Ephraim. ");
INSERT INTO latVUC_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Filii Benjamin: Bela et Bechor et Asbel et Gera et Naaman et Echi et Ros et Mophim et Ophim et Ared. ");
INSERT INTO latVUC_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hi filii Rachel quos genuit Jacob: omnes animæ, quatuordecim. ");
INSERT INTO latVUC_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Filii Dan: Husim. ");
INSERT INTO latVUC_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Filii Nephthali: Jasiel et Guni et Jeser et Sallem. ");
INSERT INTO latVUC_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hi filii Balæ, quam dedit Laban Racheli filiæ suæ: et hos genuit Jacob: omnes animæ, septem. ");
INSERT INTO latVUC_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Cunctæ animæ, quæ ingressæ sunt cum Jacob in Ægyptum, et egressæ sunt de femore illius, absque uxoribus filiorum ejus, sexaginta sex. ");
INSERT INTO latVUC_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Filii autem Joseph, qui nati sunt ei in terra Ægypti, animæ duæ. Omnes animæ domus Jacob, quæ ingressæ sunt in Ægyptum, fuere septuaginta. ");
INSERT INTO latVUC_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Misit autem Judam ante se ad Joseph, ut nuntiaret ei, et occurreret in Gessen. ");
INSERT INTO latVUC_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Quo cum pervenisset, juncto Joseph curro suo, ascendit obviam patri suo ad eumdem locum: vidensque eum, irruit super collum ejus, et inter amplexus flevit. ");
INSERT INTO latVUC_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Dixitque pater ad Joseph: Jam lætus moriar, quia vidi faciem tuam, et superstitem te relinquo. ");
INSERT INTO latVUC_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","At ille locutus est ad fratres suos, et ad omnem domum patris sui: Ascendam, et nuntiabo Pharaoni, dicamque ei: Fratres mei, et domus patris mei, qui erant in terra Chanaan, venerunt ad me: ");
INSERT INTO latVUC_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","et sunt viri pastores ovium, curamque habent alendorum gregum: pecora sua, et armenta, et omnia quæ habere potuerunt, adduxerunt secum. ");
INSERT INTO latVUC_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Cumque vocaverit vos, et dixerit: Quod est opus vestrum? ");
INSERT INTO latVUC_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","respondebitis: Viri pastores sumus servi tui, ab infantia nostra usque in præsens, et nos et patres nostri. Hæc autem dicetis, ut habitare possitis in terra Gessen: quia detestantur Ægyptii omnes pastores ovium. ");
INSERT INTO latVUC_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ingressus ergo Joseph nuntiavit Pharaoni, dicens: Pater meus et fratres, oves eorum et armenta, et cuncta quæ possident, venerunt de terra Chanaan: et ecce consistunt in terra Gessen. ");
INSERT INTO latVUC_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Extremos quoque fratrum suorum quinque viros constituit coram rege: ");
INSERT INTO latVUC_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","quos ille interrogavit: Quid habetis operis? Responderunt: Pastores ovium sumus servi tui, et nos et patres nostri. ");
INSERT INTO latVUC_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ad peregrinandum in terra tua venimus: quoniam non est herba gregibus servorum tuorum, ingravescente fame in terra Chanaan: petimusque ut esse nos jubeas servos tuos in terra Gessen. ");
INSERT INTO latVUC_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Dixit itaque rex ad Joseph: Pater tuus et fratres tui venerunt ad te. ");
INSERT INTO latVUC_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Terra Ægypti in conspectu tuo est: in optimo loco fac eos habitare, et trade eis terram Gessen. Quod si nosti in eis esse viros industrios, constitue illos magistros pecorum meorum. ");
INSERT INTO latVUC_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Post hæc introduxit Joseph patrem suum ad regem, et statuit eum coram eo: qui benedicens illi, ");
INSERT INTO latVUC_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","et interrogatus ab eo: Quot sunt dies annorum vitæ tuæ? ");
INSERT INTO latVUC_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","respondit: Dies peregrinationis meæ centum triginta annorum sunt, parvi et mali, et non pervenerunt usque ad dies patrum meorum quibus peregrinati sunt. ");
INSERT INTO latVUC_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Et benedicto rege, egressus est foras. ");
INSERT INTO latVUC_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph vero patri et fratribus suis dedit possessionem in Ægypto in optimo terræ loco, Ramesses, ut præceperat Pharao. ");
INSERT INTO latVUC_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Et alebat eos, omnemque domum patris sui, præbens cibaria singulis. ");
INSERT INTO latVUC_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","In toto enim orbe panis deerat, et oppresserat fames terram, maxime Ægypti et Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","E quibus omnem pecuniam congregavit pro venditione frumenti, et intulit eam in ærarium regis. ");
INSERT INTO latVUC_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Cumque defecisset emptoribus pretium, venit cuncta Ægyptus ad Joseph, dicens: Da nobis panes: quare morimur coram te, deficiente pecunia? ");
INSERT INTO latVUC_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Quibus ille respondit: Adducite pecora vestra, et dabo vobis pro eis cibos, si pretium non habetis. ");
INSERT INTO latVUC_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Quæ cum adduxissent, dedit eis alimenta pro equis, et ovibus, et bobus, et asinis: sustentavitque eos illo anno pro commutatione pecorum. ");
INSERT INTO latVUC_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Venerunt quoque anno secundo, et dixerunt ei: Non celabimus dominum nostrum quod deficiente pecunia, pecora simul defecerunt: nec clam te est, quod absque corporibus et terra nihil habeamus. ");
INSERT INTO latVUC_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Cur ergo moriemur te vidente? et nos et terra nostra tui erimus: eme nos in servitutem regiam, et præbe semina, ne pereunte cultore redigatur terra in solitudinem. ");
INSERT INTO latVUC_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Emit igitur Joseph omnem terram Ægypti, vendentibus singulis possessiones suas præ magnitudine famis. Subjecitque eam Pharaoni, ");
INSERT INTO latVUC_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","et cunctos populos ejus a novissimis terminis Ægypti usque ad extremos fines ejus, ");
INSERT INTO latVUC_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","præter terram sacerdotum, quæ a rege tradita fuerat eis: quibus et statuta cibaria ex horreis publicis præbebantur, et idcirco non sunt compulsi vendere possessiones suas. ");
INSERT INTO latVUC_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Dixit ergo Joseph ad populos: En ut cernitis, et vos et terram vestram Pharao possidet: accipite semina, et serite agros, ");
INSERT INTO latVUC_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ut fruges habere possitis. Quintam partem regi dabitis: quatuor reliquas permitto vobis in sementem, et in cibum familiis et liberis vestris. ");
INSERT INTO latVUC_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Qui responderunt: Salus nostra in manu tua est: respiciat nos tantum dominus noster, et læti serviemus regi. ");
INSERT INTO latVUC_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ex eo tempore usque in præsentem diem, in universa terra Ægypti regibus quinta pars solvitur, et factum est quasi in legem, absque terra sacerdotali, quæ libera ab hac conditione fuit. ");
INSERT INTO latVUC_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Habitavit ergo Israël in Ægypto, id est, in terra Gessen, et possedit eam: auctusque est, et multiplicatus nimis. ");
INSERT INTO latVUC_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Et vixit in ea decem et septem annis: factique sunt omnes dies vitæ illius, centum quadraginta septem annorum. ");
INSERT INTO latVUC_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Cumque appropinquare cerneret diem mortis suæ, vocavit filium suum Joseph, et dixit ad eum: Si inveni gratiam in conspectu tuo, pone manum tuam sub femore meo: et facies mihi misericordiam et veritatem, ut non sepelias me in Ægypto: ");
INSERT INTO latVUC_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","sed dormiam cum patribus meis, et auferas me de terra hac, condasque in sepulchro majorum meorum. Cui respondit Joseph: Ego faciam quod jussisti. ");
INSERT INTO latVUC_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Et ille: Jura ergo, inquit, mihi. Quo jurante, adoravit Israël Deum, conversus ad lectuli caput. ");
INSERT INTO latVUC_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","His ita transactis, nuntiatum est Joseph quod ægrotaret pater suus: qui, assumptis duobus filiis Manasse et Ephraim, ire perrexit. ");
INSERT INTO latVUC_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Dictumque est seni: Ecce filius tuus Joseph venit ad te. Qui confortatus sedit in lectulo. ");
INSERT INTO latVUC_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Et ingresso ad se ait: Deus omnipotens apparuit mihi in Luza, quæ est in terra Chanaan: benedixitque mihi, ");
INSERT INTO latVUC_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","et ait: Ego te augebo et multiplicabo, et faciam te in turbas populorum: daboque tibi terram hanc, et semini tuo post te in possessionem sempiternam. ");
INSERT INTO latVUC_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Duo ergo filii tui, qui nati sunt tibi in terra Ægypti antequam huc venirem ad te, mei erunt: Ephraim et Manasses, sicut Ruben et Simeon reputabuntur mihi. ");
INSERT INTO latVUC_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Reliquos autem quos genueris post eos, tui erunt, et nomine fratrum suorum vocabuntur in possessionibus suis. ");
INSERT INTO latVUC_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mihi enim, quando veniebam de Mesopotamia, mortua est Rachel in terra Chanaan in ipso itinere, eratque vernum tempus: et ingrediebar Ephratam, et sepelivi eam juxta viam Ephratæ, quæ alio nomine appellatur Bethlehem. ");
INSERT INTO latVUC_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Videns autem filios ejus dixit ad eum: Qui sunt isti? ");
INSERT INTO latVUC_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Respondit: Filii mei sunt, quos donavit mihi Deus in hoc loco. Adduc, inquit, eos ad me, ut benedicam illis. ");
INSERT INTO latVUC_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Oculi enim Israël caligabant præ nimia senectute, et clare videre non poterat. Applicitosque ad se, deosculatus et circumplexus eos, ");
INSERT INTO latVUC_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","dixit ad filium suum: Non sum fraudatus aspectu tuo: insuper ostendit mihi Deus semen tuum. ");
INSERT INTO latVUC_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Cumque tulisset eos Joseph de gremio patris, adoravit pronus in terram. ");
INSERT INTO latVUC_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Et posuit Ephraim ad dexteram suam, id est, ad sinistram Israël: Manassen vero in sinistra sua, ad dexteram scilicet patris, applicuitque ambos ad eum. ");
INSERT INTO latVUC_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Qui extendens manum dexteram, posuit super caput Ephraim minoris fratris: sinistram autem super caput Manasse qui major natu erat, commutans manus. ");
INSERT INTO latVUC_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Benedixitque Jacob filiis Joseph, et ait: Deus, in cujus conspectu ambulaverunt patres mei Abraham, et Isaac; Deus qui pascit me ab adolescentia mea usque in præsentem diem: ");
INSERT INTO latVUC_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","angelus, qui eruit me de cunctis malis, benedicat pueris istis: et invocetur super eos nomen meum, nomina quoque patrum meorum Abraham et Isaac, et crescant in multitudinem super terram. ");
INSERT INTO latVUC_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Videns autem Joseph quod posuisset pater suus dexteram manum super caput Ephraim, graviter accepit: et apprehensam manum patris levare conatus est de capite Ephraim, et transferre super caput Manasse. ");
INSERT INTO latVUC_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Dixitque ad patrem: Non ita convenit, pater: quia hic est primogenitus, pone dexteram tuam super caput ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Qui renuens, ait: Scio, fili mi, scio: et iste quidem erit in populos, et multiplicabitur: sed frater ejus minor, major erit illo: et semen illius crescet in gentes. ");
INSERT INTO latVUC_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Benedixitque eis in tempore illo, dicens: In te benedicetur Israël, atque dicetur: Faciat tibi Deus sicut Ephraim, et sicut Manasse. Constituitque Ephraim ante Manassen. ");
INSERT INTO latVUC_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Et ait ad Joseph filium suum: En ego morior, et erit Deus vobiscum, reducetque vos ad terram patrum vestrorum. ");
INSERT INTO latVUC_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Do tibi partem unam extra fratres tuos, quam tuli de manu Amorrhæi in gladio et arcu meo. ");
INSERT INTO latVUC_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Vocavit autem Jacob filios suos, et ait eis: Congregamini, ut annuntiem quæ ventura sunt vobis in diebus novissimis. ");
INSERT INTO latVUC_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Congregamini, et audite, filii Jacob, audite Israël patrem vestrum: ");
INSERT INTO latVUC_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, primogenitus meus, tu fortitudo mea, et principium doloris mei; prior in donis, major in imperio. ");
INSERT INTO latVUC_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Effusus es sicut aqua, non crescas: quia ascendisti cubile patris tui, et maculasti stratum ejus. ");
INSERT INTO latVUC_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon et Levi fratres vasa iniquitatis bellantia. ");
INSERT INTO latVUC_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","In consilium eorum non veniat anima mea, et in cœtu illorum non sit gloria mea: quia in furore suo occiderunt virum, et in voluntate sua suffoderunt murum. ");
INSERT INTO latVUC_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maledictus furor eorum, quia pertinax: et indignatio eorum, quia dura: dividam eos in Jacob, et dispergam eos in Israël. ");
INSERT INTO latVUC_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, te laudabunt fratres tui: manus tua in cervicibus inimicorum tuorum, adorabunt te filii patris tui. ");
INSERT INTO latVUC_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Catulus leonis Juda: ad prædam, fili mi, ascendisti: requiescens accubuisti ut leo, et quasi leæna: quis suscitabit eum? ");
INSERT INTO latVUC_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Non auferetur sceptrum de Juda, et dux de femore ejus, donec veniat qui mittendus est, et ipse erit expectatio gentium. ");
INSERT INTO latVUC_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ligans ad vineam pullum suum, et ad vitem, o fili mi, asinam suam, lavabit in vino stolam suam et in sanguine uvæ pallium suum. ");
INSERT INTO latVUC_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Pulchriores sunt oculi ejus vino, et dentes ejus lacte candidiores. ");
INSERT INTO latVUC_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon in littore maris habitabit, et in statione navium pertingens usque ad Sidonem. ");
INSERT INTO latVUC_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar asinus fortis accubans inter terminos. ");
INSERT INTO latVUC_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Vidit requiem, quod esset bona et terram, quod optima: et supposuit humerum suum ad portandum, factusque est tributis serviens. ");
INSERT INTO latVUC_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan judicabit populum suum sicut et alia tribus in Israël. ");
INSERT INTO latVUC_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Fiat Dan coluber in via, cerastes in semita, mordens ungulas equi, ut cadat ascensor ejus retro. ");
INSERT INTO latVUC_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Salutare tuum expectabo, Domine. ");
INSERT INTO latVUC_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, accinctus præliabatur ante eum: et ipse accingetur retrorsum. ");
INSERT INTO latVUC_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, pinguis panis ejus, et præbebit delicias regibus. ");
INSERT INTO latVUC_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nephthali, cervus emissus, et dans eloquia pulchritudinis. ");
INSERT INTO latVUC_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Filius accrescens Joseph, filius accrescens et decorus aspectu: filiæ discurrerunt super murum. ");
INSERT INTO latVUC_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Sed exasperaverunt eum et jurgati sunt, invideruntque illi habentes jacula. ");
INSERT INTO latVUC_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Sedit in forti arcus ejus, et dissoluta sunt vincula brachiorum et manuum illius per manus potentis Jacob: inde pastor egressus est, lapis Israël. ");
INSERT INTO latVUC_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Deus patris tui erit adjutor tuus, et omnipotens benedicet tibi benedictionibus cæli desuper, benedictionibus abyssi jacentis deorsum, benedictionibus uberum et vulvæ. ");
INSERT INTO latVUC_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Benedictiones patris tui confortatæ sunt benedictionibus patrum ejus, donec veniret desiderium collium æternorum: fiant in capite Joseph, et in vertice Nazaræi inter fratres suos. ");
INSERT INTO latVUC_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin lupus rapax, mane comedat prædam, et vespere dividet spolia. ");
INSERT INTO latVUC_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Omnes hi in tribubus Israël duodecim: hæc locutus est eis pater suus, benedixitque singulis benedictionibus propriis. ");
INSERT INTO latVUC_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Et præcepit eis, dicens: Ego congregor ad populum meum: sepelite me cum patribus meis in spelunca duplici quæ est in agro Ephron Hethæi, ");
INSERT INTO latVUC_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","contra Mambre in terra Chanaan, quam emit Abraham cum agro ab Ephron Hethæo in possessionem sepulchri. ");
INSERT INTO latVUC_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ibi sepelierunt eum, et Saram uxorem ejus: ibi sepultus est Isaac cum Rebecca conjuge sua: ibi et Lia condita jacet. ");
INSERT INTO latVUC_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Finitisque mandatis quibus filios instruebat, collegit pedes suos super lectulum, et obiit: appositusque est ad populum suum. ");
INSERT INTO latVUC_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Quod cernens Joseph, ruit super faciem patris, flens et deosculans eum. ");
INSERT INTO latVUC_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Præcepitque servis suis medicis ut aromatibus condirent patrem. ");
INSERT INTO latVUC_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Quibus jussa explentibus, transierunt quadraginta dies: iste quippe mos erat cadaverum conditorum: flevitque eum Ægyptus septuaginta diebus. ");
INSERT INTO latVUC_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Et expleto planctus tempore, locutus est Joseph ad familiam Pharaonis: Si inveni gratiam in conspectu vestro, loquimini in auribus Pharaonis: ");
INSERT INTO latVUC_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","eo quod pater meus adjuraverit me dicens: En morior: in sepulchro meo, quod fodi mihi in terra Chanaan, sepelies me. Ascendam igitur, et sepeliam patrem meum, ac revertar. ");
INSERT INTO latVUC_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Dixitque ei Pharao: Ascende, et sepeli patrem tuum sicut adjuratus es. ");
INSERT INTO latVUC_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Quo ascendente, ierunt cum eo omnes senes domus Pharaonis, cunctique majores natu terræ Ægypti: ");
INSERT INTO latVUC_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","domus Joseph cum fratribus suis, absque parvulis, et gregibus atque armentis, quæ dereliquerant in terra Gessen. ");
INSERT INTO latVUC_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Habuit quoque in comitatu currus et equites: et facta est turba non modica. ");
INSERT INTO latVUC_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Veneruntque ad Aream Atad, quæ sita est trans Jordanem: ubi celebrantes exequias planctu magno atque vehementi impleverunt septem dies. ");
INSERT INTO latVUC_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Quod cum vidissent habitatores terræ Chanaan, dixerunt: Planctus magnus est iste Ægyptiis. Et idcirco vocatum est nomen loci illius, Planctus Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Fecerunt ergo filii Jacob sicut præceperat eis: ");
INSERT INTO latVUC_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","et portantes eum in terram Chanaan, sepelierunt eum in spelunca duplici, quam emerat Abraham cum agro in possessionem sepulchri ab Ephron Hethæo, contra faciem Mambre. ");
INSERT INTO latVUC_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Reversusque est Joseph in Ægyptum cum fratribus suis, et omni comitatu, sepulto patre. ");
INSERT INTO latVUC_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Quo mortuo, timentes fratres ejus, et mutuo colloquentes: Ne forte memor sit injuriæ quam passus est, et reddat nobis omne malum quod fecimus, ");
INSERT INTO latVUC_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","mandaverunt ei dicentes: Pater tuus præcepit nobis antequam moreretur, ");
INSERT INTO latVUC_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ut hæc tibi verbis illius diceremus: Obsecro ut obliviscaris sceleris fratrum tuorum, et peccati atque malitiæ quam exercuerunt in te: nos quoque oramus ut servis Dei patris tui dimittas iniquitatem hanc. Quibus auditis flevit Joseph. ");
INSERT INTO latVUC_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Veneruntque ad eum fratres sui: et proni adorantes in terram, dixerunt: Servi tui sumus. ");
INSERT INTO latVUC_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Quibus ille respondit: Nolite timere: num Dei possumus resistere voluntati? ");
INSERT INTO latVUC_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vos cogitastis de me malum: sed Deus vertit illud in bonum, ut exaltaret me, sicut in præsentiarum cernitis, et salvos faceret multos populos. ");
INSERT INTO latVUC_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nolite timere: ego pascam vos et parvulos vestros: consolatusque est eos, et blande ac leniter est locutus. ");
INSERT INTO latVUC_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Et habitavit in Ægypto cum omni domo patris sui: vixitque centum decem annis. Et vidit Ephraim filios usque ad tertiam generationem. Filii quoque Machir filii Manasse nati sunt in genibus Joseph. ");
INSERT INTO latVUC_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Quibus transactis, locutus est fratribus suis: Post mortem meam Deus visitabit vos, et ascendere vos faciet de terra ista ad terram quam juravit Abraham, Isaac et Jacob. ");
INSERT INTO latVUC_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Cumque adjurasset eos atque dixisset: Deus visitabit vos, asportate ossa mea vobiscum de loco isto: ");
INSERT INTO latVUC_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","mortuus est, expletis centum decem vitæ suæ annis. Et conditus aromatibus, repositus est in loculo in Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Hæc sunt nomina filiorum Israël qui ingressi sunt in Ægyptum cum Jacob: singuli cum domibus suis introierunt: ");
INSERT INTO latVUC_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi, Judas, ");
INSERT INTO latVUC_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zabulon et Benjamin, ");
INSERT INTO latVUC_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan et Nephthali, Gad et Aser. ");
INSERT INTO latVUC_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Erant igitur omnes animæ eorum qui egressi sunt de femore Jacob, septuaginta: Joseph autem in Ægypto erat. ");
INSERT INTO latVUC_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Quo mortuo, et universis fratribus ejus, omnique cognatione illa, ");
INSERT INTO latVUC_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","filii Israël creverunt, et quasi germinantes multiplicati sunt: ac roborati nimis, impleverunt terram. ");
INSERT INTO latVUC_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Surrexit interea rex novus super Ægyptum, qui ignorabat Joseph. ");
INSERT INTO latVUC_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Et ait ad populum suum: Ecce, populus filiorum Israël multus, et fortior nobis est. ");
INSERT INTO latVUC_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Venite, sapienter opprimamus eum, ne forte multiplicetur: et si ingruerit contra nos bellum, addatur inimicis nostris, expugnatisque nobis egrediatur de terra. ");
INSERT INTO latVUC_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Præposuit itaque eis magistros operum, ut affligerent eos oneribus: ædificaveruntque urbes tabernaculorum Pharaoni, Phithom et Ramesses. ");
INSERT INTO latVUC_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Quantoque opprimebant eos, tanto magis multiplicabantur, et crescebant: ");
INSERT INTO latVUC_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","oderantque filios Israël Ægyptii, et affligebant illudentes eis, ");
INSERT INTO latVUC_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","atque ad amaritudinem perducebant vitam eorum operibus duris luti et lateris, omnique famulatu, quo in terræ operibus premebantur. ");
INSERT INTO latVUC_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Dixit autem rex Ægypti obstetricibus Hebræorum, quarum una vocabatur Sephora, altera Phua, ");
INSERT INTO latVUC_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","præcipiens eis: Quando obstetricabitis Hebræas, et partus tempus advenerit: si masculus fuerit, interficite eum: si femina, reservate. ");
INSERT INTO latVUC_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Timuerunt autem obstetrices Deum, et non fecerunt juxta præceptum regis Ægypti, sed conservabant mares. ");
INSERT INTO latVUC_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Quibus ad se accersitis, rex ait: Quidnam est hoc quod facere voluistis, ut pueros servaretis? ");
INSERT INTO latVUC_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Quæ responderunt: Non sunt Hebreæ sicut ægyptiæ mulieres: ipsæ enim obstetricandi habent scientiam, et priusquam veniamus ad eas, pariunt. ");
INSERT INTO latVUC_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Bene ergo fecit Deus obstetricibus: et crevit populus, confortatusque est nimis. ");
INSERT INTO latVUC_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Et quia timuerunt obstetrices Deum, ædificavit eis domos. ");
INSERT INTO latVUC_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Præcepit ergo Pharao omni populo suo, dicens: Quidquid masculini sexus natum fuerit, in flumen projicite: quidquid feminini, reservate. ");
INSERT INTO latVUC_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Egressus est post hæc vir de domo Levi: et accepit uxorem stirpis suæ. ");
INSERT INTO latVUC_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Quæ concepit, et peperit filium: et videns eum elegantem, abscondit tribus mensibus. ");
INSERT INTO latVUC_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Cumque jam celare non posset, sumpsit fiscellam scirpeam, et linivit eam bitumine ac pice: posuitque intus infantulum, et exposuit eum in carecto ripæ fluminis, ");
INSERT INTO latVUC_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","stante procul sorore ejus, et considerante eventum rei. ");
INSERT INTO latVUC_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ecce autem descendebat filia Pharaonis ut lavaretur in flumine: et puellæ ejus gradiebantur per crepidinem alvei. Quæ cum vidisset fiscellam in papyrione, misit unam e famulabus suis: et allatam ");
INSERT INTO latVUC_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","aperiens, cernensque in ea parvulum vagientem, miserta ejus, ait: De infantibus Hebræorum est hic. ");
INSERT INTO latVUC_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Cui soror pueri: Vis, inquit, ut vadam, et vocem tibi mulierem hebræam, quæ nutrire possit infantulum? ");
INSERT INTO latVUC_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Respondit: Vade. Perrexit puella et vocavit matrem suam. ");
INSERT INTO latVUC_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ad quam locuta filia Pharaonis: Accipe, ait, puerum istum, et nutri mihi: ego dabo tibi mercedem tuam. Suscepit mulier, et nutrivit puerum: adultumque tradidit filiæ Pharaonis. ");
INSERT INTO latVUC_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Quem illa adoptavit in locum filii, vocavitque nomen ejus Moyses, dicens: Quia de aqua tuli eum. ");
INSERT INTO latVUC_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","In diebus illis postquam creverat Moyses, egressus est ad fratres suos: viditque afflictionem eorum, et virum ægyptium percutientem quemdam de Hebræis fratribus suis. ");
INSERT INTO latVUC_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Cumque circumspexisset huc atque illuc, et nullum adesse vidisset, percussum Ægyptium abscondit sabulo. ");
INSERT INTO latVUC_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Et egressus die altero conspexit duos Hebræos rixantes: dixitque ei qui faciebat injuriam: Quare percutis proximum tuum? ");
INSERT INTO latVUC_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Qui respondit: Quis te constituit principem et judicem super nos? num occidere me tu vis, sicut heri occidisti Ægyptium? Timuit Moyses, et ait: Quomodo palam factum est verbum istud? ");
INSERT INTO latVUC_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Audivitque Pharao sermonem hunc, et quærebat occidere Moysen: qui fugiens de conspectu ejus, moratus est in terra Madian, et sedit juxta puteum. ");
INSERT INTO latVUC_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Erant autem sacerdoti Madian septem filiæ, quæ venerunt ad hauriendam aquam: et impletis canalibus adaquare cupiebant greges patris sui. ");
INSERT INTO latVUC_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Supervenere pastores, et ejecerunt eas: surrexitque Moyses, et defensis puellis, adaquavit oves earum. ");
INSERT INTO latVUC_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Quæ cum revertissent ad Raguel patrem suum, dixit ad eas: Cur velocius venistis solito? ");
INSERT INTO latVUC_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Responderunt: Vir ægyptius liberavit nos de manu pastorum: insuper et hausit aquam nobiscum, potumque dedit ovibus. ");
INSERT INTO latVUC_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","At ille: Ubi est? inquit: quare dimisistis hominem? vocate eum ut comedat panem. ");
INSERT INTO latVUC_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Juravit ergo Moyses quod habitaret cum eo. Accepitque Sephoram filiam ejus uxorem: ");
INSERT INTO latVUC_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","quæ peperit ei filium, quem vocavit Gersam, dicens: Advena fui in terra aliena. Alterum vero peperit, quem vocavit Eliezer, dicens: Deus enim patris mei adjutor meus eripuit me de manu Pharaonis. ");
INSERT INTO latVUC_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Post multum vero tempore mortuus est rex Ægypti: et ingemiscentes filii Israël, propter opera vociferati sunt: ascenditque clamor eorum ad Deum ab operibus. ");
INSERT INTO latVUC_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Et audivit gemitum eorum, ac recordatus est fœderis quod pepigit cum Abraham, Isaac et Jacob. ");
INSERT INTO latVUC_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Et respexit Dominus filios Israël et cognovit eos. ");
INSERT INTO latVUC_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moyses autem pascebat oves Jethro soceri sui sacerdotis Madian: cumque minasset gregem ad interiora deserti, venit ad montem Dei Horeb. ");
INSERT INTO latVUC_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Apparuitque ei Dominus in flamma ignis de medio rubi: et videbat quod rubus arderet, et non combureretur. ");
INSERT INTO latVUC_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Dixit ergo Moyses: Vadam, et videbo visionem hanc magnam, quare non comburatur rubus. ");
INSERT INTO latVUC_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Cernens autem Dominus quod pergeret ad videndum, vocavit eum de medio rubi, et ait: Moyses, Moyses. Qui respondit: Adsum. ");
INSERT INTO latVUC_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","At ille: Ne appropies, inquit, huc: solve calceamentum de pedibus tuis: locus enim, in quo stas, terra sancta est. ");
INSERT INTO latVUC_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Et ait: Ego sum Deus patris tui, Deus Abraham, Deus Isaac et Deus Jacob. Abscondit Moyses faciem suam: non enim audebat aspicere contra Deum. ");
INSERT INTO latVUC_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Cui ait Dominus: Vidi afflictionem populi mei in Ægypto, et clamorem ejus audivi propter duritiam eorum qui præsunt operibus: ");
INSERT INTO latVUC_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","et sciens dolorem ejus, descendi ut liberem eum de manibus Ægyptiorum, et educam de terra illa in terram bonam, et spatiosam, in terram quæ fluit lacte et melle, ad loca Chananæi et Hethæi, et Amorrhæi, et Pherezæi, et Hevæi, et Jebusæi. ");
INSERT INTO latVUC_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Clamor ergo filiorum Israël venit ad me: vidique afflictionem eorum, qua ab Ægyptiis opprimuntur. ");
INSERT INTO latVUC_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sed veni, et mittam te ad Pharaonem, ut educas populum meum, filios Israël, de Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Dixitque Moyses ad Deum: Quis sum ego ut vadam ad Pharaonem, et educam filios Israël de Ægypto? ");
INSERT INTO latVUC_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Qui dixit ei: Ego ero tecum: et hoc habebis signum, quod miserim te: cum eduxeris populum meum de Ægypto, immolabis Deo super montem istum. ");
INSERT INTO latVUC_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ait Moyses ad Deum: Ecce ego vadam ad filios Israël, et dicam eis: Deus patrum vestrorum misit me ad vos. Si dixerint mihi: Quod est nomen ejus? quid dicam eis? ");
INSERT INTO latVUC_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Dixit Deus ad Moysen: Ego sum qui sum. Ait: Sic dices filiis Israël: Qui est, misit me ad vos. ");
INSERT INTO latVUC_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dixitque iterum Deus ad Moysen: Hæc dices filiis Israël: Dominus Deus patrum vestrorum, Deus Abraham, Deus Isaac et Deus Jacob, misit me ad vos: hoc nomen mihi est in æternum, et hoc memoriale meum in generationem et generationem. ");
INSERT INTO latVUC_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Vade, et congrega seniores Israël, et dices ad eos: Dominus Deus patrum vestrorum apparuit mihi, Deus Abraham, Deus Isaac et Deus Jacob, dicens: Visitans visitavi vos: et vidi omnia quæ acciderunt vobis in Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Et dixi ut educam vos de afflictione Ægypti in terram Chananæi, et Hethæi, et Amorrhæi, et Pherezæi, et Hevæi, et Jebusæi, ad terram fluentem lacte et melle. ");
INSERT INTO latVUC_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Et audient vocem tuam: ingredierisque tu, et seniores Israël, ad regem Ægypti, et dices ad eum: Dominus Deus Hebræorum vocavit nos: ibimus viam trium dierum in solitudinem, ut immolemus Domino Deo nostro. ");
INSERT INTO latVUC_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Sed ego scio quod non dimittet vos rex Ægypti ut eatis nisi per manum validam. ");
INSERT INTO latVUC_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Extendam enim manum meam, et percutiam Ægyptum in cunctis mirabilibus meis, quæ facturus sum in medio eorum: post hæc dimittet vos. ");
INSERT INTO latVUC_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Daboque gratiam populo huic coram Ægyptiis: et cum egrediemini, non exibitis vacui: ");
INSERT INTO latVUC_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","sed postulabit mulier a vicina sua et ab hospita sua, vasa argentea et aurea, ac vestes: ponetisque eas super filios et filias vestras, et spoliabitis Ægyptum. ");
INSERT INTO latVUC_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Respondens Moyses ait: Non credent mihi, neque audient vocem meam, sed dicent: Non apparuit tibi Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Dixit ergo ad eum: Quid est quod tenes in manu tua? Respondit: Virga. ");
INSERT INTO latVUC_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Dixitque Dominus: Projice eam in terram. Projecit, et versa est in colubrum, ita ut fugeret Moyses. ");
INSERT INTO latVUC_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Dixitque Dominus: Extende manum tuam, et apprehende caudam ejus. Extendit, et tenuit, versaque est in virgam. ");
INSERT INTO latVUC_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ut credant, inquit, quod apparuerit tibi Dominus Deus patrum suorum, Deus Abraham, Deus Isaac et Deus Jacob. ");
INSERT INTO latVUC_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Dixitque Dominus rursum: Mitte manum tuam in sinum tuum. Quam cum misisset in sinum, protulit leprosam instar nivis. ");
INSERT INTO latVUC_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Retrahe, ait, manum tuam in sinum tuum. Retraxit, et protulit iterum, et erat similis carni reliquæ. ");
INSERT INTO latVUC_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Si non crediderint, inquit, tibi, neque audierint sermonem signi prioris, credent verbo signi sequentis. ");
INSERT INTO latVUC_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Quod si nec duobus quidem his signis crediderint, neque audierint vocem tuam: sume aquam fluminis, et effunde eam super aridam, et quidquid hauseris de fluvio, vertetur in sanguinem. ");
INSERT INTO latVUC_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ait Moyses: Obsecro, Domine, non sum eloquens ab heri et nudiustertius: et ex quo locutus es ad servum tuum, impeditioris et tardioris linguæ sum. ");
INSERT INTO latVUC_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Dixit Dominus ad eum: Quis fecit os hominis? aut quis fabricatus est mutum et surdum, videntem et cæcum? nonne ego? ");
INSERT INTO latVUC_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Perge, igitur, et ego ero in ore tuo: doceboque te quid loquaris. ");
INSERT INTO latVUC_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","At ille: Obsecro, inquit, Domine, mitte quem missurus es. ");
INSERT INTO latVUC_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Iratus Dominus in Moysen, ait: Aaron frater tuus Levites, scio quod eloquens sit: ecce ipse egreditur in occursum tuum, vidensque te lætabitur corde. ");
INSERT INTO latVUC_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Loquere ad eum, et pone verba mea in ore ejus: et ego ero in ore tuo, et in ore illius, et ostendam vobis quid agere debeatis. ");
INSERT INTO latVUC_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ipse loquetur pro te ad populum, et erit os tuum: tu autem eris ei in his quæ ad Deum pertinent. ");
INSERT INTO latVUC_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Virgam quoque hanc sume in manu tua, in qua facturus es signa. ");
INSERT INTO latVUC_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Abiit Moyses, et reversus est ad Jethro socerum suum, dixitque ei: Vadam et revertar ad fratres meos in Ægyptum, ut videam si adhuc vivant. Cui ait Jethro: Vade in pace. ");
INSERT INTO latVUC_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Dixit ergo Dominus ad Moysen in Madian: Vade, et revertere in Ægyptum, mortui sunt enim omnes qui quærebant animam tuam. ");
INSERT INTO latVUC_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tulit ergo Moyses uxorem suam, et filios suos, et imposuit eos super asinum: reversusque est in Ægyptum, portans virgam Dei in manu sua. ");
INSERT INTO latVUC_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Dixitque ei Dominus revertenti in Ægyptum: Vide ut omnia ostenta quæ posui in manu tua, facias coram Pharaone: ego indurabo cor ejus, et non dimittet populum. ");
INSERT INTO latVUC_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Dicesque ad eum: Hæc dicit Dominus: Filius meus primogenitus Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Dixi tibi: Dimitte filium meum ut serviat mihi; et noluisti dimittere eum: ecce ego interficiam filium tuum primogenitum. ");
INSERT INTO latVUC_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Cumque esset in itinere, in diversorio occurrit ei Dominus, et volebat occidere eum. ");
INSERT INTO latVUC_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Tulit idcirco Sephora acutissimam petram, et circumcidit præputium filii sui, tetigitque pedes ejus, et ait: Sponsus sanguinum tu mihi es. ");
INSERT INTO latVUC_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Et dimisit eum postquam dixerat: Sponsus sanguinum ob circumcisionem. ");
INSERT INTO latVUC_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Dixit autem Dominus ad Aaron: Vade in occursum Moysi in desertum. Qui perrexit obviam ei in montem Dei, et osculatus est eum. ");
INSERT INTO latVUC_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Narravitque Moyses Aaron omnia verba Domini quibus miserat eum, et signa quæ mandaverat. ");
INSERT INTO latVUC_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Veneruntque simul, et congregaverunt cunctos seniores filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Locutusque est Aaron omnia verba quæ dixerat Dominus ad Moysen: et fecit signa coram populo, ");
INSERT INTO latVUC_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","et credidit populus. Audieruntque quod visitasset Dominus filios Israël, et respexisset afflictionem illorum: et proni adoraverunt. ");
INSERT INTO latVUC_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Post hæc ingressi sunt Moyses et Aaron, et dixerunt Pharaoni: Hæc dicit Dominus Deus Israël: Dimitte populum meum ut sacrificet mihi in deserto. ");
INSERT INTO latVUC_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","At ille respondit: Quis est Dominus, ut audiam vocem ejus, et dimittam Israël? nescio Dominum, et Israël non dimittam. ");
INSERT INTO latVUC_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Dixeruntque: Deus Hebræorum vocavit nos, ut eamus viam trium dierum in solitudinem, et sacrificemus Domino Deo nostro: ne forte accidat nobis pestis aut gladius. ");
INSERT INTO latVUC_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ait ad eos rex Ægypti: Quare Moyses et Aaron sollicitatis populum ab operibus suis? ite ad onera vestra. ");
INSERT INTO latVUC_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Dixitque Pharao: Multus est populus terræ: videtis quod turba succreverit: quanto magis si dederitis eis requiem ab operibus? ");
INSERT INTO latVUC_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Præcepit ergo in die illo præfectis operum et exactoribus populi, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Nequaquam ultra dabitis paleas populo ad conficiendos lateres, sicut prius: sed ipsi vadant, et colligant stipulas. ");
INSERT INTO latVUC_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Et mensuram laterum, quam prius faciebant, imponetis super eos, nec minuetis quidquam: vacant enim, et idcirco vociferantur, dicentes: Eamus, et sacrificemus Deo nostro. ");
INSERT INTO latVUC_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Opprimantur operibus, et expleant ea: ut non acquiescant verbis mendacibus. ");
INSERT INTO latVUC_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Igitur egressi præfecti operum et exactores ad populum, dixerunt: Sic dicit Pharao: Non do vobis paleas: ");
INSERT INTO latVUC_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ite, et colligite sicubi invenire poteritis, nec minuetur quidquam de opere vestro. ");
INSERT INTO latVUC_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Dispersusque est populus per omnem terram Ægypti ad colligendas paleas. ");
INSERT INTO latVUC_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Præfecti quoque operum instabant, dicentes: Complete opus vestrum quotidie, ut prius facere solebatis quando dabantur vobis paleæ. ");
INSERT INTO latVUC_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Flagellatique sunt qui præerant operibus filiorum Israël, ab exactoribus Pharaonis, dicentibus: Quare non impletis mensuram laterum sicut prius, nec heri, nec hodie? ");
INSERT INTO latVUC_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Veneruntque præpositi filiorum Israël, et vociferati sunt ad Pharaonem dicentes: Cur ita agis contra servos tuos? ");
INSERT INTO latVUC_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","paleæ non dantur nobis, et lateres similiter imperantur: en famuli tui flagellis cædimur, et injuste agitur contra populum tuum. ");
INSERT INTO latVUC_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Qui ait: Vacatis otio, et idcirco dicitis: Eamus, et sacrificemus Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ite ergo, et operamini: paleæ non dabuntur vobis, et reddetis consuetum numerum laterum. ");
INSERT INTO latVUC_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Videbantque se præpositi filiorum Israël in malo, eo quod diceretur eis: Non minuetur quidquam de lateribus per singulos dies. ");
INSERT INTO latVUC_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Occurreruntque Moysi et Aaron, qui stabant ex adverso, egredientibus a Pharaone: ");
INSERT INTO latVUC_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","et dixerunt ad eos: Videat Dominus et judicet, quoniam fœtere fecistis odorem nostrum coram Pharaone et servis ejus, et præbuistis ei gladium, ut occideret nos. ");
INSERT INTO latVUC_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Reversusque est Moyses ad Dominum, et ait: Domine, cur afflixisti populum istum? quare misisti me? ");
INSERT INTO latVUC_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ex eo enim quo ingressus sum ad Pharaonem ut loquerer in nomine tuo, afflixit populum tuum: et non liberasti eos. ");
INSERT INTO latVUC_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Dixitque Dominus ad Moysen: Nunc videbis quæ facturus sim Pharaoni: per manum enim fortem dimittet eos, et in manu robusta ejiciet illos de terra sua. ");
INSERT INTO latVUC_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Locutusque est Dominus ad Moysen dicens: Ego Dominus ");
INSERT INTO latVUC_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","qui apparui Abraham, Isaac et Jacob in Deo omnipotente: et nomen meum Adonai non indicavi eis. ");
INSERT INTO latVUC_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Pepigique fœdus cum eis, ut darem eis terram Chanaan, terram peregrinationis eorum, in qua fuerunt advenæ. ");
INSERT INTO latVUC_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ego audivi gemitum filiorum Israël, quo Ægyptii oppresserunt eos: et recordatus sum pacti mei. ");
INSERT INTO latVUC_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ideo dic filiis Israël: Ego Dominus qui educam vos de ergastulo Ægyptiorum, et eruam de servitute, ac redimam in brachio excelso et judiciis magnis. ");
INSERT INTO latVUC_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Et assumam vos mihi in populum, et ero vester Deus: et scietis quod ego sum Dominus Deus vester qui eduxerim vos de ergastulo Ægyptiorum, ");
INSERT INTO latVUC_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","et induxerim in terram, super quam levavi manum meam ut darem eam Abraham, Isaac et Jacob: daboque illam vobis possidendam. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Narravit ergo Moyses omnia filiis Israël: qui non acquieverunt ei propter angustiam spiritus, et opus durissimum. ");
INSERT INTO latVUC_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Ingredere, et loquere ad Pharaonem regem Ægypti, ut dimittat filios Israël de terra sua. ");
INSERT INTO latVUC_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Respondit Moyses coram Domino: Ecce filii Israël non audiunt me: et quomodo audiet Pharao, præsertim cum incircumcisus sim labiis? ");
INSERT INTO latVUC_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Locutusque est Dominus ad Moysen et Aaron, et dedit mandatum ad filios Israël, et ad Pharaonem regem Ægypti ut educerent filios Israël de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isti sunt principes domorum per familias suas. Filii Ruben primogeniti Israëlis: Henoch et Phallu, Hesron et Charmi: ");
INSERT INTO latVUC_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","hæ cognationes Ruben. Filii Simeon: Jamuel, et Jamin, et Ahod, et Jachin, et Soar, et Saul filius Chananitidis: hæ progenies Simeon. ");
INSERT INTO latVUC_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Et hæc nomina filiorum Levi per cognationes suas: Gerson, et Caath, et Merari. Anni autem vitæ Levi fuerunt centum triginta septem. ");
INSERT INTO latVUC_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Filii Gerson: Lobni et Semei, per cognationes suas. ");
INSERT INTO latVUC_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Filii Caath: Amram, et Isaar, et Hebron, et Oziel; anni quoque vitæ Caath, centum triginta tres. ");
INSERT INTO latVUC_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Filii Merari: Moholi et Musi: hæ cognationes Levi per familias suas. ");
INSERT INTO latVUC_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Accepit autem Amram uxorem Jochabed patruelem suam: quæ peperit ei Aaron et Moysen. Fueruntque anni vitæ Amram, centum triginta septem. ");
INSERT INTO latVUC_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Filii quoque Isaar: Core, et Nepheg, et Zechri. ");
INSERT INTO latVUC_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Filii quoque Oziel: Misaël, et Elisaphan, et Sethri. ");
INSERT INTO latVUC_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Accepit autem Aaron uxorem Elisabeth filiam Aminadab, sororem Nahason, quæ peperit ei Nadab, et Abiu, et Eleazar, et Ithamar. ");
INSERT INTO latVUC_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Filii quoque Core: Aser, et Elcana, et Abiasaph: hæ sunt cognationes Coritarum. ");
INSERT INTO latVUC_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","At vero Eleazar filius Aaron accepit uxorem de filiabus Phutiel: quæ peperit ei Phinees. Hi sunt principes familiarum Leviticarum per cognationes suas. ");
INSERT INTO latVUC_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Iste est Aaron et Moyses, quibus præcepit Dominus ut educerent filios Israël de terra Ægypti per turmas suas. ");
INSERT INTO latVUC_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Hi sunt, qui loquuntur ad Pharaonem regem Ægypti, ut educant filios Israël de Ægypto: iste est Moyses et Aaron, ");
INSERT INTO latVUC_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","in die qua locutus est Dominus ad Moysen, in terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Et locutus est Dominus ad Moysen, dicens: Ego Dominus: loquere ad Pharaonem regem Ægypti, omnia quæ ego loquor tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Et ait Moyses coram Domino: En incircumcisus labiis sum, quomodo audiet me Pharao? ");
INSERT INTO latVUC_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Dixitque Dominus ad Moysen: Ecce constitui te Deum Pharaonis: et Aaron frater tuus erit propheta tuus. ");
INSERT INTO latVUC_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tu loqueris ei omnia quæ mando tibi: et ille loquetur ad Pharaonem, ut dimittat filios Israël de terra sua. ");
INSERT INTO latVUC_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Sed ego indurabo cor ejus, et multiplicabo signa et ostenta mea in terra Ægypti, ");
INSERT INTO latVUC_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","et non audiet vos: immittamque manum meam super Ægyptum, et educam exercitum et populum meum filios Israël de terra Ægypti per judicia maxima. ");
INSERT INTO latVUC_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Et scient Ægyptii quia ego sum Dominus qui extenderim manum meam super Ægyptum, et eduxerim filios Israël de medio eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Fecit itaque Moyses et Aaron sicut præceperat Dominus: ita egerunt. ");
INSERT INTO latVUC_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Erat autem Moyses octoginta annorum, et Aaron octoginta trium, quando locuti sunt ad Pharaonem. ");
INSERT INTO latVUC_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Dixitque Dominus ad Moysen et Aaron: ");
INSERT INTO latVUC_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Cum dixerit vobis Pharao, Ostendite signa: dices ad Aaron: Tolle virgam tuam, et projice eam coram Pharaone, ac vertetur in colubrum. ");
INSERT INTO latVUC_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ingressi itaque Moyses et Aaron ad Pharaonem, fecerunt sicut præceperat Dominus: tulitque Aaron virgam coram Pharaone et servis ejus, quæ versa est in colubrum. ");
INSERT INTO latVUC_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Vocavit autem Pharao sapientes et maleficos: et fecerunt etiam ipsi per incantationes ægyptiacas et arcana quædam similiter. ");
INSERT INTO latVUC_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Projeceruntque singuli virgas suas, quæ versæ sunt in dracones: sed devoravit virga Aaron virgas eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Induratumque est cor Pharaonis, et non audivit eos, sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Dixit autem Dominus ad Moysen: Ingravatum est cor Pharaonis: non vult dimittere populum. ");
INSERT INTO latVUC_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Vade ad eum mane, ecce egredietur ad aquas: et stabis in occursum ejus super ripam fluminis: et virgam quæ conversa est in draconem, tolles in manu tua. ");
INSERT INTO latVUC_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Dicesque ad eum: Dominus Deus Hebræorum misit me ad te, dicens: Dimitte populum meum ut sacrificet mihi in deserto: et usque ad præsens audire noluisti. ");
INSERT INTO latVUC_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Hæc igitur dicit Dominus: In hoc scies quod sim Dominus: ecce percutiam virga, quæ in manu mea est, aquam fluminis, et vertetur in sanguinem. ");
INSERT INTO latVUC_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Pisces quoque, qui sunt in fluvio, morientur, et computrescent aquæ, et affligentur Ægyptii bibentes aquam fluminis. ");
INSERT INTO latVUC_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Dixit quoque Dominus ad Moysen: Dic ad Aaron: Tolle virgam tuam, et extende manum tuam super aquas Ægypti, et super fluvios eorum, et rivos ac paludes, et omnes lacus aquarum, ut vertantur in sanguinem: et sit cruor in omni terra Ægypti, tam in ligneis vasis quam in saxeis. ");
INSERT INTO latVUC_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Feceruntque Moyses et Aaron sicut præceperat Dominus: et elevans virgam percussit aquam fluminis coram Pharaone et servis ejus: quæ versa est in sanguinem. ");
INSERT INTO latVUC_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Et pisces, qui erant in flumine, mortui sunt: computruitque fluvius, et non poterant Ægyptii bibere aquam fluminis, et fuit sanguis in tota terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Feceruntque similiter malefici Ægyptiorum incantationibus suis: et induratum est cor Pharaonis, nec audivit eos, sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Avertitque se, et ingressus est domum suam, nec apposuit cor etiam hac vice. ");
INSERT INTO latVUC_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Foderunt autem omnes Ægyptii per circuitum fluminis aquam ut biberent: non enim poterant bibere de aqua fluminis. ");
INSERT INTO latVUC_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Impletique sunt septem dies, postquam percussit Dominus fluvium. ");
INSERT INTO latVUC_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Dixit quoque Dominus ad Moysen: Ingredere ad Pharaonem, et dices ad eum: Hæc dicit Dominus: Dimitte populum meum, ut sacrificet mihi: ");
INSERT INTO latVUC_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","sin autem nolueris dimittere, ecce ego percutiam omnes terminos tuos ranis, ");
INSERT INTO latVUC_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","et ebulliet fluvius ranas: quæ ascendent, et ingredientur domum tuam, et cubiculum lectuli tui, et super stratum tuum, et in domos servorum tuorum, et in populum tuum, et in furnos tuos, et in reliquias ciborum tuorum: ");
INSERT INTO latVUC_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","et ad te, et ad populum tuum, et ad omnes servos tuos intrabunt ranæ. ");
INSERT INTO latVUC_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Dixitque Dominus ad Moysen: Dic ad Aaron: Extende manum tuam super fluvios ac super rivos et paludes, et educ ranas super terram Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Et extendit Aaron manum super aquas Ægypti, et ascenderunt ranæ, operueruntque terram Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Fecerunt autem et malefici per incantationes suas similiter, eduxeruntque ranas super terram Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Vocavit autem Pharao Moysen et Aaron, et dixit eis: Orate Dominum ut auferat ranas a me et a populo meo, et dimittam populum ut sacrificet Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Dixitque Moyses ad Pharaonem: Constitue mihi quando deprecer pro te, et pro servis tuis, et pro populo tuo, ut abigantur ranæ a te, et a domo tua, et a servis tuis, et a populo tuo: et tantum in flumine remaneant. ");
INSERT INTO latVUC_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Qui respondit: Cras. At ille: Juxta, inquit, verbum tuum faciam: ut scias quoniam non est sicut Dominus Deus noster. ");
INSERT INTO latVUC_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Et recedent ranæ a te, et a domo tua, et a servis tuis, et a populo tuo: et tantum in flumine remanebunt. ");
INSERT INTO latVUC_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Egressique sunt Moyses et Aaron a Pharaone: et clamavit Moyses ad Dominum pro sponsione ranarum quam condixerat Pharaoni. ");
INSERT INTO latVUC_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Fecitque Dominus juxta verbum Moysi: et mortuæ sunt ranæ de domibus, et de villis, et de agris. ");
INSERT INTO latVUC_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Congregaveruntque eas in immensos aggeres, et computruit terra. ");
INSERT INTO latVUC_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Videns autem Pharao quod data esset requies, ingravavit cor suum, et non audivit eos, sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Dixitque Dominus ad Moysen: Loquere ad Aaron: Extende virgam tuam, et percute pulverem terræ: et sint sciniphes in universa terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Feceruntque ita. Et extendit Aaron manum, virgam tenens: percussitque pulverem terræ, et facti sunt sciniphes in hominibus, et in jumentis: omnis pulvis terræ versus est in sciniphes per totam terram Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Feceruntque similiter malefici incantationibus suis, ut educerent sciniphes, et non potuerunt: erantque sciniphes tam in hominibus quam in jumentis. ");
INSERT INTO latVUC_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Et dixerunt malefici ad Pharaonem: Digitus Dei est hic; induratumque est cor Pharaonis, et non audivit eos sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Dixit quoque Dominus ad Moysen: Consurge diluculo, et sta coram Pharaone: egredietur enim ad aquas: et dices ad eum: Hæc dicit Dominus: Dimitte populum meum ut sacrificet mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Quod si non dimiseris eum, ecce ego immittam in te, et in servos tuos, et in populum tuum, et in domos tuas, omne genus muscarum: et implebuntur domus Ægyptiorum muscis diversi generis, et universa terra in qua fuerint. ");
INSERT INTO latVUC_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Faciamque mirabilem in die illa terram Gessen, in qua populus meus est, ut non sint ibi muscæ: et scias quoniam ego Dominus in medio terræ. ");
INSERT INTO latVUC_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ponamque divisionem inter populum meum et populum tuum: cras erit signum istud. ");
INSERT INTO latVUC_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Fecitque Dominus ita. Et venit musca gravissima in domos Pharaonis et servorum ejus, et in omnem terram Ægypti: corruptaque est terra ab hujuscemodi muscis. ");
INSERT INTO latVUC_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Vocavitque Pharao Moysen et Aaron, et ait eis: Ite et sacrificate Deo vestro in terra hac. ");
INSERT INTO latVUC_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Et ait Moyses: Non potest ita fieri: abominationes enim Ægyptiorum immolabimus Domino Deo nostro: quod si mactaverimus ea quæ colunt Ægyptii coram eis, lapidibus nos obruent. ");
INSERT INTO latVUC_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Viam trium dierum pergemus in solitudinem: et sacrificabimus Domino Deo nostro, sicut præcepit nobis. ");
INSERT INTO latVUC_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Dixitque Pharao: Ego dimittam vos ut sacrificetis Domino Deo vestro in deserto: verumtamen longius ne abeatis, rogate pro me. ");
INSERT INTO latVUC_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","At ait Moyses: Egressus a te, orabo Dominum: et recedet musca a Pharaone, et a servis suis, et a populo ejus cras: verumtamen noli ultra fallere, ut non dimittas populum sacrificare Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Egressusque Moyses a Pharaone, oravit Dominum. ");
INSERT INTO latVUC_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Qui fecit juxta verbum illius, et abstulit muscas a Pharaone, et a servis suis, et a populo ejus: non superfuit ne una quidem. ");
INSERT INTO latVUC_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Et ingravatum est cor Pharaonis, ita ut nec hac quidem vice dimitteret populum. ");
INSERT INTO latVUC_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Dixit autem Dominus ad Moysen: Ingredere ad Pharaonem, et loquere ad eum: Hæc dicit Dominus Deus Hebræorum: Dimitte populum meum ut sacrificet mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Quod si adhuc renuis, et retines eos, ");
INSERT INTO latVUC_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ecce manus mea erit super agros tuos, et super equos, et asinos, et camelos, et boves, et oves, pestis valde gravis. ");
INSERT INTO latVUC_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Et faciet Dominus mirabile inter possessiones Israël et possessiones Ægyptiorum, ut nihil omnino pereat ex eis quæ pertinent ad filios Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Constituitque Dominus tempus, dicens: Cras faciet Dominus verbum istud in terra. ");
INSERT INTO latVUC_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Fecit ergo Dominus verbum hoc altera die: mortuaque sunt omnia animantia Ægyptiorum; de animalibus vero filiorum Israël, nihil omnino periit. ");
INSERT INTO latVUC_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Et misit Pharao ad videndum: nec erat quidquam mortuum de his quæ possidebat Israël. Ingravatumque est cor Pharaonis, et non dimisit populum. ");
INSERT INTO latVUC_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Et dixit Dominus ad Moysen et Aaron: Tollite plenas manus cineris de camino, et spargat illum Moyses in cælum coram Pharaone. ");
INSERT INTO latVUC_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Sitque pulvis super omnem terram Ægypti: erunt enim in hominibus et jumentis ulcera, et vesicæ turgentes in universa terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Tuleruntque cinerem de camino, et steterunt coram Pharaone, et sparsit illum Moyses in cælum: factaque sunt ulcera vesicarum turgentium in hominibus et jumentis: ");
INSERT INTO latVUC_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","nec poterant malefici stare coram Moyse propter ulcera quæ in illis erant, et in omni terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Induravitque Dominus cor Pharaonis, et non audivit eos, sicut locutus est Dominus ad Moysen. ");
INSERT INTO latVUC_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Dixitque Dominus ad Moysen: Mane consurge, et sta coram Pharaone, et dices ad eum: Hæc dicit Dominus Deus Hebræorum: Dimitte populum meum ut sacrificet mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Quia in hac vice mittam omnes plagas meas super cor tuum, et super servos tuos, et super populum tuum: ut scias quod non sit similis mei in omni terra. ");
INSERT INTO latVUC_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nunc enim extendens manum percutiam te, et populum tuum peste, peribisque de terra. ");
INSERT INTO latVUC_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Idcirco autem posui te, ut ostendam in te fortitudinem meam, et narretur nomen meum in omni terra. ");
INSERT INTO latVUC_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Adhuc retines populum meum, et non vis dimittere eum? ");
INSERT INTO latVUC_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","En pluam cras hac ipsa hora grandinem multam nimis, qualis non fuit in Ægypto a die qua fundata est, usque in præsens tempus. ");
INSERT INTO latVUC_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Mitte ergo jam nunc, et congrega jumenta tua, et omnia quæ habes in agro: homines enim, et jumenta, et universa quæ inventa fuerint foris, nec congregata de agris, cecideritque super ea grando, morientur. ");
INSERT INTO latVUC_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Qui timuit verbum Domini de servis Pharaonis, facit confugere servos suos et jumenta in domos: ");
INSERT INTO latVUC_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","qui autem neglexit sermonem Domini, dimisit servos suos et jumenta in agris. ");
INSERT INTO latVUC_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Et dixit Dominus ad Moysen: Extende manum tuam in cælum, ut fiat grando in universa terra Ægypti super homines, et super jumenta, et super omnem herbam agri in terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Extenditque Moyses virgam in cælum, et Dominus dedit tonitrua, et grandinem, ac discurrentia fulgura super terram: pluitque Dominus grandinem super terram Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Et grando et ignis mista pariter ferebantur: tantæque fuit magnitudinis, quanta ante numquam apparuit in universa terra Ægypti ex quo gens illa condita est. ");
INSERT INTO latVUC_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Et percussit grando in omni terra Ægypti cuncta quæ fuerunt in agris, ab homine usque ad jumentum: cunctamque herbam agri percussit grando, et omne lignum regionis confregit. ");
INSERT INTO latVUC_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tantum in terra Gessen, ubi erant filii Israël, grando non cecidit. ");
INSERT INTO latVUC_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Misitque Pharao, et vocavit Moysen et Aaron, dicens ad eos: Peccavi etiam nunc: Dominus justus; ego et populus meus, impii. ");
INSERT INTO latVUC_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Orate Dominum ut desinant tonitrua Dei, et grando: ut dimittam vos, et nequaquam hic ultra maneatis. ");
INSERT INTO latVUC_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ait Moyses: Cum egressus fuero de urbe, extendam palmas meas ad Dominum, et cessabunt tonitrua, et grando non erit, ut scias quia Domini est terra: ");
INSERT INTO latVUC_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","novi autem quod et tu et servi tui necdum timeatis Dominum Deum. ");
INSERT INTO latVUC_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Linum ergo et hordeum læsum est, eo quod hordeum esset virens, et linum jam folliculos germinaret: ");
INSERT INTO latVUC_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","triticum autem et far non sunt læsa, quia serotina erant. ");
INSERT INTO latVUC_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Egressusque Moyses a Pharaone ex urbe, tetendit manus ad Dominum: et cessaverunt tonitrua et grando, nec ultra stillavit pluvia super terram. ");
INSERT INTO latVUC_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Videns autem Pharao quod cessasset pluvia, et grando, et tonitrua, auxit peccatum: ");
INSERT INTO latVUC_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","et ingravatum est cor ejus, et servorum illius, et induratum nimis: nec dimisit filios Israël, sicut præceperat Dominus per manum Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Et dixit Dominus ad Moysen: Ingredere ad Pharaonem: ego enim induravi cor ejus, et servorum illius, ut faciam signa mea hæc in eo: ");
INSERT INTO latVUC_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","et narres in auribus filii tui, et nepotum tuorum, quoties contriverim Ægyptios, et signa mea fecerim in eis: et sciatis quia ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Introierunt ergo Moyses et Aaron ad Pharaonem, et dixerunt ei: Hæc dicit Dominus Deus Hebræorum: Usquequo non vis subjici mihi? dimitte populum meum, ut sacrificet mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Sin autem resistis, et non vis dimittere eum: ecce ego inducam cras locustam in fines tuos: ");
INSERT INTO latVUC_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","quæ operiat superficiem terræ, ne quidquam ejus appareat, sed comedatur quod residuum fuerit grandini: corrodet enim omnia ligna quæ germinant in agris. ");
INSERT INTO latVUC_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Et implebunt domos tuas, et servorum tuorum, et omnium Ægyptiorum, quantam non viderunt patres tui, et avi, ex quo orti sunt super terram, usque in præsentem diem. Avertitque se, et egressus est a Pharaone. ");
INSERT INTO latVUC_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Dixerunt autem servi Pharaonis ad eum: Usquequo patiemur hoc scandalum? dimitte homines, ut sacrificent Domino Deo suo; nonne vides quod perierit Ægyptus? ");
INSERT INTO latVUC_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Revocaveruntque Moysen et Aaron ad Pharaonem: qui dixit eis: Ite, sacrificate Domino Deo vestro: quinam sunt qui ituri sunt? ");
INSERT INTO latVUC_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ait Moyses: Cum parvulis nostris, et senioribus pergemus, cum filiis et filiabus, cum ovibus et armentis: est enim solemnitas Domini Dei nostri. ");
INSERT INTO latVUC_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Et respondit Pharao: Sic Dominus sit vobiscum, quomodo ego dimittam vos, et parvulos vestros, cui dubium est quod pessime cogitetis? ");
INSERT INTO latVUC_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","non fiet ita, sed ite tantum viri, et sacrificate Domino: hoc enim et ipsi petistis. Statimque ejecti sunt de conspectu Pharaonis. ");
INSERT INTO latVUC_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Dixit autem Dominus ad Moysen: Extende manum tuam super terram Ægypti ad locustam, ut ascendat super eam, et devoret omnem herbam quæ residua fuerit grandini. ");
INSERT INTO latVUC_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Et extendit Moyses virgam super terram Ægypti: et Dominus induxit ventum urentem tota die illa et nocte: et mane facto, ventus urens levavit locustas. ");
INSERT INTO latVUC_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Quæ ascenderunt super universam terram Ægypti: et sederunt in cunctis finibus Ægyptiorum innumerabiles, quales ante illud tempus non fuerant, nec postea futuræ sunt. ");
INSERT INTO latVUC_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Operueruntque universam superficiem terræ, vastantes omnia. Devorata est igitur herba terræ, et quidquid pomorum in arboribus fuit, quæ grando dimiserat: nihilque omnino virens relictum est in lignis et in herbis terræ, in cuncta Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Quam ob rem festinus Pharao vocavit Moysen et Aaron, et dixit eis: Peccavi in Dominum Deum vestrum, et in vos. ");
INSERT INTO latVUC_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Sed nunc dimittite peccatum mihi etiam hac vice, et rogate Dominum Deum vestrum, ut auferat a me mortem istam. ");
INSERT INTO latVUC_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Egressusque Moyses de conspectu Pharaonis, oravit Dominum. ");
INSERT INTO latVUC_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Qui flare fecit ventum ab occidente vehementissimum, et arreptam locustam projecit in mare Rubrum: non remansit ne una quidem in cunctis finibus Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Et induravit Dominus cor Pharaonis, nec dimisit filios Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Dixit autem Dominus ad Moysen: Extende manum tuam in cælum: et sint tenebræ super terram Ægypti tam densæ, ut palpari queant. ");
INSERT INTO latVUC_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Extenditque Moyses manum in cælum: et factæ sunt tenebræ horribiles in universa terra Ægypti tribus diebus. ");
INSERT INTO latVUC_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Nemo vidit fratrem suum, nec movit se de loco in quo erat: ubicumque autem habitabant filii Israël, lux erat. ");
INSERT INTO latVUC_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Vocavitque Pharao Moysen et Aaron, et dixit eis: Ite, sacrificate Domino: oves tantum vestræ et armenta remaneant, parvuli vestri eant vobiscum. ");
INSERT INTO latVUC_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ait Moyses: Hostias quoque et holocausta dabis nobis, quæ offeramus Domino Deo nostro. ");
INSERT INTO latVUC_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Cuncti greges pergent nobiscum; non remanebit ex eis ungula: quæ necessaria sunt in cultum Domini Dei nostri: præsertim cum ignoremus quid debeat immolari, donec ad ipsum locum perveniamus. ");
INSERT INTO latVUC_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Induravit autem Dominus cor Pharaonis, et noluit dimittere eos. ");
INSERT INTO latVUC_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Dixitque Pharao ad Moysen: Recede a me, et cave ne ultra videas faciem meam: quocumque die apparueris mihi, morieris. ");
INSERT INTO latVUC_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Respondit Moyses: Ita fiet ut locutus es: non videbo ultra faciem tuam. ");
INSERT INTO latVUC_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Et dixit Dominus ad Moysen: Adhuc una plaga tangam Pharaonem et Ægyptum, et post hæc dimittet vos, et exire compellet. ");
INSERT INTO latVUC_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Dices ergo omni plebi ut postulet vir ab amico suo, et mulier a vicina sua, vasa argentea et aurea. ");
INSERT INTO latVUC_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Dabit autem Dominus gratiam populo suo coram Ægyptiis. Fuitque Moyses vir magnus valde in terra Ægypti coram servis Pharaonis et omni populo. ");
INSERT INTO latVUC_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Et ait: Hæc dicit Dominus: Media nocte egrediar in Ægyptum: ");
INSERT INTO latVUC_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","et morietur omne primogenitum in terra Ægyptiorum, a primogenito Pharaonis, qui sedet in solio ejus, usque ad primogenitum ancillæ quæ est ad molam, et omnia primogenita jumentorum. ");
INSERT INTO latVUC_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Eritque clamor magnus in universa terra Ægypti, qualis nec ante fuit, nec postea futurus est. ");
INSERT INTO latVUC_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Apud omnes autem filios Israël non mutiet canis ab homine usque ad pecus: ut sciatis quanto miraculo dividat Dominus Ægyptios et Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Descendentque omnes servi tui isti ad me, et adorabunt me, dicentes: Egredere tu, et omnis populus qui subjectus est tibi: post hæc egrediemur. ");
INSERT INTO latVUC_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Et exivit a Pharaone iratus nimis. Dixit autem Dominus ad Moysen: Non audiet vos Pharao ut multa signa fiant in terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moyses autem et Aaron fecerunt omnia ostenta, quæ scripta sunt, coram Pharaone. Et induravit Dominus cor Pharaonis, nec dimisit filios Israël de terra sua. ");
INSERT INTO latVUC_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Dixit quoque Dominus ad Moysen et Aaron in terra Ægypti: ");
INSERT INTO latVUC_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Mensis iste, vobis principium mensium: primus erit in mensibus anni. ");
INSERT INTO latVUC_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Loquimini ad universum cœtum filiorum Israël, et dicite eis: Decima die mensis hujus tollat unusquisque agnum per familias et domos suas. ");
INSERT INTO latVUC_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Sin autem minor est numerus ut sufficere possit ad vescendum agnum, assumet vicinum suum qui junctus est domui suæ, juxta numerum animarum quæ sufficere possunt ad esum agni. ");
INSERT INTO latVUC_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Erit autem agnus absque macula, masculus, anniculus: juxta quem ritum tolletis et hædum. ");
INSERT INTO latVUC_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Et servabitis eum usque ad quartamdecimam diem mensis hujus: immolabitque eum universa multitudo filiorum Israël ad vesperam. ");
INSERT INTO latVUC_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Et sument de sanguine ejus, ac ponent super utrumque postem, et in superliminaribus domorum, in quibus comedent illum. ");
INSERT INTO latVUC_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Et edent carnes nocte illa assas igni, et azymos panes cum lactucis agrestibus. ");
INSERT INTO latVUC_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Non comedetis ex eo crudum quid, nec coctum aqua, sed tantum assum igni: caput cum pedibus ejus et intestinis vorabitis. ");
INSERT INTO latVUC_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Nec remanebit quidquam ex eo usque mane; si quid residuum fuerit, igne comburetis. ");
INSERT INTO latVUC_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Sic autem comedetis illum: renes vestros accingetis, et calceamenta habebitis in pedibus, tenentes baculos in manibus, et comedetis festinanter: est enim Phase (id est, transitus) Domini. ");
INSERT INTO latVUC_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Et transibo per terram Ægypti nocte illa, percutiamque omne primogenitum in terra Ægypti ab homine usque ad pecus: et in cunctis diis Ægypti faciam judicia. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Erit autem sanguis vobis in signum in ædibus in quibus eritis: et videbo sanguinem, et transibo vos: nec erit in vobis plaga disperdens quando percussero terram Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Habebitis autem hunc diem in monimentum: et celebrabitis eam solemnem Domino in generationibus vestris cultu sempiterno. ");
INSERT INTO latVUC_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Septem diebus azyma comedetis: in die primo non erit fermentum in domibus vestris: quicumque comederit fermentatum, peribit anima illa de Israël, a primo die usque ad diem septimum. ");
INSERT INTO latVUC_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Dies prima erit sancta atque solemnis, et dies septima eadem festivitate venerabilis: nihil operis facietis in eis, exceptis his, quæ ad vescendum pertinent. ");
INSERT INTO latVUC_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Et observabitis azyma: in eadem enim ipsa die educam exercitum vestrum de terra Ægypti, et custodietis diem istum in generationes vestras ritu perpetuo. ");
INSERT INTO latVUC_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Primo mense, quartadecima die mensis ad vesperam, comedetis azyma usque ad diem vigesimam primam ejusdem mensis ad vesperam. ");
INSERT INTO latVUC_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Septem diebus fermentum non invenietur in domibus vestris: qui comederit fermentatum, peribit anima ejus de cœtu Israël, tam de advenis quam de indigenis terræ. ");
INSERT INTO latVUC_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Omne fermentatum non comedetis: in cunctis habitaculis vestris edetis azyma. ");
INSERT INTO latVUC_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Vocavit autem Moyses omnes seniores filiorum Israël, et dixit ad eos: Ite tollentes animal per familias vestras, et immolate Phase. ");
INSERT INTO latVUC_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Fasciculumque hyssopi tingite in sanguine qui est in limine, et aspergite ex eo superliminare, et utrumque postem: nullus vestrum egrediatur ostium domus suæ usque mane. ");
INSERT INTO latVUC_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Transibit enim Dominus percutiens Ægyptios: cumque viderit sanguinem in superliminari, et in utroque poste, transcendet ostium domus, et non sinet percussorem ingredi domos vestras et lædere. ");
INSERT INTO latVUC_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Custodi verbum istud legitimum tibi et filiis tuis usque in æternum. ");
INSERT INTO latVUC_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Cumque introieritis terram, quam Dominus daturus est vobis ut pollicitus est, observabitis cæremonias istas. ");
INSERT INTO latVUC_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Et cum dixerint vobis filii vestri: Quæ est ista religio? ");
INSERT INTO latVUC_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Dicetis eis: Victima transitus Domini est, quando transivit super domos filiorum Israël in Ægypto, percutiens Ægyptios, et domos nostras liberans. Incurvatusque populus adoravit. ");
INSERT INTO latVUC_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Et egressi filii Israël fecerunt sicut præceperat Dominus Moysi et Aaron. ");
INSERT INTO latVUC_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Factum est autem in noctis medio, percussit Dominus omne primogenitum in terra Ægypti, a primogenito Pharaonis, qui in solio ejus sedebat, usque ad primogenitum captivæ quæ erat in carcere, et omne primogenitum jumentorum. ");
INSERT INTO latVUC_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Surrexitque Pharao nocte, et omnes servi ejus, cunctaque Ægyptus: et ortus est clamor magnus in Ægypto: neque enim erat domus in qua non jaceret mortuus. ");
INSERT INTO latVUC_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Vocatisque Pharao Moyse et Aaron nocte, ait: Surgite et egredimini a populo meo, vos et filii Israël: ite, immolate Domino sicut dicitis. ");
INSERT INTO latVUC_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Oves vestras et armenta assumite ut petieratis, et abeuntes benedicite mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Urgebantque Ægyptii populum de terra exire velociter, dicentes: Omnes moriemur. ");
INSERT INTO latVUC_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Tulit igitur populus conspersam farinam antequam fermentaretur: et ligans in palliis, posuit super humeros suos. ");
INSERT INTO latVUC_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Feceruntque filii Israël sicut præceperat Moyses: et petierunt ab Ægyptiis vasa argentea et aurea, vestemque plurimam. ");
INSERT INTO latVUC_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Dominus autem dedit gratiam populo coram Ægyptiis ut commodarent eis: et spoliaverunt Ægyptios. ");
INSERT INTO latVUC_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Profectique sunt filii Israël de Ramesse in Socoth, sexcenta fere millia peditum virorum, absque parvulis. ");
INSERT INTO latVUC_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Sed et vulgus promiscuum innumerabile ascendit cum eis, oves et armenta et animantia diversi generis multa nimis. ");
INSERT INTO latVUC_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Coxeruntque farinam, quam dudum de Ægypto conspersam tulerant: et fecerunt subcinericios panes azymos: neque enim poterant fermentari, cogentibus exire Ægyptiis, et nullam facere sinentibus moram: nec pulmenti quidquam occurrerat præparare. ");
INSERT INTO latVUC_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Habitatio autem filiorum Israël qua manserunt in Ægypto, fuit quadringentorum triginta annorum. ");
INSERT INTO latVUC_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Quibus expletis, eadem die egressus est omnis exercitus Domini de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Nox ista est observabilis Domini, quando eduxit eos de terra Ægypti: hanc observare debent omnes filii Israël in generationibus suis. ");
INSERT INTO latVUC_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Dixitque Dominus ad Moysen et Aaron: Hæc est religio Phase: omnis alienigena non comedet ex eo. ");
INSERT INTO latVUC_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Omnis autem servus emptitius circumcidetur, et sic comedet. ");
INSERT INTO latVUC_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Advena et mercenarius non edent ex eo. ");
INSERT INTO latVUC_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In una domo comedetur, nec efferetis de carnibus ejus foras, nec os illius confringetis. ");
INSERT INTO latVUC_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Omnis cœtus filiorum Israël faciet illud. ");
INSERT INTO latVUC_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Quod si quis peregrinorum in vestram voluerit transire coloniam, et facere Phase Domini, circumcidetur prius omne masculinum ejus, et tunc rite celebrabit: eritque sicut indigena terræ: si quis autem circumcisus non fuerit, non vescetur ex eo. ");
INSERT INTO latVUC_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Eadem lex erit indigenæ et colono qui peregrinatur apud vos. ");
INSERT INTO latVUC_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Feceruntque omnes filii Israël sicut præceperat Dominus Moysi et Aaron. ");
INSERT INTO latVUC_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Et eadem die eduxit Dominus filios Israël de terra Ægypti per turmas suas. ");
INSERT INTO latVUC_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Sanctifica mihi omne primogenitum quod aperit vulvam in filiis Israël, tam de hominibus quam de jumentis: mea sunt enim omnia. ");
INSERT INTO latVUC_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Et ait Moyses ad populum: Mementote diei hujus in qua egressi estis de Ægypto et de domo servitutis, quoniam in manu forti eduxit vos Dominus de loco isto: ut non comedatis fermentatum panem. ");
INSERT INTO latVUC_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hodie egredimini mense novarum frugum. ");
INSERT INTO latVUC_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Cumque introduxerit te Dominus in terram Chananæi, et Hethæi, et Amorrhæi, et Hevæi, et Jebusæi, quam juravit patribus tuis ut daret tibi, terram fluentem lacte et melle, celebrabis hunc morem sacrorum mense isto. ");
INSERT INTO latVUC_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Septem diebus vesceris azymis: et in die septimo erit solemnitas Domini. ");
INSERT INTO latVUC_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Azyma comedetis septem diebus: non apparebit apud te aliquid fermentatum, nec in cunctis finibus tuis. ");
INSERT INTO latVUC_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Narrabisque filio tuo in die illo, dicens: Hoc est quod fecit mihi Dominus quando egressus sum de Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Et erit quasi signum in manu tua, et quasi monimentum ante oculos tuos: et ut lex Domini semper sit in ore tuo, in manu enim forti eduxit te Dominus de Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Custodies hujuscemodi cultum statuto tempore a diebus in dies. ");
INSERT INTO latVUC_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Cumque introduxerit te Dominus in terram Chananæi, sicut juravit tibi et patribus tuis, et dederit tibi eam: ");
INSERT INTO latVUC_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","separabis omne quod aperit vulvam Domino, et quod primitivum est in pecoribus tuis: quidquid habueris masculini sexus, consecrabis Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Primogenitum asini mutabis ove: quod si non redemeris, interficies. Omne autem primogenitum hominis de filiis tuis, pretio redimes. ");
INSERT INTO latVUC_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Cumque interrogaverit te filius tuus cras, dicens: Quid est hoc? respondebis ei: In manu forti eduxit nos Dominus de terra Ægypti, de domo servitutis. ");
INSERT INTO latVUC_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Nam cum induratus esset Pharao, et nollet nos dimittere, occidit Dominus omne primogenitum in terra Ægypti, a primogenito hominis usque ad primogenitum jumentorum: idcirco immolo Domino omne quod aperit vulvam masculini sexus, et omnia primogenita filiorum meorum redimo. ");
INSERT INTO latVUC_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Erit igitur quasi signum in manu tua, et quasi appensum quid, ob recordationem, inter oculos tuos: eo quod in manu forti eduxit nos Dominus de Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Igitur cum emisisset Pharao populum, non eos duxit Deus per viam terræ Philisthiim quæ vicina est: reputans ne forte pœniteret eum, si vidisset adversum se bella consurgere, et reverteretur in Ægyptum. ");
INSERT INTO latVUC_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Sed circumduxit per viam deserti, quæ est juxta mare Rubrum: et armati ascenderunt filii Israël de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Tulit quoque Moyses ossa Joseph secum: eo quod adjurasset filios Israël, dicens: Visitabit vos Deus; efferte ossa mea hinc vobiscum. ");
INSERT INTO latVUC_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Profectique de Socoth castrametati sunt in Etham, in extremis finibus solitudinis. ");
INSERT INTO latVUC_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Dominus autem præcedebat eos ad ostendendam viam per diem in columna nubis, et per noctem in columna ignis: ut dux esset itineris utroque tempore. ");
INSERT INTO latVUC_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Numquam defuit columna nubis per diem, nec columna ignis per noctem, coram populo. ");
INSERT INTO latVUC_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Locutus est autem Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Loquere filiis Israël: Reversi castrametentur e regione Phihahiroth, quæ est inter Magdalum et mare contra Beelsephon: in conspectu ejus castra ponetis super mare. ");
INSERT INTO latVUC_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Dicturusque est Pharao super filiis Israël: Coarctati sunt in terra; conclusit eos desertum. ");
INSERT INTO latVUC_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Et indurabo cor ejus, ac persequetur vos: et glorificabor in Pharaone, et in omni exercitu ejus; scientque Ægyptii quia ego sum Dominus. Feceruntque ita. ");
INSERT INTO latVUC_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Et nuntiatum est regi Ægyptiorum quod fugisset populus: immutatumque est cor Pharaonis et servorum ejus super populo, et dixerunt: Quid voluimus facere ut dimitteremus Israël, ne serviret nobis? ");
INSERT INTO latVUC_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Junxit ergo currum, et omnem populum suum assumpsit secum. ");
INSERT INTO latVUC_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Tulitque sexcentos currus electos, et quidquid in Ægypto curruum fuit: et duces totius exercitus. ");
INSERT INTO latVUC_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Induravitque Dominus cor Pharaonis regis Ægypti, et persecutus est filios Israël: at illi egressi sunt in manu excelsa. ");
INSERT INTO latVUC_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Cumque persequerentur Ægyptii vestigia præcedentium, repererunt eos in castris super mare: omnis equitatus et currus Pharaonis, et universus exercitus, erant in Phihahiroth contra Beelsephon. ");
INSERT INTO latVUC_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Cumque appropinquasset Pharao, levantes filii Israël oculos, viderunt Ægyptios post se, et timuerunt valde: clamaveruntque ad Dominum, ");
INSERT INTO latVUC_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","et dixerunt ad Moysen: Forsitan non erant sepulchra in Ægypto, ideo tulisti nos ut moreremur in solitudine: quid hoc facere voluisti, ut educeres nos ex Ægypto? ");
INSERT INTO latVUC_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","nonne iste est sermo, quem loquebamur ad te in Ægypto, dicentes: Recede a nobis, ut serviamus Ægyptiis? multo enim melius erat servire eis, quam mori in solitudine. ");
INSERT INTO latVUC_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Et ait Moyses ad populum: Nolite timere: state, et videte magnalia Domini quæ facturus est hodie: Ægyptios enim, quos nunc videtis, nequaquam ultra videbitis usque in sempiternum. ");
INSERT INTO latVUC_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Dominus pugnabit pro vobis, et vos tacebitis. ");
INSERT INTO latVUC_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Dixitque Dominus ad Moysen: Quid clamas ad me? loquere filiis Israël ut proficiscantur. ");
INSERT INTO latVUC_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tu autem eleva virgam tuam, et extende manum tuam super mare, et divide illud: ut gradiantur filii Israël in medio mari per siccum. ");
INSERT INTO latVUC_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ego autem indurabo cor Ægyptiorum ut persequantur vos: et glorificabor in Pharaone, et in omni exercitu ejus, et in curribus et in equitibus illius. ");
INSERT INTO latVUC_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Et scient Ægyptii quia ego sum Dominus cum glorificatus fuero in Pharaone, et in curribus atque in equitibus ejus. ");
INSERT INTO latVUC_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Tollensque se angelus Dei, qui præcedebat castra Israël, abiit post eos: et cum eo pariter columna nubis, priora dimittens, post tergum ");
INSERT INTO latVUC_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","stetit, inter castra Ægyptiorum et castra Israël: et erat nubes tenebrosa, et illuminans noctem, ita ut ad se invicem toto noctis tempore accedere non valerent. ");
INSERT INTO latVUC_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Cumque extendisset Moyses manum super mare, abstulit illud Dominus flante vento vehementi et urente tota nocte, et vertit in siccum: divisaque est aqua. ");
INSERT INTO latVUC_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Et ingressi sunt filii Israël per medium sicci maris: erat enim aqua quasi murus a dextra eorum et læva. ");
INSERT INTO latVUC_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Persequentesque Ægyptii ingressi sunt post eos, et omnis equitatus Pharaonis, currus ejus et equites per medium maris. ");
INSERT INTO latVUC_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Jamque advenerat vigilia matutina, et ecce respiciens Dominus super castra Ægyptiorum per columnam ignis et nubis, interfecit exercitum eorum, ");
INSERT INTO latVUC_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","et subvertit rotas curruum, ferebanturque in profundum. Dixerunt ergo Ægyptii: Fugiamus Israëlem: Dominus enim pugnat pro eis contra nos. ");
INSERT INTO latVUC_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Et ait Dominus ad Moysen: Extende manum tuam super mare, ut revertantur aquæ ad Ægyptios super currus et equites eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Cumque extendisset Moyses manum contra mare, reversum est primo diluculo ad priorem locum: fugientibusque Ægyptiis occurrerunt aquæ, et involvit eos Dominus in mediis fluctibus. ");
INSERT INTO latVUC_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Reversæque sunt aquæ, et operuerunt currus et equites cuncti exercitus Pharaonis, qui sequentes ingressi fuerant mare: nec unus quidem superfuit ex eis. ");
INSERT INTO latVUC_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Filii autem Israël perrexerunt per medium sicci maris, et aquæ eis erant quasi pro muro a dextris et a sinistris: ");
INSERT INTO latVUC_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","liberavitque Dominus in die illa Israël de manu Ægyptiorum. ");
INSERT INTO latVUC_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Et viderunt Ægyptios mortuos super littus maris, et manum magnam quam exercuerat Dominus contra eos: timuitque populus Dominum, et crediderunt Domino, et Moysi servo ejus. ");
INSERT INTO latVUC_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tunc cecinit Moyses et filii Israël carmen hoc Domino, et dixerunt: Cantemus Domino: gloriose enim magnificatus est, equum et ascensorem dejecit in mare. ");
INSERT INTO latVUC_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Fortitudo mea, et laus mea Dominus, et factus est mihi in salutem: iste Deus meus, et glorificabo eum: Deus patris mei, et exaltabo eum. ");
INSERT INTO latVUC_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Dominus quasi vir pugnator, Omnipotens nomen ejus, ");
INSERT INTO latVUC_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","currus Pharaonis et exercitum ejus projecit in mare: electi principes ejus submersi sunt in mari Rubro. ");
INSERT INTO latVUC_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Abyssi operuerunt eos; descenderunt in profundum quasi lapis. ");
INSERT INTO latVUC_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Dextera tua, Domine, magnificata est in fortitudine: dextera tua, Domine, percussit inimicum. ");
INSERT INTO latVUC_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Et in multitudine gloriæ tuæ deposuisti adversarios tuos: misisti iram tuam, quæ devoravit eos sicut stipulam. ");
INSERT INTO latVUC_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Et in spiritu furoris tui congregatæ sunt aquæ: stetit unda fluens, congregata sunt abyssi in medio mari. ");
INSERT INTO latVUC_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Dixit inimicus: Persequar et comprehendam, dividam spolia, implebitur anima mea: evaginabo gladium meum, interficiet eos manus mea. ");
INSERT INTO latVUC_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Flavit spiritus tuus, et operuit eos mare: submersi sunt quasi plumbum in aquis vehementibus. ");
INSERT INTO latVUC_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Quis similis tui in fortibus, Domine? quis similis tui, magnificus in sanctitate, terribilis atque laudabilis, faciens mirabilia? ");
INSERT INTO latVUC_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Extendisti manum tuam, et devoravit eos terra. ");
INSERT INTO latVUC_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Dux fuisti in misericordia tua populo quem redemisti: et portasti eum in fortitudine tua, ad habitaculum sanctum tuum. ");
INSERT INTO latVUC_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ascenderunt populi, et irati sunt: dolores obtinuerunt habitatores Philisthiim. ");
INSERT INTO latVUC_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tunc conturbati sunt principes Edom, robustos Moab obtinuit tremor: obriguerunt omnes habitatores Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Irruat super eos formido et pavor, in magnitudine brachii tui: fiant immobiles quasi lapis, donec pertranseat populus tuus, Domine, donec pertranseat populus tuus iste, quem possedisti. ");
INSERT INTO latVUC_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Introduces eos, et plantabis in monte hæreditatis tuæ, firmissimo habitaculo tuo quod operatus es, Domine: sanctuarium tuum, Domine, quod firmaverunt manus tuæ. ");
INSERT INTO latVUC_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Dominus regnabit in æternum et ultra. ");
INSERT INTO latVUC_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ingressus est enim eques Pharao cum curribus et equitibus ejus in mare: et reduxit super eos Dominus aquas maris: filii autem Israël ambulaverunt per siccum in medio ejus. ");
INSERT INTO latVUC_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Sumpsit ergo Maria prophetissa, soror Aaron, tympanum in manu sua: egressæque sunt omnes mulieres post eam cum tympanis et choris, ");
INSERT INTO latVUC_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","quibus præcinebat, dicens: Cantemus Domino, gloriose enim magnificatus est: equum et ascensorem ejus dejecit in mare. ");
INSERT INTO latVUC_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Tulit autem Moyses Israël de mari Rubro, et egressi sunt in desertum Sur: ambulaveruntque tribus diebus per solitudinem, et non inveniebant aquam. ");
INSERT INTO latVUC_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Et venerunt in Mara, nec poterant bibere aquas de Mara, eo quod essent amaræ: unde et congruum loco nomen imposuit, vocans illum Mara, id est, amaritudinem. ");
INSERT INTO latVUC_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Et murmuravit populus contra Moysen, dicens: Quid bibemus? ");
INSERT INTO latVUC_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","At ille clamavit ad Dominum, qui ostendit ei lignum: quod cum misisset in aquas, in dulcedinem versæ sunt: ibi constituit ei præcepta, atque judicia, et ibi tentavit eum, ");
INSERT INTO latVUC_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","dicens: Si audieris vocem Domini Dei tui, et quod rectum est coram eo feceris, et obedieris mandatis ejus, custodierisque omnia præcepta illius, cunctum languorem, quem posui in Ægypto, non inducam super te: ego enim Dominus sanator tuus. ");
INSERT INTO latVUC_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Venerunt autem in Elim filii Israël, ubi erant duodecim fontes aquarum, et septuaginta palmæ: et castrametati sunt juxta aquas. ");
INSERT INTO latVUC_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Profectique sunt de Elim, et venit omnis multitudo filiorum Israël in desertum Sin, quod est inter Elim et Sinai, quintodecimo die mensis secundi, postquam egressi sunt de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Et murmuravit omnis congregatio filiorum Israël contra Moysen et Aaron in solitudine. ");
INSERT INTO latVUC_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Dixeruntque filii Israël ad eos: Utinam mortui essemus per manum Domini in terra Ægypti, quando sedebamus super ollas carnium, et comedebamus panem in saturitate: cur eduxistis nos in desertum istud, ut occideretis omnem multitudinem fame? ");
INSERT INTO latVUC_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Dixit autem Dominus ad Moysen: Ecce ego pluam vobis panes de cælo: egrediatur populus, et colligat quæ sufficiunt per singulos dies: ut tentem eum utrum ambulet in lege mea, an non. ");
INSERT INTO latVUC_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Die autem sexto parent quod inferant: et sit duplum quam colligere solebant per singulos dies. ");
INSERT INTO latVUC_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Dixeruntque Moyses et Aaron ad omnes filios Israël: Vespere scietis quod Dominus eduxerit vos de terra Ægypti, ");
INSERT INTO latVUC_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","et mane videbitis gloriam Domini: audivit enim murmur vestrum contra Dominum: nos vero quid sumus, quia mussitastis contra nos? ");
INSERT INTO latVUC_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Et ait Moyses: Dabit vobis Dominus vespere carnes edere, et mane panes in saturitate: eo quod audierit murmurationes vestras quibus murmurati estis contra eum: nos enim quid sumus? nec contra nos est murmur vestrum, sed contra Dominum. ");
INSERT INTO latVUC_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Dixit quoque Moyses ad Aaron: Dic universæ congregationi filiorum Israël: Accedite coram Domino: audivit enim murmur vestrum. ");
INSERT INTO latVUC_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Cumque loqueretur Aaron ad omnem cœtum filiorum Israël, respexerunt ad solitudinem: et ecce gloria Domini apparuit in nube. ");
INSERT INTO latVUC_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Locutus est autem Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Audivi murmurationes filiorum Israël. Loquere ad eos: Vespere comedetis carnes, et mane saturabimini panibus: scietisque quod ego sum Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Factum est ergo vespere, et ascendens coturnix, cooperuit castra: mane quoque ros jacuit per circuitum castrorum. ");
INSERT INTO latVUC_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Cumque operuisset superficiem terræ, apparuit in solitudine minutum, et quasi pilo tusum in similitudinem pruinæ super terram. ");
INSERT INTO latVUC_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Quod cum vidissent filii Israël, dixerunt ad invicem: Manhu? quod significat: Quid est hoc? ignorabant enim quid esset. Quibus ait Moyses: Iste est panis quem Dominus dedit vobis ad vescendum. ");
INSERT INTO latVUC_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Hic est sermo, quem præcepit Dominus: Colligat unusquisque ex eo quantum sufficit ad vescendum: gomor per singula capita, juxta numerum animarum vestrarum quæ habitant in tabernaculo sic tolletis. ");
INSERT INTO latVUC_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Feceruntque ita filii Israël: et collegerunt, alius plus, alius minus. ");
INSERT INTO latVUC_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Et mensi sunt ad mensuram gomor: nec qui plus collegerat, habuit amplius: nec qui minus paraverat, reperit minus: sed singuli juxta id quod edere poterant, congregaverunt. ");
INSERT INTO latVUC_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Dixitque Moyses ad eos: Nullus relinquat ex eo in mane. ");
INSERT INTO latVUC_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Qui non audierunt eum, sed dimiserunt quidam ex eis usque mane, et scatere cœpit vermibus, atque computruit: et iratus est contra eos Moyses. ");
INSERT INTO latVUC_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Colligebant autem mane singuli, quantum sufficere poterat ad vescendum: cumque incaluisset sol, liquefiebat. ");
INSERT INTO latVUC_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","In die autem sexta collegerunt cibos duplices, id est, duo gomor per singulos homines: venerunt autem omnes principes multitudinis, et narraverunt Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Qui ait eis: Hoc est quod locutus est Dominus: Requies sabbati sanctificata est Domino cras: quodcumque operandum est, facite, et quæ coquenda sunt coquite: quidquid autem reliquum fuerit, reponite usque in mane. ");
INSERT INTO latVUC_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Feceruntque ita ut præceperat Moyses, et non computruit, neque vermis inventus est in eo. ");
INSERT INTO latVUC_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Dixitque Moyses: Comedite illud hodie, quia sabbatum est Domini: non invenietur hodie in agro. ");
INSERT INTO latVUC_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sex diebus colligite: in die autem septimo sabbatum est Domini, idcirco non invenietur. ");
INSERT INTO latVUC_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Venitque septima dies: et egressi de populo ut colligerent, non invenerunt. ");
INSERT INTO latVUC_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Dixit autem Dominus ad Moysen: Usquequo non vultis custodire mandata mea et legem meam? ");
INSERT INTO latVUC_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","videte quod Dominus dederit vobis sabbatum, et propter hoc die sexta tribuit vobis cibos duplices: maneat unusquisque apud semetipsum; nullus egrediatur de loco suo die septimo. ");
INSERT INTO latVUC_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Et sabbatizavit populus die septimo. ");
INSERT INTO latVUC_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Appellavitque domus Israël nomen ejus Man: quod erat quasi semen coriandri album, gustusque ejus quasi similæ cum melle. ");
INSERT INTO latVUC_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Dixit autem Moyses: Iste est sermo, quem præcepit Dominus: Imple gomor ex eo, et custodiatur in futuras retro generationes: ut noverint panem, quo alui vos in solitudine, quando educti estis de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Dixitque Moyses ad Aaron: Sume vas unum, et mitte ibi man, quantum potest capere gomor, et repone coram Domino ad servandum in generationes vestras, ");
INSERT INTO latVUC_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","sicut præcepit Dominus Moysi. Posuitque illud Aaron in tabernaculo reservandum. ");
INSERT INTO latVUC_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Filii autem Israël comederunt man quadraginta annis, donec venirent in terram habitabilem: hoc cibo aliti sunt, usquequo tangerent fines terræ Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Gomor autem decima pars est ephi. ");
INSERT INTO latVUC_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Igitur profecta omnis multitudo filiorum Israël de deserto Sin per mansiones suas, juxta sermonem Domini, castrametati sunt in Raphidim, ubi non erat aqua ad bibendum populo. ");
INSERT INTO latVUC_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Qui jurgatus contra Moysen, ait: Da nobis aquam, ut bibamus. Quibus respondit Moyses: Quid jurgamini contra me? cur tentatis Dominum? ");
INSERT INTO latVUC_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Sitivit ergo ibi populus præ aquæ penuria, et murmuravit contra Moysen, dicens: Cur fecisti nos exire de Ægypto, ut occideres nos, et liberos nostros, ac jumenta siti? ");
INSERT INTO latVUC_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Clamavit autem Moyses ad Dominum, dicens: Quid faciam populo huic? adhuc paululum, et lapidabit me. ");
INSERT INTO latVUC_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Et ait Dominus ad Moysen: Antecede populum, et sume tecum de senioribus Israël: et virgam qua percussisti fluvium, tolle in manu tua, et vade. ");
INSERT INTO latVUC_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","En ego stabo ibi coram te, supra petram Horeb: percutiesque petram, et exibit ex ea aqua, ut bibat populus. Fecit Moyses ita coram senioribus Israël: ");
INSERT INTO latVUC_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","et vocavit nomen loci illius, Tentatio, propter jurgium filiorum Israël, et quia tentaverunt Dominum, dicentes: Estne Dominus in nobis, an non? ");
INSERT INTO latVUC_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Venit autem Amalec, et pugnabat contra Israël in Raphidim. ");
INSERT INTO latVUC_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Dixitque Moyses ad Josue: Elige viros: et egressus, pugna contra Amalec: cras ego stabo in vertice collis, habens virgam Dei in manu mea. ");
INSERT INTO latVUC_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Fecit Josue ut locutus erat Moyses, et pugnavit contra Amalec: Moyses autem et Aaron et Hur ascenderunt super verticem collis. ");
INSERT INTO latVUC_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Cumque levaret Moyses manus, vincebat Israël: sin autem paululum remisisset, superabat Amalec. ");
INSERT INTO latVUC_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Manus autem Moysi erant graves: sumentes igitur lapidem, posuerunt subter eum, in quo sedit: Aaron autem et Hur sustentabant manus ejus ex utraque parte. Et factum est ut manus illius non lassarentur usque ad occasum solis. ");
INSERT INTO latVUC_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Fugavitque Josue Amalec, et populum ejus in ore gladii. ");
INSERT INTO latVUC_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Dixit autem Dominus ad Moysen: Scribe hoc ob monimentum in libro, et trade auribus Josue: delebo enim memoriam Amalec sub cælo. ");
INSERT INTO latVUC_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ædificavitque Moyses altare: et vocavit nomen ejus, Dominus exaltatio mea, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Quia manus solii Domini, et bellum Domini erit contra Amalec, a generatione in generationem. ");
INSERT INTO latVUC_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Cumque audisset Jethro, sacerdos Madian, cognatus Moysi, omnia quæ fecerat Deus Moysi, et Israëli populo suo, et quod eduxisset Dominus Israël de Ægypto, ");
INSERT INTO latVUC_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","tulit Sephoram uxorem Moysi quam remiserat, ");
INSERT INTO latVUC_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","et duos filios ejus: quorum unus vocabatur Gersam, dicente patre: Advena fui in terra aliena; ");
INSERT INTO latVUC_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","alter vero Eliezer: Deus enim, ait, patris mei adjutor meus, et eruit me de gladio Pharaonis. ");
INSERT INTO latVUC_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Venit ergo Jethro cognatus Moysi, et filii ejus, et uxor ejus ad Moysen in desertum, ubi erat castrametatus juxta montem Dei. ");
INSERT INTO latVUC_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Et mandavit Moysi, dicens: Ego Jethro cognatus tuus venio ad te, et uxor tua, et duo filii cum ea. ");
INSERT INTO latVUC_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Qui egressus in occursum cognati sui, adoravit, et osculatus est eum: salutaveruntque se mutuo verbis pacificis. Cumque intrasset tabernaculum, ");
INSERT INTO latVUC_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","narravit Moyses cognato suo cuncta quæ fecerat Dominus Pharaoni et Ægyptiis propter Israël: universumque laborem, qui accidisset eis in itinere, et quod liberaverat eos Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Lætatusque est Jethro super omnibus bonis, quæ fecerat Dominus Israëli, eo quod eruisset eum de manu Ægyptiorum. ");
INSERT INTO latVUC_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Et ait: Benedictus Dominus, qui liberavit vos de manu Ægyptiorum, et de manu Pharaonis; qui eruit populum suum de manu Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nunc cognovi, quia magnus Dominus super omnes deos: eo quod superbe egerint contra illos. ");
INSERT INTO latVUC_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Obtulit ergo Jethro cognatus Moysi holocausta et hostias Deo: veneruntque Aaron et omnes seniores Israël, ut comederent panem cum eo coram Deo. ");
INSERT INTO latVUC_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Altera autem die sedit Moyses ut judicaret populum, qui assistebat Moysi a mane usque ad vesperam. ");
INSERT INTO latVUC_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Quod cum vidisset cognatus ejus, omnia scilicet quæ agebat in populo, ait: Quid est hoc quod facis in plebe? cur solus sedes, et omnis populus præstolatur de mane usque ad vesperam? ");
INSERT INTO latVUC_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Cui respondit Moyses: Venit ad me populus quærens sententiam Dei: ");
INSERT INTO latVUC_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","cumque acciderit eis aliqua disceptatio, veniunt ad me ut judicem inter eos, et ostendam præcepta Dei, et leges ejus. ");
INSERT INTO latVUC_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","At ille: Non bonam, inquit, rem facis. ");
INSERT INTO latVUC_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Stulto labore consumeris et tu, et populus iste qui tecum est: ultra vires tuas est negotium; solus illud non poteris sustinere. ");
INSERT INTO latVUC_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Sed audi verba mea atque consilia, et erit Deus tecum. Esto tu populo in his quæ ad Deum pertinent, ut referas quæ dicuntur ad eum: ");
INSERT INTO latVUC_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ostendasque populo cæremonias et ritum colendi, viamque per quam ingredi debeant, et opus quod facere debeant. ");
INSERT INTO latVUC_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Provide autem de omni plebe viros potentes, et timentes Deum, in quibus sit veritas, et qui oderint avaritiam, et constitue ex eis tribunos, et centuriones, et quinquagenarios, et decanos, ");
INSERT INTO latVUC_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","qui judicent populum omni tempore: quidquid autem majus fuerit, referant ad te, et ipsi minora tantummodo judicent: leviusque sit tibi, partito in alios onere. ");
INSERT INTO latVUC_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si hoc feceris, implebis imperium Dei, et præcepta ejus poteris sustentare: et omnis hic populus revertetur ad loca sua cum pace. ");
INSERT INTO latVUC_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Quibus auditis, Moyses fecit omnia quæ ille suggesserat. ");
INSERT INTO latVUC_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Et electis viris strenuis de cuncto Israël, constituit eos principes populi, tribunos, et centuriones, et quinquagenarios, et decanos. ");
INSERT INTO latVUC_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Qui judicabant plebem omni tempore: quidquid autem gravius erat, referebant ad eum, faciliora tantummodo judicantes. ");
INSERT INTO latVUC_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Dimisitque cognatum suum: qui reversus abiit in terram suam. ");
INSERT INTO latVUC_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Mense tertio egressionis Israël de terra Ægypti, in die hac venerunt in solitudinem Sinai. ");
INSERT INTO latVUC_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Nam profecti de Raphidim, et pervenientes usque in desertum Sinai, castrametati sunt in eodem loco, ibique Israël fixit tentoria e regione montis. ");
INSERT INTO latVUC_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moyses autem ascendit ad Deum: vocavitque eum Dominus de monte, et ait: Hæc dices domui Jacob, et annuntiabis filiis Israël: ");
INSERT INTO latVUC_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Vos ipsi vidistis quæ fecerim Ægyptiis, quomodo portaverim vos super alas aquilarum, et assumpserim mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Si ergo audieritis vocem meam, et custodieritis pactum meum, eritis mihi in peculium de cunctis populis: mea est enim omnis terra: ");
INSERT INTO latVUC_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","et vos eritis mihi in regnum sacerdotale, et gens sancta. Hæc sunt verba quæ loqueris ad filios Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Venit Moyses: et convocatis majoribus natu populi, exposuit omnes sermones quos mandaverat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Responditque omnis populus simul: Cuncta quæ locutus est Dominus, faciemus. Cumque retulisset Moyses verba populi ad Dominum, ");
INSERT INTO latVUC_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ait ei Dominus: Jam nunc veniam ad te in caligine nubis, ut audiat me populus loquentem ad te, et credat tibi in perpetuum. Nuntiavit ergo Moyses verba populi ad Dominum. ");
INSERT INTO latVUC_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Qui dixit ei: Vade ad populum, et sanctifica illos hodie, et cras, laventque vestimenta sua. ");
INSERT INTO latVUC_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Et sint parati in diem tertium: in die enim tertia descendet Dominus coram omni plebe super montem Sinai. ");
INSERT INTO latVUC_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Constituesque terminos populo per circuitum, et dices ad eos: Cavete ne ascendatis in montem, nec tangatis fines illius: omnis qui tetigerit montem, morte morietur. ");
INSERT INTO latVUC_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Manus non tanget eum, sed lapidibus opprimetur, aut confodietur jaculis: sive jumentum fuerit, sive homo, non vivet: cum cœperit clangere buccina, tunc ascendant in montem. ");
INSERT INTO latVUC_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Descenditque Moyses de monte ad populum, et sanctificavit eum. Cumque lavissent vestimenta sua, ");
INSERT INTO latVUC_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ait ad eos: Estote parati in diem tertium, et ne appropinquetis uxoribus vestris. ");
INSERT INTO latVUC_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Jamque advenerat tertius dies, et mane inclaruerat: et ecce cœperunt audiri tonitrua, ac micare fulgura, et nubes densissima operire montem, clangorque buccinæ vehementius perstrepebat: et timuit populus qui erat in castris. ");
INSERT INTO latVUC_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Cumque eduxisset eos Moyses in occursum Dei de loco castrorum, steterunt ad radices montis. ");
INSERT INTO latVUC_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Totus autem mons Sinai fumabat, eo quod descendisset Dominus super eum in igne: et ascenderet fumus ex eo quasi de fornace, eratque omnis mons terribilis. ");
INSERT INTO latVUC_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Et sonitus buccinæ paulatim crescebat in majus, et prolixius tendebatur: Moyses loquebatur, et Deus respondebat ei. ");
INSERT INTO latVUC_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Descenditque Dominus super montem Sinai in ipso montis vertice, et vocavit Moysen in cacumen ejus. Quo cum ascendisset, ");
INSERT INTO latVUC_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","dixit ad eum: Descende, et contestare populum: ne forte velit transcendere terminos ad videndum Dominum, et pereat ex eis plurima multitudo. ");
INSERT INTO latVUC_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Sacerdotes quoque qui accedunt ad Dominum, sanctificentur, ne percutiat eos. ");
INSERT INTO latVUC_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Dixitque Moyses ad Dominum: Non poterit vulgus ascendere in montem Sinai: tu enim testificatus es, et jussisti, dicens: Pone terminos circa montem, et sanctifica illum. ");
INSERT INTO latVUC_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Cui ait Dominus: Vade, descende: ascendesque tu, et Aaron tecum: sacerdotes autem et populus ne transeant terminos, nec ascendant ad Dominum, ne forte interficiat illos. ");
INSERT INTO latVUC_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Descenditque Moyses ad populum, et omnia narravit eis. ");
INSERT INTO latVUC_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Locutusque est Dominus cunctos sermones hos: ");
INSERT INTO latVUC_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ego sum Dominus Deus tuus, qui eduxi te de terra Ægypti, de domo servitutis. ");
INSERT INTO latVUC_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Non habebis deos alienos coram me. ");
INSERT INTO latVUC_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Non facies tibi sculptile, neque omnem similitudinem quæ est in cælo desuper, et quæ in terra deorsum, nec eorum quæ sunt in aquis sub terra. ");
INSERT INTO latVUC_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Non adorabis ea, neque coles: ego sum Dominus Deus tuus fortis, zelotes, visitans iniquitatem patrum in filios, in tertiam et quartam generationem eorum qui oderunt me: ");
INSERT INTO latVUC_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","et faciens misericordiam in millia his qui diligunt me, et custodiunt præcepta mea. ");
INSERT INTO latVUC_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Non assumes nomen Domini Dei tui in vanum: nec enim habebit insontem Dominus eum qui assumpserit nomen Domini Dei sui frustra. ");
INSERT INTO latVUC_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Memento ut diem sabbati sanctifices. ");
INSERT INTO latVUC_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sex diebus operaberis, et facies omnia opera tua. ");
INSERT INTO latVUC_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Septimo autem die sabbatum Domini Dei tui est: non facies omne opus in eo, tu, et filius tuus et filia tua, servus tuus et ancilla tua, jumentum tuum, et advena qui est intra portas tuas. ");
INSERT INTO latVUC_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Sex enim diebus fecit Dominus cælum et terram, et mare, et omnia quæ in eis sunt, et requievit in die septimo: idcirco benedixit Dominus diei sabbati, et sanctificavit eum. ");
INSERT INTO latVUC_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honora patrem tuum et matrem tuam, ut sis longævus super terram, quam Dominus Deus tuus dabit tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Non occides. ");
INSERT INTO latVUC_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Non mœchaberis. ");
INSERT INTO latVUC_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Non furtum facies. ");
INSERT INTO latVUC_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Non loqueris contra proximum tuum falsum testimonium. ");
INSERT INTO latVUC_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Non concupisces domum proximi tui, nec desiderabis uxorem ejus, non servum, non ancillam, non bovem, non asinum, nec omnia quæ illius sunt. ");
INSERT INTO latVUC_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Cunctus autem populus videbat voces et lampades, et sonitum buccinæ, montemque fumantem: et perterriti ac pavore concussi, steterunt procul, ");
INSERT INTO latVUC_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","dicentes Moysi: Loquere tu nobis, et audiemus: non loquatur nobis Dominus, ne forte moriamur. ");
INSERT INTO latVUC_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Et ait Moyses ad populum: Nolite timere: ut enim probaret vos venit Deus, et ut terror illius esset in vobis, et non peccaretis. ");
INSERT INTO latVUC_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Stetitque populus de longe. Moyses autem accessit ad caliginem in qua erat Deus. ");
INSERT INTO latVUC_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Dixit præterea Dominus ad Moysen: Hæc dices filiis Israël: Vos vidistis quod de cælo locutus sim vobis. ");
INSERT INTO latVUC_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Non facietis deos argenteos, nec deos aureos facietis vobis. ");
INSERT INTO latVUC_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Altare de terra facietis mihi, et offeretis super eo holocausta et pacifica vestra, oves vestras et boves in omni loco in quo memoria fuerit nominis mei: veniam ad te, et benedicam tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Quod si altare lapideum feceris mihi, non ædificabis illud de sectis lapidibus: si enim levaveris cultrum super eo, polluetur. ");
INSERT INTO latVUC_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Non ascendes per gradus ad altare meum, ne reveletur turpitudo tua. ");
INSERT INTO latVUC_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Hæc sunt judicia quæ propones eis. ");
INSERT INTO latVUC_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Si emeris servum hebræum, sex annis serviet tibi: in septimo egredietur liber gratis. ");
INSERT INTO latVUC_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Cum quali veste intraverit, cum tali exeat: si habens uxorem, et uxor egredietur simul. ");
INSERT INTO latVUC_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Sin autem dominus dederit illi uxorem, et pepererit filios et filias: mulier et liberi ejus erunt domini sui, ipse vero exibit cum vestitu suo. ");
INSERT INTO latVUC_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Quod si dixerit servus: Diligo dominum meum et uxorem ac liberos; non egrediar liber: ");
INSERT INTO latVUC_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","offeret eum dominus diis, et applicabitur ad ostium et postes, perforabitque aurem ejus subula: et erit ei servus in sæculum. ");
INSERT INTO latVUC_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Si quis vendiderit filiam suam in famulam, non egredietur sicut ancillæ exire consueverunt. ");
INSERT INTO latVUC_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si displicuerit oculis domini sui cui tradita fuerat, dimittet eam: populo autem alieno vendendi non habebit potestatem, si spreverit eam. ");
INSERT INTO latVUC_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Sin autem filio suo desponderit eam, juxta morem filiarum faciet illi. ");
INSERT INTO latVUC_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Quod si alteram ei acceperit, providebit puellæ nuptias, et vestimenta, et pretium pudicitiæ non negabit. ");
INSERT INTO latVUC_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Si tria ista non fecerit, egredietur gratis absque pecunia. ");
INSERT INTO latVUC_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Qui percusserit hominem volens occidere, morte moriatur. ");
INSERT INTO latVUC_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Qui autem non est insidiatus, sed Deus illum tradidit in manus ejus, constituam tibi locum in quem fugere debeat. ");
INSERT INTO latVUC_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Si quis per industriam occiderit proximum suum, et per insidias: ab altari meo evelles eum, ut moriatur. ");
INSERT INTO latVUC_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Qui percusserit patrem suum aut matrem, morte moriatur. ");
INSERT INTO latVUC_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Qui furatus fuerit hominem, et vendiderit eum, convictus noxæ, morte moriatur. ");
INSERT INTO latVUC_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Qui maledixerit patri suo, vel matri, morte moriatur. ");
INSERT INTO latVUC_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Si rixati fuerint viri, et percusserit alter proximum suum lapide vel pugno, et ille mortuus non fuerit, sed jacuerit in lectulo: ");
INSERT INTO latVUC_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","si surrexerit, et ambulaverit foris super baculum suum, innocens erit qui percusserit, ita tamen ut operas ejus et impensas in medicos restituat. ");
INSERT INTO latVUC_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Qui percusserit servum suum, vel ancillam virga, et mortui fuerint in manibus ejus, criminis reus erit. ");
INSERT INTO latVUC_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Sin autem uno die vel duobus supervixerit, non subjacebit pœnæ, quia pecunia illius est. ");
INSERT INTO latVUC_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Si rixati fuerint viri, et percusserit quis mulierem prægnantem, et abortivum quidem fecerit, sed ipsa vixerit: subjacebit damno quantum maritus mulieris expetierit, et arbitri judicaverint. ");
INSERT INTO latVUC_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Sin autem mors ejus fuerit subsecuta, reddet animam pro anima, ");
INSERT INTO latVUC_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","oculum pro oculo, dentem pro dente, manum pro manu, pedem pro pede, ");
INSERT INTO latVUC_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","adustionem pro adustione, vulnus pro vulnere, livorem pro livore. ");
INSERT INTO latVUC_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Si percusserit quispiam oculum servi sui aut ancillæ, et luscos eos fecerit, dimittet eos liberos pro oculo quem eruit. ");
INSERT INTO latVUC_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Dentem quoque si excusserit servo vel ancillæ suæ, similiter dimittet eos liberos. ");
INSERT INTO latVUC_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Si bos cornu percusserit virum aut mulierem, et mortui fuerint, lapidibus obruetur: et non comedentur carnes ejus, dominus quoque bovis innocens erit. ");
INSERT INTO latVUC_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Quod si bos cornupeta fuerit ab heri et nudiustertius, et contestati sunt dominum ejus, nec recluserit eum, occideritque virum aut mulierem: et bos lapidibus obruetur, et dominum ejus occident. ");
INSERT INTO latVUC_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Quod si pretium fuerit ei impositum, dabit pro anima sua quidquid fuerit postulatus. ");
INSERT INTO latVUC_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Filium quoque et filiam si cornu percusserit, simili sententiæ subjacebit. ");
INSERT INTO latVUC_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Si servum ancillamque invaserit, triginta siclos argenti domino dabit, bos vero lapidibus opprimetur. ");
INSERT INTO latVUC_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Si quis aperuerit cisternam, et foderit, et non operuerit eam, cecideritque bos aut asinus in eam, ");
INSERT INTO latVUC_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","reddet dominus cisternæ pretium jumentorum: quod autem mortuum est, ipsius erit. ");
INSERT INTO latVUC_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Si bos alienus bovem alterius vulneraverit, et ille mortuus fuerit: vendent bovem vivum, et divident pretium, cadaver autem mortui inter se dispertient. ");
INSERT INTO latVUC_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Sin autem sciebat quod bos cornupeta esset ab heri et nudiustertius, et non custodivit eum dominus suus: reddet bovem pro bove, et cadaver integrum accipiet. ");
INSERT INTO latVUC_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Si quis furatus fuerit bovem aut ovem, et occiderit vel vendiderit: quinque boves pro uno bove restituet, et quatuor oves pro una ove. ");
INSERT INTO latVUC_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Si effringens fur domum sive suffodiens fuerit inventus, et accepto vulnere mortuus fuerit, percussor non erit reus sanguinis. ");
INSERT INTO latVUC_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Quod si orto sole hoc fecerit, homicidium perpetravit, et ipse morietur. Si non habuerit quod pro furto reddat, ipse venundabitur. ");
INSERT INTO latVUC_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si inventum fuerit apud eum quod furatus est, vivens: sive bos, sive asinus, sive ovis, duplum restituet. ");
INSERT INTO latVUC_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Si læserit quispiam agrum vel vineam, et dimiserit jumentum suum ut depascatur aliena: quidquid optimum habuerit in agro suo, vel in vinea, pro damni æstimatione restituet. ");
INSERT INTO latVUC_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Si egressus ignis invenerit spinas, et comprehenderit acervos frugum, sive stantes segetes in agris, reddet damnum qui ignem succenderit. ");
INSERT INTO latVUC_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Si quis commendaverit amico pecuniam aut vas in custodiam, et ab eo, qui susceperat, furto ablata fuerint: si invenitur fur, duplum reddet: ");
INSERT INTO latVUC_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","si latet fur, dominus domus applicabitur ad deos, et jurabit quod non extenderit manum in rem proximi sui, ");
INSERT INTO latVUC_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ad perpetrandam fraudem, tam in bove quam in asino, et ove ac vestimento, et quidquid damnum inferre potest: ad deos utriusque causa perveniet, et si illi judicaverit, duplum restituet proximo suo. ");
INSERT INTO latVUC_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Si quis commendaverit proximo suo asinum, bovem, ovem, et omne jumentum ad custodiam, et mortuum fuerit, aut debilitatum, vel captum ab hostibus, nullusque hoc viderit: ");
INSERT INTO latVUC_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","jusjurandum erit in medio, quod non extenderit manum ad rem proximi sui: suscipietque dominus juramentum, et ille reddere non cogetur. ");
INSERT INTO latVUC_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Quod si furto ablatum fuerit, restituet damnum domino; ");
INSERT INTO latVUC_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","si comestum a bestia, deferat ad eum quod occisum est, et non restituet. ");
INSERT INTO latVUC_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Qui a proximo suo quidquam horum mutuo postulaverit, et debilitatum aut mortuum fuerit domino non præsente, reddere compelletur. ");
INSERT INTO latVUC_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Quod si impræsentiarum dominus fuerit, non restituet, maxime si conductum venerat pro mercede operis sui. ");
INSERT INTO latVUC_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Si seduxerit quis virginem necdum desponsatam, dormieritque cum ea: dotabit eam, et habebit eam uxorem. ");
INSERT INTO latVUC_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Si pater virginis dare noluerit, reddet pecuniam juxta modum dotis, quam virgines accipere consueverunt. ");
INSERT INTO latVUC_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Maleficos non patieris vivere. ");
INSERT INTO latVUC_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Qui coierit cum jumento, morte moriatur. ");
INSERT INTO latVUC_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Qui immolat diis, occidetur, præterquam Domino soli. ");
INSERT INTO latVUC_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Advenam non contristabis, neque affliges eum: advenæ enim et ipsi fuistis in terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Viduæ et pupillo non nocebitis. ");
INSERT INTO latVUC_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si læseritis eos, vociferabuntur ad me, et ego audiam clamorem eorum: ");
INSERT INTO latVUC_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","et indignabitur furor meus, percutiamque vos gladio, et erunt uxores vestræ viduæ, et filii vestri pupilli. ");
INSERT INTO latVUC_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Si pecuniam mutuam dederis populo meo pauperi qui habitat tecum, non urgebis eum quasi exactor, nec usuris opprimes. ");
INSERT INTO latVUC_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si pignus a proximo tuo acceperis vestimentum, ante solis occasum reddes ei. ");
INSERT INTO latVUC_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ipsum enim est solum, quo operitur, indumentum carnis ejus, nec habet aliud in quo dormiat: si clamaverit ad me, exaudiam eum, quia misericors sum. ");
INSERT INTO latVUC_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Diis non detrahes, et principi populi tui non maledices. ");
INSERT INTO latVUC_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Decimas tuas et primitias tuas non tardabis reddere: primogenitum filiorum tuorum dabis mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","De bobus quoque, et ovibus similiter facies: septem diebus sit cum matre sua, die octava reddes illum mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Viri sancti eritis mihi: carnem, quæ a bestiis fuerit prægustata, non comedetis, sed projicietis canibus. ");
INSERT INTO latVUC_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Non suscipies vocem mendacii, nec junges manum tuam ut pro impio dicas falsum testimonium. ");
INSERT INTO latVUC_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Non sequeris turbam ad faciendum malum: nec in judicio, plurimorum acquiesces sententiæ, ut a vero devies. ");
INSERT INTO latVUC_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Pauperis quoque non misereberis in judicio. ");
INSERT INTO latVUC_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Si occurreris bovi inimici tui, aut asino erranti, reduc ad eum. ");
INSERT INTO latVUC_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si videris asinum odientis te jacere sub onere, non pertransibis, sed sublevabis cum eo. ");
INSERT INTO latVUC_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Non declinabis in judicium pauperis. ");
INSERT INTO latVUC_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Mendacium fugies. Insontem et justum non occides: quia aversor impium. ");
INSERT INTO latVUC_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Nec accipies munera, quæ etiam excæcant prudentes, et subvertunt verba justorum. ");
INSERT INTO latVUC_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Peregrino molestus non eris. Scitis enim advenarum animas: quia et ipsi peregrini fuistis in terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Sex annis seminabis terram tuam, et congregabis fruges ejus: ");
INSERT INTO latVUC_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","anno autem septimo dimittes eam, et requiescere facies, ut comedant pauperes populi tui: et quidquid reliquum fuerit, edant bestiæ agri: ita facies in vinea et in oliveto tuo. ");
INSERT INTO latVUC_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sex diebus operaberis: septimo die cessabis, ut requiescat bos et asinus tuus, et refrigeretur filius ancillæ tuæ, et advena. ");
INSERT INTO latVUC_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Omnia quæ dixi vobis, custodite. Et per nomen externorum deorum non jurabitis, neque audietur ex ore vestro. ");
INSERT INTO latVUC_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tribus vicibus per singulos annos mihi festa celebrabitis. ");
INSERT INTO latVUC_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Solemnitatem azymorum custodies. Septem diebus comedes azyma, sicut præcepi tibi, tempore mensis novorum, quando egressus es de Ægypto: non apparebis in conspectu meo vacuus. ");
INSERT INTO latVUC_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Et solemnitatem messis primitivorum operis tui, quæcumque seminaveris in agro: solemnitatem quoque in exitu anni, quando congregaveris omnes fruges tuas de agro. ");
INSERT INTO latVUC_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ter in anno apparebit omne masculinum tuum coram Domino Deo tuo. ");
INSERT INTO latVUC_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Non immolabis super fermento sanguinem victimæ meæ, nec remanebit adeps solemnitatis meæ usque mane. ");
INSERT INTO latVUC_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Primitias frugum terræ tuæ deferes in domum Domini Dei tui. Non coques hædum in lacte matris suæ. ");
INSERT INTO latVUC_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ecce ego mittam angelum meum, qui præcedat te, et custodiat in via, et introducat in locum quem paravi. ");
INSERT INTO latVUC_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Observa eum, et audi vocem ejus, nec contemnendum putes: quia non dimittet cum peccaveris, et est nomen meum in illo. ");
INSERT INTO latVUC_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Quod si audieris vocem ejus, et feceris omnia quæ loquor, inimicus ero inimicis tuis, et affligam affligentes te. ");
INSERT INTO latVUC_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Præcedetque te angelus meus, et introducet te ad Amorrhæum, et Hethæum, et Pherezæum, Chananæumque, et Hevæum, et Jebusæum, quos ego conteram. ");
INSERT INTO latVUC_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Non adorabis deos eorum, nec coles eos: non facies opera eorum, sed destrues eos, et confringes statuas eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Servietisque Domino Deo vestro, ut benedicam panibus tuis et aquis, et auferam infirmitatem de medio tui. ");
INSERT INTO latVUC_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Non erit infœcunda, nec sterilis in terra tua: numerum dierum tuorum implebo. ");
INSERT INTO latVUC_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Terrorem meum mittam in præcursum tuum, et occidam omnem populum, ad quem ingredieris: cunctorumque inimicorum tuorum coram te terga vertam: ");
INSERT INTO latVUC_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","emittens crabrones prius, qui fugabunt Hevæum, et Chananæum, et Hethæum, antequam introëas. ");
INSERT INTO latVUC_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Non ejiciam eos a facie tua anno uno: ne terra in solitudinem redigatur, et crescant contra te bestiæ. ");
INSERT INTO latVUC_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Paulatim expellam eos de conspectu tuo, donec augearis, et possideas terram. ");
INSERT INTO latVUC_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ponam autem terminos tuos a mari Rubro usque ad mare Palæstinorum, et a deserto usque ad fluvium: tradam in manibus vestris habitatores terræ, et ejiciam eos de conspectu vestro. ");
INSERT INTO latVUC_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Non inibis cum eis fœdus, nec cum diis eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Non habitent in terra tua, ne forte peccare te faciant in me, si servieris diis eorum: quod tibi certe erit in scandalum. ");
INSERT INTO latVUC_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Moysi quoque dixit: Ascende ad Dominum tu, et Aaron, Nadab et Abiu, et septuaginta senes ex Israël, et adorabitis procul. ");
INSERT INTO latVUC_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Solusque Moyses ascendet ad Dominum, et illi non appropinquabunt: nec populus ascendet cum eo. ");
INSERT INTO latVUC_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Venit ergo Moyses et narravit plebi omnia verba Domini, atque judicia: responditque omnis populus una voce: Omnia verba Domini, quæ locutus est, faciemus. ");
INSERT INTO latVUC_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Scripsit autem Moyses universos sermones Domini: et mane consurgens, ædificavit altare ad radices montis, et duodecim titulos per duodecim tribus Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Misitque juvenes de filiis Israël, et obtulerunt holocausta, immolaveruntque victimas pacificas Domino, vitulos. ");
INSERT INTO latVUC_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Tulit itaque Moyses dimidiam partem sanguinis, et misit in crateras: partem autem residuam fudit super altare. ");
INSERT INTO latVUC_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Assumensque volumen fœderis, legit audiente populo: qui dixerunt: Omnia quæ locutus est Dominus, faciemus, et erimus obedientes. ");
INSERT INTO latVUC_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ille vero sumptum sanguinem respersit in populum, et ait: Hic est sanguis fœderis quod pepigit Dominus vobiscum super cunctis sermonibus his. ");
INSERT INTO latVUC_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ascenderuntque Moyses et Aaron, Nadab et Abiu, et septuaginta de senioribus Israël: ");
INSERT INTO latVUC_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","et viderunt Deum Israël: et sub pedibus ejus quasi opus lapidis sapphirini, et quasi cælum, cum serenum est. ");
INSERT INTO latVUC_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Nec super eos qui procul recesserant de filiis Israël, misit manum suam, videruntque Deum, et comederunt, ac biberunt. ");
INSERT INTO latVUC_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Dixit autem Dominus ad Moysen: Ascende ad me in montem, et esto ibi: daboque tibi tabulas lapideas, et legem, ac mandata quæ scripsi: ut doceas eos. ");
INSERT INTO latVUC_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Surrexerunt Moyses et Josue minister ejus: ascendensque Moyses in montem Dei, ");
INSERT INTO latVUC_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","senioribus ait: Expectate hic donec revertamur ad vos. Habetis Aaron et Hur vobiscum: si quid natum fuerit quæstionis, referetis ad eos. ");
INSERT INTO latVUC_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Cumque ascendisset Moyses, operuit nubes montem, ");
INSERT INTO latVUC_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","et habitavit gloria Domini super Sinai, tegens illum nube sex diebus: septimo autem die vocavit eum de medio caliginis. ");
INSERT INTO latVUC_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Erat autem species gloriæ Domini quasi ignis ardens super verticem montis in conspectu filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ingressusque Moyses medium nebulæ, ascendit in montem: et fuit ibi quadraginta diebus, et quadraginta noctibus. ");
INSERT INTO latVUC_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Loquere filiis Israël, ut tollant mihi primitias: ab omni homine qui offeret ultroneus, accipietis eas. ");
INSERT INTO latVUC_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Hæc sunt autem quæ accipere debeatis: aurum, et argentum, et æs, ");
INSERT INTO latVUC_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","hyacinthum et purpuram, coccumque bis tinctum, et byssum, pilos caprarum, ");
INSERT INTO latVUC_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","et pelles arietum rubricatas, pellesque janthinas, et ligna setim: ");
INSERT INTO latVUC_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oleum ad luminaria concinnanda: aromata in unguentum, et thymiamata boni odoris: ");
INSERT INTO latVUC_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","lapides onychinos, et gemmas ad ornandum ephod, ac rationale. ");
INSERT INTO latVUC_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Facientque mihi sanctuarium, et habitabo in medio eorum: ");
INSERT INTO latVUC_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","juxta omnem similitudinem tabernaculi quod ostendam tibi, et omnium vasorum in cultum ejus. Sicque facietis illud: ");
INSERT INTO latVUC_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","arcam de lignis setim compingite, cujus longitudo habeat duos et semis cubitos: latitudo, cubitum et dimidium: altitudo, cubitum similiter ac semissem. ");
INSERT INTO latVUC_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Et deaurabis eam auro mundissimo intus et foris: faciesque supra, coronam auream per circuitum: ");
INSERT INTO latVUC_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","et quatuor circulos aureos, quos pones per quatuor arcæ angulos: duo circuli sint in latere uno, et duo in altero. ");
INSERT INTO latVUC_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Facies quoque vectes de lignis setim, et operies eos auro. ");
INSERT INTO latVUC_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Inducesque per circulos qui sunt in arcæ lateribus, ut portetur in eis: ");
INSERT INTO latVUC_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","qui semper erunt in circulis, nec umquam extrahentur ab eis. ");
INSERT INTO latVUC_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ponesque in arca testificationem quam dabo tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Facies et propitiatorium de auro mundissimo: duos cubitos et dimidium tenebit longitudo ejus, et cubitum ac semissem latitudo. ");
INSERT INTO latVUC_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Duos quoque cherubim aureos et productiles facies, ex utraque parte oraculi. ");
INSERT INTO latVUC_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Cherub unus sit in latere uno, et alter in altero. ");
INSERT INTO latVUC_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Utrumque latus propitiatorii tegant expandentes alas, et operientes oraculum, respiciantque se mutuo versis vultibus in propitiatorium quo operienda est arca, ");
INSERT INTO latVUC_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","in qua pones testimonium quod dabo tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Inde præcipiam, et loquar ad te supra propitiatorium, ac de medio duorum cherubim, qui erunt super arcam testimonii, cuncta quæ mandabo per te filiis Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Facies et mensam de lignis setim, habentem duos cubitos longitudinis, et in latitudine cubitum, et in altitudine cubitum et semissem. ");
INSERT INTO latVUC_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Et inaurabis eam auro purissimo: faciesque illi labium aureum per circuitum, ");
INSERT INTO latVUC_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","et ipsi labio coronam interrasilem altam quatuor digitis: et super illam, alteram coronam aureolam. ");
INSERT INTO latVUC_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Quatuor quoque circulos aureos præparabis, et pones eis in quatuor angulis ejusdem mensæ per singulos pedes. ");
INSERT INTO latVUC_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Subter coronam erunt circuli aurei, ut mittantur vectes per eos, et possit mensa portari. ");
INSERT INTO latVUC_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ipsos quoque vectes facies de lignis setim, et circumdabis auro ad subvehendam mensam. ");
INSERT INTO latVUC_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Parabis et acetabula, ac phialas, thuribula, et cyathos, in quibus offerenda sunt libamina, ex auro purissimo. ");
INSERT INTO latVUC_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Et pones super mensam panes propositionis in conspectu meo semper. ");
INSERT INTO latVUC_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Facies et candelabrum ductile de auro mundissimo, hastile ejus, et calamos, scyphos, et sphærulas, ac lilia ex ipso procedentia. ");
INSERT INTO latVUC_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Sex calami egredientur de lateribus, tres ex uno latere, et tres ex altero. ");
INSERT INTO latVUC_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tres scyphi quasi in nucis modum per calamos singulos, sphærulaque simul, et lilium: et tres similiter scyphi instar nucis in calamo altero, sphærulaque simul et lilium. Hoc erit opus sex calamorum, qui producendi sunt de hastili: ");
INSERT INTO latVUC_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","in ipso autem candelabro erunt quatuor scyphi in nucis modum, sphærulæque per singulos, et lilia. ");
INSERT INTO latVUC_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Sphærulæ sub duobus calamis per tria loca, qui simul sex fiunt procedentes de hastili uno. ");
INSERT INTO latVUC_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Et sphærulæ igitur et calami ex ipso erunt, universa ductilia de auro purissimo. ");
INSERT INTO latVUC_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Facies et lucernas septem, et pones eas super candelabrum, ut luceant ex adverso. ");
INSERT INTO latVUC_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Emunctoria quoque, et ubi quæ emuncta sunt extinguantur, fiant de auro purissimo. ");
INSERT INTO latVUC_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Omne pondus candelabri cum universis vasis suis habebit talentum auri purissimi. ");
INSERT INTO latVUC_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Inspice, et fac secundum exemplar quod tibi in monte monstratum est. ");
INSERT INTO latVUC_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Tabernaculum vero ita facies: decem cortinas de bysso retorta, et hyacintho, ac purpura, coccoque bis tincto, variatas opere plumario facies. ");
INSERT INTO latVUC_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Longitudo cortinæ unius habebit viginti octo cubitos: latitudo, quatuor cubitorum erit. Unius mensuræ fient universa tentoria. ");
INSERT INTO latVUC_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Quinque cortinæ sibi jungentur mutuo, et aliæ quinque nexu simili cohærebunt. ");
INSERT INTO latVUC_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ansulas hyacinthinas in lateribus ac summitatibus facies cortinarum, ut possint invicem copulari. ");
INSERT INTO latVUC_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Quinquagenas ansulas cortina habebit in utraque parte, ita insertas ut ansa contra ansam veniat, et altera alteri possit aptari. ");
INSERT INTO latVUC_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Facies et quinquaginta circulos aureos quibus cortinarum vela jungenda sunt, ut unum tabernaculum fiat. ");
INSERT INTO latVUC_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Facies et saga cilicina undecim, ad operiendum tectum tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Longitudo sagi unius habebit triginta cubitos, et latitudo, quatuor: æqua erit mensura sagorum omnium. ");
INSERT INTO latVUC_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","E quibus quinque junges seorsum, et sex sibi mutuo copulabis, ita ut sextum sagum in fronte tecti duplices. ");
INSERT INTO latVUC_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Facies et quinquaginta ansas in ora sagi unius, ut conjungi cum altero queat, et quinquaginta ansas in ora sagi alterius, ut cum altero copuletur. ");
INSERT INTO latVUC_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Facies et quinquaginta fibulas æneas quibus jungantur ansæ, ut unum ex omnibus operimentum fiat. ");
INSERT INTO latVUC_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Quod autem superfuerit in sagis quæ parantur tecto, id est unum sagum quod amplius est, ex medietate ejus operies posteriora tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Et cubitus ex una parte pendebit, et alter ex altera qui plus est in sagorum longitudine, utrumque latus tabernaculi protegens. ");
INSERT INTO latVUC_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Facies et operimentum aliud tecto de pellibus arietum rubricatis: et super hoc rursum aliud operimentum de janthinis pellibus. ");
INSERT INTO latVUC_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Facies et tabulas stantes tabernaculi de lignis setim, ");
INSERT INTO latVUC_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","quæ singulæ denos cubitos in longitudine habeant, et in latitudine singulos ac semissem. ");
INSERT INTO latVUC_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","In lateribus tabulæ, duæ incastraturæ fient, quibus tabula alteri tabulæ connectatur: atque in hunc modum cunctæ tabulæ parabuntur. ");
INSERT INTO latVUC_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Quarum viginti erunt in latere meridiano quod vergit ad austrum. ");
INSERT INTO latVUC_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Quibus quadraginta bases argenteas fundes, ut binæ bases singulis tabulis per duos angulos subjiciantur. ");
INSERT INTO latVUC_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","In latere quoque secundo tabernaculi quod vergit ad aquilonem, viginti tabulæ erunt, ");
INSERT INTO latVUC_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","quadraginta habentes bases argenteas, binæ bases singulis tabulis supponentur. ");
INSERT INTO latVUC_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ad occidentalem vero plagam tabernaculi facies sex tabulas, ");
INSERT INTO latVUC_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","et rursum alias duas quæ in angulis erigantur post tergum tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Eruntque conjunctæ a deorsum usque sursum, et una omnes compago retinebit. Duabus quoque tabulis quæ in angulis ponendæ sunt, similis junctura servabitur. ");
INSERT INTO latVUC_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Et erunt simul tabulæ octo, bases earum argenteæ sedecim, duabus basibus per unam tabulam supputatis. ");
INSERT INTO latVUC_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Facies et vectes de lignis setim quinque ad continendas tabulas in uno latere tabernaculi, ");
INSERT INTO latVUC_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","et quinque alios in altero, et ejusdem numeri ad occidentalem plagam: ");
INSERT INTO latVUC_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","qui mittentur per medias tabulas a summo usque ad summum. ");
INSERT INTO latVUC_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ipsas quoque tabulas deaurabis, et fundes in eis annulos aureos per quos vectes tabulata contineant: quos operies laminis aureis. ");
INSERT INTO latVUC_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Et eriges tabernaculum juxta exemplar quod tibi in monte monstratum est. ");
INSERT INTO latVUC_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Facies et velum de hyacintho, et purpura, coccoque bis tincto, et bysso retorta, opere plumario et pulchra varietate contextum: ");
INSERT INTO latVUC_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","quod appendes ante quatuor columnas de lignis setim, quæ ipsæ quidem deauratæ erunt, et habebunt capita aurea, sed bases argenteas. ");
INSERT INTO latVUC_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Inseretur autem velum per circulos, intra quod pones arcam testimonii, quo et sanctuarium, et sanctuarii sanctuaria dividentur. ");
INSERT INTO latVUC_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Pones et propitiatorium super arcam testimonii in Sancto sanctorum, ");
INSERT INTO latVUC_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","mensamque extra velum, et contra mensam candelabrum in latere tabernaculi meridiano: mensa enim stabit in parte aquilonis. ");
INSERT INTO latVUC_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Facies et tentorium in introitu tabernaculi de hyacintho, et purpura, coccoque bis tincto, et bysso retorta, opere plumarii. ");
INSERT INTO latVUC_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Et quinque columnas deaurabis lignorum setim, ante quas ducetur tentorium: quarum erunt capita aurea, et bases æneæ. ");
INSERT INTO latVUC_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Facies et altare de lignis setim, quod habebit quinque cubitus in longitudine, et totidem in latitudine, id est, quadrum, et tres cubitos in altitudine. ");
INSERT INTO latVUC_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Cornua autem per quatuor angulos ex ipso erunt: et operies illud ære. ");
INSERT INTO latVUC_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Faciesque in usus ejus lebetes ad suscipiendos cineres, et forcipes atque fuscinulas, et ignium receptacula; omnia vasa ex ære fabricabis. ");
INSERT INTO latVUC_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Craticulamque in modum retis æneam: per cujus quatuor angulos erunt quatuor annuli ænei. ");
INSERT INTO latVUC_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Quos pones subter arulam altaris: eritque craticula usque ad altaris medium. ");
INSERT INTO latVUC_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Facies et vectes altaris de lignis setim duos, quos operies laminis æneis: ");
INSERT INTO latVUC_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","et induces per circulos, eruntque ex utroque latere altaris ad portandum. ");
INSERT INTO latVUC_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Non solidum, sed inane et cavum intrinsecus facies illud, sicut tibi in monte monstratum est. ");
INSERT INTO latVUC_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Facies et atrium tabernaculi, in cujus australi plaga contra meridiem erunt tentoria de bysso retorta: centum cubitos unum latus tenebit in longitudine. ");
INSERT INTO latVUC_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Et columnas viginti cum basibus totidem æneis, quæ capita cum cælaturis suis habebunt argentea. ");
INSERT INTO latVUC_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Similiter et in latere aquilonis per longum erunt tentoria centum cubitorum, columnæ viginti, et bases æneæ ejusdem numeri, et capita earum cum cælaturis suis argentea. ");
INSERT INTO latVUC_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","In latitudine vero atrii, quod respicit ad occidentem, erunt tentoria per quinquaginta cubitos, et columnæ decem, basesque totidem. ");
INSERT INTO latVUC_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","In ea quoque atrii latitudine, quæ respicit ad orientem, quinquaginta cubiti erunt. ");
INSERT INTO latVUC_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","In quibus quindecim cubitorum tentoria lateri uno deputabuntur, columnæque tres et bases totidem: ");
INSERT INTO latVUC_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","et in latere altero erunt tentoria cubitos obtinentia quindecim, columnæ tres, et bases totidem. ");
INSERT INTO latVUC_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","In introitu vero atrii fiet tentorium cubitorum viginti ex hyacintho et purpura, coccoque bis tincto, et bysso retorta, opere plumarii: columnas habebit quatuor, cum basibus totidem. ");
INSERT INTO latVUC_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Omnes columnæ atrii per circuitum vestitæ erunt argenteis laminis, capitibus argenteis, et basibus æneis. ");
INSERT INTO latVUC_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","In longitudine occupabit atrium cubitos centum, in latitudine quinquaginta, altitudo quinque cubitorum erit: fietque de bysso retorta, et habebit bases æneas. ");
INSERT INTO latVUC_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Cuncta vasa tabernaculi in omnes usus et cæremonias, tam paxillos ejus quam atrii, ex ære facies. ");
INSERT INTO latVUC_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Præcipe filiis Israël ut afferant tibi oleum de arboribus olivarum purissimum, piloque contusum, ut ardeat lucerna semper ");
INSERT INTO latVUC_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","in tabernaculo testimonii, extra velum quod oppansum est testimonio. Et collocabunt eam Aaron et filii ejus, ut usque mane luceat coram Domino. Perpetuus erit cultus per successiones eorum a filiis Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Applica quoque ad te Aaron fratrem tuum cum filiis suis de medio filiorum Israël, ut sacerdotio fungantur mihi: Aaron, Nadab, et Abiu, Eleazar, et Ithamar. ");
INSERT INTO latVUC_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Faciesque vestem sanctam Aaron fratri tuo in gloriam et decorem. ");
INSERT INTO latVUC_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Et loqueris cunctis sapientibus corde quos replevi spiritu prudentiæ, ut faciant vestes Aaron, in quibus sanctificatus ministret mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Hæc autem erunt vestimenta quæ faciet: rationale et superhumerale, tunicam et lineam strictam, cidarim et balteum. Facient vestimenta sancta fratri tuo Aaron et filiis ejus, ut sacerdotio fungantur mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Accipientque aurum, et hyacinthum, et purpuram, coccumque bis tinctum, et byssum. ");
INSERT INTO latVUC_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Facient autem superhumerale de auro et hyacintho et purpura, coccoque bis tincto, et bysso retorta, opere polymito. ");
INSERT INTO latVUC_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Duas oras junctas habebit in utroque latere summitatum, ut in unum redeant. ");
INSERT INTO latVUC_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ipsa quoque textura et cuncta operis varietas erit ex auro et hyacintho, et purpura, coccoque bis tincto, et bysso retorta. ");
INSERT INTO latVUC_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Sumesque duos lapides onychinos, et sculpes in eis nomina filiorum Israël: ");
INSERT INTO latVUC_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","sex nomina in lapide uno, et sex reliqua in altero, juxta ordinem nativitatis eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Opere sculptoris et cælatura gemmarii, sculpes eos nominibus filiorum Israël, inclusos auro atque circumdatos: ");
INSERT INTO latVUC_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","et pones in utroque latere superhumeralis, memoriale filiis Israël. Portabitque Aaron nomina eorum coram Domino super utrumque humerum, ob recordationem. ");
INSERT INTO latVUC_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Facies et uncinos ex auro, ");
INSERT INTO latVUC_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","et duas catenulas ex auro purissimo sibi invicem cohærentes, quas inseres uncinis. ");
INSERT INTO latVUC_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Rationale quoque judicii facies opere polymito juxta texturam superhumeralis, ex auro, hyacintho, et purpura, coccoque bis tincto, et bysso retorta. ");
INSERT INTO latVUC_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Quadrangulum erit et duplex: mensuram palmi habebit tam in longitudine quam in latitudine. ");
INSERT INTO latVUC_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ponesque in eo quatuor ordines lapidum: in primo versu erit lapis sardius, et topazius, et smaragdus: ");
INSERT INTO latVUC_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","in secundo carbunculus, sapphirus, et jaspis: ");
INSERT INTO latVUC_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","in tertio ligurius, achates, et amethystus: ");
INSERT INTO latVUC_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","in quarto chrysolithus, onychinus, et beryllus. Inclusi auro erunt per ordines suos. ");
INSERT INTO latVUC_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Habebuntque nomina filiorum Israël: duodecim nominibus cælabuntur, singuli lapides nominibus singulorum per duodecim tribus. ");
INSERT INTO latVUC_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Facies in rationali catenas sibi invicem cohærentes ex auro purissimo, ");
INSERT INTO latVUC_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","et duos annulos aureos, quos pones in utraque rationalis summitate: ");
INSERT INTO latVUC_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","catenasque aureas junges annulis, qui sunt in marginibus ejus, ");
INSERT INTO latVUC_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","et ipsarum catenarum extrema duobus copulabis uncinis in utroque latere superhumeralis quod rationale respicit. ");
INSERT INTO latVUC_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Facies et duos annulos aureos, quos pones in summitatibus rationalis, in oris, quæ e regione sunt superhumeralis, et posteriora ejus aspiciunt. ");
INSERT INTO latVUC_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Necnon et alios duos annulos aureos, qui ponendi sunt in utroque latere superhumeralis deorsum, quod respicit contra faciem juncturæ inferioris, ut aptari possit cum superhumerali, ");
INSERT INTO latVUC_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","et stringatur rationale annulis suis cum annulis superhumeralis vitta hyacinthina, ut maneat junctura fabrefacta, et a se invicem rationale et superhumerale nequeant separari. ");
INSERT INTO latVUC_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Portabitque Aaron nomina filiorum Israël in rationali judicii super pectus suum, quando ingredietur Sanctuarium, memoriale coram Domino in æternum. ");
INSERT INTO latVUC_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Pones autem in rationali judicii Doctrinam et Veritatem, quæ erunt in pectore Aaron, quando ingredietur coram Domino: et gestabit judicium filiorum Israël in pectore suo, in conspectu Domini semper. ");
INSERT INTO latVUC_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Facies et tunicam superhumeralis totam hyacinthinam, ");
INSERT INTO latVUC_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","in cujus medio supra erit capitium, et ora per gyrum ejus textilis, sicut fieri solet in extremis vestium partibus, ne facile rumpatur. ");
INSERT INTO latVUC_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Deorsum vero, ad pedes ejusdem tunicæ, per circuitum, quasi mala punica facies, ex hyacintho, et purpura, et cocco bis tincto, mistis in medio tintinnabulis, ");
INSERT INTO latVUC_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ita ut tintinnabulum sit aureum et malum punicum: rursumque tintinnabulum aliud aureum et malum punicum. ");
INSERT INTO latVUC_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Et vestietur ea Aaron in officio ministerii, ut audiatur sonitus quando ingreditur et egreditur sanctuarium in conspectu Domini, et non moriatur. ");
INSERT INTO latVUC_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Facies et laminam de auro purissimo, in qua sculpes opere cælatoris, Sanctum Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ligabisque eam vitta hyacinthina, et erit super tiaram, ");
INSERT INTO latVUC_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","imminens fronti pontificis. Portabitque Aaron iniquitates eorum, quæ obtulerunt et sanctificaverunt filii Israël, in cunctis muneribus et donariis suis. Erit autem lamina semper in fronte ejus, ut placatus sit eis Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Stringesque tunicam bysso, et tiaram byssinam facies, et balteum opere plumarii. ");
INSERT INTO latVUC_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Porro filiis Aaron tunicas lineas parabis et balteos ac tiaras in gloriam et decorem: ");
INSERT INTO latVUC_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","vestiesque his omnibus Aaron fratrem tuum et filios ejus cum eo. Et cunctorum consecrabis manus, sanctificabisque illos, ut sacerdotio fungantur mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Facies et feminalia linea, ut operiant carnem turpitudinis suæ, a renibus usque ad femora: ");
INSERT INTO latVUC_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","et utentur eis Aaron et filii ejus quando ingredientur tabernaculum testimonii, vel quando appropinquant ad altare ut ministrent in sanctuario, ne iniquitatis rei moriantur. Legitimum sempiternum erit Aaron, et semini ejus post eum. ");
INSERT INTO latVUC_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Sed et hoc facies, ut mihi in sacerdotio consecrentur. Tolle vitulum de armento, et arietes duos immaculatos, ");
INSERT INTO latVUC_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","panesque azymos, et crustulam absque fermento, quæ conspersa sit oleo, lagana quoque azyma oleo lita: de simila triticea cuncta facies. ");
INSERT INTO latVUC_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Et posita in canistro offeres: vitulum autem et duos arietes. ");
INSERT INTO latVUC_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Et Aaron ac filios ejus applicabis ad ostium tabernaculi testimonii. Cumque laveris patrem cum filiis suis aqua, ");
INSERT INTO latVUC_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","indues Aaron vestimentis suis, id est, linea et tunica, et superhumerali et rationali, quod constringes balteo. ");
INSERT INTO latVUC_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Et pones tiaram in capite ejus, et laminam sanctam super tiaram, ");
INSERT INTO latVUC_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","et oleum unctionis fundes super caput ejus: atque hoc ritu consecrabitur. ");
INSERT INTO latVUC_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Filios quoque illius applicabis, et indues tunicis lineis, cingesque balteo, ");
INSERT INTO latVUC_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Aaron scilicet et liberos ejus, et impones eis mitras: eruntque sacerdotes mihi religione perpetua. Postquam initiaveris manus eorum, ");
INSERT INTO latVUC_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","applicabis et vitulum coram tabernaculo testimonii. Imponentque Aaron et filii ejus manus super caput illius, ");
INSERT INTO latVUC_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","et mactabis eum in conspectu Domini, juxta ostium tabernaculi testimonii. ");
INSERT INTO latVUC_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Sumptumque de sanguine vituli, pones super cornua altaris digito tuo, reliquum autem sanguinem fundes juxta basim ejus. ");
INSERT INTO latVUC_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Sumes et adipem totum qui operit intestina, et reticulum jecoris, ac duos renes, et adipem qui super eos est, et offeres incensum super altare: ");
INSERT INTO latVUC_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","carnes vero vituli et corium et fimum combures foris extra castra, eo quod pro peccato sit. ");
INSERT INTO latVUC_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Unum quoque arietem sumes, super cujus caput ponent Aaron et filii ejus manus. ");
INSERT INTO latVUC_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Quem cum mactaveris, tolles de sanguine ejus, et fundes circa altare. ");
INSERT INTO latVUC_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ipsum autem arietem secabis in frustra: lotaque intestina ejus ac pedes, pones super concisas carnes, et super caput illius. ");
INSERT INTO latVUC_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Et offeres totum arietem in incensum super altare: oblatio est Domino, odor suavissimus victimæ Domini. ");
INSERT INTO latVUC_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Tolles quoque arietem alterum, super cujus caput Aaron et filii ejus ponent manus. ");
INSERT INTO latVUC_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Quem cum immolaveris, sumes de sanguine ejus, et pones super extremum auriculæ dextræ Aaron et filiorum ejus, et super pollices manus eorum ac pedis dextri, fundesque sanguinem super altare per circuitum. ");
INSERT INTO latVUC_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Cumque tuleris de sanguine qui est super altare, et de oleo unctionis, asperges Aaron et vestes ejus, filios et vestimenta eorum. Consecratisque ipsis et vestibus, ");
INSERT INTO latVUC_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","tolles adipem de ariete, et caudam et arvinam, quæ operit vitalia, ac reticulum jecoris, et duos renes, atque adipem, qui super eos est, armumque dextrum, eo quod sit aries consecrationis: ");
INSERT INTO latVUC_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","tortamque panis unius, crustulam conspersam oleo, laganum de canistro azymorum, quod positum est in conspectu Domini: ");
INSERT INTO latVUC_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ponesque omnia super manus Aaron et filiorum ejus, et sanctificabis eos elevans coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Suscipiesque universa de manibus eorum: et incendes super altare in holocaustum, odorem suavissimum in conspectu Domini, quia oblatio ejus est. ");
INSERT INTO latVUC_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Sumes quoque pectusculum de ariete, quo initiatus est Aaron, sanctificabisque illud elevatum coram Domino, et cedet in partem tuam. ");
INSERT INTO latVUC_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Sanctificabisque et pectusculum consecratum, et armum quem de ariete separasti, ");
INSERT INTO latVUC_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","quo initiatus est Aaron et filii ejus, cedentque in partem Aaron et filiorum ejus jure perpetuo a filiis Israël: quia primitiva sunt et initia de victimis eorum pacificis quæ offerunt Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Vestem autem sanctam, qua utetur Aaron, habebunt filii ejus post eum, ut ungantur in ea, et consecrantur manus eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Septem diebus utetur illa qui pontifex pro eo fuerit constitutus de filiis ejus, et qui ingredietur tabernaculum testimonii ut ministret in sanctuario. ");
INSERT INTO latVUC_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Arietem autem consecrationis tolles, et coques carnes ejus in loco sancto: ");
INSERT INTO latVUC_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","quibus vescetur Aaron et filii ejus. Panes quoque, qui sunt in canistro, in vestibulo tabernaculi testimonii comedent, ");
INSERT INTO latVUC_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ut sit placabile sacrificium, et sanctificentur offerentium manus. Alienigena non vescetur ex eis, quia sancti sunt. ");
INSERT INTO latVUC_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Quod si remanserit de carnibus consecratis, sive de panibus usque mane, combures reliquias igni: non comedentur, quia sanctificata sunt. ");
INSERT INTO latVUC_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Omnia, quæ præcepi tibi, facies super Aaron et filiis ejus. Septem diebus consecrabis manus eorum: ");
INSERT INTO latVUC_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","et vitulum pro peccato offeres per singulos dies ad expiandum. Mundabisque altare cum immolaveris expiationis hostiam, et unges illud in sanctificationem. ");
INSERT INTO latVUC_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Septem diebus expiabis altare, et sanctificabis, et erit Sanctum sanctorum: omnis, qui tetigerit illud, sanctificabitur. ");
INSERT INTO latVUC_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Hoc est quod facies in altari: agnos anniculos duos per singulos dies jugiter, ");
INSERT INTO latVUC_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","unum agnum mane, et alterum vespere, ");
INSERT INTO latVUC_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","decimam partem similæ conspersæ oleo tuso, quod habeat mensuram quartam partem hin, et vinum ad libandum ejusdem mensuræ in agno uno. ");
INSERT INTO latVUC_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Alterum vero agnum offeres ad vesperam juxta ritum matutinæ oblationis, et juxta ea quæ diximus, in odorem suavitatis: ");
INSERT INTO latVUC_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","sacrificium est Domino, oblatione perpetua in generationes vestras, ad ostium tabernaculi testimonii coram Domino, ubi constituam ut loquar ad te. ");
INSERT INTO latVUC_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ibique præcipiam filiis Israël, et sanctificabitur altare in gloria mea. ");
INSERT INTO latVUC_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Sanctificabo et tabernaculum testimonii cum altari, et Aaron cum filiis suis, ut sacerdotio fungantur mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Et habitabo in medio filiorum Israël, eroque eis Deus, ");
INSERT INTO latVUC_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","et scient quia ego Dominus Deus eorum, qui eduxi eos de terra Ægypti, ut manerem inter illos, ego Dominus Deus ipsorum. ");
INSERT INTO latVUC_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Facies quoque altare ad adolendum thymiama, de lignis setim, ");
INSERT INTO latVUC_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","habens cubitum longitudinis, et alterum latitudinis, id est, quadrangulum, et duos cubitos in altitudine. Cornua ex ipso procedent. ");
INSERT INTO latVUC_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Vestiesque illud auro purissimo, tam craticulam ejus, quam parietes per circuitum, et cornua. Faciesque ei coronam aureolam per gyrum, ");
INSERT INTO latVUC_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","et duos annulos aureos sub corona per singula latera, ut mittantur in eos vectes, et altare portetur. ");
INSERT INTO latVUC_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ipsos quoque vectes facies de lignis setim, et inaurabis. ");
INSERT INTO latVUC_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ponesque altare contra velum, quod ante arcum pendet testimonii coram propitiatorio quo tegitur testimonium, ubi loquar tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Et adolebit incensum super eo Aaron, suave fragrans, mane. Quando componet lucernas, incendet illud: ");
INSERT INTO latVUC_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","et quando collocabit eas ad vesperum, uret thymiama sempiternum coram Domino in generationes vestras. ");
INSERT INTO latVUC_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Non offeretis super eo thymiama compositionis alterius, nec oblationem, et victimam, nec libabitis libamina. ");
INSERT INTO latVUC_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Et deprecabitur Aaron super cornua ejus semel per annum, in sanguine quod oblatum est pro peccato, et placabit super eo in generationibus vestris. Sanctum sanctorum erit Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Quando tuleris summam filiorum Israël juxta numerum, dabunt singuli pretium pro animabus suis Domino, et non erit plaga in eis, cum fuerint recensiti. ");
INSERT INTO latVUC_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Hoc autem dabit omnis qui transit ad nomen, dimidium sicli juxta mensuram templi (siclus viginti obolos habet); media pars sicli offeretur Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Qui habetur in numero, a viginti annis et supra, dabit pretium. ");
INSERT INTO latVUC_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Dives non addet ad medium sicli, et pauper nihil minuet. ");
INSERT INTO latVUC_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Susceptamque pecuniam, quæ collata est a filiis Israël, trades in usus tabernaculi testimonii, ut sit monimentum eorum coram Domino, et propitietur animabus eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Facies et labrum æneum cum basi sua ad lavandum: ponesque illud inter tabernaculum testimonii et altare. Et missa aqua, ");
INSERT INTO latVUC_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","lavabunt in ea Aaron et filii ejus manus suas ac pedes, ");
INSERT INTO latVUC_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","quando ingressuri sunt tabernaculum testimonii, et quando accessuri sunt ad altare, ut offerant in eo thymiama Domino, ");
INSERT INTO latVUC_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ne forte moriantur; legitimum sempiternum erit ipsi, et semini ejus per successiones. ");
INSERT INTO latVUC_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Locutusque est Dominus ad Moysen, ");
INSERT INTO latVUC_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","dicens: Sume tibi aromata, primæ myrrhæ et electæ quingentos siclos, et cinnamomi medium, id est, ducentos quinquaginta siclos, calami similiter ducentos quinquaginta, ");
INSERT INTO latVUC_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","casiæ autem quingentos siclos, in pondere sanctuarii, olei de olivetis mensuram hin: ");
INSERT INTO latVUC_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","faciesque unctionis oleum sanctum, unguentum compositum opere unguentarii, ");
INSERT INTO latVUC_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","et unges ex eo tabernaculum testimonii, et arcam testamenti, ");
INSERT INTO latVUC_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mensamque cum vasis suis, et candelabrum, et utensilia ejus, altaria thymiamatis, ");
INSERT INTO latVUC_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","et holocausti, et universam supellectilem quæ ad cultum eorum pertinet. ");
INSERT INTO latVUC_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Sanctificabisque omnia, et erunt Sancta sanctorum; qui tetigerit ea, sanctificabitur. ");
INSERT INTO latVUC_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aaron et filios ejus unges, sanctificabisque eos, ut sacerdotio fungantur mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Filiis quoque Israël dices: Hoc oleum unctionis sanctum erit mihi in generationes vestras. ");
INSERT INTO latVUC_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Caro hominis non ungetur ex eo, et juxta compositionem ejus non facietis aliud, quia sanctificatum est, et sanctum erit vobis. ");
INSERT INTO latVUC_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Homo quicumque tale composuerit, et dederit ex eo alieno, exterminabitur de populo suo. ");
INSERT INTO latVUC_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Dixitque Dominus ad Moysen: Sume tibi aromata, stacten et onycha, galbanum boni odoris, et thus lucidissimum; æqualis ponderis erunt omnia: ");
INSERT INTO latVUC_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","faciesque thymiama compositum opere unguentarii, mistum diligenter, et purum, et sanctificatione dignissimum. ");
INSERT INTO latVUC_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Cumque in tenuissimum pulverem universa contuderis, pones ex eo coram tabernaculo testimonii, in quo loco apparebo tibi. Sanctum sanctorum erit vobis thymiama. ");
INSERT INTO latVUC_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Talem compositionem non facietis in usus vestros, quia sanctum est Domino. ");
INSERT INTO latVUC_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Homo quicumque fecerit simile, ut odore illius perfruatur, peribit de populis suis. ");
INSERT INTO latVUC_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Ecce, vocavi ex nomine Beseleel filium Uri filii Hur de tribu Juda, ");
INSERT INTO latVUC_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","et implevi spiritu Dei, sapientia, et intelligentia et scientia in omni opere, ");
INSERT INTO latVUC_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ad excogitandum quidquid fabrefieri potest ex auro, et argento, et ære, ");
INSERT INTO latVUC_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","marmore, et gemmis, et diversitate lignorum. ");
INSERT INTO latVUC_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Dedique ei socium Ooliab filium Achisamech de tribu Dan. Et in corde omnis eruditi posui sapientiam: ut faciant cuncta quæ præcepi tibi, ");
INSERT INTO latVUC_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","tabernaculum fœderis, et arcam testimonii, et propitiatorium, quod super eam est, et cuncta vasa tabernaculi, ");
INSERT INTO latVUC_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","mensamque et vasa ejus, candelabrum purissimum cum vasis suis, et altaris thymiamatis, ");
INSERT INTO latVUC_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","et holocausti, et omnia vasa eorum, labrum cum basi sua, ");
INSERT INTO latVUC_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","vestes sanctas in ministerio Aaron sacerdoti, et filiis ejus, ut fungantur officio suo in sacris: ");
INSERT INTO latVUC_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","oleum unctionis, et thymiama aromatum in sanctuario, omnia quæ præcepi tibi, facient. ");
INSERT INTO latVUC_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Et locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Loquere filiis Israël, et dices ad eos: Videte ut sabbatum meum custodiatis: quia signum est inter me et vos in generationibus vestris: ut sciatis quia ego Dominus, qui sanctifico vos. ");
INSERT INTO latVUC_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Custodite sabbatum meum, sanctum est enim vobis: qui polluerit illud, morte morietur; qui fecerit in eo opus, peribit anima illius de medio populi sui. ");
INSERT INTO latVUC_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sex diebus facietis opus: in die septimo sabbatum est, requies sancta Domino; omnis qui fecerit opus in hac die, morietur. ");
INSERT INTO latVUC_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Custodiant filii Israël sabbatum, et celebrent illud in generationibus suis. Pactum est sempiternum ");
INSERT INTO latVUC_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","inter me et filios Israël, signumque perpetuum; sex enim diebus fecit Dominus cælum et terram, et in septimo ab opere cessavit. ");
INSERT INTO latVUC_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Deditque Dominus Moysi, completis hujuscemodi sermonibus in monte Sinai, duas tabulas testimonii lapideas, scriptas digito Dei. ");
INSERT INTO latVUC_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Videns autem populus quod moram faceret descendendi de monte Moyses, congregatus adversus Aaron, dixit: Surge, fac nobis deos, qui nos præcedant: Moysi enim huic viro, qui nos eduxit de terra Ægypti, ignoramus quid acciderit. ");
INSERT INTO latVUC_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Dixitque ad eos Aaron: Tollite inaures aureas de uxorum, filiorumque et filiarum vestrarum auribus, et afferte ad me. ");
INSERT INTO latVUC_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Fecitque populus quæ jusserat, deferens inaures ad Aaron. ");
INSERT INTO latVUC_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Quas cum ille accepisset, formavit opere fusorio, et fecit ex eis vitulum conflatilem: dixeruntque: Hi sunt dii tui Israël, qui te eduxerunt de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Quod cum vidisset Aaron, ædificavit altare coram eo, et præconis voce clamavit dicens: Cras solemnitas Domini est. ");
INSERT INTO latVUC_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Surgentesque mane, obtulerunt holocausta, et hostias pacificas, et sedit populus manducare, et bibere, et surrexerunt ludere. ");
INSERT INTO latVUC_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Locutus est autem Dominus ad Moysen, dicens: Vade, descende: peccavit populus tuus, quem eduxisti de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Recesserunt cito de via, quam ostendisti eis: feceruntque sibi vitulum conflatilem, et adoraverunt, atque immolantes ei hostias, dixerunt: Isti sunt dii tui Israël, qui te eduxerunt de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Rursumque ait Dominus ad Moysen: Cerno quod populus iste duræ cervicis sit: ");
INSERT INTO latVUC_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","dimitte me, ut irascatur furor meus contra eos, et deleam eos, faciamque te in gentem magnam. ");
INSERT INTO latVUC_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moyses autem orabat Dominum Deum suum, dicens: Cur, Domine, irascitur furor tuus contra populum tuum, quem eduxisti de terra Ægypti, in fortitudine magna, et in manu robusta? ");
INSERT INTO latVUC_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ne quæso dicant Ægyptii: Callide eduxit eos, ut interficeret in montibus, et deleret e terra: quiescat ira tua, et esto placabilis super nequitia populi tui. ");
INSERT INTO latVUC_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Recordare Abraham, Isaac, et Israël servorum tuorum, quibus jurasti per temetipsum, dicens: Multiplicabo semen vestrum sicut stellas cæli; et universam terram hanc, de qua locutus sum, dabo semini vestro, et possidebitis eam semper. ");
INSERT INTO latVUC_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Placatusque est Dominus ne faceret malum quod locutus fuerat adversus populum suum. ");
INSERT INTO latVUC_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Et reversus est Moyses de monte, portans duas tabulas testimonii in manu sua, scriptas ex utraque parte, ");
INSERT INTO latVUC_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","et factas opere Dei: scriptura quoque Dei erat sculpta in tabulis. ");
INSERT INTO latVUC_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Audiens autem Josue tumultum populi vociferantis, dixit ad Moysen: Ululatus pugnæ auditur in castris. ");
INSERT INTO latVUC_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Qui respondit: Non est clamor adhortantium ad pugnam, neque vociferatio compellentium ad fugam: sed vocem cantantium ego audio. ");
INSERT INTO latVUC_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Cumque appropinquasset ad castra, vidit vitulum, et choros: iratusque valde, projecit de manu tabulas, et confregit eas ad radicem montis: ");
INSERT INTO latVUC_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","arripiensque vitulum quem fecerant, combussit, et contrivit usque ad pulverem, quem sparsit in aquam, et dedit ex eo potum filiis Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Dixitque ad Aaron: Quid tibi fecit hic populus, ut induceres super eum peccatum maximum? ");
INSERT INTO latVUC_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Cui ille respondit: Ne indignetur dominus meus: tu enim nosti populum istum, quod pronus sit ad malum: ");
INSERT INTO latVUC_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","dixerunt mihi: Fac nobis deos, qui nos præcedant: huic enim Moysi, qui nos eduxit de terra Ægypti, nescimus quid acciderit. ");
INSERT INTO latVUC_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Quibus ego dixi: Quis vestrum habet aurum? Tulerunt, et dederunt mihi: et projeci illud in ignem, egressusque est hic vitulus. ");
INSERT INTO latVUC_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Videns ergo Moyses populum quod esset nudatus (spoliaverat enim eum Aaron propter ignominiam sordis, et inter hostes nudum constituerat), ");
INSERT INTO latVUC_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","et stans in porta castrorum, ait: Si quis est Domini, jungatur mihi. Congregatique sunt ad eum omnes filii Levi: ");
INSERT INTO latVUC_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","quibus ait: Hæc dicit Dominus Deus Israël: Ponat vir gladium super femur suum: ite, et redite de porta usque ad portam per medium castrorum, et occidat unusquisque fratrem, et amicum, et proximum suum. ");
INSERT INTO latVUC_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Feceruntque filii Levi juxta sermonem Moysi, cecideruntque in die illa quasi viginti tria millia hominum. ");
INSERT INTO latVUC_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Et ait Moyses: Consecrastis manus vestras hodie Domino, unusquisque in filio, et in fratre suo, ut detur vobis benedictio. ");
INSERT INTO latVUC_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Facto autem altero die, locutus est Moyses ad populum: Peccastis peccatum maximum: ascendam ad Dominum, si quomodo quivero eum deprecari pro scelere vestro. ");
INSERT INTO latVUC_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Reversusque ad Dominum, ait: Obsecro, peccavit populus iste peccatum maximum, feceruntque sibi deos aureos: aut dimitte eis hanc noxam, ");
INSERT INTO latVUC_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","aut si non facis, dele me de libro tuo quem scripsisti. ");
INSERT INTO latVUC_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Cui respondit Dominus: Qui peccaverit mihi, delebo eum de libro meo: ");
INSERT INTO latVUC_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","tu autem vade, et duc populum istum quo locutus sum tibi: angelus meus præcedet te. Ego autem in die ultionis visitabo et hoc peccatum eorum. ");
INSERT INTO latVUC_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Percussit ergo Dominus populum pro reatu vituli, quem fecerat Aaron. ");
INSERT INTO latVUC_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Locutusque est Dominus ad Moysen, dicens: Vade, ascende de loco isto tu, et populus tuus quem eduxisti de terra Ægypti, in terram quam juravi Abraham, Isaac et Jacob, dicens: Semini tuo dabo eam: ");
INSERT INTO latVUC_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","et mittam præcursorem tui angelum, ut ejiciam Chananæum, et Amorrhæum, et Hethæum, et Pherezæum, et Hevæum, et Jebusæum, ");
INSERT INTO latVUC_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","et intres in terram fluentem lacte et melle. Non enim ascendam tecum, quia populus duræ cervicis es: ne forte disperdam te in via. ");
INSERT INTO latVUC_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Audiensque populus sermonem hunc pessimum, luxit: et nullus ex more indutus est cultu suo. ");
INSERT INTO latVUC_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Dixitque Dominus ad Moysen: Loquere filiis Israël: Populus duræ cervicis es: semel ascendam in medio tui, et delebo te. Jam nunc depone ornatum tuum, ut sciam quid faciam tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Deposuerunt ergo filii Israël ornatum suum a monte Horeb. ");
INSERT INTO latVUC_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moyses quoque tollens tabernaculum, tetendit extra castra procul, vocavitque nomen ejus, Tabernaculum fœderis. Et omnis populus, qui habebat aliquam quæstionem, egrediebatur ad tabernaculum fœderis, extra castra. ");
INSERT INTO latVUC_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Cumque egrederetur Moyses ad tabernaculum, surgebat universa plebs, et stabat unusquisque in ostio papilionis sui, aspiciebantque tergum Moysi, donec ingrederetur tentorium. ");
INSERT INTO latVUC_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ingresso autem illo tabernaculum fœderis, descendebat columna nubis, et stabat ad ostium, loquebaturque cum Moyse, ");
INSERT INTO latVUC_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","cernentibus universis quod columna nubis staret ad ostium tabernaculi. Stabantque ipsi, et adorabant per fores tabernaculorum suorum. ");
INSERT INTO latVUC_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Loquebatur autem Dominus ad Moysen facie ad faciem, sicut solet loqui homo ad amicum suum. Cumque ille reverteretur in castra, minister ejus Josue filius Nun, puer, non recedebat de tabernaculo. ");
INSERT INTO latVUC_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Dixit autem Moyses ad Dominum: Præcipis ut educam populum istum: et non indicas mihi quem missurus es mecum, præsertim cum dixeris: Novi te ex nomine, et invenisti gratiam coram me. ");
INSERT INTO latVUC_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Si ergo inveni gratiam in conspectu tuo, ostende mihi faciem tuam, ut sciam te, et inveniam gratiam ante oculos tuos: respice populum tuum gentem hanc. ");
INSERT INTO latVUC_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Dixitque Dominus: Facies mea præcedet te, et requiem dabo tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Et ait Moyses: Si non tu ipse præcedas, ne educas nos de loco isto. ");
INSERT INTO latVUC_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","In quo enim scire poterimus ego et populus tuus invenisse nos gratiam in conspectu tuo, nisi ambulaveris nobiscum, ut glorificemur ab omnibus populis qui habitant super terram? ");
INSERT INTO latVUC_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Dixit autem Dominus ad Moysen: Et verbum istud, quod locutus es, faciam: invenisti enim gratiam coram me, et teipsum novi ex nomine. ");
INSERT INTO latVUC_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Qui ait: Ostende mihi gloriam tuam. ");
INSERT INTO latVUC_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Respondit: Ego ostendam omne bonum tibi, et vocabo in nomine Domini coram te: et miserebor cui voluero, et clemens ero in quem mihi placuerit. ");
INSERT INTO latVUC_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Rursumque ait: Non poteris videre faciem meam: non enim videbit me homo et vivet. ");
INSERT INTO latVUC_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Et iterum: Ecce, inquit, est locus apud me, et stabis supra petram. ");
INSERT INTO latVUC_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Cumque transibit gloria mea, ponam te in foramine petræ, et protegam dextera mea, donec transeam: ");
INSERT INTO latVUC_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","tollamque manum meam, et videbis posteriora mea: faciem autem meam videre non poteris. ");
INSERT INTO latVUC_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ac deinceps: Præcide, ait, tibi duas tabulas lapideas instar priorum, et scribam super eas verba, quæ habuerunt tabulæ quas fregisti. ");
INSERT INTO latVUC_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Esto paratus mane, ut ascendas statim in montem Sinai, stabisque mecum super verticem montis. ");
INSERT INTO latVUC_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nullus ascendat tecum, nec videatur quispiam per totum montem: boves quoque et oves non pascantur e contra. ");
INSERT INTO latVUC_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Excidit ergo duas tabulas lapideas, quales antea fuerant: et de nocte consurgens ascendit in montem Sinai, sicut præceperat ei Dominus, portans secum tabulas. ");
INSERT INTO latVUC_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Cumque descendisset Dominus per nubem, stetit Moyses cum eo, invocans nomen Domini. ");
INSERT INTO latVUC_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Quo transeunte coram eo, ait: Dominator Domine Deus, misericors et clemens, patiens et multæ miserationis, ac verax, ");
INSERT INTO latVUC_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","qui custodis misericordiam in millia; qui aufers iniquitatem, et scelera, atque peccata, nullusque apud te per se innocens est; qui reddis iniquitatem patrum filiis, ac nepotibus in tertiam et quartam progeniem. ");
INSERT INTO latVUC_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Festinusque Moyses, curvatus est pronus in terram, et adorans ");
INSERT INTO latVUC_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ait: Si inveni gratiam in conspectu tuo, Domine, obsecro ut gradiaris nobiscum (populus enim duræ cervicis est) et auferas iniquitates nostras atque peccata, nosque possideas. ");
INSERT INTO latVUC_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Respondit Dominus: Ego inibo pactum videntibus cunctis: signa faciam quæ numquam visa sunt super terram, nec in ullis gentibus, ut cernat populus iste, in cujus es medio, opus Domini terribile quod facturus sum. ");
INSERT INTO latVUC_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Observa cuncta quæ hodie mando tibi: ego ipse ejiciam ante faciem tuam Amorrhæum, et Chananæum, et Hethæum, Pherezæum quoque, et Hevæum, et Jebusæum. ");
INSERT INTO latVUC_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Cave ne umquam cum habitatoribus terræ illius jungas amicitias, quæ sint tibi in ruinam: ");
INSERT INTO latVUC_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","sed aras eorum destrue, confringe statuas, lucosque succide: ");
INSERT INTO latVUC_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","noli adorare deum alienum. Dominus zelotes nomen ejus; Deus est æmulator. ");
INSERT INTO latVUC_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ne ineas pactum cum hominibus illarum regionum: ne, cum fornicati fuerint cum diis suis, et adoraverint simulacra eorum, vocet te quispiam ut comedas de immolatis. ");
INSERT INTO latVUC_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Nec uxorem de filiabus eorum accipies filiis tuis: ne, postquam ipsæ fuerint fornicatæ, fornicari faciant et filios tuos in deos suos. ");
INSERT INTO latVUC_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Deos conflatiles non facies tibi. ");
INSERT INTO latVUC_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Solemnitatem azymorum custodies. Septem diebus vesceris azymis, sicut præcepi tibi, in tempore mensis novorum: mense enim verni temporis egressus es de Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Omne quod aperit vulvam generis masculini, meum erit. De cunctis animantibus, tam de bobus, quam de ovibus, meum erit. ");
INSERT INTO latVUC_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Primogenitum asini redimes ove: sin autem nec pretium pro eo dederis, occidetur. Primogenitum filiorum tuorum redimes: nec apparebis in conspectu meo vacuus. ");
INSERT INTO latVUC_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sex diebus operaberis; die septimo cessabis arare et metere. ");
INSERT INTO latVUC_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Solemnitatem hebdomadarum facies tibi in primitiis frugum messis tuæ triticeæ, et solemnitatem, quando redeunte anni tempore cuncta conduntur. ");
INSERT INTO latVUC_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tribus temporibus anni apparebit omne masculinum tuum in conspectu omnipotentis Domini Dei Israël. ");
INSERT INTO latVUC_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Cum enim tulero gentes a facie tua, et dilatavero terminos tuos, nullus insidiabitur terræ tuæ, ascendente te, et apparente in conspectu Domini Dei tui ter in anno. ");
INSERT INTO latVUC_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Non immolabis super fermento sanguinem hostiæ meæ: neque residebit mane de victima solemnitatis Phase. ");
INSERT INTO latVUC_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Primitias frugum terræ tuæ offeres in domo Domini Dei tui. Non coques hædum in lacte matris suæ. ");
INSERT INTO latVUC_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Dixitque Dominus ad Moysen: Scribe tibi verba hæc, quibus et tecum et cum Israël pepigi fœdus. ");
INSERT INTO latVUC_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Fuit ergo ibi cum Domino quadraginta dies et quadraginta noctes: panem non comedit, et aquam non bibit, et scripsit in tabulis verba fœderis decem. ");
INSERT INTO latVUC_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Cumque descenderet Moyses de monte Sinai, tenebat duas tabulas testimonii, et ignorabat quod cornuta esset facies sua ex consortio sermonis Domini. ");
INSERT INTO latVUC_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Videntes autem Aaron et filii Israël cornutam Moysi faciem, timuerunt prope accedere. ");
INSERT INTO latVUC_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Vocatique ab eo, reversi sunt tam Aaron, quam principes synagogæ. Et postquam locutus est ad eos, ");
INSERT INTO latVUC_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","venerunt ad eum etiam omnes filii Israël: quibus præcepit cuncta quæ audierat a Domino in monte Sinai. ");
INSERT INTO latVUC_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Impletisque sermonibus, posuit velamen super faciem suam. ");
INSERT INTO latVUC_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Quod ingressus ad Dominum, et loquens cum eo, auferebat donec exiret, et tunc loquebatur ad filios Israël omnia quæ sibi fuerant imperata. ");
INSERT INTO latVUC_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Qui videbant faciem egredientis Moysi esse cornutam, sed operiebat ille rursus faciem suam, siquando loquebatur ad eos. ");
INSERT INTO latVUC_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Igitur congregata omni turba filiorum Israël, dixit ad eos: Hæc sunt quæ jussit Dominus fieri. ");
INSERT INTO latVUC_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sex diebus facietis opus: septimus dies erit vobis sanctus, sabbatum, et requies Domini: qui fecerit opus in eo, occidetur. ");
INSERT INTO latVUC_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Non succendetis ignem in omnibus habitaculis vestris per diem sabbati. ");
INSERT INTO latVUC_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Et ait Moyses ad omnem catervam filiorum Israël: Iste est sermo quem præcepit Dominus, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Separate apud vos primitias Domino. Omnis voluntarius et prono animo offerat eas Domino: aurum et argentum, et æs, ");
INSERT INTO latVUC_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","hyacinthum et purpuram, coccumque bis tinctum, et byssum, pilos caprarum, ");
INSERT INTO latVUC_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","pellesque arietum rubricatas, et janthinas, ligna setim, ");
INSERT INTO latVUC_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","et oleum ad luminaria concinnanda, et ut conficiatur unguentum, et thymiama suavissimum, ");
INSERT INTO latVUC_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","lapides onychinos, et gemmas ad ornatum superhumeralis et rationalis. ");
INSERT INTO latVUC_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Quisque vestrum sapiens est, veniat, et faciat quod Dominus imperavit: ");
INSERT INTO latVUC_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","tabernaculum scilicet, et tectum ejus, atque operimentum, annulos, et tabulata cum vectibus, paxillos, et bases: ");
INSERT INTO latVUC_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","arcam et vectes, propitiatorium, et velum, quod ante illud oppanditur: ");
INSERT INTO latVUC_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","mensam cum vectibus et vasis, et propositionis panibus: ");
INSERT INTO latVUC_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","candelabrum ad luminaria sustentanda, vasa illius et lucernas, et oleum ad nutrimenta ignium: ");
INSERT INTO latVUC_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","altare thymiamatis, et vectes, et oleum unctionis et thymiama ex aromatibus: tentorium ad ostium tabernaculi: ");
INSERT INTO latVUC_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","altare holocausti, et craticulam ejus æneam cum vectibus et vasis suis: labrum et basim ejus: ");
INSERT INTO latVUC_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","cortinas atrii cum columnis et basibus, tentorium in foribus vestibuli, ");
INSERT INTO latVUC_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","paxillos tabernaculi et atrii cum funiculis suis: ");
INSERT INTO latVUC_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","vestimenta, quorum usus est in ministerio sanctuarii, vestes Aaron pontificis ac filiorum ejus, ut sacerdotio fungantur mihi. ");
INSERT INTO latVUC_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Egressaque omnis multitudo filiorum Israël de conspectu Moysi, ");
INSERT INTO latVUC_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","obtulerunt mente promptissima atque devota primitias Domino, ad faciendum opus tabernaculi testimonii. Quidquid ad cultum et ad vestes sanctas necessarium erat, ");
INSERT INTO latVUC_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","viri cum mulieribus præbuerunt, armillas et inaures, annulos et dextralia: omne vas aureum in donaria Domini separatum est. ");
INSERT INTO latVUC_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Si quis habebat hyacinthum, et purpuram, coccumque bis tinctum, byssum et pilos caprarum, pelles arietum rubricatas, et janthinas, ");
INSERT INTO latVUC_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","argenti, ærisque metalla, obtulerunt Domino, lignaque setim in varios usus. ");
INSERT INTO latVUC_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Sed et mulieres doctæ, quæ neverant, dederunt hyacinthum, purpuram, et vermiculum, ac byssum, ");
INSERT INTO latVUC_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","et pilos caprarum, sponte propria cuncta tribuentes. ");
INSERT INTO latVUC_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Principes vero obtulerunt lapides onychinos, et gemmas ad superhumerale et rationale, ");
INSERT INTO latVUC_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","aromataque et oleum ad luminaria concinnanda, et ad præparandum unguentum, ac thymiama odoris suavissimi componendum. ");
INSERT INTO latVUC_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Omnes viri et mulieres mente devota obtulerunt donaria, ut fierent opera, quæ jusserat Dominus per manum Moysi. Cuncti filii Israël voluntaria Domino dedicaverunt. ");
INSERT INTO latVUC_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Dixitque Moyses ad filios Israël: Ecce, vocavit Dominus ex nomine Beseleel filium Uri, filii Hur de tribu Juda, ");
INSERT INTO latVUC_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","implevitque eum spiritu Dei, sapientia et intelligentia, et scientia et omni doctrina, ");
INSERT INTO latVUC_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ad excogitandum, et faciendum opus in auro, et argento, et ære, ");
INSERT INTO latVUC_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","sculpendisque lapidibus, et opere carpentario, quidquid fabre adinveniri potest, ");
INSERT INTO latVUC_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","dedit in corde ejus: Ooliab quoque filium Achisamech de tribu Dan: ");
INSERT INTO latVUC_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ambos erudivit sapientia, ut faciant opera abietarii, polymitarii, ac plumarii, de hyacintho ac purpura, coccoque bis tincto, et bysso, et texant omnia, ac nova quæque reperiant. ");
INSERT INTO latVUC_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Fecit ergo Beseleel, et Ooliab, et omnis vir sapiens, quibus dedit Dominus sapientiam et intellectum, ut scirent fabre operari quæ in usus sanctuarii necessaria sunt, et quæ præcepit Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Cumque vocasset eos Moyses et omnem eruditum virum, cui dederat Dominus sapientiam, et qui sponte sua obtulerant se ad faciendum opus, ");
INSERT INTO latVUC_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","tradidit eis universa donaria filiorum Israël. Qui cum instarent operi, quotidie mane vota populus offerebat. ");
INSERT INTO latVUC_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Unde artifices venire compulsi, ");
INSERT INTO latVUC_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","dixerunt Moysi: Plus offert populus quam necessarium est. ");
INSERT INTO latVUC_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Jussit ergo Moyses præconis voce cantari: Nec vir, nec mulier quidquam offerat ultra in opere sanctuarii. Sicque cessatum est a muneribus offerendis, ");
INSERT INTO latVUC_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","eo quod oblata sufficerent et superabundarent. ");
INSERT INTO latVUC_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Feceruntque omnes corde sapientes ad explendum opus tabernaculi, cortinas decem de bysso retorta, et hyacintho, et purpura, coccoque bis tincto, opere vario, et arte polymita: ");
INSERT INTO latVUC_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","quarum una habebat in longitudine viginti octo cubitos, et in latitudine quatuor; una mensura erat omnium cortinarum. ");
INSERT INTO latVUC_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Conjunxitque cortinas quinque, alteram alteri, et alias quinque sibi invicem copulavit. ");
INSERT INTO latVUC_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Fecit et ansas hyacinthinas in ora cortinæ unius ex utroque latere, et in ora cortinæ alterius similiter, ");
INSERT INTO latVUC_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ut contra se invicem venirent ansæ, et mutuo jungerentur. ");
INSERT INTO latVUC_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Unde et quinquaginta fudit circulos aureos, qui morderent cortinarum ansas, et fieret unum tabernaculum. ");
INSERT INTO latVUC_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Fecit et saga undecim de pilis caprarum ad operiendum tectum tabernaculi: ");
INSERT INTO latVUC_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","unum sagum in longitudine habebat cubitos triginta, et in latitudine cubitos quatuor: unius mensuræ erant omnia saga: ");
INSERT INTO latVUC_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","quorum quinque junxit seorsum, et sex alia separatim. ");
INSERT INTO latVUC_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Fecitque ansas quinquaginta in ora sagi unius, et quinquaginta in ora sagi alterius, ut sibi invicem jungerentur. ");
INSERT INTO latVUC_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Et fibulas æneas quinquaginta, quibus necteretur tectum, ut unum pallium ex omnibus sagis fieret. ");
INSERT INTO latVUC_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Fecit et opertorium tabernaculi de pellibus arietum rubricatis: aliudque desuper velamentum de pellibus janthinis. ");
INSERT INTO latVUC_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Fecit et tabulas tabernaculi de lignis setim stantes. ");
INSERT INTO latVUC_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Decem cubitorum erat longitudo tabulæ unius: et unum ac semis cubitum latitudo retinebat. ");
INSERT INTO latVUC_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Binæ incastraturæ erant per singulas tabulas, ut altera alteri jungeretur. Sic fecit in omnibus tabernaculi tabulis. ");
INSERT INTO latVUC_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","E quibus viginti ad plagam meridianam erant contra austrum, ");
INSERT INTO latVUC_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","cum quadraginta basibus argenteis. Duæ bases sub una tabula ponebantur ex utraque parte angulorum, ubi incastraturæ laterum in angulis terminantur. ");
INSERT INTO latVUC_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ad plagam quoque tabernaculi, quæ respicit ad aquilonem, fecit viginti tabulas, ");
INSERT INTO latVUC_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","cum quadraginta basibus argenteis, duas bases per singulas tabulas. ");
INSERT INTO latVUC_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Contra occidentem vero, id est, ad eam partem tabernaculi quæ mare respicit, fecit sex tabulas, ");
INSERT INTO latVUC_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","et duas alias per singulos angulos tabernaculi retro: ");
INSERT INTO latVUC_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","quæ junctæ erant a deorsum usque sursum, et in unam compaginem pariter ferebantur. Ita fecit ex utraque parte per angulos: ");
INSERT INTO latVUC_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ut octo essent simul tabulæ, et haberent bases argenteas sedecim, binas scilicet bases sub singulis tabulis. ");
INSERT INTO latVUC_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Fecit et vectes de lignis setim, quinque ad continendas tabulas unius lateris tabernaculi, ");
INSERT INTO latVUC_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","et quinque alios ad alterius lateris coaptandas tabulas: et extra hos, quinque alios vectes ad occidentalem plagam tabernaculi contra mare. ");
INSERT INTO latVUC_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Fecit quoque vectem alium, qui per medias tabulas ab angulo usque ad angulum perveniret. ");
INSERT INTO latVUC_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ipsa autem tabulata deauravit, fusis basibus earum argenteis. Et circulos eorum fecit aureos, per quos vectes induci possent: quos et ipsos laminis aureis operuit. ");
INSERT INTO latVUC_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Fecit et velum de hyacintho, et purpura, vermiculo, ac bysso retorta, opere polymitario, varium atque distinctum: ");
INSERT INTO latVUC_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","et quatuor columnas de lignis setim, quas cum capitibus deauravit, fusis basibus earum argenteis. ");
INSERT INTO latVUC_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Fecit et tentorium in introitu tabernaculi ex hyacintho, purpura, vermiculo, byssoque retorta, opere plumarii: ");
INSERT INTO latVUC_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","et columnas quinque cum capitibus suis, quas operuit auro, basesque earum fudit æneas. ");
INSERT INTO latVUC_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Fecit autem Beseleel et arcam de lignis setim, habentem duos semis cubitos in longitudine, et cubitum ac semissem in latitudine, altitudo quoque unius cubiti fuit et dimidii: vestivitque eam auro purissimo intus ac foris. ");
INSERT INTO latVUC_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Et fecit illi coronam auream per gyrum, ");
INSERT INTO latVUC_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","conflans quatuor annulos aureos per quatuor angulos ejus: duos annulos in latere uno, et duos in altero. ");
INSERT INTO latVUC_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Vectes quoque fecit de lignis setim, quos vestivit auro, ");
INSERT INTO latVUC_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","et quos misit in annulos, qui erant in lateribus arcæ ad portandum eam. ");
INSERT INTO latVUC_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Fecit et propitiatorium, id est, oraculum, de auro mundissimo, duorum cubitorum et dimidii in longitudine, et cubiti ac semis in latitudine. ");
INSERT INTO latVUC_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Duos etiam cherubim ex auro ductili, quos posuit ex utraque parte propitiatorii: ");
INSERT INTO latVUC_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","cherub unum in summitate unius partis, et cherub alterum in summitate partis alterius: duos cherubim in singulis summitatibus propitiatorii, ");
INSERT INTO latVUC_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","extendentes alas, et tegentes propitiatorium, seque mutuo et illud respicientes. ");
INSERT INTO latVUC_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Fecit et mensam de lignis setim in longitudine duorum cubitorum, et in latitudine unius cubiti, quæ habebat in altitudine cubitum ac semissem. ");
INSERT INTO latVUC_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Circumdeditque eam auro mundissimo, et fecit illi labium aureum per gyrum, ");
INSERT INTO latVUC_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ipsique labio coronam auream interrasilem quatuor digitorum, et super eamdem, alteram coronam auream. ");
INSERT INTO latVUC_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Fudit et quatuor circulos aureos, quos posuit in quatuor angulis per singulos pedes mensæ ");
INSERT INTO latVUC_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","contra coronam: misitque in eos vectes, ut possit mensa portari. ");
INSERT INTO latVUC_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ipsos quoque vectes fecit de lignis setim, et circumdedit eos auro. ");
INSERT INTO latVUC_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Et vasa ad diversos usus mensæ, acetabula, phialas, et cyathos, et thuribula, ex auro puro, in quibus offerenda sunt libamina. ");
INSERT INTO latVUC_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Fecit et candelabrum ductile de auro mundissimo, de cujus vecte calami, scyphi, sphærulæque, ac lilia procedebant: ");
INSERT INTO latVUC_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","sex in utroque latere, tres calami ex parte una, et tres ex altera: ");
INSERT INTO latVUC_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","tres scyphi in nucis modum per calamos singulos, sphærulæque simul et lilia: et tres scyphi instar nucis in calamo altero, sphærulæque simul et lilia. Æquum erat opus sex calamorum, qui procedebant de stipite candelabri. ");
INSERT INTO latVUC_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","In ipso autem vecte erant quatuor scyphi in nucis modum, sphærulæque per singulos simul et lilia: ");
INSERT INTO latVUC_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","et sphærulæ sub duobus calamis per loca tria, qui simul sex fiunt calami procedentes de vecte uno. ");
INSERT INTO latVUC_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Et sphærulæ igitur, et calami ex ipso erant, universa ductilia ex auro purissimo. ");
INSERT INTO latVUC_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Fecit et lucernas septem cum emunctoriis suis, et vasa ubi ea, quæ emuncta sunt, extinguantur, de auro mundissimo. ");
INSERT INTO latVUC_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Talentum auri appendebat candelabrum cum omnibus vasis suis. ");
INSERT INTO latVUC_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Fecit et altare thymiamatis de lignis setim, per quadrum singulos habens cubitos, et in altitudine duos: e cujus angulis procedebant cornua. ");
INSERT INTO latVUC_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Vestivitque illud auro purissimo cum craticula ac parietibus et cornibus. ");
INSERT INTO latVUC_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Fecitque ei coronam aureolam per gyrum, et duos annulos aureos sub corona per singula latera, ut mittantur in eos vectes, et possit altare portari. ");
INSERT INTO latVUC_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ipsos autem vectes fecit de lignis setim, et operuit laminis aureis. ");
INSERT INTO latVUC_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Composuit et oleum ad sanctificationis unguentum, et thymiama de aromatibus mundissimis opere pigmentarii. ");
INSERT INTO latVUC_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Fecit et altare holocausti de lignis setim, quinque cubitorum per quadrum, et trium in altitudine: ");
INSERT INTO latVUC_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","cujus cornua de angulis procedebant, operuitque illum laminis æneis. ");
INSERT INTO latVUC_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Et in usus ejus paravit ex ære vasa diversa, lebetes, forcipes, fuscinulas, uncinos, et ignium receptacula. ");
INSERT INTO latVUC_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Craticulamque ejus in modum retis fecit æneam, et subter eam in altaris medio arulam, ");
INSERT INTO latVUC_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","fusis quatuor annulis per totidem retiaculi summitates, ad immittendos vectes ad portandum: ");
INSERT INTO latVUC_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","quos et ipsos fecit de lignis setim, et operuit laminis æneis: ");
INSERT INTO latVUC_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","induxitque in circulos, qui in lateribus altaris eminebant. Ipsum autem altare non erat solidum, sed cavum ex tabulis, et intus vacuum. ");
INSERT INTO latVUC_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Fecit et labrum æneum cum basi sua de speculis mulierum, quæ excubabant in ostio tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Fecit et atrium, in cujus australi plaga erant tentoria de bysso retorta, cubitorum centum, ");
INSERT INTO latVUC_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","columnæ æneæ viginti cum basibus suis, capita columnarum, et tota operis cælatura, argentea. ");
INSERT INTO latVUC_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Æque ad septentrionalem plagam tentoria columnæ, basesque et capita columnarum ejusdem mensuræ, et operis ac metalli, erant. ");
INSERT INTO latVUC_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","In ea vero plaga, quæ ad occidentem respicit, fuerunt tentoria cubitorum quinquaginta, columnæ decem cum basibus suis æneæ, et capita columnarum, et tota operis cælatura, argentea. ");
INSERT INTO latVUC_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Porro contra orientem quinquaginta cubitorum paravit tentoria: ");
INSERT INTO latVUC_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","e quibus, quindecim cubitos columnarum trium, cum basibus suis, unum tenebat latus: ");
INSERT INTO latVUC_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","et in parte altera (quia inter utraque introitum tabernaculi fecit) quindecim æque cubitorum erant tentoria, columnæque tres, et bases totidem. ");
INSERT INTO latVUC_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Cuncta atrii tentoria byssus retorta texuerat. ");
INSERT INTO latVUC_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Bases columnarum fuere æneæ, capita autem earum cum cunctis cælaturis suis argentea: sed et ipsas columnas atrii vestivit argento. ");
INSERT INTO latVUC_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Et in introitu ejus opere plumario fecit tentorium ex hyacintho, purpura, vermiculo, ac bysso retorta, quod habebat viginti cubitos in longitudine, altitudo vero quinque cubitorum erat juxta mensuram, quam cuncta atrii tentoria habebant. ");
INSERT INTO latVUC_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Columnæ autem in ingressu fuere quatuor cum basibus æneis, capitaque earum et cælaturæ argenteæ. ");
INSERT INTO latVUC_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Paxillos quoque tabernaculi et atrii per gyrum fecit æneos. ");
INSERT INTO latVUC_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hæc sunt instrumenta tabernaculi testimonii, quæ enumerata sunt juxta præceptum Moysi in cæremoniis Levitarum per manum Ithamar filii Aaron sacerdotis: ");
INSERT INTO latVUC_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","quæ Beseleel filius Uri filii Hur de tribu Juda, Domino per Moysen jubente, compleverat, ");
INSERT INTO latVUC_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","juncto sibi socio Ooliab filio Achisamech de tribu Dan: qui et ipse artifex lignorum egregius fuit, et polymitarius atque plumarius ex hyacintho, purpura, vermiculo et bysso. ");
INSERT INTO latVUC_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Omne aurum quod expensum est in opere sanctuarii, et quod oblatum est in donariis, viginti novem talentorum fuit, et septingentorum triginta siclorum ad mensuram sanctuarii. ");
INSERT INTO latVUC_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Oblatum est autem ab his qui transierunt ad numerum a viginti annis et supra, de sexcentis tribus millibus et quingentis quinquaginta armatorum. ");
INSERT INTO latVUC_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Fuerunt præterea centum talenta argenti e quibus conflatæ sunt bases sanctuarii, et introitus, ubi velum pendet. ");
INSERT INTO latVUC_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Centum bases factæ sunt de talentis centum, singulis talentis per bases singulas supputatis. ");
INSERT INTO latVUC_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","De mille autem septingentis et septuaginta quinque, fecit capita columnarum, quas et ipsas vestivit argento. ");
INSERT INTO latVUC_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Æris quoque oblata sunt talenta septuaginta duo millia, et quadringenti supra sicli, ");
INSERT INTO latVUC_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ex quibus fusæ sunt bases in introitu tabernaculi testimonii, et altare æneum cum craticula sua, omniaque vasa quæ ad usum ejus pertinent, ");
INSERT INTO latVUC_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","et bases atrii tam in circuitu quam in ingressu ejus, et paxilli tabernaculi atque atrii per gyrum. ");
INSERT INTO latVUC_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","De hyacintho vero et purpura, vermiculo ac bysso, fecit vestes, quibus indueretur Aaron quando ministrabat in sanctis, sicut præcepit Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Fecit igitur superhumerale de auro, hyacintho, et purpura, coccoque bis tincto, et bysso retorta, ");
INSERT INTO latVUC_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","opere polymitario: inciditque bracteas aureas, et extenuavit in fila, ut possent torqueri cum priorum colorum subtegmine, ");
INSERT INTO latVUC_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","duasque oras sibi invicem copulatas in utroque latere summitatum, ");
INSERT INTO latVUC_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","et balteum ex eisdem coloribus, sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Paravit et duos lapides onychinos, astrictos et inclusos auro, et sculptos arte gemmaria nominibus filiorum Israël: ");
INSERT INTO latVUC_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","posuitque eos in lateribus superhumeralis in monimentum filiorum Israël, sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Fecit et rationale opere polymito juxta opus superhumeralis, ex auro, hyacintho, purpura, coccoque bis tincto, et bysso retorta: ");
INSERT INTO latVUC_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","quadrangulum, duplex, mensuræ palmi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Et posuit in eo gemmarum ordines quatuor. In primo versu erat sardius, topazius, smaragdus. ");
INSERT INTO latVUC_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","In secundo, carbunculus, sapphirus, et jaspis. ");
INSERT INTO latVUC_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","In tertio, ligurius, achates, et amethystus. ");
INSERT INTO latVUC_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","In quarto, chrysolithus, onychinus, et beryllus, circumdati et inclusi auro per ordines suos. ");
INSERT INTO latVUC_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ipsique lapides duodecim sculpti erant nominibus duodecim tribuum Israël, singuli per nomina singulorum. ");
INSERT INTO latVUC_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Fecerunt in rationali et catenulas sibi invicem cohærentes, de auro purissimo: ");
INSERT INTO latVUC_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","et duos uncinos, totidemque annulos aureos. Porro annulos posuerunt in utroque latere rationalis, ");
INSERT INTO latVUC_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","e quibus penderent duæ catenæ aureæ, quas inseruerunt uncinis, qui in superhumeralis angulis eminebant. ");
INSERT INTO latVUC_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Hæc et ante et retro ita conveniebant sibi, ut superhumerale et rationale mutuo necterentur, ");
INSERT INTO latVUC_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","stricta ad balteum et annulis fortius copulata, quos jungebat vitta hyacinthina, ne laxa fluerent, et a se invicem moverentur, sicut præcepit Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Feceruntque quoque tunicam superhumeralis totam hyacinthinam, ");
INSERT INTO latVUC_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","et capitium in superiori parte contra medium, oramque per gyrum capitii textilem: ");
INSERT INTO latVUC_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","deorsum autem ad pedes mala punica ex hyacintho, purpura, vermiculo, ac bysso retorta: ");
INSERT INTO latVUC_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","et tintinnabula de auro purissimo, quæ posuerunt inter malogranata, in extrema parte tunicæ per gyrum: ");
INSERT INTO latVUC_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","tintinnabulum autem aureum, et malum punicum, quibus ornatus incedebat pontifex quando ministerio fungebatur, sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Fecerunt et tunicas byssinas opere textili Aaron et filiis ejus: ");
INSERT INTO latVUC_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","et mitras cum coronulis suis ex bysso: ");
INSERT INTO latVUC_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","feminalia quoque linea, byssina: ");
INSERT INTO latVUC_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","cingulum vero de bysso retorta, hyacintho, purpura, ac vermiculo bis tincto, arte plumaria, sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Fecerunt et laminam sacræ venerationis de auro purissimo, scripseruntque in ea opere gemmario, Sanctum Domini: ");
INSERT INTO latVUC_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","et strinxerunt eam cum mitra vitta hyacinthina, sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Perfectum est igitur omne opus tabernaculi et tecti testimonii: feceruntque filii Israël cuncta quæ præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Et obtulerunt tabernaculum et tectum et universam supellectilem, annulos, tabulas, vectes, columnas ac bases, ");
INSERT INTO latVUC_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","opertorium de pellibus arietum rubricatis, et aliud operimentum de janthinis pellibus, ");
INSERT INTO latVUC_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","velum; arcam, vectes, propitiatorium, ");
INSERT INTO latVUC_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","mensam cum vasis suis et propositionis panibus; ");
INSERT INTO latVUC_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","candelabrum, lucernas, et utensilia earum cum oleo; ");
INSERT INTO latVUC_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","altare aureum, et unguentum, et thymiama ex aromatibus, ");
INSERT INTO latVUC_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","et tentorium in introitu tabernaculi; ");
INSERT INTO latVUC_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","altare æneum, retiaculum, vectes, et vasa ejus omnia; labrum cum basi sua; tentoria atrii, et columnas cum basibus suis; ");
INSERT INTO latVUC_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","tentorium in introitu atrii, funiculosque illius et paxillos. Nihil ex vasis defuit, quæ in ministerium tabernaculi, et in tectum fœderis jussa sunt fieri. ");
INSERT INTO latVUC_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Vestes quoque, quibus sacerdotes utuntur in sanctuario, Aaron scilicet et filii ejus, ");
INSERT INTO latVUC_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","obtulerunt filii Israël, sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Quæ postquam Moyses cuncta vidit completa, benedixit eis. ");
INSERT INTO latVUC_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Mense primo, prima die mensis, eriges tabernaculum testimonii, ");
INSERT INTO latVUC_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","et pones in eo arcam, dimittesque ante illam velum: ");
INSERT INTO latVUC_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","et illata mensa, pones super eam quæ rite præcepta sunt. Candelabrum stabit cum lucernis suis, ");
INSERT INTO latVUC_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","et altare aureum, in quo adoletur incensum, coram arca testimonii. Tentorium in introitu tabernaculi pones, ");
INSERT INTO latVUC_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","et ante illud altare holocausti: ");
INSERT INTO latVUC_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","labrum inter altare et tabernaculum, quod implebis aqua. ");
INSERT INTO latVUC_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Circumdabisque atrium tentoriis, et ingressum ejus. ");
INSERT INTO latVUC_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Et assumpto unctionis oleo unges tabernaculum cum vasis suis, ut sanctificentur: ");
INSERT INTO latVUC_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","altare holocausti et omnia vasa ejus, ");
INSERT INTO latVUC_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","labrum cum basi sua: omnia unctionis oleo consecrabis, ut sint Sancta sanctorum. ");
INSERT INTO latVUC_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Applicabisque Aaron et filios ejus ad fores tabernaculi testimonii, et lotos aqua ");
INSERT INTO latVUC_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","indues sanctis vestibus, ut ministrent mihi, et unctio eorum in sacerdotium sempiternum proficiat. ");
INSERT INTO latVUC_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Fecitque Moyses omnia quæ præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Igitur mense primo anni secundi, prima die mensis, collocatum est tabernaculum. ");
INSERT INTO latVUC_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Erexitque Moyses illud, et posuit tabulas ac bases et vectes, statuitque columnas, ");
INSERT INTO latVUC_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","et expandit tectum super tabernaculum, imposito desuper operimento, sicut Dominus imperaverat. ");
INSERT INTO latVUC_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Posuit et testimonium in arca, subditis infra vectibus, et oraculum desuper. ");
INSERT INTO latVUC_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Cumque intulisset arcam in tabernaculum, appendit ante eam velum ut expleret Domini jussionem. ");
INSERT INTO latVUC_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Posuit et mensam in tabernaculo testimonii ad plagam septentrionalem extra velum, ");
INSERT INTO latVUC_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ordinatis coram propositionis panibus, sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Posuit et candelabrum in tabernaculo testimonii e regione mensæ in parte australi, ");
INSERT INTO latVUC_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","locatis per ordinem lucernis, juxta præceptum Domini. ");
INSERT INTO latVUC_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Posuit et altare aureum sub tecto testimonii contra velum, ");
INSERT INTO latVUC_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","et adolevit super eo incensum aromatum, sicut jusserat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Posuit et tentorium in introitu tabernaculi testimonii, ");
INSERT INTO latVUC_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","et altare holocausti in vestibulo testimonii, offerens in eo holocaustum, et sacrificia, ut Dominus imperaverat. ");
INSERT INTO latVUC_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Labrum quoque statuit inter tabernaculum testimonii et altare, implens illud aqua. ");
INSERT INTO latVUC_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Laveruntque Moyses et Aaron ac filii ejus manus suas et pedes, ");
INSERT INTO latVUC_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","cum ingrederentur tectum fœderis, et accederent ad altare, sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Erexit et atrium per gyrum tabernaculi et altaris, ducto in introitu ejus tentorio. Postquam omnia perfecta sunt, ");
INSERT INTO latVUC_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","operuit nubes tabernaculum testimonii, et gloria Domini implevit illud. ");
INSERT INTO latVUC_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Nec poterat Moyses ingredi tectum fœderis, nube operiente omnia, et majestate Domini coruscante, quia cuncta nubes operuerat. ");
INSERT INTO latVUC_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Siquando nubes tabernaculum deserebat, proficiscebantur filii Israël per turmas suas: ");
INSERT INTO latVUC_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","si pendebat desuper, manebant in eodem loco. ");
INSERT INTO latVUC_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Nubes quippe Domini incubabat per diem tabernaculo, et ignis in nocte, videntibus cunctis populis Israël per cunctas mansiones suas. ");
INSERT INTO latVUC_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Vocavit autem Moysen, et locutus est ei Dominus de tabernaculo testimonii, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Loquere filiis Israël, et dices ad eos: Homo, qui obtulerit ex vobis hostiam Domino de pecoribus, id est, de bobus et ovibus offerens victimas, ");
INSERT INTO latVUC_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","si holocaustum fuerit ejus oblatio, ac de armento: masculum immaculatum offeret ad ostium tabernaculi testimonii, ad placandum sibi Dominum: ");
INSERT INTO latVUC_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ponetque manum super caput hostiæ, et acceptabilis erit, atque in expiationem ejus proficiens. ");
INSERT INTO latVUC_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Immolabitque vitulum coram Domino, et offerent filii Aaron sacerdotes sanguinem ejus, fundentes per altaris circuitum, quod est ante ostium tabernaculi: ");
INSERT INTO latVUC_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","detractaque pelle hostiæ, artus in frusta concident. ");
INSERT INTO latVUC_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Et subjicient in altari ignem, strue lignorum ante composita: ");
INSERT INTO latVUC_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","et membra quæ sunt cæsa, desuper ordinantes, caput videlicet, et cuncta quæ adhærent jecori, ");
INSERT INTO latVUC_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","intestinis et pedibus lotis aqua: adolebitque ea sacerdos super altare in holocaustum et suavem odorem Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Quod si de pecoribus oblatio est, de ovibus sive de capris holocaustum, masculum absque macula offeret: ");
INSERT INTO latVUC_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","immolabitque ad latus altaris, quod respicit ad aquilonem, coram Domino: sanguinem vero illius fundent super altare filii Aaron per circuitum: ");
INSERT INTO latVUC_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","dividentque membra, caput, et omnia quæ adhærent jecori, et ponent super ligna, quibus subjiciendus est ignis: ");
INSERT INTO latVUC_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","intestina vero et pedes lavabunt aqua. Et oblata omnia adolebit sacerdos super altare in holocaustum et odorem suavissimum Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Si autem de avibus, holocausti oblatio fuerit Domino, de turturibus, aut pullis columbæ, ");
INSERT INTO latVUC_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","offeret eam sacerdos ad altare: et retorto ad collum capite, ac rupto vulneris loco, decurrere faciet sanguinem super crepidinem altaris: ");
INSERT INTO latVUC_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","vesiculam vero gutturis, et plumas projiciet prope altare ad orientalem plagam, in loco in quo cineres effundi solent, ");
INSERT INTO latVUC_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","confringetque ascellas ejus, et non secabit, neque ferro dividet eam, et adolebit super altare, lignis igne supposito. Holocaustum est et oblatio suavissimi odoris Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Anima cum obtulerit oblationem sacrificii Domino, simila erit ejus oblatio; fundetque super eam oleum, et ponet thus, ");
INSERT INTO latVUC_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ac deferet ad filios Aaron sacerdotes: quorum unus tollet pugillum plenum similæ et olei, ac totum thus, et ponet memoriale super altare in odorem suavissimum Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Quod autem reliquum fuerit de sacrificio, erit Aaron et filiorum ejus, Sanctum sanctorum de oblationibus Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Cum autem obtuleris sacrificium coctum in clibano: de simila, panes scilicet absque fermento, conspersos oleo, et lagana azyma oleo lita. ");
INSERT INTO latVUC_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Si oblatio tua fuerit de sartagine, similæ conspersæ oleo et absque fermento, ");
INSERT INTO latVUC_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","divides eam minutatim, et fundes super eam oleum. ");
INSERT INTO latVUC_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Sin autem de craticula fuerit sacrificium, æque simila oleo conspergetur: ");
INSERT INTO latVUC_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","quam offerens Domino, trades manibus sacerdotis. ");
INSERT INTO latVUC_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Qui cum obtulerit eam, tollet memoriale de sacrificio, et adolebit super altare in odorem suavitatis Domino: ");
INSERT INTO latVUC_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","quidquid autem reliquum est, erit Aaron, et filiorum ejus, Sanctum sanctorum de oblationibus Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Omnis oblatio quæ offeretur Domino, absque fermento fiet, nec quidquam fermenti ac mellis adolebitur in sacrificio Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Primitias tantum eorum offeretis ac munera: super altare vero non imponentur in odorem suavitatis. ");
INSERT INTO latVUC_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Quidquid obtuleris sacrificii, sale condies, nec auferes sal fœderis Dei tui de sacrificio tuo: in omni oblatione tua offeres sal. ");
INSERT INTO latVUC_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Si autem obtuleris munus primarum frugum tuarum Domino de spicis adhuc virentibus, torrebis igni, et confringes in morem farris, et sic offeres primitias tuas Domino, ");
INSERT INTO latVUC_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","fundens supra oleum, et thus imponens, quia oblatio Domini est: ");
INSERT INTO latVUC_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","de qua adolebit sacerdos in memoriam muneris partem farris fracti, et olei, ac totum thus. ");
INSERT INTO latVUC_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Quod si hostia pacificorum fuerit ejus oblatio, et de bobus voluerit offerre, marem sive feminam, immaculata offeret coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ponetque manum super caput victimæ suæ, quæ immolabitur in introitu tabernaculi testimonii, fundentque filii Aaron sacerdotes sanguinem per altaris circuitum. ");
INSERT INTO latVUC_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Et offerent de hostia pacificorum in oblationem Domino, adipem qui operit vitalia, et quidquid pinguedinis est intrinsecus: ");
INSERT INTO latVUC_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","duos renes cum adipe quo teguntur ilia, et reticulum jecoris cum renunculis. ");
INSERT INTO latVUC_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Adolebuntque ea super altare in holocaustum, lignis igne supposito, in oblationem suavissimi odoris Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Si vero de ovibus fuerit ejus oblatio et pacificorum hostia, sive masculum obtulerit, sive feminam, immaculata erunt. ");
INSERT INTO latVUC_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Si agnum obtulerit coram Domino, ");
INSERT INTO latVUC_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ponet manum suam super caput victimæ suæ: quæ immolabitur in vestibulo tabernaculi testimonii: fundentque filii Aaron sanguinem ejus per circuitum altaris. ");
INSERT INTO latVUC_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Et offerent de pacificorum hostia sacrificium Domino: adipem et caudam totam ");
INSERT INTO latVUC_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","cum renibus, et pinguedinem quæ operit ventrem atque universa vitalia, et utrumque renunculum cum adipe qui est juxta ilia, reticulumque jecoris cum renunculis. ");
INSERT INTO latVUC_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Et adolebit ea sacerdos super altare in pabulum ignis et oblationis Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Si capra fuerit ejus oblatio, et obtulerit eam Domino, ");
INSERT INTO latVUC_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ponet manum suam super caput ejus: immolabitque eam in introitu tabernaculi testimonii, et fundent filii Aaron sanguinem ejus per altaris circuitum. ");
INSERT INTO latVUC_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Tollentque ex ea in pastum ignis dominici, adipem qui operit ventrem, et qui tegit universa vitalia: ");
INSERT INTO latVUC_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","duos renunculos cum reticulo, quod est super eos juxta ilia, et arvinam jecoris cum renunculis: ");
INSERT INTO latVUC_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","adolebitque ea super altare sacerdos in alimoniam ignis, et suavissimi odoris. Omnis adeps, Domini erit ");
INSERT INTO latVUC_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","jure perpetuo in generationibus, et cunctis habitaculis vestris: nec sanguinem nec adipem omnino comedetis. ");
INSERT INTO latVUC_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Loquere filiis Israël: Anima, quæ peccaverit per ignorantiam, et de universis mandatis Domini, quæ præcepit ut non fierent, quippiam fecerit: ");
INSERT INTO latVUC_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","si sacerdos, qui unctus est, peccaverit, delinquere faciens populum, offeret pro peccato suo vitulum immaculatum Domino: ");
INSERT INTO latVUC_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","et adducet illum ad ostium tabernaculi testimonii coram Domino, ponetque manum super caput ejus, et immolabit eum Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Hauriet quoque de sanguine vituli, inferens illum in tabernaculum testimonii. ");
INSERT INTO latVUC_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Cumque intinxerit digitum in sanguine, asperget eo septies coram Domino contra velum sanctuarii. ");
INSERT INTO latVUC_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ponetque de eodem sanguine super cornua altaris thymiamatis gratissimi Domino, quod est in tabernaculo testimonii: omnem autem reliquum sanguinem fundet in basim altaris holocausti in introitu tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Et adipem vituli auferet pro peccato, tam eum qui vitalia operit quam omnia quæ intrinsecus sunt: ");
INSERT INTO latVUC_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","duos renunculos et reticulum quod est super eos juxta ilia, et adipem jecoris cum renunculis, ");
INSERT INTO latVUC_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","sicut aufertur de vitulo hostiæ pacificorum: et adolebit ea super altare holocausti. ");
INSERT INTO latVUC_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Pellem vero et omnes carnes, cum capite et pedibus et intestinis et fimo, ");
INSERT INTO latVUC_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","et reliquo corpore, efferet extra castra in locum mundum, ubi cineres effundi solent: incendetque ea super lignorum struem, quæ in loco effusorum cinerum cremabuntur. ");
INSERT INTO latVUC_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Quod si omnis turba Israël ignoraverit, et per imperitiam fecerit quod contra mandatum Domini est, ");
INSERT INTO latVUC_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","et postea intellexerit peccatum suum, offeret pro peccato suo vitulum, adducetque eum ad ostium tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Et ponent seniores populi manus super caput ejus coram Domino. Immolatoque vitulo in conspectu Domini, ");
INSERT INTO latVUC_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","inferet sacerdos, qui unctus est, de sanguine ejus in tabernaculum testimonii, ");
INSERT INTO latVUC_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","tincto digito aspergens septies contra velum. ");
INSERT INTO latVUC_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ponetque de eodem sanguine in cornibus altaris, quod est coram Domino in tabernaculo testimonii: reliquum autem sanguinem fundet juxta basim altaris holocaustorum, quod est in ostio tabernaculi testimonii. ");
INSERT INTO latVUC_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Omnemque ejus adipem tollet, et adolebit super altare: ");
INSERT INTO latVUC_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","sic faciens et de hoc vitulo quomodo fecit et prius: et rogante pro eis sacerdote, propitius erit eis Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ipsum autem vitulum efferet extra castra, atque comburet sicut et priorem vitulum: quia est pro peccato multitudinis. ");
INSERT INTO latVUC_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Si peccaverit princeps, et fecerit unum e pluribus per ignorantiam, quod Domini lege prohibetur: ");
INSERT INTO latVUC_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","et postea intellexerit peccatum suum, offeret hostiam Domino, hircum de capris immaculatum. ");
INSERT INTO latVUC_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ponetque manum suam super caput ejus: cumque immolaverit eum loco ubi solet mactari holocaustum coram Domino, quia pro peccato est, ");
INSERT INTO latVUC_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","tinget sacerdos digitum in sanguine hostiæ pro peccato, tangens cornua altaris holocausti, et reliquum fundens ad basim ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Adipem vero adolebit supra, sicut in victimis pacificorum fieri solet: rogabitque pro eo sacerdos, et pro peccato ejus, et dimittetur ei. ");
INSERT INTO latVUC_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Quod si peccaverit anima per ignorantiam, de populo terræ, ut faciat quidquam de his, quæ Domini lege prohibentur, atque delinquat, ");
INSERT INTO latVUC_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","et cognoverit peccatum suum, offeret capram immaculatam. ");
INSERT INTO latVUC_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ponetque manum super caput hostiæ quæ pro peccato est, et immolabit eam in loco holocausti. ");
INSERT INTO latVUC_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Tolletque sacerdos de sanguine in digito suo: et tangens cornua altaris holocausti, reliquum fundet ad basim ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Omnem autem adipem auferens, sicut auferri solet de victimis pacificorum, adolebit super altare in odorem suavitatis Domino: rogabitque pro eo, et dimittetur ei. ");
INSERT INTO latVUC_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Sin autem de pecoribus obtulerit victimam pro peccato, ovem scilicet immaculatam: ");
INSERT INTO latVUC_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ponet manum super caput ejus, et immolabit eam in loco ubi solent cædi holocaustorum hostiæ. ");
INSERT INTO latVUC_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Sumetque sacerdos de sanguine ejus digito suo, et tangens cornua altaris holocausti, reliquum fundet ad basim ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Omnem quoque adipem auferens, sicut auferri solet adeps arietis, qui immolatur pro pacificis, cremabit super altare in incensum Domini: rogabitque pro eo, et pro peccato ejus, et dimittetur ei. ");
INSERT INTO latVUC_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Si peccaverit anima, et audierit vocem jurantis, testisque fuerit quod aut ipse vidit, aut conscius est: nisi indicaverit, portabit iniquitatem suam. ");
INSERT INTO latVUC_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Anima quæ tetigerit aliquid immundum, sive quod occisum a bestia est, aut per se mortuum, aut quodlibet aliud reptile: et oblita fuerit immunditiæ suæ, rea est, et deliquit: ");
INSERT INTO latVUC_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","et si tetigerit quidquam de immunditia hominis juxta omnem impuritatem, qua pollui solet, oblitaque cognoverit postea, subjacebit delicto. ");
INSERT INTO latVUC_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Anima, quæ juraverit, et protulerit labiis suis, ut vel male quid faceret, vel bene, et idipsum juramento et sermone firmaverit, oblitaque postea intellexerit delictum suum, ");
INSERT INTO latVUC_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","agat pœnitentiam pro peccato, ");
INSERT INTO latVUC_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","et offerat de gregibus agnam sive capram, orabitque pro ea sacerdos et pro peccato ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Sin autem non potuerit offerre pecus, offerat duos turtures, vel duos pullos columbarum Domino, unum pro peccato, et alterum in holocaustum, ");
INSERT INTO latVUC_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","dabitque eos sacerdoti: qui primum offerens pro peccato, retorquebit caput ejus ad pennulas, ita ut collo hæreat, et non penitus abrumpatur. ");
INSERT INTO latVUC_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Et asperget de sanguine ejus parietem altaris; quidquid autem reliquum fuerit, faciet distillare ad fundamentum ejus, quia pro peccato est. ");
INSERT INTO latVUC_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Alterum vero adolebit in holocaustum, ut fieri solet: rogabitque pro eo sacerdos et pro peccato ejus, et dimittetur ei. ");
INSERT INTO latVUC_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Quod si non quiverit manus ejus duos offerre turtures, aut duos pullos columbarum, offeret pro peccato suo similæ partem ephi decimam: non mittet in eam oleum, nec thuris aliquid imponet, quia pro peccato est. ");
INSERT INTO latVUC_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Tradetque eam sacerdoti: qui plenum ex ea pugillum hauriens, cremabit super altare in monimentum ejus qui obtulerit, ");
INSERT INTO latVUC_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","rogans pro illo et expians: reliquam vero partem ipse habebit in munere. ");
INSERT INTO latVUC_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Anima si prævaricans cæremonias, per errorem, in his quæ Domino sunt sanctificata, peccaverit, offeret pro delicto suo arietem immaculatum de gregibus, qui emi potest duobus siclis, juxta pondus sanctuarii: ");
INSERT INTO latVUC_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ipsumque quod intulit damni restituet, et quintam partem ponet supra, tradens sacerdoti, qui rogabit pro eo offerens arietem, et dimittetur ei. ");
INSERT INTO latVUC_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Anima si peccaverit per ignorantiam, feceritque unum ex his quæ Domini lege prohibentur, et peccati rea intellexerit iniquitatem suam, ");
INSERT INTO latVUC_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","offeret arietem immaculatum de gregibus sacerdoti, juxta mensuram æstimationemque peccati: qui orabit pro eo, quia nesciens fecerit: et dimittetur ei, ");
INSERT INTO latVUC_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","quia per errorem deliquit in Dominum. ");
INSERT INTO latVUC_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Anima quæ peccaverit, et contempto Domino, negaverit proximo suo depositum quod fidei ejus creditum fuerat, vel vi aliquid extorserit, aut calumniam fecerit, ");
INSERT INTO latVUC_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","sive rem perditam invenerit, et inficians insuper pejeraverit, et quodlibet aliud ex pluribus fecerit, in quibus solent peccare homines, ");
INSERT INTO latVUC_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","convicta delicti, ");
INSERT INTO latVUC_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","reddet omnia, quæ per fraudem voluit obtinere, integra, et quintam insuper partem domino cui damnum intulerat. ");
INSERT INTO latVUC_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Pro peccato autem suo offeret arietem immaculatum de grege, et dabit eum sacerdoti, juxta æstimationem mensuramque delicti: ");
INSERT INTO latVUC_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","qui rogabit pro eo coram Domino, et dimittetur illi pro singulis quæ faciendo peccavit. ");
INSERT INTO latVUC_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Præcipe Aaron et filiis ejus: Hæc est lex holocausti: cremabitur in altari tota nocte usque mane: ignis ex eodem altari erit. ");
INSERT INTO latVUC_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Vestietur tunica sacerdos et feminalibus lineis: tolletque cineres, quos vorans ignis exussit, et ponens juxta altare, ");
INSERT INTO latVUC_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","spoliabitur prioribus vestimentis, indutusque aliis, efferret eos extra castra, et in loco mundissimo usque ad favillam consumi faciet. ");
INSERT INTO latVUC_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ignis autem in altari semper ardebit, quem nutriet sacerdos subjiciens ligna mane per singulos dies, et imposito holocausto, desuper adolebit adipes pacificorum. ");
INSERT INTO latVUC_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ignis est iste perpetuus, qui numquam deficiet in altari. ");
INSERT INTO latVUC_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Hæc est lex sacrificii et libamentorum, quæ offerent filii Aaron coram Domino, et coram altari. ");
INSERT INTO latVUC_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Tollet sacerdos pugillum similæ, quæ conspersa est oleo, et totum thus, quod super similam positum est: adolebitque illud in altari in monimentum odoris suavissimi Domino: ");
INSERT INTO latVUC_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","reliquam autem partem similæ comedet Aaron cum filiis suis, absque fermento: et comedet in loco sancto atrii tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ideo autem non fermentabitur, quia pars ejus in Domini offertur incensum. Sanctum sanctorum erit, sicut pro peccato atque delicto. ");
INSERT INTO latVUC_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Mares tantum stirpis Aaron comedent illud. Legitimum ac sempiternum erit in generationibus vestris de sacrificiis Domini: omnis qui tetigerit illa, sanctificabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Hæc est oblatio Aaron, et filiorum ejus, quam offerre debent Domino in die unctionis suæ. Decimam partem ephi offerent similæ in sacrificio sempiterno, medium ejus mane, et medium ejus vespere: ");
INSERT INTO latVUC_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","quæ in sartagine oleo conspersa frigetur. Offeret autem eam calidam in odorem suavissimum Domino ");
INSERT INTO latVUC_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","sacerdos, qui jure patri successerit, et tota cremabitur in altari. ");
INSERT INTO latVUC_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Omne enim sacrificium sacerdotum igne consumetur, nec quisquam comedet ex eo. ");
INSERT INTO latVUC_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Locutus est autem Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Loquere Aaron et filiis ejus: Ista est lex hostiæ pro peccato: in loco ubi offertur holocaustum, immolabitur coram Domino. Sanctum sanctorum est. ");
INSERT INTO latVUC_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Sacerdos, qui offert, comedet eam in loco sancto, in atrio tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Quidquid tetigerit carnes ejus, sanctificabitur. Si de sanguine illius vestis fuerit aspersa, lavabitur in loco sancto. ");
INSERT INTO latVUC_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Vas autem fictile, in quo cocta est, confringetur; quod si vas æneum fuerit, defricabitur, et lavabitur aqua. ");
INSERT INTO latVUC_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Omnis masculus de genere sacerdotali vescetur de carnibus ejus, quia Sanctum sanctorum est. ");
INSERT INTO latVUC_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Hostia enim quæ cæditur pro peccato, cujus sanguis infertur in tabernaculum testimonii ad expiandum in sanctuario, non comedetur, sed comburetur igni. ");
INSERT INTO latVUC_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Hæc quoque lex hostiæ pro delicto, Sancta sanctorum est: ");
INSERT INTO latVUC_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","idcirco ubi immolabitur holocaustum, mactabitur et victima pro delicto: sanguis ejus per gyrum altaris fundetur. ");
INSERT INTO latVUC_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Offerent ex ea caudam et adipem qui operit vitalia: ");
INSERT INTO latVUC_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","duos renunculos, et pinguedinem quæ juxta ilia est, reticulumque jecoris cum renunculis. ");
INSERT INTO latVUC_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Et adolebit ea sacerdos super altare: incensum est Domini pro delicto. ");
INSERT INTO latVUC_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Omnis masculus de sacerdotali genere, in loco sancto vescetur his carnibus, quia Sanctum sanctorum est. ");
INSERT INTO latVUC_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Sicut pro peccato offertur hostia, ita et pro delicto: utriusque hostiæ lex una erit: ad sacerdotem, qui eam obtulerit, pertinebit. ");
INSERT INTO latVUC_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Sacerdos qui offert holocausti victimam, habebit pellem ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Et omne sacrificium similæ, quod coquitur in clibano, et quidquid in craticula, vel in sartagine præparatur, ejus erit sacerdotis a quo offertur: ");
INSERT INTO latVUC_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","sive oleo conspersa, sive arida fuerint, cunctis filiis Aaron mensura æqua per singulos dividetur. ");
INSERT INTO latVUC_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Hæc est lex hostiæ pacificorum quæ offertur Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si pro gratiarum actione oblatio fuerit, offerent panes absque fermento conspersos oleo, et lagana azyma uncta oleo, coctamque similam, et collyridas olei admistione conspersas: ");
INSERT INTO latVUC_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","panes quoque fermentatos cum hostia gratiarum, quæ immolatur pro pacificis: ");
INSERT INTO latVUC_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ex quibus unus pro primitiis offeretur Domino, et erit sacerdotis qui fundet hostiæ sanguinem, ");
INSERT INTO latVUC_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","cujus carnes eadem comedentur die, nec remanebit ex eis quidquam usque mane. ");
INSERT INTO latVUC_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Si voto, vel sponte quispiam obtulerit hostiam, eadem similiter edetur die: sed et si quid in crastinum remanserit, vesci licitum est: ");
INSERT INTO latVUC_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","quidquid autem tertius invenerit dies, ignis absumet. ");
INSERT INTO latVUC_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Si quis de carnibus victimæ pacificorum die tertio comederit, irrita fiet oblatio, nec proderit offerenti: quin potius quæcumque anima tali se edulio contaminaverit, prævaricationis rea erit. ");
INSERT INTO latVUC_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Caro, quæ aliquid tetigerit immundum, non comedetur, sed comburetur igni: qui fuerit mundus, vescetur ex ea. ");
INSERT INTO latVUC_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Anima polluta quæ ederit de carnibus hostiæ pacificorum, quæ oblata est Domino, peribit de populis suis. ");
INSERT INTO latVUC_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Et quæ tetigerit immunditiam hominis, vel jumenti, sive omnis rei quæ polluere potest, et comederit de hujuscemodi carnibus, interibit de populis suis. ");
INSERT INTO latVUC_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Loquere filiis Israël: Adipem ovis, et bovis, et capræ non comedetis. ");
INSERT INTO latVUC_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Adipem cadaveris morticini, et ejus animalis, quod a bestia captum est, habebitis in varios usus. ");
INSERT INTO latVUC_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Si quis adipem, qui offerri debet in incensum Domini, comederit, peribit de populo suo. ");
INSERT INTO latVUC_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Sanguinem quoque omnis animalis non sumetis in cibo, tam de avibus quam de pecoribus. ");
INSERT INTO latVUC_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Omnis anima, quæ ederit sanguinem, peribit de populis suis. ");
INSERT INTO latVUC_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Loquere filiis Israël, dicens: Qui offert victimam pacificorum Domino, offerat simul et sacrificium, id est, libamenta ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Tenebit manibus adipem hostiæ, et pectusculum: cumque ambo oblata Domino consecraverit, tradet sacerdoti, ");
INSERT INTO latVUC_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","qui adolebit adipem super altare, pectusculum autem erit Aaron et filiorum ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Armus quoque dexter de pacificorum hostiis cedet in primitias sacerdotis. ");
INSERT INTO latVUC_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Qui obtulerit sanguinem et adipem filiorum Aaron, ipse habebit et armum dextrum in portione sua. ");
INSERT INTO latVUC_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pectusculum enim elevationis, et armum separationis, tuli a filiis Israël de hostiis eorum pacificis, et dedi Aaron sacerdoti, et filiis ejus, lege perpetua, ab omni populo Israël. ");
INSERT INTO latVUC_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Hæc est unctio Aaron et filiorum ejus in cæremoniis Domini die qua obtulit eos Moyses, ut sacerdotio fungerentur, ");
INSERT INTO latVUC_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","et quæ præcepit eis dari Dominus a filiis Israël religione perpetua in generationibus suis. ");
INSERT INTO latVUC_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ista est lex holocausti, et sacrificii pro peccato atque delicto, et pro consecratione et pacificorum victimis, ");
INSERT INTO latVUC_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","quam constituit Dominus Moysi in monte Sinai, quando mandabit filiis Israël ut offerrent oblationes suas Domino in deserto Sinai. ");
INSERT INTO latVUC_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Tolle Aaron cum filiis suis, vestes eorum, et unctionis oleum, vitulum pro peccato, duos arietes, canistrum cum azymis: ");
INSERT INTO latVUC_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","et congregabis omnem cœtum ad ostium tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Fecit Moyses ut Dominus imperaverat. Congregataque omni turba ante fores tabernaculi, ");
INSERT INTO latVUC_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ait: Iste est sermo, quem jussit Dominus fieri. ");
INSERT INTO latVUC_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Statimque obtulit Aaron et filios ejus. Cumque lavisset eos, ");
INSERT INTO latVUC_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","vestivit pontificem subucula linea, accingens eum balteo, et induens eum tunica hyacinthina, et desuper humerale imposuit, ");
INSERT INTO latVUC_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","quod astringens cingulo aptavit rationali, in quo erat Doctrina et Veritas. ");
INSERT INTO latVUC_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Cidari quoque texit caput: et super eam, contra frontem, posuit laminam auream consecratam in sanctificatione, sicut præceperat ei Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Tulit et unctionis oleum, quo linivit tabernaculum cum omni supellectili sua. ");
INSERT INTO latVUC_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Cumque sanctificans aspersisset altare septem vicibus, unxit illud, et omnia vasa ejus, labrumque cum basi sua sanctificavit oleo. ");
INSERT INTO latVUC_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Quod fundens super caput Aaron, unxit eum, et consecravit: ");
INSERT INTO latVUC_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","filios quoque ejus oblatos vestivit tunicis lineis, et cinxit balteis, imposuitque mitras, ut jusserat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Obtulit et vitulum pro peccato: cumque super caput ejus posuisset Aaron et filii ejus manus suas, ");
INSERT INTO latVUC_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","immolavit eum, hauriens sanguinem, et tincto digito, tetigit cornua altaris per gyrum: quo expiato et sanctificato, fudit reliquum sanguinem ad fundamenta ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Adipem vero qui erat super vitalia, et reticulum jecoris, duosque renunculos, cum arvinulis suis, adolevit super altare: ");
INSERT INTO latVUC_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","vitulum cum pelle, et carnibus, et fimo, cremans extra castra, sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Obtulit et arietem in holocaustum: super cujus caput cum imposuissent Aaron et filii ejus manus suas, ");
INSERT INTO latVUC_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","immolavit eum, et fudit sanguinem ejus per circuitum altaris. ");
INSERT INTO latVUC_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ipsumque arietem in frusta concidens, caput ejus, et artus, et adipem adolevit igni, ");
INSERT INTO latVUC_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","lotis prius intestinis et pedibus: totumque simul arietem incendit super altare, eo quod esset holocaustum suavissimi odoris Domino, sicut præceperat ei. ");
INSERT INTO latVUC_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Obtulit et arietem secundum in consecratione sacerdotum, posueruntque super caput ejus Aaron et filii ejus manus suas: ");
INSERT INTO latVUC_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","quem cum immolasset Moyses, sumens de sanguine ejus, tetigit extremum auriculæ dextræ Aaron, et pollicem manus ejus dextræ, similiter et pedis. ");
INSERT INTO latVUC_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Obtulit et filios Aaron: cumque de sanguine arietis immolati tetigisset extremum auriculæ singulorum dextræ, et pollices manus ac pedis dextri, reliquum fudit super altare per circuitum: ");
INSERT INTO latVUC_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","adipem vero, et caudam, omnemque pinguedinem quæ operit intestina, reticulumque jecoris, et duos renes cum adipibus suis et armo dextro separavit. ");
INSERT INTO latVUC_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Tollens autem de canistro azymorum, quod erat coram Domino, panem absque fermento, et collyridam conspersam oleo, laganumque, posuit super adipes, et armum dextrum, ");
INSERT INTO latVUC_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","tradens simul omnia Aaron et filiis ejus. Qui postquam levaverunt ea coram Domino, ");
INSERT INTO latVUC_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","rursum suscepta de manibus eorum, adolevit super altare holocausti, eo quod consecrationis esset oblatio, in odorem suavitatis, sacrificii Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Tulitque pectusculum, elevans illud coram Domino, de ariete consecrationis in partem suam, sicut præceperat ei Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Assumensque unguentum, et sanguinem qui erat in altari, aspersit super Aaron et vestimenta ejus, et super filios illius ac vestes eorum. ");
INSERT INTO latVUC_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Cumque sanctificasset eos in vestitu suo, præcepit eis, dicens: Coquite carnes ante fores tabernaculi, et ibi comedite eas; panes quoque consecrationis edite, qui positi sunt in canistro, sicut præcepit mihi Dominus, dicens: Aaron et filii ejus comedent eos: ");
INSERT INTO latVUC_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","quidquid autem reliquum fuerit de carne et panibus, ignis absumet. ");
INSERT INTO latVUC_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","De ostio quoque tabernaculi non exibitis septem diebus, usque ad diem quo complebitur tempus consecrationis vestræ; septem enim diebus finitur consecratio: ");
INSERT INTO latVUC_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","sicut et impræsentiarum factum est, ut ritus sacrificii compleretur. ");
INSERT INTO latVUC_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Die ac nocte manebitis in tabernaculo observantes custodias Domini, ne moriamini: sic enim mihi præceptum est. ");
INSERT INTO latVUC_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Feceruntque Aaron et filii ejus cuncta quæ locutus est Dominus per manum Moysi. ");
INSERT INTO latVUC_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Facto autem octavo die, vocavit Moyses Aaron, et filios ejus, ac majores natu Israël, dixitque ad Aaron: ");
INSERT INTO latVUC_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Tolle de armento vitulum pro peccato, et arietem in holocaustum, utrumque immaculatum, et offer illos coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Et ad filios Israël loqueris: Tollite hircum pro peccato, et vitulum, atque agnum, anniculos, et sine macula in holocaustum, ");
INSERT INTO latVUC_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","bovem et arietem pro pacificis: et immolate eos coram Domino, in sacrificio singulorum similam conspersam oleo offerentes: hodie enim Dominus apparebit vobis. ");
INSERT INTO latVUC_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Tulerunt ergo cuncta quæ jusserat Moyses ad ostium tabernaculi: ubi cum omnis multitudo astaret, ");
INSERT INTO latVUC_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ait Moyses: Iste est sermo, quem præcepit Dominus: facite, et apparebit vobis gloria ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Et dixit ad Aaron: Accede ad altare, et immola pro peccato tuo: offer holocaustum, et deprecare pro te et pro populo: cumque mactaveris hostiam populi, ora pro eo, sicut præcepit Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Statimque Aaron accedens ad altare, immolavit vitulum pro peccato suo: ");
INSERT INTO latVUC_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","cujus sanguinem obtulerunt ei filii sui: in quo tingens digitum, tetigit cornua altaris, et fudit residuum ad basim ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Adipemque, et renunculos, ac reticulum jecoris, quæ sunt pro peccato, adolevit super altare, sicut præceperat Dominus Moysi: ");
INSERT INTO latVUC_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","carnes vero et pellem ejus extra castra combussit igni. ");
INSERT INTO latVUC_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Immolavit et holocausti victimam: obtuleruntque ei filii sui sanguinem ejus, quem fudit per altaris circuitum. ");
INSERT INTO latVUC_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ipsam etiam hostiam in frusta concisam, cum capite et membris singulis obtulerunt; quæ omnia super altare cremavit igni, ");
INSERT INTO latVUC_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","lotis aqua prius intestinis et pedibus. ");
INSERT INTO latVUC_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Et pro peccato populi offerens, mactavit hircum: expiatoque altari, ");
INSERT INTO latVUC_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","fecit holocaustum, ");
INSERT INTO latVUC_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","addens in sacrificio libamenta, quæ pariter offeruntur, et adolens ea super altare, absque cæremoniis holocausti matutini. ");
INSERT INTO latVUC_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Immolavit et bovem atque arietem, hostias pacificas populi: obtuleruntque ei filii sui sanguinem, quem fudit super altare in circuitum. ");
INSERT INTO latVUC_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Adipem autem bovis, et caudam arietis, renunculosque cum adipibus suis, et reticulum jecoris, ");
INSERT INTO latVUC_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","posuerunt super pectora: cumque cremati essent adipes super altare, ");
INSERT INTO latVUC_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","pectora eorum, et armos dextros separavit Aaron, elevans coram Domino, sicut præceperat Moyses. ");
INSERT INTO latVUC_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Et extendens manus ad populum, benedixit ei. Sicque completis hostiis pro peccato, et holocaustis, et pacificis, descendit. ");
INSERT INTO latVUC_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ingressi autem Moyses et Aaron in tabernaculum testimonii, et deinceps egressi, benedixerunt populo. Apparuitque gloria Domini omni multitudini: ");
INSERT INTO latVUC_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","et ecce egressus ignis a Domino, devoravit holocaustum, et adipes qui erant super altare. Quod cum vidissent turbæ, laudaverunt Dominum, ruentes in facies suas. ");
INSERT INTO latVUC_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Arreptisque Nadab et Abiu filii Aaron thuribulis, posuerunt ignem, et incensum desuper, offerentes coram Domino ignem alienum: quod eis præceptum non erat. ");
INSERT INTO latVUC_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Egressusque ignis a Domino, devoravit eos, et mortui sunt coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Dixitque Moyses ad Aaron: Hoc est quod locutus est Dominus: Sanctificabor in iis qui appropinquant mihi, et in conspectu omnis populi glorificabor. Quod audiens tacuit Aaron. ");
INSERT INTO latVUC_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Vocatis autem Moyses Misaële et Elisaphan filiis Oziel, patrui Aaron, ait ad eos: Ite, et tollite fratres vestros de conspectu sanctuarii, et asportate extra castra. ");
INSERT INTO latVUC_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Confestimque pergentes, tulerunt eos sicut jacebant, vestitos lineis tunicis, et ejecerunt foras, ut sibi fuerat imperatum. ");
INSERT INTO latVUC_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Locutusque est Moyses ad Aaron, et ad Eleazar, et Ithamar, filios ejus: Capita vestra nolite nudare, et vestimenta nolite scindere, ne forte moriamini, et super omnem cœtum oriatur indignatio. Fratres vestri, et omnis domus Israël, plangant incendium quod Dominus suscitavit: ");
INSERT INTO latVUC_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","vos autem non egrediemini fores tabernaculi, alioquin peribitis: oleum quippe sanctæ unctionis est super vos. Qui fecerunt omnia juxta præceptum Moysi. ");
INSERT INTO latVUC_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Dixit quoque Dominus ad Aaron: ");
INSERT INTO latVUC_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Vinum, et omne quod inebriare potest, non bibetis tu et filii tui, quando intratis in tabernaculum testimonii, ne moriamini: quia præceptum sempiternum est in generationes vestras: ");
INSERT INTO latVUC_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","et ut habeatis scientiam discernendi inter sanctum et profanum, inter pollutum et mundum; ");
INSERT INTO latVUC_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","doceatisque filios Israël omnia legitima mea quæ locutus est Dominus ad eos per manum Moysi. ");
INSERT INTO latVUC_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Locutusque est Moyses ad Aaron, et ad Eleazar, et Ithamar, filios ejus, qui erant residui: Tollite sacrificium, quod remansit de oblatione Domini, et comedite illud absque fermento juxta altare, quia Sanctum sanctorum est. ");
INSERT INTO latVUC_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Comedetis autem in loco sancto: quod datum est tibi et filiis tuis de oblationibus Domini, sicut præceptum est mihi. ");
INSERT INTO latVUC_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Pectusculum quoque quod oblatum est, et armum qui separatus est, edetis in loco mundissimo tu et filii tui, et filiæ tuæ tecum: tibi enim ac liberis tuis reposita sunt de hostiis salutaribus filiorum Israël: ");
INSERT INTO latVUC_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","eo quod armum et pectus, et adipes qui cremantur in altari, elevaverunt coram Domino, et pertineant ad te, et ad filios tuos, lege perpetua, sicut præcepit Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Inter hæc, hircum, qui oblatus fuerat pro peccato, cum quæreret Moyses, exustum reperit: iratusque contra Eleazar et Ithamar filios Aaron, qui remanserant, ait: ");
INSERT INTO latVUC_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Cur non comedistis hostiam pro peccato in loco sancto, quæ Sancta sanctorum est, et data vobis ut portetis iniquitatem multitudinis, et rogetis pro ea in conspectu Domini, ");
INSERT INTO latVUC_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","præsertim cum de sanguine illius non sit illatum intra sancta, et comedere debueritis eam in Sanctuario, sicut præceptum est mihi? ");
INSERT INTO latVUC_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Respondit Aaron: Oblata est hodie victima pro peccato, et holocaustum coram Domino: mihi autem accidit quod vides; quomodo potui comedere eam, aut placere Domino in cæremoniis mente lugubri? ");
INSERT INTO latVUC_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Quod cum audisset Moyses, recepit satisfactionem. ");
INSERT INTO latVUC_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Locutusque est Dominus ad Moysen et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Dicite filiis Israël: Hæc sunt animalia quæ comedere debetis de cunctis animantibus terræ: ");
INSERT INTO latVUC_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","omne quod habet divisam ungulam, et ruminat in pecoribus, comedetis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Quidquid autem ruminat quidem, et habet ungulam, sed non dividit eam, sicut camelus et cetera, non comedetis illud, et inter immunda reputabitis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Chœrogryllus qui ruminat, ungulamque non dividit, immundus est. ");
INSERT INTO latVUC_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Lepus quoque: nam et ipse ruminat, sed ungulam non dividit. ");
INSERT INTO latVUC_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Et sus: qui cum ungulam dividat, non ruminat. ");
INSERT INTO latVUC_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Horum carnibus non vescemini, nec cadavera contingetis, quia immunda sunt vobis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Hæc sunt quæ gignuntur in aquis, et vesci licitum est: omne quod habet pinnulas et squamas, tam in mari quam in fluminibus et stagnis, comedetis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Quidquid autem pinnulas et squamas non habet, eorum quæ in aquis moventur et vivunt, abominabile vobis, ");
INSERT INTO latVUC_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","execrandumque erit: carnes eorum non comedetis, et morticina vitabitis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Cuncta quæ non habent pinnulas et squamas in aquis, polluta erunt. ");
INSERT INTO latVUC_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Hæc sunt quæ de avibus comedere non debetis, et vitanda sunt vobis: aquilam, et gryphem, et haliæetum, ");
INSERT INTO latVUC_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","et milvum ac vulturem juxta genus suum, ");
INSERT INTO latVUC_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","et omne corvini generis in similitudinem suam, ");
INSERT INTO latVUC_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","struthionem, et noctuam, et larum, et accipitrem juxta genus suum: ");
INSERT INTO latVUC_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","bubonem, et mergulum, et ibin, ");
INSERT INTO latVUC_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","et cygnum, et onocrotalum, et porphyrionem, ");
INSERT INTO latVUC_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","herodionem, et charadrion juxta genus suum, upupam quoque, et vespertilionem. ");
INSERT INTO latVUC_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Omne de volucribus quod graditur super quatuor pedes, abominabile erit vobis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Quidquid autem ambulat quidem super quatuor pedes, sed habet longiora retro crura, per quæ salit super terram, ");
INSERT INTO latVUC_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","comedere debetis, ut est bruchus in genere suo, et attacus atque ophiomachus, ac locusta, singula juxta genus suum. ");
INSERT INTO latVUC_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Quidquid autem ex volucribus quatuor tantum habet pedes, execrabile erit vobis: ");
INSERT INTO latVUC_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","et quicumque morticina eorum tetigerit, polluetur, et erit immundus usque ad vesperum: ");
INSERT INTO latVUC_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","et si necesse fuerit ut portet quippiam horum mortuum, lavabit vestimenta sua, et immundus erit usque ad occasum solis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Omne animal quod habet quidem ungulam, sed non dividit eam, nec ruminat, immundum erit: et qui tetigerit illud, contaminabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Quod ambulat super manus ex cunctis animantibus, quæ incedunt quadrupedia, immundum erit: qui tetigerit morticina eorum, polluetur usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Et qui portaverit hujuscemodi cadavera, lavabit vestimenta sua, et immundus erit usque ad vesperum: quia omnia hæc immunda sunt vobis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Hæc quoque inter polluta reputabuntur de his quæ moventur in terra, mustela et mus et crocodilus, singula juxta genus suum, ");
INSERT INTO latVUC_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","mygale, et chamæleon, et stellio, et lacerta, et talpa. ");
INSERT INTO latVUC_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Omnia hæc immunda sunt. Qui tetigerit morticina eorum, immundus erit usque ad vesperum: ");
INSERT INTO latVUC_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","et super quod ceciderit quidquam de morticinis eorum, polluetur, tam vas ligneum et vestimentum, quam pelles et cilicia: et in quocumque fit opus, tingentur aqua, et polluta erunt usque ad vesperum, et sic postea mundabuntur. ");
INSERT INTO latVUC_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Vas autem fictile, in quod horum quidquam intro cecidit, polluetur, et idcirco frangendum est. ");
INSERT INTO latVUC_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Omnis cibus, quem comedetis, si fusa fuerit super eum aqua, immundus erit: et omne liquens quod bibitur de universo vase, immundum erit. ");
INSERT INTO latVUC_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Et quidquid de morticinis hujuscemodi ceciderit super illud, immundum erit: sive clibani, sive chytropodes, destruentur, et immundi erunt. ");
INSERT INTO latVUC_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Fontes vero et cisternæ, et omnis aquarum congregatio munda erit. Qui morticinum eorum tetigerit, polluetur. ");
INSERT INTO latVUC_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Si ceciderit super sementem, non polluet eam. ");
INSERT INTO latVUC_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Si autem quispiam aqua sementem perfuderit, et postea morticinis tacta fuerit, illico polluetur. ");
INSERT INTO latVUC_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Si mortuum fuerit animal, quod licet vobis comedere, qui cadaver ejus tetigerit, immundus erit usque ad vesperum: ");
INSERT INTO latVUC_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","et qui comederit ex eo quippiam, sive portaverit, lavabit vestimenta sua, et immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Omne quod reptat super terram, abominabile erit, nec assumetur in cibum. ");
INSERT INTO latVUC_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Quidquid super pectus quadrupes graditur, et multos habet pedes, sive per humum trahitur, non comedetis, quia abominabile est. ");
INSERT INTO latVUC_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nolite contaminare animas vestras, nec tangatis quidquam eorum, ne immundi sitis. ");
INSERT INTO latVUC_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ego enim sum Dominus Deus vester: sancti estote, quia ego sanctus sum. Ne polluatis animas vestras in omni reptili quod movetur super terram. ");
INSERT INTO latVUC_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ego enim sum Dominus, qui eduxi vos de terra Ægypti, ut essem vobis in Deum. Sancti eritis, quia ego sanctus sum. ");
INSERT INTO latVUC_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ista est lex animantium ac volucrum, et omnis animæ viventis, quæ movetur in aqua, et reptat in terra, ");
INSERT INTO latVUC_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ut differentias noveritis mundi et immundi, et sciatis quid comedere et quid respuere debeatis. ");
INSERT INTO latVUC_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Loquere filiis Israël, et dices ad eos: Mulier, si suscepto semine pepererit masculum, immunda erit septem diebus juxta dies separationis menstruæ. ");
INSERT INTO latVUC_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Et die octavo circumcidetur infantulus: ");
INSERT INTO latVUC_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ipsa vero triginta tribus diebus manebit in sanguine purificationis suæ. Omne sanctum non tanget, nec ingredietur in sanctuarium, donec impleantur dies purificationis suæ. ");
INSERT INTO latVUC_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Sin autem feminam pepererit, immunda erit duabus hebdomadibus juxta ritum fluxus menstrui, et sexaginta sex diebus manebit in sanguine purificationis suæ. ");
INSERT INTO latVUC_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Cumque expleti fuerint dies purificationis suæ, pro filio sive pro filia, deferet agnum anniculum in holocaustum, et pullum columbæ sive turturem pro peccato, ad ostium tabernaculi testimonii, et tradet sacerdoti, ");
INSERT INTO latVUC_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","qui offeret illa coram Domino, et orabit pro ea, et sic mundabitur a profluvio sanguinis sui: ista est lex parientis masculum aut feminam. ");
INSERT INTO latVUC_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Quod si non invenerit manus ejus, nec potuerit offerre agnum, sumet duos turtures vel duos pullos columbarum, unum in holocaustum, et alterum pro peccato: orabitque pro ea sacerdos, et sic mundabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Locutusque est Dominus ad Moysen, et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Homo, in cujus cute et carne ortus fuerit diversus color, sive pustula, aut quasi lucens quippiam, id est, plaga lepræ, adducetur ad Aaron sacerdotem, vel ad unum quemlibet filiorum ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Qui cum viderit lepram in cute, et pilos in album mutatos colorem, ipsamque speciem lepræ humiliorem cute et carne reliqua: plaga lepræ est, et ad arbitrium ejus separabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Sin autem lucens candor fuerit in cute, nec humilior carne reliqua, et pili coloris pristini, recludet eum sacerdos septem diebus: ");
INSERT INTO latVUC_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","et considerabit die septimo: et si quidem lepra ultra non creverit, nec transierit in cute priores terminos, rursum recludet eum septem diebus aliis. ");
INSERT INTO latVUC_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Et die septimo contemplabitur: si obscurior fuerit lepra, et non creverit in cute, mundabit eum, quia scabies est: lavabitque homo vestimenta sua, et mundus erit. ");
INSERT INTO latVUC_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Quod si postquam a sacerdote visus est, et redditus munditiæ, iterum lepra creverit: adducetur ad eum, ");
INSERT INTO latVUC_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","et immunditiæ condemnabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Plaga lepræ si fuerit in homine, adducetur ad sacerdotem, ");
INSERT INTO latVUC_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","et videbit eum. Cumque color albus in cute fuerit, et capillorum mutaverit aspectum, ipsa quoque caro viva apparuerit: ");
INSERT INTO latVUC_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","lepra vetustissima judicabitur, atque inolita cuti. Contaminabit itaque eum sacerdos, et non recludet, quia perspicuæ immunditiæ est. ");
INSERT INTO latVUC_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Sin autem effloruerit discurrens lepra in cute, et operuerit omnem cutem a capite usque ad pedes, quidquid sub aspectum oculorum cadit, ");
INSERT INTO latVUC_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","considerabit eum sacerdos, et teneri lepra mundissima judicabit: eo quod omnis in candorem versa sit, et idcirco homo mundus erit. ");
INSERT INTO latVUC_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Quando vero caro vivens in eo apparuerit, ");
INSERT INTO latVUC_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","tunc sacerdotis judicio polluetur, et inter immundos reputabitur: caro enim viva, si lepra aspergitur, immunda est. ");
INSERT INTO latVUC_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Quod si rursum versa fuerit in alborem, et totum hominem operuerit, ");
INSERT INTO latVUC_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","considerabit eum sacerdos, et mundum esse decernet. ");
INSERT INTO latVUC_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Caro autem et cutis in qua ulcus natum est, et sanatum, ");
INSERT INTO latVUC_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","et in loco ulceris cicatrix alba apparuerit, sive subrufa, adducetur homo ad sacerdotem. ");
INSERT INTO latVUC_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Qui cum viderit locum lepræ humiliorem carne reliqua, et pilos versos in candorem, contaminabit eum: plaga enim lepræ orta est in ulcere. ");
INSERT INTO latVUC_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Quod si pilus coloris est pristini, et cicatrix subobscura, et vicina carne non est humilior, recludet eum septem diebus: ");
INSERT INTO latVUC_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","et si quidem creverit, adjudicabit eum lepræ; ");
INSERT INTO latVUC_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","sin autem steterit in loco suo, ulceris est cicatrix, et homo mundus erit. ");
INSERT INTO latVUC_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Caro autem et cutis, quam ignis exusserit, et sanata albam sive rufam habuerit cicatricem, ");
INSERT INTO latVUC_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","considerabit eam sacerdos: et ecce versa est in alborem, et locus ejus reliqua cute est humilior, contaminabit eum, quia plaga lepræ in cicatrice orta est. ");
INSERT INTO latVUC_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Quod si pilorum color non fuerit immutatus, nec humilior plaga carne reliqua, et ipsa lepræ species fuerit subobscura, recludet eum septem diebus, ");
INSERT INTO latVUC_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","et die septimo contemplabitur: si creverit in cute lepra, contaminabit eum. ");
INSERT INTO latVUC_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Sin autem in loco suo candor steterit non satis clarus, plaga combustionis est, et idcirco mundabitur, quia cicatrix est combusturæ. ");
INSERT INTO latVUC_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Vir, sive mulier, in cujus capite vel barba germinaverit lepra, videbit eos sacerdos. ");
INSERT INTO latVUC_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Et si quidem humilior fuerit locus carne reliqua, et capillus flavus, solitoque subtilior, contaminabit eos, quia lepra capitis ac barbæ est. ");
INSERT INTO latVUC_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Sin autem viderit locum maculæ æqualem vicinæ carni, et capillum nigrum: recludet eum septem diebus, ");
INSERT INTO latVUC_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","et die septimo intuebitur. Si non creverit macula, et capillus sui coloris est, et locus plagæ carni reliquæ æqualis: ");
INSERT INTO latVUC_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","radetur homo absque loco maculæ, et includetur septem diebus aliis. ");
INSERT INTO latVUC_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Si die septimo visa fuerit stetisse plaga in loco suo, nec humilior carne reliqua, mundabit eum: lotisque vestibus suis, mundus erit. ");
INSERT INTO latVUC_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Sin autem post emundationem rursus creverit macula in cute, ");
INSERT INTO latVUC_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","non quæret amplius utrum capillus in flavum colorem sit immutatus, quia aperte immundus est. ");
INSERT INTO latVUC_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Porro si steterit macula, et capilli nigri fuerint, noverit hominem sanatum esse, et confidenter eum pronuntiet mundum. ");
INSERT INTO latVUC_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Vir, sive mulier, in cujus cute candor apparuerit, ");
INSERT INTO latVUC_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","intuebitur eos sacerdos. Si deprehenderit subobscurum alborem lucere in cute, sciat non esse lepram, sed maculam coloris candidi, et hominem mundum. ");
INSERT INTO latVUC_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Vir, de cujus capite capilli fluunt, calvus et mundus est: ");
INSERT INTO latVUC_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","et si a fronte ceciderint pili, recalvaster et mundus est. ");
INSERT INTO latVUC_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Sin autem in calvitio sive in recalvatione albus vel rufus color fuerit exortus, ");
INSERT INTO latVUC_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","et hoc sacerdos viderit, condemnabit eum haud dubiæ lepræ, quæ orta est in calvitio. ");
INSERT INTO latVUC_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Quicumque ergo maculatus fuerit lepra, et separatus est ad arbitrium sacerdotis, ");
INSERT INTO latVUC_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","habebit vestimenta dissuta, caput nudum, os veste contectum, contaminatum ac sordidum se clamabit. ");
INSERT INTO latVUC_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Omni tempore quo leprosus est et immundus, solus habitabit extra castra. ");
INSERT INTO latVUC_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Vestis lanea sive linea, quæ lepram habuerit, ");
INSERT INTO latVUC_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","in stamine atque subtegmine, aut certe pellis, vel quidquid ex pelle confectum est, ");
INSERT INTO latVUC_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","si alba vel rufa macula fuerit infecta, lepra reputabitur, ostendeturque sacerdoti: ");
INSERT INTO latVUC_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","qui consideratam recludet septem diebus: ");
INSERT INTO latVUC_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","et die septimo rursus aspiciens, si deprehenderit crevisse, lepra perseverans est: pollutum judicabit vestimentum, et omne in quo fuerit inventa: ");
INSERT INTO latVUC_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","et idcirco comburetur flammis. ");
INSERT INTO latVUC_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Quod si eam viderit non crevisse, ");
INSERT INTO latVUC_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","præcipiet, et lavabunt id in quo lepra est, recludetque illud septem diebus aliis. ");
INSERT INTO latVUC_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Et cum viderit faciem quidem pristinam non reversam, nec tamen crevisse lepram, immundum judicabit, et igne comburet, eo quod infusa sit in superficie vestimenti, vel per totum, lepra. ");
INSERT INTO latVUC_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Sin autem obscurior fuerit locus lepræ, postquam vestis est lota, abrumpet eum, et a solido dividet. ");
INSERT INTO latVUC_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Quod si ultra apparuerit in his locis, quæ prius immaculata erant, lepra volatilis et vaga, debet igne comburi. ");
INSERT INTO latVUC_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Si cessaverit, lavabit aqua ea, quæ pura sunt, secundo, et munda erunt. ");
INSERT INTO latVUC_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ista est lex lepræ vestimenti lanei et linei, staminis, atque subtegminis, omnisque supellectilis pelliceæ, quomodo mundari debeat, vel contaminari. ");
INSERT INTO latVUC_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Hic est ritus leprosi, quando mundandus est. Adducetur ad sacerdotem: ");
INSERT INTO latVUC_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","qui egressus de castris, cum invenerit lepram esse mundatam, ");
INSERT INTO latVUC_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","præcipiet ei, qui purificatur, ut offerat duos passeres vivos pro se, quibus vesci licitum est, et lignum cedrinum, vermiculumque et hyssopum. ");
INSERT INTO latVUC_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Et unum ex passeribus immolari jubebit in vase fictili super aquas viventes: ");
INSERT INTO latVUC_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","alium autem vivum cum ligno cedrino, et cocco et hyssopo, tinget in sanguine passeris immolati, ");
INSERT INTO latVUC_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","quo asperget illum, qui mundandus est, septies, ut jure purgetur: et dimittet passerem vivum, ut in agrum avolet. ");
INSERT INTO latVUC_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Cumque laverit homo vestimenta sua, radet omnes pilos corporis, et lavabitur aqua: purificatusque ingredietur castra, ita dumtaxat ut maneat extra tabernaculum suum septem diebus, ");
INSERT INTO latVUC_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","et die septimo radet capillos capitis, barbamque et supercilia, ac totius corporis pilos. Et lotis rursum vestibus et corpore, ");
INSERT INTO latVUC_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","die octavo assumet duos agnos immaculatos, et ovem anniculam absque macula, et tres decimas similæ in sacrificium, quæ conspersa sit oleo, et seorsum olei sextarium. ");
INSERT INTO latVUC_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Cumque sacerdos purificans hominem, statuerit eum, et hæc omnia coram Domino in ostio tabernaculi testimonii, ");
INSERT INTO latVUC_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","tollet agnum et offeret eum pro delicto, oleique sextarium: et oblatis ante Dominum omnibus, ");
INSERT INTO latVUC_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","immolabit agnum, ubi solet immolari hostia pro peccato, et holocaustum, id est, in loco sancto. Sicut enim pro peccato, ita et pro delicto ad sacerdotem pertinet hostia: Sancta sanctorum est. ");
INSERT INTO latVUC_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Assumensque sacerdos de sanguine hostiæ, quæ immolata est pro delicto, ponet super extremum auriculæ dextræ ejus qui mundatur, et super pollices manus dextræ et pedis: ");
INSERT INTO latVUC_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","et de olei sextario mittet in manum suam sinistram, ");
INSERT INTO latVUC_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","tingetque digitum dextrum in eo, et asperget coram Domino septies. ");
INSERT INTO latVUC_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Quod autem reliquum est olei in læva manu, fundet super extremum auriculæ dextræ ejus qui mundatur, et super pollices manus ac pedis dextri, et super sanguinem qui effusus est pro delicto, ");
INSERT INTO latVUC_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","et super caput ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Rogabitque pro eo coram Domino, et faciet sacrificium pro peccato: tunc immolabit holocaustum, ");
INSERT INTO latVUC_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","et ponet illud in altari cum libamentis suis, et homo rite mundabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Quod si pauper est, et non potest manus ejus invenire quæ dicta sunt pro delicto, assumet agnum ad oblationem, ut roget pro eo sacerdos, decimamque partem similæ conspersæ oleo in sacrificium, et olei sextarium, ");
INSERT INTO latVUC_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","duosque turtures sive duos pullos columbæ, quorum unus sit pro peccato, et alter in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","offeretque ea die octavo purificationis suæ sacerdoti, ad ostium tabernaculi testimonii coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Qui suscipiens agnum pro delicto et sextarium olei, levabit simul: ");
INSERT INTO latVUC_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","immolatoque agno, de sanguine ejus ponet super extremum auriculæ dextræ illius qui mundatur, et super pollices manus ejus ac pedis dextri: ");
INSERT INTO latVUC_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","olei vero partem mittet in manum suam sinistram, ");
INSERT INTO latVUC_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","in quo tingens digitum dextræ manus asperget septies coram Domino: ");
INSERT INTO latVUC_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","tangetque extremum dextræ auriculæ illius qui mundatur, et pollices manus ac pedis dextri, in loco sanguinis qui effusus est pro delicto: ");
INSERT INTO latVUC_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","reliquam autem partem olei, quæ est in sinistra manu, mittet super caput purificati, ut placet pro eo Dominum: ");
INSERT INTO latVUC_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","et turturem sive pullum columbæ offeret, ");
INSERT INTO latVUC_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","unum pro delicto, et alterum in holocaustum cum libamentis suis. ");
INSERT INTO latVUC_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Hoc est sacrificium leprosi, qui habere non potest omnia in emundationem sui. ");
INSERT INTO latVUC_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Locutusque est Dominus ad Moysen et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Cum ingressi fueritis terram Chanaan, quam ego dabo vobis in possessionem, si fuerit plaga lepræ in ædibus, ");
INSERT INTO latVUC_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ibit cujus est domus, nuntians sacerdoti, et dicet: Quasi plaga lepræ videtur mihi esse in domo mea. ");
INSERT INTO latVUC_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","At ille præcipiet ut efferant universa de domo, priusquam ingrediatur eam, et videat utrum leprosa sit, ne immunda fiant omnia quæ in domo sunt. Intrabitque postea ut consideret lepram domus: ");
INSERT INTO latVUC_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","et cum viderit in parietibus illius quasi valliculas pallore sive rubore deformes, et humiliores superficie reliqua, ");
INSERT INTO latVUC_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","egredietur ostium domus, et statim claudet illam septem diebus. ");
INSERT INTO latVUC_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Reversusque die septimo, considerabit eam: si invenerit crevisse lepram, ");
INSERT INTO latVUC_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","jubebit erui lapides in quibus lepra est, et projici eos extra civitatem in locum immundum: ");
INSERT INTO latVUC_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","domum autem ipsam radi intrinsecus per circuitum, et spargi pulverem rasuræ extra urbem in locum immundum, ");
INSERT INTO latVUC_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","lapidesque alios reponi pro his qui ablati fuerint, et luto alio liniri domum. ");
INSERT INTO latVUC_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Sin autem postquam eruti sunt lapides, et pulvis erasus, et alia terra lita, ");
INSERT INTO latVUC_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ingressus sacerdos viderit reversam lepram, et parietes respersos maculis, lepra est perseverans, et immunda domus: ");
INSERT INTO latVUC_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","quam statim destruent, et lapides ejus ac ligna, atque universum pulverem projicient extra oppidum in locum immundum. ");
INSERT INTO latVUC_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Qui intraverit domum quando clausa est, immundus erit usque ad vesperum: ");
INSERT INTO latVUC_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","et qui dormierit in ea, et comederit quippiam, lavabit vestimenta sua. ");
INSERT INTO latVUC_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Quod si introiens sacerdos viderit lepram non crevisse in domo, postquam denuo lita fuerit, purificabit eam reddita sanitate: ");
INSERT INTO latVUC_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","et in purificationem ejus sumet duos passeres, lignumque cedrinum, et vermiculum atque hyssopum: ");
INSERT INTO latVUC_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","et immolato uno passere in vase fictili super aquas vivas, ");
INSERT INTO latVUC_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","tollet lignum cedrinum, et hyssopum, et coccum, et passerem vivum, et tinget omnia in sanguine passeris immolati, atque in aquis viventibus, et asperget domum septies, ");
INSERT INTO latVUC_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","purificabitque eam tam in sanguine passeris quam in aquis viventibus, et in passere vivo, lignoque cedrino et hyssopo atque vermiculo. ");
INSERT INTO latVUC_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Cumque dimiserit passerem avolare in agrum libere, orabit pro domo, et jure mundabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ista est lex omnis lepræ et percussuræ, ");
INSERT INTO latVUC_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","lepræ vestium et domorum, ");
INSERT INTO latVUC_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","cicatricis et erumpentium papularum, lucentis maculæ, et in varias species, coloribus immutatis, ");
INSERT INTO latVUC_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ut possit sciri quo tempore mundum quid, vel immundum sit. ");
INSERT INTO latVUC_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Locutusque est Dominus ad Moysen et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Loquimini filiis Israël, et dicite eis: Vir, qui patitur fluxum seminis, immundus erit. ");
INSERT INTO latVUC_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Et tunc judicabitur huic vitio subjacere, cum per singula momenta adhæserit carni ejus, atque concreverit fœdus humor. ");
INSERT INTO latVUC_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Omne stratum, in quo dormierit, immundum erit, et ubicumque sederit. ");
INSERT INTO latVUC_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Si quis hominum tetigerit lectum ejus, lavabit vestimenta sua, et ipse lotus aqua, immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Si sederit ubi ille sederat, et ipse lavabit vestimenta sua: et lotus aqua, immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Qui tetigerit carnem ejus, lavabit vestimenta sua: et ipse lotus aqua, immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Si salivam hujuscemodi homo jecerit super eum qui mundus est, lavabit vestimenta sua: et lotus aqua, immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Sagma, super quo sederit, immundum erit: ");
INSERT INTO latVUC_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","et quidquid sub eo fuerit, qui fluxum seminis patitur, pollutum erit usque ad vesperum. Qui portaverit horum aliquid, lavabit vestimenta sua: et ipse lotus aqua, immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Omnis, quem tetigerit qui talis est, non lotis ante manibus, lavabit vestimenta sua, et lotus aqua, immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Vas fictile quod tetigerit confringetur: vas autem ligneum lavabitur aqua. ");
INSERT INTO latVUC_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Si sanatus fuerit qui hujuscemodi sustinet passionem, numerabit septem dies post emundationem sui, et lotis vestibus et toto corpore in aquis viventibus, erit mundus. ");
INSERT INTO latVUC_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Die autem octavo sumet duos turtures, aut duos pullos columbæ, et veniet in conspectum Domini ad ostium tabernaculi testimonii, dabitque eos sacerdoti: ");
INSERT INTO latVUC_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","qui faciet unum pro peccato et alterum in holocaustum: rogabitque pro eo coram Domino, ut emundetur a fluxi seminis sui. ");
INSERT INTO latVUC_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Vir de quo egreditur semen coitus, lavabit aqua omne corpus suum: et immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Vestem et pellem, quam habuerit, lavabit aqua, et immunda erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Mulier, cum qua coierit, lavabitur aqua, et immunda erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Mulier, quæ redeunte mense patitur fluxum sanguinis, septem diebus separabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Omnis qui tetigerit eam, immundus erit usque ad vesperum: ");
INSERT INTO latVUC_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","et in quo dormierit vel sederit diebus separationis suæ, polluetur. ");
INSERT INTO latVUC_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Qui tetigerit lectum ejus, lavabit vestimenta sua: et ipse lotus aqua, immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Omne vas, super quo illa sederit, quisquis attigerit, lavabit vestimenta sua: et ipse lotus aqua, pollutus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Si coierit cum ea vir tempore sanguinis menstrualis, immundus erit septem diebus: et omne stratum, in quo dormierit, polluetur. ");
INSERT INTO latVUC_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Mulier, quæ patitur multis diebus fluxum sanguinis non in tempore menstruali, vel quæ post menstruum sanguinem fluere non cessat, quamdiu subjacet huic passioni, immunda erit quasi sit in tempore menstruo. ");
INSERT INTO latVUC_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Omne stratum, in quo dormierit, et vas in quo sederit, pollutum erit. ");
INSERT INTO latVUC_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Quicumque tetigerit ea, lavabit vestimenta sua: et ipse lotus aqua, immundus erit usque ad vesperam. ");
INSERT INTO latVUC_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Si steterit sanguis, et fluere cessaverit, numerabit septem dies purificationis suæ: ");
INSERT INTO latVUC_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","et die octavo offeret pro se sacerdoti duos turtures, aut duos pullos columbarum, ad ostium tabernaculi testimonii: ");
INSERT INTO latVUC_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","qui unum faciet pro peccato, et alterum in holocaustum, rogabitque pro ea coram Domino, et pro fluxu immunditiæ ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Docebitis ergo filios Israël ut caveant immunditiam, et non moriantur in sordibus suis, cum polluerint tabernaculum meum quod est inter eos. ");
INSERT INTO latVUC_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ista est lex ejus, qui patitur fluxum seminis, et qui polluitur coitu, ");
INSERT INTO latVUC_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","et quæ menstruis temporibus separatur, vel quæ jugi fluit sanguine, et hominis qui dormierit cum ea. ");
INSERT INTO latVUC_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Locutusque est Dominus ad Moysen post mortem duorum filiorum Aaron, quando offerentes ignem alienum interfecti sunt: ");
INSERT INTO latVUC_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","et præcepit ei, dicens: Loquere ad Aaron fratrem tuum, ne omni tempore ingrediatur sanctuarium, quod est intra velum coram propitiatorio quo tegitur arca, ut non moriatur (quia in nube apparebo super oraculum), ");
INSERT INTO latVUC_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","nisi hæc ante fecerit: vitulum pro peccato offeret, et arietem in holocaustum. ");
INSERT INTO latVUC_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Tunica linea vestietur, feminalibus lineis verenda celabit: accingetur zona linea, cidarim lineam imponet capiti: hæc enim vestimenta sunt sancta: quibus cunctis, cum lotus fuerit, induetur. ");
INSERT INTO latVUC_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Suscipietque ab universa multitudine filiorum Israël duos hircos pro peccato, et unum arietem in holocaustum. ");
INSERT INTO latVUC_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Cumque obtulerit vitulum, et oraverit pro se et pro domo sua, ");
INSERT INTO latVUC_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","duos hircos stare faciet coram Domino in ostio tabernaculi testimonii: ");
INSERT INTO latVUC_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","mittensque super utrumque sortem, unam Domino, alteram capro emissario: ");
INSERT INTO latVUC_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","cujus exierit sors Domino, offeret illum pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","cujus autem in caprum emissarium, statuet eum vivum coram Domino, ut fundat preces super eo, et emittat eum in solitudinem. ");
INSERT INTO latVUC_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","His rite celebratis, offeret vitulum, et rogans pro se, et pro domo sua, immolabit eum: ");
INSERT INTO latVUC_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","assumptoque thuribulo, quod de prunis altaris impleverit, et hauriens manu compositum thymiama in incensum, ultra velum intrabit in sancta: ");
INSERT INTO latVUC_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ut, positis super ignem aromatibus, nebula eorum et vapor operiat oraculum quod est supra testimonium, et non moriatur. ");
INSERT INTO latVUC_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Tollet quoque de sanguine vituli, et asperget digito septies contra propitiatorium ad orientem. ");
INSERT INTO latVUC_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Cumque mactaverit hircum pro peccato populi, inferet sanguinem ejus intra velum, sicut præceptum est de sanguine vituli, ut aspergat e regione oraculi, ");
INSERT INTO latVUC_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","et expiet sanctuarium ab immunditiis filiorum Israël, et a prævaricationibus eorum, cunctisque peccatis. Juxta hunc ritum faciet tabernaculo testimonii, quod fixum est inter eos, in medio sordium habitationis eorum. ");
INSERT INTO latVUC_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Nullus hominum sit in tabernaculo, quando pontifex sanctuarium ingreditur, ut roget pro se, et pro domo sua, et pro universo cœtu Israël, donec egrediatur. ");
INSERT INTO latVUC_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Cum autem exierit ad altare quod coram Domino est, oret pro se, et sumptum sanguinem vituli atque hirci fundat super cornua ejus per gyrum: ");
INSERT INTO latVUC_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","aspergensque digito septies, expiet, et sanctificet illud ab immunditiis filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Postquam emundaverit sanctuarium, et tabernaculum, et altare, tunc offerat hircum viventem: ");
INSERT INTO latVUC_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","et posita utraque manu super caput ejus, confiteatur omnes iniquitates filiorum Israël, et universa delicta atque peccata eorum: quæ imprecans capiti ejus, emittet illum per hominem paratum, in desertum. ");
INSERT INTO latVUC_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Cumque portaverit hircus omnes iniquitates eorum in terram solitariam, et dimissus fuerit in deserto, ");
INSERT INTO latVUC_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","revertetur Aaron in tabernaculum testimonii, et depositis vestibus, quibus prius indutus erat, cum intraret sanctuarium, relictisque ibi, ");
INSERT INTO latVUC_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","lavabit carnem suam in loco sancto, indueturque vestibus suis. Et postquam egressus obtulerit holocaustum suum, ac plebis, rogabit tam pro se quam pro populo: ");
INSERT INTO latVUC_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","et adipem, qui oblatus est pro peccatis, adolebit super altare. ");
INSERT INTO latVUC_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ille vero, qui dimiserit caprum emissarium, lavabit vestimenta sua, et corpus aqua, et sic ingredietur in castra. ");
INSERT INTO latVUC_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Vitulum autem, et hircum, qui pro peccato fuerant immolati, et quorum sanguis illatus est in sanctuarium, ut expiatio compleretur, asportabunt foras castra, et comburent igni tam pelles quam carnes eorum, ac fimum: ");
INSERT INTO latVUC_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","et quicumque combusserit ea, lavabit vestimenta sua et carnem aqua, et sic ingredietur in castra. ");
INSERT INTO latVUC_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Eritque vobis hoc legitimum sempiternum: mense septimo, decima die mensis, affligetis animas vestras, nullumque opus facietis, sive indigena, sive advena qui peregrinatur inter vos. ");
INSERT INTO latVUC_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","In hac die expiatio erit vestri, atque mundatio ab omnibus peccatis vestris: coram Domino mundabimini. ");
INSERT INTO latVUC_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Sabbatum enim requietionis est, et affligetis animas vestras religione perpetua. ");
INSERT INTO latVUC_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Expiabit autem sacerdos, qui unctus fuerit, et cujus manus initiatæ sunt ut sacerdotio fungatur pro patre suo: indueturque stola linea et vestibus sanctis, ");
INSERT INTO latVUC_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","et expiabit sanctuarium et tabernaculum testimonii atque altare, sacerdotes quoque et universum populum. ");
INSERT INTO latVUC_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Eritque vobis hoc legitimum sempiternum, ut oretis pro filiis Israël, et pro cunctis peccatis eorum semel in anno. Fecit igitur sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Et locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Loquere Aaron et filiis ejus, et cunctis filiis Israël, dicens ad eos: Iste est sermo quem mandavit Dominus, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Homo quilibet de domo Israël, si occiderit bovem aut ovem, sive capram, in castris vel extra castra, ");
INSERT INTO latVUC_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","et non obtulerit ad ostium tabernaculi oblationem Domino, sanguinis reus erit: quasi si sanguinem fuderit, sic peribit de medio populi sui. ");
INSERT INTO latVUC_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ideo sacerdoti offerre debent filii Israël hostias suas, quas occident in agro, ut sanctificentur Domino ante ostium tabernaculi testimonii, et immolent eas hostias pacificas Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Fundetque sacerdos sanguinem super altare Domini ad ostium tabernaculi testimonii, et adolebit adipem in odorem suavitatis Domino: ");
INSERT INTO latVUC_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","et nequaquam ultra immolabunt hostias suas dæmonibus, cum quibus fornicati sunt. Legitimum sempiternum erit illis et posteris eorum. ");
INSERT INTO latVUC_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Et ad ipsos dices: Homo de domo Israël, et de advenis qui peregrinantur apud vos, qui obtulerit holocaustum sive victimam, ");
INSERT INTO latVUC_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","et ad ostium tabernaculi testimonii non adduxerit eam, ut offeratur Domino, interibit de populo suo. ");
INSERT INTO latVUC_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Homo quilibet de domo Israël et de advenis qui peregrinantur inter eos, si comederit sanguinem, obfirmabo faciem meam contra animam illius, et disperdam eam de populo suo, ");
INSERT INTO latVUC_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","quia anima carnis in sanguine est: et ego dedi illum vobis, ut super altare in eo expietis pro animabus vestris, et sanguis pro animæ piaculo sit. ");
INSERT INTO latVUC_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Idcirco dixi filiis Israël: Omnis anima ex vobis non comedet sanguinem, nec ex advenis qui peregrinantur apud vos. ");
INSERT INTO latVUC_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Homo quicumque de filiis Israël, et de advenis qui peregrinantur apud vos, si venatione atque aucupio ceperit feram, vel avem, quibus vesci licitum est, fundat sanguinem ejus, et operiat illum terra. ");
INSERT INTO latVUC_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Anima enim omnis carnis in sanguine est: unde dixi filiis Israël: Sanguinem universæ carnis non comedetis, quia anima carnis in sanguine est: et quicumque comederit illum, interibit. ");
INSERT INTO latVUC_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Anima, quæ comederit morticinum, vel captum a bestia, tam de indigenis, quam de advenis, lavabit vestimenta sua et semetipsum aqua, et contaminatus erit usque ad vesperum: et hoc ordine mundus fiet. ");
INSERT INTO latVUC_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Quod si non laverit vestimenta sua et corpus, portabit iniquitatem suam. ");
INSERT INTO latVUC_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Loquere filiis Israël, et dices ad eos: Ego Dominus Deus vester: ");
INSERT INTO latVUC_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","juxta consuetudinem terræ Ægypti, in qua habitastis, non facietis: et juxta morem regionis Chanaan, ad quam ego introducturus sum vos, non agetis, nec in legitimis eorum ambulabitis. ");
INSERT INTO latVUC_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Facietis judicia mea, et præcepta mea servabitis, et ambulabitis in eis. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Custodite leges meas atque judicia, quæ faciens homo, vivet in eis. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Omnis homo ad proximam sanguinis sui non accedet, ut revelet turpitudinem ejus. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Turpitudinem patris tui et turpitudinem matris tuæ non discooperies: mater tua est: non revelabis turpitudinem ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Turpitudinem uxoris patris tui non discooperies: turpitudo enim patris tui est. ");
INSERT INTO latVUC_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Turpitudinem sororis tuæ ex patre sive ex matre, quæ domi vel foris genita est, non revelabis. ");
INSERT INTO latVUC_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Turpitudinem filiæ filii tui vel neptis ex filia non revelabis: quia turpitudo tua est. ");
INSERT INTO latVUC_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Turpitudinem filiæ uxoris patris tui, quam peperit patri tuo, et est soror tua, non revelabis. ");
INSERT INTO latVUC_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Turpitudinem sororis patris tui non discooperies: quia caro est patris tui. ");
INSERT INTO latVUC_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Turpitudinem sororis matris tuæ non revelabis, eo quod caro sit matris tuæ. ");
INSERT INTO latVUC_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Turpitudinem patrui tui non revelabis, nec accedes ad uxorem ejus, quæ tibi affinitate conjungitur. ");
INSERT INTO latVUC_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Turpitudinem nurus tuæ non revelabis, quia uxor filii tui est: nec discooperies ignominiam ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Turpitudinem uxoris fratris tui non revelabis: quia turpitudo fratris tui est. ");
INSERT INTO latVUC_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Turpitudinem uxoris tuæ et filiæ ejus non revelabis. Filiam filii ejus, et filiam filiæ illius non sumes, ut reveles ignominiam ejus: quia caro illius sunt, et talis coitus incestus est. ");
INSERT INTO latVUC_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Sororem uxoris tuæ in pellicatum illius non accipies, nec revelabis turpitudinem ejus adhuc illa vivente. ");
INSERT INTO latVUC_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ad mulierem quæ patitur menstrua non accedes, nec revelabis fœditatem ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Cum uxore proximi tui non coibis, nec seminis commistione maculaberis. ");
INSERT INTO latVUC_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","De semine tuo non dabis ut consecretur idolo Moloch, nec pollues nomen Dei tui. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Cum masculo non commiscearis coitu femineo, quia abominatio est. ");
INSERT INTO latVUC_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Cum omni pecore non coibis, nec maculaberis cum eo. Mulier non succumbet jumento, nec miscebitur ei, quia scelus est. ");
INSERT INTO latVUC_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Nec polluamini in omnibus his quibus contaminatæ sunt universæ gentes, quas ego ejiciam ante conspectum vestrum, ");
INSERT INTO latVUC_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","et quibus polluta est terra: cujus ego scelera visitabo, ut evomat habitatores suos. ");
INSERT INTO latVUC_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Custodite legitima mea atque judicia, et non faciatis ex omnibus abominationibus istis, tam indigena quam colonus qui peregrinantur apud vos. ");
INSERT INTO latVUC_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Omnes enim execrationes istas fecerunt accolæ terræ qui fuerunt ante vos, et polluerunt eam. ");
INSERT INTO latVUC_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Cavete ergo ne et vos similiter evomat, cum paria feceritis, sicut evomuit gentem, quæ fuit ante vos. ");
INSERT INTO latVUC_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Omnis anima, quæ fecerit de abominationibus his quippiam, peribit de medio populi sui. ");
INSERT INTO latVUC_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Custodite mandata mea. Nolite facere quæ fecerunt hi qui fuerunt ante vos, et ne polluamini in eis. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Loquere ad omnem cœtum filiorum Israël, et dices ad eos: Sancti estote, quia ego sanctus sum, Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Unusquisque patrem suum, et matrem suam timeat. Sabbata mea custodite. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Nolite converti ad idola, nec deos conflatiles faciatis vobis. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Si immolaveritis hostiam pacificorum Domino, ut sit placabilis, ");
INSERT INTO latVUC_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","eo die quo fuerit immolata, comedetis eam, et die altero: quidquid autem residuum fuerit in diem tertium, igne comburetis. ");
INSERT INTO latVUC_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Si quis post biduum comederit ex ea, profanus erit, et impietatis reus: ");
INSERT INTO latVUC_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","portabitque iniquitatem suam, quia sanctum Domini polluit, et peribit anima illa de populo suo. ");
INSERT INTO latVUC_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Cumque messueris segetes terræ tuæ, non tondebis usque ad solum superficiem terræ, nec remanentes spicas colliges, ");
INSERT INTO latVUC_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","neque in vinea tua racemos et grana decidentia congregabis: sed pauperibus et peregrinis carpenda dimittes. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Non facietis furtum. Non mentiemini, nec decipiet unusquisque proximum suum. ");
INSERT INTO latVUC_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Non perjurabis in nomine meo, nec pollues nomen Dei tui. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Non facies calumniam proximo tuo nec vi opprimes eum. Non morabitur opus mercenarii tui apud te usque mane. ");
INSERT INTO latVUC_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Non maledices surdo, nec coram cæco pones offendiculum: sed timebis Dominum Deum tuum, quia ego sum Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Non facies quod iniquum est, nec injuste judicabis. Non consideres personam pauperis, nec honores vultum potentis. Juste judica proximo tuo. ");
INSERT INTO latVUC_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Non eris criminator, nec susurro in populo. Non stabis contra sanguinem proximi tui. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Non oderis fratrem tuum in corde tuo, sed publice argue eum, ne habeas super illo peccatum. ");
INSERT INTO latVUC_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Non quæras ultionem, nec memor eris injuriæ civium tuorum. Diliges amicum tuum sicut teipsum. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Leges meas custodite. Jumentum tuum non facies coire cum alterius generis animantibus. Agrum tuum non seres diverso semine. Veste, quæ ex duobus texta est, non indueris. ");
INSERT INTO latVUC_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Homo, si dormierit cum muliere coitu seminis, quæ sit ancilla etiam nubilis, et tamen pretio non redempta, nec libertate donata: vapulabunt ambo, et non morientur, quia non fuit libera. ");
INSERT INTO latVUC_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Pro delicto autem suo offeret Domino ad ostium tabernaculi testimonii arietem: ");
INSERT INTO latVUC_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","orabitque pro eo sacerdos, et pro peccato ejus coram Domino, et repropitiabitur ei, dimitteturque peccatum. ");
INSERT INTO latVUC_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Quando ingressi fueritis terram, et plantaveritis in ea ligna pomifera, auferetis præputia eorum: poma, quæ germinant, immunda erunt vobis, nec edetis ex eis. ");
INSERT INTO latVUC_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Quarto autem anno omnis fructus eorum sanctificabitur, laudabilis Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Quinto autem anno comedetis fructus, congregantes poma, quæ proferunt. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Non comedetis cum sanguine. Non augurabimini, nec observabitis somnia. ");
INSERT INTO latVUC_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Neque in rotundum attondebitis comam, nec radetis barbam. ");
INSERT INTO latVUC_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Et super mortuo non incidetis carnem vestram, neque figuras aliquas aut stigmata facietis vobis. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ne prostituas filiam tuam, ne contaminetur terra et impleatur piaculo. ");
INSERT INTO latVUC_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Sabbata mea custodite, et sanctuarium meum metuite. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Non declinetis ad magos, nec ab ariolis aliquid sciscitemini, ut polluamini per eos. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Coram cano capite consurge, et honora personam senis: et time Dominum Deum tuum. Ego sum Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Si habitaverit advena in terra vestra, et moratus fuerit inter vos, non exprobretis ei: ");
INSERT INTO latVUC_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","sed sit inter vos quasi indigena, et diligetis eum quasi vosmetipsos: fuistis enim et vos advenæ in terra Ægypti. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Nolite facere iniquum aliquid in judicio, in regula, in pondere, in mensura. ");
INSERT INTO latVUC_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Statera justa, et æqua sint pondera, justus modius, æquusque sextarius. Ego Dominus Deus vester, qui eduxi vos de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Custodite omnia præcepta mea, et universa judicia, et facite ea. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Hæc loqueris filiis Israël: Homo de filiis Israël, et de advenis qui habitant in Israël, si quis dederit de semine suo idolo Moloch, morte moriatur: populus terræ lapidabit eum. ");
INSERT INTO latVUC_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Et ego ponam faciem meam contra illum: succidamque eum de medio populi sui, eo quod dederit de semine suo Moloch, et contaminaverit sanctuarium meum, ac polluerit nomen sanctum meum. ");
INSERT INTO latVUC_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Quod si negligens populus terræ, et quasi parvipendens imperium meum, dimiserit hominem qui dedit de semine suo Moloch, nec voluerit eum occidere: ");
INSERT INTO latVUC_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ponam faciem meam super hominem illum, et super cognationem ejus, succidamque et ipsum, et omnes qui consenserunt ei ut fornicarentur cum Moloch, de medio populi sui. ");
INSERT INTO latVUC_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Anima, quæ declinaverit ad magos et ariolos, et fornicata fuerit cum eis, ponam faciem meam contra eam, et interficiam illam de medio populi sui. ");
INSERT INTO latVUC_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Sanctificamini et estote sancti, quia ego sum Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Custodite præcepta mea, et facite ea: ego Dominus qui sanctifico vos. ");
INSERT INTO latVUC_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Qui maledixerit patri suo, aut matri, morte moriatur: patri matrique maledixit: sanguis ejus sit super eum. ");
INSERT INTO latVUC_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Si mœchatus quis fuerit cum uxore alterius, et adulterium perpetraverit cum conjuge proximi sui, morte moriantur et mœchus et adultera. ");
INSERT INTO latVUC_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Qui dormierit cum noverca sua, et revelaverit ignominiam patris sui, morte moriantur ambo: sanguis eorum sit super eos. ");
INSERT INTO latVUC_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Si quis dormierit cum nuru sua, uterque moriatur, quia scelus operati sunt: sanguis eorum sit super eos. ");
INSERT INTO latVUC_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Qui dormierit cum masculo coitu femineo, uterque operatus est nefas: morte moriantur: sit sanguis eorum super eos. ");
INSERT INTO latVUC_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Qui supra uxorem filiam, duxerit matrem ejus, scelus operatus est: vivus ardebit cum eis, nec permanebit tantum nefas in medio vestri. ");
INSERT INTO latVUC_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Qui cum jumento et pecore coierit, morte moriatur: pecus quoque occidite. ");
INSERT INTO latVUC_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Mulier, quæ succubuerit cuilibet jumento, simul interficietur cum eo: sanguis eorum sit super eos. ");
INSERT INTO latVUC_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Qui acceperit sororem suam filiam patris sui, vel filiam matris suæ, et viderit turpitudinem ejus, illaque conspexerit fratris ignominiam, nefariam rem operati sunt: occidentur in conspectu populi sui, eo quod turpitudinem suam mutuo revelaverint, et portabunt iniquitatem suam. ");
INSERT INTO latVUC_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Qui coierit cum muliere in fluxu menstruo, et revelaverit turpitudinem ejus, ipsaque aperuerit fontem sanguinis sui, interficientur ambo de medio populi sui. ");
INSERT INTO latVUC_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Turpitudinem materteræ et amitæ tuæ non discooperies: qui hoc fecerit, ignominiam carnis suæ nudavit; portabunt ambo iniquitatem suam. ");
INSERT INTO latVUC_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Qui coierit cum uxore patrui vel avunculi sui, et revelaverit ignominiam cognationis suæ, portabunt ambo peccatum suum: absque liberis morientur. ");
INSERT INTO latVUC_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Qui duxerit uxorem fratris sui, rem facit illicitam: turpitudinem fratris sui revelavit: absque liberis erunt. ");
INSERT INTO latVUC_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Custodite leges meas, atque judicia, et facite ea: ne et vos evomat terra quam intraturi estis et habitaturi. ");
INSERT INTO latVUC_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Nolite ambulare in legitimis nationum, quas ego expulsurus sum ante vos. Omnia enim hæc fecerunt, et abominatus sum eas. ");
INSERT INTO latVUC_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Vobis autem loquor. Possidete terram eorum, quam dabo vobis in hæreditatem, terram fluentem lacte et melle. Ego Dominus Deus vester, qui separavi vos a ceteris populis. ");
INSERT INTO latVUC_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Separate ergo et vos jumentum mundum ab immundo, et avem mundam ab immunda: ne polluatis animas vestras in pecore, et avibus, et cunctis quæ moventur in terra, et quæ vobis ostendi esse polluta. ");
INSERT INTO latVUC_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Eritis mihi sancti, quia sanctus sum ego Dominus, et separavi vos a ceteris populis, ut essetis mei. ");
INSERT INTO latVUC_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Vir, sive mulier, in quibus pythonicus, vel divinationis fuerit spiritus, morte moriantur: lapidibus obruent eos: sanguis eorum sit super illos. ");
INSERT INTO latVUC_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Dixit quoque Dominus ad Moysen: Loquere ad sacerdotes filios Aaron, et dices ad eos: Ne contaminetur sacerdos in mortibus civium suorum, ");
INSERT INTO latVUC_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","nisi tantum in consanguineis, ac propinquis, id est, super patre et matre, et filio, et filia, fratre quoque, ");
INSERT INTO latVUC_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","et sorore virgine quæ non est nupta viro: ");
INSERT INTO latVUC_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","sed nec in principe populi sui contaminabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Non radent caput, nec barbam, neque in carnibus suis facient incisuras. ");
INSERT INTO latVUC_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Sancti erunt Deo suo, et non polluent nomen ejus: incensum enim Domini, et panes Dei sui offerunt, et ideo sancti erunt. ");
INSERT INTO latVUC_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Scortum et vile prostibulum non ducent uxorem, nec eam quæ repudiata est a marito: quia consecrati sunt Deo suo, ");
INSERT INTO latVUC_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","et panes propositionis offerunt. Sint ergo sancti, quia et ego sanctus sum, Dominus qui sanctifico eos. ");
INSERT INTO latVUC_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Sacerdotis filia si deprehensa fuerit in stupro, et violaverit nomen patris sui, flammis exuretur. ");
INSERT INTO latVUC_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Pontifex, id est, sacerdos maximus inter fratres suos, super cujus caput fusum est unctionis oleum, et cujus manus in sacerdotio consecratæ sunt, vestitusque est sanctis vestibus, caput suum non discooperiet, vestimenta non scindet: ");
INSERT INTO latVUC_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","et ad omnem mortuum non ingredietur omnino: super patre quoque suo et matre non contaminabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Nec egredietur de sanctis, ne polluat sanctuarium Domini, quia oleum sanctæ unctionis Dei sui super eum est. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Virginem ducet uxorem: ");
INSERT INTO latVUC_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","viduam autem et repudiatam, et sordidam, atque meretricem non accipiet, sed puellam de populo suo: ");
INSERT INTO latVUC_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ne commisceat stirpem generis sui vulgo gentis suæ: quia ego Dominus, qui sanctifico eum. ");
INSERT INTO latVUC_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Loquere ad Aaron: Homo de semine tuo per familias qui habuerit maculam, non offeret panes Deo suo, ");
INSERT INTO latVUC_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","nec accedet ad ministerium ejus: si cæcus fuerit, si claudus, si parvo vel grandi, vel torto naso, ");
INSERT INTO latVUC_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","si fracto pede, si manu, ");
INSERT INTO latVUC_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","si gibbus, si lippus, si albuginem habens in oculo, si jugem scabiem, si impetiginem in corpore, vel herniosus. ");
INSERT INTO latVUC_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Omnis qui habuerit maculam de semine Aaron sacerdotis, non accedet offerre hostias Domino, nec panes Deo suo: ");
INSERT INTO latVUC_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","vescetur tamen panibus qui offeruntur in sanctuario, ");
INSERT INTO latVUC_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ita dumtaxat, ut intra velum non ingrediatur, nec accedat ad altare, quia maculam habet, et contaminare non debet sanctuarium meum. Ego Dominus qui sanctifico eos. ");
INSERT INTO latVUC_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Locutus est ergo Moyses ad Aaron, et ad filios ejus, et ad omnem Israël cuncta quæ fuerant sibi imperata. ");
INSERT INTO latVUC_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Locutus quoque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Loquere ad Aaron et ad filios ejus, ut caveant ab his quæ consecrata sunt filiorum Israël, et non contaminent nomen sanctificatorum mihi, quæ ipsi offerunt. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Dic ad eos, et ad posteros eorum: Omnis homo qui accesserit de stirpe vestra ad ea quæ consecrata sunt, et quæ obtulerunt filii Israël Domino, in quo est immunditia, peribit coram Domino. Ego sum Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Homo de semine Aaron, qui fuerit leprosus, aut patiens fluxum seminis, non vescetur de his quæ sanctificata sunt mihi, donec sanetur. Qui tetigerit immundum super mortuo, et ex quo egreditur semen quasi coitus, ");
INSERT INTO latVUC_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","et qui tangit reptile, et quodlibet immundum cujus tactus est sordidus, ");
INSERT INTO latVUC_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","immundus erit usque ad vesperum, et non vescetur his quæ sanctificata sunt: sed cum laverit carnem suam aqua, ");
INSERT INTO latVUC_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","et occubuerit sol, tunc mundatus vescetur de sanctificatis, quia cibus illius est. ");
INSERT INTO latVUC_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Morticinum et captum a bestia non comedent, nec polluentur in eis. Ego sum Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Custodiant præcepta mea, ut non subjaceant peccato, et moriantur in sanctuario, cum polluerint illud. Ego Dominus qui sanctifico eos. ");
INSERT INTO latVUC_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Omnis alienigena non comedet de sanctificatis; inquilinus sacerdotis et mercenarius non vescentur ex eis. ");
INSERT INTO latVUC_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Quem autem sacerdos emerit, et qui vernaculus domus ejus fuerit, his comedent ex eis. ");
INSERT INTO latVUC_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si filia sacerdotis cuilibet ex populo nupta fuerit, de his quæ sanctificata sunt, et de primitiis non vescetur. ");
INSERT INTO latVUC_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Sin autem vidua, vel repudiata, et absque liberis reversa fuerit ad domum patris sui: sicut puella consueverat, aletur cibis patris sui. Omnis alienigena comedendi ex eis non habet potestatem. ");
INSERT INTO latVUC_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Qui comederit de sanctificatis per ignorantiam, addet quintam partem cum eo quod comedit, et dabit sacerdoti in sanctuarium. ");
INSERT INTO latVUC_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Nec contaminabunt sanctificata filiorum Israël, quæ offerunt Domino: ");
INSERT INTO latVUC_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ne forte sustineant iniquitatem delicti sui, cum sanctificata comederint. Ego Dominus qui sanctifico eos. ");
INSERT INTO latVUC_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Loquere ad Aaron et filios ejus, et ad omnes filios Israël, dicesque ad eos: Homo de domo Israël, et de advenis qui habitant apud vos, qui obtulerit oblationem suam, vel vota solvens, vel sponte offerens, quidquid illud obtulerit in holocaustum Domini, ");
INSERT INTO latVUC_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ut offeratur per vos, masculus immaculatus erit ex bobus, et ovibus, et ex capris: ");
INSERT INTO latVUC_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","si maculam habuerit, non offeretis, neque erit acceptabile. ");
INSERT INTO latVUC_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Homo qui obtulerit victimam pacificorum Domino, vel vota solvens, vel sponte offerens, tam de bobus quam de ovibus, immaculatum offeret ut acceptabile sit: omnis macula non erit in eo. ");
INSERT INTO latVUC_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Si cæcum fuerit, si fractum, si cicatricem habens, si papulas, aut scabiem, aut impetiginem: non offeretis ea Domino, nec adolebitis ex eis super altare Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Bovem et ovem, aure et cauda amputatis, voluntarie offerre potes, votum autem ex eis solvi non potest. ");
INSERT INTO latVUC_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Omne animal, quod vel contritis, vel tusis, vel sectis ablatisque testiculis est, non offeretis Domino, et in terra vestra hoc omnino ne faciatis. ");
INSERT INTO latVUC_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","De manu alienigenæ non offeretis panes Deo vestro, et quidquid aliud dare voluerit, quia corrupta, et maculata sunt omnia: non suscipietis ea. ");
INSERT INTO latVUC_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Bos, ovis et capra, cum genita fuerint, septem diebus erunt sub ubere matris suæ: die autem octavo, et deinceps, offerri poterunt Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Sive illa bos, sive ovis, non immolabuntur una die cum fœtibus suis. ");
INSERT INTO latVUC_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Si immolaveritis hostiam pro gratiarum actione Domino, ut possit esse placabilis, ");
INSERT INTO latVUC_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","eodem die comedetis eam: non remanebit quidquam in mane alterius diei. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Custodite mandata mea, et facite ea. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ne polluatis nomen meum sanctum, ut sanctificer in medio filiorum Israël. Ego Dominus qui sanctifico vos, ");
INSERT INTO latVUC_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","et eduxi de terra Ægypti, ut essem vobis in Deum. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Loquere filiis Israël, et dices ad eos: Hæ sunt feriæ Domini, quas vocabitis sanctas. ");
INSERT INTO latVUC_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sex diebus facietis opus: dies septimus, quia sabbati requies est, vocabitur sanctus: omne opus non facietis in eo: sabbatum Domini est in cunctis habitationibus vestris. ");
INSERT INTO latVUC_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Hæ sunt ergo feriæ Domini sanctæ, quas celebrare debetis temporibus suis. ");
INSERT INTO latVUC_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Mense primo, quartadecima die mensis ad vesperum, Phase Domini est: ");
INSERT INTO latVUC_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","et quintadecima die mensis hujus, solemnitas azymorum Domini est. Septem diebus azyma comedetis. ");
INSERT INTO latVUC_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Dies primus erit vobis celeberrimus, sanctusque: omne opus servile non facietis in eo, ");
INSERT INTO latVUC_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","sed offeretis sacrificium in igne Domino septem diebus. Dies autem septimus erit celebrior et sanctior: nullumque servile opus facietis in eo. ");
INSERT INTO latVUC_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Loquere filiis Israël, et dices ad eos: Cum ingressi fueritis terram, quam ego dabo vobis, et messueritis segetem, feretis manipulos spicarum, primitias messis vestræ, ad sacerdotem: ");
INSERT INTO latVUC_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","qui elevabit fasciculum coram Domino, ut acceptabile sit pro vobis, altero die sabbati, et sanctificabit illum. ");
INSERT INTO latVUC_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Atque in eodem die quo manipulus consecratur, cædetur agnus immaculatus anniculus in holocaustum Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Et libamenta offerentur cum eo, duæ decimæ similæ conspersæ oleo in incensum Domini, odoremque suavissimum: liba quoque vini, quarta pars hin. ");
INSERT INTO latVUC_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Panem, et polentam, et pultes non comedetis ex segete, usque ad diem qua offeretis ex ea Deo vestro. Præceptum est sempiternum in generationibus, cunctisque habitaculis vestris. ");
INSERT INTO latVUC_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Numerabitis ergo ab altero die sabbati, in quo obtulistis manipulum primitiarum, septem hebdomadas plenas, ");
INSERT INTO latVUC_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","usque ad alteram diem expletionis hebdomadæ septimæ, id est, quinquaginta dies: et sic offeretis sacrificium novum Domino ");
INSERT INTO latVUC_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ex omnibus habitaculis vestris, panes primitiarum duos de duabus decimis similæ fermentatæ, quos coquetis in primitias Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Offeretisque cum panibus septem agnos immaculatos anniculos, et vitulum de armento unum, et arietes duos, et erunt in holocaustum cum libamentis suis, in odorem suavissimum Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Facietis et hircum pro peccato, duosque agnos anniculos hostias pacificorum. ");
INSERT INTO latVUC_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Cumque elevaverit eos sacerdos cum panibus primitiarum coram Domino, cedent in usum ejus. ");
INSERT INTO latVUC_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Et vocabitis hunc diem celeberrimum, atque sanctissimum: omne opus servile non facietis in eo. Legitimum sempiternum erit in cunctis habitaculis, et generationibus vestris. ");
INSERT INTO latVUC_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Postquam autem messueritis segetem terræ vestræ, nec secabitis eam usque ad solum, nec remanentes spicas colligetis: sed pauperibus et peregrinis dimittetis eas. Ego sum Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Loquere filiis Israël: Mense septimo, prima die mensis, erit vobis sabbatum, memoriale, clangentibus tubis, et vocabitur sanctum: ");
INSERT INTO latVUC_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","omne opus servile non facietis in eo, et offeretis holocaustum Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Decimo die mensis hujus septimi, dies expiationum erit celeberrimus, et vocabitur sanctus: affligetisque animas vestras in eo, et offeretis holocaustum Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Omne opus servile non facietis in tempore diei hujus: quia dies propitiationis est, ut propitietur vobis Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Omnis anima, quæ afflicta non fuerit die hac, peribit de populis suis: ");
INSERT INTO latVUC_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","et quæ operis quippiam fecerit, delebo eam de populo suo. ");
INSERT INTO latVUC_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Nihil ergo operis facietis in eo: legitimum sempiternum erit vobis in cunctis generationibus, et habitationibus vestris. ");
INSERT INTO latVUC_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Sabbatum requietionis est, et affligetis animas vestras die nono mensis: a vespera usque ad vesperam celebrabitis sabbata vestra. ");
INSERT INTO latVUC_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Et locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Loquere filiis Israël: A quintodecimo die mensis hujus septimi, erunt feriæ tabernaculorum septem diebus Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Dies primus vocabitur celeberrimus atque sanctissimus: omne opus servile non facietis in eo. ");
INSERT INTO latVUC_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Et septem diebus offeretis holocausta Domino. Dies quoque octavus erit celeberrimus, atque sanctissimus, et offeretis holocaustum Domino: est enim cœtus atque collectæ: omne opus servile non facietis in eo. ");
INSERT INTO latVUC_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Hæ sunt feriæ Domini, quas vocabitis celeberrimas atque sanctissimas, offeretisque in eis oblationes Domino, holocausta et libamenta juxta ritum uniuscujusque diei: ");
INSERT INTO latVUC_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","exceptis sabbatis Domini, donisque vestris, et quæ offeretis ex voto, vel quæ sponte tribuetis Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","A quintodecimo ergo die mensis septimi, quando congregaveritis omnes fructus terræ vestræ, celebrabitis ferias Domini septem diebus: die primo et die octavo erit sabbatum, id est, requies. ");
INSERT INTO latVUC_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Sumetisque vobis die primo fructus arboris pulcherrimæ, spatulasque palmarum, et ramos ligni densarum frondium, et salices de torrente, et lætabimini coram Domino Deo vestro. ");
INSERT INTO latVUC_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Celebrabitisque solemnitatem ejus septem diebus per annum: legitimum sempiternum erit in generationibus vestris. Mense septimo festa celebrabitis, ");
INSERT INTO latVUC_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","et habitabitis in umbraculis septem diebus: omnis, qui de genere est Israël, manebit in tabernaculis, ");
INSERT INTO latVUC_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ut discant posteri vestri quod in tabernaculis habitare fecerim filios Israël, cum educerem eos de terra Ægypti. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Locutusque est Moyses super solemnitatibus Domini ad filios Israël. ");
INSERT INTO latVUC_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Et locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Præcipe filiis Israël, ut afferant tibi oleum de olivis purissimum, ac lucidum, ad concinnandas lucernas jugiter, ");
INSERT INTO latVUC_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","extra velum testimonii in tabernaculo fœderis. Ponetque eas Aaron a vespere usque ad mane coram Domino, cultu rituque perpetuo in generationibus vestris. ");
INSERT INTO latVUC_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Super candelabrum mundissimum ponentur semper in conspectu Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Accipies quoque similam, et coques ex ea duodecim panes, qui singuli habebunt duas decimas: ");
INSERT INTO latVUC_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","quorum senos altrinsecus super mensam purissimam coram Domino statues: ");
INSERT INTO latVUC_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","et pones super eos thus lucidissimum, ut sit panis in monimentum oblationis Domini. ");
INSERT INTO latVUC_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Per singula sabbata mutabuntur coram Domino suscepti a filiis Israël fœdere sempiterno: ");
INSERT INTO latVUC_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","eruntque Aaron et filiorum ejus, ut comedant eos in loco sancto: quia Sanctum sanctorum est de sacrificiis Domini jure perpetuo. ");
INSERT INTO latVUC_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ecce autem egressus filius mulieris Israëlitidis, quem pepererat de viro ægyptio inter filios Israël, jurgatus est in castris cum viro Israëlita. ");
INSERT INTO latVUC_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Cumque blasphemasset nomen, et maledixisset ei, adductus est ad Moysen. (Vocabatur autem mater ejus Salumith, filia Dabri de tribu Dan.) ");
INSERT INTO latVUC_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Miseruntque eum in carcerem, donec nossent quid juberet Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Qui locutus est ad Moysen, ");
INSERT INTO latVUC_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","dicens: Educ blasphemum extra castra, et ponant omnes qui audierunt, manus suas super caput ejus, et lapidet eum populus universus. ");
INSERT INTO latVUC_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Et ad filios Israël loqueris: Homo, qui maledixerit Deo suo, portabit peccatum suum; ");
INSERT INTO latVUC_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","et qui blasphemaverit nomen Domini, morte moriatur: lapidibus opprimet eum omnis multitudo, sive ille civis, sive peregrinus fuerit. Qui blasphemaverit nomen Domini, morte moriatur. ");
INSERT INTO latVUC_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Qui percusserit, et occiderit hominem, morte moriatur. ");
INSERT INTO latVUC_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Qui percusserit animal, reddet vicarium, id est, animam pro anima. ");
INSERT INTO latVUC_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Qui irrogaverit maculam cuilibet civium suorum, sicut fecit, sic fiet ei: ");
INSERT INTO latVUC_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fracturam pro fractura, oculum pro oculo, dentem pro dente restituet: qualem inflixerit maculam, talem sustinere cogetur. ");
INSERT INTO latVUC_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Qui percusserit jumentum, reddet aliud. Qui percusserit hominem, punietur. ");
INSERT INTO latVUC_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Æquum judicium sit inter vos, sive peregrinus, sive civis peccaverit: quia ego sum Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Locutusque est Moyses ad filios Israël: et eduxerunt eum, qui blasphemaverat, extra castra, ac lapidibus oppresserunt. Feceruntque filii Israël sicut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Locutusque est Dominus ad Moysen in monte Sinai, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Loquere filiis Israël, et dices ad eos: Quando ingressi fueritis terram quam ego dabo vobis, sabbatizes sabbatum Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sex annis seres agrum tuum, et sex annis putabis vineam tuam, colligesque fructus ejus: ");
INSERT INTO latVUC_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","septimo autem anno sabbatum erit terræ, requietionis Domini: agrum non seres, et vineam non putabis. ");
INSERT INTO latVUC_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Quæ sponte gignet humus, non metes: et uvas primitiarum tuarum non colliges quasi vindemiam: annus enim requietionis terræ est: ");
INSERT INTO latVUC_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","sed erunt vobis in cibum, tibi et servo tuo, ancillæ et mercenario tuo, et advenæ qui peregrinantur apud te: ");
INSERT INTO latVUC_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","jumentis tuis et pecoribus, omnia quæ nascuntur præbebunt cibum. ");
INSERT INTO latVUC_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Numerabis quoque tibi septem hebdomadas annorum, id est, septies septem, quæ simul faciunt annos quadraginta novem: ");
INSERT INTO latVUC_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","et clanges buccina mense septimo, decima die mensis, propitiationis tempore, in universa terra vestra. ");
INSERT INTO latVUC_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Sanctificabisque annum quinquagesimum, et vocabis remissionem cunctis habitatoribus terræ tuæ: ipse est enim jubilæus. Revertetur homo ad possessionem suam, et unusquisque rediet ad familiam pristinam: ");
INSERT INTO latVUC_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","quia jubilæus est, et quinquagesimus annus. Non seretis neque metetis sponte in agro nascentia, et primitias vindemiæ non colligetis, ");
INSERT INTO latVUC_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ob sanctificationem jubilæi: sed statim oblata comedetis. ");
INSERT INTO latVUC_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Anno jubilæi, redient omnes ad possessiones suas. ");
INSERT INTO latVUC_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Quando vendes quippiam civi tuo, vel emes ab eo, ne contristes fratrem tuum, sed juxta numerum annorum jubilæi emes ab eo, ");
INSERT INTO latVUC_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","et juxta supputationem frugum vendet tibi. ");
INSERT INTO latVUC_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Quanto plures anni remanserint post jubilæum, tanto crescet et pretium: et quanto minus temporis numeraveris, tanto minoris et emptio constabit: tempus enim frugum vendet tibi. ");
INSERT INTO latVUC_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Nolite affligere contribules vestros, sed timeat unusquisque Deum suum, quia ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Facite præcepta mea, et judicia custodite, et implete ea: ut habitare possitis in terra absque ullo pavore, ");
INSERT INTO latVUC_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","et gignat vobis humus fructus suos, quibus vescamini usque ad saturitatem, nullius impetum formidantes. ");
INSERT INTO latVUC_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Quod si dixeritis: Quid comedemus anno septimo, si non severimus, neque collegerimus fruges nostras? ");
INSERT INTO latVUC_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","dabo benedictionem meam vobis anno sexto, et faciet fructus trium annorum: ");
INSERT INTO latVUC_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","seretisque anno octavo, et comedetis veteres fruges usque ad nonum annum: donec nova nascantur, edetis vetera. ");
INSERT INTO latVUC_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Terra quoque non vendetur in perpetuum, quia mea est, et vos advenæ et coloni mei estis: ");
INSERT INTO latVUC_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","unde cuncta regio possessionis vestræ sub redemptionis conditione vendetur. ");
INSERT INTO latVUC_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Si attenuatus frater tuus vendiderit possessiunculam suam, et voluerit propinquus ejus, potest redimere quod ille vendiderat. ");
INSERT INTO latVUC_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Sin autem non habuerit proximum, et ipse pretium ad redimendum potuerit invenire, ");
INSERT INTO latVUC_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","computabuntur fructus ex eo tempore quo vendidit: et quod reliquum est, reddet emptori, sicque recipiet possessionem suam. ");
INSERT INTO latVUC_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Quod si non invenerit manus ejus ut reddat pretium, habebit emptor quod emerat, usque ad annum jubilæum. In ipso enim omnis venditio redibit ad dominum et ad possessorem pristinum. ");
INSERT INTO latVUC_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Qui vendiderit domum intra urbis muros, habebit licentiam redimendi, donec unus impleatur annus. ");
INSERT INTO latVUC_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Si non redemerit, et anni circulus fuerit evolutus, emptor possidebit eam, et posteri ejus in perpetuum, et redimi non poterit, etiam in jubilæo. ");
INSERT INTO latVUC_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Sin autem in villa domus, quæ muros non habet, agrorum jure vendetur: si ante redempta non fuerit, in jubilæo revertetur ad dominum. ");
INSERT INTO latVUC_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ædes Levitarum quæ in urbibus sunt, semper possunt redimi: ");
INSERT INTO latVUC_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","si redemptæ non fuerint, in jubilæo revertentur ad dominos, quia domus urbium Levitarum pro possessionibus sunt inter filios Israël. ");
INSERT INTO latVUC_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Suburbana autem eorum non veneant, quia possessio sempiterna est. ");
INSERT INTO latVUC_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Si attenuatus fuerit frater tuus, et infirmus manu, et susceperis eum quasi advenam et peregrinum, et vixerit tecum, ");
INSERT INTO latVUC_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ne accipias usuras ab eo, nec amplius quam dedisti: time Deum tuum, ut vivere possit frater tuus apud te. ");
INSERT INTO latVUC_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Pecuniam tuam non dabis ei ad usuram, et frugum superabundantiam non exiges. ");
INSERT INTO latVUC_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ego Dominus Deus vester, qui eduxi vos de terra Ægypti, ut darem vobis terram Chanaan, et essem vester Deus. ");
INSERT INTO latVUC_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Si paupertate compulsus vendiderit se tibi frater tuus, non eum opprimes servitute famulorum, ");
INSERT INTO latVUC_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","sed quasi mercenarius et colonus erit: usque ad annum jubilæum operabitur apud te, ");
INSERT INTO latVUC_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","et postea egredietur cum liberis suis, et revertetur ad cognationem, ad possessionem patrum suorum. ");
INSERT INTO latVUC_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Mei enim servi sunt, et ego eduxi eos de terra Ægypti: non veneant conditione servorum: ");
INSERT INTO latVUC_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ne affligas eum per potentiam, sed metuito Deum tuum. ");
INSERT INTO latVUC_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Servus et ancilla sint vobis de nationibus quæ in circuitu vestro sunt: ");
INSERT INTO latVUC_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","et de advenis qui peregrinantur apud vos, vel qui ex his nati fuerint in terra vestra, hos habebitis famulos: ");
INSERT INTO latVUC_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","et hæreditario jure transmittetis ad posteros, ac possidebitis in æternum: fratres autem vestros filios Israël ne opprimatis per potentiam. ");
INSERT INTO latVUC_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Si invaluerit apud vos manus advenæ atque peregrini, et attenuatus frater tuus vendiderit se ei, aut cuiquam de stirpe ejus: ");
INSERT INTO latVUC_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","post venditionem potest redimi. Qui voluerit ex fratribus suis, redimet eum, ");
INSERT INTO latVUC_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","et patruus, et patruelis, et consanguineus, et affinis. Sin autem et ipse potuerit, redimet se, ");
INSERT INTO latVUC_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","supputatis dumtaxat annis a tempore venditionis suæ usque ad annum jubilæum: et pecunia, qua venditus fuerat, juxta annorum numerum, et rationem mercenarii supputata. ");
INSERT INTO latVUC_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Si plures fuerint anni qui remanent usque ad jubilæum, secundum hos reddet et pretium: ");
INSERT INTO latVUC_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","si pauci, ponet rationem cum eo juxta annorum numerum, et reddet emptori quod reliquum est annorum, ");
INSERT INTO latVUC_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","quibus ante servivit mercedibus imputatis: non affliget eum violenter in conspectu tuo. ");
INSERT INTO latVUC_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Quod si per hæc redimi non potuerit, anno jubilæo egredietur cum liberis suis. ");
INSERT INTO latVUC_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Mei enim sunt servi filii Israël, quos eduxi de terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ego Dominus Deus vester: non facietis vobis idolum, et sculptile, nec titulos erigetis, nec insignem lapidem ponetis in terra vestra, ut adoretis eum. Ego enim sum Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Custodite sabbata mea, et pavete ad sanctuarium meum. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Si in præceptis meis ambulaveritis, et mandata mea custodieritis, et feceritis ea, dabo vobis pluvias temporibus suis, ");
INSERT INTO latVUC_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","et terra gignet germen suum, et pomis arbores replebuntur. ");
INSERT INTO latVUC_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Apprehendet messium tritura vindemiam, et vindemia occupabit sementem: et comedetis panem vestrum in saturitate, et absque pavore habitabitis in terra vestra. ");
INSERT INTO latVUC_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Dabo pacem in finibus vestris: dormietis, et non erit qui exterreat. Auferam malas bestias, et gladius non transibit terminos vestros. ");
INSERT INTO latVUC_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Persequemini inimicos vestros, et corruent coram vobis. ");
INSERT INTO latVUC_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Persequentur quinque de vestris centum alienos, et centum de vobis decem millia: cadent inimici vestri gladio in conspectu vestro. ");
INSERT INTO latVUC_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Respiciam vos, et crescere faciam: multiplicabimini, et firmabo pactum meum vobiscum. ");
INSERT INTO latVUC_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Comedetis vetustissima veterum, et vetera novis supervenientibus projicietis. ");
INSERT INTO latVUC_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ponam tabernaculum meum in medio vestri, et non abjiciet vos anima mea. ");
INSERT INTO latVUC_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ambulabo inter vos, et ero Deus vester, vosque eritis populus meus. ");
INSERT INTO latVUC_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ego Dominus Deus vester, qui eduxi vos de terra Ægyptiorum, ne serviretis eis: et qui confregi catenas cervicum vestrarum, ut incederetis erecti. ");
INSERT INTO latVUC_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Quod si non audieritis me, nec feceritis omnia mandata mea, ");
INSERT INTO latVUC_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","si spreveritis leges meas, et judicia mea contempseritis, ut non faciatis ea quæ a me constituta sunt, et ad irritum perducatis pactum meum: ");
INSERT INTO latVUC_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ego quoque hæc faciam vobis: visitabo vos velociter in egestate, et ardore, qui conficiat oculos vestros, et consumat animas vestras. Frustra seretis sementem, quæ ab hostibus devorabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ponam faciem meam contra vos, et corruetis coram hostibus vestris, et subjiciemini his qui oderunt vos: fugietis, nemine persequente. ");
INSERT INTO latVUC_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Sin autem nec sic obedieritis mihi, addam correptiones vestras septuplum propter peccata vestra, ");
INSERT INTO latVUC_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","et conteram superbiam duritiæ vestræ. Daboque vobis cælum desuper sicut ferrum, et terram æneam. ");
INSERT INTO latVUC_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Consumetur incassum labor vester, non proferet terra germen, nec arbores poma præbebunt. ");
INSERT INTO latVUC_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Si ambulaveritis ex adverso mihi, nec volueritis audire me, addam plagas vestras in septuplum propter peccata vestra: ");
INSERT INTO latVUC_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","immittamque in vos bestias agri, quæ consumant vos, et pecora vestra, et ad paucitatem cuncta redigant, desertæque fiant viæ vestræ. ");
INSERT INTO latVUC_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Quod si nec sic volueritis recipere disciplinam, sed ambulaveritis ex adverso mihi: ");
INSERT INTO latVUC_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ego quoque contra vos adversus incedam, et percutiam vos septies propter peccata vestra, ");
INSERT INTO latVUC_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","inducamque super vos gladium ultorem fœderis mei. Cumque confugeritis in urbes, mittam pestilentiam in medio vestri, et trademini in manibus hostium, ");
INSERT INTO latVUC_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","postquam confregero baculum panis vestri: ita ut decem mulieres in uno clibano coquant panes, et reddant eos ad pondus: et comedetis, et non saturabimini. ");
INSERT INTO latVUC_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Sin autem nec per hæc audieritis me, sed ambulaveritis contra me: ");
INSERT INTO latVUC_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","et ego incedam adversus vos in furore contrario, et corripiam vos septem plagis propter peccata vestra: ");
INSERT INTO latVUC_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ita ut comedatis carnes filiorum vestrorum et filiarum vestrarum. ");
INSERT INTO latVUC_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Destruam excelsa vestra, et simulacra confringam. Cadetis inter ruinas idolorum vestrorum, et abominabitur vos anima mea, ");
INSERT INTO latVUC_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","in tantum ut urbes vestras redigam in solitudinem, et deserta faciam sanctuaria vestra, nec recipiam ultra odorem suavissimum. ");
INSERT INTO latVUC_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Disperdamque terram vestram, et stupebunt super ea inimici vestri, cum habitatores illius fuerint. ");
INSERT INTO latVUC_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Vos autem dispergam in gentes, et evaginabo post vos gladium, eritque terra vestra deserta, et civitates vestræ dirutæ. ");
INSERT INTO latVUC_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Tunc placebunt terræ sabbata sua cunctis diebus solitudinis suæ: quando fueritis ");
INSERT INTO latVUC_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","in terra hostili, sabbatizabit, et requiescet in sabbatis solitudinis suæ, eo quod non requieverit in sabbatis vestris quando habitabatis in ea. ");
INSERT INTO latVUC_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Et qui de vobis remanserint, dabo pavorem in cordibus eorum in regionibus hostium, terrebit eos sonitus folii volantis, et ita fugient quasi gladium: cadent, nullo persequente, ");
INSERT INTO latVUC_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","et corruent singuli super fratres suos, quasi bella fugientes, nemo vestrum inimicis audebit resistere. ");
INSERT INTO latVUC_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Peribitis inter gentes, et hostilis vos terra consumet. ");
INSERT INTO latVUC_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Quod si et de iis aliqui remanserint, tabescent in iniquitatibus suis, in terra inimicorum suorum, et propter peccata patrum suorum et sua affligentur: ");
INSERT INTO latVUC_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","donec confiteantur iniquitates suas, et majorum suorum, quibus prævaricati sunt in me, et ambulaverunt ex adverso mihi. ");
INSERT INTO latVUC_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Ambulabo igitur et ego contra eos, et inducam illos in terram hostilem, donec erubescat incircumcisa mens eorum: tunc orabunt pro impietatibus suis. ");
INSERT INTO latVUC_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Et recordabor fœderis mei, quod pepigi cum Jacob, et Isaac, et Abraham. Terræ quoque memor ero: ");
INSERT INTO latVUC_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","quæ cum relicta fuerit ab eis, complacebit sibi in sabbatis suis, patiens solitudinem propter illos. Ipsi vero rogabunt pro peccatis suis, eo quod abjecerint judicia mea, et leges meas despexerint. ");
INSERT INTO latVUC_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Et tamen etiam cum essent in terra hostili, non penitus abjeci eos, neque sic despexi ut consumerentur, et irritum facerent pactum meum cum eis. Ego enim sum Dominus Deus eorum, ");
INSERT INTO latVUC_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","et recordabor fœderis mei pristini, quando eduxi eos de terra Ægypti in conspectu gentium, ut essem Deus eorum. Ego Dominus. Hæc sunt judicia atque præcepta et leges quas dedit Dominus inter se et filios Israël in monte Sinai per manum Moysi. ");
INSERT INTO latVUC_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Loquere filiis Israël, et dices ad eos: Homo qui votum fecerit, et spoponderit Deo animam suam, sub æstimatione dabit pretium. ");
INSERT INTO latVUC_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Si fuerit masculus a vigesimo anno usque ad sexagesimum annum, dabit quinquaginta siclos argenti ad mensuram sanctuarii: ");
INSERT INTO latVUC_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","si mulier, triginta. ");
INSERT INTO latVUC_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","A quinto autem anno usque ad vigesimum, masculus dabit viginti siclos: femina, decem. ");
INSERT INTO latVUC_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ab uno mense usque ad annum quintum, pro masculo dabuntur quinque sicli: pro femina, tres. ");
INSERT INTO latVUC_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Sexagenarius et ultra masculus dabit quindecim siclos: femina, decem. ");
INSERT INTO latVUC_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Si pauper fuerit, et æstimationem reddere non valebit, stabit coram sacerdote: et quantum ille æstimaverit, et viderit eum posse reddere, tantum dabit. ");
INSERT INTO latVUC_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Animal autem, quod immolari potest Domino, si quis voverit, sanctum erit, ");
INSERT INTO latVUC_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","et mutari non poterit, id est, nec melius malo, nec pejus bono: quod si mutaverit, et ipsum quod mutatum est, et illud pro quo mutatum est, consecratum erit Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Animal immundum, quod immolari Domino non potest, si quis voverit, adducetur ante sacerdotem: ");
INSERT INTO latVUC_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","qui judicans utrum bonum an malum sit, statuet pretium. ");
INSERT INTO latVUC_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Quod si dare voluerit is qui offert, addet supra æstimationem quintam partem. ");
INSERT INTO latVUC_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Homo si voverit domum suam, et sanctificaverit Domino, considerabit eam sacerdos utrum bona an mala sit, et juxta pretium, quod ab eo fuerit constitutum, venundabitur: ");
INSERT INTO latVUC_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","sin autem ille qui voverat, voluerit redimere eam, dabit quintam partem æstimationis supra, et habebit domum. ");
INSERT INTO latVUC_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Quod si agrum possessionis suæ voverit, et consecraverit Domino, juxta mensuram sementis æstimabitur pretium: si triginta modiis hordei seritur terra, quinquaginta siclis venundetur argenti. ");
INSERT INTO latVUC_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Si statim ab anno incipientis jubilæi voverit agrum, quanto valere potest, tanto æstimabitur. ");
INSERT INTO latVUC_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Sin autem post aliquantum temporis, supputabit sacerdos pecuniam juxta annorum, qui reliqui sunt, numerum usque ad jubilæum, et detrahetur ex pretio. ");
INSERT INTO latVUC_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Quod si voluerit redimere agrum ille qui voverat, addet quintam partem æstimatæ pecuniæ, et possidebit eum. ");
INSERT INTO latVUC_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Sin autem noluerit redimere, sed alteri cuilibet fuerit venundatus, ultra eum qui voverat redimere non poterit. ");
INSERT INTO latVUC_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Quia cum jubilæi venerit dies, sanctificatus erit Domino, et possessio consecrata ad jus pertinet sacerdotum. ");
INSERT INTO latVUC_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Si ager emptus est, et non de possessione majorum sanctificatus fuerit Domino, ");
INSERT INTO latVUC_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","supputabit sacerdos juxta annorum numerum usque ad jubilæum, pretium: et dabit ille qui voverat eum, Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In jubilæo autem revertetur ad priorem dominum, qui vendiderat eum, et habuerat in sorte possessionis suæ. ");
INSERT INTO latVUC_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Omnis æstimatio siclo sanctuarii ponderabitur. Siclus viginti obolos habet. ");
INSERT INTO latVUC_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Primogenita, quæ ad Dominum pertinent, nemo sanctificare poterit et vovere: sive bos, sive ovis fuerit, Domini sunt. ");
INSERT INTO latVUC_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Quod si immundum est animal, redimet qui obtulit, juxta æstimationem tuam, et addet quintam partem pretii: si redimere noluerit, vendetur alteri quantocumque a te fuerit æstimatum. ");
INSERT INTO latVUC_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Omne quod Domino consecratur, sive homo fuerit, sive animal, sive ager, non vendetur, nec redimi poterit. Quidquid semel fuerit consecratum, Sanctum sanctorum erit Domino: ");
INSERT INTO latVUC_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","et omnis consecratio, quæ offertur ab homine, non redimetur, sed morte morietur. ");
INSERT INTO latVUC_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Omnes decimæ terræ, sive de frugibus, sive de pomis arborum, Domini sunt, et illi sanctificantur. ");
INSERT INTO latVUC_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Si quis autem voluerit redimere decimas suas, addet quintam partem earum. ");
INSERT INTO latVUC_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Omnium decimarum bovis et ovis et capræ, quæ sub pastoris virga transeunt, quidquid decimum venerit, sanctificabitur Domino. ");
INSERT INTO latVUC_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Non eligetur nec bonum nec malum, nec altero commutabitur, si quis mutaverit: et quod mutatum est, et pro quo mutatum est, sanctificabitur Domino, et non redimetur. ");
INSERT INTO latVUC_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Hæc sunt præcepta, quæ mandavit Dominus Moysi ad filios Israël in monte Sinai. ");
INSERT INTO latVUC_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Locutusque est Dominus ad Moysen in deserto Sinai in tabernaculo fœderis, prima die mensis secundi, anno altero egressionis eorum ex Ægypto, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Tollite summam universæ congregationis filiorum Israël per cognationes et domos suas, et nomina singulorum, quidquid sexus est masculini ");
INSERT INTO latVUC_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","a vigesimo anno et supra, omnium virorum fortium ex Israël, et numerabitis eos per turmas suas, tu et Aaron. ");
INSERT INTO latVUC_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Eruntque vobiscum principes tribuum ac domorum in cognationibus suis, ");
INSERT INTO latVUC_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","quorum ista sunt nomina: de Ruben, Elisur, filius Sedeur; ");
INSERT INTO latVUC_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","de Simeon, Salamiel filius Surisaddai; ");
INSERT INTO latVUC_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","de Juda, Nahasson filius Aminadab; ");
INSERT INTO latVUC_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","de Issachar, Nathanaël filius Suar; ");
INSERT INTO latVUC_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","de Zabulon, Eliab filius Helon; ");
INSERT INTO latVUC_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","filiorum autem Joseph, de Ephraim, Elisama filius Ammiud; de Manasse, Gamaliel filius Phadassur; ");
INSERT INTO latVUC_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","de Benjamin, Abidan filius Gedeonis; ");
INSERT INTO latVUC_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","de Dan, Ahiezer filius Ammisaddai; ");
INSERT INTO latVUC_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","de Aser, Phegiel filius Ochran; ");
INSERT INTO latVUC_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","de Gad, Eliasaph filius Duel; ");
INSERT INTO latVUC_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","de Nephthali, Ahira filius Enan. ");
INSERT INTO latVUC_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Hi nobilissimi principes multitudinis per tribus et cognationes suas, et capita exercitus Israël, ");
INSERT INTO latVUC_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","quos tulerunt Moyses et Aaron cum omni vulgi multitudine: ");
INSERT INTO latVUC_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","et congregaverunt primo die mensis secundi, recensentes eos per cognationes, et domos, ac familias, et capita, et nomina singulorum a vigesimo anno et supra, ");
INSERT INTO latVUC_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","sicut præceperat Dominus Moysi. Numeratique sunt in deserto Sinai. ");
INSERT INTO latVUC_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","De Ruben primogenito Israëlis per generationes et familias ac domos suas, et nomina capitum singulorum, omne quod sexus est masculini a vigesimo anno et supra, procedentium ad bellum, ");
INSERT INTO latVUC_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","quadraginta sex millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","De filiis Simeon per generationes et familias ac domos cognationum suarum recensiti sunt per nomina et capita singulorum, omne quod sexus est masculini a vigesimo anno et supra, procedentium ad bellum, ");
INSERT INTO latVUC_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","quinquaginta novem millia trecenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","De filiis Gad per generationes et familias ac domos cognationum suarum recensiti sunt per nomina singulorum a viginti annis et supra, omnes qui ad bella procederent, ");
INSERT INTO latVUC_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","quadraginta quinque millia sexcenti quinquaginta. ");
INSERT INTO latVUC_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","De filiis Juda per generationes et familias ac domos cognationum suarum, per nomina singulorum a vigesimo anno et supra, omnes qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","recensiti sunt septuaginta quatuor millia sexcenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","De filiis Issachar, per generationes et familias ac domos cognationum suarum, per nomina singulorum a vigesimo anno et supra, omnes qui ad bella procederent, ");
INSERT INTO latVUC_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","recensiti sunt quinquaginta quatuor millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","De filiis Zabulon per generationes et familias ac domos cognationum suarum recensiti sunt per nomina singulorum a vigesimo anno et supra, omnes qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","quinquaginta septem millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","De filiis Joseph, filiorum Ephraim per generationes et familias ac domos cognationum suarum recensiti sunt per nomina singulorum a vigesimo anno et supra, omnes qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","quadraginta millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Porro filiorum Manasse per generationes et familias ac domos cognationum suarum recensiti sunt per nomina singulorum a viginti annis et supra, omnes qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","triginta duo millia ducenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","De filiis Benjamin per generationes et familias ac domos cognationum suarum recensiti sunt nominibus singulorum a vigesimo anno et supra, omnes qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","triginta quinque millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","De filiis Dan per generationes et familias ac domos cognationum suarum recensiti sunt nominibus singulorum a vigesimo anno et supra, omnes qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","sexaginta duo millia septingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","De filiis Aser per generationes et familias ac domos cognationum suarum recensiti sunt per nomina singulorum a vigesimo anno et supra, omnes qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","quadraginta millia et mille quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","De filiis Nephthali per generationes et familias ac domos cognationum suarum recensiti sunt nominibus singulorum a vigesimo anno et supra, omnes qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","quinquaginta tria millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Hi sunt, quos numeraverunt Moyses et Aaron, et duodecim principes Israël, singulos per domos cognationum suarum. ");
INSERT INTO latVUC_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Fueruntque omnis numerus filiorum Israël per domos et familias suas a vigesimo anno et supra, qui poterant ad bella procedere, ");
INSERT INTO latVUC_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","sexcenta tria millia virorum quingenti quinquaginta. ");
INSERT INTO latVUC_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Levitæ autem in tribu familiarum suarum non sunt numerati cum eis. ");
INSERT INTO latVUC_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Tribum Levi noli numerare, neque pones summam eorum cum filiis Israël: ");
INSERT INTO latVUC_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","sed constitue eos super tabernaculum testimonii et cuncta vasa ejus, et quidquid ad cæremonias pertinet. Ipsi portabunt tabernaculum et omnia utensilia ejus: et erunt in ministerio, ac per gyrum tabernaculi metabuntur. ");
INSERT INTO latVUC_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Cum proficiscendum fuerit, deponent Levitæ tabernaculum; cum castrametandum, erigent. Quisquis externorum accesserit, occidetur. ");
INSERT INTO latVUC_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Metabuntur autem castra filii Israël unusquisque per turmas et cuneos atque exercitum suum. ");
INSERT INTO latVUC_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Porro Levitæ per gyrum tabernaculi figent tentoria, ne fiat indignatio super multitudinem filiorum Israël, et excubabunt in custodiis tabernaculi testimonii. ");
INSERT INTO latVUC_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Fecerunt ergo filii Israël juxta omnia quæ præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Locutusque est Dominus ad Moysen et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Singuli per turmas, signa, atque vexilla, et domos cognationum suarum, castrametabuntur filii Israël, per gyrum tabernaculi fœderis. ");
INSERT INTO latVUC_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ad orientem Judas figet tentoria per turmas exercitus sui: eritque princeps filiorum ejus Nahasson filius Aminadab. ");
INSERT INTO latVUC_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Et omnis de stirpe ejus summa pugnantium, septuaginta quatuor millia sexcenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Juxta eum castrametati sunt de tribu Issachar, quorum princeps fuit Nathanaël filius Suar. ");
INSERT INTO latVUC_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Et omnis numerus pugnatorum ejus quinquaginta quatuor millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","In tribu Zabulon princeps fuit Eliab filius Helon. ");
INSERT INTO latVUC_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Omnis de stirpe ejus exercitus pugnatorum, quinquaginta septem millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Universi qui in castris Judæ enumerati sunt, fuerunt centum octoginta sex millia quadringenti: et per turmas suas primi egredientur. ");
INSERT INTO latVUC_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","In castris filiorum Ruben ad meridianam plagam erit princeps Elisur filius Sedeur. ");
INSERT INTO latVUC_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Et cunctus exercitus pugnatorum ejus qui numerati sunt, quadraginta sex millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Juxta eum castrametati sunt de tribu Simeon: quorum princeps fuit Salamiel filius Surisaddai. ");
INSERT INTO latVUC_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Et cunctus exercitus pugnatorum ejus qui numerati sunt, quinquaginta novem millia trecenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","In tribu Gad princeps fuit Eliasaph filius Duel. ");
INSERT INTO latVUC_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Et cunctus exercitus pugnatorum ejus, qui numerati sunt, quadraginta quinque millia sexcenti quinquaginta. ");
INSERT INTO latVUC_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Omnes qui recensiti sunt in castris Ruben, centum quinquaginta millia et mille quadringenti quinquaginta per turmas suas: in secundo loco proficiscentur. ");
INSERT INTO latVUC_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Levabitur autem tabernaculum testimonii per officia Levitarum, et turmas eorum: quomodo erigetur, ita et deponetur. Singuli per loca et ordines suos proficiscentur. ");
INSERT INTO latVUC_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ad occidentalem plagam erunt castra filiorum Ephraim, quorum princeps fuit Elisama filius Ammiud. ");
INSERT INTO latVUC_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Cunctus exercitus pugnatorum ejus, qui numerati sunt, quadraginta millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Et cum eis tribus filiorum Manasse, quorum princeps fuit Gamaliel filius Phadassur. ");
INSERT INTO latVUC_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Cunctusque exercitus pugnatorum ejus, qui numerati sunt, triginta duo millia ducenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","In tribu filiorum Benjamin princeps fuit Abidan filius Gedeonis. ");
INSERT INTO latVUC_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Et cunctus exercitus pugnatorum ejus, qui recensiti sunt, triginta quinque millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Omnes qui numerati sunt in castris Ephraim, centum octo millia centum per turmas suas: tertii proficiscentur. ");
INSERT INTO latVUC_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ad aquilonis partem castrametati sunt filii Dan: quorum princeps fuit Ahiezer filius Ammisaddai. ");
INSERT INTO latVUC_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Cunctus exercitus pugnatorum ejus, qui numerati sunt, sexaginta duo millia septingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Juxta eum fixere tentoria de tribu Aser: quorum princeps fuit Phegiel filius Ochran. ");
INSERT INTO latVUC_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Cunctus exercitus pugnatorum ejus, qui numerati sunt, quadraginta millia et mille quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","De tribu filiorum Nephthali princeps fuit Ahira filius Enan. ");
INSERT INTO latVUC_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Cunctus exercitus pugnatorum ejus, quinquaginta tria millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Omnes qui numerati sunt in castris Dan, fuerunt centum quinquaginta septem millia sexcenti: et novissimi proficiscentur. ");
INSERT INTO latVUC_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Hic numerus filiorum Israël, per domos cognationum suarum et turmas divisi exercitus, sexcenta tria millia quingenti quinquaginta. ");
INSERT INTO latVUC_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Levitæ autem non sunt numerati inter filios Israël: sic enim præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Feceruntque filii Israël juxta omnia quæ mandaverat Dominus. Castrametati sunt per turmas suas, et profecti per familias ac domos patrum suorum. ");
INSERT INTO latVUC_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hæ sunt generationes Aaron et Moysi in die qua locutus est Dominus ad Moysen in monte Sinai. ");
INSERT INTO latVUC_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Et hæc nomina filiorum Aaron: primogenitus ejus Nadab, deinde Abiu, et Eleazar, et Ithamar. ");
INSERT INTO latVUC_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Hæc nomina filiorum Aaron sacerdotum qui uncti sunt, et quorum repletæ et consecratæ manus ut sacerdotio fungerentur. ");
INSERT INTO latVUC_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Mortui sunt enim Nadab et Abiu cum offerrent ignem alienum in conspectu Domini in deserto Sinai, absque liberis: functique sunt sacerdotio Eleazar et Ithamar coram Aaron patre suo. ");
INSERT INTO latVUC_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Applica tribum Levi, et fac stare in conspectu Aaron sacerdotis ut ministrent ei, et excubent, ");
INSERT INTO latVUC_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","et observent quidquid ad cultum pertinet multitudinis coram tabernaculo testimonii, ");
INSERT INTO latVUC_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","et custodiant vasa tabernaculi, servientes in ministerio ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Dabisque dono Levitas ");
INSERT INTO latVUC_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaron et filiis ejus, quibus traditi sunt a filiis Israël. Aaron autem et filios ejus constitues super cultum sacerdotii. Externus, qui ad ministrandum accesserit, morietur. ");
INSERT INTO latVUC_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Ego tuli Levitas a filiis Israël pro omni primogenito, qui aperit vulvam in filiis Israël, eruntque Levitæ mei. ");
INSERT INTO latVUC_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Meum est enim omne primogenitum: ex quo percussi primogenitos in terra Ægypti, sanctificavi mihi quidquid primum nascitur in Israël: ab homine usque ad pecus, mei sunt. Ego Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Locutusque est Dominus ad Moysen in deserto Sinai, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Numera filios Levi per domos patrum suorum et familias, omnem masculum ab uno mense et supra. ");
INSERT INTO latVUC_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Numeravit Moyses, ut præceperat Dominus, ");
INSERT INTO latVUC_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","et inventi sunt filii Levi per nomina sua, Gerson et Caath et Merari. ");
INSERT INTO latVUC_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Filii Gerson: Lebni et Semei. ");
INSERT INTO latVUC_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Filii Caath: Amram et Jesaar, Hebron et Oziel. ");
INSERT INTO latVUC_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Filii Merari: Moholi et Musi. ");
INSERT INTO latVUC_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","De Gerson fuere familiæ duæ, Lebnitica, et Semeitica: ");
INSERT INTO latVUC_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","quarum numeratus est populus sexus masculini ab uno mense et supra, septem millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Hi post tabernaculum metabuntur ad occidentem, ");
INSERT INTO latVUC_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","sub principe Eliasaph filio Laël. ");
INSERT INTO latVUC_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Et habebunt excubias in tabernaculo fœderis, ");
INSERT INTO latVUC_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ipsum tabernaculum et operimentum ejus, tentorium quod trahitur ante fores tecti fœderis, et cortinas atrii: tentorium quoque quod appenditur in introitu atrii tabernaculi, et quidquid ad ritum altaris pertinet, funes tabernaculi et omnia utensilia ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Cognatio Caath habebit populos Amramitas et Jesaaritas et Hebronitas et Ozielitas. Hæ sunt familiæ Caathitarum recensitæ per nomina sua. ");
INSERT INTO latVUC_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Omnes generis masculini ab uno mense et supra, octo millia sexcenti habebunt excubias sanctuarii, ");
INSERT INTO latVUC_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","et castrametabuntur ad meridianam plagam. ");
INSERT INTO latVUC_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Princepsque eorum erit Elisaphan filius Oziel: ");
INSERT INTO latVUC_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","et custodient arcam, mensamque et candelabrum, altaria et vasa sanctuarii, in quibus ministratur, et velum, cunctamque hujuscemodi supellectilem. ");
INSERT INTO latVUC_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Princeps autem principum Levitarum Eleazar filius Aaron sacerdotis, erit super excubitores custodiæ sanctuarii. ");
INSERT INTO latVUC_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","At vero de Merari erunt populi Moholitæ et Musitæ recensiti per nomina sua: ");
INSERT INTO latVUC_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","omnes generis masculini ab uno mense et supra, sex millia ducenti. ");
INSERT INTO latVUC_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Princeps eorum Suriel filius Abihaiel: in plaga septentrionali castrametabuntur. ");
INSERT INTO latVUC_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Erunt sub custodia eorum tabulæ tabernaculi et vectes, et columnæ ac bases earum, et omnia quæ ad cultum hujuscemodi pertinent: ");
INSERT INTO latVUC_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","columnæque atrii per circuitum cum basibus suis, et paxilli cum funibus. ");
INSERT INTO latVUC_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Castrametabuntur ante tabernaculum fœderis, id est, ad orientalem plagam, Moyses et Aaron cum filiis suis, habentes custodiam sanctuarii in medio filiorum Israël. Quisquis alienus accesserit, morietur. ");
INSERT INTO latVUC_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Omnes Levitæ, quos numeraverunt Moyses et Aaron juxta præceptum Domini per familias suas in genere masculino a mense uno et supra, fuerunt viginti duo millia. ");
INSERT INTO latVUC_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Et ait Dominus ad Moysen: Numera primogenitos sexus masculini de filiis Israël ab uno mense et supra, et habebis summam eorum. ");
INSERT INTO latVUC_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tollesque Levitas mihi pro omni primogenito filiorum Israël: ego sum Dominus: et pecora eorum pro universis primogenitis pecorum filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Recensuit Moyses, sicut præceperat Dominus, primogenitos filiorum Israël: ");
INSERT INTO latVUC_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","et fuerunt masculi per nomina sua, a mense uno et supra, viginti duo millia ducenti septuaginta tres. ");
INSERT INTO latVUC_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Tolle Levitas pro primogenitis filiorum Israël, et pecora Levitarum pro pecoribus eorum, eruntque Levitæ mei. Ego sum Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","In pretio autem ducentorum septuaginta trium, qui excedunt numerum Levitarum de primogenitis filiorum Israël, ");
INSERT INTO latVUC_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","accipies quinque siclos per singula capita ad mensuram sanctuarii (siclus habet viginti obolos): ");
INSERT INTO latVUC_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","dabisque pecuniam Aaron et filiis ejus pretium eorum qui supra sunt. ");
INSERT INTO latVUC_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Tulit igitur Moyses pecuniam eorum, qui fuerant amplius, et quos redemerant a Levitis, ");
INSERT INTO latVUC_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","pro primogenitis filiorum Israël, mille trecentorum sexaginta quinque siclorum juxta pondus sanctuarii: ");
INSERT INTO latVUC_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","et dedit eam Aaron et filiis ejus juxta verbum quod præceperat sibi Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Locutusque est Dominus ad Moysen et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Tolle summam filiorum Caath de medio Levitarum per domos et familias suas, ");
INSERT INTO latVUC_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","a trigesimo anno et supra, usque ad quinquagesimum annum, omnium qui ingrediuntur ut stent et ministrent in tabernaculo fœderis. ");
INSERT INTO latVUC_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Hic est cultus filiorum Caath: tabernaculum fœderis, et Sanctum sanctorum ");
INSERT INTO latVUC_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ingredientur Aaron et filii ejus, quando movenda sunt castra, et deponent velum quod pendet ante fores, involventque eo arcam testimonii, ");
INSERT INTO latVUC_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","et operient rursum velamine janthinarum pellium, extendentque desuper pallium totum hyacinthinum, et inducent vectes. ");
INSERT INTO latVUC_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Mensam quoque propositionis involvent hyacinthino pallio, et ponent cum ea thuribula et mortariola, cyathos et crateras ad liba fundenda: panes semper in ea erunt: ");
INSERT INTO latVUC_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","extendentque desuper pallium coccineum, quod rursum operient velamento janthinarum pellium, et inducent vectes. ");
INSERT INTO latVUC_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Sument et pallium hyacinthinum, quo operient candelabrum cum lucernis et forcipibus suis et emunctoriis et cunctis vasis olei, quæ ad concinnandas lucernas necessaria sunt: ");
INSERT INTO latVUC_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","et super omnia ponent operimentum janthinarum pellium, et inducent vectes. ");
INSERT INTO latVUC_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Necnon et altare aureum involvent hyacinthino vestimento, et extendent desuper operimentum janthinarum pellium, inducentque vectes. ");
INSERT INTO latVUC_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Omnia vasa, quibus ministratur in sanctuario, involvent hyacinthino pallio, et extendent desuper operimentum janthinarum pellium, inducentque vectes. ");
INSERT INTO latVUC_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Sed et altare mundabunt cinere, et involvent illud purpureo vestimento, ");
INSERT INTO latVUC_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ponentque cum eo omnia vasa, quibus in ministerio ejus utuntur, id est, ignium receptacula, fuscinulas ac tridentes, uncinos et batilla. Cuncta vasa altaris operient simul velamine janthinarum pellium, et inducent vectes. ");
INSERT INTO latVUC_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Cumque involverint Aaron et filii ejus sanctuarium et omnia vasa ejus in commotione castrorum, tunc intrabunt filii Caath ut portent involuta: et non tangent vasa sanctuarii, ne moriantur. Ista sunt onera filiorum Caath in tabernaculo fœderis: ");
INSERT INTO latVUC_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","super quos erit Eleazar filius Aaron sacerdotis, ad cujus curam pertinet oleum ad concinnandas lucernas, et compositionis incensum, et sacrificium, quod semper offertur, et oleum unctionis, et quidquid ad cultum tabernaculi pertinet, omniumque vasorum, quæ in sanctuario sunt. ");
INSERT INTO latVUC_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Locutusque est Dominus ad Moysen et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Nolite perdere populum Caath de medio Levitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","sed hoc facite eis, ut vivant, et non moriantur, si tetigerint Sancta sanctorum. Aaron et filii ejus intrabunt, ipsique disponent opera singulorum, et divident quid portare quis debeat. ");
INSERT INTO latVUC_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Alii nulla curiositate videant quæ sunt in sanctuario priusquam involvantur, alioquin morientur. ");
INSERT INTO latVUC_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Tolle summam etiam filiorum Gerson per domos ac familias et cognationes suas, ");
INSERT INTO latVUC_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","a triginta annis et supra, usque ad annos quinquaginta. Numera omnes qui ingrediuntur et ministrant in tabernaculo fœderis. ");
INSERT INTO latVUC_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Hoc est officium familiæ Gersonitarum, ");
INSERT INTO latVUC_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ut portent cortinas tabernaculi et tectum fœderis, operimentum aliud, et super omnia velamen janthinum tentoriumque quod pendet in introitu tabernaculi fœderis, ");
INSERT INTO latVUC_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","cortinas atrii, et velum in introitu quod est ante tabernaculum. Omnia quæ ad altare pertinent, funiculos, et vasa ministerii, ");
INSERT INTO latVUC_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","jubente Aaron et filiis ejus, portabunt filii Gerson: et scient singuli cui debeant oneri mancipari. ");
INSERT INTO latVUC_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Hic est cultus familiæ Gersonitarum in tabernaculo fœderis, eruntque sub manu Ithamar filii Aaron sacerdotis. ");
INSERT INTO latVUC_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Filios quoque Merari per familias et domos patrum suorum recensebis, ");
INSERT INTO latVUC_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","a triginta annis et supra, usque ad annos quinquaginta, omnes qui ingrediuntur ad officium ministerii sui et cultum fœderis testimonii. ");
INSERT INTO latVUC_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Hæc sunt onera eorum: portabunt tabulas tabernaculi et vectes ejus, columnas ac bases earum, ");
INSERT INTO latVUC_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","columnas quoque atrii per circuitum cum basibus et paxillis et funibus suis. Omnia vasa et supellectilem ad numerum accipient, sicque portabunt. ");
INSERT INTO latVUC_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Hoc est officium familiæ Meraritarum et ministerium in tabernaculo fœderis: eruntque sub manu Ithamar filii Aaron sacerdotis. ");
INSERT INTO latVUC_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Recensuerunt igitur Moyses et Aaron et principes synagogæ filios Caath per cognationes et domos patrum suorum, ");
INSERT INTO latVUC_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","a triginta annis et supra, usque ad annum quinquagesimum, omnes qui ingrediuntur ad ministerium tabernaculi fœderis: ");
INSERT INTO latVUC_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","et inventi sunt duo millia septingenti quinquaginta. ");
INSERT INTO latVUC_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Hic est numerus populi Caath qui intrant tabernaculum fœderis: hos numeravit Moyses et Aaron juxta sermonem Domini per manum Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Numerati sunt et filii Gerson per cognationes et domos patrum suorum, ");
INSERT INTO latVUC_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","a triginta annos et supra, usque ad quinquagesimum annum, omnes qui ingrediuntur ut ministrent in tabernaculo fœderis: ");
INSERT INTO latVUC_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","et inventi sunt duo millia sexcenti triginta. ");
INSERT INTO latVUC_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Hic est populus Gersonitarum, quos numeraverunt Moyses et Aaron juxta verbum Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Numerati sunt et filii Merari per cognationes et domos patrum suorum, ");
INSERT INTO latVUC_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","a triginta annis et supra, usque ad annum quinquagesimum, omnes qui ingrediuntur ad explendos ritus tabernaculi fœderis: ");
INSERT INTO latVUC_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","et inventi sunt tria millia ducenti. ");
INSERT INTO latVUC_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Hic est numerus filiorum Merari, quos recensuerunt Moyses et Aaron juxta imperium Domini per manum Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Omnes qui recensiti sunt de Levitis, et quos recenseri fecit ad nomen Moyses et Aaron, et principes Israël per cognationes et domos patrum suorum, ");
INSERT INTO latVUC_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","a triginta annis et supra, usque ad annum quinquagesimum, ingredientes ad ministerium tabernaculi, et onera portanda, ");
INSERT INTO latVUC_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","fuerunt simul octo millia quingenti octoginta. ");
INSERT INTO latVUC_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Juxta verbum Domini recensuit eos Moyses, unumquemque juxta officium et onera sua, sicut præceperat ei Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Præcipe filiis Israël, ut ejiciant de castris omnem leprosum, et qui semine fluit, pollutusque est super mortuo: ");
INSERT INTO latVUC_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","tam masculum quam feminam ejicite de castris, ne contaminent ea cum habitaverint vobiscum. ");
INSERT INTO latVUC_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Feceruntque ita filii Israël, et ejecerunt eos extra castra, sicut locutus erat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Loquere ad filios Israël: Vir, sive mulier, cum fecerint ex omnibus peccatis, quæ solent hominibus accidere, et per negligentiam transgressi fuerint mandatum Domini, atque deliquerint, ");
INSERT INTO latVUC_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","confitebuntur peccatum suum, et reddent ipsum caput, quintamque partem desuper, ei in quem peccaverint. ");
INSERT INTO latVUC_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Sin autem non fuerit qui recipiat, dabunt Domino, et erit sacerdotis, excepto ariete, qui offertur pro expiatione, ut sit placabilis hostia. ");
INSERT INTO latVUC_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Omnes quoque primitiæ, quas offerunt filii Israël, ad sacerdotem pertinent: ");
INSERT INTO latVUC_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","et quidquid in sanctuarium offertur a singulis, et traditur manibus sacerdotis, ipsius erit. ");
INSERT INTO latVUC_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Loquere ad filios Israël, et dices ad eos: Vir cujus uxor erraverit, maritumque contemnens ");
INSERT INTO latVUC_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","dormierit cum altero viro, et hoc maritus deprehendere non quiverit, sed latet adulterium, et testibus argui non potest, quia non est inventa in stupro: ");
INSERT INTO latVUC_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","si spiritus zelotypiæ concitaverit virum contra uxorem suam, quæ vel polluta est, vel falsa suspicione appetitur: ");
INSERT INTO latVUC_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","adducet eam ad sacerdotem, et offeret oblationem pro illa, decimam partem sati farinæ hordeaceæ: non fundet super eam oleum, nec imponet thus: quia sacrificium zelotypiæ est, et oblatio investigans adulterium. ");
INSERT INTO latVUC_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Offeret igitur eam sacerdos, et statuet coram Domino, ");
INSERT INTO latVUC_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","assumetque aquam sanctam in vase fictili, et pauxillum terræ de pavimento tabernaculi mittet in eam. ");
INSERT INTO latVUC_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Cumque steterit mulier in conspectu Domini, discooperiet caput ejus, et ponet super manus illius sacrificium recordationis, et oblationem zelotypiæ: ipse autem tenebit aquas amarissimas, in quibus cum execratione maledicta congessit. ");
INSERT INTO latVUC_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Adjurabitque eam, et dicet: Si non dormivit vir alienus tecum, et si non polluta es deserto mariti thoro, non te nocebunt aquæ istæ amarissimæ, in quas maledicta congessi. ");
INSERT INTO latVUC_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Sin autem declinasti a viro tuo, atque polluta es, et concubuisti cum altero viro: ");
INSERT INTO latVUC_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","his maledictionibus subjacebis: det te Dominus in maledictionem, exemplumque cunctorum in populo suo: putrescere faciat femur tuum, et tumens uterus tuus disrumpatur. ");
INSERT INTO latVUC_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ingrediantur aquæ maledictæ in ventrem tuum, et utero tumescente putrescat femur. Et respondebit mulier: Amen, amen. ");
INSERT INTO latVUC_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Scribetque sacerdos in libello ista maledicta, et delebit ea aquis amarissimis, in quas maledicta congessit, ");
INSERT INTO latVUC_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","et dabit ei bibere. Quas cum exhauserit, ");
INSERT INTO latVUC_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","tollet sacerdos de manu ejus sacrificium zelotypiæ, et elevabit illud coram Domino, imponetque illud super altare, ita dumtaxat ut prius: ");
INSERT INTO latVUC_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","pugillum sacrificii tollat de eo, quod offertur, et incendat super altare: et sic potum det mulieri aquas amarissimas. ");
INSERT INTO latVUC_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Quas cum biberit, si polluta est, et contempto viro adulterii rea, pertransibunt eam aquæ maledictionis, et inflato ventre, computrescet femur: eritque mulier in maledictionem, et in exemplum omni populo. ");
INSERT INTO latVUC_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Quod si polluta non fuerit, erit innoxia, et faciet liberos. ");
INSERT INTO latVUC_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ista est lex zelotypiæ. Si declinaverit mulier a viro suo, et si polluta fuerit, ");
INSERT INTO latVUC_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","maritusque zelotypiæ spiritu concitatus adduxerit eam in conspectu Domini, et fecerit ei sacerdos juxta omnia quæ scripta sunt: ");
INSERT INTO latVUC_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","maritus absque culpa erit, et illa recipiet iniquitatem suam. ");
INSERT INTO latVUC_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Loquere ad filios Israël, et dices ad eos: Vir, sive mulier, cum fecerint votum ut sanctificentur, et se voluerint Domino consecrare: ");
INSERT INTO latVUC_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","a vino, et omni quod inebriare potest, abstinebunt. Acetum ex vino, et ex qualibet alia potione, et quidquid de uva exprimitur, non bibent: uvas recentes siccasque non comedent ");
INSERT INTO latVUC_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","cunctis diebus quibus ex voto Domino consecrantur: quidquid ex vinea esse potest, ab uva passa usque ad acinum non comedent. ");
INSERT INTO latVUC_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Omni tempore separationis suæ novacula non transibit per caput ejus usque ad completum diem, quo Domino consecratur. Sanctus erit, crescente cæsarie capitis ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Omni tempore consecrationis suæ, super mortuum non ingredietur, ");
INSERT INTO latVUC_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","nec super patris quidem et matris et fratris sororisque funere contaminabitur, quia consecratio Dei sui super caput ejus est. ");
INSERT INTO latVUC_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Omnibus diebus separationis suæ sanctus erit Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Sin autem mortuus fuerit subito quispiam coram eo, polluetur caput consecrationis ejus: quod radet illico in eadem die purgationis suæ, et rursum septima. ");
INSERT INTO latVUC_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","In octava autem die offeret duos turtures, vel duos pullos columbæ sacerdoti in introitu fœderis testimonii. ");
INSERT INTO latVUC_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Facietque sacerdos unum pro peccato, et alterum in holocaustum, et deprecabitur pro eo, quia peccavit super mortuo: sanctificabitque caput ejus in die illo: ");
INSERT INTO latVUC_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","et consecrabit Domino dies separationis illius, offerens agnum anniculum pro peccato: ita tamen ut dies priores irriti fiant, quoniam polluta est sanctificatio ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ista est lex consecrationis. Cum dies, quos ex voto decreverat, complebuntur, adducet eum ad ostium tabernaculi fœderis, ");
INSERT INTO latVUC_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","et offeret oblationes ejus Domino, agnum anniculum immaculatum in holocaustum, et ovem anniculam immaculatam pro peccato, et arietem immaculatum, hostiam pacificam, ");
INSERT INTO latVUC_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","canistrum quoque panum azymorum qui conspersi sint oleo, et lagana absque fermento uncta oleo, ac libamina singulorum: ");
INSERT INTO latVUC_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","quæ offeret sacerdos coram Domino, et faciet tam pro peccato, quam in holocaustum. ");
INSERT INTO latVUC_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Arietem vero immolabit hostiam pacificam Domino, offerens simul canistrum azymorum, et libamenta quæ ex more debentur. ");
INSERT INTO latVUC_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Tunc radetur nazaræus ante ostium tabernaculi fœderis cæsarie consecrationis suæ: tolletque capillos ejus, et ponet super ignem, qui est suppositus sacrificio pacificorum: ");
INSERT INTO latVUC_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","et armum coctum arietis, tortamque absque fermento unam de canistro, et laganum azymum unum, et tradet in manus nazaræi, postquam rasum fuerit caput ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Susceptaque rursum ab eo, elevabit in conspectu Domini: et sanctificata sacerdotis erunt, sicut pectusculum, quod separari jussum est, et femur. Post hæc, potest bibere nazaræus vinum. ");
INSERT INTO latVUC_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ista est lex nazaræi, cum voverit oblationem suam Domino tempore consecrationis suæ, exceptis his, quæ invenerit manus ejus: juxta quod mente devoverat, ita faciet ad perfectionem sanctificationis suæ. ");
INSERT INTO latVUC_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Loquere Aaron et filiis ejus: Sic benedicetis filiis Israël, et dicetis eis: ");
INSERT INTO latVUC_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Benedicat tibi Dominus, et custodiat te. ");
INSERT INTO latVUC_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ostendat Dominus faciem suam tibi, et misereatur tui. ");
INSERT INTO latVUC_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Convertat Dominus vultum suum ad te, et det tibi pacem. ");
INSERT INTO latVUC_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Invocabuntque nomen meum super filios Israël, et ego benedicam eis. ");
INSERT INTO latVUC_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Factum est autem in die qua complevit Moyses tabernaculum, et erexit illud, unxitque et sanctificavit cum omnibus vasis suis, altare similiter et omnia vasa ejus: ");
INSERT INTO latVUC_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","obtulerunt principes Israël et capita familiarum, qui erant per singulas tribus, præfectique eorum, qui numerati fuerant, ");
INSERT INTO latVUC_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","munera coram Domino sex plaustra tecta cum duodecim bobus. Unum plaustrum obtulere duo duces, et unum bovem singuli, obtuleruntque ea in conspectu tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ait autem Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Suscipe ab eis ut serviant in ministerio tabernaculi, et trades ea Levitis juxta ordinem ministerii sui. ");
INSERT INTO latVUC_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Itaque cum suscepisset Moyses plaustra et boves, tradidit eos Levitis. ");
INSERT INTO latVUC_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Duo plaustra et quatuor boves dedit filiis Gerson, juxta id quod habebant necessarium. ");
INSERT INTO latVUC_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Quatuor alia plaustra et octo boves dedit filiis Merari secundum officia et cultum suum, sub manu Ithamar filii Aaron sacerdotis. ");
INSERT INTO latVUC_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Filiis autem Caath non dedit plaustra et boves: quia in sanctuario serviunt, et onera propriis portant humeris. ");
INSERT INTO latVUC_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Igitur obtulerunt duces in dedicationem altaris, die qua unctum est, oblationem suam ante altare. ");
INSERT INTO latVUC_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Dixitque Dominus ad Moysen: Singuli duces per singulos dies offerant munera in dedicationem altaris. ");
INSERT INTO latVUC_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Primo die obtulit oblationem suam Nahasson filius Aminadab de tribu Juda: ");
INSERT INTO latVUC_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","fueruntque in ea acetabulum argenteum pondo centum triginta siclorum, phiala argentea habens septuaginta siclos, juxta pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificium: ");
INSERT INTO latVUC_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","mortariolum ex decem siclis aureis plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","et in sacrificio pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc est oblatio Nahasson filii Aminadab. ");
INSERT INTO latVUC_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Secundo die obtulit Nathanaël filius Suar, dux de tribu Issachar, ");
INSERT INTO latVUC_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, juxta pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificium: ");
INSERT INTO latVUC_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","mortariolum aureum habens decem siclos plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","et in sacrificio pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Nathanaël filii Suar. ");
INSERT INTO latVUC_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Tertio die princeps filiorum Zabulon, Eliab filius Helon, ");
INSERT INTO latVUC_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum similia conspersa oleo in sacrificium: ");
INSERT INTO latVUC_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","et in sacrificio pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc est oblatio Eliab filii Helon. ");
INSERT INTO latVUC_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Die quarto princeps filiorum Ruben, Elisur filius Sedeur, ");
INSERT INTO latVUC_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Elisur filii Sedeur. ");
INSERT INTO latVUC_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Die quinto princeps filiorum Simeon, Salamiel filius Surisaddai, ");
INSERT INTO latVUC_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Salamiel filii Surisaddai. ");
INSERT INTO latVUC_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Die sexto princeps filiorum Gad, Eliasaph filius Duel, ");
INSERT INTO latVUC_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Eliasaph filii Duel. ");
INSERT INTO latVUC_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Die septimo princeps filiorum Ephraim, Elisama filius Ammiud, ");
INSERT INTO latVUC_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Elisama filii Ammiud. ");
INSERT INTO latVUC_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Die octavo, princeps filiorum Manasse, Gamaliel filius Phadassur, ");
INSERT INTO latVUC_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Gamaliel filii Phadassur. ");
INSERT INTO latVUC_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Die nono princeps filiorum Benjamin, Abidan filius Gedeonis, ");
INSERT INTO latVUC_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","et mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Abidan filii Gedeonis. ");
INSERT INTO latVUC_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Die decimo princeps filiorum Dan, Ahiezer filius Ammisaddai, ");
INSERT INTO latVUC_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Ahiezer filii Ammisaddai. ");
INSERT INTO latVUC_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Die undecimo princeps filiorum Aser, Phegiel filius Ochran, ");
INSERT INTO latVUC_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila conspersa oleo in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Phegiel filii Ochran. ");
INSERT INTO latVUC_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Die duodecimo princeps filiorum Nephthali, Ahira filius Enan, ");
INSERT INTO latVUC_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","obtulit acetabulum argenteum appendens centum triginta siclos, phialam argenteam habentem septuaginta siclos, ad pondus sanctuarii, utrumque plenum simila oleo conspersa in sacrificum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","mortariolum aureum appendens decem siclos, plenum incenso: ");
INSERT INTO latVUC_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","bovem de armento, et arietem, et agnum anniculum in holocaustum: ");
INSERT INTO latVUC_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","et in hostias pacificorum boves duos, arietes quinque, hircos quinque, agnos anniculos quinque. Hæc fuit oblatio Ahira filii Enan. ");
INSERT INTO latVUC_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Hæc in dedicatione altaris oblata sunt a principibus Israël, in die qua consecratum est: acetabula argentea duodecim: phialæ argenteæ duodecim: mortariola aurea duodecim: ");
INSERT INTO latVUC_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ita ut centum triginta siclos argenti haberet unum acetabulum, et septuaginta siclos haberet una phiala: id est, in commune vasorum omnium ex argento sicli duo millia quadringenti, pondere sanctuarii: ");
INSERT INTO latVUC_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","mortariola aurea duodecim plena incenso, denos siclos appendentia pondere sanctuarii: id est, simul auri sicli centum viginti: ");
INSERT INTO latVUC_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","boves de armento in holocaustum duodecim, arietes duodecim, agni anniculi duodecim, et libamenta eorum: hirci duodecim pro peccato. ");
INSERT INTO latVUC_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","In hostias pacificorum, boves viginti quatuor, arietes sexaginta, hirci sexaginta, agni anniculi sexaginta. Hæc oblata sunt in dedicatione altaris, quando unctum est. ");
INSERT INTO latVUC_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Cumque ingrederetur Moyses tabernaculum fœderis, ut consuleret oraculum, audiebat vocem loquentis ad se de propitiatorio quod erat super arcam testimonii inter duos cherubim, unde et loquebatur ei. ");
INSERT INTO latVUC_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Loquere Aaron, et dices ad eum: Cum posueris septem lucernas, candelabrum in australi parte erigatur. Hoc igitur præcipe ut lucernæ contra boream e regione respiciant ad mensam panum propositionis, contra eam partem, quam candelabrum respicit, lucere debebunt. ");
INSERT INTO latVUC_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Fecitque Aaron, et imposuit lucernas super candelabrum, ut præceperat Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Hæc autem erat factura candelabri, ex auro ductili, tam medius stipes, quam cuncta quæ ex utroque calamorum latere nascebantur: juxta exemplum quod ostendit Dominus Moysi, ita operatus est candelabrum. ");
INSERT INTO latVUC_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Et locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Tolle Levitas de medio filiorum Israël, et purificabis eos ");
INSERT INTO latVUC_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","juxta hunc ritum: aspergantur aqua lustrationis, et radant omnes pilos carnis suæ. Cumque laverint vestimenta sua, et mundati fuerint, ");
INSERT INTO latVUC_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","tollent bovem de armentis, et libamentum ejus similam oleo conspersam: bovem autem alterum de armento tu accipies pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","et applicabis Levitas coram tabernaculo fœderis, convocata omni multitudine filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Cumque Levitæ fuerint coram Domino, ponent filii Israël manus suas super eos. ");
INSERT INTO latVUC_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Et offeret Aaron Levitas, munus in conspectu Domini a filiis Israël, ut serviant in ministerio ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Levitæ quoque ponent manus suas super capita boum, e quibus unum facies pro peccato, et alterum in holocaustum Domini, ut depreceris pro eis. ");
INSERT INTO latVUC_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Statuesque Levitas in conspectu Aaron et filiorum ejus, et consecrabis oblatos Domino, ");
INSERT INTO latVUC_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ac separabis de medio filiorum Israël, ut sint mei. ");
INSERT INTO latVUC_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Et postea ingredientur tabernaculum fœderis, ut serviant mihi. Sicque purificabis et consecrabis eos in oblationem Domini: quoniam dono donati sunt mihi a filiis Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Pro primogenitis quæ aperiunt omnem vulvam in Israël, accepi eos. ");
INSERT INTO latVUC_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Mea sunt enim omnia primogenita filiorum Israël, tam ex hominibus quam ex jumentis. Ex die quo percussi omne primogenitum in terra Ægypti, sanctificavi eos mihi: ");
INSERT INTO latVUC_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","et tuli Levitas pro cunctis primogenitis filiorum Israël, ");
INSERT INTO latVUC_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","tradidique eos dono Aaron et filiis ejus de medio populi, ut serviant mihi pro Israël in tabernaculo fœderis, et orent pro eis ne sit in populo plaga, si ausi fuerint accedere ad sanctuarium. ");
INSERT INTO latVUC_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Feceruntque Moyses et Aaron et omnis multitudo filiorum Israël super Levitas quæ præceperat Dominus Moysi: ");
INSERT INTO latVUC_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","purificatique sunt, et laverunt vestimenta sua. Elevavitque eos Aaron in conspectu Domini, et oravit pro eis, ");
INSERT INTO latVUC_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ut purificati ingrederentur ad officia sua in tabernaculum fœderis coram Aaron et filiis ejus. Sicut præceperat Dominus Moysi de Levitis, ita factum est. ");
INSERT INTO latVUC_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Hæc est lex Levitarum: a viginti quinque annis et supra, ingredientur ut ministrent in tabernaculo fœderis. ");
INSERT INTO latVUC_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Cumque quinquagesimum annum ætatis impleverint, servire cessabunt, ");
INSERT INTO latVUC_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","eruntque ministri fratrum suorum in tabernaculo fœderis, ut custodiant quæ sibi fuerunt commendata: opera autem ipsa non faciant. Sic dispones Levitis in custodiis suis. ");
INSERT INTO latVUC_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Locutus est Dominus ad Moysen in deserto Sinai anno secundo, postquam egressi sunt de terra Ægypti, mense primo, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Faciant filii Israël Phase in tempore suo, ");
INSERT INTO latVUC_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","quartadecima die mensis hujus ad vesperam, juxta omnes cæremonias et justificationes ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Præcepitque Moyses filiis Israël ut facerent Phase. ");
INSERT INTO latVUC_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Qui fecerunt tempore suo, quartadecima die mensis ad vesperam, in monte Sinai. Juxta omnia quæ mandaverat Dominus Moysi, fecerunt filii Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ecce autem quidam immundi super anima hominis, qui non poterant facere Phase in die illo, accedentes ad Moysen et Aaron, ");
INSERT INTO latVUC_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","dixerunt eis: Immundi sumus super anima hominis: quare fraudamur ut non valeamus oblationem offerre Domino in tempore suo inter filios Israël? ");
INSERT INTO latVUC_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Quibus respondit Moyses: State ut consulam quid præcipiat Dominus de vobis. ");
INSERT INTO latVUC_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Loquere filiis Israël: Homo, qui fuerit immundus super anima, sive in via procul in gente vestra, faciat Phase Domino ");
INSERT INTO latVUC_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","in mense secundo, quartadecima die mensis ad vesperam. Cum azymis et lactucis agrestibus comedent illud: ");
INSERT INTO latVUC_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","non relinquent ex eo quippiam usque mane, et os ejus non confringent: omnem ritum Phase observabunt. ");
INSERT INTO latVUC_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Si quis autem et mundus est, et in itinere non fuit, et tamen non fecit Phase, exterminabitur anima illa de populis suis, quia sacrificium Domino non obtulit tempore suo: peccatum suum ipse portabit. ");
INSERT INTO latVUC_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Peregrinus quoque et advena si fuerint apud vos, facient Phase Domino juxta cæremonias et justificationes ejus. Præceptum idem erit apud vos tam advenæ quam indigenæ. ");
INSERT INTO latVUC_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Igitur die qua erectum est tabernaculum, operuit illud nubes. A vespere autem super tentorium erat quasi species ignis usque mane. ");
INSERT INTO latVUC_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Sic fiebat jugiter: per diem operiebat illud nubes, et per noctem quasi species ignis. ");
INSERT INTO latVUC_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Cumque ablata fuisset nubes, quæ tabernaculum protegebat, tunc proficiscebantur filii Israël: et in loco ubi stetisset nubes, ibi castrametabantur. ");
INSERT INTO latVUC_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ad imperium Domini proficiscebantur, et ad imperium illius figebant tabernaculum. Cunctis diebus quibus stabat nubes super tabernaculum, manebant in eodem loco: ");
INSERT INTO latVUC_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","et si evenisset ut multo tempore maneret super illud, erant filii Israël in excubiis Domini, et non proficiscebantur ");
INSERT INTO latVUC_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","quot diebus fuisset nubes super tabernaculum. Ad imperium Domini erigebant tentoria, et ad imperium illius deponebant. ");
INSERT INTO latVUC_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Si fuisset nubes a vespere usque mane, et statim diluculo tabernaculum reliquisset, proficiscebantur: et si post diem et noctem recessisset, dissipabant tentoria. ");
INSERT INTO latVUC_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Si vero biduo aut uno mense vel longiori tempore fuisset super tabernaculum, manebant filii Israël in eodem loco, et non proficiscebantur: statim autem ut recessisset, movebant castra. ");
INSERT INTO latVUC_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Per verbum Domini figebant tentoria, et per verbum illius proficiscebantur: erantque in excubiis Domini juxta imperium ejus per manum Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Fac tibi duas tubas argenteas ductiles, quibus convocare possis multitudinem quando movenda sunt castra. ");
INSERT INTO latVUC_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Cumque increpueris tubis, congregabitur ad te omnis turba ad ostium tabernaculi fœderis. ");
INSERT INTO latVUC_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Si semel clangueris, venient ad te principes, et capita multitudinis Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Si autem prolixior atque concisus clangor increpuerit, movebunt castra primi qui sunt ad orientalem plagam. ");
INSERT INTO latVUC_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","In secundo autem sonitu et pari ululatu tubæ, levabunt tentoria qui habitant ad meridiem; et juxta hunc modum reliqui facient, ululantibus tubis in profectionem. ");
INSERT INTO latVUC_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Quando autem congregandus est populus, simplex tubarum clangor erit, et non concise ululabunt. ");
INSERT INTO latVUC_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Filii autem Aaron sacerdotes clangent tubis: eritque hoc legitimum sempiternum in generationibus vestris. ");
INSERT INTO latVUC_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Si exieritis ad bellum de terra vestra contra hostes qui dimicant adversum vos, clangetis ululantibus tubis, et erit recordatio vestri coram Domino Deo vestro, ut eruamini de manibus inimicorum vestrorum. ");
INSERT INTO latVUC_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Siquando habebitis epulum, et dies festos, et calendas, canetis tubis super holocaustis, et pacificis victimis, ut sint vobis in recordationem Dei vestri. Ego Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Anno secundo, mense secundo, vigesima die mensis, elevata est nubes de tabernaculo fœderis: ");
INSERT INTO latVUC_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","profectique sunt filii Israël per turmas suas de deserto Sinai, et recubuit nubes in solitudine Pharan. ");
INSERT INTO latVUC_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Moveruntque castra primi juxta imperium Domini in manu Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Filii Juda per turmas suas: quorum princeps erat Nahasson filius Aminadab. ");
INSERT INTO latVUC_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","In tribu filiorum Issachar fuit princeps Nathanaël filius Suar. ");
INSERT INTO latVUC_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","In tribu Zabulon erat princeps Eliab filius Helon. ");
INSERT INTO latVUC_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Depositumque est tabernaculum, quod portantes egressi sunt filii Gerson et Merari. ");
INSERT INTO latVUC_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Profectique sunt et filii Ruben, per turmas et ordinem suum: quorum princeps erat Helisur filius Sedeur. ");
INSERT INTO latVUC_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","In tribu autem filiorum Simeon, princeps fuit Salamiel filius Surisaddai. ");
INSERT INTO latVUC_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Porro in tribu Gad erat princeps Eliasaph filius Duel. ");
INSERT INTO latVUC_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Profectique sunt et Caathitæ portantes sanctuarium. Tamdiu tabernaculum portabatur, donec venirent ad erectionis locum. ");
INSERT INTO latVUC_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Moverunt castra et filii Ephraim per turmas suas, in quorum exercitu princeps erat Elisama filius Ammiud. ");
INSERT INTO latVUC_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","In tribu autem filiorum Manasse princeps fuit Gamaliel filius Phadassur. ");
INSERT INTO latVUC_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Et in tribu Benjamin erat dux Abidan filius Gedeonis. ");
INSERT INTO latVUC_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Novissimi castrorum omnium profecti sunt filii Dan per turmas suas, in quorum exercitu princeps fuit Ahiezer filius Ammisaddai. ");
INSERT INTO latVUC_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","In tribu autem filiorum Aser erat princeps Phegiel filius Ochran. ");
INSERT INTO latVUC_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Et in tribu filiorum Nephthali princeps fuit Ahira filius Enan. ");
INSERT INTO latVUC_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Hæc sunt castra, et profectiones filiorum Israël per turmas suas quando egrediebantur. ");
INSERT INTO latVUC_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Dixitque Moyses Hobab filio Raguel Madianitæ, cognato suo: Proficiscimur ad locum quem Dominus daturus est nobis: veni nobiscum, ut benefaciamus tibi, quia Dominus bona promisit Israëli. ");
INSERT INTO latVUC_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Cui ille respondit: Non vadam tecum, sed revertar in terram meam, in qua natus sum. ");
INSERT INTO latVUC_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Et ille: Noli, inquit, nos relinquere: tu enim nosti in quibus locis per desertum castra ponere debeamus, et eris ductor noster. ");
INSERT INTO latVUC_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Cumque nobiscum veneris, quidquid optimum fuerit ex opibus, quas nobis traditurus est Dominus, dabimus tibi. ");
INSERT INTO latVUC_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Profecti sunt ergo de monte Domini viam trium dierum, arcaque fœderis Domini præcedebat eos, per dies tres providens castrorum locum. ");
INSERT INTO latVUC_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Nubes quoque Domini super eos erat per diem cum incederent. ");
INSERT INTO latVUC_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Cumque elevaretur arca, dicebat Moyses: Surge, Domine, et dissipentur inimici tui, et fugiant qui oderunt te, a facie tua. ");
INSERT INTO latVUC_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Cum autem deponeretur, aiebat: Revertere, Domine, ad multitudinem exercitus Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Interea ortum est murmur populi, quasi dolentium pro labore, contra Dominum. Quod cum audisset Dominus, iratus est. Et accensus in eos ignis Domini, devoravit extremam castrorum partem. ");
INSERT INTO latVUC_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Cumque clamasset populus ad Moysen, oravit Moyses ad Dominum, et absorptus est ignis. ");
INSERT INTO latVUC_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Vocavitque nomen loci illius, Incensio: eo quod incensus fuisset contra eos ignis Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Vulgus quippe promiscuum, quod ascenderat cum eis, flagravit desiderio, sedens et flens, junctis sibi pariter filiis Israël, et ait: Quis dabit nobis ad vescendum carnes? ");
INSERT INTO latVUC_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","recordamur piscium quos comedebamus in Ægypto gratis: in mentem nobis veniunt cucumeres, et pepones, porrique, et cæpe, et allia. ");
INSERT INTO latVUC_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Anima nostra arida est: nihil aliud respiciunt oculi nostri nisi man. ");
INSERT INTO latVUC_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Erat autem man quasi semen coriandri, coloris bdellii. ");
INSERT INTO latVUC_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Circuibatque populus, et colligens illud, frangebat mola, sive terebat in mortario, coquens in olla, et faciens ex eo tortulas saporis quasi panis oleati. ");
INSERT INTO latVUC_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Cumque descenderet nocte super castra ros, descendebat pariter et man. ");
INSERT INTO latVUC_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Audivit ergo Moyses flentem populum per familias, singulos per ostia tentorii sui. Iratusque est furor Domini valde: sed et Moysi intoleranda res visa est, ");
INSERT INTO latVUC_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","et ait ad Dominum: Cur afflixisti servum tuum? quare non invenio gratiam coram te? et cur imposuisti pondus universi populi hujus super me? ");
INSERT INTO latVUC_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Numquid ego concepi omnem hanc multitudinem, vel genui eam, ut dicas mihi: Porta eos in sinu tuo sicut portare solet nutrix infantulum, et defer in terram, pro qua jurasti patribus eorum? ");
INSERT INTO latVUC_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Unde mihi carnes ut dem tantæ multitudini? flent contra me, dicentes: Da nobis carnes ut comedamus. ");
INSERT INTO latVUC_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Non possum solus sustinere omnem hunc populum, quia gravis est mihi. ");
INSERT INTO latVUC_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Sin aliter tibi videtur, obsecro ut interficias me, et inveniam gratiam in oculis tuis, ne tantis afficiar malis. ");
INSERT INTO latVUC_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Et dixit Dominus ad Moysen: Congrega mihi septuaginta viros de senibus Israël, quos tu nosti quod senes populi sint ac magistri: et duces eos ad ostium tabernaculi fœderis, faciesque ibi stare tecum, ");
INSERT INTO latVUC_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ut descendam et loquar tibi: et auferam de spiritu tuo, tradamque eis, ut sustentent tecum onus populi, et non tu solus graveris. ");
INSERT INTO latVUC_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Populo quoque dices: Sanctificamini (cras comedetis carnes: ego enim audivi vos dicere: Quis dabit nobis escas carnium? bene nobis erat in Ægypto), ut det vobis Dominus carnes, et comedatis: ");
INSERT INTO latVUC_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","non uno die, nec duobus, vel quinque aut decem, nec viginti quidem, ");
INSERT INTO latVUC_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","sed usque ad mensem dierum, donec exeat per nares vestras, et vertatur in nauseam, eo quod repuleritis Dominum, qui in medio vestri est, et fleveritis coram eo, dicentes: Quare egressi sumus ex Ægypto? ");
INSERT INTO latVUC_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Et ait Moyses: Sexcenta millia peditum hujus populi sunt: et tu dicis: Dabo eis esum carnium mense integro? ");
INSERT INTO latVUC_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","numquid ovium et boum multitudo cædetur, ut possit sufficere ad cibum? vel omnes pisces maris in unum congregabuntur, ut eos satient? ");
INSERT INTO latVUC_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Cui respondit Dominus: Numquid manus Domini invalida est? jam nunc videbis utrum meus sermo opere compleatur. ");
INSERT INTO latVUC_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Venit igitur Moyses, et narravit populo verba Domini, congregans septuaginta viros de senibus Israël, quos stare fecit circa tabernaculum. ");
INSERT INTO latVUC_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Descenditque Dominus per nubem, et locutus est ad eum, auferens de spiritu qui erat in Moyse, et dans septuaginta viris. Cumque requievisset in eis spiritus, prophetaverunt, nec ultra cessaverunt. ");
INSERT INTO latVUC_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Remanserat autem in castris duo viri, quorum unus vocabatur Eldad, et alter Medad, super quos requievit spiritus. Nam et ipsi descripti fuerant, et non exierant ad tabernaculum. ");
INSERT INTO latVUC_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Cumque prophetarent in castris, cucurrit puer, et nuntiavit Moysi, dicens: Eldad et Medad prophetant in castris. ");
INSERT INTO latVUC_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Statim Josue filius Nun, minister Moysi, et electus e pluribus, ait: Domine mi Moyses, prohibe eos. ");
INSERT INTO latVUC_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","At ille: Quid, inquit æmularis pro me? quis tribuat ut omnis populus prophetet, et det eis Dominus spiritum suum? ");
INSERT INTO latVUC_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Reversusque est Moyses, et majores natu Israël in castra. ");
INSERT INTO latVUC_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ventus autem egrediens a Domino, arreptans trans mare coturnices detulit, et demisit in castra itinere quantum uno die confici potest, ex omni parte castrorum per circuitum, volabantque in aëre duobus cubitis altitudine super terram. ");
INSERT INTO latVUC_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Surgens ergo populus toto die illo, et nocte, ac die altero, congregavit coturnicum: qui parum, decem coros: et siccaverunt eas per gyrum castrorum. ");
INSERT INTO latVUC_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Adhuc carnes erant in dentibus eorum, nec defecerat hujuscemodi cibus: et ecce furor Domini concitatus in populum, percussit eum plaga magna nimis. ");
INSERT INTO latVUC_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Vocatusque est ille locus, Sepulchra concupiscentiæ: ibi enim sepelierunt populum qui desideraverat. Egressi autem de Sepulchris concupiscentiæ, venerunt in Haseroth, et manserunt ibi. ");
INSERT INTO latVUC_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Locutaque est Maria et Aaron contra Moysen propter uxorem ejus Æthiopissam, ");
INSERT INTO latVUC_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","et dixerunt: Num per solum Moysen locutus est Dominus? nonne et nobis similiter est locutus? Quod cum audisset Dominus ");
INSERT INTO latVUC_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(erat enim Moyses vir mitissimus super omnes homines qui morabantur in terra), ");
INSERT INTO latVUC_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","statim locutus est ad eum, et ad Aaron et Mariam: Egredimini vos tantum tres ad tabernaculum fœderis. Cumque fuissent egressi, ");
INSERT INTO latVUC_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","descendit Dominus in columna nubis, et stetit in introitu tabernaculi, vocans Aaron et Mariam. Qui cum issent, ");
INSERT INTO latVUC_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","dixit ad eos: Audite sermones meos: si quis fuerit inter vos propheta Domini, in visione apparebo ei, vel per somnium loquar ad illum. ");
INSERT INTO latVUC_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","At non talis servus meus Moyses, qui in omni domo mea fidelissimus est: ");
INSERT INTO latVUC_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ore enim ad os loquor ei: et palam, et non per ænigmata et figuras Dominum videt. Quare ergo non timuistis detrahere servo meo Moysi? ");
INSERT INTO latVUC_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Iratusque contra eos, abiit: ");
INSERT INTO latVUC_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","nubes quoque recessit quæ erat super tabernaculum: et ecce Maria apparuit candens lepra quasi nix. Cumque respexisset eam Aaron, et vidisset perfusam lepra, ");
INSERT INTO latVUC_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ait ad Moysen: Obsecro, domine mi, ne imponas nobis hoc peccatum quod stulte commisimus, ");
INSERT INTO latVUC_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ne fiat hæc quasi mortua, et ut abortivum quod projicitur de vulva matris suæ: ecce jam medium carnis ejus devoratum est a lepra. ");
INSERT INTO latVUC_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Clamavitque Moyses ad Dominum, dicens: Deus, obsecro, sana eam. ");
INSERT INTO latVUC_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Cui respondit Dominus: Si pater ejus spuisset in faciem illius, nonne debuerat saltem septem diebus rubore suffundi? separetur septem diebus extra castra, et postea revocabitur. ");
INSERT INTO latVUC_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Exclusa est itaque Maria extra castra septem diebus: et populus non est motus de loco illo, donec revocata est Maria. ");
INSERT INTO latVUC_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Profectusque est populus de Haseroth, fixis tentoriis in deserto Pharan. ");
INSERT INTO latVUC_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Ibique locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mitte viros, qui considerent terram Chanaan, quam daturus sum filiis Israël, singulos de singulis tribubus, ex principibus. ");
INSERT INTO latVUC_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Fecit Moyses quod Dominus imperaverat, de deserto Pharan mittens principes viros, quorum ista sunt nomina. ");
INSERT INTO latVUC_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","De tribu Ruben, Sammua filium Zechur. ");
INSERT INTO latVUC_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","De tribu Simeon, Saphat filium Huri. ");
INSERT INTO latVUC_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","De tribu Juda, Caleb filium Jephone. ");
INSERT INTO latVUC_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","De tribu Issachar, Igal filium Joseph. ");
INSERT INTO latVUC_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","De tribu Ephraim, Osee filium Nun. ");
INSERT INTO latVUC_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","De tribu Benjamin, Phalti filium Raphu. ");
INSERT INTO latVUC_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","De tribu Zabulon, Geddiel filium Sodi. ");
INSERT INTO latVUC_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","De tribu Joseph, sceptri Manasse, Gaddi filium Susi. ");
INSERT INTO latVUC_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","De tribu Dan, Ammiel filium Gemalli. ");
INSERT INTO latVUC_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","De tribu Aser, Sthur filium Michaël. ");
INSERT INTO latVUC_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","De tribu Nephthali, Nahabi filium Vapsi. ");
INSERT INTO latVUC_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","De tribu Gad, Guel filium Machi. ");
INSERT INTO latVUC_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Hæc sunt nomina virorum, quos misit Moyses ad considerandam terram: vocavitque Osee filium Nun, Josue. ");
INSERT INTO latVUC_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Misit ergo eos Moyses ad considerandam terram Chanaan, et dixit ad eos: Ascendite per meridianam plagam. Cumque veneritis ad montes, ");
INSERT INTO latVUC_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","considerate terram, qualis sit: et populum qui habitator est ejus, utrum fortis sit an infirmus: si pauci numero an plures: ");
INSERT INTO latVUC_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ipsa terra, bona an mala: urbes quales, muratæ an absque muris: ");
INSERT INTO latVUC_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","humus, pinguis an sterilis, nemorosa an absque arboribus. Confortamini, et afferte nobis de fructibus terræ. Erat autem tempus quando jam præcoquæ uvæ vesci possunt. ");
INSERT INTO latVUC_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Cumque ascendissent, exploraverunt terram a deserto Sin, usque Rohob intrantibus Emath. ");
INSERT INTO latVUC_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ascenderuntque ad meridiem, et venerunt in Hebron, ubi erant Achiman et Sisai et Tholmai filii Enac: nam Hebron septem annis ante Tanim urbem Ægypti condita est. ");
INSERT INTO latVUC_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Pergentesque usque ad Torrentem botri, absciderunt palmitem cum uva sua, quem portaverunt in vecte duo viri. De malis quoque granatis et de ficis loci illius tulerunt: ");
INSERT INTO latVUC_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","qui appellatus est Nehelescol, id est Torrens botri, eo quod botrum portassent inde filii Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Reversique exploratores terræ post quadraginta dies, omni regione circuita, ");
INSERT INTO latVUC_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","venerunt ad Moysen et Aaron et ad omnem cœtum filiorum Israël in desertum Pharan, quod est in Cades. Locutique eis et omni multitudini ostenderunt fructus terræ: ");
INSERT INTO latVUC_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","et narraverunt, dicentes: Venimus in terram, ad quam misisti nos, quæ revera fluit lacte et melle, ut ex his fructibus cognosci potest: ");
INSERT INTO latVUC_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","sed cultores fortissimos habet, et urbes grandes atque muratas. Stirpem Enac vidimus ibi. ");
INSERT INTO latVUC_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Amalec habitat in meridie, Hethæus et Jebusæus et Amorrhæus in montanis: Chananæus vero moratur juxta mare et circa fluenta Jordanis. ");
INSERT INTO latVUC_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Inter hæc Caleb compescens murmur populi, qui oriebatur contra Moysen, ait: Ascendamus, et possideamus terram, quoniam poterimus obtinere eam. ");
INSERT INTO latVUC_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Alii vero, qui fuerant cum eo, dicebant: Nequaquam ad hunc populum valemus ascendere, quia fortior nobis est. ");
INSERT INTO latVUC_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Detraxeruntque terræ, quam inspexerant, apud filios Israël, dicentes: Terra, quam lustravimus, devorat habitatores suos: populus, quem aspeximus, proceræ staturæ est. ");
INSERT INTO latVUC_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","Ibi vidimus monstra quædam filiorum Enac de genere giganteo: quibus comparati, quasi locustæ videbamur. ");
INSERT INTO latVUC_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Igitur vociferans omnis turba flevit nocte illa, ");
INSERT INTO latVUC_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","et murmurati sunt contra Moysen et Aaron cuncti filii Israël, dicentes: ");
INSERT INTO latVUC_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Utinam mortui essemus in Ægypto: et in hac vasta solitudine utinam pereamus, et non inducat nos Dominus in terram istam, ne cadamus gladio, et uxores ac liberi nostri ducantur captivi. Nonne melius est reverti in Ægyptum? ");
INSERT INTO latVUC_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Dixeruntque alter ad alterum: Constituamus nobis ducem, et revertamur in Ægyptum. ");
INSERT INTO latVUC_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Quo audito, Moyses et Aaron ceciderunt proni in terram coram omni multitudine filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","At vero Josue filius Nun et Caleb filius Jephone, qui et ipsi lustraverant terram, sciderunt vestimenta sua, ");
INSERT INTO latVUC_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","et ad omnem multitudinem filiorum Israël locuti sunt: Terra, quam circuivimus, valde bona est. ");
INSERT INTO latVUC_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si propitius fuerit Dominus, inducet nos in eam, et tradet humum lacte et melle manantem. ");
INSERT INTO latVUC_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nolite rebelles esse contra Dominum: neque timeatis populum terræ hujus, quia sicut panem ita eos possumus devorare. Recessit ab eis omne præsidium: Dominus nobiscum est, nolite metuere. ");
INSERT INTO latVUC_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Cumque clamaret omnis multitudo, et lapidibus eos vellet opprimere, apparuit gloria Domini super tectum fœderis cunctis filiis Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Et dixit Dominus ad Moysen: Usquequo detrahet mihi populus iste? quousque non credent mihi, in omnibus signis quæ feci coram eis? ");
INSERT INTO latVUC_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Feriam igitur eos pestilentia, atque consumam: te autem faciam principem super gentem magnam, et fortiorem quam hæc est. ");
INSERT INTO latVUC_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Et ait Moyses ad Dominum: Ut audiant Ægyptii, de quorum medio eduxisti populum istum, ");
INSERT INTO latVUC_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","et habitatores terræ hujus, qui audierunt quod tu, Domine, in populo isto sis, et facie videaris ad faciem, et nubes tua protegat illos, et in columna nubis præcedas eos per diem, et in columna ignis per noctem: ");
INSERT INTO latVUC_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","quod occideris tantam multitudinem quasi unum hominem, et dicant: ");
INSERT INTO latVUC_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Non poterat introducere populum in terram pro qua juraverat: idcirco occidit eos in solitudine? ");
INSERT INTO latVUC_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Magnificetur ergo fortitudo Domini sicut jurasti, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Dominus patiens et multæ misericordiæ, auferens iniquitatem et scelera, nullumque innoxium derelinquens, qui visitas peccata patrum in filios in tertiam et quartam generationem. ");
INSERT INTO latVUC_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Dimitte, obsecro, peccatum populi hujus secundum magnitudinem misericordiæ tuæ, sicut propitius fuisti egredientibus de Ægypto usque ad locum istum. ");
INSERT INTO latVUC_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Dixitque Dominus: Dimisi juxta verbum tuum. ");
INSERT INTO latVUC_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Vivo ego: et implebitur gloria Domini universa terra. ");
INSERT INTO latVUC_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Attamen omnes homines qui viderunt majestatem meam, et signa quæ feci in Ægypto et in solitudine, et tentaverunt me jam per decem vices, nec obedierunt voci meæ, ");
INSERT INTO latVUC_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","non videbunt terram pro qua juravi patribus eorum, nec quisquam ex illis qui detraxit mihi, intuebitur eam. ");
INSERT INTO latVUC_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Servum meum Caleb, qui plenus alio spiritu secutus est me, inducam in terram hanc, quam circuivit; et semen ejus possidebit eam. ");
INSERT INTO latVUC_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Quoniam Amalecites et Chananæus habitant in vallibus. Cras movete castra, et revertimini in solitudinem per viam maris Rubri. ");
INSERT INTO latVUC_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Locutusque est Dominus ad Moysen et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Usquequo multitudo hæc pessima murmurat contra me? querelas filiorum Israël audivi. ");
INSERT INTO latVUC_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Dic ergo eis: Vivo ego, ait Dominus: sicut locuti estis audiente me, sic faciam vobis. ");
INSERT INTO latVUC_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","In solitudine hac jacebunt cadavera vestra. Omnes qui numerati estis a viginti annis et supra, et murmurastis contra me, ");
INSERT INTO latVUC_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","non intrabitis terram, super quam levavi manum meam ut habitare vos facerem, præter Caleb filium Jephone, et Josue filium Nun. ");
INSERT INTO latVUC_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Parvulos autem vestros, de quibus dixistis quod prædæ hostibus forent, introducam, ut videant terram, quæ vobis displicuit. ");
INSERT INTO latVUC_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Vestra cadavera jacebunt in solitudine. ");
INSERT INTO latVUC_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Filii vestri erunt vagi in deserto annis quadraginta, et portabunt fornicationem vestram, donec consumantur cadavera patrum in deserto, ");
INSERT INTO latVUC_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","juxta numerum quadraginta dierum, quibus considerastis terram: annus pro die imputabitur. Et quadraginta annis recipietis iniquitates vestras, et scietis ultionem meam: ");
INSERT INTO latVUC_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","quoniam sicut locutus sum, ita faciam omni multitudini huic pessimæ, quæ consurrexit adversum me: in solitudine hac deficiet, et morietur. ");
INSERT INTO latVUC_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Igitur omnes viri, quos miserat Moyses ad contemplandam terram, et qui reversi murmurare fecerant contra eum omnem multitudinem, detrahentes terræ quod esset mala, ");
INSERT INTO latVUC_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","mortui sunt atque percussi in conspectu Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Josue autem filius Nun, et Caleb filius Jephone, vixerunt ex omnibus qui perrexerant ad considerandam terram. ");
INSERT INTO latVUC_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Locutusque est Moyses universa verba hæc ad omnes filios Israël, et luxit populus nimis. ");
INSERT INTO latVUC_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Et ecce mane primo surgentes ascenderunt verticem montis, atque dixerunt: Parati sumus ascendere ad locum, de quo Dominus locutus est: quia peccavimus. ");
INSERT INTO latVUC_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Quibus Moyses: Cur, inquit, transgredimini verbum Domini, quod vobis non cedet in prosperum? ");
INSERT INTO latVUC_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","nolite ascendere: non enim est Dominus vobiscum: ne corruatis coram inimicis vestris. ");
INSERT INTO latVUC_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalecites et Chananæus ante vos sunt, quorum gladio corruetis, eo quod nolueritis acquiescere Domino: nec erit Dominus vobiscum. ");
INSERT INTO latVUC_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","At illi contenebrati ascenderunt in verticem montis. Arca autem testamenti Domini et Moyses non recesserunt de castris. ");
INSERT INTO latVUC_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Descenditque Amalecites et Chananæus, qui habitabat in monte: et percutiens eos atque concidens, persecutus est eos usque Horma. ");
INSERT INTO latVUC_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Loquere ad filios Israël, et dices ad eos: Cum ingressi fueritis terram habitationis vestræ, quam ego dabo vobis, ");
INSERT INTO latVUC_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","et feceritis oblationem Domino in holocaustum, aut victimam, vota solventes, vel sponte offerentes munera, aut in solemnitatibus vestris adolentes odorem suavitatis Domino, de bobus sive de ovibus: ");
INSERT INTO latVUC_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","offeret quicumque immolaverit victimam, sacrificium similæ, decimam partem ephi, conspersæ oleo, quod mensuram habebit quartam partem hin: ");
INSERT INTO latVUC_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","et vinum ad liba fundenda ejusdem mensuræ dabit in holocaustum sive in victimam. Per agnos singulos ");
INSERT INTO latVUC_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","et arietes erit sacrificium similæ duarum decimarum, quæ conspersa sit oleo tertiæ partis hin: ");
INSERT INTO latVUC_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","et vinum ad libamentum tertiæ partis ejusdem mensuræ offeret in odorem suavitatis Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Quando vero de bobus feceris holocaustum aut hostiam, ut impleas votum vel pacificas victimas, ");
INSERT INTO latVUC_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","dabis per singulos boves similæ tres decimas conspersæ oleo, quod habeat medium mensuræ hin: ");
INSERT INTO latVUC_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","et vinum ad liba fundenda ejusdem mensuræ in oblationem suavissimi odoris Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Sic facies ");
INSERT INTO latVUC_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","per singulos boves et arietis et agnos et hædos. ");
INSERT INTO latVUC_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Tam indigenæ quam peregrini ");
INSERT INTO latVUC_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","eodem ritu offerent sacrificia. ");
INSERT INTO latVUC_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Unum præceptum erit atque judicium tam vobis quam advenis terræ. ");
INSERT INTO latVUC_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Loquere filiis Israël, et dices ad eos: ");
INSERT INTO latVUC_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Cum veneritis in terram, quam dabo vobis, ");
INSERT INTO latVUC_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","et comederitis de panibus regionis illius, separabitis primitias Domino ");
INSERT INTO latVUC_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","de cibis vestris. Sicut de areis primitias separatis, ");
INSERT INTO latVUC_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ita et de pulmentis dabitis primitiva Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Quod si per ignorantiam præterieritis quidquam horum, quæ locutus est Dominus ad Moysen, ");
INSERT INTO latVUC_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","et mandavit per eum ad vos, a die qua cœpit jubere et ultra, ");
INSERT INTO latVUC_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","oblitaque fuerit facere multitudo: offeret vitulum de armento, holocaustum in odorem suavissimum Domino, et sacrificum ejus ac liba, ut cæremoniæ postulant, hircumque pro peccato: ");
INSERT INTO latVUC_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","et rogabit sacerdos pro omni multitudine filiorum Israël, et dimittetur eis, quoniam non sponte peccaverunt, nihilominus offerentes incensum Domino pro se et pro peccato atque errore suo: ");
INSERT INTO latVUC_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","et dimittetur universæ plebi filiorum Israël, et advenis qui peregrinantur inter eos: quoniam culpa est omnis populi per ignorantiam. ");
INSERT INTO latVUC_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Quod si anima una nesciens peccaverit, offeret capram anniculam pro peccato suo: ");
INSERT INTO latVUC_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","et deprecabitur pro ea sacerdos, quod inscia peccaverit coram Domino: impetrabitque ei veniam, et dimittetur illi. ");
INSERT INTO latVUC_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Tam indigenis quam advenis una lex erit omnium, qui peccaverint ignorantes. ");
INSERT INTO latVUC_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Anima vero, quæ per superbiam aliquid commiserit, sive civis sit ille, sive peregrinus (quoniam adversus Dominum rebellis fuit), peribit de populo suo: ");
INSERT INTO latVUC_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","verbum enim Domini contempsit, et præceptum illius fecit irritum: idcirco delebitur, et portabit iniquitatem suam. ");
INSERT INTO latVUC_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Factum est autem, cum essent filii Israël in solitudine, et invenissent hominem colligentem ligna in die sabbati, ");
INSERT INTO latVUC_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","obtulerunt eum Moysi et Aaron et universæ multitudini. ");
INSERT INTO latVUC_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Qui recluserunt eum in carcerem, nescientes quid super eo facere deberent. ");
INSERT INTO latVUC_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Dixitque Dominus ad Moysen: Morte moriatur homo iste: obruat eum lapidibus omnis turba extra castra. ");
INSERT INTO latVUC_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Cumque eduxissent eum foras, obruerunt lapidibus, et mortuus est, sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Dixit quoque Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Loquere filiis Israël, et dices ad eos ut faciant sibi fimbrias per angulos palliorum, ponentes in eis vittas hyacinthinas: ");
INSERT INTO latVUC_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","quas cum viderint, recordentur omnium mandatorum Domini, nec sequantur cogitationes suas et oculos per res varias fornicantes, ");
INSERT INTO latVUC_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","sed magis memores præceptorum Domini faciant ea, sintque sancti Deo suo. ");
INSERT INTO latVUC_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ego Dominus Deus vester, qui eduxi vos de terra Ægypti, ut essem Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ecce autem Core filius Isaar, filii Caath, filii Levi, et Dathan atque Abiron filii Eliab, Hon quoque filius Pheleth de filiis Ruben, ");
INSERT INTO latVUC_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","surrexerunt contra Moysen, aliique filiorum Israël ducenti quinquaginta viri proceres synagogæ, et qui tempore concilii per nomina vocabantur. ");
INSERT INTO latVUC_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Cumque stetissent adversum Moysen et Aaron, dixerunt: Sufficiat vobis, quia omnis multitudo sanctorum est, et in ipsis est Dominus: cur elevamini super populum Domini? ");
INSERT INTO latVUC_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Quod cum audisset Moyses, cecidit pronus in faciem: ");
INSERT INTO latVUC_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","locutusque ad Core et ad omnem multitudinem: Mane, inquit, notum faciet Dominus qui ad se pertineant, et sanctos applicabit sibi: et quos elegerit, appropinquabunt ei. ");
INSERT INTO latVUC_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Hoc igitur facite: tollat unusquisque thuribula sua, tu Core, et omne concilium tuum: ");
INSERT INTO latVUC_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","et hausto cras igne, ponite desuper thymiama coram Domino: et quemcumque elegerit, ipse erit sanctus: multum erigimini filii Levi. ");
INSERT INTO latVUC_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Dixitque rursum ad Core: Audite, filii Levi: ");
INSERT INTO latVUC_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","num parum vobis est quod separavit vos Deus Israël ab omni populo, et junxit sibi, ut serviretis ei in cultu tabernaculi, et staretis coram frequentia populi, et ministraretis ei? ");
INSERT INTO latVUC_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","idcirco ad se fecit accedere te et omnes fratres tuos filios Levi, ut vobis etiam sacerdotium vindicetis, ");
INSERT INTO latVUC_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","et omnis globus tuus stet contra Dominum? quid est enim Aaron ut murmuretis contra eum? ");
INSERT INTO latVUC_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Misit ergo Moyses ut vocaret Dathan et Abiron filios Eliab. Qui responderunt: Non venimus. ");
INSERT INTO latVUC_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Numquid parum est tibi quod eduxisti nos de terra, quæ lacte et melle manabat, ut occideres in deserto, nisi et dominatus fueris nostri? ");
INSERT INTO latVUC_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Revera induxisti nos in terram, quæ fluit rivis lactis et mellis, et dedisti nobis possessiones agrorum et vinearum: an et oculos nostros vis eruere? non venimus. ");
INSERT INTO latVUC_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Iratusque Moyses valde, ait ad Dominum: Ne respicias sacrificia eorum: tu scis quod ne asellum quidem umquam acceperim ab eis, nec afflixerim quempiam eorum. ");
INSERT INTO latVUC_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Dixitque ad Core: Tu, et omnis congregatio tua, state seorsum coram Domino, et Aaron die crastino separatim. ");
INSERT INTO latVUC_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Tollite singuli thuribula vestra, et ponite super ea incensum, offerentes Domino ducenta quinquaginta thuribula: Aaron quoque teneat thuribulum suum. ");
INSERT INTO latVUC_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Quod cum fecissent, stantibus Moyses et Aaron, ");
INSERT INTO latVUC_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","et coacervassent adversum eos omnem multitudinem ad ostium tabernaculi, apparuit cunctis gloria Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Locutusque Dominus ad Moysen et Aaron, ait: ");
INSERT INTO latVUC_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Separamini de medio congregationis hujus, ut eos repente disperdam. ");
INSERT INTO latVUC_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Qui ceciderunt proni in faciem, atque dixerunt: Fortissime Deus spirituum universæ carnis, num uno peccante, contra omnes ira tua desæviet? ");
INSERT INTO latVUC_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Et ait Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Præcipe universo populo ut separetur a tabernaculis Core et Dathan et Abiron. ");
INSERT INTO latVUC_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Surrexitque Moyses, et abiit ad Dathan et Abiron: et sequentibus eum senioribus Israël, ");
INSERT INTO latVUC_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","dixit ad turbam: Recedite a tabernaculis hominum impiorum, et nolite tangere quæ ad eos pertinent, ne involvamini in peccatis eorum. ");
INSERT INTO latVUC_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Cumque recessissent a tentoriis eorum per circuitum, Dathan et Abiron egressi stabant in introitu papilionum suorum cum uxoribus et liberis, omnique frequentia. ");
INSERT INTO latVUC_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Et ait Moyses: In hoc scietis quod Dominus miserit me ut facerem universa quæ cernitis, et non ex proprio ea corde protulerim: ");
INSERT INTO latVUC_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","si consueta hominum morte interierint, et visitaverit eos plaga, qua et ceteri visitari solent, non misit me Dominus: ");
INSERT INTO latVUC_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","sin autem novam rem fecerit Dominus, ut aperiens terra os suum deglutiat eos et omnia quæ ad illos pertinent, descenderintque viventes in infernum, scietis quod blasphemaverint Dominum. ");
INSERT INTO latVUC_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Confestim igitur ut cessavit loqui, dirupta est terra sub pedibus eorum: ");
INSERT INTO latVUC_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","et aperiens os suum, devoravit illos cum tabernaculis suis et universa substantia eorum, ");
INSERT INTO latVUC_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","descenderuntque vivi in infernum operti humo, et perierunt de medio multitudinis. ");
INSERT INTO latVUC_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","At vero omnis Israël, qui stabat per gyrum, fugit ad clamorem pereuntium, dicens: Ne forte et nos terra deglutiat. ");
INSERT INTO latVUC_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Sed et ignis egressus a Domino interfecit ducentos quinquaginta viros, qui offerebant incensum. ");
INSERT INTO latVUC_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Præcipe Eleazaro filio Aaron sacerdoti ut tollat thuribula quæ jacent in incendio, et ignem huc illucque dispergat: quoniam sanctificata sunt ");
INSERT INTO latVUC_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","in mortibus peccatorum: producatque ea in laminas, et affigat altari, eo quod oblatum sit in eis incensum Domino, et sanctificata sint, ut cernant ea pro signo et monimento filii Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Tulit ergo Eleazar sacerdos thuribula ænea, in quibus obtulerant hi quos incendium devoravit, et produxit ea in laminas, affigens altari: ");
INSERT INTO latVUC_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ut haberent postea filii Israël, quibus commonerentur ne quis accedat alienigena, et qui non est de semine Aaron ad offerendum incensum Domino, ne patiatur sicut passus est Core, et omnis congregatio ejus, loquente Domino ad Moysen. ");
INSERT INTO latVUC_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Murmuravit autem omnis multitudo filiorum Israël sequenti die contra Moysen et Aaron, dicens: Vos interfecistis populum Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Cumque oriretur seditio, et tumultus incresceret, ");
INSERT INTO latVUC_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moyses et Aaron fugerunt ad tabernaculum fœderis. Quod, postquam ingressi sunt, operuit nubes, et apparuit gloria Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Dixitque Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Recedite de medio hujus multitudinis, etiam nunc delebo eos. Cumque jacerent in terra, ");
INSERT INTO latVUC_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","dixit Moyses ad Aaron: Tolle thuribulum, et hausto igne de altari, mitte incensum desuper, pergens cito ad populum, ut roges pro eis: jam enim egressa est ira a Domino, et plaga desævit. ");
INSERT INTO latVUC_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Quod cum fecisset Aaron, et cucurrisset ad mediam multitudinem, quam jam vastabat incendium, obtulit thymiama: ");
INSERT INTO latVUC_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","et stans inter mortuos ac viventes, pro populo deprecatus est, et plaga cessavit. ");
INSERT INTO latVUC_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Fuerunt autem qui percussi sunt, quatuordecim millia hominum, et septingenti, absque his qui perierant in seditione Core. ");
INSERT INTO latVUC_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Reversusque est Aaron ad Moysen ad ostium tabernaculi fœderis postquam quievit interitus. ");
INSERT INTO latVUC_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Et locutus est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Loquere ad filios Israël, et accipe ab eis virgas singulas per cognationes suas, a cunctis principibus tribuum, virgas duodecim, et uniuscujusque nomen superscribes virgæ suæ. ");
INSERT INTO latVUC_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Nomen autem Aaron erit in tribu Levi, et una virga cunctas seorsum familias continebit: ");
INSERT INTO latVUC_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ponesque eas in tabernaculo fœderis coram testimonio, ubi loquar ad te. ");
INSERT INTO latVUC_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Quem ex his elegero, germinabit virga ejus: et cohibebo a me querimonias filiorum Israël, quibus contra vos murmurant. ");
INSERT INTO latVUC_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Locutusque est Moyses ad filios Israël: et dederunt ei omnes principes virgas per singulas tribus: fueruntque virgæ duodecim absque virga Aaron. ");
INSERT INTO latVUC_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Quas cum posuisset Moyses coram Domino in tabernaculo testimonii, ");
INSERT INTO latVUC_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","sequenti die regressus invenit germinasse virgam Aaron in domo Levi: et turgentibus gemmis eruperant flores, qui, foliis dilatatis, in amygdalas deformati sunt. ");
INSERT INTO latVUC_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Protulit ergo Moyses omnes virgas de conspectu Domini ad cunctos filios Israël: videruntque, et receperunt singuli virgas suas. ");
INSERT INTO latVUC_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Dixitque Dominus ad Moysen: Refer virgam Aaron in tabernaculum testimonii, ut servetur ibi in signum rebellium filiorum Israël, et quiescant querelæ eorum a me, ne moriantur. ");
INSERT INTO latVUC_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Fecitque Moyses sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Dixerunt autem filii Israël ad Moysen: Ecce consumpti sumus, omnes perivimus. ");
INSERT INTO latVUC_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Quicumque accedit ad tabernaculum Domini, moritur. Num usque ad internecionem cuncti delendi sumus? ");
INSERT INTO latVUC_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Dixitque Dominus ad Aaron: Tu, et filii tui, et domus patris tui tecum, portabitis iniquitatem sanctuarii: et tu et filii tui simul sustinebitis peccata sacerdotii vestri. ");
INSERT INTO latVUC_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Sed et fratres tuos de tribu Levi, et sceptrum patris tui sume tecum, præstoque sint, et ministrent tibi: tu autem et filii tui ministrabitis in tabernaculo testimonii. ");
INSERT INTO latVUC_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Excubabuntque Levitæ ad præcepta tua, et ad cuncta opera tabernaculi: ita dumtaxat ut ad vasa sanctuarii et ad altare non accedant, ne et illi moriantur, et vos pereatis simul. ");
INSERT INTO latVUC_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Sint autem tecum, et excubent in custodiis tabernaculi, et in omnibus cæremoniis ejus. Alienigena non miscebitur vobis. ");
INSERT INTO latVUC_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Excubate in custodia sanctuarii, et in ministerio altaris: ne oriatur indignatio super filios Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ego dedi vobis fratres vestros Levitas de medio filiorum Israël, et tradidi donum Domino, ut serviant in ministeriis tabernaculi ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Tu autem et filii tui custodite sacerdotium vestrum: et omnia quæ ad cultum altaris pertinent, et intra velum sunt, per sacerdotes administrabuntur: si quis externus accesserit, occidetur. ");
INSERT INTO latVUC_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Locutusque est Dominus ad Aaron: Ecce dedi tibi custodiam primitiarum mearum. Omnia quæ sanctificantur a filiis Israël, tradidi tibi et filiis tuis pro officio sacerdotali legitima sempiterna. ");
INSERT INTO latVUC_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Hæc ergo accipies de his, quæ sanctificantur et oblata sunt Domino. Omnis oblatio, et sacrificium, et quidquid pro peccato atque delicto redditur mihi, et cedit in Sancta sanctorum, tuum erit, et filiorum tuorum. ");
INSERT INTO latVUC_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","In sanctuario comedes illud: mares tantum edent ex eo, quia consecratum est tibi. ");
INSERT INTO latVUC_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Primitias autem, quas voverint et obtulerint filii Israël, tibi dedi, et filiis tuis, ac filiabus tuis, jure perpetuo: qui mundus est in domo tua, vescetur eis. ");
INSERT INTO latVUC_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Omnem medullam olei, et vini, ac frumenti, quidquid offerunt primitiarum Domino, tibi dedi. ");
INSERT INTO latVUC_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Universa frugum initia, quas gignit humus, et Domino deportantur, cedent in usus tuos: qui mundus est in domo tua, vescetur eis. ");
INSERT INTO latVUC_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Omne quod ex voto reddiderint filii Israël, tuum erit. ");
INSERT INTO latVUC_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Quidquid primum erumpit e vulva cunctæ carnis, quam offerunt Domino, sive ex hominibus, sive de pecoribus fuerit, tui juris erit: ita dumtaxat ut pro hominis primogenito pretium accipias, et omne animal quod immundum est redimi facias, ");
INSERT INTO latVUC_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","cujus redemptio erit post unum mensem, siclis argenti quinque, pondere sanctuarii. Siclus viginti obolos habet. ");
INSERT INTO latVUC_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Primogenitum autem bovis, et ovis, et capræ, non facies redimi, quia sanctificata sunt Domino. Sanguinem tantum eorum fundes super altare, et adipes adolebis in suavissimum odorem Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Carnes vero in usum tuum cedent, sicut pectusculum consecratum, et armus dexter: tua erunt. ");
INSERT INTO latVUC_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Omnes primitias sanctuarii, quas offerunt filii Israël Domino, tibi dedi, et filiis, ac filiabus tuis, jure perpetuo. Pactum salis est sempiternum coram Domino, tibi ac filiis tuis. ");
INSERT INTO latVUC_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Dixitque Dominus ad Aaron: In terra eorum nihil possidebitis, nec habebitis partem inter eos: ego pars et hæreditas tua in medio filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Filiis autem Levi dedi omnes decimas Israëlis in possessionem, pro ministerio, quo serviunt mihi in tabernaculo fœderis: ");
INSERT INTO latVUC_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ut non accedant ultra filii Israël ad tabernaculum, nec committant peccatum mortiferum, ");
INSERT INTO latVUC_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","solis filiis Levi mihi in tabernaculo servientibus, et portantibus peccata populi. Legitimum sempiternum erit in generationibus vestris. Nihil aliud possidebunt, ");
INSERT INTO latVUC_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","decimarum oblatione contenti, quas in usus eorum et necessaria separavi. ");
INSERT INTO latVUC_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Præcipe Levitis, atque denuntia: Cum acceperitis a filiis Israël decimas, quas dedi vobis, primitias earum offerte Domino, id est, decimam partem decimæ, ");
INSERT INTO latVUC_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ut reputetur vobis in oblationem primitivorum, tam de areis quam de torcularibus: ");
INSERT INTO latVUC_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","et universis quorum accipitis primitias, offerte Domino, et date Aaron sacerdoti. ");
INSERT INTO latVUC_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Omnia quæ offeretis ex decimis, et in donaria Domini separabitis, optima et electa erunt. ");
INSERT INTO latVUC_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Dicesque ad eos: Si præclara et meliora quæque obtuleritis ex decimis, reputabitur vobis quasi de area, et torculari dederitis primitias: ");
INSERT INTO latVUC_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","et comedetis eas in omnibus locis vestris, tam vos quam familiæ vestræ: quia pretium est pro ministerio, quo servitis in tabernaculo testimonii. ");
INSERT INTO latVUC_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Et non peccabitis super hoc, egregia vobis et pinguia reservantes, ne polluatis oblationes filiorum Israël, et moriamini. ");
INSERT INTO latVUC_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Locutusque est Dominus ad Moysen et Aaron, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Ista est religio victimæ, quam constituit Dominus. Præcipe filiis Israël, ut adducant ad te vaccam rufam ætatis integræ, in qua nulla sit macula, nec portaverit jugum: ");
INSERT INTO latVUC_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","tradetisque eam Eleazaro sacerdoti, qui eductam extra castra, immolabit in conspectu omnium: ");
INSERT INTO latVUC_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","et tingens digitum in sanguine ejus, asperget contra fores tabernaculi septem vicibus, ");
INSERT INTO latVUC_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","comburetque eam cunctis videntibus, tam pelle et carnibus ejus quam sanguine et fimo flammæ traditis. ");
INSERT INTO latVUC_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Lignum quoque cedrinum, et hyssopum, coccumque bis tinctum sacerdos mittet in flammam, quæ vaccam vorat. ");
INSERT INTO latVUC_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Et tunc demum, lotis vestibus et corpore suo, ingredietur in castra, commaculatusque erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Sed et ille qui combusserit eam, lavabit vestimenta sua et corpus, et immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Colliget autem vir mundus cineres vaccæ, et effundet eos extra castra in loco purissimo, ut sint multitudini filiorum Israël in custodiam, et in aquam aspersionis: quia pro peccato vacca combusta est. ");
INSERT INTO latVUC_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Cumque laverit qui vaccæ portaverat cineres vestimenta sua, immundus erit usque ad vesperum. Habebunt hoc filii Israël, et advenæ qui habitant inter eos, sanctum jure perpetuo. ");
INSERT INTO latVUC_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Qui tetigerit cadaver hominis, et propter hoc septem diebus fuerit immundus, ");
INSERT INTO latVUC_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","aspergetur ex hac aqua die tertio et septimo, et sic mundabitur. Si die tertio aspersus non fuerit, septimo non poterit emundari. ");
INSERT INTO latVUC_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Omnis qui tetigerit humanæ animæ morticinum, et aspersus hac commistione non fuerit, polluet tabernaculum Domini et peribit ex Israël: quia aqua expiationis non est aspersus, immundus erit, et manebit spurcitia ejus super eum. ");
INSERT INTO latVUC_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ista est lex hominis qui moritur in tabernaculo: omnes qui ingrediuntur tentorium illius, et universa vasa quæ ibi sunt, polluta erunt septem diebus. ");
INSERT INTO latVUC_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Vas, quod non habuerit operculum nec ligaturam desuper, immundum erit. ");
INSERT INTO latVUC_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Si quis in agro tetigerit cadaver occisi hominis, aut per se mortui, sive os illius, vel sepulchrum, immundus erit septem diebus. ");
INSERT INTO latVUC_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Tollentque de cineribus combustionis atque peccati, et mittent aquas vivas super eos in vas: ");
INSERT INTO latVUC_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","in quibus cum homo mundus tinxerit hyssopum, asperget ex eo omne tentorium, et cunctam supellectilem, et homines hujuscemodi contagione pollutos: ");
INSERT INTO latVUC_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","atque hoc modo mundus lustrabit immundum tertio et septimo die: expiatusque die septimo, lavabit et se et vestimenta sua, et immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Si quis hoc ritu non fuerit expiatus, peribit anima illius de medio ecclesiæ: quia sanctuarium Domini polluit, et non est aqua lustrationis aspersus. ");
INSERT INTO latVUC_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Erit hoc præceptum legitimum sempiternum. Ipse quoque qui aspergit aquas, lavabit vestimenta sua. Omnis qui tetigerit aquas expiationis, immundus erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Quidquid tetigerit immundus, immundum faciet: et anima, quæ horum quippiam tetigerit, immunda erit usque ad vesperum. ");
INSERT INTO latVUC_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Veneruntque filii Israël et omnis multitudo in desertum Sin, mense primo, et mansit populus in Cades. Mortuaque est ibi Maria, et sepulta in eodem loco. ");
INSERT INTO latVUC_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Cumque indigeret aqua populus, convenerunt adversum Moysen et Aaron: ");
INSERT INTO latVUC_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","et versi in seditionem, dixerunt: Utinam periissemus inter fratres nostros coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Cur eduxistis ecclesiam Domini in solitudinem, ut et nos et nostra jumenta moriamur? ");
INSERT INTO latVUC_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","quare nos fecistis ascendere de Ægypto, et adduxistis in locum istum pessimum, qui seri non potest, qui nec ficum gignit, nec vineas, nec malogranata, insuper et aquam non habet ad bibendum? ");
INSERT INTO latVUC_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ingressusque Moyses et Aaron, dimissa multitudine, tabernaculum fœderis, corruerunt proni in terram, clamaveruntque ad Dominum, atque dixerunt: Domine Deus, audi clamorem hujus populi, et aperi eis thesaurum tuum fontem aquæ vivæ, ut satiati, cesset murmuratio eorum. Et apparuit gloria Domini super eos. ");
INSERT INTO latVUC_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Tolle virgam, et congrega populum, tu et Aaron frater tuus, et loquimini ad petram coram eis, et illa dabit aquas. Cumque eduxeris aquam de petra, bibet omnis multitudo et jumenta ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Tulit igitur Moyses virgam, quæ erat in conspectu Domini, sicut præceperat ei, ");
INSERT INTO latVUC_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","congregata multitudine ante petram: dixitque eis: Audite, rebelles et increduli: num de petra hac vobis aquam poterimus ejicere? ");
INSERT INTO latVUC_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Cumque elevasset Moyses manum, percutiens virga bis silicem, egressæ sunt aquæ largissimæ, ita ut populus biberet et jumenta. ");
INSERT INTO latVUC_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Dixitque Dominus ad Moysen et Aaron: Quia non credidistis mihi, ut sanctificaretis me coram filiis Israël, non introducetis hos populos in terram, quam dabo eis. ");
INSERT INTO latVUC_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Hæc est aqua contradictionis, ubi jurgati sunt filii Israël contra Dominum, et sanctificatus est in eis. ");
INSERT INTO latVUC_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Misit interea nuntios Moyses de Cades ad regem Edom, qui dicerent: Hæc mandat frater tuus Israël: Nosti omnem laborem qui apprehendit nos, ");
INSERT INTO latVUC_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","quomodo descenderint patres nostri in Ægyptum, et habitaverimus ibi multo tempore, afflixerintque nos Ægyptii, et patres nostros: ");
INSERT INTO latVUC_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","et quomodo clamaverimus ad Dominum, et exaudierit nos, miseritque angelum, qui eduxerit nos de Ægypto. Ecce in urbe Cades, quæ est in extremis finibus tuis, positi, ");
INSERT INTO latVUC_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","obsecramus ut nobis transire liceat per terram tuam. Non ibimus per agros, nec per vineas; non bibemus aquas de puteis tuis: sed gradiemur via publica, nec ad dexteram nec ad sinistram declinantes, donec transeamus terminos tuos. ");
INSERT INTO latVUC_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Cui respondit Edom: Non transibis per me, alioquin armatus occurram tibi. ");
INSERT INTO latVUC_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Dixeruntque filii Israël: Per tritam gradiemur viam: et si biberimus aquas tuas, nos et pecora nostra, dabimus quod justum est: nulla erit in pretio difficultas, tantum velociter transeamus. ");
INSERT INTO latVUC_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","At ille respondit: Non transibis. Statimque egressus est obvius, cum infinita multitudo, et manu forti, ");
INSERT INTO latVUC_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","nec voluit acquiescere deprecanti, ut concederet transitum per fines suos. Quam ob rem divertit ab eo Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Cumque castra movissent de Cades, venerunt in montem Hor, qui est in finibus terræ Edom: ");
INSERT INTO latVUC_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ubi locutus est Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Pergat, inquit, Aaron ad populos suos: non enim intrabit terram, quam dedi filiis Israël, eo quod incredulus fuerit ori meo, ad aquas contradictionis. ");
INSERT INTO latVUC_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Tolle Aaron et filium ejus cum eo, et duces eos in montem Hor. ");
INSERT INTO latVUC_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Cumque nudaveris patrem veste sua, indues ea Eleazarum filium ejus: Aaron colligetur, et morietur ibi. ");
INSERT INTO latVUC_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Fecit Moyses ut præceperat Dominus: et ascenderunt in montem Hor coram omni multitudine. ");
INSERT INTO latVUC_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Cumque Aaron spoliasset vestibus suis, induit eis Eleazarum filium ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Illo mortuo in montis supercilio, descendit cum Eleazaro. ");
INSERT INTO latVUC_vpl VALUES ("NU20_30","005_20_30","NUM","20","30","30","Omnis autem multitudo videns occubuisse Aaron, flevit super eo triginta diebus per cunctas familias suas. ");
INSERT INTO latVUC_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Quod cum audisset Chananæus rex Arad, qui habitabat ad meridiem, venisse scilicet Israël per exploratorum viam, pugnavit contra illum, et victor existens, duxit ex eo prædam. ");
INSERT INTO latVUC_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","At Israël voto se Domino obligans, ait: Si tradideris populum istum in manu mea, delebo urbes ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Exaudivitque Dominus preces Israël, et tradidit Chananæum, quem ille interfecit subversis urbibus ejus: et vocavit nomen loci illius Horma, id est, anathema. ");
INSERT INTO latVUC_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Profecti sunt autem et de monte Hor, per viam quæ ducit ad mare Rubrum, ut circumirent terram Edom. Et tædere cœpit populum itineris ac laboris: ");
INSERT INTO latVUC_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","locutusque contra Deum et Moysen, ait: Cur eduxisti nos de Ægypto, ut moreremur in solitudine? deest panis, non sunt aquæ: anima nostra jam nauseat super cibo isto levissimo. ");
INSERT INTO latVUC_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Quam ob rem misit Dominus in populum ignitos serpentes, ad quorum plagas et mortes plurimorum, ");
INSERT INTO latVUC_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","venerunt ad Moysen, atque dixerunt: Peccavimus, quia locuti sumus contra Dominum et te: ora ut tollat a nobis serpentes. Oravitque Moyses pro populo, ");
INSERT INTO latVUC_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","et locutus est Dominus ad eum: Fac serpentem æneum, et pone eum pro signo: qui percussus aspexerit eum, vivet. ");
INSERT INTO latVUC_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Fecit ergo Moyses serpentem æneum, et posuit eum pro signo: quem cum percussi aspicerent, sanabantur. ");
INSERT INTO latVUC_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Profectique filii Israël castrametati sunt in Oboth. ");
INSERT INTO latVUC_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Unde egressi fixere tentoria in Jeabarim, in solitudine quæ respicit Moab contra orientalem plagam. ");
INSERT INTO latVUC_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Et inde moventes, venerunt ad torrentem Zared. ");
INSERT INTO latVUC_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Quem relinquentes castrametati sunt contra Arnon, quæ est in deserto, et prominet in finibus Amorrhæi. Siquidem Arnon terminus est Moab, dividens Moabitas et Amorrhæos. ");
INSERT INTO latVUC_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Unde dicitur in libro bellorum Domini: Sicut fecit in mari Rubro, sic faciet in torrentibus Arnon. ");
INSERT INTO latVUC_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Scopuli torrentium inclinati sunt, ut requiescerent in Ar, et recumberent in finibus Moabitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ex eo loco apparuit puteus, super quo locutus est Dominus ad Moysen: Congrega populum, et dabo ei aquam. ");
INSERT INTO latVUC_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tunc cecinit Israël carmen istud: Ascendat puteus. Concinebant: ");
INSERT INTO latVUC_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Puteus, quem foderunt principes et paraverunt duces multitudinis in datore legis, et in baculis suis. De solitudine, Matthana. ");
INSERT INTO latVUC_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","De Matthana in Nahaliel: de Nahaliel in Bamoth. ");
INSERT INTO latVUC_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","De Bamoth, vallis est in regione Moab, in vertice Phasga, quod respicit contra desertum. ");
INSERT INTO latVUC_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Misit autem Israël nuntios ad Sehon regem Amorrhæorum, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Obsecro ut transire mihi liceat per terram tuam: non declinabimus in agros et vineas; non bibemus aquas ex puteis: via regia gradiemur, donec transeamus terminos tuos. ");
INSERT INTO latVUC_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Qui concedere noluit ut transiret Israël per fines suos: quin potius exercitu congregato, egressus est obviam in desertum, et venit in Jasa, pugnavitque contra eum. ");
INSERT INTO latVUC_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","A quo percussus est in ore gladii, et possessa est terra ejus ab Arnon usque Jeboc, et filios Ammon: quia forti præsidio tenebantur termini Ammonitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Tulit ergo Israël omnes civitates ejus, et habitavit in urbibus Amorrhæi, in Hesebon scilicet, et viculis ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Urbs Hesebon fuit Sehon regis Amorrhæi, qui pugnavit contra regem Moab: et tulit omnem terram, quæ ditionis illius fuerat usque Arnon. ");
INSERT INTO latVUC_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Idcirco dicitur in proverbio: Venite in Hesebon: ædificetur, et construatur civitas Sehon: ");
INSERT INTO latVUC_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ignis egressus est de Hesebon, flamma de oppido Sehon, et devoravit Ar Moabitarum, et habitatores excelsorum Arnon. ");
INSERT INTO latVUC_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Væ tibi Moab; peristi popule Chamos. Dedit filios ejus in fugam, et filias in captivitatem regi Amorrhæorum Sehon. ");
INSERT INTO latVUC_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Jugum ipsorum disperiit ad Hesebon usque Dibon: lassi pervenerunt in Nophe, et usque Medaba. ");
INSERT INTO latVUC_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Habitavit itaque Israël in terra Amorrhæi. ");
INSERT INTO latVUC_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Misitque Moyses qui explorarent Jazer: cujus ceperunt viculos, et possederunt habitatores. ");
INSERT INTO latVUC_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Verteruntque se, et ascenderunt per viam Basan, et occurrit eis Og, rex Basan, cum omni populo suo, pugnaturus in Edrai. ");
INSERT INTO latVUC_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Dixitque Dominus ad Moysen: Ne timeas eum, quia in manu tua tradidi illum, et omnem populum ac terram ejus: faciesque illi sicut fecisti Sehon, regi Amorrhæorum habitatori Hesebon. ");
INSERT INTO latVUC_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Percusserunt igitur et hunc cum filiis suis, universumque populum ejus usque ad internecionem, et possederunt terram illius. ");
INSERT INTO latVUC_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Profectique castrametati sunt in campestribus Moab, ubi trans Jordanem Jericho sita est. ");
INSERT INTO latVUC_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Videns autem Balac filius Sephor omnia quæ fecerat Israël Amorrhæo, ");
INSERT INTO latVUC_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","et quod pertimuissent eum Moabitæ, et impetum ejus ferre non possent, ");
INSERT INTO latVUC_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","dixit ad majores natu Madian: Ita delebit hic populus omnes, qui in nostris finibus commorantur, quomodo solet bos herbas usque ad radices carpere. Ipse erat eo tempore rex in Moab. ");
INSERT INTO latVUC_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Misit ergo nuntios ad Balaam filium Beor ariolum, qui habitabat super flumen terræ filiorum Ammon, ut vocarent eum, et dicerent: Ecce egressus est populus ex Ægypto, qui operuit superficiem terræ, sedens contra me. ");
INSERT INTO latVUC_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Veni igitur, et maledic populo huic, quia fortior me est: si quomodo possim percutere et ejicere eum de terra mea. Novi enim quod benedictus sit cui benedixeris, et maledictus in quem maledicta congesseris. ");
INSERT INTO latVUC_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Perrexeruntque seniores Moab, et majores natu Madian, habentes divinationis pretium in manibus. Cumque venissent ad Balaam, et narrassent ei omnia verba Balac, ");
INSERT INTO latVUC_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ille respondit: Manete hic nocte, et respondebo quidquid mihi dixerit Dominus. Manentibus illis apud Balaam, venit Deus, et ait ad eum: ");
INSERT INTO latVUC_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Quid sibi volunt homines isti apud te? ");
INSERT INTO latVUC_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Respondit: Balac filius Sephor rex Moabitarum misit ad me, ");
INSERT INTO latVUC_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","dicens: Ecce populus qui egressus est de Ægypto, operuit superficiem terræ: veni, et maledic ei, si quomodo possim pugnans abigere eum. ");
INSERT INTO latVUC_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Dixitque Deus ad Balaam: Noli ire cum eis, neque maledicas populo: quia benedictus est. ");
INSERT INTO latVUC_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Qui mane consurgens dixit ad principes: Ite in terram vestram, quia prohibuit me Dominus venire vobiscum. ");
INSERT INTO latVUC_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Reversi principes dixerunt ad Balac: Noluit Balaam venire nobiscum. ");
INSERT INTO latVUC_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Rursum ille multo plures et nobiliores quam ante miserat, misit. ");
INSERT INTO latVUC_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Qui cum venissent ad Balaam, dixerunt: Sic dicit Balac filius Sephor: Ne cuncteris venire ad me: ");
INSERT INTO latVUC_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","paratus sum honorare te, et quidquid volueris, dabo tibi: veni, et maledic populo isti. ");
INSERT INTO latVUC_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Respondit Balaam: Si dederit mihi Balac plenam domum suam argenti et auri, non potero immutare verbum Domini Dei mei, ut vel plus, vel minus loquar. ");
INSERT INTO latVUC_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Obsecro ut hic maneatis etiam hac nocte, et scire queam quid mihi rursum respondeat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Venit ergo Deus ad Balaam nocte, et ait ei: Si vocare te venerunt homines isti, surge, et vade cum eis: ita dumtaxat, ut quod tibi præcepero, facias. ");
INSERT INTO latVUC_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Surrexit Balaam mane, et strata asina sua profectus est cum eis. ");
INSERT INTO latVUC_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Et iratus est Deus. Stetitque angelus Domini in via contra Balaam, qui insidebat asinæ, et duos pueros habebat secum. ");
INSERT INTO latVUC_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Cernens asina angelum stantem in via, evaginato gladio, avertit se de itinere, et ibat per agrum. Quam cum verberaret Balaam, et vellet ad semitam reducere, ");
INSERT INTO latVUC_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","stetit angelus in angustiis duarum maceriarum, quibus vineæ cingebantur. ");
INSERT INTO latVUC_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Quem videns asina, junxit se parieti, et attrivit sedentis pedem. At ille iterum verberabat eam: ");
INSERT INTO latVUC_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","et nihilominus angelus ad locum angustum transiens, ubi nec ad dexteram, nec ad sinistram poterat deviare, obvius stetit. ");
INSERT INTO latVUC_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Cumque vidisset asina stantem angelum, concidit sub pedibus sedentis: qui iratus, vehementius cædebat fuste latera ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Aperuitque Dominus os asinæ, et locuta est: Quid feci tibi? cur percutis me ecce jam tertio? ");
INSERT INTO latVUC_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Respondit Balaam: Quia commeruisti, et illusisti mihi: utinam haberem gladium, ut te percuterem ! ");
INSERT INTO latVUC_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Dixit asina: Nonne animal tuum sum, cui semper sedere consuevisti usque in præsentem diem? dic quid simile umquam fecerim tibi. At ille ait: Numquam. ");
INSERT INTO latVUC_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Protinus aperuit Dominus oculos Balaam, et vidit angelum stantem in via, evaginato gladio, adoravitque eum pronus in terram. ");
INSERT INTO latVUC_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Cui angelus: Cur, inquit, tertio verberas asinam tuam? ego veni ut adversarer tibi, quia perversa est via tua, mihique contraria: ");
INSERT INTO latVUC_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","et nisi asina declinasset de via, dans locum resistenti, te occidissem, et illa viveret. ");
INSERT INTO latVUC_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Dixit Balaam: Peccavi, nesciens quod tu stares contra me: et nunc si displicet tibi ut vadam, revertar. ");
INSERT INTO latVUC_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ait angelus: Vade cum istis, et cave ne aliud quam præcepero tibi loquaris. Ivit igitur cum principibus. ");
INSERT INTO latVUC_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Quod cum audisset Balac, egressus est in occursum ejus in oppido Moabitarum, quod situm est in extremis finibus Arnon. ");
INSERT INTO latVUC_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Dixitque ad Balaam: Misi nuntios ut vocarent te: cur non statim venisti ad me? an quia mercedem adventui tuo reddere nequeo? ");
INSERT INTO latVUC_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Cui ille respondit: Ecce adsum: numquid loqui potero aliud, nisi quod Deus posuerit in ore meo? ");
INSERT INTO latVUC_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Perrexerunt ergo simul, et venerunt in urbem, quæ in extremis regni ejus finibus erat. ");
INSERT INTO latVUC_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Cumque occidisset Balac boves et oves, misit ad Balaam, et principes qui cum eo erant, munera. ");
INSERT INTO latVUC_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Mane autem facto, duxit eum ad excelsa Baal, et intuitus est extremam partem populi. ");
INSERT INTO latVUC_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Dixitque Balaam ad Balac: Ædifica mihi hic septem aras, et para totidem vitulos, ejusdemque numeri arietes. ");
INSERT INTO latVUC_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Cumque fecisset juxta sermonem Balaam, imposuerunt simul vitulum et arietem super aram. ");
INSERT INTO latVUC_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Dixitque Balaam ad Balac: Sta paulisper juxta holocaustum tuum, donec vadam, si forte occurrat mihi Dominus, et quodcumque imperaverit, loquar tibi. ");
INSERT INTO latVUC_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Cumque abiisset velociter, occurrit illi Deus. Locutusque ad eum Balaam: Septem, inquit, aras erexi, et imposui vitulum et arietem desuper. ");
INSERT INTO latVUC_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Dominus autem posuit verbum in ore ejus, et ait: Revertere ad Balac, et hæc loqueris. ");
INSERT INTO latVUC_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Reversus invenit stantem Balac juxta holocaustum suum, et omnes principes Moabitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","assumptaque parabola sua, dixit: De Aram adduxit me Balac rex Moabitarum, de montibus orientis: Veni, inquit, et maledic Jacob; propera, et detestare Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Quomodo maledicam, cui non maledixit Deus? qua ratione detester, quem Dominus non detestatur? ");
INSERT INTO latVUC_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","De summis silicibus videbo eum, et de collibus considerabo illum. Populus solus habitabit, et inter gentes non reputabitur. ");
INSERT INTO latVUC_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Quis dinumerare possit pulverem Jacob, et nosse numerum stirpis Israël? Moriatur anima mea morte justorum, et fiant novissima mea horum similia. ");
INSERT INTO latVUC_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Dixitque Balac ad Balaam: Quid est hoc quod agis? ut malediceres inimicis meis vocavi te, et tu e contrario benedicis eis. ");
INSERT INTO latVUC_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Cui ille respondit: Num aliud possum loqui, nisi quod jusserit Dominus? ");
INSERT INTO latVUC_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Dixit ergo Balac: Veni mecum in alterum locum unde partem Israël videas, et totum videre non possis: inde maledicito ei. ");
INSERT INTO latVUC_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Cumque duxisset eum in locum sublimem, super verticem montis Phasga, ædificavit Balaam septem aras, et impositis supra vitulo atque ariete, ");
INSERT INTO latVUC_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","dixit ad Balac: Sta hic juxta holocaustum tuum, donec ego obvius pergam. ");
INSERT INTO latVUC_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Cui cum Dominus occurrisset, posuissetque verbum in ore ejus, ait: Revertere ad Balac, et hæc loqueris ei. ");
INSERT INTO latVUC_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Reversus invenit eum stantem juxta holocaustum suum, et principes Moabitarum cum eo. Ad quem Balac: Quid, inquit, locutus est Dominus? ");
INSERT INTO latVUC_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","At ille, assumpta parabola sua, ait: Sta, Balac, et ausculta; audi, fili Sephor: ");
INSERT INTO latVUC_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","non est Deus quasi homo, ut mentiatur, nec ut filius hominis, ut mutetur. Dixit ergo, et non faciet? locutus est, et non implebit? ");
INSERT INTO latVUC_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ad benedicendum adductus sum: benedictionem prohibere non valeo. ");
INSERT INTO latVUC_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Non est idolum in Jacob, nec videtur simulacrum in Israël. Dominus Deus ejus cum eo est, et clangor victoriæ regis in illo. ");
INSERT INTO latVUC_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Deus eduxit illum de Ægypto, cujus fortitudo similis est rhinocerotis. ");
INSERT INTO latVUC_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Non est augurium in Jacob, nec divinatio in Israël: temporibus suis dicetur Jacob et Israëli quid operatus sit Deus. ");
INSERT INTO latVUC_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ecce populus ut leæna consurget, et quasi leo erigetur: non accubabit donec devoret prædam, et occisorum sanguinem bibat. ");
INSERT INTO latVUC_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Dixitque Balac ad Balaam: Nec maledicas ei, nec benedicas. ");
INSERT INTO latVUC_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Et ille ait: Nonne dixi tibi quod quidquid mihi Deus imperaret, hoc facerem? ");
INSERT INTO latVUC_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Et ait Balac ad eum: Veni, et ducam te ad alium locum: si forte placeat Deo ut inde maledicas eis. ");
INSERT INTO latVUC_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Cumque duxisset eum super verticem montis Phogor, qui respicit solitudinem, ");
INSERT INTO latVUC_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","dixit ei Balaam: Ædifica mihi hic septem aras, et para totidem vitulos, ejusdemque numeri arietes. ");
INSERT INTO latVUC_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Fecit Balac ut Balaam dixerat: imposuitque vitulos et arietes per singulas aras. ");
INSERT INTO latVUC_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Cumque vidisset Balaam quod placeret Domino ut benediceret Israëli, nequaquam abiit ut ante perrexerat, ut augurium quæreret: sed dirigens contra desertum vultum suum, ");
INSERT INTO latVUC_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","et elevans oculos, vidit Israël in tentoriis commorantem per tribus suas: et irruente in se spiritu Dei, ");
INSERT INTO latVUC_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","assumpta parabola, ait: Dixit Balaam filius Beor: dixit homo, cujus obturatus est oculus: ");
INSERT INTO latVUC_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","dixit auditor sermonum Dei, qui visionem Omnipotentis intuitus est, qui cadit, et sic aperiuntur oculi ejus: ");
INSERT INTO latVUC_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Quam pulchra tabernacula tua, Jacob, et tentoria tua, Israël ! ");
INSERT INTO latVUC_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ut valles nemorosæ, ut horti juxta fluvios irrigui, ut tabernacula quæ fixit Dominus, quasi cedri prope aquas. ");
INSERT INTO latVUC_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Fluet aqua de situla ejus, et semen illius erit in aquas multas. Tolletur propter Agag, rex ejus, et auferetur regnum illius. ");
INSERT INTO latVUC_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Deus eduxit illum de Ægypto, cujus fortitudo similis est rhinocerotis. Devorabunt gentes hostes illius, ossaque eorum confringent, et perforabunt sagittis. ");
INSERT INTO latVUC_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Accubans dormivit ut leo, et quasi leæna, quam suscitare nullus audebit. Qui benedixerit tibi, erit et ipse benedictus: qui maledixerit, in maledictione reputabitur. ");
INSERT INTO latVUC_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Iratusque Balac contra Balaam, complosis manibus ait: Ad maledicendum inimicis meis vocavi te, quibus e contrario tertio benedixisti: ");
INSERT INTO latVUC_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","revertere ad locum tuum. Decreveram quidem magnifice honorare te, sed Dominus privavit te honore disposito. ");
INSERT INTO latVUC_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Respondit Balaam ad Balac: Nonne nuntiis tuis, quos misisti ad me, dixi: ");
INSERT INTO latVUC_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Si dederit mihi Balac plenam domum suam argenti et auri, non potero præterire sermonem Domini Dei mei, ut vel boni quid vel mali proferam ex corde meo: sed quidquid Dominus dixerit, hoc loquar? ");
INSERT INTO latVUC_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","verumtamen pergens ad populum meum, dabo consilium, quid populus tuus populo huic faciat extremo tempore. ");
INSERT INTO latVUC_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Sumpta igitur parabola, rursum ait: Dixit Balaam filius Beor: dixit homo, cujus obturatus est oculus: ");
INSERT INTO latVUC_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","dixit auditor sermonum Dei, qui novit doctrinam Altissimi, et visiones Omnipotentis videt, qui cadens apertos habet oculos: ");
INSERT INTO latVUC_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Videbo eum, sed non modo: intuebor illum, sed non prope. Orietur stella ex Jacob, et consurget virga de Israël: et percutiet duces Moab, vastabitque omnes filios Seth. ");
INSERT INTO latVUC_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Et erit Idumæa possessio ejus: hæreditas Seir cedet inimicis suis: Israël vero fortiter aget. ");
INSERT INTO latVUC_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","De Jacob erit qui dominetur, et perdat reliquias civitatis. ");
INSERT INTO latVUC_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Cumque vidisset Amalec, assumens parabolam, ait: Principium gentium Amalec, cujus extrema perdentur. ");
INSERT INTO latVUC_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Vidit quoque Cinæum: et assumpta parabola, ait: Robustum quidem est habitaculum tuum: sed si in petra posueris nidum tuum, ");
INSERT INTO latVUC_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","et fueris electus de stirpe Cin, quamdiu poteris permanere? Assur enim capiet te. ");
INSERT INTO latVUC_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Assumptaque parabola iterum locutus est: Heu ! quis victurus est, quando ista faciet Deus? ");
INSERT INTO latVUC_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Venient in trieribus de Italia: superabunt Assyrios, vastabuntque Hebræos, et ad extremum etiam ipsi peribunt. ");
INSERT INTO latVUC_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Surrexitque Balaam, et reversus est in locum suum: Balac quoque via, qua venerat, rediit. ");
INSERT INTO latVUC_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Morabatur autem eo tempore Israël in Settim, et fornicatus est populus cum filiabus Moab, ");
INSERT INTO latVUC_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","quæ vocaverunt eos ad sacrificia sua. At ille comederunt et adoraverunt deos earum. ");
INSERT INTO latVUC_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Initiatusque est Israël Beelphegor: et iratus Dominus, ");
INSERT INTO latVUC_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ait ad Moysen: Tolle cunctos principes populi, et suspende eos contra solem in patibulis, ut avertatur furor meus ab Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Dixitque Moyses ad judices Israël: Occidat unusquisque proximos suos, qui initiati sunt Beelphegor. ");
INSERT INTO latVUC_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Et ecce unus de filiis Israël intravit coram fratribus suis ad scortum Madianitidem, vidente Moyse, et omni turba filiorum Israël, qui flebant ante fores tabernaculi. ");
INSERT INTO latVUC_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Quod cum vidisset Phinees filius Eleazari filii Aaron sacerdotis, surrexit de medio multitudinis, et arrepto pugione, ");
INSERT INTO latVUC_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ingressus est post virum Israëlitem in lupanar, et perfodit ambos simul, virum scilicet et mulierem in locis genitalibus. Cessavitque plaga a filiis Israël: ");
INSERT INTO latVUC_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","et occisi sunt viginti quatuor millia hominum. ");
INSERT INTO latVUC_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Dixitque Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Phinees filius Eleazari filii Aaron sacerdotis avertit iram meam a filiis Israël: quia zelo meo commotus est contra eos, ut non ipse delerem filios Israël in zelo meo. ");
INSERT INTO latVUC_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Idcirco loquere ad eum: Ecce do ei pacem fœderis mei, ");
INSERT INTO latVUC_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","et erit tam ipsi quam semini ejus pactum sacerdotii sempiternum: quia zelatus est pro Deo suo, et expiavit scelus filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Erat autem nomen viri Israëlitæ, qui occisus est cum Madianitide, Zambri filius Salu, dux de cognatione et tribu Simeonis. ");
INSERT INTO latVUC_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Porro mulier Madianitis, quæ pariter interfecta est, vocabatur Cozbi filia Sur principis nobilissimi Madianitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Hostes vos sentiant Madianitæ, et percutite eos: ");
INSERT INTO latVUC_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","quia et ipsi hostiliter egerunt contra vos, et decepere insidiis per idolum Phogor, et Cozbi filiam ducis Madian sororem suam, quæ percussa est in die plagæ pro sacrilegio Phogor. ");
INSERT INTO latVUC_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Postquam noxiorum sanguis effusus est, dixit Dominus ad Moysen et Eleazarum filium Aaron sacerdotem: ");
INSERT INTO latVUC_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Numerate omnem summam filiorum Israël a viginti annis et supra, per domos et cognationes suas, cunctos qui possunt ad bella procedere. ");
INSERT INTO latVUC_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Locuti sunt itaque Moyses et Eleazar sacerdos, in campestribus Moab super Jordanem contra Jericho, ad eos qui erant ");
INSERT INTO latVUC_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","a viginti annis et supra, sicut Dominus imperaverat, quorum iste est numerus. ");
INSERT INTO latVUC_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben primogenitus Israël: hujus filius, Henoch, a quo familia Henochitarum: et Phallu, a quo familia Phalluitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","et Hesron, a quo familia Hesronitarum: et Charmi, a quo familia Charmitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Hæ sunt familiæ de stirpe Ruben: quarum numerus inventus est quadraginta tria millia, et septingenti triginta. ");
INSERT INTO latVUC_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Filius Phallu, Eliab: ");
INSERT INTO latVUC_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","hujus filii, Namuel et Dathan et Abiron: isti sunt Dathan et Abiron principes populi, qui surrexerunt contra Moysen et Aaron in seditione Core, quando adversus Dominum rebellaverunt: ");
INSERT INTO latVUC_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","et aperiens terra os suum devoravit Core, morientibus plurimis, quando combussit ignis ducentos quinquaginta viros. Et factum est grande miraculum, ");
INSERT INTO latVUC_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ut, Core pereunte, filii illius non perirent. ");
INSERT INTO latVUC_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Filii Simeon per cognationes suas: Namuel, ab hoc familia Namuelitarum: Jamin, ab hoc familia Jaminitarum: Jachin, ab hoc familia Jachinitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zare, ab hoc familia Zareitarum: Saul, ab hoc familia Saulitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Hæ sunt familiæ de stirpe Simeon, quarum omnis numerus fuit viginti duo millia ducenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Filii Gad per cognationes suas: Sephon, ab hoc familia Sephonitarum: Aggi, ab hoc familia Aggitarum: Suni, ab hoc familia Sunitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, ab hoc familia Oznitarum: Her, ab hoc familia Heritarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, ab hoc familia Aroditarum: Ariel, ab hoc familia Arielitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Istæ sunt familiæ Gad, quarum omnis numerus fuit quadraginta millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Filii Juda, Her et Onan, qui ambo mortui sunt in terra Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Fueruntque filii Juda per cognationes suas: Sela, a quo familia Selaitarum: Phares, a quo familia Pharesitarum: Zare, a quo familia Zareitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Porro filii Phares: Hesron, a quo familia Hesronitarum: et Hamul, a quo familia Hamulitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Istæ sunt familiæ Juda, quarum omnis numerus fuit septuaginta sex millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Filii Issachar per cognationes suas: Thola, a quo familia Tholaitarum: Phua, a quo familia Phuaitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jasub, a quo familia Jasubitarum: Semran, a quo familia Semranitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Hæ sunt cognationes Issachar, quarum numerus fuit sexaginta quatuor millia trecenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Filii Zabulon per cognationes suas: Sared, a quo familia Sareditarum: Elon, a quo familia Elonitarum: Jalel, a quo familia Jalelitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Hæ sunt cognationes Zabulon, quarum numerus fuit sexaginta millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Filii Joseph per cognationes suas, Manasse et Ephraim. ");
INSERT INTO latVUC_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","De Manasse ortus est Machir, a quo familia Machiritarum. Machir genuit Galaad, a quo familia Galaaditarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galaad habuit filios: Jezer, a quo familia Jezeritarum: et Helec, a quo familia Helecitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","et Asriel, a quo familia Asrielitarum: et Sechem, a quo familia Sechemitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","et Semida, a quo familia Semidaitarum: et Hepher, a quo familia Hepheritarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Fuit autem Hepher pater Salphaad, qui filios non habebat, sed tantum filias: quarum ista sunt nomina: Maala, et Noa, et Hegla, et Melcha, et Thersa. ");
INSERT INTO latVUC_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Hæ sunt familiæ Manasse, et numerus earum quinquaginta duo millia septingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Filii autem Ephraim per cognationes suas fuerunt hi: Suthala, a quo familia Suthalaitarum: Becher, a quo familia Becheritarum: Thehen, a quo familia Thehenitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Porro filius Suthala fuit Heran, a quo familia Heranitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Hæ sunt cognationes filiorum Ephraim: quarum numerus fuit triginta duo millia quingenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Isti sunt filii Joseph per familias suas. Filii Benjamin in cognationibus suis: Bela, a quo familia Belaitarum: Asbel, a quo familia Asbelitarum: Ahiram, a quo familia Ahiramitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Supham, a quo familia Suphamitarum: Hupham, a quo familia Huphamitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Filii Bela: Hered, et Noëman. De Hered, familia Hereditarum: de Noëman, familia Noëmanitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Hi sunt filii Benjamin per cognationes suas: quorum numerus fuit quadraginta quinque millia sexcenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Filii Dan per cognationes suas: Suham, a quo familia Suhamitarum. Hæ sunt cognationes Dan per familias suas. ");
INSERT INTO latVUC_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Omnes fuere Suhamitæ, quorum numerus erat sexaginta quatuor millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Filii Aser per cognationes suas: Jemna, a quo familia Jemnaitarum: Jessui, a quo familia Jessuitarum: Brie, a quo familia Brieitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Filii Brie: Heber, a quo familia Heberitarum: et Melchiel, a quo familia Melchielitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Nomen autem filiæ Aser fuit Sara. ");
INSERT INTO latVUC_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Hæ cognationes filiorum Aser, et numerus eorum quinquaginta tria millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Filii Nephthali per cognationes suas: Jesiel, a quo familia Jesielitarum: Guni, a quo familia Gunitarum: ");
INSERT INTO latVUC_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jeser, a quo familia Jeseritarum: Sellem, a quo familia Sellemitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Hæ sunt cognationes filiorum Nephthali per familias suas: quorum numerus quadraginta quinque millia quadringenti. ");
INSERT INTO latVUC_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ista est summa filiorum Israël, qui recensiti sunt, sexcenta millia, et mille septingenti triginta. ");
INSERT INTO latVUC_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Istis dividetur terra juxta numerum vocabulorum in possessiones suas. ");
INSERT INTO latVUC_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Pluribus majorem partem dabis, et paucioribus minorem: singulis, sicut nunc recensiti sunt, tradetur possessio: ");
INSERT INTO latVUC_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ita dumtaxat ut sors terram tribubus dividat et familiis. ");
INSERT INTO latVUC_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Quidquid sorte contigerit, hoc vel plures accipiant, vel pauciores. ");
INSERT INTO latVUC_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Hic quoque est numerus filiorum Levi per familias suas: Gerson, a quo familia Gersonitarum: Caath, a quo familia Caathitarum: Merari, a quo familia Meraritarum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Hæ sunt familiæ Levi: familia Lobni, familia Hebroni, familia Moholi, familia Musi, familia Core. At vero Caath genuit Amram: ");
INSERT INTO latVUC_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","qui habuit uxorem Jochabed filiam Levi, quæ nata est ei in Ægypto. Hæc genuit Amram viro suo filios, Aaron, et Moysen, et Mariam sororem eorum. ");
INSERT INTO latVUC_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","De Aaron orti sunt Nadab et Abiu, et Eleazar et Ithamar: ");
INSERT INTO latVUC_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","quorum Nadab et Abiu mortui sunt, cum obtulissent ignem alienum coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Fueruntque omnes qui numerati sunt, viginti tria millia generis masculini ab uno mense et supra: quia non sunt recensiti inter filios Israël, nec eis cum ceteris data possessio est. ");
INSERT INTO latVUC_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Hic est numerus filiorum Israël, qui descripti sunt a Moyse et Eleazaro sacerdote, in campestribus Moab supra Jordanem contra Jericho: ");
INSERT INTO latVUC_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","inter quos, nullus fuit eorum qui ante numerati sunt a Moyse et Aaron in deserto Sinai: ");
INSERT INTO latVUC_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","prædixerat enim Dominus quod omnes morerentur in solitudine. Nullusque remansit ex eis, nisi Caleb filius Jephone, et Josue filius Nun. ");
INSERT INTO latVUC_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Accesserunt autem filiæ Salphaad, filii Hepher, filii Galaad, filii Machir, filii Manasse, qui fuit filius Joseph: quarum sunt nomina, Maala, et Noa, et Hegla, et Melcha, et Thersa. ");
INSERT INTO latVUC_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Steteruntque coram Moyse et Eleazaro sacerdote et cunctis principibus populi ad ostium tabernaculi fœderis, atque dixerunt: ");
INSERT INTO latVUC_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Pater noster mortuus est in deserto, nec fuit in seditione, quæ concitata est contra Dominum sub Core, sed in peccato suo mortuus est: hic non habuit mares filios. Cur tollitur nomen illius de familia sua, quia non habuit filium? date nobis possessionem inter cognatos patris nostri. ");
INSERT INTO latVUC_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Retulitque Moyses causam earum ad judicium Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Qui dixit ad eum: ");
INSERT INTO latVUC_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Justam rem postulant filiæ Salphaad: da eis possessionem inter cognatos patris sui, et ei in hæreditatem succedant. ");
INSERT INTO latVUC_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Ad filios autem Israël loqueris hæc: ");
INSERT INTO latVUC_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Homo cum mortuus fuerit absque filio, ad filiam ejus transibit hæreditas. ");
INSERT INTO latVUC_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Si filiam non habuerit, habebit successores fratres suos. ");
INSERT INTO latVUC_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Quod si et fratres non fuerint, dabitis hæreditatem fratribus patris ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Sin autem nec patruos habuerit, dabitur hæreditas his qui ei proximi sunt. Eritque hoc filiis Israël sanctum lege perpetua, sicut præcepit Dominus Moysi. ");
INSERT INTO latVUC_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Dixit quoque Dominus ad Moysen: Ascende in montem istum Abarim, et contemplare inde terram, quam daturus sum filiis Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Cumque videris eam, ibis et tu ad populum tuum, sicut ivit frater tuus Aaron: ");
INSERT INTO latVUC_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","quia offendistis me in deserto Sin in contradictione multitudinis, nec sanctificare me voluistis coram ea super aquas. Hæ sunt aquæ contradictionis in Cades deserti Sin. ");
INSERT INTO latVUC_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Cui respondit Moyses: ");
INSERT INTO latVUC_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Provideat Dominus Deus spirituum omnis carnis hominem, qui sit super multitudinem hanc: ");
INSERT INTO latVUC_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","et possit exire et intrare ante eos, et educere eos vel introducere: ne sit populus Domini sicut oves absque pastore. ");
INSERT INTO latVUC_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Dixitque Dominus ad eum: Tolle Josue filium Nun, virum in quo est spiritus, et pone manum tuam super eum. ");
INSERT INTO latVUC_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Qui stabit coram Eleazaro sacerdote et omni multitudine: ");
INSERT INTO latVUC_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","et dabis ei præcepta cunctis videntibus, et partem gloriæ tuæ, ut audiat eum omnis synagoga filiorum Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Pro hoc, si quid agendum erit, Eleazar sacerdos consulet Dominum. Ad verbum ejus egredietur et ingredietur ipse, et omnes filii Israël cum eo, et cetera multitudo. ");
INSERT INTO latVUC_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Fecit Moyses ut præceperat Dominus: cumque tulisset Josue, statuit eum coram Eleazaro sacerdote et omni frequentia populi. ");
INSERT INTO latVUC_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Et impositis capiti ejus manibus, cuncta replicavit quæ mandaverat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Dixit quoque Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Præcipe filiis Israël, et dices ad eos: Oblationem meam et panes, et incensum odoris suavissimi offerte per tempora sua. ");
INSERT INTO latVUC_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Hæc sunt sacrificia quæ offerre debetis: agnos anniculos immaculatos duos quotidie in holocaustum sempiternum: ");
INSERT INTO latVUC_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","unum offeretis mane, et alterum ad vesperum: ");
INSERT INTO latVUC_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","decimam partem ephi similæ, quæ conspersa sit oleo purissimo, et habeat quartam partem hin. ");
INSERT INTO latVUC_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Holocaustum juge est quod obtulistis in monte Sinai in odorem suavissimum incensi Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Et libabitis vini quartam partem hin per agnos singulos in sanctuario Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Alterumque agnum similiter offeretis ad vesperam juxta omnem ritum sacrificii matutini, et libamentorum ejus, oblationem suavissimi odoris Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Die autem sabbati offeretis duos agnos anniculos immaculatos, et duas decimas similæ oleo conspersæ in sacrificio, et liba: ");
INSERT INTO latVUC_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","quæ rite funduntur per singula sabbata in holocaustum sempiternum. ");
INSERT INTO latVUC_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","In calendis autem offeretis holocaustum Domino, vitulos de armento duos, arietem unum, agnos anniculos septem immaculatos, ");
INSERT INTO latVUC_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","et tres decimas similæ oleo conspersæ in sacrificio per singulos vitulos: et duas decimas similæ oleo conspersæ per singulos arietes: ");
INSERT INTO latVUC_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","et decimam decimæ similæ ex oleo in sacrificio per agnos singulos: holocaustum suavissimi odoris atque incensi est Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Libamenta autem vini, quæ per singulas fundenda sunt victimas, ista erunt: media pars hin per singulos vitulos, tertia per arietem, quarta per agnum. Hoc erit holocaustum per omnes menses, qui sibi anno vertente succedunt. ");
INSERT INTO latVUC_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Hircus quoque offeretur Domino pro peccatis in holocaustum sempiternum cum libamentis suis. ");
INSERT INTO latVUC_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Mense autem primo, quartadecima die mensis, Phase Domini erit, ");
INSERT INTO latVUC_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","et quintadecima die solemnitas: septem diebus vescentur azymis. ");
INSERT INTO latVUC_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Quarum dies prima venerabilis et sancta erit: omne opus servile non facietis in ea. ");
INSERT INTO latVUC_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Offeretisque incensum holocaustum Domino, vitulos de armento duos, arietem unum, agnos anniculos immaculatos septem: ");
INSERT INTO latVUC_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","et sacrificia singulorum ex simila quæ conspersa sit oleo, tres decimas per singulos vitulos, et duas decimas per arietem, ");
INSERT INTO latVUC_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","et decimam decimæ per agnos singulos, id est, per septem agnos. ");
INSERT INTO latVUC_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Et hircum pro peccato unum, ut expietur pro vobis, ");
INSERT INTO latVUC_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","præter holocaustum matutinum, quod semper offeretis. ");
INSERT INTO latVUC_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ita facietis per singulos dies septem dierum in fomitem ignis, et in odorem suavissimum Domino, qui surget de holocausto, et de libationibus singulorum. ");
INSERT INTO latVUC_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Dies quoque septimus celeberrimus et sanctus erit vobis: omne opus servile non facietis in eo. ");
INSERT INTO latVUC_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Dies etiam primitivorum, quando offeretis novas fruges Domino, expletis hebdomadibus, venerabilis et sancta erit: omne opus servile non facietis in ea. ");
INSERT INTO latVUC_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Offeretisque holocaustum in odorem suavissimum Domino, vitulos de armento duos, arietem unum, et agnos anniculos immaculatos septem: ");
INSERT INTO latVUC_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","atque in sacrificiis eorum, similæ oleo conspersæ tres decimas per singulos vitulos, per arietes duas, ");
INSERT INTO latVUC_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","per agnos decimam decimæ, qui simul sunt agni septem. Hircum quoque, ");
INSERT INTO latVUC_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","qui mactatur pro expiatione: præter holocaustum sempiternum et liba ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Immaculata offeretis omnia cum libationibus suis. ");
INSERT INTO latVUC_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Mensis etiam septimi prima dies venerabilis et sancta erit vobis. Omne opus servile non facietis in ea, quia dies clangoris est et tubarum. ");
INSERT INTO latVUC_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Offeretisque holocaustum in odorem suavissimum Domino, vitulum de armento unum, arietem unum, et agnos anniculos immaculatos septem: ");
INSERT INTO latVUC_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","et in sacrificiis eorum, similæ oleo conspersæ tres decimas per singulos vitulos, duas decimas per arietem, ");
INSERT INTO latVUC_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","unam decimam per agnum, qui simul sunt agni septem: ");
INSERT INTO latVUC_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","et hircum pro peccato, qui offertur in expiationem populi, ");
INSERT INTO latVUC_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","præter holocaustum calendarum cum sacrificiis suis, et holocaustum sempiternum cum libationibus solitis: eisdem cæremoniis offeretis in odorem suavissimum incensum Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Decima quoque dies mensis hujus septimi erit vobis sancta atque venerabilis, et affligetis animas vestras: omne opus servile non facietis in ea. ");
INSERT INTO latVUC_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Offeretisque holocaustum Domino in odorem suavissimum, vitulum de armento unum, arietem unum, agnos anniculos immaculatos septem: ");
INSERT INTO latVUC_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","et in sacrificiis eorum similæ oleo conspersæ tres decimas per singulos vitulos, duas decimas per arietem, ");
INSERT INTO latVUC_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","decimam decimæ per agnos singulos, qui sunt simul agni septem: ");
INSERT INTO latVUC_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","et hircum pro peccato, absque his quæ offerri pro delicto solent in expiationem, et holocaustum sempiternum, cum sacrificio et libaminibus eorum. ");
INSERT INTO latVUC_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Quintadecima vero die mensis septimi, quæ vobis sancta erit atque venerabilis, omne opus servile non facietis in ea, sed celebrabitis solemnitatem Domino septem diebus. ");
INSERT INTO latVUC_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Offeretisque holocaustum in odorem suavissimum Domino, vitulos de armento tredecim, arietes duos, agnos anniculos immaculatos quatuordecim: ");
INSERT INTO latVUC_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","et in libamentis eorum, similæ oleo conspersæ tres decimas per vitulos singulos, qui sunt simul vituli tredecim, et duas decimas arieti uno, id est, simul arietibus duobus, ");
INSERT INTO latVUC_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","et decimam decimæ agnis singulis, qui sunt simul agni quatuordecim: ");
INSERT INTO latVUC_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","et hircum pro peccato, absque holocausto sempiterno, et sacrificio, et libamine ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","In die altero offeretis vitulos de armento duodecim, arietes duos, agnos anniculos immaculatos quatuordecim: ");
INSERT INTO latVUC_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","sacrificiaque et libamina singulorum, per vitulos, et arietes, et agnos rite celebrabitis: ");
INSERT INTO latVUC_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","et hircum pro peccato, absque holocausto sempiterno, sacrificioque et libamine ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Die tertio offeretis vitulos undecim, arietes duos, agnos anniculos immaculatos quatuordecim: ");
INSERT INTO latVUC_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","sacrificiaque et libamina singulorum, per vitulos, et arietes, et agnos rite celebrabitis: ");
INSERT INTO latVUC_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","et hircum pro peccato, absque holocausto sempiterno, sacrificioque et libamine ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Die quarto offeretis vitulos decem, arietes duos, agnos anniculos immaculatos quatuordecim: ");
INSERT INTO latVUC_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","sacrificiaque et libamina singulorum, per vitulos, et arietes, et agnos rite celebrabitis: ");
INSERT INTO latVUC_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","et hircum pro peccato, absque holocausto sempiterno, sacrificioque ejus et libamine. ");
INSERT INTO latVUC_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Die quinto offeretis vitulos novem, arietes duos, agnos anniculos immaculatos quatuordecim: ");
INSERT INTO latVUC_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","sacrificiaque et libamina singulorum, per vitulos, et arietes, et agnos rite celebrabitis: ");
INSERT INTO latVUC_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","et hircum pro peccato, absque holocausto sempiterno, sacrificioque ejus et libamine. ");
INSERT INTO latVUC_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Die sexto offeretis vitulos octo, arietes duos, agnos anniculos immaculatos quatuordecim: ");
INSERT INTO latVUC_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","sacrificiaque et libamina singulorum, per vitulos, et arietes, et agnos rite celebrabitis: ");
INSERT INTO latVUC_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","et hircum pro peccato, absque holocausto sempiterno, sacrificioque ejus et libamine. ");
INSERT INTO latVUC_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Die septimo offeretis vitulos septem, et arietes duos, agnos anniculos immaculatos quatuordecim: ");
INSERT INTO latVUC_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","sacrificiaque et libamina singulorum, per vitulos, et arietes, et agnos rite celebrabitis: ");
INSERT INTO latVUC_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","et hircum pro peccato, absque holocausto sempiterno, sacrificioque ejus et libamine. ");
INSERT INTO latVUC_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Die octavo, qui est celeberrimus, omne opus servile non facietis, ");
INSERT INTO latVUC_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","offerentes holocaustum in odorem suavissimum Domino, vitulum unum, arietem unum, agnos anniculos immaculatos septem: ");
INSERT INTO latVUC_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","sacrificiaque et libamina singulorum, per vitulos, et arietes, et agnos rite celebrabitis: ");
INSERT INTO latVUC_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","et hircum pro peccato, absque holocausto sempiterno, sacrificioque ejus et libamine. ");
INSERT INTO latVUC_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Hæc offeretis Domino in solemnitatibus vestris: præter vota et oblationes spontaneas in holocausto, in sacrificio, in libamine, et in hostiis pacificis. ");
INSERT INTO latVUC_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Narravitque Moyses filiis Israël omnia quæ ei Dominus imperarat. ");
INSERT INTO latVUC_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Et locutus est ad principes tribuum filiorum Israël: Iste est sermo quem præcepit Dominus: ");
INSERT INTO latVUC_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Si quis virorum votum Domino voverit, aut se constrinxerit juramento: non faciet irritum verbum suum, sed omne quod promisit, implebit. ");
INSERT INTO latVUC_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Mulier si quippiam voverit, et se constrinxerit juramento, quæ est in domo patris sui, et in ætate adhuc puellari: si cognoverit pater votum quod pollicita est, et juramentum quo obligavit animam suam, et tacuerit, voti rea erit: ");
INSERT INTO latVUC_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","quidquid pollicita est, et juravit, opere complebit. ");
INSERT INTO latVUC_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Sin autem statim ut audierit, contradixerit pater: et vota et juramenta ejus irrita erunt, nec obnoxia tenebitur sponsioni, eo quod contradixerit pater. ");
INSERT INTO latVUC_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Si maritum habuerit, et voverit aliquid, et semel de ore ejus verbum egrediens animam ejus obligaverit juramento: ");
INSERT INTO latVUC_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","quo die audierit vir, et non contradixerit, voti rea erit, reddetque quodcumque promiserat. ");
INSERT INTO latVUC_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Sin autem audiens statim contradixerit, et irritas fecerit pollicitationes ejus, verbaque quibus obstrinxerat animam suam, propitius erit ei Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Vidua et repudiata quidquid voverint, reddent. ");
INSERT INTO latVUC_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Uxor in domo viri cum se voto constrinxerit et juramento, ");
INSERT INTO latVUC_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","si audierit vir, et tacuerit, nec contradixerit sponsioni, reddet quodcumque promiserat. ");
INSERT INTO latVUC_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Sin autem extemplo contradixerit, non tenebitur promissionis rea: quia maritus contradixit, et Dominus ei propitius erit. ");
INSERT INTO latVUC_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Si voverit, et juramento se constrinxerit, ut per jejunium, vel ceterarum rerum abstinentiam affligat animam suam, in arbitrio viri erit ut faciat, sive non faciat. ");
INSERT INTO latVUC_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Quod si audiens vir tacuerit, et in alteram diem distulerit sententiam, quidquid voverat atque promiserat, reddet: quia statim ut audivit, tacuit. ");
INSERT INTO latVUC_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Sin autem contradixerit postquam rescivit, portabit ipse iniquitatem ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Istæ sunt leges, quas constituit Dominus Moysi inter virum et uxorem, inter patrem et filiam, quæ in puellari adhuc ætate est, vel quæ manet in parentis domo. ");
INSERT INTO latVUC_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Ulciscere prius filios Israël de Madianitis, et sic colligeris ad populum tuum. ");
INSERT INTO latVUC_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Statimque Moyses: Armate, inquit, ex vobis viros ad pugnam, qui possint ultionem Domini expetere de Madianitis. ");
INSERT INTO latVUC_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mille viri de singulis tribubus eligantur ex Israël qui mittantur ad bellum. ");
INSERT INTO latVUC_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Dederuntque millenos de singulis tribubus, id est, duodecim millia expeditorum ad pugnam: ");
INSERT INTO latVUC_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","quos misit Moyses cum Phinees filio Eleazari sacerdotis, vasa quoque sancta, et tubas ad clangendum tradidit ei. ");
INSERT INTO latVUC_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Cumque pugnassent contra Madianitas atque vicissent, omnes mares occiderunt, ");
INSERT INTO latVUC_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","et reges eorum, Evi, et Recem, et Sur, et Hur, et Rebe, quinque principes gentis: Balaam quoque filium Beor interfecerunt gladio. ");
INSERT INTO latVUC_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Ceperuntque mulieres eorum, et parvulos, omniaque pecora, et cunctam supellectilem: quidquid habere potuerant depopulati sunt: ");
INSERT INTO latVUC_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","tam urbes quam viculos et castella flamma consumpsit. ");
INSERT INTO latVUC_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Et tulerunt prædam, et universa quæ ceperant tam ex hominibus quam ex jumentis, ");
INSERT INTO latVUC_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","et adduxerunt ad Moysen, et Eleazarum sacerdotem, et ad omnem multitudinem filiorum Israël: reliqua autem utensilia portaverunt ad castra in campestribus Moab juxta Jordanem contra Jericho. ");
INSERT INTO latVUC_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Egressi sunt autem Moyses et Eleazar sacerdos, et omnes principes synagogæ, in occursum eorum extra castra. ");
INSERT INTO latVUC_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Iratusque Moyses principibus exercitus, tribunis, et centurionibus qui venerant de bello, ");
INSERT INTO latVUC_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ait: Cur feminas reservastis? ");
INSERT INTO latVUC_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","nonne istæ sunt, quæ deceperunt filios Israël ad suggestionem Balaam, et prævaricari vos fecerunt in Domino super peccato Phogor, unde et percussus est populus? ");
INSERT INTO latVUC_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ergo cunctos interficite quidquid est generis masculinis, etiam in parvulis: et mulieres, quæ noverunt viros in coitu, jugulate: ");
INSERT INTO latVUC_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","puellas autem et omnes feminas virgines reservate vobis: ");
INSERT INTO latVUC_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","et manete extra castra septem diebus. Qui occiderit hominem, vel occisum tetigerit, lustrabitur die tertio et septimo. ");
INSERT INTO latVUC_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Et de omni præda, sive vestimentum fuerit, sive vas, et aliquid in utensilia præparatum, de caprarum pellibus, et pilis, et ligno, expiabitur. ");
INSERT INTO latVUC_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleazar quoque sacerdos ad viros exercitus, qui pugnaverunt, sic locutus est: Hoc est præceptum legis, quod mandavit Dominus Moysi: ");
INSERT INTO latVUC_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","aurum, et argentum, et æs, et ferrum, et plumbum, et stannum, ");
INSERT INTO latVUC_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","et omne, quod potest transire per flammas, igne purgabitur: quidquid autem ignem non potest sustinere, aqua expiationis sanctificabitur: ");
INSERT INTO latVUC_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","et lavabitis vestimenta vestra die septimo, et purificati postea castra intrabitis. ");
INSERT INTO latVUC_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Dixit quoque Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Tollite summam eorum quæ capta sunt, ab homine usque ad pecus, tu et Eleazar sacerdos et principes vulgi: ");
INSERT INTO latVUC_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","dividesque ex æquo prædam inter eos qui pugnaverunt egressique sunt ad bellum, et inter omnem reliquam multitudinem. ");
INSERT INTO latVUC_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Et separabis partem Domino ab his qui pugnaverunt et fuerunt in bello, unam animam de quingentis, tam ex hominibus quam ex bobus et asinis et ovibus, ");
INSERT INTO latVUC_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","et dabis eam Eleazaro sacerdoti, quia primitiæ Domini sunt. ");
INSERT INTO latVUC_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ex media quoque parte filiorum Israël accipies quinquagesimum caput hominum, et boum, et asinorum, et ovium, cunctorum animantium, et dabis ea Levitis, qui excubant in custodiis tabernaculi Domini. ");
INSERT INTO latVUC_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Feceruntque Moyses et Eleazar sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Fuit autem præda, quam exercitus ceperat, ovium sexcenta septuaginta quinque millia, ");
INSERT INTO latVUC_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","boum septuaginta duo millia, ");
INSERT INTO latVUC_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","asinorum sexaginta millia et mille: ");
INSERT INTO latVUC_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","animæ hominum sexus feminei, quæ non cognoverant viros, triginta duo millia. ");
INSERT INTO latVUC_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Dataque est media pars his qui in prælio fuerant, ovium trecenta triginta septem millia quingentæ: ");
INSERT INTO latVUC_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","e quibus in partem Domini supputatæ sunt oves sexcentæ septuaginta quinque: ");
INSERT INTO latVUC_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","et de bobus triginta sex millibus, boves septuaginta et duo: ");
INSERT INTO latVUC_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","de asinis triginta millibus quingentis, asini sexaginta unus: ");
INSERT INTO latVUC_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","de animabus hominum sedecim millibus, cesserunt in partem Domini triginta duæ animæ. ");
INSERT INTO latVUC_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Tradiditque Moyses numerum primitiarum Domini Eleazaro sacerdoti, sicut fuerat ei imperatum, ");
INSERT INTO latVUC_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ex media parte filiorum Israël, quam separaverat his qui in prælio fuerant. ");
INSERT INTO latVUC_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","De media vero parte, quæ contigerat reliquæ multitudini, id est, de ovibus trecentis triginta septem millibus quingentis, ");
INSERT INTO latVUC_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","et de bobus triginta sex millibus, ");
INSERT INTO latVUC_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","et de asinis triginta millibus quingentis, ");
INSERT INTO latVUC_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","et de hominibus sedecim millibus, ");
INSERT INTO latVUC_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","tulit Moyses quinquagesimum caput, et dedit Levitis, qui excubabant in tabernaculo Domini, sicut præceperat Dominus. ");
INSERT INTO latVUC_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Cumque accessissent principes exercitus ad Moysen, et tribuni, centurionesque, dixerunt: ");
INSERT INTO latVUC_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Nos servi tui recensuimus numerum pugnatorum, quos habuimus sub manu nostra: et ne unus quidem defuit. ");
INSERT INTO latVUC_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ob hanc causam offerimus in donariis Domini singuli quod in præda auri potuimus invenire, periscelides et armillas, annulos et dextralia, ac murænulas, ut depreceris pro nobis Dominum. ");
INSERT INTO latVUC_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Susceperuntque Moyses et Eleazar sacerdos omne aurum in diversis speciebus, ");
INSERT INTO latVUC_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","pondo sedecim millia septingentos quinquaginta siclos, a tribunis et centurionibus. ");
INSERT INTO latVUC_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Unusquisque enim quod in præda rapuerat, suum erat. ");
INSERT INTO latVUC_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Et susceptum intulerunt in tabernaculum testimonii, in monimentum filiorum Israël coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Filii autem Ruben et Gad habebant pecora multa, et erat illis in jumentis infinita substantia. Cumque vidissent Jazer et Galaad aptas animalibus alendis terras, ");
INSERT INTO latVUC_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","venerunt ad Moysen, et ad Elezarum sacerdotem, et principes multitudinis, atque dixerunt: ");
INSERT INTO latVUC_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Ataroth, et Dibon, et Jazer, et Nemra, Hesebon, et Eleale, et Saban, et Nebo, et Beon, ");
INSERT INTO latVUC_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","terra, quam percussit Dominus in conspectu filiorum Israël, regio uberrima est ad pastum animalium: et nos servi tui habemus jumenta plurima, ");
INSERT INTO latVUC_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","precamurque si invenimus gratiam coram te, ut des nobis famulis tuis eam in possessionem, nec facias nos transire Jordanem. ");
INSERT INTO latVUC_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Quibus respondit Moyses: Numquid fratres vestri ibunt ad pugnam, et vos hic sedebitis? ");
INSERT INTO latVUC_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","cur subvertitis mentes filiorum Israël, ne transire audeant in locum, quem eis daturus est Dominus? ");
INSERT INTO latVUC_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Nonne ita egerunt patres vestri, quando misi de Cadesbarne ad explorandam terram? ");
INSERT INTO latVUC_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","cumque venissent usque ad Vallem botri, lustrata omni regione, subverterunt cor filiorum Israël, ut non intrarent fines, quos eis Dominus dedit. ");
INSERT INTO latVUC_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Qui iratus juravit, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Si videbunt homines isti, qui ascenderunt ex Ægypto a viginti annis et supra, terram, quam sub juramento pollicitus sum Abraham, Isaac, et Jacob: et noluerunt sequi me, ");
INSERT INTO latVUC_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","præter Caleb filium Jephone Cenezæum, et Josue filium Nun: isti impleverunt voluntatem meam. ");
INSERT INTO latVUC_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Iratusque Dominus adversum Israël, circumduxit eum per desertum quadraginta annis, donec consumeretur universa generatio, quæ fecerat malum in conspectu ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Et ecce, inquit, vos surrexistis pro patribus vestris, incrementa et alumni hominum peccatorum, ut augeretis furorem Domini contra Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Quod si nolueritis sequi eum, in solitudine populum derelinquet, et vos causa eritis necis omnium. ");
INSERT INTO latVUC_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","At illi prope accedentes, dixerunt: Caulas ovium fabricabimus, et stabula jumentorum, parvulis quoque nostris urbes munitas: ");
INSERT INTO latVUC_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","nos autem ipsi armati et accincti pergemus ad prælium ante filios Israël, donec introducamus eos ad loca sua. Parvuli nostri, et quidquid habere possumus, erunt in urbibus muratis, propter habitatorum insidias. ");
INSERT INTO latVUC_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Non revertemur in domos nostras, usque dum possideant filii Israël hæreditatem suam: ");
INSERT INTO latVUC_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","nec quidquam quæremus trans Jordanem, quia jam habemus nostram possessionem in orientali ejus plaga. ");
INSERT INTO latVUC_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Quibus Moyses ait: Si facitis quod promittitis, expediti pergite coram Domino ad pugnam: ");
INSERT INTO latVUC_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","et omnis vir bellator armatus Jordanem transeat, donec subvertat Dominus inimicos suos, ");
INSERT INTO latVUC_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","et subjiciatur ei omnis terra: tunc eritis inculpabiles apud Dominum et apud Israël, et obtinebitis regiones, quas vultis, coram Domino. ");
INSERT INTO latVUC_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Sin autem quod dicitis, non feceritis, nulli dubium est quin peccetis in Deum: et scitote quoniam peccatum vestrum apprehendet vos. ");
INSERT INTO latVUC_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Ædificate ergo urbes parvulis vestris, et caulas, et stabula ovibus ac jumentis: et quod polliciti estis, implete. ");
INSERT INTO latVUC_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Dixeruntque filii Gad et Ruben ad Moysen: Servi tui sumus: faciemus quod jubet dominus noster. ");
INSERT INTO latVUC_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Parvulos nostros, et mulieres, et pecora, ac jumenta relinquemus in urbibus Galaad: ");
INSERT INTO latVUC_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","nos autem famuli tui omnes expediti pergemus ad bellum, sicut tu, domine, loqueris. ");
INSERT INTO latVUC_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Præcepit ergo Moyses Eleazaro sacerdoti, et Josue filio Nun, et principibus familiarum per tribus Israël, et dixit ad eos: ");
INSERT INTO latVUC_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Si transierint filii Gad et filii Ruben vobiscum Jordanem omnes armati ad bellum coram Domino, et vobis fuerit terra subjecta, date eis Galaad in possessionem. ");
INSERT INTO latVUC_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Sin autem noluerint transire armati vobiscum in terram Chanaan, inter vos habitandi accipiant loca. ");
INSERT INTO latVUC_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Responderuntque filii Gad et filii Ruben: Sicut locutus est Dominus servis suis, ita faciemus: ");
INSERT INTO latVUC_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ipsi armati pergemus coram Domino in terram Chanaan, et possessionem jam suscepisse nos confitemur trans Jordanem. ");
INSERT INTO latVUC_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Dedit itaque Moyses filiis Gad et Ruben, et dimidiæ tribui Manasse filii Joseph, regnum Sehon regis Amorrhæi, et regnum Og regis Basan, et terram eorum cum urbibus suis per circuitum. ");
INSERT INTO latVUC_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Igitur exstruxerunt filii Gad, Dibon, et Ataroth, et Aroër, ");
INSERT INTO latVUC_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","et Etroth, et Sophan, et Jazer, et Jegbaa, ");
INSERT INTO latVUC_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","et Bethnemra, et Betharan, urbes munitas, et caulas pecoribus suis. ");
INSERT INTO latVUC_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Filii vero Ruben ædificaverunt Hesebon, et Eleale, et Cariathaim, ");
INSERT INTO latVUC_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","et Nabo, et Baalmeon versis nominibus, Sabama quoque: imponentes vocabula urbibus, quas exstruxerunt. ");
INSERT INTO latVUC_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Porro filii Machir filii Manasse, perrexerunt in Galaad, et vastaverunt eam interfecto Amorrhæo habitatore ejus. ");
INSERT INTO latVUC_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Dedit ergo Moyses terram Galaad Machir filio Manasse, qui habitavit in ea. ");
INSERT INTO latVUC_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair autem filius Manasse abiit, et occupavit vicos ejus, quos appellavit Havoth Jair, id est, Villas Jair. ");
INSERT INTO latVUC_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobe quoque perrexit, et apprehendit Chanath cum viculis suis: vocavitque eam ex nomine suo Nobe. ");
INSERT INTO latVUC_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Hæ sunt mansiones filiorum Israël, qui egressi sunt de Ægypto per turmas suas in manu Moysi et Aaron, ");
INSERT INTO latVUC_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","quas descripsit Moyses juxta castrorum loca, quæ Domini jussione mutabant. ");
INSERT INTO latVUC_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Profecti igitur de Ramesse mense primo, quintadecima die mensis primi, altera die Phase, filii Israël in manu excelsa, videntibus cunctis Ægyptiis, ");
INSERT INTO latVUC_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","et sepelientibus primogenitos, quos percusserat Dominus (nam et in diis eorum exercuerat ultionem), ");
INSERT INTO latVUC_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","castrametati sunt in Soccoth. ");
INSERT INTO latVUC_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Et de Soccoth venerunt in Etham, quæ est in extremis finibus solitudinis. ");
INSERT INTO latVUC_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Inde egressi venerunt contra Phihahiroth, quæ respicit Beelsephon, et castrametati sunt ante Magdalum. ");
INSERT INTO latVUC_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Profectique de Phihahiroth, transierunt per medium mare in solitudinem: et ambulantes tribus diebus per desertum Etham, castrametati sunt in Mara. ");
INSERT INTO latVUC_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Profectique de Mara, venerunt in Elim, ubi erant duodecim fontes aquarum, et palmæ septuaginta: ibique castrametati sunt. ");
INSERT INTO latVUC_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Sed et inde egressi, fixerunt tentoria super mare Rubrum. Profectique de mari Rubro, ");
INSERT INTO latVUC_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","castrametati sunt in deserto Sin. ");
INSERT INTO latVUC_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Unde egressi, venerunt in Daphca. ");
INSERT INTO latVUC_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Profectique de Daphca, castrametati sunt in Alus. ");
INSERT INTO latVUC_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Egressique de Alus, in Raphidim fixere tentoria, ubi populo defuit aqua ad bibendum. ");
INSERT INTO latVUC_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Profectique de Raphidim, castrametati sunt in deserto Sinai. ");
INSERT INTO latVUC_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Sed et de solitudine Sinai egressi, venerunt ad sepulchra concupiscentiæ. ");
INSERT INTO latVUC_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Profectique de sepulchris concupiscentiæ, castrametati sunt in Haseroth. ");
INSERT INTO latVUC_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Et de Haseroth venerunt in Rethma. ");
INSERT INTO latVUC_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Profectique de Rethma, castrametati sunt in Remmomphares. ");
INSERT INTO latVUC_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Unde egressi venerunt in Lebna. ");
INSERT INTO latVUC_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","De Lebna castrametati sunt in Ressa. ");
INSERT INTO latVUC_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Egressique de Ressa, venerunt in Ceelatha. ");
INSERT INTO latVUC_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Unde profecti, castrametati sunt in monte Sepher. ");
INSERT INTO latVUC_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Egressi de monte Sepher, venerunt in Arada. ");
INSERT INTO latVUC_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Inde proficiscentes, castrametati sunt in Maceloth. ");
INSERT INTO latVUC_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Profectique de Maceloth, venerunt in Thahath. ");
INSERT INTO latVUC_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","De Thahath, castrametati sunt in Thare. ");
INSERT INTO latVUC_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Unde egressi, fixere tentoria in Methca. ");
INSERT INTO latVUC_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Et de Methca, castrametati sunt in Hesmona. ");
INSERT INTO latVUC_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Profectique de Hesmona, venerunt in Moseroth. ");
INSERT INTO latVUC_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Et de Moseroth, castrametati sunt in Benejaacan. ");
INSERT INTO latVUC_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Profectique de Benejaacan, venerunt in montem Gadgad. ");
INSERT INTO latVUC_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Unde profecti, castrametati sunt in Jetebatha. ");
INSERT INTO latVUC_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Et de Jetebatha venerunt in Hebrona. ");
INSERT INTO latVUC_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Egressique de Hebrona, castrametati sunt in Asiongaber. ");
INSERT INTO latVUC_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Inde profecti, venerunt in desertum Sin, hæc est Cades. ");
INSERT INTO latVUC_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Egressique de Cades, castrametati sunt in monte Hor, in extremis finibus terræ Edom. ");
INSERT INTO latVUC_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Ascenditque Aaron sacerdos in montem Hor jubente Domino: et ibi mortuus est anno quadragesimo egressionis filiorum Israël ex Ægypto, mense quinto, prima die mensis, ");
INSERT INTO latVUC_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","cum esset annorum centum viginti trium. ");
INSERT INTO latVUC_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Audivitque Chananæus rex Arad, qui habitabat ad meridiem, in terram Chanaan venisse filios Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Et profecti de monte Hor, castrametati sunt in Salmona. ");
INSERT INTO latVUC_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Unde egressi, venerunt in Phunon. ");
INSERT INTO latVUC_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Profectique de Phunon, castrametati sunt in Oboth. ");
INSERT INTO latVUC_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Et de Oboth venerunt in Ijeabarim, quæ est in finibus Moabitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Profectique de Ijeabarim, fixere tentoria in Dibongad. ");
INSERT INTO latVUC_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Unde egressi, castrametati sunt in Helmondeblathaim. ");
INSERT INTO latVUC_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Egressique de Helmondeblathaim, venerunt ad montes Abarim contra Nabo. ");
INSERT INTO latVUC_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Profectique de montibus Abarim, transierunt ad campestria Moab, supra Jordanem, contra Jericho. ");
INSERT INTO latVUC_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Ibique castrametati sunt de Bethsimoth usque ad Abelsatim in planioribus locis Moabitarum. ");
INSERT INTO latVUC_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Ubi locutus est Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Præcipe filiis Israël, et dic ad eos: Quando transieritis Jordanem, intrantes terram Chanaan, ");
INSERT INTO latVUC_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","disperdite cunctos habitatores terræ illius: confringite titulos, et statuas comminuite, atque omnia excelsa vastate, ");
INSERT INTO latVUC_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","mundantes terram, et habitantes in ea. Ego enim dedi vobis illam in possessionem, ");
INSERT INTO latVUC_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","quam dividetis vobis sorte. Pluribus dabitis latiorem, et paucis angustiorem. Singulis ut sors ceciderit, ita tribuetur hæreditas. Per tribus et familias possessio dividetur. ");
INSERT INTO latVUC_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Sin autem nolueritis interficere habitatores terræ: qui remanserint, erunt vobis quasi clavi in oculis, et lanceæ in lateribus, et adversabuntur vobis in terra habitationis vestræ: ");
INSERT INTO latVUC_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","et quidquid illis cogitaveram facere, vobis faciam. ");
INSERT INTO latVUC_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Locutusque est Dominus ad Moysen, dicens: ");
INSERT INTO latVUC_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Præcipe filiis Israël, et dices ad eos: Cum ingressi fueritis terram Chanaan, et in possessionem vobis sorte ceciderit, his finibus terminabitur. ");
INSERT INTO latVUC_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Pars meridiana incipiet a solitudine Sin, quæ est juxta Edom: et habebit terminos contra orientem mare salsissimum. ");
INSERT INTO latVUC_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Qui circuibunt australem plagam per ascensum Scorpionis, ita ut transeant in Senna, et perveniant a meridie usque ad Cadesbarne, unde egredientur confinia ad villam nomine Adar, et tendent usque ad Asemona. ");
INSERT INTO latVUC_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Ibitque per gyrum terminus ab Asemona usque ad torrentem Ægypti, et maris magni littore finietur. ");
INSERT INTO latVUC_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Plaga autem occidentalis a mari magno incipiet, et ipso fine claudetur. ");
INSERT INTO latVUC_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Porro ad septentrionalem plagam a mari magno termini incipient, pervenientes usque ad montem altissimum, ");
INSERT INTO latVUC_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","a quo venient in Emath usque ad terminos Sedada: ");
INSERT INTO latVUC_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ibuntque confinia usque ad Zephrona, et villam Enan. Hi erunt termini in parte aquilonis. ");
INSERT INTO latVUC_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Inde metabuntur fines contra orientalem plagam de villa Enan usque Sephama, ");
INSERT INTO latVUC_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","et de Sephama descendent termini in Rebla contra fontem Daphnim: inde pervenient contra orientem ad mare Cenereth, ");
INSERT INTO latVUC_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","et tendent usque ad Jordanem, et ad ultimum salsissimo claudentur mari. Hanc habebitis terram per fines suos in circuitu. ");
INSERT INTO latVUC_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Præcepitque Moyses filiis Israël, dicens: Hæc erit terra, quam possidebitis sorte, et quam jussit Dominus dari novem tribubus, et dimidiæ tribui. ");
INSERT INTO latVUC_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Tribus enim filiorum Ruben per familias suas, et tribus filiorum Gad juxta cognationum numerum, media quoque tribus Manasse, ");
INSERT INTO latVUC_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","id est, duæ semis tribus, acceperunt partem suam trans Jordanem contra Jericho ad orientalem plagam. ");
INSERT INTO latVUC_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Et ait Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Hæc sunt nomina virorum qui terram vobis divident, Eleazar sacerdos, et Josue filius Nun, ");
INSERT INTO latVUC_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","et singuli principes de tribubus singulis, ");
INSERT INTO latVUC_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","quorum ista sunt vocabula. De tribu Juda, Caleb filius Jephone. ");
INSERT INTO latVUC_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","De tribu Simeon, Samuel filius Ammiud. ");
INSERT INTO latVUC_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","De tribu Benjamin, Elidad filius Chaselon. ");
INSERT INTO latVUC_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","De tribu filiorum Dan, Bocci filius Jogli. ");
INSERT INTO latVUC_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Filiorum Joseph de tribu Manasse, Hanniel filius Ephod. ");
INSERT INTO latVUC_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","De tribu Ephraim, Camuel filius Sephthan. ");
INSERT INTO latVUC_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","De tribu Zabulon, Elisaphan filius Pharnach. ");
INSERT INTO latVUC_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","De tribu Issachar, dux Phaltiel filius Ozan. ");
INSERT INTO latVUC_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","De tribu Aser, Ahiud filius Salomi. ");
INSERT INTO latVUC_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","De tribu Nephthali, Phedaël filius Ammiud. ");
INSERT INTO latVUC_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Hi sunt, quibus præcepit Dominus ut dividerent filiis Israël terram Chanaan. ");
INSERT INTO latVUC_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Hæc quoque locutus est Dominus ad Moysen in campes tribus Moab supra Jordanem, contra Jericho: ");
INSERT INTO latVUC_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Præcipe filiis Israël ut dent Levitis de possessionibus suis ");
INSERT INTO latVUC_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","urbes ad habitandum, et suburbana earum per circuitum: ut ipsi in oppidis maneant, et suburbana sint pecoribus ac jumentis: ");
INSERT INTO latVUC_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","quæ a muris civitatum forinsecus, per circuitum, mille passuum spatio tendentur. ");
INSERT INTO latVUC_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Contra orientem duo millia erunt cubiti, et contra meridiem similiter erunt duo millia: ad mare quoque, quod respicit ad occidentem, eadem mensura erit, et septentrionalis plaga æquali termino finietur, eruntque urbes in medio, et foris suburbana. ");
INSERT INTO latVUC_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","De ipsis autem oppidis, quæ Levitis dabitis, sex erunt in fugitivorum auxilia separata, ut fugiat ad ea qui fuderit sanguinem: et exceptis his, alia quadraginta duo oppida, ");
INSERT INTO latVUC_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","id est, simul quadraginta octo cum suburbanis suis. ");
INSERT INTO latVUC_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Ipsæque urbes, quæ dabuntur de possessionibus filiorum Israël, ab his qui plus habent, plures auferentur: et qui minus, pauciores: singuli juxta mensuram hæreditatis suæ dabunt oppida Levitis. ");
INSERT INTO latVUC_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Ait Dominus ad Moysen: ");
INSERT INTO latVUC_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Loquere filiis Israël, et dices ad eos: Quando transgressi fueritis Jordanem in terram Chanaan, ");
INSERT INTO latVUC_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","decernite quæ urbes esse debeant in præsidia fugitivorum, qui nolentes sanguinem fuderint: ");
INSERT INTO latVUC_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","in quibus cum fuerit profugus, cognatus occisi non poterit eum occidere, donec stet in conspectu multitudinis, et causa illius judicetur. ");
INSERT INTO latVUC_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","De ipsis autem urbibus, quæ ad fugitivorum subsidia separantur, ");
INSERT INTO latVUC_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","tres erunt trans Jordanem, et tres in terra Chanaan, ");
INSERT INTO latVUC_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","tam filiis Israël quam advenis atque peregrinis, ut confugiat ad eas qui nolens sanguinem fuderit. ");
INSERT INTO latVUC_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Si quis ferro percusserit, et mortuus fuerit qui percussus est, reus erit homicidii, et ipse morietur. ");
INSERT INTO latVUC_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Si lapidem jecerit, et ictus occubuerit, similiter punietur. ");
INSERT INTO latVUC_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Si ligno percussus interierit, percussoris sanguine vindicabitur. ");
INSERT INTO latVUC_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Propinquus occisi, homicidam interficiet: statim ut apprehenderit eum, interficiet. ");
INSERT INTO latVUC_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Si per odium quis hominem impulerit, vel jecerit quippiam in eum per insidias: ");
INSERT INTO latVUC_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","aut cum esset inimicus, manu percusserit, et ille mortuus fuerit: percussor homicidii reus erit: cognatus occisi statim ut invenerit eum, jugulabit. ");
INSERT INTO latVUC_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Quod si fortuitu, et absque odio ");
INSERT INTO latVUC_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","et inimicitiis quidquam horum fecerit, ");
INSERT INTO latVUC_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","et hoc audiente populo fuerit comprobatum, atque inter percussorem et propinquum sanguinis quæstio ventilata: ");
INSERT INTO latVUC_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","liberabitur innocens de ultoris manu, et reducetur per sententiam in urbem, ad quam confugerat, manebitque ibi, donec sacerdos magnus, qui oleo sancto unctus est, moriatur. ");
INSERT INTO latVUC_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Si interfector extra fines urbium, quæ exulibus deputatæ sunt, ");
INSERT INTO latVUC_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","fuerit inventus, et percussus ab eo qui ultor est sanguinis: absque noxa erit qui eum occiderit. ");
INSERT INTO latVUC_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Debuerat enim profugus usque ad mortem pontificis in urbe residere. Postquam autem ille obierit, homicida revertetur in terram suam. ");
INSERT INTO latVUC_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Hæc sempiterna erunt, et legitima in cunctis habitationibus vestris. ");
INSERT INTO latVUC_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Homicida sub testibus punietur: ad unius testimonium nullus condemnabitur. ");
INSERT INTO latVUC_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Non accipietis pretium ab eo qui reus est sanguinis, statim et ipse morietur. ");
INSERT INTO latVUC_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Exules et profugi ante mortem pontificis nullo modo in urbes suas reverti poterunt, ");
INSERT INTO latVUC_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ne polluatis terram habitationis vestræ, quæ insontium cruore maculatur: nec aliter expiari potest, nisi per ejus sanguinem, qui alterius sanguinem fuderit. ");
INSERT INTO latVUC_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Atque ita emundabitur vestra possessio me commorante vobiscum. Ego enim sum Dominus qui habito inter filios Israël. ");
INSERT INTO latVUC_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Accesserunt autem et principes familiarum Galaad filii Machir filii Manasse, de stirpe filiorum Joseph: locutique sunt Moysi coram principibus Israël, atque dixerunt: ");
INSERT INTO latVUC_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Tibi domino nostro præcepit Dominus ut terram sorte divideres filiis Israël, et ut filiabus Salphaad fratris nostri dares possessionem debitam patri: ");
INSERT INTO latVUC_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","quas si alterius tribus homines uxores acceperint, sequetur possessio sua, et translata ad aliam tribum, de nostra hæreditate minuetur. ");
INSERT INTO latVUC_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Atque ita fiet, ut cum jubilæus, id est, quinquagesimus annus remissionis advenerit, confundatur sortium distributio, et aliorum possessio ad alios transeat. ");
INSERT INTO latVUC_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Respondit Moyses filiis Israël, et Domino præcipiente ait: Recte tribus filiorum Joseph locuta est. ");
INSERT INTO latVUC_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Et hæc lex super filiabus Salphaad a Domino promulgata est: nubant quibus volunt, tantum ut suæ tribus hominibus: ");
INSERT INTO latVUC_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ne commisceatur possessio filiorum Israël de tribu in tribum. Omnes enim viri ducent uxores de tribu et cognatione sua: ");
INSERT INTO latVUC_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","et cunctæ feminæ de eadem tribu maritos accipient: ut hæreditas permaneat in familiis, ");
INSERT INTO latVUC_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","nec sibi misceantur tribus, sed ita maneant ");
INSERT INTO latVUC_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ut a Domino separatæ sunt. Feceruntque filiæ Salphaad ut fuerat imperatum: ");
INSERT INTO latVUC_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","et nupserunt Maala, et Thersa, et Hegla, et Melcha, et Noa, filiis patrui sui ");
INSERT INTO latVUC_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","de familia Manasse, qui fuit filius Joseph: et possessio, quæ illis fuerat attributa, mansit in tribu et familia patris earum. ");
INSERT INTO latVUC_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Hæc sunt mandata atque judicia, quæ mandavit Dominus per manum Moysi ad filios Israël, in campestribus Moab supra Jordanem contra Jericho. ");
INSERT INTO latVUC_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Hæc sunt verba quæ locutus est Moyses ad omnem Israël trans Jordanem in solitudine campestri, contra mare Rubrum, inter Pharan et Tophel et Laban et Haseroth, ubi auri est plurimum: ");
INSERT INTO latVUC_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","undecim diebus de Horeb per viam montis Seir usque ad Cadesbarne. ");
INSERT INTO latVUC_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Quadragesimo anno, undecimo mense, prima die mensis, locutus est Moyses ad filios Israël omnia quæ præceperat illi Dominus, ut diceret eis, ");
INSERT INTO latVUC_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","postquam percussit Sehon regem Amorrhæorum, qui habitabat in Hesebon, et Og regem Basan, qui mansit in Astaroth, et in Edrai, ");
INSERT INTO latVUC_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","trans Jordanem in terra Moab. Cœpitque Moyses explanare legem, et dicere: ");
INSERT INTO latVUC_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Dominus Deus noster locutus est ad nos in Horeb, dicens: Sufficit vobis quod in hoc monte mansistis: ");
INSERT INTO latVUC_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","revertimini, et venite ad montem Amorrhæorum, et ad cetera quæ ei proxima sunt campestria atque montana et humiliora loca contra meridiem, et juxta littus maris, terram Chananæorum, et Libani usque ad flumen magnum Euphraten. ");
INSERT INTO latVUC_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","En, inquit, tradidi vobis: ingredimini et possidete eam, super qua juravit Dominus patribus vestris Abraham, Isaac, et Jacob, ut daret illam eis, et semini eorum post eos. ");
INSERT INTO latVUC_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Dixique vobis illo in tempore: ");
INSERT INTO latVUC_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Non possum solus sustinere vos: quia Dominus Deus vester multiplicavit vos, et estis hodie sicut stellæ cæli, plurimi. ");
INSERT INTO latVUC_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","(Dominus Deus patrum vestrorum addat ad hunc numerum multa millia, et benedicat vobis sicut locutus est.) ");
INSERT INTO latVUC_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Non valeo solus negotia vestra sustinere, et pondus ac jurgia. ");
INSERT INTO latVUC_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Date ex vobis viros sapientes et gnaros, et quorum conversatio sit probata in tribubus vestris, ut ponam eos vobis principes. ");
INSERT INTO latVUC_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Tunc respondistis mihi: Bona res est, quam vis facere. ");
INSERT INTO latVUC_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Tulique de tribubus vestris viros sapientes et nobiles, et constitui eos principes, tribunos, et centuriones, et quinquagenarios ac decanos, qui docerent vos singula. ");
INSERT INTO latVUC_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Præcepique eis, dicens: Audite illos, et quod justum est judicate: sive civis sit ille, sive peregrinus. ");
INSERT INTO latVUC_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Nulla erit distantia personarum: ita parvum audietis ut magnum, nec accipietis cujusquam personam, quia Dei judicium est. Quod si difficile vobis visum aliquid fuerit, referte ad me, et ego audiam. ");
INSERT INTO latVUC_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Præcepique omnia quæ facere deberetis. ");
INSERT INTO latVUC_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Profecti autem de Horeb, transivimus per eremum terribilem et maximam, quam vidistis, per viam montis Amorrhæi, sicut præceperat Dominus Deus noster nobis. Cumque venissemus in Cadesbarne, ");
INSERT INTO latVUC_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","dixi vobis: Venistis ad montem Amorrhæi, quem Dominus Deus noster daturus est nobis: ");
INSERT INTO latVUC_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","vide terram, quam Dominus Deus tuus dat tibi: ascende et posside eam, sicut locutus est Dominus Deus noster patribus tuis: noli timere, nec quidquam paveas. ");
INSERT INTO latVUC_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Et accessistis ad me omnes, atque dixistis: Mittamus viros qui considerent terram: et renuntient per quod iter debeamus ascendere, et ad quas pergere civitates. ");
INSERT INTO latVUC_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Cumque mihi sermo placuisset, misi ex vobis duodecim viros, singulos de tribubus suis. ");
INSERT INTO latVUC_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Qui cum perrexissent, et ascendissent in montana, venerunt usque ad Vallem botri: et considerata terra, ");
INSERT INTO latVUC_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","sumentes de fructibus ejus, ut ostenderent ubertatem, attulerunt ad nos, atque dixerunt: Bona est terra, quam Dominus Deus noster daturus est nobis. ");
INSERT INTO latVUC_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Et noluistis ascendere, sed increduli ad sermonem Domini Dei nostri, ");
INSERT INTO latVUC_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","murmurastis in tabernaculis vestris, atque dixistis: Odit nos Dominus, et idcirco eduxit nos de terra Ægypti, ut traderet nos in manu Amorrhæi, atque deleret. ");
INSERT INTO latVUC_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Quo ascendemus? nuntii terruerunt cor nostrum, dicentes: Maxima multitudo est, et nobis statura procerior; urbes magnæ, et ad cælum usque munitæ: filios Enacim vidimus ibi. ");
INSERT INTO latVUC_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Et dixi vobis: Nolite metuere, nec timeatis eos: ");
INSERT INTO latVUC_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Dominus Deus, qui ductor est vester, pro vobis ipse pugnabit, sicut fecit in Ægypto cunctis videntibus. ");
INSERT INTO latVUC_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Et in solitudine (ipse vidisti) portavit te Dominus Deus tuus, ut solet homo gestare parvulum filium suum, in omni via per quam ambulastis, donec veniretis ad locum istum. ");
INSERT INTO latVUC_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Et nec sic quidem credidistis Domino Deo vestro, ");
INSERT INTO latVUC_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","qui præcessit vos in via, et metatus est locum in quo tentoria figere deberetis, nocte ostendens vobis iter per ignem, et die per columnam nubis. ");
INSERT INTO latVUC_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Cumque audisset Dominus vocem sermonum vestrorum, iratus juravit, et ait: ");
INSERT INTO latVUC_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Non videbit quispiam de hominibus generationis hujus pessimæ terram bonam, quam sub juramento pollicitus sum patribus vestris, ");
INSERT INTO latVUC_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","præter Caleb filium Jephone: ipse enim videbit eam, et ipsi dabo terram, quam calcavit, et filiis ejus, quia secutus est Dominum. ");
INSERT INTO latVUC_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Nec miranda indignatio in populum, cum mihi quoque iratus Dominus propter vos dixerit: Nec tu ingredieris illuc: ");
INSERT INTO latVUC_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","sed Josue filius Nun minister tuus, ipse intrabit pro te. Hunc exhortare et robora, et ipse sorte terram dividet Israëli. ");
INSERT INTO latVUC_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Parvuli vestri, de quibus dixistis quod captivi ducerentur, et filii qui hodie boni ac mali ignorant distantiam, ipsi ingredientur: et ipsis dabo terram, et possidebunt eam. ");
INSERT INTO latVUC_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Vos autem revertimini, et abite in solitudinem per viam maris Rubri. ");
INSERT INTO latVUC_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Et respondistis mihi: Peccavimus Domino: ascendemus et pugnabimus, sicut præcepit Dominus Deus noster. Cumque instructi armis pergeretis in montem, ");
INSERT INTO latVUC_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ait mihi Dominus: Dic ad eos: Nolite ascendere, neque pugnetis: non enim sum vobiscum: ne cadatis coram inimicis vestris. ");
INSERT INTO latVUC_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Locutus sum, et non audistis: sed adversantes imperio Domini, et tumentes superbia, ascendistis in montem. ");
INSERT INTO latVUC_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Itaque egressus Amorrhæus, qui habitabat in montibus, et obviam veniens, persecutus est vos, sicut solent apes persequi: et cecidit de Seir usque Horma. ");
INSERT INTO latVUC_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Cumque reversi ploraretis coram Domino, non audivit vos, nec voci vestræ voluit acquiescere. ");
INSERT INTO latVUC_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Sedistis ergo in Cadesbarne multo tempore. ");
INSERT INTO latVUC_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Profectique inde, venimus in solitudinem, quæ ducit ad mare Rubrum, sicut mihi dixerat Dominus: et circuivimus montem Seir longo tempore. ");
INSERT INTO latVUC_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Dixitque Dominus ad me: ");
INSERT INTO latVUC_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Sufficit vobis circuire montem istum: ite contra aquilonem: ");
INSERT INTO latVUC_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","et populo præcipe, dicens: Transibitis per terminos fratrum vestrorum filiorum Esau, qui habitant in Seir, et timebunt vos. ");
INSERT INTO latVUC_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Videte ergo diligenter ne moveamini contra eos. Neque enim dabo vobis de terra eorum quantum potest unius pedis calcare vestigium, quia in possessionem Esau dedi montem Seir. ");
INSERT INTO latVUC_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Cibos emetis ab eis pecunia, et comedetis: aquam emptam haurietis, et bibetis. ");
INSERT INTO latVUC_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Dominus Deus tuus benedixit tibi in omni opere manuum tuarum: novit iter tuum, quomodo transieris solitudinem hanc magnam, per quadraginta annos habitans tecum Dominus Deus tuus, et nihil tibi defuit. ");
INSERT INTO latVUC_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Cumque transissemus fratres nostros filios Esau, qui habitabant in Seir, per viam campestrem de Elath, et de Asiongaber, venimus ad iter quod ducit in desertum Moab. ");
INSERT INTO latVUC_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Dixitque Dominus ad me: Non pugnes contra Moabitas, nec ineas adversus eos prælium: non enim dabo tibi quidquam de terra eorum, quia filiis Loth tradidi Ar in possessionem. ");
INSERT INTO latVUC_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Emim primi fuerunt habitatores ejus, populus magnus, et validus, et tam excelsus ut de Enacim stirpe, ");
INSERT INTO latVUC_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","quasi gigantes crederentur, et essent similes filiorum Enacim. Denique Moabitæ appellant eos Emim. ");
INSERT INTO latVUC_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","In Seir autem prius habitaverunt Horrhæi: quibus expulsis atque deletis, habitaverunt filii Esau, sicut fecit Israël in terra possessionis suæ, quam dedit illi Dominus. ");
INSERT INTO latVUC_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Surgentes ergo ut transiremus torrentem Zared, venimus ad eum. ");
INSERT INTO latVUC_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Tempus autem, quo ambulavimus de Cadesbarne usque ad transitum torrentis Zared, triginta et octo annorum fuit: donec consumeretur omnis generatio hominum bellatorum de castris, sicut juraverat Dominus: ");
INSERT INTO latVUC_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","cujus manus fuit adversum eos, ut interirent de castrorum medio. ");
INSERT INTO latVUC_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Postquam autem universi ceciderunt pugnatores, ");
INSERT INTO latVUC_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","locutus est Dominus ad me, dicens: ");
INSERT INTO latVUC_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Tu transibis hodie terminos Moab, urbem nomine Ar: ");
INSERT INTO latVUC_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","et accedens in vicina filiorum Ammon, cave ne pugnes contra eos, nec movearis ad prælium: non enim dabo tibi de terra filiorum Ammon, quia filiis Loth dedi eam in possessionem. ");
INSERT INTO latVUC_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Terra gigantum reputata est: et in ipsa olim habitaverunt gigantes, quos Ammonitæ vocant Zomzommim, ");
INSERT INTO latVUC_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","populus magnus, et multus, et proceræ longitudinis, sicut Enacim, quos delevit Dominus a facie eorum: et fecit illos habitare pro eis, ");
INSERT INTO latVUC_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","sicut fecerat filiis Esau, qui habitant in Seir, delens Horrhæos, et terram eorum illis tradens, quam possident usque in præsens. ");
INSERT INTO latVUC_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Hevæos quoque, qui habitabant in Haserim usque Gazan, Cappadoces expulerunt: qui egressi de Cappadocia deleverunt eos, et habitaverunt pro illis. ");
INSERT INTO latVUC_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Surgite, et transite torrentem Arnon: ecce tradidi in manu tua Sehon regem Hesebon Amorrhæum, et terram ejus incipe possidere, et committe adversus eum prælium. ");
INSERT INTO latVUC_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Hodie incipiam mittere terrorem atque formidinem tuam in populos, qui habitant sub omni cælo: ut audito nomine tuo paveant, et in morem parturientium contremiscant, et dolore teneantur. ");
INSERT INTO latVUC_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Misi ergo nuntios de solitudine Cademoth ad Sehon regem Hesebon verbis pacificis, dicens: ");
INSERT INTO latVUC_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Transibimus per terram tuam: publica gradiemur via; non declinabimus neque ad dexteram, neque ad sinistram. ");
INSERT INTO latVUC_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Alimenta pretio vende nobis, ut vescamur: aquam pecunia tribue, et sic bibemus. Tantum est ut nobis concedas transitum, ");
INSERT INTO latVUC_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","sicut fecerunt filii Esau, qui habitant in Seir, et Moabitæ, qui morantur in Ar: donec veniamus ad Jordanem, et transeamus ad terram, quam Dominus Deus noster daturus est nobis. ");
INSERT INTO latVUC_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Noluitque Sehon rex Hesebon dare nobis transitum: quia induraverat Dominus Deus tuus spiritum ejus, et obfirmaverat cor illius, ut traderetur in manus tuas, sicut nunc vides. ");
INSERT INTO latVUC_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Dixitque Dominus ad me: Ecce cœpi tibi tradere Sehon, et terram ejus: incipe possidere eam. ");
INSERT INTO latVUC_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Egressusque est Sehon obviam nobis cum omni populo suo ad prælium in Jasa. ");
INSERT INTO latVUC_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Et tradidit eum Dominus Deus noster nobis: percussimusque eum cum filiis suis et omni populo suo. ");
INSERT INTO latVUC_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Cunctasque urbes in tempore illo cepimus, interfectis habitatoribus earum, viris ac mulieribus et parvulis: non reliquimus in eis quidquam, ");
INSERT INTO latVUC_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","absque jumentis, quæ in partem venere prædantium: et spoliis urbium, quas cepimus ");
INSERT INTO latVUC_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ab Aroër, quæ est super ripam torrentis Arnon, oppido quod in valle situm est, usque Galaad. Non fuit vicus et civitas, quæ nostras effugeret manus: omnes tradidit Dominus Deus noster nobis, ");
INSERT INTO latVUC_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","absque terra filiorum Ammon, ad quam non accessimus: et cunctis quæ adjacent torrenti Jeboc, et urbibus montanis, universisque locis, a quibus nos prohibuit Dominus Deus noster. ");
INSERT INTO latVUC_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Itaque conversi ascendimus per iter Basan: egressusque est Og rex Basan in occursum nobis cum populo suo ad bellandum in Edrai. ");
INSERT INTO latVUC_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Dixitque Dominus ad me: Ne timeas eum: quia in manu tua traditus est cum omni populo ac terra sua: faciesque ei sicut fecisti Sehon regi Amorrhæorum, qui habitavit in Hesebon. ");
INSERT INTO latVUC_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Tradidit ergo Dominus Deus noster in manibus nostris etiam Og regem Basan, et universum populum ejus: percussimusque eos usque ad internecionem, ");
INSERT INTO latVUC_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","vastantes cunctas civitates illius uno tempore. Non fuit oppidum, quod nos effugeret: sexaginta urbes, omnem regionem Argob regni Og in Basan. ");
INSERT INTO latVUC_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Cunctæ urbes erant munitæ muris altissimis, portisque et vectibus, absque oppidis innumeris, quæ non habebant muros. ");
INSERT INTO latVUC_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Et delevimus eos, sicut feceramus Sehon regi Hesebon, disperdentes omnem civitatem, virosque ac mulieres et parvulos: ");
INSERT INTO latVUC_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","jumenta autem et spolia urbium diripuimus. ");
INSERT INTO latVUC_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Tulimusque illo in tempore terram de manu duorum regum Amorrhæorum, qui erant trans Jordanem: a torrente Arnon usque ad montem Hernon, ");
INSERT INTO latVUC_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","quem Sidonii Sarion vocant, et Amorrhæi Sanir: ");
INSERT INTO latVUC_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","omnes civitates, quæ sitæ sunt in planitie, et universam terram Galaad et Basan usque ad Selcha, et Edrai civitates regni Og in Basan. ");
INSERT INTO latVUC_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Solus quippe Og rex Basan restiterat de stirpe gigantum. Monstratur lectus ejus ferreus, qui est in Rabbath filiorum Ammon, novem cubitos habens longitudinis, et quatuor latitudinis ad mensuram cubiti virilis manus. ");
INSERT INTO latVUC_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Terramque possedimus tempore illo ab Aroër, quæ est super ripam torrentis Arnon, usque ad mediam partem montis Galaad: et civitates illius dedi Ruben et Gad. ");
INSERT INTO latVUC_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Reliquam autem partem Galaad, et omnem Basan regni Og, tradidi mediæ tribui Manasse, omnem regionem Argob: cunctaque Basan vocatur Terra gigantum. ");
INSERT INTO latVUC_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair filius Manasse possedit omnem regionem Argob usque ad terminos Gessuri et Machati. Vocavitque ex nomine suo Basan, Havoth Jair, id est, Villas Jair, usque in præsentem diem. ");
INSERT INTO latVUC_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Machir quoque dedi Galaad. ");
INSERT INTO latVUC_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Et tribubus Ruben et Gad dedi de terra Galaad usque ad torrentem Arnon medium torrentis, et confinium usque ad torrentem Jeboc, qui est terminus filiorum Ammon: ");
INSERT INTO latVUC_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","et planitiem solitudinis, atque Jordanem, et terminos Cenereth usque ad mare deserti, quod est salsissimum, ad radices montis Phasga contra orientem. ");
INSERT INTO latVUC_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Præcepique vobis in tempore illo, dicens: Dominus Deus vester dat vobis terram hanc in hæreditatem: expediti præcedite fratres vestros filios Israël omnes viri robusti, ");
INSERT INTO latVUC_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","absque uxoribus, et parvulis, atque jumentis. Novi enim quod plura habeatis pecora, et in urbibus remanere debebunt, quas tradidi vobis, ");
INSERT INTO latVUC_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","donec requiem tribuat Dominus fratribus vestris, sicut vobis tribuit: et possideant ipsi etiam terram, quam daturus est eis trans Jordanem: tunc revertetur unusquisque in possessionem suam, quam dedi vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Josue quoque in tempore illo præcepi, dicens: Oculi tui viderunt quæ fecit Dominus Deus vester duobus his regibus: sic faciet omnibus regnis, ad quæ transiturus es. ");
INSERT INTO latVUC_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ne timeas eos: Dominus enim Deus vester pugnabit pro vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Precatusque sum Dominum in tempore illo, dicens: ");
INSERT INTO latVUC_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Domine Deus, tu cœpisti ostendere servo tuo magnitudinem tuam, manumque fortissimam: neque enim est alius deus vel in cælo, vel in terra, qui possit facere opera tua, et comparari fortitudini tuæ. ");
INSERT INTO latVUC_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Transibo igitur, et videbo terram hanc optimam trans Jordanem, et montem istum egregium, et Libanum. ");
INSERT INTO latVUC_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Iratusque est Dominus mihi propter vos, nec exaudivit me, sed dixit mihi: Sufficit tibi: nequaquam ultra loquaris de hac re ad me. ");
INSERT INTO latVUC_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Ascende cacumen Phasgæ, et oculos tuos circumfer ad occidentem, et ad aquilonem, austrumque et orientem, et aspice; nec enim transibis Jordanem istum. ");
INSERT INTO latVUC_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Præcipe Josue, et corrobora eum atque conforta: quia ipse præcedet populum istum, et dividet eis terram quam visurus es. ");
INSERT INTO latVUC_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Mansimusque in valle contra fanum Phogor. ");
INSERT INTO latVUC_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Et nunc, Israël, audi præcepta et judicia, quæ ego doceo te: ut faciens ea, vivas, et ingrediens possideas terram, quam Dominus Deus patrum vestrorum daturus est vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Non addetis ad verbum, quod vobis loquor, nec auferetis ex eo: custodite mandata Domini Dei vestri, quæ ego præcipio vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Oculi vestri viderunt omnia quæ fecit Dominus contra Beelphegor, quomodo contriverit omnes cultores ejus de medio vestri. ");
INSERT INTO latVUC_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Vos autem qui adhæretis Domino Deo vestro, vivitis universi usque in præsentem diem. ");
INSERT INTO latVUC_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Scitis quod docuerim vos præcepta atque justitias, sicut mandavit mihi Dominus Deus meus: sic facietis ea in terra, quam possessuri estis: ");
INSERT INTO latVUC_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","et observabitis et implebitis opere. Hæc est enim vestra sapientia, et intellectus coram populis, ut audientes universa præcepta hæc, dicant: En populus sapiens et intelligens, gens magna. ");
INSERT INTO latVUC_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Nec est alia natio tam grandis, quæ habeat deos appropinquantes sibi, sicut Deus noster adest cunctis obsecrationibus nostris. ");
INSERT INTO latVUC_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Quæ est enim alia gens sic inclyta, ut habeat cæremonias, justaque judicia, et universam legem, quam ego proponam hodie ante oculos vestros? ");
INSERT INTO latVUC_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Custodi igitur temetipsum, et animam tuam sollicite. Ne obliviscaris verborum, quæ viderunt oculi tui, et ne excidant de corde tuo cunctis diebus vitæ tuæ. Docebis ea filios ac nepotes tuos, ");
INSERT INTO latVUC_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","a die in quo stetisti coram Domino Deo tuo in Horeb, quando Dominus locutus est mihi, dicens: Congrega ad me populum, ut audiant sermones meos, et discant timere me omni tempore quo vivunt in terra, doceantque filios suos. ");
INSERT INTO latVUC_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Et accessistis ad radices montis, qui ardebat usque ad cælum: erantque in eo tenebræ, et nubes, et caligo. ");
INSERT INTO latVUC_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Locutusque est Dominus ad vos de medio ignis. Vocem verborum ejus audistis, et formam penitus non vidistis. ");
INSERT INTO latVUC_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Et ostendit vobis pactum suum, quod præcepit ut faceretis, et decem verba, quæ scripsit in duabus tabulis lapideis. ");
INSERT INTO latVUC_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Mihique mandavit in illo tempore ut docerem vos cæremonias et judicia, quæ facere deberetis in terra, quam possessuri estis. ");
INSERT INTO latVUC_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Custodite igitur sollicite animas vestras. Non vidistis aliquam similitudinem in die, qua locutus est vobis Dominus in Horeb de medio ignis: ");
INSERT INTO latVUC_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ne forte decepti faciatis vobis sculptam similitudinem, aut imaginem masculi vel feminæ: ");
INSERT INTO latVUC_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","similitudinem omnium jumentorum, quæ sunt super terram, vel avium sub cælo volantium, ");
INSERT INTO latVUC_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","atque reptilium, quæ moventur in terra, sive piscium qui sub terra morantur in aquis: ");
INSERT INTO latVUC_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ne forte elevatis oculis ad cælum, videas solem et lunam, et omnia astra cæli, et errore deceptus adores ea, et colas quæ creavit Dominus Deus tuus in ministerium cunctis gentibus, quæ sub cælo sunt. ");
INSERT INTO latVUC_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Vos autem tulit Dominus, et eduxit de fornace ferrea Ægypti, ut haberet populum hæreditarium, sicut est in præsenti die. ");
INSERT INTO latVUC_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Iratusque est Dominus contra me propter sermones vestros, et juravit ut non transirem Jordanem, nec ingrederer terram optimam, quam daturus est vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ecce morior in hac humo; non transibo Jordanem: vos transibitis, et possidebitis terram egregiam. ");
INSERT INTO latVUC_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Cave nequando obliviscaris pacti Domini Dei tui, quod pepigit tecum, et facias tibi sculptam similitudinem eorum, quæ fieri Dominus prohibuit: ");
INSERT INTO latVUC_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","quia Dominus Deus tuus ignis consumens est, Deus æmulator. ");
INSERT INTO latVUC_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Si genueritis filios ac nepotes, et morati fueritis in terra, deceptique feceritis vobis aliquam similitudinem, patrantes malum coram Domino Deo vestro, ut eum ad iracundiam provocetis: ");
INSERT INTO latVUC_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","testes invoco hodie cælum et terram, cito perituros vos esse de terra, quam transito Jordane possessuri estis: non habitabitis in ea longo tempore, sed delebit vos Dominus, ");
INSERT INTO latVUC_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","atque disperget in omnes gentes, et remanebitis pauci in nationibus, ad quas vos ducturus est Dominus. ");
INSERT INTO latVUC_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ibique servietis diis, qui hominum manu fabricati sunt, ligno et lapidi qui non vident, nec audiunt, nec comedunt, nec odorantur. ");
INSERT INTO latVUC_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Cumque quæsieris ibi Dominum Deum tuum, invenies eum: si tamen toto corde quæsieris, et tota tribulatione animæ tuæ. ");
INSERT INTO latVUC_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Postquam te invenerint omnia quæ prædicta sunt, novissimo tempore reverteris ad Dominum Deum tuum, et audies vocem ejus. ");
INSERT INTO latVUC_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Quia Deus misericors Dominus Deus tuus est: non dimittet te, nec omnino delebit, neque obliviscetur pacti, in quo juravit patribus tuis. ");
INSERT INTO latVUC_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Interroga de diebus antiquis, qui fuerunt ante te ex die quo creavit Deus hominem super terram, a summo cælo usque ad summum ejus, si facta est aliquando hujuscemodi res, aut umquam cognitum est, ");
INSERT INTO latVUC_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ut audiret populus vocem Dei loquentis de medio ignis, sicut tu audisti, et vixisti: ");
INSERT INTO latVUC_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","si fecit Deus ut ingrederetur, et tolleret sibi gentem de medio nationum, per tentationes, signa atque portenta, per pugnam et robustam manum, extentumque brachium, et horribiles visiones juxta omnia quæ fecit pro vobis Dominus Deus vester in Ægypto, videntibus oculis tuis: ");
INSERT INTO latVUC_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","ut scires quoniam Dominus ipse est Deus, et non est alius præter eum. ");
INSERT INTO latVUC_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","De cælo te fecit audire vocem suam, ut doceret te, et in terra ostendit tibi ignem suum maximum, et audisti verba illius de medio ignis: ");
INSERT INTO latVUC_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","quia dilexit patres tuos, et elegit semen eorum post eos. Eduxitque te præcedens in virtute sua magna ex Ægypto, ");
INSERT INTO latVUC_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ut deleret nationes maximas et fortiores te in introitu tuo: et introduceret te, daretque tibi terram earum in possessionem, sicut cernis in præsenti die. ");
INSERT INTO latVUC_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Scito ergo hodie, et cogitato in corde tuo quod Dominus ipse sit Deus in cælo sursum, et in terra deorsum, et non sit alius. ");
INSERT INTO latVUC_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Custodi præcepta ejus atque mandata, quæ ego præcipio tibi: ut bene sit tibi, et filiis tuis post te, et permaneas multo tempore super terram, quam Dominus Deus tuus daturus est tibi. ");
INSERT INTO latVUC_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Tunc separavit Moyses tres civitates trans Jordanem ad orientalem plagam, ");
INSERT INTO latVUC_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ut confugiat ad eas qui occiderit nolens proximum suum, nec sibi fuerit inimicus ante unum et alterum diem, et ad harum aliquam urbium possit evadere: ");
INSERT INTO latVUC_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Bosor in solitudine, quæ sita est in terra campestri de tribu Ruben: et Ramoth in Galaad, quæ est in tribu Gad: et Golan in Basan, quæ est in tribu Manasse. ");
INSERT INTO latVUC_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ista est lex, quam proposuit Moyses coram filiis Israël: ");
INSERT INTO latVUC_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","et hæc testimonia et cæremoniæ atque judicia, quæ locutus est ad filios Israël, quando egressi sunt de Ægypto, ");
INSERT INTO latVUC_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","trans Jordanem in valle contra fanum Phogor in terra Sehon regis Amorrhæi, qui habitavit in Hesebon, quem percussit Moyses. Filii quoque Israël egressi ex Ægypto ");
INSERT INTO latVUC_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","possederunt terram ejus, et terram Og regis Basan, duorum regum Amorrhæorum, qui erant trans Jordanem ad solis ortum: ");
INSERT INTO latVUC_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ab Aroër, quæ sita est super ripam torrentis Arnon, usque ad montem Sion, qui est et Hermon, ");
INSERT INTO latVUC_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","omnem planitiem trans Jordanem ad orientalem plagam, usque ad mare solitudinis, et usque ad radices montis Phasga. ");
INSERT INTO latVUC_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Vocavitque Moyses omnem Israëlem, et dixit ad eum: Audi, Israël, cæremonias atque judicia, quæ ego loquor in auribus vestris hodie: discite ea, et opere complete. ");
INSERT INTO latVUC_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Dominus Deus noster pepigit nobiscum fœdus in Horeb. ");
INSERT INTO latVUC_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Non cum patribus nostris iniit pactum, sed nobiscum qui in præsentiarum sumus, et vivimus. ");
INSERT INTO latVUC_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Facie ad faciem locutus est nobis in monte de medio ignis. ");
INSERT INTO latVUC_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Ego sequester et medius fui inter Dominum et vos in tempore illo, ut annuntiarem vobis verba ejus: timuistis enim ignem, et non ascendistis in montem. Et ait: ");
INSERT INTO latVUC_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Ego Dominus Deus tuus, qui eduxi te de terra Ægypti, de domo servitutis. ");
INSERT INTO latVUC_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Non habebis deos alienos in conspectu meo. ");
INSERT INTO latVUC_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Non facies tibi sculptile, nec similitudinem omnium, quæ in cælo sunt desuper, et quæ in terra deorsum, et quæ versantur in aquis sub terra. ");
INSERT INTO latVUC_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Non adorabis ea, et non coles. Ego enim sum Dominus Deus tuus: Deus æmulator, reddens iniquitatem patrum super filios in tertiam et quartam generationem his qui oderunt me: ");
INSERT INTO latVUC_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","et faciens misericordiam in multa millia diligentibus me, et custodientibus præcepta mea. ");
INSERT INTO latVUC_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Non usurpabis nomen Domini Dei tui frustra: quia non erit impunitus qui super re vana nomen ejus assumpserit. ");
INSERT INTO latVUC_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Observa diem sabbati, ut sanctifices eum, sicut præcepit tibi Dominus Deus tuus. ");
INSERT INTO latVUC_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Sex diebus operaberis, et facies omnia opera tua. ");
INSERT INTO latVUC_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Septimus dies sabbati est, id est, requies Domini Dei tui. Non facies in eo quidquam operis tu, et filius tuus, et filia, servus et ancilla, et bos, et asinus, et omne jumentum tuum, et peregrinus qui est intra portas tuas: ut requiescat servus tuus, et ancilla tua, sicut et tu. ");
INSERT INTO latVUC_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Memento quod et ipse servieris in Ægypto, et eduxerit te inde Dominus Deus tuus in manu forti, et brachio extento. Idcirco præcepit tibi ut observares diem sabbati. ");
INSERT INTO latVUC_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Honora patrem tuum et matrem, sicut præcepit tibi Dominus Deus tuus, ut longo vivas tempore, et bene sit tibi in terra, quam Dominus Deus tuus daturus est tibi. ");
INSERT INTO latVUC_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Non occides, ");
INSERT INTO latVUC_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","neque mœchaberis, ");
INSERT INTO latVUC_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","furtumque non facies: ");
INSERT INTO latVUC_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","nec loqueris contra proximum tuum falsum testimonium. ");
INSERT INTO latVUC_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Non concupisces uxorem proximi tui: non domum, non agrum, non servum, non ancillam, non bovem, non asinum, et universa quæ illius sunt. ");
INSERT INTO latVUC_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Hæc verba locutus est Dominus ad omnem multitudinem vestram in monte de medio ignis et nubis, et caliginis, voce magna, nihil addens amplius: et scripsit ea in duabus tabulis lapideis, quas tradidit mihi. ");
INSERT INTO latVUC_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Vos autem postquam audistis vocem de medio tenebrarum, et montem ardere vidistis, accessistis ad me omnes principes tribuum et majores natu, atque dixistis: ");
INSERT INTO latVUC_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Ecce ostendit nobis Dominus Deus noster majestatem et magnitudinem suam: vocem ejus audivimus de medio ignis, et probavimus hodie, quod loquente Deo cum homine, vixerit homo. ");
INSERT INTO latVUC_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Cur ergo moriemur, et devorabit nos ignis hic maximus? si enim audierimus ultra vocem Domini Dei nostri, moriemur. ");
INSERT INTO latVUC_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Quid est omnis caro, ut audiat vocem Dei viventis, qui de medio ignis loquitur sicut nos audivimus, et possit vivere? ");
INSERT INTO latVUC_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Tu magis accede: et audi cuncta quæ dixerit Dominus Deus noster tibi: loquerisque ad nos, et nos audientes faciemus ea. ");
INSERT INTO latVUC_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Quod cum audisset Dominus, ait ad me: Audivi vocem verborum populi hujus quæ locuti sunt tibi: bene omnia sunt locuti. ");
INSERT INTO latVUC_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Quis det talem eos habere mentem, ut timeant me, et custodiant universa mandata mea in omni tempore, ut bene sit eis et filiis eorum in sempiternum? ");
INSERT INTO latVUC_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Vade et dic eis: Revertimini in tentoria vestra. ");
INSERT INTO latVUC_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Tu vero hic sta mecum, et loquar tibi omnia mandata mea, et cæremonias atque judicia: quæ docebis eos, ut faciant ea in terra, quam dabo illis in possessionem. ");
INSERT INTO latVUC_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Custodite igitur et facite quæ præcepit Dominus Deus vobis: non declinabitis neque ad dexteram, neque ad sinistram: ");
INSERT INTO latVUC_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","sed per viam, quam præcepit Dominus Deus vester, ambulabitis, ut vivatis, et bene sit vobis, et protelentur dies in terra possessionis vestræ. ");
INSERT INTO latVUC_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Hæc sunt præcepta, et cæremoniæ, atque judicia, quæ mandavit Dominus Deus vester ut docerem vos, et faciatis ea in terra, ad quam transgredimini possidendam: ");
INSERT INTO latVUC_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ut timeas Dominum Deum tuum, et custodias omnia mandata et præcepta ejus, quæ ego præcipio tibi, et filiis, ac nepotibus tuis, cunctis diebus vitæ tuæ, ut prolongentur dies tui. ");
INSERT INTO latVUC_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Audi, Israël, et observa ut facias quæ præcepit tibi Dominus, et bene sit tibi, et multipliceris amplius, sicut pollicitus est Dominus Deus patrum tuorum tibi terram lacte et melle manantem. ");
INSERT INTO latVUC_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Audi, Israël: Dominus Deus noster, Dominus unus est. ");
INSERT INTO latVUC_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Diliges Dominum Deum tuum ex toto corde tuo, et ex tota anima tua, et ex tota fortitudine tua. ");
INSERT INTO latVUC_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Eruntque verba hæc, quæ ego præcipio tibi hodie, in corde tuo: ");
INSERT INTO latVUC_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","et narrabis ea filiis tuis, et meditaberis in eis sedens in domo tua, et ambulans in itinere, dormiens atque consurgens. ");
INSERT INTO latVUC_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Et ligabis ea quasi signum in manu tua, eruntque et movebuntur inter oculos tuos, ");
INSERT INTO latVUC_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","scribesque ea in limine, et ostiis domus tuæ. ");
INSERT INTO latVUC_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Cumque introduxerit te Dominus Deus tuus in terram, pro qua juravit patribus tuis Abraham, Isaac, et Jacob, et dederit tibi civitates magnas et optimas, quas non ædificasti, ");
INSERT INTO latVUC_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","domos plenas cunctarum opum, quas non exstruxisti, cisternas, quas non fodisti, vineta et oliveta, quæ non plantasti, ");
INSERT INTO latVUC_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","et comederis, et saturatus fueris: ");
INSERT INTO latVUC_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","cave diligenter ne obliviscaris Domini, qui eduxit te de terra Ægypti, de domo servitutis. Dominum Deum tuum timebis, et illi soli servies, ac per nomen illius jurabis. ");
INSERT INTO latVUC_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Non ibitis post deos alienos cunctarum gentium, quæ in circuitu vestro sunt: ");
INSERT INTO latVUC_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","quoniam Deus æmulator Dominus Deus tuus in medio tui: nequando irascatur furor Domini Dei tui contra te, et auferat te de superficie terræ. ");
INSERT INTO latVUC_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Non tentabis Dominum Deum tuum, sicut tentasti in loco tentationis. ");
INSERT INTO latVUC_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Custodi præcepta Domini Dei tui, ac testimonia et cæremonias, quas præcepit tibi: ");
INSERT INTO latVUC_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","et fac quod placitum est et bonum in conspectu Domini, ut bene sit tibi: et ingressus possideas terram optimam, de qua juravit Dominus patribus tuis, ");
INSERT INTO latVUC_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ut deleret omnes inimicos tuos coram te, sicut locutus est. ");
INSERT INTO latVUC_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Cumque interrogaverit te filius tuus cras, dicens: Quid sibi volunt testimonia hæc, et cæremoniæ, atque judicia, quæ præcepit Dominus Deus noster nobis? ");
INSERT INTO latVUC_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","dices ei: Servi eramus Pharaonis in Ægypto, et eduxit nos Dominus de Ægypto in manu forti: ");
INSERT INTO latVUC_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","fecitque signa atque prodigia magna et pessima in Ægypto contra Pharaonem, et omnem domum illius in conspectu nostro, ");
INSERT INTO latVUC_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","et eduxit nos inde, ut introductis daret terram, super qua juravit patribus nostris. ");
INSERT INTO latVUC_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Præcepitque nobis Dominus ut faciamus omnia legitima hæc, et timeamus Dominum Deum nostrum, ut bene sit nobis cunctis diebus vitæ nostræ, sicut est hodie. ");
INSERT INTO latVUC_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Eritque nostri misericors, si custodierimus et fecerimus omnia præcepta ejus coram Domino Deo nostro, sicut mandavit nobis. ");
INSERT INTO latVUC_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Cum introduxerit te Dominus Deus tuus in terram, quam possessurus ingredieris, et deleverit gentes multas coram te, Hethæum, et Gergezæum, et Amorrhæum, Chananæum, et Pherezæum, et Hevæum, et Jebusæum, septem gentes multo majoris numeri quam tu es, et robustiores te: ");
INSERT INTO latVUC_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","tradideritque eas Dominus Deus tuus tibi, percuties eas usque ad internecionem. Non inibis cum eis fœdus, nec misereberis earum, ");
INSERT INTO latVUC_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","neque sociabis cum eis conjugia. Filiam tuam non dabis filio ejus, nec filiam illius accipies filio tuo: ");
INSERT INTO latVUC_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","quia seducet filium tuum, ne sequatur me, et ut magis serviat diis alienis: irasceturque furor Domini, et delebit te cito. ");
INSERT INTO latVUC_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Quin potius hæc facietis eis: aras eorum subvertite, et confringite statuas, lucosque succidite, et sculptilia comburite: ");
INSERT INTO latVUC_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","quia populus sanctus es Domino Deo tuo. Te elegit Dominus Deus tuus, ut sis ei populus peculiaris de cunctis populis, qui sunt super terram. ");
INSERT INTO latVUC_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Non quia cunctas gentes numero vincebatis, vobis junctus est Dominus, et elegit vos, cum omnibus sitis populis pauciores: ");
INSERT INTO latVUC_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","sed quia dilexit vos Dominus, et custodivit juramentum, quod juravit patribus vestris: eduxitque vos in manu forti, et redemit de domo servitutis, de manu Pharaonis regis Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Et scies, quia Dominus Deus tuus, ipse est Deus fortis et fidelis, custodiens pactum et misericordiam diligentibus se, et his qui custodiunt præcepta ejus in mille generationes: ");
INSERT INTO latVUC_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","et reddens odientibus se statim, ita ut disperdat eos, et ultra non differat, protinus eis restituens quod merentur. ");
INSERT INTO latVUC_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Custodi ergo præcepta et cæremonias atque judicia, quæ ego mando tibi hodie ut facias. ");
INSERT INTO latVUC_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Si postquam audieris hæc judicia, custodieris ea, et feceris, custodiet et Dominus Deus tuus pactum tibi, et misericordiam quam juravit patribus tuis: ");
INSERT INTO latVUC_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","et diliget te, ac multiplicabit, benedicetque fructui ventris tui, et fructui terræ tuæ, frumento tuo, atque vindemiæ, oleo, et armentis, gregibus ovium tuarum super terram, pro qua juravit patribus tuis ut daret eam tibi. ");
INSERT INTO latVUC_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Benedictus eris inter omnes populos. Non erit apud te sterilis utriusque sexus, tam in hominibus quam in gregibus tuis. ");
INSERT INTO latVUC_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Auferet Dominus a te omnem languorem: et infirmitates Ægypti pessimas, quas novisti, non inferet tibi, sed cunctis hostibus tuis. ");
INSERT INTO latVUC_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Devorabis omnes populos, quos Dominus Deus tuus daturus est tibi. Non parcet eis oculus tuus, nec servies diis eorum, ne sint in ruinam tui. ");
INSERT INTO latVUC_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Si dixeris in corde tuo: Plures sunt gentes istæ quam ego: quomodo potero delere eas? ");
INSERT INTO latVUC_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","noli metuere, sed recordare quæ fecerit Dominus Deus tuus Pharaoni, et cunctis Ægyptiis, ");
INSERT INTO latVUC_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","plagas maximas, quas viderunt oculi tui, et signa atque portenta, manumque robustam, et extentum brachium, ut educeret te Dominus Deus tuus: sic faciet cunctis populis, quos metuis. ");
INSERT INTO latVUC_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Insuper et crabrones mittet Dominus Deus tuus in eos, donec deleat omnes atque disperdat qui te fugerint, et latere potuerint. ");
INSERT INTO latVUC_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Non timebis eos, quia Dominus Deus tuus in medio tui est, Deus magnus et terribilis: ");
INSERT INTO latVUC_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ipse consumet nationes has in conspectu tuo paulatim atque per partes. Non poteris eas delere pariter: ne forte multiplicentur contra te bestiæ terræ. ");
INSERT INTO latVUC_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Dabitque eos Dominus Deus tuus in conspectu tuo: et interficiet illos, donec penitus deleantur. ");
INSERT INTO latVUC_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Tradetque reges eorum in manus tuas, et disperdes nomina eorum sub cælo: nullus poterit resistere tibi, donec conteras eos. ");
INSERT INTO latVUC_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Sculptilia eorum igne combures: non concupisces argentum et aurum, de quibus facta sunt, neque assumes ex eis tibi quidquam, ne offendas, propterea quia abominatio est Domini tui: ");
INSERT INTO latVUC_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","nec inferes quippiam ex idolo in domum tuam, ne fias anathema, sicut et illud est. Quasi spurcitiam detestaberis, et velut inquinamentum ac sordes abominationi habebis, quia anathema est. ");
INSERT INTO latVUC_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Omne mandatum, quod ego præcipio tibi hodie, cave diligenter ut facias, ut possitis vivere, et multiplicemini, ingressique possideatis terram, pro qua juravit Dominus patribus vestris. ");
INSERT INTO latVUC_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Et recordaberis cuncti itineris, per quod adduxit te Dominus Deus tuus quadraginta annis per desertum, ut affligeret te, atque tentaret, et nota fierent quæ in tuo animo versabantur, utrum custodires mandata illius, an non. ");
INSERT INTO latVUC_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Afflixit te penuria, et dedit tibi cibum manna, quod ignorabas tu et patres tui: ut ostenderet tibi quod non in solo pane vivat homo, sed in omni verbo quod egreditur de ore Dei. ");
INSERT INTO latVUC_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Vestimentum tuum, quo operiebaris, nequaquam vetustate defecit, et pes tuus non est subtritus, en quadragesimus annus est: ");
INSERT INTO latVUC_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","ut recogites in corde tuo, quia sicut erudit filium suum homo, sic Dominus Deus tuus erudivit te, ");
INSERT INTO latVUC_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","ut custodias mandata Domini Dei tui, et ambules in viis ejus, et timeas eum. ");
INSERT INTO latVUC_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Dominus enim Deus tuus introducet te in terram bonam, terram rivorum, aquarumque et fontium, in cujus campis et montibus erumpunt fluviorum abyssi: ");
INSERT INTO latVUC_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","terram frumenti, hordei ac vinearum, in qua ficus, et malogranata, et oliveta nascuntur: terram olei ac mellis, ");
INSERT INTO latVUC_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ubi absque ulla penuria comedes panem tuum, et rerum omnium abundantia perfrueris: cujus lapides ferrum sunt, et de montibus ejus æris metalla fodiuntur: ");
INSERT INTO latVUC_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","ut cum comederis, et satiatus fueris, benedicas Domino Deo tuo pro terra optima, quam dedit tibi. ");
INSERT INTO latVUC_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Observa, et cave nequando obliviscaris Domini Dei tui, et negligas mandata ejus atque judicia et cæremonias, quas ego præcipio tibi hodie: ");
INSERT INTO latVUC_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","ne postquam comederis et satiatus fueris, domos pulchras ædificaveris, et habitaveris in eis, ");
INSERT INTO latVUC_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","habuerisque armenta boum, et ovium greges, argenti et auri, cunctarumque rerum copiam, ");
INSERT INTO latVUC_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","elevetur cor tuum, et non reminiscaris Domini Dei tui, qui eduxit te de terra Ægypti, de domo servitutis, ");
INSERT INTO latVUC_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","et ductor tuus fuit in solitudine magna atque terribili, in qua erat serpens flatu adurens, et scorpio, ac dipsas, et nullæ omnino aquæ: qui eduxit rivos de petra durissima, ");
INSERT INTO latVUC_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","et cibavit te manna in solitudine, quod nescierunt patres tui. Et postquam afflixit ac probavit, ad extremum misertus est tui, ");
INSERT INTO latVUC_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","ne diceres in corde tuo: Fortitudo mea, et robur manus meæ, hæc mihi omnia præstiterunt: ");
INSERT INTO latVUC_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","sed recorderis Domini Dei tui, quod ipse vires tibi præbuerit, ut impleret pactum suum, super quo juravit patribus tuis, sicut præsens indicat dies. ");
INSERT INTO latVUC_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Sin autem oblitus Domini Dei tui, secutus fueris deos alienos, coluerisque illos et adoraveris: ecce nunc prædico tibi quod omnino dispereas. ");
INSERT INTO latVUC_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Sicut gentes, quas delevit Dominus in introitu tuo, ita et vos peribitis, si inobedientes fueritis voci Domini Dei vestri. ");
INSERT INTO latVUC_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Audi, Israël: tu transgredieris hodie Jordanem, ut possideas nationes maximas et fortiores te, civitates ingentes, et ad cælum usque muratas, ");
INSERT INTO latVUC_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","populum magnum atque sublimem, filios Enacim, quos ipse vidisti et audisti, quibus nullus potest ex adverso resistere. ");
INSERT INTO latVUC_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Scies ergo hodie quod Dominus Deus tuus ipse transibit ante te, ignis devorans atque consumens, qui conterat eos, et deleat atque disperdat ante faciem tuam velociter, sicut locutus est tibi: ");
INSERT INTO latVUC_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","ne dicas in corde tuo, cum deleverit eos Dominus Deus tuus in conspectu tuo: Propter justitiam meam introduxit me Dominus ut terram hanc possiderem, cum propter impietates suas istæ deletæ sint nationes. ");
INSERT INTO latVUC_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Neque enim propter justitias tuas, et æquitatem cordis tui ingredieris, ut possideas terras earum: sed quia illæ egerunt impie, introëunte te deletæ sunt: et ut compleret verbum suum Dominus, quod sub juramento pollicitus est patribus tuis, Abraham, Isaac, et Jacob. ");
INSERT INTO latVUC_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Scito ergo quod non propter justitias tuas Dominus Deus tuus dederit tibi terram hanc optimam in possessionem, cum durissimæ cervicis sis populus. ");
INSERT INTO latVUC_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Memento, et ne obliviscaris, quomodo ad iracundiam provocaveris Dominum Deum tuum in solitudine. Ex eo die, quo egressus es ex Ægypto usque ad locum istum, semper adversum Dominum contendisti. ");
INSERT INTO latVUC_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Nam et in Horeb provocasti eum, et iratus delere te voluit, ");
INSERT INTO latVUC_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","quando ascendi in montem, ut acciperem tabulas lapideas, tabulas pacti quod pepigit vobiscum Dominus: et perseveravi in monte quadraginta diebus ac noctibus, panem non comedens, et aquam non bibens. ");
INSERT INTO latVUC_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Deditque mihi Dominus duas tabulas lapideas scriptas digito Dei, et continentes omnia verba quæ vobis locutus est in monte de medio ignis, quando concio populi congregata est. ");
INSERT INTO latVUC_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Cumque transissent quadraginta dies, et totidem noctes, dedit mihi Dominus duas tabulas lapideas, tabulas fœderis, ");
INSERT INTO latVUC_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","dixitque mihi: Surge, et descende hinc cito: quia populus tuus, quem eduxisti de Ægypto, deseruerunt velociter viam, quam demonstrasti eis, feceruntque sibi conflatile. ");
INSERT INTO latVUC_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Rursumque ait Dominus ad me: Cerno quod populus iste duræ cervicis sit: ");
INSERT INTO latVUC_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","dimitte me ut conteram eum, et deleam nomen ejus de sub cælo, et constituam te super gentem, quæ hac major et fortior sit. ");
INSERT INTO latVUC_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Cumque de monte ardente descenderem, et duas tabulas fœderis utraque tenerem manu, ");
INSERT INTO latVUC_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","vidissemque vos peccasse Domino Deo vestro, et fecisse vobis vitulum conflatilem, ac deseruisse velociter viam ejus, quam vobis ostenderat: ");
INSERT INTO latVUC_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","projeci tabulas de manibus meis, confregique eas in conspectu vestro. ");
INSERT INTO latVUC_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Et procidi ante Dominum sicut prius, quadraginta diebus et noctibus panem non comedens, et aquam non bibens, propter omnia peccata vestra quæ gessistis contra Dominum, et eum ad iracundiam provocastis: ");
INSERT INTO latVUC_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","timui enim indignationem et iram illius, qua adversum vos concitatus, delere vos voluit. Et exaudivit me Dominus etiam hac vice. ");
INSERT INTO latVUC_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Adversum Aaron quoque vehementer iratus, voluit eum conterere, et pro illo similiter deprecatus sum. ");
INSERT INTO latVUC_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Peccatum autem vestrum quod feceratis, id est, vitulum, arripiens, igne combussi, et in frusta comminuens, omninoque in pulverem redigens, projeci in torrentem, qui de monte descendit. ");
INSERT INTO latVUC_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","In incendio quoque, et in tentatione, et in Sepulchris concupiscentiæ provocastis Dominum: ");
INSERT INTO latVUC_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","et quando misit vos de Cadesbarne, dicens: Ascendite, et possidete terram, quam dedi vobis, et contempsistis imperium Domini Dei vestri, et non credidistis ei, neque vocem ejus audire voluistis: ");
INSERT INTO latVUC_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","sed semper fuistis rebelles a die qua nosse vos cœpi. ");
INSERT INTO latVUC_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Et jacui coram Domino quadraginta diebus ac noctibus, quibus eum suppliciter deprecabar, ne deleret vos ut fuerat comminatus: ");
INSERT INTO latVUC_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","et orans dixi: Domine Deus, ne disperdas populum tuum, et hæreditatem tuam, quam redemisti in magnitudine tua, quos eduxisti de Ægypto in manu forti. ");
INSERT INTO latVUC_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Recordare servorum tuorum Abraham, Isaac, et Jacob: ne aspicias duritiam populi hujus, et impietatem atque peccatum: ");
INSERT INTO latVUC_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ne forte dicant habitatores terræ, de qua eduxisti nos: Non poterat Dominus introducere eos in terram, quam pollicitus est eis, et oderat illos: idcirco eduxit, ut interficeret eos in solitudine: ");
INSERT INTO latVUC_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","qui sunt populus tuus et hæreditas tua, quos eduxisti in fortitudine tua magna, et in brachio tuo extento. ");
INSERT INTO latVUC_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","In tempore illo dixit Dominus ad me: Dola tibi duas tabulas lapideas, sicut priores fuerunt, et ascende ad me in montem: faciesque arcam ligneam, ");
INSERT INTO latVUC_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","et scribam in tabulis verba quæ fuerunt in his qui ante confregisti: ponesque eas in arca. ");
INSERT INTO latVUC_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Feci igitur arcam de lignis setim. Cumque dolassem duas tabulas lapideas instar priorum, ascendi in montem, habens eas in manibus. ");
INSERT INTO latVUC_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Scripsitque in tabulis, juxta id quod prius scripserat, verba decem, quæ locutus est Dominus ad vos in monte de medio ignis, quando populus congregatus est: et dedit eas mihi. ");
INSERT INTO latVUC_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Reversusque de monte, descendi, et posui tabulas in arcam, quam feceram, quæ hucusque ibi sunt, sicut mihi præcepit Dominus. ");
INSERT INTO latVUC_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Filii autem Israël moverunt castra ex Beroth filiorum Jacan in Mosera, ubi Aaron mortuus ac sepultus est, pro quo sacerdotio functus est Eleazar filius ejus. ");
INSERT INTO latVUC_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Inde venerunt in Gadgad: de quo loco profecti, castrametati sunt in Jetebatha, in terra aquarum atque torrentium. ");
INSERT INTO latVUC_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Eo tempore separavit tribum Levi, ut portaret arcam fœderis Domini, et staret coram eo in ministerio, ac benediceret in nomine illius usque in præsentem diem. ");
INSERT INTO latVUC_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Quam ob rem non habuit Levi partem, neque possessionem cum fratribus suis: quia ipse Dominus possessio ejus est, sicut promisit ei Dominus Deus tuus. ");
INSERT INTO latVUC_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Ego autem steti in monte, sicut prius, quadraginta diebus ac noctibus: exaudivitque me Dominus etiam hac vice, et te perdere noluit. ");
INSERT INTO latVUC_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Dixitque mihi: Vade, et præcede populum, ut ingrediatur, et possideat terram, quam juravi patribus eorum ut traderem eis. ");
INSERT INTO latVUC_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Et nunc Israël, quid Dominus Deus tuus petit a te, nisi ut timeas Dominum Deum tuum, et ambules in viis ejus, et diligas eum, ac servias Domino Deo tuo in toto corde tuo, et in tota anima tua: ");
INSERT INTO latVUC_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","custodiasque mandata Domini, et cæremonias ejus, quas ego hodie præcipio tibi, ut bene sit tibi? ");
INSERT INTO latVUC_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","En Domini Dei tui cælum est, et cælum cæli, terra, et omnia quæ in ea sunt: ");
INSERT INTO latVUC_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","et tamen patribus tuis conglutinatus est Dominus, et amavit eos, elegitque semen eorum post eos, id est, vos, de cunctis gentibus, sicut hodie comprobatur. ");
INSERT INTO latVUC_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Circumcidite igitur præputium cordis vestri, et cervicem vestram ne induretis amplius: ");
INSERT INTO latVUC_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","quia Dominus Deus vester ipse est Deus deorum, et Dominus dominantium, Deus magnus, et potens, et terribilis, qui personam non accipit, nec munera. ");
INSERT INTO latVUC_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Facit judicium pupillo et viduæ; amat peregrinum, et dat ei victum atque vestitum. ");
INSERT INTO latVUC_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Et vos ergo amate peregrinos, quia et ipsi fuistis advenæ in terra Ægypti. ");
INSERT INTO latVUC_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Dominum Deum tuum timebis, et ei soli servies: ipsi adhærebis, jurabisque in nomine illius. ");
INSERT INTO latVUC_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ipse est laus tua, et Deus tuus, qui fecit tibi hæc magnalia et terribilia, quæ viderunt oculi tui. ");
INSERT INTO latVUC_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","In septuaginta animabus descenderunt patres tui in Ægyptum, et ecce nunc multiplicavit te Dominus Deus tuus sicut astra cæli. ");
INSERT INTO latVUC_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Ama itaque Dominum Deum tuum, et observa præcepta ejus et cæremonias, judicia atque mandata, omni tempore. ");
INSERT INTO latVUC_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Cognoscite hodie quæ ignorant filii vestri, qui non viderunt disciplinam Domini Dei vestri, magnalia ejus et robustam manum, extentumque brachium, ");
INSERT INTO latVUC_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","signa et opera quæ fecit in medio Ægypti Pharaoni regi, et universæ terræ ejus, ");
INSERT INTO latVUC_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","omnique exercitui Ægyptiorum, et equis ac curribus: quomodo operuerint eos aquæ maris Rubri, cum vos persequerentur, et deleverit eos Dominus usque in præsentem diem: ");
INSERT INTO latVUC_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","vobisque quæ fecerit in solitudine donec veniretis ad hunc locum: ");
INSERT INTO latVUC_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","et Dathan atque Abiron filiis Eliab, qui fuit filius Ruben: quos aperto ore suo terra absorbuit, cum domibus et tabernaculis, et universa substantia eorum, quam habebant in medio Israël. ");
INSERT INTO latVUC_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Oculi vestri viderunt opera Domini magna quæ fecit, ");
INSERT INTO latVUC_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","ut custodiatis universa mandata illius, quæ ego hodie præcipio vobis, et possitis introire, et possidere terram, ad quam ingredimini, ");
INSERT INTO latVUC_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","multoque in ea vivatis tempore: quam sub juramento pollicitus est Dominus patribus vestris, et semini eorum, lacte et melle manantem. ");
INSERT INTO latVUC_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Terra enim, ad quam ingrederis possidendam, non est sicut terra Ægypti, de qua existi, ubi jacto semine in hortorum morem aquæ ducuntur irriguæ: ");
INSERT INTO latVUC_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","sed montuosa est et campestris, de cælo expectans pluvias, ");
INSERT INTO latVUC_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","quam Dominus Deus tuus semper invisit, et oculi illius in ea sunt a principio anni usque ad finem ejus. ");
INSERT INTO latVUC_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Si ergo obedieritis mandatis meis, quæ ego hodie præcipio vobis, ut diligatis Dominum Deum vestrum, et serviatis ei in toto corde vestro, et in tota anima vestra: ");
INSERT INTO latVUC_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","dabit pluviam terræ vestræ temporaneam et serotinam, ut colligatis frumentum, et vinum, et oleum, ");
INSERT INTO latVUC_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","fœnumque ex agris ad pascenda jumenta, et ut ipsi comedatis ac saturemini. ");
INSERT INTO latVUC_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Cavete ne forte decipiatur cor vestrum, et recedatis a Domino, serviatisque diis alienis, et adoretis eos: ");
INSERT INTO latVUC_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","iratusque Dominus claudat cælum, et pluviæ non descendant, nec terra det germen suum, pereatisque velociter de terra optima, quam Dominus daturus est vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Ponite hæc verba mea in cordibus et in animis vestris, et suspendite ea pro signo in manibus, et inter oculos vestros collocate. ");
INSERT INTO latVUC_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Docete filios vestros ut illa meditentur: quando sederis in domo tua, et ambulaveris in via, et accubueris atque surrexeris. ");
INSERT INTO latVUC_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Scribes ea super postes et januas domus tuæ, ");
INSERT INTO latVUC_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ut multiplicentur dies tui, et filiorum tuorum in terra, quam juravit Dominus patribus tuis, ut daret eis quamdiu cælum imminet terræ. ");
INSERT INTO latVUC_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Si enim custodieritis mandata quæ ego præcipio vobis, et feceritis ea, ut diligatis Dominum Deum vestrum, et ambuletis in omnibus viis ejus, adhærentes ei, ");
INSERT INTO latVUC_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","disperdet Dominus omnes gentes istas ante faciem vestram, et possidebitis eas, quæ majores et fortiores vobis sunt. ");
INSERT INTO latVUC_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Omnis locus, quem calcaverit pes vester, vester erit. A deserto, et a Libano, a flumine magno Euphrate usque ad mare occidentale erunt termini vestri. ");
INSERT INTO latVUC_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Nullus stabit contra vos: terrorem vestrum et formidinem dabit Dominus Deus vester super omnem terram quam calcaturi estis, sicut locutus est vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","En propono in conspectu vestro hodie benedictionem et maledictionem: ");
INSERT INTO latVUC_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","benedictionem, si obedieritis mandatis Domini Dei vestri, quæ ego hodie præcipio vobis: ");
INSERT INTO latVUC_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","maledictionem, si non obedieritis mandatis Domini Dei vestri, sed recesseritis de via, quam ego nunc ostendo vobis, et ambulaveritis post deos alienos, quos ignoratis. ");
INSERT INTO latVUC_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Cum vero introduxerit te Dominus Deus tuus in terram, ad quam pergis habitandam, pones benedictionem super montem Garizim, maledictionem super montem Hebal: ");
INSERT INTO latVUC_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","qui sunt trans Jordanem, post viam quæ vergit ad solis occubitum in terra Chananæi, qui habitat in campestribus contra Galgalam, quæ est juxta vallem tendentem et intrantem procul. ");
INSERT INTO latVUC_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Vos enim transibitis Jordanem, ut possideatis terram quam Dominus Deus vester daturus est vobis, ut habeatis et possideatis illam. ");
INSERT INTO latVUC_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Videte ergo ut impleatis cæremonias atque judicia, quæ ego hodie ponam in conspectu vestro. ");
INSERT INTO latVUC_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Hæc sunt præcepta atque judicia, quæ facere debetis in terra, quam Dominus Deus patrum tuorum daturus est tibi, ut possideas eam cunctis diebus, quibus super humum gradieris. ");
INSERT INTO latVUC_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Subvertite omnia loca, in quibus coluerunt gentes, quas possessuri estis, deos suos super montes excelsos, et colles, et subter omne lignum frondosum. ");
INSERT INTO latVUC_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Dissipate aras eorum, et confringite statuas: lucos igne comburite, et idola comminuite: disperdite nomina eorum de locis illis. ");
INSERT INTO latVUC_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Non facietis ita Domino Deo vestro: ");
INSERT INTO latVUC_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","sed ad locum, quem elegerit Dominus Deus vester de cunctis tribubus vestris, ut ponat nomen suum ibi, et habitet in eo, venietis: ");
INSERT INTO latVUC_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","et offeretis in loco illo holocausta et victimas vestras, decimas et primitias manuum vestrarum, et vota atque donaria, primogenita boum et ovium. ");
INSERT INTO latVUC_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Et comedetis ibi in conspectu Domini Dei vestri: ac lætabimini in cunctis, ad quæ miseritis manum vos et domus vestræ, in quibus benedixerit vobis Dominus Deus vester. ");
INSERT INTO latVUC_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Non facietis ibi quæ nos hic facimus hodie, singuli quod sibi rectum videtur: ");
INSERT INTO latVUC_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","neque enim usque in præsens tempus venistis ad requiem, et possessionem, quam Dominus Deus vester daturus est vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Transibitis Jordanem, et habitabitis in terra, quam Dominus Deus vester daturus est vobis, ut requiescatis a cunctis hostibus per circuitum: et absque ullo timore habitetis ");
INSERT INTO latVUC_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","in loco, quem elegerit Dominus Deus vester, ut sit nomen ejus in eo: illuc omnia, quæ præcipio, conferetis, holocausta, et hostias, ac decimas, et primitias manuum vestrarum: et quidquid præcipuum est in muneribus, quæ vovebitis Domino. ");
INSERT INTO latVUC_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Ibi epulabimini coram Domino Deo vestro, vos et filii ac filiæ vestræ, famuli et famulæ, atque Levites qui in urbibus vestris commoratur: neque enim habet aliam partem et possessionem inter vos. ");
INSERT INTO latVUC_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Cave ne offeras holocausta tua in omni loco, quem videris: ");
INSERT INTO latVUC_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","sed in eo, quem elegerit Dominus, in una tribuum tuarum offeres hostias, et facies quæcumque præcipio tibi. ");
INSERT INTO latVUC_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Sin autem comedere volueris, et te esus carnium delectaverit, occide, comede juxta benedictionem Domini Dei tui, quam dedit tibi in urbibus tuis: sive immundum fuerit, hoc est, maculatum et debile: sive mundum, hoc est, integrum et sine macula, quod offerri licet, sicut capream et cervum, comedes: ");
INSERT INTO latVUC_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","absque esu dumtaxat sanguinis, quem super terram quasi aquam effundes. ");
INSERT INTO latVUC_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Non poteris comedere in oppidis tuis decimam frumenti, et vini, et olei tui, primogenita armentorum et pecorum, et omnia quæ voveris, et sponte offerre volueris, et primitias manuum tuarum: ");
INSERT INTO latVUC_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","sed coram Domino Deo tuo comedes ea in loco, quem elegerit Dominus Deus tuus, tu et filius tuus, et filia tua, et servus et famula, atque Levites qui manet in urbibus tuis: et lætaberis et reficieris coram Domino Deo tuo in cunctis ad quæ extenderis manum tuam. ");
INSERT INTO latVUC_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Cave ne derelinquas Levitem in omni tempore quo versaris in terra. ");
INSERT INTO latVUC_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Quando dilataverit Dominus Deus tuus terminos tuos, sicut locutus est tibi, et volueris vesci carnibus, quas desiderat anima tua: ");
INSERT INTO latVUC_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","locus autem, quem elegerit Dominus Deus tuus ut sit nomen ejus ibi, si procul fuerit, occides de armentis et pecoribus, quæ habueris, sicut præcepi tibi, et comedes in oppidis tuis, ut tibi placet. ");
INSERT INTO latVUC_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Sicut comeditur caprea et cervus, ita vesceris eis: et mundus et immundus in commune vescentur. ");
INSERT INTO latVUC_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Hoc solum cave, ne sanguinem comedas: sanguis enim eorum pro anima est, et idcirco non debes animam comedere cum carnibus: ");
INSERT INTO latVUC_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","sed super terram fundes quasi aquam, ");
INSERT INTO latVUC_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","ut bene sit tibi et filiis tuis post te, cum feceris quod placet in conspectu Domini. ");
INSERT INTO latVUC_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Quæ autem sanctificaveris, et voveris Domino, tolles, et venies ad locum, quem elegerit Dominus: ");
INSERT INTO latVUC_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","et offeres oblationes tuas carnem et sanguinem super altare Domini Dei tui: sanguinem hostiarum fundes in altari; carnibus autem ipse vesceris. ");
INSERT INTO latVUC_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Observa et audi omnia quæ ego præcipio tibi, ut bene sit tibi et filiis tuis post te in sempiternum, cum feceris quod bonum est et placitum in conspectu Domini Dei tui. ");
INSERT INTO latVUC_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Quando disperdiderit Dominus Deus tuus ante faciem tuam gentes, ad quas ingredieris possidendas, et possederis eas, atque habitaveris in terra earum: ");
INSERT INTO latVUC_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","cave ne imiteris eas, postquam te fuerint introëunte subversæ, et requiras cæremonias earum, dicens: Sicut coluerunt gentes istæ deos suos, ita et ego colam. ");
INSERT INTO latVUC_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Non facies similiter Domino Deo tuo. Omnes enim abominationes, quas aversatur Dominus, fecerunt diis suis, offerentes filios et filias, et comburentes igni. ");
INSERT INTO latVUC_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Quod præcipio tibi, hoc tantum facito Domino: nec addas quidquam, nec minuas. ");
INSERT INTO latVUC_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Si surrexerit in medio tui prophetes, aut qui somnium vidisse se dicat, et prædixerit signum atque portentum, ");
INSERT INTO latVUC_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","et evenerit quod locutus est, et dixerit tibi: Eamus, et sequamur deos alienos quos ignoras, et serviamus eis: ");
INSERT INTO latVUC_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","non audies verba prophetæ illius aut somniatoris: quia tentat vos Dominus Deus vester, ut palam fiat utrum diligatis eum an non, in toto corde, et in tota anima vestra. ");
INSERT INTO latVUC_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Dominum Deum vestrum sequimini, et ipsum timete, et mandata illius custodite, et audite vocem ejus: ipsi servietis, et ipsi adhærebitis. ");
INSERT INTO latVUC_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Propheta autem ille aut fictor somniorum interficietur: quia locutus est ut vos averteret a Domino Deo vestro, qui eduxit vos de terra Ægypti, et redemit vos de domo servitutis: ut errare te faceret de via, quam tibi præcepit Dominus Deus tuus: et auferes malum de medio tui. ");
INSERT INTO latVUC_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Si tibi voluerit persuadere frater tuus filius matris tuæ, aut filius tuus vel filia, sive uxor quæ est in sinu tuo, aut amicus, quem diligis ut animam tuam, clam dicens: Eamus, et serviamus diis alienis, quos ignoras tu, et patres tui, ");
INSERT INTO latVUC_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","cunctarum in circuitu gentium, quæ juxta vel procul sunt, ab initio usque ad finem terræ, ");
INSERT INTO latVUC_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","non acquiescas ei, nec audias, neque parcat ei oculus tuus ut miserearis et occultes eum, ");
INSERT INTO latVUC_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","sed statim interficies: sit primum manus tua super eum, et postea omnis populus mittat manum. ");
INSERT INTO latVUC_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Lapidibus obrutus necabitur: quia voluit te abstrahere a Domino Deo tuo, qui eduxit te de terra Ægypti, de domo servitutis: ");
INSERT INTO latVUC_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","ut omnis Israël audiens timeat, et nequaquam ultra faciat quippiam hujus rei simile. ");
INSERT INTO latVUC_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Si audieris in una urbium tuarum, quas Dominus Deus tuus dabit tibi ad habitandum, dicentes aliquos: ");
INSERT INTO latVUC_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","Egressi sunt filii Belial de medio tui, et averterunt habitatores urbis suæ, atque dixerunt: Eamus, et serviamus diis alienis quos ignoratis: ");
INSERT INTO latVUC_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","quare sollicite et diligenter, rei veritate perspecta, si inveneris certum esse quod dicitur, et abominationem hanc opere perpetratam, ");
INSERT INTO latVUC_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","statim percuties habitatores urbis illius in ore gladii, et delebis eam ac omnia quæ in illa sunt, usque ad pecora. ");
INSERT INTO latVUC_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Quidquid etiam supellectilis fuerit, congregabis in medio platearum ejus, et cum ipsa civitate succendes, ita ut universa consumas Domino Deo tuo, et sit tumulus sempiternus. Non ædificabitur amplius, ");
INSERT INTO latVUC_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","et non adhærebit de illo anathemate quidquam in manu tua: ut avertatur Dominus ab ira furoris sui, et misereatur tui, multiplicetque te sicut juravit patribus tuis, ");
INSERT INTO latVUC_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","quando audieris vocem Domini Dei tui custodiens omnia præcepta ejus, quæ ego præcipio tibi hodie, ut facias quod placitum est in conspectu Domini Dei tui. ");
INSERT INTO latVUC_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Filii estote Domini Dei vestri: non vos incidetis, nec facietis calvitium super mortuo: ");
INSERT INTO latVUC_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","quoniam populus sanctus es Domino Deo tuo, et te elegit ut sis ei in populum peculiarem de cunctis gentibus, quæ sunt super terram. ");
INSERT INTO latVUC_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Ne comedatis quæ immunda sunt. ");
INSERT INTO latVUC_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Hoc est animal quod comedere debetis: bovem, et ovem, et capram, ");
INSERT INTO latVUC_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","cervum et capream, bubalum, tragelaphum, pygargum, orygem, camelopardalum. ");
INSERT INTO latVUC_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Omne animal, quod in duas partes findit ungulam, et ruminat, comedetis. ");
INSERT INTO latVUC_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","De his autem, quæ ruminant, et ungulam non findunt, comedere non debetis, ut camelum, leporem, chœrogryllum: hæc, quia ruminant et non dividunt ungulam, immunda erunt vobis. ");
INSERT INTO latVUC_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Sus quoque, quoniam dividat ungulam et non ruminat, immunda erit. Carnibus eorum non vescemini, et cadavera non tangetis. ");
INSERT INTO latVUC_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","Hæc comedetis ex omnibus quæ morantur in aquis: quæ habent pinnulas et squamas, comedite: ");
INSERT INTO latVUC_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","quæ absque pinnulis et squamis sunt, ne comedatis, quia immunda sunt. ");
INSERT INTO latVUC_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Omnes aves mundas comedite. ");
INSERT INTO latVUC_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Immundas ne comedatis: aquilam scilicet, et gryphem, et haliæetum, ");
INSERT INTO latVUC_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ixion et vulturem ac milvum juxta genus suum: ");
INSERT INTO latVUC_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","et omne corvini generis, ");
INSERT INTO latVUC_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","et struthionem, ac noctuam, et larum, atque accipitrem juxta genus suum: ");
INSERT INTO latVUC_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","herodium ac cygnum, et ibin, ");
INSERT INTO latVUC_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","ac mergulum, porphyrionem, et nycticoracem, ");
INSERT INTO latVUC_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","onocrotalum, et charadrium, singula in genere suo: upupam quoque et vespertilionem. ");
INSERT INTO latVUC_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Et omne quod reptat et pennulas habet, immundum erit, et non comedetur. ");
INSERT INTO latVUC_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Omne quod mundum est, comedite. ");
INSERT INTO latVUC_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Quidquid autem morticinum est, ne vescamini ex eo. Peregrino, qui intra portas tuas est, da ut comedat, aut vende ei: quia tu populus sanctus Domini Dei tui es. Non coques hædum in lacte matris suæ. ");
INSERT INTO latVUC_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Decimam partem separabis de cunctis fructibus tuis qui nascuntur in terra per annos singulos, ");
INSERT INTO latVUC_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","et comedes in conspectu Domini Dei tui in loco quem elegerit, ut in eo nomen illius invocetur, decimam frumenti tui, et vini, et olei, et primogenita de armentis et ovibus tuis: ut discas timere Dominum Deum tuum omni tempore. ");
INSERT INTO latVUC_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Cum autem longior fuerit via, et locus quem elegerit Dominus Deus tuus, tibique benedixerit, nec potueris ad eum hæc cuncta portare, ");
INSERT INTO latVUC_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","vendes omnia, et in pretium rediges, portabisque manu tua, et proficisceris ad locum quem elegerit Dominus Deus tuus: ");
INSERT INTO latVUC_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","et emes ex eadem pecunia quidquid tibi placuerit, sive ex armentis, sive ex ovibus, vinum quoque et siceram, et omne quod desiderat anima tua: et comedes coram Domino Deo tuo, et epulaberis tu et domus tua: ");
INSERT INTO latVUC_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","et Levites qui intra portas tuas est, cave ne derelinquas eum, quia non habet aliam partem in possessione tua. ");
INSERT INTO latVUC_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Anno tertio separabis aliam decimam ex omnibus quæ nascuntur tibi eo tempore, et repones intra januas tuas. ");
INSERT INTO latVUC_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Venietque Levites qui aliam non habet partem nec possessionem tecum, et peregrinus ac pupillus et vidua, qui intra portas tuas sunt, et comedent et saturabuntur: ut benedicat tibi Dominus Deus tuus in cunctis operibus manuum tuarum quæ feceris. ");
INSERT INTO latVUC_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Septimo anno facies remissionem, ");
INSERT INTO latVUC_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","quæ hoc ordine celebrabitur. Cui debetur aliquid ab amico vel proximo ac fratre suo, repetere non poterit, quia annus remissionis est Domini. ");
INSERT INTO latVUC_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","A peregrino et advena exiges: civem et propinquum repetendi non habebis potestatem. ");
INSERT INTO latVUC_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Et omnino indigens et mendicus non erit inter vos: ut benedicat tibi Dominus Deus tuus in terra, quam traditurus est tibi in possessionem. ");
INSERT INTO latVUC_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","Si tamen audieris vocem Domini Dei tui, et custodieris universa quæ jussit, et quæ ego hodie præcipio tibi, benedicet tibi, ut pollicitus est. ");
INSERT INTO latVUC_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Fœnerabis gentibus multis, et ipse a nullo accipies mutuum. Dominaberis nationibus plurimis, et tui nemo dominabitur. ");
INSERT INTO latVUC_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Si unus de fratribus tuis, qui morantur intra portas civitatis tuæ in terra quam Dominus Deus tuus daturus est tibi, ad paupertatem venerit, non obdurabis cor tuum, nec contrahes manum, ");
INSERT INTO latVUC_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","sed aperies eam pauperi, et dabis mutuum, quo eum indigere perspexeris. ");
INSERT INTO latVUC_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Cave ne forte subrepat tibi impia cogitatio, et dicas in corde tuo: Appropinquat septimus annus remissionis: et avertas oculos tuos a paupere fratre tuo, nolens ei quod postulat mutuum commodare: ne clamet contra te ad Dominum, et fiat tibi in peccatum. ");
INSERT INTO latVUC_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Sed dabis ei: nec ages quippiam callide in ejus necessitatibus sublevandis, ut benedicat tibi Dominus Deus tuus in omni tempore, et in cunctis ad quæ manum miseris. ");
INSERT INTO latVUC_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Non deerunt pauperes in terra habitationis tuæ: idcirco ego præcipio tibi, ut aperias manum fratri tuo egeno et pauperi, qui tecum versatur in terra. ");
INSERT INTO latVUC_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Cum tibi venditus fuerit frater tuus Hebræus aut Hebræa, et sex annis servierit tibi, in septimo anno dimittes eum liberum: ");
INSERT INTO latVUC_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","et quem libertate donaveris, nequaquam vacuum abire patieris: ");
INSERT INTO latVUC_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","sed dabis viaticum de gregibus, et de area, et torculari tuo, quibus Dominus Deus tuus benedixerit tibi. ");
INSERT INTO latVUC_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Memento quod et ipse servieris in terra Ægypti, et liberaverit te Dominus Deus tuus, et idcirco ego nunc præcipio tibi. ");
INSERT INTO latVUC_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Sin autem dixerit: Nolo egredi: eo quod diligat te, et domum tuam, et bene sibi apud te esse sentiat: ");
INSERT INTO latVUC_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","assumes subulam, et perforabis aurem ejus in janua domus tuæ, et serviet tibi usque in æternum. Ancillæ quoque similiter facies. ");
INSERT INTO latVUC_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Non avertas ab eis oculos tuos, quando dimiseris eos liberos, quoniam juxta mercedem mercenarii per sex annos servivit tibi: ut benedicat tibi Dominus Deus tuus in cunctis operibus quæ agis. ");
INSERT INTO latVUC_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","De primogenitis, quæ nascuntur in armentis, et in ovibus tuis, quidquid est sexus masculini, sanctificabis Domino Deo tuo. Non operaberis in primogenito bovis, et non tondebis primogenita ovium. ");
INSERT INTO latVUC_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","In conspectu Domini Dei tui comedes ea per annos singulos in loco quem elegerit Dominus, tu et domus tua. ");
INSERT INTO latVUC_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Sin autem habuerit maculam, vel claudum fuerit, vel cæcum, aut in aliqua parte deforme vel debile, non immolabitur Domino Deo tuo: ");
INSERT INTO latVUC_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","sed intra portas urbis tuæ comedes illud: tam mundus quam immundus similiter vescentur eis, quasi caprea et cervo. ");
INSERT INTO latVUC_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Hoc solum observabis, ut sanguinem eorum non comedas, sed effundes in terram quasi aquam. ");
INSERT INTO latVUC_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Observa mensem novarum frugum, et verni primum temporis, ut facias Phase Domino Deo tuo: quoniam in isto mense eduxit te Dominus Deus tuus de Ægypto nocte. ");
INSERT INTO latVUC_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Immolabisque Phase Domino Deo tuo de ovibus, et de bobus, in loco quem elegerit Dominus Deus tuus, ut habitet nomen ejus ibi. ");
INSERT INTO latVUC_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Non comedes in eo panem fermentatum: septem diebus comedes absque fermento afflictionis panem, quoniam in pavore egressus es de Ægypto: ut memineris diei egressionis tuæ de Ægypto, omnibus diebus vitæ tuæ. ");
INSERT INTO latVUC_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Non apparebit fermentum in omnibus terminis tuis septem diebus, et non remanebit de carnibus ejus, quod immolatum est vespere in die primo, usque mane. ");
INSERT INTO latVUC_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Non poteris immolare Phase in qualibet urbium tuarum, quas Dominus Deus tuus daturus est tibi, ");
INSERT INTO latVUC_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","sed in loco quem elegerit Dominus Deus tuus, ut habitet nomen ejus ibi: immolabis Phase vespere ad solis occasum, quando egressus es de Ægypto. ");
INSERT INTO latVUC_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Et coques, et comedes in loco quem elegerit Dominus Deus tuus, maneque consurgens vades in tabernacula tua. ");
INSERT INTO latVUC_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Sex diebus comedes azyma: et in die septima, quia collecta est Domini Dei tui, non facies opus. ");
INSERT INTO latVUC_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Septem hebdomadas numerabis tibi ab ea die qua falcem in segetem miseris. ");
INSERT INTO latVUC_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Et celebraris diem festum hebdomadarum Domino Deo tuo, oblationem spontaneam manus tuæ, quam offeres juxta benedictionem Domini Dei tui: ");
INSERT INTO latVUC_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","et epulaberis coram Domino Deo tuo, tu, filius tuus et filia tua, servus tuus et ancilla tua, et Levites qui est intra portas tuas, advena ac pupillus et vidua, qui morantur vobiscum: in loco quem elegerit Dominus Deus tuus, ut habitet nomen ejus ibi. ");
INSERT INTO latVUC_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Et recordaberis quoniam servus fueris in Ægypto: custodiesque ac facies quæ præcepta sunt. ");
INSERT INTO latVUC_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Solemnitatem quoque tabernaculorum celebrabis per septem dies, quando collegeris de area et torculari fruges tuas: ");
INSERT INTO latVUC_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","et epulaberis in festivitate tua, tu, filius tuus et filia, servus tuus et ancilla, Levites quoque et advena, pupillus et vidua qui intra portas tuas sunt. ");
INSERT INTO latVUC_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Septem diebus Domino Deo tuo festa celebrabis in loco quem elegerit Dominus: benedicetque tibi Dominus Deus tuus in cunctis frugibus tuis, et in omni opere manuum tuarum, erisque in lætitia. ");
INSERT INTO latVUC_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Tribus vicibus per annum apparebit omne masculinum tuum in conspectu Domini Dei tui in loco quem elegerit: in solemnitate azymorum, in solemnitate hebdomadarum, et in solemnitate tabernaculorum. Non apparebit ante Dominum vacuus: ");
INSERT INTO latVUC_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","sed offeret unusquisque secundum quod habuerit juxta benedictionem Domini Dei sui, quam dederit ei. ");
INSERT INTO latVUC_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Judices et magistros constitues in omnibus portis tuis, quas Dominus Deus tuus dederit tibi, per singulas tribus tuas: ut judicent populum justo judicio, ");
INSERT INTO latVUC_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","nec in alteram partem declinent. Non accipies personam, nec munera: quia munera excæcant oculos sapientum, et mutant verba justorum. ");
INSERT INTO latVUC_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Juste quod justum est persequeris: ut vivas, et possideas terram, quam Dominus Deus tuus dederit tibi. ");
INSERT INTO latVUC_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Non plantabis lucum, et omnem arborem juxta altare Domini Dei tui. ");
INSERT INTO latVUC_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Nec facies tibi, neque constitues statuam: quæ odit Dominus Deus tuus. ");
INSERT INTO latVUC_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Non immolabis Domino Deo tuo ovem, et bovem, in quo est macula, aut quippiam vitii: quia abominatio est Domino Deo tuo. ");
INSERT INTO latVUC_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Cum reperti fuerint apud te intra unam portarum tuarum, quas Dominus Deus tuus dabit tibi, vir aut mulier qui faciant malum in conspectu Domini Dei tui, et transgrediantur pactum illius, ");
INSERT INTO latVUC_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","ut vadant et servant diis alienis, et adorent eo