﻿USE sofia;
DROP TABLE IF EXISTS sofia.lag_vpl;
CREATE TABLE lag_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lag_vpl WRITE;
INSERT INTO lag_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ɨhɨ noo nkʉmbʉkɨra ya marina ya lʉkolo lwa YéesuKirisitʉ, mwaana wa Daúdi, mwaana wa Aburaháamu. ");
INSERT INTO lag_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aburaháamu ajáa amʉvyaala Isaka, Isaka akamʉvyaala Yaakúupu, Yaakúupu akamʉvyaala Yʉ́ʉda na vaanaavo, ");
INSERT INTO lag_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yʉ́ʉda akamʉvyaala Peréesi na Séera na íyo waavo nɨ Tamáari ajáa. Peréesi akamʉvyaala Hesiróoni, Hesiróoni akamʉvyaala Aráamu, ");
INSERT INTO lag_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aráamu akamʉvyaala Aminadáabu, Aminadáabu akamʉvyaala Nashóoni, Nashóoni akamʉvyaala Salimóoni, ");
INSERT INTO lag_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimóoni akamʉvyaala Boáasi, fuma kwa Raháabu. Boáasi akamʉvyaala Obéedi fuma kwa Rúutu, Obéedi akamʉvyaala Yéese, ");
INSERT INTO lag_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ne Yéese akamʉvyaala mʉtemi Daúdi. Daúdi akamʉvyaala Solomóoni fuma kwa muki wa Uría. ");
INSERT INTO lag_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomóoni akamʉvyaala Rehoboáamu, Rehoboáamu akamʉvyaala Abíya, Abíya akamʉvyaala Áasa, ");
INSERT INTO lag_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Áasa akamʉvyaala Yehoshofáati, Yehoshofáati akamʉvyaala Yóramu, Yóramu akamʉvyaala Usíia, ");
INSERT INTO lag_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usíia akamʉvyaala Yósamu, Yósamu akamʉvyaala Aháasi, Aháasi akamʉvyaala Hesekía, ");
INSERT INTO lag_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekía akamʉvyaala Manáase, Manáase akamʉvyaala Amóoni, Amóoni akamʉvyaala Yosía, ");
INSERT INTO lag_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosía akamʉvyaala Yekonía na vaanaavo, mpɨɨndɨ vaantʉ va Yʉ́ʉda ˆvakasaamiwe na ɨsɨ ya ʉyenii ya Babéeli. ");
INSERT INTO lag_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lʉsaamo lwa Babéeli ˆlʉkalooke, Yekonía akamʉvyaala Searitiéeli, Searitiéeli akamʉvyaala Serubabéeli, ");
INSERT INTO lag_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabéeli akamʉvyaala Abiúudi, Abiúudi akamʉvyaala Eliakíimu, Eliakíimu akamʉvyaala Asóori, ");
INSERT INTO lag_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asóori akamʉvyaala Sadóoki, Sadóoki akamʉvyaala Akíimu, Akíimu akamʉvyaala Eliúudi, ");
INSERT INTO lag_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúudi akamʉvyaala Elieséeri, Elieséeri akamʉvyaala Matáani, Matáani akamʉvyaala Yaakúupu, ");
INSERT INTO lag_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaakúupu akamʉvyaala Yooséefu, mʉlʉme wa Maríia. Maríia akamʉvyaala Yéesu ˆaánɨrɨrwaa Masía. ");
INSERT INTO lag_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jeyyo, kʉjáa kwatɨɨte mbyaala ikimi na ine (14) fuma Aburaháamu fʉʉrʉ mʉtemi Daúdi. Kei, kʉjáa kwatɨɨte mbyaala ikimi na ine fuma mʉtemi Daúdi, fʉʉrʉ lʉsaamo lwa Viisiraéeli kʉtwaalwa na ɨsɨ ya ʉyenii ya Babéeli. Na mbyaala ikimi na ine fuma lʉsaamo lwa Viisiraéeli kʉtwaalwa na ɨsɨ ya ʉyenii ya Babéeli, fʉʉrʉ kʉvyaalwa kwa Masía. ");
INSERT INTO lag_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iji noo mbuwo ja kʉvyaalwa kwa Yéesu Kirisitʉ. Maríia íyo waala Yéesu ajáa atʉmɨrwa nɨ Yooséefu. Maa kaa, mpɨɨndɨ ˆvajáa vakaarɨ sɨ vanalʉmana ja muki na mʉlʉme, Maríia akava mawʉlʉ maruto kwa njɨra ya Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yooséefu mʉlʉme waachwe baa neembe ajáa nɨ mʉʉntʉ mʉwoloki, sɨ asaakáa kʉmʉkwaatya soni Maríia mbere ja vaantʉ tʉkʉ, akalamʉla kʉmʉreka Maríia kimbiso. ");
INSERT INTO lag_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mpɨɨndɨ ˆajáa akaarɨ yookiiririkana ɨrɨ isáare, murimʉ mʉʉja wa Ijʉva ʉkamʉfʉmɨra tulwii, maa ʉkamʉsea, “Yooséefu, mwaana wa Daúdi, koofa kʉmʉsʉmʉla Maríia ave muki waako tʉkʉ, sa uruto ˆatɨɨte nɨ kwa lʉvɨro lwa Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kiichʉngʉla arɨ mwaana mʉlʉme, na mʉkemera ʉrɨ irina raachwe Yéesu, sa yeeye noo ˆarɨ valamurirya vaantʉ vaachwe fuma uvii waavo.” ");
INSERT INTO lag_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aya yoosi yafʉ́mɨɨre, sa masáare Ijʉva ˆalʉʉsa kwa njɨra ya mʉláali na mʉtwe waachwe yakiimane, ");
INSERT INTO lag_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Laanga, mʉnjalʉ sʉmʉla arɨ ɨnda, yeeye vyaala arɨ mwaana mʉlʉme, novo mwaanɨrɨra varɨ irina raachwe Emanʉéeli,” noo kʉsea, “Mʉlʉʉngʉ nɨ na suusu arɨ.” ");
INSERT INTO lag_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yooséefu ˆakiinʉke fuma tulwii, akabweeyya ja viintʉ murimʉ mʉʉja wa Ijʉva ˆʉjáa ʉmʉwyɨ́ɨrɨɨre. Aho, akamʉsʉmʉla Maríia akava muki waachwe. ");
INSERT INTO lag_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Maa kaa, Yooséefu sɨ amʉseeserera Maríia tʉkʉ, fʉʉrʉ akiichʉngʉla mwaana wa kɨɨntʉ kɨlʉme. Yooséefu akamʉkemera irina raachwe Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yéesu ˆakavyaalwe múujii wa Betelehéemu ˆʉrɨ ɨsɨ ya Yudéea, mpɨɨndɨ ijo Heróode Mʉkʉ́ʉ́lʉ noo ajáa mʉtemi. Haaha vamanyi va nyényeeri fuma itʉʉmba vakʉʉja na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Vuuryáa voosea, “Hai arɨ ʉra ˆavyɨ́ɨrwe arɨ kʉva Mʉtemi wa Vayahúudi? Suusu twɨɨyona nyényeeri yaachwe yatʉla fuma itʉʉmba, naasu tuújire noo mwiinamɨra.” ");
INSERT INTO lag_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mʉtemi Heróode ˆakateere ayo masáare, yakaanda muturikirya, hamwɨ na vaantʉ voosi va Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Akavaanɨrɨra vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro, maa akavuurya, “Masía nɨ hai ˆarɨ vyaarɨrwa?” ");
INSERT INTO lag_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Voovo vakamʉsea, “Vyaarɨrwa arɨ múujii wa Betelehéemu ˆʉrɨ ɨsɨ ya Yudéea. Jeyyo noo ˆvyeene mʉláali na mʉtwe wa Ijʉva aandɨka, ");
INSERT INTO lag_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ee Betelehéemu ˆʉrɨ ɨsɨ ya Yʉ́ʉda, weewe sɨ ʉrɨ mudúúdi tʉkʉ, kati ya míiji ˆɨmányirwe ya Yudéea. Sa kufuma kwaako fʉmɨra arɨ mʉlongooli, ʉhʉ valongoola arɨ vaantʉ vaanɨ Viisiraéeli.’” ");
INSERT INTO lag_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aho, Heróode akavaanɨrɨra vara vamanyi va nyényeeri na kijiraawii, ʉko akavuurya mpɨɨndɨ mpɨɨndɨ ˆvɨɨyona ɨra nyényeeri. ");
INSERT INTO lag_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hara, akavatʉma vadome na Betelehéemu kʉnʉ yoovasea, “Tamanyi mukuurikirirye neeja masáare ya ʉwo mwaana, na ˆmʉrɨ moona, ndeteri mʉlomo chaangʉ sa naanɨ nkamwiinamɨre.” ");
INSERT INTO lag_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Vara vamanyi va nyényeeri ˆvakahʉmʉle mʉteerera mʉtemi Heróode, maa vakiinʉka. Na laanga, vakɨɨyona kei nyényeeri ɨʼɨra ˆvoona yootʉla itʉʉmba, ɨkava yoovalongorera novo vakiituuba fʉʉrʉ ɨkɨɨma mweeri ya haantʉ ˆajáa mwaana. ");
INSERT INTO lag_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ˆVakɨɨyone ɨra nyényeeri, vakavyeenda maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Vakɨɨngɨra na nyuumbii, vakamoona mwaana arɨ na Maríia íyo waavo, vakachwaama, maa vakamwiinamɨra. Hara, vakachʉngʉla máari jaavo ja kɨkomi ja mberii, vakamʉheera vilʉngʉlʉngʉ vya saháabu, ʉbáani na manemáane. ");
INSERT INTO lag_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mʉlʉʉngʉ akavakaanʼya tulwii, karɨ vahɨndʉke na kwa Heróode tʉkʉ. Jeyyo, vakahɨndʉka na meevo, na vajáa vatweera na njɨra yɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Vamanyi va nyényeeri ˆvakiinʉke na meevo, murimʉ mʉʉja wa Ijʉva ʉkamʉfʉmɨra Yooséefu tulwii, maa ʉkamʉsea, “Inʉka, mʉsʉmʉle mwaana na íyo waavo, ʉtɨɨje novo na Mísiri. Ikali ʉko fʉʉrʉ nɨvawyɨɨre, sa Heróode yoomʉsaakɨra mwaana sa amʉʉlae.” ");
INSERT INTO lag_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jeyyo, nuuchikʉ Yooséefu akiinʉka, akamʉsʉmʉla mwaana na íyo waavo, akakwaata njɨra na Mísiri. ");
INSERT INTO lag_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akiikala Mísiri fʉʉrʉ mʉtemi Heróode akawulala. Jeyyo, isáare ra Ijʉva ko tweera mʉláali na mʉtwe waachwe rɨkakiimana, “Namwaanɨrɨra mwaana waanɨ fuma Mísiri.” ");
INSERT INTO lag_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heróode ˆakataange akóovɨɨrwe nɨ vara vamanyi va nyényeeri, maa akakalala maatʉkʉ vii. Aho, akavatʉma vaantʉ vavʉʉlae vasinga voosi vʉʉ va kɨɨntʉ kɨlʉme ˆvarɨ na myaaka ɨvɨrɨ kʉhɨndʉka na nyuma aho múujii wa Betelehéemu, na maturii yoosi ˆyarɨɨngɨrɨra ʉwo múuji. Abweeyya jeyyo, ja ˆvyeene ajáa awyɨɨrwa jira mpɨɨndɨ nɨ vara vamanyi va nyényeeri. ");
INSERT INTO lag_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jeyyo, isáare ˆralʉʉswa nɨ Yeremía mʉláali na mʉtwe rɨkakiimana, ");
INSERT INTO lag_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sawúti yatéerekire fuma Ráama, Kɨrɨro na kʉrɨra no myaa kʉkʉʉlʉ, Rahéeli yoovarɨrɨra vaana vaachwe, baa sɨ yoosaaka tuuriwa mʉtɨma tʉkʉ, sa voosi vakwíire.” ");
INSERT INTO lag_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heróode ˆakawulale, murimʉ mʉʉja wa Ijʉva ʉkamʉfʉmɨra Yooséefu tulwii ʉko Mísiri, ");
INSERT INTO lag_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ʉkamʉsea, “Inʉka, mʉsʉmʉle mwaana na íyo waavo, ʉhɨndʉke na ɨsɨ ya Isiraéeli, sa vara ˆvasaakáa nkaasʉ ya mwaana vaakwya.” ");
INSERT INTO lag_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yooséefu akiinʉka, akamʉsʉmʉla mwaana na íyo waavo, maa vakahɨndʉka na ɨsɨ ya Isiraéeli. ");
INSERT INTO lag_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Maa kaa, Yooséefu ˆakateere Arikeláo mwaana wa Heróode noo avɨ́ɨre mʉtemi wa Yudéea haantʉ ha taáta waavo, Yooséefu akoofa doma na ʉko. Ne ˆakakaaniwe kei tulwii, akiinʉka, maa akadoma na ɨsɨ ya Galiláaya. ");
INSERT INTO lag_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kʉra, akɨɨta kiikala múujii ˆʉséwaa Nasaréeti. Jeyyo isáare ˆralʉʉswa nɨ valáali na mʉtwe rɨkakiimana, “Kaanɨrɨrwa arɨ Mʉnasaréeti.” ");
INSERT INTO lag_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sikʉ ˆjiri foo ˆjikalooke, Yooháani Mʉbatisáaji afʉmɨra ɨsɨ ya ibaláángwii ra Yudéea, yoovariyʉla, yoosea, ");
INSERT INTO lag_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Valanduki fuma uvii waanyu, Ʉtemi wa Kurumwii waséngerɨɨre.” ");
INSERT INTO lag_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ʉhʉ Yooháani noo ˆalʉʉswa nɨ Isáaya mʉláali na mʉtwe, yoosea, “Mʉʉntʉ yookaanɨrɨra vikʉlʉkʉʉlʉ ɨsɨ ya ibaláángwii, ‘Imyi neeja njɨra sa Ijʉva, wololi njɨra ˆarɨ tweera.’ ” ");
INSERT INTO lag_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yooháani iivɨkɨráa ɨngo ˆyachumwa kwa mabaáhɨra ya ngamɨ́a na iimʉtɨɨráa lʉkova. Kɨɨntʉ ˆarijáa nɨ nkʉʉmbɨ na hʉʉkɨ wa isekii. ");
INSERT INTO lag_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vaantʉ fuma múujii wa Yerusaléemu, ɨsɨ yoosi ya Yudéea na ɨsɨ joosi ˆjiri mbarɨmbarɨ ya lʉʉjɨ lwa Yorodáani, vʉʉjáa na kwa Yooháani. ");
INSERT INTO lag_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yeeye avabatisáa aho luujii lwa Yorodáani, kʉnʉ voolʉʉsa ʉvɨ waavo. ");
INSERT INTO lag_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ˆAkoone Mafarisáayo na Masadukáayo ˆvarɨ foo vookʉʉja na kwaachwe noo batisiwa, ajáa avasea, “Nyuunyu mbyaala ya nyororooda! Nɨ ani ˆavalúmire kutu mʉtɨɨje nkalari ya Mʉlʉʉngʉ ˆyookʉʉja? ");
INSERT INTO lag_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Haaha vyaali ndɨɨwa njija ˆjiri koonekya kɨkomi mwaválandukire fuma uvii waanyu. ");
INSERT INTO lag_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Reki kwiiririkana mitimii yaanyu, ‘Aburaháamu nɨ taáta wiitʉ!’ Nɨ kʉvawyɨɨra niise, Mʉlʉʉngʉ ifaanaa avalandʉle mawye aya yave vaana va Aburaháamu! ");
INSERT INTO lag_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mʉlʉʉngʉ ahʉ́mwɨɨre vɨɨka chaarya chaachwe neeja miririi ya mɨtɨ. Koonɨ mʉtɨ sɨ wootʉʉnga ndɨɨwa ˆjabooha, temwa ʉrɨ, ʉfweitɨrwe na iviivii. ");
INSERT INTO lag_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nɨɨnɨ noovabatisa na maaji, koonekya mwaválandukire fuma uvii waanyu. Maa kaa, amwaarɨ yookʉʉja nyuma yaanɨ ˆarɨ na ngururu kʉlookya nɨɨnɨ, nɨɨnɨ nsiina wʉʉja baa wo tʉmama mʉrɨmo wa mʉtʉ́mwa wo reherya nkova ja mirunkumo yaachwe tʉkʉ. Yeeye vabatisa arɨ na Mʉtɨma Mʉʉja na kwa mooto. ");
INSERT INTO lag_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yeeye akwáatɨrɨɨre saama yaachwe yo keerera mɨkonwii yaachwe. Fyaahɨra arɨ neeja lʉʉha lwaachwe. Jiinga arɨ ngáano ɨɨvɨke kyoomii, maa kaa, mukúúnku kʉʉchɨmɨka arɨ na mooto sɨ ˆurímaa.” ");
INSERT INTO lag_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aho, Yéesu akatamanya fuma Galiláaya fʉʉrʉ luujii lwa Yorodáani sa akabatisiwe nɨ Yooháani. ");
INSERT INTO lag_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Maa kaa, Yooháani ayeráa mʉkɨtɨra yoosea, “Nɨɨnɨ noo wo kʉʉja mbatisiwe nɨ weewe. Haaha weewe joolɨ wookʉʉja na kʉrɨ nɨɨnɨ?” ");
INSERT INTO lag_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Maa kaa, Yéesu akamʉsea, “Aaɨ, ruma haaha vive jei, sa jei noo ˆvyeene vyasaakwa tukiimikirirye ʉwoloki woosi.” Aho, Yooháani akaruma. ");
INSERT INTO lag_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yéesu ˆakahʉmʉle batisiwa vii, akafuma luujii. Koonka kurumu kʉkaatʉka dwee, aho, akamoona Mʉtɨma Mʉʉja yookiima mweeri yaachwe ja nkúnde na akamʉtʉʉrɨra. ");
INSERT INTO lag_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aho, maa sawúti fuma kurumwii ɨkasea, “Ʉhʉ nɨ Mwaana waanɨ ˆnamweenda, neeriwa mʉtɨma nɨ yeeye mʉnʉmʉʉnʉ.” ");
INSERT INTO lag_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aho, Mʉtɨma Mʉʉja ʉkamʉlongoola Yéesu fʉʉrʉ ɨsɨ ya ibaláángwii sa ayerwe nɨ Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ. ");
INSERT INTO lag_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yéesu ˆakiirekye kurya chɨrɨrɨ chobu kwa sikʉ makumi yanɨ (40), akoona njala. ");
INSERT INTO lag_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aho, Irimʉ rɨkʉʉja na kʉrɨ Yéesu, maa rɨkamʉsea, “Koonɨ ʉrɨ Mwaana wa Mʉlʉʉngʉ, lairirya aya mawye yave mʉkáate.” ");
INSERT INTO lag_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yéesu akʉʉsea murimʉ mʉvɨ, “Masáare ˆYarɨ Mpeho yalʉʉsa jei, ‘Mʉʉntʉ sɨ arɨ kʉva nkaasʉ kwa vyóorya vii tʉkʉ, maa kaa, ko tuuba kɨra isáare rifúmaa kwa Mʉlʉʉngʉ.’” ");
INSERT INTO lag_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aho, Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨkamʉsʉmʉla Yéesu fʉʉrʉ múujii mʉʉja wa Yerusaléemu. Rɨkamʉvɨɨka Yéesu ncholwiinchoolwii ya mʉnáara wa Kaaya Njija ya Ijʉva, ");
INSERT INTO lag_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","maa rɨkamʉsea, “Koonɨ ʉrɨ Mwaana wa Mʉlʉʉngʉ, ifweitɨre na ɨsɨ. Sa vyaandɨkwa jei, ‘Mʉlʉʉngʉ tʉma arɨ mirimʉ yaachwe miija ɨkʉlamurirye, yooyo kʉkwaatɨrɨra ɨrɨ mɨkonwii yaavo, sa karɨ ijeo raako jɨ riikunguvale iwyii tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yéesu akarɨsea, “Kei vyaandɨkwa, ‘Karɨ ʉmʉyéraa Ijʉva Mʉlʉʉngʉ waako tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aho, Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨkamʉsʉmʉla Yéesu fʉʉrʉ ncholwii ya lʉʉlʉ lʉlɨɨhɨlɨɨhɨ. Rɨkamoonekya ɨsɨ joosi ja weerʉ na nkongojima jaavo. ");
INSERT INTO lag_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Rɨkamʉsea, “Koonɨ ʉchwáamire mbere yaanɨ na wuunyinamɨɨre, kʉkʉheera ndɨrɨ ivi vyoosi.” ");
INSERT INTO lag_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aho, Yéesu akarɨsea, “Isunke kʉrɨ nɨɨnɨ Irimʉ! Sa vyaandɨkwa jei, ‘Mwiinamɨre Ijʉva Mʉlʉʉngʉ waako vii, na ʉmʉtʉmamɨre yeemweene vii.’ ” ");
INSERT INTO lag_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aho, Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨkamʉreka Yéesu, mirimʉ miija ɨkʉʉja noo mʉtʉmamɨra. ");
INSERT INTO lag_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Haaha Yéesu ˆakateere Yooháani Mʉbatisáaji ayéekɨɨrwe mʉnyololwii, akiinʉka aho, maa akadoma na Galiláaya. ");
INSERT INTO lag_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mpɨɨndɨ ˆajáa Galiláaya, akiinʉka fuma múuji wa Nasaréeti akɨɨta kiikala múujii wa Kaperenáumu ˆʉrɨ mbarɨmbarɨ ya iriva ra Galiláaya, kʉrɨ ɨsɨ ya Sabulóoni na Nafutáali. ");
INSERT INTO lag_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jeyyo, noo ˆvyeene akiimikirirya isáare ˆralʉʉswa nɨ Isáaya mʉláali na mʉtwe, ");
INSERT INTO lag_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ɨsɨ ya Sabulóoni na ɨsɨ ya Nafutáali, ˆɨrɨ njirii ˆyadoma na mayiyii, fɨrɨro ya lʉʉjɨ lwa Yorodáani, Galiláaya ya vaantʉ sɨ ˆvamʉmányire Mʉlʉʉngʉ, ");
INSERT INTO lag_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","vaantʉ vara ˆviíkalaa kilwiiryii, vɨɨ́ne kɨweerʉ kɨkʉʉlʉ. Na vaantʉ vara ˆviíkalaa ɨsɨ ya kilwiirya na murimírimii wa inkwya, itʉʉmba radáhire kwaavo.” ");
INSERT INTO lag_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kwaandɨra mpɨɨndɨ ijo, Yéesu ajáa aanda variyʉla yoosea, “Valanduki fuma uvii waanyu, Ʉtemi wa Kurumwii waséngerɨɨre!” ");
INSERT INTO lag_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mpɨɨndɨ Yéesu ˆayeendáa mbarɨmbarɨ ya iriva ra Galiláaya, ajáa avoona vavúuvi vavɨrɨ. Ʉmwɨ noo Simóoni ˆaséwaa Peéteri, na wɨɨngɨ noo mwaanaavo ˆasewáa Anderéa. Voovo vawʉmɨráa njwaavu na irivii. ");
INSERT INTO lag_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aho, Yéesu akavasea, “Ntuubi, na vabweeyya ndɨrɨ mʉve vavúuvi va vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hahara, vakareka njwaavu jaavo, vakamutuuba. ");
INSERT INTO lag_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ˆAkadome na mbere kiduudi, akoona vaantʉ vɨɨngɨ vavɨrɨ vala Yaakúupu na Yooháani mwaanaavo, vaana va mʉʉntʉ ʉmwɨ ˆaséwaa Sebedáayo. Voovo vajáa hamwɨ na taáta waavo mashúwii voolʉkanʼya njwaavu jaavo. Yéesu akavaanɨrɨra, ");
INSERT INTO lag_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","hahara, vakɨɨreka ɨra mashʉ́wa na taáta waavo, maa vakamutuuba Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yéesu arɨɨngɨrɨráa ɨsɨ yoosi ya Galiláaya, kʉnʉ yookiindya no variyʉla Masáare Maaja ya Ʉtemi masinagóogii yaavo. Kei, avahoryáa vaantʉ ndwáala jaavo ˆjiísimiresimire. ");
INSERT INTO lag_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Masáare yaachwe yakeenera ɨsɨ yoosi ya Síria. Vaantʉ vandoomʉretera valwɨ́ɨrɨ voosi ˆviísimiresimire. Kʉrɨ avo vajáa vamwaarɨ ˆvarɨ na makuundi ˆyahʉʉmba, vara ˆvajáa na mirimʉ mɨvɨ, vara ˆvajáa na kiinkwiisha na vara ˆvajáa vaakwya iyandiyandi. Yéesu akavahorya avo voosi. ");
INSERT INTO lag_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mayɨɨmbɨ ya mpuka nkʉʉlʉ ja vaantʉ vamutuubáa fuma ɨsɨ ya Galiláaya, Dekapóoli, Yerusaléemu, Yudéea na fuma nyambʉko ya lʉʉjɨ lwa Yorodáani. ");
INSERT INTO lag_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yéesu ˆakoone jira mpuka ja vaantʉ, akaambʉka na kiduundii, maa akiikala. Vapooji vaachwe vakamʉdomera, ");
INSERT INTO lag_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ne akaanda vakiindya yoosea: ");
INSERT INTO lag_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Vatalariwa vara ˆvarɨ vakɨva mitimii, sa Ʉtemi wa Kurumwii nɨ waavo. ");
INSERT INTO lag_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Vatalariwa vara ˆvarɨ na makɨva, sa Mʉlʉʉngʉ vatuurya arɨ mɨtɨma. ");
INSERT INTO lag_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Vatalariwa vara mɨtɨma yaavo ˆyahola, voovo heewa varɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Vatalariwa vara ˆvakalʉkwa na ˆvarɨ na njala ya ʉwoloki, avo kiikutiwa varɨ nɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vatalariwa vara ˆvaláangaa na riiso ra wʉʉja, voovo laangwa varɨ na riiso ra wʉʉja. ");
INSERT INTO lag_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Vatalariwa vara ˆveerya mɨtɨma, avo moona varɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Vatalariwa vara ˆvalʉ́manʼyaa vavɨ viikalanʼye na wʉʉja, avo kaanɨrɨrwa varɨ vaana va Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Vatalariwa vara ˆvatúrikiriwaa sa viíkalaa mwiikalo wa ʉwoloki, sa Ʉtemi wa Kurumwii nɨ waavo. ");
INSERT INTO lag_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mwatalariwa nyuunyu koonɨ mootʉkɨrwa, mooturikiriwa na mookoovereriwa mavɨ ˆyiísimiresimire sa nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Eryi mɨtɨma na vai siriri, sa kʉnáálo yaanyu nɨ nkʉ́ʉ́lʉ kurumwii. Nɨ kwa njɨra yɨɨyo vavaturikirya valáali na mʉtwe va aho mbere. ");
INSERT INTO lag_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nyuunyu mʉrɨ sangása ya weerʉ. Maa kaa, sangása koonɨ yasúukire, nɨ che ɨrɨ vɨkɨrwa sa mwerere ʉhɨndʉkɨre kei? Ɨyo sɨ yabooha kwa kɨɨntʉ chochoosi tʉkʉ, ɨyo nɨ yo fweita vii na weerwii ɨlwaatiririwe nɨ vaantʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nyuunyu nɨ kɨweerʉ cha weerʉ. Múuji ˆwajeengwa luulwii sɨ wiívisaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Baa kei, vaantʉ sɨ vakórereryaa kɨmʉrɨ, maa vakakɨkʉnɨkɨrɨra na nyiingʉ ya kweenga tʉkʉ, kɨrɨ vyoova jeyyo, vakɨ́vɨɨkaa kyaángwii, sa kɨmʉrɨkɨre voosi ˆvarɨ nyuumbii. ");
INSERT INTO lag_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Viivyo baa nyuunyu, kɨweerʉ chaanyu choosaakwa kɨmʉrɨke, vaantʉ voone nteendo jaanyu njija, aho, vamʉbweeyyirye nkongojima Taáta waanyu. Yeeye arɨ kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Karɨ mwiisee nʉʉja joo seyya Miiro au ʉvariyuli wa valáali na mʉtwe tʉkʉ. Sɨ nʉʉja joo seyya tʉkʉ, maa kaa, nʉʉja joo vikiimikirirya. ");
INSERT INTO lag_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kɨmaarɨ noovawyɨɨra, mpaka kurumu na weerʉ jilooke, kusiina baa lʉtalo lʉmwɨ luduudi au katóonti ka lʉtalo lwa Miiro lʉrɨ seyyiwa tʉkʉ, fʉʉrʉ aya yoosi yakiimane. ");
INSERT INTO lag_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jeyyo, mʉʉntʉ yoyoosi ˆarɨ wuna ʉmwɨ wa ʉlairiri muduudi wa ndairiri iji, na avakiindye vaantʉ vɨɨngɨ vabweeyye jeyyo, ʉwo kaanɨrɨrwa arɨ mudúúdi Ʉtemii wa Kurumwii. Maa kaa, yoyoosi ˆatʉ́mamaa na ˆakíindyaa ndairiri iji, ʉwo kaanɨrɨrwa arɨ mʉkʉ́ʉ́lʉ Ʉtemii wa Kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sa jeyyo, nɨ kʉvawyɨɨra niise, ʉwoloki waanyu koonɨ sɨ walóokeriirye wa Mafarisáayo na wa vakiindya va Miiro, kɨkomi sɨ mʉrɨ kɨɨngɨra Ʉtemii wa Kurumwii vii kaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mwateera vambere vasewa jei, ‘Karɨ wʉʉ́laa tʉkʉ,’ na kei mwateera, ‘mʉʉntʉ yoyoosi ˆarɨ kʉʉlaa heewa arɨ irya.’ ");
INSERT INTO lag_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Maa kaa, nɨɨnɨ nɨ kʉvawyɨɨra niise, mʉʉntʉ yoyoosi ˆarɨ mʉkalarɨra mwaanaavo heewa arɨ irya. Na mʉʉntʉ yoyoosi ˆarɨ mʉtʉkɨra mwaanaavo kituki, ʉwo kɨɨma arɨ mbere ya Balása Nkʉʉlʉ ya Vayahúudi. Na mʉʉntʉ yoyoosi ˆarɨ mʉtʉkɨra mwaanaavo amʉsee ‘Mʉkoókoyo,’ tamanya arɨ na mootwii wa Jehénamu. ");
INSERT INTO lag_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Haaha koonɨ woodoma noo toola mpóryo yaako masabáahwii, maa ʉkʉmbʉkɨre wiitoola na mwaanaanyu, ");
INSERT INTO lag_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","reka ɨyo mpóryo yaako haaho masabáahwii, hɨndʉka ukiiteerwe na mwaanaanyu, maa de jɨ ʉtoole ɨyo mpóryo yaako. ");
INSERT INTO lag_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Koonɨ mʉʉntʉ yookʉtwaala na balásii, mʉloombe iivae na mpʉʉlo chaangʉ mpɨɨndɨ ˆmʉkaarɨ njirii. Koonɨ sɨ jeyyo, ʉra ˆakusítakiirye kʉkʉtwaala arɨ na kwa mʉlamuli, na mʉlamuli ne kʉkwaatya arɨ kwa mʉlʉkalʉka akwiingirye na mʉnyololwii na ngururu. ");
INSERT INTO lag_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kɨmaarɨ nookuwyɨɨra, sɨ ʉrɨ fuma aho mʉnyololwii tʉkʉ, mpaka ʉrɨhe mpoocho yo marikirirya. ");
INSERT INTO lag_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mwateera yasewa, ‘Karɨ ʉyéendaa na muki wa mʉʉntʉ tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Maa kaa, nɨɨnɨ nɨ kʉvawyɨɨra niise, mʉʉntʉ ˆarɨ mʉlaanga mʉʉntʉ muki, maa amʉmererye matɨ, ʉwo kʉva arɨ ahʉ́mwɨɨre yeenda ne mutimii waachwe. ");
INSERT INTO lag_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Koonɨ riiso raako ra kʉlʉme rakʉháandire ʉtʉmame ʉvɨ, rɨnonkole, ʉrɨfweite na kʉlɨ. Nɨ pwee kwaako kʉsova kɨɨntʉ kɨmwɨ cha mʉvɨrɨ waako, kʉlookya mʉvɨrɨ waako woosi vʉʉ kʉfweitɨrwa na mootwii wa Jehénamu. ");
INSERT INTO lag_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kei koonɨ iyaanja raako ra kʉlʉme rakʉháandire ʉndoobweeyya ʉvɨ, rɨkere ʉrɨfweite na kʉlɨ. Nɨ pwee kʉsova kɨɨntʉ kɨmwɨ cha mʉvɨrɨ waako, kʉlookya mʉvɨrɨ waako woosi kʉfweitɨrwa na mootwii wa Jehénamu. ");
INSERT INTO lag_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mwateera yasewa, ‘Mʉʉntʉ yoyoosi ˆamusíitire muki waachwe, amʉheere taláka.’ ");
INSERT INTO lag_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Maa kaa, nɨɨnɨ nɨ kʉvawyɨɨra niise, mʉʉntʉ yoyoosi ˆarɨ musiita muki waachwe koonɨ sɨ sa kʉyeenda na mʉlʉme wa mʉʉntʉ, kʉva arɨ yoomʉbweeyya muki waachwe ave ja ayéendaa na mʉlʉme wa mʉʉntʉ. Na mʉʉntʉ ˆarɨ mʉloola ʉwo muki ˆasíitirwe nɨ mʉlʉme, kʉva arɨ yooyeenda na muki wa mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kei mwateera viintʉ vambere vawyɨɨrwa, ‘Karɨ uwúnaa kʉlaha kwaako tʉkʉ, maa kaa, kiimikirirya kʉlaha kwaako mbere ya Ijʉva.’ ");
INSERT INTO lag_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nɨɨnɨ nɨ kʉvawyɨɨra niise, kɨkomi karɨ mwiiláhaa tʉkʉ, baa kwa kurumu tʉkʉ, sa kurumu noo ichuumbi ra kɨtemi ra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Baa karɨ mwiiláhaa kwa weerʉ tʉkʉ, sa nɨ ibambari raachwe ro lwaatirya majeo yaachwe. Baa kei, karɨ mwiiláhaa kwa múuji wa Yerusaléemu tʉkʉ, sa noo múuji wa Mʉtemi Mʉkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Baa kei, karɨ mwiiláhaa kwa mɨtwe yaanyu tʉkʉ, sa sɨ mʉrɨ daha valandʉla lʉjwɨ́ɨrɨ baa lʉmwɨ vii lʉve lwiirʉ au lweerʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Koonɨ mʉséire, ‘Hɨɨ,’ ɨve ‘Hɨɨ’ kɨkomi, na koonɨ mʉséire, ‘Tʉkʉ,’ ɨve ‘Tʉkʉ’ kɨkomi. Chochoosi ˆkɨrɨ lookerera ayo, chafúmaa kwa Mʉvɨ. ");
INSERT INTO lag_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mwateera kei vyasewa, ‘Riiso kwa riiso na iyeo kwa iyeo.’ ");
INSERT INTO lag_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Maa kaa, nɨɨnɨ nɨ kʉvawyɨɨra niise, karɨ wiilóokereryaa na mʉʉntʉ mʉvɨ tʉkʉ. Koonɨ mʉʉntʉ akʉváire lʉsayya lwa kʉlʉme, mʉvarindʉrɨre na lwa kʉmooso. ");
INSERT INTO lag_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Koonɨ mʉʉntʉ akʉtwáarɨre na balásii sa asʉmʉle nkáancho yaako, mʉheere baa ikóoti raako. ");
INSERT INTO lag_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Koonɨ mʉʉntʉ akufíindirirye wiitɨɨke muriwa waachwe lʉyeendo lwa isaa rɨmwɨ, weewe itɨɨke lʉyeendo lwa masaa yavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mʉʉntʉ ˆyookʉloomba kɨɨntʉ, mʉheere. Koonɨ mʉʉntʉ yookʉkopa karɨ ʉmʉhéeraa moongo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kei mwateera vyasewa, ‘Mweende mwiiwaako,’ na kei, ‘Mʉsʉʉle mʉvɨ waako.’ ");
INSERT INTO lag_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Maa kaa, nɨɨnɨ nɨ kʉvawyɨɨra niise, veendi vavɨ vaanyu na mʉndoovaloombera vara ˆvavatúrikiryaa, ");
INSERT INTO lag_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","sa mwiifwaane na Taáta waanyu wa kurumwii. Sa yeeye avamʉ́rɨkɨraa mwaasʉ waachwe vavɨ na vaaja, baa kei avahéeraa mbula vawoloki na vara sɨ ˆvarɨ vawoloki. ");
INSERT INTO lag_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ha koonɨ mooveenda vara ˆvaveenda vii nyuunyu, nɨ kʉnáálo che mʉrɨ turya? Eri, baa vasaankanʼyi kóodi sɨ vabwéeyyaa jeyyo tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Koonɨ moovaluumbya vaanaanyu vii, nɨ kɨɨntʉ che ˆmoobweeyya ˆkiísimire na vɨɨngɨ? Amwɨ baa vaantʉ sɨ ˆvamʉmányire Mʉlʉʉngʉ vabwéeyyaa jeyyo. ");
INSERT INTO lag_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sa jeyyo, mʉve vawoloki ja Taáta waanyu wa kurumwii viintʉ ˆarɨ mʉwoloki. ");
INSERT INTO lag_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mʉlaange neeja, karɨ mʉbwéeyyaa ʉwoloki waanyu mbere ja vaantʉ sa moonwe vii nɨ voovo tʉkʉ. Sa koonɨ mʉbwéeyyiirye jeyyo, sɨ mʉrɨ turya kʉnáálo fuma kwa Taáta waanyu wa kurumwii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Weewe mpɨɨndɨ ˆwoomwaambirirya mʉkɨva, karɨ wiilʉ́ʉsaa ja vakweembi viintʉ ˆvabwéeyyaa masinagóogii na njirii tʉkʉ. Voovo vabwéeyyaa jeyyo sa vabweeyyiriwe nkongojima nɨ vaantʉ. Kɨmaarɨ noovawyɨɨra, avo vahʉmʉla turya kʉnáálo yaavo. ");
INSERT INTO lag_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Maa kaa, weewe mpɨɨndɨ ˆwoomwaambirirya mʉkɨva, bweeyya kwa kimbiso, karɨ baa mʉkono waako wa kʉmooso ʉtaange kɨra mʉkono waako wa kʉlʉme wootʉmama tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Toola nyambirirya yaako kwa kimbiso, ne Taáta waanyu ˆoónaa yara ˆyiivisa, kʉkʉtalarya arɨ. ");
INSERT INTO lag_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kei mpɨɨndɨ ˆmoomʉloomba Mʉlʉʉngʉ, karɨ mʉbwéeyyaa ja vakweembi tʉkʉ. Voovo veenda mʉloomba Mʉlʉʉngʉ kʉnʉ viímire masinagóogii na haantʉ njɨra ˆjalʉmanɨra, sa voonwe nɨ vaantʉ. Kɨmaarɨ noovawyɨɨra, avo vahʉmʉla turya kʉnáálo yaavo. ");
INSERT INTO lag_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Maa kaa, weewe koonɨ wooloomba, ɨngɨra na mberii, chuunga mʉryaango, maa de ʉlʉʉsɨke na Taáta waanyu sɨ ˆoónekanaa. Ʉko, Taáta waanyu ˆoónaa yara ˆyiivisa, kʉkʉtalarya arɨ. ");
INSERT INTO lag_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mpɨɨndɨ ˆmoomʉloomba Mʉlʉʉngʉ, karɨ mʉlʉ́ʉsaa masáare ˆyarɨ foo ja vara sɨ ˆvamʉmányire Mʉlʉʉngʉ tʉkʉ. Voovo viiséaa Mʉlʉʉngʉ vateera arɨ sa masáare yaavo ˆyarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Karɨ mʉve ja voovo tʉkʉ. Nyuunyu Taáta waanyu amányire yara ˆmoosaaka baa viintʉ ˆmʉkaarɨ kʉmʉloomba. ");
INSERT INTO lag_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Haaha, ja jei noo ˆvyeene mwasaakwa mʉndoomʉloomba Mʉlʉʉngʉ, ‘Taáta wiitʉ wa kurumwii, Irina raako rɨbweeyyiriwe nkongojima. ");
INSERT INTO lag_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ʉtemi waako wʉʉje. ˆCheene woosaaka kɨtʉmamwe aha weerwii, ja ˆvyeene kɨtʉ́mamwaa ʉko kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ʉtʉheere chóorya chiitʉ, cha kɨra siikʉ. ");
INSERT INTO lag_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ʉtʉsee ʉvɨ wiitʉ wasírire, ja ˆvyeene suusu tavaséaa vara ˆvatʉhonerya, ʉvɨ waavo wasírire. ");
INSERT INTO lag_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kʉtʉrekera twɨɨngɨre na mʉtehwii tʉkʉ, maa kaa, ʉtʉlamurirye na ʉra Mʉvɨ.’ Sa Ʉtemi, ngururu na nkongojima nɨ vyaako, kwa sikʉ ˆjisiina ʉhero. Kɨkomi. ");
INSERT INTO lag_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Koonɨ moovasea viivaanyu ʉvɨ waavo wasírire mpɨɨndɨ ˆvahoniirye kwaanyu, baa Taáta waanyu wa kurumwii vasea arɨ ʉvɨ waanyu wasírire. ");
INSERT INTO lag_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Maa kaa, koonɨ sɨ moovasea viivaanyu ʉvɨ waavo wasírire, baa Taáta waanyu wa kurumwii sɨ arɨ vasea nyuunyu ʉvɨ waanyu wasírire tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mpɨɨndɨ ˆmookiirekya kurya, karɨ mʉfótaa visho vyaanyu ja viintʉ vakweembi ˆvabwéeyyaa tʉkʉ. Voovo vafótaa visho vyaavo sa voonwe nɨ vaantʉ viirékiirye kurya. Kɨmaarɨ noovawyɨɨra, avo vahʉmʉla turya kʉnáálo yaavo. ");
INSERT INTO lag_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Maa kaa, koonɨ weewe wiirékiirye kurya, ihake makuta mutwii na wooyye kisho, ");
INSERT INTO lag_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sa vaantʉ vadɨɨre taanga koonɨ wiirékiirye kurya. Kwiirekya kwaako kurya kʉtaangwe vii nɨ Taáta waanyu sɨ ˆoónekanaa. Na Taáta waanyu ˆoónaa yarɨ kimbiswii, kʉkʉtalarya arɨ. ");
INSERT INTO lag_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Karɨ mukúnguulaa máari ja kɨkomi ja mberii aha weerwii kʉʉntʉ mbuuvu na kúutu ˆjisáambʉlaa tʉkʉ. Baa kei, viívi vabókaa vakiiva. ");
INSERT INTO lag_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kunguuli máari ja kɨkomi ja mberii mʉvɨɨke kurumwii, kʉʉntʉ mbuuvu sɨ ˆjisáambʉlaa ɨngo na kúutu sɨ ˆisáambʉlaa chʉʉ́ma. Baa kei, viívi sɨ vabókaa viive. ");
INSERT INTO lag_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sa kʉʉntʉ máari jaako ja kɨkomi ja mberii ˆjiri, noo kʉʉntʉ mʉtɨma waako ˆʉrɨ veera. ");
INSERT INTO lag_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Riiso nɨ kɨmʉrɨ cha mʉvɨrɨ. Koonɨ riiso raako rɨrɨ nkaasʉ, mʉvɨrɨ waako woosi wavíjaa na kɨweerʉ. ");
INSERT INTO lag_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Maa kaa, koonɨ riiso raako rasaambʉka, mʉvɨrɨ waako woosi wavéeraa kilwiiryii. Koonɨ kɨkomi kɨweerʉ ˆkɨrɨ isii yaako nɨ kilwiirya, ɨkyo kilwiirya chatʉʉnɨka maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kusiina mʉtʉmami ˆadáhaa tʉmamɨra vasúngaati vavɨrɨ tʉkʉ. Sa mʉsʉʉla arɨ ʉmwɨ na amweende wɨɨngɨ, au mʉnyemya eende ʉmwɨ na kumuchwa eende matɨ wɨɨngɨ. Sɨ mʉrɨ daha kʉmʉtʉmamɨra Mʉlʉʉngʉ na máari tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Noo ˆchooreka noovawyɨɨra, reki koofa sa kʉva nkaasʉ kwaanyu, che mʉrɨ kurya, che mʉrɨ kʉnywa, au sa mɨvɨrɨ yaanyu, che mʉrɨ kiivɨkɨra tʉkʉ. Eri, nkaasʉ nɨ chóorya vii wʉʉ? Na mʉvɨrɨ sɨ kʉlookya ɨngo tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Laangi ndee ja kurumwii. Joojo sɨ jiháandaa tʉkʉ, sɨ jichwíjaa tʉkʉ, na jisiina madongʼa tʉkʉ. Baa neembe nɨ jeyyo, Taáta waanyu wa kurumwii ajiríishaa. Eri, nyuunyu sɨ mʉrɨ vakʉ́ʉ́lʉ miiswii yaachwe kʉlookya ndee tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nɨ ani kʉrɨ nyuunyu so manyɨka kwaachwe ifaanaa oongererye nkaasʉ yaachwe kwa sáa baa ɨmwɨ vii? ");
INSERT INTO lag_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sa che kwiitweetya sa ɨngo? Laangi, malʉva ya iwundii ˆvyeene yadeda. Yooyo sɨ yatʉ́mamaa tʉkʉ, baa kei, sɨ yachúmaa ɨngo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kɨmaarɨ kaa noovawyɨɨra, baa mʉtemi Solomóoni na nkongojima yaachwe yoosi, sɨ arwɨɨkwa vyabooha ja rɨmwɨ ra malʉva ayo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Haaha koonɨ Mʉlʉʉngʉ ayarwɨ́ɨkaa masaambɨ ya iwundii aya ˆyavíjaa isikʉ na lomʉtóondo yakafweitɨrwa na iviivii, sɨ arɨ varwɨɨka nyuunyu kʉlookya ayo tʉkʉ wʉʉ? Eri, sa che mumurúmaa kiduudi jei? ");
INSERT INTO lag_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sa jeyyo, reki kwiitweetya kʉnʉ moosea, ‘Che tʉrɨ kurya? Che tʉrɨ kʉnywa? Che tʉrɨ kiivɨkɨra?’ ");
INSERT INTO lag_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sa vaantʉ sɨ ˆvamʉmányire Mʉlʉʉngʉ noo viitwéetyaa sa viintʉ ivi vyoosi. Kwaanyu Taáta waanyu wa kurumwii amányire visaaka mwiise. ");
INSERT INTO lag_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Haaha, nyuunyu saakiri ta Ʉtemi na ʉwoloki waachwe na ayo yoosi koongereriwa mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sa jeyyo, reki kwiitweetya sa lomʉtóondo, sa lomʉtóondo kwiijʉʉwɨkɨra ɨrɨ yoongʼeene. Uturikiri wa isikʉ wakiimana. ");
INSERT INTO lag_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Karɨ mʉvalámʉrɨraa vɨɨngɨ tʉkʉ, sa nyuunyu mʉdɨɨre lamʉrɨrwa nɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sa ja ˆvyeene moovalamʉrɨra vɨɨngɨ, noo ˆvyeene baa nyuunyu mʉrɨ lamʉrɨrwa. Kei kipíimo ˆmupíimɨraa vɨɨngɨ, noo baa nyuunyu ˆmʉrɨ piimɨrwa. ");
INSERT INTO lag_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sa che woolaanga kajʉla ˆkarɨ riiswii ra mwaanaanyu, na ʉlɨ sɨ wookoona mpóngoola ˆɨrɨ riiswii raako? ");
INSERT INTO lag_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Joolɨ ʉrɨ daha mʉsea mwaanaanyu, ‘Mwanawiitʉ, tʉʉla nɨkʉseyye kajʉla riiswii raako,’ na kʉnʉ weewe ˆʉrɨ na mpóngoola riiswii raako? ");
INSERT INTO lag_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Weewe mʉkweembi! Seyya ta mpóngoola riiswii raako, aho, maa de ʉdahe koona neeja na ʉseyye kajʉla ˆkarɨ riiswii ra mwaanaanyu. ");
INSERT INTO lag_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Karɨ mʉhéeraa kúri viintʉ viija tʉkʉ, na karɨ mʉwʉ́mɨraa nkaamba lúulu jaanyu tʉkʉ. Sa koonɨ mʉbwéeyyiirye jeyyo, nkaamba jilwaata jiri na viiji vyaavo na kúri vavalandʉkɨra jiri jivangʼenyengʼenye. ");
INSERT INTO lag_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Loombi, naanyu heewa mʉrɨ, saakiri, naanyu turya mʉrɨ, luumbyi mʉryaangwii, naanyu yʉʉrɨrwa mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sa kɨra ˆalóombaa, ahéewaa, na ʉra ˆasáakɨraa, atúryaa, na ʉra ˆalúumbyaa mʉryaangwii, ayʉ́ʉrɨrwaa. ");
INSERT INTO lag_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nɨ ani kʉrɨ nyuunyu koonɨ mwaana waachwe amʉlóombire mʉkáate, ˆarɨ mʉheera iwye? ");
INSERT INTO lag_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au koonɨ mwaana amʉlóombire soompa, ˆarɨ mʉheera njoka? ");
INSERT INTO lag_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Koonɨ nyuunyu baa neembe mʉrɨ vavɨ, mʉmányire kʉvaheera vaana vaanyu viintʉ ˆvyabooha, eri, Taáta waanyu wa kurumwii sɨ arɨ bweeyya vyabooha kʉlookya ivyo ko vaheera viintʉ ˆvyabooha vara ˆvamʉlóombaa tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sa chochoosi ˆmoosaaka mʉtʉmamɨrwe nɨ vaantʉ, nyuunyu vatʉmamiri. Ɨyo noo Miiro na valáali na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ingiri na mʉryaango ˆwafinya. Sa njɨra nɨ yawarɨha na mʉryaango nɨ wawarɨha ˆvyatamanya na imalwii, na ˆvɨɨ́ngɨraa na ʉko nɨ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Maa kaa, njɨra ˆɨdómaa na nkaaswii yafafa, na mʉryaango wo kɨɨngɨrɨra na ʉko wafinya. Na vaantʉ ˆvatáangaa njɨra ɨyo nɨ vake. ");
INSERT INTO lag_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mʉlaange neeja valáali na mʉtwe va ʉloongo. Voovo vʉʉ́jaa na kwaanyu viivɨ́kɨɨre mɨmberʉ ya muundi, maa kaa, isii yaavo nɨ mbʉʉjɨ nkarɨ. ");
INSERT INTO lag_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Avo, vataanga mʉrɨ kwa nteendo jaavo. Eri, vaantʉ vatʉ́ʉndaa sabíibu mihuungii wʉʉ? Bakʉ vatʉ́ʉndaa saambu matʉʉnga mpichii wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Viivyo, mʉtɨ mʉʉja watʉ́ʉngaa ndɨɨwa njija na mʉtɨ mʉvɨ watʉ́ʉngaa ndɨɨwa mbɨ. ");
INSERT INTO lag_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mʉtɨ mʉʉja sɨ watʉ́ʉngaa ndɨɨwa mbɨ tʉkʉ, na mʉtɨ mʉvɨ sɨ watʉ́ʉngaa ndɨɨwa njija tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kɨra mʉtɨ sɨ ˆʉtʉ́ʉngaa ndɨɨwa njija, temwa ʉrɨ na fweitɨrwa ʉrɨ na iviivii. ");
INSERT INTO lag_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sa jeyyo, vataanga mʉrɨ kwa nteendo jaavo. ");
INSERT INTO lag_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sɨ kɨra mʉʉntʉ ˆaanyánɨrɨraa ‘Mʉkʉ́lʉ, Mʉkʉ́lʉ’ ˆarɨ kɨɨngɨra Ʉtemii wa Kurumwii tʉkʉ, maa kaa, nɨ ʉra vii ˆatʉ́mamaa ˆmeene Taáta waanɨ wa kurumwii asáakaa. ");
INSERT INTO lag_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sikʉ ya ʉlamu ˆvarɨ foo kʉʉnsea varɨ, ‘Mʉkʉ́lʉ, Mʉkʉ́lʉ, sɨ talʉʉsáa ʉláali na mʉtwe kwa irina raako tʉkʉ wʉʉ? Kei, sɨ kwa irina raako taseyyáa mirimʉ mɨvɨ na tabweeyyáa myuujíisa ˆɨrɨ foo tʉkʉ wʉʉ?’ ");
INSERT INTO lag_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aho, nɨɨnɨ vasea ndɨrɨ baa visa tʉkʉ, ‘Sɨ navamányire nyuunyu baa kiduudi vii tʉkʉ. Isunki mbere yaanɨ, nyuunyu ˆmuwúnaa miiro.’ ");
INSERT INTO lag_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Sa jeyyo, mʉʉntʉ yoyoosi ˆayatéeraa masáare yaanɨ no yakwaatya, iifwɨ́ɨne na mʉʉntʉ ˆarɨ na tooti, ˆmweene ajeenga nyuumba yaachwe mwaalaliwyii. ");
INSERT INTO lag_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mbula ˆɨkavae, maboote yakamema maaji mpaka yakamoola, ihúmbuuto na maaji vikʉʉja, vikakʉndʉla nyuumba, nyuumba baa sɨ yaawya tʉkʉ sa viintʉ mwaariryo waachwe ʉjáa wajeengwa mwaalaliwyii. ");
INSERT INTO lag_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na mʉʉntʉ yoyoosi ˆayatéeraa masáare yaanɨ baa yakwaatya tʉkʉ, ʉwo iifwɨ́ɨne na mʉhoho ˆmweene ajeenga nyuumba yaachwe isaárii. ");
INSERT INTO lag_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mbula ˆɨkavae, maboote yakamema maaji mpaka yakamoola, ihúmbuuto na maaji vikʉʉja, vikakʉndʉla nyuumba mpaka ɨkawya kacha.” ");
INSERT INTO lag_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yéesu ˆakahʉmʉle kʉlʉʉsa masáare aya, mpuka ya vaantʉ ɨkava yoohwaalariwa nɨ ʉvariyuli waachwe. ");
INSERT INTO lag_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yeeye akiindyáa ja mʉʉntʉ ˆarɨ na wiimiriri, na sɨ ja vakiindya vaavo va Miiro tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yéesu ˆakakiime fuma luulwii, mpuka nkʉʉlʉ ya vaantʉ ɨkamutuuba. ");
INSERT INTO lag_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mʉʉntʉ ʉmwɨ ajáa na ʉlóónda akamwiinamɨra yoosea, “Aaɨ, koonɨ woosaaka, ifaanaa ʉkaanjirʉla ndwáala yaanɨ.” ");
INSERT INTO lag_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yéesu akawolola mʉkono waachwe, akamʉsaasya, kʉnʉ yoosea, “Noosaaka, ujirʉlwe!” Hahara, ʉlóónda waachwe ʉkahola. ");
INSERT INTO lag_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aho, Yéesu akamʉsea, “Karɨ umuwyɨ́ɨraa mʉʉntʉ yoyoosi isáare ɨrɨ tʉkʉ, maa kaa, tamanya ukiiyonekye kwa mweeneɨsɨ wa Ijʉva, ʉtoole na mpóryo yo jirʉlwa, ja ˆvyeene Mʉ́sa alairirya, sa vataange kɨmaarɨ ʉhórire.” ");
INSERT INTO lag_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mpɨɨndɨ Yéesu ˆajáa ɨɨ́ngɨɨre múujii wa Kaperenáumu, mʉkʉ́ʉ́lʉ ʉmwɨ wa valwi nkoondo akʉʉja na kʉrɨ Yéesu, maa akiilomboola yoosea, ");
INSERT INTO lag_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ee Aaɨ, mʉtʉmami waanɨ nɨ mʉlwɨ́ɨrɨ, akwíire iyandiyandi, atɨɨte makuundi ˆyahʉʉmba maatʉkʉ vii.” ");
INSERT INTO lag_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yéesu akamʉsea, “Doma niise noomʉhorya.” ");
INSERT INTO lag_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Maa kaa, ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo akamʉsea Yéesu, “Ee Aaɨ, nɨɨnɨ sɨ navalwa nɨɨma neeja kʉkʉteengya na nyuumbii kwaanɨ tʉkʉ. Lʉʉsa isáare vii, na mʉtʉmami waanɨ hola arɨ. ");
INSERT INTO lag_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sa baa nɨɨnɨ nɨ mʉʉntʉ ˆnavɨɨkwa ɨsɨ ya wiimiriri, baa kei natɨɨte valwi nkoondo ɨsɨ yaanɨ. Koonɨ namʉséire ʉhʉ ‘Doma,’ adómaa na wɨɨngɨ ‘Ʉja,’ ʉʉ́jaa. Koonɨ namʉséire mʉtʉmami waanɨ ‘Bweeyya ɨkɨ,’ abwéeyyaa.” ");
INSERT INTO lag_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yéesu ˆakateere masáare ayo, akahwaalala, maa akɨɨsea ɨra mpuka ˆyamutuubáa, “Kɨmaarɨ noovawyɨɨra, sɨ nɨnoona kuruma ja ʉkʉ kwa mʉʉntʉ yoyoosi wa Isiraéeli tʉkʉ! ");
INSERT INTO lag_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nɨ kʉvawyɨɨra niise, vaantʉ ˆvarɨ foo kʉʉja varɨ fuma itʉʉmba na ʉsweero, na kiikala varɨ ngovii hamwɨ na Aburaháamu, Isaka na Yaakúupu kurya ngovi Ʉtemii wa Kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Maa kaa, vaana va Ʉtemi, fweitɨrwa varɨ na weerwii haantʉ ˆharɨ na kilwiirya, ʉko kʉva kʉrɨ na kɨrɨro no sha mayeo.” ");
INSERT INTO lag_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aho, Yéesu akamʉsea ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo, “Tamanya na kaayii, na vive kwaako, ja kuruma kwaako.” Mpɨɨndɨ ɨʼɨra, mʉtʉmami waachwe akahola. ");
INSERT INTO lag_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yéesu akatamanya na kaayii kwa Peéteri, ˆakafike, akamʉshaana mʉkwɨ wa Peéteri ajáa nchiirii aváirwe nɨ ndwáala. ");
INSERT INTO lag_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aho, akamʉsaasya mʉkono, na hahara akahola ɨra ndwáala yaachwe, akiinʉka, maa akaanda vatʉmamɨra. ");
INSERT INTO lag_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mwaasʉ noo kʉtʉmɨra, vaantʉ ˆvajáa na mirimʉ mɨvɨ vakareetwa na kʉrɨ Yéesu, yeeye kwa isáare raachwe akiikibirya mirimʉ mɨvɨ na akavahorya valwɨ́ɨrɨ voosi. ");
INSERT INTO lag_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Abweeyya jeyyo, sa isáare ra Isáaya mʉláali na mʉtwe rikiimane, “Yeeye mweeneevyo asʉmʉla teketeke yiitʉ, na avereka ndwáala jiitʉ.” ");
INSERT INTO lag_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yéesu ˆakoone mpuka ya vaantʉ yoomʉrɨɨngɨrɨra, maa akalairirya vapooji vaachwe vafɨrɨre ne na nyambʉko ya iriva. ");
INSERT INTO lag_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aho, mukiindya wa Miiro ya Mʉlʉʉngʉ akʉʉja na kʉrɨ Yéesu, maa akamʉsea, “Mukiindya, kukutuuba ndɨrɨ na haantʉ hohoosi ˆʉrɨ doma.” ");
INSERT INTO lag_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yéesu akamʉsea, “Mʉʉnjʉ jatɨɨte viláalo mpáángii, na ndee jatɨɨte vivururu, maa kaa, Mwaana wa Mʉʉntʉ asiina baa ho laarya mʉtwe waachwe vii tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aho, ʉmwɨ wa vapooji vaachwe akamʉsea, “Aaɨ mʉkʉ́lʉ, reka ta nkataahe taáta.” ");
INSERT INTO lag_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Maa kaa, Yéesu akamʉsea, “Ntuuba, reka vaantʉ ˆvaakwya vataahe vaantʉ ˆvaakwya viivaavo.” ");
INSERT INTO lag_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aho, Yéesu akaambʉka mashʉ́wa hamwɨ na vapooji vaachwe. ");
INSERT INTO lag_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Koonka, kʉkava na ihúmbuuto ˆradalavadalaava irivii, mapúunta yakaanda wɨɨkɨra mashʉ́wa kende ɨnyɨmɨre. Mpɨɨndɨ ɨyo, Yéesu ajáa alɨ́ɨre anyéyyiirye. ");
INSERT INTO lag_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Vapooji vaachwe vakadoma noo mwiinukya voosea, “Mʉkʉ́lʉ! Mʉkʉ́lʉ! Tʉlamurirye, sira tiise!” ");
INSERT INTO lag_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yéesu akavasea, “Nyuunyu ˆmurúmaa kiduudi, sa che mookoofa?” Aho, akiinʉka, akarɨdalavya ihúmbuuto na yara mapúunta. Ihúmbuuto rɨkakirinya sawu, na maaji yakatʉʉla tʉ. ");
INSERT INTO lag_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Vapooji vaachwe vakahwaalala, vakaanda kiiyurya voosea, “Ʉhʉ nɨ mʉʉntʉ che? Baa ihúmbuuto na mapúunta vyoomʉteera?” ");
INSERT INTO lag_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yéesu na vapooji vaachwe vakafɨrɨra iriva fʉʉrʉ ɨsɨ ya Vageráasi. Ʉko akalʉmana na vaantʉ vavɨrɨ ˆvarɨ na mirimʉ mɨvɨ voofuma mbiríírii. Avo vaantʉ vajáa vahʉʉmba maatʉkʉ vii, kusiina mʉʉntʉ ˆakwáatɨraa na ɨyo njɨra tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Vakatʉla isóso voosea, “Nɨ che woosaaka kʉrɨ suusu weewe Mwaana wa Mʉlʉʉngʉ? Wuújire noo tuturikirya baa mpɨɨndɨ ˆyasaawʉlwa sɨ ɨnafika wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Haaha, heehi na aho haantʉ, kʉjáa kwatɨɨte ufya wa nkaamba ˆjooriisha. ");
INSERT INTO lag_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mirimʉ mɨvɨ ikiilomboola kʉrɨ Yéesu, yoosea, “Koonɨ wootukibirya, tʉrekere tʉkɨɨngɨre ʉra ufya wa nkaamba.” ");
INSERT INTO lag_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aho, Yéesu akɨɨsea, “Domi!” Ɨra mirimʉ mɨvɨ ɨkafuma kwa vara vaantʉ, maa ɨkadoma noo kɨɨngɨra nkaamba. Ufya woosi wa nkaamba ʉkagɨrɨtɨra na kɨwoongwii, maa jikabʉrʉkɨra na irivii, na joosi vʉʉ jikakwya. ");
INSERT INTO lag_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Varíisi va jira nkaamba vakakʉʉrɨka itɨ́ɨjo, vakatwaala mʉlomo kwa vaantʉ ˆvajáa múujii, vakɨɨta noo vawyɨɨra masáare yoosi ˆyajáa yafʉ́mɨɨre, baa na kɨra ˆkɨjáa chafʉ́mɨɨre kwa vara vaantʉ ˆvajáa na mirimʉ mɨvɨ. ");
INSERT INTO lag_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Vaantʉ voosi va ʉra múuji vakadoma noo lʉmana na Yéesu, ˆvakamoone, vakamʉloomba alooke aho meevo. ");
INSERT INTO lag_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yéesu akɨɨngɨra mashúwii, akafɨrɨra iriva ra Galiláaya, maa akahɨndʉka na múujii meevo. ");
INSERT INTO lag_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Vaantʉ vamwɨ, vakamʉretera mʉʉntʉ ˆaakwya iyandiyandi, aláariiwe ndirii yaachwe. Yéesu ˆakoone kuruma kwaavo, akamʉsea ʉra ˆaakwya iyandiyandi, “Mwaana waanɨ, iheere mʉtɨma! Ʉvɨ waako wasírire.” ");
INSERT INTO lag_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Vamwɨ va vakiindya va Miiro ˆveene vajáa aho, vakiiwyɨɨra jei, “Ʉhʉ mʉmaka yoomʉhɨɨntɨkɨra Mʉlʉʉngʉ!” ");
INSERT INTO lag_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yéesu akataanga miiririkano yaavo, maa akavuurya, “Sa che mookiiririkana mavɨ mitimii yaanyu? ");
INSERT INTO lag_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nɨ kɨrɨkwɨ noo chaangʉ kʉlookya myeewe, kʉmʉsea, ‘Ʉvɨ waako wasírire,’ au kʉmʉsea, ‘Inʉka, yeenda’? ");
INSERT INTO lag_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Haaha noosaaka mʉtaange Mwaana wa Mʉʉntʉ atɨɨte wiimiriri aha weerwii wo sea vaantʉ ʉvɨ waavo wasírire.” Aho, akamʉsea ʉra mʉʉntʉ ˆaakwya iyandiyandi, “Inʉka, toola ndɨrɨ yaako, tamanya na kaayii.” ");
INSERT INTO lag_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ʉra mʉʉntʉ akiinʉka, maa akatamanya na kaayii kwaachwe. ");
INSERT INTO lag_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ɨra mpuka ya vaantʉ ˆɨjáa aho ˆvakoone ayo, vakakwaatwa nɨ woowa kʉnʉ voomʉdʉʉmba Mʉlʉʉngʉ ˆavahéeraa vaantʉ wiimiriri ja ʉwo. ");
INSERT INTO lag_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mpɨɨndɨ Yéesu ˆalookáa fuma ʉko, ajáa oona mʉʉntʉ ʉmwɨ iíkyɨɨre kɨvaandii cho rɨhɨra kóodi. Ʉhʉ mʉʉntʉ irina raachwe noo Matáayo asewáa. Yéesu akamʉsea, “Ntuuba.” Ne akiinʉka akamutuuba Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mpɨɨndɨ Yéesu ˆarijáa kaayii kwa Matáayo, vasaankanʼyi kóodi na vaduwalo ˆvarɨ foo vakʉʉja. Avo vakiikala kurya chóorya hamwɨ na Yéesu na vapooji vaachwe. ");
INSERT INTO lag_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafarisáayo ˆvakoone jeyyo, maa vakavasea vapooji vaachwe, “Sa che mukiindya waanyu yoorya na masaankanʼyi kóodi na maduwalo?” ");
INSERT INTO lag_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yéesu ˆakateere jeyyo, maa akasea, “Vaantʉ ˆvarɨ nkaasʉ sɨ vasáakaa mwaanga tʉkʉ, maa kaa, valwɨ́ɨrɨ noo vasáakaa mwaanga. ");
INSERT INTO lag_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Haaha tamanyi mukiikiindye aya masáare ˆcheene yalʉʉsa, ‘Noosaaka riiso ra wʉʉja, na sɨ mpóryo jaanyu tʉkʉ.’ Sɨ nʉʉja joo kaanɨrɨra vaantʉ ˆviiyónaa nɨ vawoloki tʉkʉ, nʉʉja joo kaanɨrɨra vavɨ.” ");
INSERT INTO lag_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Haaha, vapooji va Yooháani vajáa vadoma na kʉrɨ Yéesu, maa vakamuurya, “Sa che suusu na Mafarisáayo twiirékyaa kurya, maa kaa, vapooji vaako sɨ viirékyaa kurya?” ");
INSERT INTO lag_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yéesu akavasea, “Vaantʉ ˆvaláarikirwe na ngovii joolɨ varɨ rɨra no myaa mpɨɨndɨ ˆvarɨ hamwɨ na mweenengovi? Mpɨɨndɨ kʉʉja jiri, sikʉ ijo mweenengovi sʉmʉlwa arɨ fuma kwaavo, na aho noo varɨ kwiirekya kurya. ");
INSERT INTO lag_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kusiina mʉʉntʉ ˆadáhɨraa kɨráka kifya isaámwii tʉkʉ. Koonɨ abwéeyyiirye jeyyo, ɨkyo kɨráka kifya moola kɨrɨ ɨro isaámʉ na ɨyo ɨngo tatʉka ɨrɨ kʉlookya lwa ncholo. ");
INSERT INTO lag_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kei, kusiina mʉʉntʉ ˆavɨ́kɨraa diváai ifya viríibii vya kalɨ tʉkʉ. Koonɨ abwéeyyiirye jeyyo, ɨyo diváai pʉsʉla ɨrɨ ivyo viríiba, viríiba saambʉka viri na diváai kɨɨtɨka ɨrɨ. Diváai ifya nɨ viríibii vifya ˆɨvɨ́kɨrwaa, na vyoosi diváai na viríiba chaala viri nkaasʉ.” ");
INSERT INTO lag_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mpɨɨndɨ Yéesu ˆajáa akaarɨ yoolʉʉsɨka ayo masáare, mʉʉntʉ ʉmwɨ mʉkʉʉlʉ wa sinagóogi akʉʉja. Akachwaama mbere ya Yéesu, maa akamʉsea, “Muhíínja waanɨ awʉ́lɨɨre haaha vii. Baa neembe nɨ jeyyo, nookʉloomba wʉʉje na kwaanɨ sa jɨ ʉmʉsaasye na mʉkono waako na kʉva arɨ mooyo kei.” ");
INSERT INTO lag_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yéesu akiinʉka na ʉwo mʉʉntʉ, akadomanʼya baa na vapooji vaachwe. ");
INSERT INTO lag_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mʉʉntʉ muki ʉmwɨ ajáa na ndwáala yo fuma sakami kwa myaaka ikimi na ɨvɨrɨ. Akamutuuba Yéesu kwa nyuma, maa akasaasya mʉkáwo wa nkáancho yaachwe. ");
INSERT INTO lag_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Abweeyya jei, sa iiseáa kɨmoyomooyo, “Koonɨ nasáasiirye ɨngo ya Yéesu vii, hola ndɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yéesu akiilorera, akamoona ʉra mʉʉntʉ muki, maa akamʉsea, “Muhíínja waanɨ, iheere mʉtɨma! Kuruma kwaako kwakʉhóriirye.” Hahara, ʉra mʉʉntʉ muki akahola! ");
INSERT INTO lag_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yéesu ˆakafike kaayii kwa ʉra mʉkʉ́ʉ́lʉ wa sinagóogi, akashaana vavai ntoroonya na vaantʉ ˆvarɨ foo viijíingire aho, voorɨra no myaa kwa isóso. ");
INSERT INTO lag_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aho, Yéesu akavasea, “Isunki aha, muhíínja sɨ akwíire tʉkʉ, nɨ alɨ́ɨre vii.” Avo vaantʉ vakamʉsekerera. ");
INSERT INTO lag_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Vaantʉ ˆvakafumiwe voosi na weerwii, Yéesu akɨɨngɨra na nyuumbii, akamʉkwaata mʉkono ʉra muhíínja, hahara, akiinʉka. ");
INSERT INTO lag_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Masáare aya, yakeenera ɨra ɨsɨ yoosi. ");
INSERT INTO lag_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yéesu ˆakiinʉke fuma aho, vahoku vavɨrɨ vakamutuuba kʉnʉ vootʉla isóso voosea, “Tʉlaange na riiso ra wʉʉja, ee Sha Daúdi!” ");
INSERT INTO lag_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ˆAkafike kaayii, vara vahoku vakʉʉja na kʉʉntʉ ˆajáa. Aho, Yéesu akavasea, “Ruma mwiise daha ndɨrɨ kʉvahorya wʉʉ?” Avo vahoku vakamʉsea, “Hɨɨ Mʉkʉ́lʉ.” ");
INSERT INTO lag_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aho, Yéesu akasaasya miiso yaavo kʉnʉ yoosea, “Vive ja kuruma kwaanyu.” ");
INSERT INTO lag_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Miiso yaavo yakatʉʉnʉkʉka. Yéesu akavakaanʼya na ngururu yoosea, “Karɨ mumuwyɨ́ɨraa mʉʉntʉ yoyoosi ɨrɨ isáare tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Maa kaa, voovo ˆvakiinʉke aho, vakaarya ayo masáare ɨra ɨsɨ yoosi. ");
INSERT INTO lag_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mpɨɨndɨ avo vaantʉ vavɨrɨ ˆvalookáa aho, vaantʉ vɨɨngɨ vakamʉreeta kimumu ʉmwɨ ˆarɨ na mirimʉ mɨvɨ. ");
INSERT INTO lag_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yéesu ˆakiikibirye ɨra mirimʉ mɨvɨ, ʉra mʉʉntʉ akaanda lʉʉsɨka kei. Mpuka ya vaantʉ voosi ˆvajáa aho, ɨkahwaalala kʉnʉ voosea, “Isáare ja ɨrɨ sɨ rɨnoonekana ɨsɨ yoosi ya Isiraéeli vii tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Maa kaa, Mafarisáayo vakava voosea, “Yookibirya mirimʉ mɨvɨ kwa ngururu ja Irimʉ.” ");
INSERT INTO lag_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yéesu arɨɨngɨrɨráa míiji yoosi na maturi yoosi, kʉnʉ yoovariyʉla masinagóogii yaavo Masáare Maaja ya Ʉtemi, na avahoryáa vaantʉ ndwáala ˆjiísimiresimire. ");
INSERT INTO lag_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yéesu ˆakoone mayɨɨmbɨ ya vaantʉ, akavoonera mbavariri, sa vatʉrɨkɨráa baa nyambirirya tʉkʉ, vajáa nɨ ja muundi ˆjisiina muríisi. ");
INSERT INTO lag_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aho, maa Yéesu akavasea vapooji vaachwe, “Viintʉ vyo chwa nɨ foo viri, maa kaa, vachwi nɨ vake. ");
INSERT INTO lag_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sa jeyyo, mʉloombi Mweenevyoosi wo chwa, atʉme vachwi na iwundii raachwe ro chwa.” ");
INSERT INTO lag_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yéesu akavaanɨrɨra vapooji vaachwe ikimi na vavɨrɨ. Akavaheera wiimiriri wo kibirya mirimʉ mɨvɨ no vahorya vaantʉ ndwáala ˆjiísimiresimire. ");
INSERT INTO lag_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aya noo marina ya vatumwi ikimi na vavɨrɨ, wa ncholo Simóoni, ˆmweene akemerwáa Peéteri, na Anderéa mwaanaavo, Yaakúupu na Yooháani vaana va Sebedáayo, ");
INSERT INTO lag_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filíipi, Batolomáayo, Matáayo mʉsaankanʼyi kóodi, Tomáasi, Yaakúupu sha Alʉfáayo, Tedéei, ");
INSERT INTO lag_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simóoni Mʉkanáani, na Yʉ́ʉda Isikarióoti ˆamʉvarindʉka Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Avo vapooji ikimi na vavɨrɨ Yéesu avatʉma, akavalairirya yoosea, “Karɨ mʉdómaa na kwa vaantʉ sɨ ˆvarɨ Vayahúudi tʉkʉ, na karɨ mwɨɨ́ngɨraa múujii wowoosi wa Vasamaría tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Maa kaa, tamanyi na kwa Viisiraéeli, ava vataahɨka ja muundi. ");
INSERT INTO lag_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na mpɨɨndɨ ˆmooyeenda ʉko, mʉndoovariyʉla moosea, ‘Ʉtemi wa Kurumwii, waséngerɨɨre.’ ");
INSERT INTO lag_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mʉndoohorya valwɨ́ɨrɨ, mʉndoofʉfʉla vaantʉ ˆvaakwya, mʉndoojirʉla vaantʉ ˆvarɨ na ʉlóónda na mʉndookibirya mirimʉ mɨvɨ. Mwaheewa bweete, tooli bweete. ");
INSERT INTO lag_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Karɨ mʉsʉ́mʉlaa mpía yoyoosi mifukwii yaanyu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Baa kei, karɨ mʉsʉ́mʉlaa mifuko yo kɨɨnjɨra tʉkʉ, nkáancho ivɨrɨ tʉkʉ, viráatʉ baa nkome tʉkʉ. Sa mʉtʉmami ɨɨma neeja kʉheewa marɨho yaachwe. ");
INSERT INTO lag_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Múuji au ituri roroosi ˆmʉrɨ kɨɨngɨra, saakiri mʉʉmo mʉʉntʉ ˆavalwa ɨɨma neeja. Ikali aho fʉʉrʉ sikʉ ˆmʉrɨ looka. ");
INSERT INTO lag_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na nyuumba ˆngʼeene mʉrɨ kɨɨngɨra, valuumbyi vaantʉ ˆvarɨ aho. ");
INSERT INTO lag_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Koonɨ veenekaaya vavalwa vɨɨma neeja kwa ɨyo lʉmbɨ, mwiikalo mʉʉja waanyu wiikale novo. Maa kaa, koonɨ veenekaaya sɨ vavalwa vɨɨma neeja kwa ɨyo lʉmbɨ, mwiikalo waanyu mʉʉja ʉhɨndʉke na kʉrɨ nyuunyu. ");
INSERT INTO lag_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Koonɨ mʉʉntʉ sɨ avatéengiirye au koonɨ sɨ atéɨɨre masáare yaanyu, ˆmʉrɨ fuma aho nyuumbii, au aho múujii, ikonkomi marʉrɨ ˆyarɨ majewii yaanyu koonekya ʉvɨ waavo. ");
INSERT INTO lag_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kɨmaarɨ noovawyɨɨra, sikʉ ya ʉlamu, kʉva viri pwee kwa vaantʉ va Sodóoma na Gomóora kʉlookya vaantʉ va míiji ɨyo. ");
INSERT INTO lag_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Laangi, nɨ vatʉma niise ja muundi katɨ na katɨ ya mbʉʉjɨ. Sa jeyyo, mʉve na tooti ja njoka na mʉve ˆmwahola ja nkúnde. ");
INSERT INTO lag_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Laangi neeja vaantʉ, sa kʉvatwaala veende na balásii na vawa mweende mɨjeléedimasinagóogii yaavo. ");
INSERT INTO lag_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Twaalwa mweende na mbere ja magávana na vatemi sa nɨɨnɨ, aho de mʉdahe variyʉla Masáare Maaja kwa vaantʉ sɨ ˆvarɨ Vayahúudi na vatemi vaavo. ");
INSERT INTO lag_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Maa kaa, mpɨɨndɨ ˆvarɨ vatwaala na balásii, karɨ mwiítweetyaa nɨ che ˆmʉrɨ lʉʉsa na ˆvyeene mʉrɨ lʉʉsa tʉkʉ, sa mpɨɨndɨ yɨɨyo longoolwa mʉrɨ cho lʉʉsa. ");
INSERT INTO lag_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Masáare mwɨɨndoolʉʉsa sɨ yarɨ fuma kwaanyu tʉkʉ, maa kaa, fuma yeende kwa Mʉtɨma wa Taáta waanyu. Yeeye noo ˆɨndoolʉʉsɨka ko tweera nyuunyu. ");
INSERT INTO lag_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mʉʉntʉ mʉvarindʉka arɨ mwaanaavo sa ʉʉlawe, taáta mʉvarindʉka arɨ mwaana waachwe sa ʉʉlawe. Vaana novo vavarindʉka varɨ, vala íyo na taáta waavo sa vʉʉlawe. ");
INSERT INTO lag_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sʉʉlwa mʉrɨ nɨ vaantʉ voosi sa irina raanɨ. Maa kaa, yoyoosi ˆarɨ yimirirya fʉʉrʉ ʉhero, ʉwo noo ˆarɨ lamuririwa. ");
INSERT INTO lag_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ˆMʉrɨ turikiriwa múuji ʉmwɨ, tiiji na múujii wɨɨngɨ. Kɨmaarɨ noovawyɨɨra, sɨ mʉrɨ mala kʉtweerera míijii yoosi ya Isiraéeli tʉkʉ, Mwaana wa Mʉʉntʉ sɨ anahɨndʉka. ");
INSERT INTO lag_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mʉpooji sɨ arɨ mweeri ya mukiindya waachwe tʉkʉ, baa mʉtʉ́mwa sɨ mweeri ya mweenekaaya waachwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Maa kaa, vyatoosha mʉpooji kʉva ja mʉcháani na mʉtʉ́mwa kʉva ja mweenekaaya waachwe. Koonɨ voomwaanɨrɨra mweenekaaya Belisebúuri, eri, vaantʉ va ɨyo kaaya sɨ varɨ kaanɨrɨrwa marina ˆyavɨɨha kʉlookya ɨro tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sa jeyyo, karɨ mʉvoofe avo vaantʉ tʉkʉ. Sa kɨɨntʉ chochoosi ˆchakʉnɨkɨrɨrwa, kʉnʉkʉlwa kɨrɨ, na baa kusiina ˆchaviswa, ˆkɨrɨ dɨɨra taangwa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Vyoosi ˆnoovawyɨɨra kilwiiryii, viluusi kɨweerwii namuusi kweerʉ chwe. Vyoosi ˆmoohweeherwa kutwii, viluusi italii. ");
INSERT INTO lag_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Koofi vaantʉ ˆvʉʉ́laa mʉvɨrɨ tʉkʉ, na kʉnʉ sɨ vadáhaa kʉʉlaa nkaasʉ tʉkʉ. Moofi ʉra ˆadáhaa mala mʉvɨrɨ na nkaasʉ kwa mooto wa Jehénamu. ");
INSERT INTO lag_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Eri, seese ivɨrɨ sɨ jiváwaa iyoombe igwáare rɨmwɨ tʉkʉ wʉʉ? Baa neembe nɨ jeyyo, baa ɨmwɨ vii sɨ ɨrɨ kukwya tʉkʉ, mpaka Taáta waanyu alamʉle. ");
INSERT INTO lag_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Haaha kʉrɨ nyuunyu baa njwɨɨrɨ jiri mitwii yaanyu javalwa joosi. ");
INSERT INTO lag_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sa jeyyo, koofi tʉkʉ, nyuunyu kwa Mʉlʉʉngʉ mʉrɨ va iyoombe ikʉʉlʉ kʉlookya seese ˆjiri foo! ");
INSERT INTO lag_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mʉʉntʉ yoyoosi ˆarɨ kuunduma, noo kʉsea, kʉʉndʉʉsɨkɨra nɨɨnɨ mbere ja vaantʉ, nɨɨnɨ muruma ndɨrɨ mbere ja Taáta waanɨ. Yeeye iíkalaa kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Maa kaa, ˆarɨ sea sɨ aamányire tʉkʉ mbere ja vaantʉ, nɨɨnɨ naanɨ sea ndɨrɨ sɨ namʉmányire tʉkʉ mbere ja Taáta waanɨ. Yeeye iíkalaa kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Karɨ mwiisee nʉʉja noo reeta mwiikalo mʉʉja aha weerwii tʉkʉ. Tʉkʉ, sɨ nʉʉja noo reeta mwiikalo mʉʉja tʉkʉ, nʉʉja noo reeta nkoondo. ");
INSERT INTO lag_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sa nʉʉja noo choonkererya, ‘musinga na taáta waavo, muhíínja na íyo waavo, na íyo mʉkwɨ na muki wa mwaana. ");
INSERT INTO lag_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na vavɨ va mʉʉntʉ, kʉva varɨ vaantʉ va kaayii kwaachwe.’ ");
INSERT INTO lag_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mʉʉntʉ yoyoosi ˆarɨ mweenda taáta waavo na íyo waavo kʉlookya nɨɨnɨ, au ˆarɨ mweenda mwaana waachwe wa kɨɨntʉ kiki au wa kɨɨntʉ kɨlʉme kʉlookya nɨɨnɨ, ʉwo sɨ ɨɨma neeja kʉva kwaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na mʉʉntʉ yoyoosi koonɨ sɨ yoovereka mʉsaláaba waachwe noo kuuntuuba nɨɨnɨ, ʉwo sɨ ɨɨma neeja kʉva kwaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sa koonɨ mʉʉntʉ yooturya nkaasʉ yaachwe, kɨɨtaaha arɨ, maa kaa, mʉʉntʉ yoyoosi ˆyookɨɨtaaha nkaasʉ yaachwe sa nɨɨnɨ, ʉwo kiiturya arɨ. ");
INSERT INTO lag_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ʉra ˆarɨ vateengya nyuunyu, nɨ nɨɨnɨ yookʉʉnteengya. Na ʉra ˆyookʉʉnteengya nɨɨnɨ, nɨ mʉteengya iise Mʉlʉʉngʉ, na yeeye aantʉma nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ʉra ˆarɨ mʉteengya mʉláali na mʉtwe sa nɨ mʉláali na mʉtwe, hokera arɨ kʉnáálo ya mʉláali na mʉtwe. Na ʉra ˆarɨ mʉhokera mʉwoloki sa nɨ mʉwoloki, hokera arɨ kʉnáálo ya mʉwoloki. ");
INSERT INTO lag_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na mʉʉntʉ yoyoosi ˆarɨ mʉheera ʉmwɨ wa ava vadúúdi baa ndʉvo ya maaji vii, sa yeeye nɨ mʉpooji waanɨ, kɨmaarɨ noovawyɨɨra, sɨ arɨ sova kʉnáálo yaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yéesu ˆakahʉmʉle kʉvalairirya vapooji vaachwe ikimi na vavɨrɨ, maa akatamanya na míijii ya Galiláaya noo kookiindya no vavariyʉrɨra isáare ra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ʉko mʉnyololwii, Yooháani Mʉbatisáaji akateera masáare ˆmeene Kirisitʉ atʉmamáa, akavatʉma vapooji vaachwe vamuurye, ");
INSERT INTO lag_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Eri, weewe noo ʉra ˆalʉʉswa nɨ valáali na mʉtwe yookʉʉja, bakʉ tʉwoojere wɨɨngɨ?” ");
INSERT INTO lag_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yéesu akavasea, “Tamanyi na kwa Yooháani mʉkamʉwyɨɨre yoosi ˆmwɨɨ́ne na ˆmʉtéɨɨre. ");
INSERT INTO lag_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Vahoku vookoona, vivete vooyeenda, ˆvarɨ na ʉlóónda voojirʉlwa, vimatu vooteera, vaantʉ ˆvaakwya voofʉfʉlwa na vakɨva voovariyʉrɨrwa Masáare Maaja. ");
INSERT INTO lag_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Atalariwa ʉra sɨ ˆahɨ́twahɨtwaa sa nɨɨnɨ.” ");
INSERT INTO lag_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Vara vapooji va Yooháani ˆvakalooke, maa Yéesu akaanda kiiwyɨɨra ɨra mpuka ya vaantʉ masáare ya Yooháani yoosea, “Nɨ che mwɨɨtáa koo laanga kʉra ɨsɨ ya ibaláángwii? Isaanga rooringiwaringiwa nɨ mpeho wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Koonɨ sɨ jeyyo, nɨ che mwɨɨtáa laanga? Mʉʉntʉ iirwíikire ɨngo ja iyoombe ikʉʉlʉ wʉʉ? Aka tʉkʉ, vaantʉ viirwɨ́ɨkaa ɨngo ja iyoombe ikʉʉlʉ na ˆvarɨ na kɨra kɨɨntʉ ˆchabooha nɨ nyuumbii ja kɨtemi viíkalaa. ");
INSERT INTO lag_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Haaha nɨ che mwɨɨtáa koo laanga? Nɨ mʉláali na mʉtwe mwɨɨtáa koo laanga wʉʉ? Kɨkomi, noovawyɨɨra nɨ kʉlookya mʉláali na mʉtwe, mwɨɨtáa koo laanga. ");
INSERT INTO lag_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ʉhʉ noo masáare yaachwe ˆyaandɨkwa Masáarii ˆYarɨ Mpeho, ‘Laanga, mʉtʉma ndɨrɨ mutumwi waanɨ akʉlongorɨre, yeeye kʉtengenesherya arɨ njɨra yaako.’ ");
INSERT INTO lag_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kɨmaarɨ noovawyɨɨra, kwa vaantʉ voosi kusiina ˆarɨ mʉkʉʉlʉ kʉlookya Yooháani Mʉbatisáaji tʉkʉ. Maa kaa, ʉra ˆarɨ muduudiduudi Ʉtemii wa Mʉlʉʉngʉ, noo mʉkʉʉlʉ kʉlookya Yooháani. ");
INSERT INTO lag_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kwaandɨra sikʉ ja Yooháani Mʉbatisáaji fʉʉrʉ isikʉ, Ʉtemi wa Kurumwii wookɨɨmɨrɨrwa na ngururu, na vara ˆvarɨ na ngururu noo vookʉʉnyahɨra. ");
INSERT INTO lag_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Valáali na mʉtwe voosi na Miiro yalʉʉsa ʉláali na mʉtwe fʉʉrʉ mpɨɨndɨ ja Yooháani. ");
INSERT INTO lag_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Haaha koonɨ mooruma ʉláali na mʉtwe ʉwo, yeeye noo Elía ʉra ˆalʉʉswa kʉʉja arɨ. ");
INSERT INTO lag_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ˆArɨ na matu, nɨ ateere! ");
INSERT INTO lag_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na che ndɨrɨ kɨɨfwaanirirya mbyaala ɨhɨ? Mbyaala ɨhɨ yiifwɨ́ɨne na vasinga viíkyɨɨre isóokwii de vandoovaanɨrɨra viivaavo voosea, ");
INSERT INTO lag_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tavaváɨɨre firíimbi, nyuunyu baa bwɨɨta tʉkʉ! Tavɨɨ́mbɨɨre nyɨɨ́mbo ja ʉsʉʉngʉ, nyuunyu baa rɨra tʉkʉ!’ ");
INSERT INTO lag_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sa Yooháani Mʉbatisáaji ʉʉja, sɨ arijáa baa kei sɨ anywijáa tʉkʉ, novo vakasea, ‘Atɨɨte murimʉ mʉvɨ.’ ");
INSERT INTO lag_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Maa kaa, Mwaana wa Mʉʉntʉ ʉʉja yoorya no nywa, novo vakasea, ‘Mʉlaangi ʉhʉ, mwaafu na mʉreevi, mare ya vasaankanʼyi kóodi na vavɨ.’ Baa neembe nɨ jeyyo, tooti ya Mʉlʉʉngʉ yoonekiirye kɨkomi nɨ ya ʉwoloki kwa mɨrɨmo yaachwe.” ");
INSERT INTO lag_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aho, Yéesu akaanda kiiwyɨɨra marema míiji ɨra ˆajáa abweeyya myuujíisa ˆɨrɨ foo, maa kaa, vaantʉ va ɨyo míiji sɨ vamʉvalandʉkɨra Mʉlʉʉngʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Akasea, “Mpolaɨ múuji wa Korasíini! Mpolaɨ ituri ra Besaída! Sa ngaarɨ myuujíisa yatʉ́mamirwe kwaanyu yatʉmamwa míiji ya Tíiro na Sidóoni, ngaarɨ viivɨkɨra magunía na viihaka mavu koonekya vamʉvalandʉkɨre Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kɨmaarɨ noovawyɨɨra, sikʉ ya ʉlamu, kʉva ɨrɨ pwee kwa vaantʉ va míiji ya Tíiro na Sidóoni kʉlookya nyuunyu. ");
INSERT INTO lag_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Weewe múuji wa Kaperenáumu, eri, kiinʉlwa ʉrɨ fʉʉrʉ kurumwii wʉʉ? Aka tʉkʉ! Kiimiriwa ʉrɨ fʉʉrʉ Ntarii. Sa ngaarɨ myuujíisa yatʉ́mamirwe kwaako ngaarɨ yatʉmamwa Sodóoma, ngaarɨ múuji wa Sodóoma ʉmwaarɨ fʉʉrʉ isikʉ. ");
INSERT INTO lag_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kɨmaarɨ kaa noovawyɨɨra, sikʉ ya ʉlamu kʉva viri pwee kwa múuji wa Sodóoma, kʉlookya weewe!” ");
INSERT INTO lag_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mpɨɨndɨ ɨra Yéesu akasea, “Nookʉdʉʉmba ee Taáta Mweenevyoosi wa kurumu na ɨsɨ, sa masáare aya ʉvavisa vaantʉ ˆvarɨ na tooti na mɨryʉʉngʉ, maa kaa, ʉkavakʉnʉkʉrɨra vadúúdi. ");
INSERT INTO lag_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kɨkomi Taáta, ivyo noo vyakweerya mʉtɨma. ");
INSERT INTO lag_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Taáta waanɨ aankwáatiirye viintʉ vyoosi. Kusiina ˆamʉmányire Mwaana tʉkʉ, maa kaa, Taáta vii. Kei, kusiina ˆamʉmányire Taáta tʉkʉ, maa kaa, Mwaana vii na mʉʉntʉ yoyoosi Mwaana ˆarɨ saaka kʉmoonekya. ");
INSERT INTO lag_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yeendi na kʉrɨ nɨɨnɨ, nyuunyu voosi ˆmoohʉʉmwa nɨ miriwa, nɨɨnɨ kʉvahumulukya ndɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ichuungiri iyóoki raanɨ, mwiikiindye fuma kwaanɨ, sa nɨɨnɨ nahola na nakiimya mʉtɨma waanɨ na ɨsɨ. Kwaanɨ nyuunyu kʉva mʉrɨ na mwiikalo mʉʉja nkaaswii yaanyu. ");
INSERT INTO lag_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iyóoki raanɨ nɨ ferefere rɨrɨ, na muriwa waanɨ waangʉha.” ");
INSERT INTO lag_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mpɨɨndɨ ɨyo, Yéesu ajáa akwaatɨra na mawundii ya ngáano sikʉ ya Sabáato. Vapooji vaachwe vakiiteera njala, vakaanda hʉʉnga maangala ya ngáano, maa de vandoorya. ");
INSERT INTO lag_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafarisáayo ˆvakoone jeyyo, maa vakamʉsea Yéesu, “Laanga, vapooji vaako voowuna Miiro ko tʉmama mʉrɨmo wo chwa sikʉ ya Sabáato.” ");
INSERT INTO lag_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yéesu akavasea, “Sɨ mʉnasoma ˆcheene atʉmama mʉtemi Daúdi mpɨɨndɨ ˆajáa aávirwe nɨ njala na vaantʉ vaachwe tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Daúdi ɨɨngɨra na nyuumbii ya Mʉlʉʉngʉ, yeeye na vaantʉ vaachwe vakarya mɨkáate ˆɨvɨ́ɨkwaa mbere ya Mʉlʉʉngʉ. Mɨkáate ɨyo, veeneɨsɨ va Ijʉva vii noo vajáa varekerwa vɨndoorya. Vaantʉ vɨɨngɨ Miiro ɨjáa yakaanʼya kurya. ");
INSERT INTO lag_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Baa kei sɨ mʉnasoma kɨtáabwii cha Miiro, veeneɨsɨ va Ijʉva ˆvatʉ́mamaa Kaayii Njija ya Ijʉva kɨra sikʉ ya Sabáato, vɨɨbwéeyyaa sikʉ ya Sabáato ɨve na njeo tʉkʉ wʉʉ? Baa neembe nɨ jeyyo, Mʉlʉʉngʉ sɨ avaválaa vabwéeyyiirye ʉvɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Maa kaa, nɨ kʉvawyɨɨra niise, aha amwaarɨ mʉkʉ́ʉ́lʉ kʉlookya Kaaya Njija. ");
INSERT INTO lag_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ngaarɨ mʉtáangaa Masáare ˆYarɨ Mpeho aya yalʉʉsa, ‘Noosaaka riiso ra wʉʉja, na sɨ mpóryo jaanyu tʉkʉ,’ ngaarɨ sɨ mwalʉ́ʉsaa irya kwa vaantʉ ˆvasiina ʉvɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sa Mwaana wa Mʉʉntʉ nɨ Mweeneevyo wa Sabáato.” ");
INSERT INTO lag_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yéesu akiinʉka aho, akatamanya na sinagóogii yaavo. ");
INSERT INTO lag_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aho, kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆajáa na mʉkono ˆwaakwya iyandiyandi. Aho, kʉjáa kwatɨɨte Mafarisáayo ˆvasaakɨráa njɨra yo musitaakya Yéesu. Avo vakamuurya voosea, “Eri, Miiro yaruma kʉmʉhorya mʉʉntʉ sikʉ ya Sabáato wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ne akavasea, “Kwatɨɨte ʉmwɨ waanyu, koonɨ muundi yaachwe ɨmwɨ yawyɨ́ɨrɨɨre iduundwii sikʉ ya Sabáato, ˆarɨ reka kwɨɨkwaata no kwɨɨseyya na weerwii wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Maa kaa, mʉʉntʉ nɨ wa iyoombe ikʉʉlʉ kʉlookya muundi. Sa jeyyo Miiro yaruma kʉtʉmama ʉʉja sikʉ ya Sabáato.” ");
INSERT INTO lag_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aho, maa akamʉsea ʉra mʉʉntʉ, “Wolola mʉkono waako!” Ʉra mʉʉntʉ akawolola mʉkono waachwe, nowo ʉkava nkaasʉ ja ʉra wɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Maa kaa, Mafarisáayo vakafuma na weerwii, vakaanda kiiheera mɨryʉʉngʉ ˆvyeene varɨ mʉʉlaa Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yéesu ˆakataange Mafarisáayo nɨ mʉrɨɨra viise iyeo sa vamʉʉlae, akiinʉka aho haantʉ. Vaantʉ ˆvarɨ foo vakamutuuba ne akavahorya valwɨ́ɨrɨ voosi. ");
INSERT INTO lag_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Akavakaanʼya vareke kwaarya masáare yaachwe kwa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yéesu alʉʉsa jeyyo, sa yakiimane masáare ya mʉláali na mʉtwe Isáaya ˆvyeene asea: ");
INSERT INTO lag_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Laanga, ʉhʉ nɨ Mʉtʉmami waanɨ ˆnamʉsaawʉla, Mʉʉja waanɨ ˆnamweenda, neeriwa mʉtɨma nɨ yeeye. Vɨɨka ndɨrɨ Mʉtɨma waanɨ mweeri yaachwe, yeeye vawyɨɨra arɨ vaantʉ va ɨsɨ joosi ʉwoloki wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Sɨ ɨɨndookiiruta ndihi tʉkʉ, baa tʉla isóso tʉkʉ, kusiina ˆarɨ teera sawúti yaachwe njirii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yeeye sɨ arɨ mala tʉkʉ kuruma ˆkʉrɨ teketeke ja kwa isaanga ˆrapuchwa, sɨ arɨ rimya tʉkʉ kwiilaangya kuduudi ˆkʉrɨ ja ʉtáampi wo nyeryanyerya, fʉʉrʉ abweeyye ʉwoloki usiinde. ");
INSERT INTO lag_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Weerʉ yoosi kiilaangya ɨrɨ irina raachwe.” ");
INSERT INTO lag_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aho, vakamʉreeta mʉʉntʉ ˆajáa na murimʉ mʉvɨ na kʉrɨ Yéesu. Ʉwo mʉʉntʉ nɨ mʉhoku na kimumu ajáa. Yéesu akamʉhorya, maa akaanda lʉʉsɨka no koona. ");
INSERT INTO lag_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mpuka yoosi ya vaantʉ ɨkahwaalala, maa vakasea, “Ʉhʉ ifaanaa akava noo Sha Daúdi wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Maa kaa, Mafarisáayo ˆvakateere ayo masáare Yéesu ˆatʉ́mamire, vakasea, “Ʉhʉ mʉʉntʉ sɨ yookibirya mirimʉ mɨvɨ tʉkʉ, maa kaa, kwa ngururu ja Belisebúuri vii, noo kʉsea Irimʉ.” ");
INSERT INTO lag_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Maa kaa, Yéesu kʉnʉ yootaanga miiririkano yaavo, akavasea, “Ʉtemi wowoosi koonɨ wiigávire kwiilwa woowo kwa woowo, ʉtemi ʉwo sɨ ʉrɨ lʉʉnga tʉkʉ. Kei koonɨ lʉkolo au múuji wiigávire kwiilwa, ʉwo sɨ ʉrɨ lʉʉnga tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Haaha koonɨ Irimʉ rookibirya Irimʉ, kʉva rɨrɨ riigávire. Ha de joolɨ ʉtemi waachwe ʉrɨ lʉʉnga? ");
INSERT INTO lag_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Haaha koonɨ nookibirya mirimʉ mɨvɨ kwa lʉvɨro lwa Belisebúuri, ha vaantʉ vaanyu nɨ kwa lʉvɨro lwa ani vakíbiryaa mirimʉ mɨvɨ? Sa jeyyo, avo noo ˆvarɨ valamʉrɨra nyuunyu. ");
INSERT INTO lag_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Maa kaa, koonɨ nookibirya mirimʉ mɨvɨ kwa lʉvɨro lwa Mʉtɨma wa Mʉlʉʉngʉ, taangi Ʉtemi wa Mʉlʉʉngʉ wafíkire haaha kʉrɨ nyuunyu. ");
INSERT INTO lag_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kei nɨ jei, kusiina mʉʉntʉ ˆarɨ daha kɨɨngɨra nyuumbii ya mʉʉntʉ ˆarɨ na ngururu, na anyahɨre máari jaachwe tʉkʉ, nɨ mpaka ta amuchuunge ʉwo mʉʉntʉ ˆarɨ na ngururu, de adahe nyahɨra máari jaachwe ˆarɨ nojo. ");
INSERT INTO lag_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mʉʉntʉ yoyoosi ʉra sɨ ˆarɨ ivarwii raanɨ, ʉwo nɨ mʉvɨ waanɨ. Kei, ʉra sɨ ˆajíingaa hamwɨ na nɨɨnɨ, apálaa. ");
INSERT INTO lag_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sa jeyyo, nɨ kʉvawyɨɨra niise, ʉvɨ wa vaantʉ na uhiintiki waavo woosi, Mʉlʉʉngʉ sea arɨ wasírire. Maa kaa, uhiintiki kwa Mʉtɨma wa Mʉlʉʉngʉ, ʉvɨ wa mʉʉntʉ ʉwo, sɨ ʉrɨ sewa wasírire tʉkʉ sikʉ joosi. ");
INSERT INTO lag_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yoyoosi ˆarɨ mʉkɨɨkana Mwaana wa Mʉʉntʉ, ʉvɨ waachwe sewa ʉrɨ wasírire. Maa kaa, ʉra ˆarɨ mʉkɨɨkana Mʉtɨma Mʉʉja, sɨ arɨ sewa ʉvɨ waachwe wasírire tʉkʉ, kwaandɨra kʉrɨ weerʉ ɨhɨ fʉʉrʉ kʉrɨ weerʉ yookʉʉja. ");
INSERT INTO lag_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Bohereryi mʉtɨ, na ndɨɨwa jaachwe booha jiri, ʉbweeyyi mʉtɨ ʉvɨɨhe na ndɨɨwa jaachwe vɨɨha jiri. Mʉtɨ watáangɨkanaa kwa ndɨɨwa jaachwe. ");
INSERT INTO lag_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nyuunyu mbyaala ya nyororooda! Joolɨ mʉrɨ daha lʉʉsa viintʉ viija na nyuunyu nɨ vavɨ? Sa mʉʉntʉ alʉ́ʉsaa yara ˆyamema mutimii waachwe. ");
INSERT INTO lag_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mʉʉntʉ mʉʉja, afúmyaa máari ja kɨkomi ja mberii njija mutimii waachwe. Maa kaa, mʉʉntʉ mʉvɨ, afúmyaa máari jaachwe ja kɨkomi ja mberii mbɨ mutimii waachwe. ");
INSERT INTO lag_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nɨ kʉvawyɨɨra niise, sikʉ ya ʉlamu, vaantʉ lo kuuriwa varɨ vavariyʉle kɨra isáare ra kɨkoókoyo ˆvalʉʉsa. ");
INSERT INTO lag_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sa kwa masáare yaako, Mʉlʉʉngʉ kʉvala arɨ weewe ʉrɨ mʉwoloki, na kwa masáare yaako lʉʉsa arɨ irya ʉrɨ mʉvɨ.” ");
INSERT INTO lag_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aho, vamwɨ va vakiindya va Miiro na Mafarisáayo vakamʉsea Yéesu, “Mukiindya, toosaaka koona isháara fuma kʉrɨ weewe.” ");
INSERT INTO lag_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yéesu akavasea, “Mbyaala mbɨ na ya vaantʉ vayeenda na vaki va vaantʉ, sɨ moosaaka kʉmʉtaanga Mʉlʉʉngʉ tʉkʉ, noo ˆchooreka mooloomba isháara! Sɨ mʉrɨ heewa isháara yoyoosi tʉkʉ, maa kaa, ɨra isháara ya Yóona mʉláali na mʉtwe vii. ");
INSERT INTO lag_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sa ja viintʉ Yóona ˆiikala indii ya soompa kwa sikʉ itatʉ chobu chɨrɨrɨ, viivyo Mwaana wa Mʉʉntʉ kiikala arɨ mbiríírii kwa sikʉ itatʉ chobu chɨrɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sikʉ ya ʉlamu, vaantʉ va Nináawi kɨɨma varɨ na vaantʉ va ɨhɨ mbyaala, novo lʉʉsa varɨ irya kwa vavɨ. Sa Vanináawi ˆvakateere ʉvariyuli wa Yóona vavalandʉka fuma uvii waavo, na aha amwaarɨ mʉkʉ́ʉ́lʉ kʉlookya Yóona! ");
INSERT INTO lag_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sikʉ ya ʉlamu, mʉtemi muki wa ɨsɨ ya saame kɨɨma arɨ alʉʉse irya kwa vaantʉ va ɨhɨ mbyaala nɨ vavɨ. Yeeye avaa njɨra fuma ɨsɨ ya kʉlɨ, akʉʉja joo teerera tooti ja Solomóoni. Haaha, aha amwaarɨ mʉkʉ́ʉ́lʉ kʉlookya Solomóoni. ");
INSERT INTO lag_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Murimʉ mʉvɨ koonɨ ufúmire kwa mʉʉntʉ, wadómaa na ɨsɨ ya ibaláángwii kʉʉntʉ ˆkusiina maaji, ʉko wasáakɨraa haantʉ ho hʉmʉlʉkɨra, baa turya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aho wiiséaa, ‘Hɨndʉka ndɨrɨ na nyuumbii yaanɨ kʉʉntʉ ˆnafuma.’ ˆɄrɨ hɨndʉka, washáanaa ɨra nyuumba yafyáahɨɨrwe na yaháambirwe vyabooha. ");
INSERT INTO lag_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aho, ʉwo murimʉ mʉvɨ wadómaa noo sʉmʉla viivaachwe mufungatɨ, vavɨ kʉlookya woowo. Yoosi yamwɨɨ́ngɨraa ʉwo mʉʉntʉ noo kiikala aho. Aho, ʉwo mʉʉntʉ asáambʉkɨrwaa kʉlookya vya ncholo. Ivi, noo ˆvyeene viri kʉva kwa vaantʉ va ɨhɨ mbyaala mbɨ.” ");
INSERT INTO lag_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mpɨɨndɨ Yéesu ˆajáa akaarɨ yoolʉʉsɨka na ɨra mpuka ya vaantʉ, íyo waavo na ndʉʉ ya Yéesu vakʉʉja, maa vakɨɨma weerwii voosaaka valʉʉsɨka ne. ");
INSERT INTO lag_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aho, mʉʉntʉ ʉmwɨ akamʉsea Yéesu, “Íyo waanyu na vaanaanyu vamwaarɨ aha weerwii, vookwaamʉkʉla.” ");
INSERT INTO lag_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aho, Yéesu akamʉsea ʉra mʉʉntʉ, “Íyo wiitʉ na vandʉʉ viitʉ nɨ vala ani?” ");
INSERT INTO lag_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yéesu akiinurirya mʉkono waachwe na haantʉ ˆvajáa vapooji vaachwe, maa akasea, “Laanga! Ava noo vala íyo, marʉʉmbʉ na ndʉʉ yaanɨ. ");
INSERT INTO lag_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sa mʉʉntʉ yoyoosi ˆatʉ́mamaa masáare ya Taáta waanɨ wa kurumwii ˆasáakaa, ʉwo noo mwaaniitʉ, irʉʉmbʉ raanɨ na íyo wiitʉ.” ");
INSERT INTO lag_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sikʉ ɨʼɨra, Yéesu ajáa afuma ɨra nyuumba akatamanya noo kiikala mbarɨmbarɨ ya iriva. ");
INSERT INTO lag_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mpuka nkʉʉlʉ ja vaantʉ jikiijiinga kʉmʉrɨɨngɨrɨra, fʉʉrʉ ɨkasaakwa aambʉke na mashúwii, akiikala aho na vaantʉ vakɨɨma mbarɨmbarɨ ya iriva. ");
INSERT INTO lag_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ne akavakiindya masáare ˆyarɨ foo kwa símo yoosea, “Teereri! Mʉhaandi ʉmwɨ ajáa adoma noo haanda mbeyʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mpɨɨndɨ ˆamyaaháa, mbeyʉ jimwi jikawyɨɨra njirii, ndee jikʉʉja jikajirya. ");
INSERT INTO lag_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jimwi jikawyɨɨra mwaalaliwyii, kʉʉntʉ ˆkʉjáa kusiina salʉ jo keenererya. Sa viintʉ salʉ sɨ jijáa jiri foo, jikamera chaangʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mwaasʉ ˆʉkavarɨke, jikashaawʉka, maa jikʉʉma sa viintʉ jijáa jisiina miriri. ");
INSERT INTO lag_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jimwi jikawyɨɨra haantʉ ˆhajáa na miíwa. Miíwa ˆɨkamere, ɨkajivaa. ");
INSERT INTO lag_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Maa kaa, jimwi jikawyɨɨra salwii ˆjiri na seve, jikamera, jikakʉla, jikavyaala maatʉkʉ vii, jimwi jikavyaala mara makumi ikimi (100), jimwi mara makumi mʉsasatʉ (60) na jimwi mara makumi yatatʉ (30). ");
INSERT INTO lag_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ˆArɨ na matu, nɨ ateere!” ");
INSERT INTO lag_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mpɨɨndɨ ˆjikalooke, vapooji vaachwe vajáa vamʉdomera, maa vakamuurya, voosea, “Sa che woolʉʉsɨka na vaantʉ kwa símo?” ");
INSERT INTO lag_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ne akavasea, “Nyuunyu mwaheewa nkalo yo taanga viintʉ vya Ʉtemi wa Kurumwii, ˆvyeene vijáa fuumbo. Maa kaa, voovo sɨ vaheewa ɨyo nkalo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ʉra ˆarɨ na kɨɨntʉ, koongereriwa arɨ kʉlookya, na kʉva arɨ novyo koyokoyo, na ʉra ˆasiina kɨɨntʉ, vuulwa arɨ baa kɨra kidúúdi ˆarɨ nocho. ");
INSERT INTO lag_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Noo ˆchooreka noolʉʉsɨka novo kwa símo. ‘Baa neembe voolaanga sɨ vookoona tʉkʉ, baa neembe vooteera sɨ vooteera tʉkʉ baa sɨ vootaanga tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jeyyo, kwaavo isáare ra mʉláali na mʉtwe Isáaya rakiimana roosea, ‘Teerera mʉrɨ neeja, maa kaa, sɨ mʉrɨ kwaatya tʉkʉ, koona, koona mʉrɨ, maa kaa, sɨ mʉrɨ taanga tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sa mɨtɨma ya vaantʉ ava yafafa, matu yaavo yadunga, miiso yaavo vakʉnɨkɨrɨra, sa vandoosiindwa koona, matu yaavo yadɨɨre kʉndooteera, na mɨtɨma yaavo ɨdɨɨre kʉndootaanga, sa vadɨɨre kʉʉnvalandʉkɨra nɨɨnɨ nɨvalamurirye.’ ");
INSERT INTO lag_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Maa kaa, nyuunyu mwatalariwa sa miiso yaanyu koona yiise na matu yaanyu teera yiise. ");
INSERT INTO lag_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kɨmaarɨ noovawyɨɨra, valáali na mʉtwe na vaantʉ vawoloki ˆvarɨ foo, vajáa vatɨɨte mpɨɨma yo koona aya mookoona nyuunyu, maa kaa, sɨ vayoona tʉkʉ. Baa kei vajáa vatɨɨte mpɨɨma yo teera aya mooteera nyuunyu, maa kaa, sɨ vayateera tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Haaha teeri ˆcheene lusímo lwa mʉhaandi mbeyʉ lwalʉʉsa. ");
INSERT INTO lag_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vaantʉ vara ˆvarɨtéeraa isáare ra Ʉtemi baa rɨtaanga tʉkʉ, nɨ ja mbeyʉ jira ˆjawyɨɨra njirii, aho ʉra Mʉvɨ ʉʉ́jaa akarɨseyya mitimii yaavo. ");
INSERT INTO lag_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyʉ jira ˆjawyɨɨra mwaalaliwyii, nɨ vaantʉ vara ˆvarɨtéeraa isáare ra Ʉtemi, maa vakarɨhokera na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Maa kaa, sa viintʉ risiina miriri, riíkalaa kwa mpɨɨndɨ nduudi vii. Uturikiri au ujuuwiki ˆʉrɨ kʉʉja sa rɨra isáare, varékaa kʉra kuruma kwaavo. ");
INSERT INTO lag_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbeyʉ jira ˆjawyɨɨra miíwii, nɨ ja vaantʉ vara ˆvarɨtéeraa isáare, maa kaa, ʉhangaiki wa weerʉ, na ʉkwaata wo kunguula máari vyarɨfényenkereryaa rɨdɨɨre reeta kʉnáálo. ");
INSERT INTO lag_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbeyʉ jira ˆjawyɨɨra sevii, noo vara vaantʉ ˆvarɨtéeraa ɨro isáare, vakarɨtaanga. Aho, ravíjaa na nkoonyo, jimwi jikavyaala mara makumi ikimi (100), jimwi mara makumi mʉsasatʉ (60) na jimwi mara makumi yatatʉ (30).” ");
INSERT INTO lag_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yéesu ajáa avawyɨɨra vaantʉ lusímo lwɨɨngɨ yoosea, “Ʉtemi wa Kurumwii wiifwɨ́ɨne na lusímo ʉlʉ. Sikʉ ɨmwɨ, mʉʉntʉ ʉmwɨ ajáa ahaanda mbeyʉ njija iwundii kwaachwe. ");
INSERT INTO lag_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Maa kaa, vaantʉ ˆvakalaale nuuchikʉ, mʉvɨ akʉʉja, akahaanda kɨsangaaji katɨkatɨ ya ngáano, maa akalooka. ");
INSERT INTO lag_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ngáano ˆɨkamere na ˆɨkave na maangala, kɨsangaaji nocho kɨkamera na kɨkakʉla. ");
INSERT INTO lag_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vatʉmami va ʉra mweeneiwʉnda vakamʉdomera, maa vakamʉsea, ‘Mʉkʉ́lʉ, sɨ wahaanda mbeyʉ njija iwundii kwaako tʉkʉ wʉʉ? Haaha ɨkɨ kɨsangaaji hai chafúmire?’ ");
INSERT INTO lag_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yeeye akavasea, ‘Nɨ mʉvɨ noo abweeyya jei.’ Aho, vatʉmami vaachwe vakamʉsea, ‘Saaka wiise tʉkakɨkʉʉle wʉʉ?’ ");
INSERT INTO lag_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Maa kaa, mweeneiwʉnda akavasea, ‘Tʉkʉ, mpɨɨndɨ ˆmoojiinga kɨsangaaji ifaanaa mʉkʉʉrɨre na ngáano. ");
INSERT INTO lag_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Reki vyoosi vikʉlanʼye, fʉʉrʉ mpɨɨndɨ yo chwa. Mpɨɨndɨ yo chwa kʉvasea ndɨrɨ vachwi, “Ta kusi kɨsangaaji mujiinge mabuundabuunda sa kɨchɨmɨkwe. Aho, maa de mujiinge ngáano na mwɨɨreete na kyoomii.”’” ");
INSERT INTO lag_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yéesu ajáa avawyɨɨra lusímo lwɨɨngɨ, yoovasea, “Ʉtemi wa Kurumwii wiifwɨ́ɨne na mpeke nduudi ya haradáali ˆngʼeene mʉʉntʉ atóolaa, maa akɨtoohaanda iwundii raachwe. ");
INSERT INTO lag_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ɨyo mbeyʉ ya haradáali nɨ nduudi kʉlookya mbeyʉ joosi, maa kaa, ˆɨrɨ mera, yakʉ́laa ɨkava mʉtɨ mʉkʉʉlʉ kʉlookya mɨtɨ yoosi ya mbowa, baa ndee jʉʉ́jaa jikajeenga vivururu matáampii yaachwe.” ");
INSERT INTO lag_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yéesu ajáa avavaɨra kei lusímo lwɨɨngɨ, yoovasea, “Ʉtemi wa Kurumwii wiifwɨ́ɨne na ʉsasɨ mʉʉntʉ muki ˆatoola, akasaangya na muchu wa ngáano viháárɨ vitatʉ vya saimʉ, maa muchu woosi ʉkʉʉka.” ");
INSERT INTO lag_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yéesu alʉʉsɨkáa na mpuka masáare aya yoosi kwa símo, sɨ alʉʉsɨkáa novo kɨɨntʉ chochoosi bila símo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jeyyo, isáare rɨra ˆralʉʉswa nɨ mʉláali na mʉtwe wa Ijʉva rikiimane ja viintʉ ˆrasea, “Kiinʉla ndɨrɨ mʉlomo waanɨ kwa símo, lʉʉsa ndɨrɨ masáare ˆyaviswa keende kʉʉmbwa kwa weerʉ.” ");
INSERT INTO lag_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aho, Yéesu akɨɨteengʉla ɨra mpuka ya vaantʉ, maa yeeye akɨɨngɨra na nyuumbii. Vapooji vaachwe vakamʉdomera, maa vakamʉsea, “Tʉwyɨɨre lusímo lwa kɨsangaaji nɨ che lwalʉʉsa?” ");
INSERT INTO lag_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yéesu akavasea, “Mʉhaandi wa mbeyʉ njija nɨ Mwaana wa Mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Iwʉnda nɨ weerʉ, mbeyʉ njija nɨ vaana va Ʉtemi. Kɨsangaaji nɨ vaana va ʉra Mʉvɨ. ");
INSERT INTO lag_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mʉvɨ ʉra ˆahaanda kɨsangaaji nɨ Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ. Kuchwa nɨ sikʉ ya ʉhero wa weerʉ, na vachwi nɨ mirimʉ miija. ");
INSERT INTO lag_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ja ˆvyeene kɨsangaaji kijíingwaa, maa kɨkachɨmɨkwa, noo ˆvyeene viri kʉva sikʉ ya ʉhero wa weerʉ. ");
INSERT INTO lag_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwaana wa Mʉʉntʉ tʉma arɨ mirimʉ yaachwe miija, noyo jiinga ɨrɨ fuma Ʉtemii waachwe vaantʉ voosi ˆvaháandaa viivaavo vatʉmame nteendo mbɨ, na vara voosi ˆvawúnaa miiro. ");
INSERT INTO lag_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ɨyo mirimʉ miija, vafweitɨra ɨrɨ na mootwii wa ngʼaanjo, na ʉko rɨra varɨ no sha mayeo. ");
INSERT INTO lag_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aho, vawoloki lavalava varɨ ja mwaasʉ Ʉtemii wa Taáta waavo. ˆArɨ na matu, nɨ ateere! ");
INSERT INTO lag_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ʉtemi wa Kurumwii wiifwɨ́ɨne na máari ya kɨkomi ya mberii ˆyaviswa iwundii. Mʉʉntʉ ʉmwɨ ˆakɨɨyone, maa akiivisa kei. Kʉnʉ arɨ na cheerʉ akatamanya noo vaa iyoombe viintʉ vyoosi ˆarɨ novyo, maa akawʉla rɨra iwʉnda. ");
INSERT INTO lag_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kei, Ʉtemi wa Kurumwii wiifwɨ́ɨne na muchurúusi ˆasáakɨraa lúulu ˆɨrɨ foo ya kɨkomi. ");
INSERT INTO lag_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ˆAkɨɨpate ɨmwɨ ya iyoombe ikʉʉlʉ, akɨɨta koovaa iyoombe viintʉ vyoosi ˆarɨ novyo, maa akɨɨwʉla ɨra lúulu. ");
INSERT INTO lag_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kei, Ʉtemi wa Kurumwii wiifwɨ́ɨne na lwaavu ˆlwatéirwe irivii, lʉkakwaata soompa ja kɨra ivala. ");
INSERT INTO lag_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lwaavu ˆlʉkameme soompa, vavúuvi vakaluruta na mbarɨmbarɨ ya iriva. Aho, vakiikala, vakasaawʉla soompa jira ˆjabooha, vakajivɨkɨra ntoongii, maa kaa, jira ˆjavɨɨha vakajifweita. ");
INSERT INTO lag_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Noo ˆvyeene viri kʉva sikʉ ya ʉhero. Mirimʉ miija kʉʉja ɨrɨ, na saawʉla ɨrɨ vavɨ na vawoloki viikale kɨra vaantʉ ivarwii raavo. ");
INSERT INTO lag_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Avo vaantʉ vavɨ, fweitɨrwa varɨ mootwii wa ngʼaanjo, ʉko rɨra varɨ no sha mayeo.” ");
INSERT INTO lag_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Aho, Yéesu akavuurya, “Eri, taanga mwiise masáare ayo yoosi wʉʉ?” Novo vakamʉsea, “Hɨɨ.” ");
INSERT INTO lag_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ne akavasea, “Kɨra mukiindya wa Miiro ya Mʉlʉʉngʉ ʉra ˆakiindiwa viintʉ vya Ʉtemi wa Kurumwii, iifwɨ́ɨne na mweenenyuumba ˆatóolaa máari jaachwe ja kɨkomi ja mberii, ifya na ja kalɨ.” ");
INSERT INTO lag_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yéesu ˆakahʉmʉle lʉʉsa símo iji, akalooka fuma aho. ");
INSERT INTO lag_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ˆAkafike múujii wa Nasaréeti kʉʉntʉ ˆakʉrɨra, akaanda vakiindya vaantʉ sinagóogii yaavo. Voovo vakahwaalala kʉnʉ vookiiyurya, “Ʉhʉ hai afúmiirye tooti na myuujíisa ɨhɨ? ");
INSERT INTO lag_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ʉhʉ sɨ mwaana wa mʉsóngoli mabambari tʉkʉ wʉʉ? Íyo waavo sɨ Maríia tʉkʉ wʉʉ? Vaanaavo sɨ vala Yaakúupu, Yooséefu, Simóoni na Yʉ́ʉda tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Marʉʉmbʉ yaachwe sɨ tʉrɨ novo aha tʉkʉ wʉʉ? Haaha nɨ hai ʉhʉ ˆafúmiirye viintʉ ivi vyoosi?” ");
INSERT INTO lag_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aho, vakamʉkalarɨra. Maa kaa, Yéesu akavasea, “Mʉláali na mʉtwe wa Ijʉva arúmwaa kɨra haantʉ, maa kaa, sɨ múujii na kaayii kwaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sa jeyyo, Yéesu sɨ abweeyya myuujíisa ˆɨrɨ foo tʉkʉ, sa viintʉ vaantʉ sɨ vamuruma. ");
INSERT INTO lag_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mpɨɨndɨ ijo, mʉtemi Heróode Antípaasi ajáa ateera masáare ˆmeene Yéesu atʉmamáa. ");
INSERT INTO lag_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aho, maa akavasea vatʉmami vaachwe, “Ʉhʉ nɨ Yooháani Mʉbatisáaji ˆafúfukire fuma inkwyii. Ɨkɨ noo ˆchooreka lʉvɨro lo bweeyya myuujíisa lʉrɨ ne.” ");
INSERT INTO lag_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Heróode alʉʉsa jeyyo, sa ʉko nyuma, ajáa amʉkwaata Yooháani Mʉbatisáaji, akamʉvɨɨka mʉnyololwii sa Herodía. Ʉhʉ Herodía nɨ muki wa Filíipi mwaanaavo na Heróode ajáa. ");
INSERT INTO lag_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sa Yooháani Mʉbatisáaji amʉseáa, “Miiro yakaanʼya weewe kʉmʉsʉmʉla muki wa mwaanaanyu.” ");
INSERT INTO lag_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heróode asaakɨráa njɨra yo mʉʉlaa Yooháani, maa kaa, avoofáa vaantʉ, sa vaantʉ vajáa vamányire Yooháani nɨ mʉláali na mʉtwe wa Ijʉva. ");
INSERT INTO lag_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ˆƗkafike sikʉ ya ngovi yo vyaalwa Heróode, muhíínja wa Herodía akavina mbere ya vaantʉ ˆvajáa valáarikirwe fʉʉrʉ Heróode akavyeenda. ");
INSERT INTO lag_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sa jeyyo Heróode akiichuunga kʉmʉheera ʉwo muhíínja kɨɨntʉ chochoosi ˆarɨ loomba ko laha. ");
INSERT INTO lag_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kʉnʉ yooheembwa nɨ íyo waavo, ʉwo muhíínja akamʉloomba Heróode yoosea, “Mpeera aha jei, mʉtwe wa Yooháani Mʉbatisáaji ikaafii.” ");
INSERT INTO lag_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aho, mʉtemi akavisʉʉla, maa kaa, sa kʉlaha ˆkweene ajáa abwéeyyiirye mbere ya vayeni, akalairirya muhíínja aheewe kɨra ˆalóombire. ");
INSERT INTO lag_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jeyyo, akalairirya Yooháani Mʉbatisáaji adʉmʉlwe mʉtwe ʉko mʉnyololwii. ");
INSERT INTO lag_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mʉtwe wa Yooháani ʉkareetwa ikaafii, maa akamʉheera ʉra muhíínja, ne muhíínja akamʉtwaarɨra íyo waavo. ");
INSERT INTO lag_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Vapooji va Yooháani vakɨɨta sʉmʉla mʉvɨrɨ wa Yooháani, maa vakɨɨta kʉʉtaaha. Maa re, vakɨɨta muwyɨɨra Yéesu isimwi roosi ˆrɨfʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yéesu ˆakateere ayo masáare, akiinʉka fuma ʉko na mashʉ́wa, maa akatamanya na kijiraawii. Maa kaa, vaantʉ ˆvakateere jeyyo, vakamutuuba na mawʉlʉ fuma maturii meevo. ");
INSERT INTO lag_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ˆAkakiime fuma mashúwii, akashaana mayɨɨmbɨ ya vaantʉ, akavoonera mbavariri na akavahorya valwɨ́ɨrɨ vaavo. ");
INSERT INTO lag_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nakyʉʉlwa vapooji vaachwe vakɨɨta kʉrɨ Yéesu, maa vakamʉsea, “Aha haantʉ nɨ kʉlɨ na kaaya ja vaantʉ, na mwaasʉ wahʉ́mwɨɨre kʉswa, rekera vaantʉ viidomere na maturii vakawʉle chóorya.” ");
INSERT INTO lag_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Maa kaa, Yéesu akavasea, “Kisiina ˆchoovabweeyya vadome tʉkʉ, vaheeri nyuunyu chóorya.” ");
INSERT INTO lag_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Maa kaa, voovo vakamʉsea, “Aha tatɨɨte mɨkáate ɨsaano na soompa ivɨrɨ vii.” ");
INSERT INTO lag_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yéesu akavasea, “Reeti na aha.” ");
INSERT INTO lag_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yéesu akalairirya ɨra mpuka ya vaantʉ viikale masaambii. Aho, akatoola ɨra mɨkáate ɨsaano na jira soompa ivɨrɨ. Akiinurirya miiso yaachwe na kurumwii, yoomʉdʉʉmba Mʉlʉʉngʉ. Akabendʉlabendʉla ɨra mɨkáate, maa akavaheera vapooji vaachwe novo vakavaheera vaantʉ. ");
INSERT INTO lag_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vaantʉ voosi vakarya, vakiikuta. Vapooji vakatoorera mabéendʉ ya mɨkáate, vakamemya vikápu ikimi na vivɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vaantʉ valʉme voosi ˆvaarya sikʉ ɨyo nɨ mayana yasaano (5,000), vaantʉ vaki na vasinga sɨ vavalwa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hahara vii, Yéesu akavadoomererya vapooji vaachwe vaambʉke mashʉ́wa, valongoole na nyambʉko ya iriva ra Galiláaya. Yeeye akachaala yookiiteengʉla na ɨra mpuka. ");
INSERT INTO lag_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ne ˆakiiteengʉle na vaantʉ, maa akaambʉka na luulwii yeemweene noo mʉloomba Mʉlʉʉngʉ. Iwʉlo ˆrɨkɨɨngɨre, akava yeemweene ʉko luulwii. ");
INSERT INTO lag_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mpɨɨndɨ ijo, ɨra mashʉ́wa ɨjáa yafíkire katɨkatɨ ya iriva. Ʉko mashʉ́wa ɨkava yoohɨtɨrwa nɨ mapúunta kʉnʉ na kʉnʉ, sa ihúmbuuto rawuváa fuma mbere yaavo. ");
INSERT INTO lag_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Namuyiingʉ, Yéesu akavadomera vapooji vaachwe kʉnʉ yooyeendera mweeri ya maaji. ");
INSERT INTO lag_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Vapooji ˆvakamoone yooyeenda mweeri ya iriva, vakakwaatwa nɨ woowa mʉnʉmʉʉnʉ, maa vakaanda kwaana ntáákwi, “Nɨ murimʉ!” ");
INSERT INTO lag_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Maa kaa, hahara Yéesu akavasea, “Fafyi mɨtɨma, nɨ nɨɨnɨ, koofi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aho, Peéteri akamʉsea Yéesu, “Mʉkʉ́lʉ, koonɨ nɨ weewe, sea nʉʉje na kwaako kʉnʉ nooyeendera mweeri ya maaji.” ");
INSERT INTO lag_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yéesu akamʉsea, “Yeenda.” Peéteri akakiima fuma mashúwii, akayeenda mweeri ya maaji yoodoma na kʉrɨ Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Maa kaa, Peéteri ˆakoone rɨra ihúmbuuto, akoofa, maa akaanda bʉrʉkɨra luujii, aho akaana ntáákwi yoosea, “Mʉkʉ́lʉ ndamurirya!” ");
INSERT INTO lag_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yéesu akawolola mʉkono waachwe chaangʉ, akamʉkwaata, maa akamʉsea, “Weewe kuruma kwaako kuduudi, sa che wiíkoverɨɨre?” ");
INSERT INTO lag_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aho, Peéteri na Yéesu vakaambʉka na mashúwii, maa ihúmbuuto rɨkaherya. ");
INSERT INTO lag_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Vapooji vara ˆvajáa mashúwii, vakamwiinamɨra voosea, “Kɨkomi, weewe ʉrɨ Mwaana wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yéesu na vapooji vaachwe ˆvakafɨrɨre iriva ra Galiláaya, maa vakafika ɨsɨ ya Genesaréeti. ");
INSERT INTO lag_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Vaantʉ va ɨra ɨsɨ ˆvakamʉtaange Yéesu, maa vakatʉma mʉlomo doma na ɨsɨ joosi ˆjiri mʉkaaya. Aho, vakamʉretera valwɨ́ɨrɨ voosi. ");
INSERT INTO lag_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Novo vakamʉloomba, Yéesu avarekere valwɨ́ɨrɨ vasaasye baa mʉkáwo vii wa nkáancho yaachwe. Na voosi ˆvamʉsaasya, vahola ndwáala jaavo. ");
INSERT INTO lag_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aho, Mafarisáayo na vakiindya va Miiro fuma Yerusaléemu vakʉʉja na kʉrɨ Yéesu, maa vakamʉsea, ");
INSERT INTO lag_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sa che vapooji vaako sɨ vatúubaa nkʉʉngʉ ja vala baaba? Voovo sɨ voóyyaa mɨkono kʉseyya njeo tʉkʉ, de varye chóorya.” ");
INSERT INTO lag_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yéesu akavasea, “Sa che nyuunyu ko tuuba nkʉʉngʉ jaanyu mwawúnaa ndairiri ja Mʉlʉʉngʉ? ");
INSERT INTO lag_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sa Mʉlʉʉngʉ asea, ‘Ʉvanyemye vala íyo na taáta waanyu,’ na ‘ʉra ˆarɨ mʉtʉkɨra íyo au taáta waavo, ʉʉlawe.’ ");
INSERT INTO lag_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Maa kaa, nyuunyu mʉndoovavariyʉrɨra vaantʉ, vandoovasea vala íyo na taáta waavo, ‘Haɨ, sɨ ndɨrɨ daha kʉvaambirirya tʉkʉ, sa ɨkɨ ˆnatɨɨte chavɨ́ɨre kɨlʉngʉlʉngʉ ˆnakera na ivarwii sa Mʉlʉʉngʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jeyyo, sɨ asaakwa amʉnyemye íyo na taáta waavo tʉkʉ. Jeyyo noo ˆvyeene muchwíjaa matɨ isáare ra Mʉlʉʉngʉ sa nkʉʉngʉ jaanyu. ");
INSERT INTO lag_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nyuunyu vakweembi, mʉláali na mʉtwe wa Ijʉva Isáaya, alʉʉsa kɨmaarɨ Masáarii ˆYarɨ Mpeho mpɨɨndɨ ˆalaaláa na mʉtwe yoosea, ");
INSERT INTO lag_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Vaantʉ ava vaanyémyaa na mɨlomo vii, maa kaa, mɨtɨma yaavo ɨrɨ kʉlɨ na nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kuunyinamɨra kwaavo nɨ ja kisiina, sa nɨ vavariyʉláa ndairiri ya vaantʉ vii.’” ");
INSERT INTO lag_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hara, Yéesu akɨɨyanɨrɨra mpuka ya vaantʉ, maa akɨɨsea, “Voosi nteereri neeja, mʉtaange ɨkɨ! ");
INSERT INTO lag_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kusiina kɨɨntʉ ˆkɨmwɨɨ́ngɨraa mʉʉntʉ mʉlomwii kɨdáhaa mʉbweeyya ave na njeo tʉkʉ. Kɨrɨ vyoova jeyyo, ˆkimufúmaa mʉlomwii noo kɨmʉbwéeyyaa mʉʉntʉ ave na njeo.” ");
INSERT INTO lag_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aho, vapooji va Yéesu vakadoma na kwaachwe, maa vakamʉsea, “Taanga wiise Mafarisáayo vakálɨɨre mʉnʉmʉʉnʉ sa rɨra isáare ˆulúusire?” ");
INSERT INTO lag_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yéesu akavasea, “Kɨra mʉhaando sɨ ˆwahaandwa nɨ Taáta wa kurumwii, kʉʉlwa ʉrɨ. ");
INSERT INTO lag_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Vareki, nɨ valongooli vahoku. Koonɨ mʉhoku amʉlóngwɨɨre mʉhoku mwiiwaachwe, voosi bʉrʉkɨra varɨ na iduundwii.” ");
INSERT INTO lag_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aho, maa Peéteri akamʉsea Yéesu, “Hoonɨ tʉwyɨɨre lusímo ʉlʉ ʉvariyuli waachwe nɨ ʉrɨkwɨ.” ");
INSERT INTO lag_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Maa Yéesu akasea, “Baa nyuunyu mʉkaarɨ sɨ mootaanga tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sɨ mootaanga kɨɨntʉ ˆkɨmwɨɨ́ngɨraa mʉʉntʉ na mʉlomwii nɨ kɨmwɨɨ́ngɨraa na indii vii, maa kɨkafuma kɨkatwaalwa na chóowii vii tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Maa kaa, kɨra ˆkimufúmaa mʉʉntʉ mʉlomwii, nɨ mutimii chafúmaa na noo kɨmʉbwéeyyaa ave na njeo. ");
INSERT INTO lag_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sa kufuma mutimii wa mʉʉntʉ, kwafúmaa miiririkano mɨvɨ, wʉʉlaishi, kʉyeenda na muki wa mʉʉntʉ, kʉhanguta, wiivi, kʉlongowererya, na kʉtʉkɨra. ");
INSERT INTO lag_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ivi noo ˆvibwéeyyaa mʉʉntʉ ave na njeo, maa kaa, kurya bila kooyya mɨkono, sɨ kʉbwéeyyaa mʉʉntʉ ave na njeo tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hara, maa Yéesu akakwaata njɨra, akadoma fʉʉrʉ ɨsɨ ja Tíiro na Sidóoni. ");
INSERT INTO lag_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aho, mʉʉntʉ muki ʉmwɨ wa Kɨkanáani wa ɨsɨ ɨra, akʉʉja na kʉrɨ Yéesu, akiiririrya yoosea, “Ee Mweenevyoosi, Sha Daúdi, naanga na riiso ra wʉʉja, muhíínja waanɨ atɨɨte murimʉ mʉvɨ na wamutúrikiryaa maatʉkʉ vii.” ");
INSERT INTO lag_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Maa kaa, Yéesu sɨ amuuyirya tʉkʉ. Aho, vapooji vakadoma na kʉrɨ Yéesu, vakamʉloomba voomʉsea Yéesu, “Mʉsee ʉhʉ mʉʉntʉ muki alooke, sa yootʉtʉʉbɨrɨra na isóso kʉnʉ nyuma sikʉ joosi.” ");
INSERT INTO lag_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yéesu akamʉsea ʉra mʉʉntʉ muki, “Natʉmwa sa muundi ˆjarɨmɨra ja Isiraéeli vii.” ");
INSERT INTO lag_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Maa kaa, ʉwo mʉʉntʉ muki akamʉseeserera Yéesu, akachwaama mbere yaachwe, maa akamʉsea, “Mweenevyoosi nyambirirya.” ");
INSERT INTO lag_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yéesu akamʉsea, “Sɨ vyabooha kʉtoola chóorya cha vasinga na ujiheere kúri tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ʉra mʉʉntʉ muki akamʉsea, “Nɨ kɨmáárɨ Mweenevyoosi, maa kaa, baa kúri jawóojeraa mangʼenyengʼenye ya chóorya cha vasinga ˆyawyíire iruungwii ra méesa ja veenenyuumba vaavo.” ");
INSERT INTO lag_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aho, Yéesu akamʉsea ʉra mʉʉntʉ muki, “Maáma, kuruma kwaako nɨ kʉkʉ́ʉ́lʉ. Na vive kwaako ja kuruma kwaako.” Na mpɨɨndɨ ɨʼɨra ʉra muhíínja waachwe akahola. ");
INSERT INTO lag_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yéesu akiinʉka fuma ɨsɨ ya Tíiro, akakwaata njɨra, maa akadoma fʉʉrʉ mbarɨmbarɨ ya iriva ra Galiláaya. Aho, akaambʉka na luulwii, maa akiikala. ");
INSERT INTO lag_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mpuka nkʉʉlʉ ya vaantʉ ɨkʉʉja na kʉrɨ Yéesu. Ɨyo mpuka yareetáa vivete, vahoku, vimumu, vaantʉ ˆvarɨ na mawʉlʉ na mɨkono sɨ ˆɨrɨ nkaasʉ na valwɨ́ɨrɨ vɨɨngɨ ˆvarɨ foo, maa vakavalaarya mawulwii ya Yéesu, ne akavahorya. ");
INSERT INTO lag_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Avo vaantʉ vakahwaalala maatʉkʉ vii, ˆvakoone vimumu voolʉʉsɨka, vivete na vaantʉ ˆvarɨ na mawʉlʉ sɨ ˆyarɨ nkaasʉ, vooyeenda na vahoku vookoona. Aho, mpuka nkʉʉlʉ ya vaantʉ sɨ ˆvarɨ Viisiraéeli, ɨkaanda mʉdʉʉmba Mʉlʉʉngʉ wa Isiraéeli. ");
INSERT INTO lag_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aho, Yéesu akavaanɨrɨra vapooji vaachwe akavasea, “Arumi, noovoonera mbavariri ava vaantʉ, viíkyɨɨre na nɨɨnɨ kwa sikʉ itatʉ na vasiina chóorya tʉkʉ. Nɨɨnɨ sɨ noosaaka kʉvateengʉla vatamanye viintʉ ˆvarɨ na njala tʉkʉ, sa vadɨɨre yɨrɨka njirii.” ");
INSERT INTO lag_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Vapooji vaachwe vakamʉsea, “Hai tʉrɨ fumya chóorya cho viikutya vaantʉ voosi ava aha nyikii?” ");
INSERT INTO lag_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yéesu akavuurya, “Mɨkáate ɨngaɨ mwatɨɨte?” Novo vakasea, “Tatɨɨte mɨkáate mufungatɨ na fisoompa fiduudi fingaɨ vii.” ");
INSERT INTO lag_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aho, Yéesu akalairirya vaantʉ viikale ɨsɨ. ");
INSERT INTO lag_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akatoola ɨra mɨkáate mufungatɨ na fira fisoompa, akamʉdʉʉmba Mʉlʉʉngʉ, akabendʉlabendʉla, akava yoovaheera vapooji vaachwe. Novo vakatuuba vaheera vaantʉ. ");
INSERT INTO lag_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Vaantʉ voosi vakarya, vakiikuta. ˆVakahʉmʉle, vakatoorera mabéendʉ ya mɨkáate ˆɨchɨ́hɨɨre, vakamemya vikápu mufungatɨ. ");
INSERT INTO lag_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Vaantʉ ˆvaarya nɨ vaantʉ valʉme mayana yanɨ (4,000) kʉreka vaantʉ vaki na vasinga. ");
INSERT INTO lag_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yéesu ˆakiiteengʉle na vaantʉ, akaambʉka mashʉ́wa, maa akadoma na Magádaanii. ");
INSERT INTO lag_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafarisáayo na Masadukáayo vakʉʉja na kʉrɨ Yéesu, maa vakaanda mʉyera, voomʉloomba avalaɨre isháara fuma kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yéesu akavasea, “Koonɨ kyʉʉlwa chɨɨ́ngɨɨre mwaséaa, ‘Lomʉtóondo kweera kʉrɨ vyabooha sa kurumu kwiiyériirye.’ ");
INSERT INTO lag_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na namʉtóondo mwaséaa, ‘Isikʉ mbula vaa ɨrɨ, sa kurumu kwasárɨre na kwiikúbutiirye.’ Nyuunyu mwamányire taanga viintʉ vya kurumu kwa ˆvyeene ko koonekana, maa kaa, kʉtaanga isháara ja mpɨɨndɨ iji sɨ mwamányire tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mbyaala mbɨ ya vaantʉ ˆvayéendaa na vaki va vaantʉ, sɨ moosaaka kʉmʉtaanga Mʉlʉʉngʉ tʉkʉ, noo ˆchooreka mooloomba isháara! Sɨ mʉrɨ heewa isháara tʉkʉ, maa kaa, ɨra isháara ya Yóona mʉláali na mʉtwe vii.” Aho, Yéesu akavareka, maa akalooka na vapooji waachwe. ");
INSERT INTO lag_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Vapooji vaachwe vakafɨrɨra iriva, vakava varímiirye sʉmʉla mɨkáate. ");
INSERT INTO lag_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aho, Yéesu akavasea, “Mʉlaange neeja mʉnehe ʉsasɨ wa Mafarisáayo na wa Masadukáayo.” ");
INSERT INTO lag_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Vapooji vakaanda kwiiruta ndihi voovo kwa voovo voosea, “Alúusire jei sa viintʉ sɨ taréetire mɨkáate.” ");
INSERT INTO lag_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yéesu akataanga, kwiiruta kwaavo ndihi, maa akavasea, “Nyuunyu kuruma kwaanyu kuduudi, sa che mookiiruta ndihi nyuunyu kwa nyuunyu, sa viintʉ musiina mɨkáate? ");
INSERT INTO lag_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mʉkaarɨ sɨ mʉnataanga vii tʉkʉ wʉʉ? Sɨ mookʉmbʉkɨra ɨra mɨkáate ɨsaano ˆyarɨɨwa nɨ vaantʉ mayana yasaano (5,000), na nɨ makápu yangaɨ mwatoorera ya mabéendʉ ya mɨkáate tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na ɨra mɨkáate mufungatɨ ˆyarɨɨwa nɨ vaantʉ mayana yanɨ (4,000), nɨ makápu yangaɨ mwatoorera ya mabéendʉ ya mɨkáate? ");
INSERT INTO lag_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sa che sɨ mootaanga sɨ nalúusire masáare ya mɨkáate tʉkʉ? Laangi neeja, nehi ʉsasɨ wa Mafarisáayo na Masadukáayo!” ");
INSERT INTO lag_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aho, vapooji vakataanga Yéesu sɨ aseáa valaange neeja ʉsasɨ wa mɨkáatii tʉkʉ, maa kaa, valaange neeja ukiindya wa Mafarisáayo na wa Masadukáayo. ");
INSERT INTO lag_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aho, Yéesu akadoma na ɨsɨ ya Kaisaría Filíipi. ˆAkafike ʉko, Yéesu akavuurya vapooji vaachwe yoosea, “Vaantʉ vaséaa Mwaana wa Mʉʉntʉ nɨ ani?” ");
INSERT INTO lag_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vakasea, “Vamwɨ vaséaa ʉrɨ Yooháani Mʉbatisáaji, vɨɨngɨ Elía na vɨɨngɨ Yeremía au ʉmwɨ wa valáali na mʉtwe.” ");
INSERT INTO lag_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aho, akavuurya, “Ha nyuunyu mwaséaa ndɨrɨ ani?” ");
INSERT INTO lag_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simóoni Peéteri akamʉsea, “Weewe nɨ Masía, Mwaana wa Mʉlʉʉngʉ ˆarɨ nkaasʉ.” ");
INSERT INTO lag_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aho, Yéesu akamʉsea, “Watalariwa weewe Simóoni mwaana wa Yóona, sa isáare ɨrɨ sɨ ʉtʉ́ʉnʉkʉrɨɨrwe nɨ mʉʉntʉ tʉkʉ, maa kaa, nɨ Taáta waanɨ wa kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nɨ kuwyɨɨra niise, weewe noo Peéteri, na mweeri ya mwaalaliwye ʉhʉ, kiimya ndɨrɨ mpuka ya vaantʉ vaanduma, baa ngururu ja Ntarii sɨ jiri daha kwiisiinda tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kʉheera ndɨrɨ fʉngʉ́wo ja Ʉtemi wa Kurumwii. Isáare roroosi ˆʉrɨ chuunga aha weerwii kwa irina raanɨ, kʉva rɨrɨ rachúungirwe kurumwii nɨ Mʉlʉʉngʉ. Na isáare roroosi ˆʉrɨ chʉngʉla aha weerwii kwa irina raanɨ, kʉva rɨrɨ rachʉ́ngwɨɨrwe kurumwii nɨ Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aho, Yéesu akavakaanʼya vapooji vaachwe karɨ vamuwyɨ́ɨraa mʉʉntʉ yoyoosi yeeye nɨ Masía tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kwaandɨra mpɨɨndɨ ɨyo, Yéesu ajáa aanda vawyɨɨra vapooji vaachwe yoosea nɨ mpaka adome na Yerusaléemu, na ʉko nɨ mpaka apate uturikiri mʉkʉʉlʉ. Ajáa avasea, turikiriwa arɨ nɨ vawosi, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro na nɨ mpaka ʉʉlawe. Sikʉ ya katatʉ nɨ mpaka afʉfʉlwe. ");
INSERT INTO lag_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aho, Peéteri akamʉsʉmʉla Yéesu na ivarwii, maa akaanda mʉbaamirirya yoosea, “Mʉkʉ́lʉ, ayo sɨ yarɨ kʉpata sikʉ baa ɨmwɨ vii tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yéesu akamʉvalandʉkɨra Peéteri akamʉsea, “Irimʉ! Isunke mbere yaanɨ, wookʉʉnhɨtahɨta, sɨ wookiiririkana masáare ya Mʉlʉʉngʉ tʉkʉ, wookiiririkana ya vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aho, Yéesu akavasea vapooji vaachwe, “Koonɨ mʉʉntʉ yoyoosi yoosaaka aantuube nɨ mpaka iisiite yeemweene, avaale mʉsaláaba waachwe kɨra siikʉ, aantuube. ");
INSERT INTO lag_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sa koonɨ mʉʉntʉ yoyoosi yoosaaka lamurirya nkaasʉ yaachwe, kɨɨtaaha arɨ, maa kaa, mʉʉntʉ yoyoosi ˆyookɨɨtaaha nkaasʉ yaachwe sa nɨɨnɨ, ʉwo lamurirya arɨ. ");
INSERT INTO lag_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kwatɨɨte kʉnáálo che mʉʉntʉ kuturya weerʉ yoosi no kɨɨtaaha nkaasʉ yaachwe? Bakʉ nɨ kɨɨntʉ che mʉʉntʉ arɨ toola sa nkaasʉ yaachwe? ");
INSERT INTO lag_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sa Mwaana wa Mʉʉntʉ kʉʉja arɨ na nkongojima ya Taáta na mirimʉ miija, aho kʉmʉrɨha arɨ kɨra mʉʉntʉ kwa kɨra ˆatʉmama. ");
INSERT INTO lag_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kɨmaarɨ noovawyɨɨra, vamwaarɨ vɨɨngɨ viímire aha, sɨ varɨ kukwya tʉkʉ mpaka vamoone Mwaana wa Mʉʉntʉ yookʉʉja Ʉtemii waachwe.” ");
INSERT INTO lag_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sikʉ mʉsasatʉ ˆjikalooke, Yéesu akamʉsʉmʉla Peéteri, Yaakúupu na mwaanaavo Yooháani, maa akaambʉka novo na luulwii ncholwii kijiraawii. ");
INSERT INTO lag_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mpɨɨndɨ vajáa ʉko, akavalandʉka buuwo mbere yaavo. Kisho chaachwe kɨkalava ja mwaasʉ na ɨngo jaachwe jikava njerʉ chwee, ja kɨweerʉ cha mwaasʉ. ");
INSERT INTO lag_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Koonka, Mʉ́sa na Elía vakavafʉmɨra, maa vakalʉʉsɨka ne. ");
INSERT INTO lag_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aho, Peéteri akamʉsea Yéesu, “Aaɨ Mʉkʉ́lʉ, vyabooha tʉveere haaha aha. Ndekera njeenge vivaanda vitatʉ, kɨmwɨ chaako, kɨmwɨ cha Mʉ́sa na kɨmwɨ cha Elía.” ");
INSERT INTO lag_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Viintʉ Peéteri ˆajáa akaarɨ yoolʉʉsɨka, ichu ˆroolava rɨkavawɨɨkɨra. Sawúti ɨkafuma aho ichwii yoosea, “Ʉhʉ nɨ Mwaana waanɨ ˆnamweenda, ˆneériwaa mʉtɨma nɨ yeeye, mʉteereri yeeye.” ");
INSERT INTO lag_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Vara vapooji ˆvakateere jeyyo, vakalaala ɨsɨ na ɨnda nɨ woowa. ");
INSERT INTO lag_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Maa kaa, Yéesu akʉʉja, akavasaasya, maa akavasea, “Inuki. Koofi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Avo vapooji ˆvakiinule miiso, vakamoona Yéesu yeemweene, sɨ vamoona mʉʉntʉ wɨɨngɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mpɨɨndɨ ˆvagiritáa fuma luulwii, Yéesu akavalairirya yoosea, “Karɨ mumuwyɨ́ɨraa mʉʉntʉ yoyoosi masáare aya tʉkʉ, fʉʉrʉ sikʉ Mwaana wa Mʉʉntʉ ˆarɨ fʉfʉka fuma inkwyii.” ");
INSERT INTO lag_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Vapooji vajáa vamuurya, “Sa che vakiindya va Miiro vaséaa nɨ mpaka Elía ʉʉje ta?” ");
INSERT INTO lag_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yéesu ajáa avasea, “Nɨ kɨmáárɨ Elía nɨ mpaka ʉʉje ta avɨɨke neeja masáare yoosi. ");
INSERT INTO lag_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Maa kaa, nɨ kʉvawyɨɨra niise, Elía ahʉmʉla kʉʉja, novo sɨ vamʉtaanga tʉkʉ, na vamʉbweeyyirya ʉvɨ ja ˆvyeene vasaaka. Viivyo Mwaana wa Mʉʉntʉ tamanya iise noo turikiriwa mɨkonwii yaavo.” ");
INSERT INTO lag_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aho, vapooji vakataanga nɨ lʉʉsɨkɨra aarɨ masáare ya Yooháani Mʉbatisáaji. ");
INSERT INTO lag_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yéesu na vapooji vaachwe ˆvakagirite fuma luulwii, vakafika kʉʉntʉ ˆkʉjáa na ɨra mpuka ya vaantʉ. Mʉʉntʉ ʉmwɨ akamʉdomera Yéesu, akachwaama mbere yaachwe yoosea, ");
INSERT INTO lag_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Mʉkʉ́lʉ, mʉlaange mwaana waanɨ na riiso ra wʉʉja. Yeeye atɨɨte kiinkwiisha ˆchamutúrikiryaa maatʉkʉ vii. ˆKarɨ foo chamʉváyyaa mootwii na mpɨɨndɨ jɨɨngɨ luujii. ");
INSERT INTO lag_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namʉréetire na kwa vapooji vaako vamʉhorye, maa kaa, vasíindirwe.” ");
INSERT INTO lag_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aho, Yéesu akavasea, “Aka! Ɨhɨ mbyaala sɨ irúmaa na yakɨɨkana. Niikale na nyuunyu mpaka naadi? Na nɨvayimirirye mpaka naadi? Hoonɨ mʉreeti na aha.” ");
INSERT INTO lag_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aho, Yéesu akʉʉyamirirya ʉra murimʉ mʉvɨ, maa ʉkafuma na hahara mʉtavana akahola. ");
INSERT INTO lag_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mpɨɨndɨ ˆkʉjáa kusiina vaantʉ, vapooji vakadoma na kʉrɨ Yéesu, maa vakamuurya kʉnʉ varɨ vooveene voosea, “Sa che suusu tasíindirwe kʉʉseyya ʉra murimʉ mʉvɨ?” ");
INSERT INTO lag_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yéesu akavasea, “Sa viintʉ kuruma kwaanyu nɨ kudúúdi. Kɨmaarɨ noovawyɨɨra, koonɨ kuruma kwaanyu kʉrɨ kudúúdi ja mpeke nduudi ya haradáali, sea mʉrɨ lʉʉlʉ ʉlʉ, ‘Isunke aha ʉdome na kʉra na kwiisʉnka lʉrɨ.’ Kʉrɨ nyuunyu kusiina kɨɨntʉ ˆkɨrɨ vasiinda tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Maa kaa, murimʉ mʉvɨ ja ʉhʉ sɨ mʉrɨ daha kuukibirya bila yoomʉloomba Mʉlʉʉngʉ, no kiirekya kurya tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mpɨɨndɨ Yéesu ˆajáa na vapooji vaachwe ʉko Galiláaya, ajáa avasea, “Mwaana wa Mʉʉntʉ valandʉkwa iise avɨɨkwe mɨkonwii ya vaantʉ, ");
INSERT INTO lag_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kʉmʉʉlaa varɨ, maa kaa, sikʉ ya katatʉ fʉfʉlwa arɨ.” Vapooji vaachwe ˆvakateere jeyyo, vakavisʉʉla maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yéesu na vapooji vaachwe ˆvakafike múuji wa Kaperenáumu, vasaankanʼyi kóodi ya Kaaya Njija ya Ijʉva vakʉʉja na kʉrɨ Peéteri, maa vakamuurya, “Eri, mukiindya waanyu sɨ arɨ́haa kóodi ya Kaaya Njija?” ");
INSERT INTO lag_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peéteri akavasea, “Hɨɨ, arɨ́haa.” Peéteri ˆakahɨndʉke na kaayii, baa sɨ analʉʉsa chochoosi, Yéesu akava wa ncholo kʉlʉʉsɨkɨra isáare ra kóodi. Akamuurya Peéteri, “Simóoni, weewe joolɨ wookoona? Vatemi va ɨhɨ weerʉ vasáankanʼyaa kóodi fuma kwa vaana vaavo, bakʉ fuma kwa vaantʉ vɨɨngɨ?” ");
INSERT INTO lag_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peéteri akamʉsea, “Fuma kwa vaantʉ vɨɨngɨ.” Yéesu akamʉsea, “Koonɨ nɨ jeyyo, vaana varekerwa vadɨɨre kʉrɨha kóodi. ");
INSERT INTO lag_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Maa kaa, sa tʉdɨɨre kʉvakalarya, doma na irivii ʉkawʉmɨre ndowáno. Soompa ya ncholo ˆʉrɨ kwaata, asamya mʉlomo waachwe, shaana ʉrɨ mpía mʉlomwii waachwe. Toola ɨyo mpía, doma kwaavo, ʉkarɨhe kóodi yaanɨ na yaako.” ");
INSERT INTO lag_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mpɨɨndɨ jira, vapooji vajáa vʉʉja na kʉrɨ Yéesu, maa vakamuurya, “Eri, nɨ ani noo mʉkʉʉlʉ kʉlookya voosi Ʉtemii wa Kurumwii?” ");
INSERT INTO lag_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aho, Yéesu akamwaanɨrɨra musinga muduudi, akamwiimya katɨkatɨ yaavo, ");
INSERT INTO lag_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","maa akavasea vapooji vaachwe, “Kɨmaarɨ noovawyɨɨra, koonɨ sɨ mʉválandukire mʉve ja vasinga vaduudi, kɨkomi sɨ mʉrɨ kɨɨngɨra vii tʉkʉ Ʉtemii wa Kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sa jeyyo, mʉʉntʉ yoyoosi ˆarɨ kiikiimya na ɨsɨ ja ʉhʉ musinga, noo mʉkʉʉlʉ kʉlookya voosi Ʉtemii wa Kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yoyoosi ˆarɨ mʉteengya musinga muduudi ja ʉhʉ kwa irina raanɨ, va arɨ yookʉʉnteengya nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Maa kaa, koonɨ mʉʉntʉ arɨ mʉhaanda ʉmwɨ wa ava vadúúdi ˆvaanduma atʉmame ʉvɨ, nɨ pwee kwaachwe achʉʉngɨrwe lwaala nkiingwii yaachwe, aburukiriwe katɨ na katɨ ya mayɨya. ");
INSERT INTO lag_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nɨ mpolaɨ kʉrɨ weerʉ sa yara masáare ˆyaháandaa vaantʉ vabweeyye ʉvɨ. Kʉyerwa nɨ mpaka kʉʉje vii, maa kaa, nɨ mpolaɨ kwa ʉra mʉʉntʉ, ʉra ˆyooreeta ʉko kʉyerwa. ");
INSERT INTO lag_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Koonɨ iyaanja au ijeo raako rakʉháandire ʉbweeyye ʉvɨ, dʉmʉla ʉrɨfweite na kʉlɨ. Nɨ pwee yaako wɨɨngɨre nkaaswii, ʉrɨ iduúmu au ikoónchi kʉlookya kɨɨngɨra mootwii sɨ ˆurímaa wa sikʉ ˆjisiina ʉhero ʉrɨ na mayaanja yavɨrɨ na majeo yavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na koonɨ riiso raako rakʉháandire ʉbweeyye ʉvɨ, rɨnonkole ʉrɨfweite na kʉlɨ. Nɨ pwee yaako wɨɨngɨre na nkaaswii, ˆʉrɨ ipoócho kʉlookya kʉfweitɨrwa na mootwii wa Jehénamu ˆʉrɨ na miiso yoosi. ");
INSERT INTO lag_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mʉlaange neeja, karɨ musínanalaa ʉmwɨ wa ava vadúúdi tʉkʉ, sa nɨ kʉvawyɨɨra niise, mirimʉ yaavo miija, sikʉ joosi yoónaa kisho cha Taáta waanɨ wa kurumwii.  ");
INSERT INTO lag_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sa Mwaana wa Mʉʉntʉ ʉʉja jo saakɨra no lamurirya kɨra ˆcharɨmɨra. ");
INSERT INTO lag_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Joolɨ mookoona? Koonɨ ʉmwɨ waanyu arɨ na muundi makumi ikimi (100), na muundi ɨmwɨ yarɨ́mɨɨre, che arɨ bweeyya? Sɨ arɨ reka jira muundi makumi keenda na keenda (99) luulwii, adome akasaake ɨra ɨmwɨ ˆyatáahikire tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ˆArɨ kɨɨpata, kɨmaarɨ noovawyɨɨra, kʉva arɨ na cheerʉ maatʉkʉ vii sa ɨyo muundi ɨmwɨ kʉlookya viintʉ ˆavyeéndaa sa jira muundi makumi keenda na keenda sɨ ˆjarɨ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Viivyo, Taáta waanyu wa kurumwii sɨ asáakaa baa ʉmwɨ wa ava vadúúdi arɨmɨre tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Koonɨ mwaanaanyu ahóniirye kwaako, doma ʉkamʉwyɨɨre ʉvɨ waachwe, ʉve weewe na yeeye vii. Koonɨ akʉtéɨɨre, ʉmʉpátire mʉndʉʉ waako kei. ");
INSERT INTO lag_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Maa kaa, koonɨ sɨ akʉtéɨɨre, tamanya na mʉʉntʉ wɨɨngɨ ʉmwɨ au vavɨrɨ, sa ‘Kɨra kɨloongi lamʉlwa kɨrɨ kwa vooni vavɨrɨ au vatatʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Koonɨ asíitire vateera avo, wyɨɨra mpuka yaako ya vaantʉ ˆvaanduma. Koonɨ asíitire kʉvateerera vaantʉ ˆvaanduma, mʉbweeyye kwaako ja mʉʉntʉ sɨ ˆamʉmányire Mʉlʉʉngʉ au ja mʉsaankanʼyi kóodi. ");
INSERT INTO lag_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kɨmaarɨ noovawyɨɨra, isáare roroosi ˆmʉrɨ chuunga aha weerwii, kʉva rɨrɨ rachúungirwe kurumwii nɨ Mʉlʉʉngʉ. Na isáare roroosi ˆmʉrɨ rɨchʉngʉla aha weerwii, kʉva rɨrɨ rachʉ́ngwɨɨrwe kurumwii nɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kei kɨmaarɨ noovawyɨɨra, koonɨ vaantʉ vavɨrɨ viirʉ́mɨɨre aha weerwii kwa isáare roroosi ˆvarɨ loomba, Taáta waanɨ wa kurumwii vaheera arɨ. ");
INSERT INTO lag_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sa hohoosi hara ˆvarɨ kiijiinga vaantʉ vavɨrɨ au vatatʉ kwa irina raanɨ, nɨɨnɨ kʉva ndɨrɨ hamwɨ novo.” ");
INSERT INTO lag_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Aho, Peéteri akʉʉja na kʉrɨ Yéesu, maa akamuurya, “Mʉkʉ́lʉ, mwaaniitʉ aahonerye kangaɨ na ntuube mʉsea yasírire? Eri, baa fʉʉrʉ mufungatɨ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yéesu akamʉsea, “Sɨ nookʉsea mara mufungatɨ vii tʉkʉ, maa kaa, mufungatɨ mara makumi mufungatɨ (7x70).” ");
INSERT INTO lag_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Sa jeyyo, Ʉtemi wa Kurumwii wiifwɨ́ɨne na lusímo ʉlʉ. Mʉtemi ʉmwɨ asaakáa sʉmʉla mpía jaachwe ˆngʼeene adaayyáa fuma kwa vatʉ́mwa vaachwe. ");
INSERT INTO lag_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ˆAkaande ʉwo mʉrɨmo, akareterwa mʉʉntʉ ʉmwɨ ˆajáa na noongwa ya taláanta mayana ikimi rɨmwɨ (10,000). ");
INSERT INTO lag_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ʉwo mʉtʉ́mwa akava asiina cho rɨha tʉkʉ. Sa jeyyo, mweenenyuumba waachwe akalamʉla avawe iyoombe yeeye, muki waachwe, vaana vaachwe, na viintʉ vyaachwe vyoosi sa ɨyo noongwa ɨrɨhwe. ");
INSERT INTO lag_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aho, ʉra mʉtʉ́mwa akachwaama mbere yaachwe, akamʉsea, ‘Ee Mʉkʉ́lʉ, yimirirya, kʉrɨha ndɨrɨ noongwa yaako yoosi.’ ");
INSERT INTO lag_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mʉtemi akamoonera mbavariri, akasea ɨra noongwa yasírire, maa akamʉrekera alooke. ");
INSERT INTO lag_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Maa kaa, ʉra mʉtʉ́mwa ˆakafike weerwii, akalʉmana na mʉtʉ́mwa mwiiwaachwe ˆmweene ajáa na noongwa yaachwe ya mpía ja dináari igana rɨmwɨ (100). Aho, akamʉkwaata, maa akamukurukanʼya nkiingwii kʉnʉ yoomʉsea, ‘Rɨha noongwa yaanɨ!’ ");
INSERT INTO lag_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ʉra mʉtʉ́mwa mwiiwaachwe akachwaama, akiilomboola yoosea, ‘Nookʉloomba yimirirya, rɨha ndɨrɨ noongwa yaako yoosi vʉʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ʉra mʉtʉ́mwa akasiita gɨgɨrɨ. Aho, akatamanya noo mʉvɨɨka mʉnyololwii mpaka arɨhe noongwa yoosi. ");
INSERT INTO lag_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Vatʉ́mwa viivaachwe ˆvakoone ˆcheene ʉwo mʉtʉ́mwa amʉbwéeyyiriirye mwiiwaachwe, vakakalala maatʉkʉ vii, maa vakɨɨta muwyɨɨra mweenenyuumba waavo ˆcheene kɨfʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mʉtemi akamwaanɨrɨra ʉra mʉtʉ́mwa, maa akamʉsea, ‘Weewe ʉrɨ mʉtʉ́mwa mʉvɨ. Nɨɨnɨ naséire noongwa yaako yasírire sa wʉʉnóombire. ");
INSERT INTO lag_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eri, sɨ vyaasaakwa baa weewe ʉmʉlaange mwiiwaako na riiso ra wʉʉja ja ˆvyeene nɨɨnɨ nakʉláangire na riiso ra wʉʉja tʉkʉ wʉʉ?’ ");
INSERT INTO lag_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aho, mʉtemi na nkalari akamʉtwaala ʉra mʉtʉ́mwa na mʉnyololwii, ʉko aturikiriwe mpaka arɨhe noongwa yoosi vʉʉ. ");
INSERT INTO lag_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Viivyo baa Taáta waanɨ wa kurumwii arɨ vabweeyyirya kɨra ʉmwɨ waanyu koonɨ sɨ amʉséire mwiiwaachwe yasírire na mʉtɨma waachwe woosi.” ");
INSERT INTO lag_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yéesu ˆakamarikirye kʉlʉʉsɨka masáare aya, akalooka fuma Galiláaya, akatamanya fʉʉrʉ ɨsɨ ya Yudéea nyambʉko ya lʉʉjɨ lwa Yorodáani. ");
INSERT INTO lag_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mpuka nkʉʉlʉ ya vaantʉ ɨkamutuuba, ʉko akavahorya. ");
INSERT INTO lag_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Vamwɨ va Mafarisáayo vakʉʉja noo mʉyera. Vakamuurya voosea, “Eri, Miiro yaruma mʉʉntʉ kʉmʉreka muki waachwe sa kɨɨntʉ chochoosi wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Akuuyirya akavasea, “Sɨ mʉnasoma tʉkʉ wʉʉ? Masáare ˆYarɨ Mpeho yalʉʉsa, aho ncholo, Mʉʉ́mba ‘ajáa avʉʉmba mʉʉntʉ mʉlʉme na mʉʉntʉ muki,’ ");
INSERT INTO lag_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ne akasea, ‘Sa jeyyo, mʉʉntʉ mʉlʉme avarékaa vala íyo na taáta waavo, akava kɨɨntʉ kɨmwɨ na muki waachwe, novo vavɨrɨ kʉva varɨ mʉvɨrɨ ʉmwɨ.’ ");
INSERT INTO lag_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sa jeyyo, sɨ varɨ kʉva vavɨrɨ tʉkʉ, nɨ mʉvɨrɨ ʉmwɨ. Jeyyo, ˆcheene akɨlʉmanʼya Mʉlʉʉngʉ, mʉʉntʉ sɨ arɨ nanʉkʉla tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aho, vakamʉsea, “Sa che de Mʉ́sa atʉrʉmɨra kʉmwaandɨkɨra muki taláka no mʉreka?” ");
INSERT INTO lag_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yéesu akavasea, “Mʉ́sa avarekera mʉndooreka vadala vaanyu, sa ʉfafu wa mɨtɨma yaanyu. Maa kaa, keende aho ncholo sɨ vijáa jeyyo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nɨ kʉvawyɨɨra niise, mʉʉntʉ yoyoosi ˆarɨ musiita muki waachwe koonɨ sɨ sa kʉyeenda na mʉlʉme wa mʉʉntʉ, maa aloole muki wɨɨngɨ, ʉwo kʉva arɨ yooyeenda na muki wa mʉʉntʉ.” ");
INSERT INTO lag_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aho, vapooji vaachwe vakamʉsea, “Koonɨ noo ˆviri jeyyo kwa muki na mʉlʉme, nɨ vyaangʉ kʉdɨɨra kʉloola!” ");
INSERT INTO lag_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeeye akavasea, “Sɨ voosi varɨ daha ruma ukiindya ʉhʉ tʉkʉ, maa kaa, vara ˆvaámbiririwaa nɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vaantʉ vɨɨngɨ vavyaalwa matowáashi, vɨɨngɨ vabweeyyiwa matowáashi nɨ vaantʉ, na vɨɨngɨ valamʉla kʉva matowáashi sa Ʉtemi wa Kurumwii. Ʉra ˆarɨ daha hokera ukiindya ʉhʉ nɨ ʉʉhokere.” ");
INSERT INTO lag_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Aho, vasinga vaduudi vakareetwa na kʉrɨ Yéesu sa avavɨkɨre mɨkono yaachwe na avaloombere. Maa kaa, vapooji vaachwe vakavaamirirya vara vaantʉ ˆvavareetáa. ");
INSERT INTO lag_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yéesu akavasea, “Vareki vasinga vaduudi vʉʉje na kʉrɨ nɨɨnɨ, karɨ mʉvakɨtɨre tʉkʉ! Sa Ʉtemi wa Kurumwii nɨ sa vaantʉ ˆvarɨ ja ava vasinga.” ");
INSERT INTO lag_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aho, Yéesu akavatalarya avo vasinga, maa akiinʉka aho haantʉ. ");
INSERT INTO lag_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Haaha, mʉʉntʉ ʉmwɨ akʉʉja na kʉrɨ Yéesu, maa akamuurya, “Mukiindya, nɨ kɨɨntʉ che kiija ndɨrɨ bweeyya sa mpokere nkaasʉ ya sikʉ ˆjisiina ʉhero?” ");
INSERT INTO lag_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yéesu akamʉsea, “Sa che wookuunjurya kɨɨntʉ kiija? Kwatɨɨte ʉmwɨ vii noo mʉʉja. Koonɨ woosaaka ʉpate nkaasʉ ya sikʉ ˆjisiina ʉhero, kwaatya ndairiri jaachwe.” ");
INSERT INTO lag_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ʉwo mʉʉntʉ akamuurya, “Ʉlairiri ʉrɨkwɨ?” Yéesu akamʉsea, “Karɨ wʉʉ́laa tʉkʉ, karɨ ʉyéendaa na muki wa mʉʉntʉ tʉkʉ, karɨ wiívaa tʉkʉ, karɨ ʉlóngowereryaa mʉʉntʉ tʉkʉ, ");
INSERT INTO lag_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ʉvanyemye vala íyo na taáta waanyu, na mweende mwiiwaako ja ˆvyeene wiiyenda mweeneevyo.” ");
INSERT INTO lag_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ʉwo mʉtavana akamʉsea, “Ayo yoosi nayakwaatya, che kei chookeeheka kʉrɨ nɨɨnɨ?” ");
INSERT INTO lag_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yéesu akamʉsea, “Koonɨ woosaaka ʉve usiina ˆchakeeheka kwaako, tamanya ʉkavae iyoombe máari ˆʉrɨ nojo na mpía ˆʉrɨ turya ʉvaheere vakɨva. Jeyyo, turya ʉrɨ máari ya kɨkomi ya mberii kurumwii. Aho, yeenda wuuntuube.” ");
INSERT INTO lag_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ʉwo mʉtavana ˆakateere jeyyo, akiirya mʉtɨma, maa akalooka, sa nɨ musúngaati maatʉkʉ vii ajáa. ");
INSERT INTO lag_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aho, Yéesu akavasea vapooji vaachwe, “Kɨmaarɨ noovawyɨɨra, kʉva viri vyafafa maatʉkʉ vii kwa vasúngaati kwɨɨngɨra Ʉtemii wa Kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kei nɨ kʉvawyɨɨra niise, nɨ vyaangʉ ngamɨ́a kʉtweera na ihengerii ra sinkeni kʉlookya musúngaati kwɨɨngɨra na Ʉtemii wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Vapooji ˆvakateere ayo, vakatʉlʉvalatʉlʉvaala, maa vakamʉsea, “Nɨ ani de ˆarɨ daha lamuririwa?” ");
INSERT INTO lag_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yéesu akavatuurirya miiso, maa akavasea, “Kwa vaantʉ sɨ vidáhɨkaa tʉkʉ, maa kaa, kwa Mʉlʉʉngʉ viintʉ vyoosi vyadáhɨkaa.” ");
INSERT INTO lag_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aho, Peéteri akamʉsea, “Laanga! Suusu tareka kɨra kɨɨntʉ tʉkakutuuba. Che tʉrɨ turya?” ");
INSERT INTO lag_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yéesu akavasea, “Kɨmaarɨ noovawyɨɨra, mpɨɨndɨ viintʉ vyoosi ˆviri bweeyyiwa ufya, Mwaana wa Mʉʉntʉ kiikala arɨ ichuumbii ra kɨtemi ra nkongojima. Na nyuunyu vara ˆmuuntúubaa, kiikala mʉrɨ machuumbii ikimi na yavɨrɨ moojilamʉrɨra nkolo ikimi na ivɨrɨ ja Isiraéeli. ");
INSERT INTO lag_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na kɨra mʉʉntʉ ˆareka nyuumba, au vaanaavo, au marʉʉmbʉ, au taáta, au íyo, au vaana, au mawʉnda sa nɨɨnɨ, hokera arɨ mara igana rɨmwɨ (100) kʉlookererya, na hokera arɨ nkaasʉ ya sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Maa kaa, vara va ncholo veera varɨ mukirii, na vara va mukirii kʉva varɨ va ncholo. ");
INSERT INTO lag_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ʉtemi wa Kurumwii, wiifwɨ́ɨne na mʉʉntʉ ˆajáa na iwʉnda ra mɨsabíibu. Ʉwo ajáa afuma namʉtóondo noo saaka vibarʉ́wa sa iwundii kwaachwe. ");
INSERT INTO lag_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Akiirʉmɨra novo kʉvarɨha mpía ya dináari ɨmwɨ kwa sikʉ, maa akavatwaala na iwundii raachwe ra mɨsabíibu. ");
INSERT INTO lag_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mpɨɨndɨ jo yʉʉrɨra ngʼoombe, akafuma, akashaana vɨɨngɨ viímire isóokwii baa mʉrɨmo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akavasea, ‘Baa nyuunyu tamanyi na iwundii raanɨ ra mɨsabíibu mʉkatʉmame, na nɨɨnɨ varɨha ndɨrɨ kɨra ˆcheene Miiro yaruma.’ ");
INSERT INTO lag_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jeyyo vakatamanya. Ʉwo mweeneiwʉnda akafuma kei mpɨɨndɨ ja mpoloonge, na mpɨɨndɨ ja cháámuusi, akabweeyya vivira. ");
INSERT INTO lag_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Baa mpɨɨndɨ jo fyʉʉla ngʼoombe akafuma kei. Aho isóokwii, akashaana vaantʉ vɨɨngɨ viímire, maa akavuurya, ‘Sa che mwiímire aha chobu baa mʉrɨmo tʉkʉ?’ ");
INSERT INTO lag_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Novo vakamʉsea, ‘Sa kusiina mʉʉntʉ ˆatʉhɨ́ɨre mʉrɨmo tʉkʉ.’ Yeeye akavasea, ‘Baa nyuunyu tamanyi mʉkatʉmame iwundii raanɨ ra mɨsabíibu.’ ");
INSERT INTO lag_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ˆƗkafike niiwʉlo, mweeneiwʉnda ra mɨsabíibu akamʉsea mʉtʉmami ˆɨɨ́mɨrɨraa vatʉmami vaachwe, ‘Vaanɨrɨre vatʉmami voosi ʉvarɨhe mʉsáala waavo. Waandɨre na ʉra ˆakíimikiriirye fʉʉrʉ ʉra wa ncholo.’ ");
INSERT INTO lag_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Vara vatʉmami ˆvajáa vaheewa mʉrɨmo mpɨɨndɨ jo fyʉʉla ngʼoombe, kɨra mʉʉntʉ akarɨhwa mpía ya dináari ɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Vara va ncholo ˆvakʉʉje, vakiisea rɨhwa varɨ ˆjiri foo kʉlookya vara vɨɨngɨ. Maa kaa, kɨra mʉʉntʉ akarɨhwa mpía ya dináari ɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Vakahokera mpía jaavo, maa vakaanda mʉngʼʉʉrɨra mweeneiwʉnda, ");
INSERT INTO lag_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","voosea, ‘Vaantʉ ava ʉvahɨ́ɨre mʉrɨmo mpɨɨndɨ jo fyʉʉla ngʼoombe vatʉ́mamire kwa isaa rɨmwɨ vii. Ha de joolɨ ʉvaríhire hamwɨ na suusu ˆtayímiriirye uruto wa mʉrɨmo na ivááva ra mwaasʉ chobu?’ ");
INSERT INTO lag_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Aho, ʉra mweeneiwʉnda akamʉsea ʉmwɨ waavo, ‘Kɨjeengi, sɨ nakʉkwáatire matu tʉkʉ! Eri, sɨ twaarɨ twiirʉ́mɨɨre marɨho ya mpía ya dináari ɨmwɨ tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sʉmʉla kɨra ˆkɨkʉtéire, wiitamanyirye. Nɨɨnɨ nalámwɨɨre kʉmʉheera ʉhʉ akíimikiriirye hamwɨ na weewe. ");
INSERT INTO lag_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eri, Miiro sɨ yaruma nɨɨnɨ kutumia máari jaanɨ ja ˆvyeene noosaaka tʉkʉ wʉʉ? Eri, wookoona ʉsʉʉngʉ sa viintʉ nɨɨnɨ naboohya ɨnda wʉʉ?’ ” ");
INSERT INTO lag_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yéesu akamʉsea, “Jeyyo, vara va mukirii, kʉva varɨ va ncholo, na vara va ncholo, kʉva varɨ mukirii.” ");
INSERT INTO lag_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mpɨɨndɨ Yéesu ˆaambʉkáa na Yerusaléemu, ajáa avasʉmʉla vapooji vaachwe ikimi na vavɨrɨ na ivarwii. Aho, akavasea, ");
INSERT INTO lag_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nɨ kaambʉka tiise na Yerusaléemu, na Mwaana wa Mʉʉntʉ vɨɨkwa arɨ mɨkonwii ya vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro. Voovo lʉʉsa varɨ irya akwye. ");
INSERT INTO lag_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kʉmʉkwaatya varɨ mɨkonwii ya vaantʉ sɨ ˆvarɨ Vayahúudi sa vamʉvae mɨjeléedi na vamuningʼinʼye mʉsaláabii fʉʉrʉ akwye. Maa kaa, sikʉ ya katatʉ fʉfʉka arɨ!” ");
INSERT INTO lag_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aho, íyo waala vaana va Sebedáayo akadoma na kʉrɨ Yéesu hamwɨ na vaana vaachwe, akamwiinamɨra, maa akamʉloomba amʉbweeyyirye kɨɨntʉ kɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yéesu akamuurya, “Che woosaaka?” Ne akasea, “Nooloomba vaana vaanɨ ava vavɨrɨ ʉmwɨ iikale mʉkono waako wa kʉmooso, na wɨɨngɨ mʉkono waako wa kʉlʉme Ʉtemii waako.” ");
INSERT INTO lag_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yéesu akamʉsea, “Sɨ wootaanga ˆcheene wooloomba tʉkʉ. Eri, daha mʉrɨ kʉnyweera ndʉvo ˆngʼeene ndɨrɨ nyweera nɨɨnɨ wʉʉ?” Vakasea, “Daha tʉrɨ.” ");
INSERT INTO lag_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yéesu akavasea, “Ndʉvo yaanɨ kɨɨnyweera mʉrɨ, maa kaa, kwiikala mʉkono waanɨ wa kʉlʉme na wa kʉmooso sɨ viri vyaanɨ kʉvaheera tʉkʉ. Nkalo ijo nɨ sa vara ˆviimiriwa neeja nɨ Taáta waanɨ.” ");
INSERT INTO lag_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Vapooji vara vɨɨngɨ ikimi ˆvakateere jeyyo, maa vakavakalarɨra vara vandʉʉ vavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Maa kaa, Yéesu akavaanɨrɨra voosi, maa akavasea, “Mwamányire vakʉ́ʉ́lʉ va vaantʉ sɨ ˆvarɨ Vayahúudi, vavɨɨ́mɨrɨraa vaantʉ vaavo na ngururu, na vakʉ́ʉ́lʉ vaavo valáɨraa vatɨɨte wiimiriri mweeri yaavo.” ");
INSERT INTO lag_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kʉrɨ nyuunyu sɨ noosaaka vive jeyyo tʉkʉ. Kɨrɨ vyoova jeyyo, mʉʉntʉ ˆyoosaaka ave mʉkʉ́ʉ́lʉ kwaanyu, nɨ mpaka ave mʉtʉmami waanyu. ");
INSERT INTO lag_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kei, mʉʉntʉ yoyoosi ˆyoosaaka kʉva wa ncholo kwaanyu, nɨ mpaka ave mʉtʉ́mwa waanyu. ");
INSERT INTO lag_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Viivyo Mwaana wa Mʉʉntʉ sɨ ʉʉja jo tʉmamɨrwa tʉkʉ, maa kaa, ʉʉja sa jɨ avatʉmamɨre vaantʉ, kei atoole nkaasʉ yaachwe kʉva ununuuli sa vaantʉ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mpɨɨndɨ Yéesu na vapooji vaachwe ˆviinʉkáa fuma Yerɨ́ɨko, mpuka nkʉʉlʉ ya vaantʉ ɨjáa yavatuuba. ");
INSERT INTO lag_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mbarɨmbarɨ ya njɨra, vajáa viíkyɨɨre vahoku vavɨrɨ. ˆVakateere Yéesu yoolooka, vakatʉla isóso voosea, “Yéesu Mweenevyoosi, Sha Daúdi, tʉlaange na riiso ra wʉʉja!” ");
INSERT INTO lag_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mpuka ya vaantʉ ɨkavadalavya vareke tʉla isóso, maa kaa, voovo vakadoomererya tʉla isóso voosea, “Ee Sha Daúdi, Mweenevyoosi, tʉlaange na riiso ra wʉʉja aaɨ!” ");
INSERT INTO lag_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yéesu akɨɨma, maa akavaanɨrɨra yoosea, “Che moosaaka nɨvabweeyyirye?” ");
INSERT INTO lag_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Novo vakasea, “Mweenevyoosi, toosaaka toone.” ");
INSERT INTO lag_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yéesu akavoonera mbavariri, akavasaasya miiso yaavo. Hahara miiso yaavo yakatʉʉnʉkʉka, novo vakamutuuba. ");
INSERT INTO lag_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yéesu na vapooji vaachwe ˆvakasengerere fika Yerusaléemu, vakafika iturii ra Besifáage, Luulwii lwa Mɨseitúuni. Aho, Yéesu akavatʉma vapooji vaachwe vavɨrɨ, ");
INSERT INTO lag_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akavasea, “Tamanyi na iturii ˆrɨrɨ aho mbere, na ˆmʉrɨ fika vii shaana mʉrɨ ndákwi ˆyachúungirwe na mwaana waachwe. Jichunguli mʉʉndetere. ");
INSERT INTO lag_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Koonɨ mʉʉntʉ avuúriirye chochoosi mʉsei, ‘Mweenevyoosi yoojisaaka,’ na ʉwo mʉʉntʉ varekera arɨ chaangʉ.” ");
INSERT INTO lag_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Masáare aya yafʉmɨra sa masáare ˆyalʉʉswa nɨ mʉláali na mʉtwe yakiimane, ");
INSERT INTO lag_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Vawyɨɨre vaantʉ va múuji wa Sayúuni, laangi Mʉtemi waanyu yookʉʉja! Ahola na iivérekiirye ndákwi, ˆngʼeene ɨrɨ hamwɨ na mwaana.” ");
INSERT INTO lag_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Vara vapooji vavɨrɨ vakabweeyya ja ˆvyeene vajáa valáiririiwe nɨ Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Vakɨɨreeta ɨra ndákwi na mwaana waachwe, vakaala ɨngo jaavo myoongwii ya ijo ndákwi, maa Yéesu akaambʉka. ");
INSERT INTO lag_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mpuka nkʉʉlʉ ɨra ˆyamutuubáa vakaala ɨngo njirii na vɨɨngɨ vakatema matáampi ya mɨtɨ, maa vakaala njirii. ");
INSERT INTO lag_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Vaantʉ vara ˆvajáa vamʉlóngorɨɨre na vara ˆvamutuubáa, vatʉláa isóso voosea, “Adʉʉmbwe Sha Daúdi, atalariwa yeeye ˆyookʉʉja kwa irina ra Ijʉva! Kʉdʉʉmbwe kurumu mweerimweeri.” ");
INSERT INTO lag_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yéesu ˆakɨɨngɨre Yerusaléemu, múuji woosi ʉkajimbʉka maatʉkʉ vii. Aho, vakaanda kiiyurya, “Ʉhʉ nɨ ani?” ");
INSERT INTO lag_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mpuka ya vaantʉ ɨra ˆɨjáa na Yéesu vakavasea, “Ʉhʉ nɨ Yéesu mʉláali na mʉtwe kufuma Nasaréeti múuji wa Galiláaya.” ");
INSERT INTO lag_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yéesu akɨɨngɨra waámii ya Kaaya Njija ya Ijʉva, akaanda vakibirya vaantʉ voosi ˆvaváa iyoombe no wʉla viintʉ sa vamʉtoorere Ijʉva. Akakʉndʉla méesa ja vaantʉ ˆvawʉlanáa mpía na akakʉndʉla machuumbi ya vaantʉ ˆvaváa iyoombe njɨva. ");
INSERT INTO lag_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aho, akavasea, “Masáarii ˆYarɨ Mpeho vyaandɨkwa, ‘Nyuumba yaanɨ kaanɨrɨrwa ɨrɨ nyuumba yo mʉloomba Mʉlʉʉngʉ.’ Maa kaa, nyuunyu mwɨɨválandwɨɨre ɨkava ‘mpaanga ya viívi.’” ");
INSERT INTO lag_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vahoku na vivete vajáa vʉʉja na Kaayii Njija na yeeye akavahorya. ");
INSERT INTO lag_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Maa kaa, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro ˆvakoone viintʉ ˆvihwáalaryaa ˆvyeene Yéesu abweeyyáa, kei na viintʉ vasinga ˆvɨɨmbáa waámii ya Kaaya Njija voosea, “Adʉʉmbwe Mwaana wa Daúdi,” vakakalala. ");
INSERT INTO lag_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aho, vakamʉsea, “Eri, sɨ wooteera ˆcheene ava voolʉʉsa tʉkʉ wʉʉ?” Yéesu akavasea, “Hɨɨ. Sɨ mʉnasoma Masáare ˆYarɨ Mpeho ˆcheene yalʉʉsa tʉkʉ wʉʉ? Yalʉʉsa, ‘Kwa mɨlomo ya vaana vaduudi na nkuumbu, wiikiimanirya dʉʉmbɨ.’” ");
INSERT INTO lag_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aho, akavareka maa akalooka na weerwii ya múuji fʉʉrʉ iturii ra Besanía kʉʉntʉ ˆalaala uchikʉ ʉwo. ");
INSERT INTO lag_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Namʉtóondo vii mpɨɨndɨ Yéesu ˆahɨndʉkáa na múujii, akaavwa nɨ njala. ");
INSERT INTO lag_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aho, akoona mʉsaambu mbarɨmbarɨ ya njɨra, akʉʉtamanyirya, maa kaa, sɨ ashaana kɨɨntʉ tʉkʉ, akashaana masaambɨ vii. Aho akʉʉsea, “Sɨ ʉkatuungire ndɨɨwa kei vii kaa tʉkʉ!” Haaho, mʉsaambu ʉkanyaamala. ");
INSERT INTO lag_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Vapooji vaachwe ˆvakoone jei, vakahwaalala maatʉkʉ vii voosea, “Joolɨ vivɨ́ɨre mʉsaambu ʉnyaamale chaangʉ jei?” ");
INSERT INTO lag_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yéesu akavasea, “Kɨmaarɨ noovawyɨɨra, koonɨ mʉvɨ́ɨre na kuruma baa kʉva na kivundu tʉkʉ kʉra mitimii yaanyu, sɨ mʉrɨ daha tʉmama ɨkɨ ˆkɨvɨ́ɨre vii kʉrɨ ʉhʉ mʉsaambu tʉkʉ. Maa kaa, daha mʉrɨ kʉlʉsea ʉlʉ lʉʉlʉ, ‘Kʉʉrɨka ʉkafweitɨrwe mayiyii,’ novyo kʉva viri jeyyo. ");
INSERT INTO lag_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Chochoosi ˆmʉrɨ loomba mpɨɨndɨ ˆmoomʉloomba Mʉlʉʉngʉ, koonɨ mooruma, kɨpata mʉrɨ.” ");
INSERT INTO lag_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yéesu ˆakafike Yerusaléemu, akɨɨngɨra na waámii ya Kaaya Njija, maa akaanda kiindya. Aho, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vawosi va Vayahúudi vakʉʉja na kʉʉntʉ ˆakiindyáa, maa vakamuurya, “Nɨ kwa wiimiriri ʉrɨkwɨ wootʉmama aya masáare? Na nɨ ani akʉheera wiimiriri ʉhʉ?” ");
INSERT INTO lag_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yéesu akavasea, “Naanɨ kuvuurya ndɨrɨ kɨɨntʉ kɨmwɨ. Koonɨ muúyiirye, naanɨ vawyɨɨra ndɨrɨ nɨ kwa wiimiriri ʉrɨkwɨ nootʉmama aya masáare. ");
INSERT INTO lag_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ʉbatíiso wa Yooháani nɨ hai ˆwafuma? Nɨ kurumwii bakʉ kwa vaantʉ?” Vakalʉʉsɨkanʼya voovo kwa voovo voosea, “Koonɨ taséire, ‘Wafuma kurumwii,’ sea arɨ, ‘Haaha amwɨ sɨ mumuruma?’ ");
INSERT INTO lag_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Maa kaa, koonɨ taséire, ‘Wafuma kwa vaantʉ,’ tookoofa mpuka ya vaantʉ, sa voosi vamuruma Yooháani nɨ mʉláali na mʉtwe wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sa jeyyo vakamʉsea Yéesu, “Iyaʉ, sɨ tamányire tʉkʉ.” Ne akavasea, “Baa nɨɨnɨ sɨ ndɨrɨ vawyɨɨra nɨ kwa wiimiriri ʉrɨkwɨ nootʉmama aya tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Joolɨ mookoona? Mʉʉntʉ ʉmwɨ ajáa atɨɨte vaana vavɨrɨ. Akamʉdomera ndaambere, maa akamʉsea, ‘Mwaana waanɨ, tamanya ʉkatʉmame iwundii ra sabíibu isikʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mwaana waachwe akamʉtatʉla yoosea, ‘Sɨ ndɨrɨ doma tʉkʉ!’ Mpɨɨndɨ ˆjikalooke, akavalandʉla mɨryʉʉngʉ yaachwe akatamanya. ");
INSERT INTO lag_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aho, ʉra moosi akamʉdomera mwaana waachwe wɨɨngɨ akamuwyɨɨra vivira. Ʉwo akamʉrʉmɨra yoosea, ‘Taáta tamanya ndɨrɨ,’ maa kaa, sɨ atamanya vii kaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nɨ arɨkwɨ kati ya ava vavɨrɨ ˆatʉmama kɨra ˆcheene taáta waavo asaakáa?” Novo vakamʉsea, “Nɨ ʉra wa ncholo.” Yéesu akavasea, “Kɨmaarɨ noovawyɨɨra, vasaankanʼyi kóodi na vahéngeeti voovalongorera kɨɨngɨra na Ʉtemii wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yooháani ʉʉja na kwaanyu kʉvoonekya njɨra ya ʉwoloki, nyuunyu sɨ mumuruma tʉkʉ, maa kaa, vasaankanʼyi kóodi na vahéngeeti vamuruma. Baa neembe moona ayo, mpɨɨndɨ ˆjikalooke sɨ mwavalandʉka na mumurume tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Teereri lusímo lwɨɨngɨ. Kwajáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆajáa na iwʉnda. Aho iwundii raachwe, ajáa ahaanda mɨsabíibu, akariingirirya lʉkaande, akasiimba iduundu ro fʉʉnchɨra sabíibu so tengenesera diváai na akajeenga kɨvaanda kɨlɨɨhɨ cho rɨndɨrɨra. Aho, akavakojya varimi ɨro iwʉnda, maa yeeye akakera njɨra. ");
INSERT INTO lag_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mpɨɨndɨ jo chwa ˆjikafike, akavatʉma vatʉmami vaachwe vakasʉmʉle haantʉ haachwe ha ndɨɨwa fuma kwa avo varimi. ");
INSERT INTO lag_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Vara vaantʉ ˆvakojiwa vakavakwaata vara vatʉmami, ʉmwɨ vakamʉvaa, wɨɨngɨ vakamʉʉlaa na wɨɨngɨ vakamʉvaa na mawye. ");
INSERT INTO lag_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aho, mweeneiwʉnda akatʉma vatʉmami vɨɨngɨ ˆvarɨ foo kʉlookya vara va ncholo, novo vakavabweeyyirya ʉvɨ vivira. ");
INSERT INTO lag_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lo kiimikirirya akamʉtʉma mwaana waachwe na kwaavo kʉnʉ yookiisea, ‘Kʉmʉnyemya varɨ mwaana waanɨ.’ ");
INSERT INTO lag_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Maa kaa, vara ˆvakojiwa iwʉnda ˆvakamoone mwaana waachwe vakiiwyɨɨra, ‘Ʉhʉ noo mʉpaari wa ɨrɨ iwʉnda. Hendi tʉmʉʉlae, maa ʉpaari waachwe ʉve wiiswi!’ ");
INSERT INTO lag_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jeyyo, vakamʉkwaata, vakamʉfweitɨra na weerwii ya iwʉnda ra mɨsabíibu, maa vakamʉʉlaa. ");
INSERT INTO lag_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Haaha ˆarɨ kʉʉja mweeneiwʉnda ra mɨsabíibu, nɨ joolɨ arɨ vabweeyya avo vaantʉ avakojya?” ");
INSERT INTO lag_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Vakamʉsea, “Na nkalari vamala arɨ avo vavɨ! Aho, vakojya arɨ iwʉnda ra mɨsabíibu vaantʉ vɨɨngɨ ˆveene vɨɨndoomʉrɨha ndɨɨwa mpɨɨndɨ jo chwa.” ");
INSERT INTO lag_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yéesu akavasea, “Eri, sɨ mʉnasoma Masáare ˆYarɨ Mpeho ˆcheene yalʉʉsa tʉkʉ wʉʉ? ‘Iwye ˆrasiitwa nɨ vajeengi, ravɨ́ɨre iwye ikʉʉlʉ ra kichurii. Ijʉva atʉ́mamire isáare ɨrɨ, noro rabooha na nɨ iyeni maatʉkʉ vii miiswii yiitʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Sa jeyyo, nɨ kʉvawyɨɨra niise, Ʉtemi wa Mʉlʉʉngʉ seyyiwa ʉrɨ kwaanyu, na heewa varɨ vaantʉ va ɨsɨ jɨɨngɨ ˆveene varɨ daha kʉvyaala ndɨɨwa jaachwe. ");
INSERT INTO lag_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kɨra mʉʉntʉ ˆawíjaa mweeri ya iwye ɨrɨ, ngʼenyekangʼenyeka arɨ, na ʉra ˆrɨrɨ muwyɨɨra chɨnɨka arɨ kamwɨ.” ");
INSERT INTO lag_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na Mafarisáayo ˆvakateere símo ja Yéesu, maa vakataanga nɨ voovo joovalʉʉsa. ");
INSERT INTO lag_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Vakasaaka njɨra yo mʉkwaata, maa kaa, vakoofa ɨra mpuka ya vaantʉ sa vamoonáa ja mʉláali na mʉtwe wa Ijʉva. ");
INSERT INTO lag_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yéesu akalʉʉsɨka na Mafarisáayo kei kwa símo, akavasea, ");
INSERT INTO lag_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ʉtemi wa Kurumwii wiifwɨ́ɨne na mʉtemi ʉmwɨ ˆajáa iimya neeja ngovi ya ilóola ya mwaana waachwe. ");
INSERT INTO lag_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akavatʉma vatʉmami vaachwe, vakavaanɨrɨre vara vaantʉ ˆajáa avaláarikire vʉʉje na ngovii, novo vakasiita kʉʉja. ");
INSERT INTO lag_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Akatʉma vatʉmami vɨɨngɨ kei, akavasea, ‘Vasei vara ˆvaláarikirwe, ngovi yahʉ́mwɨɨre sa nyuunyu, nahʉ́mwɨɨre baa sɨɨnja nkabaako jaanɨ ja ngʼoombe na njɨɨkʉ ˆjanona. Teengi na ngovii.’ ");
INSERT INTO lag_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Vara ˆvaláarikirwe baa sɨ vavikwaatya tʉkʉ, vakiilookera, ʉmwɨ na iwundii kwaachwe, wɨɨngɨ na mirimwii yaachwe. ");
INSERT INTO lag_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Vɨɨngɨ vakavakwaata vara vatʉmami, vakavabweeyyirya vyavɨɨha na vakavʉʉlaa. ");
INSERT INTO lag_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ʉra mʉtemi akakalala maatʉkʉ vii, akatʉma mpuka ya valwi nkoondo vaachwe ɨkavamala vara vʉʉlai, na múuji waavo vakʉʉmala na mooto. ");
INSERT INTO lag_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aho, akavasea vatʉmami vaachwe, ‘Ngovi ya ilóola yahʉ́mwɨɨre kiimiwa neeja, maa kaa, vara ˆnavalaarɨka sɨ vavalwa vɨɨma neeja vʉʉje tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Haaha tamanyi na kʉʉntʉ njɨra ˆjalʉmana, mʉmʉlaarɨke kɨra mʉʉntʉ ˆmʉrɨ moona ʉʉje na ngovii.’ ");
INSERT INTO lag_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aho, vara vatʉmami vakafuma vakadoma na kʉʉntʉ njɨra ˆjalʉmanɨra, vakavateengya vaantʉ voosi ˆvavashaana, vavɨ na vaaja. Baanka ya ngovi ɨkamema vayeni. ");
INSERT INTO lag_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Maa kaa, mʉtemi ˆakɨɨngɨre sa avoone vayeni va ngovi, akamoona mʉʉntʉ ʉmwɨ asiina ɨngo ya ngovi ya ilóola. ");
INSERT INTO lag_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mʉtemi akamuurya, ‘Kɨjeengi, joolɨ wɨɨ́ngɨɨre na kʉnʉ baa ɨngo ya ngovi tʉkʉ?’ Ʉra mʉʉntʉ ajáa asiina cho lʉʉsa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aho, mʉtemi akavasea vatʉmami vaachwe, ‘Muchuungi mɨkono na mawʉlʉ na mʉmʉfweite na weerwii kʉrɨ na kilwiirya, ʉko kʉva kʉrɨ na kɨrɨro no sha mayeo.’ ");
INSERT INTO lag_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sa vara ˆvaanɨrɨrwa nɨ foo varɨ, maa kaa, vara ˆvasaawʉlwa nɨ vake.” ");
INSERT INTO lag_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aho, Mafarisáayo vakatamanya, maa vakɨɨta noo kiimya neeja mʉryʉʉngʉ wo mʉkwaata kwa masáare yaachwe mweeneevyo. ");
INSERT INTO lag_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Vakavatʉma vapooji vaavo hamwɨ na vaantʉ va mʉtemi Heróode voosea, “Mukiindya, takʉmányire weewe nɨ mʉʉntʉ ˆʉlʉ́ʉsaa kɨmáárɨ, na wakíindyaa njɨra ya Mʉlʉʉngʉ kwa kɨmáárɨ baa sɨ ʉláangaa ʉkʉ́ʉ́lʉ wa mʉʉntʉ tʉkʉ. Weewe sɨ ʉláangaa buuwo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hoonɨ tʉwyɨɨre, joolɨ wookoona? Ndairiri jaruma mʉʉntʉ arɨhe kóodi kwa Kaisáari, bakʉ tʉkʉ?” ");
INSERT INTO lag_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Maa kaa, Yéesu kʉnʉ yootaanga mɨryʉʉngʉ yaavo mɨvɨ, akavasea, “Nyuunyu vakweembi, amwɨ mooyera kʉʉntea? ");
INSERT INTO lag_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hoonɨ nyonekyi mpía yo rɨhɨra kóodi.” Maa vakamʉretera mpía ya dináari. ");
INSERT INTO lag_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne akavuurya, “Buuwo ɨhɨ na irina ɨrɨ nɨ vya ani?” ");
INSERT INTO lag_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Vakamʉsea, “Nɨ vya Kaisáari.” Aho, Yéesu akavasea, “Haaha, vya Kaisáari mʉheeri Kaisáari, na vya Mʉlʉʉngʉ mʉheeri Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ˆVakateere jeyyo, vakahwaalala maatʉkʉ vii. Aho, vakamʉreka, vakiilookera. ");
INSERT INTO lag_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sikʉ yɨɨyo, Masadukáayo, noo kʉsea vara ˆvaséaa kusiina kʉfʉfʉka tʉkʉ, vakʉʉja na kʉrɨ Yéesu. Aho, vakamʉsea, ");
INSERT INTO lag_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mukiindya, Mʉ́sa asea, ‘Koonɨ mʉʉntʉ akwíire baa kʉva na vaana tʉkʉ, mwaanaavo yoosaakwa amʉpaale ʉwo mʉlala sa amʉvyaarɨre vaana mwaanaavo ʉra ˆaakwya.’ ");
INSERT INTO lag_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Haaha mɨɨtʉ kʉjáa kwatɨɨte vaana valʉme mufungatɨ va mʉʉntʉ ʉmwɨ. Ʉra wa ndaambere akaloola muki, ʉhʉ akakwya, na sa viintʉ ajáa asiina mwaana, akamʉrekera mwaanaavo ʉra mʉlala. ");
INSERT INTO lag_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kɨɨntʉ kɨɨkyo kɨkafʉmɨra kwa mwaanaavo wa kavɨrɨ, na wa katatʉ, na fʉʉrʉ wa mufungatɨ. ");
INSERT INTO lag_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Maa reerʉ, ʉra mʉʉntʉ muki ne akawulala. ");
INSERT INTO lag_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Haaha, sikʉ ɨra ya ʉfʉfʉ́ʉko ʉra mʉʉntʉ muki nɨ muki wa ani arɨ kʉva? Sa voosi mufungatɨ vamʉloola.” ");
INSERT INTO lag_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yéesu akavasea, “Mwahóniirye sa sɨ mʉmányire Masáare ˆYarɨ Mpeho na ngururu ja Mʉlʉʉngʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mpɨɨndɨ ja ʉfʉfʉ́ʉko, vaantʉ sɨ vakalóorire noo loolwa tʉkʉ, voovo kʉva varɨ ja mirimʉ miija ya kurumwii. ");
INSERT INTO lag_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Maa kaa, kwa ʉfʉfʉ́ʉko wa vaantʉ ˆvaakwya sɨ mʉnasoma kɨra Mʉlʉʉngʉ ˆavawyɨɨra, yoosea, ");
INSERT INTO lag_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nɨɨnɨ nɨ Mʉlʉʉngʉ wa Aburaháamu, Mʉlʉʉngʉ wa Isaka, Mʉlʉʉngʉ wa Yaakúupu tʉkʉ wʉʉ’? Yeeye sɨ Mʉlʉʉngʉ wa vaantʉ ˆvaakwya tʉkʉ, yeeye nɨ Mʉlʉʉngʉ wa ˆvarɨ nkaasʉ.” ");
INSERT INTO lag_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mpuka ya vaantʉ ˆvakateere jei, vakahwaalariwa nɨ ukiindya waachwe. ");
INSERT INTO lag_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafarisáayo ˆvakateere Yéesu avatúunikire mɨlomo Masadukáayo, maa vakiijiinga hamwɨ. ");
INSERT INTO lag_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ʉmwɨ waavo ˆmweene ajáa mukiindya wa Miiro akamuurya Yéesu ko mʉyera, ");
INSERT INTO lag_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mukiindya, ʉrɨkwɨ noo ʉlairiri mʉkʉʉlʉ kʉrɨ Miiro ya Mʉlʉʉngʉ?” ");
INSERT INTO lag_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yéesu akamʉsea, “‘Mweende Ijʉva Mʉlʉʉngʉ waako na mʉtɨma waako woosi, na nkaasʉ yaako yoosi, na mʉryʉʉngʉ waako woosi.’ ");
INSERT INTO lag_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ʉhʉ noo ʉlairiri wa ncholo na mʉkʉlʉkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ʉlairiri wa kavɨrɨ wiifwɨ́ɨne na ʉwo, ‘Mweende mwiiwaako ja ˆvyeene wiiyenda mweeneevyo.’ ");
INSERT INTO lag_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Miiro na valáali na mʉtwe voosi, mwaariryo waavo nɨ ndairiri iji ivɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafarisáayo ˆvakiijiinge hamwɨ, Yéesu ajáa avuurya, ");
INSERT INTO lag_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Joolɨ moomwiiririkana Masía? Yeeye nɨ mwaana wa ani?” Vakamʉsea, “Mwaana wa Daúdi.” ");
INSERT INTO lag_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ne akavasea, “Joolɨ de Daúdi kati ˆalʉʉsɨkáa ko longoolwa nɨ Mʉtɨma Mʉʉja amwaanɨrɨra, ‘Mweenevyoosi’? Yeeye asea, ");
INSERT INTO lag_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ijʉva amʉsea Mweenevyoosi waanɨ, “Ikala mʉkono waanɨ wa kʉlʉme, fʉʉrʉ nɨvavɨɨke vavɨ vaako, vave ɨsɨ ya majeo yaako.”’ ");
INSERT INTO lag_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Haaha koonɨ Daúdi yoomwaanɨrɨra, ‘Mweenevyoosi’ waachwe, ha de joolɨ Masía arɨ kʉva mwaana wa Daúdi?” ");
INSERT INTO lag_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kusiina mʉʉntʉ ˆadaha kumuuyirya isáare tʉkʉ. Na kwaandɨra sikʉ ɨyo, kusiina ˆayera kumuurya kei tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aho, Yéesu akɨɨsea ɨra mpuka ya vaantʉ hamwɨ na vapooji vaachwe, ");
INSERT INTO lag_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Vakiindya va Miiro na Mafarisáayo vatɨɨte wiimiriri wo vakiindya vaantʉ Miiro ya Mʉ́sa. ");
INSERT INTO lag_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jeyyo, mwasaakwa mʉvatuube kɨra kɨɨntʉ ˆvoovawyɨɨra. Maa kaa, karɨ mʉvatuube ˆcheene voobweeyya tʉkʉ, sa sɨ vatúubaa kɨra ˆvaváriyʉlaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Voovo vachúungaa miriwa mɨkʉʉlʉ na vavavérekyaa vaantʉ, maa kaa, voovo veeneevyo sɨ vasáakaa kwɨɨyɨnʉla baa na imaamba vii tʉkʉ kwɨɨseesya. ");
INSERT INTO lag_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Viintʉ vyoosi vabwéeyyaa sa vaantʉ voone. Vaténgeneshaa nkova jawarɨha ˆvaandɨka Miiro, maa de vandookiivɨkɨra vipáamii na mɨkonwii. Kei, valíihyaa ndihi ja mɨkáwo ja ɨngo jaavo kʉlookya ja vɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Veenda kwiikala haantʉ ha nyemi ngovii na machuumbii ya mbere masinagóogii. ");
INSERT INTO lag_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Veenda luumbiwa masóokwii na veenda vaantʉ vavanɨrɨre, ‘Ee Mukiindya.’ ");
INSERT INTO lag_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Maa kaa, nyuunyu karɨ mwaánɨrɨrwaa mukiindya tʉkʉ, sa mwatɨɨte Mukiindya ʉmwɨ vii na nyuunyu voosi nɨ vandʉʉ. ");
INSERT INTO lag_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na nyuunyu karɨ mʉmwaánɨrɨraa mʉʉntʉ yoyoosi taáta aha weerwii tʉkʉ, sa mwatɨɨte Taáta ʉmwɨ, yeeye nɨ kurumwii arɨ. ");
INSERT INTO lag_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Karɨ mwaánɨrɨrwaa mukiindya tʉkʉ, sa mwatɨɨte mukiindya ʉmwɨ, ne noo Masía. ");
INSERT INTO lag_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mʉkʉ́ʉ́lʉ kʉrɨ nyuunyu kʉva arɨ mʉtʉmami waanyu. ");
INSERT INTO lag_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ʉra ˆiiyámbukyaa, kiimiwa arɨ, na ʉra ˆiikíimyaa, kaambukiwa arɨ. ");
INSERT INTO lag_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Maa kaa, nɨ mpolaɨ kʉrɨ nyuunyu vakiindya va Miiro na nyuunyu Mafarisáayo, nyuunyu vakweembi! Nyuunyu mootuuba vachʉʉngɨra vaantʉ weerwii ya Ʉtemi wa Kurumwii. Nyuunyu veeneevyo sɨ mwɨɨ́ngɨraa tʉkʉ, na vara ˆvoosaaka kwɨɨngɨra mʉvakɨ́tɨraa.  ");
INSERT INTO lag_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nɨ mpolaɨ kʉrɨ nyuunyu vakiindya va Miiro na nyuunyu Mafarisáayo vakweembi. Nyuunyu mwanyáhɨraa nyuumba ja valala, na kwa ʉkweembi mwamʉlóombaa Mʉlʉʉngʉ vilɨɨhɨ. Sa jeyyo, heewa mʉrɨ irya ˆralookya. ");
INSERT INTO lag_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nɨ mpolaɨ kʉrɨ nyuunyu vakiindya va Miiro na Mafarisáayo, vakweembi! Nyuunyu mwakéraa njɨra kʉrɨ ɨsɨ na mayiyii moosaakɨra mʉʉntʉ ʉmwɨ atuube díini yaanyu, na ˆarɨ vatuuba mwamʉbwéeyyaa ave wa Jehénamu mara kavɨrɨ kʉlookya nyuunyu! ");
INSERT INTO lag_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mpolaɨ nyuunyu valongooli vahoku. Nyuunyu mwaséaa koonɨ mʉʉntʉ iiláhire kwa Kaaya Njija ya Ijʉva sɨ kɨɨntʉ tʉkʉ. Maa kaa, kei mwaséaa koonɨ mʉʉntʉ iiláhire kwa saháabu ya Kaaya Njija ʉwo iikúndikire kwa kwiilaha kwaachwe. ");
INSERT INTO lag_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nyuunyu vahoku vakookoyo, nɨ kɨrɨkwɨ noo kɨkʉ́ʉ́lʉ, saháabu bakʉ Kaaya Njija ɨra ˆɨtálaryaa saháabu ɨve njija mbere ya Mʉlʉʉngʉ? ");
INSERT INTO lag_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kei mwaséaa, ‘Koonɨ mʉʉntʉ iiláhire kwa masabáahʉ sɨ kɨɨntʉ tʉkʉ, maa kaa, koonɨ mʉʉntʉ iiláhire kwa mpóryo ˆɨrɨ mweeri yaachwe, ʉwo iikúndikire kwa kwiilaha kwaachwe.’ ");
INSERT INTO lag_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nyuunyu vahoku, nɨ kɨrɨkwɨ noo kɨkʉ́ʉ́lʉ, ɨra mpóryo bakʉ masabáahʉ ɨra ˆyookɨɨbweeyya mpóryo ɨve njija mbere ya Mʉlʉʉngʉ? ");
INSERT INTO lag_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Haaha mʉʉntʉ yoyoosi ˆiiláhaa kwa masabáahʉ, ʉwo iiláhaa kwa masabáahʉ na viintʉ vyoosi ˆviri mweeri yaachwe. ");
INSERT INTO lag_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mʉʉntʉ yoyoosi ˆiiláhaa kwa Kaaya Njija, iiláhaa kwa ɨyo Kaaya na kwa ʉra ˆiíkalaa isii yaachwe. ");
INSERT INTO lag_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na ʉra ˆiiláhaa kwa kurumu, iiláhaa kwa ichuumbi ra Mʉlʉʉngʉ na kwa yeeye ˆiíkalaa mweeri ya ɨro ichuumbi. ");
INSERT INTO lag_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nɨ mpolaɨ kʉrɨ nyuunyu vakiindya va Miiro na Mafarisáayo, vakweembi! Nyuunyu mwatóolaa rɨmwɨ ra malʉʉndʉ ikimi ya faaɨ, biinsáari na jíira na kʉnʉ mooreka masáare ya kɨkomikoomi ya Miiro ya Mʉlʉʉngʉ baa ja ʉwoloki, kʉlaanga na riiso ra wʉʉja na kuruma. Ivyo noo viintʉ ˆvyasaakwa mʉtʉmame, na baa kei, karɨ mʉreke aya yɨɨngɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nyuunyu valongooli vahoku. Mwasʉ́ʉjaa vidúúdu, kʉnʉ moomerya ngamɨ́a! ");
INSERT INTO lag_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nɨ mpolaɨ kʉrɨ nyuunyu vakiindya va Miiro na Mafarisáayo, vakweembi! Nyuunyu mʉndoosuunta ndʉvo na saháani kwa weerwii, maa kaa, isii jamema kʉnyahɨra máari na ʉláku. ");
INSERT INTO lag_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Weewe Mʉfarisáayo mʉhoku, suunta ta isii ya ndʉvo, maa de weerwii ya ndʉvo kʉsʉʉntɨke. ");
INSERT INTO lag_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mpolaɨ kʉrɨ nyuunyu vakiindya va Miiro na Mafarisáayo, vakweembi! Nyuunyu mʉrɨ ja mbɨrɨ́ɨ́ra ˆjahakwa chokáa, jira ˆjoónekanaa jabooha weerwii, kʉnʉ jamema makúfa ya vaantʉ ˆvaakwya na waavu wa mavala ˆyiísimiresimire. ");
INSERT INTO lag_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nɨ viivyo, kɨweerwii moónekanaa ja vaantʉ vawoloki, maa kaa, isii mwamema ʉkweembi na kuwuna miiro. ");
INSERT INTO lag_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nɨ mpolaɨ kʉrɨ nyuunyu vakiindya va Miiro na Mafarisáayo, vakweembi! Nyuunyu mʉndoojeengerera mbɨrɨ́ɨ́ra ja valáali na mʉtwe va Ijʉva no bohererya mbɨrɨ́ɨ́ra ja vaantʉ vaaja. ");
INSERT INTO lag_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na mwaséaa, ‘Ngaarɨ tʉjáa twiikala mpɨɨndɨ ya vala baaba wiitʉ, ngaarɨ sɨ tatʉmamanʼya mʉrɨmo wo kiita sakami ya valáali na mʉtwe va Ijʉva tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kwa njɨra ɨyo moónekyaa nyuunyu mʉrɨ vaana va vara ˆvavʉʉláa valáali na mʉtwe va Ijʉva. ");
INSERT INTO lag_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Haaha marikiriryi mʉrɨmo mʉvɨ ˆmweene vala baaba waanyu vaanda. ");
INSERT INTO lag_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nyuunyu nɨ njoka, nyuunyu nɨ mbyaala ya nyororooda! Joolɨ mʉrɨ neha kʉheewa irya ro twaalwa na Jehénamu? ");
INSERT INTO lag_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ɨkɨ noo ˆchooreka navatʉ́mɨraa valáali na mʉtwe, vaantʉ ˆvarɨ na tooti na vakiindya. Vamwɨ vʉʉlaa mʉrɨ noo vaningʼinʼya mʉsaláabii fʉʉrʉ vakwye, vɨɨngɨ vavaa mʉrɨ mɨjeléedi masinagóogii yaanyu na vɨɨngɨ vatuuba mʉrɨ fuma múuji ʉhʉ fʉʉrʉ wɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jeyyo, sakami ya vawoloki yoosi ˆyiitwa aha weerwii ɨve mweeri yaanyu, keende sakami ya Abéeli mʉwoloki, fʉʉrʉ sakami ya Sakaría mwaana wa Barakía, ʉra ˆmwamʉʉlaa katɨ na katɨ ya masabáahʉ na Haantʉ Haaja. ");
INSERT INTO lag_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kɨmaarɨ noovawyɨɨra, aya yoosi kʉʉja yarɨ mweeri ya mbyaala ɨhɨ! ");
INSERT INTO lag_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aka Yerusaléemu, aka Yerusaléemu, weewe ˆwʉʉ́laa valáali na mʉtwe na ˆʉvávaa na mawye vara ˆvatʉ́mwaa kwaako. Nɨ kangaɨ nasáakaa vasaankanʼya vaana vaako ja nkʉkʉ viintʉ ˆɨkʉ́nɨkɨrɨraa nchʉʉ́rʉ jaachwe mbavii jaachwe, maa kaa, weewe wasiita? ");
INSERT INTO lag_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Laanga nyuumba yaako yarékirwe ntʉhʉ na nkɨva. ");
INSERT INTO lag_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sa noovawyɨɨra, sɨ mʉkaanyɨɨ́ne kei tʉkʉ fʉʉrʉ mpɨɨndɨ ɨra ˆmʉkaséire, ‘Atalariwa yeeye, ˆyookʉʉja kwa irina ra Ijʉva.’ ” ");
INSERT INTO lag_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yéesu ajáa afuma Kaayii Njija ya Ijʉva, na mpɨɨndɨ ˆiilookeráa, vapooji vaachwe vajáa vamʉdomera, vakamoonekya majuumba ya Kaaya Njija. ");
INSERT INTO lag_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aho, Yéesu akavasea, “Hɨɨ, majuumba aya yoosi, mwayɨɨ́ne. Kɨmaarɨ noovawyɨɨra, kusiina iwye baa rɨmwɨ ˆrɨrɨ chaala mweeri ya iwye rɨɨngɨ tʉkʉ. Mawye yoosi vʉʉ girimʉlwa yarɨ!” ");
INSERT INTO lag_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mpɨɨndɨ Yéesu ˆajáa iíkyɨɨre Luulwii lwa Mɨseitúuni, vapooji vaachwe vajáa vamʉdomera na kijiraawii vakamuurya, “Tʉwyɨɨre nɨ naadi aya masáare yoosi ˆyarɨ fʉmɨra? Nɨ isháara che ˆjiri koonekya kʉʉja kwaako na kʉherererya kwa mpɨɨndɨ?” ");
INSERT INTO lag_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yéesu akavasea, “Laangi neeja karɨ mʉʉntʉ avakoovere tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vaantʉ ˆvarɨ foo kʉʉja varɨ kwa irina raanɨ, kɨra ʉmwɨ yoosea ‘Nɨɨnɨ noo Masía,’ novo vakoovera varɨ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Teera mʉrɨ nkoondo na fwefwe ja nkoondo, laangi, karɨ moófaa tʉkʉ, sa aya yoosi nɨ mpaka yafʉmɨre, maa kaa, ʉra ʉhero ʉkaarɨ. ");
INSERT INTO lag_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ɨsɨ kiinʉla ɨrɨ nkoondo na ɨsɨ yɨɨngɨ, na ʉtemi ʉmwɨ kiinʉla ʉrɨ nkoondo na ʉtemi wɨɨngɨ. Kʉva kʉrɨ na njala ya imalo na vitiíntima haantʉ haantʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ivi vyoosi noo ja ncholo vii ya ʉsʉʉngʉ wa makata ˆvyeene waándaa. ");
INSERT INTO lag_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Aho, vakwaatya varɨ mɨkonwii ya vaantʉ sa muturikiriwe na mʉʉlawe. Ɨsɨ joosi vasʉʉla jiri sa irina raanɨ. ");
INSERT INTO lag_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mpɨɨndɨ ijo, vaantʉ ˆvarɨ foo valandʉka varɨ kuruma kwaavo, novo kiivarindʉka veende na kiisʉʉla varɨ. ");
INSERT INTO lag_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Valáali na mʉtwe va ʉloongo ˆvarɨ foo fʉmɨra varɨ na koovera varɨ vaantʉ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sa viintʉ kuwuna miiro kʉrɨ koongereriwa, kweenda kwa vaantʉ ˆvarɨ foo hola kʉrɨ. ");
INSERT INTO lag_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Maa kaa, ʉra ˆarɨ yimirirya fʉʉrʉ ʉhero noo ˆarɨ lamuririwa. ");
INSERT INTO lag_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Masáare Maaja ya Ʉtemi variyʉlwa yarɨ kʉrɨ weerʉ yoosi, sa ɨsɨ joosi vataange kɨmáárɨ cha Masáare Maaja. Aho, de kʉra kukiimikirirya kʉʉje. ");
INSERT INTO lag_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Haaha mʉrɨ koona ‘ʉnyanyi ˆʉréetaa ʉsaambʉ ˆwavɨɨhavɨɨha’ wiímire Haantʉ Haaja, ʉsaambʉ ʉra ˆwalʉʉswa nɨ Danyéeli mʉláali na mʉtwe wa Ijʉva, ʉra ˆyoosoma ataange, ");
INSERT INTO lag_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","vara ˆvarɨ ɨsɨ ya Yudéea vatɨjɨre njuulwii. ");
INSERT INTO lag_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yoyoosi ˆarɨ ikekeerii karɨ akiime na ɨsɨ jɨ atoole chochoosi nyuumbii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ʉra ˆarɨ iwundii, karɨ ahɨndʉke na kaayii jɨ atoole nkáancho yaachwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nɨ mpolaɨ kwa vara ˆvarɨ kʉva varuto na ˆvɨɨndookoonkya sikʉ ijo. ");
INSERT INTO lag_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Loombi sa kʉtɨɨja kwaanyu kʉdɨɨre kʉva mpɨɨndɨ ja mpeho au sikʉ ya Sabáato. ");
INSERT INTO lag_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sa sikʉ ijo kʉva kʉrɨ na uturikiri mʉkʉʉlʉ ˆmweene sɨ ʉnafʉmɨra keende kwaanda kwa weerʉ mpaka isikʉ, na baa sɨ luu ʉkafʉmɨɨre kei tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngaarɨ sikʉ ijo sɨ jiri keehiwa, ngaarɨ kusiina mʉʉntʉ baa ʉmwɨ ˆahona tʉkʉ. Maa kaa, sa vara vaantʉ ˆavasaawʉla, ajikeehya sikʉ ijo. ");
INSERT INTO lag_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mpɨɨndɨ ijo, koonɨ mʉʉntʉ yoyoosi avaséire, ‘La! Masía nʉ aha,’ au ‘La! Nʉʉra hara,’ karɨ murúmaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sa fʉmɨra varɨ vala masía va ʉloongo, na valáali na mʉtwe va ʉloongo, voovo bweeyya veende isháara nkʉʉlʉ na viintʉ ˆvihwáalaryaa sa vavakoovere baa vara ˆvasaawʉlwa koonɨ viri dahɨka. ");
INSERT INTO lag_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Laangi navawyɨ́ɨrɨɨre, kati ˆyakaarɨ fʉmɨra. ");
INSERT INTO lag_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sa jeyyo, koonɨ mʉʉntʉ avawyɨ́ɨrɨɨre, ‘La! Nʉʉra kʉra ɨsɨ ya ibaláángwii,’ karɨ mʉdómaa tʉkʉ, au ‘La! Nʉʉra kʉra mberii,’ karɨ murúmaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sa ja ˆvyeene lʉlávo lwafúmaa itʉʉmba lʉkoonekana fʉʉrʉ ʉsweero, jeyyo noo ˆvyeene viri kʉva kʉʉja kwa Mwaana wa Mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Haantʉ kʉrɨ na maka ˆikwíire, noo kʉʉntʉ nkuumba jilʉ́manɨraa. ");
INSERT INTO lag_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Uturikiri wa sikʉ ijo ˆʉrɨ looka vii, ‘Mwaasʉ kʉnɨkɨrɨrwa ʉrɨ, na mweeri sɨ ʉrɨ fala tʉkʉ, nyényeeri nojo kuwya jiri fuma kurumwii, na ngururu ja kurumu sɨngɨsɨka jiri.’ ");
INSERT INTO lag_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aho, isháara ya Mwaana wa Mʉʉntʉ koonekana ɨrɨ kurumwii, na ɨsɨ joosi ja weerʉ rɨra jiri no myaaha. Novo moona varɨ Mwaana wa Mʉʉntʉ yookʉʉja machwii na ngururu na nkongojima nkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yeeye tʉma arɨ mirimʉ yaachwe miija kwa sawúti nkʉʉlʉ ya ntununu, noyo jiinga ɨrɨ vara ˆvasaawʉlwa fuma mavaru yanɨ ya weerʉ, fuma utulo waasɨ fʉʉrʉ utulo wa kurumu. ");
INSERT INTO lag_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ikiindyi fuma kwa mʉsaambu. Matáampi yaachwe koonɨ yavɨ́ɨre na nchúundo na yaándire tʉrɨka, mwatáangaa mpɨɨndɨ ja irʉtɨra jaséngerɨɨre. ");
INSERT INTO lag_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jeyyo baa nyuunyu, ˆmʉrɨ koona viintʉ ivi vyoosi, taangi aséngerɨɨre, jira mpɨɨndɨ jafíkire aha mʉryaangwii. ");
INSERT INTO lag_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kɨmaarɨ noovawyɨɨra, mbyaala ɨhɨ sɨ ɨrɨ looka tʉkʉ kende masáare aya yoosi sɨ yanafʉmɨra. ");
INSERT INTO lag_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kurumu na weerʉ looka jiri, maa kaa, masáare yaanɨ sɨ yarɨ looka vii kaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Maa kaa, kusiina ˆamányire sikʉ ɨyo baa sáa ɨyo tʉkʉ, baa mirimʉ miija ya kurumwii, na Mwaana wa Mʉʉntʉ tʉkʉ, ˆmweene amányire nɨ Taáta yeemweene vii. ");
INSERT INTO lag_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ja ˆvyeene ɨjáa mpɨɨndɨ ja Nʉ́hʉ, noo ˆvyeene viri kʉva baa kʉʉja kwa Mwaana wa Mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sikʉ jira de garɨ́ka yaande, vaantʉ varijáa no nywa, valoolwáa no loola, fʉʉrʉ sikʉ ɨra Nʉ́hʉ ˆɨɨngɨra na safíinii. ");
INSERT INTO lag_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Avo vaantʉ sɨ vajáa vamányire kɨɨntʉ chochoosi tʉkʉ fʉʉrʉ garɨ́ka ɨkavakʉnɨkɨrɨra, noo jeyyo ˆviri kʉva baa kʉʉja kwa Mwaana wa Mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Vaantʉ vavɨrɨ veera varɨ iwundii, ʉmwɨ sʉmʉlwa arɨ na wɨɨngɨ rekwa arɨ. ");
INSERT INTO lag_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vaantʉ vaki vavɨrɨ kʉva varɨ voosha, ʉmwɨ sʉmʉlwa arɨ na wɨɨngɨ rekwa arɨ. ");
INSERT INTO lag_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Haaha mwɨɨme neeja mpɨɨndɨ joosi, sa sɨ mʉmányire nɨ sikʉ ɨrɨkwɨ ˆarɨ kʉʉja Mweenevyoosi waanyu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Maa kaa, taangi isáare ɨrɨ: ngaarɨ mweenenyuumba ataanga nɨ mpɨɨndɨ che nuuchikʉ mwiívi ˆarɨ kʉʉja, ngaarɨ akeesha, ngaarɨ sɨ areka nyuumba yaachwe ɨbokwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jeyyo, baa nyuunyu moosaakwa mʉve mwɨɨ́mɨre neeja mpɨɨndɨ joosi, sa Mwaana wa Mʉʉntʉ kʉʉja arɨ mpɨɨndɨ sɨ ˆmookoona kʉʉja arɨ. ");
INSERT INTO lag_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nɨ mʉtʉmami arɨkwɨ noo ˆarɨ wo kiilaangiwa na ˆarɨ na tooti? Kei, nɨ mʉtʉmami arɨkwɨ arekerwa mʉrɨmo wo vɨɨmɨrɨra viivaachwe nɨ mweenenyuumba waachwe na avaheere vatʉmami chóorya mpɨɨndɨ ˆjasaakwa? ");
INSERT INTO lag_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Atalariwa mʉtʉmami ʉra mweenenyuumba waachwe ˆarɨ mʉshaana yoobweeyya jeyyo, mpɨɨndɨ ˆarɨ hɨndʉka. ");
INSERT INTO lag_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kɨmaarɨ noovawyɨɨra, mweenenyuumba waachwe mʉvɨɨka arɨ ʉwo mwiimiriri ɨɨmɨrɨre viintʉ vyaachwe vyoosi. ");
INSERT INTO lag_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Maa kaa, koonɨ ʉwo mʉtʉmami nɨ mʉvɨ, sea arɨ mutimii waachwe, ‘Mweenenyuumba waanɨ kiikala iise ʉko sikʉ ˆjiri foo,’ ");
INSERT INTO lag_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aho, kaanda arɨ kʉvavaa vatʉmami viivaachwe noo rya no nywa na vareevi. ");
INSERT INTO lag_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aho, mweenenyuumba wa ʉwo mʉtʉmami kʉʉja arɨ sikʉ ˆngʼeene ʉwo mʉtʉmami sɨ yookoona kʉʉja arɨ na sáa sɨ ˆɨɨmányire. ");
INSERT INTO lag_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mʉkera arɨ ʉwo mʉtʉmami mahoongehoonge na mʉvɨɨka arɨ hamwɨ na vakweembi, kʉʉntʉ ˆkʉrɨ kʉva koorɨra no sha mayeo. ");
INSERT INTO lag_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mpɨɨndɨ ijo, Ʉtemi wa Kurumwii kwiifwaana ʉrɨ na lusímo ʉlʉ. Sikʉ ɨmwɨ vanjalʉ ikimi, vajáa vatoola vimʉrɨ vyaavo vakatamanya no musingirirya mweenengovi. ");
INSERT INTO lag_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vasaano va avo vanjalʉ nɨ vakoókoyo vajáa, na vasaano vajáa vatɨɨte tooti. ");
INSERT INTO lag_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mpɨɨndɨ vara vakoókoyo ˆvasʉmʉláa vimʉrɨ vyaavo, sɨ vajáa vasʉmʉla makuta tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Maa kaa, mpɨɨndɨ vara ˆvajáa na tooti ˆvasʉmʉláa vimʉrɨ vyaavo, vajáa vasʉmʉla makuta saamii jaavo yo koongererya. ");
INSERT INTO lag_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mweenengovi ˆakachereve kʉʉja, vara vanjalʉ voosi vakawoojerera na vakalaala. ");
INSERT INTO lag_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Uchikʉ katɨ kʉkava na isóso, ‘Laangi mweenengovi nʉ afíkire, tamanyi mʉkamusingirirye!’ ");
INSERT INTO lag_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aho, vara vanjalʉ voosi vakiinʉka, vakatengenesha vimʉrɨ vyaavo. ");
INSERT INTO lag_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vara vakoókoyo vakavasea vara ˆvarɨ na tooti, ‘Tʉkeeheryi makuta yaanyu kiduudi, vimʉrɨ viiswi vyoorima.’ ");
INSERT INTO lag_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kɨrɨ vyoova jeyyo, vara ˆvarɨ na tooti vakavasea, ‘Sɨ jeyyo tʉkʉ, makuta sɨ yarɨ tʉtoosha suusu na nyuunyu tʉkʉ. Nɨ vyaangʉ mʉdome na kwa vara ˆvávaa iyoombe, mukiiwʉrɨre.’ ");
INSERT INTO lag_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na mpɨɨndɨ avo ˆvadomáa noo wʉla makuta, mweenengovi akʉʉja, na vara ˆvajáa viímiirye neeja vakɨɨngɨra hamwɨ ne na haantʉ ngovi ˆyaveeráa na mʉryaango ʉkachuungwa. ");
INSERT INTO lag_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mpɨɨndɨ ˆjikalooke, vara vanjalʉ vɨɨngɨ novo vakʉʉja. Vakaanɨrɨra, ‘Mʉkʉ́lʉ! Mʉkʉ́lʉ! Tʉyʉʉrɨre mʉryaango!’ ");
INSERT INTO lag_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Maa kaa, mweenengovi akavasea, ‘Kɨmaarɨ noovawyɨɨra, sɨ navamányire tʉkʉ!’ ");
INSERT INTO lag_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ivi, noo ˆvyeene viri kʉva, sa jeyyo, mʉlaange neeja sa sɨ mʉmányire sikʉ au sáa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kei, Ʉtemi wa Kurumwii wiifwɨ́ɨne na lusímo ʉlʉ. Kʉjáa kwatɨɨte mʉʉntʉ ˆasaakáa akere njɨra. Akavaanɨrɨra vatʉmami vaachwe, maa akavaheera máari jaachwe valaangirirye. ");
INSERT INTO lag_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ʉmwɨ akamʉheera taláanta isaano na wɨɨngɨ ivɨrɨ na wɨɨngɨ ɨmwɨ, kɨra mʉʉntʉ akamʉheera ja ˆvyeene lʉvɨro lwaachwe lʉrɨ. Aho, maa yeeye akakera njɨra. ");
INSERT INTO lag_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ʉra ˆaheewa taláanta isaano, chaangʉ akaanda jitʉmamɨra jira mpía, maa akapata taláanta jɨɨngɨ isaano. ");
INSERT INTO lag_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jeyyo baa ʉra wa ivɨrɨ akapata jɨɨngɨ ivɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Maa kaa, ʉra mʉtʉmami ˆajáa ahókɨɨre taláanta ɨmwɨ, ajáa adoma, akasiimba iduundu ɨsɨ, maa akiivisa ɨra mpía ya mweenenyuumba waachwe. ");
INSERT INTO lag_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sikʉ ˆjiri foo ˆjikalooke, ʉra mweenenyuumba wa vara vatʉmami akahɨndʉka na akabweeyya hesáabu novo. ");
INSERT INTO lag_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ʉra mʉtʉmami ˆaheewa taláanta isaano akʉʉja, akareeta jɨɨngɨ isaano. Akasea, ‘Mʉkʉ́lʉ, nɨɨnɨ ʉjáa waampeera taláanta isaano. Laanga, napátire kɨsapʉ cha taláanta jɨɨngɨ isaano.’ ");
INSERT INTO lag_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mweenenyuumba waachwe akamʉsea, ‘Mʉtʉmami mʉʉja na wo kiilaangiwa, wavɨ́ɨre wo kiilaangiwa kwa viintʉ viduudi, kʉvɨɨka ndɨrɨ ʉve mwiimiriri wa viintʉ ˆviri foo. Teenga wɨɨngɨre cheerwii cha mweenenyuumba waako.’ ");
INSERT INTO lag_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ʉra ˆajáa aheewa taláanta ivɨrɨ ne akʉʉja, akamʉsea mweenenyuumba waachwe, ‘Mʉkʉ́lʉ, ʉjáa waampeera taláanta ivɨrɨ. Laanga, napátire kɨsapʉ cha jɨɨngɨ ivɨrɨ.’ ");
INSERT INTO lag_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mweenenyuumba waachwe akamʉsea, ‘Mʉtʉmami mʉʉja na wo kiilaangiwa, wavɨ́ɨre wo kiilaangiwa kwa viintʉ viduudi, kʉvɨɨka ndɨrɨ wɨɨmɨrɨre ˆviri foo. Teenga cheerwii cha mweenenyuumba waako.’ ");
INSERT INTO lag_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Aho, ʉra mʉtʉmami ˆajáa aheewa taláanta ɨmwɨ akʉʉja, maa akasea, ‘Mʉkʉ́lʉ, nɨɨnɨ nɨjáa nataanga weewe nɨ mʉʉntʉ mʉfafu, wachwíjaa kʉʉntʉ sɨ ˆʉhaanda, na ujíingaa kʉʉntʉ sɨ ˆʉpasa mbeyʉ. ");
INSERT INTO lag_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sa jeyyo, nɨɨnɨ noofa, maa nkɨɨta kiivisa taláanta yaako ɨsɨ. Laanga, nɨ ɨhɨ aha ˆɨrɨ yaako.’ ");
INSERT INTO lag_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mweenenyuumba waachwe akamʉsea, ‘Weewe nɨ mʉtʉmami mʉvɨ na muvira! Ʉjáa wataanga nachwíjaa kʉʉntʉ sɨ ˆnahaanda, na najíingaa kʉʉntʉ sɨ ˆnapasa mbeyʉ. ");
INSERT INTO lag_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Vyabooha ngaarɨ wavɨɨka mpía yaanɨ kwa vaantʉ vahɨ́ndʉlaa na kɨsapʉ, sa ˆndɨrɨ hɨndʉka, nsʉmʉle ˆɨrɨ yaanɨ na kɨsapʉ chaachwe. ");
INSERT INTO lag_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Haaha mʉhóki ɨyo taláanta, mʉmʉheere ʉra ˆarɨ nojo ikimi. ");
INSERT INTO lag_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sa ʉra ˆarɨ na kɨɨntʉ, koongereriwa arɨ kʉlookya, na kʉva arɨ novyo koyokoyo. Maa kaa, ʉra ˆasiina kɨɨntʉ, vuulwa arɨ baa kɨra kidúúdi ˆarɨ nocho. ");
INSERT INTO lag_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Haaha ʉhʉ mʉtʉmami asiina kʉnáálo mʉfweitiri na weerwii, ʉko kʉrɨ na kilwiirya, kʉʉntʉ ˆkʉrɨ kʉva na kʉrɨra no sha mayeo.’ ");
INSERT INTO lag_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mwaana wa Mʉʉntʉ ˆarɨ kʉʉja na nkongojima yaachwe na mirimʉ miija yoosi, yeeye kiikala arɨ ichuumbi raachwe ra nkongojima yaachwe. ");
INSERT INTO lag_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ɨsɨ joosi ja weerʉ kiijiinga jiri mbere yaachwe, ne vakera arɨ ja muríisi viintʉ ˆakéraa mburi na muundi. ");
INSERT INTO lag_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jivɨɨka arɨ muundi mʉkono waachwe wa kʉlʉme na mburi mʉkono waachwe wa kʉmooso. ");
INSERT INTO lag_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Aho, ʉwo Mʉtemi vasea arɨ vara ˆvarɨ mʉkono waachwe wa kʉlʉme, ‘Yeendi nyuunyu ˆmwatalariwa nɨ Taáta waanɨ, hokeri Ʉtemi ˆmwiimiriwa neeja keende kʉʉmbwa kwa weerʉ. ");
INSERT INTO lag_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sa nɨjáa na njala mʉkaampeera chóorya, nɨjáa na nyóota mʉkaanyweesha, nɨjáa mʉyeni mʉkaanteengya, ");
INSERT INTO lag_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nɨjáa na tʉhʉ mʉkaanvɨkɨra ɨngo, nɨjáa mʉlwɨ́ɨrɨ mʉkʉʉja no kʉʉnaangirirya, na nɨjáa mʉnyololwii mʉkʉʉja no kʉʉnaanga.’ ");
INSERT INTO lag_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aho, vara vawoloki mʉsea varɨ, ‘Mʉkʉ́lʉ, nɨ naadi ˆtakoona ʉrɨ na njala, tʉkakuriisha, au ʉrɨ na nyóota tʉkakʉnyweesha? ");
INSERT INTO lag_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nɨ naadi ˆtakoona ʉrɨ mʉyeni tʉkakʉteengya, au ʉrɨ na tʉhʉ tʉkakʉvɨkɨra? ");
INSERT INTO lag_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kei nɨ naadi ˆtakoona ʉrɨ mʉlwɨ́ɨrɨ, au ʉrɨ mʉnyololwii tʉkʉʉja no kʉlaanga?’ ");
INSERT INTO lag_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ne Mʉtemi vasea arɨ, ‘Kɨmaarɨ noovawyɨɨra, ja ˆvyeene mʉvabweeyyirya ava vaaniitʉ vaduudi, mʉʉmbweeyyirya nɨɨnɨ.’ ");
INSERT INTO lag_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aho, vasea arɨ vara ˆvarɨ mʉkono waachwe wa kʉmooso, ‘Isunki kwaanɨ nyuunyu ˆmwajumwa, tamanyi na mootwii wa sikʉ ˆjisiina ʉhero ˆwiimiwa neeja sa Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ na mirimʉ yaachwe. ");
INSERT INTO lag_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sa nɨjáa na njala sɨ mwaampeera chóorya tʉkʉ, nɨjáa na nyóota sɨ mwaanyweesha tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nɨjáa mʉyeni sɨ mwaanteengya tʉkʉ, nɨjáa na tʉhʉ sɨ mwaanvɨkɨra ɨngo tʉkʉ, nɨjáa mʉlwɨ́ɨrɨ sɨ mʉʉja noo kʉʉnaangirirya tʉkʉ, nɨjáa mʉnyololwii sɨ mʉʉja no kʉʉnaanga tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aho, novo kuuyirya varɨ voosea, ‘Mʉkʉ́lʉ nɨ naadi ˆtakoona ʉrɨ na njala, au ʉrɨ na nyóota, au ʉrɨ mʉyeni, au ʉrɨ na tʉhʉ, au ʉrɨ mʉlwɨ́ɨrɨ, au ʉrɨ mʉnyololwii, na suusu sɨ twakʉlaanga?’ ");
INSERT INTO lag_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ne vasea arɨ, ‘Kɨmaarɨ noovawyɨɨra, ja ˆvyeene sɨ mʉmʉbweeyyirya ʉmwɨ wa ava vaaniitʉ vaduudi, sɨ mʉʉmbweeyyirya nɨɨnɨ tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aho, avo kɨɨngɨra varɨ kʉlaɨrwa chiirʉ kwa sikʉ ˆjisiina ʉhero, maa kaa, vara vawoloki kɨɨngɨra varɨ na nkaaswii ya sikʉ ˆjisiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yéesu ˆakamarikirye kʉlʉʉsa ayo yoosi, akavasea vapooji vaachwe, ");
INSERT INTO lag_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Taanga mwiise sikʉ ivɨrɨ ˆjiri looka kʉva ɨrɨ Paásika na Mwaana wa Mʉʉntʉ vɨɨkwa arɨ mɨkonwii ya vavɨ na muningʼinʼya varɨ mʉsaláabii fʉʉrʉ akwye wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mpɨɨndɨ ijo, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vawosi vajáa valʉmana balásii ya nyuumbii ya kɨtemi ya mweeneɨsɨ mʉkʉʉlʉ ˆasewáa Kayáafa. ");
INSERT INTO lag_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Vakabweeyya mʉryʉʉngʉ wa iyasi sa vamʉkwaate Yéesu kimbiso na vamʉʉlae. ");
INSERT INTO lag_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Maa kaa, vakasea, “Karɨ ɨve mpɨɨndɨ ja ɨhɨ ngovi tʉkʉ, sa karɨ jɨ kʉve na ntiribʉka tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mpɨɨndɨ Yéesu ˆajáa iturii ra Besanía kaayii kwa Simóoni ˆmweene asewáa ˆarɨ na ʉlóónda, ");
INSERT INTO lag_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mʉʉntʉ muki ʉmwɨ ajáa ʉʉja ˆarɨ na chʉ́pa ya iwye ˆrasongolwa ˆɨrɨ na makuta ˆyanyʉ́kɨraa ya iyoombe ikʉʉlʉ. Ʉwo mʉʉntʉ muki ajáa ʉʉja na hara méesii kʉʉntʉ ˆarijáa chákurya, akawuna ɨra chʉ́pa, maa akayakʉʉrɨra ayo makuta mutwii wa Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Vapooji vaachwe ˆvakoone jeyyo, vakakalala voosea, “Nɨ wa che ʉsaambʉ ʉhʉ? ");
INSERT INTO lag_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Makuta aya, ngaarɨ yawúsirwe kwa iyoombe ikʉʉlʉ, na ijo mpía jivaambirirye vakɨva!” ");
INSERT INTO lag_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yéesu ajáa ataanga miiririkano yaavo, maa akavasea, “Amwɨ moomujuuwa ʉhʉ maáma? Yeeye aantʉ́mamɨɨre kɨɨntʉ ˆchabooha. ");
INSERT INTO lag_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vakɨva novo mʉrɨ mpɨɨndɨ joosi, maa kaa, nɨɨnɨ sɨ ndɨrɨ kʉva na nyuunyu sikʉ joosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ʉhʉ maáma ˆakakʉʉrɨre mʉvɨrɨ waanɨ makuta, uuvíikire neeja so taahwa. ");
INSERT INTO lag_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kɨmaarɨ noovawyɨɨra, haantʉ hohoosi kʉrɨ weerʉ Masáare Maaja ˆyarɨ variyʉlwa, ɨkɨ ˆcheene akɨtʉ́mamire ʉhʉ mʉʉntʉ muki, lʉʉswa kɨrɨ ja nkʉmbʉkɨra yaachwe.” ");
INSERT INTO lag_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aho, ʉmwɨ wa vara ikimi na vavɨrɨ, ˆaséwaa Yʉ́ʉda Isikarióoti, akadoma na kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, ");
INSERT INTO lag_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akavasea, “Nɨ che mʉrɨ kʉʉmpeera koonɨ namʉválandukire Yéesu nɨmʉvɨɨke mɨkonwii yaanyu?” Vakamʉvarɨra mpía makumi yatatʉ (30). ");
INSERT INTO lag_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na kwaandɨra aho, Yʉ́ʉda akaanda saakɨra nkalo ˆyabooha yo mʉvalandʉka Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sikʉ ya ncholo ya ngovi ya mɨkáate sɨ ˆɨvɨ́kɨrwaa ʉsasɨ, vapooji vajáa vamʉdomera Yéesu vakamuurya, “Hai woosaaka tukwiimirye neeja chóorya cha Paásika sa urye?” ");
INSERT INTO lag_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne akavasea, “Tamanyi na múujii kwa mʉʉntʉ ʉmwɨ mʉmʉsee, ‘Mukiindya aséire, mpɨɨndɨ yaanɨ yafíkire, rɨɨra ndɨrɨ ngovi ya Paásika hamwɨ na vapooji vaanɨ kaayii kwaako.’ ” ");
INSERT INTO lag_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Vapooji vakabweeyya ja ˆvyeene Yéesu ajáa avaláiriirye, vakiimya neeja chóorya cha Paásika. ");
INSERT INTO lag_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iwʉlo ˆrɨkɨɨngɨre, Yéesu akava méesii hamwɨ na vapooji vaachwe ikimi na vavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na mpɨɨndɨ ˆvarijáa, Yéesu akasea, “Kɨmaarɨ noovawyɨɨra, ʉmwɨ waanyu kʉʉnvarindʉka arɨ.” ");
INSERT INTO lag_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Vapooji vaachwe vakavisʉʉla maatʉkʉ vii, maa vakaanda kuurya ʉmwɨ ʉmwɨ, “Mʉkʉ́lʉ, sɨ viri kʉva nɨ nɨɨnɨ tʉkʉ?” ");
INSERT INTO lag_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yéesu akavasea, “Ʉra ˆaríiriirye mʉkáate hamwɨ na nɨɨnɨ luumbwii noo ˆarɨ kʉʉnvarindʉka. ");
INSERT INTO lag_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwaana wa Mʉʉntʉ nɨ tamanya iise no kʉʉlawa ja ˆvyeene vyaandɨkwa Masáarii ˆYarɨ Mpeho. Maa kaa, nɨ mpolaɨ kwa mʉʉntʉ ʉra ˆarɨ mʉvarindʉka! Nɨ pwee vijáa ngaarɨ baa sɨ avyaalwa.” ");
INSERT INTO lag_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yʉ́ʉda ʉra mʉvalanduki waachwe akamʉsea, “Mukiindya, kɨkomi sɨ nɨɨnɨ tʉkʉ?” Yéesu akamʉsea, “Weewe ulúusire.” ");
INSERT INTO lag_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mpɨɨndɨ ˆvarijáa, Yéesu akatoola mʉkáate, akamʉdʉʉmba Mʉlʉʉngʉ, akʉʉbendʉlabendʉla, maa akavaheera vapooji vaachwe yoosea, “Tooli, murye, ʉhʉ nɨ mʉvɨrɨ waanɨ.” ");
INSERT INTO lag_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aho, akatoola ndʉvo, akamʉdʉʉmba Mʉlʉʉngʉ akavaheera yoosea, “Tooli voosi munywe diváai fuma nduvwii ɨhɨ. ");
INSERT INTO lag_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ɨhɨ nɨ sakami yaanɨ ya mʉháko, sakami ˆyookiitwa sa ˆvarɨ foo vaseyyiriwe ʉvɨ. ");
INSERT INTO lag_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nɨ kʉvawyɨɨra niise, sɨ ndɨrɨ kʉnywa kei ɨhɨ diváai ya sabíibu tʉkʉ, fʉʉrʉ sikʉ ˆndɨrɨ kiinywa ifya hamwɨ na nyuunyu Ʉtemii wa Taáta waanɨ.” ");
INSERT INTO lag_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ˆVakɨɨmbe lwɨɨ́mbo, vakalooka na Luulwii lwa Mɨseitúuni. ");
INSERT INTO lag_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aho, Yéesu akavasea, “Uchikʉ ʉhʉ wa isikʉ voosi kʉʉndeka mʉrɨ. Sa Masáare ˆYarɨ Mpeho yasea, ‘Kʉmʉvaa ndɨrɨ muríisi, na muundi ja mpuka yaachwe jiipase.’ ");
INSERT INTO lag_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Maa kaa, ˆndɨrɨ fʉfʉka, valongorera ndɨrɨ na ɨsɨ ya Galiláaya.” ");
INSERT INTO lag_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peéteri akamʉsea Yéesu, “Baa koonɨ voosi varɨ kʉreke weewe, nɨɨnɨ sɨ ndɨrɨ kʉreka vii kaa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yéesu akamʉsea, “Kɨmaarɨ kaa nookuwyɨɨra, uchikʉ ʉhʉ nkʉkʉlʉme sɨ ɨnavɨɨka, lʉʉsa ʉrɨ sɨ wʉʉmányire tʉkʉ katatʉ.” ");
INSERT INTO lag_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peéteri akamʉsea, “Koonɨ baa nɨ mpaka nkwye, kukwya ndɨrɨ hamwɨ na weewe, sɨ ndɨrɨ sea sɨ nakʉmányire tʉkʉ.” Baa vara vapooji vɨɨngɨ vakalʉʉsa vivira. ");
INSERT INTO lag_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Aho, Yéesu akafika na vapooji vaachwe Getisemáane, ʉko akavasea, “Ikali aha, nɨɨnɨ tamanya niise na hara mbere noo mʉloomba Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akamʉsʉmʉla Peéteri na vaana vavɨrɨ va Sebedáayo, na mpɨɨndɨ ˆvatamanyáa, mʉtɨma waachwe ʉkafɨrɨra kʉnʉ yookiiteera ʉsʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aho, akavasea, “Mʉtɨma waanɨ wookaava kende nkwye. Ikali aha, mʉkeeshe chɨrɨrɨ hamwɨ na nɨɨnɨ.” ");
INSERT INTO lag_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ˆAkaseese na mbere kiduudi, akalaala ɨsɨ na ɨnda akamʉloomba Mʉlʉʉngʉ yoosea, “Taáta waanɨ, koonɨ viri dahɨka ndʉvo ɨhɨ yaandooke, maa kaa, sɨ ɨve ja ˆvyeene noosaaka tʉkʉ, ɨve ja ˆvyeene woosaaka weewe.” ");
INSERT INTO lag_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Akatamanya na kwa vara vapooji vaachwe vatatʉ, akavashaana valɨ́ɨre. Akamʉsea Peéteri, “Arumi, mwasíindirwe keesha na nɨɨnɨ baa kwa isaa rɨmwɨ vii wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Keeshi na mʉloombe sa karɨ jɨ mwɨɨngɨre mʉtehwii tʉkʉ. Mʉtɨma wɨɨ́mɨre neeja kʉtʉmama wʉʉja, maa kaa, wasíindwaa sa mʉvɨrɨ usiina ngururu tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akatamanya kei lwa kavɨrɨ no mʉloomba Mʉlʉʉngʉ yoosea, “Taáta waanɨ, koonɨ ndʉvo ɨhɨ ya uturikiri sɨ viri dahɨka yʉʉnehe, ndɨɨre kwiinywa, haaha ˆvyeene woosaaka vikiimane.” ");
INSERT INTO lag_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kei ˆakahɨndʉke, akavashaana valɨ́ɨre, miiso yaavo yajáa yaréheriiwe nɨ tʉlo. ");
INSERT INTO lag_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Akavareka, akatamanya lwa katatʉ no mʉloomba Mʉlʉʉngʉ kwa masáare yayara. ");
INSERT INTO lag_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Aho, akadoma na kwa vara vapooji vaachwe akavasea, “Nyuunyu mʉkaarɨ mʉlɨ́ɨre no hʉmʉlʉka wʉʉ? Laangi, mpɨɨndɨ jafíkire, Mwaana wa Mʉʉntʉ varindʉkwa iise na vɨɨkwa iise mɨkonwii ya vavɨ. ");
INSERT INTO lag_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Inuki, hendi tʉlooke! Laangi, ʉra ˆyoojokʉʉnvarindʉka afíkire!” ");
INSERT INTO lag_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mpɨɨndɨ Yéesu ˆajáa akaarɨ yoolʉʉsɨka novo, Yʉ́ʉda ʉmwɨ wa vapooji vaachwe ikimi na vavɨrɨ akafika. Yeeye ajáa ʉʉjanʼya na vaantʉ ˆvarɨ foo ˆvarɨ na nyaasʉka na nkusi. Ava ˆvajáa vatúmirwe nɨ vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na nɨ vawosi. ");
INSERT INTO lag_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Haaha ʉra ˆamʉvalandʉkáa Yéesu ajáa ahʉ́mwɨɨre valaɨra isháara yoosea, “Ʉra ˆndɨrɨ mʉsʉndɨra ja noomuluumbya, noo yeeye, mʉkwaati.” ");
INSERT INTO lag_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yʉ́ʉda akahʉlʉlʉka na kʉrɨ Yéesu, akamuluumbya, “Lʉmbɨ ee Mukiindya!” Maa, akamʉsʉndɨra. ");
INSERT INTO lag_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yéesu akamʉsea, “Kɨjeengi, tʉmama ˆcheene chakʉréetire.” Aho, vara vaantʉ vakaseesa, vakamʉkwaata Yéesu, maa vakamʉvɨɨka mɨkonwii yaavo. ");
INSERT INTO lag_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hahara, ʉmwɨ wa vara ˆvajáa na Yéesu ˆakoone jeyyo, akakʉʉla nyaasʉka njatwii, akamʉtema kutu dúú mʉtʉmami wa mweeneɨsɨ mʉkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yéesu akamʉsea, “Hɨndʉla nyaasʉka yaako na njatwii, sa voosi vara ˆvʉʉ́laa na nyaasʉka, novo kukwya varɨ kwa nyaasʉka. ");
INSERT INTO lag_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sa che wookiisea sɨ ndɨrɨ daha kʉmʉloomba Taáta waanɨ aandetere haaha jei kʉlookya mayana ikimi na yavɨrɨ (12,000) ya valwi nkoondo va mirimʉ miija? ");
INSERT INTO lag_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Maa kaa, koonɨ nabwéeyyiirye jeyyo, joolɨ Masáare ˆYarɨ Mpeho yarɨ kiimana yara ˆyasea ivi nɨ mpaka vifʉmɨre jei?” ");
INSERT INTO lag_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mpɨɨndɨ ijo, Yéesu akɨɨsea ɨra mpuka ya vaantʉ, “Nɨɨnɨ ndɨrɨ mʉhóki vaantʉ viintʉ, muújire noo kʉʉnkwaata na nyaasʉka na nkusi wʉʉ? Sikʉ joosi nɨjáa na nyuunyu noovariyʉla waámii wa Kaaya Njija ya Ijʉva. Amwɨ sɨ mwaankwaatáa kʉra? ");
INSERT INTO lag_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aya yoosi yafʉ́mɨɨre sa masáare ya valáali na mʉtwe yara ˆvaandɨka Masáarii ˆYarɨ Mpeho yakiimane.” Aho, vapooji voosi vakamʉreka, maa vakatɨɨja. ");
INSERT INTO lag_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Vara ˆvajáa vamʉkwáatire Yéesu, vakamʉtwaala na kwa Kayáafa, mweeneɨsɨ mʉkʉʉlʉ, ʉko vakiindya va Miiro na vawosi vajáa valʉ́mɨɨne. ");
INSERT INTO lag_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Maa kaa, Peéteri ajáa amutúubire Yéesu kwa kʉlɨ fʉʉrʉ waámii ya mweeneɨsɨ mʉkʉʉlʉ. Akɨɨngɨra, maa akiikala hamwɨ na valʉkalʉka, sa oone ˆcheene kɨrɨ fʉmɨra. ");
INSERT INTO lag_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva hamwɨ na Balása Nkʉʉlʉ yoosi ya Vayahúudi vasaakɨráa ʉshahíidi wa ʉloongo kʉrɨ Yéesu sa vadahe kʉmʉʉlaa. ");
INSERT INTO lag_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Maa kaa, sɨ vapata kɨɨntʉ tʉkʉ, baa neembe mashahíidi ˆvarɨ foo va ʉloongo vɨɨmáa mbere. Maa reerʉ, mashahíidi vavɨrɨ vakafʉmɨra, ");
INSERT INTO lag_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","vakasea, “Ʉhʉ mʉʉntʉ asea, ‘Daha ndɨrɨ kwiigirimʉla Kaaya Njija ya Mʉlʉʉngʉ na nɨɨjeenge kei kwa sikʉ itatʉ.’ ” ");
INSERT INTO lag_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aho, mweeneɨsɨ mʉkʉʉlʉ akiinʉka, maa akamʉsea Yéesu, “Sɨ wookuuyirya kɨɨntʉ chochoosi tʉkʉ wʉʉ? Aya masáare ava vaantʉ ˆvookusitaakya nɨ kɨɨntʉ che?” ");
INSERT INTO lag_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Maa kaa, Yéesu akakirinya. Mweeneɨsɨ mʉkʉʉlʉ akamʉsea, “Kʉbweeyya niise wiilahe mbere ya Mʉlʉʉngʉ ˆArɨ Nkaasʉ, tʉwyɨɨre koonɨ weewe noo Masía, Mwaana wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yéesu akasea, “Weewe ulúusire. Maa kaa, nɨ kʉvawyɨɨra niise voosi, kwaandɨra haaha kʉmoona mʉrɨ Mwaana wa Mʉʉntʉ iíkyɨɨre mʉkono wa kʉlʉme wa Mweenengururu, yookʉʉja mweeri ya machu ya kurumwii.” ");
INSERT INTO lag_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aho, mweeneɨsɨ mʉkʉʉlʉ akamoola ɨngo jaachwe na nkalari yoosea, “Ahíintikire! Ʉshahíidi wa che kei toosaaka? Laangi, nyuunyu mwatéɨɨre ʉwo uhiintiki. ");
INSERT INTO lag_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Joolɨ moolamʉla?” Vakamʉsea, “Akiimana akwye.” ");
INSERT INTO lag_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aho, vakamʉchwɨɨra matɨ kishwii na vɨɨngɨ vakamʉvaa ngúumi. Vɨɨngɨ vakamʉhapʉla makóofi ");
INSERT INTO lag_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na vakamʉhenchʉla voosea, “Weewe Masía, hoonɨ taanga nɨ ani ˆakʉváire?” ");
INSERT INTO lag_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Haaha mpɨɨndɨ ijo joosi, Peéteri ajáa iíkyɨɨre weerwii ʉko waámii. Mʉtʉmami ʉmwɨ wa kɨɨntʉ kiki akamʉseeserera Peéteri, maa akamʉsea, “Baa weewe nɨ hamwɨ waarɨ na Yéesu wa Galiláaya.” ");
INSERT INTO lag_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Maa kaa, Peéteri akasiita mbere ya voosi yoosea, “Sɨ nootaanga baa ɨkɨ ˆwoolʉʉsa tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aho, Peéteri akɨɨtookɨɨma mutiryaangwii wa waámii, mʉtʉmami wɨɨngɨ wa kɨɨntʉ kiki akamoona Peéteri, maa akavasea vaantʉ ˆvajáa aho, “Ʉhʉ nɨ hamwɨ aarɨ na Yéesu wa Nasaréeti.” ");
INSERT INTO lag_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peéteri akasiita kei ko kiilaha yoosea, “Sɨ namʉmányire ʉwo mʉʉntʉ tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mpɨɨndɨ kiduudi vaantʉ ˆvajáa viímire aho, vakamʉseeserera, maa vakamʉsea, “Kɨkomi weewe ʉrɨ ʉmwɨ waavo, sa baa ndʉʉsɨka yaako yookoonekya.” ");
INSERT INTO lag_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aho, Peéteri akaanda kwiijuma yeemweene, na iilaháa yoosea, “Kɨmaarɨ! Sɨ namʉmányire ʉwo mʉʉntʉ tʉkʉ!” Haaho, nkʉkʉlʉme ɨkavɨɨka. ");
INSERT INTO lag_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aho, Peéteri akakʉmbʉkɨra masáare ˆajáa awyɨ́ɨrɨɨrwe nɨ Yéesu, “Nkʉkʉlʉme sɨ ɨnavɨɨka, sea ʉrɨ sɨ waamányire tʉkʉ katatʉ.” Aho, maa re akafuma na weerwii akɨɨtoorɨra maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ˆKʉkamwaae, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva voosi na vawosi vakalamʉla kʉmʉʉlaa Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Vakamuchuunga pɨɨ́ngʉ, vakamʉtwaala na kwa Piláato, gávana wa ɨsɨ ya Yudéea, maa vakamʉkwaatya kwaachwe. ");
INSERT INTO lag_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Haaha Yʉ́ʉda ʉhʉ ˆajáa amʉválandukire ˆakoone Yéesu ahʉ́mwɨɨre heewa irya, akiivairya mbiri, maa akavahɨndʉrɨra vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vawosi jira mpía makumi yatatʉ (30). ");
INSERT INTO lag_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akavasea, “Nahóniirye kʉmʉtoola mʉʉntʉ ˆasiina ʉvɨ ʉʉlawe.” Maa kaa, voovo vakamʉsea, “Ayo ˆwootuwyɨɨra yasiina nyambirirya kʉrɨ suusu tʉkʉ, nɨ yaako mweeneevyo.” ");
INSERT INTO lag_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Akajifweitɨra ijo mpía makumi yatatʉ na Kaayii Njija ya Ijʉva, maa akatamanya no kiikuva. ");
INSERT INTO lag_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva vakajitoola ijo mpía, maa vakasea, “Miiro yakaanʼya kujisaangya iji mpía na mpía ja Kaaya Njija, sa nɨ mpía ja sakami.” ");
INSERT INTO lag_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aho, vakalʉma sáare, maa vakalamʉla kujiwʉrɨra iwʉnda ra kɨrongorongo rɨve haantʉ ho taahɨra vayeni. ");
INSERT INTO lag_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Noo ˆchooreka fʉʉrʉ isikʉ, ɨro iwʉnda raséwaa Iwʉnda ra Sakami. ");
INSERT INTO lag_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jeyyo, masáare ya Yeremía mʉláali na mʉtwe yakakiimana, “Vajáa vasʉmʉla jira mpía makumi yatatʉ, iyoombe ˆapaangɨrwa nɨ vaantʉ va Isiraéeli. ");
INSERT INTO lag_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ijo mpía vakawʉrɨra iwʉnda ra kɨrongorongo, ja ˆvyeene Ijʉva aandairirya.” ");
INSERT INTO lag_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Haaha, vakamwiimya Yéesu mbere ya gávana Piláato, ne Piláato akamuurya, “Weewe noo mʉtemi wa Vayahúudi wʉʉ?” Yéesu akamʉsea, “Weewe ulúusire.” ");
INSERT INTO lag_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Maa kaa, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vawosi ˆvakamusitaakye, yeeye sɨ uuyirya isáare tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Piláato akamuurya, “Sɨ wooteera nɨ masáare yangaɨ vookusitaakya tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Maa kaa, Yéesu sɨ uuyirya baa isáare rɨmwɨ tʉkʉ, ʉwo gávana akatʉlʉvala maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Haaha, sikʉ ja ngovi ya Paásika, gávana ajáa aviijuvirya Vayahúudi kʉmʉchʉngʉrɨra mufúungwa ʉmwɨ ˆmweene varɨ saaka. ");
INSERT INTO lag_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mpɨɨndɨ ijo, kʉjáa kwatɨɨte mufúungwa ʉmwɨ ˆajáa ataangɨkana maatʉkʉ vii sa ʉvɨ, ˆasewáa Baráaba. ");
INSERT INTO lag_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sa jeyyo, vaantʉ ˆvakiijiinge, Piláato akavuurya, “Nɨ ani moosaaka nɨmʉchʉngʉrɨre kati ya ava vavɨrɨ, Baráaba au Yéesu ˆaséwaa Masía?” ");
INSERT INTO lag_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ajáa alʉʉsa jeyyo sa ajáa ataanga vajáa vamusítakiirye Yéesu kwaachwe sa kɨvɨna. ");
INSERT INTO lag_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mpɨɨndɨ Piláato ˆajáa iíkyɨɨre aho ichuumbii raachwe ro lamʉrɨra, muki waachwe akamʉtwaarɨra mʉlomo, “Karɨ jɨ ʉmʉbweeyyirye ʉvɨ wowoosi mʉʉntʉ ʉwo mʉwoloki tʉkʉ, sa nɨɨnɨ natʉ́rɨkɨɨre maatʉkʉ vii noolootera sa yeeye uchikʉ ʉhʉ.” ");
INSERT INTO lag_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Maa kaa, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vawosi vakavasoonka vaantʉ valoombe Baráaba achʉngʉrɨrwe na Yéesu ʉʉlawe. ");
INSERT INTO lag_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aho, gávana akavuurya, “Nɨ ani moosaaka nɨmʉchʉngʉrɨre kati ya ava vavɨrɨ?” Voovo vakamʉsea, “Baráaba!” ");
INSERT INTO lag_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Piláato akavuurya, “Haaha che ndɨrɨ mʉbweeyya Yéesu ˆaséwaa Masía?” Voosi vakasea, “Aningʼiniwe mʉsaláabii fʉʉrʉ akwye!” ");
INSERT INTO lag_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ne akavuurya, “Sa che? Ʉvɨ che abwéeyyiirye?” Voovo vakatuuba tʉla isóso voosea, “Aningʼiniwe mʉsaláabii fʉʉrʉ akwye!” ");
INSERT INTO lag_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Piláato ˆakoone hasiina yooseesya tʉkʉ na baa ʉsaambʉ waándire, ajáa atoola maaji, maa akooyya mɨkono yaachwe mbere ya vaantʉ yoosea, “Nɨɨnɨ nsiina ʉvɨ mweeri ya inkwya ya ʉhʉ mʉʉntʉ tʉkʉ. Ɨrɨ isáare nɨ mweeri yaanyu rɨrɨ, rɨlaangi.” ");
INSERT INTO lag_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Vaantʉ voosi vakasea, “Sakami yaachwe ɨveere mweeri yiiswi na vaana viiswi.” ");
INSERT INTO lag_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aho, Piláato akamʉchʉngʉrɨra Baráaba fuma mʉnyololwii sa voovo, maa kaa, akalairirya Yéesu avawe mɨjeléedi maa akamʉtoola aningʼiniwe mʉsaláabii fʉʉrʉ akwye. ");
INSERT INTO lag_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aho, valʉkalʉka va gávana vakamʉtwaala Yéesu na ijuumbii ra kɨtemi ra Piláato ˆrɨséwaa Puraitória. Ʉko, valwi nkoondo voosi vakiijiinga kʉmʉrɨɨngɨrɨra Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Vakamufumya ɨngo jaachwe, maa vakamʉvɨkɨra ɨngo ˆɨrɨ gyaa atɨ ja mʉtemi. ");
INSERT INTO lag_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aho, vakalʉka kɨsasaavo cha miíwa, vakamʉvɨkɨra mutwii, vakamʉkwaatya dʉʉrɨ mʉkonwii waachwe wa kʉlʉme, maa de vandoomwiinamɨra, voomʉhenchʉla voosea, “Lamʉkyaade ee aaɨ, mʉtemi wa Vayahúudi!” ");
INSERT INTO lag_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Vakamʉchwɨɨra matɨ, vakatoola ɨra dʉʉrɨ vakatuuba mʉvaa noyo mutwii. ");
INSERT INTO lag_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ˆVakahʉmʉle kʉmʉhenchʉla, vakamufumya ɨra ɨngo ˆɨrɨ gyaa, maa vakamʉvɨkɨra ɨngo jaachwe kei. Aho, vakamʉtwaala fʉʉrʉ weerwii ya múuji noo muningʼinʼya mʉsaláabii fʉʉrʉ akwye. ");
INSERT INTO lag_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Njirii, vakalʉmana na mʉʉntʉ ʉmwɨ fuma múujii wa Kɨréene ˆaséwaa Simóoni. Valwi nkoondo vakamʉdoomererya avaale mʉsaláaba wa Yéesu. ");
INSERT INTO lag_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na ˆvakafike haantʉ ˆhaséwaa Goligóota, noo kʉsea Kɨsááya cha Mʉtwe, ");
INSERT INTO lag_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","valwi nkoondo vakamʉheera Yéesu diváai ˆyasaangiwa na kɨsʉʉngʉ so seyya makuundi, maa kaa, yeeye ˆakɨɨsaɨre, akasiita kʉnywa. ");
INSERT INTO lag_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ˆVakahʉmʉle kumuningʼinʼya mʉsaláabii, vakiigavɨra ɨngo jaachwe ko vaa mbare. Jeyyo, isáare rɨra ˆralʉʉswa nɨ mʉláali na mʉtwe rɨkakiimana, “Viigavɨra mɨrwaalo yaanɨ, kati yaavo na ɨngo yaanɨ vakɨɨvaɨra mbare.” ");
INSERT INTO lag_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Vakiikala, vakatuuba kʉmʉlaangirirya. ");
INSERT INTO lag_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mweeri ya mʉtwe waachwe vakavɨɨka ishitáaka ˆraandɨkwa, “Ʉhʉ nɨ Yéesu, mʉtemi wa Vayahúudi.” ");
INSERT INTO lag_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Viívi vavɨrɨ vajáa vaningʼiniwa mɨsaláabii hamwɨ ne, ʉmwɨ mʉkono wa kʉmooso na wɨɨngɨ mʉkono wa kʉlʉme, kɨra mʉʉntʉ mʉsaláabii waachwe. ");
INSERT INTO lag_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Vaantʉ vara ˆvalookáa na aho, vamʉtʉkɨráa voosingisya mɨtwe kwa heenchʉ voosea, ");
INSERT INTO lag_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Hoonɨ ta ilaange, atɨ girimʉla ʉrɨ Kaaya Njija na wɨɨjeenge kwa sikʉ itatʉ? Haaha ilamurirye we mweeneevyo. Koonɨ kɨkomi weewe nɨ Mwaana wa Mʉlʉʉngʉ, kiima aho mʉsaláabii!” ");
INSERT INTO lag_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Baa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, hamwɨ na vawosi na vakiindya va Miiro vakamʉhenchʉla voosea, ");
INSERT INTO lag_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Avalamuriryáa vɨɨngɨ, amwɨ yoosiindwa kiilamurirya yeemweene? Atɨ yeeye nɨ mʉtemi wa Isiraéeli! Hoonɨ nɨ akiime mʉsaláabii naasu tumurume. ");
INSERT INTO lag_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yeeye amwiiláangyaa Mʉlʉʉngʉ, na ajáa alʉʉsa yeeye nɨ Mwaana wa Mʉlʉʉngʉ, haaha Mʉlʉʉngʉ nɨ amʉlamurirye koonɨ yoomʉsaaka.” ");
INSERT INTO lag_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Baa vara ˆvajáa vaníngʼiniiwe mɨsaláabii hamwɨ ne, vakamʉtʉkɨra. ");
INSERT INTO lag_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kwandɨra mpɨɨndɨ ja mpoloonge fʉʉrʉ mpɨɨndɨ ja cháámuusi, kilwiirya kɨkakʉnɨkɨrɨra ɨsɨ yoosi. ");
INSERT INTO lag_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mpɨɨndɨ jo kiimikirirya ja cháámuusi, Yéesu akarɨra na ngururu yoosea, “Éeli, Éeli láama sabakɨtáani?” noo kʉsea, “Ee Mʉlʉʉngʉ, Ee Mʉlʉʉngʉ, amwɨ waandékire?” ");
INSERT INTO lag_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Maa kaa, vamwɨ va vaantʉ ˆvajáa hara ˆvakateere jeyyo, maa vakasea, “Ʉhʉ, yoomʉkemera Elía.” ");
INSERT INTO lag_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ʉmwɨ waavo akatamanya chaangʉ, akatukya kɨɨntʉ ˆkɨrɨ monyomonyo diváaii ˆyasasʉka, akakɨfarɨmbɨrɨra isaangii, maa akamʉheera anywe. ");
INSERT INTO lag_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Maa kaa, vɨɨngɨ vakasea, “Reki toone koonɨ Elía arɨ kʉʉja noo mʉlamurirya.” ");
INSERT INTO lag_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Maa reerʉ, Yéesu akaana kei vikʉlʉkʉʉlʉ, aho, akawulala. ");
INSERT INTO lag_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Haaho, ipasía ra Kaaya Njija rɨkaatʉka katɨ na katɨ fuma mweeri fʉʉrʉ ɨsɨ, ɨsɨ ɨkasɨngɨsɨka na myaalaliwye ɨkaatʉka. ");
INSERT INTO lag_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mbɨrɨ́ɨ́ra jikakʉnʉkʉka na mɨvɨrɨ ya vaaja vara ˆvajáa vaakwya ɨkafʉfʉka. ");
INSERT INTO lag_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yéesu ˆakafʉfʉke, avo vaantʉ vakafuma mbiríírii, na vakatamanya na múujii mʉʉja na vakavafʉmɨra vaantʉ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo na vara ˆvajáa ne voomʉlaangirirya Yéesu ˆvakoone kɨra kitiíntima na yara yoosi ˆyajáa yafʉ́mɨɨre, vakoofa mʉnʉmʉʉnʉ, voosea, “Ʉhʉ kɨkomi nɨ Mwaana wa Mʉlʉʉngʉ aarɨ.” ");
INSERT INTO lag_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kʉjáa kwatɨɨte vaantʉ vaki ˆvarɨ foo ˆvalaangáa ayo kwa kʉlɨ. Avo vajáa vamutuuba Yéesu fuma Galiláaya sa vɨndoomʉtʉmamɨra. ");
INSERT INTO lag_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kʉrɨ vamwɨ vaavo, ˆajáa amwaarɨ, Maríia Makɨdaléena, Maríia íyo waala Yaakúupu na Yóose, na íyo waala vaana va Sebedáayo. ");
INSERT INTO lag_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Haaha iwʉlo ˆrɨkɨɨngɨre, ajáa ʉʉja musúngaati ʉmwɨ fuma múuji wa Arimatáaya ˆasewáa Yooséefu. Ʉhʉ ne nɨ mʉpooji wa Yéesu ajáa. ");
INSERT INTO lag_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Akamʉdomera Piláato noo koomʉloomba mʉvɨrɨ wa Yéesu. Piláato akalairirya aheewe. ");
INSERT INTO lag_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yooséefu akʉʉsʉmʉla mʉvɨrɨ, akʉʉfarɨmbɨrɨra sáanda ya kɨtáani cha kikomi, ");
INSERT INTO lag_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","maa akʉʉvɨɨka mbiríírii yaachwe mweeneevyo. Ɨyo mbɨrɨ́ɨ́ra ya mpaanga nɨ ifya na ɨjáa yabokwa mwaalaliwyii. Aho, akafingiritya iwye ikʉlʉkʉʉlʉ, yoorifintamya mʉryaangwii wa mbɨrɨ́ɨ́ra, maa akalooka. ");
INSERT INTO lag_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maríia Makɨdaléena na ʉra Maríia wɨɨngɨ vajáa vamwaarɨ aho haantʉ viíkyɨɨre kʉlaanga mbɨrɨ́ɨ́ra. ");
INSERT INTO lag_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lomʉtóondo yaachwe nɨ sikʉ ya Sabáato ɨjáa, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na Mafarisáayo vakatamanya na kwa Piláato. ");
INSERT INTO lag_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Vakamʉsea Piláato, “Mʉkʉ́lʉ, takʉ́mbʉkɨɨre, ʉra mʉkwaata de akwye ajáa asea, ‘Sikʉ itatʉ ˆjiri looka, fʉfʉka ndɨrɨ.’ ");
INSERT INTO lag_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sa jeyyo, ʉlairirye mbɨrɨ́ɨ́ra ɨlaangiririwe kamwɨ fʉʉrʉ sikʉ ya katatʉ. Koonɨ sɨ jeyyo, vapooji vaachwe ifaanaa vʉʉje, viive mʉvɨrɨ waachwe na vavawyɨɨre vaantʉ afúfukire fuma inkwyii. Ʉkwaata ʉhʉ wo kiimikirirya kʉva ʉrɨ wavɨɨha kʉlookya wa ncholo.” ");
INSERT INTO lag_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Piláato akavasea, “Nyuunyu sumuli valʉkalʉka. Tamanyi mʉkɨɨvɨɨkɨre valʉkalʉka va kɨkomi ja ˆvyeene mʉrɨ daha.” ");
INSERT INTO lag_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sa jeyyo, vakatamanya na valʉkalʉka sa vakalaangirirye mbɨrɨ́ɨ́ra kɨkomi, vakavaa mɨtooso rɨra iwye na vakavɨɨka ʉlaangiriryi. ");
INSERT INTO lag_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabáato ˆɨkalooke namʉtóondo dwɨɨ sikʉ ya Jumapɨ́ɨrɨ,Maríia Makɨdaléena, na ʉra Maríia wɨɨngɨ vajáa vadoma noo laanga mbɨrɨ́ɨ́ra ya mpaanga ɨra ˆɨjáa yabokwa mwaalaliwyii. ");
INSERT INTO lag_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Koonka, kitiíntima kɨkʉʉlʉ kɨkafʉmɨra sa murimʉ mʉʉja wa Ijʉva ʉjáa wakiima fuma kurumwii, ʉkafingiritya rɨra iwye, maa ʉkariikarɨra. ");
INSERT INTO lag_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ʉwo murimʉ buuwo yaachwe ɨjáa nɨ ja lʉlávo, na ɨngo jaachwe jijáa jeera ja mawye ya mbula. ");
INSERT INTO lag_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Vara valʉkalʉka va mbɨrɨ́ɨ́ra vajáa voofa maatʉkʉ vii, vakatetema fʉʉrʉ vakava ja ˆvaakwya. ");
INSERT INTO lag_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ʉra murimʉ mʉʉja ʉkavasea vara vaantʉ vaki, “Koofi tʉkʉ, sa taanga niise nɨ mʉsaakɨra mwiise Yéesu ʉra ˆaningʼiniiwé mʉsaláabii fʉʉrʉ akakwya. ");
INSERT INTO lag_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Asiina aha tʉkʉ, afúfukire ja ˆvyeene asea. Yeendi mʉlaange haantʉ ˆalaariiwé. ");
INSERT INTO lag_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Haaha tamanyi chaangʉ mʉkavasee vapooji vaachwe, ‘Afúfukire fuma inkwyii, ne longoola iise na Galiláaya. Ʉko moona mʉrɨ.’ Laangi, nahʉ́mwɨɨre vawyɨɨra.” ");
INSERT INTO lag_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jeyyo, vara vaantʉ vaki vakiinʉka hara varɨ na cheerʉ mʉnʉmʉʉnʉ kʉnʉ vɨɨ́ngɨɨrwe nɨ woowa, vakafuma mbiríírii itɨ́ɨjo vakatamanya noo vawyɨɨra vapooji vaachwe ɨrɨ isáare. ");
INSERT INTO lag_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Koonka, Yéesu akalʉmana novo akavasea, “Lʉmbɨ niijo!” Vara vaantʉ vaki vakamʉseeserera, vakachwaama, vakakwaata majeo yaachwe, vakamwiinamɨra. ");
INSERT INTO lag_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aho, Yéesu akavasea, “Koofi tʉkʉ. Tamanyi mʉkavawyɨɨre vandʉʉ vaanɨ vatamanye na Galiláaya, ʉko kʉʉnyona varɨ.” ");
INSERT INTO lag_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mpɨɨndɨ vara vaantʉ vaki ˆvajáa njirii vootamanya, vamwɨ va vara valʉkalʉka ˆvɨɨmɨrɨráa mbɨrɨ́ɨ́ra vajáa vatamanya na múujii no vawyɨɨra vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva yoosi ˆyajáa yafʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vawosi vakiikala kiikalo na vakatʉʉnga njɨra ya ʉloongo. Vakavaheera vara valwi nkoondo mpía ˆjiri foo, ");
INSERT INTO lag_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kʉnʉ voovasea, “Moosaakwa mʉsee jei, ‘Vapooji vaachwe vuújire nuuchikʉ mpɨɨndɨ suusu ˆtaarɨ talɨ́ɨre, maa vakamwiiva.’ ");
INSERT INTO lag_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Koonɨ iji sáare jamʉfɨ́kɨɨre gávana, suusu lʉma tʉrɨ sáare ne, sa mʉdɨɨre ringiwaringiwa.” ");
INSERT INTO lag_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jeyyo, vara valʉkalʉka vakasʉmʉla jira mpía, maa vakabweeyya ja ˆvyeene vajáa vawyɨɨrwa. Masáare aya yeenera kwa Vayahúudi fʉʉrʉ isikʉ. ");
INSERT INTO lag_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aho, vara vapooji ikimi na ʉmwɨ vakadoma fʉʉrʉ Galiláaya, luulwii haantʉ Yéesu ˆajáa avasea vatamanye. ");
INSERT INTO lag_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ˆVakamoone vakamwiinamɨra, maa kaa, vɨɨngɨ vakava vookiivʉndʉka mitimii. ");
INSERT INTO lag_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aho, Yéesu akavʉʉjɨra, maa akasea, “Nahɨ́ɨwe wiimiriri woosi, kurumwii na kʉrɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sa jeyyo, tamanyi mʉkavabweeyye vaantʉ va ɨsɨ joosi kʉva vapooji vaanɨ, mʉndoovabatisa, kwa irina ra Taáta, na ra Mwaana na ra Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kei, mʉndoovakiindya kʉyakwaatya yoosi ˆnavalairirya nyuunyu. Kɨkomi nɨɨnɨ mwaarɨ na nyuunyu sikʉ joosi, fʉʉrʉ mpɨɨndɨ ja ʉhero.”");
INSERT INTO lag_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ɨhɨ noo ncholo ya Masáare Maaja ya YéesuKirisitʉ, Mwaana wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ja ˆvyeene Ijʉva alʉʉsa kɨtáabwii cha Isáaya, mʉláali na mʉtwe waachwe, “Laanga, mʉtʉma ndɨrɨ mutumwi waanɨ akʉlongorɨre, yeeye kʉtengenesherya arɨ njɨra yaako. ");
INSERT INTO lag_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mʉʉntʉ yookaanɨrɨra vikʉlʉkʉʉlʉ ɨsɨ ya ibaláángwii, ‘Imyi neeja njɨra sa Ijʉva, wololi njɨra ˆngʼeene arɨ tweera.’” ");
INSERT INTO lag_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Masáare aya yakiimana, Yooháani Mʉbatisáaji afʉmɨra ɨsɨ ya ibaláángwii, yoovariyʉla ʉbatíiso wa vaantʉ kʉvalandʉka fuma uvii waavo, sa Mʉlʉʉngʉ asee, ʉvɨ waavo wasírire. ");
INSERT INTO lag_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vaantʉ fuma ɨsɨ yoosi ya Yudéea, na mavaru yoosi ya Yerusaléemu, vadomáa noo mʉteerera. Yeeye avabatisáa aho luujii lwa Yorodáani, kʉnʉ voolʉʉsa ʉvɨ waavo. ");
INSERT INTO lag_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yooháani iivɨkɨráa ɨngo ya mabaáhɨra ya ngamɨ́a na lʉkova iimʉ́tɨɨre. Kɨɨntʉ ˆarijáa nɨ nkʉʉmbɨ na hʉʉkɨ wa isekii. ");
INSERT INTO lag_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na avariyʉláa ɨndoosea, “Amwaarɨ ˆyookʉʉja nyuma yaanɨ ˆarɨ na ngururu kʉlookya nɨɨnɨ, nɨɨnɨ sɨ ndɨrɨ daha baa tʉmama mʉrɨmo wa mʉtʉ́mwa wo reherya nkova ja mirunkumo yaachwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nɨɨnɨ noobatisa na maaji, maa kaa, yeeye vabatisa arɨ na Mʉtɨma Mʉʉja.” ");
INSERT INTO lag_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sikʉ jira, Yéesu akʉʉja fuma Nasaréeti múuji wa Galiláaya, maa akabatisiwa nɨ Yooháani luujii lwa Yorodáani. ");
INSERT INTO lag_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ˆAkafume vii hara luujii, akoona kurumu kookwaatʉka dwee, na Mʉtɨma Mʉʉja yookiima mweeri yaachwe ja nkúnde. ");
INSERT INTO lag_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Maa sawúti ɨkafuma kurumwii, yoosea, “Weewe ʉrɨ Mwaana waanɨ ˆnakweenda, neeriwa mʉtɨma nɨ weewe mʉnʉmʉʉnʉ.” ");
INSERT INTO lag_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ayo ˆyakalooke vii, Mʉtɨma Mʉʉja akamʉtwaala fʉʉrʉ ɨsɨ ya ibaláángwii. ");
INSERT INTO lag_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Akiikala ʉko ibaláángwii sikʉ makumi yanɨ (40) yooyerwa nɨ Irimʉ, ʉko iikaláa na maka ja isaka, mirimʉ miija noyo yamʉtʉmamɨráa. ");
INSERT INTO lag_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sikʉ ˆjikalooke, Yooháani Mʉbatisáaji akakwaatwa, maa akavɨɨkwa mʉnyololwii. Sikʉ ijo, Yéesu akadoma na Galiláaya, ɨndoovariyʉla Masáare Maaja ya Mʉlʉʉngʉ ");
INSERT INTO lag_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","yoosea, “Mpɨɨndɨ jafíkire, Ʉtemi wa Mʉlʉʉngʉ waséngerɨɨre. Valanduki fuma uvii waanyu na murume Masáare Maaja.” ");
INSERT INTO lag_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sikʉ ɨmwɨ, mpɨɨndɨ ˆalookáa na mbarɨmbarɨ ya iriva ra Galiláaya, akamoona Simóoni na mwaanaavo Anderéa, voowʉmɨra lwaavu na luujii, sa voovo nɨ vavúuvi vajáa. ");
INSERT INTO lag_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aho, Yéesu akavasea, “Ntuubi, na vabweeyya ndɨrɨ mʉve vavúuvi va vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hahara, vakareka njwaavu jaavo, vakamutuuba. ");
INSERT INTO lag_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ˆAkadome na mbere kiduudi, akavoona vala Yaakúupu na Yooháani vala sha Sebedáayo, vajáa mashúwii voolʉkanʼya njwaavu jaavo. ");
INSERT INTO lag_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ˆAkavoone vii, maa akavaanɨrɨra. Novo vakamutuuba, vakamʉreka taáta waavo na vara vavúuvi vɨɨngɨ ˆvamʉtʉmamɨráa. ");
INSERT INTO lag_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kufuma aho, vakadoma fʉʉrʉ múujii wa Kaperenáumu. Sikʉ ya Sabáato Yéesu akɨɨngɨra na sinagóogii, maa akaanda variyʉla Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vaantʉ vakahwaalariwa nɨ ʉvariyuli waachwe, sa yeeye sɨ avariyʉláa ja vakiindya vaavo va Miiro tʉkʉ, kɨrɨ vyoova jeyyo, yeeye akiindyáa ja mʉʉntʉ ˆarɨ na wiimiriri. ");
INSERT INTO lag_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hara sinagóogii yaavo, kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆajáa na murimʉ mʉvɨ, akatʉlatʉʉla isóso ");
INSERT INTO lag_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yoosea, “Weewe Yéesu wa Nasaréeti, che woosaaka kʉrɨ suusu? Wuújire tʉmala wʉʉ? Nakʉmányire ʉrɨ ani weewe! Weewe ʉrɨ Mʉʉja wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yéesu akʉʉdalavya ʉra murimʉ mʉvɨ yoosea, “Kirinya sawu! Fuma kʉrɨ ʉhʉ mʉʉntʉ!” ");
INSERT INTO lag_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hahara, ʉra murimʉ mʉvɨ ʉkamusukasuka ʉra mʉʉntʉ na ngururu, kʉnʉ wootʉlatʉʉla isóso, maa ʉkafuma. ");
INSERT INTO lag_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hara, vaantʉ voosi vakatʉlʉvala, maa vakaanda kiisea, “Ɨkɨ nɨ che? Nɨ ukiindya mufya, kei ˆʉrɨ na wiimiriri! Yoolairirya baa mirimʉ mɨvɨ, noyo yoomʉteerera!” ");
INSERT INTO lag_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Masáare aya, yakeenera chaangʉ ɨsɨ yoosi ya Galiláaya. ");
INSERT INTO lag_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yéesu, Yaakúupu, Yooháani, Simóoni na Anderéa vakafuma hara sinagóogii, vakadoma fʉʉrʉ kaayii kwaala Simóoni na Anderéa. ");
INSERT INTO lag_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ˆVakafike, vakamʉshaana mʉkwɨ wa Simóoni ajáa nchiirii aváirwe nɨ ndwáala. Hahara, vakamuwyɨɨra Yéesu masáare yaachwe. ");
INSERT INTO lag_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Akaseesa na hara kʉʉntʉ ˆajáa alɨ́ɨre, akamʉkwaata mʉkono ʉra maáma, maa akamwiinʉla, hahara akahola, maa akaanda vatʉmamɨra. ");
INSERT INTO lag_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Niiwʉlo mwaasʉ ˆʉkakʉtʉmɨre, Sabáato ɨkalooka. Vaantʉ vakaanda mʉretera valwɨ́ɨrɨ voosi, na vaantʉ ˆvarɨ na mirimʉ mɨvɨ. ");
INSERT INTO lag_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aho, vaantʉ voosi va ʉra múuji vakiisaanka mbere ya kaaya. ");
INSERT INTO lag_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hara, maa Yéesu akava yoovahorya vaantʉ voosi ˆvajáa na ndwáala ˆjiísimiresimire, baa kei iikibiryáa mirimʉ mɨvɨ ˆɨrɨ foo. Maa kaa, sɨ ɨɨrekeráa ɨyo mirimʉ mɨvɨ ɨlʉʉsɨke tʉkʉ, sa ɨjáa yamʉmányire yeeye nɨ ani. ");
INSERT INTO lag_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lomʉtóondo yaachwe baa sɨ kʉna mwaa, Yéesu akadoma na kijiraawii, kʉra akamʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simóoni na viivaachwe vakamʉloonda. ");
INSERT INTO lag_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ˆVakamoone, vakamʉsea, “Kɨra mʉʉntʉ yookʉsaakɨra.” ");
INSERT INTO lag_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yéesu akavasea, “Hendi na haantʉ hɨɨngɨ, míijii yɨɨngɨ ˆɨrɨ mʉkaaya, nkavariyʉle baa ʉko, sa nʉʉja, sa mʉrɨmo ʉwo.” ");
INSERT INTO lag_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jeyyo, akarɨɨngɨrɨra ɨsɨ yoosi ya Galiláaya, kʉnʉ yoovariyʉla Masáare ˆYarɨ Mpeho masinagóogii, na avahoryáa vaantʉ ˆvarɨ na mirimʉ mɨvɨ. ");
INSERT INTO lag_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ, ˆarɨ na ndwáala ya ʉlóónda. Akʉʉja kʉrɨ Yéesu, akachwaama, akiiloombererya yoosea, “Koonɨ woosaaka, ifaanaa ʉkaanjirʉla ndwáala yaanɨ.” ");
INSERT INTO lag_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yéesu akamoonera mbavariri, akiinʉla mʉkono waachwe, akamʉsaasya, maa akamʉsea, “Noosaaka, ujirʉlwe!” ");
INSERT INTO lag_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hahara, akajirʉlwa na akahola ɨra ndwáala yaachwe. ");
INSERT INTO lag_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yéesu akamʉrekera adome, maa kaa, akamʉkaanʼya yoomʉsea, ");
INSERT INTO lag_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Karɨ umuwyɨ́ɨraa mʉʉntʉ yoyoosi isáare ɨrɨ tʉkʉ, tamanya ukiiyonekye kwa mweeneɨsɨ wa Ijʉva, ʉtoole na mpóryo yo jirʉlwa, ja ˆvyeene Mʉ́sa alairirya, sa vataange kɨmaarɨ ʉhórire.” ");
INSERT INTO lag_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kɨrɨ vyoobweeyya jeyyo, ʉra mʉʉntʉ akadoma, akaanda kaarya yara masáare kɨra haantʉ. Sa jeyyo, Yéesu sɨ adaha kɨɨngɨra na múujii ko kiiyonekya tʉkʉ, nɨ iikaláa kijiraawii vii. Maa kaa, baa neembe iivisáa, vaantʉ vamutuubáa fuma kɨra haantʉ. ");
INSERT INTO lag_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sikʉ ˆjikaseese, akahɨndʉka na Kaperenáumu, vaantʉ vakateera ahíndukire na kaayii. ");
INSERT INTO lag_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mpuka nkʉʉlʉ ikiijiinga, ɨkasoveka baa nkalo mʉryaangwii. Ne akava yoovavariyʉrɨra Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mʉʉntʉ ʉmwɨ ˆaakwya iyandiyandi, akareetwa kʉrɨ Yéesu iínwɨɨrwe nɨ vaantʉ vanɨ. ");
INSERT INTO lag_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sa ɨra mpuka nkʉʉlʉ, vara vaantʉ vakasiindwa kʉmʉlookya ʉra mʉlwɨ́ɨrɨ fʉʉrʉ kʉrɨ Yéesu. ˆVakoone jeyyo, vakaambʉka nɨ ikekeerii, vakabontola ikekeera hara kʉʉntʉ Yéesu ˆajáa, vakamukiimirya ʉra mʉlwɨ́ɨrɨ na ndɨrɨ yaachwe. ");
INSERT INTO lag_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yéesu ˆakoone kuruma kwaavo, akamʉsea ʉra mʉlwɨ́ɨrɨ, “Mwaana waanɨ, ʉvɨ waako wasírire.” ");
INSERT INTO lag_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aho nyuumbii, kwajáa kwatɨɨte vakiindya vamwɨ va Miiro vajáa viíkyɨɨre, vakaanda kiiririkana mitimii yaavo voosea, ");
INSERT INTO lag_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Joolɨ arɨ lʉʉsa jei? Yoomʉhɨɨntɨkɨra Mʉlʉʉngʉ! Sɨ Mʉlʉʉngʉ yeemweene noo ˆadáhaa sea ʉvɨ wasírire tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hahara, Yéesu akataanga miiririkano yaavo, maa akavasea, “Nɨ sa che mookiiririkana ayo mitimii yaanyu? ");
INSERT INTO lag_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nɨ kɨrɨkwɨ noo chaangʉ kʉlookya myeewe, kʉmʉsea ʉhʉ mʉlwɨ́ɨrɨ, ‘Ʉvɨ waako wasírire,’ bakʉ kʉmʉsea, ‘Inʉka, ʉtoole ndɨrɨ yaako ʉlooke’? ");
INSERT INTO lag_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Haaha noosaaka mʉtaange, Mwaana wa Mʉʉntʉ atɨɨte wiimiriri wo sea vaantʉ, ‘Ʉvɨ waavo wasírire,’ aha weerwii.” Aho, akamʉsea ʉra mʉʉntʉ ˆaakwya iyandiyandi, ");
INSERT INTO lag_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nookʉsea, inʉka, toola ndɨrɨ yaako, ʉdome na kaayii kwaako.” ");
INSERT INTO lag_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hahara, maa akatoola ndɨrɨ yaachwe akafuma na weerwii, baa vara vaantʉ voosi ntɨ ˆvoomʉlaanga. Maa vakatʉlʉvala, vakamʉdʉʉmba Mʉlʉʉngʉ voosea, “Isáare ja ɨrɨ, sɨ tʉnoona vii kaa tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hara, maa Yéesu akadoma kei na mbarɨmbarɨ ya iriva ra Galiláaya. Mpuka nkʉʉlʉ ya vaantʉ ɨkamutuuba, maa akaanda kʉvavariyʉrɨra Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mpɨɨndɨ Yéesu ˆawololáa mawʉlʉ, akamoona Láawi mwaana wa Alʉfáayo iíkyɨɨre kɨvaandii cho rɨhɨra kóodi, yoosaankanʼya kóodi. Akamʉsea, “Ntuuba!” Ne Láawi akiinʉka, akamutuuba Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mpɨɨndɨ Yéesu na vapooji vaachwe ˆvarijáa chákurya kaayii kwa Láawi, vasaankanʼyi kóodi na vaduwalo ˆvarɨ foo varijáa novo. Sa vaantʉ ˆvarɨ foo, vamutuubáa. ");
INSERT INTO lag_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Vakiindya vamwɨ va Miiro ya Mʉlʉʉngʉ na Mafarisáayo vajáa vamwaarɨ. ˆVakamoone Yéesu yoorya hamwɨ na vaduwalo na vasaankanʼyi kóodi, vakavasea vapooji vaachwe, “Sa che yoorya chákurya hamwɨ na maduwalo na masaankanʼyi kóodi?” ");
INSERT INTO lag_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yéesu ˆakayateere ayo masáare, maa akavasea, “Vaantʉ ˆvarɨ nkaasʉ sɨ vasáakaa mwaanga tʉkʉ, maa kaa, valwɨ́ɨrɨ noo vasáakaa mwaanga. Sɨ nʉʉja joo kaanɨrɨra vaantʉ ˆviiyónaa vawoloki tʉkʉ, nʉʉja joo kaanɨrɨra vavɨ.” ");
INSERT INTO lag_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Haaha, vapooji va Yooháani na va Mafarisáayo viirekyáa kurya. Maa vaantʉ vakʉʉja joo muurya Yéesu vakamʉsea, “Amwɨ vapooji va Yooháani na va Mafarisáayo viirékyaa kurya. Sa che vapooji vaako sɨ viirékyaa kurya?” ");
INSERT INTO lag_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yéesu akavasea, “De vyadáhɨkaa vaantʉ ˆvaláarikirwe nɨ mweenengovi, na mweenengovi ntɨ ˆarɨ novo kwiirekya kurya wʉʉ? Sɨ varɨ kwiirekya kurya tʉkʉ, mpɨɨndɨ joosi varɨ na mweenengovi. ");
INSERT INTO lag_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Maa kaa, luu fika jiri mpɨɨndɨ mweenengovi ˆakasʉmwɨɨrwe fuma kwaavo, aho noo luu vakiirekiirye kurya. ");
INSERT INTO lag_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kusiina mʉʉntʉ ˆadáhɨraa kɨráka kifya isaámwii tʉkʉ. Koonɨ abwéeyyiirye jeyyo, ɨkyo kɨráka moola kɨrɨ ɨro isaámʉ na ɨyo ɨngo kwaatʉka ɨrɨ kʉlookya lo ncholo. ");
INSERT INTO lag_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Baa kei, kusiina mʉʉntʉ ˆavɨ́kɨraa diváai ifya viríibii vya kalɨ tʉkʉ. Koonɨ abwéeyyiirye jeyyo, ɨyo diváai ifya, pʉsʉla ɨrɨ ivyo viríiba, na diváai kɨɨtɨka ɨrɨ na mweenediváai sova arɨ diváai na viríiba. Diváai ifya nɨ viríibii vifya ɨvɨ́kɨrwaa.” ");
INSERT INTO lag_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sikʉ ya Sabáato ɨmwɨ, Yéesu na vapooji vaachwe vajáa vakwaatɨra na mawundii ya ngáano. Mpɨɨndɨ ˆvalookáa na hara mawundii, vapooji vakaanda hʉʉnga maangala ya ngáano. ");
INSERT INTO lag_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafarisáayo vakamʉsea Yéesu, “Laanga, sa che vapooji vaako voowuna Miiro ya sikʉ ya Sabáato?” ");
INSERT INTO lag_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Maa akavasea, “Sɨ mʉnasoma vii tʉkʉ ˆcheene atʉmama mʉtemi Daúdi mpɨɨndɨ ˆajáa aávirwe nɨ njala na vaantʉ vaachwe wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aho kalɨ, mpɨɨndɨ ja Abiasáari, mweeneɨsɨ mʉkʉʉlʉ, Daúdi ɨɨngɨra na nyuumbii ya Mʉlʉʉngʉ, akarya mɨkáate ˆɨvɨ́ɨkwaa mbere ya Mʉlʉʉngʉ, akavaheera baa na viivaachwe. Mɨkáate ɨyo, veeneɨsɨ va Ijʉva vii noo vajáa varekerwa vɨndoorya. Vaantʉ vɨɨngɨ Miiro ɨjáa yakaanʼya kurya.” ");
INSERT INTO lag_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Baa kei akavasea, “Sabáato yavɨɨkwa sa vaantʉ na sɨ vaantʉ sa Sabáato tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sa jeyyo, Mwaana wa Mʉʉntʉ nɨ Mweeneevyo baa wa Sabáato.” ");
INSERT INTO lag_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yéesu ajáa ɨɨngɨra kei na sinagóogii. Aho, kwajáa kwatɨɨte mʉʉntʉ ˆajáa na mʉkono ˆwaakwya iyandiyandi. ");
INSERT INTO lag_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Vamwɨ va vaantʉ ˆvajáa aho, vakaanda mʉlaangisha Yéesu, voone koonɨ arɨ mʉhorya ʉra mʉʉntʉ sikʉ ya Sabáato, sa vamusitaakye. ");
INSERT INTO lag_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yéesu akamʉsea ʉra mʉʉntʉ mʉkono ˆwaakwya iyandiyandi, “Seesa, ɨma aha mbere ya vaantʉ voosi.” ");
INSERT INTO lag_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yéesu akavuurya, “Nɨ virikwi noo Miiro yaruma tʉtʉmame sikʉ ya Sabáato? Kʉtʉmama mʉrɨmo mʉʉja, bakʉ kʉtʉmama mʉrɨmo mʉvɨ? Kʉlamurirya nkaasʉ, bakʉ kʉʉlaa?” Maa kaa, voovo sɨ vuuyirya kɨɨntʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Akavatuurirya miiso na nkalari, kʉnʉ yookoona ʉsʉʉngʉ sa ʉfafu wa mɨtɨma yaavo. Maa akamʉsea ʉra mʉʉntʉ, “Wolola mʉkono waako!” Ne akawolola mʉkono waachwe, ʉkava nkaasʉ kei! ");
INSERT INTO lag_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hahara, vara Mafarisáayo vakafuma na weerwii vakaanda kiiheera mɨryʉʉngʉ na mpuka ya vaantʉ va mʉtemi Heróode, ˆvyeene varɨ mʉʉlaa Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yéesu na vapooji vaachwe vakiinʉka aho, vakadoma fʉʉrʉ mbarɨmbarɨ ya iriva ra Galiláaya. Mpuka nkʉʉlʉ ya vaantʉ vamutuubáa. Vaantʉ avo vajáa vafúmire kɨra haantʉ, ɨsɨ ja kʉlɨ na heehi, Galiláaya, Yudéea, Yerusaléemu, Idumáaya, ɨsɨ yoosi nyambʉko ya luujii lwa Yorodáani, na va heehi na míiji ya Tíiro na Sidóoni. Vaantʉ voosi avo, vʉʉja sa vajáa vatéɨɨre masáare ˆmeene Yéesu atʉmamáa. ");
INSERT INTO lag_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yéesu akavasea vapooji vaachwe, “Mbiikiri mashʉ́wa ɨmwɨ neeja, naambʉke, sa vaantʉ jo kʉʉnfenyenkererya.” ");
INSERT INTO lag_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yéesu alʉʉsa jeyyo, sa ajáa avahóriirye vaantʉ ˆvarɨ foo, na vaantʉ voosi vara ˆvajáa na ndwáala viifenyenkereryáa, sa vamʉsaasye. ");
INSERT INTO lag_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mirimʉ mɨvɨ ˆɨkamoone, yiivayyáa mbere yaachwe kʉnʉ yootʉla isóso yoosea, “Weewe ʉrɨ Mwaana wa Mʉlʉʉngʉ!” ");
INSERT INTO lag_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yéesu akɨɨkaanʼya ɨrekereeke kwaarya masáare yaachwe kwa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aho, Yéesu akaambʉka na luulwii, akavaanɨrɨra vara ˆveene yeeye avasaakáa, maa vakʉʉja na kʉrɨ yeeye. ");
INSERT INTO lag_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Akavasaawʉla ikimi na vavɨrɨ, vave vatumwi vaachwe, vandooyeendanʼya ne, sa ɨndoovatʉma no vavariyʉrɨra Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Baa kei, vave na wiimiriri wo kibirya mirimʉ mɨvɨ. ");
INSERT INTO lag_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na ava noo vatumwi ikimi na vavɨrɨ ˆveene Yéesu avasaawʉla: Simóoni, ˆmweene Yéesu amwaanɨrɨra Peéteri, ");
INSERT INTO lag_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yaakúupu na Yooháani vala sha Sebedáayo ˆveene avaanɨrɨra Bonéege, noo kʉsea, “Vaana va kɨdandárɨka,” ");
INSERT INTO lag_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderéa na Filíipi, Batolomáayo, Matáayo, Tomáasi, Yaakúupu sha Alʉfáayo, Tedéei, Simóoni Mʉkanáani ");
INSERT INTO lag_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yʉ́ʉda Isikarióoti ˆamʉvarindʉka Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yéesu akahɨndʉka na kaayii, mpuka ya vaantʉ ɨkaanda kiijiinga kei, fʉʉrʉ yeeye na vapooji vaachwe vakasova baa nkalo yo rya chákurya. ");
INSERT INTO lag_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kaayii kwaavo ˆvakateere masáare ˆmeene yalʉʉswáa, maa vakadoma noo mʉsʉmʉla sa viiseáa, “Asárire!” ");
INSERT INTO lag_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hara mpukii, vajáa vamwaarɨ vakiindya va Miiro ˆveene vajáa vafuma Yerusaléemu. Avo vakiindya vaseáa, “Ʉhʉ atɨɨte Belisebúuri, na nɨ kwa lʉvɨro lwa Irimʉ yookibirirya mirimʉ mɨvɨ.” ");
INSERT INTO lag_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yéesu akavaanɨrɨra, akalʉʉsɨka novo kwa símo akavasea, “Joolɨ Irimʉ rɨrɨ daha kibirya Irimʉ mwiiwaachwe? ");
INSERT INTO lag_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Koonɨ ʉtemi ʉmwɨ wiigávire haantʉ havɨrɨ kwiilwa woowo kwa woowo, ʉtemi ʉwo sɨ ʉrɨ lʉʉnga tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Baa kei, koonɨ lʉkolo lʉmwɨ lwiigáviregavire, ʉlo lʉkolo sɨ lʉrɨ lʉʉnga tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Noo jeyyo, koonɨ Irimʉ riikɨ́ɨkɨɨne rooreene na rɨve riigávire, sɨ rɨrɨ lʉʉnga tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Maa kaa, kusiina mʉʉntʉ ˆarɨ daha kɨɨngɨra nyuumbii ya mʉʉntʉ ˆarɨ na ngururu na anyahɨre máari jaachwe tʉkʉ, nɨ mpaka ta amuchuunge ʉwo mʉʉntʉ ˆarɨ na ngururu, de adahe nyahɨra máari jaachwe ˆarɨ nojo. ");
INSERT INTO lag_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kɨmaarɨ noovawyɨɨra, ʉvɨ woosi wa vaantʉ na uhiintiki waavo woosi Mʉlʉʉngʉ sea arɨ wasírire. ");
INSERT INTO lag_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Maa kaa, mʉʉntʉ ˆmweene arɨ mʉhɨɨntɨkɨra Mʉtɨma Mʉʉja, Mʉlʉʉngʉ sɨ arɨ sea ʉvɨ waachwe wasírire vii kaa tʉkʉ, na kʉva arɨ mʉvɨ kwa sikʉ ˆjisiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yéesu alʉʉsa jeyyo sa vajáa vamʉséire, “Atɨɨte murimʉ mʉvɨ.” ");
INSERT INTO lag_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mpɨɨndɨ kiduudi, akʉʉja íyo waala Yéesu na vaanaavo na Yéesu, vakɨɨma mbarɨmbarɨ, maa vakatʉma mʉʉntʉ amwaanɨrɨre. ");
INSERT INTO lag_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na vaantʉ ˆvajáa viíkyɨɨre vakamʉrɨɨngɨrɨra, vakamʉsea, “Íyo waanyu na vaanaanyu vamwaarɨ aha weerwii vookʉsaakɨra.” ");
INSERT INTO lag_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Maa Yéesu akavasea, “Íyo wiitʉ na vaaniitʉ noo vala ani?” ");
INSERT INTO lag_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Akavalaanga vaantʉ ˆveene vajáa viíkyɨɨre vakamʉrɨɨngɨrɨra, maa akavasea, “Laangi! Ava ˆvarɨ aha noo vala íyo na vaaniitʉ. ");
INSERT INTO lag_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mʉʉntʉ yoyoosi ˆatʉ́mamaa kʉsaaka kwa Mʉlʉʉngʉ noo mwaaniitʉ, irʉʉmbʉ raanɨ na íyo wiitʉ.” ");
INSERT INTO lag_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mpɨɨndɨ kiduudi, Yéesu akaanda variyʉla Masáare ˆYarɨ Mpeho kei mbarɨmbarɨ ya iriva ra Galiláaya. Mpuka nkʉʉlʉ ya vaantʉ vakiisaanka, vakamʉfenyenkererya mpaka akaambʉka mashʉ́wa irivii, maa akiikala. Vaantʉ voosi vakiikala mbarɨmbarɨ ya iriva. ");
INSERT INTO lag_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Akava yoovavariyʉrɨra viintʉ ˆviri foo kwa símo, na mpɨɨndɨ ˆavavariyʉrɨráa akavasea, ");
INSERT INTO lag_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Teereri! Mʉhaandi ʉmwɨ ajáa adoma noo haanda mbeyʉ, ");
INSERT INTO lag_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","mpɨɨndɨ ˆamyaaháa, mbeyʉ jimwi jikawyɨɨra njirii, ndee jikʉʉja jikajirya. ");
INSERT INTO lag_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jimwi jikawyɨɨra mwaalaliwyii kʉʉntʉ ˆkʉjáa kusiina salʉ jo keenererya, sa viintʉ salʉ sɨ jijáa jiri foo, jikamera chaangʉ. ");
INSERT INTO lag_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mwaasʉ ˆʉkavarɨke, jikashaawʉka, maa jikʉʉma sa viintʉ jijáa jisiina miriri. ");
INSERT INTO lag_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jimwi jikawyɨɨra haantʉ ˆhajáa na miíwa. Miíwa ˆɨkamere, ɨkajivaa, jikadundumala, maa jikadɨɨra vyaala ndɨɨwa. ");
INSERT INTO lag_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Maa kaa, jimwaarɨ jimwi ˆjawyɨɨra salwii ˆjiri na seve, jikamera, jikakʉla, jikavyaala maatʉkʉ vii, jimwi jikavyaala mara makumi yatatʉ (30), jimwi mara makumi mʉsasatʉ (60) na jimwi mara makumi ikimi (100).” ");
INSERT INTO lag_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Maa akavasea, “ˆArɨ na matu yo teerera, nɨ ateere.” ");
INSERT INTO lag_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mpɨɨndɨ kiduudi, Yéesu ajáa na vapooji vaachwe ikimi na vavɨrɨ, na vɨɨngɨ vajáa vamʉrɨ́ɨngɨrɨɨre, maa vakamuurya, “Símo jaako nɨ che joovariyʉla?” ");
INSERT INTO lag_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ne akavasea, “Nyuunyu mwaheewa nkalo yo taanga viintʉ vya Ʉtemi wa Mʉlʉʉngʉ, ˆvyeene vijáa fuumbo, maa kaa, vara sɨ ˆvarɨ Ʉtemii wa Mʉlʉʉngʉ, noovawyɨɨra kwa símo. ");
INSERT INTO lag_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Sa kʉlaanga, valaange, baa koona tʉkʉ. Kʉteera vateere, baa taanga tʉkʉ. Sa ngaarɨ vajáa vateera no taanga, ngaarɨ vavarindʉka na vareka ʉvɨ waavo, na ngaarɨ ʉvɨ waavo wasira.” ");
INSERT INTO lag_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aho, Yéesu akavuurya, “Sɨ mootaanga lusímo ʉlʉ tʉkʉ wʉʉ? Joolɨ de mʉrɨ taanga símo jɨɨngɨ? ");
INSERT INTO lag_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mʉhaandi wa mbeyʉ nɨ mʉʉntʉ ˆaváriyʉlaa isáare ra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mbeyʉ jira ˆjawyɨɨra njirii, nɨ ja vaantʉ vara ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ, hahara Irimʉ rɨkʉʉja, maa rɨkajiseyya mitimii yaavo. ");
INSERT INTO lag_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mbeyʉ jira ˆjawyɨɨra mawyii, nɨ ja vaantʉ vara ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ, na ˆvarɨhókeraa chaangʉ na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Maa kaa, sɨ rɨvɨɨngɨ́raa mitimii tʉkʉ, sa viintʉ vasiina nkalo ya miriri, kiikala varɨ noro kiduudi vii. Na uturikiri ˆʉrɨ kʉʉja vii, varékaa kʉra kuruma kwaavo chaangʉ. ");
INSERT INTO lag_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na mbeyʉ jira ˆjawyɨɨra miíwii, nɨ ja vaantʉ ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ, ");
INSERT INTO lag_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","maa kaa, ʉhangaiki wa weerʉ, ʉkwaata wo kunguula máari na mpɨɨma ya viintʉ vyɨɨngɨ ˆviri foo, ivyo virifenyenkeryáa, rɨkareka kʉreeta kʉnáálo. ");
INSERT INTO lag_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na mbeyʉ jira ˆjahaandwa sevii, noo vara vaantʉ ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ, vakarɨteengya, maa rɨkava na nkoonyo, jimwi jikavyaala mara makumi yatatʉ (30), jimwi mara makumi mʉsasatʉ (60), na jimwi mara makumi ikimi (100).” ");
INSERT INTO lag_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yéesu akɨɨsea ɨra mpuka, “Eri, kɨmʉrɨ chʉʉ́jaa, kɨkavɨɨkwa iruungwii ra kɨtáanda wʉʉ? Bakʉ kɨkakʉnɨkɨrɨrwa na nyiingʉ ya kweenga wʉʉ? Tʉkʉ, nɨ kyaángwii kɨvɨ́ɨkwaa. ");
INSERT INTO lag_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sa kɨra kɨɨntʉ ˆchaviswa, vɨɨkwa kɨrɨ kɨweerwii, na kɨra ˆchakʉnɨkɨrɨrwa, kʉnʉkʉlwa kɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ˆMweene arɨ na matu yo teerera, nɨ ateere!” ");
INSERT INTO lag_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hara, maa akavasea kei, “Mʉyakwaatye neeja aya ˆmooyateera. Sa kipíimo ˆcheene mʉrɨ konkomala kʉteerera masáare ya Ijʉva, noo ˆvyeene baa nyuunyu mʉrɨ taanga, baa kei koongereriwa mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sa ʉra ˆarɨ na kɨɨntʉ, koongereriwa arɨ kʉlookya, na ʉra ˆasiina kɨɨntʉ, vuulwa arɨ baa kɨra kidúúdi ˆarɨ nocho.” ");
INSERT INTO lag_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yéesu akavasea, “Ʉtemi wa Mʉlʉʉngʉ nɨ ja jei ʉrɨ. Mʉʉntʉ aháandaa mbeyʉ iwundii. ");
INSERT INTO lag_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ˆArɨ hʉmʉla, baa alɨ́ɨre au arɨ miiso, mbeyʉ jaméraa no kʉla, yeeye baa taanga ˆvyeene vyavíjaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Salʉ joongʼeene noo jibwéeyyaa jimere na jive mʉmero, jivyaale maangala, na maangala yave na mpeke. ");
INSERT INTO lag_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mpeke ˆjiri kangaala, ʉwo mʉʉntʉ atóolaa lufyo chaangʉ, sa mpɨɨndɨ jo chwa, jafíkire.” ");
INSERT INTO lag_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kei akavasea, “Tʉʉfwaanirirye na che Ʉtemi wa Mʉlʉʉngʉ? Bakʉ lusímo che tʉrɨ sima, sa tʉʉvariyʉle? ");
INSERT INTO lag_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ʉtemi wa Mʉlʉʉngʉ ifaanaa tʉkʉʉfwaanirirya na mpeke ya haradáali. Ɨhɨ nɨ mpeke ndudinduudi kʉlookya mpeke joosi jiháandwaa. ");
INSERT INTO lag_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Maa kaa, koonɨ yaháandirwe, yavijáa mʉtɨ mʉkʉʉlʉ kʉlookya mɨtɨ yɨɨngɨ ya mbowa. Na yavijáa na matáampi makʉʉlʉ, baa ndee jindoojeenga vivururu mpehwii ja matáampii yaachwe.” ");
INSERT INTO lag_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kwa símo ˆjiri foo ja iji, noo ˆvyeene Yéesu avariyʉláa isáare riija, ja ˆvyeene vaantʉ vadaháa taanga. ");
INSERT INTO lag_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sɨ avariyʉláa isáare roroosi ra Ʉtemi wa Mʉlʉʉngʉ baa vasɨmɨra tʉkʉ, na mpɨɨndɨ ˆajáa na vapooji vaachwe de ɨndoovavariyʉrɨra. ");
INSERT INTO lag_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iwʉlo ra sikʉ yɨɨyo, Yéesu akavasea vapooji vaachwe, “Hendi tʉfɨrɨre iriva tʉdome na nyambʉko.” ");
INSERT INTO lag_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Maa reerʉ, vakɨɨreka ɨra mpuka ya vaantʉ, vakakwaata njɨra na ɨra mashʉ́wa ˆngʼeene Yéesu ajáa ɨɨ́ngɨɨre, baa mashʉ́wa jɨɨngɨ jikamutuuba. ");
INSERT INTO lag_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ihúmbuuto ˆradalavadalaava rɨkaanda wuva, mapúunta ya maaji yakaringyaringya mashʉ́wa kende ɨmeme maaji. ");
INSERT INTO lag_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mpɨɨndɨ ijo, Yéesu mweeneevyo ajáa alɨ́ɨre nyuma ya mashʉ́wa iisíkiriirye kimútwii. Vapooji vaachwe vakamwaanɨrɨra, voosea, “Mukiindya, toonyɨmɨra, tʉlaange.” ");
INSERT INTO lag_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aho, Yéesu akiinʉka, akarɨdalavya ihúmbuuto na akayasea mapúunta, “Kirinyi sawu! Mʉtʉʉle tʉ!” Hara, ihúmbuuto rɨkakirinya sawu, na maaji yakatʉʉla tʉ. ");
INSERT INTO lag_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yéesu akavuurya vapooji vaachwe, “Sa che mookoofa? Sɨ mʉnaanduma tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Maa kaa, voovo vajáa vakwáatirwe nɨ woowa mʉnʉmʉʉnʉ, vookiiyurya, “De ʉhʉ nɨ ani, baa ihúmbuuto na mapúunta vyoomʉteera?” ");
INSERT INTO lag_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yéesu na vapooji vaachwe vakafɨrɨra na nyambʉko ya iriva ra Galiláaya, vakɨɨngɨra ɨsɨ ya Vageráasi. ");
INSERT INTO lag_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yéesu ˆakakiime vii hara mashúwii, mʉʉntʉ ʉmwɨ ˆarɨ na mirimʉ mɨvɨ afúmire mbiríírii, akʉʉja, maa akalʉmana ne. ");
INSERT INTO lag_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Hara mbiríírii, noo kʉʉntʉ ʉwo mʉʉntʉ ˆiikaláa. Kusiina mʉʉntʉ ˆadaháa kumuchuunga baa na mɨnyololo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Achuungwáa na mɨnyololo mɨkonwii na pɨɨ́ngʉ mawulwii, ɨndoodʉmʉladʉmʉla, baa kusiina mʉʉntʉ ˆajáa na ngururu jo mʉdaha tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sikʉ joosi uchikʉ na muusi, iikaláa mbiríírii na njuulwii, yootʉla isóso no kiisanasana na mawye. ");
INSERT INTO lag_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ˆAkamoone Yéesu kʉʉra, akamʉkɨbɨrɨra, maa akachwaama mbere yaachwe, ");
INSERT INTO lag_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","akatʉlatʉʉla isóso, yoosea, “Che woosaaka kʉrɨ nɨɨnɨ, weewe Yéesu Mwaana wa Mʉlʉʉngʉ ˆArɨ Mweerimweeri? Hoonɨ ilahe kwa Mʉlʉʉngʉ, sɨ ʉrɨ kuunturikirya tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Walʉʉsa jei, sa viintʉ Yéesu ajáa ʉʉséire, “Murimʉ mʉvɨ, fuma kwa ʉhʉ mʉʉntʉ!” ");
INSERT INTO lag_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Maa Yéesu akuuyurya, “Ani ʉsewáa?” Nowo ukuuyirya, ʉkasea, “Irina raanɨ nɨ Mayana na Mayana ya Valwi Nkoondo sa viintʉ tʉrɨ foo.” ");
INSERT INTO lag_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Murimʉ mʉvɨ ukiilomboola maatʉkʉ vii kʉrɨ Yéesu, karɨ iikibirye na ɨsɨ yɨɨngɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Haaha, mbarɨmbarɨ ya lʉʉlʉ heehi na aho haantʉ, kʉjáa kwatɨɨte ufya wa nkaamba ˆjooriisha. ");
INSERT INTO lag_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ɨra mirimʉ mɨvɨ ɨkamʉloomba Yéesu, yoosea, “Tʉrekere, tʉkajɨɨngɨre jira nkaamba.” ");
INSERT INTO lag_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yéesu akɨɨrekera ɨra mirimʉ mɨvɨ, ɨkafuma, ɨkɨɨta kɨɨngɨra jira nkaamba. Mirimʉ mɨvɨ ɨkɨɨngɨre ʉra ufya wa nkaamba mayana yavɨrɨ (2,000), nkaamba jikiihuunta, jikagirita, jikabʉrʉkɨra irivii, maa jikakwya joosi vʉʉ. ");
INSERT INTO lag_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Varíisi va jira nkaamba vakakʉʉrɨka itɨ́ɨjo, vakatwaala mʉlomo kwa vaantʉ ˆvajáa mawundii na múujii. Maa vakʉʉja noo laanga masáare ˆmeene yafʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ˆVakafike kʉrɨ Yéesu, vakamoona ʉra mʉʉntʉ ˆajáa na mayana na mayana ya mirimʉ mɨvɨ, iíkyɨɨre, iivɨ́kɨɨre ɨngo, arɨ baa na mɨryʉʉngʉ yaachwe, maa vakoofa. ");
INSERT INTO lag_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vara ˆveene viiyonera na miiso yaavo, vakavawyɨɨra vaantʉ vɨɨngɨ yara ˆmeene yajáa yafʉ́mɨɨre kwa ʉra mʉʉntʉ ˆajáa na mirimʉ mɨvɨ, na jira nkaamba. ");
INSERT INTO lag_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aho, vakaanda mʉloomba Yéesu alooke hara ɨsɨ ya meevo. ");
INSERT INTO lag_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yéesu ˆakaande kɨɨngɨra mashúwii, ʉra mʉʉntʉ ˆajáa na mirimʉ mɨvɨ akiiloombererya atamanyanʼye na Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yéesu akamʉsɨɨtɨra, yoosea, “Doma na meenyu, ʉkavawyɨɨre vaantʉ va meenyu ˆvyeene Ijʉva akʉtʉ́mamɨɨre masáare makʉʉlʉ, na ˆvyeene akʉláangire na riiso ra wʉʉja.” ");
INSERT INTO lag_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Maa ʉra mʉʉntʉ akadoma, akaanda kaarya ʉko ɨsɨ ya Dekapóoli ˆvyeene Yéesu ajáa amʉtʉ́mamɨɨre, maa vaantʉ voosi vakatʉlʉvala. ");
INSERT INTO lag_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Maa reerʉ, Yéesu akafɨrɨra na mashʉ́wa na nyambʉko ya iriva. ˆAkafike hara mbarɨmbarɨ ya iriva, mpuka nkʉʉlʉ ɨkamʉrɨɨngɨrɨra. ");
INSERT INTO lag_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Akʉʉja mʉʉntʉ ʉmwɨ, irina raachwe Yaíiro, ʉmwɨ wa vakʉ́ʉ́lʉ va sinagóogi. ˆAkamoone Yéesu, maa akawya majewii yaachwe. ");
INSERT INTO lag_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akiilomboola, yoosea, “Aaɨ, kahíínja kaanɨ nɨ kalwɨ́ɨrɨ ka inkwya. Nookʉloomba tʉdomanʼye, ʉkakasaasye na mʉkono waako vii, kahole kave nkaasʉ.” ");
INSERT INTO lag_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Maa vakiilongoorya na Yéesu. Ɨra mpuka ɨkava yoomutuuba na yoomufiinda. ");
INSERT INTO lag_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aho, kʉjáa kwatɨɨte mʉʉntʉ muki ˆajáa na ndwáala yo fuma sakami ˆɨrɨ foo kwa myaaka ikimi na ɨvɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ajáa atʉrɨkɨra maatʉkʉ vii, sa ayeenda ʉwaangii akamala máari jaachwe joosi vʉʉ, baa hola tʉkʉ na ndwáala yaachwe ɨkakonkomala. ");
INSERT INTO lag_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ˆAkamʉteere Yéesu, akamutuuba kʉnʉ nyuma, akiifenyenkererya mpukii ya vaantʉ, maa akasaasya nkáancho yaachwe. ");
INSERT INTO lag_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Abweeyya jei sa iiseáa kɨmoyomooyo, “Koonɨ nasáasiirye ɨngo ya Yéesu vii, hola ndɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ˆAkasaasye vii, sakami ɨkadeenʼya, akiiteera mʉvɨrɨ pwee, ahórire ɨra ndwáala yaachwe. ");
INSERT INTO lag_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hahara, Yéesu akataanga kwatɨɨte ngururu ˆjimufúmire, akavalandʉkɨra ɨra mpuka ya vaantʉ, maa akavuurya, “Nɨ ani asáasiirye ɨngo yaanɨ?” ");
INSERT INTO lag_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Vapooji vaachwe vakamʉsea, “Aaɨ, sɨ wookoona viintʉ mpuka ya vaantʉ yookiifiinda tʉkʉ wʉʉ? Sa che wookuurya, ‘Nɨ ani asáasiirye ɨngo yaanɨ?’ ” ");
INSERT INTO lag_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Maa kaa, yeeye akadoomererya laangɨra sa amoone ˆmweene amʉsáasiirye. ");
INSERT INTO lag_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ʉra mʉʉntʉ muki yootaanga ˆkɨmʉfʉ́mɨɨre, akiiturirya, akachwaama mbere ya Yéesu kʉnʉ yootetema nɨ woowa. Maa akalʉʉsa vyoosi ˆvimʉfʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yéesu akamʉsea, “Muhíínja waanɨ, kuruma kwaako kwakʉhóriirye. Tamanya na mwiikalo mʉʉja, ʉhole ndwáala yaako.” ");
INSERT INTO lag_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mpɨɨndɨ Yéesu ˆajáa akaarɨ yoolʉʉsɨka, vakafika vaantʉ fuma kaayii kwa Yaíiro, ʉmwɨ wa vakʉ́ʉ́lʉ va sinagóogi, maa vakamʉsea, “Muhíínja waako awʉ́lɨɨre. Amwɨ wootuuba mujuuwa mukiindya?” ");
INSERT INTO lag_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Maa kaa, Yéesu sɨ ayakwaatya ayo masáare tʉkʉ, yeeye akamʉsea Yaíiro, “Kwiitweetya tʉkʉ, nduma nɨɨnɨ vii.” ");
INSERT INTO lag_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Akavasʉmʉla vala Peéteri, Yaakúupu na Yooháani mudúúdi wa Yaakúupu vii, vamutuube. Akavakaanʼya vaantʉ vɨɨngɨ vareke kumutuuba. ");
INSERT INTO lag_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ˆVakafike kaayii kwa Yaíiro, vakateera ntáákwi, isóso, na vaantʉ voorɨra noo myaa. ");
INSERT INTO lag_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Vakɨɨngɨra na nyuumbii, maa Yéesu akavasea, “Sa che mootʉla isóso no rɨra? Muhíínja sɨ akwíire tʉkʉ, nɨ alɨ́ɨre vii.” ");
INSERT INTO lag_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Voovo vakamʉseka Yéesu na heenchʉ. Maa kaa, Yéesu akavakibirya voosi vafume na weerwii, akavaanɨrɨra íyo na taáta waala muhíínja na vapooji ˆveene ajáa novo hara. Maa vakɨɨngɨra na hara haantʉ muhíínja ˆajáa aláariiwe. ");
INSERT INTO lag_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yéesu akamʉkwaata mʉkono muhíínja, maa akamʉsea, “Talíita, kúumi,” noo kʉsea, “Muhíínja, nakʉséire, inʉka!” ");
INSERT INTO lag_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hahara, ʉra muhíínja akiinʉka, maa akaanda yeenda. Muhíínja ajáa atɨɨte myaaka ikimi na ɨvɨrɨ. ˆVakoone jeyyo, maa vakatʉlʉvala maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yéesu akavakaanʼya, yoosea, “Karɨ mʉlʉ́ʉsaa ɨrɨ isáare kʉrɨ mʉʉntʉ baa ʉmwɨ vii tʉkʉ.” Maa akavasea vara vaantʉ vamʉheere chóorya ʉra muhíínja arye. ");
INSERT INTO lag_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yéesu akiinʉka fuma kwa Yaíiro, akadomanʼya na vapooji vaachwe fʉʉrʉ múujii wa Nasaréeti kʉʉntʉ ˆakʉrɨra. ");
INSERT INTO lag_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na sikʉ ya Sabáato ˆɨkafike, akaanda variyʉla Masáare ˆYarɨ Mpeho sinagóogii. Vaantʉ va Nasaréeti ˆvarɨ foo ˆveene vamʉteereráa, vakatʉlʉvala, maa vakasea, “Ʉhʉ, hai ayatúriirye masáare aya? Na ʉlʉ lʉvɨro lo bweeyya myuujíisa? Tooti iji nɨ jirikwi? ");
INSERT INTO lag_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Eri, ʉhʉ sɨ ʉra mʉsóngoli mbáwo, mwaana wa Maríia tʉkʉ wʉʉ? Baa vandʉʉ vaachwe, sɨ vala Yaakúupu, Yóose, Yʉ́ʉda na Simóoni tʉkʉ wʉʉ? Na vandʉʉ vaachwe va kɨɨntʉ kiki, sɨ ava ˆtwiíkalaa novo aha?” Maa vakasiita muruma. ");
INSERT INTO lag_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yéesu akavasea, “Mʉláali na mʉtwe wa Ijʉva arúmwaa kɨra haantʉ, maa kaa, sɨ arúmwaa múujii meevo tʉkʉ, na kwa vandʉʉ vaachwe na kaayii kwaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sa jeyyo, nɨ atʉmama myuujíisa mɨke vii, yo vavɨkɨra mɨkono valwɨ́ɨrɨ, novo vakahongera. ");
INSERT INTO lag_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Akahwaalala maatʉkʉ vii, sa viintʉ sɨ vamuruma. Hara, maa Yéesu akariinga maturii ya heehi na Nasaréeti meevo, kʉnʉ yoovavariyʉrɨra vaantʉ Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akavaanɨrɨra vapooji vaachwe ikimi na vavɨrɨ. Akavaheera wiimiriri mweeri ya mirimʉ mɨvɨ. Akavatʉma vavɨrɨvɨrɨ, kʉnʉ ");
INSERT INTO lag_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","yoovalairirya, “Kati ˆmookera njɨra, karɨ mʉsʉ́mʉlaa muriwa tʉkʉ, baa chóorya tʉkʉ, baa kei karɨ mʉsʉ́mʉlaa mpía tʉkʉ, sumuli nkome vii, ");
INSERT INTO lag_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","na viráatʉ ivikiri, maa kaa, karɨ mʉsʉ́mʉlaa nkáancho ya kavɨrɨ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kei akavasea, “Kaaya ˆngʼeene mʉrɨ teengiwa ikali haaho, fʉʉrʉ sikʉ ˆmʉrɨ looka múuji ʉwo. ");
INSERT INTO lag_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na haantʉ hohoosi ˆvarɨ siita vateengya no siita vateerera masáare yaanyu, looki na ikonkomi marʉrɨ majewii yaanyu, koonekya ʉvɨ waavo.” ");
INSERT INTO lag_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Vapooji vaachwe vakadoma, kʉnʉ voovariyʉla vaantʉ vavalandʉke fuma uvii waavo. ");
INSERT INTO lag_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Baa kei vakibiryáa mirimʉ mɨvɨ ˆɨrɨ foo, vavahakáa valwɨ́ɨrɨ makuta, novo vahongeráa. ");
INSERT INTO lag_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mpɨɨndɨ ijo, mʉtemi Heróode Antípaasi akateera masáare ya Yéesu, sa viintʉ irina ra Yéesu ˆralʉʉswáa kɨra haantʉ. Vamwɨ va vaantʉ vaseáa, “Ʉhʉ nɨ Yooháani Mʉbatisáaji ˆafúfukire fuma inkwyii. Ɨkɨ noo ˆchooreka lʉvɨro lo bweeyya myuujíisa lʉrɨ ne.” ");
INSERT INTO lag_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vamwɨ vaseáa, “Ʉhʉ nɨ Elía, mʉláali na mʉtwe wa Ijʉva.” Kei vamwɨ vaseáa, “Ʉhʉ nɨ ja vara valáali na mʉtwe va Ijʉva va kalɨ.” ");
INSERT INTO lag_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Maa kaa, Heróode ˆakateere masáare ayo, akasea, “Ʉhʉ nɨ ʉra ˆnamʉdʉmʉla mʉtwe, Yooháani Mʉbatisáaji. Afúfukire!” ");
INSERT INTO lag_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Heróode alʉʉsa jeyyo sa ʉko nyuma ajáa alairirya Yooháani Mʉbatisáaji akwaatwe, avɨɨkwe mʉnyololwii, sa Herodía. Ʉhʉ Herodía nɨ muki wa Filíipi, mwaanaavo na Heróode ajáa. Heróode ajáa amʉloola. ");
INSERT INTO lag_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Na Yooháani Mʉbatisáaji amʉseáa Heróode, “Miiro yakaanʼya weewe kʉmʉsʉmʉla muki wa mwaanaanyu.” ");
INSERT INTO lag_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sa jeyyo, Herodía akamʉvɨɨkɨra Yooháani ikuundi mutimii, asaakáa amʉʉlae, nkalo vii ɨndoosoveka. ");
INSERT INTO lag_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heróode amoofáa Yooháani sa ajáa ataanga Yooháani nɨ mʉwoloki na nɨ mʉʉja wa Mʉlʉʉngʉ, maa ɨndoomukitirirya sa Herodía asiindwe kʉmʉʉlaa. Kei, Heróode ajáa eenda kʉteerera masáare ya Yooháani, baa neembe masáare yaachwe yamutuungyáa ʉsʉʉngʉ mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Maa reerʉ, nkalo ɨkatooreka. Sikʉ ɨyo, Heróode ajáa abwéeyyiirye ngovi yo kʉmbʉkɨra sikʉ ˆavyaalwa. Akavalaarɨka valʉme iiláangyaa novo sáare, vakʉ́ʉ́lʉ va vakʉ́ʉ́lʉ va valwi nkoondo na vakʉ́ʉ́lʉ va Galiláaya. ");
INSERT INTO lag_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aho ngovii, muhíínja wa Herodía akamʉvɨnɨra Heróode na vayeni vaachwe, maa vakavyeenda maatʉkʉ vii. Mʉtemi Heróode akamʉsea ʉra muhíínja, “Lʉʉsa kɨɨntʉ chochoosi ˆwoosaaka, nɨɨnɨ kʉheera ndɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akiilaha, yoosea, “Niiláhire! Kɨɨntʉ chochoosi ˆʉrɨ saaka, nɨɨnɨ kʉheera ndɨrɨ. Baa koonɨ nɨ kʉkʉkerera ɨsɨ ya ʉtemi waanɨ katɨ na katɨ.” ");
INSERT INTO lag_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Maa ʉra muhíínja akafuma, akɨɨta muurya íyo waavo, “Nɨ kɨɨntʉ che ndɨrɨ loomba?” Íyo waavo akamʉsea, “Mʉtwe wa Yooháani Mʉbatisáaji!” ");
INSERT INTO lag_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hahara, akahɨndʉka itɨ́ɨjo na kʉrɨ mʉtemi, maa akamʉsea, “Mpeera haaha vii, mʉtwe wa Yooháani Mʉbatisáaji ʉvɨ́kɨɨrwe ikaafii.” ");
INSERT INTO lag_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mʉtemi akavisʉʉla maatʉkʉ vii. Maa kaa, sa viintʉ ajáa amwiiláhɨɨre mbere ja vayeni vaachwe, akasiindwa mʉsɨɨtɨra. ");
INSERT INTO lag_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hahara, mʉtemi Heróode akamʉtʉma mulwi nkoondo ʉmwɨ, akareete mʉtwe wa Yooháani. Ʉra mulwi nkoondo akɨɨngɨra na mʉnyololwii, akamʉdʉmʉla Yooháani Mʉbatisáaji mʉtwe. ");
INSERT INTO lag_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Akavɨkɨra mʉtwe wa Yooháani ikaafii, maa akamʉtwaarɨra mwaana wa Herodía, ne akamʉkwaatya íyo waavo. ");
INSERT INTO lag_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na vapooji va Yooháani ˆvakateere ayo masáare, vakɨɨta sʉmʉla mʉvɨrɨ waachwe, maa vakɨɨta mʉtaaha mbiríírii. ");
INSERT INTO lag_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Vatumwi va Yéesu ˆvakahɨndʉke, vakamuwyɨɨra Yéesu viintʉ vyoosi ˆvatʉ́mamire na ˆvyeene vakíindiirye. ");
INSERT INTO lag_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Maa Yéesu akavasea, “Hendi, tʉdome na kijiraawii, mʉkahʉmʉlʉke kiduudi.” Alʉʉsa jei, sa hara haantʉ ˆvajáa, kwajáa kwatɨɨte vaantʉ ˆvarɨ foo ˆvʉʉjáa no looka, vakasova baa nkalo yo rya. ");
INSERT INTO lag_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hara, vakiinʉka na mashʉ́wa, maa vakadoma na haantʉ ha tʉʉla kusiina vaantʉ. ");
INSERT INTO lag_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Maa kaa, vaantʉ ˆvarɨ foo vakavoona Yéesu na vapooji vaachwe voolooka, maa vakavataanga. Vakakʉʉrɨka na lwa kʉʉlʉ fuma míiji yoosi, vakadoma na kʉra kʉʉntʉ Yéesu ˆadomáa, maa vakalongoola fika. ");
INSERT INTO lag_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yéesu ˆakakiime mbarɨmbarɨ ya iriva, akoona mayɨɨmbɨ ya vaantʉ, akavoonera mbavariri sa vajáa nɨ ja muundi ˆjisiina muríisi. Maa, akaanda variyʉla masáare ˆyarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ˆKʉkaande kʉswa, vapooji vakɨɨta kʉrɨ Yéesu, maa vakamʉsea, “Haantʉ aha nɨ kʉlɨ na kaaya ja vaantʉ, baa kei mwaasʉ waswɨ́ɨre. ");
INSERT INTO lag_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aaɨ, varekere vaantʉ, vakiiwʉrɨre vyóorya ʉko mawundii na maturii ˆyarɨ heehi.” ");
INSERT INTO lag_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Maa kaa, Yéesu akavasea, “Vaheeri nyuunyu chóorya.” Novo vakamʉsea, “Hai tʉrɨ fumya mpía ja dináari magana yavɨrɨ (200) jo wʉrɨra chóorya cho viikutya vaantʉ voosi ava?” ");
INSERT INTO lag_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Akavuurya, “Mɨkáate ɨngaɨ mwatɨɨte? Hoonɨ kalaangi.” ˆVakahɨndʉke, maa vakamʉsea, “Ɨmwaarɨ mɨkáate ɨsaano na soompa ivɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Maa akavalairirya, vaviikarye vaantʉ kɨtoongetoonge masaambii. ");
INSERT INTO lag_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Vaantʉ novo vakiikala vitoonge vya vaantʉ makumi yasaanosaano (50) na makumi ikimikimi (100). ");
INSERT INTO lag_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yéesu akatoola ɨra mɨkáate ɨsaano na jira soompa ivɨrɨ. Akiinurirya miiso yaachwe na kurumwii yoomʉdʉʉmba Mʉlʉʉngʉ. Akabendʉlabendʉla ɨra mɨkáate ɨsaano, maa akavaheera vapooji vaachwe novo vakavaheera vaantʉ. Baa na jira soompa ivɨrɨ akabweeyya vivira. ");
INSERT INTO lag_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Vaantʉ voosi vakarya, vakiikuta. ");
INSERT INTO lag_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vapooji vakatoorera mabéendʉ ya mɨkáate, vakamemya vikápu ikimi na vivɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Vaantʉ ˆvaarya vajáa vamema maatʉkʉ vii, vaantʉ valʉme vii nɨ mayana yasaano (5,000) vajáa. ");
INSERT INTO lag_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hahara vii, Yéesu akavadoomererya vapooji vaachwe, vaambʉke mashʉ́wa, valongoole na iturii ra Besaída, nyambʉko ya iriva ra Galiláaya. Yeeye akachaala yookiiteengʉla na ɨra mpuka. ");
INSERT INTO lag_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Vaantʉ ˆvakalooke, akaambʉka na luulwii noo mʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na mpɨɨndɨ ja iwʉlo, mashʉ́wa ɨjáa yafíkire katɨ na katɨ ya iriva, na Yéesu ajáa achɨ́hɨɨre yeemweene luulwii. ");
INSERT INTO lag_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Maa akavoona vapooji vaachwe kʉʉra vootʉrɨkɨra kʉtwaala mashʉ́wa na mbere, sa ihúmbuuto rawuváa fuma mbere yaavo. ˆƗkafike namuyiingʉ, Yéesu akavatuuba na katɨkatɨ ya iriva yooyeendera mweeri ya maaji, akava yoosaaka valooka. ");
INSERT INTO lag_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Maa kaa, ˆvakamoone yooyeenda mweeri ya maaji, vakiisea nɨ murimʉ. Aho, vakaanda kwaana ntáákwi, ");
INSERT INTO lag_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sa ˆvakamoone, voosi vajáa viivʉndʉka maatʉkʉ vii. Hahara, maa akavasea, “Fafyi mɨtɨma, nɨ nɨɨnɨ, koofi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yéesu akaambʉka na mashúwii hamwɨ novo, aho, maa ihúmbuuto rɨkaherya. Vapooji vaachwe vakatʉlʉvala maatʉkʉ vii, ");
INSERT INTO lag_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","sa vajáa vakaarɨ taanga ʉra muujíisa wa mɨkáate na mɨtɨma yaavo ɨjáa ɨkaarɨ yafafa. ");
INSERT INTO lag_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yéesu na vapooji vaachwe ˆvakafɨrɨre iriva ra Galiláaya, maa vakafika ɨsɨ ya Genesaréeti, aho, vakiimya mashʉ́wa. ");
INSERT INTO lag_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ˆVakakiime vii mashúwii, maa vaantʉ vakamʉtaanga Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Vakarɨɨngɨrɨra chaangʉ ɨsɨ yoosi, na vakatoola valwɨ́ɨrɨ na ndɨrɨ jaavo, maa vakavatwaala na kʉʉntʉ ˆvateeráa Yéesu amwaarɨ. ");
INSERT INTO lag_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kɨra múuji, ituri, na miwundii, noo kʉsea, kɨra haantʉ Yéesu ˆadomáa, vaantʉ vavavɨɨkáa valwɨ́ɨrɨ vaavo gurii. Na vamʉloombáa, avarekere valwɨ́ɨrɨ vasaasye baa mʉkáwo wa ɨngo yaachwe vii. Na voosi ˆvasaasya ɨngo yaachwe, vahongera. ");
INSERT INTO lag_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sikʉ ɨmwɨ, vamwɨ va Mafarisáayo na vakiindya va Miiro fuma Yerusaléemu, vajáa viisaanka mbere ya Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Aho, vakavoona vamwɨ va vapooji va Yéesu, voorya chóorya na mɨkono ˆɨrɨ na njeo, noo kʉsea, baa kooyya mɨkono ja ˆvyeene vyasáakwaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafarisáayo na Vayahúudi voosi koonɨ sɨ vanooyya mɨkono ja ˆvyeene vyasaakwa, sɨ varijáa tʉkʉ, kutuuba nkʉʉngʉ ya vala baaba waavo. ");
INSERT INTO lag_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mpɨɨndɨ ˆvafúmire sokóonii, sɨ varíjaa kɨɨntʉ chochoosi tʉkʉ mpaka vooyye mɨkono kʉseyya njeo. Na vatɨɨte nkʉʉngʉ jɨɨngɨ ˆjiri foo vii ˆvatúubaa, baa ja yo kooyya ndʉvo, nyiingʉ na saama ja sháaba. ");
INSERT INTO lag_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aho, Mafarisáayo na vakiindya va Miiro vakamʉsea Yéesu, “Eri, sa che vapooji vaako sɨ vatúubaa nkʉʉngʉ ja vala baaba, vandoorya na mɨkono ˆɨrɨ na njeo?” ");
INSERT INTO lag_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Maa Yéesu akavasea, “Mʉláali na mʉtwe wa Ijʉva Isáaya alʉʉsa kɨmaarɨ mpɨɨndɨ ˆalaaláa na mʉtwe sa nyuunyu vakweembi ja ˆvyeene Masáare ˆYarɨ Mpeho yalʉʉsa, ‘Vaantʉ ava vaanyémyaa na mɨlomo vii, maa kaa, mɨtɨma yaavo ɨrɨ kʉlɨ na nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kuunyinamɨra kwaavo nɨ ja kisiina, sa nɨ vavariyʉláa ndairiri ja vaantʉ vii.’ ");
INSERT INTO lag_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kɨmaarɨ, mwarékire ndairiri ja Mʉlʉʉngʉ maa mʉkakwaatɨrɨra nkʉʉngʉ ˆjavɨɨkwa nɨ vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Akavasea kei, “Mwamányire pala ndairiri ja Mʉlʉʉngʉ kɨweere sa mutuube nkʉʉngʉ jaanyu. ");
INSERT INTO lag_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mʉ́sa mʉláali na mʉtwe wa Ijʉva asea, ‘Ʉvanyemye vala íyo na taáta waanyu,’ na ‘Ʉra ˆarɨ mʉtʉkɨra íyo au taáta waavo, ʉʉlawe.’ ");
INSERT INTO lag_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Maa kaa, nyuunyu mʉndoovavariyʉrɨra vaantʉ, vandoovasea vala íyo na taáta waavo, ‘Haɨ, sɨ ndɨrɨ daha kʉvaambirirya tʉkʉ, sa ɨkɨ ˆnatɨɨte nɨ Korobáani, noo kʉsea, kɨlʉngʉlʉngʉ ˆnakera na ivarwii sa Mʉlʉʉngʉ.’ ");
INSERT INTO lag_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jeyyo, noo vyahérire, kusiina kʉvaambirirya vala íyo na taáta waavo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jeyyo, noo ˆvyeene muchwíjaa matɨ isáare ra Mʉlʉʉngʉ sa nkʉʉngʉ jaanyu ˆmwiihéereryaa. Baa kei, vimwaarɨ viintʉ ˆviri foo vii ˆmʉtʉ́mamaa ˆviifwɨ́ɨne na ivyo.” ");
INSERT INTO lag_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aho, Yéesu akavaanɨrɨra vaantʉ, akavasea, “Voosi kɨra ʉmwɨ waanyu nteereri neeja, mʉtaange ɨkɨ. ");
INSERT INTO lag_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kusiina kɨɨntʉ ˆkɨmwɨɨ́ngɨraa mʉʉntʉ ˆkɨdáhaa mʉbweeyya ave na njeo tʉkʉ. Kɨrɨ vyoova jeyyo, ˆkimufúmaa mutimii noo kɨmʉbwéeyyaa ave na njeo.  ");
INSERT INTO lag_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ˆArɨ na matu nɨ ateere.” ");
INSERT INTO lag_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ˆAkiireke na ɨra mpuka ya vaantʉ, akɨɨngɨra na nyuumbii, maa vapooji vaachwe vakamʉsea avariyʉle lʉra lusímo lwaachwe. ");
INSERT INTO lag_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ne akavasea, “Baa nyuunyu sɨ mootaanga tʉkʉ wʉʉ? Sɨ mootaanga kusiina kɨɨntʉ baa kɨmwɨ ˆkɨmwɨɨ́ngɨraa mʉʉntʉ ˆkɨrɨ mʉbweeyya ave na njeo tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sa koonɨ mʉʉntʉ aríire kɨɨntʉ, sɨ kɨmwɨɨngɨráa na mutimii tʉkʉ, nɨ kɨmwɨɨngɨráa na indii vii, maa kɨkafuma kɨkatwaalwa na chóowii.” ˆAkalʉʉse jei, akava aséire vyóorya vyoosi vʉʉ, visiina njeo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akoongererya, yoosea, “ˆKimufúmaa mʉʉntʉ fuma mutimii noo ˆkɨmʉbwéeyyaa ave na njeo. ");
INSERT INTO lag_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sa kufuma mutimii wa mʉʉntʉ, yafúmaa miiririkano mɨvɨ, ʉhanguti, ");
INSERT INTO lag_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","wiivi, wʉʉlaishi, kʉyeenda na muki wa mʉʉntʉ, kʉkwaata matu, kʉbweeyya ʉvɨ, ʉkwaata, kʉyeenda ja kúri, kɨvɨna, kʉtʉkɨra, kwiivaa kɨpeembe na ʉkoókoyo. ");
INSERT INTO lag_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ʉvɨ woosi ʉhʉ nɨ mutimii ufúmaa na noo ʉbwéeyyaa mʉʉntʉ ave na njeo.” ");
INSERT INTO lag_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hara, maa Yéesu akakwaata njɨra, akadoma fʉʉrʉ ɨsɨ ja Tíiro na Sidóoni. ˆAkafike, akɨɨngɨra nyuumba ɨmwɨ na sɨ asaakáa mʉʉntʉ baa ʉmwɨ ataange koonɨ amwaarɨ tʉkʉ, maa kaa, vyasɨɨndɨkana kwiivisa. ");
INSERT INTO lag_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kʉjáa kwatɨɨte mʉʉntʉ muki ʉmwɨ Mugiríki fuma ɨsɨ ya Síria Foiníike, ajáa na kahíínja kaachwe ˆkarɨ na mirimʉ mɨvɨ. ˆAkateere Yéesu amwaarɨ, akafweenga fʉʉrʉ kʉrɨ Yéesu, akachwaama mbere yaachwe, maa akamʉloomba Yéesu akaseyye kahíínja kaachwe mirimʉ mɨvɨ. ");
INSERT INTO lag_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Maa Yéesu akamʉyera ʉra maáma, “Reka ta nɨvaambirirye Vayahúudi viivaanɨ. Sɨ vyabooha kʉtoola chóorya cha vasinga na ujiheere kúri tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ʉra maáma akasea, “Nɨ kɨmáárɨ ulúusire, maa kaa, baa kúri iruungwii ra méesa, jaríjaa mangʼenyengʼenye ya chóorya cha vasinga.” ");
INSERT INTO lag_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Maa Yéesu akamʉsea, “Sa viintʉ wuúyiirye vyabooha, doma na kaayii, murimʉ mʉvɨ wamufúmire muhíínja waako.” ");
INSERT INTO lag_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ˆAkafike kaayii kwaachwe, akakashaana kahíínja kaachwe kahúmulukire kɨtáandii, murimʉ mʉvɨ wafúmire. ");
INSERT INTO lag_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aho, Yéesu akiinʉka fuma ɨsɨ ya Tíiro akakwaata na katɨ na katɨ ya Sidóoni, maa akadoma na ɨsɨ ya Dekapóoli fʉʉrʉ iriva ra Galiláaya. ");
INSERT INTO lag_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kɨmatu ʉmwɨ sɨ ˆadáhaa lʉʉsɨka neeja akareetwa nɨ vaantʉ, maa vakamʉloomba Yéesu amʉvɨkɨre mɨkono sa ahole. ");
INSERT INTO lag_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yéesu akamʉtwaala na ivarwii ʉra kɨmatu kʉlɨ na vaantʉ. Akamʉvɨkɨra maamba jaachwe matwii, akachwɨɨra matɨ mamaambii, maa akamʉsaasya lurimi. ");
INSERT INTO lag_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Akalaanga kurumwii, maa akakeeha nɨ ʉsʉʉngʉ akamʉsea, “Efáata!” noo kʉsea, “Yʉʉrɨka.” ");
INSERT INTO lag_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hahara matu yaachwe yakayʉʉrɨka na lurimi lwaachwe lʉkachʉngʉlʉka, akaanda lʉʉsɨka neeja. ");
INSERT INTO lag_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yéesu akavakaanʼya vaantʉ vara ˆvajáa hara akavasea, “Sɨ mʉyalʉʉse masáare aya kʉrɨ mʉʉntʉ baa ʉmwɨ vii tʉkʉ.” Maa kaa, ja ˆvyeene avakaanʼyáa kʉlʉʉsa, noo ˆvyeene valookyáa kwaarya ayo masáare. ");
INSERT INTO lag_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vaantʉ vakatʉlʉvala mʉnʉmʉʉnʉ voosea, “Viintʉ vyoosi ˆatʉ́mamire vyabooha maatʉkʉ vii! Baa vimatu abwéeyyiirye vandooteera na vimumu vandoolʉʉsɨka.” ");
INSERT INTO lag_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sikʉ jijira, Yéesu ajáa na mpuka nkʉʉlʉ ya vaantʉ. Sa viintʉ vajáa vasiina chóorya, Yéesu akavaanɨrɨra vapooji vaachwe akavasea, ");
INSERT INTO lag_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Arumi, noovoonera mbavariri ava vaantʉ, viíkyɨɨre na nɨɨnɨ aha sikʉ itatʉ na vasiina chóorya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Koonɨ navarékire vadome na njala na kaayii, yɨrɨka varɨ nɨ njala njirii sa vamwɨ vafumiré kʉlɨ.” ");
INSERT INTO lag_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Vapooji vaachwe vakamʉsea, “Hai tʉrɨ fumya chóorya cho viikutya vaantʉ voosi ava aha nyikii?” ");
INSERT INTO lag_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yéesu akavuurya, “Mɨkáate ɨngaɨ mwatɨɨte?” Novo vakasea, “Mufungatɨ.” ");
INSERT INTO lag_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Akavalairirya vaantʉ viikale ɨsɨ. Akatoola ɨra mɨkáate mufungatɨ, akamʉdʉʉmba Mʉlʉʉngʉ, akabendʉlabendʉla, sa vavagavɨre vaantʉ. Novo vapooji vakabweeyya jeyyo. ");
INSERT INTO lag_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na kei vajáa vatɨɨte fisoompa fingaɨ vii. Akafitalarya, maa akavalairirya vapooji vaachwe vavaheere vaantʉ. ");
INSERT INTO lag_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vaantʉ vaarya, vakiikuta. ˆVakahʉmʉle, vakatoorera mabéendʉ ya mɨkáate ˆɨchɨ́hɨɨre, vakamemya vikápu mufungatɨ. ");
INSERT INTO lag_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Vaantʉ ˆvaarya nɨ ja mayana yanɨ (4,000) vajáa. Hara, maa akasuukya. ");
INSERT INTO lag_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Akaambʉka mashʉ́wa hamwɨ na vapooji vaachwe, maa vakafɨrɨra fʉʉrʉ ɨsɨ ya Dalumanúuta. ");
INSERT INTO lag_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafarisáayo vakʉʉja, maa vakaanda kwiiruta ne ndihi, voosaaka isháara fuma kurumwii sa vamʉtee. ");
INSERT INTO lag_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yéesu ˆakateere masáare yaavo, akakeeha na ʉsʉʉngʉ, maa akavasea, “Sa che mbyaala ɨhɨ yooloomba isháara? Kɨmaarɨ noovawyɨɨra, mbyaala ɨhɨ sɨ ndɨrɨ kɨɨheera isháara tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ˆAkavareke, akaambʉka mashʉ́wa, maa akakwaata njɨra fʉʉrʉ nyambʉko ya iriva. ");
INSERT INTO lag_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Vapooji vajáa varímiirye sʉmʉla mɨkáate, na hara mashúwii, vajáa vatɨɨte mʉkáate umudu vii. ");
INSERT INTO lag_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yéesu akavalʉma kutu yoovasea, “Mʉlaange neeja, mʉnehe ʉsasɨ wa Mafarisáayo na wa Heróode.” ");
INSERT INTO lag_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Vapooji vaachwe vakaanda kiiwyɨɨra vooveene voosea, “Alúusire jei sa viintʉ tusiina mɨkáate.” ");
INSERT INTO lag_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yéesu akataanga kʉlʉʉsɨka kwaavo, maa akavuurya, “Sa che mookiiruta ndihi sa viintʉ musiina mɨkáate? Eri, mʉkaarɨ sɨ mʉnataanga no vyoona tʉkʉ wʉʉ? Sa che mwafafya mɨtɨma jei? ");
INSERT INTO lag_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Amwɨ mwatɨɨte miiso, sɨ mookoona viintʉ ˆnoovariyʉla tʉkʉ wʉʉ? Na matu mwatɨɨte, sɨ mooteera viintʉ ˆnoovariyʉla tʉkʉ wʉʉ? Sɨ moodaha kʉmbʉkɨra baa kimudu vii tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mpɨɨndɨ ˆmbéndwɨɨrembendwɨɨre ɨra mɨkáate ɨsaano nkavaheera vaantʉ mayana yasaano (5,000), nɨ vikápu yangaɨ mwamemya ya mabéendʉ ya mɨkáate?” Maa vakuuyirya, “Ikimi na vivɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ha mpɨɨndɨ ˆnkabendʉlebendʉle mɨkáate mufungatɨ, maa nkavaheera vaantʉ mayana yanɨ (4,000), mwatoorera vikápu vingaɨ vya mabéendʉ ya mɨkáate?” Vakasea, “Mufungatɨ.” ");
INSERT INTO lag_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Maa akavuurya, “Mʉkaarɨ vii sɨ mootaanga tʉkʉ viintʉ ˆnoovariyʉla wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Maa reerʉ, Yéesu na vapooji vaachwe vakafika ituri ra Besaída. Vaantʉ vamwɨ vakareeta mʉhoku ʉmwɨ, maa vakamʉloomba Yéesu amʉsaasye. ");
INSERT INTO lag_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yéesu akamʉkwaata mʉkono, maa akamʉtwaala na ivarwii ra ituri. Akamʉchwɨɨra matɨ miiswii, akamʉvɨkɨra mɨkono, maa akamuurya, “Koona wiise kɨɨntʉ chochoosi wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ʉra mʉhoku akalaanga, maa akamʉsea, “Nookoona vaantʉ, maa kaa, varɨ ja mɨtɨ ˆyooyeenda.” ");
INSERT INTO lag_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kei Yéesu akamʉvɨkɨra mɨkono miiswii, ne akatuurya miiso, maa akoona kɨra kɨɨntʉ neeja. ");
INSERT INTO lag_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hara, maa Yéesu akamʉsea, “Doma na kaayii na kaja ʉtwéeraa na iturii tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Aho, Yéesu na vapooji vaachwe vakiinʉka, maa vakadoma fʉʉrʉ maturi ya Kaisaría Filíipi. Mpɨɨndɨ ˆvajáa njirii, Yéesu akavuurya, “Eri, vaantʉ vaséaa nɨɨnɨ ndɨrɨ ani?” ");
INSERT INTO lag_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Maa vakamʉsea, “Vamwɨ vaséaa weewe ʉrɨ Yooháani Mʉbatisáaji, na vɨɨngɨ vaséaa ʉrɨ Elía, mʉláali na mʉtwe wa Ijʉva, baa kei vɨɨngɨ vaséaa ʉrɨ ʉmwɨ wa valáali na mʉtwe va Ijʉva.” ");
INSERT INTO lag_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Maa akavuurya, “Ha nyuunyu, mwiiséaa nɨɨnɨ ndɨrɨ ani?” Peéteri akuuyirya, yoosea, “Weewe noo Masía.” ");
INSERT INTO lag_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yéesu akavakaanʼya yoosea, “Karɨ mumuwyɨ́ɨraa mʉʉntʉ baa ʉmwɨ masáare aya tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yéesu akaanda vavariyʉrɨra vapooji vaachwe, yoosea, “Mwaana wa Mʉʉntʉ, nɨ mpaka aturikiriwe mʉnʉmʉʉnʉ, baa kei siitwa arɨ nɨ vawosi, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro, na kʉʉlawa arɨ. Na sikʉ ya katatʉ fʉfʉlwa arɨ.” ");
INSERT INTO lag_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Avawyɨɨráa masáare aya kɨweerwii, baa vavisa tʉkʉ. Peéteri akamʉsʉmʉla na ivarwii, maa akaanda mʉbaamirirya areke lʉʉsa masáare ayo. ");
INSERT INTO lag_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yéesu akiilorera akavalaanga vapooji vaachwe, maa akamwaamirirya Peéteri, yoosea, “Irimʉ, isunke mbere yaanɨ, sɨ wookiiririkana masáare ya Mʉlʉʉngʉ tʉkʉ, wookiiririkana ya vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Akavaanɨrɨra vapooji vaachwe na ɨra mpuka ya vaantʉ akavasea, “Koonɨ mʉʉntʉ yoyoosi yoosaaka aantuube, nɨ mpaka iisiite yeemweene, avaale mʉsaláaba waachwe, aantuube. ");
INSERT INTO lag_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sa mʉʉntʉ yoyoosi ˆyoosaaka lamurirya nkaasʉ yaachwe, kɨɨtaaha arɨ, maa kaa, yoyoosi ʉra ˆyookɨɨtaaha nkaasʉ yaachwe sa nɨɨnɨ na Masáare Maaja, ʉwo kɨɨlamurirya arɨ. ");
INSERT INTO lag_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kwatɨɨte kʉnáálo che mʉʉntʉ kuturya weerʉ yoosi no kɨɨtaaha nkaasʉ yaachwe? ");
INSERT INTO lag_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bakʉ nɨ kɨɨntʉ che mʉʉntʉ arɨ toola sa nkaasʉ yaachwe? ");
INSERT INTO lag_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Koonɨ mʉʉntʉ yoyoosi aanyónɨɨre soni nɨɨnɨ na masáare yaanɨ mbere ja ɨhɨ mbyaala mbɨ ya vaantʉ ˆvayéendaa na vaki va vaantʉ, Mwaana wa Mʉʉntʉ ne moonera arɨ soni, mpɨɨndɨ ˆakuújire na nkongojima ya Taáta na mirimʉ miija.” ");
INSERT INTO lag_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Maa Yéesu akavasea jei, “Kɨmaarɨ noovawyɨɨra, vamwaarɨ vɨɨngɨ ˆviímire aha, baa sɨ vanaakwya, kʉʉyona varɨ Ʉtemi wa Mʉlʉʉngʉ wuújire na ngururu.” ");
INSERT INTO lag_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sikʉ mʉsasatʉ ˆjikalooke, Yéesu akavasʉmʉla vala Peéteri, Yaakúupu na Yooháani fʉʉrʉ ncholwii ya lʉʉlʉ kijiraawii. Ʉko, Yéesu akavalandʉka buuwo mbere yaavo. ");
INSERT INTO lag_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ɨngo jaachwe jikava njerʉ chwee, jindoolavalava, kusiina mufuli baa ʉmwɨ vii aha weerwii, ˆarɨ daha fula jeere jeyyo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aho, Mʉ́sa na Elía vakavafʉmɨra, vakaanda lʉʉsɨka ne. ");
INSERT INTO lag_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peéteri ˆakoone jeyyo, maa akamʉsea Yéesu, “Mukiindya, vyabooha viintʉ ˆtʉrɨ aha, haaha tʉjeenge vivaanda vitatʉ, kɨmwɨ chaako, kɨmwɨ cha Mʉ́sa na kɨmwɨ cha Elía.” ");
INSERT INTO lag_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peéteri alʉʉsa jeyyo, sa viintʉ yeeye na viivaachwe voofáa mʉnʉmʉʉnʉ, akasiindwa taanga cho lʉʉsa. ");
INSERT INTO lag_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hara, maa ichu rɨkafʉmɨra, rɨkavawɨɨkɨra na sawúti ɨkafuma aho ichwii yoosea, “Ʉhʉ nɨ Mwaana waanɨ ˆnamweenda, mʉteereri yeeye.” ");
INSERT INTO lag_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hahara, vapooji vakalaanga kʉnʉ na kʉnʉ, baa sɨ vamoona mʉʉntʉ tʉkʉ, vakamoona Yéesu yeemweene vii. ");
INSERT INTO lag_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na mpɨɨndɨ ˆvagiritáa fuma luulwii, Yéesu akavakaanʼya akavasea, “Karɨ mʉlʉ́ʉsaa aya masáare ˆmwɨɨ́ne tʉkʉ, fʉʉrʉ haantʉ Mwaana wa Mʉʉntʉ ˆakafʉ́fwɨɨrwe fuma inkwyii.” ");
INSERT INTO lag_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Vakarɨkwaatya ɨro isáare, kʉnʉ vookiiyurya vooveene, “Kʉfʉfʉka fuma inkwyii noo kɨɨntʉ che?” ");
INSERT INTO lag_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hara, maa vakamuurya Yéesu, “Amwɨ vakiindya va Miiro vaséaa, nɨ mpaka Elía ʉʉje ta?” ");
INSERT INTO lag_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Maa akavasea, “Nɨ kɨmáárɨ, Elía kʉʉja arɨ ta jɨ iimye neeja kɨra kɨɨntʉ. Sa che kei Masáare ˆYarɨ Mpeho yalʉʉsa, nɨ mpaka Mwaana wa Mʉʉntʉ aturikiriwe mʉnʉmʉʉnʉ, baa kei achwɨɨwe matɨ? ");
INSERT INTO lag_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nɨ kɨmaarɨ kaa noovawyɨɨra, Elía ʉʉja, novo vakamuturikirya na heno ja ˆvyeene veenda, ja ˆvyeene Masáare ˆYarɨ Mpeho yalʉʉsa.” ");
INSERT INTO lag_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yéesu na vara vapooji vaachwe vatatʉ ˆvakakiime lʉʉlʉ, vakavashaana vara vapooji vɨɨngɨ ˆviijíingɨrɨɨrwe nɨ mpuka ya vaantʉ, na vamwɨ va vakiindya va Miiro, vookiiruta ndihi novo. ");
INSERT INTO lag_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Vara vaantʉ ˆvakamoone Yéesu, vakahwaalala maatʉkʉ vii, maa vakamʉkɨbɨrɨra, vakɨɨta muluumbya. ");
INSERT INTO lag_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yéesu akavuurya, “Nɨ che mookiirʉtɨra ndihi novo?” ");
INSERT INTO lag_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Maa ʉmwɨ wa ɨra mpuka akuuyirya, yoosea, “Mukiindya, naréetire mʉtavana waanɨ, atɨɨte murimʉ mʉvɨ ˆumudúngyaa mʉlomo asiindwe lʉʉsɨka. ");
INSERT INTO lag_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kɨra ˆʉrɨ kiinʉka wamʉváyyaa ɨsɨ, maa ɨndootuumpa ifulo no sha mayeo, kei ɨndoofafa bʉʉ. Haaha navalóombire vapooji vaako vamʉseyye ʉwo murimʉ mʉvɨ, maa kaa, vasíindirwe.” ");
INSERT INTO lag_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yéesu ˆakateere jeyyo, maa akavasea, “Aka! Ɨhɨ mbyaala sɨ ˆirúmaa, niikale na nyuunyu mpaka naadi? Na nɨvayimirirye mpaka naadi? Hoonɨ mʉreeti na aha.” ");
INSERT INTO lag_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Maa vakamʉtwaala na kʉrɨ Yéesu. Murimʉ mʉvɨ ˆʉkamoone Yéesu vii, ʉkamʉkwaatya ʉra mʉtavana kiinkwiisha, akawya na ɨsɨ. Akaanda kwiiwalaarya kʉnʉ yootuumpa ifulo. ");
INSERT INTO lag_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Maa Yéesu akamuurya taáta waala ʉwo mʉtavana, “Masáare aya yamwaanda keende naadi?” Akasea, “Keende udúúdi waachwe. ");
INSERT INTO lag_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na ˆkarɨ foo ʉhʉ murimʉ mʉvɨ wamʉváyyaa mootwii na luujii sa ʉmʉʉlae. Haaha koonɨ ʉrɨ daha, tooloomba ʉtoonere mbavariri, ʉtwaambirirye.” ");
INSERT INTO lag_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Maa Yéesu akamʉsea, “Atɨ koonɨ ndɨrɨ daha? Viintʉ vyoosi kwaanɨ vyadáhɨkaa kwa ʉra ˆmweene arɨ kuunduma.” ");
INSERT INTO lag_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Maa taáta waala ʉra mʉtavana akalʉʉsa na ngururu, yoosea, “Narúmire, nyambirirya ndahe seyya miiririkano yo dɨɨra kukuruma.” ");
INSERT INTO lag_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yéesu ˆakoone ɨra mpuka ya vaantʉ yookʉla, akʉʉyamirirya ʉra murimʉ mʉvɨ, yoosea, “We murimʉ mʉvɨ kimumu na kɨmatu. Nakʉséire ufume baa kei kusiina luu mwɨɨngɨra ʉhʉ mʉtavana tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aho, ʉra murimʉ mʉvɨ ʉkatʉla isóso, ʉkamusukasuka na ngururu ʉra mʉtavana, ʉkamʉrekera, maa akava ja akwíire. Baa vaantʉ vɨɨngɨ vakasea, “Amwɨ akwíire!” ");
INSERT INTO lag_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Maa kaa, Yéesu akamʉkwaata mʉkono, akamwiinʉla, ne akiinʉka. ");
INSERT INTO lag_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yéesu na vapooji vaachwe vakɨɨngɨra na nyuumbii, maa vakaanda muurya Yéesu kʉnʉ varɨ vooveene, “Sa che suusu tasíindirwe mʉseyya murimʉ mʉvɨ?” ");
INSERT INTO lag_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Maa akavasea, “Murimʉ mʉvɨ ˆʉrɨ jeyyo, sɨ ʉséyyiwaa jei vii tʉkʉ, nɨ mpaka mʉlʉʉsɨke na Ijʉva.” ");
INSERT INTO lag_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hara, maa Yéesu na vapooji vakiinʉka, vakakwaatɨra na ɨsɨ ya Galiláaya. Maa kaa, Yéesu sɨ asaakáa mʉʉntʉ baa ʉmwɨ ataange haantʉ ˆvarɨ tʉkʉ, ");
INSERT INTO lag_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sa asaakáa ave na vapooji vaachwe, ɨndoovavariyʉrɨra masáare ayo. Akavavariyʉrɨra, yoovasea, “Mwaana wa Mʉʉntʉ, vɨɨkwa arɨ mɨkonwii ya vaantʉ, novo kʉmʉʉlaa varɨ, na sikʉ ya katatʉ, fʉfʉlwa arɨ.” ");
INSERT INTO lag_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Maa kaa, vapooji vaachwe, sɨ vataangáa ˆcheene alʉʉsɨkáa tʉkʉ, kei voofáa kumuurya. ");
INSERT INTO lag_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Maa reerʉ, vakafika ɨsɨ ya Kaperenáumu. Vakɨɨngɨra na nyuumbii, maa Yéesu akavuurya, “Che mwaakiirʉtɨra ndihi kʉra njirii?” ");
INSERT INTO lag_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Maa voovo vakakirinya sawu, baa kuuyirya tʉkʉ, sa vajáa vatáangire kɨɨntʉ ˆviirʉtɨráa ndihi kʉra njirii, nɨ ani noo mʉkʉ́ʉ́lʉ. ");
INSERT INTO lag_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yéesu akiikala, akavakemera vapooji vaachwe ikimi na vavɨrɨ, maa akavasea, “Mʉʉntʉ ˆyoosaaka ave mʉkʉ́ʉ́lʉ, yoosaakwa iihetye nyuma, na avatʉmamɨre viivaachwe voosi.” ");
INSERT INTO lag_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aho, akamʉreeta musinga muduudi, akamwiimya katɨ na katɨ yaavo, akamwiinʉla yoomʉvɨɨka kɨpeembii, maa akavasea, ");
INSERT INTO lag_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mʉʉntʉ ˆarɨ mʉteengya musinga ja ʉhʉ sa irina raanɨ, kʉva arɨ aantéengiirye nɨɨnɨ. Na ʉra ˆmweene arɨ kʉʉnteengya nɨɨnɨ, sɨ arɨ kʉva aantéengiirye vii tʉkʉ, kei kʉva arɨ amʉtéengiirye Mʉlʉʉngʉ, na yeeye aantʉma.” ");
INSERT INTO lag_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Maa Yooháani akamʉsea, “Mukiindya, tamwɨɨ́ne mʉʉntʉ yookibirya mirimʉ mɨvɨ kwa irina raako, maa tʉkamʉkaanʼya sa viintʉ sɨ arɨ hamwɨ na suusu.” ");
INSERT INTO lag_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Maa kaa, Yéesu akavasea, “Karɨ mʉmʉkáanʼyaa tʉkʉ. Sa kusiina mʉʉntʉ ˆatʉ́mamaa myuujíisa kwa irina raanɨ, kei aanvarindʉke chaangʉ alʉʉse ʉvɨ kʉrɨ nɨɨnɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sa sɨ ˆarɨ mʉvɨ wiitʉ, nɨ hamwɨ arɨ na suusu. ");
INSERT INTO lag_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kɨmaarɨ noovawyɨɨra, mʉʉntʉ ˆarɨ vaheera baa ndʉvo ya maaji yo nywa vii sa nyuunyu nɨ vaantʉ va Kirisitʉ, kɨkomi sɨ arɨ sova kʉnáálo yaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kei akavasea, “Koonɨ mʉʉntʉ amʉháandire ʉmwɨ wa ava vadúúdi ˆvaanduma atʉmame ʉvɨ, nɨ pwee yaachwe achʉʉngɨrwe lwaala nkiingwii, maa afweitɨrwe mayiyii. ");
INSERT INTO lag_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na koonɨ iyaanja raako rakʉháandire ʉtʉmame ʉvɨ, rɨteme rɨdʉmʉke. Nɨ pwee kɨɨngɨra na nkaaswii ʉrɨ na iyaanja rɨmwɨ, kʉlookya kʉdoma na mootwii wa Jehénamu ʉra sɨ ˆurímaa, ʉrɨ na mayaanja yoosi.  ");
INSERT INTO lag_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ʉko noo kʉʉntʉ ngʼonyu sɨ ˆjikwíjaa na mooto sɨ ˆurímaa. ");
INSERT INTO lag_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kei, koonɨ ijeo raako rakʉháandire ʉtʉmame ʉvɨ, rɨteme rɨdʉmʉke. Nɨ pwee kɨɨngɨra na nkaaswii ʉrɨ na ijeo rɨmwɨ, kʉlookya kʉfweitɨrwa na mootwii wa Jehénamu ʉrɨ na majeo yavɨrɨ.  ");
INSERT INTO lag_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ʉko noo kʉʉntʉ ngʼonyu sɨ ˆjikwíjaa na mooto sɨ ˆurímaa. ");
INSERT INTO lag_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na koonɨ riiso raako rakʉháandire ʉtʉmame ʉvɨ, rɨnonkole. Nɨ pwee kɨɨngɨra Ʉtemii wa Mʉlʉʉngʉ ʉrɨ na ipoócho, kʉlookya kʉfweitɨrwa na mootwii wa Jehénamu ʉrɨ na miiso yoosi. ");
INSERT INTO lag_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ʉko, ‘noo kʉʉntʉ ngʼonyu sɨ ˆjikwíjaa, na mooto sɨ ˆurímaa.’ ");
INSERT INTO lag_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Voosi talariwa mʉrɨ nɨ mooto ja ˆvyeene mpóryo jitálariwaa nɨ sangása. ");
INSERT INTO lag_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sangása yabooha, maa kaa, koonɨ yasúukire che ɨrɨ vɨkɨrwa de ɨve mwerere kei? Mʉve na sangása isii yaanyu. Mwiikale mwiikalo mʉʉja, kɨra mʉʉntʉ na mwiiwaachwe.” ");
INSERT INTO lag_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hara, maa Yéesu na vapooji vaachwe vakakwaata njɨra fuma Kaperenáumu fʉʉrʉ ɨsɨ ya Yudéea, vakafɨrɨra na ufumo wa mwaasʉ nyambʉko ya lʉʉjɨ lwa Yorodáani, mpuka nkʉʉlʉ ya vaantʉ ɨkamutuuba, maa akaanda vavariyʉrɨra Masáare ˆYarɨ Mpeho ja ˆvyeene iijʉvɨra. ");
INSERT INTO lag_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aho, vamwɨ va Mafarisáayo vakʉʉja voosaaka mʉyera Yéesu, maa vakaanda muurya, “Eri, Miiro yaruma mʉʉntʉ kʉmʉreka muki waachwe wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Maa Yéesu akavuurya, “Mʉ́sa joolɨ ajáa avalairirya?” ");
INSERT INTO lag_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Novo vakamʉsea, “Mʉ́sa aruma mʉʉntʉ mʉlʉme amwaandɨkɨre muki waachwe taláka, amusiite.” ");
INSERT INTO lag_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yéesu akavasea, “Mʉ́sa avaandɨkɨra ʉlairiri ʉwo sa ʉfafu wa mɨtɨma yaanyu. ");
INSERT INTO lag_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Maa kaa, keende ncholo yo kʉʉmbwa kwa weerʉ, ‘Mʉlʉʉngʉ ajáa avʉʉmba mʉʉntʉ mʉlʉme na mʉʉntʉ muki. ");
INSERT INTO lag_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sa jei, mʉʉntʉ mʉlʉme avarékaa vala íyo na taáta waavo, akava kɨɨntʉ kɨmwɨ na muki waachwe, ");
INSERT INTO lag_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","novo vavɨrɨ kʉva varɨ mʉvɨrɨ ʉmwɨ.’ Jeyyo sɨ varɨ kʉva vavɨrɨ tʉkʉ, nɨ mʉvɨrɨ ʉmwɨ. ");
INSERT INTO lag_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sa jeyyo, ˆcheene akɨlʉmanʼya Mʉlʉʉngʉ, mʉʉntʉ sɨ arɨ nanʉkʉla tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Na mpɨɨndɨ kiduudi, vakɨɨngɨra kei na nyuumbii, maa vapooji vaachwe vakamuurya rɨra isáare. ");
INSERT INTO lag_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Maa akavasea, “Mʉʉntʉ yoyoosi ˆarɨ musiita muki waachwe, maa aloole muki wɨɨngɨ, kʉva arɨ yooyeenda na muki wa mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na muki ˆarɨ musiita mʉlʉme waachwe, maa aloolwe nɨ mʉlʉme wɨɨngɨ kʉva arɨ yooyeenda na mʉlʉme wa mʉʉntʉ.” ");
INSERT INTO lag_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aho, vaantʉ vakaanda mʉretera vasinga vaduudi sa avatalarye. Maa kaa, vapooji vaachwe vakavaamirirya. ");
INSERT INTO lag_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yéesu ˆakoone jeyyo, akakalala, maa akavasea, “Reki kʉvakɨtɨra vasinga vaduudi, reki vʉʉje, sa Ʉtemi wa Mʉlʉʉngʉ nɨ sa vaantʉ ˆvarɨ ja vasinga. ");
INSERT INTO lag_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kɨmaarɨ noovawyɨɨra, mʉʉntʉ ˆarɨ dɨɨra mʉrekera Mʉlʉʉngʉ amʉlongorɨre ja musinga muduudi, sɨ arɨ kɨɨngɨra vii kaa tʉkʉ, Ʉtemi wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hara, maa akavakwaatɨrɨra, akavavɨkɨra mɨkono, kʉnʉ yoovatalarya. ");
INSERT INTO lag_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yéesu akakwaata njɨra, mpɨɨndɨ ˆajáa njirii, mʉʉntʉ ʉmwɨ akamʉkɨbɨrɨra, akachwaama mbere yaachwe, maa akamuurya, “Mukiindya mʉʉja! Che ndɨrɨ bweeyya sa mpokere nkaasʉ ya sikʉ ˆjisiina ʉhero?” ");
INSERT INTO lag_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yéesu akamʉsea, “Sa che wookʉʉnyanɨrɨra mʉʉja? Kusiina mʉʉja tʉkʉ, mʉʉja nɨ Mʉlʉʉngʉ yeemweene vii. ");
INSERT INTO lag_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wamányire ndairiri jaachwe wʉʉ? Karɨ wʉʉ́laa tʉkʉ, karɨ ʉyéendaa na muki wa mʉʉntʉ tʉkʉ, karɨ wiívaa tʉkʉ, kʉlongowererya mʉʉntʉ tʉkʉ, kwiiva kwa ʉkwaata tʉkʉ, baa kei ʉvanyemye vala íyo na taáta waanyu.” ");
INSERT INTO lag_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Maa akamʉsea, “Mukiindya, aya yoosi nayakwaatya keende usinga waanɨ.” ");
INSERT INTO lag_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yéesu akamʉlaanga, akamweenda, maa akamʉsea, “Usiina kɨɨntʉ kɨmwɨ vii. Tamanya ʉkavae iyoombe máari jaako joosi vʉʉ, na mpía ˆngʼeene ʉrɨ turya ʉvaheere vakɨva, aho kʉva ʉrɨ na máari ya kɨkomi ya mberii kurumwii, maa de wuuntuube.” ");
INSERT INTO lag_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ˆAkateere jeyyo, akiirya mʉtɨma, maa akalooka, sa nɨ musúngaati maatʉkʉ vii ajáa. ");
INSERT INTO lag_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yéesu akalaanga kʉnʉ na kʉnʉ, maa akavasea vapooji vaachwe, “Kʉva viri vyafafa maatʉkʉ vii, kwa vasúngaati kɨɨngɨra Ʉtemii wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Hara, maa vapooji vakatʉlʉvala sa yara masáare yaachwe, maa kaa, Yéesu akavasea, “Vanavaanɨ, kwɨɨngɨra na Ʉtemii wa Mʉlʉʉngʉ kʉva viri vyafafa maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nɨ vyaangʉ ngamɨ́a kʉtweera na ihengerii ra sinkeni, kʉlookya musúngaati kɨɨngɨra na Ʉtemii wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Vapooji vaachwe vakatʉlʉvalatʉlʉvaala kʉnʉ vookiiyurya, “Nɨ ani de arɨ daha lamuririwa?” ");
INSERT INTO lag_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yéesu akavatuurirya miiso, maa akavasea, “Kwa vaantʉ sɨ vidáhɨkaa tʉkʉ. Maa kaa, kwa Mʉlʉʉngʉ sɨ viri jeyyo tʉkʉ. Sa viintʉ vyoosi vyadáhɨkaa kwa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peéteri akaanda mʉsea, “Laanga! Suusu tareka kɨra kɨɨntʉ tʉkakutuuba.” ");
INSERT INTO lag_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yéesu akavasea, “Kɨmaarɨ noovawyɨɨra, kɨra mʉʉntʉ ˆareka nyuumba, vandʉʉ vaachwe, marʉʉmbʉ yaachwe, vaanaavo, taáta na íyo, au baa na vasinga na mawʉnda sa nɨɨnɨ na sa Masáare Maaja, ");
INSERT INTO lag_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hokera arɨ mara igana rɨmwɨ (100) kʉlookya mpɨɨndɨ iji, nyuumba, vandʉʉ, vaanaavo, marʉʉmbʉ, vasinga, mawʉnda au baa na uturikiri, na kei weerʉ ˆyookʉʉja, hokera arɨ nkaasʉ ya sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Maa kaa, vara va ncholo veera varɨ mukirii, na vara va mukirii kʉva varɨ va ncholo.” ");
INSERT INTO lag_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mpɨɨndɨ ˆvajáa njirii voodoma na Yerusaléemu, Yéesu ajáa avalóngorɨɨre vapooji vaachwe, novo vajáa vakwáatirwe nɨ woowa, na vaantʉ vara ˆvamutuubáa, voofáa. Yéesu akavasʉmʉla kei vapooji vaachwe ikimi na vavɨrɨ na ivarwii, maa akavawyɨɨra yara ˆyarɨ mʉfʉmɨra. ");
INSERT INTO lag_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Teereri! Haaha nɨ doma tiise na Yerusaléemu, ʉko, Mwaana wa Mʉʉntʉ vɨɨkwa arɨ mɨkonwii ya vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro, novo lʉʉsa varɨ irya akwye na mʉvɨɨka varɨ mɨkonwii ya vaantʉ sɨ ˆvarɨ Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Novo mʉhenchʉla varɨ, mʉchwɨɨra varɨ matɨ noo mʉvaa na mɨjeléedi na mʉʉlaa varɨ, maa kaa, sikʉ ya katatʉ fʉfʉlwa arɨ.” ");
INSERT INTO lag_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hara, Yaakúupu na Yooháani vala sha Sebedáayo, vakɨɨta kʉrɨ Yéesu, maa vakamʉsea, “Mukiindya! Toosaaka ʉtʉtʉmamɨre kɨɨntʉ chochoosi ˆtʉrɨ loomba.” ");
INSERT INTO lag_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Maa Yéesu akavuurya, “Che moosaaka nɨvatʉmamɨre?” ");
INSERT INTO lag_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Maa vakamʉsea, “Mpɨɨndɨ ˆʉrɨ kʉva mʉtemi wa vaantʉ voosi, tooloomba twiikale ʉmwɨ mʉkono waako wa kʉlʉme, na wɨɨngɨ mʉkono waako wa kʉmooso nkongojimii kwaako.” ");
INSERT INTO lag_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Maa Yéesu akavasea, “Sɨ mootaanga ˆcheene mooloomba tʉkʉ. De daha mʉrɨ kʉnyweera ndʉvo ya uturikiri ˆngʼeene ndɨrɨ nyweera au kʉbatisiwa ʉbatíiso ˆmweene ndɨrɨ batisiwa wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Maa vakamʉsea, “Daha tʉrɨ.” Yéesu akavasea, “Ndʉvo ˆngʼeene ndɨrɨ kɨɨnyweera, kɨmaarɨ kɨɨnyweera mʉrɨ, baa na ʉbatíiso ˆmweene ndɨrɨ batisiwa, batisiwa mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Maa kaa, ani arɨ kiikala mʉkono waanɨ wa kʉlʉme au wa kʉmooso, sɨ mʉrɨmo waanɨ kʉvaheera tʉkʉ, sa nkalo ijo, heewa varɨ ˆveene viimiriwa neeja nɨ Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Vara vapooji vɨɨngɨ ikimi ˆvakateere jeyyo, maa vakavakalarɨra vala Yaakúupu na Yooháani. ");
INSERT INTO lag_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hara, maa Yéesu akavaanɨrɨra vapooji vaachwe voosi, akavasea, “Mʉmányire, vatemi va vaantʉ sɨ ˆvarɨ Vayahúudi valáɨraa vatɨɨte wiimiriri mweeri ya vaantʉ na ngururu, na vakʉ́ʉ́lʉ vaavo, valáɨraa vatɨɨte wiimiriri mweeri yaavo. ");
INSERT INTO lag_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kʉrɨ nyuunyu sɨ noosaaka ɨve jeyyo tʉkʉ. Kɨrɨ vyoova jeyyo, ʉra ˆyoosaaka ave mʉkʉ́ʉ́lʉ waanyu, nɨ mpaka ave mʉtʉmami waanyu. ");
INSERT INTO lag_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na mʉʉntʉ yoyoosi ˆyoosaaka kʉva wa ncholo, nɨ mpaka ave mʉtʉ́mwa wa voosi. ");
INSERT INTO lag_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sa baa Mwaana wa Mʉʉntʉ, sɨ ʉʉja jo tʉmamɨrwa tʉkʉ. Kɨrɨ vyoova jeyyo, ʉʉja sa jɨ avatʉmamɨre vaantʉ, kei atoole nkaasʉ yaachwe kʉva ununuuli sa vaantʉ ˆvarɨ foo.” ");
INSERT INTO lag_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aho, vakafika múuji wa Yerɨ́ɨko. Mpɨɨndɨ Yéesu, vapooji vaachwe na ɨra mpuka nkʉʉlʉ ya vaantʉ ˆvalookáa múujii, vakamʉshaana mʉhoku ˆasewáa Batimáayo. Yeeye nɨ sha Timáayo ajáa. Na ajáa iíkyɨɨre mbarɨmbarɨ ya njɨra yooloomba. ");
INSERT INTO lag_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ˆAkateere Yéesu wa Nasaréeti yoolooka na aho, akaanda tʉla isóso yoosea, “Ee Sha Daúdi, naanga na riiso ra wʉʉja!” ");
INSERT INTO lag_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vaantʉ ˆvarɨ foo vakamwaamirirya sa akirinye. Maa kaa, yeeye akadoomererya tʉlatʉʉla isóso, yoosea, “Ee Sha Daúdi, naanga na riiso ra wʉʉja Aaɨ!” ");
INSERT INTO lag_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yéesu akɨɨma, maa akavasea, “Hoonɨ mwaaniriri.” Vakamwaanɨrɨra, voosea, “Hoonɨ ifafirirye, wiiheere mʉtɨma, yookwaanɨrɨra.” ");
INSERT INTO lag_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Akafweita lweénda lwaachwe na ivarwii, akafɨrɨra, maa akadoma na kʉrɨ Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yéesu akamuurya, “Che woosaaka nɨkʉbweeyyiirye?” Maa akasea, “Mukiindya, noosaaka noone.” ");
INSERT INTO lag_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yéesu akamʉsea, “Tamanya, kuruma kwaako noo kwakʉhóniirye.” Hahara, akoona, maa akamutuuba Yéesu na ɨra njɨra ˆadomáa. ");
INSERT INTO lag_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yéesu na vapooji vaachwe ˆvakasengerere fika Yerusaléemu, vakafika maturii ya Besifáage na Besanía, Luulwii lwa Mɨseitúuni. Hara, maa Yéesu akavatʉma vapooji vaachwe vavɨrɨ, ");
INSERT INTO lag_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akavasea, “Tamanyi fʉʉrʉ ituri ˆrɨrɨ aho mbere yaanyu, na kati ˆmookɨɨngɨra vii, koona mʉrɨ mwaana wa ndákwi sɨ ˆanavereka mʉʉntʉ, achúungirwe. Muchunguli, maa mʉmʉreete na aha. ");
INSERT INTO lag_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kaanɨ mʉʉntʉ avuúriirye, ‘Sa che moochʉngʉla mwaana wa ndákwi?’ mʉkamʉsea, ‘Mweenevyoosi yoomʉsaaka, mʉhɨndʉla arɨ haaha vii.’” ");
INSERT INTO lag_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hara, maa vakadoma vakamʉshaana mwaana wa ndákwi achúungirwe mbarɨmbarɨ ya njɨra, mutiryaangwii. Mpɨɨndɨ ˆvamʉchʉngʉláa, ");
INSERT INTO lag_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vaantʉ ˆveene vajáa viímire aho, vakavuurya, “Sa che moomʉchʉngʉla mwaana wa ndákwi?” ");
INSERT INTO lag_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Maa vakuuyirya ja ˆvyeene Yéesu ajáa avaséire. Vara vaantʉ, maa vakavarekera vamʉsʉmʉle. ");
INSERT INTO lag_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Vakamʉtwaarɨra Yéesu ʉwo mwaana wa ndákwi, vakaala ɨngo jaavo moongwii, maa Yéesu akaambʉka. ");
INSERT INTO lag_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Vaantʉ ˆvarɨ foo vakaala ɨngo jaavo njirii na vaangɨ vakaala matáampi ya mɨtɨ ˆvawúnire mawundii, voomʉnyemya Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vaantʉ vara ˆvatuubáa na vara ˆvajáa valóngwɨɨre, vaváa siriri, voosea, “Adʉʉmbwe Mweenevyoosi! Atalariwa yeeye ˆyookʉʉja kwa irina ra Ijʉva. ");
INSERT INTO lag_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Watalariwa ʉtemi ˆwookʉʉja ja wa taáta wiitʉ Daúdi. Kʉdʉʉmbwe kurumu mweerimweeri.” ");
INSERT INTO lag_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yéesu akɨɨngɨra na Yerusaléemu, akawoloka fʉʉrʉ Kaayii Njija ya Ijʉva, maa akɨɨta lorera kɨra kɨɨntʉ. Maa kaa, sa viintʉ kʉjáa kwaándire kwiira, akadoma na Besanía hamwɨ na vapooji vaachwe ikimi na vavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lomʉtóondo yaachwe mpɨɨndɨ ˆvalookáa fuma Besanía, Yéesu akava aávirwe nɨ njala. ");
INSERT INTO lag_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Maa akoona mʉsaambu wa deedadeeda, akɨɨta laangɨra koonɨ arɨ turya saambu. ˆAkafike, sɨ oona saambu baa ɨmwɨ vii tʉkʉ, akashaana masaambɨ vii, sa sɨ jijáa mpɨɨndɨ ja saambu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hara, maa akʉʉsea ʉra mʉsaambu, “Kwaandɨra isikʉ mʉʉntʉ yoyoosi sɨ ˆakariire saambu yaako vii kaa tʉkʉ!” Na vapooji vaachwe vateeráa ayo masáare. ");
INSERT INTO lag_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vakafika Yerusaléemu. Yéesu akɨɨngɨra Kaayii Njija, akaanda vakibirya vaantʉ ˆveene vaváa iyoombe no wʉla ʉko waámii. Akakʉndʉla méesa ja vaantʉ ˆvawʉlanáa mpía na akakʉndʉla machuumbi ya vaantʉ ˆvaváa iyoombe njɨva. ");
INSERT INTO lag_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kei, avakaanʼyáa vaantʉ kusiina kʉkwaatɨra baa na heehi ya waama wa Kaaya Njija na viintʉ vyo vaa iyoombe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ʉvariyulii waachwe akavasea, “Eri, Masáare ˆYarɨ Mpeho sɨ yalʉʉsa yoosea, ‘Nyuumba yaanɨ kaanɨrɨrwa ɨrɨ nyuumba yo mʉloomba Mʉlʉʉngʉ sa vaantʉ va ɨsɨ joosi tʉkʉ wʉʉ?’ Maa kaa, nyuunyu mwɨɨválandwɨɨre ɨkava ‘mpaanga ya viívi’?” ");
INSERT INTO lag_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro, vajáa vateera ˆmeene Yéesu ajáa alúusire. Maa vakaanda saakɨra nkalo yo mʉʉlaa. Vamoofáa, sa vaantʉ ˆvatʉlʉvariwáa nɨ ʉvariyuli waachwe, na vara ˆvayeendáa masáare yaachwe, vavijáa foo. ");
INSERT INTO lag_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ˆƗkafike niiwʉlo, Yéesu na vapooji vakafuma Yerusaléemu vakadoma na Besanía. ");
INSERT INTO lag_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lomʉtóondo namʉtóondo mpɨɨndɨ ˆvalookáa na hara, vakoona ʉra mʉsaambu washáawukire fuma miririi. ");
INSERT INTO lag_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peéteri akʉʉkʉmbʉkɨra ʉra mʉsaambu, maa akamʉsea Yéesu, “Mukiindya! Laanga ʉra mʉsaambu ˆwaarɨ wuujumiré, washáawukire!” ");
INSERT INTO lag_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Maa Yéesu akavasea, “Murumi Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kɨmaarɨ noovawyɨɨra, koonɨ mʉʉntʉ aséire lʉʉlʉ ʉlʉ lwiisunke, lʉkafweitɨrwe irivii, na yeeye asiina kivundu mutimii waachwe, kɨmaarɨ kaa Mʉlʉʉngʉ mʉtʉmamɨra arɨ masáare ayo. ");
INSERT INTO lag_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sa jeyyo, nɨ kʉvawyɨɨra niise, isáare roroosi ˆmʉrɨ loomba mpɨɨndɨ ˆmoomʉloomba Mʉlʉʉngʉ, haaha murume mwarɨpátire isáare ɨro mitimii yaanyu, noro kʉva rɨrɨ raanyu. ");
INSERT INTO lag_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mpɨɨndɨ ˆmʉrɨ kɨɨma sa mʉmʉloombe Mʉlʉʉngʉ, koonɨ ʉrɨ na kɨɨntʉ mutimii kwa mʉʉntʉ wɨɨngɨ, mʉsei ʉwo mʉʉntʉ, ‘Ʉvɨ waako wasírire,’ sa Taáta waanyu wa kurumwii, avasee baa nyuunyu, ‘Ʉvɨ waanyu wasírire.’  ");
INSERT INTO lag_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Maa kaa, koonɨ sɨ moovasea viivaanyu, ‘Ʉvɨ wasírire,’ baa Taáta waanyu wa kurumwii sɨ arɨ sea, ‘Ʉvɨ waanyu wasírire tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kei vakafika Yerusaléemu. Mpɨɨndɨ Yéesu ˆayeendayeendáa waámii wa Kaaya Njija, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, vakiindya va Miiro na vawosi vakʉʉja na kʉrɨ Yéesu, ");
INSERT INTO lag_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","maa vakamuurya, “Nɨ kwa wiimiriri ʉrɨkwɨ wootʉmama aya masáare? Nɨ ani akʉheera wiimiriri ʉhʉ?” ");
INSERT INTO lag_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Maa akavasea, “Kuvuurya ndɨrɨ kɨɨntʉ kɨmwɨ. Koonɨ muúyiirye, naanɨ vawyɨɨra ndɨrɨ nɨ kwa wiimiriri ʉrɨkwɨ ˆnootʉmama aya masáare. ");
INSERT INTO lag_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Eri, ʉbatíiso wa Yooháani nɨ kurumwii wafuma bakʉ kwa vaantʉ? Ngwyiiri!” ");
INSERT INTO lag_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Maa vakalʉʉsɨkanʼya voovo kwa voovo voosea, “Koonɨ taséire, ‘Wafuma kurumwii,’ kuurya arɨ, ‘Sa che de sɨ mwamuruma?’ ");
INSERT INTO lag_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Maa kaa, koonɨ taséire, ‘Wafuma kwa vaantʉ…’” Vakoofa sa vaantʉ vajáa vamuruma Yooháani Mʉbatisáaji nɨ mʉláali na mʉtwe wa Ijʉva wa kɨmáárɨ. ");
INSERT INTO lag_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Maa vakasea, “Iyaʉ, sɨ tamányire tʉkʉ.” Ne akavasea, “Naanɨ sɨ ndɨrɨ vawyɨɨra nɨ kwa wiimiriri ʉrɨkwɨ nootʉmama aya tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hara, maa Yéesu akaanda vawyɨɨra vara vakʉ́ʉ́lʉ símo iji, akavasea, “Mʉʉntʉ ʉmwɨ ajáa arɨma iwʉnda ra mɨsabíibu. Akariingirirya lʉkaande iwʉnda vʉʉ, akasiimba iduundu ro fʉʉnchɨra sabíibu so tengenesera diváai, akajeenga kɨvaanda kɨlɨɨhɨ cho rɨndɨrɨra, maa akakojya ɨro iwʉnda raachwe kwa varimi. Hara, maa akakera njɨra. ");
INSERT INTO lag_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mpɨɨndɨ jo chwa ˆjikafike, akamʉtʉma mʉtʉ́mwa waachwe, akasʉmʉle haantʉ haachwe ha sabíibu ˆngʼeene vachwíire. ");
INSERT INTO lag_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ʉra mʉtʉ́mwa ˆakafike, vara vaantʉ vakamʉkwaata, vakamʉvaa, maa vakamukibirya na mɨkono mɨtʉhʉ. ");
INSERT INTO lag_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mweeneiwʉnda akatʉma mʉtʉ́mwa wɨɨngɨ kei, ʉhʉ ne vakamʉvaa mutwii, baa kei vakamʉbweeyyirya masáare ya soni. ");
INSERT INTO lag_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mweeneiwʉnda akatʉma mʉtʉ́mwa wɨɨngɨ, ʉhʉ re, vakamʉʉlaa. Atʉma vɨɨngɨ ˆvarɨ foo, vɨɨngɨ vavaváa na vɨɨngɨ vavʉʉláa. ");
INSERT INTO lag_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ʉhero waachwe, mweeneiwʉnda ajáa achɨ́hɨɨre na mʉʉntʉ ʉmwɨ vii wo tʉma, na ʉhʉ nɨ mwaana waachwe ˆamweendamweenda, akamʉtʉma yookiisea, ‘Kʉmʉnyemya varɨ mwaana waanɨ!’ ");
INSERT INTO lag_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ˆAkafike, maa vara ˆvakojiwa iwʉnda vakiiwyɨɨra voosea, ‘Ʉhʉ noo mʉpaari wa ɨrɨ iwʉnda. Hendi tʉmʉʉlae, maa ʉpaari waachwe ʉve wiiswi.’ ");
INSERT INTO lag_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hara, vakamʉkwaata, vakamʉʉlaa, maa vakɨɨta mʉwʉmɨra weerwii ya lʉkaande lwa iwʉnda ra mɨsabíibu.” ");
INSERT INTO lag_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Maa Yéesu akavasea, “Joolɨ mookiisea mweeneiwʉnda lo ˆakabweeyyiirye? Kʉʉja arɨ, vʉʉlaa arɨ vʉʉ avo ˆavakojya, maa avakojye varimi vɨɨngɨ iwʉnda raachwe ra sabíibu. ");
INSERT INTO lag_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Amwɨ moobweeyya ja sɨ mʉnasoma aya Masáare ˆYarɨ Mpeho ja ˆvyeene yalʉʉsa? ‘Iwye ˆrasiitwa nɨ vajeengi, ravɨ́ɨre iwye ikʉʉlʉ ra kichurii. ");
INSERT INTO lag_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ijʉva atʉ́mamire isáare ɨrɨ, noro rabooha, na nɨ iyeni maatʉkʉ vii miiswii yiiswi.’” ");
INSERT INTO lag_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hara, vakʉ́ʉ́lʉ va Vayahúudi vasaakáa vamʉkwaate Yéesu sa vajáa vatáangire lusímo ʉlʉ nɨ voovo lʉjáa lwavalúusire. Maa kaa, voofáa ɨra mpuka ya vaantʉ. Hara vakalamʉla vamʉreke, maa vakalooka. ");
INSERT INTO lag_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mpɨɨndɨ kiduudi, vara vakʉ́ʉ́lʉ vakavatʉma Mafarisáayo na vaantʉ ˆvafúmire kwa mʉtemi Heróode, sa vamʉtee Yéesu, de vamʉkwaate sa masáare yaachwe. ");
INSERT INTO lag_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Vakamʉʉjɨra, vakamʉsea, “Mukiindya! Takʉmányire weewe ʉrɨ mʉʉntʉ ˆʉlʉ́ʉsaa kɨmáárɨ, baa kei sɨ woófaa ʉkʉ́ʉ́lʉ wa mʉʉntʉ tʉkʉ, sa weewe sɨ ʉláangaa buuwo tʉkʉ. Kɨrɨ vyoova jeyyo, ʉváriyʉlaa njɨra ya kɨmáárɨ ya Mʉlʉʉngʉ. Eri, ndairiri jaruma mʉʉntʉ arɨhe kóodi kwa Kaisáari mʉtawáala wa Rúumi bakʉ tʉkʉ? ");
INSERT INTO lag_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Joolɨ woosea, tʉrɨhe bakʉ tʉkʉ?” Maa kaa, Yéesu akataanga ʉkweembi waavo, maa akavasea, “Amwɨ mooyera kʉʉntea? Hoonɨ ndeteri mpía ya dináari ˆngʼeene mʉrɨháa kóodi nɨɨyone.” ");
INSERT INTO lag_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ˆVakareete, maa akavuurya, “Buuwo na lʉtalo ʉlʉ nɨ lwa ani?” Vakamʉsea, “Nɨ lwa Kaisáari.” ");
INSERT INTO lag_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Maa Yéesu akavasea, “Viintʉ vya Kaisáari, mʉheeri Kaisáari na viintʉ vya Mʉlʉʉngʉ, mʉheeri Mʉlʉʉngʉ.” Maa isáare ɨrɨ rɨkavahwaalarya maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hara, vakʉʉja Masadukáayo, vaantʉ ˆveene vaséaa kusiina kʉfʉfʉka kaanɨ mʉʉntʉ akwíire tʉkʉ. Vakamʉsea, ");
INSERT INTO lag_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mukiindya! Mʉ́sa ajáa atwaandɨkɨra Miiro Masáarii ˆYarɨ Mpeho akatʉsea, ‘Koonɨ mʉʉntʉ akwíire baa kʉva na vaana tʉkʉ, mwaanaavo yoosaakwa amʉpaale ʉwo mʉlala sa amʉvyaarɨre vaana mwaanaavo ʉra ˆaakwya.’ ");
INSERT INTO lag_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Haaha, kʉjáa kwatɨɨte vaana valʉme mufungatɨ va mʉʉntʉ ʉmwɨ. Ʉra wa ncholo ˆakaloole, akawulala baa kʉva na mwaana tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wa kavɨrɨ akamʉpaala mʉlala ˆarékirwe nɨ mwaanaavo, ne akawulala baa kʉva na mwaana tʉkʉ. Wa katatʉ ne vikava vivira. ");
INSERT INTO lag_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Voosi mufungatɨ vakawulala baa reka vaana tʉkʉ, ʉhero waachwe, mʉlala ne akawulala. ");
INSERT INTO lag_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Haaha tʉwyɨɨre, sikʉ ya ʉfʉfʉ́ʉko ʉhʉ mwaana muki nɨ muki wa ani arɨ kʉva? Sa voosi mufungatɨ vajáa vamʉloola.” ");
INSERT INTO lag_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Maa akuuyirya, yoosea, “Mʉhóniirye sa viintʉ sɨ mʉyamányire Masáare ˆYarɨ Mpeho na ngururu ja Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vaantʉ ˆvawulala haantʉ ˆvakafufukire, kusiina kʉloola no loolwa tʉkʉ, voosi kʉva varɨ ja mirimʉ miija ya kurumwii. ");
INSERT INTO lag_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Maa kaa, kwa ʉfʉfʉ́ʉko wa vaantʉ ˆvaakwya, amwɨ mookiibweeyya ja sɨ mʉnasoma kɨtáabu cha Mʉ́sa, ˆcheene chalʉʉsa ˆvyeene Mʉlʉʉngʉ alʉʉsɨkáa na Mʉ́sa fuma ituundwii ˆreene rakoreráa mooto? Mʉlʉʉngʉ amʉsea, ‘Nɨɨnɨ nɨ Mʉlʉʉngʉ wa Aburaháamu, Mʉlʉʉngʉ wa Isaka na Mʉlʉʉngʉ wa Yaakúupu.’ ");
INSERT INTO lag_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yeeye sɨ Mʉlʉʉngʉ wa vaantʉ ˆvaakwya tʉkʉ, yeeye nɨ Mʉlʉʉngʉ wa ˆvarɨ nkaasʉ. Kati ˆmoosea kusiina ʉfʉfʉ́ʉko tʉkʉ, moohonʼya maatʉkʉ vii.” ");
INSERT INTO lag_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ʉmwɨ wa vakiindya va Miiro ajáa amwaarɨ hara, yooteerera ˆvyeene Yéesu na Masadukáayo viirutáa ndihi. ˆAkateere Yéesu uúyiirye viija, maa akamuurya Yéesu, “Eri, nɨ ʉlairiri ʉrɨkwɨ noo mʉkʉʉlʉ kʉlookya ndairiri joosi?” ");
INSERT INTO lag_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yéesu akamʉsea, “Ʉlairiri mʉkʉʉlʉ kʉlookya joosi noo ʉhʉ, ‘Ee Isiraéeli teeri, Ijʉva Mʉlʉʉngʉ wiitʉ, noo Mʉlʉʉngʉ ʉmwɨ vii. ");
INSERT INTO lag_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ʉmweende Ijʉva Mʉlʉʉngʉ waako na mʉtɨma waako woosi, na nkaasʉ yaako yoosi, na mɨryʉʉngʉ yaako yoosi, na ngururu jaako joosi, noo kʉsea, kɨra kɨɨntʉ ˆʉrɨ.’ ");
INSERT INTO lag_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na wa kavɨrɨ noo ʉhʉ, ‘Ʉmweende mwiiwaako ja ˆvyeene wiiyenda mweeneevyo.’ Kusiina ʉlairiri wɨɨngɨ ʉrɨ mʉkʉʉlʉ kʉlookya ndairiri iji tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ʉra mukiindya wa Miiro ya Mʉlʉʉngʉ akamʉsea, “Mukiindya, wuúyiirye viija, ‘Ijʉva nɨ ʉmwɨ vii na kusiina wɨɨngɨ tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na kʉmweenda Ijʉva na mʉtɨma woosi na mɨryʉʉngʉ yoosi na ngururu joosi, na mʉʉntʉ kʉmweenda mwiiwaachwe ja ˆvyeene iiyenda yeemweene, nɨ viija kwa Ijʉva kʉlookya kʉtoola mpóryo jo chɨmɨka joosi.” ");
INSERT INTO lag_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yéesu ˆakateere ʉra mʉʉntʉ uúyiirye na tooti, maa akamʉsea, “Aaɨ! Weewe sɨ ʉrɨ kʉlɨ na Ʉtemi wa Mʉlʉʉngʉ tʉkʉ.” Keende hara kusiina mʉʉntʉ ˆayera muurya kɨɨntʉ chɨɨngɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mpɨɨndɨ Yéesu ˆavariyʉláa waámii wa Kaaya Njija ya Ijʉva, akuurya, “Sa che vakiindya va Miiro vaséaa Masía nɨ Mwaana wa Daúdi? ");
INSERT INTO lag_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daúdi mweeneevyo kwa lʉvɨro lwa Mʉtɨma Mʉʉja, ajáa asea, ‘Ijʉva ajáa amʉsea Mweenevyoosi waanɨ, “Ikala mʉkono waanɨ wa kʉlʉme, fʉʉrʉ nɨvavɨɨke vavɨ vaako, vave ɨsɨ ya majeo yaako.”’ ");
INSERT INTO lag_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daúdi mweeneevyo yoomwaanɨrɨra ‘Mweenevyoosi’ waachwe, ha de joolɨ Masía arɨ kʉva Mwaana wa Daúdi?” Mpuka nkʉʉlʉ ɨkamʉteerera na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mpɨɨndɨ ˆavavariyʉrɨráa, akavasea, “Valaangi neeja vakiindya va Miiro, veenda kiivɨkɨra nkáancho ndɨɨhɨ na veenda luumbiwa ko nyemiwa sóokwii. ");
INSERT INTO lag_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Baa kei, veenda kiikala machuumbi ya mbere ya vakʉ́ʉ́lʉ masinagóogii na haantʉ ha nyemi ngovii. ");
INSERT INTO lag_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Vanyáhɨraa nyuumba ja valala, na ʉkweembi vamʉlóombaa Mʉlʉʉngʉ vilɨɨhɨlɨɨhɨ. Heewa varɨ irya ikʉʉlʉ.” ");
INSERT INTO lag_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Aho, Yéesu akiikala heehi na isandúku ro vɨkɨra mpóryo ja Kaaya Njija, akava yoolaanga ˆvyeene vaantʉ vootoola mpóryo. Vasúngaati ˆvarɨ foo vakavɨkɨra mpía ˆjiri foo. ");
INSERT INTO lag_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Hara, maa akʉʉja mʉlala ʉmwɨ akatoola fipóocho fivɨrɨ fiduudi. ");
INSERT INTO lag_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yéesu, akavaanɨrɨra vapooji vaachwe, akavasea, “Kɨmaarɨ noovawyɨɨra, ʉhʉ mʉlala mʉkɨva atwɨ́ɨre mpóryo nkʉʉlʉ kʉlookya vaantʉ voosi vʉʉ! ");
INSERT INTO lag_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ava vaangɨ vatwɨ́ɨre máari ˆɨlóokerɨɨre. Maa kaa, noovawyɨɨra ʉhʉ mʉlala na ʉkɨva waachwe atwɨ́ɨre choosi ˆatɨɨte.” ");
INSERT INTO lag_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na mpɨɨndɨ Yéesu ˆafumáa Kaayii Njija ya Ijʉva, ʉmwɨ wa vapooji vaachwe akamʉsea, “Mukiindya! Laanga, majuumba aya viintʉ ˆyabooha na mawye yaachwe viintʉ ˆyakʉla.” ");
INSERT INTO lag_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yéesu akamʉsea, “Koona wiise majuumba yoosi aya wʉʉ? Kusiina iwye ˆrɨkachɨ́hɨɨre mweeri ya iwye rɨɨngɨ tʉkʉ, yoosi luu girimʉlwa yarɨ vʉʉ.” ");
INSERT INTO lag_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mpɨɨndɨ kiduudi Yéesu ajáa adoma fʉʉrʉ Luulwii lwa Mɨseitúuni. Akiikala kʉnʉ aléyyiirye miiso na Kaayii Njija. Vapooji vaachwe, Peéteri, Yaakúupu, Yooháani na Anderéa vakamuurya mpoolɨ, ");
INSERT INTO lag_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Aaɨ tʉwyɨɨre, masáare aya nɨ naadi ˆyarɨ fʉmɨra? Na nɨ isháara che ˆtʉrɨ koona de tʉtaange masáare aya yaséngerɨɨre?” ");
INSERT INTO lag_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Maa akavasea, “Laangi neeja, karɨ mʉʉntʉ avakoovere tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sa vaantʉ ˆvarɨ foo kʉʉja varɨ kwa irina raanɨ, kɨra mʉʉntʉ yoosea, ‘Nɨɨnɨ noo yeeye,’ novo vakoovera varɨ vaantʉ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ˆMʉkateɨɨre masáare ya nkoondo na fweefwee ja nkoondo, karɨ moófaa tʉkʉ. Masáare aya nɨ mpaka yafʉmɨre, maa kaa, ʉra ʉhero ʉkaarɨ. ");
INSERT INTO lag_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɨsɨ kiinʉla ɨrɨ nkoondo na ɨsɨ yɨɨngɨ, na ʉtemi kiinʉla ʉrɨ nkoondo na ʉtemi wɨɨngɨ. Kʉva kʉrɨ na vitiíntima haantʉ haantʉ, baa kei, kʉva kʉrɨ na njala ya imalo. Ɨyo noo ja ncholo vii ya ʉsʉʉngʉ wa makata ˆvyeene waándaa. ");
INSERT INTO lag_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Maa kaa, nyuunyu laangi neeja, twaalwa mweende na balásii na lamʉrɨrwa mweende mʉvawe masinagóogii. Baa kei, twaalwa mweende kwa magávana na kwa vatemi sa nɨɨnɨ, aho, de mʉdahe variyʉla vataange kɨmaarɨ. ");
INSERT INTO lag_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Maa kaa, de ʉra ʉhero ufike, nɨ mpaka ta Masáare Maaja yavariyʉlwe ɨsɨ joosi vʉʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na ˆmʉrɨ kwaatwa no twaalwa na balásii, karɨ mwiítweetyaa che ˆmʉrɨ lʉʉsa tʉkʉ. Luusi isáare roroosi ˆrɨrɨ vʉʉjɨra mpɨɨndɨ jiijo, sa masáare ˆmʉrɨ lʉʉsa sɨ yaanyu tʉkʉ, nɨ ya Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mʉʉntʉ mʉvarindʉka arɨ mwaanaavo sa ʉʉlawe, taáta mʉvarindʉka arɨ mwaana waachwe sa ʉʉlawe. Vaana novo vavarindʉka varɨ vala íyo na taáta waavo sa vʉʉlawe. ");
INSERT INTO lag_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sʉʉlwa mʉrɨ nɨ vaantʉ voosi sa irina raanɨ. Maa kaa, ˆmweene arɨ yimirirya fʉʉrʉ ʉhero, ʉwo noo arɨ lamuririwa. ");
INSERT INTO lag_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Haantʉ ˆmʉkɨɨ́ne, ‘ʉnyanyi ˆʉréetaa ʉsaambʉ ˆwavɨɨhavɨɨha’ wiímire Haantʉ Haaja sɨ ˆharɨ haachwe haachwe, mʉʉntʉ yoosoma ataange, vara ˆvarɨ ɨsɨ ya Yudéea vatɨjɨre njuulwii. ");
INSERT INTO lag_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mʉʉntʉ ˆarɨ ikekeerii karɨ akiime ɨɨngɨre na nyuumbii jɨ atoole kɨɨntʉ chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ʉra ˆarɨ iwundii atɨɨje chaangʉ, karɨ ahɨndʉke na kaayii jɨ atoole nkáancho yaachwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nɨ mpolaɨ kwa vara ˆvarɨ kʉva varuto na vara ˆvɨɨndookoonkya sikʉ ijo. ");
INSERT INTO lag_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Loombi sa ɨro rɨsɨfʉmɨre mpɨɨndɨ ja mpeho tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sa sikʉ ijo, kʉva kʉrɨ na uturikiri mʉkʉʉlʉ ˆmweene sɨ ʉnafʉmɨra keende Mʉlʉʉngʉ ʉʉmba weerʉ fʉʉrʉ isikʉ, baa sɨ luu ʉkafʉmɨɨre kei vii kaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na ngaarɨ Ijʉva sɨ akéehyaa sikʉ ijo, ngaarɨ kusiina mʉʉntʉ baa ʉmwɨ ˆahona vii kaa tʉkʉ. Maa kaa, sa vaantʉ ˆveene avasaawʉla, ajikeehya sikʉ ijo. ");
INSERT INTO lag_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Na mpɨɨndɨ ijo koonɨ mʉʉntʉ yoyoosi avaséire, ‘La! Masía nʉ aha’ au ‘La, amwaarɨ kʉʉra,’ karɨ murúmaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sa fʉmɨra varɨ vala masía va ʉloongo na valáali na mʉtwe va ʉloongo, bweeyya varɨ isháara na viintʉ ˆvihwáalaryaa sa vavakoovere baa vara ˆvasaawʉlwa nɨ Ijʉva koonɨ viri dahɨka. ");
INSERT INTO lag_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Maa kaa, nyuunyu mwɨɨme neeja. Navawyɨ́ɨrɨɨre masáare kati ˆyakaarɨ fʉmɨra. ");
INSERT INTO lag_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Maa kaa, sikʉ ijo, uturikiri ʉwo ˆʉrɨ looka, ‘mwaasʉ kʉnɨkɨrɨrwa ʉrɨ na mweeri sɨ ʉrɨ fala tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nyényeeri wya jeende fuma kurumwii na ngururu ja kurumu sɨngɨsɨka jeende.’ ");
INSERT INTO lag_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na mpɨɨndɨ ijo, kɨra mʉʉntʉ kʉmoona arɨ Mwaana wa Mʉʉntʉ yookʉʉja machwii na ngururu ˆjiri foo na nkongojima. ");
INSERT INTO lag_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Maa de atʉme mirimʉ yaachwe miija jɨ ɨvasaankanʼye na ɨvareete kwaachwe ˆveene avasaawʉla, fuma mavaru yoosi ya weerʉ, fuma utulo waasɨ, fʉʉrʉ utulo wa kurumu. ");
INSERT INTO lag_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ikiindyi fuma kwa mʉsaambu. Matáampi yaachwe koonɨ yavɨ́ɨre na nchúundo na yaándire tʉrɨka, mwatáangaa mpɨɨndɨ ja irʉtɨra jaséngerɨɨre. ");
INSERT INTO lag_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jeyyo baa nyuunyu, ˆmʉrɨ koona ivi vyoosi, taangi jira mpɨɨndɨ jafíkire aha mʉryaangwii. ");
INSERT INTO lag_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kɨmaarɨ noovawyɨɨra, mbyaala ɨhɨ sɨ ɨrɨ looka tʉkʉ kende masáare aya yoosi sɨ yanafʉmɨra. ");
INSERT INTO lag_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kurumu na weerʉ looka jiri, maa kaa, masáare yaanɨ sɨ yarɨ looka vii kaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Maa kaa, kusiina ˆamányire sikʉ ɨyo baa sáa ɨyo tʉkʉ, baa mirimʉ miija ya kurumwii na Mwaana wa Mʉʉntʉ tʉkʉ, ˆmweene amányire nɨ Taáta yeemweene. ");
INSERT INTO lag_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mwɨɨme neeja na mʉndoolaanga neeja! Sɨ mʉmányire mpɨɨndɨ ijo nɨ naadi ˆjiri fika tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Valʉka viri nɨ ja mʉʉntʉ ˆyookwaata njɨra, avarékeraa vatʉ́mwa vaachwe wiimiriri, kɨra mʉʉntʉ na mʉrɨmo waachwe. Aho, maa akamʉsea mʉlangiriri wa mʉryaangwii alaange neeja. ");
INSERT INTO lag_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sa jeyyo, mwɨɨme neeja mpɨɨndɨ joosi sa sɨ mʉmányire nɨ naadi mweenenyuumba ˆarɨ hɨndʉka tʉkʉ, sa ifaanaa akahɨndʉka niiwʉlo, au nuuchikʉ, au nuuchikʉ katɨ, au namuyiingʉ, au namʉtóondo uchikʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kaanɨ avúndukiirye kʉʉja, jɨ avashaane sɨ mʉlɨ́ɨre tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na ɨkɨ ˆcheene noovawyɨɨra, nɨ vawyɨɨra niise vaantʉ voosi, mwɨɨme neeja.” ");
INSERT INTO lag_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jijáa jachɨ́hɨɨre sikʉ ivɨrɨ vii, de ɨve ngovi ya Paásika na ngovi ya mɨkáate sɨ ˆɨvɨ́kɨrwaa ʉsasɨ. Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro vasaakɨráa njɨra ya iyasi yo mʉkwaata Yéesu sa vamʉʉlae. ");
INSERT INTO lag_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Vakalamʉla, voosea, “Karɨ tʉrɨbweeyye ɨrɨ isáare mpɨɨndɨ ja ɨhɨ ngovi tʉkʉ, sa vaantʉ kʉreeta ntiribʉka.” ");
INSERT INTO lag_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mpɨɨndɨ ijo, Yéesu nɨ iturii ra Besanía ajáa, kaayii kwa Simóoni ˆmweene asewáa ˆarɨ na ʉlóónda. Na mpɨɨndɨ ˆvarijáa, mʉʉntʉ muki ʉmwɨ akɨɨngɨra aho nyuumbii ˆarɨ na chʉ́pa nduudi ya iwye ˆrasongolwa, ˆɨrɨ na makuta ˆyanyʉ́kɨraa ya iyoombe ikʉlʉkʉʉlʉ. Akiiwʉna nkiingo ɨra chʉ́pa, maa akamwɨɨtɨra Yéesu yara makuta mutwii, yoomʉnyemya. ");
INSERT INTO lag_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Vaantʉ vamwɨ vara ˆvajáa aho ˆvakoone jeyyo, vakakalala maatʉkʉ vii, vakaanda kiiwyɨɨra, “Sa che kʉbwɨɨtɨra makuta ja ayo jei? ");
INSERT INTO lag_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jangaarɨ yaváirwe iyoombe jɨtooreke mpía ja dináari magana yatatʉ (300), maa mpía ijo vaheewe vakɨva?” Maa vakamwaamirirya ʉra mʉʉntʉ muki. ");
INSERT INTO lag_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Maa kaa, Yéesu akavasea, “Mʉreki! Sa che moomujuuwa? Aantʉ́mamɨɨre vyabooha. ");
INSERT INTO lag_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Laangi! Vakɨva novo mʉrɨ mpɨɨndɨ joosi, ifaanaa mʉkavaambirirya mpɨɨndɨ yoyoosi ˆmʉrɨ keenda. Maa kaa, nɨɨnɨ sɨ ndɨrɨ kʉva na nyuunyu mpɨɨndɨ joosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ʉhʉ mʉʉntʉ muki atʉ́mamire ˆcheene adáhire. Aampákire makuta kʉʉvɨka mʉvɨrɨ waanɨ neeja so taahwa. ");
INSERT INTO lag_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kɨmaarɨ noovawyɨɨra, haantʉ hohoosi aha weerwii Masáare Maaja ˆyarɨ variyʉlwa, ɨkɨ ˆcheene akɨtʉ́mamire ʉhʉ mʉʉntʉ muki lʉʉswa kɨrɨ ja nkʉmbʉkɨra yaachwe.” ");
INSERT INTO lag_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aho, Yʉ́ʉda Isikarióoti, ʉmwɨ wa vapooji vaachwe ikimi na vavɨrɨ, akadoma noo mʉvarindʉka Yéesu kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva. ");
INSERT INTO lag_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva ˆvakateere rɨra isáare, maa vakavyeenda maatʉkʉ vii. Vakiichuunga kwaachwe kʉmʉrɨha mpía. Aho, Yʉ́ʉda akaanda saakɨra nkalo ˆyabooha sa amʉvarindʉke Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na sikʉ ya ncholo ya ngovi ya mɨkáate sɨ ˆɨvɨ́kɨrwaa ʉsasɨ, vapooji vakamuurya Yéesu, “Hai ko wookeenda tukwiimirye neeja chóorya cha Paásika?” Sikʉ ɨyo, nɨ tʉʉva ɨjáa kwa Vayahúudi kʉsɨɨnja muundi ˆɨrɨ mpeho sa Paásika. ");
INSERT INTO lag_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Maa Yéesu akavatʉma vapooji vaachwe vavɨrɨ, akavasea, “Domi na múujii Yerusaléemu, ʉko lʉmana mʉrɨ na mʉʉntʉ mʉlʉme ˆiitíikire sʉvɨya ya maaji. Mutuubi, ");
INSERT INTO lag_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","na nyuumba ˆngʼeene arɨ kɨɨngɨra, muuryi mweenekaaya, mʉkamʉsea, ‘Mukiindya yookuurya, “Hai kɨrɨ chúumba cha vayeni kʉʉntʉ ˆndɨrɨ rɨɨra chóorya cha Paásika na vapooji vaanɨ?”’ ");
INSERT INTO lag_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ʉwo mweenekaaya valaɨra arɨ chúumba kɨkʉʉlʉ ˆkɨrɨ gorófii, kwavɨɨkwa viintʉ vyoosi neeja. Imyi neeja Paásika haaho.” ");
INSERT INTO lag_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Maa reerʉ, vara vapooji vavɨrɨ vakiinʉka, vakadoma na múujii. ˆVakafike múujii, vakashaana kɨra kɨɨntʉ ja ˆvyeene Yéesu ajáa avawyɨ́ɨrɨɨre. Maa vakiimya neeja chóorya cha Paásika. ");
INSERT INTO lag_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iwʉlo ˆrɨkɨɨngɨre, Yéesu na vapooji vaachwe ikimi na vavɨrɨ vakɨɨngɨra. ");
INSERT INTO lag_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mpɨɨndɨ ˆvajáa méesii voorya, Yéesu akavasea, “Kɨmaarɨ noovawyɨɨra, ʉmwɨ waanyu kʉʉnvarindʉka arɨ.” ");
INSERT INTO lag_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vapooji vaachwe ˆvakateere jei, maa vakavisʉʉla, vakamʉsea ʉmwɨ ʉmwɨ, “Sɨ viri kʉva nɨ nɨɨnɨ tʉkʉ?” ");
INSERT INTO lag_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Maa akavasea, “Nɨ ʉmwɨ wa vapooji vaanɨ ikimi na vavɨrɨ, ˆyooriirya mʉkáate luumbwii na nɨɨnɨ aha. ");
INSERT INTO lag_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwaana wa Mʉʉntʉ nɨ mpaka atamanye no kʉʉlawa, ja ˆvyeene vyaandɨkwa Masáarii ˆYarɨ Mpeho. Maa kaa, nɨ mpolaɨ kwa mʉʉntʉ ʉra ˆarɨ mʉvarindʉka! Nɨ pwee vijáa ngaarɨ baa sɨ avyaalwa.” ");
INSERT INTO lag_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mpɨɨndɨ ˆvarijáa, Yéesu akatoola mʉkáate, akamʉdʉʉmba Mʉlʉʉngʉ, akʉʉbendʉlabendʉla, maa akavaheera vapooji vaachwe, akavasea, “Tooli, ʉhʉ nɨ mʉvɨrɨ waanɨ.” ");
INSERT INTO lag_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Maa akatoola kɨkóombe cha diváai, akamʉdʉʉmba Mʉlʉʉngʉ, akavaheera voosi vakanywa aho nduvwii. ");
INSERT INTO lag_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Maa akavawyɨɨra, yoosea, “Ɨhɨ nɨ sakami yaanɨ ya mʉháko ˆɨrɨ kiitwa sa vaantʉ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kɨmaarɨ noovawyɨɨra, luu sɨ nkanywiire kei diváai tʉkʉ, mpaka sikʉ ˆngʼeene nkɨɨnywiire ufya ʉko Ʉtemii wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ˆVakɨɨmbe lwɨɨ́mbo, vakalooka na Luulwii lwa Mɨseitúuni. ");
INSERT INTO lag_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yéesu akavasea vapooji vaachwe, “Nyuunyu voosi kʉʉndeka mʉrɨ nɨɨmweene ja ˆvyeene vyaandɨkwa Masáarii ˆYarɨ Mpeho, ‘Kʉmʉvaa ndɨrɨ muríisi, na muundi jaachwe joosi kiipasa jiri.’ ");
INSERT INTO lag_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Maa kaa, ˆndɨrɨ fʉfʉka, valongorera ndɨrɨ na ɨsɨ ya Galiláaya.” ");
INSERT INTO lag_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peéteri akamʉsea, “Baa vakʉtɨɨje voosi vʉʉ, nɨɨnɨ sɨ ndɨrɨ kʉreka tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yéesu akamʉsea, “Kɨmaarɨ kaa nookuwyɨɨra, uchikʉ wo wʉʉ, nkʉkʉlʉme sɨ ɨnavɨɨka lwa kavɨrɨ, lʉʉsa ʉrɨ sɨ waamányire tʉkʉ katatʉ.” ");
INSERT INTO lag_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Maa Peéteri akuumirirya, yoosea, “Tʉkʉ! Baa koonɨ nɨ kukwya, nkwye na weewe, nɨɨnɨ sɨ ndɨrɨ sea sɨ nakʉmányire tʉkʉ!” Baa vapooji voosi vakalʉʉsa vivira. ");
INSERT INTO lag_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Maa vakafika iwundii ra Getisemáane, Luulwii lwa Mɨseitúuni. Yéesu akavasea vapooji vaachwe, “Ikali aha mpɨɨndɨ nɨɨnɨ ˆnookoomʉloomba Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Akavasʉmʉla Peéteri, Yaakúupu na Yooháani hamwɨ ne. Aho, mʉtɨma waachwe ʉkafɨrɨra, kʉnʉ yookiiteera ʉsʉʉngʉ mʉnʉmʉʉnʉ, ");
INSERT INTO lag_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","akavasea, “Mʉtɨma waanɨ wookaava kende nkwye. Ikali aha, mʉkeeshe chɨrɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akaseesa na mbere kiduudi, akalaala ɨsɨ na ɨnda, maa akaanda mʉloomba Mʉlʉʉngʉ, koonɨ viri dahɨka mpɨɨndɨ ya uturikiri waachwe ɨmʉnehe, ");
INSERT INTO lag_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","akasea, “Áaba, Taáta, yoosi kwaako yadahɨkáa. Nookʉloomba nseyyirya kɨkóombe ɨkɨ cha uturikiri. Maa kaa, sɨ ja ˆvyeene nɨɨnɨ noosaaka tʉkʉ, ɨve ja ˆvyeene weewe ʉrɨ saaka.” ");
INSERT INTO lag_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ˆAkahɨndʉke kwa vara vapooji vaachwe vatatʉ, akavashaana vanyéyyiirye, akamwaanɨrɨra Peéteri, “Simóoni, ʉnyéyyiirye wʉʉ? Usíindirwe keesha baa isaa rimudu vii? ");
INSERT INTO lag_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Arumi, mʉkeeshe no loomba sa karɨ jɨ mwɨɨngɨre mʉtehwii tʉkʉ. Mʉtɨma wɨɨ́mɨre neeja kʉtʉmama wʉʉja, maa kaa, wasíindwaa sa mʉvɨrɨ usiina ngururu tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Akadoma noo loomba kei, akalʉʉsa masáare yayara. ");
INSERT INTO lag_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kei ˆakahɨndʉke, akavashaana valɨ́ɨre, miiso yaavo yajáa yarútahire nɨ tʉlo. Vakakwaatwa nɨ soni, vakasiindwa cho muuyirya. ");
INSERT INTO lag_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ˆAkahɨndʉke lwa katatʉ, akavawyɨɨra, yoosea, “Nyuunyu mʉkaarɨ mʉlɨ́ɨre no hʉmʉlʉka wʉʉ? Laangi, mpɨɨndɨ jafíkire, Mwaana wa Mʉʉntʉ veera iise mɨkonwii ya vavɨ. ");
INSERT INTO lag_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Inuki, hendi tʉlooke! Laangi ʉra mʉvarinduki waanɨ afíkire.” ");
INSERT INTO lag_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mpɨɨndɨ Yéesu ˆajáa akaarɨ yoolʉʉsɨka na vapooji vaachwe, Yʉ́ʉda, ʉmwɨ wa vara ikimi na vavɨrɨ, akafika na mpuka ˆɨrɨ na nyaasʉka na mpʉʉlo. Mpuka ɨyo ɨjáa yatúmirwe nɨ vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, vakiindya va Miiro na vawosi. ");
INSERT INTO lag_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Haaha, Yʉ́ʉda ʉra mʉvarinduki, ajáa ahʉ́mwɨɨre valaɨra isháara yoosea, “Ʉra ˆndɨrɨ mʉsʉndɨra ja noomuluumbya noo yeeye. Mʉkwaati, mʉmʉsʉmʉle, aveere mɨkonwii yaanyu.” ");
INSERT INTO lag_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yʉ́ʉda akahʉlʉlʉka na kʉrɨ Yéesu, akamuluumbya, “Mukiindya!” Maa akamʉsʉndɨra. ");
INSERT INTO lag_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɨra mpuka ɨkamʉkwaata Yéesu, maa vakamʉvɨɨka mɨkonwii yaavo. ");
INSERT INTO lag_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aho, ʉmwɨ wa vara ˆvajáa na Yéesu akakʉʉla nyaasʉka njatwii, akamʉtema kutu dúú mʉtʉ́mwa wa mweeneɨsɨ mʉkʉʉlʉ! ");
INSERT INTO lag_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yéesu akavasea, “Nɨɨnɨ ndɨrɨ mʉhóki vaantʉ viintʉ muújire no kʉʉnkwaata na nyaasʉka na nkusi wʉʉ? ");
INSERT INTO lag_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sikʉ joosi nɨjáa na nyuunyu noovariyʉla waámii wa Kaaya Njija ya Ijʉva. Amwɨ sɨ mwaankwaatáa kʉra? Haaha vyavɨ́ɨre sa Masáare ˆYarɨ Mpeho yakiimane.” ");
INSERT INTO lag_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aho, vapooji voosi vakoofa maatʉkʉ vii, vakamʉtɨɨja, maa vakamʉreka yeemweene. ");
INSERT INTO lag_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwajáa kwatɨɨte mʉtavana ʉmwɨ ˆamutuubáa Yéesu, ajáa iiwɨ́ɨkɨɨre lweénda lwa kɨtáani vii. Ɨra mpuka ˆɨkayere kʉmʉkwaata, ");
INSERT INTO lag_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","akavahonyoka, akareka lweénda lwaachwe lwa kɨtáani mɨkonwii yaavo, maa akatɨɨja na kɨsava mwaarya. ");
INSERT INTO lag_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hara, vakamʉtwaala Yéesu na kwa mweeneɨsɨ mʉkʉʉlʉ. Maa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, vawosi, na vakiindya va Miiro, vakalʉmana hamwɨ. ");
INSERT INTO lag_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peéteri ne ajáa amutúubire Yéesu kwa kʉlɨ, akɨɨngɨra waámii kwa mweeneɨsɨ mʉkʉʉlʉ, maa akiikala na valʉkalʉka yookoota mooto. ");
INSERT INTO lag_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na Balása Nkʉʉlʉ yoosi, vasaakɨráa ʉshahíidi fuma kwa vaantʉ vɨɨngɨ, sa vamusitaakye Yéesu de vamʉʉlae. Maa kaa, sɨ vaturya kɨɨntʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Na vaantʉ ˆvarɨ foo vatooláa ʉshahíidi wa ʉloongo, maa kaa, ʉshahíidi waavo sɨ wiifwaana baa kiduudi vii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aho, vɨɨngɨ vakɨɨma, vakamʉlongowererya voosea, ");
INSERT INTO lag_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tamʉteera yoosea, atɨ, ‘Nɨɨnɨ girimʉla ndɨrɨ ɨhɨ Kaaya Njija ˆyajeengwa nɨ vaantʉ, maa de njeenge yɨɨngɨ kwa sikʉ itatʉ vii. Maa kaa, ɨyo sɨ ɨrɨ jeengwa nɨ vaantʉ tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Baa jeyyo ʉshahíidi waavo ukiitaa. ");
INSERT INTO lag_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Maa akɨɨma mweeneɨsɨ mʉkʉʉlʉ mbere ya Balása Nkʉʉlʉ, akamuurya Yéesu, “Eri, sɨ wookuuyirya kɨɨntʉ chochoosi tʉkʉ wʉʉ? Aya masáare ava vaantʉ ˆvookusitaakya nɨ kɨɨntʉ che?” ");
INSERT INTO lag_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Maa kaa, Yéesu akakirinya sawu baa kuuyirya tʉkʉ. Hara mweeneɨsɨ mʉkʉʉlʉ akamuurya kei, “Weewe noo Masía, Mwaana wa Mʉlʉʉngʉ ˆAtalariwa wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yéesu akasea, “Hɨɨ, noo nɨɨnɨ. Luu kʉmoona mʉrɨ Mwaana wa Mʉʉntʉ iíkyɨɨre mʉkono wa kʉlʉme wa Mweenengururu, yookʉʉja mweeri ya machu ya kurumwii.” ");
INSERT INTO lag_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mweeneɨsɨ mʉkʉʉlʉ ˆakateere jei, maa akamoola ɨngo yaachwe na nkalari, yoosea, “Mashahíidi va che kei? ");
INSERT INTO lag_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mʉʉtéɨɨre uhiintiki waachwe! Haaha nɨ joolɨ moosea?” Voosi vakalʉʉsa irya voosea, “Ʉhʉ, inkwya noo kɨɨntʉ ˆkɨmʉtéire!” ");
INSERT INTO lag_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Vaangɨ vaavo vakaanda kʉmʉchwɨɨra matɨ, vakamuchuunga ntaamɨ miiswii, vakamʉvaa ngúumi, de vandoomʉhenchʉla, “Lʉʉsa, nɨ ani akʉváire?” Baa valʉkalʉka va aho ˆvakamʉhokerere, vakamʉhapʉla makóofi. ");
INSERT INTO lag_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mpɨɨndɨ ijo joosi, Peéteri ajáa akaarɨ waámii, maa akʉʉja muhíínja ʉmwɨ wa vatʉ́mwa va mweeneɨsɨ mʉkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ˆAkamoone Peéteri yookoota mooto, akamutuurirya miiso, kʉnʉ yoosea, “Baa weewe nɨ hamwɨ waarɨ na ʉhʉ Yéesu wa Nasaréeti!” ");
INSERT INTO lag_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peéteri akasiita, yoosea, “Sɨ mányire na sɨ nootaanga ˆcheene woolʉʉsa tʉkʉ.” Maa akiinʉka, akɨtookɨɨma mutiryaangwii. Hara nkʉkʉlʉme ɨkavɨɨka. ");
INSERT INTO lag_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ʉra mʉtʉ́mwa ˆakamoone Peéteri, akavasea kei vara vaantʉ ˆvajáa viímire ne aho, “Ʉhʉ ne nɨ ʉmwɨ waavo!” ");
INSERT INTO lag_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peéteri akasiita kei gɨgɨrɨ. Mpɨɨndɨ kiduudi ˆɨkalooke, vara vaantʉ ˆvajáa viímire ne aho, vakamʉsea Peéteri, “Kɨmaarɨ, weewe ʉrɨ ʉmwɨ waavo, sa ʉrɨ Mʉgaliláaya weewe hamwɨ na ava!” ");
INSERT INTO lag_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peéteri akaanda kiijuma no kiilaha yoosea, “Sɨ namʉmányire ʉhʉ mʉʉntʉ ˆmoolʉʉsa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hahara, maa nkʉkʉlʉme ɨkavɨɨka lwa kavɨrɨ. Maa Peéteri akakʉmbʉkɨra rɨra isáare ˆaarɨ awyɨ́ɨrɨɨrwe nɨ Yéesu, “Nkʉkʉlʉme sɨ ɨnavɨɨka lwa kavɨrɨ, sea ʉrɨ sɨ waamányire tʉkʉ katatʉ.” Aho, akaanda kiita miísoori nɨ ʉsʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Maa reerʉ, kʉkamwaa. Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, vawosi, na vakiindya va Miiro na Balása Nkʉʉlʉ yoosi ya Vayahúudi, vakiirʉmɨra ˆvyeene varɨ mʉbweeyya Yéesu. Vakamuchuunga pɨɨ́ngʉ, maa vakamʉtwaala na mbere ya gávana Piláato. ");
INSERT INTO lag_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Piláato ˆakateere masáare yaavo, maa akamuurya Yéesu, “Weewe ʉrɨ mʉtemi wa Vayahúudi wʉʉ?” Ne akuuyirya, yoosea, “Weewe ulúusire.” ");
INSERT INTO lag_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva vakamusitaakya Yéesu masáare ˆyarɨ foo. ");
INSERT INTO lag_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aho, Piláato akamuurya kei, “Sa che sɨ wookuuyirya? Laanga nɨ masáare yangaɨ vookusitaakya!” ");
INSERT INTO lag_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Maa kaa, Yéesu akakirinya sawu, baa kuuyirya tʉkʉ. Sa jeyyo, Piláato akatʉlʉvala. ");
INSERT INTO lag_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na mpɨɨndɨ ja ngovi ya Paásika, Piláato ajáa iijʉvɨra kʉmʉchʉngʉrɨra mufúungwa ʉmwɨ, ˆmweene vaantʉ varɨ loomba arekerwe. ");
INSERT INTO lag_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kwajáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆasewáa Baráaba, ˆajáa achuungwa mʉnyololwii na vavarinduki va wiimiriri wa Kɨrúumi vɨɨngɨ. Na mpɨɨndɨ ja ʉvarinduki, yeeye na vavarinduki vajáa vʉʉlaa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aho, vaantʉ ˆvarɨ foo vakadoma kʉrɨ Piláato, vakamʉloomba amʉchʉngʉrɨre mufúungwa ʉmwɨ ja ˆvyeene iijʉvɨra mpɨɨndɨ ja Paásika. ");
INSERT INTO lag_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Piláato akavuurya, “Saaka mwiise nɨmʉchʉngʉrɨre mʉtemi wa Vayahúudi wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Avuurya jei, sa ajáa ataanga vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva vajáa vamʉreeta Yéesu na kwaachwe, sa vamooneráa kɨvɨna. ");
INSERT INTO lag_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kɨrɨ vyoova jeyyo, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva vakavasoonka vaantʉ, vamʉloombe Piláato amʉchʉngʉrɨre Baráaba. ");
INSERT INTO lag_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Piláato akavuurya kei, “Ha de che moosaaka nɨmʉbweeyye ʉhʉ mʉʉntʉ nyuunyu ˆmʉmʉséaa, ‘mʉtemi wa Vayahúudi’?” ");
INSERT INTO lag_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Vaantʉ vakatʉla isóso, voosea, “Aningʼiniwe mʉsaláabii fʉʉrʉ akwye!” ");
INSERT INTO lag_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piláato akavuurya, “Sa che? Ʉvɨ che abwéeyyiirye?” Maa voovo vakatʉlatʉʉla isóso, voosea, “Aningʼiniwe mʉsaláabii fʉʉrʉ akwye!” ");
INSERT INTO lag_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Sa viintʉ Piláato asaakáa veerya mɨtɨma Vayahúudi, akavafumirya Baráaba mʉnyololwii. Akavakwaatya valwi nkoondo vamʉvae Yéesu mɨjeléedi na vamuningʼinʼye mʉsaláabii fʉʉrʉ akwye. ");
INSERT INTO lag_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hara, valwi nkoondo vakamʉtwaala Yéesu na balásii ya ijuumbii ra kɨtemi ra gávana Piláato ˆrɨséwaa “Pʉratoría.” Vakasaankanʼya mpuka yoosi ya valwi nkoondo. ");
INSERT INTO lag_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Vakamʉvɨkɨra Yéesu ɨngo ya kɨtemi ˆɨrɨ gyaa. Vakafota kɨsasaavo cha miíwa, vakamʉvɨkɨra mutwii. ");
INSERT INTO lag_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Maa vakaanda muluumbya na heenchʉ, “Lamʉkyaade ee aaɨ, mʉtemi wa Vayahúudi.” ");
INSERT INTO lag_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Vakatuuba mʉvaa na isaanga mutwii no mʉchwɨɨra matɨ. Vakamʉhena voochwaama ja vaantʉ ˆvoomʉnyemya mʉtemi. ");
INSERT INTO lag_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ˆVakahʉmʉle mʉhena, vakamufumya ɨra ɨngo ˆɨrɨ gyaa, maa vakamʉvɨkɨra ɨngo jaachwe. Aho, vakamufumya na weerwii sa vakamuningʼinʼye mʉsaláabii fʉʉrʉ akwye. ");
INSERT INTO lag_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mpɨɨndɨ ijo, valwi nkoondo vakalʉmana na mʉʉntʉ ʉmwɨ njirii ˆasewáa Simóoni fuma Kɨréene, taáta waala Alekɨsáanda na Rufáasi. Ɨɨngɨráa na Yerusaléemu, maa vakamʉdoomererya avaale mʉsaláaba wa Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Vakamʉtwaala Yéesu fʉʉrʉ haantʉ ˆkʉséwaa Goligóota, noo kʉsea, “Kɨsááya cha Mʉtwe.” ");
INSERT INTO lag_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Vakamʉheera diváai ˆyasaangiwa na mooda ˆʉséwaa manemáane, anywe, maa kaa, yeeye akasiita. ");
INSERT INTO lag_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Vakamuningʼinʼya mʉsaláabii. Maa vakiigavɨra ɨngo jaachwe ko jivaɨra mbare sa vataange ani aheewe ɨrɨkwɨ. ");
INSERT INTO lag_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mpɨɨndɨ ˆvamuningʼinʼyáa mʉsaláabii, ɨjáa nɨ namʉtóondo mpɨɨndɨ jo yʉʉrɨra ngʼoombe. ");
INSERT INTO lag_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mweeri ya mʉtwe waachwe vakavaɨrɨra ibambari ˆraandɨkwa kɨloongi chaachwe, “Mʉtemi wa Vayahúudi.” ");
INSERT INTO lag_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Viívi vavɨrɨ vakaningʼiniwa mʉsaláabii ne, kɨra mʉʉntʉ mʉsaláabii waachwe, ʉmwɨ ivaru ra kʉlʉme na wɨɨngɨ ivaru ra kʉmooso.  ");
INSERT INTO lag_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Masáare ˆYarɨ Mpeho yakakiimana ja ˆvyeene yalʉʉsa, “Avalwa hamwɨ na ˆvawúnaa miiro.” ");
INSERT INTO lag_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vakeri njɨra vara ˆvalookáa na aho, vakamʉtʉkɨra no singisya mɨtwe na heenchʉ voosea, “Aaɨ, sɨ ʉjáa ʉsea atɨ ʉtɨɨte ngururu jo girimʉla Kaaya Njija ya Ijʉva, maa kei wiimye kwa sikʉ itatʉ? ");
INSERT INTO lag_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hoonɨ haaha kiima aho mʉsaláabii, wiilamurirye!” ");
INSERT INTO lag_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Viivyo vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro vakamʉhenchʉla, voosea, “Avalamuriryáa vɨɨngɨ, amwɨ yoosiindwa kiilamurirya yeemweene? ");
INSERT INTO lag_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Atɨ, yeeye nɨ Masía, mʉtemi wa Isiraéeli, nɨ akiime sa tʉlaange, de turume.” Baa vara ˆvajáa vaturikiriwa mɨsaláabii ne, vakamʉtʉkɨra. ");
INSERT INTO lag_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na kwaandɨra mpɨɨndɨ ja mpoloonge fʉʉrʉ mpɨɨndɨ ja cháámuusi, kilwiirya kɨkakʉnɨkɨrɨra ɨsɨ yoosi. ");
INSERT INTO lag_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ˆƗkafike mpɨɨndɨ ja cháámuusi, Yéesu akaanɨrɨra na ngururu, yoolʉʉsɨka na ndʉʉsɨka ya kɨmeevo ya Kɨaráamu, “Elóoi, Elóoi, láama sabakɨtáani?” noo kʉsea, “Ee Mʉlʉʉngʉ, ee Mʉlʉʉngʉ, amwɨ waandékire?” ");
INSERT INTO lag_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Vamwɨ va vaantʉ vara ˆvajáa hara ˆvakateere ayo masáare, maa vakasea, “Teeri, yoomʉkemera Elía.” ");
INSERT INTO lag_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mʉʉntʉ ʉmwɨ akakʉʉrɨka, akafarɨmbɨrɨra kɨɨntʉ ˆkɨrɨ monyomonyo isaangii, akɨɨta tukya diváaii ˆyasasʉka, maa akamʉheera Yéesu afiiye, kʉnʉ yoosea, “Mʉreki, hoonɨ tʉlaange koonɨ Elía arɨ kʉʉja jɨ amukiimye aho mʉsaláabii.” ");
INSERT INTO lag_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hara, maa Yéesu akaana na ngururu, akawulala. ");
INSERT INTO lag_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hahara ipasía ra Kaaya Njija rɨkaatʉka katɨ na katɨ fuma mweeri fʉʉrʉ ɨsɨ. ");
INSERT INTO lag_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mʉkʉ́ʉ́lʉ wa valwi nkoondo ˆajáa iímire mbere ya mʉsaláaba, ˆakoone ˆvyeene Yéesu awʉ́lɨɨre, maa akasea, “Kɨmaarɨ, ʉhʉ mʉʉntʉ nɨ Mwaana wa Mʉlʉʉngʉ aarɨ.” ");
INSERT INTO lag_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hara kʉlɨ kʉlɨ, kwajáa kwatɨɨte vaantʉ vaki ˆvalaangáa ayo masáare. Aho jei, vajáa vamwaarɨ vala Maríia Makɨdaléena, Salóome na Maríia íyo waala Yóose mwaanaavo na Yaakúupu muduudi. ");
INSERT INTO lag_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Avo noo ˆvamutuubáa Yéesu mpɨɨndɨ ˆajáa Galiláaya noo mʉtʉmamɨra. Baa kei, vajáa vamwaarɨ vaantʉ vaki vɨɨngɨ ˆvarɨ foo, ˆvajáa vʉʉja ne na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sikʉ Yéesu ˆawulala nɨ sikʉ yo virisha Sabáato ɨjáa, sikʉ ɨmwɨ de ɨve Sabáato na kyʉʉlwa. ");
INSERT INTO lag_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kwajáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆasewáa Yooséefu fuma múuji wa Arimatáaya. Yooséefu nɨ ʉmwɨ wa Balása Nkʉʉlʉ ya Vayahúudi ajáa. Anyemiwáa maatʉkʉ vii, baa kei, awoojáa kʉʉja kwa Ʉtemi wa Mʉlʉʉngʉ. Akiitema, akadoma kwa Piláato, akɨtooloomba aheewe mʉvɨrɨ wa Yéesu sa akʉʉtaahe. ");
INSERT INTO lag_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Piláato ˆakapate mʉlomo Yéesu akwíire chaangʉ vii, maa akatʉlʉvala. Akamwaanɨrɨra mʉkʉ́ʉ́lʉ wa valwi nkoondo, maa akamuurya koonɨ nɨ kɨmáárɨ Yéesu akwíire. ");
INSERT INTO lag_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Piláato ˆakawyɨɨrwe nɨ ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo nɨ kɨmáárɨ Yéesu akwíire, maa akamʉheera rʉ́ʉsa Yooséefu asʉmʉle mʉvɨrɨ wa Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yooséefu akɨɨtowʉla sáanda ya kɨtáani. Akuukiimya mʉvɨrɨ wa Yéesu, akʉʉfarɨmbɨrɨra na ɨra sáanda, maa akɨɨta kʉʉtaaha mbiríírii ya mpaanga ˆngʼeene ɨjáa yabokwa lʉkaandii lwa iwye. Akafingiritya iwye ikʉʉlʉ yoorifintamya mʉryaangwii wa mbɨrɨ́ɨ́ra. ");
INSERT INTO lag_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Vala Maríia Makɨdaléena na Maríia íyo waala Yóose, vakahoona hara haantʉ Yéesu ˆatáahirwe. ");
INSERT INTO lag_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lomʉtóondo yaachwe mwaasʉ ˆʉkakʉtʉmɨre, sikʉ ya Sabáato ɨkalooka. Hahara, Maríia Makɨdaléena, Salóome na Maríia íyo waala Yaakúupu vakɨɨta wʉla makuta ˆyanyʉkɨra, sa vakahake mʉvɨrɨ wa Yéesu. ");
INSERT INTO lag_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ˆKʉkamwaae vii sikʉ ya Jumapɨ́ɨrɨ na mwaasʉ ˆʉkatʉle, vakadoma na mbiríírii ya mpaanga ˆyabokwa mwaalaliwyii haantʉ Yéesu ˆataahɨɨrwé. ");
INSERT INTO lag_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mpɨɨndɨ ˆvajáa vakaarɨ njirii, vakaanda kiiyurya, “Nɨ ani de arɨ ko tufingiritirya rɨra iwye hara mʉryaangwii wa mbɨrɨ́ɨ́ra?” ");
INSERT INTO lag_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Valʉʉsa jeyyo, sa rɨra iwye nɨ ikʉ́ʉ́lʉ maatʉkʉ vii rɨjáa. ˆVakafike vii, vakoona rɨra iwye rafíngiritiiwe, risiina tʉkʉ hara mʉryaangwii. ");
INSERT INTO lag_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ˆVakɨɨngɨre hara mbiríírii, vakamoona mʉtavana ʉmwɨ iivɨ́kɨɨre nkáancho njerʉ chwee, iíkyɨɨre mʉkono wa kʉlʉme wa mbɨrɨ́ɨ́ra, maa vakiivʉndʉka maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ʉra mʉtavana akavasea, “Koofi tʉkʉ! Sɨ mʉsaakɨra mwiise Yéesu fuma Nasaréeti ʉra ˆaningʼiniiwé mʉsaláabii fʉʉrʉ akakwya? Afúfukire! Asiina aha tʉkʉ. Laangi baa haantʉ ˆalaariiwé. ");
INSERT INTO lag_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Haaha domi kwa vapooji vaachwe baa na Peéteri mʉkavasee, ‘Yéesu valongorera iise na Galiláaya, ʉko moona mʉrɨ ja ˆvyeene ajáa avasea.’” ");
INSERT INTO lag_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Vara vaantʉ vaki kʉnʉ vootetema nɨ woowa, vakafuma hara mbiríírii itɨ́ɨjo, kʉnʉ vatʉ́lʉvɨɨre. Sɨ valʉʉsa isáare roroosi kwa mʉʉntʉ tʉkʉ sa voofáa maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yéesu ˆakafʉfʉke Jumapɨ́ɨrɨ namʉtóondo uchikʉ, mʉʉntʉ wa ncholo ˆamʉfʉmɨra nɨ Maríia Makɨdaléena. Ʉhʉ Maríia, Yéesu ajáa amʉseyya mirimʉ mɨvɨ mufungatɨ. ");
INSERT INTO lag_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maa Maríia akadoma, akavawyɨɨra vara vaantʉ ˆvayeendanʼyáa na Yéesu. Avo vaantʉ vajáa vakaarɨ voorɨra no myaa. ");
INSERT INTO lag_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ˆVakateere Yéesu afúfukire, baa Maríia Makɨdaléena amwɨɨ́ne, sɨ varuma ayo masáare tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mpɨɨndɨ kiduudi ˆɨkalooke, Yéesu akavafʉmɨra vapooji vaachwe vavɨrɨ ˆvadomáa na maturii, arɨ na buuwo ˆyiísimire. ");
INSERT INTO lag_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Avo vaantʉ vakahɨndʉka na Yerusaléemu, vakavawyɨɨra viivaavo, baa avo sɨ vavaruma vii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lo mwiisho, Yéesu akavafʉmɨra vapooji vaachwe ikimi na ʉmwɨ mpɨɨndɨ ˆvarijáa chákurya. Akavadalavya, sa viintʉ sɨ ˆvavaruma vara ˆveene vajáa vamoona afúfukire na ʉfafu wa mɨtɨma yaavo. ");
INSERT INTO lag_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Maa akavasea, “Domi kʉrɨ weerʉ yoosi, mʉkavawyɨɨre no vavariyʉrɨra vaantʉ voosi Masáare Maaja. ");
INSERT INTO lag_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ʉra ˆarɨ ruma no batisiwa, hona arɨ. Maa kaa, ˆmweene arɨ siita ruma, heewa arɨ irya nɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na iji noo isháara ˆvarɨ kʉva nojo vara ˆveene varɨ ruma. Kwa irina raanɨ vaseyya varɨ vaantʉ mirimʉ mɨvɨ, kei lʉʉsɨka varɨ ndʉʉsɨka ifya sɨ ˆvanajiteera baa sikʉ ɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Baa vakwaate njoka na mɨkono, na vanywe kɨnyéruumbe, sɨ varɨ kʉva kɨɨntʉ vii kaa tʉkʉ. Kei, vavɨkɨra varɨ mɨkono valwɨ́ɨrɨ, novo hongera varɨ.” ");
INSERT INTO lag_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Maa reerʉ, Yéesu Mweenevyoosi ˆakahʉmʉle vawyɨɨra ayo masáare, akasʉmʉlwa na kurumwii. Kʉra mweeri akiikala mʉkono wa kʉlʉme wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Vapooji vaachwe, vakadoma, vakavawyɨɨra no vavariyʉrɨra Masáare Maaja haantʉ hoosi. Yéesu Mweenevyoosi ne akatʉmama novo no roonekya isáare raachwe ko bweeyya isháara ˆjidómanʼyaa na isáare ɨro.");
INSERT INTO lag_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kwaako Toofíili kɨjeengi, Vaantʉ ˆvarɨ foo vaandɨka masáare aya ˆyakiimana aha mɨɨtʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Avo vaandɨka aya, ja ˆvyeene tavaɨrwa mbuwo nɨ vara ˆvoona na miiso yaavo keende aho ncholo, na vara ˆvajáa vatʉmami va Masáare Maaja. ");
INSERT INTO lag_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naanɨ, ˆnkayasimbʉle neeja aya masáare keende ncholo, noona nɨkwaandɨkɨre neejaneeja weewe Toofíili kɨjeengi ˆnɨkʉnyémyaa. ");
INSERT INTO lag_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jeyyo taanga ʉrɨ kɨkomi cha masáare yoosi ˆʉvariyʉrɨrwa. ");
INSERT INTO lag_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mpɨɨndɨ ja Heróode Mʉkʉ́ʉ́lʉ mʉtemi wa Yudéea, kʉjáa kwatɨɨte mweeneɨsɨ wa Ijʉva ʉmwɨ ˆasewáa Sakaría. Ʉhʉ Sakaría nɨ wa mpuka ya veeneɨsɨ va Ijʉva va Abíya ajáa. Muki waachwe noo Elisabéeti asewáa. Na yeeye woosi nɨ wa ufumo wa lʉkolo lwa Harúuni ajáa. ");
INSERT INTO lag_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vala Sakaría na Elisabéeti nɨ vawoloki vajáa mbere ya Mʉlʉʉngʉ. Voovo vatuubáa miiro yoosi ya Ijʉva na ndairiri jaachwe baa mangʼuulo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Maa kaa, voovo vajáa vasiina vaana tʉkʉ, Elisabéeti nɨ muumba ajáa na voosi vajáa vavɨ́ɨre magarugeeda. ");
INSERT INTO lag_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Haaha sikʉ ɨmwɨ, Sakaría atʉmamáa mʉrɨmo wa veeneɨsɨ va Ijʉva mbere ya Mʉlʉʉngʉ. Mpɨɨndɨ ijo nɨ nkalo ya mpuka yaachwe kʉtʉmama Kaayii Njija ya Ijʉva ɨjáa. ");
INSERT INTO lag_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sakaría ajáa asáawɨɨrwe ko vaɨrwa mbare ɨɨngɨre na Kaayii Njija ya Ijʉva noo kookuusya ngʼóóno ˆjinyʉ́kɨraa, ja viintʉ tʉʉva ja veeneɨsɨ va Ijʉva ˆjijáa jasea. ");
INSERT INTO lag_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na mpɨɨndɨ Sakaría ˆakuusyáa ngʼóóno ˆjinyʉ́kɨraa ʉko, mpuka ya vaantʉ ɨjáa yiijíingire kʉra waámii yoomʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aho, murimʉ mʉʉja wa Ijʉva ʉkamʉfʉmɨra Sakaría, ʉkɨɨma ivaru ra kʉlʉme ra masabáahʉ yo kuusirirya ngʼóóno ˆjinyʉ́kɨraa. ");
INSERT INTO lag_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaría ˆakamoone ʉra murimʉ mʉʉja, mʉtɨma waachwe ʉkafɨrɨra na akoofa maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Maa kaa, murimʉ mʉʉja ʉkamʉsea, “Sakaría, koofa tʉkʉ! Mʉlʉʉngʉ atéɨɨre kʉloomba kwaako. Muki waako Elisabéeti kʉvyaarɨra arɨ mwaana mʉlʉme. Irina raachwe ʉmʉkemere Yooháani. ");
INSERT INTO lag_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Weewe kʉvyeenda ʉrɨ, na kʉva ʉrɨ na cheerʉ. Baa vaantʉ ˆvarɨ foo vaa varɨ siriri sikʉ yo vyaalwa kwaachwe. ");
INSERT INTO lag_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sa yeeye kʉva arɨ mʉkʉ́ʉ́lʉ mbere ya Ijʉva, sɨ akanywíire diváai au kɨɨntʉ chochoosi ˆkɨréevyaa vii kaa tʉkʉ. Yeeye kʉmʉhokera arɨ Mʉtɨma Mʉʉja keende indii ya íyo waavo. ");
INSERT INTO lag_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Vahɨndʉla arɨ Viisiraéeli ˆvarɨ foo na kwa Ijʉva Mʉlʉʉngʉ waavo. ");
INSERT INTO lag_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ʉwo, longoola arɨ mbere ya Ijʉva, kwa ngururu na mʉtɨma wa Elía. Vahɨndʉla arɨ vala baaba na kwa vaana vaavo. Jeyyo, vahɨndʉla arɨ vara ˆvasiina matu na kʉrɨ tooti ya ʉwoloki na kuviimya arɨ neeja kʉmʉhokera Ijʉva.” ");
INSERT INTO lag_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aho, Sakaría akuuyurya ʉwo murimʉ mʉʉja, “Nɨɨnɨ nadálahɨɨre, baa mʉdala waanɨ woosi adálahɨɨre. Joolɨ ndɨrɨ taanga isáare ɨrɨ nɨ ra kɨmáárɨ?” ");
INSERT INTO lag_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aho, maa murimʉ mʉʉja ʉkamuwyɨɨra woosea, “Nɨɨnɨ ndɨrɨ Gaburiéeli, nɨɨ́maa mbere ya Mʉlʉʉngʉ, na yeeye aantúmire nɨkʉwyɨɨre aya masáare maaja. ");
INSERT INTO lag_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Haaha sa viintʉ sɨ urúmire aya ˆnakuwyɨ́ɨrɨɨre, dunga ʉrɨ mʉlomo fʉʉrʉ sikʉ ɨra mwaana ˆarɨ vyaalwa. Kɨkomi masáare yaanɨ kiimikiririwa yarɨ mpɨɨndɨ ˆjiri fika!” ");
INSERT INTO lag_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mpɨɨndɨ ijo, vaantʉ vamʉwoojeráa Sakaría kʉra waámii kʉnʉ vahwáalɨɨre, sa ajáa achérevire kufuma Kaayii Njija. ");
INSERT INTO lag_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ˆAkafume, akava sɨ yoodaha kʉlʉʉsɨka novo tʉkʉ. Aho vakataanga ɨɨ́ne njori mʉra Kaayii Njija, sa nɨ avalaɨráa na mɨkono vii, sɨ yoodaha lʉʉsɨka tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mpɨɨndɨ jaachwe jo tʉmama Kaayii Njija ˆjikasire, maa akahɨndʉka na kaayii. ");
INSERT INTO lag_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Sikʉ ingaɨ vii ˆjikalooke, Elisabéeti muki waachwe akava mawʉlʉ maruto, akiivisa kaayii kwaachwe kwa myeeri ɨsaano kʉnʉ yoosea, ");
INSERT INTO lag_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ijʉva noo ˆmweene aantʉ́mamɨɨre ɨkɨ, yeeye aanaanga sikʉ jira sa aanséyyiirye soni yo dɨɨra kʉva na vaana mbere ja vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ˆɄkafike mweeri wa sasatʉ keende Elisabéeti ˆakave muruto, Mʉlʉʉngʉ akatʉma murimʉ mʉʉja Gaburiéeli ʉtamanye fʉʉrʉ ituri ra Nasaréeti ˆrɨrɨ ɨsɨ ya Galiláaya. ");
INSERT INTO lag_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ʉko, ʉkatamanya fʉʉrʉ kwa muhíínja ʉmwɨ ˆajáa mʉnjalʉ. Ʉhʉ ajáa atʉmɨrwa nɨ mʉʉntʉ ʉmwɨ ˆasewáa Yooséefu wa lʉkolo lwa mʉtemi Daúdi. Na irina ra ʉwo muhíínja noo Maríia asewáa. ");
INSERT INTO lag_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Murimʉ mʉʉja ˆʉkafike kwa Maríia, maa ʉkamʉsea, “Lʉmbɨ niijo weewe ˆʉheewa nduwo, Ijʉva nɨ na weewe arɨ!” ");
INSERT INTO lag_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maríia ˆakateere jeyyo, akahwaalala maatʉkʉ vii, akiiyurya yoosea, “Ɨhɨ lʉmbɨ nɨ ya che?” ");
INSERT INTO lag_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aho, maa murimʉ mʉʉja ʉkamʉsea, “Maríia, koofa tʉkʉ! Wapátire wʉʉja miiswii ya Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Teera! Kʉva ʉrɨ muruto, na kʉva ʉrɨ na mwaana mʉlʉme. Irina raachwe mʉkemera ʉrɨ Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yeeye kʉva arɨ mʉkʉ́ʉ́lʉ, na kaanɨrɨrwa eende Mwaana wa ˆArɨ Mweerimweeri. Ijʉva Mʉlʉʉngʉ kʉmʉheera arɨ ichuumbi ra kɨtemi ra baaba waavo Daúdi. ");
INSERT INTO lag_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kwɨɨmɨrɨra arɨ kaaya ya Yaakúupu kwa sikʉ ˆjisiina ʉhero, na Ʉtemi waachwe kʉva ʉrɨ usiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maríia akuuyurya ʉra murimʉ mʉʉja, “Ɨrɨ isáare joolɨ rɨrɨ dahɨka, na nɨɨnɨ nkaarɨ sɨ nɨnaseesererwa nɨ mʉʉntʉ mʉlʉme?” ");
INSERT INTO lag_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aho, murimʉ mʉʉja ʉkamʉsea, “Mʉtɨma Mʉʉja kʉʉjɨra arɨ, na ngururu ja ˆArɨ Mweerimweeri kʉkʉnɨkɨrɨra jiri. Sa mwaana ˆarɨ vyaalwa, kʉva arɨ mʉʉja na kaanɨrɨrwa eende Mwaana wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Laanga, baa mʉndʉʉ waako Elisabéeti atɨɨte uruto wa mwaana mʉlʉme mpɨɨndɨ iji ja ʉdala waachwe. Ʉra ˆvamwaanɨrɨráa muumba, ʉhʉ nɨ mweeri wa sasatʉ wa uruto waachwe. ");
INSERT INTO lag_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sa kwa Mʉlʉʉngʉ kisiina sɨ ˆkɨdáhɨkaa tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aho, Maríia akasea, “Laanga, nɨɨnɨ ndɨrɨ mʉtʉmami wa Ijʉva, vive kwaanɨ ja ˆvyeene ulúusire.” Aho, maa re ʉra murimʉ mʉʉja ʉkalooka. ");
INSERT INTO lag_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sikʉ ingaɨ vii ˆjikalooke, Maríia akakwaata njɨra, akafweenga na múuji ʉmwɨ ˆʉrɨ ɨsɨ ya viduunda vya Yʉ́ʉda. ");
INSERT INTO lag_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ʉko akɨɨngɨra kaayii kwa Sakaría, akamuluumbya Elisabéeti. ");
INSERT INTO lag_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabéeti ˆakateere lʉmbɨ ya Maríia, mwaana ˆarɨ indii yaachwe akabwɨɨta. Aho, ngururu ja Mʉtɨma Mʉʉja jikamʉʉjɨra Elisabéeti. ");
INSERT INTO lag_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Akalʉʉsa na ngururu yoosea, “Weewe watalariwa kʉlookya vaantʉ vaki voosi, na mʉvyaalwa wa ɨnda yaako atalariwa. ");
INSERT INTO lag_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nɨɨnɨ ndɨrɨ ani mpaka íyo wa Mweenevyoosi waanɨ ʉʉje noo kʉʉnaanga? ");
INSERT INTO lag_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Laanga, ˆnkateere vii lʉmbɨ yaako, mwaana indii yaanɨ, afɨ́rɨɨre na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ʉtalariwa weewe, sa uruma Ijʉva tʉmama arɨ yara ˆakuwyɨɨra.” ");
INSERT INTO lag_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aho, maa Maríia akasea, “Mʉtɨma waanɨ wamʉbwéeyyiryaa Ijʉva nkongojima, ");
INSERT INTO lag_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","kei mʉtɨma waanɨ wavyeéndire, kwa Mʉlʉʉngʉ Mʉlamuriri waanɨ, ");
INSERT INTO lag_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","sa akwɨɨ́ne kʉsova ngururu kwa mʉtʉmami waachwe. Kɨkomi, kwaandɨra haaha, nkolo joosi ja weerʉ kʉʉnyanɨrɨra veende natalariwa, ");
INSERT INTO lag_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sa Mʉlʉʉngʉ Mweenengururu, aantʉ́mamɨɨre masáare makʉʉlʉ. Irina raachwe nɨ riija. ");
INSERT INTO lag_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kʉlaanga na riiso ra wʉʉja kwaachwe kwatámanyaa na kwa vaantʉ ˆvamʉnyémyaa, kufuma mbyaala ɨmwɨ fʉʉrʉ yɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yeeye atʉ́mamire masáare makʉʉlʉ kwa mʉkono waachwe, avapásirepasire vara ˆviívaa kɨpeembe mitimii yaavo. ");
INSERT INTO lag_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Avakíimiirye vakʉ́ʉ́lʉ fuma machuumbii yaavo ya kɨtemi, na vara ˆvarɨ ɨsɨ aviínwɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Vara ˆvarɨ na njala aviikutya viintʉ ˆvyabooha, maa kaa, vasúngaati avakibirya na mɨkono mɨtʉhʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Amwaámbiriirye Isiraéeli mʉtʉmami waachwe, kʉkʉmbʉkɨra kʉlaha kwaachwe kʉvalaanga arɨ na riiso ra wʉʉja, ");
INSERT INTO lag_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ja ˆvyeene avalaha vala baaba wiitʉ, Aburaháamu na mbyaala yaachwe kwa sikʉ ˆjisiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ʉko Maríia akiikala na Elisabéeti ja myeeri ɨtatʉ jei, maa de akahɨndʉka na kaayii kwaachwe. ");
INSERT INTO lag_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mpɨɨndɨ jo kiichʉngʉla Elisabéeti ˆjikafike, akiichʉngʉla mwaana mʉlʉme. ");
INSERT INTO lag_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Vakaaya na vandʉʉ vaachwe ˆvakateere ˆvyeene Ijʉva amʉláangire na riiso ra wʉʉja mʉnʉmʉʉnʉ, vakava voovyeenda hamwɨ ne. ");
INSERT INTO lag_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sikʉ ya naanɨ keende mwaana ˆavyaalwa ˆɨkafike, vakʉʉja noo mʉtwaala mwaana na kɨbawii. Vakasaaka vamʉkemere ʉra mwaana Sakaría irina ra taáta waavo. ");
INSERT INTO lag_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Maa kaa, íyo waavo akasiita yoosea, “Tʉkʉ! Irina ˆarɨ kaanɨrɨrwa nɨ Yooháani.” ");
INSERT INTO lag_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Novo vakamʉsea, “Amwɨ lʉkolwii lwaanyu kusiina mʉʉntʉ ˆarɨ nɨ irina ja ɨro tʉkʉ?” ");
INSERT INTO lag_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aho, maa kei vakamuurya taáta waavo ko moonekya na mɨkono sa vataange nɨ irina che ˆarɨ mʉkemera. ");
INSERT INTO lag_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sa jeyyo, Sakaría akaloomba kabambari ko kaandɨkɨra, maa akaandɨka jei, “Irina raachwe noo Yooháani.” Aho, maa vaantʉ voosi vakahwaalala. ");
INSERT INTO lag_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hahara, lurimi lwaachwe lʉkachʉngʉlʉka, akaanda lʉʉsɨka yoomʉdʉʉmba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Vakaaya voosi va Sakaría vakakwaatwa nɨ woowa. Masáare aya yakeenera ɨsɨ yoosi ya viduunda vya Yudéea. ");
INSERT INTO lag_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vaantʉ voosi ˆvateera aya masáare, vakahwaalala na vakatuuba kwiiririkana mitimii yaavo kʉnʉ vookiisea, “Ʉhʉ musinga nɨ arɨ joolɨ arɨ kʉva?” Viiririkanáa jeyyo, sa vajáa vataanga mʉkono wa Ijʉva nɨ ne ʉjáa. ");
INSERT INTO lag_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aho, Sakaría taáta waala ʉra musinga akapata ngururu ja Mʉtɨma Mʉʉja, akaanda lʉʉsa ʉláali na mʉtwe yoosea, ");
INSERT INTO lag_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Adʉʉmbwe Ijʉva Mʉlʉʉngʉ wa Isiraéeli, sa uújire vaambirirya no vanunuula vaantʉ vaachwe. ");
INSERT INTO lag_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atʉhɨ́ɨre Mʉlamuriri ˆarɨ na ngururu, kufuma ichina ra Daúdi mʉtʉmami waachwe, ");
INSERT INTO lag_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ja ˆvyeene Mʉlʉʉngʉ alʉʉsa ko tweera valáali na mʉtwe vaachwe keende aho kalɨ, ");
INSERT INTO lag_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kʉtʉlamurirya iise fuma mɨkonwii ya vavɨ viitʉ, na kufuma mɨkonwii ya voosi ˆvatʉsʉʉla. ");
INSERT INTO lag_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Abwéeyyiirye jei koonekya riiso ra wʉʉja kwa vala baaba wiitʉ, ko kʉmbʉkɨra mʉháko waachwe mʉʉja. ");
INSERT INTO lag_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mʉhákwii ʉwo, amʉlaha Aburaháamu baaba wiitʉ, ");
INSERT INTO lag_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kʉtʉlamurirya arɨ fuma mɨkonwii ya vavɨ viitʉ, haaha tʉmʉtʉmamɨre yeeye baa woowa tʉkʉ, ");
INSERT INTO lag_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kwa wʉʉja na ʉwoloki mbere yaachwe, sikʉ joosi ja nkaasʉ jiitʉ. ");
INSERT INTO lag_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Naawe mwaana waanɨ, kaanɨrɨrwa weende mʉláali na mʉtwe wa ˆArɨ Mweerimweeri, sa mʉlongorera ʉrɨ Ijʉva, ʉmʉwólorire njɨra yaachwe, ");
INSERT INTO lag_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na vawyɨɨra ʉrɨ vaantʉ vaachwe mɨryʉʉngʉ ya kʉlamuririwa kwaavo, ko sewa ʉvɨ waavo wasírire. ");
INSERT INTO lag_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kwa njɨra ya kʉlaanga kwaachwe na riiso ra wʉʉja kʉkʉʉlʉ, kɨweerʉ chaachwe kʉtʉʉjɨra kɨrɨ fuma mweeri, ");
INSERT INTO lag_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","sa kɨvamʉrɨkɨre voosi vara ˆviíkalaa kilwiiryii cha murimírimii wa inkwya, na kɨlongoole majeo yiitʉ na njirii ya mwiikalo mʉʉja.” ");
INSERT INTO lag_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yooháani akʉla, akatuuba kʉva na ngururu ja Mʉtɨma Mʉʉja. Akɨɨta kiikala ɨsɨ ya ibaláángʉ, mpaka sikʉ ˆaanda mʉrɨmo mbere ja vaantʉ va Isiraéeli. ");
INSERT INTO lag_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sikʉ ijo, Kaisáari Agúusto mʉtawáala wa weerʉ ya Róoma, ajáa alairirya vaantʉ voosi va ɨsɨ ja ʉtemi waachwe vavalwe. ");
INSERT INTO lag_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kʉvalwa ʉkʉ noo kʉjáa kwa ncholo mpɨɨndɨ Kireníio ˆajáa gávana wa ɨsɨ ya Síria. ");
INSERT INTO lag_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sa jeyyo, vaantʉ voosi vajáa vadoma noo valwa, kɨra mʉʉntʉ múujii kʉʉntʉ lʉkolo lwaachwe ˆlwafuma. ");
INSERT INTO lag_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na sa viintʉ Yooséefu ajáa nɨ wa ichina ra Daúdi, ne akaambʉka fuma múujii wa Nasaréeti, ˆʉrɨ ɨsɨ ya Galiláaya, fʉʉrʉ múuji ˆʉséwaa Betelehéemu, ˆʉrɨ ɨsɨ ya Yudéea. ");
INSERT INTO lag_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ne ajáa atamanya na ʉko noo valwa hamwɨ na Maríia muhíínja ˆajáa amʉtʉmɨra. Mpɨɨndɨ ijo, Maríia nɨ mawʉlʉ maruto ajáa. ");
INSERT INTO lag_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na mpɨɨndɨ ˆvajáa ʉko Betelehéemu, sikʉ ja Maríia jo kiichʉngʉla jikava jafíkire. ");
INSERT INTO lag_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maríia akiichʉngʉla mwaana wa ndaambere wa kɨɨntʉ kɨlʉme. Akamʉkʉnɨkɨrɨra na ɨngo ja kisinga, maa akamʉlaarya mʉlaambwii wo riishirya ngʼoombe, sa vajáa vasóvire nkalo nyuumbii ya vayeni. ");
INSERT INTO lag_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Haaha, heehi na aho kʉʉntʉ ˆvajáa uchikʉ ʉwo, kʉjáa kwatɨɨte varíisi ˆvalaangiriryáa makukikuki ya muundi na mburi ʉko mawundii mpɨɨndɨ ja uchikʉ. ");
INSERT INTO lag_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Koonka, murimʉ mʉʉja wa Ijʉva ʉkavafʉmɨra, kɨweerʉ cha nkongojima ya Ijʉva kɨkavarɨɨngɨrɨra mavaru yoosi. Aho, vakoofa mpaka vakoololokera. ");
INSERT INTO lag_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Maa kaa, murimʉ mʉʉja ʉkavasea, “Koofi tʉkʉ! Laangi, navarétɨɨre masáare maaja ˆyarɨ kʉva cheerʉ kɨkʉʉlʉ kwa vaantʉ voosi. ");
INSERT INTO lag_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sa isikʉ aha múujii wa mʉtemi Daúdi, avyɨ́ɨrwe Mʉlamuriri, noo Masía na Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na ɨhɨ noo isháara ˆɨrɨ bweeyya mʉmʉtaange: La, kʉmʉshaana mʉrɨ mwaana awɨ́ɨkɨɨrwe ɨngo ja kisinga, aláariiwe mʉlaambwii wo riishirya ngʼoombe.” ");
INSERT INTO lag_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Koonka, mpuka nkʉʉlʉ ya mirimʉ miija ya kurumwii ɨkasaangɨra na ʉra murimʉ mʉʉja, ɨkaanda mʉdʉʉmba Mʉlʉʉngʉ yoosea, ");
INSERT INTO lag_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nkongojima kwa Mʉlʉʉngʉ ˆArɨ Mweerimweeri, na kʉrɨ weerʉ kʉve na mwiikalo mʉʉja kwa vaantʉ ˆaveenda!” ");
INSERT INTO lag_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mirimʉ miija ˆɨkahɨndʉke na kurumwii, maa vara varíisi vakiiwyɨɨra voovo kwa voovo, “Arumi, hendi na Betelehéemu tʉkoone ɨkɨ ˆchafʉ́mɨɨre Ijʉva ˆatʉláɨɨre.” ");
INSERT INTO lag_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jeyyo, vakatamanya chaangʉ na Betelehéemu. Kʉra vakamʉshaana Maríia na Yooséefu na mwaana aláariiwe mʉlaambwii. ");
INSERT INTO lag_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ˆVakamoone mwaana, maa vakalʉʉsa masáare ˆmeene vajáa vawyɨ́ɨrɨɨrwe nɨ murimʉ mʉʉja ya ʉwo mwaana kwa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na voosi ˆvajáa vateera ayo, vakahwaalala kwa ayo masáare ˆvajáa vawyɨ́ɨrɨɨrwe nɨ avo varíisi. ");
INSERT INTO lag_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maa kaa, Maríia akayakwaatya na andookiiririkana ayo masáare yoosi mutimii waachwe. ");
INSERT INTO lag_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Vara varíisi vakahɨndʉka kʉnʉ voomʉbweeyyirya Mʉlʉʉngʉ nkongojima, sa ayo masáare yoosi ˆvajáa vatéɨɨre na ˆvajáa vɨɨ́ne fuma kwa mirimʉ miija. ");
INSERT INTO lag_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sikʉ inaanɨ ˆjikafike, vakamuwyiirya kɨbawii mwaana na vakamʉheera irina Yéesu. Ɨrɨ irina noo rɨra ˆajáa aheewa nɨ murimʉ mʉʉja de íyo waavo ave muruto. ");
INSERT INTO lag_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sikʉ jo kiijirʉla vala Yooséefu na Maríia ja ˆvyeene Miiro ya Mʉ́sa yalairirya, jikafika. Vakamʉtwaala mwaana na Yerusaléemu sa vamʉvɨɨke mʉháko kwa Ijʉva, ");
INSERT INTO lag_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ja ˆvyeene vyaandɨka Miirwii ya Ijʉva, “Kɨra mwaana wa kɨɨntʉ kɨlʉme wa ndaambere vɨɨkwa arɨ mʉháko kwa Ijʉva.” ");
INSERT INTO lag_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kei, vajáa vadoma noo toola mpóryo ja ˆvyeene Miiro ya Ijʉva yalʉʉsa, “Mʉtoole haramu ivɨrɨ au makɨ́ɨnda yavɨrɨ ya nkúnde.” ");
INSERT INTO lag_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Haaha, aho Yerusaléemu kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆasewáa Simeóoni. Ʉhʉ, nɨ mʉwoloki ajáa na amutuubáa Mʉlʉʉngʉ. Yeeye, amʉloombáa Mʉlʉʉngʉ kɨra siikʉ, na kei iilaangyáa Masía kʉʉja arɨ na tuurya arɨ mʉtɨma Isiraéeli. Simeóoni alongoolwáa nɨ Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mʉtɨma Mʉʉja ajáa amʉtʉʉnʉkʉrɨra sɨ arɨ kukwya tʉkʉ, mpaka amoone Masía wa Ijʉva. ");
INSERT INTO lag_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kʉnʉ yoolongoolwa nɨ Mʉtɨma Mʉʉja, Simeóoni ajáa atamanya na waámii wa Kaaya Njija ya Ijʉva. Ʉko Yooséefu na Maríia vajáa vamʉtwáarire mwaana waavo Yéesu na Kaayii Njija ja ˆvyeene Miiro yalʉʉsa. ");
INSERT INTO lag_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aho, Simeóoni akamʉhokera mwaana mɨkonwii yaachwe, maa akamʉdʉʉmba Mʉlʉʉngʉ yoosea, ");
INSERT INTO lag_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Haaha ee Ijʉva Mweeneevyo weemweene, rekera mʉtʉ́mwa waako, asuukye na wʉʉja, ja ˆvyeene ʉlʉʉsa. ");
INSERT INTO lag_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sa miiso yaanɨ yɨɨ́ne ʉlamuriri waako. ");
INSERT INTO lag_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ʉlamuriri wʉʉvɨɨka mbere ya vaantʉ voosi. ");
INSERT INTO lag_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ʉhʉ kʉva arɨ kɨweerʉ ˆkɨrɨ koonekya Mʉlʉʉngʉ kwa vaantʉ sɨ ˆvarɨ Vayahúudi, kei yeeye nɨ nkongojima kwa vaantʉ vaako Viisiraéeli.” ");
INSERT INTO lag_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Masáare ˆyajáa yalúusirwe nɨ Simeóoni kʉrɨ musinga, yakavahwaalarya vala taáta na íyo waavo. ");
INSERT INTO lag_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aho, Simeóoni akavatalarya, maa akamʉsea Maríia, “Laanga, mwaana ʉhʉ bweeyya arɨ vaantʉ ˆvarɨ foo va Isiraéeli vawye na ˆvarɨ foo viinʉke. Yeeye kʉva arɨ isháara ˆɨrɨ siitwa. ");
INSERT INTO lag_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jeyyo, miiririkano ya vaantʉ ˆvarɨ foo yiivariyʉle. Naawe mweeneevyo, nyaasʉka tʉʉnga ɨrɨ mʉtɨma waako.” ");
INSERT INTO lag_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Haaha, kʉjáa kwatɨɨte mʉláali na mʉtwe wa kɨɨntʉ kiki ˆasewáa Áana, mwaana wa Fanʉéeli wa lʉkolo lwa Ashéeri. Yeeye ajáa avɨ́ɨre ibaasʉka. Áana ajáa aloolwa na ajáa iikala na mʉlʉme waachwe kwa myaaka mufungatɨ, maa mʉlʉme waachwe akawulala. ");
INSERT INTO lag_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Keende aho, akava mʉlala na ajáa afíkiirye myaaka makumi yanaanɨ na ɨne (84). Kwa mpɨɨndɨ joosi kʉʉntʉ ˆavijáa, nɨ Kaayii Njija uchikʉ na muusi yoomwiinamɨra Mʉlʉʉngʉ, no mʉloomba Mʉlʉʉngʉ, kʉnʉ iirékiirye kurya. ");
INSERT INTO lag_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na mpɨɨndɨ jiijo kati Simeóoni ˆalʉʉsɨkáa na Yooséefu na Maríia, Áana akʉʉja, akaanda mʉdʉʉmba Mʉlʉʉngʉ na akaanda lʉʉsa masáare ya ʉwo mwaana kwa vaantʉ voosi vara ˆvawoojeráa kununuulwa kwa Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yooséefu na Maríia ˆvakamarikirye masáare yoosi ˆyasaakwa nɨ Miiro ya Ijʉva, maa vakahɨndʉka na ɨsɨ ya Galiláaya fʉʉrʉ meevo múujii wa Nasaréeti. ");
INSERT INTO lag_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Musinga ne akakʉla, akava na ngururu, akakɨɨngɨka tooti na nduwo ya Mʉlʉʉngʉ nɨ na yeeye ɨjáa. ");
INSERT INTO lag_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kɨra mwaaka, Yooséefu na Maríia vadomáa na Yerusaléemu na ngovii ya Paásika. ");
INSERT INTO lag_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yéesu ˆakafikye myaaka ikimi na ɨvɨrɨ, vakaambʉkanʼya ne na ngovii ja ˆvyeene viijʉvɨra. ");
INSERT INTO lag_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngovi ya Paásika ˆɨkasire, maa Yooséefu na Maríia vakakwaata njɨra voohɨndʉka na kaayii, Yéesu akachaala Yerusaléemu baa voovo taanga tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Maa kaa, sa viintʉ voovo viiseáa Yéesu amwaarɨ aho ikukikukii, vakayeenda lʉyeendo lwa sikʉ ɨmwɨ. Aho, vakaanda kʉmʉsaakɨra kwa vandʉʉ vaavo na kwa vijeengi vyaavo. ");
INSERT INTO lag_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ˆVakamʉsove, vakalamʉla vahɨndʉke na Yerusaléemu kʉnʉ voomʉsaakɨra. ");
INSERT INTO lag_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sikʉ itatʉ ˆjikalooke, vakamʉshaana Kaayii Njija, kʉnʉ iíkyɨɨre katɨ na katɨ ya vakiindya va Miiro yoovateerera na yoovuurya viintʉ ˆvalʉʉsáa. ");
INSERT INTO lag_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Vaantʉ voosi ˆvateeráa ˆvyeene Yéesu uuyiryáa na mʉryʉʉngʉ ˆajáa nowo, vakahwaalala. ");
INSERT INTO lag_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yooséefu na Maríia ˆvakamoone, maa vakahwaalala. Íyo waavo akamʉsea, “Mwanawaanɨ, sa che kʉtʉbweeyyirya jei? Laanga, nɨɨnɨ na taáta waanyu tatʉ́rɨkɨɨre maatʉkʉ vii tookʉsaakɨra.” ");
INSERT INTO lag_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yeeye akavasea, “Sa che mwakʉnsaakɨra? Sɨ mootaanga nasaakwa mbeere nyuumbii ya Taáta tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Maa kaa, sɨ vataanga ˆcheene avawyɨɨráa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aho, akahɨndʉkanʼya novo na Nasaréeti na akava matu sikʉ joosi. Maa kaa, íyo waavo akayakwaatya ayo yoosi mutimii waachwe. ");
INSERT INTO lag_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yéesu akatuuba kʉla na akava na tooti, kʉnʉ yoomweerya mʉtɨma Mʉlʉʉngʉ na vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Haaha, ʉjáa wafíkire mwaaka wa ikimi na ɨsaano (15) wa ʉtemi wa Kaisáari Tiberío. Mpɨɨndɨ ijo, Poontío Piláato noo ajáa gávana wa ɨsɨ ya Yudéea, Heróode Antípaasi noo ɨɨmɨrɨráa ɨsɨ ya Galiláaya na Filíipi mwaanaavo na Heróode noo ɨɨmɨrɨráa ɨsɨ ya Ituréa na ɨsɨ ya Tirakoníiti na Lisanía noo ɨɨmɨrɨráa ɨsɨ ya Abiléene. ");
INSERT INTO lag_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kei mpɨɨndɨ ijo, Anáasi na Kayáafa noo vajáa veeneɨsɨ vakʉʉlʉ. Isáare ra Mʉlʉʉngʉ rɨkamʉʉjɨra Yooháani mwaana wa Sakaría ʉko ɨsɨ ya ibaláángwii. ");
INSERT INTO lag_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yooháani adomáa na nkaande joosi ja lʉʉjɨ lwa Yorodáani, yoovariyʉla ʉbatíiso wa vaantʉ kʉvalandʉka fuma uvii waavo, sa Mʉlʉʉngʉ asee, ʉvɨ waavo wasírire. ");
INSERT INTO lag_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ja ˆvyeene Ijʉva alʉʉsa kɨtáabwii cha Isáaya mʉláali na mʉtwe waachwe, “Mʉʉntʉ yookaanɨrɨra vikʉlʉkʉʉlʉ ɨsɨ ya ibaláángwii, ‘Imyi neeja njɨra sa Ijʉva. Wololi njɨra ˆngʼeene arɨ tweera. ");
INSERT INTO lag_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kɨra nkuruwo fʉkɨrwa ɨrɨ, kɨra lʉʉlʉ na kiduunda yaaniririwa viri. Njɨra ˆjawoda wololwa jiri, na jira ˆjabonkoka yaaniririwa jiri. ");
INSERT INTO lag_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na vaantʉ voosi koona varɨ ʉlamuriri wa Mʉlʉʉngʉ.’” ");
INSERT INTO lag_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Haaha vaantʉ ˆvarɨ foo vʉʉjáa na kʉrɨ Yooháani sa avabatise. Yooháani avawyɨɨráa yoosea, “Eri, nyuunyu mbyaala ya nyororooda! Nɨ ani ˆavalúmire kutu mʉtɨɨje nkalari ya Mʉlʉʉngʉ ˆyookʉʉja? ");
INSERT INTO lag_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tʉmami mɨrɨmo ˆɨrɨ koonekya kɨkomi mwaválandukire fuma uvii waanyu. Reki kwiiririkana mitimii yaanyu, ‘Aburaháamu nɨ taáta wiitʉ!’ Nɨ kʉvawyɨɨra niise, Mʉlʉʉngʉ ifaanaa avalandʉle mawye aya yave vaana va Aburaháamu! ");
INSERT INTO lag_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Baa haaha, chaarya chavíikirwe miririi ya kɨra mʉtɨ. Kɨra mʉtɨ sɨ ˆʉtʉ́ʉngaa ndɨɨwa ˆjabooha, temwa ʉrɨ na fweitɨrwa ʉrɨ iviivii ra mooto.” ");
INSERT INTO lag_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Aho, ɨra mpuka ya vaantʉ ɨkamuurya, “Haaha nɨ che tʉrɨ bweeyya?” ");
INSERT INTO lag_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yooháani akavasea, “ˆArɨ na nkáancho ivɨrɨ, amʉheere ɨmwɨ ʉra ˆasiina, na ʉra ˆarɨ na chóorya abweeyye viivyo.” ");
INSERT INTO lag_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Vasaankanʼyi kóodi novo vakʉʉja sa vabatisiwe, maa vakamuurya Yooháani, “Mukiindya na suusu tasaakwa tʉbweeyye joolɨ?” ");
INSERT INTO lag_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ne akavasea, “Karɨ mʉsʉ́mʉlaa kʉlookya vira ˆvyeene Miiro yaruma tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Valwi nkoondo novo vakamuurya voosea, “Ha suusu nɨ che tʉrɨ bweeyya?” Yooháani akavasea, “Karɨ muvúulaa mʉʉntʉ viintʉ vyaachwe tʉkʉ, na karɨ mʉkóovereryaa sa mʉpate mpía ja mʉhonyo tʉkʉ, maa kaa, ikinkimi na mɨsáala yaanyu.” ");
INSERT INTO lag_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Vaantʉ vara ˆvaawoojera kʉʉja kwa Masía mpɨɨndɨ ijo, voosi viiseáa mitimii yaavo ifaanaa ɨkava Yooháani noo Masía. ");
INSERT INTO lag_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aho, maa Yooháani akavasea vaantʉ voosi, “Nɨɨnɨ vabatisa niise na maaji. Maa kaa, amwaarɨ yookʉʉja nyuma yaanɨ ˆarɨ na ngururu kʉlookya nɨɨnɨ, nɨɨnɨ sɨ ndɨrɨ daha baa tʉmama mʉrɨmo wa mʉtʉ́mwa, wo reherya nkova ja mirunkumo yaachwe tʉkʉ. Yeeye vabatisa arɨ na Mʉtɨma Mʉʉja na mooto. ");
INSERT INTO lag_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Saama yaachwe yo keerera akwáatire mɨkonwii yaachwe. Iímire neeja kʉfyaahɨra lʉʉha lwaachwe, ajiinge ngáano kyoomii maa kaa, mukúúnku achɨmɨke mootwii sɨ ˆurímaa.” ");
INSERT INTO lag_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa masáare ayo na yɨɨngɨ ˆyarɨ foo, Yooháani avalʉmáa kutu vaantʉ, mpɨɨndɨ ˆavavariyʉrɨráa Masáare Maaja. ");
INSERT INTO lag_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Maa kaa, Yooháani ˆakamʉdalavye mʉtemi Heróode Antípaasi sa viintʉ ˆajáa amʉsʉmʉla Herodía muki wa mwaanaavo, na sa mavɨ yɨɨngɨ ˆatʉmamáa, ");
INSERT INTO lag_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Heróode akoongererya ʉvɨ wɨɨngɨ ko muchuunga mʉnyololwii Yooháani. ");
INSERT INTO lag_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sikʉ ɨmwɨ mpɨɨndɨ Yooháani ˆajáa akaarɨ yeekerwa, vaantʉ voosi ˆvakahʉmʉle batisiwa, Yéesu ne akabatisiwa. Mpɨɨndɨ Yéesu ˆaloombáa, kurumu kʉkaatʉka dwee. ");
INSERT INTO lag_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mʉtɨma Mʉʉja wa Mʉlʉʉngʉ akakiima mweeri yaachwe arɨ ja nkúnde. Aho, sawúti ɨkafuma kurumwii, yoosea, “Weewe ʉrɨ Mwaana waanɨ. Nakweenda, neeriwa mʉtɨma mʉnʉmʉʉnʉ nɨ weewe.” ");
INSERT INTO lag_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yéesu ajáa afíkiirye myaaka makumi yatatʉ (30) de akaanda mʉrɨmo waachwe. Na vaantʉ viiririkanáa yeeye nɨ mwaana wa Yooséefu. Yooséefu nɨ mwaana wa Éeli ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Éeli nɨ mwaana wa Matáati ajáa. Matáati nɨ mwaana wa Láawi ajáa. Láawi nɨ mwaana wa Méliki ajáa. Méliki nɨ mwaana wa Yanái ajáa. Yanái nɨ mwaana wa Yooséefu ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yooséefu nɨ mwaana wa Matatía ajáa. Matatía nɨ mwaana wa Amóosi ajáa. Amóosi nɨ mwaana wa Nahúumu ajáa. Nahúumu nɨ mwaana wa Ésili ajáa. Ésili nɨ mwaana wa Nagáai ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagáai nɨ mwaana wa Máati ajáa. Máati nɨ mwaana wa Matatía ajáa. Matatía nɨ mwaana wa Semeíini ajáa. Semeíini nɨ mwaana wa Yoséeki ajáa. Yoséeki nɨ mwaana wa Yóoda ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yóoda nɨ mwaana wa Yoanáani ajáa. Yoanáani nɨ mwaana wa Réesa ajáa. Réesa nɨ mwaana wa Serubabéeli ajáa. Serubabéeli nɨ mwaana wa Searitiéeli ajáa. Searitiéeli nɨ mwaana wa Néeri ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Néeri nɨ mwaana wa Méliki ajáa. Méliki nɨ mwaana wa Áadi ajáa. Áadi nɨ mwaana wa Kosáamu ajáa. Kosáamu nɨ mwaana wa Elimadáamu ajáa. Elimadáamu nɨ mwaana wa Éeri ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Éeri nɨ mwaana wa Yooshʉ́a ajáa. Yooshʉ́a nɨ mwaana wa Elieséeri ajáa. Elieséeri nɨ mwaana wa Yoríimu ajáa. Yoríimu nɨ mwaana wa Matáati ajáa. Matáati nɨ mwaana wa Láawi ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Láawi nɨ mwaana wa Simeóoni ajáa. Simeóoni nɨ mwaana wa Yʉ́ʉda ajáa. Yʉ́ʉda nɨ mwaana wa Yooséefu ajáa. Yooséefu nɨ mwaana wa Yonáamu ajáa. Yonáamu nɨ mwaana wa Eliakíimu ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakíimu nɨ mwaana wa Meléa ajáa. Meléa nɨ mwaana wa Méena ajáa. Méena nɨ mwaana wa Matáasa ajáa. Matáasa nɨ mwaana wa Nasáani ajáa. Nasáani nɨ mwaana wa Daúdi ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daúdi nɨ mwaana wa Yéese ajáa. Yéese nɨ mwaana wa Obéedi ajáa. Obéedi nɨ mwaana wa Boáasi ajáa. Boáasi nɨ mwaana wa Salimóoni ajáa. Salimóoni nɨ mwaana wa Nashóoni ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashóoni nɨ mwaana wa Aminadáabu ajáa. Aminadáabu nɨ mwaana wa Adimíini ajáa. Adimíini nɨ mwaana wa Aráamu ajáa. Aráamu nɨ mwaana wa Hesiróoni ajáa. Hesiróoni nɨ mwaana wa Peréesi ajáa. Peréesi nɨ mwaana wa Yʉ́ʉda ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yʉ́ʉda nɨ mwaana wa Yaakúupu ajáa. Yaakúupu nɨ mwaana wa Isaka ajáa. Isaka nɨ mwaana wa Aburaháamu ajáa. Aburaháamu nɨ mwaana wa Téera ajáa. Téera nɨ mwaana wa Nahóori ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahóori nɨ mwaana wa Serúugi ajáa. Serúugi nɨ mwaana wa Réeu ajáa. Réeu nɨ mwaana wa Peléegi ajáa. Peléegi nɨ mwaana wa Ebéeri ajáa. Ebéeri nɨ mwaana wa Sáala ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sáala nɨ mwaana wa Kenáani ajáa. Kenáani nɨ mwaana wa Arɨfakisáadi ajáa. Arɨfakisáadi nɨ mwaana wa Shéemu ajáa. Shéemu nɨ mwaana wa Nʉ́hʉ ajáa. Nʉ́hʉ nɨ mwaana wa Lámeki ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lámeki nɨ mwaana wa Mesuséela ajáa. Mesuséela nɨ mwaana wa Enóoki ajáa. Enóoki nɨ mwaana wa Jeráadi ajáa. Jeráadi nɨ mwaana wa Mahalaléeli ajáa. Mahalaléeli nɨ mwaana wa Kenáani ajáa. ");
INSERT INTO lag_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenáani nɨ mwaana wa Enóoshi ajáa. Enóoshi nɨ mwaana wa Séeti ajáa. Séeti nɨ mwaana wa Adáamu ajáa, na Adáamu nɨ mwaana wa Mʉlʉʉngʉ ajáa. ");
INSERT INTO lag_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yéesu kʉnʉ ahókɨɨre Mʉtɨma Mʉʉja, akahɨndʉka fuma luujii lwa Yorodáani. Mʉtɨma Mʉʉja akamʉtwaala fʉʉrʉ ɨsɨ ya ibaláángwii. ");
INSERT INTO lag_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ʉko Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨkamʉyera Yéesu kwa sikʉ makumi yanɨ (40). Na kwa sikʉ joosi ijo sɨ arijáa kɨɨntʉ chochoosi tʉkʉ, aho akiiteera njala. ");
INSERT INTO lag_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aho, Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨkamʉsea, “Koonɨ ʉrɨ Mwaana wa Mʉlʉʉngʉ, lairirya iwye ɨrɨ rɨve mʉkáate.” ");
INSERT INTO lag_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yéesu akuuyirya, yoosea, “Masáare ˆYarɨ Mpeho yalʉʉsa jei, ‘Mʉʉntʉ sɨ arɨ kʉva nkaasʉ kwa vyóorya vii tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨkamʉtwaala Yéesu na haantʉ ˆhiinʉka harɨ ncholwii. Ʉko, rɨkamʉlaɨra kwa mpɨɨndɨ nduudi ntemi ja weerʉ yoosi. ");
INSERT INTO lag_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨkamʉsea, “Kʉheera ndɨrɨ nkongojima ya ntemi jaavo joosi na wiimiriri waavo, sa nkongojima na wiimiriri wa ntemi iji joosi naheewa nɨɨnɨ na ifaanaa nkamʉheera yoyoosi ˆnoosaaka. ");
INSERT INTO lag_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Haaha koonɨ wuunyinamɨɨre, ivi vyoosi kʉva viri vyaako.” ");
INSERT INTO lag_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yéesu akuuyirya, yoosea, “Masáare ˆYarɨ Mpeho yalʉʉsa jei, ‘Mwiinamɨre Ijʉva Mʉlʉʉngʉ waako vii, na ʉmʉtʉmamɨre yeemweene vii.’” ");
INSERT INTO lag_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Rɨkamʉtwaala Yéesu fʉʉrʉ múujii wa Yerusaléemu, ncholwiinchoolwii ya mʉnáara wa Kaaya Njija ya Ijʉva, maa rɨkamʉsea, “Koonɨ weewe ʉrɨ Mwaana wa Mʉlʉʉngʉ, ifweite na ɨsɨ fuma aha. ");
INSERT INTO lag_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sa Masáare ˆYarɨ Mpeho yalʉʉsa, ‘Mʉlʉʉngʉ tʉma arɨ mirimʉ yaachwe miija ɨkʉlamurirye, ");
INSERT INTO lag_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","yooyo kʉkwaatɨrɨra ɨrɨ mɨkonwii yaavo, sa karɨ ijeo raako jɨ riikunguvale iwyii tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yéesu akuuyirya, yoosea, “Masáare ˆYarɨ Mpeho yalʉʉsa jei, ‘Karɨ ʉmʉyéraa Ijʉva Mʉlʉʉngʉ waako tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ ˆrɨkahʉmʉle kʉmʉyera Yéesu kwa njɨra joosi ijo, maa rɨkamʉreka kwa mpɨɨndɨ. ");
INSERT INTO lag_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Aho, Yéesu akahɨndʉka na ɨsɨ ya Galiláaya ahókɨɨre lʉvɨro lwa Mʉtɨma Mʉʉja. Noyo masáare yaachwe yakeenera ɨsɨ joosi ˆjarɨɨngɨrɨra. ");
INSERT INTO lag_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ne akiindyáa vaantʉ sinagóogii jaavo na kɨra mʉʉntʉ amʉdʉʉmbáa. ");
INSERT INTO lag_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sikʉ ɨmwɨ, Yéesu akadoma na múujii wa Nasaréeti kʉʉntʉ ˆakʉrɨra. Na sikʉ ya Sabáato akɨɨngɨra na sinagóogii ja ˆvyeene iijʉvɨra. Akɨɨma sa asome Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akaheewa kɨtáabu cha Isáaya mʉláali na mʉtwe. Akakɨfotolola na akashaana haantʉ ˆhaandɨkwa, ");
INSERT INTO lag_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mʉtɨma wa Ijʉva nɨ mweeri yaanɨ ʉrɨ, sa aampaka makuta, nvariyʉle Masáare Maaja kwa vakɨva. Aantʉma nɨvawyɨɨre vaantʉ ˆvarɨ mʉnyololwii, kʉchʉngʉrɨrwa kwaavo, vahoku koona kwaavo kei, kʉvalamurirya vaantʉ ˆvakénderɨrwaa, ");
INSERT INTO lag_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kei, noo vavariyʉrɨra vaantʉ mwaaka wa Ijʉva yookʉʉja noo vatalarya vaantʉ vaachwe.” ");
INSERT INTO lag_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yéesu ˆakamarikirye soma, akakɨfota kɨra kɨtáabu, akamʉheera mʉtʉmami wa sinagóogi, maa akiikala. Vaantʉ voosi ˆvajáa aho, vakamutuurirya miiso. ");
INSERT INTO lag_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aho, akaanda lʉʉsɨka novo akavasea, “Isikʉ, aya Masáare ˆYarɨ Mpeho ˆmʉtéɨɨre, yakíimɨɨne.” ");
INSERT INTO lag_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Vaantʉ voosi ˆvajáa aho, vakamʉdʉʉmba kʉnʉ vahwáalɨɨre sa masáare ya nduwo ˆmeene alʉʉsáa. Viiyuryáa voosea, “Ʉhʉ sɨ arɨ mwaana wa Yooséefu tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ne akavasea, “Namányire kuungwyɨɨra mʉrɨ mpɨ́rɨ ɨhɨ, ‘Mwaanga ihorye mweeneevyo!’ Kei kʉʉnsea mʉrɨ, ‘Masáare ˆtateera watʉmama kʉra iturii ra Kaperenáumu, yatʉmame aha iturii kʉʉntʉ ˆwakʉrɨra.’” ");
INSERT INTO lag_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kei akavasea, “Kɨmaarɨ noovawyɨɨra, kusiina mʉláali na mʉtwe wa Ijʉva ˆarúmwaa kaayii kwaachwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kɨmaarɨ kaa noovawyɨɨra, mpɨɨndɨ ja Elía mʉláali na mʉtwe, mbula ɨjáa yɨɨma kwa myaaka ɨtatʉ na myeeri mʉsasatʉ, ɨsɨ yoosi ɨkava na njala ya imalo. Mpɨɨndɨ ijo, ɨsɨ ya Isiraéeli ɨjáa yatɨɨte valala ˆvamema maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Maa kaa, Elía sɨ atʉmwa baa kwa ʉmwɨ wa valala avo tʉkʉ. Yeeye atʉmwa kwa mʉlala ʉmwɨ wa múujii wa Seréputa ˆʉrɨ ɨsɨ ya Sidóoni. ");
INSERT INTO lag_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kei, mpɨɨndɨ ja Elíisha mʉláali na mʉtwe ɨsɨ ya Isiraéeli ɨjáa yatɨɨte vaantʉ ˆvarɨ foo ˆvarɨ na ʉlóónda. Baa jeyyo, kusiina baa ʉmwɨ waavo ajirʉlwa tʉkʉ, maa kaa, Naamáani vii fuma ɨsɨ ya Síria.” ");
INSERT INTO lag_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Vaantʉ voosi ˆvajáa aho sinagóogii ˆvakateere jeyyo, vakakorera nɨ nkalari. ");
INSERT INTO lag_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hahara, vakiinʉka, vakamufumya Yéesu na weerwii ya ituri raavo, vakamʉtwaala fʉʉrʉ nemwiinemwii ya lʉʉlʉ ˆlweene ituri raavo rɨjáa rajeengwa sa vamʉkʉndʉrɨre. ");
INSERT INTO lag_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Maa kaa, yeeye akalooka na katɨkatɨ yaavo, akiilookera. ");
INSERT INTO lag_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Aho, Yéesu akagirita na múujii wa Kaperenáumu ˆʉrɨ ɨsɨ ya Galiláaya. Ʉko, sikʉ ya Sabáato avakiindyáa. ");
INSERT INTO lag_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Vaantʉ vakahwaalala ʉvariyuli waachwe, sa ʉjáa watɨɨte wiimiriri. ");
INSERT INTO lag_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aho sinagóogii, kʉjáa kwatɨɨte mʉʉntʉ ˆajáa na murimʉ mʉvɨ. Ʉwo mʉʉntʉ akatʉlatʉʉla isóso yoosea, ");
INSERT INTO lag_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Haaka! Weewe Yéesu wa Nasaréeti, che woosaaka kʉrɨ suusu? Wuújire tʉmala wʉʉ? Nakʉmányire ʉrɨ ani weewe! Weewe ʉrɨ Mʉʉja wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yéesu akʉʉdalavya ʉra murimʉ mʉvɨ yoosea, “Kirinya sawu! Fuma kʉrɨ ʉhʉ mʉʉntʉ!” Ʉra murimʉ mʉvɨ ʉkamʉvayya ʉra mʉʉntʉ mbere yaavo baa mʉtamikya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vaantʉ voosi vakahwaalariwa maatʉkʉ vii, maa vakaanda kiiyurya voovo kwa voovo voosea, “Aya nɨ masáare che? Kwa wiimiriri na ngururu yoolairirya mirimʉ mɨvɨ ifume noyo yoofuma!” ");
INSERT INTO lag_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jeyyo, masáare ya Yéesu yakeenera kɨra haantʉ ɨsɨ ɨra. ");
INSERT INTO lag_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yéesu akafuma aho sinagóogii, maa akadoma fʉʉrʉ kaayii kwa Simóoni. ˆVakafike, vakamʉshaana mʉkwɨ wa Simóoni ajáa nchiirii aváirwe nɨ ndwáala, maa vakamʉloomba Yéesu amʉhorye. ");
INSERT INTO lag_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yéesu akamʉseeserera, maa akɨɨdalavya ɨra ndwáala. Hahara akahola ɨra ndwáala yaachwe, maa akaanda vatʉmamɨra. ");
INSERT INTO lag_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mpɨɨndɨ mwaasʉ ˆwakʉtʉmɨráa, vaantʉ voosi ˆvajáa na valwɨ́ɨrɨ ˆvajáa na ndwáala ˆjiísimiresimire, vakavareeta na kwa Yéesu. Akavɨɨka mɨkono yaachwe mweeri yaavo voosi na voosi vakahola. ");
INSERT INTO lag_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mirimʉ mɨvɨ yafumáa kwa vaantʉ ˆvarɨ foo, noyo yatʉláa isóso yoosea, “Weewe ʉrɨ Mwaana wa Mʉlʉʉngʉ!” Maa kaa, Yéesu ɨɨdalavyáa ɨreke lʉʉsa isáare roroosi sa ɨjáa yamányire yeeye noo Masía. ");
INSERT INTO lag_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lomʉtóondo yaachwe ˆkʉkeere, Yéesu akatamanya na haantʉ ˆharɨ kijiraawa. Mpuka nkʉʉlʉ ya vaantʉ ˆvakataange asiina, maa vakaanda mʉsaakɨra. ˆVakamoone vakaanda kʉmʉkɨtɨra sa achaale ʉko meevo. ");
INSERT INTO lag_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Maa kaa, Yéesu akavasea, “Nasaakwa nvariyʉle Masáare Maaja ya Ʉtemi wa Mʉlʉʉngʉ míijii yɨɨngɨ sa ɨkɨ noo ˆcheene natʉmwa jɨ ntʉmame.” ");
INSERT INTO lag_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jeyyo, Yéesu akatuuba variyʉla Masáare ˆYarɨ Mpeho masinagóogii ya Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sikʉ ɨmwɨ, Yéesu ajáa ɨɨma mbarɨmbarɨ ya iriva ra Genesaréeti, kʉnʉ yoovariyʉla isáare ra Mʉlʉʉngʉ. Vaantʉ ˆvarɨ foo vakamʉrɨɨngɨrɨra mpaka vakaanda kʉmʉfenyenkererya. ");
INSERT INTO lag_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aho, akoona mashʉ́wa ivɨrɨ ˆjiri mbarɨmbarɨ ya iriva. Ijo mashʉ́wa, vavúuvi vaachwe vajáa vakíimire noo kooyya njwaavu jaavo. ");
INSERT INTO lag_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yéesu akɨɨngɨra mashúwii ɨmwɨ. Ɨyo mashʉ́wa nɨ ya Simóoni ɨjáa. Yéesu akamʉloomba Simóoni ɨɨkʉndʉle kiduudi na luujii. Aho, Yéesu akiikala mashúwii, maa de ɨndookiindya mpuka ya vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ˆAkahʉmʉle kukiindya, maa akamʉsea Simóoni, “Hende, twaala mashʉ́wa na maajii malɨɨhɨ, aho, maa de mukiimye njwaavu jaanyu mʉkwaate soompa.” ");
INSERT INTO lag_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simóoni akamʉsea, “Aka Aaɨ, tatʉ́mamire chɨrɨrɨ baa turya kɨɨntʉ tʉkʉ. Maa kaa, kwa isáare raako kiimya ndɨrɨ njwaavu.” ");
INSERT INTO lag_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Simóoni na viivaachwe ˆvakakiimye njwaavu, vakakwaata soompa ˆjamema maatʉkʉ vii mpaka njwaavu jikaanda dʉmʉka. ");
INSERT INTO lag_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sa jeyyo, vakavaanɨrɨra viivaavo ˆvajáa na mashʉ́wa yɨɨngɨ, vʉʉje jɨ vavaambɨre. Vakʉʉja, vakamemya soompa mashʉ́wa joosi ivɨrɨ mpaka jikasengerera nyɨmɨra. ");
INSERT INTO lag_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simóoni Peéteri ˆakoone masáare ayo, akachwaama mbere ya Yéesu maa akasea, “Aaɨ Mʉkʉ́lʉ, looka kwaanɨ, nɨɨnɨ ndɨrɨ mʉvɨ.” ");
INSERT INTO lag_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simóoni na viivaachwe vajáa vahwáalariiwe maatʉkʉ nɨ soompa ˆngʼeene vajáa vakwáatire. ");
INSERT INTO lag_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Vɨɨngɨ ˆvajáa vahwaalala nɨ vala Yaakúupu na Yooháani vaana va Sebedáayo. Ava vatʉmamanʼyáa na Simóoni. Aho, Yéesu akamʉsea Simóoni, “Simóoni, koofa tʉkʉ, kwaandɨra haaha kʉva ʉrɨ muvúuvi wa vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ˆVakajitwaale mashʉ́wa na mbarɨmbarɨ ya iriva, vakareka kɨra kɨɨntʉ, vakamutuuba Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sikʉ ɨmwɨ, Yéesu ajáa atamanya na múujii ʉmwɨ. Ʉko, mʉʉntʉ ʉmwɨ ˆahaambwa nɨ ʉlóónda mʉvɨrɨ woosi akʉʉja na kʉrɨ Yéesu, akachwaama mbere yaachwe akiinamya kisho chaachwe fʉʉrʉ ɨsɨ. Akiiloombererya yoosea, “Aaɨ, koonɨ woosaaka, ifaanaa ʉkaanjirʉla ndwáala yaanɨ.” ");
INSERT INTO lag_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yéesu akiinurirya mʉkono waachwe, akamʉsaasya, kʉnʉ yoosea, “Noosaaka, ujirʉlwe!” Hahara, ʉlóónda ʉkafuma muvirii waachwe, akahola. ");
INSERT INTO lag_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aho, Yéesu akamʉlairirya yoosea, “Karɨ umuwyɨ́ɨraa mʉʉntʉ yoyoosi isáare ɨrɨ tʉkʉ, maa kaa, tamanya ukiiyónekye kwa mweeneɨsɨ wa Ijʉva, ʉtoole na mpóryo yo jirʉlwa, ja ˆvyeene Mʉ́sa alairirya, sa vataange kɨmaarɨ ʉhórire.” ");
INSERT INTO lag_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Baa jeyyo, masáare ya Yéesu yakaariwa kɨra haantʉ. Mpuka nkʉʉlʉ ja vaantʉ jiijiingáa kʉmʉteerera na vahoriwáa ndwáala jaavo. ");
INSERT INTO lag_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Maa kaa, Yéesu avarekáa na adomáa na kijiraawii noo mʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sikʉ ɨmwɨ, Yéesu avavariyʉrɨráa vaantʉ Masáare ˆYarɨ Mpeho. Vamwɨ va vaantʉ vamʉteereráa, nɨ Mafarisáayo na vakiindya va Miiro vajáa. Avo Mafarisáayo na vakiindya vajáa vafuma kɨra ituri ra Galiláaya, Yudéea na múujii wa Yerusaléemu. Lʉvɨro lwa Ijʉva nɨ na Yéesu lʉjáa sa ahorye vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Vaantʉ vamwɨ vakʉʉja viínwɨɨre mʉlwɨ́ɨrɨ ʉmwɨ na ndɨrɨ yaachwe. Ʉhʉ mʉlwɨ́ɨrɨ ajáa aakwya iyandiyandi. Vakasaaka vamwiingirye na nyuumbii kʉʉntʉ ˆajáa Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Maa kaa, vakasiindwa kumwiingirya sa vaantʉ vajáa vamémire mʉnʉmʉʉnʉ. Aho, vakaambʉka nɨ ikekeerii, vakabontola ikekeera hara kʉʉntʉ Yéesu ˆajáa, vakamukiimirya ʉra mʉlwɨ́ɨrɨ na ndɨrɨ yaachwe, maa vakamʉvɨɨka heehi na Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yéesu ˆakoone kuruma kwaavo, akamʉsea ʉra mʉlwɨ́ɨrɨ, “Aaɨ, ʉvɨ waako wasírire.” ");
INSERT INTO lag_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aho, vakiindya va Miiro na Mafarisáayo vakaanda kiiyurya voosea, “Nɨ ani ʉhʉ yoolʉʉsa masáare yo mʉhɨɨntɨkɨra Mʉlʉʉngʉ? Kusiina wɨɨngɨ ˆadáhaa sea ʉvɨ wasírire tʉkʉ, nɨ Mʉlʉʉngʉ yeemweene vii.” ");
INSERT INTO lag_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yéesu akataanga kwiiririkana kwaavo. Aho akavasea, “Nɨ sa che mookiiririkana ayo mitimii yaanyu? ");
INSERT INTO lag_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Eri, nɨ kɨrɨkwɨ noo chaangʉ kʉlookya myeewe, kʉmʉsea ʉhʉ mʉlwɨ́ɨrɨ, ‘Ʉvɨ waako wasírire,’ bakʉ kʉmʉsea, ‘Inʉka, ʉlooke’? ");
INSERT INTO lag_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Haaha noosaaka mʉtaange, Mwaana wa Mʉʉntʉ atɨɨte wiimiriri wo sea vaantʉ aha weerwii, ‘Ʉvɨ waavo wasírire.’” Aho, akamʉsea ʉra mʉʉntʉ ˆaakwya iyandiyandi, “Nookʉsea, inʉka, toola ndɨrɨ yaako, ʉdome na kaayii kwaako.” ");
INSERT INTO lag_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hahara, ʉra mʉʉntʉ akɨɨma mbere ya vaantʉ voosi, akatoola ndɨrɨ yaachwe, maa akadoma na kaayii kwaachwe kʉnʉ yoomʉdʉʉmba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vaantʉ voosi vakahwaalala maatʉkʉ vii na vakakwaatwa nɨ woowa kʉnʉ voomʉdʉʉmba Mʉlʉʉngʉ vakasea, “Isikʉ tɨɨ́ne masáare ˆyahwáalaryaa!” ");
INSERT INTO lag_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ayo ˆyakalooke, Yéesu akafuma na weerwii ya múuji. Ʉko akamoona mʉsaankanʼyi kóodi ʉmwɨ ˆasewáa Láawi iíkyɨɨre kɨvaandii cho rɨhɨra kóodi, yoosaankanʼya kóodi. Aho, akamʉsea, “Ntuuba!” ");
INSERT INTO lag_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ne Láawi akiinʉka, akareka kɨra kɨɨntʉ, maa akamutuuba Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na Láawi akamʉbweeyyirya Yéesu ngovi nkʉʉlʉ aho kaayii kwaachwe. Mpuka nkʉʉlʉ ya vasaankanʼyi kóodi na vaantʉ vɨɨngɨ vakiikala kurya ne chákurya. ");
INSERT INTO lag_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Maa kaa, Mafarisáayo na vakiindya va Miiro vakavangʼʉʉrɨra vapooji vaachwe voosea, “Sa che moorya no nywa hamwɨ na masaankanʼyi kóodi na maduwalo?” ");
INSERT INTO lag_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yéesu ˆakayateere ayo masáare, maa akavasea, “Vaantʉ ˆvarɨ nkaasʉ sɨ vasáakaa mwaanga tʉkʉ, maa kaa, valwɨ́ɨrɨ noo vasáakaa mwaanga. ");
INSERT INTO lag_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sɨ nʉʉja joo kaanɨrɨra vaantʉ ˆviiyónaa nɨ vawoloki tʉkʉ, nʉʉja joo kaanɨrɨra vavɨ sa vamʉvalandʉkɨre Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aho, vakamuurya Yéesu voosea, “Vapooji va Yooháani na va Mafarisáayo viirékyaa kurya so mʉloomba Mʉlʉʉngʉ. Maa kaa, amwɨ vapooji vaako nɨ varíjaa no nywa vii kɨra siikʉ?” ");
INSERT INTO lag_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yéesu akavasea, “Eri, ifaanaa mʉkavabweeyya vaantʉ ˆvaláarikirwe na ngovi ya ilóola na mweenengovi ntɨ ˆarɨ novo viirekye kurya wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Maa kaa, mpɨɨndɨ luu kʉʉja jiri, mweenengovi luu sʉmʉlwa arɨ, aho noo vakiirekiirye kurya.” ");
INSERT INTO lag_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aho, maa Yéesu akavavaɨra lusímo ʉlʉ, “Kusiina mʉʉntʉ ˆakéraa kɨráka fuma ɨngo ifya sa achʉmɨre isaámʉ tʉkʉ. Koonɨ abwéeyyiirye jeyyo, kʉva arɨ amwɨ́ɨre ɨngo ifya na ɨkyo kɨráka kifya sɨ kɨrɨ kiifwaanɨrɨra na ɨro isaámʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kei, kusiina mʉʉntʉ ˆavɨ́kɨraa diváai ifya viríibii vya kalɨ tʉkʉ. Koonɨ abwéeyyiirye jeyyo, ɨyo diváai pʉsʉla ɨrɨ ivyo viríiba, diváai kɨɨtɨka ɨrɨ na viríiba saambʉka viri. ");
INSERT INTO lag_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Diváai ifya nɨ viríibii vifya ɨvɨ́kɨrwaa. ");
INSERT INTO lag_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Baa kusiina mʉʉntʉ ˆasáakaa kʉnywa diváai ifya koonɨ anywíire ɨra ya kalɨ tʉkʉ, sa aséaa, ‘Ɨra ya kalɨ noo yabooha kʉlookya.’” ");
INSERT INTO lag_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sikʉ ya Sabáato ɨmwɨ, Yéesu na vapooji vaachwe vajáa vakwaatɨra na mawundii ya ngáano. Mpɨɨndɨ ˆvalookáa, vapooji vaachwe vakava voohʉʉnga maangala ya ngáano, vakayafiisa de vandoorya. ");
INSERT INTO lag_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Vamwɨ va Mafarisáayo vakasea, “Eri, sa che moowuna Miiro sikʉ ya Sabáato?” ");
INSERT INTO lag_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Aho, maa Yéesu akavasea, “Sɨ mʉnasoma ˆcheene atʉmama mʉtemi Daúdi mpɨɨndɨ ˆajáa aávirwe nɨ njala na vaantʉ vaachwe tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daúdi ɨɨngɨra na nyuumbii ya Mʉlʉʉngʉ, akatoola ɨra mɨkáate ˆɨvɨ́ɨkwaa mbere ya Mʉlʉʉngʉ, akarya. Mɨkáate ɨyo, veeneɨsɨ va Ijʉva vii noo vajáa varekerwa vɨndoorya. Vaantʉ vɨɨngɨ Miiro ɨjáa yakaanʼya kurya. Ne akavaheera vaantʉ vaachwe, vakarya.” ");
INSERT INTO lag_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aho, Yéesu akavasea, “Mwaana wa Mʉʉntʉ nɨ Mweeneevyo wa Sabáato.” ");
INSERT INTO lag_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sikʉ ya Sabáato yɨɨngɨ, Yéesu ajáa ɨɨngɨra na sinagóogii, maa akaanda kiindya. Aho, kʉjáa kwatɨɨte mʉʉntʉ ˆajáa na mʉkono wa kʉlʉme ˆwaakwya iyandiyandi. ");
INSERT INTO lag_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Vakiindya va Miiro na Mafarisáayo vakava voomʉlaanga neeja sa voone koonɨ arɨ mʉhorya sikʉ ya Sabáato. Vabweeyyáa jeyyo sa vapate nkalo yo mʉtwaala na balásii. ");
INSERT INTO lag_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Maa kaa, Yéesu ajáa atáangire miiririkano yaavo, aho akamʉsea ʉra mʉʉntʉ ˆajáa na mʉkono ˆwaakwya iyandiyandi, “Seesa, ɨma aha mbere ya vaantʉ.” Ʉra mʉʉntʉ akiinʉka, maa akɨɨma mbere ya vaantʉ voosi. ");
INSERT INTO lag_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aho, maa Yéesu akavasea, “Nɨ kuvuurya niise, nɨ rɨrɨkwɨ noo Miiro ˆyaruma kʉtʉmama sikʉ ya Sabáato? Kʉtʉmama kɨɨntʉ kiija bakʉ kɨvɨ? Kʉlamurirya nkaasʉ au kʉmala?” ");
INSERT INTO lag_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aho, akavalaanga vaantʉ voosi, maa akamʉsea ʉra mʉʉntʉ, “Wolola mʉkono waako!” Ʉra mʉʉntʉ akabweeyya jeyyo, hahara mʉkono waachwe ʉkava nkaasʉ kei! ");
INSERT INTO lag_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Maa kaa, vara vakiindya va Miiro na Mafarisáayo vakakalala maatʉkʉ vii, vakaanda kiiheera mɨryʉʉngʉ voovo kwa voovo ˆcheene varɨ mʉbweeyya Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sikʉ ɨmwɨ, Yéesu ajáa aambʉka na luulwii noo mʉloomba Mʉlʉʉngʉ. Ʉko akamʉloomba Mʉlʉʉngʉ chɨrɨrɨ. ");
INSERT INTO lag_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ˆKʉkeere, maa akavaanɨrɨra vapooji vaachwe. Aho, akavasaawʉla ikimi na vavɨrɨ, avo akavakemera vatumwi. ");
INSERT INTO lag_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ava noo vatumwi ˆasaawʉla, Simóoni, yeeye amʉkemera Peéteri, na Anderéa mwaanaavo, Yaakúupu na Yooháani, Filíipi na Batolomáayo, ");
INSERT INTO lag_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matáayo na Tomáasi, Yaakúupu sha Alʉfáayo na Simóoni ˆmweene aanɨrɨrwáa Selóote, ");
INSERT INTO lag_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yʉ́ʉda sha Yaakúupu, na Yʉ́ʉda Isikarióoti ˆamʉvarindʉka Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yéesu akakiima fuma luulwii hamwɨ na vatumwi vaachwe. Na ˆakafike haantʉ ˆharɨ na irɨrɨɨsɨ, akɨɨma. Aho, kʉjáa kwatɨɨte mpuka nkʉʉlʉ ya vapooji vaachwe na vaantʉ ˆvajáa vafúmire ɨsɨ yoosi ya Yudéea, múujii wa Yerusaléemu, na mbarɨmbarɨ ya mayɨya ya míiji ya Tíiro na Sidóoni. Ava, vajáa vuújire noo mʉteerera Yéesu na vahoriwe ndwáala jaavo. ");
INSERT INTO lag_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na vara ˆvaturikiriwáa nɨ mirimʉ mɨvɨ, avahoryáa. ");
INSERT INTO lag_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Vaantʉ voosi vasaakáa kʉmʉsaasya sa ngururu ˆjafumáa kwaachwe na avahoryáa vaantʉ voosi. ");
INSERT INTO lag_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yéesu akavalaanga vapooji vaachwe akasea, “Mwatalariwa nyuunyu ˆmʉrɨ vakɨva, sa Ʉtemi wa Mʉlʉʉngʉ nɨ waanyu. ");
INSERT INTO lag_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mwatalariwa nyuunyu ˆmʉrɨ na njala haaha, sa kiikutiwa mʉrɨ. Mwatalariwa nyuunyu ˆmoorɨra haaha, sa seka mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mwatalariwa nyuunyu mpɨɨndɨ vaantʉ ˆvarɨ vasʉʉla, ˆvarɨ vakera lʉtaamɨ na kʉvatʉkɨra, na ˆvarɨ vasea mʉrɨ vavɨ, sa mwamuruma Mwaana wa Mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sikʉ masáare aya ˆyarɨ fʉmɨra, eryi mɨtɨma na mʉndoofɨrɨra sa kʉnáálo yaanyu nɨ nkʉ́ʉ́lʉ kurumwii, sa baa vala baaba waavo vavabweeyyirirya viivyo valáali na mʉtwe va Ijʉva. ");
INSERT INTO lag_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Maa kaa, mpolaɨ nyuunyu ˆmʉrɨ vasúngaati, sa kutuurya mɨtɨma kwaanyu mwahʉmʉla kʉkʉhokera. ");
INSERT INTO lag_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mpolaɨ nyuunyu ˆmwiíkutire haaha, sa kwaavwa mʉrɨ nɨ njala. Mpolaɨ nyuunyu ˆmooseka na cheerʉ haaha, sa rɨra mʉrɨ na rɨra mʉrɨ no myaa. ");
INSERT INTO lag_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mpolaɨ nyuunyu vaantʉ voosi ˆvakavadʉ́ʉmbɨrɨraa, sa baa vala baaba vaavo viivyo vavadʉʉmbɨrɨráa, valáali na mʉtwe va ʉloongo. ");
INSERT INTO lag_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Maa kaa, nɨ vawyɨɨra niise nyuunyu vara ˆmookʉʉnteerera, veendi vavɨ vaanyu. Vabweeyyiryi wʉʉja vara ˆvavasʉʉla. ");
INSERT INTO lag_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Vatalaryi vara ˆvavajúmaa, na vara ˆvavabwéeyyiryaa mavɨ valoomberi kwa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Koonɨ mʉʉntʉ akʉváire lʉsayya lwa ivaru rɨmwɨ, mʉvarindʉrɨre na lwa ivaru rɨɨngɨ. Koonɨ mʉʉntʉ akʉhókire ikóoti raako, kʉmʉsɨɨtɨra isháati raako tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mʉʉntʉ yoyoosi ʉra ˆyookʉloomba kɨɨntʉ, mʉheere. Kei, koonɨ mʉʉntʉ akʉhókire máari jaako, karɨ ʉdáayyaa akʉhɨndʉrɨre tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mʉndoovabweeyyirya vɨɨngɨ ja ˆvyeene nyuunyu moosaaka vandoovabweeyyirya. ");
INSERT INTO lag_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Koonɨ mʉveéndire vii vara ˆvaveenda nyuunyu, nɨ kʉnáálo che mʉrɨ turya? Amwɨ baa vaduwalo vaveenda vara ˆvaveenda voovo vii! ");
INSERT INTO lag_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kei, koonɨ mʉvabwéeyyiriirye maaja vara ˆvavabwéeyyiryaa wʉʉja vii, nɨ kʉnáálo che mooturya? Amwɨ baa vaduwalo vabweeyya viivyo! ");
INSERT INTO lag_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Koonɨ moovakopesha vara ˆmookiilaangya rɨha varɨ, nɨ kʉnáálo che moopata? Baa vaduwalo vavakópeshaa vaduwalo viivaavo kʉnʉ vookiilaangya hɨndʉrɨrwa varɨ vyoosi ˆvakopesha. ");
INSERT INTO lag_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Maa kaa, nyuunyu mʉveende vavɨ vaanyu, na mʉndoovabweeyyirya wʉʉja. Kei, mʉndoovakopesha baa kiilaangya hɨndʉrɨrwa mʉrɨ tʉkʉ. Koonɨ mʉbwéeyyiirye jeyyo, ˆArɨ Mweerimweeri varɨha arɨ marɨho makʉʉlʉ. Kei, kʉva mʉrɨ vaana vaachwe sa yeeye aboohya kwa vara sɨ ˆvadʉ́ʉmbaa na vavɨ. ");
INSERT INTO lag_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sa jeyyo, mʉve na mbavariri ja Taáta waanyu ˆvyeene arɨ na mbavariri. ");
INSERT INTO lag_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Karɨ mʉlámʉrɨraa tʉkʉ, de baa nyuunyu mʉdɨɨre kʉndoolamʉrɨrwa. Karɨ mʉlʉ́ʉsaa irya tʉkʉ, de baa nyuunyu mʉdɨɨre kʉndoolʉʉsɨrwa irya. Mʉndoovasea viivaanyu yasírire, sa baa nyuunyu mʉndoosewa yasírire. ");
INSERT INTO lag_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mʉboohye ɨnda, aho naanyu heewa mweende. Kɨkomi, heewa mweende vipíimo ˆvyamema, vikasʉngʉsɨrwa mpaka vindookɨɨtɨkɨrɨra. Sa kipíimo kɨkɨra ˆmoopiimɨra vaantʉ vɨɨngɨ, noo ˆmʉrɨ piimɨrwa!” ");
INSERT INTO lag_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yéesu akavavaɨra lusímo ʉlʉ, akavasea, “Eri, mʉhoku ifaanaa amʉlongoole mwiiwaachwe wʉʉ? Kɨkomi voosi bʉrʉkɨra varɨ na iduundwii. ");
INSERT INTO lag_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mʉpooji sɨ arɨ mʉlookerera mukiindya waachwe tʉkʉ. Maa kaa, mʉpooji ʉra ˆahʉmʉla kiindiwa yoosi ifaanaa akadaha kʉva ja mukiindya waachwe. ");
INSERT INTO lag_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Amwɨ woolaanga kajʉla karɨ riiswii ra mwaanaanyu na ʉlɨ sɨ wookoona mpóngoola ˆɨrɨ riiswii raako? ");
INSERT INTO lag_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Joolɨ ʉrɨ mʉsea mwaanaanyu, ‘Mwanawiitʉ, tʉʉla nɨkʉseyye kajʉla riiswii raako,’ kʉnʉ weewe sɨ wookoona mpóngoola ˆɨrɨ riiswii raako? Weewe mʉkweembi! Seyya ta mpóngoola riiswii raako, de woone neeja na ʉdahe seyya kajʉla riiswii ra mwaanaanyu. ");
INSERT INTO lag_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kusiina mʉtɨ ˆwabooha ˆwatʉ́ʉngaa ndɨɨwa ˆjavɨɨha tʉkʉ, na kusiina mʉtɨ ˆwavɨɨha ˆwatʉ́ʉngaa ndɨɨwa ˆjabooha tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vaantʉ vʉʉtáangaa mʉtɨ kwa ndɨɨwa jaachwe. Vaantʉ sɨ vatʉ́ʉndaa saambu mihuungii tʉkʉ na sɨ vatʉ́ʉndaa sabíibu mbiirii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Noo jeyyo viri, mʉʉntʉ mʉʉja afúmyaa maaja fuma máari jaachwe ja kɨkomi ja mberii ja mutimii waachwe mʉʉja. Na mʉʉntʉ mʉvɨ afúmyaa mavɨ fuma mutimii waachwe mʉvɨ. Sa viintʉ ˆvyamema mutimii wa mʉʉntʉ, noo mʉlomo waachwe ʉlʉ́ʉsaa. ");
INSERT INTO lag_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sa che mookʉʉnyanɨrɨra, ‘Mʉkʉ́lʉ, Mʉkʉ́lʉ!’ amwɨ sɨ mootʉmama yara ˆnoovawyɨɨra? ");
INSERT INTO lag_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mʉʉntʉ yoyoosi ˆʉʉ́jaa na kʉrɨ nɨɨnɨ na ˆatéereraa no yakwaatya masáare yaanɨ, iifwɨ́ɨne na lusímo ʉlʉ, ");
INSERT INTO lag_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","yeeye nɨ ja mʉʉntʉ ˆajeengáa nyuumba, maa kaa, de aande jeenga, ajáa avɨɨka mwaariryo isii ya iduundu ˆrɨjáa rasiimbwa fʉʉrʉ mwaalaliwyii. Mbula ˆɨkavae na lʉʉjɨ lʉkʉʉlʉ ˆlukiike mpaka lʉkamoola ikɨko ra iboote, maaji yakakʉngʼʉntɨka na nyuumbii kwaachwe. Maa kaa, sa viintʉ nyuumba ɨra ɨjáa yajeengwa vyabooha, ayo maaji sɨ yadaha baa kwiisingisya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Maa kaa, ʉra ˆatéeraa masáare yaanɨ baa yakwaatya tʉkʉ, nɨ ja mʉʉntʉ ˆajeenga nyuumba yaachwe ichuúkii baa siimba no vɨɨka mwaariryo tʉkʉ. Na maaji ˆyakabomole ikɨko ra maaji na maaji ˆyakakʉngʼʉntɨke na nyuumbii yaachwe, hahara nyuumba yaachwe yaawya, na ɨkabomoka vʉʉ!” ");
INSERT INTO lag_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yéesu ˆakahʉmʉle lʉʉsa masáare ayo yoosi kʉnʉ vaantʉ voomʉteerera, maa akadoma na múujii wa Kaperenáumu. ");
INSERT INTO lag_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aho múujii, kwajáa kwatɨɨte mʉkʉ́ʉ́lʉ ʉmwɨ wa valwi nkoondo. Ʉhʉ mʉkʉ́ʉ́lʉ ajáa atɨɨte mʉtʉmami waachwe ˆajáa amweendamweenda. Haaha ʉhʉ mʉtʉmami ajáa alwaala sengerera akwye. ");
INSERT INTO lag_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ʉwo mʉkʉ́ʉ́lʉ wa valʉkalʉka ˆakateere masáare ya Yéesu, akatʉma vawosi va Kɨyahúudi vadome na kwa Yéesu, vakamʉloombe ʉʉje jɨ amʉhorye mʉtʉmami waachwe. ");
INSERT INTO lag_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Novo ˆvakafike kwa Yéesu, vakamʉkalaamya mʉnʉmʉʉnʉ voosea, “Koonɨ kʉrɨ na mʉʉntʉ ˆavalwa ɨɨma neeja kwaambiririwa, nɨ ʉhʉ. ");
INSERT INTO lag_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yeeye eenda ɨsɨ yiitʉ, baa kei noo atʉjeengera sinagóogi.” ");
INSERT INTO lag_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aho, maa Yéesu akadomanʼya novo. Maa kaa, viintʉ ˆajáa akaarɨ kʉlɨ kʉlɨ na nyuumba ya ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo, ʉra mʉkʉ́ʉ́lʉ akatʉma vijeengi vyaachwe vakamʉsee Yéesu, “Aaɨ mʉkʉ́lʉ, karɨ ujuuwɨke tʉkʉ, nɨɨnɨ sɨ navalwa nɨɨma neeja kʉkʉteengya weewe wɨɨngɨre nyuumbii kwaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ɨkɨ noo ˆchooreka, niiyɨɨ́ne sɨ navalwa nɨɨma neeja kʉʉja na kwaako tʉkʉ. Maa kaa, lʉʉsa isáare vii na mʉtʉmami waanɨ ahole. ");
INSERT INTO lag_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sa nɨɨnɨ nɨ mʉʉntʉ ˆnavɨɨkwa ɨsɨ ya wiimiriri, baa kei natɨɨte valwi nkoondo ɨsɨ yaanɨ. Koonɨ namʉséire ʉhʉ ‘Doma,’ adómaa na wɨɨngɨ ‘Ʉja,’ ne ʉʉ́jaa. Koonɨ namʉséire mʉtʉmami waanɨ ‘Bweeyya ɨkɨ,’ yeeye abwéeyyaa.” ");
INSERT INTO lag_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yéesu ˆakateere ayo masáare, akahwaalala mʉnʉmʉʉnʉ, akiilorera akɨɨlaanga ɨra mpuka ˆyamutuubáa, maa akavasea, “Noovawyɨɨra, sɨ nɨnoona kuruma ja ʉkʉ baa kʉrɨ ɨsɨ yoosi ya Isiraéeli tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na vara vaantʉ ˆvajáa vatúmirwe noo mwaanɨrɨra Yéesu ˆvakahɨndʉke na kaayii kwa mʉkʉ́ʉ́lʉ wa valʉkalʉka, vakamʉshaana ʉra mʉtʉmami ahórire. ");
INSERT INTO lag_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mpɨɨndɨ kiduudi, Yéesu akadoma na múujii ʉmwɨ, ˆʉséwaa Náini. Ʉko ajáa adomanʼya na vapooji vaachwe na mpuka nkʉʉlʉ ya vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ˆAkasengerere mutiryaangwii wa múuji, akalʉmana na mpuka ya vaantʉ viínwɨɨre mʉvɨrɨ wa mʉtavana ˆajáa awʉ́lɨɨre vootwaala noo taaha. Ʉhʉ mʉtavana noo mwaana ʉmwɨ vii wa mʉlala ʉmwɨ ajáa. Vaantʉ ˆvarɨ foo fuma múuji ʉwo nɨ hamwɨ vajáa na ʉwo mʉʉntʉ muki. ");
INSERT INTO lag_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yéesu Mweenevyoosi ˆakamoone ʉwo maáma mʉlala, akamoonera mbavariri, maa akamʉsea, “Rɨra tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yéesu akaseesa na heehi ya kɨtáanda, akakɨsaasya, maa vara vaantʉ ˆvajáa viínwɨɨre vakɨɨma. Aho, akasea, “Mʉtavana, nakʉséire inʉka!” ");
INSERT INTO lag_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ʉwo mʉtavana ˆajáa awʉ́lɨɨre, akiinʉka, akaanda lʉʉsɨka. Aho, Yéesu akamʉkwaatya íyo waavo. ");
INSERT INTO lag_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Vaantʉ voosi ˆvajáa aho, vakakwaatwa nɨ woowa, vakaanda mʉdʉʉmba Mʉlʉʉngʉ voosea, “Mʉláali na mʉtwe mʉkʉʉlʉ uújire na kʉrɨ suusu! Mʉlʉʉngʉ uújire noo vaambirirya vaantʉ vaachwe.” ");
INSERT INTO lag_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Masáare aya ya Yéesu yakeenera ɨsɨ yoosi ya Yudéea na ɨsɨ joosi ˆjiri mʉkaaya. ");
INSERT INTO lag_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Vapooji va Yooháani Mʉbatisáaji vakamuwyɨɨra masáare yoosi ˆyatʉmamwáa nɨ Yéesu. Yooháani akavaanɨrɨra vapooji vaachwe vavɨrɨ, ");
INSERT INTO lag_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","akavatʉma kwa Yéesu Mweenevyoosi vakamuurye jei, “Eri, weewe noo ʉra ˆalʉʉswa nɨ valáali na mʉtwe ˆyookʉʉja bakʉ tʉwoojere wɨɨngɨ?” ");
INSERT INTO lag_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Vara vapooji ˆvakafike kʉrɨ Yéesu, maa vakasea, “Yooháani Mʉbatisáaji atʉtʉ́mɨre tukuurye, ‘Eri, weewe noo ʉra ˆalʉʉswa nɨ valáali na mʉtwe ˆwookʉʉja bakʉ tʉwoojere wɨɨngɨ?’” ");
INSERT INTO lag_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mpɨɨndɨ ɨʼɨra Yéesu ajáa ahorya vaantʉ ndwáala, na ʉlwɨ́ɨrɨ waavo. Vara ˆvajáa na mirimʉ mɨvɨ akavahorya, na vahoku ˆvarɨ foo akavabweeyya voone. ");
INSERT INTO lag_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aho, maa Yéesu akavasea vara ˆvajáa vatúmirwe, “Tamanyi mʉkamʉwyɨɨre Yooháani yoosi ˆmwiiyónɨɨre na ˆmʉyatéɨɨre. Vahoku vookoona, vivete vooyeenda, ˆvarɨ na ʉlóónda voojirʉlwa, vimatu vooteera, vaantʉ ˆvaakwya voofʉfʉlwa na kei vakɨva voovariyʉrɨrwa Masáare Maaja. ");
INSERT INTO lag_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Atalariwa ʉra sɨ ˆarɨ hɨtwahɨtwa sa nɨɨnɨ.” ");
INSERT INTO lag_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Vara vapooji va Yooháani ˆvakalooke, maa Yéesu akaanda kʉvawyɨɨra vara vaantʉ masáare ya Yooháani yoosea, “Nɨ che mwɨɨtáa laanga kʉra ɨsɨ ya ibaláángwii? Isaanga ˆrooringiwaringiwa nɨ mpeho wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Koonɨ sɨ jeyyo, nɨ che mwɨɨtáa laanga? Mʉʉntʉ ˆiirwíikire ɨngo ja iyoombe ikʉʉlʉ wʉʉ? Aka tʉkʉ, vaantʉ ˆviirwɨ́ɨkaa ɨngo ja iyoombe ikʉʉlʉ na ˆvarɨ na kɨra kɨɨntʉ ˆchabooha nɨ nyuumbii ja kɨtemi viíkalaa. ");
INSERT INTO lag_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Haaha nɨ che mwɨɨtáa koo laanga? Nɨ mʉláali na mʉtwe mwɨɨtáa ko laanga wʉʉ? Kɨkomi, noovawyɨɨra nɨ kʉlookya mʉláali na mʉtwe mwɨɨtáa ko laanga. ");
INSERT INTO lag_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ʉhʉ noo masáare yaachwe ˆyaandɨkwa Masáarii ˆYarɨ Mpeho, ‘Laanga, mʉtʉma ndɨrɨ mutumwi waanɨ akʉlongorɨre, yeeye kʉtengenesherya arɨ njɨra yaako.’” ");
INSERT INTO lag_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kei Yéesu akasea, “Nɨ vawyɨɨra niise, kwa vaantʉ voosi kusiina ˆarɨ mʉkʉʉlʉ kʉlookya Yooháani tʉkʉ. Maa kaa, ʉra ˆarɨ muduudiduudi Ʉtemii wa Mʉlʉʉngʉ, noo mʉkʉʉlʉ kʉlookya Yooháani.” ");
INSERT INTO lag_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Vaantʉ voosi, hamwɨ na vasaankanʼyi kóodi vajáa vateera ayo masáare ya Yéesu. Vakaruma mʉryʉʉngʉ ˆiímyaa Mʉlʉʉngʉ nɨ mʉwoloki na avo noo vara ˆvajáa vabatisiwa nɨ Yooháani. ");
INSERT INTO lag_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Maa kaa, Mafarisáayo na vakiindya va Miiro sɨ vajáa vabatisiwa nɨ Yooháani tʉkʉ. Voovo vajáa vasiita mʉryʉʉngʉ Mʉlʉʉngʉ ˆajáa aviimirya. ");
INSERT INTO lag_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Aho, Yéesu akavasea, “Na che ndɨrɨ kɨɨfwaanirirya mbyaala ɨhɨ? Nɨ na che yiifwɨ́ɨne mbyaala ɨhɨ? ");
INSERT INTO lag_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mbyaala ɨhɨ yiifwɨ́ɨne na vasinga viíkyɨɨre isóokwii de vandookiisea, ‘Tavaváɨɨre firíimbi, nyuunyu baa bwɨɨta tʉkʉ! Tavɨɨ́mbɨɨre nyɨɨ́mbo ja ʉsʉʉngʉ, nyuunyu baa rɨra tʉkʉ!’ ");
INSERT INTO lag_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sa Yooháani Mʉbatisáaji ʉʉja, sɨ arijáa mʉkáate baa kei sɨ anywijáa diváai tʉkʉ, nyuunyu mʉkasea, ‘Atɨɨte murimʉ mʉvɨ!’ ");
INSERT INTO lag_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Maa kaa, Mwaana wa Mʉʉntʉ ʉʉja, yoorya no nywa, nyuunyu mʉkasea, ‘Mʉlaangi ʉhʉ, mwaafu na mʉreevi, mare ya vasaankanʼyi kóodi na vaduwalo.’ ");
INSERT INTO lag_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Baa neembe nɨ jeyyo, tooti ya Mʉlʉʉngʉ yiiyónekiirye kɨkomi nɨ ya ʉwoloki kwa vaana vaachwe voosi.” ");
INSERT INTO lag_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sikʉ ɨmwɨ, Mʉfarisáayo ʉmwɨ ˆasewáa Simóoni ajáa amʉteengya Yéesu noo rya chákurya kaayii kwaachwe. Yéesu akatamanya na kaayii kwa ʉwo Mʉfarisáayo, maa akiikala kurya chákurya. ");
INSERT INTO lag_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Haaha, aho múujii kʉjáa kwatɨɨte mʉʉntʉ muki ʉmwɨ ˆajáa mʉvɨ. Ʉwo mʉʉntʉ muki ˆakataange Yéesu amwaarɨ yoorya chákurya kwa Mʉfarisáayo, akatoola chʉ́pa ya iwye ˆɨrɨ na makuta ˆyanyʉ́kɨraa ya iyoombe ikarɨ. ");
INSERT INTO lag_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ˆAkafike, akɨɨma nyuma heehi na majeo ya Yéesu. Akaanda rɨra na miísoori yaachwe yandoowyɨɨra majewii ya Yéesu, de ɨndoomʉhonola Yéesu na njwɨɨrɨ jaachwe. Akatuuba sʉndɨra majeo ya Yéesu na akayahaka yara makuta. ");
INSERT INTO lag_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ʉra Mʉfarisáayo ˆajáa amʉtéengiirye Yéesu ˆakoone jeyyo, akaanda kiiririkana mutimii waachwe yoosea, “Ngaarɨ ʉhʉ mʉʉntʉ nɨ mʉláali na mʉtwe wa Ijʉva, ngaarɨ amányire ʉhʉ mʉʉntʉ muki yoomʉkwaata nɨ joolɨ ˆarɨ, na ngaarɨ amányire nɨ mʉvɨ.” ");
INSERT INTO lag_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Aho, maa Yéesu akamʉsea ʉra Mʉfarisáayo, “Simóoni, natɨɨte isáare ˆnoosaaka nɨkʉwyɨɨre.” Ne akasea, “Mukiindya ngwyɨɨra.” ");
INSERT INTO lag_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yéesu akasea, “Kwajáa kwatɨɨte vaantʉ vavɨrɨ ˆvadaayiwáa noongwa nɨ mʉʉntʉ ʉmwɨ. Ʉmwɨ adaayiwáa mpía ja dináari magana yasaano (500) na wɨɨngɨ mpía ja dináari makumi yasaano (50). ");
INSERT INTO lag_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Vaantʉ ava vajáa vasiindwa rɨha. Ʉwo ˆajáa avakopesha akavasea noongwa jaavo jasírire. Haaha nɨ arɨkwɨ kati ya ava vavɨrɨ ˆarɨ mweenda kʉlookya mwiiwaachwe?” ");
INSERT INTO lag_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simóoni akasea, “Nɨ ʉra ˆasewa noongwa yaachwe nkʉʉlʉ kʉlookya yasírire.” Yéesu akamʉsea, “Walámwɨɨre kwa ʉwoloki.” ");
INSERT INTO lag_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aho, Yéesu akamʉlaanga ʉra mʉʉntʉ muki, maa akamʉsea Simóoni, “Wamwɨɨ́ne ʉhʉ mʉʉntʉ muki? Nɨɨ́ngɨɨre aha nyuumbii kwaako baa sɨ wʉʉmpɨ́ɨre maaji nooyye majeo yaanɨ tʉkʉ, maa kaa, ʉhʉ mʉʉntʉ muki oóyyiirye majeo yaanɨ na miísoori yaachwe na aampónwɨɨre majeo yaanɨ na njwɨɨrɨ jaachwe. ");
INSERT INTO lag_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Weewe sɨ waansʉ́ndɨɨre mpɨɨndɨ ˆwakuunuumbya tʉkʉ. Maa kaa, ʉhʉ keende ˆnɨɨ́ngɨɨre aha sɨ anareka kʉʉnsʉʉndɨra majeo yaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Weewe sɨ waampákire makuta mutwii tʉkʉ, maa kaa, yeeye aampákire makuta ˆyanyʉ́kɨraa majewii yaanɨ. ");
INSERT INTO lag_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Haaha nɨ kuwyɨɨra niise, kweenda kwaachwe nɨ kʉkʉ́ʉ́lʉ sa ʉvɨ waachwe ˆʉrɨ foo wasírire. Maa kaa, ʉra ʉvɨ kiduudi ˆwasírire, eenda kiduudi.” ");
INSERT INTO lag_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aho, maa Yéesu akamʉsea ʉra mʉʉntʉ muki, “Ʉvɨ waako wasírire!” ");
INSERT INTO lag_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Maa kaa, vara ˆvarijáa ne aho, vakaanda kiiyurya voovo kwa voovo voosea, “Ʉhʉ nɨ ani ˆarɨ sea ʉvɨ wa mʉʉntʉ wasírire?” ");
INSERT INTO lag_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aho, Yéesu akamʉsea ʉra mʉʉntʉ muki, “Kuruma kwaako kwakʉhóniirye, tamanya na mwiikalo mʉʉja.” ");
INSERT INTO lag_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aya ˆyakalooke, Yéesu ajáa akera njɨra na atweeráa na míijii na maturii ˆyiísimiresimire kʉnʉ yoovariyʉla Masáare Maaja ya Ʉtemi wa Mʉlʉʉngʉ. Na mpɨɨndɨ ijo nɨ na vapooji vaachwe ikimi na vavɨrɨ ajáa. ");
INSERT INTO lag_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kei, nɨ hamwɨ ajáa na vaantʉ vaki vɨɨngɨ ˆveene ajáa avaseyya mirimʉ mɨvɨ na vɨɨngɨ ˆajáa avahorya ndwáala jaavo. Na ʉmwɨ wa vaantʉ vaki avo nɨ Maríia Makɨdaléena, ˆajáa aseyyiwa mirimʉ mɨvɨ mufungatɨ, ");
INSERT INTO lag_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yooáana muki wa Kúusa mwiimiriri wa máari ja mʉtemi Heróode. Wɨɨngɨ nɨ Susáana na vɨɨngɨ ˆvarɨ foo. Vaantʉ vaki ava vatooláa máari jaavo kʉmwaambirirya Yéesu na vapooji vaachwe. ");
INSERT INTO lag_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mpɨɨndɨ mpuka nkʉʉlʉ ya vaantʉ ˆyiijiingáa fuma kɨra múuji, Yéesu akavavaɨra lusímo ʉlʉ, ");
INSERT INTO lag_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mʉhaandi ʉmwɨ ajáa adoma noo haanda mbeyʉ jaachwe. Mpɨɨndɨ ˆamyaaháa, mbeyʉ jimwi jikawyɨɨra njirii, jikalwaatwa na ndee jikʉʉja jikajirya. ");
INSERT INTO lag_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mbeyʉ jimwi jikawyɨɨra mwaalaliwyii. ˆJikamere, jikʉʉma sa viintʉ kʉjáa kusiina maaji. ");
INSERT INTO lag_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jimwi jikawyɨɨra haantʉ ˆhajáa na miíwa. Miíwa ɨkakʉlanʼya hamwɨ na jira mbeyʉ, miíwa ɨkajivaa, maa jikadundumala. ");
INSERT INTO lag_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Maa kaa, jimwi jikawyɨɨra salwii ˆjiri na seve, jikamera, jikakʉla, jikavyaala maatʉkʉ vii, jimwi jikavyaala mara makumi ikimi (100).” ˆAkahʉmʉle kʉvawyɨɨra jeyyo, maa akasea na ngururu, “ˆArɨ na matu yo teerera, nɨ ateere!” ");
INSERT INTO lag_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mpɨɨndɨ kiduudi vapooji vaachwe vakamuurya, “Lusímo lwaako nɨ che loovariyʉla?” ");
INSERT INTO lag_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ne akavasea, “Nyuunyu mwaheewa nkalo yo taanga viintʉ vya Ʉtemi wa Mʉlʉʉngʉ, ivyo nɨ fuumbo. Maa kaa, vara sɨ ˆvarɨ Ʉtemii wa Mʉlʉʉngʉ, noovawyɨɨra kwa símo, sa, ‘Kʉlaanga, valaange, baa koona tʉkʉ. Na kʉteera, vateere, baa taanga tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Lusímo ʉlʉ ʉvariyuli waachwe nɨ ʉhʉ, mbeyʉ nɨ isáare ra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeyʉ jira ˆjawyɨɨra njirii nɨ vara vaantʉ ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ. Aho, Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨkʉʉja, rɨkarɨseyya mitimii yaavo sa karɨ jɨ varume na valamuririwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeyʉ jira ˆjawyɨɨra mwaalaliwyii, nɨ vaantʉ vara ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ, maa vakarɨhokera na cheerʉ. Maa kaa, sɨ rɨvɨɨngɨ́raa mitimii tʉkʉ, sa viintʉ vasiina miriri yo rɨkwaata, kiikala varɨ noro kiduudi vii, na uturikiri ˆʉrɨ kʉʉja sa rɨra isáare, varékaa kʉra kuruma kwaavo. ");
INSERT INTO lag_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeyʉ jira ˆjawyɨɨra miíwii, nɨ ja vaantʉ vara ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ. Maa kaa, ˆvarɨ tuuba kwiikala noro, raváwaa nɨ ʉhangaiki wa weerʉ, kukunguula máari na ʉláku wa viintʉ vya weerʉ, jeyyo, sɨ vakʉ́laa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na mbeyʉ jira ˆjawyɨɨra sevii, noo vaantʉ vara ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ. Vakarɨteengya na wʉʉja mitimii yaavo, vakarɨkwaatya, na kwa uyimiriryi mʉkʉʉlʉ, vavyáalaa ndɨɨwa. ");
INSERT INTO lag_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kusiina mʉʉntʉ ˆakórereryaa kɨmʉrɨ, maa akavisa nyiingwii tʉkʉ, au akakɨvɨɨka iruungwii ra kɨtáanda tʉkʉ. Kɨmʉrɨ nɨ kyaángwii kɨvɨ́ɨkwaa sa vaantʉ voosi ˆvookɨɨngɨra voone kɨweerʉ. ");
INSERT INTO lag_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sa kɨra kɨɨntʉ ˆchaviswa, vɨɨkwa kɨrɨ kɨweerwii, na kɨra ˆchakʉnɨkɨrɨrwa, taangwa kɨrɨ. ");
INSERT INTO lag_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Haaha teereri neeja masáare ayo ˆnoovawyɨɨra. Ʉra ˆarɨ na kɨɨntʉ, koongereriwa arɨ kʉlookya, na ʉra ˆasiina kɨɨntʉ, vuulwa arɨ baa kɨra kidúúdi ˆiiséaa nɨ nocho arɨ.” ");
INSERT INTO lag_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Aho, ndʉʉ ya Yéesu na íyo waavo vakʉʉja noo mʉlaanga Yéesu, maa kaa, sɨ vadaha seesa na haantʉ ˆajáa tʉkʉ, sa vaantʉ vajáa ˆvamema maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aho, mʉʉntʉ ʉmwɨ akamʉsea Yéesu, “Íyo waanyu na vaanaanyu vamwaarɨ weerwii, voosaaka vakoone.” ");
INSERT INTO lag_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Maa kaa, Yéesu akamʉsea, “Íyo wiitʉ na vandʉʉ vaanɨ nɨ vara voosi ˆvarɨtéeraa isáare ra Mʉlʉʉngʉ no rituuba.” ");
INSERT INTO lag_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sikʉ ɨmwɨ, Yéesu ajáa aambʉka mashʉ́wa na vapooji vaachwe, maa akavasea, “Hendi tʉfɨrɨre na nyambʉko ya iriva.” Aho, vakakwaata lʉyeendo. ");
INSERT INTO lag_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na mpɨɨndɨ ˆvafɨrɨráa, Yéesu akakwaatwa nɨ tʉlo, maa akanyeyya. Aho, ihúmbuuto ˆradalavadalaava rɨkaanda wuva, maa mashʉ́wa ɨkaanda mema maaji, vakava vɨɨ́ngɨɨre iremii. ");
INSERT INTO lag_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Vapooji vaachwe vakɨɨta noo mwiinukya, vakatʉla isóso voosea, “Aaɨ mʉkʉ́lʉ! Aaɨ mʉkʉ́lʉ! Sira tiise!” Hara Yéesu akiinʉka, akarɨdalavya rɨra ihúmbuuto na yara mapúunta. Hara, ihúmbuuto rɨkakirinya sawu, na maaji yakatʉʉla tʉ. ");
INSERT INTO lag_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aho, akavuurya vapooji vaachwe, “Kuruma kwaanyu hai kʉrɨ?” Vapooji vaachwe vakahwaalala na vakakwaatwa nɨ woowa mʉnʉmʉʉnʉ, vaakiiyurya voosea, “De ʉhʉ nɨ ani, ˆmweene baa ihúmbuuto na maaji vyoomʉteera?” ");
INSERT INTO lag_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yéesu na vapooji vaachwe vakafɨrɨra na nyambʉko ya iriva ra Galiláaya, vakafika ɨsɨ ya Vageráasi ˆɨrɨ mbarɨmbarɨ ya iriva. ");
INSERT INTO lag_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yéesu ˆakakiime vii hara mashúwii, maa akalʉmana na mʉʉntʉ ʉmwɨ ˆarɨ na mirimʉ mɨvɨ. Kwa mpɨɨndɨ nkʉʉlʉ ʉhʉ mʉʉntʉ sɨ iivɨ́kɨraa ɨngo tʉkʉ, baa kei sɨ iikaláa kaayii tʉkʉ nɨ mbiríírii vii iikaláa. ");
INSERT INTO lag_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ʉwo mʉʉntʉ ˆakamoone Yéesu, akachwaama mbere yaachwe, akatʉlatʉʉla isóso, yoosea, “Che woosaaka kʉrɨ nɨɨnɨ, weewe Yéesu, Mwaana wa Mʉlʉʉngʉ ˆArɨ Mweerimweeri? Nookʉloomba, kuunturikirya tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Alʉʉsa jeyyo, sa Yéesu ajáa ɨɨséire ɨyo mirimʉ mɨvɨ yiisunke kʉrɨ ʉwo mʉʉntʉ. Ɨyo mirimʉ mɨvɨ, ɨjáa yamuturikirya maatʉkʉ vii. Vaantʉ vamʉyeekeráa nyuumbii na vamuchuungáa na mɨnyololo mɨkonwii na mawulwii, maa kaa, yeeye adʉmʉladʉmʉláa, na ɨyo mirimʉ mɨvɨ yamʉtwaaláa na ɨsɨ ya ibaláángwii. ");
INSERT INTO lag_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Haaha, maa Yéesu akuuyurya, “Irina raako noo ani?” Ʉkasea, “Irina raanɨ nɨ Mayana na Mayana ya Valwi Nkoondo,” sa nɨ mirimʉ mɨvɨ ˆɨrɨ foo ɨjáa yamwɨɨngɨra. ");
INSERT INTO lag_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aho ɨra mirimʉ mɨvɨ ikiilomboola maatʉkʉ vii kʉrɨ Yéesu, karɨ iikibirye na Ntarii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Haaha mpɨɨndɨ ijo, heehi na aho haantʉ kʉjáa kwatɨɨte ufya wa nkaamba ˆjooriisha mbarɨmbarɨ ya lʉʉlʉ. Ɨra mirimʉ mɨvɨ ikiilomboola kʉrɨ Yéesu, yoosea, “Kalaama tʉrekere, tʉkajɨɨngɨre jira nkaamba.” Ne akɨɨrekera. ");
INSERT INTO lag_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɨra mirimʉ mɨvɨ ɨkafuma kwa ʉra mʉʉntʉ, maa ɨkɨɨta kɨɨngɨra jira nkaamba. Ufya woosi wa nkaamba ʉkagɨrɨtɨra na kɨwoongwii, maa jikabʉrʉkɨra na irivii na nkaamba joosi vʉʉ jikakwya. ");
INSERT INTO lag_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Varíisi va jira nkaamba ˆvakoone jeyyo, vakakʉʉrɨka itɨ́ɨjo, vakatwaala mʉlomo kwa vaantʉ ˆvajáa mawundii na múujii. ");
INSERT INTO lag_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Vaantʉ vakadoma noo laanga masáare ˆmeene yajáa yafʉ́mɨɨre. ˆVakafike kʉrɨ Yéesu, vakamoona ʉra mʉʉntʉ ˆajáa aséyyiiwe mirimʉ mɨvɨ, iíkyɨɨre mawulwii ya Yéesu, iivɨ́kɨɨre ɨngo, arɨ na mɨryʉʉngʉ yaachwe! Vakoofa maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na vara ˆvajáa voona, vakavawyɨɨra vaantʉ vɨɨngɨ ˆvyeene ʉra mʉʉntʉ ˆajáa na mirimʉ mɨvɨ ahoriwa nɨ Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Vaantʉ voosi va ɨsɨ ya Vageráasi na ɨsɨ ˆjarɨɨngɨrɨra, vakakwaatwa nɨ woowa mʉnʉmʉʉnʉ, maa voosi vakamʉloomba Yéesu alooke aho meevo. Aho, maa Yéesu akaambʉka mashʉ́wa, akahɨndʉka. ");
INSERT INTO lag_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Haaha de Yéesu alooke, ʉra mʉʉntʉ ˆajáa aséyyiiwe mirimʉ mɨvɨ akiiloombererya atamanyanʼye na Yéesu. Maa kaa, Yéesu akamʉsɨɨtɨra, yoosea, ");
INSERT INTO lag_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hɨndʉka na meenyu, ʉkavawyɨɨre vaantʉ ˆvyeene Mʉlʉʉngʉ akʉtʉ́mamɨɨre masáare makʉʉlʉ.” Aho, ʉra mʉʉntʉ akiitamanyirya, akɨtookaarya múujii waachwe woosi masáare makʉʉlʉ ˆmeene Yéesu ajáa amʉtʉ́mamɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Haaha Yéesu ˆakahɨndʉke na nyambʉko ya iriva ra Galiláaya, akateengiwa nɨ mpuka nkʉʉlʉ ya vaantʉ ˆvamʉwoojeráa. ");
INSERT INTO lag_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aho, akʉʉja mʉʉntʉ ʉmwɨ irina raachwe Yaíiro. Ʉhʉ nɨ mʉlongooli wa sinagóogi ajáa. Akawya majewii ya Yéesu yoomʉloomba atamanye na kaayii kwaachwe. ");
INSERT INTO lag_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ʉko kaayii kwaachwe muhíínja waachwe wa mpeke wa myaaka ikimi na ɨvɨrɨ ajáa aséngerɨɨre kukwya. Kati ˆadomáa na kwa Yaíiro, mpuka nkʉʉlʉ ya vaantʉ ɨkava yoomufiinda. ");
INSERT INTO lag_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aho, kʉjáa kwatɨɨte mʉʉntʉ muki ˆajáa na ndwáala yo fuma sakami kwa myaaka ikimi na ɨvɨrɨ. Yeeye ajáa amala máari jaachwe joosi vʉʉ kwa vaanga, baa kusiina yoyoosi ˆadaha mʉhorya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ʉra mʉʉntʉ muki akamutuuba Yéesu kʉnʉ nyuma, maa akasaasya mʉkáwo wa nkáancho yaachwe. Hahara, sakami ɨkadeenʼya. ");
INSERT INTO lag_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aho, Yéesu akuurya, “Nɨ ani aansáasiirye?” Vaantʉ voosi ˆvakasiite, maa Peéteri akamʉsea, “Aaɨ mʉkʉ́lʉ, ɨhɨ mpuka ya vaantʉ yoosi yookufiinda na vookiifenyenkererya!” ");
INSERT INTO lag_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Maa kaa, Yéesu akasea, “Kwatɨɨte mʉʉntʉ ˆaansáasiirye, sa kwatɨɨte ngururu jo horya mʉʉntʉ ˆjaanfúmire.” ");
INSERT INTO lag_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ʉra mʉʉntʉ muki ˆakataange sɨ arɨ daha kwiivisa tʉkʉ, akiiturirya, kʉnʉ yootetema nɨ woowa, maa akachwaama mbere ya Yéesu. Aho, akalʉʉsa mbere ja vaantʉ voosi ˆcheene kɨmʉbwéeyyiirye amʉsaasye Yéesu na ˆvyeene ahóriiwe hahara. ");
INSERT INTO lag_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aho, maa re Yéesu akamʉsea, “Muhíínja waanɨ, kuruma kwaako kwakʉhóriirye. Tamanya na mwiikalo mʉʉja!” ");
INSERT INTO lag_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mpɨɨndɨ Yéesu ˆajáa akaarɨ yoolʉʉsɨka, akʉʉja mʉʉntʉ fuma kaayii kwa Yaíiro, maa akamʉsea, “Muhíínja waako awʉ́lɨɨre. Aaɨ reka tuuba kumujuuwa Mukiindya.” ");
INSERT INTO lag_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Maa kaa, Yéesu ˆakateere jeyyo, akamʉsea Yaíiro, “Kwiitweetya tʉkʉ, ruma vii, muhíínja waako hola arɨ.” ");
INSERT INTO lag_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yéesu ˆakafike kaayii kwa Yaíiro, akavakaanʼya vaantʉ vɨɨngɨ kwɨɨngɨra hamwɨ ne na nyuumbii, maa kaa, ˆveene ɨɨngɨra novo nɨ vala Peéteri, Yooháani, Yaakúupu, na taáta na íyo waala ʉra muhíínja. ");
INSERT INTO lag_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mpɨɨndɨ ijo vaantʉ voosi varɨráa no myaa sa ʉra muhíínja. Maa kaa, Yéesu akavasea, “Reki kʉrɨra! Muhíínja sɨ awʉ́lɨɨre tʉkʉ, nɨ anyéyyiirye vii.” ");
INSERT INTO lag_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Vaantʉ ˆvajáa aho, vakaanda kʉmʉseka na heenchʉ, sa vajáa vatáangire ʉra muhíínja akwíire. ");
INSERT INTO lag_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aho, Yéesu akamʉkwaata mʉkono ʉra muhíínja, maa akamʉsea na ngururu, “Musinga, inʉka!” ");
INSERT INTO lag_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hahara, mʉtɨma waachwe ʉkamʉhɨndʉkɨra, ne akiinʉka chaangʉ. Yéesu akavasea vara vaantʉ vamʉheere chóorya ʉra muhíínja arye. ");
INSERT INTO lag_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Taáta na íyo waala ʉra muhíínja vakahwaalala maatʉkʉ vii. Maa kaa, Yéesu akavakaanʼya karɨ valʉʉse kʉrɨ mʉʉntʉ yoyoosi yara ˆyajáa yafʉ́mɨɨre tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yéesu akavajiinga vatumwi vaachwe ikimi na vavɨrɨ. Akavaheera ngururu na wiimiriri wo kibirya mirimʉ mɨvɨ no horya ndwáala. ");
INSERT INTO lag_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aho, akavatʉma vakavavariyʉrɨre vaantʉ Ʉtemi wa Mʉlʉʉngʉ na vavahorye valwɨ́ɨrɨ. ");
INSERT INTO lag_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akavasea, “Kati ˆmookera njɨra, sumuli muriwa tʉkʉ, baa nkome tʉkʉ, mufuko tʉkʉ, chóorya tʉkʉ, mpía tʉkʉ baa na nkáancho ivɨrɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kaaya ˆngʼeene mʉrɨ teengiwa, ikali haaho fʉʉrʉ sikʉ ˆmʉrɨ looka múuji ʉwo. ");
INSERT INTO lag_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Koonɨ kaaya yoyoosi vasíitire kʉvateengya, mpɨɨndɨ ˆmoolooka, ikonkomi marʉrɨ majewii yaanyu, koonekya ʉvɨ waavo.” ");
INSERT INTO lag_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aho, vara vatumwi vaachwe vakadoma, vakava vootweera ituri ɨrɨ fʉʉrʉ rɨra kʉnʉ voovavariyʉrɨra vaantʉ Masáare Maaja no vahorya valwɨ́ɨrɨ kɨra haantʉ. ");
INSERT INTO lag_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Haaha, mʉtemi Heróode Antípaasi ajáa ateera masáare yoosi ˆyatʉmamwáa nɨ Yéesu, akoololokera sa vamwɨ va vaantʉ vaseáa nɨ Yooháani Mʉbatisáaji ˆafúfukire fuma inkwyii. ");
INSERT INTO lag_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kei, vaantʉ vamwɨ vaseáa nɨ Elíamʉláali na mʉtwe wa Ijʉva afʉ́mɨɨre na vamwɨ vaséaa nɨ ʉmwɨ wa valáali na mʉtwe wa kalɨ afúfukire. ");
INSERT INTO lag_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Maa kaa, Heróode akasea, “Yooháani namʉdʉmʉla mʉtwe. Ha ʉhʉ ˆnooteera masáare yaachwe nɨ ani?” Heróode akava na mpɨɨma yo moona Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Vatumwi va Yéesu ˆvakahɨndʉke, vakamuwyɨɨra viintʉ vyoosi ˆvatʉ́mamire. Aho, akadomanʼya novo, maa vakiinʉka vooveene fʉʉrʉ iturii rɨmwɨ ˆraséwaa Besaída. ");
INSERT INTO lag_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Maa kaa, mpuka ya vaantʉ ˆvakataange na haantʉ Yéesu ˆajáa atámiinye, maa vakamutuuba. Yéesu akavateengya, maa akaanda vakiindya masáare ya Ʉtemi wa Mʉlʉʉngʉ no vahorya valwɨ́ɨrɨ ˆveene vasaakáa horiwa. ");
INSERT INTO lag_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mpɨɨndɨ ja kyʉʉlwa ˆjikafike, vatumwi vaachwe ikimi na vavɨrɨ vakɨɨta kʉrɨ Yéesu, maa vakamʉsea, “Aaɨ, varekere vaantʉ vakiiwʉrɨre vyóorya na vakiisaakɨre viláalo ʉko mawundii na maturii sa aha haantʉ ˆtʉrɨ nɨ kʉlɨ na kaaya ja vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Maa kaa, Yéesu akavasea, “Vaheeri nyuunyu chóorya.” Maa vakamʉsea, “Tusiina chóorya tʉkʉ. Aha ɨmwaarɨ mɨkáate ɨsaano na soompa ivɨrɨ vii. Nɨ saaka wiise tʉkavawʉrɨre vaantʉ voosi ava chóorya wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aho, kʉjáa kwatɨɨte vaantʉ valʉme ja mayana yasaano (5,000). Yéesu akavasea vapooji, “Viikaryi vaantʉ vitoonge vya vaantʉ makumi yasaanosaano (50).” ");
INSERT INTO lag_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Novo vakabweeyya ja ˆvyeene vajáa vaséirwe, vakaviikarya vaantʉ voosi. ");
INSERT INTO lag_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aho, Yéesu akatoola ɨra mɨkáate ɨsaano na jira soompa ivɨrɨ. Akiinurirya miiso yaachwe na kurumwii yoomʉdʉʉmba Mʉlʉʉngʉ. Akabendʉlabendʉla, maa akavaheera vapooji vaachwe novo vakavaheera vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Vaantʉ voosi vakarya, vakiikuta. Vapooji vakatoorera mabéendʉ ya mɨkáate, vakamemya vikápu ikimi na vivɨrɨ. ");
INSERT INTO lag_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sikʉ ɨmwɨ, Yéesu na vapooji vaachwe vajáa viikera kijiraawa. Yéesu amʉloombáa Mʉlʉʉngʉ. Ʉko Yéesu akavuurya vapooji vaachwe, “Eri, vaantʉ vaséaa nɨɨnɨ ndɨrɨ ani?” ");
INSERT INTO lag_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Novo vakamʉsea, “Vamwɨ vaséaa weewe ʉrɨ Yooháani Mʉbatisáaji, vɨɨngɨ vaséaa ʉrɨ Elía mʉláali na mʉtwe wa Ijʉva, na vɨɨngɨ vaséaa ʉrɨ ʉmwɨ wa valáali na mʉtwe va Ijʉva va kalɨ ˆafúfukire.” ");
INSERT INTO lag_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aho, maa akavuurya, “Ha nyuunyu, mwaséaa nɨɨnɨ ndɨrɨ ani?” Peéteri akamʉsea, “Weewe noo Masía wa Mʉlʉʉngʉ!” ");
INSERT INTO lag_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Maa Yéesu akavakaanʼya yoosea, “Karɨ muwyɨɨra mʉʉntʉ yoyoosi isáare ɨrɨ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kei akavasea, “Mwaana wa Mʉʉntʉ, nɨ mpaka aturikiriwe mʉnʉmʉʉnʉ, kei asiitwe nɨ vawosi, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro, na ʉʉlawe. Maa kaa, sikʉ ya katatʉ fʉfʉlwa arɨ.” ");
INSERT INTO lag_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kei akavawyɨɨra voosi yoovasea, “Koonɨ mʉʉntʉ yoyoosi yoosaaka aantuube nɨ mpaka iisiite yeemweene, avaale mʉsaláaba waachwe kɨra siikʉ, aantuube. ");
INSERT INTO lag_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sa mʉʉntʉ yoyoosi ˆyoosaaka honʼya nkaasʉ yaachwe, kɨɨtaaha arɨ, maa kaa, mʉʉntʉ yoyoosi ˆyookɨɨtaaha nkaasʉ yaachwe sa nɨɨnɨ ʉwo kɨɨhonʼya arɨ. ");
INSERT INTO lag_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kwatɨɨte kʉnáálo che mʉʉntʉ kuturya weerʉ yoosi, maa kaa, ataahe nkaasʉ yaachwe? ");
INSERT INTO lag_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Koonɨ mʉʉntʉ yoyoosi aanyónɨɨre soni nɨɨnɨ na masáare yaanɨ, baa Mwaana wa Mʉʉntʉ moonera arɨ soni, mpɨɨndɨ ˆakuújire na nkongojima ya Taáta na mirimʉ miija. ");
INSERT INTO lag_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kɨmaarɨ noovawyɨɨra, vamwaarɨ vɨɨngɨ viímire aha, sɨ varɨ kukwya tʉkʉ mpaka vʉʉyone Ʉtemi wa Mʉlʉʉngʉ!” ");
INSERT INTO lag_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ja sikʉ inaanɨ jei ˆjikalooke keende Yéesu ˆalʉʉsa ayo masáare, Yéesu akaambʉkanʼya na vala Peéteri, Yaakúupu na Yooháani na luulwii noo mʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mpɨɨndɨ Yéesu ˆamʉloombáa Mʉlʉʉngʉ, buuwo yaachwe ɨkavalandʉka, ɨngo jaachwe jikava njerʉ chwee, mpaka jindoolavalava. ");
INSERT INTO lag_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Koonka, vaantʉ valʉme vavɨrɨ vakafʉmɨra maa vakaanda lʉʉsɨka ne. Novo nɨ vala Mʉ́sa na Elía vajáa. ");
INSERT INTO lag_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Vajáa voonekana na nkongojima ya kurumwii na valʉʉsɨkáa na Yéesu ˆvyeene arɨ kiimanʼya mʉrɨmo wa Mʉlʉʉngʉ kwa inkwya yaachwe ʉko Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mpɨɨndɨ ijo, Peéteri na vara vatumwi viivaachwe vajáa vanyéyyiirye fúti. ˆVakiinʉke, vakamoona Yéesu na nkongojima yaachwe. Na kei vakoona vaantʉ vavɨrɨ vajáa viímire ne. ");
INSERT INTO lag_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na kati vara vaantʉ vavɨrɨ ˆviinʉkáa fuma kʉrɨ Yéesu, maa Peéteri akamʉsea Yéesu, “Aaɨ mʉkʉ́lʉ, vyabooha tʉveere haaha aha. Tʉjeenge vivaanda vitatʉ, kɨmwɨ chaako, kɨmwɨ cha Mʉ́sa na kɨmwɨ cha Elía.” Peéteri alʉʉsa jeyyo maa kaa, sɨ ataangáa kɨra ˆyoolʉʉsa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na viintʉ Peéteri ˆajáa akaarɨ yoolʉʉsɨka jeyyo, ichu rɨkafʉmɨra, maa rɨkavawɨɨkɨra. Aho, vakoofa maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sawúti ɨkafuma aho ichwii, yoosea, “Ʉhʉ nɨ Mwaana waanɨ. Yeeye namʉsaawʉla. Mʉteereri yeeye.” ");
INSERT INTO lag_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na ɨyo sawúti ˆɨkalooke, Yéesu akoónekana arɨ yeemweene. Vapooji vaachwe sɨ vamuwyɨɨra mʉʉntʉ yoyoosi masáare aya ˆvajáa vɨɨ́ne sikʉ ijo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Lomʉtóondo yaachwe mpɨɨndɨ ˆvagiritáa fuma luulwii, vakalʉmana na mpuka nkʉʉlʉ ya vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aho, ʉmwɨ wa vaantʉ va ɨyo mpuka akalʉʉsɨka na ngururu yoosea, “Mukiindya, nookʉloomba ʉmʉlaange mʉtavana waanɨ, yeeye noo mwaana waanɨ wa mpeke. ");
INSERT INTO lag_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yeeye atɨɨte murimʉ mʉvɨ ˆwamʉtáavityaa akaanda tʉla isóso mʉnʉmʉʉnʉ. Kei, wamusíngisyasingiisyaa akawya na ɨsɨ ja arɨ na kiinkwiisha, maa de ɨndootuumpa ifulo mʉlomwii. Ʉhʉ murimʉ mʉvɨ wamutúrikiryaa mʉnʉmʉʉnʉ, wamʉrékaa kiduudi vii. ");
INSERT INTO lag_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Navalóombire vapooji vaako vuukibirye ʉhʉ murimʉ mʉvɨ, maa kaa, vasíindirwe.” ");
INSERT INTO lag_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yéesu akavasea, “Aka! Ɨhɨ mbyaala sɨ ˆirúmaa, na ˆyakɨɨkana. Niikale na nyuunyu mpaka naadi? Na nɨvayimirirye mpaka naadi? Hoonɨ mʉreete mʉtavana waako na aha!” ");
INSERT INTO lag_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kati ʉra mʉtavana ˆasesáa na kwa Yéesu, murimʉ mʉvɨ ʉkamʉvayya na ɨsɨ, maa ʉkamʉkwaatya kiinkwiisha. Aho, Yéesu akʉʉyamirirya ʉra murimʉ mʉvɨ, akamʉhorya ʉra mʉtavana, maa akamʉhɨndʉla na kʉrɨ taáta waavo. ");
INSERT INTO lag_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Vaantʉ voosi vakatʉlʉvala maatʉkʉ vii koona ʉkʉ́ʉ́lʉ wa Mʉlʉʉngʉ. Mpɨɨndɨ vaantʉ ˆvajáa vakaarɨ vahwáalɨɨre sa yoosi Yéesu ˆajáa abwéeyyiirye, maa akavasea vapooji vaachwe, ");
INSERT INTO lag_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Teereri neeja aya ˆnoosaaka nɨvawyɨɨre. Mwaana wa Mʉʉntʉ valandʉkwa arɨ na vɨɨkwa arɨ mɨkonwii ya vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Maa kaa, vapooji vaachwe sɨ vataanga ʉvariyuli wa masáare yara tʉkʉ. Masáare aya yajáa yiivisa kwaavo sa vadɨɨre taanga. Kei voofáa kumuurya. ");
INSERT INTO lag_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Haaha kʉkava na nkaani kwa vapooji va Yéesu nɨ ani arʉʉva mʉkʉ́ʉ́lʉ kati yaavo voosi. ");
INSERT INTO lag_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Maa kaa, Yéesu ˆakataange miiririkano yaavo, akamwaanɨrɨra musinga muduudi, maa akamwiimya heehi ne. ");
INSERT INTO lag_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Aho, maa akavasea, “Mʉʉntʉ yoyoosi ˆarɨ mʉteengya musinga ja ʉhʉ sa irina raanɨ, kʉva arɨ aantéengiirye nɨɨnɨ. Kei, yoyoosi ˆarɨ kʉʉnteengya nɨɨnɨ, kʉva arɨ amʉtéengiirye Mʉlʉʉngʉ, na yeeye aantʉma. Sa ʉra ˆarɨ mudúúdi kufuma kʉrɨ nyuunyu noo mʉkʉ́ʉ́lʉ kʉlookya voosi.” ");
INSERT INTO lag_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yooháani akamʉsea Yéesu, “Mʉkʉ́lʉ, tamwɨɨ́ne mʉʉntʉ yookibirya mirimʉ mɨvɨ kwa irina raako, maa tʉkamʉkaanʼya sa viintʉ sɨ arɨ hamwɨ na suusu.” ");
INSERT INTO lag_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Maa kaa, Yéesu akavasea, “Karɨ mʉmʉkáanʼyaa tʉkʉ, sa ˆmweene sɨ yoovakɨɨkana nyuunyu, nɨ hamwɨ arɨ na nyuunyu.” ");
INSERT INTO lag_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sikʉ ja Yéesu jo sʉmʉlwa na kurumwii ˆjikasengerere, maa yeeye akawolola kisho chaachwe yoodoma na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yeeye akatʉma vaantʉ valongoole na iturii rɨmwɨ ra ɨsɨ ya Samaría sa vakiimye neeja haantʉ ˆarɨ fɨkɨra. ");
INSERT INTO lag_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Maa kaa, vaantʉ va ɨro ituri vakasiita kʉmʉteengya sa viintʉ aleáa na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Vapooji vaachwe, noo kʉsea vala Yaakúupu na Yooháani, ˆvakoone jeyyo, maa vakamʉsea, “Aaɨ mʉkʉ́lʉ, tʉloombe mooto ukiime fuma kurumwii sa ʉvamale wʉʉ ja ˆvyeene Elía abweeyya?” ");
INSERT INTO lag_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Maa kaa, Yéesu akavavalandʉkɨra, akavadalavya ");
INSERT INTO lag_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","yoosea, nyuunyu sɨ mʉmányire nɨ vaantʉ ˆvarɨ joolɨ mʉrɨ tʉkʉ. Aho, maa vakatamanya na iturii rɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kati Yéesu na vapooji vaachwe ˆvajáa lʉyeendwii, maa mʉʉntʉ ʉmwɨ akamʉsea, “Kukutuuba ndɨrɨ na haantʉ hohoosi ˆʉrɨ doma.” ");
INSERT INTO lag_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yéesu akamʉsea, “Mʉʉnjʉ jatɨɨte viláalo mpáángii, na ndee jatɨɨte vivururu, maa kaa, Mwaana wa Mʉʉntʉ asiina baa ho laarya mʉtwe waachwe vii tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aho, Yéesu akamʉsea mʉʉntʉ wɨɨngɨ ˆajáa aho, “Ntuuba.” Maa kaa, ʉra mʉʉntʉ akamʉsea, “Aaɨ mʉkʉ́lʉ, reka ta nkataahe taáta wiitʉ.” ");
INSERT INTO lag_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yéesu akamʉsea, “Reka vaantʉ ˆvaakwya vataahe vaantʉ ˆvaakwya viivaavo, maa kaa, weewe doma ʉkavariyʉle Ʉtemi wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mʉʉntʉ wɨɨngɨ akamʉsea Yéesu, “Aaɨ mʉkʉ́lʉ, kukutuuba ndɨrɨ, maa kaa, reka ta nkavasee vaantʉ va kaayii kwaanɨ nasúukiirye.” ");
INSERT INTO lag_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Maa kaa, Yéesu akamʉsea, “Koonɨ mʉʉntʉ yoyoosi aándire rɨma, maa kei ɨndoolaanga kɨrɨ nyuma, ʉwo sɨ asaakwa Ʉtemii wa Mʉlʉʉngʉ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ayo ˆyakalooke, Yéesu Mweenevyoosi akavasaawʉla vapooji vɨɨngɨ makumi mufungatɨ na vavɨrɨ (72), maa akavatʉma vavɨrɨvɨrɨ. Voovo vakalongoola na kɨra múuji na kɨra haantʉ ˆasaakáa tamanya yeeye mweeneevyo. ");
INSERT INTO lag_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yéesu akavasea, “Viintʉ vyo chwa nɨ foo viri, maa kaa, vachwi nɨ vake. Sa jeyyo, mʉloombi Mweenevyoosi wo chwa, atʉme vachwi, na iwundii raachwe ro chwa. ");
INSERT INTO lag_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Haaha tamanyi, na mʉtaange nɨ vatʉma niise nyuunyu ja vaana va muundi katɨ na katɨ ya mbʉʉjɨ. ");
INSERT INTO lag_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sumuli mpía tʉkʉ, mufuko wo kɨɨnjɨra tʉkʉ, baa viráatʉ vya kavɨrɨ tʉkʉ. Mpɨɨndɨ ˆmʉrɨ njirii, karɨ mʉndoololoosha ko luumbya vaantʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nyuumba yoyoosi ˆmʉrɨ kɨɨngɨra, valuumbyi jei, ‘Mwiikalo mʉʉja ʉve nyuumbii ɨhɨ!’ ");
INSERT INTO lag_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Koonɨ mwiikalo mʉʉja ʉrɨ na mweenenyuumba, mwiikalo waanyu mʉʉja kiikala ʉrɨ ne. Maa kaa, koonɨ mweenenyuumba sɨ yoovahokera na mwiikalo mʉʉja, mwiikalo waanyu mʉʉja hɨndʉka ʉrɨ na kʉrɨ nyuunyu. ");
INSERT INTO lag_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ikali nyuumba yɨɨyo ɨmwɨ, kʉnʉ moorya no nywa kɨra ˆcheene mooheewa. Sa mʉtʉmami ɨɨma neeja kʉrɨhwa marɨho yaachwe. Kʉsaamasaama fuma nyuumba ɨhɨ fʉʉrʉ ɨra tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Koonɨ mwɨɨ́ngɨɨre múuji ʉmwɨ na vaantʉ va múuji ʉwo vavateengiirye na cheerʉ, iryi vyóorya ˆviri vɨɨkwa mbere yaanyu. ");
INSERT INTO lag_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Valwɨ́ɨrɨ ˆvarɨ múujii ʉwo vahoryi na mʉvasee, ‘Ʉtemi wa Mʉlʉʉngʉ wafíkire kʉrɨ nyuunyu.’ ");
INSERT INTO lag_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Maa kaa, múuji wowoosi ˆmʉrɨ kɨɨngɨra maa vasiite kʉvateengya, looki, na mʉtamanye na njirii ja ʉwo múuji mʉsee jei, ");
INSERT INTO lag_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Baa marʉrɨ ya múuji waanyu ˆmeene yanámatɨɨre majewii yiiswi, tayakónkomire, kʉvalʉma kutu ʉvɨ waanyu. Maa kaa, taangi Ʉtemi wa Mʉlʉʉngʉ wafíkire kʉrɨ nyuunyu.’ ");
INSERT INTO lag_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nɨ vawyɨɨra niise, sikʉ ɨyo, kʉva viri pwee kwa múuji wa Sodóoma kʉlookya múuji ʉwo. ");
INSERT INTO lag_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mpolaɨ múuji wa Korasíini! Mpolaɨ ituri ra Besaída! Sa ngaarɨ myuujíisa ˆyatʉ́mamirwe kwaanyu, ngaarɨ yatʉmamwa míiji ya Tíiro na Sidóoni, ngaarɨ vamʉvalandʉkɨra Mʉlʉʉngʉ kalɨ vii, ko kiivɨkɨra magunía no kiihaka mavu. ");
INSERT INTO lag_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Maa kaa, sikʉ ɨra yo lamʉrɨrwa vaantʉ voosi, kʉva ɨrɨ pwee kwa vaantʉ va míiji ya Tíiro na Sidóoni kʉlookya nyuunyu. ");
INSERT INTO lag_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Naanyu vaantʉ va múuji wa Kaperenáumu, eri, kiinʉlwa mʉrɨ fʉʉrʉ kurumwii wʉʉ? Aka tʉkʉ! Kiimiriwa mʉrɨ fʉʉrʉ Ntarii. ");
INSERT INTO lag_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mʉʉntʉ ˆavatéereraa nyuunyu, aantéereraa nɨɨnɨ. Na ˆavasíitaa nyuunyu, aansíitaa nɨɨnɨ. Kei mʉʉntʉ ˆaansíitaa nɨɨnɨ, amusíitaa Mʉlʉʉngʉ na yeeye aantʉma.” ");
INSERT INTO lag_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vara vapooji makumi mufungatɨ na vavɨrɨ (72) ˆvakahɨndʉke, vakamuwyɨɨra Yéesu na cheerʉ voosea, “Aaɨ mʉkʉ́lʉ, baa mirimʉ mɨvɨ tookiikibirya kwa irina raako na yootʉteera!” ");
INSERT INTO lag_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yéesu akavasea, “Nɨjáa naroonáa Irimʉ roohangalamʉka fuma kurumwii ja lʉlávo. ");
INSERT INTO lag_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Laangi, navahɨ́ɨre wiimiriri mweeri ya ʉra mʉvɨ kwa kɨra kɨɨntʉ. Kwa ngururu ijo, lwaata mweende njoka na ingi, kei kusiina kɨɨntʉ ˆkɨrɨ vatamikya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Baa neembe nɨ jeyyo, kʉvyeendi sa viintʉ mirimʉ mɨvɨ yoovateera tʉkʉ, maa kaa, vyeendi sa viintʉ marina yaanyu yaándikirwe kurumwii.” ");
INSERT INTO lag_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mpɨɨndɨ ɨʼɨra, Yéesu kʉnʉ avyeéndire mʉnʉmʉʉnʉ kwa ngururu ja Mʉtɨma Mʉʉja, maa akasea, “Nookʉdʉʉmba ee Taáta, Mweenevyoosi wa kurumu na ɨsɨ, sa masáare aya ʉvavisa vara ˆvarɨ na tooti na mɨryʉʉngʉ, maa kaa, ʉkavakʉnʉkʉrɨra vadúúdi. Kɨkomi Taáta, ivyo noo vyakweerya mʉtɨma.” ");
INSERT INTO lag_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kei akasea, “Taáta waanɨ aankwáatiirye viintʉ vyoosi. ˆMweene amʉmányire Mwaana nɨ Taáta vii. Kusiina wɨɨngɨ tʉkʉ. Kei ˆmweene amʉmányire Taáta nɨ Mwaana vii, na mʉʉntʉ yoyoosi ˆmweene Mwaana arɨ saaka kʉmʉkʉnʉkʉrɨra.” ");
INSERT INTO lag_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aho, Yéesu akavavalandʉkɨra vapooji vaachwe, akalʉʉsɨka na vooveene vii kijiraawii, akavasea, “Yatalariwa miiso aya ˆyookoona masáare aya! ");
INSERT INTO lag_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nɨ vawyɨɨra niise, valáali na mʉtwe ˆvarɨ foo na vatemi vajáa vatɨɨte mpɨɨma yo koona aya ˆmookoona nyuunyu, maa kaa, sɨ vayoona tʉkʉ. Kei, vajáa vatɨɨte mpɨɨma yo teera ˆmeene mooteera nyuunyu, maa kaa, sɨ vayateera tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mpɨɨndɨ ijo, mukiindya wa Miiro ya Mʉlʉʉngʉ akɨɨma, maa akamuurya Yéesu ko mʉyera, akasea, “Mukiindya, che ndɨrɨ bweeyya sa mpokere nkaasʉ ya sikʉ ˆjisiina ʉhero?” ");
INSERT INTO lag_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yéesu akamʉsea, “Miiro ya Mʉlʉʉngʉ joolɨ yalʉʉsa? Che ʉsómaa weewe aho?” ");
INSERT INTO lag_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ʉra mukiindya wa Miiro akamʉsea Yéesu, “Vyaandɨkwa jei, ‘Mweende Ijʉva Mʉlʉʉngʉ waako, na mʉtɨma waako woosi, na nkaasʉ yaako yoosi, na ngururu jaako joosi, na mʉryʉʉngʉ waako woosi.’ Kei, ‘Ʉmweende mwiiwaako ja ˆvyeene wiiyenda mweeneevyo.’” ");
INSERT INTO lag_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yéesu akamʉsea, “Wuúyiirye vyoovyo, bweeyya jeyyo, naawe turya ʉrɨ nkaasʉ ya sikʉ ˆjisiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ʉra mukiindya wa Miiro asaakáa kiiyonekya kɨkomi yeeye nɨ mʉwoloki. Sa jeyyo akamuurya Yéesu kei yoosea, “Ha mwiiwaanɨ nɨ ani?” ");
INSERT INTO lag_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yéesu akamʉsea, “Mʉʉntʉ ʉmwɨ agiritáa fuma Yerusaléemu yoodoma na múujii wa Yerɨ́ɨko. Njirii akakɨɨmɨrɨrwa nɨ viívi. Vakamufumya ɨngo jaachwe, vakamʉvaa mpaka vakamʉtamikya, vakamʉreka aséngerɨɨre kukwya. ");
INSERT INTO lag_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Haaha ɨkava ja baháati, mweeneɨsɨ ʉmwɨ wa Ijʉva alookáa na ɨra njɨra. ˆAkamoone, akakengeeja na ivarwii, maa akiilookera. ");
INSERT INTO lag_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Viivyo, Mʉláawi ʉmwɨ ne alookáa na aho. ˆAkamoone ʉra mʉʉntʉ ˆajáa atámikiiwe, ne akakengeeja nɨ ivarwii, maa akiilookera. ");
INSERT INTO lag_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Maa kaa, Mʉsamaría ʉmwɨ ne akeráa njɨra, akatweera na ɨra njɨra. ˆAkamoone ʉra mʉʉntʉ ˆajáa atámikiiwe, maa akamoonera mbavariri. ");
INSERT INTO lag_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akamʉseeserera, akamooyya njʉʉma jaachwe na diváai, maa akamʉhaka makuta. Akajichuunga njʉʉma jaachwe na ntaamɨ, maa akamwaambukya ndákwii yaachwe. Aho, akamʉtwaala fʉʉrʉ nyuumbii ya vayeni na akava yoomʉlaangirirya. ");
INSERT INTO lag_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sikʉ ya kavɨrɨ yaachwe, akatoola mpía ja dináari ivɨrɨ, akamʉheera mweenenyuumba ya vayeni, maa akamʉsea, ‘Mʉlaangirirye ʉhʉ mʉʉntʉ. Koonɨ iji jasírire na woóngeriirye mpía jɨɨngɨ so mʉlawurya, ˆndɨrɨ hɨndʉka kʉrɨha ndɨrɨ.’” ");
INSERT INTO lag_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aho, maa Yéesu akamuurya ʉra mukiindya wa Miiro, “Kati ya ava vatatʉ nɨ ani noo mwiiwaachwe wa ʉra mʉʉntʉ ˆajáa akɨɨmɨrɨrwa akatamikiwa nɨ viívi?” ");
INSERT INTO lag_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ʉra mukiindya wa Miiro akasea, “Nɨ ʉra ˆamʉlaanga na riiso ra wʉʉja.” Aho, maa Yéesu akamʉsea, “Doma, naawe ʉkabweeyye viivyo.” ");
INSERT INTO lag_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yéesu na vapooji vaachwe vakakwaata njɨra, maa vakɨɨngɨra iturii rɨmwɨ. Aho, maa mʉʉntʉ muki ʉmwɨ ˆasewáa Maárita akamʉteengya na kaayii kwaachwe. ");
INSERT INTO lag_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maárita ajáa atɨɨte mudúúdi waachwe ˆasewáa Maríia. Yeeye ajáa iikala mawulwii ya Yéesu Mweenevyoosi kʉnʉ yoomʉteerera. ");
INSERT INTO lag_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maa kaa, Maárita ajʉʉwɨkáa na mɨrɨmo ˆɨrɨ foo yo mʉteengya mʉyeni. Sa jeyyo, akadoma na kʉrɨ Yéesu, maa akamʉsea, “Mweenevyoosi, sɨ wookoona nɨ vyavɨɨha viintʉ ʉhʉ mudúúdi waanɨ ˆyookʉʉndekera mɨrɨmo yoosi nɨɨmweene tʉkʉ wʉʉ? Haaha mʉwyɨɨre aanyambɨre.” ");
INSERT INTO lag_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Maa kaa, Yéesu Mweenevyoosi akamʉsea, “Maárita, Maárita, sa che woojʉʉwɨka na wookoofa sa viintʉ ˆviri foo? ");
INSERT INTO lag_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kɨɨntʉ ˆchoosaakwa nɨ kimudu vii. Maríia asáawɨɨre kɨɨntʉ ˆchabooha, na kusiina mʉʉntʉ ˆarɨ daha kʉkɨseyya kʉrɨ yeeye tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sikʉ ɨmwɨ, Yéesu ajáa haantʉ hamwɨ yoomʉloomba Mʉlʉʉngʉ. ˆAkahʉmʉle, maa ʉmwɨ wa vatumwi vaachwe akamʉsea, “Aaɨ mʉkʉ́lʉ, tukiindye baa suusu kʉmʉloomba Mʉlʉʉngʉ ja viintʉ Yooháani Mʉbatisáaji ˆavakiindya vatumwi vaachwe.” ");
INSERT INTO lag_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yéesu akavasea, “Mpɨɨndɨ ˆmoomʉloomba Mʉlʉʉngʉ, mʉlʉʉse jei, ‘Taáta wiitʉ wa kurumwii, irina raako rɨbweeyyiriwe nkongojima, ʉtemi waako wʉʉje. ˆMeene woosaaka yatʉmamwe aha weerwii, yatʉmamwe ja ˆvyeene yatʉ́mamwaa ʉko kurumwii. ");
INSERT INTO lag_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ʉtʉheere chóorya chiitʉ cha kɨra siikʉ. ");
INSERT INTO lag_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ʉtʉsee ʉvɨ wiitʉ wasírire, ja ˆvyeene suusu tavaséaa vara ˆvatʉhonerya ʉvɨ waavo wasírire. Kʉtʉrekera twɨɨngɨre na mʉtehwii tʉkʉ, maa kaa, ʉtʉlamurirye na ʉra Mʉvɨ.’” ");
INSERT INTO lag_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aho, maa Yéesu akavasea, “Hoonɨ iririkani, koonɨ ʉmwɨ waanyu adómire na kwa kɨjeengi chaachwe nuuchikʉ katɨ, maa amʉsee kɨjeengi chaachwe, ‘Aaɨ kɨjeengi, hoonɨ nkopesha mɨkáate ɨtatʉ. ");
INSERT INTO lag_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Amwaarɨ kɨjeengi chaanɨ yookera njɨra alúumbiirye uchikʉ ʉhʉ, na nɨɨnɨ nsiina kɨɨntʉ cho mʉheera tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Maa kaa, ʉra ˆarɨ nyuumbii amʉsee, ‘Reka kʉʉnjuuwa, nachúungire mʉryaango! Kei, nɨɨnɨ na vaana vaanɨ tahʉ́mwɨɨre laala. Sɨ ndɨrɨ kiinʉka nɨkʉheere chóorya tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nɨ vawyɨɨra niise, koonɨ mʉʉntʉ ʉwo atúubire loomba, kɨjeengi chaachwe kiinʉka arɨ na amʉheere kɨra ˆyoosaaka. Sɨ arɨ bweeyya jeyyo sa viintʉ nɨ kɨjeengi chaachwe tʉkʉ, maa kaa, sa viintʉ atúubire loomba. ");
INSERT INTO lag_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sa jeyyo, nɨ vawyɨɨra niise, loombi, naanyu heewa mʉrɨ, saakiri, naanyu turya mʉrɨ, luumbyi mʉryaangwii, naanyu yʉʉrɨrwa mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sa kɨra ˆalóombaa, ahéewaa na ʉra ˆasáakɨraa, atúryaa na ʉra ˆalúumbyaa mʉryaangwii, ayʉ́ʉrɨrwaa. ");
INSERT INTO lag_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Eri, kwatɨɨte ʉmwɨ waanyu nyuunyu vala taáta mwaana waachwe ˆarɨ mʉloomba soompa, amʉheere njoka wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bakʉ kei koonɨ amʉlóombire ii, amʉheere ingi wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Haaha koonɨ nyuunyu baa neembe mʉrɨ vavɨ mʉmányire kʉvaheera vaana vaanyu viintʉ ˆvyabooha, ha Taáta waanyu wa kurumwii sɨ arɨ bweeyya vyabooha kʉlookya ivyo vyaanyu ko vaheera Mʉtɨma Mʉʉja vara ˆvoomʉloomba tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sikʉ ɨmwɨ, Yéesu akibiryáa murimʉ mʉvɨ fuma kwa kimumu ʉmwɨ. Ʉwo murimʉ ˆʉkakibiriwe, maa ʉra mʉʉntʉ akaanda lʉʉsɨka. Aho, ɨra mpuka ya vaantʉ vajáa hara vakahwaalala. ");
INSERT INTO lag_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Maa kaa, vamwɨ va vaantʉ ˆvajáa aho vakasea, “Yookibirya mirimʉ mɨvɨ kwa ngururu ja Belisebúuri, noo kʉsea Irimʉ.” ");
INSERT INTO lag_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Vaantʉ vɨɨngɨ novo vamʉyeráa ko mʉloomba avalaɨre isháara fuma kurumwii. ");
INSERT INTO lag_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Maa kaa, Yéesu kʉnʉ yootaanga miiririkano yaavo, akavasea, “Ʉtemi wowoosi koonɨ wiigávire havɨrɨ kwiilwa woowo kwa woowo, ʉtemi ʉwo, sɨ ʉrɨ lʉʉnga tʉkʉ. Kei, koonɨ vaantʉ va lʉkolo lʉmwɨ viigávire, lʉkolo ʉlo, sɨ lʉrɨ lʉʉnga tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Haaha koonɨ Irimʉ riigávire havɨrɨ, ʉtemi waachwe joolɨ ʉrɨ lʉʉnga? Nɨ lʉʉsa niise jeyyo sa nyuunyu moosea, nooseyya mirimʉ mɨvɨ kwa ngururu ja Belisebúuri. ");
INSERT INTO lag_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ha de haaha koonɨ nookibirya mirimʉ mɨvɨ kwa lʉvɨro lwa Belisebúuri, ha vaantʉ vaanyu nɨ kwa lʉvɨro lwa ani vakíbiryaa mirimʉ mɨvɨ? Sa jeyyo, avo kʉvalamʉrɨra varɨ nyuunyu. ");
INSERT INTO lag_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Maa kaa, koonɨ nɨɨnɨ nookibirya mirimʉ mɨvɨ kwa lʉvɨro lwa Mʉlʉʉngʉ, taangi haaha Ʉtemi wa Mʉlʉʉngʉ wafíkire kʉrɨ nyuunyu. ");
INSERT INTO lag_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mpɨɨndɨ mʉʉntʉ ˆarɨ na ngururu iichʉ́ʉngɨrɨɨre mata yaachwe kʉlaangirirya nyuumba yaachwe, máari jaachwe nɨ nkaasʉ jiri. ");
INSERT INTO lag_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Maa kaa, mʉʉntʉ wɨɨngɨ ˆarɨ na ngururu kʉlookya yeeye koonɨ amukíimɨrɨɨre na amusíindire, mʉhoka arɨ mata yaachwe yoosi yara ˆiiláangyaa na nyahɨra arɨ máari joosi, maa asʉmʉle. ");
INSERT INTO lag_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mʉʉntʉ yoyoosi ʉra sɨ ˆarɨ ivarwii raanɨ, ʉwo nɨ mʉvɨ waanɨ. Kei, ʉra sɨ ˆajíingaa hamwɨ na nɨɨnɨ, apálaa. ");
INSERT INTO lag_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mpɨɨndɨ murimʉ mʉvɨ ˆʉrɨ fuma kwa mʉʉntʉ, wadómaa na ɨsɨ ya ibaláángwii kʉra ˆkusiina maaji noo saakɨra haantʉ ho hʉmʉlʉkɨra. Na ˆʉrɨ siindwa kʉhoona aho haantʉ ho hʉmʉlʉkɨra, sea ʉrɨ, ‘Hɨndʉka ndɨrɨ na nyuumbii kwaanɨ haantʉ ˆnafuma.’ ");
INSERT INTO lag_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ˆɄrɨ hɨndʉka, washáanaa ɨra nyuumba yafyáahɨɨrwe no haambwa vyabooha. ");
INSERT INTO lag_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jeyyo, ʉwo murimʉ mʉvɨ wadómaa noo sʉmʉla viivaachwe mufungatɨ, vavɨ kʉlookya woowo. Aho, ɨyo mirimʉ yɨɨ́ngɨraa kwa ʉwo mʉʉntʉ na yiíkalaa aho. Ʉwo mʉʉntʉ asáambʉkɨrwaa kʉlookya vya ncholo.” ");
INSERT INTO lag_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mpɨɨndɨ Yéesu ˆalʉʉsáa ayo masáare, mʉʉntʉ muki ʉmwɨ ˆajáa aho mpukii ya vaantʉ, akatʉla isóso yoosea, “Yatalariwa ɨnda ˆyakuvyaala na masʉʉsʉ ˆwoonka!” ");
INSERT INTO lag_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Maa kaa, Yéesu akamʉsea, “Vatalariwa mʉnʉmʉʉnʉ vara ˆvarɨtéeraa no rituuba isáare ra Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mpɨɨndɨ mpuka ya vaantʉ ˆyatuubáa kɨɨngɨka, maa Yéesu akatuuba kiindya yoosea, “Ɨhɨ mbyaala nɨ mbɨ, yoosaaka yoonekiwe isháara, sɨ ɨrɨ heewa isháara yoyoosi tʉkʉ, maa kaa, ɨra ya Yóona mʉláali na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sa ja viintʉ Yóona ˆaava isháara kwa Vanináawi, noo ˆvyeene Mwaana wa Mʉʉntʉ arʉʉva kwa mbyaala ɨhɨ. ");
INSERT INTO lag_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sikʉ ya ʉlamu mʉtemi muki wa ɨsɨ ya saame kɨɨma arɨ na vaantʉ va mbyaala ɨhɨ, ne lʉʉsa arɨ irya. Sa yeeye ajáa avaa njɨra fuma ɨsɨ ya kʉlɨ mʉnʉmʉʉnʉ, akʉʉja joo teerera tooti ja mʉtemi Solomóoni. Haaha aha amwaarɨ mʉkʉ́ʉ́lʉ kʉlookya Solomóoni. ");
INSERT INTO lag_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kei, sikʉ ya ʉlamu vaantʉ va Nináawi kɨɨma varɨ na vaantʉ va ɨhɨ mbyaala, novo lʉʉsa varɨ irya. Sa Vanináawi ˆvakateere ʉvariyuli wa Yóona, vavalandʉka fuma uvii waavo, na aha amwaarɨ mʉkʉ́ʉ́lʉ kʉlookya Yóona! ");
INSERT INTO lag_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kusiina mʉʉntʉ ˆakórereryaa kɨmʉrɨ, maa akakɨvɨɨka haantʉ ˆhiivisa tʉkʉ au akakɨkʉnɨkɨrɨra na nyiingʉ ya kweenga tʉkʉ. Kɨrɨ vyoova jeyyo, kɨmʉrɨ nɨ kyaángwii chavɨ́ɨkwaa, sa vara ˆvookɨɨngɨra voone kɨweerʉ. ");
INSERT INTO lag_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Riiso nɨ kɨmʉrɨ cha mʉvɨrɨ waako. Koonɨ riiso rɨrɨ nkaasʉ, mʉvɨrɨ waako woosi wamema kɨweerʉ. Maa kaa, koonɨ riiso raako rasaambʉka, mʉvɨrɨ waako wamema kilwiirya. ");
INSERT INTO lag_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Haaha ʉlaange neeja, kɨweerʉ ˆʉrɨ nocho karɨ jɨ kɨve kilwiirya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Haaha koonɨ mʉvɨrɨ waako woosi ʉrɨ na kɨweerʉ baa kusiina haantʉ ˆharɨ na kilwiirya tʉkʉ, mʉvɨrɨ waako woosi watɨɨte kɨweerʉ ja viintʉ kɨmʉrɨ ˆchakʉmʉ́rɨkɨraa na kɨweerʉ chaachwe.” ");
INSERT INTO lag_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yéesu ˆakamarikirye lʉʉsa ayo masáare, maa Mʉfarisáayo ʉmwɨ akamʉteengya noo rya chákurya kaayii kwaachwe. Yéesu akatamanya, akɨɨngɨra maa akiikala méesii kurya chákurya. ");
INSERT INTO lag_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ʉwo Mʉfarisáayo ˆakamoone Yéesu yoorya baa kooyya mɨkono ja ˆvyeene tʉʉva jasea tʉkʉ, akahwaalala maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aho, maa Yéesu Mweenevyoosi akamʉsea, “Nyuunyu Mafarisáayo musúuntaa ndʉvo na saháani kwa weerwii vii, maa kaa, mitimii yaanyu mwamema kʉnyahɨra máari na ʉvɨ. ");
INSERT INTO lag_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nyuunyu mʉrɨ vahoho! Eri, sɨ mootaanga ʉra ˆʉʉmba weerwii sɨ noo ˆʉʉmba isii tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Vaambiriryi vakɨva ko mɨtɨma yaanyu yoosi, na viintʉ vyɨɨngɨ vyoosi booha viri kwaanyu. ");
INSERT INTO lag_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nɨ mpolaɨ nyuunyu Mafarisáayo! Nyuunyu mʉtóolaa ilʉʉndʉ rɨmwɨ ra malʉʉndʉ ikimi baa vira viintʉ viduudi, baa ja mbowa ja masaambɨ na viintʉ ˆvibwéeyyaa chóorya kinyʉkɨre. Maa kaa, sɨ mʉkwáatyaa ʉwoloki na kweenda kwa Mʉlʉʉngʉ tʉkʉ. Mwasaakwa mʉtʉmame aya na baa kei, karɨ mʉreke aya yɨɨngɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nɨ mpolaɨ kʉrɨ nyuunyu Mafarisáayo, sa mweenda kiikala machuumbii ya mbere masinagóogii na kuluumbiwa kwa nyemi sóokwii! ");
INSERT INTO lag_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nɨ mpolaɨ kwaanyu sa mwiifwɨ́ɨne na mbɨrɨ́ɨ́ra ˆjisiina aláama, na vaantʉ vayéendaa mweeri yaachwe baa taanga tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aho, maa ʉmwɨ wa vakiindya va Miiro akamʉsea Yéesu, “Mukiindya, ayo ulúusire nɨ kituki. Baa suusu vakiindya va Miiro ʉtʉtʉ́kɨɨre.” ");
INSERT INTO lag_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yéesu akamʉsea, “Mpolaɨ kʉrɨ nyuunyu vakiindya va Miiro! Nyuunyu mwiitíikyaa vaantʉ miriwa ˆyarutaha sɨ ˆvarɨ daha kwiitɨɨka, maa kaa, kʉmba nyuunyu veeneevyo sɨ mʉvaámbiriryaa baa nɨ imaamba vii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mpolaɨ kʉrɨ nyuunyu, sa mwajéengereraa mbɨrɨ́ɨ́ra ja valáali na mʉtwe, vara ˆvʉʉlawa nɨ vala baaba waanyu! ");
INSERT INTO lag_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jeyyo, nyuunyu moónekyaa mwaruma yara vala baaba waanyu ˆvatʉmama. Voovo vavʉláa valáali na mʉtwe, na nyuunyu moovajeengera mbɨrɨ́ɨ́ra avo valáali na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɨkɨ noo kɨra Mʉlʉʉngʉ ˆalʉʉsa kwa tooti yaachwe, ‘Laanga, vatʉma ndɨrɨ valáali na mʉtwe na vatumwi na kwaavo, maa kaa, vamwɨ kʉvʉʉlaa varɨ na vɨɨngɨ kʉvaturikirya varɨ.’ ");
INSERT INTO lag_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Haaha, vaantʉ va mbyaala ɨhɨ lamʉrɨrwa varɨ sa sakami ya valáali na mʉtwe voosi, ɨra ˆyiitwa keende weerʉ ˆyʉʉmbwa, ");
INSERT INTO lag_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kwaandɨra sakami ya Abéeli, mpaka sakami ya Sakaría, ʉra ˆʉʉlaɨrwa katɨ na katɨ ya masabáahʉ na Haantʉ Haaja. Kɨkomi noovawyɨɨra vaantʉ va mbyaala ɨhɨ lamʉrɨrwa varɨ kwa ayo yoosi. ");
INSERT INTO lag_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mpolaɨ nyuunyu vakiindya va Miiro! Nyuunyu mʉtʉ́ʉnɨkaa njɨra ya vaantʉ yo mʉtaanga Mʉlʉʉngʉ. Nyuunyu sɨ mwɨɨpata tʉkʉ, kei vara ˆvoosaaka kwɨɨpata nyuunyu mʉvakɨ́tɨraa.” ");
INSERT INTO lag_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yéesu ˆakafume kaayii kwa ʉra Mʉfarisáayo, maa vakiindya va Miiro na Mafarisáayo vakaanda hʉʉmba na vakaanda kumuurya masáare ˆyarɨ foo. ");
INSERT INTO lag_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Vasaakáa vamʉtee kwa masáare yaachwe sa vapate kɨmwɨ cho musitakirya. ");
INSERT INTO lag_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mpɨɨndɨ ijo, iyɨɨmbɨ ra vaantʉ mayana na mayana vajáa viijiinga fʉʉrʉ vandookiilwaatɨrɨra, kʉnʉ voomʉteerera Yéesu. Yéesu akaanda ta lʉʉsɨka na vapooji vaachwe yoovasea, “Laangi neeja, mʉnehe ʉsasɨ wa Mafarisáayo, noo kʉsea ʉkweembi. ");
INSERT INTO lag_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kusiina isáare ˆrakʉnɨkɨrɨrwa sɨ ˆrɨrɨ kʉnʉkʉlwa tʉkʉ, na kusiina isáare ˆraviswa, sɨ ˆrɨrɨ taangwa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sa jeyyo, roroosi ˆmwarɨvariyʉla kilwiiryii, teerwa rɨrɨ kɨweerwii, na roroosi ˆmwarɨhweeha mberii, variyʉlwa rɨrɨ italii. ");
INSERT INTO lag_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nɨ vawyɨɨra niise nyuunyu vijeengi vyaanɨ, koofi vara ˆvʉʉ́laa mʉvɨrɨ vii tʉkʉ, na ivyo viri looka sɨ varɨ daha tʉmama chochoosi ˆkɨrɨ lookya ivyo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Maa kaa, nɨɨnɨ kʉvawyɨɨra ndɨrɨ wo moofa. Ofi Mʉlʉʉngʉ. Yeeye ˆarɨ hʉmʉla kʉsʉmʉla mʉtɨma wa mʉʉntʉ, atɨɨte wiimiriri wo mʉfweitɨra na mootwii wa Jehénamu. Hɨɨ, noovawyɨɨra moofi ʉhʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Eri, seese isaano sɨ jiváwaa iyoombe magwáare yavɨrɨ tʉkʉ wʉʉ? Baa neembe nɨ ndee nduudi, kwa Mʉlʉʉngʉ sɨ ɨrɨ rimiriwa baa ɨmwɨ vii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kɨkomi, njwɨɨrɨ ˆjiri mitwii yaanyu javalwa joosi. Sa jeyyo koofi tʉkʉ, nyuunyu mʉrɨ va iyoombe ikʉʉlʉ kʉlookya seese ˆjiri foo. ");
INSERT INTO lag_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nɨ vawyɨɨra niise, yoyoosi ˆarɨ kuunduma, noo kʉsea, kʉʉndʉʉsɨkɨra nɨɨnɨ mbere ja vaantʉ, Mwaana wa Mʉʉntʉ ne muruma arɨ mbere ja Mʉlʉʉngʉ na mirimʉ yaachwe miija. ");
INSERT INTO lag_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Maa kaa, ˆarɨ sea sɨ aamányire mbere ja vaantʉ tʉkʉ, Mwaana wa Mʉʉntʉ ne sea arɨ sɨ amʉmányire tʉkʉ mbere ya mirimʉ miija ya Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na kɨra mʉʉntʉ ˆarɨ mʉkɨɨkana Mwaana wa Mʉʉntʉ, ʉvɨ waachwe sewa ʉrɨ wasírire, maa kaa, ˆarɨ mʉhɨɨntɨkɨraMʉtɨma Mʉʉja sɨ arɨ sewa ʉvɨ waachwe wasírire tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mpɨɨndɨ ˆvarɨ vatwaala na masinagóogii, mbere ja vakʉ́ʉ́lʉ na mbere ja viimiriri, karɨ mwiítweetyaa joolɨ ˆmʉrɨ lʉʉsa au joolɨ ˆmʉrɨ kuuyirya tʉkʉ, ");
INSERT INTO lag_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","sa Mʉtɨma Mʉʉja mpɨɨndɨ jiijo vakiindya arɨ kɨra ˆmwasaakwa mʉlʉʉse.” ");
INSERT INTO lag_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mʉʉntʉ ʉmwɨ fuma aho mpukii ya vaantʉ vara ˆvamʉteereráa, akamʉsea Yéesu, “Mukiindya, mʉsee mʉndʉʉ waanɨ aangavɨre viintʉ vya ʉpaari ˆtarekerwa nɨ taáta wiitʉ.” ");
INSERT INTO lag_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yéesu akamʉsea, “Aaɨ, nɨ ani aanvíikire nɨɨnɨ nɨve mʉlamuli au mʉgavi wa ʉpaari waanyu?” ");
INSERT INTO lag_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aho, maa Yéesu akavasea, “Laangi neeja! Mwɨɨme kʉlɨ na kʉdɨɨra kwiikinkima koosi, sa nkaasʉ ya mʉʉntʉ sɨ ifúmaa kʉrɨ viintʉ vyaachwe ˆviri foo ˆatɨɨte tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Maa Yéesu akavavaɨra lusímo ʉlʉ, “Kwajáa kwatɨɨte musúngaati ʉmwɨ ˆajáa na iwʉnda. Aho iwundii kwaachwe, viintʉ vyakwaatáa mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sa jeyyo, ʉwo musúngaati akiiyurya mutimii waachwe, ‘Joolɨ ndɨrɨ bweeyya? Ha de amwɨ nsiina haantʉ ho vivɨɨka viintʉ vyaanɨ ˆnaachwa tʉkʉ?’ ");
INSERT INTO lag_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aho, maa ʉwo musúngaati akasea, ‘Jei noo viintʉ ˆndɨrɨ bweeyya, vaa ndɨrɨ madongʼa yaanɨ yoosi, maa njeenge yɨɨngɨ makʉlʉkʉʉlʉ. Aho, noo kʉʉntʉ ndɨrɨ vɨɨka viintʉ vyoosi ˆndɨrɨ kuchwa na viintʉ vyɨɨngɨ vyoosi.’ ");
INSERT INTO lag_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aho, noo ndɨrɨ sea, ‘Ee mʉtɨma waanɨ, watɨɨte viintʉ ˆvyabooha ˆviri foo ˆwiivɨɨkɨra kwa myaaka ˆɨrɨ foo. Hʉmʉlʉka, urye, unywe, na uvyeende.’ ");
INSERT INTO lag_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Maa kaa, Mʉlʉʉngʉ akamʉsea, ‘Weewe ʉrɨ mʉhoho! Uchikʉ wa isikʉ nkaasʉ yaako yoosaakwa. Ha ivi viintʉ ˆwiivɨɨkɨra nɨ vya ani viri kʉva?’ ");
INSERT INTO lag_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jeyyo, noo ˆvyeene viri kwa vaantʉ vara ˆvakunguula máari ja weerʉ, vakareka kʉʉnga kwa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aho, maa Yéesu akavasea vapooji vaachwe, “Sa jeyyo reki koofa sa nkaasʉ ya mɨvɨrɨ yaanyu, che mʉrɨ kurya, au sa mɨvɨrɨ yaanyu, che mʉrɨ kiivɨkɨra. ");
INSERT INTO lag_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sa nkaasʉ nɨ mweeri ɨrɨ ya chóorya na mʉvɨrɨ nɨ kʉlookya ɨngo. ");
INSERT INTO lag_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Laangi makʉʉ́ngʉlʉ! Yooyo sɨ yaháandaa tʉkʉ baa kei sɨ ya chwíjaa tʉkʉ, yasiina madongʼa tʉkʉ. Maa kaa, Mʉlʉʉngʉ ayaríishaa. Kwa Mʉlʉʉngʉ, nyuunyu nɨ mweeri ya ndee mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nɨ ani kʉrɨ nyuunyu so manyɨka kwaachwe ifaanaa oongererye nkaasʉ yaachwe kwa sáa baa ɨmwɨ vii? ");
INSERT INTO lag_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ha de haaha koonɨ sɨ mʉrɨ daha kʉtʉmama baa isáare iduudi ja ɨrɨ, sa che mookoofa sa aya yɨɨngɨ? ");
INSERT INTO lag_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Laangi malʉva ˆvyeene yakʉ́laa. Yooyo sɨ yatʉ́mamaa baa kei sɨ yachúmaa ɨngo jaavo tʉkʉ. Kɨkomi noovawyɨɨra, baa mʉtemi Solomóoni na nkongojima yaachwe yoosi, sɨ arwɨɨkwa vyabooha ja rɨmwɨ ra malʉva ayo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ha de koonɨ Mʉlʉʉngʉ ayarwɨ́ɨkaa masaambɨ ya iwundii aya ˆyavíjaa isikʉ na lomʉtóondo yakafweitɨrwa na iviivii, sɨ arɨ varwɨɨka nyuunyu kʉlookya ayo tʉkʉ wʉʉ? Eri, sa che mumurúmaa kiduudi jei? ");
INSERT INTO lag_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Haaha reki kwiitweetya, che mʉrɨ kurya au che mʉrɨ kʉnywa. Koofi tʉkʉ sa viintʉ ivi. ");
INSERT INTO lag_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vaantʉ sɨ ˆvamʉmányire Mʉlʉʉngʉ noo viitwéetyaa sa viintʉ ivi vyoosi. Maa kaa, kʉrɨ nyuunyu Taáta waanyu amányire visaaka mwiise. ");
INSERT INTO lag_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Haaha, saakiri Ʉtemi wa Mʉlʉʉngʉ na ivyo vyoosi heewa mʉrɨ ko koongereriwa. ");
INSERT INTO lag_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Reki kwiitweetya nyuunyu mpuka nduudi, sa Taáta waanyu oona nɨ kɨɨntʉ ˆchabooha kʉvaheera nyuunyu Ʉtemi waachwe. ");
INSERT INTO lag_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Vai iyoombe máari jaanyu mʉkavaheere vakɨva. Ibweeyyiryi mifuko ya mpía sɨ ˆɨsákahalaa, noo kʉsea, kʉvɨɨka máari ya kɨkomi ya mberii kurumwii. Ʉko kusiina mwiívi ˆaséngereraa tʉkʉ na mbuuvu ˆjiríjaa ɨngo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sa kʉʉntʉ ˆkʉrɨ máari yaako ya kɨkomi ya mberii, noo kʉʉntʉ mʉtɨma waako ˆʉrɨ. ");
INSERT INTO lag_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kɨra siikʉ mʉndoolaarɨra ndɨrɨ kʉtʉmama mʉrɨmo, na vimʉrɨ vyaanyu vive vikórɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mʉve ja vatʉmami vara ˆvoomʉwoojera mweenenyuumba waavo atámiinye na ngovii ya ilóola, sa mpɨɨndɨ ˆarɨ fika vii vamʉyʉʉrɨre. ");
INSERT INTO lag_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Vatalariwa vara vatʉmami ˆveene varɨ shaanwa nɨ mweenenyuumba waavo vookeesha mpɨɨndɨ ˆarɨ kʉʉja. Kɨmaarɨ noovawyɨɨra, kwiivɨkɨra arɨ sa avatʉmamɨre, yeeye vaseeserya arɨ chákurya varye. ");
INSERT INTO lag_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Vatalariwa vatʉmami avo, mweenenyuumba waavo koonɨ avashɨ́hɨɨne varɨ miiso voomʉwoojera, baa koonɨ uújire nuuchikʉ katɨ, au namuyiingʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Taangi neeja masáare aya, mweenenyuumba ngaarɨ ajáa ataanga mpɨɨndɨ ˆngʼeene mwiívi arɨ kʉʉja, ngaarɨ sɨ areka nyuumba yaachwe ɨbokwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Baa nyuunyu moosaakwa mʉve mwɨɨ́mɨre neeja mpɨɨndɨ joosi, sa Mwaana wa Mʉʉntʉ kʉʉja arɨ mpɨɨndɨ sɨ ˆmookoona kʉʉja arɨ.” ");
INSERT INTO lag_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aho, maa Peéteri akamuurya, “Mʉkʉ́lʉ, lusímo ʉlʉ nɨ suusu vii wootuwyɨɨra bakʉ vaantʉ voosi?” ");
INSERT INTO lag_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mweenevyoosi akamʉsea, “Nɨ mwiimiriri arɨkwɨ noo ˆarɨ wo kiilaangiwa na ˆarɨ na tooti? Kei, nɨ mʉtʉmami arɨkwɨ arɨ rekwa nɨ mweenenyuumba waachwe avɨɨmɨrɨre viivaachwe na avaheere chóorya mpɨɨndɨ ˆjasaakwa, maa mweenenyuumba akere njɨra? ");
INSERT INTO lag_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Atalariwa mʉtʉmami ʉra mweenenyuumba waachwe ˆarɨ mʉshaana yoobweeyya jeyyo, mpɨɨndɨ ˆarɨ hɨndʉka. ");
INSERT INTO lag_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kɨmaarɨ noovawyɨɨra, mweenenyuumba waachwe mʉvɨɨka arɨ ʉwo mwiimiriri ɨɨmɨrɨre viintʉ vyaachwe vyoosi vʉʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Maa kaa, koonɨ ʉwo mwiimiriri iírɨrɨkɨɨne, ‘Mweenenyuumba waanɨ achérevire,’ na aande kʉvavaa vara vatʉmami va kɨɨntʉ kɨlʉme na va kɨɨntʉ kiki, kʉnʉ yoorya, no nywa, no reeva, ");
INSERT INTO lag_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mweenenyuumba waachwe kʉʉja arɨ sikʉ ˆngʼeene sɨ yookoona arɨ kʉʉja, na sáa sɨ ˆɨɨmányire. Aho, Mweenenyuumba waachwe mʉtematema arɨ na mʉvɨɨka arɨ hamwɨ na vara sɨ ˆvarɨ vookiilaangya. ");
INSERT INTO lag_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mʉtʉmami ʉra ˆamányire ˆcheene mweenenyuumba waachwe asáakaa, maa kaa, akareka kwɨɨma neeja baa kei akareka tʉmama ja ˆvyeene ʉwo mweenenyuumba waachwe eenda, laɨrwa arɨ ˆkɨrɨ mooto. ");
INSERT INTO lag_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Maa kaa, mwiimiriri ʉra sɨ ˆamányire, ˆatʉ́mamire yara ˆyɨɨma neeja kʉvawa, vawa arɨ kiduudi. Mʉʉntʉ ʉra ˆaheewa ˆviri foo, ʉwo atɨɨte noongwa ya ˆviri foo na ʉra ˆakwaatiwa mɨrɨmo ˆɨrɨ foo, saakwa ɨrɨ, ˆɨrɨ foo. ");
INSERT INTO lag_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nʉʉja na kʉrɨ weerʉ, sa nkorererye mooto. Nɨ vyaangʉ ngaarɨ waándire korera. ");
INSERT INTO lag_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Maa kaa, natɨɨte uturikiri, ˆnoosaaka nturikiriwe na tuuba ndɨrɨ tʉrɨkɨra mʉnʉmʉʉnʉ mutimii waanɨ fʉʉrʉ uturikiri ʉwo ˆʉrɨ hʉmʉla. ");
INSERT INTO lag_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mukiisea nʉʉja na aha weerwii kʉreeta mwiikalo mʉʉja? Aka tʉkʉ, nareeta kwiikera! ");
INSERT INTO lag_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kwaandɨra haaha, nyuumba ˆɨrɨ na vaantʉ vasaano, kwiikera veende vatatʉ kwiiruta ndihi na vavɨrɨ na vavɨrɨ kwiiruta ndihi na vatatʉ. ");
INSERT INTO lag_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taáta kwiitoola eende na mwaana waachwe na mwaana kwiitoola eende na taáta waavo. Íyo kwiitoola eende na muhíínja waachwe, na muhíínja kwiitoola eende na íyo waavo. Íyo mʉkwɨ kwiitoola eende na muki wa mwaana waachwe, na muki wa mwaana kwiitoola eende na mʉkwɨ waachwe.” ");
INSERT INTO lag_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kei Yéesu akɨɨsea ɨra mpuka, “Koonɨ mwɨɨ́ne ichu raándukire ivaru ra ʉsweero hahara mʉséaa, ‘Mbula vaa ɨrɨ,’ noyo yaváa. ");
INSERT INTO lag_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na koonɨ mwɨɨ́ne mpeho yoowuva fuma saame, mwaséaa, ‘Kʉva kʉrɨ na irʉtɨra,’ na kɨkomi vyavíjaa jeyyo. ");
INSERT INTO lag_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nyuunyu vakweembi, mwamányire taanga viintʉ vya kurumu na vya weerʉ kwa ˆvyeene ko koonekana! Sa che moosiindwa taanga masáare aya ˆyootʉmamwa haaha? ");
INSERT INTO lag_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sa che sɨ moolamʉla veeneevyo kɨɨntʉ cha ʉwoloki? ");
INSERT INTO lag_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mpɨɨndɨ ˆmʉrɨ njirii moodoma na balásii na mʉvɨ waako, mʉloombe iivae na mpʉʉlo chaangʉ mpɨɨndɨ ˆmʉkaarɨ njirii. Koonɨ sɨ ʉbwéeyyiirye jeyyo, kʉtwaala arɨ na balásii na ʉko mʉlamuli kʉkwaatya arɨ mɨkonwii ya mʉlʉkalʉka, ne kʉtwaala arɨ na mʉnyololwii na ngururu. ");
INSERT INTO lag_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kɨmaarɨ nookuwyɨɨra, sɨ ʉrɨ rekerwa ʉko tʉkʉ, mpaka ʉrɨhe mpoocho yo marikirirya.” ");
INSERT INTO lag_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mpɨɨndɨ yɨɨyo, vaantʉ vamwɨ vajáa vamuwyɨɨra Yéesu masáare ya Vagaliláaya vamwɨ ˆveene Piláato ajáa avʉʉlaa mpɨɨndɨ ˆvamʉtooreráa Mʉlʉʉngʉ mpóryo. ");
INSERT INTO lag_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aho, maa Yéesu akavuurya, “Eri, mukiisea ava Vagaliláaya ˆvaakwya inkwya ɨhɨ, nɨ vavɨ vajáa kʉlookya Vagaliláaya vɨɨngɨ voosi vʉʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aka tʉkʉ! Noovawyɨɨra, koonɨ sɨ mʉválandukire fuma uvii waanyu, voosi sira mʉrɨ jeyyo! ");
INSERT INTO lag_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au vara ikimi na vanaanɨ (18) ˆveene valaarɨrwa nɨ mʉnáara vakakwya kʉra Siloáamu, nɨ kiisea mwiise nɨ vavɨ vajáa kʉlookya vaantʉ vɨɨngɨ voosi ˆveene viikaláa múujii wa Yerusaléemu wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aka tʉkʉ! Noovawyɨɨra nyuunyu, koonɨ sɨ mʉválandukire fuma uvii waanyu, baa nyuunyu sira mʉrɨ viivyo!” ");
INSERT INTO lag_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aho, maa Yéesu akavawyɨɨra lusímo ʉlʉ, “Mʉʉntʉ ʉmwɨ ajáa atɨɨte mʉsaambu ˆwahaandwa iwundii raachwe ra sabíibu. Sikʉ ɨmwɨ akatamanya noo tʉʉnda saambu aho mʉsaambwii, maa kaa, sɨ ashaana saambu baa ɨmwɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sa jeyyo akamʉsea mʉtʉmami wa iwundii raachwe, ‘Laanga, kwa myaaka ɨtatʉ nʉʉja noo tʉʉnda saambu ja mʉtɨ ʉhʉ, maa kaa, sɨ nɨnapata baa saambu ɨmwɨ vii tʉkʉ! Ʉkanye! Sa nɨ woosaambʉla iwʉnda vii!’ ");
INSERT INTO lag_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ʉra mʉtʉmami wa iwundii akamʉsea, ‘Mʉkʉ́lʉ, ʉreke ʉhʉ mwaaka kei, nɨɨnɨ kʉʉrɨmɨra ndɨrɨ na kʉʉvɨkɨra ndɨrɨ nchuúkuru. ");
INSERT INTO lag_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Koonɨ ʉrɨ tʉʉnga saambu mwaaka ˆwookʉʉja, booha viri, koonɨ sɨ jeyyo wʉʉkanye.’ ” ");
INSERT INTO lag_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sikʉ ɨmwɨ ya Sabáato, Yéesu akiindyáa sinagóogii ɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aho sinagóogii, kʉjáa kwatɨɨte mʉʉntʉ muki ʉmwɨ, ˆajáa na murimʉ mʉvɨ. Ʉwo murimʉ mʉvɨ ʉjáa wamukukumarya na sɨ adaháa woloka tʉkʉ kwa myaaka ikimi na ɨnaanɨ (18). ");
INSERT INTO lag_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yéesu ˆakamoone, maa akamwaanɨrɨra yoosea, “Íyo, ʉrékɨɨrwe nɨ ndwáala yaako!” ");
INSERT INTO lag_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aho, Yéesu akamʉvɨkɨra mɨkono yaachwe, na hahara akawoloka na akaanda kʉmʉbweeyyirya Mʉlʉʉngʉ nkongojima. ");
INSERT INTO lag_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Maa kaa, mʉkʉ́ʉ́lʉ wa sinagóogi akakalala sa viintʉ Yéesu ˆajáa amʉhóriirye ʉra mʉʉntʉ muki sikʉ ya Sabáato. Sa jeyyo, ʉra mʉkʉ́ʉ́lʉ akavasea vaantʉ, “Júma yatɨɨte sikʉ mʉsasatʉ jo tʉmama. Moosaakwa mʉndookʉʉja noo horiwa sikʉ ijo na sɨ sikʉ ya Sabáato tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Maa kaa, Mweenevyoosi akamʉsea, “Aka, nyuunyu vakweembi! Eri, nɨ ani sɨ ayʉ́ʉrɨraa ngʼoombe jaachwe na ndákwi fuma waámii noo jitwaala noo nyweesha sikʉ ya Sabáato? ");
INSERT INTO lag_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ʉhʉ mʉʉntʉ muki nɨ mwaana wa Aburaháamu. Irimʉ ramuchuunga kwa myaaka ikimi na ɨnaanɨ. Eri, sɨ asaakwa arekerwe fuma mʉnyololwii sikʉ ya Sabáato tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yéesu ˆakalʉʉse aya, vavɨ vaachwe vakakwaatwa nɨ soni, maa kaa, vaantʉ vakavyeenda sa masáare ˆyoohwaalarya ˆatʉmamáa. ");
INSERT INTO lag_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Aho, maa Yéesu akavuurya, “Ʉtemi wa Mʉlʉʉngʉ wiifwɨ́ɨne na che? Nʉʉfwaanirirye na che? ");
INSERT INTO lag_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wiifwɨ́ɨne na mpeke nduudi ya haradáali ˆngʼeene mʉʉntʉ atoola akahaanda iwundii raachwe. Ɨyo mbeyʉ ɨkamera, ɨkava mʉtɨ na ndee jikajeenga vivururu matáampii yaachwe.” ");
INSERT INTO lag_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yéesu akavuurya kei, “Na che ndɨrɨ kʉʉfwaanirirya Ʉtemi wa Mʉlʉʉngʉ? ");
INSERT INTO lag_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wiifwɨ́ɨne na ʉsasɨ ˆmweene mʉʉntʉ muki atoola, akakaandɨra muchu wa ngáano viháárɨ vitatʉ vya saimʉ. Ʉra ʉsasɨ, ʉkasuuwya muchu woosi.” ");
INSERT INTO lag_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yéesu akatuuba njɨra yaachwe ɨra ˆadomáa na Yerusaléemu. Na njirii akiindyáa vaantʉ míijii na maturii kʉʉntʉ ˆatweeráa. ");
INSERT INTO lag_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sikʉ ɨmwɨ, mʉʉntʉ ʉmwɨ akamuurya, “Mʉkʉ́lʉ, nɨ vake vii noo Mʉlʉʉngʉ arɨ lamurirya wʉʉ?” Yéesu akamʉsea, ");
INSERT INTO lag_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ifafiriryi mwɨɨngɨre na mʉryaango ˆwafinya. Kɨkomi noovawyɨɨra, ˆvarɨ foo saaka varɨ kwɨɨngɨra maa kaa, sɨ varɨ daha tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mpɨɨndɨ kʉʉja jiise, mweenenyuumba kiinʉka arɨ na chuunga arɨ mʉryaango, aho kɨɨma mʉrɨ weerwii de mwaande luumbya kʉnʉ moosea, ‘Ee mʉkʉ́lʉ, tʉyʉʉrɨre!’ Maa kaa, yeeye vasea arɨ, ‘Sɨ nɨvamányire na sɨ nootaanga kʉʉntʉ ˆmufúmire tʉkʉ!’ ");
INSERT INTO lag_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Naanyu sea mʉrɨ, ‘Suusu noo vara ˆtarijáa no nywa hamwɨ na weewe! Kei, weewe utukiindyáa maturii ya mɨɨtʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ne vasea arɨ, ‘Navawyɨ́ɨrɨɨre, sɨ nɨvamányire tʉkʉ, na sɨ mányire kʉʉntʉ ˆmufúmire tʉkʉ! Isunki kwaanɨ nyuunyu vavɨ!’ ");
INSERT INTO lag_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ʉko rɨra mweende no sha mayeo, mpɨɨndɨ ˆmʉrɨ moona Aburaháamu, Isaka na Yaakúupu na valáali na mʉtwe Ʉtemii wa Mʉlʉʉngʉ na kʉnʉ nyuunyu mʉfwéitirwe na weerwii. ");
INSERT INTO lag_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vaantʉ kʉʉja varɨ, fuma itʉʉmba na ʉsweero, ʉtʉ́rʉko na saame, novo kiikala varɨ haantʉ ˆviimiriwa neeja ngovii ʉko Ʉtemii wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Laanga, vamwaarɨ va mukirii ˆvarɨ kʉva va ncholo, na va ncholo varɨ kʉva mukirii.” ");
INSERT INTO lag_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mpɨɨndɨ jiijo, Mafarisáayo vamwɨ vakɨɨta na kʉrɨ Yéesu, maa vakamʉsea, “Looka aha, tamanya na kwɨɨngɨ sa Heróode saaka iise kʉkʉʉlaa.” ");
INSERT INTO lag_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yéesu akavasea, “Tamanyi mʉkɨɨsee ɨra mʉʉnjʉ ˆɨrɨ kɨnchʉnkʉla, ‘Laanga, mwaarɨ nookibirya mirimʉ mɨvɨ, no horya vaantʉ isikʉ na lomʉtóondo. Na sikʉ ya katatʉ marikirirya ndɨrɨ mʉrɨmo waanɨ.’ ");
INSERT INTO lag_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Baa neembe nɨ jeyyo, tuuba niise na njɨra yaanɨ isikʉ, lomʉtóondo na kukyɨɨre fika ndɨrɨ. Bweeyya niise jeyyo, sa sɨ vyasaakwa mʉláali na mʉtwe akwye haantʉ hɨɨngɨ tʉkʉ, maa kaa, nɨ Yerusaléemu vii. ");
INSERT INTO lag_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aka Yerusaléemu, aka Yerusaléemu, weewe ˆwʉʉ́laa valáali na mʉtwe no vavaa na mawye vara ˆvatʉ́mwaa kwaako! Nɨ kangaɨ nasáakaa kʉvajiinga vaana vaako ja nkʉkʉ viintʉ ˆijíingaa nchʉʉ́rʉ jaachwe mbavii? Baa jei sɨ wuunduma tʉkʉ! ");
INSERT INTO lag_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Laangi! Mʉlʉʉngʉ avarékɨɨre nyuumba jaanyu nyuuveene! Nɨ kʉvawyɨɨra niise, sɨ mʉrɨ kʉʉnyona kei tʉkʉ, fʉʉrʉ mpɨɨndɨ ˆmʉkaséire, ‘Atalariwa yeeye ˆyookʉʉja kwa irina ra Ijʉva.’” ");
INSERT INTO lag_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sikʉ ɨmwɨ ya Sabáato, Yéesu ajáa adoma noo rya chákurya kaayii kwa mʉkʉ́ʉ́lʉ ʉmwɨ wa Mafarisáayo. Mpɨɨndɨ ˆajáa aho, vaantʉ vamʉlaangisháa sa voone nɨ che arɨ tʉmama sikʉ ya Sabáato. ");
INSERT INTO lag_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aho, kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆajáa na ndwáala yo suuwa mawʉlʉ na mɨkono. ");
INSERT INTO lag_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hara, maa Yéesu akavuurya Mafarisáayo na vakiindya va Miiro, “Eri, Miiro yaruma kʉmʉhorya mʉʉntʉ sikʉ ya Sabáato, bakʉ tʉkʉ?” ");
INSERT INTO lag_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Novo vakakirinya sawu. Jeyyo Yéesu akamʉsaasya ʉra mʉlwɨ́ɨrɨ, akamʉhorya, maa akamʉsea itamanyɨre. ");
INSERT INTO lag_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aho, maa akavuurya, “Ivi koonɨ ʉmwɨ waanyu mwaana waachwe au ngʼoombe yaachwe yawyɨ́ɨrɨɨre isimii sɨ arɨ doma no mʉseyya chaangʉ baa neembe nɨ sikʉ ya Sabáato tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Voovo, vakasova cho muuyirya. ");
INSERT INTO lag_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yéesu akoona vara ˆvajáa valáarikirwe ˆvyeene viisaawʉrɨráa machuumbi ya nyemi mpɨɨndɨ ja chákurya. Aho, akavawyɨɨra lusímo ʉlʉ, ");
INSERT INTO lag_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Koonɨ ʉláarikirwe na ngovii ya ilóola, karɨ wiíkalaa ichuumbii ra mbere tʉkʉ, sa ifaanaa ɨkava amwaarɨ wɨɨngɨ ˆaláarikirwe ˆanyémiwaa kʉlookya weewe. ");
INSERT INTO lag_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na mpɨɨndɨ ˆarɨ kʉʉja mweenengovi ʉra ˆavaláarikire, weewe na yeeye kʉsea arɨ, ‘Sosoloka ʉhʉ iikale.’ Aho, saama ʉrɨ na ichuumbii ra nyuma kʉnʉ ʉkwáatirwe nɨ soni. ");
INSERT INTO lag_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kɨrɨ vyoobweeyya jeyyo, weewe koonɨ ʉláarikirwe, ikala ichuumbii ra nyuma sa ˆarɨ kʉʉja mweenengovi ya ilóola akʉsee, ‘Aaɨ yeenda jiwiikale aha mbere.’ Aho, noo nkongojima yaako ɨrɨ koonekana mbere ja vaantʉ voosi ˆvaláarikirwe. ");
INSERT INTO lag_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sa kɨra mʉʉntʉ ˆiiyámbukyaa na mweeri, kiimiwa arɨ na ɨsɨ, na ʉra ˆiikíimyaa na ɨsɨ, kaambukiwa arɨ.” ");
INSERT INTO lag_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aho, maa Yéesu akamʉsea ʉra ˆajáa avaláarikire, “Mpɨɨndɨ ˆwookiimya neeja ngovi ya cháámuusi au kiiwʉlo, karɨ ʉláarɨkaa vijeengi vyaako, au vandʉʉ vaako, au vaantʉ va lʉkolo lwaako, au vakaaya vaako vara ˆvarɨ vasúngaati vii tʉkʉ. Koonɨ ʉbwéeyyiirye jeyyo, baa voovo ifaanaa vakʉlaarɨke weewe na kwaavo, maa ʉve uríhirwe. ");
INSERT INTO lag_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Maa kaa, weewe koonɨ woobweeyya ngovi, laarɨka vakɨva, vivete na vahoku. ");
INSERT INTO lag_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aho, talariwa ʉrɨ, sa avo vasiina lʉvɨro lo kʉrɨha tʉkʉ. Weewe rɨhwa ʉrɨ nɨ Mʉlʉʉngʉ mpɨɨndɨ jo fʉfʉlwa vara vawoloki.” ");
INSERT INTO lag_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ʉmwɨ ˆajáa iíkyɨɨre aho chákuryii na Yéesu ˆakateere masáare ayo, maa akasea, “Atalariwa mʉʉntʉ ˆarɨ kurya ngovi Ʉtemii wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aho, Yéesu akamʉsea, “Mʉʉntʉ ʉmwɨ ajáa iimya neeja ngovi nkʉʉlʉ, maa akavalaarɨka vaantʉ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mpɨɨndɨ ja ngovi ˆjikafike, akamʉtʉma mʉtʉmami waachwe kwa vaantʉ vara ˆajáa avalaarɨka sa akavasee, ‘Teengi, viintʉ vyoosi vyahʉ́mwɨɨre!’ ");
INSERT INTO lag_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Maa kaa, voosi ˆvajáa valaarɨkwa vakaanda ʉkooveri wo lʉʉsa vadɨɨre kʉʉja. Wa ncholo ko koovera akasea, ‘Nawúrire iwʉnda noosaakwa nkarɨlaange. Kalaama sɨ ndɨrɨ kʉʉja tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wa kavɨrɨ ne akasea, ‘Nawúrire ngʼoombe ikimi jo rɨma, jei nɨ tamanya niise noo jiyera, kalaama sɨ ndɨrɨ kʉʉja tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wa katatʉ ko koovera ne akasea, ‘Nasʉ́mwɨɨre muki, sa jeyyo sɨ ndɨrɨ daha kʉʉja tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ʉra mʉtʉmami akahɨndʉka, akɨɨta muwyɨɨra mweenenyuumba waachwe kɨra ˆvaséire. Aho, ʉra mweenenyuumba akakalala, maa akamʉlairirya mʉtʉmami waachwe yoomʉsea, ‘Tamanya chaangʉ na balíbalii na njirii joosi ja ʉhʉ múuji, ʉkavareete na aha vakɨva, vivete na vahoku.’ ");
INSERT INTO lag_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ʉra mʉtʉmami ˆakahɨndʉke, maa akamʉsea mweenenyuumba waachwe, ‘Mʉkʉ́lʉ, yoosi ˆmeene waandáiriirye nayatʉ́mamire, maa kaa, nkalo ɨmwaarɨ ɨchɨ́hɨɨre.’ ");
INSERT INTO lag_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Sa jeyyo, mweenenyuumba waachwe akamʉsea mʉtʉmami, ‘Tamanya na balíbalii jira ˆjiri weerwii ya múuji, ʉkavadoomererye vaantʉ sa nyuumba yaanɨ ɨmeme. ");
INSERT INTO lag_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sa kɨkomi noovawyɨɨra, kusiina mʉʉntʉ baa ʉmwɨ wa vara ˆnavalaarɨka arɨ saɨra ngovi yaanɨ tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Haaha mpuka nkʉʉlʉ yamutuubáa Yéesu. Yéesu akiilorera, maa akavasea, ");
INSERT INTO lag_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mʉʉntʉ yoyoosi ˆyoosaaka kuuntuuba, asaakwa aanyende nɨɨnɨ kʉlookya ˆvyeene amweenda taáta waavo, íyo waavo, muki waachwe, vaana vaachwe, marʉʉmbʉ yaachwe, vandʉʉ vaachwe na baa kʉlookya ˆvyeene eenda nkaasʉ yaachwe. Koonɨ sɨ jeyyo, sɨ arɨ kʉva mʉpooji waanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mʉʉntʉ yoyoosi koonɨ sɨ avérekire mʉsaláaba waachwe ko tʉrɨkɨra na baa koonɨ nɨ kukwya sa nɨɨnɨ na aantuube, sɨ arɨ kʉva mʉpooji waanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nɨ ani ʉmwɨ waanyu, koonɨ yoosaaka jeenga sɨ iíkalaa ɨsɨ ta kʉlaanga viintʉ vyoosi ˆyoosaakwa ave novyo, sa ataange koonɨ arɨ na mpía jo marikirya ijeengo raachwe? ");
INSERT INTO lag_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Koonɨ sɨ abwéeyyiirye jeyyo, ifaanaa akajeenga mwaariryo wa nyuumba vii, maa asiindwe marikirirya ijeengo roosi. Na voosi ˆvarɨ koona ijeengo raachwe, mʉsekerera varɨ, ");
INSERT INTO lag_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","voosea, ‘Mʉʉntʉ ʉhʉ aanda jeenga, maa akasiindwa ngururu jo marikirirya.’ ");
INSERT INTO lag_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Haaha iririkani mʉtemi ʉra ˆyoosaaka atamanye na nkoondwii noo lwa na mʉtemi wɨɨngɨ. Nɨ mʉtemi arɨkwɨ sɨ ˆarɨ kiikala ta iiririkane neeja, koonɨ arɨ daha kʉlwa na mʉtemi ˆarɨ na vaantʉ va nkoondo mayana makumi yavɨrɨ (20,000), na kʉnʉ yeeye arɨ na vaantʉ va nkoondo mayana ikimi rɨmwɨ (10,000) vii? ");
INSERT INTO lag_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Koonɨ ɨɨ́ne siindwa arɨ, tʉma arɨ vaantʉ vaachwe, vatamanye na kwa ʉra mʉtemi wɨɨngɨ ntɨ ˆakaarɨ kʉlɨ, sa viiteerwe. ");
INSERT INTO lag_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Noo jeyyo viri kʉrɨ nyuunyu, kusiina ʉmwɨ waanyu ˆarɨ kʉva mʉpooji waanɨ koonɨ sɨ arékire vira vyoosi ˆarɨ novyo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sangása nɨ kɨɨntʉ ˆchabooha kʉterekera, maa kaa, koonɨ yasúukire nɨ che ɨrɨ vɨkɨrwa sa mwerere waachwe ʉhɨndʉkɨre kei? ");
INSERT INTO lag_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sangása ˆɨrɨ jeyyo, sɨ yabooha baa kwiita iwundii tʉkʉ, baa nchuúkurwii tʉkʉ, ɨyo nɨ ɨfwéitwaa vii. ˆArɨ na matu yo teerera, nɨ ateere!” ");
INSERT INTO lag_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Haaha, vasaankanʼyi kóodi na vaduwalo vadomáa na kʉrɨ Yéesu noo mʉteerera. ");
INSERT INTO lag_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Maa kaa, Mafarisáayo na vakiindya va Miiro vakaanda ngʼuula voosea, “Sa che ʉhʉ mʉʉntʉ iíkalaa na maduwalo baa kei ɨndoorya chóorya noyo?” ");
INSERT INTO lag_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aho, maa Yéesu akavasɨmɨra lusímo ʉlʉ, ");
INSERT INTO lag_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Koonɨ ʉmwɨ waanyu arɨ na muundi igana rɨmwɨ (100), na koonɨ muundi ɨmwɨ yarɨ́mɨɨre, che arɨ bweeyya? Jireka arɨ jira muundi makumi keenda na keenda (99) ibaláángwii adome akasaake ɨra ˆyatáahikire mpaka ɨɨpate. ");
INSERT INTO lag_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na ˆarɨ kɨɨpata, kɨɨvaala arɨ mavei kʉnʉ arɨ na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ˆArɨ fika kaayii, kʉvaanɨrɨra arɨ vijeengi vyaachwe na vakaaya vaachwe kʉnʉ yoovasea, ‘Eryi mɨtɨma hamwɨ na nɨɨnɨ, sa muundi yaanɨ ˆngʼeene yaarɨ yarɨ́mɨɨre, nɨɨyɨɨ́ne!’ ");
INSERT INTO lag_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Viivyo noovawyɨɨra, kʉva kʉrɨ na cheerʉ mʉnʉmʉʉnʉ kurumwii, haantʉ mʉʉntʉ ʉmwɨ mʉvɨ ˆarɨ mʉvalandʉkɨra Mʉlʉʉngʉ. Cheerʉ ɨkyo kʉva kɨrɨ nɨ kɨkʉʉlʉ kʉlookya vaantʉ makumi keenda na keenda (99) vara ˆviiyónaa voovo nɨ vawoloki, ˆvasiina kɨɨntʉ cho vabweeyya vamʉvalandʉkɨre Mʉlʉʉngʉ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yéesu akavawyɨɨra lusímo lwɨɨngɨ, “Tʉsee baa ja koonɨ mʉʉntʉ muki arɨ na mpía ikimi na koonɨ ɨmwɨ yarɨ́mɨɨre che arɨ bweeyya? Korererya arɨ kɨmʉrɨ na fyaahɨra arɨ nyuumba yoosi vʉʉ, yoosaakɨra ɨra mpía mpaka ɨɨpate. ");
INSERT INTO lag_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na ˆarɨ kɨɨpata, vaanɨrɨra arɨ vijeengi vyaachwe na vakaaya vaachwe na vasea arɨ, ‘Eryi mɨtɨma hamwɨ na nɨɨnɨ, sa mpía yaanɨ ˆngʼeene yaarɨ yarɨ́mɨɨre, nɨɨyɨɨ́ne.’ ");
INSERT INTO lag_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Viivyo, noovawyɨɨra, kwatɨɨte cheerʉ kɨkʉʉlʉ kwa mirimʉ miija ya Mʉlʉʉngʉ, mpɨɨndɨ mʉvɨ ʉmwɨ ˆarɨ mʉvalandʉkɨra Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yéesu kei akavawyɨɨra lusímo lwɨɨngɨ yoovasea, “Mʉʉntʉ ʉmwɨ ajáa atɨɨte vaana valʉme vavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mwaana waachwe muduudi, akamʉsea taáta waavo, ‘Taáta nooloomba ʉpaari waanɨ.’ Jeyyo, akavagavɨra vaana vaachwe ʉpaari waavo. ");
INSERT INTO lag_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mpɨɨndɨ kiduudi ˆjikalooke, ʉra mudúúdi akasaankanʼya máari jaachwe joosi vʉʉ, maa akatamanya na ɨsɨ ya kʉlɨ. Ʉko akɨɨta takʉna máari yoosi vʉʉ. ");
INSERT INTO lag_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ˆAkamarikirye kɨra kɨɨntʉ ˆajáa nocho, ɨra ɨsɨ yoosi ɨkava na njala ya imalo, ne akava asiina chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aho, akatamanya na kwa mʉʉntʉ ʉmwɨ wa ɨsɨ ɨra, akɨtooloomba mʉrɨmo. Ʉra mʉʉntʉ akamʉtwaala na iwundii kwaachwe ɨndookooriisha nkaamba jaachwe. ");
INSERT INTO lag_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ʉwo mʉtavana akava yoomererya matɨ mafaala ˆmeene nkaamba jarijáa. Na kusiina mʉʉntʉ ˆamʉheráa chákurya chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Maa kaa, ˆakiiririkane mutimii waachwe, maa akasea, ‘Amwɨ vatʉmami va taáta wiitʉ varijáa mpaka vandoocheerya? Nɨɨnɨ mwaarɨ nookwya na njala aha! ");
INSERT INTO lag_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Haaha hɨndʉka niise na kwa taáta nkamʉsee, “Taáta, nabweeyya ʉvɨ kwa Mʉlʉʉngʉ na kʉrɨ weewe. ");
INSERT INTO lag_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nɨɨnɨ sɨ nɨɨma neeja kwaanɨrɨrwa mwaana waako kei tʉkʉ, mbɨɨka nɨve ja ʉmwɨ wa vatʉmami vaako. ”’ ");
INSERT INTO lag_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aho, akiinʉka, akakwaata njɨra na kaayii kwa taáta waavo. ˆAkasengerere kaayii, taáta waavo akamoona kʉra kʉlɨ, maa akamoonera mbavariri. Akamʉkɨbɨrɨra, akamʉkwaatɨrɨra, maa akamʉsʉndɨra mwaana waachwe. ");
INSERT INTO lag_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aho, mwaana waachwe akamʉsea, ‘Taáta, nabweeyya ʉvɨ kʉrɨ kurumu na kʉrɨ weewe. Nɨɨnɨ sɨ nɨɨma neeja kwaanɨrɨrwa mwaana waako kei tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Maa kaa, taáta waavo akavasea vatʉmami vaachwe, ‘Reeti chaangʉ ɨngo ˆyaboohabooha mʉmʉvɨkɨre, muvikiri ipoo mʉkonwii waachwe na viráatʉ majewii. ");
INSERT INTO lag_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Reeti njɨɨkʉ ˆyaneneha, mʉsɨɨnje, turye ngovi. ");
INSERT INTO lag_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sa ʉhʉ mwaana waanɨ ajáa aakwya haaha afúfukire, ajáa ataahɨka haaha oónekɨɨne.’ Aho, vakaanda bweeyya ngovi. ");
INSERT INTO lag_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mpɨɨndɨ ijo, ʉra mwaana mʉkʉʉlʉ nɨ iwundii ajáa. Mpɨɨndɨ ˆahɨndʉkáa ˆakasengerere kaayii, akateera chɨɨ́mbo na vina. ");
INSERT INTO lag_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aho, akamwaanɨrɨra mʉtʉmami ʉmwɨ, maa akamuurya, ‘Nɨ che kwatɨɨte?’ ");
INSERT INTO lag_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ʉra mʉtʉmami akamʉsea, ‘Mudúúdi waako uújire na taáta waanyu amʉsɨ́ɨnjɨɨre ɨra njɨɨkʉ ˆyanona sa taáta waanyu amʉhókɨɨre arɨ nkaasʉnkaasʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ʉra mwaana mʉkʉʉlʉ akavisʉʉla, maa akasiita kwɨɨngɨra na nyuumbii. Aho, taáta waavo akafuma na weerwii noo mʉkalaamya ɨɨngɨre. ");
INSERT INTO lag_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Maa kaa, yeeye akamʉsea taáta waavo, ‘Laanga, myaaka yoosi ɨhɨ nɨɨnɨ natʉmama aha kaayii, baa sɨ nɨnawaayya kuchwa matɨ ʉlairiri waako wowoosi baa sikʉ ɨmwɨ tʉkʉ! Maa kaa, nɨɨnɨ sɨ ʉnawaayya kʉʉmpeera baa kaburi vii, nkárye nɨvyeende na viivaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Haaha ʉhʉ mwaana waako ˆmweene atakuna máari jaako na vaantʉ vaki ˆvayéendaa na valʉme va vaantʉ, uújire na kaayii ʉmʉsɨ́ɨnjɨɨre njɨɨkʉ ɨra ˆyanona.’ ");
INSERT INTO lag_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Taáta waavo akamʉsea, ‘Mwanawaanɨ, weewe nɨ na nɨɨnɨ ʉrɨ sikʉ joosi, viintʉ vyoosi ˆndɨrɨ novyo nɨ vyaako. ");
INSERT INTO lag_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Haaha nɨ vyabooha kʉbweeyya ngovi tuvyeende, sa mwaanaanyu ajáa aakwya, haaha nɨ nkaasʉ arɨ. Yeeye ajáa arɨmɨra, haaha oónekɨɨne.’ ” ");
INSERT INTO lag_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kei Yéesu akavawyɨɨra lusímo ʉlʉ vapooji vaachwe, yoovasea, “Kʉjáa kwatɨɨte musúngaati ʉmwɨ na mwiimiriri wa máari jaachwe. Ʉwo musúngaati akateera mwiimiriri wa máari jaachwe yoosaambʉla máari. ");
INSERT INTO lag_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sa jeyyo ʉwo musúngaati akamwaanɨrɨra mwiimiriri akamʉsea, ‘Natéɨɨre kɨra ˆwoobweeyya na máari jaanɨ! Laɨra kɨra ˆʉbweeyyirya máari jaanɨ, sa sɨ ʉrɨ kʉva mwiimiriri wa máari jaanɨ tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ʉra mwiimiriri akiiririkana mutimii waachwe, ‘Musúngaati waanɨ nɨ kʉʉnseyya iise murimwii waanɨ. Haaha nɨ che ndɨrɨ bweeyya? Nɨɨnɨ nsiina ngururu jo rɨma tʉkʉ, na nookoona soni yo loombaloomba. ");
INSERT INTO lag_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Natáangire ˆcheene ndɨrɨ bweeyya, sa ˆndɨrɨ rekiwa mʉrɨmo waanɨ vaantʉ vaanteengye na nyuumbii jaavo.’ ");
INSERT INTO lag_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jeyyo, akavaanɨrɨra vaantʉ voosi vara ˆvadaayiwáa noongwa nɨ musúngaati waachwe. Wa ncholo akamuurya, ‘Noongwa yaako kwa musúngaati waanɨ nɨ viintʉ vingaɨ?’ ");
INSERT INTO lag_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ne akasea, ‘Noongwa yaanɨ ndáayiwaa nɨ líita mayana yatatʉ na magana mufungatɨ (3,700) ya makuta ya saitúuni.’ Aho, mwiimiriri akamʉsea, ‘Toola karatáasi ɨhɨ ˆngʼeene yaandɨkwa noongwa yaako chaangʉ, andɨka noongwa yaako nɨ líita iyana rɨmwɨ, magana yanaanɨ na makumi yasaano (1,850).’ ");
INSERT INTO lag_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aho, akamuurya wa kavɨrɨ akamʉsea, ‘Weewe viintʉ vingaɨ ʉdáayiwaa?’ Ʉra akamʉsea, ‘Magunía magana yatatʉ na makumi yatatʉ (330) ya ngáano.’ Mwiimiriri akamʉsea, ‘Toola karatáasi ɨhɨ ˆngʼeene yaandɨkwa noongwa yaako, andɨka magana yavɨrɨ na makumi mʉsasatʉ (260).’ ");
INSERT INTO lag_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ʉra musúngaati akamʉdʉʉmbɨrɨra ʉra mwiimiriri sɨ ˆarɨ wo kiilaangiwa, sa viintʉ ˆajáa abwéeyyiirye ʉweere. Sa kʉrɨ vaantʉ va mbyaala ɨhɨ, vara sɨ ˆvamurúmaa Mʉlʉʉngʉ nɨ vaweere mʉnʉmʉʉnʉ kwa masáare ya ɨhɨ weerʉ, kʉlookya vaantʉ vara ˆvamuruma Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nɨ kʉvawyɨɨra niise, vaambiriryi viivaanyu na máari jaanyu ja aha weerwii, sa ˆjiri sira mʉteengiwe na kiikalwii cha sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mʉʉntʉ ˆiiláangiwaa kwa masáare maduudi, kiilaangiwa eende kwa masáare makʉʉlʉ. Noo jeyyo, mʉʉntʉ ʉra ˆasova ʉwoloki kwa viintʉ viduudi, kʉva arɨ mʉʉntʉ ˆasova ʉwoloki kwa viintʉ ˆviri foo. ");
INSERT INTO lag_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na koonɨ sɨ mʉrɨ vo kiilaangiwa kwa máari ja ɨhɨ weerʉ, nɨ ani ˆarɨ viilaangya kwa máari ya kɨkomi? ");
INSERT INTO lag_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kei koonɨ sɨ mʉrɨ kiilaangiwa kwa máari ya mʉʉntʉ wɨɨngɨ, nɨ ani ˆarɨ kʉvaheera máari yaanyu veeneevyo? ");
INSERT INTO lag_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kusiina mʉtʉmami ˆadáhaa tʉmamɨra vasúngaati vavɨrɨ tʉkʉ. Sa mʉsʉʉla arɨ ʉmwɨ na amweende wɨɨngɨ, au mʉnyemya eende ʉmwɨ na kumuchwa eende matɨ wɨɨngɨ. Sɨ mʉrɨ daha kʉmʉtʉmamɨra Mʉlʉʉngʉ na máari tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafarisáayo ˆvakateere masáare yoosi Yéesu alʉʉsáa, maa vakamʉseka ko muchwa matɨ, sa vajáa veenda mpía maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yéesu akavawyɨɨra yoovasea, “Nyuunyu mwiiyónekyaa kɨkomi mbere ja vaantʉ mʉrɨ vawoloki. Maa kaa, Mʉlʉʉngʉ amányire mɨtɨma yaanyu. Sa vira viintʉ vaantʉ ˆvavyoónaa nɨ vya kɨkomi, Mʉlʉʉngʉ avisʉʉla. ");
INSERT INTO lag_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Miiro na masáare ya valáali na mʉtwe, yavariyʉlwa fʉʉrʉ mpɨɨndɨ ja Yooháani Mʉbatisáaji. Fuma mpɨɨndɨ ijo, Masáare Maaja ya Ʉtemi wa Mʉlʉʉngʉ yaváriyʉlwaa na kɨra mʉʉntʉ iiyingiryáa ʉtemii ʉwo na ngururu. ");
INSERT INTO lag_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Maa kaa, nɨ vyoolo kwa kurumu na weerʉ kʉlooka, kʉlookya lʉtalo baa lʉmwɨ kʉrɨmɨra fuma Miirwii ya Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mʉʉntʉ mʉlʉme ˆamusíitaa muki waachwe, maa akaloola muki wɨɨngɨ, ʉwo ayéendaa na muki wa mʉʉntʉ. Kei, mʉʉntʉ mʉlʉme ʉra ˆamʉlóolaa mʉʉntʉ muki ˆarekwa nɨ mʉlʉme waachwe, ʉwo ayéendaa na muki wa mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Haaha, kʉjáa kwatɨɨte musúngaati ʉmwɨ, ˆiivɨkɨráa ɨngo ja kɨtáani ˆjiri gyaa ja kisúngaati, ˆjalʉkwa na mputi ja kɨkomi. Na sikʉ joosi yeeye arijáa chóorya cha kibuya. ");
INSERT INTO lag_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kei, kʉjáa kwatɨɨte mʉkɨva ʉmwɨ ˆasewáa Lasáaro. Areetwáa, maa akavɨɨkwa mʉryaangwii kwaachwe. Ʉhʉ ajáa atɨɨte viloonda mʉvɨrɨ vʉʉ. ");
INSERT INTO lag_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yeeye iikaláa mʉryaangwii na ajáa atɨɨte mpɨɨma yo rya mangʼenyengʼenye ˆyawíire ɨsɨ ya méesa kwa ʉhʉ musúngaati. Kei, kúri jʉʉjáa noo mʉnaampa viloonda vyaachwe. ");
INSERT INTO lag_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sikʉ ˆjikalooke, ʉra mʉkɨva akakwya. Mirimʉ miija ɨkʉʉja noo mʉsʉmʉla, ɨkamʉtwaala fʉʉrʉ kɨpeembii cha Aburaháamu. Ʉra musúngaati ne akɨjoowulala na akataahwa. ");
INSERT INTO lag_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yeeye akatamanya na ntarii. Ʉko uturikirii, akiinurirya miiso yaachwe na mweeri, maa akamoona Aburaháamu kwa kʉlɨ arɨ na Lasáaro. ");
INSERT INTO lag_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Aho, ʉra musúngaati akamwaanɨrɨra Aburaháamu, ‘Taáta Aburaháamu, naanga na riiso ra wʉʉja. Nooloomba ʉmʉtʉme Lasáaro atukye imaamba raachwe luujii, maa atoonyerye lurimii lwaanɨ sa lʉhole. Kɨkomi nɨ tʉrɨkɨra niise mʉnʉmʉʉnʉ mootwii ʉhʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aho, Aburaháamu akamʉsea, ‘Mwanawaanɨ, kʉmbʉkɨra, weewe mpɨɨndɨ ˆʉjáa mooyo, ʉjáa ʉtɨɨte viintʉ vyoosi ˆvyabooha ˆʉsaakáa. Maa kaa, Lasáaro nɨ uturikiri vii apatáa. Haaha yeeye atúuriiwe mʉtɨma aha na weewe ʉmwaarɨ wootʉrɨkɨra mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Sɨ jeyyo vii tʉkʉ, katɨkatɨ yiiswi na nyuunyu kwatɨɨte iduundu ikʉʉlʉ mʉnʉmʉʉnʉ. Iduundu ɨro, ravɨɨkwa sa vaantʉ va kʉnʉ ˆvarɨ saaka kʉʉja nooko kwaanyu, vasiindwe fɨrɨra na vaantʉ va ʉko vasiindwe kʉʉja na kʉnʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Aho, ʉra musúngaati akasea, ‘Haaha nookʉloomba ee taáta ʉmʉtʉme Lasáaro atamanye na kaayii kwa taáta wiitʉ. ");
INSERT INTO lag_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ʉko natɨɨte vaaniitʉ vasaano. Lasáaro akavalʉme kutu sa karɨ luu vʉʉje na kʉnʉ kʉʉntʉ kwa uturikiri tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Maa kaa, Aburaháamu akamʉsea, ‘Vaanaanyu vatɨɨte ʉtali wa Mʉ́sa na valáali na mʉtwe va Ijʉva, vayateere ayo!’ ");
INSERT INTO lag_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ʉra musúngaati akamʉsea, ‘Taáta Aburaháamu tʉkʉ! Koonɨ mʉʉntʉ afúfukire na adome akavawyɨɨre, aho, valandʉka varɨ fuma uvii waavo.’ ");
INSERT INTO lag_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aburaháamu akamʉsea, ‘Koonɨ sɨ vatéerɨɨre yara ˆyaandɨkwa nɨ Mʉ́sa na valáali na mʉtwe, sɨ varɨ ruma baa ya mʉʉntʉ afúfukire tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yéesu akavasea vapooji vaachwe, “Masáare ˆyabwéeyyaa vaantʉ viikunguvale, mpaka yʉʉje vii. Maa kaa, mpolaɨ kwa ʉra yoyoosi ˆyooyareeta. ");
INSERT INTO lag_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nɨ pwee viri kwa mʉʉntʉ ʉwo kʉchʉʉngɨrwa lwaala nkiingwii, maa afweitɨrwe na mayiyii, kʉlookya uturikiri ˆarɨ turya ko mʉhaanda ʉmwɨ wa ava vadúúdi atʉmame ʉvɨ! ");
INSERT INTO lag_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sa jeyyo, imi neeja. Koonɨ mwaanaanyu abwéeyyiirye ʉvɨ, mʉdalavye. Koonɨ aválandukire fuma uvii waachwe, mʉsee yasírire. ");
INSERT INTO lag_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Koonɨ ahóniirye kwa sikʉ ɨmwɨ mara mufungatɨ na uújire na kwaako yoosea, ‘Haɨ, naválandukire fuma uvii waanɨ,’ weewe woosaakwa ʉmʉsee yasírire.” ");
INSERT INTO lag_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aho, vatumwi va Yéesu vakamʉsea Mweenevyoosi, “Toongererye kukuruma.” ");
INSERT INTO lag_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mweenevyoosi akavasea, “Ngaarɨ mʉrɨ na kuruma baa kuduudi ja mpeke nduudi ya haradáali, ngaarɨ mʉdáhire kʉʉsea ʉhʉ mʉkʉyʉ, ‘Ngʼooka, ʉkakondiwe mayiyii!’ Nowo ngaarɨ wavɨ́ɨre matu kwa kɨra ˆmuuwyɨ́ɨrɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Baa ja tʉsee, koonɨ ʉmwɨ waanyu arɨ na mʉtʉmami waachwe ˆafúmire rɨma iwundii au kuriisha muundi, nɨ ani ʉmwɨ waanyu ifaanaa amʉsee, ‘Yeenda chaangʉ, ikala, urye chóorya?’ ");
INSERT INTO lag_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sɨ jeyyo tʉkʉ. Kɨrɨ vyoolʉʉsa jei sea arɨ, ‘Nyimirya neeja chóorya, na wʉʉntʉmamɨre fʉʉrʉ mpʉmʉle kurya no nywa. ˆNdɨrɨ hʉmʉla de weewe urye no nywa.’ ");
INSERT INTO lag_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eri, mʉdʉʉmba ʉrɨ mʉtʉmami ko bweeyya kɨra ˆcheene ʉmʉwyɨ́ɨrɨɨre abweeyye wʉʉ? Aka tʉkʉ! ");
INSERT INTO lag_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Viivyo, baa nyuunyu ˆmʉrɨ hʉmʉla tʉmama yoosi ˆmwalaiririwa, sei, ‘Suusu tʉrɨ vatʉmami vii, tatʉ́mamire yara ˆmeene tasaakwa tʉtʉmame vii.’” ");
INSERT INTO lag_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mpɨɨndɨ Yéesu ˆadomáa na Yerusaléemu, ajáa atweera na mʉhakii wa ɨsɨ ya Samaría na Galiláaya. ");
INSERT INTO lag_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mpɨɨndɨ Yéesu ˆɨɨngɨráa iturii rɨmwɨ, ajáa alʉmana na vaantʉ ikimi ˆvarɨ na ʉlóónda. Avo vaantʉ vakɨɨma kʉlɨ, maa ");
INSERT INTO lag_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","vakaanɨrɨra voosea, “Yéesu, Mweenevyoosi, tʉlaange na riiso ra wʉʉja!” ");
INSERT INTO lag_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yéesu ˆakavoone akavasea, “Tamanyi, mukiiyonekye kwa veeneɨsɨ va Ijʉva.” Na mpɨɨndɨ ˆvajáa njirii vootamanya, maa vakajirʉlwa ʉlóónda waavo. ");
INSERT INTO lag_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ʉmwɨ waavo ˆakoone ahórire, maa akahɨndʉka na kwa Yéesu kʉnʉ yoomʉdʉʉmba Mʉlʉʉngʉ na sawúti nkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akalaala majewii ya Yéesu na ɨnda kʉnʉ yoomʉdʉʉmba. Ʉwo mʉʉntʉ nɨ Mʉsamaría ajáa. ");
INSERT INTO lag_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yéesu akamuurya, “Voosi ikimi sɨ vajírwiilwe tʉkʉ wʉʉ? Hai varɨ vara vɨɨngɨ keenda? ");
INSERT INTO lag_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kusiina baa ʉmwɨ ˆahíndukire joo mʉdʉʉmba Mʉlʉʉngʉ tʉkʉ, maa kaa, ʉhʉ mʉyeni vii?” ");
INSERT INTO lag_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yéesu akamʉsea, “Inʉka, ʉtamanye, kuruma kwaako kwakʉhóniirye.” ");
INSERT INTO lag_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sikʉ ɨmwɨ, Mafarisáayo vajáa vamuurya Yéesu voosea, “Ʉtemi wa Mʉlʉʉngʉ naadi ʉrɨ kʉʉja?” Yéesu akavasea, “Ʉtemi wa Mʉlʉʉngʉ, sɨ wʉʉjáa ko kʉʉlaangishalaangisha tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kusiina mʉʉntʉ ˆarɨ daha sea, ‘La nʉ aha!’ au ‘La haʉra kʉra,’ tʉkʉ. Sa Ʉtemi wa Mʉlʉʉngʉ nɨ nowo mʉrɨ.” ");
INSERT INTO lag_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aho, akavasea vapooji vaachwe, “Mpɨɨndɨ kʉʉja jiise, kʉva mʉrɨ na mpɨɨma jo va na Mwaana wa Mʉʉntʉ baa kwa sikʉ ɨmwɨ vii, maa kaa, sɨ mʉrɨ kʉʉnyona tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Vaantʉ kʉndoovasea veende, ‘La haʉra hara,’ au ‘Haʉhʉ aha!’ Karɨ mʉdómaa na karɨ mʉvarúmaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sa Mwaana wa Mʉʉntʉ sikʉ ˆarɨ kʉʉja, kʉʉja arɨ ja lʉlávo ˆvyeene lʉʉ́jaa loomʉrɨka mavaru yoosi ya kurumu. ");
INSERT INTO lag_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Maa kaa, saakwa arɨ aturikiriwe kwa masáare ˆyarɨ foo na siitwa arɨ nɨ mbyaala ɨhɨ. ");
INSERT INTO lag_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ja viintʉ ˆvijáa sikʉ ja Nʉ́hʉ, noo ˆvyeene ɨrɨ kʉva sikʉ yo hɨndʉka Mwaana wa Mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mpɨɨndɨ ja Nʉ́hʉ, vaantʉ varijáa no nywa, valoolwáa no loola fʉʉrʉ sikʉ ɨra Nʉ́hʉ ˆakɨɨngɨre na safíinii. Aho, ɨra mbula ya imalo ɨkʉʉja, maa ɨkavamala voosi vʉʉ. ");
INSERT INTO lag_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Baa mpɨɨndɨ ja Lúutu nɨ ja jeyyo vijáa. Vaantʉ varijáa no nywa, vaváa iyoombe no wʉla, varɨmáa no jeenga. ");
INSERT INTO lag_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Maa kaa, sikʉ ɨra Lúutu ˆakiinʉke Sodóoma, mooto na sálʉfa ʉjáa wakiima fuma kurumwii, ʉkavamala voosi vʉʉ. ");
INSERT INTO lag_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Noo jeyyo ˆviri kʉva sikʉ ɨra Mwaana wa Mʉʉntʉ ˆarɨ variyʉlwa. ");
INSERT INTO lag_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sikʉ ɨyo, mʉʉntʉ ˆarɨ ikekeerii karɨ akiime sa atoole viintʉ vyaachwe nyuumbii tʉkʉ. Na ʉra ˆarɨ iwundii karɨ ahɨ́ndʉkaa na kaayii noo toola chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukiri kɨra alʉmana nocho muki wa Lúutu! ");
INSERT INTO lag_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mʉʉntʉ yoyoosi ʉra ˆyooyera kʉlamurirya nkaasʉ yaachwe, ʉwo kɨɨtaaha arɨ. Maa kaa, mʉʉntʉ yoyoosi ʉra ˆyookɨɨtaaha nkaasʉ yaachwe, ʉwo kɨɨlamurirya arɨ. ");
INSERT INTO lag_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nɨ kʉvawyɨɨra niise, sikʉ ɨyo, vaantʉ vavɨrɨ ˆvalɨ́ɨre kɨtáanda kɨmwɨ, ʉmwɨ sʉmʉlwa arɨ, na wɨɨngɨ rekwa arɨ. ");
INSERT INTO lag_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Vaantʉ vaki vavɨrɨ ˆvoosha hamwɨ, ʉmwɨ sʉmʉlwa arɨ na wɨɨngɨ rekwa arɨ.  ");
INSERT INTO lag_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Vaantʉ valʉme vavɨrɨ kʉva varɨ vootʉmama iwundii, ʉmwɨ sʉmʉlwa arɨ na wɨɨngɨ rekwa arɨ.” ");
INSERT INTO lag_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aho, vapooji vaachwe vakamuurya, “Mweenevyoosi, aya nɨ hai ˆyarɨ fʉmɨra?” Ne akavasea, “Hara kʉʉntʉ ˆkʉrɨ na maka ˆikwíire, aho noo kʉʉntʉ nkuumba jilʉ́manɨraa.” ");
INSERT INTO lag_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yéesu akavavaɨra vapooji vaachwe lusímo ʉlʉ yoovakiindya vatuube kʉndooloomba bila yookatala. ");
INSERT INTO lag_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akavasea, “Múujii ʉmwɨ, kʉjáa kwatɨɨte mʉlamuli ʉmwɨ. Ʉhʉ mʉlamuli, sɨ amoofáa Mʉlʉʉngʉ tʉkʉ, baa kei, sɨ avanyemyáa vaantʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na múujii ʉwo, kʉjáa kwatɨɨte mʉlala ʉmwɨ ˆatamanyáa na kwaachwe yoomʉloomba, ‘Kalaama nooloomba ʉlamʉle kɨloongi chaanɨ na mʉvɨ waanɨ sa mpate kɨra Miiro ˆyaruma.’ ");
INSERT INTO lag_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa sikʉ ˆjiri foo ʉra mʉlamuli ajáa asiita kʉmwaambirirya. Maa kaa, sikʉ ɨmwɨ akiisea yeemweene, ‘Baa neembe sɨ nɨmoófaa Mʉlʉʉngʉ na baa neembe sɨ nɨvanyémyaa vaantʉ, ");
INSERT INTO lag_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sa viintʉ ʉhʉ mʉlala yookuunjuuwa mʉnʉmʉʉnʉ, lamʉla ndɨrɨ kɨloongi chaachwe, apate kɨra ˆkɨmʉtéire sa areke kʉʉnkatarya.’” ");
INSERT INTO lag_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aho, Mweenevyoosi akavasea, “Ikiindyi fuma kwa ʉhʉ mʉlamuli sɨ ˆarɨ mʉwoloki. ");
INSERT INTO lag_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eri, Mʉlʉʉngʉ sɨ arɨ vaheera vira ˆvivatéire vaantʉ ˆavasaawʉla vara ˆvoomʉloomba uchikʉ na muusi tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nɨ kʉvawyɨɨra niise, Mʉlʉʉngʉ kʉvaheera arɨ chaangʉ kɨra ˆkɨvatéire. Maa kaa, Mwaana wa Mʉʉntʉ ˆarɨ hɨndʉka na aha weerwii, shaana arɨ vaantʉ ˆvamuruma wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yéesu akavawyɨɨra kwa lusímo vaantʉ ˆveene viiyonáa voovo nɨ vawoloki na vavachwijáa matɨ vaantʉ vɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Akavasea, “Sikʉ ɨmwɨ, vaantʉ vavɨrɨ vajáa vatamanya na Kaayii Njija ya Ijʉva noo mʉloomba Mʉlʉʉngʉ. Ʉmwɨ nɨ Mʉfarisáayo ajáa na wɨɨngɨ, mʉsaankanʼyi kóodi. ");
INSERT INTO lag_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ʉra Mʉfarisáayo akɨɨma yeemweene, maa akaanda mʉloomba Mʉlʉʉngʉ yoosea, ‘Ee Mʉlʉʉngʉ, nakʉdʉ́ʉmbaa sa nɨɨnɨ sɨ ndɨrɨ ja vaantʉ vɨɨngɨ tʉkʉ, vakumuriryi, sɨ ˆvarɨ vawoloki tʉkʉ, ˆvayéendaa na vaki va vaantʉ, baa kei sɨ ndɨrɨ ja ʉhʉ mʉsaankanʼyi kóodi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nɨɨnɨ kwa júma ɨmwɨ niirékyaa kurya kavɨrɨ. Kei, natóolaa ilʉʉndʉ rɨmwɨ ra kɨra malʉʉndʉ ikimi ra viintʉ vyaanɨ.’ ");
INSERT INTO lag_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Maa kaa, ʉra mʉsaankanʼyi kóodi akɨɨma kʉlɨ, sɨ asaaka baa kwiinʉla miiso yaachwe na kurumwii tʉkʉ. Yeeye, akiivaavaa kɨpeembe kʉnʉ yookaavwa nɨ mʉtɨma yoosea, ‘Ee Mʉlʉʉngʉ nookʉloomba wʉʉnyonere mbavariri, nɨɨnɨ ndɨrɨ mʉvɨ!’ ");
INSERT INTO lag_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nɨ kʉvawyɨɨra niise, ʉhʉ mʉsaankanʼyi kóodi, ahɨndʉka na kaayii kwaachwe kʉnʉ avárirwe nɨ mʉwoloki, maa kaa, kwa ʉra Mʉfarisáayo sɨ jeyyo tʉkʉ. Sa kɨra mʉʉntʉ ˆiiyámbukyaa na mweeri, kiimiwa arɨ, na ʉra ˆiikíimyaa na ɨsɨ, kaambukiwa arɨ.” ");
INSERT INTO lag_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Haaha vaantʉ vamʉreteráa Yéesu vasinga vaduudi sa avavɨkɨre mɨkono. Vapooji vaachwe ˆvakoone jeyyo, maa vakavaamirirya. ");
INSERT INTO lag_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Maa kaa, Yéesu akavaanɨrɨra vara vasinga, akavasea, “Vareki vasinga vaduudi vʉʉje na kʉrɨ nɨɨnɨ, karɨ mʉvakɨtɨre tʉkʉ! Sa Ʉtemi wa Mʉlʉʉngʉ nɨ sa vaantʉ ˆvarɨ ja vasinga ava. ");
INSERT INTO lag_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kɨmaarɨ noovawyɨɨra, yoyoosi ʉra sɨ ˆarɨ kʉʉhokera Ʉtemi wa Mʉlʉʉngʉ ja musinga muduudi, sɨ arɨ kʉʉyɨngɨra vii kaa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aho, mʉlongooli ʉmwɨ akamuurya Yéesu, “Mukiindya mʉʉja, che ndɨrɨ bweeyya mpokere nkaasʉ ya sikʉ ˆjisiina ʉhero?” ");
INSERT INTO lag_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yéesu akamʉsea, “Sa che wookʉʉnyanɨrɨra mʉʉja? Kusiina mʉʉja tʉkʉ, mʉʉja nɨ Mʉlʉʉngʉ yeemweene vii. ");
INSERT INTO lag_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ʉmányire ndairiri ja Mʉlʉʉngʉ wʉʉ? ‘Karɨ ʉyéendaa na muki wa mʉʉntʉ tʉkʉ, karɨ wʉʉ́laa tʉkʉ, karɨ wiívaa tʉkʉ, karɨ ʉlóngowereryaa mʉʉntʉ tʉkʉ, na ʉvanyemye vala íyo na taáta waanyu.’” ");
INSERT INTO lag_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ne akasea, “Ayo yoosi nayakwaatya keende usinga waanɨ.” ");
INSERT INTO lag_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yéesu ˆakateere jei, akamʉsea, “Kɨmwaarɨ kɨɨntʉ kimudu vii sɨ ˆʉnabweeyya. Tamanya, ʉkavae iyoombe máari joosi ˆʉrɨ nojo, na mpía ˆʉrɨ turya, ʉvaheere vakɨva. Jeyyo, turya ʉrɨ máari ya kɨkomi ya mberii kurumwii. Aho, yeenda, wuuntuube.” ");
INSERT INTO lag_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ʉra mʉʉntʉ ˆakateere ayo, akiirya mʉtɨma maatʉkʉ vii, sa yeeye nɨ musúngaati maatʉkʉ vii ajáa. ");
INSERT INTO lag_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yéesu akamoona ʉra mʉʉntʉ iíriirye mʉtɨma, maa akasea, “Kʉva viri vyafafa maatʉkʉ vii kwa musúngaati kwɨɨngɨra Ʉtemii wa Mʉlʉʉngʉ! ");
INSERT INTO lag_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kɨkomi, nɨ vyaangʉ ngamɨ́a kʉtweera na ihengerii ra sinkeni, kʉlookya musúngaati kwɨɨngɨra na Ʉtemii wa Mʉlʉʉngʉ!” ");
INSERT INTO lag_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Vaantʉ vara ˆvateera masáare aya vakasea, “Nɨ ani de arɨ daha lamuririwa?” ");
INSERT INTO lag_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yéesu akavasea, “Yara sɨ ˆyadáhɨkaa kwa vaantʉ, kwa Mʉlʉʉngʉ yadáhɨkaa.” ");
INSERT INTO lag_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peéteri akamʉsea, “Laanga! Suusu tareka vyoosi ˆtʉjáa novyo tʉkakutuuba weewe!” ");
INSERT INTO lag_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yéesu akamʉsea, “Kɨmaarɨ noovawyɨɨra, mʉʉntʉ yoyoosi ʉra ˆareka nyuumba yaachwe, au mʉdala waachwe, au vandʉʉ vaachwe, au vala íyo na taáta, au vaana vaachwe sa Ʉtemi wa Mʉlʉʉngʉ, ");
INSERT INTO lag_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ʉwo hokera arɨ ˆviri foo mpɨɨndɨ iji kʉlookya vira ˆareka. Na weerʉ ˆyookʉʉja, hokera arɨ nkaasʉ ya sikʉ ˆjisiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Aho, Yéesu akavasʉmʉla vapooji vaachwe ikimi na vavɨrɨ na ivarwii, maa akavasea, “Haaha nɨ kwaambʉka tiise na Yerusaléemu. Masáare yoosi ˆmeene yaandɨkwa nɨ valáali na mʉtwe sa Mwaana wa Mʉʉntʉ, kiimana yarɨ. ");
INSERT INTO lag_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yeeye vɨɨkwa arɨ mɨkonwii ya vaantʉ sɨ ˆvarɨ Vayahúudi. Aho, muchwa varɨ matɨ, mʉtʉkɨra varɨ na kʉmʉchwɨɨra varɨ matɨ. ");
INSERT INTO lag_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kei kʉmʉvaa varɨ na mɨjeléedi na kʉmʉʉlaa varɨ na sikʉ ya katatʉ fʉfʉka arɨ.” ");
INSERT INTO lag_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Maa kaa, vapooji vaachwe sɨ vataanga ʉvariyuli wa masáare aya tʉkʉ, sa ʉvariyuli waachwe ʉjáa wiivisa kʉrɨ voovo. Sɨ vataanga nɨ che alʉʉsáa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yéesu ˆakasengerere múuji wa Yerɨ́ɨko, kʉjáa kwatɨɨte mʉhoku ʉmwɨ ˆaloombáa iíkyɨɨre heehi na njɨra. ");
INSERT INTO lag_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ʉwo mʉhoku ˆakateere mpuka ya vaantʉ voolooka, akuurya, “Nɨ che kwatɨɨte?” ");
INSERT INTO lag_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Vakamʉsea, “Yéesu wa Nasaréeti yoolooka.” ");
INSERT INTO lag_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aho, akatʉla isóso yoosea, “Ee Yéesu, Sha Daúdi, naanga na riiso ra wʉʉja!” ");
INSERT INTO lag_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Vaantʉ vara ˆvajáa valóngwɨɨre mbere ya Yéesu vakaanda kʉmʉdalavya akirinye. Maa kaa, yeeye akadoomererya kʉmwaanɨrɨra, “Ee Sha Daúdi, naanga na riiso ra wʉʉja Aaɨ!” ");
INSERT INTO lag_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yéesu akɨɨma, maa akavalairirya vamʉreete na kwaachwe. Ʉra mʉhoku ˆakaseese, maa Yéesu akamuurya, ");
INSERT INTO lag_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Che woosaaka nɨkʉbweeyyiirye?” Ne akasea, “Ee Mweenevyoosi, noosaaka noone!” ");
INSERT INTO lag_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aho, Yéesu akamʉsea, “Haaha ona kaa! Kuruma kwaako kwakʉhóniirye.” ");
INSERT INTO lag_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hahara akaanda koona kei. Akamutuuba Yéesu kʉnʉ yoomʉdʉʉmba Mʉlʉʉngʉ. Na vaantʉ voosi ˆvakoone ayo, vakamʉdʉʉmba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yéesu ˆakɨɨngɨre na múuji wa Yerɨ́ɨko, akakwaatɨra na katɨkatɨ ya ʉwo múuji. ");
INSERT INTO lag_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ʉko, kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ mʉkʉʉlʉ wa vasaankanʼyi kóodi. Ʉhʉ mʉʉntʉ nɨ musúngaati ajáa na irina raachwe noo Sakáayo asewáa. ");
INSERT INTO lag_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakáayo akava yoosaaka kʉmoona Yéesu. Maa kaa, sa viintʉ ajáa mukufi, akasiindwa kʉmoona Yéesu sa kʉjáa kwatɨɨte mpuka nkʉʉlʉ ya vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sa jeyyo, akakʉʉrɨka itɨ́ɨjo, akalongorera na mbere. Akaambʉka mʉsaambwii sa amoone Yéesu kati ˆyoolooka. ");
INSERT INTO lag_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yéesu ˆakafike hara mʉsaambwii, akalaanga mweeri, maa akamʉsea Sakáayo, “Sakáayo, kiima chaangʉ! Isikʉ nɨ kwaako ndɨrɨ kʉʉmba!” ");
INSERT INTO lag_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aho, Sakáayo akakiima chaangʉ na ɨsɨ, maa akamʉteengya Yéesu na kaayii kwaachwe na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vaantʉ voosi ˆvakoone, vakaanda ngʼuula voosea, “Sa che yookɨɨngɨra noo va mʉyeni kwa iduwalo?” ");
INSERT INTO lag_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Maa kaa, Sakáayo akɨɨma, ma akamʉsea Mweenevyoosi, “Aaɨ laanga, haaha jei kera niise máari yaanɨ havɨrɨ. Ivaru rɨmwɨ vaheera ndɨrɨ vakɨva na koonɨ nasʉmʉla kɨɨntʉ cha mʉʉntʉ kwa ʉloongo, ʉwo mʉhɨndʉrɨra ndɨrɨ mara kanɨ ya ɨkyo kɨɨntʉ ˆnasʉmʉla.” ");
INSERT INTO lag_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aho, Yéesu akamʉsea, “Ʉlamuriri wɨɨ́ngɨɨre kʉrɨ kaaya ɨhɨ, sa baa weewe umurúmire Mʉlʉʉngʉ ja taáta wiitʉ Aburaháamu. ");
INSERT INTO lag_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sa Mwaana wa Mʉʉntʉ ʉʉja joo saakɨra no lamurirya vara ˆvarɨmɨra.” ");
INSERT INTO lag_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Vaantʉ vara ˆvamʉteereráa Yéesu yoovavaɨra símo viiseáa Ʉtemi wa Mʉlʉʉngʉ fika wiise, sa viintʉ vajáa vaséngerɨɨre fika múuji wa Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aho, Yéesu akavasea, “Kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ wa lʉkolo lwa kɨtemi. Yeeye ajáa akera njɨra na ɨsɨ ya kʉlɨ. Ʉko ajáa atamanya noo heewa ʉtemi de ahɨndʉke na ɨsɨ yaachwe kʉʉntʉ ˆarɨ kʉva mʉtemi. ");
INSERT INTO lag_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","De alooke, ajáa avaanɨrɨra vatʉmami vaachwe ikimi, akavaheera kɨra mʉʉntʉ mpía ˆjiri foo akavasea, ‘Saakiri kʉnáálo na mpía iji fʉʉrʉ sikʉ ˆndɨrɨ hɨndʉka!’ ");
INSERT INTO lag_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Maa kaa, vaantʉ va ɨsɨ yaachwe vajáa vamʉsʉʉla, sa jeyyo vakatʉma vaantʉ nyuma yaachwe voosea, ‘Sɨ toosaaka mʉʉntʉ ʉhʉ ave mʉtemi wiitʉ tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Baa neembe vajáa valʉʉsa jeyyo, yeeye ajáa aheewa ʉtemi. ˆAkahɨndʉke, akavaanɨrɨra vara vatʉmami ˆajáa avaheera mpía sa ataange kʉnáálo ˆngʼeene vaturya. ");
INSERT INTO lag_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mʉtʉmami wa ncholo ˆakʉʉje, maa akasea, ‘Ee mʉtemi, mpía ˆngʼeene waampeera, nasaakɨrɨra kʉnáálo nkapata malʉʉndʉ ikimi yɨɨngɨ.’ ");
INSERT INTO lag_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ʉra mʉtemi akamʉsea, ‘Wabweeyya vyabooha mʉtʉmami mʉʉja! Sa viintʉ waava wo kiilaangiwa kwa viintʉ viduudi, kʉheera ndɨrɨ wɨɨmɨrɨre míiji ikimi.’ ");
INSERT INTO lag_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mʉtʉmami wa kavɨrɨ ne akʉʉja akasea, ‘Ee mʉtemi, mpía ˆngʼeene waampeera nasaakɨrɨra kʉnáálo nkapata malʉʉndʉ yɨɨngɨ yasaano.’ ");
INSERT INTO lag_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mʉtemi akamʉsea ʉhʉ mʉʉntʉ, ‘Baa weewe nakʉhɨ́ɨre wɨɨmɨrɨre míiji ɨsaano.’ ");
INSERT INTO lag_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Maa re, akʉʉja ʉra mʉtʉmami wɨɨngɨ akasea, ‘Ee mʉtemi, mpía jaako nɨ iji aha. Najichʉʉngɨrɨra kɨtabárii sa jidɨɨre rɨmɨra. ");
INSERT INTO lag_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nɨjáa nakoofa sa weewe ʉrɨ mʉʉntʉ mʉfafu. Ʉsʉ́mʉlaa viintʉ haantʉ sɨ ˆwavɨɨka, na wachwíjaa kʉʉntʉ sɨ ˆʉhaanda.’ ");
INSERT INTO lag_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mʉtemi akamʉsea, ‘Mʉtʉ́mwa mʉvɨ weewe! Kwa masáare ˆyafúmire mʉlomwii waako kʉkʉlamʉrɨra niise! Weewe ʉjáa ʉmányire nɨɨnɨ ndɨrɨ mʉʉntʉ mʉfafu, nasʉ́mʉlaa kʉʉntʉ sɨ ˆnavɨɨka kɨɨntʉ, baa kei nachwíjaa kʉʉntʉ sɨ ˆnahaanda. ");
INSERT INTO lag_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ha de haaha, sa che sɨ ujivɨɨka mpía jaanɨ kwa vaantʉ ˆvachúrushaa sa nɨɨnɨ ˆndɨrɨ hɨndʉka nsʉmʉle mpía jaanɨ na kʉnáálo yaachwe?’ ");
INSERT INTO lag_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aho, mʉtemi akavasea vara vaantʉ ˆvajáa viímire aho, ‘Mʉhóki ilʉʉndʉ raachwe mʉkamʉheere ʉra ˆarɨ na ikimi.’ ");
INSERT INTO lag_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Maa kaa, voovo vakamʉsea, ‘Mʉkʉ́lʉ, amwɨ ʉra atɨɨte malʉʉndʉ ikimi!’ ");
INSERT INTO lag_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ne akavasea, ‘Nɨ kʉvawyɨɨra niise, kɨra ˆarɨ na kɨɨntʉ, koongereriwa arɨ kʉlookya, maa kaa, ʉra ˆasiina kɨɨntʉ, vuulwa arɨ baa kɨra kidúúdi ˆarɨ nocho. ");
INSERT INTO lag_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na kwa vara vavɨ vaanɨ, vara sɨ ˆvasaakáa nɨve mʉtemi mweeri yaavo, vareeti na aha, mʉvʉʉlae mbere yaanɨ.’” ");
INSERT INTO lag_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yéesu ˆakahʉmʉle kʉlʉʉsa ayo, akavalongorera mbere yookaambʉka na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ˆVakasengerere maturii ya Besifáage na Besanía ˆyarɨ luulwii ˆlwaséwaa Lʉʉlʉ lwa Mɨseitúuni, akavatʉma vapooji vaachwe vavɨrɨ, ");
INSERT INTO lag_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akavasea, “Tamanyi na ituri ˆrɨrɨ mbere yaanyu, na kati ˆmookɨɨngɨra koona mʉrɨ mwaana wa ndákwi sɨ ˆanavereka mʉʉntʉ, achúungirwe aho. Muchunguriri, mʉmʉreete na aha. ");
INSERT INTO lag_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Koonɨ mʉʉntʉ avuúriirye, ‘Sa che moomʉchʉngʉrɨra mwaana wa ndákwi?’ mʉsei, ‘Mweenevyoosi yoomʉsaaka.’ ” ");
INSERT INTO lag_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Vara vapooji vakadoma, maa vakashaana kɨra kɨɨntʉ ja ˆvyeene Yéesu ajáa avawyɨ́ɨrɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kati ˆvamʉchʉngʉrɨráa ʉra mwaana wa ndákwi, veene ndákwi vakavuurya, “Amwɨ moomʉchʉngʉrɨra mwaana wa ndákwi?” ");
INSERT INTO lag_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Vara vapooji vakavasea, “Mweenevyoosi yoomʉsaaka.” ");
INSERT INTO lag_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Vakamʉtwaarɨra Yéesu. ˆVakahʉmʉle kwaala ɨngo jaavo mweeri ya ʉwo mwaana wa ndákwi, vapooji vaachwe vakamwaambukya ndákwii. ");
INSERT INTO lag_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mpɨɨndɨ Yéesu ˆatamanyáa, vaantʉ vakaala ɨngo jaavo njirii. ");
INSERT INTO lag_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yéesu ˆakafike mugiritwii wa Lʉʉlʉ lwa Mɨseitúuni, mpuka yoosi na vapooji vaachwe vakaanda vaa siriri kʉnʉ voomʉdʉʉmba Mʉlʉʉngʉ na sawúti nkʉʉlʉ, sa myuujíisa yoosi ˆvajáa voona Yéesu yoobweeyya. ");
INSERT INTO lag_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Vaseáa jei, “Atalariwa Mʉtemi ˆyookʉʉja kwa irina ra Ijʉva! Mwiikalo mʉʉja kurumwii na nkongojima kwa Mʉlʉʉngʉ ˆArɨ Mweerimweeri.” ");
INSERT INTO lag_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Vamwɨ va Mafarisáayo ˆvajáa vamwaarɨ mʉra mpukii, maa vakamʉsea Yéesu, “Mukiindya, valairirye vapooji vaako vakirinye.” ");
INSERT INTO lag_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yéesu akavasea, “Nɨ kʉvawyɨɨra niise, koonɨ ava vakíriinye, mawye tʉla yarɨ isóso.” ");
INSERT INTO lag_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yéesu akasengerera múuji wa Yerusaléemu. ˆAkʉʉyone múuji, maa akʉʉrɨrɨra, ");
INSERT INTO lag_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","yoosea, “Ngaarɨ wataanga sikʉ ɨhɨ yara ˆyarɨ kʉretera mwiikalo mʉʉja, haaha yaviswa miiswii yaako. ");
INSERT INTO lag_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kɨkomi, sikʉ kʉʉja jiise, vavɨ vaako kʉkereesa varɨ, na kʉrɨɨngɨrɨra varɨ nkaande joosi na kʉkɨtɨra varɨ isii. ");
INSERT INTO lag_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kʉkʉkanya varɨ weewe na vaantʉ vaako voosi. Kei sɨ varɨ reka iwye baa rɨmwɨ mweeri ya rɨɨngɨ tʉkʉ, sa sɨ ʉtaanga mpɨɨndɨ Mʉlʉʉngʉ ʉʉja na kwaako tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Aho, Yéesu akɨɨngɨra Kaayii Njija ya Ijʉva akaanda vakibirya vaantʉ ˆvaváa iyoombe viintʉ aho. ");
INSERT INTO lag_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akavasea, “Yaandɨkwa Masáarii ˆYarɨ Mpeho, ‘Nyuumba yaanɨ kʉva ɨrɨ nyuumba yo mʉloomba Mʉlʉʉngʉ.’ Maa kaa, nyuunyu mwɨɨválandwɨɨre ɨkava ‘mpaanga ya viívi.’” ");
INSERT INTO lag_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kɨra siikʉ akiindyáa Kaayii Njija. Maa kaa, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro na valongooli va vaantʉ vasaakɨráa njɨra yo mʉʉlaa Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Maa kaa, vakasova njɨra sa vaantʉ voosi vateereráa masáare yaachwe na vamʉteeráa matu kamwɨ. ");
INSERT INTO lag_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sikʉ ɨmwɨ, Yéesu avavariyʉrɨráa Masáare Maaja vaantʉ waámii wa Kaaya Njija ya Ijʉva. Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, vakiindya va Miiro na vawosi vakamʉʉjɨra. ");
INSERT INTO lag_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aho, vakamuurya voosea, “Tʉwyɨɨre nɨ kwa wiimiriri wa ani wootʉmama masáare aya? Nɨ ani akʉheera wiimiriri ʉhʉ?” ");
INSERT INTO lag_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ne akavasea, “Naanɨ kuvuurya ndɨrɨ, mʉʉngwyɨɨre, ");
INSERT INTO lag_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","eri, ʉbatíiso wa Yooháani nɨ kurumwii wafuma, bakʉ kwa vaantʉ?” ");
INSERT INTO lag_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aho, vakalʉʉsɨkanʼya voovo kwa voovo, “Koonɨ taséire ‘Wafuma kwa Mʉlʉʉngʉ,’ sea arɨ, ‘Haaha amwɨ sɨ mwamuruma?’ ");
INSERT INTO lag_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Maa kaa, koonɨ taséire, ‘Wafuma kwa vaantʉ,’ vaantʉ voosi kʉtʉvaa varɨ na mawye tukwye sa vaantʉ voosi vamuruma Yooháani nɨ mʉláali na mʉtwe wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aho, maa re vakamʉsea, “Sɨ tamányire kʉʉntʉ wiimiriri waachwe ˆwafuma tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yéesu ne akavasea, “Naanɨ sɨ ndɨrɨ vawyɨɨra nɨ kwa wiimiriri ʉrɨkwɨ nootʉmama aya tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Aho, maa Yéesu akaanda kʉvavaɨra vaantʉ lusímo ʉlʉ, “Mʉʉntʉ ʉmwɨ ajáa ahaanda mɨsabíibu iwundii kwaachwe. Ɨro iwʉnda akarɨkojya kwa varimi. Maa yeeye akakera njɨra na ɨsɨ ya kʉlɨ. Ʉko akɨɨta kiikala kwa sikʉ ˆjiri foo. ");
INSERT INTO lag_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mpɨɨndɨ jo chwa ˆjikafike, akamʉtʉma mʉtʉmami waachwe kwa vara vaantʉ sa vamʉheere haantʉ haachwe ha sabíibu ˆvachwíire. Maa kaa, vara varimi ˆajáa avakojya vakamʉvaa ʉra mʉtʉmami, maa vakamukibirya na mɨkono mɨtʉhʉ. ");
INSERT INTO lag_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Akamʉtʉma mʉtʉmami wɨɨngɨ, ʉhʉ ne vakamʉvaa, vakamʉbweeyyirya masáare ya soni, maa vakamukibirya na mɨkono mɨtʉhʉ. ");
INSERT INTO lag_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kei akamʉtʉma wa katatʉ, ʉhʉ ne vakamʉtamikya, maa vakamʉfweitɨra na weerwii ya iwʉnda. ");
INSERT INTO lag_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Maa re mweeneiwʉnda ra mɨsabíibu akiiyurya, ‘Che ndɨrɨ bweeyya? Haaha kʉmʉtʉma niise mwaana waanɨ. Ʉhʉ namweenda maatʉkʉ! Ʉhʉ ifaanaa vamʉnyemye.’ ");
INSERT INTO lag_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Maa kaa, vara ˆvakojiwa iwʉnda ˆvakamoone vii, maa vakiiwyɨɨra voovo kwa voovo voosea, ‘Ʉhʉ noo mʉpaari wa ɨrɨ iwʉnda. Tʉmʉʉlae haaha sa ʉpaari waachwe ʉve wiiswi.’ ");
INSERT INTO lag_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Vakamʉfweitɨra na weerwii ya iwʉnda ra mɨsabíibu, maa vakamʉʉlaa.” Aho, Yéesu akavuurya, “Haaha mweeneiwʉnda che arɨ vabweeyya vaantʉ vara? ");
INSERT INTO lag_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kʉʉja arɨ na kʉvʉʉlaa arɨ avo vaantʉ ˆavakojya iwʉnda na kʉvakojya arɨ vaantʉ vɨɨngɨ ɨrɨ iwʉnda ra mɨsabíibu.” Vaantʉ ˆvakateere ayo masáare, maa vakasea, “Aka tʉkʉ! Karɨ baa luu vifʉmɨre vii tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yéesu akavalaanga, maa akavasea, “Masáare aya ˆYarɨ Mpeho nɨ che yalʉʉsa? ‘Iwye ˆrasiitwa nɨ vajeengi, ravɨ́ɨre iwye ikʉʉlʉ ra kichurii.’ ");
INSERT INTO lag_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kɨra mʉʉntʉ ˆawíjaa mweeri ya iwye ɨrɨ, ngʼenyekangʼenyeka arɨ, na ʉra ˆrɨrɨ muwyɨɨra, chɨnɨka arɨ kamwɨ.” ");
INSERT INTO lag_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Vakiindya va Miiro, na vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, vakasaakɨra njɨra yo mʉkwaata chaangʉ sa vajáa vatáangire lusímo ʉlo nɨ voovo lʉjáa lwavalúusire. Maa kaa, vakavoofa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aho, vakʉ́ʉ́lʉ va Vayahúudi vakava voomʉrɨɨra iyeo. Vakatʉma vaantʉ viibweeyye vawoloki sa vandoomʉsola. Vabweeyyáa jei sa vapate kɨɨntʉ cho mʉkwaatɨra, vamʉvɨɨke ɨsɨ ya ngururu na wiimiriri wa gávana. ");
INSERT INTO lag_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Avo vuurikiriri vakamuurya, “Mukiindya, tamányire weewe ʉlʉ́ʉsaa na ʉváriyʉlaa ya kɨmáárɨ. Weewe sɨ woófaa ʉkʉ́ʉ́lʉ wa vaantʉ tʉkʉ, weewe wakíindyaa kɨmáárɨ ja ˆvyeene Mʉlʉʉngʉ asáakaa. ");
INSERT INTO lag_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Eri, ndairiri jaruma tʉndoorɨha kóodi kwa Kaisáari bakʉ tʉkʉ?” ");
INSERT INTO lag_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Maa kaa, Yéesu akataanga ʉkwaata waavo, maa akavasea, ");
INSERT INTO lag_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ndairi mpía ya dináari. Buuwo ɨhɨ na irina ɨrɨ nɨ vya ani?” Vakuuyirya voosea, “Nɨ vya Kaisáari.” ");
INSERT INTO lag_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aho, Yéesu akavasea, “Vya Kaisáari, mʉheeri Kaisáari. Na vya Mʉlʉʉngʉ, mʉheeri Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Vakasiindwa kʉmʉkwaata kwa yara ˆalʉʉsáa mbere ja vaantʉ. Vakahwaalala maatʉkʉ vii kwa vira ˆvyeene uuyiryáa, vakakirinya sawu. ");
INSERT INTO lag_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mpɨɨndɨ ˆjikalooke, Masadukáayo, noo kʉsea vaantʉ vara ˆvaséaa kusiina kʉfʉfʉka tʉkʉ, vajáa vamʉʉjɨra Yéesu, ");
INSERT INTO lag_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","maa vakamuurya, “Mukiindya, Mʉ́sa ajáa atwaandɨkɨra, ‘Koonɨ mʉʉntʉ akwíire baa kʉva na vaana tʉkʉ, mwaanaavo yoosaakwa amʉpaale ʉwo mʉlala sa amʉvyaarɨre vaana mwaanaavo ʉra ˆaakwya.’ ");
INSERT INTO lag_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Haaha, kʉjáa kwatɨɨte vaana valʉme mufungatɨ va mʉʉntʉ ʉmwɨ. Ndaambere yaachwe ajáa aloola, maa akawulala baa kʉva na mwaana tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wa kavɨrɨ akamʉpaala ʉwo mʉlala, ne akawulala baa reka mwaana tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wa katatʉ ne akamʉpaala ʉwo mʉlaala, ne akakwya baa reka mwaana tʉkʉ. Ɨkava viivyo kwa vaana voosi mufungatɨ ˆvamʉloola ʉra mʉʉntʉ muki, na kusiina ˆareka mwaana tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Maa reerʉ ʉra mwaana muki akawulala. ");
INSERT INTO lag_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Haaha, sikʉ ya ʉfʉfʉ́ʉko nɨ muki wa ani arɨ kʉva? Sa ajáa aloolwa nɨ voosi mufungatɨ.” ");
INSERT INTO lag_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yéesu akavasea, “Aha weerwii vaantʉ valóolaa no loolwa. ");
INSERT INTO lag_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Maa kaa, vara ˆvarɨ valwa nɨ Mʉlʉʉngʉ, vafʉfʉlwe fuma inkwyii na vaturye nkalo weerwii ifya, avo sɨ varɨ loola no loolwa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ava sɨ varɨ kukwya kei tʉkʉ, sa avo kʉva varɨ ja mirimʉ miija. Voovo nɨ vaana va Mʉlʉʉngʉ sa voovo nɨ vaana ˆvafʉfʉlwa. ");
INSERT INTO lag_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Maa kaa, kwa isáare ra vara ˆvaakwya kʉfʉfʉka, baa Mʉ́sa alʉʉsa vaantʉ ˆvaakwya fʉfʉka varɨ. Alʉʉsa aya masáarii ya rɨra itʉʉndʉ ˆrakoreráa mooto. Alʉʉsa ˆakamwaanɨrɨre Ijʉva nɨ Mʉlʉʉngʉ wa Aburaháamu, Mʉlʉʉngʉ wa Isaka na wa Yaakúupu. ");
INSERT INTO lag_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yeeye sɨ Mʉlʉʉngʉ wa vaantʉ ˆvaakwya tʉkʉ. Yeeye nɨ Mʉlʉʉngʉ wa vaantʉ ˆvarɨ nkaasʉ, na kwaachwe voosi nɨ nkaasʉ varɨ.” ");
INSERT INTO lag_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Vamwɨ va vakiindya va Miiro vakamʉsea, “Mukiindya, ulúusire kɨkomi kamwɨ!” ");
INSERT INTO lag_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kwaandɨra aho, kusiina ˆayera kumuurya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aho, maa Yéesu akavuurya, “Eri, nɨ joolɨ vyaava vaantʉ vandoomwaanɨrɨra Masía Mwaana wa mʉtemi Daúdi? ");
INSERT INTO lag_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daúdi mweeneevyo alʉʉsa jei kɨtáabwii cha Sabúuri, ‘Ijʉva amuwyɨɨra Mweenevyoosi waanɨ, “Ikala mʉkono waanɨ wa kʉlʉme, ");
INSERT INTO lag_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","fʉʉrʉ nɨvavɨɨke vavɨ vaako, vave kabambari ko vɨkɨra majeo yaako.”’ ");
INSERT INTO lag_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Koonɨ Daúdi yoomwaanɨrɨra ‘Mweenevyoosi’ waachwe, haaha joolɨ Masía arɨ kʉva Mwaana wa Daúdi?” ");
INSERT INTO lag_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na mpɨɨndɨ vaantʉ voosi ˆvamʉteereráa, Yéesu akavasea vapooji vaachwe, ");
INSERT INTO lag_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mʉvalaange neeja vakiindya va Miiro. Voovo veenda kwiivɨkɨra nkáancho ndɨɨhɨ na veenda luumbiwa kwa nyemi masóokwii. Kei, veenda kwiikala machuumbii ya mbere masinagóogii, na na haantʉ ha nyemi ngovii. ");
INSERT INTO lag_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Vanyáhɨraa nyuumba ja valala. Na ʉkweembi vamʉlóombaa Mʉlʉʉngʉ vilɨɨhɨlɨɨhɨ. Vaantʉ ja ava, heewa varɨ irya ikʉʉlʉ fuma kwa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mpɨɨndɨ Yéesu ˆajáa Kaayii Njija ya Ijʉva, ajáa avoona vasúngaati voovɨkɨra mpóryo jaavo isandúkwii ro vɨkɨra mpóryo. ");
INSERT INTO lag_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aho, akamoona mʉlala ʉmwɨ mʉkɨva yoovɨkɨra fipóocho fivɨrɨ fya mpía. ");
INSERT INTO lag_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aho, Yéesu akavasea, “Kɨkomi noovawyɨɨra, ʉhʉ mʉlala mʉkɨva atwɨ́ɨre mʉnʉmʉʉnʉ kʉlookya voosi. ");
INSERT INTO lag_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sa ava vɨɨngɨ voosi, vatwɨ́ɨre mpóryo kwa Mʉlʉʉngʉ sa ʉkʉ́ʉ́lʉ wa usúngaati waavo. Maa kaa, ʉhʉ mʉlala na ʉkɨva waachwe, atwɨ́ɨre vyoosi ˆarɨ novyo vyoomʉbweeyya ave nkaasʉ.” ");
INSERT INTO lag_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Vamwɨ va vapooji va Yéesu vakava voomʉlaɨra ˆvyeene Kaaya Njija yajeengwa na mawye ˆyabooha, baa na viintʉ vyɨɨngɨ vya iyoombe ikʉʉlʉ ˆvyeene vaantʉ vatoola ja mpóryo kwa Mʉlʉʉngʉ. Maa kaa, Yéesu akavasea, ");
INSERT INTO lag_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Viintʉ vyoosi ivi ˆmoovyoona, sikʉ kʉʉja jiri, kusiina iwye ˆrɨrɨ chaala mweeri ya iwye rɨɨngɨ tʉkʉ. Yoosi vawa yarɨ na ɨsɨ!” ");
INSERT INTO lag_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Vapooji vaachwe vakamuurya, “Mukiindya, masáare ayo nɨ naadi ˆyarɨ fʉmɨra? Na isháara che jiri laɨra yaséngerɨɨre fʉmɨra?” ");
INSERT INTO lag_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yéesu akavasea, “Laangi neeja, karɨ mʉkóoverwaa tʉkʉ. Vaantʉ ˆvarɨ foo kʉʉja varɨ kwa irina raanɨ voosea, ‘Nɨɨnɨ noo yeeye!’ Na vɨɨngɨ sea veende, ‘Mpɨɨndɨ jo herererya nɨ aha miiswii jiri!’ Karɨ mʉvatúubaa tʉkʉ! ");
INSERT INTO lag_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mpɨɨndɨ ˆmʉrɨ teera mbuwo ja nkoondo na masáare ya ntiribʉka, karɨ moófaa tʉkʉ. Ayo yoosi nɨ mpaka yafʉmɨre ta, maa kaa, ʉra ʉherereryo wa yoosi ʉkaarɨ.” ");
INSERT INTO lag_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kei akavasea, “Ɨsɨ kiinʉla ɨrɨ nkoondo na ɨsɨ yɨɨngɨ, na ʉtemi ʉmwɨ kiinʉla ʉrɨ nkoondo na ʉtemi wɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kʉva kʉrɨ na vitiíntima vikʉʉlʉ, njala ya imalo na ndwáala jo kiihokererya haantʉ haantʉ. Kei kʉva kʉrɨ na viintʉ ˆvyookoofya na isháara ˆjiri foo fuma kurumwii. ");
INSERT INTO lag_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Maa kaa, ayo de yafʉmɨre, vaantʉ kʉvakwaata veende na kʉvaturikirya veende. Vatwaala veende mʉkalamʉrɨrwe masinagóogii na kʉvachuunga veende mʉnyololwii. Kei, twaalwa mweende na kwa vatemi na kwa gávana sa mʉlamʉrɨrwe. Ivi vyoosi nɨ sa irina raanɨ. ");
INSERT INTO lag_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɨhɨ kʉvaheera ɨrɨ nkalo nyuunyu yo vabweeyya vataange kɨmaarɨ. ");
INSERT INTO lag_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Maa kaa, mʉlamʉle kʉreka kwiitweetya mitimii yaanyu nɨ che mʉrɨ lʉʉsa mbere ya balása tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sa nɨɨnɨ kʉvaheera neende masáare ya tooti ˆmeene mwɨɨndoolʉʉsa. Na masáare ayo, kusiina mʉvɨ waanyu ˆarɨ daha kuyuuyirya au kʉyasiita tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Varindʉkwa mweende baa nɨ vavyɨɨrɨ vaanyu, vaanaanyu, vandʉʉ vaanyu na vijeengi vyaanyu. Kei vamwɨ vaanyu, vaantʉ kʉvʉʉlaa veende. ");
INSERT INTO lag_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sʉʉlwa mʉrɨ nɨ vaantʉ voosi sa mwaanduma nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Maa kaa, baa lʉjwɨ́ɨrɨ lʉmwɨ vii lwaanyu sɨ lʉrɨ rɨmɨra tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ko yimirirya, lamurirya mʉrɨ nkaasʉ yaanyu. ");
INSERT INTO lag_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mpɨɨndɨ ˆmʉrɨ koona múuji wa Yerusaléemu warɨ́ɨngɨrɨɨrwe nɨ valʉkalʉka va vavɨ vaanyu, mʉtaange kʉsaambʉlwa kwaachwe kwaséngerɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mpɨɨndɨ ijo, vara ˆvarɨ Yudéea vatɨjɨre njuulwii. Vara ˆvarɨ katɨ na katɨ ya múuji vafume na weerwii ya múuji. Na vara ˆvarɨ mawundii karɨ vɨɨngɨre na múujii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sa sikʉ ijo, kʉva jiri sikʉ ja irya, sa yara ˆyaandɨkwa yakiimane. ");
INSERT INTO lag_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nɨ mpolaɨ kwa vara ˆvarɨ kʉva varuto, na vara ˆvɨɨndookoonkya sikʉ ijo! Mpɨɨndɨ ijo, kʉva kʉrɨ na imalo ikʉʉlʉ kʉrɨ weerʉ yoosi, na nkalari ya Mʉlʉʉngʉ veera ɨrɨ mweeri ya vaantʉ va mbyaala ɨhɨ. ");
INSERT INTO lag_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Vaantʉ ˆvarɨ foo kʉʉlawa varɨ na nyaasʉka, na vɨɨngɨ twaalwa varɨ na utúmwii ɨsɨ jɨɨngɨ. Na múuji wa Yerusaléemu kindaɨrɨrwa ʉrɨ nɨ vaantʉ sɨ ˆvarɨ Vayahúudi, fʉʉrʉ mpɨɨndɨ jaavo jo kʉʉyɨmɨrɨra jisire. ");
INSERT INTO lag_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Mwaasʉ, mweeri na nyényeeri koonekya viri isháara. Na kʉrɨ weerʉ, ɨsɨ kʉva jiri na uturikiri, mayɨya kʉva yarɨ na vidandárɨka na mapúunta makʉʉlʉ ˆyarɨ na mukíindo. ");
INSERT INTO lag_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Vaantʉ kɨndooyɨrɨka veende sa woowa. Kiisea veende irya ikʉʉlʉ kʉʉja riise sa ngururu ja kurumwii sɨngɨsɨka jeende. ");
INSERT INTO lag_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aho, kʉmoona varɨ Mwaana wa Mʉʉntʉ yookʉʉja machwii na ngururu na nkongojima nkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mpɨɨndɨ aya ˆyarɨ kaanda fʉmɨra, mwɨɨme neeja na mʉve na cheerʉ sa ununuuli waanyu waséngerɨɨre.” ");
INSERT INTO lag_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aho, akavavaɨra lusímo ʉlʉ, “Iririkani mʉsaambu na mɨtɨ yɨɨngɨ yoosi. ");
INSERT INTO lag_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mpɨɨndɨ ˆmʉrɨ koona yaándire tʉrɨka, mwatáangaa mpɨɨndɨ ja irʉtɨra jaséngerɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Noo jeyyo, ˆmʉrɨ koona viintʉ ivi vyoofʉmɨra, taangi Ʉtemi wa Mʉlʉʉngʉ waséngerɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kɨmaarɨ noovawyɨɨra, mbyaala ɨhɨ sɨ ɨrɨ looka tʉkʉ keende masáare aya yoosi sɨ yanafʉmɨra. ");
INSERT INTO lag_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kurumu na weerʉ looka jiri, maa kaa, masáare yaanɨ sɨ yarɨ looka vii kaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mʉlaange neeja, karɨ mɨtɨma yaanyu ɨremeerwe nɨ ʉreevi, ʉláku na uturikiri wa nkaasʉ ɨhɨ tʉkʉ. Bweeyyi jeyyo, sa sikʉ ya Mwaana wa Mʉʉntʉ kʉʉja ɨrɨ koonka na koonka. ");
INSERT INTO lag_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sikʉ ɨyo, kʉʉja ɨrɨ ja mʉteo kwa vaantʉ voosi va weerʉ. ");
INSERT INTO lag_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Haaha mʉve miiso. Mʉndoomʉloomba Mʉlʉʉngʉ sa avaheere ngururu jo nehera aya yoosi ˆyarɨ fʉmɨra. Aho, mʉdahe kwɨɨma mbere ya Mwaana wa Mʉʉntʉ.” ");
INSERT INTO lag_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kwa sikʉ joosi ijo, Yéesu akiindyáa vaantʉ Kaayii Njija. Na kyʉʉlwa ˆkɨkɨɨngɨre atamanyáa noo laala Luulwii lwa Mɨseitúuni. ");
INSERT INTO lag_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na kɨra siikʉ vaantʉ valaaváa namʉtóondo noo mʉteerera Kaayii Njija. ");
INSERT INTO lag_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Haaha mpɨɨndɨ ja ngovi ya mɨkáate sɨ ˆɨvɨ́kɨrwaa ʉsasɨ noo kʉsea Paásika ɨjáa yaséngerɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na mpɨɨndɨ ijo, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro vasaakɨráa njɨra yo mʉʉlaa Yéesu. Vabweeyya jeyyo sa vavoofáa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Irimʉ rɨkamwɨɨngɨra Yʉ́ʉda ˆaséwaa Isikarióoti, ʉmwɨ wa vapooji ikimi na vavɨrɨ va Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aho, Yʉ́ʉda akatamanya na kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakʉ́ʉ́lʉ va valʉkalʉka va Kaayii Njija ya Ijʉva. Akiirʉmɨra novo ˆvyeene arɨ mʉvarindʉka sa vamʉkwaate. ");
INSERT INTO lag_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Isáare ɨro rɨkaveerya mɨtɨma na vakiirʉmɨra kʉmʉrɨha mpía. ");
INSERT INTO lag_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yʉ́ʉda akaruma na akaanda saakɨra njɨra yo mʉvarindʉka Yéesu mpɨɨndɨ kusiina mpuka ya vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sikʉ ya ngovi ya mɨkáate sɨ ˆɨvɨ́kɨrwaa ʉsasɨ ɨkafika. Sikʉ ɨyo noo muundi ˆɨrɨ mpeho sa Paásika yasɨɨnjwáa. ");
INSERT INTO lag_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aho, maa Yéesu akavatʉma vala Peéteri na Yooháani akavasea, “Tamanyi, mʉkatwiimirye neeja chóorya cha Paásika, twiirye hamwɨ.” ");
INSERT INTO lag_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Novo vakamuurya, “Hai woosaaka tukwiimirye neeja chóorya cha Paásika?” ");
INSERT INTO lag_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yéesu akavasea, “Mpɨɨndɨ ˆmʉrɨ kɨɨngɨra múujii, lʉmana mʉrɨ na mʉʉntʉ mʉlʉme ʉmwɨ iitíikire sʉvɨya ya maaji. Mutuubi ʉwo mʉʉntʉ mʉlʉme fʉʉrʉ nyuumba ˆarɨ kɨɨngɨra. ");
INSERT INTO lag_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ˆMʉrɨ kɨɨngɨra, mʉsei mweenenyuumba, ‘Mukiindya yookuurya, hai kɨrɨ chúumba cha vayeni kʉʉntʉ ˆndɨrɨ rɨɨra chóorya cha Paásika na vapooji vaanɨ?’ ");
INSERT INTO lag_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na yeeye kʉvoonekya arɨ, baanka nkʉʉlʉ ˆɨrɨ gorófii kwavɨɨkwa viintʉ vyoosi neeja. Iyimyi neeja Paásika haaho.” ");
INSERT INTO lag_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aho, vakatamanya, ˆvakafike ʉko, vakashaana kɨra kɨɨntʉ ja ˆvyeene ajáa avawyɨ́ɨrɨɨre. Maa vakiimya neeja chóorya cha Paásika. ");
INSERT INTO lag_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mpɨɨndɨ ˆjikafike, Yéesu akiikala méesii hamwɨ na vatumwi vaachwe, kurya chóorya. ");
INSERT INTO lag_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aho, akavasea, “Namériirye matɨ maatʉkʉ vii, nirye chóorya cha Paásika na nyuunyu, de kuturikiriwa kwaanɨ kufike. ");
INSERT INTO lag_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nɨ kʉvawyɨɨra niise, sɨ ndɨrɨ kurya Paásika kei tʉkʉ, fʉʉrʉ sikʉ ˆɨrɨ kiimana Ʉtemii wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aho, akatoola ndʉvo, akamʉdʉʉmba Mʉlʉʉngʉ, yoosea, “Tooli ndʉvo ɨhɨ voosi munywe! ");
INSERT INTO lag_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nɨ kʉvawyɨɨra niise, kwaandɨra haaha sɨ ndɨrɨ kʉnywa kei diváai tʉkʉ fʉʉrʉ Ʉtemi wa Mʉlʉʉngʉ ˆʉrɨ kʉʉja.” ");
INSERT INTO lag_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aho, akatoola mʉkáate, akamʉdʉʉmba Mʉlʉʉngʉ, akʉʉbendʉlabendʉla akavaheera yoosea, “Ʉhʉ nɨ mʉvɨrɨ waanɨ ˆwootoolwa sa nyuunyu. Bweeyyi jei sa nkʉmbʉkɨra yaanɨ!” ");
INSERT INTO lag_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Viivyo ˆvakahʉmʉle kurya, akatoola ndʉvo, akasea, “Ndʉvo ɨhɨ nɨ mʉháko mufya wa Mʉlʉʉngʉ wa sakami yaanɨ ˆyookɨɨtɨka sa nyuunyu. ");
INSERT INTO lag_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Maa kaa, taangi, mʉʉntʉ ˆyookʉʉnvarindʉka amwaarɨ yoorya na nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kɨkomi Mwaana wa Mʉʉntʉ tamanya iise noo kʉʉlawa ja ˆvyeene Mʉlʉʉngʉ asaaka vive. Maa kaa, nɨ mpolaɨ kwa mʉʉntʉ ˆarɨ mʉvarindʉka.” ");
INSERT INTO lag_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aho, vakaanda kiiyurya voovo kwa voovo, “Nɨ ani kʉrɨ suusu ˆarɨ daha tʉmama isáare ɨrɨ?” ");
INSERT INTO lag_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Vapooji va Yéesu vakaanda kwiiruta ndihi, nɨ ani katɨ na katɨ yaavo ˆarɨ mʉkʉ́ʉ́lʉ. ");
INSERT INTO lag_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aho, Yéesu akavasea, “Vatemi va vaantʉ sɨ ˆvarɨ Vayahúudi na vakʉ́ʉ́lʉ vaavo, vavɨɨ́mɨrɨraa vaantʉ vaavo na ngururu. Na kei, vara ˆvalaɨ́raa vatɨɨte wiimiriri mweeri yaavo, viiyánɨrɨraa nɨ vaambiriryi va vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Maa kaa, nyuunyu karɨ mwiifwaane novo tʉkʉ. Kɨrɨ vyoova jeyyo, mʉʉntʉ mʉkʉʉlʉ waanyu ave ja muduudi kʉlookya voosi. Kei, ʉra ˆarɨ mʉlongooli wa vaantʉ, ave ja mʉtʉmami waanyu. ");
INSERT INTO lag_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Iririkani! Mʉkʉ́ʉ́lʉ nɨ arɨkwɨ? Nɨ ʉra ˆiíkalaa méesii kurya au nɨ ʉra ˆatʉ́mamɨraa vaantʉ méesii? Eri, sɨ ʉra ˆiíkalaa kurya tʉkʉ wʉʉ? Haaha nɨɨnɨ ndɨrɨ ʉmwɨ waanyu ja ʉra ˆavatʉ́mamɨraa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nyuunyu mwachaala na nɨɨnɨ sikʉ joosi ˆnayerwáa. ");
INSERT INTO lag_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Haaha, ja ˆvyeene nɨɨnɨ naheewa Ʉtemi nɨ Taáta waanɨ, baa nɨɨnɨ nɨ kʉvaheera niise ʉtemi. ");
INSERT INTO lag_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jeyyo, kurya mweende no nywa méesii ya Ʉtemii waanɨ. Kei, kiikala mweende machuumbii ya kɨtemi na lamʉrɨra mweende nkolo ikimi na ivɨrɨ ja Isiraéeli.” ");
INSERT INTO lag_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yéesu akasea, “Simóoni, Simóoni, Irimʉ ralóombire sa rɨveere nyuunyu ja viintʉ murimi ˆeéraa ngáano. ");
INSERT INTO lag_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Maa kaa, nakʉlóombɨɨre weewe Simóoni kuruma kwaako kʉdɨɨre keeheka. Na ˆʉrɨ kʉʉnhɨndʉkɨra, ʉvaheere mʉtɨma vaanaanyu.” ");
INSERT INTO lag_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peéteri akamʉsea, “Ee Mweenevyoosi, nɨɨnɨ nɨɨ́mɨre neeja kʉtwaalwa na mʉnyololwii hamwɨ na weewe, baa kukwya hamwɨ na weewe!” ");
INSERT INTO lag_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yéesu akamʉsea, “Peéteri, nookuwyɨɨra de nkʉkʉlʉme ɨvɨɨke uchikʉ wa isikʉ, kuunsiita ʉrɨ katatʉ woosea sɨ wʉʉmányire tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aho, maa Yéesu akavuurya vapooji vaachwe, “ˆNkavatʉme bila mpía, bila mufuko wo kɨɨnjɨra na bila viráatʉ, mʉjáa mwasɨrɨrwa nɨ kɨɨntʉ wʉʉ?” Novo vakuuyirya vakasea, “Tʉkʉ, sɨ tasɨrɨrwa nɨ kɨɨntʉ chochoosi tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aho, akavasea, “Haaha koonɨ mʉʉntʉ arɨ na mufuko wa mpía ʉʉsʉmʉle, na ʉra ˆarɨ na mufuko wo kɨɨnjɨra ʉʉsʉmʉle. Na ʉra ˆasiina nyaasʉka, avae iyoombe nkáancho yaachwe awʉle nyaasʉka. ");
INSERT INTO lag_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sa nɨ kʉvawyɨɨra niise, Masáare ˆYarɨ Mpeho nɨ mpaka yakiimane kʉrɨ nɨɨnɨ, ‘Avalwa hamwɨ na ˆvawúnaa miiro.’ Kɨkomi yara ˆyaandɨkwa sa nɨɨnɨ nɨ kiimana yiise.” ");
INSERT INTO lag_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Vapooji vaachwe vakamʉsea, “Mʉkʉ́lʉ, laanga kwatɨɨte nyaasʉka ivɨrɨ aha.” Ne akavasea, “Yatóoshiirye.” ");
INSERT INTO lag_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hara, maa Yéesu akadoma na Luulwii lwa Mɨseitúuni ja viintʉ ˆiijʉvɨra na vapooji vaachwe vajáa vamutúubire. ");
INSERT INTO lag_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ˆVakafike aho, maa akavasea vapooji vaachwe, “Mʉloombi Mʉlʉʉngʉ sa mʉdɨɨre kwɨɨngɨra mʉtehwii!” ");
INSERT INTO lag_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aho, akavareka kʉlɨ kʉlɨ ja iwʉmo ra iwye. Akachwaama akaanda kʉmʉloomba Mʉlʉʉngʉ ");
INSERT INTO lag_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","yoosea, “Taáta! Koonɨ viri kweerya mʉtɨma, nooloomba wʉʉnseyyirye ndʉvo ɨhɨ ya uturikiri. Maa kaa, karɨ vive ja ˆveene noosaaka tʉkʉ, vive ja ˆvyeene woosaaka weewe.”  ");
INSERT INTO lag_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Murimʉ mʉʉja fuma kurumwii ʉkamʉfʉmɨra, maa ʉkamʉheera ngururu. ");
INSERT INTO lag_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yéesu akatuuba loomba mʉnʉmʉʉnʉ na ajáa atɨɨte uturikiri na alʉngʉrɨráa nɨ ʉsʉʉngʉ. Na mpɨɨndɨ ˆaloombáa, irʉtɨra raachwe rɨkava ja matóonti ya sakami yoowya na ɨsɨ. ");
INSERT INTO lag_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aho, akiinʉka hara kʉʉntʉ ˆamʉloombáa Ijʉva, akahɨndʉka na kwa vapooji vaachwe. Kʉra akavashaana valɨ́ɨre, sa vajáa vakátɨɨre sa viintʉ vajáa vaviswɨ́ɨre. ");
INSERT INTO lag_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Akavuurya akavasea, “Sa che mʉnyéyyiirye? Inuki, mʉloombi Mʉlʉʉngʉ, karɨ jɨ mwɨɨngɨre mʉtehwii tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mpɨɨndɨ Yéesu ˆajáa akaarɨ yoolʉʉsɨka na vapooji vaachwe, mpuka ya vaantʉ ˆvalóngwɨɨrwe nɨ Yʉ́ʉda, ʉmwɨ wa vapooji vaachwe ikimi na vavɨrɨ, ɨkafika. Yʉ́ʉda akamʉseeserera Yéesu sa amʉsʉndɨre. ");
INSERT INTO lag_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Maa kaa, Yéesu akamʉsea, “Aka Yʉ́ʉda! Eri, nɨ kʉmʉvarindʉka wiise Mwaana wa Mʉʉntʉ ko mʉnsʉndɨra wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Vapooji va Yéesu ˆvakoone yara ˆyarɨ fʉmɨra, maa vakamuurya Yéesu, “Mʉkʉ́lʉ, tʉvatemeteme na nyaasʉka wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hahara, ʉmwɨ waavo akamʉtema na nyaasʉka mʉtʉmami wa mweeneɨsɨ mʉkʉʉlʉ, kutu kwa kʉlʉme dúú. ");
INSERT INTO lag_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Maa kaa, Yéesu akasea, “Reki!” Aho, akamʉsaasya kʉra kutu na ʉra mʉʉntʉ akahola. ");
INSERT INTO lag_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aho, maa Yéesu akavuurya vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, vakʉ́ʉ́lʉ va valʉkalʉka va Kaayii Njija ya Ijʉva na vawosi ˆvajáa vuújire, “Nɨɨnɨ ndɨrɨ mʉhóki vaantʉ viintʉ muújire na nyaasʉka na nkusi wʉʉ? ");
INSERT INTO lag_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sikʉ joosi nɨjáa na nyuunyu waámii wa Kaaya Njija, maa kaa, kʉra sɨ mwaankwaatáa tʉkʉ. Haaha vyavɨ́ɨre mpɨɨndɨ jaanyu, mpɨɨndɨ mʉtemi wa kilwiirya ˆyookɨɨmɨrɨra!” ");
INSERT INTO lag_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aho, vakamʉkwaata Yéesu, maa vakamʉtwaala fʉʉrʉ kaayii kwa mweeneɨsɨ mʉkʉʉlʉ. Peéteri ne akatuuba nyuma kwa kʉlɨ. ");
INSERT INTO lag_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ˆVakakorye mooto katɨkatɨ ya waama, maa vakiikala hamwɨ vookoota mooto. Peéteri ne akiikala hamwɨ novo. ");
INSERT INTO lag_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mʉtʉmami ʉmwɨ wa kɨɨntʉ kiki akamoona Peéteri iíkyɨɨre hara mootwii. Akamʉlaanga neeja, maa akasea, “Baa mʉʉntʉ ʉhʉ nɨ hamwɨ aarɨ na Yéesu.” ");
INSERT INTO lag_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Maa kaa, Peéteri akasiita yoosea, “Aka, mʉʉntʉ muki, sɨ namʉmányire tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mpɨɨndɨ kiduudi mʉʉntʉ ʉmwɨ akamoona Peéteri, maa akamʉsea, “Baa weewe ʉrɨ ʉmwɨ waavo!” Maa kaa, Peéteri akasea, “We mʉʉntʉ we, nɨɨnɨ tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ja isaa rɨmwɨ jei ˆrɨkalooke, mʉʉntʉ wɨɨngɨ akuumirirya yoosea, “Kɨkomi mʉʉntʉ ʉhʉ nɨ hamwɨ aarɨ ne sa baa yeeye woosi nɨ Mʉgaliláaya.” ");
INSERT INTO lag_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aho, Peéteri akamʉsea, “We mʉʉntʉ we, sɨ nootaanga kɨra ˆwoolʉʉsa tʉkʉ!” Hahara viintʉ ˆalʉʉsáa masáare ayo, nkʉkʉlʉme ɨkavɨɨka. ");
INSERT INTO lag_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aho, Mweenevyoosi akiilorera, akamʉlaanga Peéteri. Peéteri akakʉmbʉkɨra masáare ˆmeene aarɨ awyɨ́ɨrɨɨrwe nɨ Mweenevyoosi, “Isikʉ nkʉkʉlʉme sɨ ɨnavɨɨka, sea ʉrɨ sɨ waamányire tʉkʉ katatʉ.” ");
INSERT INTO lag_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peéteri akafuma na weerwii, maa akɨɨta koorɨra maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vara vaantʉ ˆvamʉlaangiriryáa Yéesu vakaanda kʉmʉhenchʉla no mʉvaa. ");
INSERT INTO lag_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Vakamuchuunga ntaamɨ miiswii, maa de vandoomʉhenchʉla voosea, “Hoonɨ taanga nɨ ani ˆakʉváire?” ");
INSERT INTO lag_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Vakatuuba kʉmʉtʉkɨra mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ˆKʉkamwaae, Balása Nkʉʉlʉ ya vawosi, hamwɨ na vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, na vakʉ́ʉ́lʉ va vakiindya va Miiro vakalʉmana. Yéesu ne akareetwa na mbere yaavo. ");
INSERT INTO lag_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aho, vakamuurya voosea, “Tʉwyɨɨre! Weewe noo Masía wʉʉ?” Yéesu akavasea, “Baa koonɨ navawyɨ́ɨrɨɨre sɨ mʉrɨ ruma vii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kei baa koonɨ navuúriirye, sɨ mʉrɨ kuuyirya vii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Maa kaa, kwaandɨra haaha Mwaana wa Mʉʉntʉ iíkyɨɨre mʉkono wa kʉlʉme wa Mʉlʉʉngʉ Mweenengururu.” ");
INSERT INTO lag_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aho, voosi vakamuurya, “Eri, weewe noo Mwaana wa Mʉlʉʉngʉ wʉʉ?” Yeeye akavasea, “Nyuunyu mulúusire nɨɨnɨ ndɨrɨ!” ");
INSERT INTO lag_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aho, maa vakasea, “Ʉshahíidi wɨɨngɨ ʉrɨkwɨ kei toosaaka kʉlookya ʉhʉ? Suusu veeneevyo tatéɨɨre fuma mʉlomwii waachwe.” ");
INSERT INTO lag_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aho, Balása Nkʉʉlʉ yoosi ya Vayahúudi ikiinʉka, maa vakamʉtwaala Yéesu na kwa Piláato. ");
INSERT INTO lag_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Vakaanda kumusitaakya voosea, “Tamʉteera ʉhʉ mʉʉntʉ yookiindya vaantʉ vave vasaambʉ kʉrɨ ɨsɨ yiitʉ. Avakáanʼyaa vaantʉ vareke kʉrɨha kóodi kwa Kaisáari, kei aséaa yeeye noo Masía, na nɨ Mʉtemi.” ");
INSERT INTO lag_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jeyyo Piláato akamuurya Yéesu, “Weewe noo mʉtemi wa Vayahúudi wʉʉ?” Yéesu akasea, “Weewe ulúusire.” ");
INSERT INTO lag_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aho, Piláato akavasea vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na mpuka ya vaantʉ, “Sɨ nookoona ʉvɨ wa ʉhʉ mʉʉntʉ tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Maa kaa, voovo vakuumirirya voosea, “Ʉhʉ mʉʉntʉ yoosoonka vaantʉ kwa ukiindya waachwe kwa ɨsɨ yoosi ya Vayahúudi. Aandɨra ʉko Galiláaya mpaka afíkire kʉnʉ Yerusaléemu.” ");
INSERT INTO lag_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Piláato ˆakateere ayo, maa akuurya, “Ʉhʉ mʉʉntʉ nɨ Mʉgaliláaya wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ˆAkataange Yéesu nɨ mʉʉntʉ wa Galiláaya, maa akamʉtwaala na kwa Heróode. Heróode noo ajáa mʉtemi wa Galiláaya na mpɨɨndɨ ijo nɨ Yerusaléemu ajáa. ");
INSERT INTO lag_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heróode ˆakamoone Yéesu, akavyeenda maatʉkʉ vii sa ajáa ateera masáare Yéesu ˆatʉmamáa, sa jeyyo, asaakáa kʉmoona Yéesu kwa sikʉ ˆjiri foo. Kei, ajáa atɨɨte mpɨɨma yo moona Yéesu yootʉmama isháara na myuujíisa ˆyiísimiresimire. ");
INSERT INTO lag_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aho, akamuurya Yéesu masáare ˆyarɨ foo, maa kaa, Yéesu sɨ uuyirya kɨɨntʉ chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakiindya va Miiro vajáa viímire voomusitaakya Yéesu na ngururu. ");
INSERT INTO lag_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heróode na valwi nkoondo vaachwe vakaanda kʉmʉhenchʉla Yéesu no mʉbwɨɨtɨra. Vakamʉvɨkɨra ɨngo ja kɨtemi, maa vakamʉhɨndʉla na kwa Piláato. ");
INSERT INTO lag_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Keende sikʉ ɨyo, Heróode na Piláato vakava vijeengi. De ayo yafʉmɨre Piláato na Heróode nɨ ja kúri na nyaáu vajáa. ");
INSERT INTO lag_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mpɨɨndɨ kiduudi, Piláato akavaanɨrɨra vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva, vakʉ́ʉ́lʉ va Vayahúudi na vaantʉ vɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aho, akavasea, “Nyuunyu mʉmʉréetire ʉhʉ mʉʉntʉ na kwaanɨ na mʉséire yoovakiindya vaantʉ vave vasaambʉ. Haaha nɨɨnɨ namuchúkurumire mbere yaanyu, maa kaa, nɨɨ́ne asiina ʉvɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Baa Heróode sɨ ɨɨ́ne isáare roroosi tʉkʉ ro mʉlamʉrɨra mʉʉntʉ ʉhʉ, na noo ˆchooreka amʉhɨ́ndwɨɨre na kʉrɨ suusu. Ja ˆvyeene mookoona kusiina kɨɨntʉ chochoosi ˆcheene mʉʉntʉ ʉhʉ atʉ́mamire ˆchoobweeya ɨɨme neeja kukwya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Haaha nɨ lairirya niise avawe mɨjeléedi, maa de nɨmʉrekere.”  ");
INSERT INTO lag_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Piláato ajáa atɨɨte tʉʉva yo mʉchʉngʉrɨra mʉʉntʉ ʉmwɨ ˆachuungwa mpɨɨndɨ ja ngovi ya Paásika. ");
INSERT INTO lag_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Aho, vaantʉ voosi vakatʉla isóso na ngururu voosea, “Mʉʉntʉ ʉwo ʉʉlawe, tʉchʉngʉrɨre Baráaba!” ");
INSERT INTO lag_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ʉhʉ Baráaba ajáa achuungwa sa ntiribʉka ˆngʼeene ajáa abweeyya múujii na so kʉʉlaa mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piláato asaakáa kʉmʉrekera Yéesu, sa jeyyo, akalʉʉsɨka kei na vaantʉ. ");
INSERT INTO lag_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Maa kaa, voovo vakatuuba tʉla isóso voosea, “Muningʼinʼye mʉsaláabii fʉʉrʉ akwye, muningʼinʼye mʉsaláabii fʉʉrʉ akwye!” ");
INSERT INTO lag_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Lwa katatʉ Piláato akavuurya, “Sa che? Nɨ ʉvɨ ʉrɨkwɨ ʉhʉ mʉʉntʉ ˆabwéeyyiirye? Nɨɨnɨ sɨ nɨɨ́ne ʉvɨ wowoosi wo bweeyya ʉʉlawe tʉkʉ. Sa jeyyo, lairirya niise avawe mɨjeléedi, maa de nɨmʉrekere.” ");
INSERT INTO lag_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Maa kaa, vaantʉ vakatuuba tʉla isóso mʉnʉmʉʉnʉ, voosaaka Yéesu aningʼiniwe mʉsaláabii fʉʉrʉ akwye. Jeyyo, isóso raavo rɨkasiinda. ");
INSERT INTO lag_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aho, Piláato akalamʉla kʉbweeyya ja ˆvyeene vasaakáa. ");
INSERT INTO lag_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Piláato akamʉchʉngʉrɨra ʉra mʉʉntʉ ˆvamʉsaakáa, ˆajáa achuungwa so reeta ntiribʉka na so kʉʉlaa. Akamʉkwaatya Yéesu mɨkonwii ya valwi nkoondo vaachwe va Kɨrúumi, sa vamʉbweeyyirye ja ˆvyeene Vayahúudi vasaakáa. ");
INSERT INTO lag_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Njirii, mpɨɨndɨ ˆvamʉtwaaláa Yéesu noo muningʼinʼya, vakalʉmana na mʉʉntʉ ʉmwɨ ˆaséwaa Simóoni, mʉʉntʉ wa múuji wa Kɨréene. Yeeye nɨ iwundii afumáa. Valwi nkoondo vakamʉkwaata, vakamʉdoomererya avereke mʉsaláaba nyuma ya Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Vaantʉ ˆvarɨ foo vamutuubáa Yéesu. Vamwɨ va vaantʉ avo, nɨ vaantʉ vaki ˆveene vamʉrɨrɨráa no myaaha. ");
INSERT INTO lag_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yéesu akiilorera, akavasea, “Nyuunyu vahíínja va Yerusaléemu, kuundiriri nɨɨnɨ tʉkʉ! Iririri nyuunyu na vaana vaanyu! ");
INSERT INTO lag_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Laangi, fika jiri mpɨɨndɨ vaantʉ lʉʉsa varɨ, ‘Vatalariwa ˆvawuumba, vara sɨ ˆvavyaala na vara masʉʉsʉ yaavo sɨ ˆyoonkwa.’ ");
INSERT INTO lag_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aho, ‘Kujisea varɨ njʉʉlʉ “Tuwyiiri!” Na viduunda “Tukunikiriri!”’ ");
INSERT INTO lag_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sa koonɨ vookʉʉbweeyyirya jei mʉtɨ ˆʉrɨ ɨcho, nɨ joolɨ viri kʉva kwa mʉtɨ ˆwʉʉma?” ");
INSERT INTO lag_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mpɨɨndɨ ijo, kʉjáa kwatɨɨte viívi vavɨrɨ ˆvatwaalwáa sa vakʉʉlawe hamwɨ na Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ˆVakafike haantʉ ˆhaséwaa Kɨsááya cha Mʉtwe, vakamuningʼinʼya Yéesu mʉsaláabii hamwɨ na viívi vavɨrɨ, ʉmwɨ mʉkono wa kʉlʉme na wɨɨngɨ mʉkono wa kʉmooso, kɨra mʉʉntʉ mʉsaláabii waachwe. ");
INSERT INTO lag_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yéesu akasea, “Taáta, vasee ʉvɨ waavo wasírire sa sɨ vootaanga kɨra ˆvootʉmama tʉkʉ.” Vakiigavɨra ɨngo jaachwe ko jivaɨra mbare. ");
INSERT INTO lag_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Vaantʉ vakɨɨma aho, kʉnʉ voomʉlaanga. Vakʉ́ʉ́lʉ va Vayahúudi vakaanda mʉhenchʉla voosea, “Avalamuriryáa vɨɨngɨ, koonɨ yeeye nɨ Masía ˆasaawʉlwa nɨ Mʉlʉʉngʉ nɨ iilamurirye yeemweene!” ");
INSERT INTO lag_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Valwi nkoondo novo vakʉʉja, vakamʉhenchʉla, maa vakamʉretera diváai ˆyasasʉka sa anywe. ");
INSERT INTO lag_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Vakamʉsea, “Koonɨ kɨkomi weewe noo mʉtemi wa Vayahúudi, ilamurirye weemweene!” ");
INSERT INTO lag_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mweeri yaachwe masáare aya yajáa yaandɨkwa ibambarii, “Ʉhʉ noo mʉtemi wa Vayahúudi.” ");
INSERT INTO lag_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ʉmwɨ wa vara viívi ˆvajáa vaníngʼiniiwe ne akamʉtʉkɨra yoosea, “Weewe sɨ noo Masía? Ilamurirye sa ʉtʉlamurirye na suusu.” ");
INSERT INTO lag_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Maa kaa, ʉra mwiívi wɨɨngɨ akamʉdalavya yoosea, “Eri, weewe sɨ ʉmoófaa Mʉlʉʉngʉ tʉkʉ wʉʉ? Amwɨ voosi tahɨ́ɨwe irya rɨɨro? ");
INSERT INTO lag_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Suusu, tahókɨɨre ɨrɨ irya ja ˆvyeene Miiro yalʉʉsa sa vira ˆvyeene tabwéeyyaa. Maa kaa, ʉhʉ mʉʉntʉ sɨ abwéeyyiirye ʉvɨ wowoosi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aho akasea, “Ee Yéesu, nkʉmbʉkɨra mpɨɨndɨ ˆʉrɨ kɨɨngɨra Ʉtemii waako!” ");
INSERT INTO lag_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yéesu akamʉsea, “Kɨkomi nookuwyɨɨra, isikʉ kʉva ʉrɨ hamwɨ na nɨɨnɨ ntindikii njija.” ");
INSERT INTO lag_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mpɨɨndɨ ijo, nɨ ja mpɨɨndɨ ja mpoloonge jijáa, mwaasʉ ʉkarima fʉʉrʉ mpɨɨndɨ ja cháámuusi, kilwiirya kɨkakʉnɨkɨrɨra ɨsɨ yoosi. ");
INSERT INTO lag_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mwaasʉ ʉkareka korera. Ipasía ra Kaaya Njija ya Ijʉva rɨkaatʉka katɨ na katɨ havɨrɨ. ");
INSERT INTO lag_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yéesu akalʉʉsɨka na ngururu, yoosea, “Taáta, mɨkonwii yaako mʉtɨma waanɨ nuuvíikire.” ˆAkalʉʉse ayo, akawulala. ");
INSERT INTO lag_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mʉkʉ́ʉ́lʉ wa valwi nkoondo ˆakoone ayo ˆyafʉ́mɨɨre, akamʉdʉʉmba Mʉlʉʉngʉ yoosea, “Kɨkomi mʉʉntʉ ʉhʉ nɨ mʉwoloki aarɨ.” ");
INSERT INTO lag_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na vaantʉ voosi ˆvajáa viijíingire hara kʉlaanga masáare aya ˆvakoone ayo ˆmeene yajáa yafʉ́mɨɨre, vakahɨndʉka na kaayii kwaavo kʉnʉ vookiivaavaa kɨpeembe nɨ ʉsʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Maa kaa, vara ˆvajáa vamʉmányire neeja na vara vaantʉ vaki ˆveene ajáa ʉʉjanʼya novo fuma Galiláaya, vajáa vɨɨma kʉlɨ, kʉnʉ voolaanga ayo masáare. ");
INSERT INTO lag_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Haaha kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆajáa mʉʉja na mʉwoloki ˆasewáa Yooséefu. Yeeye nɨ ʉmwɨ wa Balása Nkʉʉlʉ ya Vayahúudi ajáa. ");
INSERT INTO lag_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ʉhʉ Yooséefu, meevo nɨ múujii wa Arimatáaya ˆʉrɨ ɨsɨ ya Yudéea kʉjáa. Yeeye awoojeráa kʉʉja kwa Ʉtemi wa Mʉlʉʉngʉ. Sikʉ ɨyo, yeeye sɨ ajáa arúmire ʉlamuli wa viivaachwe wo mʉʉlaa Yéesu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yooséefu akatamanya na kwa Piláato, akɨtooloomba aheewe mʉvɨrɨ wa Yéesu sa akʉʉtaahe. ");
INSERT INTO lag_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Akuukiimya mʉvɨrɨ wa Yéesu, akʉʉfarɨmbɨrɨra na sáanda ya kɨtáani, maa akɨɨta kʉʉtaaha mbiríírii ɨjáa sɨ ˆɨnataahwa mʉʉntʉ. Ɨhɨ mbɨrɨ́ɨ́ra nɨ ja mpaanga ɨjáa na ɨjáa yabokwa mwaalaliwyii. ");
INSERT INTO lag_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sikʉ ɨyo, nɨ sikʉ yo kiimya neeja sikʉ ya Sabáato ɨjáa na Sabáato ɨjáa yaséngerɨɨre kwaanda. ");
INSERT INTO lag_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vaantʉ vaki vara ˆvajáa vʉʉjanʼya na Yéesu fuma Galiláaya, vajáa vamutuuba Yooséefu na mbiríírii. Sa jeyyo, vakɨɨyona ɨra mbɨrɨ́ɨ́ra na mʉvɨrɨ wa Yéesu haantʉ ˆʉjáa ʉláariiwe. ");
INSERT INTO lag_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aho, vakahɨndʉka na kaayii, vakɨɨta kiimya neeja makuta na mooda wo haka mʉvɨrɨ. Sikʉ ya Sabáato vakahʉmʉlʉka ja ˆvyeene ʉlairiri wa Ijʉva walʉʉsa. ");
INSERT INTO lag_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Haaha sikʉ ya Jumapɨ́ɨrɨ namʉtóondo dwɨɨ, vara vaantʉ vaki vajáa vatoola makuta yara ˆvajáa viimiiryé neeja, maa vakadoma na mbiríírii ya mpaanga ˆngʼeene ɨjáa yabokwa mwaalaliwyii. ");
INSERT INTO lag_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ˆVakafike kʉra, vakashaana rɨra iwye rafíngiritiiwe fuma mbiríírii. ");
INSERT INTO lag_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Maa kaa, ˆvakɨɨngɨre na mbiríírii, sɨ vashaana mʉvɨrɨ wa Yéesu Mweenevyoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ntɨ ˆvakaarɨ vahwáalɨɨre, koonka vaantʉ valʉme vavɨrɨ viivɨ́kɨɨre ɨngo njerʉ ˆjilavalava mʉnʉmʉʉnʉ ja lʉlávo vakafʉmɨra, maa vakɨɨma heehi novo. ");
INSERT INTO lag_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Avo vaantʉ vaki vakoofa mʉnʉmʉʉnʉ, vakiinamya mɨtwe yaavo fʉʉrʉ ɨsɨ. Aho, vara vaantʉ vakavasea, “Sa che moomʉsaakɨra ˆarɨ mooyo kwa vaantʉ ˆvaakwya? ");
INSERT INTO lag_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Asiina aha tʉkʉ, afúfukire! Kumbukiri vira ˆvyeene avawyɨɨra mpɨɨndɨ ˆajáa hamwɨ na nyuunyu kʉra Galiláaya. ");
INSERT INTO lag_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ajáa avasea, ‘Vyasaakwa Mwaana wa Mʉʉntʉ avɨɨkwe mɨkonwii ya vaantʉ vavɨ, aningʼiniwe mʉsaláabii fʉʉrʉ akwye, na sikʉ ya katatʉ afʉfʉke.’” ");
INSERT INTO lag_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aho, vakayakʉmbʉkɨra yara masáare Yéesu ˆajáa avawyɨɨra. ");
INSERT INTO lag_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Avo vaantʉ vaki vakahɨndʉka fuma mbiríírii. Vakɨɨta koo vawyɨɨra isimwi ɨrɨ vara vatumwi ikimi na ʉmwɨ baa na vapooji vɨɨngɨ voosi va Yéesu. ");
INSERT INTO lag_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Avo vaantʉ vaki marina yaavo noo vala Maríia Makɨdaléena, Yooáana na Maríia íyo waala Yaakúupu. Kei kʉjáa kwatɨɨte vaantʉ vaki vɨɨngɨ ˆvajáa hamwɨ novo, na ava noo vavawyɨɨra vatumwi masáare aya. ");
INSERT INTO lag_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Maa kaa, sɨ varuma ayo masáare tʉkʉ, vakoona nɨ ya kɨhoho vii. ");
INSERT INTO lag_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Baa neembe nɨ jeyyo, Peéteri akiinʉka, akatamanya itɨ́ɨjo fʉʉrʉ mbiríírii. ˆAkasʉngɨrɨre akoona ɨngo ja kɨtáani joongʼeene vii. Akahɨndʉka na kaayii kʉnʉ yookiiyurya kɨra ˆkɨfʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Haaha sikʉ ɨyo, kʉjáa kwatɨɨte vapooji vavɨrɨ va Yéesu ˆvatamanyáa na iturii rɨmwɨ ˆraséwaa Emáau. Kufuma Yerusaléemu fʉʉrʉ Emáau nɨ ja lʉyeendo lwa masaa yavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na mpɨɨndɨ ˆvajáa njirii, vakava vookiivaɨra mbuwo ja masáare ˆmeene yafʉmɨɨré. ");
INSERT INTO lag_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mpɨɨndɨ ˆvajáa vakaarɨ voolʉʉsɨka ayo, Yéesu mweeneevyo akavakwaata, maa akaanda yeendanʼya novo. ");
INSERT INTO lag_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Maa kaa, miiso yaavo yakakʉnɨkɨrɨrwa vadɨɨre kʉmʉtaanga. ");
INSERT INTO lag_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeeye akavuurya, “Nɨ mbuwo che mʉkɨtookiivaɨra mpɨɨndɨ ˆmooyeenda?” Avo vamaka vakɨɨma kʉnʉ vaviswɨ́ɨre. ");
INSERT INTO lag_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ʉmwɨ waavo ˆasewáa Kɨleóopa akamuurya, “Weewe vii noo mʉyeni sɨ ˆʉmányire masáare ˆyafʉmɨɨré aha Yerusaléemu sikʉ iji wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Maa Yéesu akavuurya, “Nɨ masáare yarɨkwɨ ayo?” Novo vakamʉsea, “Masáare ya Yéesu wa Nasaréeti. Yeeye nɨ mʉláali na mʉtwe ajáa, kei ajáa atɨɨte lʉvɨro lʉkʉʉlʉ mirimwii yaachwe na masáarii yaachwe mbere ya Mʉlʉʉngʉ na vaantʉ voosi. ");
INSERT INTO lag_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakʉ́ʉ́lʉ va aha mɨɨtʉ, vamʉkwaatya mɨkonwii ya Piláato sa aheewe irya ro kwya, maa akaningʼiniwa mʉsaláabii fʉʉrʉ akakwya. ");
INSERT INTO lag_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Maa kaa, ʉhʉ noo tiilaangyáa tununuula arɨ suusu Viisiraéeli fuma kwa vavɨ viitʉ. Kʉlookya ayo, isikʉ nɨ sikʉ ya katatʉ keende ayo ˆyafʉmɨra. ");
INSERT INTO lag_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kei kwatɨɨte vaantʉ vaki va mpuka yiiswi ˆvatʉhwáaliirye isikʉ. Voovo vaarɨ valáavire na mbiríírii. ");
INSERT INTO lag_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ʉko mbiríírii, sɨ vʉʉshɨ́hɨɨne mʉvɨrɨ wa Yéesu tʉkʉ. ˆVakahɨndʉke, vatʉséire, vafʉ́mɨɨrwe nɨ mirimʉ miija na yavaséire, ‘Yéesu nɨ mooyo arɨ.’ ");
INSERT INTO lag_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aho, vamwɨ va vaantʉ valʉme va mpuka yiiswi vadómire itɨ́ɨjo na mbiríírii na vashɨ́hɨɨne ja ˆvyeene vawyɨ́ɨrɨɨrwe nɨ vara vaantʉ vaki. Maa kaa, voovo sɨ vamwɨɨ́ne Yéesu tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yéesu akavasea, “Aka re nyuunyu mʉrɨ vahoho! Sa che mɨtɨma yaanyu yafafa jei kuruma masáare yoosi ˆyalʉʉswa nɨ valáali na mʉtwe va Ijʉva? ");
INSERT INTO lag_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eri, sɨ vijáa vyasaakwa Masía aturikiriwe kwa njɨra ɨyo, maa de ɨɨngɨre nkongojimii yaachwe tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Akavavariyʉrɨra masáare yoosi ˆyarɨ Masáarii ˆYarɨ Mpeho ˆmeene yalʉʉswa kʉrɨ yeeye. Akalʉʉsa kwaandɨra masáarii ya Mʉ́sa fʉʉrʉ masáarii yoosi ya valáali na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ˆVakasengerere kufika rɨra ituri kʉʉntʉ ˆvadomáa, Yéesu akabweeyya ja yoolookanirya na mbere. ");
INSERT INTO lag_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Maa kaa, voovo vakamʉheemba voosea, “Laala aha mɨɨtʉ, amwɨ iwʉlo rɨɨ́ngɨɨre nuuchikʉ wafíkire?” Jeyyo Yéesu akatamanyanʼya novo. ");
INSERT INTO lag_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yéesu ˆakiikale novo méesii kurya chákurya, akatoola mʉkáate, akamʉdʉʉmba Mʉlʉʉngʉ, akʉʉbendʉlabendʉla, maa akavaheera. ");
INSERT INTO lag_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hahara, miiso yaavo yakakʉnʉkʉlwa, maa vakamʉtaanga nɨ Yéesu. Ne hahara akarɨmɨra mbere yaavo. ");
INSERT INTO lag_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aho, vakiiyurya voosea, “Mɨtɨma yiiswi sɨ yaarɨ ɨkórɨɨre mpɨɨndɨ ˆaatʉvariyʉrɨra no tʉlaɨra Masáare ˆYarɨ Mpeho kʉra njirii tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mpɨɨndɨ jijira vakahɨndʉka na Yerusaléemu. Kʉra, vakavashaana vapooji vaachwe ikimi na ʉmwɨ viijíingire hamwɨ baa na vɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Novo vaseáa, “Mweenevyoosi afúfukire kɨkomi! Amʉfʉ́mɨɨre Simóoni!” ");
INSERT INTO lag_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aho, vara vapooji vavɨrɨ novo vakalʉʉsa masáare ˆyavafʉ́mɨɨre njirii, na ˆvyeene vamʉtáangire Yéesu ˆakabendʉlebendʉle mʉkáate, de akavaheera. ");
INSERT INTO lag_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mpɨɨndɨ ˆvajáa vakaarɨ voolʉʉsɨka ayo, Yéesu mweeneevyo akɨɨma katɨkatɨ yaavo akavasea, “Mwiikalo mʉʉja ʉve na nyuunyu!” ");
INSERT INTO lag_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Vakiivʉndʉka na vakoofa mʉnʉmʉʉnʉ sa viiseáa vɨɨ́ne murimʉ. ");
INSERT INTO lag_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Maa kaa, Yéesu akavuurya, “Sa che mookoofa? Sa che mʉrɨ na kivundu mitimii yaanyu? ");
INSERT INTO lag_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Laangi mayaanja yaanɨ na majeo yaanɨ, sa mʉtaange koonɨ kɨkomi nɨ nɨɨnɨ. Nsaasyi moone, sa murimʉ usiina mʉvɨrɨ tʉkʉ na makúfa tʉkʉ ja ˆvyeene mookʉʉnyona natɨɨte.” ");
INSERT INTO lag_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ˆAkahʉmʉle kʉvawyɨɨra masáare ayo, akavalaɨra mayaanja yaachwe na majeo yaachwe. ");
INSERT INTO lag_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Vapooji vaachwe vakavyeenda maatʉkʉ vii mpaka vakasiindwa baa kuruma yara ˆvoonáa. Aho, akavuurya, “Mwatɨɨte chóorya chochoosi aha wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Voovo vakamʉheera ibéendʉ ra soompa ˆyookiwa. ");
INSERT INTO lag_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yeeye akahokera, maa akarya mbere yaavo. ");
INSERT INTO lag_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aho, akavasea, “Aya noo masáare ˆnavawyɨɨráa mpɨɨndɨ ˆnɨjáa na nyuunyu. Nɨjáa navasea, kɨra kɨɨntʉ ˆchaandɨkwa kʉrɨ nɨɨnɨ Miirwii ya Mʉ́sa, vitáabwii vya valáali na mʉtwe na Sabúurii nɨ mpaka kiikiimane.” ");
INSERT INTO lag_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aho, akachʉngʉla mɨryʉʉngʉ yaavo sa vadahe kʉtaanga Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akavasea, “Ayo noo yaandɨkwa, Masía turikiriwa arɨ na sikʉ ya katatʉ fʉfʉka arɨ fuma inkwyii. ");
INSERT INTO lag_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kei kwa irina raachwe, vaantʉ va ɨsɨ joosi kwaandɨra Yerusaléemu variyʉrɨrwa varɨ vavalandʉke fuma uvii waavo, na vasewe ʉvɨ waavo wasírire. ");
INSERT INTO lag_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nyuunyu noo mashahíidi va aya masáare. ");
INSERT INTO lag_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Laangi! Nɨɨnɨ mʉtʉma ndɨrɨ kʉrɨ nyuunyu Mʉtɨma Mʉʉja Taáta waanɨ ˆajáa iichuunga kʉvaretera arɨ. Haaha, ikali aha Yerusaléemu fʉʉrʉ mpɨɨndɨ ˆmʉrɨ heewa ngururu fuma kurumwii.” ");
INSERT INTO lag_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mpɨɨndɨ kiduudi, Yéesu akavasʉmʉla na weerwii ya múuji fʉʉrʉ iturii ra Besanía. Akiinurirya mɨkono yaachwe, akavatalarya. ");
INSERT INTO lag_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mpɨɨndɨ ˆavatalaryáa, akavareka, maa akasʉmʉlwa na kurumwii. ");
INSERT INTO lag_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aho, vakamwiinamɨra, maa vakahɨndʉka na Yerusaléemu kʉnʉ vavyeéndire mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sikʉ joosi vakiikala Kaayii Njija ya Ijʉva, kʉnʉ voomʉdʉʉmba Mʉlʉʉngʉ.");
INSERT INTO lag_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aho ncholo, kʉjáa kwatɨɨte Isáare. Ne Isáare nɨ na Mʉlʉʉngʉ ajáa, na yeeye Isáare nɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Keende ncholo, Isáare nɨ hamwɨ ajáa na Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Viintʉ vyoosi vijáa vyʉʉmbwa kwa njɨra ya ʉwo Isáare. Kusiina kɨɨntʉ chochoosi ˆchʉʉmbwa baa tweera kwa Isáare tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kʉrɨ yeeye ʉwo Isáare, noo kʉrɨ ufumo wa nkaasʉ yoosi, na ɨyo nkaasʉ noo yaava kɨweerʉ cha vaantʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ɨkyo kɨweerʉ, chiiyéreryaa kilwiiryii, na kilwiirya sɨ chadáhaa kusiinda tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mʉʉntʉ ʉmwɨ ajáa ʉʉja. Ʉwo mʉʉntʉ ajáa atʉmwa nɨ Mʉlʉʉngʉ. Irina raachwe noo Yooháani aséwaa. ");
INSERT INTO lag_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yooháani ajáa ʉʉja jo koonekya ɨkyo kɨweerʉ, na ko tweera koonekya kwaachwe, vaantʉ voosi vadahe ruma. ");
INSERT INTO lag_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yooháani sɨ ajáa ɨkyo kɨweerʉ tʉkʉ, maa kaa, yeeye ʉʉja jo voonekya vaantʉ ˆvyeene ɨkyo kɨweerʉ kɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ɨkyo kɨweerʉ cha kɨkomi, ˆkɨmʉ́rɨkɨraa kɨra mʉʉntʉ, chavijáa chookʉʉja na kʉrɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ʉhʉ Isáare ajáa amwaarɨ kʉrɨ ɨhɨ weerʉ. Na baa neembe weerʉ yʉʉmbwa nɨ Mʉlʉʉngʉ ko tweera yeeye, weerʉ sɨ yamʉtaanga tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yeeye ʉʉja kwa vaantʉ vaachwe, novo sɨ vamʉhokera tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Maa kaa, vara voosi ˆvamʉhokera na ˆvamwiilaangya, avabweeyya vave vaana va Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ava sɨ vaana va Mʉlʉʉngʉ ˆvavyaalwa kwa ufumo wa wʉʉntʉ tʉkʉ, au sɨ ko kiiseeserera kwa mʉʉntʉ mʉlʉme na mʉʉntʉ muki tʉkʉ, au kwa kʉsaaka kwa mʉʉntʉ tʉkʉ, maa kaa, kwa uvyaalo ˆufúmaa kwa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Haaha ʉwo Isáare aava mʉʉntʉ, na iikala na suusu. Na suusu toona nkongojima yaachwe, nkongojima ya Mwaana wa mpeke ˆafuma kwa Taáta, amema nduwo na kɨmáárɨ. ");
INSERT INTO lag_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yooháani oonekya kɨmáárɨ cha masáare ya ʉwo. Alʉʉsa kwa sawúti nkʉʉlʉ yoosea, “Ʉhʉ noo ʉra ˆnavawyɨɨra nkavasea, ‘Amwaarɨ yookʉʉja nyuma yaanɨ, yeeye nɨ mʉkʉʉlʉ kʉʉndookya, yeeye ajáa amwaarɨ nɨɨnɨ sɨ nɨnavyaalwa.’” ");
INSERT INTO lag_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na sa kukiimana kwaachwe, suusu voosi tahokera nduwo ˆjiri foo mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mʉlʉʉngʉ atoola Miiro kwa mʉkono wa Mʉ́sa, maa kaa, nduwo na kɨmáárɨ vyʉʉja ko tweera YéesuKirisitʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kusiina mʉʉntʉ yoyoosi ˆamoona Mʉlʉʉngʉ mpɨɨndɨ yoyoosi tʉkʉ. Maa kaa, Mwaana waachwe wa mpeke, yeeye nɨ Mʉlʉʉngʉ, na yeeye nɨ hamwɨ arɨ na Taáta, yeeye noo atʉkʉnʉkʉrɨra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sikʉ ɨmwɨ, vakʉ́ʉ́lʉ va Vayahúudi vajáa vatʉma veeneɨsɨ va Ijʉva na Valáawi fuma Yerusaléemu, vadome na kwa Yooháani vamuurye oonekye yeeye nɨ ani. Na ʉkʉ noo kwiiyoonekya kwaachwe. ");
INSERT INTO lag_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yooháani alʉʉsa baa siita tʉkʉ, yoosea, “Nɨɨnɨ sɨ ndɨrɨ Masía tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Vakamuurya voosea, “Ha weewe ʉrɨ ani? Eri, weewe ʉrɨ Elíamʉláali na mʉtwe wʉʉ?” Yooháani akavasea, “Tʉkʉ, nɨɨnɨ sɨ ndɨrɨ Elía tʉkʉ.” Vakamuurya kei, “Weewe noo ʉra mʉláali na mʉtwe wʉʉ?” Yooháani akavasea, “Tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aho, maa vakamʉsea, “Haaha tʉwyɨɨre weewe ʉrɨ ani, sa tʉvatwaarɨre mʉlomo vara ˆvatutúmire. Ha weewe nɨ joolɨ wiiséaa?” ");
INSERT INTO lag_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Maa Yooháani akavasea, “Nɨɨnɨ noo ʉra ˆalʉʉswa nɨ Isáaya mʉláali na mʉtwe yoosea, ‘Nɨɨnɨ nɨ sawúti ya mʉʉntʉ ˆyookaanɨrɨra vikʉlʉkʉʉlʉ ɨsɨ ya ibaláángwii, “Wololi njɨra ya Ijʉva.”’” ");
INSERT INTO lag_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na avo vaantʉ vajáa vatúmirwe fuma kwa Mafarisáayo. ");
INSERT INTO lag_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aho, vakamuurya, “Koonɨ weewe sɨ ʉrɨ Masía, au Elía au ʉra mʉláali na mʉtwe, haaha sa che woobatisa?” ");
INSERT INTO lag_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yooháani akavasea, “Nɨɨnɨ noobatisa na maaji, maa kaa, katɨ na katɨ yaanyu amwaarɨ sɨ mʉmʉmányire. ");
INSERT INTO lag_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ʉwo noo ʉra ˆyookʉʉja nyuma yaanɨ. Ʉwo nɨɨnɨ sɨ nɨɨma neeja kʉtʉmama mʉrɨmo wa mʉtʉ́mwa wo reherya nkova ja mirunkumo yaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Masáare aya yoosi yafʉmɨra ʉko múujii wa Besanía, fɨrɨro ya lʉʉjɨ lwa Yorodáani, kʉʉntʉ Yooháani ˆabatisáa. ");
INSERT INTO lag_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lomʉtóondo yaachwe, Yooháani akamoona Yéesu yookʉʉja na kwaachwe. Aho, akavasea vaantʉ, “Ʉhʉ noo mpóryo ya Mwaana wa Muundi wa Mʉlʉʉngʉ. Yeeye noo ˆyooseyya ʉvɨ wa weerʉ! ");
INSERT INTO lag_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ʉhʉ noo ʉra ˆnavawyɨɨra masáare yaachwe ˆnkavasee, ‘Amwaarɨ ˆyookʉʉja nyuma yaanɨ, yeeye nɨ mʉkʉʉlʉ kʉʉndookya, yeeye ajáa amwaarɨ nɨɨnɨ sɨ nɨnavyaalwa.’ ");
INSERT INTO lag_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nɨɨnɨ mweeneevyo sɨ nɨjáa namʉmányire tʉkʉ, maa kaa, nʉʉja noobatisa vaantʉ na maaji sa vaantʉ va Isiraéeli vamʉtaange.” ");
INSERT INTO lag_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Aho, maa Yooháani akoonekya masáare ya ɨkɨ kɨkomi yoosea, “Namoona Mʉtɨma Mʉʉja yookiima fuma kurumwii ja nkúnde, akiikala mweeri yaachwe. ");
INSERT INTO lag_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nɨɨnɨ sɨ namʉtaanga tʉkʉ. Maa kaa, Mʉlʉʉngʉ yeeye ˆaantʉma mbatise na maaji, yeeye aansea, ‘Mʉʉntʉ ʉra ˆʉrɨ koona Mʉtɨma Mʉʉja yookiima fuma kurumwii noo kiikala mweeri yaachwe, ʉwo noo ˆɨɨndoobatisa kwa Mʉtɨma Mʉʉja.’ ");
INSERT INTO lag_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nɨɨnɨ mweeneevyo noona isáare ɨrɨ, na nɨ lʉʉsa niise kɨkomi, ʉhʉ noo Mwaana wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lomʉtóondo yaachwe, Yooháani Mʉbatisáaji ajáa amwaarɨ aho haantʉ, hamwɨ na vavɨrɨ va vapooji vaachwe kei. ");
INSERT INTO lag_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ˆAkamoone Yéesu yoolooka na aho, maa akasea, “Laangi, mpóryo ya Mwaana wa Muundi ya Mʉlʉʉngʉ!” ");
INSERT INTO lag_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Vara vapooji vavɨrɨ ˆvakateere Yooháani Mʉbatisáaji yoosea jeyyo, vakamutuuba Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yéesu akiilorera, ˆakavoone voomutuuba, maa akavuurya, “Nɨ che moosaakɨra?” Maa vakamʉsea, “Ráabi,” noo kʉsea, Mukiindya, “Nɨ hai ˆwiíkalaa?” ");
INSERT INTO lag_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yéesu akavasea, “Yeendi, na nyuunyu kʉhoona mʉrɨ.” Jeyyo, avo vapooji vakamutuuba Yéesu, vakoona haantʉ ˆiikaláa. Sikʉ ɨra vakava ne. Jijáa nɨ mpɨɨndɨ ja kyʉʉlwa. ");
INSERT INTO lag_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anderéa mwaanaavo na Simóoni Peéteri, nɨ ʉmwɨ wa vara vavɨrɨ ˆvajáa vateera vira Yooháani ˆajáa alúusire, ne akamutuuba Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kɨɨntʉ cha ncholo ˆatʉmama Anderéa, nɨ kʉmʉloonda Simóoni mwaanaavo, akamʉsea, “Tamwɨɨ́ne Masía,” noo kʉsea Kirisitʉ. ");
INSERT INTO lag_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aho, Anderéa akamʉtwaala Simóoni na kwa Yéesu. Yéesu akamʉlaanga Simóoni, maa akamʉsea, “Weewe Simóoni mwaana wa Yooháani, maa kaa, kwaandɨra haaha nɨ Kéefa ʉkaánɨrɨrwaa.” Irina ɨrɨ na Kɨgiríki nɨ Peéteri. ");
INSERT INTO lag_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lomʉtóondo yaachwe, Yéesu akalamʉla kʉdoma na ɨsɨ ya Galiláaya. Akamʉshaana Filíipi, maa akamʉsea, “Ntuuba.” ");
INSERT INTO lag_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filíipi nɨ mʉʉntʉ fuma múuji wa Besaída ajáa, múuji haantʉ Anderéa na Peéteri ˆvafuma. ");
INSERT INTO lag_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filíipi ne akamʉshaana Nasaniéeli, na akamʉsea, “Tamwɨɨ́ne ʉra Mʉ́sa ˆaandɨka masáare yaachwe Kɨtáabwii cha Miiro, na ʉwo baa valáali na mʉtwe ˆvaandɨka masáare yaachwe noo kʉsea, Yéesu wa Nasaréeti, mwaana wa Yooséefu.” ");
INSERT INTO lag_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aho, maa Nasaniéeli akamuurya, “Eri, kwatɨɨte kɨɨntʉ kiija ˆkɨrɨ fuma iturii ra Nasaréeti wʉʉ?” Filíipi akamʉsea, “Yeenda jɨ woone.” ");
INSERT INTO lag_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kamʉsaambo, Yéesu ˆakamoone Nasaniéeli yookʉʉja, maa akalʉʉsa sáare ja Nasaniéeli yoosea, “Laangi, ʉhʉ nɨ Mwiisiraéeli wa kɨkomi, asiina ʉvaangʉ isii yaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nasaniéeli akamuurya Yéesu, “Joolɨ wʉʉntáangire?” Yéesu akamʉsea, “Baa Filíipi viintʉ ˆaarɨ akaarɨ kwaanɨrɨra, nɨɨnɨ naarɨ nakwɨɨ́ne wiikyɨ́ɨre nchinii ya mʉsaambu.” ");
INSERT INTO lag_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nasaniéeli akamʉsea, “Mukiindya, weewe nɨ Mwaana wa Mʉlʉʉngʉ! Weewe nɨ Mʉtemi wa Isiraéeli!” ");
INSERT INTO lag_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yéesu akamʉsea, “Weewe warúmire sa viintʉ ˆnakʉséire, nakwɨɨ́ne viintʉ ˆwaarɨ ʉkaarɨ wiikyɨ́ɨre nchinii ya mʉsaambu. Koona ʉrɨ masáare makʉʉlʉ kʉlookya ayo.” ");
INSERT INTO lag_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yéesu akasea, “Kɨmaarɨ kaa noovawyɨɨra, koona mʉrɨ kurumu koochʉngʉlʉka, na mirimʉ ya Mʉlʉʉngʉ yookaambʉka no kiima mweeri ya Mwaana wa Mʉʉntʉ.” ");
INSERT INTO lag_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sikʉ ya katatʉ, kʉjáa kwatɨɨte ngovi ya ilóola múujii wa Káana ˆʉrɨ ɨsɨ ya Galiláaya. Aho ngovii, íyo waala Yéesu ajáa amwaarɨ. ");
INSERT INTO lag_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yéesu na vapooji vaachwe novo vajáa valáarikirwe aho ngovii. ");
INSERT INTO lag_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Diváai ˆɨkasire, íyo waavo akamʉsea Yéesu, “Vasɨ́rɨɨrwe nɨ diváai.” ");
INSERT INTO lag_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yéesu akamʉsea íyo waavo, “Íyo, sa che wookuungwyɨɨra ayo? Mpɨɨndɨ yaanɨ yo tʉmama sɨ ɨnafika tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aho, maa íyo waavo akavasea vara vatʉmami va aho ngovii, “Chochoosi ˆarɨ vasea, kɨtʉmami.” ");
INSERT INTO lag_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aho, kʉjáa kwatɨɨte sʉvɨya mʉsasatʉ ja mawye ˆyasongolwa. Ijo sʉvɨya, jɨɨ́ngɨraa ja madúumu yasaano au mʉsasatʉ. Jijáa javíikirwe aho, so vɨkɨra maaji yo seyyirya njeo, ja ˆvyeene tʉʉva ja Vayahúudi jalʉʉsa. ");
INSERT INTO lag_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yéesu akavasea vara vatʉmami, “Memyi ijo sʉvɨya maaji.” Avo vatʉmami vakamemya ijo sʉvɨya fʉʉrʉ ʉkeenkii. ");
INSERT INTO lag_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aho, Yéesu akavasea, “Haaha, tahi ayo maaji kiduudi, mʉmʉtwaarɨre mwiimiriri wa ɨhɨ ngovi.” Vatʉmami vakataha, maa vakamʉtwaarɨra. ");
INSERT INTO lag_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mwiimiriri ˆakasaɨre yara maaji, kʉmba yaválandʉkɨre yakava diváai. Ʉwo mwiimiriri sɨ ataanga ɨyo diváai nɨ hai ˆɨjáa ifúmire tʉkʉ. Maa kaa, vara vatʉmami ˆvajáa vatáire, vajáa vatáangire. Aho, ʉra mwiimiriri akamwaanɨrɨra mweenengovi, ");
INSERT INTO lag_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","maa akamʉsea, “Kɨra mʉʉntʉ alóongoryaa ta ɨra diváai ˆyaboohabooha, na vaantʉ ˆvarɨ kiikuta de akareeta ɨra ɨrɨ ferefere. Maa kaa, weewe wachíhiirye diváai ˆyabooha fʉʉrʉ haaha.” ");
INSERT INTO lag_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ɨhɨ noo isháara ya ncholo Yéesu ˆabweeyya ʉko múujii wa Káana ˆʉrɨ ɨsɨ ya Galiláaya. Jeyyo, Yéesu akoonekya nkongojima yaachwe, na vapooji vaachwe vakamuruma. ");
INSERT INTO lag_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ayo ˆyakalooke, Yéesu, íyo waavo, vandʉʉ vaachwe na vapooji vaachwe vakagirita na múujii wa Kaperenáumu. Ʉko vakiikala sikʉ ɨnke. ");
INSERT INTO lag_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ngovi ya Paásika ya Vayahúudi ɨjáa yaséngerɨɨre, Yéesu akaambʉka na múujii wa Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ʉko, akɨɨngɨra waámii ya Kaaya Njija ya Ijʉva, akavashaana vaantʉ voovaa iyoombe ngʼoombe, muundi na njɨva. Na vɨɨngɨ vajáa viíkyɨɨre méesii, vookaasakanʼya mpía. ");
INSERT INTO lag_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yéesu akalʉka mʉréesa wa ludihi, akavakibirya voosi fuma waámii ya Kaaya Njija, hamwɨ na muundi na ngʼoombe jaavo. Akakʉndʉla méesa ja vara ˆvaasakanʼyáa mpía na akamyaaha mpía jaavo. ");
INSERT INTO lag_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aho, Yéesu akavasea vara ˆvaváa iyoombe njɨva, “Seyyi njɨva jaanyu aha! Kɨɨbweeyyi nyuumba ya Taáta waanɨ ja haantʉ ho vaɨra iyoombe viintʉ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Vapooji vaachwe vakakʉmbʉkɨra Masáare ˆYarɨ Mpeho ja ˆvyeene yalʉʉsa, “Kweenda kwaanɨ nyuumba yaako, kʉʉnjʉlaa kʉrɨ.” ");
INSERT INTO lag_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Vamwɨ va Vayahúudi vakamuurya, “Nɨ isháara che ʉrɨ tʉlaɨra sa woonekye kɨkomi ʉtɨɨte wiimiriri wo tʉmama aya?” ");
INSERT INTO lag_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yéesu akavasea, “Vai ɨhɨ Kaaya Njija, na nɨɨnɨ kɨɨjeenga ndɨrɨ kwa sikʉ itatʉ.” ");
INSERT INTO lag_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aho, Vayahúudi vakamʉsea, “Ɨhɨ Kaaya Njija yajeengwa kwa myaaka makumi yanɨ na mʉsasatʉ (46). Atɨ, weewe kɨɨjeenga ʉrɨ kwa sikʉ itatʉ?” ");
INSERT INTO lag_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Maa kaa, kaaya Yéesu ˆalʉʉsáa nɨ mʉvɨrɨ waachwe. ");
INSERT INTO lag_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ˆAkafʉfʉke, vapooji vaachwe vakakʉmbʉkɨra yara ˆajáa alʉʉsa. Aho, vakaruma Masáare ˆYarɨ Mpeho na yara masáare ˆajáa alʉʉsa Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mpɨɨndɨ Yéesu ˆajáa Yerusaléemu ngovii ya Paásika, vaantʉ ˆvarɨ foo ˆvakoone isháara na myuujíisa ˆabweeyyáa, maa vakamuruma. ");
INSERT INTO lag_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Maa kaa, Yéesu sɨ iiviikya kwa vaantʉ tʉkʉ, sa amányire yoosi ˆyarɨ mutimii wa mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yeeye sɨ ajáa mpaka oonekiwe vira ˆvyeene vaantʉ varɨ tʉkʉ, sa yeeye ajáa amányire yoosi ˆyarɨ mutimii wa mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ wa mpuka ya Mafarisáayo, irina raachwe Nikodéemu. Yeeye nɨ ʉmwɨ wa vakʉ́ʉ́lʉ va Vayahúudi ajáa. ");
INSERT INTO lag_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sikʉ ɨmwɨ nuuchikʉ, Nikodéemu akadoma na kʉrɨ Yéesu, maa akamʉsea, “Mukiindya, tamányire weewe watʉmwa nɨ Mʉlʉʉngʉ, sa kusiina mʉʉntʉ ˆarɨ daha tʉmama isháara na myuujíisa ɨhɨ ˆwootʉmama tʉkʉ, koonɨ Mʉlʉʉngʉ sɨ arɨ ne.” ");
INSERT INTO lag_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yéesu akamʉsea, “Kɨmaarɨ kaa nookuwyɨɨra, kusiina mʉʉntʉ ˆarɨ koona Ʉtemi wa Mʉlʉʉngʉ tʉkʉ koonɨ sɨ avyɨ́ɨrwe lwa kavɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodéemu akamuurya, “Joolɨ mʉʉntʉ arɨ daha vyaalwa lwa kavɨrɨ na kʉnʉ avɨ́ɨre moosi? Sɨ viri dahɨka tʉkʉ ahɨndʉke na indii ya íyo waavo, sa avyaalwe kei.” ");
INSERT INTO lag_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yéesu akamʉsea, “Kɨmaarɨ kaa nookuwyɨɨra, kusiina mʉʉntʉ ˆarɨ kɨɨngɨra Ʉtemii wa Mʉlʉʉngʉ tʉkʉ, koonɨ sɨ avyɨ́ɨrwe kwa maaji na kwa Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mʉʉntʉ avyáalwaa kɨmʉvɨrɨ kwa taáta na íyo waavo, maa kaa, mʉtɨma mufya wavyáalwaa kwa Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hwaalala tʉkʉ sa viintʉ ˆnookʉsea, nɨ mpaka uvyaalwe lwa kavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mpeho yafwɨ́ɨraa na kʉʉntʉ ˆyoosaaka. Teera ʉrɨ viintʉ ˆyoofwɨɨra, maa kaa, sɨ ʉrɨ taanga kʉʉntʉ ˆyoofuma na kʉʉntʉ ˆyoodoma tʉkʉ. Noo ˆvyeene viri kwa kɨra mʉʉntʉ ˆavyaalwa nɨ Mʉtɨma Mʉʉja.” ");
INSERT INTO lag_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aho, Nikodéemu akamuurya Yéesu, “Aya masáare joolɨ yarɨ dahɨka?” ");
INSERT INTO lag_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yéesu akamʉsea, “Weewe ʉrɨ mukiindya ˆʉnyémiwaa maatʉkʉ vii kʉrɨ ɨhɨ ɨsɨ ya Isiraéeli, joolɨ sɨ ʉmányire masáare aya? ");
INSERT INTO lag_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kɨmaarɨ kaa nookuwyɨɨra, suusu toolʉʉsa yara ˆtʉyamányire na tookoonekya kɨmáárɨ cha yara ˆtoona. Maa kaa, nyuunyu sɨ mooruma kɨra ˆtookoonekya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Navawyɨ́ɨrɨɨre viintʉ ˆvitʉ́mamwaa aha weerwii, maa kaa, nyuunyu sɨ mooruma tʉkʉ. Haaha joolɨ mʉrɨ kuunduma koonɨ navawyɨ́ɨrɨɨre viintʉ ˆvitʉ́mamwaa kurumwii? ");
INSERT INTO lag_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kusiina mʉʉntʉ ˆaambʉka na kurumwii tʉkʉ. Nɨ Mwaana wa Mʉʉntʉ vii, yeeye akiima fuma kurumwii. ");
INSERT INTO lag_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ja ˆvyeene Mʉ́sa ajáa iinurirya ɨra njoka ya chʉʉ́ma cha sháaba kʉra ɨsɨ ya ibaláángwii, viivyo nɨ mpaka Mwaana wa Mʉʉntʉ iinuririwe na mweeri, ");
INSERT INTO lag_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","sa kɨra mʉʉntʉ ˆarɨ muruma, ave na nkaasʉ ya sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sa viintʉ Mʉlʉʉngʉ ˆeenda weerʉ mʉnʉmʉʉnʉ, amʉtoola Mwaana waachwe wa mpeke Yéesu, na kɨra mʉʉntʉ ˆarɨ muruma Yéesu sɨ arɨ malwa tʉkʉ, maa kaa, kʉva arɨ na nkaasʉ ya sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mʉlʉʉngʉ sɨ amʉtʉma Mwaana waachwe sa jɨ alʉʉse irya kwa weerʉ tʉkʉ, maa kaa, ko tweera yeeye weerʉ ɨlamuririwe. ");
INSERT INTO lag_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yoyoosi ˆamuruma Mwaana sɨ arɨ heewa irya tʉkʉ. Maa kaa, ʉra sɨ ˆamuruma ahʉmʉla heewa irya, sa asiita kumuruma Mwaana wa mpeke wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na ʉhʉ noo ʉlamu, kɨweerʉ chʉʉja kʉrɨ weerʉ, kɨrɨ vyoova jeyyo, vaantʉ veenda kilwiirya, kʉlookya kɨweerʉ, sa nteendo jaavo nɨ mbɨ. ");
INSERT INTO lag_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kɨra mʉʉntʉ ˆatʉ́mamaa ʉvɨ, asʉʉla kɨweerʉ. Sɨ asáakaa kʉʉja na kɨweerwii tʉkʉ, sa nteendo jaachwe mbɨ jo taangwa jiri. ");
INSERT INTO lag_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Maa kaa, ʉra ˆakwáatyaa kɨmáárɨ, ʉʉja na kɨweerwii, sa masáare yaachwe yataangɨkane ˆyatʉ́mwamwaa kwa ngururu ja Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aya ˆyakalooke, Yéesu na vapooji vaachwe vakatamanya fʉʉrʉ ɨsɨ ya Yudéea. Novo vakiikala ʉko kwa mpɨɨndɨ sa vabatisáa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yooháani ne abatisáa vaantʉ ʉko iturii ra Ainóoni, ˆrɨrɨ heehi na múuji wa Saléemu, sa ʉko kʉjáa kwatɨɨte maaji ˆyarɨ foo. Vaantʉ vʉʉjáa na kwaachwe, sa avabatise. ");
INSERT INTO lag_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mpɨɨndɨ ijo, Yooháani ajáa akaarɨ sɨ anavɨɨkwa mʉnyololwii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sikʉ ɨmwɨ, vapooji va Yooháani vajáa vaanda kiiruta ndihi na Mʉyahúudi ʉmwɨ. Kɨɨntʉ ˆviirʉtɨráa ndihi, nɨ tʉʉva jo kiijirʉla. ");
INSERT INTO lag_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Vakatamanya na kwa Yooháani, maa vakamʉsea, “Mukiindya, mʉkʉmbʉkɨra wiise ʉra mʉʉntʉ ˆajáa hamwɨ na weewe fɨrɨro ya lʉʉjɨ lwa Yorodáani, ʉra ˆwatoonekya masáare yaachwe ya kɨkomi. Haaha yoobatisa, na kɨra mʉʉntʉ yoodoma na kwaachwe.” ");
INSERT INTO lag_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yooháani akavasea, “Kusiina mʉʉntʉ arɨ ˆturya kɨɨntʉ chochoosi tʉkʉ, koonɨ Mʉlʉʉngʉ sɨ amʉhɨ́ɨre kurumwii. ");
INSERT INTO lag_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nyuunyu veeneevyo daha mʉrɨ koonekya kɨmaarɨ, nɨɨnɨ navawyɨɨra, ‘Nɨɨnɨ sɨ ndɨrɨ Masía tʉkʉ, maa kaa, natʉmwa sa nɨmʉlongorere.’ ");
INSERT INTO lag_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mʉʉntʉ muki ˆalóorirwe, nɨ wa mʉlʉme waachwe. Maa kaa, mʉʉntʉ mʉlʉme kɨjeengi ʉra ˆɨɨ́maa ivarwii ra mʉlóoli de ɨndooteera kɨra mʉlóoli ˆyoolʉʉsa, avyeéndaa maatʉkʉ vii ˆarɨ teera sawúti ya mʉlóoli. Sa ɨkɨ, kʉvyeenda kwaanɨ kwakíimɨɨne. ");
INSERT INTO lag_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yoosaakwa yeeye ave mʉkʉʉlʉ kʉlookya, na nɨɨnɨ nɨve muduudiduudi.” ");
INSERT INTO lag_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yeeye ˆafuma mweeri, nɨ mweeri arɨ ya vaantʉ voosi. Mʉʉntʉ yoyoosi ˆafuma kʉrɨ weerʉ, nɨ wa weerʉ, na masáare ˆalʉ́ʉsaa nɨ ya weerʉ. Maa kaa, ʉra ˆafuma kurumwii, nɨ mweeri ya vaantʉ voosi arɨ. ");
INSERT INTO lag_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yeeye oónekyaa yara ˆoona na ˆayateera, maa kaa, kusiina mʉʉntʉ ˆyooruma kɨra ˆyookoonekya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ʉra ˆyooruma ayo masáare ˆyoolʉʉsa, koonekya iise kɨweerwii Mʉlʉʉngʉ nɨ kɨkomi. ");
INSERT INTO lag_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yeeye atʉmwa nɨ Mʉlʉʉngʉ. Alʉ́ʉsaa masáare ya Mʉlʉʉngʉ, sa Mʉlʉʉngʉ amʉheera Mʉtɨma Mʉʉja baa yerenʼya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taáta amweenda Mwaana, na avɨɨka viintʉ vyoosi mɨkonwii yaachwe. ");
INSERT INTO lag_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mʉʉntʉ yoyoosi ˆamuruma Mwaana wa Mʉlʉʉngʉ, atɨɨte nkaasʉ ya sikʉ ˆjisiina ʉhero. Maa kaa, mʉʉntʉ yoyoosi ʉra ˆamusíitaa Mwaana, ʉwo asiina nkaasʉ ya sikʉ ˆjisiina ʉhero tʉkʉ, kʉrɨ yeeye nkalari ya Mʉlʉʉngʉ chaala ɨrɨ ne. ");
INSERT INTO lag_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Haaha, Mafarisáayo vajáa vateera Yéesu yooturya no batisa vapooji ˆvarɨ foo kʉlookya va Yooháani. ");
INSERT INTO lag_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Maa kaa, kɨmaarɨ Yéesu sɨ abatisáa tʉkʉ, vapooji vaachwe noo vabatisáa. ");
INSERT INTO lag_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yéesu ˆakateere masáare aya, akiinʉka fuma Yudéea, akahɨndʉka na Galiláaya. ");
INSERT INTO lag_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Haaha, ɨkava nɨ mpaka atweere na ɨsɨ ya Samaría. ");
INSERT INTO lag_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ʉko, akafika múuji ʉmwɨ wa Samaría ˆʉséwaa Sikáari. Ʉwo múuji nɨ heehi ʉjáa na iwʉnda Yaakúupu ˆajáa amʉheera Yooséefu mwaana waachwe. ");
INSERT INTO lag_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Aho, kʉjáa kwatɨɨte isima Yaakúupu ˆajáa asiimba. Yéesu akiikala mbarɨmbarɨ ya rɨra isima, sa ajáa akátɨɨre sa lʉyeendo lʉlɨɨhɨ. Mpɨɨndɨ ijo, nɨ mpɨɨndɨ ja mpoloonge jijáa. ");
INSERT INTO lag_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Aho, akʉʉja mʉʉntʉ muki ʉmwɨ Mʉsamaría noo taha maaji. Yéesu akamʉsea, “Nooloomba maaji yo nywa.” ");
INSERT INTO lag_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mpɨɨndɨ ijo, vapooji vaachwe vajáa vatámiinye na múujii no wʉla chóorya. ");
INSERT INTO lag_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ʉra mʉʉntʉ muki Mʉsamaría akamʉsea Yéesu, “Weewe ʉrɨ Mʉyahúudi na nɨɨnɨ ndɨrɨ Mʉsamaría. Haaha joolɨ ʉrɨ kʉʉnoomba nɨɨnɨ maaji yo nywa?” Ʉwo mʉʉntʉ muki alʉʉsa jeyyo, sa Vayahúudi na Vasamaría sɨ vasaangɨrɨráa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yéesu akamʉsea, “Ngaarɨ wootaanga kɨlʉngʉlʉngʉ cha Mʉlʉʉngʉ, na nɨ ani ˆyookʉloomba maaji yo nywa, ngaarɨ wʉʉnóombire, naanɨ ngaarɨ nakʉhɨ́ɨre maaji ya nkaasʉ.” ");
INSERT INTO lag_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ʉra mʉʉntʉ muki akamʉsea Yéesu, “Aaɨ, weewe usiina kɨɨntʉ cho tahɨrɨra maaji tʉkʉ na ɨrɨ isima nɨ ilɨ́ɨ́hɨ. Ayo maaji ya nkaasʉ hai ʉrɨ yaturirya? ");
INSERT INTO lag_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Eri, weewe ʉrɨ mʉkʉʉlʉ kʉlookya baaba wiitʉ Yaakúupu wʉʉ? Yeeye atʉheera isima ɨrɨ. Isima ɨrɨ noo ˆanywijáa maaji yaachwe, yeeye, vaana vaachwe na nchúwo jaachwe.” ");
INSERT INTO lag_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yéesu akamʉsea, “Kɨra mʉʉntʉ ˆanywíjaa maaji ya isima ɨrɨ, oónaa nyóota kei. ");
INSERT INTO lag_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Maa kaa, yoyoosi ˆarɨ kʉnywa maaji ˆndɨrɨ mʉheera nɨɨnɨ, sɨ arɨ koona nyóota kei vii kaa tʉkʉ. Maaji ˆndɨrɨ mʉheera, kʉrɨ yeeye kʉva yarɨ nchóonko sɨ ˆyʉʉ́maa ya maaji ya nkaasʉ ya sikʉ ˆjisiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ʉra mʉʉntʉ muki akamʉsea Yéesu, “Aaɨ taáta, kalaama mpeera ayo maaji ndɨɨre koona nyóota kei, na ndeke kʉʉja noo taha maaji aha isimii!” ");
INSERT INTO lag_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yéesu akamʉsea, “Tamanya ʉkamwaanɨrɨre mʉlʉme waako wʉʉje ne na aha.” ");
INSERT INTO lag_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ʉra mʉʉntʉ muki akamʉsea, “Nsiina mʉlʉme tʉkʉ.” Yéesu akamʉsea, “Ulúusire kɨmáárɨ, usiina mʉlʉme tʉkʉ! ");
INSERT INTO lag_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sa waava na valʉme vasaano na ʉhʉ ˆʉrɨ ne haaha, sɨ mʉlʉme waako tʉkʉ. Ulúusire kɨmáárɨ.” ");
INSERT INTO lag_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ʉra mʉʉntʉ muki akamʉsea, “Aaɨ, nookoona weewe ʉrɨ mʉláali na mʉtwe! ");
INSERT INTO lag_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Vala baaba wiitʉ vamwiinamɨráa Mʉlʉʉngʉ ncholwii ya ʉlʉ lʉʉlʉ. Maa kaa, nyuunyu Vayahúudi mʉndoosea, nɨ ʉko Yerusaléemu vii noo haantʉ ho mwiinamɨra Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aho, Yéesu akamʉsea ʉra mʉʉntʉ muki, “Maáma, nduma nɨɨnɨ. Mpɨɨndɨ kʉʉja jiri, sɨ mʉkamwiinamɨraa Mʉlʉʉngʉ Taáta mweeri ya ʉlʉ lʉʉlʉ tʉkʉ, baa kʉra Yerusaléemu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyuunyu Vasamaría mwamwiínamɨraa ʉra sɨ ˆmwamʉmányire. Suusu Vayahúudi tamwiínamɨraa Mʉlʉʉngʉ ˆtamʉmányire, sa ʉlamuriri nɨ kwa Vayahúudi woofuma. ");
INSERT INTO lag_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Maa kaa, mpɨɨndɨ kʉʉja jiise, na kɨkomi jafíkire. Vaantʉ ˆvasáakaa mwiinamɨra Mʉlʉʉngʉ Taáta kɨmaarɨ, mwiinamɨra varɨ Taáta kwa kɨmáárɨ na kwa mʉtɨma. Vaantʉ ˆvamwiínamɨraa jeyyo noo Taáta yoosaaka. ");
INSERT INTO lag_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mʉlʉʉngʉ nɨ Mʉtɨma, na voosi ˆvamwiínamɨraa, nɨ mpaka vamwiinamɨre kwa mʉtɨma na kɨkomi.” ");
INSERT INTO lag_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ʉra mʉʉntʉ muki akamʉsea Yéesu, “Namányire kʉʉja iise Masía ˆaséwaa Kirisitʉ. Na ˆarɨ kʉʉja, tʉvariyʉrɨra arɨ masáare yoosi.” ");
INSERT INTO lag_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yéesu akamʉsea ʉra mʉʉntʉ muki, “Nɨɨnɨ noolʉʉsɨka na weewe, noo yeeye.” ");
INSERT INTO lag_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aho, vapooji vaachwe vakahɨndʉka. Vakahwaalala maatʉkʉ kʉshaana Yéesu yoolʉʉsɨka na mʉʉntʉ muki. Maa kaa, kusiina mʉʉntʉ ˆuurya, “Che woosaaka kwaachwe?” tʉkʉ, au “Sa che woolʉʉsɨka ne?” tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ʉra mʉʉntʉ muki akareka sʉvɨya yaachwe hara isimii, akahɨndʉka na múujii. Ʉko akavasea vaantʉ, ");
INSERT INTO lag_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Hendi mʉkamoone mʉʉntʉ ˆaangwyɨ́ɨrɨɨre masáare yoosi ˆnawaayya tʉmama! Eri, ifaanaa ɨkava ʉhʉ noo Masía wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Vaantʉ vakafuma múujii mayɨɨmbɨ na mayɨɨmbɨ, vakava voodoma na kʉʉntʉ Yéesu ˆajáa. ");
INSERT INTO lag_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","De vaantʉ vafike, vapooji vaachwe vajáa vamʉloomba voosea, “Mukiindya, hoonɨ irya chóorya.” ");
INSERT INTO lag_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Maa kaa, yeeye akavasea, “Nɨɨnɨ natɨɨte chóorya ˆcheene nyuunyu sɨ mʉkɨmányire.” ");
INSERT INTO lag_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aho, vapooji vaachwe vakaanda kiiyurya, “Eri, kwatɨɨte mʉʉntʉ ˆamʉréetire chóorya viintʉ ˆtwaarɨ tusiina wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yéesu akavasea, “Chóorya chaanɨ nɨ kʉtʉmama kɨra Mʉlʉʉngʉ ˆeenda, yeeye aantʉma nkiimikirirye mʉrɨmo waachwe. ");
INSERT INTO lag_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Eri, nyuunyu sɨ moosea, ‘Ɨkaarɨ myeeri ɨne vii, kuchwa tʉrɨ!’ Maa kaa, nɨɨnɨ nɨ kʉvawyɨɨra niise, laangi ˆvyeene mawʉnda yarɨ. Viintʉ vyo chwa vyahʉ́mwɨɨre, nɨ vyo chwa vii! ");
INSERT INTO lag_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Muchwi ahʉ́mwɨɨre hokera mʉsáala waachwe, na nɨ saankanʼya iise viryo, sa nkaasʉ ya sikʉ ˆjisiina ʉhero. Aho, ʉra ˆahaanda na ʉra ˆaachwa vyeenda varɨ. ");
INSERT INTO lag_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jeyyo ɨra mpɨ́rɨ ˆyasea, ‘Ʉmwɨ aháandaa na wɨɨngɨ achwíjaa,’ nɨ ya kɨkomi. ");
INSERT INTO lag_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Navatʉma mʉkachwe viintʉ sɨ ˆmwafʉmɨra irʉtɨra. Vaantʉ vɨɨngɨ vatʉmama mʉrɨmo woosi muruto, maa kaa, nyuunyu mooturya kʉnáálo ya uturikiri waavo.” ");
INSERT INTO lag_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vasamaría ˆvarɨ foo va ʉwo múuji wa Sikáari, vakamuruma Yéesu, sa vajáa vateera ˆvyeene ʉra mʉʉntʉ muki ajáa oonekya kɨkomi yoosea, “Mʉʉntʉ ʉhʉ aangwyɨ́ɨrɨɨre yoosi ˆmeene nawaayya tʉmama.” ");
INSERT INTO lag_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Aho, vara Vasamaría ˆvakafike kʉrɨ Yéesu, vakamʉkalaamya achaale aho meevo, ne akiikala novo kwa sikʉ ivɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Vasamaría ˆvarɨ foo vakamuruma sa yara ˆmeene alʉʉsáa. ");
INSERT INTO lag_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vara vaantʉ vakamʉsea ʉra mʉʉntʉ muki, “Tamurúmire mʉʉntʉ ʉhʉ, sɨ sa masáare yaako vii ˆʉtʉwyɨ́ɨrɨɨre tʉkʉ, suusu veeneevyo tatéɨɨre ˆcheene yoolʉʉsa. Kei tatáangire kɨkomi mʉʉntʉ ʉhʉ nɨ Mʉlamuriri wa weerʉ.” ");
INSERT INTO lag_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sikʉ ivɨrɨ ˆjikalooke, Yéesu akiinʉka fuma Sikáari akatamanya na ɨsɨ ya Galiláaya. ");
INSERT INTO lag_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na Yéesu ajáa avaséire vapooji vaachwe, “Mʉláali na mʉtwe wa Ijʉva sɨ anyémiwaa nɨ vaantʉ va ɨsɨ ya yaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ˆAkafike Galiláaya, vaantʉ va Galiláaya vakamʉteengya vyabooha. Vamʉteengya sa mpɨɨndɨ ˆvajáa ʉko ngovi ya Paásika kʉra Yerusaléemu, vajáa voona yoosi ˆmeene Yéesu atʉmamáa. ");
INSERT INTO lag_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yéesu akatamanya kei na múujii wa Káana ˆʉrɨ ɨsɨ ya Galiláaya. Aho múujii, noo haantʉ ˆajáa abweeyya maaji yakava diváai. Ʉko Kaperenáumu, kʉjáa kwatɨɨte mʉkʉ́ʉ́lʉ ʉmwɨ wa ɨsɨ. Ʉwo ajáa na mʉtavana waachwe mʉlwɨ́ɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Haaha ʉwo mʉkʉ́ʉ́lʉ ˆakateere Yéesu uújire na Galiláaya fuma Yudéea, akatamanya na kʉrɨ Yéesu, maa akamʉkalaamya vatamanyanʼye na Kaperenáumu, sa akamʉhorye musinga waachwe ˆajáa alwɨ́ɨre sengerera kukwya. ");
INSERT INTO lag_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aho, Yéesu akamʉsea, “Eri, sɨ mʉrɨ kuunduma vii tʉkʉ koonɨ sɨ mwɨɨ́ne isháara na viintʉ ˆvihwáalaryaa wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ʉra mʉkʉ́ʉ́lʉ akamʉsea Yéesu, “Aaɨ kalaama, hende tugiritanʼye musinga waanɨ viintʉ ˆakaarɨ sɨ anaakwya.” ");
INSERT INTO lag_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aho, Yéesu akamʉsea, “Tamanya na kaayii, mwaana waako ahórire.” Ʉra mʉkʉ́ʉ́lʉ akaruma masáare ya Yéesu, maa akahɨndʉka na kaayii kwaachwe. ");
INSERT INTO lag_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Viintʉ ˆajáa akaarɨ njirii, akalʉmana na vatʉmami vaachwe vakamʉsea, “Musinga ahoriré ndwáala yaachwe.” ");
INSERT INTO lag_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jeyyo, akavuurya mpɨɨndɨ ndwáala yaándire mʉrekera. Vakamʉsea, “Niijo, mpɨɨndɨ ja mpoloonge.” ");
INSERT INTO lag_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aho, taáta waala ʉra musinga akataanga nɨ mpɨɨndɨ jijira Yéesu ˆaarɨ amʉseiré, “Mwaana waako ahórire.” Aho, yeeye na kaaya yaachwe vakamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɨhɨ nɨ isháara ya kavɨrɨ ˆngʼeene Yéesu atʉmama, ˆakahɨndʉke na Galiláaya fuma Yudéea. ");
INSERT INTO lag_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ayo ˆyakalooke, kʉjáa kwatɨɨte ngovi ya Vayahúudi. Yéesu ne akaambʉka na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ʉko Yerusaléemu, kʉjáa kwatɨɨte mutiryaango ʉséwaa “Mutiryaango wa Muundi.” Heehi na ʉwo mutiryaango, kʉjáa kwatɨɨte isima na Kɨeburanía ˆraséwaa Betisáata. Ɨro isima, rɨjáa rarɨɨngɨrɨrwa nɨ balása isaano. ");
INSERT INTO lag_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aho balásii, valaaláa valwɨ́ɨrɨ ˆvarɨ foo, baa ja vahoku, vivete, na vaantʉ ˆvaakwya iyandiyandi. Vawojeráa maaji yatikʉlwe. ");
INSERT INTO lag_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sa kwatɨɨte mpɨɨndɨ jimwi murimʉ mʉʉja wa Ijʉva wakiimáa, ʉkatikʉla maaji. Na mʉʉntʉ ˆajáa wa ncholo kɨɨngɨra na luujii maaji ˆyakatɨkʉlwe, aholáa ʉlwɨ́ɨrɨ waachwe wowoosi ˆajáa nowo. ");
INSERT INTO lag_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Haaha, kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆajáa mʉlwɨ́ɨrɨ kwa myaaka makumi yatatʉ na ɨnaanɨ (38). ");
INSERT INTO lag_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yéesu ˆakamoone alɨ́ɨre aho, na kʉnʉ yootaanga nɨ aho ajáa kwa sikʉ ˆjiri foo, maa akamuurya, “Eri, saaka wiise ʉhole wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ʉra mʉlwɨ́ɨrɨ akamʉsea, “Aaɨ, nɨɨnɨ nsiina mʉʉntʉ wo kuumburukirya luujii mpɨɨndɨ maaji yatíkwɨɨrwe tʉkʉ. Kɨra ˆndɨrɨ saaka kɨɨngɨra, mʉʉntʉ wɨɨngɨ ɨɨngɨráa mbere yaanɨ.” ");
INSERT INTO lag_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yéesu akamʉsea, “Inʉka, toola ndɨrɨ yaako, ʉtamanye.” ");
INSERT INTO lag_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hahara, ʉra mʉʉntʉ akahola. Akatoola ndɨrɨ yaachwe, maa akaanda yeenda. Ayo yafʉmɨra sikʉ ya Sabáato. ");
INSERT INTO lag_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sa jeyyo, vakʉ́ʉ́lʉ va Vayahúudi ˆvakamoone ʉra mʉʉntʉ ˆahóriiwe, maa vakamʉsea, “Isikʉ nɨ Sabáato, ndairiri jasiita mʉʉntʉ kʉtʉmama mʉrɨmo wo kwiitɨɨka ndɨrɨ yaachwe.” ");
INSERT INTO lag_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Maa kaa, ʉra mʉʉntʉ akavasea, “Ʉra ˆaampóriirye noo aanséire, ‘Inʉka, toola ndɨrɨ yaako ʉyeende.’” ");
INSERT INTO lag_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Vayahúudi vakamʉsea, “Ʉwo mʉʉntʉ ˆakʉséire toola ndɨrɨ yaako ʉdome, nɨ ani?” ");
INSERT INTO lag_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Maa kaa, ʉra mʉʉntʉ sɨ ajáa atáangire ˆmweene amʉhóriirye tʉkʉ, sa Yéesu ajáa alóokire kimi, asáangɨrɨɨre mpukii ya vaantʉ. ");
INSERT INTO lag_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kamʉsaambo, Yéesu akamʉshaana ʉra mʉʉntʉ Kaayii Njija ya Ijʉva, maa akamʉsea, “Laanga, ʉhóriiwe, karɨ ʉbweeyye ʉvɨ kei tʉkʉ, sa luu ʉdɨɨre lʉmana na irema ikʉʉlʉ kʉlookya ɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aho, akatamanya noo vawyɨɨra Vayahúudi, nɨ Yéesu noo ˆamʉhóriirye. ");
INSERT INTO lag_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Aho, Vayahúudi vakaanda saakɨra njɨra yoomʉlaa Yéesu, sa viintʉ ajáa atʉ́mamire masáare ayo sikʉ ya Sabáato. ");
INSERT INTO lag_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Maa kaa, Yéesu akavasea, “Taáta waanɨ atʉ́mamaa mʉrɨmo sikʉ joosi baa reka tʉkʉ. Baa nɨɨnɨ nootʉmama viivyo.” ");
INSERT INTO lag_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sa jeyyo, Vayahúudi vakoongererya saakɨra njɨra yo mʉʉlaa Yéesu. Vabweeyya jeyyo, sɨ sa viintʉ ajáa awúnire miiro ya Sabáato vii tʉkʉ, maa kaa, sa viintʉ ajáa aséire Mʉlʉʉngʉ nɨ Taáta waachwe. Kwa njɨra ɨyo, ajáa iibwéeyyiirye nɨ ja Mʉlʉʉngʉ mweeneevyo. ");
INSERT INTO lag_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Aho, Yéesu akavasea valongooli va Vayahúudi, “Kɨmaarɨ kaa noovawyɨɨra, Mwaana sɨ arɨ tʉmama isáare roroosi kwa ngururu jaachwe tʉkʉ. Noo ˆchooreka, yeeye atʉ́mamaa kɨra vii ˆoona Taáta yootʉmama. Sa kɨra ˆatʉ́mamaa Taáta, noo Mwaana ˆatʉ́mamaa. ");
INSERT INTO lag_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taáta amweenda Mwaana, na noo ˆchooreka amoónekyaa yara ˆatʉ́mamaa yeeye mweeneevyo. Kei, moonekya arɨ masáare makʉʉlʉ kʉlookya aya, na nyuunyu hwaalala mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ja ˆvyeene Taáta avafʉ́fʉlaa vaantʉ no vaheera nkaasʉ ya sikʉ ˆjisiina ʉhero, viivyo Mwaana avahéeraa nkaasʉ vara ˆeendire kʉvaheera. ");
INSERT INTO lag_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kei, Taáta sɨ amʉlámʉrɨraa mʉʉntʉ yoyoosi tʉkʉ, maa kaa, mʉrɨmo woosi wo lamʉrɨra, amʉheera Mwaana. ");
INSERT INTO lag_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Abweeyya jeyyo, sa vaantʉ voosi vamʉnyemye Mwaana ja ˆvyeene vamʉnyémyaa Taáta. Mʉʉntʉ yoyoosi sɨ ˆamʉnyémyaa Mwaana, ʉwo sɨ amʉnyémyaa Taáta tʉkʉ. Na Taáta noo amʉtʉma Mwaana. ");
INSERT INTO lag_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kɨmaarɨ kaa noovawyɨɨra, Taáta aantʉma. Yoyoosi ˆatéeraa masáare yaanɨ na ˆamurúmaa Taáta, atɨɨte nkaasʉ ya sikʉ ˆjisiina ʉhero. Ʉwo sɨ arɨ heewa irya tʉkʉ, yeeye afɨrɨra inkwya, akɨɨngɨra na nkaaswii. ");
INSERT INTO lag_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kɨmaarɨ kaa noovawyɨɨra, mpɨɨndɨ kʉʉja yiise, na mpɨɨndɨ ɨyo yafíkire, vaantʉ ˆvaakwya teera varɨ Mwaana wa Mʉlʉʉngʉ yoolʉʉsa. Na vara ˆvooteera, kʉva varɨ nkaasʉ. ");
INSERT INTO lag_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ja ˆvyeene Taáta atɨɨte nkaasʉ yeeye mweeneevyo, viivyo amʉheera Mwaana nkaasʉ isii yaachwe. ");
INSERT INTO lag_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kei, amʉheera Mwaana wiimiriri wo lamʉrɨra vaantʉ, sa yeeye nɨ Mwaana wa Mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Karɨ mʉhwaalale tʉkʉ. Mpɨɨndɨ kʉʉja jiri, voosi ˆvarɨ mbiríírii teera varɨ sawúti yaachwe, ");
INSERT INTO lag_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na fuma varɨ mbiríírii. Yoyoosi ˆatʉmamáa maaja, heewa arɨ nkaasʉ ya sikʉ ˆjisiina ʉhero. Maa kaa, vara ˆvabweeyyáa ʉvɨ, heewa varɨ irya. ");
INSERT INTO lag_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nɨɨnɨ sɨ ndɨrɨ daha tʉmama isáare roroosi kwa lʉvɨro lwaanɨ tʉkʉ. Noolamʉrɨra vaantʉ ja ˆvyeene Taáta aangwyɨɨra. Na ʉlamuli waanɨ nɨ wa ʉwoloki, sa sɨ nootʉmama yara ˆnoosaaka nɨɨnɨ tʉkʉ, kɨrɨ vyoova jeyyo, nootʉmama yara ˆyoosaaka Taáta, yeeye aantʉma. ");
INSERT INTO lag_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Koonɨ nookiiyonekerya masáare yaanɨ nɨɨmweene, kɨra ˆnookiiyonekerya sɨ cha kɨmáárɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Maa kaa, amwaarɨ wɨɨngɨ ˆoónekyaa kɨkomi chaanɨ, na nɨ kʉvawyɨɨra niise, kɨra ˆyookoonekya chaanɨ nɨ cha kɨmáárɨ. ");
INSERT INTO lag_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyuunyu mwatʉma vatumwi na kwa Yooháani Mʉbatisáaji, ne avoonekya kɨra kɨmáárɨ. ");
INSERT INTO lag_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sɨ nookiilaangya koonekya kwa vaantʉ tʉkʉ, maa kaa, nɨ kʉvawyɨɨra niise masáare aya, sa mʉlamuririwe. ");
INSERT INTO lag_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yooháani Mʉbatisáaji ajáa nɨ ja kɨmʉrɨ ˆkɨmʉ́rɨkaa kilwiiryii. Nyuunyu mʉjáa mwacheenda ɨkyo kɨmʉrɨ, kwa mpɨɨndɨ nduudi. ");
INSERT INTO lag_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Maa kaa, natɨɨte masáare makʉʉlʉ nookoonekya kʉlookya ya Yooháani. Sa mɨrɨmo ˆnootʉmama, koonekya yiise Mʉlʉʉngʉ Taáta noo aantʉma. ");
INSERT INTO lag_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taáta yeeye mweeneevyo aantʉma, oónekiirye kɨkomi chaanɨ. Maa kaa, nyuunyu sɨ mʉnateera sawúti yaachwe vii tʉkʉ, baa kei, sɨ mʉnamoona mpula na miiso tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kei, isáare raachwe sɨ riíkalaa isii yaanyu tʉkʉ, sa sɨ mwaandúmaa nɨɨnɨ tʉkʉ. Nɨɨnɨ, natʉmwa nɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nyuunyu mwasímbʉlaa Masáare ˆYarɨ Mpeho, sa mwiiséaa isii yaachwe turya mʉrɨ nkaasʉ ya sikʉ ˆjisiina ʉhero. Kʉmba kaa, Masáare ˆYarɨ Mpeho yoónekyaa kɨkomi mweeri yaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nyuunyu moosiita kʉʉja na kʉrɨ nɨɨnɨ, sa mʉhokere nkaasʉ ya sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nɨɨnɨ sɨ nooruma kʉdʉʉmbɨrɨrwa nɨ vaantʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Maa kaa, nɨɨnɨ navamányire nyuunyu. Nyuunyu sɨ mwamweenda Mʉlʉʉngʉ mitimii yaanyu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nɨɨnɨ nʉʉja kwa irina ra Taáta waanɨ, na nyuunyu mwasíitire kʉʉmpokera. Maa kaa, mʉʉntʉ wɨɨngɨ koonɨ uújire kwa irina raachwe kʉmʉhokera mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nyuunyu, mweenda dʉʉmbɨrɨrwa nɨ viivaanyu, na sɨ mweenda saakɨra dʉʉmbɨ ˆifúmaa kwa Mʉlʉʉngʉ mweeneevyo tʉkʉ. Haaha joolɨ mʉrɨ kuunduma? ");
INSERT INTO lag_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Maa kaa, karɨ mwiisee nɨɨnɨ vasitaakya ndɨrɨ kwa Taáta tʉkʉ, ˆarɨ vasitaakya, nɨ Mʉ́sa nyuunyu ˆmumwiiláangyaa. ");
INSERT INTO lag_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ngaarɨ mwamuruma Mʉ́sa, ngaarɨ mwaanduma baa nɨɨnɨ, sa Mʉ́sa aandɨka masáare yaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Maa kaa, koonɨ sɨ mooruma ˆmeene aandɨka Mʉ́sa, joolɨ mʉrɨ ruma ˆcheene noolʉʉsa?” ");
INSERT INTO lag_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ayo ˆyakalooke, Yéesu akatamanya na fɨrɨro ya iriva ra Galiláaya, irina rɨɨngɨ rɨséwaa iriva ra Tibéria. ");
INSERT INTO lag_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mpuka nkʉʉlʉ ya vaantʉ ɨkava yoomutuuba, sa vajáa vɨɨ́ne myuujíisa ˆmyeene abweeyyáa kwa valwɨ́ɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aho, Yéesu na vapooji vaachwe vakaambʉka na luulwii. Ʉko vakiikala voosi hamwɨ. ");
INSERT INTO lag_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ngovi ya Vayahúudi ˆɨséwaa Paásika, ɨjáa yaséngerɨɨre. ");
INSERT INTO lag_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yéesu akalaanga, maa akoona yara mayɨɨmbɨ ya vaantʉ ˆyookʉʉja na kwaachwe. Aho, akamuurya Filíipi, “Hai tʉrɨ wʉrɨra mɨkáate sa ava vaantʉ voosi varye?” ");
INSERT INTO lag_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yéesu alʉʉsa jeyyo yoomʉyera Filíipi, sa ajáa amányire ˆcheene arɨ tʉmama. ");
INSERT INTO lag_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filíipi akamʉsea, “Aaɨ baa na tʉwʉle mɨkáate ya mpía ja dináari magana yavɨrɨ (200), ava vaantʉ sɨ varɨ keenera kwa kɨra mʉʉntʉ kʉpata kiduudi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aho, ʉmwɨ wa vapooji vaachwe ˆaséwaa Anderéa, mwaanaavo na Simóoni Peéteri, akamʉsea Yéesu, ");
INSERT INTO lag_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mʉkʉ́lʉ, aha kwatɨɨte mʉtavana ʉmwɨ ˆarɨ na mɨkáate ɨsaano ya shayíiri na fisoompa fivɨrɨ. Ha de ivi nɨ kɨɨntʉ che kwa ɨrɨ iyɨɨmbɨ ra vaantʉ?” ");
INSERT INTO lag_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yéesu akasea, “Vasei vaantʉ viikale ɨsɨ.” Aho haantʉ, kʉjáa kwatɨɨte masaambɨ ˆyarɨ foo, maa vaantʉ vakiikala. Aho mpukii, kʉjáa kwatɨɨte vaantʉ valʉme mayana yasaano (5,000). ");
INSERT INTO lag_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yéesu akatoola ɨra mɨkáate, akamʉdʉʉmba Mʉlʉʉngʉ, maa akavaheera vaantʉ ˆvajáa aho. Kei akabweeyya vivira kwa fira fisoompa. Kɨra mʉʉntʉ apata ja ˆvyeene asaakáa. ");
INSERT INTO lag_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Vaantʉ ˆvakarye no kiikuta, Yéesu akavasea vapooji vaachwe, “Tooreri mabéendʉ ya mɨkáate yoosi ˆɨchɨ́hɨɨre, sa yadɨɨre chaala ja kosu.” ");
INSERT INTO lag_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Aho, vakatoorera mabéendʉ ya mɨkáate ya shayíiri ˆyachɨ́hɨɨre, vakamemya vikápu ikimi na vivɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Vaantʉ ˆvakoone ɨra isháara na muujíisa ˆajáa abwéeyyiirye, maa vakasea, “Kɨmaarɨ, ʉhʉ noo ʉra mʉláali na mʉtwe ˆtawóojeraa, ˆyookʉʉja na kʉrɨ weerʉ.” ");
INSERT INTO lag_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yéesu kʉnʉ yootaanga vaantʉ voosaaka vamʉdoomererye ave mʉtemi waavo, yeeye akalooka, akaambʉka na luulwii, akava yeemweene. ");
INSERT INTO lag_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na kyʉʉlwa, vapooji vaachwe vakagirita na irivii ra Galiláaya. ");
INSERT INTO lag_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Vakɨɨngɨra mashúwii, maa vakaanda fɨrɨra iriva voodoma na iturii ra Kaperenáumu. Mpɨɨndɨ ijo, kilwiirya kɨjáa chɨɨ́ngɨɨre, na Yéesu sɨ ajáa anafika ave novo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aho, iriva rɨkatikʉlwa nɨ ihúmbuuto ikarɨ ˆrawuváa. ");
INSERT INTO lag_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Vapooji vaachwe vajáa vayéendire ja lʉyeendo lwa kilomíita isaano au mʉsasatʉ, maa vakamoona Yéesu yooyeenda luujii mweeri aséngerɨɨre mashʉ́wa yaavo. Aho, vakakwaatwa nɨ woowa mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Maa kaa, Yéesu akavasea, “Nɨ nɨɨnɨ, koofi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aho, varɨ na cheerʉ vakasaaka aambʉke na mashúwii, na hahara mashʉ́wa ɨkafika haantʉ ˆvadomáa. ");
INSERT INTO lag_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lomʉtóondo yaachwe, mpuka ya vaantʉ ˆvajáa vachɨ́hɨɨre nyambʉko ya iriva, vajáa vataanga kʉjáa kwatɨɨte mashʉ́wa imudu vii ɨchɨ́hɨɨre hara. Kei vajáa vatáangire Yéesu sɨ ajáa adómiinʼye na vapooji vaachwe na ɨra mashʉ́wa tʉkʉ, nɨ vooveene vajáa vadómire. ");
INSERT INTO lag_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Maa kaa, mashʉ́wa jɨɨngɨ fuma múuji wa Tibéria, jikʉʉja na heehi na haantʉ vaantʉ ˆvaarɨ varíire mɨkáate Mweenevyoosi ˆakamʉdʉʉmbe Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aho, vara vaantʉ ˆvakataange Yéesu na vapooji vaachwe valóokire, maa vakaambʉka ijo mashʉ́wa, vakadoma na múujii wa Kaperenáumu noo mʉsaakɨra Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Avo vaantʉ ˆvamʉsaakɨráa Yéesu, vakamʉshaana nyambʉko ya iriva, maa vakamuurya voosea, “Mukiindya, naadi wuújire na kʉnʉ?” ");
INSERT INTO lag_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yéesu akavasea, “Kɨmaarɨ kaa noovawyɨɨra, sɨ mookʉʉnsaakɨra sa mwatáangire isháara na myuujíisa mwɨɨ́ne tʉkʉ, kɨrɨ vyoova jeyyo, mookʉʉnsaakɨra sa viintʉ mwariiré ɨra mɨkáate mukiikuta. ");
INSERT INTO lag_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Karɨ mʉndootʉmama sa muturye chóorya ˆkɨsáambʉkaa tʉkʉ, kɨrɨ vyoova jeyyo, mʉndootʉmama sa muturye chóorya sɨ ˆkɨsaambʉka kwa sikʉ ˆjisiina ʉhero. Ɨkyo chóorya, Mwaana wa Mʉʉntʉ noo arɨ vaheera. Yeeye noo avɨkɨrwa mʉtooso mweeri yaachwe nɨ Mʉlʉʉngʉ Taáta.” ");
INSERT INTO lag_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aho, vakamuurya Yéesu voosea, “Eri, tʉbweeyye che sa tʉtʉmame mʉrɨmo wa Mʉlʉʉngʉ ˆmweene yoosaaka?” ");
INSERT INTO lag_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yéesu akavasea, “Mʉrɨmo wa Mʉlʉʉngʉ ˆyoosaaka mʉtʉmame noo ʉhʉ, ndumi nɨɨnɨ ˆnatʉmwa nɨ yeeye.” ");
INSERT INTO lag_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aho, maa vakamʉsea, “Eri, nɨ isháara na muujíisa ʉrɨkwɨ ˆʉrɨ tʉmama tʉʉyoone, maa de tukurume? Nɨ kɨɨntʉ che ʉrɨ bweeyya? ");
INSERT INTO lag_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Vala baaba wiitʉ vaarya máana ɨsɨ ya ibaláángwii ja ˆvyeene Masáare ˆYarɨ Mpeho yalʉʉsa, ‘Avaheera mʉkáate fuma kurumwii, sa varye.’” ");
INSERT INTO lag_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yéesu akavasea, “Kɨmaarɨ kaa noovawyɨɨra, sɨ Mʉ́sa ˆavaheera mɨkáate fuma kurumwii tʉkʉ, kɨrɨ vyoova jeyyo, nɨ Taáta waanɨ, yeeye noo ˆyoovaheera chóorya cha kɨkomi fuma kurumwii. ");
INSERT INTO lag_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sa mʉkáate wa Mʉlʉʉngʉ, nɨ ʉra ˆyookiima fuma kurumwii na yookʉʉheera weerʉ nkaasʉ ya sikʉ ˆjisiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aho, vakamʉsea, “Mʉkʉ́lʉ, ʉndootʉheera ʉwo mʉkáate sikʉ joosi.” ");
INSERT INTO lag_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yéesu akavasea, “Nɨɨnɨ noo chóorya cha nkaasʉ, yoyoosi ˆʉʉ́jaa na kʉrɨ nɨɨnɨ, na ˆaandúmaa sɨ arɨ kwaavwa nɨ njala kei vii kaa tʉkʉ, na yoyoosi ˆaandúmaa nɨɨnɨ, sɨ arɨ koona nyóota kei tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Maa kaa, ja ˆvyeene navawyɨ́ɨrɨɨre, baa neembe mʉʉnyɨɨ́ne, mʉkaarɨ sɨ mookuunduma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Voosi ˆaampeera Taáta, kʉʉja varɨ na kwaanɨ, na kɨkomi nɨɨnɨ sɨ ndɨrɨ musiita baa ʉmwɨ vii tʉkʉ ˆarɨ kʉʉja na kwaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nɨɨnɨ nakiima fuma kurumwii, sa jɨ ntʉmame vira Taáta ˆyoosaaka ntʉmame. Sɨ nʉʉja jo tʉmama vira ˆnoosaaka tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na kɨra Taáta ˆasáakaa noo ɨkɨ, karɨ nɨmʉtaahe baa ʉmwɨ vii tʉkʉ wa vara ˆaampeera. Kɨrɨ vyoova jeyyo, yoosaaka nɨvafʉfʉle sikʉ ya ʉhero wa weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sa kɨra Taáta waanɨ ˆasáakaa nɨ ɨkɨ, kɨra mʉʉntʉ ˆamʉláangaa Mwaana na ˆamurume, ave na nkaasʉ ya sikʉ ˆjisiina ʉhero, na nɨɨnɨ mʉfʉfʉla ndɨrɨ sikʉ ya ʉhero wa weerʉ.” ");
INSERT INTO lag_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aho, Vayahúudi vakaanda ngʼuula sa viintʉ Yéesu ˆajáa aséire, “Nɨɨnɨ nɨ chóorya ˆchakiima fuma kurumwii.” ");
INSERT INTO lag_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Vaakaanda kiiyurya, “Ʉhʉ sɨ Yéesu, mwaana wa Yooséefu tʉkʉ wʉʉ? Taáta waavo na íyo waavo sɨ ava tavamányire tʉkʉ wʉʉ? Haaha joolɨ yoosea, ‘Nakiima fuma kurumwii’?” ");
INSERT INTO lag_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yéesu akavasea, “Reki kwiingʼʉʉrɨra nyuunyu kwa nyuunyu. ");
INSERT INTO lag_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taáta aantʉma. Kusiina mʉʉntʉ ˆarɨ daha kʉʉja na kwaanɨ tʉkʉ, koonɨ Taáta sɨ amʉlóngwɨɨre. Na nɨɨnɨ mʉfʉfʉla ndɨrɨ sikʉ ya ʉhero wa weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ja ˆvyeene vyaandɨkwa masáarii ya valáali na mʉtwe, ‘Mʉlʉʉngʉ vakiindya arɨ vaantʉ voosi.’ Yoyoosi ˆamʉtéeraa na ˆiikíindyaa fuma kwa Taáta, ʉʉ́jaa na kwaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kusiina mʉʉntʉ yoyoosi ˆanamoona Taáta tʉkʉ, nɨ ʉra vii ˆafuma kwa Mʉlʉʉngʉ, yeeye noo amoona Taáta. ");
INSERT INTO lag_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kɨmaarɨ kaa noovawyɨɨra, ʉra ˆyookuunduma nɨɨnɨ, atɨɨte nkaasʉ ya sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nɨɨnɨ nɨ chóorya cha nkaasʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vala baaba waanyu vaarya máana kʉra ɨsɨ ya ibaláángwii, vakakwya. ");
INSERT INTO lag_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Maa kaa, aha kwatɨɨte chóorya ˆchafuma kurumwii, na mʉʉntʉ yoyoosi ˆarɨ kurya, sɨ arɨ kukwya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nɨɨnɨ nɨ chóorya cha nkaasʉ kɨra ˆchafuma kurumwii. Mʉʉntʉ yoyoosi ˆarɨ kurya chóorya ɨkɨ, kʉva arɨ nkaasʉ kwa sikʉ ˆjisiina ʉhero. Chóorya ɨkɨ, nɨ mʉvɨrɨ waanɨ ˆnookʉʉtoola sa nkaasʉ ya vaantʉ voosi va weerʉ.” ");
INSERT INTO lag_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Vayahúudi vakaanda kiiyurya voovo kwa voovo voosea, “Ʉhʉ mʉʉntʉ, joolɨ arɨ tʉheera mʉvɨrɨ waachwe turye?” ");
INSERT INTO lag_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sa jeyyo, Yéesu akavasea, “Kɨmaarɨ kaa noovawyɨɨra, koonɨ sɨ mʉrɨ́ɨre mʉvɨrɨ wa Mwaana wa Mʉʉntʉ na koonɨ sɨ munywíire sakami yaachwe, sɨ mʉrɨ na nkaasʉ ya sikʉ ˆjisiina ʉhero tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mʉʉntʉ yoyoosi ˆaríjaa mʉvɨrɨ waanɨ na ˆanywíjaa sakami yaanɨ, atɨɨte nkaasʉ ya sikʉ ˆjisiina ʉhero, naanɨ mʉfʉfʉla ndɨrɨ sikʉ ya ʉhero wa weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mʉvɨrɨ waanɨ noo chóorya cha kɨkomi, na sakami yaanɨ nɨ choonywa cha kɨkomi. ");
INSERT INTO lag_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mʉʉntʉ yoyoosi ˆaríjaa mʉvɨrɨ waanɨ na ˆanywíjaa sakami yaanɨ, yeeye na nɨɨnɨ, kei nɨɨnɨ na yeeye, tavíjaa kɨɨntʉ kɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Taáta nɨ nkaasʉ arɨ. Ja ˆvyeene yeeye aantʉma, na nɨɨnɨ napátaa nkaasʉ fuma kwaachwe, jeyyo, ˆmweene arɨ kurya mʉvɨrɨ waanɨ, turya arɨ nkaasʉ fuma kwaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ɨkɨ noo chóorya ˆchafuma kurumwii. Ɨkɨ chóorya sɨ chiifwɨ́ɨne na chóorya ˆvaarya vala baaba waanyu tʉkʉ. Voovo vaarya vakakwya. Maa kaa, mʉʉntʉ yoyoosi ˆaríjaa chóorya ɨkɨ, kʉva arɨ na nkaasʉ ya sikʉ ˆjisiina ʉhero.” ");
INSERT INTO lag_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yéesu alʉʉsa masáare aya, mpɨɨndɨ ˆakiindyáa sinagóogii ʉko Kaperenáumu. ");
INSERT INTO lag_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Vapooji vaachwe ˆvarɨ foo ˆvakateere jeyyo, maa vakasea, “Ukiindya ʉhʉ wakaangaala maatʉkʉ vii. Ani arɨ daha kuuruma?” ");
INSERT INTO lag_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yéesu akataanga vapooji vaachwe nɨ ngʼuula viise sa ɨrɨ isáare, aho, akavuurya, “Eri, ɨrɨ isáare ravatɨ́kwɨɨre wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Haaha joolɨ viri kʉva, mʉrɨ moona Mwaana wa Mʉʉntʉ yookaambʉka na kʉʉntʉ ˆajáa aho ncholo? ");
INSERT INTO lag_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mʉtɨma wa Mʉlʉʉngʉ noo ʉvahéeraa vaantʉ nkaasʉ. Mʉvɨrɨ usiina kɨɨntʉ chochoosi tʉkʉ. Masáare ˆnavawyɨ́ɨrɨɨre nɨ Mʉtɨma na nɨ nkaasʉ. ");
INSERT INTO lag_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Maa kaa, vamwaarɨ kʉrɨ nyuunyu sɨ ˆvookuunduma tʉkʉ.” Yéesu alʉʉsa jeyyo, sa ajáa ataanga fuma ncholo nɨ vala ani sɨ ˆvarɨ muruma, na nɨ ani ˆarɨ mʉvarindʉka. ");
INSERT INTO lag_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kei akasea, “Noo ˆchooreka noovasea, kusiina mʉʉntʉ ˆarɨ daha kʉʉja na kwaanɨ tʉkʉ, nɨ mpaka Taáta vii amʉlongoole.” ");
INSERT INTO lag_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ˆVakateere masáare ayo, vapooji ˆvarɨ foo vakamʉreka na vakareka mutuuba. ");
INSERT INTO lag_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aho, Yéesu akavuurya vapooji vaachwe ikimi na vavɨrɨ, “Eri, baa nyuunyu saaka mwiise mwaandeke wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simóoni Peéteri akamʉsea, “Mʉkʉ́lʉ, tʉdome na kwa ani? Weewe ʉtɨɨte masáare ya nkaasʉ ya sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Suusu taruma, tataanga weewe noo ʉra ˆArɨ Mʉʉja wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Aho, Yéesu akavasea, “Eri, sɨ navasaawʉla nyuunyu ikimi na vavɨrɨ tʉkʉ wʉʉ? Maa kaa, ʉmwɨ waanyu nɨ ja Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ.” ");
INSERT INTO lag_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aha Yéesu amʉlʉʉsɨkɨráa Yʉ́ʉda mwaana wa Simóoni Isikarióoti. Ʉwo ʉʉja jo mʉvarindʉka Yéesu, baa neembe ajáa ʉmwɨ wa vapooji ikimi na vavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Aya ˆyakalooke, Yéesu akatamanya na míiji ˆɨrɨ foo ʉko ɨsɨ ya Galiláaya. Sɨ arɨɨngɨrɨra ɨsɨ ya Yudéea tʉkʉ, sa viintʉ vakʉ́ʉ́lʉ va Vayahúudi vasaakáa mʉʉlaa. ");
INSERT INTO lag_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Haaha ngovi ya Vayahúudi ya matibu ɨjáa yaséngerɨɨre. ");
INSERT INTO lag_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jeyyo, vandʉʉ vaachwe vakamʉsea, “Inʉka aha, ʉtamanye na Yudéea sa vapooji vaako voone myuujíisa ˆwootʉmama. ");
INSERT INTO lag_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Koonɨ mʉʉntʉ yoosaaka ataangɨkane kwa vaantʉ, mɨrɨmo yaachwe ˆyootʉmama sɨ arɨ kɨɨtʉmama kimbiso tʉkʉ. Weewe tʉmama wiise aya masáare, iyonekye kwa weerʉ.” ");
INSERT INTO lag_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Baa vaanaavo na Yéesu sɨ vamuruma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yéesu akavasea, “Mpɨɨndɨ jaanɨ sɨ jinafika tʉkʉ, maa kaa, nyuunyu tamanya mʉrɨ mpɨɨndɨ jojoosi ˆmʉsáakire. ");
INSERT INTO lag_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Weerʉ sɨ ɨrɨ vasʉʉla nyuunyu tʉkʉ, maa kaa, yaansʉʉla nɨɨnɨ sa nookɨɨyonekya kɨkomi yootʉmama ʉvɨ. ");
INSERT INTO lag_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nyuunyu ambuki na Yerusaléemu ngovii. Nɨɨnɨ sɨ nookaambʉka tʉkʉ, sa mpɨɨndɨ jaanɨ jikaarɨ fika.” ");
INSERT INTO lag_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ˆAkavawyɨɨre jeyyo, maa akachaala ʉko ɨsɨ ya Galiláaya. ");
INSERT INTO lag_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Vandʉʉ va Yéesu ˆvakalooke na ngovii, Yéesu ne akaambʉka na Yerusaléemu, maa kaa, kwa kimbiso sɨ iiyonekya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mpɨɨndɨ ja ngovi, vakʉ́ʉ́lʉ va Vayahúudi vamʉsaakɨráa Yéesu aho ngovii. Vakavuurya vaantʉ voosea, “Hai arɨ ʉra mʉmaka?” ");
INSERT INTO lag_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Vaantʉ ˆvarɨ foo vangʼuuláa sa Yéesu voosea, “Nɨ mʉʉntʉ mʉʉja.” Na vɨɨngɨ vaseáa, “Yoovakoovera vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Maa kaa, kusiina mʉʉntʉ ˆamʉlʉʉsáa Yéesu mbere ja vaantʉ tʉkʉ, sa voofáa vakʉ́ʉ́lʉ va Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mpɨɨndɨ ja sikʉ ja ngovi ˆjikafike katɨkatɨ, Yéesu akɨɨngɨra na waámii ya Kaaya Njija ya Ijʉva, maa akaanda kiindya. ");
INSERT INTO lag_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Vayahúudi vakahwaalariwa nɨ ukiindya waachwe, vakasea, “Eri, ʉhʉ mʉʉntʉ nɨ hai ˆafumya ʉmanyi ʉhʉ na yeeye sɨ anakiindiwa tʉkʉ?” ");
INSERT INTO lag_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aho, Yéesu akavasea, “Ʉhʉ ukiindya sɨ waanɨ tʉkʉ, nɨ wa ʉra ˆaantʉma. ");
INSERT INTO lag_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mʉʉntʉ yoyoosi ʉra ˆasáawʉlaa kʉtʉmama vira ˆvyoosaakwa nɨ Mʉlʉʉngʉ, amányire ukiindya ʉhʉ wafuma kwa Mʉlʉʉngʉ, na sɨ masáare yaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Vara ˆvalʉ́ʉsɨkaa sa voovo, vasáakaa nkongojima jaavo vooveene, maa kaa, mʉʉntʉ ʉra ˆasáakaa kʉmʉnyemya ʉra ˆamʉtʉma, alʉ́ʉsɨkaa kɨmáárɨ vii, sɨ ʉloongo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Eri, Mʉ́sa sɨ avaheera Miiro? Baa jeyyo, kusiina baa ʉmwɨ waanyu ˆakwáatyaa ɨyo Miiro tʉkʉ. Haaha sa che moosaaka kʉʉnjʉlaa?” ");
INSERT INTO lag_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɨra mpuka ya vaantʉ ɨkamʉsea, “Weewe watɨɨte murimʉ mʉvɨ. Ani yoosaaka kʉkʉʉlaa?” ");
INSERT INTO lag_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yéesu akavasea, “Nabweeyya muujíisa ʉmwɨ vii sikʉ ya Sabáato, na nyuunyu voosi mwahwaalala. ");
INSERT INTO lag_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mʉ́sa avalairirya kʉvatwaala na kɨbawii vasinga voosi va kɨɨntʉ kɨlʉme, baa neembe ɨhɨ tʉʉva sɨ yafuma kwa Mʉ́sa, maa kaa, kwa vala baaba waanyu. Kɨrɨ vyoova jeyyo, nyuunyu mwatwáalaa vasinga na kɨbawii baa sikʉ ya Sabáato. ");
INSERT INTO lag_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Koonɨ musinga atwáalwaa na kɨbawii baa sikʉ ya Sabáato sa Miiro ya Mʉ́sa ɨdɨɨre wunwa, joolɨ de mookʉʉnkalarɨra nɨɨnɨ so horya mʉʉntʉ sikʉ ya Sabáato? ");
INSERT INTO lag_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Reki lamʉrɨra mʉʉntʉ kwa kɨra ˆmookoona weerwii, kɨrɨ vyoova jeyyo, lamuriri kwa ʉwoloki.” ");
INSERT INTO lag_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Haaha, vamwɨ va vaantʉ va Yerusaléemu vakaanda sea, “Eri, ʉhʉ sɨ noo ʉra mʉʉntʉ ˆvoosaaka mʉʉlaa tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hoonɨ laangi, amwɨ yoolʉʉsɨka novo kɨweerwii na baa sɨ voomuwyɨɨra kɨɨntʉ chochoosi tʉkʉ? Ifaanaa vikava vakʉ́ʉ́lʉ vatáangire ʉhʉ noo Masía wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Suusu tamányire ʉhʉ mʉʉntʉ kʉʉntʉ ˆafuma. Maa kaa, Masía ˆarɨ kʉʉja sɨ tʉrɨ taanga kʉʉntʉ ˆarɨ fuma tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yéesu akatuuba kiindya waámii wa Kaaya Njija, akalʉʉsɨka na sawúti nkʉʉlʉ yoosea, “Nyuunyu mwaamányire nɨɨnɨ, na mwamányire kʉʉntʉ ˆnafuma. Nɨɨnɨ sɨ nʉʉja kwa ngururu jaanɨ tʉkʉ. Maa kaa, ʉra ˆaantʉma nɨ wa kɨkomi na nyuunyu sɨ mwamʉmányire tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nɨɨnɨ namʉmányire, sa nafuma kwaachwe, na yeeye noo aantʉma.” ");
INSERT INTO lag_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aho, vakayera mʉkwaata, maa kaa, kusiina mʉʉntʉ yoyoosi ˆadaha mʉkwaata tʉkʉ, sa mpɨɨndɨ yaachwe ɨjáa ɨkaarɨ fika. ");
INSERT INTO lag_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Vaantʉ ˆvarɨ foo vajáa aho, vakamuruma, na vakasea, “Eri, Masía ˆarɨ kʉʉja, tʉmama arɨ isháara na myuujíisa mɨkʉʉlʉ kʉlookya ɨhɨ ˆyootʉmama ʉhʉ mʉʉntʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafarisáayo vakateera vaantʉ vookiihweehera ayo masáare ya Yéesu. Aho, Mafarisáayo na vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva vakatʉma valʉkalʉka va Kaayii Njija, vakamʉkwaate Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yéesu akavasea, “Nɨɨnɨ mwaarɨ na nyuunyu kwa mpɨɨndɨ nduudi vii, aho, hɨndʉka ndɨrɨ kwa ʉra ˆaantʉma. ");
INSERT INTO lag_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kʉʉnsaakɨra mʉrɨ, maa kaa, sɨ mʉrɨ kʉʉnyona tʉkʉ, na haantʉ ˆndɨrɨ veera, nyuunyu sɨ mʉrɨ daha kʉʉja tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aho, Vayahúudi vakiiyurya voovo kwa voovo voosea, “Ʉhʉ mʉʉntʉ nɨ na hai ˆyoodoma haantʉ sɨ ˆtʉrɨ daha kʉmoona? Bakʉ saaka iise adome na kwa Vayahúudi vara ˆviipasa míijii ya Vagiríki, sa avakiindye Vagiríki wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nɨ kɨɨntʉ che ɨkɨ ˆyoolʉʉsa, ‘Kʉʉnsaakɨra mʉrɨ, maa kaa, sɨ mʉrɨ kʉʉnyona tʉkʉ, na haantʉ ˆndɨrɨ veera, nyuunyu sɨ mʉrɨ daha kʉʉja tʉkʉ?’” ");
INSERT INTO lag_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sikʉ yo herererya ngovi ya matibu, nɨ sikʉ nkʉʉlʉ ɨjáa. Yéesu akɨɨma katɨ na katɨ ya waama wa Kaaya Njija, akalʉʉsɨka kwa sawúti nkʉʉlʉ yoosea, “Koonɨ ʉrɨ na nyóota yeenda na kwaanɨ jɨ unywe. ");
INSERT INTO lag_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Masáare ˆYarɨ Mpeho yalʉʉsa, ‘Ʉra ˆaanduma nɨɨnɨ, maboote ˆyiíkaa maaji ya nkaasʉ fuma yarɨ isii yaachwe.’” ");
INSERT INTO lag_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yéesu alʉʉsɨkɨra Mʉtɨma Mʉʉja. Ʉhʉ Mʉtɨma Mʉʉja, vaantʉ voosi ˆvamurúmaa Yéesu lo mʉhokera varɨ. Mpɨɨndɨ ijo, Mʉlʉʉngʉ ajáa akaarɨ mʉtʉma Mʉtɨma Mʉʉja na kwa vaantʉ ˆvamuruma Yéesu, sa Mʉlʉʉngʉ ajáa akaarɨ laɨra nkongojima kwa Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Vamwɨ va vaantʉ va ɨra mpuka ˆvakateere ayo masáare, maa vakasea, “Kɨkomi, ʉhʉ noo ʉra mʉláali na mʉtwe ˆtawóojeraa fuma kwa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Vamwɨ vakasea, “Ʉhʉ noo Masía!” Maa kaa, vɨɨngɨ vakasea, “Tʉkʉ, Masía sɨ arɨ fuma Galiláaya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Masáare ˆYarɨ Mpeho yasea, Masía fuma arɨ ichinii ra mʉtemi Daúdi, vyaarɨrwa arɨ múujii wa Betelehéemu, múuji haantʉ mʉtemi Daúdi ˆiikala.” ");
INSERT INTO lag_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sa jeyyo, vaantʉ vakiigava sa Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vamwɨ vaavo vakasaaka kʉmʉkwaata, maa kaa, kusiina ˆayera kʉmʉkwaata tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Valʉkalʉka ˆvakahɨndʉke na kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na Mafarisáayo, ˆveene vajáa vavatúmire vakamʉkwaate Yéesu, maa vakuuriwa, “Sa che sɨ mʉmʉréetire?” ");
INSERT INTO lag_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Valʉkalʉka vakavasea, “Kusiina mʉʉntʉ wɨɨngɨ ˆanalʉʉsɨka ja ʉhʉ mʉʉntʉ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafarisáayo vakavasea, “Arumi, baa nyuunyu mwakóovɨɨrwe wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Eri, kwatɨɨte mʉkʉ́ʉ́lʉ ʉmwɨ au Mʉfarisáayo ʉmwɨ ˆamuruma wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tʉkʉ! Maa kaa, ɨhɨ mpuka ya vaantʉ ˆvoomuruma, sɨ vamányire Miiro tʉkʉ. Ava, vajumwa.” ");
INSERT INTO lag_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Aho, Nikodéemu, ʉra ˆajáa ʉmwɨ waavo sikʉ ɨmwɨ ajáa adoma na kwa Yéesu nuuchikʉ, akuurya, ");
INSERT INTO lag_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Eri, Miiro yiitʉ yaruma kʉheera mʉʉntʉ irya baa mʉteerera no taanga kɨra ˆatʉ́mamaa tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Novo vakamʉsea, “Bakʉ baa weewe nɨ Galiláaya wafuma wʉʉ? Doma kasole neeja Masáare ˆYarɨ Mpeho, aho, taanga ʉrɨ kusiina mʉláali na mʉtwe wa Ijʉva ˆafúmaa Galiláaya tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aho, kɨra mʉʉntʉ akatamanya na kaayii kwaachwe. ");
INSERT INTO lag_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yéesu ˆakahʉmʉle kukiindya, maa akatamanya na Luulwii lwa Mɨseitúuni. ");
INSERT INTO lag_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lomʉtóondo yaachwe namʉtóondo dwɨɨ, Yéesu akatamanya kei na waámi wa Kaaya Njija ya Ijʉva. Vaantʉ voosi vakatamanya na kʉrɨ yeeye, akiikala ɨsɨ, maa akaanda vakiindya. ");
INSERT INTO lag_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aho, vakiindya va Miiro na Mafarisáayo vakamʉreeta mʉʉntʉ muki ʉmwɨ ˆajáa akwáatirwe yooyeenda na mʉlʉme wa mʉʉntʉ. Vakamwiimya katɨ na katɨ ya mpuka ya vaantʉ. ");
INSERT INTO lag_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Aho, vakamuurya Yéesu voosea, “Mukiindya, ʉhʉ mʉʉntʉ muki asháanɨrɨɨrwe yooyeenda na mʉlʉme wa mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Miirwii yiitʉ, Mʉ́sa atʉlairirya tʉmʉvae na mawye fʉʉrʉ akwye mʉʉntʉ muki ja ʉhʉ. Haaha weewe joolɨ woosea?” ");
INSERT INTO lag_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Valʉʉsa jeyyo ja mʉteo sa vapate kɨɨntʉ cho musitakirya. Maa kaa, Yéesu akiinama, maa akaanda tala ɨsɨ na imaamba raachwe. ");
INSERT INTO lag_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ˆVakatuube kumuurya, akiinʉla mʉtwe, maa akavasea, “Ʉmwɨ waanyu ʉra ˆasiina ʉvɨ kati yaanyu, ʉwo ave wa ncholo kʉmʉvaa na iwye ʉhʉ mʉʉntʉ muki.” ");
INSERT INTO lag_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aho, akiinama kei, maa akatala ɨsɨ na imaamba raachwe. ");
INSERT INTO lag_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ˆVakateere jeyyo, vakaanda looka ʉmwɨ ʉmwɨ, vakaanda vawosi. Yéesu akachaala yeemweene na ʉra mʉʉntʉ muki ˆajáa iímire mbere yaachwe. ");
INSERT INTO lag_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yéesu akiinʉla mʉtwe waachwe, akamuurya ʉra mʉʉntʉ muki, “Maáma, hai varɨ vara vaantʉ ˆvaalʉʉsa irya raako?” ");
INSERT INTO lag_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ʉra mʉʉntʉ muki akasea, “Taáta, kusiina baa ʉmwɨ tʉkʉ.” Yéesu ne akamʉsea, “Baa nɨɨnɨ sɨ noolʉʉsa irya raako tʉkʉ. Doma, maa kaa, kwaandɨra isikʉ karɨ ʉtʉ́mamaa ʉvɨ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aho, Yéesu akatuuba lʉʉsɨka na ɨra mpuka ya vaantʉ akavasea, “Nɨɨnɨ noo kɨweerʉ cha weerʉ. Mʉʉntʉ yoyoosi ˆaantúubaa, sɨ arɨ yeendera kilwiiryii vii kaa tʉkʉ, yeeye kʉva arɨ na kɨweerʉ cha nkaasʉ.” ");
INSERT INTO lag_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jeyyo, Mafarisáayo vakamʉsea, “Wootoola ʉshahíidi waako mweeneevyo, sa jeyyo, ʉshahíidi ʉwo sɨ ʉrɨ rʉmɨka tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yéesu akavasea, “Baa koonɨ nootoola ʉshahíidi waanɨ mweeneevyo, ɨkɨ ˆnoolʉʉsa nɨ cha kɨmáárɨ, sa namányire kʉʉntʉ ˆnafuma na kʉʉntʉ ˆnoodoma. Maa kaa, nyuunyu sɨ mʉmányire kʉʉntʉ ˆnafuma na kʉʉntʉ ˆnoodoma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyuunyu mookʉʉndamʉrɨra kwa miiririkano ya vaantʉ. Maa kaa, nɨɨnɨ sɨ noolamʉrɨra mʉʉntʉ yoyoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Baa koonɨ noolamʉrɨra mʉʉntʉ, ʉlamuli waanɨ nɨ wa kɨkomi. Nɨɨnɨ sɨ nalámʉrɨraa mʉʉntʉ nɨɨmweene tʉkʉ, maa kaa, nɨ hamwɨ navíjaa na Taáta. Taáta noo aantʉma. ");
INSERT INTO lag_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Miirwii yaanyu vyaandɨkwa, ʉshahíidi wa vaantʉ vavɨrɨ nɨ wa kɨmáárɨ. ");
INSERT INTO lag_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nɨɨnɨ nootoola ʉshahíidi waanɨ mweeneevyo, na Taáta atóolaa ʉshahíidi mweeri yaanɨ. Yeeye noo aantʉma.” ");
INSERT INTO lag_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aho, maa vakamuurya, “Taáta waanyu hai arɨ?” Yéesu akavasea, “Nyuunyu sɨ mwaamányire nɨɨnɨ tʉkʉ. Na baa kei sɨ mwamʉmányire Taáta waanɨ tʉkʉ. Ngaarɨ mwaamányire nɨɨnɨ, ngaarɨ mwamʉmányire Taáta waanɨ.” ");
INSERT INTO lag_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yéesu alʉʉsa masáare aya, mpɨɨndɨ ˆakiindyáa chúumbii cha kʉʉntʉ ˆvavɨkáa isandúku ra mpía ja Kaaya Njija. Maa kaa, kusiina mʉʉntʉ ˆamʉkwaata tʉkʉ, sa mpɨɨndɨ jaachwe jijáa jikaarɨ fika. ");
INSERT INTO lag_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aho, Yéesu akavasea kei vara Mafarisáayo, “Nɨɨnɨ kiitamanyirya niise, naanyu kʉʉnsaakɨra mʉrɨ, maa kaa, kukwya mʉrɨ na ʉvɨ waanyu. Kʉʉntʉ ˆnootamanya, nyuunyu sɨ mʉrɨ daha fika tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aho, vara Vayahúudi vakaanda kiiyurya, “Eri, nɨ kookiiyʉlaa iise wʉʉ? Ɨkɨ noo ˆchooreka yoosea, ‘Kʉʉntʉ ˆnootamanya, nyuunyu sɨ mʉrɨ daha fika tʉkʉ wʉʉ’?” ");
INSERT INTO lag_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yéesu akavasea, “Nyuunyu mwafuma kʉrɨ ɨhɨ ɨsɨ, na nɨɨnɨ nafuma mweeri. Nyuunyu mʉrɨ va ɨhɨ weerʉ, nɨɨnɨ sɨ ndɨrɨ wa ɨhɨ weerʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɨkɨ noo ˆchooreka noovawyɨɨra, kukwya mʉrɨ na ʉvɨ waanyu. Koonɨ sɨ mookuunduma, ‘Nɨɨnɨ Mwaarɨ,’ kukwya mʉrɨ na ʉvɨ waanyu.” ");
INSERT INTO lag_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aho, vakamuurya Yéesu voosea, “Weewe ʉrɨ ani?” Ne akavasea, “Keende naanda vakiindya, navawyɨɨra nɨɨnɨ ndɨrɨ ani. ");
INSERT INTO lag_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Natɨɨte masáare ˆyarɨ foo yo vawyɨɨra nyuunyu na yo valamʉrɨra. Maa kaa, lʉʉsa ndɨrɨ yara ʉra ˆaantʉma ˆyookuungwyɨɨra ndʉʉse. Yeeye nɨ wa kɨmáárɨ, na nɨɨnɨ niiwyɨ́ɨraa weerʉ kɨra ˆnateera fuma kwaachwe.” ");
INSERT INTO lag_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Avo vaantʉ sɨ vataanga tʉkʉ kɨɨntʉ Yéesu ˆavawyɨɨráa, nɨ masáare ya Taáta waachwe wa kurumwii. ");
INSERT INTO lag_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aho, Yéesu akavasea, “Mʉrɨ hʉmʉla kumwiinʉla na mweeri Mwaana wa Mʉʉntʉ, aho, noo mʉrɨ taanga kʉmba ‘Nɨɨnɨ Mwaarɨ,’ na yoosi ˆnatʉ́mamaa sɨ kwa wiimiriri waanɨ tʉkʉ, maa kaa, nalʉʉsa yara vii Taáta waanɨ ˆaankiindya. ");
INSERT INTO lag_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yeeye aantʉma, kei nɨ hamwɨ arɨ na nɨɨnɨ. Yeeye sɨ aandeka nɨɨmweene tʉkʉ, sa sikʉ joosi natʉ́mamaa yara ˆyamweéryaa mʉtɨma.” ");
INSERT INTO lag_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mpɨɨndɨ Yéesu alʉ́ʉsaa ayo masáare, vaantʉ ˆvarɨ foo vakamuruma. ");
INSERT INTO lag_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aho, Yéesu akavasea Vayahúudi vara ˆvajáa vamurúmire, “Koonɨ mʉkwáatiirye masáare yaanɨ, kɨkomi nyuunyu mʉrɨ vapooji vaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Taanga mʉrɨ kɨmáárɨ, na kɨmáárɨ vabweeyya kɨrɨ mwiiyanjaale.” ");
INSERT INTO lag_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Novo vakamʉsea, “Suusu tʉrɨ vaana va Aburaháamu, na sɨ tʉnaava vatʉ́mwa va mʉʉntʉ yoyoosi tʉkʉ. Haaha joolɨ woosea kwiiyanjaala tʉrɨ?” ");
INSERT INTO lag_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yéesu akavasea, “Kɨmaarɨ kaa noovawyɨɨra, mʉʉntʉ yoyoosi ˆatʉ́mamaa ʉvɨ, ʉwo nɨ mʉtʉ́mwa wa ʉvɨ. ");
INSERT INTO lag_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mʉtʉ́mwa sɨ arɨ ʉmwɨ wa vaantʉ va kaaya ya mweenenyuumba waachwe sikʉ joosi tʉkʉ, maa kaa, mwaana nɨ ʉmwɨ wa vaantʉ va kaaya yaavo kwa sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sa jeyyo, koonɨ Mwaana wa Mʉlʉʉngʉ avachʉ́ngʉrɨɨre, nyuunyu sɨ mʉrɨ kʉva vatʉ́mwa kei tʉkʉ, kwiiyanjaala mʉrɨ kɨkomi. ");
INSERT INTO lag_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Namányire nyuunyu mʉrɨ vaana va Aburaháamu, maa kaa, moosaakɨra nkalo yo kʉʉnjʉlaa sa moosiita ruma ukiindya waanɨ. ");
INSERT INTO lag_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nɨɨnɨ noovawyɨɨra yara ˆnoona kwa Taáta waanɨ. Viivyo, naanyu mootʉmama yara ˆavawyɨɨra taáta waanyu.” ");
INSERT INTO lag_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Novo Vayahúudi vakamʉsea, “Aburaháamu nɨ taáta wiitʉ.” Yéesu akavasea, “Ngaarɨ mʉrɨ vaana va Aburaháamu, ngaarɨ tʉmama mwiise mɨrɨmo ya Aburaháamu. ");
INSERT INTO lag_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Maa kaa, nyuunyu moosaakɨra nkalo yo kʉʉnjʉlaa, baa neembe navawyɨɨra kɨmáárɨ kɨra ˆnateera fuma kwa Mʉlʉʉngʉ. Aburaháamu sɨ abweeyya jeyyo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyuunyu mootʉmama yara ˆatʉ́mamaa taáta waanyu.” Voovo vakamʉsea, “Suusu sɨ vaana va hʉlʉrɨ tʉkʉ, tatɨɨte Taáta ʉmwɨ vii, noo Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yéesu akavasea, “Ngaarɨ Mʉlʉʉngʉ nɨ Taáta waanyu, ngaarɨ mwaanyenda, sa nafuma kwa Mʉlʉʉngʉ. Nɨɨnɨ sɨ nʉʉja kwa lʉvɨro lwaanɨ tʉkʉ, maa kaa, nɨ yeeye noo aantʉma. ");
INSERT INTO lag_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sa che sɨ mootaanga ˆcheene noovawyɨɨra? Sɨ mootaanga tʉkʉ, sa viintʉ musiina lʉvɨro lo teerera masáare yaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nyuunyu taáta waanyu nɨ Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ, na nyuunyu moosaaka tʉmama kɨra rataáta waanyu ˆreenda tʉmama. Rooro nɨ rʉʉlai keende ncholo, na sɨ rɨsáakaa kɨmáárɨ tʉkʉ, sa kɨmáárɨ kisiina mutimii waachwe tʉkʉ. Kati ˆroolʉʉsa ʉloongo, nɨ lʉʉsa riise vira ˆvyeene rɨrɨ, sa rooro nɨ iloongo na ncholo ya ʉloongo. ");
INSERT INTO lag_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Maa kaa, sa viintʉ nɨɨnɨ noovawyɨɨra kɨmáárɨ, nyuunyu sɨ mookuunduma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nɨ ani katɨ na katɨ yaanyu kɨkomi arɨ koonekya nɨɨnɨ natɨɨte ʉvɨ? Koonɨ aya ˆnoovawyɨɨra nɨ ya kɨkomi, sa che sɨ mookuunduma? ");
INSERT INTO lag_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mʉʉntʉ wa Mʉlʉʉngʉ atéeraa masáare ya Mʉlʉʉngʉ. Kɨɨntʉ choobweeyya musiindwe teera kɨra Mʉlʉʉngʉ ˆalʉʉsa, nɨ sa viintʉ sɨ mʉrɨ va Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aho, Vayahúudi vakamʉsea Yéesu, “Eri, kati ˆtoosea ʉrɨ Mʉsamaría na watɨɨte murimʉ mʉvɨ, sɨ talʉ́ʉsaa kɨmáárɨ tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yéesu akavasea, “Nɨɨnɨ nsiina murimʉ mʉvɨ tʉkʉ. Nɨɨnɨ namʉnyémyaa Taáta waanɨ, maa kaa, nyuunyu sɨ mwaanyémyaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nɨɨnɨ sɨ noosaakɨra nkongojima yaanɨ tʉkʉ, maa kaa, amwaarɨ ˆmweene yoosaaka nɨɨnɨ nyemiwe, na yeeye noo mʉlamuli. ");
INSERT INTO lag_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kɨmaarɨ kaa noovawyɨɨra, mʉʉntʉ yoyoosi ʉra ˆarɨ kwaatya masáare yaanɨ, ʉwo sɨ arɨ kukwya vii kaa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Aho, Vayahúudi vakamʉsea, “Haaha tatáangire watɨɨte murimʉ mʉvɨ. Aburaháamu aakwya, viivyo baa valáali na mʉtwe va Ijʉva, atɨ weewe woosea, ‘Mʉʉntʉ ˆarɨ teera masáare yaanɨ sɨ arɨ kukwya tʉkʉ?’ ");
INSERT INTO lag_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Eri, weewe ʉrɨ mʉkʉʉlʉ kʉlookya taáta wiitʉ Aburaháamu wʉʉ? Yeeye aakwya, baa valáali na mʉtwe novo vaakwya. Ivi weewe wookiisea ʉrɨ ani?” ");
INSERT INTO lag_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yéesu akavasea, “Koonɨ nookiibweeyyirya nkongojima nɨɨnɨ mweeneevyo, nkongojima yaanɨ isiina kɨɨntʉ tʉkʉ. Maa kaa, ˆaanyínʉlaa nɨɨnɨ, nɨ Taáta waanɨ, nyuunyu ˆmoosea nɨ Mʉlʉʉngʉ waanyu. ");
INSERT INTO lag_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Baa haaha, nyuunyu sɨ mʉnamʉtaanga Mʉlʉʉngʉ tʉkʉ, maa kaa, nɨɨnɨ namʉmányire. Koonɨ naséire sɨ namʉmányire tʉkʉ, kʉva ndɨrɨ mʉloongo ja nyuunyu. Maa kaa, nɨɨnɨ namʉmányire na isáare raachwe narɨkwaatya. ");
INSERT INTO lag_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Taáta waanyu Aburaháamu ajáa avyeenda maatʉkʉ kʉtaanga nɨɨnɨ kʉʉja ndɨrɨ. Ɨyo sikʉ ɨɨyɨɨ́ne, maa akavyeenda.” ");
INSERT INTO lag_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aho, Vayahúudi vakamʉsea, “Weewe baa sɨ ʉnafikya myaaka makumi yasaano (50) tʉkʉ, joolɨ de wamoona Aburaháamu?” ");
INSERT INTO lag_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yéesu akavasea, “Kɨmaarɨ kaa noovawyɨɨra, Aburaháamu sɨ anavyaalwa, ‘Nɨɨnɨ Mwaarɨ.’” ");
INSERT INTO lag_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Vayahúudi ˆvakateere jeyyo, maa vakatoola mawye voosaaka vamʉvae Yéesu. Yéesu akiivisa, maa akafuma aho Kaayii Njija. ");
INSERT INTO lag_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sikʉ ɨmwɨ mpɨɨndɨ Yéesu ˆalookáa, akamoona mʉʉntʉ ʉmwɨ ˆajáa mʉhoku keende kʉvyaalwa kwaachwe. ");
INSERT INTO lag_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vapooji vaachwe vakamuurya, “Mukiindya, nɨ ani ˆatʉmama ʉvɨ fʉʉrʉ ʉhʉ avyaalwe mʉhoku? Nɨ yeeye bakʉ vavyɨɨrɨ vaachwe?” ");
INSERT INTO lag_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yéesu akavasea, “Sɨ yeeye tʉkʉ na sɨ vavyɨɨrɨ vaachwe ˆvatʉmama ʉvɨ tʉkʉ. Avyaalwa mʉhoku sa mɨrɨmo ya Mʉlʉʉngʉ ɨvariyʉlwe mwiikalwii waachwe aha weerwii. ");
INSERT INTO lag_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mʉlʉʉngʉ aantʉma. Viintʉ ˆkʉkaarɨ namuusi, nɨ mpaka tʉtʉmame mɨrɨmo yaachwe. Uchikʉ kʉʉja wiise, mpɨɨndɨ ijo, sɨ tʉrɨ daha tʉmama tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mpɨɨndɨ ˆnkaarɨ aha weerwii, nɨɨnɨ nɨ kɨweerʉ cha weerʉ.” ");
INSERT INTO lag_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yéesu ˆakalʉʉse jeyyo, akachwa matɨ ɨsɨ, akabweeyya fitoe na yara matɨ, maa akamʉhaka ʉra mʉhoku miiswii. ");
INSERT INTO lag_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Aho, akamʉsea, “Tamanya ʉkoowe iduundwii ra Siloáamu.” Siloáamu noo kʉsea “vaantʉ ˆvatʉmwa.” Aho, ʉra mʉhoku akatamanya noo koowa, akahɨndʉka kʉnʉ yookoona. ");
INSERT INTO lag_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Vakaaya vaachwe na vaantʉ ˆvajáa vamoona aho ncholo yooloomba, vakaanda kiiyurya voosea, “Eri, ʉhʉ sɨ ʉra mʉʉntʉ ˆiikaláa aha no loomba tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vamwɨ vaavo vakasea, “Nɨ yeeye.” Vɨɨngɨ vakasea, “Sɨ yeeye tʉkʉ nɨ iifwɨ́ɨne vii.” Maa kaa, ʉwo mʉʉntʉ akavasea, “Nɨ nɨɨnɨ.” ");
INSERT INTO lag_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Maa kaa, voovo vakaanda muurya, “Joolɨ vyavɨ́ɨre amwɨ miiso yaako yookoona?” ");
INSERT INTO lag_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ne akavasea, “Mʉʉntʉ ˆaséwaa Yéesu, abwéeyyiirye fitoe na matɨ yaachwe, akaampaka miiswii, maa akaansea, ‘Tamanya na Siloáamu ʉkooyye kisho chaako.’ Na ˆnkooyye kisho, maa nkaanda koona.” ");
INSERT INTO lag_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Avo vaantʉ vakamuurya, “Ʉwo mʉʉntʉ hai arɨ?” Ʉra mʉhoku akavasea, “Iyaʉ.” ");
INSERT INTO lag_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aho, avo vaantʉ vakamʉtwaala ʉwo mʉʉntʉ ˆajáa mʉhoku aho ncholo na kwa Mafarisáayo. ");
INSERT INTO lag_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sikʉ Yéesu ˆajáa abweeyya fitoe na akamʉhorya ʉra mʉhoku, nɨ sikʉ ya Sabáato ɨjáa. ");
INSERT INTO lag_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jeyyo, Mafarisáayo vakaanda muurya kei ˆvyeene ajáa ahóriiwe. Ne akavasea, “Aampákire fitoe miiswii, nkooyya kisho, na haaha nookoona.” ");
INSERT INTO lag_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Vamwɨ va Mafarisáayo vakasea, “Ʉhʉ mʉʉntʉ sɨ afuma kwa Mʉlʉʉngʉ tʉkʉ, sa sɨ yookɨɨnyemya Sabáato tʉkʉ.” Maa kaa, vɨɨngɨ vakasea, “Joolɨ mʉʉntʉ mʉvɨ arɨ daha bweeyya isháara na myuujíisa ja ɨhɨ?” Aho, maa vakiigava voovo kwa voovo. ");
INSERT INTO lag_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jeyyo, Mafarisáayo vakamuurya kei ʉra mʉhoku voosea, “Weewe noo ˆʉhóriiwe miiso nɨ ʉra mʉʉntʉ, joolɨ woosea kwa ʉwo mʉʉntʉ?” Yeeye akasea, “Ʉra nɨ mʉláali na mʉtwe wa Ijʉva.” ");
INSERT INTO lag_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Vara Vayahúudi sɨ varuma koonɨ ʉwo mʉʉntʉ aho ncholo ajáa mʉhoku tʉkʉ. Kukiimikirirya, vakavaanɨɨrɨra vavyɨɨrɨ va ʉra mʉhoku. ");
INSERT INTO lag_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Vakavuurya, “Eri, ʉhʉ nɨ mwaana waanyu nyuunyu ˆmoosea ajáa avyaalwa mʉhoku wʉʉ? Koonɨ moosea jeyyo, joolɨ haaha yookoona?” ");
INSERT INTO lag_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Vavyɨɨrɨ vaachwe vakavasea, “Nɨ kɨmáárɨ ʉhʉ nɨ mwaana wiiswi na nɨ kɨmáárɨ ajáa avyaalwa mʉhoku. ");
INSERT INTO lag_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Maa kaa, sɨ tootaanga nɨ joolɨ aándire koona tʉkʉ, na baa sɨ tootaanga nɨ ani ˆamʉhóriirye tʉkʉ. Muuryi mweeneevyo, sɨ musinga tʉkʉ, lʉʉsa arɨ mweeneevyo.” ");
INSERT INTO lag_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Vavyɨɨrɨ vaachwe vajáa valʉʉsa jeyyo, sa voofáa Vayahúudi. Vayahúudi vajáa vasea, koonɨ mʉʉntʉ amurúmire Yéesu noo Masía, kibiriwa arɨ fuma sinagóogii. ");
INSERT INTO lag_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Noo ˆchooreka vavyɨɨrɨ vaachwe vajáa vasea, “Muuryi mweeneevyo, sɨ musinga tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aho, vakʉ́ʉ́lʉ va Vayahúudi vakamwaanɨrɨra lwa kavɨrɨ ʉra ˆajáa mʉhoku vakamʉsea, “Mʉheere Mʉlʉʉngʉ nkongojima koonɨ nɨ kɨmáárɨ woolʉʉsa! Suusu tamányire ʉhʉ mʉʉntʉ ˆakʉhóriirye nɨ mʉvɨ.” ");
INSERT INTO lag_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Maa yeeye akavasea, “Nɨɨnɨ sɨ namányire koonɨ nɨ mʉvɨ tʉkʉ. Kɨɨntʉ kimudu ˆnamányire nɨ ɨkɨ, nɨɨnɨ nɨ mʉhoku nɨjáa, na haaha nookoona.” ");
INSERT INTO lag_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Maa vakamuurya, “Che ʉwo mʉʉntʉ akʉbwéeyyiriirye? Joolɨ akʉtʉ́ʉnʉkwɨɨre miiso yaako?” ");
INSERT INTO lag_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ʉra ˆajáa mʉhoku akavasea, “Nahʉ́mwɨɨre vawyɨɨra, naanyu sɨ mookʉʉnteerera tʉkʉ. Sa che moosaaka nɨvawyɨɨre kei? Eri, saaka mwiise mʉve vapooji vaachwe wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aho, vakamʉtʉkɨra voomʉsea, “Weewe noo mʉpooji waachwe, suusu tʉrɨ vapooji va Mʉ́sa. ");
INSERT INTO lag_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tamányire Mʉlʉʉngʉ alʉʉsɨka na Mʉ́sa, maa kaa, sɨ tamányire ʉhʉ mʉʉntʉ kʉʉntʉ ˆafuma tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ʉra ˆajáa mʉhoku akavasea, “Ɨkɨ nɨ kɨɨntʉ cho hwaalarya! Atɨ sɨ mʉmányire kʉʉntʉ ˆafuma tʉkʉ, maa kaa, aantʉ́ʉnʉkwɨɨre miiso yaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tamányire Mʉlʉʉngʉ sɨ atéeraa kʉloomba kwa vavɨ tʉkʉ, yeeye atéeraa kʉloomba kwa voosi ˆvamʉnyémyaa na ˆvatʉ́mamaa kɨra ˆasáakaa. ");
INSERT INTO lag_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Keende weerʉ yʉʉmbwa, sɨ tʉnateera mʉʉntʉ amʉhóriirye mʉʉntʉ ˆavyaalwa mʉhoku tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ngaarɨ ʉhʉ mʉʉntʉ sɨ afuma kwa Mʉlʉʉngʉ, ngaarɨ sɨ adáhire tʉmama chochoosi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Novo vakamʉsea, “Weewe wavyaalwa na warerwa uvii. Eri, watɨɨte lʉvɨro lo tukiindya suusu wʉʉ?” Aho, maa vakamukibirya na weerwii. ");
INSERT INTO lag_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yéesu akateera vajáa vamukíbiirye ʉra mʉʉntʉ fuma sinagóogii. Yéesu akamʉshaana maa akamuurya, “Eri, muruma wiise Mwaana wa Mʉʉntʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ʉra mʉʉntʉ akamuurya Yéesu, “Mʉkʉ́lʉ, ʉhʉ mʉʉntʉ nɨ ani? Ngwyɨɨra sa nɨɨnɨ nimurume.” ");
INSERT INTO lag_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yéesu akamʉsea, “Wamwɨɨ́ne, noo ʉhʉ ˆyoolʉʉsɨka na weewe.” ");
INSERT INTO lag_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ʉra mʉʉntʉ akasea, “Mʉkʉ́lʉ, narúmire.” Aho, maa akamwiinamɨra Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yéesu akamʉsea, “Nɨɨnɨ nʉʉja na aha weerwii jo lamʉrɨra, sa vahoku voone na vara ˆvoónaa vave vahoku.” ");
INSERT INTO lag_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kʉjáa kwatɨɨte Mafarisáayo vamwɨ ˆvajáa heehi na Yéesu ˆvakateere jeyyo, maa vakamʉsea, “Atɨ, baa suusu tʉrɨ vahoku wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yéesu akavasea, “Ngaarɨ mʉrɨ vahoku, ngaarɨ musiina ʉvɨ tʉkʉ, maa kaa, sa viintʉ moosea koona mwiise, mʉkaarɨ mʉrɨ na ʉvɨ.” ");
INSERT INTO lag_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Kɨmaarɨ kaa noovawyɨɨra, mʉʉntʉ yoyoosi koonɨ sɨ ɨɨ́ngɨɨre na waámii ya muundi ko tweera na mutiryaangwii, maa kaa, ɨɨngɨre ko tweera na haantʉ hɨɨngɨ, ʉwo nɨ mwiívi na mʉhóki. ");
INSERT INTO lag_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mʉʉntʉ ˆɨɨ́ngɨraa ko tweera na mutiryaangwii, ʉwo noo muríisi wa muundi. ");
INSERT INTO lag_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mʉlaangiriryi wa mutiryaango amʉyʉ́ʉrɨraa, na muundi jatéeraa sawúti yaachwe. Aánɨrɨraa muundi jaachwe kwa marina yaavo, na ajifúmyaa na weerwii. ");
INSERT INTO lag_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ˆArɨ hʉmʉla kujifumya muundi jaachwe na weerwii, ajilóngoreraa na muundi jaachwe jamutúubaa sa jamányire sawúti yaachwe. ");
INSERT INTO lag_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ijo muundi, sɨ jiri mutuuba mʉyeni tʉkʉ, maa kaa, mʉtɨɨja jiri sa sɨ jamányire sawúti yaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yéesu avawyɨɨra lusímo ʉlʉ, maa kaa, sɨ vataanga tʉkʉ ˆcheene alʉʉsáa. ");
INSERT INTO lag_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aho, Yéesu akavasea kei, “Kɨmaarɨ kaa noovawyɨɨra, nɨɨnɨ noo mutiryaango wa muundi. ");
INSERT INTO lag_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Voosi vara ˆvalongoola kʉva varíisi va muundi mpɨɨndɨ nɨɨnɨ ˆnɨjáa nkaarɨ kʉʉja, avo nɨ viívi na vahóki, muundi sɨ ja vateera tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nɨɨnɨ noo mutiryaango. Mʉʉntʉ yoyoosi ˆarɨ kɨɨngɨra na waámii ko tweera kʉrɨ nɨɨnɨ, lamuririwa arɨ, kɨɨngɨra arɨ na fuma arɨ, na turya arɨ uríisi ˆwabooha. ");
INSERT INTO lag_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwiívi ʉʉ́jaa sa iive, ʉʉlae au asaambʉle. Maa kaa, nɨɨnɨ nʉʉja sa muundi jive nkaasʉ na jive na ɨyo nkaasʉ ˆyakiimana. ");
INSERT INTO lag_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nɨɨnɨ ndɨrɨ muríisi mʉʉja. Muríisi mʉʉja atóolaa nkaasʉ yaachwe sa muundi jaachwe. ");
INSERT INTO lag_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mʉtʉmami ʉra sɨ ˆarɨ muríisi wa muundi, na kei muundi sɨ ˆjiri jaachwe, ʉwo arɨ koona mbʉʉjɨ yookʉʉja, tɨɨja arɨ na jireka arɨ muundi. Mbʉʉjɨ yakɨ́ɨmɨrɨraa ikukikuki ra muundi na jɨɨngɨ jiípasaa. ");
INSERT INTO lag_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mʉtʉmami atɨ́ɨjaa, sa sɨ iitwéetyaa sa muundi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nɨɨnɨ ndɨrɨ muríisi mʉʉja. Na namányire muundi jaanɨ na muundi jaanɨ jaamányire nɨɨnɨ, ");
INSERT INTO lag_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ja ˆvyeene Taáta aamányire nɨɨnɨ, na nɨɨnɨ namʉmányire Taáta. Kei, nɨɨnɨ nootoola nkaasʉ yaanɨ sa muundi jaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Natɨɨte muundi jɨɨngɨ sɨ ˆjiri ja ɨhɨ waama. Nɨ mpaka nijireete, nojo jiteere sawúti yaanɨ. Jeyyo, jive ufya ʉmwɨ na muríisi ʉmwɨ. ");
INSERT INTO lag_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Taáta waanɨ aanyenda nɨɨnɨ sa nootoola nkaasʉ yaanɨ sa nɨɨpate kei. ");
INSERT INTO lag_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kusiina mʉʉntʉ ˆarɨ daha kʉʉmpoka nkaasʉ yaanɨ tʉkʉ, maa kaa, nɨɨnɨ noo nookɨɨtoola nkaasʉ yaanɨ ko keenda. Nɨɨnɨ natɨɨte wiimiriri wo toola nkaasʉ yaanɨ, na kei natɨɨte wiimiriri wo va nkaasʉ kei. Nɨ Taáta waanɨ mweeneevyo noo ˆaandairirya mbweeyye jeyyo.” ");
INSERT INTO lag_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sa ayo masáare, Vayahúudi vakiigava. ");
INSERT INTO lag_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ˆVarɨ foo vaavo vakasea, “Ʉhʉ mʉʉntʉ atɨɨte murimʉ mʉvɨ na nɨ mʉsari. Sa che toomʉteerera?” ");
INSERT INTO lag_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Vɨɨngɨ vakasea, “Aya sɨ masáare ya mʉʉntʉ ˆarɨ na murimʉ mʉvɨ tʉkʉ. Eri, murimʉ mʉvɨ daha ʉrɨ tʉʉnʉkʉla miiso ya vahoku wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Haaha, ʉko Yerusaléemu kʉjáa kwatɨɨte ngovi yo talarya Kaaya Njija ya Ijʉva, na nɨ mpɨɨndɨ ja mpeho jijáa. ");
INSERT INTO lag_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yéesu nɨ Kaayii Njija ajáa, na akava yooyeenda waámii ˆʉséwaa Waama wa Solomóoni. ");
INSERT INTO lag_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Vayahúudi vajáa aho, vakamʉrɨɨngɨrɨra, maa vakamuurya Yéesu voosea, “Fʉʉrʉ naadi ʉrɨ tuuba kutulumya mɨtɨma? Tʉwyɨɨre ilaarii, koonɨ weewe noo Masía.” ");
INSERT INTO lag_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yéesu akavasea, “Nahʉmʉla vawyɨɨra, na nyuunyu sɨ mooruma tʉkʉ. Masáare ˆmeene noobweeyya kwa irina ra Taáta yookoonekya nɨɨnɨ ndɨrɨ ani. ");
INSERT INTO lag_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Maa kaa, sɨ mooruma tʉkʉ, sa sɨ mʉrɨ va ikukikuki ra muundi jaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Muundi jaanɨ jatéeraa sawúti yaanɨ. Nɨɨnɨ najimányire na jaantúubaa. ");
INSERT INTO lag_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nɨɨnɨ najihéeraa nkaasʉ ya sikʉ ˆjisiina ʉhero, na sɨ jiri rɨmɨra vii kaa tʉkʉ. Kei kusiina mʉʉntʉ ˆarɨ daha kʉʉmpoka fuma mɨkonwii yaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taáta waanɨ yeeye aampeera iji muundi, nɨ mʉkʉʉlʉ kʉlookya voosi, na kusiina ˆarɨ daha kʉmʉhoka fuma mɨkonwii yaachwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nɨɨnɨ na Taáta, nɨ ʉmwɨ!” ");
INSERT INTO lag_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aho, maa Vayahúudi vakatoorera mawye kei voosaaka vamʉvae fʉʉrʉ akwye. ");
INSERT INTO lag_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Maa kaa, Yéesu akavasea, “Navoónekiirye mɨrɨmo miija ˆɨrɨ foo fuma kwa Taáta. Nɨ sa kɨrɨkwɨ moosaaka kʉʉnvaa na mawye mʉʉnjʉlae?” ");
INSERT INTO lag_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Vayahúudi vakamʉsea, “Sɨ tookʉvaa na mawye sa mɨrɨmo miija ˆwootʉmama tʉkʉ, maa kaa, nɨ sa uhiintiki waako kwa Mʉlʉʉngʉ. Weewe ʉrɨ mʉʉntʉ vii, wookiibweeyya ʉrɨ Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yéesu akavasea, “Eri, sɨ vyaandɨkwa Miirwii yaanyu, ‘Nɨɨnɨ nasea, nyuunyu nɨ mɨlʉʉngʉ’ tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Koonɨ avaanɨrɨra mɨlʉʉngʉ vara ˆvahokera isáare raachwe, na isáare ra Mʉlʉʉngʉ nɨ ra kɨkomi sikʉ joosi, ");
INSERT INTO lag_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","eri, sa che moosea noomʉhɨɨntɨkɨra Mʉlʉʉngʉ kati noosea, ‘Nɨɨnɨ ndɨrɨ Mwaana wa Mʉlʉʉngʉ?’ Taáta noo ˆaantalarya na ˆaantʉma kʉrɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Koonɨ sɨ nootʉmama mɨrɨmo ya Taáta waanɨ, reki kuunduma. ");
INSERT INTO lag_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Maa kaa, koonɨ nootʉmama mɨrɨmo ya Taáta, baa koonɨ sɨ mookuunduma nɨɨnɨ, rumi ɨyo mɨrɨmo. Kwa njɨra ɨyo, taanga mʉrɨ na tuuba mʉrɨ taanga, Taáta na nɨɨnɨ, kei nɨɨnɨ na Taáta, nɨ kɨɨntʉ kɨmwɨ.” ");
INSERT INTO lag_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vayahúudi ˆvakateere ayo, maa vakayera kʉmʉkwaata kei, maa kaa, akavahonyoka mɨkonwii yaavo. ");
INSERT INTO lag_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yéesu akadoma na fɨrɨro ya lʉʉjɨ lwa Yorodáani, fʉʉrʉ hara haantʉ Yooháani Mʉbatisáaji ˆabatisiryáa vaantʉ hara mbere, maa akiikala ʉko. ");
INSERT INTO lag_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Vaantʉ ˆvarɨ foo vakʉʉja na kwa Yéesu, maa vandoosea, “Yooháani sɨ abweeyya isháara tʉkʉ, maa kaa, kɨra isáare ˆalʉʉsa kwa ʉhʉ mʉʉntʉ nɨ ra kɨmáárɨ.” ");
INSERT INTO lag_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aho, vaantʉ ˆvarɨ foo vajáa aho, vakamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆaséwaa Lasáaro, mʉʉntʉ wa iturii ra Besanía. Ʉhʉ Lasáaro ajáa alwaala. Marʉʉmbʉ yaachwe Maríia na Maárita novo viikaláa iturii ra Besanía. ");
INSERT INTO lag_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ʉhʉ Maríia noo ˆajáa amʉhaka Yéesu makuta ˆyanyʉkɨra, na akamʉhonola majeo na njwɨɨrɨ jaachwe. ");
INSERT INTO lag_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jeyyo, Maríia na Maárita marʉʉmbʉ ya Lasáaro, vakatʉma mʉlomo na kʉrɨ Yéesu voomʉsea, “Mʉkʉ́lʉ, kɨjeengi chaako ˆwamweenda nɨ mʉlwɨ́ɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Maa kaa, Yéesu ˆakateere ayo, akasea, “Ʉlwɨ́ɨrɨ ʉhʉ sɨ ʉrɨ reeta inkwya tʉkʉ, nɨ so mʉretera Mʉlʉʉngʉ nkongojima, na kwa njɨra ɨyo, Mwaana wa Mʉlʉʉngʉ abweeyyiriwe nkongojima.” ");
INSERT INTO lag_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yéesu ajáa aveenda maatʉkʉ vii vala Maárita, Maríia na irʉʉmbʉ raavo Lasáaro. ");
INSERT INTO lag_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jeyyo, ˆakateere Lasáaro nɨ mʉlwɨ́ɨrɨ, akiikala aho haantʉ ˆajáa kwa sikʉ ivɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sikʉ ivɨrɨ ˆjikalooke, maa akavasea vapooji vaachwe, “Hendi tʉhɨndʉke na Yudéea.” ");
INSERT INTO lag_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Vapooji vaachwe vakamʉsea, “Mukiindya, amwɨ nɨ ɨra sikʉ vii Vayahúudi vasaakáa kʉkʉvaa na mawye ukwye. Na haaha woosaaka hɨndʉka nooko kei?” ");
INSERT INTO lag_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yéesu akavasea, “Eri, sikʉ sɨ ɨtɨɨte masaa ikimi na yavɨrɨ ya muusi tʉkʉ wʉʉ? Mʉʉntʉ koonɨ yooyeenda namuusi sɨ arɨ kiikunguvarya kʉʉlʉ kwaachwe tʉkʉ, sa koona iise kɨweerʉ cha ɨhɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Maa kaa, koonɨ mʉʉntʉ yooyeenda nuuchikʉ, kunguvala arɨ, sa asiina kɨweerʉ isii yaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ˆAkahʉmʉle lʉʉsa aya, Yéesu akavasea, “Kɨjeengi chiiswi Lasáaro alɨ́ɨre, maa kaa, nɨ tamanya niise nkamwiinukye.” ");
INSERT INTO lag_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Vapooji vaachwe vakamʉsea, “Mʉkʉ́lʉ, koonɨ alɨ́ɨre tʉlo, hola arɨ.” ");
INSERT INTO lag_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kɨɨntʉ Yéesu ˆalʉʉsáa aha nɨ inkwya ya Lasáaro, maa kaa, vapooji sɨ vataangáa tʉkʉ, viiseáa kɨra ˆyoolʉʉsa kʉrɨ Lasáaro nɨ alɨ́ɨre tʉlo vii. ");
INSERT INTO lag_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sa jeyyo, Yéesu akavawyɨɨra pusu, “Lasáaro akwíire. ");
INSERT INTO lag_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Baa neembe nɨ jeyyo, navyeéndire sa nyuunyu, sa viintʉ naarɨ nsiina kʉra mpɨɨndɨ Lasáaro ˆaakukwya, sa mʉdahe kuunduma. Haaha hendi na kwaachwe.” ");
INSERT INTO lag_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Aho, mʉpooji waachwe ʉmwɨ ˆasewáa Tomáasi, irina rɨɨngɨ vamwaanɨrɨráa Maása, akavasea viivaachwe, “Hendi baa suusu, tʉkakwye hamwɨ ne.” ");
INSERT INTO lag_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yéesu ˆakafike ʉko Besanía, akashaana Lasáaro avéerɨɨre mbiríírii kwa sikʉ ine. ");
INSERT INTO lag_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ituri ra Besanía nɨ heehi rɨjáa na múuji wa Yerusaléemu, ja ʉlɨ́ɨ́hɨ wa kilomíita itatʉ. ");
INSERT INTO lag_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Vayahúudi ˆvarɨ foo vajáa vuújire noo vafɨɨta vala Maárita na Maríia, sa viintʉ vajáa vawúlarɨɨrwe nɨ irʉʉmbʉ raavo Lasáaro. ");
INSERT INTO lag_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maárita ˆakateere Yéesu amwaarɨ yookʉʉja, akatamanya noo musingirirya. Maa kaa, Maríia akachaala kaayii. ");
INSERT INTO lag_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maárita akamʉsea Yéesu, “Mweenevyoosi, ngaarɨ waarɨ ʉmwaarɨ aha, ngaarɨ irʉʉmbʉ raanɨ sɨ akwíire tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Maa kaa, taanga niise baa haaha kɨɨntʉ chochoosi ˆʉrɨ mʉloomba Mʉlʉʉngʉ, kʉheera arɨ.” ");
INSERT INTO lag_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yéesu akamʉsea, “Irʉʉmbʉ raako fʉfʉka arɨ.” ");
INSERT INTO lag_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maárita akamʉsea, “Namányire sikʉ ya ʉhero wa weerʉ fʉfʉka arɨ.” ");
INSERT INTO lag_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yéesu akamʉsea, “Nɨɨnɨ noo ʉwo ʉfʉfʉ́ʉko na nkaasʉ. Yoyoosi ˆaandúmaa nɨɨnɨ baa neembe arɨ kukwya, kʉva arɨ nkaasʉ. ");
INSERT INTO lag_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na yoyoosi ˆarɨ mooyo na ˆaandúmaa nɨɨnɨ sɨ arɨ kukwya vii kaa tʉkʉ. Eri, yaruma wiise aya wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maárita akamʉsea, “Mweenevyoosi naruma weewe noo Masía Mwaana wa Mʉlʉʉngʉ, ʉra ˆyookʉʉja na kʉrɨ weerʉ.” ");
INSERT INTO lag_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maárita ˆakahʉmʉle lʉʉsa ayo, akatamanya noo mwaanɨrɨra mwaanaavo Maríia na ivarwii, akamʉsea, “Mukiindya amwaarɨ aha yookwaanɨrɨra.” ");
INSERT INTO lag_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maríia ˆakateere jeyyo, akiinʉka chaangʉ, maa akatamanya na kwa Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yéesu ajáa akaarɨ kɨɨngɨra na iturii, ajáa akaarɨ hara haantʉ Maárita ˆajáa amʉshɨ́hɨɨne. ");
INSERT INTO lag_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Vara Vayahúudi ˆvajáa na Maríia kaayii vuújire noo mʉfɨɨta, ˆvakoone iínukire chaangʉ, maa akafuma na weerwii, vakamutuuba sa viiseáa nɨ tamanya iise na mbiríírii noo rɨra. ");
INSERT INTO lag_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maríia ˆakafike hara haantʉ ˆajáa Yéesu na ˆakamoone Yéesu, akachwaama majewii yaachwe kʉnʉ yoosea, “Mweenevyoosi, ngaarɨ waarɨ aha, ngaarɨ irʉʉmbʉ raanɨ sɨ akwíire tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yéesu ˆakamoone Maríia yoorɨra, na ˆakoone na vara Vayahúudi ˆvajáa vamutúubire novo voorɨra, akiiteera ʉsʉʉngʉ mutimii, maa akavisʉʉla. ");
INSERT INTO lag_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aho, akavuurya, “Hai mʉmʉtaahɨɨré?” Vakamʉsea, “Mweenevyoosi, yeenda tʉkoonekye.” ");
INSERT INTO lag_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aho, Yéesu akaanda rɨra. ");
INSERT INTO lag_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Vayahúudi vakasea, “Laangi ta viintʉ ˆajáa amweenda Lasáaro!” ");
INSERT INTO lag_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Maa kaa, vɨɨngɨ vakasea, “Eri, ʉhʉ sɨ noo ʉra ˆamʉhorya mʉhoku, sa che sɨ adaha kɨtɨra Lasáaro adɨɨre kukwya?” ");
INSERT INTO lag_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yéesu kʉnʉ aviswɨ́ɨre mutimii, akafika mbiríírii. Ɨyo mbɨrɨ́ɨ́ra nɨ ya mpaanga ɨjáa, na ɨjáa yakʉnɨkɨrɨrwa na iwye ikʉʉlʉ mʉryaangwii. ");
INSERT INTO lag_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yéesu akavasea, “Seyyi iwye mʉryaangwii.” Maárita, irʉʉmbʉ ra ʉhʉ ˆajáa awʉ́lɨɨre, akasea, “Aaɨ aándire nyuka, sa avéerɨɨre mbiríírii kwa sikʉ ine.” ");
INSERT INTO lag_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yéesu akamʉsea Maárita, “Sɨ nakʉséire koonɨ wooruma koona ʉrɨ nkongojima ya Mʉlʉʉngʉ tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aho, vakarɨseyya rɨra iwye. Yéesu akalaanga kurumwii, maa akasea, “Taáta, kuusa sa waantéɨɨre. ");
INSERT INTO lag_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Namányire weewe waantéeraa mpɨɨndɨ joosi, maa kaa, nɨ lʉʉsa niise aya, sa ɨhɨ mpuka ya vaantʉ ˆɨrɨ aha irume weewe noo ˆwaantʉma.” ");
INSERT INTO lag_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ˆAkalʉʉse jeyyo, akaanɨrɨra na sawúti nkʉʉlʉ yoosea, “Lasáaro, fuma na weerwii!” ");
INSERT INTO lag_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasáaro akafuma kʉnʉ mɨkono yaachwe na mawʉlʉ yaachwe yafárɨmbɨrɨɨrwe ntaamɨ ja sáanda ya kɨtáani. Kei da kisho chaachwe kɨjáa chafárɨmbɨrɨɨrwe na ntaamɨ njerʉ. Yéesu akavasea, “Muchunguli, na mʉreki iitamanyirye.” ");
INSERT INTO lag_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jeyyo, Vayahúudi ˆvarɨ foo vara ˆvajáa vuújire noo mʉfɨɨta Maríia, na ˆvajáa voona yara Yéesu ˆajáa abwéeyyiirye, maa vakamuruma. ");
INSERT INTO lag_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Maa kaa, vamwɨ vaavo vakatamanya na kwa Mafarisáayo noo vawyɨɨra yara Yéesu ˆajáa atʉ́mamire. ");
INSERT INTO lag_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sa jeyyo, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na Mafarisáayo vakaanɨrɨra Balása Nkʉʉlʉ ya Vayahúudi, maa vakasea, “Joolɨ tʉrɨ bweeyya? Ʉhʉ mʉʉntʉ yoobweeyya isháara na myuujíisa ˆɨrɨ foo. ");
INSERT INTO lag_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Koonɨ tamʉrékɨɨre atuube bweeyya jei, vaantʉ voosi muruma varɨ, na Varúumi kʉʉja varɨ, na saambʉla varɨ ɨsɨ yiitʉ na Kaaya yiitʉ Njija.” ");
INSERT INTO lag_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ʉmwɨ waavo ˆasewáa Kayáafa ˆajáa mweeneɨsɨ mʉkʉʉlʉ mwaaka ʉwo, akavasea, “Nyuunyu sɨ mʉmányire kɨɨntʉ tʉkʉ! ");
INSERT INTO lag_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Eri, sɨ mookoona nɨ vyabooha mʉʉntʉ ʉmwɨ kukwya sa vaantʉ, kʉlookya vaantʉ va ɨsɨ yoosi kusira imalo tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayáafa sɨ alʉʉsa masáare aya ko keenda kwaachwe tʉkʉ. Maa kaa, yeeye noo ajáa mweeneɨsɨ mʉkʉʉlʉ mwaaka ʉwo, sa jeyyo, nɨ laala alaaláa na mʉtwe Yéesu kukwya arɨ sa ɨsɨ ya Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na sɨ sa ɨsɨ ya Vayahúudi veene vii tʉkʉ, maa kaa, sa avajiinge vaana voosi va Mʉlʉʉngʉ ˆviipasa, vave hamwɨ. ");
INSERT INTO lag_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kwaandɨra sikʉ ɨyo, vakarya nchuungo yo mʉʉlaa Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sa jeyyo, Yéesu akareka yeenda ko kiiyonekya kwa Vayahúudi. Akiinʉka aho, akatamanya na ituri ˆraséwaa Efʉraímʉ, ˆrɨrɨ heehi na ɨsɨ ya ibaláángʉ. Akiikala ʉko hamwɨ na vapooji vaachwe. ");
INSERT INTO lag_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ngovi ya Vayahúudi ɨséwaa Paásika, ɨjáa yaséngerɨɨre, vaantʉ ˆvarɨ foo vakaambʉka na Yerusaléemu fuma maturii, vakatamanya noo kiijirʉla ngovi ɨyo sɨ ɨnafika. ");
INSERT INTO lag_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Vaantʉ vakava voomʉsaakɨra Yéesu. Novo ˆvakiijiinge hamwɨ Kaayii Njija, vakaanda kiiyurya, “Joolɨ mookiisea? Ʉhʉ mʉʉntʉ sɨ arɨ kʉʉja vii kaa tʉkʉ na ngovii wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na Mafarisáayo, vajáa valairirya voosea, koonɨ mʉʉntʉ yoyoosi atáangire kʉʉntʉ Yéesu ˆarɨ, avatwaarɨre mʉlomo sa vakamʉkwaate. ");
INSERT INTO lag_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sikʉ mʉsasatʉ de ifike ngovi ya Paásika, Yéesu akatamanya na Besanía, múujii haantʉ ˆiikaláa Lasáaro, ʉra ˆajáa amʉfʉfʉla. ");
INSERT INTO lag_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ʉko, vaantʉ vakamwiimirya neeja kiiwʉlo ja nyemi kwa Yéesu. Maárita akava yoovatʉmamɨra vayeni. Lasáaro ne nɨ ʉmwɨ wa vara ˆvajáa viíkyɨɨre méesii hamwɨ na Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maríia akatoola chʉ́pa ya núusu líita ya makuta ˆyanyʉ́kɨraa ya iyoombe ikʉlʉkʉʉlʉ. Aho, akamʉhaka Yéesu makuta majewii, maa de ɨndoomʉhonola na njwɨɨrɨ jaachwe. Nyuumba yoosi ɨkanyukɨra makuta. ");
INSERT INTO lag_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Maa kaa, Yʉ́ʉda Isikarióoti, ʉmwɨ wa vapooji ikimi na vavɨrɨ, ʉra ˆarɨ mʉvarindʉka Yéesu, akasea, ");
INSERT INTO lag_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sa che aya makuta ˆyanyʉkɨra sɨ yaváirwe iyoombe ra mpía ja dináari magana yatatʉ (300), na mpía ijo vaheewe vakɨva?” ");
INSERT INTO lag_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yʉ́ʉda alʉʉsa jei, sɨ sa avooneráa mbavariri vakɨva tʉkʉ, maa kaa, nɨ sa viintʉ ajáa mwiívi. Yeeye noo iikaláa na mufuko wa mpía, na kweene ɨɨváa mpía fuma aho mufukwii. ");
INSERT INTO lag_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aho, Yéesu akasea, “Mʉreki. Awʉla makuta aya ˆyanyʉkɨra, akayavɨɨka, sa sikʉ yaanɨ yo taahwa. ");
INSERT INTO lag_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vakɨva novo mʉrɨ sikʉ joosi, maa kaa, sɨ mʉrɨ kʉva na nɨɨnɨ sikʉ joosi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mpuka nkʉʉlʉ ya Vayahúudi vakateera Yéesu amwaarɨ ʉko Besanía, maa vakʉʉja sɨ so jo moona Yéesu vii tʉkʉ, maa kaa, baa so moona Lasáaro. Ʉhʉ Lasáaro Yéesu ajáa amʉfʉfʉla. ");
INSERT INTO lag_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jeyyo, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva vakarya nchuungo yo mʉʉlaa Lasáaro. ");
INSERT INTO lag_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Sa Lasáaro, Vayahúudi ˆvarɨ foo vajáa vareka kutuuba vakʉ́ʉ́lʉ vaavo, maa vakamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lomʉtóondo yaachwe, mpuka nkʉʉlʉ ya vaantʉ ˆngʼeene ɨjáa yuújire na ngovii, ɨkateera Yéesu amwaarɨ njirii yookʉʉja na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Aho, vakawuna matáampi ya mɨtéende, maa vakatamanya noo musingirirya, kʉnʉ vootʉla isóso voosea, “Adʉʉmbwe Mweenevyoosi! Atalariwa yeeye ˆyookʉʉja kwa irina ra Ijʉva. Atalariwa Mʉtemi wa Isiraéeli.” ");
INSERT INTO lag_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Aho, Yéesu akashaana mwaana wa ndákwi, akiiverekya ja ˆvyeene Masáare ˆYarɨ Mpeho yalʉʉsa, ");
INSERT INTO lag_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nyuunyu vaantʉ va múuji wa Sayúuni, koofi tʉkʉ, laangi, Mʉtemi waanyu yookʉʉja, iivérekiirye mwaana wa ndákwi.” ");
INSERT INTO lag_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mpɨɨndɨ ijo, vapooji va Yéesu sɨ vataanga aya masáare tʉkʉ. Maa kaa, Yéesu ˆakahɨndʉke na kurumwii, aho de vakakʉmbʉkɨra aya masáare yajáa yaandɨkwa sa yeeye, na yajáa yatʉmamwa kwaachwe. ");
INSERT INTO lag_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mpuka ya vaantʉ ɨra ˆɨjáa ne mpɨɨndɨ ˆamwaanɨrɨráa Lasáaro fuma mbiríírii, akamʉfʉfʉla, vakatuuba koonekya ko kwaarya aya masáare. ");
INSERT INTO lag_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sa jeyyo, mpuka ya vaantʉ ɨkadoma noo musingirirya, sa voosi vajáa vatéɨɨre ʉwo muujíisa Yéesu ˆajáa abwéeyyiirye. ");
INSERT INTO lag_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Maa kaa, Mafarisáayo vakiisea voovo kwa voovo, “Koona mwiise wʉʉ? Sɨ tʉrɨ tʉmama kɨɨntʉ chochoosi tʉkʉ, weerʉ yoosi yoomutuuba yeeye vii.” ");
INSERT INTO lag_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Haaha, vamwɨ va vaantʉ ˆvajáa vatamanya noo mwiinamɨra Mʉlʉʉngʉ mpɨɨndɨ ja ngovi ya Paásika, nɨ Vagiríki vajáa. ");
INSERT INTO lag_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ava vaantʉ vakatamanya na kwa Filíipi. Ʉhʉ Filíipi meevo nɨ iturii ra Besaída ˆrɨrɨ ɨsɨ ya Galiláaya kʉjáa. Vakamʉloomba voosea, “Mʉkʉ́lʉ, tooloomba tʉlʉʉsɨke na Yéesu.” ");
INSERT INTO lag_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filíipi akɨɨta muwyɨɨra Anderéa, maa voosi vavɨrɨ vakatamanya noo muwyɨɨra Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yéesu akavasea, “Mpɨɨndɨ ja Mwaana wa Mʉʉntʉ kʉbweeyyiriwa nkongojima jafíkire. ");
INSERT INTO lag_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kɨmaarɨ kaa noovawyɨɨra, koonɨ mpeke ya ngáano sɨ iwíire ɨsɨ ɨkakwya, chaala ɨrɨ viintʉ ɨrɨ mpeke ɨmwɨ vii. Maa kaa, koonɨ yakwíire, yavyáalaa mpeke ˆjiri foo. ");
INSERT INTO lag_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mʉʉntʉ yoyoosi ˆeenda nkaasʉ yaachwe, kɨɨtaaha arɨ, maa kaa, mʉʉntʉ yoyoosi ˆɨɨsʉʉla nkaasʉ yaachwe aha weerwii, kɨɨlamurirya arɨ kwa sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mʉʉntʉ yoyoosi ˆaantʉ́mamɨraa nɨɨnɨ, nɨ mpaka aantuube. Na haantʉ ˆndɨrɨ veera baa yeeye veera arɨ. Taáta waanɨ mʉnyemya arɨ yoyoosi ˆaantʉ́mamɨraa. ");
INSERT INTO lag_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Haaha mʉtɨma waanɨ woólolokɨɨre maatʉkʉ vii. Che kaa ndɨrɨ lʉʉsa? Ndʉʉse, ‘Taáta, ndamurirya fuma mpiindii ɨhɨ ya uturikiri wʉʉ?’ Tʉkʉ, sɨ ndɨrɨ loomba jeyyo tʉkʉ, sa nʉʉja jɨ ntʉrɨkɨre mpɨɨndɨ iji. ");
INSERT INTO lag_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taáta, bweeyyirya irina raako nkongojima.” Aho, sawúti fuma kurumwii ɨkasea, “Narɨbwéeyyiriirye nkongojima na kei, rɨbweeyyirya ndɨrɨ nkongojima.” ");
INSERT INTO lag_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mpuka ya vaantʉ ˆɨjáa hara ˆɨkateere ɨyo sawúti, maa ɨkasea, “Kwakíririmire.” Vamwɨ vakasea, “Murimʉ mʉʉja walúusikire ne.” ");
INSERT INTO lag_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yéesu akavasea, “Sawúti ɨhɨ ˆmwatéɨɨre sɨ sa nɨɨnɨ tʉkʉ, maa kaa, nɨ sa nyuunyu. ");
INSERT INTO lag_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Haaha, mpɨɨndɨ ja ɨhɨ weerʉ kʉlamʉrɨrwa, jafíkire. Irimʉ noo kʉsea mʉkʉ́ʉ́lʉ wa ɨhɨ weerʉ kibiriwa riise nɨ Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Maa kaa, nɨɨnɨ ˆndɨrɨ kiinʉlwa na mweeri, varuta ndɨrɨ vaantʉ voosi vʉʉje na kwaanɨ.” ");
INSERT INTO lag_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yéesu alʉʉsa jei, koonekya nɨ inkwya ɨrɨ joolɨ ˆarɨ kukwya. ");
INSERT INTO lag_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ɨra mpuka ya vaantʉ ɨkamʉsea, “Suusu tateera fuma Miirwii yiitʉ yasea, Masía kʉva arɨ amwaarɨ kwa sikʉ ˆjisiina ʉhero. Haaha sa che woosea vaantʉ mwiinurirya varɨ Mwaana wa Mʉʉntʉ? Eri, Mwaana wa Mʉʉntʉ nɨ ani?” ");
INSERT INTO lag_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yéesu akavasea, “Kɨweerʉ kɨkaarɨ na nyuunyu kwa mpɨɨndɨ vii. Sa jeyyo, yeendi viintʉ ˆmʉkaarɨ na ɨkyo kɨweerʉ, sa mʉdɨɨre remeerwa nɨ kilwiirya. Koonɨ mʉʉntʉ yooyeenda kilwiiryii, sɨ amányire na kʉʉntʉ ˆyootamanya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mpɨɨndɨ mʉrɨ na ɨkɨ kɨweerʉ, kirumi kɨweerʉ, sa mʉve vaantʉ va kɨweerʉ.” ˆAkahʉmʉle lʉʉsa ayo, Yéesu akavareka vaantʉ, maa akɨɨta kiivisa. ");
INSERT INTO lag_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Baa neembe Yéesu abweeyya isháara na myuujíisa ˆɨrɨ foo mbere yaavo, sɨ vamuruma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Vyaava jeyyo, sa yakiimane masáare ya mʉláali na mʉtwe Isáaya viintʉ ˆyasea, “Ee Ijʉva, nɨ ani aruma masáare yiiswi? Kei, ani oonekiwa ngururu jaachwe nɨ Ijʉva?” ");
INSERT INTO lag_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jeyyo, sɨ vamuruma tʉkʉ ja ˆvyeene Isáaya alʉʉsa haantʉ hɨɨngɨ, ");
INSERT INTO lag_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mʉlʉʉngʉ avahokurya miiso yaavo, na mɨtɨma yaavo abweeyya ɨfafe, sa vasiindwe koona kwa miiso yaavo, na vasiindwe taanga na mɨtɨma yaavo, karɨ luu vavalandʉke, nɨvahonʼye tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isáaya alʉʉsa aya, sa ajáa oona nkongojima ya Yéesu, na akalʉʉsa masáare yaachwe. ");
INSERT INTO lag_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Baa neembe nɨ jeyyo, ˆvarɨ foo katɨ na katɨ ya vakʉ́ʉ́lʉ va Vayahúudi vakamuruma. Maa kaa, sa Mafarisáayo, sɨ valʉʉsa italii tʉkʉ, sa voofáa kibiriwa varɨ masinagóogii. ");
INSERT INTO lag_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Avo vakʉ́ʉ́lʉ vajáa veenda nkongojima ja vaantʉ, kʉlookya nkongojima ˆjifúmaa kwa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Aho, Yéesu akavasea jei na sawúti nkʉʉlʉ, “Mʉʉntʉ ˆaandúmaa nɨɨnɨ, sɨ aandúmaa nɨɨnɨ vii tʉkʉ, maa kaa, amurúmaa ʉra ˆaantʉma. ");
INSERT INTO lag_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yoyoosi ˆaanyona nɨɨnɨ, amoona ʉra ˆaantʉma. ");
INSERT INTO lag_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nɨɨnɨ nʉʉja nɨve kɨweerʉ cha ɨhɨ weerʉ, sa mʉʉntʉ yoyoosi ˆarɨ kuunduma adɨɨre chaala kilwiiryii. ");
INSERT INTO lag_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mʉʉntʉ ˆayatéeraa masáare yaanɨ baa yakwaatya tʉkʉ, nɨɨnɨ sɨ nkaluusire irya raachwe tʉkʉ. Sa sɨ nʉʉja jo lamʉrɨra weerʉ tʉkʉ, kɨrɨ vyoova jeyyo, nʉʉja jo lamurirya weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ʉra ˆaansíitaa na sɨ ˆahókeraa masáare yaanɨ, ʉwo atɨɨte mʉlamuli. Masáare ayo ˆnoolʉʉsa noo ˆyakaluusire irya sikʉ ya ʉhero wa weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nɨɨnɨ sɨ noolʉʉsɨka kwa lʉvɨro lwaanɨ tʉkʉ, maa kaa, kwa lʉvɨro lwa Taáta ˆaantʉma, yeeye aandairirya ndʉʉse, na ˆvyeene nasaakwa ndʉʉse. ");
INSERT INTO lag_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nɨɨnɨ namányire ʉlairiri waachwe nɨ nkaasʉ ya sikʉ ˆjisiina ʉhero. Haaha ɨkɨ ˆnoolʉʉsa nɨ kɨra vii Taáta ˆaandairirya ndʉʉse.” ");
INSERT INTO lag_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sikʉ ya ngovi ya Paásika ɨjáa yaséngerɨɨre. Yéesu akataanga mpɨɨndɨ jaachwe jo kiinʉka fuma kʉrɨ weerʉ no tamanya na kwa Taáta waavo, jijáa jafíkire. Yéesu ajáa aveenda vaantʉ vaachwe ˆvajáa aha weerwii maatʉkʉ vii, akavalaɨra kʉveenda fʉʉrʉ ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Mpɨɨndɨ ja iwʉlo, Yéesu na vapooji vaachwe vakiikala kurya kiiwʉlo. Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ rɨjáa rahʉ́mwɨɨre kʉmwɨɨngɨra mutimii Yʉ́ʉda mwaana wa Simóoni Isikarióoti amʉvalandʉke Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yéesu ajáa amányire Taáta ajáa amʉheera viintʉ vyoosi mɨkonwii yaachwe. Kei ajáa amányire yeeye afuma kwa Mʉlʉʉngʉ na hɨndʉka arɨ na kwa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aho, Yéesu akareka kurya, akiinʉka, akafumya nkáancho yaachwe, akatoola táwʉlo, maa akiichuunga mukiiswii. ");
INSERT INTO lag_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akakʉʉrɨra maaji ibésenii, maa akaanda vooyya majeo vapooji vaachwe, maa de ɨndoovahonola na ɨra táwʉlo ˆajáa iimʉ́tɨɨre mukiiswii. ");
INSERT INTO lag_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ˆAkafike kwa Simóoni Peéteri, maa Peéteri akamuurya, “Mʉkʉ́lʉ, atɨ weewe wʉʉnjoyye majeo nɨɨnɨ?” ");
INSERT INTO lag_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yéesu akamʉsea, “Weewe sɨ wootaanga kɨra ˆnootʉmama haaha tʉkʉ. Maa kaa, mpɨɨndɨ ˆjookʉʉja taanga ʉrɨ.” ");
INSERT INTO lag_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peéteri akamʉsea Yéesu, “Baa sikʉ ɨmwɨ, sɨ ʉrɨ kʉʉnjoyya majeo yaanɨ vii kaa tʉkʉ.” Aho, Yéesu akamʉsea, “Koonɨ sɨ nakoóyyiirye majeo, usiina lʉtaamɨ na nɨɨnɨ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aho, Simóoni Peéteri akamʉsea, “Mʉkʉ́lʉ, kʉʉnjoyya majeo vii tʉkʉ, njoyya mɨkono baa na mʉtwe waanɨ.” ");
INSERT INTO lag_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yéesu akamʉsea, “Mʉʉntʉ ˆahʉ́mwɨɨre koowa, sɨ asaakwa oowe kei tʉkʉ, maa kaa, kooyya majeo vii. Nyuunyu mweérire, maa kaa, sɨ kɨra mʉʉntʉ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yéesu ajáa amʉmányire ˆmweene arɨ mʉvarindʉka, noo ˆchooreka asea, “Mweérire, maa kaa, sɨ voosi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yéesu ˆakahʉmʉle kʉvooyya vapooji vaachwe majeo, akatoola nkáancho yaachwe, akiivɨkɨra, maa akiikala kei kurya. Aho, akavasea vapooji vaachwe, “Eri, mwatáangire kɨra ˆnavabwéeyyiiriirye wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nyuunyu mwaanyánɨrɨraa nɨɨnɨ ‘Mukiindya’ na ‘Mweenevyoosi,’ ɨkyo ˆmʉlʉ́ʉsaa nɨ kɨmáárɨ na noo ˆvyeene ndɨrɨ. ");
INSERT INTO lag_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Sa jeyyo, koonɨ nɨɨnɨ ˆndɨrɨ Mweenevyoosi na Mukiindya waanyu navoóyyiirye majeo, viivyo baa nyuunyu mʉndookiiyoyya majeo nyuunyu kwa nyuunyu. ");
INSERT INTO lag_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Navoónekiirye jei sa mʉndookiibweeyyirya ja ˆvyeene nɨɨnɨ navabwéeyyiriirye. ");
INSERT INTO lag_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kɨmaarɨ kaa noovawyɨɨra, mʉtʉmami sɨ mʉkʉʉlʉ kʉlookya mweenenyuumba waachwe tʉkʉ. Kei, ʉra ˆatʉmwa sɨ mʉkʉʉlʉ kʉlookya ʉra ˆamʉtʉma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Koonɨ mʉyatáangire aya, Mʉlʉʉngʉ vatalarya arɨ koonɨ mooyatʉmama. ");
INSERT INTO lag_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Sɨ noolʉʉsa aya kʉrɨ nyuunyu voosi tʉkʉ. Navamányire vara ˆnavasaawʉla. Maa kaa, nɨ lʉʉsa niise aya sa Masáare ˆYarɨ Mpeho yakiimane ja ˆvyeene yalʉʉsa, ‘Ʉra ˆaríjaa na nɨɨnɨ, noo ˆaankɨ́ɨkɨɨne.’ ");
INSERT INTO lag_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nɨ kʉvawyɨɨra niise aya haaha, viintʉ ˆyakaarɨ fʉmɨra, sa ˆyarɨ fʉmɨra, murume, ‘Nɨɨnɨ Mwaarɨ.’ ");
INSERT INTO lag_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kɨmaarɨ kaa noovawyɨɨra, mʉʉntʉ yoyoosi ʉra ˆamʉhókeraa ʉra ˆnamʉtʉma, aampókeraa nɨɨnɨ. Na nɨɨnɨ Taáta aantʉma. Jeyyo, ʉra ˆaampókeraa nɨɨnɨ, amʉhókeraa Taáta.” ");
INSERT INTO lag_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yéesu ˆakahʉmʉle lʉʉsa aya masáare, mʉtɨma waachwe ʉkaava, maa akoonekya ko sea, “Kɨmaarɨ kaa noovawyɨɨra, ʉmwɨ waanyu kʉʉnvarindʉka arɨ.” ");
INSERT INTO lag_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Vapooji vaachwe vakiilaanga voovo kwa voovo, sa sɨ vataangáa nɨ ani ˆyoomʉlʉʉsa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kʉjáa kwatɨɨte mʉpooji waachwe ʉmwɨ Yéesu ˆajáa amweenda. Yeeye ajáa iisíkiriirye kɨpeembii cha Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simóoni Peéteri akamʉkonyera sa amuurye Yéesu nɨ ani ˆyoomʉlʉʉsa. ");
INSERT INTO lag_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ʉra mʉpooji kʉnʉ iisíkiriirye kwa Yéesu akuurya yoosea, “Mweenevyoosi, nɨ ani?” ");
INSERT INTO lag_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yéesu akamʉsea, “Nɨ ʉra ˆndɨrɨ mʉheera ɨrɨ ibéendʉ ra mʉkáate ˆndɨrɨ tukya aha luumbwii.” Sa jeyyo, ˆakatukye rɨra ibéendʉ ra mʉkáate luumbwii, akamʉheera Yʉ́ʉda mwaana wa Simóoni Isikarióoti. ");
INSERT INTO lag_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yʉ́ʉda ˆakahokere rɨra ibéendʉ ra mʉkáate, Irimʉ rɨkamwɨɨngɨra. Aho, Yéesu akamʉsea Yʉ́ʉda, “ˆCheene woosaaka tʉmama, tʉmama chaangʉ.” ");
INSERT INTO lag_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Maa kaa, kusiina baa ʉmwɨ aho méesii ˆataanga sa che Yéesu alúusire jeyyo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sa viintʉ Yʉ́ʉda noo ˆakwaatáa mufuko wa mpía, vɨɨngɨ vakiisea Yéesu amʉséire akawʉle viintʉ ˆvyoosaakwa sa ngovi ya Paásika, au avaheere vakɨva mpía kiduudi. ");
INSERT INTO lag_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jeyyo, ˆakahokere rɨra ibéendʉ ra mʉkáate, haaho akafuma na weerwii. Na mpɨɨndɨ ijo nɨ uchikʉ ʉjáa. ");
INSERT INTO lag_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yʉ́ʉda ˆakafume na weerwii, Yéesu akavasea vapooji vaachwe, “Haaha Mwaana wa Mʉʉntʉ ahʉ́mwɨɨre bweeyyiriwa nkongojima, ne Mʉlʉʉngʉ abwéeyyiriiwe nkongojima kʉrɨ yeeye. ");
INSERT INTO lag_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Koonɨ Mʉlʉʉngʉ abwéeyyiriiwe nkongojima kwa njɨra ya Mwaana, Mʉlʉʉngʉ ne mʉbweeyyirya arɨ nkongojima kʉrɨ yeeye mweeneevyo, na bweeyya arɨ jeyyo haaha vii. ");
INSERT INTO lag_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Vanavaanɨ vaduudi, nkaarɨ na nyuunyu kwa mpɨɨndɨ nduudi vii. Kʉʉnsaakɨra mʉrɨ, maa kaa, ja ˆvyeene navawyɨɨra vakʉ́ʉ́lʉ va Vayahúudi, viivyo baa nyuunyu nɨ kʉvawyɨɨra niise haaha, kʉʉntʉ ˆnootamanya, nyuunyu sɨ mʉrɨ daha fika tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Haaha nɨ kʉvaheera niise ʉlairiri mufya, ‘Mwiiyende, ja ˆvyeene nɨɨnɨ naveenda nyuunyu, viivyo naanyu mwiiyende.’ ");
INSERT INTO lag_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Koonɨ mwiiyéndire nyuunyu kwa nyuunyu, vaantʉ voosi taanga varɨ nyuunyu mʉrɨ vapooji vaanɨ.” ");
INSERT INTO lag_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Aho, Simóoni Peéteri akamuurya Yéesu, “Mweenevyoosi, na hai wootamanya?” Yéesu akamʉsea, “Na kʉʉntʉ ˆnootamanya sɨ ʉrɨ daha kuuntuuba haaha tʉkʉ, maa kaa, kuuntuuba ʉrɨ sikʉ ˆjookʉʉja.” ");
INSERT INTO lag_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peéteri akamuurya, “Mweenevyoosi, sa che sɨ ndɨrɨ kutuuba haaha? Nɨɨnɨ nɨɨ́mɨre neeja kʉtoola nkaasʉ yaanɨ sa weewe.” ");
INSERT INTO lag_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yéesu akamuurya, “Peéteri, eri, kɨmaarɨ toola ʉrɨ nkaasʉ yaako sa nɨɨnɨ? Kɨmaarɨ kaa nookuwyɨɨra, lomʉtóondo namʉtóondo nkʉkʉlʉme sɨ ɨnavɨɨka, lʉʉsa ʉrɨ katatʉ sɨ waamányire tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yéesu akavasea vapooji vaachwe, “Karɨ mʉrékeraa mɨtɨma yaanyu ɨndootʉrɨkɨra tʉkʉ, murumi Mʉlʉʉngʉ na kei ndumi nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kaayii kwa Taáta waanɨ, kwatɨɨte haantʉ ho kiikala ˆharɨ foo. Ngaarɨ sɨ viri jeyyo, ngaarɨ navawyɨɨra. Haaha, nɨ tamanya niise noo viimirya neeja haantʉ ho kiikala. ");
INSERT INTO lag_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na ˆndɨrɨ tamanya no kooviimirya neeja haantʉ ho kiikala, kʉʉja ndɨrɨ kei no vasʉmʉla na kwaanɨ, sa haantʉ ˆndɨrɨ veera nɨɨnɨ, baa nyuunyu mʉvere haaho. ");
INSERT INTO lag_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nyuunyu mwɨɨmányire njɨra ˆyatamanya na haantʉ ˆnoodoma.” ");
INSERT INTO lag_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aho, Tomáasi akamʉsea, “Mweenevyoosi, suusu sɨ tʉmányire na haantʉ ˆwootamanya tʉkʉ, joolɨ tʉrɨ kwɨɨtaanga njɨra?” ");
INSERT INTO lag_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yéesu akavasea, “Nɨɨnɨ noo njɨra, kɨmáárɨ na nkaasʉ. Kusiina mʉʉntʉ yoyoosi ˆarɨ kʉʉja na kwa Taáta tʉkʉ, nɨ mpaka atweere na kwaanɨ vii. ");
INSERT INTO lag_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngaarɨ mwaamányire nɨɨnɨ, ngaarɨ mwamʉmányire baa Taáta. Kwaandɨra haaha mwamʉmányire Taáta waanɨ, baa kei mwamwɨɨ́ne.” ");
INSERT INTO lag_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filíipi akamʉsea Yéesu, “Mʉkʉ́lʉ, toonekye Taáta waanyu, naasu twiikinkime.” ");
INSERT INTO lag_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yéesu akamʉsea, “Filíipi niikala na nyuunyu mpɨɨndɨ joosi iji, atɨ sɨ waamányire tʉkʉ? Mʉʉntʉ yoyoosi ˆaanyona nɨɨnɨ, amoona Taáta. Haaha joolɨ wookʉʉnsea, ‘Toonekye Taáta?’ ");
INSERT INTO lag_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Eri, sɨ wooruma nɨɨnɨ na Taáta, kei Taáta na nɨɨnɨ nɨ kɨɨntʉ kɨmwɨ tʉkʉ wʉʉ? Masáare ˆnoovawyɨɨra sɨ miiririkano yaanɨ tʉkʉ, kɨrɨ vyoova jeyyo, Taáta, yeeye na nɨɨnɨ tʉrɨ kɨɨntʉ kɨmwɨ, noo atʉ́mamaa mɨrɨmo ko tweera nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Rumi yara ˆnoovawyɨɨra, nɨɨnɨ na Taáta, kei Taáta na nɨɨnɨ nɨ kɨɨntʉ kɨmwɨ. Maa kaa, koonɨ sɨ mooruma aya ˆnoolʉʉsa, ndumi nɨɨnɨ sa mɨrɨmo ˆnootʉmama. ");
INSERT INTO lag_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kɨmaarɨ kaa noovawyɨɨra, yoyoosi ˆaandúmaa nɨɨnɨ, tʉmama arɨ mɨrɨmo ˆnatʉ́mamaa. Na kɨkomi tʉmama arɨ mɨkʉ́ʉ́lʉ kʉlookya ɨhɨ, sa nɨɨnɨ nɨ tamanya niise na kwa Taáta. ");
INSERT INTO lag_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kɨɨntʉ chochoosi ˆmʉrɨ loomba kwa irina raanɨ, nɨɨnɨ tʉmama ndɨrɨ. Kwa njɨra ɨyo Taáta abweeyyiriwe nkongojima ko tweera Mwaana. ");
INSERT INTO lag_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kɨɨntʉ chochoosi ˆmʉrɨ loomba kwa irina raanɨ, nɨɨnɨ tʉmama ndɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Koonɨ mwaanyenda, kwaatya mʉrɨ ndairiri jaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɨɨnɨ mʉloomba ndɨrɨ Taáta, yeeye vaheera arɨ Mwaambiriryi, ne kiikala arɨ na nyuunyu kwa sikʉ ˆjisiina ʉhero. ");
INSERT INTO lag_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ʉhʉ Mwaambiriryi noo Mʉtɨma wa kɨmáárɨ. Vaantʉ va weerʉ sɨ varɨ daha kʉmʉhokera tʉkʉ, sa sɨ vamoónaa tʉkʉ na sɨ vamʉmányire tʉkʉ. Maa kaa, nyuunyu mwamʉmányire sa nɨ hamwɨ arɨ na nyuunyu na kiikala arɨ mitimii yaanyu. ");
INSERT INTO lag_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Sɨ ndɨrɨ vareka nyuuveene ja varekwa tʉkʉ, maa kaa, kʉʉja ndɨrɨ kei na kwaanyu. ");
INSERT INTO lag_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mpɨɨndɨ kiduudi, weerʉ sɨ ɨrɨ kʉʉnyona kei tʉkʉ, maa kaa, nyuunyu kʉʉnyona mʉrɨ. Sa viintʉ nɨɨnɨ ndɨrɨ nkaasʉ, baa nyuunyu kʉva mʉrɨ nkaasʉ. ");
INSERT INTO lag_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sikʉ ɨyo taanga mʉrɨ nɨɨnɨ na Taáta waanɨ nɨ kɨɨntʉ kɨmwɨ, na nyuunyu na nɨɨnɨ, kei nɨɨnɨ na nyuunyu nɨ kɨɨntʉ kɨmwɨ tʉrɨ. ");
INSERT INTO lag_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mʉʉntʉ yoyoosi ˆamányire na ˆakwáatyaa ndairiri jaanɨ, ʉwo noo ˆaanyenda. Na ʉra ˆaanyenda nɨɨnɨ, Taáta waanɨ mweenda arɨ na nɨɨnɨ mweenda ndɨrɨ na kwiiyonekya ndɨrɨ kwaachwe.” ");
INSERT INTO lag_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Aho, mʉpooji waachwe ʉmwɨ ˆaséwaa Yʉ́ʉda, sɨ Yʉ́ʉda Isikarióoti tʉkʉ, akamuurya Yéesu, “Mʉkʉ́lʉ, joolɨ vyavɨ́ɨre woosaaka wiiyonekye kwiiswi vii na sɨ kwa weerʉ yoosi tʉkʉ?” ");
INSERT INTO lag_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yéesu akamʉsea, “Mʉʉntʉ yoyoosi ˆaanyenda, kwaatya arɨ isáare raanɨ, Taáta waanɨ mweenda arɨ, na suusu kʉʉja tʉrɨ na kwaachwe noo kiikala hamwɨ ne. ");
INSERT INTO lag_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Maa kaa, mʉʉntʉ sɨ ˆaanyenda, sɨ arɨ kwaatya masáare yaanɨ tʉkʉ. Aya masáare ˆmooteera sɨ yaanɨ tʉkʉ, nɨ ya Taáta yeeye aantʉma. ");
INSERT INTO lag_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Navawyɨ́ɨrɨɨre masáare aya yoosi, viintʉ ˆnkaarɨ hamwɨ na nyuunyu. ");
INSERT INTO lag_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Maa kaa, Taáta waanɨ varetera arɨ Mwaambiriryi, noo kʉsea Mʉtɨma Mʉʉja, ʉwo Taáta mʉtʉma arɨ kʉrɨ nyuunyu kwa irina raanɨ, yeeye vakiindya arɨ masáare yoosi na kʉvakumbusikya arɨ yoosi ˆnavawyɨɨra. ");
INSERT INTO lag_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Varekera niise mwiikalo mʉʉja, mwiikalo waanɨ mʉʉja kʉvaheera niise. Sɨ noovaheera mwiikalo waanɨ mʉʉja ja ˆvyeene weerʉ ɨtóolaa tʉkʉ. Karɨ mʉndoojʉʉwɨka mitimii yaanyu tʉkʉ na karɨ mʉndookoofa chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwateera noosea, ‘Kiitamanyirya niise, maa kaa, kʉʉja ndɨrɨ kei.’ Ngaarɨ kɨmaarɨ mwaanyenda, ngaarɨ mwavyeéndire kʉteera nootamanya na kwa Taáta, sa Taáta nɨ mʉkʉʉlʉ kʉlookya nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nɨɨnɨ noovawyɨɨra aya mpɨɨndɨ ˆyakaarɨ fʉmɨra, sa ˆyarɨ fʉmɨra, muundume. ");
INSERT INTO lag_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sɨ ndɨrɨ tuuba lʉʉsɨka masáare ˆyarɨ foo kʉrɨ nyuunyu tʉkʉ, sa ʉra mʉkʉ́ʉ́lʉ wa weerʉ, noo kʉsea Irimʉ, rɨmwaarɨ rookʉʉja. Rooro risiina lʉvɨro kʉrɨ nɨɨnɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nɨɨnɨ nootʉmama yara Taáta ˆaandairirya ntʉmame, sa vaantʉ voosi vataange nɨɨnɨ namweenda Taáta waanɨ. Haaha inuki, hendi tʉlooke fuma aha. ");
INSERT INTO lag_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nɨɨnɨ ndɨrɨ mʉsabíibu wa kɨkomi, na Taáta waanɨ nɨ murimi. ");
INSERT INTO lag_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kɨra itáampi raanɨ rɨra sɨ ˆrɨtʉ́ʉngaa ndɨɨwa, Taáta arɨtémaa akarɨseyya. Na kɨra itáampi ˆratʉ́ʉngaa ndɨɨwa, Taáta arɨpʉ́ʉtɨraa sa rɨtʉʉngetʉʉnge. ");
INSERT INTO lag_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nyuunyu mwahʉmʉla pʉʉtɨrwa no jirʉlwa ko tweera ukiindya waanɨ ˆnavawyɨɨra. ");
INSERT INTO lag_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mʉve kɨɨntʉ kɨmwɨ na nɨɨnɨ, naanɨ kʉva ndɨrɨ kɨɨntʉ kɨmwɨ na nyuunyu. Itáampi sɨ rɨrɨ tʉʉnga ndɨɨwa rooreene tʉkʉ, koonɨ sɨ rakwaatana na mʉsabíibu. Viivyo baa nyuunyu sɨ mʉrɨ daha kʉva na ndɨɨwa tʉkʉ, koonɨ sɨ mʉvɨ́ɨre kɨɨntʉ kɨmwɨ na nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nɨɨnɨ nɨ mʉsabíibu, na nyuunyu nɨ matáampi. Ʉra ˆatúubaa kʉva kɨɨntʉ kɨmwɨ na nɨɨnɨ, na nɨɨnɨ kʉva kɨɨntʉ kɨmwɨ ne, ʉwo atúungaa ndɨɨwa mʉnʉmʉʉnʉ. Sa nyuunyu veene vii sɨ mʉrɨ daha tʉmama chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mʉʉntʉ yoyoosi ʉra sɨ ˆarɨ kɨɨntʉ kɨmwɨ na nɨɨnɨ, nɨ ja itáampi rakerwa, rɨkʉʉma. Matáampi ja ayo, yʉʉ́maa, yakajiingwa mavɨɨvɨ, yakafweitɨrwa mootwii, maa yakamalwa. ");
INSERT INTO lag_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nyuunyu koonɨ mwavɨ́ɨre kɨɨntʉ kɨmwɨ na nɨɨnɨ, na masáare yaanɨ yiíkyɨɨre isii yaanyu, loombi chochoosi ˆmoosaaka, na heewa mʉrɨ. ");
INSERT INTO lag_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Vapooji vaanɨ va kɨkomi, vatʉ́ʉngaa ndɨɨwa ˆjiri foo. Sa jeyyo, voónekyaa ʉkʉ́ʉ́lʉ wa nkongojima ya Taáta. ");
INSERT INTO lag_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Naveenda nyuunyu ja ˆvyeene Taáta aanyenda nɨɨnɨ. Sa jeyyo, ikali kʉrɨ kweenda kwaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Koonɨ mwakwáatiirye ndairiri jaanɨ, kiikala mweende kʉrɨ kweenda kwaanɨ, ja ˆvyeene nɨɨnɨ nakwaatya ndairiri ja Taáta, jo kiikala kʉrɨ kweenda kwaachwe. ");
INSERT INTO lag_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Navawyɨ́ɨrɨɨre aya, sa kʉvyeenda kwaanɨ kʉve isii yaanyu na kʉvyeenda kwaanyu kukiimane. ");
INSERT INTO lag_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ʉlairiri waanɨ nɨ ʉhʉ, iyendi nyuunyu kwa nyuunyu, ja ˆvyeene nɨɨnɨ naveenda nyuunyu. ");
INSERT INTO lag_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kusiina mʉʉntʉ ˆarɨ na kweenda kʉkʉʉlʉ ja ʉkʉ tʉkʉ, mʉʉntʉ kʉtoola nkaasʉ yaachwe sa vijeengi vyaachwe. ");
INSERT INTO lag_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nyuunyu nɨ vijeengi vyaanɨ, koonɨ mootʉmama yara ˆnavalairirya. ");
INSERT INTO lag_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sɨ ndɨrɨ vaanɨrɨra kei vatʉmami tʉkʉ, sa mʉtʉmami sɨ amányire kɨra mweenenyuumba waachwe ˆyootʉmama tʉkʉ. Kɨrɨ vyoova jeyyo, nɨɨnɨ noovaanɨrɨra nyuunyu vijeengi, sa navawyɨɨra yoosi ˆnateera fuma kwa Taáta waanɨ. ");
INSERT INTO lag_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Sɨ nyuunyu mwaansaawʉla nɨɨnɨ tʉkʉ, kɨrɨ vyoova jeyyo, nɨ nɨɨnɨ navasaawʉla mʉve vapooji vaanɨ. Navasaawʉla mʉve na ndɨɨwa sɨ ˆjisíraa. Sa jeyyo, chochoosi ˆmʉrɨ mʉloomba Taáta kwa irina raanɨ, vaheera arɨ. ");
INSERT INTO lag_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Haaha, ʉlairiri waanɨ noo ʉhʉ, iyendi. ");
INSERT INTO lag_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Koonɨ weerʉ yavaswɨ́ɨre nyuunyu, taangi ɨjáa yaansʉʉla nɨɨnɨ ta. ");
INSERT INTO lag_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ngaarɨ mʉrɨ va ɨhɨ weerʉ, ngaarɨ weerʉ yaveenda ja ˆvyeene yeenda vaantʉ vaachwe. Maa kaa, nyuunyu sɨ mʉrɨ va ɨhɨ weerʉ tʉkʉ, na nɨɨnɨ navasaawʉla fuma kʉrɨ ɨhɨ weerʉ. Noo ˆchooreka weerʉ yavasʉʉla. ");
INSERT INTO lag_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbukiri rɨra isáare ˆnavawyɨɨra, ‘Mʉtʉmami sɨ arɨ mʉkʉʉlʉ kʉlookya mweenenyuumba waachwe tʉkʉ.’ Koonɨ vaanturikirya nɨɨnɨ, vaturikirya varɨ baa nyuunyu. Maa kaa, koonɨ vakwáatiirye isáare raanɨ, kwaatya varɨ baa isáare raanyu. ");
INSERT INTO lag_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ayo yoosi vabweeyyirya varɨ sa irina raanɨ, sa voovo sɨ vamʉmányire ʉra ˆaantʉma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngaarɨ sɨ nʉʉja no lʉʉsɨka novo, ngaarɨ vasiina irya ra ʉvɨ tʉkʉ. Maa kaa, haaha vasiina cho lʉʉsa cho seyya ʉvɨ waavo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mʉʉntʉ yoyoosi ʉra ˆaansʉʉla nɨɨnɨ, amʉsʉʉla baa Taáta waanɨ. ");
INSERT INTO lag_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ngaarɨ sɨ nabweeyya myuujíisa ˆɨhwáalaryaa kwaavo kusiina mʉʉntʉ ˆanabweeyya, ngaarɨ vatɨɨte kɨɨntʉ cho kitirirya ʉvɨ waavo. Maa kaa, haaha vɨɨyona myuujíisa yoosi, na baa neembe nɨ jeyyo, vaansʉʉla nɨɨnɨ na Taáta waanɨ. ");
INSERT INTO lag_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aya yafʉmɨra, sa yara masáare ˆyaandɨkwa Miirwii yaavo yakiimane, ‘Vaansʉʉla bweete.’ ");
INSERT INTO lag_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nɨɨnɨ mʉtʉma ndɨrɨ Mwaambiriryi na kʉrɨ nyuunyu fuma kwa Taáta, noo kʉsea Mʉtɨma Mʉʉja. Yeeye ˆarɨ kʉʉja, kʉʉnkʉnʉkʉla arɨ kwa vaantʉ koonekya kɨkomi nɨɨnɨ nɨ ani. ");
INSERT INTO lag_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nyuunyu naanyu saakwa mʉrɨ moonekye kɨkomi masáare yaanɨ, sa nɨ hamwɨ mʉjáa na nɨɨnɨ keende ncholo. ");
INSERT INTO lag_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Navawyɨ́ɨrɨɨre yoosi aya, sa karɨ jɨ mʉreke kuunduma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Vakibirya veende fuma masinagóogii. Na fika jiri mpɨɨndɨ ˆvʉʉlaa veende vookiisea nɨ tʉmama viise mʉrɨmo wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tʉmama veende ayo, sa sɨ vamʉmányire Taáta tʉkʉ, na sɨ vaamányire baa nɨɨnɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Maa kaa, navawyɨ́ɨrɨɨre masáare aya, sa ɨra mpɨɨndɨ ˆɨrɨ fika, mʉkʉmbʉkɨre nɨjáa navawyɨɨra. Sɨ navawyɨɨra ayo hara ncholo tʉkʉ, sa viintʉ nɨjáa hamwɨ na nyuunyu. ");
INSERT INTO lag_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Haaha nɨɨnɨ nɨ tamanya niise na kwa Taáta yeeye aantʉma. Maa kaa, kusiina baa ʉmwɨ ˆyookuunjurya tʉkʉ, ‘Na hai woodoma?’ ");
INSERT INTO lag_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sa viintʉ navawyɨ́ɨrɨɨre masáare aya, mɨtɨma yaanyu yaviswɨ́ɨre maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Maa kaa, nɨ kɨmáárɨ noovawyɨɨra, nɨ vyabooha kwaanyu nootamanya na kwa Taáta. Sa koonɨ sɨ natámiinye, ʉwo Mwaambiriryi sɨ arɨ kʉʉja na kʉrɨ nyuunyu tʉkʉ. Maa kaa, koonɨ natámiinye, mʉtʉma ndɨrɨ na kʉrɨ nyuunyu. ");
INSERT INTO lag_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yeeye ˆarɨ kʉʉja, koonekya arɨ kɨkomi weerʉ nɨ mbɨ, laɨra arɨ ʉwoloki na ʉlamuli. ");
INSERT INTO lag_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kwa ʉvɨ, kʉvalaɨra eende kɨkomi vaantʉ nɨ vavɨ sa vasiita kuunduma. ");
INSERT INTO lag_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kwa ʉwoloki, kʉvoonekya eende kɨkomi nɨɨnɨ nɨ mʉwoloki, sa tamanya niise na kwa Taáta, na sɨ mʉkʉʉnyɨɨne kei tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kwa ʉlamuli, kʉvoonekya eende kɨkomi Mʉlʉʉngʉ valamʉrɨra arɨ, sa alʉʉsa irya ra Irimʉ, rooro noo Ikʉ́ʉ́lʉ ra ˆvatʉ́mamaa ʉvɨ. ");
INSERT INTO lag_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nkaarɨ na masáare ˆyarɨ foo yo vawyɨɨra, maa kaa, haaha sɨ mʉrɨ daha kʉyahokera tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mʉtɨma ʉwo wa kɨmáárɨ ˆarɨ kʉʉja, valongoola arɨ mʉtaange kɨmáárɨ choosi. Sɨ arɨ lʉʉsa masáare yaachwe tʉkʉ, maa kaa, lʉʉsa arɨ yara yoosi ˆarɨ teera na vawyɨɨra arɨ masáare ˆyarɨ kʉʉja. ");
INSERT INTO lag_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yeeye kʉvoonekya eende nkongojima yaanɨ, sa masáare ˆɨɨndoovawyɨɨra nɨ yara ˆyarɨ kwaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Viintʉ vyoosi ˆarɨ novyo Taáta, nɨ vyaanɨ. Noo ˆchooreka noovasea, masáare ˆɨɨndoovawyɨɨra nɨ yara ˆyarɨ kwaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jachɨ́hɨɨre mpɨɨndɨ kiduudi vii sɨ mʉrɨ kʉʉnyona tʉkʉ, na jachɨ́hɨɨre mpɨɨndɨ kiduudi vii kʉʉnyona mʉrɨ.” ");
INSERT INTO lag_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aho, vamwɨ va vapooji vaachwe vakiiyurya, “Nɨ che ˆyoolʉʉsa kati ˆyoosea, ‘Jachɨ́hɨɨre mpɨɨndɨ kiduudi vii sɨ mʉrɨ kʉʉnyona tʉkʉ, na jachɨ́hɨɨre mpɨɨndɨ kiduudi vii kʉʉnyona mʉrɨ?’ Na nɨ che yoolʉʉsa kati ˆyoosea, ‘Tamanya niise na kwa Taáta’?” ");
INSERT INTO lag_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Vakatuuba kiiyurya, “Nɨ che yoolʉʉsa kati ˆyoosea, ‘Mpɨɨndɨ kiduudi?’ Sɨ tootaanga ˆcheene yoolʉʉsa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yéesu akataanga kɨra ˆvoosaaka muurya, maa akavasea, “Nɨ kiiyurya mwiise nɨ che ˆnoolʉʉsa kati ˆnoosea, ‘Jachɨ́hɨɨre mpɨɨndɨ kiduudi vii sɨ mʉrɨ kʉʉnyona tʉkʉ, na jachɨ́hɨɨre mpɨɨndɨ kiduudi vii kʉʉnyona mʉrɨ wʉʉ?’ ");
INSERT INTO lag_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kɨmaarɨ kaa noovawyɨɨra, nyuunyu rɨra mʉrɨ no myaa, maa kaa, vaantʉ va weerʉ vyeenda varɨ. Kuvisʉʉla mʉrɨ, maa kaa, kuvisʉʉla kwaanyu kʉva kʉrɨ kʉvyeenda. ");
INSERT INTO lag_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mʉʉntʉ muki ˆyootamanya no kiichʉngʉla avisʉ́ʉlaa sa mpɨɨndɨ yo tʉrɨkɨra yafíkire. Maa kaa, ˆarɨ hʉmʉla kiichʉngʉla, sɨ akʉ́mbʉkɨraa ʉsʉʉngʉ tʉkʉ sa avíjaa na cheerʉ sa aréetire mwaana na aha weerwii. ");
INSERT INTO lag_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Viivyo, nyuunyu mwatɨɨte ʉsʉʉngʉ haaha, maa kaa, ˆndɨrɨ kʉʉja kei na kwaanyu, kʉva mʉrɨ na cheerʉ mitimii. Aho, kusiina ˆarɨ daha seyya ɨkyo cheerʉ mitimii yaanyu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Sikʉ ɨyo ˆɨrɨ fika, sɨ mʉkaanóombire kɨɨntʉ chochoosi tʉkʉ. Kɨmaarɨ kaa noovawyɨɨra, chochoosi ˆmʉrɨ loomba Taáta waanɨ kwa irina raanɨ, vaheera arɨ. ");
INSERT INTO lag_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Fʉʉrʉ haaha sɨ mʉnaloomba chochoosi kwa Taáta kwa irina raanɨ tʉkʉ. Loombi, naanyu heewa mʉrɨ, sa kʉvyeenda kwaanyu kukiimane. ");
INSERT INTO lag_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Noovawyɨɨra aya masáare kwa símo. Mpɨɨndɨ kʉʉja yiise, sɨ ndɨrɨ lʉʉsɨka na nyuunyu kwa símo tʉkʉ, vapʉsʉrɨra ndɨrɨ pwaa ˆvyeene Taáta waanɨ arɨ. ");
INSERT INTO lag_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sikʉ ɨyo, mʉloomba mʉrɨ Taáta kwa irina raanɨ. Sɨ noosea valoombera ndɨrɨ kwa Taáta kɨpaango chaanyu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Taáta mweeneevyo aveenda nyuunyu, sa nyuunyu mwaanyenda nɨɨnɨ, na mwaanduma nafuma kwa Taáta. ");
INSERT INTO lag_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nafuma kwa Taáta nkʉʉja na kʉrɨ weerʉ, maa kaa, haaha looka niise fuma kʉrɨ weerʉ, na hɨndʉka niise na kwa Taáta.” ");
INSERT INTO lag_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aho, vapooji vaachwe vakamʉsea, “Haaha woolʉʉsɨka pusu, sɨ wootumia símo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Haaha tatáangire weewe wamányire kɨra kɨɨntʉ, na baa kusiina ˆchoobweeyya mʉʉntʉ yoyoosi akuurye chochoosi tʉkʉ. Ayo, noo yabwéeyyiirye turume weewe wafuma kwa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yéesu akavasea, “Haaha mwarúmire wʉʉ? ");
INSERT INTO lag_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mpɨɨndɨ yaséngerɨɨre, kei yahʉ́mwɨɨre fika. Paswa mʉrɨ, kɨra mʉʉntʉ na kaayii kwaachwe, na kʉʉndeka mʉrɨ nɨɨmweene. Maa kaa, sɨ ndɨrɨ nɨɨmweene tʉkʉ, sa Taáta waanɨ nɨ hamwɨ arɨ na nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Navawyɨ́ɨrɨɨre masáare aya, sa mʉve na mwiikalo mʉʉja mitimii yaanyu, sa viintʉ mʉrɨ kɨɨntʉ kɨmwɨ na nɨɨnɨ. Kʉrɨ weerʉ turikiriwa mʉrɨ, maa kaa, koofi tʉkʉ, sa nɨɨnɨ niisiinda weerʉ.” ");
INSERT INTO lag_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yéesu ˆakahʉmʉle lʉʉsa aya, akalaanga kurumwii, akasea, “Taáta, ɨra mpɨɨndɨ yaanɨ yafíkire. Mʉbweeyyirye nkongojima Mwaana waako, sa Mwaana waako ne akʉbweeyyirye nkongojima. ");
INSERT INTO lag_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Weewe waampeera wiimiriri wo longoola vaantʉ voosi va weerʉ, sa nɨvaheere nkaasʉ ya sikʉ ˆjisiina ʉhero vara voosi ˆwaampeera. ");
INSERT INTO lag_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ɨyo nkaasʉ ya sikʉ ˆjisiina ʉhero noo ɨhɨ, vakʉtaange Mʉlʉʉngʉ weemweene wa kɨkomi, na vamʉtaange Yéesu Kirisitʉ, ˆʉmʉtʉma kʉrɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nɨɨnɨ nakʉbweeyyirya nkongojima ko kiimikirirya ʉra mʉrɨmo ˆwaampeera ntʉmame. ");
INSERT INTO lag_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ee Taáta, haaha nookʉloomba mbweeyyirya nkongojima mbere yaako, nkongojima ɨra ˆnɨjáa noyo mpɨɨndɨ ˆtʉjáa hamwɨ na weewe, mpɨɨndɨ sɨ ˆʉjáa ʉnʉʉmba weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Taáta nakʉvariyʉla ˆvyeene ʉrɨ kwa vaantʉ vara ˆwaampeera fuma kʉrɨ weerʉ. Ava vaantʉ nɨ vaako vajáa, na ʉkaampeera nɨɨnɨ vakava vaanɨ. Voovo vakwaatya isáare raako. ");
INSERT INTO lag_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Haaha vatáangire viintʉ vyoosi ˆwaampeera nɨ kwaako vyafuma, ");
INSERT INTO lag_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","sa nɨɨnɨ navaheera isáare rɨra ˆwaampeera, novo varɨhokera. Voovo vataanga kɨkomi nɨɨnɨ nafuma kwaako, na kei varuma nɨ weewe waantʉma. ");
INSERT INTO lag_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Noovaloombera avo, sa nɨ vaantʉ vaako. Sɨ nooloombera vaantʉ voosi va weerʉ tʉkʉ, kɨrɨ vyoova jeyyo, noovaloombera avo ˆwaampeera. ");
INSERT INTO lag_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Vaantʉ voosi ˆndɨrɨ novo, nɨ vaako, na voosi ˆʉrɨ novo nɨ vaanɨ. Novo vookʉʉmbweeyyirya nkongojima. ");
INSERT INTO lag_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Haaha nɨɨnɨ kiinʉka niise aha weerwii nʉʉje na kwaako, maa kaa, ava vaantʉ vaako vakaarɨ aha weerwii. Taáta Mʉʉja, nookʉloomba ʉvɨɨmɨrɨre kwa ngururu ja irina raako ˆwaampeera, sa vave kɨɨntʉ kɨmwɨ ja nɨɨnɨ na weewe viintʉ tʉrɨ kɨɨntʉ kɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mpɨɨndɨ ˆnɨjáa novo, navɨɨmɨrɨráa kwa ɨro irina ˆwaampeera. Navɨɨmɨrɨra vyabooha. Kusiina ˆarɨmɨra tʉkʉ, nɨ ʉra umudu vii, yeeye ajáa nɨ wo malwa sa Masáare ˆYarɨ Mpeho yakiimane. ");
INSERT INTO lag_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Taáta haaha nɨ na kwaako nookʉʉja. Maa kaa, nɨ lʉʉsa niise masáare aya, viintʉ ˆnkaarɨ aha weerwii, sa vave na cheerʉ ˆchakiimana mitimii yaavo. ");
INSERT INTO lag_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nɨɨnɨ navawyɨɨra vapooji vaanɨ isáare raako, maa kaa, weerʉ yavasʉʉla sa viintʉ voovo sɨ va weerʉ, ja nɨɨnɨ viintʉ sɨ ndɨrɨ wa ɨhɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nɨɨnɨ sɨ nooloomba ʉvaseyye aha weerwii tʉkʉ, maa kaa, nooloomba ʉvɨɨmɨrɨre fuma kwa ʉra Mʉvɨ. ");
INSERT INTO lag_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Voovo sɨ varɨ va ɨhɨ weerʉ tʉkʉ, ja nɨɨnɨ viintʉ sɨ ndɨrɨ wa ɨhɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Taáta, isáare raako nɨ kɨkomi, jeyyo, vatalarye vaantʉ vaako kwa kɨkomi ɨkyo. ");
INSERT INTO lag_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ja viintʉ ˆwaantʉma nɨɨnɨ kʉrɨ weerʉ, viivyo baa nɨɨnɨ navatʉma kʉrɨ weerʉ. ");
INSERT INTO lag_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Haaha nɨ kwiitalarya niise sa voovo, sa voovo novo vatalariwe kɨkomi. ");
INSERT INTO lag_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Taáta sɨ nooloomba sa ava vapooji vaanɨ vii tʉkʉ, maa kaa, noovaloombera baa vara ˆvarɨ kuunduma, so teera ukiindya waavo. ");
INSERT INTO lag_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Taáta nooloomba voosi vave kɨɨntʉ kɨmwɨ, ja viintʉ nɨɨnɨ ˆndɨrɨ kɨɨntʉ kɨmwɨ na weewe, na weewe ˆʉrɨ kɨɨntʉ kɨmwɨ na nɨɨnɨ. Kei nooloomba vave kɨɨntʉ kɨmwɨ na suusu, sa weerʉ ɨtaange nɨ weewe ˆwaantʉma nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nkongojima ɨra ˆwaampeera, naanɨ navahɨ́ɨre, sa vave kɨɨntʉ kɨmwɨ, ja viintʉ suusu ˆtʉrɨ kɨɨntʉ kɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nɨɨnɨ nɨ kɨɨntʉ kɨmwɨ ndɨrɨ novo, na weewe nɨ kɨɨntʉ kɨmwɨ ʉrɨ na nɨɨnɨ. Nooloomba vave vakiimana hamwɨ, sa kwa njɨra ɨhɨ, weerʉ yoosi ɨtaange weewe waantʉma, na waveenda ja ˆvyeene waanyenda nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Taáta, nɨ mpɨɨma yaanɨ ava ˆwaampeera vave hamwɨ na nɨɨnɨ hara haantʉ ˆndɨrɨ. Sa voone nkongojima yaanɨ ɨra ˆwaampeera, sa waanyenda, baa mwaariryo wa weerʉ sɨ ʉnavɨɨkwa. ");
INSERT INTO lag_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taáta Mʉwoloki, baa neembe weerʉ sɨ ɨkʉmányire, nɨɨnɨ nakʉmányire, na ava vamányire weewe waantʉma. ");
INSERT INTO lag_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nɨɨnɨ navakiindya ˆvyeene ʉrɨ, na kei tuuba ndɨrɨ kʉbweeyya jeyyo, sa vaveende vaanaavo ja ˆvyeene waanyenda, kei nɨɨnɨ nɨve kɨɨntʉ kɨmwɨ novo.” ");
INSERT INTO lag_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yéesu ˆakahʉmʉle kʉlʉʉsa masáare ayo, akiinʉka na vapooji vaachwe, maa vakadoma na fɨrɨro ya ilolo ra Kediróoni. Ʉko kʉjáa kwatɨɨte iwʉnda ra mɨseitúuni. Yéesu na vapooji vaachwe vakɨɨngɨra aho iwundii. ");
INSERT INTO lag_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yʉ́ʉda ʉra ˆamʉvarindʉka Yéesu, ajáa ahamányire aho haantʉ, sa Yéesu na vapooji vaachwe vadomáa kweene na aho. ");
INSERT INTO lag_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yʉ́ʉda akʉʉja na aho iwundii alóngorɨɨre mpuka ya valwi nkoondo va Kɨrúumi, na vamwɨ va vatʉmami fuma kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na Mafarisáayo. Vara valwi nkoondo na vatʉmami vajáa vakwáatɨrɨɨre vimʉrɨ, masasaankʉ na mata. ");
INSERT INTO lag_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yéesu ajáa amányire yoosi ˆyarɨ mʉfʉmɨra. Akiiturirya mbere yaavo, maa akavasea, “Ani moomʉsaakɨra?” ");
INSERT INTO lag_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Voovo vakamʉsea, “Yéesu wa Nasaréeti.” Yéesu akavasea, “Noo nɨɨnɨ.” Aho, Yʉ́ʉda ʉra ˆamʉvalandʉka, ajáa iímire hamwɨ na vara vavɨ. ");
INSERT INTO lag_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yéesu ˆakavasee “Noo nɨɨnɨ,” vakahɨndʉka na nyuma, maa vakawya na ɨsɨ. ");
INSERT INTO lag_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Akavuurya kei, “Ani moomʉsaakɨra?” Novo vakamʉsea, “Yéesu wa Nasaréeti.” ");
INSERT INTO lag_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yéesu akavasea, “Nahʉ́mwɨɨre kʉvawyɨɨra noo nɨɨnɨ. Koonɨ mookʉʉnsaakɨra nɨɨnɨ, vareki ava viilookere.” ");
INSERT INTO lag_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Masáare aya ˆyafʉmɨra sa isáare rɨra ˆalʉʉsa rikiimane, “Vara ˆwaampeera sɨ namʉtaaha baa ʉmwɨ vii tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simóoni Peéteri ajáa atɨɨte nyaasʉka njatwii. Akakʉʉla, maa akamʉtema kutu kwa kʉlʉme mʉtʉ́mwa wa mweeneɨsɨ mʉkʉʉlʉ, kʉkadʉmʉka dúú. Ʉwo mʉtʉ́mwa irina raachwe noo Maáliko asewáa. ");
INSERT INTO lag_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aho, Yéesu akamʉsea Peéteri, “Fyʉʉrɨra nyaasʉka yaako na njatwii. Eri, sɨ wootaanga nasaakwa ninywe ndʉvo ya uturikiri, ja ˆvyeene Taáta aampeera nturikiriwe tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aho, mpuka ya valwi nkoondo na mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ vaavo, na vatʉmami va vakʉ́ʉ́lʉ va Vayahúudi, vakamʉkwaata Yéesu, maa vakamuchuunga. ");
INSERT INTO lag_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Vakamʉtwaala ta na kwa Anáasi. Ʉhʉ Anáasi nɨ mʉkʉ́lʉ wa Kayáafa ajáa. Na Kayáafa noo ajáa mweeneɨsɨ mʉkʉʉlʉ mwaaka ʉwo. ");
INSERT INTO lag_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayáafa ʉko nyuma ajáa avasea vakʉ́ʉ́lʉ va Vayahúudi, nɨ vyabooha mʉʉntʉ ʉmwɨ akwye sa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Haaha, Simóoni Peéteri na mʉpooji wɨɨngɨ vamutuubáa Yéesu. Ʉhʉ mʉpooji wɨɨngɨ ajáa amányirwe nɨ mweeneɨsɨ mʉkʉʉlʉ. Sa jeyyo, akɨɨngɨra na Yéesu fʉʉrʉ balásii ya nyuumba ya mweeneɨsɨ mʉkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Maa kaa, Peéteri ajáa iímire weerwii, mbarɨmbarɨ ya mʉryaango. Aho, ʉra mʉpooji wɨɨngɨ ˆajáa amányirwe nɨ mweeneɨsɨ mʉkʉʉlʉ, akafuma na weerwii, akalʉʉsɨka na mʉʉntʉ muki ʉmwɨ ˆɨɨ́mɨrɨraa aho mʉryaangwii, maa akamʉrekera Peéteri ɨɨngɨre na nyuumbii. ");
INSERT INTO lag_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ʉra mʉʉntʉ muki akamuurya Peéteri, “Eri, weewe naawe sɨ ʉmwɨ wa vapooji va ʉhʉ mʉʉntʉ tʉkʉ wʉʉ?” Peéteri akamʉsea, “Tʉkʉ, aka nɨɨnɨ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sa viintʉ kʉjáa na mpeho, vara vatʉmami na valʉkalʉka va mweeneɨsɨ mʉkʉʉlʉ vajáa vakóriirye mooto wa makala, viímire vookoota. Peéteri ne ajáa iímire hamwɨ novo, yookoota mooto. ");
INSERT INTO lag_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mpɨɨndɨ jiijo, mweeneɨsɨ mʉkʉʉlʉ akamuurya Yéesu masáare ya vapooji vaachwe, na masáare ya ukiindya waachwe. ");
INSERT INTO lag_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yéesu akamʉsea, “Nɨɨnɨ nalʉ́ʉsaa masáare yaanɨ kɨweerwii kwa kɨra mʉʉntʉ. Sikʉ joosi nakíindyaa sinagóogii na Kaayii Njija ya Ijʉva, haantʉ Vayahúudi ˆvarɨ foo ˆviijíingaa. Nɨɨnɨ sɨ nalʉ́ʉsaa kɨɨntʉ chochoosi kimbiso tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Sa che wookuunjurya nɨɨnɨ? Vuurye vara ˆvateera kɨra ˆnakíindyaa. Voovo vamányire kɨra ˆnalʉ́ʉsaa.” ");
INSERT INTO lag_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yéesu ˆakalʉʉse jei, ʉmwɨ wa valʉkalʉka ˆajáa iímiire heehi ne, akamʉvaa ikóofi, maa akamʉsea, “Eri, jei noo ˆvyeene wuúyiryaa mweeneɨsɨ mʉkʉʉlʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yéesu akamʉsea, “Koonɨ nalúusire kɨɨntʉ ˆchavɨɨha, hoonɨ toola ʉshahíidi wa ʉvɨ waanɨ. Maa kaa, koonɨ nalúusire kɨmáárɨ, sa che waanváire?” ");
INSERT INTO lag_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Aho, Anáasi akamʉtwaala Yéesu na kwa Kayáafa mweeneɨsɨ mʉkʉʉlʉ, kʉnʉ akaarɨ achúungirwe. ");
INSERT INTO lag_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mpɨɨndɨ Simóoni Peéteri ˆajáa iímire yookoota mooto, vamwɨ va vara ˆvajáa aho, vakamuurya voosea, “Eri, weewe sɨ ʉmwɨ wa vapooji vaachwe tʉkʉ wʉʉ?” Yeeye akasiita yoosea, “Aka, nɨɨnɨ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ʉmwɨ wa vatʉmami va mweeneɨsɨ mʉkʉʉlʉ, mʉndʉʉ na ʉra ˆajáa adʉmʉlwa kutu nɨ Peéteri, akamʉsea, “Eri, sɨ nakwɨɨ́ne kʉra iwundii ʉrɨ hamwɨ na Yéesu tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peéteri akasiita kei, haaho nkʉkʉlʉme ɨkavɨɨka. ");
INSERT INTO lag_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Aho, vakamʉsʉmʉla Yéesu fuma kwa Kayáafa, maa vakamʉtwaala fʉʉrʉ ijuumbii ra kɨtemi ra gávana Piláato. Mpɨɨndɨ ijo, nɨ namʉtóondo uchikʉ kʉjáa. Vayahúudi sɨ vɨɨngɨráa na nyuumbii tʉkʉ, sa vadɨɨre kʉva na njeo, aho, vadahe kurya chóorya cha Paásika. ");
INSERT INTO lag_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sa jeyyo, Piláato akafuma na weerwii haantʉ ˆvajáa, maa akavuurya, “Eri, ʉhʉ mʉʉntʉ che abwéeyyiirye moomusitaakya kwaanɨ?” ");
INSERT INTO lag_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Voovo vakamʉsea, “Ngaarɨ ʉhʉ mʉʉntʉ sɨ abwéeyyiirye kɨɨntʉ kɨvɨ, ngaarɨ sɨ tamʉreetire na kwaako tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aho, maa Piláato akavasea, “Musumuli nyuunyu, mʉkamʉlamʉrɨre kwa Miiro yaanyu.” Maa kaa, Vayahúudi vakamʉsea, “Suusu tusiina wiimiriri wo kʉʉlaa mʉʉntʉ yoyoosi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ayo yabweeyyiwa jeyyo, sa rɨra isáare ˆalʉʉsa Yéesu nɨ inkwya ɨrɨ joolɨ arɨ kukwya, rikiimane. ");
INSERT INTO lag_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Aho, Piláato akɨɨngɨra na ijuumbii raachwe, akamwaanɨrɨra Yéesu, maa akamuurya, “Eri, weewe ʉrɨ mʉtemi wa Vayahúudi wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yéesu akamʉsea, “Aya ˆwoolʉʉsa nɨ masáare yaako mweeneevyo bakʉ vaantʉ vɨɨngɨ vakuwyɨ́ɨrɨɨre masáare yaanɨ?” ");
INSERT INTO lag_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Piláato akamʉsea, “Eri, nɨɨnɨ ndɨrɨ Mʉyahúudi wʉʉ? Vaantʉ va ɨsɨ yaako na vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva noo vakʉréetire na kwaanɨ. Nɨ che ʉbwéeyyiirye?” ");
INSERT INTO lag_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yéesu akamʉsea, “Ʉtemi waanɨ sɨ wa ɨhɨ weerʉ tʉkʉ. Ngaarɨ viri jeyyo, ngaarɨ vapooji vaanɨ valwíire nkoondo ndɨɨre veera mɨkonwii ya Vayahúudi. Maa kaa, Ʉtemi waanɨ sɨ wafuma kʉrɨ ɨhɨ weerʉ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Piláato akamuurya yoosea, “Haaha, weewe ʉrɨ mʉtemi wʉʉ?” Yéesu akamʉsea, “Weewe waséire, nɨɨnɨ ndɨrɨ mʉtemi. Sa jeyyo, nɨɨnɨ navyaalwa, na nʉʉja aha weerwii sa nɨvoonekye vaantʉ kɨmáárɨ. Mʉʉntʉ yoyoosi ˆatúubaa ɨkyo kɨmáárɨ, akwáatyaa masáare yaanɨ.” ");
INSERT INTO lag_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Piláato akamʉsea Yéesu, “Kɨmáárɨ noo che?” Aho, Piláato ˆakalʉʉse jeyyo, akafuma na weerwii, maa akɨɨta noo vasea valongooli va Vayahúudi, “Nɨɨnɨ sɨ nookoona ʉvɨ wowoosi kwa ʉhʉ mʉʉntʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Maa kaa, nyuunyu mwatɨɨte tʉʉva yo loomba nɨmʉrekere mʉʉntʉ ʉmwɨ ˆmoosaaka fuma mʉnyololwii, mpɨɨndɨ ja ɨhɨ ngovi ya Paásika. Eri, saaka mwiise nɨmʉchʉngʉrɨre mʉtemi wa Vayahúudi wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Maa kaa, voovo vakatʉlatʉʉla isóso voosea, “Ʉhʉ tʉkʉ, tʉchʉngʉrɨre Baráaba.” Ʉhʉ Baráaba nɨ mʉvarinduki wa wiimiriri wa Kɨrúumi ajáa. ");
INSERT INTO lag_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Aho, Piláato akalairirya Yéesu anʉswe mɨjeléedi, maa valʉkalʉka vakamʉvaa. ");
INSERT INTO lag_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Valwi nkoondo vakalʉka kɨsasaavo cha miíwa, vakamʉvɨkɨra mutwii na kei vakamʉrwɨɨka ɨngo ya kɨtemi ˆɨrɨ gyaa. ");
INSERT INTO lag_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Vakava vootamanya na mbere ya Yéesu, maa de vandoomuluumbya ko mʉhenchʉla voosea, “Lʉmbɨ niijo ee mʉtemi wa Vayahúudi,” kʉnʉ voomʉlatʉla makóofi. ");
INSERT INTO lag_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Piláato akafuma kei na weerwii, akavasea vara vaantʉ ˆvajáa viijíingire aho, “Laangi, namʉréetire Yéesu na kʉnʉ weerwii kei, sa mʉtaange nɨɨnɨ sɨ nookoona ʉvɨ wowoosi kwaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aho, Yéesu akafuma na weerwii kʉnʉ iivɨ́kɨɨre kɨsasaavo cha miíwa, na ɨra ɨngo ˆɨrɨ gyaa. Piláato akavasea, “Laangi, mʉʉntʉ mweeneevyo nɨ ʉhʉ!” ");
INSERT INTO lag_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na valʉkalʉka ˆvakamoone Yéesu, vakatʉlatʉʉla isóso voosea, “Muningʼinʼye mʉsaláabii fʉʉrʉ akwye! Muningʼinʼye mʉsaláabii fʉʉrʉ akwye!” Piláato akavasea, “Musumuli nyuunyu mʉkamuningʼinʼye, nɨɨnɨ sɨ nookoona ʉvɨ wowoosi kwaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Vayahúudi vakamʉsea Piláato, “Suusu tatɨɨte Mwiiro, ʉwo Mwiiro wasea, yoosaakwa akwye sa yoosea yeeye nɨ Mwaana wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Piláato ˆakateere jeyyo, akoofa mʉnʉmʉʉnʉ kʉlookya. ");
INSERT INTO lag_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Akɨɨngɨra kei na ijuumbii raachwe ra kɨtemi, maa akamuurya Yéesu, “Hai wafuma?” Maa kaa, Yéesu akakirinya sawu, sɨ alʉʉsa isáare roroosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Piláato akamʉsea, “Sɨ woosaaka kuuyirya tʉkʉ wʉʉ? Sɨ wootaanga natɨɨte wiimiriri wo kʉrekera, na wiimiriri wo kuningʼinʼya mʉsaláabii fʉʉrʉ ukwye tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yéesu akamʉsea, “Weewe ngaarɨ usiina wiimiriri wowoosi mweeri yaanɨ tʉkʉ, ngaarɨ sɨ wooheewa nɨ Mʉlʉʉngʉ. Sa jeyyo, ʉra ˆaanvíikire mɨkonwii yaako, atɨɨte ʉvɨ kʉlookya.” ");
INSERT INTO lag_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Piláato ˆakateere jeyyo, akaanda saakɨra njɨra yo mʉrekera Yéesu. Maa kaa, Vayahúudi vakatʉlatʉʉla isóso voosea, “Koonɨ wamʉrekɨɨre mʉʉntʉ ʉhʉ, weewe sɨ ʉrɨ kɨjeengi cha Kaisáari tʉkʉ. Mʉʉntʉ yoyoosi ˆiibwéeyyaa mʉtemi, amusíitaa Kaisáari mʉtemi wa Rúumi.” ");
INSERT INTO lag_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Piláato ˆakateere aya masáare, akamʉreeta kei Yéesu na weerwii. Akiikala ichuumbii raachwe ro lamʉrɨra ˆrɨrɨ haantʉ ˆhaséwaa Mʉtambalala wa Iwye, na Kɨeburanía Gabáata. ");
INSERT INTO lag_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Haaha sikʉ ɨyo, nɨ sikʉ yo kiimya neeja ngovi ya Paásika ɨjáa, na ɨjáa yafíkire mpɨɨndɨ ja mpoloonge. Piláato akavasea Vayahúudi, “Mʉtemi waanyu nʉ aha.” ");
INSERT INTO lag_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Maa kaa, voovo vakatʉlatʉʉla isóso voosea, “Mʉseyye! Mʉseyye! Muningʼinʼye mʉsaláabii fʉʉrʉ akwye.” Piláato akavuurya, “Eri, moosaaka nimuningʼinʼye mʉsaláabii mʉtemi waanyu wʉʉ?” Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva vakamʉsea, “Suusu tusiina mʉtemi wɨɨngɨ tʉkʉ, tatɨɨte Kaisáari vii.” ");
INSERT INTO lag_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aho, Piláato akamʉkwaatya Yéesu mɨkonwii ya Vayahúudi, sa ˆvakamuningʼinʼye mʉsaláabii fʉʉrʉ akwye. Aho, valwi nkoondo vakamʉsʉmʉla Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yéesu akavereka mʉsaláaba waachwe, akakwaata njɨra yo doma na haantʉ ˆhaánɨrɨrwaa Goligóota na Kɨeburanía, noo kʉsea Kɨsááya cha Mʉtwe. ");
INSERT INTO lag_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aho, noo haantʉ ˆvamuningʼinʼya mʉsaláabii fʉʉrʉ akakwya. Vaantʉ vavɨrɨ vajáa vaningʼiniwa hamwɨ ne, kɨra mʉʉntʉ mʉsaláabii waachwe, ʉmwɨ mʉkono wa kʉlʉme, na wɨɨngɨ mʉkono wa kʉmooso, ne Yéesu katɨkatɨ. ");
INSERT INTO lag_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Piláato akalairirya yaandɨkwe masáare na yavɨɨkwe mweeri ya mʉsaláaba. Masáare ayo nɨ jei yajáa yasea, “Yéesu wa Nasaréeti, mʉtemi wa Vayahúudi.” ");
INSERT INTO lag_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Masáare aya, yajáa yaandɨkwa kwa ndʉʉsɨka ya Kɨeburanía, Kɨrúumi na Kɨgiríki. Vayahúudi ˆvarɨ foo vasomáa ayo, sa haantʉ ˆvajáa vamuningʼinʼya mʉsaláabii fʉʉrʉ akakwya nɨ heehi kʉjáa na múuji wa Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva va Vayahúudi vakamʉsea Piláato, “Kaandɨka, ‘Mʉtemi wa Vayahúudi’ tʉkʉ, andɨka jei, ‘Mʉʉntʉ ʉhʉ asea, nɨɨnɨ ndɨrɨ mʉtemi wa Vayahúudi.’ ” ");
INSERT INTO lag_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piláato akavasea, “ˆCheene nɨɨnɨ naándikire, naándikire!” ");
INSERT INTO lag_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Valwi nkoondo ˆvakahʉmʉle kumuningʼinʼya Yéesu mʉsaláabii, vakatoola ɨngo jaachwe, maa vakajigava malʉʉndʉ yanɨ. Kɨra mulwi nkoondo akasʉmʉla ilʉʉndʉ rɨmwɨ. Nkáancho yaachwe ɨjáa yachʉmɨrɨrwa ko domerera fuma mweeri fʉʉrʉ ɨsɨ, na ɨjáa isiina mʉláwo tʉkʉ. Noyo vakɨɨtoola. ");
INSERT INTO lag_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Vakiiwyɨɨra voosea, “Karɨ twɨɨmoole ɨhɨ nkáancho tʉkʉ, hendi tʉvae mbare sa tʉtaange nɨ ani arɨ kɨɨsʉmʉla.” Aya yafʉmɨra sa Masáare ˆYarɨ Mpeho yakiimane ja ˆvyeene yasea, Viigavɨra ɨngo jaanɨ, na nkáancho yaanɨ vakɨɨvaɨra mbare. Jeyyo, noo ˆvyeene valwi nkoondo vabweeyya. ");
INSERT INTO lag_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Heehi na mʉsaláabii wa Yéesu, kʉjáa kwatɨɨte Maríia íyo waavo, mwaanaavo na íyo waavo, Maríia muki wa Kiléeopa na Maríia Makɨdaléena. ");
INSERT INTO lag_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yéesu akamoona íyo waavo iímire aho, hamwɨ na mʉpooji waachwe ʉmwɨ. Ʉhʉ mʉpooji Yéesu ajáa amweenda. Jeyyo, akamʉsea íyo waavo, “Íyo, laanga, ʉwo haaha nɨ mwaana waako.” ");
INSERT INTO lag_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aho, akamʉsea ʉra mʉpooji, “Laanga, ʉwo haaha nɨ íyo waanyu.” Keende mpɨɨndɨ ɨra, ʉra mʉpooji akamʉsʉmʉla íyo waala Yéesu, akɨɨta kiikala kwaachwe. ");
INSERT INTO lag_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ayo ˆyakalooke, na kʉnʉ Yéesu yootaanga ahʉ́mwɨɨre tʉmama mʉrɨmo waachwe, akasea, “Nakálukirwe,” sa Masáare ˆYarɨ Mpeho yakiimane. ");
INSERT INTO lag_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aho, kʉjáa kwatɨɨte bakúuri ˆɨmémire diváai ˆyasasʉka. Vakatukya kɨɨntʉ kɨrɨ monyomonyo diváaii ˆyasasʉka, vakatuungirirya nkomii ya faaɨ, maa vakamʉheera Yéesu mʉlomwii. ");
INSERT INTO lag_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yéesu ˆakasaɨre ɨra diváai ˆyasasʉka, maa akasea, “Yakíimɨɨne.” Aho, akiinamya mʉtwe waachwe, maa akawulala. ");
INSERT INTO lag_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sikʉ ɨra, nɨ sikʉ yo kiimya neeja ngovi ya Paásika ɨjáa, na Sabáato ɨra nɨ nkʉ́ʉ́lʉ ɨjáa. Vayahúudi sɨ vasaakáa mɨvɨrɨ ɨchaale mɨsaláabii sikʉ ya Sabáato tʉkʉ. Sa jeyyo, vakamʉloomba Piláato, vaantʉ vara ˆvajáa vaníngʼiniiwe mɨsaláabii, mawʉlʉ yaavo yawunwe, na mɨvɨrɨ yaavo ɨseyyiwe mɨsaláabii. ");
INSERT INTO lag_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Valwi nkoondo vakatamanya, vakawuna mawʉlʉ ya mʉʉntʉ wa ncholo na wa kavɨrɨ wa vara ˆvajáa vaníngʼiniiwe fʉʉrʉ vakwye hamwɨ na Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Maa kaa, ˆvakafike kwa Yéesu, vakashaana awʉ́lɨɨre. Sa jeyyo, sɨ vamʉwʉna mawʉlʉ yaachwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kɨrɨ vyoova jeyyo, ʉmwɨ wa valwi nkoondo akamʉtʉʉnga na ichimu lʉvarwii, aho, sakami na maaji vikafuma. ");
INSERT INTO lag_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mʉʉntʉ ˆoona masáare aya noo ˆmweene ayalʉʉsa, na kɨra ˆoonekya nɨ cha kɨmáárɨ. Ʉhʉ ayalʉʉsa masáare aya, amányire masáare aya nɨ ya kɨmáárɨ, na yoovoonekya nyuunyu sa murume. ");
INSERT INTO lag_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Aya yafʉmɨra sa Masáare ˆYarɨ Mpeho yakiimane ja ˆvyeene yalʉʉsa, “Kusiina ikúfa raachwe ˆrɨrɨ wunwa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kei Masáare ˆYarɨ Mpeho haantʉ hɨɨngɨ yasea, “Moona varɨ ʉra ˆvamʉtʉʉnga.” ");
INSERT INTO lag_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆaséwaa Yooséefu fuma múuji wa Arimatáaya. Yeeye nɨ mʉpooji wa Yéesu ajáa wa kimbiso, sa avoofáa Vayahúudi. Yeeye akatamanya na kwa Piláato akɨtooloomba mʉvɨrɨ wa Yéesu sa akʉʉtaahe. Piláato akamʉrʉmɨra, maa Yooséefu akɨɨta kʉʉsʉmʉla mʉvɨrɨ wa Yéesu. ");
INSERT INTO lag_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodéemu ʉra aho ncholo ˆajáa adoma na kwa Yéesu nuuchikʉ, akareeta makuta ya idumbaasi ˆyasaangiwa na manemáane ja kílo makumi yatatʉ (30). ");
INSERT INTO lag_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Vakasʉmʉla mʉvɨrɨ wa Yéesu, vakʉʉfarɨmbɨrɨra na sáanda ya kɨtáani, kʉnʉ voohaka yara makuta ˆyanyʉkɨra, ja viintʉ tʉʉva ja Vayahúudi jo taaha ˆjiri. ");
INSERT INTO lag_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Heehi na aho haantʉ Yéesu ˆajáa aníngʼiniiwe mʉsaláabii fʉʉrʉ akakwya, kʉjáa kwatɨɨte iwʉnda. Aho iwundii, kʉjáa kwatɨɨte mbɨrɨ́ɨ́ra ya mpaanga ifya ˆyabokwa mwaalaliwyii sɨ ˆɨnataahwa mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sa viintʉ sikʉ ɨyo nɨ sikʉ ya Kɨyahúudi yo kiimya neeja Sabáato ɨjáa, na sa viintʉ ɨyo mbɨrɨ́ɨ́ra ɨjáa heehi, vakamʉtaaha Yéesu aho. ");
INSERT INTO lag_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Namʉtóondo uchikʉ wa sikʉ ya Jumapɨ́ɨrɨ, viintʉ kʉkaarɨ chi chi, Maríia Makɨdaléena akatamanya na mbiríírii ya mpaanga ˆyabokwa mwaalaliwyii kʉʉntʉ Yéesu ˆataahwa. Kʉra, akashaana rɨra iwye ˆrakʉnɨkɨrɨra mbɨrɨ́ɨ́ra, raséyyiiwe fuma mʉryaangwii wa mbɨrɨ́ɨ́ra. ");
INSERT INTO lag_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jeyyo, akafuma itɨ́ɨjo fʉʉrʉ kʉrɨ Simóoni Peéteri, na kwa ʉra mʉpooji wɨɨngɨ Yéesu ˆajáa amweenda. Aho, maa akavasea, “Vamʉséyyiirye Mweenevyoosi mbiríírii, na sɨ tootaanga haantʉ ˆvamʉvɨ́ɨkɨre tʉkʉ!” ");
INSERT INTO lag_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jeyyo, Peéteri na ʉra mʉpooji wɨɨngɨ vakafuma itɨ́ɨjo voodoma na mbiríírii. ");
INSERT INTO lag_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Voosi vavɨrɨ vatɨɨjáa, maa kaa, ʉra mʉpooji akamʉlooka Peéteri, na akava wa ncholo kufika mbiríírii. ");
INSERT INTO lag_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ˆAkafike, akasʉngɨrɨra mbiríírii, akoona ntaamɨ ja sáanda ya kɨtáani ivarwii, maa kaa, sɨ ɨɨngɨra na mbiríírii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aho, Simóoni Peéteri akʉʉja nyuma, akahʉlʉlʉka na mbiríírii. Ne akoona jira ntaamɨ ja sáanda ya kɨtáani jiri ivarwii. ");
INSERT INTO lag_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kei, akoona ɨra ntaamɨ ˆɨjáa yachuungwa mutwii wa Yéesu, ɨrɨ kisima na jira ntaamɨ jɨɨngɨ, yaárirwe na ivarwii. ");
INSERT INTO lag_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Aho, ʉra mʉpooji ˆajáa afíkire wa ncholo akɨɨngɨra na mbiríírii, akoona na akaruma. ");
INSERT INTO lag_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mpɨɨndɨ ijo, vapooji vajáa vakaarɨ taanga Masáare ˆYarɨ Mpeho ˆvyeene yalʉʉsa, Yéesu nɨ mpaka afʉfʉke fuma inkwyii. ");
INSERT INTO lag_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Aho, avo vapooji vakahɨndʉka na kaayii. ");
INSERT INTO lag_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maa kaa, Maríia Makɨdaléena akachaala iímire weerwii ya mbɨrɨ́ɨ́ra yoorɨra. Mpɨɨndɨ ˆarɨráa, akiinama, maa akasʉngɨrɨra na isii ya mbɨrɨ́ɨ́ra. ");
INSERT INTO lag_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Akoona mirimʉ miija ɨvɨrɨ ˆyiivɨ́kɨɨre ɨngo njerʉ chwee, yiíkyɨɨre haantʉ mʉvɨrɨ wa Yéesu ˆʉjáa ʉlaarɨɨwé, ʉmwɨ mitwii na wa kavɨrɨ majewii. ");
INSERT INTO lag_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ɨra mirimʉ miija ɨkamuurya Maríia yoosea, “Íyo, sa che woorɨra?” Ne akavasea, “Sa vamʉtwɨ́ɨre Mweenevyoosi waanɨ, na sɨ nootaanga nɨ hai ˆvamuvíikire tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ˆAkahʉmʉle lʉʉsa ayo, akiilorera, akamoona Yéesu iímire, maa kaa, sɨ ataanga koonɨ nɨ Yéesu ajáa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yéesu akamuurya, “Íyo, sa che woorɨra? Nɨ ani woomʉsaakɨra?” Maríia akɨɨsea ʉra ˆyoolʉʉsɨka ne nɨ mʉlaangiriryi wa iwʉnda. Sa jeyyo, akamʉsea, “Taáta, koonɨ nɨ weewe ʉmʉtwɨ́ɨre, kalaama ndaɨra haantʉ ˆumuvíikire, naanɨ mʉsʉmʉla ndɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aho, Yéesu akamwaanɨrɨra, “Maríia!” Maríia akavarindʉka, maa akasea na Kɨeburanía, “Rabóoni!” noo kʉsea, “Mukiindya!” ");
INSERT INTO lag_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yéesu akamʉsea, “Kʉʉnsaasya tʉkʉ, sa nkaarɨ kaambʉka na kwa Taáta waanɨ. Kɨrɨ vyoova jeyyo, tamanya na kwa vandʉʉ vaanɨ ʉkavasee, ‘Kaambʉka niise na kwa Taáta waanɨ, ne nɨ Taáta waanyu, na kwa Mʉlʉʉngʉ waanɨ, ne nɨ Mʉlʉʉngʉ waanyu.’ ” ");
INSERT INTO lag_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jeyyo, Maríia Makɨdaléena akatamanya na kwa vapooji va Yéesu, akavawyɨɨra masáare aya, yoosea, “Namwɨɨ́ne Mweenevyoosi!” Ne akavawyɨɨra yoosi Yéesu ˆajáa amʉwyɨ́ɨrɨɨre. ");
INSERT INTO lag_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nakyʉʉlwa ya sikʉ ɨʼɨra ya Jumapɨ́ɨrɨ, vapooji va Yéesu vajáa viisaanga hamwɨ nyuumbii ɨmwɨ. Vajáa vachuunga mɨryaango sa voofa vakʉ́ʉ́lʉ va Vayahúudi. Aho, Yéesu akavafʉmɨra, akɨɨma katɨ na katɨ yaavo akavasea, “Mwiikalo mʉʉja ʉve na nyuunyu!” ");
INSERT INTO lag_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ˆAkahʉmʉle kʉlʉʉsa ayo, akavoonekya mɨkono yaachwe na lʉvaru lwaachwe. Vapooji vaachwe vakavyeenda maatʉkʉ kʉmoona Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yéesu akavasea kei, “Mwiikalo mʉʉja ʉve na nyuunyu! Ja ˆvyeene Taáta aantʉma nɨɨnɨ, naanɨ nɨ kʉvatʉma niise nyuunyu.” ");
INSERT INTO lag_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ˆAkahʉmʉle kʉlʉʉsa ayo, akavafwɨɨrɨra nkeeho, maa akavasea, “Hokeri Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Koonɨ mʉmʉséire mʉʉntʉ ʉvɨ waachwe wasírire, Mʉlʉʉngʉ sea arɨ ʉvɨ waachwe wasírire. Koonɨ sɨ mʉmʉséire mʉʉntʉ ʉvɨ waachwe wasírire, Mʉlʉʉngʉ ne sɨ arɨ sea ʉvɨ waachwe wasírire tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ʉmwɨ wa vapooji ikimi na vavɨrɨ va Yéesu ˆasewáa Tomáasi, irina rɨɨngɨ Maása, yeeye sɨ ajáa na viivaachwe mpɨɨndɨ Yéesu ˆavafʉmɨráa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jeyyo, vara vapooji viivaachwe vakamʉsea, “Tamwɨɨ́ne Mweenevyoosi.” Maa kaa, Tomáasi akavasea, “Koonɨ sɨ nɨɨ́ne nkoru ja mɨsʉmáari mɨkonwii yaachwe, na nkwaate ijo nkoru na imaamba raanɨ, na nvɨɨke mʉkono waanɨ lʉvarwii lwaachwe, sɨ ndɨrɨ ruma tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sikʉ inaanɨ ˆjikalooke, vapooji va Yéesu kei vajáa hamwɨ nyuumbii. Sikʉ ɨyo, Tomáasi ne nɨ hamwɨ ajáa novo. Aho, Yéesu akʉʉja kʉnʉ mɨryaango ichúungirwe. Akɨɨma katɨ na katɨ yaavo, maa akasea, “Mwiikalo mʉʉja ʉve na nyuunyu!” ");
INSERT INTO lag_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Aho, akamʉsea Tomáasi, “Vɨɨka imaamba mɨkonwii yaanɨ, woone mɨkono yaanɨ. Wolola mʉkono waako ʉkwaate lʉvaru lwaanɨ. Karɨ ʉve na wiikoveriri kei tʉkʉ, maa kaa, urume.” ");
INSERT INTO lag_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomáasi akamʉsea, “Mweenevyoosi waanɨ, na Mʉlʉʉngʉ waanɨ!” ");
INSERT INTO lag_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yéesu akamʉsea Tomáasi, “Urúmire sa viintʉ wanyɨɨ́ne wʉʉ? Vatalariwa vara sɨ ˆvaanyona, maa kaa vaanduma.” ");
INSERT INTO lag_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yéesu abweeyya isháara na myuujíisa ˆɨrɨ foo miiswii ya vapooji vaachwe, ˆmyeene sɨ yaandɨkwa aha kɨtáabwii. ");
INSERT INTO lag_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Maa kaa, ɨhɨ yaandɨkwa sa murume Yéesu noo Masía, Mwaana wa Mʉlʉʉngʉ, na sa kwa njɨra yo muruma, mʉve nkaasʉ kwa irina raachwe. ");
INSERT INTO lag_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ayo ˆyakalooke, Yéesu akavafʉmɨra vapooji vaachwe mbarɨmbarɨ ya iriva ra Tibéria, noo kʉsea iriva ra Galiláaya. Jei noo ˆvyeene iiyonekya kwaavo, ");
INSERT INTO lag_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simóoni Peéteri, Tomáasi ˆaséwaa Maása, Nasaniéeli mʉʉntʉ wa Káana ya Galiláaya, vaana vavɨrɨ va Sebedáayo, na vapooji vɨɨngɨ vavɨrɨ nɨ hamwɨ vajáa. ");
INSERT INTO lag_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simóoni Peéteri akavasea viivaachwe, “Nɨɨnɨ tamanya niise no kwaata soompa.” Novo vakamʉsea, “Tamanya tiise hamwɨ na weewe.” Vakatamanya na mashúwii, maa kaa, uchikʉ ʉra sɨ vaambʉrɨra kɨɨntʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ˆKʉkaande mwaa, Yéesu akɨɨma mbarɨmbarɨ ya iriva, maa kaa, vapooji sɨ vataanga koonɨ nɨ Yéesu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yéesu akavuurya, “Vanavaanɨ, mwakwáatɨre soompa yoyoosi wʉʉ?” Vakamʉsea, “Tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yéesu akavasea, “Haaha kiimyi njwaavu na ivaru ra kʉlʉme ra mashʉ́wa yaanyu, naanyu kwaata mʉrɨ soompa.” Aho, vakakiimya njwaavu, laanga, vakasiindwa rʉta njwaavu, sa jijáa jakwáatire soompa ˆjamema maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Maa mʉpooji Yéesu ˆajáa amweenda, akamʉsea Peéteri, “Ʉhʉ nɨ Mweenevyoosi.” Simóoni Peéteri ˆakateere jei, akiichuunga ɨngo yaachwe, ˆngʼeene ajáa iifúmiirye mpɨɨndɨ ˆaandáa mʉrɨmo, aho, akiifweitɨra na irivii. ");
INSERT INTO lag_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Vara vapooji vɨɨngɨ vakʉʉja na mashʉ́wa kʉnʉ vooruta njwaavu ˆjimémire soompa. Sɨ vajáa kʉlɨ na mbarɨmbarɨ tʉkʉ, nɨ ja mawʉlʉ igana rɨmwɨ (100) vii vajáa. ");
INSERT INTO lag_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ˆVakafike mbarɨmbarɨ ya iriva haantʉ ˆhʉʉma, vakoona mooto wa makala na soompa na mɨkáate ˆyoókiiwe mweeri yaachwe. ");
INSERT INTO lag_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yéesu akavasea, “Reeti jimwi ja soompa ˆmʉkwáatire haaha vii.” ");
INSERT INTO lag_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simóoni Peéteri akaambʉka na mashúwii, akarʉta lʉra lwaavu fʉʉrʉ mbarɨmbarɨ haantʉ ˆhʉʉma. Lʉjáa lwamémire soompa nkʉʉlʉ igana rɨmwɨ, makumi yasaano na itatʉ (153). Baa neembe soompa jijáa jamema jeyyo, lwaavu sɨ lwaatʉka tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yéesu akavasea vapooji vaachwe, “Yeendi murye cha mʉtóondo!” Kusiina baa ʉmwɨ ˆadaha kumuurya kʉsea, “Weewe ʉrɨ ani?” tʉkʉ. Ava vajáa vataanga nɨ Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yéesu akaseesa, akatoola ʉra mʉkáate, maa akavaheera. Akabweeyya vivira baa na jira soompa. ");
INSERT INTO lag_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ʉlʉ nɨ lwa katatʉ Yéesu avafʉmɨra vapooji vaachwe, keende ˆakafʉfʉlwe. ");
INSERT INTO lag_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ˆVakahʉmʉle kurya, Yéesu akamuurya Simóoni Peéteri, “Eri, Simóoni mwaana wa Yooháani, waanyenda kʉlookya ava viivaako wʉʉ?” Simóoni akasea, “Hɨɨ Mʉkʉ́lʉ, weewe wamányire nakweenda.” Yéesu akamʉsea, “Riisha muundi jaanɨ.” ");
INSERT INTO lag_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yéesu akamuurya kei, “Simóoni mwaana wa Yooháani, waanyenda wʉʉ?” Peéteri akasea, “Hɨɨ Mʉkʉ́lʉ, weewe wamányire nakweenda.” Yéesu akamʉsea, “Laanga muundi jaanɨ.” ");
INSERT INTO lag_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yéesu akamuurya Peéteri lwa katatʉ, “Simóoni mwaana wa Yooháani, waanyenda wʉʉ?” Peéteri akiirya kisho, akavisʉʉla sa viintʉ Yéesu ajáa amuúriirye lwa katatʉ, “Waanyenda wʉʉ?” Peéteri akamʉsea Yéesu, “Mʉkʉ́lʉ, weewe wamányire yoosi, wamányire nɨɨnɨ nakweenda.” Yéesu akamʉsea, “Riisha muundi jaanɨ. ");
INSERT INTO lag_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kɨmaarɨ kaa nookuwyɨɨra, mpɨɨndɨ ˆʉjáa mʉtavana, wiichuungáa ɨngo jaako na watamanyáa na haantʉ ˆwoosaaka. Maa kaa, ˆʉrɨ kʉva moosi, wolola ʉrɨ mɨkono yaako, na mʉʉntʉ wɨɨngɨ kʉkʉvɨkɨra arɨ ɨngo jaako, na kʉtwaala arɨ haantʉ sɨ ˆwoosaaka.” ");
INSERT INTO lag_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yéesu alʉʉsa aya, koonekya inkwya ˆarɨ kukwya Peéteri, na mʉbweeyyirya arɨ Mʉlʉʉngʉ nkongojima. Aho, Yéesu akamʉsea Peéteri, “Ntuuba!” ");
INSERT INTO lag_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aho, Peéteri akiilorera, akamoona mʉpooji yoovatuuba. Ʉhʉ mʉpooji Yéesu ajáa amweenda. Ʉhʉ noo ʉra ˆajáa iisikirirya kɨpeembii cha Yéesu mpɨɨndɨ ˆvarijáa kiiwʉlo na akuurya, “Mʉkʉ́lʉ, nɨ ani ˆarɨ kʉvarindʉka?” ");
INSERT INTO lag_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peéteri ˆakamoone ʉwo mʉpooji, akamuurya Yéesu, “Mʉkʉ́lʉ, na ʉhʉ ne joolɨ?” ");
INSERT INTO lag_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yéesu akamʉsea, “Koonɨ noosaaka achaale arɨ nkaasʉ fʉʉrʉ sikʉ ˆndɨrɨ hɨndʉka, chaako che? Weewe ntuuba nɨɨnɨ.” ");
INSERT INTO lag_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sa jeyyo, fwefwe ikeenera kwa vapooji ˆvarɨ foo, kʉsea ʉhʉ mʉpooji sɨ arɨ kukwya tʉkʉ. Maa kaa, Yéesu sɨ alʉʉsa ʉwo mʉpooji sɨ arɨ kukwya tʉkʉ, kɨɨntʉ ˆalʉʉsa nɨ ɨkɨ, “Koonɨ noosaaka ave nkaasʉ fʉʉrʉ sikʉ ˆndɨrɨ hɨndʉka, chaako che?” ");
INSERT INTO lag_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mʉpooji ʉhʉ, noo ayoonekya kɨkomi masáare aya na ayaandɨka. Na suusu tamányire aya ˆoonekya nɨ ya kɨmáárɨ. ");
INSERT INTO lag_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kwatɨɨte masáare yɨɨngɨ ˆyarɨ foo ˆatʉmama Yéesu. Ngaarɨ yoosi yaandɨkwa, ngaarɨ weerʉ yoosi sɨ yatoosha kʉvɨkɨra vitáabu ˆviri kaandɨkwa tʉkʉ.");
INSERT INTO lag_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Toofíili mwanawiitʉ, kʉra kɨtáabwii ˆchalongoola, nakwaandɨkɨra masáare yoosi Yéesu ˆaanda tʉmama no variyʉla ");
INSERT INTO lag_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","fʉʉrʉ sikʉ ɨra ˆakasʉmʉlwe na kurumwii. Ajáa de asʉmʉlwe na kurumwii, avalairirya vatumwi vaachwe ˆavasaawʉla kwa njɨra ya Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kwa sikʉ makumi yanɨ (40) keende ˆakafʉfʉke, avafʉmɨra vatumwi vaachwe ˆvarɨ foo kwa njɨra ˆjoonekya kɨkomi yeeye nɨ mooyo ajáa. Kei avakiindyáa masáare ya Ʉtemi wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mpɨɨndɨ ɨmwɨ kati ˆajáa novo, ajáa avalairirya yoovasea, “Karɨ mufúmaa múujii wa Yerusaléemu tʉkʉ, mʉmʉwoojere mʉmʉnʉ Mʉtɨma Mʉʉja ʉra Taáta waanɨ ˆajáa iichuunga kʉvaretera arɨ, ʉra ˆmwateera fuma kwaanɨ. ");
INSERT INTO lag_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yooháani Mʉbatisáaji abatisáa vaantʉ na maaji, maa kaa, sikʉ ingaɨ vii ˆjookʉʉja, nyuunyu batisiwa mʉrɨ na Mʉtɨma Mʉʉja.” ");
INSERT INTO lag_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mpɨɨndɨ vatumwi ˆvajáa viijíingire hamwɨ na Yéesu, vakamuurya voosea, “Eri, Mʉkʉ́lʉ, mpɨɨndɨ iji noo ʉrɨ tʉhɨndʉrɨra suusu Viisiraéeli ʉtemi wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Maa kaa, Yéesu akavasea, “Sikʉ na mpɨɨndɨ sɨ mʉrɨmo waanyu kʉtaanga tʉkʉ, ɨro nɨ ra Taáta ˆarɨ vɨɨka kwa wiimiriri waachwe. ");
INSERT INTO lag_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Maa kaa, mʉrɨ hokera ngururu mpɨɨndɨ Mʉtɨma Mʉʉja ˆarɨ kʉʉja na kʉrɨ nyuunyu, kʉva mʉrɨ vara ˆvoónekyaa kɨkomi chaanɨ múujii Yerusaléemu, kwa ɨsɨ yoosi ya Yudéea na Samaría na fʉʉrʉ utulo waasɨ.” ");
INSERT INTO lag_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ˆAkahʉmʉle kʉlʉʉsɨka ayo, hahara akasʉmʉlwa na kurumwii, vatumwi voosi ntɨ ˆvoomoona. Aho, ichu rɨkamʉkʉnɨkɨrɨra, sɨ vamoona kei tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ntɨ ˆvajáa vakaarɨ voolaanga kurumwii koona ja ˆvyeene yootamanya na kurumwii, koonka vaantʉ valʉme vavɨrɨ viivɨ́kɨɨre ɨngo njerʉ vakɨɨma mbarɨmbarɨ yaavo! ");
INSERT INTO lag_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Avo vaantʉ vakavasea, “Ee vaantʉ va Galiláaya, sa che mwiímire aha no laanga kurumwii? Yéesu asʉ́mwɨɨrwe kʉdoma na kurumwii fuma kʉrɨ nyuunyu, hɨndʉka arɨ jeyyo ja ˆvyeene mʉmwɨɨ́ne yootamanya na kurumwii.” ");
INSERT INTO lag_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hara, vatumwi va Yéesu vakahɨndʉka na Yerusaléemu fuma Luulwii lwa Mɨseitúuni. Fuma luulwii fʉʉrʉ Yerusaléemu, nɨ lʉyeendo lwa sikʉ ya Sabáato lʉjáa. ");
INSERT INTO lag_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ˆVakɨɨngɨre múujii, vakaambʉka na gorófii kʉʉntʉ ˆviikaláa. Ava noo vajáa aho, Peéteri, Yooháani, Yaakúupu, Anderéa na Filíipi, Tomáasi, Batolomáayo na Matáayo, Yaakúupu sha Alʉfáayo, Simóoni Selóote na Yʉ́ʉda sha Yaakúupu. ");
INSERT INTO lag_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Avo voosi viijiingáa kʉmʉloomba Mʉlʉʉngʉ na mʉryʉʉngʉ ʉmwɨ. Baa kei, vajáa vamwaarɨ vaantʉ vaki vɨɨngɨ baa na Maríia íyo waala Yéesu na vandʉʉ vaachwe. ");
INSERT INTO lag_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sikʉ ɨmwɨ vaantʉ igana rɨmwɨ na makumi yavɨrɨ (120) vajáa viijíingire, aho, Peéteri akɨɨma katɨ na katɨ ya vaantʉ ˆvamuruma Yéesu. Akavasea, ");
INSERT INTO lag_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Vanaviitʉ, Masáare ˆYarɨ Mpeho yakiimana, kwa kɨra Mʉtɨma Mʉʉja ˆalʉʉsa ko tweera mʉtemi Daúdi mweeri ya ayo masáare ya Yʉ́ʉda ˆmweene avalongoola vara ˆvamʉkwaata Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yʉ́ʉda nɨ ʉmwɨ wiiswi ajáa, na suusu tatʉmamáa ne mʉrɨmo ʉhʉ wa Mʉlʉʉngʉ hamwɨ ne. ");
INSERT INTO lag_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yʉ́ʉda awʉla iwʉnda na jira mpía ˆapata kwa nteendo mbɨ. Na mpɨɨndɨ ˆajáa ʉko aawya na ɨnda, na ɨnda yaachwe yaatʉka mpaka matuumbu yakɨɨtɨka na weerwii. ");
INSERT INTO lag_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Masáare aya, yajáa yeenera Yerusaléemu yoosi. Sa jeyyo, vakaraanɨrɨra ɨro iwʉnda Akelidáama, noo kʉsea, ‘Iwʉnda ra Sakami.’ ");
INSERT INTO lag_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kɨtáabu cha Sabúuri chalʉʉsa, ‘Nyuumba yaachwe ɨchaale ntʉhʉ, karɨ kʉve na mʉʉntʉ ˆarɨ chaala aho tʉkʉ.’ Kei kwaandɨkwa, ‘Haantʉ haachwe hasʉmʉlwe nɨ mʉʉntʉ wɨɨngɨ.’ ");
INSERT INTO lag_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Sa jeyyo, toosaakwa tʉsaawʉle mʉʉntʉ wɨɨngɨ ˆiituubáa na suusu mpɨɨndɨ joosi Yéesu Mweenevyoosi ˆajáa na suusu. ");
INSERT INTO lag_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ʉwo asaakwa ave ʉra ˆavíjaa na suusu keende Yéesu ˆakabatisiwe nɨ Yooháani Mʉbatisáaji fʉʉrʉ sikʉ asʉmʉlwa na kurumwii. Ʉra ˆarɨ saawʉlwa, yoosaakwa ave ʉra ˆoona hamwɨ na suusu kʉfʉfʉka kwa Yéesu.” ");
INSERT INTO lag_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hara vakalʉʉsa marina ya vaantʉ vavɨrɨ. Yooséefu ˆasewáa Barisába irina rɨɨngɨ noo Yústo akemerwáa na wa kavɨrɨ Matiáasi. ");
INSERT INTO lag_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Aho, vakalʉʉsɨka na Mweenevyoosi voosea, “Mweenevyoosi, weewe ʉmányire mʉtɨma wa kɨra mʉʉntʉ. Tʉlaɨre kati ya ava vavɨrɨ nɨ ani ˆʉmʉsáawɨɨre, ");
INSERT INTO lag_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","sa asʉmʉle mʉrɨmo wa utumi ˆmweene warekirwé nɨ Yʉ́ʉda. Yeeye ˆakakwye atamanya na kʉʉntʉ yeeye ˆasaakwa adome.” ");
INSERT INTO lag_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Vakasaawʉla ko vaa mbare, na mbare ɨkamuwyɨɨra Matiáasi. Jeyyo Matiáasi akasaangɨra na vatumwi vara vɨɨngɨ ikimi na ʉmwɨ. ");
INSERT INTO lag_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sikʉ ya ngovi ya Pentekóste ˆɨkafike, vaantʉ voosi ˆvamuruma Yéesu vajáa viijiinga haantʉ hamudu. ");
INSERT INTO lag_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Koonka, ɨkateereka sawúti fuma kurumwii ja ya ihúmbuuto ikʉlʉkʉʉlʉ yooruma. Ɨyo sawúti ɨkamema nyuumba ˆngʼeene viikaláa. ");
INSERT INTO lag_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hahara, vakoona viintʉ ˆviri ja lʉrɨɨjo lwa mooto. Ʉlo lʉrɨɨjo lukiikerakera na lukiikala mweeri ya kɨra mʉʉntʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Vaantʉ voosi ˆvajáa aho, vakahokera Mʉtɨma Mʉʉja, vakaanda lʉʉsɨka ndʉʉsɨka jɨɨngɨ, ja ˆvyeene Mʉtɨma Mʉʉja ajáa avaheera ngururu jo lʉʉsɨka. ");
INSERT INTO lag_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Haaha aho Yerusaléemu, kʉjáa kwatɨɨte Vayahúudi ˆvamutuubáa Mʉlʉʉngʉ. Avo vajáa vafúmire ɨsɨ joosi vʉʉ ja weerʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ˆVakateere ɨyo sawúti, vakadoma itɨ́ɨjo, vakiijiinga na vaantʉ vɨɨngɨ ˆvarɨ foo. Vakahwaalala maatʉkʉ sa kɨra ʉmwɨ waavo avateeráa avo vaantʉ ˆvamuruma Yéesu voolʉʉsɨka ndʉʉsɨka jaavo. ");
INSERT INTO lag_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Vakahwaalala na vakiivʉndʉka. Vakaanda kiiyurya voosea, “Eri, ava vaantʉ ˆvoolʉʉsɨka jei sɨ Vagaliláaya tʉkʉ wʉʉ? ");
INSERT INTO lag_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ha de joolɨ kɨra ʉmwɨ wiitʉ yoovateera voolʉʉsɨka ndʉʉsɨka jiitʉ ˆtavyaalwa nojo? ");
INSERT INTO lag_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vamwɨ viitʉ tafúmire ɨsɨ ya Vapáasi, Vaméedi, na Vaeláami, vɨɨngɨ tafúmire ɨsɨ ya Mesopotámia, Yudéea, Kapadokía, Póonto na Ásia, ");
INSERT INTO lag_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","vamwɨ Firigía na Pamufilía, Mísiri na Líbia sengerera na Kɨréene na vɨɨngɨ tafúmire Róoma. ");
INSERT INTO lag_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Vamwɨ viitʉ nɨ Vayahúudi na vaantʉ vɨɨngɨ ˆvatúubaa díini ya Kɨyahúudi. Vamwɨ vafúmire Kɨréete na vɨɨngɨ Arábia. Suusu voosi toovateera voolʉʉsɨka ndʉʉsɨka jiitʉ, voomʉdʉʉmba Mʉlʉʉngʉ kwa masáare makʉʉlʉ Mʉlʉʉngʉ ˆabwéeyyaa.” ");
INSERT INTO lag_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Vaantʉ voosi vakahwaalala maatʉkʉ no koofa. Vaakiiyurya voosea, “Ʉvariyuli wa masáare aya nɨ kɨɨntʉ che?” ");
INSERT INTO lag_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Maa kaa, vamwɨ vaavo vakaanda kʉvahenchʉla voosea, “Varéeviiwe nɨ diváai ifya!” ");
INSERT INTO lag_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Aho, Peéteri akɨɨma hamwɨ na vara vatumwi ikimi na ʉmwɨ, akaanda vawyɨɨra vaantʉ na sawúti nkʉʉlʉ, “Nyuunyu vaantʉ va Yudéea na vɨɨngɨ voosi ˆmwiíkalaa Yerusaléemu, nteereri neeja nɨvawyɨɨre masáare ˆyafʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nyuunyu mookiisea vaantʉ ava varéevire, amwɨ iji noo mpɨɨndɨ jo yʉʉrɨra ngʼoombe vii? ");
INSERT INTO lag_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kɨkomi masáare aya ˆyafʉ́mɨɨre, noo yara ˆyalʉʉswa nɨ Mʉlʉʉngʉ kwa njɨra ya mʉláali na mʉtwe waachwe Yoéeli. Yeeye asea, ");
INSERT INTO lag_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Sikʉ ja ʉhero, Mʉlʉʉngʉ yoolʉʉsa, mʉkʉngʼʉntɨra ndɨrɨ kɨra mʉʉntʉ Mʉtɨma waanɨ Mʉʉja. Vaana vaanyu va kɨɨntʉ kɨlʉme na va kɨɨntʉ kiki laala veende na mʉtwe, vatavana koona veende njori, na vawosi lootera veende. ");
INSERT INTO lag_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mpɨɨndɨ ijo, vakʉngʼʉntɨra ndɨrɨ vatʉmami vaanɨ va kɨɨntʉ kɨlʉme na va kɨɨntʉ kiki Mʉtɨma waanɨ, novo lʉʉsa veende ʉláali na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Bweeyya neende viintʉ ˆvihwáalaryaa kurumwii na isháara ɨsɨ. Kʉva kʉrɨ na sakami, mooto na nkungúúla ya muuki. ");
INSERT INTO lag_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mwaasʉ valandʉka ʉrɨ ʉve kilwiirya, na mweeri kʉva ʉrɨ nkʉʉndʉ ja sakami. Ayo yoosi koonekana yarɨ, de ɨra sikʉ nkʉʉlʉ ya Ijʉva yʉʉje. ");
INSERT INTO lag_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na yoyoosi ˆarɨ loomba nyambirirya, fuma kwa Ijʉva lamuririwa arɨ.’ ");
INSERT INTO lag_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ee vaantʉ va Isiraéeli teeri masáare aya! Yéesu wa Nasaréeti ajáa oonekiwa kɨkomi kwaanyu nɨ Mʉlʉʉngʉ kwa myuujíisa, viintʉ ˆvihwáalaryaa, na isháara ˆjiísimiresimire kwaanyu. Mʉlʉʉngʉ abweeyya ayo yoosi mbere yaanyu ko tweera Yéesu ja ˆvyeene nyuunyu veeneevyo mwamányire. ");
INSERT INTO lag_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ʉhʉ Yéesu ajáa areetwa kwaanyu, kwa ˆvyeene Mʉlʉʉngʉ ajáa avɨɨka mʉryʉʉngʉ waachwe na kwa kʉtaanga kwaachwe keende aho kalɨ. Nyuunyu mʉkamʉʉlaa mʉsaláabii kwa mɨkono ya vaantʉ vavɨ sɨ ˆvarɨ Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Maa kaa, Mʉlʉʉngʉ akamʉchʉngʉrɨra fuma makatii ya inkwya, sa inkwya sɨ yadaha kʉmʉnamatɨra Yéesu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mʉtemi Daúdi alʉʉsa ivi kʉrɨ Yéesu, ‘Namoona Ijʉva mbere yaanɨ kwa sikʉ ˆjisiina ʉhero, na sa viintʉ ˆarɨ ivarwii raanɨ ra kʉlʉme, sɨ ndɨrɨ singisiwa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sa jeyyo, mʉtɨma waanɨ watɨɨte cheerʉ, na lurimi lwaanɨ loovaa lusiriri na cheerʉ, na mʉvɨrɨ waanɨ kiikala ʉrɨ ko kiilaangya. ");
INSERT INTO lag_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sa sɨ ʉrɨ kʉʉreka mʉtɨma waanɨ Ntarii tʉkʉ, baa mʉvɨrɨ wa Mʉʉja waako, sɨ ʉrɨ kʉʉreka woole tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wʉʉndaɨra njɨra jo kʉʉmbweeyya nɨve mooyo, kʉva ndɨrɨ na cheerʉ mʉnʉmʉʉnʉ sa weewe ʉmwaarɨ na nɨɨnɨ.’ ");
INSERT INTO lag_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Vanaviitʉ nɨ kʉvawyɨɨra niise baa kʉvavisa tʉkʉ, Daúdi baaba wiitʉ aakwya, akataahwa, na mbɨrɨ́ɨ́ra yaachwe ɨmwaarɨ baa isikʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Haaha tatáangire Daúdi nɨ mʉláali na mʉtwe ajáa. Yeeye ajáa ataanga Mʉlʉʉngʉ ajáa amwiilaha, mʉpaarya arɨ mʉvyaalwa wa ichina ra lʉkolo lwaachwe ʉtemi. ");
INSERT INTO lag_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daúdi ajáa oona ˆyarɨ fʉmɨra, noo ˆchooreka akalʉʉsa kʉfʉfʉka kwa Masía. Mʉlʉʉngʉ sɨ amʉreka Yéesu Ntarii tʉkʉ na baa sɨ aruma mʉvɨrɨ waachwe woole tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mʉlʉʉngʉ amʉfʉfʉla Yéesu Kirisitʉ na suusu voosi tʉrɨ vara ˆvoona masáare aya. ");
INSERT INTO lag_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ʉhʉ Yéesu, Mʉlʉʉngʉ amwiinʉla, akamʉvɨɨka ivarwii raachwe ra kʉlʉme, na akahokera Mʉtɨma Mʉʉja kufuma kwa Taáta. Ʉhʉ Mʉtɨma Mʉʉja, Taáta iichuunga kʉtʉretera arɨ, yeeye atʉkʉ́ngʼʉntɨɨre na noo aya ˆmeene mooyoona no yateera. ");
INSERT INTO lag_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daúdi mweeneevyo sɨ aambʉka na kurumwii tʉkʉ, maa kaa, yeeye alʉʉsa, ‘Ijʉva amuwyɨɨra Mweenevyoosi waanɨ, “Ikala mʉkono waanɨ wa kʉlʉme, ");
INSERT INTO lag_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","fʉʉrʉ nɨvavɨɨke vavɨ vaako, vave kabambari ko vɨkɨra majeo yaako.”’ ");
INSERT INTO lag_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sa jeyyo, vaantʉ voosi va Isiraéeli moosaakwa mʉtaange kɨkomi, Yéesu ˆmumuningʼinʼya mʉsaláabii fʉʉrʉ akakwya, Mʉlʉʉngʉ amʉvɨɨka ave Mweenevyoosi na Masía.” ");
INSERT INTO lag_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Vara Vayahúudi ˆvakateere ayo masáare, vakaavwa nɨ mɨtɨma. Aho, vakamuurya Peéteri na vara vatumwi vɨɨngɨ voosea, “Vanaviitʉ, joolɨ tʉrɨ bweeyya haaha?” ");
INSERT INTO lag_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peéteri akavasea, “Valanduki fuma uvii waanyu, na kɨra mʉʉntʉ abatisiwe kwa irina ra Yéesu Kirisitʉ, sa Mʉlʉʉngʉ asee ʉvɨ waanyu wasírire. Aho, hokera mʉrɨ kɨlʉngʉlʉngʉ cha Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sa kwiichuunga reterwa tʉrɨ Mʉtɨma Mʉʉja, nɨ sa nyuunyu na vaana vaanyu, na vaantʉ voosi ˆvarɨ kʉlɨ na kɨra mʉʉntʉ ˆarɨ kaanɨrɨrwa nɨ Ijʉva Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peéteri akatuuba voonekya kwa masáare yɨɨngɨ ˆyarɨ foo na akavalʉma kutu yoosea, “Mʉloombi Mʉlʉʉngʉ avalamurirye fuma mbyaala ɨhɨ ˆyareka njɨra.” ");
INSERT INTO lag_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Vaantʉ ˆvarɨ foo vakayaruma yara masáare, vakabatisiwa na vakasaangɨra na vaantʉ ˆvamuruma Yéesu. Vaantʉ avo nɨ ja mayana yatatʉ (3,000) jei vajáa. ");
INSERT INTO lag_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Vaantʉ ava ˆvamuruma Yéesu vakatuuba teerera ukiindya wa vatumwi va Yéesu, vakava kɨɨntʉ kɨmwɨ kɨmʉtɨma na kʉbendʉlabendʉla mʉkáate ja nkʉmbʉkɨra ya inkwya yaachwe no mʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Vatumwi va Yéesu vabweeyyáa viintʉ ˆvihwáalaryaa ˆvyamema maatʉkʉ vii na isháara. Sa jeyyo, vaantʉ va Yerusaléemu vajáa vakwaatwa nɨ woowa na vamʉnyemyáa Mʉlʉʉngʉ maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vaantʉ voosi ˆvajáa vamuruma Yéesu vajáa vaava kɨɨntʉ kɨmwɨ, na viiheeráa voosi viintʉ vyoosi ˆvajáa novyo. ");
INSERT INTO lag_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Vaantʉ vaváa iyoombe viintʉ vyaavo na mpía ˆngʼeene vapatáa, vajigaváa kwa kɨra mʉʉntʉ ˆvyeene asaakáa. ");
INSERT INTO lag_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kɨra siikʉ valʉmanáa waámii wa Kaaya Njija ya Ijʉva. Kei, valʉmanáa nyuumbii jaavo kʉbendʉla mʉkáate no rya chákurya chaavo hamwɨ kʉnʉ varɨ na mɨtɨma myeerʉ na varɨ na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Vamʉbweeyyiryáa Mʉlʉʉngʉ nkongojima na vajáa veendwa nɨ vaantʉ voosi. Na kɨra siikʉ Yéesu Mweenevyoosi oongereryáa vaantʉ vɨɨngɨ ko valamurirya, vakava hamwɨ na viivaavo vara ˆvamuruma. ");
INSERT INTO lag_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sikʉ ɨmwɨ mpɨɨndɨ ja cháámuusi, Peéteri na Yooháani vajáa vatamanya na Kaayii Njija ya Ijʉva. Mpɨɨndɨ ijo, noo vaantʉ vatamanyiryáa noo mʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ʉko Kaayii Njija, kʉjáa kwatɨɨte vaantʉ ˆvajáa vamʉvérekire mʉʉntʉ ʉmwɨ kɨvete keende kʉvyaalwa kwaachwe. Avo vaantʉ vamʉvɨɨkáa ʉwo kɨvete mʉryaangwii wa waama ya Kaaya Njija ˆʉséwaa Mʉryaango ˆWabooha, sa andooloomba chochoosi fuma kwa vara vaantʉ ˆvɨɨngɨráa na Kaayii Njija. ");
INSERT INTO lag_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ʉwo mʉʉntʉ ˆakavoone Peéteri na Yooháani vookɨɨngɨra na Kaayii Njija, akavaloomba vamʉheere mpía. ");
INSERT INTO lag_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peéteri na Yooháani vakamutuurirya miiso, maa Peéteri akamʉsea, “Tʉlaange!” ");
INSERT INTO lag_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ʉra kɨvete akavalaanga kʉnʉ yookiilaangya heewa arɨ kɨɨntʉ chochoosi. ");
INSERT INTO lag_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aho, Peéteri akamʉsea, “Nɨɨnɨ nsiina mpía baa na saháabu tʉkʉ, maa kaa, kɨra ˆndɨrɨ nocho kʉheera ndɨrɨ. Kwa irina ra YéesuKirisitʉ wa Nasaréeti, inʉka, na waande yeenda!” ");
INSERT INTO lag_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hara, Peéteri akamʉkwaata mʉkono wa kʉlʉme, akamwiinʉla. Hahara, majeo na mpʉ́ʉ́nchɨ jaachwe jikapata ngururu. ");
INSERT INTO lag_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akafɨrɨra, akɨɨma, maa akaanda yeenda. Akɨɨngɨra hamwɨ novo na waámii ya Kaaya Njija, yooyeenda no fɨrɨrafɨrɨra kʉnʉ yoomʉdʉʉmba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Vaantʉ voosi ˆvajáa aho, vakamoona yooyeenda kʉnʉ yoomʉdʉʉmba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Vaantʉ ˆvakataange ʉhʉ noo ʉra mʉʉntʉ ˆaloombaloombáa heehi na Mʉryaango ˆWabooha wa Kaaya Njija, vakahwaalala mʉnʉmʉʉnʉ koona masáare ˆyamʉpátire. ");
INSERT INTO lag_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kʉnʉ vahwáalɨɨre, vaantʉ voosi vakakʉʉrɨka na kʉʉntʉ ˆkʉséwaa Waama wa Solomóoni, kʉʉntʉ ʉwo mʉʉntʉ ˆajáa avʉʉ́mɨrɨɨre vala Peéteri na Yooháani. ");
INSERT INTO lag_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peéteri ˆakavoone avo vaantʉ, maa akavasea, “Ee Viisiraéeli, sa che aya masáare yoovahwaalarya? Sa che mootutuurirya miiso? Nɨ kiisea mwiise tamʉhóriirye ʉhʉ mʉʉntʉ kwa ngururu jiiswi, au nɨ sa mwiikalo wiiswi ˆutúubaa kɨra Mʉlʉʉngʉ ˆasáakaa wʉʉ? ");
INSERT INTO lag_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mʉlʉʉngʉ wa Aburaháamu, Isaka na Yaakúupu, Mʉlʉʉngʉ wa vala baaba wiitʉ amʉbwéeyyiriirye nkongojima Mʉtʉmami waachwe Yéesu. Ʉhʉ noo ʉra ˆmʉmʉtwaala na balásii kwa vakʉ́ʉ́lʉ sa ʉʉlawe, na mʉkamʉheera moongo mpɨɨndɨ Piláato ˆasaakáa amʉchʉngʉrɨre. ");
INSERT INTO lag_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mʉmʉheera moongo Yéesu, Mʉʉja na Mʉwoloki. Na nyuunyu mwamʉloomba Piláato amʉrekere mʉʉlai kɨpaango chaachwe. ");
INSERT INTO lag_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jeyyo, mwamʉʉlaa yeeye ˆarɨ ncholo ya nkaasʉ! Maa kaa, Mʉlʉʉngʉ amʉfʉfʉla! Na suusu voosi tʉrɨ vara ˆvoona ayo! ");
INSERT INTO lag_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Irina ra Yéesu na kuriruma irina ɨro, noo ˆvimʉhɨ́ɨre ngururu ʉhʉ mʉʉntʉ ˆmoomoona. Ja viintʉ voosi ˆmoomoona, ahórire sa kuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Vanaviitʉ, mʉmányire nyuunyu na vakʉ́ʉ́lʉ vaanyu mwatʉmama aya sa sɨ mʉjáa mʉmányire tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ayo yatʉmamwa sa Mʉlʉʉngʉ akiimikirirye masáare yara ˆalʉʉsa kʉtweera kwa valáali na mʉtwe vaachwe voosi, Masía waachwe turikiriwa arɨ. ");
INSERT INTO lag_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sa jeyyo, mʉvalandukiri Mʉlʉʉngʉ sa yeeye aseyye ʉvɨ waanyu, yeeye aveerye mɨtɨma kwa kʉra kʉva amwaarɨ na nyuunyu, ");
INSERT INTO lag_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","na avatʉmɨre Masía, yeeye nɨ Kirisitʉ ˆavasaawʉla keende aho kalɨ. ");
INSERT INTO lag_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yéesu yasaakwa achaale ʉko kurumwii, mpaka jifike mpɨɨndɨ Mʉlʉʉngʉ ˆarɨ bweeyya kɨra kɨɨntʉ kɨve kifya, ja ˆvyeene alʉʉsa keende aho kalɨ kwa njɨra ya valáali na mʉtwe vaachwe. ");
INSERT INTO lag_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mʉláali na mʉtwe Mʉ́sa alʉʉsa, ‘Kʉrɨ nyuunyu, Ijʉva Mʉlʉʉngʉ vasaawʉrɨra arɨ mʉláali na mʉtwe ˆmweene arɨ kiifwaana na nɨɨnɨ. Masáare yoosi mʉláali na mʉtwe waachwe ˆarɨ vawyɨɨra, mʉyateerere neeja. ");
INSERT INTO lag_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mʉʉntʉ yoyoosi sɨ ˆarɨ mʉteerera ʉwo mʉláali na mʉtwe, Mʉlʉʉngʉ mʉseyya arɨ kwa sikʉ ˆjisiina ʉhero fuma kwa vaantʉ vaachwe.’ ");
INSERT INTO lag_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Masáare ya sikʉ iji, yalʉʉswa nɨ valáali na mʉtwe voosi, kwaandɨra mpɨɨndɨ ja Samwéeli na voosi ˆvamʉtʉʉbɨrɨra vayalʉʉsa na vayavariyʉla. ");
INSERT INTO lag_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Masáare yara Mʉlʉʉngʉ ˆalʉʉsa ko tweera kwa valáali na mʉtwe vaachwe, nyuunyu noo mooyahokera. Kei, mʉháko ʉra ˆmweene abweeyya na vala baaba waanyu nyuunyu noo mookʉʉhokera. Mʉlʉʉngʉ avɨɨka mʉháko na baaba waanyu Aburaháamu kʉnʉ yoosea, ‘Kwa njɨra ya vaana vaako, luu vatalarya neende vaantʉ voosi va weerʉ.’ ");
INSERT INTO lag_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Haaha Mʉlʉʉngʉ amʉfʉfʉla Mʉtʉmami waachwe sa nyuunyu mʉpate kʉnáálo va ncholo, mʉtalariwe fuma uvii waanyu.” ");
INSERT INTO lag_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Viintʉ Peéteri na Yooháani ˆvajáa vakaarɨ voolʉʉsɨka na vara vaantʉ, maa veeneɨsɨ va Ijʉva, Masadukáayo na mʉkʉ́ʉ́lʉ wa valʉkalʉka va Kaayii Njija ya Ijʉva vakafika. ");
INSERT INTO lag_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Avo vajáa vakálɨɨre maatʉkʉ vii sa avo vatumwi va Yéesu vakiindyáa na vavariyʉláa Yéesu afʉfʉka, isáare ɨrɨ roónekyaa kɨweerwii, vaantʉ ˆvaakwya fʉfʉka varɨ. ");
INSERT INTO lag_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aho, vakavakwaata, na sa viintʉ uchikʉ ʉjáa wɨɨ́ngɨɨre, vakavavɨɨka mʉnyololwii fʉʉrʉ lomʉtóondo yaachwe. ");
INSERT INTO lag_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Maa kaa, vaantʉ ˆvarɨ foo va vara ˆvateereráa isáare, vakamuruma Mʉlʉʉngʉ. Na ˆvamuruma Yéesu vakafika vaantʉ valʉme mayana yasaano (5,000). ");
INSERT INTO lag_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ˆKʉkeere, vakʉ́ʉ́lʉ va vaantʉ, vawosi na vakiindya va Miiro vakalʉmana ʉko Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aho kiikalwii, ajáa amwaarɨ Anáasi mweeneɨsɨ mʉkʉʉlʉ, Kayáafa, Yooháani, Alekɨsáanda na vaantʉ vɨɨngɨ va lʉkolo lwa mʉkʉ́ʉ́lʉ wa veeneɨsɨ va Ijʉva. ");
INSERT INTO lag_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Vakaviimya vala Peéteri na Yooháani, vakavuurya voosea, “Kɨvete ˆmʉmʉhoriiryé nɨ kwa ngururu na kwa irina ra ani?” ");
INSERT INTO lag_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aho, Peéteri kʉnʉ amémire Mʉtɨma Mʉʉja, akavasea, “Arumi, nyuunyu vakʉ́ʉ́lʉ va vaantʉ na vawosi! ");
INSERT INTO lag_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Koonɨ isikʉ mootuchukuruma sa ɨrɨ isáare ˆreene abweeyyiriiwé ʉhʉ kɨvete na ˆvyeene ahoriiwé, ");
INSERT INTO lag_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nyuunyu na vaantʉ voosi va Isiraéeli moosaakwa mʉtaange, mʉʉntʉ ʉhʉ ˆmweene iímire mbere yaanyu ahórire na avɨ́ɨre nkaasʉ, kwa ngururu ya irina ra Yéesu Kirisitʉ wa Nasaréeti. Ʉhʉ Yéesu nyuunyu mwamuningʼinʼya mʉsaláabii fʉʉrʉ akakwya, maa kaa, Mʉlʉʉngʉ akamʉfʉfʉla fuma inkwyii. ");
INSERT INTO lag_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nɨ ʉhʉ Yéesu noo ˆalʉʉswa jei, Iwye ˆrasiitwa nɨ nyuunyu vajeengi, ravɨ́ɨre iwye ikʉʉlʉ ra kichurii. ");
INSERT INTO lag_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kusiina mʉʉntʉ wɨɨngɨ yoyoosi ˆarɨ daha kʉtʉlamurirya tʉkʉ, sa kusiina irina rɨɨngɨ vaantʉ ˆvaheewa aha weerwii ˆreene rɨrɨ daha kʉtʉlamurirya fuma uvii tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Vara vakʉ́ʉ́lʉ ˆvakoone ˆvyeene vala Peéteri na Yooháani vajáa viitema, vakahwaalala maatʉkʉ vii sa vajáa vamányire sɨ vakiindiwa isáare ra Mʉlʉʉngʉ tʉkʉ. Vakataanga vala Peéteri na Yooháani nɨ hamwɨ vajáa na Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Maa kaa, ˆvakamoone ʉra mʉʉntʉ ˆajáa ahórire iímire hamwɨ na vala Peéteri ya Yooháani, sɨ vaava na isáare ro lʉʉsa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aho, vakavalairirya vafume hara Balásii Nkʉʉlʉ ya Vayahúudi, maa vakachaala vooveene, voolʉma sáare. ");
INSERT INTO lag_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Vakaanda kiiyurya, “Che tʉrɨ vabweeyya vaantʉ ava? Sɨ tʉrɨ daha siita ʉhʉ muujíisa mʉkʉʉlʉ ˆmweene vabwéeyyiirye tʉkʉ, sa nɨ kɨweerwii ʉrɨ kwa kɨra mʉʉntʉ wa aha Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sa jeyyo, tʉvakaanʼye ko vavuumba, vareke lʉʉsɨka na mʉʉntʉ yoyoosi kwa irina ra Yéesu, sa ɨrɨ irina rɨdɨɨre kweenera.” ");
INSERT INTO lag_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aho, vakavaanɨrɨra vala Peéteri na Yooháani kei, vakavakaanʼya vareke lʉʉsɨka ayo masáare mbere ja vaantʉ, baa karɨ vandookiindya vaantʉ kwa irina ra Yéesu vii kaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Maa kaa, vala Peéteri na Yooháani vakavasea, “Lamuli veeneevyo koonɨ nɨ ʉwoloki mbere ya Mʉlʉʉngʉ kʉvanyemya nyuunyu kʉlookya Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Suusu sɨ tʉrɨ reka kʉlʉʉsa masáare ˆtoona no teera tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Maa re, Balása Nkʉʉlʉ ya Vayahúudi ɨkavakaanʼya na nkalari, maa ɨkavareka. Vasiindwa kʉvaheera irya sa vaantʉ voosi vamʉbweeyyiryáa nkongojima Mʉlʉʉngʉ maatʉkʉ vii sa ɨro isáare ˆrɨjáa rafʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ʉwo mʉʉntʉ ˆahoriwa kwa muujíisa nɨ kɨvete ajáa keende ˆavyaalwa, na ajáa atɨɨte myaaka makumi yanɨ (40) na kɨɨntʉ. ");
INSERT INTO lag_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Vala Peéteri na Yooháani ˆvakarekerwe, vakahɨndʉka na kwa viivaavo, vakavawyɨɨra yara yoosi ˆvajáa vawyɨ́ɨrɨɨrwe nɨ vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vawosi. ");
INSERT INTO lag_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Novo ˆvakateere jeyyo, voosi hamwɨ vakamʉloomba Mʉlʉʉngʉ voosea, “Weewe Ijʉva Mweeneevyo weemweene, ʉrɨ mʉkʉ́ʉ́lʉ wa kɨra kɨɨntʉ. Weewe noo wʉʉmba kurumu na weerʉ, mayɨya na viintʉ vyoosi ˆviri mʉʉmo. ");
INSERT INTO lag_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Weewe ʉmʉbweeyya baaba wiitʉ Daúdi mʉtʉmami waako alʉʉse jei kwa njɨra ya Mʉtɨma Mʉʉja, ‘Sa che vaantʉ va weerʉ vakálɨɨre? Na sa che nkolo ja vaantʉ joobweeyya mɨryʉʉngʉ ya kɨhoho? ");
INSERT INTO lag_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Vatemi va ɨhɨ weerʉ viímire neeja kʉlwa nkoondo, kei vakʉ́ʉ́lʉ va Viisiraéeli viijíingire hamwɨ, sa vamusiite Ijʉva wiitʉ na Masía waachwe.’ ");
INSERT INTO lag_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Masáare aya yafʉ́mɨɨre aha múujii, Heróode Antípaasi na Poontío Piláato valʉ́mɨɨne na vaantʉ sɨ ˆvarɨ Vayahúudi na Viisiraéeli sa vamʉkɨɨkane Yéesu Mʉtʉmami waako mʉʉja ˆwamʉhaka makuta. ");
INSERT INTO lag_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ayo masáare vabwéeyyiirye noo ˆʉjáa ʉlamʉla keende aho kalɨ yatʉmamwe, kwa ngururu jaako na kweenda kwaako. ");
INSERT INTO lag_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Haaha ee Ijʉva, laanga ˆvyeene vootuvuumba! Ʉtʉheere ngururu suusu vatʉmami vaako tweenerye isáare raako ko kiitema. ");
INSERT INTO lag_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Onekya ngururu jaako jo horya valwɨ́ɨrɨ. Kei ʉtwaambirirye tʉndoobweeyya isháara na viintʉ ˆvihwáalaryaa kwa irina ra Yéesu Mʉtʉmami waako mʉʉja.” ");
INSERT INTO lag_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ˆVakahʉmʉle kʉloomba, aho haantʉ ˆvajáa viijíingire, hakasɨngɨsɨka. Mʉtɨma Mʉʉja akavalongoola voosi vakaanda kweenerya isáare ra Mʉlʉʉngʉ kʉnʉ viitémire. ");
INSERT INTO lag_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Vaantʉ voosi ˆveene vajáa vamuruma Yéesu vajáa vaava mʉtɨma ʉmwɨ, na mɨryʉʉngʉ yaavo ɨjáa yaava hamwɨ. Kusiina mʉʉntʉ ˆaséaa viintʉ ˆarɨ novyo nɨ vyaachwe yeemweene tʉkʉ, viintʉ vyaavo vyoosi vijáa vyasaangiwa hamwɨ. ");
INSERT INTO lag_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Vatumwi va Yéesu vavawyɨɨráa vaantʉ ko kiitema, kɨmáárɨ cha kʉfʉfʉka kwa Yéesu Mweenevyoosi. Na nduwo ya Mʉlʉʉngʉ ˆɨrɨ foo nɨ mweeri ya voosi ɨjáa. ");
INSERT INTO lag_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kusiina ʉmwɨ waavo sɨ ˆeenereryáa kɨɨntʉ tʉkʉ, sa vara ˆveene vajáa na mawʉnda baa na nyuumba, vaváa iyoombe. ");
INSERT INTO lag_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Mpía ˆngʼeene vapatáa, vavaheeráa vatumwi va Yéesu, novo vajigaváa kwa vaantʉ ˆvamuruma Yéesu ja ˆvyeene kɨra mʉʉntʉ asaakáa. ");
INSERT INTO lag_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kʉjáa kwatɨɨte Mʉláawi ʉmwɨ fuma ɨsɨ ya Kúpuro. Irina raachwe noo Yooséefu asewáa. Ʉhʉ, vatumwi va Yéesu vajáa vamʉkemera irina ra Barinába, noo kʉsea, “Mwaana ˆahéeraa mʉtɨma.” ");
INSERT INTO lag_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ʉhʉ ne ajáa avaa iyoombe iwʉnda raachwe. Na mpía ˆngʼeene ajáa apata, akajitwaala kwa vatumwi va Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆasewáa Ananía na muki waachwe ˆasewáa Safíira. Ava novo vajáa vavaa iyoombe iwʉnda raavo. ");
INSERT INTO lag_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na mpía ˆngʼeene vajáa vapátire, Ananía akakeehya, na jira ˆngʼeene jijáa jachɨ́hɨɨre akajitwaala na kwa vatumwi va Yéesu. Ɨkɨ kɨɨntʉ vajáa valʉʉsɨkanʼya na mʉdala waachwe. ");
INSERT INTO lag_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ʉko, Peéteri akamʉsea, “Ananía, sa che Irimʉ rɨɨ́ngɨɨre mutimii waako na woomʉlongowera Mʉtɨma Mʉʉja ko lʉʉsa ʉréetire mpía joosi ˆngʼeene ʉpátire ko vaa iyoombe rɨra iwʉnda raako? ");
INSERT INTO lag_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","De ʉrɨ vae iyoombe, ɨrɨ iwʉnda nɨ raako raarɨ. Baa ˆʉkarɨvae iyoombe, mpía ˆngʼeene ʉpátire vyaarɨ ujibweeyyirye viintʉ vyaako ja ˆvyeene woosaaka weewe mweeneevyo. Ha de haaha nɨ sa che ʉtʉ́mamire isáare ja ɨrɨ mutimii waako? Weewe sɨ ʉtʉlóngowɨɨre suusu vii tʉkʉ, maa kaa, ʉmʉlóngowɨɨre Mʉlʉʉngʉ!” ");
INSERT INTO lag_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananía ˆakateere vii ayo masáare, akawya, maa akakwya. Vaantʉ voosi ˆvateera ayo ˆyajáa yafʉ́mɨɨre, maa vakakwaatwa nɨ woowa. ");
INSERT INTO lag_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Aho, vakʉʉja vatavana, vakʉʉfarɨmbɨrɨra mʉvɨrɨ waachwe na sáanda, vakamufumya na weerwii, maa vakɨɨta noo mʉtaaha. ");
INSERT INTO lag_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Masaa yatatʉ ˆyakalooke, muki waachwe akɨɨngɨra. Yeeye sɨ ajáa anataanga yara ˆyajáa yafʉ́mɨɨre tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aho, Peéteri akamuurya, “Hoonɨ ngwyɨɨra, iji noo mpía joosi ˆmʉpátire ko vaa iyoombe iwʉnda wʉʉ?” Maa akasea, “Hɨɨ, noo iji.” ");
INSERT INTO lag_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Aho, maa Peéteri akamʉsea, “Sa che mwiirʉ́mɨɨre kʉmʉyera Mʉtɨma wa Ijʉva? Teera! Vara vatavana ˆvadómire noo mʉtaaha mʉlʉme waako, naava aha mʉryaangwii, baa weewe kʉkʉtwaala viise noo kʉtaaha!” ");
INSERT INTO lag_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hahara Safíira akawya majewii ya Peéteri, maa akakwya. Vara vatavana vakɨɨngɨra, vakashaana akwíire, vakamʉtwaala na weerwii maa vakɨɨta noo mʉtaaha heehi na mʉlʉme waachwe. ");
INSERT INTO lag_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mpuka ya vaantʉ ˆvamuruma Yéesu, na vaantʉ voosi ˆvajáa vateera, vakɨɨngɨrwa nɨ woowa mʉkʉʉlʉ, sa ayo ˆyajáa yafʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kwa lʉvɨro lwa Mʉlʉʉngʉ, vatumwi va Yéesu vabweeyyáa isháara na viintʉ ˆvyamema maatʉkʉ vii ˆvihwáalaryaa kwa vaantʉ. Na vaantʉ vara ˆvajáa varuma, valʉmanáa voosi haantʉ ˆkʉséwaa Waama wa Solomóoni. ");
INSERT INTO lag_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kusiina mʉʉntʉ yoyoosi sɨ ˆajáa amuruma Yéesu ˆiisaangiriryáa novo tʉkʉ. Baa neembe nɨ jeyyo, vaantʉ vara sɨ ˆvajáa vamuruma Yéesu vavadʉʉmbáa no vanyemya mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Vaantʉ ˆvamuruma Yéesu Mweenevyoosi vakakɨɨngɨka mʉnʉmʉʉnʉ, vaantʉ valʉme na vaantʉ vaki, vakatuuba kɨɨngɨka. ");
INSERT INTO lag_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sa jeyyo, vaantʉ vavavɨɨkáa valwɨ́ɨrɨ ndirii na virágwii njirii, sa Peéteri ˆarɨ looka, baa murimírimi waachwe ʉvatweerere novo vahole. ");
INSERT INTO lag_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Vaantʉ ˆvarɨ foo vʉʉjáa fuma míiji ˆɨrɨ mbarɨmbarɨ ya Yerusaléemu, na vavareetáa valwɨ́ɨrɨ vaavo na vara ˆvajáa na mirimʉ mɨvɨ, na avo voosi vahoriwáa. ");
INSERT INTO lag_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Haaha, mweeneɨsɨ mʉkʉʉlʉ, na viivaachwe ˆvajáa va mpuka ya Masadukáayo, vakaanda voonera kɨvɨna vatumwi. ");
INSERT INTO lag_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Sa jeyyo, vakavakwaata vatumwi, maa vakavatwaala na mʉnyololwii. ");
INSERT INTO lag_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Maa kaa, kati na kati ya uchikʉ murimʉ mʉʉja wa Ijʉva ʉkʉʉja. Ʉkachʉngʉla mɨryaango ya aho mʉnyololwii, ʉkavafumya na weerwii, maa ʉkavasea, ");
INSERT INTO lag_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Tamanyi na waámii ya Kaaya Njija ya Ijʉva mʉkavawyɨɨre vaantʉ masáare yoosi ya ɨhɨ nkaasʉ ifya.” ");
INSERT INTO lag_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Vatumwi vakakwaatya isáare ɨro, vakatamanya namʉtóondo dwɨɨ na waámii ya Kaaya Njija, maa vakaanda vavariyʉrɨra vaantʉ Masáare Maaja. Mweeneɨsɨ mʉkʉʉlʉ na vara ˆvajáa ne ˆvakafike, vakaanɨrɨra Balása Nkʉʉlʉ ya Vayahúudi, noo kʉsea, itaka ra valʉme voosi va Isiraéeli. Vakavatʉma vaantʉ vavafumye vatumwi fuma mʉnyololwii. ");
INSERT INTO lag_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Maa kaa, valʉkalʉka va Kaayii Njija ˆvakafike aho mʉnyololwii, sɨ vavashaana vatumwi tʉkʉ. Sa jeyyo, vakahɨndʉla mʉlomo voosea, ");
INSERT INTO lag_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tashɨ́hɨɨne mɨryaango ya mʉnyololwii yachuungwa vivira, na valʉkalʉka va mʉnyololwii viímire mɨryaangwii, maa kaa, ˆtʉkayʉʉle mɨryaango sɨ tashɨ́hɨɨne mʉʉntʉ yoyoosi nyuumbii tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aho, mʉkʉ́ʉ́lʉ wa valʉkalʉka va Kaayii Njija na vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva ˆvakateere ayo masáare, vakoololokera na vakahwaalala mʉnʉmʉʉnʉ kʉnʉ vookiiyurya nɨ kɨɨntʉ che chafʉ́mɨɨre. ");
INSERT INTO lag_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Aho, akʉʉja mʉʉntʉ ʉmwɨ, akavasea, “Vara vaantʉ ˆmʉvachuungiré mʉnyololwii, vamwaarɨ waámii ya Kaaya Njija voovakiindya vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Aho, mʉkʉ́ʉ́lʉ wa valʉkalʉka va Kaayii Njija na valʉkalʉka vaachwe vakadoma na Kaayii Njija, maa vakɨtoovareeta vatumwi. Maa kaa, sɨ vavakwaata na ngururu tʉkʉ, sa voofáa kʉvawa na mawye nɨ vaantʉ. ");
INSERT INTO lag_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ˆVakavareete, maa vakaviimya mbere ya Balása Nkʉʉlʉ ya Vayahúudi. Aho, mweeneɨsɨ mʉkʉʉlʉ akavasea, ");
INSERT INTO lag_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Eri, sɨ tavakaaniiryé na ngururu mʉreke kukiindya vaantʉ kwa irina ra Yéesu tʉkʉ wʉʉ? Haaha sa che moodoomererya kweenerya ʉvariyuli waanyu Yerusaléemu yoosi na moosaaka kʉtʉverekya irya ra inkwya ya ʉhʉ mʉʉntʉ?” ");
INSERT INTO lag_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Aho, Peéteri na vatumwi viivaachwe vakasea, “Suusu nɨ Mʉlʉʉngʉ tʉrɨ mutuuba kʉlookya kʉteera vaantʉ! ");
INSERT INTO lag_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mʉlʉʉngʉ wa vala baaba wiitʉ amʉfʉfʉla Yéesu, ʉra nyuunyu ˆmwamʉʉlaa ko muningʼinʼya mʉsaláabii. ");
INSERT INTO lag_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Maa Mʉlʉʉngʉ akamʉbweeyyirya nkongojima ko mʉvɨɨka mʉkono waachwe wa kʉlʉme, ave Mʉkʉ́ʉ́lʉ na Mʉlamuriri sa Mʉlʉʉngʉ atʉbweeyye suusu Viisiraéeli tʉdahe kʉvalandʉka fuma uvii wiitʉ na asee ʉvɨ wiitʉ wasírire. ");
INSERT INTO lag_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Suusu tʉrɨ vara ˆvoona aya masáare hamwɨ na Mʉtɨma Mʉʉja Mʉlʉʉngʉ ˆavaheera vara ˆvamʉtéeraa matu.” ");
INSERT INTO lag_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Avo vakʉ́ʉ́lʉ ˆvakateere ayo, vakakalala maatʉkʉ vii, vakasaaka kʉvʉʉlaa vatumwi va Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Maa kaa, ʉmwɨ wa valʉme ajáa atɨɨte miiririkano ˆyiísimire. Ʉwo nɨ Mʉfarisáayo ajáa na irina raachwe noo Gamaliéeli asewáa. Yeeye nɨ mukiindya wa kɨkomi wa Miiro ya Mʉlʉʉngʉ na anyemiwáa maatʉkʉ vii nɨ vaantʉ voosi. Akɨɨma mbere ya Balása Nkʉʉlʉ ya Vayahúudi, maa akalairirya vatumwi vafumiwe na weerwii kiduudi. ");
INSERT INTO lag_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aho, akavasea vara valʉme ˆvajáa vachɨ́hɨɨre hara Balásii, “Nyuunyu vaantʉ valʉme va Isiraéeli, laangi neeja ɨkɨ kɨɨntʉ ˆmoosaaka bweeyya kwa ava vaantʉ. ");
INSERT INTO lag_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sikʉ sɨ ˆjiri baa foo tʉkʉ, Teúuda, ajáa iibweeyya nɨ mʉʉntʉ wa kɨkomi na ajáa avalandʉka serekáali, baa kei ajáa aava na vapooji magana yanɨ (400). Maa kaa, ˆakʉʉlawe, vapooji vaachwe viipasa na mɨrɨmo yaavo ɨkarɨmɨra. ");
INSERT INTO lag_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sikʉ ˆjikaseese, mpɨɨndɨ vaantʉ ˆvavalwáa, Yʉ́ʉda Mʉgaliláaya ajáa afʉmɨra. Ʉhʉ ne ajáa apata vaantʉ iituubáa novo, baa yeeye ajáa avalandʉka serekáali, ne ˆakʉʉlawe vaantʉ voosi vara ˆvamutuubáa viipasa. ");
INSERT INTO lag_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Haaha nɨ kʉvawyɨɨra niise. Karɨ mʉvabweeyye kɨɨntʉ chochoosi ava vaantʉ tʉkʉ! Vareki! Koonɨ vookiibweeyyirya masáare yaavo vii, ʉhʉ mʉrɨmo waavo sɨ ʉrɨ chaala tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Maa kaa, koonɨ woofuma kwa Mʉlʉʉngʉ sɨ mʉrɨ daha kʉvakɨtɨra tʉkʉ, sa kʉva mʉrɨ moomʉkɨɨkana Mʉlʉʉngʉ.” Maa re, vakaruma masáare ya Gamaliéeli. ");
INSERT INTO lag_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sa jeyyo, vakavaanɨrɨra vatumwi, maa vakavataandɨkataandɨɨka. Aho, maa vakasea, karɨ luu valʉʉse kei irina ra Yéesu tʉkʉ. Vakavarekera vadome na meevo. ");
INSERT INTO lag_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Vatumwi vakafuma Balásii Nkʉʉlʉ ya Vayahúudi varɨ na cheerʉ, sa viintʉ Mʉlʉʉngʉ ˆajáa avavárire vɨɨma neeja kʉchwɨɨwa matɨ sa irina ra Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Vakatuuba variyʉla Masáare Maaja kɨra siikʉ waámii ya Kaaya Njija na nyuumbii ja vaantʉ, Yéesu nɨ Masía. ");
INSERT INTO lag_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sikʉ ˆjikaseese, vaantʉ ˆvamuruma Yéesu vakɨɨngɨkáa mʉnʉmʉʉnʉ. Mangʼuulo ya Vayahúudi ˆvalʉʉsɨkáa Kɨgiríki na vara ˆvalʉʉsɨkáa Kɨeburanía yakaanda. Vara ˆvalʉʉsɨkáa Kɨgiríki, vangʼuuláa vandoosea, valala vaavo, sɨ vagavɨrwáa chóorya cha kɨra siikʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Sa jeyyo, vatumwi ikimi na vavɨrɨ vakaanɨrɨra itaka ra vaantʉ voosi ˆvamuruma Yéesu vakavasea, “Sɨ vyabooha suusu kʉreka mʉrɨmo wo variyʉla isáare ra Mʉlʉʉngʉ sa tʉndoovagavɨra valala chóorya tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Haaha vanaviitʉ, saawuli vaantʉ mufungatɨ fuma kʉrɨ nyuunyu. Ava vaantʉ vave ˆvalʉ́ʉswaa nɨ vaaja, vara ˆvalóngoolwaa nɨ Mʉtɨma Mʉʉja. Kei, vave varɨ na tooti. Ava, vavɨɨka tʉrɨ vandootʉmama mʉrɨmo wo gava vyóorya, ");
INSERT INTO lag_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","sa suusu tutuube mʉloomba Mʉlʉʉngʉ no variyʉla isáare raachwe.” ");
INSERT INTO lag_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Isáare ɨrɨ, rɨkaveerya mʉtɨma vaantʉ voosi. Hara, vakaanda saawʉla, vakamʉsaawʉla Sitefáani. Ʉhʉ nɨ mʉʉntʉ ˆamuruma Yéesu kɨkomi ajáa na alongoolwáa nɨ Mʉtɨma Mʉʉja. Kei, vakamʉsaawʉla Filíipi, Purokóoro, Nikanóori, Timóona, Pariméena na Nikoláao fuma múuji wa Antiókia ˆatuubáa díini ya Kɨyahúudi. ");
INSERT INTO lag_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aho, vakavavɨɨka avo ˆvasaawɨɨrwe mbere ya vatumwi va Yéesu, novo vakavaloombera ko vavɨkɨra mɨkono yaavo. ");
INSERT INTO lag_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Isáare ra Mʉlʉʉngʉ rɨkatuuba kweenera, na vaantʉ ˆvamuruma Yéesu vakatuuba kɨɨngɨka mʉnʉmʉʉnʉ ʉko Yerusaléemu. Mpuka nkʉʉlʉ ya veeneɨsɨ va Ijʉva ɨkamuruma. ");
INSERT INTO lag_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Haaha, Sitefáani ajáa aheewa nduwo nɨ Mʉlʉʉngʉ maatʉkʉ vii. Mʉlʉʉngʉ ajáa amʉheera ngururu nkʉʉlʉ jo bweeyya viintʉ ˆvihwáalaryaa na isháara nkʉʉlʉ kwa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Maa kaa, Vayahúudi vamwɨ vakasaaka kwiiruta ndihi ne. Ava vajáa vafúmire sinagóogii ˆɨséwaa Vatʉ́mwa ˆVarekerwa. Vamwɨ vaavo vajáa vafúmire múuji wa Kɨréene na Alekisándiria, na ɨsɨ ja Kilikía na Ásia. ");
INSERT INTO lag_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sitefáani akava yoolʉma sáare novo kwa tooti kwa lʉvɨro lwa Mʉtɨma, novo vakasiindwa kwiiruta ndihi ne. ");
INSERT INTO lag_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aho, vakavaheemba vaantʉ kimbiso, maa vakaanda sea, “Tamʉteera Sitefáani yoomʉhɨɨntɨkɨraMʉ́sa na Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ˆVakalʉʉse jeyyo, vakavatikʉla vaantʉ, vawosi na vakiindya va Miiro. Aho, vakamʉkwaata Sitefáani, maa vakamʉtwaala na mbere ya Balása Nkʉʉlʉ ya Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ʉko Balásii, vakamʉvɨɨkɨra mashahíidi va ʉloongo ˆvamʉlongowereryáa vandoosea, “Kɨmaarɨ ʉhʉ mʉʉntʉ sɨ arékaa lʉʉsa masáare yo kɨɨhɨɨntɨkɨra Kaaya Njija ya Ijʉva na Miiro vii kaa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tamʉteera yoosea atɨ ʉhʉ Yéesu wa Nasaréeti vaa arɨ ɨhɨ Kaaya Njija na valandʉla arɨ tʉʉva ˆngʼeene talaiririwa nɨ Mʉ́sa.” ");
INSERT INTO lag_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Vaantʉ voosi ˆvajáa Balásii ɨyo, vakamutuurirya miiso Sitefáani, vakoona kisho chaachwe choolavalava ja kisho cha murimʉ mʉʉja. ");
INSERT INTO lag_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Aho, maa mweeneɨsɨ mʉkʉʉlʉ akamuurya Sitefáani, “Eri, masáare ˆvookusitaakya nɨ ya kɨmáárɨ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefáani akamʉsea, “Vanaviitʉ na vala taáta wiitʉ, nteereri! Mʉlʉʉngʉ wa Nkongojima amʉfʉmɨra baaba wiitʉ Aburaháamu mpɨɨndɨ ˆajáa Mesopotámia, mpɨɨndɨ sɨ ˆanasaama na Haráani. ");
INSERT INTO lag_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na ajáa amʉsea, ‘Inʉka fuma ɨsɨ yaako, vareke vaantʉ va lʉkolo lwaako, doma na ɨsɨ ˆngʼeene ndɨrɨ koonekya!’ ");
INSERT INTO lag_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aburaháamu akasaama fuma ɨsɨ yaachwe ya Vakalidáayo, akɨɨta kiikala Haráani. Taáta waavo ˆakawulale, Mʉlʉʉngʉ akamʉsaamya, akamʉreeta akʉʉja joo kiikala ɨsɨ ˆngʼeene mookiikala haaha. ");
INSERT INTO lag_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Baa neembe nɨ jeyyo, Mʉlʉʉngʉ sɨ amʉheera ʉpaari wowoosi tʉkʉ, baa ijeo rɨmwɨ ra kadawo tʉkʉ. Maa kaa, Mʉlʉʉngʉ ajáa iichuunga kwaachwe kʉmʉheera arɨ ɨsɨ ɨhɨ ɨve yaachwe na vaana vaachwe, baa neembe mpɨɨndɨ ijo ajáa asiina mwaana. ");
INSERT INTO lag_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mʉlʉʉngʉ ajáa amʉsea, ‘Vaana vaako kʉva varɨ vayeni ɨsɨ ya vaantʉ vɨɨngɨ. Ʉko bweeyyiwa varɨ vatʉ́mwa na turikiriwa varɨ kwa myaaka magana yanɨ (400). ");
INSERT INTO lag_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Maa kaa, nɨɨnɨ vaheera ndɨrɨ irya vaantʉ va ɨsɨ ˆngʼeene ɨrɨ vabweeyya vatʉ́mwa. Aya ˆyarɨ looka, vafumya ndɨrɨ fuma ɨsɨ ɨyo sa jɨ vaanyinamɨre aha.’ ");
INSERT INTO lag_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ayo ˆyakalooke, Mʉlʉʉngʉ akamʉheera Aburaháamu mʉháko, wo twaala vaantʉ valʉme na kɨbawii. Jeyyo, Aburaháamu akamʉvyaala Isaka, akamʉtwaala na kɨbawii sikʉ ya naanɨ keende ˆavyaalwa. Isaka ne akamʉvyaala Yaakúupu, ne akavavyaala vala baaba wiitʉ ikimi na vavɨrɨ. ");
INSERT INTO lag_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ava vala baaba wiitʉ ikimi na ʉmwɨ vamooneráa kɨvɨna mwaanaavo Yooséefu, sa jeyyo, vakamʉvaa iyoombe ja mʉtʉ́mwa ʉko Mísiri. Maa kaa, Mʉlʉʉngʉ nɨ hamwɨ ajáa na Yooséefu. ");
INSERT INTO lag_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Yeeye akamʉlamuririrya fuma uturikirii waachwe woosi. Akamʉheera tooti na Faráao mʉtemi wa Mísiri akamweenda, akamʉvɨɨka ave mʉkʉ́ʉ́lʉ wa ɨsɨ ya Mísiri na wa nyuumba yaachwe yoosi ya kɨtemi. ");
INSERT INTO lag_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Sikʉ ˆjikaseese, ɨsɨ yoosi ya Mísiri na Kanáani ɨkava na njala ya imalo ˆngʼeene ɨjáa yareeta uturikiri mʉkʉʉlʉ. Chóorya kɨkavasɨrɨra vala baaba wiitʉ. ");
INSERT INTO lag_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yaakúupu ˆakateere Mísiri kwatɨɨte viryo, akavatʉma vaana vaachwe, noo kʉsea, vala baaba wiitʉ vadome. Ʉlo noo lʉjáa lwa ncholo voovo kʉtamanya na ʉko. ");
INSERT INTO lag_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ˆVakatamanye lwa kavɨrɨ, Yooséefu akiilʉʉsa kwa vaanaavo, novo vakataangɨkana kwa Faráao mʉtemi wa Mísiri mweeneevyo. ");
INSERT INTO lag_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yooséefu akatʉma mʉlomo kwa taáta waavo Yaakúupu, adome na Mísiri hamwɨ na nyuumba yaachwe yoosi, novo nɨ vaantʉ makumi mufungatɨ na vasaano (75) vajáa. ");
INSERT INTO lag_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aho, Yaakúupu akatamanya na Mísiri, akawularɨra kʉʉko, baa na vala baaba wiitʉ vakawularɨra kʉʉko. ");
INSERT INTO lag_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mɨvɨrɨ yaavo ɨkareetwa fʉʉrʉ Shekéemu, ɨkataahwa mbiríírii ˆngʼeene Aburaháamu ajáa awʉla na mpía fuma kwa vaana va Hamóori. ");
INSERT INTO lag_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Mpɨɨndɨ ˆjikasengerere ja kʉra kwiichuunga Mʉlʉʉngʉ ˆajáa iichuunga kwa Aburaháamu, mbyaala ya vala baaba wiitʉ ɨjáa yoongereriwa, vakava foo mʉnʉmʉʉnʉ ʉko Mísiri. ");
INSERT INTO lag_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Maa reerʉ, mʉtemi wɨɨngɨ akaanda temerera ɨsɨ ya Mísiri, ʉwo sɨ ajáa amányire kɨɨntʉ chochoosi cha Yooséefu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ʉwo mʉtemi akaanda kʉvaturikirya vala baaba wiitʉ, fʉʉrʉ akavadoomererya vandoofweita vasinga vaduudi sa vakwye. ");
INSERT INTO lag_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mpɨɨndɨ ɨyo, Mʉ́sa ajáa avyaalwa. Mʉ́sa nɨ musinga ˆabooha maatʉkʉ vii ajáa mbere ya Mʉlʉʉngʉ. Akarerwa kaayii kwa taáta waavo kwa myeeri ɨtatʉ. ");
INSERT INTO lag_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Maa kaa, ˆvakasiindwe kumuvisa, vakɨɨta koomʉfweita luujii na muhíínja wa Faráao akamʉshaana, maa akamʉsʉmʉla, akaanda mʉrera ja mwaana waachwe. ");
INSERT INTO lag_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mʉ́sa akakiindiwa masáare yoosi ya tooti ja Vamísiri, akava nkabaako kwa masáare na mɨrɨmo yaachwe. ");
INSERT INTO lag_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mʉ́sa ˆakafikye myaaka makumi yanɨ (40), akapata mpɨɨma yo koovalaanga Viisiraéeli viivaachwe. ");
INSERT INTO lag_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ʉko akamʉshaana Mwiisiraéeli ʉmwɨ yooturikiriwa vyavɨɨha nɨ Mʉmísiri, akadoma noo mʉlamurirya, akamʉʉlaa ʉwo Mʉmísiri. ");
INSERT INTO lag_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mʉ́sa ajáa iisea, Viisiraéeli viivaachwe taanga varɨ Mʉlʉʉngʉ valamurirya arɨ ko tweera yeeye, baa jeyyo vandʉʉ vaachwe sɨ vataanga ayo tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lomʉtóondo yaachwe akavoona Viisiraéeli vavɨrɨ vookiivaa, akaanda valamʉla yoosea, ‘Arumi, nyuunyu mʉrɨ vaantʉ va mʉʉntʉ ʉmwɨ! Sa che mookiitamikya?’ ");
INSERT INTO lag_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Maa kaa, ʉra ˆamuturikiryáa mwiiwaachwe akamʉkʉndʉla Mʉ́sa na ivarwii kʉnʉ yoomʉsea, ‘Nɨ ani akuvíikire ʉve mʉtemereri wiitʉ na mʉlamuli wiitʉ? ");
INSERT INTO lag_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nɨ saaka wiise wʉʉnjʉlae ja ˆvyeene ʉmʉʉlairé ʉra Mʉmísiri niijo wʉʉ?’ ");
INSERT INTO lag_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mʉ́sa ˆakateere ayo, akatɨɨja na ɨsɨ ya Midiáani, akɨɨta kiikala ʉko ja mʉyeni. Ʉko, akava na vaana vavɨrɨ va kɨɨntʉ kɨlʉme. ");
INSERT INTO lag_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Myaaka makumi yanɨ (40) ˆɨkalooke, murimʉ mʉʉja ʉkamʉfʉmɨra Mʉ́sa ituundwii ˆrookorera mooto, ʉko ɨsɨ ya ibaláángwii heehi na Lʉʉlʉ lwa Sináai. ");
INSERT INTO lag_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mʉ́sa akahwaalala maatʉkʉ vii koona ɨro isáare, akaseesa na heehi sa alaange neeja. Hahara akateera sawúti ya Ijʉva yoomʉsea, ");
INSERT INTO lag_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nɨɨnɨ ndɨrɨ Mʉlʉʉngʉ wa vala baaba waanyu, Aburaháamu, Isaka, na Yaakúupu.’ ˆAkateere ayo, akaanda tetema, akoofa baa kʉlaanga. ");
INSERT INTO lag_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Hara Ijʉva akamʉsea, ‘Fumya mirunkumo majewii yaako, aha haantʉ ˆwiímire nɨ haantʉ haaja. ");
INSERT INTO lag_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nɨɨnɨ nɨɨ́ne viintʉ vaantʉ vaanɨ ˆvootʉrɨkɨra ʉko ɨsɨ ya Mísiri, natéɨɨre kɨrɨro chaavo, nakíimire nɨvalamurirye fuma utúmwii. Haaha nɨkʉtʉme ʉdome na ʉko Mísiri.’ ");
INSERT INTO lag_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ʉhʉ Mʉ́sa noo yeeye ʉʼʉra vala baaba wiitʉ ˆvajáa vamusiita voosea, ‘Nɨ ani ˆakuvíikire ʉve mʉtemereri wiitʉ na mʉlamuli wiitʉ?’ Kwa njɨra ya ʉra murimʉ mʉʉja ˆmweene wamʉfʉmɨra hara ituundwii ˆrakoreráa mooto, Mʉlʉʉngʉ amʉtʉma ave mʉtemereri waavo na mʉlamuriri waavo. ");
INSERT INTO lag_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yeeye noo avalongoola vaantʉ va Isiraéeli fuma Mísiri kwa isháara na viintʉ ˆvihwáalaryaa ʉko Mísiri, mayiyii ya Sháamu, na ɨsɨ ya ibaláángʉ kwa myaaka makumi yanɨ (40). ");
INSERT INTO lag_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ʉhʉ Mʉ́sa noo ˆmweene avawyɨɨra Viisiraéeli yoosea, ‘Fuma kʉrɨ lʉkolo lwaanyu Mʉlʉʉngʉ vasaawʉrɨra arɨ mʉláali na mʉtwe fuma kʉrɨ vaanaanyu ˆiifwɨ́ɨne na nɨɨnɨ.’ ");
INSERT INTO lag_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yeeye noo ajáa hamwɨ na Viisiraéeli ʉko ɨsɨ ya ibaláángwii. Murimʉ mʉʉja alʉʉsa ne na vala baaba wiitʉ ʉko Luulwii lwa Sináai, akahokera masáare ya nkaasʉ sa atʉheere suusu. ");
INSERT INTO lag_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kɨrɨ vyoova jeyyo, vala baaba wiitʉ vajáa vamusiita Mʉ́sa vakamʉvɨɨka ivarwii, vakoona mpɨɨma mitimii yaavo vahɨndʉke na Mísiri. ");
INSERT INTO lag_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mʉ́sa ˆakachereve kʉhɨndʉka fuma luulwii, vakamʉsea Harúuni mwaanaavo, ‘Tʉtengenesherye kɨdabalaíyo ˆcheene kɨrɨ tʉlongoola njirii, sa Mʉ́sa ˆatʉlongoola fuma ʉko Mísiri sɨ tootaanga ˆcheene alʉ́mɨɨne nocho tʉkʉ!’ ");
INSERT INTO lag_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Sikʉ ijo, Viisiraéeli vakatengenesha kɨdabalaíyo ˆchiifwɨ́ɨne na ndama ya ngʼoombe. Baa neembe kɨjáa nɨ kɨɨntʉ cho tengenesha na mɨkono yaavo, voovo vakakɨtoorera mpóryo jo chɨmɨka na vakakɨbweeyyira ngovi. ");
INSERT INTO lag_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Aho, Mʉlʉʉngʉ akaleyya miiso na kwɨɨngɨ, akavareka viinamɨre mwaasʉ, mweeri na nyényeeri. Ja ˆvyeene yaandɨkwa kɨtáabwii cha valáali na mʉtwe, ‘Ee Nyuumba ya Isiraéeli! Mpɨɨndɨ ˆmwiikaláa ɨsɨ ya ibaláángʉ kwa myaaka makumi yanɨ, eri, mʉʉnsɨɨnjɨráa nchúwo jaanyu sa mʉʉntoorere mpóryo wʉʉ? Aka tʉkʉ! ");
INSERT INTO lag_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Laangi mwaverekáa itibu ro kiinamɨra kɨdabalaíyo cha Molóoki, na kɨdabalaíyo cha nyényeeri ya mʉlʉʉngʉ waanyu Refáani. Vidabalaíyo ivyo, mʉjáa mwavitengenesha sa mʉndooviinamɨra. Sa jeyyo, vatwaala ndɨrɨ na nyɨnɨkɨro ya Babéeli.’ ");
INSERT INTO lag_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kʉra ɨsɨ ya ibaláángwii, vala baaba wiitʉ vajáa vatɨɨte rɨra itibu ro kiinamɨra, ˆralaɨráa Mʉlʉʉngʉ novo arɨ. Ɨro rɨjáa ratengeneshiwa viviraviviira ja ˆvyeene Mʉlʉʉngʉ ajáa amoonekya Mʉ́sa. ");
INSERT INTO lag_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Vala baaba wiitʉ viiheereryáa mpɨɨndɨ Yooshʉ́a ˆavalongooláa. Novo ˆvakɨɨsʉmʉle ɨra ɨsɨ fuma kwa vaantʉ va ɨsɨ ijo, Mʉlʉʉngʉ ˆakavakibirye mbere yaavo, vakarɨreeta na ʉko. Ɨro itibu rɨkava rɨmwaarɨ fʉʉrʉ mpɨɨndɨ ja mʉtemi Daúdi. ");
INSERT INTO lag_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daúdi ajáa apata wʉʉja mbere ya Ijʉva, akamʉloomba yoosea, ‘Ee Ijʉva, Mʉlʉʉngʉ wa Yaakúupu nooloomba nɨkʉjeengere Kaaya Njija.’ ");
INSERT INTO lag_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Maa kaa, ʉra ˆajeenga ɨyo Kaaya Njija nɨ mʉtemi Solomóoni. ");
INSERT INTO lag_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Baa neembe nɨ jeyyo, yeeye ˆArɨ Mweerimweeri sɨ iíkalaa nyuumbii ˆngʼeene yajeengwa nɨ vaantʉ tʉkʉ. Ja ˆvyeene mʉláali na mʉtwe alʉʉsa, ");
INSERT INTO lag_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ijʉva alʉʉsa, “Kurumu nɨ ichuumbi raanɨ ra kɨtemi, na weerʉ nɨ ibambari raanɨ ro vɨkɨra majeo. Haaha nɨ nyuumba ɨrɨ joolɨ ˆmʉrɨ kʉʉnjeengera? Nɨ hai ˆndɨrɨ hʉmʉlʉka? ");
INSERT INTO lag_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Eri, ivyo vyoosi sɨ nɨɨnɨ navyʉʉmba tʉkʉ wʉʉ?”’” ");
INSERT INTO lag_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitefáani akavasea, “Eri, nyuunyu ˆmwahiingya nkiingo! Mɨtɨma yaanyu na matu yaanyu sɨ yanatwaalwa kɨbawii tʉkʉ. Sikʉ joosi nyuunyu mʉndoomʉkɨtɨra Mʉtɨma Mʉʉja ja ˆvyeene vala baaba waanyu vabweeyya. ");
INSERT INTO lag_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Eri, kwatɨɨte mʉláali na mʉtwe ˆmweene vala baaba waanyu sɨ vamuturikirya wʉʉ? Laangi, vavʉʉláa valáali na mʉtwe ˆvalʉʉsa kʉʉja kwa Yéesu Mʉwoloki! Na ʉwo noo nyuunyu ˆmwamʉtwaala na kwa vavɨ mʉkamʉʉlaa. ");
INSERT INTO lag_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nyuunyu mwahokera Miiro ya Mʉlʉʉngʉ kwa njɨra ya murimʉ mʉʉja, maa kaa, mʉkasiita kwɨɨteera.” ");
INSERT INTO lag_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Vara vakʉ́ʉ́lʉ va Vayahúudi ˆvakateere ayo masáare ya Sitefáani, maa vakakalala maatʉkʉ vii kʉnʉ viilúmire mayeo. ");
INSERT INTO lag_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Maa kaa, Mʉtɨma Mʉʉja akamʉheera ngururu Sitefáani, akalaanga kurumwii, akoona nkongojima ya Mʉlʉʉngʉ na Yéesu iímire mʉkono wa kʉlʉme wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Hara akavasea, “Laangi! Nɨɨ́ne kurumu kwayúurikire na Mwaana wa Mʉʉntʉ iímire mʉkono wa kʉlʉme wa Mʉlʉʉngʉ!” ");
INSERT INTO lag_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hahara vakʉ́ʉ́lʉ va Vayahúudi vakasiita kʉmʉteerera, vakatʉʉnɨka matu yaavo kʉnʉ vootʉla isóso, maa voosi vakamʉkɨɨmɨrɨra Sitefáani hamwɨ. ");
INSERT INTO lag_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Hara, vakamufumya na mbarɨmbarɨ ya múuji, maa vakaanda mʉvaa na mawye. Mashahíidi vajáa vafumya nyweénda jaavo, maa vakajivɨɨka mawulwii ya mʉtavana ʉmwɨ ˆaséwaa Saúli ajilaange. ");
INSERT INTO lag_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mpɨɨndɨ ˆvamʉváa Sitefáani na mawye, yeeye amʉloombáa Mʉlʉʉngʉ yoosea, “Yéesu Mweenevyoosi, hokera mʉtɨma waanɨ!” ");
INSERT INTO lag_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Aho, akachwaama ɨsɨ, akarɨra vikʉlʉkʉʉlʉ yoosea, “Mweenevyoosi, karɨ ʉvalamʉrɨre sa ʉvɨ ʉhʉ tʉkʉ.” ˆAkalʉʉse jeyyo, mʉtɨma waachwe ʉkareka mʉvɨrɨ. ");
INSERT INTO lag_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na Saúli ajáa amwaarɨ aho, akeeriwa mʉtɨma sa kʉʉlawa kwa Sitefáani. Sikʉ ɨyo, mpuka ya vaantʉ ˆvamuruma Yéesu vakaanda turikiriwa mʉnʉmʉʉnʉ ʉko Yerusaléemu. Novo vakiipasa na ɨsɨ ya Yudéea, na Samaría. Vatumwi vii noo vajáa vachaala ʉko Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Sitefáani ˆakʉʉlawe, vaantʉ vamutúubaa Mʉlʉʉngʉ, vakɨɨta noo mʉtaaha, vakarɨra noo myaaha mʉnʉmʉʉnʉ sa Sitefáani. ");
INSERT INTO lag_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mpɨɨndɨ ijo, Saúli akaanda kuturikirya mpuka ya vaantʉ ˆvamuruma Yéesu. Yeeye ayeendáa nyuumbii ja vaantʉ, ɨndoovarutirirya vaantʉ valʉme na vaantʉ vaki no vachuunga mʉnyololwii. ");
INSERT INTO lag_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Vaantʉ ˆvamuruma Yéesu ˆvajáa vapásirwe, vakaanda variyʉla Masáare Maaja kɨra haantʉ ˆvadomáa. ");
INSERT INTO lag_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filíipi ne akadoma na múujii ʉmwɨ wa ɨsɨ ya Samaría. Ʉko akaanda kʉvavariyʉrɨra vaantʉ Masáare ya Masía. ");
INSERT INTO lag_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Vaantʉ ˆvakateere masáare Filíipi ˆalʉʉsáa na myuujíisa na isháara ˆabweeyyáa, vakateya matu yaavo. ");
INSERT INTO lag_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filíipi akibiryáa mirimʉ mɨvɨ fuma kwa vaantʉ ˆvarɨ foo, na mirimʉ mɨvɨ yarɨráa kati ˆyafumáa. Avahoryáa vaantʉ ˆvarɨ foo ˆvajáa vaakwya iyandiyandi na vivete. ");
INSERT INTO lag_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sa jeyyo, vaantʉ va ɨyo míiji vajáa veeriwa mɨtɨma maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Haaha aho múujii ʉwo wa ɨsɨ ya Samaría, kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆmweene abweeyyáa ʉsavɨ. Ʉhʉ mʉʉntʉ irina raachwe noo Simóoni asewáa. Yeeye avahwaalaryáa vaantʉ voosi va ɨsɨ ya Samaría kwa ʉsavɨ ˆmweene abweeyyáa. Kei, iiyonáa yeeye nɨ nkabaako. ");
INSERT INTO lag_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Vaantʉ voosi, vasinga na vaantʉ vakʉʉlʉ vamʉteeráa matu neejaneeja voosea, “Mʉʉntʉ ʉhʉ noo ɨra ngururu ya Mʉlʉʉngʉ ˆɨséwaa Ngururu Nkʉʉlʉ.” ");
INSERT INTO lag_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vaantʉ avo vamʉteeráa matu, sa avahwaalaryáa kwa sikʉ ˆjiri foo na ʉsavɨ waachwe. ");
INSERT INTO lag_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Maa kaa, Filíipi ˆakavariyʉle Masáare Maaja ya Ʉtemi wa Mʉlʉʉngʉ na irina ra Yéesu Kirisitʉ, vaantʉ vakaruma na vaantʉ valʉme na vaantʉ vaki vakabatisiwa. ");
INSERT INTO lag_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simóoni ne akamuruma Yéesu, akabatisiwa, maa akaanda mutuuba Filíipi na kɨra haantʉ ˆadomáa. ˆAkoone isháara na myuujíisa mɨkʉʉlʉ Filíipi ˆabweeyyáa, akahwaalariwa maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Vatumwi va Yéesu ˆvajáa vachaala Yerusaléemu ˆvakateere vaantʉ va Samaría novo varirúmire isáare ra Mʉlʉʉngʉ, maa vakavatʉma vala Peéteri na Yooháani vadome na ʉko. ");
INSERT INTO lag_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Novo ˆvakafike ʉko, vakavaloombera vaantʉ vamʉhokere Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sa avo vaantʉ vajáa vabatisiwa kwa irina ra Yéesu Mweenevyoosi vii na Mʉtɨma Mʉʉja vajáa vakaarɨ sɨ vanamʉhokera tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peéteri na Yooháani vakavavɨkɨra avo vaantʉ mɨkono yaavo, novo vakamʉhokera Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simóoni ˆakoone vaantʉ vamʉhókɨɨre Mʉtɨma Mʉʉja kwa njɨra yo vɨkɨrwa mɨkono nɨ vatumwi, yeeye akayera kʉvaheera mpía vala Peéteri na Yooháani ");
INSERT INTO lag_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","yoovasea, “Mpeeri baa nɨɨnɨ lʉvɨro ʉlʉ, sa kɨra mʉʉntʉ ˆnkamʉvɨ́kɨraa mɨkono, amʉhokere Mʉtɨma Mʉʉja.” ");
INSERT INTO lag_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peéteri akamʉsea, “Isunke aha na mpía jaako! Nɨ kiisea wiise kɨlʉngʉlʉngʉ cha Mʉlʉʉngʉ chawʉ́lwaa na mpía! ");
INSERT INTO lag_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Weewe sɨ ʉrɨ hamwɨ na suusu murimwii ʉhʉ baa kiduudi vii tʉkʉ, sa mʉtɨma waako sɨ ʉrɨ mʉwoloki miiswii ya Mʉlʉʉngʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Valandʉka fuma ʉhʉ ʉvɨ waako, na ʉmʉloombe Mweenevyoosi akoonere mbavariri. Yeeye ifaanaa asee yasírire aya mavɨ ˆwaakiiririkana mutimii waako. ");
INSERT INTO lag_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nakwɨɨ́ne mʉtɨma waako wamema kɨvɨna, na waava mʉrerwa wa ʉvɨ.” ");
INSERT INTO lag_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simóoni akamʉsea, “Nooloomba mʉʉnoombere kwa Mweenevyoosi, sa ayo ˆmulúusire baa rɨmwɨ rɨdɨɨre kʉʉmpata.” ");
INSERT INTO lag_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Vala Peéteri na Yooháani vakoonekya kɨkomi na vakeenerya Masáare Maaja ya Yéesu Kirisitʉ Mweenevyoosi. Fuma ʉko vakahɨndʉka na Yerusaléemu. Kʉnʉ njirii vavariyʉláa Masáare Maaja maturii yɨɨngɨ ˆyarɨ foo ya Samaría. ");
INSERT INTO lag_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sikʉ ɨmwɨ, murimʉ mʉʉja wa Ijʉva ʉjáa wamʉsea Filíipi, “Inʉka, ʉdome na ivaru ra saame fʉʉrʉ ɨra njɨra ˆyafuma Yerusaléemu ˆyatamanya na Gáasa.” Njɨra ɨhɨ ɨjáa yatweera na ɨsɨ ya ibaláángwii. ");
INSERT INTO lag_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aho, maa Filíipi akakwaata njɨra. Njirii akalʉmana na mʉkʉ́ʉ́lʉ ʉmwɨ fuma Esiópia, ʉwo mʉʉntʉ nɨ mʉkʉlʉkʉʉlʉ wa ɨsɨ ajáa na ajáa achulwa asiina mbyaala tʉkʉ. Ʉwo noo ɨɨmɨrɨráa mpía joosi ja Kandáake, noo kʉsea, mʉtemi muki wa ɨsɨ ya Esiópia. Ʉhʉ mʉkʉ́ʉ́lʉ ajáa adómire na Yerusaléemu noo mwiinamɨra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mpɨɨndɨ ijo, nɨ hɨndʉka ahɨndʉkáa na kaayii. Yeeye ajáa iíkyɨɨre gáarii yaachwe ˆirútwaa nɨ faráasi kʉnʉ yoosoma kɨtáabu cha Isáaya mʉláali na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Aho, Mʉtɨma Mʉʉja akamʉsea Filíipi, “Tamanya fʉʉrʉ wɨɨkwaate ɨra gáari.” ");
INSERT INTO lag_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Akɨɨkɨbɨrɨra mpaka akɨɨkwaata. Ʉko gáarii akateera mʉʉntʉ yoosoma kɨtáabu cha Isáaya mʉláali na mʉtwe. Filíipi akamuurya, “Taanga wiise ayo ˆwoosoma wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ne akamʉsea, “Joolɨ ndɨrɨ taanga na nɨɨnɨ nsiina mʉʉntʉ wo kʉʉnvariyʉrɨra masáare aya?” Hara, akamʉloomba Filíipi ɨɨngɨre na gáarii novo vakiikala hamwɨ. ");
INSERT INTO lag_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Masáare ˆYarɨ Mpeho ˆmeene asomáa ʉwo Mweesiópia nɨ aya, “Ajáa alongoriwa ja muundi ˆyootwaala noo sɨɨnjwa. Ne ajáa akirinya sawu ja ˆvyeene mwaana wa muundi akírinyaa kati ˆyookerwa mabaáhɨra. Yeeye sɨ iinʉla mʉlomo waachwe tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Vakamuchwa matɨ na vakamʉsea nɨ mʉvɨ, maa kaa, yeeye sɨ abweeyya ʉvɨ wowoosi tʉkʉ. Kusiina mʉʉntʉ ˆarɨ daha lʉʉsɨkɨra masáare ya mbyaala yaachwe tʉkʉ. Sa kʉva mooyo kwaachwe, kwaseyyiwa aha weerwii.” ");
INSERT INTO lag_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ʉra Mweesiópia akamuurya Filíipi, “Nooloomba wʉʉngyɨɨre masáare aya mʉláali na mʉtwe alʉʉsa sa ani? Nɨ sa yeeye mweeneevyo au sa mʉʉntʉ wɨɨngɨ?” ");
INSERT INTO lag_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hahara Filíipi akaanda na yayara Masáare ˆYarɨ Mpeho, akamʉvariyʉrɨra Masáare Maaja ya Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mpɨɨndɨ ˆvayeendáa, vakafika haantʉ ˆkʉjáa na maaji. Ʉra Mweesiópia akamʉsea Filíipi, “Laanga! Maaji naaya aha. Che kɨrɨ kʉʉnkɨtɨra ndɨɨre batisiwa?”  ");
INSERT INTO lag_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filíipi akamʉsea, “Koonɨ wooruma kwa mʉtɨma waako woosi daha ʉrɨ batisiwa.” Akamʉsea, “Narúmire, Yéesu Kirisitʉ nɨ Mwaana wa Mʉlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hara ʉra Mweesiópia akalairirya gáari yaachwe yiimiwe, vakakiima, vakɨɨngɨra luujii, maa Filíipi akamʉbatisa. ");
INSERT INTO lag_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ˆVakafume vii luujii, hahara, Mʉtɨma wa Ijʉva ʉkamʉsʉmʉla Filíipi, na ʉra Mweesiópia sɨ amoona kei tʉkʉ. Akatuuba lʉyeendo lwaachwe kʉnʉ arɨ na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filíipi ne akiishaana arɨ múujii wa Asóoto. Akatweera míiji yoosi ɨrɨ njirii kʉnʉ yoovariyʉla Masáare Maaja mpaka akafika múujii wa Kaisaría. ");
INSERT INTO lag_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mpɨɨndɨ ijo, Saúli ajáa atuuba kʉvavuumba vaantʉ ˆvamuruma Yéesu Mweenevyoosi. Yeeye asaakáa avamale imalo. Aho, akadoma na kwa mweeneɨsɨ mʉkʉʉlʉ, ");
INSERT INTO lag_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","noo loomba barʉ́wa sa akataangwe ʉko masinagóogii ya Damésiki. Barʉ́wa ijo, jamʉheeráa ngururu yo vakwaata no vachuunga vaantʉ valʉme na vaantʉ vaki vara ˆvaruma Njɨra ya Yéesu Mweenevyoosi sa avatwaale na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Aho, akakwaata njɨra yo doma na Damésiki. ˆAkasengerere Damésiki, koonka kɨweerʉ kɨkʉʉlʉ fuma kurumwii kɨkamʉmʉrɨka fuma kɨra ivaru. ");
INSERT INTO lag_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Haaho akawya na ɨsɨ na akateera sawúti yookaanɨrɨra, “Saúli, Saúli sa che wookuunturikirya?” ");
INSERT INTO lag_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saúli akasea, “Aaɨ Mʉkʉ́lʉ, ʉrɨ ani weewe?” Na ɨra sawúti ɨkamʉsea, “Nɨɨnɨ ndɨrɨ Yéesu. Weewe wookuunturikirya. ");
INSERT INTO lag_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ɨma, ʉtamanye na múujii, ʉko wyɨɨrwa ʉrɨ nɨ mʉʉntʉ ʉmwɨ ˆcheene woosaakwa ʉbweeyye.” ");
INSERT INTO lag_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Vaantʉ ˆayeendanʼyáa novo vajáa viímire kimi kʉnʉ vahwáalɨɨre, sa baa voovo vajáa vatéɨɨre ɨyo sawúti, maa kaa, sɨ vamoona mʉʉntʉ yoyoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Hara, Saúli akiinʉka, akasaaka kʉnʉkʉla miiso baa koona kɨɨntʉ tʉkʉ. Vara viivaachwe vakamʉkwaata mʉkono vakamʉtwaala fʉʉrʉ Damésiki. ");
INSERT INTO lag_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Saúli iikala ʉko kwa sikʉ itatʉ baa koona tʉkʉ. Mpɨɨndɨ ijo, sɨ arijáa baa noo nywa kɨɨntʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ʉko Damésiki kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆamuruma Yéesu ˆasewáa Ananía. Yéesu Mweenevyoosi ajáa amwáanɨrɨɨre Ananía njorii akamʉsea, “Ananía!” Ne akamʉsea, “Mweenevyoosi, nɨɨnɨ nʉ aha!” ");
INSERT INTO lag_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mweenevyoosi akamʉsea, “Tamanya fʉʉrʉ njɨra ɨra ˆyaséwaa Njɨra ˆYawoloka. Aho, nyuumbii ya Yʉ́ʉda, wuurikirirye mʉʉntʉ ʉmwɨ fuma Társo irina raachwe Saúli. Haaha nɨ mʉloomba iise Mʉlʉʉngʉ, ");
INSERT INTO lag_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na ɨɨ́ne njori. Ʉko njorii amwɨɨ́ne mʉʉntʉ ˆasewáa Ananía yookɨɨngɨra na nyuumbii na amʉvɨ́kɨɨre mɨkono sa oone kei.” ");
INSERT INTO lag_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Maa kaa, Ananía akamʉsea, “Ee Mweenevyoosi, nateera kwa vaantʉ ˆvarɨ foo ˆvyeene ʉhʉ Saúli avatʉmamɨra viintʉ vɨvɨ vaantʉ vaako vaaja ʉko Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Haaha amwaarɨ aha arɨ na wiimiriri fuma kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva wo kwaata vaantʉ voosi ˆvariruma irina raako.” ");
INSERT INTO lag_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Maa kaa, Mweenevyoosi akamʉsea Ananía, “Weewe doma! Ʉhʉ mʉʉntʉ nɨɨnɨ namʉsáawɨɨre ave mʉtʉmami waanɨ. Yeeye kweenerya arɨ irina raanɨ kwa vaantʉ sɨ ˆvarɨ Vayahúudi, kwa vatemi, baa na kwa Viisiraéeli. ");
INSERT INTO lag_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nɨɨnɨ mweeneevyo kʉmʉlaɨra ndɨrɨ ˆvyeene arɨ turikiriwa maatʉkʉ vii sa irina raanɨ.” ");
INSERT INTO lag_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hara Ananía akadoma, akɨɨngɨra nyuumba kʉʉntʉ ˆajáa Saúli. Akamʉvɨkɨra mɨkono akamʉsea, “Saúli mwanawiitʉ, Yéesu Mweenevyoosi aantúmire kwaako, waande koona, ʉmʉhokere Mʉtɨma Mʉʉja. Ʉhʉ Yéesu noo akʉfʉmɨra kʉra njirii kati ˆwʉʉjáa na aha.” ");
INSERT INTO lag_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Koonka, viintʉ ˆviri ja majʉla vikawya fuma miiswii ya Saúli, akaanda koona. Aho, akiinʉka, akabatisiwa. ");
INSERT INTO lag_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ˆAkahʉmʉle kurya chákurya, maa akava na ngururu kei. Saúli iikalakala ʉko Damésiki, na mpɨɨndɨ ijo nɨ na vaantʉ ˆvamuruma Yéesu ajáa. ");
INSERT INTO lag_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Hahara, akaanda doma na masinagóogii, na akaanda variyʉla Yéesu nɨ Mwaana wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Vaantʉ voosi ˆvateereráa ʉvariyuli waachwe ʉwo, vahwaalaláa maatʉkʉ vii. Viiyuryáa voosea, “Eri, ʉhʉ sɨ noo ʉra mʉʉntʉ ˆavaturikiryáa mʉnʉmʉʉnʉ vaantʉ ˆvamuruma Yéesu ʉko Yerusaléemu tʉkʉ wʉʉ? Eri, ˆchamʉreeta na aha sɨ joo kwaata vaantʉ ˆvamuruma Yéesu aha Damésiki sa avatwaale na kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Maa kaa, Saúli akava yookiitema mʉnʉmʉʉnʉ, yeeye avavariyʉrɨráa Vayahúudi ˆviikaláa Damésiki, ko tweera Masáare ˆYarɨ Mpeho Yéesu noo Masía na sɨ vadaháa siita tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mpɨɨndɨ ˆjikalooke, Vayahúudi vakatʉʉnga mʉryʉʉngʉ wo mʉʉlaa Saúli. ");
INSERT INTO lag_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Vakaanda kumugiida mɨryaangwii ya ʉra múuji uchikʉ na muusi sa vamʉʉlae. Maa kaa, mʉryʉʉngʉ waavo wo mʉʉlaa ʉkamʉfɨkɨra Saúli. ");
INSERT INTO lag_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sa jeyyo, nuuchikʉ vapooji vaachwe vakamʉvɨkɨra kɨkápwii kɨkʉʉlʉ, vakamukiimya na ɨsɨ na ludihi ko tweera na chooririi ˆcheene kɨjáa lʉkaandii lwa múuji, maa akalooka. ");
INSERT INTO lag_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saúli ˆakafike Yerusaléemu, akiisompyasompya kʉsaangɨra na vaantʉ ˆvamuruma Yéesu. Vaantʉ voosi ˆvamuruma Yéesu vakamoofa, sa sɨ varumáa koonɨ ajáa amurúmire Yéesu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Maa kaa, Barinába akamʉtwaala Saúli na kwa vatumwi va Yéesu. Akavawyɨɨra ˆvyeene Saúli ajáa amoona Mweenevyoosi njirii yoodoma na Damésiki na ˆvyeene Mweenevyoosi amuwyɨɨra. Kei, akavawyɨɨra ˆvyeene Saúli avavariyʉrɨráa vaantʉ Masáare ˆYarɨ Mpeho ko kiitema ʉko Damésiki. ");
INSERT INTO lag_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sa jeyyo, Saúli akiikala hamwɨ novo. Ɨndoorɨɨngɨrɨra novo ʉko Yerusaléemu, kʉnʉ yoovavariyʉrɨra vaantʉ kwa irina ra Yéesu Mweenevyoosi baa woowa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Alʉʉsɨkáa no kwiiruta ndihi na Vayahúudi ˆveene valʉʉsɨkáa Kɨgiríki, maa kaa, voovo vasaakáa vamʉʉlae. ");
INSERT INTO lag_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Maa kaa, vaaniitʉ ˆvakataange ayo, vakamʉsʉmʉla, vakamʉtwaala na múujii wa Kaisaría, maa vakamʉtʉma atamanye na kwaavo ʉko múujii wa Társo. ");
INSERT INTO lag_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mpɨɨndɨ ijo, mpuka ya vaantʉ ˆvamuruma Yéesu vajáa viikala mwiikalo mʉʉja ɨsɨ yoosi ya Yudéea, Galiláaya, na Samaría. Vajáa vakɨɨngɨka, vajáa vadoma na mbere, na Mʉtɨma Mʉʉja ajáa avaheera mʉtɨma. Kei vamʉnyemyáa Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mpɨɨndɨ ijo, Peéteri arɨɨngɨrɨráa ʉko nooko, akadoma fʉʉrʉ múuji wa Líida sa avaluumbye vaantʉ va Mʉlʉʉngʉ ˆviikaláa ʉko. ");
INSERT INTO lag_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ʉko Líida akamʉshaana mʉʉntʉ ʉmwɨ ˆasewáa Ainéea. Ʉhʉ ajáa aakwya iyandiyandi kwa myaaka ɨnaanɨ na alaala ndirii vii. ");
INSERT INTO lag_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peéteri akamʉsea, “Ainéea, Yéesu Kirisitʉ akʉhóriirye. Inʉka! Fota ndɨrɨ yaako.” Koonka, Ainéea akiinʉka. ");
INSERT INTO lag_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Vaantʉ voosi ˆviikaláa ʉko múuji wa Líida na nyika yoosi ya Sharóoni ˆvakamoone Ainéea, vakamuruma Yéesu Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ʉko múuji wa Yóopa, kʉjáa kwatɨɨte mwaana muki ʉmwɨ ˆajáa amuruma Yéesu irina raachwe noo Tabíita asewáa, noo kʉsea Dorikáasi na Kɨgiríki. Dorikáasi avaambiriryáa vakɨva na avabweeyyiryáa vaantʉ vɨɨngɨ vaaja. ");
INSERT INTO lag_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mpɨɨndɨ ijo Peéteri ˆajáa ʉko, Dorikáasi ajáa alwaala, maa akawulala. Vaantʉ vakamooyya, vakamʉlaarya, maa vakamʉvɨɨka chúumba cha gorófii. ");
INSERT INTO lag_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na sa viintʉ múuji wa Líida ʉjáa heehi na Yóopa, vaantʉ ˆvamuruma Yéesu vakateera Peéteri amwaarɨ Líida. Sa jeyyo, vakavatʉma vaantʉ vavɨrɨ vakamwaanɨrɨre. Vakavasea, vakamʉsee jei, “Tooloomba wʉʉje chaangʉ na mɨɨtʉ, karɨ ʉchérevaa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aho, maa Peéteri akatamanyanʼya novo. ˆVakafike Yóopa, vakamʉtwaala Peéteri na kʉra chúumba cha gorófii. Ʉko, valala ˆvarɨ foo vakaanda kʉmʉrɨɨngɨrɨra Peéteri kʉnʉ voomʉrɨrɨra no mʉlaɨra Peéteri ɨngo ˆngʼeene Dorikáasi avachʉmɨra kati ˆajáa arɨ mooyo. ");
INSERT INTO lag_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peéteri akavaseyya voosi na weerwii, akachwaama, akamʉloomba Mʉlʉʉngʉ. Hara akʉʉlaanga ʉra mʉvɨrɨ, maa akasea, “Tabíita, inʉka!” Tabíita akakʉnʉkʉla miiso yaachwe, na ˆakamoone Peéteri, akiikala. ");
INSERT INTO lag_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peéteri akamʉkwaata mʉkono, maa akamwaambirirya kwɨɨma. Akavaanɨrɨra vara valala, na vaantʉ vɨɨngɨ ˆvamuruma Yéesu, maa akavalaɨra Tabíita arɨ mooyo. ");
INSERT INTO lag_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Masáare aya yakeenera múujii woosi wa Yóopa, vaantʉ ˆvarɨ foo vakamuruma Yéesu Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peéteri akiikala ʉko Yóopa kwa sikʉ ˆjiri foo na kʉʉntʉ ˆɨkaláa nɨ kwa mʉʉntʉ ˆaséwaa Simóoni ˆmweene aténgeneshaa mɨmberʉ. ");
INSERT INTO lag_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ʉko múujii wa Kaisaría, kʉjáa kwatɨɨte mʉkʉ́ʉ́lʉ wa valwi nkoondo ʉmwɨ ˆasewáa Kornéeli. Ʉhʉ ɨɨmɨrɨráa valʉkalʉka fuma mpuka nkʉʉlʉ ya valʉkalʉka ˆyasewáa Mpuka ya Kiitalía. ");
INSERT INTO lag_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornéeli nɨ mʉʉntʉ mʉʉja ajáa, na amʉnyemyáa Mʉlʉʉngʉ hamwɨ na vaantʉ voosi va kaaya yaachwe. Yeeye amʉloombáa Mʉlʉʉngʉ mpɨɨndɨ joosi na avaambiriryáa vakɨva. ");
INSERT INTO lag_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sikʉ ɨmwɨ mpɨɨndɨ ja cháámuusi, akoona njori. Aho njorii akoona murimʉ mʉʉja wa Mʉlʉʉngʉ woomwaanɨrɨra kwa irina raachwe, “Kornéeli!” ");
INSERT INTO lag_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornéeli akʉʉlaanga ʉra murimʉ mʉʉja na woowa, maa akuurya, “Ee aaɨ nɨ che?” Murimʉ mʉʉja ʉkamʉsea, “Mʉlʉʉngʉ atéɨɨre kʉloomba kwaako na ɨɨ́ne ˆvyeene ʉvaambɨráa vakɨva. Ivyo vyoosi vyafíkire kwa Mʉlʉʉngʉ na vikʉmbʉkɨra iise. ");
INSERT INTO lag_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Haaha, tʉma vaantʉ vatamanye na múujii wa Yóopa, sa vakamʉreete mʉʉntʉ ʉmwɨ ˆaséwaa Simóoni irina rɨɨngɨ Peéteri. ");
INSERT INTO lag_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kʉʉntʉ ˆyookiikala nɨ kwa Simóoni mʉtengeneshi wa ndɨrɨ. Nyuumba yaachwe nɨ mbarɨmbarɨ ya mayɨya ɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Murimʉ mʉʉja ˆʉkahʉmʉle kumuwyɨɨra Kornéeli ayo masáare, maa ʉkalooka. Aho, maa akavaanɨrɨra vatʉmami vaachwe vavɨrɨ na mulwi nkoondo ʉmwɨ ˆmweene ajáa mʉʉja. ");
INSERT INTO lag_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Akavawyɨɨra yoosi ˆyajáa yamʉfʉ́mɨɨre, maa akavatʉma vadome na Yóopa. ");
INSERT INTO lag_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sikʉ ya kavɨrɨ mpɨɨndɨ ja mpoloonge, vaantʉ ˆveene Kornéeli ajáa avatʉma vakava vaséngerɨɨre Yóopa. Mpɨɨndɨ yɨɨyo, Peéteri ne akaambʉka na ikekeerii noo mʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mpɨɨndɨ ˆasaaryáa, njala ɨkamwaava mʉnʉmʉʉnʉ. Maa kaa, mpɨɨndɨ chóorya ˆchiimiwáa neeja, akoona njori. ");
INSERT INTO lag_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Aho njorii, akoona kurumu kwayúurikire, na kɨɨntʉ ja lweénda lʉkʉlʉkʉʉlʉ ˆlwakwáatirwe makondowa yoosi lʉkakiima fʉʉrʉ ɨsɨ. ");
INSERT INTO lag_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Isii ya ʉlo lweénda, kʉjáa kwatɨɨte maka ja kɨra ivala. Kʉjáa kwatɨɨte maka ˆjiri na mawʉlʉ yanɨ, viintʉ ˆvitámbaalaa na ndee. ");
INSERT INTO lag_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aho, akateera sawúti yoomʉsea, “Peéteri, inʉka, ʉsɨɨnje, urye.” ");
INSERT INTO lag_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Maa kaa, Peéteri akamʉsea, “Ee Mweenevyoosi, tʉkʉ! Nɨɨnɨ sɨ nɨnaarya baa kamudu vii tʉkʉ kɨɨntʉ chochoosi ˆkɨrɨ na njeo.” ");
INSERT INTO lag_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kei ɨyo sawúti ɨkamʉsea lwa kavɨrɨ, “Kuvisea viintʉ ˆavijirʉla Mʉlʉʉngʉ viri na njeo tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ivi vijáa vyafʉmɨra katatʉ, maa lʉra lweénda lʉkahɨndʉlwa na kurumwii. ");
INSERT INTO lag_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mpɨɨndɨ Peéteri ˆajáa akaarɨ ahwáalɨɨre, vaantʉ vara ˆvajáa vatúmirwe nɨ Kornéeli vakuurikirirya ɨra nyuumba ya Simóoni, maa vakɨɨtaanga. Aho, maa vakɨɨma mʉryaangwii. ");
INSERT INTO lag_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Vakaluumbya, maa vakuurya, “Eri, aha kwatɨɨte mʉyeni ˆaséwaa Simóoni, na irina rɨɨngɨ Peéteri wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na mpɨɨndɨ Peéteri ˆiiririkanáa ɨra njori, Mʉtɨma Mʉʉja akamʉsea, “Simóoni, ʉko ɨsɨ vamwaarɨ vaantʉ vatatʉ vookʉsaakɨra. ");
INSERT INTO lag_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kiima na ɨsɨ na ʉdomanʼye novo. Kʉva na kivundu tʉkʉ, nɨ nɨɨnɨ mweeneevyo nɨvatúmire kwaako.” ");
INSERT INTO lag_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Aho, Peéteri akakiima na ɨsɨ, maa akavasea, “Nɨɨnɨ noo ˆmweene mookʉʉnsaakɨra. Che kɨvaréetire?” ");
INSERT INTO lag_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Vakamʉsea, “Mʉkʉ́ʉ́lʉ ʉmwɨ wa valwi nkoondo atutúmire. Irina raachwe noo Kornéeli aséwaa. Yeeye nɨ mʉwoloki na amʉnyémyaa Mʉlʉʉngʉ na Vayahúudi voosi vamʉdʉ́ʉmbaa. Haaha murimʉ mʉʉja wamʉsea, akʉteengye na kaayii kwaachwe na ateerere masáare ˆʉrɨ muwyɨɨra.” ");
INSERT INTO lag_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Aho, maa Peéteri akavateengya na nyuumbii, vave vayeni vaachwe. Lomʉtóondo yaachwe, Peéteri akiinʉkanʼya na vara vayeni na vamwɨ va vaaniitʉ fuma Yóopa. ");
INSERT INTO lag_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kukyɨɨre yaachwe, vakafika Kaisaría. Kʉra vakamʉshaana Kornéeli avajíingire vandʉʉ vaachwe na vijeengi vyaachwe, yoovawoojera. ");
INSERT INTO lag_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peéteri ˆakɨɨngɨre vii kaayii kwa Kornéeli, maa Kornéeli akɨɨta noo musingirirya, akachwaama mbere yaachwe, maa akamwiinamɨra. ");
INSERT INTO lag_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Maa kaa, Peéteri akamwiimya, kʉnʉ yoomʉsea, “Ɨma, nɨɨnɨ ndɨrɨ mʉʉntʉ ja weewe.” ");
INSERT INTO lag_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Aho, Kornéeli akɨɨma, vakaanda lʉʉsɨka hamwɨ, maa vakɨɨngɨra na nyuumbii, vakashaana vaantʉ viijíingire. ");
INSERT INTO lag_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Aho, Peéteri akavasea, “Nyuunyu veeneevyo mwamányire, suusu Vayahúudi Miiro yiiswi yakaanʼya ko valuumbya vaantʉ sɨ ˆvarɨ Vayahúudi baa kʉsaangɨrɨra novo. Maa kaa, Mʉlʉʉngʉ aankáaniirye ndeke kʉmʉlaanga mʉʉntʉ wɨɨngɨ yoyoosi ja ˆarɨ na njeo. ");
INSERT INTO lag_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Noo ˆchooreka sɨ nasiitiré kʉʉja mpɨɨndɨ ˆʉkavatʉme vaantʉ na kwaanɨ jɨ vaandeete na aha. Haaha nɨ kuvuurya niise, sa che mʉʉnyánɨrɨɨre?” ");
INSERT INTO lag_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornéeli akamʉsea, “Jalóokire sikʉ ine keende mpɨɨndɨ ɨra ˆnamʉlóombaa Mʉlʉʉngʉ aha nyuumbii, mpɨɨndɨ ja iji ja cháámuusi. Koonka, noona mʉʉntʉ iímire mbere yaanɨ iivɨ́kɨɨre ɨngo ˆjilavalaváa. ");
INSERT INTO lag_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ʉhʉ mʉʉntʉ aansea, ‘Kornéeli! Kʉlʉʉsɨka kwaako Mʉlʉʉngʉ akʉtéɨɨre na kʉvaambirirya kwaako vakɨva, Mʉlʉʉngʉ akwɨɨ́ne. ");
INSERT INTO lag_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Haaha, tʉma vaantʉ vadome vakamwaanɨrɨre Simóoni ˆvamʉséaa Peéteri. Ʉhʉ iíkalaa Yóopa kwa mʉʉntʉ ʉmwɨ irina raachwe Simóoni ˆmweene aténgeneshaa ndɨrɨ. Nyuumba ya ʉhʉ Simóoni nɨ mbarɨmbarɨ ya mayɨya ɨrɨ.’ ");
INSERT INTO lag_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aya noo yaambweeyyiiryé ntʉme chaangʉ vaantʉ jɨ vakwaanɨrɨre, na weewe wabwéeyyiirye vyabooha viintʉ ˆwuújire. Haaha suusu voosi nɨ mbere ya Mʉlʉʉngʉ tʉrɨ, toowoojera kʉteera masáare Mweenevyoosi ˆakʉláiriirye utuwyɨɨre.” ");
INSERT INTO lag_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Aho, maa Peéteri akavasea, “Haaha natáangire, nɨ kɨkomi Mʉlʉʉngʉ sɨ asínanalaa vaantʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yeeye avarúmaa vaantʉ va kɨra ɨsɨ ˆveene vamʉnyémyaa na vabwéeyyaa ʉwoloki mbere jaachwe. ");
INSERT INTO lag_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nyuunyu mwamányire, Mʉlʉʉngʉ atʉma vaantʉ vaachwe kʉvavariyʉrɨra ViisiraéeliMasáare Maaja, vapate mwiikalo mʉʉja kwa njɨra ya YéesuKirisitʉ, Mweenevyoosi wa vaantʉ voosi. ");
INSERT INTO lag_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwamányire yara ˆyafʉ́mɨɨre Yudéea yoosi, kwaandɨra Galiláaya mpɨɨndɨ Yooháani ˆavavariyʉrɨráa vaantʉ vabatisiwe. ");
INSERT INTO lag_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mwamányire ˆvyeene Mʉlʉʉngʉ amʉhaka makuta Yéesu wa Nasaréeti ko mʉheera Mʉtɨma Mʉʉja na lʉvɨro. Yéesu adomáa ʉko na ʉko, yoobweeyya maaja no horya vaantʉ voosi ˆveene vaturikiriwáa nɨ ngururu ya Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ, sa Mʉlʉʉngʉ nɨ hamwɨ ajáa ne. ");
INSERT INTO lag_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ayo yoosi Yéesu ayatʉmamáa ʉko ɨsɨ ya Vayahúudi na Yerusaléemu múujii, na suusu tʉrɨ vara ˆvoona. Mpɨɨndɨ ˆjikalooke, vakamʉʉlaa ko muningʼinʼya mʉsaláabii. ");
INSERT INTO lag_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Maa kaa, sikʉ ya katatʉ Mʉlʉʉngʉ akamʉfʉfʉla na akamoonekya kwa vaantʉ. ");
INSERT INTO lag_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Sɨ oonekana kwa kɨra mʉʉntʉ tʉkʉ, maa kaa, kʉrɨ suusu Mʉlʉʉngʉ ˆajáa atʉsaawʉla tʉve vara ˆvoona. Suusu twaarya, no nywa ne ˆakafʉfʉke. ");
INSERT INTO lag_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Akatʉlairirya tʉvavariyʉrɨre vaantʉ Masáare Maaja, na toonekye kɨkomi yeeye noo avɨɨkwa nɨ Mʉlʉʉngʉ avalamʉrɨre vaantʉ ˆvarɨ mooyo na ˆvaakwya. ");
INSERT INTO lag_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ʉhʉ Yéesu valáali na mʉtwe voosi voonekya ʉkʉ́ʉ́lʉ waachwe, vakasea, mʉʉntʉ yoyoosi ˆarɨ kumuruma ʉvɨ waachwe sira ʉrɨ kwa irina raachwe.” ");
INSERT INTO lag_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kati Peéteri ˆavijáa akaarɨ yoolʉʉsɨka ayo, vaantʉ voosi ˆvajáa aho vooyateerera ayo masáare, Mʉtɨma Mʉʉja akavakiimɨra. ");
INSERT INTO lag_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Vayahúudi ˆvajáa vamuruma Yéesu vara ˆvajáa vʉʉjanʼya na Peéteri, vakahwaalala koona vaantʉ sɨ ˆvarɨ Vayahúudi novo vookiimɨrwa nɨ Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Voovo vajáa vavatéɨɨre voolʉʉsɨka kwa ndʉʉsɨka ˆjiísimiresimire voomʉdʉʉmba Mʉlʉʉngʉ. Aho, Peéteri akasea, ");
INSERT INTO lag_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Vaantʉ ava, novo vamʉhókɨɨre Mʉtɨma Mʉʉja ja ˆvyeene suusu tamʉhokera. Nɨ ani ˆarɨ daha siita vadɨɨre batisiwa na maaji?” ");
INSERT INTO lag_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Haaho Peéteri akalairirya Kornéeli na viivaachwe vabatisiwe kwa irina ra Yéesu Kirisitʉ. Maa reerʉ, vakamʉloomba iikale novo kwa sikʉ nke. ");
INSERT INTO lag_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Haaha, vatumwi na vaaniitʉ vara ˆviikaláa Yudéea, vakateera vaantʉ sɨ ˆvarɨ Vayahúudi novo varirúmire isáare ra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peéteri ˆakahɨndʉke na Yerusaléemu, maa vara Vayahúudi vakaanda mʉngʼʉʉrɨra Peéteri ");
INSERT INTO lag_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","voomʉsea, “Weewe wɨɨngɨɨré nyuumbii ya vaantʉ sɨ ˆvanatwaalwa na kɨbawii na ʉkarya novo!” ");
INSERT INTO lag_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Aho, Peéteri akavawyɨɨra pusu masáare yoosi ˆyafʉmɨra, yoovasea, ");
INSERT INTO lag_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Sikʉ ɨmwɨ kati ˆnɨjáa múujii Yóopa noomʉloomba Mʉlʉʉngʉ, nɨjáa noona kɨɨntʉ ja lweénda lʉkʉʉlʉ, lookiimiwa na ɨsɨ fuma kurumwii lwakwáatirwe makondowa yoosi, maa lʉkavɨɨkwa mbarɨmbarɨ yaanɨ. ");
INSERT INTO lag_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ˆNkalaange kʉra isii, nkoona kʉrɨ na maka ja isaka, maka ˆjiri na mawʉlʉ yanɨ, viintʉ ˆvitámbaalaa na ndee ˆjiwʉ́lʉkaa. ");
INSERT INTO lag_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aho, nkateera sawúti yookʉʉnsea, ‘Peéteri, inʉka, ʉsɨɨnje, urye!’ ");
INSERT INTO lag_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Maa kaa, nɨɨnɨ nkasea, ‘Ee Mweenevyoosi tʉkʉ! Laanga sɨ nɨnaarya kɨɨntʉ ˆkɨrɨ na njeo tʉkʉ!’ ");
INSERT INTO lag_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Maa kaa, ɨra sawúti fuma kurumwii ɨkaansea kei, ‘Kɨɨntʉ chochoosi ˆakijirʉla Mʉlʉʉngʉ, kʉchaanɨrɨra kɨrɨ na njeo tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Masáare aya yafʉmɨra katatʉ, aho, maa ivyo viintʉ vikahɨndʉlwa na kurumwii. ");
INSERT INTO lag_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Hahara, vaantʉ vatatʉ ˆvajáa vatúmirwe Kaisaría, vakafika nyuumba haantʉ ˆniikaláa. ");
INSERT INTO lag_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na Mʉtɨma Mʉʉja akaangwyɨɨra ndomanʼye novo baa kivundu tʉkʉ. Ava vaaniitʉ vasasatʉ nadomanʼya novo, na twɨɨngɨra kaayii kwa Kornéeli. ");
INSERT INTO lag_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ne Kornéeli atuwyɨɨra ˆvyeene murimʉ mʉʉja wamʉfʉmɨra aho kaayii kwaachwe. Ʉwo murimʉ mʉʉja wamʉsea, ‘Vatʉme vaantʉ vadome na Yóopa, vakamwaanɨrɨre Simóoni ˆaséwaa Peéteri. ");
INSERT INTO lag_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yeeye kʉretera arɨ masáare ˆyarɨ kʉlamurirya weewe na vaantʉ voosi va nyuumba yaako.’ ");
INSERT INTO lag_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Naanɨ ˆnkaande lʉʉsɨka novo, Mʉtɨma Mʉʉja akakiima mweeri yaavo ja ˆvyeene atʉkɨɨmɨra suusu aho ncholo. ");
INSERT INTO lag_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Naanɨ nkakʉmbʉkɨra rɨra isáare Yéesu Mweenevyoosi ˆatuwyɨɨra, ‘Yooháani avabatisáa vaantʉ na maaji, maa kaa, nyuunyu batisiwa mʉrɨ na Mʉtɨma Mʉʉja.’ ");
INSERT INTO lag_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Haaha koonɨ Mʉlʉʉngʉ avaheera vaantʉ ava wʉʉya wa Mʉtɨma Mʉʉja ʉra ˆatʉheera suusu ˆtamuruma Yéesu Kirisitʉ Mweenevyoosi, nɨɨnɨ ndɨrɨ ani mpaka niiririkane daha ndɨrɨ kumusiita Mʉlʉʉngʉ?” ");
INSERT INTO lag_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Vayahúudi ˆvakateere ayo, maa vakareka kwiiruta ndihi. Vakamʉbweeyyirya Mʉlʉʉngʉ nkongojima voosea, “Kʉmba Mʉlʉʉngʉ avaheera baa vaantʉ sɨ ˆvarɨ Vayahúudi njɨra ˆɨrɨ vabweeyya vadahe kʉvalandʉka fuma uvii waavo, na vapate nkaasʉ ya sikʉ ˆjisiina ʉhero!” ");
INSERT INTO lag_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Vaantʉ ˆvamuruma Yéesu ˆvajáa viimyaaha sa uturikiri Sitefáani ˆakʉʉlawe, vakatamanya na ɨsɨ ja Foiníike, Kúpuro na múuji wa Antiókia. Ʉko koosi vavariyʉláa Masáare ya Yéesu Mweenevyoosi kwa Vayahúudi vooveene vii. ");
INSERT INTO lag_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Maa kaa, ʉko Antiókia, vamwɨ va vaantʉ ˆvajáa vadoma na ʉko nɨ vaantʉ va ɨsɨ ya Kúpuro, na va múuji wa Kɨréene. Voovo vakaanda kʉvariyʉla Masáare Maaja ya Yéesu Mweenevyoosi baa kwa Vagiríki. ");
INSERT INTO lag_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na lʉvɨro lwa Mweenevyoosi nɨ hamwɨ novo lʉjáa. Ʉko, vaantʉ ˆvarɨ foo maatʉkʉ vii vakamuruma Yéesu Mweenevyoosi na vakamutuuba. ");
INSERT INTO lag_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mpuka ya vaantʉ ˆvamuruma Yéesu ʉko Yerusaléemu ˆvakateere aya masáare, maa vakamʉtʉma Barinába atamanye na Antiókia. ");
INSERT INTO lag_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ˆAkafike ʉko, akoona viintʉ Mʉlʉʉngʉ ˆavaheera nduwo vaantʉ avo. Akavyeenda maatʉkʉ vii, akavakalaamya voosi vatuube kʉmʉkwaatɨrɨra Yéesu Mweenevyoosi kwa mɨtɨma yaavo yoosi. ");
INSERT INTO lag_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barinába nɨ mʉʉntʉ mʉʉja ajáa na ajáa amema Mʉtɨma Mʉʉja na kuruma kwa kɨmáárɨ. Na vaantʉ ˆvamuruma Yéesu Mweenevyoosi vakakɨɨngɨka mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Sikʉ ˆjikaseese, Barinába akadoma na múuji wa Társo koo mʉsaakɨra Saúli. ");
INSERT INTO lag_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ˆAkamʉpate akamʉreeta na Antiókia. Ʉko kwa mwaaka vʉʉ, vakalʉmana na mpuka ya vaantʉ ˆvamuruma Yéesu, kʉnʉ vookiindya vaantʉ ˆvarɨ foo. Ʉko Antiókia vaantʉ vakaanda vaanɨrɨra vaantʉ ˆvamuruma Yéesu, Vakirisitʉ. ");
INSERT INTO lag_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sikʉ ijo, valáali na mʉtwe fuma Yerusaléemu vajáa vadoma na Antiókia. ");
INSERT INTO lag_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ʉmwɨ waavo noo Agáabo asewáa. Yeeye kʉtweera kwa Mʉtɨma Mʉʉja, ajáa ɨɨma, akalʉʉsa ʉláali na mʉtwe, “Njala nkʉʉlʉ ya imalo fʉmɨra ɨrɨ ɨsɨ jɨɨngɨ joosi.” Njala ɨyo noo ɨra ɨjáa yafʉmɨra mpɨɨndɨ ja Kaisáari Kɨlaáudi mʉtemi mʉkʉʉlʉ ˆɨɨmɨrɨráa. ");
INSERT INTO lag_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Sa jeyyo, vaantʉ ˆvamuruma Yéesu ʉko Antiókia, vakalamʉla kɨra mʉʉntʉ asaange viintʉ vyo vaambirirya vaaniitʉ vara ˆviikaláa ʉko ɨsɨ ya Yudéea. ");
INSERT INTO lag_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Vakasaanga na vakavaheera vala Barinába na Saúli vatwaale na kwa vawosi va vaantʉ ˆvamuruma Yéesu ʉko Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sikʉ ijo, mʉtemi Heróode Agiríipa ajáa aanda kʉvaturikirya vaantʉ vamwɨ va mpuka ya vaantʉ ˆvamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akalairirya Yaakúupu mwaanaavo na Yooháani ʉʉlawe na nyaasʉka. ");
INSERT INTO lag_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ˆAkoone masáare ayo yaveériirye mɨtɨma Vayahúudi, maa akalairirya Peéteri ne akwaatwe. Aya yajáa yafʉmɨra mpɨɨndɨ ja ngovi ya mɨkáate sɨ ˆɨvɨ́kɨrwaa ʉsasɨ. ");
INSERT INTO lag_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peéteri ˆakavɨɨkwe mɨkonwii yaavo, akachuungwa mʉnyololwii. Ʉko akatwaalwa na haantʉ ho laangiririwa nɨ valwi nkoondo vanɨ vanɨ va mpuka ine sa vamʉlaangirirye neejaneeja. Heróode akiiririkana Paásika ɨrɨ looka de amʉlamʉrɨre Peéteri mbere ja vaantʉ. ");
INSERT INTO lag_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Na sikʉ ijo, mpɨɨndɨ Peéteri ˆajáa achúungirwe mʉnyololwii, maa kaa, mpuka ya vaantʉ ˆvamuruma Yéesu vajáa viitoola mʉnʉmʉʉnʉ kʉmʉloomba Mʉlʉʉngʉ sa Peéteri. ");
INSERT INTO lag_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Uchikʉ wa sikʉ ˆngʼeene Heróode ajáa iiririkana kʉmʉlamʉrɨra Peéteri, Peéteri ajáa alaala ʉko mʉnyololwii. Yeeye nɨ katɨ na katɨ ya valwi nkoondo vavɨrɨ ajáa na vajáa vamuchuunga mɨkono yaachwe na mɨnyololo ɨvɨrɨ. Na mʉryaangwii wa gerésa kʉjáa kwatɨɨte valʉkalʉka vɨɨngɨ vamʉrɨndɨráa. ");
INSERT INTO lag_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Koonka, ʉkafʉmɨra murimʉ mʉʉja wa Ijʉva aho kʉʉntʉ ˆajáa Peéteri. Kɨweerʉ kɨkamʉrɨka hara haantʉ. Ʉra murimʉ mʉʉja ʉkamusingisya Peéteri mbarwii, ʉkamʉsea, “Inʉka chaangʉ!” Hara, mɨnyololo ˆvajáa vamuchúungire Peéteri ɨkawya na ɨsɨ! ");
INSERT INTO lag_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Aho, ʉra murimʉ mʉʉja ʉkamʉsea, “Imʉtɨre lʉkova lwaako, wiivɨkɨre na viráatʉ.” Peéteri ˆakamarikirye kʉbweeyya jeyyo, ʉra murimʉ mʉʉja ʉkamʉsea, “Ivɨkɨre ikóoti raako, wuuntuube!” ");
INSERT INTO lag_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peéteri akuutuuba ʉra murimʉ mʉʉja. Sɨ ataangáa ˆyafʉmɨra koonɨ nɨ kɨmáárɨ tʉkʉ, yeeye iiseáa nɨ njori. ");
INSERT INTO lag_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Peéteri na murimʉ mʉʉja vakavalooka valʉkalʉka va ncholo, na va kavɨrɨ, na vakafika mʉryaangwii mʉkʉʉlʉ wa chʉʉ́ma ˆwoofuma mʉnyololwii ˆwadoma na múujii. Mʉryaango ʉwo ʉkayʉʉrɨka wooweene, vakafuma na weerwii. ˆVakayeendeyeende fʉʉrʉ njirii ɨmwɨ, hahara, ʉra murimʉ mʉʉja ʉkamʉreka Peéteri. ");
INSERT INTO lag_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Aho, Peéteri akataanga ayo ˆyafʉ́mɨɨre, maa akasea, “Haaha natáangire, nɨ kɨmáárɨ! Ijʉva aantʉ́mɨɨre murimʉ mʉʉja jɨ wʉʉnamurirye fuma mɨkonwii ya Heróode na kwa yara yoosi Vayahúudi ˆvaawoojera mbweeyyiriwe.” ");
INSERT INTO lag_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Peéteri ˆakataange ayo, akadomerera na kaayii kwa Maríia íyo waala Yooháani ˆmweene aanɨrɨrwáa Maáriki. Aho nyuumbii, vaantʉ ˆvamuruma Yéesu vajáa viijíingire, voomʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peéteri akaluumbya mʉryaangwii wa weerwii wa ɨyo nyuumba. Muhíínja ʉmwɨ, mʉtʉmami ˆasewáa Róoda, akɨɨta ko teerera nɨ ani. ");
INSERT INTO lag_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ˆAkateere nɨ Peéteri, akavyeenda mʉnʉmʉʉnʉ, akahɨndʉka na nyuumbii baa kʉmʉyʉʉrɨra mʉryaango tʉkʉ. Akavawyɨɨra viivaachwe yoovasea, “Peéteri amwaarɨ mʉryaangwii!” ");
INSERT INTO lag_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Novo vakamʉsea ʉra muhíínja, “Ʉtɨɨte kɨsari!” Maa kaa, yeeye akadoomererya kʉvasea, atéɨɨre sawúti ya Peéteri. Voovo vakatuuba sea, “Nɨ murimʉ mʉʉja waachwe.” ");
INSERT INTO lag_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ne Peéteri ajáa adoomererya kuluumbya kʉra mʉryaangwii. ˆVakayʉʉle, vakamoona Peéteri, vakahwaalala maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peéteri akavalaɨra na mʉkono vakirinye, maa akavawyɨɨra ˆvyeene Mweenevyoosi amʉséyyiirye mʉnyololwii. Kei akavasea, “Muwyiiri ˆmeene yafʉ́mɨɨre Yaakúupu na vaaniitʉ.” Aho, maa Peéteri akalooka na kʉʉntʉ kwɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ˆKʉkeere, vara valwi nkoondo va mʉnyololwii vakoololokera sa sɨ vajáa vatáangire ˆkɨmʉpátire Peéteri tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heróode akalairirya Peéteri asaakwe kɨkomi. Maa kaa, ˆvakasiindwe kʉmʉpata, maa akavaanɨrɨra vara valʉkalʉka ˆvamʉlaangiriryáa Peéteri. Heróode akavachukuruma, aho, maa akalairirya vʉʉlawe. Mpɨɨndɨ ˆjikalooke, Heróode akakiima fuma Yudéea akatamanya na múuji wa Kaisaría, akiikala ʉko kwa mpɨɨndɨ. ");
INSERT INTO lag_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heróode ajáa avasʉʉla maatʉkʉ vii vaantʉ va míiji ya Tíiro na Sidóoni. Maa kaa, vaantʉ va ɨyo míiji vakava kɨɨntʉ kimudu sa vadome noo kiiyona na Heróode. Vakamʉheemba Bulásto, ne akava hamwɨ novo. Ʉhʉ Bulásto, noo ɨɨmɨrɨráa nyuumba ya mʉtemi. Aho, vakatamanya na kwa mʉtemi ko loomba kʉve na mwiikalo mʉʉja, sa míiji ɨyo yiilaangyáa chóorya fuma ɨsɨ ya mʉtemi. ");
INSERT INTO lag_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Haaha sikʉ ɨyo ˆngʼeene vajáa vasaawʉla valʉmane, Heróode akiivɨkɨra ɨngo jaachwe ja kɨtemi. Aho, maa akiikala ichuumbii raachwe ro lamʉrɨra akaanda lʉʉsɨka novo. ");
INSERT INTO lag_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Aho, vaantʉ vakaanda kʉmʉvaɨra siriri noo tʉla isóso voosea, “Ɨhɨ ɨsɨrɨ sawúti ya mʉʉntʉ tʉkʉ, ɨhɨ nɨ sawúti ya ʉmwɨ wa mɨlʉʉngʉ.” ");
INSERT INTO lag_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Na mpɨɨndɨ ˆvamʉdʉʉmbɨrɨráa jeyyo, Heróode sɨ amʉheera Mʉlʉʉngʉ nkongojima tʉkʉ. Haaho, murimʉ mʉʉja wa Ijʉva ʉkamʉvaa na ndwáala yo rɨɨwa nɨ vinyʉlʉlʉ, maa akakwya. ");
INSERT INTO lag_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Isáare ra Mʉlʉʉngʉ rɨkatuuba kweenera kwa vaantʉ, na vaantʉ ˆvamuruma Yéesu vakatuuba kɨɨngɨka mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barinába na Saúli ˆvakahʉmʉle mʉrɨmo waavo, vakiinʉka fuma Yerusaléemu, vakadoma na Antiókia. Na vajáa vatamanyanʼya na Yooháani irina rɨɨngɨ aanɨrɨrwáa Maáriki. ");
INSERT INTO lag_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ʉko Antiókia, mpukii ya vaantʉ ˆvamuruma Yéesu, kʉjáa kwatɨɨte valáali na mʉtwe na vakiindya ava, Barinába, Simeóoni ʉra ˆvamwaanɨrɨráa Nigéeri, Lukío fuma Kɨréene, Saúli na Maanaéeni ʉra ˆajáa arerwa hamwɨ na mʉtemi Heróode Antípaasi. ");
INSERT INTO lag_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mpɨɨndɨ ˆvamʉloombáa Mweenevyoosi ko kiirekya kurya, Mʉtɨma Mʉʉja akavasea, “Vakeri na ivarwii vala Barinába na Saúli sa mʉrɨmo ˆmweene navaanɨrɨra.” ");
INSERT INTO lag_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ˆVakahʉmʉle kʉmʉloomba Mʉlʉʉngʉ no kiirekya kurya, vakavavɨkɨra mɨkono vala Barinába na Saúli, maa vakavatʉma vatamanye. ");
INSERT INTO lag_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Vala Barinába na Saúli ˆvakatʉmwe nɨ Mʉtɨma Mʉʉja, vakagirita fʉʉrʉ múuji wa Seleúkia na aho vakaambʉka méeli fʉʉrʉ ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ˆɨséwaa Kúpuro. ");
INSERT INTO lag_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ˆVakafike múuji wa Salámisi, vakavariyʉla Masáare ya Mʉlʉʉngʉ masinagóogii ya Vayahúudi. Novo nɨ hamwɨ vajáa na Yooháani Maáriki mwaambiriryi waavo. ");
INSERT INTO lag_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Barinába na Saúli vayeenda ɨsɨ yoosi ˆyarɨɨngɨrɨrwa nɨ maaji ya Kúpuro mpaka vakafika múuji ʉmwɨ ˆʉséwaa Páafo. Ʉko vakalʉmana na Mʉyahúudi ʉmwɨ mʉsavɨ na mʉláali na mʉtwe wa ʉloongo. Ʉwo mʉʉntʉ irina raachwe noo Baari-Yéesu aséwaa. ");
INSERT INTO lag_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ʉhʉ mʉʉntʉ nɨ hamwɨ ajáa na Sárijo Paúli, mʉkʉ́ʉ́lʉ wa ɨsɨ ya Kúpuro, yeeye ajáa atɨɨte tooti maatʉkʉ vii. Ʉhʉ mʉkʉ́ʉ́lʉ akavateengya vala Barinába na Saúli, vatamanye na kwaachwe sa akateerere isáare ra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Maa kaa, Baari-Yéesu mʉsavɨ (irina raachwe ra Kɨgiríki noo Elíima asewáa) akiiruta ndihi na vala Barinába na Saúli. Akayera kʉbweeyya mʉtɨma wa ʉra mʉkʉ́ʉ́lʉ ʉfafe adɨɨre muruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Aho, maa Saúli ʉra irina rɨɨngɨ ˆaanɨrɨrwáa Paúli, kʉnʉ yoolongoolwa nɨ Mʉtɨma Mʉʉja, akamutuurirya miiso Elíima, maa akamʉsea, ");
INSERT INTO lag_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Weewe ʉrɨ mwaana wa Ikʉ́ʉ́lʉ ra Mirimʉ Mɨvɨ! Weewe ʉrɨ mʉvɨ wa ʉwoloki woosi! Wamema kɨra ʉvaangʉ na ʉkerema! Sa che sɨ wooreka kʉvalandʉla kɨkomi cha Mweenevyoosi no kɨbweeyya kɨve ʉloongo? ");
INSERT INTO lag_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Haaha Mweenevyoosi kʉheera arɨ irya. Kʉva ʉrɨ mʉhoku! Sɨ ʉrɨ koona kɨweerʉ cha mwaasʉ tʉkʉ, miiso dunga yarɨ du kwa mpɨɨndɨ.” Hahara, nkʉngʉʉ na kilwiirya kɨkamʉkʉnɨkɨrɨra Elíima miiswii, akareka koona, akaanda rɨɨngɨrɨra kʉsaakɨra mʉʉntʉ wo mʉkwaata mʉkono amʉlongoole. ");
INSERT INTO lag_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ʉra mʉkʉ́ʉ́lʉ ˆakoone yara ˆmeene yajáa yafʉ́mɨɨre, akamuruma Mweenevyoosi. Akahwaalala mʉnʉmʉʉnʉ sa ʉra ukiindya ˆajáa atéɨɨre wa Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paúli na viivaachwe vakiinʉka Páafo, vakatamanya fʉʉrʉ múuji wa Périge ˆʉrɨ ɨsɨ ya Pamufilía. Maa kaa, Yooháani Maáriki akavareka ʉko, akahɨndʉka fʉʉrʉ Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Novo vala Paúli na Barinába vakiinʉka Périge, vakatamanya fʉʉrʉ múuji wa Antiókia ˆʉrɨ ɨsɨ ya Pisídia. Sikʉ ya Sabáato ˆɨkafike, vakɨɨngɨra sinagóogii, maa vakiikala. ");
INSERT INTO lag_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mʉʉntʉ ʉmwɨ akasoma kɨtáabwii cha Miiro na masáarii ya valáali na mʉtwe. Aho, vakʉ́ʉ́lʉ va sinagóogi vakatʉma mʉʉntʉ avasee vala Paúli na Barinába, “Arumi, koonɨ mʉrɨ na isáare roroosi ro vawyɨɨra vaantʉ sa mɨtɨma yaavo ɨve na ngururu, teengi mʉlʉʉse.” ");
INSERT INTO lag_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paúli akiinʉka, maa akiinurirya mʉkono sa vamʉteerere akasea, “Nyuunyu vaantʉ valʉme va Isiraéeli na nyuunyu vaantʉ voosi sɨ ˆmʉrɨ Vayahúudi ˆmʉmʉnyémyaa Mʉlʉʉngʉ, teereri! ");
INSERT INTO lag_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mʉlʉʉngʉ wiitʉ suusu Viisiraéeli noo avasaawʉla vala baaba wiitʉ, mpɨɨndɨ ˆviikaláa ɨsɨ ya ʉyenii ʉko Mísiri, akavabweeyya vave lʉkolo lʉkʉʉlʉ mʉnʉmʉʉnʉ. Sikʉ ˆjikalooke, akavalongoola, akavaseyya fuma Mísiri kwa ngururu jaachwe nkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kwa myaaka makumi yanɨ (40) akavayimirirya ʉko ɨsɨ ya ibaláángʉ. ");
INSERT INTO lag_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Akamala ɨsɨ mufungatɨ ʉko ɨsɨ ya Kanáani, maa akavaheera vala baaba wiitʉ ɨyo ɨsɨ ɨve yaavo. ");
INSERT INTO lag_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Masáare aya yoosi yatʉmamwa kwa myaaka magana yanɨ na makumi yasaano (450). Sikʉ ˆjikaseese, Mʉlʉʉngʉ akavaheera vala baaba wiitʉ valamuli vo valongoola fʉʉrʉ mpɨɨndɨ ja Samwéeli mʉláali na mʉtwe avɨɨmɨrɨráa. ");
INSERT INTO lag_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Aho, maa vakaloomba vave na mʉtemi. Mʉlʉʉngʉ akavaheera Saúli mwaana wa Kíisi wa lʉkolo lwa Bénjamini ave mʉtemi kwa myaaka makumi yanɨ (40). ");
INSERT INTO lag_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mʉlʉʉngʉ ˆakamʉseyye Saúli ʉtemii, akamʉhaka makuta Daúdi sha Yéese ave mʉtemi. Mʉlʉʉngʉ amoonekya kɨkomi Daúdi yoosea, ‘Namwɨɨ́ne Daúdi sha Yéese, eériirye mʉtɨma waanɨ, kei noo ˆmweene arɨ tʉmama yoosi ˆnoosaaka yatʉmamwe.’ ");
INSERT INTO lag_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kufuma lʉkolwii lwa Daúdi noo kʉʉntʉ Mʉlʉʉngʉ ˆavaretera Viisiraéeli Mʉlamuriri Yéesu, ja ˆvyeene ajáa iichuunga kʉvaretera arɨ. ");
INSERT INTO lag_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mpɨɨndɨ Yéesu ˆajáa akaarɨ kwaanda mʉrɨmo waachwe, Yooháani avavariyʉrɨráa Viisiraéeli vavalandʉke fuma uvii waavo na vabatisiwe. ");
INSERT INTO lag_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mpɨɨndɨ Yooháani ˆamarikiriryáa mɨrɨmo yaachwe, akavasea, ‘Mookisea nɨɨnɨ ndɨrɨ ani? Nɨɨnɨ sɨ ndɨrɨ ʉra Masía ˆmweene moomʉwoojera tʉkʉ. Teereri! Ʉwo ˆmweene arɨ kʉʉja nyuma yaanɨ, nɨɨnɨ sɨ nɨɨma neeja kʉtʉmama mʉrɨmo wa mʉtʉ́mwa wo reherya nkoorisa ja mirunkumo majewii yaachwe tʉkʉ!’ ");
INSERT INTO lag_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Arumi, nyuunyu vanaviitʉ vaantʉ va lʉkolo lwa Aburaháamu, na nyuunyu vaantʉ sɨ ˆmʉrɨ Vayahúudi ˆveene mʉmʉnyémyaa Mʉlʉʉngʉ, suusu noo masáare aya ya ʉlamuriri ˆyatʉʉjɨra fuma kwa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Sa viintʉ vaantʉ va Yerusaléemu na vakʉ́ʉ́lʉ vaavo sɨ vataanga Yéesu tʉkʉ, vakabweeyya aheewe irya ro kʉʉlawa. Baa neembe vasomáa masáare yaachwe ˆyaandɨkwa vitáabwii vya valáali na mʉtwe kɨra sikʉ ya Sabáato, voovo vayakiimikirirya ko mʉbweeyyirya jeyyo. ");
INSERT INTO lag_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Baa neembe vajáa vasiina isáare roroosi ra kɨmáárɨ ˆroonekyáa Yéesu alamʉrɨrwe inkwya, voovo vamʉloomba Piláato alairirye ʉʉlawe. ");
INSERT INTO lag_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ˆVakahʉmʉle kɨra kɨɨntʉ ˆchalʉʉswa nɨ valáali na mʉtwe kʉrɨ Yéesu, vakamukiimya fuma mʉsaláabii, maa vakamʉvɨɨka mbiríírii. ");
INSERT INTO lag_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Maa kaa, Mʉlʉʉngʉ akamʉfʉfʉla. ");
INSERT INTO lag_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yeeye avafʉ́mɨraa vaantʉ vara ˆvayeendanʼyáa ne kufuma Galiláaya fʉʉrʉ Yerusaléemu. Ava noo vara vaantʉ vaachwe ˆvoona, kwa vaantʉ va Isiraéeli. ");
INSERT INTO lag_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Suusu tuújire na aha, kʉjoovavariyʉrɨra Masáare Maaja Mʉlʉʉngʉ ˆiichuunga kwa vala baaba wiitʉ. ");
INSERT INTO lag_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Yeeye ayakiimikirirya kʉrɨ suusu vajʉkʉlʉ vaavo kwa njɨra yo mʉfʉfʉla Yéesu, ja ˆvyeene vyaandɨkwa Sabúurii ya kavɨrɨ, ‘Weewe nɨ Mwaana waanɨ, isikʉ nɨɨnɨ navɨ́ɨre Taáta waako.’ ");
INSERT INTO lag_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Mʉlʉʉngʉ amʉfʉfʉla Yéesu sa adɨɨre kukwya vii kaa kei. Sa aya Mʉlʉʉngʉ alʉʉsa jei, ‘Namwiilaha Daúdi ntálarya ja kɨkomi. Ntálarya ijo, noo ˆngʼeene ndɨrɨ vaheera nyuunyu.’ ");
INSERT INTO lag_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Isáare ɨrɨ ralʉʉsa haantʉ hɨɨngɨ, ‘Sɨ ʉrɨ mʉreka tʉkʉ Mʉʉja waako oole.’ ");
INSERT INTO lag_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Haaha Daúdi ajáa akiimanʼya kɨra Mʉlʉʉngʉ ˆasaakáa kwa mpɨɨndɨ ja mbyaala yaachwe, akakwya, akataahwa heehi na vala baaba waavo na mʉvɨrɨ waachwe ʉkoola. ");
INSERT INTO lag_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Maa kaa, ʉra ˆmweene Mʉlʉʉngʉ amʉfʉfʉla, yeeye sɨ oola tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Vanaviitʉ, teereri neeja aya ˆmeene toovawyɨɨra! Nɨ kʉvawyɨɨra tiise kwa njɨra ya Yéesu, mwavariyʉrɨrwa kusira kwa ʉvɨ. ");
INSERT INTO lag_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kwa Yéesu vii, kɨra mʉʉntʉ ˆamuruma, avalwa nɨ mʉwoloki mbere ya Mʉlʉʉngʉ, isáare ɨrɨ sɨ mʉrɨ daha tʉkʉ ko tuuba Miiro ya Mʉ́sa. ");
INSERT INTO lag_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mʉlaange neeja, karɨ lo mʉkwaatwe nɨ aya masáare ˆyaandɨkwa vitáabwii vya valáali na mʉtwe tʉkʉ, ");
INSERT INTO lag_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nyuunyu ˆmuchwíjaa matɨ, laangi! Mʉhwaalale, mʉmalwe imalo. Sa kɨɨntʉ ˆnoobweeyya mpɨɨndɨ jaanyu, nɨ kɨɨntʉ sɨ ˆmʉrɨ kiruma, baa mʉwyɨɨrwe nɨ mʉʉntʉ.’” ");
INSERT INTO lag_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mpɨɨndɨ Paúli na Barinába ˆvafumáa hara sinagóogii, vaantʉ vakavakalaamya vahɨndʉke kei sikʉ ya Sabáato ˆɨtʉ́ʉbɨrɨɨre na valʉʉse kei yara masáare. ");
INSERT INTO lag_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mwiijiingo wa sinagóogii ˆʉkasire, Vayahúudi ˆvarɨ foo na vaantʉ vɨɨngɨ vara ˆvatuubáa díini ya Kɨyahúudi kumwiinamɨra Mʉlʉʉngʉ, vakavatuuba vala Paúli na Barinába, novo vakalʉʉsɨka novo na vakavaheera mɨtɨma vatuube kʉkwaatɨrɨra nduwo ya Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabáato ˆɨtʉ́ʉbɨrɨɨre, sengerera vaantʉ voosi va ʉra múuji vajáa vʉʉja noo teerera isáare ra Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Maa kaa, Vayahúudi ˆvakoone vaantʉ ˆvarɨ foo mʉnʉmʉʉnʉ vaviijɨ́ɨngɨrɨɨre vala Paúli na Barinába, vakaanda koona kɨvɨna mʉnʉmʉʉnʉ. Aho, vakaanda kwiiruta ndihi na vala Paúli na vakavatʉkɨra. ");
INSERT INTO lag_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hahara, vala Paúli na Barinába vakalʉʉsɨka ko kiitema mʉnʉmʉʉnʉ, voosea, “Vijáa vyabooha, isáare ra Mʉlʉʉngʉ rɨvariyʉlwe ta kʉrɨ nyuunyu Vayahúudi. Maa kaa, sa viintʉ mwarisíitire ɨro isáare, kei mwiilámʉrɨɨre sɨ mwɨɨma neeja muturye nkaasʉ ya sikʉ ˆjisiina ʉhero tʉkʉ, haaha suusu tavarékire na domerera tʉrɨ na kwa vaantʉ sɨ ˆvarɨ Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sa Yéesu Mweenevyoosi atʉlairirya jei, ‘Nakʉvɨɨka weewe ʉve kɨweerʉ kwa vaantʉ sɨ ˆvarɨ Vayahúudi, sa ʉreete ʉlamuriri kwa vaantʉ fʉʉrʉ utulo waasɨ.’” ");
INSERT INTO lag_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Vaantʉ sɨ ˆvarɨ Vayahúudi ˆvakateere ayo masáare, maa vakavyeenda maatʉkʉ vii, vakaribweeyyirya nkongojima isáare ra Mweenevyoosi. Na voosi ˆvajáa vasaawʉlwa kʉva na nkaasʉ ya sikʉ ˆjisiina ʉhero, vakamuruma Yéesu Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jeyyo, isáare ra Mweenevyoosi Yéesu rɨkeenera ɨsɨ ɨyo yoosi. ");
INSERT INTO lag_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Maa kaa, Vayahúudi vakavasoonka vaantʉ vaki ˆvamwiínamɨraa Mʉlʉʉngʉ na ˆvanyemiwáa nɨ vaantʉ, na vaantʉ valʉme vakʉʉlʉ va ʉwo múuji. Vakavasoonka vaantʉ vaande kʉvaturikirya vala Paúli na Barinába, maa vakavakibirya fuma ɨsɨ yaavo. ");
INSERT INTO lag_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Aho, vala Paúli na Barinába vakiikonkoma marʉrɨ majewii yaavo koonekya kusiita kwa vara vaantʉ, maa vakadoma na múuji wa Ikonío. ");
INSERT INTO lag_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Maa kaa, vaantʉ ˆvamuruma Yéesu ʉko vakeerya mɨtɨma na vakatuuba kʉlongoolwa nɨ Mʉtɨma Mʉʉja. ");
INSERT INTO lag_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ʉko múujii wa Ikonío, Paúli na Barinába vakɨɨngɨra sinagóogi ja ˆvyeene viijʉvɨra. Vakavariyʉla Masáare Maaja ya YéesuKirisitʉ. Vayahúudi na vaantʉ sɨ ˆvarɨ Vayahúudi ˆvarɨ foo mʉnʉmʉʉnʉ vakamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Maa kaa, Vayahúudi ˆveene sɨ vajáa vamuruma Yéesu, vakavasoonka na vakavakalarya vaantʉ sɨ ˆvarɨ Vayahúudi vaviihye mɨtɨma kwa vaaniitʉ. ");
INSERT INTO lag_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Baa neembe nɨ jeyyo, Paúli na Barinába vakiikala sikʉ ˆjiri foo ʉko Ikonío, vandoovoonekya kɨkomi vaantʉ Masáare ya nduwo ya Mweenevyoosi ko kiitema. Ne Mweenevyoosi abweeyya jeyyo, ko bweeyya vadahe tʉmama isháara na viintʉ ˆvihwáalaryaa. ");
INSERT INTO lag_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Vaantʉ va ʉra múuji vakiikera. Vɨɨngɨ vakavatuuba Vayahúudi na vɨɨngɨ vakavatuuba vatumwi va Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Maa reerʉ, Vayahúudi, hamwɨ na vaantʉ sɨ ˆvarɨ Vayahúudi na vakʉ́ʉ́lʉ vaavo vakiirʉmɨra kʉvabweeyyirya ʉvɨ no vavaa na mawye vala Paúli na Barinába. ");
INSERT INTO lag_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Maa kaa, vala Paúli na Barinába vakataanga ɨyo mɨryʉʉngʉ, vakatɨjɨra na ɨsɨ ya Lukonía, ʉko vakadoma na míiji ya Lísitra na Déribe na míiji yɨɨngɨ ˆɨrɨ mʉkaaya. ");
INSERT INTO lag_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Na ʉko, vavavariyʉrɨráa vaantʉ Masáare Maaja. ");
INSERT INTO lag_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ʉko Lísitra, kwajáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆajáa kɨvete keende kʉvyaalwa kwaachwe. Majeo yaachwe sɨ yajáa yanalwaatya baa sikʉ ɨmwɨ vii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mpɨɨndɨ Paúli ˆalʉʉsɨkáa, ʉwo mʉʉntʉ akava yoomʉteerera. Paúli akamutuurirya miiso ʉra mʉʉntʉ, maa akoona kuruma kwaachwe nɨ ko mʉhorya. ");
INSERT INTO lag_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paúli akalʉʉsa na ngururu, “Inʉka! Wɨɨme na majeo yaako!” Hara, maa ʉra mʉʉntʉ akɨɨma chaangʉ, akaanda yeenda yeemweene. ");
INSERT INTO lag_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Vaantʉ ˆvakoone kɨra Paúli ˆajáa abwéeyyiirye kwa ʉra mʉʉntʉ, maa vakaanda tʉla isóso kwa ndʉʉsɨka ya kɨmeevo ya Kɨlukonía voosea, “Mɨlʉʉngʉ yakíimire na kʉrɨ suusu ɨrɨ ja vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barinába vakamwaanɨrɨra irina ra mʉlʉʉngʉ waavo ˆaséwaa Séeu. Na sa viintʉ Paúli noo ˆalʉʉsɨkáa, vakamwaanɨrɨra Hérime. ");
INSERT INTO lag_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Weerwii ya ʉwo múuji kʉjáa kwatɨɨte kaaya yo mʉloomba Séeu. Mweeneɨsɨ wa Séeu wa ɨyo kaaya, akareeta makabaako ya ngʼoombe na matáaji na mutiryaangwii wa múuji. Ʉwo mweeneɨsɨ hamwɨ na vaantʉ vɨɨngɨ vasaakáa kʉvasɨɨnjɨra ngʼoombe ja mpóryo vala Paúli na Barinába. ");
INSERT INTO lag_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Maa kaa, vatumwi Paúli na Barinába ˆvakateere ayo, vakamoola ɨngo jaavo kwa ʉsʉʉngʉ. Vakatɨɨja, maa vakɨɨta koo saangɨrɨra na vaantʉ, aho, vakalʉʉsɨka na ngururu voosea, ");
INSERT INTO lag_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ee arumi, sa che moobweeyya jei? Arumi, suusu nɨ vaantʉ vii ja nyuunyu! Tuújire na aha jo vavariyʉrɨra Masáare Maaja, mʉreke kwiinamɨra mɨlʉʉngʉ ˆisiina kɨɨntʉ, mʉve vaantʉ va Mʉlʉʉngʉ ˆArɨ Nkaasʉ. Yeeye ʉʉmba kurumu na weerʉ, mayɨya, na viintʉ vyoosi ˆviri mʉʉmo. ");
INSERT INTO lag_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Aho mbere, ajáa avareka nyuunyu vaantʉ va ɨsɨ joosi mwiikale ja ˆvyeene moosaaka veeneevyo. ");
INSERT INTO lag_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Baa neembe nɨ jeyyo, Mʉlʉʉngʉ sɨ areka kʉvalaɨra nɨ novo arɨ tʉkʉ. Yeeye atuuba kʉvabweeyyirya wʉʉja, kwa njɨra yo vaheera nyuunyu mbula, sa muchwe kwa mpɨɨndɨ joojo na mʉve na chákurya cho keenererya na mɨtɨma yaanyu ɨve na cheerʉ.” ");
INSERT INTO lag_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Baa neembe vala Paúli na Barinába vajáa valʉʉsa ayo masáare, vijáa vyafafa kʉvakaanʼya vareke toola mpóryo yo chɨmɨka kwaavo. ");
INSERT INTO lag_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mpɨɨndɨ kiduudi, vakʉʉja Vayahúudi fuma múuji wa Antiókia na Ikonío. Vakavaheemba vaantʉ vave ivarwii raavo, vakamʉvaa Paúli na mawye, maa vakamurutya na weerwii ya múuji sa viiseáa akwíire. ");
INSERT INTO lag_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Maa kaa, vaantʉ ˆvamuruma Yéesu ˆvakamʉrɨɨngɨrɨre, akiinʉka, akahɨndʉka na múujii. ˆKʉkeere, akiinʉka aho, akadomanʼya na Barinába fʉʉrʉ múuji wa Déribe. ");
INSERT INTO lag_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ʉko Déribe, Paúli na Barinába vavavariyʉrɨráa vaantʉ Masáare Maaja, vaantʉ ˆvarɨ foo vakamuruma Yéesu. Sikʉ ˆjikaseese, vakahɨndʉka na Lísitra, Ikonío na Antiókia. ");
INSERT INTO lag_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Na kɨra haantʉ ˆvadomáa, vavakalaamyáa vaantʉ ˆvamuruma Yéesu vabweeyye mɨtɨma yaavo ɨve na ngururu yo muruma Yéesu. Vavaseáa, “Kwɨɨngɨra Ʉtemii wa Mʉlʉʉngʉ, nɨ mpaka tʉpate uturikiri ˆʉrɨ foo.” ");
INSERT INTO lag_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na ʉko kʉʉntʉ ˆvatweeráa, vasaawʉláa vawosi viimiriri va mpuka ya vaantʉ ˆvamuruma Yéesu kɨra haantʉ. Na vabweeyyáa jeyyo ko vavɨɨka kwa Mweenevyoosi ʉhʉ ˆvamuruma, ko loomba no kwiirekya kurya. ");
INSERT INTO lag_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Aho, vakatweera na ɨsɨ ya Pisídia, vakɨɨta fʉʉrʉ ɨsɨ ya Pamufilía. ");
INSERT INTO lag_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ʉko, vakavariyʉla isáare ra Mʉlʉʉngʉ múujii wa Périge, maa vakatamanya na múuji wa Atalía. ");
INSERT INTO lag_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Fuma Atalía vakaambʉka méeli vakatamanya fʉʉrʉ Antiókia ya Síria. Aho, noo kʉʉntʉ vaantʉ ˆvamuruma Yéesu vajáa vavakwaatya vala Paúli na Barinába kʉrɨ nduwo ya Mʉlʉʉngʉ, sa mʉrɨmo ˆvajáa vamárikiirye. ");
INSERT INTO lag_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ˆVakafike ʉko Antiókia, vakajiinga mpuka ya vaantʉ ˆvamuruma Yéesu. Aho, vakavawyɨɨra yoosi ˆmeene Mʉlʉʉngʉ ajáa atʉmama ko tweera kʉrɨ voovo, ˆvyeene Mʉlʉʉngʉ ajáa avayʉʉrɨra mʉryaango vara sɨ ˆvarɨ Vayahúudi kumuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Aho, vakiikala sikʉ ˆjiri foo hamwɨ na vaantʉ ˆvamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Haaha, vaantʉ vamwɨ fuma Yudéea, vakatamanya na Antiókia. Ʉko vakaanda vavariyʉrɨra vaaniitʉ voovasea, “Koonɨ mʉʉntʉ sɨ atwáarirwe na kɨbawii ja ˆvyeene tʉʉva ja Mʉ́sa jalʉʉsa, sɨ arɨ lamuririwa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paúli na Barinába vakavasɨɨtɨra ngʼangʼala ʉvariyuli waavo. Jeyyo, vaantʉ ˆvamuruma Yéesu vakavasaawʉla Paúli na Barinába na vaantʉ vɨɨngɨ fuma avo ˆvamuruma Yéesu, sa vaambʉke na Yerusaléemu vakalʉmane na vatumwi va Yéesu na vawosi, sa vakamarikirye ɨrɨ isáare. ");
INSERT INTO lag_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jeyyo, vakatʉmwa nɨ mpuka ya vaantʉ ˆvamuruma Yéesu, vadome na Yerusaléemu. Njirii, vakatweera na ɨsɨ ja Foiníike na Samaría. Ʉko vakavawyɨɨra vaantʉ ˆvamuruma Yéesu masáare ya vaantʉ sɨ ˆvarɨ Vayahúudikʉvalandʉka na kʉrɨ Yéesu. Ayo masáare yakaveerya mɨtɨma maatʉkʉ vii vaaniitʉ voosi. ");
INSERT INTO lag_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paúli na viivaachwe ˆvakafike Yerusaléemu, vakateengiwa vyabooha nɨ vatumwi va Yéesu, vawosi na mpuka ya vaantʉ ˆvamuruma Yéesu. Aho, vala Paúli vakavawyɨɨra yoosi Mʉlʉʉngʉ ˆajáa atʉmama ko tweera kʉrɨ voovo. ");
INSERT INTO lag_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Aho, maa mpuka ɨmwɨ ya Mafarisáayo ˆveene vajáa vamuruma Yéesu vakɨɨma, vakasea, “Vaantʉ voosi sɨ ˆvarɨ Vayahúudi, voosaakwa vatwaalwe na kɨbawii na vatuube Miiro ya Mʉ́sa.” ");
INSERT INTO lag_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Sa jeyyo, vatumwi na vawosi, vakalʉmana hamwɨ sa vatamanʉle ɨrɨ isáare. ");
INSERT INTO lag_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ˆVakalʉme sáare kwa mpɨɨndɨ nkʉʉlʉ, Peéteri akɨɨma, maa akavasea, “Vanaviitʉ, mʉmányire Mʉlʉʉngʉ aansaawʉla fuma kʉrɨ nyuunyu sa nkavariyʉle Masáare Maaja kwa vaantʉ sɨ ˆvarɨ Vayahúudi, vateere ko tweera nɨɨnɨ na vamurume Yéesu Kirisitʉ Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mʉlʉʉngʉ amányire yoosi ˆmeene yarɨ mitimii ya vaantʉ. Yeeye oónekiirye avahokera vaantʉ sɨ ˆvarɨ Vayahúudi kwa njɨra yo vaheera Mʉtɨma Mʉʉja ja ˆvyeene atʉheera suusu. ");
INSERT INTO lag_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sa viintʉ kusiina usinanali wowoosi Mʉlʉʉngʉ ˆabweeyya kʉrɨ suusu na kwaavo, yeeye ajirʉla mɨtɨma yaavo ko muruma Yéesu Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Haaha sa che moosaaka kʉmʉyera Mʉlʉʉngʉ ko vaverekya vaantʉ ˆvamuruma Yéesu muriwa ʉhʉ wo tuuba Miiro vala baaba wiitʉ na suusu ˆtasiindwa kwiituuba? ");
INSERT INTO lag_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Maa kaa, suusu taruma nɨ kwa nduwo ya Yéesu Mweenevyoosi tʉrɨ lamuririwa, na baa voovo nɨ viivyo.” ");
INSERT INTO lag_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ˆAkalʉʉse jeyyo, maa vaantʉ voosi vakakirinya sawu, voovateerera Paúli na Barinába viintʉ ˆvalʉʉsáa masáare makʉʉlʉ ya isháara, na viintʉ ˆvihwáalaryaa Mʉlʉʉngʉ ˆabweeyya ko tweera kʉrɨ voovo kwa vaantʉ sɨ ˆvarɨ Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ˆVakahʉmʉle kʉlʉʉsɨka, maa Yaakúupu akavasea, “Vanaviitʉ nteereri! ");
INSERT INTO lag_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simóoni alúusire kʉrɨ suusu, ˆvyeene Mʉlʉʉngʉ iisaawʉrɨra lwa ncholo vaantʉ vamwɨ sɨ ˆvarɨ Vayahúudi, sa vave vaantʉ vaachwe. ");
INSERT INTO lag_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Masáare ya valáali na mʉtwe, yadómanʼyaa na isáare ɨrɨ ja ˆvyeene vyaandɨkwa, ");
INSERT INTO lag_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Aya ˆyarɨ looka, hɨndʉka ndɨrɨ, jeenga ndɨrɨ kei nyuumba ya mʉtemi Daúdi ˆngʼeene yaawya. Jeenga ndɨrɨ ihaáma raachwe na kuriimya ndɨrɨ. ");
INSERT INTO lag_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Sa jeyyo, vaantʉ vɨɨngɨ voosi vara ˆvarɨ chaala vadahe kʉmʉsaakɨra Ijʉva, baa na vaantʉ sɨ ˆvarɨ Vayahúudi, navaánɨrɨɨre kwa irina raanɨ,’ alúusire Ijʉva. Yeeye abweeyya ");
INSERT INTO lag_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","aya yoosi yataangɨkane keende aho kalɨ. ");
INSERT INTO lag_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Sa jeyyo, kɨɨntʉ ˆnalámwɨɨre nɨ ɨkɨ, tʉreke kʉvahinisha vaantʉ sɨ ˆvarɨ Vayahúudi ˆveene vamʉválandʉkɨɨre Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kɨrɨ vyoova jeyyo, tʉvaandɨkɨre barʉ́wa tʉvasee, karɨ varíjaa nyama ˆɨrɨ na njeo ˆɨtwɨ́ɨrwe kwa vidabalaíyo tʉkʉ, karɨ vahángutaa tʉkʉ, karɨ varíjaa nyama ˆyakuvwa tʉkʉ na karɨ varíjaa sakami tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sa keende aho kalɨ, voovo vavariyʉláa Miiro ya Mʉ́sa míijii yoosi, sa vɨɨsomáa masinagóogii sikʉ joosi ja Sabáato.” ");
INSERT INTO lag_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Aho, maa vatumwi, vawosi na mpuka yoosi ya vaantʉ ˆvamuruma Yéesu ʉko Yerusaléemu vakalamʉla hamwɨ, vakavasaawʉla vamwɨ va vaantʉ vaavo ˆveene varɨ domanʼya na Paúli na Barinába na ʉko Antiókia. Vakavasaawʉla valongooli vavɨrɨ, ʉmwɨ Yʉ́ʉda irina raachwe rɨɨngɨ nɨ Barisába, na wɨɨngɨ Síila, fuma kʉrɨ vaaniitʉ. ");
INSERT INTO lag_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Vakavatʉma na barʉ́wa ɨhɨ, “Kufuma kwa vatumwi na vawosi, noo kʉsea suusu vandʉʉ vaanyu ˆtamuruma Yéesu, toovaluumbya nyuunyu vanaviitʉ ˆmʉsɨrɨ Vayahúudi, ˆmwiíkalaa múuji wa Antiókia, ɨsɨ ja Síria na Kilikía. ");
INSERT INTO lag_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tatéɨɨre vamwaarɨ vamwɨ viiswi ˆvafuma aha, vakʉʉja nooko noo jo vawyɨɨra masáare yo vaturikirya, baa mɨtɨma yaanyu yasóvire mpɨɨma, maa kaa, sɨ suusu tavatʉma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Sa teériiwe mɨtɨma, twiirʉ́mɨɨre na tavasáawɨɨre vaantʉ ˆtʉrɨ vatʉma kwaanyu, vʉʉje hamwɨ na ava vijeengi viiswi ˆtaveenda vala Paúli na Barinába. ");
INSERT INTO lag_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ava vatoola nkaasʉ yaavo so mʉtʉmamɨra Mweenevyoosi wiitʉ, Yéesu Kirisitʉ. ");
INSERT INTO lag_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Haaha tavatúmire vala Yʉ́ʉda na Síila, sa vavawyɨɨre masáare aya ˆtʉvaándɨkɨɨre. ");
INSERT INTO lag_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sa vyamweériirye Mʉtɨma Mʉʉja na suusu, tʉreke kʉvaverekya miriwa mɨkʉʉlʉ, maa kaa, mutuube viintʉ ivi, ");
INSERT INTO lag_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","mʉreke kurya chóorya ˆkɨtwɨ́ɨrwe ntambɨko kwa vidabalaíyo, mʉreke kurya sakami, au nyama ˆikúvirwe na kei mʉreke kʉhanguta. Koonɨ mʉrékire aya, bweeyya mʉrɨ vyabooha. Mukiikala nkaasʉ.” ");
INSERT INTO lag_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Avo vaantʉ vanɨ ˆvakasuukye, maa vakakwaata njɨra na Antiókia. Ʉko vakavaanɨrɨra vaantʉ voosi ˆvamuruma Yéesu, maa vakavaheera ɨra barʉ́wa. ");
INSERT INTO lag_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ˆVakɨɨsome ɨra barʉ́wa, vakavyeenda maatʉkʉ vii sa ɨjáa yavaheera mɨtɨma. ");
INSERT INTO lag_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yʉ́ʉda na Síila nɨ valáali na mʉtwe va Ijʉva vajáa, vakalʉʉsa masáare ˆyarɨ foo yo vaheera mɨtɨma no vabweeyya vɨɨme neeja avo vaaniitʉ. ");
INSERT INTO lag_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ˆVakiikale kwa mpɨɨndɨ, vaaniitʉ vakavarekera vahɨndʉke voovasea, “Hinduki na mwiikalo mʉʉja kwa vara ˆvavatʉma.”  ");
INSERT INTO lag_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Maa kaa, Síila akoona vyabooha achaale kʉkʉra. ");
INSERT INTO lag_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paúli na Barinába vakachaala ʉko Antiókia, vookiindya no variyʉla isáare ra Mweenevyoosi na vaantʉ vɨɨngɨ ˆvarɨ foo. ");
INSERT INTO lag_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Sikʉ ˆjikaseese, Paúli akamʉsea Barinába, “Tʉhɨndʉke na míijii yoosi kʉʉntʉ ˆtavariyʉla isáare ra Mweenevyoosi, sa tʉlaange vaaniitʉ na toone ˆvyeene voodomerera na kʉra kumuruma Yéesu.” ");
INSERT INTO lag_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barinába asaakáa vatamanyanʼye na Yooháani ˆaséwaa Maáriki. ");
INSERT INTO lag_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Maa kaa, Paúli akasea, “Sɨ ɨɨma neeja kʉtamanyanʼya na suusu tʉkʉ,” sa viintʉ Yooháani Maáriki ajáa avatɨɨja kʉra Pamufilía, na akasiita tuuba tʉmamanʼya novo. ");
INSERT INTO lag_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Aho, Paúli na Barinába vakiiruta ndihi kwa ʉkarɨ maatʉkʉ vii fʉʉrʉ vakiitamanʉla. Barinába akamʉsʉmʉla Maáriki, vakaambʉka méeli, maa vakadomanʼya na Kúpuro. ");
INSERT INTO lag_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paúli akamʉsaawʉla Síila. Vaaniitʉ vakamʉloomba Yéesu Mweenevyoosi avaheere nduwo, maa Paúli na Síila vakakwaata njɨra. ");
INSERT INTO lag_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Vakakwaata na ɨsɨ ya Síria na Kilikía na ʉko vavaheeráa mɨtɨma mpuka ja vaantʉ ˆvamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paúli na Síila vakayeenda fʉʉrʉ múuji wa Déribe na Lísitra. Ʉko Lísitra, kʉjáa kwatɨɨte mʉʉntʉ ˆiikaláa ʉko, ˆasewáa Timotéeo. Timotéeo ajáa amuruma Yéesu. Íyo waala Timotéeo nɨ Mʉyahúudi ajáa na ajáa amuruma Yéesu, maa kaa, taáta waavo nɨ Mugiríki ajáa. ");
INSERT INTO lag_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Vaaniitʉ ʉko Lísitra na Ikonío vamʉdʉʉmbáa Timotéeo sa mɨryʉʉngʉ yaachwe miija. ");
INSERT INTO lag_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paúli asaakáa andooyeendanʼya na Timotéeo, sa jeyyo, akamʉtwaala Timotéeo na kɨbawii sa Vayahúudi ˆveene viikaláa ʉko kʉʉntʉ vajáa vamʉmányire taáta waavo nɨ Mugiríki. ");
INSERT INTO lag_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na mpɨɨndɨ ˆvatweereráa na kɨra múuji, vavaheeráa vaaniitʉ ʉlamuli ˆʉjáa wavɨɨkwa nɨ vatumwi va Yéesu na vawosi ˆvamuruma Yéesu va Yerusaléemu. Na vavaseáa vatuube ʉwo ʉlamuli. ");
INSERT INTO lag_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jeyyo, mpuka ja vaantʉ ˆvamuruma Yéesu vakava na ngururu ya kuruma kwaavo na vakɨɨngɨkáa kɨra siikʉ. ");
INSERT INTO lag_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paúli na viivaachwe vakakwaata lʉyeendo fʉʉrʉ ɨsɨ ja Firigía na Galatía sa Mʉtɨma Mʉʉja ajáa avakáaniirye vareke variyʉla Masáare ˆYarɨ Mpeho ɨsɨ ya Ásia sikʉ ijo. ");
INSERT INTO lag_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ˆVakafike mʉhakii wa ɨsɨ ya Mísia, vasaakáa vɨɨngɨre na ɨsɨ ya Bisínia, baa ʉko Mʉtɨma wa Yéesu akavakaanʼya. ");
INSERT INTO lag_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Sa jeyyo, vakakwaata na ɨsɨ ya Mísia, vakadoma na múuji wa Turóoa. ");
INSERT INTO lag_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Uchikʉ ʉwo, Paúli akoona njori. Aho njorii, akoona mʉʉntʉ fuma ɨsɨ ya Makedonía iímire nyambʉko yookiiloombererya yoosea, “Mentʉka na kʉnʉ Makedonía jɨ ʉtwaambirirye.” ");
INSERT INTO lag_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paúli ˆakoone ɨyo njori, hahara tukiimya neeja lʉyeendo lo doma na Makedonía, sa tʉjáa twataanga Mʉlʉʉngʉ atwaánɨrɨɨre tʉkavavariyʉrɨre vara vaantʉ Masáare Maaja. ");
INSERT INTO lag_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kufuma Turóoa tʉkaambʉka méeli, tukiinʉka, maa tʉkadomerera fʉʉrʉ ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ˆɨséwaa Samosiráake. Lomʉtóondo yaachwe tʉkafika múuji wa Neopóoli. ");
INSERT INTO lag_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Aho, tʉkɨɨreka méeli, maa tʉkakwaata njɨra fʉʉrʉ Filíipi, múuji mʉkʉʉlʉ wa ɨsɨ ya Makedonía. Ɨhɨ ɨsɨ yɨɨmɨrɨrwáa nɨ Varúumi. Aho, tukiikala kwa sikʉ nke. ");
INSERT INTO lag_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sikʉ ya Sabáato, tʉkafuma na weerwii ya múuji, maa tʉkadoma na mbarɨmbarɨ ya iboote ˆriíkaa maaji. Tʉjáa twiiséire turya tʉrɨ haantʉ vaantʉ ˆvamwiínamɨraa Mʉlʉʉngʉ. Ʉko, tukiikala, maa tʉkaanda lʉʉsɨka na vaantʉ vaki ˆvajáa viijíingire aho. ");
INSERT INTO lag_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Na ʉmwɨ wa vara ˆvatʉteereráa nɨ mʉʉntʉ muki ʉmwɨ fuma múuji wa Siatíira, irina raachwe noo Lídia asewáa. Yeeye amwiinamɨráa Mʉlʉʉngʉ. Na mʉrɨmo waachwe ˆatʉmamáa nɨ wo vaa iyoombe ɨngo ˆjiri gyaa. Paúli ˆakaande variyʉla Masáare Maaja, Yéesu Mweenevyoosi akakʉndʉkʉla mʉtɨma wa Lídia, maa akamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lídia na nyuumba yaachwe ˆvakabatisiwe, akatʉloomba maatʉkʉ vii tʉdome na kwaachwe yoosea, “Koonɨ mwɨɨ́ne namurúmire Mweenevyoosi, hendi na kaayii kwaanɨ.” Akiiloombererya mpaka tʉkaruma. ");
INSERT INTO lag_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sikʉ ɨmwɨ mpɨɨndɨ ˆtadomáa na kʉʉntʉ vaantʉ ˆvalʉ́manɨraa so mwiinamɨra Mʉlʉʉngʉ, akʉʉja muhíínja ʉmwɨ mʉtʉ́mwa. Ʉwo muhíínja ajáa atɨɨte murimʉ mʉvɨ. Murimʉ mʉvɨ ʉwo, wamʉheeráa lʉvɨro lo vaa mbare ya masáare ˆyarɨ fʉmɨra sikʉ ˆjookʉʉja. Kʉtweera kwa ʉwo muhíínja, veenenyuumba vaachwe vapatáa mpía ˆjiri foo. ");
INSERT INTO lag_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ʉwo muhíínja, atutuubáa suusu na Paúli kʉnʉ yootʉla isóso yoosea, “Vaantʉ ava nɨ vatʉmami va Mʉlʉʉngʉ ˆArɨ Mweerimweeri, nɨ kʉvavariyʉrɨra viise njɨra ya ʉlamuriri.” ");
INSERT INTO lag_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ʉwo muhíínja atuuba bweeyya jeyyo kwa sikʉ ˆjiri foo. Maa kaa, sikʉ ɨmwɨ, Paúli ajáa akalala maatʉkʉ vii akʉʉsea ʉra murimʉ mʉvɨ, “Nakʉláiriirye kwa irina ra Yéesu Kirisitʉ, fuma kʉrɨ ʉhʉ muhíínja!” Hahara, ʉra murimʉ mʉvɨ ʉkafuma. ");
INSERT INTO lag_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Veenenyuumba va ʉra muhíínja ˆvakataange njɨra yaavo yo patɨra mpía yasáambukire, maa vakavakwaata vala Paúli na Síila, vakavakumuririrya fʉʉrʉ isóokwii, mbere ya vakʉ́ʉ́lʉ. ");
INSERT INTO lag_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Vakavasitaakya balásii voosea, “Vaantʉ ava nɨ Vayahúudi, voovo varéetire lʉsoso lʉkʉʉlʉ aha múujii mɨɨtʉ. ");
INSERT INTO lag_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Voovo vakíindyaa tʉʉva ja meevo, ˆngʼeene ndairiri jiitʉ ja Kɨrúumi jasiita suusu Varúumi kujirʉma no jituuba.” ");
INSERT INTO lag_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mpuka ya vaantʉ vakɨɨma, maa vakavakɨɨmɨrɨra vala Paúli na Síila. Aho, vara valamuli vakavafumya ɨngo vala Paúli na Síila, maa vakalairirya vavawe nkome. ");
INSERT INTO lag_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ˆVakahʉmʉle rindamwa nɨ valʉkalʉka, maa vakavachʉʉngɨra mʉnyololwii na vakamʉlairirya mʉkʉ́ʉ́lʉ wa gerésa avalaangirirye neeja. ");
INSERT INTO lag_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ˆAkalaiririwe jeyyo, akavatwaala vala Paúli na Síila na vyúumba vya isiʼiisii ya gerésa, akavachuunga mawʉlʉ yaavo mapongoolii makʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Uchikʉ katɨ, Paúli na Síila vamʉloombáa Mʉlʉʉngʉ no kɨɨmba nyɨɨ́mbo jo mʉdʉʉmba, na viivaavo ˆvajáa vachuungwa vavateereráa. ");
INSERT INTO lag_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Koonka, kitiíntima kɨkʉʉlʉ kɨkalooka na kɨkasingisya mwaariryo wa nkaande ja gerésa. Mɨryaango yoosi ɨkayʉʉrɨka yoomyeene na mɨnyololo ˆmyeene vajáa vachʉ́ʉngɨɨrwe ɨkachʉngʉlʉka. ");
INSERT INTO lag_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mʉkʉ́ʉ́lʉ wa gerésa ˆakiinʉke na ˆakoone mɨryaango ɨrɨ mwaarya, akakʉʉla nyaasʉka yaachwe yoosaaka kwiiyʉlaa, sa ajáa iiséire vaantʉ voosi ˆvachuungwa vatíijire. ");
INSERT INTO lag_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Koonka, Paúli akamwaanɨrɨra na ngururu yoosea, “Karɨ wiiyʉlae tʉkʉ! Suusu voosi tʉmwaarɨ aha.” ");
INSERT INTO lag_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ʉra mʉkʉ́ʉ́lʉ wa gerésa akalairirya vimʉrɨ vireetwe, akɨɨngɨra kurudu na chúumbii, maa akalaala na ɨnda mbere ya Paúli na Síila kʉnʉ yootetema nɨ woowa. ");
INSERT INTO lag_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Aho, maa akavafumya na weerwii na akavuurya, “Arumi! Che ndɨrɨ bweeyya sa ndahe kʉlamuririwa?” ");
INSERT INTO lag_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Novo vakamʉsea, “Murume Yéesu Mweenevyoosi, yeeye kʉkʉlamurirya arɨ weewe na vaantʉ va nyuumba yaako.” ");
INSERT INTO lag_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Aho, vakamʉvariyʉrɨra isáare ra Mweenevyoosi, yeeye na vaantʉ va nyuumba yaachwe. ");
INSERT INTO lag_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mpɨɨndɨ jijira akavasʉmʉla, maa akavooyya viloonda vyaavo. Hahara, maa yeeye na vaantʉ va kaaya yaachwe vakabatisiwa. ");
INSERT INTO lag_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mʉkʉ́ʉ́lʉ wa gerésa akavasʉmʉla vala Paúli na Síila na kaayii kwaachwe, akaviimirya neeja chóorya. Akeerya mʉtɨma maatʉkʉ vii, yeeye na nyuumba yaachwe sa kumuruma Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lomʉtóondo ˆkʉkeere, vara valamuli vakavatʉma valʉkalʉka kwa mʉkʉ́ʉ́lʉ wa gerésa vakamʉsea, “Vachʉngʉrɨre vara vaantʉ viilookere.” ");
INSERT INTO lag_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ʉra mʉkʉ́ʉ́lʉ wa gerésa akamʉsea Paúli, “Valamuli vaandairiirye, nɨvachʉngʉrɨre, haaha, fumi, mwiitamanyirye na mwiikalo mʉʉja.” ");
INSERT INTO lag_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Maa kaa, Paúli akamʉsea mʉkʉ́ʉ́lʉ wa gerésa, “Valamuli vatʉvairé maatʉkʉ vii mbere ja vaantʉ na vakatuchuunga mʉnyololwii baa kutusitaakya tʉkʉ au baa kutuurya tʉkʉ baa neembe tʉrɨ vaantʉ va Róoma. Haaha sa che voosaaka kʉtʉchʉngʉrɨra kimbiso? Sɨ viri kʉva jeyyo tʉkʉ! Vʉʉje voovo veeneevyo de jɨ vatufumye.” ");
INSERT INTO lag_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Valʉkalʉka vakavawyɨɨra ayo masáare valamuli. ˆVakateere vala Paúli na Síila nɨ Varúumi, maa vakakwaatwa nɨ woowa. ");
INSERT INTO lag_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Sa jeyyo, vakʉʉja noo valoomba vasee yasírire, maa vakavafumya hara mʉnyololwii na vajáa vavaloomba valooke fuma ʉra múuji. ");
INSERT INTO lag_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paúli na Síila ˆvakafume mʉnyololwii, vakadoma na kaayii kwa Lídia. Ʉko vakalʉmana na vaaniitʉ, vakavaheera mɨtɨma, maa vakiinʉka. ");
INSERT INTO lag_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paúli na Síila vakakwaata njɨra, vakakwaatɨra na múuji wa Amufipóoli na Apolonía, vakafika múuji wa Tesaloníike. Ʉko kwajáa kwatɨɨte sinagóogi ya Kɨyahúudi. ");
INSERT INTO lag_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paúli akɨɨngɨra na sinagóogii kɨra sikʉ ya Sabáato kwa majuma yatatʉ ja ˆvyeene ajáa iijʉvɨra. Ʉko, akava yootamanʉla novo Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Akavavariyʉrɨra ʉláali na mʉtwe na akoonekya kɨmaarɨ, Masía nɨ mpaka aturikiriwe na afʉfʉke fuma inkwyii. Akavasea, “Ʉhʉ Yéesu ˆnoovavariyʉrɨra, noo Masía.” ");
INSERT INTO lag_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Vamwɨ va Vayahúudi vakayaruma masáare ya Paúli, baa na Vagiríki ˆvarɨ foo mʉnʉmʉʉnʉ vara ˆvamwiinamɨráa Mʉlʉʉngʉ, na vaantʉ vaki ˆvanyémiwaa ˆvarɨ foo, voosi vakasaangɨra na vala Paúli na Síila. ");
INSERT INTO lag_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Maa kaa, Vayahúudi vara sɨ ˆvajáa varuma, vakakwaatwa nɨ kɨvɨna. Vakatamanya na sóokwii, maa vakɨɨta vaanɨrɨra vaantʉ vavɨ, novo vakasaankanʼya vaantʉ ˆvarɨ foo, maa vakaanda lʉsoso lʉkʉʉlʉ múujii woosi. Aho, vakadoma na kaayii kwa Yasóoni, maa vakɨɨngɨra na ngururu sa vavakwaate vala Paúli na Síila na vavatwaale na kɨweerwii mbere ja vaantʉ. ");
INSERT INTO lag_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Maa kaa, ˆvakavasove, vakamukumurirya Yasóoni na vamwɨ va vaaniitʉ fʉʉrʉ kwa vakʉ́ʉ́lʉ va múuji kʉnʉ vootʉla isóso voosea, “Vaantʉ ava noo vara ˆvakányiirye weerʉ yoosi vʉʉ, haaha vuújire baa na kʉnʉ. ");
INSERT INTO lag_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ʉhʉ Yasóoni, avahokera na kaayii kwaachwe. Ava voosi vavalandʉka tʉʉva ja Kaisáari na vaséaa, atɨ kwatɨɨte mʉtemi wɨɨngɨ ˆaséwaa Yéesu.” ");
INSERT INTO lag_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Vaantʉ va ʉra múuji na vakʉ́ʉ́lʉ vaavo ˆvakateere jeyyo, mɨtɨma yaavo ɨkavaava. ");
INSERT INTO lag_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Aho, vakʉ́ʉ́lʉ va múuji vakavasea vala Yasóoni na viivaachwe vatoole mpía jo kiinunuula. ˆVakatoole, maa vakavarekera. ");
INSERT INTO lag_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Uchikʉ ˆʉkɨɨngɨre, vaaniitʉ vakavasea vala Paúli na Síila vatamanye chaangʉ na múujii wa Beróoya. ˆVakafike ʉko, vakɨɨngɨra sinagóogii ya Kɨyahúudi. ");
INSERT INTO lag_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Vayahúudi va aho Beróoya nɨ vaantʉ ˆvateereráa kʉlookya vaantʉ va Tesaloníike. Mpɨɨndɨ Paúli ˆavariyʉláa Masáare Maaja, voovo vakayahokera na mɨtɨma yaavo yoosi. Vakatuuba chukuruma Masáare ˆYarɨ Mpeho sikʉ joosi, sa viiyonere yara Paúli ˆyoovariyʉla nɨ ya kɨmáárɨ. ");
INSERT INTO lag_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Sa jeyyo, Vayahúudi ˆvarɨ foo vakamuruma Yéesu, hamwɨ na vakʉ́ʉ́lʉ va Kɨgiríki va kɨɨntʉ kɨlʉme na va kɨɨntʉ kiki. ");
INSERT INTO lag_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Maa kaa, Vayahúudi va Tesaloníike ˆvakataange Paúli amwaarɨ yoovariyʉla isáare ra Mʉlʉʉngʉ ʉko Beróoya, vakadoma na ʉko. Vakasoonka mpuka ja vaantʉ na vakareeta lʉsoso. ");
INSERT INTO lag_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Aho, vaaniitʉ va Beróoya vakamusindikirirya Paúli na ɨsɨ ya mbarɨmbarɨ ya mayɨya. Maa kaa, Síila na Timotéeo vakachaala ʉko Beróoya. ");
INSERT INTO lag_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Vara vaantʉ ˆvajáa vamʉsɨ́ndɨkɨɨre Paúli, ˆvakamufikye múuji wa Aséene, maa vakahɨndʉka na Beróoya. De valooke Paúli akavasea, vavasee vala Timotéeo na Síila vamutuube chaangʉ. ");
INSERT INTO lag_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mpɨɨndɨ Paúli ˆavawoojeráa vala Timotéeo na Síila ʉko Aséene, mʉtɨma waachwe ʉjáa wasukiwasukiwa sa ajáa oona múuji woosi ʉjáa wamema vidabalaíyo. ");
INSERT INTO lag_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Sa jeyyo, ɨɨngɨráa masinagóogii. Ʉko andoolʉma sáare na Vayahúudi na kei Vagiríki ˆveene vamwiinamɨráa Mʉlʉʉngʉ. Kei, sikʉ joosi alʉmáa sáare na vaantʉ ˆalʉmanáa novo sóokwii. ");
INSERT INTO lag_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Paúli ajáa alʉmana na vaantʉ ˆvatuubáa ʉlwɨɨrɨ wa mɨryʉʉngʉ ya Vaepukuréo na Vasitoíki na andoolʉma sáare novo. Vamwɨ vaavo vaseáa, “Nɨ che kaa yoosaaka alʉʉse ʉhʉ mʉhaanchi?” Na vɨɨngɨ vaseáa, “ˆVyeene yookoonekana nɨ lʉʉsɨkɨra iise masáare ya mɨlʉʉngʉ ya kɨyeni.” Vajáa valʉʉsa aya, sa viintʉ ˆavariyʉláa Masáare Maaja ya Yéesu Kirisitʉ na kʉfʉfʉka kwaachwe. ");
INSERT INTO lag_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Avo vaantʉ vakamʉsʉmʉla, maa vakamʉtwaala na itakii ra vamanyi ˆraséwaa Areopáago, ʉko vakamʉsea, “Tʉwyɨɨre hoonɨ masáare ayo mafya ˆwoolʉʉsa. ");
INSERT INTO lag_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tatéɨɨre yiísimire, toosaaka ʉtʉtamanʉrɨre ayo masáare.” ");
INSERT INTO lag_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Vajáa valʉʉsa jeyyo, sa vaantʉ va Aséene na vayeni fuma kʉlɨ ˆviikaláa ʉko, vajáa veenda teerera masáare mafya noo yavariyʉla. ");
INSERT INTO lag_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Aho, Paúli akɨɨma katɨ na katɨ ya Areopáago, maa akavasea, “Arumi, nyuunyu vaantʉ va Aséene! Nɨɨ́ne nyuunyu nɨ vaantʉ ˆmutúubaa masáare yoosi ya díini. ");
INSERT INTO lag_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mpɨɨndɨ ˆnaalooka aha múujii, nɨɨ́ne ˆvyeene mwiínamɨraa mɨlʉʉngʉ. Nɨɨ́ne masabáahʉ ˆmʉtóoreraa mpóryo ˆngʼeene yaandɨkwa, ‘Kwa mʉlʉʉngʉ sɨ ˆtamʉmányire.’ Haaha ɨkɨ kɨɨntʉ ˆnavariyʉláa noo noosaaka nɨvavariyʉrɨre, noo cha ʉwo ˆmweene mumwiínamɨraa sɨ ˆmʉmʉmányire. ");
INSERT INTO lag_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mʉlʉʉngʉ ʉʉmba weerʉ na vyoosi ˆviri mʉʉmo. Yeeye noo Mweenevyoosi wa kurumu na ɨsɨ, sɨ iíkalaa nyuumbii ˆngʼeene jajeengwa kwa mɨkono ya vaantʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yeeye sɨ atʉ́mamɨrwaa na mɨkono ya vaantʉ ja yoosaaka kɨɨntʉ chaayo fuma kʉrɨ voovo tʉkʉ. Yeeye noo avahéeraa vaantʉ voosi nkaasʉ na nkeeho na viintʉ vyoosi. ");
INSERT INTO lag_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Yeeye ʉʉmba mʉʉntʉ ʉmwɨ na ʉwo akava ichina ra vaantʉ va ɨsɨ joosi viipasa aha weerwii koosi. Yeeye avɨɨka mpɨɨndɨ ja naadi na hai ˆvarɨ kwiikala. ");
INSERT INTO lag_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mʉlʉʉngʉ abweeyya jei, sa vaantʉ vamʉsaakɨre, baa koonɨ nɨ ko halaasha vamoone. Baa neembe nɨ jeyyo, yeeye sɨ arɨ kʉlɨ na kɨra ʉmwɨ wiitʉ asiindwe kʉmʉfɨkɨra tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Sa ‘Nɨ kʉrɨ yeeye suusu twiíkalaa na tavíjaa nkaasʉ.’ Ja ˆvyeene mpɨ́rɨ yaanyu yalʉʉsa, ‘Suusu tʉrɨ vaana vaachwe.’ ");
INSERT INTO lag_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Sa viintʉ suusu tʉrɨ vaana va Mʉlʉʉngʉ, sɨ tasaakwa tʉndookiiririkana ʉlʉʉngʉ waachwe wiifwɨ́ɨne na vidabalaíyo ˆviténgeneshiwaa na saháabu, au chʉʉ́ma cha mpía, au mawye kwa wʉʉya na tooti ja vaantʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Aho kalɨ, mpɨɨndɨ vaantʉ ˆvatʉmamáa ayo kɨhoho, Mʉlʉʉngʉ ajáa iibweeyya ja sɨ yookoona. Maa kaa, haaha nɨ vawyɨɨra iise vaantʉ voosi va kɨra haantʉ vavalandʉke fuma uvii waavo. ");
INSERT INTO lag_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Yeeye avɨɨka sikʉ ˆarɨ valamʉrɨra vaantʉ va weerʉ yoosi kwa ʉwoloki kwa njɨra ya mʉʉntʉ ˆmweene amʉsaawʉla. Mʉlʉʉngʉ alaɨra kwa vaantʉ voosi ayo kɨkomi kwa njɨra yo mʉfʉfʉla.” ");
INSERT INTO lag_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Vara vaantʉ ˆvakateere Paúli yoolʉʉsɨkɨra kʉfʉfʉka kwa vaantʉ ˆvaakwya, vamwɨ vakava voomuchwa matɨ, maa kaa, vɨɨngɨ vakamʉsea, “Toosaaka tʉteere woovariyʉla aya masáare kei.” ");
INSERT INTO lag_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Aho, Paúli akafuma, maa akavareka itakii raavo. ");
INSERT INTO lag_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Vaantʉ vamwɨ vakamuruma Yéesu, maa vakaanda kumutuuba Paúli. Ʉmwɨ wa avo vaantʉ nɨ Deoníisi wa itakii ra Areopáago, na mʉʉntʉ muki ʉmwɨ ˆakemerwáa Damáali, hamwɨ baa na vɨɨngɨ. ");
INSERT INTO lag_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Aya ˆyakalooke, Paúli akafuma Aséene, maa akadoma na múuji wa Koríinto. ");
INSERT INTO lag_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ʉko, akamʉshaana Mʉyahúudi ʉmwɨ ˆasewáa Akíila. Yeeye nɨ mʉʉntʉ wa Póonto ajáa na ajáa afíkire fuma Itália hamwɨ na Pirisíila muki waachwe. Ajáa abweeyya jeyyo, sa sikʉ ijo Kaisáari Kɨlaáudi ajáa alairirya yoosea, “Vayahúudi voosi vʉʉ viisunke múujii wa Róoma.” Maa Paúli akadoma noo valuumbya. ");
INSERT INTO lag_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Na sa viintʉ vajáa nɨ vachumi va mɨnyana yo tengenesherya vivaanda, Paúli akiikala novo, na akatʉmama novo sa baa yeeye nɨ muchumi ajáa. ");
INSERT INTO lag_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Na kɨra sikʉ ya Sabáato, Paúli ɨɨngɨráa na sinagóogii na alʉʉsɨkáa na Vayahúudi na Vagiríki sa yoosaaka vamurume Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Síila na Timotéeo ˆvakʉʉje fuma Makedonía, Paúli akaanda variyʉla Masáare ˆYarɨ Mpeho kwa mpɨɨndɨ joosi kwa Vayahúudi. Oonekyáa kɨkomi yoovasea, Yéesu noo Masía. ");
INSERT INTO lag_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Maa kaa, Vayahúudi vakamusiita na vakamʉtʉkɨra. Aho, Paúli akiikonkoma marʉrɨ ingwii jaachwe kʉnʉ yoovasea, “Sakami ya marema yaanyu ɨve mweeri ya mɨtwe yaanyu! Nɨɨnɨ nsiina lʉtaamɨ na ʉvɨ waanyu tʉkʉ. Kwaandɨra haaha doma niise na kwa vaantʉ sɨ ˆvarɨ Vayahúudi.” ");
INSERT INTO lag_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Aho, maa akafuma aho sinagóogii, akadoma na kwa mʉʉntʉ ʉmwɨ ˆasewáa Tíito Yústo. Ʉhʉ sɨ ajáa Mʉyahúudi tʉkʉ na amwiinamɨráa Mʉlʉʉngʉ na nyuumba yaachwe ɨjáa yiiyandama na sinagóogi. ");
INSERT INTO lag_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirísipo mʉkʉ́ʉ́lʉ wa ɨyo sinagóogi akamuruma Yéesu Mweenevyoosi baa na vaantʉ va kaaya yaachwe yoosi. Na Vakoríinto ˆvarɨ foo ˆvakateere masáare ya Paúli, vakayaruma, maa vakabatisiwa. ");
INSERT INTO lag_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sikʉ ɨmwɨ nuuchikʉ, Mweenevyoosi akalʉʉsɨka na Paúli njorii yoosea, “Koofa tʉkʉ, tuuba variyʉla, karɨ ʉhɨndʉle mʉtɨma waako na nyuma tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nɨɨnɨ nɨ na weewe ndɨrɨ, na kusiina mʉʉntʉ ˆarɨ kukiimɨrɨra akʉtamikye tʉkʉ. Nɨɨnɨ natɨɨte vaantʉ vaanɨ ˆvarɨ foo aha múujii.” ");
INSERT INTO lag_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Jeyyo, Paúli akiikala ʉko mwaaka ʉmwɨ na myeeri mʉsasatʉ, kʉnʉ yoovavariyʉrɨra vaantʉ isáare ra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Haaha mpɨɨndɨ Gálio ˆajáa mʉkʉ́ʉ́lʉ wa ɨsɨ ya Akáaya, Vayahúudi vajáa viisaanka, vakamʉkʉʉkɨra Paúli, vakamʉkwaata, maa vakamʉtwaala na balásii. ");
INSERT INTO lag_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ʉko, vakamusitaakya voosea, “Ʉhʉ mʉʉntʉ yoovaheemba vaantʉ vamwiinamɨre Mʉlʉʉngʉ kwa njɨra ˆɨkɨ́ɨkanaa Miiro yiitʉ.” ");
INSERT INTO lag_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paúli ˆakiinʉke sa alʉʉsɨke, maa Gálio akavasea Vayahúudi, “Nyuunyu Vayahúudi teeri, ngaarɨ mʉmʉréetire na balásii sa abwéeyyiirye ʉvɨ au ʉsaambʉ, nɨɨnɨ ngaarɨ navatéerɨɨre. ");
INSERT INTO lag_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Maa kaa, sa viintʉ mookiiruta ndihi sa masáare, marina na Miiro yaanyu, lamuli nyuunyu veeneevyo. Nɨɨnɨ sɨ noosaaka kʉva mʉlamuli wa aya masáare tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Aho, maa akavakibirya aho balásii. ");
INSERT INTO lag_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Avo vaantʉ vakamʉkwaata Sositénesi. Ʉhʉ noo ajáa mʉkʉ́ʉ́lʉ wa sinagóogi. Haaho, balásii vakamʉvaa. Baa jeyyo, Gálio akiikwaatɨra vyaachwe, sɨ oona nɨ kɨɨntʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paúli akiikala ʉko Koríinto sikʉ ˆjiri foo. Sikʉ ˆjikalooke, Paúli akavasea vaaniitʉ, asúukiirye, aho, maa akadoma na múujii wa Kenkiréa. ˆAkafike Kenkiréa, Paúli akakerwa njwɨɨrɨ jaachwe, ja ˆvyeene ajáa alaha. Aho, maa akaambʉka méeli ˆyoodoma na ɨsɨ ya Síria na akadomanʼya na vala Pirisíila na Akíila. ");
INSERT INTO lag_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Vayeenda fʉʉrʉ vakafika Eféeso. Aho, Paúli akavareka vala Pirisíila na Akíila. Yeeye akadoma na sinagóogii, ʉko akaanda lʉma sáare ja Mʉlʉʉngʉ na Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Novo vakamʉloomba oongererye sikʉ jo kiikala novo, maa kaa, yeeye akasiita. ");
INSERT INTO lag_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Akavasea asúukiirye yoosea, “Koonɨ Mʉlʉʉngʉ eéndire, hɨndʉka ndɨrɨ kei na meenyu.” Aho, akiinʉka fuma Eféeso na méeli. ");
INSERT INTO lag_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paúli ˆakafike Kaisaría, akaambʉka fʉʉrʉ Yerusaléemu, akɨɨta ko luumbya mpuka ya vaantʉ ˆvamuruma Yéesu, aho, maa akagirita na Antiókia. ");
INSERT INTO lag_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ʉko Antiókia, Paúli akiikala kwa mpɨɨndɨ kiduudi. Aho, akiinʉka, maa de ɨndootweerera ɨsɨ ya Galatía na Firigía, kʉnʉ yoovaheera mʉtɨma vaantʉ ˆvamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Haaha sikʉ ijo, Mʉyahúudi ʉmwɨ ˆasewáa Apóolo ajáa ʉʉja na Eféeso. Ʉhʉ meevo kʉʉntʉ ˆajáa avyaarɨrwa nɨ múuji wa Alekisándiria. Yeeye nɨ mʉmanyi wo lʉʉsɨka ajáa, na ajáa atɨɨte mʉryʉʉngʉ mʉkʉʉlʉ wa Masáare ˆYarɨ Mpeho. ");
INSERT INTO lag_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Yeeye ajáa akiindiwa njɨra ya Yéesu Mweenevyoosi, na yeeye avakiindyáa vaantʉ vɨɨngɨ ɨyo njɨra ya Mweenevyoosi ko kiitema na kwa ʉwoloki. Baa neembe abweeyyáa jeyyo, yeeye kɨɨntʉ ˆajáa amányire nɨ ʉbatíiso wa Yooháani vii. ");
INSERT INTO lag_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Sikʉ ɨmwɨ, akɨɨngɨra sinagóogii, maa akaanda variyʉla Masáare ˆYarɨ Mpeho ko kiitema kʉkʉʉlʉ. Pirisíila na Akíila ˆvakateere ˆvyeene alʉʉsáa ko kiitema, vakamʉsʉmʉla na meevo noo mukiindya neeja njɨra yo mutuuba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Sikʉ ˆjikaseese, Apóolo akasaaka doma na ɨsɨ ya Akáaya, vaaniitʉ vakamʉheera mʉtɨma. Vakaandɨka barʉ́wa atamanye noyo na kwa vaantʉ ˆvamuruma Yéesu ʉko Akáaya sa vamʉteengye vyabooha. ˆAkafike ʉko, akavaambɨra maatʉkʉ vii kwa nduwo ya Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yeeye iirutáa ndihi na Vayahúudi mbere ja vaantʉ ko kiitema kʉnʉ yookoonekya Masáare ˆYarɨ Mpeho yalʉʉsa Yéesu nɨ Masía. ");
INSERT INTO lag_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mpɨɨndɨ ijo Apóolo ˆajáa ʉko Koríinto, Paúli ne atweereráa na ɨsɨ ja mweeri fʉʉrʉ múuji wa Eféeso. Ʉko Eféeso, Paúli akashaana vaantʉ ˆvamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Maa akavuurya, “Eri, ˆmʉkamurume Yéesu, mwahokera Mʉtɨma Mʉʉja wʉʉ?” Novo vakamʉsea, “Tʉkʉ, baa sɨ tʉnateera koonɨ kwatɨɨte Mʉtɨma Mʉʉja tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paúli akavuurya kei, “Kwa ʉbatíiso wa ani mwabatisiwa?” Maa vakamʉsea, “Kwa ʉbatíiso wa Yooháani.” ");
INSERT INTO lag_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paúli akavasea, “Ʉbatíiso wa Yooháani nɨ wavasaakáa vaantʉ vavalandʉke fuma uvii waavo vii. Na yeeye avawyɨɨráa vaantʉ vamurume ˆmweene yookʉʉja nyuma yaachwe, noo kʉsea Yéesu.” ");
INSERT INTO lag_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ˆVakateere jeyyo, maa vakabatisiwa kwa irina ra Yéesu Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na Paúli ˆakavavɨkɨre mɨkono yaachwe, vakahokera Mʉtɨma Mʉʉja, vakaanda lʉʉsɨka ndʉʉsɨka ngʼeni no lʉʉsa ʉláali na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Na avo voosi nɨ ja vaantʉ valʉme ikimi na vavɨrɨ vajáa. ");
INSERT INTO lag_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Na kwa myeeri ɨtatʉ, Paúli ɨɨngɨráa masinagóogii na avariyʉláa ko kiitema mʉnʉmʉʉnʉ kʉnʉ yoolʉma sáare, na vaantʉ varumáa masáare ya Ʉtemi wa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Maa kaa, vamwɨ vaavo, vakahɨtanʼya mɨtɨma yaavo, kʉnʉ voohɨɨntɨkɨra rɨra isáare ra Njɨra ya Yéesu Mweenevyoosi mbere ya mpuka ya vaantʉ. Aho, Paúli akiireka novo, akavasʉmʉla vaantʉ ˆvamuruma Yéesu, ɨndoovakiindya kɨra siikʉ nyuumbii ya kɨbawo kwa Tiráano. ");
INSERT INTO lag_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Paúli akatuuba kʉvakiindya kwa myaaka ɨvɨrɨ, sa jeyyo, Vayahúudi na Vagiríki voosi ˆviikaláa ɨsɨ ja Ásia, vakarɨteera isáare ra Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mʉlʉʉngʉ abweeyyáa myuujíisa ˆɨhwáalaryaa ko tweera kwa Paúli. ");
INSERT INTO lag_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Vaantʉ vatooláa baa nchíifu na ɨngo jɨɨngɨ ˆngʼeene jijáa jasáasiirye mʉvɨrɨ wa Paúli, novo ˆvakajivɨɨke kwa valwɨ́ɨrɨ, vaholáa ndwáala jaavo baa mirimʉ mɨvɨ yavafumáa. ");
INSERT INTO lag_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Vayahúudi vamwɨ ˆveene vayeenda ʉko na ʉko kʉseyya mirimʉ mɨvɨ kʉrɨ vaantʉ, vakayera seyya mirimʉ mɨvɨ kwa irina ra Yéesu Mweenevyoosi voosea jei, “Nakʉláiriirye kwa irina ra Yéesu, ʉra ˆavariyʉlwáa nɨ Paúli, fuma kʉrɨ ʉhʉ mʉʉntʉ.” ");
INSERT INTO lag_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kʉjáa kwatɨɨte vaana mufungatɨ va Mʉyahúudi ʉmwɨ ˆasewáa Sikéewa. Yeeye nɨ mʉkʉ́ʉ́lʉ wa veeneɨsɨ va Ijʉva ajáa. Avo vaana vaachwe vandoobweeyya jeyyo. ");
INSERT INTO lag_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Sikʉ ɨmwɨ, murimʉ mʉvɨ ʉkavasea, “Yéesu namʉmányire, baa Paúli namʉmányire, ha nyuunyu mʉrɨ vala ani?” ");
INSERT INTO lag_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Aho, ʉra mʉʉntʉ ˆajáa akwaatwa nɨ murimʉ mʉvɨ akavakiimɨrɨra voosi na ngururu, akavahʉʉma ngururu. Akavavaa maatʉkʉ vii mpaka vakafuma aho nyuumbii varɨ na tʉhʉ na varɨ na maloonda. ");
INSERT INTO lag_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Aya masáare yakeenera kwa vaantʉ voosi ˆviikaláa Eféeso noo kʉsea Vayahúudi na Vagiríki. Voosi vakakwaatwa nɨ woowa, na irina ra Yéesu Mweenevyoosi rɨkava roonyemiwa maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Vaantʉ ˆvarɨ foo vara ˆvamuruma Yéesu, vʉʉjáa kʉnʉ voolʉʉsa ʉvɨ waavo ˆvajáa vabweeyya. Vabweeyyáa jei mbere ja vaantʉ. ");
INSERT INTO lag_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Vaantʉ ˆvarɨ foo vara ˆvabweeyyáa ʉsavɨ, vajiingáa vitáabu vyaavo na vavichɨmɨkáa mbere ya vaantʉ voosi. Vakavala iyoombe ra vitáabu vyoosi, rɨkafika mbwɨɨrʉ ja chʉʉ́ma cha mpía mayana makumi yasaano (50,000). ");
INSERT INTO lag_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Jeyyo, isáare ra Ijʉva reeneráa na ravijáa na ngururu mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Masáare ayo ˆyakalooke, Paúli akalamʉla akiisea adome na Yerusaléemu ko tweera ɨsɨ ya Makedonía na Akáaya. Akasea, “ˆNdɨrɨ fika ʉko, yoosaakwa ndome na Róoma.” ");
INSERT INTO lag_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Aho, akavatʉma vaambiriryi vaachwe vavɨrɨ, Timotéeo na Erásto, valongoole na Makedonía, yeeye akachaala kiduudi ʉko Ásia. ");
INSERT INTO lag_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mpɨɨndɨ jiijo, aho Eféeso kwajáa kwafʉmɨra ntiribʉka nkʉʉlʉ, sa ʉwo ukiindya wa Njɨra ya Yéesu Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Haaha aho múujii, kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆasewáa Demetirío. Yeeye nɨ mʉcháani wa fividabalaíyo fya mpía ajáa, na ifyo fividabalaíyo fijáa fiifwɨ́ɨne na kaaya ya mʉlʉʉngʉ waavo wa kɨɨntʉ kiki ˆaséwaa Aritéemi. Na mʉrɨmo ʉhʉ wavareteráa vacháani vaachwe kʉnáálo nkʉʉlʉ. ");
INSERT INTO lag_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetirío akavajiinga vacháani viivaachwe na vaantʉ vɨɨngɨ ˆvatʉ́mamaa mʉrɨmo ˆwiifwɨ́ɨne na ʉwo, maa akavasea, “Arumi, mʉmányire tapátaa mpía ˆjamema maatʉkʉ vii fuma kʉrɨ ʉhʉ mʉrɨmo wiiswi. ");
INSERT INTO lag_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nookoona kiiteerera mwiise na kwiiyonera mwiise ˆvyeene Paúli yoovavalandʉla vaantʉ na ˆvyeene voomuruma. Yeeye atúubire lʉʉsa vidabalaíyo ˆviténgeneshiwaa nɨ vaantʉ sɨ mɨlʉʉngʉ ya kɨmáárɨ tʉkʉ. Avasóonkire vaantʉ ˆvarɨ foo sɨ aha Eféeso vii tʉkʉ, baa na ɨsɨ joosi ja ʉko Ásia. ");
INSERT INTO lag_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Haaha ˆvyeene nookoona ʉhʉ mʉrɨmo wiiswi koonwa ʉrɨ nɨ kosu vii, na sɨ jeyyo vii tʉkʉ, baa na ɨhɨ kaaya ya Aritéemi, mʉlʉʉngʉ wa kɨɨntʉ kiki chwɨɨwa ɨrɨ matɨ. Aritéemi, mʉlʉʉngʉ ˆiínamɨrwaa ɨsɨ joosi ja Ásia na weerʉ yoosi, nyemi yaachwe sira ɨrɨ.” ");
INSERT INTO lag_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ˆVakateere ayo masáare, vakakalala maatʉkʉ vii, maa vakaanda tʉla isóso voosea, “Aritéemi wa Vaeféeso noo mʉkʉ́ʉ́lʉ!” ");
INSERT INTO lag_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Haaho, múuji woosi ukiinʉla ntiribʉka. Vakavakwaata vaantʉ vavɨrɨ va Makedonía ˆvayeendanʼyáa na Paúli, vala Gáayo na Aristáriko, maa vakavatwaala fʉʉrʉ haantʉ ˆvabwéeyyiryaa bwɨɨto. ");
INSERT INTO lag_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paúli asaakáa doma na ʉko mwiijiingwii wa vaantʉ maa kaa, vaantʉ ˆvamuruma Yéesu vakamʉkaanʼya. ");
INSERT INTO lag_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Baa vakʉ́ʉ́lʉ va ɨsɨ ja Ásia vara ˆvajáa vijeengi vya Paúli, vakatʉma vaantʉ na kwaachwe vamʉloombe adɨɨre kɨɨngɨra aho nyuumbii kʉʉntʉ ˆvabweeyyiryáa bwɨɨto. ");
INSERT INTO lag_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Na vaantʉ ˆvajáa viijíingire hara sɨ viiteerwáa tʉkʉ, vɨɨngɨ varɨráa jei, na vɨɨngɨ jira. Vaantʉ ˆvarɨ foo sɨ vatáangaa baa nɨ che kɨvajíingire aho tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Vayahúudi vakamwiimya mʉʉntʉ ʉmwɨ ˆasewáa Alekɨsáanda mbere ya vara vaantʉ. Vaantʉ vamwɨ vakamʉhweehera kɨra ˆarɨ lʉʉsa. Akiinurirya mʉkono kʉvasea vakirinye sa asaakáa kiitetera. ");
INSERT INTO lag_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Maa kaa, ˆvakataange Alekɨsáanda nɨ Mʉyahúudi, voosi vakatuuba tʉla isóso kwa masaa yavɨrɨ voosea, “Aritéemi wa Eféeso noo mʉkʉ́ʉ́lʉ!” ");
INSERT INTO lag_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Aho, mwaandiki mʉkʉʉlʉ wa múuji akavakaanʼya vaantʉ vareke isóso, akavasea, “Arumi, nyuunyu vaantʉ va Eféeso, nɨ ani sɨ ˆamányire múuji wa Eféeso noo wɨɨ́mɨrɨraa kaaya ya Aritéemi mʉkʉʉlʉ, na ɨrɨ iwye ra kɨdabalaíyo chaachwe ˆraawya fuma kurumwii? ");
INSERT INTO lag_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kusiina mʉʉntʉ ˆarɨ daha siita ɨrɨ tʉkʉ. Haaha nyuunyu kirinyi, karɨ mʉbweeyye kɨɨntʉ chochoosi chaangʉ chaangʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ava vaantʉ ˆmʉvaréetire na aha, sɨ viívire kɨɨntʉ tʉkʉ fuma kaayii ya Aritéemi wiitʉ na sɨ vamʉhɨ́ɨntɨkɨɨre mʉlʉʉngʉ muki wiitʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Koonɨ Demetirío na vacháani viivaachwe varɨ na isáare na vaantʉ ava, vatwaali na balásii, amwɨ jimwaarɨ na vakʉ́ʉ́lʉ vamwaarɨ, nɨ vakaloongerwe ʉko. ");
INSERT INTO lag_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Maa kaa, koonɨ mʉrɨ na masáare yoyoosi yɨɨngɨ, yatwaali na balásii ˆngʼeene yarumwa nɨ ndairiri ja Kɨrúumi, yakaloongwe ʉko. ");
INSERT INTO lag_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ˆVyeene tabwéeyyiirye isikʉ ifaanaa ɨkatʉbweeyya tʉtwaalwe na balásii sa tabwéeyyiirye ntiribʉka nkʉʉlʉ. Koonɨ vatusítakiirye sa ntiribʉka ɨhɨ, tusiina cho kuuyirya tʉkʉ. Ɨhɨ ntiribʉka nɨ ya bweete vii.” ");
INSERT INTO lag_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ˆAkalʉʉse jeyyo, maa akavasea vaantʉ viimyaahe. ");
INSERT INTO lag_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɨra ntiribʉka ˆɨkasire, Paúli akavaanɨrɨra vaantʉ ˆvamuruma Yéesu, akavaheera mʉtɨma, maa akavasea, asúukiirye. Aho, akakwaata njɨra na Makedonía. ");
INSERT INTO lag_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Akatweera na ɨsɨ ɨyo, na njirii avaheeráa vaantʉ ˆvamuruma Yéesu masáare yo bweeyya mɨtɨma yaavo ɨve na ngururu. Maa re, akafika Ugiríki. ");
INSERT INTO lag_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ʉko akiikala myeeri ɨtatʉ. Mpɨɨndɨ ˆasaakáa fɨrɨra na mashʉ́wa adome na Síria, Vayahúudi vakabweeyya nchuungo, sa vamʉbweeyyirye ʉvɨ. Jeyyo, maa akalamʉla kʉhɨndʉka kwa njɨra ya Makedonía. ");
INSERT INTO lag_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Mpɨɨndɨ ijo, Paúli ayeendanʼyáa na vala Sopatíro mwaana wa Píiro fuma múuji wa Beróoya, Aristáriko na Séekuundo fuma múuji wa Tesaloníike, Gáayo fuma múuji wa Déribe, Timotéeo fuma Lísitra, na Tíkiko na Tirofíimo fuma ɨsɨ ya Ásia. ");
INSERT INTO lag_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ava voosi vakalongoola na Turóoa, maa vakɨɨta kootʉwoojera kʉra. ");
INSERT INTO lag_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Maa kaa, ngovi ya mɨkáate sɨ ˆɨvɨ́kɨrwaa ʉsasɨ ˆɨkalooke, tʉkaambʉka méeli fuma Filíipi na sikʉ isaano ˆjikalooke, tʉkafika Turóoa, aho, tukiikala kwa sikʉ mufungatɨ. ");
INSERT INTO lag_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sikʉ ya ncholo ya júma nakyʉʉlwa, tʉjáa twalʉmana hamwɨ so bendʉla mʉkáate. Paúli akaanda kʉvavariyʉrɨra vaantʉ fʉʉrʉ nuuchikʉ katɨ, sa ajáa aláarɨɨre ndɨrɨ kʉlooka lomʉtóondo yaachwe. ");
INSERT INTO lag_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Na aho gorófii haantʉ ˆtʉjáa talʉ́manɨɨre, kʉjáa kwatɨɨte vimʉrɨ ˆviri foo. ");
INSERT INTO lag_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mʉtavana ʉmwɨ ˆasewáa Eutíiko, akiikala chooririi mpɨɨndɨ Paúli ˆalʉʉsɨkáa, maa akakwaatwa nɨ tʉlo. Sa jeyyo, akanyeyya fúti, maa akawya na ɨsɨ fuma gorófa ya katatʉ. ˆVakakiime, vakɨɨta shaana akwíire. ");
INSERT INTO lag_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paúli ne akakiima na ɨsɨ, akamʉlaarɨra ʉra mʉtavana, akamʉʉvatɨra, maa akavasea, “Koofi tʉkʉ, akaarɨ arɨ nkaasʉ!” ");
INSERT INTO lag_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Aho, Paúli akaambʉka na gorófii, vakabendʉlabendʉla mʉkáate, maa vakarya. ˆVakahʉmʉle, akatuuba kʉlʉʉsɨka novo fʉʉrʉ kʉkeera. ˆKʉkeere, maa akalooka. ");
INSERT INTO lag_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Vara vaantʉ vakamʉhɨndʉla ʉra mʉtavana na kaayii arɨ nkaasʉ, vakatuuriwa mɨtɨma maatʉkʉ vii. ");
INSERT INTO lag_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Aho, suusu tʉkaambʉka méeli, tʉkalongoola doma na Asóosi, sa Paúli ajáa alámwɨɨre kʉkerya na mawʉlʉ. Ʉko Asóosi noo kʉʉntʉ ˆtʉjáa twiirʉmɨra kʉmʉtweerera. ");
INSERT INTO lag_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ˆTʉkalʉmane kʉra Asóosi, tʉkaambʉkanʼya méeli fʉʉrʉ múuji wa Mituléene. ");
INSERT INTO lag_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Lomʉtóondo yaachwe tʉkakwaata njɨra, tʉkayeenda na méeli fʉʉrʉ ɨsɨ ya Kíio ˆngʼeene ɨjáa yarɨɨngɨrɨrwa nɨ maaji. Sikʉ ya katatʉ tʉkayeenda na méeli fʉʉrʉ ɨsɨ ya Sáamo ˆngʼeene ɨjáa yarɨɨngɨrɨrwa nɨ maaji, na sikʉ ya kanɨ tʉkafika múuji wa Miléeto. ");
INSERT INTO lag_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Mpɨɨndɨ ijo, Paúli ajáa alámwɨɨre atuube lʉyeendo lwaachwe na méeli baa tweera na múujii wa Eféeso tʉkʉ, sa adɨɨre chereva ʉko ɨsɨ ya Ásia. Asaakáa koonɨ viri dahɨka, afike Yerusaléemu sikʉ ya ngovi ya Pentekóste sɨ ɨnafika. ");
INSERT INTO lag_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mpɨɨndɨ Paúli ˆajáa Miléeto, akatʉma vaantʉ vadome na Eféeso, vakavaanɨrɨre vawosi va mpuka ya vaantʉ ˆvamuruma Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ˆVakʉʉje, maa akavasea, “Nyuunyu mʉmányire ˆvyeene niikala na nyuunyu fuma sikʉ ɨra ya ncholo ˆnalwaatya kʉʉlʉ kwaanɨ aha Ásia. ");
INSERT INTO lag_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Namʉtʉmamɨra Yéesu Mweenevyoosi kwa ʉholi woosi na nafumwáa nɨ miísoori. Nayimirirya uturikiri ʉra ˆwafumáa kwa Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mʉmányire sɨ navavisa isáare baa rɨmwɨ ˆrɨrɨ na kʉnáálo kwaanyu tʉkʉ. Na kei nɨjáa niitoola kʉvakiindya mbere ja mpuka ja vaantʉ na nyuumbii jaanyu. ");
INSERT INTO lag_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kɨɨntʉ ˆnoonekyáa kɨkomi nɨ kɨmwɨ kwa Vayahúudi na kwa vaantʉ sɨ ˆvarɨ Vayahúudi, voosi vareke ʉvɨ waavo vamʉvalandʉkɨre Mʉlʉʉngʉ na vamurume Mweenevyoosi wiitʉ, Yéesu Kirisitʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Haaha teeri, doma niise na Yerusaléemu ja ˆvyeene Mʉtɨma Mʉʉja yookʉʉnkulusirirya ndome. Na sɨ nootaanga viintʉ ˆviri kʉʉnfʉmɨra ʉko tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ˆCheene nootaanga vii nɨɨnɨ nɨ kɨra ˆnoolʉmwa kutu nɨ Mʉtɨma Mʉʉja kɨra múuji ˆmweene nootweera, kuchuungwa mʉnyololwii na uturikiri vimwaarɨ vyookʉʉngoojera. ");
INSERT INTO lag_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Maa kaa, kʉva nkaasʉ kwaanɨ sɨ kɨɨntʉ tʉkʉ. Kɨɨntʉ kɨkʉʉlʉ kwaanɨ nɨ kʉmarikirya mʉrɨmo ˆmweene naheewa nɨ Yéesu Mweenevyoosi, noo kʉsea, noonekye kɨkomi Masáare Maaja ya nduwo ya Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nɨɨnɨ nalookáa kɨra haantʉ noovavariyʉrɨra Ʉtemi wa Mʉlʉʉngʉ. Maa kaa, haaha natáangire, kusiina baa ʉmwɨ waanyu nyuunyu ˆakaanyɨɨne mpula na mʉlomo kei tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Sa jeyyo, nɨ kʉvawyɨɨra niise isikʉ, koonɨ ʉmwɨ waanyu arɨ́mɨɨre, sakami yaachwe sɨ ɨrɨ kʉva mweeri yaanɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nɨɨnɨ sɨ naneha na sɨ navisa kʉvavariyʉrɨra vyoosi Mʉlʉʉngʉ ˆasaakáa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mwiiyɨmɨrɨre nyuunyu veeneevyo, na mwɨɨmɨrɨre mpuka yoosi Mʉtɨma Mʉʉja ˆavavɨɨka nyuunyu mʉve viimiriri vaavo. Imiriri mpuka ya vaantʉ ˆvamuruma Mʉlʉʉngʉ. Yeeye avanunuula kwa sakami ya mwaana waachwe. ");
INSERT INTO lag_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Taanga niise, vakiindya va ʉloongo vara ˆvarɨ ja mbʉʉjɨ nkarɨ, kʉʉja varɨ nɨɨnɨ ˆndɨrɨ looka. Avo sɨ varɨ voonera mbavariri vaantʉ ˆvamuruma Yéesu tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na vamwɨ vaanyu nyuunyu veeneevyo, fʉmɨra varɨ vaantʉ ˆvakaluusire masáare ya ʉloongo, sa vavabweeyye vaantʉ ˆvamuruma Yéesu varɨmɨre na vavatuube voovo. ");
INSERT INTO lag_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Haaha, mʉndoolaanga neeja! Noosaaka mʉndookʉmbʉkɨra kwa myaaka ɨtatʉ sɨ nareka kʉvalʉma kutu vii kaa tʉkʉ, kɨra mʉʉntʉ kwa miísoori uchikʉ na muusi. ");
INSERT INTO lag_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Haaha, nɨ kʉvavɨɨka niise mbere ya wiimiriri wa Mʉlʉʉngʉ, na wa isáare ra nduwo yaachwe rɨra ˆrɨrɨ na ngururu yo vajeenga, na ˆrɨrɨ vaheera ʉpaari ˆavavɨɨkɨra nyuunyu hamwɨ na vara voosi vɨɨngɨ ˆvaava vaaja mbere ya Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nɨɨnɨ sɨ namerirya matɨ mpía, saháabu, na baa ɨngo ja mʉʉntʉ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nyuunyu veeneevyo mʉmányire ˆvyeene natʉmama na mɨkono yaanɨ sa mpate viintʉ ˆnasaakáa na viivaanɨ ˆvasaakáa. ");
INSERT INTO lag_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Na kwa viintʉ vyoosi nasaakáa kʉvalaɨra tasaakwa tʉndoofuma irʉtɨra ko tʉmama mɨrɨmo sa tʉndoopata viintʉ vyo vaambirirya vaantʉ vara ˆvasiina ngururu. Kei tʉndookʉmbʉkɨra masáare ya Yéesu Mweenevyoosi yara ˆalʉʉsa yeeye mweeneevyo, yoosea, ‘Ʉra ˆatóolaa atálariwaa kʉlookya ʉra ˆahókeraa.’” ");
INSERT INTO lag_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paúli ˆakahʉmʉle kʉlʉʉsa ayo, maa reerʉ, akachwaama hamwɨ na avo vaantʉ voosi akamʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Aho, voosi vakarɨra maatʉkʉ vii ko mʉkwaatɨrɨra no mʉsʉndɨra no kiiheera mɨkono yo kiiteengʉla na Paúli. ");
INSERT INTO lag_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Voosi mɨtɨma yaavo ɨkavalʉma, sa yara masáare ˆajáa alúusire sɨ varɨ moona kei vii kaa tʉkʉ. Aho, vakamʉsɨndɨkɨra fʉʉrʉ méelii. ");
INSERT INTO lag_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ˆTʉkahʉmʉle kwiiteengʉla novo, tʉkaambʉka méeli, maa tʉkatamanya fʉʉrʉ ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ˆɨséwaa Kóosi. Lomʉtóondo yaachwe ˆkʉkeere, tʉkayeenda na méeli fʉʉrʉ ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ˆɨséwaa Róodo. Kufuma aho, tʉkatamanya fʉʉrʉ múuji wa Patáara. ");
INSERT INTO lag_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ʉko, tʉkashaana méeli yɨɨngɨ yoofɨrɨra na ɨsɨ ya Foiníike, maa tʉkaambʉka. ");
INSERT INTO lag_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ˆTʉkafike sengerera na ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ˆɨséwaa Kúpuro na ˆtʉkaande kɨɨyona, tʉkaambalakana na ivaru ra saame fʉʉrʉ ɨsɨ ya Síria. Ʉko tʉkɨɨma múujii wa Tíiro kʉʉntʉ ɨra méeli ˆyakiimyáa miriwa yaachwe. ");
INSERT INTO lag_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ˆTʉkavasaakɨre vaantʉ ˆvamuruma Yéesu, tukiikala kwaavo kwa sikʉ mufungatɨ. Avo vakalʉʉsɨka ko longoolwa nɨ Mʉtɨma Mʉʉja. Vakiilomboola, voomʉsea Paúli adɨɨre tamanya na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Baa jeyyo, sikʉ jo kiikala aho ˆjikasire, maa tʉkakwaata njɨra. Vaantʉ voosi ˆvamuruma Yéesu va aho Tíiro, vaantʉ valʉme, vaantʉ vaki na vasinga vakatʉsɨndɨkɨra fʉʉrʉ weerwii ya múuji. Voosi tʉkachwaama hara mbarɨmbarɨ ya mayɨya, tʉkamʉloomba Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ˆTukiiteengʉle, maa tʉkaambʉka méeli, novo vakahɨndʉka na kaayii. ");
INSERT INTO lag_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kufuma Tíiro, tʉkatuuba lʉyeendo fʉʉrʉ múuji wa Tolemáai, ʉko tʉkavaluumbya vaaniitʉ na tukiikala novo kwa sikʉ ɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lomʉtóondo yaachwe, tukiinʉka, maa tʉkayeenda fʉʉrʉ Kaisaría. Ʉko, tʉkɨɨta kiikala kaayii kwa mʉvariyuli ʉmwɨ wa Masáare Maaja ˆasewáa Filíipi. Ʉhʉ Filíipi, nɨ ʉmwɨ wa vaantʉ mufungatɨ vara ˆvajáa vasaawʉlwa kʉra Yerusaléemu vandoolaanga valala. ");
INSERT INTO lag_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yeeye ajáa atɨɨte vahíínja vanɨ, ˆvajáa vanjalʉ, novo valaaláa na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Na ˆtukiikale aho kwa mpɨɨndɨ, mʉláali na mʉtwe ʉmwɨ ˆasewáa Agáabo akʉʉja fuma Yudéea. ");
INSERT INTO lag_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Agáabo akʉʉja, aho, akatoola mʉkandala wa Paúli, akiichuunga mɨkono na mawʉlʉ yaachwe, maa akasea, “Mʉtɨma Mʉʉja aséire, ‘Jei noo ˆvyeene Vayahúudi va Yerusaléemu varɨ muchuunga mweene ʉhʉ mʉkandala na aho, mʉkwaatya varɨ kwa vaantʉ sɨ ˆvarɨ Vayahúudi.’” ");
INSERT INTO lag_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ˆTʉkateere aya masáare, maa suusu hamwɨ na viiviiswi va aho Kaisaría, tʉkamʉkalaamya Paúli adɨɨre doma na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Maa kaa, Paúli akatʉsea, “Nɨ che moobweeyya? Amwɨ moorɨra sa moosaaka kuungʼuna mʉtɨma? Nɨɨnɨ sɨ kuchuungwa vii noo nookoofa tʉkʉ, baa koonɨ nɨ kʉʉlawa ʉko Yerusaléemu sa irina ra Yéesu Mweenevyoosi, nɨɨnɨ sɨ nookoofa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ˆTʉkoone Paúli sɨ yooteera kɨra ˆtoomuwyɨɨra, maa tʉkasea, “Kɨra Yéesu Mweenevyoosi ˆyoosaaka, ɨkyo kɨtʉmamwe.” ");
INSERT INTO lag_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Aya ˆyakalooke, tʉkatoola miriwa yiiswi, maa tʉkakwaata njɨra na Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Vamwɨ va vaantʉ ˆvamuruma Yéesu fuma Kaisaría vakatʉsɨndɨkɨra fʉʉrʉ kaayii kwa Mʉnasóoni, kʉʉntʉ ˆtɨɨtáa kiikala kwa mpɨɨndɨ. Mʉnasóoni nɨ mʉʉntʉ wa Kúpuro ajáa, na nɨ ʉmwɨ wa vaantʉ ˆvamuruma Yéesu va ncholo ajáa. ");
INSERT INTO lag_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ˆTʉkafike Yerusaléemu, vaaniitʉ vakatʉteengya na cheerʉ. ");
INSERT INTO lag_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lomʉtóondo yaachwe, Paúli akadomanʼya na suusu noo muluumbya Yaakúupu, na vawosi va mpuka ya vaantʉ ˆvamuruma Yéesu vajáa vamwaarɨ. ");
INSERT INTO lag_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Lʉmbɨ ˆjikalooke, maa Paúli akaanda vatamanʉrɨra kwa isáare rɨmwɨ rɨmwɨ yoosi Mʉlʉʉngʉ ˆabweeyya kwa vaantʉ sɨ ˆvarɨ Vayahúudi kwa mʉrɨmo waachwe. ");
INSERT INTO lag_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ˆVakateere masáare yoosi, vakamʉbweeyyirya Mʉlʉʉngʉ nkongojima, maa vakamʉsea Paúli, “Mwanawiitʉ, wɨɨ́ne ˆvyeene Vayahúudi mayana na mayana vamuruma Yéesu. Avo voosi vatúubaa na ngururu jaavo joosi Miiro. ");
INSERT INTO lag_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Maa kaa, vateera ˆvyeene ʉvakíindyaa Vayahúudi voosi ˆveene viíkalaa ɨsɨ ja vaantʉ sɨ ˆvarɨ Vayahúudi, vareke namatɨra Miiro ya Mʉ́sa. Vateera ˆvyeene ukíindyaa vareke vatwaala vaana vaavo na kɨbawii na vareke tʉʉva ja Kɨyahúudi. ");
INSERT INTO lag_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Haaha joolɨ tʉrɨ bweeyya? Na voovo kɨkomi vatáangire, wuújire. ");
INSERT INTO lag_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Haaha bweeyya ja ˆvyeene tookuwyɨɨra. Aha kwatɨɨte vamaka vanɨ ˆveene vamwiilaha Mweenevyoosi. ");
INSERT INTO lag_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Saangɨra novo, na wiijirʉle hamwɨ novo. Kei varɨhɨre mpía sa vakerwe njwɨɨrɨ jaavo. Sa jeyyo, vaantʉ voosi taanga varɨ yara masáare ˆvalʉ́ʉsaa sɨ ya kɨmáárɨ tʉkʉ, na weewe utúubaa Miiro. ");
INSERT INTO lag_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Maa kaa, kwa vaantʉ vara sɨ ˆvarɨ Vayahúudi ˆveene vamuruma Yéesu, tavaandɨkɨra ˆvyeene talamʉla, tʉkavasea, viikale kʉlɨ na kɨɨntʉ chochoosi ˆcheene chatoolwa ntambɨko kwa vidabalaíyo, kʉnywa sakami, kurya nyama ˆjakuvwa tʉkʉ na karɨ vahángutaa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Lomʉtóondo yaachwe, Paúli akavasʉmʉla vara vamaka, maa akɨɨta kiijirʉla novo. Aho, akɨɨngɨra hara Kaayii Njija ya Ijʉva, sa akalʉʉse sikʉ jo kiijirʉla ˆjiri hʉmʉla mpóryo ngʼeene jiri toolwa sa kɨra ʉmwɨ waavo. ");
INSERT INTO lag_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Sikʉ mufungatɨ jo kiijirʉla ˆjikasengerere sira, vamwɨ va Vayahúudi fuma ɨsɨ ya Ásia, vakamoona Paúli arɨ Kaayii Njija. Aho, vakɨɨsoonka mpuka ya vaantʉ voosi ˆvajáa aho, maa vakamʉkwaata Paúli. ");
INSERT INTO lag_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Vakaanda tʉla isóso voosea, “Arumi, vaantʉ va Isiraéeli, twaambiri! Ʉhʉ noo ʉra mʉʉntʉ ˆakíindyaa kɨra haantʉ, vaantʉ voosi vandootuchwa matɨ suusu Viisiraéeli na vandoochwa matɨ Miiro, baa na ɨhɨ Kaaya Njija. Kʉlookya ayo yoosi, abwéeyyiirye Kaaya Njija ɨve na njeo ko viingirya Vagiríki na waámii ya Kaaya Njija.” ");
INSERT INTO lag_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Valʉʉsa jeyyo, sa vajáa vamoona Tirofíimo, mʉʉntʉ wa Eféeso ˆarɨ hamwɨ na Paúli múujii Yerusaléemu, maa vakiisea Paúli ɨɨ́ngɨɨre ne na Kaayii Njija. ");
INSERT INTO lag_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Aho, múuji woosi ʉkava na ntiribʉka, vaantʉ fuma kɨra haantʉ vakʉʉja na waámii ya Kaaya Njija. Vakamʉkwaata Paúli, vakamurutya na weerwii, maa vakeeka mɨryaango ya Kaaya Njija chaangʉ. ");
INSERT INTO lag_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kati ˆvasaakáa kʉmʉʉlaa, mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valwi nkoondo va Kɨrúumi akapata mʉlomo, múuji woosi wa Yerusaléemu wavɨ́ɨre na ntiribʉka. ");
INSERT INTO lag_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Hahara ʉra mʉkʉ́ʉ́lʉ akavasʉmʉla vakʉ́ʉ́lʉ va valwi nkoondo, na valwi nkoondo, vakadoma itɨ́ɨjo na kʉrɨ ɨra mpuka ya vaantʉ. Novo ˆvakamoone ʉra mʉkʉ́ʉ́lʉ yookʉʉja na valwi nkoondo, maa vakareka kʉmʉvaa Paúli. ");
INSERT INTO lag_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Maa ʉra mʉkʉ́ʉ́lʉ akaseesa, akamʉkwaata Paúli, maa akalairirya achuungwe mɨnyololo ɨvɨrɨ. Maa akuurya, “Nɨ ani ʉhʉ? Na nɨ che abwéeyyiirye?” ");
INSERT INTO lag_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Hahara vara vaantʉ vakaanda tʉla isóso. Vɨɨngɨ valʉʉsáa ɨkɨ vɨɨngɨ kɨra, sa jeyyo ʉra mʉkʉ́ʉ́lʉ akadɨɨra taanga ˆchafʉmɨráa. Aho, akalairirya vamʉtwaale Paúli na nkambii ya valwi nkoondo. ");
INSERT INTO lag_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paúli ˆakafike mwaambukirwii wa ɨra nkambi, maa vara valwi nkoondo vakamwiinʉla kɨtangaritangaari sa ntiribʉka ya vaantʉ nɨ nkʉ́ʉ́lʉ ɨjáa. ");
INSERT INTO lag_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ɨra mpuka ˆngʼeene yamutuubáa, ɨkatuuba tʉla isóso yoosea, “Nɨ ʉʉlawe!” ");
INSERT INTO lag_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mpɨɨndɨ valʉkalʉka ˆvamwiingiryáa Paúli na aho nkambii ya valʉkalʉka, maa Paúli akamuurya ʉra mʉkʉ́ʉ́lʉ, “Eri, ifaanaa nɨkʉwyɨɨre isáare rɨmwɨ wʉʉ?” Maa ʉra mʉkʉ́ʉ́lʉ akamʉsea, “Kʉmba ʉlʉ́ʉsɨkaa Kɨgiríki? ");
INSERT INTO lag_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Weewe sɨ ʉrɨ ʉra Mʉmísiri ˆareeta ntiribʉka, maa akavalongoola vʉʉlai mayana yanɨ (4,000) na ɨsɨ ya ibaláángwii tʉkʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paúli akavasea, “Nɨɨnɨ ndɨrɨ Mʉyahúudi, fuma múuji mʉkʉʉlʉ wa Társo ˆʉrɨ ɨsɨ ya Kilikía. Nookʉloomba ndʉʉsɨke na ava vaantʉ.” ");
INSERT INTO lag_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ʉra mʉkʉ́ʉ́lʉ ˆakamʉrʉmɨre, Paúli hara mwaambukirwii akiinurirya mɨkono kʉvalaɨra vakirinye. ˆVakakirinye, maa akalʉʉsɨka novo kwa ndʉʉsɨka ya Kɨeburanía. ");
INSERT INTO lag_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Aho, maa akavasea, “Vandʉʉ vaanɨ, na vala taáta, teereri aya ˆnoolʉʉsa aha mbere yaanyu.” ");
INSERT INTO lag_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ˆVakateere Paúli yoolʉʉsɨka ndʉʉsɨka ya Kɨeburanía, maa vakakirinya sawu. Aho, maa Paúli akavasea, ");
INSERT INTO lag_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nɨɨnɨ ndɨrɨ Mʉyahúudi. Mɨɨtʉ nɨ Társo múuji mʉkʉʉlʉ wa ɨsɨ ya Kilikía. Baa jeyyo, nakʉrɨra aha Yerusaléemu. Na Gamaliéeli noo aankiindya vyoovyovyoovyo Miiro ya vala baaba wiitʉ ˆvatʉrekera. Namanyɨkáa na mʉtɨma waanɨ kʉmʉtʉmamɨra Mʉlʉʉngʉ ja ˆvyeene nyuunyu moobweeyya isikʉ. ");
INSERT INTO lag_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Navaturikirya na nʉʉláa vaantʉ ˆvatuubáa Njɨra ya Yéesu Mweenevyoosi. Nɨɨnɨ navakwaatáa vaantʉ valʉme na vaantʉ vaki na navachuungáa mʉnyololwii. ");
INSERT INTO lag_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Aya ˆnoolʉʉsa baa mweeneɨsɨ mʉkʉʉlʉ na Balása Nkʉʉlʉ ya Vayahúudi daha varɨ toola ʉshahíidi kʉrɨ nɨɨnɨ. Voovo noo vaampeera barʉ́wa jo twaala na kwa Vayahúudi viiviiswi ˆveene viikaláa múujii wa Damésiki, sa nɨvakwaate vaantʉ vara ˆvamuruma Yéesu. Aho, maa de nɨvareete na Yerusaléemu sa vaheewe irya raavo. ");
INSERT INTO lag_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Mpɨɨndɨ ˆnɨjáa njirii noodoma na Damésiki, jijáa ja mpɨɨndɨ ja mpoloonge na nɨjáa naséngerɨɨre fika, koonka kɨweerʉ kɨkʉʉlʉ fuma kurumwii, kɨkaamʉrɨka kosikosi. ");
INSERT INTO lag_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Haaho nkawya na ɨsɨ, maa nkateera sawúti yookʉʉnsea, ‘Saúli, Saúli sa che wookuunturikirya?’ ");
INSERT INTO lag_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Aho, maa nkuurya, ‘Aaɨ ʉrɨ ani weewe?’ Noyo ɨkaansea, ‘Nɨɨnɨ ndɨrɨ Yéesu wa Nasaréeti. Weewe wookuunturikirya.’ ");
INSERT INTO lag_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Viivaanɨ ˆnɨjáa novo, voona kɨra kɨweerʉ, maa kaa, ɨra sawúti sɨ vataanga kɨra ˆyalʉʉsáa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Aho, maa nkuurya, ‘Joolɨ ndɨrɨ bweeyya Mʉkʉ́lʉ?’ Ne Mweenevyoosi akaansea, ‘Inʉka, ʉdome na Damésiki, ʉko ko wyɨɨrwa ʉrɨ mɨrɨmo yoosi ˆnakwiímiriirye neeja.’ ");
INSERT INTO lag_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Na sa viintʉ kɨra kɨweerʉ kɨjáa chadalava mʉnʉmʉʉnʉ, nkasiindwa koona, viivaanɨ vakaankwaata mʉkono, vakaanongoola fʉʉrʉ Damésiki. ");
INSERT INTO lag_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Aho, kʉjáa kwatɨɨte mʉʉntʉ ʉmwɨ ˆasewáa Ananía. Ʉhʉ Ananía ajáa akwaatya kɨkomi Miiro yiitʉ na anyemiwáa nɨ Vayahúudi vara ˆviikaláa Damésiki. ");
INSERT INTO lag_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Akʉʉja noo kʉʉnaanga, akɨɨma heehi na nɨɨnɨ, maa akaansea, ‘Saúli mwanawiitʉ, pata ngururu jo koona kei!’ Na mpɨɨndɨ ɨʼɨra nkamoona Ananía. ");
INSERT INTO lag_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Aho, Ananía akaansea, ‘Mʉlʉʉngʉ wa vala baaba wiitʉ akʉsáawɨɨre weewe, sa ʉtaange yara ˆyoosaaka, ʉmoone Yéesu ʉra Mʉwoloki na ʉteere sawúti yaachwe mweeneevyo. ");
INSERT INTO lag_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Sa weewe kʉva ʉrɨ ʉra ˆoona kwa vaantʉ voosi kwa ayo ˆwoona na ˆʉyateera. ");
INSERT INTO lag_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Haaha che de woowoojera? Inʉka, ʉbatisiwe na ʉvɨ waako wooyyiwe kʉnʉ wooriruma irina raachwe.’ ");
INSERT INTO lag_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Aho, maa nkahɨndʉka na Yerusaléemu. Na mpɨɨndɨ ˆnamʉloombáa Mʉlʉʉngʉ Kaayii Njija ya Ijʉva, maa nkoona njori. ");
INSERT INTO lag_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Aho njorii, nkamoona Yéesu Mweenevyoosi yookʉʉnsea, ‘Inʉka chaangʉ fuma aha Yerusaléemu, sa aha sɨ varɨ ruma vira ˆvyeene wookʉʉnyonekya kwaavo tʉkʉ.’ ");
INSERT INTO lag_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Naanɨ nkamʉsea, ‘Ee Mweenevyoosi, voovo vamányire kɨkomi ˆvyeene nadomáa na masinagóogii noo vakwaata, ˆvyeene navaváa na ˆvyeene navavɨɨkáa mɨnyololwii vara ˆvakuruma. ");
INSERT INTO lag_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Baa sikʉ ɨra sakami ya Sitefáani shahíidi waako ˆyiítirwe, nɨɨnɨ nɨjáa mwaarɨ niímire aho, na nɨjáa naruma kɨra ˆvatʉmamáa. Nɨɨnɨ noonɨɨmɨrɨráa ɨngo ja vara ˆvamʉʉlaa.’ ");
INSERT INTO lag_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Aho, maa Yéesu Mweenevyoosi akaansea, ‘Tamanya! Kʉtʉma niise na kʉlɨ, kwa vaantʉ sɨ ˆvarɨ Vayahúudi.’” ");
INSERT INTO lag_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Masáare ayo yoosi ya Paúli, vaantʉ vajáa vayateerera. Maa kaa, ˆakalʉʉse aya, vakamʉkerya ko tʉla isóso voosea, “Mʉʉntʉ ʉhʉ yoosaakwa arɨmɨre aha weerwii! Ʉhʉ yoosaakwa akwye!” ");
INSERT INTO lag_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Vakatuuba tʉla isóso, noo kiikuusirirya irʉrɨ kʉnʉ vooriingirirya nyweénda jaavo mweeri. ");
INSERT INTO lag_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Aho, ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valwi nkoondo akalairirya Paúli iingiriwe na nkambii ya valwi nkoondo. Akalairirya uuriiwe ko nʉswa na mɨjeléedi, sa alʉʉse nɨ sa che Vayahúudi voomʉtʉrɨra isóso. ");
INSERT INTO lag_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Maa kaa, kati ˆvamuchuungáa na lʉkova sa vamʉnʉse, Paúli akamuurya mʉkʉ́ʉ́lʉ wa valwi nkoondo ˆajáa iímire aho, akamʉsea, “Eri, Miiro yaruma nyuunyu kʉmʉnʉsa Mʉrúumi ˆmweene sɨ analamʉrɨrwa wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo ˆakateere jeyyo, maa akatamanya noo muwyɨɨra ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ, akamʉsea, “Che ɨkɨ woosaaka ʉbweeyye? Ʉhʉ mʉʉntʉ nɨ Mʉrúumi!” ");
INSERT INTO lag_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Hara ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ akatamanya na kʉrɨ Paúli, maa akamuurya, “Ngwyɨɨra, weewe ʉrɨ Mʉrúumi wʉʉ?” Paúli akamʉsea, “Hɨɨ! Nɨɨnɨ ndɨrɨ Mʉrúumi.” ");
INSERT INTO lag_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ akamʉsea, “Nɨɨnɨ naava Mʉrúumi ko toola mpía ˆjiri foo mʉnʉmʉʉnʉ.” Maa kaa, Paúli akamʉsea, “Nɨɨnɨ ndɨrɨ Mʉrúumi ko vyaalwa.” ");
INSERT INTO lag_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Hahara vara valʉkalʉka ˆvasaakáa kumuurya ko mʉnʉsa, vakalooka chaangʉ, vakamʉreka Paúli. Ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valʉkalʉka ˆakataange Paúli nɨ Mʉrúumi, akakwaatwa nɨ woowa, sa viintʉ ˆajáa amuchúungire na mɨnyololo. ");
INSERT INTO lag_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lomʉtóondo yaachwe, ʉra mʉkʉ́ʉ́lʉ wa valʉkalʉka akalairirya vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na Balása Nkʉʉlʉ ya Vayahúudi valʉmane. Abweeyya jeyyo, sa asaakáa ataange kɨkomi nɨ sa che Vayahúudi vamusítakiirye Paúli. Jeyyo, akamʉchʉngʉla Paúli mʉnyololo, akamʉreeta, maa akamwiimya mbere ya Balása ɨyo. ");
INSERT INTO lag_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Aho, Paúli akiituurirya miiso Balása ɨyo yoosi, maa akavasea, “Vanaviitʉ, nɨɨnɨ fʉʉrʉ isikʉ niíkalaa mbere ja Mʉlʉʉngʉ na mʉtɨma waanɨ sɨ waantwáalaa na kɨloongii tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananía mweeneɨsɨ mʉkʉʉlʉ ˆakateere jeyyo, maa akalairirya vara ˆvajáa heehi na Paúli vamʉhapʉle mʉlomwii. ");
INSERT INTO lag_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Aho, maa Paúli akamʉsea, “Baa weewe mʉkweembi ʉrɨ ja lʉkaande ˆlwahakwa chokáa, Mʉlʉʉngʉ kʉkʉvaa arɨ. Weewe wiíkyɨɨrye aho, sa ʉlamʉle ko tuuba Miiro, amwɨ de weewe wookɨɨkana Miiro ko lairirya hapʉlwe?” ");
INSERT INTO lag_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Aho, maa vara vaantʉ ˆvajáa viímire heehi na Paúli, vakamʉsea, “Eri, nɨ mʉtʉkɨra wiise mweeneɨsɨ mʉkʉʉlʉ wa Mʉlʉʉngʉ wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paúli akavasea, “Vanaviitʉ, sɨ natáangire koonɨ nɨ mweeneɨsɨ mʉkʉʉlʉ tʉkʉ. Sa Masáare ˆYarɨ Mpeho yalʉʉsa, ‘Karɨ ʉlʉ́ʉsaa mavɨ kwa mʉkʉ́ʉ́lʉ wa vaantʉ vaanyu tʉkʉ.’” ");
INSERT INTO lag_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Na Paúli ˆakataange aho Balásii kʉjáa kwatɨɨte Masadukáayo na Mafarisáayo, maa akalʉʉsɨka na ngururu yoosea, “Vanaviitʉ, nɨɨnɨ ndɨrɨ Mʉfarisáayo, mwaana wa Mafarisáayo. Naréetirwe na aha Balásii sa niiláangyaa vaantʉ ˆvaakwya fʉfʉka varɨ.” ");
INSERT INTO lag_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Paúli ˆakalʉʉse jeyyo, maa ntiribʉka ikiinʉka katɨ na katɨ ya Mafarisáayo na Masadukáayo. Aho, maa vakiikera havɨrɨ. ");
INSERT INTO lag_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sa Masadukáayo vaséaa kusiina kʉfʉfʉka tʉkʉ, na baa kei sɨ varúmaa koonɨ mirimʉ miija na mɨtɨma ɨmwaarɨ tʉkʉ, maa kaa, Mafarisáayo varúmaa aya yoosi.) ");
INSERT INTO lag_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kʉra kwiiruta ndihi kwa vara vakʉ́ʉ́lʉ kʉkakonkomala mʉnʉmʉʉnʉ na isóso ikʉʉlʉ. Vamwɨ va vakiindya va Miiro ˆveene vajáa nɨ va mpuka ya Mafarisáayo, vakɨɨma, maa vakasiita na ngururu voosea, “Sɨ tookoona ʉvɨ wowoosi kʉrɨ ʉhʉ mʉʉntʉ tʉkʉ! Ifaanaa ɨkava murimʉ mʉʉja au mʉtɨma walʉ́ʉsɨkɨre ne.” ");
INSERT INTO lag_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ɨra nkoondo ɨkakʉla, mpaka ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valwi nkoondo akakwaatwa nɨ woowa, akiisea ifaanaa vamʉdʉmʉledʉmʉle Paúli. Aho, akalairirya valwi nkoondo vɨɨngɨrɨre na katɨ na katɨ ya Vayahúudi sa vamʉlamurirye na ngururu, na vamʉtwaale na nkambii ya valwi nkoondo, novo vakabweeyya jeyyo. ");
INSERT INTO lag_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Uchikʉ wa sikʉ ɨyo, Yéesu Mweenevyoosi akɨɨma heehi ne akamʉsea, “Iheere mʉtɨma! Ja ˆvyeene woonekiirye kɨkomi cha masáare yaanɨ aha Yerusaléemu, bweeyya ʉrɨ viivyo baa ʉko múujii wa Róoma.” ");
INSERT INTO lag_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ˆKʉkeere, Vayahúudi vakabweeyya nchuungo, voosi vakiirʉmɨra, ko kwiilaha varɨɨwe nɨ salʉ, sɨ varɨ kurya no nywa tʉkʉ mpaka haantʉ ˆvarɨ kʉva vamʉʉ́laire Paúli. ");
INSERT INTO lag_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Na vaantʉ ˆveene vajáa vabweeyya ɨyo nchuungo nɨ makumi yanɨ (40) na kɨɨntʉ vajáa. ");
INSERT INTO lag_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Vakadoma na kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na kwa vawosi, maa vakasea, “Twiilahíre, sɨ tʉrɨ kurya no nywa tʉkʉ mpaka tʉve tamʉʉ́laire Paúli. ");
INSERT INTO lag_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Haaha nyuunyu na vawosi va Balása Nkʉʉlʉ ya Vayahúudi mʉloombi mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ amʉreete Paúli na kʉrɨ nyuunyu. Ibweeyyi ja moosaaka taanga neeja masáare yaachwe ˆmʉmʉréetɨɨre na mbere yaanyu. Suusu tɨɨ́mɨre neeja kʉmʉʉlaa baa sɨ anafika aha.” ");
INSERT INTO lag_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ɨyo nchuungo, mwiihwa wa Paúli akava ɨɨtéɨɨre, maa akatamanya, akamuwyɨɨra Paúli kʉra nkambii ya valwi nkoondo. ");
INSERT INTO lag_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Hahara, Paúli akamwaanɨrɨra ʉmwɨ wa vakʉ́ʉ́lʉ va valwi nkoondo, akamʉsea, “Mʉtwaale ʉhʉ mʉtavana na kwa mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valwi nkoondo, atɨɨte isáare ˆyoosaaka amʉlʉme kutu.” ");
INSERT INTO lag_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Aho, ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo akamʉtwaala ʉra mʉtavana na kwa mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valwi nkoondo, maa akamʉsea, “Paúli ʉra ˆarɨ mʉnyololwii, aanyánɨrɨɨre na aanoómbire nɨmʉreete ʉhʉ mʉtavana na kwaako, sa atɨɨte isáare ˆyoosaaka akuwyɨɨre.” ");
INSERT INTO lag_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ, akamʉkwaata mʉkono ʉra mʉtavana, maa akatamanya ne na ivarwii, maa akamuurya, “Nɨ kɨɨntʉ che ˆwoosaaka wʉʉngwyɨɨre?” ");
INSERT INTO lag_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ʉra mʉtavana akamʉsea, “Vayahúudi viirʉ́mɨɨre vakʉloombe weewe ʉmʉtwaale Paúli na mbere ya Balása Nkʉʉlʉ ya Vayahúudi lomʉtóondo sa vookiisaambirirya voosaaka vamuurye neeja masáare yaachwe. ");
INSERT INTO lag_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Maa kaa, karɨ ʉvarʉmɨre tʉkʉ, sa vamwaarɨ Vayahúudi makumi yanɨ (40) na kɨɨntʉ ˆvarɨ mugiida njirii. Ava viílahire varɨɨwe nɨ salʉ, sɨ varɨ kurya no nywa tʉkʉ mpaka vamʉʉlae Paúli. Haaha viímire neeja vooteerera vii, nɨ che ˆʉrɨ lʉʉsa.” ");
INSERT INTO lag_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Aho, ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ akamʉrekera ʉra mʉtavana atamanye na akamʉkaanʼya, yoomʉsea, “Karɨ umuwyɨ́ɨraa mʉʉntʉ yoyoosi aya masáare ˆwʉʉngwyɨ́ɨrɨɨre tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Aho, maa ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ akavaanɨrɨra vakʉ́ʉ́lʉ va valwi nkoondo vavɨrɨ akavasea, “Imyi neeja valwi nkoondo magana yavɨrɨ (200) vooyeenda na mawʉlʉ, valwi nkoondo ˆvaámbʉkaa faráasi makumi mufungatɨ (70), na vɨɨngɨ magana yavɨrɨ (200) ˆvarɨ na machimu. Ava voosi viinʉke mpɨɨndɨ jo kaala ndɨrɨ kugirita na múuji wa Kaisaría. ");
INSERT INTO lag_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kei, imyi neeja faráasi jɨɨngɨ sa Paúli, na mʉmʉtwaale nkaasʉ fʉʉrʉ kwa gávana Felíisi.” ");
INSERT INTO lag_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ʉra mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valwi nkoondo akaandɨka barʉ́wa, yoosea, ");
INSERT INTO lag_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Felíisi ˆʉnyémiwaa, gávana wa ɨsɨ, nɨɨnɨ Kɨlaáudi Lísia, nakulúumbiirye. ");
INSERT INTO lag_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ʉhʉ mʉʉntʉ akwaatwa nɨ Vayahúudi, voovo vajáa vaséngerɨɨre kʉmʉʉlaa. Maa kaa, ˆnkataange yeeye nɨ Mʉrúumi nɨɨta noo mʉlamurirya na valwi nkoondo vaanɨ. ");
INSERT INTO lag_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nasaakáa ntaange nɨ sa che vamusitaakyáa Paúli, sa jeyyo, nkamʉtwaala na mbere ya Balása Nkʉʉlʉ ya Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Hahara, nkataanga vamʉtwáarire na balásii sa masáare ya Miiro yaavo. Baa jeyyo, kʉjáa kusiina isáare roroosi ˆroobweeyya ɨɨme neeja kukwya au baa achuungwe mʉnyololwii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Haaha nalúmirwe kutu nɨ mʉʉntʉ ʉmwɨ, vamwaarɨ Vayahúudi ˆvaríire nchuungo yo mʉʉlaa, sa jeyyo, nalámwɨɨre chaangʉ valʉkalʉka vamʉreete na kwaako. Navaséire vaantʉ vaachwe vara ˆvamʉreeta na balásii vareete masáare yaachwe na kwaako.” ");
INSERT INTO lag_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Jeyyo, valwi nkoondo vakamʉsʉmʉla Paúli ja ˆvyeene vajáa valáiririiwe, vakamʉtwaala uchikʉ ʉʼʉra fʉʉrʉ múuji wa Antipáatiri. ");
INSERT INTO lag_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lomʉtóondo yaachwe, vara valwi nkoondo ˆvayéendaa na mawʉlʉ, vakavarekera vara valwi nkoondo ˆvajáa vaámbukire faráasi vadomanʼye na Paúli, maa voovo vakahɨndʉka na nkambii. ");
INSERT INTO lag_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Vara valʉkalʉka ˆvaámbʉkaa faráasi ˆvakafike Kaisaría, vakamʉheera gávana ɨra barʉ́wa baa Paúli vakamʉkwaatya kwa gávana. ");
INSERT INTO lag_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ˆAkahʉmʉle kʉsoma ɨra barʉ́wa, maa akavuurya, “Ʉhʉ mʉʉntʉ nɨ wa ɨsɨ che?” ˆAkataange nɨ mʉʉntʉ wa Kilikía, ");
INSERT INTO lag_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","maa akamʉsea, “Teerera ndɨrɨ sáare jaako mpɨɨndɨ ˆvarɨ kʉʉja vara ˆvakʉreeta na balásii.” Aho, maa akalairirya Paúli avɨɨkwe ɨsɨ ya ʉlaangiriryi ijuumbii ra kɨtemi ra Heróode. ");
INSERT INTO lag_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sikʉ isaano ˆjikalooke, Ananía mweeneɨsɨ mʉkʉʉlʉ, akagiritanʼya na Kaisaría na vawosi va Vayahúudi na mʉʉntʉ ʉmwɨ, mʉmanyi wa Miiro ˆasewáa Teritúulo. Avo, vakatwaala kɨloongi cha Paúli na kwa gávana. ");
INSERT INTO lag_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paúli ˆakaanɨrɨrwe, Teritúulo akaanda kumusitaakya Paúli yoosea, “Felíisi ˆʉnyémiwaa, ʉlongooli waako ˆwabooha waámbiriirye twiikale na cheerʉ na twiikale mwiikalo mʉʉja kwa sikʉ joosi iji, baa kei, viintʉ vyoovalandʉka kʉrɨ ɨsɨ ɨhɨ sa viintʉ ˆwoónaa mbere. ");
INSERT INTO lag_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Felíisi ˆʉbwéeyyiriwaa nkongojima, sikʉ joosi na kɨra haantʉ, tayahókeraa aya na dʉʉmbɨ mʉnʉmʉʉnʉ. ");
INSERT INTO lag_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nɨɨnɨ sɨ noosaaka nikuriingirirye tʉkʉ. Nookʉloomba kwa uyimiriryi waako ʉyateerere aya masáare yiiswi yangaɨ vii. ");
INSERT INTO lag_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tamwɨɨ́ne mʉʉntʉ ʉhʉ nɨ irema ikʉʉlʉ. Kɨra ɨsɨ ˆkʉrɨ na Vayahúudi, yeeye noo iinʉláa ntiribʉka. Yeeye noo mʉkʉ́ʉ́lʉ wa díini ya ʉloongo ya Vanasaréeti. ");
INSERT INTO lag_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Yeeye asaakáa kwiibweeyya Kaaya Njija ya Ijʉva ɨve na njeo, maa kaa, suusu tamʉkwaata chaangʉ. Tasaakáa kʉmʉlamʉrɨra kwa Miiro yiiswi, ");
INSERT INTO lag_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","maa kaa, Lísia mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valʉkalʉka akʉʉja noo tʉhoka na ngururu. ");
INSERT INTO lag_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Akavalairirya vara ˆvamusitaakyáa vamʉreete na kwaako. Weewe mweeneevyo koonɨ umuchúkurumire taanga ʉrɨ masáare yoosi ˆtoomusitaakya kwaako, nɨ ya kɨmáárɨ.” ");
INSERT INTO lag_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Vayahúudi voosi vakalumirirya masáare ya Teritúulo voosea, ayo yoosi nɨ ya kɨmáárɨ. ");
INSERT INTO lag_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Aho, maa gávana Felíisi akamooloota Paúli sa ne alʉʉsɨke. Aho, Paúli akaanda lʉʉsɨka yoosea, “Kwiitetera niise kwa mʉtɨma mweerʉ sa taanga niise weewe ʉrɨ mʉlamuli wa vaantʉ wa ɨsɨ ɨhɨ kwa myaaka ˆɨrɨ foo. ");
INSERT INTO lag_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Weewe mweeneevyo koona ʉrɨ nɨ sikʉ ikimi na ivɨrɨ vii jalóokire keende ˆnaambʉka na Yerusaléemu noo ko mwiinamɨra Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Vaantʉ ava sɨ vaanshaana nookiiruta ndihi na mʉʉntʉ yoyoosi au noosoonka mpuka ya vaantʉ tʉkʉ. Ɨve nɨ Kaayii Njija, sinagóogii, au baa haantʉ hɨɨngɨ hohoosi kʉra múujii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Masáare aya ˆvakɨtookʉʉnvɨɨkɨra kɨloongi sɨ varɨ daha laɨra kɨkomi nɨ ya kɨmáárɨ tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Baa neembe nɨ jeyyo, nɨɨnɨ narúmire namwiínamɨraa Mʉlʉʉngʉ wa vala baaba na nasáakɨraa Njɨra ya Yéesu Mweenevyoosi ˆngʼeene ava voosea nɨ ya ʉloongo. Baa kei, nayaruma yoosi ˆyarɨ Miirwii na yoosi ˆyaandɨkwa vitáabwii vya valáali na mʉtwe. ");
INSERT INTO lag_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Sɨ ayo vii tʉkʉ, kei, niiláangyaa kwa Mʉlʉʉngʉ ja ˆvyeene vaantʉ ava viiláangyaa Mʉlʉʉngʉ vafʉfʉla arɨ vaantʉ voosi, vawoloki na sɨ ˆvarɨ vawoloki. ");
INSERT INTO lag_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Sa jeyyo, namanyɨka sikʉ joosi nɨve na mʉtɨma sɨ ˆwʉʉntwáalaa na kɨloongii mbere ja Mʉlʉʉngʉ na vaantʉ. ");
INSERT INTO lag_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Haaha ˆnkiikale kwɨɨngɨ kwa myaaka ˆɨrɨ foo, nahɨndʉka na Yerusaléemu, sa ndeete mpía jo vaambirirya vakɨva va ɨsɨ yaanɨ na ntoole mpóryo kwa Mʉlʉʉngʉ. ");
INSERT INTO lag_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kati vaantʉ ava ˆvaanshaanáa noobweeyya aya waámii ya Kaaya Njija, nɨjáa nahʉ́mwɨɨre tʉmama tʉʉva yo jirʉlwa. Na baa sɨ vaanshaana ndɨrɨ na mpuka ya vaantʉ tʉkʉ na baa sɨ nabweeyyáa ntiribʉka tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Baa jeyyo, kwatɨɨte Vayahúudi vɨɨngɨ fuma ɨsɨ ya Ásia, avo nookoona ngaarɨ vaveere mbere yaako sa valʉʉse koonɨ varɨ na kɨloongi na koonɨ varɨ na kɨɨntʉ chochoosi na nɨɨnɨ. ");
INSERT INTO lag_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Au voovo ava ˆvarɨ aha, nɨ valʉʉse nɨ ʉvɨ che ˆvoona kʉrɨ nɨɨnɨ mpɨɨndɨ ˆnɨjáa niimiiwé mbere ya Balása Nkʉʉlʉ ya Vayahúudi? ");
INSERT INTO lag_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ifaanaa ɨkava voona kwa ɨkɨ kɨɨntʉ kɨmwɨ ˆnalʉʉsa kwa sawúti nkʉʉlʉ mbere yaavo noosea, ‘Naréetirwe na aha balásii sa viintʉ ˆnarúmaa vaantʉ ˆvaakwya fʉfʉlwa varɨ.’” ");
INSERT INTO lag_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Maa kaa, Felíisi ajáa amányire neeja Njɨra ya Yéesu Mweenevyoosi, akadɨɨra lamʉla kɨloongi ɨkyo yoosea, “Lamʉla ndɨrɨ masáare aya mpɨɨndɨ Lísia mʉkʉ́ʉ́lʉ wa vakʉ́ʉ́lʉ va valwi nkoondo ˆarɨ girita na kʉnʉ.” ");
INSERT INTO lag_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Aho, maa akalairirya mʉkʉ́ʉ́lʉ wa valwi nkoondo amʉvɨɨke Paúli mʉnyololwii, maa kaa, andoomʉheera nkalo, baa vijeengi vyaachwe andoovarekera vamʉtʉmamɨre. ");
INSERT INTO lag_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Sikʉ ingaɨ vii ˆjikalooke, Felíisi akʉʉja na muki waachwe Durusíila. Ʉhʉ Durusíila nɨ Mʉyahúudi ajáa. Felíisi akatʉma vamʉreete Paúli. Paúli ˆakʉʉje akaanda vawyɨɨra kumuruma Kirisitʉ Yéesu. ");
INSERT INTO lag_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mpɨɨndɨ ˆalʉʉsɨkɨráa ʉwoloki mbere ya Mʉlʉʉngʉ, kwiiyɨmɨrɨra, na Mʉlʉʉngʉ luu valamʉrɨra arɨ vaantʉ sikʉ yo kiimikirirya, Felíisi akoofa, aho, akamʉsea Paúli, “Haaha doma, kʉkwaanɨrɨra ndɨrɨ kei koonɨ napátire nkalo.” ");
INSERT INTO lag_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mpɨɨndɨ jiijo, Felíisi iiseáa heewa arɨ mpía ja ʉhoondo nɨ Paúli. Sa jeyyo, andoomwaanɨrɨra Paúli kweene kweene sa alʉʉsɨke ne. ");
INSERT INTO lag_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Myaaka ɨvɨrɨ ˆɨkalooke, Porikío Feésto akakwaata nkalo ya Felíisi. Na Felíisi asaakáa aveerye mɨtɨma Vayahúudi, sa jeyyo akamʉreka Paúli mʉnyololwii. ");
INSERT INTO lag_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Sikʉ itatʉ ˆjikalooke keende gávana Feésto ˆafika Kaisaría, akaambʉka fʉʉrʉ Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mpɨɨndɨ ˆajáa ʉko Yerusaléemu, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vakʉ́ʉ́lʉ va Vayahúudi, vakadoma na kʉʉntʉ ˆajáa sa vakamuwyɨɨre kɨloongi cha Paúli. ");
INSERT INTO lag_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Viiloombereryáa maatʉkʉ kwa Feésto ahʉʉngɨre ivaru raavo voosea, “Tooloomba ʉmʉhɨndʉle Paúli na Yerusaléemu!” Valʉʉsa jeyyo, sa vajáa varíire nchuungo vamugiide njirii, maa vamʉʉlae. ");
INSERT INTO lag_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Maa kaa, Feésto akavasea, “Paúli amwaarɨ mʉnyololwii ʉko Kaisaría, na nɨɨnɨ hɨndʉka niise na ʉko sikʉ ingaɨ vii ˆjookʉʉja.” ");
INSERT INTO lag_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Kei akavasea, “Saaka niise ntamanyanʼye na vamwɨ va vakʉ́ʉ́lʉ vaanyu ndomanʼye novo, vakalʉʉse kɨloongi chaachwe koonɨ kʉrɨ na ʉvɨ wowoosi ˆabweeyya.” ");
INSERT INTO lag_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Feésto akiikala na vaantʉ avo kwa sikʉ inaanɨ fʉʉrʉ ikimi, maa de akahɨndʉka na Kaisaría. ˆAkahɨndʉke, lomʉtóondo yaachwe ˆkʉkeere, akadoma na balásii, akiikala ichuumbii raachwe ro lamʉrɨra, maa akalairirya Paúli areetwe na mbere yaachwe. ");
INSERT INTO lag_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paúli ˆakafike hara, akavashaana Vayahúudi vara ˆvajáa vagirita fuma Yerusaléemu. Vakamʉrɨɨngɨrɨra, maa vakaanda kumusitaakya masáare maruto ˆyarɨ foo, baa jeyyo vakasiindwa koonekya kɨmáárɨ chaachwe. ");
INSERT INTO lag_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Aho, maa Paúli akiilʉʉsɨra, yoosea, “Nɨɨnɨ sɨ nabweeyya kɨɨntʉ kɨvɨ kʉrɨ Miiro ya Vayahúudi tʉkʉ, kʉrɨ Kaaya Njija ya Ijʉva tʉkʉ, baa kʉrɨ Kaisáari mʉtawáala wa Rúumi tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Maa kaa, sa viintʉ Feésto asaakáa kʉveerya mɨtɨma Vayahúudi, aho, maa akamuurya Paúli, “Eri, saaka wiise aya masáare nkayadʉmʉrɨre ʉko Yerusaléemu wʉʉ?” ");
INSERT INTO lag_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paúli akamʉsea, “Aha kʉʉntʉ ˆniímire, nɨ balásii ya Kaisáari, aha noo kʉʉntʉ ʉlamuli waanɨ wa Miiro ˆwoosaakwa ʉtoorerwe. Weewe mweeneevyo kiiyonera wiise, kisiina kɨɨntʉ ˆnahonʼya kwa Vayahúudi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Sa jeyyo, koonɨ kɨkomi natʉmama ʉvɨ ˆmweene inkwya noo kɨɨntʉ ˆchaantéire, nɨɨnɨ sɨ noosiita kukwya tʉkʉ. Maa kaa, koonɨ ɨkɨ kɨloongi chareetwa nɨ ava Vayahúudi sɨ cha kɨmáárɨ, kusiina mʉʉntʉ ˆarɨ na wiimiriri wo kʉʉnkwaata na aankwaatye mɨkonwii yaavo tʉkʉ. Nooloomba ɨrɨ isáare rɨkateererwe nɨ Kaisáari!” ");
INSERT INTO lag_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Feésto ˆakahʉmʉle kwiilaangya sáare na balása yaachwe, maa akamʉsea Paúli, “Wakérire rufáa kɨloongi chaako kɨkateererwe nɨ Kaisáari! Haaha doma ʉrɨ na kwa Kaisáari!” ");
INSERT INTO lag_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Sikʉ ngala ˆjikalooke, mʉtemi Agiríipa na Beriníike irʉʉmbʉ raachwe vakʉʉja na Kaisaría sa jivoonekye nyemi jaavo kwa Feésto. ");
INSERT INTO lag_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Vakiikala ʉko Kaisaría kwa sikʉ ˆjiri foo. Sikʉ ijo, Feésto akamuwyɨɨra mʉtemi kɨloongi cha Paúli yoomʉsea, “Kwatɨɨte mʉʉntʉ ʉmwɨ aha ˆarekwa mʉnyololwii nɨ Felíisi. ");
INSERT INTO lag_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na ˆnkadome na Yerusaléemu, vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva na vawosi va Vayahúudi vajáa vaangwyɨɨra kɨɨntʉ ˆchabweeyya vamʉtwaale Paúli na balásii, na vaanoomba nɨmʉlamʉrɨre atɨɨte ʉvɨ. ");
INSERT INTO lag_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Maa kaa, nɨɨnɨ navasea, suusu Varúumi sɨ takwáatyaa mʉʉntʉ mɨkonwii ya vara ˆvamusitaakya tʉkʉ, koonɨ sɨ analʉmana na vara ˆvamʉtwaala na balásii, na sɨ anaheewa nkalo yo kiitetere tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Haaha avo vakʉ́ʉ́lʉ ˆvakalʉmane aha, sɨ nachereva tʉkʉ. ˆNkafike, lomʉtóondo yaachwe, nkaanɨrɨra valamuli na balásii, maa nkiikala ichuumbii raanɨ ro lamʉrɨra. Aho, maa nkalairirya Paúli areetwe. ");
INSERT INTO lag_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ˆAkareetwe, vara ˆveene vamusitaakyáa, vakaanda mʉlʉʉsɨra. Baa jeyyo, masáare ˆmeene valʉʉsáa sɨ yajáa mavɨ ja ˆvyeene niiseáa tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kɨɨntʉ ˆviirʉtɨráa ndihi, nɨ sa masáare ya díini yaavo vii, na sa masáare ya mʉʉntʉ ʉmwɨ ˆmweene ajáa aakwya irina raachwe noo Yéesu. Ʉhʉ mʉʉntʉ Paúli uumiriryáa ɨndoosea nɨ mooyo arɨ. ");
INSERT INTO lag_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nɨɨnɨ nasova njɨra yo yatʉʉbɨrɨra sa ntaange koonɨ aya masáare nɨ ya kɨmáárɨ. Sa jeyyo, nɨɨnɨ namuurya Paúli koonɨ arɨ ruma kʉdoma na Yerusaléemu sa akalamʉrɨrwe ʉko. ");
INSERT INTO lag_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Maa kaa, Paúli ˆakaloombe rufáa achaale mʉnyololwii kʉwoojera kɨloongi chaachwe kɨkateererwe nɨ Kaisáari mʉtemi mʉkʉʉlʉ, nɨjáa nalairirya alaangiririwe aho mʉnyololwii, fʉʉrʉ mpate njɨra yo mʉtwaala na kwa Kaisáari.” ");
INSERT INTO lag_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Aho, maa Agiríipa akamʉsea Feésto, “Noosaaka nɨmʉteere ʉhʉ mʉʉntʉ.” Feésto akamʉsea, “Kʉmʉteerera ʉrɨ lomʉtóondo!” ");
INSERT INTO lag_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lomʉtóondo yaachwe, Agiríipa na Beriníike vakʉʉja na nkongojima. Vakɨɨngɨra na balásii yo lʉmanɨra hamwɨ na vakʉ́ʉ́lʉ va vakʉ́ʉ́lʉ va valwi nkoondo na vakʉ́ʉ́lʉ va múuji. Aho, maa Feésto akalairirya Paúli areetwe na aho balásii. ");
INSERT INTO lag_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Paúli ˆakafike, maa Feésto akasea, “Agiríipa mʉtemi, na vaantʉ voosi ˆmwiijíingire aha, ʉhʉ mʉʉntʉ ˆmoomoona aha, Vayahúudi voosi vamusitaakya kʉrɨ nɨɨnɨ ʉko Yerusaléemu na aha Kaisaría. Vatʉláa isóso voosea, ‘Mʉʉntʉ ʉhʉ sɨ arɨ wo va mooyo tʉkʉ!’ ");
INSERT INTO lag_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Maa kaa, nɨɨnɨ sɨ noona ʉvɨ wowoosi wo mʉbweeyya ɨɨme neeja kʉʉlawa tʉkʉ. Maa kaa, yeeye aanoomba akalamʉrɨrwe kɨloongi chaachwe nɨ Kaisáari mʉtemi mʉkʉʉlʉ. Noo ˆchooreka nalamʉla atwaalwe na Róoma. ");
INSERT INTO lag_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kɨkomi, nɨɨnɨ nsiina isáare kʉrɨ yeeye ˆndɨrɨ mwaandɨkɨra mʉtemi wiitʉ mʉkʉʉlʉ tʉkʉ. Noo ˆchooreka namʉréetire na aha mbere yaanyu, na mbere yaako mʉtemi Agiríipa, sa suusu ˆtʉrɨ hʉmʉla kumuurya, turya ndɨrɨ isáare ro kaandɨka. ");
INSERT INTO lag_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nabwéeyyiirye jeyyo, sa sɨ viri kɨɨngɨra miryuungwii kʉmʉtwaala mʉʉntʉ na kwa Kaisáari baa kwaandɨka kɨɨntʉ ˆasitaakiwa tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Aho, maa Agiríipa akamʉsea Paúli, “Nakʉrékɨɨre wiilʉʉsɨre masáare yaako.” Aho, Paúli akiinurirya mʉkono waachwe, maa akaanda kiitetera, yoosea, ");
INSERT INTO lag_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ee mʉtemi Agiríipa, nookiiyona natalariwa sa viintʉ ˆniímire mbere yaako kiitetera sa masáare yoosi Vayahúudi ˆvaansítaakyaa. ");
INSERT INTO lag_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Niitéɨɨre jei, sa weewe ʉmányire vyabooha tʉʉva ja Vayahúudi na viintʉ vyoosi ˆvibwéeyyaa vandookiiruta ndihi. Sa jeyyo, nooloomba uyimirirye kʉʉnteerera. ");
INSERT INTO lag_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Vayahúudi voosi vamányire ˆvyeene narerwa fuma usinga waanɨ. Vamányire kwaandɨra aho ncholo ˆvyeene niikaláa na vaantʉ va ɨsɨ yaanɨ ʉko Yerusaléemu. ");
INSERT INTO lag_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Vaamányire kwa myaaka ˆɨrɨ foo, na koonɨ vooruma, voovo veeneevyo toola varɨ ʉshahíidi ˆvyeene niíkalaa ja Mʉfarisáayo, nootuuba viviraviviira tʉʉva ja díini yiitʉ. ");
INSERT INTO lag_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Atɨ, ɨkɨ noo ˆchabwéeyyiirye nkɨɨma aha, sa ndamʉrɨrwe, sa niiláangyaa kwiichuunga kwa Mʉlʉʉngʉ ˆalʉʉsa kwa vala baaba wiitʉ. ");
INSERT INTO lag_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kʉlaha ʉko, noo kʉra kwiiláangiwaa nɨ nkolo ikimi na ivɨrɨ ja mɨɨtʉ. Na noo ˆchooreka vamwiínamɨraa Mʉlʉʉngʉ ko manyɨka uchikʉ na muusi. Ee mʉtemi, nɨ sa kwiilaangya ʉko noo Vayahúudi vaansítakiriirye! ");
INSERT INTO lag_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nɨ sa che nyuunyu mookoona Mʉlʉʉngʉ sɨ arɨ daha fʉfʉla vaantʉ tʉkʉ? ");
INSERT INTO lag_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Kɨkomi, nɨɨnɨ mweeneevyo noonáa nasaakwa mbweeyye kɨra kɨɨntʉ sa nkɨɨkane irina ra Yéesu wa Nasaréeti. ");
INSERT INTO lag_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Aya masáare noo ˆmeene nabweeyyáa ʉko Yerusaléemu. Nɨɨnɨ navachuungáa mʉnyololwii vaantʉ va Mʉlʉʉngʉ kwa wiimiriri wa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva. Vara vɨɨngɨ ˆvakalamʉrɨrwe kukwya, nɨɨnɨ naváa mbare kuruma ʉlamuli ʉwo. ");
INSERT INTO lag_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ˆKarɨ foo nadomáa na masinagóogii nkalairirya vaturikiriwe, sa vamʉhɨɨntɨkɨre Yéesu. Nɨjáa navakalarɨra maatʉkʉ vii, sa jeyyo nadomáa baa na míiji ˆɨrɨ kʉlɨ sa nkavaturikirye. ");
INSERT INTO lag_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Sikʉ ɨmwɨ ˆnadomáa noo vaturikirya vaantʉ ʉko múujii wa Damésiki, nɨjáa nahɨ́ɨwe wiimiriri na ʉlairiri fuma kwa vakʉ́ʉ́lʉ va veeneɨsɨ va Ijʉva. ");
INSERT INTO lag_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ee mʉtemi, mpɨɨndɨ ˆnɨjáa njirii, koonka nkoona kɨweerʉ ˆchadalavadalaava kʉlookya cha mwaasʉ fuma kurumwii. Ɨkyo kɨweerʉ kɨkaamʉrɨka nɨɨnɨ baa viivaanɨ ˆveene nayeendanʼyáa novo. ");
INSERT INTO lag_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Voosi tʉkawya na ɨsɨ. Nɨɨnɨ nkateera sawúti yookʉʉnyanɨrɨra kwa ndʉʉsɨka yaanɨ ya Kɨeburanía, yoosea, ‘Saúli! Saúli! Sa che wookuunturikirya? Wookiitamikya bweete vii ja ndákwii yoovaa vivalo dʉʉrɨ ya muríisi waachwe.’ ");
INSERT INTO lag_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Maa nkuurya noosea, ‘Aaɨ, ʉrɨ ani weewe?’ Ne akaansea, ‘Nɨɨnɨ ndɨrɨ Yéesu. Weewe wookuunturikirya. ");
INSERT INTO lag_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Baa neembe nɨ jeyyo, haaha inʉka, wɨɨme na majeo yaako! Nakʉfʉ́mɨɨre sa nɨkʉvɨɨke weewe ʉve mʉtʉmami waanɨ na ʉra ˆoona aya masáare ˆwɨɨ́ne isikʉ na yara ˆndɨrɨ koonekya. ");
INSERT INTO lag_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Kʉkʉlamurirya neende fuma mɨkonwii ya Vayahúudi viivaako na fuma mɨkonwii ya vaantʉ sɨ ˆvarɨ Vayahúudi. Na nɨ kʉkʉtʉma niise kwa avo vaantʉ sɨ ˆvarɨ Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kavatʉʉnʉkʉle miiso yaavo, vareke tuuba kilwiirya, vatuube kɨweerʉ. Vareke tuuba Irimʉ, vamutuube Mʉlʉʉngʉ. Kwa njɨra ɨyo, Mʉlʉʉngʉ sea arɨ ʉvɨ waavo wasírire na kʉva varɨ hamwɨ na vara ˆvaava vaaja mbere ya Mʉlʉʉngʉ kwa njɨra yo kuunduma nɨɨnɨ.’ ");
INSERT INTO lag_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ee mʉtemi Agiríipa, sa jeyyo sɨ nareka kwiituuba ɨyo njori ˆngʼeene nɨjáa naheewa fuma kurumwii tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nɨɨnɨ naanda kʉvavariyʉrɨra vaantʉ va Damésiki vareke ʉvɨ waavo, vamʉvalandʉkɨre Mʉlʉʉngʉ, na vandoobweeyya viintʉ ˆvyoónekyaa kɨkomi vaválandwɨɨre mɨtɨma yaavo. Masáare yaayo, nayavariyʉla Yerusaléemu na ɨsɨ yoosi ya Yudéea na kwa vaantʉ sɨ ˆvarɨ Vayahúudi. ");
INSERT INTO lag_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Aya noo yabweeyya, Vayahúudi vakaankwaata ˆvakaanshaane ʉko waámii wa Kaaya Njija ya Ijʉva na vasaakáa kʉʉnjʉlaa. ");
INSERT INTO lag_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Maa kaa, Mʉlʉʉngʉ aanyambirirya fʉʉrʉ isikʉ. Aya noo yambwéeyyiirye nɨɨme mbere ya vawosi na mbere ya vaantʉ kʉtoola ʉshahíidi. Nsiina masáare yɨɨngɨ ˆndʉ́ʉsaa tʉkʉ, nɨ yayara ˆmeene valáali na mʉtwe na Mʉ́sa valʉʉsa fʉmɨra yarɨ. ");
INSERT INTO lag_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Na avo voosi valʉʉsa, Masía turikiriwa arɨ, na kʉva arɨ wa ncholo kʉfʉfʉka fuma inkwyii, sa avawyɨɨre vaantʉ kɨweerʉ cha Mʉlʉʉngʉ, Vayahúudi na vaantʉ sɨ ˆvarɨ Vayahúudi.” ");
INSERT INTO lag_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Mpɨɨndɨ Paúli ˆiiteteráa jei, maa Feésto akalʉʉsɨka na sawúti nkʉʉlʉ yoosea, “Paúli mʉtwe waako wafɨrɨra! Kʉsoma mʉnʉmʉʉnʉ kwabweeyya ʉve na kɨsari!” ");
INSERT INTO lag_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Maa kaa, Paúli akasea, “Ee aaɨ Feésto! Nɨɨnɨ sɨ ndɨrɨ mʉsari tʉkʉ. Aya masáare ˆnoolʉʉsa nɨ ya kɨmáárɨ na nɨ lʉʉsa niise na tooti jaanɨ ˆjiri nkaasʉ. ");
INSERT INTO lag_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kɨkomi mʉtemi amányire neeja masáare aya sa yafʉmɨra kɨweerwii, na kusiina ˆramʉlooka tʉkʉ. Noo ˆchooreka noolʉʉsa ko kiitema. ");
INSERT INTO lag_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mʉtemi Agiríipa, eri, warúmaa valáali na mʉtwe wʉʉ? Namányire wavarúmaa.” ");
INSERT INTO lag_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Aho, maa Agiríipa akamʉsea Paúli, “Eri, wookiisea kʉʉmbweeyya ʉrɨ nɨve Mʉkirisitʉ chaangʉ vii jei?” ");
INSERT INTO lag_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Maa Paúli akamʉsea, “Noomʉloomba Mʉlʉʉngʉ, ɨve chaangʉ, au ɨve kwa mpɨɨndɨ nkʉʉlʉ, weewe na ava vaantʉ voosi ˆvoonkʉʉteerera isikʉ, mʉve ja nɨɨnɨ, maa kaa, bila yo chuungwa mɨnyololo.” ");
INSERT INTO lag_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Paúli ˆakalʉʉse jeyyo, maa mʉtemi Agiríipa hamwɨ na gávana Feésto na Beriníike, na vaantʉ voosi ˆveene vajáa viíkyɨɨre novo aho, vakɨɨma. ");
INSERT INTO lag_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ˆVakalooke, maa vakiiwyɨɨra voosea, “Ʉhʉ mʉʉntʉ sɨ abweeyya isáare roroosi ˆroomʉbweeyya ɨɨme neeja kʉʉlawa au achuungwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Aho, maa re Agiríipa akamʉsea Feésto, “Ngaarɨ ʉhʉ mʉʉntʉ sɨ aarɨ analoomba isáare raachwe rɨkateererwe nɨ Kaisáari, nɨ aarɨ wo rekera vii.” ");
INSERT INTO lag_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ˆVakalamʉle doma tʉrɨ na ɨsɨ ya Itália ko kwaambʉka méeli, maa vakamʉvɨɨka Paúli na vaantʉ vɨɨngɨ ˆvajáa mʉnyololwii mɨkonwii ya mʉkʉ́ʉ́lʉ wa valwi nkoondo ʉmwɨ ˆasewáa Juliáasi. Ʉhʉ, Juliáasi nɨ wa mpuka ya valwi nkoondo va Kaisáari Agúusto mʉtemi mʉkʉʉlʉ ajáa. ");
INSERT INTO lag_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Aho, tʉkaambʉka méeli fuma múuji wa Adiramitío, ˆngʼeene yadomáa na míijii ˆɨrɨ mbarɨmbarɨ ya mayɨya ya ɨsɨ ya Ásia. Mpɨɨndɨ ˆtwiinʉkáa aho, nɨ hamwɨ tʉjáa na Aristáriko mʉʉntʉ ˆamuruma Yéesu, Mʉmakedonía fuma múuji wa Tesaloníike. ");
INSERT INTO lag_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lomʉtóondo yaachwe ˆkʉkeere, tʉkafika múujii wa Sidóoni ˆʉrɨ mbarɨmbarɨ ya mayɨya. Aho, Juliáasi akamʉbweeyyirya wʉʉja Paúli ko mʉrekera adome noo valuumbya vijeengi vyaachwe sa vamwaambirirye viintʉ ˆasaakáa. ");
INSERT INTO lag_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Fuma aho, tʉkakwaata njɨra na méeli yiiswi. Na sa viintʉ ihúmbuuto ratʉkɨtɨráa tʉkakwaatɨra na ʉtʉ́rʉko wa ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ˆɨséwaa Kúpuro sa twiikitirirye ɨro ihúmbuuto. ");
INSERT INTO lag_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tʉkafɨrɨra mayɨya ko tweera na ivarwii ra ɨsɨ ya Kilikía na Pamufilía, aho, tʉkafika múujii wa Míira ˆʉrɨ ɨsɨ ya Líkia. ");
INSERT INTO lag_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Aho, mʉkʉ́ʉ́lʉ wa valwi nkoondo akashaana méeli fuma múuji wa Alekisándiria, ˆyoodoma na Itália, maa akatwaambukya aho méelii. ");
INSERT INTO lag_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kwa sikʉ ˆjiri foo tʉkayeenda na méeli kwa uturikiri mpolɨ mpolɨ fʉʉrʉ tʉkasengerera múuji wa Níido. Na sa viintʉ kʉjáa na ihúmbuuto ˆrootʉkɨtɨra tʉdɨɨre doma ja ˆvyeene tatamanyáa, maa tʉkakwaata na nyʉngʉre ya ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ya Kɨréete, tʉkatweera heehi na múuji wa Salimóoni. ");
INSERT INTO lag_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tʉkalooka ko tʉrɨkɨra kʉnʉ tookɨɨyambalakana Kɨréete mpaka tʉkafika kʉʉntʉ ˆkʉséwaa Bandáari ˆYabooha, heehi na múujii wa Laséa. ");
INSERT INTO lag_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tatuuba lʉyeendo kwa sikʉ ˆjiri foo, na lʉyeendo lʉjáa lwavɨɨha maatʉkʉ vii. Ngovi yo kiirekya kurya ɨkava yalóokire. Jeyyo, Paúli akavakalamya valongooli va méeli yoovasea, ");
INSERT INTO lag_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Arumi, nookoona ʉlʉ lʉyeendo lwiiswi reeta lʉrɨ marema na máari ˆjiri foo rɨmɨra jiri. Ɨhɨ méeli na miriwa yaachwe sɨrɨra ɨrɨ mayiyii. Sɨ jeyyo vii tʉkʉ, baa nkaasʉ jiiswi rɨmɨra jiri.” ");
INSERT INTO lag_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Maa kaa, ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo kɨrɨ vyo mʉteerera Paúli, yeeye akateerera masáare ya mʉlongooli wa méeli na mweeneméeli. ");
INSERT INTO lag_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Na sa viintʉ ɨyo bandáari sɨ ɨjáa yabooha so kiikala mpɨɨndɨ ja mpeho, vaantʉ ˆvarɨ foo vakalamʉla twiinʉke aho, sa viiseáa fika tʉrɨ Foiníike, na twiikale ʉko mpɨɨndɨ ja mpeho. Foiníike nɨ bandáari ˆɨrɨ ɨsɨ ya Kɨréete ɨjáa, na ɨjáa yalaanga ivaru ra saame kʉmweéri na ʉtʉ́rʉko kʉmweéri. ");
INSERT INTO lag_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mpeho ya kifwiiriri ˆɨkaande fwɨɨra fuma ivaru ra saame, vakiisea kiimikirirya varɨ mɨryʉʉngʉ yaavo. Aho, vakakʉʉla náanga, maa vakakwaata njɨra na mbarɨmbarɨ ya ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ya Kɨréete. ");
INSERT INTO lag_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kamʉsaambo kiduudi vii keende ˆtʉkalooke, maa rɨkʉʉja ihúmbuuto ˆradalavadalaava ˆraséwaa Ihúmbuuto ra Ʉtʉ́rʉko Itʉʉmba fuma Kɨréete, rɨkawuva. ");
INSERT INTO lag_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ɨro ihúmbuuto rɨkavaa lʉvaru lwa méeli, aho, tʉkasiindwa nɨ rɨra ihúmbuuto, tʉkɨɨrekera, maa tʉkatwaalwa na katɨ na katɨ ya mayɨya. ");
INSERT INTO lag_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ˆTʉkafike nyʉngʉre ya ɨsɨ nduudi ˆyarɨɨngɨrɨrwa nɨ maaji ˆɨséwaa Kaúuda, tʉkava twakítiririiwe kiduudi rɨra ihúmbuuto nɨ ɨyo ɨsɨ. Aho, tʉkadaha chʉngʉla mashʉ́wa yo honerya vaantʉ kwa uturikiri. ");
INSERT INTO lag_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Vatʉmami va méeli ˆvakahʉmʉle kwiirʉtɨrɨra ɨra mashʉ́wa, vakiiyingirya na méelii. Aho, vakariingirirya ndihi na itakwii ra méeli, maa vakiichuunga méeli neeja sa ɨdɨɨre wʉnɨka. Vabweeyya jeyyo sa voofáa kʉtwaalwa na isaárii ra mbarɨmbarɨ ya Síriti, vakaburukirya náanga sa méeli ɨyeende mpolɨ mpolɨ, maa vakarekera méeli ɨkʉndʉlwe nɨ ɨro ihúmbuuto. ");
INSERT INTO lag_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ihúmbuuto rɨkavaa méeli mʉnʉmʉʉnʉ, sa jeyyo, lomʉtóondo yaachwe ˆkʉkeere, maa vatʉmami va méeli vakaanda fweitɨra miriwa na luujii. ");
INSERT INTO lag_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Sikʉ ya katatʉ, maa vakaanda fweita saama ja méelii na mayiyii kwa mɨkono yaavo veeneevyo. ");
INSERT INTO lag_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Sikʉ ˆjiri foo jikalooka baa koona mwaasʉ na nyényeeri tʉkʉ. Rɨra ihúmbuuto ˆradalava rɨjáa rakonkomala kuwuva mʉnʉmʉʉnʉ, maa re kwiilaangya kwiiswi hona tʉrɨ, kʉkasira vʉʉ. ");
INSERT INTO lag_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Na vaantʉ ˆvakiikale sikʉ ˆjiri foo baa kurya tʉkʉ, Paúli akɨɨma katɨkatɨ yaavo, maa akavasea, “Arumi, vijáa mʉʉnteerere mpɨɨndɨ ˆtʉjáa Kɨréete. Ngaarɨ ʉsaambʉ ʉhʉ na mukube ʉhʉ mʉʉnéhire. ");
INSERT INTO lag_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Haaha noovaloomba mʉfafye mɨtɨma yaanyu, sa kusiina mʉʉntʉ baa ʉmwɨ ˆarɨ taaha nkaasʉ yaachwe tʉkʉ. Nɨ méeli vii noo ɨrɨ nyɨmɨra. ");
INSERT INTO lag_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nɨɨnɨ ndɨrɨ mʉʉntʉ wa Mʉlʉʉngʉ na ndɨrɨ mʉtʉmami waachwe. Uchikʉ wa isikʉ, murimʉ waachwe mʉʉja waanfʉ́mɨɨre, ");
INSERT INTO lag_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na waanséire jei, ‘Paúli koofa tʉkʉ, weewe nɨ mpaka wɨɨme mbere ya Kaisáari. Laanga! Mʉlʉʉngʉ kwa ʉwoloki waachwe, akʉhɨ́ɨre weewe nkaasʉ ya vaantʉ voosi ˆʉrɨ novo méelii.’ ");
INSERT INTO lag_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Haaha arumi itemi, sa Mʉlʉʉngʉ nimwiiláangyaa tʉmama arɨ yara ˆmeene aangwyɨɨrɨɨré. ");
INSERT INTO lag_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Maa kaa, nɨ mpaka tʉfweitɨrwe kaɨsɨ kaduudi ˆkarɨɨngɨrɨrwa nɨ maaji vii.” ");
INSERT INTO lag_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Uchikʉ wa sikʉ ya ikimi na ine (14) ˆʉkafike, tʉjáa tʉkaarɨ toofiindwa nɨ rɨra ihúmbuuto kʉnʉ na kʉra haantʉ ha mayɨya ya Adiriáati. Kati na kati ya uchikʉ ʉwo, vatʉmami va méeli vakiisea vaséngerɨɨre fika ɨsɨ ɨmwɨ. ");
INSERT INTO lag_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Sa jeyyo, vakakiimya ludihi luujii sa vataange ʉlɨ́ɨ́hɨ wa maaji, vakashaana nɨ míita makumi yanɨ (40). ˆVakaseese na mbere kiduudi, vakashaana míita makumi yatatʉ (30). ");
INSERT INTO lag_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Aho, vakaanda koofa vookiisea méeli ifaanaa ɨhamɨre mwaalaliwye, sa jeyyo, vakafweitɨra náanga ine na nyuma ya méeli. Maa vakaanda loomba kweere chaangʉ. ");
INSERT INTO lag_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Vatʉmami va méeli vasaakáa tɨɨja fuma méelii, aho, vakakiimya ɨra mashʉ́wa luujii kʉnʉ vookiibweeyya ja voosaaka fweitɨra náanga na ivaru ra mbere ya méeli. ");
INSERT INTO lag_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Aho, maa Paúli akamʉsea mʉkʉ́ʉ́lʉ wa valwi nkoondo na valwi nkoondo ˆvarɨ ɨsɨ yaachwe, “Koonɨ ava vatʉmami va méeli sɨ vachɨ́hɨɨre na suusu aha méelii, nyuunyu sɨ mʉrɨ hona tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Reerʉ, valwi nkoondo vakakera ndihi ˆngʼeene jijáa jachuunga ɨra mashʉ́wa, maa vakɨɨreka ɨwyɨɨre na luujii ɨsʉmʉlwe nɨ maaji. ");
INSERT INTO lag_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ˆKʉkasengerere kweera, Paúli avakalaamyáa voosi varye chákurya, kʉnʉ yoosea, “Isikʉ mufíkiirye sikʉ ikimi na ine (14) ntɨ ˆmoololokera vii baa kei sɨ mʉnaarya chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Haaha kalaami murye chákurya, sa ɨkyo noo kɨrɨ valamurirya. Kusiina baa ʉmwɨ waanyu ˆarɨ taaha lʉjwɨ́ɨrɨ lwaachwe tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Paúli ˆakahʉmʉle lʉʉsa ayo, akatoola mʉkáate, akamʉdʉʉmba Mʉlʉʉngʉ mbere ya vaantʉ voosi, akabendʉlabendʉla, maa akaanda kurya. ");
INSERT INTO lag_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Aho, voosi vakiiheera mʉtɨma, maa vakaanda kurya. ");
INSERT INTO lag_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Na vaantʉ voosi tʉjáa aho méelii, nɨ magana yavɨrɨ, makumi mufungatɨ na vasasatʉ (276). ");
INSERT INTO lag_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Voosi ˆvakarye no kiikuta, vakafweita miriwa ya ngáano na luujii, sa méeli yaangʉhe. ");
INSERT INTO lag_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ˆKʉkeere, vatʉmami va méeli vakoona ɨsɨ, maa kaa, sɨ vɨɨtaangáa ɨra ɨsɨ tʉkʉ. Kei, vakoona haantʉ maaji ya mayɨya ˆyɨɨngɨra ˆharɨ nɨ isaáre. Vakalamʉla koonɨ viri dahɨka vɨɨtwaale méeli na aho. ");
INSERT INTO lag_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Aho, vakakera ndihi ja náanga, maa vakajireka mayiyii. Vakachʉngʉla ndihi ya usukáani wo wolorera méeli, maa vakachʉʉnga lweénda ncholwii ya ngururyo ya mbere, sa mpeho yɨɨkʉndʉle méeli na mbarɨmbarɨ ya mayɨya. ");
INSERT INTO lag_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Maa kaa, méeli ˆɨkaseese kiduudi vii, mpula ya méeli ɨkakita na ngururu isaárii, maa ikiibokera aho. Nyuma ya méeli ɨkava yoovawa nɨ mapúunta ya maaji mpaka méeli ɨkaanda wʉnɨka. ");
INSERT INTO lag_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Aho, vara valwi nkoondo vakalamʉla vavʉʉlae vara vaantʉ voosi ˆvachuungwa, sa vakɨtɨre mʉʉntʉ yoyoosi kooyerera, maa atɨɨje. ");
INSERT INTO lag_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Maa kaa, ʉra mʉkʉ́ʉ́lʉ wa valwi nkoondo sɨ asaakáa Paúli ʉʉlawe tʉkʉ, sa jeyyo, akavakaanʼya vara valwi nkoondo vareke bweeyya jeyyo. Aho, akalairirya, vara ˆvamányire kooyerera, viifweitɨre na luujii sa vafɨrɨre na nyambʉko. ");
INSERT INTO lag_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Na vara ˆveene sɨ vamányire kooyerera, vatoole mbáwo, vamwɨ mabéendʉ ya méeli sa vooyerere novyo. Jeyyo, noo ˆvyeene tafɨrɨra voosi nkaasʉ fʉʉrʉ nyambʉko. ");
INSERT INTO lag_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ˆTʉkafike tʉrɨ nkaasʉ nyambʉko, tʉkataanga ɨra ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji nɨ Malíta ɨséwaa. ");
INSERT INTO lag_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Vaantʉ va ɨyo ɨsɨ vakatʉteengya vyabooha mʉnʉmʉʉnʉ baa neembe sɨ vajáa vatʉmányire. Vakatʉkorerya mooto, maa vakatʉsea toote, sa mbula yaváa na kʉjáa kwatɨɨte mpeho. ");
INSERT INTO lag_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paúli akɨɨta noo sasawuta inkwi, maa akajivɨkɨra mootwii. Koonka, njoka ˆɨdɨ́ɨmwɨɨrwe nɨ irʉtɨra, ɨkamʉkoma, maa ikiifarimbirirya mʉkonwii wa Paúli. ");
INSERT INTO lag_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Vaantʉ va ɨyo ɨsɨ ˆvakoone njoka iníngʼinire mʉkonwii wa Paúli, maa vakiiwyɨɨra, “Sɨ viri reka tʉkʉ, ʉhʉ mʉʉntʉ nɨ mʉʉlai, baa neembe ahónire ʉko mayiyii, mʉlʉʉngʉ wiitʉ ʉhʉ ˆtamʉkémeraa Ʉwoloki, sɨ arúmire ave nkaasʉ tʉkʉ.” ");
INSERT INTO lag_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Maa kaa, Paúli akɨɨkonkomera ɨra njoka na mootwii, yeeye baa kʉva kɨɨntʉ chochoosi tʉkʉ. ");
INSERT INTO lag_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Vara vaantʉ vakatuuba woojera asuuwe, au awye no kwya chaangʉ. ˆVakoone mpɨɨndɨ joodoma baa kʉva kɨɨntʉ chochoosi tʉkʉ, maa vakavarindʉla miiririkano yaavo vakaanda sea Paúli nɨ ʉmwɨ wa mɨlʉʉngʉ yaavo. ");
INSERT INTO lag_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Heehi na hara haantʉ vaantʉ ˆvajáa vatʉkóreriirye mooto, kʉjáa kwatɨɨte mawʉnda ya mʉʉntʉ ʉmwɨ ˆasewáa Púbulio. Ʉhʉ noo mʉkʉ́ʉ́lʉ wa ɨyo ɨsɨ ˆyarɨɨngɨrɨrwa nɨ maaji ajáa. Akatʉteengya vyabooha na kwaachwe, tukiikala kwa sikʉ itatʉ. ");
INSERT INTO lag_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Mpɨɨndɨ jiijo, taáta waala Púbulio nɨ nchiirii ajáa na ajáa alwɨ́ɨre ndwáala yo fwaaha sakami. Aho, Paúli akɨɨngɨra na haantʉ mʉlwɨ́ɨrɨ ˆajáa. Akamʉloombera kwa Mʉlʉʉngʉ ko mʉvɨkɨra mɨkono mweeri yaachwe, maa akahola. ");
INSERT INTO lag_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ayo ˆyakafʉmɨre, aho, valwɨ́ɨrɨ ˆvarɨ foo va ɨra ɨsɨ vʉʉjáa na vahoriwáa. ");
INSERT INTO lag_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Vaantʉ va ɨra ɨsɨ, vakatʉnyemya mʉnʉmʉʉnʉ. Na mpɨɨndɨ ˆtakwaatáa njɨra na méeli, vakatwaambirirya kwaambukya na méelii viintʉ vira ˆtasaakáa. ");
INSERT INTO lag_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Myeeri ɨtatʉ ɨkava yalóokire. Tʉkakwaata njɨra fuma ɨyo ɨsɨ, na méeli ˆngʼeene ɨjáa aho kʉwoojera mpɨɨndɨ ja mpeho jilooke. Ɨhɨ méeli nɨ ya múujii wa Alekisándiria ɨjáa na ɨjáa yatɨɨte sanáamu ja vidabalaíyo maása. ");
INSERT INTO lag_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Mpɨɨndɨ ˆjikalooke, tʉkafika múuji wa Sirakúusa, aho, tukiikala sikʉ itatʉ. ");
INSERT INTO lag_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Fuma aho, tʉkarɨɨngɨrɨra fʉʉrʉ múuji wa Réjio. Sikʉ ˆɨtʉ́ʉbɨrɨɨre, mpeho ya saame ɨkaanda fwɨɨra, na sikʉ ya kavɨrɨ tʉkafika múuji wa Puteóoli. ");
INSERT INTO lag_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Aho, tʉkavashaana vaaniitʉ, na vakatʉteengya na vakatʉkalaamya twiikale novo kwa sikʉ muf