﻿USE sofia;
DROP TABLE IF EXISTS sofia.lacNT_vpl;
CREATE TABLE lacNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lacNT_vpl WRITE;
INSERT INTO lacNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A tan in ts'ibtic techex, quij Mateo, tʌcʌ robob u nunquirob Jesucristo uch. A Jesúso' u ch'ic parar u nunquir David. Bayiri' xan a Jesúso' u ch'ic parar u nunquir Abraham. ");
INSERT INTO lacNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ra' u tet Isaac. A Isaaco' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar Jacob. A Jacobojo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar u c'aba' Judá. A Jacobojo' ra' u tet. Mʌ' ja wirej, p'eri u tetob yejer yits'inob yejer u sucu'unob. ");
INSERT INTO lacNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","A Judájo' yʌn ca'tur u pararob yejer u rac' Tamar. Turiri' ra' u c'aba' Fares. U jer turiri' u parar, Zara u c'aba'. A Fareso' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar, ra' u c'aba' Esrom. A Esromo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar u c'aba' Aram. ");
INSERT INTO lacNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Baxuc xan, quij Mateo, a Aramo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar uch ra' u c'aba' Aminadab. A Aminadabo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Naasón. A Naasóno' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Salmón. ");
INSERT INTO lacNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","A Salmónjo' caj u raq'uintaj ra' u c'aba' Rahab. Caj c'uchij tu q'uinin u pararʌncʌr u rac' Rahab yʌn u parar ra' u c'aba' Booz. A Boozo' caj u raq'uintaj ra' u c'aba' Rut. Caj c'uchij tu q'uinin u pararʌncʌr u rac' Rut yʌn u parar ra' u c'aba' Isaí. ");
INSERT INTO lacNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","A Isaíajo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar David. A Davido' raji' oc rey u winiquirob israel. Caj u raq'uintaj David u rac' Urías. Caj c'uchij tu q'uinin u pararʌncʌr u rac' David yʌn u parar David ra' u c'aba' Salomón. ");
INSERT INTO lacNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","A Salomóno' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Roboam. A Roboamo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Abías. A Abíaso' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Asa. ");
INSERT INTO lacNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","A Asajo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Josafat. A Josafato' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Joram. A Joramo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Uzías. ");
INSERT INTO lacNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","A Uzíaso' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Jotam. A Jotamo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Acaz. A Acazo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Ezequías. ");
INSERT INTO lacNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","A Ezequíaso' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Manasés. A Manaséso' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Amón. A Amóno' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Josías. ");
INSERT INTO lacNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","A Josíaso' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Jeconías. A Jeconíaso' yʌn ya'ab u sucu'unob. A Jeconíaso' caj pararnʌjij u rac' tu q'uininin caj bin purbir ich u ru'umin Babilonia u winiquirob israel. Chucbir u winiquirob israel caj bin purbir ich u ru'umin Babilonia. ");
INSERT INTO lacNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Caj ts'oc u purbir u winiquirob israel tu ru'umin Babilonia. Caj pararnʌjij u rac' yʌn u parar ra' u c'aba' Salatiel. A Salatielo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Zorobabel. ");
INSERT INTO lacNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","A Zorobabel caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Abiud. A Abiudo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Eliaquim. A Eliaquimo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Azor. ");
INSERT INTO lacNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","A Azoro' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Sadoc. A Sadoco' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Aquim. A Aquimo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Eliud. ");
INSERT INTO lacNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","A Eliudo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Eleazar. A Eleazaro' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Matán. A Matáno' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' Jacob. ");
INSERT INTO lacNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","A Jacobo' caj c'uchij tu q'uinin u pararʌncʌr u rac' yʌn u parar ra' u c'aba' José. José raji' caj u raq'uintaj María. A Maríajo' ra' u c'aba' u nʌ' Jesús. Raji' Jesús a tuchi'ta'b ten C'uj ich yoc'ocab rajen u c'aba' Cristo. ");
INSERT INTO lacNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mʌ' ja wirej, quij Mateo, yʌn catorce u nunquirob Jesús. Cu yʌnx chun yejer Abraham cʌja'an ich yoc'ocab hasta c'uchij tu q'uinin ti' u rey David. Yʌn u jerob catorce u nunquirob Jesús. Caj quimij u rey David hasta caj bin purbir u winiquirob israel ich u ru'umin Babilonia. Yʌn u jerob catorce u nunquirob Jesucristo caj wʌc'ʌs urob ich u ru'umin Canaán hasta caj rocha'b Jesucristo ten u nʌ'. Mʌ' ja wirej, ra' u q'uinin quir u taquic winic a ti' yʌnob ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Baxuc a jera' caj rocha'b Jesucristo ten u nʌ' uch. Caj c'ata'b María, u nʌ' Jesús. José caj u c'ata ti' u tet María. Chen caj u toc c'ataj. Mʌ' toy u raq'uintej. Caj yʌnjij u parar María quire' u Taj'or u Pixam C'uj. Raji' caj u ya'araj u yʌntar u parar María. ");
INSERT INTO lacNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Caj yuba yʌn u parar María. A Joséjo' mʌ' u c'at u raq'uintej María quire' tsoy yor a Joséjo'. Chen u c'at u muc u tuchi'tic María, José, soc mʌ' u che'ta'r ten u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","José caj u tucraj ich yor bic cu bin u p'ʌtic María. Caj u wʌyʌc'taj José yʌjmasir u t'ʌn C'uj. Ara'b ti' ten yʌjmasir u t'ʌn C'uj: ―Mʌ' ja ch'ic sajaquir ―quij ya'araj ti' José―, quire' a techo' u pararech a nunquir David. Tsoy a ch'ic a raq'uintej María. Yʌn u parar quire' ara'b ti' ten u Taj'or u Pixam C'uj ca' yanac u parar. ");
INSERT INTO lacNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A Maríajo' ―caj u ya'araj yʌjmasir u t'ʌn C'uj―, bin u ca' pararʌncʌr María xib u parar María. Caj u toc araj yʌjmasir u t'ʌn C'uj ti' José: ―Ca' a pʌchej u c'aba' JESÚS ca' bin a pʌchej u c'aba'. Rajen pʌcha'an u c'aba' Jesús, quire' bin u jawsic u si'pir a mac a cu quibic u t'ʌn soc mʌ' u bin ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mʌ' ja wirej, quij Mateo, a C'ujo' caj u toc araj je' u tar Cristoje'. Quire' baxuc caj u tsec'taj yʌjtseq'uir u t'ʌn C'uj Isaías uch. Rajen nup' u t'ʌn baje'rere'. Mʌ' ja wirej, tarij Cristo. U'yex ba' caj u ya'araj yʌjtseq'uir u t'ʌn C'uj uch: ");
INSERT INTO lacNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Irej a xquico' ―quij Isaías: Mʌ' toy u ch'a'i' caj yʌnjij u parar ―quij Isaías―. Bin u pachej u c'aba' Emanuel ―quij Isaías. U c'aba' Emanuel u c'at ya'aric: Ti' yʌn C'uj yejero'on ich yoc'ocab. Baxuc caj u ya'araj yʌjmasir u t'ʌn C'uj caj u wʌyʌc'taj José. ");
INSERT INTO lacNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Caj ts'oc u wʌyʌc' José. Caj ajij caj u ch'aj u raq'uintej María quire' baxuc caj u ya'araj yʌjmasir u t'ʌn C'uj. Rajen caj u ch'aj u raq'uintej José. ");
INSERT INTO lacNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Barej José mʌ' u wenʌn yejer, yiric yʌn u parar María, hasta caj rocha'b u parar C'uj ten u nʌ'. Caj pach u c'aba' JESÚS quire' caj u toc araj yʌjmasir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús, quij Mateo, caj rocha'b ich u cajar Belén. A Beléno' ti' yʌn ich u ru'umin Judea. Cu reyintic Herodes ich u ru'umin Judea caj rocha'b Jesús. Tar u tar ich u cajar Jerusalén. Caj c'uchob ich u cajar Jerusalén tar u tarob tu cu tar ic yum. Robob u ne'er ba' caj c'uchob. Jun yarob caj c'uchob ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","A mac u ne'er ba' caj u c'atajob ich u winiquirob judío tu cajar Jerusalén: ―Tu rocha'b u rey u winiquirob judío? Mʌ' ja wirej, tij quiraj u sab, jach carem, a cu yesic toc rocha'b ten u nʌ'. Tij quiraj tu cu tar ic yum. Rajen caj taro'on ca' ij c'ujintej ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Caj yubaj u rey Herodes ba' cu manob u c'aticob caj jaq'uij yor, Herodes. Baxuc tu cotor mac cʌja'an ich u cajar Jerusalén, caj jaq'uij yorob a ba' caj u yubob u c'atobi'. ");
INSERT INTO lacNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Rajen u rey Herodes, caj u pʌyaj u c'atej ti'ob, tu cu bin rochbir a mac a cu bin tuchi'bir ten C'uj quir u taquic mac tu cotor. Caj u c'ataj ti' u jach ts'urirob sacerdote u winiquirob judío. Baxuc, caj u c'ataj Herodes ti' a cu camsicob u t'ʌn Moisés ti' u winiquirob judío: ―Tu cu bin rochbir Cristo? ―quij Herodes. ");
INSERT INTO lacNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Robob caj u ya'arajob ti' Herodes: ―Yʌn u rocha'r Cristo ich u cajar Belén quire' ti' yʌn tu ru'umin Judea. Mʌ' ja wirej, baxuc caj u ts'ibtaj yʌjtseq'uir u t'ʌn C'uj uch: ");
INSERT INTO lacNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Caj ya'araj yʌjtseq'uir u t'ʌn C'uj uch: Tar yʌn ich u cajar Belén tu ru'umin Judea, quij. Jach manan co'oj u cajar Belén ich tu cotor u cajar tu ru'umin, quij C'uj. Quire' ti' cu tar tub yʌnech, quij, a mac cu bin u reyinticob u winiquirob israel, quij C'uj. Ti' cu bin rocha'r ten u nʌ', a mac a cu bin u cʌnantic u winiquirob israel. Baxuc caj u ya'araj C'uj ti' yʌjtseq'uir u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Rajen caj u muc u pʌyaj Herodes caj u c'ataj ti' a u ne'er ba': ―P'iseten ―quij Herodes― mun u q'uinin caj a yʌn irex u joc'ar sab u rey u winiquirob judío? ");
INSERT INTO lacNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Caj u tus a'araj Herodes ti' a ju ne'er ba': ―Ca' xiquechex ich u cajar Belén ca' a qui' cʌxtex a wirej tu yʌn Cristo tu rocha'b. Wa ca wirique', purex a t'ʌn ten soc in tar in c'ujintic xan. ");
INSERT INTO lacNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Caj ts'oc yubic ya'ara' ten u rey Herodes caj binob a ju ne'er ba'. Caj joc'ob ich u cajar Jerusalén caj yirob sab quet cu binob yejer, sab tu cu tar ic yum, hasta c'uchij tu yʌn chan Cristo. Ti' xurij sab ich chan Cristo. ");
INSERT INTO lacNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Caj yirob xurij sab jach manan qui' yorob a ju ne'er ba'. ");
INSERT INTO lacNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Caj ocob ich yatoch tu yʌn chan Cristo. Caj yirob rocha'an chan Cristo ten u nʌ' María. Caj yirob chan Cristo caj xonrajob ich Cristo quir u c'ujinticob. Sansan caj u jarob u chan coprej quir u sijajob ba' ti' chan Cristo. Caj u sijajob oro. Caj u sijajob ti' u ts'ac pom. Caj u sijajob u ts'ac mirra. A je' ts'aca' quir u cho'wic tu baquer mac a cu quimine' quire' qui' u boc. ");
INSERT INTO lacNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Caj ts'oc yiricob chan Cristo a ju ne'er ba', caj ara'b ti'ob ten C'uj tu cu wʌyʌc'ob: ―Mʌ' ja binex ich u rey Herodes ―quij C'uj. Rajen caj sutnʌjob tu cajarob chen u jer u berir ti' binobi'. ");
INSERT INTO lacNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Caj ts'oc u binob a ju ne'er ba'. A Joséjo' caj u wʌyʌc'taj yʌjmasir u t'ʌn C'uj. Caj ara'b ti' ten yʌjmasir u t'ʌn C'uj: ―Riq'uen ca' xiquech yejer chan Cristo yejer u nʌ'. Tar a bin ich u ru'umin Egipto, ti' ca p'atʌr ich u ru'umin Egipto hasta quin wa'aric tech ca' su'nʌquech tera'. Quire' u rey Herodes u c'at u cʌxtic u quinsej chan Cristo ―baxuc caj ara'b ti' ten yʌjmasir u t'ʌn C'uj tu cu wʌyʌc' José. ");
INSERT INTO lacNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Caj ts'oc u wʌyʌc' José caj ajij, caj riq'uij caj binij yejer María yejer chan Cristo. Binob ich u ru'umin Egipto, cax ac'bir caj binob. ");
INSERT INTO lacNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ti' p'atobi' ich u ru'umin Egipto hasta quimij u rey Herodes. Soc u nup'ur u t'ʌn C'uj, rajen binob ich u ru'umin Egipto. Quire' caj u ya'araj yʌjtseq'uir u t'ʌn C'uj uch: “Ti' quin payic in parar, quij C'uj, ich u ru'umin Egipto.” Baxuc caj u ya'araj yʌjtseq'uir u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Caj yubaj Herodes caj u tusarob ti' Herodes a ju ne'er ba'. Caj ts'iquij u rey Herodes. Rajen caj u ya'araj Herodes ti' u soldadojob: ―Ca' xiquex a quinsex a chan ochir xib ich u cajar Belén. Ca' a rʌc quinsex chan ochir, a ca'tur yaxq'uin caj rocha'b ten u nʌ'. Cax tep u ca'ob, rʌc quinsex ich u cajar Belén. Baxuc caj u yubaj yacob a ju ne'er ba'. Ca'tur yaxq'uin caj irob a sabo'. Rajen caj u toc quinsajob chan ochir soldadojob: ―Cʌxtex u chan ochir a nʌts'a'an ich u cajar Belén ca' a quinsex. ");
INSERT INTO lacNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Baxuc caj u ch'ic araj yʌjtseq'uir u t'ʌn C'uj Jeremías uch. Quire' caj u ya'araj Jeremías uch: ");
INSERT INTO lacNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Caj yubob u t'ʌnob ich u cajar Ramá, Jeremías tu ch'ic tsec'taj. Mʌ' toy quinsac chan ochir caj u tsec'taj: Tan yoc'arob tan yac'ticob quire' mʌna' u chan ochir. Jach ya'ab cu yac'ticob u chan ochir an ten bic Raquel caj u yac'taj uch. Mʌna' mac cu qui'quintic yorob quir u ch'enʌn yoc'arob quire' yiric mʌna' u chan ochir. Baxuc caj u tsec'taj Jeremías uch. ");
INSERT INTO lacNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Barej caj quimij u rey Herodes. José caj u wʌyʌc'taj yʌjmasir u t'ʌn C'uj ich u ru'umin. Caj ara'b ti': ");
INSERT INTO lacNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Xen ―quij ya'araj ti'―. Mʌna' Herodes, quimij. Mʌna' mac cu quinsic chan Cristo. Riq'uen ca' xiquech yejer chan Cristo. Ca' sutnʌquech ta pach ich u ru'umin Israel ―baxuc ara'b ti' José ten yʌjmasir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Caj ts'oc u wʌyʌc' José. Caj ajij José caj riq'uij, caj bin ich u ru'umin Israel. Caj bin yejer u nʌ' chan Cristo, bayiri' yejer chan Cristo. ");
INSERT INTO lacNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Caj yubaj ya'ara' José cu reyintic u parar Herodes ich u ru'umin Judea. Caj yuba ya'ara' oc u reyintic caj quim u tet. U c'aba' u parar Herodes, Arquelao. Rajen caj u ch'aj sajaquir José quir u sut tu pach ich u ru'umin Judea. Caj u wʌyʌc'taj yʌjmasir u t'ʌn C'uj José. Caj ara'b ti': ―Xen ich u ru'umin Galilea. Rajen binij José ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Baxuc caj c'uchij José yejer u nʌ' Jesús ich u ru'umin Galilea. Caj bin u cʌjtarob ich u cajar Nazaret. Ti' cajij quir u nup'ur u t'ʌn C'uj. Baxuc ara'b ti' ten yʌjtseq'uir u t'ʌn C'uj uch: ―Raji' ti' cu tar ich u cajar Nazaret. Rajen ara'an u winiquir nazaret. ");
INSERT INTO lacNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti' toy cʌja'an Jesús ich u cajar Nazaret, caj tarij Juan ich u ru'umin Judea. Caj u tsec'taj ich tʌcay ru'um. Caj u yacsaj ja' tu jo'rob macob. ");
INSERT INTO lacNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Caj u tsec'taj Juan caj ya'araj: ―C'axex a worex ca' a p'ʌtex a c'aso' quire' c'uchij tu q'uinin u reyinticob C'uj ―baxuc caj u ya'araj Juan. ");
INSERT INTO lacNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A je' Juana', quij Mateo, ts'ibta'b uch ten yʌjtseq'uir u t'ʌn C'uj Isaías. Caj ya'araj Isaías ti' Juan uch cax mʌ' tac Juan: Quij cu'wic u t'ʌn, quij Isaías. Quij cu'wic u t'ʌn mac cu tsec'tic ich tʌcay ru'um. Aro' a cu tsec'tic quij cu'wic u ya'aric: “Tajquintex a worex soc c'ucha'an a worex a qui' acsiquex Jaj Ts'ur, irex ca jariquex u ber soc u tar rey.” Baxuc caj u ts'ibtaj Isaías ti' Juan uch. Rajen a baje'rer nup' u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A Juano' u tsotser yʌrʌc' camello cu sacta' u buquintej. U c'ax u nʌc' Juano', ot'. C'axicab cu mʌq'uic Juan, yejer sac' cu chi'ic Juan. ");
INSERT INTO lacNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pim mac cu bin ich Juan quir yubicob u tsec'ta' ten Juan. Tar u tarob ich u cajar Jerusalén. Tar u tarob ich u ru'umin Judea. Jach pim binob ich Juan a cu tarob ich u ru'umin Judea. ");
INSERT INTO lacNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A mac a caj u ya'araj ti' C'uj, yʌn u si'pir. A caj u ya'araj yʌn u si'pir jawsa'b u si'pir ten C'uj. Rajen acsa'b ja' tu jo'rob ten Juan ich ya'arir Jordán. ");
INSERT INTO lacNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Caj yiraj Juan caj tarob u winiquirob judío a fariseojo'. Yet tarob judío a u winiquirob saduceojo'. Quire' u winiquirob judío a fariseojo' cu qui' cʌnanticob u t'ʌn u nunquirob Moisés. Barej u winiquirob judío a saduceojo' cu ya'aricob: ―Mʌna' mac cu riq'uir ti' quimen. Pim caj yiraj u tarob Juan, a saduceojo' yejer a fariseojo'. Caj tarob a saduceojo' yejer a fariseojo' quir yacsa' ja' tu jo'rob ten Juan. Caj irir caj ara'b ti'ob ten Juan: ―A techexo' ―quij Juan―, jach c'asechex. U pararechex quisin. A mac arej a puts'urex quire' tabar u tar xur t'ʌn. A c'at wa ja taquiquex a bʌj? ");
INSERT INTO lacNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Juan caj u ya'araj ti'ob: ―Toc p'ʌtex a c'asirex tu ca mʌnex, soc a mʌnex tu tsoyir, soc chʌca'an yiricob a rac'ob caj a jach c'axex a worex. ");
INSERT INTO lacNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Juan caj u ya'araj ti' a saduceojo' yejer a fariseojo': ―Mʌ' a yʌn tucriquex a wa'ariquex ta worex. Mʌ' chichin ca wa'ariquex: “U ch'ic pararenob Abraham. Mʌ' ja wirej, ra' in nunquirob'.” Mʌ' ja tucriquex wa ju taquiquechex C'uj quire' u ch'ic pararechex a nunquirex Abraham. Caj ara'b ti'ob ten Juan: ―U'yex ba' quin wac techex. A C'ujo' c'ucha'an yor u waysic a je' tunicha' soc raji'ob u ch'ic pararob a nunquirex Abraham soc u cʌnicob a nunquirex Abraham. ");
INSERT INTO lacNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Juan caj u ya'araj ti' a fariseojo' yejer a saduceojo': ―Baje'rer an ten bic c'uchij tu q'uinin u ch'ʌcar che' a c'aso' a mʌna' u wiche'. Ti' cu bin purbir ca' tocac ich c'ac'. Baxuc xan, a mac a mʌ' u betej a ba' tsoyir, ra' cu bin u'wibir u ts'ictar ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Caj ya'araj Juan: ―A teno' jach jaj quin wacsic ja' tu jo'r mac a caj u p'ʌtaj a c'aso' quire' caj u c'axaj tu yor. Ca' bin tac Cristo. Tabar u tar Cristo. Raji' Cristo cu bin u ts'ic techex u Taj'or u Pixam C'uj soc a wet manex u Taj'or u Pixam C'uj soc u rʌc ruc'sic tu cotor a c'asirex. Ca' bin tac a Cristoji' jach no'oj. A teno' ―quij Juan―, mʌ' no'ojeni'. Mʌ' ja wirej, a teno' mʌ' jach pajareni' in pitic u c'anin u pech' xʌnʌb, cax u c'urewen a teno'. ");
INSERT INTO lacNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Caj ya'araj Juan: ―Ca' bin taco' a Cristojo', je' u jʌsic techex irej techex ca ruc'siquechex u sor a wochex trigo. Chen a tsoyo', ra' cu p'atʌr a wochex trigo. Ca puriquex u sor a to'quiquex. Baxuc ca' bin xuruc t'ʌn, ca' bin u much'quintico'on ic Tetex C'uj. A c'aso', ra' cu bin purbir ich c'ac' tu mʌ' u tupur c'ac'. Chen a tsoyo' cu bin yacsac ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ra' u q'uinino', caj tarij Jesús ich Juan. Tar u tar ich u ru'umin Galilea. A Juano' ti' yʌn. Juan nʌts'a'an ich ya'arir Jordán. Tarij ich Juan ca' acsac ja' tu jo'r ten Juan. ");
INSERT INTO lacNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Chen Juan mʌ' ju c'at yacsic ja' tu jo'r. Caj ya'araj Juan: ―A teno', ca yʌn acsic ja' tin jo'r ―quij Juan―. A techo', mʌ' tarech quir in wacsic ja' ta jo'ri'. A Juan u c'at u yiric u c'axic u tucur Jesús rajen caj u ya'araj Juan ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Caj u nuncaj Jesús caj ara'b ti' Juan: ―Tsire'ej baje'rer. Mʌ' ja wa'aric. Acsej ja' tin jo'r. Ca' ic betej tu cotor a ba' tsoy tu t'ʌn C'uj. Rajen Juan caj u yacsaj ja' tu jo'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Caj ts'oc u yacsic ja' tu jo'r Jesús ten Juan caj joq'uij Jesús ich chi' ja', caj yiraj u buj ca'anan. Seb caj yiraj Jesús u Taj'or u Pixam C'uj. Caj emij ti' ca'anan. Caj irir ten Jesús caj emij u Taj'or u Pixam C'uj oc yicnʌn Jesús. Irej susuy. ");
INSERT INTO lacNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Caj yubob tar u tar u t'ʌn ca'anan. Caj ya'araj C'uj: ―A techo' ―quij―, a jach in pararech, in jach yajech. A techo' caj a qui'quintaj in wor. ");
INSERT INTO lacNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Caj pay u ber Jesús ten u Taj'or u Pixam C'uj soc cu tumta'r yor ich tʌcay ru'um. A quisino', cu bin tumtic yor Jesús, quir yirir wa cu yacsic u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ti' yʌn ich tʌcay ru'um cuarenta u q'uinin. Caj u jamach p'at u janʌn u burur q'uin u burur ac'bir. Caj ts'oc u jamach p'ʌtic u janʌn. Jesús caj wichʌjij. ");
INSERT INTO lacNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","A quisino', caj u nʌts' u bʌj ich Jesús soc u tumtic yor Jesús. Caj ara'b ti' Jesús: ―Wa tech, jach taj u pararech C'uje', waysej a je' tunicha' waj ca' a waysej a wo'och waj quir a jantic. ");
INSERT INTO lacNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Barej Jesús caj u nuncaj. Caj ya'araj Jesús: ―Baxuc tu ts'iba'an u t'ʌn C'uj, cu ya'aric to'on: “Mʌ' chen a woch waj cu cuxquintiquech. A xibo' cu cuxtar wa cu ya'aric C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Caj payir Jesús ten quisin soc u bin ich u cajar Jerusalén. U winiquirob judío ti' cu naj c'ujinticob C'uj ich u cajar Jerusalén. Caj payir Jesús ten quisin ca'anan tu jo'r carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Caj ara'b ten quisin ti' Jesús: ―Wa jach taj u pararech C'uj, pur a bʌj ca' rubuquech. Quire' ―quij quisin― cu ya'aric u t'ʌn C'uj: Quire' a C'ujo' cu ya'aric ti' u yʌjmasir u t'ʌn C'uj: “Ca' a cʌnantej a mac in jach yaj. Je' a ric'siquex yejer a c'ʌbex cax mʌ' u nac ch'ʌctej tunich, soc mʌ' u yajtar u yocob ten tunich.” Baxuc caj u ya'araj quisin. ");
INSERT INTO lacNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús caj u nuncaj caj ya'araj ti' quisin: ―Baxuc cu ya'aric tu ts'iba'an u t'ʌn C'uj xan: “Mʌ' tsoy ic tumtic yor ic Jaj Ts'urirex C'uj soc ij quirej wa taj a ba' cu ya'aric.” ");
INSERT INTO lacNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tu ca' ten wʌc'ʌs payir Jesús ten quisin. Bin yejer quisin ich jo'r wits. Jach ca'anan u witsir. Caj esa'b ti' ten quisin soc yiric Jesús tu cotor u ru'umin tu cu reyinticob rey. Caj yiraj Jesús, jach tsoy u ru'umin tu cu reyinticob. ");
INSERT INTO lacNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Caj ara'b ti' Jesús ten quisin: ―Je' in ts'ic tech a je' ba' tu cotor, a je' tsoya' ich yoc'ocab, wa ca xontar tu yʌnen ca' a c'ujinten ―quij quisin. ");
INSERT INTO lacNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús caj u ya'araj ti' quisin: ―Joq'uen xen, quisinech. Quire' u t'ʌn C'uj cu ya'aric: “C'ujintej a Jaj Ts'ur C'uj. Jari' raji' ca beyaj ti'.” ");
INSERT INTO lacNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Caj ts'oc u tumta' yor Jesús, caj binij quisin, caj tarob u yʌjmasir u t'ʌn C'uj ich Jesús. Caj tarob yamta'bir Jesús ten yʌjmasirob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Caj yubaj Jesús mac Juan ich tu cu naj ma'cʌr winiquir. Caj wʌc'ʌs bin Jesús ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jesús mʌ' wʌc'ʌs cajij ich u cajar Nazaret. Caj bin u cʌjtar ich u cajar Capernaum. Ti' yʌn ich u chi'c'ac'nab. A Capernaum ti' yʌn ich u ru'umin Zabulón. Baxuc xan, ich u ru'umin Neftalí. ");
INSERT INTO lacNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Caj bin cʌjtar Jesús ich u cajar Capernaum quir u nup'sic u t'ʌn C'uj, baxuc caj u ts'ibtaj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Isaías caj ya'araj uch, cax mʌ' toy tac Jesús uch. Caj u toc araj Isaías: Tar yʌn ich u ru'umin Zabulón. Tar xan ich u ru'umin Neftalí. Ra' u berir ich chi'c'ac'nab. Chen pʌchir ya'arir Jordán tu cu tar ic yum. Ra' u ru'umin Galilea, ti' cʌja'an a mʌ' u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A mac yʌn u si'pirob, a cʌja'anob ich u ru'umin Zabulón yejer u ru'umin Neftalí. Je' yiricob yʌjtaquirobe' a mac a yʌn u si'pirob. A mac ti' cʌja'an ich yac'birir quire' yʌn u si'pirob, ti' cu bin c'uchur Cristo tu yʌnob soc u yacsic ti'ob a mʌ' u winiquirob judío ich u sasirir C'uj. Baxuc caj u ya'araj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Caj c'uchij tu cʌjtar Jesús ich u cajar Capernaum. Caj u yʌnxchun u tsec'tic u t'ʌn C'uj Jesús: ―C'axex a wor ―quij Jesús―. Ca' a p'ʌtex a c'asiro', quire' c'uchij tu q'uinin bin u ca' u reyinticob C'uj we'. ");
INSERT INTO lacNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús caj bin ich chi' c'ac'nab. U c'aba' u c'ac'nabir Galilea. Caj irir Pedro ten Jesús. U jer u c'aba' Pedro, Simón. Cu puric u chimin u chuc cʌy. Ti' yʌn yits'in Pedro, u c'aba' Andrés. Quire' ra' u beyajob Simón yejer Andrés, cu chuc cʌyob. ");
INSERT INTO lacNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Caj ara'b ti'ob ten Jesús: ―Cojenex ca' in camsechex ti' u t'ʌn C'uj, soc a camsiquex a rac'obex. Ra' a beyajex baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Seb caj u p'ʌtob u chuc cʌyob caj binob ich u pach Jesús. Simón yejer yits'in, caj binob tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sansame' ca' u ca' ir u jer. Ba'iri' ca'tur xan. Ca'tur yejer yits'in. Sucu'unbir Jacobo. Its'inbir Juan. P'eri' u tetob. Zebedeo u c'aba' u tetob. Ti' yʌnob ich chem yejer u tetob cu chuwicob u chimin u chuc cʌyob, quire' t'oc u chimin. Jesús caj u payaj ca' tacob tu pach u cʌnicob u t'ʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Seb caj u p'ʌtob u tetob yejer u chem quir u cʌnicob u t'ʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pachir caj man Jesús u camsic tu cotor u cajar ich u ru'umin Galilea. Cu yocar u camsej tu cu naj c'ujinticob C'uj u winiquirob judío ich u chan najir. Jujuntur u cajar cu yocar u camsej u t'ʌn C'uj. Caj u tsec' ti'ob bic cu bin u reyintic C'uj ich yoc'ocab. Cax a ba' yajir yʌn ti'ob cu rʌc jawsic Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Caj yubob u juminta' ti' yʌn Jesús ich u ru'umin Galilea hasta tu ru'umin Siria. Caj u yubob u juminta' bic cu jawsic mac, rajen tarob u puricob a mac yajob ich Jesús. Tu cotor a ba' yajire' yʌn ti'ob, caj tar u purob ich Jesús. A macob mʌ' u riq'uir ch'ictare', cu tar purbir. A macob aca'an quisin ti'e', cu tarob purbir ich Jesús. A macob cu sʌjquimin, cu tarob purbir ich Jesús caj rʌc jawsa'b u yajirob ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Caj tarob ich Jesús quir yubicob. Ti' u tarob ich pʌchir ya'arir Jordán. Ti' u tarob ich u ru'umin Galilea. Ti' u tarob ich u cajarob Decápolis. Ti' u tarob ich u cajar Jerusalén. Ti' u tarob ich u ru'umin Judea. Jach pim rʌc tarob ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Caj yiraj Jesús jach pim mac. Jesús caj naquij jo'r p'uc wits. Ti' curaj Jesús ich u jo'r wits. Caj nats'ob u camsʌwinicob Jesús ich u jo'r p'uc wits. ");
INSERT INTO lacNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Baxuc a jera' Jesús caj u camsaj u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Caj u camsaj Jesús caj ya'araj ti' u camsʌwinicob: ―Qui' yorob ―quij Jesús―, quire' yerob je' u jawsa'r u si'pirob ten C'uj. Quire' robob cu bin yamticob C'uj tu cu bin u reyintic ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Qui' yorob ―quij Jesús―, a mac mʌ' qui' yore' baje'rer, quire' cu bin u qui'quinta' yor ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Qui' yorob ―quij Jesús―, a cu tucricob u rac'ob. Chen u bʌjiri' mʌ' u tucric, quire' bin u c'ʌmej a ba' ara'b ti' ten C'uj quir u qui' cuxtar ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Qui' yorob ―quij Jesús―, a cu pachticob tu yor u manob ich u tsoyir. Quire' je' u yamta' ten C'uj soc u manob ich u tsoyir. ");
INSERT INTO lacNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Qui' yorob ―quij Jesús―, a cu tucric ti' u rac'ob, cu yamtic u rac'ob. Quire' C'uj cu bin u yajquintic a mac a cu yajquintic u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Qui' yorob ―quij Jesús―, a mac jawsa' u si'pir ten C'uj. Quire' je' yiricob C'uj ca'anane'. ");
INSERT INTO lacNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Qui' yorob ―quij Jesús―, a mac cu man u sisquintic u yor u rac'ob. Quire' a C'ujo' je' bin ya'aric: “Aro' in parar” ―quij―. ");
INSERT INTO lacNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Qui' yorob ―quij Jesús―, a mac a chucob u pachob, quire' cu manob tu tsoyir. Ti' cu bin u reyinticob ca'anan yejer C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Cax cu p'astic techex ―quij Jesús―, qui'quintej a worex. Cax cu che'tiquechex, qui'quintej a worex. Cax cu chuquicob a pachex, qui'quintej a worex. Jesús caj ya'araj: ―Cax cu pʌq'uicob a pachex quire' caj a wacsajex ta wor ti' in t'ʌn ―quij Jesús―. Qui'quintej a worex. ");
INSERT INTO lacNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Caj ya'araj Jesús ich u jo'r p'uc wits ti' u camsʌwinicob: ―Qui'quintej a worex, ca' tsoyac a worex wa ber cu p'astiquechexob. A C'ujo' ―quij Jesús―, ti' cu bin u qui' yacsiquechex ca'anan. Quire' caj a muctajex tu cu p'astiquechexob. Caj ya'araj Jesús: ―Baxuc caj u chucob u pachob yʌjtseq'uirob u t'ʌn C'uj tu cʌja'anob uch. ");
INSERT INTO lacNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Caj ya'araj Jesús ti' u camsʌwinicob: ―A techexo', irechex xa'an te' yoc'ocab. Chen wa cu jawar ch'och'er cu yubic mʌna' ch'och'. Wa mʌ' ch'och', jot mʌ' ba'wir ti', quire' mʌ' u ca' ch'och'tar. Rajen cu pich'intic mac. Rajen ca' a cʌnantex a muc' techex a ts'a'b techex ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Caj ya'araj Jesús: ―A cajaro', ich u jo'r wits, chʌca'an irir ten tu cotor mac. An ten bic a quibo' quir u yerc'ac'tic a mac cʌja'an ich yoc'ocab, baxuc techex xan, quir a yamtiquex mac quire' a werex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Baxuc a mac cu t'ʌbic u quib. Mʌ' u yacsic yaran ch'ac. Cu cuquintic u quib ca'anan soc sasir yatoch soc u yerc'ac'tic yatochob. ");
INSERT INTO lacNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Rajen ca' manaquex tu tsoyir ich a rac'ob soc chʌca'an yiricob, soc u bin u sʌjticob C'uj a mac ic Tetex a ti' yʌn ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Caj ya'araj Jesús ti' u camsʌwinicob ich u jo'r p'uc wits: ―Mʌ' taren in wa'aric techex quir a p'ʌtiquex u t'ʌn Moisés. Mʌ' taren in wa'aric techex quir a p'ʌtiquex a ba' caj u camsajechex yʌjtseq'uirob u t'ʌn C'uj uch. Caj ya'araj Jesús: ―Caj taren in camsiquechex soc a werex a ba' caj u ya'araj Moisés yejer yʌjtseq'uirob u t'ʌn C'uj. Quire' mʌ' taj caj u camsechexob yʌjcamsayʌjirob u t'ʌn Moisés baje'rer. Taren ―quij Jesús―, in rʌc nup'sej a ba' ara'b ich u t'ʌn Moisés, baxuc ich u t'ʌn yʌjtseq'uirob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","C'ʌ'otex a ba' quin wac techex ―quij Jesús―. Mʌ' xuruc t'ʌni' ich yoc'ocabi' hasta cu rʌc nup'ur u t'ʌn C'uj a ts'ibta'b ten Moisés uch. Mʌ' chichin cu p'atar ca' bin xuruc t'ʌn ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Caj ya'araj Jesús: ―A mac cu jenmastic u t'ʌn Moisés baje'rer, cax chichin cu jenmastic. Baxuc cu bin u camsic ti' u rac'ob, chen bay cu c'uchur ich ca'anan. Barej mac taj caj u quibaj u t'ʌn Moisés. Baxuc taj cu qui' camsic ti'ob u t'ʌn Moisés. Aro' ya'ab cu bin u ts'urintic ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Caj ya'araj ti' u camsʌwinicob, Jesús: ―A teno' ―quij Jesús―. Chich quin wac techex. Wa mʌ' jach manex tu tsoyir. Mʌ' ja wirej, u winiquirob judío a fariseojo' yejer u rac'ob a cu camsicob u t'ʌn Moisés mʌ' ju manob tu tsoyir. Mʌ' c'ucha'an a worex a bin ich ca'anan tu cu reyintic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Caj a wu'yaj ya'aric a nunquirex uch: “Mʌ' tsoy a quinsic mac. Wa cu quinsique', tar cu bin ʌcʌtan ich juez soc yer bic tabar caj u quinsaj.” ");
INSERT INTO lacNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Chen a teno' ―quij Jesús―. Quin chich aric techex: A mac cu ts'ictar yejer u bʌj, ti' cu bin ʌcʌtan C'uj soc yubic biquinin. Caj ya'araj Jesús: ―A mac cu p'astic u bʌj, ca' bin xic ʌcʌtan tu cotor a jach ts'urirob u winiquirob judío soc ya'aric bic caj u p'astaj. A mac a cu ya'aric ti' u bʌj: “Jach chich a jo'r tech”, tabar u bin yerar ich c'ac', quire' u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Rajen a teno', chich quin wa'aric techex. ");
INSERT INTO lacNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Wa tabarech a quinsej wacax a sije ti' C'uj soc u jawar a si'pir. Wa ca c'ʌ'otic tu ts'iquech yejer a bʌj, jamach p'ʌtej u bo'orir a si'pir. Ca' sutnʌc a sisquintej yor a bʌj. Jeroj caj ts'oquij a sisquintic yor a bʌj, tsoy a bin a quinsic wacax soc u jawsic a si'pir C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Wa yʌn winic cu bin u puriquech ʌcʌtan ich juez quir yiric wa ja bo'or ti'. Joq'uen sisquintej yor soc mʌ' u bin u puriquech ich juez. Quire' caj ts'oc yiric yʌn a si'pir, cu bin u c'ubiquech tu cu naj ma'cʌr winic. ");
INSERT INTO lacNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Jach taj quin wa'aric techex: Hasta ca qui' bo'otic policía cu joc'siquech. ");
INSERT INTO lacNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Caj ya'araj ti' u camsʌwinicob, Jesús: ―A techexo', a wu'ymʌn ya'ara' ten a nunquirex: “Mʌ' tsoy u man xib.” ");
INSERT INTO lacNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Chen a teno' ―quij Jesús―. Chich quin wa'aric techex: A mac tan tu yiric xquic. Cu pachtej u man yejer ra' xquico', irej wa cu jach man yejer quire' cu jach pachtic yor. ");
INSERT INTO lacNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Wa jumbuj a wich tabar u yacsic a si'pir, mʌ' ja quibej. Tucrej an ten bic caj a toc joc'saj a purej nachir. Mʌ' ja wirej, jach manan tsoyir a sʌtic turiri' a wich soc mʌ' a bin ich c'ac' munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wa ra' tabar u si'pir a c'ʌbe', mʌ' a quibej. Tucrej an ten bic caj a curch'ʌctaj caj a puraj. Quire' jach manan tsoyir a sʌtic a c'ʌb soc mʌ' a bin ich c'ac' munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Caj a wu'yex ya'ara' a nunquirex uch: “A mac a u c'at u p'ʌtic u rac'. Yʌn u cʌxtic ca' u ts'ibtej u ju'un soc tsoy u p'ʌtic u rac'.” ");
INSERT INTO lacNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Chen a teno' ―quij Jesús―, chich quin wa'aric techex: Mʌ' tsoy a p'ʌtiquex a rac'. Caj ya'araj ti' u camsʌwinicob, Jesús: ―Chen wa cu man yejer u jer mac tsoy a p'ʌtic. Chen a mac wa raji' cu ch'ic, a caj u p'ʌtaj a raq'ue'. Wa cu ch'ic u jer mac, cax mʌna' u si'pir chen caj u ch'aj u raq'uintej caj u pʌyaj u si'pir. Baxuc a p'ata'b ten u mam, yʌn u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Caj ya'araj ti' u camsʌwinicob, Jesús: ―A wu'ymʌnex ya'ara' ten a nunquirex uch: “Ca' a bo'otej, a caj a toc araj ti' C'uj, wa caj a chuquex C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Chen a teno' ―quij Jesús―, chich quin camsic techex; mʌ' tsoy a wa'ariquex: “C'uj cu yiric” wa ber ca toc ariquex ba' ti' mac. Ba'iri' xan: mʌ' tsoy a chuquex C'uj ca'anan, ti' taro' tu cu reyintic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mʌ' tsoyi' ―quij Jesús―, a chuquiquex ich ru'um, tu ca toc aric ba' ti' mac quire' C'uj ti' yʌn ich ru'um xan. Mʌ' tsoy a chuquiquex Jerusalén, tu ca toc ariquechex ba' ti' a rac'ob, quire' ra' u cajar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Cax mʌ' a wa'ariquex: “In jo'r cu yiric” tu ca toc ariquex ba' ti' mac. Quire' mʌ' c'ucha'an a worex a waysiquex a jo'rex sʌc, mʌ' ya'ax a jo'rex c'ucha'an a waysiquex. Cax turi' u tsotser a jo'rex mʌ' u c'uchur a worex ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jesús caj u ya'araj ti' u camsʌwinicob: ―Wa ca chen ariquex ti' a rac'ob: “Je' in bin” ―quech ti'―, wa “mʌ' jin bin” ―quech ti'―. Baxuc tsoy a nunquiquex ti'. Wa ju jer a t'ʌn ca waquex ti', ti' cu tar ich quisin. Rajen turi' t'ʌn ca nunquiquex soc u quibic a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Caj ya'araj ti' u camsʌwinicob, Jesús: ―A wu'ymʌnex ya'ara' ten a nunquirex uch: “Toc pʌquej u bo'orir yejer a mac caj u chucaj a pach.” ");
INSERT INTO lacNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Chen a teno' ―quij Jesús―, chich quin camsic techex: Mʌ' ja pʌquic u bo'orir a jach c'aso', cax cu raxic a techo'. Mʌ' a pʌquej a bʌj. Wa caj u raxaj jumbuj a p'uc. Ra' mʌ' a cʌniquex. Ca ts'ic u raxej jumbuj a p'uc xan. ");
INSERT INTO lacNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Caj ya'araj Jesús ti' u camsʌwinicob ich u jo'r p'uc wits: ―Wa mac u ta'quic a jo'r soc u ch'ic a noc'. Pitej a noc', ca' a ts'aj ti' ―quij Jesús―, cax u ca' ya'arir a noc' xan. ");
INSERT INTO lacNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Caj ya'araj Jesús: ―Wa cu ts'ʌric a pach soldado ca' a cuchej u ba'tac turi' nachir. Ca' arej ti': “Je' in cuchic ca'ture' nachir quir in yamtiquech.” ");
INSERT INTO lacNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Caj ya'araj Jesús ti' u camsʌwinicob: ―Wa mac caj u c'ataj tech a ba'tac. Mʌ' ja wa'aric mʌ' ja ts'ic ti'. Ts'ajex ti', cax a mac a cu tar u majantej. Ts'ajex ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Caj ya'araj ti' u camsʌwinicob, Jesús: ―A wu'ymʌnex ya'ara' ten a nunquirex uch ―quij Jesús―: “A mac cu yajquintiquex, quet yajquintej. A mac a cu p'actiquexo' quet a p'actiquex xan.” ");
INSERT INTO lacNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Chen a teno' ―quij Jesús―, chich quin camsic techex. Yajquintex a mac cu p'actic techex. Qui' t'ʌnex a mac a cu cʌrʌxt'ʌntiquex. Ca waquex ti': “Ca' u yamtech C'uj.” Qui' yamtex a mac a cu p'actiquechex. A mac cu p'actiquechex, t'ʌnex C'uj ti'. Cax cu che'tiquechex, t'ʌnex C'uj ti' xan. ");
INSERT INTO lacNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Caj ya'araj Jesús ti' u camsʌwinicob: ―Wa ca yaj a cu p'actiquechexo' u pararechex C'uj, caj a cʌnex C'uj. Quire' a C'ujo' cu yajquintic mac, cax ti' yʌn a c'aso', cax a ti' yʌn a tsoyo'. A C'ujo' cu cha'ic u tar ja' ti' a c'aso' soc u ch'ijir u pʌc'ar. Baxuc xan, ti' a tsoyo', cu cha'ic u tar ja' soc u ch'ijir u pʌc'ar xan. ");
INSERT INTO lacNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Caj ya'araj Jesús: ―Wa ca chen yajquintiquex a mac a yajexe'. Je' wa ju bo'otiquechex C'uj. Mʌ' ju bo'otiquechex, quire' a mac jach c'as xano', cu yajquintic a ju jach yaj u rac'ob. U jeroj, mʌ' ju yajquintej, cu p'actic. ");
INSERT INTO lacNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Caj ya'araj Jesús ti' u camsʌwinicob: ―Ba'wir ca t'ʌniquex a rac'ob chen mʌ' a t'ʌniquex a cu p'actiquechex. Tsoy wa mʌ' a tsoyi'? ―quij Jesús―. Quire' a mac mʌ' yer C'uj baxuc cu t'ʌnic u rac'ob xan, mʌ' ju t'ʌnic a mac cu p'acticob. ");
INSERT INTO lacNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Cʌnex C'uj ―quij Jesús―. Quire mʌna' u si'pir a C'ujo' soc irechex C'uj, mʌna' a si'pirex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Caj ya'araj ti' u camsʌwinicob, Jesús ich u jo'r p'uc wits: ―Wa ca manex ta tsoyir soc chen yiric ten a rac'ob. Mʌ' ju bin u qui' bo'otiquechex ic Tet C'uj a mac ti' yʌn ich ca'anan. Rajen cʌnantechex a bʌj tu ca manex tu tsoyir. ");
INSERT INTO lacNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Rajen ―quij Jesús―, quin wa'aric techex. Wa ca wiriquex mʌna' noc'. Cu ts'oc a jʌsiquex ti', chen mʌ' a manex a wa'arex ti' tu cotor mac irex wa ca'tur u tucur. Mʌ' ja wirej, aro' cu man ya'aric soc ya'aric ti': “Jach tsoyech quire' caj a jʌsaj ti'.” Baxuc u c'at yubicob u jumintej tu cu man u c'ujinticob C'uj a fariseojo'. Baxuc u c'at yubicob u jumintej tu cu man u t'ʌnicob u rac'ob a ca'tur u tucuro'. Taj quin wa'aric techex, toc bo'ota'b ten u rac'ob caj ya'arajob: “Jach tsoyech.” ");
INSERT INTO lacNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Chen a teno' ―quij Jesús―, quin camsic techex. Wa ca jʌsiquex mac mʌna' ba' ti'. Mʌ' ja manex a wa'arex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Muc u ts'ajex ti' ba', a mʌna' ba' ti'. A C'ujo', cu yiric a muc u ts'iquex ti'. Je' u qui' bo'otic techexe' ca' bin xiquechex ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Caj ya'araj Jesús ti' u camsʌwinicob: ―Mʌ' ja bin a t'ʌnex C'uj irechex ca'turex a tucurex. Quire' cu ch'ictarob tu cu naj c'ujinticob C'uj u winiquirob judío ca' tus iric ten u rac'ob. Baxuc a mac cu t'ʌnicob ich tanbej, ca' tus iric ten u rac'ob. Jesús caj u ya'araj: ―Taj quin wac techex. Yʌn u bo'orir quire' irir ten u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Chen a teno' ―quij Jesús―. Quin camsic techex, ca' bin a t'ʌnex C'uj ta junanex. Mʌ' ich tu yʌn pim winic. Mʌc u jor jun c'as a watochex, ca' a t'ʌnex C'uj ta junʌn, soc mʌ' chʌca'an yiricob techex a rac'ob. A C'ujo', cu yiric ca t'ʌniquex ta junanex, je' u bo'otiquechex biq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Caj ya'araj Jesús: ―Ca' bin a t'ʌnex C'uj, mʌ' a ca'ca' ariquex irechex wa mac mʌ' yerob C'uj. Aro' ya'ab cu tsicbarob. Cu tus tucricobe', cu yubic ti'ob u tus C'uj a ya'ab cu tsicbarob. ");
INSERT INTO lacNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Caj ya'araj Jesús: ―Rajen mʌ' ja yʌn cʌniquex, a mac a mʌ' yerob C'uj. Mʌ' ja wirej, cax a techex mʌ' toj a c'atex ba' ti'. A C'ujo', yer ba' a c'atex, cax mʌ' toj a t'ʌniquex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Caj u ya'araj Jesús: ―A je' quin camsic techex. Cʌnex a t'ʌnex C'uj. Arex ti' C'uj: Ic Tet ca'anan, ca wa'ariquex ti'. Ca' u sʌjtejob a c'aba' tu cotor mac, C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sebquintej a tar C'uj quir a reyintic C'uj ich yoc'ocab ―quechex ti'―. Ca' in quibob a t'ʌn C'uj te' yoc'ocab an ten bic u quibicob a tar ca'anano', a yʌjmasirob a t'ʌn tech C'uj ―quechex ti'―. ");
INSERT INTO lacNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Chuquej tenob in wo'och waj, soc ti'ti' tenob. ");
INSERT INTO lacNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ca' a jawsej in si'pirob ―quechex ti' C'uj―, an ten bic ca' in jawsej u si'pirob in rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Taquej a tenob, tu cu tumtic in worob a quisino' ―quechex ti' C'uj―. A techo', C'uj, c'ucha'an a wor a reyintic ich yoc'ocab. A techo', C'uj, yʌn a muc' quir a reyintic ich yoc'ocab. Ca' u qui' c'ujintiquech, C'uj, tu cotor mac ich yoc'ocab. Ca' u c'ujintiquech munt q'uin ―quechex ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Mʌ' ja wirej, an bic tech, ca jawsic u si'pir mac. Baxuc tech cu jawsic a si'pir C'uj. Raji' a Tet ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wa tech mʌ' ja jawsej u si'pir a rac'ob, baxuc mʌ' ju jawsic a si'pir a Tet C'uj xan. ");
INSERT INTO lacNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Wa ber u q'uinin ca jamach p'ʌtiquex a janʌnex soc a t'ʌniquex C'uj. Mʌ' ja cha'iquex yiricob a rac'obex, caj a jamach p'ʌtajex a janʌnex. Quire' a mac ca'tur u tucurob, cu yesicob ti' u rac'ob tu jamach p'ʌticob u janan. Raji'ob cu tus tucurob soc irir ten u rac'ob. Ya'araj Jesús: ―A teno', taj quin camsic techex. A ca'tur u tucurob, toc bo'ta'an ten u rac'ob quire' irir ten u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Wa ber u q'uinin ca jamach p'ʌtiquex a janʌnex quir a t'ʌniquex C'uj. Qui' tsictej a jo'rex. Qui' p'o'ej a wichex ");
INSERT INTO lacNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","soc mʌna' mac yer caj a p'ʌtex a janʌnex. Chen a C'ujo', ti' yʌn yejerechex tu junan, caj u yiraj ta jamach p'ʌtajex a janʌnex. Raji' cu bin u bo'otic techex biq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesús caj ya'araj ti' u camsʌwinicob ich u jo'r p'uc wits: ―Mʌ' tsoy u net'ajar a taq'uinex ich yoc'ocab quire' je' u yajtar, a worex ti'. Mʌ' ju xʌntar quire' je' u rʌc janta' ten c'ʌmʌs. Bayiri ca sʌtiquex a taq'uinex xan. Mʌ' ja wirej, yʌn mac cu yocar ta watochex cu yacric a taq'uinex xan. ");
INSERT INTO lacNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","’Rajen qui' p'isex a bʌj quir a cuxtarex ich ca'anan, quire' aro' irechex a mac yʌn u taq'uin ich ca'anan. Tu mʌ' u janta' ten c'ʌmʌs. Mʌ' ju rapar, mʌ' ju yocar mac u ya'cric techex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ca wiric ―quij Jesús―, a tu yʌn a taq'uinex raji' ca pachtiquex. Raji' ca pachtiquex a taq'uinex wa yʌn ich yoc'ocab. Wa ti' yʌn a taq'uinex ca'anan, ti' ca pachtiquex a binex ca'anan xan. ");
INSERT INTO lacNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Caj ya'araj Jesús ti' u camsʌwinicob: ―A wichexo' irej quib. Quire' ra' ca c'ʌniquex soc u yerc'ac'tic a berex. Baxuc a wichexo', wa sasirchʌji a wichex, mʌ' ja manex tu yac'birir, quire' sasirchʌjij a wichex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Chen waj ac'birchʌjij a wichex ca manex tu yac'birir. Baxuc a tucurex xan. Wa tsoy a tucurex, ca bin a qui' najtex tu cu bin u reyintej C'uj. Wa mʌ' ja c'ʌmajex C'uj, mʌ' tsoy a tucurex, irechex a cu manob tu yac'birir, a jach manan ac'biro'. ");
INSERT INTO lacNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Mʌna' mac c'ucha'an yor u beyaj a ca'tur u ts'uriro'. A ca'turo' u ts'uriro', cu p'actic junturi'. Turiri' cu yajquintic u ts'urir. A ca'turo' u ts'uriro', mʌ' u qui' beyaj ti'. Turiri' u ts'urir cu qui' beyaj ti'. Baxuc techex, mʌ' c'ucha'an a worex a yajquintex C'uj wa ca yajquintex a taq'uinex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Caj ya'araj Jesús ti' u camsʌwinicob: ―Chich quin wa'aric techex. Mʌ' ja tucriquex ba' ca bin a jantex. Mʌ' ja tucriquex a ba' ca bin a wuq'uiquex. Mʌ' ja tucriquex bic ca bin cuxtarex. Mʌ' ja tucriquex a noq'uex ba' ca bin a buquintex. A C'ujo' ―quij Jesús―, ra' cu cʌnantic techex. Mʌ' wa ra' cu bin u ts'ic techex a wo'ochex, cax a noq'uex xan? ");
INSERT INTO lacNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jesús caj ya'araj ti' u camsʌwinicob: ―Irej a wirex. A ch'ich'o', cu ch'ic u xic' ca'anan. Mʌ' ju pʌq'uicob yo'och irej winic. Mʌ' ju jaq'uicob yo'och a ch'ich'o', irej winic. Mʌna' u ca'anche'ir irej winiquir. Chen a C'ujo' cu ts'ic yo'och. Mʌ' ja wirej, jach manan cojir techex, chen a ch'ich'o', mʌ' coji' ʌcʌtan tu wich C'uj. Rajen a C'ujo' cu cʌnantic techex quire' u jach yajechex a C'ujo'. ");
INSERT INTO lacNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Caj ara'b ti'ob ten Jesús: ―Arej ten ―quij Jesús―, tu yʌnechex a c'ucha'an yor u bʌji' ca' u betej ca' sats'ac cu nesats'ar u baquer, cax chumuc metro? Mʌna' mac c'ucha'an yor u betic ca' sats'ac u baquer chichin. ");
INSERT INTO lacNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Caj ya'araj Jesús ti' u camsʌwinicob: ―Biquinin ca tucriquex a noq'uex? Cʌnex irechex u top'che' tu cu wac'ar u top'. Mʌ' ju beyaj, mʌ' ju c'uch irej winic, u top' a che'o'. ");
INSERT INTO lacNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Cax mʌ' ju beyaj, cax mʌ' ju c'uch. U top' a che'o', u bʌjiri' cu wac'ar, barej jach manan u tsoyir u top' a che'o'. Quin wac techex ―quij Jesús―. A werex Salomón uch, a cu reyintic a nunquirex uch. Raji' mʌ' ju buquintej jach tsoy u noc'. A ju top' che'o' jach manan tsoyir. A Salomóno' mʌ' jach tsoy u noq'ui'. ");
INSERT INTO lacNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Caj ya'araj Jesús ti' u camsʌwinicob: ―A C'ujo', caj u betaj a su'uc a ti' yʌn baje'rer chen samʌn mʌna'. Cu bin erar. Cax a su'uco' tabar u bin, chen qui'quintex a worex, quire' a C'ujo' jach manan u cʌnantiquechex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Rajen mʌ' a yʌn tucriquex a ba' ca bin a jantex. Mʌ' ja tucriquex a ba' ca bin a wuq'uiquex. Mʌ' ca bin a tucriquex a ba' ca bin a buquintex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A mac mʌ' yer C'uj rajra' cu cʌxticob ba' cu bin u jantejob. Rajra' cu cʌxtejob yuq'uej. Rajra' cu man u cʌxtejob u buquintejob noc'. Caj u ya'araj Jesús: ―Yʌn a Tetex ca'anan a mac cu cʌnantic techex. Raji' yer a ba' a c'atex. Raji' C'uj ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Barej ―quij Jesús―, pʌyber arex ti' C'uj: Ca' a reyintex C'uj. Bayiri' xan, ca' qui'quintaquex yor C'uj ca' manaquex ich u tsoyir. Wa baxuc caj a quibex je' u ts'ic techex tu cotor ba' a c'atex. Cax a wo'ochex, je' u ts'ic techex. Cax a noq'uex, je' u ts'ic techex. Cax a wuc'urex je' u ts'ic techex. ");
INSERT INTO lacNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Caj ya'araj ti' u camsʌwinicob Jesús: ―Rajen ―quij Jesús―, ba'wir ca wac'tiquex a ba' ca' bin tac samʌn. Ti' ti' a ba' ca wac'tiquex baje'rer. Ba'wir ca xaquiquex, a ca wac'tiquex a ba' cu bin tar samʌn yejer a ca wac'tiquex baje'rer. Ca' ic tucriquex a ba' cu tar samʌn quire' u q'uinin samʌni'. ");
INSERT INTO lacNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesús caj u ya'araj ti' u camsʌwinicob ich u jo'r p'uc wits: ―Mʌ' a yʌn tucriquechex, wa tsoyechex quir a wocar juezirechex ti' a rac'ob, soc a ta'quiquex u jo'r. ");
INSERT INTO lacNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wa ca wocarex juezirechex quir a ta'quiquex u jo'r a rac'ob. An ten bic techex caj a ta'quex u jo'r a rac'ob, baxuc C'uj cu bin u ta'quic a jo'r techex. Toc jawsex a ba' c'asir caj u betaj techex a rac'ob, soc C'uj cu jawsic ba' c'asir caj a betajex xan. ");
INSERT INTO lacNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Biquinin ca pʌq'uiquex u pach a rac'ob, cax chichin ba' yʌn ti'? Mʌ' ja wirej, a ba' yʌn techex, a cu pʌq'uicob u pach u rac'ob, jach manan c'as. Aro' irej a cu yiric u p'up'ir a chichino' tu wich u rac'ob. Chen u bʌjiri', mʌ' ju c'ʌ'otic yʌn u p'up'ir jach carem tu wich. ");
INSERT INTO lacNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Caj ya'araj Jesús: ―Mʌ' ja wirej, wa ca tsicbarex ti' a rac'ob a ba' caj u yʌn betaj uch. Chen a techexo', a ba' yʌn techex jach c'as, aro' irej wa ca wa'ariquex ti' a rac'ob: “Arej in ruc'sej u p'up'ir a wich a chichino'.” Chen a techexo', u p'up'ir ta wichex jach carem. ");
INSERT INTO lacNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","A techexo', ca'tur a tucurex. Mʌ' ja wirej, ca' a p'ʌtex a jach c'aso' techex soc c'ucha'an a worex a yamtiquex a bʌjo' ca' u p'ʌtej u c'asir a cu betic chichin. ");
INSERT INTO lacNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Caj ya'araj Jesús ti' u camsʌwinicob: ―Jaj ix tʌcoj, mʌ' tsoy ca wesiquex C'uj ti' mac a jach tam u pixam. Jaj ix tʌcoj, cu ts'ictar wa ca tsicbar ti' u t'ʌn C'uj, irej pec' wa ca ts'iquex ti' yo'och. Cu chen tar u chi'echex. Irej q'uec'ʌn cu tar u ya'ch'ʌctic uj wa ca puriquex ti' a wujex a jach co'oj. ");
INSERT INTO lacNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesús caj u camsaj ti' u camsʌwinicob ich u jo'r p'uc wits: ―C'atex ti' C'uj a ba' a c'atex. Je' u ts'ic techex C'uj. Mʌ' ja wirej, aro' irechex ca c'atiquex ba' ti' a rac'ob, jeroj cu ts'ic techex. Wa ca t'ʌniquex mac tu yatoch. Jeroj cu yacsiquechex. ");
INSERT INTO lacNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wa ca cʌxtiquex a ba' a c'atex. Jeroj je' a wiriquexe'. ");
INSERT INTO lacNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Caj ya'araj Jesús ti' u camsʌwinicob: ―Je' wa ja ts'iquex u jantej a pararex tunich, wa cu tar u c'atic techex yo'och waj? A techexo', ca ts'iquex ti' yo'och waj quire' a parar. ");
INSERT INTO lacNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Je' wa ca ts'iquex quir u chi'ic can, wa cu c'atic techex cʌy quir u chi'ic? Je' a ts'iquex ti' yo'och cʌy. ");
INSERT INTO lacNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Caj ya'araj Jesús ti' u camsʌwinicob: ―Cax c'asechex, ca ts'iquex ti' a pararex a ba' jach tsoy. Mʌ' ja ts'iquex ti' a pararex a ba' c'asi'. Baxuc a C'ujo'. Jach manan tsoyir cu ts'ic ti' a mac cu c'atic ti'e'. A mac cu c'atic ti' ic Tet C'uj ca'anan. Ts'aja'an yor cu ts'ic ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Rajra' ca' a yamtex a rac'ob an ten bic a c'atex u yamtiquechex xan. Wa baxuc ca betiquex caj a toc quibex a ba' ts'ibta'b ten Moisés yejer yʌjtseq'uirob u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Caj ya'araj Jesús ti' u camsʌwinicob: ―Cax jach yaj a wu'yiquex a p'ʌtiquex a ba' ca pachtiquex ta worex. Chen p'ixex a bʌjex soc a p'ʌtiquex aro' quir a quibex u t'ʌn C'uj, soc a binex ca'anan. A teno' ―quij Jesús―, quin wa'aric techex. Mʌ' ya'ab cu bin c'uchur ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mʌ' ja wirej, aro' an ten bic chichin u jor tu cu yocar, baxuc u bej, jach c'ax tu cu manob. Chen a mac a cu manob tu cu pachticob tu yorob ti' yʌnob ich co'coch u jor quir u yocarob. Baxuc ti' yʌnob ich co'coch u bej tu cu manob. Chen ca' bin xicob ʌcʌtan C'uj ti' cu bin joc'sa' ten C'uj ca' xicob ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Qui' cʌnantex a bʌjex soc mʌ' u tusiquechex u tus ʌjcamsʌyʌjirob u t'ʌn C'uj. Raji'ob cu ya'aricob: “Mʌ' jach caremenobi'”, chen jach c'asob. ");
INSERT INTO lacNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Je' a c'ʌ'otiquex a tus ʌjcamsʌyʌjirob u t'ʌn C'uj, quire' je' a wiriquex u manob ich u c'asir. Mʌ' ja wirej, je' wa ja bin a wirex u wich uva ich u che'er a yʌn u q'ui'ixere'. Mʌ' ra' u yaq'uir u wich uva. Mʌ' ja bin a wirex u wich higo ich u che'er a yʌn u q'ui'ixere'. Mʌ' ra' u che'er u wich higo. ");
INSERT INTO lacNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Cʌnex a jera' ―quij Jesús―. Wa tsoy u che'er tsoy u wich xan. Wa mʌ' tsoy u che'er, c'as u wich xan. ");
INSERT INTO lacNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A tsoy u che'er, mʌ' u c'astar u wichi', tsoy u wich. A c'as u che'er cu c'astar u wich. Mʌ' c'ucha'an yor u tsoyquintej u wichob, quire' c'as u che'er. ");
INSERT INTO lacNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Baxuc raji'ob a tus yʌjcamsʌyʌjirob u t'ʌn C'uj. A tu cu beyajob ca bin a wirex wa cu manob tu tsoyir wa cu chen tusaricob. C'ʌ'otex a c'as u che'er, cu joc'sic mac quir u toquej. ");
INSERT INTO lacNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Baxuc a tus ʌjcamsʌyʌjirob cu bin yubicob u ts'iquir C'uj. Tar cu binob ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesús caj ya'araj ti' u camsʌwinicob: ―Tu cotor mac a cu t'ʌnic ten: “Jaj Ts'ur” ―quij―, irej wa caj u c'ʌmaj in t'ʌn. Mʌ' jin bin in wacsic tu cu reyintic C'uj. Jari' a mac a cu quibic u t'ʌn in Tet ca'anan. Ra' quin bin in wacsej. ");
INSERT INTO lacNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","U q'uinin ca' bin c'uchuc, tu q'uinin u xur t'ʌn, ya'ab mac cu bin mamax a'aric ten: “Jaj Ts'ur, caj in tsec'taj a t'ʌn. Caj in joc'sob c'ac'as quisin xan. Caj in wa'arob: Joq'uen c'ac'as quisin ich u c'aba' Jesús. Baxuc caj in betob carem tech.” Baxuc cu bin ya'aric ti' ten ca' bin xuruc t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ra' u q'uinin ca' bin in c'asej ti'ob. Je' in wac ti'ob: “Mʌ' jin wer maquechex. Mʌ' jin wirmʌnechex.” Quin bin in wa'aric ti'ob: “Xenex quire' caj manex ta c'asir.” ");
INSERT INTO lacNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesús caj ya'araj ti' u camsʌwinicob: ―A mac jach t'aj cu yubic in t'ʌn, cu quibic a ba' quin chich aric ti'. Aro' irej a cu cʌxtic u panic yoc naj tu yʌn tunich soc mʌ' u riquir. ");
INSERT INTO lacNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pachir caj tarij ja', caj burij, caj tarij ic' yejer ja'. Caj u pecsaj naj ic' yejer ja'. Chen mʌ' riqui' naj quire' chich yoc u najir. Rajen mʌ' ju riquir. ");
INSERT INTO lacNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Caj ya'araj Jesús: ―A mac cu yubic in t'ʌn chen mʌ' ju quibej irej a mac jach chich u jo'r. Mʌ' ja wirej, aro' caj u c'ʌxaj naj tu jup'. ");
INSERT INTO lacNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Caj tarij ja', caj burij. Caj tarij ja' yejer yic'ar. Caj u pecsaj naj. Caj riquij yoc. U najir caj rup' ich ru'um. C'am caj rup' u najir. Caj u jac'saj yor mac. ");
INSERT INTO lacNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Caj ts'oc u camsic u camsʌwinicob Jesús. Jach jaq'uij yorob caj yubob bic caj u camsaj ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Quire' caj u camsaj ti'ob a ju jach ne'er u camsic ti'ob. Mʌ' ju camsaj bajen yʌjcamsʌyʌjirob u t'ʌn Moisés. Raji'ob mʌ' u ne'er u camsicob. Quire' yejer u muc' C'uj Jesús cu camsic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Uche' ti' yʌn Jesús ich u jo'r p'uc wits. Caj emij caj rʌc sayob tu pach mac. Jach pim caj binob tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Caj u juts'aj u bʌj tu yʌn Jesús ra' u cʌnmʌn iq'uer u ca', xib. Caj xonraj ich tu yʌn Jesús. Caj ya'araj: ―In wer c'ucha'an a wor a jawsiquen Jaj Ts'urir wa ja c'at a jawsiquen ―quij a iq'uer u ca'. ");
INSERT INTO lacNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús caj u tʌraj a iq'uer u ca'. Caj u tʌraj Jesús caj ara'b ten Jesús: ―In c'at in wiric a jawʌr ―quij Jesús. Seb caj toc jawij iq'uer u ca'. ");
INSERT INTO lacNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Caj u toc araj ti', Jesús: ―Iric, mʌ' a bin a wa'aric tu ca man bic jawech. Chen tar a bin ich sacerdote u winiquirob judío quir a sijic ti' a ba' ya'ara' Moisés uch. Soc yer tu cotor mac jawsa'bech ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Caj c'uchij ich u cajar Capernaum caj u nup'aj u winiquir romano. Yʌjt'ʌnin cien soldados caj c'uchij ich Jesús caj u chich c'ataj ca' xic ich yatoch. ");
INSERT INTO lacNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Caj ya'araj ti': ―Jaj Ts'urir ―quij―. Yaj in c'urew ti' yʌn tin watoch. Jach yaj mʌ' u pec. ");
INSERT INTO lacNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús ara'b ti'e': ―Jeroj, cux in jawsej. ");
INSERT INTO lacNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Caj u nuncaj yʌjt'ʌnin cien soldados: ―Jaj Ts'urir, mʌ' tsoy in wacsiquech tin watoch, quire' yʌn in si'pir. Ca' a jawsej in c'urew. ");
INSERT INTO lacNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mʌ' ja wirej, cax yʌjt'ʌninen cien soldados quin ts'urintic. Ra' in ts'urir a mac a cu ya'aric in beyaj, ra' in jach ts'urir. Rajen wa quin t'ʌnic turiri' in soldado ca' xic, cu bin. Wa quin t'ʌnic u jer ca' tac, cu tar. Wa quin t'ʌnic in c'urew ca' xic tu beyaj, cu bin. Baxuc a techo', in wer wa ca wa'aric ca' jawʌc, je' u jawʌre'. ");
INSERT INTO lacNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Caj ts'oc yubic Jesús a ba' ara'b ti' ten yʌjt'ʌnin cien soldados caj jaq'uij yor Jesús. Caj u t'ʌnaj a mac a cu tar u cʌnicob u t'ʌn. Caj ya'araj Jesús: ―Mʌ' in wiramʌn mac tu cotor ich u winiquirob judío, wa caj u qui' acsaj tu yor an bic yʌjt'ʌnin cien soldados. Ra' caj u qui' acsaj tu yor ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Caj ya'araj Jesús ti': ―U'yex ba' quin wac. Tar u tar jach pim ich yoc'ocab, quire' u yet binacob Abraham yejer Isaac yejer Jacob, soc p'eri'ob u cʌjtarob ich ca'anan tu cu bin u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Barej a techexo', a cu tus ya'aricob: “A tenob, in nunquirob Abraham, rajen cu bin u yacsiquenob C'uj.” Chen a teno', quin wa'aric techex, cu bin joc'sa'birechex ten C'uj ich c'ac'. Ti' ca bin a jʌch'iquex a cojex ich c'ac', quire' jach yaj ca bin a muc'yajex. Ta ca bin a wac'tiquex a bʌjex ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Caj ya'araj Jesús. Ya'araj ti' yʌjt'ʌnin cien soldados: ―Xen ta watoch. A ta wu'yaje', toc jaw, quire' caj a wacsaj ta wor. Ra' u q'uinin caj jaw u yajir u c'urew yʌjt'ʌnin cien soldados. ");
INSERT INTO lacNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús caj bin tu yatoch Pedro. Caj yiraj yixquit Pedro. Caj yiraj characbar tu ch'ac, yaj u jo'r. ");
INSERT INTO lacNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Caj tar u c'ʌb yixquit ten Jesús. Caj jaw u yajir u jo'r. Caj riq'uij, caj yʌnx chun u jansic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Caj ac'birchʌjij, caj tar u much'quinticob u bʌjob ich Jesús. Jach pim caj rʌc tar ich Jesús. Caj tarob purbir ti', a aca'an ti'ob quisin. Caj rʌc joc'sa'b u quisinin ten Jesús. Caj u t'ʌnaj quisin ca' jocac. Rʌc jaw u yajirir a mac a jach tar purbir ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jawsa'b ten Jesús tu cotor mac quir u nup'ur u t'ʌn a ts'ibta'b ten yʌjtseq'uir u t'ʌn C'uj, Isaías uch. Caj ya'araj Isaías uch: “U bʌjiri' Cristo cu bin u jawsic u yajir a mac yʌn ti'”, baxuc caj ya'araj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Caj yiraj jach pim mac Jesús. Mʌ' tu cu man, quire' jach pim. Caj ya'araj: ―Ca' xico'onex pʌchir c'ac'nab. ");
INSERT INTO lacNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A ra' u q'uinino', caj c'uchij yʌjcamsʌyʌjir u t'ʌn Moisés ich Jesús. Caj ara'b ti' ten yʌjcamsʌyʌjir u t'ʌn Moisés: ―In wʌjcamsʌyʌjirech, arej in tar ta pach quir in cʌnic a t'ʌn cax tu ca bin. ");
INSERT INTO lacNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús caj u nuncaj ti': ―A bʌc'o' yʌn u way tu cu wenʌn. A ch'ich'o' yʌn u c'ʌ'che' tu cu wenʌn. Barej a teno', a baxuquenechexo', mʌna' in watoch tu quin wenʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","U jer u camsʌwinicob caj ya'araj ti' Jesús: ―Arej in yʌn p'atʌr ich yicnʌn in tet hasta cu quimin. Ca' bin ts'ocac u quimin, caj in mucaj u baquer in tet. Quin tar ta pach quir in cʌnic a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús caj u nuncaj ti': ―Cojen tin pach. Tsire'ej a tet. Arej a mac a toc quimen ʌcʌtan tu wich C'uj, quire' mʌ' ju yacsob tu yorob, ca' u muquejob u baquer u quimirirob. ");
INSERT INTO lacNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Caj ts'oc aro'. Jesús caj oquij ich chem quir u ch'ʌctic c'ac'nab. Yet binac u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Caj tar yic'ar tu yʌnob ich c'ac'nab. C'am yic'ar caj tarij. Caj burij u chem quire' u yaminin. Wenʌn u ca' Jesús caj burij chem. ");
INSERT INTO lacNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","U camsʌwinicob caj as Jesús caj ya'arob: ―Tabar in jururob, Jaj Ts'urir. Cʌnante tenob soc mʌ' in jururob. ");
INSERT INTO lacNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús caj u nuncaj ti' u camsʌwinicob: ―Biquinin sajaquechex? Chichin a wacsmʌnex ta worex. Caj riq'uij Jesús u t'ʌnej yic'ar. Quet caj ch'en yic'ar yejer u yaminin. Qui' ch'en u yaminin. Qui' ch'en yic'ar xan. ");
INSERT INTO lacNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Caj yirob u camsʌwinicob caj jaq'uij yorob. Caj ya'arajob: ―Ba' xibiri' a jera', cax cu jawsic u tar yic'ar? Cax u yaminin c'ac'nab cu jawsic. ");
INSERT INTO lacNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Caj c'uchij Jesús pʌchij c'ac'nab tu ru'umin Gadara. Ca'tur xib caj c'uchob ich Jesús tu cu but'ur u baquer macob. Ti' cʌja'anob tu cu but'ur u baquer macob. Caj joc'ob tu japnin tunich tu cu but'ur u baquer macob. A ca'tur xibo' yʌn u quisinin. Jach ts'icob, rajen mʌ' u cha'bʌrob u manob u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A mac aca'anob ti' quisine', ra' caj u purob u t'ʌn ti' Jesús. Caj ya'arob: ―Ba' a c'at tenob Jesús? A techo', u pararech C'uj. Tarech a puriquenob ich c'ac' cax mʌ' c'uchuc tu q'uinin? ");
INSERT INTO lacNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mʌ' nenach yʌn tu yʌn Jesús yejer u camsʌwinicob. Ti' yʌn aca'anob c'ac'as quisini'. Ti' yʌn yʌrʌc' cajij q'uec'ʌn, jach pim. Cu manob u janʌnob xiw. ");
INSERT INTO lacNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","A quisino', aca'anob ich a ca'tur xib, caj u chich c'atajob ti' Jesús: ―Ar in binob ich cajij q'uec'ʌn wa ca joc'siquenob. ");
INSERT INTO lacNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Caj u nuncaj Jesús caj u ya'araj ti'ob: ―Xenex ―quij. Caj joc' u quisinin ich xibob, caj bin ich u cajij q'uec'ʌn. Caj yubob u quisinin u cajij q'uec'ʌn caj ruc' yac'ab. Caj ruc' yac'ab ich ch'ica'anin wits. Caj u purob u bʌjob ich c'ac'nab. Caj rʌc bint ja', caj rʌc quimin. ");
INSERT INTO lacNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A cu cʌnanticob u yʌrʌc' cajij q'uec'ʌn, caj yirob u rʌc bin cajij q'uec'ʌn, caj jaq'uij yorob. Caj u c'ʌnajob yac'ab, caj u bin ya'arajob tu cajar a ba' u ber ti' u yʌrʌc' cajij q'uec'ʌn. Caj binob ya'arej tu cajar ba' u ber ti' u rac'ob, a mac aca'anob quisin ti' u rac'ob xan. ");
INSERT INTO lacNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Caj rʌc joc'ob tu cajar tu cotor mac. Caj binob ich Jesús. Caj yirob Jesús caj chich ara'b ti' Jesús: ―Xen tech ich u jer ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Caj ts'oc aro' caj oc Jesús ich chem. Caj bin pʌchir c'ac'nab quir u bin ich u cajar Capernaum. Caj urij ich Capernaum. ");
INSERT INTO lacNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Caj tarob purbir a mech yoc ten u rac'ob. A mech yoco' xib, characbar ich ch'ac. Jesús caj u yiraj bic tabar caj u yacsajob tu yorob, caj u t'ʌnaj a mech yoco': ―Qui'quintej a wor in pararech. Tsoy in wiriquech quire' toc jaw a si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ti' yʌn yʌjcamsʌyʌjirob u t'ʌn Moisés ich Jesús. Mʌ' ya'ab ti' yʌnob. Chen tu yorob caj u mucu arob, caj ya'arob: “Cu pach'ic C'uj, Jesús wa ber cu ya'aric baxuco'.” ");
INSERT INTO lacNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","A Jesúso', yer a ba' cu tucricob tu yorob a yʌjcamsʌyʌjirob u t'ʌn Moisés. Ara'b ti'ob ten Jesús: ―Mʌ' a yʌn tucriquex c'as. ");
INSERT INTO lacNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Jesús caj ya'araj ti' yʌjcamsʌyʌjirob u t'ʌn Moisés: ―Wa quin wac a je' mech yoca': “Caj in jawsaj a si'pir”, a techexo' mʌ' a werex wa yʌn u muc' C'uj ten, wa mʌna' u muc' C'uj ten. Barej wa quin wac ti': “Riq'uen ca' xiquech.” Je' a werexe' yʌn u muc' C'uj ten. ");
INSERT INTO lacNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Caj ara'b ten Jesús ti' yʌjcamsʌyʌjirob u t'ʌn Moisés: ―Ar in wesej techex in muc' quir in jawsic u si'pir mac ich yoc'ocab, quire' taren in yamtej tu cotor mac. Jesús caj u t'ʌnaj a mac a mech yoco': ―Riq'uen ―quij―. Ch'aj a ch'ac ca' xiquech ich a watoch. ");
INSERT INTO lacNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A mech yoco', caj riq'uij caj bin ich yatoch. ");
INSERT INTO lacNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Caj yirob u riq'uir a mech yoque', caj jaq'uij yorob u winiquirob judío. Caj ya'arob u winiquirob judío: ―Jach caremech C'uj, quire' ta ts'aja muc' ti' Jesús quir u jawsic a mech yoco'. ");
INSERT INTO lacNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús caj u p'ʌtaj u cajar Capernaum jeroj caj yiraj turiri' xib Jesús, u c'aba' Mateo. Curucbar tu cu c'ʌmic u taq'uin gobernador romano. Caj pay Mateo ten Jesús: ―Cux ―quij Jesús―, quir a cʌnic in t'ʌn. Caj riq'uij Mateo, caj bin tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús ti' yʌn uch ich yatoch Mateo. Curucbar janʌn Jesús yejer u camsʌwinicob, yejer a cu c'ʌmicob u taq'uin gobernador romano. Ti' yʌn ich Jesúse', a yʌn u si'pirobe', cu janʌnob xan. P'eri'o' cu janʌnob yejer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","A farisejo', caj yirob cu janʌnob yejer Jesús, a yʌn u si'pirob, yejer a cu c'ʌmicob u taq'uin gobernador romano. Caj c'ata'b ten u winiquirob judío a fariseobo', u camsʌwinicob Jesús: ―Biquinin a wʌjcamsʌyʌjirex cu janʌn yejer a yʌn u si'pire', yejer a cu c'ʌmicob u taq'uin gobernador romano? ");
INSERT INTO lacNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús caj yubaj a ba' c'ata'bob ti' u camsʌwinicob. Jesús caj ya'araj ti' u winiquirob judío a fariseobo': ―A mʌ' yajo', mʌ' u c'atic ts'ac, quire' toc yʌn yor. A mac a yajo', ra' cu bin u cʌxtic yo'och ts'ac. ");
INSERT INTO lacNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Caj ara'b ti' u winiquirob judío a fariseojo' ten Jesús: ―Xen, cʌnex a ba' ts'iba'an ich u t'ʌn C'uj, a tu cu ya'aric: “Ca' yajquinte mac baxuc u c'at C'uj. Mʌ' a chen quinsiquex a wʌrʌc' wacʌx a sija ten”, quij C'uj. Rajen tareno'. Quire' taren in pʌyic a mac yʌn u si'pirob ca' u c'axej tu yorob soc u p'ʌticob a c'aso'. Mʌ' taren in pʌyic a mac a cu ya'aric mʌna' u si'pirob. A ray winico', ca' u quibob a ba' ara'b ti'ob ten C'uj, a tu cu ya'aric: “Jach manan tsoyir ca' a yajquintej a rac'ob. Mʌ' ja chen quinsiquex a wʌrʌc' wacʌx a sijetenex.” ");
INSERT INTO lacNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Caj c'uchob mʌ' ya'ab u camsʌwinicob Juan ich Jesús. Ra' cu yacsic ja' tu jo'r mac. Caj ara'b ti' Jesús ten u camsʌwinicob Juan: ―Biquinin mʌ' u p'ʌticob u janʌnob a camsʌwinicob quir u c'ujinticob C'uj? Biquinin a tenob in p'ʌticob in janʌnob yejer u winiquirob judío a fariseobo'? ");
INSERT INTO lacNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Caj u nuncaj Jesús: ―A mac cu bin u ch'ic u raq'ue', cu pʌyic u rac'ob quir u qui'qui' janʌnob. A tarobe', mʌ' tsoyi' wa cu tucricob. Barej ca' bin c'uchuc tu q'uinin cu bin, a tu ch'aj u raq'ue', jeroj ra' u q'uinino', cu bin u p'ʌticob u janʌnob. Baxuc a teno'. A mac a caj in pʌyaj mʌ' ba'wir u p'ʌticob u janʌnob. Wa ber ca' bin xiquen, a ra' u q'uinino', jach taj cu bin u p'ʌticob u janʌnob in camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Caj ya'araj Jesús: ―Mʌ' tsoy xan ca' a xaxactiquex a ba' caj a cʌnex ti' a nunquirex yejer a ba' tan a cʌniquex ti' ten. Mʌ' ja wirej, mʌna' mac cu jompʌc'tic u rabir u noc' yejer ric'ben. Cu mosar a ric'ben cu jatar a rabo' cu cochtar u jor. Jach carem u jorir u noc' u cochtar. ");
INSERT INTO lacNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Caj ya'araj Jesús: ―Mʌna' mac cu t'ajtic u c'ab u wich uva ich u rabir yot'er chivo. Quire' ca' bin pajnʌc, cu bujur. Hasta u rʌc wecar u c'ab uva cu rʌc jatʌr u yot'er chivo xan. A ric'ben u c'ab uva yʌn u t'ajic ich ric'ben yot'er chivo soc mʌ' ju bujur soc mʌ' ju rʌc wecar u c'ab uva. ");
INSERT INTO lacNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mʌ' toy ts'ocac u camsic u bujur u yot'er chivo Jesús. Caj tar pʌybir Jesús ten Jairo. Ra' u jach ts'urir u winiquirob judío. Caj ara'b ti' ten Jairo tu cu xonraj: ―Jach quimin in chan parar xquic. Cojen, chan ts'anc'ʌbtej ca' wʌc'ʌs riq'uir in chan parar xquic. ");
INSERT INTO lacNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús caj riq'uij caj bin yejer u camsʌwinicob yejer Jairo. ");
INSERT INTO lacNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ti' yʌn u jer xquic, caj tar tu pach Jesús tu cu bin ich Jairo. Mʌ' ju jawʌr u yajir. Yʌn u yajir doce yaxq'uin. Mʌ' ju jawʌr tu cu muc'yaj. Mʌ' ju tsoytar. Caj u juts'aj u bʌj xquic ich Jesús. Tu pach Jesús caj u tʌra u yoquir u noc' Jesús ten xquic. ");
INSERT INTO lacNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Caj u tucraj a xquico', ca' u tʌrej u yoquir u noc' Jesús. Caj ya'araj xquic tu yor: “Wa quin tʌric u yoquir u noc' Jesús, je' in jaware'.” ");
INSERT INTO lacNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A Jesúso', caj u sut u bʌj ich u pach quir yiric mac caj u tʌraj u yoquir u noc'. Caj yiraj xquic, caj u tʌraj u noc' Jesús. Caj ya'araj ti': ―Qui'quintej a wor in jach pararech. Quire' caj a wacsaj ta wor ti' ten ―quij ya'araj ti'―, rajen toc jawech. Ra'iri' u q'uinin toc jaw a xquico'. ");
INSERT INTO lacNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Caj c'uchij Jesús ich yatoch Jairo. Ra' u jach ts'urir u winiquirob judío. Caj yiraj Jesús cu churob mac, quire' tabar u mucur u baquer u parar Jairo, quire' baxuc nanij u betic u winiquirob judío. Jach pim cu yoc'arob tan yac'ta'r u parar Jairo. ");
INSERT INTO lacNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Caj ya'araj Jesús: ―Chan joq'uenex tancab ―quij Jesús―. Mʌ' quimeni'. Wenʌn u ca' in wiric a teno' ―quij Jesús. Caj p'asta'b Jesús ten a pimo' quire' yerob jach quimij u chan parar Jairo. ");
INSERT INTO lacNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Caj ts'oc u rʌc joc'sic mac tancab Jesús. Jesús caj oc ich yatoch, caj mach u c'ʌb ten Jesús caj riq'uij. Caj u ch'a'aj yor chan xquic, u parar Jairo. ");
INSERT INTO lacNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Caj man u rʌc tsicbʌticob ich tu cotor u ru'um. Caj ya'araj ti' u rac'ob bic tabar caj ric'sa'b u parar Jairo ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Caj joq'uij Jesús ich yatoch Jairo. Caj tar mʌna' u wich ich u pach Jesús. Ca'tur a ch'op u wichobe'. Caj u purob u t'ʌn ti' Jesús: ―Yajquin tenob, yamtej tenob quire' u pararech ic nunquir David. ");
INSERT INTO lacNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jeroj, caj oc Jesús ich yatoch mac quet caj ocob a ch'op u wichobe'. Caj u jutsob u bʌjob ich Jesús. Caj c'ata'b ti'ob ten Jesús: ―Ca tucriquex c'ucha'an in wor in jawsiquechex? Caj ya'arob a ch'op u wichobe': ―In werob Jaj Ts'urir c'ucha'an a wor a jawsiquenob. ");
INSERT INTO lacNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesús caj u tʌr u wich a ch'op u wichobe'. Caj ya'araj ti'ob: ―An ten bic tabar caj a wacsajex ta worex ti' ten, baxuc u jawʌr a wichex xan. ");
INSERT INTO lacNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Caj qui' jawʌc u wichob ten Jesús. Caj u toc araj ti'ob: ―Mʌ' a yʌn bin a wa'arex wa jaw a wichex ―quij ya'araj ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tan tu ts'ocar u jawar u wichob. Caj toc rʌc bin ya'arej ich tu cotor an bic tabar caj jawsa'b u wich ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Caj joc'ob ich Jesús, a jaw u wichobe', caj ca' tar purbir u jer. A mʌ' u joc'ar u t'ʌn quire' aca'an c'ac'as quisin ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","A Jesúso', caj u joc'saj u c'ac'as quisinin, a mʌ' u joc'ar u t'ʌn. Caj joc' u c'ac'as quisin, caj joc' u t'ʌn. Caj yirob u rac'ob caj jaq'uij yorob. Caj ya'arob: ―Mʌna' ij quiric mac cu joc'sic quisin. Cax tu cotor u ru'umin Israel. ");
INSERT INTO lacNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Caj ts'oc yiricob u winiquirob judío a fariseojo' u joc'sic quisin Jesús. Caj u tus arob ti' u yet winiquirob judío: ―A werex tub u tar u muc' quir u joc'sic a quisino'? Ich u jach ts'urir quisin. ");
INSERT INTO lacNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús caj rʌc man u tsec'tic ti'ob u jach tsoyir u t'ʌn tu cotor u cajar. Cax tu chan cajar cax tu carem u cajarob caj u tsec'taj ti'ob u jach tsoyir u t'ʌn. Ti' cu man u camsic Jesús ich u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u tsec'taj Jesús tu cu bin u reyinticob C'uj. Jesús caj man u jawsaj mac, cax a ba' yajir cu jawsic Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Caj yiraj Jesús jach pim mac, caj u yajquinta Jesús, quire' caj u yiraj mʌna' mac caj u camsob tu cu bin u reyinticob C'uj. Yiraj Jesús u winiquirob judío irej wa tʌmʌn yuc, quire' mʌna' yʌjcʌnʌnyʌjirob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Taj quin wa'aric techex. Yʌn mac pim ―quij―, u c'at yubicob u t'ʌn C'uj. Barej a cu beyajo', mʌ' pim yʌjtseq'uir u t'ʌn C'uj ti'ob. Aro' irej wa ti' yʌn jach ya'ab nʌr quir u jaq'uic, chen mʌ' ti' yʌn mac quir u jaq'uic. ");
INSERT INTO lacNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rajen ca' t'ʌnex C'uj soc u tuchi'tic mac quir u bin u tsec'tic u t'ʌn C'uj soc c'ucha'an yorob u yubicob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Caj ts'oc aro' Jesús caj u much'quintaj u camsʌwinicob doce. Caj u ts'aja u muc' ti'ob tu cu bin u camsʌwinicob quir u joc'sicob quisin. Cax ba' yajir, cu jawsicob. ");
INSERT INTO lacNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yʌn u c'aba' caj u tetaj doce xib. A jeroj Simón, caj ca' pach u jer u c'aba' ten Jesús. Caj pach u c'aba' Pedro, Jesús. Pachir caj teta'b Andrés ten Jesús. Ra' u bʌjob Pedro, Andrés. U jer Jacobo u bʌjob Juan. Caj teta'b Juan xan. P'eri' u tetob Zebedeo Jacobo yejer Juan. ");
INSERT INTO lacNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Caj teta'b Felipe ten Jesús. U jer caj teta'b Bartolomé. U jer caj teta'b Tomás. U jer caj teta'b Mateo yʌjc'ʌmin u taq'uin gobernador romano. Caj teta'b Jacobo ra' u tet Alfeo. U jer teta'b Lebeo ra' pʌcha'an u jer u c'aba' Tadeo. ");
INSERT INTO lacNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Caj teta'b u jer Simón ra' cu sayʌr tu pach cananista. Caj teta'b Judas Iscariote, ra' caj u c'ubaj Jesús, Judas. ");
INSERT INTO lacNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús caj u tuchi'taj u camsʌwinicob doce. Caj ya'araj ti' u camsʌwinicob: ―Mʌ' a yʌn bin a tsec'tex u t'ʌn C'uj ich u cajar u winiquirob Samaria. Mʌ' a yʌn binex a tsec'tex u t'ʌn C'uj ich a mʌ' u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jari' yʌn xenex a tsec'tex tu yʌn u jach winiquirob judío. A caj u p'ʌtob u t'ʌn C'uj. Mʌ' ja wirej, irob yʌrʌc' tʌmʌn yuc a satʌrobe'. ");
INSERT INTO lacNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Caj ya'araj Jesús ti' u camsʌwinicob: ―Xenex, tsec'tex in t'ʌn. Arex ti'ob: “Tabar u c'uchur a mac a cu bin u reyintejob C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jawsex a mac u cʌnmʌnob iq'uer u ca'ob ―quij Jesús―. A ba' yajirir, jawsex ―quij Jesús―. Rʌc joc'sex u quisinin ―quij Jesús. Caj ya'araj Jesús ti' u camsʌwinicob: ―Ric'sex u quimirir. Mʌ' in c'atej techex u bo'orir in muc' caj in ts'aja techex. Baxuc xan, a yamtiquex mac, mʌ' a c'atiquex u bo'orir. ");
INSERT INTO lacNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Mʌ' a ch'a'ex a taq'uinex. ");
INSERT INTO lacNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mʌ' a ch'a'iquex u mucuquir a noq'uex, chen a buquinmʌnex ―quij Jesús―. Chen ra' a ch'a'ex. Mʌ' a yʌn ch'iquex u jer xʌnʌb, cax turiri'. Baxuc a xonte', mʌ' a ch'iquex. Quire' a cu beyajo', cu ts'abʌr yo'och bayiri' noc'. ");
INSERT INTO lacNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ca' bin c'uchuquex chan cajar, cax carem u cajar. Cʌxtex a mac a tsoy yoro' soc ra' cu yacsiquex. Tsoy a wocarex tu yatoch hasta a ca' binex. ");
INSERT INTO lacNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jesús caj ya'araj ti' u camsʌwinicob: ―Ca' bin ocaquex ich mac yʌnin yatoch. T'ʌnex C'uj soc u qui' cʌnanta' ten C'uj a mac a cu yacsiquechex. ");
INSERT INTO lacNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wa mʌ' u yacsechex tsoy a wʌc'ʌs ch'ic a t'ʌn ―quij Jesús―, quire' mʌ' u qui' acsechexi'. Wa caj u qui' acsechex cu p'atʌr a t'ʌnex ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A mʌ' ju yacsexo', a mʌ' u c'at u c'ʌmicob a t'ʌnex. Mʌ' ju c'at yubejobi'. Joq'uenex tu yatoch, cax tu cajar. Pustex u ru'umin a woquex soc yerob u beri' yʌn u si'pirob ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Taj quin wa'aric techex ―quij Jesús―. Ca' bin c'uchuc tu q'uinin u tar C'uj, yaj cu bin yubic yerar, a mʌ' u cha'j a wocarex a tsec'tex u t'ʌn C'uj. Jach manan cu bin muc'yajob. A tu cajar Sodoma quet yejer u cajar Gomorra mʌ' neyaj cu bin yubicob muc'yajob. ");
INSERT INTO lacNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Caj ya'araj Jesús ti' u camsʌwinicob: ―U'yex ba' quin wa'aric techex ―quij Jesús―. Quin tuchi'quechex tu yʌn a nets'ique' ―quij Jesús―. Aro' irej a mac a caj u tuchi'taj u yʌrʌc' tʌmʌn yuc ich a bobochi'o'. Rajen qui' cʌnantex a bʌjex ―quij Jesús―, soc mʌ' nemʌ' biquechexi'. ");
INSERT INTO lacNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Caj ya'araj Jesús ti' u camsʌwinicob: ―Qui' cʌnantex a bʌjex, quire' je' u chuquicob a pachechex. Je' u chuquic u mʌchiquechex a jach ts'urir tu cajarob. Je' u bin u puriquechex ʌcʌtan u jach ts'urir a pim mac. Je' u jʌts'iquechex a pachex tu chan najir tu cu naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Caj ya'araj Jesús ti' u camsʌwinicob: ―Ti' cu bin u puriquechex ʌcʌtan ich gobernadores baxuc ich reyes cu bin u puriquechexo', quire' caj a wacsajex ta worex in t'ʌn. A baywo' ―quij Jesús―, c'ucha'an a worex a tsec'tiquex in t'ʌn ti' reyes yejer gobernadores. Cax mʌ' u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Wa ber u puriquechex ʌcʌtan ich u jach ts'urirob u cajar. Mʌ' ju jac'ʌr a worex a ba' ca bin a tsicbarex ti'ob. An bic ca bin a tsicbarex ti'ob mʌ' u jac'ʌr a worex ti'. A C'ujo' cu bin u yamtiquechex bic tabar ca bin a nunquiquex ti'ob. Toc ra' u q'uinino', cu bin u yamtiquechex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Cax cu yubic techex a t'ʌnex. Mʌ' techex ca t'ʌnexi' ―quij Jesús―. Chen u t'ʌn u Taj'or u Pixam C'uj cu t'ʌn, quire' cu tar ich a Tetex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Cax a bʌj cu bin u c'ubiquechex quire' yirob caj a wacsex ta worex. Cax u wʌc'ʌs parar cu bin u c'ubic quinsbir ten u tet. Cax u wʌc'ʌs tet cu bin c'ubic ca' quinsac ten u parar. ");
INSERT INTO lacNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tu cotor mac cu bin u p'actic techex quire' caj a wacsajex ta worex ti' in t'ʌn. Wa mac mʌ' ju p'ʌtic u cʌnic in t'ʌn hasta cu quimin, ra' u quinin bin in taquej. ");
INSERT INTO lacNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wa mac cu chuquicob a pachex ich a cajarex. Xenex tu yʌn u jer cajar. Taj quin wa'aric techexi'. Quire' mʌ' toy rʌc manʌquechex a puts'urex quir a tsec'tex ti' in t'ʌn ich tu cotor u cajar tu ru'umin u winiquirob Israel, ca' bin wʌc'ʌs uren ten ―quij Jesús―. Quire' taren in yamtic mac tu cotor. ");
INSERT INTO lacNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Cʌnex a jera'. U camsʌwinic mac mʌ' u c'uchur u yor ti' u yʌjcamsʌyʌjir. Baxuc u c'urew mʌ' u c'uchur u yor ti' u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Rajen a je' u camsʌwinic mac yʌn u qui'quintic yor a caj u cʌnaj u camsʌyʌjir. Quire' a ba' u ber ti' u yʌjcamsʌyʌjir bayiri' cu bin tar ti' u camsʌwinic xan. Bayiri' xan, u c'urew mac ca' u qui'quintac yor a caj cʌnaj u jach ts'urir. Quire' a ba' u ber ti' u jach ts'urir bayiri' cu bin tar ti' u c'urew xan. Caj ya'araj Jesús ti' u camsʌwinicob: ―An bic caj u t'ʌnenob, baxuc cu bin u t'ʌniquechexob: “U pararechex Beelzebú.” Chen jach manan cu bin ya'aricob ti' techex. ");
INSERT INTO lacNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Quire' a werex ba' cu bin tar techex. Mʌ' a sʌjtiquex mac. Quire' a ba' u mucuber ti' mac je' u rʌc u'yicobe', cax a ba' u mucuber ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Caj ya'araj ti' u camsʌwinicob, Jesús: ―A ba' caj in camsechex ta junanex. Ca' a manex a rʌc ariquex ich tu cotor mac. A caj in camsex ta junanex ca' a puriquex a t'ʌnex tu cotor soc yerob ba' quiri' caj in camsajex. ");
INSERT INTO lacNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Mʌ' ja ch'a'iquex sajaquir ti' mac, cax cu quinsiquex. Mʌ' ju quinsejob a pixamex. Ca' a sʌjtex C'uj, quire' c'ucha'an yor u puriquechex ich c'ac'. Tu cu yerar a winquirex quet yejer a pixamex. ");
INSERT INTO lacNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Wa ber ca mʌnex ch'ich' ca'tur quir a chi'iquex. Ca bo'otiquex turi' centavo. “Jot” ―quechex ti'―, quire' mʌ' co'oj ch'ich'. Chen a ch'ich'o', mʌ' u quimin wa mʌ' tsoy tu t'ʌn C'uj ic Tetex ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Chen a C'ujo', jach manan u cʌnantic techex, biquinin a jo'rex cu cʌnantic xan. ");
INSERT INTO lacNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Rajen ba'wir ca tucriquex a bʌj quire' a techexo' jach ya'ab a bo'orirex, a chan ch'ich'o', mʌ' co'oji'. ");
INSERT INTO lacNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Bayiri' tu cotor mac a taj cu yacsic tu yor ti' ten, aro' chʌca'an yiricob u rac'ob. Ra' quin bin in qui' acsic ʌcʌtan in Tet C'uj ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Caj ya'araj ti' u camsʌwinicob, Jesús: ―A mac a mʌ' ju ya'araj ti' u rac'ob wa ju yacsaj tu yoro'. Ca' bin xiquiquen ʌcʌtan ich in Tet C'uj ca'anan ca' bin xuruc t'ʌn. Je' in wac ti' in Tete': “Mʌ' in wer maqui'.” ");
INSERT INTO lacNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Mʌ' a chen quibiquex wa rʌc taren in quetquintic yor tu cotor mac. Quire' a mac a cu yacsic tu yor ti' ten, u rac'ob cu bin u ts'ictarob yejer. ");
INSERT INTO lacNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mʌ' ja wirej, a pararo', cu bin u ts'ictarob yejer u tet. A xquico', cu bin u ts'ictar yejer u nʌ' ―quij Jesús―. A xquico', cu bin u ts'ictar yejer yixquit. ");
INSERT INTO lacNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Caj ya'araj ti' u camsʌwinicob: ―Cax u wʌc'ʌs u bʌjob cu bin u p'acta'bir yejer. ");
INSERT INTO lacNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Wa mac jach manan u yajquintic u tet, baxuc u nʌ', chen mʌ' u neyajquinten, quire' u tet jach yaj, baxuc u nʌ'. Ba'wir quin wa'aric: “Ten yʌnin aro'.” ");
INSERT INTO lacNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Caj ya'araj ti' u camsʌwinicob, Jesús: ―A mac cu bin yacsic tu yor ti' ten, bin u ca' muc'yaj an ten bic caj u bajij mac ich cruz. Wa mʌ' u c'at, ba'wir cu yacsic tu yor ten? ");
INSERT INTO lacNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mʌ' ja wirej, a mac u c'at u taquic u bʌj soc mʌ' u muc'yaj, chen je' u sa'tʌr u pixam, quire' caj u p'ʌtaj u yacsic tu yor in t'ʌn. Chen a mac u c'at u quinsa' ti' ten, quire' caj u yacsaj tu yor ti' ten. Mʌ' u sa'tʌr u pixam, cax quinsa'b ten u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Wa mac cu yacsiquechex, baxuc cu yacsiquen, xan. A mac cu yacsiquen cu yacsic C'uj xan quire' caj u tuchi'ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","A mac a cu yacsic yʌjtseq'uir u t'ʌn C'uj quire' tuchi'ta'b ten C'uj quir u tsec'tic u t'ʌn. Quet ca' bin bo'ota'c ten C'uj. A mac a cu yacsic xib, a jach tsoy yoro', quire' yer jach tsoy yor xib. Ra'iri' quet ca' bin bo'otac ten C'uj ti' techex, quire' caj a wacsajex xib ta watochex. ");
INSERT INTO lacNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Caj ya'araj ti' u camsʌwinicob, Jesús: ―Yʌn mac a caj u yacsaj tu yor ten, cu bin arbir ten a mʌ' yer C'uje': “Jot aro.” Chen a mac a cu ts'ic yuc'ur sisis ja' ti'ob, C'uj bin u ca' bo'otej ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Caj ts'oc u camsic aro' ti' u camsʌwinicob Jesús. Caj bin Jesús quir u man u tsec'tic u t'ʌn C'uj ich tu cotor u rac'ob ich tu cotor u cajarob, ca' bin u camsic u rac'ob xan. ");
INSERT INTO lacNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti' yʌn Juan a cu yacsic ja' tu jo'r mac ti' yʌn tu cu naj ma'cʌr winic. Caj yubaj u juminta' Juan ten u camsʌwinicob. Quire' ya'arob u camsʌwinicob: “Jach carem u beyajob Jesús.” Caj u tuchi'taj ca'tur u camsʌwinicob Juan ich Jesús quir u c'atic ba' ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Caj c'uch u camsʌwinicob Juan ich Jesús. Caj ara'b ten u camsʌwinicob Juan: ―Arej tenob wa Cristojech, a quin pajicob u tar ti' C'uj quir u taquiquenob ―quij yac ti', u camsʌwinicob Juan―. Arej tenob wa yʌn in pajicob u jer? ");
INSERT INTO lacNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Caj ara'b ti' u camsʌwinicob Juan ten Jesús: ―Joq'uen, arex ti' Juan a ba' caj a wirex in camsic mac. ");
INSERT INTO lacNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Arex ti' Juan, a caj a wirex in jawsic a ch'op u wiche'. A caj a wirex in jawsic a mech yoque'. Arex ti' Juan, a caj a wirex in jawsic iq'uer u ca'ob. Arex ti' Juan, a caj a wirex in jawsic a mʌ' u yubejo' t'ʌn. Bayiri' a caj a wirex in ric'sic u quimirir mac ―quij Jesús―. Arex ti' Juan, a caj a wirex in tsec'tic u jach tsoyir u t'ʌn C'uj a mac a cu ya'aricob: “Otsirchʌjen a teno'.” ");
INSERT INTO lacNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Caj ya'araj Jesús ti' u camsʌwinicob Juan: ―Arex ti' Juan. A teno', quin wa'aric a mac a rajra' cu yacsic tu yor ti' ten yejer tu cotor u pixam tsoy yʌn ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Caj bin u camsʌwinicob Juan. Wʌc'ʌs sutnʌjob u camsʌwinicob Juan tu pachob. Caj u tsicbʌtaj Jesús Juan ti' u winiquirob judío, a ti' yʌnob ich Jesús. Caj ara'b ten Jesús ti' u winiquirob judío: ―Ba' bin a wirex ich Juan tu cu tsec'tic u t'ʌn C'uj uch. Baxuc wa ca'tur u tucur? Samane' wa ju jer u tucur. A mac irej jʌrʌr cu yumta' ten ic'? Baxuc wa caj a wirex Juan? Mʌ' caj a wirex aro'. ");
INSERT INTO lacNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Caj ara'b ti' u winiquirob judío ten Jesús: ―Mʌ' wa binechex a wirex mac a cu c'axic u tucur. Mʌ' binex a wirex a mac a cu buquintic jach tsoy u noc'. A mac cu buquintic jach tsoy u noc' ti' yʌn ich yatoch rey. A Juano' mʌ' u buquintic jach tsoy u noq'ui'. ");
INSERT INTO lacNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mʌ' chen binechex a wirex mac cu buquintic jach tsoy noc'. Mʌna' mac a cu c'axic u tucur. Jach binechex a wirex a mac a cu jach tsec'tic u jach tsoyir u t'ʌn C'uj. Raji' mʌ' chen a mac a cu tsec'tic u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Caj ya'araj Jesús: ―Mʌ' ja wirej, ts'ibta'b ti' Juan ten yʌjtseq'uir u t'ʌn C'uj Isaías uch cax mʌ' toy tac Juan. Caj ya'araj Isaías uch: Je' u tar yʌjtseq'uir u t'ʌn C'uj, quij Isaías. Pʌyber cu bin tar. Mʌ' ja wirej, tabar u tar Cristo soc mac yer je' u tare' Cristo. Baxuc caj ya'araj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Caj ya'araj Jesús ti' u winiquirob judío: ―Jach taj quin wac techex. Mʌna' mac cu c'uchur orben ti' Juan a cu yacsic ja' tu jo'r mac. Cax a mac a ti' yʌn ich yoc'ocab. Cax a mac cʌja'an baje'rer. Mʌ' ju c'uchur orben ti' Juan, a cu yacsic ja' tu jo'r mac. A mac cu bin c'uchur orben ti' Juan a cu yacsic ja' tu jo'r cax chichin caj u yacsaj tu yor. Hasta cu c'uchur tu q'uinin u reyinticob C'uj je' u c'uchur orben ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jesús caj ya'araj ti' u winiquirob judío: ―Caj u yʌnxchun u tsec'tic Juan a cu yacsic ja' tu jo'r mac. Caj rʌc tarob u winiquirob judío quire' u jach c'at yocarob tu cu bin u reyintejob C'uj. Caj u jach p'isob u bʌj ti' u t'ʌn C'uj. Quire' u c'at yubicob u t'ʌn C'uj cax baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mʌ' ja wirej, raji'ob caj u tsec'tajob yʌjtseq'uirob u t'ʌn C'uj uch, cax Moisés caj u tsec'taj u t'ʌn C'uj tu cu bin u reyintejob C'uj hasta tari Juan a cu yacsic ja' tu jo'r mac. ");
INSERT INTO lacNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Caj ya'araj Jesús ti' u winiquirob judío: ―Wa ja c'at a c'ʌmiquex u t'ʌnob Juan. Quire' a Juano', irej Elías a ucho', a cu tsec'tic u t'ʌn C'uj uch. Eliás raji' ca pajiquex ca' tac. A tsec'ta'b uch: “Je' u tare'.” ");
INSERT INTO lacNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Rajen ca' a wu'yex a ba' caj in wa'araj techex. ");
INSERT INTO lacNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Caj ya'araj Jesús ti' u winiquirob judío: ―A mac a cuxa'an a je' q'uina', quin wiric an ten bic a chichano', a cu baxarob tu cu naj mʌnicob yo'och mac. Cu puricob u t'ʌn ti' u yet baxarob. ");
INSERT INTO lacNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Cu ya'aricob ti' yet baxʌrob: “Cax chen churnʌquenob, mʌ' a woc'atex quire' qui' a worex. Cax chen c'aynʌquenob, mʌ' a woc'arex, cax oc'nʌjenob a quin c'ʌyicob techex.” ");
INSERT INTO lacNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Quire' caj tar Juan a cu yacsic ja' tu jo'r mac. Mʌ' u nejanan Juan a nequi' yo'ocho'. Mʌ' u yuc'ur u c'ab u wich uva. Caj ya'araj Jesús ti' u winiquirob judío: ―Caj a wa'araj techex: “Aca'an quisin ti' Juan.” Rajen raji'ob a mac a cuxa'an a je' q'uina' irob a ray chichano'. ");
INSERT INTO lacNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jesús caj ya'araj ti' u winiquirob judío: ―Caj taren quir in yamtic mac tu cotor. Quin qui' janʌn ―quij Jesús―. Quin wu'q'uic u c'ab u wich uva. Ca tus a'ariquex jach manan qui' quin janʌn ―quij Jesús ti' u winiquirob judío―. Bayiri' ca tus a'ariquex quin ne'uc'ur. A techexo' ―quij Jesús―, a ca wa'ariquex in wet man yejer a yʌn u si'pirobe'. Bayiri' ca tus a'ariquex in wet man yejer a mac a cu c'ʌmicob u taq'uin gobernador. Quire' jach manan cu c'aticob taq'uin gobernador. Caj ya'araj Jesús ti' u winiquirob judío: ―A mac a cu p'actic u beyaj quin beticob mʌ' t'aji'. Quire' a mac a t'aji' yerob a ba' quin beticob ra' u beyaj C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús caj yubaj ich u cajar u winiquirob judío mʌ' ju c'axic yorob quir u p'ʌticob u c'asir, cax caj u yirob jach carem u beyaj Jesús. Caj chich q'ueya'b u winiquirob judío ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Caj ya'araj Jesús ti' u winiquirob judío: ―Otsirechex ich a cajarex u c'aba' Corazín, quire' mʌ' ja c'axex a worexi' quir a p'ʌtiquex a c'asirex. Bayiri' a mac a ti' yʌnob tu cajar Betsaida. Wa caj u chen irob carem u beyaj uche' caj u c'axob yorob ich u cajar Sidón uch. Bayiri' ich u cajar Tiro wa caj u yirob carem u beyaj uche' an ten bic carem in beyaji'. A mʌ' seb caj u c'axob yorob quire' yirob carem in beyaj. Caj manob yac'ticob u bʌj, quire' manob tu c'asir uch. Caj u buquintob tsots noc' yejer u t'ot'ic tan tu jo'r je' u manob yac'tob u bʌj an ten bic nani u betic u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Quin wa'aric techex ―quij Jesús―. Jach yaj ca bin a muc'yajex ca' bin xuruc t'ʌn. Chen a mac tu cʌja'anob tu cajar Tiro mʌ' neyaj cu bin yubic u muc'yajob. Bayiri' xan, ich u cajar Sidón. Mʌ' neyaj cu bin yubic u muc'yajob. ");
INSERT INTO lacNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Caj ya'araj Jesús ti' u rac'ob a cʌja'anob ich u cajar Capernaum: ―A techexo', te' cʌja'anechex ich u cajar Capernaum. Ca tucriquex je' u sʌjtiquechex a rac'ob quire' ca wiriquex ti' cʌja'aneni' ―quij Jesús―. Ca' bin xuruc t'ʌn ich yoc'ocab ―quij Jesús―. Ti' ca bin erarexi', quire' mʌ' ja c'axex a wori'. Mʌ' ja wirej, wa caj u yirob in carem beyajob tu cajar Sodoma uche', a caj a wirajex uch ta cajarex uch, ti' toy yʌn u cajari' Sodoma baje'rer. Mʌ' erabir ten C'uj uchi'. ");
INSERT INTO lacNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Quin wa'aric techex ―quij Jesús―. Ca' bin xuruc t'ʌn, jach yaj ca bin a werarex ich u cajar Capernaum. Mʌ' ja wirej, mʌ' ja c'axex a worexi' ―quij Jesús―. Chen a ti' cʌja'an uch ich u cajar Sodoma mʌ' neyaj cu bin yubic yerarobi'. ");
INSERT INTO lacNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ra' u q'uinina', caj urob u camsʌwinicob ich u winiquirob judío, caj u t'ʌnaj C'uj, Jesús. Caj ya'araj Jesús ti' C'uj: ―Jach caremech C'uj in Jach Ts'urech u C'ujirech yoc'ocab xan, quire' u C'ujirech ca'anan xan. A techo' C'uj ―quij Jesús―, caj a wesaj a t'ʌn ti' a mac a mʌ' u ne'er a t'ʌn. A techo' C'uj ―quij Jesús―, mʌ' ja wesaj ti' a mac a cu tus a'aric u ne'er a t'ʌn. A cu tus a'aric cu jach najtic a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Caj u t'ʌnaj C'uj: ―Jach jaj C'uj, quire' ra' tsoy ta t'ʌn tech, quire' baxuc a c'at. ");
INSERT INTO lacNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Caj ya'araj Jesús ti' a mac a ti' yʌnobo': ―C'uj caj u rʌc ts'aj ten tu cotor ba' ich yoc'ocab quir u ts'urinticob ten. Baxuc ich ca'anan C'uj caj u rʌc ts'aj ten quir u ts'urinticob ten. Mʌna' mac cu najtiquen a tera' ―quij Jesús―. Chen in Tet cu jach najtiquen. Baxuc C'uj xan, mʌna' mac c'ucha'an yor u najtic C'uj, chen ten quin najtic C'uj. Mʌna' mac c'ucha'an yor u najtar in Tet, jari' a mac a jin bʌjiri' caj in camsaj soc yer biquira' in Tet. ");
INSERT INTO lacNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Cojen tu yʌnen ―quij Jesús―, ca' in jawsej wa ba' ca tucriquex, wa choc a worex ti' a si'pirex, soc u qui'tar a worex. ");
INSERT INTO lacNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Caj ya'araj Jesús: ―Quibex a ba' quin wa'aric techex. Mʌ' yaj a cʌniquex in t'ʌn. Quire' ―quij Jesús―, wa ca c'ʌmiquex in t'ʌn, jach qui' a worex. Ca' a cʌnenex ―quij Jesús―. Mʌ' ts'iquen a teno', mʌ' biq'uin quin p'ujur a teno' ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wa baxuc techexo', mʌ' yaj ca bin quibiquex in t'ʌn, quire' jach tsoy ca bin a wu'yiquex in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Caj u ch'ʌctob u cor mac Jesús. A ju camsʌwinicob caj tarob tu pach Jesús. Caj u ji'chtajob u wich trigo u jantejob quire' wichʌjob. Ra' u q'uinin cu jesicob u bʌj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","U winiquirob judío a farisejobo', irob u ji'chticob u wich trigo. Caj ara'b ti' Jesús ten u winiquirob judío a farisejobo': ―Iric, biquinin cu ji'chticob u wich trigo a camsʌwinicob quire' u q'uinin ic jesicob ic bʌj. Baxuc ts'iba'an ich u t'ʌn Moisés uch. Mʌ' tsoy u beyaj tu q'uinin tu cu jesic u bʌj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús caj ya'araj ti' u winiquirob judío a farisejobo': ―Mʌ' wa ja xacajex tu ts'iba'an u t'ʌn C'uj ti' David uch? Caj wichʌjob David yejer u rac'ob uch. ");
INSERT INTO lacNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Caj oquij David yejer u rac'ob ich yatoch tu t'ina'an yot'er chivo tu cu naj c'ujinticob C'uj u winiquirob judío. Caj ts'a'b yo'och pan ten sacerdote ca' u jantajob David yejer u rac'ob quire' wichʌjob, cax mʌ' tsoy u janticob caj ts'ab ti' David ten sacerdote. Mʌ' ja wirej, ra' quir u ts'abʌr ti' C'uj. Cu chen janticob u winiquirob judío a sacerdotejo'. ");
INSERT INTO lacNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jesús caj ya'araj ti' u winiquirob judío a farisejobo': ―Baxuc xan, mʌ' a xacmʌnex ich u t'ʌn Moisés a cu ya'aric u beyajob sacerdote cax u q'uinin tu cu yʌn jesicob u bʌj. Raji'ob cu beyajob ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío aro' mʌ' c'asi'. Mʌ' ju tar u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Quin wa'aric techex ―quij Jesús―, ti' u winiquirob judío a farisejobo'. Quire' ts'a'b u muc' ten C'uj ti' sacerdote soc u beyajob ich carem naj tu cu naj c'ujinticob C'uj. Cax cu beyajob a sacerdotejo' tu q'uinin tu cu jesicob u bʌj, chen tsoyo' ―quij Jesús―. Chen a teno' jach manan u ts'abʌr in muc' ten C'uj. A ray u muc'o' ts'a'b ti' sacerdote mʌ' u c'uchur u muc' teni'. ");
INSERT INTO lacNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A techexo', ―quij Jesús― mʌ' a wu'yex a ba' cu ya'aric a je' ts'iba'an ich u t'ʌn C'uj? U'yex ―quij Jesús―: “In c'at ―quij C'uj―, ca' a yajquintej a rac'ob ca' a yamtej ti'ob. Mʌ' a chen quinsiquex a wʌrʌc' quir a sijic ten quir in jawsic a si'pirex. Jach manan tsoyir ca' a yajquintej a rac'ob.” Baxuc cu ya'aric tu ts'iba'an u t'ʌn C'uj. Wa ja najtajex aro', mʌ' a pʌq'uiquex u pachob in wʌjcamsayʌjirob, quire' mʌ' c'as caj u betob. ");
INSERT INTO lacNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Caj ya'araj Jesús ti' u winiquirob judío a farisejobo': ―A teno' baxuquenechex, cu ts'urintiquen tu cotor ba', cax a ba' cu yiric mac tu q'uinin tu cu jesicob u bʌj u winiquirob judío ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ra' u q'uinino' Jesús caj toc p'at u winiquirob judío a farisejobo', caj bin Jesús, caj oc tu cu naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ti' yʌn xibi' a mʌ' u jitir u c'ʌb. Caj c'ata'b ti' Jesús ten u winiquirob judío: ―Are to'onex. Tsoy wa jic jawsic mac tu q'uinin ic jesicob ic bʌj? U c'at u pac'arob u pach Jesús, rajen caj u tus c'atic u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús caj u nuncaj: ―A techex ―quij Jesús―, wa cu rubur a wʌrʌc' tʌmʌn yuc. Cu rubur tu ch'ica'an. Mʌ' wa ja joc'sex enan tu q'uinin tu ca jesiquex a bʌj? A mʌ' ca joc'siquex a wʌrʌc' tʌmʌn yuc xan enaj tu q'uinin a jesiquex a bʌj. ");
INSERT INTO lacNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mʌ' ja wirej, a xibo', jach co'oj enan a wʌrʌc' tʌmʌn yuc a ca joc'sique', mʌ' neco'oji'. Rajen tsoy a man a yamtiquex mac tu q'uinin tu ca jesiquex a bʌjex. Mʌ' ja wirej, mʌ' c'asi' ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesús caj u t'ʌnaj xib a mʌ' u jitir u c'ʌb: ―Tich' a c'ʌb ca'anan ―quij Jesús. Caj u tich'aj u c'ʌb, caj jawij u c'ʌb an ten bic jumbuj u c'ʌb caj jawij. ");
INSERT INTO lacNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Caj joc'ob u winiquirob judío a farisejobo' caj irob jawij u c'ʌb a mʌ' ju jitir u c'ʌb. Caj u rʌc much'quintob u bʌjob a farisejobo' quir u tsicbʌticob ti' u rac'ob soc yubicob bic tabar ca' bin u quinsejob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús caj yubaj ba' cu tucricob. Caj u p'ʌtaj u cajar a mʌ' u jitir u c'ʌb, caj bin Jesús. Caj uya'b u bin Jesús, caj binob a pim mac ich u pach Jesús. Caj rʌc jawsaj u yajirob. ");
INSERT INTO lacNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Caj ya'araj Jesús ti' a tu jawsaj: ―Mʌ' a yʌn bin a wa'arex wa tin jawsajechex soc mʌ' yerob mac tu tuchi'tajen C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A baywo' caj u nup'saj Jesús a ba' ts'ibta'b ti' ten Isaías uch. Mʌ' ja wirej, caj ya'araj Isaías caj ara'b ti' Jesús: ");
INSERT INTO lacNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","A jera' in c'urew, ra' cu beyaj ten, a mac caj in tetaj, quij Isaías, ti' C'uj. A mac caj in yajquintaj qui' in wor yejer a tin tetaje', quij Isaías, quire' yʌn u Taj'or u Pixam C'uj ti' in c'urew. Je' u bin ʌcʌtan tu cotor mac quir u tsec'tic in t'ʌn soc u manob tu tsoyir. Cax ich a mʌ' u winiquirob judío cu bin ʌcʌtan quir u tsec'tic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mʌ' ju ts'ictar in c'urew, mʌ' u nunquic u t'ʌn mac, in c'urew, quij Isaías. Mʌna' mac cu bin yubic u ts'ictar in c'urew. Mʌ' u bin u tupsic yor mac, a caj u yac't u bʌj quire' u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Chen cu bin chichquintic yorob. Rajra' cu bin u betic soc ca' bin c'uchuc tu q'uinin cu bin manob tu tsoyir. A raji'ob, a mac a ti' yʌn yoc'ocab a cu bin u yacsicob tu yorob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Rajen tu cotor mac ich u cajarob caj u pajob Cristo quir u tocar ten C'uj. Baxuc caj ya'araj C'uj ti' Isaías uch caj u ts'ibtaj. ");
INSERT INTO lacNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Caj tar purbir xib ten u rac'ob a ch'op u wiche'. Mʌ' ju joc'ar u t'ʌn quire' yʌn c'ac'as quisin ti' xib. Caj u jawsaj Jesúso', caj joc' u t'ʌn, caj yiraj u berir xan. ");
INSERT INTO lacNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Caj jaq'uij yorob u rac'ob caj yirob u jawar a mʌ' u joc'ar u t'ʌn, a ch'op u wich uche'. Caj ya'araj a pimo': ―Mʌ' wa ju parar ic nunquirex David a caj ic pajex ca' tac? ");
INSERT INTO lacNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","A ju winiquirob judío a fariseobo' caj yubob a ba' ara'b ten u rac'ob. Caj ya'arob: ―A je' xiba' cu joc'sic quisin. Mʌ' ra' ts'ic u muq'ui' u ts'urir quisin. U muc' u ts'urir quisin Beelzebú caj u joc'sej quisin. ");
INSERT INTO lacNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Caj yubaj Jesús a ba' caj u tucraj u winiquirob judío a fariseobo'. Caj ya'araj Jesús ti' u winiquirob judío a fariseobo': ―Wa ju wʌc'ʌs bʌjiri' cu bin ts'ictar ich u ru'umin tu cu reyinticob rey. Je' u rʌc ch'esicob u bʌj. Cax ich u chan cajar tu cu bin u ts'ictarob. Cax wa ju wʌc'ʌs bʌjob cu ts'ictarob je' u rʌc quinsicob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Bayiri' a quisino', u jach c'aba' Satanás. Wa ju yet quisinin bin u joc'sejob. Jeroj caj u toc ch'esob u bʌj. Jeroj mʌna' quisin. ");
INSERT INTO lacNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jesús caj u nuncaj ti' u winiquirob judío a fariseobo': ―A techexo', ca wa'ariquex caj in joc'saj c'ac'as quisin yejer u muc' Beelzebú. Wa taj a ba' ca wa'ariquex ―quij Jesús―. Arex ten bic tabar cu joc'sic c'ac'as quisin a camsʌwiniquex? Caj ya'araj Jesús ti' u winiquirob judío a fariseobo': ―Cu joc'sicob quire' c'ac'as quisin yejer u muc' jach ts'ur Beelzebú xan. Mʌ' ju joc'sejob quisin yejer u muc' Beelzebú. Rajen a camsʌwiniquex xan, cu yesicob mʌ' taj a ba' ca wa'ariquex ti' ten ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Caj ya'araj Jesús ti' u winiquirob judío a fariseobo': ―A teno', quin joc'sic c'ac'as quisin ―quij Jesús―. Quire' caj u ts'aj ten u Taj'or u Pixam C'uj. Rajen chʌca'an a wiriquex ti' yʌn u muc' C'uj tu yʌnechex. ");
INSERT INTO lacNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Caj ya'araj Jesús ti' u winiquirob judío a fariseobo': ―Bic tabar in joc'sic u c'ac'as quisin wa mʌ' tin yʌn rubsaj u muc' u jach ts'urir quisin, Satanás? A baywo' ―quij Jesús―, c'ucha'an in wor in joc'sic quisin. Quire' aro' irej a mac oquij ich yatoch a mac chich u muc' irej wa caj u c'ʌxaj soc u rʌc ch'ic u ba'tac. ");
INSERT INTO lacNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’A mac a mʌ' ju yamtiquen, cu p'actiquen an ten bic a p'actiquenex. A mac mʌ' ju cha'ic ca' in taquic mac caj u joc'saj u rac'ob ca' xicob ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Rajen quin wa'ariquex tech ―quij Jesús―. Techex ca p'astiquenex caj a wirex in joc'sic c'ac'as quisin. Cax ca p'astiquenex ―quij Jesús―. Cax ca pach'iquenex quin jawsiquex a si'pirex. Caj ya'araj Jesús: ―Wa ca p'astiquex u Taj'or u Pixam C'uj mʌ' biq'uin cu jawʌr a si'pirex. ");
INSERT INTO lacNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","A teno', taren in yamtej tu cotor mac. A mac a cu p'astiquene', je' u jawʌr u si'pire'. A mac a cu jach p'astic u Taj'or u Pixam C'uj mʌ' u bin jawʌr u si'pir, cax u q'uinin baje'rer, cax u q'uinin u xur t'ʌn, mʌ' u jawʌr u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Caj ya'araj Jesús ti' u winiquirob judío a fariseobo': ―Wa ca wiriquex u che'er a cu wichʌncʌr. Mʌ' a werex wa jach tsoy u che'er wa c'as u che'er. Wa chʌca'an a wiriquex wa tsoy u wich a wer tsoy u che'er. Bayiri' xan, wa chʌca'an a wiric wa c'as u wich a werex c'as u che'er. Rajen a werex biquira' u che'er. Cʌnex ti' aro'. Mʌ' a chen man a pʌq'uiquex u pach a rac'ob, an ten bic caj a wa'arex ten quin beyaj yejer quisin ―quij Jesús―. A mac cu man tu tsoyir ca' a wa'arex: “Tsoy a rayo'”, an bic caj a wirex in joc'sic c'ac'as quisin. Mʌ' wa tsoy ca' in joc'sej quisin? ―quij Jesús―. A mac mʌ' ju man tu tsoyir ti' cu man tu c'asir. ");
INSERT INTO lacNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Caj ya'araj Jesús ti' u winiquirob judío a fariseobo': ―Jach c'asechex ―quij Jesús―. Ti' cu joc'ar a t'ʌnex ich a chi'ex an ten biquechex can. Mʌ' ja wirej, a cano', cu chi'ic mac. Mʌ' u joc'ar tsoy a t'ʌnex. Mʌ' ja wirej, toc c'asechex. Rajen mʌ' taj a ba' ca wa'ariquex, quire' a ba' cu joc'ar ta chi'ex ti' cu tar ich a pixamex quire' c'as a pixamex. ");
INSERT INTO lacNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Caj ya'araj Jesús: ―A xibo', wa toc tsoy cu joc'ar u t'ʌn, toc tsoy u pixam. Baxuc xan, a xibo', wa c'as cu ya'aric, mʌ' toc tsoy u pixam. Mʌ' ja wirej, c'as cu ya'aric. ");
INSERT INTO lacNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Rajen quin wa'aric techex. Taj quin wa'aric techex, ra' u q'uinin ca' bin xuruc t'ʌn a ba' caj a wa'arex ra' ca bin a wuyiquex ya'aric techex C'uj. Quire' c'as caj a wa'arex. Tu cotor mac cu bin yubic ya'ara' ten C'uj u ric'smʌnex a t'ʌnex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","A wʌc'ʌs t'ʌnex cu bin u ta'quiquex a jo'rex quir a bin erarex. Bayiri' xan, a wʌc'ʌs t'ʌnex cu bin u taquiquex soc mʌ' a werarex. ");
INSERT INTO lacNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Caj tarob u winiquirob judío a fariseobo'. Caj c'ata'b ti' Jesús. Yet tarac yʌjcamsʌyʌjirob u t'ʌn Moisés. Mʌ' ya'ab tarob ich Jesús. Caj ara'b ti' Jesús ten u winiquirob judío a fariseobo' yejer u camsʌyʌjirob u t'ʌn Moisés: ―Esej to'onex carem beyaj in wʌjcamsʌyʌjirech soc ij querex tarech ich C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Caj u nuncaj Jesús: ―A techexo', a mac cʌja'an tu q'uinin baje'rer jach c'asechex. Mʌ' taj ca c'ujintiquex C'uj. Rajen caj a tus c'atenex ca' in wesic techex carem beyaj. Jari' ca bin a wirex an ten bic Jonásen, u yʌjtseq'uirir u t'ʌn C'uj uch, soc a werex taren ich C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","An ten bic Jonás ti' yʌn ich u japnin u nʌc' cʌy. Caj ruc' ten cʌy a caremo'. Mʌna' u nup' u q'uinin ti' yʌn Jonás ich u japnin u nʌc' cʌy. Ac'bir xan ti' yʌn Jonás. Baxuc ten xan biq'uino' mʌna' u nup' u q'uinin ti' yʌnen ich u japnin ru'um xan. Mʌna' u nup' ac'abir xan ti' yʌnen quire' taren in yamtic mac tu cotorob. ");
INSERT INTO lacNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Caj ya'araj Jesús: ―C'aj techex wa Jonás caj bin u tsec'tej u t'ʌn C'uj ich u cajar Nínive caj joc' ich u nʌc' cʌy. Caj u rʌc c'axaj tu yorob ca' u rʌc p'ʌtob u manob tu c'asir tu cotor mac ich u cajar Nínive. Jesús caj ya'araj: ―Ca' bin xuruc t'ʌn, a mac caj u c'axaj tu yorob caj u p'ʌtajob u c'asirob ich u cajar Nínive cu bin ya'aricob: “Jach c'asechex”, mʌ' ta c'axex a worex soc a p'ʌtiquex a c'asirex cax caj a wirex in tar in tsec'techex a wu'yex u t'ʌn C'uj ―quij Jesús―. Jach manan in tsec'tic techex ―quij Jesús―. A Jonáso' mʌ' nec'ucha'an yor u tsec'tic. ");
INSERT INTO lacNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","C'aj wa techex, caj tar xquic reina tu cu reyinticob u ru'umin Etiopía. Tar yubej a ba' cu najtic Salomón tu cotor a ba' ti' yʌn ich yoc'ocab. Cax jach nach caj tar yubic ich Salomón. Ca' bin xuruc t'ʌn je' ya'aric xquic ti' C'uj: “Jach c'as aro' a mac cʌja'anob tu q'uinin ti' yʌn Jesús ich yoc'ocab. Quire' mʌ' tu c'ʌmajob u t'ʌn Jesús.” Chen a teno' ―quij Jesús―, taren in tsec'tic u t'ʌn C'uj quir a najtiquex, chen mʌ' a c'ʌmexi'. Chen a Salomóno', mʌ' ne manan u camsic. A teno' ―quij Jesús―, jach manan quin camsic tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Caj ya'araj Jesús ti' u winiquirob judío a fariseobo': ―A techex irex a mac aca'an c'ac'as quisin ti' uch. Caj joc quisin' caj bin ich tʌcay ru'um quir u cʌjtar quisin chen mʌ' tu yiraj. ");
INSERT INTO lacNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Rajen a c'ac'as quisino' u c'at u wʌc'ʌs ur ich winic tu joc'sa'b uch. Caj tar yiraj jach tsoy, irej naj, toc mista'an. ");
INSERT INTO lacNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Rajen rʌc bin u pʌyic yet quisinin. Siete caj u pʌyaj u yet quisinin. Jach manan c'asir u yet quisinin. Caj wʌc'ʌs oc ich a xibo'. Jach manan c'as, a ucho', mʌ' nec'asi'. Baxuc ca rʌc bin a cʌniquex a cuxa'anex mac baje'rer ―quij Jesús―, a ra' aca'an u quisinino'. ");
INSERT INTO lacNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús mʌ' toy ts'ocac u tsicbar yejer a pimo' caj c'uchij u nʌ' Jesús yejer yits'inob Jesús. Tar xur nach tu mʌna' mac, quire' pim bʌcrista'b Jesús. Tarob u tsicbarob yejer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Caj ara'b ti' Jesús ten mac: ―Tu t'ʌniquech a nʌ' yejer a wits'inob ―quij―. U c'at u tsicbar yejerech a nʌ' ―quij―, quet yejer a wits'inob. ");
INSERT INTO lacNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Caj t'an ten Jesús ti' a mac a tar t'ʌnbir Jesús: ―Taj ca wa'aric, ra' in nʌ' yejer in wits'inob. ");
INSERT INTO lacNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Caj u tuchbar ti' u camsʌwinic, Jesús: ―A jera' irob in jach nʌ'. A jeroj irob in jach its'inob. ");
INSERT INTO lacNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mʌ' ja wirej, a mac cu man u betic a ba' tsoy tu t'ʌn C'uj, in Tet ca'anan. Ra' irej in jach nʌ'. Ra' irej in jach its'inob. ");
INSERT INTO lacNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ra'iri' u q'uinin caj joq'uij Jesús ich naj caj bin chi' c'ac'nab. Ra'iri' u q'uinin caj toc bin Jesús cutar ich chi' c'ac'nab quir u camsic mac. ");
INSERT INTO lacNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Caj rʌc tar much'ta'bir ich Jesús jach pim. Caj oc Jesús ich chem caj curʌj. Caj rʌc ch'icrʌj a pim ich chi' c'ac'nab. ");
INSERT INTO lacNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Caj u camsaj Jesús a pimo' an bic tabar u pʌq'uic u pʌc'ar tu cor chen quir u camsic. Caj ya'araj Jesús: ―Mac bin u pʌq'uic, u pʌc'ar ich u cor. ");
INSERT INTO lacNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A mac caj bin u q'uich'intej ich u cor. Caj u q'uich'intaj caj rʌc rub ich bej mʌ' ya'abi'. Caj tar u ruq'uic ch'ich'. ");
INSERT INTO lacNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","U jer tar rʌc rube' ich tunich tu mʌ' pim u ru'umin. Seb caj ts'ejernʌji, quire' chan jay u ru'umin. Rajen seb caj joc'. ");
INSERT INTO lacNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Caj naquij q'uin caj quimin, quire' jay u ru'um. Mʌ' tu bin ocac u mos. Rajen quimij. ");
INSERT INTO lacNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","U jer caj rʌc q'uich'intaj. Caj rub ich q'ui'ix. Caj ch'ijij caj rʌc bobʌsta'b ten q'ui'ix caj quimij. ");
INSERT INTO lacNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","U jer caj u rʌc ca' q'uich'intaj ich u jer ru'um. Jach tsoy u ru'um. Caj u nets'aja u wich. Cien caj u toc ts'aj u wich. U jer caj u ts'aj u wich sesenta. U jer caj u ts'aja u wich treinta. ");
INSERT INTO lacNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","U'yex ba' quin camsic techex soc a wu'yiquex soc a najtiquex a ba' u c'at ya'aric. ");
INSERT INTO lacNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Caj ts'oc u camsa' ten Jesús caj u juts' u bʌj u camsʌwinicob ich Jesús. Caj c'ata' ti' Jesús: ―Biquinin ca camsic a pim bic tabar u q'uich'intic yijir ich u cor? ");
INSERT INTO lacNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús caj ya'araj ti'ob: ―Je' u ts'iquex tech C'uj quir a najtiquex a ba' tu mucu araj ten C'uj ti' Cristo. Chen a pimo' mʌ' ju bin u najtejob quire' mʌ' tu c'ʌmajob u t'ʌn C'uji'. ");
INSERT INTO lacNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A ba' ta chʌc cʌnajex baje'rer ca chʌc najtiquex. Chen je' a najtiquex hasta ca qui' najtiquex bic tabar u reyinticob C'uj. Chen a pimo' mʌ' ju bin u najtejobi'. Chen a ba' caj in chʌc camsaj ti'ob je' u rʌc tubur ti'ob. Mʌ' ju p'atʌr ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rajen caj in chʌc camsa a pimo' bic tabar u q'uich'intic yijir u pʌc'ar ich cor, quire' cu chen uyicob mʌ' ju najtobi'. ");
INSERT INTO lacNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Quire' a ba' tsec'ta'b ten Isaías ti' u winiquirob judío uch jach joq'uij u tajir baje'rer. U'yex ba' ara'b ten Isaías ti' u winiquirob judío uch: Rajra' ca bin a wu'yex, chen mʌ' a bin a najtex. Rajra' ca bin a wirex, chen mʌ' a bin a jach irex. ");
INSERT INTO lacNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Quire' jach chich u jo'r u winiquirob judío. Mʌ' ja wirej, caj u mʌchajob u xiquinob, caj u muts'ajob u wichob soc mʌ' c'ucha'an yor yiricob. Bayiri' soc mʌ' c'ucha'an yor yubicob u t'ʌn C'uj, soc mʌ' ju najtejob xan. Soc u c'axicob u yorob soc u jawsa'r u si'pir ten C'uj. Baxuc caj tsec'ta'b ten Isaías ti' u winiquirob judío uch. ");
INSERT INTO lacNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","A techexo', qui' a worex quire' ca chʌc najtiquex bic tabar cu bin u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Caj ya'araj Jesús ti' u camsʌwinicob: ―Jach taj quin wa'aric techex. Ya'ab u yʌjtseq'uir u t'ʌn C'uj u c'at yiricob a ba' ca wiriquex baje'rer. Baxuc xan, ya'ab mac a tsoy yorob u c'at yiricob a ba' ca wiriquex baje'rer. Baxuc xan, caj u c'at yubicob a ba' quin camsiquechex. Chen mʌ' tu yubob quire' quimob. ");
INSERT INTO lacNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Caj ya'araj Jesús ti' u camsʌwinicob: ―U'yex bic tabar a caj in camsechex bic tabar u bin u pʌq'uic u pʌc'ar ich u cor. ");
INSERT INTO lacNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jesús caj u tajquintaj ti' u camsʌwinicob: ―A caj a wu'yajex sam. A mac a caj yubaj in t'ʌn ti' u ru'umin tu cu bin u reyintejob C'uj. Cu tar a quisino' cu ta'quic ti' mac u t'ʌn C'uj soc mʌ' u najtej, irej u yijir rub ich bej, a caj in camsajechex sam. ");
INSERT INTO lacNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Baxuc xan, a rub yijir ich tunich, an ten bic a mac cu yubic u t'ʌn C'uj seb caj qui'jij yor, quire' caj u c'ʌmaj u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aro' irej u yijir a mʌ' tam oc u mos. Seb caj u toc p'ʌtaj u t'ʌn C'uj quire' caj yubaj u tumtaj yor. Caj yub u chucur u pach quire' caj u yacsaj tu yor. Rajen caj u p'ʌta yacsic tu yor. ");
INSERT INTO lacNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A yijir tu q'uich'intaj, rub ich q'ui'ix. Baxuc cu camsiquechex ti' u t'ʌn C'uj, an ten bic mac cu yubic u t'ʌn C'uj. Mʌ' ja wirej, a ba' yʌn yoc'ocab cu pachtic. Cu pachtic u neja'ric u taq'uin, ra' cu bobʌstic irej q'ui'ix caj u bobʌstaj tu q'uich'intaj. Rajen mʌ' ju nequi' acsic yor. Mʌ' taj cu yacsic tu yor. ");
INSERT INTO lacNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Caj ya'araj Jesús ti' u camsʌwinicob: ―A rub yijir tu tsoy u ru'umin, ra' quir u camsiquechex a mac tu jach c'ʌmaj u t'ʌn C'uj. Caj u toc ts'aja u wich cien. Ra' cu qui' man tu tsoyir. U jer caj u ca' ts'aja u wich sesenta. Ra' cu man tu tsoyir, chen mʌ' c'ucha'an yor tu qui' acsic tu yor cien. U jer caj u ca' ts'ajaj u wich treinta u wich. Ra' cu man tu c'ʌs tsoyir, chen mʌ' tu qui' acsaj tu yor ti' sesenta u wich ―baxuc caj ya'araj Jesús ti' u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús cu ca' camsic u camsʌwinicob bic tabar cu bin u reyinticob C'uj. Caj ya'araj Jesús: ―An bic tabar u pʌq'uic u pʌc'ar trigo ich cor. Caj u rʌc q'uich'intaj tu cor. ");
INSERT INTO lacNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Caj man u rʌc purej u robir tub u pʌc'man u pʌc'ar trigo a mac a cu p'actic ti'. Quire' wenʌn u ca'ob, mac caj man u pur u robirir tub u pʌc'ar trigo u rac'ob. P'acta'b ten u rac'ob, rajen cu man u pʌq'uic u robir tu pʌc'a'an trigo. Caj ts'oc u puric u robir caj bin ich yatoch. ");
INSERT INTO lacNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Caj ch'ijij u pʌc'ar trigo, yet ch'ijac u robirir hasta job u wich u pʌc'ar trigo. Quet tar u wich u robirir. ");
INSERT INTO lacNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Caj bin ya'araj u c'urew ti' u jach ts'urir: “A ta pʌc'aj trigoje' Jach Ts'ur, xaca'an yejer robirir cu ch'ijir. A caj a pʌc'aj yirir uche' tsoy. U ch'ijir a baje'rer yʌn u robirir xaca'an. An tub u tar u robirir caj joc'?” ");
INSERT INTO lacNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Caj ara'b ten u jach ts'urir: “Yʌn mac caj u pʌc'aj u robirir ich trigo. Ra' cu p'actiquen. Raji' caj u pʌc'aj u robirir.” Caj ya'araj ti' u jach ts'urir: “Ar in rʌc bin in jaquej u robirir.” ");
INSERT INTO lacNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Caj ya'araj u jach ts'urir: “Mʌ', chen u robirir ca jaquiqui' quet ca bin a jaquic xan u wich trigo. ");
INSERT INTO lacNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cax ch'ijir u robirir yejer trigo hasta cu ts'ic u wich trigo. Je' in tuchi'ticob u wʌticob u wich trigo, yet bin u jaquicob u robirir. U robirir cu yʌn bin u jaquejob ca' u jep' c'ʌxtejob u robirir ca' u toquejob. Cu ts'ocare' cu wʌticob trigo ca' u ric'sejob.” ");
INSERT INTO lacNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús caj u camsaj bic tabar cu bin u reyinticob C'uj. Rajen caj u ya'araj ti'ob: ―An ten bic u ch'ijir u pʌc'ar mostaza xib ich ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jesús caj ya'araj: ―Mʌna' u jer yijir jach mijin yijir mostaza. Cu ch'ijire' jach manan u xit'ir u c'ʌb. U jer u pʌc'ar mʌ' u nexit'ir u c'ʌb. Hasta ch'ijir u che'er jeroj cu tar ch'ich' u c'ʌxicob u c'u'. ");
INSERT INTO lacNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús caj u ca' camsaj. Rajen caj ya'araj ti'ob: ―Bajen u ru'umin tu cu bin u reyinticob C'uj ra' irej u ts'ac yoch pan a xquico' cu puric ich harina mʌna' u nup u tenin u puric. Cu ts'ocar u puric cu rʌc sip tu cotor. ");
INSERT INTO lacNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mʌ' u camsa' u jer t'ʌn. Toc ra'iri' caj u camsaj. Bic tabar caj u pʌc'aj u yijir mostaza soc yerob bic tabar cu bin u reyintic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Soc u nup'ur u t'ʌn a ba' ara'b ten yʌjtseq'uir u t'ʌn C'uj uch, rajen a baywo' Jesús caj u camsaj ti'ob. Mʌ' ja wirej, a mac a ts'a'b u tucur ten C'uj caj u ts'ibtaj uch: Quin wa'aric ti'ob, quij yʌjts'eq'uir u t'ʌn C'uj, an ten bic mʌ' yubmʌn uch ra' u q'uinin caj ts'oc u beta'r ich yoc'ocab. Baxuc caj u ts'ibtaj a mac ts'a'b u tucur ten C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús caj ya'araj ti' a pimo': ―Xenex ich a watochex. Caj binob Jesús caj oc ich yatoch mac. Caj u juts'ob u bʌj u camsʌwinicob ich Jesús. Caj ya'arob u camsʌwinicob: ―Arej tenob a ba' ca camsic tenob cu joc'ar u robirir u pʌc'ar trigo. ");
INSERT INTO lacNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Caj ya'araj Jesús ti' u camsʌwinicob: ―Quire' a mac a cu man u pʌq'uic tsoy yijire', ten ―quij Jesús―. Quire' taren in yamtic mac tu cotor. Yʌjpʌq'uiren. ");
INSERT INTO lacNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A tu quin pʌq'uic yijire', te' ich yoc'ocab. A quin pʌq'uic yijire' ich yoc'ocab, ra' u winiquir cu yacsic tu yor in t'ʌn. A robirire', raji' winiquir mʌ' tu yacsaj tu yor ti' ten. ");
INSERT INTO lacNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ra' u q'uinin caj u wʌticob u wich trigo yejer u robirir, ra' u q'uinin ca' bin xuruc t'ʌn. Raji'ob a tu wʌtajob u wich trigo yejer u robirir. Mʌ' ra' cu bin jach wʌticob, yʌjmasirob u t'ʌn C'uj. Wa mac caj u pʌc'aj robirir, quisin caj u pʌc'aj yijir, quire' cu p'actiquen. ");
INSERT INTO lacNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Baxuc a cu maric u robirir u purejob ich c'ac'. Quet bayiri' cu bin u teticob a mac mʌ' ju yacsob tu yorob. Ra' cu bin purbir ten yʌjmasirob u t'ʌn C'uj ich c'ac' ca' bin xuruc t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Caj ya'araj Jesús: ―A teno', a mac tar u yamtic tu cotor mac. Quin bin in tuchi'tic yʌjmasirob u t'ʌn C'uj quir u teticob a mac yʌn u si'pir. Chen cu yʌn bin u teticob a mac a caj u pʌyob u si'pir u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tar cu bin joc'ar purbir ich c'ac'. Ti' cu bin yac'ticob u bʌj ich c'ac' tu cuch tu cu to'quic mac. Ti' cu bin u jach muc'yaj ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Chen a mac a caj u yacsaj tu yor in t'ʌn ―quij Jesús―, a C'ujo' cu bin ya'aric ti' a mac a caj u c'ʌmob in t'ʌn. Je' ya'ara' ten C'uj: ―Qui' in wor in wiriquech ―quij C'uj―. Je' u yesiquech ti' tu cotor mac quir yiric qui' yor yiriquechex C'uj. Qui' u'yex ba' quin wa'aric techex. ");
INSERT INTO lacNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Caj ya'araj Jesús: ―Bic tabar cu bin u reyintic C'uj irej a mac a mʌnmʌn u ru'um, caj yiraj ti' muca'an u taq'uin. Caj yiraj ti' muca'an u taq'uin qui' yor. Caj u ca' mucaj caj bin u mʌnej u ru'um. Caj u rʌc xupaj u taq'uin tu u mʌnmʌn u ru'um. Cax tu rʌc canaj u ba'tac xan quir u mʌnic. ");
INSERT INTO lacNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Caj ya'araj Jesús ti' u camsʌwinicob: ―Soc a werex bic tabar cu bin u reyintic C'uj. Irej a mac a nanij cu man u cʌxtej u mʌnej sʌc uj, a jach co'oj. ");
INSERT INTO lacNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Caj u yiraj jach co'oj sʌc uj, caj yiraj mʌ' c'ucha'an yor u mʌnic quire' jach co'oj. Rajen caj rʌc bin u canic u ba'tac quir u mʌnic sʌc uj. ");
INSERT INTO lacNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Caj ya'araj Jesús ti' u camsʌwinicob: ―A werex bic tabar cu bin u reyintic C'uj. Irej a cu puric u chimin cʌy quir u chuquic cʌy ich c'ac'nab. Caj u chucaj xaca'an ba' cʌyir cu yocar ich chim. ");
INSERT INTO lacNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Caj chup u cʌyir ich chim, caj u jitaj ich chi'c'ac'nab. Caj curʌj u tetej a tsoyo', caj u rʌc puraj a c'aso', quire' mʌ' qui' u chi'bir. Caj u but'aj ich xac a tsoyo'. ");
INSERT INTO lacNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Baxuc cu bin u betic ich yoc'ocab ca' bin xuruc t'ʌn. Je' u tarob yʌjmasirob u t'ʌn C'uj quir u teticob a mac c'as quir u tetic a mac tsoy xan. ");
INSERT INTO lacNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tar cu bin u teticob a mac c'as quir u tetic a mac tsoy xan. Tar cu bin purbir ich c'ac' tu cuchir u to'quic mac quire' c'as. Tu cu bin u jach muc'yaj. Tu cu bin u jach ac'ticob u bʌj tu cu yerar. ");
INSERT INTO lacNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Caj c'ata'b ten Jesús ti' u camsʌwinicob: ―Ta rʌc najtajex a ba' tin camsajechex? Caj u nuncajob u camsʌwinicob: ―Tin cʌnajob Jaj Ts'ur. ");
INSERT INTO lacNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Caj ya'araj Jesús ti' u camsʌwinicob: ―Mʌ' ja wirej ―quij Jesús―. Quire' caj a najtex tu cu bin u reyintej C'uj ca' bin a cʌnex irechex yʌjcamsʌyʌjirob u t'ʌn Moisés a cu camsicob ti' u rac'ob a ba' camsa'b ten yʌjtseq'uirob u t'ʌn C'uj uch. Baxuc ca bin a camsex ti'ob u t'ʌn C'uj a ric'beno'. ");
INSERT INTO lacNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús caj ts'oc u camsic bic tabar cu bin u reyinticob C'uj caj bin Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Caj c'uchij Jesús tu cajar Nazaret tu ch'ijij Jesús uch. Caj u yʌnxchun u camsic ti'ob Jesús tu cu naj c'ujinticob C'uj u winiquirob judío: ―Tub u tar caj yubaj a je' xiba' a ba' cu camsico'on? A ju ne'er u camsico'on Jesús. An tub u tar caj u cʌnaj carem u beyaj ―baxuc caj ya'arob u rac'ob ich u cajar. ");
INSERT INTO lacNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Caj ya'arob: ―Mʌ' wa raji' u parar yʌjsusiche'? Caj ya'arob: ―Biquinin ra' u bʌj Jacobo. Ra' u bʌj José xan. Ra' u bʌj Simón xan. Ra' u bʌj Judas xan. ");
INSERT INTO lacNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Caj ya'araj u rac'ob tu cajar Nazaret: ―Ti' cʌja'an xquic u bʌjob Jesús. P'eri' yejero'onex. An tub u tar caj u cʌnaj aro'? ");
INSERT INTO lacNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Rajen u rac'ob caj choquij yorob ti' Jesús. Caj ara'b ten Jesús ti' u rac'ob: ―Mʌ' u c'at yirir a mac ts'a'b u tucur ten C'uj wa ti' cʌja'an tu jach cajar. Cax u wʌc'ʌs u bʌjob, mʌ' u c'at yiricob. Chen mac cʌja'an nach u c'at yubicob. ");
INSERT INTO lacNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mʌ' ya'ab caj u jawsa mac Jesús tu cajar Nazaret quire' mʌ' ju yacsob tu yorob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ra' u q'uinin ti' yʌn Jesús ich u cajar Nazaret. Caj yub u rey Herodes ti' yʌn Jesús. Caj yubaj u jumbinta' jach carem u beyaj Jesús. Ra' Herodes gobernador u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Caj ara'b ten Herodes ti' a mac a cu yamticob u reyinticob Herodes: ―In wer raji' Juan ―quij Herodes―, a cu yacsic ja' tu jo'r mac. Riq'uij caj quimij rajen jach carem u beyaj Juan ―quij Herodes. ");
INSERT INTO lacNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Uch chuc Juan ten Herodes. Caj mac tu cu ma'cʌr u winiquir. Caj c'arar Juan. Caj c'arij yoc Juan ten Herodes. Caj ara'b ten Juan ti' Herodes: ―Mʌ' tsoy a ch'ic a mu'. Herodías u c'aba' u rac' u yits'in Felipe. Rajen chuc Juan. ");
INSERT INTO lacNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Cax Herodes u c'at u quinsic Juan, cu ch'ic sajquir ti' a pimo'. Herodes yer je' u p'ujur a pimo', quire' yerob a Juano' cu tsec'tic u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Caj c'uchij tu q'uinin quir u c'ʌ'otic tuj rocha'b Herodes ten u nʌ' uch. Caj u pʌyaj u rac'ob Herodes quir u qui'qui' janʌnob. Caj joc' u ts'enʌ' Herodes. Caj oc'atnʌjij tu pim a mac. Jach tsoy yirir yoc'at ten Herodes. ");
INSERT INTO lacNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ts'oc yoc'at u ts'enʌ', caj ya'araj ti' u ts'enʌ': ―Ʌcʌtan tu wich C'uj wa ba' a c'at je' in ts'ic tech. Wa mʌ' in ts'a tech cax u quinsen C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","U ts'enʌ' Herodes caj bin tu yʌn u nʌ'. Caj ara'b ti' ten u nʌ': ―Xen c'atej ca' u xonch'ʌctej u car Juan a cu yacsic ja' tu jo'r mac ca' u ts'aj tech u jo'r Juan. Ca' u but'ej tech ich u rʌquir quir a pe'jic u jo'r Juan. ");
INSERT INTO lacNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Caj yubaj u c'ata'r ten u ts'enʌ': ―Chuquej ten u jo'r Juan. Tu pachir tucraj quire' mʌ' u c'at u quinsa'r Juan ten Herodes. Quire' tu rʌc u'yajob mac cura'an tu cu qui'qui' janʌnob, quire' caj u toc araj: “Je' in ts'ic tech a ba' a c'at.” Rajen caj tuchi'ta'b ten Herodes ca' xonch'ʌctac u car Juan. ");
INSERT INTO lacNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Caj ya'araj Herodes: ―Xen xonch'ʌctej u car Juan tu mʌca'an. ");
INSERT INTO lacNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Seb caj u ch'aj u jo'r Juan ich u rʌquir. Caj ts'a'b ti' xquic caj bin u ts'aj ti' u nʌ'. ");
INSERT INTO lacNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Caj tarob u camsʌwinicob Juan. Caj tar ch'a'bir u baquer Juan, caj u mucob u baquer. Ts'oc u muquicob u baquere', caj bin arbir ti' Jesús: “Mʌna' Juan.” ");
INSERT INTO lacNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús caj yubaj bic tabar caj quinsa'b Juan caj bin Jesús. Tu junan caj binij. Caj binij yejer chem tu mʌna' mac. Caj yubob caj bin Jesús tu junan, caj rʌc tar a pimo'. Caj rʌc c'uchob ich Jesús. A pimo', caj joc'ob tu cajar caj binob ich yoc tu yʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Caj oc Jesús ich chem caj yiraj jach pim mac caj u much'quintob u bʌj ich Jesús. Caj yiraj a pimo', caj u yajquintaj quire' otsir caj irir ten Jesús rajen. Caj jawsa'b u yajirir a mac tar purbir. ");
INSERT INTO lacNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Oq'uin caj c'uchij u camsʌwinicob ich Jesús. Caj c'uchob u camsʌwinicob Jesús caj ya'arob: ―Cu bin ic yum. Mʌna' mac a tera'. Arej u binob u mʌnejob yo'och quir u janticob a pimo'. Arej ti'ob ca' xicob u mʌnejob yo'och ich u chan cajarob. ");
INSERT INTO lacNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús caj ya'araj ti'ob: ―Cax mʌ' ju binob ―quij Jesús―. Ts'ajex yo'och pan. ");
INSERT INTO lacNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Caj u nuncajob u camsʌwinicob: ―Mʌ' ya'ab in wo'och panobi'. Yʌn cinco pan tenob. Ca'tur cʌy yʌn tenobi'. ");
INSERT INTO lacNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús caj ya'araj: ―Chuquej tera' ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesús caj ya'araj ti' a pimo': ―Rʌc much'quintex a bʌj. Curenex ich su'uc. Caj rʌc curʌjob. Caj u rat'aj yo'och pan a cinco pano'. Caj u rat'aj yo'och cʌy xan, ca'tur cʌy. Caj u pʌctaj ca'anan caj u t'ʌnaj C'uj Jesús: ―Bayo' C'uj ―quij Jesús―. Ta ts'aj ij co'ochex pan. Caj ts'oc u t'ʌnic C'uj Jesús, caj u rʌc jʌsaj ti' u camsʌwinicob. Robob ca' u rʌc t'axaj yo'och ti' a pim. ");
INSERT INTO lacNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Caj u jantob a pimo', cinco mil xib caj rʌc na'achʌjob. Mʌ' u xacaj a xquic, mʌ' u xacaj u chan ti'ar. Pachir caj u marajob doce xac, chup u xet'er. Caj u rʌc marob u xet'er quire' mʌ' ju rʌc jantaj. ");
INSERT INTO lacNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Seb caj ya'araj Jesús yocarob u camsʌwinicob ich chem quir u ch'ʌctic c'ac'nab. Ra' yʌn u c'uchurob camsʌwinicob pach c'ac'nab. Pachir ca' bin c'uchuc Jesús. Caj bin u t'ʌnej ca' xicob a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Caj ts'oc u tuchi'tic a pimo', caj rʌc binob. Caj bine', caj bin Jesús u t'ʌnej C'uj ich u jo'r p'uc wits. Tu junan caj bin. Caj bin ic yum ti' yʌn Jesús tu junan. ");
INSERT INTO lacNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A chemo', ti' yʌn chumuc c'ac'nab. Caj c'uchij chumuc c'ac'nab caj tar yic'ar. Caj nup'o' yic'ar ich chumuc c'ac'nab. Cu ts'icch'inta'r u chemin ten u yamin. ");
INSERT INTO lacNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cu sastar caj c'uchij Jesús tu yʌnob u camsʌwinicob. Caj tar Jesús ich yoc'o ja'. ");
INSERT INTO lacNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Caj yiraj u camsʌwinicob cu tar Jesús ich yoc'o ja' caj jaq'uij yorob. Caj awʌtnʌjob quire' sajʌcob. Caj ya'arob: ―Quisin cu tar. ");
INSERT INTO lacNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Seb caj u puraj u t'ʌn, Jesús caj ya'araj: ―Chichquintej a worex, ten ―quij Jesús―. Mʌ' ja ch'iquex sajquire' ten. ");
INSERT INTO lacNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Caj ya'araj Pedro: ―Jaj Ts'ur, ar in tar tu yʌnech ich yoc'o ja' wa tech ca tar ich yoc'o ja'. ");
INSERT INTO lacNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Caj ya'araj Jesús: ―Cojen. Caj joc' ich chem Pedro. Caj bin yoc'o ja' caj c'uchuc tu yʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Caj yubaj u tar c'am yic'ar Pedro caj jaq'uij yor. Caj jaq'uij yore' caj u yʌnxchun u jurur. Caj awʌtnʌjij: ―Taquen, Jaj Ts'ur. ");
INSERT INTO lacNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tabar u c'uchur ich Jesús caj jur. Caj chuc u c'ʌb ten Jesús, caj joc'sa'b ten Jesús. Caj ara'b ten Jesús: ―Chichin ca wacsic ta wor ten Pedro. Mʌ' ju yʌn jac'ʌr a wor. ");
INSERT INTO lacNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Caj wʌc'ʌs oc Pedro ich chem yejer Jesús caj ch'enij yic'ar. ");
INSERT INTO lacNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A mac a ti' yʌnob ich chem, caj rʌc xonrʌj tu yʌn Jesús quir u c'ujinta'r Jesús. Caj ya'arob: ―U pararech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Caj c'uchob ich chi'c'ac'nab tu cajar Genesaret quire' caj u ch'ʌctob c'ac'nab. ");
INSERT INTO lacNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","A mac a ti' yʌn ich u cajar Genesaret u c'ʌ'omʌnob Jesús. Caj rʌc manob u jumbintejob ti' yʌn Jesús. Rajen rʌc tarob purbir u yajirir ich Jesús. Cax u cajar nʌts'a'an, ti' cu tarob purbir u yajirir. ");
INSERT INTO lacNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Caj chich c'ata'b ti' Jesús ten a mac a yaje': ―Cax in tʌrejob yoquirir a noc' wa ja c'at in tʌricob yoquir a noc' ―quij ya'araj ti' Jesús. Caj rʌc tarij yoquirir u noc' Jesús caj rʌc jaw. ");
INSERT INTO lacNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Caj tarob tu yʌn Jesús. Tarob u winiquirob judío a fariseobo' quir u c'aticob ti' Jesús. Tar u tar u winiquirob judío a fariseobo' ich u cajar Jerusalén. Yet taracob yʌjcamsʌyʌjirob u t'ʌn Moisés. Mʌ' ya'ab caj c'uchob ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Caj c'ata'b ti' ten u winiquirob judío a fariseobo' yejer yʌjcamsʌyʌjirob u t'ʌn Moisés: ―Biquinini' a camsʌwinicob mʌ' u quibejob a ba' cu ya'aricob ic nunquir? Rajra' cu janʌnob. Mʌ' u p'o'icob u c'ʌb cu janʌnob. ");
INSERT INTO lacNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Caj c'ata'b ti'ob ten Jesús: ―Biquinin ca cʌrʌx betiquex u t'ʌn C'uj? Biquinin u t'ʌn a nunquirex ca cʌniquex? Mʌ' tan a quibiquex a ba' cu ya'ariquex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Caj u ya'araj Jesús: ―“Ca' a sʌjt a tet, quij C'uj. Baxuc a nʌ' xan ca sʌjtic. Mʌ' tsoy a pach'ic a tet yejer a nʌ'. Bin a ca' quimin, quire' caj pach'aj u tet yejer u nʌ'. Cu joc'sa' ch'inbir u jo'r ten u rac'ob quire' caj u pach'aj u tet yejer u nʌ'.” Baxuc caj ya'araj C'uj ich u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Biquinin techex ca wa'ariquex a tet yejer a nʌ' mʌ' u c'uchur a worex a yamtex a tet yejer a nʌ' quire' a ba' yʌn techex caj a toc ts'ajex ti' C'uj? Baje'rer mʌ' techex yʌnin, C'uj yʌnin. ");
INSERT INTO lacNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A techexo', ca camsiquex cax a mac cu ya'aric: “Mʌ' in yamtic in tet yejer in nʌ'. Caj in toc rʌc ts'aj ti' C'uj.” Quire' mʌ' caj a quibex u t'ʌn C'uj a cu ya'aric: “Ca' a sʌjtex a tet yejer a nʌ'.” Ca chen qui' cʌnantiquex u t'ʌn a nunquirex. ");
INSERT INTO lacNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Caj ya'araj Jesús ti' u winiquirob judío a fariseobo': ―Irechex wa ca'tur a tucurex, quire' taj caj u camsa techex Isaías uch. Caj u ts'ibtajechex uch: ");
INSERT INTO lacNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","A je' maca', quij Isaías. Cu tusaricob: “Quin sʌjticob C'uj”, chen a tu pixamo' cu ya'aricob: “Mʌ' in sʌjtic C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Caj u ts'ibtaj Isaías uch: A C'ujo' cu ya'aric: “Ba'wir cu chen c'ujintiquenob wa mʌ' u quibicob in t'ʌn? Mʌ' ja wirej, chen u t'ʌn winiquir cu quibicob quire' raji'ob cu camsicob u t'ʌn winic irej wa ju t'ʌn C'uj cu camsicob.” Baxuc caj u ts'ibtaj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesús caj u pʌyaj mac a pimo'. Caj ya'araj Jesús ti' a mac caj u much'quintob u bʌj: ―U'yex ba' quin wa'aric techex ca' a cʌnex. ");
INSERT INTO lacNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A mac a cu yubic u si'pir, ra' mʌ' u yacsic u si'pir quire' a ba' caj u jantaj. Ra' cu yacsic tu si'pir u t'ʌn a cu joc'ar tu chi', a c'aso'. ");
INSERT INTO lacNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","U camsʌwinicob Jesús caj u juts'ob u bʌj ich Jesús. Caj ara'b ti' Jesús ten u camsʌwinicob: ―A ba' caj a wa'araj ti'ob sam, caj a choquintaj u yorob u winiquirob judío a fariseojo'. Mʌ' wa ta wu'yaj ―quij u camsʌwinicob? ");
INSERT INTO lacNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Caj ya'araj Jesús ti' u camsʌwinicob: ―U t'ʌn C'uj mʌ' u ch'eja'r. A cu tus camsicob cu ya'aricob u t'ʌn C'uj cu tsec'ticob. Ra' cu bin ch'eja'r ten ic Tet C'uj ca'anan. Irej a mac a cu joc'sic u che'er yejer u mo'os. ");
INSERT INTO lacNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Caj ya'araj Jesús ti' u camsʌwinicob: ―Tsire'ej u tucurob u winiquirob judío a fariseojo'. Irob mʌna' u wichob a fariseojo'. A mac a cu pʌyic u jer ch'op u wich tu cu bin rubur tu ch'ica'anin ru'um. Mʌ' ja wirej, tu cu binob erar ich c'ac'. Mʌ' ja wirej, cu yubic u t'ʌn a fariseojo'. ");
INSERT INTO lacNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro caj tarij ich Jesús. Caj c'ata'b ti' Jesús ten Pedro: ―Ba' quire' u c'at ya'aric a caj a camsaj u winiquirob judío a fariseojo'. A caj a wa'araj ti': “Cax mʌ' ju p'o'ic u c'ʌb cu janʌn.” ");
INSERT INTO lacNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Caj ya'araj Jesús ti' Pedro: ―Mʌ' wa ja najtex irechex u winiquirob judío a fariseojo' xan? ");
INSERT INTO lacNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ara'b ti' Pedro ten Jesús: ―A ca jantic a wo'ocho', cu bin ta chocher, ca ta'ic. ");
INSERT INTO lacNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mʌ' ja wirej, ti' u tar cu joc'ar a t'ʌn ta chi'. A c'aso', ti' u tar ti' u tucur mac. Quire' c'as rajen cu pʌyic u si'pir. Mʌ' quir u janʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Quire' a c'as ca tucric ti' cu yʌnxchun tu tucur mac, quire' cu tucric u quinsic mac. Quire' a mac a cu man, ti' cu tar a cu tucric. Quire' cax mʌna' u mam cu tucric u man, ti' cu tar cu joc'ar tu tucur. Baxuc xib xan, cu tucric u man cax mʌna' u rac'. Ti' cu tar u joc'ar tu tucur. A cu ch'ic u ba'tʌc mac, ti' cu tar u joc'ar tu tucur. Quire' a cu tus, ti' u tar u joc'ar tu tucur. Quire' a cu pac'ʌr u pach u rac'ob, ti' u tar u joc'ar tu tucur. ");
INSERT INTO lacNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A ray u si'piro' cu casquintic mac. Quire' a ba' cu janʌn mac cax rajra' cu janʌn mʌ' u pʌyic u si'pir mac. ");
INSERT INTO lacNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ruc' Jesús tu cajar tuj tar c'atbir ten u winiquirob judío a fariseojo' ti' Jesús: ―Biquinin mʌ' u p'o'icob u c'ʌbob a camsʌwinicob cu janʌnob? Caj joc' Jesús tar cu bin tu ru'um bʌytʌc tu yʌn u cajar Tiro yejer u cajar Sidón. ");
INSERT INTO lacNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Caj tar xquic. Ti' u tar xquic u ru'umin cananea. Caj tar cʌjtar ich u ru'umin Tiro yejer u cajar Sidón. Caj tar ich Jesús caj u c'am t'ʌntaj: ―Jaj Ts'urir ―quij―, quire' u pararech a nunquir David. Yajquinte ten yejer in chan parar xquic. Aca'an quisin ti', jach yaj. ");
INSERT INTO lacNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Barej Jesús mʌ' ju nuncaji'. Caj tarob u camsʌwinicob Jesús caj u chich c'atajob ti' Jesús: ―Cu jach chich t'ʌniquenob a xquico'. ");
INSERT INTO lacNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Caj ya'araj Jesús: ―Mʌ' ya'araj in bin C'uj, chen tu satʌr u winiquirob judío. Quin bin in tsec'tej ti'ob quire' C'uj cu yiric irob tʌmʌn yuc a satʌro'. ");
INSERT INTO lacNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Caj u juts'aj u bʌj xquic ich Jesús caj xonrʌj. Caj ya'araj: ―Jaj Ts'urir, chan yam ten. ");
INSERT INTO lacNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Caj ya'araj Jesús ti' xquic: ―Mʌ' tsoy in ts'ic tech a ba' caj u ts'aja C'uj ti' u winiquirob judío. Mʌ' quir in yamtiquech. Mʌ' u winiquir judíojech. Quire' mʌ' tsoy u ts'abʌr tech a ts'aja'an ti' u winiquirob judío irej wa tan u taquic u yoch u parar quir u ts'ic ti' pec'. ");
INSERT INTO lacNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Caj ya'araj a xquic: ―Jach jaj, Jaj Ts'ur, a ba' ca wa'aric. A pec'o' cu chuquic u jantej u p'up'ir yo'och u winiquirir wa cu potar ich yaran pojche'. Rajen quin c'atic tech ca' a yam ten cax chichin. ");
INSERT INTO lacNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús caj u nuncaj ti' xquic: ―Taj caj a qui' acsaj ta wor ten xquic. Ca' joc'ac u quisinin a chan parar xquic. A ta chich c'ata ten. Sep caj jaw u chan parar xquic. ");
INSERT INTO lacNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Caj joc' Jesús tu caj u jawsaj u parar chan xquic aca'an quisin ti'. Caj manij chi'c'ac'nab. U c'aba' u c'ac'nabir Galilea. Caj nac Jesús ich u jo'r p'uc wits caj curaj. ");
INSERT INTO lacNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Caj c'uchij a pimo' tu yʌn Jesús. Caj tar purbir mech yoc. Caj tar purbir xan ch'op u wich. Caj tar purbir xan mʌ' u joc'ar u t'ʌn. Caj tar purbir mech u c'ʌb xan. Baxuc u yajirir ya'ab, caj tar purbir ich Jesús. Caj tar chaquinbir ich yoc Jesús. Caj jawsa'b ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Caj yirob a pimo' jawsa'b a mʌ' u joc'ar u t'ʌn, caj joc' u t'ʌn. Caj yirob a pim caj jaw u yac'bir u wich, caj u qui' iraj u ber. Caj yirob u rʌc jawʌr mech yoc, caj yirob u ximbar. Caj yirob u jawʌr mech u c'ʌb, caj tsoyij u c'ʌb. Caj jaq'uij yorob a pimo'. Caj ya'arab ti' C'uj: ―Jach caremech C'uj u C'ujirech u winiquirob israel. ");
INSERT INTO lacNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Caj u pʌyaj u camsʌwinicob Jesús caj ya'araj ti' u camsʌwinicob: ―In c'at in yajquinticob ti' a pimo', quire' wi'ichʌjob. Quire' mʌna' u nup u q'uinin ti' yʌnob tu yʌnen. Mʌna' yo'och, mʌ' ba' cu janticob. Mʌ' jin c'at in tuchi'ta'r ich yatochob, quire' mʌna' ba' cu janticob. Quire' mʌ' ju c'uchurob ich bej, quire' wi'ij. ");
INSERT INTO lacNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Caj ya'araj u camsʌwinicob: ―Bic tabar ij quirej ij co'och quire' jach pim? Quire' mʌna' mac cʌja'an tera' quir ic mʌnic yo'och. ");
INSERT INTO lacNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús caj u c'ataj ti' u camsʌwinicob: ―Mun yʌn techex a wo'ochex pan? Caj u nuncajob: ―Yʌn siete pan. Mʌ' ya'ab cʌy yʌn ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Caj ara'b u cutarob a pimo' ten Jesús ich ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Caj ts'a'b ti' Jesús ten u camsʌwinicob. Siete pan caj ts'a'b ti' Jesús. Ts'a'b ti' cʌy Jesús. Caj u t'ʌnaj C'uj Jesús: ―Bayo' C'uj caj a ts'aj to'on ij co'och. Caj ts'oc u t'ʌnic C'uj, caj u ts'aja ti' u camsʌwinicob Jesús. Caj u rʌc jʌsajob ich a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Caj jantob caj rʌc najchʌjob. Caj xur u janticob ti' rʌc p'at u xet'er. Caj u marob u xet'er caj chup siete xac. ");
INSERT INTO lacNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yʌn cuatro mil xib caj janob. Mʌ' tu xacob mun a xquic caj janʌnob. Mʌ' xaca'an u parar xan. ");
INSERT INTO lacNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Caj ts'oc u janʌnob caj ya'araj ti'ob a pim ca' xicob. Caj oc Jesús ich chem caj bin tu ru'umin Magdala. ");
INSERT INTO lacNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","U winiquirob judío a fariseojo' yejer u winiquirob judío a saduceobo', caj binob irbir Jesús quir yubicob u t'ʌn Jesús. Soc c'ucha'an yorob u chucur Jesús. Rajen caj u tus c'atajob ti' u carem beyaj a cu tar ich C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús caj u nuncaj ti'ob: ―A techexo', ca wa'ariquex: “Mʌ' ju tar ya'arir oq'uin quire' chʌc u muyarir.” ");
INSERT INTO lacNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A techexo', ca wa'ariquex cu sastar je' u tar ya'arir a mʌ' ac'bir u muyarir yejer chʌc. A techexo', jach c'asechex. Ca wa'ariquex c'ucha'an a worex a wa'ariquex mʌ' ju tar ya'arir. A techexo', c'ucha'an a worex a wa'ariquex: Je' u tar ya'arire'. Chen aro' c'ucha'an a worex a najtiquex ti'. Chen mʌ' ju c'uchur a worex a najtex u carem beyaj a beta'b ten C'uj tu q'uinin baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Caj ya'araj Jesús ti'ob u winiquirob judío a fariseojo' yejer u winiquirob judío a saduceobo': ―Techex a mac a cuxa'an tu q'uinin baje'rer ca c'atiquex carem beyaj quire' jach c'asechex. Quire' mʌ' taj caj a c'ujintex C'uj. Chen ca binex a wirex in riq'uir mʌna' u nup u q'uinin. Iren Jonás caj wʌc'ʌs xeja Jonás ten cʌy quire' C'uj. Ra' u carem beyaj bin a ca' a wirex. Caj bin Jesús nach, caj p'at u winiquirob judío a fariseojo' yejer u winiquirob judío a saduceobo'. ");
INSERT INTO lacNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Caj bin u camsʌwinicob Jesús pʌchi c'ac'nab. Caj tubi ti'ob u ch'icob yo'och pan u jantejob. ");
INSERT INTO lacNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Caj ya'araj Jesús ti' u camsʌwinicob: ―Qui' cʌnantex a bʌj ti' a ba' ca cʌniquex ti' u winiquirob judío a fariseojo' yejer u winiquirob judío a saduceobo'. Quire' ba' cu beticob irej u ts'ac pan cu sip. ");
INSERT INTO lacNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Quire' cu tsicbarob u camsʌwinicob ich u rac'ob: ―Rajen ―quij ya'aric to'on ij cʌjcamsʌyʌjir― quire' caj u yiraj mʌ' ic ch'a'ic ij co'och pan. ");
INSERT INTO lacNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús caj yubaj a ba' cu muc u aricob u camsʌwinicob. Caj ya'araj: ―Biquinin ca wa'ariquex: “Mʌna' a wochex pan.” Chichin a wacsamʌnex ta worex. Quire' Jesús yer caj u tucrajob mʌ' tu ch'ajob yo'och pan. Chen tar p'ato'. ");
INSERT INTO lacNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Caj ya'araj Jesús: ―Mʌ' wa ta najtajex? Mʌ' wa c'aj techex? Yʌn to'on cinco pan ca'ch caj in rʌc jʌsaj ti' cinco mil xib. Mʌ' wa c'aj techex mun xac cax chup a ta marex? Mʌ' ja wirej, u carem beyaj caj a wirajex? ");
INSERT INTO lacNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mʌ' wa c'aj techex a yʌn siete pan caj in rʌc jʌsaj ti' cuatro mil xib. Mʌ' wa c'aj techex mun xac caj ic rʌc maraj. Mʌ' ja wirej, u carem beyaj caj a wirajex? ");
INSERT INTO lacNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Caj ya'araj Jesús ti' u camsʌwinicob: ―Biquinin mʌ' a qui' najtajex? Mʌ' raji' quin wac techex a wo'ochex pan. Caj in wa'araj techex, qui' cʌnantex a bʌj ti' a ts'ac a cu sip yo'och pan u winiquirob judío a fariseojo' yejer u winiquirob judío a saduceojo'. ");
INSERT INTO lacNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Caj u najtajob u camsʌwinic Jesús: “A ba' caj u ya'araj Jesús, mʌ' raji' cu yac to'on. Tu camsa to'on an ten bic cu sip yo'och pan, a ba' cu camsico'on u winiquirob judío a fariseojo' yejer u winiquirob judío a saduceojo'. Qui' cʌnantex a bʌj ti' a ba' cu camsiquech u winiquirob judío a fariseojo' yejer u winiquirob judío a saduceojo'.” ");
INSERT INTO lacNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Caj c'uchij Jesús bʌytʌc ich u cajar Cesarea de Filipo. Caj u c'ataj ti' u camsʌwinicob: ―Mac cu ya'ariquenob ―quij Jesús― a pimo' u pararen C'uj quire' taren in yamtic mac tu cotor? ");
INSERT INTO lacNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Caj ya'arajob: ―Mʌ' ya'ab tij cu'yaj u juminticob caj u pʌchechob: “Juanech, a cu yacsic ja' tu jo'r mac.” U jer caj ya'arob: “Elíasech.” Ti' yʌn xan cu ya'aric: “Jeremíasech.” U jer cu ya'aric: “U jerech yʌjtseq'uirech u t'ʌn C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Caj ya'araj Jesús ti'ob: ―A techexo', a mac ca wa'ariquex ten? ");
INSERT INTO lacNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Caj ya'araj Simón Pedro ti' Jesús: ―A techo', Cristojech, a mac tuchi'ta'b ten C'uj. U pararech C'uj. A C'ujo' cuxa'an. ");
INSERT INTO lacNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús caj u nuncaj ti': ―Qui'quintej a wor Simón, ra' a tet Jonás. C'uj caj u ts'aj a najtej wa Cristojen. Mʌna' mac caj u ts'aj a najtej tech. Chen ic Tet a ti' yʌn ca'anan raji' caj u ts'aj a najtej. ");
INSERT INTO lacNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A teno' quin wa'aric tech Pedrojech. U c'at ya'aric a c'aba' Tunichech. Quire' mʌ' u c'ax a tucur toc taj ca tucric jach Cristojen. Mʌ' ju c'uchur u yor ten quisin u taquiquech ti' ten quire' ca jach c'ujintiquen Cristo. ");
INSERT INTO lacNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Caj ya'araj Jesús ti' Pedro: ―A teno' quin wacsiquech u ts'urirech a rac'ob quire' in muc' cu bin ts'abir tech. A ba' cu beticob a rac'ob wa tsoy ta t'ʌn tech, bayiri' tsoy tu t'ʌn C'uj. Wa mʌ' tsoy cu beticob a rac'ob quire' mʌ' tsoy ta t'ʌn, tech bayiri' ti' C'uj xan. ");
INSERT INTO lacNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Caj u chich araj Jesús ti' u camsʌwinicob: ―Mʌ' a yʌn bin a wa'arex wa Cristojen. ");
INSERT INTO lacNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ra' u q'uinin Jesús caj u yʌnxchun u camsic u camsʌwinicob. Ti' cu bin u muc'yaj Jesús ich u cajar Jerusalén quire' u jach ts'urirob sacerdote. Bayiri' xan ti' yʌjcamsʌyʌjirob u t'ʌn Moisés. Bayiri' ti' u jach ts'urir u cajarob u winiquirob judío. Bin u ca' quinsbir Jesús ich u cajar Jerusalén. Ya'araj ca' bin riq'uir tu quimirir: “Ca' bin manac mʌna' u nup u q'uinin quin ca' riq'uir” ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro caj mach u c'ʌb Jesús caj bin Pedro yejer Jesús tu junan quir u tsicbar. Caj ya'araj Pedro: ―In c'at C'uj ca' u yamtech Jaj Ts'ur soc mʌ' a muc'yaj soc mʌ' a quinsa'. ");
INSERT INTO lacNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chen Jesús caj p'us u pach ti' Pedro. Mʌ' ju c'at yubic Jesús ya'aric Pedro: “Mʌ' a yʌn quinsa'r.” Caj ya'araj Jesús: ―Joq'uen Pedro, irech quisin Satanás ―quij Jesús―. Mʌ' a p'usic in wor ―quij Jesús―. Mʌ' quet a wor yejer C'uj, quet a wor yejer xib Pedro. ");
INSERT INTO lacNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Caj ya'araj Jesús ti' u camsʌwinicob: ―An ten bic ten ca' bin muc'yajnʌquen ich cruz. Baxuc techex, ca' bin mucyajnʌquechex quire' caj a c'amex in t'ʌn, cax ca bin a quimechex ich cruz. Baxuc xan, ca' a p'ʌtiquex a ba' ca pachtiquex ta worex wa ja c'atex a cʌniquex in t'ʌn ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Quire' a mac mʌ' u c'at u taquic u cuxtar ti' u rac'ob tu cu chucur u pach ten u rac'ob, quire' caj u yacsaj tu yor ti' in t'ʌn. Chen ra' cu bin taquic u pixam. Chen a mac u c'at u taquic u cuxtar ti' u rac'ob tu cu chucur u pach ten u rac'ob. Je' u satʌr u pixame', quire' mʌ' ju c'at u c'ʌmic in t'ʌn quir u cuxtar munt q'uin ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Cax chen toc rʌc yʌn a ba' yʌn te' ich yoc'ocab. Chen u pixam je' u satʌre'. Rajen mʌ' ba'wir ti' u ba'tʌc ich yoc'ocab. Mʌ' biq'uin c'ucha'an yor u bo'otej u pixam. ");
INSERT INTO lacNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jesús caj ya'araj ti' u camsʌwinicob: ―Ca' bin taquen yejerob yʌjmasirob u t'ʌn C'uj. Yejer u sasir C'uj ca' bin taquen. Jujuntur quin bin in bo'otej, a tu jach c'ʌmajob in t'ʌn an ten bic caj man tu tsoyir C'uj. Quire' taren in yamtic mac tu cotor. ");
INSERT INTO lacNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Caj ya'araj Jesús: ―Taj quin wa'aric techex. Yʌn mac mʌ' ya'ab tera' mʌ' ju quimin hasta yiric in tar ich yoc'ocab quir a reyintiquex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ti' yʌn uch Jesús ich u cajar Cesarea de Filipo tu caj u camsej ti'ob u camsʌwinicob. Caj manij seis u q'uinin Jesús caj u pʌyaj Pedro yejer Juan yejer Jacobo. U bʌjob Jacobo, Juan. Caj binob ich u jo'r wits tu ca'anan u jo'r wits. Caj binij Jesús yejer u camsʌwinicob mʌ' ya'ab. Mʌna' u nup. ");
INSERT INTO lacNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ʌcʌtan u camsʌwinicob caj waysa'b Jesús. Caj waysa'b u sasirir u wich Jesús, irej u sasirir ic yum q'uin. Baxuc u jach cha'aj u noc', irej u sasirir ic yum. ");
INSERT INTO lacNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Seb caj irir ix ba' Moisés yejer ix ba' Elías ten u camsʌwinicob. Caj tsicbanʌjob yejer Jesús, caj ir ten u camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro caj u t'ʌnaj Jesús: ―Jaj Ts'urir ―quij―. Jach tsoy te' yʌno'ona' tera'. Arej in chan tʌsej paser. U tiriri' tech. U tiriri' ti' Moisés. U turiri' ti' Elías. ");
INSERT INTO lacNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Caj u yub u t'ʌn C'uj Pedro ca'anan. Caj yiraj u tar u muyarir, jach sʌc t'ina'an, rʌc bʌcrista'b tu cotor. Caj yubaj u t'ʌn ich u muyarir. Caj yubaj ya'aric Pedro: ―A je' in jach parar, in jach yaj. Jach qui' in wor. Ca' a u'yex u t'ʌn. Ti' toy cu t'ʌn Pedro yejer Jesús caj yir u tar u muyarir. ");
INSERT INTO lacNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Caj ts'oc yubic u t'ʌn ich u muyarir u camsʌwinicob Jesús, caj rʌc nacrʌjob ich ru'um. Jach jaq'uij yorob. ");
INSERT INTO lacNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús caj u juts' u bʌj ichob u camsʌwinicob. Caj u tʌraj ti'ob soc yerob ti' yʌn Jesús. Caj ya'araj ti'ob: ―Riq'uenex mʌ' a ch'ic sajaq'uirex. ");
INSERT INTO lacNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Caj ric'ob u camsʌwinicob Jesús caj yirob mʌna' ix ba' Moisés, bayiri' ix ba' Elías. Mʌna' mac chen Jesús tu junan. ");
INSERT INTO lacNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cu yemenob ich u jo'r p'uc wits. Jesús caj u toc t'ʌnaj u camsʌwinicob soc mʌ' ya'aricob wa yirob ix ba' Moisés yejer ix ba' Elías, cax a ba' yubmʌnob xan, hasta in ca' riq'uir ca' bin quimiquen, a teno' a mac tar u yamtic mac tu cotor. Jeroj arex a ba' caj a wirex. ");
INSERT INTO lacNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Caj u c'atajob u camsʌwinicob ti' Jesús: ―Quire' tech caj a wa'araj to'on. Mʌ' a yʌn bin a wa'arex wa caj in wirob ix ba' Elías yejer ix ba' Moisés. Biquinin cu ya'aric yʌjcamsʌyʌjirob u t'ʌn Moisés: “Raji' cu yʌn bin tar ix ba' Elías, pachir cu tar a Cristojo”? ");
INSERT INTO lacNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Caj u nuncaj ti'ob Jesús: ―Taj ―quij Jesús―. Ix ba' Elías cu yʌn bin tar uch quir u pʌyic u ber Cristo soc u c'axicob yorob, soc u rʌc p'ʌticob c'as u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A teno', ―quij Jesús―, quin wa'aric techex, toc tarij Elías chen mʌ' u c'ʌ'otajob Elías. Mʌ' tu yacsajob ti', caj quinsa'b ti', quire' baxuc u c'atob a mac caj u chucajob ti'. Baxuc a teno' ―quij Jesús―, quin bin in muc'yaj ca' bin u chuquenob xan. ");
INSERT INTO lacNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","U camsʌwinicob caj yubob ba' ya'araj Jesús caj u jach najtajob raji' Juan cu tsicbʌtic Jesús. Ra' Juan a cu yacsic ja' tu jo'r mac. ");
INSERT INTO lacNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Caj urob Jesús ich u jo'r ca'anan wits. Caj c'uchij tu yʌnob a pimo'. Caj u juts u bʌj turi' xib ich tu yʌn Jesús. Caj xonrʌj ʌcʌtan ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Caj ya'araj: ―Jaj Ts'urir ―quij―. Ca' yajquintej in parar. Yamtej ti', cu sʌj quimin. Tiri' cu rʌc rubur ich ja'. Cu jach muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Caj tar in puric ich a camsʌwinicob mʌ' tu jawsajobi'. A camsʌwinicob, mʌ' c'ucha'an yorob u jawsej. ");
INSERT INTO lacNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Caj ya'araj Jesús ti': ―A techexo', a mac cuxa'an tu q'uinin baje'rer, mʌ' ca wacsiquex ta worex. Mʌ' ca quibiquex in t'ʌn. Mʌ' ya'ab u q'uinin ti' yʌnen tu yʌnechex. Arex mun u q'uinin quin muc'tic techex quire' mʌ' a quibex in t'ʌn. Arex ca' tac purbir chan xib tera'. ");
INSERT INTO lacNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús caj u joc'saj c'ac'as quisin. Caj u q'ueyaj. Ra'iri' u q'uinin caj toc jaw chan xib. ");
INSERT INTO lacNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Caj tarob u camsʌwinicob yicnʌn Jesús caj tsicbanʌjob yejer Jesús, quire' rʌc binob a pimo'. Caj c'ata'bi ti': ―Biquinin a tenobe' mʌ' c'ucha'an in worob in joc'sicob quisin? ");
INSERT INTO lacNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Caj ya'araj Jesús ti'ob. ―Mʌ' ca wacsiquex ta worex, rajen mʌ' c'ucha'an a worex a joc'sex. Taj quin wa'ariquex tech, an ten bic yijir u wich mostaza. Mʌ' ja wirej, jach mijin. Wa bayiri' ca wacsiquex ta worex, cax an ten bic mijin u yijir mostaza, cax a ba' cu tar techex c'ucha'an a worex ti'. C'ucha'an a worex ti' tu cotor ba' wa ca wacsiquex ta worex ti' ten. ");
INSERT INTO lacNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","A je' quisin caj in joc'sajo' juntur quisin. Chen a techexo' ca' a t'ʌnex C'uj. Bayiri' ca' a p'ʌtex a janʌnex soc c'ucha'an a worex a joc'siquex. ");
INSERT INTO lacNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ti' cu manob Jesús yejer u camsʌwinicob ich u ru'umin Galilea. Jesús caj ya'araj: ");
INSERT INTO lacNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","―A teno' bin in ca' quinsbir. Cu yʌn tarob u chuquiquenob mac quir in quinsa'. Ca' bin mʌnac mʌna' u nup u q'uinin je' in ca' riq'uire'. Caj yubob ya'aric Jesús caj jach tucra'b Jesús ten u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Caj c'uchob Jesús yejerob u camsʌwinicob ich u cajar Capernaum. Caj tar yʌjc'ʌmin u taq'uin tu cu naj c'ujinticob C'uj u winiquirob judío. Caj bin ich Pedro caj c'ata'b ti' Pedro: ―Cu bo'otic wa ja wʌjcamsʌyʌjir tu cu yocar ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío? ");
INSERT INTO lacNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Caj nuncaj Pedro: ―Cu bo'otic u bo'orir tu cu yocar. Caj ts'oc u ya'aric aro', caj oc ich yatoch tu yʌn Jesús. Caj u yʌn t'ʌnaj Pedro, Jesús. Caj c'ata'b ti' Pedro ten Jesús: ―Ba' ca tucric tech Pedro. A mac a cu tar nach yʌn u c'atic u bo'orir ten gobierno. A mac a tiri' cʌja'an mʌ' u c'ata'r u bo'orir? ");
INSERT INTO lacNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Caj ya'araj Pedro: ―Ra' cu c'atic u bo'orir a mac nach u tar. Caj ya'araj Jesús: ―Rajen cax mʌ' in bo'otic tu cu yocar u naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Caj ara'b ten Jesús ti' Pedro: ―Soc mʌ' u pʌq'uicob in pach soc mʌ' ya'aric caj in p'astaj carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Joq'uen xen ich chi'c'ac'nab joq'uen rutsej cʌy. A ca yʌn rutsique' jʌp u chi' a wirej wa yʌn u taq'uin. Ra' soc quir a bo'otic quir ij cocar carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Joq'uen a bo'otej ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ra' u q'uinin caj tsicbanʌj Jesús yejer Pedro caj u juts'ob u bʌj u camsʌwinicob ich Jesús. Caj c'ata'b ti' Jesús ten u camsʌwinicob: ―Arej to'on a mac jach carem tu cu bin u reyinticob C'uj? ");
INSERT INTO lacNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús caj u pʌyaj u chan parar mac. Caj u pʌyaj ch'ictar chumuc tu yʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Caj ya'araj Jesús: ―Jach taj quin wa'aric techex. Ca' a c'axex a worex soc a cʌniquex chichan quire' cu quibic u t'ʌn mac. Wa ja c'atex a wocarex tu cu bin u reyinticob C'uj ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Rajen a mac a cu cʌnic a chichano' quire' cu quibic u t'ʌn mac ca' bin c'uchuc tu q'uinin u reyintic C'uj ra' jach manan carem. ");
INSERT INTO lacNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A mac cu yacsic mac a caj u cʌnaj chichan, quire' raji' caj u yacsaj tu yor ti' ten bayiri' cu yacsiquen xan. ");
INSERT INTO lacNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Caj ya'araj Jesús ti' u camsʌwinicob: ―A mac a cu yacsic u si'pir u rac'ob, a caj u cʌnaj chichan, a caj u yacsaj tu yor. Arej jach manan tsoy ca' u jich'ej ich u car yejer yajaw ca'. Ca' u purej u bʌj ich c'ac'nab quire' caj u pʌyaj u si'pir u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","A mac cu jach c'asquintic mac ich tu cotor yoc'ocab jach yaj cu bin yubic yerar a je' xibo'. Yʌn u tar u jer mac quir u c'asquintic u rac'ob. Rajra' yʌn u tar quir u c'asquintic mac jach manan c'as aro'. ");
INSERT INTO lacNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Rajen quin wac techex: Xonch'ʌctej a c'ʌb wa raji' cu yacsic a si'pir. Cax a woc wa raji' cu yacsic a si'pir. Cax bujuch c'ʌbech, cax bujuch oquech soc a taquic a bʌj. Soc mʌ' a bin tu ca werar ich c'ac' munt q'uin yejer ca'tur a c'ʌb. Bayiri' soc mʌ' a werar yejer ca'tur a woc. ");
INSERT INTO lacNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Baxuc xan a wich. Wa raji' cu pʌyic a si'pir rʌc a wich. Cax bujuch ichech soc mʌ' a bin erar ich c'ac'. Soc a taquic a bʌj wa yejer ca'tur a wich ca bin tu ca werar. ");
INSERT INTO lacNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Caj ya'araj Jesús ti': ―Mʌ' a yʌn che'tic a chichan a caj u yacsaj tu yor ten, a ti' yʌn ich yoc'ocab, a irob a je' chichana'. Quire' ti' yʌn u yʌjmasirob u t'ʌn C'uj ti' chichan ʌcʌtan ti' C'uj ca'anan. Raji'ob cʌnanticob yʌjmasirob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Caj ya'araj Jesús: ―Taren in yamtic mac tu cotor ich yoc'ocab a mac satʌr quir u jawsic u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Qui' tucrex a ba' quin bin in camsic techex. Mʌ' wa ti' yʌn xib yʌjcʌnʌnyʌjir cien tʌmʌn yuc. Caj satij turiri' je' u bin u cʌxtej a turiri' sa'at. Cu jamach p'ʌtic yʌrʌc' tʌmʌn yuc a noventa y nueve a ti' yʌnob ich u jo'r wits, ca' xic u cʌxtej turiri'. ");
INSERT INTO lacNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wa cu yiric yʌrʌc' tʌmʌn yuc a turiri' taj quin wa'aric jach qui' yor. Cax ti' yʌn a noventa y nueve a mʌ' sa'atʌrob. Mʌ' qui' yor hasta cu yiric a turiri', a ra' u q'uinino' cu jach qui' tar yor. ");
INSERT INTO lacNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Caj ya'araj Jesús: ―Rajen baxuc ic Tet C'uj. Mʌ' u c'at yiric u satʌr a chichan turiri' a mac a cu yacsic tu yor ti' ten, a ca wiriquex bʌytʌc tu yʌnechex. ");
INSERT INTO lacNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Caj ya'araj Jesús ti' u camsʌwinicob: ―Wa ja wet acsa'orir c'as cu yac techex. Cax wa ba' cu betic techex. Tu junan ca wa'ariquex ti' wa ba' cu ya'aric techex. Wa caj u quibaj a t'ʌn a wet acsa'orir, p'eri' a wor yejer. Mʌ' ja wirej, caj u yac'taj u bʌj tu si'pir caj u pʌyaj. Caj a tacaj soc mʌ' u ts'ictar ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wa mʌ' u quibic a t'ʌn a wet acsa'orir, joq'uen pʌyej turiri' wa ca'tur. Ca' a pʌyej soc yubic a wet acsa'orir yʌn u si'pir yet acsa'orir. Soc yiric wa c'ucha'an yor u p'eri'quinticob yor. Soc mʌna' u nup yubic yʌn u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wa mʌ' u yubiquex a t'ʌnex a wet acsa'orir, ca' a rʌc arex yubejob tu cotor u ts'urir a wet acsa'orir tu ca much'quintiquex a bʌj. Wa mʌ' yubic u t'ʌn tu cotor u ts'urir yet acsa'orir. Mʌ' ja t'ʌniquex an ten bic mac mʌ' yer C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jach taj quin wa'ariquechex: ―A ba' quir mʌ' a c'atex tu ca much'quintiquex a bʌj ich yoc'ocab, baxuc xan, a C'ujo' mʌ' u c'at. A ba' quir tsoy techex tu ca much'quintiquex a bʌj, baxuc a C'ujo', tsoy yiric C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Taj quin wa'aric techex. Cax wa chan ca'turechex yejer a wet acsa'orir te' ich yoc'ocab. Je' u ts'ic techex ic Tet C'uj a ba' a c'at wa quet a worex. ");
INSERT INTO lacNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Cax wa mʌna' u nup cu tar u much'quinticob u bʌj ti' yʌnen ―quij Jesús―. Cax wa ca'tur quir u c'ujinticob C'uj cu bin ts'abir ten C'uj ti' techex a ba' ca c'atiquex ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Caj tar Pedro ich Jesús caj u c'ataj ti': ―Wa cu tar in bʌjob, Jaj Ts'ur. Ya'arej ca' in jawsej u si'pir wa ba' caj u ya'araj. Arej ten mun ca' bin in jawsej u si'pir. Ya'ab u tenin, cax wa siete quin jawsic u si'pir? ");
INSERT INTO lacNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Caj u nuncaj Jesús: ―Mʌ' jin wa'arej a jawsej siete, cax ya'ab u tenin u tar cax setenta. ");
INSERT INTO lacNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Rajen caj ya'araj Jesús tu cu camsicob: ―U ru'umin tu cu bin u reyinticob C'uj ca'anan irej a rey a cu bin u c'atic u bo'orir ti' u c'urew, a mac yʌn u bo'or. ");
INSERT INTO lacNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Caj u yʌnxchun yiric yʌn u bo'or u c'urew ti' u rey. Caj tar purbir ti' rey u c'urew quire' raji' yʌn u bo'or ya'ab. Jaj ix tʌcoj cuatro millones pesos. ");
INSERT INTO lacNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","U c'urew mʌ' c'ucha'an yor u bo'otic u rey. Caj u toc araj rey: “Ar u rʌc cʌnej u ba'tac. Bayiri' u rac', ca' u canej yejer u parar ca' u canej. A ba' yʌne', ca' u rʌc canej quir u bo'otic rey.” ");
INSERT INTO lacNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Caj xonrʌj u c'urew ʌcʌtan u rey. Caj ya'araj ti': “Ca' a yajquin ten, Jaj Ts'ur. Sisquintej a wor ten. Je' in rʌc bo'otiquech.” ");
INSERT INTO lacNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Caj sisij yor rey, caj u yajquintaj ti' u c'urew. Caj ya'araj ti' u c'urew: “Tsire'ej cax mʌ' a bo'otic.” Caj ya'araj u rey: “Siptej in c'urew ca' xic.” ");
INSERT INTO lacNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ra'iri' u c'urew tan tu joc'ar ich rey caj u nup'ob u bʌj u yet c'urewir a mac yʌn u bo'or ti' yet c'urewir. Mʌ' neco'oj u bo'or ten u yet c'urewir. Yʌn ix tʌcoj cuatro pesos. Caj chuc yʌt'bir u c'o'och ten yet c'urewir. Caj ya'araj: “Bo'oten.” ");
INSERT INTO lacNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Caj xonraj u yet c'urewir ʌcʌtan Caj u chich araj: “Yajquinten. Je' in rʌc bo'otiquech tu cotor.” ");
INSERT INTO lacNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Jot” ―quij―. Caj u c'ubaj u yet c'urewir a mʌ' ya'ab u bo'or ca' xic mʌcbir hasta cu bo'otic u bo'or ti' u yet c'urewir. ");
INSERT INTO lacNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","U yet c'urewir ya'ab, caj yajij yorob a ba' caj u yirob caj binob ich rey ya'arajob ti' ba' u ber. ");
INSERT INTO lacNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Caj u pʌyaj u c'urew rey. Caj c'uchij u c'urew tu yʌn rey. Caj ya'araj ti' u c'urew: “Jach c'asech, a teno' caj in wa'araj mʌ' a bo'otej a bo'or quire' caj a chich c'ataj ten. ");
INSERT INTO lacNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Biquinin mʌ' ja yajquintaj a wet c'urewir an ten biquen caj in yajquin tech?” ");
INSERT INTO lacNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A ju rey caj jach ts'iquij. Caj u c'ubaj u c'urew xan, ca' ma'cac hasta cu rʌc bo'otic u bo'or. ");
INSERT INTO lacNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús quir u ts'ocar u camsic bic tabar u jawsic u si'pir mac caj ya'araj: ―Baxuc in Tet xan a tar yʌn ich ca'anan. Mʌ' ju jawsic techex C'uj wa mʌ' a jawsic u si'pir a wet acsa'orir je'erer, mʌ' u jawsej. ");
INSERT INTO lacNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Caj ts'oc ya'aric Jesús bic tabar u jawsic u yet acsa'orir caj u p'ataj u ru'umin Galilea. Caj c'uchij tu ru'umin Judea caj ca' bin pʌchir ya'arir Jordán tu cu tar ic yum. ");
INSERT INTO lacNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jach pim caj sayob tu pach Jesús caj bin pʌchir ya'arir Jordán caj jawsa'b u yajir. ");
INSERT INTO lacNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Caj tar c'atbir ti' Jesús ten jun yarob u winiquirob judío a fariseojo'. Caj u juts'ajob u bʌj ich Jesús quir u tumta'rob yor Jesús. Caj tus c'atob ti': ―Tsoy wa ju p'ʌtic u rac' cax a ba' quiri'? ");
INSERT INTO lacNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Caj u nuncaj: ―Mʌ' wa ja xacmʌnex tu ts'iba'an: “A C'uje' tu yʌn betaj xib yejer xquic caj u betaj yoc'ocab?” ");
INSERT INTO lacNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bayiri' C'uj caj ya'araj xan: “Rajen a xibo' yʌn u p'ʌtic u tet bayiri' u nʌ' soc u bin u ch'a'ej u rac'. Caj ts'oc u ch'ic u rac' ca'tur yejer u rac' irej wa tu junan.” ");
INSERT INTO lacNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Caj ya'araj Jesús: ―Rajen mʌ' biq'uin ca'tur a mac a tu ch'aj u rac' quire' a C'ujo' cu yiric turiri' yʌn. Quire' C'uj caj u toc much'quintaj xib, yejer u rac' ra' u q'uinin caj u ch'aj u rac'. Jeroj, turi' cu yiric C'uj rajen mʌ' tsoy u p'ʌtic u rac' xib. ");
INSERT INTO lacNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Caj ya'araj u winiquirob judío a fariseojo': ―Biquinin caj ya'araj Moisés uch: “Tsoy ca' a ts'ibtej u ju'unin quir a p'ʌtic a rac'?” ");
INSERT INTO lacNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús caj u nuncaj ti'ob: ―Quire' chich u jo'r a rac'ob rajen ya'araj Moisés: “Tsoy u ts'ibtic u ju'unin quir u p'ʌtic u rac'.” Chen tu yʌnxchun tu cotor ba' mʌ' tsoy u p'ʌtic u rac' quire' baxuc u c'at C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A teno' ―quij Jesús―. Quin wa'aric techex. Tsoy a p'ʌtiquex a rac' wa cu man. Barej wa mʌ' u man, mʌ' tsoy a p'ʌtiquex a rac'. Mʌ' tsoy u p'ʌtic u rac' ca' u raq'uinte u jer. Wa caj u raq'uintaj u jer cu man. Wa caj u raq'uintaj u jer a p'at ten xib cu man yejer. ");
INSERT INTO lacNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","U camsʌwinicob Jesús caj ya'arob: ―Wa ja xibe' cu chen p'ʌtic u rac' a cu man mʌ' ba' wir ca' ic ch'a'ic ic raq'uintej. ");
INSERT INTO lacNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Caj ya'araj Jesús: ―Mʌ' tu cotor mʌ' c'ucha'an yor mʌ' u ch'ic u rac' quire' C'uj ts'a'b ti' u muc' soc mʌ' ju ch'ic u rac'. Jariri' mʌ' u ch'ic u rac' quire' C'uj cu ts'ic u muc' quir u quibej. ");
INSERT INTO lacNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yʌn u jer xib mʌ' ju ch'ic u raq'uintej xquic quire' toc c'as caj rocha'b ten u nʌ' uch. U jer xib mʌ' ju ch'ic u rac' quire' caponta'b ten mac. Yʌn u jer xib mʌ' ju ch'ic u rac' soc u qui' beyaj ti' C'uj. A mac c'ucha'an yor mʌ' u c'at u ch'ic u rac', tsoy. A mac mʌ' c'ucha'an yor, tsoy u ch'ic u rac'. A mac mʌ' ju bin u ch'ic u rac' quire' u c'at u qui' beyaj yejer C'uj tsoy xan. ");
INSERT INTO lacNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yʌn mac caj tar purbir chichan ich Jesús quir u ts'anc'ʌbtic Jesús soc u yamta' ten C'uj. Ca' u t'ʌnej C'uj Jesús quir u yamta'r a chichano' Jesús. Raji'ob q'ueya'b ten u camsʌwinicob Jesús a mac tar u puricob a chichano'. ");
INSERT INTO lacNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Caj ya'araj Jesús: ―Tsire'ej u tar purbir chichan. Mʌ' ja mʌquex u berob quir u tarob ten. Mʌ' ja wirej, a chichano' sep cu tar tu yʌnen. Wa mac u c'at yocar tu cu bin u reyintejob C'uj ca' u cʌnejob a chichano'. ");
INSERT INTO lacNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Caj u ta'rob ten Jesús a chichanobo' soc u yamta'r a chichanobo' ten C'uj. Caj wʌc'ʌs bin Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Caj bin ich Jesús a mʌ' uch xuruc xib, caj u c'ataj ti' Jesús: ―Ba' quin yʌn u'yic in wʌjcamsayʌjirech quire' jach tsoyech. Ba' ca' in betej a jach tsoyo', soc in cuxtar munt q'uin? ");
INSERT INTO lacNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Caj u nuncaj Jesús: ―Biquinin ca wa'aric jach tsoyiren? Chen C'uj a jach tsoyo', mʌna' u jer. Wa ja c'at u yacsiquech C'uj ca' a quibej u t'ʌn tu ts'iba'an. ");
INSERT INTO lacNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Caj u c'ataj xib a mʌ' uch xuruc. Caj ya'araj: ―Tu yʌn? ―quij. Caj u nuncaj Jesús: ―Mʌ' a yʌn quinsic mac. Mʌ' a yʌn man yejer a mʌ' a rac'. Mʌ' a wa'cric ba'. Mʌ' a tus pʌquic mac. ");
INSERT INTO lacNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Caj ya'araj Jesús ti': ―Sʌjtej a tet, bayiri' sʌjtej a nʌ'. Yajquintej a wet cajar an ten bic a yajquintic a wʌc'ʌs bʌjiri'. ");
INSERT INTO lacNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Caj u nuncaj a mʌ' uch xuruc xib: ―Aro' caj in toc rʌc quibaj, caj in toc quibaj tin chichanin. Yʌn wa ju jer wa jariri'o'? ");
INSERT INTO lacNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Caj ya'araj Jesús: ―Wa ja c'at ca' u qui' acsech C'uj. Joq'uen, xen cʌnej a ba'tac. Caj ts'oc a canic a ba'tac, yʌn a taq'uin, ts'aj ti' a mac jach otsiro'. Soc a baywo' yʌn tech ich C'uj jach manan tsoyir, quire' caj a yamtaj a rac'ob. Pachir caj sayʌr tin pach quir a cʌnic in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Caj yuba a mʌ' uch xuruc xib. Caj ts'oc yubic a ba' ara'b ten Jesús ti' caj choquij yor quire' nejach yʌn u taq'uin. Caj wʌc'ʌs bin a xib mʌ' uch xuruc. ");
INSERT INTO lacNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Caj ya'araj ti'ob u camsʌwinicob, Jesús: ―Taj quin wa'aric techex. Jach yaj yubic a neyʌn u taq'uin. Jach yaj yubic xan, quir u yocar tu cu bin u reyinticob C'uj, quire' u yaj u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","In wʌc'ʌs ca' aric techex ―quij Jesús―, je' wa ju c'uchur yor yocar yʌrʌc' tsimin ich u jor yit' puts'? Mʌ' u c'uchur yor, quire' chichin u jor yit' puts'. Je' wa ju c'uchur yor ocar ich ca'anan a mac neyʌn u jach taq'uin? Mʌ' ju yocar quire' u yaj u taq'uin. Jaj ix tʌcojo' je' yocar yʌrʌc' tsimin ich u jor yit' puts'. Chen a mac neyʌn u taq'uin mʌ' ju yocar tu cu bin u reyintejob C'uj quire' u yaj u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Caj yubob u camsʌwinicob caj jaq'uij yorob. Caj u c'atajob ti' Jesús u wʌc'ʌs u bʌjirirob u camsʌwinicob Jesús: ―A mac cu bin tacbir ten C'uj? ");
INSERT INTO lacNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús caj u pʌctaj u camsʌwinicob caj ya'araj ti'ob: ―A xibo' mʌ' c'ucha'an yor u taquic u bʌj. Chen C'uj c'ucha'an yor u taquic tu cotor quire' c'ucha'an yor ti' tu cotor ba'. ");
INSERT INTO lacNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Caj ya'araj Pedro: ―Jach Ts'urir, biquinin a yʌn u taq'uin mʌ' tu rʌc p'ʌtaj u ba'tac mʌ' u sayʌr ta pach quir u cʌnic a t'ʌn? A tenobo', caj in rʌc p'atajob a ba' yʌn tenob caj sayenob ta pach quir in cʌnicob a t'ʌn. Ba' cu bin u ts'ic tenob C'uj quire' caj in toc rʌc p'ʌtob in ba'tacob? ");
INSERT INTO lacNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús caj u nuncaj: ―Jach taj, quinin wa'aric techex. Ra' u q'uinin ca' bin u betej u jer ric'ben te' ich yoc'ocab. Ra' u q'uinin xan quin bin in cutar tu cu bin u reyinticob C'uj. Ti' quin bin in cutar tu sasirir C'uj a teno' taren in yamtic mac tu cotor. Bayiri' techex, a bin a ts'urintiquex u winiquirob Israel. Ca' a ts'urintiquex a doce yo'nen u winiquirob Israel. ");
INSERT INTO lacNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A mac tu rʌc p'ʌtaj yatoch tu cotor. Cax u wʌc'ʌs u bʌjob. Cax u wʌc'ʌs tet, cax u nʌ', cax wa ju rac' cax wa ju parar cax wa ju ru'umin. Quire' cu tar tin pach quir u cʌnic in t'ʌn. Rajen cu p'ʌtic tu cotor soc u quibic in t'ʌn. A caj u rʌc p'ʌtaj aro', cu bin u c'ʌmej ti' C'uj a ba' jach tsoy baje'rer. Jach manan cu bin ts'abʌr ti'. Baxuc xan, ca' bin xuruc t'ʌn je' u ts'abʌr ti' quir u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Caj ya'araj Jesús: ―A mac caj u yʌn acsaj tu yor in t'ʌn cu qui' acsa'r ten C'uj. Bayiri' a mac pachir caj u yacsaj tu yor. Bayiri' xan cu bin qui' acsa'rbir ten C'uj. A C'ujo' mʌ' u coyen acsej a caj u yʌn acsaj tu yor. Quet ca' bin u rʌc acsejob a pachir caj u yacsajob tu yorob. ");
INSERT INTO lacNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Caj ya'araj Jesús: ―Tu cu bin u reyinticob C'uj ca'anan an ten bic u bin mac caj bin u pʌyic mac quir u beyaj, quir u t'aquic u wich uva tu cor. A'ac'bir caj bin u pʌybir ten u ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Caj tsicbajnʌjij u ts'urir yejer yʌjt'aquirob u wich uva mun u bo'orir cu bin bo'otbir. Tres pesos turi' u q'uinin u bo'orir quir u t'aquic u wich uva. Baxuc u bo'orir uch cu bo'ota'r. Caj u tuchi'taj beyajob ich u cor. ");
INSERT INTO lacNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Caj joc' u jach ts'urir a las nueve caj yiraj u jerob. Ti' yʌnob ich tu naj co'onan yo'och. Mʌna' u beyajob cu manob. ");
INSERT INTO lacNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Caj ara'b ti'ob ten u jach ts'urir: “Xenex ta beyajex tin cor. T'aquex u wich uva. Je' in bo'otiquex ca' bin xiquechex ta beyajex. A ba' tsoy tin t'ʌn je' in bo'otiquex.” ");
INSERT INTO lacNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Caj joc' u jach ts'urir caj bin u ts'urir tu cu naj mʌnic yo'och. C'ac'chunq'uin ca' u ca' iraj u jerob. Caj u tuchi'taj beyajob ich u cor. A las tres caj u ca' irajob u jerob caj u tuchi'taj beyajob. ");
INSERT INTO lacNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Caj wʌc'ʌs bin u jach ts'urir tu cu naj mʌnic yo'och a las cinco. Caj u ca' iraj u jerob. Mʌna' u beyajob. Caj ara'b ti'ob: “Biquinin u bur u q'uinin ca manex tera'? Biquinin mʌna' a beyajex?” ");
INSERT INTO lacNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Caj ara'b ti' u jach ts'urir ten a mac mʌna' u beyajob: “Mʌna' mac caj u pʌyo'on tic beyaj.” Caj ara'b ti'ob ten u jach ts'urir: “Xenex ta beyajex ich in cor. Je' in ts'ic techex a ba' tsoy tin t'ʌn.” ");
INSERT INTO lacNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","U jach ts'urir caj u tuchi'taj yʌjt'ʌnin. Oq'uin caj u tuchi'taj quir u bo'ota'r yʌjt'aquirob u wich uva. Yʌn bo'ota'r a mac pachir caj tarob. Caj ts'oc u bo'otic a pachir, caj tarob caj u bo'otaj a mac ch'ic tarob sam. ");
INSERT INTO lacNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Quet bayiri' u bo'orir caj ts'a'b ti'. Cax pachir caj tarob tu beyajob. Tres pesos caj bo'ota'b. ");
INSERT INTO lacNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Caj c'uchij tu q'uinin u bo'otic a mac yʌn ch'ic tarob. Cu tucricobe' yerob jach co'oj cu bin bo'otbir. Caj bo'ota'be' tres pesos u bo'orir. ");
INSERT INTO lacNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Caj ts'oc u bo'ota'r caj choquij yorob yejer u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Caj ya'arajob ti' u jach ts'urir: “Baxuc a pachirob xan, caj beyajnʌjob cax turi' hora. Bayiri' caj bo'ota'b xan. Cax a tenob tin jach muc'ob chʌcʌr q'uin tu quin beyajob.” ");
INSERT INTO lacNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Caj u nuncaj ti'ob u jach ts'urir caj ya'araj: “Biquinin ca chen ts'iquintiquenex in tus yaj in bʌj. Toc tsicbanʌjen techex uch caj in tuchi'techex ta beyajex. Tin toc araj tres pesos. ");
INSERT INTO lacNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ch'a'ex u bo'orir a beyajex ca' xiquechex. A teno', wa jin c'at in ts'ic techex bayiri' u bo'orir a beyajex cax pachir caj tarob. Bayiri' quin ts'ic ti'ob u bo'orir u beyajob xan. ");
INSERT INTO lacNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mʌ' wa tsoy quin ts'ic in taq'uin a mun u bo'orir in c'at in bo'otic ti'ob quire' ten in taq'uin? Biquinin choquex a worex ten quire' mʌ' ts'u'ten?” ");
INSERT INTO lacNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bayiri' baxuc, ca' bin xuruc t'ʌn xan ich yoc'ocab. A mac pachir tar tu beyaj ti' Jaj Ts'ur cu tucric mʌ' co'oj cu bin bo'otbir, chen quet cu bin bo'otbir. Barej a mac a yʌn tarij tu beyaj cu tucric jach co'oj cu bin bo'otbir a ti'ob, chen quet cu bin bo'otbir ten Jaj Ts'ur. Mʌ' ja wirej, cax ya'ab mac cu yubic u t'ʌn C'uj, mʌ' u rʌc quibicob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús caj bin ich u berir Jerusalén. Tu junan caj u pʌyaj u camsʌwinic a docejo'. Caj ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Jeroj, cu'uxex ich u cajar Jerusalén. Ti' cu bin u quinsiquenob. Ti' cu yʌn c'ubiquenob ti' u jach ts'urirob sacerdote yejer u yʌjcamsʌyʌjirob u t'ʌn Moisés. Robob cu bin u ya'arejob ca' quinsaquen. ");
INSERT INTO lacNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Robob u winiquirob judío cu bin u c'ubiquenob ti' u winiquirob romano soc u p'astiquenob. Soc u rʌc jʌts'icob in pach, soc u bʌjiquenob ich cruz soc in quimin. Mʌna' u nup u q'uinin ca' bin ca' riq'uiquen ti' in quimin. ");
INSERT INTO lacNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Caj u juts' u bʌj u nʌ'ob Jacobo yejer Juan. Ra' u tet Zebedeo. Quet caj tar yejer u pararob. Caj xonrʌj ich Jesús ");
INSERT INTO lacNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","quir u c'atic ba' ti': ―Ba' a c'at ten? ―quij. Caj ya'araj ti': ―Ca' bin c'uchur tu q'uinin ca' bin u reyinticob C'uj. Arej u cutarob turiri' ta noj, bayiri' turiri' ta ts'ic soc u sʌjta'r ten u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Caj u nuncaj Jesús: ―A techo', mʌ' a wer ba' ca c'atic ten. Arej ten wa c'ucha'an yorob a parar u muc'yajob an ten bic ten ca' bin muc'yajnʌquen ich cruz. Caj ya'arajob Juan yejer Jacobo: ―C'ucha'an ij cor ic muc'yaj an bic tech. ");
INSERT INTO lacNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús caj ya'araj ti'ob: ―Taj quin wa'aric techex. Je' a muc'yaj an ten biquen. Chen mʌ' c'ucha'an in wor in curquintechex ich in noj mʌ' ich in ts'ic, quire' mʌ' ten yʌnin. Quire' in Tet C'uj yʌnin quir u curquintic mac u c'at C'uj. U yʌn ricsmʌn uch. ");
INSERT INTO lacNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Caj yubob a diez a yet camsʌwinicob caj p'ujob yejer Juan yejer Jacobo. ");
INSERT INTO lacNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús caj u t'ʌnaj caj u much'quinticob u bʌj u camsʌwinicob quir u camsic. Caj ya'araj: ―A werex a mac u jach ts'urir u cajar a mʌ' u winiquirob judío. Cu jach ts'ictarob tu cu ts'urinticob u winiquirob. Bayiri' a mac a cu yamticob ti'ob cu jach p'asticob a mac cu ts'urinticob u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʌ' ja yʌn cʌniquex a baxuc u ts'urirob a mʌ' u winiquirob judío. A mac u c'at u ts'urintic u yet acsa'orir. Arej ti', ca' u yamtej u yet acsa'orir. ");
INSERT INTO lacNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Cax a mac ichechex u c'at u ts'urintic u yet camsʌwinicob. Arej ca' u yamtej u yet camsʌwinicob soc irej wa ju c'urew. ");
INSERT INTO lacNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Caj ya'araj Jesús: ―Ca' a cʌnenex. A teno' taren in yamtic tu cotor mac. Mʌ' taren quir u yamtiquenob. Taren quir in quinsa'r soc in rʌc taquic tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Caj joc'ob Jesús yejerob u camsʌwinicob ich u cajar Jericó. Jach pim caj sayob tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ti' yʌn ch'op u wich ca'tur cura'anob ich nʌc' bej. Quire' cu c'aticob u taq'uin wa mac cu man ich nʌc' bej. Caj yubob ya'araj cu man Jesús ich bej caj awʌtnʌjob: ―Jaj Ts'urir, u pararech wa ja nunquir David. Yajquinte tenob otsirenob, yam tenob. ");
INSERT INTO lacNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Caj q'ueya'b ten a pim soc mʌ' yawʌtob. Mʌ' yubob ya'araj ti'ob. Mʌ' ts'ocar yawʌtob. Tu jach c'amquintajob yawʌt: ―Yajquinte tenob, otsirenob yam tenob, Jaj Ts'ur, u pararech wa David. ");
INSERT INTO lacNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús caj xurij ich bej caj u pʌyaj ch'op u wichob. Caj tarob caj c'ata'b ti'ob: ―Ba' a c'atex ten quir in yamtiquechex? ");
INSERT INTO lacNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Caj u nuncob ti': ―Jaj Ts'urir, arej ca' sasichʌjʌc in wichob soc chʌca'an in wiricob in berob. ");
INSERT INTO lacNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús caj u yajquintob a ch'op u wichob. Caj tar u wichob. Sep caj toc jaw u wichob. Caj binob tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tabar u c'uchur Jesús ich u cajar Jerusalén. Jach bʌytʌc u c'uchur ich u cajar Betfagé. Nʌts'a'an u witsir u che'er Olivos. Jesús caj u tuchi'taj u camsʌwinicob ca'tur ca' xicob ich u cajar jach bʌytʌc, ");
INSERT INTO lacNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","caj ya'araj: ―Je' a wiriquex chan tsimin yejer yar. Pitex ca' taquechex a purex tera'. Seb ―quij Jesús―, ca' bin a toc irex chan tsimin yejer u yar ca' taquex a purex ten. ");
INSERT INTO lacNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wa ti' yʌn mac ―quij―. Cu yiric a pitic chan tsimin yejer yar. Wa cu ya'aric techex: “Ba'wir techex?” Arex ti': “U Jach Ts'urir je' u wʌc'ʌs tar u purej teche' ca' bin ts'ocac u c'ʌnic.” Je' u cha'ic a pitiquex. Seb cu bin u cha'ej a pitiquex. ");
INSERT INTO lacNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Caj u jamach mʌjanta'b u chan tsimin ti' yejer yar quir u cʌptar tu pach tsimin Jesús. Quir u nup'ur a ba' ts'iba'an ten yʌjtseq'uir u t'ʌn C'uj uch. Caj u toc araj yʌjtseq'uir u t'ʌn C'uj uch ti' Cristo. ");
INSERT INTO lacNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Arex ti' u winiquirob a cʌja'an ich u cajar Jerusalén: “Ira wirex cu c'uchur a reyex. Aro' mʌ' ts'ic, a cʌpa'an ich u pach chan tsimin. Quet u tar yejer yar tsimin.” Baxuc caj u ts'ibtaj uch yʌjtseq'uir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","U camsʌwinicob Jesús caj binob. Caj u pʌyajob u chan tsimin a toc ara'b ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Caj tarob u purej chan tsimin yejer yar ich Jesús. Caj u jʌyob u noq'uirob tu pach tsimin. Jesús caj nac u cʌpʌtar ich u pach chan tsimin. ");
INSERT INTO lacNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A pim mac a cu yiricob Jesús cu jʌyicob u noq'uir ich tan bej soc u yach'ʌctic u chan tsimin. Caj u rʌc jan ch'ʌctajob u re' che' irej u re' tuts quir u jʌyicob ich tan bej quir u yach'tic chan tsimin. Rajen cu jʌyicob u re' che' ich tan bej yejer u noc'ob. Cu rʌc jʌyicob quire' cu yesicob cu sʌjticob Jesús irej rey cu sʌjticob. ");
INSERT INTO lacNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A mac caj u pʌyob u ber Jesús. Bayiri' caj binob tu pach Jesús caj u c'am t'ʌnicob Jesús soc yubicob u rac'ob: ―Qui' qui' t'ʌnex a pimo', u parar a nunquirex David. Ca' ij caric ti' C'uj: “Bayo' C'uj caj a tuchi'taj a mac a cu bin u reyinticob u winiquirob judío.” Ca' ij carej ti' C'uj: “Jach caremech C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Caj jach c'uchij Jesús ich u cajar Jerusalén. Tu cotor mac caj u rʌc c'atob: ―Mac a jera'? ―quij. Caj rʌc joc'ob ich yatochob. Rʌc xibche'chʌjijob cu manob caj yubob ya'araj: ―Cu tar Cristo a tuchi'ta'b ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Caj ya'araj a pimo': ―Raji' Jesús, yʌjtseq'uir u t'ʌn C'uj. Ti' cu tar ich u cajar Nazaret ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Caj c'uch Jesús ich u cajar Jerusalén, caj oc ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Jesús caj u rʌc joc'saj a mac a cu canicob ba'. Bayiri' a mac a cu mʌnicob, caj u rʌc jʌwʌc'ch'intaj Jesús u pojche'ir tu cu c'axicob u taq'uin. Baxuc caj u rʌc jʌwʌc'ch'intaj u cutanob tu cu canicob u yʌrʌc' susuy. ");
INSERT INTO lacNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesús caj ya'araj ti'ob: ―Mʌ' wa c'aj techex tu ts'iba'an u t'ʌn C'uj: “A jera' u najir quir u yocar u t'ʌnicob C'uj”, chen techex caj a waysajex irej u japnin tunich tu cu tar a mac a cu yac'ricob ba'. ");
INSERT INTO lacNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Caj tarob a ch'op u wiche', yet tarac a mech yoque' ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u juts'ob u bʌj ich Jesús a ch'op u wiche' yejer a mech yoque'. Caj jawsa'b ti'ob ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Caj p'ujob u jach ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Caj irob u jawsic Jesús a mac yajo' rajen p'ujob. Caj yubob yawʌt t'ʌnticob ten a chichan ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío: “Qui' t'ʌnex u parar ic nunquir rey David.” ");
INSERT INTO lacNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Caj ya'arajob u jach ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés: ―Uyej ba' cu ya'aricob a chichanobo'? Caj u nuncaj Jesús: ―In wer a xacmʌnex tub ts'iba'an u t'ʌn C'uj: An ten bic a chichan a cu chuch cu ya'aricob bic jach carem C'uj quire' camsa'b bayiri' a man jaca'ano'. Biquinin mʌ' tsoy ya'aric: Jach carem C'uj a je' chichana' quire' taren tera'? ");
INSERT INTO lacNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Caj joc' Jesús ich carem naj caj u p'ʌtaj tu yʌnob u ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Caj bin ich u cajar Betania quir u wenʌn ac'bir. ");
INSERT INTO lacNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Caj sasij caj wʌc'ʌs bin Jesús ich u cajar Jerusalén. Caj wichʌjij ich bej. ");
INSERT INTO lacNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yiraj Jesús ti' yʌn u che'er higuera ich nʌc' bej. Caj u juts' u bʌj Jesús. Caj c'uchij ich u che'er caj yiraj mʌna' u wich, chen u re' yʌn. Caj ya'araj Jesús ti' u che'er higuera: ―Mʌ' a yʌn yʌn ca' ichancʌr biq'uin. Seb caj quim u che'er. ");
INSERT INTO lacNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Caj yirob u camsʌwinicob Jesús, caj quim u che'er, caj jaq'uij yorob. Caj c'ata'b ten u camsʌwinicob Jesús: ―Biquinin seb caj quimin u che'er higuera? ");
INSERT INTO lacNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús caj u nuncaj ti'ob: ―Jach taj quin wa'aric techex. Wa ca acsiquex ta worex wa mʌ' tan a waquex ta worex: “Mʌ' c'ucha'an in worob ti'.” Mʌ' chen jari' c'ucha'an a worex ti' a ba' caj in wa'araj ti' u che'er higuera. Je' u c'uchur a worex ti' ba'. Cax a je' witsa' ca t'ʌniquex ca' xic ich chi'c'ac'nab. Je' u bine' ―quij―, wa taj ca wacsic ta wor ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jesús caj ya'araj: ―Wa yʌn ba' a c'at tu ca t'ʌniquex C'uj. Je' a qui' c'ʌmiquex wa taj ca wacsiquex ta wor. ");
INSERT INTO lacNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Caj c'uchij Jesús ich u cajar Jerusalén caj ca' oquij ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u juts'ob u bʌj u jach ts'urirob sacerdote yejer u jach ts'urirob u winiquirob judío a cu ya'aric a Nuxibe'. Caj u juts'ob u bʌj ich Jesús tu cu camsic mac caj c'ata'b ti' Jesús: ―Tu yʌn mac caj u ya'araj tech ca' a joc'sej jo'oraj. Tub u tar a muc' quir a jawsic mac. Tub u tar a muc' quir a camsic mac. Mac tu ts'aj a muc'? ");
INSERT INTO lacNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús caj u nuncaj ti'ob: ―Baxuc techex xan, je' in c'atic techex wa taj ca nunquiquex ten. Je' in wa'aric techex tub u tar in muc' quir in betic aro'. ");
INSERT INTO lacNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Arej ten ―quij Jesús―. Mac tu tuchi'taj Juan quir u yacsic ja' tu jo'r mac. C'uj wa tuchi'tej wa xib tuchi'tej? Caj ts'oc yubicob a ba' c'ata'b ti'ob ten Jesús. Caj u nuncob u t'ʌn ich u bʌjirirob tan ya'aricob: ―Wa quij caric ti': “C'uj tuchi'tej”, je' ya'aric to'on: “Biquinin mʌ' ta quibex u t'ʌn Juan uch?” ");
INSERT INTO lacNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wa quij caric ti': “Tuchi'ta'b ten xib, quic sʌjticob a pim quire' a pim cu tucricob tuchi'ta'b Juan ten C'uj u tsec'tej u t'ʌn C'uj uch.” ");
INSERT INTO lacNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Baxuc caj ara'b ti' Jesús: ―Mʌ' ij quer mac tuchi'tej Juan. Baxuc caj u ca' nuncaj Jesús caj ya'araj: ―Baxuc xan, mʌ' in wa'aric tub u tar in muc' a ba' quin betic. ");
INSERT INTO lacNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús caj u c'ataj ti' u jach ts'urirob sacerdote yejer u jach ts'urirob u winiquirob judío a cu ya'aric a Nuxibe': ―Arex ten ba' ca najtiquex ti' a jera'. Ti' yʌn xib ca'tur u pararob. Caj ya'araj ti' u parar turiri': “Xen ta beyaj ich in cor baje'rer quir a t'aquic u wich uva.” ");
INSERT INTO lacNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Caj u nuncaj u parar: “Mʌ' in c'at in bin beyaj.” Pachir caj u c'axaj u tucur caj bin beyaj. ");
INSERT INTO lacNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A mac yʌn u parar ca'tur caj bin yirej u parar juntur. Caj ya'araj: “Xen ta beyaj ich in cor.” Caj u nuncaj: “Je' in bin beyaj Tet”, quij. Chen mʌ' binij. ");
INSERT INTO lacNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesús caj u c'ataj ti' u jach ts'urirob sacerdote yejer u jach ts'urirob u winiquirob judío a cu ya'aric a Nuxibe': ―Arex ten mac caj u quibaj u t'ʌn u tet? U ts'urirob caj u nuncajob: ―A tu yʌn tuchi't'aj bin beyaj cax tu cay araj: “Mʌ' u bin.” Jesús caj ya'araj: ―Jach taj, quin wa'ariquex tech an ten biquechex u parar a mʌ' tu quibaj u t'ʌn u tet. Quire' techex mʌ' ca quibex u t'ʌn C'uj. Rajen a xquico' a cu man cu bin qui' acsa'bir ten C'uj tu cu bin u reyintej C'uj. Bayiri', a mac a cu c'ʌmicob u taq'uin gobierno, quire' caj u quibob u t'ʌn Juan a tu yacsaj ja' tu jo'r mac. Chen a techex mʌ' u yacsiquechex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mʌ' ja wirej ―quij Jesús―. Caj tar uch quir u tsec'tic techex u t'ʌn C'uj mʌ' ta quibexi'. Chen a xquic a cu mano', baxuc a yʌjc'ʌmirob u taq'uin gobierno, raji'ob caj u c'axajob u yorob caj u quibob u t'ʌn Juan. Chen a techex mʌ' ja quibex u t'ʌn Juan mʌ' ja c'axex a worex cax caj a wirex cu c'axicob yorob a mac yʌn u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Caj ya'araj Jesús ti' u ts'urirob sacerdote yejer u jach ts'urirob u winiquirob judío a cu ya'aric a Nuxibe': ―U'yex ba' quin camsiquex u jer. Raji' u ru'umin tu tu pʌc'aj yaq'uir uva ich u yajaw cor. Caj u pa'te'taj u cor. Caj u betaj u ba'inquir quir u yʌts'ic u c'ab u wich uva. Caj u ts'ʌpquintaj tunich quir u ch'ictar ca'anan soc u cʌnantic yaq'uir u wich uva soc mʌ' u rʌc mʌq'uicob ch'ich'. ’Caj ya'araj u cʌnanta'r u cor ten u winiquirob. Quire' bin u ca' ti' u jer ru'um nachir. ");
INSERT INTO lacNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Caj c'uchij tu q'uinin u wichʌncʌr, caj tuchi'tob u c'urew ten u jach ts'urir quir u c'atic u bo'orir tu cu t'aca'rob u wich uva yʌjcʌnanyʌjirob u cor. Quire' yʌn u jasʌrob ti' u ts'urir, quire' u bo'orir u cor tu cu cʌnanta'ob u cor. ");
INSERT INTO lacNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Caj chuc u c'urew ten yʌjcʌnanyʌjirob u cor. Caj u jʌts'ajob turiri', u jer quinsa'b. U jer caj u ch'inajob u jo'r. ");
INSERT INTO lacNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","U wʌc'ʌs ts'urir caj u tuchi'taj u ca' jer c'urew quir u c'aticob u bo'orir ti' yʌjcʌnanyʌjirob tu tu t'acajob u wich uva ich u cor. Pim caj u toc tuchi'taj u c'urew u jach ts'urir. A tu yʌn tuchi'taj mʌ' pimi'. Ra'iri' caj u ch'inajob u c'urew u jach ts'ur ten yʌjcʌnanyajirob u cor. Caj jats'ob xan, caj quinsa'b u jer. ");
INSERT INTO lacNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Caj c'uchij tu q'uinin caj u tuchi'taj u parar. Yer yʌjcʌnanyʌjirob u cor je' u sʌjta'r u parar ten yʌjcʌnanyʌjirob u cor. ");
INSERT INTO lacNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Caj c'uchij u parar caj ir ten yʌjcʌnanyʌjirob u cor caj ya'arajob: “Raji' u parar cu tar. Raji' cu bin ch'ic u cor wa cu quimin u tet. Ca' xico'on ij quinsej u parar soc to'on quic bin ic ch'ic u cor.” ");
INSERT INTO lacNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Caj u chucajob ca' xicob u quinsejob ich u nʌc' c'axir u cor. Ti' tu jach quinsajob ich nʌc' c'axir u cor. ");
INSERT INTO lacNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesús caj u c'ataj ti'ob: ―Arex ten ba' cu bin u betic u jach ts'urir u cor ti' u yʌjcʌnanyʌjirob u cor ca' bin tac? ");
INSERT INTO lacNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","U jach ts'urirob sacerdote yejer u jach ts'urirob u winiquirob judío a cu ya'aric a Nuxibe' caj u nuncajob: ―U jach ts'urir cu rʌc bin quinsic u yʌjcʌnanyʌjirob u cor quire' jach c'as. Je' u ca' cʌxtic u jer winiquirob a mac cu bo'ota'r u t'aquic u wich uva ich u cor. Ca' bin c'uchuc tu q'uinin cu ts'icob ti' u ts'urir u wich uva u bo'orir u cor. ");
INSERT INTO lacNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús caj ya'araj ti' u ts'urirob u winiquirob judío: ―Mʌ' wa ja xacmʌnex a tu ts'ibtaj yʌjtseq'uir u t'ʌn C'uj uch caj ya'araj: U yoc naj caj u pich'intajob yʌjc'ʌxirob naj quire' mʌ' u c'atob. A je' tu purajob mʌna' u jer jach chich u muc'. Caj bin u wʌc'ʌs ch'a'ej u c'ʌxej naj. Aro' caj u betaj C'uj rajen cu jac'ʌr ij cor, quij quiric. Baxuc caj u ts'ibtaj yʌjtseq'uir u t'ʌn C'uj uch ti' Cristo. ");
INSERT INTO lacNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Rajen quin wa'ariquex tech, an ten bic caj pich'ta'b yoc naj, caj bin u wʌc'ʌs ch'a'ej quir u wʌc'ʌs c'ʌxic yatoch. Baxuc ten, ca bin a xump'ʌtenex soc in quinsa'r. Rajen a C'ujo cu bin u taquic techex a ru'umex quir u ts'ic ti' u jer mac soc raji'ob cu qui' beyajob ti' u bo'orir u ru'umob. ");
INSERT INTO lacNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ber u q'uinin mac mʌ' u c'amiquen an ten bic mac rub ich yajaw tunich. Jach yaj caj yubaj caj rub ich yoc'or. Baxuc xan, a mac a quin ts'ictar yejer an ten bic mac cu tar actun tu yocor, caj rʌc maxij. ");
INSERT INTO lacNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","U jach ts'urirob sacerdote yejer u winiquirob judío a fariseojo' caj yubob a ba' caj u camsaj Jesús. Caj yertajob caj u camsaj Jesús quir u cʌnic u ts'urirob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Rajen u jach ts'urirob sacerdote yejer u winiquirob judío a fariseojo' u c'at chucurob Jesús. Cu chen sʌjta'rob a pimo'. Mʌ' ja wirej, yerob a pimo' raji' yʌjtseq'uir u t'ʌn C'uj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús caj u yʌnxchun u wʌc'ʌs ca' camsic ti' a pimo'. Caj ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Quin wa'aric techex bic cu bin u reyinticob C'uj ich ca'anan, irej rey a cu pʌyic u rac'ob quir u qui'qui' janʌnob. Quire' u parar rey cu bin u ch'ic u rac'. ");
INSERT INTO lacNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A reyo', caj u tuchi'taj u c'urew quir u pʌyicob a mac a caj u ya'araj ca' tacob, quire' c'uchij tu q'uinin. Robob mʌ' ju quibajob u tarob. ");
INSERT INTO lacNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Caj u wʌc'ʌs ca' tuchi'taj u jerob u c'urew: “Arex ti'ob a mac caj in yʌn araj u tarob. Arex ti'ob tin toc rʌc quinsaj a wo'och bʌq'uex quir a qui' janʌnex. Jach paroc ca bin a jantex. Toc rʌc chʌca'an soc a jantiquex. Cojenex ta qui' janʌnex soc u ch'ic u rac' in parar.” ");
INSERT INTO lacNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mʌ' ju quibob caj bin pʌybir caj u p'astob yo'och. Caj bin turiri' tu cor. U jer caj bin tu cu conan ba'. ");
INSERT INTO lacNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","U jerob caj u chucajob u c'urewob rey, caj u raxob caj u quinsajob u c'urew. ");
INSERT INTO lacNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Caj yuba ba' u ber u c'urew rey caj jach ts'iquij. Caj u tuchi'taj u soldadojob quir u quinsa'r yʌjquinsirob u c'urewob, ca' u rʌc to'cacob u cajarob. ");
INSERT INTO lacNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Caj ya'araj ti' u c'urewob, rey: “Toc rʌc ts'aca'an yo'ochob quir u qui'qui' janʌnob quir u ch'ic u rac' in parar. Chen a mac caj in yʌn ch'ic pʌyaj mʌ' ju quibob u tarob jot, quij. Mʌ' tsoyob u tarobi'. ");
INSERT INTO lacNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Joq'uenex xenex pʌyex a tu cu naj much'quinticob u bʌj ich bej. Arex ti'ob. Cojenex ta qui'qui' janʌnex quire' ca' u ch'aj u rac' in parar. Arex ti' ca' rʌc tacob a much'a'an a ca wiriquexe'.” ");
INSERT INTO lacNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","U c'urewob caj binob ich u berir tu cu naj much'quinticob u bʌj winic. Caj u rʌc pʌyajob, cax tsoy caj u pʌyob, cax mʌ' tsoy caj u pʌyob xan. Tu pʌyob caj rʌc tarob, caj rʌc chup tu najir tu cu yocar. ");
INSERT INTO lacNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Caj oc yiraj rey a mac caj u pʌyob u c'urewob. Caj yiraj xib ti' yʌn. Mʌ' tu qui' buquintaj u noc' quir yiric u ch'ic u rac' mac. ");
INSERT INTO lacNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Caj ya'araj rey: “Biquinin caj oquech tera' quire' mʌ' ja buquintaj a noc' quir a wiric u ch'ic u rac' in parar?” Caj rʌc ts'oc u t'ʌnob, quire' yubaj ya'ara' ten u rey. ");
INSERT INTO lacNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","A reyo', caj ya'araj ti' u c'urewob a cu jansicob a pimo': “Maquex yoc yejer u c'ʌb. Joc'sex, a purex tancab soc u yac'tic u bʌj. Quire' mʌ' ju buquintaj u noc'. Ti' cu bin u chi'ic u yac' quire' cu muc'yaj.” ");
INSERT INTO lacNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mʌ' ja wirej ―quij Jesús―, jach ya'ab mac caj payij ten C'uj soc u yocar u reyinticob C'uj. Chen mʌ' ya'ab cu bin tetbir ten C'uj quire' mʌ' ju quibob u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","U winiquirob judío a fariseojo' caj bin much'quinticob u bʌj quir yubicob bic tabar cu bin u chuquicob Jesús, quir u wayticob u t'ʌn Jesús, quir u ta'quicob u jo'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Caj u tuchi'tajob u camsʌwinicob a fariseojo' ich Jesús, yet binac u camsʌwinicob Herodes. Caj c'uchob ich Jesús caj ya'arajob ti': ―In wʌjcamsʌyʌjirech, in werob taj ca camsiquenob bic tabar in manob tu tsoyir baxuc u c'at C'uj. Caj ya'arajob ti' Jesús: ―Cax mac cu c'uchur tu yʌnech mʌ' ja p'astej, quire' p'eri'o'on ca wirico'onex. ");
INSERT INTO lacNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Arej tenob wa tsoy ca' ic bo'otej u bo'orir ic ru'um ti' César u rey u winiquirob romano? Wa mʌ' tsoy ic bo'otic? Arej tenob ba' ca tucric a teche'? ");
INSERT INTO lacNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús caj yubaj tarob quir u wayta'r u t'ʌn Jesús. Caj ara'b ti'ob ten Jesús: ―Biquinin ca tarex a tumtic in worex yʌjtusarirechex ten. ");
INSERT INTO lacNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Joq'uenex ch'a tenex a taq'uinex tu ta bo'otajex a ru'umex soc in wiric ―quij Jesús. Caj binob u ch'ajob taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Caj ya'araj Jesús ti'ob: ―Mac yochir a jo'ort'ʌn ich taq'uin? ");
INSERT INTO lacNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Caj u nuncajob: ―Raji' yochir a jo'ort'ʌn César, u rey u winiquirob romano. Jesús caj ya'araj: ―Ca' a quibex u t'ʌn a cu ya'aric techex César. Bayiri' xan, ca' a quibex a ba' cu ya'aric techex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Caj yubob ya'aric Jesús a jera', caj jach jaq'uij yorob. Caj u p'ʌtob Jesús, caj binob ich u winiquirob judío a fariseojo'. ");
INSERT INTO lacNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ra'iri' u q'uinin caj c'uchij u winiquirob judío a saduceojo'. Ra' cu camsicob mac mʌ' u riq'uir ti' quimen. Caj c'uchob ich Jesús caj tarob c'atbir ti' Jesús ten u winiquirob judío a saduceojo'. ");
INSERT INTO lacNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Caj ya'arob ti' Jesús: ―In wʌjcamsʌyʌjirechob, ic nunquir Moisés caj ya'araj uch. Wa xib cu quimin, mʌna' u parar yejer u rac'. U yits'in cu ca' wʌc'ʌs bin u ch'aj u mu'. Cu wʌc'ʌs ca' bin u ch'a'ic soc u pararancʌr yejer u mu' quir u c'ʌ'otic u ixba' sucu'un, a quimene'. ");
INSERT INTO lacNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yʌn seis yits'in a yʌn quimen xib, caj quimij mʌna' u parar. U yits'in aro' caj u ca' ch'aj u mu'. ");
INSERT INTO lacNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Baxuc caj u ca' ch'aj u jer u mu', caj quimij mʌna' u parar xan. U yits'in aro' tu ca' ch'aj u mu'. Mʌna' u parar yejer caj quimin. Hasta tu rʌc ch'aj u mu' caj rʌc quimin mʌna' u parar yejer. ");
INSERT INTO lacNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Caj rʌc ts'oc u quiminob u mamob caj quimin xquic xan. ");
INSERT INTO lacNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Caj ya'araj u winiquirob judío a saduceojo': ―Are tenob mac cu bin raq'uintej ca' bin ca' riq'uir mac tu quimin. Mʌ' ja wirej, siete caj u ch'aj u mam. ");
INSERT INTO lacNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús caj u nuncaj: ―A wʌc'ʌs bʌj cu tusariquex. Mʌ' ja najtiquex a ba' ts'iba'an ich u t'ʌn C'uj. Mʌ' ja werex wa jach chich u muc' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ca' bin c'uchuc tu q'uinin u wʌc'ʌs riq'uir ti' quimen. A xibo' mʌ' ju raq'uintej xquic. Bayiri' a xquic mʌ' ju mʌmintej xib quire' u jer cu bin waysa'r ten C'uj irej yʌjt'ʌnirob C'uj ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","’Soc a cʌniquex ba' u c'at ya'aric je' u riq'uir mac ti' quimen. C'aj wa techex tu ts'iba'an u t'ʌn C'uj. Caj ya'araj C'uj ti' u winiquirob israel: ");
INSERT INTO lacNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Tu c'ujinten Abraham uch. Bayiri' Isaac yejer Jacob.” A C'ujo' mʌ' quimen yiric a nunquirex. Cuxa'an yiric a C'ujo'. Mʌ' ja wirej, cuxa'an yiric C'uj tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Caj yubob a pimo', caj jaq'uij yorob. Caj yubob ya'araj ten Jesús bic C'uj cu yiric mʌ' quimen mac. ");
INSERT INTO lacNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","U winiquirob judío a fariseojo' caj yubob ya'aric Jesús mʌ' c'ucha'an yorob u nunquicob u t'ʌn Jesús a saduceojo'. Caj u much'quintajob u bʌj yejer u winiquirob judío a saduceojo' soc u tarob ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Caj tuchi'ta'b ten u winiquirob judío a fariseojo' yejer u winiquirob judío a saduceojo' turiri' u rac'ob. Caj bin u tus c'atejob ba' ti' Jesús soc tumta'r yor Jesús. Raji'ob caj u tuchi'tajob yʌjcamsʌyʌjir u t'ʌn Moisés. ");
INSERT INTO lacNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Caj c'ata'b ti' Jesús ten yʌjcamsʌyʌjir u t'ʌn Moisés: ―In wʌjcamsʌyʌjirech. Arej tenob a jach manan tsoyir u t'ʌn C'uj ca' in qui' quibejob. ");
INSERT INTO lacNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús caj u nuncaj ti': ―Ca' a yajquintej C'uj, quire' raji' a Jaj Ts'urir. Quet a yajquintej C'uj yejer tu cotor a pixam yejer tu cotor a tucur yejer tu cotor a wor xan, quire' raji' pʌybej ich u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mʌna' u jer jach manan tsoyir, quire' raji' pʌyber ich u t'ʌn C'uj. Rajen ca' a qui'quibex a jera'. ");
INSERT INTO lacNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Quet bayiri', ti' yʌn u jer cu ya'aric: “Yajquintej a rac'ob an ten bic ca wʌc'ʌs yajquintic a bʌj.” ");
INSERT INTO lacNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wa ca quibic a je' ca'tur t'ʌn ts'iba'an uch. Caj a rʌc quibaj tu cotor u t'ʌn C'uj a ts'iba'an ten Moisés yejer yʌjtseq'uirob u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mʌ' toy xicob u winiquirob judío a fariseojo' tu much'a'an ich Jesús. Caj c'ata'b ti'ob ten Jesús: ");
INSERT INTO lacNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―Ba' ca najtiquex ti' Cristo, a tuchi'bir ten C'uj. Mac u nunquir? Caj ya'arob a winiquirob judío a fariseojo': ―Ra' u nunquir David. ");
INSERT INTO lacNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús caj ya'araj: ―Arex ten biquin David caj u t'ʌnaj: “In Jaj Ts'urirech.” Mʌ' ja wirej, caj yamta'b ten u Taj'or u Pixam C'uj caj u ts'ibtaj a jera': ");
INSERT INTO lacNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","A C'ujo' caj in wu'yaj ya'aric ti' in Jaj Ts'urir, quij David: “Curen tin noj, quij C'uj, hasta quin rʌc ch'esic a mac a cu p'actiquecho'.” Baxuc tu ts'ibtaj David uch. ");
INSERT INTO lacNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bic tabar Cristo u parar a nunquirex David wa David u bʌj t'ʌnej: “In Jaj Ts'urir.” Rajen ij quer raji' mʌ' chen u parar a nunquirex David. ");
INSERT INTO lacNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mʌna' mac caj u nuncaj u t'ʌn Jesús, mʌ' ju ca' tarob u c'aticob u jer t'ʌn ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús caj ya'araj ti' a pimo' yejer u camsʌwinicob: ");
INSERT INTO lacNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ocob tu beyajob yʌjcamsʌyʌjirob u t'ʌn Moisés yejer u winiquirob judío a fariseojo'. Raji'ob u beyajob quir u camsicob u t'ʌn Moisés. ");
INSERT INTO lacNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Quire' ra' u beyajob quir u camsiquechex u t'ʌn C'uj, rajen ca' a yʌn quibex a cu ya'ariquexob ich u t'ʌn Moisés. Chen a ba' cu man u beticob, mʌ' a yʌn cʌniquex. Cax cu chen aric ba' jach tsoy, chen cu manob ich c'as. ");
INSERT INTO lacNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","U manob u tus camsicob u t'ʌn Moisés, baxuc cu jenmasticob u t'ʌn C'uj. Rajen u winiquirob judío mʌ' c'ucha'an yorob u quibicob. Cu chen ts'ʌricob u pach u rac'ob ca' u quibejob a ba' cu tus camsicob. Chen u wʌc'ʌs bʌjiri'ob mʌ' ju quibicob a ba' cu tus camsicob, mʌ' ju quibicob chichin. ");
INSERT INTO lacNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Cu tus qui' beyajob ti' C'uj soc u tus irir ten u rac'ob cu qui' c'ʌmicob u t'ʌn C'uj. Bayiri' cu tus buquinticob u noc'ob, a jach tsoy yejer u ba'yinquirir, soc sʌjta'r ten u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Caj ya'araj Jesús: ―U winiquirob judío a fariseojo' cu pachticob cu qui' acsicob u rac'ob tu cu qui'qui' janʌnob, tu cu naj cutar jach ts'ur, soc u tus qui' sʌjta' ten u rac'ob. Cax ich u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío, u c'at u cutarob tu yʌn u cutan a nojo' soc u tus sʌjta' ten u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","’U c'at yubicob u tus qui'qui' t'ʌnʌn ten u rac'ob tu nanij cu mʌnicob yo'och. U c'at yubicob u tus qui'qui' t'ʌnʌn ten u rac'ob: “In wʌjcamsʌyʌjirech.” ");
INSERT INTO lacNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Caj ya'araj Jesús: ―Mʌ' a cha'iquex u t'ʌniquex: “In wʌjcamsʌyʌjirech” quire' chen winiquechex. Ca chen ariquex ti' C'uj: “In wʌjcamsʌyʌjirech” quire' tu cotorechex a wʌc'ʌs bʌjex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mʌ' a cha'ic u t'ʌniquex: “Tet” te' ich yoc'ocab quire' turiri' ic Jach Tet a ti' yʌno' ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mʌ' a cha'ic u t'ʌniquex: “Jaj Ts'urir” ―quij―, quire' yʌn techex turiri' a Jach Ts'urirex, raji' Cristo a tuchi'ta'b ten C'uj quir u taquiquechex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A mac a neno'ji' ich techex, raji' jach manan cu bin sʌjta'bir ten a wet camsawinic, wa cu cʌnic a c'urewo'. ");
INSERT INTO lacNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","A mac a cu ya'aric: “Jach caremen a teno'” je' u joc'sa'r ten C'uj ti' u beyaj. Chen a mac a mʌ' ju ya'arej: “Jach caremen” raji' cu bin acsa'bir ten C'uj tu beyaj. ");
INSERT INTO lacNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jesús caj ya'araj ti' u winiquirob judío a fariseojo' yejer u yʌjcamsʌyʌjirob u t'ʌn Moisés: ―Otsirechex, quire' caj a tusarex ti' a rac'ob. A techexo', mʌ' a cha'iquex u c'ʌmicob u t'ʌn Cristo a rac'ob irechex ca maquiquex u jor soc mʌ' u yocarob u reyinticob C'uj ich ca'anan. Baxuc techex, mʌ' a c'ʌmiquex u t'ʌn Cristo soc a wocarex tu cu bin u reyinticob C'uj ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Jesús ti' toy cu t'ʌnic u winiquirob judío a fariseojo' yejer yʌjcamsʌyʌjirob u t'ʌn Moisés: ―Otsirechex, quire' caj a tusarex ti' a rac'ob. Quire' ca tus taquiquex yatoch a xquico' a quimen u mame'. Caj a tus t'ʌniquex C'uj, oma'an u ts'ocar a tus t'ʌniquex C'uj soc u tus iricobechex a rac'ob. Rajen jach manan yaj ca bin a wu'yiquex a muc'yajex ca' bin xuruc t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Caj ya'araj Jesús: ―Otsirechex, quire' caj a tusariquex ti' a rac'ob. Techex, ca manex ich tu cotor yoc'ocab quir a camsiquex mac quir u c'ujinticob C'uj an ten bic ca c'ujintiquex. Caj ts'oc u cʌnicob jach manan c'aso'. Jach manan c'as a ti'obo' cax a techexo' c'asechex, chen a mac a tu cʌnajechexob jach manan c'as. Jach yaj cu bin u muc'ajob ich c'ac', mʌ' neyaj ca bin a muc'yajex ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Techex, irechex a ch'op u wichob, chen a c'atex a pʌyiquex u bej u jer ch'op u wichob. Otsirechex, quire' caj a camsex a rac'ob. Mʌ' ja wirej, wa ca toc aric ti' a rac'ob, ca wa'ariquex ti'ob: “Taj quin wa'aric tech quire' ti' yʌn carem naj tu cu naj c'ujinticob C'uj u winiquirob judío.” Cax mʌ' ja betej a ba' ta toc a'araj quire' caj a wa'araj ti' carem naj tu cu naj c'ujinticob C'uj u winiquirob judío rajen mʌ' a betej xan. Chen wa ca toc ariquex ti' a rac'ob: “Taj quin wa'aric tech quire' ti' yʌn oro ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío.” Jeroj taj ca' a betex aro', quire' caj a wa'arex ti' oro a ti' yʌn ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Jach chich a jo'rex, quire' mʌ' ja najtiquex. Mʌ' ja wirej, jach manan co'oj a carem naj tu cu naj c'ujinticob C'uj u winiquirob judío quire' ti' ca bin a c'ujintiquex C'uj. A orojo' mʌ' nejach co'oj, chen tsoy quire' ti' yʌn ich carem naj tu ca naj c'ujintiquex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Baxuc techex caj a camsex a rac'ob: Wa ca toc aric ti' a rac'ob: “Taj quin wa'aric tech quire' ti' yʌn u ba'yinquirir tu cu quinsic yʌrʌc' quir u ts'ic ti' C'uj.” Cax mʌ' ju betej a ba' caj u toc araj. Chen wa mac cu toc aric ti' u rac'ob: “Taj quin wa'aric tech quire' yʌrʌc' a tabar u quinsic ich carem naj. Jeroj ca' u toc betej a ba' caj u ya'araj.” ");
INSERT INTO lacNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Jach chich a jo'rex, quire' mʌ' ja najtex. Mʌ' ja wirej, jach manan tsoy u ba'yinquirir tu cu naj quinsic yʌrʌc' wacax quir u bo'oticob u bo'orir u si'pir. Ich yoc'or u ba'yinquirir cu naj quinsob yʌrʌc' rajen jach manan tsoyir u ba'yinquirir, quire' ti' cu bo'otic u bo'orir u si'pir a rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mʌ' ja wirej ―quij Jesús―. A mac a caj u toc arar u rac'ob quire' u ba'yinquirir tu cu naj quinsic yʌrʌc' wacax. Cu toc aric ti' a ba' yʌn yoc'or xan, mʌ' chen tu junan yʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mʌ' ja wirej, a mac a caj u toc arar u rac'ob quire' ti' yʌn carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Bayiri' caj u toc araj u rac'ob xan, quire' C'uj ti' yʌn tu cu naj c'ujinticob C'uj, quire' raji' yʌnin C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wa caj a toc arex a rac'ob quire' a ba' yʌn ca'anan, caj a toc chuquex C'uj quire' ti' yʌn C'uj ca'anan tu cu bin u reyintejob C'uj tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’A techex u winiquirechex judío a fariseojo' yejer yʌjcamsʌyʌjirex u t'ʌn Moisés. Otsirechex, caj a chʌc jʌsex ti' C'uj u ts'ac a wo'ochex a cu ya'aric u c'aba' mienta, yejer u ts'ac a wo'ochex cu ya'aric u c'aba' anis. Yejer u ts'ac a wo'ochex, a cu ya'aric u c'aba' comino, quire' baxuc cu ya'aric ich u t'ʌn Moisés. Chen mʌ' ja quibex a ba' ts'iba'an ich u t'ʌn C'uj, a tu caj u ch'ic arex techex C'uj ca' a quibex u t'ʌn. Quire' mʌ' ja yajquintaex ti' a rac'ob. Mʌ' ca manex tu tsoyir. Mʌ' ca wacsiquex ta worex u t'ʌn C'uj. Ca' a toc rʌc quibex tu cotor u t'ʌn C'uj. Mʌ' ja p'ʌtex turiri' u t'ʌn C'uj. Quet a wu'yiquex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Quire' irechex ch'op a wichex a ca pʌyiquex u berob a rac'ob a mac ch'op u wich xan. Chen jari' ca chachtiquex a mijin ti' a wuc'urex. Chen jari' ca p'ʌtiquex u sor, an ten bic a qui' cʌnantiquex a ba' mʌ' tsoy tu t'ʌn C'uj. Chen a ba' jach tsoy tu t'ʌn C'uj, mʌ' a qui' cʌnantexi'. ");
INSERT INTO lacNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Jach otsirechex, u winiquirechex judío a fariseojo' yejer u yʌjcamsʌyʌjirechex u t'ʌn Moisés. Yʌjtusariquechex ti' a rac'ob. Mʌ' ja wirej, ca chen p'o'iquex u pach a ruchex, chen ich u japnino' ec'. Baxuc u ruchirex a wo'ochex, ca p'o'iquex, ec' ich u japnin. An ten biquex a pixamex jach ec' quire' caj manex a wa'criquex u ba'tac a rac'ob, quire' jach ts'u' techex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","A techexo', mʌ' ja najtex u t'ʌn C'uj u winiquirechex judío a fariseojo'. Biquinin mʌ' ja toc p'ʌtex a wac'riquex u ba'tac a rac'ob. Ca' a p'ʌtex a ts'u'tar. Wa ca yʌn p'ʌtiquex aro', caj a ruc'sajex u yeq'uir a pixamex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’A techexo', u winiquirechex judío a fariseojo' yejer yʌjcamsʌyirechex u t'ʌn Moisés. Yʌjtusarirex ti' a rac'ob. Jach otsirechex, ca tus c'ujintiquex C'uj soc u tusaricob a rac'ob: “Jach tsoyechex”, chen jach c'asechex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Baxuc yʌnechex quire' a rac'ob cu tucric: “Jach tsoyechex.” Chen ca tusariquex ti' mac ca jach c'ujintiquex C'uj, rajen jach c'asechex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Jach otsirechex, u winiquirechex judío a fariseojo' yejer u yʌjcamsʌyʌirechex u t'ʌn Moisés quire' yʌjtusarirechex ti' mac. Caj a toc ts'ʌpquintajex tunich tu t'oja'an u baquer yʌjtseq'uir u t'ʌn C'uj uch. Baxuc xan, caj a qui' banajex u pach tunich a mac qui' manob tu tsoyir uch, quir a c'ʌ'oticobex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A techexo', ca waquex ti' a rac'ob: “Wa cuxa'anechex uch tu q'uinin ti' yʌn a nunquirex uch mʌ' ta yamtajex a mac a caj u quinsajob yʌjtseq'uirob u t'ʌn C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Rajen quetechex yejer a nunquirex yʌjquinsirob yʌjtseq'uirob u t'ʌn C'uj, quire' p'eri' a nunquirex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Joq'uenex, ts'ocsex u beyajob a nunquirex. Bin a caj toc c'ubenex quinsbirenex yejer in camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Irechex can, a yʌc u coj a cu quinsic mac. Mʌ' ju c'uchur a worex a puts'urex ich c'ac' tu ca bin a jach muc'yajex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Caj ya'araj Jesús ti'ob: ―Rajen ca' a qui' sarex a xiquinex, quire' yʌn in toc tuchi'tic techex a mac a cu bin tsec'tic u t'ʌn C'uj techex. Yʌn in toc tuchi'tic yʌjcamsʌyʌjirob u t'ʌn C'uj xan, yejer a mac u ne'er u t'ʌn C'uj. A techexo', bin a caj quinsiquex ya'ab mac. U jerob bin a caj c'ubiquex quinsbir ich cruz. A techexo', bin a caj jʌts'iquex u pachob u jerob tu cu naj c'ujinticob C'uj u winiquirob judío. A techexo', bin a caj chuquiquex u pachob u jerob tu cu bin ich u cajar, cax tu cu puts'urob, bin a caj chuquiquex u pachob. ");
INSERT INTO lacNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Rajen ca bin a bo'otiquex u bo'orir a si'pirex, quire' a mac quinsa'b ten a nunquirex, cax mʌna' c'as caj u betajob a mac quinsbir uch. Rajen bin a caj bo'otiquex u bo'orir a si'pirex, quire' quinsa'b Abel uch a mac jach tsoyir yor hasta u q'uinin caj quinsa'b Zacarías xan. Ra' u tet Berequías. Raji' caj a quinsajex ich carem naj tu ca naj c'ujintiquex C'uj. Chumuc u berir carem naj caj quinsa'b Zacarías. ");
INSERT INTO lacNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Caj ya'araj Jesús: ―Taj quin wa'ariquex tech. A techexo', baje'rer a mac cuxa'an, bin a caj bo'otiquex a si'pirex. Quire' ra' u q'uinin caj a quinsajex Zacarías hasta u q'uinin caj quinsa'b Abel ten a nunquirex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Caj ya'araj Jesús: ―A techexo', u winiquirechex judío ich u cajar Jerusalén. A techexo', caj a quinsajex yʌjtseq'uirob u t'ʌn C'uj a caj in tuchi'taj. Baxuc xan, caj a rʌc ch'inajex u jo'r a mac caj in tuchi'taj ca' u tsec'tej techex u t'ʌn C'uj. Ya'ab u tenin in c'at in much'quintic techex soc in cʌnantic techex irej u nʌ' cax cu pʌyic cu much'quintic u yar yarʌn u xic'. Chen mʌ' ta cha'ex in much'quintiquechex soc in cʌnantiquechex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","C'ʌ'otex ca' bin c'uchuc tu q'uinin, je' a rʌc p'ʌtiquex a cajarex soc chen saj naj, quire' mʌ' ja cha'ex in much'quintiquechex. ");
INSERT INTO lacNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","A teno', quin wa'aric techex, mʌ' a yʌn yʌn bin a wiren hasta ca' bin c'uchuc tu q'uinin ca bin a wa'ariquex: “Ca' ic sʌjtej Jesús, quire' raji' a mac tuchi'tac ten C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús caj joc' tu japnin carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Toc bin u ca' ca'ch caj u juts'ob u bʌj u camsʌwinicob ich Jesús. Caj ya'arajob: ―Iric carem naj. Mʌ' wa qui' c'ʌxa'an carem naj? ");
INSERT INTO lacNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús caj u nuncaj ti'ob: ―C'ʌ'otex a je' carem naj bic tabar caj a wirex quire' jach taj quin toc aric a wu'yex. Ca' bin c'uchuc tu q'uinin cu bin jubsa'bir. Mʌ' ju bin p'atʌr tunich tu ts'ʌpa'an. Mʌ' ja bin a wirex ca'tur ts'ʌpa'an. ");
INSERT INTO lacNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Caj joc' Jesús ich carem naj, caj bin ich u jo'r chan p'uc wits Olivos. Jesús caj curʌj. Ti' cura'an Jesús, caj u juts'ob u bʌj u camsʌwinicob ich Jesús soc tu junanob cu yubicob. ―Tar in c'atob a toc aric tenob wa ber ca' bin jubsac carem naj. Biquira' carem naj ca' bin c'uchuc tu q'uinin cu xur t'ʌn ca' bin urquech? ");
INSERT INTO lacNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Caj u nuncaj Jesús caj ya'araj: ―Qui' cʌnantex a bʌj soc mʌna' mac cu tar u tusiquex. ");
INSERT INTO lacNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Quire' ya'ab mac cu bin u tus aric: “Cristojen quire' caj u tuchi'tajen C'uj. Rajen quin tar quir in taquic tu cotor mac.” Ya'ab mac cu bin u quibicob a ba' cu ya'aric tus Cristo. ");
INSERT INTO lacNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ra' u q'uinino' ca' bin a wu'yiquex u jumintac: “Tan u quinsicob u bʌj ich u jer ru'um.” Cax tub yʌnechex ca' bin u quinsicob u bʌj. Je' a wu'yiquex tabar u quinsicob u bʌj. Mʌ' ja ch'aquex sajaquirex quire' yʌn u tar u quinsicob u bʌj. Cax cu manob u quinsicob u bʌj. Mʌ' toy c'uchuc tu q'uinin u xur t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ra' u q'uinino' ca wu'yiquex cu ts'ictarob winic ich jumpet ru'um. Cu bin u quinsicob u bʌj yejer u winiquirob ich jumpet ru'um. Bayiri' je' u wichʌjʌrob xan ich jumpet ru'um. Cax jach bʌytʌc cu bin u wichʌjʌjrob. Bayiri' yʌn u tar u yajir. Bayiri' je' a wu'yiquex u pec u ch'ic yum ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tu cotor aro' tan u muc'yaj. Raji' u yʌnx ch'ic chun u muc'yaj a cu bin tar ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’A ra' u q'uinino' cu bin u p'astiquechex, quire' caj a wacsex ta worex ti' ten. Rajen cu bin u ta'quicob a jo'rex. Rajen cu bin u chuquicob a pachex. Bayiri' cu bin u quinsiquechex. Baxuc tu cotor mac xan. ");
INSERT INTO lacNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Quire' aro', a ra' u q'uinino' ya'ab mac cu bin u p'ʌtejob u yacsicob tu yorob. Je' u bin u p'acticob u bʌj. Je' u ta'quic u jo'r u rac'ob ʌcʌtan u jach ts'urirob u cajarob. ");
INSERT INTO lacNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A ra' u q'uinino', ya'ab mac cu bin tar quir u tusaricob tuchi'tac ten C'uj quir u tus camsicob a pimo'. Ya'ab mac cu bin u quibicob. ");
INSERT INTO lacNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A ra' u q'uinino', ya'ab mac cu bin manob tu c'asir. Jach mananob tu c'asir. Rajen a mac a cu manob tu tsoyir mʌ' u neyajquinticob u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","A mac a mʌ' ju p'ʌticob u quibicob in t'ʌn hasta ca' bin manac a je' muc'yaj a tin wa'araj. Ra' cu bin tacbir ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mʌ' toy c'uchuc tu q'uinin u xur t'ʌn, quire' yʌn u man u tsec'ticob u jach tsoyir u t'ʌn an ten bic cu bin u reyintejob C'uj ca'anan. Bin u caj tsec'tic ich tu cotor mac ich yoc'ocab soc yerob tu cotor mac tu cʌja'anob. Ra' u q'uinin ca' bin ts'ocac u tsec'ticob ra' u q'uinin cu bin xur t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Caj ya'araj Jesús ti' u camsʌwinicob: ―Caj u ts'ibtaj Daniel a caj u tsec'taj u t'ʌn C'uj uch. Ra' tu tsec'taj uch: “Wa ca wiriquex a ba' jach c'as ch'ica'an ich u japnin carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Qui' tucrex, quij Daniel, quire' raji' cu bin u c'asquintic u winiquirob israel.” ");
INSERT INTO lacNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A ray u q'uinino' ca wiriquex aro', joq'uenex ta puts'urex ich u jo'r wits. Wa cʌja'anechex ich u ru'umin Judea, sebquintex a toc puts'urex. ");
INSERT INTO lacNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","A ray u q'uinino' wa ti' yʌn mac tu jo'r yatoch tu taj u jo'r yatoch. Arex ti' mʌ' tsoy u yocar u ch'ic u ba'tac. Arex u toc puts'ur. ");
INSERT INTO lacNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A ray u q'uinino' wa ti' yʌn mac ich u cor. Arex mʌ' u sut u ch'ic u noc'. Arex u toc puts'ur. ");
INSERT INTO lacNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A ray u q'uinino', jach otsirchʌjij a xquic a tabar u rochic u chan ochir. Bayiri' a xquico', a cu ts'ic u chuch ti' chan ochir. ");
INSERT INTO lacNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","A ray u q'uinino', t'ʌnex C'uj soc mʌ' ra' u q'uinin a puts'urex tu q'uinin que'er. Quire' mʌ' ju c'uchur a worex a muc'tiquex que'er. T'ʌnex C'uj soc mʌ' ray u q'uinin tu ca jesiquex a bʌj. ");
INSERT INTO lacNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Quire' a ray q'uinino', jach manan cu bin u muc'yajob winic. U jer winic mʌ' u nemuc'yajob an ten bic cu bin u muc'yajob u winiquirob tu q'uinin cu bin xur t'ʌn. Mʌ' biq'uin yubmʌnob. ");
INSERT INTO lacNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A ray u q'uinino', wa C'uj u c'at u cha'ic coch u pach q'uin soc oma'an cu bin muc'yaj. Mʌna' mac cu bin p'atʌrob. Chen tabar u muc'yajob, quire' ti' yʌnob a toc teta'b ten C'uj quire' yajbir ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ca' bin c'uchuc a ray u q'uinino' wa mac cu bin ya'aric: “Ire wirex Cristo toc c'uchij quir u taquic mac tu cotor.” Mʌ' a quibiquex a ba' cu ya'aricob. Cax cu ya'aricob: “A ray Cristojo'.” ");
INSERT INTO lacNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Quire' a ray u q'uinino', ya'ab cu bin tar quir u tusaricob ti' u rac'ob: “A teno' taren ich yoc'ocab quir in taquic mac quire' caj u tuchi'ten C'uj.” Tu cu tusaricob ti' mac je' u tus esicob carem beyaj ti' u rac'ob xan. Cax a mac teta'b ten C'uj orac u quibicob quire' cu tus esicob carem beyaj, quire' baxuc u c'atob, chen mʌ' ju c'uchur u yorob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jesús caj ya'araj ti' u camsʌwinicob: ―Quin toc aric techex a je' t'ʌna' soc a toc erex a ba' cu bin tar biq'uin soc mʌ' u jac'arex a worex. ");
INSERT INTO lacNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rajen a ray u q'uinino' je' u ya'aric techex: “Ti' yʌn Cristo ich tʌcay ru'um.” Bayiri' je' u tusaricob techex: “Ti' yʌn Cristo tera' ich yatoch.” Mʌ' ja yʌn quibiquex xan. ");
INSERT INTO lacNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Je' a wiriquex in wu'ur, a teno' taren in yamtic mac tu cotor, tera' ich yoc'ocab an ten bic a wiriquex u raram ich ca'anan. Mʌ' ja wirej, sasir cu raram soc chʌca'an yiric tu cotor mac ten quin tar. ");
INSERT INTO lacNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ray u q'uinino', a mac yʌn u si'pir yʌn u bo'otic u bo'orir u si'pir mʌ' tu cu puts'ur. ");
INSERT INTO lacNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Caj ya'araj Jesús ti' u camsʌwinicob: ―A ray u q'uinino', tabar u ts'ocar u muc'yaj a winiquiro'. Je' yac'birchʌjʌr q'uin. Mʌ' u sasichʌjʌr. Bayiri' ic nʌ' xan, je' yac'birchʌjʌr. A sa'abo' cu bin yiricob irej wa tan u rʌc rubur. Tu cotor a ba' yʌn ich ca'anan cu cha'ic u pec C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","A ray u q'uinino', je' yesic carem beyaj C'uj ich ca'anan soc yer mac tu cotor tan in wu'ur, a teno' quir in yamtic mac tu cotor. Tu cotor mac a ti' cʌja'an ich yoc'ocab cu bin u yac'ticob u bʌj, quire' cu yiricob in wu'ur ich u muyar yejer jach chich in muc'. Yejer u sasirir C'uj quin bin ur. ");
INSERT INTO lacNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ca' bin uruquen, je' yubicob u jum ca' bin usac ten yʌjmasir u t'ʌn C'uj. C'am cu bin yubicob. Je' in tuchi'tic u yʌjmasirob u t'ʌn C'uj quir u much'quinta'r a mac caj in tetaj ich yoc'ocab. Cax tu yʌnob ti' cu bin u much'quinta'r. ");
INSERT INTO lacNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’A werex cu jutur u re' che' quir u top'ʌncʌr, quire' tan yocar yaxq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","An bic taj aro', bayiri' xan ba' ca wiriquex a ba' caj in camsajechex sam tan u tar. Jeroj tabar u xur t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jesús caj ya'araj ti' u camsʌwinicob: ―Taj quin wa'aric techex. Ti' yʌn mac baje'rer. Ra' cu bin cuxtarob hasta cu yiricob a ba' caj in toc araj techex cu tar ich tu yʌnechex. ");
INSERT INTO lacNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A ca'anano', je' u rʌc ts'ocare' a je' ru'uma' je' u rʌc ts'ocare' xan. Chen in t'ʌno' mʌ' u bin ts'ocar quire' yʌn u toc rʌc nup'ur in t'ʌn ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Chen a ray u q'uinin cu bin tar a ba' caj in toc araj techex. Mʌna' mac yer wa ber u tar, cax yʌjmasirob u t'ʌn C'uj. Mʌ' u parar C'uj yer, chen u bʌjiri' C'uj yer wa ber u tar. Rajen mʌna' mac yer wa ber hora cax beq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ca' bin uruquen a teno' quir in yamtic mac tu cotor. Cu bin tar an ten bic tu q'uinin cuxa'an Noé uch yejer u rac'ob caj rʌc burob. ");
INSERT INTO lacNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","U rac'ob Noé rajra' qui' yorob tan u janʌnob, cu qui' uc'urob xan. Baxuc caj man u cʌxtob u rac' u parar. Cax rajra' caj u betob hasta oquij Noé ich u chem. Mʌ' tu najtajob quire' seb caj tar ya'arir. Caj u yʌnxchun u burur. Rajen rʌc quimij u rac'ob Noé. ");
INSERT INTO lacNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Baxuc ca' bin uruquen a teno' taren in yamtic mac tu cotor. Cax wa tan u janʌnob. Cax tan yuc'urob. Mʌ' ju bin u najticob wa ber ca' bin uruquen a mac tan u man tu c'asir, quire' a ba' cu yiricob. ");
INSERT INTO lacNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ray u q'uinin ca' bin uruquen cax wa ca'turo' tan u beyajob ich u cor. Ca' bin tac yʌjmasirob u t'ʌn C'uj, je' u pʌyʌr turiri' a caj u yacsaj tu yor. Turiri' cu bin p'atʌr. ");
INSERT INTO lacNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Baxuc xan xquic. Cax wa ca'turo' tan u juch'ob. Chen je' u payʌr turiri' ten yʌjmasirob u t'ʌn C'uj. Turiri' cu p'atʌr xan. ");
INSERT INTO lacNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Qui' pajex u q'uinin wa ber ca' bin uruquen ―quij Jesús―. Quire' mʌ' a werex ca' bin uruquenex a Jaj Ts'urirenex. ");
INSERT INTO lacNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Qui' cʌnex a ba' quin bin in camsic techex. Irej a mac cu tar ya'cric a ba'tac. Wa mac raji' yʌnin yatoch yer wa ber cu tar a'cra'bir u ba'tac ten mac. Ac'bir cu pajic u tar soc mʌ' u cha'ic ya'cra'r u ba'tac. Rajen cʌnex u jach ts'urir yatoch. ");
INSERT INTO lacNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Baxuc techex, ca' a qui' pajenex quire' seb ca' bin uruquen a teno' taren in yamtic mac tu cotor. Wa ra' u q'uinin mʌ' ja pajiquenex. ");
INSERT INTO lacNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Caj ya'araj Jesús ti' u camsʌwinicob: ―U'yex ba' quin wa'aric techex baje'rer. Ti' yʌn u c'urew mac cu nequi' quibic u t'ʌn u jach ts'urir. Caj bin u jach ts'urir ich jumpet ru'um. Caj ara'b ti' ten u jach ts'urir: “Qui' cʌnantej a wet c'urewirob. Qui' jansej a ba' quiri' u c'atob. Qui' irej u beyajob a wet c'urewirob.” Caj bin u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jach qui' yor u c'urew u jach ts'urir a rajra' cu quibic u t'ʌn u jach ts'urir hasta cu yu'ur u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Taj quin wa'aric techex ―quij Jesús―. Wa tu qui' quibaj u t'ʌn u jach ts'urir a c'urewo'. Je' u qui' ts'abʌr u muc' ti' quir u cʌnantic a ba'quir yʌn ti' u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Chen wa ju c'urew cu tucric mʌ' seb cu bin yu'ur u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Rajen cu yʌnxchun u cʌrʌxbetic ti' u yet c'urewirob. Bayiri' u c'urew cu joc'ar janʌn. Bayiri' cu joc'ar yuc'ur yet a mac cʌra'anob. ");
INSERT INTO lacNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","U jach ts'urir seb ca' bin ca' uruc ra' u q'uinin u c'urew mʌ' tan u pajic yu'ur u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ca' bin uruc u jach ts'urir je' u jach jʌts'ic u c'urew. Jach yaj cu bin yubic an ten bic C'uj cu bin joc'sic a mac cu tusaric ti' u rac'ob. Mʌ' ja wirej, irob a mac a mʌ' tu c'ʌmajob u t'ʌn C'uj. Je' u bin muc'yaj ich c'ac'. Ti' cu bin yac'ticob u bʌj ich c'ac'. Tu cu bin mʌmʌx chi'icob u yac' ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesús caj ya'araj ti' u camsʌwinicob: ―Ra' u q'uinin ca' bin tac u reyinticob C'uj. Cu bin tar ti' u winiquirob an ten bic caj tuchi'taj xquic quir u nupic a mac a cu bin u ch'ic u rac'. Tuchi'ta' xquic diez, ra' u nup' a cu bin u ch'ic u mam. Caj u rʌc ch'a'ob u quibob. ");
INSERT INTO lacNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco xquic caj u ch'ajob u quib. Mʌ' tu qui' cʌnantajob u quib. U jer cinco caj u qui' cʌnantajob u quib. ");
INSERT INTO lacNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A mac a tu qui' cʌnantajob u quib, caj u ch'ajob u chujir ya'arir u quib quir u t'ajicob u jer ya'arir. Toc chup ya'arir u quib caj u ch'ajob. ");
INSERT INTO lacNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A mac a mʌ' tu qui' cʌnantajob u quib a tu ch'ajob. Mʌ' ya'ab caj u ch'ajob ya'arir u quib. Chen u quib caj u ch'ajob. ");
INSERT INTO lacNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Quire' oma'an caj c'uchij a cu bin u ch'ic u rac', rajen a xquico', caj tar u wenʌnob. Caj c'ʌs wenʌneb. ");
INSERT INTO lacNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Caj yubob u tar chumuc ac'bir. Caj yubob yawʌt: “Tan u tar a mac a cu bin u ch'ic u rac'. Xenex ca' a nupex ich chumuc bej.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Caj ric'ob, a xquico', caj u pustaj u tanin u jo'r u quib caj u t'ʌbajob. ");
INSERT INTO lacNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A xquico', a cinco a mʌ' u qui' cʌnanticob u quib, caj ya'araj ti' u yet t'ʌn: “Jamach chuquej tenob ya'arir quib, quire' tan u tup'ur tenob in quibob, quire' tan xupur ya'arir.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A xquico' a caj u qui' cʌnantajob ya'arir u quib. Caj u nuncajob: “Mʌ' jin ts'ajob techex cʌrʌx xupuc tenob ya'arir. Joq'uenex mʌnex ya'arir techex tu cu naj co'onan ya'arir.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Caj binob u mʌnejob ya'arir u quib a cinco xquico'. Caj c'uchij a mac a cu bin u ch'ic u rac'. Caj ocob a tu qui' cʌnantajob ya'arir u quib. Caj ocob yejer a cu bin u ch'ic u rac'. Caj u mʌcob u jor. ");
INSERT INTO lacNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Sansam u mʌcob u jor, caj c'uch a xquic a bin u mʌnejob u ya'arir u quib. Caj u purob u t'ʌn: “Jach ts'urir ―quij―. Je'ej in jor quir in wocarob.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A mac a cu bin u ch'ic u rac' caj u nuncaj: “Taj quin wa'aric techex. Mʌ' in wirmʌnechex, rajen mʌ' in wacsiquechex.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Caj ts'oc u camsa'rob a xquico' caj ya'araj Jesús ti' u camsʌwinicob: ―C'ʌ'otex a jera' a caj in camsajechex soc a pajiquex in tar, quire' mʌ' a werex wa ber u q'uinin ca' bin taquen quir in yamtic mac tu cotor. ");
INSERT INTO lacNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’U winiquir cu bin u jach ts'urintic C'uj irob u c'urew jach ts'urir. U jach ts'urir bin u ca' ich u jer ru'um. Caj u rʌc much'quintaj u c'urewirob quir u p'ʌtic u taq'uin ti'ob quir u ca' jaricob u jer u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Caj ts'a'b u taq'uin cinco mil ten u jach ts'urir ti' u c'urew turiri'. U jer caj u ca' ts'a'b ti' u c'urew dos mil. U jer caj u ca' ts'a'b ti' mil. Caj ts'a'b u taq'uin an ten bic c'ucha'an yorob u c'urewirob tu beyajob. Caj bin u ts'urirob nach. ");
INSERT INTO lacNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A mac a caj u c'ʌmaj u taq'uin cinco mil caj u c'ʌnaj quir u ca' jaric u jer. Caj u ca' jaraj u jer cinco mil tu cu beyaj. ");
INSERT INTO lacNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","A mac a ts'a'b ti' dos mil caj u c'ʌnaj. Ca' u ca' jaraj u jer dos mil tu cu beyaj. ");
INSERT INTO lacNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A mac a ts'a'b ti' mil caj u ta'caj u taq'uin. Caj u pan u jor u ru'um quir u muquic u taq'uin. Caj u mucaj u taq'uin ich ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Jach ya'ab u q'uinin caj ur jach ts'urir. Caj u ca' much'quintaj u c'urewob. Caj c'ata'b ti'ob: “Mun u taq'uinob.” Caj u jarajob u taq'uinob. ");
INSERT INTO lacNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ra' yʌn c'uchij a ts'a'b ti' cinco mil, caj ya'araj ti' u jach ts'urir: “Caj binech caj a ts'aja ten cinco mil quir in c'ʌnic. A teno' caj in jaraj u jer cinco mil tech tu quin beyaj. Je' a taq'uin cinco mil yejer u jer cinco mil caj in jaraj.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Caj ya'araj u jach ts'ur: “Tsoyech in c'urewech. Taj ta wa'araj ten. Qui' beyanʌjech. Caj a jaraj a taq'uin, cax mʌ' ya'ab taq'uin, caj in ts'aj tech. A baje'rer je' in ca' ts'ic tech u jer jach ya'ab. P'aten tin wicnʌn soc u qui'tar ij cor.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Caj c'uchij a ts'a'b ti' dos mil. Caj ya'araj ti' u jach ts'urir: “Caj binech caj a ts'ajaj ten dos mil quir in c'ʌnic. U jer caj in ca' jaraj tech. Yʌn ten u jer dos mil. A je' a dos mil a caj a ts'ajaj ten. Caj bin yejer u jer a caj in jaraj tech.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Caj ya'araj u jach ts'urir: “Tsoyech in c'urewech. Jach taj ca wa'aric ten. Qui' beyanʌjech caj a jaraj in taq'uin, cax mʌ' ya'ab taq'uin, caj in ts'a tech. A baje'rer je' in ca' ts'ic tech a taq'uin jach ya'ab. P'aten tin wicnʌn soc u qui'tar ij cor.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Caj c'uchij a ts'a'b ti' turi' mil caj ya'araj ti' u jach ts'urir: “Jach ts'urir, quij. In wer jach ts'u'tech ca nejaric a taq'uin tu ca c'ʌnic. Rajen jach manan ca jaric a taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Rajen mʌ' jin c'ʌnaj a taq'uin quire' caj in ch'aj sajquir. Rajen caj in chen panaj u jor u ru'umin quir in muquic a taq'uin. Jera' tech a taq'uin.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","U jach ts'urir caj u nuncaj ti' u c'urew: “Jach c'asech mʌ' jach c'orech. A wer jach ts'u'ten ca' in nejaric in taq'uin tu quin c'ʌnic. Rajen jach manan ya'ab quin jaric in taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Biquinin mʌ' binech a but'ej in taq'uin ich u najitaq'uin soc in chʌc jaric u jer in taq'uin. Ca' bin uruquen ca chʌc ts'ic ten in taq'uin yejer u jer caj a jaraj ich u najitaq'uin?” ");
INSERT INTO lacNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","U jach ts'urir caj ya'araj ti' mac ti' yʌnob: “A mun yʌn ti', ch'a, a ts'a u taq'uin a mac yʌn ti' diez mil. ");
INSERT INTO lacNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","A baxuco' cu tar ti' winic xan. A mac yʌn ti' jach ya'ab u taq'uin. Je' u t'ajʌr u ba'tac hasta jach ya'ab u ba'tac. Chen a mac mʌ' ya'ab u taq'uin je' u tocar ti', cax mʌ' ya'ab yʌn ti'.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Caj ya'araj u jach ts'urir ti' u c'urew: “Chuquex a purex a je' in c'urewa'. Joc'sex a pich'intex ich tancab tu ac'bir.” Baxuc cu bin u betic ti' a mac jach c'as, ti' cu bin ocarob tu cu bin muc'yajob ich c'ac'. Ti' cu bin u yac'ticob u bʌj. Ti' cu bin u chi'ic u yac'ob ich c'ac' quire' muc'yaj u ca'ob. ");
INSERT INTO lacNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Caj ya'araj Jesús ti' u camsʌwinicob: ―Ca' bin taquen a teno' a mac tar quir in yamtic mac tu cotor. Quin tar in reyintic tu cotor mac. In wet tar yʌjmasirob u t'ʌn C'uj yejer u sasirir C'uj xan. Ti' quin bin in cutar tu cu naj cutar rey quir in wiric a mac tsoy wa mʌ' tsoyi'. ");
INSERT INTO lacNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ti' cu bin u much'quinticob u bʌj tu cotor mac wa ti' cu tar ich u jer ru'um. Ti' cu bin u rʌc much'quinticob u bʌj ʌcʌtan ten ―quij Jesús―. U tiri' quin bin in jʌsic irij a mac yʌn yʌrʌc' tʌmʌn yuc cu jʌsic yejer yʌrʌc' chivo. Jujuntur ti' quin bin in jʌsic hasta caj in rʌc jʌsaj tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A mac cu jach man tu tsoyir ti' quin bin in jʌsej ich in no'j. Wa mac cu man tu c'asir ti' quin bin in jʌsic tin ts'ic. ");
INSERT INTO lacNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","A teno' ―quij Jesús―, quin bin in wa'aric a mac ti' yʌnob tin no'j: “Je' in qui' acsiquechex tu cu bin u reyintic C'uj, quire' C'uj caj u betaj tsoy ti' techex. Cax mʌ' toy betaj te' ich yoc'ocab C'uj caj u toc betaj u cuchir quir u yacsiquechex ich ca'anan a mac a caj u yacsajob tu yorob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mʌ' ja wirej, tsoy in wacsiquechex. Mʌ' ja wirej, caj wichʌjen uch caj a ts'aj in wo'och. Caj uc'chʌjen caj a ts'aj in wuc'ur. Caj a wacsajenex quire' mʌna' in way tu quin wenen. ");
INSERT INTO lacNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Caj a wirajex mʌna' in noc' caj a sijex ten in buquintej. Caj a wirex yajen caj tarechex a wirenex. Caj a wirenex mʌca'anen caj tarechex a wirenex.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Robob cu bin ya'aric: “Jaj ix tʌcoj ic Jaj Ts'urirex. A tenob quire' mʌ' tin jansajob tech. Mʌ' tin ts'ajob quir a wuc'ur. Mʌ' tin wacsajob tech quire' mʌna' a way. Mʌ' tin yamtajob tech a baywo'. ");
INSERT INTO lacNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A tenob mʌ' tin wacsajob tech mʌ' tin ts'ajob tech a noc' quir a buquintic. ");
INSERT INTO lacNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Caj yajijech mʌ' tarenob in wirechob. Ti' mʌca'anech xan mʌ' tarenob in wirechob.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A teno' quin bin in nunquic techex: “Jach taj quin wa'aric techex quire' caj a yamtajex a mac a caj u yacsajob tu yorob in t'ʌn cax ca wiric irej moso quet tan a yamtiquenex.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’A teno' quin bin in wa'aric ti' a mac a ti' yʌnob tin ts'ic: A techex satʌrechex. Joq'uenex, xenex ich c'ac' soc munt q'uin ca werarex a toc beta'an ten C'uj ti' quisin yejer yʌjmasirob u t'ʌn quisin. ");
INSERT INTO lacNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mʌ' jin wacsajechex, quire' mʌ' ta jansajenex, cax wi'ijen. Caj uc'chʌjen mʌ' ta c'ʌs ts'ajex in wuc'ur. ");
INSERT INTO lacNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Caj manen tu yʌnechex, cax caj a wirajenex mʌna' in noc', mʌ' ta c'ʌs ts'ajex ten in buquintej. Cax caj a wirex mʌna' in way, mʌ' ta wacsajenex. Caj yajijen mʌ' tarechex a c'ʌs irenex. Bayiri' ti' mʌca'anen, mʌ' tarechex a c'ʌs irenex. ");
INSERT INTO lacNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","A mac ti' yʌnob tin ts'ic cu bin u yacob ten: “Jaj Ts'urir, wa ber caj in wirob wi'ijech cax uc'chʌjech. Cax mʌna' a way mʌ' in ts'ajob tech. Caj in wirob ti' mʌca'anechob mʌ' tarenob in wiriquechob. Caj in wirob yajech mʌ' tarenob in wirechob mʌ' tin yamtechob?” ");
INSERT INTO lacNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A teno' quin bin in nunquic a mac ti' yʌn ich in ts'ic: “Taj quin wa'aric techex quire' caj a p'uspachtaj a caj u yacsaj tu yorob in t'ʌn. Quire' mʌ' a tucriquex wa tsoyob a yacsmʌnob tu yorob in t'ʌn. Bayiri' caj u p'uspachtajenex.” ");
INSERT INTO lacNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Rajen quin bin in wa'aric ti' a mac ti' yʌn ich in ts'ic: “Xenex ta werarex ich c'ac' munt q'uin ca werarex.” Chen a mac ti' yʌn tin no'j quin bin in wa'aric ti'ob: “Je' in qui' acsiquechex quir a cuxtar munt q'uin ich ca'anan.” ");
INSERT INTO lacNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Caj ts'oc ya'aric Jesús a ba' caj u camsaj sam ti' u camsʌwinicob. Caj u rʌc araj ti' u camsʌwinicob: ");
INSERT INTO lacNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Techex a werex ―quij Jesús―. Ca'bej cu c'uchur tu q'uinin u qui'qui' janʌnob u winiquirob judío. Ra' u q'uinin quir u c'ʌ'oticob caj u potmastajob yʌjmasir u t'ʌn C'uj uch. Soc mʌ' u quimin u parar a yʌn rocha'b ten u nʌ' uch. Ra' u q'uinin ca'bej, quir u c'ubiquenob, a teno' taren in yamtic mac tu cotor, ca' quinsaquen ten u jach ts'urirob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","U jach ts'urirob sacerdote caj u rʌc much'quintob u bʌj yejer yʌjcamsayʌjirob u t'ʌn Moisés yejer u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo'. Ti' cu much'quinticob u bʌj ich yatoch Caifás. Ra' u jach ts'urir ti' tu cotor sacerdote, tu re'a'an yatoch tu pach u pa'te'. ");
INSERT INTO lacNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Robob u c'at u tucricob bic tabar cu bin u muc u chuquicob Jesús soc u quinsa'r. ");
INSERT INTO lacNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Caj ya'arajob: ―Ca' ic yʌn pajej u ts'ocar u q'uinin u qui'qui' janʌnob. Quire' je' u ts'ictarob a pimo' wa quic chuquic Jesús tan u qui'qui' janʌnob. ");
INSERT INTO lacNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús ti' yʌn ich u cajar Betania. Ti' yʌn ich yatoch Simón a ju cʌnmʌn iq'uer u ca' uch. ");
INSERT INTO lacNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ti' yʌn Jesús, cu janʌn ich u poche'ir och. Caj u juts u bʌj xquic. U ch'amʌn tu t'aja'an a qui' u boque'. U c'aba' u chujir, alabastro, tunich u chujir tu t'aja'an ya'arir a qui' u boco'. Jach manan coj a qui' u boco'. Caj joy tu jo'r Jesús tu cura'an janʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","U camsʌwinicob Jesús caj yirob caj u jayaj tu jo'r Jesús a qui' u boco' caj p'ujob. Caj ya'arajob: ―Tu chen rʌc xup u taq'uin. Ba'wir ti' caj u chen mʌnaj? Mʌ' ja wirej, jach co'oj a qui' u boco'. ");
INSERT INTO lacNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wa caj cʌnaj ca'che', caj u ca' jaraj ya'ab u taq'uin quir u jasʌr ti' a jach otsir. ");
INSERT INTO lacNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús caj yuba ba' ya'arajob u camsʌwinicob. Caj ya'araj ti' u camsʌwinicob: ―Ba'wir ca ts'iquintiquex xquic. Tsoy caj u jayaj tin jo'r a qui' u boque'. ");
INSERT INTO lacNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A otsire' rajra' ti' yʌn tu yʌnechex. Wa ber a c'at a yamtej a otsiro', ca' a yʌn yamtex. A teno' mʌ' rajra' ti' yʌnen tu yʌnechex. ");
INSERT INTO lacNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A xquico', rajen caj u jayaj tin jo'r a qui' u boque'. Quire' tabar u muquic in baquer mac. ");
INSERT INTO lacNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jach taj quin wa'aric techex ―quij Jesús―. Cax wa tu cu bin u tsec'tic u jach tsoyir u t'ʌn C'uj. Je' ya'aric bic caj u jayaj tin jo'r xquic a qui' u boque' soc u c'ʌ'otic a je' xquica'. ");
INSERT INTO lacNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Caj ts'oc yiric u joyaj tu jo'r Jesús a qui' u boque'. Caj bin Judas Iscariote quir u tsicbar yejer u jach ts'urirob sacerdote. Judas raji' u camsʌwinic Jesús. Turiri' ich u doce camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Judas caj c'uchij caj u c'ataj ti' u jach ts'urir sacerdote: ―Mun ca bin a bo'oten wa quin c'ubic Jesús? Caj bo'ota'b yejer sʌc taq'uin treinta. ");
INSERT INTO lacNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ra' u q'uinino', caj u toc cʌxtaj bic tabar cu bin u c'ubic Jesús tu junan. ");
INSERT INTO lacNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yʌn turi' u q'uinin quir u c'uchur tu q'uinin u qui'qui' janʌnob saman. Ra' u q'uinin ca' bin u jantejob pan, raji' mʌna' u ts'ac quir u sip. C'uch u camsʌwinicob ich Jesús caj u c'atajob ti': ―Arej tenob tub a c'at a jantej a wo'och oq'uin tu q'uinin u qui'qui' janʌnob u winiquirob judío? ");
INSERT INTO lacNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Caj u nuncaj Jesús caj ya'araj ti'ob: ―Xenex ich u cajar Jerusalén. Je' a wiriquex turi' xib ich yatoch. Arex ti': “A wʌjcamsʌyʌjir u c'at u tar tu janʌn oq'uin soc u c'ʌ'otic u q'uinin caj u potmastaj yʌjmasir u t'ʌn C'uj uch. Tabar u quinsa'r a wʌjcamsʌyʌjir rajen cu tar.” ");
INSERT INTO lacNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","U camsʌwinicob caj binob ich u cajar Jerusalén. Caj ara'b ti' xib an ten bic toc ara'b ten Jesús. Caj toc bota'b yo'och Jesús ten u camsʌwinicob quir u c'ʌ'otic u q'uinin caj potmasta'b yʌjmasir u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Caj ac'birchʌjij, caj c'uchij Jesús quir u janʌn. Yet tarac doce u camsʌwinicob. Caj curob tu janʌnob yejer Jesús ich pojche'ir yo'och. ");
INSERT INTO lacNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tan tu janʌn Jesús caj ya'araj: ―Jach taj quin wa'aric techex. Yʌn turiri' techex ca bin a mucu c'ubiquen. ");
INSERT INTO lacNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Caj jach choquij yorob u camsʌwinicob Jesús. Jujuntur u camsʌwinicob cu bin u c'aticob ti' Jesús: ―Ten wa quin bin in c'ubiquech Jaj Ts'urir? ");
INSERT INTO lacNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Caj u nuncaj Jesús caj ya'araj ti'ob: ―A je' cu ruchic yo'och, raji' cu bin u c'ubiquen ti' yʌn yejerechex. ");
INSERT INTO lacNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A teno' taren in yamtic mac tu cotor. Rajen yʌn in bin quinsbir, quire' tabar u nup'ur u t'ʌn C'uj. Chen otsir a mac a cu bin u mucu c'ubiquen. Jach manan tsoyir wa mʌ' ti' yʌn tera' ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas a tu mucu c'ubaj Jesús. Caj cata'b ti' Jesús: ―Ten ix ti', quin bin in c'ubiquech Jaj Ts'urir? Caj u nuncaj Jesús: ―Taj, tech ca bin c'ubiquen. ");
INSERT INTO lacNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ti' toy u janʌnob caj u ch'aj yo'och pan caj u yʌn t'ʌnaj C'uj: ―Bayo' C'uj, quire' caj a ts'aj tenob in co'ochob pan. Caj u rʌc t'axaj ti' u camsʌwinicob caj ya'araj ti'ob: ―Jantex a je' pan quire' in bʌq'uer. Jantex. ");
INSERT INTO lacNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Caj ts'oc u rʌc janticob yo'och pan. Jesús caj u chucaj u chan ruch yejer u c'ab u wich uva. Caj u yʌn t'ʌnaj C'uj: ―Bayo' C'uj, tech caj a ts'aj tenob u c'ab u wich uva. Caj u ts'aj ti' u camsʌwinicob. Caj ya'araj ti'ob: ―Rʌc uq'uex ca'ca' xot' techex a wu'quiquex u c'ab u wich uva. ");
INSERT INTO lacNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","A je' u c'ab u wich uva in q'uiq'uer quir u nup'ur u t'ʌn a ba' caj u ch'ic araj C'uj uch. A je' cu bin joc'ar in q'uiq'uer soc yiric ya'ab mac cu bin u jawsicob u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Quin wa'aric techex. Mʌ' in yʌnyʌn ca' uq'uic u c'ab u wich uva hasta cu xur t'ʌn. Ca' bin in wuq'uej yejerechex tu cu bin u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Caj ts'oc u c'ayob caj joc'ob, caj binob ich u witsir Olivos. ");
INSERT INTO lacNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Caj c'uchob ich u jo'r u witsir Olivos. Caj ya'araj Jesús ti' u camsʌwinicob: ―Techex tu cotorechex ca bin a p'ʌtiquenex ac'bir baje'rer, quire' ca' nup'uc u t'ʌn C'uj tu cu ya'aric: “Quin cha'ic u quinsic a mac a cu cʌnantic yʌrʌc' tʌmʌn yuc. Rajen cu bin u puts'urob yʌrʌc' tʌmʌn yuc.” ");
INSERT INTO lacNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ca' bin in wʌc'ʌs riq'uir tin quimirir ―quij Jesús―, ti' ca bin a wiriquenex ich u ru'umin Galilea. Chen a teno' quin yʌn c'uchur ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro caj ya'araj ti' Jesús: ―Cax tu cotor in wet camsʌwinicob cu bin u p'ʌtiquechob. Chen a teno', mʌ' in p'ʌtiquech. ");
INSERT INTO lacNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús caj ya'araj: ―Jach taj quin wa'aric tech Pedro. Mʌ' toy c'aynʌc cax ac'bir cax mʌna' u nup u tenin u c'ay cax ca bin a wa'aric ti' mac: “Mʌ' jin wer mac Jesús.” ");
INSERT INTO lacNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Caj ya'araj Pedro: ―Cax wa in quet quimin yejerech. Mʌ' jin wa'aric, mʌ' jin werech. Bayiri' xan, caj ya'araj u yet camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Caj c'uchij Jesús yejer u camsʌwinicob ich u chan corir u c'aba' Getsemaní. Caj ya'araj ti' u camsʌwinicob: ―Te' a yʌn cutarex. Tar quin bin bʌytʌc quir in t'ʌnic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús caj u pʌyaj tu pach Pedro yejer u pararob Zebedeo. Ca'tur u pararob. Jesús caj u yʌnxchun u tucur tu yor, bayiri' xan, caj u yʌnxchun u muc'yaj. Jach manan cu tucur caj c'uchij bʌytʌc. ");
INSERT INTO lacNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Caj ya'araj ti'ob: ―Jach tucur in ca'. Tan u jach bin in wor irej wa bin in ca' quimin. Te' a p'atʌrex mʌ' ja wenʌnex soc a yamtiquenex. ");
INSERT INTO lacNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús caj bin u t'ʌnej C'uj. Jach bʌytʌc caj bin. Caj pʌch'raj caj u t'ʌnej C'uj. Caj ya'araj ti' C'uj: ―Wa tsoy ta t'ʌn tech, Tet. Mʌ' ja cha'ic in jach muc'yaj an ten bic caj a toc araj uch. Wa tsoy ta t'ʌn tech ca cha'ic in muc'yaj. Baxuc ten tsoy tin t'ʌn xan, ca' tac ti' ten a ba' a c'at ten. ");
INSERT INTO lacNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Caj riq'uij Jesús caj wʌc'ʌs ur tu yʌn u camsʌwinicob. Caj yiraj wenʌn u ca'ob. Caj u t'ʌnaj Pedro: ―Mʌ' wa c'ucha'an a worex a muc'tic a wenex a tresechexe' ca' a yamtenex cax turi' hora? ");
INSERT INTO lacNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mʌ' ja wenʌnex, t'ʌnex C'uj soc mʌ' u tumtiquex a worex quisin. Cax a chen c'at aja'anechex soc a t'ʌniquechex C'uj ti' ten. Chen mʌ' ju c'uchur a worex a muc'tic a wenʌnex quire' jach tac a wenʌnex. ");
INSERT INTO lacNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Caj wʌc'ʌs bin Jesús caj u wʌc'ʌs t'ʌnaj u Tet: ―Wa tsoy ta t'ʌn, Tet, in muc'yaj ich cruz cax a ba' cu tar ten, tsoy. ");
INSERT INTO lacNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Caj ric' Jesús caj wʌc'ʌs urij ich u camsʌwinicob. Caj yiraj wenʌn u ca'ob. Mʌ' tu muc'tob u wenʌnob. Mʌ' u p'irir u wichob. ");
INSERT INTO lacNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Caj u p'ʌtaj u camsʌwinicob Jesús caj bin u ca' t'ʌnej C'uj. Mʌna' u nup u tenin u bin u t'ʌnic C'uj. Bayiri' caj u wʌc'ʌs t'ʌnaj u Tet an ten bic ca'che'. Baxuc caj u yʌn t'ʌnaj sam. ");
INSERT INTO lacNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Caj ur Jesús ich u camsʌwinicob caj ya'araj ti'ob: ―Tsoy a wenʌnex baje'rer, jes a bʌjex. Baje'rer c'uchij tu q'uinin tu chuquenob a teno' taren in yamtic mac tu cotor. Bin u c'ubiquenob ti' mac a yʌn u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Riq'uenex ―quij―, ca' xico'on ic pajic a mac a mucu c'ubiquen quire' tan u tar. ");
INSERT INTO lacNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ti' toy cu tsicbar Jesús caj c'uchij Judas Iscariote ra'iri' ti' u camsʌwinicob Jesús yejer a oncejo'. Yet taracob a jach pim. U rʌc ch'amʌnob u mascab, bayiri' u rʌc ch'amʌnob che', caj tarob quire' tuchi'ta'b ten u jach tsuririrob sacerdote yejer u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo'. ");
INSERT INTO lacNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mʌ' toy c'uchuc Judas ich Jesús caj u toc araj ti'ob a pimo': ―A ca wiriquex in ts'u'ts'ic u p'uc. Ra' ca chuquiquex. ");
INSERT INTO lacNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Seb caj u juts u bʌj ich Jesús caj ya'araj Judas ti' Jesús: ―Taren in wʌjcamsʌyʌjirech. Caj uts'benta'b u p'uc ten Judas. ");
INSERT INTO lacNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús caj u nuncaj: ―In yajech baj tarech a wirej? Caj u juts'ob u bʌj a pim caj chucob u c'ʌb Jesús ca' xicob mʌcbir. ");
INSERT INTO lacNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ti' yʌn ra' u camsʌwinic Jesús u nup. Caj u jit'aj u mascab caj u ch'ʌcaj u xiquin u c'urew u jach ts'urir sacerdote. Caj rac u xiquin. ");
INSERT INTO lacNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús caj ya'araj: ―Jup a mascab tu pix. Mʌ' ja wirej, a mac cu quinsic mac yejer mascab raji' cu wʌc'ʌs bin quinsa'r yejer mascab. ");
INSERT INTO lacNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mʌ' ja wirej, wa c'ucha'an in wor in t'ʌnic in Tet soc seb cu tuchi'ta'r yʌjmasirob u t'ʌn C'uj quir u taquicob ten. Jach pim yʌjmasirob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Chen mʌ' in t'ʌnic in Tet quire' ca' u yʌn nup'ur u t'ʌn, a caj u toc araj uch, soc u tar ten an bic caj u toc araj uch. ");
INSERT INTO lacNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Caj ts'oc u t'ʌnan Pedro caj ya'araj Jesús ti' a mac yʌjchuquirob Jesús: ―Biquinin caj tarechex tera' yejer che', bayiri' yejer a mascabex quir a chuquiquenex iren wa yʌjac'ricyʌjiren ba'. Rajra' ti' yʌnen ich carem naj caj in camsechex tu ca wocarex a c'ujintex C'uj. Biquinin mʌ' a toc chuquenex uch? ");
INSERT INTO lacNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","A ba' u ber ten baje'rer, quire' caj u toc araj uch yʌjtseq'uirob u t'ʌn C'uj. Quire' nup' a ba' ts'iba'an uch. Ra'iri' u q'uinin u camsʌwinicob Jesús caj rʌc puts'ob. P'at Jesús tu junan. ");
INSERT INTO lacNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yʌjchuquirob Jesús caj bin purbir Jesús ich Caifás. Ra' u jach ts'urir sacerdote. Bayiri' ti' yʌn yʌjcamsʌyʌjirob u t'ʌn Moisés. Ti' yʌnob u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo'. U rʌc much'quinmʌnob u bʌj xan. ");
INSERT INTO lacNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro pachir u bin tu cu binob Jesús. C'ʌs nanach cu tar Pedro hasta c'uchij tu re'a'an yatoch Caifás. Caj oc ich tu re'a'an yatoch Caifás. Caj curaj yejer policía soc u yiric ba' u ber ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","U jach ts'urirob sacerdote yejer tu cotor u ts'urirob u winiquirob judío. Ti' u much'quinmʌnob u bʌj quir u wayticob quir u tus ta'quicob u jo'r Jesús soc u quinsa'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mʌ' c'ucha'an yor u waytob quir u tus ta'quicob u jo'r Jesús. Cax jach pim mac cu tar quir u tus ta'quicob u jo'r Jesús. Pachir caj tarob ca'tur u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Caj ya'arajob ti' u jach ts'urirob u winiquirob judío: ―Tij cu'yaj ya'aric a je' xiba', cu bin u rʌc jubsic carem naj tu quij c'ujintiquex C'uj. Je' u ca' ts'ʌpquintique' u jer carem naj ca' bin ts'ocac u man mʌna' u nup u q'uinin. ");
INSERT INTO lacNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Caj ric' u ch'ictar Caifás caj ya'araj ti' Jesús: ―Biquinin mʌ' a c'ʌs nunquic ti' a mac tan u ta'quic a jo'r tech? ");
INSERT INTO lacNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús mʌ' u c'ʌs nunquic. U jach ts'urir sacerdote caj u chuchaj C'uj caj ya'araj: ―C'uj cu yiric, a cuxa'ano'. Arej to'on wa tech u pararech C'uj a mac caj u toc araj C'uj yʌn u tar quir u ta'quic tu cotor mac? Arej to'on soc taj quic najtic. ");
INSERT INTO lacNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús caj u nuncaj caj ya'araj: ―An ten bic caj a wa'araj raji' ten. Raji' ten ca bin a wiren ich u noj C'uj a jach manan chich u muc'. Quire' taren in yamtej tu cotor mac. Je' a wiric in tar tu muyarir ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","U jach ts'urir sacerdote seb caj u jʌtaj u noc' quire' ts'ic. Quire' cu tucra' cu pach'ic C'uj Jesús, an ten bic caj u nuncaj Jesús rajen Caifás caj ya'araj: ―Ba'wir ti' u jer mac quir u ta'quic u jo'r? A bʌjirex caj a wu'yajex cu pach'ic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Arex ten ba' ca tucriquex ti'? Robob u ts'urirob u winiquirob judío caj ya'arajob: ―Toc yʌn u si'pir ca' u yʌn u quimin. ");
INSERT INTO lacNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Caj u tubajob u wich Jesús caj u jʌts'ajob. U jerob caj u tac' jʌts'tajob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Caj u tus ya'arajob: ―Arej tenob mac tu tac' jʌts'tajech wa C'uj caj u tuchi'tajech quir a ta'quic mac tu cotor, quire' baxuc caj a wa'araj. ");
INSERT INTO lacNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ti' toy yʌn Pedro ich tancab tu re'a'an yatoch Caifás. Caj u juts' u bʌj turiri' xquic ich Pedro. Ra' u c'urew Caifás. Caj ara'b ti' Pedro: ―A techo' ―quij ya'araj―, a wet man Jesús ich u ru'umin Galilea xan. ");
INSERT INTO lacNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro caj ya'araj ʌcʌtan tu cotor mac: ―A teno', mʌ' in wer ba' ca wa'aric a techo'. ");
INSERT INTO lacNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sansam caj bin Pedro ich u jor yatoch Caifás. U jer xquic caj yiraj caj ya'araj: ―A je' xiba' xano', yet man Jesús ra' cu tar ich u cajar Nazaret. ");
INSERT INTO lacNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro caj ya'araj, caj u chucaj C'uj, caj ya'araj: ―A C'ujo' cu yiric. Mʌ' jin wiramʌn xib a ca c'atic teno'. ");
INSERT INTO lacNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sansam caj u juts' u bʌj xib ich Pedro caj ara'b ti' Pedro: ―Taj tech a wet mʌn Jesús uch. A mʌ' quet baxuc a t'ʌn yejer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Caj ara'b Pedro, caj u chucaj C'uj, Pedro caj ya'araje': ―C'uj cu yiric, mʌ' in wiramʌn xib a je' ca wa'aric teno'. Cax cu quinsiquen C'uj. Bayiri' caj c'aynʌj cax. ");
INSERT INTO lacNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pedro caj u c'asaj yic' a ba' ara'b ten Jesús uch: “Mʌ' toy c'aynʌc cax mʌna' u nup u tenin ca bin a wa'aric mʌ' a wer maqueni'.” Caj joc' Pedro caj oc'nʌjij. Caj jach qui' oc'nʌjij Pedro, caj u jach tucraj u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Caj sasij. Tu cotor u jach ts'urirob sacerdote yejer u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo', caj u tucrob bic tabar cu bin u quinsic Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Caj c'ax u c'ʌb Jesús caj tar purbir ich Poncio Pilato raji' gobernador. ");
INSERT INTO lacNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas caj yiraj bin u ca' quinsbir Jesús, yer raji' caj u c'ubaj, caj u tucraj ich yor: “Jach c'asen.” Caj bin u wʌc'ʌs sutbir u taq'uin, treinta sʌc taq'uin. Caj u ts'aj ti' u jach ts'urirob sacerdote yejer u ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo'. ");
INSERT INTO lacNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas caj ya'araj ti'ob: ―A teno', yʌn in si'pir ―quij―. Mʌ' ja wirej, caj in c'ubaj Jesús ca' quinsac, cax mʌna' ba' caj u betaj. Caj u nuncajob u rac'ob: ―Ba'wir to'on ca' ic tucrej, quire' ra' a beyaj tech. ");
INSERT INTO lacNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Caj u pich'intaj taq'uin Judas ich carem naj ʌcʌtan ti'ob. Caj bin Judas caj u jich' u c'o'och. ");
INSERT INTO lacNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","U jach ts'urir sacerdote caj u ch'ich'a'b u taq'uin. Caj ya'arajob: ―Mʌ' tsoy ic but'ic a je' taq'uina' ich u copre taq'uin carem naj, quire' ra' u bo'orir u quinsa'. ");
INSERT INTO lacNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Seb caj u tucrajob u mʌnicob u ru'umin quir u muquic u baquer a mac quimin, a nach u tar. Raji' u cay taq'uin Judas uch. Caj bin u mʌnej u ru'umin u c'aba' u ru'umin, Tu Cu Pʌtic Pac. ");
INSERT INTO lacNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ra' u q'uinino', caj u c'axob u c'aba' u ru'umin. Caj u pʌchaj u c'aba', U Ru'umin U Q'uiq'uer. Quire' u cay taq'uin Judas tu mʌnob u ru'umin. ");
INSERT INTO lacNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","A baywo', caj nu'psaj u t'ʌn Jeremías yʌjtseq'uir u t'ʌn C'uj. Caj ya'araj uch: “U winiquirob israel, caj u toc araj baxuc cu bin u bo'otic quir u c'ubur ti', treinta sʌc taq'uin ");
INSERT INTO lacNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","cu bin u bo'otej. Yejer u sʌc taq'uin caj u mʌnob u ru'umin a mac cu pʌtic pac. An ten bic caj u toc araj Jaj Ts'ur uch.” ");
INSERT INTO lacNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús caj bin ch'ictar ʌcʌtan gobernador. Caj c'ata'b ti': ―Taj wa u reyech u winiquirob judío? Jesús caj u nuncaj: ―Baxuc ca wa'ariquen, a teno', u reyen u winiquirob judío? ");
INSERT INTO lacNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","U jach ts'urir sacerdote yejer u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo', caj tocob u jo'r Jesús, chen mʌ' u c'ʌs nunquic. ");
INSERT INTO lacNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato caj ya'araj ti' Jesús: ―Biquinin mʌ' a c'ʌs nunquic u ta'quicob a jo'r? ");
INSERT INTO lacNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús mʌ' ju c'ʌs nuncaj chichin. Rajen jach jaq'uij yor gobernador. ");
INSERT INTO lacNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Toc beri' cu siptic mac tu maca'an ca' bin c'uchur tu q'uinin u qui'qui' janʌnob u winiquirob judío, u q'uinin caj u potmastaj yʌjmasir u t'ʌn C'uj uch. Gobernador cu bin u siptic a mac maca'an a cu c'ata' ti' ten u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A ra' u q'uinino', ti' maca'an mac jach c'as. Ra' u c'aba' Barrabás. ");
INSERT INTO lacNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ra' u q'uinin ti' much'a'anob a pimob u winiquirob judío ich Pilato. Pilato yer q'uex yorob u jach ts'urirob sacerdote. Rajen caj u ta'quob u jo'r Jesús. Caj u c'ataj ti' a pimo': ―A mac a c'at in siptic techex. Arex ten wa Barrabás wa Jesús a ca wa'ariquex Cristo? ");
INSERT INTO lacNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ti' toy yʌn Pilato tu cu ta'quicob u jo'r Jesús u ts'urirob sacerdote. Caj tuchi'ta'b ten u rac' Pilato ti' u mam. Caj ya'araj ti': ");
INSERT INTO lacNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","―A ray xibo' mʌ' tsoy a sinic ich cruz quire' mʌna' u si'pir. Baxuc caj in wʌyʌc'taj ac'bir caj u jac'saj in wor. Rajen wa ca sinic jach yaj cu bin u tar to'on. ");
INSERT INTO lacNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Chen u jach ts'urirob sacerdote yejer u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo', cu cay c'aticob ti' u rac'ob: ―Biquinin mʌ' a c'atex ti' Pilato ca' u sinej Jesús ich cruz ca' siptac a Barrabáso'? Rajen u rac'ob caj u quibajob u t'ʌn u jach ts'urirob yejer u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo' soc u sinic ich cruz Jesús. Chen cu sipta' Barrabás ten Pilato. ");
INSERT INTO lacNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato caj u wʌc'ʌs c'ataj ti' a pimo': ―Mac a c'at in siptic techex. Caj u rʌc nuncajob, caj ya'araj: ―Siptej Barrabás. ");
INSERT INTO lacNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato caj u c'ataj: ―Bic in bin in betic ti' Jesús a ca wa'ariquex Cristo? Caj u rʌc nuncajob ti': ―Arej ti' ca' xic sinbir ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato caj ya'araj: ―Biquinin cu bin sinbir ich cruz quire' mʌna' c'as caj u betaj? Robob a jach pimo' caj u purob yawʌt: ―Arej ca' sinic ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Caj yiraj Pilato mʌ' ju c'uchur yor ti' a pimo' soc mʌ' u sinin Jesús ich cruz. Chen a pimo' cu jach c'amtar u t'ʌn. Rajen caj u tuchi'taj mac ca' tac purbir ja' quir u p'o'ic u c'ʌb Pilato ʌcʌtan pim soc yiricob mʌna' u si'pir Pilato. Pilato caj ya'araj ti'ob: ―A je' xiba' mʌna' u si'pir. Rajen mʌ' in c'at u quimin. Chen quin betic a ba' a c'atex ten. ");
INSERT INTO lacNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tu cotor a pimo' caj u rʌc nuncaj: ―Arej ca' sinic ich cruz. Tenob in si'pirob ca' xic sinbir Jesús. Baxuc yʌn u si'pir in ti'arob. ");
INSERT INTO lacNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato caj u siptaj Barrabás ca' xic. Caj ya'araj ti' soldado ca' jats'ʌc u pach Jesús. Ca' bin ts'ocac u jats'ʌr cu bin sinbir ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","U soldado gobernador caj acsa'b Jesús ich palacio gobernador. Caj u rʌc much'quintajob u bʌj u yet soldadojirob ich ʌcʌtan Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Caj pit u noc' Jesús ten soldado. Caj ts'a'b u buquintej chʌc noc' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Caj u jit'ob a q'uixer u ca' quir u ts'a'b u p'oquintej Jesús q'ui'ix. Caj u chucajob oj caj ts'a'b u mʌchej tu noj Jesús. Caj xonrʌjob ʌcʌtan ich Jesús ʌcʌtan ich Jesús quir u che'tic Jesús. Caj ya'arob: ―Ca' cuxraquech munt q'uin, quire' u reyech u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Caj tuba'b Jesús caj u chucaj che' a' ju mʌchmʌn Jesús quir u jats'ʌr u jo'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Caj ts'oc u p'astar Jesús ten soldado. Caj pit u chʌc noc' ca' wʌc'ʌs ts'a'b u buquintej u noq'uirir Jesús. Caj pay ca' xic bʌjbir ich cruz Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Caj binob Jesús ich bej, caj u nup'ajob xib ti' u tar ich u cajar Cirene. Ra' u c'aba' Simón. Caj ts'ar u pach ca' c'ochac u cruz Jesús tu cu bin bʌjbir. ");
INSERT INTO lacNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Caj c'uchob tu chan witsir u c'aba' Gólgota. U c'at ya'aric u witsir u baquer u jo'r, quire' bajen u baquer u jo'r. ");
INSERT INTO lacNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ti' ts'a'b yuq'uej Jesús u c'ab uva xaca'an u c'aj bʌc'. Jesús caj u cay tumtaj, chen mʌ' tu yuc'aj. ");
INSERT INTO lacNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Caj ts'oc u bajʌr Jesús ten soldado. Caj u chictajob chan tunich quir yiric mac cu bin ch'ic u noc' Jesús. A baywo' caj u chictajob chan tunich quir u nup' u t'ʌn yʌjtseq'uir u t'ʌn C'uj tu cu ya'aric: ―Raji'ob cu bin chicticob chan tunich quir yiric mac cu bin u ch'ic in noc'. ");
INSERT INTO lacNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Caj ts'oc u ch'abʌr u noc' Jesús ti' toy curucbarob cʌnʌbir Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ts'ibta'b ich u xur u jo'r u cruz Jesús quir yirir ba' u si'pir. Tu ts'ibtaj: “A je' xiba' Jesús, u rey u winiquirob judío.” ");
INSERT INTO lacNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bayiri' xan, a cu ya'cricob ba' ca'tur caj baj ten soldado. Turiri' tu noj Jesús. Turiri' tu ts'ic xan, Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Quet yejer a cu manob ich Jesús tu bʌja'an. Cu chicticob u jo'r quire' cu p'asticob Jesús. Caj u che'jtajob. ");
INSERT INTO lacNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Caj ya'arajob ti' Jesús tu bʌja'an: ―A techo', ca wa'aric je' a jubsic carem naj ca wa'aric mʌna' u nup u q'uinin ts'oc a wʌc'ʌs ts'ʌpquintej u jer carem naj. Tac a bʌj ich cruz ca' wʌc'ʌs emaquech wa ju pararech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ti yʌnob xan, cu p'asticob Jesús u jach ts'urirob sacerdote, bayiri' u yʌjcamsʌyʌjirob u t'ʌn Moisés, yejer u winiquirob judío a fariseojo', yejer u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo'. ");
INSERT INTO lacNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Caj ya'arajob ich u rac'ob: ―A ray xibo', chen u jer cu taquic. U bʌjiri' mʌ' c'ucha'an u muc' u wʌc'ʌs taquic u bʌj. Wa taj u rey u winiquirob Israel biquinin mʌ' ju yemʌn ich cruz ij quirej soc ij cacsic tij cor u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U bʌjiri' caj ya'araj: A teno' quin wacsic tin wor ti' C'uj. Ca' ij quirej wa C'uj cu tar u taquic wa cu yajquinta'r ten C'uj, quire' caj u ya'araj uch: “U pararen C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bayiri' jujunturob u yʌja'crʌjyʌjirob ba' a bʌja'an ich cruz xan. Caj u p'astob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A ray u q'uinino', caj toc rʌc ac'birchʌjij tu cotor u ru'umin. C'ac'chunq'uin caj ac'birchʌjij, hasta las tres caj sasichʌjij. ");
INSERT INTO lacNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A ray u q'uinino', a las tres, caj c'am awʌtnʌjij Jesús, caj ya'araj: ―Elí, Elí, lama sabactani? ―u c'at ya'aric: In C'ujech, in C'ujech, biquinin caj a toc p'ʌtajen? ");
INSERT INTO lacNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","A mac ti' yʌnob ich Jesús caj yubob yawʌt Jesús: ―Ta wu'yex ba' caj u ya'araj a je' xiba'? Caj u t'ʌnaj Elías yʌjtseq'uir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Turiri' caj u c'ʌnaj yac'ab quir u ch'ic a irej noc', chen irej tʌmʌn. Caj u t'ʌjaj ich u c'ab uva a pʌjo'. Caj u ric'che'taj quir u ts'abʌr yuq'uej Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Chen u rac'ob a ti' yʌnob caj ya'araj: ―Tsire'ej, ca' ij quirej wa ju tar Elías ensbir Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A ray u q'uinino', caj wʌc'ʌs ca' awʌtnʌjij Jesús. Jach c'am caj awʌtnʌjij, caj quimij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","U noc' a t'ina'an ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. A cu jʌsic junxot' naj tu cu bin u wa'quicob u q'uiq'uer yʌrʌc' soc u ruc'sic u si'pir mac. Ra' u noc', seb caj jat tu chumuquin. Caj u yʌnxchun u jatʌr ca'anan hasta c'uchij u jatʌr ich u xax u noc'. Baxuc xan, caj pecnʌj u ch'ic yum ru'um caj wac' u tunichir. ");
INSERT INTO lacNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Caj rʌc wac' tunich tu muca'an u baquer a quimen, a yacsmʌnob tu yorob. Ya'ab caj ric'sa'b quir u wʌc'ʌs ca' cuxtar. ");
INSERT INTO lacNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Caj ts'oc u riq'uir Jesús ti' quimen caj joc' a yacsmʌnob tu yorob tu muca'an, caj binob ich u cajar Jerusalén. Ra' u cajar C'uj. Ti' irir a cu wʌc'ʌs riq'uir a yacsmʌnob tu yorob. Ti' irir ten u rac'ob a jach pimo'. ");
INSERT INTO lacNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yʌjt'ʌnir cien soldados yejer u winiquirob soldado romano a cu cʌnanticob Jaj Ts'ur. Caj jaq'uij yorob caj yubob u pec ru'um, yejer a ba' u ber ti' a quimenob. Caj ya'arajob: ―A je' xiba' u jach parar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A ti taro', ti' yʌn xquic ya'ab, nanach ch'ica'anob. Tan yiricob Jesús. Ra' yet manob yejer Jesús, caj tarob tu pach Jesús, caj u p'ʌtaj u ru'umin Galilea. Robob caj u yamtajob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A tu yʌn a xquico', ti' yʌn María a cu tar ich u cajar Magdalena. Ti' yʌn u jer xquic u rac' Zebedeo. Raji' a ca'tur u parar. ");
INSERT INTO lacNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Caj ac'birchʌjij caj tarij José. Ti' cu tar ich u cajar Arimatea. Raji' jach yʌn u taq'uin. Bayiri' caj u yacsaj tu yor u t'ʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Caj bin ich Pilato José quir u c'ata'r u baquer Jesús soc u but'ic u baquer. Pilato caj ya'araj ti' u winiquirob soldado ca' ts'a'bʌc ti' José u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José caj bin ch'abir u baquer Jesús. Caj emsa'b ich cruz. Caj u tap'aj u baquer Jesús yejer carem sʌc noc'. ");
INSERT INTO lacNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A Joséjo' caj u but'aj u baquer Jesús tu japnin tunich, a ric'beno'. Mʌ' ja wirej, José caj u betaj ti' u bʌjiri' uch. Caj ts'oc u but'ur u baquer Jesús caj u pets'ta'r u jor tunich tu but' u baquer Jesús, caj binij. ");
INSERT INTO lacNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ti' toy yʌn María, ti' cu tar ich u cajar Magdalena. U jer ti' yʌn juntur María ti' cura'an ʌcʌtan u jor tu but'a'an u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Caj sasij ra' u q'uinin caj ts'oc u man viernes. Ra' u q'uinin quir u jesicob u bʌj u winiquirob judío. Caj c'uchij u jach ts'urirob sacerdote yejer u winiquirob judío a fariseojo', caj binob irbir Pilato. ");
INSERT INTO lacNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Caj c'uchob ich Pilato caj ya'arob ti': ―Ic gobernadorech, ca' ij c'ʌ'otej a cu tusic mac. A cu ya'aric: “A ca' bin ts'ocac u man mʌna' u nup u q'uinin je' in riq'uir ti' in quimirir.” ");
INSERT INTO lacNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Rajen quic tar ij quirej tech, ca' a wa'arej ti' a winiquirob soldado romano, ca' u qui' cʌnantacob u baquer Jesús tu but'a'an. Soc mʌ' u tar ch'abir u baquer ten u camsʌwinicob ac'bir. Ca' bin u tus arob: “Riq'uij tu quimirir.” Aro' jach manan cu bin u tusaricob ti' mac, a tu yʌn tusarob mʌ' jach c'asi'. ");
INSERT INTO lacNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato caj ya'araj ti'ob: ―Tar yʌno' in winiquirob soldado romano. Pʌyex ca' xicob cʌnanbir u baquer soc robob cu bin u cʌnantejob an ten bic a c'at techex. ");
INSERT INTO lacNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Caj rʌc binob cʌnanbirob u baquer. Caj c'uchob caj u pʌc'ajob u jor soc mʌna' mac c'ucha'an yor u rʌquic u jor. Caj p'at u winiquirob soldado romano quir u cʌnaticob. ");
INSERT INTO lacNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Caj ts'oc u man sábado, ra' u q'uinin cu yʌnxchun semana, María, ti' cu tar ich u cajar Magdalena. Ti' yʌn u jer María juntur. Caj binob tu but'a'an u baquer Jesús. Jach a'ac'bir caj binob. ");
INSERT INTO lacNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Seb caj yubajob u jach ch'ic yum u pec ru'um, quire' caj tarij yʌjmasir u t'ʌn Jaj Ts'ur. Ti' u tar caj emij ca'anan. Caj c'uch tu but'a'an u baquer Jesús. Raji' caj rac u mac u jor, caj curaj tu jor. ");
INSERT INTO lacNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jach sʌc t'inen u noc' yʌjmasir u t'ʌn C'uj, irej u ba' ja', jach sʌc t'inen u wich, irej u raramʌncʌr xan. ");
INSERT INTO lacNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Caj yirob soldado romano yʌjmasir u t'ʌn C'uj caj jaq'uij yorob. Caj rʌc babʌcnʌjob orac sʌj quimicob. ");
INSERT INTO lacNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Caj ya'araj yʌjmasir u t'ʌn C'uj ti' xquic: ―Mʌ' u jac'ʌr a worex ten. In wer tan a cʌxtiquex Jesús a cu bʌjʌ'r ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mʌna' tera', quire' riq'uij an ten bic caj u toc araj uch. Cojen irex u wa'ay tu yʌn ca'ch. ");
INSERT INTO lacNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Seb ca' xiquechex a wa'arex ti' u camsʌwinicob Jesús. Arex ti'ob wʌc'ʌs riq'uij tu quimirir Jesús. Ti cu yʌn bin ich u ru'umin Galilea. Ti' taro' cu bin u nupic ti'ob. Tar cu bin yiricob. Jari' yʌn in wac techex. ");
INSERT INTO lacNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jach jac'a'an yorob xquic caj binob arbir ti' u camsʌwinicob. Seb caj binob ya'arej. Jach manan qui' yorob. ");
INSERT INTO lacNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A xquico', seb caj u nupob Jesús ich bej. Jesús caj u t'ʌnaj. A xquico', caj u juts u bʌjob ich Jesús, caj xonrʌjob. Caj mec'ab yoc Jesús ten xquic quir u c'ujinticob. ");
INSERT INTO lacNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Caj ya'araj Jesús: ―Mʌ' ja sajquirex ten. Xenex, arex ti' in camsʌwinicob: “Tar quin bin ich u ru'umin Galilea ti' cu bin yiriquenob.” ");
INSERT INTO lacNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Caj binob a xquico', caj binob soldado yʌjcʌnanyʌjirob u baquer Jesús. Mʌ' ya'ab bin ya'arej ti' u jach ts'urirob sacerdote ich u cajar Jerusalén. Caj ya'arob ba' u ber ti' tu cotor. ");
INSERT INTO lacNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","U jach ts'urirob sacerdote caj bin tsicbarob yejer u jach ts'urirob u cajar u winiquirob judío a cu ya'aric a Nuxibo'. Quir u p'eri'quinticob yor quir u ts'abʌr u taq'uin ti' soldado romano. ");
INSERT INTO lacNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Caj ya'araj u jach ts'urirob sacerdote: ―Tus arex ti' mac: “Chumuc ac'bir caj tar ch'abir u baquer Jesús ten u camsʌwinicob. Quire' wenʌn in ca'ob.” ");
INSERT INTO lacNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wa cu yubic u juminta'r gobernador je' in binob in cʌnanticob a pachex soc in ta'quiquechex ti' gobernador ―quij ya'aricob sacerdote. ");
INSERT INTO lacNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Caj ts'oc u c'ʌmiquicob u taq'uin soldado romano caj binob ya'aricob ich u winiquirob judío a ba' toc ara'b ti' ten u jach ts'urirob sacerdote. Rajen a je' t'ʌna' cu man u juminticob ich u winiquirob judío hasta baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Caj binob u camsʌwinicob a oncejo' ich u ru'umin Galilea. Caj binob ich wits bic caj ara'b ten Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ti' irir Jesús ten u camsʌwinicob ich u jo'r p'uc wits. Caj u c'ujintajob Jesús. Chen ti' yʌn ich u camsʌwinicob caj u tucrajob: ―Mʌ' raji' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús caj u juts'aj u bʌj ich u camsʌwinicob caj ya'araj ti'ob: ―Tu toc ts'aja ten C'uj tu cotor u muc' C'uj, soc c'ucha'an in wor in betic a ba' in c'at, cax ich yoc'ocab, cax ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Rajen quin toc aric techex: Ca' xiquechex ich tu cotor mac quir a camsiquex in t'ʌn soc u yacsicob tu yor. Acsex ja' tu jo'r mac yejer u muc' in Tet, yejer u muc' u parar C'uj yejer u muc' u Taj'or u Pixam C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bayiri' camsex a rac'ob ca' u quibejob a caj in toc araj techex. A werex ti' yʌnen yejerechex u burur q'uin. Mʌ' biq'uin bin in ca' p'ʌtiquechex. Hasta cu xur t'ʌn. Jeroj ts'oquij quij.");
INSERT INTO lacNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","U jach tsoyir u t'ʌn Jesucristo u parar C'uj caj u yʌnxchun bic a je' ts'iba'an a ra' cu bin tarej. ");
INSERT INTO lacNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tu yʌnxchun an ten bic Isaías u ts'ibmʌn uch quire' raji' ts'a'b u tucur ten C'uj quir u ts'ibtic a ba' u c'at C'uj. U'yex ba' tu ts'ibtaj: Iric, quij C'uj, quin tuchi'tic yʌjtseq'uir in t'ʌn, quij C'uj, pʌyber cu tsoyquintic a ber tu ca bin c'uchur. ");
INSERT INTO lacNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ti' yʌn mac tan u c'am t'ʌnic ich tʌcay ru'um. Raji' tan ya'aric: “Tajquintex a worex soc c'ucha'an a worex a qui' acsiquex Jaj Ts'ur irex tan a jariquex u ber rey quir u tar.” Baxuc caj u ts'ibtaj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Rajen c'uchij Juan tan u yacsic ja' tu jo'r mac ich tʌcay ru'um tan u tsec'tic ca' u c'axej tu yor mac soc u p'ʌticob u c'asirob soc u jawsa' u si'pirob ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tiri' caj rʌc binob yicnʌn Juan tu cotor mac a cʌja'anob tu ru'umin Judea quet bayiri' tu cotor mac ti' u cajar Jerusalén. Tu toc arajob ba' c'asir caj u betob quir u jawsa' u si'pirob ten C'uj. Jeroj tune', caj acsa'b ja' tu jo'rob ten Juan ich u ya'arir Jordán. ");
INSERT INTO lacNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A Juano' u buquinmʌn u noc' a sʌcta'b ti' u tsotser u yʌrʌc' camello. Tu c'ʌxaj u nʌc' yejer ot'. Raji' cu chi'ic sac'. Cu mʌquic cab a mʌ' ʌcrʌc'a'an. ");
INSERT INTO lacNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Caj u tsec'taj Juan: ―Tan u tar tin pach a mac jach no'j. A teno' ―quij Juan―, mʌ' no'jen. Mʌ' pataren, a teno', cax in chen p'uxtar in pitic u c'anin u pech' xʌnʌb. ");
INSERT INTO lacNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A teno' ―quij Juan―, caj in wacsaj ja' ta jo'rex chen a mac a ca' bin c'uchuc je' u ts'ic techex u Taj'or u Pixam C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mʌ' uch caj ruq'uij Jesús ich u cajar Nazaret, ra' u wa'an u ru'umin Galilea. Caj c'uchij Jesús yicnʌn Juan caj acsa'b ja' tu jo'r xan ich u ya'arir Jordán. ");
INSERT INTO lacNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Caj ts'oc u yacsic ja' tu jo'r Jesús ten Juan tan u bin ich chi' ja', Jesús seb caj u yiraj u buj ca'anan. A jeroj caj yiraj xan, u Taj'or u Pixam C'uj tan yeman irej susuy caj oc yicnʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Raji' caj u yubaj u t'ʌn a cu tar ca'anano', caj u ya'araj: ―A techo' ―quij―, in pararech, in jach yajech. A techo' ta qui'quin tin wore'. ");
INSERT INTO lacNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A jeroj tune', seb caj pay u ber Jesús ten u Taj'or u Pixam C'uj ca' xic ich tʌcay ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tiri' yʌn Jesús uch ich tʌcay ru'um quir u tumta' u yor ten Satanás, raji' u ts'urir a quisino'. Caj tumta'b u yor ten Satanás cuarenta q'uin. Caj tumta'b yor Jesús ten Satanás quir u yiric wa cu yacsic u si'pir. Ti' yʌn c'axir bʌc' tu yʌn Jesús, chen tarob u yʌjmasirob u t'ʌn C'uj quir u yamta'rob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chen caj ts'oc u c'ʌric Juan tu cu naj ma'cʌr mac, c'uchij Jesús ich u ru'umin quir u tsec'tic u jach tsoyir u t'ʌn a cu tar ich C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Raji' Jesús caj u ya'araj: ―Baje'rer, c'uchij tu q'uinin a caj u ya'araj C'uj uch. Baje'rer cu bin reyinbir C'uj, rajen c'axex a worex soc a p'ʌtiquex a c'asirex, ca wacsiquex ta worex a jach tsoyir u t'ʌn C'ujo'. ");
INSERT INTO lacNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A ray u q'uinino' tan u man Jesús ich u chi' c'ac'nab, u c'aba' u c'ac'nabir Galilea, jeroj caj u yiraj Simón yejer u yits'in Andrés. Tu chuquicob cʌy quire' ra' u beyajob. Cu chuquicob cʌy yejer yajow chim. ");
INSERT INTO lacNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Caj u ya'araj Jesús ti'ob: ―Sayenex tin pach quir in camsic techex in t'ʌn soc a manex a tsec'tex in t'ʌn ich a wet winiquirex judío. ");
INSERT INTO lacNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Seb caj u p'ʌtajob u chuc cʌyob, caj sayob tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wa ber caj bin mʌ' nachi', a jeroj caj u yiraj Jacobo, u parar Zebedeo, yejer Juan u yits'in Jacobo. Robob caj u chuyob u chimin u chuc cʌyob ich u chemob. ");
INSERT INTO lacNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","An ten bic caj u yiraj ti'ob, seb caj pay Jacobo yejer Juan ten Jesús. A jeroj tune', caj u p'ʌtajob u tetob Zebedeo ich chem yejer u c'urewo', caj sayob tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Caj c'uchob tu cajar Capernaum. Ber caj c'uchij tu q'uinin tu cu jesicob u bʌjob u winiquirob judío, caj oquij Jesús tu chan najir tu cu naj c'ujinticob C'uj u winiquirob judío. Caj oquij tu yʌnxchun u camsa'ob. ");
INSERT INTO lacNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A mac a ti' yʌnob a caj u yubob jach jaq'uij yorob an ten bic caj u camsaj ti'ob. Mʌ' ja wirej, Jesús caj u camsaj, jach noj u camsej mac. Mʌ' an ten bic yʌjcamsʌyʌjirob u t'ʌn Moisés. ");
INSERT INTO lacNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A ray u q'uinino' seb caj oquij ich u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío a mac aca'an quisin ti'e'. Raji' c'am caj u ya'araj: ");
INSERT INTO lacNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Ba' a c'at ti' a tenobo' Jesúsech a cu tar ich u cajar Nazaret? Tara'anech a ch'esiquenob, in werechob maquechi', a techo' a mac a cu tar ich C'uj, a techo' caj a ric'saj a wʌc'ʌs bʌjiri' soc C'uj yʌninech. ");
INSERT INTO lacNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús caj u q'ueyaj, caj u ya'araj: ―Nup a chi', ca' joc'aquech, ca' a p'ʌtej a je' xiba'. ");
INSERT INTO lacNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A c'ac'as quisino', caj u betaj ca' babanʌqui', jeroj tune' caj joq'uij ti', tan u c'am awʌt. ");
INSERT INTO lacNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A mac a ti' yʌnob ich u chan naj tu cu naj c'ujinticob C'uj u winiquirob judío jach manan rʌc jaq'uij yorob, rajen caj u pacran c'aticob ich u yet winiquirob judío: ―Ba'quiri' a jera', quij ya'ara'ob? Ba' u jer t'ʌn cu camsa'? Quire' cu camsa' an ten bic mac yʌn u muc'. Mʌ' ja wirej, a je' xiba', cax cu t'ʌnic a quisino', cu quibicob a ba' cu ya'ara'ob ti' ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Caj joc'ob a mac a ti' yʌnob ich u chan najir tu cu naj c'ujinticob c'uj u winiquirob judío seb caj u jumbintajob a ba' caj u yirob ich tu cotor u ru'umin Galilea, baxuc xan, caj u jumbintob a ba' caj u yubajob. ");
INSERT INTO lacNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wa ber caj ruq'uij Jesús ti' u chan najir tu cu naj c'ujintiob C'uj u winiquirob judío, yet binacob u camsʌwinicob. Yet binacob Jesús a Jacobo yejer Juan, bayiri' xan Simón Pedro yejer Andrés, a jeroj caj c'uchob tu yatoch Simón Pedro yejer Andrés. ");
INSERT INTO lacNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Barej u yixquit Simón Pedro characbar quire' jach ar u jo'r. Seb caj ara'b ti' Jesús yaj u yixquit Simón Pedro. ");
INSERT INTO lacNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","C'uchij tun, raji', caj u mʌchaj u c'ʌb caj u ric'saj, jeroj seb caj jaw, caj u yʌnxchun u jansa'rob. ");
INSERT INTO lacNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Tan u bin u q'uinin caj jach ac'bichʌjij tun. Tu cotor a mac a p'eri' u cajarob yejer Simón Pedro yejer Andrés caj c'uchob tu cu naj ocar mac tu yatoch Simón Pedro yejer Andrés. Caj tar purbirob a mac a jach yaj ich Jesús yejer a mac a aca'an ti' quisino'. Tiri' caj u rʌc much'quintajob u bʌj tu yʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Caj u jawsaj ya'ab mac yejer ya'ab u yajirir. Bayiri' xan, caj u joc'saj ti' mac a yʌn ya'ab u quisinino'. Mʌ' ju cha'bʌr u joc'ar u t'ʌnob ten Jesús quire' u jach erob jach raji' Cristo. ");
INSERT INTO lacNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","C'ʌs a'ac'bir mʌ' toy qui' sasichʌjʌqui' caj ruq'uij Jesús tu junan tu mʌna' mac soc u t'ʌnic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jesús cu man cʌxta'bir ten Simón Pedro yejer u yet camsʌwiniquirob. ");
INSERT INTO lacNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wa ber caj irir Jesús ten a mac tarob cʌxta'bir. Caj u ya'arob: ―Tu cotor mac cu cʌxtiquechob. ");
INSERT INTO lacNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Caj ya'araj ti'ob: ―Ca' xico'onex ich u jer cajarob a baytʌco' ca' in tsec'tej xan, quire' rajen ruq'uen ti' a ray cajaro'. ");
INSERT INTO lacNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesús rʌc man ich tu cotor u ru'umin Galilea cu yocar jujuntur tu chan najir tu cu naj c'ujinticob C'uj u winiquirob judío tiri' caj u tsec't u t'ʌn C'uj. Jujuntur u cuchir tu cu naj tsec'tic u t'ʌn C'uj tu oquij caj u joc'saj a mac aca'an u quisinin ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A mac a ju cʌnmʌn iq'uer u ca', c'uchij yicnʌn Jesús, caj xonrʌj caj u ya'araj: ―Wa ja c'ate', c'ucha'an a wor a jawsic iq'uer u ca' ten. ");
INSERT INTO lacNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús caj u tucraj ti', caj u nuncaj caj u ya'araj: ―In c'at ―quij Jesús―, jawen quen. ");
INSERT INTO lacNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A jeroj tune', seb caj jawij a iq'uer u ca' ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús caj u t'ʌnaj ca' xic tan u chich aric ti': ");
INSERT INTO lacNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Mʌ' a bin a wa'aric tu ca man bic jawech. Chen tar a bin ich sacerdote u winiquirob judío quir a sijic ti' a ba' caj ya'araj Moisés uch. Soc yerob tu cotor mac jawsa'bech ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Raji' mʌ' caj u yubaj a ba' ara'b ten Jesús, seb caj u toc rʌc araj ich u rac'ob. Caj yubob jaw a iq'uer u ca' ti'e'. Rajen Jesús mʌ' c'ucha'an yor u joc'ar ich tu cotor mac cax a ba' cajarob. Cu chen joc'ar tu mʌna' mac, cax ti' cu bin Jesús ti' rʌc c'uchob yicnʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mʌ' ya'ab u q'uinin caj wʌc'ʌs urij Jesús ich u cajar Capernaum. A jeroj caj yubob u juminta'b, ti' yʌn Jesús ich yatoch. ");
INSERT INTO lacNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Seb caj u much'quintajob u bʌj ich Jesús jach pim, cax tu cu naj ocar mac ich yatoch mʌ' u p'atar tu cu yocar mac quire' pech. A Jesúso' caj u tsec'taj u jach tsoyir u t'ʌn C'uj ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Caj tar purbirob yicnʌn Jesús a mac a mʌ' u ch'ictar. Mʌ' ya'ab caj tar purbirob cuatro xib tan u c'ochicob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Chen mʌ' c'ucha'an yorob u nats'arob yicnʌn Jesús quire' a pimo'. Tar nacob ich pach naj, caj u rʌc pa'aj u pach naj soc u yensʌ'r a mac a mʌ' u ch'ictar tu yicnʌn Jesús. Yej u tas caj emsa'b ich Jesús. Mʌ' ja wirej, mʌ' c'ucha'an yorob u yocarob ich naj tu yicnʌn Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","A Jesúso' caj u yiraj bic caj u yacsob tu yorob wa Jesús c'ucha'an yor u jawsic caj u ya'araj ti' a mac a mʌ' u ch'ictare': ―In yajech ―quij Jesús―, toc jaw a si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chen ti' yʌn mʌ' ya'ab yʌjcamsʌyʌjirob u t'ʌn Moisés ti' cura'anobi'. Tu yorob tu tucrajob ti' Jesús: ");
INSERT INTO lacNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Biquinin baxuc cu tsicbar a ray xibo'? A baywo' poch' u ca'. Je' wa ju ch'uchur u yor u jawsic u si'pir maque', chen u bʌjiri'o' C'uj c'ucha'an yor u jawsic mac?” ");
INSERT INTO lacNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chen seb caj u yubaj Jesús tu pixam a ba' tu mucu tucrajob, rajen caj u ya'araj ti'ob: ―Biquinin a baxuco' ca tucriquex ta pixamex? ");
INSERT INTO lacNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wa quin wac ti' a je' a mʌ' u ch'ictare': “Tin jawsaj a si'pir”, a techexo', mʌ' a werex wa yʌn in muc' ti' C'uj wa mʌ' yʌn in muc' ti' C'uj. Barej wa quin wac ti': “Riq'uen ca' xiquech”, je' a werex yʌn in muc' ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Caj ara'b ten Jesús ti' yʌjcamsʌyʌjir u t'ʌn Moisés: “Arej in wesej techex yʌn u muc' ten C'uj quir in jawsic u si'pir mac ich yoc'ocab quire' baxuquenechexo', quij.” Jesús caj u t'ʌnaj a mac a mʌ' u ch'ictare': ");
INSERT INTO lacNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Riq'uen ―quij―, ch'aj a tas ca' xiquech ich a watoch. ");
INSERT INTO lacNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A mac mʌ' u ch'itare' caj riq'uij caj u ch'aj u tas caj joq'uij ʌcʌtan tu cotor mac rajen tu cotor mac jach jaq'uij yorob caj u rʌc qui' t'ʌntajob C'uj: ―Jach caremech C'uj. Mʌ' biq'uin ij quiramʌnex a baxuc a jera'. ");
INSERT INTO lacNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Caj joc' Jesús caj bin ich u chi' c'ac'nab u c'aba' Galilea. Tu cotor a pimo' tarob tu yicnʌn Jesús, a jeroj tune', caj u yʌnxchun u camsic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Carique' tan u man wa ber caj u yiraj Leví, u parar Alfeo curucbar tu cuchir tu cu naj c'ʌmic u taq'uin gobierno romano. Caj pʌyir ten Jesús caj u ya'araj ti': ―Cux ―quij Jesús―, quir a cʌnic in t'ʌn. Caj riq'uij, caj bin tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pachir ti' yʌn Jesús ich yatoch Leví. Curucbar janʌn Jesús yejer u camsʌwinicob, yejer a mac a cu c'ʌmicob u taq'uin gobierno romano. Ti' yʌn xan, a mac a mʌ' patarob, p'eri'ob u janʌnob yejer Jesús. Quire' yʌn ya'ab mac cu sayob tu pach quir u cʌnicob u t'ʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","U camsʌyʌjirob u t'ʌn Moisés a fariseojo' caj u yirajob curucbar janʌn u ca' Jesús yejer a mac a cu naj c'ʌmicob u taq'uin gobierno romano yejer a mac a mʌ' patarob, caj u ya'arob ti' u camsʌwinicob Jesús: ―Biquinin a wʌjcamsʌyʌjirex ―quij ya'araj ti'― p'eri' u janʌnob yejer a mac a cu naj c'ʌmicob u taq'uin u gobierno romano, bayiri' xan, yejer a mac a mʌ' patarobe'? ");
INSERT INTO lacNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","A ber caj u yubaj Jesúse', caj u ya'araj ti'ob: ―A mʌ' yajo', mʌ' u c'atic ts'ac, quire' toc yʌn yor. A mac a yajo' ra' cu bin cʌxtic yo'och ts'ac. Rajen tareno'. Quire' taren in pʌyic a mac a yʌn u si'pirob ca' u c'axej tu yorob soc u p'ʌticob a c'aso'. Mʌ' taren in pʌyic a mac a cu ya'aricob mʌna' u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","U camsʌwinicob Juan yejer camsʌwinicob a fariseojo' tan u jamach p'ʌticob u janʌnob soc u qui' c'ujinticob C'uj. Caj tarob c'ata'bir ti' ten jun yarob mac caj u ya'arajob: ―Biquinin u camsʌwinicob Juan yejer u camsʌwinicob a farisejo' cu jamach p'ʌticob u janʌnob soc u qui' c'ujinticob C'uj, barej a camsʌwinicob mʌ' u jamach p'ʌticob u janʌnob quir u qui' c'ujinticob C'uj? ");
INSERT INTO lacNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús caj u ya'araj ti'ob: ―A mac a cu bin u ch'ic u raque', cu pʌyic u rac'ob quir u qui' qui' janʌnob. A tarobe', mʌ' tsoy wa cu tucricob. ");
INSERT INTO lacNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Barej wa cu c'uchur tu q'uinin cu bin, a tu ch'aj u raq'ue', jeroj a ray u q'uinino' cu bin u jamach p'ʌticob u janʌnob. Wa ber ca' bin xiquen a ray u q'uinino' jach jaj cu bin u jamach p'ʌticob u janʌnob in camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Caj u ya'araj Jesús: ―Mʌ' tsoy xan, ca' a xaxactiquex a ba' caj a cʌnex ti' a nunquirex yejer a ba' ca cʌniquex ti' ten. Mʌ' ja wirej, mʌna' mac cu jompʌc'tic u rabir u noc' yejer ric'ben. Cu mosar a ric'beno' cu jatar, cu cochtar. Jach carim u jorir u noc' u cochtar. ");
INSERT INTO lacNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bayiri' xan, mʌna' mac cu t'ajic u c'ab u wich uva ich u rabir yot'er chivo. Quire' ca' bin pajnʌc, cu bujur, hasta u rʌc wecar u c'ab uva. Cu rʌc jatar u yot'er chivo xan. A ric'ben u c'ab u wich uva, ca' u t'ajej ich ric'ben yot'er chivo soc mʌ' u bujur soc mʌ' u rʌc wecar u c'ab uva. ");
INSERT INTO lacNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ra' u q'uinin tu cu jesic u bʌjob u winiquirob judío, cu ch'ʌtob u cor mac Jesús, quet yejer u camsʌwinicob. Robob caj u tarob tu pach Jesús. U camsʌwinicob Jesús caj u jich'tajob u pʌc'ar u wich trigo, u jantejob quire' wichʌjob. ");
INSERT INTO lacNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A winiquirob judío a fariseojo' tun, caj u ya'arob ti' Jesús: ―Iric a camsʌwinicob. Biquinin cu jich'ticob u pʌc'ar u wich trigo u q'uinin tu cu jesicob u bʌj u winiquirob judío. Quire' cu beyajob tu q'uinin tu cu jesic u bʌjob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús caj u ya'araj ti' u winiquirob judío a fariseojo': ―Mʌ' wa ta xacajex tu ts'iba'an u t'ʌn C'uj ti' David uch ber caj wichʌjij David yejer u rac'ob uch? ");
INSERT INTO lacNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Caj oquij David yejer u rac'ob ich naj tu t'ina'an yot'er chivo quir u c'ujinticob C'uj u winiquirob judío. Caj ts'a'b yo'och pan ten a sacerdote. A ra u q'uinino' ti' yʌn u jach ts'urir sacerdote u c'aba' Abiatar. A jeroj tune', caj u jantajob David yejer u rac'ob quire' wichʌjob, cax mʌ' tsoy u jantic a caj ts'a'b ti' David ten sacerdote. Mʌ' ja wirej, ra' quir u ts'abʌr ti' C'uj, cu chen janticob a sacerdotejo'. ");
INSERT INTO lacNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bayiri' xan, caj u ya'araj ti'ob: ―Mʌ' ja wirej, u q'uinin tu cu jesic u bʌjob ra' beta'b ti' winic quir u jesic u bʌjob. Mʌ' beta'b winic ten C'uj ti' u q'uinin tu cu jesic u bʌjob. ");
INSERT INTO lacNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A teno', baxuquenechex, chen a teno' cu ts'uririntiquen tu cotor ba', inan a ba' cu yiric mac tu q'uinin tu cu jesicob u bʌj u winiquirob judío ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Caj wʌc'ʌs oquij Jesús ich u chan najir tu cu naj c'ujintiob C'uj u winiquirob judío ich u cajar Capernaum. Ti yʌn uch turiri' xib a mʌ' u jitir u c'ʌb. ");
INSERT INTO lacNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yʌn jun yarob u c'at u pac'ʌrob u pach Jesús rajen caj u qui'qui' pʌctob quir yiricob wa je' u jawsic mac tu q'uinin tu cu jesic u bʌjob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús tun, caj u ya'araj ti' a mac a mʌ' u jitir u c'ʌbo': ―Riq'uen ca' taquech chumuc tu yʌno'onex, soc chʌca'an yiriquech tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Caj u ya'araj ti'ob ―Yʌn ba' quir in c'atic techex ―quij Jesús―. Ba' cu cha'bʌr a to'onex ca' ic betex u t'ʌn Moisés tu q'uinin tu quic jesic ic bʌj u winiquirob judío? C'ucha'an yor mac u betic a ba' jach tsoy, wa c'ucha'an yor mac u betic a ba' c'as? C'ucha'an yor mac u yamtic mac u jer, wa c'ucha'an yor mac u quinsic mac? Barej a pimo' mʌ' ju nucobi'. ");
INSERT INTO lacNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús caj u rʌc pʌctaj yirej jujuntur, jach ts'ic u wich Jesús quire' caj u yiraj mʌ' ju tucrob a mʌ' u jitir u c'ʌb ten u yet winiquirob judío. Caj u yiraj jach chich u jo'rob. Caj u ya'araj ti' a mac a mʌ' u jitir u c'ʌbo': ―Tich' a c'ʌb ca'anan. A xibo' caj u tich' u c'ʌb seb caj toc qui' jaw u c'ʌb. ");
INSERT INTO lacNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Caj joc' tun u winiquirob judío a fariseojo' caj u much'quintob u bʌj yejer u yet winiquirob judío a cu ya'aricob herodiano quire' cu sayʌrob tu pach u rey Herodes. Caj u sebquintajob u much'quinticob u bʌj quir u p'eri'quintajob u tucurob quir u quinsicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Barej Jesús caj bin yejer u camsʌwinicob tu chi' c'ac'nab. Caj sayob tu pach ten Jesús a jach pim mac a tar u tarob tu ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bayiri' tarob ti' u ru'umin Judea yejer a mac a cʌja'anob tu cajar Jerusalén, yejer a mac a cʌja'anob pichir u ya'arir Jordán tu cu tar q'uin, yejer a mac a cʌja'an tu ru'umin Idumea, yejer a mac a cʌja'anob baytʌc tu cajar Tiro yejer u cajar Sidón. P'encʌch pim tarob yicnʌn Jesús quire' caj u yubob a ba' caj u betaj Jesús a ba' a mʌna' mac iramʌn biq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Quire' jach manan pim a mac a tarob rajen Jesús caj u ya'araj ti' u camsʌwinicob ca' u cʌxejob chem quir u yocar. Yubic cu maxʌr. Yiric cu rʌc nactanticob u bʌj ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mʌ' ja wirej, caj u yirob caj u jawsaj ya'ab mac rajen a mac a yajob cu nactanticob u bʌj ich Jesús caj u tʌrejob u noc' quir u jawʌr u yajiriro'. ");
INSERT INTO lacNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wa ber a mac a aca'an quisin ti' caj tarob caj u purajob u bʌj ʌcʌtan ti' Jesús, cu c'am awʌt tu cu ya'aricob: ―A techo' u pararech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Barej raji' Jesús caj u jach q'ueyaj quisin soc mʌ' u ya'aricob mac Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A jeroj tune', Jesús caj u nacajtaj u p'uc wits caj u pʌyaj a mac u c'at u pʌyic. Robob caj binob ti' quir u camsa'rob. ");
INSERT INTO lacNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Caj u tetaj doce xib soc ti' yʌnob tu yicnʌn, soc ca' bin tuchi'tacob ten Jesús quir u tsec'ticob u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bayiri' xan, ts'a'b u muc' ti'ob ten Jesús quir u joc'sicob quisin, bayiri' xan, ts'a'b u muc' ti'ob ten Jesús quir u jawsicob a mac a yajo'. ");
INSERT INTO lacNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A jera' u c'aba'ob a doce xibo' a teta'b ten Jesús. A jera' Simón a mac caj u ts'aj u c'aba' Pedro. ");
INSERT INTO lacNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","A jera' Jacobo u parar Zebedeo yejer Juan u yits'in Jacobo, ti' mac caj u ts'aj u jer u c'aba'ob Boanerges, u c'at ya'arique', U Parar A Cu Peco', quire' ts'icob. ");
INSERT INTO lacNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","A jera' Andrés, a jera' Felipe, a jera' Bartolomé, a jera' Mateo, a jera' Tomás, a jera' Jacobo, u parar Alfeo, a jera' Tadeo, a jera' Simón, a cu sayʌr tu pach cananista. ");
INSERT INTO lacNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","A jera' Judas Iscariote, a mac pachir caj u c'ubaj Jesús. Caj ts'oc u tetic Jesús ti'ob yet binacob tu yatoch. ");
INSERT INTO lacNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","U jer jach pim tarob rajen mʌ' u cha'bʌr u janʌn quire' jach pim cu tarob. ");
INSERT INTO lacNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Barej caj u yubajob u jach u bʌjob Jesús, rʌc tarob quir u chuquicob Jesús quire' cu ya'aricob uch: ―Jaj ix tʌcoj, mʌna' u yor a Jesúso'. ");
INSERT INTO lacNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bayiri' xan, u camsʌyʌjirob u t'ʌn Moisés a tar u tarob tu cajar Jerusalén. Pac' u pach Jesús ten u camsʌyirob u t'ʌn Moisés quire' caj u ya'arob wa aca'an quisin ti': ―Aca'an Beelzebú ti' mʌ' ra' ts'ic u muq'ui' u ts'urir quisin. U muc' u ts'urir quisin Beelzebú caj u joc'sej quisin. ");
INSERT INTO lacNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Rajen Jesús caj u t'ʌnajob ca' tacob u much'quinticob u bʌj caj u ya'araj ti'ob tu cu camsicob: ―A Satanáso' bic tabar u wʌc'ʌs bʌjiri' u joc'sic? Mʌ' c'ucha'an yor u joc'sic u wʌc'ʌs bʌjiri'. ");
INSERT INTO lacNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mʌ' ja wirej, wa ju wʌc'ʌs bʌjiri' cu bin ts'ictar ich u ru'umin tu cu reyinticob rey, je' u rʌc ch'esicob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Cax wa ju wʌc'ʌs bʌjob tu yatoch cu ts'ictarob je' u rʌc quinsicob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bayiri' xan, a quisino', u jach c'aba' Satanás, wa ju yet quisinin bin u joc'sejob, jeroj caj u toc ch'esob u bʌj, jeroj mʌna' quisin. ");
INSERT INTO lacNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Bic tabar in joc'sic quisin wa mʌ' tin yʌn ch'esaj u muc' u jach ts'urir quisin, Satanás? A baywo' ―quij Jesús―, c'ucha'an in wor in joc'sic quisin. Quire' aro' irej a mac a oquij ich yatoch a mac chich u muc' irej wa tu c'ʌxaj soc u rʌc ch'ic u ba'tac. ");
INSERT INTO lacNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Taj quin wa'aric techex, tu cotor u si'pirob bin jawsac ti' mac ten C'uj, cax a ba' poch'nʌjij uch bin jawsac ti' xan. ");
INSERT INTO lacNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Barej, a mac a cu p'astic u Taj'or u Pixam C'uj mʌ' biq'uin cu bin jawsabir u si'pir, munt q'uin sipnʌjij. ");
INSERT INTO lacNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Baxuc caj u ya'araj Jesús quire' yʌn jun yarob tus yarmʌnob uch: “Yʌn quisin ti' Jesús.” ");
INSERT INTO lacNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Caj tarob tun u yits'inob yejer u nʌ' Jesús, chen p'atob ich tancab yatoch tu yʌn Jesús, caj u tuchi'tajob t'ʌnbir. ");
INSERT INTO lacNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A ya'ab maco' ti' cura'anob yicnʌn Jesús, robob caj u ya'arajob ti': ―Iric, a nʌ' cu t'ʌniquech, ti' yʌn yejer a wits'inob ich tancab cu cʌxtiquech yiriquech a nʌ' yejer a wits'inob. ");
INSERT INTO lacNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús caj u nuncaj ti'ob tan ya'aric: ―Taj ca wa'aric ra' in nʌ' yejer in wits'inob. ");
INSERT INTO lacNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Caj u pʌctaj a jach ya'ab mac a cura'anob yicnʌn Jesúso', caj u ya'araj: ―A je'ra' irob in nʌ', a jera' irob in wits'inob. ");
INSERT INTO lacNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Quire' cax a mac a cu betic a ba' u c'at C'uj ra' irej in nʌ' ra' irej in jach its'inob. ");
INSERT INTO lacNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús caj wʌc'ʌs bin ich u chi'c'acnab u c'aba' Galilea caj u yʌnx chun u camsic bʌytʌc tu yʌn u chi'c'ac'nab. Jach ya'ab mac caj u much'quintob u bʌj yicnʌn Jesús rajen caj oquij ich chem a ti' yʌn ich c'ac'nab caj curajij. Tu cotor a mac ti' yʌnob ich ru'um tu chi' c'ac'nab. ");
INSERT INTO lacNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Caj u ya'araj ya'ab ba' tu cu camsa'rob. Tu cu camsa'rob caj u ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―U'yex a ba' quin camsic techex. Caj bin mac quir u pʌq'uic u pʌc'ar ich u cor. ");
INSERT INTO lacNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A mac caj bin u q'uich'intej ich u cor. Carique' caj u q'uich'intaj caj rub jun yar u pʌc'ar ich tam bej. Caj tar u ruq'uic ch'ich'. ");
INSERT INTO lacNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","U jer jun yar rub ich tunich tu mʌ' pim u ru'umin. Seb caj ts'ernʌj quire' jay u ru'umin, rajen seb caj joc'. ");
INSERT INTO lacNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Barej caj naquij q'uin caj quimij mʌ' tu bin ocac u mots, rajen quimij. ");
INSERT INTO lacNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","U jer jun yar caj u rʌc q'uich'intaj, caj rub ich q'ui'ix. Caj ch'ijij caj rʌc bobosta'b ten q'ui'ix mʌ' ju ts'ajaj u wich. ");
INSERT INTO lacNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","U jer jun yar caj u rʌc ca' q'uich'intaj ich u jer u ru'umin. Jach tsoy u ru'umin. Caj ts'ernʌj, caj ch'ijij, caj u nets'aj u wich. Cien caj u toc ts'aj u wich. U jer caj u ts'aj u wich sesenta. U jer caj u ts'aj u wich treinta. ");
INSERT INTO lacNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","U'yex ba' quin camsic techex soc a wu'yiquex, soc a najtiquex a ba' u c'at ya'aric. ");
INSERT INTO lacNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Caj ts'oc u camsa' ten Jesús caj u juts' u bʌj u doce camsʌwinicob Jesús tu yicnʌn, quet yejer a mac a ti' yʌnob bʌytʌc ti'. Caj ara'b ti': ―Biquinin ca camsic a pimo' bic tabar u q'uich'intic u pʌc'ar ich u cor? ");
INSERT INTO lacNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Caj u ya'araj ti'ob: ―Je' u ts'ic techex C'uj quir a najtiquex a ba' caj u mucu araj ten C'uj ti' Cristo. Chen a pimo' mʌ' ju bin u najtejob quire' mʌ' ju c'ʌmajob u t'ʌn C'uj. Tu chen so'soc u'yajob camsa'rob. ");
INSERT INTO lacNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Rajen, a mac a mʌ' yerob C'uj a cu yubicob in camsicob cu chen u'yicob cax cu yubicob mʌ' ju najtejob. Mʌ' bin u c'ʌ'oticob soc u yacsicob tu yorob soc u toca'rob ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Caj u ya'araj ti'ob: ―Mʌ' ja najtajex a je' ba' caj in camsajechex. Bic tabar ca bin a najtex tu cotor a ba' ca so'soc u'yiquex in camsiquechex? ");
INSERT INTO lacNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A mac a caj bin u q'uich'intic u pʌc'ar ich u cor raji' cu q'uich'intic u yijir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yʌn jun yarob mac ich tan bej tu cu q'uich'ita'r u t'ʌn C'uj, barej caj u yubob seb caj tar Satanás u taquic ti' mac u t'ʌn C'uj a ba' yubmʌni' soc mʌ' ju najticobi', irej u yijir a rub ich tan bej a caj in camsajechex sam. ");
INSERT INTO lacNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","U jer jun yarob mac, robob irob u yijir a q'uich'inta'b ich u tunich robob caj yubob u t'ʌn C'uj qui' yorob caj u c'ʌmajobi'. ");
INSERT INTO lacNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Quire' robob irej u yijir a mʌ' tam oc u mots. Seb caj u toc p'ʌtajob u t'ʌn C'uj caj yubajob u tumtaj u yorob. Caj yubajob u chucur u pachob quire' u t'ʌn C'uj, rajen caj u p'ʌtajob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","U jer jun yarob irob u yijir a q'uich'inta'b a rub ich q'ui'ix, robob a tu yubob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Chen a je' maca' cu tucric u t'ajar u ba'tac yejer u t'ajar u taq'uin yejer u beyaj. A ba' yʌn yoc'ocab cu pachtic, rajen bobʌsta' u t'ʌn C'uj soc mʌ' c'ucha'an yor u qui'quintic u yor C'uj irej q'ui'ix caj u bobʌstaj tu q'uich'inta'b. ");
INSERT INTO lacNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A rub yijir tu tsoy u ru'umin ra' quir u camsiquechex a mac a caj u jach c'ʌmaj u t'ʌn C'uj, caj u ts'aj u wich cien, ra' cu qui' man tu tsoyir. U jer caj u ca' ts'ajaj u wich sesenta, ra' cu man tu tsoyir chen mʌ' c'ucha'an yor ti' a caj u ts'aj u wich cien. U jer caj u ts'ajaj u wich treinta, ra' cu man tu tsoyir chen mʌ' c'ucha'an yor ti' a caj u ts'ajaj u wich sesenta. ");
INSERT INTO lacNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bayiri' xan Jesús caj u ya'araj ti'ob: ―Mʌna' mac cu yacsic u quib yaram u ch'ac, mʌ' ich yaram rec xan. Mʌ' ja wirej, cu t'ʌquintic ca'anan quir u yerc'ac'tic yatoch. Rajen a ba' cu camsic ti'ob irej wa t'ʌba'an u quib. ");
INSERT INTO lacNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bayiri' xan, tu cotor ba' a mucutaca'an tu cu bin u reyinticob C'uj baje'rer, ca' bin c'uchuc tu q'uinin je' u joc'ar u tajire'. Baxuc tu cotor mac je' u c'ʌ'otic ca' bin c'uchuc tu q'uinin je' u yubique'. ");
INSERT INTO lacNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","U'yex ba' quin camsic techex soc a wu'yiquex soc a najtiquex a ba' u c'at ya'aric. ");
INSERT INTO lacNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Caj u ya'araj ti'ob xan: ―Qui' u'yex soc mʌ' ju tubur techex a ba' ca wu'yiquex. Wa chichin ca wu'yiquex u t'ʌn C'uj chichin cu bin u camsic techex. Wa ya'ab ca wu'yiquex u t'ʌn C'uj jeroj ya'ab cu bin u camsic techex. ");
INSERT INTO lacNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A mac a yʌn u t'ʌn C'uj ti'e' u c'at u qui' najtic, C'uj cu bin u camsic ya'ab. Chen a mac ti', chichin u t'ʌn C'uj, mʌ' u c'at u qui' najtic, je' u p'ʌtique'. ");
INSERT INTO lacNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús tu cu camsic caj u ya'araj xan: ―Tu cu bin u reyinticob C'uj ra' irej tu cu man mac cu pʌq'uic u yijir ich ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Rajra' cu wenʌn, rajra' cu yajar, jeroj u man u q'uinin cu yiric a ba' u c'at. U yijir a caj u pʌc'aje' ts'ernʌj, jeroj cu ch'ijir. Chen mʌ' yer bic tabar u ch'ijiri'. ");
INSERT INTO lacNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mʌ' ja wirej, u bʌjiri' u ru'um tu junan cu ch'isic u yijir a pʌc'a'an ti', cu c'ʌs ch'ijire', cu joc'ar u re'. Cu ts'ocar u ch'ijire' cu jobar yi'ij. Cu jobar yi'ij cu tar u wich. ");
INSERT INTO lacNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cu tijire' seb cu jaq'uic quire' c'uchuc tu q'uinin u jaq'uic. ");
INSERT INTO lacNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús caj u ya'araj xan: ―An bic je' in quetquintic tu cu bin u reyinticob C'uj? An bic tabar je' in camsic techex? A ba' t'ʌnin quin wa'aric techex? ");
INSERT INTO lacNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","An ten bic u ch'ijir u pʌc'ar mostaza xib ich ru'um. Mʌna' u jer pʌc'ar jach ne mijin yijir mostaza. ");
INSERT INTO lacNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Cu ch'ijire' jach manan u xit'ir u c'ʌb. U jer pʌc'ar mʌ' u ne xit'ir u c'ʌb. Hasta ch'ijir u che'er a jeroj, cu tar ch'ich' u c'ʌxicob u c'u' ich u bo'oy. ");
INSERT INTO lacNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yejer jach ya'ab a je' camsa'bir u t'ʌn an ten bic a jera' caj u ya'araj ti'ob u t'ʌn hasta tu c'ucha'an yorob u najtejob. ");
INSERT INTO lacNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wa mʌ' yejer a camsa'bir t'ʌn mʌ' ju tsicbʌtej ti'ob ba', barej caj u toc araj tu cotor ba' ti' u camsʌwinicob caj bin tu junanob. ");
INSERT INTO lacNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ra'iri' u q'uinin caj bin q'uin caj u ya'araj Jesús ti' u camsʌwinicob: ―Cuxex tanxer ich c'ac'nab. ");
INSERT INTO lacNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Caj ts'oc u tuchi'tic a ya'ab maco', toc ti' yʌn chem caj toc oquij Jesús quet yejer u camsʌwinicob. Yet binacob u jer jun yarob chem. ");
INSERT INTO lacNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A jeroj caj tar ch'ic yum yic'ar, caj tar u yamin xan, tan u burur u chemin, tabar u jurur u chem. ");
INSERT INTO lacNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Raji'e', tan u wenʌn. Yʌn u c'anjo'r tu cu wenʌn ich yach chem. A'as Jesús ten u camsʌwinicob, caj u ya'arob ti': ―In wʌjcamsʌyʌjirechob, mʌ' wa ca tucriquenob? Tabar in jururob. ");
INSERT INTO lacNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Caj ajij Jesús caj u t'ʌnaj yic'ar ca' ch'enac: ―Xurej, ic' ―quij―. Mʌ' a tar. A jeroj, ch'en u tar yic'ar, caj ch'en u yamin c'ac'nab xan. ");
INSERT INTO lacNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús caj u ya'araj ti'ob: ―Biquinin tu jac'saj a worex, mʌ' wa ja wacsmʌnex ta worexi'? ");
INSERT INTO lacNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Caj u jach ch'aj ch'ic yum sajaquirob, caj u pacran arajob ich u yet camsʌwinicob: ―A mac a je' xiba' cu yuba'r u t'ʌn cax a ic'o' cax u yamin c'acnab cu quibicob u t'ʌn Jesús? ");
INSERT INTO lacNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Caj c'uchob pichir c'ac'nab Galilea, ti' u ru'umin a cu ya'aricob Gadarajo'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús tan tu joc'ar ich chem, a jeroj seb caj joc' tu t'aja'an u baquer u quimiriro' turiri' xib a mac aca'an quisin ti'e'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ti' cʌja'an ich tu t'aja'an u baquer u quimiriro'. Mʌna' mac c'ucha'an yor u c'ʌxic cax yejer mascab a irej sumo'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A ucho' chuquij ten u rac'ob caj c'ʌrij yoc yejer mascabir a irej sumo', bayiri' xan yejer u mascabir c'ʌb chen caj u p'icaj u mascabir c'ʌb caj u xexet'aj u mascabir yoc. Mʌna' mac c'ucha'an yor u suquintic quire' jach manan chich u muc'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","U burur ac'bir yejer u burur q'uin cu man uch awʌt u ca' ich tu t'aja'an u baquer u quimiriro', bayiri' xan, ich wits, bayiri' xan, cu man u c'ubic u bʌj yejer tunich. ");
INSERT INTO lacNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Barej caj u yiraj Jesús u tar nachir, ra' caj u c'ʌnaj yacab caj xonraj ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","C'am awʌtnʌjij caj u ya'araj: ―Ba' a c'at ten Jesús? A techo' u pararech C'uj a mac u C'ujir ca'anan. Quin chich c'atic tech tu quin chuquic C'uj, mʌ' a ts'ic ten in muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mʌ' ja wirej, baxuc caj ya'araj a mac a aca'an quisin ti'e' quire' sam ara'b ti' ten Jesús: ―Joq'uen ti' a maca' a techo' quisinech. ");
INSERT INTO lacNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sam caj u c'ataj ti' quisin: ―Ba' a c'aba'? Caj u nuncaj, tan ya'aric: ―Legión in c'aba'. Mʌ' ja wirej, pimenob aca'anenob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Rajra' tan u c'ata' ti' Jesús ten a mac a aca'an quisino' mʌ' u tuchi'ta'rob tanxer ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mʌ' nenach tu yʌn Jesús yejer u camsʌwinicob, ti' yʌn yʌrʌc' cajij q'uec'ʌn, jach pimob. Cu manob u janʌnob xiw ich p'uc wits. ");
INSERT INTO lacNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Caj u chich c'atajob ti' tu cotor a quisinobo' a aca'anob ich a ray xibo' tan ya'aricob: ―Arej in binob ich a ray cajij q'uec'ʌnob quir in ca' wocarob ich a ray q'uec'ʌnob. ");
INSERT INTO lacNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Seb cha'b ti'ob ten Jesús, a jeroj caj joc'ob a quisinob caj ocob ich cajij q'uec'ʌnob. Tu cotor a cajij q'uec'ʌno' caj u c'ʌnajob yacab tu ch'inca'an wits caj u rʌc purob u bʌj ich c'ac'nab caj rʌc quimij. Dos mil q'uec'ʌn caj quimij. ");
INSERT INTO lacNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Rʌc puts'ob tun, a mac a cu cʌnanticob yʌrʌc' cajij q'uec'ʌn quire' jaquij yorob. Jeroj caj binob u jumintejob ich u cajarob, bayiri' xan ich mac a ti' yʌnob tu corob. Caj joc'ob u yirob a ba' u ber ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Caj rʌc c'uchob yicnʌn Jesús. Caj u yirajob a mac a aca'an ti' a quisino' Legión uch, a jeroj caj u yirajob curucbar u buquinmʌn u noc', baje'rer yʌn yor xan, robob caj u ch'ajob sajquir. ");
INSERT INTO lacNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A yʌj'irirob caj u tsicbʌtajob ba' u ber ti' a mac a aca'an quisin ti'e' Legión u c'aba' uch, bayiri' xan, a ba' u ber ti' a cajij q'uec'ʌno'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Rajen caj yʌnxchun u ya'aricob ti' Jesús ca' xic Jesús nachir soc mʌ' ti' yʌni'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús caj u yocar ich chem caj c'uchij a mac a aca'an quisin ti'e' a Legión u c'aba' uche', caj u chich c'ataj ti' ca' xic tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Barej a Jesúso' mʌ' ju chaj u tar tu pachi' barej caj u ya'araj ti': ―Xen ich a watoch ich a bʌjob. Xen jumintej an ten bic caj in yajquin tech. Arej yubej u jach carem beyaj caj u betaj C'uj ti' tech. Arej yubej bic joc'sa'b tech quisin ten Jaj Ts'ur. ");
INSERT INTO lacNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A ray xibo' a joc'sa'b u quisinino' caj joc' caj yʌnxchun u tsicbʌtic u ru'umin Decápolis tu cotor ba' a beta'b ti' ten Jesús. Tu cotor mac a caj u yubajob caj jaq'uij yorob. ");
INSERT INTO lacNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Barej Jesús caj u wʌc'ʌs ch'ʌctaj a c'ac'nabo' ich chem tanxer pichir. Tiri' ich chi' c'ac'nab caj u much'quintajob u bʌj a pimo' ich yicnʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Caj c'uchij turiri' xib u jach ts'urir u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío, Jairo u c'aba'. Barej caj u yiraj Jesús caj tar p'uxtar ʌcʌtan Jesús ich yoc. ");
INSERT INTO lacNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Caj u chich c'ataj ti', tan ya'aric: ―Cojen ―quij―, jawsej in chan parar xquic quire' tabar u quimin. Cojen ca' a ts'anc'ʌbtej ca' jawac, soc u cuxtar. ");
INSERT INTO lacNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Caj bin Jesús yejer raji', barej jach pim caj sayob tu pach Jesús, cu rʌc nactanticob u bʌj yicnʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tiri' ich a pimo' a sayob tu pach Jesús ti' yʌn turiri' xquic. Mʌ' u tsoytar uch. Yʌn manij doce yaxq'uin caj u cʌnaj u yajir. ");
INSERT INTO lacNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Cax ts'acʌc ten a mac a yerob ts'ac mʌ' u tsoytar quire' aro' caj u rʌc xupaj u taq'uin yejer u ba'tac, barej mʌ' yamta'bi' chen cu jach qui' c'astar. ");
INSERT INTO lacNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A ray xquico' caj u yubaj tsicbʌta'r Jesús. Caj c'uchij ich u pimʌn a yaje' caj tar tu pach Jesús caj u tʌraj u noc' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Quire' cu ya'aric: ―Wa quin tʌric u noq'ue', chen u noc' quin tʌrique', je' in tsoytare'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Seb caj ts'oc u tʌric u noc' Jesús tsits u q'uiq'uer a xquico', caj u yubaj tu winquirir caj jawij. ");
INSERT INTO lacNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jeroj seb caj u yubaj Jesús caj u jawsaj u yajir mac quire' caj u yubaj u bin u muc' caj ts'oc u tarʌr u noc'. Jeroj caj u sut u bʌj caj u pʌctaj a pimo', caj c'ata'b ti': ―Mac, tʌr in noc'? ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","U camsʌwinicob Jesús caj u ya'arajob ti': ―Iric a jach pim mac a cu nactanticob u bʌj ta wicnʌn, biquinin ca wa'aric: “Mac tʌr in noc'?” ");
INSERT INTO lacNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús raji' caj u pʌctaj a mac a u bʌc'rismʌnobi' Jesús quir yiric a mac tʌr u noc'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A xquic tuno', sajacchʌjij cu quiquirʌncʌr quire' yer ba' u ber tu winquirir caj u nʌts'aj u bʌj yicnʌn Jesús caj xonrʌj caj u ya'araj ti' tu cotor jach jaj. ");
INSERT INTO lacNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús caj u ya'araj ti': ―Xquic, quire' caj a wacsaj ta wor ti' ten rajen jawech. Xen in jach yajech ca' qui'ac a wor. Ca' qui' tsoyaquech. ");
INSERT INTO lacNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mʌ' toy ts'ocaqui' u tsicbar Jesús, jeroj caj c'uchob jun yarob mac yicnʌn Jairo, ti' u tarob ich yatoch Jairo u jach ts'urir u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío, caj tarob caj u ya'arajob: ―Quimij ―quij ya'ara' ti' Jairo― a chan parar xquic. Tsire'ej, cax mʌ' u tar a wʌjcamsayʌjir. ");
INSERT INTO lacNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Barej seb caj u yubaj Jesús rajen caj u ya'araj ti' Jairo: ―Mʌ' a ch'ic sajaquir, chen acsej ta wor ten. Yʌn tsire'ej ya'aricobe' quim a chan parar xquique'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mʌ' ju chaj u bin mac tu pach Jesús, chen Pedro bin tu pach Jesús yejer Jacobo yejer Juan, u yits'in Jacobo. ");
INSERT INTO lacNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Caj c'uchob taro' tu yatoch u jach ts'urir u chan naj tu cu naj c'ujinticob C'uj u winiquirob judío caj u yiraj jumrac yoc'arob quire' cu yac'ticob. ");
INSERT INTO lacNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Caj ts'oc u yocare' caj u ya'araj ti'ob: ―Biquinin a jumrac a woc'arex? A teno' quin wiric wenʌn u ca', cax a techexo' ca wiriquex quimen a chan xquico'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Caj p'asta'b Jesús ten a mac a ti' yʌnob tu yatoch Jairo quire' yerob jach quimij a chan xquico'. Barej raji'e' caj ts'oc u rʌc joc'sic tu cotor mac tancab, caj acsa'b u tet yejer u nʌ' a chan xquico' yejer a mac a yet taracobe' caj ocob tu quimen a chan xquico'. ");
INSERT INTO lacNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesús caj u mʌchaj u c'ʌb a chan xquico' caj u ya'araj ti': ―Talita cumi ―u c'at ya'aric: Chan xquic quin wa'aric tech, riq'uen. ");
INSERT INTO lacNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Seb caj riq'uij a chan xquico', caj yʌnxchun u ximbar quire' yʌn doce yaxq'uin ti' uch. Seb caj jaq'uij yorob, jach manan caj jaq'uij u yorob. ");
INSERT INTO lacNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Barej raji' caj u jach chich araj ti'ob: ―Mʌ' a yʌn aquex ti' mac. Caj u ya'araj ca' ts'abac u janʌn a chan xquico'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Caj joq'uij ich Jairo caj bin tu jach cajar. Yet binacob u camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Caj c'uchij tu q'uinin tu cu jesicob u bʌj u winiquirob judío caj oc tu chan najir tu cu naj c'ujinticob C'uj u winiquirob judío caj oc quir u camsic ti'ob. Ya'ab mac a caj u yubobe', jʌprʌj u chi'ob quire' a ba' camsa'bob. Caj u ya'arajob: ―A tub u tar ti' a ray xibo' a je' ba'ra'? Bic tabar ts'a'b u tucur a ti'e' a mʌ' c'ucha'an yor u betaj a ba' a mʌna' mac yiramʌn, mʌ' biq'uin uch a cu jac'ar u yor mac. ");
INSERT INTO lacNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A ray xibo' mʌ' wa ra' cu susche' uchi', u parar María, u sucu'un Jacobo José, Judas yejer Simón? Mʌ' wa ti' yʌnʌnob xan tu yʌno'onex u yits'inob a xquicob? Rajen mʌ' ju sʌjtajobi' cu p'uspachticob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Barej Jesús caj u ya'araj ti'ob: ―U yʌjtseq'uir u t'ʌn C'uj, a ts'a'b u tucure' ten C'uj quir u tsicbar a ba' u c'at C'uj mʌ' u c'at yirir ten yet cajarob tu jach cajar. Cax u wʌc'ʌs u bʌjob mʌ' u c'at yiricob. Chen a mac cʌja'an nach u c'at yubicob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A taro' mʌ' c'ucha'an yor u betic a ba' mʌna' mac yiramʌnob uch mʌ' biq'uin chen caj u jawsaj jun yarob a mac a yajo'. Caj u ts'anc'ʌbtaj quir u jawarob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A Jesuso' jac'a'an yor ti'ob quire' mʌ' ju yacsajob tu yorob. Pachir Jesús caj c'uchij tu chan cajarob a rʌc bʌca'an ti' u jach cajar Jesús, caj u camsaj ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jeroj, caj t'ʌnaj yicnʌn u doce camsʌwinicob, caj yʌnxchun u tuchi'ticob ca'ca'turi', caj u ts'ajaj u muc' ti'ob quir u joc'sicob u quisininob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Caj u jach araj ti'ob: ―Mʌ' a ch'iquex bar ich a ber. Chen xomte' ca ch'iquex, baxuc chim mʌ' a ch'iquex. Baxuc a woj wajex mʌ' a ch'iquex, baxuc a taq'uinex mʌ' a ch'iquex ich u poxajir a taq'uinex. ");
INSERT INTO lacNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Chen a pech' xʌnʌb ca ch'iquex, baxuc turiri' a noq'uex a ch'iquex. ");
INSERT INTO lacNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Caj u ya'araj ti'ob: ―Wa ber ca' bin acsaquechex ich naj ca' p'ataquechex hasta ca joc'arex ca ca' binex. ");
INSERT INTO lacNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wa ca c'uchurex ich mac a mʌ' u c'at u yacsiquechex a mʌ' u c'at u yubicob a t'ʌnex, ca' joc'aquechex ti' taro'. Puxtex u noy ru'um ta woquex soc yerob yʌn u si'pirob quire' mʌ' u c'atob yubejob a t'ʌnex. Jach taj quin wa'aric ti' techex, a ray maco' ich a ray cajaro' jach manan ca' bin muc'yajnʌcob tu q'uinin u xur t'ʌn, chen a mac a cʌja'anob uch tu cajarjob Sodoma yejer u cajar Gomorra mʌ' nejach bin muc'yajnʌcobi'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jeroj, u doce camsʌwinicob caj joc'obe' caj u tsec'tajob ti' mac ca' u c'axej u yorob ca' u p'ʌtejob u c'asir tu cu manob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bayiri' xan, caj u joc'sajob ya'ab quisin tu aca'anob ich mac, caj u jic'tajob tsats quir u jawʌr mac a yajo', jach ya'ab jawij. ");
INSERT INTO lacNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Baje'rer caj u yubaj rey Herodes u tsicbʌticob u c'aba' Jesús a Herodeso' rajen ya'ab mac tus pac' Juan a cu yacsic ja' tu jo'r: ―Tin t'ʌn ―quij―, wʌc'ʌs riq'uij tu quimirir Juan rajen c'ucha'an yor u betic a mʌna' mac yirmʌnob uch, mʌ' biq'uin yirmʌnob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Chen u jerob juninta'b yubej, caj u ya'arajob: ―Raji' Elías u yʌjtseq'uir u t'ʌn C'uj a ts'a'b u tucuric ten C'uj uch. U jerob caj u ya'arajob: ―Raji' yʌjtseq'uir u t'ʌn C'uj a ts'a'b u tucuric ten C'uj quir u tsicbʌtic a ba' u c'at C'uj rajen raji' irej yʌjtseq'uir u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Barej caj yubaj Herodese', caj u ya'araj: ―Raji' Juan, a mac a tin ch'ʌcaj u car uche', raji' riq'uij tu quimirir. ");
INSERT INTO lacNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mʌ' ja wirej, raji' Herodes caj u tuchi'taj mʌcbir Juan caj u c'ʌraj tu cu naj mʌquic mac. Tiri' tu mʌcaj, quire' Herodías u rac' u sucu'un Felipe. Mʌ' ja wirej, Herodes caj u ch'aj u rac' u sucu'un. ");
INSERT INTO lacNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mʌ' ja wirej, caj u ya'araj uch ti' Herodes: ―Mʌ' tsoy a taquic u rac' a sucu'un quire' ra' u toc ch'amʌn a sucu'un. ");
INSERT INTO lacNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A Juano' p'acta'b ten Herodías rajen cu ch'uctic quire' u c'at u quinsej barej mʌ' c'ucha'an u yor ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mʌ' ja wirej, Herodese' sajʌc ti' Juan quire' yer raji' turiri' xib a mac taj yor, a mac a mʌ' u naj man tu c'asir, rajen cu cʌnanta' Juan soc mʌ' u quinsa'. Tenten caj yubaj cax tucurnʌjij quire' tsoy yubic tu xiquin a ba' tsec'ta'b ten Juan. ");
INSERT INTO lacNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jeroj, c'uchij tu q'uinin Herodías cu pajic quir u quinsic Juan. Raji' u q'uinin u c'aba' u rey Herodes, ber cu c'ʌ'oticob u q'uinin caj rocha'b Herodes ten u nʌ' uch. Rajen caj u pʌyaj tu qui'qui' janʌnob u jach ts'urirob a cu yamticob u rey Herodes tu cu reyinticob. Yet payacob a mac u ts'urirob u soldadojob yejer a mac a neyʌn u taq'uino' tu ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Barej caj oc tun u parar xquic Herodías, oc'atnʌjij tu cuchir tu cu naj qui'qui' janʌnob u rey Herodes yejer u rac'ob. Jach tsoy tu wich u rey Herodes yejer a mac a curucbarob tu cu qui'qui' janʌnob. Rajen caj u ya'araj a reyo' ti' u parar xquic Herodías: ―C'atej ten, cax a ba' a c'at, a teno' je' in ts'ic teche'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Caj u ya'araj: ―C'uj cu yiric ―quij Herodes―. Tu cotor ba' ca' a c'atej tene' je' in ts'ic teche' tac tan chumuc u ru'umin tu quin reyinticob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Caj joc' raji' u xquic u parar Herodías, caj u ya'araj ti' u nʌ': ―Ba' quin bin in c'atej? U nʌ' tune', caj ya'araj: ―Ra' a catej u jo'r Juan a cu yacsic ja' tu jo'r mac. ");
INSERT INTO lacNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Seb caj wʌc'ʌs sutnʌjij tu yicnʌn rey Herodes caj u c'ataj, cu ya'aric ti': ―In c'at ca' a ts'ic ten baje'rer u jo'r Juan a cu yacsic ja' tu jo'r mac, ca' a ts'a ten turiri' u rʌquir quir in pe'ic. ");
INSERT INTO lacNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mʌ' jach qui' yor a rey Herodese', tu chen tucric, barej quire' caj u ya'araj: “C'uj cu yiric”, bayiri' xan, quire' yubob ya'aric tu cotor mac a cu qui'qui' janʌnob rajen yʌn u ts'ic ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Seb a reyo' caj u tuchi'taj turiri' u soldado a cu cʌnantic a reyo' soc ca' tac purbir u jo'r Juan. ");
INSERT INTO lacNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Raji' caj bine' caj u ch'ʌcaj u car Juan tu cu naj macar mac, caj bin u purej u jo'r ich turiri' u rʌquir quir u pe'ic. Jeroj, caj u c'ubaj ti' a ray xquico' u parar Herodías aro' tune' caj u ts'ajaj ti' u nʌ'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Barej u camsʌwinicob Juan caj u yubob a ba' u ber, tarob u ch'a'ob u baquer Juan caj u t'ajaj ich turiri' tu cu naj t'ojar u baquer mac. ");
INSERT INTO lacNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A mac a tuchi'ta'b ten Jesús uch quir u tsec'ta'r u t'ʌn, caj urob caj u much'quintajob u bʌj yicnʌn Jesús, caj u tsicbʌtajob ti' tu cotor ba' a caj u betob uch, bayiri' xan, yejer a ba' caj u camsob uch. ");
INSERT INTO lacNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Raji' tune', caj u ya'araj ti'ob: ―Cuxex ich tʌcay ru'um quir a je'siquex a bʌj. Mʌ' ja wirej, ya'ab mac cu tarob bayiri' xan, cu binob, rajen mʌ' je'erarob mʌ' quir u man u janʌnob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","P'eri'ob caj rʌc ocob ich chem quir u binob ich tʌcay ru'um. U tiriri' ti' caj binob soc tu junʌnob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Irob u binob ten ya'ab mac, caj c'ʌ'ota'bob ten a ya'ab maco'. Rajen caj joc'ob ti' tu cotor u cajarob soc u binob ti' taro' xan, caj u c'ʌnajob yacab. Ra' bat'an c'uchob a ya'ab maco'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Barej caj joc' Jesús ich chem, caj u yiraj ya'ab mac toc c'uchob, rajen caj yajquinta'bob quire' irob a tʌmʌn yucobo' a mʌna' yʌjcʌnanyʌjir tʌmʌn yuc. Jeroj tune', caj yʌnxchun u camsic ya'ab ba' ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tabar u bin q'uin, caj tarob u camsʌwinicob tu yicnʌn caj ya'arajob: ―Chen tʌcay ru'um a tera' mʌna' mac cʌja'an cu bin q'uin cabar. ");
INSERT INTO lacNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tuchi'tabo' ca' xicob ti' corob, cax ti' u chan cajarob a rʌc bʌca'anob a tera', ca' u mʌnejob yo'och waj quir u janʌnticob quire' mʌna' ba' caj u jantob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Caj u nuncaj Jesús, caj u ya'araj ti'ob: ―Ts'ajex yo'och quir u janʌnob ―quij. Caj u ya'arajob ti': ―Je' wa jin mʌnicob yo'och a ya'ab maco' ca' in jʌsejob ti'ob. Mʌ' ja wirej, mʌ' nupa'an u bo'orir yo'ochob, quire' baxuc u bo'orir u beyaj mac turiri' yaxq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús caj u ya'araj ti'ob: ―Joq'uenex irex mun pan yʌn techex. Caj ts'oc u yiricobe', caj u ya'arajob: ―Yʌn cinco pan yejer ca'tur cʌy. ");
INSERT INTO lacNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Caj u ya'araj ti'ob u binob u cutarob jujumuch'ob ich su'uc. ");
INSERT INTO lacNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","P'eri' rʌc curajob u tirir ti' junmuch' cura'anob. U tirir ti' caj u cuquintajob junmuch' curicob cincuenta. U jer junmuch' curicob cien. ");
INSERT INTO lacNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jeroj tune', Jesús caj u ch'aj a cinco pano' yejer a ca'tur cʌye', caj u pʌctaj ca'anan caj u ya'araj: “Bayo' C'uj ti' ij co'ochex.” Jeroj caj u xat'aj a pano' caj u ts'aj ti' u camsʌwinicob quir u ca' ts'a'icob ʌcʌtan a pimo'. Bayiri' xan, caj u jʌsaj ti' tu cotor mac a ca'tur cʌye'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Rʌc janob caj najchʌjob xan. ");
INSERT INTO lacNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pachir caj u wʌc'ʌs marajob doce xacob chup yejer u xet'er pan yejer a cʌyo'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A mac a caj u jantob a pano' cuch cinco mil xibob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesús caj u ya'araj ti' u camsʌwinicob: ―Ca' xiquechex ich chem soc a bat'an c'uchurex ich u cajar Betsaida a ti' yʌn pichir c'ac'nab. Quire' raji' cu tuchi'tic a ya'ab macobo'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Caj ts'oc u tuchi'ticobe' caj bin ich turiri' p'uc wits quir u t'ʌnic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Barej caj ac'birchʌjij, a chemo' ti' yʌn uch te' ich tan chumuc c'ac'nab. Raji' tune', p'at Jesús tu junan ich ru'um. ");
INSERT INTO lacNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús caj u yiraj jach chich tu cu babticob a chemo' quire' caj u nup'ob ic', rajen caj tar Jesús tu yicnʌnob tan u ximbar yoc'or a c'ac'nabo'. Jach tabar u sastar caj u yirajob u tar. Jesús u c'at u man pʌybej. ");
INSERT INTO lacNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","U camsʌwinicob Jesús tune', caj u yirajob tan u ximbar yoc'or a c'ac'nabo' caj u tucrajob quisin cu tar, caj awʌtʌjob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Quire' tu cotor caj u yirajob, caj u ch'aj saquirob, jeroj, seb t'ʌnob, caj ya'araj ti'ob: ―Chichquintej a worex ten ―quij―, mʌ' a ch'iquex sajaquir ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Caj naquij yicnʌnob ich a chemo', caj ch'en u tar yic'ar. U camsʌwincob Jesús bin yorob quire' jach manan jac'a'an yorob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Quire' mʌ' ju c'ʌ'otajob tu yorob u muc', cax caj u yirajob u t'ajʌr a pano' quire' jach chich u jo'rob. ");
INSERT INTO lacNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Barej caj c'uchob tanxer ru'um tarob tu ru'umin Genesaret, caj u macob a chemo'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Barej caj joc'ob ti' a chemo' seb c'ʌ'ota'b Jesús ten a maco'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Caj acabnʌjob ti' tu cotor a ti' cʌja'anob ich a ru'umo' quir u tarob purbir yicnʌn Jesús a mac a yajo'. Caj yʌnxchun u tarob u puricob a mac yajo' ti' ch'ac, jaj ix tʌco caj u yubob ti' yʌn uche'. ");
INSERT INTO lacNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jaj ix tʌco te' cu yocarobe' cax wa ju chan cajarob wa ju yajaw cajarob, cax wa ju corob, robob cu tarob purbir mac a yajo' ti' tu cu naj mʌnicob yo'och, tiri' cu chich c'aticob ca' u tʌrejob cax u yoquir u noc'. Tu cotor mac a caj u tʌrobe', jeroj jaw. ");
INSERT INTO lacNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Caj much'rʌjob yicnʌn Jesús a ju winiquirob judío a fariseojo' yejer jun yarob yʌjcamsʌyʌjirob u t'ʌn Moisés. Ti' cu tarob tu cajarob Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","A rayo' caj u yirajob jun yarob u camsʌwinicob Jesús rajra' caj u jantob waj, u c'at ya'aric, mʌ' u p'o'ob u c'ʌbob, rajen caj u pʌc'aj u pachob. ");
INSERT INTO lacNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mʌ' ja wirej, a winiquirob judío a fariseojo' yejer tu cotor u winiquirob judío cu naj p'o'icob u c'ʌbob wa mʌ' u p'o'icob u c'ʌbob mʌ' u janʌnob quire' a ba' ara'b ti'ob ten u nunquirob uch. ");
INSERT INTO lacNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Barej cu yurob tu cu naj mʌnicob yo'och wa mʌ' u p'o'icob u bʌj mʌ' ju janʌnob. Yʌn u jer ya'ab ba' caj u naj cʌnajob ti' u nunquirob an ten bic ca' u p'o'ej u ruchir tu cu yuc'ur. Ca' u p'o'ej u p'urir u yo'och ja'. Ca' u p'o'ej u ruchir a mascabo'. Ca' u p'o'ej u ch'ac tu cu wenʌn. ");
INSERT INTO lacNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rajen u winiquirob judío a fariseojo' yejer a yʌjcamsʌyʌjirob u t'ʌn Moisés caj u c'atajobi': ―Biquinin a camsʌwinicob mʌ' u cuxtarob an ten bic cu naj camsicob ic nunquirex barej rajra' cu janʌnob? ");
INSERT INTO lacNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Caj u nuncajob raji'e', caj ya'araj ti'ob: ―Ca'tur a tucurechex a techexo'. Jach taj caj u tsec'taj Isaías ti' tu cotorechex quire' raji' ts'a'b u tucuric ten C'uj quir u ts'ibtic a ba' u c'at C'uj rajen caj u ts'ibtaj: A je' maca', quij C'uj, cu tusaricob: “Quin sʌjticob C'uj”, chen a tu pixamob cu ya'aricob: “Je' wa jin sʌjticob C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","A C'ujo' cu ya'aric: “Ba' wir cu chen c'ujintiquenob wa mʌ' u quibicob in t'ʌn? Mʌ' ja wirej, chen u t'ʌn winic cu quibicob quire' robob cu camsicob u t'ʌn winic irej wa ju t'ʌn C'uj cu camsicob.” Baxuc caj u ts'ibtaj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Biquinin ca p'ʌtiquex u t'ʌn C'uj quir a qui' cʌnantiquex u t'ʌn a nunquirirex an ten bic u p'obar ruch. Ca' u p'o'ej u ruchir tu cu yuc'ur ca betiquex xan ya'ab u jer ba' an ten bic a jera'. ");
INSERT INTO lacNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Caj u ya'araj ti'ob xan: ―Ca wa'ariquex xan, mʌ' patarex u t'ʌn C'uj ti' techex, chen a nunquirexo' ca qui' cʌnantiquex u t'ʌn. Ca toc ts'ocsiquex a ba' yarmʌnex a nunquirex uch. ");
INSERT INTO lacNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Biquinin Moisés caj u ya'araj uch: “Ca' a sʌjtex a tet yejer a nʌ'. Wa c'as cu tsicbar ti' u tet, ti' u nʌ' xan, cu joc'sa' quinsbir”, quij Moisés uch. ");
INSERT INTO lacNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Barej a techexo', ca wa'ariquex: Wa turiri' parar cu ya'aric ti' u tet wa ti' u nʌ': “Tu cotor ba' a ten yʌnin a ca pajiquex u yamtiquechex uche' raji' Corbán”, u c'at ya'aric in toc sijmʌn ti' C'uj; ");
INSERT INTO lacNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","rajen mʌ' tan a cha'iquex u parar u betic u jer ba' quir u yamtic u tet wa ju nʌ'. ");
INSERT INTO lacNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A baywo' ca c'asquintiquex a ba' ara'b ten C'uj quire' ca qui' cʌnantiquex a ba' naj camsa'bechex ten a nunquirex quir a wʌc'ʌs masiquex ti' a pararex. Baxuc ca betiquex ya'ab u jer a ba' an ten bic aro'. ");
INSERT INTO lacNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Caj u wʌc'ʌs t'ʌnaj tu cotor a ya'ab macobe', caj ya'araj ti'ob: ―U'yex ba' quin wac ―quij―, ch'aj a najtex. ");
INSERT INTO lacNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mʌna' ba' a cu jantic mac a cu yasic u si'pir, jari' a ba' cu betic, wa ba' cu ya'aric, ra' cu yacsic u si'pir mac. ");
INSERT INTO lacNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","U'yex a ba' quin camsic techex soc a wu'yiquex soc a najtiquex a ba' u c'at ya'aric. ");
INSERT INTO lacNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Barej caj oquij Jesús tu japnin naj caj u p'ʌtaj a ya'ab macobo', jeroj tune', caj c'ata'b ti' ten u camsʌwinicob Jesús ba' quiri' caj ts'oc a camsiquenob. ");
INSERT INTO lacNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Caj u ya'araj ti'ob: ―Mʌ' wa qui' ca tucriquex ba'? A ba' cu jantic mac mʌ' ra' cu yacsic u si'piri'. ");
INSERT INTO lacNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Quire' a yo'ocho' mʌ' u yocar tu tucur mac chen ich u nʌc', pachir cu joc'ar tu chocher. A baywo' Jesús caj u ya'araj tsoy u janta' ten a mac a yacsmʌnob tu yorob tu cotor yo'och. ");
INSERT INTO lacNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Barej caj u ya'araj: ―Mʌna' ba' a cu jantic mac cu yacsic u si'pir, jari' a ba cu betic, wa ja ba' cu ya'aric, ra' cu yasic mac u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Quire' ich u tucur mac cu joc'ar a ba' cu yacsic u si'pir mac. Mʌ' ja wirej, tu tucur cu joc'ar a c'as u tucuro', tu tucur cu tucric u pʌyic xquic wa yʌn u mam cax wa mʌna' u mam. Tu tucur cu tucric u pʌyic xib a yʌn u raq'ue', cax a mʌna' u raq'ue'. Tu tucur cu tucric u quinsic mac, rajen cu quisic. Tu tucur cu tucric u ya'cric u ba'tac mac, rajen cu ya'cric. ");
INSERT INTO lacNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Tu tucur cu tucric u pachtic a ba' yʌn ti' u jer mac. Tu tucur cu tucric ba', rajen cu pachtic a xquico' wa ja xibo'. Tu tucur cu tucric ba' rajen cu tus aric mac. Tu tucur cu tucric ba', rajen cu q'uextar yor. Tu tucur cu tucric ba', rajen cu pʌq'uic u pach mac. Tu tucur cu tucric ba', rajen mʌ' u c'ʌmic u t'ʌn C'uj. Tu tucur cu tucric ba', rajen mʌ' u c'ujintic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tu cotor a ray c'aso' cu joc'ar tu tucur mac, rajen cu yacsic u si'pir mac. ");
INSERT INTO lacNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Barej caj ruq'uij taro' caj bin tu ru'umin Tiro yejer u ru'umin Sidón. Caj c'uchij caj oquij ich naj. Mʌ' u c'at yerta' wa ti' yʌn ten a ya'ab macobo', barej mʌ' c'ucha'an yor u taquic u bʌj Jesús soc mʌ' yirir. ");
INSERT INTO lacNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tu juminta' yubej ti' yʌn Jesús ich naj, caj c'uchij xquic yicnʌn Jesús, caj u puraj u bʌj ich u yoc Jesús quir u sʌjta'. Raji' yʌn turiri' u chan parar xquic a mac aca'an quisin ti'e'. ");
INSERT INTO lacNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A xquico' griego u t'ʌn, chen raji' ti' naj cʌja'an tu ru'umin sirofeniciajo'. Caj u chich c'ataj ti' ca' joc'sac a quisino' ti' u chan parar xquic. ");
INSERT INTO lacNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Barej Jesús caj u ya'araj ti': ―Ca' yʌn bat'an janac u pararob quir u nachajʌrob. Mʌ' tsoy u puric u yo'och u pararob ti' a chan pec'obo'. ");
INSERT INTO lacNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A xquico' caj u nuncaj, tan ya'aric ti': ―Taj a ba' ca wac Jaj Ts'urir ―quij―, cax cu jantic yaran pojche' tu cu jutur u p'up'ir yo'och a chan pararob. A chan pec'o' cu janʌn yaram pojche' tu cu jutur u p'up'ir. ");
INSERT INTO lacNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jeroj tune', caj u ya'araj ti': ―Quire' a je' t'ʌna' ―quij―, ca' xiquech, toc jaw a chan parar xquic ti' u quisinin. ");
INSERT INTO lacNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Caj wʌc'ʌs ur tu yatocho' caj u yiraj u chan parar xquic characbar ich u ch'ac, toc joc'sa'b u quisinin. ");
INSERT INTO lacNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús caj joq'uij tu ca'ten ti' u ru'umin Tiro caj u ch'ʌctaj u ru'umin Sidón caj c'uchij tu c'ac'nabir Galilea. Caj u ch'ʌctaj tan chumuc u ru'umin Decápolis. ");
INSERT INTO lacNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jeroj caj tar purbir ti' turiri' xib, a mʌ' u joc'ar u t'ʌne', a mʌ' u yubej t'ʌn xan. Caj u chich c'atajob ti' ca' u ts'anc'ʌbtej ti' quir u jawʌr. ");
INSERT INTO lacNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","U tiri' ti' caj u pʌyaj Jesús a mac a macar u xiquine' soc mʌ' p'eri' tu yʌn a ya'ab macobob. Jeroj caj u ts'aj yar u c'ʌb tu xiquin a mac a mʌ' u yubic t'ʌne', caj tubnʌjij Jesús, caj u tʌraj u yac' xan. ");
INSERT INTO lacNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Caj u nacsaj u wich ca'anan caj u putaj yic', caj u ya'araj ti': ―Efata, u c'at ya'aric: Ca' jepʌjʌc a xiquin ―quij ya'ara' ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jach seb jaw a mʌ' u yubej t'ʌn. Tsoyjij u yac' caj qui' t'ʌnʌj ich u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Caj u maquintaj ti'obe': ―Mʌ' a yʌn ariquex ti' mac. Cax caj u chen maquintaj ti'ob ya'ab tu jen tsicbʌtajob. ");
INSERT INTO lacNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jach jaq'uij yorob tun, cu ya'aricob: ―Jach tsoy tu beta'r tu cotor, cax inan a mʌ' u joc'ar u t'ʌn cu jawsique', cu joc'ar u t'ʌn a macar u xiquine'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A ray u q'uinino', caj ts'oc u much'quinticob ya'ab macob. Mʌna' yo'och pan bin u jantobi'. Jesús caj u t'ʌnaj u camsʌwinicob tu yicnʌn, caj u ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Quin yajquintic a ya'ab macoba' chen ts'oc u man mʌna' u nup u q'uinin ti' yʌnob yejerenob baje'rer, u yo'ochob tu rʌc xupajob. ");
INSERT INTO lacNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wa quin tuchi'ticob ca' xicob tu yatochobe' je' u rubur u muc'ob ich beje' quire' wi'ij. Mʌ' ja wirej, yʌn jun yarob ich a ya'ab macoba' nach tub u tarob. ");
INSERT INTO lacNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","U camsʌwinicob caj u nuncajob ti': ―Je' wa ju c'uchur yor mac ich a je' tʌcay ru'uma' ca' u na'ajquintej yejer yo'och pan a je' ya'ab macoba'? Mʌ' ja wirej, mʌna' mac te' cʌja'anoba'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Caj u c'ataj ti'ob: ―Mun pan yʌn techexi'? Robobe' caj u ya'arajob: ―Siete pan yʌn a tenobi'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Caj u ya'araj ti' a ya'ab macobo' ca' curacob ich ru'um. Jeroj caj u ch'aj a siete pano' caj u ya'araj: “Bayo' C'uj quire' caj a ts'aj to'onex ij co'ochex”, jeroj tune', caj u xat'aj caj u ts'aj ti' u camsʌwinicob quir u ts'icob ʌcʌtan a ya'ab macobo'. Robob tune' caj u ts'ajob ʌcʌtan a ya'ab macobo'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yʌn xan ti'ob jun yarob majʌn cʌyob, jeroj caj u t'ʌnaj C'uj: “Bayo' C'uj quire' caj a ts'aj to'onex ij co'och cʌyex”, caj u ya'araj ti' u camsʌwinicob ca' ts'abac xan ʌcʌtan a ya'ab macobo'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Caj janobe' caj na'ajchʌjob, jeroj tune', caj u marajob u xet'er, caj u marajob siete xac chup yejer u xet'er. ");
INSERT INTO lacNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A mac janobo' tac cuatro mil. Jeroj tune', caj u ya'araj ti'ob ca' xicob tu yatochob. ");
INSERT INTO lacNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Seb caj oquij yejer u camsʌwinicob ich chem, caj c'uchob tu ru'umin u c'aba' Dalmanuta. ");
INSERT INTO lacNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Caj c'uchob a winiquirob judío a fariseojo' caj yʌnxchun u nunquicob a ba' cu tsicbar Jesús, caj u c'atob ti' u esacob ti' ca'anan a ba' mʌna' mac yiramʌn uch mʌ' biq'uin yiramʌn. Mʌ' ja wirej, cu tumticob u yor Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Caj ts'oc yubic ya'ara' ti' ten u winiquirob judío a fariseojo' caj u putaj yic', caj u ya'araj: ―A techexo', a mac cuxa'anob tu q'uinin baje'rer ca c'atic tenex ca' in wesej techex a ba' a mʌna' mac yiramʌn uch mʌ' biq'uin yiramʌn. Jach taj quin wa'aric techex mʌ' biq'uin quin bin in wesej ti' techex a ba' a mʌna' mac yiramʌn uch a mʌ' biq'uin yiramʌno'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jeroj tune', caj u p'ʌtajobe', caj wʌc'ʌs oc ich chem caj bin tanxer ru'um pichir c'ac'nab. ");
INSERT INTO lacNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","U camsʌwinicob Jesús tu'ub ti'ob uch u ch'icob yo'och waj, Chen turiri' yo'och waj caj u ch'aj ich chem. ");
INSERT INTO lacNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Caj u camsaj ti'ob tan ya'aric: ―Qui' cʌnantechex a bʌjex ti' a ba' cu camsic techex u winiquirob judío a fariseojo' yejer a ba' cu camsic techex a mac u yajob u bʌj Herodes. A ba' cu camsicob irej a pʌj sʌcʌno'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","U camsʌwinicob Jesús caj u pacran t'ʌnajob ich u yet camsʌwinicob caj ya'arob: ―Ra' ix ti' cu ya'aric quire' mʌna' to'onex waj quir ic janʌnex. ");
INSERT INTO lacNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús caj u c'ʌ'otaj u tucurob caj u ya'araj ti'ob: ―Biquinin ca pacran t'ʌniquex a bʌjex quire' tub techex a ch'iquex a wo'och panex? Biquinin mʌ' a toy c'ʌ'otiquex biquinin mʌ' a toy najtiquex? Taquij u q'uinin baje'rer chich a jo'rex. ");
INSERT INTO lacNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yʌn a wichex biqinin mʌ' a wiriquex ba'? Yʌn a xiquinex biquinin mʌ' a wu'yiquex t'ʌn? Mʌ' wa c'aj techex? ");
INSERT INTO lacNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Barej caj in xat'aj a cinco yo'och pan ich a cinco mile' mun xac chup yejer u xet'er caj a marajex? Robob caj u nuncajob: ―Doce xac caj in marob. Jesús caj u wʌc'ʌs c'ataj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Barej caj in xat'aj yo'och pan yejer cʌy ich a cuatro mile', mun xac chup yejer u xet'er caj a marex? Robob caj u nuncajob: ―Siete xac caj in marobi'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Caj u ya'araj ti'ob: ―Biquinin mʌ' toy a najtajexi'? ");
INSERT INTO lacNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús yejer u camsʌwincob caj c'uchob tu cajar Betsaida. Caj tar purbir ti' turiri' ch'op u wich, caj u chich c'atajob ti' ca' u tʌrej quir u jawʌr u wich. ");
INSERT INTO lacNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Caj u mʌchaj tun u c'ʌb a chop u wicho' caj u joc'saj tancab tu cajar tu yʌnob. Caj tuba'b u wich, caj u ts'an c'ʌb tu boxer u wich caj u c'ataj ti': ―Ca wiric wa ba'? ―caj c'ata'b ti' ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A ch'op u wicho' caj pacatnʌjij caj u ya'araj: ―Quin wiric a maco' an ten bic che', barej quin wiric u manobe' irej che' cu manob. ");
INSERT INTO lacNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Seb wʌc'ʌs ts'anc'ʌbtaj yoc'or u boxer wich caj u pacat, jeroj qui' tsoyquinta'b u wich, cax nach cu qui' yiric tu cotor. ");
INSERT INTO lacNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Caj u tuchi'taj u yatoch, caj u ya'araj ti': ―Mʌ' a yʌn bin a wa'arej ich a je' cajara'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Caj joc' Jesús yejer u camsʌwinicob, caj binob ich u cajarob nʌts'a'an, u cajar u c'aba' Cesarea Filipo. A ich bejo' caj u c'ataj ti' u camsʌwinicob, caj ya'araj ti'ob: ―Caj u jumintajob a wu'yajex, ba' cu ya'aricob ten, a macobo'? ");
INSERT INTO lacNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Robob caj u nuncajob: ―Juanech ―quij―, a cu yacsic ja' tu jo'r mac bin. U jerob cu ya'aric, Elíasech. U jerob, cu ya'aric jaj ix ti' yʌjtseq'uirech u t'ʌn C'uj a ts'a'b u tucuric ten C'uj quir u tsicbar a ba' u c'at C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Raji' tune' caj u ya'araj ti'ob: ―Ten wa ca waquenex? Pedro tune', caj u nuncaj caj u ya'araj ti': ―A techo', raji' Cristojech caj u tuchi'tajech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Raji' caj ara'b ti'ob ten Jesús: ―Mʌ' a yʌn bin a wa'ariquex ti' mac wa Cristojen. ");
INSERT INTO lacNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jeroj tune', caj yʌnxchun u camsic ti'ob bin in caj bat'an muc'yaj a teno' baxuquenechexo'. Bin u ca'ob u xurp'ʌtiquenob u jach ts'urirob u winiquirob judío, a nuxibo' yejer u jach ts'urirob sacerdote u winiquirob judío yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Bin in caj quinsbir barej ca' bin manac mʌna' u nup u q'uinin bin in caj wʌc'ʌs riq'uir quir in cuxtar. ");
INSERT INTO lacNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tu qui' toc rʌc araj ti'ob quir u najticob. Caj pay Jesús ten Pedro soc u tiri' cu tsicbar caj u majquintaj Pedro caj ya'araj: ―Mʌ' a yʌn aric a quinsa'. ");
INSERT INTO lacNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Raji' tune', caj u sutaj u bʌj caj u pʌctaj u camsʌwinicob caj q'ueya'b Pedro ten Jesús caj ya'araj: ―Joq'uen Pedro irech a quisino' a Satanáso' ―quij Jesús―. Mʌ' a p'usic in wor ―quij Jesús―. Mʌ' quet a wor yejer C'uj, quet a wor yejer a xibo' Pedro. ");
INSERT INTO lacNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Caj u t'ʌnaj ya'ab macob yejer u camsʌwinicob, caj u ya'araj ti'ob: ―An ten bic ten ca' bin muc'yajnʌquen ich in cruz. Baxuc techex ca' bin muc'yajnʌquechex quire' caj a c'ʌmajex in t'ʌn cax ca quiminex ich a cruzex. Baxuc xan, ca' a p'ʌtex a ba' ca pachtiquex ta worex wa ja c'atex a cʌniquex in t'ʌn ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Quire' a mac a mʌ' u c'at u taquic u cuxtar ti' u rac'ob tu cu chucurob u pach ten u rac'ob, quire' caj u yacsaj tu yor ti' in t'ʌn, bayiri' xan, quire' u jach tsoyir u t'ʌn C'uj, ra' cu bin taquic u pixam. ");
INSERT INTO lacNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Cax chen toc yʌn a ba'taquex ich yoc'ocab chen wa cu sa'tar a pixamex jeroj tune', ba' wir a ba'taquex ich yoc'ocab? ");
INSERT INTO lacNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Je' wa ju c'uchur u yor u bo'otic u pixam yejer u ba'tac wa yejer u taq'uin? Mʌ' biq'uini', c'ucha'an yor u bo'otic. ");
INSERT INTO lacNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wa mac cu ch'ic suraquir ten yejer a ba' quin tsec'tic, quire' a je' cuxa'anob mac baje'rer, a cu naj acsicob u si'pirob, bayiri' xan, ti' a je' cuxa'anob mac, a cu naj manob, baxuc ten ca' bin in ch'a'ej suraquir ti', quire' a teno' baxuquenechexo'. Quin bin in ch'ic suraquir ti' ca' bin taquen ich u sasirir C'uj in Tet yejer u muc' u yʌjmasirob u t'ʌn C'uj ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Caj u ya'araj ti'ob xan: ―Chen taj quin wa'aric ti' techex, yʌn jun yarob ich mac a tera' mʌ' u bin quimin hasta cu yiric bic C'uj cu bin u reyintic yejer u chichir u muc'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ti' yʌn Jesús uch ich u cajar Cesarea de Filipo tuj u camsaj ti'ob u camsʌwinicob. Caj manij seis u q'uinin Jesús caj u pʌyaj Pedro yejer Juan yejer Jacobo. Caj binob ich u jo'r wits tu ca'anan u jo'r witsir. Chen robob pay ten Jesús. Ʌcʌtan u camsʌwinicob Jesús caj waysa'b Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Caj waysa' u noc' bajen u ba' ja', sʌc t'ina'an u noc', baxuc jach cha'aj u noc'. Mʌna' mac c'ucha'an yor u p'o'ic u noc' an ten bic a ray sʌco'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Seb irir ixbaj Moisés yejer ixbaj Elías ten u camsʌwinicob a mʌna' u nupo'. Cu tsicbarob yejer Jesús caj irir ten u camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro caj u t'ʌnaj caj u ya'araj ti' Jesús: ―Jaj Ts'urir ―quij―, jach tsoy te' yʌno'onexa' tera'. Arej in chan tʌsej paser, u tirir ti' tech, u tirir ti' ixbaj Moisés, u tirir ti' ixbaj Elías. ");
INSERT INTO lacNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mʌ' ja wirej, jach jac'a'an yorob u camsʌwinicob rajen Pedro caj ya'araj aro' quire' mʌ' ju qui' tucraj a ba' caj u ya'araj. ");
INSERT INTO lacNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Quire' cu tsicbar Pedro caj tarij turiri' u muyʌrir caj bobʌsta'b ten u muyʌrir caj joc' u t'ʌn C'uj ti' a ray u muyʌriro', tan ya'aric: ―A je' in jach parar in jach yaj. Ca' u'yex u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Seb caj u sut u bʌj pacatnʌjobe' mʌ' ju wʌc'ʌs irob mac yicnʌnob, chen Jesús yʌn. ");
INSERT INTO lacNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Quire' cu yemanob ich u jo'r p'uc wits caj u chen qui' araj ti'ob soc mʌ' ju ya'arob a ba' ts'oc u yiricob hasta ca' bin riq'uiquen tin quimirir a teno' a baxuquenechex. ");
INSERT INTO lacNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tu chen quibajob a ba' ara'b ti'ob ten Jesús, chen cu chan ber sʌjʌj t'ʌnob tan u ya'aricob: ―A ba' u c'at ya'aric a ca' bin wʌc'ʌs riq'uic tu quimirir? ");
INSERT INTO lacNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Caj u c'atajob ti', tan ya'aricob: ―Quire' tech caj a wa'araj tenob, mʌ' in yʌn bin in wa'aricob wa caj in wirob ixbaj Elías yejer ixbaj Moisés. Biquinin cu ya'aricob yʌjcamsʌyʌjirob u t'ʌn Moisés: “Raji' cu bat'an bin tar Elías uch quir u pʌyic u ber Cristo soc pachir cu tar a Cristojo'”? ");
INSERT INTO lacNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Caj u nuncaj raji'e', caj u ya'araj ti'ob: ―Taj ―quij Jesús―. Elías cu yʌn bat'an tar uch quir u pʌyic u bej Cristo soc u c'axicob yorob soc u rʌc p'ʌticob u c'asir u winiquirob judío. Chen arex ten biquinin u ts'iba'an t'ʌn C'uj cu tsicbar ca' bin muc'yajnʌquen a teno' a baxuquenechexo', bayiri' xan ca' bin u xunp'ʌtenob ten u jach ts'urirob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A teno' ―quij Jesús―, quin wa'aric techex toc tarij Elías, bayiri' xan, robob caj u betob ti' tu cotor a ba' caj u pachtajob tu yorob an ten bic ti' ts'iba'an ich u t'ʌn C'uj ti' raji' a ba' u ber. ");
INSERT INTO lacNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Caj urob Jesús ich u jo'r wits yejer u mʌna' u nup camsʌwinicob caj tar tu yicnʌn a ju camsʌwinicob a p'atobo'. Caj urob Jesús yejer mʌna' u nup u camsʌwinicob jeroj caj u yiraj rʌc bʌcrista'b ten ya'ab macob. A yʌjcamsʌyʌjirob u t'ʌn Moisés cu nunquicob u t'ʌn yejer u camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A ray u q'uinino' tune', caj irir Jesús ten a ya'ab macob caj jaq'uij u yorob caj u c'ʌnajob yacab tu yicnʌn quir u rʌc t'ʌnicob. ");
INSERT INTO lacNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Raji' caj u c'ataj ti'ob: ―Biquinin ca nunquiquex u t'ʌnob a yʌjcamsʌyʌjirob u t'ʌn Moisés? ");
INSERT INTO lacNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Caj u nuncaj turiri' ich a ya'ab macobo', caj u ya'araj: ―In wʌjcamsʌyʌjirech, taren in puric in parar tech quire' aca'an quisin ti', rajen mʌ' u joc'ar u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ca' bin chucuc purbir in parar ten quisin tu cu bin man, cu rubsic ru'um, cu yomancʌr u chi', cu jʌch'ic u coj, cu tochtar u winquirir rajen jach mʌna' u muc' xan. Caj in wa'araj ti' a camsʌwinicob ca' u joc'sejob ti'e', barej mʌ' c'ucha'an yorob u joc'sej. ");
INSERT INTO lacNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Caj u nuncaj Jesús caj u ya'araj ti'ob: ―A techexo' a mac a cuxa'anechex u q'uinin baje'rer, am biquinin mʌ' a wacsic ta worex? A mun u q'uinin yʌn in p'atʌr ta wicnʌnex quir a wacsic ta worex? Joq'uen ch'a'ej ten. ");
INSERT INTO lacNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tabar u nats'ʌr ich Jesús, barej caj irir Jesús ten a quisino', jeroj seb tit'ab a pararo', caj rub ru'um caj bʌcrʌnʌjij caj omnʌj u chi'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Caj c'ata'b ti' u tet ten Jesús: ―Ber ocac quisin ti' a parar? Caj u nuncaj u tet: ―Tu chichanin caj oc quisin ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ya'ab u tenin cu purur ich c'ac' bayiri' ich ja' quir u quinsic. Barej wa c'ucha'an a wor a betique', joc'sej a quisino'. Yajquintenob ―quij u tet u parar―, yʌm tenob. ");
INSERT INTO lacNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús tun, caj u ya'araj ti': ―Wa je' u c'uchur a wor a wacsic ta wore', tu cotor c'ucha'an yor ti' mac a cu yacsic tu yoro'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jeroj tune', seb caj c'am t'ʌnaj u tet a pararo', caj u ya'araj: ―Quin wacsic tin wor, wa mʌ' ti'ti' yam ten. ");
INSERT INTO lacNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Barej caj u yiraj Jesús, cu tar yacabob tu yicnʌn a ya'ab macob, jeroj Jesús caj u q'ueyaj a quisino', tan ya'aric ti': ―A techo' a mʌ' a cha'ej u t'ʌn, bayiri' a mʌ' a cha'ej u yubic t'ʌn. A teno' quin wa'aric tech, joq'uen ti', bayiri' xan, mʌ' a wʌc'ʌs ocar ti' a chan pararo'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Caj awatnʌjij a quisino' seb caj tita'b, caj joc' ti', caj p'at an ten bic mac a quimene', rajen ya'ab macob caj u ya'araj: “Jeroj quimij, quij.” ");
INSERT INTO lacNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Barej Jesúse' caj u mʌchaj u c'ʌb, caj u ric'saj caj ch'iraj. ");
INSERT INTO lacNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Barej caj oc ich naj, u camsʌwinicob caj u c'atajob ti' tu junan: ―Biquinin a tenobe' mʌ' c'ucha'an in worob in joc'sicob a quisinobi'? ");
INSERT INTO lacNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Caj u ya'araj ti'ob: ―Wa ja c'atex ca' a joc'sex baxuc a baywo' ca' a t'ʌniquex C'uj tu ca jamach p'ʌtiquex a janʌnex. ");
INSERT INTO lacNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Caj ts'oc u ruc'urob ti' taro', caj manob tu ru'umin Galilea. Mʌ' ju c'at wa mac u yerob wa ti' yʌni'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Quire' cu camsic u camsʌwinicob caj u ya'araj ti'ob uch: ―Quire' bin u caj c'ubiren a teno' ti' mac a cu p'actiquenob a teno' a baxuquenechexo'. Bin quinsaquen ten a ray xibobo', barej ca' bin ts'ocac in quimene' bin in caj cuxtar ca' bin manʌc mʌna' u nup u q'uinin. ");
INSERT INTO lacNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","U camsʌwinicob Jesús mʌ' ju najtob a ba' ara'b ti'ob ten Jesús, tu cu camsic ti'ob, sajacchʌjob u c'aticob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Caj c'uchob tu cajar Capernaum. Quire' ti' yʌnob ich naj caj u c'ataj ti'ob: ―Ba' ca sʌjʌj ariquex ich a bej? ");
INSERT INTO lacNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Barej, robobe' mʌ' tu nuncajob, quire' ich bej cu nunquicob u t'ʌnob soc yerob mac jach no'j ich u yet camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Barej caj curaj Jesús tune', caj u t'ʌnaj a docejo' caj u ya'araj ti'ob: ―Wa mac u c'at bin pʌyber arej u bin pachir soc raji' u c'urewinta'r ten tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jeroj caj u ch'a'aj turiri' chan parar quir u ch'iquintic tan chumuc tu yicnʌnob, caj u mec'aj, caj u ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Wa tsoy ca betiquex ti' a je' chichana', cax ti' u jer xan, quire' ca yajquintiquenex. Tsoy ca betiquenex ten xan. Baxuc tsoy ca betiquex ti' C'uj a mac a caj u tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Caj u t'ʌnaj Juan, tan ya'aric ti': ―In wʌj camsʌyʌjirech, caj in wirob turiri' mac cu joc'sic quisin. Cu t'ʌnic a c'aba'. Caj in wa'arob: “Tsire'ej”, quire' mʌ' u sayʌr ta pach quir u cʌnic a t'ʌn, an ten bic a tenob quin sayʌrob ta pach. ");
INSERT INTO lacNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús caj u ya'araj: ―Tsire'ej, cax mʌ' a wa'ariquex ti' quire' mʌna' mac c'ucha'an yor u betic tsoy tin c'aba' wa ca' bin ts'ocaque' cu bin u p'astic in c'aba'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Quire' a mac a mʌ' u p'actico'onex cu yamtico'onex. ");
INSERT INTO lacNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taj quin wa'aric techex, wa mac je' u ts'ic techex turiri' ruch ja' quir a wu'q'uiquex quire' caj a wacsaj ta worex ti' Cristo, quin wa'aric techex mʌ' u bin satʌr u bo'orir tu cu ts'ic a woj ja'ex. ");
INSERT INTO lacNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús caj u ya'araj ti'ob: ―A mac a cu yacsic u si'pir u rac'ob a tu cʌnaj chichan a caj u yacsaj tu yor. Arej jach manan tsoy ca' u jich'ej ich u car yejer yajaw ca'. Ca' u purej u bʌj ich c'ac'nab quire' caj u toc pʌyaj u si'pir u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","46","Rajen quin wa'aric techex: Xonch'ʌtej a c'ʌb wa raji' cu pʌyic a si'pirex. Cax a woc wa raji' cu pʌyic a si'pirex. Cax bujuch c'ʌbech cax bujuch oquech soc a taquic a bʌj soc mʌ' a bin tu ca werarex ich c'ac' munt q'uin yejer ca'tur a c'ʌb, bayiri' xan soc mʌ' a bin tu ca werarex ich c'ac' munt q'uin yejer ca'tur a woc. Mʌ' ja wirej, ti' taro' u noq'uer bʌc' mʌ' u quimin, mʌ' biq'uin a c'ac'o' u tupur. ");
INSERT INTO lacNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Baxuc xan, a wichex. Wa raji' cu pʌyic a si'pirex rʌquej a wichex, jach manan tsoy ca' ocaquechex bujuch ichechex tu cu bin u reyintic C'uj wa quet yejer ca'tur a wichex cu bin u puriquechex ich tu cu yerar mac. ");
INSERT INTO lacNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tu yʌn noc'or bʌc' mʌ' u quimin, tu mʌ' u tupur a c'ac'o'. ");
INSERT INTO lacNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Caj ya'araj Jesús ti'ob: ―A ʌrʌc'o' a cu sijic u winiquirob judío ti' C'uj tabta'an cu toquic ich c'ac'. Bayiri' xan, cu bin tumta'bir yor a mac a cu sayʌr tin pach. Cu bin tumta'bir yor ten a mac a cu chuquic u pach a cu sayʌr tin pacho'. Cu bin tumta'bir yor mac soc yiric wa taj cu yacsic tu yor. ");
INSERT INTO lacNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tsoy yʌn u xa'anin, chen wa cu ruc'ur u xa'anin, mʌ' ch'o'ochi'. Taj ca c'ʌmejex u t'ʌn C'uj soc irechex xa'an. Ca' sisac a worex yejer a rac'obex. ");
INSERT INTO lacNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Caj ruq'uij ti' taro' caj tar tu cu xur u ru'umin Judea caj u ch'ʌtaj ya'arir u c'aba' Jordán. A ya'ab macobe' caj u wʌc'ʌs much'quintajob u bʌj tu yicnʌn Jesús. Jeroj tune', caj u yʌnxchun u wʌc'ʌs camsic ti'ob an ten bic cu nanij u camsic ti'ob uch. ");
INSERT INTO lacNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Caj c'uchob u winiquirob judío a fariseojo' yicnʌn Jesús, caj u chich c'atajob ti' quir u tumticob yor, wa tsoy turiri' mam u p'ʌtic u rac'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Barej Jesús caj u nuncaj, caj u ya'araj ti'ob: ―Ba' yarmʌn techex Moisés uch? ");
INSERT INTO lacNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Robobe' caj u ya'arajob: ―A Moisése' ara'b u ts'ibtej u ju'unin quir u p'ʌtic u rac'. Ca' bin ts'ocac u ts'ibtic u ju'unin jeroj tsoy u p'ʌtic. Baxuc ara'b ten Moisés. ");
INSERT INTO lacNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Caj u nuncaj Jesús, caj u ya'araj ti'ob: ―Barej caj u ts'ibtaj techex a ra' t'ʌno' caj u ts'ibtaj quire' caj u yiraj jach chich a jo'rex. ");
INSERT INTO lacNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Barej u ch'ic chunin ber caj beta'b ich yoc'ocabe', ra' u q'uinin caj beta'b tu cotor a ba', caj ara'b ich u t'ʌn C'uj: “Xib yejer xquic caj beta'b ten C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Rajen juntur a xibe' bin u p'ʌtej u tet yejer u nʌ' quir u p'eriquintic u bʌj yejer u rac'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","A ca'turo' ca'che' tu p'eri'quintaj u bʌjob.” Rajen robob mʌ' ca'turobi' chen turiri' yʌn. ");
INSERT INTO lacNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Rajen a ba' p'eriquinta'b ten C'uj mʌ' tsoy u jʌsic a xibo'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Barej caj ocob ich naj u camsʌwinicob caj tarob u c'aticob ti' ba' caj u camsaj ti'ob sam. ");
INSERT INTO lacNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Caj u ya'araj ti'ob: ―Wa mac cu p'ʌtic u rac' quir u bin u ch'ic u jer, caj ts'oc u ch'ic u jer, yʌn u si'pir, irej a mac a cu man yejer u jer xquic. ");
INSERT INTO lacNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wa ja xquico' cu p'ʌtic u mam quir u bin u ch'ic u jer, caj ts'oc u ch'ic u jer, yʌn u si'pir, irej a xquico' a cu man yejer u jer xibo'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yʌn mac caj tar purbir chichan ich Jesús quir u ts'anc'ʌba'rob ten Jesús soc u yamta'rob ten C'uj. Caj u t'ʌnej C'uj Jesús quir u yamta'rob chichan ten C'uj. A yʌjpurirob chichan ich Jesús caj q'ueya'bob ten u camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","C'uxij yor Jesús caj u yiraj rajen caj u ya'araj ti'ob: ―Tsire'ej u tar purbir a chichano', ca' u yirenob. Mʌ' a mʌquex u berob quir u tarob ten. Mʌ' ja wirej, a chichano' seb cu tar tu yʌnen. ");
INSERT INTO lacNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Wa mac u c'at u yocar tu cu bin u reyintejob C'uj arej u cʌnejob a chichano'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jeroj tune', caj u ch'aj u mec'ob jujuntur a chichano' caj u ts'aj u c'ʌb yoc'orob jujuntur a chichano' caj u t'ʌnaj C'uj soc u yamta'rob ten C'uj a chichano'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","A ray u q'uinino' cu joc'ar Jesús quir u bin tu bej, caj tar yacab yicnʌn Jesús turiri' mac, caj xonraj ʌcʌtan caj u c'ataj ti': ―Jach tsoyech in wʌjcamsʌyʌjirech. Arej ten ba' ca' in betej soc in cuxtar munt q'uin? ");
INSERT INTO lacNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús caj u ya'araj ti' a xibo': ―Biquinin ca wa'aric tsoyen? Mʌna' mac jach tsoy chen jari' C'uj tsoyo'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tech a wer ba' caj u ts'ibtaj Moisés uch: “Mʌ' a yʌn man yejer xquic, baxuc xquic mʌ' u yʌn man yejer xib. Baxuc xan, mʌ' ja quinsic mac. Baxuc xan, mʌ' a wa'cric ba'. Baxuc xan, mʌ' a yʌn tusic mac. Baxuc xan, mʌ' a yʌn tusaric ba'. Yʌn sʌj ta tet yejer a nʌ' xan.” ");
INSERT INTO lacNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Raji' tune', caj u nuncaj, caj u ya'araj ti': ―In wʌjcamsayʌjirech, tu cotor aro' caj in toc quibaj tin chichʌnin uch. ");
INSERT INTO lacNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús tune', caj u pʌctaje' caj u yajquintaj, caj u ya'araj ti': ―Yʌn turiri' ba' mʌ' ta quibaj, ca' a betej aro'. Canej tu cotor a ba' yʌn tech. Cu ts'ocar a rʌc canic, ca' a jʌsej a taq'uin ti' a mac otsiro'. Cu ts'ocar aro' ca' taquech tin pach quir a cʌnic in t'ʌn, cax wa je' a quimin. Ca' bin c'uchuquech ich ca'anan, cu bin ts'abʌr tech a ba' jach co'ojo'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Caj ts'oc yubic a ba' caj u ya'araj Jesús ti' caj tucurnʌjij quire' jach yʌn u taq'uin. Caj bine', yajij yor. ");
INSERT INTO lacNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús tune', caj sut u bʌj caj pacatnʌjij caj u ya'araj ti' u camsʌwinicob: ―Jach yaj yocar mac a neyʌn u taq'uine' tu cu reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Caj jac' yorob u camsʌwinicob Jesús quire' a ray t'ʌno' a ba' caj u ya'araj Jesús. Jeroj tune', caj u wʌc'ʌs araj ti'ob: ―In pararechex, jach yaj yocar mac a neyʌn u taq'uine' tu cu reyinticob C'uj quire' u yaj u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Je' wa ju c'uchur yor yocar yʌrʌc' tsimin ich u jorir yit' puts'? Mʌ' u c'uchur yor quire' chichin u jorir yit' puts'. Je' wa ju c'uchur yor ocar ich ca'anan a mac a ne yʌn u taq'uin? Mʌ' u yocar quire' u yaj u taq'uin. Jaj ix tʌcoj, je' u yocar yʌrʌc' tsimin ich u jorir u yit' puts'. Chen a mac a neyan u taq'uin mʌ' ju yocar tu cu bin u reyintejob C'uj quire' u yaj u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Caj u yubajob u camsʌwinicob caj jaq'uij yorob caj u pacran c'atajob ich u yet camsʌwinicob: ―A mac cu bin tacbir ten C'uj tun? ");
INSERT INTO lacNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús caj pacta'bob caj u ya'araj: ―A xibo' mʌ' c'ucha'an yor u taquic u bʌj, chen C'uj c'ucha'an yor u taquic tu cotor mac, quire' C'uj c'ucha'an yor ti' tu cotor ba'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro tune', caj u yʌnxchun ya'aric ti': ―Jaj Ts'urir biquinin a neyʌn u taq'uin mʌ' u rʌc p'ʌtaj a ba' yʌn ti' quir u say ta pach quir u cʌnic a t'ʌn? A tenob caj in rʌc p'ʌtajob a ba' yʌntenob caj sayenob ta pach quir in cʌnicob a t'ʌn. An ba' cu bin u ts'ic tenob C'uj, quire' caj in toc rʌc p'ʌtajob a ba' yʌn tenob uch? ");
INSERT INTO lacNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Caj u nuncaj Jesús caj u ya'araj: ―Jach taj quin wa'aric techex. A mac a caj u p'ʌtaj yatoch tu cotor, cax u wʌc'ʌs u bʌjob, cax u wʌc'ʌs tet, cax u nʌ', cax wa ju pararob, cax wa ju ru'umin quir u yamtiquen yejer u jach tsoyir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","A mac a caj u p'ʌtaj aro' cu bin u c'ʌmej ti' C'uj a ba' jach tsoyo' tu q'uinin baje'rer, jach manan cu bin ts'abʌr ti'. Cu bin ts'abʌr yatochob. Cu bin ts'abʌr ti' u ru'umob. Ra'iri' u q'uinin xan, je' u chuquicob u pach quire' caj u yacsaj tu yor in t'ʌn. Baxuc xan, ca' bin xuruc t'ʌn, je' u ts'abʌr ti' u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Barej ya'ab a ra' yʌn pʌybeje' baje'rer, cu bin man pachir cu man u ts'ati' pachir pʌybeji'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús cu bin ich u berir Jerusalén, yet binacob ya'ab macob. Jesús pʌybej cu bin. Jac'a'an yorob cu binob a yet binacob, a cu sayʌrob tu pache' caj sajʌcchʌjob. Jeroj tune', tu junanob caj u pʌyaj u camsʌwinicob quire' u tsicbʌtic ti'ob u docejob. Caj u yʌnxchun u ya'aric ti'ob a ba' cu bin tar ti' ca' bin c'uchucob tu cajar Jerusalén: ");
INSERT INTO lacNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Iric quic binex tu cajar Jerusalén. Ti' cu bin u quinsiquenob. Ti' cu yʌn bin u c'ubiquenobi' ti' u jach ts'urirob sacerdote u winiquirob judío, yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Robob cu bin ya'arejob ca' quinsaquen, a teno' a baxuquenechexe'. Mʌ' ja wirej, cu bin u c'ubiquenob xan ti' a mʌ' u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Robob bin u p'astiquenob, bin u jʌts'enob, bin u tubiquenob, jeroj tune', bin u quinsenob. Mʌna' u nup u q'uinin ca' bin riq'uiquen ti' in quimirir. ");
INSERT INTO lacNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo tun, yejer Juan, u pararob Zebedeojo' caj tarob tu yicnʌn Jesús, caj u ya'arajob: ―In wʌjcamsayʌjirechob, wa quin c'aticob ba' ti' tech, in c'atob ca' a betej ti' a tenob. ");
INSERT INTO lacNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Raji' tune', caj u ya'araj ti'ob: ―Ba' a c'atex ca' in betej techex? ");
INSERT INTO lacNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Robob caj u ya'arajob ti': ―Arej tenob ca' curaquenob turiri' ta noj bayiri' turiri' ta ts'ic ca' bin c'uchuc tu q'uinin ca' ocaquech tu cu reyinticob C'uj a mac tu cotor. ");
INSERT INTO lacNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús tune', caj u ya'araj ti'ob: ―A techexo', mʌ' a werex ba' ca c'atiquex ten. Arex ten wa c'ucha'an a worex a muc'yajex an ten bic ca' bin muc'yajnʌquen ich cruz? Bayiri' xan, arex ten wa c'ucha'an a worex a muc'yajex an ten bic ca' bin muc'yajnʌquenob ti' a macob? ");
INSERT INTO lacNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Robob caj u ya'arajob ti': ―C'ucha'an in worob in muc'yajob an bic tech. Jesús caj u ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","―Taj quin wa'aric. Je' a muc'yajex an bic ten. Chen mʌ' c'ucha'an in wor in curquintiquechex ich in noj mʌ' ich in ts'ic quire' mʌ' ten yʌnin. Quire' in Tet C'uj yʌnin quir u curquintic mac u c'at C'uj. Raji' u yʌn ricsmʌn uch. ");
INSERT INTO lacNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Barej caj yubob a diezo' u yet camsʌwinicob a ba' c'ata'b ti' Jesús ten Juan yejer Jacobo. U yet camsʌwinicob caj p'ujob yejer Juan yejer Jacobo. ");
INSERT INTO lacNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Barej Jesús caj u t'ʌnaj ca' u much'quintejob u bʌj u camsʌwinicob quir u camsic, caj u ya'araj ti'ob: ―A werex a mac u jach ts'urirob u cajarob a mʌ' u winiquirob judío, cu jach ts'uririnticob u winiquirob. Bayiri' xan, cu naj ts'uririnticob u winiquirob quir u beticob a ba' u c'atob u jach ts'urirob. ");
INSERT INTO lacNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʌ' a yʌn cʌniquex a baxuc u jach ts'urirob a mʌ' u winiquirob judío, a mac u c'at u ts'uririnticob u yet acsa'orirob. Arej ca' u yamtej u yet camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cax a mac ich techex u c'at u ts'uririntic u yet camsʌwinicob, arej ca' u yamtej u yet camsʌwinicob soc irej u c'urew. ");
INSERT INTO lacNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Caj u ya'araj Jesús: ―Ca' a cʌniquenex, a teno' a baxuquenechex. Mʌ' taren quir u yamtiquenob. Taren in yamtic tu cotor mac. Taren quir in quinsa'r soc in rʌc bo'otic u bo'orir ca' siptacob u binob u si'pirob ya'ab mac. ");
INSERT INTO lacNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Caj tarob tu cajar Jericó. Quire' cu joc'ar ich u cajar Jericó yet binacob u camsʌwinicob yejer xan p'encʌch ya'ab macob, ti' cura'an a ch'op u wiche' ich nʌc' bej. Cu c'atic u taq'uin quir u janʌn. Bartimeo u c'aba' a ch'op u wiche', raji' u parar Timeo. ");
INSERT INTO lacNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Barej caj u yubaj Jesús a cu tar tu cajar Nazaret caj mane' caj u yʌnxchun u yawʌt caj ya'araj: ―Jesús, u pararech a nunquir u rey David, chan yajquin ten. ");
INSERT INTO lacNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Q'ueya'b ten ya'ab mac ca' u mʌc u chi'. Barej raji' caj u jach c'amquintic awʌt: ―U pararech a nunquir u rey David chan yajquin ten. ");
INSERT INTO lacNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús caj xurij ich bej caj u pʌyaj a ch'op u wiche'. Caj u pʌyajob a pimo' ti' a ch'op u wiche', caj ya'arob ti': ―Chichquintej a wor, riq'uen cu t'ʌniquech ―quij ya'ara' ten a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeo tune', caj ric' caj u pitaj u ca' ya'arir u noq'ue', caj u ch'aj u sit', caj tarij yicnʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Caj t'ʌn ten Jesúse', caj u ya'araj ti': ―Ba' a c'at ten quir in yamtiquech? A Bartimeojo' caj u ya'araj ti': ―In wʌj camsʌyʌjirech ca' sasichʌjʌc in wich soc chʌca'an in wiric in ber. ");
INSERT INTO lacNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Caj u ya'araj Jesús ti': ―Xen, quire' caj a wacsaj ta wor ten, jaw a wich. Seb caj jaw u wich, caj pacatnʌjij, caj bin tu pach Jesús ich bej. ");
INSERT INTO lacNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Barej caj nats'ob tu cajar Jerusalén, caj yʌn c'uchob u chan cajar u c'aba' Betfagé quet yejer u chan cajar Betania. Jach baytʌc tu yʌn u chan p'uc witsir u c'aba' Olivos quire' ti' pʌca'an u pʌc'ar ich u cor u che'er Olivos. Jesús caj u tuchi'taj ca'tur u camsʌwinicob ca' xicob. ");
INSERT INTO lacNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Caj ya'araj ti'ob: ―Xenex ich u chan cajar c'ʌs baytʌc. Ca' bin ocaquechex ich u cajar je' a wiriquex chan tsimin ti' maca'an, mʌna' mac naca'an cʌptar u cʌpmʌn tu pach. Pitex ca' a pʌyex tera'. ");
INSERT INTO lacNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wa mac cu c'atic techex: “Biquinin ca pitiquex chan tsimin?” Yʌn are baxuc a jera': Quire' ic Jaj Ts'urir u c'at u cʌptar tu pach, quechex ti'. Ca' bin tsocac u c'ʌnique' seb cu wʌc'ʌs tuchi'tej tera'. ");
INSERT INTO lacNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Caj binob ca'tur u camsʌwinicob Jesús caj u yirajob a chan tsinino' ti' maca'an tancab baytʌc tu yʌn u jor a najo'. Tu ber yʌn. Jeroj tune', caj u pitajob a chan tsimino'. ");
INSERT INTO lacNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jun yarob ti' a macob, a ti' tar yʌnobob, caj u c'atajob ti'ob: ―Ba' ca betex? Biquinin ca pitiquex a chan tsimino'? ");
INSERT INTO lacNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Robob tune', caj u ya'arajob ti'ob quire' ara'bob ten Jesúse', caj cha'aj ti'ob chan tsimin. ");
INSERT INTO lacNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","A ca'tur u camsʌwinicob caj u paytajob chan tsimin, caj binob u purej ich Jesús, caj u jʌyajob noc' tu pach chan tsimin. U camsʌwinicob Jesús caj u yamtajob Jesús quir u cʌptar tu pach chan tsimin. ");
INSERT INTO lacNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ya'ab mac cu jʌyicob uch u ca' yarir u noc'ob te' ich bejo' tu cu man yʌrʌc' chan tsimin an ten bic rey cu c'uchur tu cajar. U jer jun yarob caj u ch'ʌcajob u c'ʌb che' caj u jʌyajob te' ich bej xan, a baywo' cu yesicob cu sʌjticob a mac a cu tar ich bej. ");
INSERT INTO lacNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A mac a cu bin pʌybej ti' Jesús yejer a ra' cu tarob tu pach, caj c'ayʌnʌjob tu cu ya'aricob: ―Jach caremech C'uj. C'uj caj a yamtaj a mac a cu tar tu c'aba' Jaj Ts'ur. Ca' ij carex Hosanna. ");
INSERT INTO lacNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Jach manan tsoy wa macob cu qui' t'ʌnticob tu cu bin u reyinticob u rey ic nunquirex David a cu bin tar. Ca' ij carex Jach caremech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Caj oc Jesús tu cajar Jerusalén. Barej caj oc Jesús tu carem naj tu cu naj c'ujinticob C'uj u winiquirob judío, caj u rʌc pʌctaj tu cotor a ba' ti' yʌno'. Jeroj tune', caj joc' quir u bin tu cajar Betania yejer u docejo' u camsʌwinicob quire' cu bin q'uin. ");
INSERT INTO lacNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Caj sasij, jeroj tune', caj joc'ob tu cajar Betania, caj wi'ijchʌjij. ");
INSERT INTO lacNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Caj u yiraj nach turiri' u che'er higo, yʌn u re', rajen caj u juts' u bʌj Jesús yirej wa jix ti' yʌn u wich, caj yiraj mʌna' u wich chen u re' yʌn, quire' mʌ' ra' u q'uinin u wichʌnʌcʌr. ");
INSERT INTO lacNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jeroj tune', caj u t'ʌnaj, Jesús caj u ya'araj ti': ―Mʌ' biq'uin ca' bin mac'ʌc a wich ten mac ―quij ya'ara' ti' u che'er higo. Caj u'ya'b ten u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Barej caj urob tu cajar Jerusalén tiri' caj oquij Jesús ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u yʌnxchun u joc'sic a mac a cu canicob u ba'tac tu japnin carem naj, bayiri' xan, a mac cu mʌnicob, caj u rʌc jʌwʌcch'intej Jesús u poche'ir tu cu c'axicob u taq'uin, bayiri' xan, caj u rʌc jʌwʌcch'intej u cutanob tu cu canic u yʌrʌc' susuy. ");
INSERT INTO lacNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mʌ' cha'b u ch'a'acob ba' ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Caj u camsaj ti'ob, tan ya'aric: ―Mʌ' wa c'aj techex tub ts'iba'an ich u t'ʌn C'uj tu cu ya'aric C'uj: “A jera' u najir quir u yocar mac u t'ʌnic C'uj, cax tu cotor mac tu cu tarob tu cajarob ich tu cotor u ru'umirob”; chen a techexo' caj a waysajex irej u japnin tunich tu cu naj tar a mac a cu ya'cricob ba'. ");
INSERT INTO lacNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Barej caj u'ya'b ten u jach ts'urirob tu cotor u sacerdote u winiquirob judío yejer yʌjcamsʌyʌjirob u t'ʌn Moisés caj u cʌxtob bic tabar u quinsicob. Quire' tu cotor macob jac'a'an yorob ti' a ba' cu camsic, rajen robob, u jach ts'urirob tu cotor sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés caj u ch'aj saquirob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Barej ber cu bin q'uin, caj joc'ob tu cajar Jerusalén caj bin Jesús quet yejer u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A'acbir samam caj manob caj u yirajob rʌc tijij u che'er higo tac tu mots. ");
INSERT INTO lacNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Caj c'ajij yic' Pedro, caj u ya'araj ti': ―In wʌjcamsʌyʌjirech, iric quimij a ray u che'er higo a ta ro'ro' t'ʌntaj, caj rʌc tijij u che'er. ");
INSERT INTO lacNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Caj u nuncaj Jesúse', caj u ya'araj ti'ob: ―Ca' acsex ta worex ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Taj quin wa'aric techex, je' u c'uchur a worexe' a t'ʌnex cax a je' witsa' ca' xic ich u chi'c'ac'nab, je' u bine' wa ca wacsiquex ta worex, wa ta worex mʌ' a wa'ariquex: “Je' wa ju bine' wa quin wac ti'.” Mʌ' ja wirej, je' u bine' quire' caj a wacsajex ta worex je' u bine'. ");
INSERT INTO lacNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rajen, quin wa'aric techex, wa ber ca t'ʌniquex C'uj ti' a ba' a c'atex, acsej ta worex wa bin a c'ʌmiquex jeroj tune' bin tac ti' techex tu cotor a ba' caj a c'atajex ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wa ber ca t'ʌniquex C'uj ca' a pacran jawsex u si'pir a ca tucriquex wa mac caj u betaj c'as ti' techex soc a Tetex ca'anan ca' u jawsej a si'pirex xan. ");
INSERT INTO lacNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Quire' wa techex mʌ' ja jawsiquex u si'pirob bayiri' xan a Tetex a ti' yʌn ich ca'anano' mʌ' u bin u jawsic a si'pirex xan. ");
INSERT INTO lacNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Caj c'uchij Jesús ich u cajar Jerusalén yejer u camsʌwinicob. Quire' cu man ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío, caj u juts'ob u bʌj u jach ts'urirob tu cotor sacerdote u winiquirob judío yejer yʌjcamsʌyʌjirob u t'ʌn Moisés yejer u jach ts'urirob u winiquirob judío a Nuxibe'. Caj u juts'ob u bʌj ich Jesús caj c'atab ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Caj u ya'arajob ti': ―Mac caj u ya'araj tech ca' a joc'sej jo'oraj? Tub u tar a muc' quir a jawsic mac? Tub u tar a muc' quir a camsic mac? Mac caj u ts'aj a muc'? ");
INSERT INTO lacNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Caj nuncaj Jesúse', caj u ya'araj ti'ob: ―Baxuc techex xan, je' in c'atic techex wa taj ca nunquiquex ten je' in wa'aric techexe' tub u tar in muq'ue' quir in betic aro'. ");
INSERT INTO lacNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Arex ten ―quij Jesús―. Mac tuchi'tej Juan quir u yacsic ja' tu jo'r mac. C'uj wa tuchi'tej wa xib tu tuchi'taj? ");
INSERT INTO lacNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Caj ts'oc yubicob a ba' c'ata'b ti'ob ten Jesús, cu pacran nunquicob u t'ʌn ich u bʌjiri'ob tan ya'aricob: ―Wa quij cariquex ti': “C'uj tuchi'tej”, je' u ya'aric to'onex: “Biquinin mʌ' ta quibex u t'ʌn Juan uch?” ");
INSERT INTO lacNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Barej wa quij cariquex ti': “A Juano' tuxta'b ten xib”, quic sʌjtiquex a ya'ab macob quire' robob cu tucricob tuchi'ta'b ten C'uj rajen yerob jach jaj Juane' a mac ts'a'b u tucuric ten C'uj quir u tsicbar a ba' u c'at C'ujo'. ");
INSERT INTO lacNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Caj u nucajob, caj u ya'arajob ti' Jesús: ―Mʌ' in werob mac tuchi'tej Juan. Baxuc caj wʌc'ʌs nunca'b ten Jesús caj u ya'araj: ―Baxuc xan, mʌ' in wa'aric tub u tar in muc' a ba' quin betic. ");
INSERT INTO lacNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús caj u yʌnxchun u camsic a ya'ab macob, caj u camsaj baxuc a jera' soc yerob a mac a mʌ' u c'at yacsic u yor quire' bin u caj ich c'ac'. Rajen caj u camsaj a jera': ―Ti' yʌn mac cuch caj ts'oc u ch'ʌquic u che'er u cor, caj u rʌc tocaj u robirir, caj u pʌc'aj u yaq'uir uva. Caj ts'oc u pʌq'uic caj u pa'te'taj u cor, caj u ts'ʌpquintaj tunich quir u ch'ictar ca'anan soc u cʌnantic u wich uva soc mʌ' u rʌc mʌq'uicob ch'ich'. ’Caj ya'araj u cʌnata'rob u cor ten u winiquirob, quire' bin u caj nachir. ");
INSERT INTO lacNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Caj c'uchij tu q'uinin u t'aquicob u wich uva u jach ts'urir caj u tuchi'taj u c'urew turiri' quir u c'atic u bo'orir tu tu t'acajob u wich uva ti' u yʌjcarirob u corir uva. Quire' ca' u jʌsob ti u ts'urirob u bo'orir u cor u ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Caj chuc jʌts'bir ten yʌjcarirob u corir uva caj wʌc'ʌs tuchi'ta'b ich u ts'urir, mʌna' ba' ts'a'b ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tu wʌc'ʌs tuchi'taj u jer u c'urew, barej caj u ch'inajob u jo'r, caj u bujʌtstajob u yot'er u jo'r, toc cheta'b ten yʌjcarirob u corir uva caj wʌc'ʌs tuchi'ta'b ten yʌjcarirob u corir uva ich u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Caj wʌc'ʌs tuchi'taj u jer raji' xan caj u quinsajob. Bayiri' xan yejer u jerob ya'ab, jun yarob caj u bʌbʌjʌtstajob, jun yarob caj u quinsajob. ");
INSERT INTO lacNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ti' toy yʌn uch turiri' u parar ich yicnʌn u jach ts'urir, u jach yaj u parar. Jari' mʌna' u jer mac quir u tuchi'tic, rajen caj u tuchi'taj u parar. Yer u jach ts'urir je' u sʌjta' u parar ten yʌjcarirob u corir uva. ");
INSERT INTO lacNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Caj c'uchij u parar caj irir ten yʌjcarirob u corir uva caj u pacran arajob ich u yet carirob u corir uva: “Raji' u parar ic jach ts'urirex cu tar. Raji' cu bin ch'ic u cor wa cu quimin u tet. Ca' xico'onex ij quinsex u parar soc to'onex quic bin ic ch'iquex u cor.” ");
INSERT INTO lacNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Caj u chucajob ca' xicob u quinsejob ich u nʌc' c'axir u cor. Ti' tu jach quinsajob ich u nʌc' c'axir u cor, caj u pich'intajob u baquer. ");
INSERT INTO lacNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesús caj u c'ataj ti'ob: ―Arex ten, ba' cu bin u betic u jach ts'urir u cor ti' yʌjcarirob u corir uva ca' bin tac? Je' u tar u jach ts'urir quir u joc'sic u quinsej quir u ts'ic ti' u jerob mac. ");
INSERT INTO lacNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jesús caj u ya'araj ti' u jach ts'urirob u winiquirob judío: ―Mʌ' wa ja xacmʌnex a ts'iba'an u t'ʌn C'uj a jera': U yoc naj a caj u pich'intajob yʌjc'ʌxirob naj quire' mʌ' u c'atobi'. A jera' yoc naj a caj u purob mʌna' u jer jach chich u muc'. Chen caj u wʌc'ʌs chucob quir u c'ʌxicob naj soc u chichtar u muc'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A jera' caj beta'b ten C'uj. Mʌ' wa cu jac'ar ij corex ij quiriquex? ");
INSERT INTO lacNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Caj najta'bir ten u jach ts'urirob tu cotor u winiquirob judío a ba' camsa'b ti'ob sam ra' quir u najticob rajen caj u tumtajob u tuchi'ticob chucbir Jesús. Quire' cu sʌjticob a pimob rajen p'at, rajen binob. ");
INSERT INTO lacNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Caj u tuchi'tajob jun yarob u winiquirob judío a fariseojo' yejer u camsʌwinicob Herodes ti' Jesús quir u tus wayticob u t'ʌn soc u tus taquicob u jo'r ich gobernador. ");
INSERT INTO lacNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Barej caj tarob caj u ya'arajob ti': ―In wʌjcamsʌyʌjirechob ―quij―, in werob taj a ba' ca wac. Baxuc taj a ba' ca camsic ti' u t'ʌn C'uj. Mʌ' a coyen ca chich aric ti' mac, quet ca wa'aric ti'ob. Quire' baxuc taj ca camsic tenob a ba' u c'at C'uj ti' a tenob. Arej tenob quire' in c'atob in werob wa tsoy in bo'oticob in ru'umob ti' rey? Wa mʌ' tsoy in bo'oticob in ru'umob ti' rey? ");
INSERT INTO lacNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús yer a ba' c'as cu tucricob tu yorob caj u ya'arajob: ―Biquinin tarechex a tumtiquex in wor? Esej ten turiri' a taq'uinex ca' in wirej. ");
INSERT INTO lacNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Caj u yesajob ti' Jesús. Raji' caj u ya'araj ti'ob: ―Mac jot'a'an u yo'ochir? Mac u c'aba' ts'iba'an ti'? Caj u ya'arajob ti': ―Ra' u yo'ochir u rey César, jot'a'an ich sʌc taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Caj u ya'araj Jesús ti'ob: ―Taj a ba' ca wa'ariquex. Rajen ca' a quibex a ba' cu ya'aric techex u rey César, baxuc xan, ca' a quibex a ba' a cu ya'aric C'uj ti' techex. Chan jac'a'an yorob a ba' yubajob ya'aric Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Baxuc xan, tarob u winiquirob judío a saduceojo'. Aro' cu ya'aric: “Mʌ' u riq'uir mac tu quimirir.” Caj tarob u c'atej ba' ti' Jesús caj ya'arajob ti' Jesús: ");
INSERT INTO lacNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―In wʌjcamsʌyʌjirechob ―quij―, ic nunquirirex Moisés caj u ts'ibtaj to'onex uch a ba' ca' ic betejex caj u ya'araj wa ju mam cu quimin, cu p'atʌr u rac', mʌna' u parar yejer, caj quimij u mam tu junan. Caj u ya'araj Moisés, ra' u yits'in u mam, raji' cu bin u ch'ic u raq'uintej u mu'. Soc yiric wa je' u pararʌncʌr yejer soc u ch'isic u parar, irej wa ju tus parar u sucu'un uch. ");
INSERT INTO lacNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A sucu'unbiro' yʌn seis yits'inob. A sucu'unbiro', raji' tu yʌn ch'aj u rac', hasta u quimij mʌna' u parar. ");
INSERT INTO lacNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A its'inbiro', raji' caj u tacaj u chuch u sucu'un. Raji' caj u ch'aj u rac' u sucu'un, mʌna' u parar xan caj quimij, a jach ca' its'inbiro', raji' caj u tacaj u chuch u ca' sucu'un. Raji' caj u ch'aj u rac' u ca' sucu'un. Mʌna' u parar xan. ");
INSERT INTO lacNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hasta nup u rʌc ch'ic u yits'in u mam, hasta rʌc quiminob mʌna' u parar, caj c'uchij tu q'uinin u quimin a xquico', caj quimij. ");
INSERT INTO lacNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ca' bin riq'uic tu quimirir, mac cu bin u ch'ic u raq'uintej quire', siete tu ch'aj u mam? ");
INSERT INTO lacNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús tune', caj u nuncaj ti': ―Mʌ' wa ja wʌc'ʌs bʌjiri'ex ca tusariquex quire' mʌ' ja najtex a ba' ts'iba'an ich u t'ʌn C'uj bayiri' xan, mʌ' a werex wa jach chich u muc' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quire' ca' bin c'uchuc tu q'uinin u wʌc'ʌs riq'uir mac ti' u quimirir, a xibo' mʌ' u raq'uintej xquic. Bayiri' a xquico' mʌ' u mʌmintej xib quire' u jer cu bin waysa'bir ten C'uj robob irej yʌjt'ʌnirob C'uj ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Soc a cʌniquex ba' u c'at ya'aric, je' u riq'uir mac ti' quimirir. Yʌn c'aj techex tub ts'iba'an u t'ʌn C'uj. Caj ya'araj C'uj ti' Moisés ich a ray chan che'er a erar u ca' uch an bic C'uj cu ya'aric: “Tu c'ujinten Abraham uch, bayiri' Isaac yejer Jacob.” ");
INSERT INTO lacNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A C'ujo' mʌ' quimen yiric a nunquirex, cuxa'an yiric a C'ujo'. Mʌ' ja wirej, cuxa'an yiric a C'ujo' tu cotor mac. Rajen mʌ' qui'jij a waquex. ");
INSERT INTO lacNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Caj u juts'aj u bʌj turiri' ich Jesús, yʌjcamsʌyʌjir u t'ʌn Moisés a mac caj u yubaj uch bic cu nunquicob u t'ʌn Jesús a saduceojo'. Tsoy caj u yubaj u nunquic Jesús ti' u pacran t'ʌnob, caj u c'ataj ti': ―Arej ten a jach manan tsoyir u t'ʌn C'uj ich tu cotor ca' in quibejob. ");
INSERT INTO lacNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús tune' caj u nuncaj ti': ―A jera' a jach manan tsoyir u t'ʌn C'uj ich tu cotor: “U'yex tu cotor u winiquirechex israel a Jaj Ts'uro', raji' ij C'ujirex, jari' raji' ic Jaj Ts'urirex. ");
INSERT INTO lacNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yajquintej C'uj, quire' raji' a Jaj Ts'urirex. Qui' yajquintej C'uj yejer tu cotor a pixam, yejer tu cotor a muc' yejer tu cotor a wor xan”, quire' raji' pʌybej ich u t'ʌn C'uj. Rajen ca' a qui' quibex a jera'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Quet bayiri' ti' yʌn u jer a cu ya'aric: “Yajquintej a rac'ob an bic ca wʌc'ʌs yajquintic a bʌjiri're'.” Mʌna' u jer tu ts'iba'an ich u t'ʌn a jach manan noj ti' aro'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A yʌjcamsʌyʌjir u t'ʌn Moisés tuno', caj u ya'araj ti': ―Jach taj caj a wa'araj ten, in wʌjcamsʌyʌjirech, caj a wa'araj jach taj, turiri' C'uj yʌn, mʌna' u jer, jariro'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Taj caj a wa'araj ca' ic yajquintex C'uj yejer tu cotor ic pixamex yejer tu cotor ic tucurex yejer tu cotor ic muq'uex, bayiri' xan, ca' ic yajquintex ic rac'obex an bic ic wʌc'ʌs bʌjex ic yajquintiquex, a jera' a caj a wa'araj jach manan ti' tu cotor a ba' ʌrʌc'a'an a cu toquic quir u sijic ti' C'uj, bayir' ti' tu cotor a ba' cax cu sijicob ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús caj u toc u'yaj tsoy an bic caj u nuncaj ti' a yʌjcamsʌyʌjir u t'ʌn Moisés quire' caj u nuncaj an bic caj u najtaj a ba' ara'b ti' ten Jesús. Rajen caj u ya'araj ti': ―Tabar a wocar tu cu bin u reyinticob C'uj. Jeroj tune', caj p'atob u tar u c'aticob ba' ti' Jesús, sajʌcob u c'atej. ");
INSERT INTO lacNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Barej ti' yʌn Jesús ich a carem naj tu cu naj c'ujinticob C'uj u winiquirob judío tu cu camsic caj u c'ataj ti'ob: ―Bic tabar cu ya'aric a yʌjcamsʌyʌjirob u t'ʌn Moisés wa Cristo raji' u ch'ic ca' parar u nunquir David? ");
INSERT INTO lacNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Arex ten biquinin David caj u t'ʌnaj: “In Jaj Ts'urir” ―quij David. Mʌ' ja wirej caj yamta'b ten u Taj'or u Pixam C'uj caj u ts'ibtaj a jera': A C'ujo' caj u ya'araj ti' in Jaj Ts'urir, quij ya'aric David: “Curen tin noj, quij C'uj, hasta quin rʌc ch'esic a mac a cu p'atiquech.” ");
INSERT INTO lacNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Bic tabar Cristo u ch'ic ca' parar a nunquirex David wa David u bʌj t'ʌnej: “In Jaj Ts'urir”? Rajen ij querex a Cristojo' raji' mʌ' chen u ch'ic ca' parar a nunquirex David. A macob a ti' yʌnob, quire' p'encʌch ya'ab ti' yʌnob, jach tsoy tu xiquinob caj u yubajob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tu cu camsic Jesús caj u ya'araj ti'ob: ―Qui' cʌnantechex a bʌjex soc mʌ' a cʌniquex a yʌjcamsʌyʌjirob u t'ʌn Moisése'. Mʌ' ja wirej, u yʌjcamsʌyʌjirob u t'ʌn Moisés jach c'ʌrʌp u noc' cu manob soc u tus tucricob u rac'ob jach noj aro'. Qui' yorob yiricob baxucob. Jach qui' yorob yiricob u t'ʌnʌn ten u rac'ob tu cu naj bin u mʌnicob yo'ochob quire' cu yiricob tus noj aro'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Baxuc cu teticob u cutanob tu cu cutarob a jach no'ojo' tu cu naj c'ujinticob C'uj tu chan najirob. Baxuc tu cu qui'qui' janʌnob soc u tus irir jach nojob. ");
INSERT INTO lacNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mʌ' ja wirej, a yʌjcamsʌyʌjirob u t'ʌn Moisés cu tus aricob ti' a xquico' a quimenob u mamob soc u tus ts'ic yatoch yejer u ba'tac cax a ba' yʌn tu yatochob. Robob jach ama'an cu ts'ocar u t'ʌnicob C'uj soc u rac'ob cu tus tucricob cu qui' c'ujinticob C'uj. Jach manan cu bin ts'abir u muc'yajob ten C'uj quire' cu beticob aro', cax yerob u t'ʌn C'uj. Chen u jer mac a mʌ' yerob C'uj mʌ' neyaj cu bin muc'yajob. ");
INSERT INTO lacNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Quire' curucbar Jesús ʌcʌtan ti' tu cuchir tu cu naj but'icob taq'uin tu cu naj c'ujinticob C'uj u winiquirob judío. Ra' taq'uin ti' carem naj tu cu naj c'ujinticob C'uj. Jesús caj u yiraj cu but'icob ya'ab u taq'uin ya'ab mac, a neyʌn u taq'uinob. ");
INSERT INTO lacNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Caj u yiraj xan xquic, a quimen u mame', otsir, caj u but'aj u majan taq'uin, ca'tur chʌc taq'uin, a mʌ' coji'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús tune', caj u t'ʌnaj ca' tacob u camsʌwinicob tu yicnʌn, caj u ya'araj ti'ob: ―Taj quin wa'aric techex, a je' xquica' a quimen u mame' cax otsir, chen caj u but'aj ca'tur chʌc taq'uin a mʌ' coji', chen ʌcʌtan tu wich C'uj coj caj u but'aj. Chen u rac'ob cax ya'ab caj u but'ajob, chen ʌcʌtan tu wich C'uj mʌ' coji'. ");
INSERT INTO lacNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A mac a ne yan u taq'uinob caj u but'ajob u ta'quin tu cuchir tu cu naj but'icob u taq'uinob u winiquirob judío tu cu naj c'ujinticob C'uj. Quire' jach manan ya'ab caj u but'ajob quire' jach manan t'aj u taq'uinob, chen ra' caj u but'ob quire' mʌ' u rʌc c'ʌnicobe' u taq'uin. Chen a xquico' a otsiro' caj u toc rʌc but'aj ti'o' u ta'quin cax mʌna' tu cu mʌnic yo'och. ");
INSERT INTO lacNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Quire' cu joc'ar Jesús tu japnin carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Toc bin u caj uch, caj u juts'aj u bʌj turiri' u camsʌwinicob ich yicnʌn Jesús. Ca' ara'b ti': ―In wʌjcamsʌyʌjirech, cha'antej biquira' a tunichob. Mʌ' wa jach caremo'? Cha'antej biquira' a najobo' mʌ' jach carem xan? ");
INSERT INTO lacNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús caj u nuncaj, caj u ya'araj ti': ―C'ʌ'otej tech a je' carem naja' bic tabar caj a wiraji' quire' jach taj quin toc aric a wu'yej, ca' bin c'uchuc tu q'uinin cu bin jubsa'bir. Mʌ' u p'at tunich tub ts'ʌpa'an, mʌ' a bin a wirej ca'tur ts'ʌpa'an. Bin rʌc jubucob a carem najobo'. ");
INSERT INTO lacNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Caj joc' Jesús ich carem naj caj bin ich u jo'r chan p'uc witsir Olivos, Jesús caj curʌj, ʌcʌtan ti' a carem najo' tu cu naj c'ujinticob C'uj u winiquirob judío, quire' cu pʌctic a carem najo', barej caj u juts'ob u bʌj u camsʌwinicob Pedro yejer Jacobo yejer Juan yejer Andrés soc tu junanob cu yubicob: ");
INSERT INTO lacNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Tarenob in c'atob a toc aric tenob ber ca' bin jubsac carem naj? Biquira' carem naj ca' bin c'uchuc tu q'uinin cu xur t'ʌn ca' bin urquech? ");
INSERT INTO lacNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Caj nunca'b ti'ob ten Jesús caj u yʌnx chun u ya'aric: ―Qui' cʌnantex a bʌjex soc mʌna' mac cu tar u tusaric techex, soc u pʌyicob techex ca' a quibiquex a ba' cu tusaricob techex. ");
INSERT INTO lacNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Quire' ya'ab mac cu bin tarob ich in c'aba', tan ya'aricob: “A teno' a Cristojeno'.” Rajen cu bin u beticob ca' a quibexob a ba' cu tusaricob techex. ");
INSERT INTO lacNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Chen ber ca' bin a wu'yejex u juminta'rob: “Tan u quinsicob u bʌj ich u jer ru'um”, cax tu yʌnechex xan, ca' bin u quinsicob u bʌj. Je' a wu'yiquex tabar u quinsicob u bʌj xan. Cax tan u manob u quinsicob u bʌj, mʌ' a ch'aquex sajaquirex, quire' yʌn u tar u quinsicob u bʌj an ten bic u c'at C'uj. Mʌ' toy c'uchuc tu q'uinin u xur t'ʌni'. ");
INSERT INTO lacNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ra' u quinino' ca wu'yiquex cu ts'ictarob winiquirob ich jumpet ru'um. Cu bin u quinsicob u bʌj yejer u winiquirob ich jumpet ru'um. Bayiri' xan, u ru'umin tu reyinta'b ten rey cu bin u quinsicob u bʌj yejer u jer ru'um tu reyinta'b ten u jer rey. Bayiri', je' a wu'yiquex u pec ch'ic yum ru'umin ich u jerob ya'ab ru'umob. Bayiri' je' u wichʌjʌrob xan ich jumpet ru'um, cax baytʌc cu bin u wichʌjʌrob. Raji' u yʌnx ch'ic chun u muc'yaj a cu bin tar ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Barej a techexo' yʌn cʌnatechex a bʌj. Quire' bin c'ubuquechex quir u tocar a jo'rex tu cu naj much'quinticob u bʌj tu cotor u jach ts'urirob u winiquirob judío. Jeroj tune', bin u caj u jʌts'icob a pachex ich u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío. Ti' cu bin u chopʌytiquechexob quir u bin u puriquechexob ʌcʌtan rey yejer ich gobernador quir u taquiquex a jo'rex quire' caj a wacsaj ta worex ti' ten, soc c'ucha'an a worex a wa'ariquex ba' u ber ti' techex. ");
INSERT INTO lacNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mʌ' ja wirej, mʌ' toy c'uchuc tu q'uinin u xur a t'ʌno' u jach tsoyir u t'ʌn C'uj cu yʌn bat'an tsec'ta'r ich tu cotor mac cax tu cʌja'anob. ");
INSERT INTO lacNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ber ca' bin chucuquechex ca' c'ubuquechex ʌcʌtan a juezo' quir u taquiquex a jo'rex. Mʌ' ja tucriquex ba' ca bin a wa'ariquex ti'ob, cax mʌ' toy xiquechex ʌcʌtan a mac a cu bin u taquiquex a jo'rex. Barej cu bin ts'abir techex a ray a q'uinino', ra' ca wa'ariquex quire' mʌ' techex ca t'ʌnexi' wa mʌ' a Taj'or u Pixam C'ujo'. ");
INSERT INTO lacNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mʌ' chen a mac a cu p'actiquechex cu bin u chuquicob a pachex, a tet yejer a nʌ' cax a bʌjob je' u c'ubiquechexob, baxuc je' u quinsiquechexob. Baxuc xan, u wʌc'ʌs pararob cu bin u c'ubicob u tet yejer u nʌ' soc u quinsa'rob. ");
INSERT INTO lacNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Quire' techex caj a wacsajex ta worex ten, tu cotor mac cu bin u p'actiquechexob, je' u ts'abʌr techex a cuxtarex munt q'uin wa rajra' ca muc'tiquex a ba' cu tar techex tu cu chuquicob a pachex. ");
INSERT INTO lacNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Mʌ' ja wirej, caj u ts'ibtaj Daniel a ts'ab u tucuric ten C'uj quir u ts'ibtic a ba' u c'at C'uj uch. Ra' caj u tsec'taj uch: “Wa ber ca wiriquex a ba' jach c'as ch'ica'an ich u japanin carem naj tu cu naj c'ujinticob C'uj u winiquirob judío tu mʌ' tsoy u ch'ictaro' quire' mʌ' ra' u beyaj. Qui' tucriquex ―quij Daniel―, quire' raji' cu bin u c'asquintic u winiquirob Israel.” Jeroj tune', arej ti'ob a mac a ti' yʌnob tu ru'umin Judea a ray u q'uinino' ca' puts'ucob ich wits. ");
INSERT INTO lacNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","A ray u q'uinino' wa ti' yʌn mac tu jo'r yatoch tu taj u jo'r yatoch. Arex ti' mʌ' tsoy u yocar u ch'ic u ba'tac. Arex u toc puts'ur. ");
INSERT INTO lacNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","A ray u q'uinino' wa ti' yʌn mac ich u cor. Arex mʌ' u sut u ch'ic u noc'. ");
INSERT INTO lacNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","A ray u q'uinino' jach otsirchʌjij a xquico' a tabar u rochic u chan ʌrʌc' ochir. Bayiri' a xquic a cu ts'ic chuch ti' chan ʌrʌc' och. ");
INSERT INTO lacNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","A ray u q'uinino' t'ʌnex C'uj soc mʌ' ra' u q'uinin a puts'urex tu q'uinin que'er, quire' mʌ' a c'uchur a worex a muc'tiquex que'er. ");
INSERT INTO lacNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Quire' a ray u q'uinino', jach manan cu bin muc'yajob a ra winiquirobo'. U jer winiquirob mʌ' u ne muc'yajob an ten bic cu bin u muc'yajob a ra winiquirobo' tu q'uinin cu bin xur t'ʌn. Mʌ' biq'uin yubmʌnobi' ra u q'uinin caj beta'b a ich yoc'ocabo' tu ch'ic chun uch. Mʌ' ca' bin tac u jer u q'uinin a baxuco'. ");
INSERT INTO lacNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","A ray u q'uinino' wa Jaj Ts'ur u c'at u cha'ic u cochtar u pach q'uin soc ama'an cu bin muc'yajob a ra winiquirobo', mʌna' mac cu bin p'atʌrob. Chen tabar u muc'yajob quire' ti' yʌnob a mac a toc teta'b ten C'uj quire' yajbir ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ca' bin c'uchuc a ray u q'uinino' wa mac cu bin ya'aric: “Irewirex, Cristo toc c'uchij quir u taquic mac tu cotor.” Mʌ' a quibex a ba' cu ya'aricob. Cax cu ya'aricob: “A ray Cristojo'.” ");
INSERT INTO lacNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Quire' a ray u q'uinino' ya'ab cu bin tarob quir u tusaricob ti' u rac'ob: “A teno' taren ich yoc'ocab quir in taquic mac, quire' tu tuchi'ten C'uj.” Tu cu tusaricob ti' mac je' u tus esicob carem beyaj xan. Cax a mac a teta'b ten C'uj orac u quibicob quire' cu tus iricob carem beyaj, quire' baxuc u c'atob, chen mʌ' u c'uchur u yorob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Quin toc aric techex a je' t'ʌna' soc a toc erex a ba' cu bin tar biq'uin soc mʌ' u jac'ʌr a worex. ");
INSERT INTO lacNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Caj ya'araj Jesús ti' u camsʌwinicob: ―A ray u quinino' a tabar u ts'ocar u muc'yaj a winiquirobo'. Je' u yac'birchʌjʌr q'uine'. Mʌ' u sasichʌjʌr. Bayiri', ic nʌ' mʌ' u bin u ts'abir u sasirir. ");
INSERT INTO lacNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","A sa'abo', cu bin yiricob irej wa cu rʌc rubur. Tu cotor ba' a ti' yʌn ich ca'anano' cu cha'ic u pec C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jeroj tune', cu bin yiricob in wu'ur a teno' a mac bayxuquenechexo'. Bin u yiriquenob quin tar tu muyʌrir yejer jach chich in muc', yejer u sasirir C'uj quin wu'ur. ");
INSERT INTO lacNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jeroj tune', bin tuchi'tac ten C'uj u yʌjmasirob u t'ʌn quir u bin u much'quinta'rob a mac caj in tetajob ich yoc'ocab, cax tu yʌnob, ti' cu bin u much'quinta'rob. ");
INSERT INTO lacNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Cʌnex a ba' cu camsico'onex che'er higuera. A werex cu jut'ur u re' che' quir u top'ʌncʌr quire' cu yocar yaxq'uin, taj an ten bic aro'. ");
INSERT INTO lacNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bayiri' xan, ber ca wiriquex a ba' caj in camsajechex sam cu tar, jeroj tabar u xur t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","C'aj techex a jera', quire' taj quin wa'aric techex. Ti' yʌn mac baje'rer, ra' cu bin cuxtarob tac cu yiricob a ba' caj in toc araj techex cu tar ich tu yʌnechex. ");
INSERT INTO lacNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A ca'anano' je' u rʌc ts'ocare', a je' ru'uma' je' u rʌc ts'ocar xan. Chen in t'ʌno' mʌ' u bin ts'ocar quire' yʌn u toc rʌc nupur in t'ʌn ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Chen ber cu bin tar a ba' caj in toc araj techex, mʌna' mac yer ber u tar. Cax u yʌjmasirob u t'ʌn C'uj, cax u parar C'uj mʌ' yer, chen u bʌjiri' C'uj yer ber u tar. Rajen mʌna' mac yer ber hora, cax ber u q'uinin mʌ' yer. ");
INSERT INTO lacNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Qui' cʌnatex a bʌj, qui' p'iric a wichex ca' a t'ʌnejex C'uj soc mʌ' u nayʌr a worex. Quire' mʌ' a werex biq'uin quin tar ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aro' irej a xib a caj joc' quir u bin nachir. Caj u p'ʌtaj u yatoch, caj u ts'ajaj u muc' ti' u c'urewob, caj u jʌsaj jujuntur u beyajob, caj u tuchi'taj a mac a cu cʌnantic u jor yatoch tu cu naj ocar mac tu yatoch, caj ya'araj ti' ca' u qui' p'irej u wich soc yiric u yu'ur u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Qui' p'irej a wichex tun, quire' mʌ' a werex ber ca' bin tac u jach ts'urir a najo', wa jix ti' oq'uin cu yu'ur, wa jix ti' chumuc ac'bir cu yu'ur, wa jix ti' ca' bin c'ayʌnʌc cax cu yu'ur, wa jix ti' a'a'cbir cu yu'ur. ");
INSERT INTO lacNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mʌ' ja wirej, wa jix ti' seb cu yu'ur ca' bin uruc jeroj cu yiric techex wenʌn a ca'ex. ");
INSERT INTO lacNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A ba' quin wa'aric techexa', quin wa'aric ti' tu cotor mac: “Qui' p'irex a wichex.” ");
INSERT INTO lacNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ca'bej cu c'uchur tu q'uinin u qui' qui' janʌnob u winiquirob judío. Ra' u q'uinin quir u c'ʌ'oticob u potmasticob yʌjmasir u t'ʌn C'uj uch, soc mʌ' u quiminob u parar xib a yʌn rocha'b ten u nʌ'. Ra' u q'uinin xan, a pano' a mʌ' u sipe', quire' mʌ' pʌji'. U jach ts'urirob u sacerdote u winiquirob judío yejer a yʌjcamsʌyʌjirob u t'ʌn Moiséso' caj u cʌxtob bic tabar u tusaricob ti' Jesús soc u chuquicob u quinsicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Robob caj u ya'arajob: ―Mʌ' tu q'uinin u qui' qui' janʌnob a pascuajo'. Ca' ic yʌn pajex u ts'ocar u quinin u qui' qui' janʌnob, soc mʌ' ic p'usiquex u yorob ij quet winiquirob judío a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Quire' ti' yʌn Jesús ich u cajar Betania, curucbar tu janʌn tu yatoch Simón. Ra' u cʌnmʌn iq'uer u ca' uch. Jeroj tune', tarij turiri' xquic ich yatoch Simón yejer turiri' chan p'urir, chup yejer a ne qui' u boque', chen nardo u c'aba', a qui' u boque'. A nardojo', jach co'oj u bo'orir. A xquico' caj u pa'aj a chan p'uro' caj u wecaj a qui' u boque' tu jo'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yan jun yarob a ti' yʌnob, caj p'ujob, caj u ya'arajob: ―A biquinin caj u sʌtaj a ra' qui' u boque' ich u jo'r Jesús? ");
INSERT INTO lacNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wa caj u canaj ca'che' tu ca' jaraj u taq'uin quir u jasʌr ti' a jach otsirobo'. Quire' u bo'orir jach manij tres cientos sʌc taq'uinob. Choc yorob ti' a xquico' quire' caj u xupaj a qui' u boque'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Barej Jesúse' caj u ya'araj: ―Tsire'ej, ba'wir ca ts'iquintex a xquico'. Mʌ' ja wirej, caj u betaj tsoy ten, caj u jayaj tin jo'r a qui' u boque'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A otsire', rajra' ti' yʌn tu yʌnechex an ber a c'atex, je' u c'uchur a worex a betiquex tsoy ti'ob, barej a teno' mʌ' rajra' ti' yʌnen tub yʌnechex. ");
INSERT INTO lacNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A je' xquica', a ba' caj u betaj a ba' c'ucha'an yor ti', rajen caj u jayaj tin jo'r a qui' u boque', quire' tabar u muquicob in baquer. ");
INSERT INTO lacNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jach taj quin wa'ariquex tech ―quij Jesús―. Cax wa tu cu bin u tsec'tic u jach tsoyir u t'ʌn C'uj, je' ya'arique' bic caj u jayaj tin jo'r a xquico', a qui' u boque' soc u c'ʌ'otic u c'aba' a je' xquica'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Caj ts'oc yiric u joyar tu jo'r Jesús a qui' u boque', caj bin Judas Iscariote quir u tsicbar yejer u jach ts'urirob sacerdote u winiquirob judío. Raji' turiri' ich doce u camsʌwinicob Jesús. Caj bin u c'ubic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Caj qui'jij yorob u jach ts'urirob sacerdote rajen caj u toc arajob je' u bo'ota' ten u jach ts'urir tu cotor u sacerdote quir u c'ubic Jesús. Caj u yʌnxchun u cʌxtic bic tabar je' u c'ubique'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Caj c'uchij tu q'uinin u q'uinin a cu janticob yo'och pan a mʌ' u sipe'. Ra' u q'uinin xan, cu quinsicob yʌrʌc' tʌmʌn yuc, chan ar soc u c'ʌ'oticob bic C'uj caj u tacaj u nunquirirob u winiquirob judío ich u ru'umin Egipto. C'uch u camsʌwinicob ich Jesús caj u c'atajob ti': ―Arej tenob tub a c'at a jantej a wo'och oq'uin tu q'uinin u qui' qui' janʌnob u winiquirob judío? Arej tenob tub a c'at in chʌcob? ");
INSERT INTO lacNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Caj u tuchi'taj ca'tur u camsʌwinicob, caj u ya'araj ti'ob: ―Xenex a je' cajaro', ti' ca bin a nupex tun, turiri' xib cu cuchic u p'urir u yo'och ja', sayenex tu pach. ");
INSERT INTO lacNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tu ca wiriquex tu cu yocar tu yatoch a ca' ts'ap yatocho', arex ti' u yumin a najo': “Yʌjcamsʌyʌnireche' cu c'atic: Tu yʌn u cuchir tu quin bin in jantejob a ba' cu naj janticob u winiquirob judío tu q'uinin pascua yejer in camsʌwinicob?” ");
INSERT INTO lacNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Raji'e' cu bin yesic techex junxot' yatoch u ca' tsap yatocho' toc yʌn u pojche'ir tu cu janʌn. Toc yʌn u cutan xan. Ti' taro' ca chʌquiquex ij co'ochex. ");
INSERT INTO lacNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Caj binob u camsʌwinicob Jesús caj yirajob an ten bic Jesús caj u ya'araj ti'ob, jeroj tune', caj chʌcajob yo'och quir u c'ʌ'oticob u q'uinin pascua. ");
INSERT INTO lacNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Barej caj ac'birchʌjij, caj c'uchij Jesús quir u janʌn. Yet tarac u doce u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Caj curajob tu janʌnob yejer Jesús ich u pojche'ir yo'och. Cu janʌn Jesús caj ya'araj: ―Jach taj quin wa'aric techex. Yʌn turiri' ich techex, a docejo', a mac a p'eri' ic janʌnex, a cu bin u mucu c'ubiquene'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Caj jach choquij yorob u camsʌwinicob Jesús. Jujuntur u camsʌwinicob cu bin u c'aticob ti' Jesús: ―Ten wa quin bin in c'ubiquech Jaj Ts'urir? ");
INSERT INTO lacNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Raji' tune', caj u nuncaj, caj u ya'araj ti'ob: ―A mac turiri' ich techex a docejo' a je' cu ruchic yo'och yejeren, raji' cu bin u c'ubiquen a ti' yʌn yejerechex. ");
INSERT INTO lacNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A teno' a baxuquenechexo', bin in ca' quinsbir, quire' tabar u nup'ur u t'ʌn C'uj. Chen otsir a mac a cu bin u mucu c'ubiquen a mac a tar soc u yamtic mac tu cotor. Jach manan tsoyir wa mʌ' ti' yʌn tera' ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Quire' tu cu janʌnobe', Jesús caj u ch'aj yo'och pan caj u yʌn t'ʌnaj C'uj: ―Bayo' C'uj, quire' caj a ts'aja to'onex ij co'ochex pan. Caj u rʌc xat'aj ti' u camsʌwinicob caj u ya'araj ti'ob: ―Jantex a je' pana' quire' in bʌq'uer. Jantex. ");
INSERT INTO lacNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Caj ts'oc u rʌc janticob yo'och pan, Jesús caj u chucaj u chan ruch yejer u c'ab u wich uva. Caj u yʌn t'ʌnaj C'uj: ―Bayo' C'uj, tech caj a ts'aja to'onex u c'ab u wich uva. Caj u ts'aja ti' u camsʌwinicob, caj u ya'araj ti'ob: ―Rʌc uq'uex ca' ca' xot' techex a wu'q'uiquex u c'ab u wich uva. ");
INSERT INTO lacNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Caj ya'araj ti'ob: ―A je' u c'ab u wich uva, in q'uiq'uer quir u nup'ur u t'ʌn a ba' tu ch'ic araj C'uj uch. A je' ba' cu bin joc'ar in q'uiq'uer soc yiric mac, ya'ab cu bin u jawsicob u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Taj quin wa'aric techex. Mʌ' in yʌnyʌn ca' uq'uic u c'ab u wich uva hasta cu xur t'ʌne', ca' bin in wuq'uej yejerex tu cu bin u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Caj ts'oc u c'ayob caj joc'ob caj binob ich u witsir Olivos. ");
INSERT INTO lacNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús tune', caj u ya'araj ti'ob: ―Techex tu cotorechex ca bin a p'ʌtiquenex ac'bir baje'rer quire' ca' nup'uc u t'ʌn C'uj tu cu ya'aric: “Quin cha'ic u quinsic a mac a cu cʌnantic yʌrʌc' tʌmʌn yuc, rajen cu bin puts'urob yʌrʌc' tʌmʌn yuc.” ");
INSERT INTO lacNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ca' bin wʌc'ʌs riq'uiquen tin quimirir ―quij Jesús―, ti' ca bin a wiriquenex ich u ru'umin Galilea. Chen a teno' quin yʌn bat'an c'uchur ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro tune', caj u ya'araj ti': ―Cax tu cotor in wet camsʌwinicob cu bin u p'ʌtiquechob, chen a teno' mʌ' in p'ʌtiquech. ");
INSERT INTO lacNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús caj u ya'araj ti': ―Jach taj, quin wa'aric tech, Pedro. Mʌ' toy c'aynʌc cax ac'bir baje'rer, cax mʌna' u nup u tenin u c'ay cax, ca bin a wa'aric ti' mac: “Mʌ' in wer mac Jesús.” ");
INSERT INTO lacNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Barej raji'e' caj u jach chen a'araj ti': ―Cax wa quet ij quimin, mʌ' in wa'aric: “Mʌ' in c'ʌ'otechi'.” Bayiri' xan, caj ya'araj u yet camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Caj c'uchij Jesús yejer u camsʌwinicob ich u chan corir u c'aba' Getsemaní. Caj u ya'araj ti' u camsʌwinicob: ―Te' a yʌn cutarexa', quire' tar quin bin baytʌc quir in t'ʌnic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Caj u pʌyaj tu pach Pedro yejer Jacobo yejer u yits'in Juan. Jesús caj u yʌnxchun u tucur, jach manan cu tucur caj c'uchij baytʌc. ");
INSERT INTO lacNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Caj u ya'araj ti'ob: ―Jach tucur in caj. Cu jach bin in wor irej wa bin in caj quimin. Te' a p'atarexa' mʌ' a wenʌnex soc a yamtiquenex. ");
INSERT INTO lacNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesús caj bin u t'ʌnej C'uj. Jach baytʌc caj bin, caj pʌch'raj quir u t'ʌnej C'uj ich ru'um. Caj u ya'araj ti' C'uj: ―Wa tsoy ta t'ʌn tech Tet, wa mʌ' a cha'ic in jach muc'yaj an ten bic caj a toc araj uch. Wa tsoy ta t'ʌn tech ca cha'ic in muc'yaj, baxuc ten tsoy tin t'ʌn xan, ca' tac ti' ten a ba' a c'at ten. ");
INSERT INTO lacNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tu cu t'ʌnic C'uj raji' caj u ya'araj: ―In Tetech C'uj ―quij―, c'ucha'an a wor ti' tu cotor ba', ruc'sej a je' muc'yaja' a cu bin tar ten wa ra' a c'at ca' muc'yajnʌquen, je' in muc'yaje', quire' in c'at in betic a ba' a c'at teche'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Caj riq'uij, caj bin ich u camsʌwinicob caj yiraj cu wenʌnob caj u ya'araj ti' Pedro: ―Simón, tan wa ja wenʌn? Mʌ' wa c'ucha'an a wor a muc'tic a wenʌn ca' a yamtejen cax turi' hora? ");
INSERT INTO lacNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","T'ʌnex C'uj, soc mʌ' u tumtic a worex, a quisino'. Cax a chen c'at ʌja'anechex soc a t'ʌniquex C'uj ti' ten. Chen mʌ' u c'uchur a worex a muc'tic a wenʌnex quire' jach tac a wenʌnex. ");
INSERT INTO lacNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Caj wʌc'ʌs bin Jesús caj u wʌc'ʌs t'ʌnaj u Tet, caj u ya'araj ra'iri' u caj wʌc'ʌs t'ʌno'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Caj ric' Jesús caj wʌc'ʌs ur ti' yʌn u camsʌwinicob. Caj yiraj wenʌn u ca'ob, mʌ' u muc'tob u wenʌnob. Mʌ' u p'irir u wichob. Mʌ' u yerob ba' u nunquicob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Caj tar mʌna' u nup u tenin ich u camsʌwinicob, caj u ya'araj ti'ob: ―Tsoy a wenʌnex baje'rer, jesej a bʌjex, baje'rer, c'uchij tu q'uinin u tarob u chuquenob a teno' a baxuquenechexo', rajen tsire'ej. Bin u c'ubiquenob a mac a yʌn u si'pirobe'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Riq'uenex, ca' xico'onex iric a mac a c'ubiquene' ti' yʌn jach baytʌc. ");
INSERT INTO lacNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ti' toy cu tsicbar Jesús barej seb caj c'uchij Judas Iscariote, raji' ti' u camsʌwinicob Jesús yejer once. Yet taracob jach pim mac, u rʌc ch'amʌnob u mascabir, bayiri' u rʌc ch'amʌnob che'. Tarob quire' tuchi'ta'bob ten u jach ts'urirob sacerdote u winiquirob judío, yejer u jach ts'urirob u cajarob u winiquirob judío, a cu ya'aric a Nuxibo', yejer u yʌjcamsʌyʌjiriob u t'ʌn Moisés. ");
INSERT INTO lacNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mʌ' toy c'uchuc Judas ich Jesús caj u toc araj ti'ob, a pimo': ―A ca wiriquex in ts'uts'ic u p'uc, ra' ca chuquiquex, ca' a qui' c'ʌxex u c'ʌb, ca' a purex ti' yejer mac a cu cʌnanticob ti' soc mʌ' u puts'ur Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Seb caj u juts' u bʌj ich Jesús, caj ya'araj Judas ti' Jesús: ―In wʌjcamsʌyʌjirech, in wʌjcamsʌyʌjirech. Jeroj tune', caj u ts'uts'aj u p'uc an ten bic cu naj t'ʌnic a cu camsic mac u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Robob tune', caj u mʌchajob, caj u chucajob. ");
INSERT INTO lacNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Turiri' ich a macob a ti' yʌn ti' taro', caj u jitaj u mascab caj u ch'ʌcaj u xiquin u c'urew u jach ts'urir sacerdote, caj rac u xiquin u c'urew u jach ts'urir sacerdote. ");
INSERT INTO lacNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Caj u t'ʌnaj Jesús caj u ya'araj ti'ob: ―Biquinin caj tarechex tera' yejer mascab, bayiri' yejer che' quir a chuquiquenex iren wa yʌja'criryʌjiren ba'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rajra' ti' yʌnen ich carem naj tu ca naj c'ujintiquex C'uj, caj in camsechex. Biquinin mʌ' ta chuquenex uch? A ba' u ber ten baje'rer quire' caj u toc araj uch yʌjtseq'uir u t'ʌn C'uj, a ts'a'b u tucuric ten C'uj quir u ts'ibtic a ba' u c'at C'uj, ra' quire' u nup'ur a ba' ts'iba'an. ");
INSERT INTO lacNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ra'iri' u q'uinin tu cotor u camsʌwinicob Jesús caj rʌc puts'ob. P'at Jesús tu junan. ");
INSERT INTO lacNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Barej say tu pach Jesús turiri' xib, mʌ' uch xuruc u baquer, u chen buquinmʌn u winquirir yejer turiri' sʌc noc', a linojo' u c'aba' u noc'. Raji' caj chucob ten a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Barej caj chuquij ten a pimo' caj ts'ub u noc' caj puts'ij, chʌc'ʌren. ");
INSERT INTO lacNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yʌjchuquirob Jesús caj bin purbir Jesús ich Caifás. Raji' u jach ts'urir tu cotor sacerdote, yejer u jer u ca' jach ts'urirob sacerdote, yejer u jach ts'urirob tu cotor u cajarob u winiquirob judío, a cu ya'aric, a Nuxibo', yejer u yʌjcamsʌyʌjirib u t'ʌn Moisés, quire' caj u much'quintob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Barej Pedroje' nach bin tu pach tu cu binob Jesús. C'ʌs nanach cu tar Pedro tac c'uchur tub re'a'an yatoch Caifás. Curucbar Pedro yejer a policíajo' cu q'uich, p'eri' yejerob. ");
INSERT INTO lacNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","U jach ts'urirob sacerdote yejer tu cotor u ts'urirob u winiquirob judío, tiri' u rʌc much'quinmʌnob u bʌj quir u wayticob quir u tus taquicob u jo'r Jesús soc u quinsa'rob Jesús. Mʌ' c'ucha'an yor u wayticob quir u tus taquicob u jo'r. ");
INSERT INTO lacNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Cax jach pim mac cu tar quir u tus taquicob u jo'r Jesús, mʌ' tu quetquintajob u t'ʌnob. ");
INSERT INTO lacNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jeroj tune', caj tarob ca'tur u winiquirob judío quir u tus taquicob u jo'r Jesús, robob tan ya'aricob: ");
INSERT INTO lacNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―A to'ono', tij cu'yaj ya'aric a je' xiba' cu bin u rʌc jubsic carem naj tu quic naj c'ujintiquex C'uj. A je' beta'ana' yejer u c'ʌb mac, je' u ca' ts'ʌpquintic u jer carem naj ca' bin ts'ocac u man mʌna' u nup u q'uinin, a mʌ' beta'an yejer u c'ʌb mac. ");
INSERT INTO lacNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Cax baxuc cu tsicbarob mʌ' tu quetquintajob u t'ʌnobi'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jeroj tune', caj ric ch'ictar Caifás ich ʌcʌtan tu cotor u yet jach ts'urirob u winiquirob judío ca' u c'atej ba' ti' Jesús, tan ya'aric: ―Biquinin mʌ' a c'ʌs nunquic ti' a mac cu taquicob a jo'r tech? ");
INSERT INTO lacNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús u mʌcmʌn u chi' uch, mʌ' u c'ʌs nunquic ti' u jach ts'urir. U jach ts'urir tu cotor sacerdote caj u wʌc'ʌs c'atej ti' tan ya'aric: ―Arej tenob wa tech a Cristojo' a mac caj u toc araj C'uj yʌn u tar quir u taquic tu cotor mac? Arej tenob wa tech u pararech C'uj a cu c'ujinta'bo' ten mac? ");
INSERT INTO lacNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús caj u ya'araj ti': ―Ten ―quij―, bin a wirenex xan a teno' a baxuquenechexo' curucbaren ich u no'oj C'uj, a jach manan chichir u muc'o'. Je' a wiriquex in tar tu muyʌrir ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","U jach ts'urir tu cotor sacerdote u winiquirob judío, seb caj u jʌtaj u noc' quir u yesic ts'iquij, quire' cu tucra' cu pach'ic C'uj Jesús an ten bic caj u nuncaj Jesús, caj u ya'araj u jach ts'urir tu cotor sacerdote: ―Ba'wir ti' u jer mac quir u ta'quic u jo'r? A bʌjiri'ex caj a wu'yajex cu pach'ic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Arex ten ba' ca tucriquex te'ex? Robob u jach ts'urirob tu cotor u winiquirob judío, caj u ya'arajob: ―Toc yʌn u si'pir, ca' quinsac. ");
INSERT INTO lacNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jun yarob caj u yʌnx chun u tubob u wich, u jerob caj u pixob u wich Jesús caj u raxajob xan, cu ya'aricob: ―Arej tenob mac caj u raxech. U policía a caj u chucajobo' caj u tacjʌts'ajob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ti' toy yʌn Pedro ich tancab tu re'a'an yatoch Caifás, caj u juts'aj u bʌj turiri' xquic ich Pedro. Ra' u c'urew xquic Caifás; ");
INSERT INTO lacNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Barej caj u yiraj cu q'uich Pedroje', caj u pʌctaj, caj u ya'araj ti': ―A tech xane' ―quij ya'ara'―, ti' a wet man Jesús a cu tar tu cajar Nazaret. ");
INSERT INTO lacNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Barej raji', caj u ya'araj: ―Mʌ' teni' ―quij Pedro―. Mʌ' in wer ba' ca wa'aric. Mʌ' in wer maqui'. Pedro caj joc' tancab baytʌc tu yʌn u jor naj, jeroj caj c'aynʌj a caxo'. ");
INSERT INTO lacNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Caj wʌc'ʌs irir ten u c'urew xquic Caifás caj wʌc'ʌs a'ara ti' a macob a ti' yʌnob taro': ―A je' xiba', jach taj, u yet man Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Barej raji' caj u wʌc'ʌs a'araj: ―Mʌ' teni' ―quij caj ya'araj. Chen sansame', a mac a ti' yʌnob uch taro', caj u wʌc'ʌs a'arajob ti' Pedro: ―Jach taje' tech a wet mʌn Jesús uch, a mʌ' quet baxuc a t'ʌn yejer Jesús quire' u xibirech u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Caj ara'b Pedro, cu chuquic C'uj, tan ya'aric: ―C'uj cu yiric, wa mʌ' in wer a mac a ca wa'ariquexe', cax u quinsiquen C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bayiri' caj ca' c'aynʌj cax tu ca' ten, Pedro caj u c'asaj yic' a ba' ara'b ten Jesús uch: “Mʌ' toy wʌc'ʌs c'aynʌc a caxo' mʌna' u nup u tenin ca bin a wa'aric mʌ' a wer maqueni'.” Pedro caj oc'nʌjij. Caj jach qui' oc'nʌjij Pedro tun. ");
INSERT INTO lacNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Barej caj sasij seb tu cotor u jach ts'urirob sacerdote yejer u jach ts'urirob u cajarob u winiquirob judío, a cu ya'aricob a Nuxibo', yejer yʌjcamsʌyʌjirob u t'ʌn Moisés, yejer a mac t'irir ich tu cotor u jach ts'urirob u winiquirob judío, caj u much'quintajob u bʌj quir u tucricob bic tabar cu bin u c'ubicob c'ʌxbir Jesús ich Pilato. Caj c'ax u c'ʌb Jesús caj tar purbir ich Pilato, raji' gobernador. ");
INSERT INTO lacNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","A Pilatoje' caj u c'ataj ti': ―Taj wa ju reyech u winiquirob judío? Caj u nuncaj raji', cu ya'aric ti': ―Baxuc ca wa'ariquen, a teno' u reyen u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","U jach ts'urirob sacerdote, ya'ab caj u tocob u jo'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","A Pilatoje', caj u wʌc'ʌs c'ataj ti', cu ya'aric: ―Biquinin mʌ' a c'ʌs nunquic u taquicob a jo'r quire' jach ya'ab tan u taquicob a jo'r? ");
INSERT INTO lacNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús mʌ' u c'ʌs nuncaj chichin, rajen jach jaq'uij yor Pilato. ");
INSERT INTO lacNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Toc beri' cu siptic mac tub mʌca'an ca' bin c'uchuc tu q'uinin u qui' qui' janʌnob u winiquirob judío, u q'uinin tu potmastaj yʌjmasir u t'ʌn C'uj uch. Mʌ' ja wirej, a gobernadoro' cu bin u siptic a mac mʌca'an a cu c'ata' ti' ten u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A ray u q'uinino' ti' mʌca'an mac jach c'as. Ra' u c'aba' Barrabás, raji' c'ʌra'an yejer u yet ric's ʌjba'te'ob, mac u quinsmʌnob winic tu tu ric'sajob ba'te' uch. ");
INSERT INTO lacNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ra' u quinin, ti' cu tarob a ya'ab macob u winiquirob judío, quir u much'quinticob u bʌj ich Pilato, caj u yʌnxchun u c'aticob ca' u betej an ten bic cu naj beta'r ti'obe'. ");
INSERT INTO lacNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato tune', caj u nuncaj ti'ob, cu ya'aric: ―A mac a c'at in siptiquex techex? Arex ten ca' in siptej ti' techex u rey u winiquirob judío? ");
INSERT INTO lacNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mʌ' ja wirej, Pilato yer q'uex yorob u jach ts'urirob sacerdote, rajen c'ubob Jesús ten u jach ts'urirob sacerdote u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Barej u jach ts'urirob sacerdote u winiquirob judío caj u p'usaj u yorob a ya'ab macob quir u cha'bʌr ti'ob Barrabás, cax mʌ' u cha'bʌr Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jeroj tune', caj u nuncaj Pilato, caj u wʌc'ʌs a'araj ti'ob: ―Ba' a c'atex ca' in betej ti' a mac a ca wa'ariquex u rey u winiquirob judíojo'? ");
INSERT INTO lacNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Robob a pim macob, caj u c'amquintajob t'ʌnob ti' tu ca'ten: ―Arej ti' ca' xic sinbir ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Barej Pilato caj u ya'araj ti'ob: ―Biquinin cu bin sinbir ich cruz quire' mʌna' c'as caj u betaj? Caj chen c'amquintaj u t'ʌnob a pimo': ―Arej ca' sinic ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A Pilatoje', quire' u c'at u qui'quintic u yorob a pimo', rajen caj u cha'j u bin Barrabás. Caj ts'oc u jʌts'icob u pach Jesúse', caj u c'u'saj ca' quinsac tu cruz. ");
INSERT INTO lacNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A soldadojo' tune', caj acsa'b Jesús ich palacio gobernador, tu re'a'an naj. Caj u t'ʌnajob u much'quinticob u bʌj tu cotor u yet soldadojob gobernador. ");
INSERT INTO lacNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Caj pit u noc' Jesús ten soldadojo', caj ts'a'b u buquintej chʌc noc' Jesús. Caj jit'ob a q'ui'ixer u ca'o' quir u ts'a'bʌr u p'oquintej Jesús q'ui'ix. ");
INSERT INTO lacNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jeroj tune', caj chinrajob ʌcʌtan ti' Jesús ten a soldadojo', caj u tus t'ʌnajob an ten bic cu naj t'ʌnicob rey cu ya'aricob: ―In c'atob ca' cuxraquech munt q'uin u reyech u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Caj u c'oc'ojʌts'tajob tu jo'r Jesús yejer jʌrʌr, caj u tubob u wich. Ti' rʌc xonrʌjob ich ʌcʌtan Jesús an ten bic cu xontarob ich rey cu tus esicob u sʌjticob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Barej caj ts'oc u p'asticobe', caj u pitajob a chʌc noq'ue', a tu tus ts'ajob sam ti'e' caj u buquintajob u wʌc'ʌs noc' caj u joc'sajob quir u quinsa'r tu cruz. ");
INSERT INTO lacNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A uche' caj u man taro' turiri' xib, u c'aba' Simón, u tet Alejandro yejer Rufo. A Simóno' caj tar tu ru'umin Cirene uch. Cu yu'ur tu cor caj ts'ar u pach quir u c'o'ochic u cruz Jesús tu cu bin bʌjbir. ");
INSERT INTO lacNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Caj u pʌyajob Jesús tu chan witsir u c'aba' Gólgota, u c'at ya'aric: U Cuchir U Baquer U Jo'r. ");
INSERT INTO lacNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Caj u tumtaj ca' ts'abʌc u c'ab u wich uva u yuq'uej, aro' xaca'an u ts'ac mirra, barej raji'e' mʌ' tu yuc'aji'. ");
INSERT INTO lacNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jeroj tune', caj ts'oc u bajʌr Jesús ten soldadojob caj u jʌsajob u noc' Jesús caj u chictajob chan tunich quir yiric mac cu bin u ch'ic u noc' Jesús. Soc yerob ba' cu bin ch'ic jujunturob. ");
INSERT INTO lacNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ca'anan u q'uinin, jach jats'cab caj u sinajob tu cruz. ");
INSERT INTO lacNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ts'ibta'b ich c'ʌs chumuc u jo'r u cruz Jesús, irej wa ju cuchir ts'ib quir yiric ba' u si'pir. Caj u ts'ibtaj: “A je' xiba' Jesús, u rey u winiquirob judío.” ");
INSERT INTO lacNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Caj u sinajob tu cruz yejer raji' ca'tur xib, a cu ya'cricob ba'. Caj baj ten soldado. Turiri' tu noj Jesús, turiri' tu ts'ic xan Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Rajen toc nup'a'an a ba' ts'iba'an ich u t'ʌn C'uj a cu ya'aric: “Caj u tucrajob wa raji' p'eri' yejer a mac a yʌn u si'pirobe'.” ");
INSERT INTO lacNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A macob a cu manob uche' taro', caj u p'astajob, caj u chictob u jo'r an bic cu naj p'asticob mac, tan ya'aricob: ―A techo' ca wa'aric je' a jubsic carem naj, ca wa'aric mʌna' u nup u q'uinin a wʌc'ʌs ts'ʌpquintej u jer carem naj. ");
INSERT INTO lacNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tac a bʌj ich a cruz, wʌc'ʌs emen ta cruz. ");
INSERT INTO lacNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ti' yʌnob xan, caj u p'astob Jesús u jach ts'urirob, cu pacran ya'aricob, quet yejer yʌjcamsʌyʌjirob u t'ʌn Moisés: ―A ray xibo', chen u jer cu taquic, u bʌjiri' mʌ' c'ucha'an u muc' u wʌc'ʌs taquic u bʌji'. ");
INSERT INTO lacNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ca' ij quirex wa raji' Cristo, a mac tuchi'ta'b ten C'uj, u rey u winiquirob Israel. Ca' emac tu cruz baje'rer, ca' in wirejob soc ca' in wacsejob tin worob ti'. Baxuc xan, u yet bʌja'an winiquirob caj u p'astajob ti'. ");
INSERT INTO lacNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Caj c'uchij c'ac'chun q'uin caj ac'birchʌjij ich yoc'ocab tac u man mʌna' u nup horas. ");
INSERT INTO lacNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tabar u c'uchur a mʌna' u nup horaso' caj c'am t'ʌnʌj Jesús caj awʌtnʌjij, caj ya'araj: ―Eloi, Eloi, lama sabactani? ―u c'at ya'aric: In C'ujech, in C'ujech, biquinin ca p'ʌtiquen tin junan? ");
INSERT INTO lacNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Barej caj u'yab ten jun yarob a mac a ti' yʌnob ti' taro', caj u ya'arob: ―U'yex ba' cu ya'aric. Cu t'ʌnic Elías, yʌjtsequir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Caj u c'ʌnaj yacab turiri' tu yʌn ya'arir a pʌj u c'ab u wich uva, caj u ts'ʌmaj u noq'uir quir u ts'uts'ic ya'arir a pʌj u c'ab u wich uvajo'. Caj u chucaj caj u tʌcaj tu che'er jʌrʌr quir u nacsic u ts'a ti' yuq'uej. Caj u ts'aj u yuq'uej caj ya'araj: ―Pajo'onex, ca' ij quirex wa cu bin tar Elías, ca' u yensej tu cruz Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Barej Jesús caj c'am t'ʌnaj, caj u putaj yic', caj quimij. ");
INSERT INTO lacNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","U noc' a t'ina'ano' ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío, a cu jʌsic jun xot' naj tu cu bin u wa'quic u q'uiq'uer yʌrʌc' soc u ruc'sic u si'pirob mac. Ra' u noq'uir seb caj jat chumuc. Caj u yʌnxchun u jatʌr ca'anan tac u c'uchur u jatʌr ich u xax u noq'uir. ");
INSERT INTO lacNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","U jach ts'urir cien soldadojob u winiquirob romano, a ti' yʌn uch ʌcʌtan ich Jesús, caj u yiraj ts'oc u quimin an ten bic a jera', caj u ya'araj: ―A je' xiba' jach taj u parar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Baxuc xan, ti' yʌnob jun yarob xquicob, c'ʌs nach cu pʌcticob Jesús a ray xquicob. Ti' yʌnob María, ra' cʌja'an tu cajar Magadalena, ti' yʌn María u nʌ' Jacobo a chichano', yejer José, ti' yʌn xan Salomé. ");
INSERT INTO lacNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ra' yet manacob yejer Jesús caj tarob tu pach Jesús. Caj tarob tu pach Jesús caj u p'ʌtaj u ru'umin Galilea. Quire' ti' yʌn ich u ru'umin Galilea. Robob caj u yamtajob Jesús, ti' yʌn u jer ya'ab xquicob caj binob uch tu cajar Jerusalén yejer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Barej caj ac'birchʌjij, raji' u q'uinin cu pac much'quinticob yo'och quir u qui' qui' janʌnob. Mʌ' ja wirej, saman u q'uinin u jesicob u bʌj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Caj tarij José, ti' cu tar ich u cajar Arimatea, raji' turiri' ich tu cotor u jach ts'urirob u winiquirob judío, a mac tsoy yor, ich u jach ts'urirob u winiquirob judío. Raji' xan, cu pajic u q'uinin tu cu bin u reyinticob C'uj. Caj u chichquintaj u yor quir u bin ich ʌcʌtan Pilato quir u c'atic u baquer Jesús quir u but'ic tu japnin tunich José. ");
INSERT INTO lacNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jac' yor Pilato, quire' toc quimij Jesús, caj u tuchi'taj t'ʌnbir u jach ts'urir cien soldadojob u winiquirob romano, caj u c'ataj ti' wa taj toc quimij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Barej caj u yubaj tu chi' tu jach ts'urir cien soldadojob u winiquirob romano, caj yubaj ya'aric wa quimij Jesús tu ts'aj u baquer ti' José. ");
INSERT INTO lacNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Raji'e' caj u mʌnaj turiri' sʌc noc', lino u c'aba' a sʌc noq'ue', caj ts'oc u yensic u baquer caj u tapaj yejer a sʌc noq'ue', caj bin u but'ej ich japnin tunich, ra' toc beta'b u japnin uch ti' tunich. Jeroj tune', caj u bʌc'ʌstaj turiri' tunich tu jor u japnin tunich quir u qui' pe'che'tic. ");
INSERT INTO lacNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María a cu tar tu cajar Magdalena yejer María u nʌ' José uche', caj u pʌctob tu bin t'ajbir u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Barej caj man u q'uinin tu cu jesicob u bʌj u winiquirob judío, María, a cu tar tu cajar Magdalena, quet yejer María, u nʌ' Jacobo, quet yejer xan Salomé, robob caj u mʌnajob a qui' u boc soc c'ucha'an yorob u chojicob u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","U q'uinin u yʌnxchun semana, jach a'ac'bir tan u tar q'uin caj tarob tu t'aja'an u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Cu pacran a'aricob a xquico': ―Mac cu bin u bʌc'ʌstic ti' to'onex a tunicho' a ti' yʌn tu jor a tu t'aja'an u baquero'? ");
INSERT INTO lacNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Caj c'uchob caj u nacsaj u wichobe', caj u yirajob a jach carem tuniche', toc bʌc'ʌsa'an. ");
INSERT INTO lacNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Barej caj ocob tu t'aja'an u baquer Jesús, caj u yirajob turiri' xib, mʌ' uch xuruc u baqueri'. Ti' c'ura'an tu noj a xquique'. Raji' u buquinmʌn jach c'ʌrʌp sʌc noc'. Caj jaq'uij yorob a xquico', caj yirob curic. ");
INSERT INTO lacNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Barej raji'e', caj u ya'araj ti'ob: ―Mʌ' u jac'ʌr a worex ―quij―, ca cʌxtiquex Jesús, a cu tar tu cajar Nazaret uche', a mac quinsa'b tu cruz. Wʌc'ʌs riq'uij, mʌna' Jesús tera' ―quij―, ca' cuxrajij ―quij― te' yʌn u wa'aya' tu chaquinta'b u baquer ucha', iric ―quij―. ");
INSERT INTO lacNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Barej xenex, arex ti' u camsʌwinicob, quet a wa'ariquex ti', yejer Pedro: “Arex ti'ob cu bin tu ru'umin Galilea, raji' cu bin yʌn bat'an c'uchur. A techexo', pachir a c'uchurex. Ti' ca bin a wirex aro' an ten bic caj u toc araj techex uch.” ");
INSERT INTO lacNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Caj joc'ob ich tu t'aja'an u baquer Jesús uch, caj u c'ʌnajob yacab quir u puts'urob quire' jach manan sajʌcob, tu chen quiquirʌncʌrob. Mʌna' ba' caj u ya'arajob ti', quire' jach sajʌcob. ");
INSERT INTO lacNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Barej caj riq'uij Jesús ti' u quimirir, a'ac'bir, u q'uinin u yʌnxchun semana, caj u yʌn bat'an esaj u bʌj ti' María, a cu tar tu cajar Magdalena, ra'iri' María a joc'sa'b siete u quisinob ten Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Caj bin María, caj u ya'araj ti' u yet manob uch Jesús, caj c'uchij María cu yoc'arob, cu yacticob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Robobe', cax caj u yubajob cuxa'ane', cax yubobo' irir ten María. Robob caj u ya'arajob: ―Mʌ' taji' ―quij. ");
INSERT INTO lacNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Barej pachir ca'tur caj u yirajob mʌ' irej Cristo, caj u yirajob quire' jarpʌjij quimij, cu binob ximbar ich chʌcʌn, caj u yirajobi'. ");
INSERT INTO lacNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Caj binob, robobe' ya'arej ti' u rac'ob, barej, mʌ' ju quibob caj yubob ya'ara' ti'ob, xan. ");
INSERT INTO lacNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pachir caj u yesaj u bʌj cuxa'an ti' a oncejo' u camsʌwinicob tu junanob, quire' curucbarob tu janʌnob. Caj q'ueya'bob ti'ob quire' cax ara'b ti'ob ten yʌjirirob Jesús, chen mʌ' ju yacsob tu yorob wa riq'uij. Caj q'ueya'bob xan, quire' chich u jo'rob. ");
INSERT INTO lacNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Caj u ya'araj ti'ob: ―Joq'uenex ca' a tsec'tex u jach tsoyir u t'ʌn C'uj ich tu cotor mac ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","A mac a cu yacsic tu yor bayiri' xan, tan yacsa' ja' tu jo'r, bin tocac ten C'uj. Barej a mac a mʌ' ju yacsej tu yor, ti' toy yʌn u si'pir quire' mʌ' ju yacsaj tu yore', raji' cu bin satʌre'. ");
INSERT INTO lacNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A ba' mʌna' mac yirmʌni' uch, mʌ' biq'uin yirmʌni', ra' cu bin esbir ten an mac a yacsmʌnob tu yorob an ten bic a jera': Bin u joc'sicob quisinob quire' ten tin ts'aja u muc'ob. Bin u tsicbarob ich u t'ʌn a mac mʌ' u najticob uchi'. ");
INSERT INTO lacNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wa cu chuquic can, cax wa cu yuq'uic a ba' cu quinsic mac, mʌ' u bin c'astar. Bin u cu ts'anc'ʌbtic a mac yaje', jeroj cu jawʌra'. ");
INSERT INTO lacNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","A Jaj Ts'uro', caj ts'oc u tsicbar yejerob caj bin ca'anano', caj curaj ich u no'oj C'uj quir u sʌjta' ten tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","U camsʌwinicob Jesús tune', caj joc'obe' quir u tsec'ticob u t'ʌn Jesús ti' tu cotor mac, jach quet u beyaj u Jaj Ts'urir yejerob. A Jaj Ts'uro' caj u yesaj a ba' cu tsicbarob u camsʌwinicob ra' taj cu ya'aricob. Jeroj Ts'oquij, quij.");
INSERT INTO lacNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Quire' a wer Teófilo ya'ab mac caj u yʌnxchun u ts'ibticob ba' u ber tu yʌnenob uch a ti' yʌn tu yʌno'onex uch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Caj u yʌnxchun u ts'ibticob u t'ʌn Jesús. Caj u ts'ibtajob a ba' ara'b ten a mac tu yirob Jesús a tu yʌnxchun raji'ob xan caj mʌnob u yamtejob u tsec'ticob u jach tsoyir u t'ʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Rajen tin qui' cʌxtaj in wirej xan wa taj caj u betaj Jesús uch caj ts'oc in wiric taj a ba' caj u betaj Jesús caj in ts'ibtaj a ba' caj u yʌnxchun u betic Jesús hasta baje'rer soc tech a wer u bʌjob in bʌj, Teófilo. ");
INSERT INTO lacNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Rajen caj in ts'ibtaj tech Teófilo soc a toc er a ba' taj tu camsech uch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ti' yʌn mac cu reyintic u ru'umin Judea, Herodes u c'aba'. Ra' u q'uinin cuxa'an sacerdote pʌcha'an u c'aba' Zacarías. Raji' cu beyaj yejerob yo'nen Abías. Zacarías caj u raq'uintaj Elisabet ra' yo'nen Aarón raji' yo'nen xan sacerdote. ");
INSERT INTO lacNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías yejer u rac' caj yiraj C'uj taj cu quibicob u t'ʌn C'uj. Caj yiraj C'uj taj cu qui' mʌnob ich u tsoyir a ba' caj u ya'araj C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mʌna' u parar Elisabet quire' mʌ'ju c'uchur u yor u pararʌncʌr. Mʌ' ja wirej, u beri' mʌna' u parar, toc ch'ija'an toc ca'turo' yejer u mam baje'rer mʌ' ju pararʌncʌr caj ch'ijob uch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ra' u q'uinin toc p'isa'an tu cu beyaj Zacarías an ten bic sacerdote ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Ra' u q'uinin cu beyaj ti' yo'nen Zacarías. ");
INSERT INTO lacNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","An ten bic nanij cu bin u toquic a qui' u boque' ich carem naj. Caj bin Zacarías quir u toquic quire' teta'b ten u yet sacerdote. Caj teta'b Zacarías caj ts'oc u yʌrʌc'tic chan tunich. ");
INSERT INTO lacNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ra' u q'uinin cu toquic a qui' u boque' Zacarías, tu cotor a pimo' tan u t'ʌnicob C'uj ich u tancabir carem naj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Yʌjmasir u t'ʌn C'uj caj u yesaj u bʌj ti' Zacarías. Zacarías caj yiraj yʌjmasir u t'ʌn C'uj, ch'iquicbar ich u noj tu cu toquic a qui' u boque'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Caj yiraj yʌjmasir u t'ʌn C'uj Zacarías jach jaq'uij yor quire' mʌ' yer ba' u c'at yʌjmasir u t'ʌn C'uj caj u ch'aj sajquir. ");
INSERT INTO lacNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yʌjmasir u t'ʌn C'uj caj ya'araj ti': ―Mʌ' ju jac'ʌr a wor ten, Zacarías. C'uj cu yubic a t'ʌn rajen cu bin yʌntar a parar ca' a pʌchej u c'aba' Juan. ");
INSERT INTO lacNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ca' bin qui'ac a wor jach manan qui' a wor. Ya'ab mac cu bin qui' tar yorob quire' yʌn a parar Zacarías. ");
INSERT INTO lacNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Quire' a parar ca' bin rochac ten u nʌ' jach carem ʌcʌtan u wich C'uj. Mʌ' ju bin yuq'uic u c'ab uva a parar. Bayiri' trago mʌ' ju bin yuq'uic xan. Toc aca'an ti' u Taj'or u Pixam C'uj quir u ts'urintic ca' bin rochac ten u nʌ'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jach ya'ab cu bin yacsic tu yor ti' C'uj ca' bin yubej u tsec'tic u t'ʌn C'uj u winiquirob israel. ");
INSERT INTO lacNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A parar Juan cu bin u ts'urinbir u Taj'or u Pixam C'uj soc c'ucha'an yor ti' tu cotor ba' an ten bic Elías uch. Ca' bin yubob u winiquirob judío u tsec'tic u t'ʌn cu bin u quetquintic u yor u pararob yejer u tet soc p'eri'ob yor. Cu bin u tsec'tic ti'ob soc u c'axicob yor a mac a mʌ' ju quibicob C'uj. Soc cu bin u quibicob a mac taj yor, a mac u ne'er. Soc c'ucha'an yor u c'ʌmic a Cristojo' ca' bin tac. ");
INSERT INTO lacNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías caj u c'ataj ti' yʌjmasir u t'ʌn Jaj Ts'ur: ―Bic tabar in jach er taj a ba' ca wac quire' jach uch ch'ijiquen yej in rac'? ");
INSERT INTO lacNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Caj u nuncaj yʌjmasir u t'ʌn C'uj: ―A teno', raji' in c'aba' Gabriel, quin beyaj ʌcʌtan ti' C'uj. Raji' tu tuchi'tajen quir in wa'aric tech a je' jach tsoy t'ʌna'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A techo' mʌ' ta quibaj in t'ʌn a ba' tin toc a'araj tech baje'rer. Baxuquech mʌ' ju bin joc'ar a t'ʌn hasta cu c'uchur tu q'uinin u rocha'r a parar ten u nʌ'. Jeroj cu joc'ar a t'ʌn. Ca' bin c'uchuc tu q'uinin cu bin joc'ar jach taj an ten bic tin wa'ara tech. ");
INSERT INTO lacNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ti' yʌn a pimo' ich tancab tan pajicob ca' joc'ac Zacarías caj jaq'uij yorob quire' oma'an joc' Zacarías ich japnin carem naj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Caj joc' Zacarías mʌ' ju joc'ar u t'ʌn. Caj u najtajob a pimo' yʌn ba' caj u yiraj Zacarías ich carem naj, caj yesa yejer u c'ʌb Zacarías quire' mʌ' ju joc'ar u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Caj c'uchij tu q'uinin u ts'ocar u beyaj Zacarías ich carem naj, caj bin ich yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Caj ur Zacarías ich yatoch caj yʌnjij u parar Elisabet. Mʌ' ju c'ʌs joc'ar hasta manij cinco icnʌ'. Tan u tucric ich yor, Elisabet caj u tucraj tu yor: ");
INSERT INTO lacNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“In Jaj Ts'urir caj u jawsaj in suraquir tu mʌ' ju yʌn tar in parar. Caj u yamtajen C'uj, soc mʌ' jin pʌyic in su'tar ti' a pim baje'rer.” ");
INSERT INTO lacNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Yʌn seis icnʌ' caj najij u nʌc' yejer yʌrʌc' och Elisabet, caj wʌc'ʌs tuchi'ta'b ten C'uj yʌjmasir u t'ʌn ra'iri' Gabriel ca' xic ich u ru'umin Galilea tu cajar Nazaret. ");
INSERT INTO lacNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Caj bin yiric turiri' xquic a mʌ' yer ba' hasta cu ch'ic u María quire' José cu bin raq'uintic María toy c'ata'b ten José, ra' u nunquir David uch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yʌjmasir u t'ʌn C'uj caj oc tu yʌn María caj u t'ʌnaj: ―A C'ujo' cu bin u yamtiquech soc jach manan tsoyirech. Mʌna' u jer xquic baxuco' chen tech tsoyech. ");
INSERT INTO lacNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María caj yiraj yʌjmasir u t'ʌn C'uj caj jaq'uij yor María a ba' yuba ya'ara' ti'. Caj u tucraj tu yor: “Biquinin cu t'ʌniquen baxuc aro'.” ");
INSERT INTO lacNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yʌjmasir u t'ʌn C'uj caj ya'araj: ―Mʌ' ju jac' a wor ten, María, C'uj cu jach qui' qui' yajquintiquech María. Mʌ' ja wirej, C'uj cu bin yesic bic u jach yajquintiquech. ");
INSERT INTO lacNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Baje'rer cu bin yʌntar a parar raji' ca bin a rochej xib, ca' a pʌchej u c'aba' JESÚS. ");
INSERT INTO lacNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A'a parar Jesúso' jach ne no'j, raji' u parar C'uj a ti' yʌn ca'anano'. A Jaj Ts'ur a C'ujo' cu bin yacsic soc u reyinticob u winiquirob judío an ten bic u nunquir David caj u reyintajob uch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Raji' cu bin u reyinticob u winiquirob israel munt q'uin mʌ' ju ts'ocar u reyinticob u winiquirob israel. ");
INSERT INTO lacNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María caj u c'ata ti' yʌjmasir u t'ʌn C'uj: ―Bic tabar in pararʌncʌr quire' mʌ' toy in ch'aj in mami'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Caj nunca'b ten yʌjmasir u t'ʌn C'uj caj ara'b ti': ―Je' u tar tech u Taj'or u Pixam C'uj soc u yʌntar a parar quire' jach yʌn u muc' C'uj jach manan ti', rajen cu yʌntar a parar. Ca' bin a rochej a parar yʌn u bin sʌjta'bir ten mac quire' u parar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ira wirej, a bʌjob a bʌj Elisabet baje'rer yʌn u parar cax uch ch'ijic yʌnij u parar. Cax a ucho' caj u ya'araj u rac'ob mʌ' u yʌntar u parar. Baje'rer yʌn ti' seis icnʌ' caj yʌnij u parar xib. ");
INSERT INTO lacNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Quire' a ba' caj u toc araj C'uj c'ucha'an yor ti' cax ca tucric C'uj mʌ' c'ucha'an yor ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Caj ya'araj María: ―A teno' ―quij María―, u c'urewen in Jaj Ts'urir. Arej ti' C'uj a ba' u c'at u betic ten tsoy quire' ti' yʌnen quir u yʌntar in parar. Caj ts'oc u tsicbar María caj bin yʌjmasir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mʌ' jach uch caj yiraj yʌjmasir u t'ʌn María, caj bin yirej u bʌjob u bʌj Elisabet. Seb caj toc bin María ich u bʌjob u bʌj quire' ti' cʌja'an Elisabet ich u cajar ich u ru'umin Judea a yʌn u witsir. ");
INSERT INTO lacNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Caj oc María ich yatoch Zacarías. Caj t'ʌn Elisabet ten María. ");
INSERT INTO lacNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Caj yubaj u t'ʌnʌn Elisabet seb caj pecnʌj ich u nʌc' Elisabet u chan ochir. Quire' jach yʌn ti' u Taj'or u Pixam C'uj Elisabet. ");
INSERT INTO lacNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Rajen caj c'am t'ʌn María ten Elisabet quire' qui' yor: ―A techo', María, jach manan u qui' yajquintiquech C'uj quire' mʌna' u jer xquic teta'b an ten bic tech ―quij―. Jach tsoy a parar ca' bin a rochej quire' C'uj cu bin u yamtic a parar. ");
INSERT INTO lacNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Maqueni' cu tar yiriquen u nʌ' in Jaj Ts'urir C'uj? Mʌ' ja wirej, tan u sʌjtiquen María. ");
INSERT INTO lacNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Caj tarech caj a t'ʌnen caj yubaj a t'ʌniquen caj pecnʌj in chan ochir ich in nʌc' quire' qui' yor. ");
INSERT INTO lacNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Caj ya'araj Elisabet: ―Jach qui' a wor María quire' ta quibaj u t'ʌn yʌjmasir u t'ʌn C'uj caj ya'araj: “Je' u yʌntar a parar.” Mʌ' ja wirej, a wer bin u nup'ur a ba' caj u ya'ara tech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Caj u nuncaj María: Jach qui' in wor quire' caj in wa'araj ti' in Jaj Ts'urir: jach caremech Jaj Ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Jach qui' in wor ʌcʌtan C'uj quire' raji' in wʌjtaquir. ");
INSERT INTO lacNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A C'ujo' tu yajquin ten quire' u c'urewen C'uj cax mʌ' no'jen. Caj ya'araj María: Ca' bin ts'ocac in rochic in parar je' ya'aric a jach pimo': C'uj caj u betaj a tsoyo' ti' ten. Baxuc cu bin ya'ariquenob mac hasta cu xur t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","A C'ujo' jach manan chichir u muc' quire' caj u yamtajen. Mʌ' ja wirej, jach carem u c'aba' quire' mʌna' u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A C'ujo' cu yajquintic mac quire' a mac cu sʌjtic C'uj. Cax ber u q'uinin ca' bin rochac ten u nʌ' cu bin yajquinbir ten C'uj wa cu sʌjtic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A C'ujo' caj u yesaj wa raji' jach manan chichir u muc', bayiri' u ne'er tu cotor ba'. Raji' c'ucha'an yor u ch'esic u beyaj a mac a cu tucric jach carem, a mac a cu tucricob u jach ne'er ba' soc robob mʌ' u c'uchur u yor ti' mʌna' ba'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A C'ujo' c'ucha'an yor u joc'sic a mac a cu ts'urintic u rac'ob a jach no'j u beyaj. Baxuc xan c'ucha'an yor u ts'ic u beyaj ti' a mac irir ten u rac'ob a mʌ' no'jo'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A C'ujo' cu bin u qui'quintic yor a mac a jach otsir yejer a ba' jach tsoyo'. Baxuc xan a mac neyaj u taq'uin, mʌna' ba' cu ts'ic ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A C'ujo' caj u yamtaj u winiquirob israel quire' u yaj. A baywo' caj nup' u t'ʌn C'uj a ba' caj u toc araj ti' ic nunquir uch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Quire' caj u c'ʌ'otaj u yajquintaj u winiquirob israel. Baxuc caj ara'b ti' ic nunquir Abraham yejer u bʌjob soc munt q'uin cu yajquintic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María caj p'at yejer u bʌjob u bʌj Elisabet. Tres icnʌ' ti' yʌn María ich u bʌjob u bʌj. Pachir caj u wʌc'ʌs bin María ich yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Caj c'uchij tu q'uinin caj pararnʌjij Elisabet, xib caj u rochaj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Caj yubob u rac'ob caj u rochaj u parar Elisabet, baxuc xan u bʌjob caj rʌc qui'ji yorob yejer Elisabet. Caj yajquinta'b ten C'uj rajen yʌnij u parar. Rajen jach qui' yor u rac'ob yejer u bʌjob. ");
INSERT INTO lacNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Caj manij turi' semana caj rʌc tarob quir u chan sesic u bʌq'uer an ten bic nanij cu beticob u winiquirob judío quir u yacsicob u c'aba'. U c'at u chen pʌchicob u wʌc'ʌs jer u c'aba' u tet Zacarías. ");
INSERT INTO lacNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Caj u ya'araj u nʌ': ―Mʌ' a pʌchiquex u c'aba' Zacarías, tsoy ic pʌchic u c'aba' Juan. ");
INSERT INTO lacNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Caj ya'arob: ―Mʌna' u c'aba' baxuc ich a bʌjob. ");
INSERT INTO lacNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Caj c'ata'b ti' u tet ba' quir u c'aba' ca bin a pʌchej, tan yesicob yejer u c'ʌb ti' Zacarías. ");
INSERT INTO lacNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Caj u mʌcantaj u c'ʌb caj u c'ataj u chan pequer che' caj tar purbir ti' caj u ts'ibtaj: “Ra' u c'aba' Juan.” Rajen jaq'uij yor u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ray u q'uinino' seb caj joc' u t'ʌn Zacarías caj u yʌnxchun u t'ʌnic C'uj: ―Jach caremech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A mac ti' cʌja'an tu cajar Zacarías caj u ch'aj sajaquirob caj rʌc mʌn u jumintob ich tu cotor u ru'umin u witsir u ru'umin Judea a ba' u ber Zacarías caj u pʌchaj u c'aba' u parar. ");
INSERT INTO lacNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Caj yubob u mʌn u jumintej caj u tucrob tu yor: ―A ba' u ber u parar Zacarías? Quire' a C'ujo' cu bin yamta'bir Juan. ");
INSERT INTO lacNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","U tet Juan Zacarías jach yʌn ti' u Taj'or u Pixam C'uj, rajen caj ya'araj ti' C'uj: ");
INSERT INTO lacNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Jach caremech C'uj, quire' caj a cʌnantaj u winiquirob israel. Mʌ' ja wirej, caj a tacato'on baxuc caj a yamtaj ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A C'ujo' caj u ts'aj to'on ij cʌjtaquir a mac manan chichir u muc'. Ra' cu tar ti' ic nunquir David a caj u reyintaj u winiquirob israel uch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Baxuc caj u toc araj ti' a mac ts'a'b u tucur ten C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Baxuc caj u toc araj C'uj uch: “Je' in taquiquechex ti' a mac cu p'actiquechex a mac a mʌ' u winiquirob judío”, baxuc caj u ya'araj C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A C'ujo' caj ya'araj: “Je' in yajquintic ti' ic nunquir tan u yamtic ti'ob. Mʌ' ju bin tubur ti' a ba' caj u toc araj uch.” ");
INSERT INTO lacNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Baxuc caj toc ara'b ti' ic nunquir Abraham uch: ");
INSERT INTO lacNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Cu bin tacbir ti' a mac cu p'actico'on soc c'ucha'an ij cor ij c'ujintic C'uj soc mʌ' ic ch'ic sajaquir ti' mac.” ");
INSERT INTO lacNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Caj u chajex to'on ij cacsic tij cor soc ij cʌnic C'uj soc u bur u q'uinin ic manex tu tsoyir ʌcʌtan ti' hasta cu xur t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Caj ya'araj Zacarías ti' u parar: “A techo', in pararech, je' u t'ʌniquech yʌjtseq'uir u t'ʌn C'uj caj bin a pʌyic u ber ic Jaj Ts'urir soc yer a rac'ob u winiquirob judío je' u tar Jaj Ts'ure'. ");
INSERT INTO lacNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","A C'ujo' caj u tetaj to'on a techo', chan och, ca bin a wa'aric C'uj cu jawsic ic si'pir quir u taquic to'on. ");
INSERT INTO lacNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Quire' u jach tsoyir u pixam C'uj caj u yajquintaj to'on ca' bin tac tu q'uinin cu c'uchur. ");
INSERT INTO lacNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ij cʌjtaquir je' u sasichʌjir u pixam ten C'uj. A mac a cu man tu yac'birir yʌn u c'oxar u pixam ten C'uj quir u sasichʌjir u pixamob. Cu bin u rʌc ruc'sic a ba' quic sʌjtic ij quimin.” ");
INSERT INTO lacNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Caj ch'ijij Juan caj bin u cʌjtar ich tʌcay ru'um. Caj u qui' cʌnaj C'uj Juan. Hasta c'uchij tu q'uinin caj u yesaj u bʌj ti' u rac'ob u winiquirob israel yʌjpʌyiren u ber Jaj Ts'ur. ");
INSERT INTO lacNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ray u q'uinin Augusto caj u reyintaj u ru'umin u winiquirob romano caj ya'araj rey ti' u winiquirob: ―Ca' xiquechex a ts'ibtex a c'aba' quir in wiric mun u winiquirob yʌn tera'. Tu cotor mac yʌn u bin u ts'ibtic u c'aba'. Baxuc caj ya'araj César Augusto. ");
INSERT INTO lacNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","A je' beyaja' caj u ts'ibtajob u c'aba'. Ra' tu yʌn bat'an ts'ibtaj u c'aba' caj oc u gobernador u ru'umin Siria, Cirenio, u c'aba' gobernador. ");
INSERT INTO lacNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tu cotor ich u cajaririri'ej yʌn u ts'ibtic u c'aba' xan. Jujuntur cu bin u ts'ibtic u c'aba' ich u jach cajar. ");
INSERT INTO lacNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Caj bin José, caj ruq'uij ti' u cajar Nazaret caj bin ich u ru'umin Judea quir u c'uchur tu cajar Belén. Caj bin u ts'ibtej José u c'aba' ich Belén quire' ra' u cajar u nunquir David tu rocha'b ten u nʌ'. Rajen caj u jʌmʌch p'ʌtaj u cajar Nazaret quir u bin. ");
INSERT INTO lacNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Caj binob José yejer María ich Belén quir u ts'ibticob u c'aba'. José mʌ' toy u jach raq'uintej María chen tabar u rochic u parar. ");
INSERT INTO lacNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ti' yʌn José yejer María ich u cajar Belén caj c'uchij tu q'uinin u rochic u parar. ");
INSERT INTO lacNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","María caj u rochaj u chan och xib. Raji' tu yʌnx rochaj María. Caj u tapa María yejer u tep' caj u chaquintaj tu cu bin u jansej yʌrʌc' wacʌx quire' mʌ' tu cu mʌjʌnticob naj quir u wenʌnob quire' jach pimob caj u rʌc ts'ibtajob u c'aba'. ");
INSERT INTO lacNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bʌytʌc ich u cajar Belén ti' yʌn yʌjcʌnanyʌjirob yʌrʌc' tʌmʌn yuc. Cax ac'bir caj u cʌnantajob yʌrʌc' tʌmʌn yuc. Ti' yʌnob tu mʌna' u che'er chen suc yʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Seb caj tar ch'ictar yʌjmasir u t'ʌn C'uj tu yʌn yʌjcʌnanyʌjirob tʌmʌn yuc caj tar u sasir C'uj caj sasichʌjij tu yʌnob. Rajen jach jaq'ui yorob. ");
INSERT INTO lacNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Caj ya'araj yʌjmasir u t'ʌn C'uj: ―Mʌ' u jac'ʌrex a worex ten quire' caj taren in wa'aric techex a je' tsoy t'ʌna'. Caj taren in wa'aric tech soc u qui'tar yor tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Baje'rer rocha'b ten u nʌ' ich u cajar Belén. Ra' a wʌjtaquirex a caj u ya'ara yʌjtseq'uir u t'ʌn C'uj je' u tare'. Raji' Cristo Jaj Ts'ur a' tuchi'ta'b ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Soc a werex a ba' quin waquextech jaj. Je' a wiriquex charic tu cu jansic yʌrʌc' wacʌx ich u najir yʌrʌc' wacʌx. ");
INSERT INTO lacNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Seb caj tar u jer ya'ab yʌjmasirob u t'ʌn C'uj. Jach pim caj tarob. Ti' u tar ich ca'anan. Caj u yʌnxchun u c'ʌyicob C'uj yʌjmasirob u t'ʌn C'uj. Caj u c'ʌyob C'uj: ");
INSERT INTO lacNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Jach caremech C'uj a techo' a ti' yʌnech ich ca'anan. Jach qui' yor a mac a ti' yʌn ich yoc'ocab a tu qui' quiquintajob a wor C'uj. Mʌ' ja wirej, caj a yamtaj ti'ob. Baxuc caj c'ʌyajob yʌjmasirob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Caj wʌc'ʌs binob yʌjmasir u t'ʌn C'uj ich ca'anan. Caj ya'arob ti' u rac'ob yʌjcʌnanyʌjirob: ―Ca' xico'onex ich u cajar Belén ca' ij quirej a ba' caj u ya'araj to'on yʌjmasirob u t'ʌn C'uj. Ca' ij quirej ba' u ber ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ts'ajan yor binob caj u nup'ajob María yejer José ich u najir tu cu jansicob yʌrʌc' wacʌx. Ti' chara'an u chan ochir María tu cu jansic yʌrʌc' wacʌx. Caj ts'oc yiricob u chan ochir. ");
INSERT INTO lacNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yʌjcʌnanyʌjirob tʌmʌn yuc caj ara'b ti' José yejer María a ba' ara'b ti'ob ten yʌjmasir u t'ʌn C'uj. Caj ya'arob ba' cu bin u betic u chan ochir ich u rac'ob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Caj jac'ob yor tu cotor a caj u yuba ba' caj u ya'arajob yʌjcʌnanyʌjirob tʌmʌn yuc. Tu tsicbʌtob bic tabar u chan ochir María. ");
INSERT INTO lacNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María caj u qui' tucraj a ba' yuba ya'ara'r ten yʌjcʌnanyʌjirob tʌmʌn yuc. Rajra' cu tucric ti' tu yor María. ");
INSERT INTO lacNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Caj wʌc'ʌs sutnʌjob yʌjcʌnanyʌjirob tʌmʌn yuc quir u beyaj. Caj ya'arob ti' C'uj: ―Bayo' C'uj, jach caremech C'uj quire' tij quiraj tij quich quire' baxuc caj a wa'ara to'on. Toc taj caj a wa'araj to'on ―baxuc caj ya'arob yʌjcʌnanyʌjirob tʌmʌn yuc ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Caj man turiri' semana caj bin purbir Jesús quir u sesic u bʌq'uer chan xib an ten bic nanij u betic u winiquirob judío. Caj pach u c'aba' Jesús an ten bic caj ara'b ten yʌjmasir u t'ʌn C'uj ti' María. Ra' u q'uinin mʌ' toy yʌnʌc u parar uch. ");
INSERT INTO lacNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Caj ts'oc u nup'ur u q'uinin an ten bic caj u ts'ibtaj Moisés uch. Ra' u q'uinin caj bin María quir u yesic u bʌj ʌcʌtan C'uj ich carem naj an ten bic nanij cu betic u winiquirob judío, yet binac José. Rajen binob purbir Jesús ich u cajar Jerusalén quir u yesicob ti' C'uj ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío soc C'uj yʌnin ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Caj binob quir u nup'ur u t'ʌn a tu ts'ibtaj Moisés uch. Caj ya'araj: “A mac a yʌn bat'an rochic u parar xib yʌn u bin u ts'ic chan och ti' Jaj Ts'urir soc raji' yʌnin.” ");
INSERT INTO lacNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Caj binob José yejer María quir u ts'ic ti' C'uj a baxuc caj u toc araj Moisés uch, caj ya'araj: “Yʌn a ts'ic ca'tur susuy wa mʌna', yʌn a ts'ic ca'tur chan tuch. Raji' yʌn u quinsic sacerdote quir u toquic ti' C'uj.” Baxuc caj ya'araj Moisés uch. ");
INSERT INTO lacNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ra' u q'uinin caj bin María yejer José ti' cʌja'an ich u cajar Jerusalén, turiri' xib Simeón u c'aba'. Raji' jach tsoy yor, cu jach c'ujintic C'uj. Caj u qui' paj u q'uinin ber ca' bin tac a mac a cu bin tuchi'bir ten C'uj quir u qui'quinta' yor u winiquirob israel. Quire' u Taj'or u Pixam C'uj caj u pay ber Simeón. ");
INSERT INTO lacNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Rajen esa'b ten u Taj'or u Pixam C'uj ti' Simeón: “Mʌ' a quimin hasta ca wiric ta wich Cristo a mac Jaj Ts'ur, a mac tuchi'ta'b ten C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeón caj bin ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío, quire' pay u ber ten u Taj'or u Pixam C'uj. Ba'iri' c'uch José yejer María yejer u chan ochir María, Jesús u c'aba'. An ten bic nanij u yesicob u winiquirob judío ti' C'uj ich carem naj, rajen binob. ");
INSERT INTO lacNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón caj u nup'aj José yejer María, caj chuc u chan ochir María ten Simeón. Caj u t'ʌnaj C'uj Simeón: Bayo' C'uj, quij. ");
INSERT INTO lacNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Jaj Ts'urir, quij Simeón, baje'rer c'ucha'an in wor in quimin. ");
INSERT INTO lacNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Qui' in wor quire' caj in wiraj a mac a caj a toc araj cu bin tar. Caj in wiraj in wʌjtaquir an ten bic caj a wa'araj ti' ten a mac a cu beyaj tech. ");
INSERT INTO lacNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","A je' chan ocha' a quin rochic raji' caj a tetaj quir u taquic mac tu cotor. Tu cotor cu bin yiric. ");
INSERT INTO lacNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","A je' chan ocha', je' u sasiquintic ti' mac cax a mʌ' u winiquirob judío soc yerob bic tabar cu bin tacbir. U winiquirob judío cu bin sʌjta'bir ten tu cotor mac quire' ti' u tar ti'ob a mac cu bin u taquic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José yejer María u nʌ' Jesús caj jaq'uij yorob quire' yubarob ya'aric Simeón ti' chan ochir. ");
INSERT INTO lacNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón caj ya'araj: ―Ca' u yamtej techex C'uj. Caj ara'b ti' María ten Simeón: ―Ca bin a muc'yaj María irej wa rambirech yejer chan mascab quire' a ba' cu bin tar ti' a parar. Ya'ab u winiquirob israel cu bin satʌrob quire' mʌ' tu quibob a parar tech. Chen ya'ab cu bin u cuxtar munt q'uin quire' caj u quibob ti'. Ya'ab mac cu bin u nunquicob u t'ʌn ");
INSERT INTO lacNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","soc u joc'ar a ba' cu muc u tucricob tu yorob. Baxuc teta'b ten C'uj uch ―baxuc caj ara'b ten Simeón. ");
INSERT INTO lacNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ti' yʌn u jer xquic ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío, ra' u c'aba' Ana, raji' u c'aba' u tet, Fanuel. Ana, raji' u jach ʌj tseq'uir u t'ʌn C'uj. Raji' yo'nen Aser. Jach uch ch'ijic. Tan tu xur u baquer Ana caj raq'uinta'b ten u mam caj ts'oc u man siete yaxq'uin caj quim u mam. U beriri' mʌna' u mam, quim u mam. ");
INSERT INTO lacNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Baje'rer yʌn ochenta y cuatro yaxq'uin, mʌna' u mam. Rajra' ti' yʌn Ana ich carem naj. Rajra' caj u c'ujintaj C'uj caj u t'ʌnaj C'uj ti' u rac'ob. Su' su' caj u jamach p'ʌtaj u janʌn soc u qui' c'ujintic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana caj c'uchij ich carem naj ra' u q'uinin ti' yʌn Simeón tan u tsicbarob yejer José yejer María. Caj ts'oc yiric u chan ochir María caj u t'ʌnaj C'uj caj ya'araj: ―Bayo' C'uj quire' caj in wiraj chan ochir. Ana caj tsicbanʌj yejer u rac'ob bic tabar u chan ochir María. Caj ya'araj ti' a mac tan u pajicob u tar Cristo ich u cajar Jerusalén. Ana caj u tsicbʌtaj ti'ob ti' Cristo. Baxuc caj ara'b ten Ana. ");
INSERT INTO lacNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ra' ts'oc u nup'sicob a ba' ya'araj ich u t'ʌn Moisés. Caj wʌc'ʌs sutnʌjob José yejer María ich u cajar Nazaret quire' ra' u jach cajar. Ti' yʌn tu ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ti' yʌnob ich u cajar Nazaret caj ch'ijij u parar. Caj u jach chichtar u muc'. U ne'er ya'aric tu cotor ba'. C'uj caj u qui' cʌnantaj chan Jesús xan. ");
INSERT INTO lacNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","An bic nanij u bin José yejer María cu yocar yaxq'uin cu bin ich u cajar Jerusalén, cu c'uchur tu q'uinin u qui'qui' janʌnob u winiquirob judío. Ra' u q'uinin cu c'ʌ'oticob tu caj u potmastaj yʌjmasir u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Rajen caj c'uchij ti' doce u yaxq'uinin ti' Jesús yet binacob u nʌ' yejer José ich u cajar Jerusalén an ten bic nanij cu binob José yejer María quir u binob. ");
INSERT INTO lacNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Caj ts'oc u qui'qui' janʌnob caj sutnʌjob José yejer María. Tiri' toc p'at Jesús ich u cajar Jerusalén. Mʌ' yerob u nʌ' wa tar bin Jesús yejer u rac'ob pʌybej. Mʌ' yerob p'at tu junan ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Cu tucricob tan u tar ich a pimo' a yet binacob, tu masajob turiri' u q'uinin ich bej. Caj binob cʌxta'bir Jesús ich u rac'ob bayiri' ich u bʌjob. ");
INSERT INTO lacNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mʌ' yirob rajen wʌc'ʌs ca' sutnʌjob u cʌxtej ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Caj c'uchob ich Jerusalén caj u cʌxtajob, tres u q'uinin tan u cʌxta' Jesús. Tres u q'uinin caj ir Jesús. Ti' yʌn ich carem naj caj irir curucbar yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Caj yubaj u tsicbarob. Caj u c'ataj Jesús a ba' cu camsicob yʌjcamsʌyʌjirob. ");
INSERT INTO lacNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jac'a'an yorob yʌjcamsʌyʌjirob u t'ʌn Moisés quire' yubicob quet u nunquic Jesús a ba' cu c'ata' ti' quire' yer u nunca'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Caj irir ten José ti' yʌn Jesús ich u yʌjcamsʌyʌjirob u t'ʌn Moisés caj jaq'uij yorob u nʌ' yejer José. U nʌ' caj ya'araj: ―In pararech, biquinin caj a betaj to'on aro'? Mʌ' wa ja toc er je' in wac'tiquech yejer a tet? ");
INSERT INTO lacNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Caj ya'araj Jesús: ―Biquinin caj tarechex a cʌxtenex? A werex a teno' yʌn in bin in betej a caj u ya'araj ten in Tet C'uj, rajen te' yʌnena'. ");
INSERT INTO lacNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Robob mʌ' ju najticob ba' caj u ya'araj Jesús ti' u nʌ' yejer u tet. ");
INSERT INTO lacNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Quet caj wʌc'ʌs sutnʌjob ich u cajar Nazaret. Caj u quibaj u tʌn u nʌ' Jesús quet u quibic u t'ʌn José. María caj u caj tucraj ich yor a ba' caj u ya'araj Jesús ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A Jesúso' caj u jach ne qui' cʌnaj quire' tan u jach ne ch'ijir quire' yajquinta'b ten C'uj. Bayiri' u rac'ob yajquinta'b Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ra' u q'uinin ts'oc u mʌn quince u yaxq'uinin Tiberio César tan u reyinticob u ru'umin Roma. Ti' yʌn Poncio Pilato tan u ts'urinticob u ru'umin Judea. Bayiri' xan Herodes tan u ts'urinticob u ru'umin Galilea. Yits'in Herodes, Felipe, ra' u c'aba' tan u ts'urinticob u ru'umin Iturea yejer u ru'umin Traconite. Bayiri' xan Lisanias tan u ts'urinticob u ru'umin Abilinia. ");
INSERT INTO lacNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bayiri' xan a ray u q'uinino' ti' yʌn Anás yejer Caifás tan u ts'urinticob carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Quire' u jach ts'urirob sacerdote. A ray u q'uinino' caj ts'a'b ti' Juan ten C'uj quir u tsec'tic u t'ʌn C'uj. Raji' u parar Zacarías. Ti' cʌja'an Juan ich tʌcay ru'um caj tar u t'ʌn C'uj ti' ca' u tsec'tej. ");
INSERT INTO lacNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Rajen Juan a cu yacsic ja' tu jo'r mac bin u ts'ectej tu nʌts'a'an u ya'arir Jordán. Caj u man ya'araj ti' a pim ca' u c'axejob tu yorob soc u p'ʌticob u c'asir quir u yacsic ja' tu jo'r soc u jawʌrob u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A ba' caj u tsec'taj Juan raji' quir u nup'ur u t'ʌn C'uj a caj u ts'ibtaj Isaías uch. Caj ya'araj Isaías yʌjtseq'uir u t'ʌn C'uj bin Isaías uch: Quij cu'yic u t'ʌn, quij Isaías. Quij cu'yic u t'ʌn mac, c'am cu tsec'tic ich tʌcay ru'um. Aro' a cu tsec'tic quij cu'yic u ya'aric: Toc rʌc ruc'sex a c'asirex, irej a mac cu tajquintic u ber soc u tar rey. Tu c'oc'ob cu tajquintic. ");
INSERT INTO lacNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tu c'omc'om ca' u muquej soc u tajtar. Tu cotor u witsir a ca'anano' ca' u tajquintej, bayiri' u chan p'uc wits ca' u tajquintej. Tu roch u berir ca' u tajquintej xan. ");
INSERT INTO lacNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Abaywo' c'ucha'an yor yiric C'uj tan u p'ʌticob u man tu c'asir soc yer tu cotor mac bic tabar cu tocar ten C'uj. Baxuc caj ya'araj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Caj tarob a pimo' quir u yacsa'r ja' tu jo'rob ten Juan quire' caj u c'axob tu yorob. Caj ya'araj Juan ti' a pimo': ―A techexo' jach c'asechex irechex can. Mʌ' ja wirej, a cano' cu puts'ur yiric cu tar quinsbir. Rajen ca tar a taquiquex a bʌj a werex sajaquechex a binex erarex. Arex ten mac caj u ya'araj techex quir a puts'urex ti' u ts'iquir C'uj? Juan caj ya'araj ti'ob: ―A techexo' caj a wac'tex a bʌj quire' a werex yʌn a si'pirex. ");
INSERT INTO lacNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Toc p'ʌtex a c'asirex tu caj a manex soc a manex tu tsoyir soc chʌca'an yiricob a rac'ob caj a jach c'axex a worex. Mʌ' a chen bin a wa'ariquex ra' in nunquirob Abraham rajen cu bin taquiquenob soc mʌ' u ts'abʌr a muc'yajex ten C'uj. Biquinin C'ujo' c'ucha'an yor u ric'sic a je' tunicha' quir u wayʌr u parar a nunquirex Abraham. ");
INSERT INTO lacNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chen a techexo' wa mʌ'ja betiquex a ba' cu qui'quintic yor C'uj cu p'eri'quintic techex ti' pʌc'ar u che'er a mʌ' ju wichʌncʌr. Techex a werex, a mac a yʌn u pʌc'ar che' a mʌ' ju wichʌncʌr, cu rʌc ch'ʌquic quir u puric ich c'ac'. Baxuquex xan wa techex mʌ' ca wesiquex caj a jach c'axex ta wor cu bin ts'abʌr a muc'yajex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Caj c'ata'b ti' ten u winiquirob judío, a mac a caj u yubob u t'ʌn: ―Ba' tsoyir yʌn ic betic soc u taquico'onex C'uj? ");
INSERT INTO lacNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Caj u nunca Juan: ―A mac mʌna' u noc' yʌn a jʌsiquex ti' wa yʌn ca'tur techex. A mac yʌn yo'och ca' u jʌsej ti' a mac mʌna' yo'och. ");
INSERT INTO lacNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Caj tarob ich Juan a mac a cu c'ʌmicob u taq'uin gobernador tar u purej acsabir ja' tu jo'rob caj c'ata'b ti' Juan: ―Arej to'on ba' yʌn ic betic soc u taquico'on C'uj ij cʌjcamsʌyʌjirech. ");
INSERT INTO lacNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Caj ya'araj Juan: ―A mun cu c'ata'r u bo'orir ti a rac'ob ten gobernador. Mʌ' ja ne jach nacsiquex u bo'orir. Jach taj ca waquex ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Caj tarob jun yarob soldado ich Juan u c'atejob ti': ―Ba' yʌn ic betic soc u taquico'on C'uj, arej to'on. Caj u nunca Juan: ―Mʌ' a yʌn ts'ʌriquex u pach mac quir u sijiquex a taq'uinex. Mʌ' tsoy a pʌq'uiquex u pach mac quir u ts'ic a taq'uinex. Cax mun cu bo'otiquechex gobernador qui'quintex a worex ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A pimo' a tan u pajicob ca' tac Cristo a tuchi'ta'b ten C'uj, u c'at seb u tar Cristo. Cu tucricob a pimo' a Juano', raji' wa Cristo a caj u ya'araj C'uj cu bin tuchi'bir. Raji' caj man u tsotsoc arob wa Juan Cristo ich tu cotor u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Caj ya'araj Juan ti' u winiquirob judío a fariseojo' yejer u winiquirob judío a saduceojo': ―A teno' taj quin wacsic ja' tu jo'r mac a caj u p'ʌtajob a c'aso' quire' caj u c'axajob tu yorob. Ca' bin tac Cristo, quire' tabar u tar, raji' Cristo cu bin u ts'ic techex u Taj'or u Pixam C'uj soc u ruc'sic tu cotor a c'asirex. Ca' bin tac a Cristojo' jach no'j. A teno' ―quij Juan―, mʌ' no'jen. Mʌ' ja wirej, a teno' mʌ' pataren in pitic u c'anir u pech' xʌnʌb cax u c'urewen. ");
INSERT INTO lacNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Caj ya'araj Juan: ―A ca' bin tac Cristojo' je' u jʌsic techex, irechex ca ruc'siquex u sor u wich trigo. Chen a tsoyo' ra' cu p'atʌr. U wich trigo ca ric'siquex, chen u sorob ca rʌc puriquex u sor a toquiquex. A baywo' ca' bin xuruc t'ʌn ca' bin u much'quintico'onex ic Tet C'uj, a c'aso' ra' cu bin u puric ich c'ac' tu mʌ' u tupur c'ac'. Chen a tsoyo' cu bin acsa'bir ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A baywo' caj u chich araj ti' u rac'ob. U jer jach ya'ab tan u chich ara' ti' ten Juan tan u tsec'tic u jach tsoyir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A Juano' caj u q'ueyaj gobernador Herodes. Mʌ' ja wirej, caj u ch'a'aj u mu' Herodes. U rac' yits'in Felipe caj u ch'aj, Herodías u c'aba'. Yʌn u jer ba' c'asir caj u betaj, rajen caj u q'ueyaj Juan. ");
INSERT INTO lacNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jach manan c'as caj u ca' betaj Herodes quire' caj u chuca Juan caj u mʌcaj. ");
INSERT INTO lacNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mʌ' toy chucuc Juan caj tarob a pimo' quir yacsa'r ja' tu jo'rob ten Juan, bayiri' xan acsa'b ja' tu jo'r Jesús. Caj ts'oc yacsic ja' tu jo'r Jesús quire' caj u t'ʌnaj C'uj ca'anan. Caj bin u muyarir. ");
INSERT INTO lacNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Caj tar u Taj'or u Pixam C'uj oc yicnʌn Jesús. Caj yira yeman irej susuy caj emij. Caj yub u t'ʌn C'uj ich ca'anan. Caj ya'araj: ―A techo' a chen in pararech, in jach yaj. Atecho' ta qui'quintaj in wor ―baxuc caj ara'b ten C'uj ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús tabar u chucpʌjʌr treinta u yaxq'uinin caj u yʌnxchun u beyaj u camsic u t'ʌn C'uj. Raji' u parar José, baxuc u tucric u rac'ob. A Joséjo' ra' u c'aba' u tet Elí. ");
INSERT INTO lacNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A Elíjo' u c'aba' u tet Matat. A Matato' u c'aba' u tet Leví. A Levíjo' u c'aba' u tet Melqui. A Melquijo' u c'aba' u tet Jana. A Janajo' u c'aba' u tet José. ");
INSERT INTO lacNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","A Joséjo' u c'aba' u tet Matatías. A Matatíaso' u c'aba' u tet Amós. A Amóso' u c'aba' u tet Nahum. A Nahumo' u c'aba' u tet Esli. A Eslijo' u c'aba' u tet Nagai. ");
INSERT INTO lacNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","A Nagaijo' u c'aba' u tet Maat. A Maato' u c'aba' u tet Matatías. A Matatíaso' u c'aba' u tet Semei. A Semeijo' u c'aba' u tet José. A Joséjo' u c'aba' u tet Judá. ");
INSERT INTO lacNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","A Judájo' u c'aba' u tet Joana. A Joanajo' u c'aba' u tet Resa. A Resajo' u c'aba' u tet Zorobabel. A Zorobabelo' u c'aba' u tet Salatiel. A Salatielo' u c'aba' u tet Neri. ");
INSERT INTO lacNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","A Nerijo' u c'aba' u tet Melqui. A Melquijo' u c'aba' u tet Adi. A Adijo' u c'aba' u tet Cosam. A Cosamo' u c'aba' u tet Elmodam. A Elmodamoj u c'aba' u tet Er. ");
INSERT INTO lacNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","A Ero' u c'aba' u tet Josúe. A Josuéjo' u c'aba' u tet Eliezer. A Eliezero' u c'aba' u tet Jorim. A Jorimo' u c'aba' u tet Matat. ");
INSERT INTO lacNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","A Matato' u c'aba' u tet Leví. A Levíjo' u c'aba' u tet Simeón. A Simeóno' u c'aba' u tet Judá. A Judájo' u c'aba' u tet José. A Joséjo' u c'aba' u tet Jonán. A Jonáno' u c'aba' u tet Eliaquim. ");
INSERT INTO lacNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","A Eliaquimo' u c'aba' u tet Melea. Meleajo' u c'aba' u tet Mainán. A Maináno' u c'aba' u tet Matata. A Matatajo' u c'aba' u tet Natán. ");
INSERT INTO lacNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","A Natáno' u c'aba' u tet David. A Davido' u c'aba' u tet Isaí. A Isaíjo' u c'aba' u tet Obed. A Obedo' u c'aba' u tet Booz. A Boozo' u c'aba' u tet Salmón. A Salmóno' u c'aba' u tet Naasón. ");
INSERT INTO lacNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","A Naasóno' u c'aba' u tet Aminadab. A Aminadabo' u c'aba' u tet Aram. A Aramo' u c'aba' u tet Esrom. A Esromo' u c'aba' u tet Fares. A Fareso' u c'aba' u tet Judá. ");
INSERT INTO lacNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","A Judájo' u c'aba' u tet Jacob. A Jacobo' u c'aba' u tet Isaac. A Isaaco' u c'aba' u tet Abraham. A Abrahamo' u c'aba' u tet Taré. A Taréjo' u c'aba' u tet Nacor. ");
INSERT INTO lacNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","A Nacoro' u c'aba' u tet Serug. A Serugo' u c'aba' u tet Ragau. A Ragaujo' u c'aba' u tet Peleg. A Pelego' u c'aba' u Tet Heber. A Hebero' u c'aba' u tet Sala. ");
INSERT INTO lacNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","A Salajo' u c'aba' u tet Cainán. A Caináno' u c'aba' u tet Arfaxad. A Arfaxado' u c'aba' u tet Sem. A Semo' u c'aba' u tet Noé. A Noéjo' u c'aba' u tet Lamec. ");
INSERT INTO lacNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","A Lameco' u c'aba' u tet Matusalén. A Matusalén u c'aba' u tet Enoc. A Enoco' u c'aba' u tet Jared. A Jaredo' u c'aba' u tet Mahalaleel. A Mahalaleelo' u c'aba' u tet Cainán. ");
INSERT INTO lacNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","A Caináno' u c'aba' u tet Enós. A Enós u c'aba' u tet Set. A Seto' u c'aba' u tet Adán. A Adáno' beta'b ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Caj joq'uij Jesús ich u chi' ya'arir Jordán quir u bin ich Galilea, Jesús jach ts'urinta'b ten u Taj'or u Pixam C'uj. Caj pay u ber Jesús ten u Taj'or u Pixam C'uj quir u bin ich tʌcay ru'um. ");
INSERT INTO lacNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Quir u tumta'r yor ten quisin quir yirir wa cu yacsic u si'pir. Ti' taro', ti' yʌn ich tʌcay ru'um cuarenta u q'uinin. Caj u jamach p'ʌtaj u janʌn u burur q'uin, u burur ac'bir. Caj ts'oc u jamach p'ʌtic u janʌn, Jesús caj wichʌjij. ");
INSERT INTO lacNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Caj tar quisin caj ya'araj quisin ti' Jesús: ―Wa jach taj u pararech C'uj waysej a je' tunicha' ca' wayac a woch waj, quir a jantic. ");
INSERT INTO lacNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús caj u nuncaj: ―Baxuc tu ts'iba'an cu ya'aric: “Mʌ' chen a woch cu cuxquintiquech. A xibo' cu cuxtar wa cu ya'aric C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Caj ts'oc ya'aric aro' caj pay ten quisin caj bin purbir ich jo'r yajaw wits tu ca'anan. Caj tus rʌc esa'b ti' ten quisin tu cotor u ru'umin tu cu reyinticob rey. Tabar caj ts'oc yesa'r ti' ten quisin. ");
INSERT INTO lacNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A quisino' caj ya'araj: ―Tu cotor a ba' ca wirique' a cu nequi'quintic u yor mac quire' caj u ts'aj ten C'uj, tu cotor wa jin c'at in ts'ic, c'ucha'an in wor in ts'ic. Bayiri' xan, tu cotor u muc' a caj a wiraje'. ");
INSERT INTO lacNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wa ca xontar tub yʌnen ca' a c'ujinten je' in rʌc ts'ic tech tu cotor a ba' caj a wiraj sam, soc tech yʌnin. ");
INSERT INTO lacNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Caj u nuncaj Jesús: ―Joq'uen xen, Quisinech. Quire' u t'ʌn C'uj cu ya'aric: “C'ujintej a Jaj Ts'urir C'uj. Chen raji' ca beyaj ti'.” ");
INSERT INTO lacNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Caj pay Jesús ten quisin ich u cajar Jerusalén. Caj nac purbir Jesús tu jach ca'anan u jo'r carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj ara'b ti' ten quisin: ―Wa jach jaj u pararech C'uj, pur a bʌj ca' rubuquech ich ru'um. ");
INSERT INTO lacNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Baxuc cu ya'aric tu ts'iba'an u t'ʌn C'uj: Tu toc araj ti' yʌjmasirob u t'ʌn C'uj ca' u qui' cʌnatech. ");
INSERT INTO lacNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Baxuc cu ya'aric tu ts'iba'an u t'ʌn C'uj, tu cu ya'aric: “Je' a ric'siquex yejer a c'ʌbex, cax mʌ' u ya' ch'ʌtic tunich soc mʌ' u yajtar u yoc ten tunich.” Baxuc cu ya'aric u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Caj u nuncaj Jesús: ―Baxuc tu ts'iba'an cu ya'aric xan: “Mʌ' tsoy ic tumtic yor ic Jaj Ts'urir C'uj soc ij quirej wa taj a ba' caj u ya'araj.” ");
INSERT INTO lacNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Caj ts'oc u yʌn rʌc tumta'r yor Jesús ten quisin. Jamach p'at Jesús ten quisin je' u ca'tar tumta'bir yor Jesús u jer u q'uinin. ");
INSERT INTO lacNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús caj sutnʌj ich u ru'umin Galilea. Jach ts'urinta'b ten u Taj'or u Pixam C'uj Jesús. Caj rʌc man u jumintej ti' u rac'ob a ba' tsoyir caj u betaj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tu caj u camsaj Jesús ich u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío. U rac'ob caj ara'b ti' Jesús ich u rac'ob caj ya'araj: ―Jach tsoy Jesús quire' cu tsec'tic u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Caj urij Jesús ich u cajar Nazaret tub ch'ijij Jesús uch. An ten bic nanij u c'ujintic C'uj caj oquij ich u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío. Quire' ra' u q'uinin quir u jesicob u bʌj u winiquirob judío. Caj ric' u ch'ictar u xaquej u t'ʌn C'uj Jesús quir yubicob u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Caj ts'a'b ti' u ju'unin a ba' caj u ts'ibtaj Isaías uch. Caj ts'a'b ti' ten u ts'urir u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u choraj u ju'unin Jesús, mʌ' ja wirej, cats'a'an. Caj yiraj tu ts'iba'an ten Isaías a cu ya'aric, caj u xacaj Jesús: ");
INSERT INTO lacNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","A teno', quij Isaías, tu ts'urinten u Taj'or u Pixam C'uj. Rajen caj u teten C'uj quir in bin in tsec'tic u jach tsoyir u t'ʌn C'uj ich a mac jach otsire'. Caj u tuchi'ten quir in wa'aric ti' a mac ts'urinta'b ten u si'pirob, caj u toc siptaj C'uj ti' u si'pirob. Caj aren in yamtic a mac cu manob tu c'asir soc u manob tu tsoyir, irej a mac ch'op u wich cu bin sasichʌjʌr u wich. Caj taren in chichquintic yorob a mac tupsa'an yorob ten u yajirob. ");
INSERT INTO lacNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Caj taren in toc aric techex c'uchij tu q'uinin u tar ic Jaj Ts'urir quir u ta'quic tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesús caj ts'oc u xaquic caj u ca' cats'aj u ju'unin caj u ts'aj ti' u c'urew u jach ts'urir u chan najir. Caj cura Jesús. Tu cotor mac a ti' cura'anob tu cu naj c'ujinticob C'uj tan u qui' pʌta'rob Jesús quire' jac'a'an yorob. ");
INSERT INTO lacNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Caj u yʌnxchun u tsicbar Jesús, caj ya'araj: ―A caj in xacaj baje'rer toc nup'a'an a ba' ts'ibta'b. ");
INSERT INTO lacNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tu cotor a mac ti' yʌn tu cu naj c'ujinticob C'uj u winiquirob judío caj ya'arob: ―Jach tsoy Jesús. Jac'a'an yorob quire' yubob jach tsoy u t'ʌn Jesús. Caj u c'axajob u tucurob rajen caj ya'arob: ―A je'ra' u chen parar José. Caj u p'astob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús caj ya'araj ti' a mac a ti' yʌn ich u chan najir tu cu naj c'ujinticob C'uj: ―In wer techex ca' bin a wa'ariquenex: “Wa ja c'at a yamtic u jer mac, a wʌc'ʌs bʌjiri' ca' a bat'an yamtej quire' yajech.” Ra' u c'at ya'aric: “Biquinin a teche', Jesús, mʌ' a betaj carem beyaj ta cajar Nazaret tu chi'jech an ten bic caj a betaj carem beyaj ich u cajar Capernaum?” ");
INSERT INTO lacNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ti' toy cu tsicbar Jesús caj ya'araj: ―Jach taj quin waquex tech. Mʌ' ju yacsʌr yʌjtseq'uir u t'ʌn C'uj a cu tar ich cajarire'. ");
INSERT INTO lacNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Taj quin bin in c'asej techex, soc a c'ʌ'otiquex ba' u ber uch yʌjtseq'uir u t'ʌn C'uj, quire' caj u betaj carem beyaj ti' a mʌ' u winiquirob judíojo'. C'aj wa techex tu q'uinin yʌjtseq'uir u t'ʌn C'uj Elías uch. Mʌ' ju tar ya'arir caj mʌn tres yaxq'uin yejer u jer chumuc yaxq'uin. Mʌ' ju tar ya'arir, caj u rʌc wichʌjob quire' mʌ' ju ch'ijir u pʌc'ar. ");
INSERT INTO lacNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Chen a C'ujo' caj u tuchi'taj Elías tu ru'umin Sidón tu yʌn yatoch a xquic a quimen u mamo'. Sarepta u c'aba' u cajar. Caj bin jansbir Elías cax mʌ' u winiquir judío a xquico'. Biquinin mʌ' tu jansaj a ti' yʌn ich u winiquirob judío a xquic a quimen u mam quire' yʌn ya'ab? Quire' tuchi'ta'b Elías ich u jer cajar. ");
INSERT INTO lacNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","C'ajtechex wa Eliseo caj jawsa'b iq'uer u ca' ti' Naamán a cu tar tu ru'umin Siria. Biquinin mʌ' tu jawsaj u winiquirob judío cax yʌn ya'ab iq'uer u ca' ich u winiquirob judío? Quire' mʌ' ara'b ten C'uj u jawsej ich u winiquirob judío, rajen mʌ' ju jawsej. ");
INSERT INTO lacNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Caj yubob ya'aric Jesús a ti' rʌc much'a'anob tu cu naj c'ujinticob C'uj caj rʌc p'ujob. ");
INSERT INTO lacNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Caj rʌc ric'ob joc'sa'bir Jesús caj bin purbir tu jo'r wits tu ch'ica'anin wits. Bʌytʌc yatochob tu cʌja'an ich u j'or wits. U c'at u nech'inta'r Jesús quir u quinsicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Chen Jesús caj man chumuc tu rʌc much'a'anob, chan ber caj man Jesús chumuc caj bin. ");
INSERT INTO lacNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús caj u p'ʌtaj u cajar Nazaret caj bin ich u cajar Capernaum tu ru'umin Galilea. Caj c'uchij tu q'uinin u jesicob u bʌj u winiquirob judío caj oc u camsej Jesús tu cu naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Caj jac'ob u yorob barej caj u yubob a pimo' u camsa'rob ten Jesús, quire' raji' tsicbanʌjij an ten bic mac a yʌn u muc'. ");
INSERT INTO lacNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ti' yʌn turiri' xib tu cu naj c'ujinticob C'uj u winiquirob judío. Raji' yʌn u c'ac'as quisinin, a cu yawato'. Caj u yʌwtaj Jesús, caj ya'araj: ");
INSERT INTO lacNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Ay, ba' a c'at ti' a tenob, Jesúsech, a cu tar ich u cajar Nazaret? Tara'anech quir a ch'esiquenob? In werob maquech, a techo', a mac a cu tar ich C'uj, a mac a caj u ric'saj u wʌc'ʌs bʌjiri' ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús caj u q'ueyaj c'ac'as quisin: ―Nup' a chi', ca' joc'aquech, ca' a p'ʌtej a je' xiba'. Caj pich'inta'b xib ten c'ac'as quisin caj rub ich ru'um ʌcʌtan u rac'ob. Mʌ' yaj caj joc' u quisinin. ");
INSERT INTO lacNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Caj jac'ob yorob u rac'ob caj irir u joc'ar c'ac'as quisin. Caj tsicbanʌjob ich u rac'ob: ―Ba' t'ʌnin a je' xiba' a mʌ' cax c'ac'as quisin cu quibir u t'ʌn ten c'ac'as quisin? Inan cu joc'arob. ");
INSERT INTO lacNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A ba' irir u betic Jesús caj u rʌc man u jumintej ich tu cotor u rac'ob ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Caj joc' Jesús tu cu naj c'ujinticob C'uj u winiquirob judío, caj oc ich yatoch Simón. Yaj yixquit Simón, jach ar u jo'r. Caj c'ata'b ti' Jesús quir u jawsic. ");
INSERT INTO lacNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Caj oc Jesús tu chara'an yixquit Simón. Caj p'uxraj u t'ʌnej Jesús, caj u jawsa u yajir u jo'r. Caj jawij, seb caj riq'uij quir u jansa'r Jesús yejer a mac a ti' yʌnob tu yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A ray u q'uinino' tan u bin ic yum, caj tar purbir u yajir a mac cʌja'an tu cajar Capernaum cax a ba' yajir yʌn ti'ob Jesús caj u rʌc tʌraj caj rʌc jaw u yajir. ");
INSERT INTO lacNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bayiri' xan, yʌn mac aca'an ti' c'ac'as quisin. Caj joc'ob, caj q'ueya'b ten Jesús caj awʌtnʌjob caj joc'ob, caj ya'arajob: ―A techo', u pararech C'uj. Jesús caj u q'ueyaj ca' u nup'ob u chi' quire' a quisino' yer ti' u tar ich C'uj, rajij Cristo. ");
INSERT INTO lacNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Caj sasij caj joc' Jesús tar u wich u bin ich tacay ru'um. Chen a pimo' caj bin u cʌxtejob hasta caj u yirajob Jesús. Caj chich ara'b u p'atʌr Jesús ich u cajar Capernaum. ");
INSERT INTO lacNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús caj ya'araj ti'ob: ―Yʌn in bin in tsec'tej u jach tsoyir u t'ʌn C'uj tu cu bin u reyintejob C'uj, ich u jer u cajarob. Rajen caj u tuchi'ten C'uj quir in tsec'tic u jach tsoyir u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Rajen ti' rajra' cu man Jesús u tsec'tej tu cu naj c'ujinticob C'uj u winiquirob judío ich u ru'umin tu cʌja'anob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Caj c'uchij tu q'uinin u man u tsec'tej Jesús ich u chi' c'ac'nab u c'aba' Geneseret. Caj c'uchob jach pim, caj u rʌc nʌctantajob u bʌj ich Jesús quire' u c'at yubicob u jach tsoyir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús caj yiraj ti' yʌn chem ich chi' c'ac'nab, bʌytʌc u sa'amin u chi' c'ac'nab. Ca'tur caj yiraj chem. Chen u chem yʌn. Ti' yʌn u winiquirir u chem tan u p'o'icob u chim. ");
INSERT INTO lacNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús caj oc cutar ich chem, turiri', ra' u chemin Simón caj c'ata'b ti' ten Jesús: ―Joc'sej u chemin nʌnʌchir. Jesús caj curʌj u camsej a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Caj ts'oc u camsic Jesús a pimo' caj ara'b ti' Simón: ―Ch'aj a chem ca' xiquech ca' a purej a chim tub tam. Je' a chuquic ya'ab cʌy yejer a wet beyajob. ");
INSERT INTO lacNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Caj u nunca Simón: ―In wʌjcamsʌyʌjirech, u bur u ac'bir caj chich beyanʌjenob tan in puric in chimob. Mʌ' tin c'ʌs chuc u cʌyirob. Chen wa tech aric tenob, je' in wʌc'ʌs bin in purejob in chimob. ");
INSERT INTO lacNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Caj ts'oc u puricob u chimin caj u jach chucajob u cʌyir ya'ab. Caj u yʌnxchun u jatʌr u chimin quire' jach manan chup u cʌyir u chimin. ");
INSERT INTO lacNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","A mac ti' yʌnob ich chem yejer Simón caj u babach c'ʌ'tajob u yet chucob cʌyob, a ti' yʌn juntur chem quir u yamta'r u jitic u chimin. Caj tarob yamtabir Simón. Caj u jitob caj u but'ajob ich chemob caj chup u cʌyir ich chemob tabar u jurur u chemob. ");
INSERT INTO lacNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Caj yiraj Simón Pedro jach ya'ab caj u chucajob u cʌyir caj xonraj ʌcʌtan ich Jesús. Caj ya'araj: ―Chan xen Jaj Ts'urir p'ʌten quire' a teno' jach manen yʌn in si'pir. ");
INSERT INTO lacNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Caj u ya'araj aro' quire' jach jaq'uij yor Simón. Quet caj jaq'uij yorob xan a yejer yet chuc cʌyo' Simón. Quire' yirob jach chup u cʌyir caj u but'ob ich chem caj u chucajob. ");
INSERT INTO lacNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Baxuc xan u c'aba' Jacobo yejer Juan yet chucob cʌy Simón, a p'eri' u beyajob. Ra' u teto' Zebedeo, caj jac' yorob xan. Caj ya'araj Jesús ti' Simón: ―Mʌ' u jac'ʌr a wor an ten bic caj a chucaj cʌy. Quire' ra' a beyaj, ca' bin a camsej in t'ʌn ich a rac'ob soc u quibicob in t'ʌn. Ra' a beyaj baje'rer ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Caj u jitob u chem ich chi' c'ac'nab caj u rʌc p'ʌtob u beyajob u chuc cʌy caj rʌc binob tu pach Jesús quir u cʌnicob u t'ʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Caj c'uchi tu q'uinin ti' yʌn Jesús ich turiri' cajarob carem. Caj c'uchi turiri' xib yaj, u cʌnmʌn iq'uer u ca'. Caj xonraj ich Jesús caj u chich c'ataj ti' Jesús: ―In wer c'ucha'an a wor a jawsiquen Jaj Ts'urir wa ja c'at a jawsiquen ―quij, a iq'uer u ca' teno'. ");
INSERT INTO lacNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús caj u tich'aj u c'ʌb caj u tʌraj caj ya'araj: ―In c'at in wiric a jawʌr ―quij Jesús. Caj ya'araj aro' seb caj jawij iq'uer u ca' ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús caj u chich araj ti' a jawe': ―Mʌ' a bin a wa'aric tu ca man bic jawech. Chen tar a bin ich u sacerdote u winiquirob judío quir a sijic ti' a ba' ya'araj Moisés uch. Soc yerob tu cotor mac jawsa'bech ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Quire' a pimo' yubaj u juminta'r jach chich u muc' Jesús, jach manan caj u rʌc juminta'r ti' u rac'ob. Rajen rʌc tarob pim quir u much'quinticob u bʌj quir yubicob u tsec'ticob u t'ʌn C'uj Jesús, quir u jawsʌr u yajirir xan. ");
INSERT INTO lacNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús caj u jamach p'ʌtaj a pimo' quir u bin u t'ʌnej C'uj tu junan ich tʌcay ru'um. ");
INSERT INTO lacNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Caj c'uchij tu q'uinin, tan u camsic Jesús. Chen jun yarob u winiquirob judío a fariseojo' yejer yʌjcamsʌyʌjirob u t'ʌn Moisés curucbarob yubejob. A pimob ti' u tarob ich u ru'umin Galilea. Ti' u tarob u jerob ich u ru'umin Judea. Ti' u tarob u jerob ich u cajar Jerusalén. Jach ts'urinta'b Jesús ten u Taj'or u Pixam C'uj quir u jawsic u yajirir mac. ");
INSERT INTO lacNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jun yarob xib caj tarob purbir a mʌ' u ch'ictare'. Caj u c'ochob yejer u ch'ac. U c'at yacsa'r ich yatocho' tu yʌn Jesús ca' u chaquintob ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Chen mʌ' tu cu yacsicob quire' ti' yʌnob jach pim. Rajen caj nacob ich u pach yatoch quir u rʌcob u pach yatoch quir u yensa'r yejer u ch'ac, a mʌ' u ch'ictaro' ich Jesús. Caj u patajob u jo'r yatoch quire' taj u jo'r yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Caj u yiraj Jesús bic tabar cu yacsicob tu yor ti' Jesús caj ya'araj ti' a mʌ' u ch'ictare': ―Je' in toc jawsic a si'pire' baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","U winiquirob judío a fariseojo' yejer u yʌjcamsʌyʌjirob u t'ʌn Moisés caj u yʌnxchun u tucricob tu yor: “Mac winic a je'ra' cu tucric c'ucha'an yor u jawsic u si'pir mac? Tan u pach'ic C'uj Jesús, chen a C'ujo' c'ucha'an yor u jawsic u si'pir mac.” ");
INSERT INTO lacNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús yer ba' cu tucricob u winiquirob judío rajen caj ya'araj ti'ob: ―Biquinin tan a waquex tan in pach'ic C'uj? ");
INSERT INTO lacNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wa quin wa'aric ti' a je' xiba': “Je' in toc jawsic a si'pire'”, a techexo' mʌ' a werex wa yʌn ten u muc' C'uj, chen wa quin wa'aric ti': “Riq'uen ca' xiquech”, ca bin a werex yʌn ten u muc' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Baje'rer je' in toc esic techex in muq'ue' quir in jawsic u si'pir a je' xiba', quire' quin bin in jawsic u yajir a mac mʌ' u ch'ictare' soc a werex jach yʌn in muc' quir in jawsic u si'pir mac, quire' a teno' baxuquenechexo'. Jesús caj u t'ʌnaj a mac a mʌ' u riq'uire': ―Riq'uen ca' xiquech ta woc, toc ch'aj a ch'ac, xen ich a watoch. ");
INSERT INTO lacNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Seb caj riq'uij a mʌ' u ch'ictare' ʌcʌtan u rac'ob caj yirajob u ch'ic u ch'ac yejer u tas caj bin ich yatoch caj u ya'araj ti' C'uj: ―Bayo' C'uj, ta jawsajen. ");
INSERT INTO lacNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Caj jaq'uij yorob a ti' much'a'anob, caj u ch'aj sajaquirob caj u ya'arajob: ―Jach caremech C'uj quire' mʌ' biq'uin ij quiramʌni' u jawsic mac hasta baje'rer caj ij quiraj. ");
INSERT INTO lacNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Caj joc' Jesús tub u jawsaj a mʌ' u ch'ictar ca'ch. Caj u yiraj yʌjc'ʌmin u taq'uin gobernador, raji' u c'aba' Leví, curucbar tu cu c'ʌmic u taq'uin gobernador. Caj ara'b ti': ―Cojen tin pach ca' a cʌnej in camsiquech soc in camsʌwiniquech. ");
INSERT INTO lacNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví, caj riq'uij caj u rʌc p'ʌtaj u beyaj caj say tu pach Jesús quir u cʌnic u t'ʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leví, caj u much'quintaj u rac'ob quir u qui' janʌnob quir u sʌjticob Jesús. Caj rʌc tarob ich yatoch Leví, ti' yʌn u jerob yʌjc'ʌminob, u taq'uin gobernador jach pim. Bayiri' ti' yʌn u jerob u rac'ob xan. P'eri' curicob janʌnob. ");
INSERT INTO lacNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Caj yirob u winiquirob judío a fariseojo' yejer u yʌjcamsʌyʌjirob u t'ʌn Moisés a fariseojo'. Caj choquij yorob, caj u yʌnxchun ya'ara' ti' u camsʌwinicob Jesús: ―Biquinin p'eri' a janʌnex ca wuc'urex xan yejer a mac cu c'ʌmicob u taq'uin gobernador yejer a mac jach yʌn u si'pirob? ");
INSERT INTO lacNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús caj u nuncaj ti'ob: ―Baxuc a yer ts'aco' mʌ' u ts'ʌquic a mʌ' yaje', cu chen ts'acʌr a yʌn u yajire'. ");
INSERT INTO lacNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Baxuc a teno' taren in pʌyic a mac a yʌn u si'pirob ca' u c'axej tu yorob soc u p'ʌticob a c'aso'. Mʌ' taren in yamtic a mac cu ya'aric mʌna' u si'pir ―baxuc caj ya'araj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A mac ti' yʌn caj u c'atob ti' Jesús: ―Arej to'on biquinin mʌ' u jamach p'ʌticob u janʌnob a camsʌwiniquirob quire' rajra' tan u qui' janʌnob. Chen u camsʌwinicob Juan cu jamach p'ʌticob u janʌn, quir u t'ʌnicob C'uj ―baxuc u camsʌwinicob a fariseojo'. ");
INSERT INTO lacNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús caj u nuncaj: ―Mʌ' ba' u ber ca' u jamach p'ʌticob u janʌn a yet mano' cu bin u ch'ic u rac' quire' qui' yorob. ");
INSERT INTO lacNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Barej ca' bin ruc'sac a cu bin u ch'ic u rac' ten a mac a cu p'actic ti'. Raxben tsoy u jamach p'ʌticob u janʌn u camsʌwinicob quire' tan yac'ta'rob a mac ruc'sa'b. ");
INSERT INTO lacNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús caj u camsaj ti'ob tan ya'aric: ―Mʌ' tsoy ic xac'tic a ba' caj u camsajo'on ic nunquirex quire' jach uchben yejer a ba' ric'ben ca wu'yiquex. An ten bic mac mʌ' ju jʌtic ric'ben quir u pʌq'uic u rabir u noc'. Quire' a ric'beno' cu mosar. Chen wa cu pʌq'uic u rabir yejer a ric'beno', chen a rabo', raji' cu bin jatʌr. Sat a ric'beno' a caj u jʌtaj quir u pʌq'uic ich u rabir. Mʌ' ju bin quet tarob. ");
INSERT INTO lacNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Baxuc xan, mʌna' mac cu t'ajic u c'ab uva ric'ben ich u rabir yot'er yʌrʌc' chivo, quire' je' u paj u c'ab uva ich u rabir u yot'er chivo, je' u bujure', cu bin u satʌr u c'ab uva yejer yot'er xan. ");
INSERT INTO lacNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Rajen yʌn u t'ajic u c'ab uva a ric'beno' ich u yot'er chivo a ric'beno'. ");
INSERT INTO lacNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mʌ' ja wirej, a mac toc naj yuq'uic u c'ab uva a pʌje', qui' yubic. Mʌ' ju yuq'uic ric'ben u c'ab uva quire' toc na'sa'b yuq'uic pʌj u c'ab uva. Rajen, a techexo' mʌ' a c'at a p'ʌtiquex a ba' tu na'satechex a nunquirex. Baxuc mʌ' ja c'ʌmiquex a ric'beno' quin camsiquechex. ");
INSERT INTO lacNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Caj c'uchij tu q'uinin u jesicob u bʌj u winiquirob judío, ray u q'uinin caj bin Jesús yejer u camsʌwinicob caj u ch'ʌctajob u corir trigo. U camsʌwinicob Jesús caj u jo'stajob u wich trigo caj u jʌxʌc'ʌ'tajob ca' ruc'uc u sor ca' u jantejob. ");
INSERT INTO lacNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Caj irir tenob u winiquirob judío a fariseojo', jun yarob a fariseojo'. Caj ya'arajob: ―Biquinin a camsʌwinicob tech tan u jo'sticob u wich trigo u jantejob. Tu ts'iba'an u t'ʌn Moisés cu ya'aric mʌ' tsoy u beyaj u q'uinin tu cu jesicob u bʌj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús caj u nuncaj: ―Mʌ' wa ja xacmʌnex ba' caj u jantaj David uch, caj wichʌj quet yejer u nupob caj wichʌjob uch. ");
INSERT INTO lacNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Caj oc tu t'ina'an u noq'uir naj tu cu naj c'ujinticob C'uj u winiquirob judío uch. Caj u jantaj pan a ti' yʌnob ich yoc'or pojche' ti' ʌcʌtan C'uj. Caj u c'asquintaj u t'ʌn C'uj David, quire' raji' David yejer u nupob caj u jantajob. Quire' C'uj, caj ya'araj, chen a sacerdotejo' cu janticob. ");
INSERT INTO lacNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mʌ' ja wirej ―quij Jesús―, a teno' baxuquenechex, quin ts'urintic tu cotor ba', inan a ba' cu yiric mac tu q'uinin tu cu jesicob u bʌj u winiquirob judío ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Caj c'uchij u jer u q'uinin tu q'uinin tu cu jesicob u bʌj u winiquirob judío. Jesús caj oc tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u yʌnxchun u camsicob Jesús. Ti' yʌn xib a mʌ' u jitir u c'ʌb ich u noje'. ");
INSERT INTO lacNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ti' yʌn yʌjcamsʌyʌjirob u t'ʌn Moisés yejer u winiquirob judío a fariseojo'. Tan u qui' pʌcticob Jesús quir yiricob wa mʌna' u jawsic u yajir ray u q'uinin tu cu jesicob u bʌj u winiquirob judío, quire' u c'at u taquicob u jo'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús yer ba' cu tucricob u winiquirob judío a fariseojo' yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Caj ara'b ti' xib, a mʌ' u jitir u c'ʌb: ―Riq'uen ta ch'ictar ca' taquech chumuc tu yʌno'onex soc chʌca'an yiriquech tu cotor mac. Caj ric' tu ch'ictar. ");
INSERT INTO lacNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús caj ya'araj ti'ob: ―Yʌn ba' quir in c'atic techex. Tu q'uinin quic jesic ic bʌj. C'ucha'an yor mac u betic a ba' jach tsoy, wa c'ucha'an yor mac u betic a ba' c'as? C'ucha'an yor mac u yamtic mac u jer wa c'ucha'an yor u quinsic mac? ");
INSERT INTO lacNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús caj u rʌc pʌctaj yirej jujuntur, Jesús caj ya'araj ti' xib: ―Tich' a c'ʌb ca'anan. A xibo' caj u tich'aj u c'ʌb, seb caj toc qui' jawij. ");
INSERT INTO lacNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Chen raji'ob, caj yirob aro' caj jach p'ujob caj u p'erinquintajob u tucurob ba' cu bin u beticob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Caj c'uchij tu q'uinin Jesús caj bin u t'ʌnej C'uj ich jo'r wits. U burur ac'bir caj u t'ʌnaj C'uj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Caj sasij caj u much'quintajob u camsʌwinicob quir u tetic doce, raji' caj u pʌcha u camsʌwinicob: “A mac a quin tuchi'ticob quir u tsec'ticob in t'ʌn.” ");
INSERT INTO lacNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jera' u c'aba' a mac a cu bin tuchi'bir ten Jesús quir u tsec'ta'r u t'ʌn. Jeroj Simón caj pach u jer u c'aba' Pedro. U jer caj u tetaj Andrés, raji' u bʌjob Simón. U jer caj u tetaj Jacobo. U jer caj u tetaj Juan. U jer caj u tetaj Felipe. U jer caj u tetaj Bartolomé. ");
INSERT INTO lacNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","U jer caj u tetaj Mateo. U jer caj u tetaj Tomás. U jer caj u tetaj Jacobo, ra' u tet Alfeo. U jer caj u tetaj Simón, raji' tan u qui' c'ujintic C'uj, a tan u sayʌr u pach cananista. ");
INSERT INTO lacNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","U jer caj u tetaj Judas, ra' u tet Jacobo. U jer caj u tetaj Judas Iscariote, raji' cu bin c'ubic Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Caj ts'oc u tetic a docejo' caj wʌc'ʌs emij ti' u jo'r wits. Jesús caj ch'icrʌj tu tajir ru'um. Ti' yʌn jach pim u camsʌwinicob. Ti' yʌn u jerob pim a cu tar ich u ru'umin Judea, bayiri' ti' u tar ich u cajar Jerusalén. Ti' u tarob ich u cajar Tiro, ra' u chi' c'ac'nab. Ti' u tarob ich u cajar Sidón ra' u chi' c'ac'nab xan. Rʌc tarob yubicob u t'ʌn Jesús quire' u c'at u jawsa'r u yajirob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A mac aca'an c'ac'as quisin jawsa'bob xan ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tu cotor u c'at u tarʌr Jesús quire' ca' bin tarʌc cu jawar u yajirob quire' cu tar u muc' ti' Jesús quir u jawar u yajirob. ");
INSERT INTO lacNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Caj yiraj Jesús u camsʌwinicob caj ya'araj ti'ob: ―Qui'quint a worex quire' jach otsirchʌjechex baje'rer quire' a C'ujo' cu bin u qui' acsiquechex ich ca'anan tu cu reyinticob Cuj. ");
INSERT INTO lacNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Qui'quintej a worex quire' wichʌjechex baje'rer, je' a najchʌjʌrex ca' bin c'uchuc tu q'uinin. A mac tan u yac'ticob u bʌj baje'rer qui'quintej yorob quire' ca' bin c'uchuc tu q'uinin je' u qui'tar yorob, je' u che'ejobe', quire' C'uj cu bin u qui'quintic yorob. ");
INSERT INTO lacNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Qui'quintej a worex wa ber cu p'actiquechex mac wa tan u joc'siquechex tu cu naj c'ujinticob C'uj. Wa tan u p'astiquechex, wa tan u ya'aricob c'asechex quire' ta wacsajex ta wor ti' ten, a teno' a baxuquenechexo'. ");
INSERT INTO lacNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Qui'quintej a worex cax wa ber cu p'actiquechex, jach manan yʌn a qui'quintiquex a worex wa tan u p'astiquechex quire' tan a manex tu tsoyir. Rajen a C'ujo' cu bin u qui' acsiquechex ca'anan. Mʌ' ja wirej, quetechex yejer yʌjtseq'uirob u t'ʌn C'uj uch. Bayiri' caj p'acta'b ten u rac'ob uch. ");
INSERT INTO lacNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jesús caj ya'araj ti' a mac a mʌ' tan u manob tu tsoyir a mac neyʌn u taq'uin baje'rer: ―Yaj cu bin yubicob quire' toy qui'ij yorob tera' ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Mʌ' ja wirej, a mac jach bu'ut baje'rer jach yaj cu bin yubic u wichʌjʌr. A baje'rer cu tus che'eticob chen a ray u q'uinino' cu bin u jach ac'ticob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Qui' irej ber cu ya'aricob: “Jach tsoyech”, quire' baxuc caj ya'arob ti' u tus ʌjtseq'uirob u t'ʌn C'uj uch. Je' u yac'ticob u bʌj xan. ");
INSERT INTO lacNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Caj ya'araj Jesús ti' a pimo': ―U'yex ba' quin camsiquechex. Ca' a yajquintex a mac cu p'actiquechex. Yamtex a mac cu p'actiquechex. ");
INSERT INTO lacNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","T'ʌnex C'uj ti' a mac cu tʌmʌchi'tiquechex soc u qui'tar yorob. Chich t'ʌnex C'uj ti' a mac cu tupsic a worex soc u yamta' ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mʌ' a cʌniquex a mac a cu c'asquintiquechex. Wa cu tac' jʌts'ticob a p'uc, arex ti' ca' u tac' jʌts'tej jumbuj a p'uc xan. Cax wa mac cu ta'quic a jo'rex quir u ch'ic a noq'uex, soc mʌ' a cʌniquex aro', arej ti' ca' u toc ch'aj u ca'yarir a noq'uex. ");
INSERT INTO lacNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cax wa mac cu tar u chich c'atej techex. Cax wa sijibar ti', cax wa mʌjʌnbar ti', ts'ajex ti'. Wa mac cu tar u ch'ic a ba'tac, mʌ' a yʌn c'atiquex ti', ca' u sutextech. ");
INSERT INTO lacNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yamtex a rac'ob an ten bic a c'atex u yamtiquexob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’A mac a cu chen pacran yajquinticob u bʌj quire' u yajob u bʌj, chen u bʌjiri' cu tucric, mʌ' ti' C'uj cu tucric. Quire' baxuc a mac yʌn u si'pir cu yajquinticob u bʌj, quire' u yajob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A mac a cu chen yamtic u rac'ob quire' baxuc caj yamta'b uch xan. U bʌjiri' tan u tucric, mʌ' ti' C'uj, quire' cu tucric baxuc u yamticob u bʌj a mac yʌn u si'pir xan. ");
INSERT INTO lacNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A mac a cu mʌjʌntic u taq'uin ti' u rac'ob cu ts'ic ti'ob quire' yer je' u sutur ti' u jer, bayiri' xan u bʌjiri' tan u tucric. Mʌ' ti' C'uj quire' bayiri' a mac yʌn u si'pir, quet u mʌjʌnticob u taq'uin yer je' u sutur ti' xan. ");
INSERT INTO lacNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Caj ya'araj Jesús: ―A teno' tan in camsic techex. Yajquintex a mac cu p'actiquechex. Yamtex a mac cu p'actiquechex. Ts'ajex ti' ba', a ba' u c'atic techex, cax mʌ' a pajic u sutic techex. Baxuc ca' bin c'uchuquechex ich ca'anan. A C'uj cu bin u qui' bo'otic techex quire' ta cʌnajex C'uj, rajen u pararechex C'uj. Mʌ' ja wirej, a C'ujo' xan cu yamtic a mac jach c'as cax mʌ' cu ya'aricob ti' C'uj: “Bayo' C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cʌnex a Tet C'uj, mʌ' ja wirej, a C'ujo' cu yajquintic mac. Baxuc techex ca' a yajquintex a rac'obex. ");
INSERT INTO lacNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesús caj ya'araj ti' u camsʌwinicob ich u jo'r p'uc wits: ―Mʌ' a ta'quiquex u jo'r a rac'ob soc bayiri' mʌ' u ta'quic a jo'rex C'uj. An ten bic caj a chich ta'quex u jo'r a rac'ob. Bayiri' a C'ujo' u bin u chich ta'quic a jo'rex xan. A mac tu c'asquintajechex, jawsex u si'pir soc baxuc a rac'obex cu bin u jawsic a si'pirex. Baxuc a C'ujo' cu bin u jawsic a si'pirex xan. ");
INSERT INTO lacNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ts'ajex ti' a rac'obex a ba' u c'at, quire' baxuc C'uj cu bin u ts'ic techex xan. An ten mun u p'is caj a ts'aj ti' a rac'obex baxuc u p'is techex cu bin u ts'ajex C'uj. Jach manan ya'abir cu bin u ts'ic techex C'uj, mʌ' ju bin u c'uchur a worex ca' bin u rʌc ts'ajtechex. ");
INSERT INTO lacNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús caj u wʌc'ʌs araj yej u jer u t'ʌn quir u camsic: ―Irej a mac ch'op u wich, mʌ' u pʌyic u bej u jer ch'op u wich. Quire' wa yʌn u jor ru'um ti' cu bin u p'itc'ʌjob quire' mʌ' yirob u bej. Quire' baxuc techex a mac a mʌ' yer C'uj, mʌ' tsoy quir u camsic u t'ʌn C'uj. Quire' tan u pʌyicob a bej quir a bin ich u c'aq'uir. ");
INSERT INTO lacNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A mac cu camsiquechex baxuc ca bin a cʌnex, irechex a mac caj u camsajechex ca' bin ts'ocac u camsiquechex. ");
INSERT INTO lacNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Wa tech, caj a p'astaj a rac'ob quire' mʌ' tan u man tu tsoyir, chen a bʌjiri' xan, mʌ' tan a man tu tsoyir, chen ta man ta c'asir. Irech a mac a cu p'astic u rac'ob quire' bina'an robir chichin tu wich. Chen a bʌjiri' mʌ' a wiric wa bina'an robir ta wich cax carem. ");
INSERT INTO lacNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wa ca tsicbar ti' mac quire' caj man tu c'asir, chen a bʌjiri' jach manan yʌn a c'asir tech. Irech wa mac a cu ya'aric: “Arej in joc'sej a chichin bina'an robir ta wich quire' in bʌjobech.” Chen u bʌjiri' jach ya'ab bina'an robir tu wich. Mʌ' a yʌn cʌniquex u winiquirob judío a fariseojo' yejer u yʌjcamsʌyʌjirob u t'ʌn Moisés quire' irob ch'op u wich. Mʌ' ja wirej, yʌjtusarirech. Chen a bʌjiri' mʌ' a yʌn joc'sic robir a wich. A techo' yʌjtusarirech. Yʌn a toc p'ʌtic a man tu c'asir soc c'ucha'an a wor a wiric ca' u p'ʌt u man tu c'asir a rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Caj ya'araj Jesús tu cu camsic a pimo': ―Wa tsoy u che'er bayiri' tsoy u wich. Wa c'as u che'er, bayiri' c'as u wich xan. Rajen wa c'as u che'er mʌ' c'ucha'an yor u ts'ic u wich a tsoyo'. Bayiri' xan wa tsoy u che'er mʌ' c'ucha'an, yor u ts'ic u wich a c'aso'. ");
INSERT INTO lacNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wa ca wiric u wich ca c'ʌ'otic u che'er xan. An ten bic mʌ' a t'aquic u wich ʌrʌxa' ich abʌr, bayiri' xan, an ten bic mʌ' a t'aquic u wich pujam ich poch'ir. ");
INSERT INTO lacNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","An ten bic a mac tsoy u tucur, tsoy cu bin joc'ar u t'ʌn tu chi'. A mac c'as u tucur c'as, cu bin joc'ar u t'ʌn tu chi'. Mʌ' ja wirej, a ba' yʌn tu tucur ra' cu bin joc'ar tu cu tsicbar. ");
INSERT INTO lacNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Caj ya'araj Jesús: ―Biquinin ca chen t'ʌniquen, “Jaj Ts'urir”, barej mʌ' ca quibic in t'ʌn? ");
INSERT INTO lacNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tu cotor a mac cu yubic in camsic ca' u quibej a ba' tin wa'araj. ");
INSERT INTO lacNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Raji' irej a mac t'aj. Quire' ber caj u c'ʌxaj yatoch, tam caj u pʌc'aj yoc yatoch soc mʌ' u riquir. Ca' bin tac u ch'icyum ic' ca' bin buruc, mʌ' u riquir quire' jach tam caj u pʌc'aj yoc yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Chen a mac cu yubic in camsic, chen mʌ' ju quibej a ba' caj in wa'araj ti', raji' irej a mac chich u jo'r. Quire' caj u c'ʌxaj yatoch turiri', chen mʌ' tam caj u pʌc'aj yoc yatoch. Rajen caj riquij caj tar u ch'icyum ic' caj tar ya'arir, caj bu'urij. Quire' mʌ' tam caj u pʌc'aj yoc yatochi'. Caj rʌc sat yatoch, caj rʌc cuch ten ic' yejer ja'. ");
INSERT INTO lacNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús caj ts'oc u camsic a pimo' a je' t'ʌna', caj bin ich u cajar Capernaum. ");
INSERT INTO lacNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ti' yʌn ich u cajar Capernaum u capitán u soldado u winiquirob romano. Raji' yʌn u c'urew, u yaj u c'urew, tabar u quimin u c'urew. ");
INSERT INTO lacNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Caj yubaj ya'ara' capitán, ti' yʌn Jesús. Caj tuchi'ta'b jun yarob u jach ts'urirob u winiquirob judío, a nuxibe', caj chich pa'ay Jesús ca' tac jawsa'bir u c'urew capitán. ");
INSERT INTO lacNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Caj u juts'ob u bʌj ich Jesús caj u yʌnxchun u chich pʌyicob Jesús, caj ya'arob ti' Jesús: ―Cojen ca' a jawsej u c'urew capitán quire' jach tsoy a je' capitáno'. Raji' tsoy ca' a yamtej ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Quire' a capitáno' cu yajquintic u winiquirob judío. Mʌ' ja wirej, u bʌjiri' caj u bo'otaj yʌjc'ʌxirob naj tu quij c'ujintic C'uj ―baxuc caj ara'b yʌjpʌyirob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús caj bin yejerob. Bʌytʌc u c'uchurob Jesús ich yatoch capitán caj tuchi'ta'b t'ʌnbir Jesús u rac'ob capitán. Caj ya'arob: ―Tsire'ej, cax mʌ' a wocar tin watoch ti tar a xuro' ich tancab. A teno' mʌ' pataren quir in wacsiquech. ");
INSERT INTO lacNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Rajen mʌ' joq'uen in t'ʌnech quire' in wer mʌ' tsoyen. Chen arej ti' ca' jawac in c'urew. ");
INSERT INTO lacNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mʌ' ja wirej, quin chen quibic u t'ʌn in jach ts'urob. Bayiri' a teno' xan, quin ts'urintic soldado u winiquirob romano. Rajen wa quin wa'aric ti' mac ca' xic, cu bin. Quin wac ti' u jer, ca' tac, cu tar. Wa quin wac ti' in c'urew u betej, cu betic. Rajen in wer wa ca waric u jawʌr in c'urew cu jawʌr ―baxuc caj ara'b ti' Jesús ten capitán. ");
INSERT INTO lacNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Caj yuba Jesús aro' caj jaq'uij yor caj yuba bic tabar caj u yacsaj tu yor capitán. Rajen Jesús caj u sut u bʌj tu pach soc u t'ʌnic a mac a cu tarob tu pach. Jesús caj ya'araj ti'ob: ―A teno' quin wac techex, mʌ' biq'uin in wiramʌn yacsic tu yor cax ich u winiquirob judío, an ten bic a je' xiba' caj u yacsaj tu yor ―baxuc caj ara'b ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Caj wʌc'ʌs urob ich yatoch a tuchi'ta'bob ten capitán caj yirob jawij u c'urew capitán. ");
INSERT INTO lacNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Caj ts'oc u jawsa'r u c'urew capitán caj bin Jesús ich u chan cajar Naín. Ra' u c'aba' Naín. Yet binacob u camsʌwinicob yejer a pimob. ");
INSERT INTO lacNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tabar u c'uchur Jesús ich u cajar Naín, tu jo'rir u pa'te'ir tunich, tan u joc'sa'rob u baquer quir u mucur. Raji' u parar a xquico', a quimen u mamo'. Turiri' u parar. Yet taracob a pim u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús caj yiraj a xquico', a quimen u mamo', caj yajquinta'b ten Jesús. Caj ara'b ti': ―Mʌ' a wac'tic a parar xib ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús caj u juts' u bʌj tʌrbir tu but'a'an u baquer tu c'ocha'an ten u rac'ob. Caj xurob yʌjc'ochirob u baquer. Jesús caj ya'araj ti' a quimen a chichano': ―Riq'uen, quen. ");
INSERT INTO lacNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A quimen ca'che' caj riq'uij cutar, caj u yʌnxchun u tsicbar yejer u rac'ob. Caj ts'a'b ti' u nʌ' ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Caj yirob aro' caj u jach ch'ajob sajaquirob, caj u yʌnxchun ya'aricob ti' C'uj: ―Jach caremech C'uj. Caj a tuchi'taj u jer yʌjtseq'uir u t'ʌn C'uj a mac jach carem. Caj tar C'uj quir u yamtic u winiquirob israel ―baxuc caj ya'arob. ");
INSERT INTO lacNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Caj u jumintajob ich u rac'ob bic tabar caj u ric'saj Jesús u chan parar xib a xquico', a quimen u mamo'. Caj u rʌc jumintajob ich tu cotor u cajarob u ru'umin Judea. Baxuc tantanxer caj u rʌc jumintajob. ");
INSERT INTO lacNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","U camsʌwinicob Juan caj u yubob u juminta' u carem beyajob Jesús. Caj binob arbir ti' Juan. ");
INSERT INTO lacNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","A Juano' caj u pʌyaj ca'tur u camsʌwinicob ca' u tuchi'tejob ich Jesús quir u c'ata'r ti' Jesús: ―Wa jach taj raji' Cristo a cu bin tar ich C'uj? Wa yʌn ic pajic u jer? ");
INSERT INTO lacNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Caj c'uchob u camsʌwinicob Juan ich Jesús. Caj ya'arob ti' Jesús: ―Tu tuchi'tenob Juan ra' cu yacsic ja' tu jo'r mac quir in c'atob tech. Wa jach Cristojech a cu tar ich C'uj wa ca' in pajob u jer? ―baxuc caj ya'arob. ");
INSERT INTO lacNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Caj c'uchob ich Jesús caj u jawsaj a mac yʌn u yajirir cax a bar yajir yʌnob ti'. A mac yʌn u c'ac'as quisinin caj u joc'saj. A mac ch'op u wich caj u jawsa caj sasichʌj u wich. ");
INSERT INTO lacNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesús caj ts'oc yubic biquinin tarob u camsʌwinicob Juan, caj u nuncaj ti'ob: ―Xen arex ti' Juan bic tabar ta wirex in jawsic a ch'opo' caj sasichʌj u wich, a mech yoc caj jawij caj ximbajnʌj. Bayiri' caj jaw ti' a iq'uir u ca'o'. Bayiri' a macar u xiquin caj jawi caj sasichʌj u xiquin. Bayiri' a mac quimen caj ric'. Bayiri' caj a wu'yex in tsec'tic ti' u t'ʌn C'uj a jach otsirob. ");
INSERT INTO lacNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ca' bin xiquechex ich Juan: Arex ti' jach qui' yor a mac a yacsic tu yor wa tu tuchi'tajen C'uj ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Caj binob u camsʌwinic Juan. Caj wʌc'ʌs bin Jesús quir u tsicbar ti' a pimo'. Caj u tsicbʌtaj bic tabar Juan. Caj u c'ataj ti'ob a pimo' Jesús: ―Mac binechex a wirex ich tʌcay ru'um uch? Mʌ' wa ta wirex Juan a seb cu quibic ba'? Mʌ' binechex a wirex mac a seb cu quibic ba'. ");
INSERT INTO lacNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mʌ' binechex a wirex turiri' xib a ju buquimʌn noc' irej wa neyʌn u taq'uin a cu buquintic u noc'. Mʌ' ja wirej, a mac cu nebuquintic u jach tsoyir u noc' ti' cʌja'anob ich u palacio rey. Robob cu qui' janʌnob xan. Mʌ' a bin a wirex irej wa Juan ich tʌcay ru'um. ");
INSERT INTO lacNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Binechex a wirex yʌjtseq'uir u t'ʌn. Rajen binechex soc a wirejex yʌjtseq'uir u t'ʌn C'uj. Caj binechex a wirex Juan mʌ' chen yʌjtseq'uir u t'ʌn C'uj, quire' raji' caj u payaj in ber. Raji' irej Elías. ");
INSERT INTO lacNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Raji' Juan a tsec'ta'b ich u t'ʌn C'uj tu ts'iba'an tu cu ya'aric: Yʌn in tuchi'tic, quij C'uj, a mac cu ya'aric in tar, raji' yʌjtseq'uir in t'ʌn cu bin u pʌyic in ber tu cu tsec'tic u t'ʌn C'uj. Baxuc C'uj caj ya'araj ti' u yʌjtseq'uir u t'ʌn C'uj uch, caj u ts'ibtaj uch. ");
INSERT INTO lacNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tu cotor a mac ti' yʌn ich yoc'ocab mʌna' mac jach carem chen jari' Juan jach carem. Raji' cu yacsic ja' tu jo'r mac. Chen a mac a cu cha'ic C'uj u ts'urintic, cax mʌ' no'j tera', ca' bin u c'uchuc tu q'uinin je' u bin u qui' najtej u t'ʌn C'uj. Jach manan cu bin u najtej u t'ʌn C'uj. A Juano' c'ʌs ti' ti' cu najtic. ");
INSERT INTO lacNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chʌc yʌn yʌjc'amirob u taq'uin gobernador yejer u jerob u rac'ob, a yacsa'b ja' tu jo'rob ten Juan, caj u c'ʌ'otajob jach c'asob ʌcʌtan tu wich C'uj. Caj yubob u t'ʌn Jesús caj u ya'araj: ―Jach carem C'uj. Quire' acsa'b ja' tu jo'rob ten Juan. ");
INSERT INTO lacNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Chen u winiquirob judío a fariseojo' yejer yʌjcamsʌyʌjirob u t'ʌn Moisés, raji'ob mʌ' acsa'b ja' tu jo'r ten Juan quire' caj u p'astob C'uj a ba' u c'at C'uj ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","A Jaj Ts'ur caj u ya'araj ti'ob: ―Bic tabar quin quetquintic quir in camsic a mac cuxa'an baje'rer? Bic tabar quin wa'aric ti'ob quire' chich u jo'rob? ");
INSERT INTO lacNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jesús caj ya'araj ti'ob: ―Bin in quetquintic techex irex a chichan cu yac'ticob cu jenjen t'ʌnticob u yet chichinin cu tus aricob quire' mʌna' ba' cu qui'quinticob yorob: “Ca' ic tus aric ic ch'ic ic rac'. Chen mʌ' a tus ʌrʌc'ʌncʌr Cojen ca' ʌrʌc'nʌco'on. Ca' ic tus arej ic muc u baquer mac. Cheno' mʌ' a tus ʌrʌc'ʌncʌr”, baxuc cu ya'aricob a chicano' tu cu mʌnicob yoch u tet. ");
INSERT INTO lacNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mʌ' ja wirej, caj tar Juan ra' cu yacsic ja' tu jo'r mac, mʌ' nanij u nequi' janʌn, mʌ' ju yuq'uic u c'ab uva. Chen techex ca wa'ariquex ti' Juan yʌn u c'ac'as quisinin. ");
INSERT INTO lacNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Caj taren a teno' ―quij Jesús―, a baxuquenechexo'. Mʌ' wirej, a teno' ca wa'ariquex rajra' quin nejanʌn bayiri' ca wa'ariquex quin ne uc'ur. Bayiri' ca waquex jach coch in nʌc' ca waquex quin jach carchʌjʌr. Ca waquex in wet man yʌjc'ʌminob u taq'uin gobernador. Bayiri' ca waquex in wet man a neyʌn u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A mac caj u yacsaj tu yor ti' C'uj. Cu ts'abʌr u t'ʌnin ten C'uj soc u jach er u camsa'r. Rajen ij quer taj yor C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Turiri' u winiquir judío a fariseojo' caj pa'ay Jesús quir u janʌn. Jesús caj bin tu yatoch. Caj curaj janʌn ich u poche'ir yo'och. ");
INSERT INTO lacNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Caj u yubaj xquic ti' cu bin Jesús ich yatoch u winiquir judío a fariseojo' quir u janʌn. A xquico' raji' yʌn u si'pir. Caj tar purbir u cuchir ti' t'aja'an a qui' u boque'. U c'aba' u cuchir alabastro. Tunich u cuchir tu t'aja'an a qui' u boque'. ");
INSERT INTO lacNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Caj u juts'a u bʌj a xquico' ich yoc Jesús. Caj u yʌnxchun u yac'tic u bʌj a xquico' caj p'ob yoc Jesús yejer u wʌc'ʌs arir u wich tu cu yoc'ar. Caj u tisa yoc Jesús yejer u wʌc'ʌs tsotser u jo'r xquic. Tan u ts'u'ts'ar yoc Jesús ten xquic. Caj u jic'taj ich yoc Jesús a qui' u boque'. ");
INSERT INTO lacNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","A winiquir judío a fariseojo' a mac caj u pʌyaj Jesús caj yiraj a ba' caj u betaj xquic. Tu yor caj u tucraj a fariseojo': “Wa Jesús u jach ʌjtseq'uir u t'ʌn C'uj yer Jesús yʌn u si'pir a xquico'.” ");
INSERT INTO lacNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús caj ya'araj ti' u winiquir judío a fariseojo', u c'aba' Simón: ―Yʌn ba' quin wac tech. Caj u nunca Simón: ―Arej ten ba' ca bin a wa'arej in wʌjcamsʌyʌjirech. ");
INSERT INTO lacNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús caj ya'araj ti' Simón: ―A ca'tur xibe' yʌn u bo'or quire' caj u mʌjʌntajob taq'uin ti' a mac cu mʌjʌntic taq'uin. Turi' caj u p'axaj cincuenta denarios, ra' u c'aba' u sʌc taq'uin. U rac'ob caj u p'axaj quinientos sʌc taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","A je' ca'tur xiba' mʌ' c'ucha'an yorob u bo'oticob u bo'orob. A tu mʌjʌntajob uch caj u ya'araj ti'ob: “Tsire'ej, cax mʌ' a bo'otiquex.” Caj ya'araj Jesús: ―Arej ten mac jach manan cu bin yajquintej a ra' xibo'. A jach ya'ab u bo'or wa ja mʌ' neya'ab u bo'or cu bin u jach yajquintej? ");
INSERT INTO lacNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Caj u nuncaj Simón: ―Jaj ixtʌcoj, a mac jach ya'ab u bo'or, raji' cu jach bin yajquinbir. Jesús caj ya'araj: ―Taj a ba' caj a wa'araj. ");
INSERT INTO lacNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Caj u sut u bʌj quir u pʌctic xquic Jesús. Caj u ya'araj ti' Simón: ―Ca wiric, a je' xquica' a ba' caj u betaj ten. Tech, caj a wacsajen ta watoch, mʌ' ta ts'ajten ja' quir in p'o'ic in woc. Chen a je' xquica' caj u p'oj in woc yejer u ya'arir u wich. Caj u tisaj yejer u tsotser u jo'r. ");
INSERT INTO lacNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A techo', mʌ' ta wuts'benteno', cax ra' nanij u betic u winiquirob judío a cu yacsic tu yatoch. Chen a je' xquica' rajra' cu yuts'bentic in woc. Mʌ' ja wirej, cu qui' sʌjtiquen. ");
INSERT INTO lacNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A techo', mʌ' ta jic'taj tsats tin jo'ri' an ten bic nanij u betic u winiquirob judío a cu yacsic tu yatoch. Chen a je' xquica' caj u jic'taj a qui' u boque' ich in woc. ");
INSERT INTO lacNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Rajen quin wa'aric tech cax ya'ab u si'pir caj in toc rʌc jawsaj rajen ya'ab cu yajquintiquen. A mac a mʌ' neya'ab u si'pir cax jawsa'b u si'pir, mʌ' u qui' yajquinten. ");
INSERT INTO lacNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Caj ya'araj ti' xquic: ―A techo' rʌc jawsa'b a si'pir. ");
INSERT INTO lacNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ti' rʌc cura'anob janʌnob caj yʌnxchun ya'aricob ich u rac'ob: ―Ba' winquirir a je'ra' c'ucha'an yor u jawsic u si'pir mac? ");
INSERT INTO lacNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Caj ya'araj ti' xquic Jesús: ―C'uj bin u tacajech quire' caj a wacsaj ta wor. Ca' xiquech ta watoch qui'quintej a wor ―baxuc caj ya'araj Jesús ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Caj ts'oc u beyaj ti taro' Jesús caj bin ich tu cotor u cajarob, cax ich u chan cajarob, cax ich u yajaw cajarob xan. Ti' caj u tsec'taj u jach tsoyir u t'ʌn C'uj tu cu bin u reyinticob C'uj. U yet binacob u doce u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Baxuc xquic yet manob uch a mac joc'sa'b u c'ac'as quisinin yejer a mac jawsa'b u yajirir. Baxuc ti' yʌn María Magdalena, raji' joc'sa'b siete u quisinin. ");
INSERT INTO lacNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Baxuc Juana ra' u mam Chuza, ra' cu beyaj ich Herodes. Tan u cʌnantic u ba'tac Herodes. Baxuc Susana, baxuc ti' rʌc yʌnob u jerob. Caj u yamtob Jesús yejer u camsʌwinicob cax yejer u taq'uinob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Caj rʌc joc'ob ich u cajarob quir yiricob Jesús. Caj u rʌc much'quintajob u bʌj ich Jesús quir u camsa' ten Jesús. Caj u ya'araj tu cu camsa' bic tabar u t'ʌn C'uj: ");
INSERT INTO lacNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Caj binij mac quir u pʌq'uic tu cor trigo, cu q'uich'intic u yijir. Caj u pʌc'aj u cor trigo, jumbuj yijir caj rub ich tanbej. Caj tar mac caj u yajch'ʌctaj. Caj tar u ruq'uic ch'ich' xan. ");
INSERT INTO lacNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jumbuj caj u q'uich'intaj yijir caj rub ich tunich. Caj ch'ijij, caj quimij quire' mʌ' ch'ur u ru'umin. ");
INSERT INTO lacNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jumbuj caj u q'uich'intaj yijir caj rubij ich q'ui'ix, quet caj ch'ijij, caj bobasta'b rajen mʌ' ju ch'ijir. ");
INSERT INTO lacNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jumbuj caj u q'uich'intaj yijir caj rub tub u nec'at u ru'umin caj ch'ijir caj u nets'aja u wich hasta tu ni'. Caj ts'oc ya'aric Jesús c'am caj ya'araj: ―Wa c'ucha'an a worex a wu'yiquex t'ʌn, u'yex a ba' caj in camsaquechex ti' u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","U camsʌwinicob caj u c'atajob ba' caj u camsaj sam. ");
INSERT INTO lacNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Caj ya'araj ti' u camsʌwinicob Jesús: ―Tsaja'antechex ten C'uj quir a najtiquex a ba' mʌ' yerob uch tu cu bin u reytinticob C'uj. Chen a mac mʌ' yerob C'uj a cu yubicob in camsicob tu quin p'eri'quintic in t'ʌn. Cu chen u'yicob, cax cu yubicob mʌ' ju najtejob. Mʌ' ju bin u c'ʌ'oticob soc u yacsicob tu yor soc u tocar ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’U'yex ba' u c'at ya'arej u t'ʌn a caj in camsajechex: Ra' u yijir caj u q'uich'intaj caj u q'uich'intaj irej u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A yijirob caj rub ich tanbej irob a mac a cu yubicob u t'ʌn C'uj caj tarij quisin quir u taquic u t'ʌn C'uj tu pixamob soc mʌ' u yacsicob tu yor soc mʌ' ju tocar ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Caj rub yijir ich tunich irob a mac cu yubicob u t'ʌn C'uj. Qui' yor caj u c'ʌmajob u t'ʌn C'uj. Chen irob yijir a mʌna' u motsob. Tabar u yacsicob tu yorob, ca' bin tumta'c yorob ten quisin cu p'ʌticob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Caj rub yijir ich q'ui'ix irob a mac a cu yubicob u t'ʌn C'uj chen ti' toy cuxa'anob tera'. Cu tucricob ti' u bʌjiri'ob, u c'atob u nejaricob u taq'uin yejer u ba'tac. Cu chen tucricob ti' a ba' cu bin u qui'quintic yorob. Raji' cu tupsic u t'ʌn C'uj, rajen mʌ' ju qui' quibob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","U yijir a rub ich tub u nec'at u ru'umin irob a mac a cu qui' yubicob u t'ʌn C'uj caj u nequi' quibob u t'ʌn C'uj. Caj u qui' acsob tu yorob. Caj u muc'tob ba' a cu tumticob yorob soc u qui'quinticob yor C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A ba' cu camsic ti'ob irej wa t'ʌba'an u quib, rajen Jesús caj u ya'araj ti'ob: ―A mac a cu t'ʌbic u quib cu ts'ocar u t'ʌbic mʌ' u bʌric yejer ba'. Mʌ' ju yacsic yaram u ch'ac. Yʌn nacsic ca'anan soc u yerc'ac'tic tu cotor mac a cu yocar. Quire' ca' bin u yerc'ac'tej a quibo', chʌca'an ij quirej ic bej soc mʌ' jic satʌr, baxuc ti' Jesús cu camsico'on soc ic najtic ca' ij quer u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Caj ya'araj Jesús: ―Tu cotor ba' a mucu taca'an tu cu bin u reyinticob C'uj. Baje'rer ca' bin c'uchuc tu q'uinin je' u joc'ar u tajire'. Baxuc tu cotor mac je' u c'ʌ'otej ca' bin c'uchuc tu q'uinin je' u yubique'. ");
INSERT INTO lacNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Rajen qui' u'yex a ba' quin camsiquechex quire' wa ca quibiquex in t'ʌn je' in ca' camsiquechex ya'ab. Quire' wa mʌ' a quibiquex in t'ʌn a mun ya'abir ta cʌnex cu bin u tubur techex cax ca tucriquex je' u tubur techex. ");
INSERT INTO lacNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Caj tar u nʌ' Jesús yejer yits'inob. Caj c'uchob ich Jesús. Mʌ' c'ucha'an yorob u c'uchurob ich Jesús quire' ti' yʌn a pimo', jach pech. ");
INSERT INTO lacNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yʌn mac caj u t'ʌnaj Jesús: ―Ti' yʌnob a nʌ' yejer a wits'inob tar yʌnob tu xur a nepimo', u c'at yiriquechob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Caj ya'araj ti'ob Jesús: ―Quire' a mac a cu yacsic tu yor u t'ʌn C'uj a cu qui' quibicob u t'ʌn C'uj raji'ob in jach nʌ', ra' in wits'inob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Turi' u q'uinin caj binij Jesús. Caj oquij ich chem yejer u camsʌwinicob. Caj ya'araj ti'ob: ―Cuxex pʌchij c'ac'nab. Caj binob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Caj u ch'ʌctajob c'ac'nab Jesús caj wenij ich chem. Caj u nup'ob c'am yic'ar rajen caj u burij u chem, orac u jurur u chem. ");
INSERT INTO lacNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Caj bin ʌsbir Jesús ten u camsʌwinicob caj ya'arajob: ―In wʌjcamsayʌjirechob, tan ic jurur. Caj riq'uij Jesús. Caj u t'ʌnaj yic'ar yejer u yamin caj ch'en u tar yic'ar yejer u yamin. ");
INSERT INTO lacNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Caj ya'araj ti' u camsʌwinicob: ―Mʌ' wa ja qui' acsmʌnex a wor ti' ten? Quire' jach jaq'uij yorob caj u ch'ajob sajquirob. Caj ya'arajob ich u bʌjob a ju camsʌwinicob: ―A mac a je'ra', cax ic', cax u yamin, cu yuba'r u t'ʌn? ");
INSERT INTO lacNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Caj c'uchob yejer chem ich u ru'umin Gadara. Ra' ʌcʌtan u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Caj joq'uij Jesús ich chem. Caj nats'ij turi' xib ich a ray cajaro', tar bin ich Jesús. Manij ya'ab yaxq'uin aca'an ti' quisin. Rajen mʌ' u buquintic u noc', mʌ' ju cʌjtar ich naj. Ti' cu cʌjtar ich u quimirir tu yʌn u japnin tunich. Mʌ' ja wirej, a ucho' u rac'ob caj u chucajob u c'ʌrejob yejer mascab. Caj u c'ʌrob u yoc yejer u c'ʌb soc u cʌnanticob, ya'ab u teni' caj u p'icaj u mascabirob u c'ʌb yejer u mascabirob u yoc caj puts'ij ich tʌcay ru'um quire' aca'an ti' c'ac'as quisin. ");
INSERT INTO lacNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Rajen caj u yiraj Jesús, c'am caj awʌtnʌjij caj tar xontar ich Jesús. Caj ya'araj u quisinin: ―Biquinin ca pecsic in worob Jesús u pararech C'uj, a C'ujo' a mac jach no'j? Quin chich c'aticob tech soc mʌ' a ts'ic in muc'yajob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Baxuc caj ya'arob u quisinin quire' sam arac ten Jesús ca' jocac ti' a xibo'. ");
INSERT INTO lacNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús caj u c'ataj ti'ob: ―Mac a c'aba'ex? Caj u nuncajob: ―Pimenob. Baxuc caj u nuncajob ti' quire' jach pimob a quisino' a aca'an ti' a xibo'. ");
INSERT INTO lacNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A quisino' caj u chich c'atajob ti' Jesús: ―Mʌ' a tuchi'tiquenob ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Caj ya'arob: ―Are in binob ich cajir q'uec'an tu cu janʌnob ich nʌc' wits. Jesús tu chaj u binob ich cajir q'uec'an. ");
INSERT INTO lacNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","A quisino', caj joq'uij ich xib caj ocob ich cajir q'uec'an, caj u c'ʌnajob yacab caj pitc'ʌjob tu ch'ica'an, caj binob ich c'ac'nab, ti' rʌc bint ja' rʌc quimob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A mac a cu cʌnanticob cajir q'uec'an caj yirob ba' u ber ti' u cajir q'uec'an caj u c'ʌnob yacab caj bin u jumbintajob ich u cajar cax ich u chan corob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","U rac'ob caj binob yirejob ba' u ber. Caj c'uchob ich Jesús caj yirob xib a mac aca'an ti' quisin ca'ch. Ti' cura'an tan yubic u t'ʌn Jesús. Toc yʌn u noc' caj jep yor rajen jaq'uij yor a mac tar yiricob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A mac caj u yirajob bic jawsa'b a xibo' ten Jesús. Tu tsicbʌtajob ich u rac'ob a tarob ich tu cotor u cajarob a ba' caj u betaj Jesús, bic jawsa'b a xibo' a mac aca'an c'ac'as quisin ti' ca'ch. ");
INSERT INTO lacNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tu cotor mac a ti' yʌnob ich u ru'umin Gadara. Baxuc a mac a cʌja'anob bʌcris cajarob caj u chich c'atajob ti' Jesús ca' xic tu pach quire' jaca'an yorob. Rajen Jesús caj wʌc'ʌs oc ich chem quir u bin. ");
INSERT INTO lacNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A mac joc' u c'ac'as quisinin ca'ch caj u chich c'ataj ti' Jesús: ―Ar in tar ta pach. Chen Jesús caj yaraj ti': ―Mʌ' ja tar ―quij―. ");
INSERT INTO lacNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Xen ta watoch, xen jumintej a ba' tu betech C'uj, a ba' tsoyir caj u betaj tech. A xibo' caj bin u jumintej a ba' beta'b ten Jesús ti'. Baxuc caj u jumintaj ich tu cotor u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Caj sutnʌjij Jesús ich pʌchir c'ac'nab. A pimo' qui' yorob caj u yasajob Jesús quire' tan u pajicob. ");
INSERT INTO lacNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Caj c'uchij turi' xib u c'aba' Jairo, u jach ts'urir u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u pur u bʌj ich yoc Jesús caj u chich c'atej ca' xic tu yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Quire' tu quimin u chan parar xquic quire' mʌna' u jer u chan parar. Yʌn doce u yaxq'uinin. Caj bin Jesús yejer Jairo. A pimo' caj u rʌc nʌctantob u bʌj ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ti' yʌn ich a pimo' turi' xquic jach yaj quire' yʌn doce u yaxq'uinin caj u cʌnaj u yajir. Mʌ' ju jawʌr u p'o'ic u noc'. Caj u rʌc xupaj u taq'uin tu cu bin tu cu ts'acʌr. Mʌna' mac c'ucha'an yor u jawsic. ");
INSERT INTO lacNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A xquico' caj u nʌts u bʌj ich Jesús caj c'uch ich u pach Jesús caj u tʌraj u xax u noc' Jesús. Sep caj jawij u yajir. Caj tsits u q'uiq'uer. ");
INSERT INTO lacNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Caj u c'ataj Jesús: ―Mac caj u tʌraj in noc'? Mʌna' mac arej wa caj u tʌraj u noc'. Caj ya'arob Pedro yejer u yetcamsʌwinicob: ―In wʌjcamsʌyʌjirechob, a jach pimo' caj u nʌctantob tech, caj u nech'intajechob. Biquinin ca c'atic mac caj u tʌraj a noc'? ");
INSERT INTO lacNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús caj ya'araj: ―Yʌn mac caj u tʌraj in noc', tin wu'yaj bin in muc' caj u jawsa'b mac. ");
INSERT INTO lacNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A xquico' caj yubaj yer Jesús caj tari, tu babac caj xonraj ich Jesús caj u toc rʌc araj ʌcʌtan tu cotor mac biquinin caj a tʌraj u noc' Jesús. Caj ya'araj biquinin seb caj jawij. ");
INSERT INTO lacNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús caj ya'araj: ―In chan ti'arech jawech quire' caj a wacsa ta wor ca' xiquech ta watoch, qui'quintej a wor. ");
INSERT INTO lacNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ti' toy cu tsicbar Jesús caj c'uchij turi' mac, tar u tar ich yatoch Jairo. Ra' u jach ts'urir u chan najir tu cu naj c'ujintic C'uj u winiquirob judío. Caj ara'b ti' Jairo: ―Quimij a chan parar, xquic. Mʌ' a pecsic yor yʌjcamsʌyʌjir, tsire'ej. ");
INSERT INTO lacNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Caj yuba Jesús ba' ara'b ti' Jairo caj u ya'araj Jesús ti': ―Mʌ' a ch'ic sajaquir, chen acsej ta wor ten je' u jebar yore'. ");
INSERT INTO lacNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Caj c'uchij ich yatoch Jairo. Jesús mʌ' ju chabʌr u yocar mac, chen Pedro yejer Juan yejer Jacobo, quet yejer u tet yejer u nʌ', a quimen, chan xquic. ");
INSERT INTO lacNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A mac ti' yʌno' caj u yac'tajob a chan xquic baxuc caj oc'arnʌjob. Chen Jesús caj ya'araj: ―Mʌ' a wac'tiquex quire' mʌ' quimen, chen wenen u ca'. ");
INSERT INTO lacNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Caj u p'astajob Jesús quire' yirajob jach quimen. ");
INSERT INTO lacNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Caj u mʌch u c'ʌb ten Jesús caj u c'am ya'araj: ―Chan xquic riq'uen ch'icren. ");
INSERT INTO lacNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Caj u wʌc'ʌs cuxrʌj. Seb caj riq'uij. Jesús caj ya'araj: ―Ts'ajex yo'och. ");
INSERT INTO lacNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","U tet yejer u nʌ' caj jaq'uij yorob. Chen Jesús caj ya'araj ti'ob: ―Mʌ' a yʌn ariquex ti'ob mac a ba' u ber ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús caj u much'quintaj u camsʌwinicob caj u jʌsaj u muc' ti'ob quir u joc'sicob quisin, quir u jawsic u yajirir xan. ");
INSERT INTO lacNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jesús caj u tuchi'taj u camsʌwinicob quir u tsec'ticob tu cu bin u reyintejob C'uj quir u jawsic u yajirir. ");
INSERT INTO lacNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Caj ya'araj Jesús: ―Mʌ' ja ch'iquex ba' tu ca binex. Mʌ' ja ch'iquex a xonte'. Mʌ' ja ch'iquex chim. Mʌ' ja ch'iquex a woch. Mʌ' ja ch'iquex taq'uin. Chen turirir' a noc' a ch'iquex. ");
INSERT INTO lacNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A mac a cu yʌn acsiquechex ti' ca yʌn p'atʌrexe' hasta a ca' binex. ");
INSERT INTO lacNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Cax a ba' cajar mʌ' u yacsiquechex ca' bin xiquechex, toc pustex u noy ru'um ich u cajar soc yerob c'as caj u betajob quire' mʌ' tu c'ʌmajob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Caj ruc'ob u camsʌwinicob Jesús caj binob ich tu cotor u cajarob caj u tsec'tajob u jach tsoyir u t'ʌn C'uj. Baxuc caj u jawsajob u yajir mac tu cu binob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Caj yubaj gobernador Herodes tu cotor ba' cu betic Jesús yejer u camsʌwinicob quire' caj u cay tucric Herodes. Mʌ' ja wirej, yʌn mac caj u ya'arajo': “Juan wʌc'ʌs ric' ich u quimrir. Rajen cu betic aro'.” ");
INSERT INTO lacNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Caj u yuba ya'ara' Herodes ten mac: “Raji' Elías urij, rajen tan u betic aro'.” Chen u jer mac caj ya'araj: “Wʌc'ʌs riq'uij turiri' yʌjtseq'uir u t'ʌn C'uj, rajen cu betic aro'.” ");
INSERT INTO lacNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Caj ya'araj Herodes: ―Quire' caj in tuchi'taj ch'ʌcbir u car Juan, rajen aro' mʌ' Juan. A mac a quin wu'yic ya'are' cu betic aro'? In c'at in wirej ―quij. Caj u cʌxtaj bic tabar cu bin yiric. ");
INSERT INTO lacNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Caj urob u camsʌwinicob Jesús a tuchi'ta'b ca'ch caj u tsicbʌtajob ba' caj u betajob tu tu tsec'tajob u t'ʌn. Caj payob ten Jesús soc u binob tu junanob yejer Jesús. Caj payob u ber ten Jesús quir u binob ich u cajar Betsaida. ");
INSERT INTO lacNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Caj yubaj a pimo' tan u bin Jesús caj binob tu pach Jesús, caj u cha'a u tarob a pimo' caj tsec'ta'b ti'ob tu cu bin u reyintejob C'uj. Caj u jawsaj a mac yʌn u yajire'. ");
INSERT INTO lacNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tabar u bin q'uin, caj tarob a doce u camsʌwinicob Jesús. Caj ya'arob: ―Arej u bin a pimo' quir u cʌxticob quir u wenʌnob, quir u cʌxticob yoch xan. Quire' a tera' mʌna' mac. ");
INSERT INTO lacNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Caj ara'b ten Jesús: ―Bʌ' wir cu binob, techex ts'ajex yo'ochob soc mʌ' u binob. Caj ya'arob: ―Mʌna' to'onex chen yʌn cinco ij coch pan yejer ca'tur cʌy. Arej ic bin ic mʌnej yoch quir ic jansicob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jaj ixtʌco yʌn cinco mil xib. Jesús caj ya'araj ti' u camsʌwinicob: ―Arej u rʌc cutarob jun much' curicob cincuenta soc u rʌc jujuntur cincuenta cu cutarob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Baxuc caj u rʌc betajob u camsʌwinicob caj rʌc curajob a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús caj u chucaj a cinco pan yejer dos cʌy caj u nacsaj u wich ca'anan. Caj u ya'araj ti' C'uj: ―Bayo' C'uj. Caj ts'oc u t'ʌnic caj u xat'aj pan caj u ts'aj ti' u camsʌwinicob caj u jʌsejob ti' a pimo'. Baxuc yejer cʌy. ");
INSERT INTO lacNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Rʌc janob qui' nachʌjob. Caj ts'oc u janʌnob caj u marob u xet'er yoch pan yejer cʌy. Caj chupij doce xac u xet'er yoch pan yejer cʌy. ");
INSERT INTO lacNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Quire' ti' yʌn tu junan tu cu t'ʌnic C'uj Jesús, quire' caj u p'ʌtaj a pimo'. Chen ti' yʌn yejer u camsʌwinicob. Jesús caj u c'ataj ti' u camsʌwinicob: ―Bic u yaquenob a pimo'? ");
INSERT INTO lacNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Caj u nuncajob caj ya'araj: ―Juanech, bin, a cu yacsic ja' tu jo'r mac. U jerob cu yaquech Elíasech, bin, chen u jerob u ca' aric yʌjtseq'uirech u t'ʌn C'uj uch, bin, ca' riq'uech, bin. ");
INSERT INTO lacNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Caj u c'ataj ti'ob: ―A techexe' bic tabar a waquenex? Pedro, caj u nuncaj, caj ya'araj: ―Cristojech a caj u tuchi'tech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Caj u qui' ma'quintaj ti' u camsʌwinicob: ―Mʌ' a yʌn bin a wa'arex ti' mʌna' mac wa Cristojen. ");
INSERT INTO lacNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Caj ara'b ti'ob ten Jesús: ―A teno' baxuquenechexo' tu tuchi'ten C'uj, jach yaj quin bin muc'yajnʌquen. Cu bin u xunp'ʌtiquenob u jach ts'urirob u cajar u winiquirob judío yejer u jach ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Bin u quinsenob chen ca' bin tac mʌna' u nup u q'uinin C'uj cu bin u ric'siquen. ");
INSERT INTO lacNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pachir caj ya'araj ti' tu cotor mac: ―Wa mac u c'at u tar tin pach soc u cʌnic in t'ʌn. Arej u p'ʌtej a ba' cu pachtic tu yor tu cotor u nonobʌjiri' soc u betic a ba' u c'at C'uj. Rajra' yʌn u tar tin pach cax wa quimij ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","A mac a cu tucric ti' u nonobʌjiri' ti' toy cuxa'an cu bin u satar a ba' jach manan co'oj. Cu bin u satar u cuxtar munt q'uin. Chen a mac a u c'at u quimin ti' ten cu bin u c'ʌmic a ba' jach manan co'oj, cu bin u c'ʌmic u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mʌ' u joc'ar tu tsoyir cax cu ts'urintic tu cotor ba' ich yoc'ocab wa cu satʌr u pixam. Quire' je' u bo'otic u bo'orir u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wa mac cu ch'ic suraquir ti' ten yejer a ba' quin tsec'tic, baxuc a ba' quin camsic. Baxuc ten, ca' bin in ch'a'aj suraquir ti' quire' a teno' baxuquenechexo'. Quin bin in ch'a'aj suraquir ti' ca' bin taquen ich u sasirir C'uj in Tet yejer u muc' u yʌjmasirob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Chen jach taj quin wac techex. Chʌc yʌn jun yarob mac a tera' mʌ' ju bin quimin hasta cu yiric bic C'uj cu bin u reyinticob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Caj man turi' semana caj ts'oc u camsic a ra' t'ʌno' ti' u camsʌwinicob. Jesús caj naquij ich jo'r wits quir u t'ʌnic C'uj. Yet binacob Pedro yejer Jacobo yejer Juan, quire' payob ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús caj u t'ʌnaj C'uj caj waysa'b u wich caj way u noc' sʌc, jach sʌc t'ina'an. ");
INSERT INTO lacNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ray u q'uinin caj c'uchob ixba' Moisés yejer ixba' Elías. Caj c'uchob ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Caj u tsicbanʌjob yejer Jesús bic tabar u quimin Jesús soc u nupsic u t'ʌn C'uj ca' bin quimic ich u cajar Jerusalén. U sasirir C'uj bʌcrista'bob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A Pedrojo' yejer u yet camsʌwinicob jach p'encʌch tar u wenʌnob caj ajob caj yirob u wayʌr Jesús. Baxuc ti' yʌnob ca'tur xib ich yicnʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Quire' tan u binob nanach ixba' Moisés yejer ixba' Elías, Pedro caj ya'araj ti' Jesús: ―In wʌjcamsʌyʌjirech ―quij―. Jach tsoy ti' yʌno'on tera'. Are ca' in c'ʌxejob pʌser. Turi' ti' tech. Turi' ti' ixba' Moisés. Turi' ti' ixba' Elías. Caj ya'araj aro' quire' mʌ' tu qui' tucraj a ba' caj u ya'araj. ");
INSERT INTO lacNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ti' toy u tsicbar Pedro caj tari turiri' u muyarir caj jaq'uij yorob u camsʌwinicob caj ts'oc u binob ixba' Moisés yejer ixba' Elías ich u muyarir. ");
INSERT INTO lacNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Caj yubob u t'ʌn C'uj ich u muyarir. Caj yubob ya'ara' ti'ob: ―A je'ra' in jach parar a mac in jach yaj. Ca' u'yex a ba' cu camsiquechex. ");
INSERT INTO lacNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Caj ts'oc u yubicob u t'ʌn tu ca' irob Jesús tu junan mʌna' mac ti' yʌn. A mʌna' u nup u camsʌwinicob a ba' caj u yirob tu cotor aro' tu mʌcob u chi' mʌ' tu ya'arajob ti' mac a ba' caj u yirob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Caj sasij, caj ts'oc u yemanob ich u jo'r wits Jesús yejerob a mʌna' u nupo'. Caj tar a pimo' quir u nup'icob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ti' yʌn mac turi' ich a pimo' caj u puraj u t'ʌn ti' Jesús: ―In wʌjcamsʌyʌjirech quin chich c'atic tech ca' a chan yamten ti' in parar quire' turi' ten. ");
INSERT INTO lacNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ca' bin chucuc ten quisin in chan parar. Cu sepquintic yawʌt, cu yʌn satʌr yor hasta cu yom u chi'. Ca' bin p'atʌc ten u quisinin in parar cu jach ts'abʌr u muc'yaj ten quisin hasta mʌna' yor. ");
INSERT INTO lacNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A xibo' caj u ya'araj: ―Caj in chich araj ti'ob a camsʌwinicob ca' u joc'sejob u quisinin chen mʌ' c'ucha'an yorob u joc'sicob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús caj u nuncaj ti': ―A techexo' a mac cuxa'an u q'uinin baje'rer. Biquinin mʌ' a wacsmʌnex ta wor ti' C'uj? Biquinin jach chichex a jo'r? Ya'ab u q'uinin ti' yʌnen tera' mʌ' toy a wacsejex ta wor. A ber ca' bin a wacsex ta wor ten. Jesús caj u t'ʌnaj a xibo': ―Toc pʌyej a parar a te'ra'. ");
INSERT INTO lacNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tabar u nats'ʌr ich Jesús a quisino' caj rubsaj ich ru'um. Caj satij yor ten quisin. Chen Jesús caj u q'ueyaj u quisinin. A baywo' caj joc' u quisinin. Caj ts'oc u joc'ar u quisin caj jawij, Jesús caj u sutaj ti' u tet. ");
INSERT INTO lacNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jach jaq'uij yorob a pimo' quire' caj yirajob carem u beyaj C'uj. Ti' toy jac'a'an yorob a pimo' ti' u carem beyaj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Caj ya'araj Jesús ti' u camsʌwinicob: ―Qui' uyex a je'ra' a ba' quin camsiquechex baje'rer. Mʌ' ju yʌn tubur techex. Quire' bin u ca'ob u c'ubirenob a teno' ti' a mac a cu p'actiquenob a teno' bayxuquenechexo'. ");
INSERT INTO lacNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","U camsʌwinicob mʌ' ju najtajob a ba' ara'b ti'ob ten Jesús. Mʌ' ju najtajob quire' mʌ' toc ara'b ten Jesús ti'ob a ba' u c'at ya'aric. Quire' suracob quir u c'aticob a ba' ara'b ti'ob sam. ");
INSERT INTO lacNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","U camsʌwinicob quet u pacran acob soc yerob mac jach no'jo' ich u yet camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús caj u najtaj a ba' cu tucricob tu yorob rajen caj u pʌyaj chichan quir u ch'iquintic yicnʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jesús caj u ya'araj ti' u camsʌwinicob: ―Wa tsoy ca betiquex ti' a je' chichana' cax ti' u jer xan quire' ca yajquintiquen. Tsoy ca betiquex ten xan. Baxuc tsoy caj a betex ti' C'uj a mac caj u tuchi'tajen. A mac a cu tucric ich u wʌc'ʌs bʌjiri': “Mʌ' no'jen a teno'”, raji'o' toc no'j ʌcʌtan tu wich C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Caj ya'araj Juan: ―In wʌjcamsʌyʌjirech, tij quiraj turi' mac caj u joc'saj quisin ca'ch. Caj u t'ʌnaj a c'aba'. Tij caraj ti': “Tsire'ej” quire' mʌ' u sayʌr ta pach quir u cʌnic a t'ʌn. An ten bic to'on quic sayʌr ta pach. ");
INSERT INTO lacNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Caj ya'araj Jesús: ―Tsire'ej, cax mʌ' ja wac ti' quire' a mac a mʌ' u p'actic to'on cu yamtico'on. ");
INSERT INTO lacNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tabar u c'uchur tu q'uinin u ca' payʌr Jesús ten C'uj ca' xic ich ca'anan. Jesús u c'at u jach bin ich u cajar Jerusalén. Ts'ajan yor tar u bin. ");
INSERT INTO lacNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Rajen caj u tuchi'taj mʌ' ya'abir mac soc pʌybejob cu binob. Robob caj binob caj c'uchob ich u cajar Samaria, caj u cʌxtajob mac quir u yacsa'rob wenʌnob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Chen ich u cajar Samaria mʌ' u c'at yacsa'robi' quire' ti' cu binob ich u cajar Jerusalén, Jesús yejer u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Caj wʌc'ʌs urob ich Jesús a tuchi'ta'bob. Quire' yubob mʌ' u yacsa'rob a Juano' yejer Jacobo quire' yubob mʌ' acsa'bobi' caj ya'arob ti' Jesús: ―Arej to'on in wʌjcamsayʌjirechob ca' tac u c'aq'uir ca'anan ca' rʌc erac ara' cajaro' an bic caj u betaj Elías uch, a cu tsec'tic u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús caj u sut u bʌj quir u pʌctic a ca'tur u camsʌwinicob. Caj u q'ueyaj caj u ya'araj ti'ob: ―A techexo' mʌ' a werex mac ca ts'urintiquex. ");
INSERT INTO lacNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","A teno' baxuquenechexo' mʌ' taren in ch'esic u cajar mac, taren in ta'quic tu cotor mac quire' tu tuchi'ten C'uj. Jeroj caj binob ich u jer cajar. ");
INSERT INTO lacNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ti' toy cu binob ich u berir Jerusalén. Turi' mac caj u ya'araj ti' Jesús: ―Arej in tar ta pach cax tu ca bin. ");
INSERT INTO lacNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Caj u nuncaj Jesús caj u ya'araj: ―A boboch pec'o' yʌn u jor tu cu wenʌn baxuc a ch'ich'o' yʌn u c'ʌbir che' tu cu wenʌn. Chen a teno' mʌna' tu quin chatar in jesic in bʌj a teno', baxuquenechexo'. ");
INSERT INTO lacNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús caj ya'araj ti' u jer mac: ―Cojen tin pach ―quij―, quir a cʌnic in t'ʌn. Chen caj ya'araj ti' a mac pay ten Jesús: ―Arej in p'atʌr ich yicnʌn in tet hasta cu quimin in tet, je' in tar ta pache'. ");
INSERT INTO lacNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús caj u nuncaj ti': ―A mac a irej a quimeno', raji'ob cu bin u muquicob u quimirir. Chen tech xen tsec'tej u jach tsoyir u t'ʌn C'uj tu cu bin u reyintejob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chen ti' yʌn u jer caj ara'b ti': ―A teno' je' in tar ta pache'. Ar in bin in c'atej ti' in bʌjob wa tsoy in tar ta pach. ");
INSERT INTO lacNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chen Jesús caj ya'araj ti': ―A mac a u c'at u jach tar tin pach chen mʌ' u jach p'is u bʌj ca' tac tin pach. Wa cu chen tucric a ba' caj u p'ʌtaj je' u nacar yor ti' a ba' a cu tar ti'. Aro' mʌ' tsoy u beyaj tu cu bin u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Caj ts'oc u tsicbar ti' a mac a ju c'at u tarob tu pach Jesús caj u tetaj u jerob setenta u camsʌwinicob. Caj u tuchi'taj ca' ca'turob ich tu cotor u chan cajar. Baxuc ich tu cotor u yajaw cajar xan. Raji'ob cu yʌn binob. Pachir cu c'uchur Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Caj ya'araj Jesús ti'ob: ―Ti' yʌn mac pim u c'at yubicob u t'ʌn C'uj chen a cu beyajob, mʌ' nepimi' a cu tsec'ticob u t'ʌn C'uj ti'ob. Aro' irej wa ti' yʌn jach ya'ab u trigo quir u wʌtic. Chen mʌna' mac quir u wʌtic. Rajen ca' a t'ʌnex C'uj soc u tuchi'tic mac quir u bin u tsicbʌtic u t'ʌn C'uj soc c'ucha'an yorob u yubicob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Baje'rer ca' xiquechex tu caj in wa'araj a binex. Je' a wiricobexe' irob barum. Robob cu bin yiriquechexob irechex tʌmʌn yuc. An ten bic barum u c'at u chi'ic tʌmʌn yuc. Baxuc a xibo' u c'at quinsiquechexob. ");
INSERT INTO lacNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ca' bin xiquechex mʌ' ja yʌn ch'iquex a chimex, u boxer a taq'uinex mʌ' ca ch'iquex. Mʌ' ja ch'iquex a pech' xʌnʌb, ts'ot a bin beyajex. Mʌ' ja yʌn wec' t'ʌniquex mac tu ca binex a tsec'tiquex u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ca' bin yʌn ocaquex ich yatoch mac, yʌn arex ti' tu ca t'ʌnic: “In c'at ca' qui'ac a worex ti' C'uj a mac ti' yʌn ich yatoch tera'.” ");
INSERT INTO lacNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wa ti' yʌn mac a tabar u qui' tar yor ti' C'uj, je' u bin qui' tar yor ti' C'uj. An ten bic techex caj a c'atajex ti'. Chen wa ti' yʌn mac mʌ' u qui'tar yor ti' C'uj. Aro' mʌ' ju bin qui' tar yor ti' C'uj. A bʌjiri'ex ca bin a waquex ti': “Je' in wʌc'ʌs ch'ic a ba' caj in wa'araj techex u qui'ir yor C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tiri' ca p'atʌrex ich yatoch a tu yacsechex mʌ' a ca' cay binex ich u jer naj. Janʌnex uc'urnenex xan a ba' cu ts'ic techex an biquex a janʌnex ta watochex. Irechex a mac cu c'ʌmic u bo'orir u beyaj quire' ra' u bo'orir tu ca beyajex. ");
INSERT INTO lacNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wa ca wocarex ich u chan cajar tu cu yacsiquechex, toc jantechex ba' cu ts'ictechex. ");
INSERT INTO lacNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jawsex u yajir tu ca binex ich u chan cajar. Yʌn arex ti': “Toc ti' yʌnechex baje'ra' quire' toc c'uchij tu q'uinin tu ca bin a reyintiquex C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wa ca wocarex ich u chan cajar tu mʌ' u yacsiquex, toc ruq'uenex ich tan bej ich u cajar. Ca waquex ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Cax u ru'umin a cajarex a cu nich'ir tin woc quin toc pusticob tin wocob quire' c'as caj a betajex. A baywo' quin toc aric techex c'uchij tu q'uinin C'uj ca' bin a reyintiquex, chen mʌ' a c'at a reyintiquex C'uj.” Baxuc yʌn a waquex ti' mac a mʌ' u yacsiquex. ");
INSERT INTO lacNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jesús caj ya'araj ti' u camsʌwinicob a setentajo': ―Chen a teno' quin wac techex ca' bin xuruc t'ʌn a ra cajaro' a mʌ' tu yacsajechex, jach manan cu bin ts'abʌr u muc'yajob ten C'uj. Chen u cajar Sodoma, mʌ' u nebin muc'yajob a ch'esa'b ten C'uj yejer c'ac' uch. ");
INSERT INTO lacNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ti' toy cu tsicbar Jesús ti' a setentajo' caj ya'araj: ―Jach otsir techex ich u cajar Corazín. Baxuc otsirechex ich u cajar Betsaida. Jaj ixtʌco' wa ti' yʌn mac uch ich u cajar Tiro yejer u cajar Sidón caj u yesej u carem beyajob. An ten bic caj in wesaj techex carem beyajob. Robob a ti' yʌnob uch ich u cajar Tiro yejer Sidón. Tabar ix ti' ucho' ca' bin u c'axicob yorob tan a p'ʌticob u manob tu c'asir. Jaj ix ti' caj u buquintajob u rabir u noc'. Baxuc caj u posta'antajob u jo'rob yejer c'uta'an soc yer mac tucur u ca'ob. An ten bic mac nanij cu beticob uch. ");
INSERT INTO lacNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ca' bin xuruc t'ʌn a techex a cʌja'anechex ich u cajar Corazín yejer Betsaida. Jach manan ca bin muc'yajex chen a mac a cʌja'anob uch ich u cajar Tiro yejer Sidón, mʌ' ju bin nemuc'yajob. ");
INSERT INTO lacNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A techex ca tucriquex ich a cajar Capernaum jach no'jechex yiriquechex C'uj. Chen C'uj mʌ' ju yiriquechex wa jach no'jechex cu bin u puriquechex ich c'ac' munt q'uin quire' mʌ' ta wacsajex ta wor ti' ten. ");
INSERT INTO lacNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’A mac a cu quibiquex a t'ʌnex baxuc ten cu quibob in t'ʌn xan. A maque' mʌ' ju c'ʌmic a ba' ca waquex ti'ob. Baxuc ten mʌ' u c'ʌmicob a ba' quin wac ti'ob. Baxuc a mac mʌ' ju c'ʌmicob a ba' quin wa'aric ti'. Mʌ' tan u c'ʌmic a ba' cu ya'aric C'uj quire' raji' caj u tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Caj urob a setentajo' tub binob u tsec'ticob u t'ʌn C'uj. Jach qui' yorob caj urob ich Jesús, caj ya'arajob: ―Jaj Ts'urir, cax c'ac'as quisinob caj u yubob ic t'ʌnob caj ij caraj ti'ob: “Quisin, ich u c'aba' Jesús, ca' xiquex”, jeroj joq'ui. ");
INSERT INTO lacNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús caj ya'araj ti'ob: ―A teno' caj in wiraj a rubsiquex u muc' a quisino'. Seb caj in wiraj a rubsiquex u muc' a quisino'. ");
INSERT INTO lacNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mʌ' ja wirej, an ten bic c'ucha'an a worex ti' a joc'siquex quisin quire' a teno' caj in jʌsatechex in muc'. Baxuc xan ca pech'ʌctiquex can a yʌc u cojo', cax roroch mʌ' ja bin a wu'iquex yajir. Baxuc caj in jʌsatechex in muc' soc mʌ' a sʌjtiquex a quisin quire' c'ucha'an a worex ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mʌ' a chen qui'quintex a worex quire' a c'ac'as quisino' caj u yubajob a t'ʌnex, barej jach qui'quintex a worex quire' ti' ts'iba'an ich u ju'unin C'uj a c'aba' techex. Quire' ti' ts'iba'an a mac a caj u yacsajob tu yorob. ");
INSERT INTO lacNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ra'iri' u q'uinin caj qui'quinta'b yor Jesús ten u Taj'or u Pixam C'uj, Jesús caj ya'araj ti' C'uj: ―Jach caremech C'uj, in tetech, cax ca'anano' cax yoc'ocabo'. U jach ts'urirech quire' tech ta rʌc betaj tu cotor ba'. Jach caremech C'uj ―quij―. Mʌ' ja wirej, caj a jʌsa a muc' ti' a mac a mʌ' yerob ju'un soc u joc'sicob c'ac'as quisinob soc c'ucha'an yorob ti' a jach quisino'. Mʌ' ta ts'aja u najtejob a ba' a c'at ti' a mac u ne'erob ba' quire' baxuc a c'at tech. ");
INSERT INTO lacNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Jesús caj ya'araj ti' a mac ti' yʌnob yejerob setenta. Tu cotor mac a teno' cu bin u ts'urintiquen quire' baxuc u c'at C'uj. Mʌna' mac yer u parareni' ―quij Jesús―, chen in Tet yer maqueni'. Mʌna' mac yer mac in Tet chen ten quire' u pararen. Rajen u jer mac c'ucha'an yor yer C'uj wa quin cha'ic u najtic. ");
INSERT INTO lacNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Caj binob tu junan Jesús yejer u camsʌwinicob. Caj u pʌctaj caj ya'araj ti'ob: ―Qui'quintej a worex quire' a ba' ca wiriquex in camsic baxuc quire' ca wiriquenex. ");
INSERT INTO lacNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Quire' yʌn ya'ab yʌjtseq'uirob u t'ʌn C'uj uch. Baxuc reyob xan, quire' u c'at yiriquenob uch, chen mʌ' yirenob uch cax u c'atob yubicob a ba' quin camsic an bic techex ca wiriquenex in camsicob, chen mʌ' tu yubob. ");
INSERT INTO lacNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","C'uchij turiri' mac ich Jesús. A cu camsic u t'ʌn Moisés. Tar u tumtic yor Jesús tu cu camsic mac. Caj u c'ata ti': ―In wʌjcamsʌyʌjirech ―quij―, ba' quin bin in betej quir in cuxtar munt q'uin? ");
INSERT INTO lacNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Caj nunca' ten Jesús: ―Ba' ts'iba'an ich u t'ʌn C'uj tu ca xaquic? ");
INSERT INTO lacNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yʌjcamsʌyʌjir u t'ʌn Moisés caj u nunca: ―U t'ʌn C'uj cu ya'aric: “Quet ca' ic yajquintej ic Jaj Ts'urir yejer tu cotor ic pixam yejer tu cotor ic muc' yejer tu cotor ic tucur ich ic jo'r.” Baxuc ca' ic yajquintej ij quet cajar. An ten bic ic yajquintic ic wʌc'ʌs bʌjiri'. ");
INSERT INTO lacNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Caj ara'b ten Jesús: ―Taj a ba' caj a nuncaj. Wa ca betic baxuc aro', yʌn a cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Quire' cu tucric mʌ' qui' nunc'ab ten Jesús. Rajen ca' u c'ataj ti' Jesús: ―Mac in wet cajari' quir in yajquintic? ");
INSERT INTO lacNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A baywo' caj u nuncaj Jesús soc u camsic: ―Caj binij turi' winic ich u cajar Jericó. Ti' ruq'uij ich u cajar Jerusalén. Caj u nup'aj mac a cu yac'rʌ' ba'. Caj chuc ten yʌjac'rʌ' yʌjirob ba' rʌc ac'ra'b u ba'tac cax u buquimʌn u noc' rʌc ch'a'b ti', caj ts'oc u rʌj jʌts'ic, irej wa quimen caj u p'ʌtajob. ");
INSERT INTO lacNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ra'iri' u q'uinin caj manij sacerdote ich bej tu chara'an a mac jats' irej quimen. Caj yiraj charique' nach caj man. ");
INSERT INTO lacNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Baxuc caj tar u winiquir judío u yo'nen Leví, ra' cu beyaj ich carem naj. Caj yira charic a mac jats' caj u pot mastaj. ");
INSERT INTO lacNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Caj tar u winiquir u cajar Samaria nach u tar caj tarij tan u nats'ʌr tu chara'an a mac jʌts'a'an. Caj u yiraj charic caj u yajquintaj. ");
INSERT INTO lacNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","U winiquir samaria caj c'uchij tu chara'an a xibo' a jʌts'a'ano' caj u ts'ʌcaj tu c'orij tut jats' caj u jic'taj tsats yejer u c'ab u wich uva quir u jawʌr. Caj u nacsaj tu pach u tsimin quire' ra' u tsimin caj bin u puric quir u cʌnanta' ti' tu tu mʌjantaj yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Caj sasij quire' bin u ca' u winiquir samaria. Caj u chʌc jaraj u taq'uin ca' turur u sʌc taq'uin caj u ts'aja ti' a mac yʌnin yatoch. Caj ya'araj ti': “Cʌnantej a je' xiba' wa ca rʌc xupic a taq'uin ti' a mac ca' bin uquen je' in bo'otiquech.” Baxuc caj ya'araj Jesús ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Caj ts'oc u tsicbar Jesús ti' a jʌts'a'an caj u c'ataj ti' yʌjcamsʌyʌjir u t'ʌn Moisés: ―Arej ten ich a mʌna' u nup xibo' a mac caj u yajquintaj? ");
INSERT INTO lacNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Caj ya'araj yʌjcamsʌyʌjir u t'ʌn Moisés. A mac a tu yiraj otsir a jʌts'a'ano', raji' tu yajquintaj. Jesús caj u nuncaj ti': ―Baxuc tech rajra' ca' a yajquintej mac. ");
INSERT INTO lacNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ti' toy cu bin Jesús yejer u camsʌwinicob ich u berir Jerusalén caj c'uchij tu cajar. Ti' yʌn xquic u c'aba' Marta. Raji' caj u yacsaj ich yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A Martajo' yʌn u yits'in María u c'aba'. Caj curʌj María ich yoc Jesús quire' u c'at yubic a ba' cu camsa'. ");
INSERT INTO lacNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Chen Marta cu tucric jach ya'ab u beyaj rajen tarij ich Jesús caj ya'araj ti': ―Jaj Ts'urir ―quen―, wa ca jach tucriquen ca wac ti' in wits'in ca' tac u yamten. ");
INSERT INTO lacNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chen Jesús caj u nuncaj ti': ―Marta ―quen―, ca jach tucric a beyaj, rajen choc a wor quire' jach ya'ab. ");
INSERT INTO lacNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","María caj u tetaj a ba' jach tsoy rajen cu tucric u tar yubej in t'ʌn. Rajen mʌna' mac cu ma'quintic soc mʌ' u tar. ");
INSERT INTO lacNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ti' yʌn Jesús tu cu t'ʌnic C'uj uch caj ts'oc u t'ʌnic C'uj caj c'uchob u camsʌwinicob Jesús turi'. Caj ya'araj ti': ―Jach Ts'urir ―quij―, camsenob bic in t'ʌnicob C'uj an ten bic Juan caj u camsaj u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Caj nunca'b ti'ob ten Jesús: ―Ca' binex a t'ʌniquex C'uj. Baxuc a je'ra' ca waquex ti': In Tetob a mac ti' yʌno' ich ca'anan. Quin c'atob soc tu cotor mac cu c'ujintiquech. Quin c'aticob tech ca' bin c'uchuc tu q'uinin ca' bin a reyintej ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Chan chuquej tenob in woch soc ti'bir yʌn tenob ti' u q'uinin baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jawsej tenob in si'pirob a ba' si'pir caj in betajob quire' quin jawsicob u si'pirob in rac'ob cax a ba' c'asir caj u betajob ten xan. Mʌ' ja cha'ic in binob tu quin pʌyicob in si'pirob. Mʌ' ja cha'ic in ts'urinticob a ba' quin pachticob tin worob a c'aso'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús caj ya'araj ti' u camsʌwinicob: ―Qui' tucrej a ba' u ber wa ca' bin xiquech tu yʌn a ju yajech cax chumuc ac'bir ti' ca bin a c'atic ti'. Ca wa'aric ti': “Chan chuquej ten a woch pan quire' a yajen, cax mʌna' u nup pan. ");
INSERT INTO lacNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mʌ' ja wirej, tan tu c'uchur a mac u yajen, nach u tar, caj tarij quire' mʌna' ten quir in jansic.” ");
INSERT INTO lacNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A mac a ti' yʌn ich yatoch a mac a ju jach yaj, a mac tar c'atbir yoch. Jaj ixtʌco cu nunquic: “Mʌ' a pecsic in wor quire' caj in toc mʌcaj u jor in watoch. Toc ti' yʌnen yejer in parar tin wenʌnob. Mʌ' jin riq'uir in ts'ic tech a ba' a c'at.” ");
INSERT INTO lacNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Quire' ―quij Jesús―, taj quin wa'aric techex. Cax mʌ' u riq'uir u ts'ic ti' yoch quire' jach yaj yiric. Chen je' u riq'uir u ts'ic ti' a ba' u c'at quire' rajra' cu jach p'isic u bʌj u c'atic ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Baxuc ti' C'uj xan ―quij Jesús―: C'atej ti' C'uj, je' u ts'iquex tex. Cʌxtex a ba' a c'at, C'uj cu bin u cha'ic a wiriquex. C'atex ti' C'uj, irej a mac cu c'atic ich u jor naj, je' u ts'abʌr techex an bic ca c'atic. ");
INSERT INTO lacNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","A teno', quin wac techex ―quij Jesús―, tu cotor mac a cu c'atic ti', je' u ts'abʌr ti'. Tu cotor mac cu cʌxtic a ba' u c'at, je' u yirique'. Tu cotor mac cu c'atic a ba' u c'at, an ten bic caj u c'ataj ti' xib ich u jor yatoch. Je' u ts'abʌr ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Caj ya'araj Jesús ti' u camsʌwinicob: ―Wa mac ti' yʌn ta wicnʌnex a yʌn u pararo' je' wa ju ts'ic ti' tunich wa caj u c'ataj yoch pan? Mʌ' ju ts'ic tunich ti'. Je' wa ju ts'ic ti' can quir u ch'ic wa cu c'atic yoch cʌy? Mʌ' ju ts'ic ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Je' wa ju ts'ic ti' roroch quir u chi'ic wa cu c'atic yoch ye'er cax. Mʌ' ju ts'ic ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A techexo' cax jach c'asechex a werex a ts'iquex ti' a parar a ba' jach tsoyo'. Jach manan tsoyir a ti' yʌn ich ca'anano'. Baxuc a C'ujo' a ti' yʌn ich ca'anʌno' jach manan tsoyir cu ts'abʌr ti' u Taj'or u Pixam C'uj ti' a mac a cu c'atic ti'e'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Caj u joc'saj quisin Jesús ti' a xibo' a mʌ' ju joc'ar u t'ʌne'. Caj ts'oc u joc'sic caj yʌnxchun u t'ʌn. Rajen jaq'uij yorob a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Chen yʌn mac mʌ' ya'abir caj u ya'arajob: ―A je' xiba' cu joc'sic c'ac'as quisin quire' yamta'b ten Beelzebú quire' ra' u Jach Ts'urir u quisinin. ");
INSERT INTO lacNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Chen ti' yʌnob u jerob u c'at u tus tumticob yor Jesús quir u yesic carem beyaj soc yerob wa tuchi'ta'b ten C'uj wa mʌ'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Chen Jesús yer ba' cu tucricob tu yorob tu pʌc'ob u pach u jach ts'urir quisin Jesús. Caj ya'araj ti'ob: ―Mʌ' ja wirej, tu cotor ru'um tu cu reyinticob rey. Wa ju jer junxot cu ts'ictarob yejer u jer junxot cu bin u rʌc ch'esicob u yet cajarob mʌ' ju p'at mac. Baxuc xan a mac p'eri' cʌjricob ich yatoch cax u wʌc'ʌs u bʌjob wa cu pacran ts'ictarob cu bin u ch'esicob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Baxuc xan a Satanáso', wa ju winiquirob Satanás cu pacran ts'ictarob cu bin u rʌc ch'esicob u bʌj. Mʌna' mac cu bin u reyinticob Satanás. Quire' techex ta wa'arajex quin joc'sic in wet quisinin. Quire' caj u yamtajen Beelzebú. ");
INSERT INTO lacNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wa baxuc quin joc'sic quisin an ten bic ca tucriquex. Baxuc arex ten bic u camsʌwinicobex, cu joc'sicob a quisinino'. Mʌ' u joc'sicob quire' yamta'b ten Beelzebú quire' a werex yamta'bob ten C'uj quir u joc'sicob. Mʌ' ja ta'quiquex in jo'r, tan in yamta'r ten Beelzebú. ");
INSERT INTO lacNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mʌ' taj cu yamtiquen Beelzebú quir in joc'sic quisin. Chen u muc' C'uj quir in joc'sic a quisino'. Aro' cu yesic c'uchij tu q'uinin a reyintiquex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ti' toy cu camsic Jesús caj ya'araj: ―A werex ―quij Jesús―, a mac jach chich u muc', irej a quisino', u mʌchmʌn u mascab quire' cu cʌnantic a ba' yʌn ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ca' bin c'uchuc tu q'uinin cu tar a jach manan chich u muc', iren ―quij Jesús―. Cu ts'ictar yejer a quisino', cu rʌc to'car u mascab tu cu cʌnantic a ba' yʌn ti', cu ts'ocar u to'car ti', cu rʌc ch'ic u jʌsic ich u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Quire' a mac mʌ' ju yamtiquen cu yamtic a quisino' quire' a mac mʌ' ju yamtiquen irej, tan u joc'sic mac ca' xic erar ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Caj ya'araj Jesús ti'ob: ―A ucho' joc'sa'b quisinin ten mac tar cu mano' u quisinin ich tacay ru'um tu yʌn u yet quisinin. Caj u cʌxtaj tu cu jesic u bʌj. Chen mʌ' tu yiraj. A quisino' caj ya'araj: “Je' in ca' bin tu joq'uen a ucho' soc in wʌc'ʌs ocar ti'.” ");
INSERT INTO lacNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Caj sutnʌj a quisino' caj u yiraj a je' xiba', irej yatoch toc misa'an chen mʌna' mac yʌnin u pixam a xibo', toc qui' yor. ");
INSERT INTO lacNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Rajen caj bin u pʌyej siete yet quisinin jach manan c'as u yet quisino'. A ti' ucho' mʌ' nejach c'asi'. Caj rʌc ocob a quisino' quir u ts'urinta' a quisino' ten a xibo'. A xibo' a aca'an ti' quisin jach manan c'as baje'rer, a ucho' mʌ' nec'asi'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ti' toy cu tsicbar Jesús ti' a pimo'. Turi' xquic ich yicnʌnob caj u puraj u t'ʌn ti' Jesús caj ya'araj: ―Mun tsoyir a nʌ'o' a tu ch'isajech a ta chuch a yim. ");
INSERT INTO lacNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Caj ya'araj Jesús: ―Jaj ixtʌc taj a ba' ca wac chen jach manan qui' yor a cu quibic u t'ʌn C'uj a tan u man tu tsoyir a ba' cu betic. ");
INSERT INTO lacNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Caj u rʌc tar a pimo' uch quir u rʌc bʌcristicob Jesús, caj u yʌnxchun ya'aric uche': ―A techexo' ―quij Jesús―, a mac cuxa'an u q'uinin bajera' jach c'asechex quire' ca c'atiquex a wiriquex carem beyaj soc a werex wa tuchi'ten C'uj. Chen turi' cu bin ts'abʌr techex soc a werex caj u tuchi'ten C'uj. Cu bin u betej C'uj an ten bic caj u betaj ti' yʌjtseq'uir u t'ʌn C'uj uch, u c'aba' Jonás. ");
INSERT INTO lacNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Soc yerob winiquirob uch ich u cajar Nínive tuchi'ta'b ten C'uj Jonás. Baxuc ten ―quij Jesús―, soc a wer caj u tuchi'tajen C'uj xan. ");
INSERT INTO lacNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ti' toy cu tsicbar Jesús ti' a pimo': ―Ca' bin c'uchuc ―quij Jesús―, tu q'uinin cu xur t'ʌn, a ray u q'uinino', cu bin riq'uir mac a quimen a ucho'. Cu bin tar xquic u reina u winiquirob u cajar Seba. Aro' tar cu bin ʌcʌtan C'ujo', cu bin u ta'quic a jo'rex a mac cuxa'an u q'uinin bajera', quire' c'as caj a betaj techex. Mʌ' ja wirej, a ray xquico' jach nach u tar uch quir yubic u t'ʌn Salomón quire' u nejach er ba' Salomón. Chen ti' yʌnen baje'ra' ―quij Jesús―, jach no'jen a teno'. A Salomón ucho' mʌ' nejach no'ji' chen techex mʌ' ja qui' quibiquex in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ca' bin c'uchuc tu q'uinin u xur t'ʌn, a ray u q'uinin ca' bin xic ʌcʌtan C'uj tu cotor mac. Quire' u winiquirob tu cajar Nínive ca' bin ts'ocac u riq'uir tu quimen a ucho'. Tar cu binob ʌcʌtan C'uj quir u ta'quiquex a jo'rob. Quire' c'as caj betajex. Mʌ' ja wirej, robob caj u c'axajob yorob soc u p'ʌticob u c'asirob uch caj yubob caj u tsec'tic u t'ʌn C'uj Jonás. Mʌ' jach no'j a Jonás a ucho'. Caj u c'axob u yor u winiquirob u cajar Nínive. A teno' jach no'jen chen mʌ' tan a c'axiquex a worex ti' in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","U camsa'bar Jesús, irej cu t'ʌbic quib quir u yerc'ac'tic mac. Rajen Jesús caj ya'araj: ―A mac a cu t'ʌbic u quib ca' bin ts'ocar u t'ʌbic mʌ' u bʌric yejer xac. Mʌ' ju ta'quic u quib tu yatoch soc mʌ' yiric mac. Ca' bin ts'ocar u t'ʌbic cu chen na'sic ca'anan quir yerc'ac'tic a mac a cu yocar. Baxuc ten ―quij Jesús―. Mʌ' tin mucric u t'ʌn C'uj ti' techex. Caj in chen tsec'taj techex u t'ʌn C'uj ʌcʌtan tu cotor mac soc u rʌc u'wic. ");
INSERT INTO lacNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A quibo' quir u yerc'ac'tic mac. Rajen wa mʌ' p'ur buts' ti' u ras quib chʌca'an ic betic a ba' ij c'at. Wa p'ur buts' ti' u ras quib mʌ' u neyerc'ac'tic ba'. Rajen ac'bir ij cʌjtoch soc mʌ' chʌca'an ic betej a ba' ij c'at. Baxuc techex yejer a wichex wa tsoy ta t'ʌn ca wiriquenex, je' u yocar in t'ʌn tu quin camsic techex. Wa mʌ' tsoy ta t'ʌn ca wiriquenex, mʌ' u yocar in t'ʌn ta pixamex tu quin camsic techex, rajen a pixamex cu bin tu yac'birir. ");
INSERT INTO lacNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Rajen qui' cʌnantex a bʌj soc mʌ' ja ruc'siquex in t'ʌn ich a pixamex quire' wa ca mʌ'quintic in t'ʌn cu bin yac'birchʌjʌr a pixamex. ");
INSERT INTO lacNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Quire' wa ti' yʌn in t'ʌn ta pixamex wa mʌ' a c'ʌs ruc'siquex in t'ʌn ta pixamex cu bin u qui' yamtic techex soc a manex tu tsoyir. Mʌna' yac'birir ta pixamex. Aro' an ten bic cu yerc'ac'tic tech quib. ");
INSERT INTO lacNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Caj ts'oc u tsicbar Jesús a ba' caj u camsaj sam. Caj tari' turi' a fariseojo' caj payij quir u janʌn ich yatoch. Caj binij Jesús caj oquij caj curʌj tu pojche'ir tu cu janʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Rajen jaq'uij yor a fariseojo' quire' mʌ' tu p'o'aj u c'ʌb Jesús, mʌ' toy janʌqui'. Mʌ' ja wirej, u winiquirob judío a fariseojo' nanij u p'o'ic u c'ʌb mʌ' toy janʌqui'. Quire' cu tucricob baxuc cu qui'quinticob yor C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesús yer jac'a'an yor a fariseojo', rajen caj u ya'araj ti': ―A techexo' u winiquirechex judío a fariseojo', irechex ruch a ca p'o'iquex u pach chen tu japnin mʌ' a p'o'iquex. A techexo' u winiquirechex judío a fariseojo' irechex u rʌquir a woch a ta qui' p'o'ajex tu pach chen u japnin mʌ' ta p'ojechexi', rajen ti' toy eq'ui'. A techex irex u ruchir a wochex chen p'o'a'an u pach, quire' ca qui' p'o'ic a c'ʌb soc mac yiric jach tsoyechex chen mʌ' a tucric wa p'o'a'an a pixamex. Jach ec' a pixamex quire' tu cotor a si'pirex. ");
INSERT INTO lacNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mʌ' ja wirej, C'uj caj u betaj ic winiquir baxuc ic pixam, rajen mʌ' u chen c'at ca' ichinʌco'on ij winiquir, u c'at xan toc tsoy ic pixam xan. ");
INSERT INTO lacNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Soc yʌn techex jach tsoy a pixamex chuquex a ba' yʌn techex ti' a mac a mʌna' ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Jach otsirechex u winiquirechex judío a fariseojo' caj a chuquiquex turiri' a ba' yʌn techex ich a diezo' soc a ts'iquex ti' C'uj. Cax a ba' pʌc'ar quir a ts'ʌquic a bʌj, cax a ba' a ts'ac a woch, a turiri' ich a diezo'. Jot, cax mʌ' a ts'iquex ti', quire' mʌ' tan a yajquintic mac, mʌ' ca yajquintex C'uj. Ba' quiri' jach manan tsoyir ca' a yajquintex mac. Baxuc aro' ca' a yajquintiquex C'uj. Chen mʌ' a yʌn p'ʌtiquex a ts'iquex ti' C'uj a ba' nani ca ts'iquex ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Jach otirechex u winiquirechex judío a fariseojo'. A c'at ca' u yiriquechexob jach no'jechex. Rajen a c'atex u cutan jach tsoy ich tu cu naj c'ujinticob C'uj u winiquirob judío. Baxuc a c'atex soc mac cu qui' t'ʌniquex tu cu najmʌnicob yoch. ");
INSERT INTO lacNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’A techexo', jach otsirechex u winiquirechex judío a fariseojo'. A techexo', u winiquirechex judío a fariseojo' irechex u mucnaj mac tu cu najmuquic mac, chen mʌna' u mucnaj, mʌ' chʌca'an. Rajen a mac a cu man tan u ch'ʌctic quire' mʌ' yer wa muca'an mac ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ti' yʌn turi' yʌjcamsʌyʌjir u t'ʌn Moisés caj u nuncaj caj ya'araj: ―Cax ca wa'aric ti'ob u winiquirob judío a fariseojo' tan a p'astiquenob quire' p'eri'enob yejer u winiquirob judío a fariseojo'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Caj ya'araj Jesús ti' yʌjcamsʌyʌjir u t'ʌn Moisés: ―A techexo', jach otsirechex yʌjcamsʌyʌjirechex u t'ʌn Moisés. Mʌ' ja wirej, ca ts'ʌric u pach a rac'ob u betic a ba' jach yaj quire' ca jenmastic u t'ʌn Moisés. Aro' irej a mac cu ts'ʌric u pach ca' u cuchej a ba' jach ar, chen u bʌjiri' mʌ' u yamtic u cuchej. Mʌ' ju c'at u cuchej. ");
INSERT INTO lacNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Otsirechex yʌjcamsʌyʌjirechex u t'ʌn Moisés, ca ts'ʌpquintiquex tunich tu mucnaj yʌjtsequirob u t'ʌn C'uj soc tsoy yiric tu cotor mac. Ra'iri' yʌjtseq'uirob u t'ʌn C'uj a quinsa'b ten a nunquirex uch. ");
INSERT INTO lacNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Cax ca ts'ʌpquintiquex tunich tu mucnaj soc a sʌjtiquex yʌjtseq'uirob u t'ʌn C'uj. Jach irex a nunquirex a mac tu quinsajob yʌjtseq'uirob u t'ʌn C'uj quire' ich a tucurex a c'at a quinsenex. ");
INSERT INTO lacNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Rajen C'uj a yer tu cotor ba' caj ya'araj: “Quin tuchi'tic yʌjtseq'uirob u t'ʌn C'uj tu yʌnechex, yʌn jun yar cu bin u quinsicob, yʌn jun yar cu bin ts'abʌr u muc'yajob”, baxuc caj ya'araj C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jach taj caj a betajex an ten bic caj u ya'araj C'uj. Rajen ca bin a bo'otiquex u bo'orir tu ta quinsajobex, cax tu yʌnxchun tu cotor ba'. ");
INSERT INTO lacNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Quire' tu yʌnxchun u quinsicob Abel a ucho' hasta u q'uinin baje'rer caj u quinsajob Zacarías. Ti' caj u quinsajob Zacarías nʌts'a'an tu cu quinsicob wacʌx quir u ts'ic ti' C'uj baxuc c'ʌs nʌts'a'an carem naj. Je' a rʌc bin a bo'otiquex u bo'orir tu rʌc quinsa'b yʌjtseq'uirob u t'ʌn C'uj. Ti' techex a mac cuxa'an u q'uinin baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Caj ya'araj Jesús ti' yʌjcamsʌyʌjirob u t'ʌn Moisés: ―Otsirechex techex ―quij Jesús―, ya'ab ca najtiquex ti' u t'ʌn Moisés. Ca camsic ti'ob xan, chen mʌ' a qui' camsej a ba' jach taje'. Mʌ' ja quibiquex a ba' ti' yʌn ich u t'ʌn Moisés. A mac a ju c'at u quibej mʌ' a cha'ic u quibic. ");
INSERT INTO lacNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Caj ts'oc u t'ʌn Jesús yejerob a fariseojo' yejerob yʌjcamsʌyʌjirob u t'ʌn Moisés, caj bin Jesús, jach ts'icob u winiquirob judío a fariseojo' yejer yʌjcamsayʌjirob u t'ʌn Moisés robob u c'at na'sicob yor quinsac Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mʌ' ja wirej, caj u ch'uctajob yubejob ba' cu yac Jesús soc u binob u ta'quicob u jo'r Jesús quire' a ba' c'as caj u ya'araj. ");
INSERT INTO lacNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ti' toy cu tsicbar Jesús yejer u winiquirob judío a fariseojo' yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Quire' caj u much'quintob u bʌj u winiquirob judío. Jach ti' yʌn miles quire' tan u yach'ʌticob u bʌj. Jesús caj u yʌnxchun ya'aric ti' u camsʌwinicob quire' u c'at u yʌn tsicbar yejer u camsʌwinicob. Rajen caj ya'araj ti'ob: ―Qui' cʌnantej a bʌjex ti' u winiquirob judío a fariseojo' soc mʌ' u tusaricob techex ba'. Soc mʌ' a cʌnicobex quire' a ba' cu tus aric u winiquirob judío a fariseojo', irej u ts'ac yo'och pan cu sip. ");
INSERT INTO lacNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Rajen, mʌ' ja cʌnicobex quire' tu cotor ba' cu mucricob mac je' u bin irbir ten mac. Quire' a ba' cu tucric mac, mʌna' mac yer, chen je' u yerticobe'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rajen tu cotor ba' ca mucu'ariquex ya'ab mac cu bin yubic. Quire' a wa ba' ca chan ber ariquex ich a watochex ta junanex ya'ab mac cu bin yertic. ");
INSERT INTO lacNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Caj ya'araj Jesús: ―Quin wac techex a mac in jach yaj, mʌ' a ch'iquex sajaquir ti' a mac a cu bin u quinsiquechex. Quire' ca' bin ts'ocac u quinsiquechex quire' mʌ' c'ucha'an yor ba' quir u betic techex. ");
INSERT INTO lacNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","A teno' ―quij Jesús―, quin chen bin in wa'aric techex mac yʌn a jach sʌjtiquex. Ca' a ch'iquex sajaquir ti' C'uj quire' ca' bin ts'ocac u taquic a cuxtarex c'ucha'an yor u puriquechex ich c'ac'. Jach jaj ra' a jach sʌjtex. ");
INSERT INTO lacNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Caj ya'araj Jesús: ―Tu cotor mac yer cu conan cinco chan ch'ich' ti' ca'tur chan majan taq'uin. Quire' cu yiric mʌ' coji'. Chen a chan ch'ich'o' mʌ' u tubur ti' C'uj, cax turiri'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Rajen mʌ' a ch'iquex sajaquir quire' jach cojechex a techexo'. Mʌ' necoj, jach ya'ab a chan ch'ich'o'. Mʌ' ja wirej, mun C'uj cu jach yajquintic techex cax yer mun yʌn u tsotser a jo'rex. ");
INSERT INTO lacNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Caj ya'araj Jesús: ―A teno' quin wac techex a wa mac caj u toc araj caj u yacsaj tu yor ti' u rac'ob. Baxuc a teno' baxuquenechexo'. Quin bin in wa'aric ti' yʌjmasirob u t'ʌn C'uj: Aro' caj u yacsaj tu yor ten. ");
INSERT INTO lacNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A wa mac mʌ' u c'at ya'aric wa caj u yacsaj tu yor ti' u rac'ob, baxuc a teno' quin bin in wac ti' yʌjmasirob u t'ʌn C'uj: Aro' mʌ' u c'at ya'aric wa caj u yacsaj tu yor uch. ");
INSERT INTO lacNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’A wa mac a cu p'astic ten a tu tuchi'ten C'uj wa cu c'axic yor, je' u jawsa'r ten C'uj. Chen a wa mac a cu p'astic u Taj'or u Pixam C'uj, mʌ' ju bin jawsa'bir u si'pir ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cax cu bin u puriquechex ʌcʌtan u ts'urir tu cu naj c'ujinticob C'uj u winiquirob judío. Cax ich gobernador cax ich presidente quire' caj a wacsex ta wor ten. Mʌ' ja chen tucriquex bic tabar ca bin a nunquiquex ti'. Mʌ' ja tucriquex a ba' ca bin waquex ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","A ray u q'uinino' u Taj'or u Pixam C'uj, je' u yac techex ba' yʌn a waquex ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Turi' mac ich a pimo' caj u puraj u t'ʌn ti' Jesús, caj ya'araj: ―In wʌjcamsʌyʌjirech, chan arej ti' in sucu'un ca' u chʌc jʌse ten u ba'tac in tetob a caj u p'ʌtʌtenob caj quimin in tetob. ");
INSERT INTO lacNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Caj u nunca Jesús caj ya'araj: ―Arej ten mac caj u tetajen ca' in wa'arej bic tabar a jʌsiquex u ba'tac a tetex? Rajen mʌ' in wac techi'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Rajen Jesús caj u ya'araj ti' a pimo': ―Qui' cʌnantex a bʌj soc mʌ' a yajquintiquex a taq'uinex, bayiri' ti' a ba'taquex xan. Mʌ' ja wirej, cax a mac neyʌn u taq'uin yejer u ba'tac, aro' mʌ' u ya'aric wa je' u cuxtar ya'ab q'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Soc u cʌnicob a ba' caj u camsaj sam, rajen caj u ya'araj a je'ra': ―A ucho' ti' yʌn mac jach neya'ab u taq'uin quire' u ru'um caj u nets'ajaj u wich u pʌc'ar. ");
INSERT INTO lacNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A xibo' a mac jach neya'ab u taq'uin caj u tucraj ich yor caj ya'araj: “Ba' quin bin in betej baje'rer quire' mʌ' tu quin wacsic in ts'ʌpquin tin wo'och quire' jach ya'ab ten?” ");
INSERT INTO lacNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Caj ts'oc u tucric a ba' cu bin u betic caj ya'araj: “In wer ba' quin bin in betic. Je' in rʌc pa'ic tu quin wacsic u canche'ir in woch ca' in jach cochquintej u jer soc jach carem. Soc ti' quin bin in wacsic in woch yejer a ba' yʌn ten.” ");
INSERT INTO lacNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A mac jach neya'ab u taq'uin caj u tucraj tu yor, tan ya'aric ti' u wʌc'ʌs bʌjiri': “Toc yʌn ba' a c'at ti' ya'ab yaxq'uin. Tsire'ej a beyaj chen jes a bʌj janen uc'urnen xan manen soc qui' a wor.” ");
INSERT INTO lacNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mʌ' toy ts'ocac u t'ʌn caj ara'b ten C'uj: “Jach chich a jo'r, a je' ac'bira' c'uchij tu q'uinin a quimin. Tu cotor a ba' a caj a ric'saj mac cu bin u ch'ic?” ");
INSERT INTO lacNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Baxuc u bin u betic tu cotor mac a cu tucric u nono'j bʌjiri' yejer u ba'tac a mun u q'uinin cuxa'an ich yoc'ocab. Chen mʌ' tu betaj a ba' cu bin u qui'quintic yor C'uj. Chen ʌcʌtan tu wich C'uj jach otsir. ");
INSERT INTO lacNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Caj ts'oc u camsic Jesús a pimo' caj u ya'araj ti' u camsʌwinicob: ―Rajen quin wac tech: Mʌ' ja yʌn tucriquex ba' ca bin a jantex quir a cuxtarex. Mʌ' ja yʌn tucriquex a ba' ca bin a buquintex. ");
INSERT INTO lacNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mʌ' ja wirej, jach no'j a cuxtarex chen a wochex mʌ' no'ji'. Baxuc xan, jach no'j a winquirirex chen a noq'uex mʌ' no'ji'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Qui' tucrex a ba' quin bin in wac techex. A c'awojo', mʌ' ju pʌq'uic ba' mʌ' ju jaq'uic yo'och, mʌ' c'ucha'an yor u ric'sic yoch ich c'anche' soc ca' bin c'uchur tu q'uinin yʌn yoch. Chen mʌ' ju wichʌjʌr quire' C'uj cu jansic. Mʌ' wa jach manan cojechex a ch'ich'o', mʌ' necoji'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Caj ya'araj Jesús: ―Cax ya'ab ca tucriquex u sats'ʌr a baquerex, mʌ' ju sats'ʌr a baquerex, mʌ' chichin. ");
INSERT INTO lacNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","A werechex mʌ' c'ucha'an a worex a sʌts'iquex a baquerex quire' mʌ' neno'j aro'. Rajen mʌ' ba'wir ca jach tucriquex a ba' ca bin a jantex, a ba' ca bin a wuq'uex, a ba' ca bin a buquintiquex. ");
INSERT INTO lacNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Qui' tucriquex a ba' quin bin in wac techex. Caj a wirajex bic tabar u ch'ijir u top' chʌcmʌnche' a jach tsoy u top'. Ca wiric wa cu beyaj, mʌ' ju c'uch. A teno' quin wac techex. A rey Salomóno', u buquimʌn u noc' uch, jach tsoy chen mʌ' jach quet tsoyir yejer chʌcmʌn che', cax rey. ");
INSERT INTO lacNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A C'ujo' cu ch'isic u top'che' a ti' yʌn ich c'ax soc tsoy u top', chen tabar u ts'u'ts'ur u top'. Cu c'uchur mac cu maric quir u toquic ich c'ac'. Wa baxuc a C'ujo' cu cʌnantic u top'che'. Baxuc a C'ujo' cu cʌnantic techex, cax ca tucriquex mʌ' u cʌnantiquechex. ");
INSERT INTO lacNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Quire' a mac yer cʌnanta'an ten C'uj, mʌ' u yʌn tucric a ba' cu bin u jantej. Baxuc a ba' cu bin yuq'uej. Baxuc mʌ' u yʌn xaca'an tucur. ");
INSERT INTO lacNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chen a mac a mʌ' yerob C'uj cu tus tucricob aro' quire' xaca'an u tucricob ba' cu bin u jantejob. Baxuc a ba' cu bin u yuc'urob chen ic Tet C'uj, jach yer a ba' a c'atex. ");
INSERT INTO lacNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Barej c'ajtex a ba' jach no'j tu cu bin u reyintic C'uj. Wa ca yʌn cʌxtiquex aro', tu cotor a ba' a c'atex, je' u ts'ic techex C'uj. Cax a noc', cax a woch, cax a wuc'ur. ");
INSERT INTO lacNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesús caj u ya'araj ti' u camsʌwinicob: ―Mʌ' ja ch'iquex sajaquir quire' cax mʌ' pimechex. Mʌ' ja wirej, jach tsoy caj u tucraj C'uj u yacsiquechex a reyintex tu cu reyintej C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Cʌnex a ba'taquex soc yʌn techex ca' a ts'ic ti' a mac otsirchʌjij. Wa baxuc ca betiquex, aro' irej tan a ric'siquex a ba' jach co'oj soc yʌn techex ich ca'anan. A ti taro' mʌ' u xupur quire' munt q'uin ti' yʌno'. Quire' ti taro' mʌna' mac cu yocar u muc u ac'ric. Baxuc a taro' mʌ' ju jantic c'ʌmʌs. ");
INSERT INTO lacNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mʌ' ja wirej, a tu yʌn a ric'smʌnex jach co'oj ti' ca pachiquex a bin xan. ");
INSERT INTO lacNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús caj ya'araj ti' u camsʌwinicob bic tabar u q'uinin ca' bin uruc: ―Toc pajenex ca' bin urquen ―quij Jesús―, an ten bic mac cu cʌnanticob yatoch u ts'urir quire'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bin u ts'urir, bin yiric u ch'ic u rac' mac. U winiquirob a ts'uro' u toc buquimʌnob u noc'. Toc t'ʌba'an u quib ca' bin c'uchuc t'ʌnbir. Seb cu q'ueyic u jor soc u yacsicob ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Qui' yor a mac a cu toc pajicob u tar u jach ts'urirob ca' bin uruc. Wa tu pajicob ca' bin uruc a ray u quinino', quin bin in wa'aric ti'ob ca' curacob tu janʌnob. Quin ts'abʌc ti'ob quir u janʌnob. ");
INSERT INTO lacNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Techex jach qui' a worex wa tan a toc pajiquenex ca' bin urquen. Cax chumuc ac'bir. Ca' bin urquen, cax wa tan u sastar ca' bin urquen. ");
INSERT INTO lacNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Uyex ba' quin waquex tech. Jaj ixtʌcoj wa ra' u winquirir yatoch yer ixtʌcoj u q'uinin u tar yʌjac'rayʌjir ba'tac caj u toc pajaj ca'ch soc mʌ' u cha'ic yocar u yac'ric. ");
INSERT INTO lacNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Baxuc techex ca' a toc pajiquex quire' wa ra' u q'uinin quin wu'ur mʌ' tan a tucriquex in wu'ur. A teno' a mac tuchi'ta'b ten C'uj baxuquenechexo'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Caj ya'araj Pedro: ―Wa chen ti' tenob caj a wa'araj sam wa ti' tu cotor mac xan. ");
INSERT INTO lacNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Caj ya'araj Jesús: ―Ca' a cʌnex u ca' ts'urir a mac jach t'aj, a cu quib u t'ʌn u Jach Ts'urir ts'a'b u cʌnantej a mac ti' yʌn tu yatoch. Tan u ts'ic ti'ob u janʌnob ca' bin c'uchuc tu q'uinin u janʌnob u winiquirob u Jach Ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Rajen u ca' ts'urir qui' yor quire' irir ten u Jach Ts'urir tu qui' quibaj u t'ʌn caj ur tu yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Caj ya'araj Jesús: ―Jach taj quin wa'aric techex. Je' u ts'abʌr u cʌnantej tu cotor ba' a ti' yʌn ich yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Chen wa ju ca' ts'urir cu tucric tu yor tan ya'aric: “In jach ts'urir ama'an cu c'uch, tin t'ʌn.” Rajen tu yʌnxchun u jʌts'icob u winiquirob cax xib cax xquic. Tan u nejanʌn tan u ne'uc'ur xan, tan u carchʌj xan. ");
INSERT INTO lacNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","U jach ts'urir je' u yu'ur tu q'uinin mʌ' tan u pajic u ca' ts'urir quire' mʌ' tu ya'araj ti' ber ca' bin uruc. Cu bin ts'abʌr u muc'yaj ten u jach ts'urir. Quet cu bin u muc'yaj yejer a mac a mʌ' yerob C'uj quire' mʌ' tu betaj a ba' u c'at u jach ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Caj ya'araj Jesús: ―Chen a winico' a yer a ba' u c'at u jach ts'urir chen mʌ' tu quibaj a ba' ara'b ti'. Rajen ca' bin uruc u jach ts'urir ara' u q'uinin mʌ' tan u pajic. Je' u bin ts'abʌr u muc'yaj. Jach yaj cu bin muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Chen a winico', quire' caj u betaj ba', rajen bin u jats'ʌr u pach ten u jach ts'urir cax mʌ' yer a ba' u c'at u jach ts'urir ca'ch. Barej mʌ' neyaj cu bin jʌts'bir u pach ten u jach ts'urir. Ca' bin u ts'abʌr u beyaj ten u jach ts'urir ti' u c'urew yʌn u toc rʌc betic. Cax mʌ' ya'ab u beyaj yʌn u rʌc ts'ocsic. Cax ya'ab u beyaj u ts'abʌr ti' ten u ts'urir cu pajic u ts'ocsic ti' cax ya'ab ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Caj ya'araj Jesús: ―Quire' taren a teno' ich yoc'ocab cu bin u p'ujur yor mac aro' irej c'ac'. An bic in c'at toc ts'aca'an in beyaj ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Chen yʌn in muc'yaj ―quij Jesús―, baxuc yʌn in quimin soc toy ts'aca'an in beyaj. Bic jach yaj in wor hasta ca' bin yʌnxchunuc in muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Quire' taren ―quij Jesús―, ca bin a tucrex a mac ti' yʌn ich yoc'ocab mʌ' u bin u ts'ictarob. Chen a teno' quin wac techex mʌ' u bin sistar yor yejer u rac'ob mac cu bin u rʌc pacran ts'ictarob. ");
INSERT INTO lacNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cu yʌnxchun baje'rer hasta cu xur t'ʌn wa ti' yʌn cinco winic ich yatoch u tet. A mʌna' u nupo' cu bin u ts'ictarob yejer a ca'turo'. A ca'turo' cu bin u ts'ictarob yejer a mʌna' u nupo'. ");
INSERT INTO lacNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","U tet cu ts'ictar yejer u parar xan. U parar cu ts'ictar yejer u tet xan. U nʌ' cu ts'ictar yejer xquic u parar. A xquico' u parar cu ts'ictar yejer u nʌ'. Yixquit cu ts'ictar yejer yixquit. Cu pacran ts'ictar yejer yixquit. ");
INSERT INTO lacNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús caj ya'araj ti' a pimo': ―Ca wiriquex u nacar u muyarir tu cu bin q'uin ca waquex je' u tar ya'rire'. Jach jaj cu tar ya'rir. ");
INSERT INTO lacNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wa cu tar yic'ar ich nojar ca waquex bin u ca' chʌcʌrchʌjʌr q'uin. Jach taj cu chʌcʌchʌjʌr q'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ca chen tusariquex ca' bin a wirex biquira' a ca'anano'. Baxuc a ru'umo' a werex wa cu tar ja' wa cu bin chʌcʌwchʌjʌr. Biquinin mʌ' a werex ba' u c'at ya'arej a ba' quin betic baje'rer? ");
INSERT INTO lacNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Caj ya'araj Jesús: ―Biquinin mʌ' a bʌjiri'ex ca tucriquex ta worex a ba' ca bin a betiquex? ");
INSERT INTO lacNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Caj ya'araj ti' u camsʌwinicob: ―Wa yʌn mac cu bin u puriquech ʌcʌtan ich juez quir yiric wa yʌn a bo'or ti'. Joq'uen sisquintej yor soc mʌ' u bin u puriquech ich juez. Wa mʌ' a bin a sisquintej yor, je' u bin u puriquech ich juez. Caj ts'oc yiric yʌn a si'pir cu bin u c'ubiquech tu cu ma'cʌr winic. ");
INSERT INTO lacNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A teno' ―quij Jesús―, quin wac tech: Mʌ' u bin u cha'ic tech hasta ca rʌc bo'otic a bo'or. ");
INSERT INTO lacNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ra'iri' u q'uinin ti' yʌn mac ich Jesús. Mʌ' ja wirej, tarob u toc arob ti' Jesús a ba' u ber ti' u winiquirob judío a cu tarob ich u ru'umin Galilea. Quire' quinsa'b ten u soldado, Pilato, tu cu quinsicob wacʌx quir u ts'ic ti' C'uj. Quire' ara'b ten Pilato. ");
INSERT INTO lacNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús caj u nuncaj ti'ob, caj ya'araj: ―Ca tucriquex wa jach c'asob a cu tarob ich u ru'umin Galilea? Rajen quinsa'b tu cu naj c'ujinticob C'uj. Barej u rac'ob a cu tarob ich u ru'umin Galilea mʌ' nec'asi'. ");
INSERT INTO lacNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Rajen quin wac techex ―quij Jesús―, mʌ' taj a ba' ca waquex. Baxuc techex wa mʌ' tan a c'axiquex a worex caj a p'ʌtex a c'aso' je' a rʌc quiminex xan, irej ti'ob ca' quinsa'b. ");
INSERT INTO lacNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","C'aj wa techex a mac pets'ta'b ten u tunichir tu ts'ʌpa'an? Bʌytʌc tu yʌn u ts'ʌpa'an tunich ca'anan u c'aba' Siloé soc nach cu yiric. Caj pets'ta'bob dieciocho. Arex ten wa jach c'asob rajen pets'ta'b chen a mac ich u cajar Jerusalén mʌ' nec'asobi'? ");
INSERT INTO lacNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Rajen quin wac techex ―quij Jesús―, mʌ' taj a ba' ca waquex. Baxuc techex wa mʌ' tan a c'axiquex a worex ca' a p'ʌtex a c'aso'. Je' a rʌc quiminex xan, irej caj pets'abob. ");
INSERT INTO lacNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús caj u camsaj baxuc a je' t'ʌna' soc tabar u c'axicob u yorob. Rajen caj ya'araj: ―Ti' yʌn u pʌc'ar higuera ich corir u yaq'uir uva mac. Caj bin yiric wa yʌn u wich. Mʌ' tu yira u wich. ");
INSERT INTO lacNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Rajen ―quij Jesús―, caj ara'b ten a mac yʌnin u cor ti' a mac a cu cʌnantic u cor: “Yʌn tres yaxq'uin, rajra' quin tar in wiric wa yʌn u wich higuera. Chen mʌ' in wiric u wich. Toc ch'ʌquej u che'er, ba'wir cu c'ʌnic u ru'umin?” ");
INSERT INTO lacNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Caj ara'b ten a mac a cu cʌnantic u cor: “Tsire'ej, Jach Ts'urir ―quij―, soc in juptic u ru'umin chen a je' yaxq'uina' quin bin in purej u ta' tsimin soc u ne'ichancʌr. ");
INSERT INTO lacNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jaj ixtʌcoj, je' u wichancʌr ca' bin tac tu q'uinin u wichʌncʌr. Jach Ts'urir, wa mʌ' u wichancʌr, arej in ch'ʌquej.” ");
INSERT INTO lacNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","U q'uinin u jesicob u bʌj u winiquirob judío, Jesús caj u camsaj u winiquirob judío tu cu naj c'ujinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ti' yʌn tu cu naj c'ujinticob C'uj uch xquic, a p'ux u bin, yʌn dieciocho yaxq'uin caj u cʌnaj u yajir. Quire' aca'an c'ac'as quisin ti', rajen mʌ' u tajtar u pach. ");
INSERT INTO lacNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Rajen Jesús caj yiraj caj u t'ʌna caj ya'araj ti': ―Xquic ―quen―, toc jaw a yajir. ");
INSERT INTO lacNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Caj u ts'anc'ʌbtaj seb caj tajij xquic a p'ux u bin cuch. Caj u yʌnxchun ya'aric ti' C'uj: ―Bayo' C'uj ―quij―, caj a jawsajen. ");
INSERT INTO lacNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chen u jach ts'urir tu cu naj c'ujinticob C'uj u winiquirob judío caj ts'iquij quire' yiraj u jawsic Jesús xquic u q'uinin cu jesicob u bʌj u winiquirob judío. Rajen caj ya'araj ti' a mac ti' yʌnob. Yʌn seis u q'uinin quir a beyajex techex. A seis u q'uinino' tsoy a tarex quir a jawsic a yajirex, chen mʌ' ra' u q'uinin baje'ra'. ");
INSERT INTO lacNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Caj u nuncaj Jesús caj ya'araj ti': ―Ca' yarir a wac' a techexo' ca tus ets'iquex a c'ujintiquex C'uj. Mʌ' wa ti' yʌn mac a tera' a mʌ' ju siptic yʌrʌc' wacʌx yejer yʌrʌc' tsimin tu cu jansic quir u ts'ic u yuc'ur cax ra' u q'uinin caj u jesob u bʌj u winiquirob judío? Jach taj ca siptiquex ti' quir a ts'ic yo'och ja'. ");
INSERT INTO lacNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Irex a je' xquica', u parar u ca' parar Abraham uch. Yʌn dieciocho yaxq'uin caj yajij quire' quisin. Jach jaj yʌn u bin sipta'bir u yajirir cax tu q'uinin caj u jesob u bʌj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mʌ' toy ts'ocac Jesús u tsicbar ti'ob tu cu naj c'ujinticob C'uj a mac tu pʌc'ob u pach Jesús caj u ch'ajob suraquir. Chen u jerob u rac'ob caj qui'jij yorob quire' yirob carem u beyajob Jesús a caj u betaj ti' a xquico'. ");
INSERT INTO lacNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús caj ya'araj: ―Bin in ca' in camsic techex soc a werex cu bin u reyintic C'uj soc a p'erquintiquex. ");
INSERT INTO lacNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aro' irej u yijir mostaza jach mijin. Barej cu ch'ic u pʌq'uic ich u chan cor. Cu ch'ijire' cu majan xit'ir u c'ʌbir. A ch'ich'o' cu tar u c'ʌxic u c'u' ich u c'ʌbir. ");
INSERT INTO lacNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ti' toy cu tsicbar Jesús caj u ca' a'araj: ―Bin in ca' in p'eri'quintic u ru'umin tu cu bin u reyintej C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","An bic ten cu sip' yoch pan wa cu puric ts'ac. Mʌna' u nup u puric u tenin u ts'ac ich harina cu ts'ocar u puric u ts'ac cu rʌc sip' tu cotor. ");
INSERT INTO lacNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ti' toy cu bin Jesús ich u berir Jerusalén. Ti' cu man ich u chan cajar baxuc ich u yajaw cajar a ti' yʌn ich bej. Ti' cu camsic mac ti taro'. ");
INSERT INTO lacNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yʌn mac tu c'ataj ti': ―Jaj Ts'urir ―quij―, arej ten wa ya'ab cu bin tacbir ten C'uj wa mʌ' ya'ab cu bin tacbir? Jesús caj ya'araj ti' a pimo': ―Mun cu bin tacbir? ");
INSERT INTO lacNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jach p'isex a bʌjex quir a wocarex tu cu bin u reyinticob C'uj cax yaj tu ca wocarex. Qui' tucriquex quire' mʌ' ya'ab cu bin yocar ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mʌ' ja wirej ―quij Jesús―, je' u c'uchur tu q'uinin a mac yʌnin yatoch cu bin u c'ʌric u jor. Ca' bin taquechex ich tancab ca' bin a yʌn t'ʌniquex: “Q'ueyej in jo'rob, Jaj Ts'urir, quir in wocarob.” Chen a ti'o' cu bin u nunquic: “Mʌ' in wer maquechex, mʌ' in wer tub a tarex.” ");
INSERT INTO lacNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ra'iri' u q'uinin ca bin a yʌnxchun a wa'ariquex: “P'eri' ic janʌn uch, p'eri' ij cuc'ur xan uch. Baxuc caj a camsajenob tu berir uch tu cʌja'anenob.” ");
INSERT INTO lacNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A Jaj Ts'uro' ca' bin u nunquej: “Caj in wa'araj ca'ch mʌ' in wer tub a tarex. Ca' xiquechex tu cotorex quire' nanex a manex ta c'asirex.” ");
INSERT INTO lacNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ca' bin a wac'tiquex a bʌj ca' bin a jʌch'iquex a coj quire' ts'iquechex quire' caj a wiraj mʌ' u yacsiquechex. Quire' caj a wiraj u yacsa'rob Abraham yejer Isaac yejer Jacob yejer tu cotor yʌjtseq'uirob u t'ʌn C'uj. Chen tancab p'atechex tu cu yocarob u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","A winico' tar cu bin tarob tu cu tar q'uin. Baxuc cu bin tarob tu cu bin ic yum. Baxuc cu bin tarob xʌman ca'anan. Baxuc cu bin tarob ich nojar. Ti' cu rʌc binob ich ca'anan tu cu bin u reyinticob C'uj. Ti' cu bin cutarob u janʌnob. ");
INSERT INTO lacNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","U'yex ba' quin wac, yʌn mac a tera' mʌ' no'ji' chen ca' bin c'uchuc tu q'uinin tu cu bin u reyinticob C'uj jach no'j. Yʌn mac a tera' jach no'j baje'ra' ca' bin c'uchuc tu q'uinin tu cu reyintic C'uj. Mʌ' no'ji'. ");
INSERT INTO lacNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesús caj ts'oc u camsicob a ba' caj u ya'araj sam. Caj c'uchij mʌ' ya'ab u winiquirob judío a fariseojo'. Caj ya'arob ti': ―Ca' xiquech quire' Herodes u c'at u quinsiquech. ");
INSERT INTO lacNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús caj ya'araj ti'ob: ―A Herodeso', raji' cu tusaric mac. Joq'uenex a wa'ariquex ti': “Chen te' yʌnena', mʌ' ya'ab u q'uinin soc in yʌn joc'sic a mac aca'an c'ac'as quisin ti'. Soc in yʌn jawsic u yajir mac xan. Tabar in ts'ocsic in beyaj a tera'.” ");
INSERT INTO lacNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Arex ―quij Jesús―, ti' Herodes a ba' quin betic baje'ra'. Baxuc xan in betic saman. Baxuc yʌn in betic ca'bej xan hasta quin c'uchur ich u cajar Jerusalén. Quire' ich u cajar Jerusalén tiri' cu quinsicob yʌjtseq'uirob u t'ʌn C'uj, mʌ' a tera' ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Caj ya'araj Jesús: ―A techexo' ti' cʌja'anechex ich u cajar Jerusalén. Ca quinsiquex yʌjtseq'uirob u t'ʌn C'uj uch. Ca rʌc ch'iniquex u jo'rob a mac tuchi'ta'b ten C'uj ti' techex. Ya'ab u tenin in c'at in much'quintic techex an ten bic cax cu juquintic yar soc u cʌnantic. Chen techex mʌ' ja c'atex in much'quintiquechex baxuc aro'. ");
INSERT INTO lacNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","U'yex ba' quin wac techex. Caj in toc p'ʌtechex ta junanex. Quin wac techex mʌ' a bin a wiriquenex hasta cu c'uchur tu q'uinin a ray u q'uinino' ca waquex: “Ca' ij c'ujintej a je' xiba' a cu tar quire' tuchi'ta'b ten C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Caj c'uchij tu q'uinin caj bin tu janʌn Jesús ich yatoch u ts'urir u winiquirob judío a fariseojo' quire' pʌybir. Ray u q'uinin u jesicob u bʌj u winiquirob judío. A ju yet janʌnob tan u ch'ucticob a ba' cu bin u betej Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ti' yʌn xib xan tu yʌn Jesús. A yʌn u yajir chup u bʌq'uer. ");
INSERT INTO lacNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús caj ya'araj ti'ob a fariseojo' yejer yʌjcamsayʌjirob u t'ʌn Moisés a ju yet janʌnob, caj ya'araj ti'ob: ―Ba' cu ya'aric tu ts'iba'an u t'ʌn Moisés? Cu cha'ic wa jic jawsic u yajir mac wa mʌ' u cha'ic ic jawsic mac u q'uinin quir a jesiquex a bʌjex? ");
INSERT INTO lacNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mʌna' mac caj u nuncaj a ba' c'ata'b ti'ob. Rajen Jesús caj u mʌchaj u c'ʌb caj u jawsaj u yajir. Caj ts'oc u jaware' caj u cha' u bin a mac jawsa'b. ");
INSERT INTO lacNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesús caj ya'araj ti'ob a mac rʌc ti' yʌnob ich yatoch u ts'urir a fariseojo': ―Wa yʌn techex a wʌrʌc' chan tsimin cax a wʌrʌc' wacʌx ton, wa pitc'ʌjij caj but' ich u jorir ru'um ich yic' ja', mʌ' wa seb ca jariquex cax u q'uinin a jesiquex a bʌjex? ");
INSERT INTO lacNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mʌ' c'ucha'an yor u nunquicob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús caj yiraj bic cu teticob u cutanob a payob tu janʌnob. U c'at u cutarob soc jach no'j tu cura'anob. Rajen Jesús caj ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Wa ju pʌyiquechex mac quir a janʌnex tu cu bin u ch'ic u rac'. Mʌ' ja yʌn cutarex tu cu cutar a mac jach no'j. Quire' wa ti' ca cutarex jaj ixtʌcoj wa cu tar a mac jach no'jo' quire' techex mʌ' jach no'jechexi'. ");
INSERT INTO lacNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wa ti' cura'anech cu bin tar yac tech a mac tu pay a janʌn: “Chan joq'uen a techo' ―quij― ca' xiquech ti' taro' soc in wacsic a je' xiba' tera' ta cutan.” Rajen ―quij Jesús―, ca' bin a ch'ic suraquir tu ca bin a cutar tu mʌ' no'j a cutan. ");
INSERT INTO lacNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chen wa cu payiquechex mac quir a janʌnex tu cu bin u ch'ic u rac'. Tar a cutarex tu cura'an a mac mʌ' no'jo' soc wa cu tar a mac tu pʌyechex cu bin yac techex: “In jach yajech ―quij―, cojen a cutar tu jach no'j.” Ra'iri' u q'uinin cu bin sʌjta'birechex ten a mac cura'anob janʌnob yejerech. ");
INSERT INTO lacNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mʌ' ja wirej ―quij Jesús―, a mac a cu tucric: Jach no'jen, a C'ujo' cu bin yiric mʌ' no'ji'. A mac a cu tucric: Mʌ' no'jen a teno', a C'ujo' cu bin yiric jach no'j. ");
INSERT INTO lacNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús ti' toy cu tsicbar ti' a mac caj u pʌy tu janʌn. Caj ya'araj ti': ―Barej ca pʌyic mac quir u janʌnob cax cu qui' janʌnob? Mʌ' ja chen pʌyic a mac a jach yaj. Mʌ' ja pʌyic a wits'inob, mʌ' ja pʌyic a bʌjob, mʌ' ja pʌyic a wet cajar a neyʌn u taq'uinob quire' baxuc xan c'ucha'an yorob u wʌc'ʌs pʌyiquech ta janʌn xan. Baxuc aro' tu wʌc'ʌs botechob. ");
INSERT INTO lacNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Chen wa ca pʌyiquex mac quir u qui' jananob. Pʌyej a mac otsij, baxuc pʌyej a xon c'upa'an yoco' wa ju c'ʌb xan. Baxuc pʌyej a mech yoque'. Baxuc pʌyej a ch'op u wiche' xan. ");
INSERT INTO lacNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wa baxuc ca pʌyicob janʌnob a C'ujo' cu bin u qui'quintic a wor quire' a ra' winiquirob mʌ' cucha'an yorob u wʌc'ʌs bo'otiquech tu ta payajexob. Chen C'uj cu bin u bo'otiquex ca' bin riq'uic a mac quimeno' a mac curʌjij an ten bic C'uj u c'at uch. ");
INSERT INTO lacNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A mac a p'eri' curic janʌnob a caj u yubaj ya'aric Jesús caj ya'araj ti' Jesús: ―Jach qui' yorob a mac a cu bin janʌnob tu q'uinin cu bin u reyinticob C'uj a payob janʌnob. Ba'iri' cu c'uchur quir u janʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús caj ya'araj ti': ―Yʌn mac caj u toc pʌyaj ya'ab ca' tac u qui' janʌnob. Tar cu bin pʌybir tu yatochob. ");
INSERT INTO lacNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Caj c'uchij tu q'uinin toc ts'aca'an yo'och caj tuchi'ta'b ca' u t'ʌnej a mac payob janʌnob uch. U c'urewob a tu pʌyaj ti' janʌnob: “Cojen ―quij―, toc ts'aca'an a wochex.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chen tu cotor a payob ca'ch caj u yʌnxchun ya'arob. Biquinin mʌ' c'ucha'an yor u binob, a tu yʌn c'uch, caj ya'araj: “A teno' caj in mʌnaj in ru'um, yʌn in bin in wiric biquira'. Toc chan arej ti' a jach ts'urir mʌ' c'ucha'an in wor in tar. Arej u jawsen a Jaj Ts'urir.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Caj c'uchij u c'urew ich u jer a mac payob ca'ch. Raji' caj u ya'araj: “A teno' caj in mʌnaj cinco ca' ca'tur in wʌrʌc' wacʌx a ton, a cu jitic ba'. Bin in ca' in wirej wa cu beyajob. Toc chan arej ti' a Jach Ts'urir mʌ' c'ucha'an in wor in tar. Arej u jawsen.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Caj c'uchij u c'urew ich u jer a mac payob uch. Raji' caj u ya'araj: “Mʌ' jin tar ―quij―, quire' tant in ch'ic in rac', rajen mʌ' c'ucha'an in wor in tar.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Caj ts'oc yu'ur u c'urew caj ya'araj ti' u Jach Ts'urir a ba' caj u ya'araj a mac payob uch. Rajen caj ts'iquij caj ya'araj ti' u c'urew: “Sebquintej a bin ich tanbej ich u cajar, baxuc ich u berir u cor mac. Ca' a rʌc pʌyic a mac otsir. Baxuc a mac xonc'ub yoc wa c'ʌb. Baxuc a mac mech. Baxuc a mech yoque'. Baxuc a ch'op u wicho' xan.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Caj ts'oc u betic aro' caj wʌc'ʌs bin ich u Jach Ts'urir caj ya'araj: “In Jach Ts'urir ―quij―, caj in toc betaj a ba' caj a wa'araj. Ti' toy yʌn, mʌ' chupuc a watoch.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Caj ya'araj ti' u c'urew: “Joq'uen, rʌc pʌyej ich tancab u cajar cax tu cu manob ich bej. Chich pʌyob ca' tacob tu janʌnob soc u rʌc chupur in watoch.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Caj ya'araj u Jach Ts'urir: “Taj quin wac tech a mac a caj in yʌn pʌyajob, mʌ' ju bin u janticob in woch. A toc ts'aca'an, quire' mʌ' in cha'ic u tarob.” ");
INSERT INTO lacNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","P'eri' cu binob Jesús yejer a pimob. Caj u sut u bʌj caj u ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Wa mac ich techex u c'at u tar tin pach quir u cʌnic in t'ʌn. Wa ju jach yajquintic u tet yejer u nʌ' yejer u rac' yejer u parar yejer u bʌjob. Cax u wʌc'ʌs bʌjiri' chen mʌ' ten u qui' yajquintic ten ―quij Jesús―, aro' mʌ' c'ucha'an yor u tar u cʌnic in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wa mac ich techex ―quij Jesús―, mʌ' u c'at u muc'yaj, mʌ' u c'at u quimin, cax ich cruz wa ra' u c'at C'uj. Arej mʌ' c'ucha'an yor u tar u cʌnic in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wa mac ich techex ―quij Jesús―, u c'at u ts'ʌpquintic tunich soc u c'ʌxic yatoch jach carem. Cu yʌn tucric mun u bo'orir, mʌ' toy yʌnchun u beyaj soc yiric wa c'ucha'an u ts'ocsic ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wa mʌ' tu qui' tucraj mun u bo'orir quir u ts'ocsic ca' bin u ts'ʌpquintic tunich quir u nacsic u jo'r ca'anan. Ca' bin yirej mʌ' c'ucha'an yor u ts'ocsic. Tu cotor mac cu bin tar u che'ticob quire' caj u yirob mʌ' c'ucha'an yor u ts'ocsic. ");
INSERT INTO lacNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Cu bin u ya'aricob: “A je' xibo' caj u yʌnxchun cu chen ts'ʌpquintic tunich mʌ' c'ucha'an yor u ts'ocsic.” Baxuc a mac a cu tar u cʌnic in t'ʌn. Cu yʌn tucric mun u bo'orir wa toy yʌnxchun u tar tin pach. ");
INSERT INTO lacNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jesús caj ya'araj ti' a pimo', a mac tarob tu pach: ―Baxuc a reyo' ―quij Jesús―, wa cu bin u ts'ictar yejer u yet reyir quire' p'acta'b. Cu yʌn qui' tucric wa c'ucha'an yor ti' quir u nup'ic yejer diez mil, cax yet reyir yʌn veinte mil soldado. ");
INSERT INTO lacNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wa cu yiric mʌ' c'ucha'an yor ti' yet reyir. Ti' toy yʌn yet reyir nach, tan u tar quinsbir. Je' u tuchi'tic mac quir u sisquintic yor soc cu p'eri'quinticob yor soc mʌ' ju tar quir u quinsa'. ");
INSERT INTO lacNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","A mac a cu bin u betic a ba' jach no'j, yʌn u qui' tucric wa c'ucha'an yor u ts'ocsic. Baxuc techex ―quij Jesús―, mʌ' c'ucha'an a worex a tar a cʌniquex in t'ʌn, wa mʌ' a c'at a p'ʌtiquex tu cotor a ba' yʌn techex. ");
INSERT INTO lacNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Caj ya'araj Jesús: ―A wochexo', mʌ' qui' wa mʌ' tabta'an yejer xa'an. Chen wa cu ruc'ur u xa'anin. Ba' yʌn ic betej soc u wʌc'ʌs tar u xa'anin? ");
INSERT INTO lacNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A ruc'a'an u xa'anino', mʌ' ba'wir ti', mʌ' ti' a cor quir u ch'isej ba' an ten bic u ta' tsimin, ca chen joc'sic a puric nach. Baxuc techex wa mʌ' a quibiquex in t'ʌn cu bin u joc'sic u puric techex. Qui' u'yex a ba' quin wac. ");
INSERT INTO lacNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Turi' u q'uinin caj tarob a mac cu c'ʌmicob u taq'uin gobierno yejer a mac yʌn u si'pirob. Caj u much'quintajob u bʌj ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Rajen u winiquirob judío a fariseojo' yejer yʌjcamsayʌjirob u t'ʌn Moisés caj ya'arajob: ―A je' xiba' cu man yejer a mac yʌn u si'pirob, cu janʌn yejerob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Rajen Jesús caj u camsaj baxuc a je'ra': ");
INSERT INTO lacNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Wa turiri' techex yʌn cien a wʌrʌc' tʌmʌn yuc, cu satʌr turiri', mʌ' wa cu jamach p'ʌtic u yʌrʌc' tʌmʌn yuc a noventa y nueve tu cu janʌnob ca' xic u cʌxtej a sa'ataro'? Cu qui' cʌxtic hasta cu yiric. ");
INSERT INTO lacNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Caj ts'oc yiric caj qui'jij yor rajen caj u c'ocha. ");
INSERT INTO lacNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ca' bin c'uchuc ich yatoch caj u pʌyaj a mac u jach yajob yejer u yet cajarob caj ya'araj ti'ob: “Ca' ij qui'quintej ij cor quire' caj in wiraj in wʌrʌc' tʌmʌn yuc a cu satʌr uch.” ");
INSERT INTO lacNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Baxuc xan, rajen quin wac techex: Jach manan cu bin u qui' tar yor C'uj ich ca'anan yejer yʌjmasirob u t'ʌn C'uj quire' caj u yiraj turi' caj u c'axaj yor, caj u p'ʌtaj u man tu c'asir. Cax mʌ' ba'wir aro' a noventa y nueve quir u c'axic yorob soc u p'ʌticob u c'asirob quire' jach tsoyob. ");
INSERT INTO lacNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesús caj ya'araj: ―Mʌ' wa ti' yʌn xquic a yʌn diez u sʌc taq'uin wa cu sʌtic u taq'uin turiri'. Cu t'ʌbic u quib quir u mistic yatoch soc u qui' cʌxtic u taq'uin hasta cu yiric. Jach taj cu bin u qui' cʌxtic hasta cu yiric. ");
INSERT INTO lacNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Barej caj u yiraj u taq'uin cu pʌyic a mac u jach yajob. Baxuc u yet cajarob, caj ya'araj ti'ob: “Ca' ij qui'quintic ij cor quire' caj in wiraj in taq'uin a tin sʌtaj uch.” ");
INSERT INTO lacNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Quin wac techex baxuc xan qui' yorob yʌjmasirob u t'ʌn C'uj ber cu yiricob u c'axic yor mac. Caj u p'ʌtaj u man tu c'asir, cax turiri'. ");
INSERT INTO lacNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús caj ya'araj ti': ―Ti' yʌn turiri' xib yʌn ca'tur u parar. ");
INSERT INTO lacNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A its'inbir u parar caj ya'araj ti' u tet: “Tet ―quij―, jʌse ten a ba' ca bin a p'ʌtej wa ca quimin.” Rajen u tet caj u jʌsaj ti'ob u pararob a ba' cu bin u p'ʌtic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Caj manij mʌ' ya'ab u q'uinin, u parar a its'inbiro' caj u rʌc maraj u ba'tac caj u p'ʌtaj u tet caj bin ich tanxer u cajar nach. Caj u rʌc xup u taq'uin tu cu man tu c'asir. ");
INSERT INTO lacNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Caj ts'oc u rʌc xupic u taq'uin caj c'uchij tu q'uinin u tar wi'ij tu ru'umin. Caj u yʌnxchun u masic otsir. ");
INSERT INTO lacNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Caj tar u chich c'ataj u beyaj a ti' cʌja'an ich u ru'umin. Raji' caj u ts'aj u beyaj ich u cor quir u jansic yʌrʌc' q'uec'an. ");
INSERT INTO lacNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cu jach pachtic u najchʌjʌr yejer yoch q'uec'an a cu ts'abʌr ti'. Quire' mʌ' u ts'abʌr ti' a mac a cu cʌnanticob q'uec'an. ");
INSERT INTO lacNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chen caj u c'axaj u tucur caj ya'araj: “Mun u c'urew in tet cu beyaj. Toc yʌn yo'och ya'ab. Mʌ' u rʌc janticob. Chen a teno' tan in quimin yejer wi'ij. ");
INSERT INTO lacNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bin in ca' sut ich in tet ca' bin in wac ti' in tet: Tet, quen, a teno' yʌn in si'pir ti' C'uj. Baxuc tech, mʌ' tin quibaj a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ca' bin in wac ti' in tet: Mʌ' tsoyen a waquen wa ja pararen. Chan cha' in beyaj tech an ten bic a c'urew.” ");
INSERT INTO lacNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A its'inbiro' caj riq'ui, caj sutnʌjij ich yatoch u tet. ’Ti' toy yʌn nach caj irir ten u tet, tan u sut. Caj yajquinta'b ten u tet caj u c'ʌnaj u yacab quir u nup'ur caj c'uchij ich u parar. Caj u pʌtʌx mec'taj caj u ts'u'ts'aj u p'uc. ");
INSERT INTO lacNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Rajen u parar caj u ya'araj ti' u tet: “Tet, quen, a teno' yʌn in si'pir ti' C'uj. Baxuc tech quire' mʌ' tin quibaj a t'ʌn. Rajen mʌ' tsoyen a waquen wa ja pararen.” ");
INSERT INTO lacNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Caj c'uchob yejer u tet ich yatoch. U tet caj ya'araj ti' u c'urew: “Chuquej u jer u noc' a tsoyo' ca' a tʌquej u noc' ti'. Chuquej u c'ʌb ca' a c'ʌrej tu c'ʌb. Chuquej u pech' xʌnʌb ca' a jupej ich yoc. ");
INSERT INTO lacNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Joq'uen chuque bʌc' a tan ic tsentic ca' ij quinsej ca' ij qui' janʌnex ca' qui'ac ij corex. ");
INSERT INTO lacNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Quire' a je' in parara' in wer uche' quimen chen ti' yʌn baje'rer cuxa'an quire' caj u p'ʌtenob uch chen baje'rer tan tu c'uchur.” Caj u yʌnxchun u betic ti' u qui' janʌnob. ");
INSERT INTO lacNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’U parar a sucu'unbiro' ti' yʌn ich u cor ca'ch caj ur u yits'in. Tan u yu'ur tabar u c'uchur ich yatoch. Caj yubaj u c'ayob tan yoc'atob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Rajen caj u t'ʌnaj turiri' u c'urew u tet caj u c'ata ti' ba' cu yiricob. ");
INSERT INTO lacNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Caj ara'b ti' ten u c'urew: “Quire' toc ur a wits'in rajen a tetex caj u ya'araj ca' quinsac bʌc' a toc tsemta'an toc ti' yʌn yor quire' urij.” ");
INSERT INTO lacNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","A sucu'unbiro' caj ts'iquij, rajen mʌ' u c'at u yocar ich u tet. Caj joc' u tet caj u chich araj ti' ca' ocac. ");
INSERT INTO lacNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Caj u nuncaj ti' u tet: “U'yej ba' quin wac. Ya'ab yaxq'uin caj in beyaj tech. Ti' toy quin beyaj tech a ba' ta wa'araj ca'ch, caj in toc quibaj. Mʌ' ta chuca bʌc' teni', a ts'aten mʌ' chichin soc in qui' janʌn yejer a mac in jach yajob. ");
INSERT INTO lacNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Chen caj urij a parar a je'ra' a caj u rʌc xupaj a taq'uin yejer xquic a cu manob. Biquinin caj a wa'araj u quinsa' yoch bʌc' ya'ab a tsemta'an ―quij―, ti' u tet?” ");
INSERT INTO lacNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chen u tet caj u ya'araj ti': “In pararech. Rajra' ti' yʌnech tin wicnʌn. Tu cotor ba' a yʌn ten, tech yʌnin. ");
INSERT INTO lacNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mʌ' ja wirej ―quij―, yʌn ij qui'quintic ij cor. Yʌn ij qui' janʌn xan quire' urij a wits'in. In wer quimij uch chen ti' yʌn baje'rer cuxa'an quire' caj u p'ʌtʌnenob uch chen baje'rer tant u c'uchur.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús caj u ya'araj ti' u camsʌwinicob xan: ―Ti' yʌn mac u Jach Ts'urir, neyʌn u taq'uin. Aro' yʌn u ca' ts'urir. Caj ara'b ti' ten mac: “A ca' ts'urir tech caj u rʌc xupur a ba' yʌn tech.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Rajen u Jach Ts'urir caj u pʌyaj ca' tac u ca' ts'urir caj c'uchij caj ara'b ti' ten u Jach Ts'urir: “Arej ten ba' caj in wu'yaj u jumintic tech, a rac'ob? Toc ts'ibtej ten mun caj a rʌc xupaj in ba'tac baxuc a mun caj a jaraj ten quire' baje'rer mʌ' a bin a beyaj ten.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Caj u tucraj u ca' ts'urir caj ya'araj: “Ba' quin bin in betej quire' in jach ts'urir bin u joc'siquen ti' in beyaj tu quin cʌnantic u ba'tac? Mʌ' c'ucha'an in wor in chich beyaj. Je' in ch'ic suraquir wa quin man in c'atic ba' ti' in rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","In toc er ba' quin bin in betej soc u yacsiquen mac ca' bin joc'saquen ti' in beyaj tu tin cʌnantaj u ba'tac in jach ts'ur.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Caj u pʌyaj jujuntur a mac yʌn u bo'or ti' u jach ts'urir caj ara'b ti' a yʌn c'uchij: “Mun a bo'or ti' in jach ts'urir?” ");
INSERT INTO lacNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A mac yʌn u bo'or caj ya'araj: “A teno' yʌn in bo'or cuatro mil litros tsats.” Caj ara'b ti' ten a ca'ts'uro': “Curen ―quen―, a je' u ju'unin a bo'or ca' a ts'bitej a bo'or chen dos mil.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Caj c'uchij ich u jer caj u c'ataj ti': “Mun a bo'or ti' in jach ts'urir?” Caj ya'araj: “A teno' yʌn in bo'or turi' mil tzontle nʌr.” Caj ara'b ti': “A je' u ju'unin a bo'or ca' a ts'ibtej ocho cientos tzontle nʌr.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Caj u c'ʌ'otaj u jach ts'urir ti' u ca' ts'urir a mʌ' tu qui' cʌnantaj u ba'tac. “Aro', jach t'aj ―quij jach ts'urir―, an bic tabar caj u tucraj soc u yacsa' ten a mac yʌn u bo'or ten.” Quin wac techex ―quij Jesús―, jach t'aj a mac a cu yajquinticob a ba' yʌn ich yoc'ocab. Mʌ' ja wirej, neyerob bic tabar cu cʌnanticob u bʌj. Chen ya'ab mac a yerob C'uj mʌ' u netucricob bic tabar cu bin u jaricob u taq'uin yejer u ba'tac. ");
INSERT INTO lacNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesús caj ya'araj: ―A teno' quin wac techex a ba' yʌn techex ich yoc'ocab. Je' u rʌc xupur. Chen a ba' yʌn techex c'ʌnex ti' mac soc tsoy yiriquechex. Ca' bin xuruc t'ʌn yʌn mac ich ca'anan cu bin u yacsiquechex soc munt q'uin ti' yʌnechex ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Wa mac cu qui' cʌnantic a ba' mʌ' neno'ji', je' u qui' cʌnantic a ba' jach no'jo'. A mac mʌ' u cʌnantic a ba' mʌ' neno'ji', mʌ' ju bin u cʌnantic a ba' jach no'jo'. ");
INSERT INTO lacNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Rajen wa mʌ' ta qui' cʌnantex a ba' ts'a'b techex ich yoc'ocab, mʌ' ju bin ts'abir techex a ba' jach no'jo' ich ca'anan. A ti' taro', mʌ' u xupur. ");
INSERT INTO lacNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mʌ' ja wirej ―quij Jesús―, a ba' yʌn techex ich yoc'ocab C'uj yʌnin, mʌ' techex yʌnin. Wa mʌ' ta qui' cʌnantex a ba' yʌnin C'uj mʌ' u bin u ts'ic techex soc techex yʌnin a ba' mʌ' u xupur ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Mʌna' mac c'ucha'an yor u cʌjtar ich yatoch wa cu ts'urintic ca'tur u jach ts'urir quire' cu bin u p'actic turiri' chen cu bin u yajquinbir juntur u jach ts'urir. Mʌ' ja wirej ―quij Jesús―, cu bin u qui' beyaj ti' a mac cu jach sʌtic. Chen u jer u jach ts'ur a mʌ' ju sʌjtic, mʌ' ju qui' beyaj ti'. Baxuc techex. Mʌ' c'ucha'an a worex a c'ujintiquex C'uj wa caj a qui' beyajex quire' a c'at a nejariquex a taq'uinex. ");
INSERT INTO lacNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","C'ʌs bʌytʌc ti' yʌnob u winiquirob judío a fariseojo caj ts'oc yubicob ya'aric ti' u camsʌwinicob caj u p'astajob Jesús quire' cu nepachticob u taq'uin u winiquirob judío a fariseojo'. ");
INSERT INTO lacNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús caj ya'araj ti' a fariseojo': ―A techexo' ca tus ets'tiquex jach tsoyechex ʌcʌtan a rac'obex barej C'uj yer a pixamex. Mʌ' ja wirej, yʌn a ba' cu tucricob winic, jach no'jo'. Chen ya'ab ba' cu tucricob winic no'j, a C'ujo' cu p'actic. ");
INSERT INTO lacNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Mʌ' toy tac Juan, ra' caj u pʌyaj a berex a ba' caj u ts'ibtaj Moisés yejer a ba' caj u ts'ibtaj yʌjtseq'uirob u t'ʌn C'uj. Pachir a Juano' caj u tsec'taj techex bic tabar cu bin u reyinticob C'uj. Baje'rer ya'ab mac u c'atob u yocar tu cu bin u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ca wiric, a ba' ts'iba'an ich u t'ʌn C'uj a chichino' a puntojo', mʌ' u bin ts'ocar ti'. Chen a ca'anano' yejer a ru'umo' cu bin rʌc ts'ocar ti'. Tu cotor u t'ʌn C'uj cu bin nupsej. ");
INSERT INTO lacNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesús caj ya'araj ti'ob: ―Wa mac cu p'ʌtic u rac' quir u bin u ch'ic u jer. Caj ts'oc u ch'ic u jer yʌn u si'pir, irej wa man u ca' yejer. Baxuc a mac a cu ch'ic u raq'uintej a p'ato'. Baxuc xan yʌn u si'pir aro' irej wa man u ca' yejer mac a cu man. ");
INSERT INTO lacNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús caj ya'araj ti'ob: ―Ij quer ti' yʌn mac jach yʌn u taq'uin, a ba' cu buquintic jach tsoy u noc', quire' jach co'oj. Rajra' cu qui' janʌn xan. ");
INSERT INTO lacNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ti' yʌn mac otsir u c'aba' Lázaro p'achen t'uch u cʌnmʌn. Tar cu bin purbir ten u rac'ob ich u jor u pa'te' a mac neyʌn u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Cu pachtic u jantic u p'up'ir a cu pich'intic cu ts'ocar u janticob a neyʌn u taq'uin. Cu tar a pec'o' cu rets'ic u p'achen t'uch. ");
INSERT INTO lacNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Caj c'uchij tu q'uinin caj quimij a otsiro' caj bin purbir ten yʌjmasirob u t'ʌn C'uj ca'anan tu yʌn u nunquir Abraham. Baxuc caj quimij a neyʌn u taq'uin, caj bin mucbir. ");
INSERT INTO lacNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Caj binij tu cu bin mac a cu quimin a yʌn u si'piro'. Tu cu muc'yaj, a neyʌn u taq'uin caj u nacsaj u wich caj u pʌctaj nach. Caj u yiraj ti' yʌn Abraham yejer Lázaro ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Caj u yawʌt t'ʌntaj caj ya'araj: “In nunquirech Abraham ―quen―, yajquin ten ―quij―, arej ca' tac Lázaro tu yʌnena'. Arej ca' tʌre ja' tu yar u c'ʌb ca' tac u tʌrej ja' tin wac' ca' sisac in wac' quire' tan in jach muc'yaj ich c'ac' tu quin werar.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Caj ara'b ten Abraham: “In pararech ―quij Abraham―, c'aj tech a ucho' ti' toy cuxa'anech ich yoc'ocab quire' caj a qui'quintaj a wor a ba' yʌn tech. Baxuc Lázaro xan caj muc'yajnʌjij ya'ab ca'che', ti' toy cuxa'an ich yoc'ocab. Chen baje'rer Lázaro qui'quinta'b yor chen a techo' ts'a'b a muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ti' toy yʌn ―quij Abraham―, mʌ' c'ucha'an yor Lázaro u tar tu yʌnech. Quire' toc beta'b ten C'uj, jach carem u ch'ic ca'ananin ich tech, baxuc ich ten xan. Soc a tenob mʌ' c'ucha'an in worob in tarob tu yʌnech. Baxuc tech mʌ' c'ucha'an a wor a tar tub yʌnenob.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Rajen caj u ya'araj a mac neyʌn u taq'uin: “Quin chich c'atic tech in nunquirech Abraham ca' a tuchi'tej Lázaro ich yatoch in tet. ");
INSERT INTO lacNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Quire' yʌn cinco in bʌjob. Ca' yarej ti'ob soc mʌ' u beticob xan an ten bic caj in betaj uch ich yoc'ocab soc ca' bin quimicob mʌ' u tarob yejeren tu quin muc'yajob.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham caj u nuncaj ti': “A bʌjob tech toc yʌn a ts'ibta'b u t'ʌn C'uj a nanij cu xaquicob, baxuc cu tsec'tic ti'ob tu cu naj c'ujinticob C'uj u winiquirob judío. Chen yʌn u quibejob a ba' cu yubicob, ya'ara' ti'ob.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Caj ya'araj a mac neyʌn u taq'uin: “In nunquirech Abraham ―quij―, mʌ' u bin u quibicob tu cu tsec'ta' ti'ob u t'ʌn C'uj. Jaj ixtʌcoj wa cu riq'uir a quimeno' soc u bin u tsicbar ti'ob je' u c'axicob yor, tan u p'ʌticob u man tu c'asir.” ");
INSERT INTO lacNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham caj ya'araj ti': “Wa mʌ' u quibicob a ts'iba'an u t'ʌn C'uj cax wa riq'uir mac tu quimen mʌ' u bin u yacsejob tu yorob.” ");
INSERT INTO lacNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús caj ya'araj ti' u camsʌwinicob: ―Rajra' yʌn ba' quir u yacsic u si'pir chen jach otsir a mac cu tumtic yor soc u yacsic u si'pir u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wa cu jich'ir tu car a jach ar u ca'ir tu cu juch' ti' a ray xibob soc u juruc ich c'ac'nab ca' quimic. Aro' jach tsoy ca' juruc soc mʌ' c'ucha'an yor cu tumtic yor mac soc u yacsic tu si'pir quire' cu tucric: Jot mac aro'. ");
INSERT INTO lacNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jesús caj u chich ya'araj ti'ob: ―Qui' cʌnantej a bʌj ―quij―, wa ja wet acsa'orir caj u cʌrʌxbetaj tech. Ca' bin ts'ocac a chich aric ti'. Soc u p'ʌtic u c'asir caj u betaj. Jaj ixtʌcoj je' u c'axic u yor tan u p'ʌtic. Ca' a jawsej ti' ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Cax ya'ab u tenin cu cʌrʌxbetic tech a wet acsa'orir. Baxuc ya'ab u tenin cu tar yac tech: “Mʌ' in yʌn yʌn betej aro'.” Ca' a jawsej ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A mac tuchi'ta'b ten Jesús caj ya'araj ti': ―Jaj Ts'urir ―quij―, yʌmtej a tenob soc in qui' acsicob tin worob a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A Jaj Ts'uro' caj ya'araj: ―Wa ca wacsiquex ta wor ti' C'uj cax an ten bic mijin u yijir mostaza, raji' jach mijin. Jeroj c'ucha'an a wor a wac ti' a je' che'a' carem: “Joq'uen che' ―quech ti'―. Ca' xiquech a pʌc' a bʌj ich c'ac'nab.” A che'o' cu bin yubic a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesús caj ya'araj ti'ob: ―Wa ja c'urewex cu beyaj ich a corex tan u muxic ru'umin a corex soc a paq'uiquex a trigojo'. Baxuc tan u cʌnantic a wʌrʌc' tʌmʌn yuc, ca' bin uruc beyaj. A techexo' mʌ' a wac ti': “Sepquintej ca' curaquechex ta janʌn.” ");
INSERT INTO lacNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mʌ' wa ca waquex ti': “Toc ts'ocsej in wo'och. Cu ts'ocar ca ts'icten. Cu ts'ocar in janʌn a teno' tsoy a bin janen tech xan.” ");
INSERT INTO lacNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Je' wa ja wac ti' a c'urew: “Bayo'” ―quech ti'―, quire' qui' beyanʌjij? Mʌ' ja bin a wa'aric ti' baxuco' quire' caj u chen betaj a ba' caj a wa'ara ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Baxuc techex in wʌjcamsʌyʌjirechex ca' bin ts'ocac a rʌc betiquex a ba' caj u ya'araj C'uj. Ca' a waquex ti' C'uj: “Caj in chen betajob a ba' yʌn in beticob. Mʌ' tsoyenob a wactenob bayo'.” ");
INSERT INTO lacNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ti' toy cu bin Jesús ich u berij Jerusalén. Ti' manij tu xurij u ru'umin Samaria. Baxuc ti' u xur u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Caj c'uchij ich u chan cajar. Tabar u yocar caj u nup'ob xib diez, u cʌnmʌn iq'uer u ca'ob. Ti' xurob nach. ");
INSERT INTO lacNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Caj u c'am puraj u t'ʌnob caj ya'arob: ―In Jaj Ts'urirob Jesús ―quij―, yajquin tenob ca' a jawsenob. ");
INSERT INTO lacNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Caj yiraj Jesús caj ya'araj ti'ob: ―Xenex ich ʌcʌtan sacerdote soc u yiriquechob jawechex. Caj binob jaw iq'uer u ca'ob ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Turiri' xib ich a diezo' caj yiraj toc jawij, rajen sutnʌjij ich Jesús. C'am caj awʌtnʌjij: ―Bayo' C'uj ―quij―, caj a jawsajen. ");
INSERT INTO lacNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Caj c'uchij ich Jesús caj xonrʌj caj ya'araj: ―Bayo' ―quij. Raji' cʌja'an ich u ru'umin Samaria uch. ");
INSERT INTO lacNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Rajen Jesús caj ya'araj: ―Caj in jawsaj diez. Tu binob a nuevejo'? ");
INSERT INTO lacNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Chen a je' turi' xiba' a cu tar ich tanxer ru'um wʌc'ʌs tarij ya'aric ti' C'uj: “Bayo'.” ");
INSERT INTO lacNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesús caj ya'araj ti' xib: ―Riq'uen ca' xiquech quire' jawech quire' caj a wacsaj ta wor ten. ");
INSERT INTO lacNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Caj c'uchob u winiquirob judío a fariseojo' ich Jesús. Caj u c'atob: ―Ber ca' bin u reyintejob C'uj? ");
INSERT INTO lacNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jesús caj u nuncaj ti': ―Mʌna' ba' cu bin yesic techex soc c'ucha'an a worex a werex tabar u reyinticob C'uj. Mʌna' mac cu bin ya'aric: “Iric te' yʌna' tan reyinticob C'uj. Baxuc tar yʌno' tan u reyinticob C'uj.” Quire' toc ti' yʌn baje'rer tub yʌnechex tan u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesús caj ya'araj ti' u camsʌwinicob: ―Ca' bin a pachtej a wirej a mac a cu bin tuchi'bir ten C'uj. Cax turiri' u q'uinin ca wiriquex, chen mʌ' a bin a wirexi'. ");
INSERT INTO lacNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yʌn mac cu bin u yac techex: “Iric tan u reyinticob tera'”, wa cu bin ya'aricob: “Tan u reyinticob taro'.” Mʌ' ja sayʌrex tu pachob tu cu payiquechex. ");
INSERT INTO lacNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","An ten bic ca wiriquex u raram. Seb cu sasichʌjʌr tu cotor ca'anan. Baxuc ca' bin taquen ca' bin c'uchuc tu q'uinin quire' a teno' tu tuchi'tajen C'uj, baxuquenechexo'. Baxuc seb ca' bin raramnʌc baxuc tu cotor mac cu bin yiriquen. ");
INSERT INTO lacNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Chen pʌyber quin bin in jach muc'yaj. Bin u ca'ob u xump'ʌtiquenob u jach ts'urir sacerdote. Baxuc a mac a cu camsicob u t'ʌn Moisés. Baxuc u ts'urirob u cajar u winiquirob judío. Baxuc u winiquirob judío, mʌ' ya'ab. Bin u ca'ob xump'ʌtiquenob quire' mʌ' u yacsicob tu yorob ten. ");
INSERT INTO lacNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","An ten bic u q'uinin, ti' yʌn Noé uch, baxuc cu bin u betej u q'uinin ca' bin urquen quire' caj u tuchi'ten C'uj ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mʌ' ja wirej ―quij Jesús―, a mac cʌja'anob tu q'uinin Noé, rajra' tan u qui' janʌnob. Rajra' tan u ch'icob u yo'och. Rajra' tan u ts'icob u pararob quir u raq'uinticob mac. Hasta caj c'uchij tu q'uinin Noé, caj oc ich chem caj tari ya'arir, jach c'am. A mac mʌ' rʌc ocob ich chem caj rʌc bint ja'. ");
INSERT INTO lacNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Baxuc caj beta'b u q'uinin cʌja'an Lot ich Sodomajo'. A mac cʌja'anob ich u cajar Sodoma, rajra' tan u janʌnob. Rajra' tan u yuc'urob. Rajra' tan u canicob u ba'tac. Rajra' tan u mʌnicob u ba'tac. Rajra' tan u pʌq'uicob u nar. Rajra' tan u c'ʌxicob yatochob. ");
INSERT INTO lacNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Chen u q'uinin caj ruq'uij Lot tu cajar Sodoma C'uj caj u chaj u tar c'ac' ca'anan yejer tunich. Erar u ca' an ten bic cu tar ja' ca'anan, caj rʌc quinsa'bij ten c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Baxuc ca' bin c'uchur tu q'uinin ca' bin urquen quire' a teno' caj u tuchi'ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ca' bin uruquen. Wa ti' yʌn xib ich u jo'r yatoch tan u jesicob u bʌjob. Quire' ti' taro' u jo'r yatoch taj, chen u ba'tac ti' yʌn tu japnin yatoch. Arej mʌ' u yeman u maric u ba'tac. Arej u toc p'ʌtej. Baxuc a mac ti' yʌn tu cor cax mʌ' u sut tu yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mʌ' wa c'ajtechex ba' u ber ti' u rac' Lot? ");
INSERT INTO lacNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","A maque' cu tucric u ta'quic u bʌj soc mʌ' u muc'yaj soc mʌ' u quimin xan, aro' tar cu bin ich c'ac'. Chen a mac a cu yac te' yʌnena' quir in muc'yaj quir in quimin xan, quir in yamtic Jesús. Aro' bin u ca' cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Quin wa'aric techex ―quij Jesús―, soc a werex ba' u ber u q'uinin ca' bin uruquen. Waj oq'uin quin wur. Wa ti' yʌn ca'tur xib p'eri' u wenenob. Turi' cu bin pʌybir ten yʌjmasir u t'ʌn C'uj. Turi' cu bin p'ʌtbir. ");
INSERT INTO lacNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ra'iri' u q'uinin xan, wa ti' yʌn ca' tur xquic tan u juch'ob turiri' cu bin pʌybir ten yʌjmasirob u t'ʌn C'uj. Turiri' cu bin p'ʌtbir. ");
INSERT INTO lacNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ra'iri' u q'uinin xan, wa ti' yʌn ca'tur xib ich u cor. Turi' cu bin pʌybir ten yʌjmasirob u t'ʌn C'uj. Turi' cu bin p'ʌtbir. ");
INSERT INTO lacNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","U camsʌwinicob caj ts'oc yubicob ya'aric Jesús a je' t'ʌna', caj u c'atajob ti': ―Tu cu bin u betej aro', Jaj Ts'urir? Caj u nunca'b ti', caj u ya'araj tu cu camsic t'ʌn: ―A mac a mʌ' u c'at u quibicob u t'ʌn C'uj je' u c'uchur tu q'uinin cu bin tar u muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús caj u ya'araj ti'ob tu cu p'eriquintic u t'ʌn soc u cʌnicob: ―Ca' a t'ʌnex C'uj soc mʌ' u nacar a worex, tu ca t'ʌniquex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ti' yʌn u cajar ―quij Jesús―, tu cʌja'an juez. A juezo', mʌ' u sʌjtic C'uj, mʌ' ju tucric mac xan. ");
INSERT INTO lacNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tiri' ich u cajar xan, ti' yʌn xquic, quimen u mam raji' caj bin ʌcʌtan juez. Su' su' cu bin ya'aric ti': “Yʌmtejen ti' a mac a cu p'actiquen.” ");
INSERT INTO lacNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Caj u yʌnxchun u tar xquic a juezo', mʌ' ju quibaj u t'ʌn. Chen pachir caj u ya'araj tu yor: “Cax mʌ' in sʌjtic C'uj ―quij―, cax mʌ' in tucric ti' mac.” ");
INSERT INTO lacNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Caj ya'araj a juezo': “Bin in ca' in yamtej a je' xquica', a quimen u mam ra' cu p'acta' xquique' soc mʌ' u choquintic in wor quire' rajra' cu tar. Quire' ca'an in wor in wu'yic ya'aric.” ");
INSERT INTO lacNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Caj ya'araj Jaj Ts'ur: ―Cʌnex ti' a ba' cu ya'aric juez cax mʌ' taj yor. ");
INSERT INTO lacNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Chen mʌ' baxuc C'uj quire' taj yor. Wa rajra' ca c'atiquex tu ca t'ʌniquex C'uj u bur u q'uinin u bur u ac'bir soc u cʌnantic a ba' a c'at. A techexo' a teta'b ten C'uj, je' u tar u tajir techex. A C'ujo' mʌ' u ts'ocar u yubic a t'ʌnex. ");
INSERT INTO lacNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A teno' ―quij Jesús―, quin wac techex. A C'ujo' seb cu ta'quic techex mac ti' a cu p'acti'echobo'. Chen ca' bin uruquen ich yoc'ocab a teno' caj u tuchi'ten C'uj, baxuquenechexo'. Je' wa jin wiric mac tan u yacsic tu yor ten. Tan u pajicob ten ca' in ta'quej ti' a mac a cu p'actic ti'e'. ");
INSERT INTO lacNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús caj u ca' camsaj tu cu p'eri'quintic u t'ʌn. Yʌn mac cu tucric chen jach tsoy a ti'ob ʌcʌtan tu wich C'uj quire' a ba' cu beticob. Chen cu tucric tu yor: “Jot u rac'ob.” Rajen Jesús caj u ya'araj baxuc aro', caj ya'araj Jesús: ");
INSERT INTO lacNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Ca'tur xib binob ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío quir u t'ʌnicob C'uj. Turiri' u winiquir judío a fariseojo', u jer yʌjc'ʌmin u taq'uin gobierno. ");
INSERT INTO lacNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Caj ch'iraj u winiquir judío a fariseojo' soc yirir ten tu cotor mac caj u tus t'ʌnaj C'uj. Tu yor, caj u t'ʌnaj C'uj, caj ya'araj: “Bayo' C'uj ―quij―, mʌ' in betic an ten bic u jer winiquir judío cu betic. A teno', mʌ' in tus ch'ic a ba' yʌn ti' winic. Baxuc mʌ' jin man tu c'asir, mʌ' jin man in wiric xquic, mʌ' c'as a teno'. Mʌ' baxuquen a cu c'ʌmic u taq'uin gobierno a ti' yʌno'. ");
INSERT INTO lacNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","A teno', quin qui' c'ujintiquech, quin jamach p'ʌtic in janʌn ca'tur u q'uinin ich a turi' semana. Tu cotor in taq'uin tu quin jaric quin chuquic turiri' ich a diezo' soc in ts'ic ti' a mac a cu jach beyaj tu cu naj c'ujinticob C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Chen yʌjc'ʌmin u taq'uin gobierno, nach yʌn. Ti' yʌn tu pach u rac'ob tu cu t'ʌnicob C'uj. Mʌ' ju c'at u nacsic u wich quir u t'ʌnic C'uj. Cu chen pʌxic u tsem quire' yer yʌn u si'pir. Quire' baxuc nanij cu betic u winiquirob judío. Caj ya'araj ti' C'uj ―quij―: “Chan yajquin ten quire' yʌn in si'pir a teno'.” ");
INSERT INTO lacNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Quin wa'aric techex ―quij Jesús―, C'uj caj u jawsaj u si'pir a cu c'ʌmic u taq'uin gobierno. Caj bin tu yatoch toc tsoyquinta'b yor ten C'uj. Chen a fariseojo', mʌ' tsoyquinta'b yor ten C'uj. A mac a cu yac jach no'jen ―quij―, chen a C'ujo' cu bin ya'aric: “Jo'tech a techo'”, cu yiric mʌ' no'ji'. Chen a mac cu yac: “Jo'ten a teno'.” Chen a C'ujo' cu yiric jach no'j. ");
INSERT INTO lacNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Caj tarob u purej ti' Jesús a mac yaje', baxuc yejer a chichano'. Caj tar purbir a chichano' soc u pʌtʌxmec'tic. Caj irir ten u camsʌwinicob ba' u ber. Caj u q'uejajob: ―Joq'uen, xen ―quij. Quire' mʌ' u c'at yiric u tarob ich Jesús a chichano'. ");
INSERT INTO lacNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús caj u pʌyaj ca' tacob. Caj ya'araj ti' u camsʌwinicob: ―Ts'ire'ej u tarob a chichano' tin wicnʌn. Mʌ' ja q'ueyic an ten bic a je' chichana'. Baxuco' a mac c'ucha'an yor yocor tu cu reyinticob C'uj. Yʌn u cʌnic irej wa ja chichano'. ");
INSERT INTO lacNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jach taj quin wac techex ―quij Jesús―. A mac a mʌ' ju cʌnic a chichano' soc u chabar ten C'uj u reyinticob mʌ' u c'uchur yor, u c'uchur ich ca'anan tu cu bin u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Caj tarij turi' u jach ts'urir u winiquirob judío ich Jesús. Caj u c'ataj ti' Jesús: ―Jach tsoyech in wʌjcamsʌyʌjirech. Arej ten ba' yʌn in betic soc in cuxtar munt q'uin? ");
INSERT INTO lacNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús caj ya'araj ti': ―Biquinin ca wac tsoyen? Mʌna' mac jach tsoy chen jari' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tech a wer ba' caj u ts'ibtaj Moisés uch. Cu ya'aric: “Mʌ' a yʌn man yejer xquic baxuc xquic, mʌ' u yʌn man yejer xib. Mʌ' ja quinsic mac. Mʌ' ja wac'ric ba'. Mʌ' a yʌn man tus, a caj a wiraj ba'. Yʌn a sʌjtic a tet, yʌn a sʌjtic a nʌ' xan.” ");
INSERT INTO lacNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","U jach ts'urir u winiquirob judío caj ya'araj: ―Tu cotor aro' ten caj in toc quibaj tin chichanin uch. ");
INSERT INTO lacNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Rajen caj ts'oc yubic Jesús a ba' caj u ya'araj. Caj ara'b ti': ―Yʌn turi' ba' mʌ' ta quibaj ca' a betej aro'. Canej tu cotor a ba' yʌn tech. Cu ts'ocar a rʌc canic, ca' a jʌsej a taq'uin ti' a mac otsir. Cu ts'ocar aro', ca' taquech tin pach quir a cʌnic in t'ʌn. Ca' bin c'uchuquech ich ca'anan tu cu bin u reyinticob C'uj. Cu bin u ts'abʌr tech a ba' jach co'oj. ");
INSERT INTO lacNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Caj ts'oc yubic a ba' caj u ya'araj Jesús ti' caj tucurnʌjij quire' jach yʌn u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús caj yiraj tucur u ca' a xibo' caj u ya'araj ti': ―Jach yaj yocar mac a neyʌn u taq'uin tu cu reyinticob C'uj quire' u yaj u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Je' wa ju c'uchur yor yocar yʌrʌc' tsimin ich u jor yit' puts'? Mʌ' ju c'uchur u yor quire' chichin u jor yit' puts'. Je' wa ju c'uchur u yor yocar ich ca'anan a mac neyʌn u taq'uin? Mʌ' ju yocar quire' u yaj u taq'uin. Jaj ixtʌcoj, je' u yocar yʌrʌc' tsimin ich u jor yit' puts'. Chen a mac neyʌn u taq'uin mʌ' yocar, tu cu bin u reyintejob C'uj, quire' u yaj u taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A mac a caj u yubaj u t'ʌn caj ya'arajob: ―A mac cu bin ta'cbir ten C'uj tun? ");
INSERT INTO lacNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Rajen Jesús caj ya'araj: ―A C'ujo' c'ucha'an yor ti' a ba' mʌ' c'ucha'an yor ti' mac. ");
INSERT INTO lacNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro caj ya'araj: ―Jaj Ts'urir ―quij―, caj in toc rʌc p'ʌtajob a ba' yʌn tenob quir in tarob ta pach soc in cʌnicob a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús caj ya'araj ti'ob: ―Jach taj quin wac techex. Wa mac cu p'ʌtic yatoch wa ju rac' wa ju tet. Wa ju bʌjob wa ju pararob soc raji' cu reyinticob C'uj wa cu cha'icob. ");
INSERT INTO lacNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Cu bin u c'ʌmej ti' C'uj a ba' jach tsoy baje'rer. Jach manan cu bin ts'abʌr ti'. Baxuc xan, ca' bin xuruc t'ʌn je' u ts'abʌr ti' u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús caj u pʌyaj u doce u camsʌwinicob soc u tsicbar ti'ob tu junanob: ―Baje'rer ―quij―, quic wʌc'ʌs bin ich u cajar Jerusalén. Tu cotor a ba' caj u ts'ibtajob yʌjtseq'uirob u t'ʌn C'uj ti' ten uch. Je' u tar ten quire' caj u tuchi'tajen C'uj baxuquenechexo'. ");
INSERT INTO lacNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ti' cu bin u c'ubiquenob ti' a mac a mʌ' u winiquirob judío. Ti' cu bin u p'astiquenob. Ti' cu bin u cʌrʌxbetiquenob. Ti' cu bin u tubiquenob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ti' cu bin u chich jʌts'icob in pach. Cu ts'ocar aro' cu bin u quinsiquenob. Chen ca' bin manʌc mʌna' u nup u q'uinin, je' in riq'uir tin quimirir. ");
INSERT INTO lacNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","U camsʌwinicob, mʌ' tu najtajob a ba' caj u yubajob ya'aric Jesús quire' mʌ' yerob ba' u c'at ya'aric u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tabar u c'uchur Jesús ich u cajar Jericó. Ti' cura'an a ch'op u wicho' ich nʌc' bej. Tan u c'atic u taq'uin quir u janʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Caj u rʌc u'yaj u manob a pimo' a ch'op u wicho' caj u c'ata ti' mac bʌytʌc ba' u ber. ");
INSERT INTO lacNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Caj ara'b ti': ―Jesús a cu tar ich u cajar Nazaret, raji' caj a wu'yaj u man ʌcʌtan tech. ");
INSERT INTO lacNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A ch'op u wicho' caj u puraj u t'ʌn ti': ―Jesús ―quij―, u pararech a nunquir u rey David, chan yajquin ten. ");
INSERT INTO lacNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chen a mac a cu binob pʌybej caj u ya'arajob ti': ―Mʌc a chi' ―quij. Chen caj u jach c'amquintaj yawʌt t'ʌn: ―U pararech a nunquir u rey David, chan yajquint ten. ");
INSERT INTO lacNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Caj xurij Jesús ich bej caj ya'araj ca' tac purbir ti'. Caj u juts' u bʌj ich Jesús caj c'ata'b ti': ");
INSERT INTO lacNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Ba' a c'at in betej tech? A ch'op u wicho' caj u nuncaj: ―Jaj Ts'urir ―quij―, in c'at u sasichʌjʌr in wich. ");
INSERT INTO lacNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Caj ara'b ti' ten Jesús: ―Ca' tac u sasirir a wich quire' caj a wacsaj ta wor ten. ");
INSERT INTO lacNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Rajen sasichʌjij u wich. Rajen seb caj sasichʌjij u wich caj say tu pach Jesús caj ya'araj: ―Jach caremech C'uj. Baxuc a mac a caj u yirob u jawʌr u wich caj ya'arajob xan: ―Jach caremech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Caj oc Jesús ich u cajar Jericó. Ti' man chumuc u cajar. ");
INSERT INTO lacNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ti' yʌn turi' xib neyʌn u taq'uin u c'aba' Zaqueo, u jach ts'urir yʌjc'ʌminob u taq'uin gobierno. ");
INSERT INTO lacNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zaqueo u c'at u yiric Jesús quir u c'ʌ'otic, chen mʌ' c'ucha'an yirej quire' a pimob, cabar u baquer. Mʌ' c'ucha'an yor yirej quire' ti' yʌn a pimob. ");
INSERT INTO lacNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Rajen caj u c'ʌnaj yacab caj naquij ich c'ʌb che' quire' ti' yʌn u berir quir u man Jesús soc yiric. Rajen pʌybej caj bin. ");
INSERT INTO lacNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ti' manij Jesús tu yʌn Zaqueo. Jesús caj u pʌctaj ti', caj ya'araj ti': ―Zaqueo ―quen―, seb a wemʌn quire' yʌn in jamach p'atʌr ta watoch. ");
INSERT INTO lacNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Rajen Zaqueo seb caj emij ich ru'um, qui' yor caj u qui' acsaj tu yatoch. ");
INSERT INTO lacNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A mac a caj u yirajob yocar Jesús ich yatoch Zaqueo caj u pacran arajob ich u rac'ob, tan u choctar yorob: ―Biquinin cu yʌn ocar aro' ich yatoch a mac yʌn u si'pir quir u wenʌn? ");
INSERT INTO lacNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Caj ch'icraj Zaqueo ʌcʌtan tu cotor mac soc chʌca'an yubicob. Caj ya'araj ti' Jaj Ts'urir: ―Iric Jaj Ts'urir ―quij―. Yʌn in ts'ic ti' in taq'uin ti' a otsiro'. Chumuc tu cotor a yʌn teno' quin bin in ts'ic ti'. Wa caj in tus ch'aj u taq'uin mac uch, quin bin in sutej ti'. Cuatro u tenin quin sutic ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús caj ya'araj ti': ―Baje'rer C'uj caj u ta'quech yejer tu cotor mac a ti' yʌn ta watoch. Jach taj u pararech a nunquir Abraham, quire' caj a wacsaj ta wor ti' C'uj an ten bic ic nunquir Abraham uch, caj u yacsaj tu yor. ");
INSERT INTO lacNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mʌ' ja wirej, a baxuquenechexo' caj u tuchi'ten C'uj ca' in wesej quin yajquintic mac a tabar u bin ich c'ac' quir in ta'quic a mac a cu yacsic tu yor ten. ");
INSERT INTO lacNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ti' toy cu yubicob an ten bic Jesús caj u tsicbʌtaj ti' Zaqueo. Jesús caj u yʌnxchun u camsic ti'ob quire' tabar u c'uchur ich u cajar Jerusalén. Rajen cu tucricob c'uchij tu q'uinin u reyinticob Jesús u ru'umin u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Rajen caj ya'araj Jesús: ―A mac jach no'j u tet ―quij―, caj bin ich tanxer ru'um soc u yacsa' rey. Caj ts'oc yacsa' rey caj wʌc'ʌs urij. ");
INSERT INTO lacNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Caj bin ich tanxer ru'um ca'ch caj u t'ʌnaj diez u c'urew caj u ts'aj jujuntur u c'urewob dos cientos pesos caj u ya'araj ti'ob: “C'ʌnej a je' taq'uina' ca' a jarex u jer taq'uin jach ya'ab hasta quin wu'ur.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jeroj caj binij. Ti' yʌn mac ich u cajar aro' caj p'acta'b ten u yet cajarob a cu bin yocar rey. Rajen caj u tuchi'taj mac tu pach aro' caj u ya'araj ti' rey: “Mʌ' in c'atob u yocar quir in reyinticob. Mʌ' a wacsic ti'.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Caj urij a je' xibo' caj u yʌnxchun u reyinticob caj u pʌyaj u c'urew a caj u ts'a ti' u taq'uin uch ca' tacob ʌcʌtan ich rey. Quire' u c'at yer mun t'aj u taq'uin jujunturob. ");
INSERT INTO lacNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A pʌybejo' tarij caj ya'araj: “Jach Ts'urir ―quij―, a taq'uin a ta ts'aj ten, dos cientos pesos uch, jach net'ajij baje'rer yʌn dos mil pesos.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","U jach ts'urir caj ya'araj ti': “Jach tsoy a beyaj, jach tsoy in c'urewech. In wer baje'rer ca qui' cʌnantic a ba' mʌ' ya'ab tech. Rajen quin bin in ts'ic diez cajarob quir u reyintiquech.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A ca'tur u c'urew tarij caj ya'araj ti': “Jach Ts'urir ―quij―. A taq'uin a caj a ts'aj ten dos cientos pesos, jach t'aj baje'rer yʌn mil pesos.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","U jach ts'urir caj ya'araj ti': “Tech quin bin in ts'ic cinco cajarob quir u reyintiquech.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Caj tar u jer u c'urew caj ya'araj ti': “Jaj Ts'urir ―quij―, je' a taq'uina'. Caj in tapa caj in ric'saj, ");
INSERT INTO lacNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","quire' caj in ch'aj sajaquir tech quire' ts'iquech. Quire' tech ca ch'ic a ba' mʌ' tech yʌnin. Quire' tech ca jaq'uic u nar mac cax tech mʌ' ta pʌc'aj.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","U jach ts'urir caj u ya'araj ti': “Jach c'as in c'urewech, a wʌc'ʌs t'ʌn tech a caj a wa'araj. Raji' cu bin u ta'quic a jo'r quire' a wer jach ts'iquen quire' a teno' quin ch'ic u taq'uin mac a caj u jaraj. Quire' quin jaq'uic u nar mac a mʌ' tin pʌc'aj. ");
INSERT INTO lacNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Rajen biquinin mʌ' ta majantaj in taq'uin ti' mac soc c'ʌs t'ajij in taq'uin ca' bin urquen. Ca' in ch'ic cax mʌ' ya'ab?” ");
INSERT INTO lacNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Caj ara'b ten u jach ts'urir ti' a mac ti' yʌn tu yicnʌn u c'urew a c'aso': “Taquej ti' u taq'uin a ti' yʌn ti' a dos cientos ca' a ts'ic ti' a mac yʌn ti' dos mil pesos.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","U c'urewob caj ya'arajob ti': “Jach Ts'urir ―quij―, toc yʌn ti' dos mil pesos a caj a p'ʌtaj ti'.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","U jach ts'uric caj ya'araj ti'ob: “Quin wac techex a mac a cu betic tsoy yejer a ba' quin ts'ic ti'. Je' in ts'ic ti' jach ya'ab. A maque' a mʌ' u c'ʌnic a ba' quin ts'ic ti'. Je' in ta'quic ti', cax mʌ' ya'ab yʌn ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Techex a werex a mac a cu p'actiquen ca'ch. Robob a mʌ' u c'at in wocar rey toc chuquejob ca' a quinsejob ʌcʌtan ten.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Caj ts'oc a ba' caj u camsa sam ich yatoch Zaqueo. Caj u p'ʌtaj u cajar Jericó quir u bin ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tabar u c'uchur ich u cajar Betfagé, baxuc ti' yʌn u cajar Betania, nʌts'a'an ti'ob yʌn u chan p'uc witsir u c'aba' Olivos. Quire' ra' u c'aba' u che'er a ti' yʌno'. Jesús caj u tuchi'taj ca'tur u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Caj ara'b ti'ob: ―Xenex ich u chan cajar c'ʌs bʌytʌc ca' bin ocaquechex ich u cajar. Je' a wirex chan tsimin ti' maca'an, mʌna' mac u cʌptanmʌn u pach. Pitex ti' ca' a paytex tera'. ");
INSERT INTO lacNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wa mac cu c'atic techex: “Biquinin ca pitiquex chan tsimin?” Caj a waquex ti' baxuc a je'ra': “Quire' ic Jaj Ts'urir u c'at u cʌptar tu pach”, quech ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","U camsʌwinicob caj binob caj yirajob ti' maca'an chan tsimin an ten bic Jesús caj ya'araj ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Caj u pitajob chan tsimin caj tarij a mac yʌnin caj u c'ataj: “Biquinin ca pitiquex chan tsimin?” ");
INSERT INTO lacNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Raji'ob caj u nuncajob: ―Quire' ic Jaj Ts'ur u c'at u cʌptar tu pach. ");
INSERT INTO lacNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A ca'tur u camsʌwinicob caj u paytajob chan tsimin caj binob u purej ich Jesús. Caj u jʌyajob u noq'uir u pach chan tsimin. U camsʌwinicob caj u yamtajob Jesús quir u cʌptar tu pach chan tsimin. ");
INSERT INTO lacNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Caj bin Jesús tu berir Jerusalén. Ti' cʌpa'an Jesús tu pach chan tsimin ich u bej tu cu man Jesús. A winiquir judíojo' caj u pitaj u ca' yarir u noc'ob quir u jʌyicob tu ber Jesús. Irej nanij cu yacsicob rey tu cajarob quire' qui' yorob yiricob. ");
INSERT INTO lacNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tabar u c'uchur Jesús ich u cajar Jerusalén. Ti' yʌn chan p'uc witsir Olivos tu cu bin yemantic Jesús. U camsʌwinicob a pimo' caj u yʌnxchun u qui'quinticob yorob. C'am caj ya'arajob: ―Jach caremech C'uj quire' caj in wirob jach carem a beyaj. ");
INSERT INTO lacNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","A pimo' caj ya'arajob: ―Tan in c'ujinticob a je' reya' a cʌpʌcbar tu pach chan tsimin a caj u tuchi'taj C'uj. Ca' ij carej ti': Bayo' C'uj, ti' yʌnech ich ca'anan quire' caj a quetquintaj ij corex yejerech ―baxuc caj ya'arajob a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ti' yʌn mʌ' ya'ab u winiquirob judío a fariseojo' ich a pimo', caj ya'arajob ti' Jesús: ―Arej u mʌcob u chi' a camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús caj u nuncaj ti'ob, caj ya'araj: ―Quin wac techex, wa cu mʌquicob u chi' a je' winica', jaj ixtʌcoj, a je' tunicha' je' u joc'ar u t'ʌn, tan ya'aric: “Quin c'ujintiquechob.” ");
INSERT INTO lacNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús tabar u nats'ʌr caj yiraj u cajar Jerusalén caj oc'nʌjij Jesús quire' otsir yiric, a mac ti' yʌn tu cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Caj ya'araj Jesús: ―Jaj ix tʌcoj wa ja toc erex bic c'ucha'an a worex a quetquintiquex a worex yejer C'uj chen baje'rer C'uj mʌ' u cha'ic a wiriquex ba' a ber techex. ");
INSERT INTO lacNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Quire' ca' bin c'uchuc tu q'uinin a mac a cu p'actiquechex cu bin u ts'ʌpquinticob tunich soc mʌ' tu ca puts'urex. Quire' caj u toc bʌcris ts'ʌptajob tunich. ");
INSERT INTO lacNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cu bin u quinsicob techex yejer a pararobex. Cu bin u rʌc jubsicob u tunichir a cajarex cu bin u rʌc pich'inticob tunich. Baxuc cu bin u beticob techex quire' mʌ' ta wacsajex ta worex ti' C'uj quire' caj u tuchi'tajen a teno' a baxuquenechexo' ti' techex quir in yamtic techex. ");
INSERT INTO lacNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Caj oquij Jesús ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u yʌnxchun u joc'sic a mac cu canicob u ba'tac tu japnin carem naj ba'iri' a mac a cu mʌnicob ba'. ");
INSERT INTO lacNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús caj ya'araj ti'ob: ―Ti' ts'iba'an ich u t'ʌn C'uj, cu ya'aric: “In watoch a je'ra' quir u tar mac u t'ʌnic C'uj”, chen techex caj a waysaj irej wa tu cu much'quinticob u bʌj a cu yac'rʌ' ba'. ");
INSERT INTO lacNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús caj ts'oc u joc'sic a mac a cu canicob ba' ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Rajra' Jesús cu camsic a mac a cu tar ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Chen u jach ts'urirob u sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés yejer u jach ts'urir u winiquirob judío u c'at u quinsicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Chen mʌ' yerob bic tabar cu bin u quinsicob ti' quire' a pimo' u jach c'at yubicob u t'ʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jesús ti' yʌn turi' u q'uinin ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío, caj u camsaj ti'ob. Baxuc caj u tsec'taj ti'ob u jach tsoyir u t'ʌn C'uj. Caj c'uchob u jach ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés yejer u ts'urirob u winiquirob judío a nuxibo'. ");
INSERT INTO lacNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Caj ya'arob ti': ―Mac caj u ts'ajaj a muc' caj a c'ʌmaj? Mac arej tech quir a camsicob quir a tsec'ticob? Arej tenob mac caj u ya'araj tech ca' a camsej ti'ob? ");
INSERT INTO lacNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús caj ya'araj ti'ob: ―Baxuc ten bin in ca' in c'atic techex. Nunquex ten. ");
INSERT INTO lacNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Arex ten mac tuchi'tej Juan quir yacsic ja' tu jo'r mac? C'uj wa tuchi'tej Juan wa xib tuchi'tej? ");
INSERT INTO lacNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Caj u tucrajob bic tabar cu bin u nunquicob ti'. Caj pacran arajob: ―Wa quij aric ti', C'uj caj u tuchi'taj Juan quir u yacsic ja' tu jo'r mac, je' ya'aric to'on: “Biquinin mʌ' ta wacsajex ta worex ti'?” ");
INSERT INTO lacNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wa quij aric xib caj u tuchi'taj, a pimo', je' u ch'inico'onob quire' yerob taj tuchi'ta'b ten C'uj Juan quir u tsec'tic t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Caj u nuncob: ―Mʌ' in werob mac tuchi'tej Juan quir u yacsic ja' tu jo'r mac. ");
INSERT INTO lacNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús caj ya'araj ti'ob: ―Baxuc techex, mʌ' a wa'aric mac tuchi'tej Juan, baxuc ten ―quij Jesús―, mʌ' in wac techex mac caj u ya'araj ten quir in camsic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús caj u yʌnxchun u camsic a pimob caj u camsaj baxuc a je'ra' soc yerob a maque' a mʌ' u c'at u yacsicob tu yor ti' quire' bin u ca' ich c'ac'. Rajen caj u camsaj a je'ra': ―Ti' yʌn mac uch caj ts'oc u ch'ʌquic u che'er u cor caj u rʌc tocaj u robirir caj u pʌc'aj u yaq'uir u wich uva. Caj ts'oc u pʌq'uic, caj u ts'aj ti' mac quir u cʌnanticob. U bo'orir u cor ca' bin c'uchuc tu q'uinin u t'aquic u wich uva. Cu ts'icob ti' u ts'urir u cor jun xot' u wich. U ts'urir caj bin nach ama'an caj urij. ");
INSERT INTO lacNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Caj c'uchij tu q'uinin cu t'ocar u wich uva. U ts'urir caj u tuchi'taj u c'urew tu yʌn a mac a cu cʌnanticob u corir uva quir u c'at junxot' u wich uva u bo'orir u cor. Chen a mac a cu cʌnanticob u cor caj u raxajob u c'urew caj wʌc'ʌs tuchi'ta'b mʌ' tu ts'ajajob ti' u wich uva. ");
INSERT INTO lacNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","U jach ts'uriro' caj u ca' tuchi'taj u jer u c'urewo'. A mac cu cʌnanticob u corir u wich uva caj u raxob u c'urew. Caj u p'astajob xan caj u puts'ob ca' xic mʌ' tu ts'ajajob ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","U jach ts'urir ca' u wʌc'ʌs ca' tuchi'taj u jer u c'urewo' chen a mac a cu cʌnanticob u corir u wich uva, baxuc xan, caj u jʌts'ajob hasta em u q'uiq'uer caj u pich'intajob tu nʌc' c'axir u corob. ");
INSERT INTO lacNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’U jach ts'urir u cor u wich uva caj ya'araj: “Ba' quin bin in betej?” U bʌjir cu t'ʌn tu junan: “Je' in tuchi'tic in parar in jach yaj, jaj ixtʌcoj cu sʌjticob yʌjcʌnʌnyʌjirob u pach u corir uva.” ");
INSERT INTO lacNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Chen a mac a cu cʌnanticob u pach u cor uva caj u yirob u tar u parar u ts'urir: “Ara' cu tar u pararo', ra' cu bin u ch'ic u cor u tet ca' bin quimqui'.” Baxuc caj ya'arob ich u rac'ob: “Ca' ij quinsej soc to'on ca' bin ic ch'ic u cor.” ");
INSERT INTO lacNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ti' taro' caj u quinsajob u parar u ts'urir caj u joc'sajob u pich'intej ich nʌc' c'ax. Ba' cu bin u betej u jach ts'urir ti' yʌjcʌnanyʌjirob u pach u corir uva? ");
INSERT INTO lacNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Je' u tar u jach ts'urir quir u joc'sic u quinsej quir u ts'ic u cor ti' u jer mac. Caj yubob ya'aric u winiquirob judío caj ya'arob: ―Jaj ixtʌcoj mʌ' u tar to'on. ");
INSERT INTO lacNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús caj u pʌctaj u wichob caj ya'araj ti'ob: ―Arex ten ajera' ba' cu ya'aric ich u t'ʌn C'uj tu ts'iba'an? Tan ya'aric: A teno' iren a yoc najo' soc u chich tar u muc' naj, chen a ray yoc najo' pich'ita'b ten yʌjc'ʌxirob naj uch. Quire' mʌ' u c'at, chen caj u wʌc'ʌs chucajob quir u c'ʌxicob yatoch soc u chichtar u muc'. ");
INSERT INTO lacNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A mac a mʌ' u yacsic tu yor ten baje'rer. Raji' irej a mac cu nacch'ʌtic tunich caj yajij yoc. Chen ca' bin c'uchuc tu q'uinin u xur t'ʌn, a mac a mʌ' tu yacsaj tu yor ti' C'uj, raji' irej mac cu rubur tunichir tu yoc'or cu maxʌre' toc ramʌn ich ru'um. ");
INSERT INTO lacNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ra'iri' u q'uinin u jach ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés u c'at u chuquicob Jesús. Quire' yerob a ba' caj u camsaj sam quire' Jesús yer mʌ' tu yacsicob tu yorob. Mʌ' tu jach chucob Jesús quire' cu ch'ic saquirob a pimob. Mʌ' ja wirej, a pimob u nec'at yubic u tsicbar Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tan u ch'ucticob u chuquej Jesús, rajen caj u tuchi'tajob mac quir u tus waytarob u t'ʌn soc cu tus ta'quicob u jo'r ich gobernador. U c'at u ta'quic u jo'r ti' gobernador soc u quinsa'. Rajen yet tarob a mac a cu tus aric tsoy yorob. Soc u tus aric a ba' cu yubic u tsicbar Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Rajen caj u c'atob ti' Jesús: ―In wʌjcamsʌyʌjirech ―quij―, in werob taj a ba' ca wac. Baxuc taj a ba' ca camsic ti' u t'ʌn C'uj. Mʌ' a coyen chich aric ti' mac quet ca wa'aric ti'. Quire' baxuc taj ca camsic tenob a ba' u c'at C'uj ti' tenob. ");
INSERT INTO lacNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","In c'atob in wer wa tsoy in bo'oticob in ru'um ti' rey? Wa mʌ' tsoy in bo'oticob in ru'um? ");
INSERT INTO lacNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús caj u yubaj ba' c'as cu tucricob tu yorob, caj ya'araj ti'ob: ―Biquinin ca tarex a tumtiquex in wor? ");
INSERT INTO lacNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Esej ten a taq'uin turiri' ca' in wirej. Caj u yesob ti' Jesús. Jesús caj u ya'araj ti'ob: ―Mac jot'a'an u yochiri'? Ba' quiri' u c'aba' ts'iba'an ti'? Raji'ob caj u ya'arob ti': ―Ra' u yochir u rey César, jot'a'an ich sʌc taq'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Caj ya'araj Jesús ti'ob: ―Taj a ba' ca waquex. Rajen ca' a quibʌquex a ba' cu yac techex u rey, César, baxuc xan, ca' a quibʌquex a ba' cu ya'aric C'uj techex. ");
INSERT INTO lacNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mʌ' c'ucha'an yor yubic ba' cu ya'aric Jesús ich a pimo' soc u tus ta'quicob u jo'r Jesús. Chen jaca'an yorob a ba' yubicob ya'aric Jesús. Rajen ts'oc u t'ʌnob. ");
INSERT INTO lacNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Baxuc xan, tarob u winiquirob judío a saduceojo'. Aro' cu ya'aric mʌ' u riq'uir mac tu quimirir. Caj tarob u c'atej ba' ti' Jesús; caj ya'arajob ti' Jesús: ");
INSERT INTO lacNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―In wʌjcamsʌyʌjirech ―quij―, ic nunquir Moisés caj u ts'ibtaj to'on uch a ba' ca' ic betej. Caj ya'araj wa ju mam cu quimin, cu p'atʌr u rac', mʌna' u parar yejer caj quimin u mam, tu junan. Caj ya'araj Moisés, ra' u yits'in u mam, raji' cu bin u ch'ic u raq'uintej a mu'. Soc yiric wa je' u pararancʌr yejer soc u ch'isic u parar, irej waj u tus parar u sucu'un uch. ");
INSERT INTO lacNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A sucu'unbir yʌn seis yits'inob. A sucu'unbir, raji' tu yʌn ch'aj u rac' hasta quimin, mʌna' u parar. ");
INSERT INTO lacNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A its'inbiro' raji' u ta'quic u chu'ch u sucu'un. Raji' caj u ch'aj u rac' u sucu'un, mʌna' u parar xan. ");
INSERT INTO lacNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A jach ca' its'inbiro', raji' caj u ta'ca u chu'ch u ca' sucu'un. Raji' caj u ch'aj u rac' u ca' sucu'un. Mʌna' u parar xan. Hasta nup u rʌc ch'ic u yits'inob u mam hasta rʌc quimob, mʌna' u parar. ");
INSERT INTO lacNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Caj c'uchij tu q'uinin u quimin a xquico' caj quimij. ");
INSERT INTO lacNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ca' bin riq'uic tu quimen, mac cu bin u ch'ic u raq'uintej quire' siete caj u ch'aj u mam. ");
INSERT INTO lacNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Rajen Jesús caj u nuncaj ti'ob, caj ya'araj: ―A te' ich yoc'ocab cu ch'ic u rac' mac, baxuc xquic cu ch'ic u mam xan. Baxuc a pararex xan cu ch'ic u rac', baxuc xquic a pararex xan, cu ch'ic u mam. ");
INSERT INTO lacNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ca' bin ts'ocac u riq'uir mac tu quimen, a mac jach tsoyo' cu bin cha'bir yocar ten C'uj ich ca'anan. Munt q'uin ti' yʌnob. Mʌ' u ch'ic u rac' a ich C'ujo'. Mʌ' ju bin u ch'ic u mam. ");
INSERT INTO lacNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Quire' a taro', mʌ' ju bin quimen, irob baxucob yʌjmasirob u t'ʌn C'uj. Quire' u pararob C'uj quire' ric'ob tu quimen ten C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mʌ' wa c'aj techex a ba' caj u ts'ibtaj Moisés uch a caj u yiraj tu cu yerar c'ac' ich chan che'er uch. Caj ara'b ten C'uj ti' Moisés. “A teno' u C'ujirenob a nunquirex Abraham yejer a nunquirex Isaac yejer a nunquirex Jacob.” Rajen ij quer cu bin riq'uir mac tu quimirir. ");
INSERT INTO lacNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A C'ujo', raji' u C'uj tu cotor mac. Raji' u C'uj a mac cuxa'an. Baxuc xan, raji' u C'uj a mac quimen quire' a quimeno' cuxa'an ʌcʌtan ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mʌ' ya'ab ti' yʌnob yʌjcamsʌyʌjirob u t'ʌn Moisés caj ya'arob ti': ―In wʌjcamsʌyʌjirech, taj a ba' caj a wa'araj ti' u winiquirob judío a saduceojo'. ");
INSERT INTO lacNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Quire' sajaquir u ca' u c'atob ti' Jesús. Rajen caj u p'ʌtajob u c'ata ba'. ");
INSERT INTO lacNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús caj u c'ataj ti'ob: ―Bic tabar cu ya'aricob a pimob yejer u ts'urirob u winiquirob judío, u parar u nunquir David. Raji' Cristo a mac tuchi'ta'b ten C'uj? ");
INSERT INTO lacNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mʌ' ja wirej, u bʌjiri' David, caj u ts'ibtaj ich u ju'unin Salmos ich a uchben u t'ʌn C'ujo'. Caj ya'araj: Ic Jach Ts'ur C'uj, quij David, caj u ya'araj ti' in Jach Ts'ur: “Tar a cutar, quij C'uj, tin noj soc p'eri' quic reyinticob mac. ");
INSERT INTO lacNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Soc p'eri' quic reyinticob mac hasta cu c'uchur tu q'uinin quin rʌc ch'ersic a mac a cu p'actiquech.” Baxuc caj ara'b ti' ic nunquir David ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jesús caj u c'ataj ti'ob caj ya'araj: ―A je' u t'ʌn C'uj cu yesic to'on David caj u t'ʌnaj a Cristojo', in Jach Ts'ur, quij David. Rajen biquinin ca waquex u parar David a Cristojo' quire' wa raji' u Jach Ts'urir, quet ba'iri'? ");
INSERT INTO lacNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Jesús cu tsicbar ti' u camsʌwinicob p'eri caj yubajob a pimo': ―Qui' cʌnantajex a bʌj soc mʌ' a cʌniquex yʌjcamsʌyʌjirob u t'ʌn Moisés. Mʌ' ja wirej, yʌjcamsʌyʌjirob u t'ʌn Moisés. Jach tsoy u noc' cu manob soc u tus turicob u rac'ob, jach no'job aro'. Qui' yorob yiricob baxucob. Jach qui' yorob yiricob u t'ʌnʌn ten u rac'ob tu cu naj bin u mʌnicob yo'och quire' cu yiricob tus no'job aro'. Baxuc cu tetic u cutanob tu cu cutar a jach no'jo' tu cu naj c'ujinticob C'uj. Baxuc tu cu qui'qui' janʌnob soc u tus irir jach no'job. ");
INSERT INTO lacNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mʌ' ja wirej. yʌjcamsʌyʌjirob u t'ʌn Moisés cu tus aricob ti' a u quimenob u mam. Soc u tus ch'ic yatoch yejer u ba'tac cax yʌn tu yatoch. Jach ama'an u ts'ocar u t'ʌnicob C'uj soc u rac'ob cu tus tucricob cu qui' c'ujinticob C'uj. Jach manan cu bin ts'abʌr u muc'yajob ten C'uj quire' cu beticob aro' cax yerob u t'ʌn C'uj. Chen u jerob mac mʌ' neyaj cu bin muc'yajob. ");
INSERT INTO lacNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús caj u yiraj tan u but'icob u taq'uin a mac neyʌn u taq'uin tu cuchir tu cu naj but'icob u taq'uin tu cu naj c'ujinticob C'uj u winiquirob judío. Ra' taq'uin ti' carem naj tu cu naj c'ujinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Caj u yiraj xan xquic a quimen u mamo' otsir caj u but'aj u majan taq'uin, ca'tur chʌc taq'uin a mʌ' coji'. ");
INSERT INTO lacNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Caj ya'araj Jesús ti': ―Taj quin wac techex. A je' xquica' a quimen u mamo' cax otsir. Chen caj u but'aj ca'tur u chʌc taq'uin a mʌ' coji' chen ʌcʌtan tu wich C'uj co'oj caj u but'aj. Chen u rac'ob cax ya'ab caj u but'ajob chen ʌcʌtan tu wich C'uj mʌ' co'oji'. ");
INSERT INTO lacNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","A mac neyʌn u taq'uinob caj u but'ob u taq'uin tu nanij cu but'icob u taq'uin tu cuchir tu cu naj c'ujinticob C'uj. Quire' jach manan ya'ab caj u but'ob quire' jach manan t'aj u taq'uin chen ra' caj u but'ob quire' mʌ' u rʌc c'ʌnicobe' u taq'uin. Chen a xquico' a otsiro' caj u toc rʌc but'aj ti'o' u taq'uin cax mʌna' tu cu mʌnic yo'och. ");
INSERT INTO lacNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ti' yʌn mʌ' ya'ab mac caj ya'araj ti' Jesús: ―Ira wirej, jach tsoy tu ts'ʌpa'an u tunichir carem naj. Baxuc u tunichir ti' C'uj a ts'abij ten, mʌ' ya'ab u winiquirob judío, quire' cu sʌjticob C'uj. Chen Jesús caj u ya'araj ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―A ca wiriquex carem naj ca' bin c'uchuc tu q'uinin je' u rʌc jubsa' ten mac. Cu bin u rʌc pipich'inticob, mʌ' ju bin p'atʌr ca'tur ts'ʌpric. ");
INSERT INTO lacNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","U camsʌwinicob caj u c'atob ti' Jesús: ―In wʌjcamsʌyʌjirech ―quij―, ber ca' bin jubuc a caj a wa'araj? Ba' cu bin u yesic to'on xan wa tabar u xur t'ʌn? ");
INSERT INTO lacNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús caj ya'araj ti'ob: ―Qui' cʌnantex a bʌj ―quij Jesús―, quire' je' u tar mac u tusiquechex. Mʌ' a quibiquex aro'. Quire' cu bin ya'aricob: “A teno' Cristojen, caj u tuchi'ten C'uj.” Tan ya'aric: “Tabar u xur t'ʌn.” Chen mʌ' ja yʌn sayʌrex tu pach. ");
INSERT INTO lacNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mʌ' ja ch'iquex sajquir ―quij Jesús―, wa tan a wu'yiquex tan u quinsicob u bʌj. Cax wa cu wu'yiquex bin u ca' quinsicob u bʌj. Raji' cu yʌnxchun u tar u quinsicob u bʌj chen mʌ' toy xuruc t'ʌni'. ");
INSERT INTO lacNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús caj u ya'araj ti'ob: ―Mʌ' toy c'uchuc tu q'uinin u xur t'ʌni' A je' u ru'umin tu cʌja'anob mac. Je' u ts'ictar mac ich u ru'umin tu cʌja'anob mac. Baxuc xan, mac ich u chan cajar. Bin u caj ts'ictarob yejer mac ich u jerob u chan cajarob. ");
INSERT INTO lacNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mʌ' toy xuruc t'ʌn, cax cu chen pec u ru'umin. Jach c'am cu pec tu cʌja'anob mac. Yʌn a ru'umin mʌ' u pec juntur u cajar u ru'umin tu cʌja'anob mac. Yʌn u ru'umin je' u pec u ru'umin tu cʌja'an mac. Yʌn u q'uinin cu bin yubicob wi'ij. An bic cu cʌnic u yajirir seb cu cʌnicob. Ra' cu bin u rʌc man tu cotor. Je' u ch'icob sajquir mac ca' bin yirob a ba' u ber ich ca'anan a ba' cu bin yesej C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Mʌ' c'uchuc tu q'uinin aro' cu bin chuquex a pach quire' caj a wacsajex ta wor ten ―quij Jesús―. Baxuc cu bin u c'ubiquechex yejer u ts'urirob tu cu naj c'ujinticob C'uj u winiquirob judío. Baxuc xan, quir u mʌquiquexob tu cu ma'cʌr winic. Ti' cu bin u chopʌytiquexob quir u bin u puriquechex ʌcʌtan rey yejer ich gobernador quir u taquiquex a jo'r. ");
INSERT INTO lacNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Wa ra' u q'uinin cu beticob techex aro', ra' u q'uinin c'ucha'an a wor a waquex ti'ob u jach tsoyir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mʌ' a tucriquex wa cu tar u chuquex a pach. Baxuc mʌ' a tucriquex ba' ca bin a wa'arex ti'ob. Mʌ' toy xiquex ʌcʌtan a mac a cu bin u ta'quic a jo'r. ");
INSERT INTO lacNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","A teno' ―quij Jesús―, je' in ts'ic techex a t'ʌnex quire' a ne'er a nuquiquex u t'ʌnob. Je' a nunquiquex ti' soc mʌ' c'ucha'an yor u pʌq'uiquex a pach a mac u p'ec yiriquechex. ");
INSERT INTO lacNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mʌ' chen a mac cu p'actiquechex cu bin u chuquiquex a pachex. A tet xan, yejer a nʌ', cax a bʌjob xan, cax a mac a u jach yajechex xan, cu bin u chuquiquex a pachex, tan u c'ubicob techex. Baxuc je' u quinsiquechex xan, mʌ' ya'abi' ich techex. ");
INSERT INTO lacNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Quire' techex caj a wacsajex ta wor ten tu cotor mac cu bin u p'actiquechex. ");
INSERT INTO lacNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Qui' cʌnex a je'ra'. Mʌ' ja wirej, a C'ujo' cu cʌnantic techex soc mʌna' ba' u ber techex, mʌ' ja bin satʌr turi' u tsotser a jo'r. ");
INSERT INTO lacNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Je' u ts'abʌr techex a cuxtarex munt q'uin wa rajra' ca muc'tiquex a ba' cu tar techex tu cu chuquicob a pachex. ");
INSERT INTO lacNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Quire' wa ca wiriquex yʌjquinsirob mac jach pim tan u bʌcristicob u cajar Jerusalén. A werex c'uchij tu q'uinin u rʌc jubsicob u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Barej ca wiriquex bʌcrisa'an u cajar Jerusalén. Arej ti' a mac ti' yʌn ich u ru'umin Judea ca' rʌc puts'ucob ich wits. Arej ti' a mac ti' yʌn ich u cajar Jerusalén ca' putsuc xan. Arej ti' a mac ti' yʌn ich tancab u cajar Jerusalén. Arej ti'ob mʌ' u puts'urob ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ra'iri' u q'uinin c'uchij tu q'uinin u bo'oticob u bo'orir u si'pir ti' C'uj u winiquirob judío ich u cajar Jerusalén quire' baxuc caj u ya'araj tu ts'iba'an u t'ʌn C'uj. Rajen cu bin u nupsej. ");
INSERT INTO lacNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jach otsir a xquico', ra' u q'uinin jach na'aj. Baxuc xquic cu ts'ic u chu'ch u chan ti'ar. Mʌ' ja wirej, tu cotor mac a ti' yʌn tu ru'umin Judea, cu bin ts'abir u muc'yajob ten C'uj. Quire' ts'iquij a C'ujo' quire' caj u yiraj mʌ' quibob u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yʌn cu bin ch'ʌcbirob u car ten yʌjquinsirob winiquirob ich u winiquirob judío. Yʌn ya'ab xan cu bin purbirob ich u jer ru'umin quir u c'anʌn beyajob tu cu binob ich tu cotor u cajarob ich yoc'ocab u winiquirob judío. Ti' cu bin ts'urinbir u cajar Jerusalén ten a mʌ' u winiquirob judío hasta c'uchij tu q'uinin u ts'ocar u ts'urinticob u ts'urirob u ru'umob. ");
INSERT INTO lacNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Caj ya'araj Jesús ti' u camsʌwinicob: ―Ra' u q'uinin ca' bin ts'ocac u ts'urinticob a mʌ' u winiquirob judío. A ba' u ber ich ic yum, baxuc ich ic nʌ'. Baxuc ich a sabo', cu bin u jac'ʌr yor tu cotor mac. Mʌ' yerob mac ba' cu bin u beticob. Ca' bin yubejob u jum c'ac'nab, jach c'am yejer u yamin xan. Cu bin u ch'icob sajquirob. ");
INSERT INTO lacNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ra'iri' u q'uinin tu cotor mac a ti' yʌn ich yoc'ocab cu bin u ch'ic sajquirob ca' bin jac'ʌcob yorob. Quire' a ba' u ber ich yoc'ocab. Quire' a C'ujo' cu bin u rʌc siptic a sabo'. ");
INSERT INTO lacNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ra'iri' u q'uinin mac ti' yʌnob ich yoc'ocab cu bin yiricob in tar ich u muyarir ca' bin taquen yejer in muc' soc yer tu cotor mac jach no'jen a teno'. Quin bin in tar yejer jach manan u sasirir C'uj xan. A teno' baxuquenechexo'. ");
INSERT INTO lacNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Barej u q'uinin cu yʌnxchun arayo' chichquintej a worex ―quij Jesús―, qui'quintex a worex quire' tabar u c'uchur tu q'uinin in ca' ur quir in ta'quiquechex ti' a c'aso'. ");
INSERT INTO lacNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús caj u camsaj baxuc a je'ra' caj ya'araj: ―C'aj techex ca' bin a wirex u che'er higuera yejer tu cotor che'. ");
INSERT INTO lacNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cu ts'ocar u joc'ar u mumun re', tabar u yocar yaxq'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Baxuc xan, ca' bin a wirex a ba' u ber ich ic yum. Baxuc ich ic nʌ'. Baxuc ich a sabo', je' a werex c'uchij tu q'uinin u tar C'uj quir u reyinticob. ");
INSERT INTO lacNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Taj quin wa'aric techex ―quij Jesús―, cu yʌn tar tu cotor ba' a caj in wa'araj techex. Mʌ' toy quimiquechex a mac cuxa'an baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Je' u c'uchur tu q'uinin a ca'anano' cu bin ts'ocar baxuc cu bin ts'ocar u ru'umin. Chen in t'ʌn a caj in wa'araj techex a C'ujo' cu bin u nupsic. ");
INSERT INTO lacNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Qui' cʌnantex a bʌj. Mʌ' a jen janʌnex, mʌ' ja wuq'uiquex quir a carchʌjʌrex. Mʌ' ja man a tucriquex bic tabar a jariquex a taq'uinex. Mʌ' ja wirej, quire' a mac a cu jen janʌn yejer a cu yuq'uic quir u carchʌjʌrob yejer mac a cu tucric u nejaric u taq'uin ca' bin taquen a teno' u q'uinin mʌ' tan u pajicob quir u bin ich ca'anan quire' seb quin bin ur. ");
INSERT INTO lacNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Baxuc a mac mʌ' yerob C'uj ich yoc'ocab cu bin u jac'ʌr yorob ca' bin uruquen wa ra' u q'uinin mʌ' tan u pajicob in wur. Baxuc a bʌc'o' ca rejiquex mʌ' yer. ");
INSERT INTO lacNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chen techex rajra' ca cʌnantiquex a bʌj. Rajra' ca t'ʌniquex C'uj soc ca' bin c'uchuc tu q'uinin tabar u xur t'ʌn cu bin u yamtiquechex C'uj quir a muc'tiquex a ba' u ber techex. Soc a tarex ʌcʌtan tu yʌnen quire' a teno' baxuquenechexo'. ");
INSERT INTO lacNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","U burur q'uin Jesús caj u camsaj a pimo' ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Chen oq'uin rara' cu bin ich u jo'r p'uc wits u c'aba' Olivos. Ti' p'atij ich u jo'r wits. ");
INSERT INTO lacNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A'ac'bir tu cotor mac cu binob ich tu cu naj c'ujinticob C'uj u winiquirob judío quir yubic u tsicbar Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tabar u c'uchur tu q'uinin u qui'qui' janʌnob u winiquirob judío ra' u q'uinin cu janticob yoch pan a mʌ' u sipe'. Pʌcha'an u c'aba' pascua quire' ra' u q'uinin caj u potmastaj yʌjt'ʌnir C'uj uch soc mʌ' u quimin chan xib chichin. ");
INSERT INTO lacNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","U ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés, u c'at u muc u chuquicob Jesús. Baxuc u c'atob quire' cu sʌjticob a pimob. Caj u cʌxtajob mac quir u c'ubic quinsbir Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","A Judaso' caj u ts'urintaj quisin raji' pʌcha'an u c'aba' Iscariote, raji' turi' ich u doce u camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas caj u p'ʌtaj Jesús yejer u yet camsʌwinicob caj bin ich u jach ts'urirob sacerdote yejer u capitán policía caj pacran tsicbanʌjij yejerob soc yerob bic tabar cu c'ubic Jesús ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Caj qui'jij yorob u jach ts'urirob sacerdote rajen caj u toc arob je' u boticob tu c'ubij Jesús ten Judas. ");
INSERT INTO lacNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas caj ya'araj: ―Tsoy. Caj u yʌnxchun u chanber tucric u c'ubic Jesús ra' u q'uinin mʌ' ti' yʌn a pimo', soc mʌ' yerob wa bin u ca' chucbir Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Caj c'uchij tu q'uinin a cu janticob yoch pan a mʌ' u sipe'. Ra' u q'uinin xan cu quinsicob yʌrʌc' tʌmʌn yuc u chan ar soc u c'ʌ'otic bic C'uj caj u ta'caj u nunquir u winiquirob judío ich u ru'umin Egipto. ");
INSERT INTO lacNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Rajen Jesús caj u tuchi'taj Pedro yejer Juan caj ya'araj ti'ob: ―Joq'uenex ca' a toc chʌquex ij cochex quir ij qui' janʌnex quir ij c'ʌ'otic u q'uinin pascua. ");
INSERT INTO lacNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Robob caj ya'arob: ―Tub a c'at ic chʌquex? Arej to'on tuba? ");
INSERT INTO lacNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús caj ya'araj ti'ob: ―U'yex ba' quin waquex techex. Ca' bin oquechex ich u cajar, je' a wiriquex xib turiri', u c'ochmʌn u p'urir yoch ja'. Sayenex tu pach hasta ca wiric tu cu yocar tu yatoch a ca' ts'ap yatocho'. Quet a wocarex yejer. ");
INSERT INTO lacNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Arej ti' mac yʌnin yatoch: “Ij cʌjcamsʌyʌjirex caj u ya'araj tenob ca' in c'atejob a watoch junxot' soc p'eri' quin janʌnob yejer in camsawinic quir in c'ʌ'oticob u q'uinin pascua.” ");
INSERT INTO lacNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A mac yʌnin yatoch ―quij Jesús―, je' u yestic techex junxot' yatoch tu ca' ts'ap, toc yʌn u pojche'ir tu cu janʌn. Toc yʌn u cutan xan. Ti taro' ca chʌquiquex ij cochex. ");
INSERT INTO lacNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Caj binob u camsʌwinicob Jesús caj yirob an ten bic Jesús caj u ya'araj ti'ob, caj u chʌcob yo'och quir u qui' janʌnob quir u c'ʌ'oticob u q'uinin pascua. ");
INSERT INTO lacNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Caj c'uchij tu q'uinin u janticob yoch u q'uinin pascua caj curaj Jesús baxuc u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús caj u ya'araj ti' u camsʌwinicob: ―Caj in jach pachtaj in jantej yoch tu q'uinin pascua yejerechex. Mʌ' toy muc'yajnʌquen. ");
INSERT INTO lacNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Quin wac techex ca' bin ts'ocac in jantic a je'ra'. Mʌ' jin yʌn yʌn ca' jantic hasta ca' bin c'uchuc tu q'uinin cu reyinticob C'uj. A ra' u q'uinino' quin ca' jantic. ");
INSERT INTO lacNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Caj ts'a'b ti' Jesús u c'ab uva ich ruch caj u pe'aj. Caj u ya'araj ti' C'uj: ―Bayo' C'uj. Caj ts'oc ya'aric aro' caj u ts'aj ti' u camsʌwinicob, caj ya'araj ti'ob: ―Ca' ca' xot' a wuq'uiquex. ");
INSERT INTO lacNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Quin wac techex tin toc uc'aj a je'ra'. Mʌ' in yʌn yʌn uq'uej hasta ca' bin c'uchuc tu q'uinin u reyinticob C'uj. Je' in ca' uq'uique'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Caj u chuca yoch pan caj u mʌchaj caj u ya'araj: ―Bayo' C'uj. Caj ts'oc ya'aric aro' caj u xat'aj caj u jʌsej ti'ob u camsʌwinicob. Caj u ya'araj ti'ob: ―A je' a woch pana', raji' in winquirir quir in c'ubʌr techex soc in quinsa'. Baxuc yʌn a jantiquex soc a c'ʌ'otiquex u q'uinin tu quimen. ");
INSERT INTO lacNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Caj ts'oc u rʌc janʌnob yoch u q'uinin pascua ca' u pe'aj a rucho' xan caj ya'araj ti'ob: ―Tucrex a je'ra' u c'ab uva, raji' in q'uiq'uer. Irej bin u ca' joc'ar in q'uiq'uir tu quin quinsa', u bo'orir a si'pirirex. Soc toc ric'ben an ten bic caj in toc araj techex. Mʌ' ja wirej, u t'ʌn Moisés ruc'sabij soc yʌn u jer ric'ben a jach manan tsoy. ");
INSERT INTO lacNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Caj ya'araj Jesús: ―Taj quin wac techex a mac cu bin u c'ubiquene' p'eri' cu janʌn yejero'on baje'rer. Raji' cu bin u c'ubiquen ti' mac quir in quinsa'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A teno', yʌn in quinsa' a teno', baxuquenechexo'. An ten bic caj u toc araj C'uj uch. Chen jach otsir a mac a cu c'ubiquen. ");
INSERT INTO lacNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Caj u yʌnxchun u pacran c'aticob u camsʌwinicob Jesús. Caj ya'arajob mac cu bin c'ubic Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","U camsʌwinicob caj u pacran ts'ictarob soc yiricob a mac jach no'j ich u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús caj ya'araj ti'ob: ―Ich yoc'ocab a reyo' ti' jujuntur u ru'umin, cu ts'urintic u winiquirob. U c'at u winiquirob ca' ya'arejob ti' ca' yamtac a reyo'. Baxuc u ca' ts'urir u c'at yubejob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aro' mʌ' baxuc ca betiquex. A mac jach no'j ich techex, arej mʌ' u pachtej yubej ya'ara' jach no'jech ten u rac'ob. Wa ca wocar techex a ts'urintic tu cu c'ujintic C'uj toc yʌn a yamtiquex a rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Qui' tucrex a ba' quin wac techex. Mac jach no'je', wa ra' cu janʌn ich u pojche'ir u janʌn? Wa ra' jach no'j a cu beyaj ti'? Mʌ' ja wirej, a mac a cu cutar tu pojche'ir u janʌn, raji' jach no'j. Chen a teno' cax a ts'urirenex ti' yʌnen ich techex quir in beyaj techex. ");
INSERT INTO lacNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jesús caj u ya'araj ti' u camsʌwinicob: ―Techex rajra' ti' yʌnechex tu yʌnen mʌ' ja p'ʌtenexi' p'eri' quic muc'tiquex a ba' cu tar to'onex uch. ");
INSERT INTO lacNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","An ten bic in Tet C'uj caj u teten quir in reyintic. Baxuc techex in tetiquechex quir a wocarex a reyintiquex. ");
INSERT INTO lacNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Baxuc quin tetic techex soc p'eri' quic janʌnex. Baxuc p'eri' ij cuc'urex tu pojche'ir ca' bin c'uchuc tu q'uinin in reyintic. Quin bin in wacsiquechex a reyintiquex a wet winiquirob judío a doce u yo'nen u winiquirob Israel. ");
INSERT INTO lacNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús caj ya'araj ti' Pedro: ―Wa mac cu chachtic yo'och cu p'atʌr u bʌq'uer chen u soro' cu puric. Baxuquech Simón ―quen―, a quisino' caj u c'ataj ti' C'uj quir u tumtic a wor soc yiric wa taj caj a wacsaj ta wor. ");
INSERT INTO lacNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Chen a teno' caj in t'ʌnaj C'uj ti' tech soc mʌ' a p'ʌtic a wacsic ta wor ten. Ca' bin ts'ocac a c'axic a wor toc chichquintej yor a wet camsʌwinicob a te' yʌna'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro caj ya'araj: ―Jaj Ts'urir ―quij―, tin toc ch'uctic in bin yejerech tu cu ma'cʌr winic cax quet ij quimin. ");
INSERT INTO lacNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús caj ya'araj ti' Pedro: ―Taj quin wa'aric tech. Mʌ' toy c'ʌynʌc cax baje'rer ac'bir. Mʌna' u nup ca bin a wa'aric mʌ' a c'ʌ'oreni'. Cu ts'ocor a wac mʌ' a c'ʌ'oreni' cu bin u c'ay cax. ");
INSERT INTO lacNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús caj u c'ataj ti' u camsʌwinicob: ―Caj in tuchi'techex ca'ch quir a tsec'tiquex in t'ʌn. Cax mʌna' a chimex. Cax mʌna' a taq'uinex cax mʌna' a xanabex. Yʌn wa ba' a c'atex ca'ch? U camsʌwinicob caj u nuncajob: ―Mʌna' ba' in c'atob. ");
INSERT INTO lacNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús caj ya'araj ti'ob: ―Chen baje'rer, wa yʌn a taq'uinex toc ch'a'ex. Baxuc wa yʌn a chimex toc ch'a'ex. Wa mʌna' techex a mascab canex u ca' yarir a noc' quir a mʌnic turiri' a mascab. ");
INSERT INTO lacNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mʌ' ja wirej ―quij Jesús―, ti' ts'iba'an ich u t'ʌn C'uj uch, caj ya'araj: “A winiquirob caj ya'araj chen c'as a ray xibo'.” Aro' ―quij Jesús―, quin wac techex. Yʌn in nupsej quire' tabar in quinsa'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Caj ya'arob u camsʌwinic: ―Jaj Ts'urir ―quij―, a je' mascaba' ca'tura'. Jesús caj ya'araj ti'ob: ―Ti' ti' a mascabex. ");
INSERT INTO lacNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús caj joc' ich u cajar caj binij an ten bic nanij u bin ich u p'uc witsir u c'aba' Olivos. Yet binac u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Caj c'uchij tu nanij u bin, caj ya'araj ti' u camsʌwinicob: ―T'ʌnex C'uj soc mʌ' u cha'ba' u tar tumbir a worex. ");
INSERT INTO lacNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesús caj joc' nanach an ten bic mun nachir cu rubur tunich a cu ch'inin ten mac. Caj xonrʌj quir u t'ʌnic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jesús caj ya'araj: ―In Tetech C'uj ―quij―, wa ra' cu qui'quintic a wor quir a ts'icten a ba' in c'at, ruc'sej a je' muc'yaja' a cu bin tar ten. Wa ra' a c'at ca' muc'yajnʌquen je' in muc'yaje' quire' in c'at in betic a ba' a c'at tech. ");
INSERT INTO lacNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Caj tar turiri' yʌjmasir u t'ʌn C'uj ich Jesús quir u ts'abʌr u muc' ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Caj jach muc'yajnʌjij Jesús caj u yʌnxchun u muc'yaj jach manan tu cu t'ʌnic C'uj. Tan u jach chichquintic u t'ʌnic C'uj hasta cu q'uicab. U q'uicabe' irej u q'uiq'uer cu ch'ojar ich ru'um. Jach carem u ch'ojar. ");
INSERT INTO lacNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Caj riq'uij tub xonrʌj tu cu t'ʌnic C'uj. Caj bin ich u camsʌwinicob caj yiraj tan u wenʌnob quire' mʌ' qui' yorobi'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesús caj ya'araj ti'ob: ―Mʌ' a yʌn wenʌnex. Ca' a ch'ictarex soc a yʌn t'ʌniquex C'uj soc mʌ' u cha'bʌr u tar tumbir a worex. ");
INSERT INTO lacNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ti' toy cu tsicbar Jesús. Caj c'uchob a pimob quire' pay ten Judas. Raji' turiri' ich camsʌwinicob a docejo'. Caj u nʌts' u bʌj Judas quir u ts'uts'ic u p'uc Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Caj ya'araj Jesús ti' Judas: ―Tan wa ja ts'uts'ic in p'uc quir a c'ubiquen ti' a mac a cu p'actiquenob? A teno' baxuquenechexo' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","U camsʌwinicob a ti' yʌn yicnan Jesús caj u yirob ba' u ber ti', caj u ya'arob ti' Jesús: ―Arej to'on Jaj Ts'urir ca' ts'icaco'on yejerob ca' ic ch'ʌquej u car yejer mascab. ");
INSERT INTO lacNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Turiri' u camsʌwinicob caj u ch'ʌcaj u xiquin, raji' u c'urew u jach ts'urir sacerdote. Caj u rac ch'ʌctaj u xiquin, tu noj. ");
INSERT INTO lacNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús caj ya'araj ti': ―Tsire'ej, mʌ' a ch'ʌquiquex. Jesús caj u tʌra u xiquin u c'urew u jach ts'urir sacerdote caj jawij u xiquin tu ch'aquij. ");
INSERT INTO lacNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús caj ya'araj ti'ob u jach ts'urirob sacerdote yejer u yʌjt'ʌnin policía ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío, yejer u jach ts'urirob u cajar u winiquirob judío. Quire' tarob u chuquejob Jesús. Caj ya'araj Jesús: ―Tarechex a chuquiquenex yejer a mascabex yejer che'. Irej wa yʌja'crʌyʌjiren ba', ca chuquiquenex. ");
INSERT INTO lacNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rajra' ti' yʌnen ich carem naj uch. Tan in camsicob, chen mʌ' ta chuquenex. Chen tarechex a chuquenex quire' c'uchij tin q'uin. An ten bic C'uj caj ya'araj uch. C'uchij tin q'uin xan, quire' baxuc u c'at a quisino' a mac a cu ts'urintic a mac a cu man ich yac'birir quire' ra' u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Caj u chucob Jesús caj u mʌchob u c'ʌb caj binob u purej ich yatoch u jach ts'urir sacerdote. Chen Pedro caj tar tu pach Jesús chen nach cu xur. ");
INSERT INTO lacNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Caj c'uchob caj ocob tu re'a'an u chi' naj. Ti' tu t'ʌbaj u q'uich chumuc. Caj curajob tu q'uich. P'eri' yejer Pedro. ");
INSERT INTO lacNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ti' yʌn xquic u c'urew u jach ts'urir sacerdote caj irir Pedro ti' cura'an q'uich ich chi' c'ac'. Caj u qui' pʌctaj caj u ya'araj ti' a mac ti' yʌnob: ―A je' xiba' u yet man Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro caj ya'araj: ―Xquic ―quen―, mʌ' in c'ʌ'ormʌni'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sasam caj irir Pedro ten u jer caj ara'b ten xib ti' Pedro: ―A techo' ―quij―, caj a chaj nupintej Jesús ca'ch, ti' yʌnech yejer Jesús uch. Chen Pedro caj ya'araj ti' xib: ―Mʌ' teni'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Caj manij turiri' hora caj c'uch u jer xib caj chich ara'b ti' u rac'ob: ―Taj a je' xiba' ti' yʌn ich Jesús uch. Quire' ti' u tar ich u ru'umin Galilea quire' baxuc u t'ʌnobob. ");
INSERT INTO lacNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chen Pedro caj ya'araj ti' xib: ―Mʌ' in wer mac a ca wa'arico'. Ti' toy cu tsicbar Pedro, seb caj c'aynʌj cax. ");
INSERT INTO lacNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A Jaj Ts'uro' caj u sut u bʌj u pʌcaj Pedro. Pedro caj c'aj ti' a ba' ara'b ti' ten Jesús ca'ch. An bic caj ya'araj Jesús: “Mʌ' toy c'aynʌc a caxo' mʌna' u nup ca bin a wac mʌ' a c'ʌ'oreni'.” ");
INSERT INTO lacNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Caj joc' Pedro ich yatoch u jach ts'urir sacerdote caj chich oc'nʌjij quire' tucur u ca'. ");
INSERT INTO lacNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A policíajo' a cu beyajob ich carem naj tu cu naj c'ujinticob C'uj a ju chucmʌnob Jesús caj u yʌnxchun u p'asticob Jesús tan u jʌts'icob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Robob tu pixob u wich Jesús caj u raxob caj u ya'arob ti': ―Quire' yʌjtseq'uirech u t'ʌn C'uj, arej tenob mac tu raxech? ");
INSERT INTO lacNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Caj ya'arob ya'ab ba' tu cu p'asticob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Caj sasij caj u much'quintajob u bʌj u ts'urirob u winiquirob judío. Quet baxucob u ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés. Caj u much'quintajob u bʌj quir u ta'quicob u jo'r Jesús. Robob caj u pʌyob ca' tac Jesús. Caj c'uchij Jesús caj u c'atob ti' Jesús: ");
INSERT INTO lacNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Wa Cristojech caj u tuchi'tech C'uj, arej tenob? Chen Jesús caj u nuncaj ti'ob, caj ya'araj: ―Wa quin wa'aric Cristojen caj u tuchi'ten C'uj, mʌ' ja bin a wacsiquex ta worex ten. ");
INSERT INTO lacNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wa quin c'atiquex techex ba', mʌ' a bin a nunquiquex ten. ");
INSERT INTO lacNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ca' bin ts'ocac in riq'uir tin quimirir ti' quin bin in cutar tu noj C'uj soc ten cu bin u ts'urintiquen tu cotor mac. P'eri' quin ts'urintic yejer C'uj a caj u tuchi'tajen C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tu cotor u ts'urirob u winiquirob judío caj u c'atajob: ―Arej tenob wa ju jach pararech C'uj? Jesús caj u nuncaj ti'ob: ―An ten bic caj a wa'arex sam, raji'en. ");
INSERT INTO lacNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Caj ya'arob: ―Ba' wir u jer yʌjta'quic u jo'r. Tic toc u'yaj. Poch' u ca' quire' u bʌjiri' caj u ya'araj. ");
INSERT INTO lacNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","P'eri' caj rʌc ric'ob caj binob purej Jesús ʌcʌtan Pilato. ");
INSERT INTO lacNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","U ts'urirob u winiquirob judío caj u yʌnxchun u ta'quicob u jo'r Jesús caj ya'arajob: ―Ts'oc in wiricob soc u quinsa' Jesús. Mʌ' ja wirej, caj u p'usaj yorob u winiquirob judío. Quire' cu ya'aric: “Mʌ' tsoy a bo'otiquex u taq'uin a ru'umex ti' u rey César.” Baxuc xan, u bʌjiri' cu ya'aric: “Cristojen, a caj u tuchi'ten C'uj quir u reyintiquen mac.” ");
INSERT INTO lacNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato, caj u c'ata' ti': ―Arej ten wa ju reyech u winiquirob judío? Jesús caj u nuncaj ti': ―An ten bic tech caj a wa'araj sam, raji'en. ");
INSERT INTO lacNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato caj u ya'araj ti' u jach ts'urirob sacerdote yejer a pimob caj u much'quintob u bʌj: ―Mʌ' jin wiraj u si'pir a je' xiba'. ");
INSERT INTO lacNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Caj u p'encʌch arob ba' u winiquirob judío: ―Caj u jach p'usaj yorob u winiquirob judío tu cu camsic ti'ob. Caj u yʌnxchun u camsic ich u ru'umin Galilea. Baxuc ich tu cotor u cajar Judea hasta c'uchij tera' xan. ");
INSERT INTO lacNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato caj yubaj a ba' caj u ya'arajob yʌjta'quirob u jo'r Jesús. Caj u c'ataj ti'ob: ―Ti' wa ju tar a je' xiba' ich u ru'umin Galilea? ");
INSERT INTO lacNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Caj u yuba ya'ara' ti' u tar ich u ru'umin Galilea. Caj ya'araj ca' xic purbir Jesús ich Herodes quir u ta'quicob u jo'r. Quire' raji' gobernador ich u ru'umin Galilea. Quire' ti' c'uchij Herodes ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Caj c'uchij Jesús ich Herodes, jach qui' yor Herodes quire' uch u chen c'at yiric Jesús quire' cu pachtic yirej ca' esac ti' carem beyaj Herodes. Quire' cu yubic u tsibʌticob a pimob a ba' cu betic Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Cax ya'ab ba' caj u c'ataj Herodes ti' Jesús. Mʌ' baj c'ʌs nunca'b ti'. ");
INSERT INTO lacNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","U jach ts'urirob sacerdote yejer yʌjcamsʌyʌjirob u t'ʌn Moisés caj tarob ch'ictarob ʌcʌtan Herodes quir u ta'quicob u jo'r Jesús. C'am u t'ʌnob. ");
INSERT INTO lacNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes, caj u p'astaj Jesús yejer tu cotor u ts'urirob soldadojo' caj u chejtajob ti'. Caj u tʌcajob u noc' a tsoyo' soc irej rey. Caj ts'oc u tʌquicob u noc' caj wʌc'ʌs tuchi'ta'b Jesús ich Pilato. ");
INSERT INTO lacNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ra'iri' u q'uinin Pilato yejer Herodes caj u yajquintajob u bʌj quire' a ucho' cu p'acticob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato caj u much'quintaj u jach ts'urirob sacerdote yejer u jach ts'urirob u cajar u winiquirob judío yejer a pimob. Tu cu ta'quicob u jo'r Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilato caj u ya'araj ti'ob: ―Tarex a puric a je' xiba' ʌcʌtan ten. Caj a wa'arajex caj u p'usaj yor u winiquirob judío. Caj ts'oc in cʌxtic in wirej wa yʌn u si'pir, mʌ' tin wiraj u si'pir turiri' a ca ta'quiquex u jo'r. ");
INSERT INTO lacNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A mʌ' Herodeso' caj u yiraj u si'pir xan. Rajen caj u wʌc'ʌs tuchi'taj to'onex. Mʌna' ba' caj u betaj quir u quinsa'. ");
INSERT INTO lacNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Baje'rer quin bin in wac u jʌts'ob u pach. Cu ts'ocar u jats'ʌr ca' sipac ca' xic Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Caj ya'araj baxuco' quire' nanij u sipic mac Herodes, rajra' cu c'uchur tu q'uinin u qui'qui' janʌn, ra' u q'uinin pascua. ");
INSERT INTO lacNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chen tu cotor mac caj u c'amquintajob u t'ʌn, caj ya'arajob: ―Quinsej a ra xibo'. Ij c'at ca' a siptej Barrabás. ");
INSERT INTO lacNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","A je' Barrabása' caj chuquij caj maquij tu cu ma'cʌr winic uch quire' caj u p'usaj yorob mac ich u cajar quir u joc'sicob u ts'urir u cajar. Bayiri' caj u quinsaj mac xan. ");
INSERT INTO lacNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato u c'at u siptic ca' xic Jesús, rajen tu ca' t'ʌnaj a pimo'. ");
INSERT INTO lacNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","A pimo' caj u ca' purajob u t'ʌn. C'am caj ya'arob: ―Sinej ich cruz. Ca' ten caj u ca' arob: ―Sinej ich cruz ―quij. ");
INSERT INTO lacNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mʌna' u nup u tenin caj ya'araj Pilato: ―Biquinin yʌn in sinic ich cruz? Arex ten ba' c'asir caj u betaj? A teno' mʌ' jin wiraj u si'pir quir u quinsa'. Rajen quin bin in wa'aric u jats'ʌr u pach. Cu ts'ocar u jats'ʌr u pach, cu chabʌr ca' xic. ");
INSERT INTO lacNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Chen a pimo' caj u ts'ʌraj u pach Pilato, caj u chich araj ti' Pilato: ―Sinej ich cruz. Quire' c'am yawʌt t'ʌnob. ");
INSERT INTO lacNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato caj u quibaj u t'ʌn. Rajen Pilato caj u ya'araj ca' quinsac Jesús soc u betic a ba' u c'atob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato caj u siptaj Barrabás, a mac chuca'an uch cax ra' caj u p'usaj yorob u rac'ob quir u joc'sicob u ts'urir u cajar cax caj u quinsaj mac. Chen Jesús caj u c'ubaj ca' quinsa' ten u soldado quire' baxuc u c'at u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","U soldado u winiquirob romano, caj u joc'sajob Jesús quir u quinsicob. Caj u chucob turiri' xib u c'aba' Simón. Ti' u tar caj urij tancab tu cajar. Ti' u tar uch ich u cajar Cirene uch. Caj ts'ar u pach u c'ochej u cruz Jesús. Pachir u bin a Simóno'. Jesús pʌyber. ");
INSERT INTO lacNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Baxuc xan, ya'ab mac caj binob tu pach Jesús. Ti' yʌn xquic ich a pimob a cu tarob tu pach Jesús. Awʌt oc'ar u ca'ob quire' cu tucricob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús caj u sut u bʌj u pʌctic u pach quir u t'ʌnic a xquico': ―A techexo' u xquiquirechex u cajar Jerusalén. Mʌ' a wac'tiquenex. Ca' a wactex a wʌc'ʌs bʌjiri'ex yejer a pararex. ");
INSERT INTO lacNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Taj quin wac techex je' u c'uchur tu q'uinin cu bin ya'aric mac: “Jach tsoy a xquico' a mʌ' pararnʌjij. Quire' mʌ' c'ucha'an yor ti'. Bayiri' a mʌ' tu rochaj u parar. Bayiri' jach tsoy a xquico' a mʌna' u chan och quir u ts'ic chu'ch.” ");
INSERT INTO lacNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ra'iri' u q'uinin cu bin u chich aric ca' quimic, irej a cu ya'aricob mac. Ca' rubuc a witso' ich yoc'orob ca' maxʌcob. Bayiri' cu t'ʌnicob p'uc witso' ca' mucucob, ten p'uc wits. ");
INSERT INTO lacNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wa cu quinsiquenob cax mʌna' in si'pir chen jach manan cu bin u muc'yajob ich u winiquirob judío quire' c'as caj u betajob. ");
INSERT INTO lacNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Caj bin purbir Jesús quir u quinsa', yet binacob ca'tur xib a cu yacrʌ ba' quir u quinsa'ob xan. ");
INSERT INTO lacNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Caj rʌc c'uchob tu pʌcha'an u c'aba' u baquer u jo'r mac quire' a ru'umo' irej u baquer u jo'r mac. Ti' caj u bʌjob ich cruz, Jesús a baxuc a cu yacrʌ ba' ca'turo' caj sinob ich u cruzob. Turi' tu noj Jesús, turi' tu ts'ic Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús caj ya'araj ti' C'uj wa ber tan u bajarob ich cruz: ―In Tetech ―quij―, jawse u si'pirob a mac a cu p'actiquenob quire' mʌ' yerob ba' cu beticob ten ―quij Jesús. U soldado u winiquirob romano caj u jʌsob u noc' Jesús caj u yʌrʌc'tajob chan tunich quir yiric mac cu bin u ch'ic u noc' Jesús, baxuc nanij u beticob uch. ");
INSERT INTO lacNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tarob ya'ab mac quir u chen pʌcticob u quimin Jesús. U ts'urirob u winiquirob judío caj u yuts'ajob u ni' quire' tan u p'asticob Jesús, caj ya'arob: ―U jer caj u tacaj; chen u bʌjiri' mʌ' tu tacaj u bʌj, wa jach jaj a Cristojo', a tuchi'ta'b ten C'uj quir u taquic tu cotor mac ca' u wʌc'ʌs tac u bʌj xan. ");
INSERT INTO lacNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","U soldado u winiquirob romano, caj u chejtajob Jesús quire' caj nʌts'ob u bʌj ich Jesús caj u ts'ajob ti' Jesús u c'ab uva a pʌje' ca' u yuq'uej. ");
INSERT INTO lacNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Caj ya'arob ti': ―Wa ju jach u reyech u winiquirob judío, toc tac a bʌj baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ti' ts'iba'an a je' t'ʌna' ich c'ʌs chumuc u cruz u jo'r Jesús soc yer biquinin sinij ich cruz. Caj ts'ibta'b: “A je' xiba' u rey u winiquirob judío.” ");
INSERT INTO lacNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Turiri' cu yacrʌ ba' ti' sina'an ich Jesús caj u p'astaj Jesús tan ya'aric: ―Wa jach taj Cristojech toc tac a bʌj yejerenob baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chen u jer u yet bʌja'an Jesús caj u q'ueyaj u yet acrʌ ba' caj ya'araj ti': ―Mʌ' tan a ch'ic sajʌquir ti' C'uj. Mʌ' wa quet caj bʌjo'on yejer Jesús quir ij quimin xan? ");
INSERT INTO lacNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","A to'ono' ―quij ya'ara' ti'―, taj caj u tacaj ic jo'rob, rajen tan ic jach muc'yaj quire' ra' u bo'orir ic si'pir. Chen a je' xiba' mʌna' ba' caj u betaj quir u quinsa'. ");
INSERT INTO lacNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Caj ya'araj ti' Jesús: ―Jesús ―quij―, chan c'ʌ'ote ten ca' bin c'uchech tu ca reyintic. ");
INSERT INTO lacNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús caj ya'araj ti': ―Taj quin wa'aric tech baje'rer ti' yʌnech yejeren ich C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Caj c'uchij c'ac'chunq'uin caj ac'ʌ'chʌjij ich tu cotor ru'umin. Hasta las tres caj sasichʌjij. ");
INSERT INTO lacNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ti' toy ac'bir ic yum caj jatij u noq'uir tub t'ina'an ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Rajen jat chumuc u noq'uir tub t'ina'an quire' caj u yesaj to'on bic tabar ic bin ʌcʌtan C'uj. Mʌ' ja wirej, a ucho' mʌ' c'ucha'an yor mac u je'ic u noq'uir quir u yocar ʌcʌtan C'uj tu cu ya'aricob ti' yʌn C'uj. Chen raji' cu yocar a ucho' u jach ts'urir sacerdote. Teni' cu yocar turiri' yaxq'uin. ");
INSERT INTO lacNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ra'iri' u q'uinin caj quimij Jesús caj jat u noq'uir ti' t'ina'an. C'am caj awʌtnʌjij Jesús caj ya'araj: ―In Tet C'uj ―quij―, tan in ts'ic tech in pixam quir a cʌnantic. Caj ts'oc ya'aric caj quimij. ");
INSERT INTO lacNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A yʌjt'ʌnino' cien soldado u winiquirob romano, caj yiraj ba' u ber ti' Jesús caj u c'ujintaj C'uj caj ya'araj: ―Jach jaj a je' xiba' mʌna' u si'pir toc taj yor. ");
INSERT INTO lacNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ya'ab mac caj tarob uch quir yiricob u quinsa'r Jesús. Caj ts'oc yiricob ba' u ber caj sutnʌjob tu yatochob. Caj u pʌxajob u semob quire' tan yesicob tucur u ca'ob quire' baxuc nanij u beticob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tu cotor mac a yet manob Jesús uch. Baxuc yejer a xquicob a tarob tu pach Jesús ich u cajar Galilea. Caj yirob ba' u ber ti' Jesús nanach chica'anob caj yirob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ti' yʌn ca'ch turiri' xib, ti' u tar ich u cajar Arimatea, ra' u wa'an u ru'umin Judea. José u c'aba'. Raji' turiri' u ts'urir u winiquirob judío. Jach tsoy yor José, José cu quibic a ba' ts'iba'an ich u t'ʌn Moisés. ");
INSERT INTO lacNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mʌ' ja wirej, a Joséjo', tan u pajic u q'uinin cu tuchi'tic mac C'uj quir u reyinticob u winiquirob judío. Raji' cu pajic José. A Joséjo', mʌ' quet yor u c'ubic quinsbir Jesús yejer u yet jach ts'urirob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Caj bin José ich Pilato quir u c'atic u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato caj u ts'aj u baquer Jesús ti' José quir u but'ic u baquer ich japnin tunich José, cu ya'araj ti' mac: ―Ensej u baquer Jesús. Caj ts'oc u yensa' caj u tapaj yejer sʌc noc', lino u c'aba' u noq'uir, jach co'oj aro'. Caj bin u but'ej ich japnin tunich tu ric'ben, mʌna' mac u but'mʌni'. ");
INSERT INTO lacNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ba' u ber ti' Jesús. Ra' u q'uinin cu chʌquic yoch quir u qui'qui' janʌnob u q'uinin pascua. Raji' tabar u c'uchur tu q'uinin quir u jesicob u bʌj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A xquico' a tarob ich u pach Jesús caj ruq'uij ich u ru'umin Galilea caj binob tu pach José soc u yiricob u but'ur u baquer Jesús ich japnin tunich. ");
INSERT INTO lacNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","A xquico' caj ts'oc yiricob u but'ur u baquer Jesús. Caj urob ich yatoch ich u cajar Jerusalén. Caj u mʌnob a qui' u boque' soc u cho'icob ich u baquer Jesús. Raji' u ts'ac mirra u c'aba' yejer u ts'ac aloe u c'aba' quire' nanij u winiquir judío, u cho'ic ich u baquer a mac quimeno'. A xquico' caj u jesajob u bʌj ti' u beyaj. Quire' ra' u q'uinin tu cu jesicob u bʌj u winiquirob judío. An ten bic cu ya'aric tu ts'iba'an u t'ʌn Moisés. ");
INSERT INTO lacNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","U q'uinin u yʌnxchun semana, jach a'ac'bir a xquico' caj wʌc'ʌs binob tu but' u baquer Jesús. Caj u cuchob a qui' u boque a caj u mʌnajob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Caj c'uchob a xquico' caj yirob toc bʌc'ʌsa'an u tunichir u mac u jor tu but'ij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Caj ocob tu japnin tunich tu but'ij Jesús. Chen mʌ' caj u yirob u baquer. ");
INSERT INTO lacNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A xquico' xaca'an u tucurob quire' yirob mʌna' u baquer Jesús. Seb caj yirob ti' yʌn ca'tur xib tu ch'ica'anob xquic. U buquimʌnob u noc' jach sʌc t'inen. ");
INSERT INTO lacNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","A xquico' caj chinrajob u jo'r quire' sajʌcob. A xibo' caj ya'araj ti'ob: ―Ca tarechex a cʌxtex tu but' u baquer Jesús? ");
INSERT INTO lacNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mʌ' ti' yʌn a tera' baje'rer quire' riq'uij tu quimen, cuxa'an baje'rer. Mʌ' wa c'ajtechex ba' caj u ya'araj techex uch. Ti' toy yʌnechex ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","C'ajtechex caj ya'araj: “Yʌn in quinsa'r, a teno', quij Jesús, quire' caj u tuchi'ten C'uj a baxuquechexo'. A mac jach c'aso', raji' cu bin u bʌjiquenob ich cruz. Ca' bin ts'ocac in quinsa' quin bin in riq'uir, mʌna' u nup u q'uinin.” Baxuc caj ya'araj Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","A xquico' caj u c'ʌ'otajob u t'ʌn Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Caj urob tu bin yirob tu but' u baquer Jesús caj binob ich a oncejo' u camsʌwinicob Jesús. Baxuc ti' yʌnob a yet manob Jesús uche'. Caj u ya'arob ti' a ba' caj u yirob yejer a ba' caj u yubob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A xquico' a mac binob ca'ch quir ya'aricob ti' u camsʌwinicob cuxa'an Jesús. Raji'ob, María, a cu tar ti' u cajar Magdalena, yejer Juana, yejer María, u nʌ' Jacob yejer u jer mʌ' ya'ab xquic. ");
INSERT INTO lacNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Chen u camsʌwinicob mʌ' ju quibob a ba' caj ara'b ti'ob: “Riq'uij Jesús.” Cu chen tucricob a ba' caj u yubob ya'aric a xquic quire' yerob u sosoc a'bar. ");
INSERT INTO lacNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","A Pedrojo', seb caj riq'uij caj u c'ʌnaj yacab caj bin yiric tu but'ij u baquer Jesús. Caj c'uchij caj u tac ch'enaptaj caj u yiraj u noq'uir tu top u baquer uch. Chen u noq'uir yʌn ich u way. Caj sutnʌj tu junan ich yatoch jach jac'a'an yor a ba' caj u yiraj. ");
INSERT INTO lacNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ra'iri' u q'uinin ca'turob u camsʌwinicob Jesús, caj binob tu berir u cajar Emaús. Yʌn once kilómetros u nachir ti' u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Caj pacran tsicbnʌjob tu cu binob ich bej. Caj tsicbnʌjob ti' a ba' u ber ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ti' toy cu tsicbarob ich bej tan u chich tsicbarob. Jesús caj u c'ʌs nʌts'aj u bʌj ich u camsʌwinicob soc quet u binob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","U camsʌwinicob mʌ' yerob wa Jesús quire' mʌ' ts'a'b u t'ʌnin u c'ʌ'ota'r ten u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús caj u c'ataj ti'ob: ―Ba' ca chich tsicbʌtiquex ich a ber? Biquinin tucurex a caj tu ca binex ich bej? ");
INSERT INTO lacNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Turiri' ich a winico' u c'aba' Cleofas caj u nuncaj ti' caj ya'araj: ―A je' q'uina' tu cotor mac ich u cajar Jerusalén yerob ba' u ber a tera'. Cax jamach ti' yʌnech ich u cajar Jerusalén. Tin t'ʌn jari' teche', mʌ' a wer ba' u ber Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús caj ya'araj: ―Ba' u ber tera'? Raji'ob caj u nuncajob ti', caj ya'arajob. Mʌ' wa ta wu'yaj ba' u ber ti' Jesús a cu tar ich u cajar Nazaret? Raji' yʌjtseq'uir u t'ʌn C'uj. A Jesúso' caj u qui'quintaj yor C'uj. Baxuc a pimo' caj u qui'quintaj yorob. Quire' caj u yirob u carem beyaj Jesús. Baxuc a ba' caj u camsaj. ");
INSERT INTO lacNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mʌ' wa caj a wu'yaj ―quij ya'ara' ti'― u jach ts'urirob sacerdote yejer u jach ts'urirob u cajar a nuxibo', bic caj u c'ubajob Jesús ti' Pilato caj ts'oc u ta'quicob u jo'r. Caj ara'b u bin bʌjbir ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Baje'rer ―quij ya'ara' ti'―, yʌn tres u q'uinin tu ts'oc u bajʌr Jesús ich cruz. A tenob tan in pajicob wa raji' tuchi'ta'b ten C'uj quir u taquico'onex u winiquirob judío ti' u winiquirob romano. ");
INSERT INTO lacNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bayiri' ―quij ya'araj―, xquic a p'eri'o' yejero'on caj u jac's in worob quire' a'ac'bir caj binob yirejob tu but' u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Caj c'uchob mʌ' ju yirob u baquer, caj sutnʌjob tu yʌnenob caj tsicbʌnʌjob tenob an ten bic tu jach irob yʌjmasir u t'ʌn C'uj a mac caj u ya'araj ti'ob cuxa'an Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bayiri' xib xan tres a p'eri'o'enob yejerob caj bin yirob tu but' u baquer. Caj yirob taj a ba' ara'b ten a xquicobo'. Chen mʌ' ju yirob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesús caj ya'araj ti'ob: ―Biquinin jach chichex a jo'rex quire' qui' ts'abir ca wacsiquex a worex quire' mʌ' ja wacsajex ta worex a ba' ts'ibta'b ten yʌjtseq'uirob u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A werex jach taj yʌn u muc'yaj Cristo quire' baxuc u c'at C'uj soc u bin sʌjta'bir ten tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesús caj u qui' camsaj ti'ob a ba' ara'b ti' tu cotor ich u t'ʌn C'uj ti' u wʌc'ʌs bʌjiri' ich tu cotor u t'ʌn C'uj. Caj u yʌnxchun tub ts'iba'an ich u t'ʌn Moisés. Caj ts'oc u qui' camsic ti'ob a ba' ara'b ti' ten Moisés. Caj u qui' camsaj ti'ob a ba' ara'b ti' ten yʌjtseq'uirob u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tabar u c'uchurob tu cajar tu cu binob ca'ch. Jesús irej wa bin u ca' u potmastej u cajar. ");
INSERT INTO lacNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Chen u camsʌwinicob caj u chich arob ti' caj ya'arob: ―P'aten yejero'on, tabar u bin q'uin quire' tabar u yac'birchʌjʌr. Rajen Jesús caj oquij quir u p'atʌr yejerob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Caj ts'oc u cutarob quir u janʌnob. Jesús caj u chucaj u yoch pan caj ya'araj ti' C'uj: ―Bayo' ―quij. Caj u xat'aj caj u ts'aj ti'ob quir u janticob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Caj ts'a'b u t'ʌnin quir u c'ʌ'oticob Jesús seb caj binij Jesús mʌ' ju yirob tu binij. ");
INSERT INTO lacNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Caj u pacraj arob: ―Jach qui' ij cor ca'ch caj u tsicbʌta to'on ich bej, caj u qui' tsicbʌta to'on u t'ʌn C'uj, tu ts'iba'an. ");
INSERT INTO lacNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","A ca'turo' u camsʌwinicob Jesús, ra'iri' u q'uinin seb caj wʌc'ʌs urob ich u cajar Jerusalén. Caj c'uchob tu much'a'an a oncejo' u camsʌwinicob Jesús yejer u jerob u rac'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","A oncejo' caj ya'arajob ti' a tan tu c'uchurob: ―Jach jaj ic Jaj Ts'ur, riq'uij tu quimen quire' Jesús caj tu yes u bʌj ti' Simón. ");
INSERT INTO lacNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A tan tu c'uchurob caj u tsicbʌtajob a ba' u ber ti'ob ich u berir Emaús. Caj u c'ʌ'otajob Jesús caj xat'aj u yo'och pan ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ti' toy cu tsicbarob a ba' u ber ti'ob. Seb caj ch'icraj Jesús chumuc tu yʌnob u camsʌwinicob. Caj ara'b ti'ob ten Jesús: ―Ca' qui'ac a worex ten C'uj ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chen u camsʌwinicob jach jaq'uij yorob caj u ch'aj sajquirob. Cu tucricob ca'ch caj u yirob u pixam a mac quimeno'. ");
INSERT INTO lacNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús caj ya'araj ti'ob: ―Biquinin sajquechex? Biquinin ca tucriquex ta worex: Mac a je'ra'? ");
INSERT INTO lacNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pʌctex a wirex in c'ʌb yejer in woc soc a werex ten. Tʌrex a wu'yex wa ten quire' u pixam mac mʌna' u bʌq'uer an ten biquen yʌn in bʌq'uer. Mʌna' u baquer an ten biquen. ");
INSERT INTO lacNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Caj ts'oc ya'aric ti'ob aro' caj u yesaj u c'ʌb ti'ob soc yiricob tu bʌja'an yoc yejer u c'ʌb. ");
INSERT INTO lacNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Quire' jach qui' yorob, rajen mʌ' ju quibob wa raji' quire' jac'a'an yorob xan. Jesús caj ya'araj ti'ob: ―Chan chuquej ten a wochex in jantej. ");
INSERT INTO lacNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Robob caj u ts'ajob ti' u xet'er c'ac'bir cʌy quir u chi'ic caj u yʌrob ti' cab. ");
INSERT INTO lacNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús caj u c'ʌmaj caj u chi'aj cʌy ʌcʌtan tu yʌnob baxuc cab caj u mʌc'aj. ");
INSERT INTO lacNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jesús caj ya'araj ti'ob: ―A ba' caj in wa'araj techex ti' yʌnen ta wicnʌnex ca'ch. Caj in wa'araj techex ca'ch, yʌn in nupsic tu cotor a bar ts'iba'an ich u t'ʌn Moisés. Baxuc a ts'iba'an ich u t'ʌn yʌjtseq'uirob u t'ʌn C'uj. Baxuc a ba' ts'iba'an ich u t'ʌn salmos. ");
INSERT INTO lacNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ra'iri' u q'uinin Jesús caj u ts'aj ti'ob ca' u najtejob a ba' ts'iba'an ich u t'ʌn C'uj ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesús caj ya'araj ti'ob: ―Baxuc a je' ts'iba'an ti': “Cristo a tuchi'ta'b ten C'uj. Yʌn u quimij, caj ts'oc u quimij cu man mʌna' u nup u q'uinin cu riq'uir ti' u quimirir, quire' a Cristojo', u parar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A techexo' yʌn a bin a tsec'tiquex in t'ʌn ich tu cotor u cajar tu cʌja'an mac. Tar ca yʌnxchun a tsec'tiquex ich u cajar Jerusalén. Ca' a tsec'tex ti' ca' u yʌn c'axejob tu yorob soc u p'ʌticob u c'asirob soc C'uj cu jawsiob u si'pirob.” ");
INSERT INTO lacNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ca' xic a waquex ti' mac a ba' caj a wirex, baxuc a ba' u ber teno'. ");
INSERT INTO lacNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Baxuc xan, je' in tuchi'tic techex u Taj'or u Pixam C'uj an ten bic caj u toc araj C'uj. Je' u p'atʌr ta wicnʌnex. Tar ca p'atʌrex ich u cajar Jerusalén hasta ca' bin a c'ʌmiquex a muq'uex a tar u tar ich ca'anan ti' in Tet C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesús caj u pʌyaj u berob u camsʌwinicob ich u xur u cajar. Tabar u c'uchob ich cajar Betania. Caj u nacsaj u c'ʌb ich yoc'or u camsʌwinicob caj u c'ataj ti' C'uj ca' cʌnantacob ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Caj ts'oc u c'atic ti' C'uj ca' cʌnantacob ten C'uj, C'uj caj u pʌyaj Jesús ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jamach p'atob u camsʌwinicob quir u c'ujinticob Jesús. Caj ts'oquij caj binob ich u cajar Jerusalén, jach qui' yorob. ");
INSERT INTO lacNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Rajra' ti' yʌnob u camsʌwinicob Jesús ich carem naj tan u c'ujinticob C'uj.");
INSERT INTO lacNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mʌ' toy betac ru'um mʌ' toy betac ca'anan xan. Rajra' ti' yʌn a mac a cu bin tar u tsicbar to'onex bicyʌra' C'uj. Raji' ti' yʌn yejer ic Tet C'uj quire' raji' C'uj a cu bin tar. ");
INSERT INTO lacNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Rajra' ti' yʌn a mac a cu bin tar ich ic Tet C'uj cax mʌ' toy betac ru'um yejer ca'anan xan. ");
INSERT INTO lacNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tu cotor a ba' ti' yʌn, raji' u beyaj C'uj. Mʌna' mac u jer tu betaj. Raji' tu junan caj u betaj. ");
INSERT INTO lacNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Raji' tu junan cu ts'ic ij cuxtarex. Raji' tu ts'aj ic najtiquex ij cuxtarex munt q'uin. Quire' a ba' caj u betaj rajen raji' u sasirir to'onex a mac a cu manob ich yoc'ocab a mac a cu manob ich yac'birir quire' yʌn u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Raji' quib a cu ye'c'ac'tic tu yʌn ac'bir. A ac'biro' mʌ' c'ucha'an yor u tupic u sasirir. Baxuc arayo' yejer Jesús xan, cax mʌ' u c'atob Jesús mac. Raji' tan u ts'ic to'onex ij cuxtarex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A ucho' ti' yʌn mac u c'aba' Juan. Raji' ts'a'b u beyaj ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A Juano' caj u tsec'taj u sasirir a cu tar ich C'uj a cu sasiquintic mac. Mʌ' ja wirej, wa quij cacsiquex ij corex u sasirir ic pixamex, mʌ' ac'bir ic pixamexi'. Juan caj u tsec'taj soc u yacsic tu yor tu cotor mac a ba' cu yubic ya'aric Juan. ");
INSERT INTO lacNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A Juano' mʌ' ra' cu sasiquintic mac, u sasirir a cu tar ich C'uj, cu chen tsec'tic a cu sasiquintic mac. Quire' ara'b ti' ca' u tsec'tej. ");
INSERT INTO lacNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wa ber a Juano' tan u tsec'tic ti' uch. Toc ts'oc u c'uchur tera' ich yoc'ocab, raji' a cu ts'ic ij cuxtarex soc u sasiquintic ic pixamex. Quire' ra' u beyaj. ");
INSERT INTO lacNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Raji' c'uchij ich yoc'ocab a caj u betaj yoc'ocab. Chen mʌ' c'ʌ'ota'b ten a mac ti' yʌn ich yoc'ocabo'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Caj c'uchij ich yoc'ocab soc u yet manob u winiquirob judío a mac teta'b ten C'uj uch. Chen mʌ' tu sʌjtajobi'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Chen yʌn mʌ' ya'ab mac a tu sʌjtajo', a tu yacsaj tu yor a ti'o'. Raji'ob yer ts'a'b u beyaj ten C'uj soc u to'car ti'ob. Ara'b ti'ob ten C'uj, raji'ob u parar C'uj a cu yacsicob tu yor ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mʌ' ja wirej, a maque' u parar C'uj quire' caj u yacsaj tu yor. Raji' mʌ' baxuc a mac jach pararinta'b ten u tet quire' raji' quir a cuxtar techex yoc'ocab. Raji' mʌ' baxuc u pararinta'b ten u nʌ' quire' baxuc cu pachtic u pararʌncʌr a xquico'. Chen a mac a ju parar C'uj munt q'uin u cuxtar. ");
INSERT INTO lacNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chen a mac a tar tsicbʌta to'onex bicyʌra' C'uj tu ch'aj u winquirir an ten bic to'onex. Tarij soc ij quet man a mac a ju winiquirob judío. Tij quiraj jach manan u muc'. Quire' raji' u parar C'uj, rajen baxuc jach manan u ne'er ba'. Ic Tet C'uj jari' turiri' u parar. Raji' quet cu yajquinto'onex. Raji' quet taj cu tsicbar. ");
INSERT INTO lacNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A Juano' caj u tsec'taj ti' a cu bin tar. Caj u ya'araj ti': ―A jeroj, bin, a mac a tin wa'araj techex uch. A pachir cu tar, raji' jach no'j beyaj caj in wa'araj. Chen in beyaj a teno', mʌ' neno'jeni'. Cax mʌ' toy u rochen in nʌ', u toc beri' a ti'o' quire' rajra' ti' yʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Quire' jach tsoy yor a cu tar ich C'uj, rajen u jach tsoyirir C'uj caj ij c'ʌmaj. Rajra' tan u ts'ic to'on a ba' tsoy tu t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mʌ' ja wirej, u winiquirob judío caj u c'ʌmajob u nunquirob u t'ʌn C'uj a ts'ab ten Moisés uch. Chen a Jesucristojo' caj u yesaj bic C'uj caj u yajquintaj to'onex quire' otsir to'onex yirico'onex. Quire' a Jesucristojo' xan tij cu'yajex u t'ʌn C'uj a ba' taj. ");
INSERT INTO lacNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mʌna' mac yirmʌn C'uj. Chen u parar C'uj tu yiraj u Tet. Jari' u parar turiri' raji' jach yajbir ten u Tet. Raji' caj u yesaj to'onex bicyira' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","U winiquirob judío a ti' cʌja'anob ich u cajar Jerusalén. Raji'ob caj u tuchi'tajob sacerdote yejer a mac a cu beyajob ich carem naj tu cu naj c'ujinticob u winiquirob judío. Levitas u c'aba'ob. Tuchi'ta'b quir u c'ata' ti' Juan: ―Maquechi'? ");
INSERT INTO lacNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","A Juano' mʌ' ju mucraj caj u ya'araj: ―Mʌ' Cristojeni', mʌ' yʌjtaquiren maqui', a cu bin tar. ");
INSERT INTO lacNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Caj u ca' c'atob ti' Juan: ―Arej to'on maquechi'? A techo' wa Elíasech soc in wa'aricob ti' in rac'ob a tu tuchi'tenob? Juan caj ya'araj: ―Mʌ' Elíaseni'. Caj u ca' c'atob ti': ―Mʌ' wa tech yʌjtseq'uirech u t'ʌn C'uj a tan in pajicob u tar? Juan caj u nuncaj, tan ya'aric ti'ob: ―Mʌ' teni'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","A tuchi'ta'b caj u ya'arob ti' Juan: ―Arej tenob maquechi' soc in wa'aricob ti' a macob a tu tuchi'tenob ba' a beyaj tech, arej tenob. ");
INSERT INTO lacNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A Juano' caj u nuncaj caj u ya'araj: ―Isaías caj u tsec'taj ti' ten uch. Baxuc a jera' caj u tsec'taj Isaías uch tan ya'aric: “Ti' cu bin tar mac ca' bin c'uchuc tu q'uinin quir u c'am tsec'tic ich tʌcay ru'um.” C'am cu bin ya'aric: “Tajquintex a worex soc c'ucha'an a worex a qui' acsiquex Jaj Ts'urir irex ca jariquex u ber soc u tar rey.” Baxuc caj ya'araj Isaías uch. ");
INSERT INTO lacNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A mac tuchi'ta'b ten u winiquirob judío a fariseojo' caj c'uchob ich Juan. ");
INSERT INTO lacNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Caj c'uchob caj u c'atajob ti' Juan: ―Biquinin ca wacsic ja' tu jo'r mac wa mʌ' tech Cristojech? Quire' mʌ' Elíasech xan, baxuc mʌ' yʌjtseq'uirech u t'ʌn C'uj xan? ");
INSERT INTO lacNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan caj ya'araj ti'ob: ―A teno' ra' in beyaj quir in wacsic ja' tu jo'r mac. Chen a mac jach no'j beyaj ti' yʌn tu yʌnechex baje'rer. Chen a techex mʌ' a c'ʌ'omʌnexi'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Raji' a cu tar pachir raji' jach no'j u beyaj chen a teno' mʌ' jach no'jen beyaj. Mʌ' pataren a teno' cax in chen pitic u c'anin pech' u xʌnʌb. ");
INSERT INTO lacNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Caj tarob u c'atej ti' Juan tu yʌn cu ya'aricob Betábara, raji' pichir ya'arir Jordán tu cu tar ic yum. Ti taro' Juan tan yacsic ja' tu jo'r mac. ");
INSERT INTO lacNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","U jer u q'uinin Juan caj yiraj Jesús Juan. A Jesúso' tan u juts'ic u bʌj ich yicnʌn Juan. Caj ya'araj Juan: ―Ir a wirex a je' cu taro' ts'a'b u beyaj ten C'uj. Raji' irej u tʌmʌn yuc C'uj quire' cu bin u quinsa'r soc u rʌc ruc'sic ic si'pirex. Baxuc tu cotor mac a ti' yʌn ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A jera' a tin yʌn bat'an araj tech uch caj in wa'araj techex: “A pachir cu taro', rajra' ti' yʌn a pachir cu tar cax mʌ' toy u rochen in nʌ' uch a ti'o'. Toc beri' ucho'.” ");
INSERT INTO lacNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Juan caj ya'araj: ―A teno' xan mʌ' tin c'ʌ'otaj wa raji' ij cʌjtaquirex. Mʌ' ja wirej, taren in wacsic ja' tu jo'r u winiquirob judío soc u c'ʌ'oticob a cu tar ich C'ujo'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan caj ya'araj ti'ob: ―A teno' caj in wiraj u yeman u Taj'or u Pixam C'uj ich ca'anan, irej susuy caj c'uchij tu yʌni'. Ti' p'atij tu yʌni'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","A teno' uch mʌ' tin c'ʌ'otaj. Chen a C'ujo' a tu ts'aj in beyaj quir in wacsic ja' tu jo'r mac caj ya'araj ten C'uj: “Ca' bin a wirej, quij C'uj, u yeman u Taj'or u Pixam C'uj. Ca wiric tu cu p'atʌr yejer. Raji' cu bin u ts'ic tech u Taj'or u Pixam C'uj.” Baxuc caj ya'araj C'uj ti' ten ―quij Juan―. ");
INSERT INTO lacNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Baxuc caj in wiraj, rajen quin wac techex raji' u parar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","U jer u q'uinin a Juano' tiri' yʌn tu yʌn jo'raj. Ti' yʌn Juan yejer ca'tur u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan caj yiraj u man Jesús, caj u ya'araj ti' u camsʌwinicob: ―Iriquex a jera', raji' irej u tʌmʌn yuc C'uj, quir u ruc'sic u si'pir tu cotor mac ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Caj yubob ya'aric Juan a ca'tur u camsʌwinicob Juan caj sayob tu pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús caj u sut u bʌj u pʌctej tu pach. Caj yiraj tan u tar tu pach, caj ara'b ti'ob: ―Ba' ca cʌxtiquex? ―quij. Robob caj ya'arob ti': ―In wʌjcamsʌyʌjirechob, tu cʌja'anech? ");
INSERT INTO lacNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús caj u nucaj ti'ob, tan ya'aric: ―Cuxex a wirej. Caj c'uchob tu yirajob tu cʌja'an. Jesús caj u yacsaj ti'ob quire' tabar u bin q'uin. Ti' wenob. ");
INSERT INTO lacNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Turiri' a tu yuba ya'aric Juan, a ca'tur u camsʌwinic, caj say tu pach Jesús, raji' u c'aba' Andrés. Raji' u sucu'un Simón Pedro. ");
INSERT INTO lacNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Seb caj bin u cʌxtej u sucu'un Simón. Caj ya'araj ti': ―Tin wiraj a cu ya'ara' Mesías ―raji' u c'at ya'aric Cristo a tuchi'ta'b ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés caj bin yejer u sucu'un tub yʌn Jesús. Caj irir Simón ten Jesús, caj u ya'araj ti': ―A techo' ―quij Jesús―, Simónech, u pararech Jonás. Chen yʌn in pʌchic a c'aba' Cefas, aro' Pedro a c'aba' ―a Cefaso' ich u t'ʌn u winiquirob judío, quet ich u t'ʌn griego cu ya'aric Pedro. ");
INSERT INTO lacNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Caj sasij Jesús u c'at u bin ich u ru'umin Galilea. Mʌ' toy xiqui' caj u nup'a Felipe caj ya'ara ti': ―Sayen ―quij Jesús―, tin pach quir a cʌnic in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","A je' Felipeja' ti' cʌja'an ich u cajar Betsaida. Tu cʌja'anob Andrés xan yejer Pedro. ");
INSERT INTO lacNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe caj bin u cʌxtej Natanael, caj u yiraj caj ya'araj ti': ―Tij quiraj ―quij Felipe―, a mac ts'ibta'b ten ic nunquir Moisés uch ich u t'ʌnob. Baxuc raji'ob tu ts'ibtajob ic nunquir yʌjtseq'uirob u t'ʌn C'uj uch. Baxuc raji' u parar José a ti' cʌja'an ich u cajar Nazaret. ");
INSERT INTO lacNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael caj c'ataj ti' Felipe tan ya'aric: ―Mʌ' ij cu'wimʌn a mac jach tsoy a cu tar ich u cajar Nazaret. Felipe caj u nuncaj: ―Cojen irej ―quij ya'araj ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús caj u yiraj tan u c'ʌs juts'ic u bʌj Natanael ich Jesús. Jesús caj ya'araj: ―A je' cu tara' a mac taj u yor ich u winiquirob judío. Mʌ' yer bic tabar u tus aric mac. ");
INSERT INTO lacNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael caj u c'ataj ti': ―Bic a c'ʌ'otiquen? Jesús caj ya'araj ti': ―A teno' ―quij Jesús―, caj in wirech yaran u che'er higuera cax mʌ' toy u t'ʌnech Felipe. ");
INSERT INTO lacNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Caj ara'b ti' ten Natanael: ―In wʌjcamsʌyʌjirech ―quij Natanael―, a techo' u pararech C'uj. Baxuc je' a wocar a reyintic u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús caj u nuncaj ti', tan ya'aric: ―Quire' ―quij Jesús―, caj in wa'araj tech caj in wirech yaran u che'er higuera, rajen caj a wacsa ta wor ten? Jach tsoy baxuc, quire' ta wacsaj ta wor. Ca' bin c'uchuc tu q'uinin je' in wesic tech jach manan in ne'er ba'. ");
INSERT INTO lacNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Baxuc xan Jesús caj u ya'araj ti' u camsʌwinicob. ―Taj a ba' quin wac techex. A techexo' je' a wiriquex u q'ue'pʌjʌr ca'anan soc a wiriquex u yeman yʌjmasirob u t'ʌn C'uj tu yʌnen. Je' a wiriquex u nacar ich ca'anan yʌjmasirob u t'ʌn C'uj. Quire' a teno' baxuquenechexo'. ");
INSERT INTO lacNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Caj manij mʌna' u nup u q'uinin caj ts'oc yiric Natanael yejer Felipe. Yʌn mac cu bin u ch'ic u rac' ich u cajar Caná ra' u wa'an u ru'umin Galilea. Ti' yʌn xan u nʌ' Jesús, tar yiric u ch'ic u rac' mac. ");
INSERT INTO lacNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Caj pay u camsʌwinicob Jesús caj yirajob u ch'ic u rac' mac. Yet payac Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ti' toy yʌn Jesús tu cu bin u ch'ic u rac' mac caj xup u c'ab uva. Caj ara'b ti' Jesús ten u nʌ': ―Xup u c'ab uva. Biquinin mʌ' a yamtic ti'ob? ");
INSERT INTO lacNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús caj ya'araj: ―In nʌ'ech ―quij Jesús―, biquinin ca wa'aric ten xup? Mʌ' toy jach c'uchuc tu q'uinin soc in wesic in muc'. ");
INSERT INTO lacNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","U nʌ' Jesús caj u ya'araj ti' u c'urewob a mac cu bin u ch'ic u rac': ―Quibex a ba' cu ya'aric techex. ");
INSERT INTO lacNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ti' t'ana'ani' u yajaw p'urir yoch ja', u cuchir tu cu t'ajic yoch ja' soc ti' cu p'o'icob u c'ʌb. Baxuc ti' cu p'o'icob yoc. Quire' baxuc u p'urir cu ch'ic ochenta litros yoch ja'. ");
INSERT INTO lacNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús caj ya'araj ti' u c'urewob a mac a cu bin u ch'ic u rac': ―Toc chupex ya'arir a je' t'ana'an u p'urir yoch ja'. Tu toc chupaj u ya'arir u jor u p'urir. ");
INSERT INTO lacNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús caj u ya'araj ti'ob: ―Jopex ca' xiquex a purex ti' yirej yʌjt'ʌjir a wo'ochex. Caj binob u purej ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yʌjt'ʌjir yoch caj u tumtaj ja' a waysa'b u c'ab uva. Chen mʌ' yer tub u tar ya'arir u c'ab uva. Chen u c'urewob yerob chen ja' ca'ch caj u jopajob. Rajen u yʌjt'ʌjir yo'och caj u t'ʌnaj a mac a cu ch'ic u rac'. ");
INSERT INTO lacNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Yʌjt'ʌjir yo'och caj ya'araj ti': ―A rac'ob ―quij―, raji' cu bat'an ts'ic a jach tsoy u c'ab uva. Cu ts'ocar u yuq'uicob ya'ab u c'ab uva, cu ts'ic ti' u rac'ob u c'ab uva, a mʌ' quet yejer a tsoyo'. Chen tech ta ric'saj u c'ab uva a jach tsoyo' hasta baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Baxuc caj u betaj Jesús ich u cajar Caná, ra' u wa'an u ru'umin Galilea. Raji' u yʌnxchun u carem beyaj soc yesic ti' u rac'ob u winiquirob judío jach yʌn u muc' C'uj. Rajen u camsʌwinicob caj u yacsob tu yorob ti' quire' yerob u parar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Caj ts'oc aro' caj binob ich u cajar Capernaum. Jesús yejer u nʌ' yejer yits'inob yejer u camsʌwinicob. Chen mʌ' ya'ab u q'uinin ti' p'atob ich u cajar Capernaum. ");
INSERT INTO lacNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tabar u c'uchur tu q'uinin u qui'qui' janʌnob u q'uinin pascua. Ra' u q'uinin u winiquirob judío quire' na'nij u c'ʌ'oticob quire' baxuc caj potmasta'b u winiquirob judío ich u ru'umin Egipto ten yʌjmasir u t'ʌn C'uj uch. Caj bin Jesús yejer u camsʌwinicob ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Caj bin Jesús tu re'a'an carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Ti' tu yiraj mac ich carem naj. A mac cu canicob yʌrʌc' wacʌx a tono' yejer tʌmʌn yuc yejer susuj. Rʌc ti' yʌnob tu re'a'an carem naj. Caj irir xan ti' cura'an yʌjc'axir u taq'uin soc u c'oxar u taq'uin a mac a cu tar nach. ");
INSERT INTO lacNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Rajen caj u cʌxtaj sum soc u jit'ic quir u jats'ʌr u pachob. Caj u rʌc joc'saj ich carem naj tu cotor a mac a cu canicob yʌrʌc' tʌmʌn yuc yejer yʌrʌc' wacʌx a tono'. Baxuc a mac cu c'axicob u taq'uinob mac caj u rʌc wec u taq'uinob yejer u pojche'irob u taq'uinob. ");
INSERT INTO lacNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesús caj u ya'araj ti' a mac a cu canic susuj: ―Toc rʌc joc'sex a wʌrʌc' susuj. Quire' raji' yatoch in Tet, mʌ' a c'axiquex irej tu cu naj co'nan ba'. ");
INSERT INTO lacNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Caj u yirob ba' tu betaj Jesús, rajen c'aj ti' u camsʌwinicob Jesús a ba' ts'iba'an ich u t'ʌn C'uj uch: “Quire' q'uex in wor ti' yatoch C'uj rajen cu bin u p'actiquen mac.” Baxuc ara'b ich u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","U jach ts'urirob sacerdote caj u c'atob ti' Jesús tan ya'aricob: ―Mac caj u ts'aj a beyaj quir a joc'sic mac a cu canicob ba' ich carem naj? Ese tenob carem beyaj soc in werob mac caj u ts'aj a beyaj. ");
INSERT INTO lacNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús caj ya'araj ti'ob: ―Jubse a je' carem naja' ca' bin c'uchuc mʌna' u nup u q'uinin, quin bin in ca' ric'sej u jer ric'ben. ");
INSERT INTO lacNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","U jach ts'urirob sacerdote caj ya'arob: ―Yʌn cuarenta y seis yaxq'uin caj ts'oc u ts'ʌpquintic u tunichir quir u ts'ocsicob a je' carem naja'. Bic tabar tech ca' bin a ric'sic mʌna' u nup u q'uinin? ");
INSERT INTO lacNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús tan u tsicbar ti' u winquirir, mʌ' cu ya'aric jach carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Rajen caj riq'uij Jesús ich u quimirir. U camsʌwinicob c'aj ti'ob a ba' ara'b ti' u jach ts'urirob sacerdote ten Jesús. Ra'iri' u q'uinin caj u quibob u t'ʌn C'uj tu ts'iba'an tan ya'aric: “Je' u ca' riq'uir tu quimirir.” Rajen yerob taj u camsʌwinicob a ba' ara'b ti' u jach ts'urirob sacerdote ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ti' p'at Jesús yejer u camsʌwinicob ich u cajar Jerusalén hasta caj ts'oc u man u q'uinin pascua. Ya'ab mac caj u yacsaj tu yor quire' yerob yʌjtaquirob quire' yirob u carem beyajob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Quire' Jesús yer ba' cu tucric tu cotor mac rajen yer mac mʌ' quet yor yejeri'. ");
INSERT INTO lacNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A Jesúso' mʌ' ba'wir cu tar ya'aric ti' bicyʌra' mac quire' Jesús u toc er bicyʌra'. ");
INSERT INTO lacNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","A ucho' ti' yʌn u winiquir judío a fariseojo' a ucho', raji'o' u c'aba' Nicodemo. Raji' turiri' u ts'urir ich u winiquirob judío. A fariseojo' cu quibicob a ba' ara'b ten u nunquir u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Oq'uin caj bin Nicodemo tu yʌn Jesús quir u tsicbar yejer. Caj ya'araj ti': ―In wʌjcamsʌyʌjirech. In wer C'uj tu tuchi'tech quir a camsico'on. Wa mʌ' C'uj tu tuchi'tech, mʌ' c'ucha'an a wor a wesic carem beyaj an ten bic ca betic. ");
INSERT INTO lacNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús caj ya'araj ti': ―Taj quin wa'aric tech. A mac u c'at u yocar tu cu reyintic C'uj, u Taj'or u Pixam C'uj yʌn u ts'ic u cuxtar a cu tar ich ca'anan. Irej wa ju ca' rocha'r ten u nʌ'. ");
INSERT INTO lacNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo caj ya'araj ti' Jesús: ―Bic tabar u ca' rochar ten u nʌ' quire' uch ch'ijic? Mʌ' c'ucha'an yor u ca' ocar ich u nʌc' winic soc u ca' rocha' ten u nʌ'. ");
INSERT INTO lacNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús caj u nuncaj ti', tan ya'aric ti': ―Taj a ba' quin wac tech. Mʌ' chen jari' ja' cu yacsa' ta jo'r, ca' a c'ʌmej u Taj'or u Pixam C'uj quire' baxuc toc ara'b ten C'uj. A baywo' c'ucha'an a wor a wocar tu cu reyintic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tu q'uinin caj u rochech a nʌ', raji' quir a chen cuxtar ich yoc'ocab. Tu q'uinin cu ts'ic tech a cuxtar u Taj'or u Pixam C'uj, ra' cu tar ich ca'anan, raji' quir a cuxtar munt q'uin. Aro' irej wa tu ca' rochech a nʌ'. ");
INSERT INTO lacNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mʌ' ju jac'ʌr a wor Nicodemo quire' tin wa'araj tech aro'. Mʌ' ja wirej, u Taj'or u Pixam C'uj je' u ts'ic a cuxtar a cu tar ich ca'anan soc c'ucha'an a wor a bin ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A ic'o' cu rʌc man tu cotor. Ca wu'yic u jum, chen mʌ' a wer tub u tar, mʌ' ja wer, tu cu bin. Baxuc aro' tu cotor mac a ts'ab u cuxtar a cu tar ich ca'anan ten u Taj'or u Pixam C'uj. Cu chen beyaj ti' techex chen mʌ' a werex bic tabar. ");
INSERT INTO lacNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo, mʌ' toy u jach qui' najti' caj u ca' nuncaj, tan ya'aric: ―Bic tabar cu betic a baxuc aro'? ");
INSERT INTO lacNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús caj a nuncaj ti' tan ya'aric: ―A techo' a ne'er a camsic, ca chen camsic u winiquirob judío. Mʌ' wa ja najtej a tin wa'araj tech? ");
INSERT INTO lacNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jach taj quin wa'aric tech Nicodemo. A tenob in wa'aricob tech a ba' in werob, baxuc a ba' tin wirob. Chen techex mʌ' ja quibex a ba' quin wa'aricob. ");
INSERT INTO lacNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wa mʌ' ja quibiquex a ba' quin tsicbar techex, a ba' yʌn ich yoc'ocab an ten bic caj in wa'araj yʌn u ca' rochiquech a nʌ'. Je' wa ja quibic a ba' quin wa'aric techex, a ba' yʌn ich ca'anan? ");
INSERT INTO lacNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Jesús caj ya'araj: ―Mʌna' mac binij ich ca'anan caj wʌc'ʌs ur tera' quir ya'aric bicyʌra' ca'anan. Chen a teno' c'ucha'an in wor in wa'aric bicyʌra' quire' ti' in tar ich ca'anan quire' a teno' irenechex. Ti' quin wʌc'ʌs bin xan. ");
INSERT INTO lacNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","An ten bic ic nunquir Moisés caj u nacsaj can a beta'b ti' mascab, caj u nacsa yejer che' ich tacay ru'um. Soc raji' quir u jawʌr a mac chi'bir ten can wa cu pʌctic. An ten bic a cano' caj nacsa'b ich che' baxuc ten ca' bin u bʌjen ich cruz soc u nacsiquen soc in jawsic u si'pir mac quire' a teno' irenechex. ");
INSERT INTO lacNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wa mac cu yacsic tu yor ten quire' bin u ca' bʌjbiren ich cruz soc in taquic ti'ob, je' u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Mʌ' ja wirej, a C'ujo' jach manan cu yajquintic tu cotor mac ich yoc'ocab. Rajen tu tuchi'taj u parar turiri'. Rajen tu cotor mac a cu yacsic tu yor ti' cu bin tacbir soc mʌ' u bin erar ich c'ac'. Chen cu bin ts'abʌr u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ic Tet C'uj tu tuchi'taj u parar tera' ich yoc'ocab. Mʌ' tarij quir u ts'ic u muc'yaj a ti' yʌn ich yoc'ocab quire' yʌn u si'pirob. Mʌ' ja wirej, tarij quir u yamtic tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’A mac cu yacsic tu yor ti' cu bin tacbir ten u parar C'uj, mʌ' ju bin u bo'otic u bo'orir u si'pir. Chen a mac a mʌ' u c'at u to'car ten u parar C'uj. A C'ujo' caj u toc tetaj tub u wich u bin, quire' mʌ' tu quibaj u t'ʌn u parar a turiri', raji' ij cʌj taquir. ");
INSERT INTO lacNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mʌ' ja wirej, tarij u parar C'uj ich yoc'ocab quire' tu toc tucraj a C'ujo' bic cu bin u ruc'sic u si'pir mac. Mʌ' ja wirej, ca' bin tac u sasirir a a'ac'biro' chʌca'an a wiric ba' u ber wa c'as. Baxuc xan caj tar u parar C'uj chʌca'an yiric wa yʌn u si'pir tu cotor mac. Chen a winiquiro' mʌ' u c'at u tar tu yʌn u parar C'uj quire' cu manob tu c'asir quire' raji'ob cu jach pachticob u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Quire' tu cotor mac a na'nij cu betic a c'aso' mʌ' u c'at ca' iric a ba' cu betic. Rajen mʌ' u c'at u tar tu yʌn u parar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Chen a mac a rajra' cu betic a ba' u c'at C'uj, mʌ' ju ch'a'ej sajquir u tar yicnʌn u parar C'uj. Mʌ' ja wirej, irir raji'ob yamta'b ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pachir caj binij Jesús yejer u camsʌwinicob ich u ru'umin Judea. Ti' p'at yejer u camsʌwinicob ya'ab u q'uinin. Jesús tu ts'aj u beyaj quir u yacsic ja' tu jo'r mac wa tu quib u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Baxuc Juan xan tan yacsic ja' tu jo'r mac ich u cajar Enón. A Enóno' c'ʌs bʌytʌc u cajar Salim. Quire' ti' yʌn ya'ab yic' ja'. A mac c'uchob ich Juan caj ac'sa'b ja' tu jo'r wa tu quib u t'ʌn xan. ");
INSERT INTO lacNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Quire' a Juano', mʌ' toy chucuc quir u ma'cʌr, tan yacsic ja' tu jo'r mac ich u cajar Enón. ");
INSERT INTO lacNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yʌn u camsʌwinicob Juan mʌ' qui' yorob quire' u winiquirob judío tan u binob ich Jesús ca' acsac ja' tu jo'rob. Rajen u camsʌwinicob Juan quet tan u chich aricob turiri' u winiquir judío. ");
INSERT INTO lacNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","U camsʌwinicob Juan caj binob ya'arej ti' Juan tan ya'aricob ti': ―In wʌjcamsʌyʌjirech a mac tarij tub yʌnech uch ich pʌchir ya'arir Jordán a mac a ta wa'araj uch yʌn u tar. A baje'rer ti' yʌn tan yacsic ja' tu jo'r mac, tu cotor mac tan u rʌc bin yicnʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan caj u nuncaj tan ya'aric ti'ob: ―Mʌ' ja wirej, u bʌjiri' C'uj cu ts'ic u beyaj ti' mac a ba' yʌn u betej. ");
INSERT INTO lacNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","A techexo' caj a wu'yajex mʌ' jin mucraj tin toc araj: Mʌ' Cristojen. Mʌ' taren in taquechex. A C'ujo', tu ts'aj in beyaj quir in chen pʌyic u ber ij cʌjtaquirex. ");
INSERT INTO lacNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A mac a caj u raq'uintaj a je' xquica' raji' u mam. A mac u jach yajo' cu yiric tan u ch'ic u rac'. Cu yubic u tsicbar cu qui' tar yor yubic tan u ch'ic u rac'. Aro' baxuc ten, jach qui' in wor in wiric u bin a pimo' ich Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Juan caj ya'araj: ―Mʌ' u neman u jumin ten, chen a Jesúso', ra' cu jach jumintejob, quire' baxuc u c'at C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Juan caj ya'araj ti' u camsʌwinicob: ―A Jesúso' tuchi'ta'b ten C'uj tera' ich yoc'ocab, raji' u ts'urir tu cotor ba'. A teno' ―quij Juan―, te' toc yʌnena' ich yoc'ocab, quin chen beyaj a tera'. A teno', quin chen aric techex a ba' quin wiric ich yoc'ocab. A Jesúso' tar u tar ich ca'anan, rajen u ne'er tu cotor ba'. Rajen neyʌn u muc'. ");
INSERT INTO lacNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A Jesúso' cu ya'aric a ba' caj u yiraj tu yʌn a C'ujo'. Baxuc a ba' caj u yubaj, raji' cu ya'aric. Chen mʌ' ya'abi' cu quibic a ba' cu yac. ");
INSERT INTO lacNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Chen a mac a cu quibic u t'an Jesús quire' tarij ich ca'anan tan u quibic a ba' ara'b ti' Jesús ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","A Jesúso' tuchi'ta'b ten C'uj, rajen cu ya'aric u t'ʌn C'uj. A C'ujo' mʌ' ju p'isej mun cu ts'abʌr ti' Jesús u Taj'or u Pixam C'uj. mʌ' ja wirej, rajra' yʌn u Taj'or u Pixam C'uj ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ic Tet C'uj cu yajquintic u parar rajen caj u ts'aj ti' tu cotor a ba' yʌn ti', C'uj ca' u cʌnantej u parar. ");
INSERT INTO lacNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tu cotor mac a cu yacsic tu yor ti' u parar cu bin tacbir ten u parar C'uj. Munt q'uin cu bin cuxtar. Tu cotor mac a mʌ' u c'at u yacsic tu yor ti', mʌ' u bin tacbir ten u parar C'uj. Mʌ' u bin cuxtar munt q'uin, tar cu bin ich c'ac'. Yʌn u ts'abʌr u muc'yaj ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesús tu najtaj ti' a ba' ara'b ten mac ti' a fariseojo'. U camsʌwinicob Jesús tan u pimtar quire' tan u jach pimtar a mac acsa'b ja' tu jo'rob. Tan u jach osar u camsʌwinicob Juan. Baxuc ara'b ti' a fariseojo' ten mac. ");
INSERT INTO lacNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Baxuc caj juminta'b ti' Jesús. Chen u bʌjiri' Jesús mʌ' ju yacsaj ja' tu jo'rob mac. Chen u camsʌwinicob raji'ob cu yacsic ja' tu jo'rob mac. ");
INSERT INTO lacNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Quire' Jesús yer ba' cu ya'aricob a fariseojo' quire' mʌ' u c'atob yiricob u pimtar u yacsicob tu yorob ti' Jesús. Rajen ruq'uij ich u ru'umin Judea soc u wʌc'ʌs bin ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ra' u berir tu cu bin uch, ti' cu ch'ʌctic u ru'umin u c'aba' Samaria. ");
INSERT INTO lacNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ti' c'uchob Jesús yejer u camsʌwinicob ich u cajar Sicar. Ra' u cajar ich u ru'umin Samaria. Aro' jach bʌytʌc ti' u ru'umin a ti' ts'ab ti' José uch ten u tet Jacob. ");
INSERT INTO lacNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ti' yʌn yic' ja' ich ru'um chen tam yʌn ya'arir. Raji' u nunquir u winiquirob judío caj u panaj uch, Jacob u c'aba'. Quire' Jesús ca'anij tu cu tar ich bej. Tan u jesic u bʌj bʌytʌc tu yʌn yic' ja'. Bʌytʌc c'ac'chunq'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Caj tarij xquic a ti' cʌja'an ich u ru'umin Samaria. Quir u paytic yoch ja' quire' tam. Jesús caj ya'araj ti': ―Chan chuquej ―quij Jesús―, ten ja' quir in wuq'uic. ");
INSERT INTO lacNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mʌ' ja wirej, u camsʌwinicob Jesús, binob ich u cajar Sicar quir u mʌnicob yo'och. ");
INSERT INTO lacNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A xquico' a ti' cʌja'an tu ru'umin Samaria caj u ya'araj ti' Jesús: ―Biquinin ca c'atic ten ja' quire mʌ' u winiquir judíojen? U xquiquiren u ru'umin Samaria. Baxuc caj ya'araj a xquico' quire' p'acta'b u winiquirob samaria ten u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús caj u nuncaj ti', tan ya'aric: ―Wa ja chen er C'uj u c'at u sijic tech ba', wa ta c'ʌ'otajen a mac a tu ya'araj tech: “Chan chuquej ten ja' quir in wuq'uic”, a techo' jach jaj ta yʌn bat'an c'ata ten sam ja' ca' in ts'a tech ja' soc raji' quir a cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A xquico' caj ya'araj: ―Jaj Ts'urir ―quij―. A techo' mʌna' quir a paytic ja' quire' tam yic' ya'arir. Bic tabar ca bin a ts'ic ja' ten, a ray ja'o' an ten bic caj a wa'araj ten? ");
INSERT INTO lacNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ic nunquir Jacob caj u p'ʌta to'on a je' yic' ja'a'. Quire' u bʌjiri' ti' tu yuc'aj xan uch. Baxuc ti' caj u yuc'ob u pararob xan, baxuc ti' caj u yuc'ob u yʌrʌc'. Jach manan wa no'jech ta beyaj a techo', c'ucha'an waj a wor a ts'ic ten ja' an ten bic ta wa'araj? ");
INSERT INTO lacNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús caj u nuncaj, caj ya'araj ti': ―Tu cotor mac a cu yuq'uic a je' ja'a', je' u ca' uc'chʌjʌre' cax a wuq'uej. ");
INSERT INTO lacNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A mac a cu yuq'uic ja' a quin ts'ic a ti'o', mʌ' ju bin yʌnyʌn uc'chʌjʌr. Quire' a ja'o' a quin ts'ic ti', cu wayʌr yic' ja' irej u bosirʌncʌr ja' tu pixam soc u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mʌ' toy u najti', wa tan u tsicbar ti' u cuxtar munt q'uin, rajen a xquico' caj ya'araj: ―Jaj Ts'urir ―quij―, chan chuquej a je' ja'a' a caj a wa'araj ca' in wuq'uej soc mʌ' in yʌnyʌn uc'chʌjʌr baxuc soc mʌ' in ca' tar in t'uyic in woch ja' yejer sum. ");
INSERT INTO lacNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús caj ya'araj ti': ―Joq'uen pʌyej a mam soc a tar yejer. ");
INSERT INTO lacNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A xquico' caj u nuncaj caj u ya'araj: ―Mʌna' in mam ―quij ya'araj ti' Jesús. Rajen Jesús caj ya'araj ti': ―Taj caj a wa'araj ten mʌna' a mam ");
INSERT INTO lacNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","quire' yʌn tech cinco a mam jach jaj uch. Rajra' tan a tuchi'tic ca' xic a mac jach raji' a mam. Rajen a ba' ta wa'araj sam taj quire' mʌ' jach a mami', cax ti' cʌja'anech yejer. ");
INSERT INTO lacNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A xquico', caj ts'oc yubic a ba' ara'b ti' ten Jesús, caj ya'araj: ―Jaj Ts'urir ―quij―, quin wiric irech yʌjtseq'uirech u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Quire' in nunquirob uch tu c'ujinticob C'uj uch ich a je' u jo'r u witsira'. Chen techex ca wa'ariquex ca' xiquenob ich u cajar Jerusalén quir in c'ujinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús caj ya'araj: ―Quibej a ba' quin wa'aric tech, xquic. Ca' bin c'uchuc tu q'uinin, mʌ' ju bin ya'aricob ca' in c'ujintejob C'uj ich a je' jo'r witsira'. Mʌ' ju bin u ya'aricob: “Ca' ij c'ujintej C'uj ich u cajar Jerusalén.” ");
INSERT INTO lacNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","A techexo' u winiquirechex samaria mʌ' a werex C'uj, a mac a ca c'ujintiquex. Chen u winiquirob judío yerob in Tet C'ujob, a mac in c'ujinticob quire' ara'b ti'ob ten C'uj: “Bin in ca' in tar quir in taquicob quire' p'eri'en yejer u winiquirob judío.” ");
INSERT INTO lacNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Baje'rer c'uchij tu q'uinin tu cotor mac a cu qui' acsic tu yorob, taj cu bin u c'ujinticob ic Tet C'uj tu pixam. Quire' baxuc u c'at ic Tet C'uj, taj ca' u c'ujintejob ten mac tu pixamob. ");
INSERT INTO lacNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ic Tet C'uj mʌ' c'ucha'an a worex a wiric quire' mʌna' u winquirir. Rajen mʌ' ja wirej. Baxuco' mʌ' c'ucha'an a wor a wiric a mac a taj cu c'ujintic C'uj tu pixam. Quire' tu pixamob taj cu c'ujinticob C'uj. Baxuc C'uj u c'at taj ca' ij c'ujintej ―baxuc caj u ya'araj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A xquico' caj ya'araj: ―In wer mac cu bin tar cu ya'ara' Mesías ―raji' u c'at ya'aric Cristo cu bin ts'abir u beyaj ten C'uj quir u taquic mac tu cotor ca' bin tac―. Raji' cu bin u camsico'on tu cotor ba'. ");
INSERT INTO lacNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús caj ya'araj ti': ―Raji'en a tan in tsicbar yejerech. ");
INSERT INTO lacNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ra'iri' u q'uinin caj urob u camsʌwinicob tu bin u mʌnejob yo'och. Caj jac'ob yorob caj yirob Jesús tan u tsicbar yejer xquic. Mʌ' ja wirej, a mac a cu camsic u t'ʌn C'uj mʌ' ju tsicbar yejer xquic ich tan bej, baxuc na'nij cu betic u winiquirob judío. U camsʌwinicob surac u c'atob: “Biquinin ca tsicbar yejer xquic baxuc aro'?” ");
INSERT INTO lacNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Rajen a xquico' caj u p'ʌta u p'urir yoch ja' tu chi' u jorir ya'arir caj bin ich u cajar Sicar. Caj c'uchij caj ya'araj ti' u rac'ob: ");
INSERT INTO lacNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Cojenex ―quij―, ca' a wirex a mac a tu ya'araj tu cotor ba' a tin betaj. Jaj ix tʌco wa raji' ti' Cristo a cu bin tuchi'bir ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Rajen seb caj tarob ich Jesús caj joc'ob tu cajar. ");
INSERT INTO lacNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Caj bin a xquico' ca'ch, u camsʌwinicob tan u chich a'aricob ti' Jesús: ―In wʌjcamsʌyʌjirech chan janen. ");
INSERT INTO lacNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesús caj u nunca tan ya'aric ti'ob: ―Yʌn ten quir in janʌn. A ba' yʌn ten mʌ' a werex wa yʌn ten. ");
INSERT INTO lacNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","U camsʌwinicob caj pacran tsicbanʌjob tan ya'aricob: ―Yʌn wa mac tar u puric yo'och quir u janʌn? ");
INSERT INTO lacNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús caj ya'araj ti' u camsʌwinicob: ―Ra' in woch a teno' ca' in betej a ba' u c'at C'uj quire' raji' tu tuchi'tajen. Ca' in ts'ocsej a tu ts'aj in beyaj. ");
INSERT INTO lacNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jesús caj ya'araj ti' u camsʌwinicob: ―Baxuc ca waquex tech yʌn cuatro ic nʌ' quir ic wʌtic ij co'och trigo. U'yex ba' quin wac techex. Pʌctex a wirex a ra' cu tar winiquirob tub yʌno'on. Raji'ob irob trigo a cu tijire' ich cor quir u wʌtic. ");
INSERT INTO lacNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jeroj c'uchij tu q'uinin a yamtic mac u yacsic tu yor ten. Irechex a mac tan a wʌtiquex trigo ich cor a tiquino'. A mac a cu yamtic mac ca' u yacsej tu yor, irob a mac a cu maric yoch trigo a tiquine'. Je' u qui' acsa'rob ten C'uj. A mun cu bin yambir ca' u yacsej tu yor cu bin cuxtar munt q'uin. Rajen p'eri' qui' yorob a mac a cu ts'abʌr ti' u t'ʌn C'uj tu pixam mac yejer a mac a cu yamtic ca' u yacsej tu yor. ");
INSERT INTO lacNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Quire' taj a cu ya'aric mac: “Turiri' yʌjpʌq'uir turiri' yʌjwʌtir.” ");
INSERT INTO lacNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A teno' caj in ts'aj a beyajex techex quir a mariquex a mac a tu yacsaj tu yor ten. Quin tuchi'tiquechex tub mʌ' beyajnʌja'anechex. Mʌ' ja wirej, u jer mac tu pʌc'aj u t'ʌn C'uj tu pixamob. Quire' ra' a beyaj a techexo' quir a qui' camsic ti'ob ti' u t'ʌn C'uj soc u qui' acsicob tu yorob. ");
INSERT INTO lacNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ya'ab u winiquirob samaria a cʌja'anob ich u cajar Sicar tu yacsob tu yorob ti' Jesús quire' a ba' tu tsicbʌtaj a xquico' ti'ob quire' tu yubob ya'aric: “Raji' tu ya'araj ten tu cotor ba' caj in betaj uch.” ");
INSERT INTO lacNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Caj tarob u winiquirob samaria ich Jesús. Caj u chich arob ca' p'atʌc yejerob. Ti' p'atij Jesús ca'tur u q'uinin. ");
INSERT INTO lacNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ya'ab u winiquirob samaria caj u yacsajob tu yorob a ba' caj u yubob ya'aric Jesús xan. ");
INSERT INTO lacNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Rajen ya'ab u winiquirob samaria caj u ya'arajob ti' a xquico': ―Baje'rer tij cacsaj tij cor, mʌ' chen tij cu'yaj a wa'aric. Quire' tij cu'yaj u t'ʌn Jesús, rajen ij quer raji' Cristo a tar u taquic tu cotor mac ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Caj ts'oc u man ca'tur u q'uinin. Caj ruc' Jesús ich u ru'umin Samaria quir u bin ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Caj binob ich u ru'umin Galilea quire' yerob mʌna' mac cu bin u p'actic Jesús ca'ch quire' mʌ' sʌjta'b ten u rac'ob. Quire' Jesús caj u ya'araj: “A mac a cu tsec'tic u t'ʌn C'uj mʌ' u bin sʌjta'bir tu ch'ijir.” ");
INSERT INTO lacNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Caj c'uchij Jesús ich u ru'umin Galilea, mac ti' cʌja'anob qui' yorob yiricob Jesús. Mʌ' ja wirej, tu yirob tu cotor a ba' caj u betaj Jesús u q'uinin pascua ich u cajar Jerusalén quire' binob xan. ");
INSERT INTO lacNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús caj wʌc'ʌs bin ich u cajar Caná ra' u wa'an u ru'umin Galilea tu' tu waysaj ja' u c'ab uva. Ti' yʌn mac a cu tar ti' u cajar Capernaum. Raji' cu beyaj ti' rey. Raji' u parar yaj. ");
INSERT INTO lacNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","A cu beyaj ti' rey caj yuba ya'aric c'uchij Jesús tar u tar ich u ru'umin Judea baje'rer c'uchij ich u ru'umin Galilea. Caj bin yirej quir u chich pʌyic ca' xic ich yatoch quir u jawsa' u parar quire' tabar u quimin. ");
INSERT INTO lacNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Caj c'uchij ich Jesús caj ara'b ti' ten Jesús: ―A techexo' mʌ' ja quibiquex cax jach manan in muc' hasta ca wiriquex carem in beyaj. ");
INSERT INTO lacNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chen a mac a cu beyaj ti' rey caj ya'araj ti' Jesús: ―In Jaj Ts'urir ―quij―, sepquintej a tar, mʌ' toy quimic in parar. ");
INSERT INTO lacNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús caj ya'araj ti': ―Ca' xiquech ta watoch je' u jawʌr a parar. A xibo' tu quibaj u t'ʌn a ba' ara'b ti' ten Jesús. Caj wʌc'ʌs sutnʌj tu yatoch ");
INSERT INTO lacNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tabar u c'uchur tu yatoch caj bin nupbir ten u c'urew ich bej. Tar u tar ich yatoch caj ara'b ti': ―A parar jawij. ");
INSERT INTO lacNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A xibo' caj u c'ataj ti' u c'urew: ―Tu' q'uin caj jawij? U c'urew caj ya'araj: ―Jo'raj c'ʌs sarpʌj u q'uinin caj jawij u chʌcwirir u jo'r. ");
INSERT INTO lacNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","U tet u parar caj u c'ʌ'otaj ra'iri' u q'uinin caj ara'b ti' ten Jesús jo'raj: “Je' u jawʌr a parare'”; rajen a xibo' yejer tu cotor mac ti' yʌn tu yatoch caj u yacsob tu yorob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A jera' u carem beyaj tu ca' esaj Jesús soc yesic yʌn u muc' C'uj. Raji' tu betaj caj urij ich u ru'umin Judea caj c'uchij ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pachir caj c'uchij tu q'uinin u qui'qui' janʌn u winiquirob judío. Ra' u q'uinin pascua, ca'ten binob Jesús yejer u camsʌwinicob ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ti' yʌn ich u cajar Jerusalén tu cuch yacʌr ya'arir. Ti' yʌn tu cu yocar yʌrʌc' tʌmʌn yuc ich u jor u pa'te'ir tunich. Tar cu binob ich carem naj a tʌmʌn yuco'. Yʌn u c'aba' tu cu yacʌr ya'arir u c'aba' Betesda. Baxuc cu ya'aric ich u t'ʌn hebreo Betesda. Ti' c'ʌxa'an cinco yatoch tu nʌc' tu cuch u yacʌr ya'arir. Chen yatochob mʌ' pa'te'ta'an. ");
INSERT INTO lacNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ti' much'a'anob ya'ab u yajirir yejer ch'op u wich yejer a mac mech yoc yejer a mac a mʌ' ju riq'uir. Rʌc ti' yʌnob ich yatochob tu cuch yacʌr ya'arir characbarob ich ru'um. Quire' tan u pajicob u pecsa'r ya'arir. ");
INSERT INTO lacNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mʌ' ja wirej, tar cu yeman yʌjmasir u t'ʌn C'uj tu cuch yacʌr ya'arir. Tenten cu yeman yʌjmasir u t'ʌn C'uj quir u pecsic ya'arir. Caj ts'oc u pecsa' ya'arir, a mac yʌn pʌybej em ich ya'arir caj jawij u yajir cax ba' yajirir. ");
INSERT INTO lacNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ti' yʌn turi' u winiquir judío jach uch tu cʌnaj u yajir. Yʌn treinta y ocho yaxq'uin ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús caj u yiraj ti' chara'an. Yer uch yajac rajen caj u ya'araj ti': ―A c'at wa ja jawʌr? ");
INSERT INTO lacNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A yajo' caj u nunca tan ya'aric: ―In Jaj Ts'urir ―quij―, mʌna' mac cu bin u yacsiquen tu cuch u yacʌr ya'arir, cu ts'ocar u pecsa'r ya'arir. Cax in c'at in wocar, u jer cu tar, raji' cu bat'an ocar. ");
INSERT INTO lacNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús caj ya'araj ti': ―Riq'uen cats'e yor xa'an ca' ximbanʌquech. ");
INSERT INTO lacNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Seb caj jawij caj u cats'a yor xa'an caj u yʌnxchun u ximbar. Chen ra' u q'uinin cu jesic u bʌj u winiquirob judío caj jawsa'b ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Rajen u winiquirob judío caj ya'arob ti' a mac jawsa'b: ―Ti' toy u q'uinin quir ic jesic ic bʌjex, tech tan a cʌrʌxbetic u t'ʌn Moisés quire' tan a cuchic yor xa'an. ");
INSERT INTO lacNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A xibo' caj u nuncaj tan ya'aric ti'ob: ―A mac a tu jawsajen. Raji' caj u ya'araj ten: “Cats'ej yor xa'an ca' ximbanʌquech” ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Robob caj u c'atob ti': ―Mac caj u ya'araj tech cats'ej yor xa'an ca' ximbanʌquech? ");
INSERT INTO lacNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","A jawsa'b u yajirir mʌ' yer mac jawsej quire' seb caj binij Jesús quire' pim winicob caj u much'quintajob u bʌj. ");
INSERT INTO lacNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pachir Jesús caj u nup'aj tu jap'nin carem naj. Jesús caj ya'araj ti': ―Jawech baje'rer. Mʌ' toy jawac a si'pir wa ca p'atʌr ich a si'pir, jach manan ca bin a muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A xibo' caj bin ich u jach ts'urirob sacerdote caj ya'araj ti'ob: ―A mac a tu jawseni', raji' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Quire' Jesús caj u jawsaj a xibo' u q'uinin u jesic u bʌj u winiquirob judío rajen u jach ts'urirob sacerdote cu p'acticob Jesús. U c'atob u quinsicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús caj ya'araj ti'ob: ―In Teto' ti' toy cu beyaj. Baxuc aro' ti' toy quin beyaj xan. ");
INSERT INTO lacNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Rajen u jach ts'urirob sacerdote u c'atob u jach quinsicob Jesús. Cu tucricob mʌ' ju cʌnantaj u q'uinin tu cu jesicob u bʌj u winiquirob judío. Bayiri' quire' caj ya'araj: “Raji' in Tet C'uj.” Baxuc tu p'eri'quintaj u bʌj yejer C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús caj ya'araj ti'ob: ―Taj a ba' quin wac techex, a teno' u pararen C'uj. In bʌjiri' mʌ' c'ucha'an in wor ti' ba'. Quin chen betic a ba' quin wiric u betic in Tet. A ba' cu betic in Tet, baxuc a teno' quin betic quire' u pararen. ");
INSERT INTO lacNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","In Tet cu yajquintiquen quire' u pararen. Cu yesic ten tu cotor ba' cu betic. Techex baje'rer ta wirex chichin a ba' caj in betaj. Je' u cha'ic in betic C'uj jach manan carem in beyaj. Ca' bin ts'ocac in betic, jach manan cu bin jac'ʌr a worex. ");
INSERT INTO lacNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","An ten bic in Tet cu ric'sic a quimeno' soc u ts'ic u cuxtar. Baxuc a teno' quin ts'ic u ca' cuxtar a mac in c'at u ca' cuxtarob. ");
INSERT INTO lacNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","In Teto' mʌ' ju bin u jʌsic a mac yʌn u si'pirob. Chen tu ya'araj ten, quire' u pararen, soc in jʌsic a mac yʌn u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Rajen tu cotor mac je' u sʌjtiquen an ten bic cu sʌjticob in Tet. A mac a mʌ' ju sʌjtiquen cax u pararen C'uj, baxuc mʌ' ju sʌjta' in Tet a mac a tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jesús caj ya'araj ti'ob: ―Taj quin wa'aric techex: C'uchij tu q'uinin a mac a cu yubic in t'ʌn a teno' u pararen C'uj, a mac a cu yubic in t'ʌn wa cu yacsic tu yor ti' a mac a tu tuchi'tajen, je' u cuxtar munt q'uin. Mʌ' ju bin ts'abir u muc'yaj. Baxuc mʌ' ju bin satʌr chen cu bin ts'abir u cuxtar ric'ben quir u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Taj quin wa'aric techex. C'uchij tu q'uinin a mac a cu yubic in t'ʌn a teno' u pararen C'uj. A techexo' irechex wa quimrechex ʌcʌtan ten. A mac a cu yacsic tu yor in t'ʌn je' u cuxtar munt q'uine'. ");
INSERT INTO lacNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","An ten bic in Tet C'uj yʌn u muc' quir u ts'ic u cuxtar munt q'uin ti' mac. Baxuc caj u ts'aj ten u muc' quir in ts'ic u cuxtar munt q'uin ti' mac, quire' u pararen. ");
INSERT INTO lacNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Baxuc caj u ts'aj ten u muc' quir in jʌsic mac a yʌn u si'pirob quire' a teno' bajeneno' winic ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mʌ' u jac'ʌrex a worex quire' caj in wa'araj techex aro'. Mʌ' ja wirej, je' u c'uchur tu q'uinin tu cotor mac a quimeno' cu bin u yubic in t'ʌn quire' u pararen C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tu cotor mac cu bin riq'uir tu mucnaj. A mac a tu betaj tsoy cu bin cuxtar munt q'uin ich ca'anan. A mac a tu betaj c'aso' cu bin ts'abir u muc'yaj quire' ra' u bo'orir u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesús caj ya'araj: ―A teno' ―quij―, in bʌjiri' mʌ' c'ucha'an in wor ti' ba'. An ten bic caj u ya'araj in Tet baxuc quin bin in jʌsic a mac a yʌn u si'pirob. Taj quin bin in jʌsic mac. A teno' mʌ' in bin in jʌsej an ten bic in c'at. A teno' quin betic an ten bic u c'at in Tet a tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Quire' techex ca tucriquex in bʌjiri' quin tsicbar tin junan. Rajen ca tus tucriquex mʌ' c'ucha'an a worex a wacsiquex ta worex ten. ");
INSERT INTO lacNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yʌn ten mac cu tsicbar ti' ten. Taj a ba' cu tsicbar ti' ten. ");
INSERT INTO lacNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","A techexo' ta tuchi'tajex mac quir u c'ata' ti' Juan a cu yacsic ja' caj u jo'r mac. Taj a ba' tu ya'araj techex Juan ten. ");
INSERT INTO lacNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mʌ' ba'wir Juan quir u tsicbar ten. Quin chen aric techex aro' quir in c'asictechex soc c'ucha'an a worex a wacsiquex ta worex. ");
INSERT INTO lacNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","A Juano' irej quib, cu ye'c'ac'tic a berex soc chʌca'an a berex tu ca binex. Cax tabar u q'uinin, Juan caj u camsaj techex soc a werex ten. Qui'ex a worex caj u tsec'taj techex Juan. ");
INSERT INTO lacNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","A Juano', tu chen tsicbʌtajen. Chen in beyaj cu cha'ic C'uj in betic jach carem. Aro' cu yesic techex C'uj tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","In Tet C'uj a mac tu tuchi'tajen, raji' cu tsicbʌtic ten. A techexo' mʌ' ja wu'yʌmʌnex chichin u tsicbar, mʌ' ja wiramʌnex bicyʌra' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Quire' mʌ' ti' yʌn u t'ʌn ta pixamex. Rajen mʌ' ja wacsiquex ta worex ti' ten a mac tu tuchi'tajen C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mʌ' ja wirej, rajra' ca qui' xaquiquex u t'ʌn C'uj tu ts'iba'an quire' ca tus tucriquex baxuco' ca bin a cuxtarex munt q'uin. Chen u t'ʌn C'uj mʌ' ju ya'aric aro'. Cu tsicbar ti' ten a ts'iba'an u t'ʌn C'uj quir in ts'ic a cuxtarex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Chen a techexo' mʌ' ja c'at a wacsiquex ta wor ti' ten quir in ts'ic a cuxtarex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Cax mʌ' a sʌjtiquenex mʌ' jin pʌq'uiquechex. ");
INSERT INTO lacNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Quire' in werechex, mʌ' ja yajquintiquex C'uj ta pixamex. ");
INSERT INTO lacNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A techexo' mʌ' a c'at a wacsiquex ta wor ti' ten cax ti' in tar ich in Tet. Chen a mac mʌ' tuchi'ta'b ten in Tet ca sʌjtiquex. ");
INSERT INTO lacNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mʌ' c'ucha'an a worex a wacsiquex ta worex quire' ca pachtiquex ca' u tus yirechex a rac'ob jach tsoyechex. Mʌ' ja wirej, mʌ' tan a cʌxtiquex soc chen C'uj cu yiriquechex jach tsoyechex. ");
INSERT INTO lacNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mʌ' a chen tucriquex wa chen ten quin bin in ta'quiquex a jo'rex ʌcʌtan ti' in Tet. Quire' ca tus tucriquex a qui' cʌnantiquex tu cotor a ba' ts'ibta'b ich u t'ʌn Moisés. Ta pʌyex a si'pirex quire' mʌ' ta quibex an ten bic caj u ya'araj Moisés uch. ");
INSERT INTO lacNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wa ta quibex a ba' caj u ts'ibtaj Moisés baxuc je' a quibiquex in t'ʌn quire' Moisés tu ts'ibtaj ten uch. ");
INSERT INTO lacNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Quire' wa mʌ' a quibiquex a ba' caj u ts'ibtaj Moisés uch, baxuc xan mʌ' ja bin a quibex a ba' quin wac techex xan ―baxuc caj ya'araj Jesús ti' u jach ts'urirob sacerdote. ");
INSERT INTO lacNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pachir Jesús caj binij pichij c'ac'nab Galilea. U jer u c'aba' u c'ac'nabir Tiberias. ");
INSERT INTO lacNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ya'ab mac tan u binob tu pach Jesús quire' tu yirob carem u beyaj. Baxuc caj yirob u jawsa'rob a mac yʌn u yajirir. ");
INSERT INTO lacNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Rajen Jesús naquij ich u jo'r chan p'uc wits yejer u camsʌwinicob Jesús caj curʌj quir u camsic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tabar u c'uchur tu q'uinin u qui'qui' janʌnob u winiquirob judío ra' u q'uinin pascua. ");
INSERT INTO lacNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús caj u yiraj a pimo' tan u tarob cʌxta'bir. Rajen caj u ya'araj ti' Felipe: ―Tu quic bin ic mʌnic yoch pan quir ic jansic a pimo' a cu tarob. ");
INSERT INTO lacNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Baxuc caj u ya'araj Jesús quire' cu tumtic Felipe yubej ba' cu ya'aric quire' a Jesúso' yer ba' cu bin u betej. ");
INSERT INTO lacNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe caj u nuncaj ti' tan ya'aric: ―Cax wa yʌn u taq'uin a mun cu jaric mac turiri' yaxq'uin, quir a mʌnic yoch pan ti' a pimo', mʌ' ju bin nup'ur cax ca'ca' xet'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrés, ra'iri' u camsʌwinic Jesús xan. Andrés, u yits'in Simón Pedro, caj ya'araj ti': ");
INSERT INTO lacNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ti' yʌn chan chichan tera' yʌn ti' cinco yo'och pan beta'b ti' u pʌc'ar cebada ra' yoch u winiquirob judío. Yejer ca'tur cʌy. Je' wa ju rʌc nup'ur ti' a pimo' quire' jach pim? ");
INSERT INTO lacNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús caj ya'araj ti' u camsʌwinicob: ―Arex ti'ob ca' curacob ich su'uc. Quire' ti' yʌn ya'ab su'uc tub yʌnob. Caj curʌjob, yʌn cinco mil xib. Mʌ' tu xacajob mun xquic yejer chichan. ");
INSERT INTO lacNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús caj u chucaj pan a cincojo' caj u ya'araj ti': ―Bayo' C'uj. Caj ts'oqui' caj u ts'aja ti' u camsʌwinicob quir u jʌsicob ti' a pimo', a ti' cura'anob. Baxuc caj u betaj xan yejer yoch cʌy, tan u rʌc jʌsic ti'ob a mun u c'at. ");
INSERT INTO lacNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Caj nachʌjob. Jesús caj ya'araj ti' u camsʌwinicob: ―Marex u xet'er tu' mʌ' ju rʌc jantob soc mʌ' u sa'atʌr. ");
INSERT INTO lacNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Rajen tu rʌc marob u xet'er. Caj u but'ob ich xac, rʌc chupij doce xac a mun yʌn samo' cinco yoch pan a beta'b ti' yoch cebada. ");
INSERT INTO lacNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A pimo' caj u yirob ba' caj u betaj Jesús quire' yerob carem u beyaj. A pimo' cu pacran aricob: ―Mʌ' wa raji' jach jaj yʌjtseq'uir u t'ʌn C'uj a ara'b bin u ca' tar tera' ich yoc'ocab? ");
INSERT INTO lacNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Chen Jesús caj u najtaj a pimo' u c'at u ts'ʌricob u pach u yocar rey ten u piman. Rajen Jesús caj bin tu junan ich u jo'r p'uc wits. ");
INSERT INTO lacNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","U camsʌwinicob Jesús tan yiricob tan yac'birchʌjʌr caj bin ich chi' c'ac'nab. ");
INSERT INTO lacNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Caj ruc'ocob ich chem quir u ch'ʌcticob c'ac'nab quir u c'uchurob ich u cajar Capernaum. Jach ac'birchʌjij tan u binob ich chem. A Jesúso', mʌ' toy uruqui'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Caj u yʌnxchun u tar yic'ar. Jach c'am caj jach nuquij u tar u yamin xan. ");
INSERT INTO lacNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Caj nachijob tan u binob yejer chem. Yʌn cinco kilómetros caj yirob Jesús. Tan u ximbar ich yoc'o ja', tan u c'ʌs nats'ʌr ich chem caj u ch'aj sajquirob u camsʌwinicob caj yirob u tar Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Chen Jesús caj ya'araj ti'ob: ―Ten ca wiriquenex ―quij―, mʌ' a ch'iquex sajquir. ");
INSERT INTO lacNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Caj qui'jij yorob caj acsa'b Jesús ich chem. Rajen seb caj c'uchob pichij c'ac'nab tu cu binob ca'ch. ");
INSERT INTO lacNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Caj sasij a pimo' a p'atob pichir c'ac'nab caj u najtob binob u camsʌwinicob tu junanob ich chem. Quire' ti' yʌn turiri' u chem ich chi' c'ac'nab ca'ch. Caj u najtob xan mʌ' binij Jesús yejer u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tarob u jer chemob ti' u tar ich u cajar Tiberias ti' manob tu' jansa'b a pimo' ten u Jaj Ts'urir caj ts'oc ya'aric: ―Bayo' C'uj ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Quire' tu yirob mʌ' ti' yʌn Jesús mʌ' ti' yʌn u camsʌwinicob xan. Caj ocob ich chem. Caj binob ich u cajar Capernaum quir u cʌxta'ob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Caj c'uchob a pimob ich pichi c'ac'nab caj u nup'ob Jesús caj u c'atob ti', tan ya'aricob: ―In wʌjcamsʌyʌjirech, tu' q'uin c'uchuquech tera'? ");
INSERT INTO lacNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús caj ya'araj ti'ob: ―Taj quin wa'aric techex. Tarechex a cʌxtiquenex quire' ta wu'yajex najchʌjechex ti' a woch pan. Mʌ' tarechex a cʌxtiquenex quire' ta wacsajex ta wor ten a carem beyaj tin betaj. ");
INSERT INTO lacNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mʌ' rajra' ca tucriquex a wochex quire' cu xupur aro'. Ca' a cʌxtex a wochex ti' a pixamex quire' munt q'uin ti' yʌn a pixamex. Je' in ts'ic techex a teno' a mac tuchi'ta'b ten C'uj. Quire' baxuc caj u ts'aj in beyaj in Tet C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","A pimob caj u nuncob tan ya'aricob: ―Bic tabar ic betic u beyaj C'uj? ");
INSERT INTO lacNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús caj u nuncaj ti'ob tan ya'aric: ―Ra' u beyaj C'uj quir a wacsiquex ta worex ten quire' tu tuchi'ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","A pimob caj ya'arob: ―Ba' carem beyaj ca wesic tenob soc c'ucha'an in worob in wacsicob tin worob ti' a t'ʌn? Ba' beyaj ca wesic tenob? ");
INSERT INTO lacNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ic nunquir caj u jantob yoch mana a irej waj uch ich tacay ru'um. Baxuc cu ya'aric tu ts'iba'an u t'ʌn C'uj: “A tu ts'aj ti'ob yoch waj a manajo' a cu tar ich ca'anan. Baxuc tech yʌn a ts'ic tenob.” ");
INSERT INTO lacNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús caj ya'araj ti'ob: ―Taj quin wac techex. Mʌ' Moisés caj u ts'aja ti' a nunquirex yoch pan a manajo' ich tacay ru'um. C'ub u beyaj Moisés ten C'uj. Chen C'uj tu ts'aj ti'ob quir u janticob. A tu jantajob a nunquirex uch chen quir u cuxtar a tera' ich yoc'ocab. Chen baje'rer in Tet cu bin u ts'ic techex a wochex quir a cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","A C'ujo' cu ts'ic yo'och a jach jaj cu tar ti' ca'anan. A je' ocha' quir a cuxtarex munt q'uin a mac a ti' yʌnob ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","A pimob caj u ya'araj ti' Jesús: ―In Jaj Ts'urob rajra' ca ts'ic tenob in woch panob a ca tsicbʌtic tenob baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús caj ya'araj ti'ob: ―An ten bic cu cuxriquechex ti' a wo'och wajex. Baxuc a teno' iren waj quir a cuxtarex munt q'uin. A mac a cu tar tin wicnʌn tan yacsic tu yor ten. Aro' irej wa mʌ' u yuc'chʌjʌr baxuc irej wa mʌ' ju wi'chʌjʌr xan. ");
INSERT INTO lacNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Chen a teno' caj in wa'araj techex cax ta wirenex mʌ' a c'atex a wacsex ta worex ten. ");
INSERT INTO lacNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tu cotor mac a cu ts'abʌr ti' ten C'uj. Je' u tar tin wicnʌn. A mac a cu tar tin wicnʌn ten qui' in wor in ts'ic ti'ob u cuxtar munt q'uin. Mʌ' biq'uin quin bin in joc'sic. ");
INSERT INTO lacNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","In Tet caj u tuchi'tajen mʌ' quir in betic a ba' in c'at a teno'. A teno' taren quir in betic a ba' u c'at in Tet quire' raji' tu tuchi'ten. ");
INSERT INTO lacNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","In Tet a mac a tu tuchi'ten, u c'at u yiric tu cotor mac a tu ts'ajten mʌ' u sa'tʌr mʌ' turiri'. Wa cu quimin je' in ric'sic ca' bin c'uchuc tu q'uinin u xur t'ʌne'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Baxuc u c'at in Tet xan tu cotor mac a cu ya'aric: “U pararech C'uj” ti' ten. A mac a cu quibic in t'ʌn je' in taquic soc u cuxtar munt q'uin. Wa cu quimin je' in ric'sic ca' bin c'uchuc tu q'uinin u xur t'ʌne'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","U winiquirob judío caj u yʌnxchun u choctar yorob ti' Jesús quire' a ba' caj u yubob ya'aric quire' Jesús caj u ya'araj: “A teno' iren a woch wajex a cu tar ich ca'anan quir a cuxtarex munt q'uin.” ");
INSERT INTO lacNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","U winiquirob judío caj ya'arob; tan u pacran aricob: ―Mʌ' wa raji' Jesús, u parar José? Ij quiramʌn u tet yejer u nʌ'. Chen cu ya'aric ti' u tar ich ca'anan. Bic tabar aro'? ");
INSERT INTO lacNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús caj u nuncaj ti'ob tan ya'aric: ―Mʌ' u choctar a worex ten. ");
INSERT INTO lacNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mʌna' mac cu bin tar tin wicnʌn quir u yacsic tu yor wa mʌ' teta'b ten C'uj a mac tu tuchi'tajen. A mac cu tar tin wicnʌn quir u yacsic tu yor wa cu quimin je' in ca' ric'sique' ca' binin c'uchuc u q'uinin cu xur t'ʌne'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mʌ' ja wirej, baxuc tu ts'ibtajob yʌjtseq'uirob u t'ʌn C'uj uch, tan ya'aricob: “Tu cotor mac cu bin camsabir ten C'uj.” Baxuc caj u ya'arajob yʌjtseq'uirob u t'ʌn C'uj. Rajen tu cotor mac tu yubob a ba' caj u ya'araj Juan a mac Jesúso', quij Juan. Raji'ob camsa'b ten C'uj, rajen cu tar tin wicnʌn quir u cʌnicob in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Mʌna' mac yiramʌn u wich C'uj. Caj ya'araj Jesús. Chen ten tin junan caj in wiraj u wich C'uj quire' ti' in tar a teno' ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Taj a ba' quin wac techex ―quij Jesús―, a mac a cu yacsic tu yor tene' yʌn u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A teno' iren a woch wajenex ―quij Jesús―, quir in ts'ic a cuxtarex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A nunquirex a ucho' caj u jantob yoch mana irej a woch panex ich tacay ru'um. Chen mʌ' ju yirob u cuxtar munt q'uin cax tu jantajob a manajo', chen quimob. ");
INSERT INTO lacNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","A woch panex a quin tsicbar techex, toc tarij ti' ca'anano' soc a mac a cu jantic ti' je' u cuxtar munt q'uine'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","A teno' taren ich ca'anan, iren a woch wajenex quir a cutarex munt q'uin. Tu cotor mac a cu jantic yoch waj a quin tsicbar ti' techex, je' u cuxtar munt q'uine'. A woch wajex a quin ts'ic techex raji' in winquirir. Je' in ts'ic ti' soc tu cotor mac cu bin u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Rajen u winiquirob judío caj u chich arob tan ya'aricob: ―Bic tabar cu bin u ts'ic to'on u winquirir quir ic chi'ic? ");
INSERT INTO lacNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús caj ya'arj ti'ob: ―Taj quin wa'aric techex wa mʌ' a jantiquex in winquirir a teno' iren techex mʌ' ja bin a cuxtarex munt q'uin. Wa mʌ' ja wuq'uiquex in q'uiq'uer mʌ' ja bin a cuxtarex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","A mac a cu jantic in winquirir yejer in q'uiq'uer cu yuq'uic, munt q'uin cu bin cuxtar wa cu quimin. A teno' je' in ric'sic ca' bin c'uchuc tu q'uinin u xur t'ʌne'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mʌ' ja wirej, in winquirir irej a jach ochex a ca jantiquex. In q'uiq'uer xano' irej a jach uc'urex a ca wuq'uiquex. Rajen a mac a cu jantic je' u cuxtar munt q'uine'. Baxuc a mac a cu yuq'uic in q'uiq'uer je' u cuxtar munt q'uine'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","A mac a cu jantic in winquirir baxuc cu yuq'uic in q'uiq'uer p'eri'en yejer quire' ti' yʌnen tu pixam. ");
INSERT INTO lacNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","In Teto' a mac tu tuchi'tajen raji' yʌn u cuxtar munt q'uin quire' a C'ujo' toc berer uch. Rajen yʌn in cuxtar a teno' quire' in Tet C'uj. Baxuco' a mac a cu jantic in winquirir cu bin u cuxtar munt q'uin quire' ten quin ts'ic u cuxtar. ");
INSERT INTO lacNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A woch wajex a quin tsicbʌtechex ts'oc u tar ich ca'anan. Raji' mʌ' quet yejer yoch mana a tu jantob a nunquirex uch. Quire' mʌ' tu yirob u cuxtarob munt q'uini' cax tu jantob a manajo' toc rʌc quimob uch. Chen a mac cu jantic a wajo' a quin tsicbʌtechex baje'rer munt q'uin cu bin cuxtar. ");
INSERT INTO lacNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ti' tu camsajob a jera' ich u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío ich u cajar Capernaum. ");
INSERT INTO lacNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ya'ab u q'uinin tan u tar ya'ab mac tu pach Jesús quir u cʌnicob u t'ʌn. Caj u yubob a ba' caj u ya'araj Jesús caj ya'arob: ―Jach yaj ij cʌnic aro' mʌ' ij c'at ij cu'yic aro'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Chen Jesús tu najtaj tu yor tan u choctar yorob u camsʌwinicob. Rajen tu c'ataj ti'ob: ―Cu joc'siquex wa ja worex a tin wa'araj techex? ");
INSERT INTO lacNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ba' ca bin a wa'ariquex wa ca' bin a wirex in bin tub in wʌc'ʌs tar uch a teno' a mac tuchi'ta'ben ten C'uj? ");
INSERT INTO lacNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Quire' a pixamex je' u cuxtarex munt q'uin quire' a winquirirex mʌ' neno'ji'. Mʌ' ja wirej, in t'ʌn a tin wa'araj techex, raji' ti' a pixamex quir u cuxtarex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ti' toj yʌnechex jun yarechex, mʌ' toy a wacsex a worex. Quire' Jesús u toc er tu yʌnxchun u beyaj mac cu quibic u t'ʌn, baxuc a mac a cu bin u c'ubur Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Caj ara'b ti'ob ten Jesús: ―Rajen caj in wa'araj techex uch mʌna' mac cu tar tu yʌnen quir u cʌnic in t'ʌn wa mʌ' teta'b ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Rajen ya'ab mac a cu sayʌr tu pach Jesús caj u p'ʌtob u binob tu pach Jesús caj wʌc'ʌs binob tu yatoch. ");
INSERT INTO lacNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús caj u c'ataj ti' u camsʌwinicob a docejo': ―Ba' ca tucriquex? Je' wa ja wʌc'ʌs binex ta watochex? ");
INSERT INTO lacNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro caj u nuncaj ti' Jesús tan ya'aric: ―Mʌna' mac quir ic bin ic tsicbar ti' u t'ʌn C'uj. Chen a techo' yʌn a t'ʌn quir ij cuxtarex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Quire' a tenobo' tin toc wacsob tin worob tech. Quire' a techo' in werob Cristojech raji' tu ts'aj a beyaj C'uj quir a yamtiquenob quire' u pararech C'uj a cuxa'ano'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús caj u nuncaj ti'ob tan ya'aric: ―A teno' tin tetajechex doce chen ti' yʌn turiri' ich techex a mac aca'an quisin ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús tan u tsicbar, ti' Judas u parar Simón Iscariote quire' raji' cu bin u c'ubic Jesús. Quire' raji' turiri' ich a doce u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pachir caj bin Jesús ich u ru'umin Galilea quire' mʌ' u c'at u bin ich u ru'umin Judea quire' u ts'urirob u winiquirob judío u c'at u quinsicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tabar u c'uchur tu q'uinin u qui' janʌnob u winiquirob judío ra' u q'uinin cu c'ʌxicob paser an ten bic ara'b ten C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Rajen ara'b ti' Jesús ten u yits'inob: ―Mʌ' a p'atʌr tera' ca' xico'on ich u ru'umin Judea. Soc a camsʌwinicob ca' bin u yirob a carem beyaj tu q'uinin u qui'qui' janʌnob u winiquirob judío soc yerob C'uj tu ts'aj a beyaj tech. ");
INSERT INTO lacNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Quire' mʌna' mac cu muc u beyaj wa ju c'at u yeticob tu cotor mac u beyaj. Joq'uen es a bʌj ti' a pimob wa ca beyaj ti' C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Cax raji' yʌjtaquirob mʌ' ju yacsob tu yorob u yits'inob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús caj ya'araj ti' u yits'inob: ―Mʌ' c'uchuc tu q'uinin ten quir in bin ich u cajar Jerusalén quir in qui'qui'janʌn. Chen techex xenex wa ja c'at a binex. ");
INSERT INTO lacNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Rajen, mʌ' ja wirej, a mac ti' yʌn ich yoc'ocab mʌ' ju p'actiquechex a techexo', chen a teno' cu p'actiquenob quire' quin wa'aric ti'ob c'as cu beticob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Xenex ta qui'qui' janʌnex ich u cajar Jerusalén. Quire' a teno' mʌ' c'uchuc tu q'uinin in bin hasta cu c'uchur tu q'uinin jeroj quin bin. ");
INSERT INTO lacNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Caj ts'oc ya'aric mʌ' ju bin, ti' p'at Jesús ich Galilea yejer u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Caj ts'oc u binob u yits'inob Jesús ich u cajar Jerusalén quir u qui'qui' janʌnob caj bin Jesús yejer u camsʌwinicob. Mʌ' bin yejer u rac'ob chen tu junan yejer u camsʌwinicob caj bin, quire' mʌ' u c'at u yesic u bʌj ti' a pimob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","U ts'urirob sacerdote tan u cʌxticob Jesús u q'uinin cu qui'qui' janʌnob u winiquirob judío. Tan u c'aticob: ―Tu' yʌn? ―quijob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mʌ' ja wirej, a pimob rajra' cu tsicbarob ti' Jesús. Yʌn mac tan ya'aricob: “Jach tsoy a Jesúso'.” Chen yʌn u jerob cu ya'aricob: “Bic tabar jach tsoy. Quire' cu tusaric ti' mac.” ");
INSERT INTO lacNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Quire' cu sʌjticob u ts'urirob sacerdote. Rajen cu manob u muc u aricob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Caj c'uchij chumuc u q'uinin u qui'qui' janʌnob Jesús caj bin ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío caj u yʌnxchun u camsic. ");
INSERT INTO lacNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Caj jaq'uij yorob a pimob, rajen tu ya'arob: ―Bic tabar ij quet winquirir caj u cʌnaj quire' mʌna' mac tu camsaj chen u ne'er u camsa'? ");
INSERT INTO lacNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús caj u nuncaj ti'ob tan ya'aric: ―Mʌ' ra' in t'ʌn a quin camsic techex. Raji' u t'ʌn in Tet a mac tu tuchi'ten. ");
INSERT INTO lacNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wa mac u c'at ca' u betej a ba' C'uj u c'at. Cu bin ts'abir u najtic ich u t'ʌn C'uj tu' quin camsic wa raji' cu tar ich C'uj wa chen in bʌjiri' in t'ʌn quin camsic. ");
INSERT INTO lacNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A mac a cu camsic u bʌjiri' u t'ʌn tan u cʌxtic soc sʌjta' ten mac. A teno' tan in cʌxtic ca' a sʌjtex a mac a tu tuchi'tajen. Rajen mʌ' tan in tusariquex, taj a ba' quin wac techex. ");
INSERT INTO lacNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés caj u tsec'taj techex uch a ba' tu toc araj C'uj uch. Chen techex mʌ' turiri' tan a quibiquex a ba' caj u ya'araj Moisés uch quire' wa ta quibajex, mʌ' ja tsicbʌtiquex a c'atex a quinsiquenex. ");
INSERT INTO lacNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A pimob caj u nuncob tan ya'aric: ―Aca'an quisin tech, mac u c'at u quinsiquech? ");
INSERT INTO lacNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús caj ya'araj: ―A teno' tin jawsa mac turiri', u q'uinin ca jesiquex a bʌjex, raji' tu jac'saj a worex. ");
INSERT INTO lacNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés caj u ts'aj u t'ʌnin quir a ts'iriquex a pararex xib tu cu wix. Mʌ' Moisés tu yʌn a'raji', chen a nunquirex, raji' tu yʌn a'raj. Rajen cax u q'uinin ca jesiquex a bʌjex ca ts'iriquex a chan pararex xib. ");
INSERT INTO lacNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tsoy ca' quibiquex u t'ʌn Moisés tu cu ya'aric: “Ts'irej a chan pararex xib.” Cax tu q'uinin ca jesiquex a bʌjex ca' ts'iric. Rajen biquinin ca p'actiquenex ca wiric in jawsic mac u q'uinin ca jesiquex a bʌjex. ");
INSERT INTO lacNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mʌ' tsoy wa sep ca ta'quiquex u jo'r mac. Ca' a qui' tucrex wa taj tan u betic c'as mac. ");
INSERT INTO lacNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A mac a ti' cʌja'anob ich u cajar Jerusalén caj ya'arob: ―A je' xiba' mʌ' wa raji' tu cʌxticob u quinsej. ");
INSERT INTO lacNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Iric ti' yʌn. Mʌ' tu mucra'r tu ya'araj ich tu cotor mac. U jach ts'urirob sacerdote mʌna' ba' caj u ya'arob ti'. Jaj ix tʌco' tan u quibicob raji' Cristo a cu taro'. ");
INSERT INTO lacNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","A to'onexo' ij querex tub u tar a ra xibo'. Chen ca' bin tac a Cristojo' ij cʌjtaquirex mʌna' mac yer tub u tar ―baxuc caj ya'araj a mac cʌja'anob ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Rajen Jesús caj u c'am araj tu cu camsic ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u ya'araj ti' a pimob: ―Ca tucriquex a werenex. Ca tucriquex a werex tub in tar. In wʌc'ʌs bʌjiri' mʌ' taren chen a mac jach tajo', raji' tu tuchi'tajen. Chen a techexo', mʌ' a werex maqui' a tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","A teno' ―quij Jesús―, in wer quire' ti' in tar tub yʌni'. Quire' raji' tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Rajen u c'atob u chuquicob Jesús quir u bin u mʌquicob tu cu ma'cʌr winic. Mʌ' c'ucha'an yorob u chuquejob Jesús quire' mʌ' c'uchuc tu q'uinin cu chuquicob quir u mʌquicob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yʌn ya'ab mac tu yacsob tu yorob ti' quire' yerob yʌjtaquirob. Caj ya'arob: ―A je' xibo' jach manan carem u beyaj caj u yesaj to'onex an ten bic cu ya'aric cu bin u betej Cristo ca' bin tac. Rajen ij querex raji' Cristo. ");
INSERT INTO lacNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","A fariseojo' caj yubob ya'aric a mac tu yacsob tu yor ti' Jesús. Tu yubob ya'aricob a Jesúso': ―Raji' Cristo a cu bin tar. Rajen a fariseojo' yejer u jach ts'urirob sacerdote caj u tuchi'tajob u policía a cu beyajob ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío quir u chuquicob Jesús quir u mʌquicob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús caj ya'araj ti' a pimob: ―Mʌ' ya'ab u q'uinin quin p'atʌr tub yʌnechex quire' bin in ca' tub yʌn a mac a tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Quire' a techexo' ca bin a cʌxtiquenex chen mʌ' ja bin a wirenexi'. Quire' a tu quin bino' mʌ' c'ucha'an a worex a tarex. ");
INSERT INTO lacNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","U winiquirob judío tan u pacran tsicbarob tan ya'aricob: ―Tub u wich u bin cu ya'aric mʌ' ic yʌnyʌn iric? Ti' wa cu bin ich ij quet winquirirob judío a tar yʌnob tantanxer ich u ru'umin u winiquirob griego? U tiri' cu bin u camsic u winiquirob griego. ");
INSERT INTO lacNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Caj ya'arob: ―Ba' u c'at ya'aric to'onex a tu ya'araj to'onex: “Ca bin a cʌxtenex chen mʌ' ja bin a wiriquenex quire' a tu quin bino' mʌ' c'ucha'an a worex a tarex”? ―baxuc cu pacran tsicbarob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","U q'uinin a jach no'jo' ra' u q'uinin quir u ts'ocsic u qui'qui' janʌnob u winiquirob judío. Ra'iri' u q'uinin caj riq'uij caj ch'icrʌj Jesús caj u c'am araj ti' a pimob, tan ya'aric: ―Wa mac cu yuc'chʌjʌr, arej ca' tac ten quir u yuc'ur. ");
INSERT INTO lacNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mʌ' ja wirej, a mac a cu yacsic tu yor ten, je' u yʌn tar tu pixam an ten bic yic' ja' cu bosirancʌr a cu ts'ic u cuxtar a ricbeno' quire' baxuc cu ya'aric ich u t'ʌn C'uj ―baxuc cu tsicbar Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mʌ' ja wirej, cu tsicbar ti' u Taj'or u Pixam C'uj a cu bin ts'abir ti' a mac a cu yacsic tu yor ti'. U Taj'or u Pixam C'uj mʌ' taqui' quire' mʌ' toy xic Jesús ich ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ti' yʌn mac tu' yʌn Jesús caj yubob ya'aric baxuc aro' caj u ya'arajob: ―Aro' jach jaj yʌjtseq'uir u t'ʌn C'uj a tij cu'yajex ya'ara' yʌn u tar. ");
INSERT INTO lacNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Chen yʌn mac jujuntur tan ya'aricob: ―Raji' a jera' Cristo yʌjtaquir mac tu cotor. Ti' yʌn mac jujuntur tan ya'aricob: ―A Cristojo', mʌ' u bin tar ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Quire' cu ya'aric ich u t'ʌn C'uj tu' ts'iba'an: “A Cristojo' a ca' bin taco' ti' cu bin rochbir ten u nʌ' ich u cajar Belén quire' David, raji' u ch'ic sucu'un Cristo. Ti' cu bin rochbir ten u na' Cristo quire' ti' rocha'b u ch'ic sucu'un ten u na'.” ");
INSERT INTO lacNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Rajen mʌ' quet yorob a pimob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yʌn mac u c'atob u chuquicob quir u mʌquicob. Chen mʌna' mac tu chucajob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Caj urob a policíajo' a cu beyajob ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj c'uchob ti' yʌnob u jach ts'urirob sacerdote yejer a fariseojo'. Caj c'ata'b ti'ob ten u jach ts'urirob: ―Biquinin mʌ' ta chuquexi'? ");
INSERT INTO lacNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Caj u nuncob a policíajo' tan ya'aricob: ―Mʌna' mac cu tsicbar baxuc a tar yʌn xibo'. ");
INSERT INTO lacNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A fariseojo' caj ya'arob: ―U tus a'bar techex xan? ");
INSERT INTO lacNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mʌ' ja wirej, mʌna' u ts'urirob u winiquirob judío tu yacsaj tu yor ti'. Baxuc a tenobo' u winiquirenob fariseo, mʌ' tin wacsajob tin worob ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Chen a pimob tu yacsob tu yorob tub much'a'anob. Robob jach chichob u jo'r. Mʌ' yerob a ba' ts'iba'an ich u t'ʌn C'uj, toc rʌc satob. ");
INSERT INTO lacNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ti' yʌn Nicodemo a cu bin tsicbar yejer Jesús uch. Ac'bir caj binij. Raji' turiri' u ts'urir u winiquirob judío. Caj u ya'arajob ti' u yet winiquirob fariseo: ");
INSERT INTO lacNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Mʌ' c'ucha'an ij corex ic ts'iquex u muc'yaj mac wa mʌ' toy ij cu'yex u t'ʌn wa mʌ' tij quirex ba' u si'pir yʌn ti', quire' baxuc cu ya'aric u t'ʌn Moisés. ");
INSERT INTO lacNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Robob caj u nuncajob ti' tan ya'aricob; ―A techo' irech a mac a cu tar ich u ru'umin Galilea. Xaquej a wirej tu' ts'iba'an ich u t'ʌn C'uj. Mʌ' ja bin a wirej, cu ya'aric u tar turiri' yʌjtseq'uir u t'ʌn C'uj ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jujuntur u ts'urirob u winiquirob judío caj rʌc binob tu yatoch. ");
INSERT INTO lacNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Chen a Jesúso' yejer u camsʌwinicob caj binob ich u jo'r wits u c'aba' Olivos. ");
INSERT INTO lacNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Caj sasij caj sutnʌj Jesús caj oc ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u rʌc much'quintajob u bʌj ich Jesús. Caj curʌj Jesús caj u yʌnxchun u camsic a pimob. ");
INSERT INTO lacNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Caj c'uchob yʌjcamsʌyʌjirob u t'ʌn Moisés yejer a fariseojo'. Caj tarob u purej xquic a jach irir tan u man tu c'asir. Caj c'uchob caj u purajob ʌcʌtan tu yʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Robob caj ya'arob ti' Jesús: ―In wʌjcamsʌyʌjirechob, caj in wirob a je' xquica' caj in jach chucob tu cu man ich u c'asir. ");
INSERT INTO lacNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Quire' Moisés tu toc araj uch ca' ic ch'inex u jo'r a xquico' a quic jach iriquex cu man tu c'asir. Are tenob ba' ca wa'aric a techo'? ");
INSERT INTO lacNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Baxuc caj ya'arob quire' u c'atob u tumticob yor Jesús soc u pʌyicob u si'pir soc yʌn ba'wir quir u taquicob u jo'r. Jesús caj p'uxrʌj caj u ts'ibtaj ich u noy ru'um yejer u yar u c'ʌb. ");
INSERT INTO lacNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mʌ' ju ts'ocor u c'aticob ti' caj u tajquintaj u bʌj Jesús caj ya'araj: ―Arej a mac a mʌna' u si'pir tu yʌnechex, arej ti' raji' cu yʌn bat'an ch'inic u jo'r yejer tunich a ray pay same'. ");
INSERT INTO lacNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Caj ca' p'uxrʌj Jesús u ts'ibtej ich noy ru'um. ");
INSERT INTO lacNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Caj ts'oc u yubicob ba' nunca'b ten Jesús caj rʌc joc'ob tan u binob. Jujuntur caj rʌc binob quire' caj u tucurajob u si'pirob. Caj u yʌnxchun u binob a mac jach uch ch'ijic, pachir caj rʌc binob a mʌ' uch ch'ijiqui'. P'atij Jesús yejer xquic ich a pimob chen u ts'urirob u winiquirob judío binob. ");
INSERT INTO lacNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús caj u tajquintaj u bʌj a mac tarob u purob a xquico' rʌc binob chen xquic ti' yʌn. Rajen Jesús caj ya'araj ti': ―Xquic ―quen―. A mac a tu ta'cajob a jo'r sam mʌna', rʌc bin. Mʌna' mac tu ch'inaj a jo'r quire' yʌn a si'pir ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A xquico' caj u ya'araj: ―Mʌna' mac tu ch'inaj in jo'r, Jaj Ts'urir ―quij xquic. Jesús caj ya'araj ti': ―Baxuc a teno', mʌ' in ts'aj a muc'yaj cax yʌn a si'pir. Xen ―quij―, mʌ' a yʌnyʌn acsic a si'pir. ");
INSERT INTO lacNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús cu ca' camsic a pimob ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Caj u ya'araj: ―A teno' a quin camsic mac a ti' yʌnob ich yoc'ocab, iren quin yerc'ac'tic mac. Tu cotor mac a cu yacsic tu yor ten, mʌ' u binob ich yac'birir. Je' u binob tu sasirir quire' quin ts'ic ti'ob u cuxtar a ric'beno'. ");
INSERT INTO lacNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A fariseojo' caj ya'arob ti' Jesús: ―A wʌc'ʌs bʌjiri' ca tsec'tic tech, rajen mʌ' in quibicob. Mʌna' yʌj'irirech soc ya'aric taj a ba' ca wa'aric. ");
INSERT INTO lacNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús caj u nuncaj ti'ob tan ya'aric: ―Cax wa ca tucriquex in wʌc'ʌs bʌjiri' tan in tsec'tic. Taj a ba' quin wac techex. In wer tub in tar, baxuc in wer tu' quin bin. A techexo' mʌ' a werex tub in tar, mʌ' a werex tu' quin bin. ");
INSERT INTO lacNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","A techexo' seb ca quibiquex wa ju jer mac yʌn u si'pir. Mʌ' a qui' tucrex. A teno' ―quij Jesús―, mʌ' in tucric ba' ti' u jer mac. ");
INSERT INTO lacNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wa yʌn ba' quin tucric, taj a ba' quin tucric. In wʌc'ʌs bʌjiri' mʌ' in tucric quire' p'eri' quin tucric yejer in Tet, a mac tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ti' ts'iba'an ich u t'ʌn C'uj ti' techex: “Tsoy a quibiquex u t'ʌn quire' ca'tur yʌj'irirob wa quet u t'ʌnob.” ");
INSERT INTO lacNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","A teno' quin tsec'tic ti' in wʌc'ʌs bʌjiri'. In Teto' a mac tu tuchi'tajen, cu tsec'tic ti' ten xan. ");
INSERT INTO lacNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Robob caj u c'atob ti' tan ya'aricob: ―Tu' yʌn a Tet a ca tsicbʌtic tenob? Jesús caj u nuncaj ti'ob tan ya'aric: ―A techexo' mʌ' a werenexi'. Mʌ' a werex in Tet xan. Wa baxuc a werenex baxuc a werex in Tet xan. ");
INSERT INTO lacNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús tan u camsic a je' t'ʌna' ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío tu cu but'icob u taq'uin quir u sijic ti' u beyaj C'uj. Mʌna' mac c'ucha'an yorob u chuquicob u mʌquejob quire' mʌ' c'uchuc tu q'uinin u chuquicob u mʌquejob. ");
INSERT INTO lacNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús caj u ca' araj ti'ob: ―Tu' quin bin a teno', ca bin a cʌxtiquenex, chen mʌ' ja bin a wiriquenex ca bin a quiminex ti' a si'pirex quire' tu' quin bin a teno' mʌ' c'ucha'an a worexi' a tarex. ");
INSERT INTO lacNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Rajen u winiquirob judío caj u pacran arob, tan ya'aricob: ―Bin u ca' quins u bʌj, tin t'ʌn quire' cu ya'aric: “Tu' quin bin mʌ' c'ucha'an a worex a tarexi'”, ―baxuc cu pacran aricob. ");
INSERT INTO lacNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús caj ya'araj ti'ob: ―Mʌ' p'eri'o'onex, rajen mʌ' p'eri' ic tucriquex ba', quire' a teno' tar in tar ich ca'anan, quire' a techexo' toc ti' yʌnechex ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Rajen quin wa'aric techex: Bin a ca' quiminex ti' a si'pirex, quire' mʌ' ja wacsex ta worex ten wa ten a mac cu bin u rucsic a si'pirex. Rajen ca quiminex ti' a si'pirex. ");
INSERT INTO lacNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Robob caj u c'atob ti' Jesús tan ya'aricob: ―Maquechi'? Jesús caj u nuncaj ti'ob tan ya'aricob: ―A teno' tin toc araj techex uch maqueni'. ");
INSERT INTO lacNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yʌn toy ya'ab quir in wa'aric techex baxuc quir in wa'aric techex ba' si'pir yʌn techex. A teno' quin chen aric techex a ba' caj u ya'araj ten in Tet a mac tu tuchi'tajen. In Tet a mac tu tuchi'tajen, taj u t'ʌn a ti'o'. ");
INSERT INTO lacNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Quire' mʌ' ju yacsob tu yor ti' Jesús quire' raji' Cristo a tuchi'ta'b ten C'uj, rajen mʌ' ju najtob wa tan u tsicbar ti' u Tet C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Rajen Jesús caj ya'araj ti'ob: ―Ca' bin a sinenex ich cruz quire' a teno' a mac tuchi'ta'ben ten C'uj, ra'iri' u q'uinin ca' bin a najtex a wʌjtaquirenex. Ra'iri' u q'uinin xan ca' bin a wetiquex, jari' tin wa'araj techex an ten bic tu ya'araj in Tet, a mac a tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","In Teto' mʌ' u p'ʌten quire' rajra' quin betic a ba' u c'at ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ti' toy cu camsic ti'ob, ya'ab mac caj u yacsajob tu yorob ti', quire' yerob yʌjtaquirob. ");
INSERT INTO lacNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Rajen Jesús caj ya'araj ti' u winiquirob judío a tu yacsajob tu yorob ti': ―Wa ja techexo' teni' ta toc acsex ta worex a ba' tin wa'araj techex a baxuc aro' in jach camsʌwiniquechex. ");
INSERT INTO lacNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A teno' tan in camsic techex a ba' taj, a je' t'ʌna' a ba' taji' cu bin u cha'bʌr techex ti' a ca ts'urintiquex. ");
INSERT INTO lacNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","U winiquirob judío caj u nuncajob ti' tan ya'aricob: ―A tenobob u pararenob in nunquir Abraham, mʌ' in ts'urinticob ba'. Bic tabar ca wa'aric a siptiquenex ti' ba'. ");
INSERT INTO lacNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús caj ya'araj ti'ob: ―Taj a ba' quin wac techex. Tu cotor a mac a cu man tu c'asir raji' cu ts'urintic u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A mac a mʌnbir ten u ts'uriro' quir u beyaj ti', raji' mʌ' rajra' cu p'atʌr tu yatoch u ts'urir quire' cu bin ca' canbir ten u ts'urir. Chen a mac a jach u parar u ts'uriro', raji' u parar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","A techexo' irechex a mac a mʌnbir ten ts'ur chen a teno' a mac tuchi'ta'b ten C'uj c'ucha'an in wor in cha'iquechex soc jach jaj cha'anechex. ");
INSERT INTO lacNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Bʌ'wir ca waquex u pararechex a nunquirex Abraham quire' techex a c'atex a quinsiquenex quire' c'as ca tucriquex ta pixamex. Rajen mʌ' ju yocar in t'ʌn ta pixamex. ");
INSERT INTO lacNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A teno' tin tsec'taj an ten bic in Tet tu cha'j in wiric. A techexo' ca betiquex an ten bic a tet quisin tu toc ts'aj u t'ʌnintechex. ");
INSERT INTO lacNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Robob caj u nuncob ti' tan ya'aricob: ―Ic tetex raji' ic nunquir Abraham. Caj ara'b ti'ob ten Jesús: ―Wa ju pararechex a nunquirex Abraham ta quibex u t'ʌn C'uj xan an ten bic a nunquirex Abraham caj u quibaj u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Chen baje'rer a c'at a quinsiquenex quire' caj in wa'araj techex a ba' jach taji' a tin wu'yaj ich C'uj. A nunquirex Abraham mʌ' ju betaj baxuc a'rayo'. Jesús caj ya'araj ti'ob: ―Ca betiquex u beyaj a tetex quisin. ");
INSERT INTO lacNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Robob caj u nuncob ti' tan ya'aricob: ―A tenob mʌ' u pararenob a yʌn u si'pir ―quij ya'aric u winiquirob judío―. Jari' yʌn tenob turiri' in tetob. Raji' in Tetob C'uj ―baxuc caj ya'araj u winiquirob judío ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús caj ya'araj ti'ob: ―Wa ja jach tetex C'uj je' a yajquintiquenex quire' a teno' taren ich C'uj. Mʌ' in bʌjiri' taquen quire' C'uj tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mʌ' ja najtiquex in t'ʌn quire' mʌ' a c'at a najtiquex in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","A techexo' a tetex quisin. Mʌ' ja wirej, ta pixamex ca betiquex a ba' u c'at a tetex. Raji' yʌjquinsir mac uch tu yʌnxchun a winico' ich yoc'ocab uch. Mʌ' u c'at a ba' jach taji' quire' mʌna' u tajir tu pixam. Wa cu tus xan, cu tus quire' a cu tuso' u tet quisin, rajen cu camsic tus. ");
INSERT INTO lacNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Quire' taj a ba' quin wac techex, rajen mʌ' a c'atex a quibiquex in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mʌ' c'ucha'an a worex a wiriquex wa yʌn in si'pir. In t'ʌn a tin wa'araj techex taj, rajen biquinin mʌ' ja quibiquex in t'ʌn? ");
INSERT INTO lacNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","A maque', raji' C'uj yʌnin cu yubic u t'ʌn C'uj. Rajen a techexo' mʌ' C'uj yʌninechex. Rajen mʌ' a c'atex a wu'yiquex u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Caj ya'arob u winiquirob judío ti' Jesús. ―Taj a ba' quic tucriquex uch. U winiquirech samaria aca'an tech c'ac'as quisin ―baxuc tan u tus pac'ʌr u pach Jesús ten u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús caj u nuncaj ti'ob, tan ya'aric; ―A teno' mʌ' aca'an ten c'ac'as quisini'. A teno' quin sʌjtic in Tet chen a techexo' mʌ' ja sʌjtiquenex. ");
INSERT INTO lacNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A teno' mʌ' jin cʌxtic soc u sʌjtiquen mac quire' in Tet u c'at yiric u sʌjtiquen tu cotor mac. A mac mʌ' u sʌjtiquen ca' bin c'uchuc tu q'uinin. Je' u ya'ara' ten C'uj: Biquinin mʌ' ja sʌjtaj Jesús uch? ");
INSERT INTO lacNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Taj a ba' quin wac techex a mac a cu quibic in t'ʌn mʌ' ju bin quimin ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","U winiquirob judío caj ya'arob: ―Baje'rer ij quer aca'an quisin tech. Quire' ic nunquir Abraham quimij uch. Baxuc yʌjtseq'uirob u t'ʌn quimob uch. Chen tech ca wa'aric: “A mac a cu quibic a ba' quin wa'aric ti' mʌ' ju bin quimin.” ");
INSERT INTO lacNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Biquinin a techo' ca tucric jach no'jech a beyaj? Ic nunquir Abraham a mac quimij uch, jach no'j beyaj. Baxuc yʌjtseq'uirob u t'ʌn C'uj caj quimob jach no'j beyajob uch. Mac ca tucric jach manan no'j a beyaj, tech wa? ");
INSERT INTO lacNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús caj u nuncaj ti'ob, tan ya'aric: ―Wa quin cʌxtic soc u sʌjtiquen mac jot aro'. Wa quin cʌxtic soc u sʌjtiquen mac, in Tet a mac ca tucriquex a C'uj techex, raji' cu ya'aric: “Jach caremech in pararech Jesús.” ");
INSERT INTO lacNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","A techexo' mʌ' a werex C'uj. Chen a teno' in wer C'uj. Wa quin wa'aric mʌ' in wer C'uj, baxuc aro' tus in ca' an ten bic techex ca tusex. Chen a teno' in jach er C'uj quin wu'yic u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A tetex a nunquirex Abraham a ca tsicbʌtiquex qui'ji yor uch quire' yuba tabar in tar. Tu quibaj je' in tare' rajen tu jach qui'quintaj yor uch. ");
INSERT INTO lacNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Rajen u winiquirob judío caj ya'arob ti' Jesús: ―A techo' mʌ' c'uchuc cincuenta yaxq'uinechi'. Tu' ta wiraj ic nunquir Abraham quire' mʌ' uch ch'ijiquechi'? ");
INSERT INTO lacNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús caj u nuncaj ti'ob tan ya'aric: ―Taj quin wac techex. Mʌ' toy rochac Abraham ten u nʌ' uch in toc berer uch ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Rajen u winiquirob judío caj u chucob tunich quir u ch'inicob u jo'r Jesús. Jesús caj u ta'c u bʌj ich u rac'ob. A baywo' ca' joc' tancab ti' manij chumuc tu' yʌnob, caj bin. ");
INSERT INTO lacNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tu cu man Jesús, ti' tu yiraj ch'op u wich toc berer caj rocha'b ten u na'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","U camsʌwinicob caj u c'atajob ti' Jesús tan ya'aricob: ―A wʌjcamsʌyʌjirenob ―quij―. Mac u si'pir quire' toc ch'op u wich caj rocha'b ten u na'? Wa ja je' xiba' yʌn u si'pir wa ju tet yejer u na', yʌn u si'pirob? ");
INSERT INTO lacNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús caj u nuncaj ti'ob tan ya'aric: ―Mʌ' u bʌjiri' u si'pir, mʌ' u si'pir u tet yejer u na' xan. Toc berer ch'opir u wich caj rocha'b ten u na' soc yesa' ten C'uj jach carem beyaj ti' a je' xiba'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ti' toy cuxa'anen baje'rer te' ich yoc'ocaba'. Yʌn u q'uinin quir in beyaj ti' in Tet C'uj a mac tu tuchi'tajen. Ca' bin quimiquen ts'oc in beyaj tera' ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mun q'uin ti' yʌnen ich yoc'ocab, quire' a teno' tuchi'taben ten C'uj, iren quib quir in wesiquex tech u jach jajir u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Caj ts'oc ya'aric aro' Jesús caj u tubaj ich u noy ru'um caj u jach'quintaj u noy ru'um caj u ch'aj u jach'ir u ru'umin caj u jic'taj tu boxer u wich a ch'op u wicho'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jesús caj ya'araj ti': ―Ca' xiquech ca' a ja'xtej a wich tu cuch u yacʌr ya'arir pʌcha'an u c'aba' Siloé ―u c'at ya'aric aro' tu cuch u tar ya'arir. A ch'op u wicho' caj binij u ja'xtej u wich ich u cuch ya'arir Siloé caj urij chʌca'an yiric u bej. ");
INSERT INTO lacNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Rajen u yet cajarob caj yirob. Baxuc a mac tu yirob uch a ch'op u wicho' caj u pacran arob tan ya'aricob: ―Mʌ' wa raji' a cu cutar u c'atej u taq'uin uche'? ―baxuc u pacran aricob. ");
INSERT INTO lacNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yʌn mac tu ya'arob: ―Raji'. Yʌn u jerob tu ya'arob: ―Mʌ' raji'. Mʌ' ja wirej, cu c'ʌs c'ʌ'oticob. Chen u bʌjiri' tu ya'araj: ―Jach jaj raji' ten ―quij―, a ch'op in wich uche'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Rajen robob caj u c'atob ti', tan ya'aric: ―Bic tabar caj jaw u ch'opir a wich baje'rer? ");
INSERT INTO lacNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A ch'op u wich ucho' caj u nuncaj ti'ob, tan ya'aric: ―A ray xibo', Jesús u c'aba', caj u jach'quintaj u noy ru'um caj u jic'taj tu boxer in wich. Caj ya'araj ten: “Ca' xiquech, quij, ich tu cu yacʌr ya'arir u c'aba' Siloé.” Rajen binen in jax tin wich. Rajen baje'rer chʌca'an in wiric in ber ―quij a ch'op u wicho'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Robob caj u c'atob ti' a ch'op u wich ucho'. ―Tu' yʌn a mac a ta tsicbʌtaj ucho'? Caj u ya'araj ti'ob: ―Mʌ' in wer tu' yʌni'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Caj bin purbir a mac jawsa'b u wich ʌcʌtan ich a fariseojo'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ra' u q'uinin cu jesicob u bʌj u winiquirob judío caj u jach'quintaj u noy ru'um Jesús caj u jawsaj a ch'op u wich ucho'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","A fariseojo' xan caj u c'atob ti' a xibo' bic jawsa'b u wich. Raji' caj u ya'araj ti'ob: ―Jesús ―quij―, caj u jic'taj tu boxer in wich a tu jach'quintaj u noy ru'um. Pachir caj binen in ja'x tin wich, rajen chʌca'an in wiric in ber baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Rajen caj ya'arob a ti' yʌn jun yarob a fariseojo': ―A xibo' a ray ca tsicbar ti' mʌ' raji' C'uj yʌnin quire' raji' mʌ' u cʌnantic u q'uinin ic jesiquex ic bʌjex. Chen u jerob caj ya'arob: ―Bic tabar a mac a cu betic carem beyaj a mac yʌn u si'pir? Rajen mʌ' p'eri' yorob a fariseojo'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Rajen robob caj u ca' c'atob ti' a ch'op u wich ucho'. Tech, ba' ca wac tech ti' a mac a tu jawsaj a wich? A xibo' caj u nuncaj ti'ob, tan ya'aric: ―A teno' quin wa'aric raji' yʌjtseq'uir u t'ʌn C'uj ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","U winiquirob judío mʌ' u c'at u quibicob a ba' ara'b ti'ob ten a ch'op u wich ucho'. Mʌ' ju quibob u t'ʌn hasta caj tarob u na' yejer u tet a mac jawsa'b u wich. ");
INSERT INTO lacNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Caj c'uchob u tet yejer u na' caj u c'atob ti'ob: ―A je'ra' a pararex toc ch'op wa ju wich caj rocha'b ten u na' uch? Baxuc ca wa'aric uch? Bic tabar baje'rer quire' chʌca'an yiric u ber? ");
INSERT INTO lacNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","U tet yejer u na' caj u nuncob ti'ob tan ya'aric: ―In werob a jera' quire' in pararob toc berer ti' ch'op u wich caj rocha'b ten u na' uch. ");
INSERT INTO lacNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Chen a tenobo' mʌ' in werob bic tabar caj jaw u wich. Baxuc mʌ' in werob mac tu jawsaj u wich. C'atex a wu'yej ti' quire' ch'ijij, u bʌjiri' cu yac techex tu junan. ");
INSERT INTO lacNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Baxuc caj u nuncob u tet yej u na' quire' tu ch'ajob sajquir ti' u jach ts'urirob sacerdote. Mʌ' ja wirej, u jach ts'urirob sacerdote tu ts'ajob u t'ʌnin tan ya'aricob: “Toc jumpuri' mʌ' u yʌnyʌn ocar ich u chan najir tu cu naj c'ujinticob C'uj u winiquirob judío, a mac tu yubaj ya'aric ti' u rac'ob: A Jesúso', raji' yʌjtaquiro'onex.” ");
INSERT INTO lacNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rajen u tet yejer u na' caj ya'arob: “C'atex a wu'yex ti' quire' ch'ijij. Je' yac techex bic caj jaw u wich.” ");
INSERT INTO lacNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","U jach ts'urirob sacerdote caj u wʌc'ʌs pʌyob a ch'op u wich uch, caj ya'arob ti': ―Ca' a wa'arej ti' C'uj: “Bayo' C'uj tech ta jawsaj in wich.” A mac a ca tsicbar ti', a tenobo' in werob yʌn u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Raji' caj u ya'araj ti'ob: ―A teno' mʌ' in wer wa yʌn u si'pir. In chen er baje'rer quire' chʌca'an in wiric in ber. A ucho' mʌ' chʌca'an in wiric in ber ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Robob caj u ca' c'atob ti': ―Ba' tu betaj tech? Bic tabar caj u jawsaj a wich? ―quijob. ");
INSERT INTO lacNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Raji' caj u nuncaj ti'ob tan ya'aric: ―Biquinin tin toc araj techex ca'ch? Chen techex mʌ' a c'atex a quibexi'. Biquinin a c'atex a ca' u'yiquex, je' wa ja binex tu pach quir a cʌniquex u t'ʌn? ");
INSERT INTO lacNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Robob caj u yʌnxchun u p'asticob ti' tan ya'aricob ti': ―A techo' ca bin tu pach quir a cʌnic u t'ʌn a mac a yʌn u si'piro'. Chen a tenobo' quin binob tu pach ic nunquir Moisés quir in cʌnicob u t'ʌn Moisés uch. ");
INSERT INTO lacNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","A tenobo' in werob C'uj cu tsicbar ti' Moisés uch. A ray ca tsicba ti' mʌ' in werob tub u tari' ―quijob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A xibo' caj u nuncaj ti'ob, tan ya'aric: ―A techexo' ca jac'siquex in wor quire' ca waquex mʌ' a werex tub u tari'. Tu jawsaj in wich mʌ' wa ca wiriquex jaw in wich. ");
INSERT INTO lacNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ij querex a C'uj mʌ' ju yubic u t'ʌn a mac a yʌn u si'pire'. A C'ujo' cu chen u'yic u t'ʌn a mac a cu sʌjtic C'uj, a mac a tan u betic a ba' u c'at C'ujo'. Ra' cu yubic C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mʌ' ja wirej, caj yʌnxbeta'b yoc'ocab taquij baje'rer, mʌ' ij cu'yimʌnex mac jawsa'b u wich ch'op a ju toc berer caj rocha'b ten u nʌ' ―raji', aric a ch'op u wicho'―. ");
INSERT INTO lacNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","A quin tsicbʌtic ti', wa mʌ' tarij ich C'uj, mʌ' c'ucha'an yor u betic baxuc a jera' ―quij a ch'op wich ucho'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Robob caj u nuncob ti' tan ya'aric: ―Bic ca bin a camsic tenob? Mʌ' toy u rochech a na', uch toc yʌn a si'pir tech uch ―baxuc caj ya'arob ti'. Robob caj ya'arob ti' jumpuri': ―Mʌ' a yʌnyʌn ocar ich chan naj tu cu naj c'ujinticob C'uj u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús caj yubaj a mac ch'op u wich ucho', toc jumpuri' toc joc'sa'b ich chan naj tu cu naj c'ujinticob C'uj u winiquirob judío. Rajen Jesús caj tar u tsicbar ti' a xibo', ra' jaw u wicho'. Caj u yiraj caj u c'ataj ti': ―Ca wacsic wa ta wor ti' u parar C'uj a mac a yʌn tu cotor u muc' C'uj? ");
INSERT INTO lacNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A xibo' a jaw u wicho' caj u nuncaj ti' tan ya'aric: ―Maqui' in Jaj Ts'urir? In c'at in wacsic tin wor ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús caj u nunca ti' tan ya'aric: ―A techo' ta wirajen baje'rer. Raji'en a tan u tsicbar yejerech. ");
INSERT INTO lacNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A xibo' caj u nuncaj ti', tan ya'aric: ―Quin wacsic tin wor tech, Jaj Ts'urir. Caj xonrʌj tu' yʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús caj ya'araj ti': ―A teno' taren ich yoc'ocab soc u sasichʌjʌr u wich a mac ch'op u wiche'. A mac a cu ya'aric: “Sasij in wicho'”, cu bin tar ti', irej wa ch'op u wich. ");
INSERT INTO lacNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ti' yʌn a fariseojo' tu' yʌn Jesús caj yubob a ba' caj u ya'araj Jesús. Rajen caj u c'atob ti': ―Ca tucric wa ja tenob ch'opob in wichob ―baxuc caj ya'arob. ");
INSERT INTO lacNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús caj u nuncaj ti'ob, tan ya'aric: ―Wa ch'op a wichex mʌna' a si'pirex techex. Quire' ca waquex: “Sasir in wichob”, rajen yʌn a si'pirex techex quire' ca waquex sasir a wichex. ");
INSERT INTO lacNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús caj ya'araj ti' a pimob: ―Taj a ba' quin wac techex. Rajen u'yex, a mac a cu tar ya'cric tʌmʌn yuc, mʌ' ju yocar tu jor u pa'te' tu jap'nin quir u ya'cric. Cu chen nacatic u pa'te'ir quir u ya'cric. ");
INSERT INTO lacNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Chen a mac raji' u jach winquirir u tʌmʌn yuc cu jach ocar tu jor u pa'te'ir tu' yʌn yʌrʌc' tʌmʌn yuc. ");
INSERT INTO lacNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A mac a cu cʌnantic u jor u pa'te'ir tu' yʌn yʌrʌc' tʌmʌn yuc cu q'ue'ic u jor u pa'te'ir soc u yocar a taj yʌjcʌnanyʌjir tʌmʌn yuc. A tʌmʌn yuco' cu c'ʌ'otic u t'ʌn u winquirir. Cu t'ʌnic u yʌrʌc' tʌmʌn yuc quire' jujuntur yʌrʌc' tʌmʌn yuc cu t'ʌnic u c'aba' soc u pʌyic ich tancab ca' joc'acob ich u pa'te'ir. ");
INSERT INTO lacNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Caj ts'oc u joc'sic tu cotor u yʌrʌc' tʌmʌn yuc cu pʌyic u berob. U yʌrʌc' tʌmʌn yuc cu sayʌrob tu pach quire' cu c'ʌ'oticob u t'ʌn, rajen cu binob tu pach. ");
INSERT INTO lacNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","U tʌmʌn yuc mʌ' u sayʌrob tu pach a mac a mʌ' u yocar tu jor u pa'te'ir quire' mʌ' ra' u winquirir. Cu puts'urob u tʌmʌn yuc quire' mʌ' u c'ʌ'oticob u t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús caj u ya'araj a je' t'ʌna' quir u camsic ti' a mac a mucha'an ti'o'. Chen mʌ' tu najtob a ba' u c'at ya'aric. ");
INSERT INTO lacNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús caj ya'araj ti' a pimob: ―Taj quin wa'aric techex, a teno' yʌjcʌnanyʌjiren u jor u pa'te'ir tu' yʌn yʌrʌc' tʌmʌn yuc C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","A mac a ca tucriquex yʌjcʌnanyʌjirob, robob irob a mac a cu ya'cric tʌmʌn yuc quire' u c'at u taquic ti' ten a mac a cu sayʌrob tin pach. Mʌ' ju yubicob u t'ʌn u tus ʌjcʌnanyʌjirob tʌmʌn yuc. ");
INSERT INTO lacNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","A teno' ―quij Jesús―, quin cʌnantic u jor u pa'te'ir tu' yʌn yʌrʌc' tʌmʌn yuc C'uj. A mac a cu yacsic tu yor ten quire' yerob quin bin in taquej. Robob waysa'b irob yʌrʌc' tʌmʌn yuc C'uj. Cu bin cʌnanbirob ten C'uj, cu bin jach qui'quinbir yorob ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’A mac a cu tar ya'cric tʌmʌn yuc, ra' u beyaj quir u ya'cric. Baxuc quir u quinsic. Baxuc quir u ch'esic xan. Chen a teno' taren in ts'ic ti'ob u cuxtarob munt q'uin soc jach manan u qui' tar yorob. ");
INSERT INTO lacNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","An ten bic a mac yʌjcʌnanyijir tʌmʌn yuc a jach tsoyo' cu qui' cʌnantic u yʌrʌc' tʌmʌn yuc cax quinsbir ti' u yʌrʌc' tʌmʌn yuc. Baxuc a teno' quin qui' cʌnantic mac a cu yacsic tu yor ten cax quinsbiren quir in taquic ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Chen a mac u chen c'at u cʌnantic tʌmʌn yuc ca' bin yirej u tar bʌc' chi'bir u yʌrʌc' tʌmʌn yuc cu puts'ur quire' mʌ' raji' u winquirir. Rajen chi'bir yʌrʌc' tʌmʌn yuc ten bʌc' rʌc wacche' u binob yʌrʌc' tʌmʌn yuc. ");
INSERT INTO lacNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A mac a cu chen c'at u cʌnantic tʌmʌn yuc cu puts'ur quire' mʌ' u yajquintic tʌmʌn yuc. ");
INSERT INTO lacNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","An ten bic a mac yʌjcʌnanyʌjir tʌmʌn yuc a jach tsoyo'. Cu qui' cʌnantic u tʌmʌn yuc. Baxuc a teno' quin qui' cʌnantic a mac a cu yacsic tu yor ten. In wer mac tu yacsaj tu yor ten. Baxuc xan robob yerob tu yacsajob tu yor ten. ");
INSERT INTO lacNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","In pacran erob in bʌjob an ten bic in Tet yeren in pacran erob in bʌjob. In Tet yeren xan, baxuc ten in wer in Tet xan. Baxuc quin c'ubic in bʌj soc in quinsa' ti' a mac a cu sayʌr tin pach. ");
INSERT INTO lacNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yʌn mac mʌ' u winiquirob judío cu bin u yacsicob tu yorob ten xan. Bin in ca' in pʌyejob xan. Robob cu bin u yubicob in t'ʌn xan soc p'eri'ob yejerechex u winiquirechex judío chen turiri' yʌjcʌnanyʌjir, raji'en. ");
INSERT INTO lacNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’In Teto' cu yajquintiquen quire' tin c'ubaj in bʌj soc in quinsa' ti' a mac a cu sayʌrob tin pach. Pachir in ca' riq'uir. ");
INSERT INTO lacNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mʌna' mac c'ucha'an yor u quinsiquen. In wʌc'ʌs bʌjiri' in c'at in cha'ic in quinsa'. C'ucha'an in wor in cha'ic in quinsa'. C'ucha'an in wor in wʌc'ʌs riq'uir quire' baxuc caj u ya'araj ten in Tet. Baxuc tu ts'aj u t'ʌnin ti' in Tet xan. ");
INSERT INTO lacNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Rajen mʌ' quet yorob a pimob a ba' caj u yubob ya'aric Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ya'ab mac tu ya'arob: ―Aca'an ti' c'ac'as quisin. U jerob cu ya'aricob: ―Chochoc t'ʌn u ca' quire' mʌna' yor. Biquinin ca wu'yiquex u t'ʌn? ");
INSERT INTO lacNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","U jerob u winiquirob judío caj ya'arob: ―Raji' mʌ' u tsicbar baxuc wa aca'an c'ac'as quisin. Mʌ' ja wirej, a mac aca'an c'ac'as quisin mʌ' c'ucha'an yor u jawsic a mac ch'op u wicho' ―baxuc ya'arob. ");
INSERT INTO lacNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","C'uchij tu q'uinin u qui'qui' janʌnob u winiquirob judío ich u cajar Jerusalén. Ra' u q'uinin u winiquirob judío cu c'ʌ'oticob caj ts'oc u qui' tsoyquinticob carem naj tu cu naj c'ujinticob C'uj uch soc ti' cu wʌc'ʌs c'ujinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ra' u q'uinin que'er tan xet'ir. Ti' yʌn Jesús ca'ch tan u man tu jap'nin carem naj tu re'ja'an naj u c'aba' Salomón. ");
INSERT INTO lacNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","U winiquirob judío caj u much'quintob u bʌj caj u bʌ'cristob Jesús caj ya'arob ti': ―Arej tenob ber ca' bin ts'ocac a choquintic in worob. Mʌ' a mucric, toc arej tenob wa Cristojech a tuchi'ta'bech ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús caj u nuncaj ti'ob tan ya'aric: ―Tin toc araj techex chen mʌ' ja quibiquex. A wiramʌnex xan tin betaj carem beyajob quire' tu yamtajen in Tet C'uj. Raji' cu yesic tar in tar ich C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","A techexo' mʌ' ja quibiquex in t'ʌn quire' mʌ' ten yʌninechex baxuc caj in wa'araj techex uch. ");
INSERT INTO lacNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Quire' a mac ten yʌnin ―quij Jesús―, a cu yubicob in t'ʌn quire' in wer maqui'. Robob cu sayʌrob tin pach. ");
INSERT INTO lacNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Quin ts'ic u cuxtarob munt q'uin mʌ' ju bin satʌrob mʌ' biq'uin. Mʌna' mac c'ucha'an yor u taquic ten quire' ten yʌnin. ");
INSERT INTO lacNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","In Tet C'uj caj u ts'aj ti'ob ten soc ten yʌninob. In Teto' jach manan c'ucha'an yor ti' tu cotor ba'. Mʌna' mac c'ucha'an yor u taquic ti' in Tet quire' raji' yʌninob xan. ");
INSERT INTO lacNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jesús caj ya'araj: ―A teno' yejer in Tet turiri'enob. ");
INSERT INTO lacNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Rajen u winiquirob judío tu ca' chucob tunich u c'atob u ch'inicob u jo'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús caj ya'araj ti'ob tan ya'aric: ―A techexo' a wiramʌnex ya'ab carem in beyaj caj in betaj quire' tu yamtajen in Tet. Arex ten ba' tsoyir beyaj ta wirex in betic. Rajen a c'at a ch'iniquex in jo'r. ");
INSERT INTO lacNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","U winiquirob judío caj u nuncob ti' tan ya'aricob: ―Mʌ' jin bin in ch'inicob a jo'r quire' tsoy a beyaj. Quin bin in ch'inicob a jo'r quire' tan a p'astic C'uj. Mʌ' ja wirej, chen xibech ca tucric C'ujech. ");
INSERT INTO lacNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús caj u nuncaj ti'ob tan ya'aric: ―Ti' ts'iba'an tu cu ya'aric C'uj ti' techex: “Techex, quij C'uj, ca wesiquenex ti' mac C'ujen.” Aro' ara'b ti' u juez u winiquirob judío uch ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Baxuc caj ara'b ti' a mac ts'ab u beyajob ten C'uj uch. Rajen mʌ' ju bin ruc'sa'bir ich u t'ʌn C'uj tu ts'iba'an. ");
INSERT INTO lacNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","A techexo' u winiquirechex judío ca waquex jach tsoyo' a mac ara'b ten C'uj ca wesiquenex ti' mac C'ujen. Rajen biquinin ca wa'ariquex quin p'astic C'uj quire' tin wa'araj u pararen C'uj. Mʌ' ja wirej, tu ts'aj in beyaj C'uj, rajen taren ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wa ca tucriquex, mʌ' u beyaj C'uj quin betic mʌ' a yʌn acsiquex ta worex ten. ");
INSERT INTO lacNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wa ca wiriquex ra' u beyaj C'uj quin betic, quibex aro', cax mʌ' a quibiquex in t'ʌn. Quire' wa ca quibiquex ra' u beyaj C'uj quin betic, baxuc a werex xan turi'en yejer C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Rajen u ca' c'atob u chuquicob Jesús chen mʌ' c'ucha'an yorob u chuquicob chen Jesús puts'ij. ");
INSERT INTO lacNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tu ca'ten ca' bin Jesús pichir ya'arir Jordán tu cu tar ic yum, ti' p'atij tu cu yacsic ja' tu jo'r mac Juan uch. ");
INSERT INTO lacNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ti' toy yʌn Jesús pʌchir ya'arir Jordán caj tarob ya'ab mac quir u yirirob Jesús. A pimob caj u pacran arob: ―Cax Juan mʌ' tu yesaj carem beyaj chen taj a ba' caj u ya'araj Juan ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Rajen ya'ab mac tu yacsob tu yorob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ti' yʌn mac uch tu cʌnaj u yajir. Raji' u c'aba' Lázaro, ti' u tar uch ich u cajar Betania, ra' u wa'an u ru'umin Judea. Lázaro ti' cʌja'anob ich u cajar uch yejer u yits'inob María yejer Marta. ");
INSERT INTO lacNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María, raji' a tu jayaj a qui' u boco' tu yoc Jesús caj u tisaj yejer u tsotser u jo'r ca' tijic. A mac u cʌmʌn u yajir raji' u sucu'unob Lázaro. ");
INSERT INTO lacNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Rajen u yits'inob Lázaro caj tuchi'ta'b ca' xic pʌybir Jesús tan ya'aricob ti': ―Jaj Ts'urir ―quij―, a mac a jach yaj a wiric baje'rer yajij ―baxuc caj ya'arob a mac tuchi'ta'b ten María yejer Marta. ");
INSERT INTO lacNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús caj yuba caj ya'araj: ―A tu cʌnaj u yajir, mʌ' quir u jach quimin chen quir u sʌjta' C'uj ten tu cotor mac. Cu bin quimij soc ten xan cu sʌjtiquenob tu cotor mac quire' u pararen C'uj a tuchi'ta'ben ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús tu yajquintaj Marta yejer u yits'in María yejer Lázaro, ");
INSERT INTO lacNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","chen p'atij Jesús u jer ca'tur u q'uinin tu' yʌni' cax tu yubaj tu cʌnaj u yajir Lázaro. ");
INSERT INTO lacNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pachir caj ya'araj ti' u camsʌwinicob: ―Jeroj cuxex ca' wʌc'ʌs xico'on ich u ru'umin Judea ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chen u camsʌwinicob caj ya'arob: ―A wʌjcamsʌyʌjirenob ―quij―, u winiquirob judío u c'at u ch'inicob a jo'r uch. Biquinin a c'at a ca' bin ti' taro'? ");
INSERT INTO lacNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús caj u ya'araj ti'ob bic yira' u beyaj C'uj. Rajen caj u ya'araj ti'ob: ―A C'ujo' tu ts'aj to'onex juntur u q'uinin doce horas. Mʌ' ja wirej, a mac a cu man chunq'uine', mʌ' ju cojar yoc, quire' ti' toy chunq'uini'. ");
INSERT INTO lacNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Chen wa cu yac'birchʌjʌr c'uchij tu q'uinin cu cojar yoc quire' mʌ' sasiri'. Baxuc a jera' Jesús tu cha' ic najtic mʌ' ju bin quinsbir Jesús hasta cu c'uchur tu q'uinin a tu p'isa C'uj uch. Rajen mʌna' ba' u ber ti' Jesús ten mac. ");
INSERT INTO lacNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pachir Jesús caj u ya'araj ti' u camsʌwinicob: ―A Lázarojo' a jic jach yaj tan u wenʌn. Tar quin bino' quir in wʌsic quire' wenʌn u ca' ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","U camsʌwinicob caj ya'arob ti': ―Jaj Ts'urir ―quij―, wa wenʌn u ca', je' u ch'ic yore'. ");
INSERT INTO lacNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Baxuc Jesús caj u ya'ara ti'ob quire' jach quimen Lázaro chen u camsʌwinicob cu tucricob jach wenʌn u ca' tan u je'sic u bʌj. Rajen cu bin u ch'ic yor. ");
INSERT INTO lacNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Rajen Jesús mʌ' tu mucraj caj u ya'araj ti'ob: ―Lázaro jach quimij. ");
INSERT INTO lacNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Caj ya'araj Jesús: ―Qui' in wor quire' mʌ' ti' yʌnenob tu' yʌn Lázaro, soc a wacsiquex ta wor ten. Chen cuxex ij quirej. ");
INSERT INTO lacNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Rajen Tomás caj u ya'araj ti' u yet camsʌwinicob, raji' cu ya'aricob u yet camsʌwinicob Gemelo, mʌ' ja wirej, caj rocha'b ten u na' toc ca'tur: ―Cuxex ca' quimico'onex yejer Jesús. Yer je' u quinsa'r Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Caj u bin Jesús yejer u camsʌwinicob caj c'uchob cuatro u q'uinin tub but'i u baquer ich u jap'nin tunich Lázaro. ");
INSERT INTO lacNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","U cajar Lázaro, raji' Betania baytʌc ich u cajar Jerusalén. Ya'aric ca'tur kilómetro chumuc u nachir. ");
INSERT INTO lacNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ya'ab u winiquirob judío caj binob tu' yʌn Marta yejer María quir u qui'quinta' yorob soc p'eri'ob ya'cticob u sucu'unob. ");
INSERT INTO lacNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta caj yuba tabar u c'uchur Jesús caj binij quir u nup'ic ich bej. Chen María ti' p'atij ich naj. ");
INSERT INTO lacNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta caj c'uchij ich Jesús caj ya'araj: ―Jaj Ts'urir ―quij―, wa ti' yʌnech uch caj u cʌnaj u yajir in sucu'un mʌ' quimij uch je' a jawsique'. ");
INSERT INTO lacNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Quire' in wer C'uj cu ts'ic tech baje'rer a ba' ca c'atic ti' ―quij Marta. ");
INSERT INTO lacNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús caj ya'araj ti': ―A sucu'un je' u riq'uire' tu but'ij ich jap'nin tunich ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta caj u ya'araj ti': ―In wer in sucu'un je' u ca' cuxtare' ca' bin xuruc t'ʌn ca' bin cuxrac tu cotor mac. ");
INSERT INTO lacNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús caj u ya'araj ti': ―Quire' a teno' yʌn u cuxtar mac. Quire' a teno' yʌn u ca' cuxtar mac, a maque' cu yacsic tu yor ten quire' yer yʌjtaquiren a teno' cax cu bin quimin cu bin cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tu cotor mac a cu cuxtar munt q'uin a mac a cu yacsic tu yor ten quire' yer yʌjtaquiren a teno'. Mʌ' ju bin satʌr mʌ' biq'uin. Ta quibaj aro' ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta caj u ya'ara ti': ―Quin quibic Jaj Ts'urir in wer a techo' Cristojech, u pararech C'uj a mac a cu bin tar ich yoc'ocab ―quij Marta. ");
INSERT INTO lacNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta caj ts'oc ya'aric aro' caj bin u pʌyej u yits'in caj u muc u araj ti': ―Ij cʌjcamsʌyʌjir c'uchij caj u tuchi'tajen ca' in pʌyech. ");
INSERT INTO lacNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Caj yuba ya'aric aro' María seb caj riq'uij caj bin irbir Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús mʌ' toy c'uchuc ich u cajar ti' yʌn tub u nup'a Marta ich bej ca'ch. ");
INSERT INTO lacNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Rajen u winiquirob judío a tarob u qui'quinticob yor a ti' yʌnob ich yatoch yejer ca'ch. Caj yirob seb u joc'ar María caj sayob tu pach quire' cu tucricob ti' cu bin tu' but' u baquer u sucu'un quir u yactic. ");
INSERT INTO lacNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Caj c'uchij María tu' yʌn Jesús caj xonrʌj tu' yʌn Jesús tan ya'aric ti': ―Jaj Ts'urir ―quij―, wa ti' yʌnech uch caj u cʌnaj u yajir in sucu'un mʌ' quimij uch je' a jawsique' ―quij María. ");
INSERT INTO lacNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús caj u yiraj yoc'ar María baxuc u winiquirob judío a sayob tu pach María yaj yubaj tu yor quire' mʌ' u c'at yiric u quimin mac. ");
INSERT INTO lacNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesús caj u c'ataj ti'ob: ―Tub a but'ex u baquer Lázaro? Caj ya'arob: ―Jaj Ts'urir, cojen irej ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús caj oc'nʌjij. ");
INSERT INTO lacNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A mac a ti' yʌnob caj u pacran arob: ―Iric, cu yajquintic Lázaro. ");
INSERT INTO lacNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ti' yʌn mac caj u ya'arob: ―Aro' raji' a tu jawsaj u wich a ch'opo' uch. Mʌ' wa raji' c'ucha'an yor yamta'bir Lázaro soc mʌ' u quimij? ");
INSERT INTO lacNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús caj c'uchij tu' but'a'an u baquer Lázaro yʌn u jap'nin tunich caj u tucraj tu yor quire' mʌ' u c'at yiric quimin mac. Tu' but'ij yʌn u mac u jor. ");
INSERT INTO lacNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús caj ya'araj: ―Ruc'sex ―quij―, u mac u jor tunich. Marta, a yits'in ixba Lázaro caj u ya'araj ti': ―Jaj Ts'urir ―quij―, tu'jij tin t'ʌn quire' toc yʌn cuatro q'uin caj but'ij. ");
INSERT INTO lacNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús caj u ya'araj ti': ―Mʌ' wa tin wa'araj tech wa ca wacsic ta wor ca bin a wirej jach manan u muc' C'uj? ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Caj u ruc'sob u tunichir u mac u jor tu' but'a'an u baquer Lázaro. Jesús caj u pʌctaj ich ca'anan caj u ya'araj: ―In Tet C'uj ―quij―, quin wa'aric tech: “Bayo'” quire' rajra' ca wu'yic in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","In wer rajra' ca wu'yic in t'ʌn. Baxuc quin wac ti' tech quire' ti' yʌn mac tera' soc yubic ba' caj in wa'araj tech soc yacsicob tu yorob tech ta tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Caj ts'oc ya'aric aro' Jesús caj u c'am t'ʌnaj: ―Lázaro ―quen―, joq'uen ti' taro' ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A quimeno' ca' joq'uij toc sʌsʌ c'ʌxa'an u c'ʌb yejer noc', baxuc u yoc xan. Baxuc u wich tapa'an yejer panyu. Jesús caj ya'araj ti'ob a mac ti' yʌnob: ―Jitex u noc' soc u bin ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Rajen ya'ab u winiquirob judío a ti' yʌnob yejer María tu yacsob tu yorob ti' Jesús quire' yerob yʌjtaquirob quire' tu yirob Jesús u ric'sic Lázaro. ");
INSERT INTO lacNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","A mac mʌ' tu yacsajob tu yorob quire' mʌ' u c'at yiricob ba' cu betic Jesús. Rajen caj binob ich a fariseojo' caj u tsicbʌtajob a ba' caj u betaj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Rajen u ts'urirob sacerdote yejer a fariseojo' caj u much'quintajob u bʌj u yet ts'urirob u winiquirob judío, caj ya'arob: ―Ba' quic bin ic betejex ti' a xibo' a tar yʌno' quire' tan u yesic carem u beyajob? ");
INSERT INTO lacNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Quire' wa quic aric: “Tsire'ej”, tu cotor mac cu bin u yacsicob tu yorob ti' quire' yerob yʌjtaquirob. A baywo' cu bin acsa'bir ten a pimob quir ic ts'urintiquex, rajen u rey ich u cajar Roma cu bin u ts'ictar yejero'onex. Cu bin tuchi'tic a soldadojo' ca' tacob u quinsico'onex ca' tacob u rʌc joc'sico'onex. ");
INSERT INTO lacNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chen turiri' u yet ts'urirob u c'aba' Caifás, raji' a je' yaxq'uina' c'uchij tu q'uinin u yocar u jer u jach ts'urir sacerdote, raji' Caifás. Raji' caj ya'araj ti'ob: ―Mʌna' ba' a werex a techexo'. ");
INSERT INTO lacNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mʌ' wa ca najtiquex wa tsoy cu quimin turiri' mac ti' tu cotoro'onex soc tu cotor mac mʌ' u bin quinsbir ten u winiquirob romano. ");
INSERT INTO lacNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A Caifáso' mʌ' u bʌjiri' tu ya'araj a jera' quire' raji' u jach ts'urir sacerdote quire' c'uchij tu q'uinin u yocar u jer u jach ts'urir sacerdote. ");
INSERT INTO lacNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mʌ' chen ti' to'onex, quij Caifás, cu bin quinsbir Jesús. Cu bin quinsbir u parar C'uj ti' tu cotor a mac C'uj yʌnin a ti' yʌnob ich yoc'ocab soc u p'eri'quintico'onex a mac a C'uj yʌnino'. ");
INSERT INTO lacNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Rajen u ts'urirob sacerdote seb caj u tucrajob u c'at u quinsicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rajen Jesús mʌ' ju yes u bʌj ti' u winiquirob judío. Tu junan caj binij yejer u camsʌwinicob ich u ru'umin Judea, caj bin ich tʌcay ru'um. Caj c'uchij ich u cajar Efraín. Ti' p'atij yejer u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tabar u c'uchur tu q'uinin u qui'qui' janʌnob u winiquirob judío. Ra' u q'uinin pascua, ra' u q'uinin cu c'ʌ'oticob tu potmasta'b ten yʌjmasirob u t'ʌn C'uj uch soc mʌ' u quimin u parar a yʌn rocha'b ten u na'. Ya'ab winiquirob caj rʌc binob ich u cajar Jerusalén cax mʌ' c'uchuc tu q'uinin pascua soc u nup'sic a ba' cu ya'aric ich u t'ʌn Moisés soc tsoy yiricob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Caj c'uchob u winiquirob judío ich u cajar Jerusalén. Caj yubob ya'aricob a ba' ara'b ti'ob ten u jach ts'urirob sacerdote yejer a fariseojo': “Wa mac cu yiric tu' yʌn Jesús ca' tac ya'arej tu' tu yiraj Jesús soc u bin chucbirob quir u ma'cʌr.” Rajen tan u manob cʌxta'bir Jesús. Tu cotor mac ti' yʌn ich carem naj tan u pacran c'aticob tan ya'aricob: ―Ba' ca tucric je' wa ju tar Jesús ca' bin c'uchuc tu q'uinin u qui'qui' janʌn? ―baxuc tan u pacran tsicbarob ti' Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yʌn seis u q'uinin quir u c'uchur tu q'uinin pascua. Caj binob Jesús yejer u camsʌwinicob ich u cajar Betania tu cʌja'an Lázaro a tu ric'saj Jesús tu quimirir. ");
INSERT INTO lacNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Marta caj u pʌyaj Jesús yejer u camsʌwinicob quir u qui' janʌnob. Ti' yʌn Lázaro yejer u jer macob tan u janʌnob yejer ich u pojche'ob. Marta cu tar purbir yoch ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María, u yits'in Marta, tu ch'aj tu' yʌn Jesús chumuc kilo a qui' u boque' u c'aba' nardo. Jach co'oj a nardojo' caj u rʌc jic'taj tu yoc Jesús, María caj u tisaj yejer u wʌc'ʌs tsotser u jo'r. Tu cotor u japnin yatoch tu rʌc bac'aj u boc nardo. ");
INSERT INTO lacNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ti' yʌn Judas Iscariote u yet janʌn Jesús, raji' u parar Simón Iscariote. Raji' turiri' ich u camsʌwinicob Jesús chen raji', Judas, cu wʌc'ʌs bin u c'ubic Jesús ca' quinsac. Raji' caj ya'araj: ");
INSERT INTO lacNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Wa tu canaj a je' qui' u boc a tu jic'taj tu yoc Jesús, a tu chen jaraj u taq'uin ca'ch tres cientos denarios ―u c'at ya'aric u taq'uin a mac a cu jaric turiri' yaxq'uin tu cu beyaj―. Jach tsoy ca' u jʌsej ti' a mac otsire' ―baxuc caj ya'araj Judas. ");
INSERT INTO lacNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas mʌ' u jach tucric a mac otsir tu chen araj aro' quire' Judas cu cʌnantic u taq'uin u yet camsʌwinicob Jesús. Mʌ' ja wirej, a Judaso', cu chʌc a'cric taq'uin tu cu ts'abʌr u cʌnantej ti' ten u yet camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús caj ya'araj ti' Judas: ―Tsire'ej mʌ' a wa'aric aro' quire' tu cʌnantaj a jeroj soc u c'uchur tu q'uinin in quimin. ");
INSERT INTO lacNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Rajra' ti' yʌn otsir tu' yʌnechex. Chen a teno' mʌ' rajra' ti' yʌnen tu' yʌnechex ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jach pim a winiquirob judío a tu much'quintajob u bʌj ich u cajar Jerusalén caj yubob c'uchij Jesús yejer u camsʌwinicob ich u cajar Betania. Rajen binob u yirejob Jesús. Mʌ' chen c'uchob quir u yiricob Jesús quir yiric Lázaro xan a mac ric'sa'b tu' quimen ten Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Caj tarob ich u cajar Betania mʌ' toy u yacsajob tu yorob ti' Jesús. Caj joc'ob tu cajar Betania tu yacsob tu yorob ti' Jesús quire' yerob yʌjtaquirob quire' tu yirob Lázaro raji' ric'sa'b ten Jesús tu' quimen. Rajen u jach ts'urirob sacerdote tu p'eri'quintob yorob u tucricob u quinsicob Lázaro xan. ");
INSERT INTO lacNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Caj sasij a pimob tan u much'quinticob u bʌj ich u cajar Jerusalén quire' c'uchij tu q'uinin u qui'qui' janʌnob u winiquirob judío. Caj yubob tan u c'uchur Jesús ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Rajen caj joc'ob u janch'ʌtejob u re' pajo' caj joc'ob tancab ich u cajar Jerusalén. U mʌchmʌnob u re' pajo' quir u binob u nup'icob Jesús ich bej. C'am tan u t'ʌnob tu cu tarob ich bej. Caj ya'arob: ―Je' cu tar ij cʌjtaquirex jach qui' ij corex quire' baje'rer tuchi'ta'b ten C'uj. Ca' qui'ac ij corex. Raji' cu bin yocar quir ic reyintiquex a tenobo' u pararenob ic nunquirex Israel. Ca' ij carex ti' C'uj: “Jach caremech C'uj.” ");
INSERT INTO lacNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ti' yʌn chan tsimin taro'. Jesús caj naquij quir u cʌptar tu pach an ten bic ts'iba'an ich u t'ʌn C'uj uch tan ya'aric: ");
INSERT INTO lacNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","A techexo', a xquico' a mac cʌja'an ich u cajar Jerusalén, u jer u c'aba' Sión, mʌ' a ch'iquex sajaquir, je' u tar a mac ca' bin a reyintiquex. Je' u tar cʌpʌcbar tu pach chan tsimin. Baxuc cu ya'ara' ti' Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","U camsʌwinicob Jesús, mʌ' ju najtobi' caj yirob Jesús u captar tu pach chan tsimin quir u sʌjta' ten tu cotor mac. Caj wʌc'ʌs binij Jesús ich ca'anan caj c'aj ti'ob a ba' ts'ibta'b ti' Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A pimob a tarob ich bej quir u nup'icob Jesús quire' tu yubob ya'aric: “Raji' tu t'ʌnaj ca' joc'ac Lázaro tu but' u baquer. ");
INSERT INTO lacNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Raji' tu ric'saj Lázaro tu' quimen.” ");
INSERT INTO lacNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Rajen a fariseojo' caj u pacran arob: ―Iriquex mʌ' c'ucha'an ij corex ti' quire' tu cotor mac tan u binob tu pach quir u cʌnicob u t'ʌn ―baxuc caj u pacran arob. ");
INSERT INTO lacNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ti' yʌnob u winiquirob griego a rajra' cu tarob cu c'uchur tu q'uinin u qui'qui' janʌnob u winiquirob judío quir u c'ujinticob C'uj, irob u winiquirob judío. Caj tarob u sijejob ba' ti' C'uj xan. ");
INSERT INTO lacNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Robob caj tarob u tsicbarob yejer Felipe. Raji' u camsʌwinic Jesús a cu tar tu cajar Betsaida a ti' yʌn tu ru'umin Galilea, caj u chich arajob ti': ―Jach ts'urir, quen, in c'atob in wiricob Jesús ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Rajen Felipe caj bin ich Andrés caj ya'araj ti'. Rajen ca'turo' u camsʌwinicob Jesús caj binob ich Jesús caj ya'arob ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús caj ya'araj ti'ob: ―C'uchij tin q'uin a teno' a tu tuchi'ten C'uj soc u caremquintiquen C'uj, a teno' irenechex. ");
INSERT INTO lacNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Taj a ba' quin wac techex, u yijir u wich trigo cu ts'abʌr u wich wa cu pʌc'ʌr ich ru'um. Wa pʌc'a'an cu nets'ajic u wich trigo. Wa mʌ' pʌc'a'an chen tu junan yʌn. Baxuc ten ―quij Jesús―, wa quin quimin, ya'ab mac cu bin u yacsicob tu yorob ten quir u tar tin pach ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Baxuc yejer techex. A mac mʌ' u c'at u c'ubic u bʌj ti' ten soc u quinsa' irej ten, cu bin ts'abir u muc'yaj munt q'uin. Chen a mac u c'at u c'ubic u bʌj ti' ten soc u quinsa', raji' cu bin u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tu cotor mac u c'at u yamtiquen ca' tacob tin pach. Baxuco' cu bin c'uchur ich ca'anan tu' yʌnen quire' a mac a tu yamtajen cu bin qui' acsa'bir ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesús caj ya'araj: ―Yaj in wu'yic tin wor baje'rer. Mʌ' c'ucha'an in wor in wac ti' in Tet C'uj: “Yʌmtej ten, Tet”, quire' taren ich yoc'ocab quir in muc'yaj a ba' cu bin tar ten. Rajen taren quir in muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jesús caj u t'ʌnaj C'uj tan ya'aric: ―Baxuc in c'at ca' u sʌj techob C'uj. Jeroj tune', caj yubob u t'ʌn ca'anan. C'uj caj u nuncaj, ti' u tar u t'ʌn ich ca'anan: ―Tan in toc sʌjta're', je' in ca' sʌjta're' ―quij C'uj―, ra' u q'uinin ca' bin quinsaquech. ");
INSERT INTO lacNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A mac a ti' yʌnob a tan u ch'ictarob caj yubob u t'ʌn c'am a tar u tar ich ca'anan. Robob caj u pacran arajob tan ya'aricob: ―Ba' pecnʌjij sam, a ti' ij cu'yajex? U jer caj ya'arob: ―Yʌjmasir u t'ʌn C'uj, raji' t'ʌnʌjij. Raji' tin wu'yajob, tin t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús caj ya'araj ti'ob: ―In Tet, C'uj, caj u t'ʌnajen, mʌ' chen jari' ti' ten, ti' techex xan ca' a wu'yex soc a werex in Tet, C'uj, cu yubic in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Baje'rer ―quij Jesús―, c'uchij tu q'uinin cu bin jʌsbir mac a yʌn u si'pire' quire' mʌ' biq'uin u c'at yacsicob tu yor ten. Baje'rer ―quij Jesús―, c'uchij tu q'uinin xan cu bin ruc'sa'bir u beyaj a quisino' quire' raji' cu ts'urinticob ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Quire' a teno' quin bin quinsbir ich cruz. A baywo' tu cotor mac cu bin tar tu' yʌnen quir u yacsicob tu yorob ten cax u winiquirob judío cax mʌ' u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Baxuco' ca' u chaj u najticob ti' cu bin quimin ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Rajen a pimob caj u nuncob tan ya'aricob: ―Tij cu'yajex a ba' ts'iba'an ich u t'ʌn C'uj ti' a Cristojo' cu ya'aric: “Munt q'uin cu bin u cuxtar a Cristojo'.” Wa Cristojech biquinin ca wa'aric: “Bin in ca' quinsa' ich cruz?” A techo' ca wa'aric: “Iren techex”, quire' baxuc ca wa'aric. ");
INSERT INTO lacNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús caj u ya'araj ti'ob: ―Irej a mac a cu ximbar ich bej, cu jach p'isic u bʌj soc mʌ' u yac'birchʌjʌr tu bej wa tabar u bin q'uin. Quire' wa cu yac'birchʌjʌr mʌ' yer tu cu bin. Aro' baxuc ten, tabar in bin, a mac cu camsiquechex. Rajen toc acsex ta wor ten baje'rer. Ti' toy yʌn u q'uinin quir a wacsiquex ta worex soc a bin tacbirex munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ti' toj yʌnen tu' yʌnechex, toc acsex ta worex ten. Quire' a werex a wʌjtaquirenex a teno' soc a werex jach jaj u pararintechex C'uj. Caj ts'oc ya'aric aro' caj binij Jesús. Mʌ' u ca' u tsicbar ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Cax ya'ab tu yesaj carem beyaj Jesús ti'ob, mʌ' tu yacsob tu yorob ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Baxuc caj u nup'saj a ba' ara'b ten yʌjtseq'uir u t'ʌn C'uj Isaías uch. Quire' Isaías tu ts'ibtaj uch: Jaj Ts'urir, quij Isaías, a mac a tin tsec'taj a t'ʌn ti' uch, mʌ' tu yacsob tu yorob ti'. Cax ta yamtaj ti'ob, mʌ' tu sʌjtech Jaj Ts'urir, quij Isaías. A techo' yʌn tu cotor a muc'. ");
INSERT INTO lacNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rajen mʌ' c'ucha'an yor u winiquirob judío u yacsicob tu yor ti'. Tu ca' ten Isaías tu ts'ibtaj uch tan ya'aric: ");
INSERT INTO lacNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ac'birquinta'b u wich ten C'uj u winiquirob judío, bayiri' caj chichquinta'b u jo'r soc mʌ' u yiricob ba' soc mʌ' u najtic ba' xan, soc quir u c'axicob yorob, soc u to'carob ten C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Baxuc caj ya'araj Isaías uch quire' u c'at ca' ij quirex Cristo, raji' yʌn tu cotor u muc'. Rajen ya'araj aro'. ");
INSERT INTO lacNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Cax ya'ab u winiquirob judío mʌ' ju yacsob tu yorob ti' Jesús. Chʌc yʌn u ts'urirob u winiquirob judío tu yacsajob tu yorob ti' Jesús. Tu muc u acsajob tu yorob quire' cu sʌjticob a fariseo cu bin joc'sabirob ich carem naj soc mʌ' u yʌnyʌn tar. ");
INSERT INTO lacNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mʌ' ja wirej, cu tucricob soc tsoy irir ten u rac'ob chen mʌ' u tucricob soc tsoy irirob ten C'uj, rajen mʌ' tu toc arob ti' u rac'ob wa tu yacsob tu yorob. ");
INSERT INTO lacNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús caj u c'am araj ti' a pimo' tan ya'aric: ―Tu cotor mac a cu yacsicob tu yorob ti' in t'ʌn, mʌ' chen ten cu yacsic tu yor ti' in t'ʌn. Baxuc cu yacsicob tu yor ti' u t'ʌn in Tet C'uj a mac tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tu cotor mac u yirmʌnen baxuc xan yirmʌn in Tet, a mac tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A teno' ―quij Jesús―, iren quib quir in yerc'ac'tic techex a mac ti' yʌn ich yoc'ocab. Tu cotor mac a cu yacsicob tu yorob ten mʌ' u mʌn tu yac'birirob quire' yerob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","A mac cu yubicob in t'ʌn wa mʌ' ju yacsic tu yor ti' in t'ʌn mʌ' taren quir in taquic u jo'r mac baje'rer. Quire' mʌ' taren quir in taquic u jo'r mac quire' taren quir in taquic mac. ");
INSERT INTO lacNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","A maque' a mʌ' u sʌjtiquen a mʌ' ju yacsic tu yor ti' in t'ʌn ca' bin c'uchuc tu q'uinin u xur t'ʌn cu bin ts'abir u muc'yaj in t'ʌn a tin wa'araj ti'. Raji' cu bin u ta'quic u jo'r quire' mʌ' tu quibaj in t'ʌn. Rajen cu bin ts'abir u muc'yaj quire' mʌ' tu quibaj in t'ʌn ―quij―. ");
INSERT INTO lacNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","A teno' mʌ' tin chen araj techex in bʌjiri' in t'ʌn. In Tet C'uj a mac tu tuchi'tajen tu ya'araj ba' yʌn in wac techex. Baxuc a ba' yʌn in camsiquechex xan. ");
INSERT INTO lacNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","In wer a ba' caj u ya'araj ten in Tet, ra' quin tsec'tic techex soc yʌn techex a cuxtarex munt q'uin. Ra'iri'e' a tu ya'araj ten in Tet, quin wac techex, quet bayiri' quin wac techex. ");
INSERT INTO lacNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tabar u c'uchur tu q'uinin u qui'qui' janʌnob u winiquirob judío u q'uinin pascua. Jesús yer c'uchij tu q'uinin ti' cu wʌc'ʌs bin ich u Tet ca'anan. Jesús caj u yajquintaj a mac ts'a'b ti' ten u Tet C'uj. Jach manan caj u yajquintaj a ts'a'b ten u Tet. ");
INSERT INTO lacNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","A quisino' toc aca'an ti' Judas Iscariote. U tet Judas, Simón u c'aba'. Rajen u c'at u c'ubic Jesús soc u chucur. Jesús yer ts'a'b ti' u beyaj ten u Tet C'uj quir u cʌnantic tu cotor ba'. An ten bic caj tuchi'ta'b ich yoc'ocab yer xan je' u ca' bin ich ca'anan ich u Tet C'uj. Ti' toy cu janʌnob oq'uin tu q'uinin pascua. Cax Jesús tarij ich C'uj caj riq'uij caj u pitaj u ca' yarir u noc' caj u ch'aj u noc' tu cu tisic ba' caj u wit'c'ʌxtaj tu nʌc', irej c'urew a nanij cu p'o'ic yoc a mac acsa'b ich naj. ");
INSERT INTO lacNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jesús caj u pe'aj ya'arir ich palancan quir u p'o'ic yocob u camsʌwinicob a cura'anob tu janʌnob. Caj u tisaj u yocob yejer a noc'o' a tu wit'c'ʌxtaj tu nʌc'. ");
INSERT INTO lacNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jesús caj c'uchij ich Simón Pedro quir u p'o'ic u yocob caj ya'araj: ―Jaj Ts'urir, mʌ' jin najtic. Biquinin ca p'o'ic in woc? ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús caj u nuncaj ti', tan ya'aric: ―A ba' quin betic baje'rer mʌ' ja najtic chen pachir ca bin a najtic. ");
INSERT INTO lacNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro caj ya'araj: ―Mʌ' in cha'ic a p'o'ic in woc, mʌ' biq'uin. Jesús caj u nuncaj ti', tan ya'aric: ―Wa mʌ' jin p'o'ic a woc, mʌ' ten yʌninechi'. ");
INSERT INTO lacNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro caj ya'araj: ―Jaj Ts'urir, quen, mʌ' chen in woc ca p'o'ic, p'o'ej in c'ʌb xan yejer in jo'r. ");
INSERT INTO lacNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús caj ya'araj ti': ―A mac ts'oc u yichir mʌ' ba'wir cu p'obar tu cotor chen u yoc cu p'obar chen ti' u yoc. Baxuco' toc p'o'a'anechex. Mʌ' ja wirej, toc ruc'sa'an a si'pirex chen ti' yʌn turiri' tu yʌnechex mʌ' ruc'sa'an u si'piri'. ");
INSERT INTO lacNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Quire' Jesús yer Judas cu bin c'ubic, rajen tu ya'araj: “Turiri' tu' yʌnechex mʌ' ruc'sa'an u si'piri'.” ");
INSERT INTO lacNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Caj ts'oc u p'o'ic yoc u camsʌwinic, Jesús tu ca' buquintaj u ca'yarir u noc'. Caj wʌc'ʌs cura tu po'che'ir u janʌn caj u c'ataj ti'ob: ―A wer wa biquinin caj in p'o'aj a woquex? ");
INSERT INTO lacNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Quire' techex ca t'ʌniquenex in wʌjcamsayʌjirechex, baxuc ca t'ʌniquenex Jaj Ts'urir. Tsoy ca t'ʌniquenex quire' taj ten tin camsiquechex quire' taj a Jaj Ts'urirenex xan. ");
INSERT INTO lacNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A teno' a Jaj Ts'urirenex, baxuc a yʌjcamsʌyʌjirenechex tan in p'o'ic a woquex. Baxuc techex soc mʌ' a tucriquex jach no'jechex, ca' a yamtex a wet acsa'orirex. ");
INSERT INTO lacNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","A techexo' ta wirex ba' tin betaj, baxuc techex, rajra' ca' a betex, an ten bic ten tin betaj. ");
INSERT INTO lacNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Taj a ba' quin wa'aric techex, mʌ' tsoy wa ju c'urew cu tucric jach neno'j u beyaj ―quij Jesús―, rajen mʌ' u bin u betic an ten bic u jach ts'urir. Mʌ' tsoy wa mac tuchi'ta'b cu tucric jach neno'j u beyaj. Rajen bin u betic an ten bic a mac tuchi'tej. ");
INSERT INTO lacNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wa ca najtiquex a je' quin camsiquechex ca bin a cʌniquenex. Rajen cu bin u qui' tar a worex. ");
INSERT INTO lacNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mʌ' tan in tsicbar ti' tu cotorechex. In wer mac tin tetajechex quir in camsiquechex. Chen ti' yʌn turiri' ich techex a mac tin tetaj, aro' mʌ' quir u yamtiquen. A teno' tin chen tetaj quir in nup'sic a ba' ts'iba'an ich u t'ʌn C'uj tu cu ya'aric ich u t'ʌn C'uj uch: “A mac p'eri' in janʌn yejeren a mac in wet man. Raji' cu bin u c'ubiquen.” Ra' cu tsicbar ti' ten. ");
INSERT INTO lacNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mʌ' toy c'uchuc tu q'uinin u c'ubiqueni' quin toc aric techex soc a najtiquex soc ca' bin jach c'uchuc tu q'uinin u c'ubiquen ca' bin a qui' acsex ta worex ten. Quire' a werex yʌjtaquirenechex. ");
INSERT INTO lacNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A mac a cu yacsic a mac tin tuchi'taj, irej wa cu yacsiquen. A mac a cu yacsiquen, irej wa cu yacsic a mac a tu tuchi'tajene'. ");
INSERT INTO lacNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Caj ts'oc ya'aric aro' Jesús yaj cu yubic caj ya'araj ti' u camsʌwinicob: ―Taj a ba' quin wac techex, turiri' ich techex cu bin u c'ubiquen. ");
INSERT INTO lacNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Rajen u camsʌwinicob caj u yʌnxchun u pacran pʌcticob u bʌj quire' mʌ' yerob mac tan u tsicbari' ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ti' yʌnen, quij Juan, raji' Jesús cu jach yajquintic jach bʌytʌc cura'an janʌn yejer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro caj yesaj ti' Juan ca' u c'atej ti' Jesús wa mac tan u tsicbar ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ti' yʌn Juan bʌytʌc tu' yʌn Jesús, rajen caj u c'ataj: ―Mac aro'? Jaj Ts'urir ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Rajen Jesús caj u nuncaj ti', tan ya'aric: ―A mac a quin ts'ic ti' yoch pan a ts'oc in chuquic, raji' cu bin u c'ubiquen. Caj ts'oc u chuquic yoch pan caj u ts'aj ti' Judas, raji' u tet Judas Simón Iscariote. ");
INSERT INTO lacNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Caj ts'oc u ts'abʌr yoch pan Judas, caj oc quisin ti' Judas. Rajen Jesús caj u ya'araj: ―A ba' ca bin a betej baje'rer toc sebquintej, betej baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","U camsʌwinicob a mac yet janʌnob ich u pojche'ir mʌ' yerob biquinin caj ya'araj aro' ti' Judas. ");
INSERT INTO lacNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Quire' Judas ra' u beyaj quir u cʌnantic u taq'uin u yet camsʌwinicob, rajen caj u sosoc tucrajob Jesús tan ya'aric: ―Joq'uen mʌnej a ba' ij c'at quir ij qui'qui' janʌnex. Chen u jer caj u sosoc tucrajob ara'b ten Jesús ti' Judas ca' u jʌsej taq'uin ti' a mac mʌna'. ");
INSERT INTO lacNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Caj ts'oc u jantic yoch pan Judas sep caj joq'uij, jach ac'bir. ");
INSERT INTO lacNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Caj ts'oc u bin Judas, Jesús caj u ya'araj ti' u camsʌwinicob: ―Baje'rer c'uchij tu q'uinin cu bin u sʌjtiquen tu cotor mac. A teno' tu tuchi' ten C'uj a mac irenechex. Cu bin sʌjta'bir C'uj xan quire' a ba' quin bin in betej. ");
INSERT INTO lacNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Quire' a ba' quin bin in betej cu bin sʌjta'bir C'uj ten mac. Baxuc a C'ujo' cu bin u yiric jach caremen a teno'. Baje'rer c'uchij tu q'uinin cu yiric caremen a teno'. ");
INSERT INTO lacNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","In chan pararechex, tabar in bin, ca' bin a cʌxtiquenex an ten bic caj in wa'araj ti'ob u winiquirob judío. Baxuc xan quin wa'aric techex tu' quin bin a teno', mʌ' toy c'ucha'an a wor a tarex tu' quin bin. ");
INSERT INTO lacNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Quin toc aric techex u jer in t'ʌn ric'ben. Quin wac techex: Yajquintex a pacran bʌjex. An ten bic quin yajquintic techex. ");
INSERT INTO lacNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wa baxuco' tu cotor cu bin u yerob in camsʌwiniquechex wa ca pacran yajquintex a bʌjex. ");
INSERT INTO lacNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro caj u c'ataj ti' Jesús, tan ya'aric: ―Jaj Ts'urir ―quij―, tub u wich a bin? Jesús caj u nuncaj ti': ―A tu' quin bin a teno' mʌ' c'ucha'an a wor a tar baje'rer. Chen pachir je' a tare' ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro, caj u ya'araj: ―Jaj Ts'urir ―quij―, biquinin ca wa'aric mʌ' c'ucha'an in wor in tar ta pach baje'rer? ―quij Pedro―. Cax quimiquen ti' tech jach tsoy tin t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús caj ya'araj ti': ―A techo' Pedro mʌ' a c'at a quimini', taj quin wac tech mʌ' toy c'aynʌc a caxo' mʌna' u nup u tenin ca' bin a wa'arej mʌ' a c'ʌ'oteni'. Tabar in bin, ca' bin a cʌxtiquenex a teno'. ");
INSERT INTO lacNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús caj ya'araj ti' u camsʌwinicob: ―Mʌ' a xac' a tucriquex ba', acsex ta wor ti' C'uj. Baxuc ten acsex ta worex ten xan. ");
INSERT INTO lacNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tar quin bino' ich in Tet C'uj. Wa mʌ' taj ca'ch mʌ' in wac techex. Tar quin bino' quir in tsoyquintic quir a wocarex quir a cʌjtarex. ");
INSERT INTO lacNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cu ts'ocar in tsoyquintique', je' in ca' tare' quir in pʌyiquechex soc rajra' ti' yʌnechex tu' yʌnen. ");
INSERT INTO lacNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A tu' quin bin a teno' a toc erex bic tabar a tarex. ");
INSERT INTO lacNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás caj u ya'araj ti': ―Jaj Ts'urir ―quij―, mʌ' in werob tu' ca bin. Bic in weticob bic tabar in tar tu' yʌnech? ");
INSERT INTO lacNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús caj u nuncaj ti', tan ya'aric: ―Quire' a teno' ca' bin c'uchuquechex tu' yʌn in Tet C'uj. Quire' a teno' ca' bin a wetiquex a ba' taj. A teno' quin ts'ic a cuxtarex ric'ben. Chen a mac a cu yacsic tu yor ten cu bin u c'uchur tu' yʌn in Tet C'uj. A mac mʌ' u yacsic tu yor in t'ʌn mʌ' c'ucha'an yor u yer C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ra' u q'uinin mʌ' a werenexi', rajen mʌ' a werex in Teti'. Baje'rer a chʌc erex in Tet xan quire' tan a cʌnic a werenex xan. ");
INSERT INTO lacNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Rajen Felipe caj ya'araj ti': ―Jaj Ts'urir ―quij―, cha' in wiricob ic Tet C'ujex a baxuco' ti'ti' tenob. ");
INSERT INTO lacNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús caj ya'araj: ―Mun q'uin ti' yʌnen yejerechex? Mʌ' toy a weren, Felipe? A mac yirmʌnen baxuc yirmʌn in Tet C'uj xan. Biquinin ca wac ten: “Cha' in wiricob ic Tetex C'uj”? ");
INSERT INTO lacNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mʌ' wa ta wacsex ta worex ra'iri'enob yejer in Tet C'uj? A ba' quin wa'aric techex mʌ' in t'ʌni'. A quin wa'aric techexo' u t'ʌn in Tet C'uj. Mʌ' ja wirej, in Tet ti' cʌja'an tin pixam raji' cu betic a carem beyajo'. ");
INSERT INTO lacNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Acsex ta worex ten ra'iri'enob yejer in Tet C'uj. Wa mʌ' c'ucha'an a wor a wu'yic a ba' quin wa'aric techex, rajen acsex ta worex ti' a ba' quin betic. ");
INSERT INTO lacNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Taj a ba' quin wac techex. Acsex ta worex wa quin yamtiquechex soc quet bayiri' carem a beyajex xan an ten bic ten carem in beyaj. Chen jach manan ca bin a betiquex quire' ca' bin xiquen ich in Tet C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Quire' ta wacsex ta worex ten, rajen c'ucha'an a worex a c'atic ba' ti' C'uj. Rajen a teno' quin bin in ts'ic tu cotor a ba' ca c'atiquex ti' in Tet. Soc a baxuco' cu bin ya'aricob mac jach carem in Tet C'uj quire' ten tin yamtajechex ―quij Jesús―. Mʌ' ja wirej, u pararen C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Quire' ca wacsiquex ta worex ten, rajen ca bin a c'atiquex ba' ten, rajen quin ts'ic techex xan. ");
INSERT INTO lacNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesús caj ya'araj ti'ob: ―Wa ca yajquintiquenex je' a quibiquex tu cotor in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Wa ca quibiquex in t'ʌn je' in t'ʌnic in Tet C'uj soc u ts'ic techex u Taj'or u Pixam C'uj quir u yamtiquechex. Rajra' ti' yʌn yejerechex. Raji' cu cʌnantic in t'ʌn xan a ba' jach taje'. ");
INSERT INTO lacNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","A mac ti' yʌn ich yoc'ocab mʌ' c'uch'a'an yorob u c'ʌmic u Taj'or u Pixam C'uj quire' mʌ' u yacsicob tu yorob ti' wa ti' yʌn quire' mʌ' yerob bic tabar cu beyaj. Quire' ca' bin tac u Taj'or u Pixam C'uj, je' a wetiquexe' quire' a wet binex yejer. Baxuc cu bin u cʌjtar ta pixamex. ");
INSERT INTO lacNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mʌ' jin bin in p'ʌtiquechex, je' in ca' tar soc ti' yʌnen yejerechex tu ca' ten. ");
INSERT INTO lacNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A mac a ti' yʌnob ich yoc'ocab, mʌ' ya'ab u q'uinin cu bin yiriquenob. Chen techex rajra' ca bin a wiriquenex quire' ca bin a wiriquex in beyaj. Quire' a teno' quin bin in cuxtar, rajen ca bin a c'ʌmiquex ric'ben cuxtar techex. ");
INSERT INTO lacNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Quire' ca' bin tac u Taj'or u Pixam C'uj quir u cʌjtar ta pixamex je' a c'ʌ'otiquex a teno' ra'iri'en yejer in Tet C'uj. Je' a c'ʌ'otiquex ti' yʌnen yejerechex ra'iri'en yejerechex quire' ti' yʌnen ta pixamex. ");
INSERT INTO lacNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","A mac cu quibic in t'ʌn a tu yubaj raji' cu yajquintiquen. A mac cu yajquintiquen raji' yajbir ten in Tet C'uj. Baxuc ten quin yajquintic xan. Je' in tar ti' soc u jach c'ʌ'otiquenob. ");
INSERT INTO lacNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas mʌ' ra' Iscariote caj ya'araj ti' Jesús: ―Jaj Ts'urir ―quij―, biquinin mʌ' a wesic a bʌj ti' tu cotor mac a ti' yʌn ich yoc'ocab? ");
INSERT INTO lacNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús caj u nuncaj ti', tan ya'aric ti': ―A mac a cu yajquintiquene' cu quibic a ba' quin wac ti'. Raji' yajbir ten in Tet C'uj. Quin tarob yejer in Tet quir in cʌjtarob tu pixamo'. ");
INSERT INTO lacNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","A mac a mʌ' u yajquintiquen, raji' mʌ' u quibic a ba' quin wa'aric ti'. Mʌ' ten in t'ʌn a quin wa'aric techexo'. Raji' u t'ʌn in Tet a mac tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Quin wa'aric techex aro' ti' toy yʌnen yejerechex. ");
INSERT INTO lacNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Quire' tin c'ataj ti' in Tet ca' u tuchi'tej techex u Taj'or u Pixam C'uj quir u yamtiquechex. Je' u camsiquechex tu cotor ba'. Baxuc je' u c'asic techex tu cotor a ba' caj in wa'araj techex uch. ");
INSERT INTO lacNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Mʌ' toy xiquen, je' in chichquintic a worex. Mʌ' in chichquintic a worex an ten bic mac cu chichquintic u yor u rac'ob a ti' yʌn ich yoc'ocabe'. Quin bin in ts'ic techex u qui'ir in wor soc rajra' qui' a worex. Rajen mʌ' a xa'xac' tucurex, baxuc mʌ' a ch'iquex sajaquirex. ");
INSERT INTO lacNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Quire' tin wa'araj techex bin in ca'. Quire' tin wa'araj techex je' in ca' tar in wiriquechex. Wa ca yajquintiquenex cu qui' tar a worex quire' wʌc'ʌs bin in ca' ich in Tet C'uj. In Teto' jach manan no'j, a teno' mʌ' nejach no'jeni'. ");
INSERT INTO lacNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Quire' quin wac techex aro' ti' toy yʌnen yejerechex quire' mʌ' toy xiquen. Baxuco' ca' bin xiquen je' a quibiquex a ba' tin wa'araj techexo'. ");
INSERT INTO lacNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mʌ' ya'ab u q'uinin quir in tsicbar ya'ab techex quire' tabar u c'uchur a quisino' quir u cʌxtiquen. Raji' cu cʌnantic tu cotor mac ich yoc'ocab a mac mʌ' yer C'ujo'. Mʌ' ju c'uchur yor u betic mʌ' c'ʌs ba' ten. ");
INSERT INTO lacNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","A teno' quin chen betic an ten bic tu ya'araj ten in Tet. Baxuc soc yer mac quin yajquintic in Tet. Jeroj riq'uenex cuxex ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús caj ya'araj ti' u camsʌwinicob: ―A teno' ―quij―, iren u yaq'uir u wich uva. In Tet C'uj irej a mac cu cʌnantic u yaq'uir u wich uva. ");
INSERT INTO lacNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tu cotor mac cu tar tin wicnʌn irob u xa'yar yaq'uir uva. A mac a cu tar tin wicnʌn a mʌ' u betic a ba' u c'at in Tet C'uj, raji' irej u xa'yar yaq'uir uva a mʌ' u ts'ic u wiche'. Wa ju xa'yar yaq'uir a mʌ' u ts'ic u wich a mac cu cʌnantic u yaq'uir uva cu janc'ubtic u xa'yar yaq'uir. Baxuco' in Tet C'uj cu bin u betej ti' a mac a mʌ' u betic a ba' u c'at C'uj. Chen a mac cu tar tin wicnʌn a cu betic a ba' u c'at C'uj cu bin yamta'bir ten C'uj soc u man tu tsoyir. Raji' irej u xa'yar yaq'uir uva cu racʌr a ba' mʌ' tsoye', ten a mac a cu cʌnantic soc u nets'ic u wich. ");
INSERT INTO lacNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mʌ' ja wirej, in Tet C'uj tu toc ruc'saj a c'asirex a ta betajex quire' ta wacsajex ta worex in t'ʌn a tin wa'araj techex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","P'atenex tin wicnʌn soc in p'atʌr ta pixamex. C'aj techex wa ju xa'yar yaq'uir wa mʌ' ti' yʌn ich u jach aq'uir, mʌ' c'ucha'an yor u ts'ic u wichi'. Rajen, wa ca p'atʌrex tin wicnʌn soc in p'atʌr ta pixamex baxuco' c'ucha'an a worex a betic a ba' u c'at C'uj. Quire' wa mʌ' a p'atʌrex tin wicnʌn mʌ' c'ucha'an a worex a betic a ba' u c'at C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’A teno', iren u jach aq'uir uva, a techexo' irechex u xa'yar yaq'uir uva. A mac a cu p'atar tin wicnʌn quin p'atar xan tu pixam raji'ob cu ts'ic u wich, cu beticob a ba' u c'at C'uj. A wʌc'ʌs bʌjiri'ex mʌ' c'ucha'an a worex ti' mʌna' ba', quire' yʌn in yamtiquechex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A mac a mʌ' u c'at u quibic in t'ʌn, raji' mʌ' u c'at u p'atʌr tin wicnʌn. Raji' irej u xa'yar yaq'uir uva a mʌ' u ts'ic u wich. Rajen cu janch'ʌctic. U xa'yar yaq'uir uva a tu janch'ʌctaj cu tijir. Pachir cu tar u maric quir u toquic ich c'ac'. ");
INSERT INTO lacNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Wa ca p'atʌrex tin wicnʌn, baxuc wa cu p'atʌr in t'ʌn ta pixamex, c'ucha'an a worex a c'atiquex tu cotor ba' a c'atex ti' C'uj. Je' u ts'ic techex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wa rajra' ca betiquex a jach tsoyo' in Tet C'uj cu bin sʌjta'bir C'uj ten tu cotor mac. Baxuco' ca wesiquex in jach camsawiniquechex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","An ten bic in Tet cu yajquintiquen, baxuc techex quin yajquintiquechex. P'atenex soc in yajquintiquechex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wa ca quibiquex tu cotor a ba' quin wac techex. A baywo' quin yajquintic techex an ten bic in Tet C'uj cu yajquintiquen quire' tin quibaj tu cotor a ba' caj u ya'araj ten. ");
INSERT INTO lacNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Rajen quin wa'aric techex aro' soc rajra' qui'ex a worex an ten bic ten qui' in wor. A baywo' jach manan qui'ex a worex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A je' in t'ʌna' tan in wac techex ca' a pacran yajquintiquex a bʌjex an ten bic ten caj in yajquin techex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A mac a cu c'ubic u bʌj quir u quinsa' ti' a mac a cu jach yajquintic, raji' jach manan cu yajquintic. Baxuc quin bin in betej a teno', rajen yʌn cʌniquenex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Techex jach manan quin yajquintiquechex wa ca betiquex a ba' tin wa'ara techex baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Baje'rer ra'iri'o'onex quire' tin cha' a najtiquex tu cotor a ba' in wu'ymʌn ich in Tet C'uj. A mac a cu beyaj mʌ' ara'b ten u ts'urire' tu cotor ba' cu tucric u betic. Chen ten tin toc araj techex rajen baje'rer mʌ' in c'urewechex quire' ra'iri'o'onex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A techexo' mʌ' ta tetajenex chen ten tin tetajechex. An ten bic u yaq'uir uva ts'a'b u beyaj ten C'uj quir u wichʌncʌr. A teno' tin ts'aj techex a beyajex soc a wesic u beyaj C'uj ta pixamex. U yaq'uir uva yʌn u q'uinin quir u wichʌncʌr. Chen mʌ' baxuc techex quire' techex rajra' c'ucha'an a worex a wesiquex u beyaj C'uj ta pixamex. Rajra' ca bin a betiquex aro' quire' ta wacsex ta worex ten. Rajen a ba' ca c'atiquex ti' in Tet C'uj je' u ts'ic techex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","A je' in t'ʌna' tan in wac techex: ca' a pacran yajquintex a bʌjex. ");
INSERT INTO lacNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesús caj ya'araj ti' u camsʌwinicob: ―Wa mac cu p'actiquechex mʌ' a p'ʌtiquex in t'ʌn, c'aj techex ten tu yʌn p'acten a teno'. ");
INSERT INTO lacNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wa techex irechex a mac ti' yʌn yoc'ocab cu yajquintiquechexob quire' irechexob a mac ti' yʌn yoc'ocab. Chen mʌ' irechex a mac ti' yʌnob ich yoc'ocab quire' ten tin tetajechex ich a mac a mʌ' ju yacsob tu yorob in t'ʌn. Rajen cu bin u p'actiquechex a mac ti' yʌnob yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","C'aj techex a ba' caj in wa'ara techex: “A mac a cu beyaj ti' u jer, mʌ' no'j u beyaj. Chen u ts'urir a mac a cu beyaj, raji' jach no'j u beyaj.” Robob caj u chucob in pach, baxuc techex xan cu bin u chuquicob a pachex. Robob wa tu quibajob in t'ʌn, baxuc techex cu bin u quibicob a t'ʌnex xan. ");
INSERT INTO lacNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Baxuc tu cotor aro', cu bin u beticob ti' techex quire' mʌ' tu yacsob tu yorob in t'ʌn quire' mʌ' yerob mac tu tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Wa mʌ' taren in tsicbar ti'ob uch, mʌ' chʌca'an yiricob u si'pirob. Quire' taren, rajen mʌ' c'ucha'an yor ya'aricob mʌna' u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Chen a mac a cu p'actiquen baxuc cu p'actic in Tet xan. ");
INSERT INTO lacNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wa mʌ' tin wesob ti' carem beyaj an ten bic mʌna' mac yiramʌn uch, mʌ' chʌca'an yiricob u si'pirob cax tu yirob a ba' tin betaj caj u p'actajenob yejer in Tet. ");
INSERT INTO lacNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chen robob caj u nup'saj tu' ts'iba'an ich u t'ʌn C'uj uch: “Tu chen p'actajenob quire' baxuc u c'atob u bʌjiri' cu p'acticquenob.” Baxuc ts'ibta'b ten uch yʌjtseq'uirob u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ca' bin c'uchuc tu q'uinin cu bin tar u Taj'or u Pixam C'uj a mac quin tuchi'tic soc u yamtiquechex. Taj a ba' cu bin yac techex quire' ti' u tar ich u Tet C'uj. Raji' cu bin u tsec'tiquen ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Techex xan ca bin a tsec'tiquenex ti'ob quire' techex ti' yʌnechex yejeren caj u yʌnxchun in beyaj hasta baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Quin toc aric techex a jera' soc mʌ' a p'ʌtiquex in t'ʌn pachir quire' a werex mac cu p'actiquex. ");
INSERT INTO lacNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Robob cu bin u joc'siquechex tu cu naj c'ujinticob C'uj u winiquirob judío. Je' u c'uchur tu q'uinin xan je' u quinsiquechex xan quire' cu tus tucricob wa quet u beyaj C'uj a cu beticob. ");
INSERT INTO lacNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Baxuc cu bin u beticob techex quire' mʌ' yerob in Tet C'uj. Baxuc ten xan mʌ' yerenobi'. ");
INSERT INTO lacNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mʌ' ja wirej, quin toc aric techex aro' baje'rer soc ca' bin c'uchuc tu q'uinin cu chuquicob a pachex ca bin a c'ʌ'otiquex a ba' caj in toc araj techexe'. ’Caj in yʌn tetajechex uch mʌ' jin toc araj techex quire' ti' toy yʌnen yejerechex. Mʌ' ju bin u tar ti' techex aro' hasta ca' bin xiquen. ");
INSERT INTO lacNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesús caj ya'araj ti' u camsʌwinicob. Baje'rer bin in ca' ich in Tet C'uj a mac tu tuchi'tajen. Mʌna' turiri' techex a c'atmʌnex ten biquinin ca bin. ");
INSERT INTO lacNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jach yaj tan a wu'yiquex quire' tucur a ca'ex quire' tin wa'araj techex bin in ca' ich in Tet. ");
INSERT INTO lacNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Quire' taj quin wac techex. Jach tsoy ti' techex ca' xiquen ich in Tet C'uj. Quire' wa mʌ' jin bin mʌ' ju tar u Taj'or u Pixam C'uj. Chen wa ca' bin xiquen je' in tuchi'tic techex u Taj'or u Pixam C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ca' bin tac u Taj'or u Pixam C'uj je' u yesic soc chʌca'an yiric tu cotor mac ich yoc'ocab yʌn u si'pirob. Baxuc xan, je' u yesic mac soc chʌca'an yiricob bic tabar u cuxtaro', a jach tajo'. Baxuc xan je' u yesic soc chʌca'an yiric cu bin u jʌsbir ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Je' u yesic soc chʌca'an yiric yʌn u si'pirob quire' mʌ' tu toc acsajob tu yorob ten quire' ten quin taquicob. ");
INSERT INTO lacNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Je' u yesic mac a cuxtaro' a jach tajo' an ten bic caj cuxrajen ich yoc'ocab quire' mʌ' c'ucha'an yorob yiriquenob quire' ca' bin ts'ocac in beyaj bin in ca' ca'anan. ");
INSERT INTO lacNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Je' u yesic soc chʌca'an yiric C'uj cu bin jʌsbirob quire' toc jʌsa'anob ten C'uj quir u binob muc'yajob munt q'uinob. ");
INSERT INTO lacNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Yʌn toy ya'ab quir in camsiquechex chen mʌ' c'ucha'an a worex a najtiquex baje'rer. Quire' mʌ' toy c'uchuc tu q'uinin quir a najtiquexi'. ");
INSERT INTO lacNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ca' bin tac u Taj'or u Pixam C'uj cu bin u camsiquechex tu cotor a ba' jach tajo'. Mʌ' ju bin u tsicbar techex u wʌc'ʌs bʌjiri' u t'ʌn. Ra' cu bin u tsicbar techex a ba' ara'b ten in Tet C'uj. Je' u tsicbar ti' techex a ba' cu bin tar ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Je' u tsicbar techex soc a sʌjtiquenex quire' ra' u beyaj u Taj'or u Pixam C'uj quir u tsec'tic ti' techex ti' ten soc a werex u jach tajiren a teno'. ");
INSERT INTO lacNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tu cotor a ba' yʌn ti' in Teto' tu cotor ten yʌnin. Rajen tin wa'araj techex u beyaj u Taj'or u Pixam C'uj ra' quir u tsec'tic ti' techex ti' ten soc a werex u jach tajiren a teno'. ");
INSERT INTO lacNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesús caj ya'araj: ―Chen sasame' ca bin a wiriquenex. Chen mʌ' ya'ab u q'uinin mʌ' ja bin a wiriquenex. Pachire' je' a ca' iriquenex. Cu ts'ocar aro' quin ca' bin ich in Tet C'uj ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jun yarob u camsʌwinicob caj u pacran aricob: ―Ba' u c'at ya'aric aro'?: “Chen sasame' ca bin a wiriquenex. Chen mʌ' ya'ab u q'uinin mʌ' ja bin a wiriquenex. Pachire' je' a ca' iriquenex. Cu ts'ocar aro' quin ca' bin ich in Tet C'uj”, quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ba' u c'at ya'aric: Sansame'? Mʌ' ic najtic a ba' cu ya'aric ―baxuc cu pacran a'aricob u camsʌwinicob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús caj u najtaj u c'atob u c'atic a ba' u c'at ya'aric, a ba' ara'b ti'ob same'. Rajen Jesús caj ya'araj ti'ob: ―In wer a ba' ca pacran ariquexe'. Chen sasame' ca bin a wiriquenex. Chen mʌ' ya'ab u q'uinin mʌ' ja bin a wiriquenex. Pachire' je' a ca' iriquenexe'. Cu ts'ocar aro' quin ca' bin ich in Tet C'uj ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Taj a ba' quin wa'aric techex. Ca bin a woc'arex, ca bin a tucurex. Chen a pimob cu bin u qui' tar u yorob. Sansame' ca chen tucurex. Pachire' cu qui' tarex a worex jach jaj. ");
INSERT INTO lacNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ca' bin c'uchuc tu q'uinin a xquico' cu bin u rochic chan och. Tucur u ca' quire' muc'yaj u ca', chen ca' bin ts'ocac u rochic chan och, cu tubur ti' u muc'yaj a tu yubaj. Chen pachir qui' yor quire' tu rochaj chan och. ");
INSERT INTO lacNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Baxuc techex xan baje'rer tucur a ca'ex, irej a xquico'. Cu man mʌ' ya'ab u q'uinin je' a ca' iriquenex. Baxuc cu bin u qui'tar a worex xan. Mʌna' mac cu bin u ruc'sic u qui'ir a worex. ");
INSERT INTO lacNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ca' bin c'uchuc a ray q'uino' mʌ' ja bin a c'atic ba' ten. Taj a ba' quin wac techex. Ca' bin a t'ʌnex C'uj chich a wor ca' bin a t'ʌnejex. Je' u ts'ic techex tu cotor ba' quire' ta c'ʌnex in c'aba'. ");
INSERT INTO lacNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mʌ' toy a tumtex chen baje'rer a yʌnx chun techex a c'atiquex ti' in Tet. Tan a c'ʌniquex in c'aba' tu ca t'ʌniquex C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’A teno' ―quij Jesús―, tin c'ʌs mucraj a ba' tin wa'araj techex uch. Je' u c'uchur tu q'uinin mʌ' in mucric techex quin bin in toc aric techex in Tet C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Je' u c'uchur tu q'uinin ca' bin xiquen ich in Tet C'uj a ray u q'uinino'. A bʌjiri'ex ta junanex ca bin a c'atex ba' ti' in Tet C'uj quire' ta wacsex ta worex ten. Mʌ' ba'wir quin c'atic ti' in Tet C'uj ti' techex. ");
INSERT INTO lacNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Quire' u bʌjiri' in Tet cu yajquintiquechex. Cu yajquintiquechex quire' ta yajquintenex quire' techex ta quibex ti' in tar ich C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Raji' taj, a teno' taren ich C'uj tera' ich yoc'ocab. Rajen baje'rer quin p'ʌtic yoc'ocab quire' wʌc'ʌs bin in ca' ich in Tet C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","U camsʌwinicob caj ya'arob ti': ―Baje'rer tan a tsicbar soc in najticob a ba' ca wa'aric. Mʌ' tan a c'ʌs mucric a ba' ta wa'araj tenob tu ca p'eri'quintic a ba' ca camsic ti' tenob uch. ");
INSERT INTO lacNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","A tenobo', in werob tu cotor ba' a wer. Quire' a wer yʌn ba' quin c'aticob tech cax mʌ' toy in c'atob ti' tech a toc er. Rajen mʌ' ba'wir mac quir u c'atic tech ba'. Rajen quin quibicob tu tuchi'tech C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús caj ya'araj ti'ob: ―A wacsmʌnex ta worex chen yʌn toy a c'atex. ");
INSERT INTO lacNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tabar u c'uchur tu q'uinin ca bin a p'ʌtiquenex tantanxer ca' bin xiquechex. Chen tin junan ca bin p'ʌtenex. Chen mʌ' tin junani' quire' ti' yʌn in nup, raji' in Tet C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Quin wa'aric techex tu cotor aro' soc mʌ' a ch'iquex sajaquirex quire' ta wacsex ta worex ten. Ti' toy cuxa'anechex ich yoc'ocab, je' a muc'yajex. Chen mʌ' a ch'iquex sajaquirex quire' a teno' ts'oc in toc ruc'sic u muc' u ts'urir a mac ti' yʌnob ich yoc'ocab. Baxuc techex ca bin a ruc'siquex u muc' u ts'urir a ti' yʌn ich yoc'ocabe'. ");
INSERT INTO lacNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús caj ts'oc u ya'aric aro' caj u nacsaj u wich ca'anan quir u t'ʌnic C'uj. Caj ya'araj: ―Tet ―quij―, c'uchij tin q'uin esej ti'ob a winico' jach caremen a teno' quire' a pararen soc c'ucha'an in wor in wesic ti' a winico' jach caremech xan. ");
INSERT INTO lacNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Quire' ta ts'aj in cʌnantej tu cotor mac a ti' yʌn ich yoc'ocab cax a mun ti' yʌn soc c'ucha'an in wor in ts'ic ti'ob u cuxtar muntq'uin a mac ta ts'aja ten. ");
INSERT INTO lacNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","In Tet jach C'ujech quire' mʌna' u jer baxuquech. A teno' Jesucristojen a mac a ta tuchi'taj ich yoc'ocab. Tu cotor mac u yerech, baxuc u yeren xan. Je' u c'ʌmicob u cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ts'oc in wesic ti' tu cotor mac a ti' yʌn ich yoc'ocab jach caremech a techo'. Quire' tin ts'ocsaj in beyaj a ta ts'aja ten baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Baje'rer Tet ―quij Jesús―, esej ti' tu cotor mac jach caremen a teno' ʌcʌtanech an ten bic ti' yʌnen uch yejerech cax mʌna' toy ru'um uch. ");
INSERT INTO lacNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’A teno', tin wesaj ti'ob bicyʌra'ech ti' a mac ta tetaj ich yoc'ocab quir a ts'ic ten. Tech yʌnin ca' ta ts'ajob ten caj u quibob a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tu cotor ba' a ta ts'aja ten u tar ti' tech in Tetech. ");
INSERT INTO lacNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","A teno' tin toc araj ti'ob a t'ʌn, a ta wa'araj ten. Robob caj u c'ʌmajob a t'ʌn quire' yerob taj, ti' in tar tub yʌnech. Caj u yacsajob tu yorob tech ta tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’A teno' ―quij Jesús―, quin c'atic tech ca' a yamtejob. Mʌ' jin c'atic tech quir a yamtic tu cotor mac ich yoc'ocab. Chen ca' a yamtej a mac a pararob a mac a ta tetaj ca' u yacsejob tu yor ten. ");
INSERT INTO lacNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tu cotor mac tech yʌnin, ten yʌnin xan. Tu cotor a mac ten yʌnin tech yʌnin xan. P'eri' to'on yʌnin quire' a ba' cu bin u beticob quin bin sʌjta'bir. ");
INSERT INTO lacNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Baje'rer tar in ca' ich tech tu ca'ten. Mʌ' jin p'atʌr ich yoc'ocab. Chen robob cu bin u p'atʌrob ich yoc'ocab tu junanob. In Tet ʌcʌtan tech a mʌna' u si'piro' quin c'atic tech ca' a cʌnantej tu cotor mac a ta ts'aj ten uch. Soc c'ucha'an yorob ti' wa ba' cu tar u tumtic yorob. Quin c'atic tech ca' a cʌnantej ti'ob soc p'eri' u tucurob an ten bic tenob quire' p'eri' in tucurob xan. ");
INSERT INTO lacNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ti' toy yʌnen yejerob ich yoc'ocab a mac a ta ts'aja ten tin cʌnantajob tin camsaj ti'ob a ba' a c'at. Tin cʌnantaj soc mʌ' u satʌrob. Chen ti' toy cu sayʌrob tin pach a mac a ta ts'aja ten. Chen turiri' satij. Quire' ti' ts'iba'an ich u t'ʌn C'uj cu bin satʌr. ");
INSERT INTO lacNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Quire' tar in ca' ta wicnʌn, Tet. Chen tan in t'ʌniquech ti'ob, ti' toy yʌnen yejerob tera' ich yoc'ocab. Soc cu yubicob soc cu chichquinta'r yorob quire' in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tin wa'araj ti'ob a t'ʌn. Baje'rer robob caj p'actabir ten mac. Quire' mʌ' p'eri'ob u tucurob yejer a mac ti' yʌn yoc'ocab. Quire' baxuc ten ―quij Jesús―, mʌ' p'eri' in tucur yejer a mac ti' yʌn ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mʌ' tan in c'atic tech ca' a joc'sicob ich yoc'ocab. Tan in c'atic tech ca' a cʌnantob ti' a quisino' soc mʌ' u p'ʌticob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Quire' mʌ' p'eri' u tucurob yejer a mac ti' yʌn ich yoc'ocab quire' baxuc ten ―quij Jesús―, mʌ' p'eri' in tucur yejer a ti' yʌn ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tsoyquintej yorob yejer a t'ʌn quire' a t'ʌn a techo', raji' taj. ");
INSERT INTO lacNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","An ten bic ta tuchi'tajen ich a mac a ti' yʌnob yoc'ocab quir in wa'aric a t'ʌn. Baxuc ti'ob quin tuchi'tic ich yoc'ocab quir u ya'aricob a t'ʌn yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Quire' tan in c'ubic in bʌj quir in betic a ba' a c'at quire' quin yajquinticob xan soc jach jaj tech yʌninob tu cotorob. C'ucha'an yorob u beticob aro' quire' baxuc tin betaj ten xan. ");
INSERT INTO lacNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Mʌ' chen ti'ob quin c'atic tech, quin c'atic tech ti'ob a mac a cu bin u yacsic tu yor pachir ca' bin yubej u tsec'ticob a t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Quin t'ʌniquech ti'ob, Tet, soc p'eri'ob u tucurob an ten bic tech yejeren, Tet, p'eri'enob in tucurob. Soc tu cotor mac cu bin u yacsicob tu yorob tech ta tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A teno' tin ts'aja ti'ob u tsoyir u pixamob an ten bic ta ts'ajten u tsoyir in pixam soc p'eri' u tucurob an ten bic tenob p'eri' in tucurob xan ―quij Jesús―. ");
INSERT INTO lacNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","A teno' ti' yʌnen tu pixamob, a techo' ti' yʌnech tin pixam xan soc raji'ob jach jaj p'eri'ob u tucurob soc tu cotor mac yerob tech ta tuchi'tajen soc yerob xan tech ta yajquintaj a mac a cu yacsicob tu yorob in t'ʌn an ten bic ten ca yajquintiquen, Tet. ");
INSERT INTO lacNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tet ―quij Jesús―, in c'at u tarob a mac a ta ts'aja ten tu' quin bin a teno' soc munt q'uin ti' yʌnob yejerenob. Soc yiricob a teno' u sasiriren a ta ts'aja ten quire' ta yajquinten cax mʌna' toy yoc'ocab uch. ");
INSERT INTO lacNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","In Tetech, C'uj, taj a wor a techo'. A mac a ti' yʌn ich yoc'ocab mʌ' yerech chen ten in werech. In camsʌwinicob yerob tech ta tuchi'tajen. ");
INSERT INTO lacNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tin camsaj ti'ob soc yerechob. Ti' toy jach ya'ab u q'uinin bin in camsic ti'ob soc yerechob a techo' jach manan. Soc u yajquintiquechob an ten bic ca yajquintiquen soc ti' quin cʌjtar ich u pixamob, ―baxuc caj u t'ʌnaj C'uj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Caj ts'oc u t'ʌnic C'uj Jesús caj joc' yejer u camsʌwinicob. Caj u ch'ʌctaj pʌchij chan ja' u c'aba' Cedrón. Ti' c'uchij tu' yʌn u chan corir u pʌc'ar Olivo. Ti' mani yejer u camsʌwinicob yaran u che'er Olivo. ");
INSERT INTO lacNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas a cu bin u c'ubic Jesús yer tu yʌn u chan corir quire' ti' nanij Jesús cu bin yejer u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ti' c'uchij Judas yejer ya'ab soldados yejer policía a cu beyajob ich carem naj tu cu naj c'ujinticob C'uj u winiquirob judío. Robob tuchi'ta'b ten u jach ts'urirob sacerdote yejer a fariseojo'. Caj tarob u mʌchmʌnob tʌjte' yejer u quib yejer u mascab xan. ");
INSERT INTO lacNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús yer tu cotor ba' a ba' cu bin tar ti' rajen raji' nats'ij ich a pimo' a cu tarob caj u c'ataj ti'ob: ―Mac tan a cʌxtiquex? ");
INSERT INTO lacNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Caj u nuncob tan ya'aricob: ―Tan in cʌxticob Jesús a cu tar ich u cajar Nazaret. Jesús caj u nuncaj ti'ob tan ya'aric: ―Raji'en. Ti' yʌn Judas xan yejer a mac tarob tan u c'ubic Jesús ti' a pimob. ");
INSERT INTO lacNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Caj ts'oc u ya'aric Jesús: “Raji'en”, caj cuncun pachnʌjob a mac a cu tarob u chuquicob Jesús ca'ch. Sep caj rubob ich ru'um. ");
INSERT INTO lacNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús caj u ca' c'ataj ti'ob: ―Mac tan a cʌxtiquex? Caj u nuncajob: ―Jesús a cu tar ich u cajar Nazaret tan in cʌxticob. ");
INSERT INTO lacNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús caj u ya'araj ti'ob: ―Tin wa'araj techex, raji'en a ta wu'yajex in wa'aric techex. Rajen robob in camsʌwinicob tsire'ej u binob a ti'ob quire' chen ten ca cʌxtiquenex. ");
INSERT INTO lacNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesús caj ya'araj ti'ob baxuco' soc u nup'sic a ba' caj u ya'araj ti' C'uj caj u t'ʌnaj sam caj ya'araj: “A mun ta ts'aja tene' mʌ' ju bin sa'tʌr”, baxuc caj u ya'araj Jesús ti' C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro u ch'a'mʌn u mascab caj u jarar tu pix u mascab caj u ch'ʌcaj u xiquin, raji' u c'urew u jach ts'urir sacerdote. Raji' u c'aba' u c'urew Malco. Caj u racch'ʌctaj u xiquin ich u no'oj. ");
INSERT INTO lacNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús caj u ya'araj ti' Pedro: ―Wʌc'ʌs jupej a mascab tu pix. Wa baxuc ca betic mʌ' in bin in muc'yaj an ten bic in Tet u c'at in muc'yaj. ");
INSERT INTO lacNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Rajen u capitán yejer u soldado yejer policía a cu beyajob ti' sacerdote caj u chucob Jesús caj u c'ʌxob u c'ʌbob, quir u binob u purej. ");
INSERT INTO lacNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Caj yʌn ch'ic binob u purob ich u jach ts'urir sacerdote, u c'aba' Anás. Anás, raji' tu yʌcantaj Caifás. U ja'an Caifás, raji' u jach ts'urir sacerdote, ra' u yaxq'uinin caj quinsa'b Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mʌ' u jer Caifás, ra'iri' a tu ya'araj: ―Jach tsoy ca' quimic turiri' mac ti' tu cotoro'onex quire' cax mʌ' tu cotoro'onex quij quiminex ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro, quij Juan, caj binenob tu pach Jesús quire' u jach ts'urir u c'ʌ'oren, quij Juan. Tar binen ich u japnin tu re'a'an naj a yatocho' u jach ts'urir sacerdote tu yʌn Jesús xan. ");
INSERT INTO lacNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tar p'at Pedro tancab bʌytʌc tu' yʌn u mac u jor yatoch u jach ts'urir sacerdote. Quire' u c'ʌ'omʌnenob, rajen binen in wa'arej ti' a mac a cu cʌnantic u jor yatoch soc u yacsa' Pedro. Rajen cha'b yocar Pedro tu japnin yatoch tu re'a'an. ");
INSERT INTO lacNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Rajen a mac cu cʌnantic u jor naj, raji' xquic, caj u c'ataj ti' Pedro: ―Mʌ' wa tech u camsʌwiniquech a je' xiba'? Pedro caj u nuncaj tan ya'aric: ―Mʌ' teni' ―quij Pedro. ");
INSERT INTO lacNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ti' ch'ica'anob u c'urewob u jach ts'urir sacerdote yejer u policía u jach ts'urir sacerdote. Tu nuts'ob u q'uich quire' que'er. U c'ac' a tu t'ʌbajob raji' u chuquir. Tu cu q'uichob ti' ch'ica'an Pedro xan, tan u q'uich xan yejerob. ");
INSERT INTO lacNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","U jach ts'urir sacerdote caj u yʌnxchun u c'atic ti' Jesús: ―Mun yʌn a camsʌwinic tech? Ba' ta camsaj ti'ob xan? ");
INSERT INTO lacNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús caj u ya'araj: ―Ten ―quij Jesús―, mʌ' jin mucraj ich tu cotor mac caj in camsaj ti'ob ich ʌcʌtan tu cotor mac. Rajra' quin camsicob ich carem naj tu cu naj c'ujinticob C'uj tu cu much'quinticob u bʌj u winiquirob judío. Baxuc ich chan naj tu cu naj c'ujinticob C'uj u winiquirob judío, rajra' tin camsajob. Mʌ' jin muc u camsaji'. ");
INSERT INTO lacNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Biquinin ca c'atic ten? ―quij Jesús―. C'atej a wu'yej ti'ob a mac tu yubob in camsicob. Robob yerob a ba' caj in wa'araj ti'ob. ");
INSERT INTO lacNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús caj ts'oc u ya'aric aro', ti' yʌn turiri' policía a cu beyaj ich carem naj caj u tac' jʌtstaj Jesús, caj ya'araj ti' Jesús: ―Biquinin ca nunquic baxuco' ti' u jach ts'urir sacerdote? ");
INSERT INTO lacNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús caj u nuncaj ti' tan ya'aric: ―Wa c'as tin wa'araj, arej ten. Tu' yʌn c'as tin wa'araj? Quire' mʌ' c'as tin wa'araj. Biquinin ca tac' jʌtstiquen? ");
INSERT INTO lacNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anás tu tuchi'taj Jesús ich Caifás toc c'ʌxa'an. Raji' u jach ts'urir sacerdote a tan tu yocar u ts'urir sacerdote. ");
INSERT INTO lacNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ti' toy yʌn Pedro, ti' ch'ica'an q'uich. A mac yet q'uich caj u c'ataj ti': ―Mʌ' wa tech u camsʌwiniquech a je' xiba'? Pedro caj u ca' ma'quintaj: ―Mʌ' teni' ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ti' yʌn u c'urew u jach ts'urir sacerdote. Raji' u bʌjob a mac ch'ac u xiquin ten Pedro. Caj u c'ataj ti': ―Mʌ' wa tin wirech yejer a ra xibo' ich u chan corir u pʌc'ar Olivo? ");
INSERT INTO lacNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro caj u ca' ma'quintaj: ―Mʌ' ten ta wirajeni'. Sasame' caj c'aynʌj cax. ");
INSERT INTO lacNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Caj joc'sa'b Jesús ich Caifás caj bin purbirob ich u palacio gobernador soc ca' to'cac u jo'r. U c'aba' u palacio gobernador pretorio, u cuchir tu cu naj ta'quic u jo'r mac. Chen tabar u sastar. U jach ts'urir sacerdote yejer u rac'ob mʌ' ju yocarob ich palacio. Mʌ' ja wirej, ca' bin c'uchuc tu q'uinin pascua mʌ' u xac'ticob u bʌj yejer a mʌ' u winiquirob judío. Mʌ' toy u jantob yoch u q'uinin pascua. Wa cu yocarobe' mʌ' u cha'bʌr u janticob quire' baxuc u winiquirob judío nanij cu beticob. ");
INSERT INTO lacNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Rajen Pilato caj joc' tu' yʌnob, caj u c'ataj ti'ob: ―Ba' si'pir yʌn ti' quir a tar a puric tenex? ");
INSERT INTO lacNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Caj u nuncajob tan ya'aricob: ―Wa mʌna' u si'pir uch mʌ' jin tarob in c'ubicob tech. ");
INSERT INTO lacNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato caj u ya'araj ti'ob: ―Toc ch'a'ej techex a wʌc'ʌs bʌjiri'e'. Ta'quej u jo'r an ten bic ts'iba'an ich a t'ʌn techex. U jach ts'urir sacerdote caj u nuncaj ti': ―U t'ʌn u winiquir romano cu ya'aric mʌ' c'ucha'an in worob in quinsicob mac quire' ra' a beyaj tech. ");
INSERT INTO lacNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Baxuc cu bin u tar ti' Jesús an ten bic caj u ya'araj uch. Cu bin quinsbir ich cruz ten u winiquirob romano. ");
INSERT INTO lacNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Rajen Pilato caj ca' oquij tu cuchir tu nanij u ta'quic u jo'r mac. Pilato caj u ya'araj ti' Jesús: ―In c'at in wu'yej wa tech u reyech u winiquirob judío? ");
INSERT INTO lacNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús caj u ya'araj: ―Baxuc wa ca tucric tech wa yʌn mac tu ya'araj tech ti' ten? ");
INSERT INTO lacNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato caj u nuncaj, tan ya'aric: ―Bic in wetic aro' mʌ' u winiquir judíojen. A wet winiquirob judío yejer u jach ts'urirob sacerdote a mac tu c'ubech ti' ten. Ba' ta betaj tech ti'ob? ");
INSERT INTO lacNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús caj u nuncaj ti' tan ya'aric: ―A teno' mʌ' in reyintic a tera' ich yoc'ocab. Wa tin reyintic a tera', in camsʌwinicob uch je' u yamtiquenob soc mʌ' u chuquiquenob uch u policía a cu beyajob ich carem naj yejer soldado. Rajen uch mʌ' jin tar ʌcʌtan tech uch soc a ta'quicob in jo'r. ");
INSERT INTO lacNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato caj u ya'araj ti'ob: ―Jaj a techo' ca wa'aric reyech ―quij. Jesús caj u nuncaj ti': ―A teno' reyen, rajen taren ich yoc'ocab caj u rochen in nʌ' soc in tsec'tic u t'ʌn C'uj a ba' jach taj. Tu cotor mac a ju c'at u cʌxtic a ba' jach taj cu yubic in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato caj u ya'araj: ―Bic yerob mac ba'quiri' taj? Pilato caj ts'oc u ya'aric aro' caj wʌc'ʌs joc' tu' yʌn u jach ts'urirob sacerdote. Caj u ya'araj ti'ob: ―Mʌ' jin wiraj wa yʌn u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Quire' techex nanij quin cha'ic a teno' a mac mʌca'an cu c'uchur tu q'uinin pascua. A c'atex wa jin cha'ic a reyex techex u winiquirex judío? ");
INSERT INTO lacNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tu cotorob caj c'am awʌt'nʌjob tan ya'aricob: ―Mʌ' a cha'ic aro', cha'ej Barrabás. A Barrabáso' raji' cu ya'cric ba'. ");
INSERT INTO lacNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato caj ya'araj u jats'ʌr Jesús. Rajen u soldado Pilato caj u ch'ajob Jesús caj u jʌts'ajob u pach Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A soldadojo' caj u jit'ajob q'ui'ix caj u tʌcʌjob caj u p'o'quintaj Jesús. Caj u tʌcob u buquintej Jesús u c'ʌrʌb noc'. Raji' u noc' chʌc irej cu buquintic a reyo'. ");
INSERT INTO lacNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Caj u tus t'ʌnajob irej wa rey tan ya'aricob: ―Ca' cuxraquech ya'ab u q'uinin u reyech u winiquirob judío ―baxuc nanij cu t'anic jach rey. Rajra' tan u tac' jʌts'ticob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato caj ca' joq'uij ich tancab tu' yʌnob u winiquirob judío caj u ya'araj ti'ob: ―Irex, tin joc'saj a je' xiba' ʌcʌtan techex soc a werex mʌna' turiri' u si'pir tin wiraj ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Caj joc'sab Jesús ʌcʌtan ti'ob. Jesús ti' toy u p'o'quinmʌn q'ui'ix. Baxuc u noc' ti' toy u buquinmʌn a chʌc noc'o'. Pilato caj u ya'araj ti' u winiquirob judío: ―Ire'ex a je' xiba'. ");
INSERT INTO lacNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Rajen caj yirob Jesús u jach ts'urirob sacerdote yejer u policía a cu beyajob ich carem naj tu cu naj c'ujinticob u winiquirob judío. Caj u yʌnxchun u c'am aricob ti' Pilato: ―Bʌjej ich cruz, bʌjej ich cruz. Rajen Pilato caj ya'araj ti'ob: ―Ch'a'ex ca' a bʌjex ich cruz a bʌjiri'ex quire' a teno' mʌ' in wiric wa yʌn u si'pir. ");
INSERT INTO lacNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","U winiquirob judío caj u nuncob ti' tan ya'aric: ―A tenob yʌn in t'ʌnob. Aj in t'ʌnob cu ya'aric ca' in quinsob wa cu tucric u bʌjiri' raji' u parar C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato caj u toc ch'aj sajquir uch a ba' cu bin tar ti' Jesús. Caj ts'oc u yubic a ba' caj u ya'arob ti', tu jach ch'aj sajaquir Pilato quire' yerob u parar C'uj, u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilato caj ca' oquij ich palacio yejer Jesús caj u c'ataj ti' Jesús: ―Tub a tar? ―quij. Jesús mʌ' c'ʌs ba' tu nuncaj ti'. ");
INSERT INTO lacNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Rajen Pilato caj u ya'araj ti' Jesús: ―A techo' mʌ' ja nunquic ten quire' a teno' a ts'urirenex. Wa jin c'at in cha'iquech ca' xiquech. A teno' c'ucha'an in wor in wa'aric ca' in quinsech ich cruz xan. ");
INSERT INTO lacNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús caj u ya'araj ti': ―Mʌ' c'ucha'an a wor a betic baxuc aro' ti' ten wa C'uj mʌ' ju c'at, a ti' yʌn ich ca'anano'. Rajen u jach ts'urirob sacerdote a mac tu c'ubajenob ti' tech, jach manan yʌn u si'pirob. ");
INSERT INTO lacNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Rajen Pilato u c'at u cha'ic Jesús ca' xic chen u winiquirob judío caj u c'am arob: ―Wa ca cha'ic u bin mʌ' tan a qui' beyaj ti' a rey César quire' tu cotor mac a ju c'at yocar rey cu p'actic u rey César. ");
INSERT INTO lacNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato caj ts'oc yubic ya'aric a pimo' caj u ya'araj ti' u soldado ca' u yacsej Jesús tu re'a'an naj. Ich chumuc tu' re'a'an naj ti' yʌn u cutan gobernador raji' beta'b ti' tunich. Raji' quir u cutar soc ya'aric wa cu cha'bʌr wa yʌn u quinsa'r wa ber cu ts'ocar u to'car u jo'r. U cutan gobernador pʌcha'an u c'aba' ich u t'ʌn hebreo Gabata. Rajen Pilato caj oc u cutar ti' taro'. ");
INSERT INTO lacNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Caj c'uchij c'ac'chunq'uin caj oc Pilato quir u cutar ich u cutan gobernador. Raji' u jach q'uinin pascua. Caj curʌj Pilato caj ya'araj ti' u winiquirob judío: ―Iriquex a je' reyexa'. ");
INSERT INTO lacNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","U winiquirob judío caj u c'am arajob, tan ya'aricob: ―Sinej ich cruz ca' quimic. Sinej ich cruz ca' quimic. Chen Pilato caj ya'araj ti'ob: ―Cax wa ja reyex quin sinic ich cruz ca' quimic? U jach ts'urirob sacerdote caj u ya'arob: ―Raji' mʌ' ic reyex aro'. Chen raji' ic reyex César. ");
INSERT INTO lacNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Rajen Pilato caj u quibaj a ba' u c'atob caj u c'ubaj ti'ob u soldado ca' u bʌjej ich cruz. Rajen a soldadojo' caj u pʌyob Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Rajen u soldado caj u ts'ʌraj u pach Jesús, rajen tu c'ochaj u cruz. Caj bin tu cuchir a cu ya'aric u baquer u jo'r mac. Ich u t'ʌn hebreo pʌcha'an u c'aba' Gólgota. ");
INSERT INTO lacNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ti' tu bʌjob ich cruz, yet bajac ca'tur mac, u tiri' bʌja'an xan tu ts'ic, u tiri' bʌja'an xan tu no'oj Jesús. Chumuc yʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato caj u ts'ibtaj ich yoc'o che' jun xot' caj u ts'ibta, baxuc tan ya'aric: “A je' Jesús a cu tar ich u cajar Nazaret, raji' u rey u winiquirob judío.” Raji' bʌja'an ich yoc'or u jo'r Jesús ich u cruz. ");
INSERT INTO lacNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ya'ab u winiquirob judío cu xaquicob tu' ts'iba'an quire' ti' bajij Jesús ich bʌytʌc tu cu yocarob ich u cajar Jerusalén. A ba' caj u ts'ibtaj Pilato ich u t'ʌn hebreo yejer ich u t'ʌn griego yejer ich u t'ʌn latino. ");
INSERT INTO lacNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","U jach ts'urirob sacerdote caj ts'oc yiricob a ba' ts'iba'an ich cruz Jesús caj bin ya'aricob ti' Pilato: ―C'axej a ba' caj a ts'ibtaj soc mʌ' ya'aric: “Raji' u rey u winiquirob judío.” Chen ca' a ts'ibtej: “Raji' cu ya'aric u reyen u winiquirob judío.” ");
INSERT INTO lacNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato caj u nuncaj ti'ob tan ya'aric: ―An bic caj in ts'ibtaj toc tsire'ej, a teno', mʌ' in c'axic ―quij Pilato. ");
INSERT INTO lacNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","A mac a tu bʌjob Jesús cuatrojob soldado. Caj ts'oc u bʌjicob Jesús tu ch'ajob u noc'. Jujuntur tu ch'aj turiri', c'ʌs p'atij turiri'. Raji' u ca' yarir u noc' Jesús quire' toc coch caj sʌcta'b u tan u noq'uir, mʌna' u ber u chuyur. ");
INSERT INTO lacNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rajen u soldado cu pacran aricob: ―Cax mʌ' ic jʌtic. Ca' ij cʌrʌc'tej chan tunich, ca' ij quirej mac cu bin ch'ic u ca' yarir u noc'. A baxuco' caj u nup'saj tu' ts'iba'an u t'ʌn C'uj uch caj u ya'araj: “Mʌ' u bin u jʌticob u ca' yarir in noc'. Cu chen binob yʌrʌc'ticob chan tunich soc yiricob mac cu bin u toc ch'ic in noc'”, quij. Baxuc ya'aric yʌjtseq'uir u t'ʌn C'uj uch. Rajen baxuc caj u betob u winiquirob soldado. ");
INSERT INTO lacNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ti' ch'ica'an u nʌ' Jesús tu' bʌja'an ich cruz Jesús. Ti' yʌn u bʌj u nʌ' Jesús u c'aba' María xan. U c'aba' u mam Cleofas. Baxuc ti' yʌn María Magdalena. ");
INSERT INTO lacNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ti' yʌn Juan bʌytʌc tu' bʌja'an Jesús, a mac jach yajbir ten Jesús. Ti' yʌn tu' yʌn u nʌ' Jesús. Rajen Jesús caj yiraj ti' yʌnob u nʌ' yejer Juan, caj ya'araj Jesús ti' u nʌ': ―Nʌ', quen, raji' Juan, ch'a'ej tech soc irej a parar. ");
INSERT INTO lacNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jesús caj u ya'araj ti' Juan: ―Raji' in nʌ', ch'a'ej tech soc irej a nʌ' tech. Rajen Juan tu yacsaj tu yatoch soc ti' cu cʌjtar ich yatoch Juan. ");
INSERT INTO lacNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Caj ts'oc u toc aric ti' Juan aro', Jesús yer yʌn u rʌc nup'sic a ba' ts'iba'an ich u t'ʌn C'uj uch, rajen caj u ya'araj: ―Uc'chʌjen ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ti' yʌn ich ruch chup u c'ab uva, pʌj. Rajen caj u ts'ʌmaj u noq'uir ich u c'ab uva a pʌjo' quir u ts'u'ts'ic ya'arir a noc'o' irej tʌmʌn. Caj u tʌcaj ich jʌrʌr u c'aba' hisopo caj u tich'itej u chi' Jesús ca' u ts'u'ts'aj. ");
INSERT INTO lacNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús caj u ts'u'ts'aj u c'ab uva a pʌjo' caj ts'oc aro' caj u ya'araj: ―Tin ts'ocsaj in beyaj ―quij Jesús. Caj u chinquintaj u jo'r quire' quimij. ");
INSERT INTO lacNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Quire' a samano' u q'uinin quir u jesicob u bʌj u winiquirob judío, rajen u ts'urirob sacerdote. Mʌ' u c'atob yiricob u p'atʌrob u baquer ich cruz. Mʌ' ja wirej, ti' u winiquirob judío jach no'j yiricob u q'uinin saman tu cu bin u jesicob u bʌj. Rajen caj u c'atajob ti' Pilato soc u wʌticob u baquerob a mac a bʌja'anob ich cruz xan, u chac bʌq'uerob soc seb cu quiminob soc c'ucha'an yorob u yemsicob u baquer ich cruz. ");
INSERT INTO lacNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Rajen caj c'uchob soldado caj u rʌc wʌtob u chac bʌq'uer a turiri' u yet bʌja'an winico'. Caj c'uchob tu' yʌn u jer yet bʌja'an winiquir caj u wʌtob u chac bʌq'uer. ");
INSERT INTO lacNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Caj nats' tu' yʌn Jesús caj yirob quimij, rajen mʌ' tu wʌtob u chac bʌq'uer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Chen turiri' soldado tu ramaj u ch'ara'tir Jesús yejer ransa ca'ch. Sasame' caj joc' u q'uiq'uer yet jocac u ya'arir u bʌq'uer. ");
INSERT INTO lacNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A teno', quij Juan, caj in wiraj bic caj quimij Jesús. Rajen taj a ba' quin wa'aric soc baxuc a werex xan. ");
INSERT INTO lacNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A ba' u ber ti' Jesús ich cruz ten soldado, ra' quir u nup'sic a ba' ts'iba'an ich u t'ʌn C'uj uch, tu cu ya'aric: “Mʌ' ju bin wʌtbir u baquer, mʌ' turiri'”, baxuc caj ya'araj u t'ʌn C'uj uch. ");
INSERT INTO lacNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Baxuc ti' ts'iba'an u jer ich u t'ʌn C'uj uch, tan ya'aric: “Robob cu bin u yiricob ti' tu' rom in ch'ʌra'tir”, baxuc ts'iba'an ich u t'ʌn C'uj xan. ");
INSERT INTO lacNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pachir José a cu tar ich u cajar Arimatea, raji' tu muc u acsaj tu yor ti' Jesús quire' cu sʌjtic u jach ts'urirob u winiquirob judío, mʌ' ju ya'araj ti' u rac'ob wa tu yacsaj tu yor. Caj yiraj quimij Jesús caj bin ich Pilato quir u c'atic wa tsoy u ch'ic u baquer Jesús quir u but'ic ich japnin tunich. Pilato caj u ya'araj ti' ca' yens u baquer ich cruz quir u ch'ic u but' u baquer ich japnin tunich. Caj bin u ch'ic. ");
INSERT INTO lacNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yet binac Nicodemo, raji' a mac bin tsicbar yejer Jesús oq'uin uch. Bin u yamtej José. Nicodemo tu mʌnaj u ts'ac mirra, xaca'an yejer u ts'ac áloes quir u jic'tic tu bʌq'uer Jesús, treinta kilos yʌn. ");
INSERT INTO lacNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Robob caj u cuchob u baquer Jesús, José yejer Nicodemo. Caj u sʌsʌjc'ʌstajob u baquer Jesús yejer sʌc noc'. Tu cu sʌsʌjc'ʌsticob u baquer Jesús, ti' cu puricob u ts'ac mirra yejer u ts'ac áloes soc mʌ' netu' u boc quire' baxuc nanij cu beticob u winiquirob judío tu cu bin u but'ic u baquer u rac'ob ich japnin tunich. ");
INSERT INTO lacNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tu' tu sinob Jesús ich cruz uch bʌytʌc ti' u chan corir u pʌc'ar u che'er Olivos. Tu' yʌn u che'er Olivos ti' yʌn u mucnaj japnin tunich a beta'b ten mac. Mʌna' mac u but'mʌn u baquer quire' ric'ben. ");
INSERT INTO lacNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tabar u q'uinin quir u jerar u winiquirob judío quire' tabar u bin q'uin. Quire' bʌytʌc ti' yʌn u japnin tunich, rajen c'ucha'an yorob u but'icob u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ra' u q'uinin cu yʌnxchun semana ti' toy ac'bir caj c'uchij María Magdalena tu' but' u baquer Jesús. Caj u yiraj toc bʌc'ʌsa'an u tunichirir u mac u jor a tu tu but'aj u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","María Magdalena caj u c'ʌnaj u yacab caj bin tu' yʌn Juan u yajbir ten Jesús yejer Simón Pedro. Caj ya'araj: ―Tu cuchob u baquer ic Jaj Ts'urirex, mʌ' ij quer tu tu purob u baqueri'. ");
INSERT INTO lacNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Rajen Pedro yejer Juan caj joc'ob caj binob tu' but'a'an u baquer Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Quet caj u c'ʌnob yacab. Chen Juan jach chich yacab raji' yʌn bat'an c'uchij tu but' u baquer Jesús. Chen Pedro sen yacab, pachir caj c'uchij. ");
INSERT INTO lacNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A Juano' caj u tac ch'ena'btaj tu japnin caj u yiraj u sʌc noc' tu top u baquer Jesús uch. Ti' jana'an ich ru'um. Juan mʌ' oc tu japnin tunich. ");
INSERT INTO lacNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Caj c'uchij Simón Pedro seb caj oquij tu japnin tu but' u baquer Jesús uch. Raji' caj u yiraj ti' jana'an u sʌc noq'uir tu top u baquer Jesús uch. U beri' jenric. ");
INSERT INTO lacNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Baxuc tu yiraj u panyujir tu top u wich Jesús uch. Toc ca' ts'a'an, u tiri' jana'an. ");
INSERT INTO lacNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pachir caj oquij Juan a yʌn c'uch sasame' tu but' u baquer Jesús. Caj u yira ti' toc jana'an u noq'uir caj u quibaj riq'uij Jesús tu' quimen an ten bic caj u ya'araj Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","A ucho' mʌ' ju najtob tu ts'iba'an u t'ʌn C'uj uch wa yʌn u riq'uir Jesús tu quimirir. Ra'iri' u q'uinin caj u najtajob. ");
INSERT INTO lacNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Rajen Pedro yejer Juan yej u yet camsʌwinicob caj wʌc'ʌs sutnʌjob tu yatochob. ");
INSERT INTO lacNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María caj ca' urij tu but' u baquer Jesús uch. Caj bin Pedro yejer Juan ti' p'at María. Oc'ar u ca'. Ti' toy cu yoc'ar caj u tac ch'enaptaj yirej u japnin tu but' u baquer Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","María caj yiraj yʌjmasirob u t'ʌn C'uj ca'tur, jach sʌc u noc'ob ti' cura'anob tu chaquinta'b u baquer Jesús uch. Turiri' tu jo'rir, turiri' tu yoquir tu chaquinta'b u baquer Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Caj c'ata'b ti' ten yʌjmasirob u t'ʌn C'uj: ―Xquic ―quen―, biquinin tan a woc'ar? Raji' caj u nuncaj tan ya'aric: ―Quire' tu cuchob u baquer in Jaj Ts'urir, mʌ' in wer tuj tu purob u baquer in Jaj Ts'urir. ");
INSERT INTO lacNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","María caj ts'oc ya'aric aro' caj u sut u bʌj caj u yiraj ti' yʌn Jesús chen mʌ' yer wa Jesúsi'. ");
INSERT INTO lacNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús caj ya'araj ti' María: ―Xquic ―quij―, biquinin tan a woc'ar? Mac tan a cʌxtiqui'? María yer raji' a cu cʌnantic u chan corir tub u pʌc'mʌn u che'er Olivo. Rajen caj u ya'araj ti': ―Tech wa ta ch'ajaj u baquer in Jaj Ts'urir, arej ten tub a puraj ca' xiquen in ch'a'ej. ");
INSERT INTO lacNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús caj u nuncaj ti': ―María ―quij. Rajen María caj u sut u bʌj caj u ya'araj ti' ich u t'ʌn hebreo: ―Raboni ―quij ya'araj. Raji' u c'at ya'aric: A wʌjcamsʌyʌjiren, quij Juan. ");
INSERT INTO lacNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús caj u ya'araj ti': ―Mʌ' a yʌn su'siquen quire' mʌ' xiquen tu' yʌn in Tet ich ca'anan. Ca' xiquech a wa'arej ti'ob in camsʌwinicob a irej in wits'inob. Arej ti'ob: tar quin bin ich in Tet. Baxuc tech, raji' a Tet xan. Ti' quin bin ich C'uj baxuc tech, raji' a C'uj xan. Baxuc yʌn a wac ti' in camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Rajen María Magdalena caj bin ich u camsʌwinicob Jesús caj u ya'araj: ―A teno' ―quij―, tin wiraj ic Jaj Ts'urirex. Caj u ya'araj ti'ob tu cotor a ba' ara'b ti' ten Jaj Ts'ur. ");
INSERT INTO lacNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ra'iri' u q'uinin, oq'uin ti' toy u q'uinin cu yʌnxchun semana. U camsʌwinicob ti' u much'quinmʌnob u bʌj ich yatoch. U qui' mʌcmʌnob u jor quire' cu sʌjticob u jach ts'urirob u winiquirob judío. Seb caj yubob ti' c'uchij Jesús tu' yʌnob. Caj ch'icrʌj Jesús chumuc tu' yʌnob caj u rʌc t'ʌnaj tan ya'aric: ―Taren in qui'quint a worex ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Caj ts'oc ya'aric aro' ti'ob caj yes u c'ʌb tuj bajij yejer u ch'ʌ'ra'tir tuj rom. Rajen yerob ic Jaj Ts'urirex. Rajen jach qui' yorob. ");
INSERT INTO lacNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús tu ca' araj ti'ob: ―Qui'quintex a worex. An ten bic in Tet caj u tuchi'tajen ich yoc'ocab. Baxuc techex quin tuchi'tiquechex quir a beyajex ti' ten. ");
INSERT INTO lacNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Caj ts'oc ya'aric aro' caj u yustaj u camsʌwinicob caj ya'araj ti'ob: ―Baje'rer a wet binaquex u Taj'or u Pixam C'uj. ");
INSERT INTO lacNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","A mac cu c'axicob yor c'ucha'an a worex a wa'ariquex ti'ob: “Jawsa'b u si'pirob.” Chen a mac mʌ' u c'axicob yor c'ucha'an a wor a wa'ariquex ti'ob: “Mʌ' jawsa'an u si'pirobi'.” ");
INSERT INTO lacNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás mʌ' ti' yʌn ca'chi' yejer u yet camsʌwinicob caj c'uchij Jesús. Raji' turiri' ich a doce u camsʌwinicob Jesús. Raji' a toc ca'tur caj rocha'b ten u nʌ' uch. ");
INSERT INTO lacNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Caj c'uchij Tomás. U yet camsʌwinicob caj u ya'arob: ―Tin wirob ic Jaj Ts'urirex. Chen Tomás caj u nuncaj tan ya'aric: ―Wa mʌ' in wiric u c'ʌb tu bajij yejer clavo. Wa mʌ' in jupic u yar in c'ʌb tu jorir clavo tuj bajij u c'ʌb, baxuc wa mʌ' in jupic in c'ʌb tuj rom u ch'ʌra'tir, mʌ' in quibic wa riq'uir Jesús ―quij Tomás. ");
INSERT INTO lacNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Caj c'uchij u jer semana u camsʌwinicob ti' cu much'quinticob u bʌj. A ray u q'uinino' ti' yʌn Tomás yejerob ich yatoch. Qui' mʌcmʌnob u jor. Seb caj yubob ti' yʌn Jesús yejerob caj ch'irʌj Jesús chumuc tu' yʌnob. Caj ya'araj: ―Taren in qui'quintic a worex ―quij Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jesús caj ya'araj ti' Tomás: ―Cojen jupej yar a c'ʌb tuj bʌja'an in c'ʌb iric in c'ʌb. Tich'ej yar a c'ʌb ca' a jupej tuj rom in ch'ʌra'tir. Mʌ' a tucric wa mʌ' taji' quire' riq'uen tuj quimen. Quibej riq'uen ich in quimirir. ");
INSERT INTO lacNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Rajen Tomás caj u nuncaj caj ya'araj: ―In Jaj Ts'urirech ―quij―, in C'ujech xan ―quij Tomás. ");
INSERT INTO lacNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús caj ya'araj ti': ―Tomás ―quij―, a techo' mʌ' ja quibaj hasta caj a wiraj riq'uen ti' in quimirir. Chen jach manan qui' yorob a mac a cu quibicob riq'uen ti' in quimirir cax mʌ' ju yirajenob. ");
INSERT INTO lacNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ti' toy ya'ab carem beyajob tu yesaj Jesús ti' u camsʌwinicob Jesús. Chen mʌ' ts'ibta'b ich a je' ju'una'. ");
INSERT INTO lacNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Chen caj u ts'ibtaj a je' t'ʌna' soc a quibiquex a Jesúso', raji' Cristo a teta'b ten C'uj quir u taquico'onex, u parar C'uj. Wa baxuc ca quibico' toc yʌn a cuxtar munt q'uin. ");
INSERT INTO lacNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jesús caj u ca' esa'r u bʌj ti' u camsʌwinicob. Caj u yesaj u bʌj ich chi' c'ac'nab u c'aba' Tiberias. Baxuc a jera' caj u yesaj u bʌj ti' u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ti' tu much'quintajob u bʌj Simón Pedro yejer Tomás a toc ca'tur caj rocha'b ten u nʌ'. Ti' yʌn Natanael ti' u tar ich u cajar Cana ich u ru'umin Galilea. Ti' yʌn xan ca'turob u camsʌwinicob Jesús raji' u tetob Zebedeo. Ti' yʌn xan u jer ca'turob u camsʌwinicob. ");
INSERT INTO lacNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro caj u ya'araj ti' u yet camsʌwinicob: ―Bin in ca' chuc cʌy yejer chim. Robob caj ya'arob: ―Baxuc a tenob tar in ca'ob yejerech. Caj rʌc ocob ich chem caj binob u chuquejob cʌy. U burur ac'bir tu puricob u chimin, mʌ' ju chucobi'. ");
INSERT INTO lacNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Caj sasij ti' ch'ica'an Jesús ich chi' c'ac'nab chen u camsʌwinicob mʌ' yerob wa raji' Jesúsi'. ");
INSERT INTO lacNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús caj u c'ataj ti'ob: ―Chichanechex, mʌ' wa ta chuquex u cʌyir? Caj u nuncajob: ―Mʌna' ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús caj ya'araj ti'ob: ―Purej u chimin tu no'oj chem. Je' a chuquiquex a cʌyo'. Baxuc caj u betajob caj u purajob u chimin caj u jarajob u chimin jach chup u cʌyir. Rajen mʌ' ju c'uchur u yorob u jaricob ich c'ac'nab. ");
INSERT INTO lacNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","A Juano', raji' a yajbir ten Jesús. Raji' u camsʌwinic xan, caj ya'araj ti' Pedro: ―Raji' ic Jaj Ts'urirex. Simón Pedro caj u yubaj ya'aric, “Raji' ic Jaj Ts'urirex”, caj u buquintaj u noc' quire' chʌcpiten ca'ch caj u puraj u bʌj ich ja' quir u c'uchur ich chi' c'ac'nab tu' yʌn Jesús. ");
INSERT INTO lacNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Caj tarob u camsʌwinicob yejer chem, tan u payticob u chimin cʌy quire' jach chup u cʌyir. Mʌ' nach yʌn ti' u chi'c'ac'nab chen cien metros. ");
INSERT INTO lacNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Caj joc'ob ich chem caj c'uchob ich chi'c'ac'nab. Caj yirob nuts'a'an c'ac'. Ti' yʌn u chuquir, ti' yʌn cʌy, tan u c'ac'tic yoc'or yejer waj. ");
INSERT INTO lacNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús caj u ya'araj ti'ob: ―Ch'ayex cʌy jach ya'ab a tan ta chuquiquex. ");
INSERT INTO lacNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Rajen binij Simón Pedro ich chem. Caj u jitaj u chimin chup yejer cʌy. Jach carem u cʌyir caj u xacaj caj u yiraj ciento cincuenta y tres u cʌyir. Cax chup u chimin mʌ' ju jatʌr. ");
INSERT INTO lacNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Rajen caj u ya'araj ti'ob: ―Cojenex ta jananex ―quij. Mʌna' u camsʌwinicob caj u ya'araj: “Maquech”, quire' baje'rer yerob raji' u Jaj Ts'urirob. ");
INSERT INTO lacNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús caj u chucaj waj caj u ts'aj ti'ob u camsʌwinicob. Baxuc caj u ts'aj ti'ob yoch cʌy xan. Caj u rʌc jantajob. ");
INSERT INTO lacNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A jera' mʌna' u nup u tenin tu yesa u bʌj ti'ob u camsʌwinicob a caj ts'oc u riq'uir ti' u quimirir. ");
INSERT INTO lacNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Caj ts'oc u janʌnob Jesús caj u c'ata ti' Simón Pedro: ―Simón, u pararech Jonás. A nupob cu yajquintiquen, chen tech wa jach manan ca yajquintiquen? Pedro caj u nuncaj: ―Tech, Jaj Ts'urir, a wer quin yajquintiquech. Jesús caj u ya'araj ti': ―Cʌnen, jansej ti' ten tu cotor mac a tu yacsob tu yorob ti' ten soc cu bin u chichquinticob tu pixamob an ten bic yʌjcʌnʌnyʌjir tʌmʌn yuc cu jansic u chan ar tʌmʌn yuc. ");
INSERT INTO lacNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús caj u ca' c'ataj ti': ―Simón, u pararech Jonás, jach qui' wa ca yajquintiquen? Pedro caj u nuncaj: ―Tech, Jaj Ts'urir, a wer in qui' yajquintiquech. Jesús caj ya'araj ti': ―Cʌnen, jansej ti' ten tu cotor mac a tu yacsob tu yorob ti' ten soc cu bin u chichquinticob tu pixamob an ten bic yʌjcʌnʌnyʌjir tʌmʌn yuc cu jansic u chan ar tʌmʌn yuc. ");
INSERT INTO lacNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mʌna' u nup caj c'ata'b ten Jesús ti': ―Simón, u pararech Jonás, ca jach qui' wa ca yajquintiquen? Pedro caj tucurnʌjij quire' tu yubaj mʌna' u nup u tenin caj c'ata'b ti': “Ca yajquintiquen wa?” Caj u ya'araj: ―Tech, Jaj Ts'urir, tu cotor a wer. A wer quin yajquintiquech. Jesús caj ya'araj ti': ―Cʌnen, jansej ti' ten tu cotor mac a tu yacsob tu yor ti' ten soc cu bin u chichquinticob tu pixamob an ten bic yʌjcʌnʌnyʌjir tʌmʌn yuc cu jansic u chan ar tʌmʌn yuc. ");
INSERT INTO lacNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jesús caj ya'araj: ―Taj a ba' quin wac tech. Chen chichanech uch ta qui' buquintaj a noc' caj bin tub a c'at. Ca' bin ch'ijiquech cu bin u c'ʌxicob a c'ʌb yejer a winquirir ich che' quir u quinsiquech. ");
INSERT INTO lacNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Caj u ya'araj ti' aro' quir u camsic bic tabar cu bin quimin soc mac cu bin u yiricob jach carem a C'ujo'. Jesús caj ya'araj ti': ―Cojen tin pach ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro caj u sut u bʌj caj u yiraj tan u tar Juan tu pach a mac yajbir ten Jesús, ra'iri' a ti' yʌn ich Jesús caj u jantob yoch u q'uinin pascua, caj u c'ataj uch ti': “Jaj Ts'urir, quij, mac cu bin u c'ubiquech?” quij. ");
INSERT INTO lacNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro caj u yiraj Juan caj u c'ataj ti' Jesús: ―Jaj Ts'urir ―quij―, ba' cu bin tar ti' a ray in nupo'? ");
INSERT INTO lacNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús caj u nuncaj ti', tan ya'aric: ―Wa jin c'at ca' p'atac Juan hasta quin ca' ur, mʌ' ba'wir ca tucric ti'. Tech yʌn a tar tin pach ―quij. ");
INSERT INTO lacNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Rajen caj bin u sosoc arej ich mac a tu yacsob tu yorob, tan ya'aric: ―A Juano' mʌ' ju bin quimin ―quij. Chen Jesús mʌ' ju ya'araj: “Mʌ' ju bin quimin.” Tu chen araj: “Wa jin c'at ca' p'atac Juan hasta quin wu'ur mʌ' ba'wir ca tucric ti'.” ");
INSERT INTO lacNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tu cotor a ba' ts'iba'an a tera', raji' caj u yiraj Juan, baxuc caj u yubaj a raji' u camsʌwinic Jesús. Rajen ij querex taj a ba' cu ya'aric. ");
INSERT INTO lacNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ti' toy yʌn ya'ab ba' caj u betaj Jesús. Wa toc ts'iba'an jujuntur ich u ju'unin jach p'ecʌch ya'ab u ju'unin cu bin ts'ibta'bir. Chen a ts'iba'an a tera' ti'ti' soc ij querex bic tabar ic taquic ic bʌjex.");
INSERT INTO lacNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Uche' tin yʌn ts'ibtaj u ju'unin tech Teófilo, a mac in jach yaje'. Caj in wa'araj tech tu cotor a ba' caj u betaj Jesúse'. Bayiri' xan, tu cotor a ba' caj u camsaj a ra' u q'uinin tu yʌnxchun u beyaj Jesúse'. ");
INSERT INTO lacNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Tin toc ts'ibtaj tech Teófilo a ba' caj u betaj Jesús hasta caj bin ca'anan. Chen mʌ' toy xic Jesús ca'anani', caj u tetaj u camsʌwinicob. Mʌ' ja wirej, ts'a'b u t'ʌnin ti'ob ten u Taj'or u Pixam C'uj soc yerob a ba' cu bin u beticob. ");
INSERT INTO lacNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Caj ts'oc u muc'yaj Jesús, caj riq'uij caj u yesaj u bʌj ti' u camsʌwinicob cuxa'an. Jach jaj caj u yesaj u bʌj ti'ob. Ya'ab u beyaj caj u yesaj ti'ob soc yerob cuxa'an. Cuarenta q'uin ti' yʌn yejer u camsʌwinicob cu tsicbar ti'ob bic cu bin u reyinticob C'uj. ");
INSERT INTO lacNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ti' toy yʌn Jesús yejer u camsʌwinicob caj u ya'araj ti'ob: ―Mʌ' a yʌn p'ʌtiquex ich u cajar Jerusalén. Ti' a yʌn toc pajiquex a ba' tu toc araj in Tet C'uj u ts'ic techex ―quij―. Baxuc caj in wa'araj techex. ");
INSERT INTO lacNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mʌ' ja wirej, a Juano' caj u yacsaj ja' tu jo'r mac yejer ja'. Chen mʌ' ya'ab q'uin je' u tar ta wicnʌnex u Taj'or u Pixam C'uj. Raji' bin u ca' c'asiquex techex in t'ʌn. ");
INSERT INTO lacNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ti' u rʌc much'a'anob u camsʌwinicob ich Jesús barej caj c'ata'b ti' ten u camsʌwinicob: ―Ber u q'uinin cu bin u reyinticob u ru'umin u winiquirob israel? Baje'rer wa? ―quij. ");
INSERT INTO lacNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Caj u nuncaj ti'ob Jesús tan ya'aric ti'ob: ―Mʌ' ts'aja'an techex quir a wetiquex tu q'uinin u tar. Mʌ' chumuc yaxq'uin, wa ju q'uinin cu tar ja'. Chen C'uj u ricsmʌn ti', u bʌjiri' yer. ");
INSERT INTO lacNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Barej ca' bin tac u Taj'or u Pixam C'uj, je' a c'ʌmiquex u muc' ich a worex. Taj je' a bin a wa'ariquenex ich u cajar Jerusalén, cax ich u ru'umin Judea, cax ich u ru'umin Samaria hasta tu cu xur tu cotor u cajarob ich yoc'ocab. ");
INSERT INTO lacNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Caj ts'oc u ya'aric a jeroj ti'ob, jeroj ti' toy cu pʌcticob Jesús. Seb caj binij ca'anan. Robob caj u yirajob u bin ca'anan, jeroj caj tar u muyarir. Jeroj, mʌ' chʌca'an u bin Jesúsi'. ");
INSERT INTO lacNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Cu qui'qui' chanticob ca'anan u camsʌwinicob Jesús, caj tarob tu yʌnob ca'tur xib. Robob u buquimʌnob jach sʌc u noc'. ");
INSERT INTO lacNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tu ya'arajob ti' u camsʌwinicob Jesús: ―Mʌ' a yʌn pʌctiquex ca'anan, a techex u xibirechex u ru'umin Galilea. Je' u ca' tare' Jesús an bic caj a wirajex u bin ca'anan ―baxuc ara'b ti'ob ten a ca'tur xibo'. ");
INSERT INTO lacNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ti' u witsir u c'aba' Olivo, caj sutpʌjob ich u cajar Jerusalén. A ray witso', nʌts'a'an ti' u cajar Jerusalén, bay u nachir u bin mac u q'uinin tu cu jesicob u bʌj u winiquirob judío. Ca'tur kilómetro. ");
INSERT INTO lacNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Caj wʌc'ʌs sutnʌjob u camsʌwinicob ich u cajar Jerusalén. Ti' nacob ca'anan tu jun c'as naj tu jamach ocob. Rʌc ti' yʌnob Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartalomé, Mateo, Jacobo, ra' u parar Alfeo. Simón, a cu sayʌr tu pach cananistaje' yejer Judas u sucu'un Jacobo. ");
INSERT INTO lacNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tu cotor a jeroj quet yorob cu t'ʌnicob C'uj quet yejer a xquico'. Mʌ' ja wirej, ti' yʌn u nʌ' Jesús cu t'ʌnic C'uj xan. Ti' yʌn u jach its'inob Jesús xan. ");
INSERT INTO lacNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ra'iri' u q'uinin tu cu t'ʌnicob C'uj, caj riq'uij u ch'ictar Pedro ich chumuc tu yʌn a mac a yacsmʌnob tu yorob. Ti' yʌn ciento veinte a mac a yacsmʌnob tu yorobe'. Caj ya'araj Pedro ti'ob: ");
INSERT INTO lacNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―In wet acsa'orirex, yʌn u ts'ocsic a tu ts'iba'an u t'ʌn C'uj a tu ara'b ten u Taj'or u Pixam C'uj uch. Mʌ' ja wirej ―quij―, David ic nunquirex caj u ts'ibtaj ti' ixba' Judas uch, a ra' caj u c'ubaj Jesús ca' quinsac. ");
INSERT INTO lacNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mʌ' ja wirej, ber caj teta'b Judas ten Jesús, p'eri' ic beyajex yejer Judas. A Judaso' raji' ic nupex. ");
INSERT INTO lacNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Chen raji' Judas yejer u taq'uin a ju bo'orir tu tu c'ubaj Jesús caj u mʌnaj u ru'umin. Tiri' tu jich'aj u c'o'och, caj u quinsaj u bʌj. Caj rub Judas bʌja'an binquij u jo'r. Jeroj caj buj u nʌc', caj joc' u chocher, caj joc' u q'uiq'uer Judas. ");
INSERT INTO lacNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Rajen a mac a cʌja'an ich u cajar Jerusalén caj yubob bic caj u quinsaj u bʌj Judas, jeroj robob tu pʌchajob u c'aba' u ru'umin a tu mʌnaje', Acéldama, ra' u c'at ya'aric, u ru'umin tu joc' u q'uiq'uer Judas. ");
INSERT INTO lacNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mʌ' ja wirej ―quij Pedro―, toc ts'iba'an ich u ju'unin salmos tu cu ya'aric: “Mʌ' a cha'ic u cajʌr mac soc chen saj nʌj.” Tu ca' araj ich u jer ich u ju'unin salmos, tu cu ya'aric: “Arej u ch'aj u yet beyaj soc u jer quir u c'ʌnic beyaj”, baxuc caj ya'araj ich u t'ʌn C'uj a salmoso'. ");
INSERT INTO lacNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Rajen ―quij Pedro―, in wet acsa'orirex ca' ic tetex baje'rer a mac ij quet manex yejero'onex u burur q'uin ti' yʌno'onex yejer Jesús uch. ");
INSERT INTO lacNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Raji' ca' ic tetex a mac a caj u yiraj Juan tu yacsaj ja' tu jo'r mac hasta caj u yiraj tu wich u bin Jesús ca'anan, quire' raji' yʌn u man u jumintej wa riq'uij Jesús. Taj cu bin u jumintej Jesús. ");
INSERT INTO lacNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jeroj ca'turob caj u tetajob ich u rac'ob. Jeroj José, ca'p'er u c'aba' José, Barsabás, raji' u yo'nen Justo. Jeroj u jer turiri' teta'b xan, Matías u c'aba'. ");
INSERT INTO lacNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jeroj tune', caj u rʌc t'ʌnajob C'uj caj ya'arob: ―Tech, Jaj Ts'urir ―quij ya'aric―. A werob u pixam tu cotor mac, ese to'onex mac a c'at tech ich a je' ca'turob. ");
INSERT INTO lacNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Soc raji' cu ca' tsec'tic a t'ʌn soc raji' cu bin quir u yamtico'onex. Mʌ' ja wirej, caj u p'ʌtaj u beyaj Judas caj u c'ubaj Jesús, jeroj caj bin erar Judas. ");
INSERT INTO lacNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jeroj caj yʌrʌc'tajob u chan tunich quir yiric mac cu yocar beyaj yejer u camsʌwinicob Jesús. Caj ts'oc u puric a chan tunicho', jeroj caj u tetaj Matías. Caj oc u beyaj yejer u camsʌwinicob Jesús, yejer a oncejo'. ");
INSERT INTO lacNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Caj c'uchij tu q'uinin Pentecostés, p'eri' much'ricob ich naj a caj u yacsaj tu yorob u t'ʌn C'uj. U q'uinin Pentecostés, ra' u q'uinin u qui'qui' janʌnob u winiquirob judío. ");
INSERT INTO lacNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jeroj tune', caj u yubob u tar u jum ic', seb caj yubob u tar. Tar u tar u jum ic' ich ca'anan. C'am u jum ic' oc ich naj tu much'a'anob tu curucbarob a yacsmʌnob tu yorob. ");
INSERT INTO lacNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Caj tar ti'ob irej u job c'ac'. Caj u rʌc jʌsaj ti'ob jujuntur, bajen u job c'ac' tu jo'rob. Chichin u job tu jo'rob a mac a yacsmʌnob tu yorob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Caj tarij u Taj'or u Pixam C'uj yicnʌob quir u tar u muc' C'uj tu yʌnob. ");
INSERT INTO lacNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ra'iri' u q'uinin, caj tarob u winiquirob judío quir u c'ujinticob C'uj. Tarob ich u jer u cajarob tarob quir u c'ujinticob C'uj ich u cajar Jerusalén. Ti' cʌja'anob ich u cajar Jerusalén. ");
INSERT INTO lacNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Robob xan, caj yubob u jum bajen u tar u jum ic', robob xan, caj binob u yiricob a ba' u ber ich a yacsmʌnob tu yorob. Caj c'uchob a pimo' tu much'a'anob ich naj. Jeroj, caj jaq'uij u yorob quire' yuba'b bajen u wʌc'ʌs t'ʌnob a tub u tarob. Robob cu t'ʌnob a mac a yacsmʌnob tu yorob u t'ʌn C'uj. ");
INSERT INTO lacNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jaq'uij yorob a pimo', sajacob, mʌ' cu joc'arob u t'ʌnob. Chen sasame' caj joc' u t'ʌnob, caj ya'arajob: ―Ir a wirej ―quij ya'aric―. A mac a cu t'ʌnob tar u tarob ich u ru'umin Galilea. ");
INSERT INTO lacNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ba' u ber, quire' quij cuyiquex u t'ʌnob ich ic t'ʌnex? ");
INSERT INTO lacNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Te' yʌna' tu yʌno'onex a mac a cu tarob ich u cajar Partia. U jer a tar u tarob ich u cajar Media. Ti' yʌn xan, a tar u tarob ich u cajar Elam. Ti' yʌn xan, a cu tarob ich u cajar Mesopotamia. Ti' yʌn xan, a cu tarob ich u cajar Judea. Ti' yʌn xan, a cu tarob ich u cajar Ponto. Ti' yʌn xan, a cu tarob ich u ru'umin Asia. ");
INSERT INTO lacNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Te' yʌna' tu yʌno'onex a mac a tar u tarob ich u cajar Panfilia. Ti' yʌn xan, a cu tarob ich u ru'umin Egipto. Ti' yʌn xan a cu tarob ich u cajar Libia tu nʌts'a'an Cirene. Ti' yʌn xan, a mac u winiquirob romano, quire' ra' u cajar Roma, Tar binob yirej ich u cajar Jerusalén, u winiquirob romanojo'. A je' pima' u winiquirob judío. Chen yʌn mac te' yʌna' tu yʌno'onex caj tarob u c'ujinticob C'uj irej u winiquirob judío cu beticob. ");
INSERT INTO lacNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Te' yʌna' tu yʌno'onex a mac a tar u tarob ich u cajar Arabia, cax mʌ' u winiquirob judío, tar u c'ujinticob C'uj an ten bic u winiquirob judío, cax ti' u ru'umin Creta caj tarob xan. Chen biquinin quij cuyiquex u tsicbarob to'onex ich ic wʌc'ʌs t'ʌnobex tan u ya'aricob a ba' jach manan u beyaj C'uj a tu betaj? ―baxuc caj ya'arajob a pimo' a caj tarob tu yʌn a yacsmʌnob tu yorobe'. ");
INSERT INTO lacNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tu yʌnob a pimo', tu cotor jach jac'a'an yorob quire' mʌ' yerob ba' quiri'. Caj u c'atajob ich u bʌjob: ―A ba' u c'at ya'aric tu cotor a jera', a quij cuyiquexe'? ");
INSERT INTO lacNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","U jerob a tu yubob u t'ʌnob a tu yacsaj tu yorob u t'ʌn C'uj, robob caj u che'tajob caj ya'arob: ―Cʌra'anob, rajen cu tsicbarob ich ic t'ʌnobex. ");
INSERT INTO lacNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Rajen caj riq'uij Pedro yejer u yet camsʌwinicob a mac tuchita'b ten Jesús. Caj ric'ob u ch'ictarob, chen Pedro, c'am caj u t'ʌnaj a mac a caj u che'tob, caj u ya'araj ti'ob: ―U'yex u xibirex Judea, bayiri' xan a techo' a mac a cʌja'anob ich u cajar Jerusalén. Qui'qui' u'yex in t'ʌn soc a najtiquex. ");
INSERT INTO lacNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ca tucriquex cʌra'anenob a tenob, chen mʌ' cʌra'anenobi'. Mʌ' ja wirej ―quij Pedro―, mʌ' nacʌc a q'uino' baje'rer, quire' mʌ' u carchʌjʌr a mac u winiquirob judío a bay q'uino'. ");
INSERT INTO lacNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","A ba' ca wiriquex baje'rer tu yʌn ts'ibtaj Joel uch. Mʌ' ja wirej, raji' Joel ts'ab u tucur ten C'uj quir u tsicbar a ba' u c'at C'uj. Rajen caj u ya'araj Joel ti' C'uj a ba' tu toc araj C'uj. U'yex ba' tu toc araj: ");
INSERT INTO lacNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Je' u c'uchur tu q'uinin a tabar u xur t'ʌn ich yoc'ocab, quij ya'aric C'uj. Je' in tuchitic u Taj'or u Pixam C'uj soc raji' ti' yʌn tu' yʌnechex, a mac a ti' yʌn ich yoc'ocabe'. A pararex je' u tsec'ticob in t'ʌnob, cax xquic xan. A mʌ' xura'an xibo', quij ya'aric C'uj, je' u yiricob a ba' cu yesa' ten C'uj a bajen u wʌyʌc'. Je' u wʌyʌc'tiquenob a mac nuxibo', quij ya'aric C'uj. ");
INSERT INTO lacNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A ra'iri' u q'uinin a tabar u xur t'ʌno', quij ya'aric C'uj, a mac a cu yamtiquenob, cax wa xib, cax wa xquic, Je' in tuchi'tic u Taj'or in Pixam C'uj soc ti' yʌn tu yʌnob. Robob je' u tsec'ticob in t'ʌnob a je' xiba', bayiri', a je' xquica' xan. ");
INSERT INTO lacNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Je' in wesic techex, quij ya'aric C'uj, ra' cu bin u jac'ar a worex ich ca'anan. Bayiri' xan, ich yoc'ocab bin in ca' in wesic techex carem beyaj soc a werex u chichir in muc'. Je' a wiriquex, quij ya'aric C'uj, q'uic'. Je' a wiriquex c'ac', quij ya'aric C'uj, a bay u pimin muyar u buts'ir. ");
INSERT INTO lacNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A ra'iri' u q'uinino', quij ya'aric C'uj, bin in ca' in wesic techex u chichir in muc', a teno' u Jaj Ts'uriren tu cotor mac. Tabar in tar u Jaj Ts'uriren tu cotor mac. Bin u ca' ac'birchʌjʌr q'uin. ");
INSERT INTO lacNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tu cotor mac, quij ya'aric C'uj, a mac a cu t'ʌniquen quir in taquique', je' in taquique'. Baxuc caj u ts'ibtaj to'on Joel, a mac ts'a'b u tucur ten C'uj quir u ts'ibtic a ba' u c'at C'ujo'. ");
INSERT INTO lacNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro caj u ya'araj ti'ob: ―U'yex in wac, u xibirechex Israel. A werex Jesús, a cʌja'an ich u cajar Nazaret uch. Raji' caj u yesaj to'onex carem u beyaj, rajen ij querex wa teta'b Jesús ten C'uj. A techexo', caj a wirajex a ba' beta'b ten C'uj ti' Jesús, wa ber ti' yʌn Jesús ti' yʌn yejero'onex uch. ");
INSERT INTO lacNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","A C'ujo', yer je' a c'ubiquex quinsbir Jesús quire' sasir u wich C'ujo'. A C'ujo' yer xan bin a quinsiquex Jesús, chen raji' tu cha'jex. A techexo', caj a c'ubex Jesús ti' a mac jach c'aso' ca' u sinejob ich cruz quir u quimin. ");
INSERT INTO lacNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Chen raji' caj ric'sa'b ten C'uj ich u quimirir. Mʌ' tu cha'j u p'atʌr Jesús ich u quimirir rajen ric'sa'b. ");
INSERT INTO lacNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mʌ' ja wirej, David caj u toc ts'ibtaj uch wa yʌn u riq'uir Cristo. Rajen caj u ya'araj David a ucho': U burur q'uin quin quibic u t'ʌn Jaj Ts'ur, rajra' ti' yʌn Jaj Ts'ur tin wicnʌn soc mʌna' ba' cu tar ten. ");
INSERT INTO lacNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rajen qui' in wor in c'ay, quij David. Mʌna' ba' quin tucric quire' tech ca cʌnantiquen. Cax quimic in winquirir, mʌ' in tucric quire' qui' in wor, quij. ");
INSERT INTO lacNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","In wer, quij David. Mʌ' ja p'ʌtic in pixam ich in quimirir ca' bin quimiquen. Mʌ' ja cha'j u tu'tar in winquirir tu t'aja'anen. In wer a jach yajen. ");
INSERT INTO lacNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A techo', quij David, caj a wesaj in ber quir in bin ca'anan quir in cuxtar munt q'uin. Je' a qui'quintic in wor quire' p'eri' quij cuxtarex. Baxuc caj u ya'araj David a ucho'. ");
INSERT INTO lacNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro caj u ya'araj: ―In wet winiquirob israel ―quij Pedro―. Taj yʌn in wa'aric techex. Uch quimic ic nunquirex David. Ti' t'aja'an u baquer ich u japnin tunich, chʌca'an tu t'aja'an u baquer baje'rer. ");
INSERT INTO lacNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David u toc er aro' quire' raji' ts'a'b u tucur ten C'uj quir u ya'aric a ba' u c'at C'uj. Jach ara'b ti' ten C'uj tan u ya'aric ti': Je' u tar a Cristojo'. Je' u yʌn tar baxuc u parare'. Raji' bin u ca' reyintic irej David. ");
INSERT INTO lacNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A ucho' yer David je' u riq'uir Cristoje' tu quimen, rajen caj u ts'ibtaj David mʌ' u tu'tar u winquirir Cristo, mʌ' ju p'atʌr tu t'aja'an u baquer. ");
INSERT INTO lacNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Taj quin wa'aric techex ―quij Pedro―. Ra'iri' Jesús caj ric'sa'b ten C'uj, in bʌjiriro' caj in wirajob rajen quin wa'aricob techex. ");
INSERT INTO lacNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mʌ' ja wirej, caj ric'sa'b Jesús ten C'uj ich u noj C'uj soc u sʌjta' ten tu cotor mac. Caj u c'ʌmaj u Taj'or u Pixam C'uj Jesús, quire' toc ara'b ti' ten C'uj uch. A ba' caj a toc irajex baje'rer, baxuc a ba' caj a toc u'yajex, ra' cu tar ich Cristo. Mʌ' ja wirej, Cristo caj u tuchi'taj u Taj'or u Pixam C'uj. ");
INSERT INTO lacNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Chen David u bʌjiri' mʌ' bin ca'anani' quire' tu yʌn araj David tan ya'aric: In Jaj Ts'urir caj u ya'araj ti' in Jaj Ts'urir: “Yʌn curen, quij C'uj, tin noj, ");
INSERT INTO lacNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta quin ts'ic tech u mosatiquech a mac u p'ec yiriquecho'.” Baxuc caj ara'b ti' David a ucho'. ");
INSERT INTO lacNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Caj u ya'araj Pedro: ―Yʌn c'ʌ'otiquex quire' u winiquechex israel soc mʌ' a tucriquex wa mʌ' Cristo. Quire' raji' teta'b ten C'uj Cristo quir u reyinta'r ten tu cotor mac. Ra'iri' Jaj Ts'ur xan. Chen techex a ta bʌjex ich cruz soc u quimin. Quin wa'aric techex quen, raji' u jach tajir Cristo. ");
INSERT INTO lacNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Caj ts'oc u tsicbar Pedro, a mac a caj u yubob u t'ʌn Pedro jach choc yorob caj yubob u yet winiquirob judío. Robob caj u c'atajob ti' Pedro yejer u yet camsʌwinicob a mac tuchi'ta'b t