﻿USE sofia;
DROP TABLE IF EXISTS sofia.kze_vpl;
CREATE TABLE kze_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kze_vpl WRITE;
INSERT INTO kze_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ísu Káráísitina akúni'a uráan-kwasai. Ísu aíkwá'náma Tévítimani. Tévíti aíkwá'náma Ááváramumani. ");
INSERT INTO kze_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ááváramu Áísákaamba marankówana Áísáka Yákópomba marankówana Yákópo Yúta-iyai áváráwáínónda matinkówana ");
INSERT INTO kze_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yúta Pérésinte Sáraante matínkaraimba tinówa Témamani. Pérési Éséronimba marankówana Éséroni Árámumba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Árámu Ámínátapamba marankówana Ámínátapa Násonimba marankówana Násoni Sáómonimba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sáómoni Póásimba maránkaraimba anówa Áré'apimani. Póási Ópétimba maránkaraimba anówa Árútimani. Ópéti Yésimba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yési Tévítimba marankówana Tévíti kárákwiyi-i'a uráiwai Sórómonimba maránkaraimba anówana aiva-kwánkó áwí'a Yúráya úwana naaén-kwamba Tévítimani. ");
INSERT INTO kze_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sórómoni Áríyapoamumba marankówana Áríyapoamu Ápáísaamba marankówana Ápáísaa Ésaamba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ésaa Yíósavatimba marankówana Yíósavati Yórámumba marankówana Yórámu Ásáyaamba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ásáyaa Yótámumba marankówana Yótámu É'ásaamba marankówana É'ásaa Ésékayaamba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ésékayaa Mánásaamba marankówana Mánásaa Émósimba marankówana Émósi Yósáyaamba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yósáyaa Yékónaya-iyai áváráwáínónda matinkówasa minkánáávímbá Pépíróni-naopakewai Ísareri-kwaasi tayí'maesa Pépíróniva'a ándáva'a mátínkaraawe. ");
INSERT INTO kze_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pépíróniva'a mátínkó-kanaavimba Yékónaya Síátiomba marankówana Síátio Sérápápeomba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sérápápeo Ápáyatimba marankówana Ápáyati Éráyakimumba marankówana Éráyakimu Ésomba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Éso Sétókomba marankówana Sétóko Ékímumba marankówana Ékímu Éráyatimba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Éráyati Éríesaamba marankówana Éríesaa Mátánaamba marankówana Mátánaa Yákópomba marankówana ");
INSERT INTO kze_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yákópo Yósépimba marankówana Yósépi Máríyaamba awaikó úwana Máríyaa Ísumba anówamani. Ísuntavesa Áánútu usásinankaiwaiye sésa Káráísitiye kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ááváramumo máyonka'a sísamaivakemba éíyaimba kumbaimái-kwaasi 14 kwaasi agáyówasa Tévítimo paárurenamo máyonka'a sísamaivakemba éíyaimba kumbaimái-kwaasi 14 kwaasi agáyówasa Pépírónivakewai tayí'maesa Pépíróniva'a ándáva'a mátínkarowasa máyón-kanaavimba sísamaivakemba éíyaimba kumbaimái-kwaasi 14 kwaasi agáyówana minká'á Máríyaa Ísu Káráísitimba maránkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ísu Káráísitimba marankómba maará uráiye. Ísu anówamba Yósépinka'a siváúmaresa ítámakowana Yósépi íma kwesé kurónka'a ámú'a paáruraiye. Áánútun-amanko ámú'a paárumankarowana ");
INSERT INTO kze_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","awaikó kawe'á kwéuwai séna kwaási túranka'a ai'máráanana Máríyaa aigaeyávéna iváímpo'a aúpá'á ai'mátuwanaumne-imayaa uráiye. ");
INSERT INTO kze_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","mirá imáyáama kwéena aún-kwáyowana Ísóigona kwayó'nákó kwíyómpakewai kaainampá'á simámena séna Yósépiyo Tévítin-andaraken-kwaasi óne. Máríyaamo ámú'o káúvímba Áánútun-amankowe su'mai ámú'a kauwánkáímba po kwembá úwoi mayáníyompo íma áá'a kaíno. ");
INSERT INTO kze_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","iyámpóímo marankánímba áwí'a Ísuwe simámiyo siráiye. mináwíkóná ááimba kwená kwaási sáwí-imayaaomo tátokaimpinkemba iyátinkaniye siráiye. ");
INSERT INTO kze_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","naaóvá'á Áánútun-aai simátímakowai sirónka'a póna mirán-tántáá'á paáruraiye. ");
INSERT INTO kze_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","kwemá agaimaréna séna moórá-inaamarugo kwaaí íma mairéna ámú'a kaumái iyámpói marankáínasa miníyámpóígó áwí'a Émániyueriye sénááowe agaimaréna siráimba mináwíkóná ááimba Áánútu keséya máyáiye siráiye. ");
INSERT INTO kze_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yósépi aúvínké usásinena Ísóigona kwayó'nákó kwíyómpakewai siróntemba awainínkómbá mairéna ");
INSERT INTO kze_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","íma kwesé kúmba úwoi ména kárákwirowana iyámpói marankówana Ísuwe séna áwí'a tamánkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yútiyaa-maravaken-kawaanako áwí'a Éróti máyon-kanaavimba Pétáremu-naopa'a Máríyaa Ísumba maránkarowasa némpakemba aaváúmó usópaken-kwaasi kawer-ímáyáágwárá-kwáásí teémesa Yérúsaremu-naopa'a tésa ");
INSERT INTO kze_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sésa Yútaa-kwaasira'a kárákwiyinine sénamo maránkáín-iyampoi náávara ánkaraao. aaváúmó usaipá'á méta awánáúndaya moórá-o'a paárisata awánéta séta iyámpói maránkaraimba póta awánéta kwenáwí'a mósá maránáe séta teémeta túne siráawe. ");
INSERT INTO kze_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","suwaná marará-káwáánákó Éróti mináímbá isówana arunkó sáwí'a úwasa Yérúsaremu-naopakewaigwara'a ísówana tirunkó sáwí'a úwana ");
INSERT INTO kze_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Éróti mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé tááyowasa torupamái máyówana séna Áánútu ai'maráníwaimba Káráísitimba marankánímba náávara ankáníyo súwasa ");
INSERT INTO kze_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","sésa Yútiyaa-marava'a Pétáremu-naopa'a ankáníye. Áánútun-aai simátímakowai agaimaréna séna ");
INSERT INTO kze_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yútiyaa-marava'a Pétáremu-naopaken-kwaasiyono. Yútiyaa-marava'a kárákwiraawaivimba kentí naaópa'o kárákwiraawai íma tínaaempa'a máyáawe. kentí naaópakemba moóráwai paárurena kesí kwaási Ísareri-kwaasira'a kawe'á umái kárákwiyiniye agaimaréna siráiye suwaná ");
INSERT INTO kze_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Éróti iséna aaváúmó usópaken-kwaasi aúpá'á tááyowasa tuwaná tísaa ena séna nósa-tawai minó'á paárisara awánaraao súwasa simámúwana ");
INSERT INTO kze_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Éróti séna Pétáremuva'a miníyámpóí koavakáá-umai awáné'a tasimásimiya'a kesé kuré'a kwenáwí'a mósá máráano súwasa ");
INSERT INTO kze_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","isésa kumbá aaváúmó usópa'o mésamo awánaraan-o'a awánowana minókómá aiva'á kwégwena miníyámpóímó máyonka'a kogwaúwasa ");
INSERT INTO kze_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ávááraumai aamoí ésa ");
INSERT INTO kze_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","mindáúmpá'á iyésa anówante miníyámpóíyé tuwánésa kívairesa miníyámpóígó áwí'a mósá marésa unáámbá óin-tokésa kawe-tántáá'á kóri-ontamba óimai amésa kawer-úmúmbó ií-yántáá'á óimai amésa áséi-kwiyum-basawenkwara'a óimai ámakaawe. ");
INSERT INTO kze_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ámatuwesa tuún-kwáúwana Áánútu kaainampá'á simátimena séna Érótimba íma kosimáméro súwasa ó'on-ampakemba kentí naaópa'a kóuraawe. ");
INSERT INTO kze_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","kóúwana kwíyómpakemba Ísóigona kwayó'nákómbá Yósépi kaainampá'á awánówana séna Éróti miníyámpóí tuvuwíndayavena kwéavakaa-ivo usásine anówante miníyámpóíyé tí'mae Ísípi-marava'a koména'a aáno simámé'a áí'mae tiyó sénaumne súwana ");
INSERT INTO kze_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","mindó'wáámbá usásinena anówante miníyámpóíyé tí'maena Ísípi-marava'a kwémena ");
INSERT INTO kze_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","mivá'á komáyowana Éróti pukáiye. naaóvá'á Áánútun-aai simátímakowai sirónka'a póna mirá uráiye. kwemá agaimaréna séna Ísóigo séna Ísípi-maravakemba kesáánimba máyaina'a ááyaanana koyauweráníye siráiye agaimaréna sirónka'a póna mirá uráiye. ");
INSERT INTO kze_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Éróti awánómba aaváúmó usópaken-kwaasi kampa'á simáuwesa kóúwana Éróti arunkó áyámba úwana aaváúmó usópaken-kwaasi simámakon-aintavaiye o'á paáruraiyemo sirón-aintavaiye imáyáa éna évakarawai ti'maréna séna Pétáremu-naor-ayampa'-naopimpa'a kaer-ímó ten-íyámpóíyé ímo kaer-ímó tarén-iyampoiye tivakáá-umai tínkantuwaaro súwasa mirá uráawe. ");
INSERT INTO kze_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","naaóvá'á Áánútun-aai simátímakowai áwí'a Yérémaya sirónka'a póna mirá uráiye. kwemá agaimaréna séna ");
INSERT INTO kze_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Áráma-kwaasi ávááraumaimo ivi'ó taráamba ísaraawe. Áréseo aísaavutantamba uráan-kwaasi miwítí iyámpóíyavesa ivi'á taawasá iyámpóímo pukáantavesa timambá aráápamai tínkaraawasa úwoi ivi'á támae iráawe agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Éróti puwúmba Yósépi Ísípi-marava'a ména kwíyómpakemba Ísóigona kwayó'nákómbá kaainampá'á awánówana séna ");
INSERT INTO kze_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","miníyámpóígómbá tuvuwónáe sen-kwáásí á'a púwóvo usásine anówante miníyámpóíyé tí'mae Ísareri-marava'a kwaaó súwana ");
INSERT INTO kze_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","usásinena awainínkónte ááninkonte tí'maena Ísareri-marava'a kúmba ");
INSERT INTO kze_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Éróti ááninko áwí'a Ákéreasi kwemá avowáná anondá Yútiyaa-ayampa'a kawáá-máyáí kwémayowana Yósépi iséna mináyámpá'ó koménintavena inkaisúwana kaainampá'á Áánútu simámuwana Káríri-ayampa'a ");
INSERT INTO kze_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Násáreti-naopa'a tí'maena koméraiye. naaóvá'á Áánútun-aai simátímakowai sirónka'a póna mirá uráiye. kwemá Ísuntavena séna Násáretivaken-kwaasiye sénááowe agaimaréna sirónka'a póna mirá uráiye. ");
INSERT INTO kze_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","minkánáávímbá moóráwai áwí'a Yóni ména nombá pétinkowai póna Yútiyaa-marava'a kúmba kavóná-marava'a koména simátimena séna ");
INSERT INTO kze_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Áánútu kwená kwaási kawááimba ááimba kwéasaivo kentí sáwí-imayaa tuwé'a Áánútumpa'a teró simátíma'mae iráiye. ");
INSERT INTO kze_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","naaóvá'á Yóni íma máyonka'a Áánútun-aai simátímakowai áwí'a Áísáya Yónimo paárinintavena imáyáa éna agaimaréna séna moóráwai kavóná-marava'a ména aayamáírakemba séna Ísóigona aambá kwirankánááomba kwená aambá arupí íyana minámpá'á kwíno Áísáya agaimaréna sirónka'a póna Yóni paárúwana mináímbá paáruraiye. ");
INSERT INTO kze_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yóni póígo áwí'a káámeri kwená áyáú-kwatoi iréna aúwarasinei ámúranda uréna a'nóríné kwantáámíkóná aúwé mintóné su'mai kwénena ");
INSERT INTO kze_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","aaí simátíma'mae iyúwasa Yérúsaremu-naopaken-kwaasiye Yútiyaa-ayampaken-kwaasiye Yóntáni-nonkona menávápákéné maanávápákén-kwáásíyé miráumai kwaási tóyo ésa ");
INSERT INTO kze_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","sáwí'o uráamba paárumai avora'á simámúwana Yóni Yóntáni-nompimba nombá pétinkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yóni nombá pétinkena awánómba ámáán-kawaa-kwaasiye Sátúsi-monor-aimbo sun-kwáásíyé sáwíva'a nombó pétinkanintavesa kwenópa'a tóyo uwaná simátimena séna iyánkó póígon-araa'an-owe. Áánútu kentí sáwí-meyamba timínívo nááwa simátímísara iséra inkaiséra kwéteo. ");
INSERT INTO kze_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","kentí sáwí-mayai tuwé'o Áánútumpa'o té'o é'a kawe'-máyáí máyéwa'a tuwánanaumne. ");
INSERT INTO kze_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ááváramu kentáá síkwá'ná imbá póta Áánútuna kawe-kwáásíyá úne sé'a mirán-ímáyáá íma oró. Áánútu Ááváramu aísaavutantamba ónááowe sénaraankasi maanóntámpínkémbá kanaám-po'a kwaási aúráaro sisa'á aúráasino. Ááváramu aísaavutantamba uráundawai póta kawe-kwáásíyá úne sé'a mirán-ímáyáá íma oró. ");
INSERT INTO kze_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","íma kawer-árámbá íyain-taima ááimpimba kwéayaisuwesa iravímbó agaisúwáantemba Áánútu miráumai kentí sáwí-meyamba timíníye Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yóni simásuwena séna kentí sáwí-imayaa tuwé'a Áánútumpa'a tewáí nombá kwévetinkaundanivo kesínaaemba tíníwai Áánútun-amankomba ai'maráínana kuména keinárawapimba anómba umátinkaniye. iramó agáyáantemba íníye. kwemá anóndakoma kembá usáyaaitaraimba pó'a kwemó aaimó síndavimba kemá aaimá sendamá uwóví'a ónaumne. ");
INSERT INTO kze_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","aawinkwínaumo sípétivimbo mósá makésamo iyaavumásúwááwanamo anómbo marapá'ó kúmísanamo ásima úndáomo tútúwaisasamo kaíkai'o ínín-iravimbo kwiyúmaimo agaisuwésamo anómbo naaúmpa'o mósá máráantemba kwaási miráráámbá íníye Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","minkánáá Ísu Káríri-ayampakemba Yóntáni-nompa'a téna Yóni nombá pésinkainkwae séna túwana ");
INSERT INTO kze_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yóni séna ímanivo emó nombó pésinkaniyonda kanaán-ivo kentáváí se nombá pésinkaao kwésene súwana ");
INSERT INTO kze_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ísu séna ivátuke súndantemba mirá uwo. mirámó ékaimo ékai Áánútu siráini'a óyauye súwana owé séna ");
INSERT INTO kze_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","nombá pérankowana nompínkémbá usásinowana sokón-tawaai taaínkaar-úwana Yóni awánómba Áánútun-amanko mááiraamba úmaena Ísu ane'á kumbáyowana ");
INSERT INTO kze_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","aaigówé su'mai kwíyómpakemba séna maawámá kesáánimba isa'á kwená imáyáa kwée'a ávááraumai aamoí umánkaumne siráiye. ");
INSERT INTO kze_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","súwana Sáátáánigo Ísumba áísaa umai isáníntavena Áánútun-amanko Ísumba simámuwana kavóná-marava'a ");
INSERT INTO kze_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","koména toómbá íma néna ayáátááka'a 40 no'waamba kwaúwana ávááran-aai ankówana ");
INSERT INTO kze_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sáátáánigo Ísu sáwí'o índa awánanae séna Ísunopa'a téna séna emá Áánútu áánimba úne kwésempo maanóntánkóntáváí toómbá aúréna'a naanó siyó súwana ");
INSERT INTO kze_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ísu séna Áánútun-aai aúváí-kwandaaivinkemba séna toómbó náíyawaiye su'mai kwaási íma tátoraivo Áánútu siráini'a amápa'a íyana tátoraniye siráimba pó'a emó sénda íma mirá ónaumne súwana ");
INSERT INTO kze_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sáátáánigo Ísumba áí'maena Yérúsaremu-naopa'a kwéna anóm-bono'-nankona ávúmayaapa'a móankena ");
INSERT INTO kze_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","séna Áánútun-aai aúváí-kwandaaivimba séna Áánútu kwíyómpakemba kwená kwayó'nárawa'a ti'maráínasa enká'á kárákwiresa pósa óntanka'a aísamaima turaráanavo sésa tiyáándei aramónááowe siráiye. mindáyavai emá Áánútu áánimba úne kwésempo maankákémbá ásávenasa kwíyómpakendarawa'a arámbaesa marapá'á móru ankánááowe Sáátáánigo súwana ");
INSERT INTO kze_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ísu séna Áánútun-aai aúváí-kwandaaivinkemba á'a mirá siréna moórá-ainkwara'a séna kentí Ísóigo Áánútumba áísaa umai isánáe íma seró siráimba emó séndantembo mirámó ékai Áánútumba áísaa umai isáúsino. mindáyavai emó sénda íma mirá ónaumne Ísu súwana ");
INSERT INTO kze_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sáátáánigo Ísumba áí'maena anón-omapa'a iréna móankena amápa'-marava'a kárákwiron-kwaasiye miwítí anón-asirayane agaráárankena ");
INSERT INTO kze_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","séna kenká'ó kívairemo kesí imáyáamo mósá máréna'o é'a kárákwiyi-mayai áména kárákwiyiniyone Sáátáánigo súwana ");
INSERT INTO kze_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ísu séna Sáátáánigo kówaao. Áánútun-aai aúváí-kwandaaivinkemba séna kentí Ísóigo Áánútumpa'a imáyáa é'a kwenáwíre su'mai mósá maré'a kwená mayáíyé su'mai máyáaro siráimba pó'a emó sénda íma mirá ónaumne súwana ");
INSERT INTO kze_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sáátáánigo auwéna kúwasa kwíyómpakemba Áánútuna kwayó'nárawa'a kumésa Ísumba áwa'naa uráawe. ");
INSERT INTO kze_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yóni marará-káwáánákó áwí'a Érótintavena séna sáwí'a uráiye siróntavena ándáva'a máankowana máyon-aimba Ísu iséna Káríri-ayampa'a kwéna ");
INSERT INTO kze_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Násáreti-naopa'a íma koména Kápénéamu-naopa'a koméraiye. mindáópa'a Káríri-nonkwaaunkon-awampa'-naopa'a Sépiyuraaniye Návataraiye tísaavutantamba uráawaiti maravá'á kwáyon-daopa'ani. ");
INSERT INTO kze_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ísu Kápénéamu-naopa'a komáyomba naaóvá'á Áánútun-aai simátímakowai áwí'a Áísáya agaimaréna sirónka'a póna mirá uráiye. kwemá agaimaréna séna ");
INSERT INTO kze_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sépiyuraaninte Návatarainte mindárai tísaavutantamba uráawaiti maravá'á nonkwaaúnkón-awampa'a Yóntáni-nonkona menávápá'-máráó áwí'a Káríri-marava'a máyáawai ó'on-o'on-kwaasiyave'a súnda ");
INSERT INTO kze_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","minkwáásí túnkwi-ayampa'a mésa sámo kaípa'a awánanaaowe. Áánútuna némpa'o túnkwi-ayampa'o máyáawai sán-kamátinkaniye agaimaréna sirónka'a póna Ísu paáréna mirá uráiye. ");
INSERT INTO kze_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","minkánáá Ísu simátimindayavena ááimba ásámai simátimena séna Áánútu kwená kwaási kawááimba ááimba kwéasaivo kentí sáwí-imayaa tuwé'a Áánútunopa'a teró siráiye. ");
INSERT INTO kze_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ísu Káríri-kwaaunkon-awampakavamba kúmba kae-kwáásíráí mésarai awaaó áwí'a Sáímoni moórá-awi'a Pítaa úwana áváko áwí'a Éndaru umái mésarai miwítí mayáímá pósarai noyáá'a to'mái tímapa'a kwénaaesarai kwase-únámbá nompí tukóyana ");
INSERT INTO kze_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ísu simátimena séna kesé tekaiyó. noyáá'o to'máímo tímapa'o kwénaaoyantemba aúná-mayai tíménakai kwénaaekai kesáái simátímapa'a kwénaaiyasa kesópa'a teró súwasarai ");
INSERT INTO kze_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","minkwásé-únámbá tuwésarai kwesé kurááiye. ");
INSERT INTO kze_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","kwesé kuyaná Ísu kómarena kúmba kae-kwáásíráí mésarai Sépéti ááninkai awaaó áwí'a Yémési úwana áváko áwí'a Yóniye tivowámpi kwimái nompí-sípívímbá mésaya kwase-únámbá to'mayaa kwéuwana Ísu minkáé'nárai tááyowasarai ");
INSERT INTO kze_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","avekáámbá tivowámbá mindómpí-sípívímbá auwésarai Ísuwe kurááiye. ");
INSERT INTO kze_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ísu Káríri-ayampa'a naaó'-nao'a kwénaaena mono'-náúmpímpá'á Áánútu kwená kwaási kawááin-aimba mináséí-kwásáí kosimátímapa'a kwénaaena ó'on-o'on-ti'o ún-kwaasi asóvamatinkava'a kúwana ");
INSERT INTO kze_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","kwenááigo Síriyaa-marava'a naaó'-nao'a kóyáwé úwasa ó'on-o'on-ti'o ún-kwaasiye taraváá-kwámbó tirumpimbó máyon-kwaasiye tíyayaambo árúkun-kwaasiye tíyayaambo pukón-kwaasiye mirámó un-kwáásí taagwiya'maésa Ísunopa'a mátínkówana asóvamatinkena ");
INSERT INTO kze_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","aambó kwénaaumba sáwívarawai Káríri-ayampakene Tékáporisi-ayampakene Yérúsaremu-naopakene Yútiyaa-ayampakene Yóntáni-nonkona menávápákén-kwáásíyé miráumai-naoken-kwaasi kwenópa'a tóyo uráawe. ");
INSERT INTO kze_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ísu máyowasa sáwíva-kwaasimo tóyo umbá tuwánéna omápa'a umáyowasa kwená kwaásiyomba torupamái máyówana ");
INSERT INTO kze_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","simátimena séna ");
INSERT INTO kze_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Áánútu súwa'naa ínkwáe sewáí Áánútu miwí kawe'á kwéumatinkena miwírá'á kwégawaaiye. ");
INSERT INTO kze_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","miwívímbá sáwí-imayaa kwáyáísana tirunkó umbaí kwétaiwai Áánútu miwí kawe'á kwéumatinkena etóyóí kwéumatinkaiye. ");
INSERT INTO kze_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","kesáváí túmo ímo maé kwéiyowai Áánútu miwí kawe'á kwéumatinkaimba pósa siráim-barama mayánááowe. ");
INSERT INTO kze_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Áánútu siráintemba mirá ónáe kwésewai Áánútu miwí kawe'á kwéumatinkena kawe'ó umáímo ménaaontavena kawerí'a umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","tirumbó kwéumatinkaawai Áánútu miwí kawe'á kwéumatinkena arumbá umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","tirumpinkémbó kawer-áíné su'mai kwésewai Áánútu miwí kawe'á kwéumatinkaimba pósa Áánútumba awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","kwaásivimbo paru umátinkanaaontavesa mayáí kwémayaawai Áánútu miwí kawe'á kwéumatinkena kesí iyámpóin-owe síníye. ");
INSERT INTO kze_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Áánútuntavesamo imáyáamo ésamo arupí umáímo máyáantavesa sáwí'a kwéumatinkaawe. Áánútu miwí kawe'á kwéumatinkena miwí kwená kwaási-i'o ombá póna kwégawaaiye. ");
INSERT INTO kze_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","keinárawa'o kentávé'o asiramáímo máyáantavesa mindáyavesa sáwí-aimba simátinkesa sáwí'a umátinkesa ó'on-o'on-kampar-aimba simátinkaamba Áánútu keinárawa'a kawe'á kwéumatinkaiye. ");
INSERT INTO kze_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","naaóvá'ó Áánútun-aaimo simátímakowaimo sáwí'o umátínkaraantemba ívé'a sáwí'a kwéumatinkaamba tirunkó kawe'á kwéina'a aamoí é'a kwíyómpakemba kentí kawe'-méyámbá mayánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ísu simásuwena simátimena séna marapá'ó máyáan-kwaasivimba mé'a uwígómó áséimo intenkáámbá kwéowe. mirá kwéombanivo uwímó sáwí'o énamo imbá íma kawe'á umái kéna íma áséi éna úwoisankaamba umágwisasa aampa'á tukésa kwénaaowe. ");
INSERT INTO kze_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","marapá'ó máyáan-kwaasivimba mé'a sámo kaintenkáámbá kwéowe. ááraipa'o kwáyáin-daopa'o mósá awánaantemba keinárawa'a máyáawaina ááimba kwéawanaawe. ");
INSERT INTO kze_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","iramá oómbá kúra'maresa íma aúpá'á maráíyamba avora'á maráíyamba mindáópaken-kwaasi awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","miráumai sámo kaintembá kwaásivimba mé'a sán-kamátinkaiyasa kentí kawe'-máyáí tuwánésa kentivo kwíyómpa'o máyáiwai áwí'a mósá maránááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ísu mináímbá simásuwena séna íma kentávé'a sé'a Mósesi siráin-aine Áánútun-aai simátímakaawai siráan-aine ivá'á túwáiwaiye íma seró. Áánútun-aai siráan-aimba íma tuwánaumpo siráanteni'o umáímo paárinintave'a kunkáumne. ");
INSERT INTO kze_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","simátíménda ísáaro. kwíyómba maramá kwáyáísana póna Áánútun-aai kwaíkwai'a kwéiye. Áánútun-aaigo amápa'a kwaíkwai'a kwéimba póna mináínkómó siráinten-umai amápa-tantaa'a paáriniye. ");
INSERT INTO kze_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","miráumai Áánútun-aaivinkembo kítor-aimbo araaisésamo ó'owantavesamo sésamo kwéundantemba mirá ínímba mindá kanaán-iye síyanamo éna Áánútu séna kesí kwaási kawááunda-kwaasivinkemba íma asirayán-kwáásímán-owe sínívo Áánútun-aaimo taagwiyavésamo simátimesamo sésamo Áánútun-aai ísáaro kwésewaiyavena Áánútu séna kesí kwaási kawááunda-kwaasivinkemba anón-kwaasiman-owe síníye. ");
INSERT INTO kze_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","moórá-aimba simátimunda ísáaro. ámáán-kawaa-kwaasiye ámáámba sen-kwáásíyé sésa Áánútumo siráintemba umái máyaumnemo sembá kampa'á kwésewe. miwímó ontembó keinárawa'o é'a Áánútumo kawááipa'a íma mé'a Áánútumo siráintemba árai'a mirámó é'o é'a Áánútumo kawááipa'a ménaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ísu maarán-áínkwárá'á séna naaóvá'á Mósesi kentíkwá'náyavena simátímakain-aimba ísaraamba maará séna tínkamiyasamo puwónááoni'a íma oró. mirámó íyasamo ésa aaivimbá maitinkánááowe siráimbanivo ");
INSERT INTO kze_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","simátime'a sé'a miwítí kwaásiyavesa aaisambá kwétiyiyawai aaivimbá maitinkánááomba mindá kanaán-iye. miwítí kwaásiyavesa sáwí-aimba simátínkáawaima tí'maesa aaimó ísáawaitopa'a mátinkaiyasa aaivimbá maitinkánááomba mindá kanaán-iye. miwítí kwaásiyavesa uwo'aó-kwáásíyá'o. úwoi-kwaasiya'o. sésa simái sáwí'a kwéiyawai sáwí-meyambo mayánááopa'o iramó kwégaipa'a ménaaomba mindá kanaán-iye. ");
INSERT INTO kze_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","mirán-áímbá imáyáa ombá Áánútuntave'o imáyáamo é'o moórá-yantaa'o aménáe'o anóm-bono'-naumpa'o komé'o é'a kentí kwaási aaí tátokaiya'o tááka'o maké'o é'a ");
INSERT INTO kze_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Áánútumbo aménááon-tantaa'a óntan-taareigona egwaa'á mámare'a mináímbá koísámai arupí umásuwe'a koyauweré'a Áánútumba áméro. ");
INSERT INTO kze_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","aaimó simátinkanae síyawaimo tí'mae kwíyasa aampa'á mósimai paárumasuwesa koró. anón-kwaasimo mátimiyasamo ésa i-kwáásí timíyasa ándá-naumpa'a tinkánááowe. ");
INSERT INTO kze_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ímo mirámó íyasamo ésa ándá-naumpa'a mótinkaiyasa íma ááéma ánásanaumne sésa amápa'-meyamba tímatuwaiyasa ayútinkanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ísu mináímbá simásuwena séna naaóvá'á Mósesi simátímakain-aimba ísaraamba maará séna ó'owi tuwainímbááre tuwai'mááte íma nááóro siráimbanivo ");
INSERT INTO kze_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","simátime'a sé'a moóráwaimo moórá-inimbo awánénamo tavisénáe sénamo ínímba íma avora'á ínívo imáyáaneiye su'mai tavisínana Áánútu séna imáyáavinkemba á'a kwéyavisiye síníye. ");
INSERT INTO kze_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","túrankomo sáwí'o ína'a misáwí-ámpá'á kúnavo sé'a moórá-turamba pítuwaaro. kae-túrándéímó awáné'o é'a sáwí-marupa'o iramó kwégaipa'a kónááomba mindá sáwí'an-iye. sáwí'o uráinda maisuwé'o máyáamba mindá kawe'án-iye. ");
INSERT INTO kze_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","tiyáánkomo sáwí'o ína'a misáwí-ámpá'á kúnavo sé'a moórá-tiyaamba arátúwáaro. kae-tíyáámbó kwáyaina'o é'a sáwí-marupa'o iramó kwégaipa'a kónááomba mindá sáwí'an-iye. sáwí'o uráinda maisuwé'o máyáamba mindá kawe'án-iye. ");
INSERT INTO kze_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","naaóvá'á Mósesi maará séna moóráwai awainínkómbá ai'mátuwaindawai aúváívimba agaimaréna séna kesuwainímbá ai'mátuwaumne séna agaimái amiíno siráimbanivo ");
INSERT INTO kze_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","simátime'a sé'a awainínkó íma moórá-kwaasigoe kwénaaisana awaikó ai'mátuwaisana minínínkó kówéna moórá-kwaasi komairéna minínínkó aúná-kwaasigoe kwénaaimba sáwí-amba kwénaaiye. aivar-áwáíkómó ai'mátukaintavena mirá kwéiye. moórá-kwaasigo ai'mátukain-inimbo kwémayaimba kwegwárá'á umóyámbá kwémayaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ísu maarán-áínkwárá'á séna naaóvá'á Mósesi simátímakain-aimba ísaraamba maará séna Ísóigompata mirá ónaumne síyamba kampa'á seváínivo árai'a sé'a mirá oró siráimbanivo ");
INSERT INTO kze_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","simátime'a sé'a kemó mirá ónaumnemo síyambo é'a árai'a mirá oró. kemó ímo mirá ónaumnemo síyambo é'a árai'a íma mirá oró. Áánútu kárákwiraiwai kwíyómpa'a máyáivo Áánútu áwíka'a íma matuwé'a seró. ");
INSERT INTO kze_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Áánútu marapá'á kárákwiraipa'an-ivo íma marará'á matuwé'a seró. Yérúsaremu-naopa'a Áánútu kárákwirain-daópa'an-ivo íma mindáópa'a matuwé'a seró. ");
INSERT INTO kze_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","avután-á'nóntáúrá'á kaantáún-a'nontau íma kanaán-umai auré'a kaantáún-a'nontaura'a avután-á'nóntáú íma kanaán-umai auránááovo ti'nónká'á íma matuwé'a seró. ");
INSERT INTO kze_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","kemó mirá ónaumnemo síyambo é'a maarán-áíné su'mai seró. owé mirá ónaumne seró. kemó ímo mirá ónaumnemo síyambo é'a maarán-áíné su'mai seró. a'áo íma mirá ónaumne seró. simátimunda-aimba Sáátáánigona imáyáavinkeni'a kwéowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ísu mináímbá simásuwena séna Mósesi simátímakain-aimba ísaraamba maará séna moóráwaimo moóráwai aúrambo pítuwainasamo ésa kwená meéyámbá kwenaúramba pítuwanaaowe. moóráwaimo moóráwai áwááyaamba kútúyuwainasamo ésa kwená meéyámbá kwenáwááyaamba kútúyuwanaaowe siráimbanivo ");
INSERT INTO kze_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","simátime'a sé'a moóráwaimo sáwí'o umánkáimba íma anondá kwembá sáwí'a umánkaino. moóráwaimo áá'o tuwausínamo e íma kwembá inkamé ókwara'a kwántáminana tuwausíníye. ");
INSERT INTO kze_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","moóráwaimo ená unáánkwátóiyavesamo mayánaunda pó'a áí'mae'a aaimó isáí-kwáásígónópa'a máánkare'a ókwara'a mayánaumnemo sínamo e íma a'áo se paákár-únánkwátóigwara'a amiyó. ");
INSERT INTO kze_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","moóráwaimo aampa'ó tátorenamo séna kesí náaindaamba sáwíyanka'a súwa'naa uwómó sínamo e íma a'áo se úwoi ayáátááka'a áwa'naa uwo. ");
INSERT INTO kze_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","moóráwaimo moórá-yantaatavenamo simiyó sínamo e úwoi amiyó. moóráwaimo moórá-yantaatavaimo kwááyu simiyó sínamo e mirá uwo Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ísu mináímbá simásuwena séna naaóvá'á simátímakain-aimba ísaraamba maará séna kentí kwaásiti imáyáa oro. kentí namuro-kwáásí tíyámba umátínkáaro siráimbanivo ");
INSERT INTO kze_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","simátime'a sé'a kentí namuro-kwáásí imáyáa timé'a sáwí'o umátínkáawaiyave'a túwa'naa umai Áánútumpa'a námúnaa seró. ");
INSERT INTO kze_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","mirámó ombá kwíyómpa'o kentivo máyáiwaina iyámpói-i'a kwéowe. Áánútu miráumai kawe'á umátinkena aaí sisaná aa'á kaisaná kawe-kwáásíráré sáwí-kwaasirare aa'á kaisaná Áánútu aaí sisaná aa'á tisaná arupí-kwaasirare ímo arupímo umáímo máyáan-kwaasirare aa'á kwétiye. ");
INSERT INTO kze_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","amáparawai kentí kwaásiti imáyáamo kwéowasamo ombá anondá miwítí imáyáa kwéowe. táákísimo máyáan-umoyan-kwaasi íma kawe-kwáásí ombánivo miwítí kwaásiti imáyáamo kwéowasamo ombá anondá miwítí imáyáa kwéowe. miráumaimo kentí kwaásiti imáyáawe su'maimo kwéiyanamo éna Áánútu íma kawe'-méyámbá timínívo kentí namuro-kwáásígwárá'á imáyáa tíméro. ");
INSERT INTO kze_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","amáparawai kentí kwaási-i'a umái kawe'á kwéumatinkaawe. Áánútuna aambó ímo kwárááwaigwara'a mirá kwéowe. mirámó onten-umái kentí kwaásiye su'mai ímanivo kentí namuro-kwáásígwárá'á kawe'á umátínkáaro. ");
INSERT INTO kze_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","kentivo kwíyómpakewai kasenkuí'a umái máyáimba mindáyave'a imáyáa é'a kasenkuí'a umái máéro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ísu mináímbá simásuwena séna évakarawaiyave'a tirumbá umátinke'a túwa'naa ónááomba íma maarán-ímáyáá é'a kwaási máyaiyanka'a kwétuwa'naa-onasa anón-kwaasiman-iye sígwáe-imayaa íma é'a úwoi túwa'naa oro. mirán-ímáyáámó kwée'o túwa'naa íyanamo éna kentivo kwíyómpakewai kawe'-méyámbá íma timíníye. ");
INSERT INTO kze_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","óísambo ímo makáawaimo túwa'naa ónááomba kwaási aamoí umásinkaigwae-imayaa íma é'a íma anónkar-anonka'a síyamba úwoi túwa'naa ónááowe. kaumbo-káér-ainkwara-kwaasi mono'-náúmpáré aamparé kwirésa anónka'a sembá óísambo ímo makáawaimo tímémba íma miwítí imáyáa ombá kwétimesa kesúwí'a mósá maráígwáe sésa kwétimewe. árai'a simátime'a sé'a mindámo tímén-anonda miwí túwí'o mósá máráamba á'a mimbéyámbá kwémayaawe. ");
INSERT INTO kze_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","óísambo ímo makáawaimo túwa'naa ónááomba kesí kwaási suwánaavo sé'a kwaásimo ímo máyaiyanka'a túwa'naa oro. mirámó ombá kentivo aúpá'ó kwéomba tuwánaiwai póna kawe'-méyámbá timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ísu mináímbá simásuwena séna Áánútumpa'a námúnaa sénááomba kaumbo-káér-ainkwara-kwaasimo sentembá íma mirá oró. miwí sésa kwaási suwánésa aamoí umásinkaigwae-imayaa ésa mono'-náúmpá'á mésa kwaásimo tóyo on-áyámpá'á mésa námúnaa kwésewe. árai'a simátime'a sé'a miwímó mirámó kwéon-anonda miwí túwí'o mósá kwémaraamba mimbéyámbá kwémayaawe. ");
INSERT INTO kze_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","miwí mirá kwéovo Áánútumpa'a námúnaa sénááomba kentí naaúmpa'a keináraware su'mai umé'a kentivombó ímo ane'ó awánaraawaimpa'a námúnaa síyana aúpá'ó kwéomba tuwánaiwai póna iséna kawe'á umái túwa'naa íníye. ");
INSERT INTO kze_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Áánútumpa'a námúnaa sénááomba úwoi-ainkaamba íma simái tavisénaaowe. Áánútuna aambó ímo kwáráawai sésa tavisimái-ainta senanayá súwa'naa íníye sésa úwoi-ainkaamba simái kwétavisevo ");
INSERT INTO kze_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","íma mirá oró. kentivombó Áánútumpa'o mirám-baaran-aintave'o kwéaisaa-e'o súwa'naa íníyemo síyamba á'a awánaraimba póna túwa'naa íníye. ");
INSERT INTO kze_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Áánútumpa'o aaí sénááomba maará sé'a kentáásivoo kwíyómpa'a máyaandawai óne. enáwí'a usáyaaitarain-awita mósá kwémaraumne. ");
INSERT INTO kze_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kentáárá'á kawááuwoya kwésune. kwíyómpakewaimo embó arááímo tainí'o ontembá súwa'naa inatá póta marapátá máyaundawaiya embó arááímo tainíta ónaumne. ");
INSERT INTO kze_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ívé'a kentáásí toóntá simiyó. ");
INSERT INTO kze_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","kwaásimo sáwí'o kwéumasinkewata mindáyaveta anondá íma sáwí'a umátinketa ivátá kwétuwaanaya miráumaiya kentáásí sáwí-imayaa maisiyuwaaó. ");
INSERT INTO kze_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","sáwí'a ígwáe sésamo kentáámó íyambo e súwa'naa íníyone. Sáátáánigo kentáá tátoraivo se kárákwiyiniyone.  ená kwaásimo kawááúmae kwéiyonana ená asirayámbá kwaíkwai'a úmae kwéiyisana enáwí'a anómba úmae kwéiyimba árair-aimban-iye. mirán-áímbá Áánútuwe seró. ");
INSERT INTO kze_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","sáwí'o umátínkaraamba ímo anondámo sáwí'o é'o ivátuwaiyanamo éna kentivo kwíyómpakewai keinárawa'o sáwí'o kwéomba túwa'naa ena maitiyuwánívo ");
INSERT INTO kze_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","sáwí'o umátínkaraamba úwoimo imáyáamo úmae iyé'o ímo ivátuwaiyanamo éna kentivo kwíyómpakewai keinárawa'o sáwí'o kwéomba íma maitiyuwáníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ísu mináímbá simásuwena séna Áánútumpa'o námúnaawe su'mai sé'a toómbá kwéawesomba asósóí-kwaasimo ontembá íma mirá oró. miwí sésa kwaási suwánésa sésa kawe'á ésa toómbá kwéawesowe sígwáe sésa toómbó ímo naanten-tóí'á ma'mái kwémaewe. árai'a simátime'a sé'a miwítí meéyámbá miwí túwí'a mósá kwémaraam-beyamba á'a mairáawe. ");
INSERT INTO kze_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","miwí ésa mirá kwéovo keinárawa'a toómbá kwéawesomba tói'a kwisuké'a ti'nóntáu paasá tumái kawe'á úmaraiyasa ");
INSERT INTO kze_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kwaási tuwánésa toómbá kwéawesowe íma síyana kentivo tuwánéna kawe'-méyámbá timíníye. kentivon-ane'ó ímo awánaawai aúpá'ó ombá awánaiwai kawe'-méyámbá timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ísu mináímbá simásuwena séna marapá'ó máyáamba sáwívar-oisamba íma máráaro. maráíyan-oisamba avíyaraamba káínana kwaígo náínana atún-káínasa mindámbá sáwí'a umásuwesa umóyámbá mayánááovo sáwívar-oisamba íma maré'a ");
INSERT INTO kze_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","kawe'-máyáí mayáíyana kentí kawe-tántáá'á kwíyómpa'a kwéniye. kwíyómpa'a kwáyáimba avíyaraamba íma káínana kwaígo íma náínana atú íma káínasa kwaási íma umóyámbá mayáíyana úwoi kwéniye. ");
INSERT INTO kze_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","marapá'ó kentí óísambo kwáyainanamo éna marapátávéna tinkánívo kwíyómpa'o kentí óísambo kwáyainanamo éna kwíyómpatavena tinkáníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ísu mináímbá simásuwena séna túranko kentí imáyáavimbo sámo kaí-yántáá'án-iye. túrankomo kawe'ó umáímo awánáínanamo éna amápar-imayaa sáma kánívo ");
INSERT INTO kze_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","túrankomo ímo kawe'ó umáímo awánáínanamo éna amápar-imayaa túnkwiniye. marapá-tántááré su'mai imáyáamo íyanamo éna keinárawapimbo sámo kaí-yántáá'ó ímo kwénamo éna tuní-yántáákó anómba umái kwéniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ísu mináímbá simásuwena séna íma kanaán-umai kae-káwáá-kwáásítí mayáí kwémayaawe. mirámó ésamo ésa moóráwaimba aamoí ésa moóráwaimba íma aamoí umánkanaaowe. mirámó ésamo ésa moóráwaina mayáí kawe'á umái maésa moóráwaina mayáí sáwí'a umái mayánááowe. miráumai Áánútuna mayáímó maé'o é'a sáwívar-ontamba mayánaumne-imayaa íma úmae iyónááowe. sáwívar-ontamba mayánaumne-imayaamo é'o é'a Áánútuna mayáí íma mayánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ísu mináímbá simásuwena séna mináímbá imáyáa é'a simátime'a sé'a máyáamba íma anón-imayaa é'a toómbó nánááontave'a íma anón-imayaa é'a kentúra'o unáánkwátóimo ónááontave'a íma anón-imayaa oró. toómbó nánááomba úwoisambanivo kwaásimo máyáamba anón-tantaa'an-iye. unáánkwátói ónááomba úwoisambanivo kwaási túma anón-tantaa'an-iye. ");
INSERT INTO kze_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","numagómpá'á imáyáa oró. numaó íma kígau kwéena toómbá áká'mai naaúmpa'a makéna nánívo kentivo kwíyómpakewai miwítí toómbá tímísasa kwénaawe. Áánútu aúranka'a kemá kwaási numaómbá usáyaaitaraamba póna kentí toómbó éna timíníye. ");
INSERT INTO kze_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","keinárawa'o anón-imayaamo é'o é'a maíyan-kanaama íma kanaán-umai ayáátááka'a ménaaowe. ");
INSERT INTO kze_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","unáánkwátói ónááontave'a íma anón-imayaa é'a kwaigwandáánká'á imáyáa oró. kwaigwandáánkó íma kígau éna íma kwená unáánkwátói makáivo ");
INSERT INTO kze_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","simátime'a sé'a naaóvá'á Yútaa-kwaasiti anóndako áwí'a Sórómoni kwemá sáwívar-unankwatoiye konaariríyé makówai úwasa kwaási awánésa kawe'án-iye sumbánivo kwaigwandáán-aramba awánésa anón-kawe'an-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","uvá'á konaarirí-yántááré séna kwaigwandáámbá Áánútu uvá'á makáiye. umá íma kwaíkwai'a ínívo ívé'a ínasa aaváyaa kwaási agaisúwánááomba Áánútu mintántáá'á imáyáa kwéena konaarirí-yántáá'á makáiye. miráumai Áánútu kwaásiyavena imáyáa éna kentí unáánkwátói timínívo keinárawa'a Áánútuntave'a íma kanaán-umai kwésuwa'naa-iwaiman-iye ímo seráámbá kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Áánútu kwétuwa'naa-imba pó'a toómbó nombó nánááontave'a íma anón-imayaa é'a unáánkwátóimo ónááontave'a íma anón-imayaa oró. ");
INSERT INTO kze_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Áánútuna aambó ímo kwáráawai toómbó nombó nánááontavesa anón-imayaa kwéowe. toómbó nombó ímo kwéne'o e'a puwónááontavena kentivo imáyáa éna kwétimivo imáyáa íma anón-imayaa kwée'a ");
INSERT INTO kze_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Áánútumo kwená kwaásimo kawááintave'a aiva'á imáyáa é'a kwembó arááímo tainí'o kwéontave'a imáyáa é'a mirámó owaná mintántáá'á kwétimiye. ");
INSERT INTO kze_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ayunkáwe aaváyaawe paárinin-tantaatave'a íma anón-imayaa íyana tirunkó umbaí táíno. ívé'a kwáyáin-tantaatave'a imáyáa é'a aaváyaamo paárinin-tantaa'a awáné'a imáyáa é'a moórá-tawai moórá-tawaimo paárinin-tantaa'o awánaantemba imáyáa oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ísu mináímbá simásuwena séna tuwáné'o é'a sáwí-kwaasiye siyanamó éna Áánútu kentáváígwárá'á mirá sínívo tuwáné'o é'a sáwí-kwaasiye sevó. ");
INSERT INTO kze_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kawer-áímbá kwésimatime'a sáwí-aimba kwésimatime'a íyantavena Áánútu kembá mirá íníye. tíménteni'a umái Áánútu miráumai timíníye. ");
INSERT INTO kze_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","kentúrampimba irarumbá kwáyáísa'o ombá íma awánaamba kentí kwaási tuwáné'a enaúrampimba ayaantambá kwáyáiye kwésevo íma mirá seró. ");
INSERT INTO kze_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","kentúrampimbo irarumbó ímo awánaamba nóra sera kentí kwaási túrampinkemba tiyaantambá maitiyuwánáe kwéseo. ");
INSERT INTO kze_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","kaumbo-káér-ainkwara-kwaasin-ovo kentúrampinkemba irarumbá maisuké'a tuwáné'a kentí kwaási túrampinkemba tiyaantambá kanaán-umai maitiyuwánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","kawe-tántáá'ó iyánkómbó ímo áméntemba Áánútun-aai arááiraawaima íma simátíméro. simátimiyasamo ésa aká'áámba simátinkanaaowe. kawe-tántáá'ó póígombo ímo áméntemba Áánútun-aai íma sínkáiye kwésewaima íma simátíméro. simátimiyanamo éna mináínkó úndáraamba tokwíníye. ");
INSERT INTO kze_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ísu séna Áánútumpa'o námúnaamo kwésemba áísaa úmae kwéiyiyana timíníye. ááyamae kwéiyiyana kentáái isáníye. kwéavakaa úmae iyíyana Áánútu agaráátinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","áísaa íyanamo éna Áánútu timíníye. kwéaayewanamo éna Áánútu kentáái isáníye. avakáá íyanamo éna Áánútu agaráátinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","keinárawa'a iyámpóígwara-kwaasi kentáánimbaa'o kisaamá simiyómó síya'o é'a íma óntan-amu'a timé'a kisaamá timénááowe. ");
INSERT INTO kze_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","noyáá'a simiyómó síya'o é'a íma iraankavayaambá timénááowe. ");
INSERT INTO kze_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ánivo sáwí-kwaasi ombánivo kentáánimbaa'a kawe-tántáá'á kwétimevo kwíyómpakemba kentáásivowa kaweré su'mai iwáí póna áísaa íyawaimo éna kawe-tántáá'á timíníye. ");
INSERT INTO kze_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","kembó tirááímo táínda-i'o umáímo kwétuwa'naa-iya'a miwí miráumai túwa'naa oro. mináímbó simátimunda Mósesi siráin-aine Áánútun-aai simátímakaawai siráan-aine minkáér-áínkóná ááimba kwésimatimune Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ísu séna kaer-óntámá kwáyáísa'a sáwíyan-ontavimba usáveraaro. anón-ontama anón-ankona ontamán-iye. Áánútuna némpa'o maí'mai'o ónááon-ayampa'a minánón-ámpá'á kwégwesa sáwíva-kwaasi minóntávímbá kwégowe. ");
INSERT INTO kze_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","sáwíyan-ontama umbai-ánkóná ontamán-iye. aúnái'o umáímo maí'mai'o ónááon-ayampa'a minúmbáí-ámpá'á kwégwesa esimáí-kwaasiye su'mai minóntámá avakáá-umai awánésa kwéusaveraawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ísu mináímbá simásuwena séna évakarawai kampa'á simátimesa sésa Áánútun-aai simátimunda-kwaasi úne kwésewai miwí kárákwimai máéro. sipisípi-poigomo paru umáímo máíntemba miwí kampa-párú umái kwénaaombanivo kawer-ímáyáá sáwí'a kwéumatinkaan-kwaasin-owe. ");
INSERT INTO kze_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","miwítí ááimbo awánanae'o é'a miwítí mayáí awáné'a miwímó máyáawaina ááimba awánaaro. tekómó éna íma áwí-yantaa'a iyánívo te'á iyáníye. ampaantarígoma avo'árén-aramba íma iyánívo ampaantarí-aramba iyáníye. ");
INSERT INTO kze_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","miráumai kawe-táígó kawer-árámbá íyáísana sáwí-taigo sáwí-aramba kwéiyaiye. ");
INSERT INTO kze_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","kawe-táígó íma sáwí-aramba íyáísana sáwí-taigo íma kawer-árámbá íyáísasa ");
INSERT INTO kze_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","kawer-árámbó ímo íyain-taima ayáímai iravimbá kwéagaisuwaawe. ");
INSERT INTO kze_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","miráumai minkámpá-kwáásítí mayáí awáné'a miwítí ááimba miráráán-umai awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","kentávésa kesí Ísóigoman-iye kwésewaigwara'a Áánútu íma mútú'a kárákwinimba póna kesivo kwíyómpakewaimbo arááímo tainí'o kwéowairare su'mai kárákwiyiniye. ");
INSERT INTO kze_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Áánútu amáparawai máyáawaina ááintavena tísaa ínín-kanaa tíndara'a kentávésa sáwívarawai sésa Ísóigoo ená asirayándéí Áánútun-aai simátímakaumne. ená asirayándéí kwaási tirumpinkémbá taraváá-kwámbá maitíyukaumne. ená asirayándéí ó'on-o'on-kawe'-mayai ímo awánaraam-bayai mairáumne sénááombanivo ");
INSERT INTO kze_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","simátime'a sé'a íma kesí kwaási é'a sáwí-mayai kwémayaan-kwaasin-ovo kóro kemá sénaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ísu mináímbá simásuwena séna kesáái isésa kwégwaraiyawaima mirán-kwáásímó simátíméndara'a ísáaro. kawer-ímáyáágwárá-kwáásí asirayán-dámbá ónáe sésa mai'á u'maésa kumémesa óntanka'a naamayáámba móru aimái naambá úmaraiyana ");
INSERT INTO kze_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","aa'á téna anón-kavirayan-domba kumínana mindámbá íma tawisínda asiramái kwéena óntanka'-namba póna úwoi kwéniye. ");
INSERT INTO kze_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ánivo kesááimo isésamo ímo kawe'ó umáímo kwéisaiyawaima mirán-kwáásímó simátíméndara'a ísáaro. naambá ónáe sésa íma mai'á ukésa íyamba nonáámááíra'a paáká'á úmakaiyana ");
INSERT INTO kze_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","anón-a'a téna kavirayán-dómbá kuména mindámbá tawísíyuwainana sáwí'a íníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ísu mináímbá simátímatuwowasa torupamáímo máyón-kwaasi isésa ");
INSERT INTO kze_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ámáámba sen-kwáásímó sentembá íma sivó anón-kwaasigoraamba siyé sésa táátavesa uráawe. ");
INSERT INTO kze_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","táátavesa uwaná Ísu minómápákémbá kumúwasa sáwívarawai ánaaemba kwárówana ");
INSERT INTO kze_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","moóráwai áúmo karón-kwaasi Ísunopa'a téna anóndakoman-iye séna aísamaivimba takívairena séna kentávénamo ankáínamo e kanaán-umai aúnái'a umásinkaniyone súwana ");
INSERT INTO kze_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ísu ayáámba ane'á tátorena séna mirá ónaumpo enáúra'a karevú'a kawáúgwiye súwana avekáámbá kawáúguwana ");
INSERT INTO kze_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ísu séna enáúra'o umánkaunda-aimba simátimenavo enáúra'a kawáúgwimba po naaóvá'ó Mósesimo siráintemba mono'-máyáí-kwáásítópa'a kwéma enáúma máagaraatinke póíma tímínasa Áánútuntavesa ísámai tuvú'mái agayáíyasa amáparawai awánésa áúrakemba kawáúgwiye sénááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ísu mináímbá simásuwena Kápénéamu-naopa'a kúwana Árómáani-i-kwaasiti kawááná'á ména Ísunopa'a téna asiramái séna ");
INSERT INTO kze_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","anóndakoo kesí kwayó'ná'á naaúmpa'a ména anón-ai'a isaná áúwawaako íma úwauwa kwéisana máyáiye súwana ");
INSERT INTO kze_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ísu séna koasóvamankanaumne súwana ");
INSERT INTO kze_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","kwemá séna kemá sáwíyan-kwaasi úmpo emá anón-kwaasi ómpo kesí naaúmpa'a íyínda uwóví'a íníyompo ivátuwe aaiyé su'mai sinaná kesí kwayó'ná'á asóváíno. ");
INSERT INTO kze_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","kegwárá'á kawáá-máyáígóná ááimba awánaraunda kesí kawáánákó sisa'á kwená mayáí kwémae'a kesí i-kwáásíyávé'a súnasa kesí mayáí kwémayaawe. moóráwaintave'a sé'a kwaaó súnana kwégwisa'a moóráwaintave'a sé'a tiyó súnana kwétisa'a kesí kwayó'nátávé'a mirá uwómó súndantemba mirá kwéivo úwoi aaiyé su'mai sinaná kesí kwayóná'á asóváíno súwana ");
INSERT INTO kze_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ísu mináímbá iséna áátavena éna kwenánaaembo kwa'maésamo kun-kwáásíyóntávéna séna simátime'a sé'a minkwáásí Árómáani-kwaasigo kentávéna súwa'naa ií-ásíráyámbá tokáiye kwésivo kesí kwaási Ísareri-kwaasivinkene ó'on-kwaasivinkene íma mirán-áímbá kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","simátíménda ísáaro. aaváúmó usaipakéné kumpéráípakene ó'on-o'on-ayampakene sáwívarawai tóyo ésa Áánútu kwená kwaásimo kawááipa'a mésa kentíkwá'ná Ááváramuwe Áísákaawe Yákópowe toómbá nánááombanivo ");
INSERT INTO kze_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","mindárau tísaavutantambo uráawai miwí túma maé kwéiyesa sésa Áánútu kawááipata ménaumne kwésewai tí'maena túnkwi-ayampa'a tiyuwáínasa ivi'á kwétesa sáwí'a umái mésa túwááyaamba akévundanaaowe Ísu simátimena ");
INSERT INTO kze_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Árómáani i-kwáásítí kawáánátávéna séna emó kentávémo séndantemba mirá onaná asóvanivo ená naaúmpa'a kwaaó súwana mitáwai kwená kwayó'ná'á asóvamaguraiye. ");
INSERT INTO kze_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ísu Pítaana naaúmpa'a uména awánómba Pítaa aísáankomba kokotámba kwéankowana máyowana ");
INSERT INTO kze_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ayáánka'a tátorowana minkókótámba ánásowana usásinkwena toómbá agaimái tímakaiye. ");
INSERT INTO kze_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","toómbá timúwasa enónka'a taraváá-kwámbó tirumpimbó máyon-kwaasi tí'maesa Ísunopa'a mátínkówana aaí séna taraváá-kwámbá tirumpinkémbá maitiyuwówasa kóuwana tí'o ún-kwaasi asóvamatinkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","naaóvá'á Áánútun-aai simátímakowai áwí'a Áísáya agaimaréna Ísuntavena séna sí'o kwéimba asóvasinkena sí'o kwéimba ánásamasinkaraiye agaimaréna sirónka'a póna Ísu mirá uráiye. ");
INSERT INTO kze_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","moórá-tawai sáwívarawai tóyo ésa Ísuna egwaa'á máyówana tuwánéna kwená kwaásiyavena séna monkwaaúnkóná menávápátá kónáe súwana ");
INSERT INTO kze_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","moóráwai ámáámba sún-kwaasigo téna séna amápa'-naopa'o nááíndava'a esé naaónaumne súwana ");
INSERT INTO kze_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ísu minkwáásígómbá áísaa umai isánáe séna emó sénda súnda-aimba imáyáa uwo. kwaankó taaiyaivimbá kwégwaisana numaómá ánáamba úmarena kwégwaivo kemá kwaási úranda'a kumpaáruraundawai íma naambá úmare'a kwégwaumne súwana ");
INSERT INTO kze_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","moóráwai kwenánaaemba kwakówai séna anóndakoo máyáanana kesivo puwína'a utamánke'a enánaaemba kwaránaumne súwana ");
INSERT INTO kze_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ísu séna ímanivo kesáái ímo isésamo pukáan-kwaasiraamba owáímá puwíyan-kwaasi utamátinkanaaovo emá kesínaaemba kwaraaó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ísu mináímbá simásuwena kwená kwayó-kwáásíyé nompí-sípívímbá usáatena nonkwaaúnkóná menávápá'á kúmba ");
INSERT INTO kze_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ísu aún-kwaigurówana minkwaaúmpá'á anón-unda torówana nonkó tuvántááva éna nompí-sípívímbá ógwitowasa kunávekunavo sésa ");
INSERT INTO kze_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","inkaisésa Ísumba koaúsesa sésa Ísóigo puwúnavaiya súwa'naa uwo suwaná ");
INSERT INTO kze_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","nóintavaiya kwéinkaiseo. kentávé'a nóra séra íma kesí imáyáa onkákémbá kwéseo séna usásinena asiramái séna úndáonte nonkóntéyavena maiváyáakaiyo súwasarai úndáoe nonkóe maiváyóyana nonkómá kararépaguwana ");
INSERT INTO kze_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","táá'a kówasa keáímbá sésa nóran-kwaasiya énawa úndáoe nonkóe kwenáái kwéisaiyo sésa tiyáámba uvakésa táátavesa ésa siráawe. ");
INSERT INTO kze_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","simásuwesa mindómpí-sípívímbá kumbá Káríri-marama tínaaempa'a kwáyowana Kégésaa-marama túrampa'a kwáyowasa mimbárává'á kumbá Ísu mindómpí-sípívínkémbá ásávowasarai kae'nárai kwenópa'a tiráái. minkáé'nárai taraváá-kwámbá tirumpimbá máyowasarai kwaásimo utamátínkóm-buri-aiva'a mésarai túwáávite kwéuyasa kwaási inkaisésa minkáé'náraimo máyóyapa'a íma kwéguwasarai minkáé'nárai Ísunopa'a tésarai ");
INSERT INTO kze_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","anónka'a sésarai Áánútu ááninkoo sínkami-kanaa íma tiráisasa sínkaminiyerai kwéteno suyasá ");
INSERT INTO kze_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","egwaa'á sáwíva-poima mésa umá kwénowasa ");
INSERT INTO kze_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","minkáé'nárai tirumpinkén-táráváá-kwántómbá Ísuntavesa sésa si'mátuweyaamo e mimpóí tirumpimbá si'maraaó suwaná ");
INSERT INTO kze_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","mirán-oro súwasa taraváá-kwántómbá minkáé'nárai tirumpinkémbá kárúwesa póí-tirumpimba kovérówasa mimpóíyómbá amápa'a ámémpakemba isaaisésa nonkwaaúmpíntá kumpérómba putásowasa ");
INSERT INTO kze_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","póíra'o tavíkówai awánésa avekáán-umai naaópa'a kwésa póígomo úne Ísumo minkáé'náraimo umátinkone mósimatim-besimati uwasá ");
INSERT INTO kze_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","isésa koawánanae sésa kumbá koawánésa Ísuntavesa sésa maambárává'á ivá siyuwéya kóaao siráawe. ");
INSERT INTO kze_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","suwaná Ísu kwená kwayó-kwáásíyé nompí-sípívímbá usámaaisena kúmba kwená naaópa'a marapá'á ásávowasa ");
INSERT INTO kze_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","évakarawai aísamaimo pukówaimba kwandaaivímbá marésa taagwiya'maésa tésa Ísunopa'a máánkówana Ísu tuwánéna taagwiya'maésamo tun-kwáásímó árai'a kawe'á umánkaniye-imayaamo umbá Ísu tuwánéna aísamaimo pukón-kwaasiyavena séna kesí kwaásiyo ená sáwí-imayaa mayauwáúmne súwasa ");
INSERT INTO kze_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ámáámba sun-kwáásí keáímbá sésa Áánútu kweyáá sáwí-imayaa maitiyuwánívo minkwáásígó Áánútumba aká'áámba kwésimankaiye suwaná ");
INSERT INTO kze_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ísu miwítí imáyáa tuwánéna nóra séra mirá-sáwí-ímáyáá kwéoo. ");
INSERT INTO kze_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","moóráwaimo aísamaimo pukáindawaintavenamo sénamo ená sáwí-imayaa mayauwáúmne sínasamo ésa áraira sií. kampará siíyo sénááowe. ánivo moóráwaimo aísamaimo pukáindawaintavenamo sénamo usásine eyááríka'a kwaaó sínasamo ésa áraira sií. kampará siíyo awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","kemá kwaási úranda'a kumpaáruraundawai marapá'á máyaunda kwaásiti sáwí-imayaa maitiyuwáúnda-asirayamba tokáunda pó'a agaráátínkáanda awánanaaowe séna aísamaimo pukón-kwaasiyavena séna usásinke ená kwandaaimá maimaé ená naaópa'a kwaaó súwana ");
INSERT INTO kze_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","usásinena kwená naaópa'a kúwasa ");
INSERT INTO kze_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","máyówai Ísumo úmba awánésa táátavesa ésa Áánútu áwí'a mósá marésa sésa Áánútu minkwáásígómbá asirayámbá ámísana póna mirá uráiye sésa táátavesa ésa tiyáámba tóipimba áákaawe. ");
INSERT INTO kze_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","suwaná Ísu tuwéna kwéna awánómba moóráwai áwí'a Mátíyu táákísimo máyón-daumpa'a máyowana awánéna séna usásine kesé tiyó súwana usásinena kwenánaaemba kwa'maéna kúwasa ");
INSERT INTO kze_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ísu kwená kwayó-kwáásíyé Mátíyuna naaúmpa'a umésa toómbá nowasá sáwívarawai táákísimo máyón-kwaasiye sáwí'o un-kwáásíyé mindáúmpá'á umésa nowasá ");
INSERT INTO kze_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ámáán-kawaa-kwaasi awánésa Ísuna kwayó-kwáásíyávésa tísaa esa sésa kentí anóndako nóra sénawa táákísimo máyáan-umoyan-kwaasiye sáwí'o on-kwáásíyé toómbá kwénaiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ísu iséna séna sontaa-kwáásígó kawe'ó umáímo máyáan-kwaasi íma kwétuwa'naa-ivo tí'o in-kwáásí kwétuwa'naa-iye. ");
INSERT INTO kze_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","mindáyave'a arupí umáímo máyáan-kwaasi tááyaanasa Áánútunopa'a tígwáe sé'a íma kunkáumpo sáwí'o umáímo máyáan-kwaasi tááyaanasa Áánútunopa'a tígwáe sé'a kunkáumne. Áánútun-aai aúváívimba agaimaréna séna Áánútu séna póímo tuvú'máímo agaimáímo símémba kanaán-ivo tirumbó kwéumatinkaamba anón-aamoi kwéune siráimba mindáyave'a imáyáa é'a mirá kwéumpo mináínkóná ááimba isé'a mirán-oro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","súwasa Yóni nombó pétinkowaina kwayó-kwáásí Ísunopa'a tésa áísaa esa sésa keséya ámáán-kawaa-kwaasiye moórá-mora-tawai Áánútuntaveta imáyáa éta toómbá íma kwéneta námúnaawe su'mai kwésumpo ená kwayó-kwáásí íma mirá ésa toómbá úwoi kwénaawe. nóra esa mirá kwéoo suwaná ");
INSERT INTO kze_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ísu séna moóráwai aaraí mayáíndawai amááraawi tanómba kautimínímba miwísé máyainasa aamoí ésa mintómbá íma a'áo sénááovo úwoi nánááowe. naaémba minkwáásígómbá áí'maesa kówíyasa minkánáámá amááraawi tirunkó sáwí'a ínasa toómbá a'áo sénááowe Ísu séna kwemó ménamo naaémbo tiyuwénamo iyíníntavena mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ísu mináímbá simásuwena séna ááéraan-ampantaamo avaa'ó kwáyáísasamo ombá aúná-ampanta íma kárámai kwéaraapaawe. mirámó íyana aúná-ampanta sáwí'a ínana ááéraan-ampantao aúná-ampantaraani'a íma íníye. ");
INSERT INTO kze_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","aúná-anda-aran-domba ááéraa-sipisipi-auwarasi-anaveumpimba íma kwéatimaraawe. mirámó íyanamo éna aúná-anda-aran-domba anón-éna ááéraan-anaveumba kavámbaena sáwí'a ínana mindómbá úwoiva'a atígwiniye. mindáyavesa aúná-anda-aran-domba aúná-sipisipi-auwarasi-anaveumpimba kwéatimaraawana minándá-árán-dóné misípísípí-áúwárásí-anaveune kawe'á umái kwáyáiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ísu mináímbá kwésimatimumba moóráwai mono'-nánká'ó kárákwirowai téna Ísu anóndakoman-iye séna aísamaivimba kumbéna séna kesiyáámúmba kwévuwivo tiré ane'á koyátorenana usásinaino súwana ");
INSERT INTO kze_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ísu usásinena kwená kwayó-kwáásíyé mindákóe kumbá ");
INSERT INTO kze_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","moórá-ininkomba áí'a kwéun-ininko sísamaivakemba kae'á kumbaimái-ima naaeyámba kwéankowana minínínkó Ísun-ánaaemba kwa'maéna kwégwena kwená unáánkwátói árááira'a koyátorena ");
INSERT INTO kze_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","imáyáa éna séna kwená unáánkwátói árááira'a koyátóráánanama sí'a ésinkaniye-imayaa éna koyátorowana ");
INSERT INTO kze_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ísu kwanténa awánéna séna kesímánaako áá'a íma kaíno. kentáváí se árai'a súwa'naa íníwaiman-iye sénda póna áí'a éránkáiye súwana minkánáá kawe'á umái méraiye. ");
INSERT INTO kze_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","kawe'á umái máyowana Ísu kwéna mono'-nánká'ó kárákwirowaina naambó kwáyonka'a kwéna awánómba torupamáímo máyón-kwaasi uwíremba kwésesa anón-ivi'a kwétowana Ísu tuwánéna ");
INSERT INTO kze_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","séna máápa'a kúmóro. minárásígó íma pukáivo úwoi aúmá kwaiguráiye súwasa Ísuna awíráái suwaná ");
INSERT INTO kze_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ísu ti'mátuwowasa máápa'a kunákárúwowana minárásígó pukópa'a iyéna ayáánka'a tátorowana minárásígó usásinowana ");
INSERT INTO kze_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ísumo ún-aimba kóyáwé uráiye. ");
INSERT INTO kze_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","mináímbá kóyáwé úwana minkákémbá Ísu aampa'á kúmba kae'nárai túramba kavíkóndarai kwenánaaemba kwa'maésarai kwésarai anónka'a sésarai Tévítina akún-ándárákéwáí ómpo arunkáí umásinkaao suyaná ");
INSERT INTO kze_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","kwégwena naaúmpa'a umáyowasarai minkáé'nárai kwesé umáyóyana Ísu tísaa ena séna kentávékai sékai súramba kanaán-umai kawe'á umásinkaniyewa kwéseyo Ísu súwasarai anóndakoo kanaán-umai mirá íníyone suyaná ");
INSERT INTO kze_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","kentávékai miráyavekai áraire séyamba póna túramba kawe'á íno súwasarai ");
INSERT INTO kze_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","túramba awánamai kawe'á uyaná Ísu asiramái simátimena séna kemó únda íma simátímékaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ivátuwesarai kwemó úmba mósimatim-besimatimba uyaná kóyáwé uráiye. ");
INSERT INTO kze_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","minkáé'nárai kuyasá évakarawai moóráwaimba áí'maesa Ísunopa'a máánkara. kwenarumpimbá taraváá-kwámbá máyontavena minkwáásígó íma aaí kwésuwasa áí'maesa Ísunopa'a máánkówana ");
INSERT INTO kze_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ísu mayauwówana kóúwana minkwáásígó aaí súwasa sáwívarawai awánésa táátavesa ésa sésa Ísareri-kwaasiya éta naaóvá'á mirám-báyáí íma awáraundaya ívékwarata íma kwéawanaumne sumbánivo ");
INSERT INTO kze_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ámáán-kawaa-kwaasi sésa taraváá-kwántóntí kawááná'á asirayámbá ámísana tokéna póna taraváá-kwámbá kwémaitiyuwaiye siráawe. ");
INSERT INTO kze_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ísu naaó'-nao'a anón-daopimpare sáwíyan-daopimpare kwénaaena mono'-náúmpímpá'á uména Áánútu kwená kwaásimo kawááin-aimba áséi-aimba simátíma'maena iyéna ó'on-o'on-ti'o ún-kwaasi asóvamatinkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ísu mirá kwéuwasa sáwívarawaimo tóyo umbá tuwánéna séna sipisípira'o ímo kárákwiraiwaimo ímo máyáísasamo sipisípimo sáwí'o umáímo nááóntemba mirá owasá íma túwa'naa úmae kwénaaowasa sáwí'a kwéowe séna arumbá umátinkena ");
INSERT INTO kze_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","kwaásima Áánútumpa'a tígwáe-imayaa éna kwená kwayó-kwáásíyávéna séna kígauva'a sáwíva-tomba ávu karáisasa mintómbá akaránááon-kwaasi esimáí-kwaasi máyáamba pó'a ");
INSERT INTO kze_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kígaugona avowámpa'a námúnaa síyana mayáí-kwáásí ti'maráínasa mintómbá akaránááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ísu kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi tááyowasa tuwaná kwaási tirumpinkémbá taraváá-kwámbá maitíyu'mae'a nááóro-asirayamba tiména ó'on-o'on-ti'o ún-kwaasi asóvamatinkai-asirayamba tímakaiye. ");
INSERT INTO kze_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","asirayámbá tiména kwená mayáírá'á ti'maréna séna kesí aantá-kwaasin-owe súwai túwí'a moóráwai áwí'a Sáímoniye séna aúná-kwi'a tamámena Pítaawe séna moóráwai Pítaa áváko áwí'a Éndaru moóráwai Sépéti ááninko áwí'a Yémési moóráwai Yémési áváko áwí'a Yóni moóráwai ");
INSERT INTO kze_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Vírípi moóráwai áwí'a Pátóromu moóráwai áwí'a Tómáasi moóráwai áwí'a Mátíyu kwemá táákísi mayówai moóráwai Árávíási ááninko áwí'a Yémési moóráwai áwí'a Tátiyasi ");
INSERT INTO kze_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","moóráwai áwí'a Sáímoni kwemá Árómáani-kamaani-kwaasi ti'mátuwanae siráiwai moóráwai áwí'a Yútási Isakéríóti kwemá naaénba Ísumba kwená namuro-kwáásírá'á agaráátínkaraiwai miráumai-kwaasi Ísuna kwayó-kwáásímán-owe. ");
INSERT INTO kze_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ísu minkwáásí sísamaivakemba kae'á kumbaimái-kwaasi ti'maréna séna kosimátíma'mae nááóro. ó'onkaa-kwaasiti naaópimpare Sámériyaa-kwaasiti naaópimpare íma naaé'a ");
INSERT INTO kze_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","kentí kwaási Ísareri-kwaasiti naaópimpa'a nááóro. sipisípira'o ímo kárákwiraiwaimo ímo máyáísasamo sipisípimo sáwí'o umáímo nááóntemba Ísareri-kwaasi mirámó kwéomba ");
INSERT INTO kze_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","kosimátime'a sé'a Áánútu kwená kwaásimo kawááimba ááimba kwéasaiye kosimátí'mae nááóro. ");
INSERT INTO kze_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","tí'o in-kwáásí asóvamatinke'a púwón-kwaasi usásintinke'a túmo karáin-kwaasi túma kawe'á umátinke'a taraváá-kwámbá tirumpimbá máyáan-kwaasi maitiyúwáanasa kónááowe. mimbáyáígóná asirayámbá úwoi timúna'a íma óntamba meéyámbakaavo úwoi kawe'á umátínkáaro. ");
INSERT INTO kze_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","aampa'ó kwíyamba íma moórá-yantaa'a maimaé'a koró. óntamba íma unáámpímbá áítumae'a kwé'a ");
INSERT INTO kze_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","toón-únámbá íma maimaé'a kwé'a tísamai-anaamba íma maimaé'a kwé'a tááúmba íma maimaé'a koró. moórá-mora-umai unáánkwátói timantenká umái kuvé'mae'a koró. túwa'naa ónááowai kárákwiyonaaovo évaka-tantaa'o íma maimaé'a úwoi koró. ");
INSERT INTO kze_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Áánútun-aai simátimenaaontave'a moórá-naopa'o kwíyamba keinárawa'o naambó timíndawaimba avakáá é'a mindáúmpáré su'mai mé'a kentí mayáí maimái ánáse'a mindámbá tuwé'a ó'on-daopa'a koró. ");
INSERT INTO kze_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","moórá-naumpa'a iyíyamba máyaiyan-kwaasiyave'a sé'a kawe'á umái máéro síyasa ");
INSERT INTO kze_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","keinárawa'o kárákwiyiyanamo éna Áánútu kawe'á umátinkanivo ímo kárákwiyiyanamo éna Áánútu keináraware su'mai kawe'á umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","moórá-naopa'o kwíyamba naambó ímo timésamo kentááimo ímo isáíyanamo éna Áánútu mindáópaken-kwaasi íma aamoí umátinkanivo umásítai'a é'a tísamaivakem-baramo uwáéntenkaani'a oró. mindáúmpárá'i. mindáópara'iyo. tuwé'a koró. ");
INSERT INTO kze_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","simátíménda ísáaro. Áánútu kwaási máyáawaina ááintavena tísaa ínín-kanaa tínímba naaóvá'ó Sótómu-naopare Kómóraa-naopare méraan-kwaasi sáwí'o uráantavena sáwí-meyamba timíníye. keinárawa'o tínaaembo umátimenaaon-kwaasi sáwí-meyamba timíníye. minkwáásíyóntí sáwí-meyanko Sótómu-naopakewaiye Kómóraa-naopakewaiyeti sáwí-meyankomba usáyaaitaniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ísu mináímbá simásuwena séna simátíménda ísáaro. sipisípimo kwisanamó áwááisaantemo in-íyánkómó intenkáámbó on-kwáásívímbá ti'maránaumne. kawer-ímáyáágwárá-kwáásíráámbá umái mé'a sáwí'o umátinkanaaombo é'a íma anondá sáwí'a é'a paru umái máéro. ");
INSERT INTO kze_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","kárákwiyoro. mono-káwáá-kwáásí keinárawa'a tí'maesa anón-kwaasitopa'a mótinkesa aaivimbá maitinkésa mono'-náúmpá'á mótinkesa túwíruku'-nesa ");
INSERT INTO kze_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","kentávé'o asiramáímo máyáantavesa táto'mai tí'maesa kámááni-anon-kwaasitopare kawááon-kwaasitopare mátinkesa aaivimbá maitinkáíya'a miwí kesáái simátime'a ó'onkaa-kwaasiyonte kesáái simátimenaaowe. ");
INSERT INTO kze_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","aaimó simátínkénka'a nóran-aina sénaumno-imayaa íma anómba é'a íma kentí imáyáavinken-aimba sénááovo kentivon-amankó sénááon-aimba úwoi tááka tinkáína'a sénááowe. ");
INSERT INTO kze_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","évakarawai tívá'awaawi tí'mai ó'owira'a timíyasa tínkamiyasa puwónááowe. tivoísáímo ésa tíráámaa'a tí'mai ó'owira'a timíyasa tínkamiyasa puwónááowe. iyámpóíyombo ésa tinóvowima tí'mai ó'owira'a timíyasa tínkamiyasa puwónááowe. ");
INSERT INTO kze_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","kentávé'o asiramáímo máyáantavesa tíyámba umátinkesa mirámó kwéomba ímo ivátuwesamo kentávésamo asiramáímo méwai Áánútu kawepá'á métinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","moórá-naopa'o méwasamo sáwí'o umátinkewa'o é'a tiyuwé'a isaaisé'a ó'on-daopa'a koró. simátíménda ísáaro. Ísareri-kwaasiti naaó'-nao'a simátíma'mae kwénaaiyana mimbáyáí íma ánásaraindara'a kemá kwaási úranda'a kumpaáruraundawai moórágwara'a kumónaumne. ");
INSERT INTO kze_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ívé-kwaasigo kwéagaraarankaiwaimba íma kwéusayaaitaiye. mayáí-kwáásígó kwená anón-kwaasi íma kwéusayaaitaiye. ");
INSERT INTO kze_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ívé-kwaasigo agaráárankainda-kwaasigomo índantemba íníye. mayáí-kwáásígó kwená anón-kwaasigomo índantemba íníye. miráumai kemá anóndako únasa simái sáwí'a umásinkesa sésa taraváá-kwántóntí kawáánákó áwí'a Píyésepu iyémá kwésewe. mirá kwésemba pósa kesí kwaási simái ávááraumai sáwí'a umátinkanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ísu simásuwena séna mináímbá imáyáa é'a kwaási-taaroi íma inkaisé'a máéro. aúpá'ó kwáyáin-tantaa'a amápa'a avora'á paárínasa awánanaaowe. túnkaipa'a kwáyáin-tantaa'a avora'á paárínasa awánanaaowe. mindáyave'a kwaási-taaroi íma inkáíséro. ");
INSERT INTO kze_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","aúpá'ó simátíménda avora'á simátíméro. keinárawa'o simátíménda-aimba sáwíva-kwaasimo torupenká'á simátíméro. ");
INSERT INTO kze_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","tínkamiya'o puwónááon-kwaasi-taaroi íma inkáíséro. miwí kentimambá íma tínkambai ánásanaaovo Áánútun-aaroiye su'mai inkáíséro. kwemó éna sáwí-marupa'o iramó kwégaindava'a túgwarare timankwáráré tuwáinasa ménaaowe. ");
INSERT INTO kze_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","maarán-áímbá imáyáa oro. sáwíyan-dumama téntékaan-dumama kae'-númámá sáwíyan-ontankakemba siyáánkai-toyaaraamba kwémeyan-ovo Áánútu kíraan-dumama kárákwirena ímo kanaán-iye sínanamo éna íma puwéna marapá'á kumínívo ");
INSERT INTO kze_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","sáwíva'-numama Áánútu aúranka'a íma anón-tantaa'an-ivo kwaási anón-tantaa'a owaná póna kárákwirena amápa-tantaa'a kwéawanena kenti'nótáugwara'a kwétaampamai kwéawanaivo íma táá'a kaíno Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ísu mináímbá simásuwena séna amáparawai túranka'a kentávésa sésa kesí anóndakoman-iye síyawaiyave'a kesivo kwíyómpakewai aúranka'a sé'a kesí kwaásiman-owe sénaumne. ");
INSERT INTO kze_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ánivo kwaási túranka'a kembá tínaaemba umásimiyawaiyave'a kesivo kwíyómpakewai aúranka'a sínaaemba umátimenaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ísu mináímbá simásuwena séna kentávé'a maarán-ímáyáá íma oró. kwaási amápa'a paru umái máyáantavena marapá'á kunkáiye. ímanivo marapá'á kunkáunda kwaási taaínka'a ésa évakarawai kesáái isáíyasa évakarawai aaisambá sénááowe. ");
INSERT INTO kze_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ívékwara aánogwara'a kesááiyavesa maará ónááowe. avowámá moórá-imayaa ínana ááninko ó'on-imayaa íníye. anówama moórá-imayaa ínana ayáámúnko ó'on-imayaa íníye. anáávúkowe ó'on-o'on-imayaa óyááoiye. ");
INSERT INTO kze_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","moóráwai kwenamáárawi kwená namuro-kwáásíráámbá umái ónááowe. kesááiyavesa miráumai miwítí imáyáa taaínka'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ísu mináímbá simásuwena séna kesí kwaási-i'a ónáe síyawai aiva'á tinóvowiye táánimbaare tiyáámúmbaare tirumbá timésa naaémba kembá tirumbá símémba uwóví'an-owe. ");
INSERT INTO kze_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","kemá puwónaunda-taima súgwaata'mae'a kondantembá kesí kwaási-i'a íyawaima umbai-yántáá'á timíyasa minúmbáí-yántáá'á íma maimaésa sínaaemba kwaránááomba uwóví'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","tirááímo táíndai'o ésa íma kawe'á umái ménaaovo kentávésa imáyáa ésa tirááímo táínda-yantaa'a tuwésa puwésa aúnái'a umái kwíyómpa'a maí'mai'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ísu mináímbá simásuwena séna ti'máráandawai kentáái isáíyawai kesááigwara'a isánááowe. kesáái isáiyawai si'mákaiwain-aaigwara'a isánááowe. ");
INSERT INTO kze_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Áánútun-aai simátimindawai évakarawaitopa'a kwínasa sésa Áánútun-aai kwésimatimendawai ónda pó'a enáái isánaumne síyawaima kwésimatimiwaimba Áánútu kawe'-méyámbá aména kwéisaiyawaigwara'a mirám-béyámbá timíníye. arupí umái máyáiwai évakarawaitopa'a kwínasa sésa arupí umái máyaandawai ónda pó'a enáái isánaumne síyawaima arupí umái máyainda-kwaasigomba Áánútu kawe'-méyámbá aména kwéisaiyawaigwara'a mirám-béyámbá timíníye. ");
INSERT INTO kze_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","kesí kwaási awánésa sésa úwoisan-kwaasi imbánivo Ísuna kwaási-i'a uráimba pó'a áwa'naa ónáe sésa sáwíyan-tantaa'a nombá amíyana Áánútu kawe'-méyámbá timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ísu kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi mináyáátáár-áímbá simátímatuwena mimbárává'á tuwéna ó'on-o'on-daopa'a kwenáái kosimátíma'mae kwégwena kwená kawer-ámbá agaráátínkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","agaráátinkowana Yóni ándá-naumpa'a máyonka'a Áánútumo usásinankaiwai Káráísiti ún-aimba iséna kwená kwayó-kwáásí ti'marówasarai Ísunopa'a tésarai ");
INSERT INTO kze_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","áísaa esarai sésarai kumíníyonemo sirááwaiya'ono. á'owawa ónómpo kumíníwaina amu'maránaumno suyaná ");
INSERT INTO kze_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ísu séna tayauwerékai isááyamba awánááyamba Yónimba kosimámekai sékai ");
INSERT INTO kze_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","túramba kavíkáiwai túramba awánamai kawe'á owaná táá'a kaúnkaiwai táá'a kwéisaawana tísamaima pukáiwai kawe'á umái tísamaima kwétaawana túma karáiwai kawe'á kwéumatinkena puwón-kwaasi kwéusasintinkena úwoi-kwaasi áséi-kwasai kwésimatimena séna ");
INSERT INTO kze_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","kentávéna íma kaer-ímáyáá íyawai tirunkó kawe'á kwéiye siyé Yónimba kosimámékaiyo Ísu súwasarai kurááiye. ");
INSERT INTO kze_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yónina kwayó'nákai tayauwerésarai kuyaná Ísu Yónin-aai amápa-kwaasi simátimena séna Yóni kavóná-marava'a máyáísa'a koawáné'a nóran-imayaa kwéera koawánaraao. úndá toréna umá móma'mema'o intenkáán-kwáásí Yónima iyé-ímáyáá uráao. Yóni íma mirán-kwáásímán-ivo asirayán-kwáásímán-iye. ");
INSERT INTO kze_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","nóran-imayaa kwéera koawánaraao. kawer-únánkwátói úmakainda-kwaasi Yónima iyé-ímáyáá uráao. ímanivo mirán-kwáásí kawer-únánkwátóigwara-kwaasi anón-kwaasiti naaúmpa'a kwémaewe. ");
INSERT INTO kze_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","nóran-imayaa kwéera koawánaraao. Áánútun-aai kwésiwai Yónima iyé-ímáyáá uráao. owé Áánútun-aai kwésiwaiman-iye. árai'a simátime'a sé'a kwemá Áánútun-aai siráawai usáyaaitaraiye. ");
INSERT INTO kze_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Áánútun-aai aúváívimba Yónin-aai simái agaimaréna séna Áánútu séna isaaó. moóráwaimba ai'máráanana kesáái maimaéna ená aiva'á kwéna ená aambá kwiyíníye siráiye agaimaréna siráimba Yónintavena siráiye. ");
INSERT INTO kze_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","simátíménda ísáaro. Yóni nombá pétinkaraiwaina mayáígó amápa-kwaasiti mayáígómbá usáyaaitaisana Áánútu kawe'á umánkaraivo Áánútu kwená kwaásira'o kawááin-kwaasi anón-kwaasiye úwoi-kwaasiye anómba kawe'á umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yóni nombá pétinkaraiwai Áánútun-aai simátimindayavena ááimba ásárainkakemba ívékwara'a évakarawai Áánútu kawááipa'a íyóvo sésa aambá itánáe sésa anóm-bayai máyáawasa évakarawai aamoí ésa Áánútu kenká'á kawááinkwae kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","naaóvá'á Áánútun-aai simátímakowaiye Mósesiye Áánútu kwená kwaásimo kawááinimba paáriniye-aimba suwaná naaémba Yóni paáruraiye. ");
INSERT INTO kze_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","naaóvá'á Íráiyaa maémáiwai ókwara'a paáriniye-aimba suwa'á mináímbó siráan-aintave'a áraire sewa'á kemá sé'a Íráiyaantavesamo siráamba Yónintavesa siráawe kwésunda mináíntávé'a áraire seró. ");
INSERT INTO kze_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","kwéisaawai ísámai kawe'á oro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ísu mináímbá simásuwena moórá-ainkwara'a simátimena séna ívé'a máyáan-kwaasi nóran-kwaasiraane sénaumno. mirán-kwáásíráání'a kwéomba iyámpóíyomba naaópa'a marupímbá mésa aávéima kwétesa moórá-ayampa'o máyáan-iyampoi tááyesa imá tiré'a taseró. ");
INSERT INTO kze_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","moórá-iya súna'a íma táásá uráawe. ivi'á taan-íyá súna'a íma ivi'á taráawe. miníyámpóí uráantemba maamáyáan-kwaasi mirá kwéowe. ");
INSERT INTO kze_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yóni nombá pétinkaiwai ména ándá-aran-domba íma kwénena Áánútuntavena ísámai toónkwárá'á íma kwénaisasa kwentávésa sésa taraváá-kwámbá arumpimbá máyáiwaiman-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","kemá kwaási úranda'a kumpaáruraundawai mé'a ándá-aran-donkwara toónkwárá'á kwénaunasa kentávésa sésa ándá-aran-donte toónté námae íyíwaima póna táákísi máyáan-umoyan-kwaasiye sáwí'a on-kwáásítí kwaásiman-iye kwésewe. ánivo Áánútu simátímakaintemba kwéowai sésa Áánútu kawer-ímáyáágwáráwáímán-iye kwésewe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","moórá-mora-tawai Ísu naaó'-nao'a kawe'-máyáí ímo awánaraam-bayai mayówasa awánésa sáwí-mayai íma tuwésa Áánútunopa'o ímo tuntávéna Ísu asiramái séna ");
INSERT INTO kze_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","keinárawa'a Kórásini-naopaken-kwaasiye Pétésáítaa-naopaken-kwaasiye sáwí-meyamba kentópa'a tíníye. naaóvá'ó Táyaa-naaopaken-kwaasiye Sáítóni-naopaken-kwaasiye Áánútun-aaimo ímo ísaraawaivimbo kawe'-máyáí ímo awánaraam-bayaimo kwémayaawandamo awánarekai miwítí sáwí-mayai tukáasino. sáwí-mayaimo tuwésamo úwoi-unankwatoimo úmaesamo kanamó a'mákáankakai Áánútu tuwánaraisino. ");
INSERT INTO kze_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","mindáyave'a simátíménda ísáaro. maarán-ímáyáá kwée'a Áánútu kwaási máyáawaina ááintavena tísaa ínín-kanaa tínímba Áánútu Táyaa-naopaken-kwaasiye Sáítóni-naopaken-kwaasiye sáwí-meyamba anómba timíníye-imayaa kwéowe. ánivo kentí sáwí-meyanko minkáé'-náópakewaiti sáwí-meyankomba usáyaaitaya-sawi-meyamba timíníye. ");
INSERT INTO kze_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kápénéamu-naopaken-kwaasiyono. kentúwí'a mósá maré'a sé'a kwíyómpa'a iyónaumne sembánivo púwón-ayampa'a kónááowe. naaóvá'á Sótómu-naopaken-kwaasivimbo kawe'-máyáí ímo awánaraam-bayaimo kwémayaawandamo awánarekai miwítí sáwí-mayai túwówana póna Áánútu mindáó'a íma ánásasuwowana ívé'a úwoi kwáyáisino. ");
INSERT INTO kze_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","mindáyave'a simátíménda ísáaro. maarán-ímáyáá kwée'a Áánútu kwaási máyáawaina ááintavena tísaa ínín-kanaa tínímba Áánútu Sótómu-naopaken-kwaasi sáwí-meyamba anómba timíníye-imayaa kwéowe. ánivo kentí sáwí-meyanko Sótómu-naopakewaiti sáwí-meyankomba usáyaaitaya-sawi-meyamba timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","minkánáá Ísu Áánútuntavena séna kesivoó kwíyómpakwara mararákwárá'á kárákwiraandawai óne. amápa-tantaa'a kwéisaumne sen-kwáásí íma simátime úwoi-kwaasi simátime ");
INSERT INTO kze_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","mirámó iíyávéna kwéankaisa'a pó'a enáwí'a mósá kwémaraumne Ísu Áánútuntavena siráiye. ");
INSERT INTO kze_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ísu mináímbá simásuwena séna kesivo amápa-tantaaka'a kárákwiyuwo séna símakaiye. amáparawai kesí ááimba íma suwánaraavo kemá kesivo ááninko únana póna kesí ááimba suwánaraiye. amáparawai kesivoná ááimba íma awánaraavo kesivombá pó'a keyáá kwená ááimba awánaraumne. kesivoná ááimba simátimenae únda-kwaasi kanaán-umai kesivona ááimba kwéawanaawe. ");
INSERT INTO kze_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","kentí mayáí umbai-máyáí kwémayaawana kentópa'a umbai-yántáá'á kwáyáiwai kesópa'a tíya'a kentí imáyáa aúnái'a umátínkáana'a paru umái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","kemá kesúma íma maé iyé'a paru umátinkaundawai úna'a pó'a kesí aambá kawe'á umái awáné'a kesáái taagwiyavíya'a kentí imáyáa aúnái'a umátínkáana'a paru umái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","kesááimo taagwiyavónááomba íma umbaí táínana timénaunda-mayai kawe'-máyáímán-iye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","minkánáávímbá Yútaa-kwaasi agándaan-kanaara'a Ísuwe kwená kwayó-kwáásíyé kígauvimba úwíti-ton-kigauvimba kwéguwana kwená kwayó-kwáásí táái tinkówasa úwíti-aramba kútúmai ásima pítuwesa kwénowasa ");
INSERT INTO kze_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ámáán-kawaa-kwaasi tuwánésa Ísuntavesa sésa tuwánaao. agándaan-kanaama aambá áúmbakaawasa mirá kwéowe suwaná ");
INSERT INTO kze_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ísu séna naaóvá'ó Tévítimo urómba aúváívimba agaimarón-ainkona ááimba íma ísaraawe. Tévítiye kwená kwaásiye táái kwétinkowana ");
INSERT INTO kze_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tévíti Áánútuna mono'-náúmpá'á iyéna Áánútu aúranka'o makón-tomba umairéna kwénena kwená kwaási timúwasa naráawe. mintómbá úwoi-kwaasi íma némáembanivo mono'-máyáí máyón-kwaasi némáembani. Tévíti mintómbá umairéna timúwasa nonká'á Áánútu íma áwáá'a siráimbanivo kesí kwaási mirá kwéowa'a áwáá'a ímo seráámbá áwáá'a kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","naaóvá'á Mósesi simátímakain-aimba aúváívinkemba awánaraawe. Áánútuntavesamo ísámaimo póímo tuvú'máímo kwéagayaan-kwaasi anóm-bono'-naumpa'a mayáí kwémaesa agándaan-kanaagwara'a mayáí kwémayaawasa mirámó kwéontavesa íma aaí kwésimatinkesa sésa sáwí'a kwéowe íma kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","simátime'a sé'a keinárawapimba kwémayaunda-mayaigo anóm-bono'-naumpa'o kwémayaam-bayaigomba usáyaaitaraivo agándaan-kanaa mono'-máyáí-kwáásí mayáí kwémayaantave'o ímo sáwí'o kwéowe senkákémbá kesí kwayó-kwáásíyávé'a sáwí'a kwéowe íma seró. ");
INSERT INTO kze_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Áánútun-aai aúváívimba agaimaréna séna Áánútu séna póímo tuvú'máímo agaimáímo símémba kanaán-ivo tirumbó kwéumatinkaamba anón-aamoi kwéune siráimba mináínkóná ááimbo isé'o kwarékai ímo sáwí'o uráan-kwaasi aaivimbá íma maitínkáasino. ");
INSERT INTO kze_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","kwíyómpakemba kwaási úranda'a pó'a agándai-kanaara'o kárákwiraundawai úmpo agándai-kanaara'o kwaásimo mayáí kwémayaamba kendéímán-iye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ísu mivá'á tuwéna mono'-náúmpá'á iyúwana ");
INSERT INTO kze_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","moóráwai ayáámba kawévaiguron-kwaasi máyowasa aaivimbá mayankánáe sésa Ísumba áísaa esa sésa agándai-kanaama mayáí aambá áúmakaan-kanaama póna áí'o in-kwáásí asóvamankai-mayai mayáínda ámáámba araaisíni. íya araaisíníyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ísu tísaa ena séna keinárawapinkemba kentí sipisípi-poraa'o maipímbó pékaina'o é'a agándai-kanaara'a ááéma mósá asinánááoo. owé á'a mirá ónááomba ");
INSERT INTO kze_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","kwaásigo sipisípi-poigomba usáyaaitaraimba póna agándai-kanaa áí'o in-kwáásí asóvamankanimba kawe'á éna ámáámba íma araaisíníye simátímatuwena ");
INSERT INTO kze_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ayáámba kawévaiguron-kwaasiyavena séna enayáámba árútuwaao súwana ayáámba árútuwowana kawe'á umánkowana ó'on-ayaankaamba úwasa ");
INSERT INTO kze_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ámáán-kawaa-kwaasi mono'-náúmpákémbá kumésa Ísumba nóraumaiya tuvuwónaundaya'iyo sésa ámááyu-aimba siráawe. ");
INSERT INTO kze_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ámááyu-aimba sun-táámá Ísu iséna mimbárává'á tuwówasa sáwívarawai kwenánaaemba kwárówana tí'o ún-kwaasi amápa'a asóvamatinkena ");
INSERT INTO kze_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","asiramái séna kemó umátinkaunda-aimba íma simátíméro siráiye. ");
INSERT INTO kze_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","mirámó úmba naaóvá'á Áánútun-aai simátímakowai áwí'a Áísáya sirónka'a póna Ísu mirá uráiye. Áísáya agaimaréna séna Áánútu séna ");
INSERT INTO kze_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","kwembá usásinankaraunana kesí mayáí-kwáásí isa'á kwená imáyáa kwée'a aamoí kwéumanke'a aaí senaná kesimankó kwesé máyainana ó'on-o'on-kwaasi amáparawai kesí arupí-aimba simátimena ");
INSERT INTO kze_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","íma aaisambá tiyéna íma anónka'a séna naaópa'a kwénaaena íma anónka'a séna ");
INSERT INTO kze_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Áánútunopa'o ímo asiramáímo máyáan-kwaasi íma tiyuwéna kawe'á umátinkaniye. mirá úmae iyéna mayáí maimaé iyéna íma ivátuwainana kesí arupí-ainko usáyaaitena kwáyainasa ");
INSERT INTO kze_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ó'onkaa-kwaasi kwenáwí'a isésa sésa árai'a súwa'naa íníwaiman-iye sénááowe Áánútu siráiye sirónka'a póna Ísu mirá uráiye. ");
INSERT INTO kze_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","moóráwai maúmba kwenarumpimbá taraváá-kwámbá máyowana póna minkwáásígó íma aaí kwésuwana aúramba kavíkówasa áí'maesa Ísunopa'a máánkówana Ísu mayauwéna minkwáásígómbá kawe'á umánkowana kwemá aaí súwana aúramba awánówasa ");
INSERT INTO kze_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","sáwívarawai táátavesa ésa sésa mindá'á Tévítin-andarakemba paáriniyemo siráawaiya'i. ó'owa'iyo suwasá ");
INSERT INTO kze_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ámáán-kawaa-kwaasi mináímbá isésa kampa'á sésa ímanivo taraváá-kwántóntí kawááná'á áwí'a Píyésepu asirayámbá ámísana tokéna póna taraváá-kwámbá kwémaitiyuwaiye siráawe. ");
INSERT INTO kze_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","suwaná Ísu miwí tááma iséna simátimena séna moórá-andama áái'a tiyésa pósa taaínkaar-umai mésa íma asiramáívakaamba kwémaewe. moórá-naopara'i. moórá-akuna'i. usíyán-ákúmbá pósa taaínkaar-umai íma asiramáívakaamba kwémaewe. ");
INSERT INTO kze_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sáátáánigona kwaásimo áái'o tiyésamo taaínkaa'o ésamo ésa íma asiramáívakaamba kwémaewe. kentávé'o sembá Píyésepu asirayámbá ámísana tokéna póna taraváá-kwámbá kwémaitiyuwaiyemo kwésemba ");
INSERT INTO kze_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ánivo Píyésepuna asirayánká'ó taraváá-kwámbó kwémaitiyuwaundarakai kentí kwaásigwara'a Píyésepuna asirayánká'á taraváá-kwámbá maitiyúwáásino. mirán-áímbó síyasamo ésa kentí kwaási kampa'á kwésewe sénááowe. ");
INSERT INTO kze_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ánivo kemá Áánútun-amankona asirayánká'á taraváá-kwámbá kwémaitiyuwaundayavena Áánútuna asirayámbá keinárawapimba kwévaarisa'a kwéawanaawe. ");
INSERT INTO kze_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","moórá-aimba imáyáa oro. moóráwai moórá-nanko avowámó asiramáímo máyainanamo éna mindáúmpákémbó umóyámbó mayáindayavenamo éna íma úwoi uveránívo mindánkó avowámbá ánda asááúmankenamo éna uvékena kwená náaindaamba umóyámbá mayáníye. ");
INSERT INTO kze_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","kembá íma kwésuwa'naa-esa kesí namuro-kwáásíráámbá umái kwémaewe. íma súwa'naa esa kwaási torupamái símémba moórá-mora umáguraawe. ");
INSERT INTO kze_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","mindáyave'a simátíménda ísáaro. kwaási sáwí-mayai kwémaesa simái sáwí'a kwéumatinkaamba mindá Áánútu maitiyuwánívo Áánútun-amankontavesa simái sáwí'a umánkanaaomba mindá Áánútu íma maitiyuwáníye. ");
INSERT INTO kze_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","kembá kwaási úrandako kumpaáruraundawaimba simái sáwí'a umásinkanaaomba mindá Áánútu maitiyuwánívo Áánútun-amankontavesa simái sáwí'a umánkanaaomba mindá Áánútu íma maitiyuwéna ívékwara naaénkwara'a íma maitiyuwáníye. ");
INSERT INTO kze_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","kawe-táígó kawer-árámbá íyáísana sáwí-taigo sáwí-aramba kwéiyaivo taaéramba awánésa kawe-táígón-aramban-iye. sáwí-taigon-aramban-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","iyánkó póígon-araa'an-owe. sáwíre su'mai on-kwáásí mé'a pó'a íma kanaán-umai kawer-áímbá kwésewe. tirumpimbá kwáyáin-imayaanei kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","kawe-kwáásí kawer-ímáyáávínkémbá kawe'-máyáí kwémayaavo sáwí-kwaasi sáwí-imayaavinkemba sáwí-mayai kwémayaavo sáwí-kwaasi é'a sáwí-aimba kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","simátíménda ísáaro. Áánútu kwaásimo máyáawaina ááintavena tísaa ínín-kanaa tínímba úwoi-aimbo ó'on-o'on-aimbo siráantavena tísaa íníye. ");
INSERT INTO kze_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","kawer-áímbó sirén-kwaasiyavenamo éna arupí-kwaasiman-owe Áánútu séna sáwí-aimbo sirén-kwaasiyavenamo éna sáwí-kwaasiman-owe síníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","súwasa évaka'a ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé Ísumo sáwí-aimbo sínda isánáe sésa anóndakoo áraira Áánútumpakena kunkáana ímo awánáúnda-mayai máyénata awánaano suwaná ");
INSERT INTO kze_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ísu séna ívé'o máyáan-kwaasi sáwí-kwaasi é'a Áánútuntave'a íma imáyáa é'a kentávé'a kwése'a Áánútumo ai'mákainamo e íma awánáúnda-mayai máyénata awánaanomo kwésemba naaóvá'á Áánútu Yónaambo uráintemba kembá mirá ínívo mináímbá imáyáa oro. ");
INSERT INTO kze_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","naaóvá'ó anón-doyaako Yónaambo nawíkowanamo kaumbo-táwaimo arumpimbó méraintemba kemá kwaási úrandako kumpaáruraundawai kaumbo-táwai maipímbá ménaumne. ");
INSERT INTO kze_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yónaa kaumbo-táwai anón-doyaako arumpimbá máyowana miín-kwituwówana minkákémbá Nínívaa-naopa'a Áánútun-aai kosimátimuwasa isésa sáwí-mayai tuwésa Áánútun-aai ísaraawe. ívé'a Yónaamba usáyaaitaraundawai máyauna'a kesáái íma kwéisaamba póna naaémba Áánútu kwaásimo máyáawaina ááintavena tísaa ínín-kanaa tínímba Nínívaa-naopaken-kwaasi keinárawa'a aaivimbá maitinkésa sésa Yónaan-aai iséta sáwí-mayai tukáundayaanivo Yónaamba usáyaaitaraiwai kentí naaópa'a máyowa'a kwenáái íma isé'a sáwí-mayai íma tukáawe Nínívaa-naopaken-kwaasi sénááowe. ");
INSERT INTO kze_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","naaóvá'á kentíkwá'nára'a kárákwirowai áwí'a Sórómoni kawer-ímáyáávínkémbá aaimá kwésimatimuwana moórá-ininko némpaken-kawaa-ininko Sórómonin-aai koisánáe séna kwémena kuráiye. ívé'a kemá Sórómonimba usáyaaitaraundawai máyauna'a kesáái íma kwéisaamba póna naaémba Áánútu kwaásimo máyáawaina ááintavena tísaa ínín-kanaa tínímba minínínkó keinárawa'a aaivimbá maitinkéna séna kemá némpakemba Sórómonin-aai taísaraumpo Sórómonimba usáyaaitaraiwai kentópa'a máyowa'a kwenáái ísómba íma ísámai kawe'á uráawe síníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ísu mináímbá simásuwena séna kwaási arumpinkémbá taraváá-kwánkó auwéna kavóná-marava'a nombá íma kwáyáipa'a kogwénaaena séna náávara ménaumno séna avakáá uwááena ");
INSERT INTO kze_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","séna tayauweré'a kesí naambá kwaásigo arumpimbá pó'a koménaumne simásuwena téna taawánaimba mindánkómbá kankambá kwiyú'mái kawer-umásukaisana taawánéna ");
INSERT INTO kze_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tayauweréna avakaeté-taravaa-kwamba miwítí sáwí-mayai anómba uráawai tí'maena minkwáásígó arumpimbá tamáyáawana moórá-taravaa-kwamba arumpimbá máyáísana minkwáásígó sáwí'a umái máyáísasa naaémba sáwíva-taravaa-kwamba máyáawana kwemá anómba sáwí'a umái méraiye. miráumai ívé'o máyáan-kwaasi sáwí-mayai kwémaesa anómba sáwí'a úmaesa iyónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ísu kwésimatimumba Ísun-anówawe Ísun-áúnava'maate tésa aaí simámenaaontavesa máápa'a máyówana ");
INSERT INTO kze_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","moóráwai Ísuntavena séna enanówe enáúnava'maare aaí simámenaesa máápa'a máyáawe súwana ");
INSERT INTO kze_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ísu séna kesinó nááwa'iyo. kesúnava'a nááwiya'o séna ");
INSERT INTO kze_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ayáándei kwená kwayó-kwáásí agaráátinkena séna kesinó kesívá'maa'a máyáawe. ");
INSERT INTO kze_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","kesivo kwíyómpakewai siráini'a kwéowai kesinó kesúnava'maa'a kesímánaa'maa'an-owe Ísu siraíye. ");
INSERT INTO kze_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","mitáwai Ísu naaúmpa'a tuwéna Káríri-nonkwaaunkon-awampa'a koména aaí simátimindayavena úwasa ");
INSERT INTO kze_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","sáwívarawai tóyo ésa kwená egwaa'á tamáyóntavena nompí-sípívímbá usámaaisena máyowasa minkwáásíyómbá nonkwaaúnkón-awampa'a máyówana ó'on-o'on-aimba kwántámai simátimakaiye. ");
INSERT INTO kze_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","moórá-aimba simátimena séna moóráwai ánáyumba maimaéna kígauva'a kwégwena ");
INSERT INTO kze_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","máyu'maraisana évakar-anayumba aampa'á kunkwáyáísana numaómá túkúnasukaiye. ");
INSERT INTO kze_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","évakar-anayumba óntankwara'-maravimba kunkwéna paáká'-márávímbá póna avekáán-umai anón-isana ");
INSERT INTO kze_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","aa'á kaisaná amímá ayáátááka'a íma kunkéna aáyánkaguraiye. ");
INSERT INTO kze_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","évakar-anayumba karaampimbá kunkwéna kárúraisana karaan-tantáákó ara'násukaiye. ");
INSERT INTO kze_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","évakar-anayumba kawe'-márávímbá kunkwéna karuwéna anón-éna arambá imái sáwívar-aramba iyéna évaka'a usáyaaitayan-aramba íyáísana évaka'a umaimái-aramba iráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","kwéisaawai ísámai kawe'á oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ísu súwasa kwená kwayó-kwáásí kwenópa'a tésa taáísaa esa sésa kwésimatimenda nóra séwa kwántámai-aimba kwésimatimeno suwaná ");
INSERT INTO kze_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ísu séna Áánútu kwená kwaásimo kawááin-ainkona ááimba kwésimatimunda Áánútu keinárawa'a imáyáa tímísa'a kwéisaavo miwí imáyáa íma tímakaisasa kwéisaantave'a kwántámai-aimba kwésimatimune. ");
INSERT INTO kze_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Áánútun-aaimo ísámaimo kawe'ó íyawai Áánútu túwa'naa ínasa moórá-ainkwara'a isésa mirámó kwéiyanamo éna Áánútu túwa'naa ínasa amápar-ainkwara'a isánááowe. Áánútun-aaimo ímo ísámaimo kawe'ó ésa kampa'á sésa kawe'á umái kwéisaumne síyawaima tirumpinkémbá mináímbá maimayáínana íma kwéniye. ");
INSERT INTO kze_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","kwéisaambanivo íma ísámai kawe'á kwéowe. kwéawanaambanivo íma awánamai kawe'á kwéowe. mirámó kwéontave'a simátimunda kwántámai-aimba kwésimatimune. ");
INSERT INTO kze_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","naaóvá'á Áánútun-aai simátímakowai áwí'a Áísáya siráimba miwí mirá kwéowe. Áísáya séna kwéisaambanivo íma ísámai kawe'á kwéowe. kwéawanaambanivo íma awánamai kawe'á kwéowe. ");
INSERT INTO kze_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","miwítí imáyáao umbaí kwétaisana tááko aaimó isáíyávéna ávón-kaisaná túranko awánaiyavena ávón-kwégaivo ímo mirámó ésamo ésa táá'o isésamo túrambo awánésamo kesááimo isésamo miwítí sáwí-imayaamo tuwésamo kesópa'o tenkákáí sáwí-imayaa maitiyuwé'a kawe'á umátinkausino Áánútu siráiye Áísáya agaimaréna siráimba Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ísu mináímbá simásuwena séna simátime'a sé'a keinárawa'a kawe'ó umáímo awánaamba Áánútu kawe'á kwéumatinkaiye. kawe'ó umáímo ísáamba Áánútu kawe'á kwéumatinkaiye. ");
INSERT INTO kze_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","simátíménda ísáaro. naaóvá'á Áánútun-aai simátímakowaiye arupí umái máyówaiye sáwíva-kwaasi keinárawa'o kwéunda-mayai kwéawanaanten-umai awánanae sésa umbá íma awánaraawe. miwí keinárawa'o kwéisaanten-umai isánáe sésa umbá íma ísaraawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ísu kwená kwayó-kwáásíyávéna simátímatuwena séna moóráwai ánáyumba tu'makáin-ainkona ááimba súnda ísáaro. ");
INSERT INTO kze_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Áánútu kwená kwaásimo kawááin-aimba isésa íma ísámai kawe'á kwéowana Sáátáánigo téna tirumpinkémbá tamaimái úwoiva'a kwétiyuwaiye. minkwáásí aampa'á kunkwáyáin-anayunkaamba kwéowe. ");
INSERT INTO kze_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ánáyumbo óntankwara-maravimbo kúmímba maarán-ááímbán-iye. Áánútun-aai isésa aamoí ombánivo ");
INSERT INTO kze_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","íma tirumpimbá táto'mai kawe'á owasá Áánútun-aaiyavesa umbai-yántáárí'a umátinkaantavesa Áánútun-aai ivátukaawe. ");
INSERT INTO kze_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ánáyumbo karaampimbó kúmímba maarán-ááímbán-iye. Áánútun-aai ísáámbanivo marapár-úmbáí-yántáátávésa imáyáa úmae naaésa óísan-imayaama úmae kwénaaesa mirán-ímáyááó Áánútun-aai káátasuwaisasa íma Áánútuna mayáí kwémayaawe. ");
INSERT INTO kze_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ánáyumbo kawe'-márávímbó kúmímba maarán-ááímbán-iye. Áánútun-aai isésa tirumpimbá táto'mai kawe'á ésa asiramái mésa Áánútuna mayáí kwémaesa kwétuwa'naa-owasa évakarawai usáyaaitamai-mayai kwémaesa kwétuwa'naa-owe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ísu mináímbá simásuwena séna Áánútu kwená kwaásimo kwégawaain-aimba maarán-áímbán-iye. moóráwai kwená kígauva'a kawer-ánáyúmbá áwí'a úwíti-anayumba u'makáisana ");
INSERT INTO kze_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","moórá-no'waamba amááraawigwara'a tuún-kwaiguráawana namuro-kwáásígó téna arambó ímo íyáí-uwitiraan-anayumba sáwí-anayumba avuvumpimpá'á u'makáisana ");
INSERT INTO kze_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","úwíti anón-éna arambá íyáísana úwítiraan-damai u'makáiwai anón-isasá ");
INSERT INTO kze_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","mayáí-kwáásí awánésa kígaugo avowánópa'a tésa sésa kawer-ánáyúmbá u'makáandavimba úwítiraan-damai náávakena mimpímbá kwáyáivo sewaná ");
INSERT INTO kze_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","séna namuro-kwáásígó mau'makáiye sisasá áísaa esa sésa táúyuwanaumne sewaná ");
INSERT INTO kze_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","séna ímanivo úwíti táúyuwaavainivo túwéwana ");
INSERT INTO kze_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","kwáyainana naaémba úwíti karepáína'a toómbó akaránááowaiyave'a senasá misáwí-úwítíráán-dámáí táúmai asááumai iramá kwégaindava'a tuwésa úwíti úramba áká'mai kesí toón-dáúmpá'á maránááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Ísu maarán-áínkwárá'á simátimena séna Áánútu kwená kwaásimo kwégawaaain-aimba maarán-áímbán-iye. moóráwai sáwíyan-taeranko áwí'a másátati mintáígó arambá ímo ane'ó awánaraan-taeramba kígauva'a u'makáawana anón-éna amaimá móivarena kóyáwé uráisana numaómá mimpímpá'á ánáamba úmarena kwémaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ísu maarán-áínkwárá'á simátimena séna Áánútu kwená kwaásimo kwégawaain-aimba maarán-áímbán-iye. moórá-ininko péréti-tomba agayánáe séna kanaráán-tántáákó áwí'a páráwaa'a maimaéna intoráí-yántáá'á sáwíyan-tantaa'a ayáúmaraisana kwéna intoréna anón-kwéiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ísu kwaásiyomba aaí simátimenae sénamo úmba íma avora'á siráivo kwántámai-aine su'mai simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","naaóvá'á Áánútun-aai simátímakowai sirónka'a póna Ísu mirá uráiye. kwemá agaimaréna séna simátíménda kwántámai-aimba simátimenaumne. Áánútu maramá tarórurainka'a aúpá'ó kwáyom-bayaigon-aai ímo ísaraan-aimba simátimenaumne siráiye agaimaréna siráimba Ísuntavena siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ísu mináímbá simátímatuwena tiyuwéna naaúmpa'a iyúwasa kwená kwayó-kwáásí kwenópa'a tésa sésa namuro-kwáásígómó moóráwaina kígauva'o sáwí-anayumbo kwéu'maraiwaina ááimba simásimiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ísu séna kawer-ánáyúmbó u'makáiwaina ááimba kemá kwaási úrandako kumpaáruraundawai úne. ");
INSERT INTO kze_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kígaugona ááimba maramán-iye. kawer-ánáyúnkóná ááimba Áánútu kwená kwaásimo kawááin-kwaasiman-owe. sáwí-anayunkona ááimba Sáátáánigona kwaásiman-owe. ");
INSERT INTO kze_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","namuro-kwáásígó sáwí-anayumba u'makáiwaina ááimba Sáátáánigon-iye. toómbó akaránááon-kanaaona ááimba maramó ánásanin-kanaaman-iye. toómbó akaránááowaina ááimba Áánútuna kwayó'ná'á kwíyómpakewaiman-owe. ");
INSERT INTO kze_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","námáímo áú'maimo iravímbó agaisuwánááontemba naaén-kanaamo tínda mirá ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","kwaási úrandako kumpaáruraundawai kesí kwayó'nárawa'a kwíyómpakemba ti'máráanasa kesí kwaásivinkemba sáwí-kwaasi ó'owima sáwí-imayaa tíméwasa sáwí-amba kwégwaraawai kuntúkúmai ");
INSERT INTO kze_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","iramó kwégaipa'a tiyuwáíyasa mésa ivi'á tésa túwááyaamba akévundarewasa ");
INSERT INTO kze_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","arupí umái máyáawai Áánútu kentivo kawááipa'a mésa aa'ó kwégaintemba mirá ónááowe. kwéisaawai ísámai kawe'á oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ísu maarán-áínkwárá'á simátimena séna Áánútu kwená kwaásimo kwégawaain-aimba maarán-áímbán-iye. ó'oran-ontamba maravímbá utámarena ména pukáisana moóráwai téna taawánéna aamoí éna káátamarena mimbárámá meéyámbá íníntavena kwená óísamba maimái tímatuwena óntamba mairéna mimbárámá komeéyán-éna minó'órán-óntámbó ásámakaamba mairáiye. ");
INSERT INTO kze_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Áánútu kwená kwaásimo kwégawaain-aimba maarán-áímbán-iye. moóráwai ameriyáámba meéyámbaraindayavena naaó'-nao'a kwénaaena ");
INSERT INTO kze_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","awánáínda moóráwai ó'oran-ameriyaamba makáinana awánéna kwená óísamba maimái kwétimena óntamba mairéna minó'órán-áméríyáámbá komeéyán-umai kwémayaiye. ");
INSERT INTO kze_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Áánútu kwená kwaásimo kwégawaain-aimba maarán-áímbán-iye. kwasen-únánkáámbá moóráwai nompímbá túwáísana ó'on-o'on-doyaa'a ");
INSERT INTO kze_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","minúnámpímbá ógwitagwisana asináíndayavena umái kwéawanaisasa évakarawai áwa'naa umai asímbai áámááíva'a makésa kawe'-nóyáá'á unáámpímbá áítesa sáwí-noyaa'a ivá'á kwétuwaawe. ");
INSERT INTO kze_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","naaén-kanaa tínímba mirá íníye. kwíyómpaken-kwayo'narawa'a kawe-kwáásívínkémbá sáwí-kwaasiyomba tí'mai ");
INSERT INTO kze_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","iramó kwégaindava'a tuwáíyasa ivi'á tésa tí'o íníntavesa túwááyaamba akévundanaaowe simásuwena ");
INSERT INTO kze_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","kwená kwayó-kwáásíyávéna tísaa ena séna simátimunda-ainkona ááimba ára isaaó súwasa owé suwaná ");
INSERT INTO kze_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ísu simátimena séna ísáamba simátimunda-aimba simátíméro. moóráwai naankó avowá kwená naaúmpa'a ááéraan-tantaare aúná-yantaare kwáyáísana taaímbai kwená kwaási kwétimiye. mindánkó avowámó kwétimintemba miráumai ááéraam-bonor-aimpinkene Áánútu kwená kwaásimo kwégawaain-aimpinkene simátíméro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ísu mináímbá simátímatuwena mimbárává'á tuwéna ");
INSERT INTO kze_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kwenamáápa'a kúmba miwítí mono'-náúmpá'á iyéna aaí simátimuwasa táátavesa ésa sésa náávakena kawer-ímáyáá mairéna kawer-áímbá kwésimasimenayaawa nááwawa asirayámbá ámísana kawe'-máyáí ímo awánáúnda-mayai kwémayaiyo. ");
INSERT INTO kze_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","kesáámó awánáúnda taaineí évaka-tantaa'o kwéiwai ááninkoman-iye. Máríyaa áánimba éna Yémési Yósépi Sáímoni Yútási tuwaaómán-iye. ");
INSERT INTO kze_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","kwenáúnava'a maanká'á máyáawe. ");
INSERT INTO kze_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","maankákéwáímá póna úwoi-kwaasiman-ivo náávakena mináímbá isénawa minásíráyámbá mairénawa kwésiyo sésa kayorésa tínaaemba umámúwana Ísu simátimena séna Áánútun-aai simátímíwai ó'on-o'on-daopa'a kwénaaisasa kwenáwí'a mósá kwémaraavo kwená naaópa'a komáyáimba kwenamááraa sésa kesáámó úndanten-kwaasiman-iye sésa kwenáwí'a íma mósá kwémaraawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","kesáámó úndanten-kwaasi póna íma súwa'naa íníye suntávéna ímo awánom-bayai moórá-mora-mayaiye su'mai mairáiye. ");
INSERT INTO kze_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","minkánáá Ísuna mayáígón-áái símae íyúwana Káríri-marara-kawaanako áwí'a Éróti mináímbá iséna ");
INSERT INTO kze_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","kwená mayáí-kwáásíyávéna séna minkwáásígó Yóni nombó pétinkaraiwaiman-iye. pukáimpinkemba usásinkena póna asirayámbá kwempímbá kwáyáísana mirám-báyáí kwémayaiye sirái. ");
INSERT INTO kze_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","ááéma Éróti kwenáváko awainínkómbá áwí'a Erotíyasimba mairówana Yóni séna enáváko awainínkómbá aambá áúmbakaawa mayááne simá-sima'a úwana Éróti ti'marówasa Yónimba koáí'maesa ándáva'a máánkarowana ");
INSERT INTO kze_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Éróti Yónimba inkamónáe súmba kwaási-taaroi inkaiséna íma inkánkaiye. kwaási Yónintavesa sésa Áánútun-aai simátímíwaiman-iye suwaná Éróti séna Yónimba inkámónasa áwáá'a siyénááowe séna íma inkaména máyowana ");
INSERT INTO kze_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","kwembó ánkaron-kanaamo túwana anón-tanomba kaumái sáwíva-kwaasi tímúwasa nowaná Erotíyasi ayáámúnko téna túranka'a araimá marówana Éróti aamoí umánkena ");
INSERT INTO kze_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","minárásígóntávéna séna nóin-tantaatavena ankáíya simásímína'a áméno. árai'a súnda pó'a sísaina'a áméno súwana ");
INSERT INTO kze_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","anówamba koáísaa ena súwana anówama aaí súwana Érótinopa'a téna séna Yóni nombá pétinkaraiwai a'nómbá ará'mái táávepimba maré simiyó súwana ");
INSERT INTO kze_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","iséna arumbá kwéumbanivo aiva'á asirayán-áímbá siráin-aimba imáyáa éna toómbó naan-kwáásígwárá'á ísaraantavaiye séna íma a'áo sénáe séna ");
INSERT INTO kze_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","moóráwaimba ai'marówana ándávinkemba Yónimba anumarambá ará'mái a'nómbá ");
INSERT INTO kze_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","táávepimba maréna maimaéna minárásígómbá máamuwana maimaéna anówamba máamuwasa ");
INSERT INTO kze_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yónina kwayó-kwáásí isésa anómba komaimái utamánkesa Ísunopa'a tésa tasimámakaawe. naaémba Éróti Ísuna mayáígón-áái iséna séna minkwáásígó Yóni nombó pétinkaraiwai éna pukáimpinkemba usásinkena póna asirayámbá kwempímbá kwáyáísana mirám-báyáí kwémayaiye Éróti siráiye. ");
INSERT INTO kze_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yóni puwómba kwená kwayó-kwáásí Ísumba simámúwana iséna tuwéna kwená kwayó-kwáásíyé nompí-sípívímbá usámaaisena kwaásimo ímo máyaiyapata kónáe séna kúmba naaó'-naokewai mináímbá isésa marapá'á kóyo uwaná nompí-sípívímbá kwéna ");
INSERT INTO kze_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","marapá'á ásávomba misáwívá-kwáásí tuwánéna arumbá umátinkena tí'o ún-kwaasi asóvamatinkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ísu asóvamatinkowasa enónka'a kwená kwayó-kwáásí kwenópa'a tésa sésa íma sáwíva-kwaasi máyáapa'an-ivo enáíndara'a ti'márénasa egwaa'-náópimpa'a kwénaaesa toómbá meéyámbáráaro suwaná ");
INSERT INTO kze_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ísu séna toóntáá'a íma kwíya'a toómbá tíméro súwasa ");
INSERT INTO kze_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","miwí sésa sáwíyan-tomba éva'aasei-tonkwara kae'-nóyáákwárá'á kwáyáivo sáwíva-kwaasivimba íma kanaán-íníye suwaná ");
INSERT INTO kze_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ísu maimaé másíméro séna ");
INSERT INTO kze_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","sáwíva-kwaasiyavena mara'á máéro séna éva'aasei-tonkwara kae'-nóyáákwárá'á maisokéna kwíyómpa'a karákéna Áánútuntavena súwi simásuwena mintómbá topán-topan-umai kwená kwayó-kwáásí timúwasa misáwívá-kwáásí tímúwasa ");
INSERT INTO kze_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","amáparawai nowaná tímú'a vówasa sáwíva-kwaasi 5,000 kwaaima uwasá aaraiyé iyámpóígwarare miráumai-kwaasi nowaná tímú'a vówasa Ísuna kwayó-kwáásí mintón-ayai sísamaivakemba kae'á kumbaimái-unampimba áítumai ógwitaraawe. ");
INSERT INTO kze_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","áítumai ógwitowana minkákémbá Ísu kwená kwayó-kwáásí ti'maréna séna kesí aiva'á nompí-sípívímbá usámaaise'a menávápá'-náópa'a koró. misáwívá-kwáásí kwéti'mare'a sé'a kentí naaó'-nao'a koró simátimenaumne séna ");
INSERT INTO kze_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","misáwívá-kwáásí ti'marówasa miwítí naaó'-nao'a kuwaná Áánútumpa'a námúnaamo síndayavena omápa'a umáyowana no'wáámba aúkúwana Ísu kweyáá máyowasa ");
INSERT INTO kze_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kwená kwayó-kwáásí nompí-sípívímbá non-avuvumpá'á máyówana maramá nénka'a kwáyowana anón-unda to'maé kwétena misípí tayáto'marowasa íma kumbá ");
INSERT INTO kze_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","irataró'a Ísu non-avóvomayaapa'a kwénaaena kwená kwayó-kwáásímó máyónka'a túwasa ");
INSERT INTO kze_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","non-avóvomayaapa'o kwénaaumba awánésa táátavesa ésa tiyántámbá kwétowasa sésa kwaántáo kwénaaiye suwaná ");
INSERT INTO kze_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ísu avekáán-umai séna táá'a kaivó aáno máéro. kemá úne súwana ");
INSERT INTO kze_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pítaa simámena séna emó Ísóigo úrambo éma sina'á non-avóvomayaapa'a emó máyaandava'a konó súwana ");
INSERT INTO kze_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ísu séna kanaán-ivo tiyó súwana nompí-sípívínkémbá kunásávena non-avóvomayaapa'a Ísumo máyopa'a kúmba ");
INSERT INTO kze_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kawe'á umái kúmba anón-undamo toróntavena imáyáa éna inkaisúmba nompímbá kunávekora'nara kwéena anónka'a séna Ísóigoo kembá tátoraao súwana ");
INSERT INTO kze_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ísu avekáán-umai ayáámba árú'mai tátorena séna anón-undamo toráintavai sáwí-imayaa e kesí asirayántávémo ímo imáyáamo óndayavai kunáveraane. kesí asirayántáváí íma kaer-ímáyáá uwo súwasarai ");
INSERT INTO kze_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","nompí-sípívímbá usámaaisewana anón-undao maivaiyówasa ");
INSERT INTO kze_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","nompí-sípívímbá máyówai Ísuna imáyáa mósá marésa sésa árai'a Áánútu ááninko óne siráawe. ");
INSERT INTO kze_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","árai'a Áánútu ááninko óne sésa kwaaúnóná menávápá'á Kénésáréti-marava'a kumbá marapá'á ásávowasa ");
INSERT INTO kze_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","mimbápákén-kwáásí Ísumba aúyésa naaó'-nao'a simátimesa Ísumo tamaún-aimba isésa tí'o ún-kwaasi tí'maesa tóyo ésa ");
INSERT INTO kze_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","sésa ená unáánkwátói-araaira'a tátoraiyana tí'a étinkainkwae suwasá tátórówana tí'a étínkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé Yérúsaremu-naopakemba Ísumo máyopa'a tésa sésa ");
INSERT INTO kze_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ená kwayó-kwáásí nóra isasá kentáá síkwá'náí ámáámba íma kwarésa tiyáámba íma sese ombá toómbá kwénaao suwaná ");
INSERT INTO kze_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ísu séna kentíkwá'námo simátímakaan-amaamba kwaré'a Áánútuna ámáámba kwéaraaisemba nóra éra mirá kwéoo. ");
INSERT INTO kze_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Áánútu séna kentinóvowi túwí'a anómba oró. ánivo anóvowimo sáwíkaambo simátinkaindawaimba tuvuwíyana puwíníye Áánútu siráivo ");
INSERT INTO kze_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","keinárawa'o siráamba moóráwai anóvowiyavena simátimena séna moórá-yantaa'a Áánútundeiman-ivo íma kanaán-umai timénaumne siréna anóvowima íma kwétuwa'naa-iye. mirámó ontávé'a kanaán-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mirá-sáwí'ó ontávé'a Áánútun-aai tuwé'a kentíkwá'náí ámáámba kwégwaraawe. ");
INSERT INTO kze_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","kaumbo-káér-ainkwara-kwaasin-owe. naaóvá'á Áánútun-aai simátímakowai áwí'a Áísáya keinárawatavena árair-aimba siráimba agaimaréna séna Áánútu séna ");
INSERT INTO kze_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","maawímá kesúwí'a tóikakene su'mai sésa kesí imáyáa íma tirumpimbá kwáyáiye. ");
INSERT INTO kze_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","kwaásiti ámáámba simái paárombanivo Áánútuna ámáámban-iye kampa'á sembá miráráán-umai kesí imáyáa kampar-ímáyáá mósá kwémaraawe Áánútu siráiye Áísáya simái agaimakáiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ísu mináímbá simátímatuwena kwaásiyavena teró súwasa kwenópa'a tuwaná séna simátíménda isé'a kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","máápaken-tantaa'o naawáí íma kwaási sáwí'a kwéumatinkaivo tirumpinkén-áínkó kwaási sáwí'a kwéumatinkaiye siráiye. ");
INSERT INTO kze_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","súwasa Ísuna kwayó-kwáásí kwenópa'a tésa sésa ámáán-kawaa-kwaasi emó simátimenda-aimba isésa áwáá'a aéésa kayóráamba íya isaánó suwaná ");
INSERT INTO kze_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ísu séna kesivo kwíyómpakewai ímo u'makáin-anayumbo éna táúyuwaniye. ");
INSERT INTO kze_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ámáán-kawaa-kwaasi tááiyave'a íma anón-imayaa oró. miwí ímo aambó awánaakakemba tóikakemba kampa'á simátimesa sésa aambá agaráátinkanaumne kwésewe. moórá aúgavitawai moórá aúgavitawaimba ayáán-to'maesarai íma kanaán-umai kóyááoivo mirámó ésaraimo ésarai maipímbá koyuvánkoyaaoiye súwana ");
INSERT INTO kze_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pítaa séna kwántámai-aimbo simátimenda-ainkona ááimba simásimiyo súwana ");
INSERT INTO kze_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ísu séna kenkwárá'á íma tááko pééi kwésisa'a mé'a ísáambanivo íma ísámai kawe'á uráawe. ");
INSERT INTO kze_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","máápaken-tantaa'o naawáí tindáámpá'á kunáyúsúgwinivo ");
INSERT INTO kze_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","aaimó kwésemba tirumpinkén-ímáyááó éna mindá kwaási sáwí'a kwéumatinkaiye. ");
INSERT INTO kze_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","tirumpin-ímáyáávínkémbá sáwí-imayaa ésa tínkamiyasamo puwónááoni'a ésa aarai-úmóyámbá ésa kwaai-úmóyámbá ésa amápa-tantaa'a umóyámbá ésa kampar-áímbá simátinkesa simái sáwí'a umátinkesa ");
INSERT INTO kze_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","mirá-sáwí'ó kwéomba tirumpinkén-ímáyááó kwaási sáwí'a kwéumatinkaivo tiyáámbo ímo sese ombó toómbó kwénaamba mindáo kwaási íma sáwí'a kwéumatinkaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ísu mináímbá simásuwena kwená kwayó-kwáásíyé mivá'á tuwéna Táyaa-naopare Sáítóni-naopare mináyámpá'á kúmba ");
INSERT INTO kze_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","mináyámpákén-ínínkó íma Yútaa-inimba póna Kénááni-ininko Ísunopa'a téna anónka'a séna anóndakoo Tévítin-andarakewai arumbá umásinkaao. taraváá-kwámbá kesiyáámúnko arumpimbá máyáísana sáwí'a umái máyáiye súwana ");
INSERT INTO kze_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ísu iséna íma aaí súwasa kwená kwayó-kwáásí kwenópa'a tésa asiramái sésa ai'mátuwaao. aasiyaasí mirá siváínivo suwaná ");
INSERT INTO kze_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ísu séna Áánútu si'mákaisa'a Ísareri-kwaasiye su'mai túwa'naa e'a Ísareri-kwaasimo sipisípi-poiraan-umaimo kóyáwé kwéowai kwétuwa'naa-une súwana ");
INSERT INTO kze_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","minínínkó Ísun-aóka'a mara'á kumbaéna séna anóndako súwa'naa uwo súwana ");
INSERT INTO kze_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ísu séna iyámpóíti toómbá maimái iyámbá timúnavo miráumai Ísareri-kwaasimo túwa'naa úndantemba emá ó'onkaa-inimba ónda pó'a áwa'naa únavo kwésune súmbanivo ");
INSERT INTO kze_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","minínínkó séna anóndako árai'a sémpo iyánkó avowá owé sisaná toón-ayai takwémandaiye. miráumai ó'onkaa-ininkoman-iye sinaná kanaán-ína súwa'naa íníyone súwana ");
INSERT INTO kze_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ísu séna kentáváí asiramái máyaanda-ininko sénda pó'a mirá ónaumne séna mitáwai ayáámúnkomba asóvamankaraiye. ");
INSERT INTO kze_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","asóvamankena kúmba Káríri-kwaankon-awampa'a koúkúmai omápa'a mara'á umáyowasa ");
INSERT INTO kze_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","sáwíva-kwaasi kwemó máyopa'a kumbá tísamaimo tausokón-kwaasiye tiyáántámbo mavíkuron-kwaasiye túrambo kavíkón-kwaasiye aaimó ímo sun-kwáásíyé ó'on-o'on-ti'o ún-kwaasi tí'maesa kwenaísamaivimba mótinkowana asóvamatinkowasa ");
INSERT INTO kze_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","tísamaimo tausokón-kwaasi kawe'á uwasá tiyáántámbo mavíkuron-kwaasi kawe'á uwasá túrambo kavíkón-kwaasi kawe'á umái awánowasa aaimó ímo sun-kwáásí aaí suwasá misáwíváráwáí awánésa ávááraumai táá'a kówasa Ísareri-kwaasiti Ísóigo áwí'a mósá makáawe. ");
INSERT INTO kze_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Áánútu áwí'a mósá marówana Ísu kwená kwayó-kwáásí tááyowasa tuwaná séna maankwáásíyómbá kaumbo-táwai kesé máyáawana maimaésa tiráan-tomba ánásaisa'a sirumbá kwéumatinkaumne. ti'máráanasa miwítí naaó'-nao'a kónááombanivo aampa'á kwíyamba kánoka'a pósa púwóvainiye súwasa ");
INSERT INTO kze_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","kwená kwayó-kwáásí sésa kavóná-marava'a sáwíva-kwaasin-ovo náánkakenta toómbá maimáíya timénaumno suwaná ");
INSERT INTO kze_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ísu tísaa ena séna nóraumai-tona kwáyáiyo súwasa avakaeté kwáyáísana esimáí-noyaakwara'a kwáyáiye suwaná ");
INSERT INTO kze_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","minkwáásíyóntávéna séna mara'á máéro séna ");
INSERT INTO kze_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","avakaeté-tone noyááre maisokéna Áánútuntavena súwi séna mintómbá topán-topan-umai kwená kwayó-kwáásírá'á timúwasa minkwáásíyómbá tímúwasa ");
INSERT INTO kze_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","amáparawai nowaná tímú'a vówasa sáwíva-kwaasi 4,000 kwaaima uwasá aaraiyé iyámpóígwarare miráumai-kwaasi nowaná tímú'a vówasa kwená kwayó-kwáásí mintón-ayai túwómba avakaeté-unampimba áítumai ógwitowana ");
INSERT INTO kze_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ísu misáwívá-kwáásí ti'maréna kwená kwayó-kwáásíyé nompí-sípívímbá usámaaisesa Mágátani-ayampa'a kuráawe. ");
INSERT INTO kze_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","mivá'á Ísu máyowasa ámáán-kawaa-kwaasiye Sátúsi-monor-aimbo sun-kwáásíyé Ísumo sáwí-aimbo sínda isánáe sésa Ísunopa'a tésa sésa áraira Áánútumpakena kunkáana ímo awánáúnda-mayai máyénata awánaano suwaná ");
INSERT INTO kze_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ísu séna enáínka'o awánaamba aaváúmá naaerírí'a vaisa'á sé'a aaváyaavimba aa'á káníye sé'a ");
INSERT INTO kze_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","aaváyaavimba awánaamba ainánkó aaváúmá káátasuwaisa'a sé'a ívé'a aa'á tíníye kwésewe. kwíyómpa'o awáné'o ombá sé'a aa'á káníye. aa'á tíníye kwésemba mirán-tántáákóná ááimba awánaambanivo Áánútumo ívé'o kwéin-tantaakona ááimba íma awánaraawe. ");
INSERT INTO kze_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ívé'o máyáan-kwaasi sáwí-kwaasi é'a Áánútuntave'a íma imáyáa é'a kentávé'a kwése'a Áánútumo ai'mákainamo e íma awánáúnda-mayai máyénata awánaanomo kwésemba naaóvá'á Áánútu Yónaambo uráintemba kembá mirá ínívo mináímbá imáyáa oró. naaóvá'ó anón-doyaako Yónaambo nawíkowanamo kaumbo-táwaimo arumpimbó méraintemba kemá kaumbo-táwai maipímbá ménaumne Ísu séna tiyuwéna kuráiye. ");
INSERT INTO kze_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","tiyuwéna kúmba Ísu kwená kwayó-kwáásíyé nonkwaaúnkóná menávápá'á kumbá marapá'á ásávesa kwená kwayó-kwáásí péréti-tomba íma máyómba tuwinkésa kuwaná ");
INSERT INTO kze_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ísu ámáán-kawaa-kwaasiye Sátúsi-monor-aimbo sun-kwáásíyé kaumbo-káér-ainkwara-kwaasi owé-ímáyáá kwéena kwená kwayó-kwáásí simátimena séna intóráín-tantaa'a sáwíyan-tantaa'a moórá-tonko áwí'a péréti mimpímbá kwémaraawana kwéintorena anómba intembá ámáán-kawaa-kwaasiye Sátúsi-mono-kwaasiyavaiye imáyáa é'a kentúma kárákwimai máéro súwasa ");
INSERT INTO kze_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","keáímbá sésa nóra séna mirá kwésiyo. péréti-tomba íma maimaéta túnanaya mirá kwésiye suwaná ");
INSERT INTO kze_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ísu keáímbó kwésun-aimba iséna nóra séra toómbá íma kwáyáiye-aimba kwéseo. kentávé'a íma sáwíyan-imayaa é'a anón-imayaa oró. ");
INSERT INTO kze_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","kanaán-umai toómbá timénaunda ááémo uráundawaina ááimba íma tááko pééi kwésiye. éva'aasei-tomba topán-topan-umai sáwíva-kwaasi 5,000 kwaasi timéwánasa naráamba mintón-ayai nóraumai-unampina áíturaawara kemó uráundawaina ááimba íma awánaraawe. ");
INSERT INTO kze_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","avakaeté-tomba topán-topan-umai sáwíva-kwaasi 4,000 kwaasi timéwánasa naráamba mintón-ayai nóraumai-unampina áíturaawara kemó uráundawaina ááimba íma awánaraawe. ");
INSERT INTO kze_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ámáán-kawaa-kwaasiye Sátúsi-mono-kwaasiyavaiye imáyáa é'a pérétimo intóráin-tantaatave'a kentúma kárákwimai máéro-aimbo súnda íma péréti-tontave'a kwésumpo nóra éra íma ísaraao súwana ");
INSERT INTO kze_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tááko pééi súwasa mináínkóná ááimba ísówana péréti-tontavena íma siráivo ámáán-kawaa-kwaasiye Sátúsi-mono-kwaasiye tááiyavena séna kárákwimai máéro siráiye. ");
INSERT INTO kze_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ísu Sísáriya Vírípai-naokon-ayampa'a kúmba kwená kwayó-kwáásí tísaa ena séna kemá kwaási úrandako kumpaáruraundawaintavesa amáparawai kentávésa nóran-kwaasiye kwéseo súwasa ");
INSERT INTO kze_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","miwí sésa évakarawai sésa emá Yóni nombá pétinkaandawai óne sewasá évakarawai sésa naaóvá'á Áánútun-aai simátímakaandawai áwí'a Íráiyaama óne sewasá évakarawai naaóvá'á Áánútun-aai simátímakaandawai áwí'a Yérémaya óne sewasá évakarawai sésa naaóvá'á Áánútun-aai simátímakaawaivinkemba moóráwai óne kwésewe suwaná ");
INSERT INTO kze_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ísu séna keinárawa'a kentávé'a nóran-kwaasiye kwéseo súwana ");
INSERT INTO kze_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sáímoni Pítaa séna Áánútumo usásinankaiwaima Yútaa-kwaasiya kwéamu'maraundawaiya óne. Áánútu asirayánkwáráwáí ááninko óne Pítaa súwana ");
INSERT INTO kze_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ísu séna Sáímoni Yónaa ááninkoma ónana Áánútu kawe'á kwéumankaiye. kesí ááinkona ááimba sénda kwaási íma simámévo kesivo kwíyómpakewai mináímbá embá simámísa isáánda póna Áánútu embá kawe'á kwéumankaiye. ");
INSERT INTO kze_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","simátime'a sé'a enáwí'a Pítaawemo kwésemba mináwíkóná ááimba óntamban-iye. anón-ontanka'a kesí naankáámbá ónaunda mindánkáámbá kesí kwaási-i'a owaná púwón-asirayanko íma usáyaaitaniye. ");
INSERT INTO kze_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Áánútu kwená kwaásimo kwégawaain-asirayamba áména marapá'ó máyaanda sáwí'o ombá aambó aunóndanten-umai Áánútu kwíyómpa'a ména á'a aambá áúmbakaiye. kawe'ó ombá ímo aambó aunóndanten-umai Áánútu kwíyómpa'a ména á'a mirá uráiye simásuwena ");
INSERT INTO kze_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","kwená kwayó-kwáásíyávéna asiramái séna Áánútumo usásisinkaiwaima Yútaa-kwaasi kwésimu'maraawai úne-aimba íma simátíméro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","minkánáá Ísu kwemó puwínín-aimba ááimba ásámai kwená kwayó-kwáásí simátimena séna Yérúsaremu-naopa'a kondá Yútaa-anon-kwaasiye mono-káwáá-kwáásíyé ámáámba sen-kwáásíyé sí'a índai'a umásinkesa sínkamiya'a puwónaundanivo kaumbo-táwai maisúwáanana Áánútu usásisinkaniye súwana ");
INSERT INTO kze_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pítaa áí'maena kweyááva'a máankena séna Ísóigoo mirán-áímbá sénavo Áánútu íma owé sínasa séndanteni'a íma umánkanaaowe súwana ");
INSERT INTO kze_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ísu kwanténa Pítaantavena asiramái séna Sáátáánigo siyuwé kóaao. kwaásiti imáyáavinkemba kwésempo íma Áánútuna imáyáavinkemba kwésempo kesí aambá íma itaaó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ísu mináímbá simásuwena kwená kwayó-kwáásí simátimena séna kesínaaemba kwaránáe síyawai tirááímo táínda-yantaa'a íma tátoraaro. kemá puwónaunda-taima súgwaata'mae'a kondantembá kesínaaemba kwaránááowaima umbai-yántáá'á timíyasa minúmbáí-yántáá'á úwoi maimaésa sínaaemba kwaránááowe. ");
INSERT INTO kze_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","tirááímo táíndai'o ésa íma kawe'á umái ménaaovo kentávésa ísámai tirááímo táínda-yantaa'o tuwésamo puwésa aúnái'a umái maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","marapákémbó amápa-tantaa'o kwémaesamo puwíyambo éna mintántáákó íma túwa'naa íníye. puwíyamba marapá'ó makáan-tantaa'nei íma anondáí'a umásuwesa ókwara'a ayáátááka'a ménaaowe. ");
INSERT INTO kze_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","kemá kwaási úrandako kumpaáruraundawai kesí kwayó'nárawa'a kwíyómpakewaiye kesivoná asirayánkwárá'á kumé'a amápa-kwaasimo úmae kwéiyomba imáyáa é'a miwítí meéyámbá timénaumne. ");
INSERT INTO kze_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","árai'a simátime'a sé'a évaka'a maanká'ó máyáan-kwaasi íma aiva'á puwé'a kemá kwaási úrandako kesí kwaásimo kwégawaaunda suwáné'a naaémba puwónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ísu mináímbá simásuwena ava'moraé-no'waamba kwaéna Pítaante Yémésinte kwenáváko Yóninte umái tí'maena omápa'a iyúmba miwíyé su'mai umésa ");
INSERT INTO kze_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","miwí túranka'a Ísu ó'oran-auma auvúwana óipakemba aaváúgómó inten-úwana kwená unáánkwátóirakemba sán-kena kwayání'a kówasa ");
INSERT INTO kze_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","awánomba kae-kwáásíráí kwíyómpakemba paárésarai mindárai túwí'a Mósesiye Íráiyaae Yútaa-kwaasi tíkwá'nárai Ísuwe kwaasái kwésuyana ");
INSERT INTO kze_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pítaa Ísuntavena séna Ísóigoo maanká'ó maúndaya kawe'á imbá póta emó sinataamó éta kwááyu-namba kaumbomá ónaundaya moórá endéí éta moórá Mósesindei éta moórá Íráiyaandei éta mirá ónaundayaawe siráiye. ");
INSERT INTO kze_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","mirá kwésunka'a ainánkó sán-kámaena kwayání'a kámae kuména kunkáátowana mináínámpínkémbá aaigówé su'mai séna maawámá kesáánimba isa'á kwená imáyáa kwée'a ávááraumai aamoí umánkaumne. kwenáái ísáaro súwasa ");
INSERT INTO kze_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","kwená kwayó'nárau mináímbá isésa marapá'á kumbésa táátavesa ésa tiyántámbá kwétowana ");
INSERT INTO kze_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ísu miwímó máyópa'a téna tine'á tátorena séna táá'a kaivó usásinaaro súwasa ");
INSERT INTO kze_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","awánomba mindárai kwíyómpa'a íyúyana Ísuwe su'mai méraiye. ");
INSERT INTO kze_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","máyowasa omápakemba kúmúmba Ísu asiramái simátimena séna awánaamba íma simátíméro. kemá kwaási úranda'a kumpaáruraundawai púwóndavinkemba usásinaandara'a awánaamba kanaará'á simátíma'mae íyóro súwasa ");
INSERT INTO kze_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","kwená kwayó'nárau Ísumba áísaa esa sésa ámáámba sen-kwáásí Íráiyaa aiva'á paárínana Áánútu usásinankaiwai Yútaa-kwaasiya amu'makáúndawaiya naaémba paáriniyemo sembá nóra sésa mináímbá kwéseo suwaná ");
INSERT INTO kze_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ísu séna aiva'á Íráiyaa paáréna to'mayaa íníye-aimba árair-aimban-iye. ");
INSERT INTO kze_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","simátime'a sé'a Íráiyaa á'a paárúwasa íma aúyésa sáwí'a umánkanae sésa sáwí'a umánkesa mirá uráantemba kembá kwaási úrandako kumpaáruraundawaimba sáwí'a umásinkanaaowe súwana ");
INSERT INTO kze_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tááko pééi súwasa Íráiyaa siráimba Yóni nombá pétinkaraiwaintavena siráiye siráawe. ");
INSERT INTO kze_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","simásuwesa omápakemba kúmúmba sáwíva-kwaasi torupamái máyówasa awánomba moóráwai Ísunopa'a téna aísamaivimba kumbéna séna ");
INSERT INTO kze_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","anóndakoo kesáánimba arumbá umánkaao. sáwí'a umái ména tanaambá váguvagu kwéena aigaregó nonkáánéna aíyayaamba sápísimagwisana nompíné iravíné tanaambá kwévamae kwénaaisa'a ");
INSERT INTO kze_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ená kwayó-kwáásí máyáapa'a máankaunasa íma kanaán-umai kawe'á umánkaraawe súwana ");
INSERT INTO kze_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ísu séna kentí imáyáa kae'náér-imayaama isa'á kentávé'a íma imáyáa kwéowana póna sirumbá umbaí kwétaivo nóraumai-tawaiya'i kesé ménaumpo enáánimba áí'mae tiyó súwana áí'maena túwana ");
INSERT INTO kze_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ísu taraváá-kwántávéna séna auwé kóaao súwana arumpinkémbá auwéna kóúwana miníyámpóí kawe'á umánkowana kawe'á umái méraiye. ");
INSERT INTO kze_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","kawe'á umánkowasa naaémbo Ísu kweyáá máyonka'a kwená kwayó-kwáásí tésa sésa nóra séta mintáráváá-kwámbá íma kanaán-umaiya mayáúkaumno suwaná ");
INSERT INTO kze_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ísu séna Áánútuntave'o mayauwáníyemo sé'o asiramáímo máyáankakai mayaúwáísino. árai'a simátime'a sé'a moórá-taigo áwí'a másátati sáwíyan-aramba ma'makáisana áruma kwikéna anón-tainambo kwéiyintemba kesé aráápamai sáwíyanka'a mé'a naaémba anóni'a umái aráápamai mé'a omátave'o sé'o kítímae ór-ayampa'a kóaaomo síyanamo éna mirá íníye. ");
INSERT INTO kze_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ísu mináímbá siráimba kwesé aráápamai máyáamba kwená mayáí amápa'a kanaán-umai mayánááontavena siráiye. ");
INSERT INTO kze_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ísu kwená kwayó-kwáásí Káríri-ayampa'a torupamái máyówana Ísu simátimena séna kembá kwaási úranda'a kumpaáruraundawaimba ó'on-kwaasi timíyasa ");
INSERT INTO kze_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","sínkamiya'a puwé'a kaumbo-táwai maisúwáanana usásisinkaniye súwana miwí tirunkó umbaí taráiye. ");
INSERT INTO kze_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","tirunkó umbaí tówasa Ísu kwená kwayó-kwáásíyé Kápénéamu-naopa'a kumbá anóm-bono'-nankontavesa táákísi-ontamba kwémayaawai Pítaanopa'a tésa sésa ená anóndako anóm-bono'-nankontavena táákísi-ontamba kwétuwai. íya kwétuwaiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pítaa séna kwétuwaiye simásuwena naaúmpa'a iyúwana táákísin-aimbo ímo sirónka'a Ísu Pítaamba áísaa ena séna Sáímoniyo marapákén-ánón-kwáásí timááraawitopakemba táákísi-ontamba maésa ó'onkaatopakemba maésawa kwéompo nóran-imayaamo kwéemo e simásimiyo súwana ");
INSERT INTO kze_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pítaa séna táákísi-ontamba ó'onkaatopakemba mairáawe súwana Ísu séna miráumai Áánútuna kwaásiya póta anóm-bono'-nankona táákísi-ontamba íma tuwánaundayaanivo ");
INSERT INTO kze_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","áwáá'a seváí póta úwoi tuwánaundayaanivo nonkwaaúmpá'á kuré ánda túwénana kumína aiva'ó torénda-noyaa'a mairé óipimbo óntambo kwáyaina maimaé minóntándéí esáváíyé kentáváíyé táákísi móuwo Ísu súwana mirá uráiye. ");
INSERT INTO kze_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","mitáwai Ísuna kwayó-kwáásí kwenópa'a tésa taáísaa esa sésa Áánútu kwená kwaásimo kawááin-kwaasivinkemba nááwa usáyaaitesa anón-kwaasi-i'a kwéoo suwaná ");
INSERT INTO kze_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ísu moórá-iyampoi ááyowana túwana avumpimbá aránkena ");
INSERT INTO kze_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","séna árai'a simátime'a sé'a sen-ímáyáámó ímo tuwé'o iyámpóímo ímo usáyaaitanae-imayaamo ontembó keinárawa'a mirán-ímáyáámó ímo íyanamo éna Áánútu kenká'á íma kawááiniye. ");
INSERT INTO kze_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","miníyámpóígó tísamaivimbo máíntemba mirámó kwéowai Áánútu kwená kwaásimo kawááin-kwaasivinkemba kwéusayaaitaawe. ");
INSERT INTO kze_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","kentávésa imáyáa kwéesa iyámpói áwa'naa onten-umái kwésuwa'naa-owe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ísu mináímbá simásuwena séna iyámpóígomo kesááiyavenamo árairemo sintenkáán-umai évakarawai áraire kwésewe. évakarawai tésa kesááiyavesamo áraire kwésewaima kampar-áímbá tasimátimiyasa isésa sáwí-ampa'a kówíyasa Áánútu kampa'ó síyawaima sáwí-meyamba anómba timínívo miwímó tinumarampimbó anón-ontambo aríkwímaresamo nompímbó túwááwasamo kumésamo kumpuwésarakai kampar-áímbá íma simátíméwasa sáwí-ampa'a íma kosinó. mindá kanaán-iye. ");
INSERT INTO kze_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","marapá'á máyáanka'a kesáái tuwésa sáwí-ampa'a kónááontavena ó'on-o'on-tantaako kwétavisiye. mirá-sáwí-tántáákó kwaíkwai'a kwéimba pósa sáwí-ambo ó'owimo agaráátínkáawai sáwí-meyamba mayánááowe. ");
INSERT INTO kze_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","tiyáánkowa'i. tísamaigowa'i. sáwí'o ína'a misáwí-ámpá'á kúnavo sé'a moórá-tiyaana'i. moórá-tisamaiya'i. arátúwáaro. kae-tíyááná'i. kae-tísámáíyá'i. kwáyaina'o é'a sáwí-marupa'o iramó kwégaipa'a kónááomba mindá sáwí'an-iye. sáwí'o uráimbo maisuwé'o máyáamba mindá kawe'án-iye. ");
INSERT INTO kze_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","túrankomo sáwí'o ína'a misáwí-ámpá'á kúnavo sé'a moórá-turamba pítuwaaro. kae-túrándéímo awáné'o é'a sáwí-marupa'o iramó kwégaipa'a kónááomba mindá sáwí'an-iye. sáwí'o uráimbo maisuwé'o máyáamba mindá kawe'án-iye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ísu séna úwoi-kwaasiyave'a úwoisamban-owe íma sé'a kárákwiyoro. Áánútuna kwayó'nárawa'a kwíyómpakewai miwírá'á kárákwiraawai kesivo kwíyómpakewaina egwaa'á mésa miwí táái kwésimamevo kárákwiyoro Ísu siráiye.  ");
INSERT INTO kze_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ísu mináímbá simásuwena séna kemá kwaási úrandako kumpaáruraundawai Áánútuna aampa'ó ímo kwégwaraan-kwaasiyave'a tivakáá-umai sáwí'o umáímo máyáampinkemba kawer-ámpá'á métínkáandayave'a kunkáumne. ");
INSERT INTO kze_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","sipisípira'a kárákwiyowai kwéon-aimba ísáaro. moóráwai sáwíva-sipisipi 100 sipisipira'a kárákwiraisana moórá-sipisipi áúyokwisana misáwívá-sípísípímó umó kwénaamba tiyuwéna moórámo áúyokwimba koavakáá eémena ");
INSERT INTO kze_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","awánénamo imbá aamoí kwéena séna kesí sipisípi áúyokwimba áíkaumne séna mimbóráwáíná aamoí anómba éna sáwíva-sipisipi ímo áúyokombo úwoimo máyáawaiti aamoí sáwíyanka'a kwéiye. ");
INSERT INTO kze_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","sipisípira'o kárákwiyowaimo áúyokwi-sipisipiyavenamo arunkómó umbaimó taintembá kentivo kwíyómpakewai kwená aampa'ó ímo kwégwaraan-kwaasiyavena arunkó umbaí kwétaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ísu mináímbá simásuwena séna ená kwaási Áánútuna kwaásigomo embó sáwí'o umánkainamo e kwempá'á mináíntáváí kosimámínana kwewé su'mai máyaindara'a kosimámínana enáái isénamo arupí umánkainamo ékai kwesé esé kawe'á umái máékaiyo. ");
INSERT INTO kze_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","enáái ímo isáínamo e moóráwaiya'i. kaekóná'i. kotí'mai kwempá'á simámiyo. Áánútun-aai aúváívimba agaimaréna séna moóráwaimba aaivimbá mayankánáe séna mináímbá ísarewai kaerá'i. kaumbowá'i. tí'maena mátinkena áísaa umai isáníye siráimba mindáyavena ená kwaási enáái isáníntavena moóráwaiya'i. kaekóná'i. kotí'mai kwempá'á mé'a simámiyana kentáái isáíno. ");
INSERT INTO kze_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ánivo ímo isáínamo e Áánútuna kwaási torupamátinke enáái simátímínasa mésa simámiyana kwemó miwí tááimo ímo isáínamo e imáyáa e se Áánútuna aambó ímo kwáráan-kwaasiraamba éna táákísi-umoyan-kwaasiraamba kwéiye siyó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ísu séna árai'a simátime'a sé'a marapá'ó máyáanka'a sáwí'o ombá aambó aunónaaonten-umai Áánútu kwíyómpa'a ména á'a aambá áúmbakaiye. kawe'ó ombá ímo aambó aunónaaonten-umai Áánútu kwíyómpa'a ména á'a mirá uráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ísu mináímbá simásuwena séna moórá-aimba simátíménda ísáaro. marapá'ó máyáanka'a kae-kwáásígóráímó moórá-aintavesaraimo mimbórá-ímáyáámó ésaraimo kesivo kwíyómpakewaimo áísaa íyanamo éna mirá umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","kaumbo-káé-kwaasi kentávésa imáyáa ésa torupamái máyáamba túwa'naa ónaundayave'a miwísé ménaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ísu mináímbá súwana Pítaa Ísunopa'a téna séna Ísóigoo kesí kwaási sáwí'o umásínkáva'o kwéiyomba mindáyave'a nóraumai-tawai íma aaivimbá mayankéra íma imáyáa éra ivátuwanaumno. avakaeté-tawaima sáwí'a umásínkáimba íma aaivimbá mayanké'a íma imáyáa é'a ivátuwaunda pó'a moórá-tawaimo sáwí'o umásinkaindara'a aaivimbá íya mayankéra. íya imáyáa éra. ivátuwanaumno súwana ");
INSERT INTO kze_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ísu séna íma avakaeté-tawaiye su'mainivo úwoi mirá úmae iyuwó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ísu séna sáwí'o umátínkáamba íma imáyáa é'a ivátuwaaromo súnda maarán-iíyávé'a sé'a Áánútu kwená kwaásimo kawááin-aimba maarán-áímbán-iye. moórá anón-kwaasigo kwená mayáí-kwáásí óntamba kwááyu tímakena ");
INSERT INTO kze_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","tísaa ónáe kwéimba anón-ontamba 10,000,000 ontamba kwááyu ámakaiwaimba moóráwai áí'maena móaminkwae séna íyísana ");
INSERT INTO kze_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","íma móamintavena óntan-anavo séna kwembá airé'a awainínkómbá airé'a kwená iyámpóíye kwená póíye kwená óísane maimaé'a ó'on-kwaasiti mayáí mayáníntave'a miwí kwétime'a óntamba maimaé'a kemó tukáunda-ontankaamba umái másíméro sisaná ");
INSERT INTO kze_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","kwená mayáí-kwáásígó aísamaivimba kumbaéna séna arumbá umásinkema simu'makéna'a óntamba avakáá-é'a amápa'a áméno sisaná ");
INSERT INTO kze_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","kwená anón-kwaasigo arumbá umánkena séna kanaán-ivo kwááyu ámakaunda-ontamba íma imáyáa ónaumpo ivátuwaao sisaná ");
INSERT INTO kze_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","mayáí-kwáásígó máápa'a kuména moórá mayáí-kwáásígómbá awánéna sáwíyan-ontamba 100 ontamba ámakaiwaimba awánéna amósámba kumbapaména anónka'a séna kwááyumo ámakaunda-ontamba avekáámbá simiyó sisaná ");
INSERT INTO kze_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","kwenaísamaivimba kumaéna séna arumbá umásinkema simu'makéna'a óntamba avakáá-é'a áméno sisaná ");
INSERT INTO kze_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","íma iséna áí'maena ándáva'a móankena séna kwááyumo ámakaunda-ontamba símínasa ayúránkáaro sisasá ");
INSERT INTO kze_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","mayáí-kwáásíyómbá awánésa tirumbá umánkesa miwítí anón-kwaasira'a kosimáméwana ");
INSERT INTO kze_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","anón-kwaasigo iséna kwená mayáí-kwáásígó sáwívar-ontamba 10,000,000 ontamba mairáiwaimba ááyaisana tisaná séna sáwí-mayai-kwaasi óne. kentáváí arumbá umásinkaao séndayave'a mirá é'a anón-ontamba kwááyu ámakaunda-ontamba íma imáyáa ónaumpo ivátuwe íma simiyó sé'a ");
INSERT INTO kze_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","sirumbó umánkaraundantemba moórá-mayai-kwaasigomba arumbá umánkááraamba sáwí'a óne séna ");
INSERT INTO kze_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","arumbá anómba sáwí'a umánkena ándáva'o kárákwiraindakonka'a móankena séna kwááyumo ámakaunda-ontamba amápa'a simína ayúrankaao sisaná ándáva'a ánkaraiye ");
INSERT INTO kze_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ísu simásuwena kwená kwayó-kwáásíyávéna séna kentí kwaásimo sáwí'o umátínkáambo ímo ivátuwe'o imáyáamo úmae kwéiyiyanamo éna kesivo kwíyómpakewai kentí sáwí-mayai íma maitiyuwáníye. óntan-anavomo intembá kesivo mirá umátinkaniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ísu mináyáátáár-áímbá simátímatuwena Káríri-ayampa'a tuwéna Yútiyaa-ayampa'a Yótáni-nonkona menávápár-áyámpá'á komáyowasa ");
INSERT INTO kze_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","sáwívarawai tóyo uwaná tí'o ún-kwaasi asóvamatinkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","asóvamatinkowasa ámáán-kawaa-kwaasi sésa Ísumo sáwí-aimbo sínda isánáe sésa Ísunopa'a tésa sésa moórá-kwaasigo maanáíntáváíyá'i. ó'on-o'on-aintavaiya'i. awainínkómbá kanaarárá auwáníyo. mirámó énamo éna ámáán-aimba araaisíni. íya araaisíníyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ísu séna naaóvá'ó Mósesimo agaimakáin-aimba awánaraawe. maarán-áímbá agaimaréna séna Áánútu kwíyómba maramá taróruronka'a aaraigwárá kwaaigwárá'á taróruraiye. ");
INSERT INTO kze_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","tarórurena séna aaraigwárá kwaaigwárá'á tatóruraundayavesa tinóvowi tiyuwésa awaikóe awainínkóe tágárotamai mimbórá-túmá ma'mái kwémaewe Áánútu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","mindáyavesa awaikóe awainínkóe íma kae-kwáásíráámbá ésa mimbóráí'a kwéowe. Áánútu aarai-kwaaí moórái'a umátínkaraintavesa íma tasáéro Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","miwí sésa naaóvá'á Mósesi maará séna moóráwai awainínkómbá ai'mátuwaindawai aúváívimba agaimaréna séna kesuwainímbá ai'mátuwaumne séna agaimái amiíno siráiye. nóra séna mirán-áímbá siráiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ísu séna kentíkwá'ná tirumbá makáamba pósa Áánútun-aai íma ísóntavena mindáyavena Mósesi minámáámbá siráimbanivo Áánútu kwíyómba maramá taróruronka'a íma mirá siráiye. ");
INSERT INTO kze_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","simátime'a sé'a moóráwaimo awainínkó íma moórá-kwaasigoe kwénaaisana awaikó ó'on-aintavena ai'mátuwenamo ó'on-inimbo kwémayaimba umóyámbá kwémayaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ísu mináímbá simásuwena máyowasa kwená kwayó-kwáásí sésa aaraimó kwémayaamba sénda-aimba kwáyáinka'a pósa mirá kwéovo ímo aaraimó maésamo úwoimo kwémaemba kawe'á kwéowe suwaná ");
INSERT INTO kze_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ísu séna amáparawai sen-áímbá íma kawe'á umái ísáawasa aaraimó ímo mayánááontavesa Áánútu asirayámbá tímakaiwai mináímbá kwéisaawe. ");
INSERT INTO kze_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","évakarawai moórá-mora-aintavesa íma aaraí máyáawasa évakarawai tinóvowi sáwí-kwaasi tínkaraawai aaraí íma máyáawasa évakarawai túmo sáwí'o umátínkaraawai aaraí íma máyáawasa évakarawai Áánútu kwená kwaásimo kawááin-aimba isésa Áánútuntavesa imáyáa ésa aaraí íma kwémayaawe. kanaán-umai mirá ónaumnemo kwésewai mináímbá isánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ísu simátimuwasa évakarawai Ísu tátorena kawe'á umátinkena Áánútumpa'a námúnaa sínkwáe sésa iyámpói tí'maesa tuwasá kwená kwayó-kwáásí sésa tí'mae'a kóro suwaná ");
INSERT INTO kze_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ísu simátimena séna íma kóro sé'a tiyuwáíyasa kesópa'a iyámpói úwoi teró. miníyámpóímó kesópa'o tentembá Áánútu kwená kwaásimo kawááimba miráráán-umai kwégawaaimba iyámpóímo kesópa'o tí-amba íma ítátinkaaro séna ");
INSERT INTO kze_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","miníyámpóírá'á ayáámba tátorena túwa'naa umai námúnaa simásuwena tíyukaiye. ");
INSERT INTO kze_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","tiyuwówana moóráwai ívé-kwaasigo Ísunopa'a téna séna anóndakoo nóran-kawera umáíya aúnái'a umái kwíyómpa'a maí'maira ónaumno súwana ");
INSERT INTO kze_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ísu séna nóra se kawe'-máyáíyáváíyá sísaa oónó. mimbóráwáí Áánútu kweyáá kawe'ná'án-iye. aúnái'a úmai maí'mai'a ónáe sémo e Áánútuna ámáámba kawe'á umái kwaraaó súwana ");
INSERT INTO kze_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","mindákó áísaa ena séna nóin-amaana kwaránaumno súwana Ísu séna tínkamiyasamo puwónááoni'a íma uwó. íma aarai-úmóyámbá uwó. íma umóyámbá mayaaó. kampar-áímbá íma simátinkaao. ");
INSERT INTO kze_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kentinóvowi túwí'a anómba uwó. esáváí-ímáyáámó óndantemba ená kwaásiti imáyáagwara'a uwó. miráumai-amaamba kwaraaó Ísu súwana ");
INSERT INTO kze_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","mindákó séna minámáámbá kwa'maé'a kwéiyumpo nóran-amaankona íma kawe'á kwéuno súwana ");
INSERT INTO kze_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ísu séna amápa-tantaa'o kanaamó émo e ená náaindaamba ó'on-kwaasi kwétime óntamba mairé ímo makéwai tímatuwenana ená kawe'-méyámbá Áánútu kwíyómpa'a ankáníye. tímatuwemo e kesínaaemba kwaráníyone súwana ");
INSERT INTO kze_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","mináímbá iséna sáwíva'-naaindaamba makóntavena anón-imayaa úwana arunkó sáwí'a kwéuwana kuráiye. ");
INSERT INTO kze_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","kúwana Ísu kwená kwayó-kwáásíyávéna séna árai'a simátime'a sé'a sáwívar-oisambo makén-kwaasi Áánútumo kwená kwaásimo kawááipa'a kwíyamba umbaí táníye. ");
INSERT INTO kze_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","moórá-poigo áwí'a káámeri mimpóígó kwaigóná avaapimbá íma kanaán-umai kóveraniye. káámeri-poigomo kwaigóná avaapimbó kóverainkakai sáwívar-oisamba makén-kwaasi Áánútumo kawááipa'a kosinó Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","kwená kwayó-kwáásí mináímbá isésa táátavesa ésa sésa umbaí taintávésa nóran-kwaasiya Áánútumo kawááipa'a ménaaoo suwaná ");
INSERT INTO kze_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ísu tuwánéna séna kwaási miwítí mayáínéí íma meéyámbaresa kónááovo Áánútu amápa-tantaa'a úwoi kanaán-umai kwéiye súwana ");
INSERT INTO kze_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pítaa séna isaaó. kentáásí amápa-tantaa'a tuwéta enánaaemba kwégwaraumpo nóram-beyana mayánaumno súwana ");
INSERT INTO kze_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ísu séna árai'a simátime'a sé'a Áánútu amápa-tantaa'a aúnái'a úmaraindara'a kemá kwaási úrandako kumpaáruraundawai ságayankwarawai mé'a kárákwiyona'a keinárawa'a sísamaivakemba kae'á kumbaimái-kwaasi kesínaaemba kwégwaraawai Ísareri-kwaasi mayáíyávé'a tísaa ónááowe. Ísareri sísamaivakemba kae'á kumbaimái tínkaraiwai-andarakewai tísaa ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","kentávésa imáyáa ésa Áánútun-aai kosimátimenaaontavesa naambáru'a tuwésa tuwaaísái tiyuwésa tívá'maa'a tiyuwésa tímánaa'maa'a tiyuwésa tinóvowi tiyuwésa táánimbaa'a tiyuwésa tiyáámúmbaa'a tiyuwésa miwítí maramá túwáawaina anondáma túwáan-tantaa'a mirán-tántáá'á sáwíva'a mémaesa aúnái'a umái kwíyómpa'a maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ívé'a évaka'a aivakéwáí aáno tínaaeni'a íyasa ívé'a évaka'a tínaaenkewai aáno aivarí'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ísu mináímbá simásuwena séna Áánútu kwená kwaásimo kawááin-aimba maarán-áímbán-iye. moóráwai ándá-aran-kigaugo avowámá kesí mayáí mayáígwáe séna ááéma usásinkena kwaási tivakáá-umai tuwánéna ");
INSERT INTO kze_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","séna kesí mayáí kwémaewa'a moórá-tawai-mayaigona óntamba tíméno sisasá owé sewaná tí'maena kwená ándá-aran-kigauva'a móitinkaisasa mayáí kwémayaawana ");
INSERT INTO kze_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","usá aaváyaavimba ókwara'a mayáí mayáígwáe séna mayáímó mayánáe sésamo torupamáímo máyáapa'a kwéna tuwánéna ");
INSERT INTO kze_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","séna kesí mayáí kwémaewa'a arupí-meyamba tíméno sisasá ");
INSERT INTO kze_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","owé sésa mimbáyáí kwémayaawana kwáyá'wái mirán-umai ókwara'a kwétirena eénáínka'a ókwara'a kwétirena ");
INSERT INTO kze_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","mayáí ánásanaaon-kanaa sáwíyanka'a kwétisana mayáímó mayánáe sésamo torupamáímo máyáapa'a kwéna évakarawai tuwánéna séna nóra éra úwoi máyáao sisasá ");
INSERT INTO kze_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","sésa íma moórá-kwaasigo kesí mayáí máyáaro siráawata máyaumne sewaná tiré'a kesí ándá-aran-kigauva'a mayáí máyáaro sisasá mirá uráawe. ");
INSERT INTO kze_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","mirá owaná eénáínka'a kígaugo avowámá mayáí-kwáásírá'ó kárákwiraiwaintavena séna mayáí-kwáásí tááyare miwítí meéyámbá timé naaémbo tiráawai aiva'á timé aiva'ó tiráawai naaémba timiyó sisaná ");
INSERT INTO kze_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","iséna mirá éna mayáí ánásainiye kwéinka'a tiráawai moórá-tawai-mayaigona óntamba tiména miráumai tímatuwena ");
INSERT INTO kze_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ááéma aaváyaavimba tiráawaiti meéyámbá timénáe kwéisasa miwí imáyáa ésa kentáásí meéyámbá anómban-iye kwésewana moórá-tawai-mayaigona óntamba tímísasa ");
INSERT INTO kze_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","maimaésa kígaugo avowámá í'ái simánkáawana ");
INSERT INTO kze_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","miwívínkémbá moóráwai séna naaémba tiráan-kwaasi sáwíyam-bayai mairáavo kesáá aiva'á tiráundawaiya anón-a'a kwégaisata umisi-áráá'á méta anóm-bayai mairáundaya mimbóráí'a umáíya meéyámbá símakaandaya nóra séwa kentáámó siméndantem-beyamba miwí tímakaano sisaná ");
INSERT INTO kze_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","kígaugo avowámá séna kesí kwaásiyo kemá sé'a kesí mayáí kwémaewa'a moórá-tawai-mayaigona óntamba tíméno súna'a owé sé'a mayáí mairáawa'a mindáyave'a íma sáwí-meyamba kwétimumpo ");
INSERT INTO kze_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","kentí meéyámbá maimaé'a koró. keinárawa'o timúndantem-beyamba naaémbo tiráawai mirám-béyámbá timénáe'a kwéune. ");
INSERT INTO kze_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","kesí óntambo taaímbare'o kwétimunda mindá kendéímán-iye. sáwíyam-bayai mairáawai anón-ontamba kwétimuna'a ímo kayórááraamba kwégayoraawe kígaugo avowámá siráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ísu mináímbá simásuwena séna miráráán-umai Áánútu kwená kwaásimo kawááipa'a aiva'á kwégowai íyasa naaémbo kwégowaise mimbóráí'a umái aasiyaasí aúnái'a umái maí'mai'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ísu séna Yérúsaremu-naopa'a kónáe séna aampa'á kwégwena kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi tí'maena moórá-ayampa'a tínkarena ");
INSERT INTO kze_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","simátimena séna maísáaro. Yérúsaremu-naopa'a konanayá moóráwai kembá kwaási úrandakomba mono-káwáá-kwáásíyé ámáámba sen-kwáásíyé agaráátinkainasa kembó sínkami-aimba simái tarúmaresa ");
INSERT INTO kze_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","sí'mai ó'onkaa-kwaasi timíyasa kanaáráá'a kwésinkesa súwíruku'a nésa taaira'á sínkamiya'a púwónasa utamásinkaiya'a kaumbo-táwai maisuwé'a usásinanaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","minkánáá Sépéti ááninkai tinówama tí'maena Ísunopa'a téna moórá-yantaatavena áísaa íníntavena anóndakoman-iye séna takívairowana ");
INSERT INTO kze_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ísu séna nóintavaiya sísaa íníyewa kwéono súwana tinówa séna emó kawááindava'a kesááninkai usásintinke évarevar-akwampa'a tinkáníyone súwana ");
INSERT INTO kze_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ísu séna sénda-ainkona ááimba íma ísaraiye. sáwí-nombo anavéúmpinkembo náúndanten-umai sí'a índai'a umásinkanaaomba keinárai kanaarárá kemó náúnda-anaveumpinkemba náyááoiyo súwasarai keiráí kanaám-pókai náyauye suyaná ");
INSERT INTO kze_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ísu séna árai'a séye. kemó náúnda-anaveumpinkemba náyááoivo kesí évareva-sukwampa'a kemá íma usásintinkanaumpo Áánútu kae'nárai umátinkaraimba póna usásintinkaniye súwasa ");
INSERT INTO kze_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ísuna kwayó-kwáásí siyáánkainarawa'a mináímbá isésa mináváráwai áwáá'a tíyúwana ");
INSERT INTO kze_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ísu tááyowasa tuwaná séna á'a ísaraawe. marapár-ánón-kwáásíyómbá usáyaaitamai asirayán-áímbá simáti-simati kwéuwasa kwenkóyai kwentáyai'a uráawe. ");
INSERT INTO kze_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","anón-kwaasimo ontembá keinárawa'a íma mirá oró. keinárawapinkemba usáyaaitanae síyawai ó'owiti kwayó'á maránááowe. ");
INSERT INTO kze_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","keinárawapinkemba aivarí'a ónáe síyawai amáparawaiti mayáímá túwa'naa oro. ");
INSERT INTO kze_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kemá kwaási úrandako kumpaáruraundawai íma súwa'naa ígwáe'a kunkáumpo kemá kwaási túwa'naa ónáe'a kunkáumne. sáwí-imayaavinkemba iyátinkanaundayave'a puwónaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ísuwe kwená kwayó-kwáásíyé Yéríko-naopakemba kumbá sáwíva-kwaasi tínaaemba kumbá ");
INSERT INTO kze_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","kae'nárai túramba kavíkóndarai aanéiva'a mésarai Ísu kwétiye-aimba isésarai anónka'a sésarai Tévítin-andarakewai ómpo arunkáí umásinkaao suyasá ");
INSERT INTO kze_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","misáwívá-kwáásí áwáá'a tiyésa sésa aaí séyavo suwasaráí mináímbá ivátuwesarai ó'omba anónka'a sésarai anóndakoo Tévítin-andarakewai ómpo arunkáí umásinkaao kwésuyana ");
INSERT INTO kze_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ísu aampa'ó kúmba minká koména tísaa ena séna nóin-tantaara tirááímo táínda-yantaa'a umátinkanaumno súwasarai ");
INSERT INTO kze_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","anóndakoo súramba kawe'á umásinkaao suyaná ");
INSERT INTO kze_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ísu arumbá umátinkena ayáámba túranka'a tátorowasarai avekáámbá túramba kawe'á umái awánésarai Ísu ánaaemba kwa'mái kurááiye. ");
INSERT INTO kze_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ísu kwená kwayó-kwáásíyé kumbá Yérúsaremu-noar-ampa'a kumbá Óríve-omakar-egwaa'-nao'a áwí'a Pétévasi-nao'a egwaa'á kwésa kwená kwayó-kwáásí kae'á máti'marena ");
INSERT INTO kze_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","séna epín-dáópa'a kurékai awáneyamba moórá-poigo áwí'a tónki ánda kwímaraawana áráákwara'a máyáivo koawánékai ándáma iyátuwekai áí'maekai tekaiyó. ");
INSERT INTO kze_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","moóránakomo tuwánénamo tísaa ínakai anóndako ayáá'mae'a kónáe siyé kosimámiyana séna ánivo áí'maekai kokaiyó síníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","naaóvá'á Áánútun-aai simátímakowai siráintemba Ísu mirá uráiye. Áánútun-aai simátímakowai séna ");
INSERT INTO kze_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sáíyono-noapaken-kwaasiyavai simátime se kentí kawááná'á kentópa'a kwempa'á teémena tónki-poigo ayáá'maena téna tónki-poigon-araako ayáá'maena kwétiye simátimiyo siráiye agaimaréna Sáíyono-naoparemo siráimba Yérúsaremu-naopatavena siráiye. mináímbá paáréna Ísu kae'nárai ti'marówasarai ");
INSERT INTO kze_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ísumo súntemba mirá ésarai ");
INSERT INTO kze_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","tónki-poi áráákwara'a áí'maesarai Ísunopa'a tuyasá kwená kwayó-kwáásí paákár-únánkwátói ayú'mái mimpóígó arósáánumpimba kwandaaí uwí'márówana Ísu ayáá'maena kwéguwasa ");
INSERT INTO kze_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","sáwíva-kwaasi mésa anón-kwaasiye sésa évakarawai paákár-únánkwátói ayú'mái évakarawai taayánáma ayáiresa aampa'á uwí'ma'mae kwéguwana minúnánkwátóirare mintááyánáravane augwétámai kwéguwasa ");
INSERT INTO kze_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","aiva'á nááún-kwaasiye Ísun-ánaaemba nááún-kwaasiye anónkar-anonka'a sésa Tévítin-andarakewai áwí'a mósá kwémaraumne. Ísóigo ai'máráísana kunkáiwaimba Áánútu kawe'á kwéumankaiye. kwíyómpakewai kwenáwí'a mósá kwémaraumne anónkar-anonka'a suwaná ");
INSERT INTO kze_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ísu Yérúsaremu-naopa'a kúwasa isaaisésa tóyo kwéesa nááwa kwétiyo suwasá ");
INSERT INTO kze_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","évakarawai sésa Ísu Áánútun-aai simátímíwai Káríri-ayampakemba Násáreti-naopakewaiman-iye siráawe. ");
INSERT INTO kze_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","suwaná Ísu Yérúsaremu-naopa'a anóm-bono'-naumpa'a Áánútuna naaúmpa'a iyéna mono'-náúmpá'ó meéyámbó kwémayon-kwaasi tuwánéna uti'mátuwena mono'-nánkóná óntambo meéyámbárón-kwaasiti taareimá tawísíyuwena Áánútuntavesa imáyáa ésa máái-numama kwéamun-dumama meéyámbárón-kwaasiti taareimá tawísíyuwena ");
INSERT INTO kze_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","simátimena séna Áánútun-aai aúváí-kwandaaivimba agaimaréna séna kesí naatavésa sésa Áánútumpa'o námúnaamo sen-dámbán-iye kwésewe agaimaréna siráiye. ánivo umóyán-dáúmpá'ó ontenkáámbá uráawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ísu mináímbá simásuwena anóm-bono'-naumpa'a máyowasa túrambo kavíkówaiye aíyayaambo tausokówaiye kwenópa'a tuwaná asóvamatinkowasa ");
INSERT INTO kze_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","iyámpói mésa anónkar-anonka'a sésa Tévítin-andarakewai áwí'a mósá kwémaraumne sumbá mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé isésa Ísumo ó'oran-kawe'-mayaimo mayómba awánésa tirumbá sáwí'a umánkesa ");
INSERT INTO kze_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ísuntavesa sésa iyámpóímo sáwí-aimbo kwésemba íya kwéisaano suwaná Ísu séna á'a kwéisaunda Áánútun-aai aúváívimba agaimakáin-aimba awánaraawe. maarán-áímbá séna túwa'naa óndayavesa pósa iyámpóíye umarané enáwí'a mósá kwémaraawe agaimaréna siráiye Ísu simásuwena ");
INSERT INTO kze_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","tiyuwéna máápa'a kuména mindáópa'a tuwéna Pétáni-naopa'a kwéna mindó'wáámbá koméraiye. ");
INSERT INTO kze_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pétáni-naopa'a kogwáúmba usásinesa Yérúsaremu-naopa'a tumbá Ísumba áái ankówana ");
INSERT INTO kze_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","moórá-taigo áwí'a víkima aankón-awampa'a kwáyowana mintáéramba nánáe séna ááimpa'a kwéna awánómba ánáwe su'mai kwáyowana mintáígóntávéna séna ená arambá íma iyáníyone súwana mintáímá aáyánkaraiye. ");
INSERT INTO kze_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","mintáí aáyánkówasa Ísuna kwayó-kwáásí awánésa táátavesa ésa tiyáámba tóipimba aavésa sésa víki-tai ááéma aáyánkagwiye suwaná ");
INSERT INTO kze_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ísu séna árai'a simátime'a sé'a Áánútuntave'o ímo kaer-ímáyáámó é'o asirayán-ímáyáámó é'o é'a víki-taigontave'o súnanamo aáyánkaintemba kanaán-umai mirá é'a miráwé su'mai íma é'a maanómátávé'a sé'o iré mapámbai nompá'á kumuwómó síyanamo éna mirá íníye. ");
INSERT INTO kze_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Áánútumpa'a námúnaa sé'a ó'on-o'on-tantaatave'a áísaa e'a sembá árai'a Áánútu kanaán-umai súwa'naa umásinkaniye sembá kanaán-umai kwétuwa'naa-iye. ");
INSERT INTO kze_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ísu mináímbá simásuwena anóm-bono'-naumpa'a uména Áánútuna áséi-kwasai kwésimatimuwasa mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye tésa sésa nááwa ai'mákaisa tiréwa nááwampinkena mairéwa asirayám-báyáí kwémayaanda simásimiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ísu séna aiva'á moórá-aimba tísaa ona'á anondámo síya'o é'a sísaa on-áímbá simátimenaumne. ");
INSERT INTO kze_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ááéma Yóni nombá pétinkaraiwaima Áánútuwa simámakaisana nombá pétinkarai. kwaásiya simámakaawana nombá pétinkaraiyo súwasa miwímá keáímbá sésa nórayaawa sénaumno. Áánútu simámakaisana nombá pétinkaraiyemo senanayáámó éna nóra séra Yónin-aaiyave'a íma áraire sirááo síníye. ");
INSERT INTO kze_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","kwaási simámakaawana nombá pétinkaraiyemo senasayáámó ésa úwoi-kwaasi sínkamonaaowe. úwoi-kwaasi sáwíva-kwaasi Yónintavesa Áánútun-aai simásímakaiwai uráiye kwésemba pósa áwáá'a siyénááowe mirá keáímbá sésa ");
INSERT INTO kze_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ísuntavesa sésa emó sísaa ónda-ainta íma ísaraumne suwaná Ísu séna ímo simásimiya'a nááwampinkena mairéra asirayám-báyáí kwémayaunda-aimba íma simátimenaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ísu mináímbá simásuwena séna simátíménda-aimba imáyáa oró. moóráwai kaer-íyámpóí tínkaraiwai aivakéwáíntávéna séna kesááninkoo kesí ándá-aran-kigauva'a mayáí komayaaó sisaná ");
INSERT INTO kze_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","aivakéwáí séna íma sínkáiye séna ména moórá-imayaa éna mayáí komáyáísana ");
INSERT INTO kze_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","naaénkewaintavena séna kesí ándá-aran-kigauva'a mayáí komayaaó sisaná owé simái ivátuwena íma mayáí mairáiye ");
INSERT INTO kze_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ísu simásuwena tísaa ena séna nááwa tivowán-áái kwéisaiyo súwasa aivakéwáí avowán-áái kwéisaiye suwaná Ísu séna mináímbá imáyáa é'a simátíménda-aimba ísáaro. táákísi-umoyan-kwaasiye eénánká'ó kwénaaon-inine sáwí'a kwéon-kwaasin-owe kwésembanivo miwímá Áánútu kwená kwaásimo kawááin-ampa'a ááéma kwégovo keinárawa'ando. ");
INSERT INTO kze_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yóni nombá pétinkaraiwai téna kawer-ámbá agaráátinkowa'a kwenááiyave'a íma áraire siráavo táákísi-umoyan-kwaasiye eénánká'ó kwénaaon-inine Yónin-aaiyavesa áraire suwa'á keinárawa'a miwí tuwáné'a Yónin-aaiyave'a íma áraire sé'a kentí sáwí-imayaa íma tuwé'a Áánútunopa'a íma tiráawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ísu mináímbá simásuwena séna moórá kwántámai-aimba simátíménda ísáaro. moóráwai anóm-baragwarawai ména óntan-kurima úmakena ándá-aran-kigau úmarena ándá-arankona tááve'a úmarena ándá-arambo mapándáápá ínana anombó kumínín-taave'a úmarena óntan-damba kígaura'o taviyí-námbá úmarena ayáátááka'a ó'om-barava'a koménae séna maankígáúrá'ó taviyíyawaimo é'a kesáváí évakar-aramba maé'a évaka'a kembá siyúwáaro simátimena ó'om-bapa'a komáyáísana ");
INSERT INTO kze_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","arambó ávumo kain-kánáá tisaná aanávómá kesí ándá-aramba komáyáaro séna kwená kwayó'nárawa'a ti'máráísasa minkígáúrá'ó tavíyéwaitopa'a tewasá ");
INSERT INTO kze_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","táto'mai moóráwaimba tuvuwésa moóráwaimba tuvú'maraawana púwísasa moóráwaimba óntandei tuvuwésa ándá-aramba íma tímémba ti'mátuwaawasa kowaná ");
INSERT INTO kze_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","aanávómá aiva'á kwená kwayó'nárawa'a évaka'a ti'maréna naaémba sáwívarawai ti'máráísasa tewasá minkígáúrá'ó tavíyéwai táto'mai aiva'ó uráantemba mirá ésa sáwí'a umátinkesa ándá-aramba íma tímémba ti'mátuwaawasa kowaná ");
INSERT INTO kze_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","aanávómá ména naaémba séna kesááninkomba ai'máráanana kwínasa kwenáái isánááowe séna ai'máráísana tisasá ");
INSERT INTO kze_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","minkígáúrá'ó tavíyéwai awánésa keáímbá sésa aanávómbá ááninko kwétimba póta tuvúwónana puwéna maankígáú íma mayáínata kesáá mayánáe sésa ");
INSERT INTO kze_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","táto'mai ándá-aran-kigauvakemba awéntayuwesa tuvúwówana pukáiye. ");
INSERT INTO kze_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ísu mináímbá simásuwena séna minkígáúgó aanávómá tínímba kígaura'o tavíyéwai nóra síníyo súwasa ");
INSERT INTO kze_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","miwí sésa misáwí-kwáásí tínkaminasa puwíyana ó'on-kwaasi kesí kígaura'a tavíyéro sínasa minkígáúrá'á taviyésa arambó ávumo kain-kánáá tíndantemba aanávómbá minárámbá aménááowe siráawe. ");
INSERT INTO kze_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","suwaná Ísu simátimena séna Áánútun-aai aúváívimba awánaraawe. maarán-áímbá agaimaréna séna óntan-damba on-kwáásí moórá-ontantavesa sáwí'a kwéiye sésa maisukáawe. aáno minóntánkó ávonkaaamba uráiye. mindá Ísóigo isatá awánéta séta ó'oran-kawe'a uráiye kwésune agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","mináímbá imáyáa é'a simátime'a sé'a Áánútu keinárawa'a Yútaa-kwaasiyavena maará séna kenká'á íma kawáá-ónaumne séna tiyuwéna ó'onkaa-kwaasiyavena kenká'á kawáá-ónaumne sínasa kwená mayáí mayánááowe. ");
INSERT INTO kze_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","minóntánká'á tanaambá kovésa sáwí'a umái ménaaovo minóntánkó tuvú'mái sáwí'a umásuwaniye Ísu séna kwenááiyavesamo ímo áraire síyawai imáyáa éna mináímbá siráiye.  ");
INSERT INTO kze_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ísu súwasa mono-káwáá-kwáásíyé ámáán-kawaa-kwaasiye isésa tááko pééi súwasa sésa moóráwai ááninkai kwaasáimo simbá kentááyávéna siyé sésa ándá-aran-kigaura'o tavíkáawaiyavenamo simbá kentááyávéna siyé sésa óntankowemo simbá kentááyávéna siyé sésa ");
INSERT INTO kze_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","táto'mai tuvuwónáe sésa umbá amápa-kwaasi Ísuntavesa sésa Áánútun-aai simásímíwaiman-iye sun-kwáásí táároi inkaisésa Ísumba íma tátoresa ivátukaawe. ");
INSERT INTO kze_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","moórágwara'a Ísu aaí simátimindayavena kwántámai-aimba simátimena séna ");
INSERT INTO kze_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Áánútu kwená kwaásimo kawááin-aimba maarán-áímbán-iye. moóráwai kárákwiraiwai ááninko aaraí mayáníntavena anón-tanomba kauvónáe séna ");
INSERT INTO kze_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","sáwíva-kwaasi tááyena séna aáno tanómba tamandaaró séna ména tanómba kaumaréna kwená mayáí-kwáásí ti'maréna séna tamandaaró kosimátíméro sisasá mirá owasá ivátuwesa íma tewaná ");
INSERT INTO kze_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ó'omba mayáí-kwáásí ti'maréna séna tááyaraundawai kosimátime'a sé'a toómbó naí kwéto'mayaa é'a purumakané naanté-póíyé tuvú'mái kwégauvumpo tamandaaró. kesááninko aaraí mayáindara'a tamandaaró. kosimátíméro séna ti'máráísasa mirá kosewasá ");
INSERT INTO kze_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ivátuwesa íma tésa moóráwai kwená kígauva'a kówisana moóráwai óntambo kwémayaim-bayaiva'a kówisasa ");
INSERT INTO kze_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","évakarawai kárákwiraiwaina mayáí-kwáásíyómbá táto'mai tínkamowasa púwówana ");
INSERT INTO kze_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","kárákwiraiwai áwáá'a séna kwená i-kwáásí ti'máráísasa miwí tínkamowasa púwówasa miwítí naampimpá'á iramá agagaowaná kágwisana ");
INSERT INTO kze_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","kárákwiraiwai kwená mayáí-kwáásíyávéna séna tanómba kauvé'a tááyaraundawai kesááninkona tanómba tamandaígómbá uwóví'an-owe. ");
INSERT INTO kze_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","aantáá'o kwaásimo torupamáímo máyáapa'a kotivakáá-umai ó'on-o'on-kwaasi tuwáné'a simátimiyasa tanómba tamandaaró sisasá ");
INSERT INTO kze_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","kwená mayáí-kwáásí isésa aampa'á kwénaaesa kwaási tivakáá-umai tuwánésa sáwí-kwaasiye kawe-kwáásíyé torupamátinkesa tí'maesa tésa toómbó naí-náúmpá'á sisipáá uráawe. ");
INSERT INTO kze_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Yútaa-kwaasi aaraimó máyáanka'o ombá tanómbo nánáesamo ten-kwáásí ontará'ó tewasá mayáí-kwáásí kawer-únánkwátói tíméwasa urésa mindáúmpá'á umésa toómbá kwénaavo minúnánkwátóimo ímo urésamo ésa íma toómbá umandánááowe. toómbó naí-náúmpá'á sisipáá owaná kárákwiraiwai tuwánaimba moóráwai íma kawer-únánkwátói uréna máyáísana awánéna ");
INSERT INTO kze_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","séna nóra éwa kawer-únánkwátói íma uréwa iráano sisaná íma aaí sisaná ");
INSERT INTO kze_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","kárákwiraiwai kwená mayáí-kwáásíyávéna simátimena séna aíyayaanka'a asááumai máápa'a túnkwi-ayampa'a aúwéwana ivi'á téna áí'o índayavena áwááyaamba akévundaniye siráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ísu mináímbá simásuwena séna Áánútu sáwíva-kwaasi tááyain-kwaasivinkemba évakarawaiye su'mai kwená kwaási-i'a kwéumatinkaiye siráiye. ");
INSERT INTO kze_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ísu súwasa ámáán-kawaa-kwaasi máápa'a kumbésa keáímbá sésa nóran-ainta áísaa onanayá sáwí-aimbo sínata aaivintá mayankánaumno sésa ");
INSERT INTO kze_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","miwí tínaaembo kwárón-kwaasiye Éróti amááraawiye ti'márówasa Ísunopa'a tésa sésa anóndakoo árai-kwaasi po Áánútuna aambó kwáráan-aimba arupí umái kwésimatimendaya ísaraumne. kwaási táároi íma inkaisé anón-kwaasiye úwoi-kwaasiye táároi íma inkaisé tirumbá airá'mái-aimba íma séma arupí umái kwésimatimendaya ísaraumne. ");
INSERT INTO kze_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","simáménda-ainta isaaó. kanaarátááwá táákísi-ontamba Árómáani-kamaani-kwaasiya timénaum. íya timénaumno. timénaundaya Yútaa-kwaasiya kentáásí ámáámba araaisénaundaya'iyompo nóran-imayaamo émo e simásimiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ísu miwí tááma iséna imáyáa éna arumpimbá séna Árómáani-kamaani-kwaasi táákísi-ontamba tíméromo senasamó ésa Yútaa-kwaasi áwáá'a sésa Árómáani-kamaani-kwaasi sáwí'o umásínkáawaiya óntamba tíméro kwésiye sénááowe séna Árómáani-kamaani-kwaasi táákísi-ontamba íma tíméromo senasamó ésa Árómáani-kamaani-kwaasi áwáá'a sésa táákísi-ontamba íma tíméro kwésiye sésa aaivimbá maisinkánááowe-imayaa éna áísaa un-kwáásíyávéna séna kaumbo-káér-ainkwara-kwaasi pó'a kentávé'a sáwí-aimbo síndawe sé'a kwésisaa-owe. ");
INSERT INTO kze_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","táákísi-ontamba moórá maimái máagaraasinkaaro súwasa maimái máagaraarankowana ");
INSERT INTO kze_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","séna nááwa óikaana uráinkara áwí'a kwáyáiyo súwasa ");
INSERT INTO kze_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","miwí sésa Árómáani-kamaani-kawaanako óikaamba isaná áwí'a kwáyáiye suwaná Ísu séna Árómáani-kamaani-kawaanakondei kwembá áméro. Áánútundei Áánútumba áméro súwasa ");
INSERT INTO kze_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","mináímbá ísówana táá'a kówasa íma aaí sésa auwésa kuráawe. ");
INSERT INTO kze_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","kuwasá Sátúsi-monor-aimbo sun-kwáásí púwómpinkemba íma usásinanaaowe kwésen-kwaasi pósa mitáwai Ísunopa'a tésa ");
INSERT INTO kze_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","sésa anóndakoo naaóvá'á Mósesi séna moóráwai aaraí maimakéna iyámpói íma ankéna púwísana ávákoma maimakéna awaaóná anondáwe séna iyámpói ankáníye siráiye. ");
INSERT INTO kze_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","moórá-aimba isaaó. moórá-tawai maanká'á avakaeté-avarawainonda mésa tuwaaómá aaraí maimakéna iyámpói íma ankéna púwísana ");
INSERT INTO kze_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","kwenánaaenkewai kware'á maimakéna iyámpói íma ankéna púwísana kwenánaaenkewai kware'á maimakéna iyámpói íma ankéna púwísana mirá eémesa avakaeté-kwaasi putásaawana ");
INSERT INTO kze_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","minínímbá naaémba pukáiye simásuwesa ");
INSERT INTO kze_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ísumba áísaa esa sésa mirámó ombá kwaásimo puwíyampinkembo usásinaiya-tawai minínímbá avakaeté-kwaasi tuwainímbá póna nááwa mayáníyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ísu séna Áánútun-aai aúváívimba agaimakón-aimba íma kawe'á umái isé'a Áánútuna asirayámbá íma awáné'a pó'a miráumai sáwísawaa-aimba kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","pukémpinkemba usásinesa kwíyómpa'a uménaaon-kanaa aaraí íma mayáíyasa kwaaí íma mayáíyasa ésa Áánútuna kwayó'nárawa'o kwíyómpa'o máéwaimo ontembá minínínákwá'á miráumai aaraí íma mayáíyasa kwaaí íma mayáíyasa ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","kwaási pukémpinkemba usásinanaaomba simátíménda ísáaro. Áánútu simátímakomba aúváívimba agaimakón-aimba awánaraawe. ");
INSERT INTO kze_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Áánútu Mósesintavena maarán-áímbá séna Áánútu úne. enaíkwá'ná Ááváramune Áísákaane Yákópone miwítí Áánútu úne siráiye. Áánútu mináímbá siráimba minkáúmbó-kwáásí á'a púwúwasa utamátínkaraambanivo mináímbá siráimba pósa miwí úwoi máyáawe Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","kwesémo máyón-kwaasi isésa táátavesa ésa sésa ááin-kwasai kwésimasimiye siráawe. ");
INSERT INTO kze_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","suwaná Ísun-aaigo Sátúsi-monor-aimbo sun-kwáásí táái usáyaaitomba ámáán-kawaa-kwaasi isésa torupamái mésa ");
INSERT INTO kze_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","miwívínkémbá moóráwai ámáámba kawe'á umái ísarowai Ísumo sáwí-aimbo sínda isánáe séna áísaa ena séna ");
INSERT INTO kze_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","anóndakoo Áánútuna ámáámpinkemba nóran-amaana aivar-ámáámbán-iyo súwana ");
INSERT INTO kze_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ísu séna Áánútun-aai aúváívimba agaimaréna séna Áánútumpa'a kentí Ísóigomba kentiruné kentí imáyáawe kentimané áméro agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","minámáámbá aivar-ámáámbá isaná ");
INSERT INTO kze_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","miwá ánaaenken-amaamba anón-amaamba maarán-ámáámbán-iye. Áánútun-aai aúváívimba agaimaréna séna kesáváí-ímáyáámó ontembá kentí kwaásiti imáyáagwara'a oró agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","minkáér-ámáánkó ávonkaamba uráisana Mósesimo ó'on-amaambo siráine Áánútun-aai simátímakowai siráan-amaane megwí-megwiraamba éna kaer-ámáánkó ávonkaamba uraínka'a tagwéaraapaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","súwasa ámáán-kawaa-kwaasi torupamái máyówana Ísu miwí tísaa ena séna ");
INSERT INTO kze_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Áánútumo usásinankaiwai Káráísiti nááwan-andaraken-kwaasiya'iyo súwasa kentáásíkwá'ná Tévítin-andaraken-kwaasiman-iye suwaná ");
INSERT INTO kze_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ísu séna naaóvá'á Áánútun-amanko Tévítimba imáyáa amúwana Tévíti Káráísitintavena séna kesí Ísóigoman-iye siráimba ");
INSERT INTO kze_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","monor-ímá agaimakón-auvai-kwandaaivimba Tévíti agaimarena séna kesí Ísóigonatavena Áánútu séna kesiyáánúrapa'a asirayán-áyámpá'á mara'á ména'a ená namuro-kwáásí usáyaaitaanasa miwí ánásanaaowe Áánútumo siráin-aimba Tévíti siráiye. ");
INSERT INTO kze_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","miráumai Tévíti Káráísitintavena séna kesí Ísóigoman-iye siráimbanivo nóraumaiya kwemá Tévítin-andaraken-kwaasiman-iyo Ísu súmba ");
INSERT INTO kze_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Káráísiti Tévítina Ísóigoma éna Tévítin-andaraken-kwaasigoman-iye súmbanivo miwí íma kanaán-umai aaí sésa táátavesa ésa minkánáárákémbá íma áísaa úmaesa iráawe. ");
INSERT INTO kze_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ísu torupamái máyón-kwaasiye kwená kwayó-kwáásíyé simátimena séna ");
INSERT INTO kze_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Áánútu usásintinkaraisasa ámáámba sen-kwáásíyé ámáán-kawaa-kwaasiye Mósesi agaimakáin-aimba awánésa kwésimatimemba ");
INSERT INTO kze_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","isé'a kwáráaro. Mósesi siráin-amaamba miwí tóikakene su'mai sésa íma kwégwaraavo miwímó ontembá íma oró. ");
INSERT INTO kze_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","umbai-yántáá'ó asááúmakesamo túgwaata'mae'a korómó sésamo ímo túwa'naa ontembá miwí umbai-áímbá simátimesa íma túwa'naa ombá úwoi kwáráaro kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","miwí sésa kwaási suwánésa anón-kwaasin-owe sígwáe sésa Mósesi siráin-amaamba agaimái anavéúmpimba makésa túwayaankare tiyáánkare asááúmaresa miwítí kwátói-araira'a ayáátááka'a taváákarara úmakesa naaópa'a avuvumpa'á kwénaaesa ");
INSERT INTO kze_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","tanómbo kaúvópa'o máyáapa'a kawer-áyámpá'á mésa mono'-náúmpá'ó umáyáapa'a anón-kwaasimo maí-áyámpá'á umésa ");
INSERT INTO kze_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","kwaási suwánésa sésa anón-kwaasi monor-áímbá simátíméwain-owe sígwáe sésa naaópa'a avuvumpa'á kwénaaesa mirámó ontávésa aamoí kwéowe. ");
INSERT INTO kze_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","miwí mirá kwéombanivo íma mirá oró. keinárawatavesa anón-kwaasi monor-áímbá simátíméwai owémó síyambo é'a kímborawai anón-kwaasi isatá kwená kwaásiya mimbóráí'a umáíya máyaumne seró. ");
INSERT INTO kze_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","keinárawapinkemba moóráwaintave'a anón-kwaasi kesivón-iye sevó. kentivó kwíyómpa'a máyáiye. ");
INSERT INTO kze_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","keinárawapinkemba moóráwaintave'a kentáára'a kárákwiraiwain-iye sevó. Áánútumo usásisinkaiwai keyáá keinárawaka'a kárákwiraundawai kemá úne. ");
INSERT INTO kze_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","keinárawapinkemba usáyaaitanae síyawai keinárawati kwayó'-máyáí máyáaro. ");
INSERT INTO kze_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","kentúwí'o mósá maráíyawaima Áánútu úwoi-kwaasiraamba umátinkanivo kentúwí'o ímo mósá maráíyawaima Áánútu mósá tinkáníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ísu mináímbá simásuwena séna ámáámba sen-kwáásíyé ámáán-kawaa-kwaasiye simátíménda ísáaro. kaumbo-káér-ainkwara-kwaasimo é'a kárákwiyoro. Áánútu kwená kwaásimo kawááin-amba kwéitatinkaawe. Áánútu kwená kwaásimo kawááin-ampa'a íma kónáe sé'a kónáe kwéowaiti aambá kwéitatinkaawe.  ");
INSERT INTO kze_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ámáámba sen-kwáásíyé ámáán-kawaa-kwaasiye kaumbo-káér-ainkwara-kwaasi é'a ketor-íníntí óísankwara naankwará'á umóyámbá kwémae'a kwaási suwánésa súwí'a mósá maráígwáe sé'a kampakómbá tavisimái-namunaa kwésewe. mindáyave'a kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ámáámba sen-kwáásíyé ámáán-kawaa-kwaasiye kaumbo-káér-ainkwara-kwaasi é'a simátimunda monor-áímbá kwaráígwáe sé'a tivakáá úmae'a anón-domba kóate'a némpa'a kwénaae'a tuwáné'a kentí sáwí-mayai agaráátínkáawasa miwítí sáwí-mayaigo kentí sáwí-mayaigomba usáyaaitaraimba pó'a mindáyave'a kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","aambá íma kawe'á umái awáraawai kampa'á sé'a maarán-ámbá kwáráaromo kwésewai kárákwiyoro. keinárawa'o monor-áímbó sembá kampa'á simátime'a sé'a anóm-bono'-nankon-aai tivamíra'a marésa sésa mirá ónaumnemo sembá minímáyáámó ivátuwaiyanamo éna kanaán-íníye. ánivo kawer-óntámbá áwí'a kóri-ontankon-aai tivamíra'a marésa sésa mirá ónaumnemo sembá minímáyáámó ivátuwaiyanamo éna sáwí'a íníye kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","minkórí-óntánkó anóm-bono'-nankomba íma usáyaaitaraivo mindáúmpá'ó kwénimba mindá kawe'án-iye. keinárawa'a monor-áíntávéna tááko íma pééi sisa'á kwéisaawe. sáwí-imayaagwara-kwaasi simátímén-aimba kampar-áímbán-iye. ");
INSERT INTO kze_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","keinárawa'o monor-áímbó sembá kampa'á simátime'a sé'a Áánútuntavesamo póímo tuvú'máímo agáyáan-taareigon-aai tivamíra'a marésa sésa mirá ónaumnemo sembá minímáyáámó ivátuwaiyanamo éna kanaán-íníye. ánivo mintááréírá'ó Áánútumbo kwéame-poigon-aai tivamíra'a marésa sésa mirá ónaumnemo sembá minímáyáámó ivátuwaiyanamo éna sáwí'a íníye kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Áánútumbo ámém-poigo mintááréígómbá íma kwéusayaaitaivo mintááréígó usáyaaitarena ámém-poi kawe'á kwéiye. keinárawa'a monor-áíntávéna tááko íma pééi sisa'á kwéisaawe. sáwí-imayaagwara-kwaasi simátímén-aimba kampar-áímbán-iye. ");
INSERT INTO kze_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","asirayán-áímbó sembá Áánútuntavesamo póímo tuvú'máímo agáyáan-taareigon-aaimo tivamíra'o marésamo sésamo ésa mintááréígón-ááigwara'a Áánútumbo kwéamem-poigon-aaigwara'a kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","asirayán-áímbó sembá anóm-bono'-nankon-aaimo tivamíra'o marésamo sésamo ésa mindánkón-ááigwara Áánútu mindáúmpá'á máyáiwain-aaigwara'a kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kwíyónkon-aaimo tivamíra'o marésamo sésamo ésa Áánútu mivá'á kárákwiraiwain-aaigwara'a kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ámáámba sen-kwáásíyé ámáán-kawaa-kwaasiye kaumbo-káér-ainkwara-kwaasimo é'a kárákwiyoro. naaóvá'ó Mósesimo siráintemba kentí kígauvakemba sáwíyan-tonkwara'a taaínkaar-umai siyáánkai maké'a moórá Áánútumba kwéame'a kawe'á kwée'a mirán-ámáámbá ísámai iyé'anivo Mósesimo siráin-amaamba anón-amaamba ivá'á tu'maré'a pó'a kwaási íma arupí umátinke'a tirumbá íma umátinke'a íma Áánútuntave'a asiramáí-imayaa é'a mirá ontávé'a pó'a minánón-ámáántómbá ivá'á tukáawe. ");
INSERT INTO kze_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","aambá íma kawe'á umái awáraawai kampa'á sé'a maarán-ámbá kwáráaro kwésemba sáwíyan-amaamba kwaré'a anón-amaamba tukáawe. mirámó ombá toómpímbá kankambá kwáyáísa'a kíto-kankamba túkúyuwe'a anón-kankamba mindágwara'a kwénaantenkaan-kwaasin-owe. ");
INSERT INTO kze_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ámáámba sen-kwáásíyé ámáán-kawaa-kwaasiye kaumbo-káér-ainkwara-kwaasimo é'a kárákwiyoro. anavéúne táávere paákáré su'mai kwésese owain-ovo andáámpa'a sáwí'a uráisa'a pó'a kempímbá sáwíva-tantaa'a anómba kwáyáiye. ");
INSERT INTO kze_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ámáán-kawaa-kwaasiyono. monor-áíntávéna tááko íma pééi sisa'á kwéisaawe. anavéúne táávere andáámpa'o sese owanamó andáámpare paákáré kawe'ó kwéintemba kentí sáwí-imayaa tuwé'a kawer-ímáyáá umái máéro. ");
INSERT INTO kze_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","ámáámba sen-kwáásíyé ámáán-kawaa-kwaasiye kaumbo-káér-ainkwara-kwaasimo é'a kárákwiyoro. kwaásimo maipímbó utámakaawanamo kaviraisasamó kwaási ímo awánaantemba kentirumpímbá mirá isa'á sáwí'a kwéowasa kwaási íma kwétuwanaawe. kwaásimo maipímbó utámakesamo kanaagunémo owasá awánésamo sésamo kawe'á kwéowe sentembá keinárawa'a tuwánésa kawe-kwáásímán-owe sembánivo kentirumpimbá mirá-sáwí-yántáá'á kwáyáísa'a kaumbo-káér-ainkwara-kwaasiman-owe. ");
INSERT INTO kze_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ámáámba sen-kwáásíyé ámáán-kawaa-kwaasiye kaumbo-káér-ainkwara-kwaasimo é'a kárákwiyoro. kentíkwá'ná Áánútun-aai simátímakowai tínkamuwasa púwúwa'a utamátínkaraapa'a konaarirí kwéowe. arupí umái máyón-kwaasi tínkamuwasa púwúwa'a utamátínkaraapa'a konaarirí kwée'a ");
INSERT INTO kze_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","sé'a miwí tísaavutantamba uráawai sé'a minkánáávímbó métaraiya kentáá síkwá'námo uráantemba íma miráyá uráusino kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","mirán-áímbó kwésembo maarán-áímbá sé'a Áánútun-aai simátímakowai tínkamesa mirá-sáwí'á uráawai tírááta úne kwése'a miwímó uráantemba mirá kwéowe. ");
INSERT INTO kze_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","kentíkwá'námo uráantembo mirámó kwée'a ánásanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ánásanaaomba iyánkó póígon-araa'an-owe. Áánútu keinárawa'a aaivimbá matinkáína'a sáwí-meyambo mayánááopa'a iramó kwégaipa'a tu'maá'námo ímo kwáyáipa'a kónááowe. ");
INSERT INTO kze_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","miráumai kesáái simátimenaaowaiye agaráátinkanaaowaiye kawer-ímáyáágwárá-kwáásíyé ti'máráanasa keinárawapimba kwénaaiya'a évakarawai tínkamiyasa puwíya'a évakarawai taaira'á tínkamiyasa puwíya'a évakarawai kentí mono'-náúmpímpá'á taándéí tínkame'a moórá-mora-naopimpa'o kwénaaiya'o é'a ti'mátu'mae'a naaónááowe. ");
INSERT INTO kze_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","mirámó íyana arupí-kwaasimo tínkamom-beyamba amáparawaiti meéyámbá kentópa'a tíníye. aiva'ó tuvúwanamo pukáin-kwaasigo áwí'a Épeo naaémba moóráwai Pérékaya ááninko áwí'a Sékáraya anóm-bono'-naumpa'a máyowana moórá-ayampa'a Áánútuntavesamo ísámaimo póímo tuvú'máímo agáyáan-onta-tarei kwáyowana moórá-ayampa'a aiva'-mónó-káwáánákówé su'mai iyún-ontama kwáyowana avumpimbá Sékáraya umáyowasa túvúwana pukáiye. ");
INSERT INTO kze_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","minkáé-kwáásíráítí avumpimbó agairáan-kwaasi tínkamuwasa pukáawaigwara'a miwítí sáwí-meyamba ívé'o máyáan-kwaasi mayánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ísu mináímbá simátímatuwena Yérúsaremu-naopaken-kwaasi arumbá umátinkena séna Yérúsaremu-naopaken-kwaasiyono. Áánútun-aai simátímakowai tínkambae'a kwéiyuwasa pukáawe. Áánútu ti'marówasa kurówai óntantamba tínkambae'a kwéiyuwasa pukáawe. kokórigomo áráátombo ayóí-ándámpá'ó tínkarenamo káátamatinkaintemba aasiyaasi-táwai kemá mirá ónaumne kwésundanivo tínaaemba kwéumasimewe. ");
INSERT INTO kze_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ísáaro. Áánútu tiyuwáína'a tu'nankáámbá ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","simátime'a sé'a íma úwoi suwánanaaovo naaémbo sé'o Áánútu ai'máráísana kunkáiwaimba Áánútu kawe'á kwéumankaiye síyanka'a moórágwara'a suwánanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ísu mináímbá simásuwowasaya anóm-bono'-naumpakemba kárúwesa kúmúmba kwená kwayó-kwáásí sésa anóm-bono'-namba kawe'-námbán-ivo awánaao suwaná ");
INSERT INTO kze_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ísu séna ívé'o awánaan-dantave'a simátime'a sé'a aáno kwaási tésa mindámbá amápa'a tawísíyuwesa amápar-ontankwarare tawísíyuwanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ísu mináímbá simásuwena Óríve-omaka'a umáyowasa kwená kwayó-kwáásí kweyáá máyonka'a tésa áísaa esa sésa emó sénda nósa-tawaiya tíníyo. nóran-awaamera ínata séta ákíra'a emá kuméma ívé'o kwáyáin-tantaa'a ánásaniye sénaumno suwaná ");
INSERT INTO kze_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ísu séna kampar-áímbá isé'a áraire sevó kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","sáwíva-kwaasi tóyo ésa kesúwí'a mágwétesa sésa Áánútumo usásisinkaiwai úne síyasa sáwívarawai minkámpár-áíntávésa áraire sénááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","áái'o tíyáán-aimba némpakena'i. egwaakéná'i. isáíyana íma táá'a kaíno. mirán-kánáámó tínda mindá íma amápa-tantaa'a ánásai-awaame'an-iye. ");
INSERT INTO kze_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","moórá-ayampa-kwaasimo áái'a tiyánááowe. moórá-kawaa-kwaasigomo éna moórá-kawaa-kwaasigona amááraayavena usásimbai áái'a tíyáaro sínasa usásinesa áái'a tiyánááowe. ó'on-o'om-barava'a ayawaimá táníye. ó'on-o'om-barava'a anóm-barima táníye. ");
INSERT INTO kze_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","mirán-tántáá'ó paárína'a sé'a amápa-tantaa'o ánásanin-kanaa íma tiráivo iyámpóímo tinkánáe owanamó anón-ti'o intembá umbai-kánáámó tínímba miráumai ááimba ásáiye seró. ");
INSERT INTO kze_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","mirán-áímbó síyasa minkákémbá keinárawa'a táto'mai ó'owima timíyasa sáwí'a umátinkesa tínkamiya'a puwónááowe. kentáváímó asiramáímo máyáantavesa ó'on-o'on-kwaasi amáparawai tíyámba umátinkanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","kesááiyavesa áraire kwésiyawaivinkemba sáwívarawai kesáái tínaaemba umámesa miwítí namuro-kwáásí moórá-morawai agaráátinkesa tíyámba umátinkanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","sáwívarawai paárésa kampa'á sésa Áánútun-aai simátimundawai úne sésa sáwívarawai kampa'á simátiyuwanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","miráumai sáwí-mayaigo kóyáwé éna anómba ínasa ó'owiti imáyáamo eémemba ivátuwesa kesáváí-ímáyááwé su'mai ónááovo ");
INSERT INTO kze_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ímo ivátuwesamo kentáváímó asiramáímo méwai ánásai-kanaara'a Áánútu tí'mai kawepá'á métinkaniye. ");
INSERT INTO kze_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","amápa'-maravaken-kwaasi isánááontave'a áséi-kwasai Áánútu kwená kwaásimo kawááin-aimba simátíma'mae iyíyana naaémba amápa-tantaa'a ánásai-kanaama tíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ísu mináímbá simásuwena séna naaémba ávááraumai inkaisí-yántáákómá paáriniye. naaóvá'á Áánutun-aai simátímakaiwai áwí'a Tánieri mintántáátávéna siráiye Ísu siráiye. kemá Mátíyu sé'a maanáúváímó torausíyawai tááko pééi sína'a ísáaro kwésune. Ísu séna Áánútuna kawe'-mápá'á misáwí-yántáá'á paárínasa awánanaaomba ");
INSERT INTO kze_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yútiyaa-marava'o máyaiyan-kwaasi omápata isaaisésa iyánááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ontará'ó máyaiyan-kwaasi íma naaúmpa'a iyíyamba óísamba ivátuwesa úwoi isaaisésa iyónááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","kígauva'o máyaiyan-kwaasi íma naaópa'a iyíyamba unáánkwátói ivátuwesa úwoi isaaisésa iyónááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","tímúkwarar-inimba ívér-iyampoigwarar-inimba minkánáámá sáwí'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","isaaisé'o iyónááomba táúgwi-kanaa iyé'a agándai-kanaa iyé'a únavo sé'a Áánútumpa'a námúnaa seró. ");
INSERT INTO kze_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","minkánáámá tínímba anón-umbai táníye. naaóvá'á Áánútu maramá tarórumba ívéka to'mái mirán-úmbáí-yántáá'á íma tiráiye. aánogwara'a mirán-úmbáí-yántáá'á íma tíníye. ");
INSERT INTO kze_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","mirán-úmbáí-yántáá'ó kwéin-kanaa Áánútu ákíse úmakaiye. mirán-úmbáí-yántáá'ó kwénin-kanaamo ayáátááka'o kwéninkakai amápa-kwaasi íma úwoi túvamai máésino. Áánútu ítámakain-kwaasiyavena imáyáa éna mirán-úmbáí-yántáá'á ákíse uráiye. ");
INSERT INTO kze_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ákísemo ínasa évakarawaimo simátimesamo sésamo Áánútumo usásinankaiwai mivá'-maava'a máyáiye síya'o é'a íma ísáaro. ");
INSERT INTO kze_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","évakarawai paárésa kampa'á sésa Áánútumo usásisinkaiwai úne síyasa évakarawai kampa'á sésa Áánútun-aai simátimundawai úne simátíma'maesa naaónááomba ímo awánem-bayai kwémaesa Áánútumo ítámakain-kwaasi kampa'á simátiyuwanae sésa mirán-ánóm-báyáí mayánááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","miwíyávé'a árai-kwaasin-owe sevó sé'a íma paáruraanka'a aiva'á simátimumpo kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","súnda-aimba imáyáa é'a naaémbo moóráwaimo kentávénamo sénamo paárurena kavóná-marava'a máyáiyemo sína'o é'a íma koró. moóráwaimo kentávénamo aúpá'á máyáiyemo sína'o é'a íma áraire seró. ");
INSERT INTO kze_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","kwíyómpa'o tawáombo úmae kwisasamó awánaantemba kemá kwaási úrandako kumpaáruraundawai miráumai avora'á ókwara'a kumónaumne. ");
INSERT INTO kze_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","póímo awáímó kaviraipá'ó náíndayavenamo evontáán-dúmáómó torupamáímo máyáintemba Áánútu sínana súnda-aimba paáriniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ísu mináímbá simásuwena séna mirán-úmbáí-yántáá'á tínín-kanaama ánásainana aaváúmá túnkwinana kwíyómba íma sán-káínana o'á kwíyómpakemba kuntínana kwíyónko tora'naára'a ínasa ");
INSERT INTO kze_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","amápa'-maravaken-kwaasi kwíyómpa'a awánanaaomba ó'oran-tantaa'a awánésa kentávésa sésa kumíníyena to'mayaa kwéiye sésa táátavesa kwéesa ivi'á kwétesa suwánanaaomba kemá kwaási úrandako anón-asirayankwara ságayankwara'a ainámpímbá kúmóna'a suwánanaaowe. ");
INSERT INTO kze_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","uwíremba kwése'a kwíyómpaken-kwayo'narawa'a ti'máráanasa Áánútumo ítámakain-kwaasi amápa'-maravakemba tí'maesa moórávimba torupanááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ísu mináímbá simásuwena séna moórá-tai naí-táígó áwí'a víki-taigontave'a imáyáa umái ísáaro. aráságáyómó agayáínda awáné'a sé'a áú'o sínín-kanaa sáwíyanka'a tíníye sénááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","mirámó intembá kemá súnda-yantaa'a ína'a awáné'a sé'a sáwíyanka'a kumíníye sénááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","árai'a simátime'a sé'a ívé'o máyáan-kwaasi évaka'a íma pukáiyanka'a kemó súnda-yantaa'a paáríniye. ");
INSERT INTO kze_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","kwíyómba maramá ánásainana kesáái íma ánásena úwoi kwaíkwai'a íníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ísu mináímbá simásuwena séna kúmónda-kanaama aaváúvímbá kwaási íma isááwasa kwíyómpaken-kwayo'narawa'a íma isááwa'a kemá Áánútu ááninkoma íma isáúnana kesivo kweyáá ísaraiye. ");
INSERT INTO kze_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","naaóvá'á moóráwai áwí'a Nówaa máyonka'a kwaási íma Áánútuntavesa imáyáa ésa maémáéntemba naaémba kemá kwaási úrandako kúmónda mirá ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","kavirayán-dónkómó ímo tínkankonka'a nombá toómbá kwénesa tiyáámúmbaa'a kwétokwaa-esa aaraí máyówasa kwaaí máyówasa kwéuwana Nówaa non-avóvomayaa'o kún-daumpa'a umáyowasa ");
INSERT INTO kze_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","kavirayán-dónkó tínín-aimba ísaresa íma imáyáa ésa máyówana anón-a'a téna kavirayán-dónkó amápa-kwaasi tínkamuwasa putásaraawe. mirámó uráantemba kemá kwaási úrandako kumpaáruraundawai ókwara'a kúmóndara'a kentávésamo ímo imáyáamo íyawai mirá ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","minkánáá maará ónááowe. kae-kwáásí kígauva'a méyana Áánútu moóráwaimba auwéna moóráwaimba airáníye. ");
INSERT INTO kze_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","minkánáá kaer-ínínkáí toómbá kwégwanteyana Áánútu moórá-inimba auwéna moórá-inimba airáníye. ");
INSERT INTO kze_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","kemá kentí Ísóigo kúmónda-kanaama íma ísaraavo kárákwimai máéro. ");
INSERT INTO kze_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","simátíménda-aimba imáyáa oró. naakó avowámó umóyán-kwáásímó tínín-kanaamo ísarenarai umóyán-kwáásí timbá kwéto'mayaa-ena awánéna kwatúwáísana kwená naaúmpakemba umóyámbá íma máyáísino. ");
INSERT INTO kze_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","miráumai kemá kwaási úrandako kumónaundayave'a pó'a keinárawa'a íma imáyáa kwéiyanka'a kumúnavainivo kwéto'mayaa-e'a simu'maré'a máéro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ísu mináímbá simásuwena séna kawe'-máyáímó kwémayaawai kawer-ímáyáágwárá-kwáásíyávé'a kwésune. kwená anóndako séna kesí mayáí-kwáásírá'á kárákwire toómbá taaímbai tíma'mae iyuwó síníye. ");
INSERT INTO kze_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","kwená anóndako téna kwená mayáímó kawe'ó umáímo mayáínda taawánáínana mayáímó kwémayaindawai arunkó kawe'á ínana ");
INSERT INTO kze_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","minánóndákó séna kesí náaindaamba amápa-tantaaka'a kárákwiyuwo síníye. ");
INSERT INTO kze_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ánivo mimbáyáí-kwáásígómó imáyáamo énamo kesí anóndako ayáátááka'a íma tíníye sénamo ");
INSERT INTO kze_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mayáí-kwáásí tínkamenamo toómbó nénamo uwoaó'-nómbá kwénaan-kwaasiye uwoaó'ó énamo ");
INSERT INTO kze_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kwená anóndako tínín-kanaa ímo ísarenamo ímo imáyáa kwéindara'a téna ");
INSERT INTO kze_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","anónka'a tainkámbai ai'mátuwena séna kaumbo-káér-ainkwara-kwaasimo mésamo tí'o kwéisasamo ivi'ó kwétesamo túwááyaambo akévundaresamo máyáapa'a kóaao síníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ísu mináímbá simásuwena aaraimó kwémayaawainá ááimba imáyáa éna séna naaén-kanaamo tínímba Áánútu kwená kwaásimo kawááin-aimba maarán-áímbán-iye. aaraimó mayáníwaimba toómbá náíyanesa siyáánkai-inaamaru oómbá kúra'maesa aampakémbá koáíkaawe. ");
INSERT INTO kze_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","minárásíyómbá éva'aasei sáwí-imayaagwara'a owasá éva'aasei kawer-ímáyáágwárá'á owasá ");
INSERT INTO kze_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","sáwí-imayaagwarar-arasi oómbá kúraresa ó'on-anaveumpimba iramó kánín-domba íma atíyoraawasa ");
INSERT INTO kze_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kawer-ímáyáágwárár-árásí oómbá kúraresa ó'on-anaveumpinkwara'a iramó kánín-domba atíyoresa ");
INSERT INTO kze_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","aaraimó mayáníwaimba koamu'makáawana íma ááéma tisasá túgávaa'a isasá tuún-kwaiguráawe. ");
INSERT INTO kze_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","tuún-kwáyáawana no'wáán-avuntamba moóráwai aayamái séna kwétivo koairánáisaiye sisasá ");
INSERT INTO kze_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","misíyáánkáí-árásí usásinesa oómbá to'maésa kombá ");
INSERT INTO kze_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","sáwí-imayaagwarar-arasi kawer-ímáyáágwárár-árásíyávésa sésa kentáásí iramá pisinánívo nombá atísimero sewasá ");
INSERT INTO kze_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","kesáágwárá'á miráumai kwéanasaivo nombó atíyén-daumpakemba komeéyámbáráaro sewasá ");
INSERT INTO kze_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","kwégowana aaraimó mayáníwai tisasá éva'aasei-arasi to'mayaan-umai máyáawai kwesé toómbó náíyanesa naaúmpa'a íyówana ");
INSERT INTO kze_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","onta umásúwáísasa minévá'ááséí-árásí nombó atiyénáesamo kówai tésa anónka'a sésa anóndakoo onta tisinkaaó sewaná ");
INSERT INTO kze_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","íma awánáúnda-arasi ombá pó'a íma onta titinkánaumne siráiye. ");
INSERT INTO kze_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ísu simásuwena séna miráumai kemó kúmónda-kanaa íma ísarenka'a kumónaumpo kárákwimai máéro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ísu mináímbá simásuwena séna naaén-kanaamo tínímba Áánútu kwená kwaásimo kawááin-aimba maarán-áímbán-iye. moórá-anondako némpa'a kwááyu koménae séna éna kwená mayáí-kwáásí tááyena séna kesí óntanka'a kárákwiyoro séna ");
INSERT INTO kze_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","moóráwai kwená mayáí kawe'-máyáí máyáísana awánaiwaintavena séna kesí óntamba éva'aasei-unamba kárákwiyuwo séna aména moóráwai kwená mayáí sáwíyanka'a kawe'-máyáí máyáiwaintavena séna kesí óntamba kaer-únámbá kárákwiyuwo séna aména moóráwai kwená mayáí sáwíyam-bayai máyáiwaintavena séna kesí ónamba moórá-unamba kárákwiyuwo séna aména tiyuwéna námpa'-marava'a kówisana ");
INSERT INTO kze_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","éva'aasei-unan-ontamba mairáiwai minóntándéí mayáí maimaé kwégwena ó'omba éva'aasei-unan-ontamba máyáísana ");
INSERT INTO kze_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","moóráwai kaer-únán-óntámbá mairáiwai minóntándéí mayáí kwémaena ó'omba kaer-únámbá máyáísana ");
INSERT INTO kze_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","moóráwai moórá-unan-ontamba mairáiwai minóntándéí íma mayáí maéna úwoi maravímbá utámakaiye. ");
INSERT INTO kze_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","utámakaisasa mirá kwéowana miwítí anóndako ayáátááka'a kuróm-bapa'a mivá'á ména naaémba téna kwááyumo tímakaunda-ontamba torupamái awánanae séna tááyaisasa ");
INSERT INTO kze_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tésa éva'aasei-unan-ontamba mairáiwai maimaéna máagaraarankena séna éva'aasei-unan-ontambo símakaandavinkemba mayáí kwémae'a ó'omba éva'aasei-unan-ontamba mairáumne sisaná ");
INSERT INTO kze_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","anóndako séna kesí mayáí-kwáásígó kawe'á óne. kentávémo imáyáamo émo sáwíyan-tantaaka'o kawe'ó umáímo kárákwiraandantemba sáwíva-tantaaka'a kárákwiyiniyone. kesirunkómó aamoimó intembá kesé taménana enarunkó aamoí íno sisaná ");
INSERT INTO kze_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","kaer-únán-óntámbá mairáiwai maimaéna máagaraarankena séna kaer-únán-óntámbó símakaandavinkemba mayáí kwémae'a ó'omba kaer-únán-óntámbá mairáumne sisaná ");
INSERT INTO kze_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","anóndako séna kesí mayáí-kwáásígó kawe'á óne. kentávémo imáyáamo émo sáwíyan-tantaaka'o kawe'ó umáímo kárákwiraandantemba sáwíva-tantaaka'a kárákwiyiniyone. kesirunkómó aamoimó intembá kesé taménana enarunkó aamoí íno sisaná ");
INSERT INTO kze_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","moórá-unan-ontamba mairáiwai maimaéna máagaraarankena séna emá asirayán-kwáásí éma ó'owiti mayáívínkémbá toómbá kwéne ó'owiti kígaurakemba úwoi kwénaae kwémandaana'a ");
INSERT INTO kze_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","enáároi inkaisé'a ená óntandei mayáí íma mayáúnda úwoi aúpá'á makáunda po ená óntamba mayáníyone sisaná ");
INSERT INTO kze_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","anóndako séna sáwí-mayai-kwaasigo kavóná-kwaasi po kentávémo sémo ó'owiti mayáívínkémbá toómbá kwéne ó'owiti kígaurakemba úwoi kwénaae kwémandaana'a óne sénda po ");
INSERT INTO kze_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kesí óntambo amápa-kwaasiti óntambo máráan-daumpa'o makáandarakai tiré'a kesí óntankwara aa'wáá-ontankwara'a mayáúsino séna ");
INSERT INTO kze_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","kwená mayáí-kwáásíyávéna séna minóntámbá mairé'a siyáánkai-unan-ontambo tokáiwaimba áméro. ");
INSERT INTO kze_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","sáwíva-tantaaka'o kawe'ó umáímo kárákwisinkaiwaimba moórá-mora-yantaa'a áménana kárákwisinkanivo ímo kawe'ó umáímo kárákwisinkaindawaimpakemba makáimba máyáana'a ");
INSERT INTO kze_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","misáwí-máyáí-kwáásígómbá áí'mae'a máápa'a móru auwáíyana túnkwi-ayampa'a tí'o kwéisasamo ivi'ó kwétesamo túwááyambo akévundaresamo máyáapa'a kwíníye siráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ísu mináímbá simásuwena séna kemá kwaási úrandako naaémba kúmóndara'a ságayankwara kwíyómpaken-kwayo'narawakwara'a kárákwiraundawai pó'a kúmónasa ");
INSERT INTO kze_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","amápa'-maravaken-kwaasi kesúranka'a torupamái máyaiya'a sipisípi-poiye méme-poiraremo kárákwiraiwaimo taaímbaraintemba minkwáásíyómbá miráumai taaímbake'a ");
INSERT INTO kze_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","évakarawai siyáánúrapa'a mótinke'a évakarawai siyáánepa'a métinke'a ");
INSERT INTO kze_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","kárákwiraundawai siyáánúrapa'o maíyan-kwaasiyave'a sé'a kesivo kawe'á umátínkáiwain-owe. Áánútu maramó taróruronka'a kentí imáyáa éna kentí maru'á to'mayaa úmakaivo mivá'á tamáéro. ");
INSERT INTO kze_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","kawe'á umásinke'a kembó sááimo sinkómbo toómbá simé'a nombá simé'a ó'om-bapaken-kwaasimo ówánda aamoí umásinke'a kentí naaúmpa'a mógwésinke'a ");
INSERT INTO kze_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","unáánkwátói-iyaaimbo ówánda kwésime'a sí'o úmba kwégarakwiye'a ándáva'o maéwánda kwésuwa'naa-e'a mirá umásínkaraawe. mirán-áímbá senasá ");
INSERT INTO kze_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","arupí umái máyáawai sísaa esa sésa Ísóigo nósa-tawaiya embó ááimo ankómba toóné noné améta ");
INSERT INTO kze_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","nósa-tawaiya ó'om-bapaken-kwaasiraambo undá aamoí umánketa kentáásí naaúmpa'a móanketa nósa-tawaiya unáánkwátói-iyaaimbo undá améta ");
INSERT INTO kze_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","nósa-tawaiya áí'o úmba áwa'naa eta nósa-tawaiya ándáva'o maúnda áwa'naa uráumno síya'a ");
INSERT INTO kze_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","kárákwiraundawai sé'a árai'a simátime'a sé'a kesí kwaási úwoi-kwaasi miráumaimo túwa'naa uráamba mindá kembán-iye simátimenaumne. ");
INSERT INTO kze_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","mirá simátímatuwe'a siyáánepa'o maíyan-kwaasiyave'a sé'a Áánútu sáwí'a umátinkaniwain-ovo siyuwé'a kóro. Áánútu Sáátáánigone kwená kwayó'náraware imáyáa éna anón-irama to'mayaa umátínkaraisana kaíkai'a éna íma pisínáípa'a mivá'á komáéro. ");
INSERT INTO kze_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kembó sááimo sinkómbo toóné noné íma simé'a ");
INSERT INTO kze_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ó'om-bapaken-kwaasimo ówánda íma aamoí umásinke'a kentí naaúmpa'a íma mósinke'a unáánkwátói-iyaaimbo ówánda íma simé'a sí'o úmba íma súwa'naa e'a ándáva'o maéwánda íma súwa'naa e'a mirá umásínkaraawe. mirán-áímbá senasá ");
INSERT INTO kze_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","sísaa esa sésa Ísóigo nósa-tawaiya embó ááimo ankómba toóné noné íma améta nósa-tawaiya ó'om-bapaken-kwaasiraambo undá íma aamoí umánketa kentáásí naaúmpa'a íma móanketa nósa-tawaiya unáánkwátói-iyaaimbo undá íma améta nósa-tawaiya áí'o úmba íma áwa'naa eta nósa-tawaiya ándáva'o maúnda íma áwa'naa uráumno síya'a ");
INSERT INTO kze_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","kemá sé'a árai'a simátime'a sé'a kesí kwaási úwoi-kwaasi íma túwa'naa uráamba mindá kembán-iye simátimenaumne. ");
INSERT INTO kze_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","mirán-áímbá simátímatuwe'a aaí senasá miwítí sáwí-meyambo ímo ánásenamo kwaíkwai'o ínín-ayampa'a komaí'mai'a ónááovo arupí umái máyáawai aúnái'a umái maí'mai'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Ísu minó'ón-ó'ón-áímbá kwená kwayó-kwáásíyávéna simátímakaiye. naaóvá'ó Áánútu Yútaa-kwaasi tíyótaasa í-tánón-kánáá imáyáa éna séna kae'-nó'wáámbá kwaésa tíyótaasa í-tánón-kánáá tínímba kembá táto'mai taaira'á sínkamiya'a puwónaumne Ísu kwená kwayó-kwáásíyávéna simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","simátimuwasa mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye aiva'-mónó-káwáánákó áwí'a Káyavaasina naaúmpa'a torupamái mésa ");
INSERT INTO kze_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","sésa nóraumaiya aúpá'á Ísumba táto'mai inkamónaundaya'iyo. ");
INSERT INTO kze_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","amápa-kwaasi áái'a tíyáávainivo tanómbo kauvíyan-kanaara'a íma tuvuwónaumne siráawe. ");
INSERT INTO kze_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","suwaná Ísu Pétáni-naopa'a koména moóráwai áwí'a Sáímonina naaúmpa'a áúma kárúkokovaa'a uréna ánásarowaina naaúmpa'a ména toómbá kwénowana ");
INSERT INTO kze_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","moórá-ininko iyéna áséi-kwiyumba úm-basawemba anón-ontankakemba meéyámbakaim-basawemba maimaéna iyúmba Ísu a'nómpímbá atímarowasa ");
INSERT INTO kze_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","kwená kwayó-kwáásí awánésa áwáá'a sésa nóra séna mimbásáwémbá úwoi atíyankaiyo. ");
INSERT INTO kze_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","mimbásáwémbó ó'owimo timénamo anón-ontambo mairénamo ímo óísambo makáan-kwaasi tíméraambaniye suwaná ");
INSERT INTO kze_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ísu iséna ivátuwe'a íma áwáá'a aééro. kawe'á umái pésinkaiye. ");
INSERT INTO kze_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ímo óísambo máráan-kwaasi keséma maí'mai'a kwéiya'a túwa'naa ónáe sé'a túwa'naa ónááombanivo kemá keséma marapá'á íma maí'mai'a ónaumne. ");
INSERT INTO kze_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","púwóndara'a masawémba pésinkesa utamásinkanaaovo minínínkó á'a masawémba pésinkaiye. ");
INSERT INTO kze_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","árai'a súmpo maísáaro. kesí áséi-aimba amápa'-mapa'a kwésimatimesa minínínkómó umásinkain-aimba kwésimatimiyasa tááka'a maránááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","súwana Ísuna kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasivinkemba moóráwai áwí'a Yútási moórá-awi'a Isakéríóti mono-káwáá-kwáásítópa'a kwéna ");
INSERT INTO kze_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","séna Ísumbo tátoraiyantavaimo agaráátínkáana'o é'a nóraumai-meyana siménááoo súwasa moórá-kwaai aíyayaan-umai siyáánkai-ontamba 30 ontamba táámpamai ámúwana Yútási maimaéna ");
INSERT INTO kze_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","kwéna nóraumai Ísumba agaráátínkáanasa tátoranaao-imayaa ááimba ásámai uráiye. ");
INSERT INTO kze_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yútaa-kwaasi ímo intóráin-tantaakwara-pereti kwéagayon-kanaa aiva-táwai túntemba kwená kwayó-kwáásí Ísumba taáísaa esa sésa náávara tíyótaasa í-tánómbá kogauvónaundaya'iyo suwaná ");
INSERT INTO kze_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ísu séna Yérúsaremu-naopa'a kwékai moórá-kwaasigontavekai sékai kentáásí anóndako séna kesí kanaamá tisatá kesí kwayó-kwáásíyé ená naaúmpa'a tíyótaasa í-tánómbá nánaumne kwésiye kosimámékaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ísumo súntemba mirá ésarai minká'á tanómba mágauwankaraaiye. ");
INSERT INTO kze_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","tanómba mágaumakoyasa enónka'a Ísu kwená kwayó-kwáásíyé kwésa mindáúmpá'á umésa ");
INSERT INTO kze_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","toómbá kwémandesa uwaná Ísu séna keinárawapinkemba moóráwai kembá namuro-kwáásírá'á agaráátinkaniye súwana ");
INSERT INTO kze_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tirunkó umbaí tówasa moórá-mora-umai áísaa esa sésa Ísóigoo kewá'iyo sinté kuwaná ");
INSERT INTO kze_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ísu séna moóráwai kwená toón-ayai maimaéna kesé moórá-taavepimba tu'mái náíndawai kwemá kembó namuro-kwáásírá'ó agaráátinkaniwaiman-iye. ");
INSERT INTO kze_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","naaóvá'á Áánútun-aai aúváívimba agaimaréna séna kwaási úrandako puwíníye siráintemba pó'a púwónana namuro-kwáásírá'ó agaráátinkaniwai sáwí-meyamba mayáníye. kwembó ímo maránkaraankakaankasi kawe'á isinó Ísu súwana ");
INSERT INTO kze_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yútási kwembó agaráátinkaniwai séna anóndakoo kentáváíyá kwéseno súwana Ísu séna á'a séne siráiye. ");
INSERT INTO kze_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","súwasa toómbá kwénowana Ísu péréti maisoréna Áánútumpa'a súwi séna topámbai kwená kwayó-kwáásí tímatuwena séna mindá kesúman-ivo maimái naaró séna ");
INSERT INTO kze_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ándá-aran-dombo kwáyon-anaveumba maisoréna Áánútumpa'a súwi séna tiména séna amáparawai naaró. ");
INSERT INTO kze_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mindá kesí naaemán-iye. kesí naaemá sáwívarawaiyavena kumínímba póna Áánútu sáwí-imayaa maitiyuwéna séna kesé tarúmai máyáawe séna mináúná-áímbá simái tarúmakaiye. ");
INSERT INTO kze_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","simátime'a sé'a ókwara'a ándá-aran-domba íma nánaumpo kesivo kwená kwaásimo kwégawaaipa'a kesé ménaaomba ándá-aran-domba aúná-nomba nánaumne Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Áánútuntavesa ísámai monor-ímá simásuwesa mindáúmpá'á tuwésa Óríve-omapa'a iráawe. ");
INSERT INTO kze_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Óríve-omapa'a umáyówana Ísu simátimena séna Áánútun-aai aúváívimba agaimaréna séna Áánútu séna sipisípira'o kawááiwaimba tuvúwónana puwínasa sipisípiyomba kóyáwé ónááowe Áánútu siráiye siráimba póna ívé'-no'waamba táá'a káína'a siyuwé'a kóyáwé ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ánivo púwónasa utamásinkaiya'a usásine'a kentí aiva'á Káríri-ayampa'a kona'á kesínaaemba kónááowe Ísu súwana ");
INSERT INTO kze_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pítaa séna amáparawai auwésa kóyáwé íyambanivo kemá íma mirá ónaumne súwana ");
INSERT INTO kze_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ísu séna árai'a simáme'a sé'a ívé'-no'waamba kokórigo íma áái siráindara'a emá kaumborá'á kentáváí se íma awánáúnda-kwaasiye síníyone Ísu Pítaantavena súwana ");
INSERT INTO kze_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pítaa séna entémo sínkamonae íya'o é'a íma auwé'a kónaumne súwasa kwená kwayó-kwáásí amápa'a mirá simásaraawe. ");
INSERT INTO kze_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","amápa'a mirá simásuwesa Ísuwe kwená kwayó-kwáásíyé taai-kanáágúnéyómbá áwí'á Kétésémaniva'a komésa Ísu simátimena séna manká'á máyaiya'a Áánútumpa'a námúnaa kosénaumne séna ");
INSERT INTO kze_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pítaawe Sépéti ááninkaiye tí'maena komáyowana umbai-yántáákómá arumbá sáwí'a kwéuwana ");
INSERT INTO kze_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","simátimena séna kesirunkómá umbaiyé taisa'á pó'a puwóra'naraamba umái máyaumne. maanká'á mé'a kesé kárákwimai máéro séna ");
INSERT INTO kze_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","tiyuwéna egwaa'á kwéna Áánútu anónda'an-iye séna mara'á kumbaéna námúnaavinkemba séna kesivoó emó kanaán-iye sémo e maanúmbáí-yántáá'ó kesópa'o tínímba maisiyuwéma ánivo kesí imáyáa íma kwaréna'a ená imáyáa kwáráano Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ísu námúnaa simásuwena kwená kwayó-kwáásíráútópa'a téna tayuwánómba tuún-kwaigurówana tayúsena Pítaantavena séna íma kanaará'á sáwíyanka'a kesé kárákwimai máyáane. ");
INSERT INTO kze_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sáátáánigo tísaa umai isánáe-aimba kentópa'a síyáváínivo Áánútumpa'a námúnaa seró. imáyáago kató isaná áúgomo umbaimó taimbá mindá áúgávaa'a kwéiye simásuwena ");
INSERT INTO kze_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","moórágwara'a tiyuwéna egwaa'á kwéna Áánútumpa'a námúnaavinkemba séna minúmbáí-yántáá'á enópa'a úwoi tíníyemo sina'ó é'a emó sindantembá mirá ónaumne siráiye. ");
INSERT INTO kze_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ísu námúnaa kosimásuwena kwená kwayó-kwáásíráútópa'a téna tayuwánómba tuún-kwaigurésa túgávaate kwéuwana ");
INSERT INTO kze_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","moórágwara'a tiyuwéna egwaa'á kwéna ké'naamba námúnaa kosimásuwena koyauweréna ");
INSERT INTO kze_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","minkáúmbónárauyavena séna tuúmó kwaiguré'o máyáamba kemá kwaási úrandakomba sáwí'o kwéon-kwaasira'a agaráátinkainasa tátoranaaon-kanaa kwétivo ");
INSERT INTO kze_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","usásinewata kwétiyapata konó. kembó agaráátinkaniwai kwétiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ísu mináímbá kwésuwana kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasivinkemba moóráwai áwí'a Yútási túmba kwesé sáwíva-kwaasi taánasatagwara ánáyatankwara'a maimaésa tumbá mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye miwímá ti'márówasa tumbá ");
INSERT INTO kze_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ááéma Yútási Ísumbo agaráátinkaintavena simátimena séna paruvará umánkáandawaimba tátoraaro siráimba ");
INSERT INTO kze_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","póna Yútási Ísunopa'a téna séna anóndakoo máyaano kwésena paruvará kwéumankowana ");
INSERT INTO kze_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ísu séna kesí kwaásiyo ónáe sindáí'a uwó súwasa kwesémo tuwáí Ísumba tátórówana ");
INSERT INTO kze_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ísuna kwayó-kwáásívínkémbá moóráwai taánasatama ámúrandavinkemba taú'maena aiva'-mónó-káwáánákóná kwayó-kwáásígó áá'a agáúsuwowana ");
INSERT INTO kze_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ísu kwentávéna séna ená taánasatama ámúrandavimba kwiyuwó. taánasataneimo tínkamiyan-kwaasi anondámo ésa taánasatanei tínkamiyasa puwónááowe. ");
INSERT INTO kze_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","maaráyávé'a imáyáa oró. kesivontávé'o sé'o súwa'naa uwómó senanamó éna kwíyómpaken-kwayo'narawa'a sáwívarawai íma kanaán-umai táámpanaaowai avekáámbá ti'maráínasa súwa'naa ónááowe. ");
INSERT INTO kze_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","mirámó súndarakai Áánútun-aai aúváívimba agaimakáin-umbai-yantaa'a kesópa'a íma tisinó. ánivo siráintemba miráumai paáriniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ísu mináímbá simásuwena tun-kwáásíyávéna séna kentávé'a umóyán-kwáásímán-iye sé'a pó'a taánasatagwara ánáyatankwara'a maimaé'a kembá tátoranae sé'a kwétewe. sáwíva-tawai anóm-bono'-naumpa'a kesáái kwésimatimundara'a íma kembá tátokaawe. ");
INSERT INTO kze_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","naaóvá'á Áánútun-aai simátímakowai aúváívimba agaimakáan-aimba kembó mirámó umásínkéne'a kwétewe súwasa kwená kwayó-kwáásí amápa'a inkaisésa auwésa kóyáwé uráawe. ");
INSERT INTO kze_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","kwená kwayó-kwáásí auwésa kuwasá Ísumba tátorowai áí'maesa aiva'-mónó-káwáánákó áwí'a Káyavaasina naaúmpa'a móankesa mindáúmpá'á ámáámba sun-kwáásíyé Yútaa-anon-kwaasiye torupamái máyón-daumpa'a móankowana ");
INSERT INTO kze_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pítaa tínaaemba nénka'a teémáyomba aiva'-mónó-káwáánákóná máápar-ontavinkemba iréna naamaúva'a ména Ísun-ane'o paáríndamo awánáíndayavena i-kwáásíyé méraiye. ");
INSERT INTO kze_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pítaa máyowasa mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye amáparawai Ísumba tuvuwíyana puwíní-ainkona ááimba avakáá-uwana ");
INSERT INTO kze_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","íma kwáyowasa Ísuntavesa mósi-mesi-aimba sésa íma moórá-aimba suwasaráí kae-kwáásígóráí usásinesarai ");
INSERT INTO kze_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kampa'á sésarai kwemó sisatáámó isáúndaya anóm-bono'-namba Áánútuna naambá kanaán-umai tawísíyuwe'a kaumbo-táwai maisuwé'a ónaumne siráiye suyaná ");
INSERT INTO kze_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","aiva'-mónó-káwáánákó usásinena Ísumba áísaa ena séna mindáraimo simánkaayan-aimba anondá íya síníyono súwana ");
INSERT INTO kze_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ísu iséna íma aaí súwana aiva'-mónó-káwáánákó séna Áánútu asirayánkwáráwáí aúranka'a mé áísaa onda-áímbá árair-aine su'mai simásimiyo. Áánútumo usásinankaiwai Káráísiti Áánútu ááninkowa'onompo simásimiyo súwana ");
INSERT INTO kze_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ísu séna á'a sémpo simátime'a sé'a naaémba suwánáína'a kemá kwaási úrandako Áánútu asirayáwáíná ayáánúrapa'a asirayán-áyámpá'á umé'a ainámpímbá kumónaumne Ísu súwana ");
INSERT INTO kze_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","aiva'-mónó-káwáánákó arumbá sáwí'a kwéuwana kwená unáánkwátói tarátuwena séna Áánútumba aká'áámba simánkena kwesáváí simbá póta mináíntávéta aaivimbá mayankéta ó'on-aimbo simánkáamba avakáá únda póta ivátá tuwéta Áánútumbo simáímo sáwí'o umánkáintaveta ");
INSERT INTO kze_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","nóraya ónaumno súwasa sáwí'an-ivo tuvuwíyana puwíno sésa ");
INSERT INTO kze_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ísumba tuwirááíma kwirankésa tuvuwésa tiyáándei tuvúwún-kwaasi ");
INSERT INTO kze_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aká'áámba sésa esáváí se Áánútu usásisinkaiwai úne séndawai ómpo kemá nááwa kwétuvuwuna simásimiyo siráawe. ");
INSERT INTO kze_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pítaa naamaúva'a máyowana aiva'-mónó-káwáánákóná kwayór-árásígó awánéna kwenópa'a téna séna Káríri-ayampakewaise maéndawai óne súwana ");
INSERT INTO kze_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pítaa amáparawai túranka'a séna emó sénda-aimba sáákoma íma kawe'án-iye simásuwena ");
INSERT INTO kze_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","máápar-ontavimba komáyowana ó'omba kwayór-ínáámárúgó awánéna máyón-kwaasiyavena séna minkwáásígómá Ísu Násáreti-naopakewaiye maíwaiman-iye súwana ");
INSERT INTO kze_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pítaa aika'á maréna séna íma awánáúnda-kwaasiman-iye simásuwena máyowasa ");
INSERT INTO kze_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","sáwíyanka'a máyómba Pítaanopa'a tésa sésa Ísuna kwayó-kwáásí mirán-kwáásí máyáawata awánemayaundantenkaan-kwaasiraamba éma mináyámpákén-kwáásí tááiraamba kwésene suwaná ");
INSERT INTO kze_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pítaa séna kampar-áímbó kwésenanamo éna Áánútu sínkaminiye. síyawaimba íma awánáúndana'an-iye kwésuwana kokórigoma áái súwana ");
INSERT INTO kze_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pítaa Ísumo simámun-aimba ááka'a maréna mirá siráinka'a kokórigomo ááimo ímo siráindara'a emá kaumborá'á kentáváí se íma awánáúnda-kwaasiman-iye síníyone siráimba mináímbá ááka'a maréna máápa'a kuména ávááraumai ivi'á taráiye. ");
INSERT INTO kze_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ivi'á tówasa aaváúmá usónka'a mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye Ísumbo tuvuwíyanamo puwínín-aimba mimbórá-áímbá símaresa ");
INSERT INTO kze_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ísumba ayáánka'a asááúmaresa áí'maesa Árómáani-kamaani-kawaanako áwí'a Páírátinopa'a máankaraawe. ");
INSERT INTO kze_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Páírátinopa'a máánkarowana Yútási Ísuna kuntaru'á mairówai Ísumbo tuvuwónááomba awánéna séna ímo mirá oráámbá kemá sáwí'a úne séna kuntaru'ó ésamo ámakon-ontamba 30 ontamba maimaéna mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye miwítopa'a kwéna séna ");
INSERT INTO kze_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","íma sáwí'a uráin-kwaasi agaráátinkauna'a tuvuwónáe'a kwéomba kemá mindá sáwí'a úne súwasa miwí sésa íma kendéíyáán-ivo endéímán-iye suwaná ");
INSERT INTO kze_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yútási minóntámbá anóm-bono'-naumpa'a metuwéna tiyuwéna ánda maimaéna ándákwamba varáiye. ");
INSERT INTO kze_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yútási minóntámbá anóm-bono'-naumpa'a metuwówasa mono-káwáá-kwáásí maésa sésa maanóntámbá kuntarur-óntámbá póta amápa-kwaasimo Áánútuntavesamo imáyáamo ésamo máráan-ontampimbo máráandaya kentáásí monor-ámáámbá karánaumne simásuwesa ");
INSERT INTO kze_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","minóntánkón-áái kwésesa mimbórá-áímbá sésa minóntándéí moórá-marama saweimó kwéom-barama meéyámbakaanasaya mimbárávímbá ó'om-baravaken-kwaasi puwíyan-kwaasi utanááowe siráawe. ");
INSERT INTO kze_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","mirá uráantavesa mimbáráyávésa sésa kuntaru'-márámán-iye siráawasa ívékwara'a mirá kwésewe. ");
INSERT INTO kze_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","mono-káwáá-kwáásí mirán-áímbá kwésesa mimbárámá meéyámbakaamba Áánútun-aai simátímakowai áwí'a Yérémayamo siráin-aimba paáruraiye. Yérémaya séna Ísareri aísaavutantamba uráawai évakarawai mimbórá-áímbá sésa moóráwaimbo kuntaru'ó ónááon-ontamba 30 ontamba maimaésa ");
INSERT INTO kze_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","saweimó kwéom-barama meéyámbakaamba Ísóigo simásímakaintemba mirá ónááowe Yérémaya siráimba pósa mirá uráawe. ");
INSERT INTO kze_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ísumba Árómáani-kamaani-kawaanakonopa'a máánkówana kwenaúranka'a máyowana áísaa ena séna Yútaa-kwaasiti kawáánárá oónó súwana Ísu séna á'a séne súwasa ");
INSERT INTO kze_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye ó'on-o'on-aintavesa aaivimbá mayánkówana Ísu iséna íma aaí súwana ");
INSERT INTO kze_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Páíráti Ísumba áísaa ena séna sáwívar-aimba kwésimankaavo íya kwéisaano súwana ");
INSERT INTO kze_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ísu iséna amápar-aintavena íma anondá aaí súwana kámááni-kawaana'a Páráíti sáwívar-imayaa uráiye. ");
INSERT INTO kze_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","naaóvá'á Áánútu Yútaa-kwaasi tíyótaasa í-tánón-kánáá tóyo úntemba Árómáani-kamaani-kawaanako séna amáparawai torupamái mésa aamoí ésa ándáva'o máyáin-kwaasi áwí'a tewa'á ayúrankanaumne séna minkánáá miráumai ándá-kwaasi kwéayurankaiye. ");
INSERT INTO kze_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ísumba Páírátinopa'a máánkónka'a moóráwai áwí'a Párápási amáparawai kwenáái ísarowai ándáva'a máyowasa ");
INSERT INTO kze_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","sáwíva-kwaasi torupamái máyówana Páíráti tísaa ena séna ándáva'o máyáan-kwaasivinkemba moóráwai áwí'a tewa'á ayúránkáano. Párápásiya'i. Ísu Áánútumo usásinankaiwaiye kwésewaina'iyo séna ");
INSERT INTO kze_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Páíráti imáyáa éna séna mono-káwáá-kwáásí Ísuntavesa íma anón-kwaasi-i'a ínkwáe sésa táto'maesa kesópa'a máankaraawe séna mináímbá tísaa uráiye. ");
INSERT INTO kze_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Páíráti mináímbá kwétisaa-ena aaimó ísón-daumpa'a máyowana awainínkó moóráwaimba ai'marówana kwenópa'a téna séna enawainínkó séna no'wáámba kaaimbá awánáúnda minkwáásígó íma sáwí'a uráisana sirunkó umbaí kwétaivo íma aaivimbá mayankaaó siyé simámakaiye. ");
INSERT INTO kze_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","awainínkón-áái kwésimamumba mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye úwoi-kwaasi sáwívarawai kwakwiyésa sésa Páírátintave'a sé'a Párápásimba ayúránkénasa Ísumba tuvuwíyana puwíno simáméro simátímúwana ");
INSERT INTO kze_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Páíráti moórágwara'a tísaa ena séna minkáé-kwáásívínkémbá nááwana ayúrankanaumno súwasa miwí sésa Párápásimba ayúrankaao suwaná ");
INSERT INTO kze_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Páíráti séna Ísumba Áánútumo usásinankaiwainemo sewáímbá nóra ónaumno súwasa amáparawai sésa taaira'á tuvuwíyana puwíno suwaná ");
INSERT INTO kze_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Páíráti séna nóra-sawira uráina'iyo súwasa anónka'a sésa taaira'á tuvuwíyana puwíno símae iráawe. ");
INSERT INTO kze_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","mináímbá símae íyúwana Páíráti miwí táái íma kanaán-umai karánaumne-imayaa éna amáparawai áái'a tíyáavo séna táávepimba nombá atímarena amáparawai túranka'a umásítai'a éna ayáámba sese éna séna mindákómó puwínín-umbai-yantaa'a kesiyáámpimba íma kwáyáivo kentiyáámpimba kwáyáiye súwasa ");
INSERT INTO kze_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","amáparawai sésa puwínata mimbéyámbá kentáásísaavutantambo ónááowaiseya mayánaumne suwaná ");
INSERT INTO kze_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Páráíti Párápásimba ayúrankena i-kwáásí simátimuwasa Ísumba áwí-andanei áwíruku'nowana Páíráti séna áí'mai taaira'á tuvuwíyana puwíno séna Ísumba i-kwáásírá'á tímakaiye. ");
INSERT INTO kze_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Páíráti Ísumba kwená i-kwáásírá'á timúwasa áí'maesa kámááni-kwaasiti naaúmpa'a móankesa amápar-i-kwaasi tááyowasa tamésa ");
INSERT INTO kze_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","kwená unáánkwátói ayú'maesa naaeyanyán-únánkwátói anón-kwaasiti unáánkwátóiman-iye sésa Ísumba umánkesa ");
INSERT INTO kze_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","anón-kwaasiti kánumo'an-iye sésa áwí-andama owepamái Ísu a'nómpímbá kuvérankesa tááúmba ayáánúrapa'a torankésa kanaáráá'a ankésa moórá-mora-umai kívairesa sésa Yútaa-kwaasiti kawááná'á óne sésa ");
INSERT INTO kze_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tuwirááíma kwirankésa ayáámpimbo toránkón-taumba mairésa a'nónká'á tuvánto'na kwéesa ");
INSERT INTO kze_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","kanaáráá'a ánkáyuwesa naaeyayán-únánkwátói ayú'maesa kwená unáánkwátói umánkesa tuvuwíyanamo puwíndava'a áí'maesa kuráawe. ");
INSERT INTO kze_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","i-kwáásí Ísumba áí'maesa kumbá moóráwai Sáíríni-naopakewai áwí'a Sáímoni aampa'á kwétuwasa i-kwáásí tátoresa Ísumbo tuvuwónááon-taima áúgwaatarankesa sésa áwa'naa umai tiyó suwaná mirá úwasa ");
INSERT INTO kze_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","kwésa moórá-marago áwí'a Kórígótaava'a kwésa mináwíkóná ááimba a'nómayaampare supa'á kwésa ");
INSERT INTO kze_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ándá-aran-domba mairésa áí'a ánásainkwae sésa ikaa'ó vaí-yántáá'á mimpímbá marésa Ísumba ámúwana óika'a ma'mai awánéna íma naráiye. ");
INSERT INTO kze_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ísu íma nówasa áí'maesa taaira'á aíyayaampimba tuvúsúmaresa kwená unáánkwátói mayánáe sésa aávéiya kwétiyaananaya nááwa usáyaaitaindawai mayáníyo sésa mirá ésa ");
INSERT INTO kze_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","mara'á mésa Ísunka'a kárákwiresa ");
INSERT INTO kze_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ísumbo tuvúwúwanamo puwún-ainkona ááimba aúváívimba agaimarésa sésa Ísu Yútaa-kwaasiti kawááná'án-iye agaimarésa a'nónká-táírá'á mósá marésa ");
INSERT INTO kze_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","umóyántémo uyan-kwáásíráí tí'maesa Ísumba évarevar-akwampa'a taaira'á tuvúsúmaresa mara'á mésa minkwáásírá'á kárákwirowasa ");
INSERT INTO kze_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","évakarawai tésa tiyáámba tóipimba áákesa timánáantata'a umánkesa aká'áámba simánkesa sésa ");
INSERT INTO kze_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","úwé emá séma anóm-bono'-namba tawísíyuwe'a kaumbo-táwai maisuwé'a ó'omba ónaumne siráampo Áánútu ááninkomo émo e esáváí enáúma áwa'naa ema eyááríka'a taairakémbá taútuwe marapá'á kumuwó siráawe. ");
INSERT INTO kze_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","suwasá miráumai mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé Yútaa-anon-kwaasiye kanaáráá'a ankésa ");
INSERT INTO kze_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","sésa ó'owi túwa'naa ena kwesáváí kwenáúma íma kanaán-umai áwa'naa íníye. Ísareri-kwaasiti kawááná'á úne seémáyáimba póna árai'o seémáyáindamo éna kweyááríka'a taairakémbá kumínata awánéta séta árai'a Áánútu áánimban-iye sénaumne. ");
INSERT INTO kze_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Áánútuntave'a asiramái máyaunda Áánútu áánimba úne seémáyáimba Áánútumo áwa'naa ónáe sénaraai ívé'a áwa'naa isinó suwasaráí ");
INSERT INTO kze_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","miwímó suntembá umóyántémo uyan-kwáásíráí évarevar-akwampa'a taaira'á tuvúsúmarowairai kanaáráá'a Ísumba ánkaraaiye. ");
INSERT INTO kze_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ísumba kanaáráá'a ánkówana kwáyá'wái amápa'-mapa'a túnkwena auváúmá kaapa marówana túnkumba ");
INSERT INTO kze_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ísu anónka'a Yútaa-kwaasi tááivinkemba séna eroi eroi rama sapakataniyemo sún-aimba maarán-áímbá séna Áánútu kesí Áánútuwo nóra séwa siyuwáánó súwasa ");
INSERT INTO kze_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","minká'ó máyón-kwaasi isésa évakarawai sésa naaóvá'á Áánútun-aai simátímakaiwaimba Íráiyaamba kwéaayaiye suwaná ");
INSERT INTO kze_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","moóráwai isaaiséna paru-táyánáma maimaéna ándá-aran-domba ikaa'-nómpímbá tu'maéna oviyen-támayopimba kinúvaimena naínkwáe séna Ísu óika'a mósá marówasa ");
INSERT INTO kze_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","évakarawai sésa Íráiyaama kuména áwa'naa íni. íya áwa'naa íníyo séta amu'maréta máyaumne suwaná ");
INSERT INTO kze_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ísu moórágwara'a anónka'a kwésena avowa ayáámpimba kwenamambá to'maréna pukáiye. ");
INSERT INTO kze_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ísu puwúwana anóm-bono'-naumpa'a ampanta-óntámá úmakomba sanaan-áyáírákémbá utaváá'maena marapá'á móru taváákaar-umai kaesé umágúwana póna Áánútunopa'a iyónááon-amba kwi'marówana anóm-barima tówana anón-ontantomba tawákaa'a kwéuwana ");
INSERT INTO kze_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","utámáróm-buri-aivimba awááumaron-ontamba akwákúwasa Áánútuna kwaási sáwívarawai pukómpinkemba usásinesa ");
INSERT INTO kze_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","utámáróm-buri-aivinkembausásine-mesa Ísu pukéna usásinon-tawai Yérúsaremu-naopa'a paárúwasa sáwívarawai awánaraawe. ");
INSERT INTO kze_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ísu puwúmba i-kwáásítí kawáánákówé kwená i-kwáásíyé Ísumbo kárákwimaresamo máyówai marímo tówanamo amápa-tantaa'o paárúmba awánésa ávááraumai táátavesa ésa sésa árai'a kwemá Áánútu ááninkoman-iye siráawe. ");
INSERT INTO kze_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","mináímbá sumbá sáwívar-inimba awánanae sésa tumbá némpa'a tamésa awánara. miníníntómbá Káríri-ayampakembo Ísun-ánaaembo kwa'maésamo áwa'naa úmaesamo Yérúsaremuva'o tiráan-inintompinkemba ");
INSERT INTO kze_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","moórá-inimba Mágátáraa-naopaken-ininko áwí'a Máríyaa úwana moórá-inimba Yémésinte Yósépinte tinówa áwí'a Máríyaa úwana moórá-inimba Sépéti ááninkai tinówa úwasa évakar-inintonkwara'a tamésa awánaraawe. ");
INSERT INTO kze_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","miníníntómbá tamáyówana enónka'a moóráwai óísankwarawai áwí'a Yósépi Árímátíyaa-naopakewai Ísun-aaiyavena áraire súwai ");
INSERT INTO kze_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Páírátinopa'a téna séna Ísun-auma utánáivo simiyó súwana kwená i-kwáásíyávéna séna Ísun-auma maimái áméro súwasa mirá uwaná ");
INSERT INTO kze_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yósépi Ísun-auma tamaimái aúná-ampantavimba asááumai ");
INSERT INTO kze_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","maimaéna kemó púwónasamo utamásínkéne sénamo aúsámakon-ontam-buri-aivimba mámarena óika'a anón-ontandei awááumasuwena kúwasarai ");
INSERT INTO kze_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Máríyaa Mágátáraa-naopaken-ininko úwana araámáó úwasarai mara'á mésarai Ísumbo utamánkóm-buri-aivimba karátuwesarai méraaiye. ");
INSERT INTO kze_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","minínínkáí kará'matuwesarai máyóyasa usá aaváyaavimba savaatirá'á mono-káwáá-kwáásíyé ámáán-kawaa-kwaasiye Páírátinopa'a tóyo ésa ");
INSERT INTO kze_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","sésa anóndakoo úwoimo aúvamai máyáinka'a kampar-áíntémó siwáí séna kaumbo-táwai maisuwé'a púwóndavinkemba usásinanaumne siráimba ísaraundaya sááka'a makáúndaya po ");
INSERT INTO kze_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","i-kwáásí ti'márénasa kaumbo-táwai utámáráam-buri-aivimba kogárákwiresa awánaaro. kwená kwayó-kwáásí kwenáúma asímbaesa aúpá'á utámaresa sésa pukáimpinkemba usásinkaiye seváínivo. mirán-áímbó síyanamo éna minkámpár-áínkó ááémo siráin-kampar-ainkomba usáyaaitaivainivo suwaná ");
INSERT INTO kze_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Páíráti séna kentí i-kwáásí ti'máréwasa sentení'a umái mimbúrí-áívímbá kawe'á umái kárákwiyoro súwasa ");
INSERT INTO kze_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","kwésa kwaási murí-áívímbá usáveraavo sésa sanómbá maimaésa móaraapamaranae sésa kurésa mirá maúmaresa i-kwáásí mátiyuwesa kóuraawe. ");
INSERT INTO kze_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yútaa-kwaasimo agándon-kanaa ánásowasarai sontaará'á usá aaváyaavimba aaváúmá usónka'a Máríyaa Mágátáraa-naopaken-ininko úwana araámáó úwasarai Ísumbo utamánkáapa'a koawánanae sésarai kuyambá ");
INSERT INTO kze_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","3","anóm-barima tówana Ísóigona kwayó'nákó kwíyómpakemba kuména kwenóikakemba aaváúmó usénamo intembá kwéuwana kwená unáánkwátóirakemba ainánkómó intembá kwayání'a kwégowana kuména murí-áigón-óika'a makón-ontamba kunakwátuwena minóntánká'á mara'á máyowana ");
INSERT INTO kze_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","mimbúrí-áírá'ó kárákwiyuwai ávááraumai táá'a kówasa tiyántámbá kwétowana tímáávomba kavúkuraiye. ");
INSERT INTO kze_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","kárákwiyuwai mirá kwéuwasarai minkáér-ínímbá kuyaná kwíyómpakewai minínínkáí simátimena séna íma táá'a kaíno Ísumba taaira'á tuvúwówana púwíwaimba taawánayae sékaimo téyamba ísaraumne. ");
INSERT INTO kze_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","kwemó siráintemba pukáimpinkemba usásinena kówéna íma maanká'á máyáivo utamánkaraampimba uawánékai ");
INSERT INTO kze_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","isaaisékai kwená kwayó-kwáásí kosimátimekai sékai Ísu pukáimpinkemba usásinena kentí aiva'á Káríri-ayampa'a kwína'a koawánanaaowe. mináímbá kosimátímékaiyo siráiye. ");
INSERT INTO kze_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","súwasarai minínínkáí avekáámbá utamánkópa'a tuwésarai táátavesarai uyaná tirunkó aamoí úwasarai kwená kwayó-kwáásí kosimátimiyantavairai aampa'á kuyambá ");
INSERT INTO kze_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ísu minínínkáí tuwánéna séna náávara máyaayano súwasarai anóndakoma iyé-ímáyáá ésarai kwenaísamaivimba tamésarai aísamaira'a tátoresarai kwená imáyáa mósá máróyana ");
INSERT INTO kze_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ísu simátimena séna kesívá'awaawi kosimátimiyasa Káríri-ayampa'a komésa suwánaaro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ísu mináímbá súwasarai kwemó súntemba minínínkáí aampa'á kuyambá utámárópa'o kárákwiyun-i-kwaasi évakarawai Yérúsaremu-naopa'a kwésa mono-káwáá-kwáásí paárún-tantaa'a kosimátímúwasa ");
INSERT INTO kze_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye torupamái mésa aaí simái mimbórá-áímbá símaresa utámárópa'o kárákwiyun-i-kwaasi anón-ontamba timésa ");
INSERT INTO kze_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","simátimesa sésa maarán-áímbá simátíméro. no'wáámba suún-kwaiguráunasaya Ísuna kwayó-kwáásí tésa kwenáúma umóyámbá maimaésa kóuraawe kosimátíma'mae'a nááóro. ");
INSERT INTO kze_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Páírátimo mináímbó isáínataamo éta moórá-ainkwara'a simáménanaya keinárawa'a íma aaivimbá maitinkáníye suwasá ");
INSERT INTO kze_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","miní-kwáásí isésa óntamba maimaésa kurésa sunten-áíné su'mai kosimátíma'mae nááúwana mináínkó kóyáwé úwasa ísaraamba ívékwara'a Yútaa-kwaasi kwéisaawe. ");
INSERT INTO kze_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ísuna kwayó-kwáásí sísamaivakemba moórá kumbaimái-kwaasi Káríri-ayampa'a Ísumo minómáká'á komáéromo sirón-omaka'a komáyówana ");
INSERT INTO kze_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","miwí túranka'a paárúwasa awánésa kwená imáyáa mósá márówasa évakarawai kaer-ímáyáá ésa sésa Ísu pukáimpinkemba usásinkaiyo. ó'owawa iyó suwaná ");
INSERT INTO kze_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ísu miwítí egwaa'á taména séna Áánútu asirayámbá siména séna kwíyómpare marapáré kárákwiyuwo simbá ");
INSERT INTO kze_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","pó'a mindáyave'a amápa'-marava'a kesáái simátíma'mae nááíyasa kesí kwaási-i'a ésa kesivowé kemá kwenááninkowe kwenamankóé tarúmai máyaiya'a kentáásúwíka'a nombá pétinke'a ");
INSERT INTO kze_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","simátímakaunda-aimba kwarésa asiramái tátoraigwae sé'a simátíma'mae íyóro. maramá kwáyaindara'a keinárawate mé'a ívé'o kwáyáin-tantaa'o ánásaindara'a keinárawate ménaundayave'a imáyáa úmae íyóro Ísu siráiye. kemá Mátíyu súnda-aimba ánásaiye. ");
INSERT INTO kze_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Áánútu ááninko Ísu Káráísiti kwená áséi-kwasai maarámán-iye. ");
INSERT INTO kze_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","naaóvá'á moóráwai áwí'a Yóni íma máyonka'a Áánútun-aai simátímakowai áwí'a Áísáya Yónin-aai simái agaimaréna séna Áánútu séna isaaó. moóráwaimba ai'máráanana kesáái maimaéna ená aiva'á kwéna ená aambá kwirankéna ");
INSERT INTO kze_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","kavóná-marava'a ména aayamáírakemba séna ísóigona aambá kwirankánááomba kwená aambá arupí íyana minámpá'á kwíno Áánútu siráiye Áísáya agaimaréna sirónka'a Yóni paárúwana mináímbá paáruraiye. ");
INSERT INTO kze_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Yóni nombá pétinkowai kavóná-marava'a komáyowasa Yútiyaa-ayampake Yérúsaremu-naopaken-kwaasi amápa'a Yóninopa'a tuwaná simátimena séna kentí sáwí-imayaa tuwé'a Áánútumpa'a tíyana sáwí-imayaa maitiyuwáína'a nombá pétinkanaumne súwasa sáwí'o uráamba paárumai avora'á simámúwana Yóni Yótáni-nompimba nombá pétinkaraiye. ");
INSERT INTO kze_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yóni póígo áwí'a káámeri kwená áyáu-kwatoi iréna aúwarasinei ámúr-anda uréna a'nóríné kwantáámíkóná aúwé mintóné su'mai kwénena ");
INSERT INTO kze_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","simátimena séna moóráwai kesínaaemba tíníwai kwemá anóndakoma kembá usáyaaitaraimba pó'a kwemó aaimó síndavimba kemá aaimá sendamá uvóví'a ónaumne. ");
INSERT INTO kze_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","kemá nombá pétinkaundanivo kwemá Áánútu amankómbá ai'maráínana kuména keinárawapimba anómba umátinkaniye siráiye. ");
INSERT INTO kze_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","minkánáá Káríri-ayampakemba Násáreti-naopakemba Ísu túwana Yótáni-nompimba Yóni kwembá nombá pérankowana ");
INSERT INTO kze_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ísu nompínkémbá usásinowana sokón-tawaai taaínkar-úwana Yóni awánómba Áánútun-amanko mááiraamba úmaena Ísu ane'á kumbáyowana ");
INSERT INTO kze_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","kwíyómpakemba aaigówé su'mai séna emá kesááninko óna'a ená imáyáa kwée'a ávááraumai aamoí umánkaumne siráiye. ");
INSERT INTO kze_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","súwana Áánútun-amankoma Ísumba simámuwana kavóná-marava'a komáyowana ");
INSERT INTO kze_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kae-kwááí aíyayaan-do'waamba 40 no'waamba komáyowana Sáátáánigo Ísu sáwí'o índa awánanae séna ó'on-o'on-aimba súwana Ísu íma sáwí'a éna aváá-kwánkáán-umai máyowasa kwíyómpakemba Áánútuna kwayó'nárawa'a kumbésa áwa'naa umánkaraawe. ");
INSERT INTO kze_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","naaémba Yóni Káríri-marara-kawaanako áwí'a Érótintavena séna sáwí'a uráiye siróntavena Yónimba ándáva'a máankowana máyowana Ísu Káríri-ayampa'a kwéna Áánútuna áséi-kwasai simátimena séna ");
INSERT INTO kze_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Áánútu kwená kwaásira'o kawááimba ááimba kwéasaivo kentí sáwí-imayaa tuwé'a Áánútuna áséi-aintave'a áraire seró siráiye. ");
INSERT INTO kze_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","mináímbá simásuwena Káríri-kwaaunkon-awampakavamba kúmba kae-kwáásíráí mésarai awaaó áwí'a Sáímoni úwana áváko áwí'a Éndaru umái mésarai miwítí mayáímá pósarai noyáá'a to'mái tímapa'a kwénaaesarai kwase-únámbá nompí tukóyana ");
INSERT INTO kze_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ísu simátimena séna kesé tekaiyó. noyáá'o to'máímo tímapa'o kwénaaoyantemba aúná-mayai tíménakai kwénaaekai kesáái simátímapa'a kwénaaiyasa kesópa'a teró súwasarai ");
INSERT INTO kze_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","minkwásé-únámbá tuwésarai kwesé kurááiye. ");
INSERT INTO kze_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","kwesé kuyaná Ísu sáwíyanka'a kúmba kae-kwáásíráí mésarai Sépéti ááninkai awaaó áwí'a Yémési úwana áváko áwí'a Yóniye nompí-sípívímbá mésarai kwase-únámbá to'mayaa kwéuyana ");
INSERT INTO kze_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ísu tuwánéna tááyowasarai mindómpí-sípívímbá tivowáné kwená mayáí-kwáásíyé tiyuwésarai Ísuwe kurááiye. ");
INSERT INTO kze_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kápénéamu-naopa'a komáyómba Yútaa-kwaasi monor-áímbó kwéison-kanaa túwana Ísu mono'-náúmpá'á uména kwenáái simátimuwasa ");
INSERT INTO kze_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","isésa asiramái súntavesa sésa ámáámba sentenkáání'a íma kwésivo anón-kwaasigoraamba kwésiye sésa táátavai uráawe. ");
INSERT INTO kze_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","táátavai uwaná mimbónó'-náúmpá'á moóráwai kwenarumpimbá taraváá-kwámbá máyon-kwaasigo ména ");
INSERT INTO kze_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","anónka'a séna Ísu Násáretivakewaima óne. kentáá nóra taéwa tasínkambaiya ánásaniyono. embá awánáúndawai Áánútuna kawe-kwáyó'ná'á óne súwana ");
INSERT INTO kze_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ísu taraváá-kwántánéna asiramái séna aaiseré minkwáásí tiyuwé kóaao súwana ");
INSERT INTO kze_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","mintáráváá-kwánkó minkwáásí toká'mái tuvámbarowana aíyayaanko sápísimaguwana kwáá'a túmaena arumpinkémbá kóúwasa ");
INSERT INTO kze_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","awánésa táátavai ésa keáímbá sésa mindóra'iyo. aúnái'an-iye. kwemá taraváá-kwántávéna asiramái kwésisasa sintembá kwéowe suwaná ");
INSERT INTO kze_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","mirá úwasa Káríri-ayampa'a Ísun-aai kóyáwé úwasa ísaraawe. ");
INSERT INTO kze_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ísówasa mono'-náúmpá'á tuwésa Sáímoninte Éndaruntei mindáraiti naaúmpa'a íyúmba Yémésiye Yóniye Ísuwe umái íyúmba ");
INSERT INTO kze_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sáímoni aísáankomba kokotámba kwéankowana máyowasa Ísumba simámúwana ");
INSERT INTO kze_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","iséna kwenópa'a téna ayáánka'a táto'mai usásinankowana kokotámba ánásowana usásinkwena toómbá agaimái tímakaiye. ");
INSERT INTO kze_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","toómbá agai-timúwasa enónka'a tí'o ún-kwaasiyonkwara taraváá-kwámbó tirumpimbó máyón-kwaasiyonkwara'a tí'maesa Ísunopa'a mátínkówasa ");
INSERT INTO kze_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","mindáópaken-kwaasiyomba amápa'a ontará'á torupowaná ");
INSERT INTO kze_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ísu ó'on-o'on-ti'o ún-kwaasiyomba asóvamatinkena taraváá-kwámbá tirumpinkémbá maituyuwówasa mintáráváá-kwántómbá Ísuntavesa Áánútu ááninkoman-iye sésa kwembá awánontavena aaiséráaro Ísu súwasa kóuraawe. ");
INSERT INTO kze_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","kóuwana irataró'á Ísu usásinena mindáópa'a tuwéna námúnaa síndayavena íma kwaási máyópa'a koména námúnaa kwésena máyowana ");
INSERT INTO kze_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sáímoni kwená kwaásiye Ísumba avakáá-umai ");
INSERT INTO kze_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","awánésa sésa amápa-kwaasi embá kwéavakaa-owe suwaná ");
INSERT INTO kze_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ísu séna ó'on-daopimpakwarata kwénaaeta kesáái simátímapa'a koónaumne. mirá ónaundayave'a túne séna ");
INSERT INTO kze_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Káríri-ayampa'a mono'-náúmpímpá'á kosimátímapa'a kwénaaena tirumpinkémbá taraváá-kwámbá maitiyuwówasa kóuraawe. ");
INSERT INTO kze_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","moórá-tawai Ísunopa'a áúma karón-kwaasigo téna anóndakoman-iye séna aísamaivimba takívairena séna kentávénamo ankáínamo e kanaán-umai aúnái'a umásinkaniyono súwana ");
INSERT INTO kze_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ísu arumbá úwana ayáándei ane'á tátorena séna mirá ónaumpo enáúra'a karevú'a kawáúgwiye séna ");
INSERT INTO kze_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","avekáámbá kawe'á umánkowana kawáúguwana ");
INSERT INTO kze_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ísu asiramái séna enáúra'a kawáúgwimba po Mósesimo siráintemba mono'-máyáí-kwáásítópa'a kwéma enáúma máagaraatinke póíma tímínasa Áánútuntavesa ísámai tuvú'mái agayáíyasa amáparawai awánésa áúrakemba kawáúgwiye sénááowe. ánivo enáúra'o umánkaunda-aimba simátimunavo se kwaaó Ísu súwana ");
INSERT INTO kze_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","minkwáásígó ivátuwena kawe'á umánkon-aimba simátíma'mae iyúwana mináínkó kóyáwé úwasa sáwívarawai Ísu tíníye sésa kentí naaópimpa'a torupamái máyówana mindáyavena Ísu íma naaó'-nao'a kúmba kwaási íma máyónkavamba máyowasa naaó'-naoken-kwaasi kwenópa'a tóyo uráawe. ");
INSERT INTO kze_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","évaka'-no'waamba kwaéna Ísu Kápénéamu-naopa'a kúmba kwená naaúmpa'a máyowasa sáwíva-kwaasi isésa ");
INSERT INTO kze_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","torupésa mindáúmpá'á sisipáá ésa pááimpakwara'a sisipáá umásowana Ísu kwenáái kwésimatimuwasa ");
INSERT INTO kze_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","éíyain-kwaasi aísamaimo pukówaimba taagwiya'maésa tumbá ");
INSERT INTO kze_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","mindáúmpá'á sáwíva-kwaasi sisipáá uwasá íma kanaán-umai íyóra'naraan-esa naanamiva'á taagwiya'maésa umésa avaa'á akósámaresa ándára tátoresa túwówana kumeémena Ísumo máyonka'a aúranka'a kumúwana ");
INSERT INTO kze_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ísu taagwiya'maésamo tun-kwáásímó árai'a kawe'á umánkaniye-imayaa umbá Ísu tuwánéna aísamaimo pukón-kwaasiyavena séna kesí kwaásiyo ená sáwí-imayaa mayauwáúmne súwasa ");
INSERT INTO kze_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ámáámba sun-kwáásí mésa ");
INSERT INTO kze_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","imáyáa ésa sésa nóra séna mirá siyó. Áánútu kweyáá sáwí-imayaa maitiyuwánívo kwaási íma mirá ónááovo Áánútumba aká'áámba kwésimankaiye-imayaa ésa suwaná ");
INSERT INTO kze_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ísu minímáyáámó umbá awánéna simátimena séna nóra séra mirán-ímáyáá kwéoo. ");
INSERT INTO kze_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","moóráwaimo aísamaimo pukáindawaintavaimo sénamo ená sáwí-imayaa mayauwáúmne sínasamo ésa áraira sií. kampará siíyo sénááowe. ánivo moóráwaimo aísamaimo pukáindawaintavaimo sénamo eyááríka'a usásine ená kwandaaimá maimaé kwaaó sínasamo ésa áraira sií. kampará siíyo awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","kemá kwaási úranda'a kumpaáruraundawai marapá'á máyaunda kwaásiti sáwí-imayaa maitiyuwáúnda-asirayamba tokáunda pó'a agaráátínkáanda awánanaaowe séna aísamaimo pukón-kwaasiyavena séna ");
INSERT INTO kze_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","isaaó. usásinke ená kwandaaimá maimaé naaópa'a kwaaó súwana ");
INSERT INTO kze_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","amápa-kwaasi túranka'a usásinkwena kwená kwandaaimá maimaéna kúwasa amáparawai táátavesa ésa Áánútu áwí'a mósá marésa sésa íma awánaraundai'a isa'á awánáúmne sésa táátavesa ésa tiyáámba tóipimba áákaawe. ");
INSERT INTO kze_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ísu tuwéna Káríri-nonkwaaunkon-awampa'a kúwasa sáwíva-kwaasi kwenópa'a torupowaná kwenáái simátimena ");
INSERT INTO kze_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","kwéna awánómba Árávíási ááninko áwí'a Árívái táákísimo máyón-daumpa'a máyowana Ísu awánéna séna usásine kesé tiyó súwana usásinena kwenánaaemba kwa'maéna kuráiye. ");
INSERT INTO kze_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","kúwasa Ísuwe kwená kwayó-kwáásíyé Áríváina naaúmpa'a umésa toómbá nowasá táákísimo máyón-kwaasiye sáwí'o un-kwáásíyé sáwíva'a Ísun-ánaaemba kwa'maésa Áríváina naaúmpa'a umésa nowasá ");
INSERT INTO kze_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ámáán-kawaa-kwaasivinkemba ámáámba sun-kwáásí Ísumo táákísimo máyón-kwaasiye sáwí'o un-kwáásíyé toómbó kwénomba tuwánésa Ísuna kwayó-kwáásíyávésa tísaa esa sésa nóra sénawa táákísimo máyáan-umoyan-kwaasiye sáwí'o on-kwáásíyé Ísu toómbá kwénaiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ísu iséna séna sontaa-kwáásígó kawe'ó umáímo máyáan-kwaasi íma kwétuwa'naa-ivo tí'o in-kwáásí kwétuwa'naa-iye. mindáyave'a arupí umái máyáan-kwaasi tááyaanasa Áánútunopa'a tígwáe sé'a íma kunkáumpo sáwí'o umáímo máyáan-kwaasi tááyaanasa Áánútunopa'a tígwáe sé'a kunkáumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","moórá-tawai Yóni nombó pétinkowaina kwayó-kwáásíyé ámáán-kawaa-kwaasiye Áánútuntavesa imáyáa ésa toómbá íma kwénesa námúnaawe su'mai kwésuwasa évakarawai Ísumba taáísaa esa sésa Yónina kwayó-kwáásíyé ámáán-kawaa-kwaasiti kwayó-kwáásíyé moórá-mora-tawai Áánútuntavesa imáyáa ésa toómbá íma kwénesa námúnaawe su'mai kwésevo ená kwayó-kwáásí íma mirá ésa toómbá úwoi kwénaawe. nóra ésa mirá kwéoo suwaná ");
INSERT INTO kze_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ísu séna moóráwai aaraí mayáíndawai amááraawi tanómba kautimínímba miwísé máyainasa aamoí ésa mintómbá íma a'áo sénááovo úwoi nánááowe. ");
INSERT INTO kze_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","naaémba minkwáásígómbá aí'maesa kówíyasa minkánáámá amááraawi tirunkó sáwí'a ínasa toómbá a'áo sénááowe. Ísu séna kwemó ménamo naaémbo tiyuwénamo iyíníntavena mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ísu mináímbá simásuwena séna ááéraan-ampantamo avaa'ó kwáyáísasamo ombá aúná-ampanta íma kárámai kwéaraapaawe. mirámó íyana aúná-ampanta sáwí'a ínana ááéraan-ampantao aúná-ampantaraani'a íma íníye. ");
INSERT INTO kze_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","aúná-anda-aran-domba ááéraa-sipisipi-auwarasi-anaveumpimba íma kwéatimaraawe. mirámó íyanamo éna aúná-anda-aran-domba anón-éna ááéraan-anaveumba kavámbaena sáwí'a ínana mindómbá úwoiva'a atígwiniye. mindáyavesa aúná-anda-aran-domba aúná-sipisipi-auwarasi-anaveumpimba kwéatimaraawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","moórá-tawai Yútaa-kwaasi agándon-kanaara'a Ísuwe kwená kwayó-kwáásíyé úwíti-ton-kigauvimba kwégwesa kwená kwayó-kwáásí úwíti-aramba kútúmai ásima pítuwesa kwénowasa ");
INSERT INTO kze_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ámáán-kawaa-kwaasi tuwánésa Ísuntavesa sésa maisaaó. ená kwayó-kwáásí agándaan-kanaama aambá áúmbakaawasa mirá kwéowe suwaná ");
INSERT INTO kze_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ísu séna naaóvá'á Tévítimo urómba aúváívimba agaimarón-ainkona ááimba íma ísaraawe. aiva'-mónó-káwááná'á áwí'a Ápáyata máyonka'a Tévítiye kwená kwaásiye táái kwétinkowana Tévíti Áánútuna mono'-náúmpá'á iyéna Áánútu aúranka'o makón-tomba umairéna kwénena kwená kwaási timúwasa naráawe. mintómbá úwoi-kwaasi íma némáembanivo mono'-máyáí máyón-kwaasi némáembani. Tévíti mintómbá umairéna timúwasa nonká'á Áánútu íma áwáá'a siráimbanivo kesí kwaási mirá kwéowa'a áwáá'a ímo seráámbá áwáá'a kwésewe. ");
INSERT INTO kze_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Áánútu kwaásiyavena imáyáa éna túwa'naa íníntavena agándain-kanaa maréna kwaási aiva-tántáá'á maréna agándain-kanaama naaén-tantaa'a póna túwa'naa íníntavena makáiye. ");
INSERT INTO kze_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","kwíyómpakemba kwaási úranda'a pó'a agándai-kanaara'o kárákwiraundawai úmpo agándai-kanaamo kwaásimo mayáí kwémayaamba kendéímán-iye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","moórá-tawai Ísu mono'-náúmpá'á iyúmba moóráwai ayáámba kawévaiguron-kwaasi máyowasa ");
INSERT INTO kze_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","aaivimbá mayankánáe kwésuwai mésa Ísuntavesa sésa agándaira'a póna minkwáásímó kawe'ó umánkainataamo éta táto'maiya aaivintá mayankánaumne sésa Ísumba awánomba ");
INSERT INTO kze_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ísu ayáámba kawévaiguron-kwaasiyavena séna kemó máyaundara'a tiyó súwana mirá úwana ");
INSERT INTO kze_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ísu miwíyávéna séna kentáásí ámáán-aimpimba nóin-aina kwáyáiyo. agándai-kanaara'a póta kawe'-máyáíyá kwémayaum. sáwí-mayaiya kwémayaumno. kwaási áwa'naa onanayá kawerá umáíya méni. inkámónanaya puwíníyo. tísaa ena súwasa íma aaí suwaná ");
INSERT INTO kze_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ísu móyuwana meyuwana éna áwáá'a títuwena kwaásiyavaimo ímo imáyáamo kwéontavai arumbá kwéuwana ayáámba kawévaiguron-kwaasiyavena séna enayáámba árútuwaao súwana ayáámba árútuwowana kawe'á umánkowasa ");
INSERT INTO kze_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ámáán-kawaa-kwaasi mono'-náúmpá'á tuwésa avekáán-umai Érótina kwaási torupésa Ísumba nóraumaiya tuvuwónaundaya'iyo sésa ámááyu-aimba siráawe. ");
INSERT INTO kze_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ísu tiyuwéna kwená kwayó-kwáásí tí'maena Káríri-nonkwaaunkon-awampa'a kúmba sáwíva-kwaasiyomba Kárírivaken-kwaasi Yútiyaavaken-kwaasi ");
INSERT INTO kze_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yérúsaremu-naopaken-kwaasi Ítúmiyaa-ayampaken-kwaasi Yótáni-nonkona menávápákén-kwáásí Táyaa-naor-ayampaken-kwaasi Sáítóni-naor-ayampaken-kwaasi miráumaivaken-kwaasiyomba Ísuna mayáí-áímbá isésa Ísunopa'a tóyo uwaná ");
INSERT INTO kze_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","12","sáwíva-kwaasi asóvamatinkowasa mindáyavesa tí'o ún-kwaasiyomba asóvamasinkainkwae sésa Ísun-ane'o tátoraiyanesa kwenkuvará'á úmaesa kwéiyuwasa tirumpimbó taraváá-kwámbó máyon-kwaasi Ísumba awánésa mara'á kumbésa anónka'a sésa emá Áánútu ááninko óne suwaná Ísu asiramái séna Áánútu ááninko óne sé'a íma simái paároro séna kwená kwayó-kwáásí simátimena séna sáwíva-kwaasi kwenkuvará'a ésa siméntáyuwaavo nompí-sípí maimaé'a egwaa'á másínkáaro siráiye. ");
INSERT INTO kze_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ísu omápa'a uména évakarawai usásintinkanae séna tááyowasa kwenópa'a íyúwana ");
INSERT INTO kze_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","minkwáásívínkémbá sísamaivakemba kae'á kumbaimái-kwaasi usásintinkena séna kesí aantá-kwaasi é'a mé'a kesáái kosimátímapa'a kónááontave'a ti'maré'a ");
INSERT INTO kze_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tirumpinkémbó taraváá-kwámbó komaitiyuwánááon-asirayamba timúnda miráyávé'a usásintinkaumne siráiye. ");
INSERT INTO kze_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","miwí túwí'a Sáímoniye séna aúná-kwi'a tamámena Pítaawe súwaima séna ");
INSERT INTO kze_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sépéti ááninkorai túwí'a Yémési Yóni aúná-kwi'a Poanésiye súwairai minkwíkóná ááimba kwíyónaaimo siwáí áráakaiye súwairaiyavena séna ");
INSERT INTO kze_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","moóráwai Éndaru moóráwai Vírípi moóráwai Pátóromu moóráwai Mátíyu moóráwai Tómáasi moóráwai Árávíási ááninko áwí'a Yémési moóráwai Tátiyasi moóráwai Sáímoni kwemá Árómáani-kamaani-kwaasi ti'mátuwanae siráiwai ");
INSERT INTO kze_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","moóráwai Yútási Isakéríóti kwemá naaémba Ísumba kwená namuro-kwáásírá'á agaráátínkaraiwai miráumai-kwaasi Ísu usásintinkena naaópa'a koyauwékáiye. ");
INSERT INTO kze_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ísu naaúmpa'a iyúmba ó'onkwara'a sáwíva-kwaasi torupésa sisipáá untáváí Ísuwe kwená kwayó-kwáásíyé toómbá íma kanaará'á umái notávésa ");
INSERT INTO kze_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ísumba amááraa isésa aívó'an-iye sésa tairánáe sésa tiráawe. ");
INSERT INTO kze_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yérúsaremu-naopaken-kwaasi Áánútuna ámáámba sun-kwáásí tésa sésa taraváá-kwántóntí kawááná'á áwí'a Píyésepu asirayámbá ámísana tokéna póna taraváá-kwámbá kwémaiyuwaiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ísu tááyowasa tuwaná kwántámai-aimba simátimena séna Sáátáánigo kwesáváí íma maisuwáníye. ");
INSERT INTO kze_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","moórá-andama áái'a tiyésa pósa taaínkaar-umai mésa íma asiramáívakaamba kwémaewe. ");
INSERT INTO kze_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","moórá-akumba usíyán-ákúmbá pósa taaínkaar-umai íma asiramáívakaamba kwémaewe. ");
INSERT INTO kze_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sáátáánigona kwaásimo áái'o tiyésamo taaínkaa'o ésamo ésa íma asiramáívakaamba kwémaewe. ");
INSERT INTO kze_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","moóráwai moórá-nanko avowámó asiramáímo máyainanamo éna mindáúmpákémbó umóyámbó mayáíndayavenamo éna íma úwoi uveránívo mindánkó avowámbá ánda asááúmakenamo éna uvékena kwená náaindaamba umóyámbá mayáníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ísu simásuwena séna maísáaro. kwaási sáwí-mayai kwémaesa simái sáwí'a kwéumatinkaamba mindá Áánútu maitiyuwánívo ");
INSERT INTO kze_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Áánútun-amankontavesa simái sáwí'a umánkanaaomba mindá Áánútu íma maitiyuwáinana kwaíkwai'a íníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ísuntavesa sésa taraváá-kwánkó kwenarumpimbá máyáiye suntávéna Ísu mináímbá simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","mináímbá simátimuwasa Ísun-anówawe Ísun-áúnava'maate tésa máápa'a mésa sésa Ísuntavai tiyó se kosimáméro suwasá ");
INSERT INTO kze_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","naaúmpa'o máyón-kwaasi sésa enanówe enáúnava'maare máápa'a mésa kwéaayaawe suwaná ");
INSERT INTO kze_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ísu séna kesinó nááwa'iyo. kesúnava'a nááwiya'o séna ");
INSERT INTO kze_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","naaúmpa'o máyón-kwaasi tuwánéna séna kesinó kesívá'maa'a máyáawe. ");
INSERT INTO kze_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Áánútu siráini'a kwéowai kesinó kesúnava'maa'a kesímánaa'maa'an-owe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ókwara'a Ísuma Káríri-nonkwaaunkon-awampa'a koména aaí kwésimatimuwasa sáwívarawai tóyo ésa kwená egwaa'á tamáyóntavena nompí-sípívímbá usámaaisena máyowana nompí-sípímá kwaaún-avovomayaa'a kwáyowasa minkwáásíyómbá nonkwaaúnkón-awampa'a máyówana ");
INSERT INTO kze_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ó'on-o'on-aimba kwántámai simátimena séna ");
INSERT INTO kze_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","maísáaro. moóráwai ánáyumba maimaéna kígauva'a kwégwena ");
INSERT INTO kze_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","máyu'maraisana évakar-anayumba aampa'á kunkwáyáísana numaómá túkúnasukaiye. ");
INSERT INTO kze_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","évakar-anayumba óntankwara'-maravimba kunkwéna paáká'-márávímbá póna avekáán-umai anón-isana ");
INSERT INTO kze_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","aa'á kaisaná ánú'a ayáátááka'a íma kunkéna aáyánkaguraiye. ");
INSERT INTO kze_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","évakar-anayumba karaampimbá kunkwéna kárúraisana karaan-tantáákó ara'násúwáísana íma arambá iráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","évakar-anayumba kawe'-márávímbá kunkwéna kárúrena anón-éna arambá imái sáwívar-aramba iyéna évaka'a usáyaaitayan-aramba íyáísana évaka'a umaimái-aramba iráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","kwéisaawai ísámai kawe'á oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ísu súwasa naaémba kwená kwayó-kwáásíyé évaka-kwaasiye mésa Ísuntavesa sésa minkwántámáí-áínkóná ááimba sinatá ísáano suwaná ");
INSERT INTO kze_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ísu séna Áánútu kwená kwaásimo kawááin-ainkona ááimba kwésimatimunda Áánútu keinárawa'a imáyáa tímísa'a kwéisaavo ó'on-kwaasi kwántámai-aine su'mai kwésimatimumpo ");
INSERT INTO kze_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kwéisaambanivo íma ísámai kawe'á kwéowe. kwéawanaambanivo íma awánamai kawe'á kwéowe. isékai Áánútunopa'a tewaná Áánútu miwítí sáwí-imayaa maitiyúwáísino. mindáyave'a kwántámai-aimba kwésimatimune Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ísu simátímatuwena séna maankwántámáí-áímbó simátimunda íma isáíyankakemba pó'a ó'on-o'on-kwantamai-aimbo sendá íma isánááowe. ");
INSERT INTO kze_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","mináínkóná ááimba súnda ísáaro. moóráwaimo ánáyumbo tu'máráinten-umai Áánútun-aai simátímísana ");
INSERT INTO kze_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","évakar-anayumbo aampa'ó kúmímba kwaási tirumpintá kúmísasa Áánútun-aai ísáawana Sáátáánigo téna tirumpinkémbá maimái úwoiva'a kwétiyuwaiye. ");
INSERT INTO kze_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","évakar-anayumbo óntankwara'-maravimba kúmímba kwaási tirumpintá kúmísasa avekáán-umai Áánútun-aai isésa aamoí ombánivo ");
INSERT INTO kze_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","íma tirumpimbá táto'mai kawe'á owasá Áánútun-aaiyavai umbai-yántáárí'a umátinkaantavai Áánútun-aai ivátukaawe. ");
INSERT INTO kze_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","évakar-anayumbo karaampimbó kúmímba kwaási tirumpintá kúmísasa Áánútun-aai ísáámbanivo ");
INSERT INTO kze_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","marapár-úmbáí-yántáátáváí imáyáa úmae naaésa óísan-imayaa úmae kwénaaesa ó'on-o'on-tantaa'a mayánáe kwésimae naaésa mirán-ímáyááó Áánútun-aai káátasuwaisasa íma Áánútuna mayáí kwémayaawe. ");
INSERT INTO kze_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","évakar-anayumbo kawe'-márávímbó kúmímba kwaási tirumpintá kúmísasa Áánútun-aai isésa tirumpimbá táto'mai kawe'á ésa asiramái mésa Áánútuna mayáí kwémaesa kwétuwa'naa-owasa évakarawai usáyaaitamai-mayai kwémaesa kwétuwa'naa-owe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ísu simásuwena séna oómbó kúra'maraamba íma aúpá'á marésa íma aasípáa-amendaampa'a marésa avora'á mósá kwémaraawe. ");
INSERT INTO kze_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","mirámó onten-umái aúpá'ó kwáyáin-tantaa'a amápa'a avora'á paárínasa awánanaaowe. túnkaipa'a kwáyáin-tantaa'a avora'á paárínasa awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","kwéisaawai ísámai kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","tíménten-umai Áánútu miráumai tiména moórágwara'a timíníye. mindáyave'a ísáan-aimba imáyáa umái kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Áánútun-aaimo ísámaimo kawe'ó kwéowai Áánútu túwaa'naa ínasa moórá-ainkwara'a isánááowe. Áánútun-aaimo ímo ísámaimo kawe'ó kwéowai tirumpinkémbá maimayáínana íma kwéniye. mindáyave'a ísáan-aimba imáyáa umái kawe'á oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ísu simátimena séna Áánútu kwená kwaásimo kwégawaain-aimba maarán-áímbán-iye. moóráwai ánáyumba tu'maréna ");
INSERT INTO kze_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","íma áwa'naa ena kwaéna iraréna kwéisana ánáyumba kweyááríka'a kwéanon-iye. ");
INSERT INTO kze_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","maragómá ánáyunkomba áwa'naa isaná áruma kwíkéna anón-umai arambá iréna ");
INSERT INTO kze_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ávuma kaisaná áká'nanaaon-kanaa tisasá áká'mai kwénaawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ísu séna Áánútu kwená kwaásimo kwégawaaimba nóinkara kwégawaaiyompo maarán-áímbá simátíména'a isánááowe. ");
INSERT INTO kze_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Áánútu kwená kwaási kwégawaaimba maarámán-iye. sáwíyan-taeranko áwí'a másátati mintáígó arambá ímo ane'ó awánaraan-taeramba maravímbá u'makáawana mimpínkémbá kwíkéna ");
INSERT INTO kze_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","anón-taima anón-éna amaimá anón-amaima móivarena kóyáwé uráisana numaómá mimpímpá'á ánáamba úmarena kwémaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Ísu kwaásiyomba aaí simátimenae sénamo úmba íma avora'á siráivo kwántámai-aine su'mai simátimuwasa taaímbai súntemba móisaiyuwowana mináyáírákémbá simátimuwasa móisowana miráumai simátimena ánivo kwená kwayó-kwáásí kwesé máyonka'a mináínkóná ááimba simátíma'mae iráiye. ");
INSERT INTO kze_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","mitáwai enónka'a Ísu kwená kwaásiyavena séna nonkwaaúnkóná menávápátá kónáe súwasa ");
INSERT INTO kze_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ó'on-kwaasi tiyuwésa Ísumba áí'maesa nompí-sípívímbá usáatesa kuwasá évaka'-nompi-sipigwara'a kumbá ");
INSERT INTO kze_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Ísu misípígó ayááívá'á aún-kwaigurówana anón-unda torówana nonkó tuvántááva éna nompí-sípívímbá ógwitowasa kunávekunavo sésa inkaisésa Ísumba koaúsesa sésa anóndakoo kesí imáyáa íma inatá puwúnavaiya súwa'naa uwo suwaná ");
INSERT INTO kze_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","usásinena asiramái séna úndáonte nonkóntéyavena maiváyáakaiyo súwasarai úndáoe nonkóe maiváyóyana nonkómá kararépaguwana ");
INSERT INTO kze_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ísu simátimena séna nóintavaiya kwéinkaiseo. kentávé'a nóra séra íma kesí imáyáa onkákémbá kwéseo súwana ");
INSERT INTO kze_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","táá'a kówasa keáímbá sésa nóran-kwaasiya énawa úndáoe nonkóe kwenáái kwéisaiyo sésa tiyáámba uvakésa táátavesa ésa siráawe. ");
INSERT INTO kze_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","simásuwesa mindómpí-sípívímbá kumbá Káríri-marama tínaaempa'a kwáyowana Kégésaa-marama túrampa'a kwáyowasa mimbárává'á kumbá ");
INSERT INTO kze_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","4","Ísu mindómpí-sípívínkémbá mimbárává'á ásávowana moóráwai taraváá-kwámbá arumpimbá máyon-kwaasigo utamátínkó-muri-aiva'a máyomba Ísunopa'a tirái. minkwáásí kárár-umankontemba taráka-yaraka úwaima póna íma kwaási mésayavai íma kárár-umankowana ména ");
INSERT INTO kze_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","enómba irarómba omáka'a utamátínkó-muri-aiva'a kwénaaena kwáá'a kwétena óntandei kwenáúra'a kwétena ");
INSERT INTO kze_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","nénkakemba Ísumba awánéna isaaiséna Ísun-aóká'á taména kwená imáyáa éna áwí'a mósá marówana Ísu minkwáásígó arumpinkén-táráváá-kwánkóntávéna séna emá taraváá-kwámbá ómpo minkwáásígómbá auwé kóaao súwana anónka'a séna Ísuwo usáyaaitamai-Isoigo ááninko ómpo Áánútuntavai ísámai sínkamonavainivo nóra umásinkaniyono súwana ");
INSERT INTO kze_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ísu séna enáwí'a nááwa'ono súwana sáwíva'a máyaumpo kesúwí'a sáwívarawai úne séna máyowasa ");
INSERT INTO kze_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","13","omáka'a sáwíva-poima mésa umá kwénowasa minkwáásígó arumpinkén-táráváá-kwántómbá Ísuntavesa asiramái sésa ó'opa'a íma si'maraaó. mimpóí tirumpimbá si'maraaó suwaná mirá oró súwasa taraváá-kwántómbá minkwáásígó arumpinkémbá kárúwesa póí tirumpimbá kovérówasa mimpóíyómbá amápa'a ámémpakemba isaaisésa nonkwaaúmpíntá kumpérómba putásowasa ");
INSERT INTO kze_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","póíra'o tavíkówai úmba awánésa avekáán-umai naaópa'a kwésa kígauvimpa'o máyón-kwaasi mósimatim-besimati uwasá isésa koawánanae sésa kumbá ");
INSERT INTO kze_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ísunopa'a koyorupésa awánomba taraváá-kwántómbó arumpinkémbó kóun-kwaasigo unáánkwátói úmarena kawe'á umái máyowasa koawánésa táátavai uwasá ");
INSERT INTO kze_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ísumo minkwáásígómbó kawe'ó umánkowasamo awánon-aine póígomo ún-aine simátímúwasa ");
INSERT INTO kze_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","isésa Ísuntavesa sésa maambárává'á ivá siyuwéya kóaao suwaná ");
INSERT INTO kze_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","nompí-sípívímbá usámaaisowana taraváá-kwámbó arumpinkémbó mayauwón-kwaasigo Ísuntavena asiramái séna esé kónáe súwana ");
INSERT INTO kze_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ímanivo ená naaópa'a kuré Ísóigomo arumbó umánkenamo kawe'ó umánkáin-aimba enamááraawi kosimátimiyo súwana ");
INSERT INTO kze_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tékáporisi-ayampa'a mindáópata Ísumo umánkon-aimba simátíma'maena kúwasa amápa-kwaasi sáwívar-imayaa uráawe. ");
INSERT INTO kze_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ísu Káríri-kwaaunkona menávápákémbá nompí-sípívímbá koyauweréna túmba moórágwara'a kwaaúnkón-awampa'a máyówasa sáwíva-kwaasi torupowaná ");
INSERT INTO kze_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","moóráwai mono'-nánká'ó kárákwirowai áwí'a Yáírasi téna Ísumba taawánéna Ísu anóndakoman-iye séna aísamaivimba kumbéna ");
INSERT INTO kze_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","asiramái séna kesiyáámúmba puwíndayavena kwéivo tiré ane'á koyátorenana asóvéna kawe'á umái máíno súwana ");
INSERT INTO kze_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ísu kwesé kúmba sáwíva-kwaasi Ísumba taúkúraa'namai kwa'maé kuwaná ");
INSERT INTO kze_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","moórá-ininkomba áí'a kwéun-ininkogwara'a kwa'maéna kúmba kwembá naaeyámba kwéankowana sísamaivakemba kae'á kumbaimái-ima maisuwéna mináí'á íma érankowasa ");
INSERT INTO kze_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","sáwíva-sontaa-kwaasi áwa'naa uwaná óísamba tíma'mai ánásasuwowana mináí'á íma érankomba anón-ai'a umágúwana ");
INSERT INTO kze_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","minínínkómá Ísumo kawe'ó umátínkaron-aimba iséna séna Ísuna unáánkwátóira'a koyátóráánanama sí'a ésinkaniye séna sáwíva-kwaasimo kwa'maé kumpímbá minínínkó maréna ánaaempakemba unáánkwátóira'a tátorowana ");
INSERT INTO kze_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","mindááéyánkoma érankowana imáyáama éna asóvasinkaiye súwana ");
INSERT INTO kze_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ísu imáyáama éna séna kempínkén-ásíráyánkó moóráwaimba kawe'á umánkáiye séna kwántámai tuwánéna séna nááwawa kesí unáánkwátóira'a tátoraina'iyo súwasa ");
INSERT INTO kze_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","kwená kwayó-kwáásí Ísumba simámesa sésa úwé sáwíva-kwaasi kwenkuvará'a úmaesa íyómpimba tátokaavo nááwawa kesí unáánkwátóira'a tátoraina'iyo nóra séwa kwéseno suwaná ");
INSERT INTO kze_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","tátokaiwaintavena mógara'megara úwana ");
INSERT INTO kze_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","minínínkó imáyáa éna séna asóvasinkaiye súwana ayántámbá kwétowana Ísu aísamaivimba kumbaéna asóvamankon-aimba simámuwana ");
INSERT INTO kze_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ísu séna kesímánaako kentáváí se árai'a súwa'naa íníwaiman-iye sénda póna áí'a éránkáivo kawe'á umái kwaaó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ísu mináímbá kwésuwasa mono'-nánká'ó kárákwirowaina naaópaken-kwaasi tésa Yáírasintavesa sésa enayáámúnko pukáivo anóndatavai ténavo simámiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ísu mináímbá iséna ivátuwena Yáírasintavena séna mináíntáváí íma áákar-aaka'a éma kentáváí ísámai kuwo séna ");
INSERT INTO kze_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","kwa'maésamo kun-kwáásíyóntávéna maanká'á méwaro séna Pítaante Yémésinte kwenáváko áwí'a Yóninte tí'maena kúmba ");
INSERT INTO kze_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","sáwíva-kwaasi mono'-nánká'ó kárákwirowaina naaúmpa'a torupamái mésa anón-ivi'a kwétowana Ísu iséna ");
INSERT INTO kze_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","naaúmpa'a usávé'mai iyéna séna íma ivi'á taaró. minárásí íma pukáivo úwoi aúmá kwaiguráiye súwasa ");
INSERT INTO kze_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ísun-awíráái suwaná ti'mátuwowasa máápa'a kunákárúwowana minárásígó anóvowiye kwená kwayó-kwáásíráúm tí'maena minárásígó pukópa'a iyéna ");
INSERT INTO kze_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ayáánka'a tátorena kwenááivinkemba simámena séna tarita kumi mirámó súmba kwántámai séna inaamarúgóo usásinaao súwana ");
INSERT INTO kze_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","usásinkwena sísamaivakemba kae'á kumbaimái-ima maisukáin-inaamaruma usásinowasa awánésa táátavesa uwaná ");
INSERT INTO kze_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ísu asiramái séna kemó únda-aimba íma simátíméro séna minárásígómbá toómbá áméro siráiye. ");
INSERT INTO kze_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","minkákémbá Ísu kwenamáápa'a kwéena kwená kwayó-kwáásíyé kumbá ");
INSERT INTO kze_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yútaa-kwaasi monor-áímbá kwéison-kanaara'a mono'-náúmpá'á iyéna aaí simátimuwasa sáwíva-kwaasi isésa táátavai ésa sésa náávakena kawer-ímáyáá mairéna kawer-áímbá kwésimasimenayaawa nááwawa asirayámbá ámísana kawe'-máyáí ímo awánáúnda-mayai kwémayaiyo. ");
INSERT INTO kze_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","kwentáámó awánáúnda taaineí évaka-tantaa'o kwéiwaiman-iye. Máríyaa áánimba éna Yémési Yósisi Yútási Sáímoni tuwaaómán-iye. kwenáúnava'a maanká'á máyáawe. maankákéwáímá póna úwoi-kwaasiman-ivo náávakena mináímbá isénawa minásíráyámbá mairénawa kwésiyo sésa kayorésa tínaaemba umámúwana ");
INSERT INTO kze_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ísu simátimena séna Áánútun-aai simátímíwai ó'on-o'on-daopa'a kwénaaisasa kwenáwí'a mósá kwémaraavo kwená naaópa'a komáyáimba kwenamááraa sésa kesáámó úndanten-kwaasiman-iye sésa kwenáwí'a íma mósá kwémaraawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","kesáámó úndanten-kwaasima éna íma súwa'naa íníye suntávéna ímo awánom-bayai moórá-mora-mayaiye su'mai mairáiye. moórá-mora tí'o ún-kwaasi tine'á ayáándei tátorena asóvamatinkena ");
INSERT INTO kze_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","kwenamáápaken-kwaasi sésa íma súwa'naa íníye sun-áíntávéna imáyáa uwááena naaó'-nao'a Áánútun-aai simátímapa'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ísu kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi tááyowasa tuwaná kwaási tirumpinkémbá taraváá-kwámbá maitíyu'mae'a nááóro-asirayamba tiména séna kaesé umásuwe'a nááóro séna ");
INSERT INTO kze_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","asiramái simátimena séna aampa'ó kwíyamba íma moórá-yantaa'a maimaé'a koró. toómbá íma maimaé'a kwé'a toón-únámbá íma maimaé'a kwé'a óntamba íma maimaé'a koró. tááúmba vaimaé'a ");
INSERT INTO kze_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","tísamai-anaamba kwimaé'a moórá-mora-umai unáánkwátói timantenká umái kuvé'mae'a koró. ");
INSERT INTO kze_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Áánútun-aai simátimenaaontave'a moórá-naopa'o kwíyasamo naambó timíya'a mindáúmpáré su'mai mé'a kentí mayáí maimái ánáse'a mindámbá tuwé'a ó'on-daopa'a koró. ");
INSERT INTO kze_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","moórá-naopa'o kwíyambo naambó ímo timésamo kentááimo ímo isáíyanamo éna Áánútu mindáópaken-kwaasi íma aamoí umátinkanivo umásítai'a é'a tísamaivakem-baramo uwáéntemba unté'a koró Ísu simátimuwasa ");
INSERT INTO kze_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","kwená kwayó-kwáásí isésa naaó'-nao'a kwénaaesa kosimátimesa sésa sáwí-imayaa tínaaemba umáme'a Áánútumpa'a teró sésa ");
INSERT INTO kze_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","taraváá-kwántómbá kwaási tirumpinkémbá komaitiyuwésa tí'o ún-kwaasi taaéraampinken-domba atínkáva'a kuwasá asóvamatinkava'a kuráawe. ");
INSERT INTO kze_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ísuna mayáígón-áái símae íyúwana Káríri-marara-kawaanako áwí'a Éróti mináímbá ísarai. Ísuntavesa évakarawai sésa Yóni nombó pétinkaraiwai pukáimpinkemba usásinkena póna kwempímbá asirayámbá kwáyáísana mirám-báyáí kwémayaiye suwasá ");
INSERT INTO kze_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","évakarawai sésa kwemá Áánútun-aai simátímakowai áwí'a Íráiyaa pukáimpinkemba usásinena máyáiye suwasá évakarawai sésa kwemá naaóvá'á Áánútun-aai simátímakowairaamba máyáiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Éróti iséna séna kwemá Yóni nombó pétinkaraiwaiman-iye. kemá simátinkaunasa Yóni anumarambá arátúwááwana pukáisana usásinankaisana máyáiye Éróti siráiye. ");
INSERT INTO kze_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","ááéma Éróti kwenáváko awainínkómbá áwí'a Erotíyasimba mairówana Yóni séna enáváko awainínkómbá aambá áúmbakaawa mayááne simásima'a úwana Éróti ti'marówasa Yónimba koáí'maesa ándávimba máánkarowana Erotíyasima Yóni ááiyavena aaisambá séna inkamónáe súwana ");
INSERT INTO kze_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Éróti séna ímaniye séna Yóni kawer-ímáyáágwárá-kwáásí úntavena Éróti kwenáároi inkaiséna kwenká'á tavíkéna Erotíyasima inkámívo séna kwenká'á tavíkéna kwenááima ísámai kaumbo-káér-imayaa umánkena aasiyaasí koísaraiye. ");
INSERT INTO kze_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ánivo naaémba Erotíyasina kanaamá túmba Éróti anón-tanomba kaumái kwená kawáá-kwaasi ááipin-anon-kwaasi Káríri-ayampaken-anon-kwaasi tímúwasa nowaná ");
INSERT INTO kze_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erotiyási ayáámúnko téna araimá marówasa Érótiye toómbá naráan-kwaasiye aamoí umánkówana Éróti minárásígóntávéna séna nóintantaatavena ankáíya simásímína'a áméno séna ");
INSERT INTO kze_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","árai'a súnda pó'a sísaina'a áméno. kesí maramó arááímo táíndamo e sísaina'a tasá-áméno súwana ");
INSERT INTO kze_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","anówamba koáísaa ena séna nóintantaara komayánaumno súwana Yóni nombá pétinkaraiwai a'nómbá koáísaa-e mayaaó súwana ");
INSERT INTO kze_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","avekáán-úwana Érótinopa'a téna taáísaa ena séna ívé'a Yóni nombá pétinkaraiwai a'nómbá ará'mái táávepimba maré simiyó súwana ");
INSERT INTO kze_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","iséna arumbá kwéumbanivo aiva'á asirayán-áímbá siráin-aimba imáyáa éna toómbó naan-kwáásígwárá'á ísaraantavaiye séna íma a'áo sénáe séna ");
INSERT INTO kze_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","i-kwáásí moórá ai'marówana ándávinkemba Yónimba anumarambá ará'mái a'nómbá ");
INSERT INTO kze_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","táávepimba maréna maimaéna minárásígómbá máamuwana maimaéna anówamba máamuwasa ");
INSERT INTO kze_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yónina kwayó-kwáásí isésa anómba komaimái utamánkaraawe. naaémba Éróti Ísuna mayáígón-áái iséna séna minkwáásígó Yóni nombó pétinkaraiwai éna pukáimpinkemba usásinankaisana máyáiye Éróti siráiye. ");
INSERT INTO kze_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ísumo mayáírá'ó ti'mákain-kwaasi mimbáyáí maisuwésa Ísunopa'a tésa amápa'-mayaimo máyón-aimba aaimó sun-áímbá simámúwasa ");
INSERT INTO kze_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ísunopa'a sáwíva-kwaasi kuré ire untávésa toómbá íma kawe'á umái nowaná mindáyavena kwená kwayó-kwáásíyávéna séna kwaásimo ímo máyaiyapata kométa agándaano súwasa ");
INSERT INTO kze_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","nompí-sípívímbá usámaaisesa kwaásimo ímo máyáapataawe sésa kuwasá ");
INSERT INTO kze_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","sáwíva-kwaasi tuwánésa aúyésa naaó'-naokemba marapá'á kóyo uwasá Ísun-iyai nompí-sípívímbá kumbá ");
INSERT INTO kze_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","marapá'á ásávena misáwívá-kwáásí tuwánéna arumbá umátinkena sipisípi-poi-ayuraamba miwítí kawáá íma máyówasa kewé su'mai máyóntavena Ísu arumbá umátinkena ayáátáár-aai kwésimatimuwasa ");
INSERT INTO kze_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","enónka'a kwená kwayó-kwáásí kwenópa'a tésa sésa íma sáwíva-kwaasi máyáapa'an-ivo enáíndara'a ");
INSERT INTO kze_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ti'márénasa egwaa'-náópimpa'a kwénaaesa toómbá meéyámbáráaro suwaná ");
INSERT INTO kze_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ísu simátimena séna kemá toómbá tíméro súwasa sáwívar-ontankaken-tomba 200 kinaaraken-tomba meéyámba'maiya timúsina. óntamba íma kwáyáiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","nóraumai-tona káyáiya koawánaaro súwasa koawánésa tésa sésa sáwíyan-tomba éva'aasei-tonkwara kae'-nóyáákwárá'á kwáyáiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ísu kwená kwayó-kwáásíyávéna séna inkwima'mái mara'á máéro súwasa ");
INSERT INTO kze_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","moóráva'a 50 kwaasi máúwasa moóráva'a 100 kwaasi máúwasa miráumai-kwaasi kwimakówana ");
INSERT INTO kze_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ísu éva'aasei-tonkwara kae'-nóyáákwárá'á maisokéna kwíyómpa'a karákéna Áánútuntavena súwi simásuwena mintómbá topán-topan-umai kwená kwayó-kwáásí timúwasa misáwívá-kwáásí tímúwasa noyáá'a topán-topan-umai timúwasa misáwívá-kwáásí tímúwasa ");
INSERT INTO kze_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","amáparawai nowaná tímú'a vówasa sáwíva-kwaasi 5,000 kwaasi nowaná tímú'a vówasa kwená kwayó-kwáásí mintón-ayai sísamaivakemba kae'á kumbaimái-unampimba áítumai ógwitaraawe. ");
INSERT INTO kze_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","áítumai ógwitowana minkákémbá Ísu kwená kwayó-kwáásí ti'maréna séna kesí aiva'á nompí-sípívímbá usámaaise'a menávápá'-náópa'a Pétésáítava'a koró. misáwívá-kwáásí kwéti'mare'a sé'a kentí naaó'-nao'a koró simátimenaumne séna ");
INSERT INTO kze_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","misáwívá-kwáásí ti'marówasa miwítí naaó'-nao'a kuwaná Áánútumpa'a námúnaamo síndayavena omápa'a umáyowana ");
INSERT INTO kze_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","no'wáámba aúkúwana Ísu kweyáá marapá'á máyowasa kwená kwayó-kwáásí nompí-sípívímbá non-avóvomayaapa'a máyówana maramá nénka'a kwáyowana ");
INSERT INTO kze_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ísu awánómba anón-unda to'maé kwétena misípí tayáto'marowasa nombó tuwíntámaesamo kun-támayo'a nonkó tavímayowasa íma kumbá irataró'a Ísu non-avóvomayaapa'a kwénaaena kwená kwayó-kwáásímó máyónka'a téna táyaaitaguwasa ");
INSERT INTO kze_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","awánésa táátavesa ésa tiyántámbá kwétowasa sésa kwaántáo kwénaaiye suwaná Ísu avekáán-umai séna táá'a kaivó aáno máéro. kemá úne séna ");
INSERT INTO kze_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","nompí-sípívímbá usámaaisena kwegwárá'á umáyowana anón-undaoma maivaiyówasa táátavesa ávááraumai uwaná ");
INSERT INTO kze_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","íma táákoma kawe'á umái méra. sáwíyan-tompinkembo sáwíva-kwaasi taaín-timuwasamo nowáíná ááimba íma táákoma kawe'á umái méraawe. ");
INSERT INTO kze_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","táátavesa ávááraumai ésa kwaaúnkóná menávápá'á Kénésáréti-marava'a kumbá non-awámpá'á nompí-sípí ándánei avíkwímaresa ");
INSERT INTO kze_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","marapátá ásávowasa mimbápákén-kwáásí Ísumba aúyésa ");
INSERT INTO kze_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","naaó'-nao'a simátimesa Ísumo tamaún-aimba isésa tí'o ún-kwaasi kúkutaavimba tí'maesa tóyo uwaná ");
INSERT INTO kze_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ísu kíto'-nao'a anón-dao'a kwaivá kwénaauwasa tí'o úwai tí'mai maruká'á marésa sésa ená unáánkwátói-araaira'a tátoraiyana tí'a étinkainkwae suwasá tátórówana tí'a étínkaraiye. ");
INSERT INTO kze_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé Yérúsaremu-naopakemba Ísumo máyopa'a tésa ");
INSERT INTO kze_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","tuwánomba Ísuna kwayó-kwáásí évaka'a tiyáámba íma sese un-tíyáándéí toómbá kwénowasa ");
INSERT INTO kze_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yútaa-kwaasi ámáán-kawaa-kwaasiye úwoi-kwaasiye tíkwá'náí ámáámba kwáróntavesa tiyáámba sese umásukesa toómbá nésa ");
INSERT INTO kze_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","máákétirakemba naaópa'a iyésa tiyáámba sese umásukesa toómbá nésa tíkwá'náí ámáámba ó'on-o'on-amaamba kwarésa tááve'a nonánámá anavéúmbá sese uráawe. ");
INSERT INTO kze_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé Ísunka'a torupésa sésa ená kwayó-kwáásí nóra isasá kentáá síkwá'náí ámáámba íma kwarésa tiyáámba íma sese ombá toómbá kwénaao suwaná ");
INSERT INTO kze_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ísu séna kaumbo-káér-ainkwara-kwaasin-owe. naaóvá'á Áánútun-aai simátímakowai áwí'a Áísáya keinárawatavena árair-aimba siráimba agaimaréna séna Áánútu séna maawímá kesúwí'a tóikakene su'mai sésa kesí imáyáa íma tirumpimbá kwáyáiye. ");
INSERT INTO kze_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","kwaásiti ámáámba simái paárombanivo Áánútuna ámáámban-iye kampa'á sembá miráráán-umai kesí imáyáa kampar-ímáyáá mósá kwémaraawe Áánútu siráimba aúváívimba agaimakáiye. ");
INSERT INTO kze_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Áánútuna ámáámba tuwé'a tíkwá'náí ámáámba kwétoraawe. ");
INSERT INTO kze_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Áánútun-aai kwétuwaantavai miwá anondá kentááiyavai aamoí kwéowe. ");
INSERT INTO kze_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","naaóvá'á Mósesi séna kentinóvowi túwí'a anómba oró. ánivo anóvowimo sáwíkaambo simátinkaindawaimba tuvuwíyana puwíníye Mósesi siráivo ");
INSERT INTO kze_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","keinárawa'o siráamba moóráwai anóvowiyavena simátimena séna moórá-yantaa'a Áánútundeiman-ivo íma kanaán-umai timénaumne siréna ");
INSERT INTO kze_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","anóvowima íma kwétuwa'naa-iye. mirámó ontáváí kanaán-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","mirá-sáwí'ó ontávé'a Áánútun-aai tuwé'a kentíkwá'náí ámáámba kwégware'a kentáái kwésimatimewe. miráráání'a kwéowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ísu mináímbá simátímatuwena kwaásiyavena teró súwasa kwenópa'a tuwaná séna simátíménda isé'a kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","máápaken-tantaa'o naawáí íma kwaási sáwí'a kwéumatinkaivo tirumpinkén-áínkó kwaási sáwí'a kwéumatinkaiye.  ");
INSERT INTO kze_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","kwéisaawai ísámai kawe'á oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ísu simásuwena minkwáásíyómbá mátiyuwena naaúmpa'a umáyowasa kwená kwayó-kwáásí sésa mináínkóná ááimba simásimiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ísu séna kenkwárá'á íma tááko pééi kwéisa'a mé'a ísáambanivo íma ísámai kawe'á uráawe. máápaken-tantaa'o naawáí kwaási íma sáwí'a kwéumatinkaiye. ");
INSERT INTO kze_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","mindá íma imáyáa kunkwaéna tindáámpa'a kunáyúsúgwinivo ");
INSERT INTO kze_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","aaimó kwésemba tirumpinkén-ímáyááó éna mindá kwaási sáwí'a kwéumatinkaiye. ");
INSERT INTO kze_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","tirumpin-ímáyáávínkémbá sáwí-imayaa ésa tínkamiyasamo puwónááoni'a ésa aarai-úmóyámbá ésa kwaai-úmóyámbá ésa amápa-tantaa'a umóyámbá ésa ");
INSERT INTO kze_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","túran-anda ésa mirá-mira-sawi'a ésa kampar-áímbá sésa aosaambá kwimaé naaésa kawe'-máyáímó kwémayaantavesa tirunkó simái sáwí'a kwéumatinkesa tívókari'a ésa uwo'aórí'a ésa ");
INSERT INTO kze_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","mirá-sáwí'ó kwéomba tirumpinkén-ímáyááó kwaási sáwí'a kwéumatinkaivo tiyáámbo ímo sese ombó toómbó kwénaamba mindáo kwaási íma sáwí'a kwéumatinkaiye Ísu siráiye. ánivo Ísumo kwemó siráimba amápa-tomba kawe'á umái kwénaawe siráiye. ");
INSERT INTO kze_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ísu mináímbá simásuwena kwená kwayó-kwáásíyé mivá'á tuwéna Táyaa-naopare Sáítóni-naopare mináyámpá'á kúmba moórá-naumpa'a uména séna kemó tamaúnda íma simátíméro súwasa ánivo évaka-kwaasi tamáún-aimba ísówana ");
INSERT INTO kze_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","moórá-ininko ayáámúnko arumpimbá taraváá-kwámbá máyowana minínínkó Ísumo tamáún-aimba iséna avekáán-umai kwenópa'a iyéna mara'á kumbaéna ");
INSERT INTO kze_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","kwemá íma Yútaa-inimba póna Síriyaa-marava'a Vínísiyaa-naopaken-ininko Ísunopa'a iyéna mara'á kumbaéna asiramái séna kesiyáámúnko arumpinkémbá taraváá-kwámbá mayauwaaó súwana ");
INSERT INTO kze_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ísu simámena séna aiva'á iyámpói toómbá timénaumne. iyámpóíti toómbá maimái iyámbá timúnavo miráumai Ísareri-kwaasimo túwa'naa úndantemba emá ó'onkaa-inimba ónda pó'a áwa'naa únavo kwésune súmbanivo ");
INSERT INTO kze_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","minínínkó séna anóndako árai'a sémpo iyámpóíti toón-ayai iyánkó tamandáníye. miráumai ó'onkaa-ininkoman-iye sinaná kanaán-ína súwa'naa íníyone súwana ");
INSERT INTO kze_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ísu séna kawer-áímbá séndayavai enayáámúnko arumpinkémbá taraváá-kwámbá mayáúkaumpo ená naaópa'a kwaaó súwana ");
INSERT INTO kze_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","kwená naaópa'a kwéna koawánómba taraváá-kwámbá kóúrowana ayáámúnko kawe'á umái tuvaiká'á méraiye. ");
INSERT INTO kze_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ísu Táyaa-naopar-ayampakemba Sáítóni-naopar-ayampa'a táúkúmaena Tékáporisi-ayampa'a táúkúmaena Káríri-nonkwaaumpa'a kúmba ");
INSERT INTO kze_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","évakarawai aívó'na'a áí'maesa tésa sésa enayáándei táto'mai asóvamankaao suwaná ");
INSERT INTO kze_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","kwaásivinkemba áí'mai kweyááva'a ankéna ayáánánánei áápimba maréna awirááíma kwi'maréna amáávíra'a tátorena ");
INSERT INTO kze_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","kwíyómpa'a karákéna sirumbá kwéiye séna kwenááivinkemba séna epaata mináímbá kwántámai séna áá'o kaúnímba intíyuwaumne súwana ");
INSERT INTO kze_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","áá'a kawe'á úwana amáávíma etóyóí úwana aaí kawe'á umái súwana ");
INSERT INTO kze_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ísu asiramái séna íma simátíméro súwasa íma ísónkakemba simátímapa'a kuwasá ");
INSERT INTO kze_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ísówana ávááraumai táá'a kówasa sésa amápa-tantaa'a kawe'á unté kwéiyena táá'o kaúnín-kwaasi kawe'á kwéumatinkena aaimó ímo kawe'ó umáímo sen-kwáásí kawe'á kwéumatinkaiye siráawe. ");
INSERT INTO kze_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","moórá-tawai sáwíva-kwaasi torupowaná miwítí toómbá ánásowana Ísu kwená kwayó-kwáásí tááyowasa tuwaná ");
INSERT INTO kze_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","séna kaumbo-táwai kesé máyáawana maimaésa tiráan-tomba ánásaisa'a sirumbá kwéumatinkaumne. ");
INSERT INTO kze_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ti'máráanasa kentí naaó'-nao'a kónááombanivo némpaken-kwaasi aampa'á kwíyamba kánoka'a pósa púwóvainivo súwasa ");
INSERT INTO kze_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","kwená kwayó-kwáásí sésa kavóná-marava'an-ivo náákakenta toómbá maimáíya timénaumno suwaná ");
INSERT INTO kze_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tísaa ena séna nóraumai-tona kwáyáiyo súwasa avakaeté kwáyáiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","minkwáásíyóntávéna séna mara'á máéro séna avakaeté-tomba maisokéna Áánútuntavena súwi séna toómbá topán-topan-umai kwená kwayó-kwáásírá'á timúwasa minkwáásíyómbá tímúwana ");
INSERT INTO kze_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","kaumbo-káé'-noyaa'a kwáyowana Ísu maisokéna Áánútuntavena súwi séna kwená kwayó-kwáásírá'á timúwasa minkwáásíyómbá tímúwasa ");
INSERT INTO kze_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","nowaná tímú'a vówasa sáwíva-kwaasi 4,000 kwaasi nowaná tímú'a vówasa kwená kwayó-kwáásí mintón-ayai túwómba avakaeté-unampimba áítumai ógwitowana ");
INSERT INTO kze_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ísu misáwívá-kwáásí ti'maréna kwená kwayó-kwáásíyé nompí-sípívímbá usámaaisesa Táómánúta-ayampa'a kuráawe. ");
INSERT INTO kze_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","mivá'á Ísu máyowasa ámáán-kawaa-kwaasi sáwí-aimbo sínda isánáe sésa Ísunopa'a tésa sésa áraira Áánútumpakena kunkáana ímo awánáúnda-mayai máyénata awánaano suwaná ");
INSERT INTO kze_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ísu arumbá umbaí kwétopakemba séna ívé'o máyáan-kwaasi nóra séra ímo awánáúnda-mayai máyénata awánaano kwéseo. árai'a simátime'a sé'a ívé'o máyáan-kwaasi íma agaráátinkanaumne séna ");
INSERT INTO kze_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ivátiyuwena nompí-sípívímbá usámaaisena nonkwaaúnkóná menávápá'á kuráiye. ");
INSERT INTO kze_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ísu kwená kwayó-kwáásíyé nonkwaaúnkóná menávápá'á kumbá kwená kwaási péréti-tomba íma máyómba tuwinkésa kuwaná kímbora-tomba nompí-sípívímbá kwáyowana ");
INSERT INTO kze_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ísu ámáán-kawaa-kwaasiye Érótiye kaumbo-káér-ainkwara-kwaasi owé-ímáyáá kwéena kwená kwayó-kwáásí simátimena séna intóráín-tantaa'a sáwíyan-tantaa'a moórá-tonko áwí'a péréti mimpímbá kwémaraawana kwéintorena anómba intembá ámáán-kawaa-kwaasiye Érótiye miwí tááiyavai kentúra'a kárákwimai máéro súwasa ");
INSERT INTO kze_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","keáímbá sésa nóra séna mirá kwésiyo. péréti-tomba íma makáunanaya mirá kwésiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ísu keáímbó kwésun-aimba iséna nóra séra toómbá íma kwáyáiye-aimba kwéseo. kanaán-umai toómbá timénaunda ááémo uráundawaina ááimba íma tááko pééi kwésiye. kentí imáyáagoma kentirunkómá usisi'ándaisa'a kwéowe. ");
INSERT INTO kze_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","túramba kwáyáimbanivo íma awánamai kawe'á kwéowe. táá'a kwáyáimbanivo íma ísámai kawe'á kwéowe. ");
INSERT INTO kze_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","éva'aasei-tomba topán-topan-umai sáwíva-kwaasi 5,000 kwaasi timéwánasa naráaamba mintón-ayai nóraumai-unampina áíturaao séna tísaa úwasa sísamaivakemba kae'á kumbaimái-unampinta ógwitaraumne suwaná ");
INSERT INTO kze_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","avakaeté-tomba topán-topan-umai sáwíva-kwaasi 4,000 kwaasi timéwánasa naráamba mintón-ayai nóraumai-unampina áíturaao séna tísaa úwasa avakaeté-unampinta ógwitaraumne suwaná ");
INSERT INTO kze_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ísu séna nóra éra íma tááko pééi sisa'á ísaraao Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ísu simásuwena kwená kwayó-kwáásíyé Pétésáítaa-naopa'a kumbá évakarawai aúramba kavíkówaimba áí'maesa Ísunopa'a tésa sésa táto'mai asóvamankaao suwaná ");
INSERT INTO kze_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ísu ayáánka'a tátorena áí'maena mindáókona ayááívá'á kwéna aúrampimba awirááíma kwirankéna aúranka'a tátorena séna ára kwéawanaano súwana ");
INSERT INTO kze_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","awánéna séna kwéawanaumne. taairaán-kwáásí marapá'á kwénaaowa'a kwéawanaumne súwana ");
INSERT INTO kze_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","moórágwara'a Ísu aúranka'a tátorena kawe'á umánkowana aúramba kararéna kawe'á umái kwéawanowana ");
INSERT INTO kze_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ísu séna mindáópa'a kónavo ená naaópa'a tayauweré kwaaó siráiye. ");
INSERT INTO kze_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ísu simásuwena kwená kwayó-kwáásíyé Sísáriya Vírípai-naokon-ayampa'a kúmba aampa'á kwéguwana kwená kwaási tísaa ena séna kentáváí amáparawai nóran-kwaasiye kwéseo súwasa ");
INSERT INTO kze_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","miwí sésa évakarawai sésa emá Yóni nombá pétinkaadawai óne sewasá évakarawai sésa naaóvá'á Áánútun-aai simátímakaandawai áwí'a Íráiyaama óne sewasá évakarawai sésa naaóvá'á Áánútun-aai simátímakaawaivinkemba moóráwai óne kwésewe suwaná ");
INSERT INTO kze_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ísu séna keinárawa'a kentáváí nóran-kwaasiye kwéseo súwana Sáímoni Pítaa séna Áánútu usásinankaiwaimba Yútaa-kwaasiya kwéamu'maraundawaiya óne súwana ");
INSERT INTO kze_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","mináímbá íma simátíméro Ísu asiramái siráiye. ");
INSERT INTO kze_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ísu kwemó puwínín-aimba ááimba ásámai kwená kwayó-kwáásí simátimena séna sí'a índai'a umásinkesa Yútaa-anon-kwaasiye mono-káwáá-kwáásíyé ámáámba sen-kwáásíyé tínaaemba umásimesa sínkamiya'a puwónaundanivo kaumbo-táwai ánásaina'a púwóndavinkemba usásinanaumne séna ");
INSERT INTO kze_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","miráumai avora'á simátimuwana Pítaa Ísumba áí'maena kweyááva'a máankena séna mirán-áímbá sénavo súwana ");
INSERT INTO kze_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ísu kwanténa kwená kwayó-kwáásí tuwánéna Pítaantavena asiramái séna Sáátáánigo siyuwé kóaao. kwaásiti imáyáavinkemba kwésempo íma Áánútuna imáyáavinkemba kwésene Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ísu mináímbá simásuwena kwaásiyonte kwená kwayó-kwáásíyé tááyena séna kesínaaemba kwaránáe síyawai tirááímo táínda-yantaa'a íma tátoraaro. kemá puwónaunda-taima súgwaata'mae'a kondantembá kesínaaemba kwaránááowaimba umbai-yántáá'á timíyasa minúmbáí-yántáá'á úwoi maimaésa sínaaemba kwaránááowe. ");
INSERT INTO kze_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","tirááímo táíndai'o ésa íma kawe'á umái ménaaovo kentáváí ísámai Áánútu áséi-aintavai ísámai tirááímo táínda-yantaa'o tuwésa puwésa aúnái'a umái maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","marapákémbá amápa-tantaa'a kwémaesa puwíyambo éna mintántáákó íma túwa'naa íníye. ");
INSERT INTO kze_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","puwíyamba marapá'ó makáan-tantaa'nei íma anondáí'a umásuwesa ókwara'a ayáátááka'a ménaaowe. ");
INSERT INTO kze_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ívé'a Áánútuntavesa íma imáyáa ésa máyáanka'a kenkwárá kesááigwara'o tigaemó umásínkáámba pó'a aáno kemó marapá'ó kúmónda miwí sigaemá umátinkanaumne. kemá kwaási úranda'a kumpaáruraundawai aáno kesivoná ságayankwara kwíyómpakembo Áánútuna kwayó'nárawati ságayankwara'o marapá'ó kúmónda miwí sigaemá umátinkanaumne. ");
INSERT INTO kze_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","árai'a simátime'a sé'a évaka'a maanká'ó máyáan-kwaasi íma aiva'á puwé'a Áánútu kwená asirayándéí kwégawaaimba awáné'a naaémba puwónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ísu mináímbá simásuwena ava'moraé-no'waamba kwaéna Pítaante Yémésinte Yóninte tí'maena anón-omapa'a iyúmba miwíyé su'mai umésa miwí túranka'a Ísu ó'oran-auma auvúwana ");
INSERT INTO kze_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","kwená unáánkwátóira'a ságayamba kwaéna kwayání'a kéna aaváúmó usénamo intembá mirá úwasa ");
INSERT INTO kze_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","awánomba kae-kwáásíráí kwíyómpakemba paárésarai mindárai túwí'a Íráiyaae Mósesiye Yútaa-kwaasi tíkwá'nárai Ísuwe kwaasái kwésuyana ");
INSERT INTO kze_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pítaa Ísuntavena séna anóndakoo maanká'ó maúndaya kawe'á imbá póta kwááyu-namba kaumbomá ónaundaya moórá endéí éta moórá Mósesindei éta moórá Íráiyaandei éta mirá ónaundayaawe súwana ");
INSERT INTO kze_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ávááraumai táá'a kówana nóin-aina'i síníyena póna mirán-aimba Pítaa siráiye. ");
INSERT INTO kze_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","mirá kwésunka'a ainánkó kuména káátaguwana mináínámpínkémbá aaigówé su'mai séna maawámá kesáánimba isa'á kwená imáyáa kwéune. kwenáái ísáaro súwasa ");
INSERT INTO kze_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","kwená kwayó'nárau awánomba mindárai kwíyómpa'a íyúwana Ísuwe su'mai méraiye. ");
INSERT INTO kze_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","máyowasa omápakemba kúmúmba Ísu asiramái simátimena séna awánaamba íma simátíméro. kemá kwaási úranda'a kumpaáruraundawai púwóndavinkemba usásinaandara'a awánaamba kanaará'á simátíma'mae íyóro súwasa ");
INSERT INTO kze_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","isésa íma simátimesa mináímbá úwoi tátoresa keáímbá sésa púwóndavinkemba usásinanaumne simbá nóran-aina'iyo keáímbá siráawe. ");
INSERT INTO kze_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","keáímbá sésa Ísuntavesa áísaa esa sésa ámáámba sen-kwáásí sésa Íráiyaa aiva'á paárínana Áánútu usásinankaiwai Yútaa-kwaasiya amu'makáundawaiya naaémba paáriniyemo sembá nóra sésa mináímbá kwéseo suwaná ");
INSERT INTO kze_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ísu séna aiva'á Íráiyaa paáréna to'mayaa íníye-aimba árair-aimban-iye. moórá-aimba kwaási úranda'a kumpaáruraiwaintavena agaimaréna séna kwembá áí'a índai'a umánkesa tínaaemba umánkanaaowe agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","simátime'a sé'a Íráiyaa á'a tiráiye. agaimaróntemba umái kwembá sáwí'a umánkanae sésa sáwí'a umánkaraawe. mirán-áímbá kwentáváí agaimaróntemba kemá kwaási úranda'a kumpaáruraundawaintavai agaimakáawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ísu simásuwena omápakemba kúmúmba kwená kwayó-kwáásítópa'a kúmúwasa sáwíva-kwaasi torupésa ámáámba sun-kwáásíyé Ísuna kwayó-kwáásíyé asirayán-áímpákémbá sésa ");
INSERT INTO kze_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ísu túntavesa ivátuwesa paruvará umánkówana ");
INSERT INTO kze_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ísu séna nóintavai asirayán-áímbá kwéseo séna tísaa úwana ");
INSERT INTO kze_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","minkwáásíyómpínkémbá moóráwai séna anóndakoo kesáánimba áí'mae'a túne. kwenarumpimbá taraváá-kwámbá máyáísana íma aaí kwésisana ");
INSERT INTO kze_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","mintáráváá-kwánkó táto'mai amentánaanta isaná tanaambá váguvagu kwéena áwááyaamba akékúndena aigareó nonkáánéna aíyayaamba sápísimagwisana mirá úmaena kwéiyisa'a ená kwayó-kwáásíyávé'a sé'a taraváá-kwámbá arumpinkémbá mayaúwáaro súnasa íma kanaán-umai mayáúkaawe súwana ");
INSERT INTO kze_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ísu séna kentáváí íma imáyáa kwéowana póna sirumbá umbaí kwétaivo nóraumai-tawaiya kesé ménaumno simásuwena séna ánivo enáánimba áí'mae tiyó súwasa ");
INSERT INTO kze_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","áí'maesa tuwaná mintáráváá-kwánkó Ísumba awánéna miníyámpóí améntáyuwowana tanaambá véna kwárere'a éna aigareó monkáánúwana ");
INSERT INTO kze_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ísu avowántávéna séna nósatawai ánkaraiyo súwana umaranka'á ánkaraiye. ");
INSERT INTO kze_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","tuvuwíndayavena póna sáwívaka'a améntámai irá káúvóra'na éna améntámai nompímbá túwáara'na kwéiye. emó kanaamó e arumbá maisinkéya súwa'naa uwo súwana ");
INSERT INTO kze_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ísu séna nóra séwa emó kanaamó e súwa'naa uwo kwéseno. Áánútumpa'a agevamái máyaawai amápa-tantaa'a kanaará'á ónááowe súwana ");
INSERT INTO kze_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","miníyámpóígó avowámá avekáán-umai anónka'a séna kemá Áánútumpa'a agevamái máyaundanivo kemá Áánútuntavai íma asiramái kwémaunda-yantaa'a súwa'naa uwo súwana ");
INSERT INTO kze_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ísu awánómba sáwíva-kwaasi sisipáá uwaná taraváá-kwántávéna séna aívó-taravaa-kwankoo auwé kóaao. íma koyauwérénda áka'a kóaao súwana ");
INSERT INTO kze_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","kwáá'a téna miníyámpóí améntáyuwowana tanaambá vówana arumpinkémbá kóúwana miníyámpóí púwóra'na umai máyowasa évakarawai sésa á'a púwíye suwaná ");
INSERT INTO kze_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ísu ayáánkwanda táto'mai usásinakowana koku'á méraiye. ");
INSERT INTO kze_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","koku'á máyowana Ísu naaúmpa'a umáyowasa Ísumo kweyáá máyonka'a kwená kwayó-kwáásí umésa sésa nóra séta mintáráváá-kwámbá íma kanaán-umaiya mayáúkaumno suwaná ");
INSERT INTO kze_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","námúnaa kwésemba pó'a miráumai mirán-táráváá-kwámbá mayauwánááovo ó'on-tantaa'neimo é'a íma kanaán-umai mayauwánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ísu simásuwena tuwéna Káríri-ayampa'a aampa'á kwégwena sáwíva-kwaasi torupaavó séna kesí kwayó-kwáásíyé su'mai aaí simátimenae séna aampa'á kwégwena séna kembá kwaási úranda'a kumpaáruraundawaimba ó'on-kwaasi timíyasa sínkamiya'a puwé'a kaumbo-táwai maisuwé'a usásinanaumne súwasa ");
INSERT INTO kze_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","kwemó sún-ainkona ááimba íma isésa áísaa ónáe sésa umbá táá'a kówasa íma áísaa uráawe. ");
INSERT INTO kze_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","íma áísaa esa Kápénéamu-naopa'a kumbá naaúmpa'a umáúwana Ísu tísaa ena séna aampa'á kwéte'a nóin-aina siráao súwasa ");
INSERT INTO kze_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","aampa'á kwégwesa sésa kentáávínkémbá nááwa kwéusayaaitaiyo sésa iséise úmae kwégwesa pósa íma aaí suwaná ");
INSERT INTO kze_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ísu mara'-maéna kwená kwaási sísamaivakemba kae'á kumbaimái-kwaasiyavena séna maísáaro. usáyaaitanae síyawai tínaaeni'a ésa amáparawaiti kwayó'á máráaro simásuwena ");
INSERT INTO kze_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","moórá-iyampoi áí'mai avumpimbá usásinankena taparéna simátimena séna ");
INSERT INTO kze_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","kentáváí imáyáa kwéesa iyámpói áwa'naa onten-umái kwésuwa'naa-owe. súwa'naa onten-umái Áánútu si'mákaiwaimba kwéawa'naa-owe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","súwana Yóni Ísuntavena séna anóndakoo moóráwai kwénaaena taraváá-kwántóntávéna séna Ísuna asirayámbá kwáyáintavai auwé kóaao simátímapa'a kwégwisasa mintáráváá-kwámbá kóuraawe. minkwáásígó íma kentáávínkén-kwáásímá ómpo íma miráne étuwaaoya siráumne Yóni súwana ");
INSERT INTO kze_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ísu séna íma tuvínankaaro. ímo awánaam-bayaimo máyáawai úwoi kesúwí'a íma sáwí'a simásinkanaaowe. ");
INSERT INTO kze_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","kentáásí mayáígómbá íma sáwí'a kwéowai úwoi kwésuwa'naa-owe. ");
INSERT INTO kze_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","árai'a simátime'a sé'a keinárawa'a tuwánésa sésa Ísu Káráísitina kwaási ombá pó'a túwa'naa ónáe sésa sáwíyan-tantaa'a nombá timíyawaima Áánútu kawe'-méyámbá timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ísu mináímbá simásuwena séna iyámpóígomo kesááiyavaimo áraire sintenkáán-umai évakarawai áraire kwésewe. évakarawai tésa kesááiyavaimo áraire kwésewaima kampar-áímbá tasimátimiyasa isésa sáwí-ampa'a kówíyasa Áánútu kampa'ó síyawai sáwí-meyamba anómba timínívo miwímó tinumarampimbó anón-ontambo aríkwímaresamo nompímbó túwáawasamo kumésamo kumpuwésarakai kampar-áímbá íma simátíméwasa sáwí-ampa'a íma kosinó. mindá kanaán-iye. ");
INSERT INTO kze_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","tiyáánkomo sáwí'o ína'a misáwí-ámpá'á kúnavo sé'a moórá-tiyaamba arátúwáaro. kae-tíyáámbó kwáyaina'o é'a sáwí-marupa'o iramó kaíkai'o kwéipa'a kónááomba mindá sáwí'an-iye. sáwí'o uráinda maisuwé'o máyáamba mindá kawe'án-iye. ");
INSERT INTO kze_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","tísamaigomo sáwí'o ína'a misáwí-ámpá'á kúnavo sé'a moórá-tisamaima arátúwáaro. kae-tísámáímó kwáyaina'o é'a sáwí-marupa'o iramó kaíkai'o kwéipa'a kónááomba mindá sáwí'an-iye. sáwí'o uráinda maisuwé'o máyáamba mindá kawe'án-iye. ");
INSERT INTO kze_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","túrankomo sáwí'o ína'a misáwí-ámpá'á kúnavo sé'a moórá-turamba pítuwaaro. kae-túrándéímo awáné'o é'a sáwí-marupa'o iramó kwégaipa'a kónááomba mindá sáwí'an-iye. sáwí'o uráinda maisuwé'o máyáamba Áánútu kwená kwaási kawááipa'a máyáamba mindá kawe'án-iye. ");
INSERT INTO kze_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","iramó kwégaipa'a marinkómó éna kwaíkwai'a kwéinana iramó éna íma pisináínda kaíkai'a kwéiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ísu simásuwena séna uwímó toónká'ó úmárááwanamo kawe'ó intembá Áánútuma kwaásira'a iramó kaintenkáán-umai maráínasa kawe'á umái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","uwímá kawe-tántáá'á imbánivo anómba ánásaisana ayáántámba kwáyáimbanivo ó'a uwímó káí'a íma úmaranaaowe. uwígómó áséimo intenkáámbá kwée'a paru umái ménaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ísu minká'á tuwéna Yútiyaa-ayampa'a Yótáni-nonkona menávápá'á komáyowasa moórágwara'a sáwíva-kwaasi torupowaná ké'naamba aaí kwésimatimuwasa ");
INSERT INTO kze_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ámáán-kawaa-kwaasi sésa sáwí-aimbo sínda isánáe sésa Ísunopa'a tésa sésa moórá-kwaasigo awainínkómbá kanaarárá auwáníyo. mirámó énamo éna ámáán-aimba karáni. íya karáníyo suwaná ");
INSERT INTO kze_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","naaóvá'á Mósesi nóra-amaana simátímakaiyo séna tísaa úwasa ");
INSERT INTO kze_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","miwí sésa Mósesi maará séna moóráwai awainínkómbá ai'mátuwaindawai aúváívimba agaimaréna séna kesuwainímbá ai'mátuwaumne séna agaimái amiíno siráiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ísu séna kentíkwá'ná tirumbá makáamba pósa Áánútun-aai íma ísóntavai mindáyavai Mósesi minámáámbá siráimbanivo ");
INSERT INTO kze_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Áánútu kwíyómba maramá taróruronka'a íma mirá siráivo Áánútu aaraigwárá kwaaigwárá'á taróruraiye. ");
INSERT INTO kze_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","miráumai taróruraintavai tinóvowi tiyuwésa awaikóe awainínkóe tágárotamai ");
INSERT INTO kze_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mimbórá-túmá ma'mái kwémaewe. mindáyavai awaikóe awainínkóe íma kae-kwáásíráámbá ésa mimbóráí'a kwéowe ");
INSERT INTO kze_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Áánútu aarai-kwaaí moórái'a umátínkaraintavai íma tasáéro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ísu simásuwena naaúmpa'a umésa kwená kwayó-kwáásí Ísumo sún-aintavesa áísaa uwaná ");
INSERT INTO kze_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","séna moóráwaimo awainínkómbó ai'mátuwenamo ó'on-inimbo kwémayaimba umóyámbá kwémayaiye. ");
INSERT INTO kze_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","moórá-ininkomo awaikómbó auwénamo ó'onkwambo kwémayaimba umóyámbá kwémayaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ísu simátimuwasa évakarawai Ísu tátorena kawe'á umátinkainkwae sésa iyámpói tí'maesa tuwasá kwená kwayó-kwáásí sésa tí'mae'a kóro suwaná ");
INSERT INTO kze_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ísu tuwánéna áwáá'a tiyéna séna íma kóro sé'a tiyuwáíyasa kesópa'a iyámpói úwoi teró. miníyámpóí kesópa'a tentembá Áánútu kwená kwaási kawááimba miráráán-umai kwégawaaimba iyámpói kesópa'a tí-amba íma ítátinkaaro. ");
INSERT INTO kze_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","árai'a simátime'a sé'a Áánútuntavesamo sésamo iyámpóíraan-umai kenká'á kwégawaa-onemo síyanamo éna miwírá'á kawááinivo ímo mirámó síyawaimo éna íma kawááiniye Ísu séna ");
INSERT INTO kze_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","miníyámpóíyómbá tiránkena tine'á tátorena kawer-áímbá simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ísu simátimena kwéguwana moóráwai isaaiséna Ísu anóndakoman-iye séna takívairena séna kawe'ná'á óne. nóra umáíya aúnái'a umái kwíyómpa'a maí'maira ónaumno súwana ");
INSERT INTO kze_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ísu séna kentáváí nóra séwa kawe'ná'á óne kwéseno. mimbóráwáí Áánútu kweyáá kawe'ná'án-iye. ");
INSERT INTO kze_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Áánútuna ámáámba á'a ísaraane. minámáámbá aúváívinkemba agaimaréna séna kwaási tínkamiyasamo puwónááoni'a íma oró. íma aarai-úmóyámbá oró. íma umóyámbá máyáaro. íma kampar-áímbá simátínkáaro. kwakaráí-áímbá íma seró. kentinóvowi túwí'a anómba oró siráiye súwana ");
INSERT INTO kze_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","mindákó séna minámáámbá kesí iyámpóírakemba ísare'a pó'a kawe'á úmae kwéiyune súwana ");
INSERT INTO kze_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ísu awánéna aamoí éna séna kawe'á éma moórá-yantaa'a íma kawe'á uráampo ená náaindaamba ó'on-kwaasi kwétime óntamba mairé ímo makéwai tímatuwenana ená kawe'-méyámbá Áánútu kwíyómpa'a ankáníye. tímatuwemo e kesínaaemba kwaráníyone súwana ");
INSERT INTO kze_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","mináímbá iséna sáwíva'-naindaamba makóntavai kanagí'á túmaena anón-imayaa úwana arunkó sáwí'a kwéuwana kuráiye. ");
INSERT INTO kze_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","kúwana Ísu kwanténa kwená kwayó-kwáásíyávéna séna sáwívar-oisambo makén-kwaasi Áánútumo kwená kwaási kawááipa'a kwíyamba umbaí táníye súwana ");
INSERT INTO kze_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","kwená kwayó-kwáásí mináíntáváí táá'a kówana kesí iyámpóíyono. óísan-imayaamo eémáyaiyawaimo Áánútumo kawááipa'o kwíyamba umbaí táníye. ");
INSERT INTO kze_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","moórá-poigo áwí'a káámeri mimpóígó kwaigóná avaapimbá íma kanaán-umai kóveraniye. káámeri-poigomo kwaigóná avaapimbó kóverainkakai sáwívar-oisamba makén-kwaasi Áánútu kawááipa'a kosinó súwasa ");
INSERT INTO kze_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","mináímbá isésa táátavai ésa sésa umbaí taintáváí nóran-kwaasiya Áánútu kawááipa'a ménaaoo suwaná ");
INSERT INTO kze_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ísu tuwánéna séna kwaási miwítí mayáínéí íma meéyámbaresa kónááovo Áánútu amápa-tantaa'a úwoi kanaán-umai kwéiye súwana ");
INSERT INTO kze_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pítaa séna isaaó. kentáásí amápa-tantaa'a tuwéta enánaaemba kwégwaraumne súwana ");
INSERT INTO kze_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ísu séna árai'a simátime'a sé'a kentáváí imáyáa ésa Áánútuna áséi-aimba kosimátimenaaontavesa naambáru'a tuwésa tuwaaísái tiyuwésa tívá'maa'a tiyuwésa tímánaa'maa'a tiyuwésa tinóvowi tiyuwésa táánimbaa'a tiyuwésa tiyáámúmbaa'a tiyuwésa miwítí maramá túwáawaina anondáma ");
INSERT INTO kze_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","marapá'ó máyáanka'a túwáan-tantaa'a mirán-tántáá'á sáwíva'a mémaesa tuwaaísái-i'a ésa tímánaa'maari'a ésa tinóisai-i'a ésa kentí iyámpóí-i'a ésa naambá maramá mayánááomba miwívímbá umbai-yántáárí'a umátinkanaaombo ésa naaén-kanaa aúnái'a umái kwíyómpa'a maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ívé'a évaka'a aivakéwáí aáno tínaaeni'a íyasa ívé'a évaka'a tínaaenkewai aáno aivarí'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ísu séna Yérúsaremu-naopa'a kónáe séna aampa'á kwégwesa Ísu aiva'á kúwana kwená kwayó-kwáásí táá'a kówana tínaaembo kun-kwáásígwárá'á táá'a kówana Ísu kwená kwaási sísamaivakemba kae'á kumbaimái-kwaasi tí'maena moórá-ayampa'a tínkarena kwempá'ó tínín-tantaakontavai mósimatimena ");
INSERT INTO kze_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","séna maísáaro. Yérúsaremu-naopa'a konanayá moóráwai kembá kwaási úrandakomba mono-káwáá-kwáásíyé ámáámba sen-kwáásíyé agaráátinkainasa kembó sínkami-aimba simái tarúmaresa sí'mai ó'onkaa-kwaasi timíyasa ");
INSERT INTO kze_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","kanaáráá'a kwésinkesa tuwirááíma kwisinkésa súwíruku'a kwénesa sínkamiya'a púwónasa utamásinkaiya'a kaumbo-táwai maisuwé'a usásinanaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","minkánáá Sépéti ááninkorasarai Yémésiye Yóniye Ísunopa'a tésarai sésarai anóndakoo áísaa oyaní'a umásinkaniyono suyaná ");
INSERT INTO kze_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","nóintavai kwétinkainara umátinkanaumno súwasarai ");
INSERT INTO kze_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ená ságayam-barupa'o umaéma kenkáí usásisinke évarevar-akwampa'a sinkáníyone suyaná ");
INSERT INTO kze_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ísu séna séyan-ainkona ááimba íma ísaraaiye. sáwí-nombo anavéúmpinkembo náúndanten-umai sí'a índai'a umásinkanaaomba keinárai kanaarárá kemó náúnda-anaveumpinkemba náyááoiyo. sí'o índai'o umásinkanaaontemba kanaarárá keinárai mirá umátinkanaaoo súwasarai ");
INSERT INTO kze_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","keiráí kanaám-pókai mayáyauye suwaná Ísu séna árai'a séye. kemó náúnda-anaveumpinkemba náyááoiye. sí'o índai'o umásinkanaaontemba keinárai mirá umátinkanaaovo ");
INSERT INTO kze_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kesí évareva-sukwampa'a kemá íma usásintinkanaumpo Áánútu kae'nárai umátínkaraimba póna usásintinkaniye súwasa ");
INSERT INTO kze_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ísuna kwayó-kwáásí siyáánkainarawa'a mináímbá isésa Yémésinte Yóninte áwáá'a tíyúwana ");
INSERT INTO kze_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ísu tááyowasa tuwaná séna á'a ísaraawe. marapár-ánón-kwáásíyómbá usáyaaitamai asirayán-áímbá simáti simati kwéuwasa kwenkóyai kwentáyai'a uráawe. ");
INSERT INTO kze_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","anón-kwaasimo ontembá keinárawa'a íma mirá oró. keinárawapinkemba usáyaaitanae síyawai ó'owiti kwayó'á maránááowe. ");
INSERT INTO kze_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","keinárawapinkemba aivarí'a ónáe síyawai amáparawaiti mayáímá túwa'naa oro. ");
INSERT INTO kze_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","kemá kwaási úrandako kumpaáruraundawai íma súwa'naa ígwáe'a kunkáumpo kemá kwaási túwa'naa ónáe'a kunkáumne. sáwí-imayaavinkemba iyátinkanaundayavai puwónaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ísuwe kwená kwayó-kwáásíyé Yéríko-noapa'a kumbá sáwíva-kwaasigwara'a mindáópa'a tuwésa aampa'á kuwaná Tímíyási ááninko áwí'a Páátímiyasi aúramba kavíkówai óntamba inaai simái mayánáe séna aanéiva'a kumbéna kwéinaai súwasa ");
INSERT INTO kze_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","évakarawai sésa Ísu Násáretivakewai kwétiye suwaná iséna anónka'a séna Ísuwo Tévítin-andarakewai ómpo arumbá umásinkaao súwasa ");
INSERT INTO kze_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","sáwívarawai áwáá'a aéésa sésa aaiseraaó suwaná mináímbá ivá kwétuwena ó'omba anónka'a séna Ísuwo Tévítin-andarakewai ómpo arumbá umásinkaao súwana ");
INSERT INTO kze_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ísu aampa'ó kweémáyomba kwená egwaa'á kousásinena séna ááyaaro súwasa aúrambo kavíkówaimba ááyesa sésa enarunkó kawe'á íno. kwéaayaivo usásinaao suwaná ");
INSERT INTO kze_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","a'marénamo máyon-ampaanta agwáímarena usásinena Ísun-aóká'á túwana ");
INSERT INTO kze_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ísu séna nóin-tantaara embó arááímo táínda-yantaa'a umánkanaumno súwana anóndakoo súramba kawe'á umásinkainkwae'a úne súwana ");
INSERT INTO kze_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ísu séna kentáváí kanaán-umai súwa'naa íníwaiman-iye sénda pó'a kawe'á umánkaumpo kwaaó súwana avekáámbá aúramba awánéna Ísun-ánaaemba kwakáiye. ");
INSERT INTO kze_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ísu kwená kwayó-kwáásíyé kumbá Yérúsaremu-naor-ampa'a kumbá Óríve-omakar-egwaa'-naokai moórá Pétévasi-nao'a úwana moórá Pétáni-nao'a úwasa minkáé'-náór-egwaa'a kwésa kwená kwayó-kwáásí kae'á máti'marena ");
INSERT INTO kze_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","séna epín-dáópa'a kurékai moórá-poigo áwí'a tónki koawáneyambo kwaásimo ímo ayáákainda-poi ándáma iyátuwekai áí'maekai tekaiyó. ");
INSERT INTO kze_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","moóránankomo tuwánénamo nóra óyáekai óyómo sínakai anóndako ayáá'mae'a konasá áí'maesa koyauweránááowe siyé simámékaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","kuyaná mimpóímá ontará'á ándánei anumarampimbá kwímarowana máyowasarai koawánésarai minándá koiyatúwóyana ");
INSERT INTO kze_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","minká'á máyón-kwaasi sésa nóra sékai mimpóígóná ándáma kwéiyatuwaaiyo suwasaráí ");
INSERT INTO kze_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ísumo sún-aimba simátímúyasa kanaán-ivo mirá okaiyó suwasaráí ");
INSERT INTO kze_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","áí'maesarai Ísunopa'a tuyasá kwená kwayó-kwáásí paákár-únánkwátói ayú'mái mimpóígó arósáánumpimba kwandaaí uwí'márówana Ísu ayáá'maena kwéguwasa ");
INSERT INTO kze_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","sáwíva-kwaasi mésa anón-kwaasiye sésa évakarawai paákár-únánkwátói ayú'mái évakarawai taayánáma ayáiresa aampa'á uwí'ma'mae kwéguwana minúnánkwátóirare mintááyánáravane augwétámai kwéguwasa ");
INSERT INTO kze_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","aiva'á nááún-kwaasiye Ísun-ánaaemba nááún-kwaasiye anónkar-anonka'a sésa Ísóigo ai'máráísana kunkáiwaimba Áánútu kawe'á kwéumankaiye. ");
INSERT INTO kze_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","kentáá síkwá'ná Tévítimo kawáá-uraintemba miráráámbá íníye. kwenáwí'a mósá kwémaraumne anónkar-anonka'a suwaná ");
INSERT INTO kze_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ísu Yérúsaremu-naopa'a kúmba anóm-bono'-naumpa'a uména amápa-tantaa'a awánéna enónka'a kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi tí'maena Pétáni-naopa'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pétáni-naopa'a kogwáúmba usá aaváyaavimba mindáópa'a tuwésa aampa'á kumbá Ísumba ááima ankówana ");
INSERT INTO kze_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","moórá-taigo áwí'a víkima kwáyowana mintáéramba nánáe séna ááimpa'a kwéna awánómba arambó iyáí-kánáámó ímo túmba íma iyéna ánáwe su'mai kwáyowana avakáá uwááena ");
INSERT INTO kze_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","mintáígóntávéna séna ená arambá íma iyáníyone. moórágwara'a kwaási ená arambá íma nánááowe súwasa kwená kwayó-kwáásí mináímbá ísaraawe. ");
INSERT INTO kze_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ísumo sún-aimba isésa Yérúsaremu-naopa'a kumbá Ísu anóm-bono'-naumpa'a iyéna mono'-náúmpá'ó meéyámbó kwémayon-kwaasi tuwánéna uti'mátuwena mono'-nánkóná óntambo meéyámbárón-kwaasiti taareimá tawísíyuwena Áánútuntavai imáyáa ésa máái-numama kwéamun-dumama meéyámbárón-kwaasiti taareimá tawísíyuwena ");
INSERT INTO kze_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","simátimena séna ókwara'a íma mono'-náúmpá'á mirán-tántáá'á maimaé'a iré kunke oro. ");
INSERT INTO kze_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Áánútun-aai aúváí-kwandaaivimba agaimaréna séna kesí naantaváí sésa Áánútumpa'o námúnaamo sen-dámbá isasá ó'on-o'om-barapaken-kwaasi tésa námúnaa kwésewe agaimaréna siráiye. ánivo umóyán-dáúmpá'ó ontenkáámbá uráawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ísu súwasa mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé Ísuna ámááyu-aimba kwésesa sáwíva-kwaasimo Ísun-aaimo ísámae kwéiyuntavai táátavai ésa Ísumba tuvuwónááon-amba kwéavakaa-uwasa ");
INSERT INTO kze_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","enónka'a Ísu kwená kwayó-kwáásíyé Yérúsaremu-naopa'a tuwésa kuráawe. ");
INSERT INTO kze_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ísu kwená kwayó-kwáásíyé kogwaésa usásinesa aampa'á kumbá víki-taima awánomba ánúka to'mai amápa'a móayankagurowana ");
INSERT INTO kze_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pítaa Ísumo sún-aimba ááka'a maréna séna awánaao. aaimó simámakaanda-taima á'a aáyánkagwiye súwana ");
INSERT INTO kze_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ísu séna Áánútunka'a aráápamai máéro. ");
INSERT INTO kze_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","árai'a simátime'a sé'a maanómátáváímo sé'o iré mapámbai nompá'á kumuwómó síyawai ímo kaer-ímáyáámó tokésamo súndantemba árai'a íníye síyanamo éna árai'a mirá íníye. ");
INSERT INTO kze_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","mindáyavai Áánútumpa'a námúnaa sé'a ó'on-o'on-tantaatavai áísaa e'a sembá árai'a Áánútu kanaán-umai súwa'naa umásinkaiye sembá kanaán-umai kwétuwa'naa-iye. ");
INSERT INTO kze_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Áánútumpa'a námúnaa sembá sáwí'o umátínkaraamba anondá sáwí'a ónaumne-imayaa íma é'a ivátuwaaro. mirámó íyanamo éna kentivo kwíyómpakewai keinárawa'a sáwí'o kwéomba maitiyuwáníye.  ");
INSERT INTO kze_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ánivo sáwí'o umátínkaraamba úwoimo imáyáamo úmae iyé'o ímo ivátuwaiyanamo éna kentivo kwíyómpakewai sáwí'o kwéomba íma maitiyuwáníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ísu kwená kwayó-kwáásíyé ókwara'a Yérúsaremu-naopa'a kumbá anóm-bono'-naumpa'a kwénaauwasa mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye ámáámba sun-kwáásíyé Ísunopa'a tésa ");
INSERT INTO kze_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","sésa nááwa ai'mákaisa tiréwa nááwampinkena mairéwa asirayám-báyáí kwémayaanda simásimiyo suwaná ");
INSERT INTO kze_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ísu séna aiva'á moórá-aimba tísaa ona'á anondámo síya'o é'a sísaa on-áímbá simátimenaumne. ");
INSERT INTO kze_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ááéma Yóni nombá pétinkaraiwaima Áánútuwa simámakaisana nombá pétinkarai. kwaásiya simámakaawana nombá pétinkaraiyo súwasa ");
INSERT INTO kze_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","miwímá keáímbá sésa nórayaawa sénaumno. Áánútu simámakaisana nombá pétinkaraiyemo senanayáámó éna nóra séra Yónin-aaiyavai íma áraire siráao síníye. ");
INSERT INTO kze_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","kwaási simámakaawana nombá pétinkaraiyemo senasayáámó ésa úwoi-kwaasi sínkamonaaowe. úwoi-kwaasi sáwíva-kwaasi Yónintavai sésa Áánútun-aai simásimakaiwai uráiye kwésemba pósa áwáá'a siyénááowe mirá keáímbá sésa ");
INSERT INTO kze_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ísuntavesa sésa emó sísaa ónda-ainta íma ísaraumne suwaná Ísu séna ímo simásimiya'a nááwampinkena mairéra'i. asirayám-báyáí kwémayaunda-aimba íma simátimenaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ísu kwántámai-aimba simátimena séna moóráwai óntan-kurima úmakena ándá-aran-kigau úmarena ándá-arankona tááve'a úmarena ándá-arambo mapándáápá ínana anombó kumínín-taave'a úmarena óntan-damba kígauva'o taviyí-námbá úmarena ayáátááka'a ó'om-barava'a koménae séna maankígáúrá'ó taviyíyawaimo é'a kesáváí évakar-aramba maé'a évaka'a kembá siyúwáaro simátimena ó'om-bapa'a komáyáísana ");
INSERT INTO kze_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","arambó ávumo kain-kánáá tisaná aanávómá kesí ándá-aramba komayaaó séna kwená kwayó'ná'á ai'máráísana minkígáúrá'ó tavíyéwaitopa'a tisasá ");
INSERT INTO kze_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","táto'mai tuvú'maresa ándá-aramba íma ámémba ai'mátuwaawana kówisana ");
INSERT INTO kze_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","aanávómá moóráwaimba ai'máráísana tisasá minkígáúrá'ó tavíyéwai táto'mai a'nómbá tuvámbai sáwí'a umánkówana kówisana ");
INSERT INTO kze_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","aanávómá moóráwaimba ai'máráísana tisasá táto'mai tuvú'márááwana púwísana aanávómá moórá-mora-umai ti'máráintemba tewasá tínkamba tinkamba kwéowasa évaka'a púwówasa évaka'a tayauwéráawana ");
INSERT INTO kze_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","aanávómá kímborawai kwenááninkomba póna kwená imáyáama ámakaiwaima máyáimba ayáátááka'a imáyáa eémena kesááninkon-aai isánááowe séna ai'máráísana ");
INSERT INTO kze_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","tisasá minkígáúrá'ó tavíyéwai awánésa keáímbá sésa aanávómbá ááninko kwétimba póta tuvúwónana puwéna maankígáú íma mayáínata kesáá mayánáe sésa ");
INSERT INTO kze_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","táto'mai tuvúwówana púwísasa maimái aaumépa'a tukáawe. ");
INSERT INTO kze_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ísu mináímbá simásuwena séna minkígáúgó aanávómá mirá íníye. téna kígaura'o tavíyéwaima tínkaminasa puwíyana ó'onkaa-kwaasi kesí kígaura'a tavíyéro síníye. ");
INSERT INTO kze_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Áánútun-aai aúváívimba awánaraawe. maarán-áímbá agaimaréna séna óntan-damba on-kwáásí moórá-ontantavesa sáwí'a kwéiye sésa maisukáawe. aáno minóntánkó ávonkaamba uráiye. ");
INSERT INTO kze_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","mindá Ísóigo isatá awánéta séta ó'oran-kawe'a uráiye kwésune agaimaréna siráiye Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","mono-káwáá-kwáásí mináímbá isésa kentááyáváíyá siyé sésa táto'mai tuvuwónáe sésa umbá amápa-kwaasiyavai táá'a kówasa ivátuwesa kuráawe. ");
INSERT INTO kze_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","mono-káwáá-kwáásí kwésa Ísumba áísaa íyana sáwí-aimbo sínasa aaivimbá mayankánááontavai ámáán-kawaa-kwaasivinkemba évakarawaiye Éróti amááraawivinkemba évakarawaiye ti'márówasa ");
INSERT INTO kze_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ísunopa'a tésa sésa anóndakoo árai-kwaasi po kwaási táároi íma inkaisé anón-kwaasiye úwoi-kwaasiye táároi íma inkaisé tirumbá airá'mái-aimba íma séma Áánútuna aambó kwáráan-aimba arupí umái kwésimatimendaya ísaraumne. emá nóra se kwéisaano. kanaarátááwá táákísi-ontamba Árómáani-kamaani-kwaasiya timénaum. íya timénaumno. timénaundaya Yútaa-kwaasiya kentáásí ámáána araaisénaundaya'iyompo ");
INSERT INTO kze_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","timénaum. íya timénaumno suwaná Ísu miwí tááma iséna kaumbo-káér-ainkwara-kwaasin-owe séna kentáváí sáwí-aimbo síndawe sé'a kwésisaa-owe. moórá-ontamba maimái máagaraasinkaaro súwasa ");
INSERT INTO kze_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","maimái máagaraarankowana séna nááwa óikaana uráinkara áwí'a kwáyáiyo súwasa miwí sésa Árómáani-kamaani-kawaanako óikaamba isaná áwí'a kwáyáiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ísu séna Árómáani-kamaani-kawaanakondei kwembá áméro. Áánútundei Áánútumba áméro súwasa mináímbá ísówana táá'a kówasa íma aaí siráawe. ");
INSERT INTO kze_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","suwasá Sátúsi-monor-aimbo sun-kwáásí púwómpinkemba íma usásinanaaowe kwésun-kwaasi pósa Ísunopa'a tésa sésa ");
INSERT INTO kze_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","anóndakoo naaóvá'á Mósesi séna moóráwai aaraí maimakéna iyámpói íma ankéna púwísana ávákoma maimakéna awaaóná anondáwe séna iyámpói ankáníye siráiye. ");
INSERT INTO kze_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","moórá-aimba isaaó. moórá-tawai avakaeté-avarawainonda mésa tuwaaómá aaraí maimakéna iyámpói íma ankéna púwísana ");
INSERT INTO kze_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","kwenánaaenkewai kware'á maimakéna iyámpói íma ankéna púwísana kwenánaaenkewai kware'á maimakéna iyámpói íma ankéna púwísana mirá eémesa ");
INSERT INTO kze_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","avakaeté-kwaasi putásaawana minínímbá naaémba pukáiye simásuwesa ");
INSERT INTO kze_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ísumba áísaa esa sésa mirámó ombá kwaásimo puwíyampinkembo usásinaiya-tawai minínímbá avakaeté-kwaasi tuwainímbá póna nááwa mayáníyo suwaná ");
INSERT INTO kze_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ísu séna Áánútun-aai aúváívimba agaimakón-aimba íma kawe'á umái isé'a Áánútuna asirayámbá íma awáné'a pó'a miráumai sáwísawaa-aimba kwésewe. ");
INSERT INTO kze_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","pukémpinkemba usásinesa kwíyómpa'a uménaaon-kanaa aaraí íma mayáíyasa kwaaí íma mayáíyasa ésa Áánútuna kwayó'nárawa'o kwíyómpa'o máéwaimo ontembá minínínákwá'á miráumai aaraí íma mayáíyasa kwaaí íma mayáíyasa ónááowe. ");
INSERT INTO kze_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","kwaási pukémpinkemba usásinaaomba Mósesi mináíntáváí agaimakáiye. aúváívimba agaimaréna séna áru-taira'a iramá kaimbá íma mintáímá kágwisana mintáívínkémbá Áánútu Mósesintavena séna Áánútu úne. enaíkwá'ná Ááváramune Áísákaane Yákópone miwítí Áánútu úne siráiye. Áánútu mináímbá siráimba minkáúmbó-kwáásí á'a púwúwasa utamántínkaraambanivo ");
INSERT INTO kze_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","mináímbá siráimba pósa miwí úwoi máyáawe. ánivo kentááima sáwísawaa-aimba siráawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","súwana ámáámba sún-kwaasigo ména amápa-kwaasimo sumbá iséna Ísuna usáyaaitamai-kwasai iséna Ísumba áísaa ena séna Áánútuna ámáámpinkemba nóran-amaana aivar-ámáámbán-iyo súwana ");
INSERT INTO kze_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ísu séna aivar-ámáámbá sénaumpo Áánútun-aai aúváívimba agaimaréna séna Ísareri-kwaasi maísáaro. Áánútu kentáásí Ísóigo éna mimbórá-Ísóígómán-iye. ");
INSERT INTO kze_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Áánútumpa'a kentí Ísóigomba kentiruné kentí imáyáawe kentimané kentí asirayáné áméro agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","miwá ánaaenken-amaamba sénaumpo ísáaro. Áánútun-aai aúváívimba agaimaréna séna kesáváí-ímáyáámó ontembá kentí kwaásiti imáyáagwara'a oró agaimaréna siráiye. minkáér-ámáánkómá amápar-amaamba usáyaaitaraiye Ísu simámuwana ");
INSERT INTO kze_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","minkwáásígó séna anóndakoo árai'a sénda Áánútu kweyáá Ísóigoman-ivo ó'on-o'on-isoima íma máyáawe. ");
INSERT INTO kze_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","kesáámá Áánútumpa'a kesirumbá imáyáama kesí asirayámbá kwempá'á tuwéta mirá onó. kesáváí-ímáyáámó úndantenta kesí kwaásiti imáyáagwara'a onó. minkáér-ámáánkómá amápar-amaamba usáyaaitaraiye. toómbá sipisípima iravímbá agaimái Áánútumba amúndanivo mindágwara'a usáyaaitaraiye séna ");
INSERT INTO kze_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","mindá'ó súmba kawer-ímáyáávínkémbá súwana póna Ísu iséna séna Áánútumo kawááimba kwená egwaa'á máyáane súwasa ísómba Ísun-aaiyavai táá'a kóntavai íma áísaa úmaesa iráawe. ");
INSERT INTO kze_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","íma áísaa úmaesa íyúwana Ísu anóm-bono'-naumpa'a uména kwésimatimena séna ámáámbo sen-kwáásí sésa Káráísitima Tévíti-andaraken-kwaasiman-iye kwésevo ");
INSERT INTO kze_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","naaóvá'á Áánútun-amanko Tévítimba imáyáa amúwana Tévíti Káráísintavai séna kesí Ísóigoman-iye siráimba monor-ímá agaimakón-auvaivimba Tévíti agaimaréna séna kesí Ísóigontavena Áánútu séna kesiyáánúrapa'a asirayán-áyámpá'á mara'á ména'a ená namuro-kwáásí usáyaaitaanasa miwí ánásanaaowe Áánútumo siráin-aimba Tévíti siráiye. ");
INSERT INTO kze_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","miráumai Tévíti Káráísitintavai séna kesí Ísóigoman-iye siráimbanivo nóraumaiya kwemá Tévítin-andaraken-kwaasiman-iye Ísu súmba Káráísiti Tévítina Ísóigoma éna Tévítin-andaraken-kwaasigoman-iye. úwoi-kwaasi amápa'a Ísun-aai isésa aamoí uráawe. ");
INSERT INTO kze_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","úwoi-kwaasi amápa'a Ísun-aai isésa aamoí kwéuwana Ísu kwésimatimena séna évaka'o ámáámbo sen-kwáásítí aambá kwáráavo. minkwáásí ayáátáár-ampantama iyésa naaópa'a avuvumpa'á kwénaauwasa pósa kwaási tuwánésa sésa anón-kwaasin-owe kwésewe. ");
INSERT INTO kze_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","minkwáásí mono'-náúmpá'ó umáyáapa'o anón-kwaasimo maí-áyámpá'á umésa tanómbo kaúvópa'o máyáapa'a kawer-áyámpá'á mésa kawe-tómbá kwénaawe. ");
INSERT INTO kze_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","minkwáásí ketor-íníntí óísankwara naankwará'á umóyámbá kwémaesa kwaási suwánésa súwí'a mósá maráígwáe sésa kampakómbá tavisimái-namunaa kwésewe. mirámó owáíná anondá umbai-yántáá'á mayánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","simásuwena Ísu anóm-bono'-naumpa'a ména óntambo túwón-anaveunkona egwaa'á ména tuwánómba kwaásiyomba tésa óntamba túwómba sáwívar-oisankwara-kwaasi sáwívar-ontamba túwówana ");
INSERT INTO kze_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","moórá-ketor-ininko íma óísamba makón-ininko téna sáwíyan-ontamba kae-tóyáráámbá tuwówana ");
INSERT INTO kze_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ísu kwená kwayó-kwáásí tááyena séna árai'a simátime'a sé'a minkétór-ínínkómó túwáin-ontankoma amápa-kwaasimo tukáan-ontamba usáyaaitaiye. ");
INSERT INTO kze_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","miwímá sáwívar-oisampinkemba évaka'a tukáavo kwemá sáwíyan-oisampinkemba mútú'a túwáimba póna óísan-iyaaimba méniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ísu mináímbá simásuwowasaya anóm-bono'-naumpakemba kárúwesa kúmúmba kwená kwayó-kwáásívínkémbá moóráwai anóm-bono'-nantavai séna úwé awánaao. maanóntán-dámbá kawe'á kwáyáísana minóntámbá anón-ontamba kwáyáiye súwana ");
INSERT INTO kze_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ísu séna maanánón-dámbá awánaaro. aáno kwaási tésa mindámbá amápa'a tawísíyuwesa amápar-ontankwara'a tawísíyuwanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ísu mináímbá simásuwena Óríve-omaka'a uména anóm-bono'-namba awánómba Pítaawe Yémésiye Yóniye Éndaruwe kíraumai-kwaasi Ísumo kweyáá máyonka'a tésa áísaa esa sésa ");
INSERT INTO kze_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","emó sénda nósa-tawaiya tíníyo. nóran-awaamera ínata séta ákíra'a Ísumo simbá mirá íníyeya sénaumno suwaná ");
INSERT INTO kze_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ísu séna kampar-áímbá isé'a áraire sevó kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","sáwíva-kwaasi tóyo ésa kesúwí'a mágwétesa sésa Áánútumo usásisinkaiwai úne síyasa sáwívarawai minkámpár-áíntáváí áraire sénááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","áái'o tíyáán-aimba némpakena'i. egwaakéná'i. isáíyana íma táá'a kaíno. mirán-kánáámó tínda mindá íma amápa-tantaa'a ánásai-awaame'an-iye. ");
INSERT INTO kze_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","moórá-ayampa-kwaasimo ésa ó'on-ayampa-kwaasiye áái'a tiyánááowe. moórá-kawaa-kwaasigomo éna moórá-kawaa-kwaasigona amááraayavai usásimbai áái'a tíyáaro sínasa usásinesa áái'a tiyánááowe. ó'on-o'om-barava'a anóm-barima táníye. ó'on-o'om-barava'a ayawaimá táníye. mirán-tántáá'ó paárína'a sé'a amápa-tantaa'o ánásanin-kanaa íma tiráivo iyámpóímo tinkánáe owanamó anón-ti'o intembá umbai-kánáámó tínímba miráumai ááimba ásáiye seró. ");
INSERT INTO kze_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","mirán-áíntáváí kárákwiyoro. mono-káwáá-kwáásí keinárawa'a tí'maesa anón-kwaasitopa'a mótinkesa aaivimbá maitinkésa mono'-náúmpá'á mótinkesa tínkamesa kentáváímó asiramáímo máyáantavai táto'mai tí'maesa kámááni-anon-kwaasitopare kawááon-kwaasitopare mótinkesa aaí simátinkaiya'a minánón-kwáásí kesáái simátimenaaowe. ");
INSERT INTO kze_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","aiva'á áséi-kwasai amápa'-maravaken-kwaasi simáti simati kwéiyana naaémba amápa-tantaa'a ánásai-kanaama tíníye. ");
INSERT INTO kze_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","táto'mai aaimó simátínkénka'a nóran-aina sénaumno-imayaa íma anómba é'a íma kentí imáyáavinken-aimba sénááovo Áánútun-amanko sénááon-aimba úwoi tááka tinkáína'a mináímbá sénááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","évakarawai tívá'awaawi tí'mai ó'owira'a timíyasa tínkamiyasa puwónááowe. tivoísáímo ésa tíráámaa'a tí'mai ó'owira'a timíyasa tínkamiyasa puwónááowe. iyámpóíyombo ésa tinóvowima tí'mai ó'owira'a timíyasa tínkamiyasa puwónááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","kentáváímó asiramáímo máyáantavai amáparawai tíyámba umátinkanaaowe. ímo ivátuwesamo kentáváímó asiramáímo méwai ánásai-kanaara'a Áánútu tí'mai kawepá'á métinkaniye. ");
INSERT INTO kze_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ísu mináímbá simásuwena séna naaémba ávááraumai inkaisí-yántáákómá uwóví'a ií-márúká'á paáriniye Ísu siráiye. kemá Mááka sé'a maanáúváímó torausíyawai tááko pééi sína'a ísáaro kwésune. Ísu séna uwóví'a ií-márúká'á paárínasa awánanaaomba Yútiyaa-marava'o máyaiyan-kwaasi omápata isaaisésa iyónááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ontará'ó máyaiyan-kwaasi íma naaúmpa'a iyíyamba óísamba ivátuwesa úwoi isaaisésa iyónááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","kígauva'o máyaiyan-kwaasi íma naaópa'a iyíyamba unáánkwátói ivátuwesa úwoi isaaisésa iyónááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","tímúkwarar-inimba ívér-iyampoigwarar-inimba minkánáámá sáwí'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","isaaisé'o iyónááomba táúgwi-kanaa iyé'a únavo sé'a Áánútumpa'a námúnaa seró. ");
INSERT INTO kze_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","minkánáámá tínímba anón-umbai táníye. naaóvá'á Áánútu maramá tarórumba ívéka to'mái mirán-úmbáí-yántáá'á íma tiráiye. aánogwara'a mirán-úmbáí-yántáá'á íma tíníye. ");
INSERT INTO kze_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","mirán-úmbáí-yántáá'ó kwénin-kanaa Ísóigo ákíse úmakaiye. mirán-úmbáí-yántáá'ó kwénin-kanaamo ayáátááka'o kwéininkakai amápa-kwaasi íma úwoi túvamai máésino. Áánútu ítámakain-kwaasiyavai imáyáa éna mirá-úmbáí-yántáá'á ákíse uráiye. ");
INSERT INTO kze_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ákísemo ínasa évakarawaimo simátimesamo sésamo Áánútumo usásinankaiwai mivá'-maava'a máyáiye síya'o é'a íma ísáaro. ");
INSERT INTO kze_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","évakarawai paárésa kampa'á sésa Áánútumo usásisinkaiwai úne síyasa évakarawai kampa'á sésa Áánútun-aai simátimundawai úne simátíma'maesa naaónááomba ímo awánem-bayai kwémaesa Áánútumo ítámakain-kwaasi kampa'á simátiyuwanae sésa mirán-ánóm-báyáí mayánááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","miwíyáváí árai-kwaasin-owe sevó sé'a íma paáruraanka'a aiva'á simátimumpo kárákwiyoro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ísu mináímbá simásuwena séna mirán-úmbáí-yántáá'á tínín-kanaama ánásainana aaváúmá túnkwinana kwíyómba íma sán-káínana ");
INSERT INTO kze_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","o'á kwíyómpakemba kuntínana kwíyónko tora'naára'a ínasa ");
INSERT INTO kze_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","kemá kwaási úrandako anón-asirayankwara ságayankwara'a ainámpímbá kúmóna'a suwánanaaowe. ");
INSERT INTO kze_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","kwíyómpaken-kwayo'narawa'a ti'máráanasa Áánútumo ítámakain-kwaasi amápa'-maravakemba tí'maesa moórávimba torupanááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ísu mináímbá simásuwena séna moórá-tai naí-táígó áwí'a víki-taigontavai imáyáa umái ísáaro. aráságáyómó agayáínda awáné'a sé'a áú'o sínín-kanaa sáwíyanka'a tíníye sénááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","mirámó intembá kemá súnda-yantaa'a ína'a awáné'a sé'a sáwíyanka'a kumíníye sénááowe. ");
INSERT INTO kze_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","árai'a simátime'a sé'a ívé'o máyáan-kwaasi évaka'a íma pukáiyanka'a kemó súnda-yantaa'a paáriniye. ");
INSERT INTO kze_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","kwíyómba maramá ánásainana kesáái íma ánásena úwoi kwaíkwai'a íníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ísu mináímbá simásuwena séna kúmónda-kanaama aaváúvímbá kwaási íma isááwasa kwíyómpaken-kwayo'narawa'a íma isááwa'a kemá Áánútu ááninkoma íma isáúnana kesivo kweyáá ísaraiye. ");
INSERT INTO kze_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","kemó kumónaunda-kanaa íma ísaraiyanka'a kumónaumpo kárákwimai máéro. ");
INSERT INTO kze_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","mirámó íníntenkaan-umai maarán-áímbán-iye. moórá-anondako némpa'a kwááyu koménae séna éna kwená mayáí-kwáásíyávéna mayáí máyáaro séna ti'má'mai kwégwena ontará'ó kawááiwaintavena séna taviyiyó séna kóuraiye. ");
INSERT INTO kze_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","naankóná aanávómó tínímbo ímo ísaraantemba ké'naamba kemá kúmónda-kanaama íma ísaraavo kárákwimai máéro. enáíndarara'i. no'wáámpina'i. iratarórá'i. kwáyá'wáiya'i. kumónaumno minkánáá íma ísaraavo ");
INSERT INTO kze_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","kentáváí íma imáyáa kwéiyanka'a kumúnavainivo kwéto'mayaa-e'a simu'maré'a máéro. ");
INSERT INTO kze_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","kemó simátimunda amápa-kwaasiyave'a súmpo taviyé'a máéro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ísu mináímbá simátimuwana naaóvá'ó Áánútu Yútaa-kwaasi tíyótaasa í-tánómbá ímo intóráin-tantaakwara-pereti kwéagayon-kanaama ayúnkaraamba kauvónaumpo sésa kae-táwaima úwoi mésa mono-káwáá-kwáásíyé ámáámba sun-kwááíyé sésa nóraumaiya Ísumba aúpá'á táto'mai inkamónaundaya'iyo. ");
INSERT INTO kze_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","amápa-kwaasi áái'a tíyáávainivo tanómbo kauvíyan-kanaara'a íma tuvuwónaumne siráawe. ");
INSERT INTO kze_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","suwaná Ísu Pétáni-naopa'a koména moóráwai áwí'a Sáímonina naaúmpa'a áúma kárúkokovaa'a uréna ánásarowaina naaúmpa'a ména toómbá kwénowana moórá-ininko iyéna áséi-kwiyumba úm-basawemba anón-ontankakemba meéyámbakaim-basawemba maimaéna iyúmba minánávéúnkó ói'a móankaisuwena Ísu a'nómpímbá atímarowasa ");
INSERT INTO kze_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","évakarawai keáímbá sésa áwáá'a aéésa nóra séna mimbásáwémbá úwoi atíyankaiyo. ");
INSERT INTO kze_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","mimbásáwémbó ó'owimo timénamo anón-ontambo mairénamo ímo óísambo makáan-kwaasi tíméraambaniye sésa minínínkómbá áwáá'a áúwana ");
INSERT INTO kze_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ísu séna ivátuwe'a íma áwáá'a aééro. kawe'á umái pésinkaiye. ");
INSERT INTO kze_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ímo óísambo máráan-kwaasi keséma maí'mai'a kwéiya'a túwa'naa ónáe sé'a túwa'naa ónááombanivo kemá keséma marapá'á íma maí'mai'a ónaumne. ");
INSERT INTO kze_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","minínínkómá kwená imáyáavinkemba kawe'á umái pésinkaiye. púwóndara'a masawémba pésinkesa utamásinkanaaovo minínínkó á'a masawémba pésinkaiye. ");
INSERT INTO kze_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","árai'a súmpo maísááro. kesí áséi-aimba amápa'-mapa'a kwésimatimewasa minínínkómá umásinkain-aimba kwésimatimiyasa tááka'a maránááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","súwana Ísuna kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasivinkemba moóráwai áwí'a Yútási moórá-awi'a Isakéríóti mono-káwáá-kwáásítópa'a kwéna séna túwa'naa ona'á Ísumba tátoranaaowe súwasa ");
INSERT INTO kze_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","isésa aamoí kwéesa sésa mirámó inda-méyámbá óntanta aménaumne suwaná nóraumai Ísumba agaráátínkáanasa tátoranaao-imayaa ááimba ásámai uráiye. ");
INSERT INTO kze_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yútaa-kwaasi ímo intóráin-tantaakwara-pereti kwéagayon-kanaa túntemba tíyótaasa í-tánón-kánáá sipisípi-araa'a tuvú'mái kwégauvunka'a kwená kwayó-kwáásí Ísumba taáísaa esa sésa náávara tíyótaasa í-tánómbá kogauvónaundaya'iyo suwaná ");
INSERT INTO kze_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","kae'á ti'maréna séna Yérúsaremu-naopa'a kwíyana moóráwaimo nonánámó maimaénamo kwíndawaimba kóánaaemba kwáráakaiyo. ");
INSERT INTO kze_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kwemó naaúmpa'o iyínanamo naankó avowámó máyáinakai kosimámekai anóndakoma áísaa ena séna kesí kwayó-kwáásíyé náán-ayampara tíyótaasa í-tánómbá nánaumno kwésiye kosimámékaiyo. ");
INSERT INTO kze_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","kwemá avóvomayaa'-nankomba anón-ayampa'a agaráátinkaniye. kísuvu'o umándanaaon-tantaa'a mimpímbá kwáyáiye. amápa-tantaa'a arúsámarekai minká'á kausínkáakaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","mindárai isésarai Yérúsaremu-naopa'a kwésarai Ísumo sún-tantaa'a kwáyowasarai minká'á tanómba mágauwankaraaiye. ");
INSERT INTO kze_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","tanómba mágaumakoyasa enónka'a Ísu kwená kwayó-kwáásíyé mindáúmpá'á umésa ");
INSERT INTO kze_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","toómbá kwémandesa uwaná Ísu séna keinárawapinkemba moóráwai keséya toómbá kwénaiwaima kembá namuro-kwáásírá'á agaráátinkaniye súwana ");
INSERT INTO kze_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tirunkó umbaí tówasa moórá-mora-umai áísaa esa sésa kewá'iyo sinté kuwaná ");
INSERT INTO kze_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ísu séna moóráwai kwená toón-ayai maimaéna kesé moórá-taavepimba tu'mái náíndawai kwemá kembó namuro-kwáásírá'ó agaráátinkaniwaiman-iye. ");
INSERT INTO kze_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","naaóvá'á Áánútun-aai aúváívimba agaimaréna séna kwaási úrandako kumpaáríndawai puwíníye siráintemba pó'a púwónana namuro-kwáásírá'ó agaráátinkaniwai sáwí-meyamba mayáníye. kwembó ímo maránkaraankakaankasi kawe'á isinó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","súwasa toómbá kwénowana Ísu péréti maisoréna Áánútumpa'a súwi séna topámbai tímatuwena séna mindá kesúman-ivo maimái naaró séna ");
INSERT INTO kze_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ándá-aran-dombo kwáyon-anaveumba maisoréna Áánútumpa'a súwi séna timúwasa amáparawai nowaná séna mindá kesí naaemán-iye. ");
INSERT INTO kze_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","kesí naaemá sáwívarawaiyavai kumínímba póna Áánútu kesé tarúmai máyáawe séna mináúná-áímbá simái tarúmakaiye. ");
INSERT INTO kze_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","simátime'a sé'a ókwara'a ándá-aran-domba íma nánaumpo Áánútu kwená kwaási kwégawaaipa'a mé'a ándá-aran-domba aúná-nomba nánaumne Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Áánútuntavai ísámai monor-ímá simásuwesa mindáúmpá'á tuwésa Óríve-omapa'a iráawe. ");
INSERT INTO kze_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Óríve-omapa'a umáyówana Ísu simátimena séna Áánútun-aai aúváívimba agaimaréna séna Áánútu séna sipisípira'o kawááiwaimba tuvúwónana puwínasa sipisípiyomba kóyáwé ónááowe Áánútu siráiye siráimba póna táá'a káína'a siyuwé'a kóyáwé ónááowe. ");
INSERT INTO kze_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ánivo púwónasa utamásinkaiya'a usásine'a kentí aiva'á Káríri-ayamapa'a kona'á kesínaaemba kónááowe Ísu súwana ");
INSERT INTO kze_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pítaa séna amáparawai auwésa kóyáwé íyambanivo kemá íma mirá ónaumne súwana ");
INSERT INTO kze_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ísu séna árai'a simáme'a sé'a ívé'-no'waamba kokórigo íma kaeká'á áái siráindara'a emá kaumborá'á kentáváí se íma awánáúnda-kwaasiye síníyone Ísu Pítaantavai súwana ");
INSERT INTO kze_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pítaa asiramái séna entémo sínkamonae íya'o é'a íma auwé'a kónaumne súwasa kwená kwayó-kwáásí amápa'a mirá simásaraawe. ");
INSERT INTO kze_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","amápa'a mirá simásuwesa Ísuwe kwená kwayó-kwáásíyé taai-kanáágúnéyómbá áwí'a Kétésémaniva'a komésa Ísu simátimena séna maanká'á máyaiya'a Áánútumpa'a námúnaa kosénaumne séna ");
INSERT INTO kze_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pítaawe Yémésiye Yóniye tí'maena komáyowana umbai-yántáákómá arumbá sáwí'a kwéuwana ");
INSERT INTO kze_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","simátimena séna kesirunkómá umbaiyé taisa'á pó'a puwóra'naraamba umái máyaumne. maanká'á mé'a kárákwimai máéro séna ");
INSERT INTO kze_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","tiyuwéna egwaa'á kwéna Áánútu anónda'an-iye séna mara'á kumbaéna námúnaavinkemba séna kesivoó amápa-tantaa'a kanaán-umai kwéonda po kanaán-iye sémo e maanúmbáí-yántáá'ó kesópa'o tínímba maisiyuwéma ánivo kesí imáyáa íma kwaréna'a ená imáyáa kwáráano Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ísu námúnaa simásuwena kwená kwayó-kwáásíráútópa'a téna tayuwánómba tuún-kwaigurówana tayúsena Pítaantavena séna Sáímoniyo aún-kwaiguréma íma kanaará'á sáwíyanka'a kárákwimai máyáane. ");
INSERT INTO kze_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sáátáánigo tísaa umai isánáe-aimba kentópa'a síyáváínivo Áánútumpa'a námúnaa seró. imáyáago kató isaná áúgomo umbaimó taimbá mindá aúgávaa'a kwéiye simásuwena ");
INSERT INTO kze_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","moórágwara'a tiyuwéna egwaa'á kwéna ké'naamba Áánútumpa'a námúnaa kosimásuwena ");
INSERT INTO kze_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","kwená kwayó-kwáásítópa'a téna tayuwánómba tuún-kwaigurésa túgávaate kwéuwasa nóran-aina'i. anondá íma simámuwana ");
INSERT INTO kze_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","tiyuwéna ké'naamba námúnaa kosimásuwena koyauweréna minkáúmbónárauyavai séna tuúmó kwaiguré'o máyáamba á'anivo kemá kwaási úrandakomba sáwí'o kwéon-kwaasira'a agaráátinkainasa tátoranaaon-kanaa kwétivo ");
INSERT INTO kze_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","usásinewata kwétiyapata konó. kembó agaráátinkaniwai kwétiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ísu mináímbá kwésuwana kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasivinkemba moóráwai áwí'a Yútási túmba kwesé sáwíva-kwaasi taánasatagwara ánáyatankwara'a maimaésa tumbá mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé Yútaa-anon-kwaasiye miwímá ti'márówasa tumbá ");
INSERT INTO kze_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ááéma Yútási Ísumbo agaráátinkanintavai simátimena séna paruvará umánkáandawaimba táto'mai áí'mae'a taví'mae'a koró siráimba ");
INSERT INTO kze_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","póna Yútási Ísunopa'a téna séna anóndakoo máyaano kwésena paruvará kwéumankowasa ");
INSERT INTO kze_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","kwesé tuwáí Ísumba tátórówana ");
INSERT INTO kze_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ísuna kwayó-kwáásívínkémbá moóráwai taánasatama maimaéna aiva'-mónó-káwáánákóná kwayó-kwáásígó áá'a agáúsuwowana ");
INSERT INTO kze_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","tun-kwáásíyávéna séna kentáváí umóyán-kwáásímán-iye sé'a pó'a taánasatagwara ánáyatankwara'a maimaé'a kembá tátoranae sé'a kwétewe. ");
INSERT INTO kze_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","sáwíva-tawai anóm-bono'-naumpa'a kesé mé'a kesáái kwésimatimundara'a íma kembá tátokaawe. naaóvá'á Áánútun-aai aúváívimba agaimakáan-aimba kembó mirámó umásínkéne'a kwétewe súwasa ");
INSERT INTO kze_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","kwená kwayó-kwáásí amápa'a inkaisésa auwésa kóyáwé uwasá tun-kwáásí Ísumba áí'maesa kwéguwana ");
INSERT INTO kze_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","moórá ívé-kwaasigo ampaantawé su'mai úsúrena Ísun-ánaaemba kwéguwasa tátorankowana ");
INSERT INTO kze_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ampaantamá kwatuwéna kwátóiyaaimba kuráiye. ");
INSERT INTO kze_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","kúwasa Ísumba tátorowai áí'maesa aiva'-mónó-káwáánákóná naaúmpa'a móankesa mindáúmpá'á mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye ámáámba sun-kwáásíyé torupamái máyón-daumpa'a móankowana ");
INSERT INTO kze_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pítaa tínaaemba nénka'a teémáyomba aiva'-mónó-káwáánákóná máápar-ontavinkemba iréna naamaúva'a ména i-kwáásíyé irará'á koména irá kwégauviye. ");
INSERT INTO kze_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pítaa irá kwégauvuwasa mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye amáparawai Ísumba tuvuwíyana puwíní-ainkona ááimba avakáá-uwana íma kwáyowasa ");
INSERT INTO kze_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ísuntavesa mósi-mesi-aimba sésa íma moórá-aimba suwasá ");
INSERT INTO kze_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","évakarawai usásinesa kampa'á sésa ");
INSERT INTO kze_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","kwemó sisatáámó isáúndaya anóm-bono'-namba kwaási uráan-damba tawísíyuwe'a kaumbo-táwai kwaisuwé'a kwaásimo ímo íyan-damba ónaumne siráiye suwasá ");
INSERT INTO kze_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","minkwáásí íma moórá-aimba suwaná ");
INSERT INTO kze_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","aiva'-mónó-káwáánákó usásinena Ísumba áísaa ena séna simánkáan-aimba anondá íya síníyono súwana ");
INSERT INTO kze_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ísu iséna íma aaí súwana aiva'-mónó-káwáánákó áísaa ena séna kesáámó áwí'o mósá maráúndawai ááninko e Áánútumo usásinankaiwai Káráísitiya'ona simásimiyo súwana ");
INSERT INTO kze_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ísu séna kemá úne. suwánáína'a kemá kwaási úrandako Áánútu asirayáwáímá ayáánúrapa'a asirayán-áyámpá'á umé'a ainámpímbá kumónaumne Ísu súwana ");
INSERT INTO kze_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","aiva'-mónó-káwáánákó arumbá sáwí'a kwéuwana kwená unáánkwátói tarátuwena séna Áánútumba aká'áámba simánkena kwesáváí simbá póta mináíntáváí aaivimbá mayankéta ó'on-aimbo simánkáamba avakáá únda póta ivátá tuwéta ");
INSERT INTO kze_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Áánútumbo simáímo sáwí'o umánkáintavaiya nóraya ónaumno súwasa sáwí'an-ivo tuvuwíyana puwíno sésa ");
INSERT INTO kze_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ísumba tuwirááíma kwirankésa aúrampa'a ampantanéí káátamakesa kwétuvuwesa sésa esáváí se Áánútu usásisinkaiwai úne séndawai ómpo kemá nááwa kwétuvuwuna simásimiyo kwésuwasa i-kwáásí áí'mai tiyáándei tuvúkáawe. ");
INSERT INTO kze_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pítaa naamaúva'a ména irará'á kwégauvuwana aiva'-mónó-káwáánákóná kwayór-árásígó téna Pítaamba takarákéna séna Ísu Násáretivakewaise maéndawai óne súwana ");
INSERT INTO kze_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","emó sénda-aimba sáákoma íma kawe'án-iye simásuwena máápar-ontavimba komáyowana ");
INSERT INTO kze_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","minárásígó moórágwara'a awánéna máyón-kwaasiyavena séna evíwána kwaásivinkenda'an-iye súwana ");
INSERT INTO kze_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","moórágwara'a Pítaa séna ímaniye simásuwena máyowasa sáwíyanka'a máyómba Pítaantavesa sésa áraita súne. Kárírivakenda'a po kwená kwayó-kwáásívínkéndá'á óne suwaná ");
INSERT INTO kze_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pítaa aika'á maréna séna kampar-áímbó kwésenanamo éna Áánútu sínkaminiye. síyawaimba íma awánáúndana'an-iye kwésuwana ");
INSERT INTO kze_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","kokórigoma moórágwara'a áái súwana Pítaa Ísumo simámun-aimba ááka'a maréna mirá siráinka'a kokórigomo kaeká'ó ááimo ímo siráindara'a emá kaumborá'á kentáváí se íma awánáúnda-kwaasiman-iye síníyone siráimba mináímbá ááka'a maréna ávááraumai ivi'á taráiye. ");
INSERT INTO kze_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ivi'á tówasa aaváúmá usónka'a mono-káwáá-kwáásíyé Yútaa-anon-kwaasiye ámáámba sun-kwáásíyé mimbórá-áímbá símaresa Ísumba ayáánka'a asááúmaresa áí'maesa Árómáani-kamaani-kawaanako áwí'a Páírátinopa'a máánkarowana ");
INSERT INTO kze_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Páíráti Ísumba áísaa ena séna Yútaa-kwaasiti kawáánárá oónó súwana Ísu séna á'a séne súwasa ");
INSERT INTO kze_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","mono-káwáá-kwáásí ó'on-o'on-aintavai aaivimbá mayánkówana ");
INSERT INTO kze_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Páíráti Ísumba áísaa ena séna sáwívar-aimba kwésimankaavo anondáma íya moórá-aimba síníyono súwana ");
INSERT INTO kze_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ísu iséna íma anondá aaí súwana kámááni-kawaana'a Páíráti sáwívar-imayaa uráiye. ");
INSERT INTO kze_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","naaóvá'á Áánútu Yútaa-kwaasi tíyótaasa í-tánón-kánáá tóyo úntemba Árómáani-kamaani-kawaanako séna amáparawai torupamái mésa aamoí ésa ándáva'o máyáin-kwaasi áwí'a tewa'á ayúrankanaumne séna minkánáá miráumai ándá-kwaasi kwéayurankaiye. ");
INSERT INTO kze_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ísumba Páírátinopa'a máánkónka'a moóráwai áwí'a Párápási ándáva'a ména évakarawai kámááni-kwaasiye áái'a tíyónka'a kwemá moóráwaimba tuvuwúwana puwúwasa ándávimba ánkarowana máyowasa ");
INSERT INTO kze_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","sáwíva-kwaasi torupamái mésa Páírátintavai sésa moóráwaimba ayúrankaao suwaná ");
INSERT INTO kze_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Páíráti imáyáa éna séna mono-káwáá-kwáásí Ísuntavai íma anón-kwaasi-i'a ínkwáe sésa táto'maesa kesópa'a máánkaraawe séna tísaa ena séna Yútaa-kwaasiti kawáánárá ayúrankanaumno súwasa ");
INSERT INTO kze_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","mono-káwáá-kwáásí úwoi-kwaasi sáwívarawai kwakwiyésa sésa Ísumba íma ayúrankaniyompo Párápásimba ayúrankaao simáméro suwasá isésa mináímbá simámúwana ");
INSERT INTO kze_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Páíráti séna Ísumba Yútaa-kwaasiti kawááná'á iyémó sewáímbá nóra ónaumno súwasa ");
INSERT INTO kze_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","anónka'a sésa taaira'á tuvuwíyana puwíno suwaná ");
INSERT INTO kze_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Páíráti séna nóra-sawira uráina'iyo súwasa anónkar-anonka'a sésa taaira'á tuvuwíyana puwíno símae íyúwana ");
INSERT INTO kze_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Páíráti miwí táái owé senasá aamoí umásinkaigwae séna Párápásimba ayúrankena i-kwáásí simátimuwasa Ísumba áwí-andanei áwíruku'nowana Páíráti séna áí'mai taaira'á mátuvuwiyana puwíno séna Ísumba i-kwáásírá'á tímakaiye. ");
INSERT INTO kze_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ísumba i-kwáásírá'á timúwasa áí'maesa kámááni-kwaasiti naaúmpa'a móankesa amápar-i-kwaasi tááyowasa tamésa ");
INSERT INTO kze_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","naaeyayán-únánkwátói anón-kwaasiti unáánkwátóiman-iye sésa Ísumba umánkesa anón-kwaasiti kánumo'an-iye sésa áwí-andama owepamái Ísu a'nómpímbá kuvérankesa ");
INSERT INTO kze_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","kanaáráá'a ankésa moórá-mora-umai kívairesa sésa Yútaa-kwaasiti kawááná'á óne sésa tááúndei a'nómbá tuvánto'na kwéesa tuwirááíma kwirankésa ");
INSERT INTO kze_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","kanaáráá'a ánkáyuwesa naaeyayán-únánkwátói ayú'maesa kwená unáánkwátói umánkesa tuvuwíyanamo puwíndava'a áí'maesa kuráawe. ");
INSERT INTO kze_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","i-kwáásí Ísumba áí'maesa kumbá moóráwai Sáíríni-naopakewai áwí'a Sáímoni kwemá Arekesándaawe Árúvusinte tivowámá kwemá Yérúsaremu-naor-ampa'a túwasa i-kwáásí tátoresa Ísumbo tuvuwónááon-taima áúgwaatarankesa sésa áwa'naa úmae tiyó suwaná mirá úwasa ");
INSERT INTO kze_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","kwésa moórá-marago áwí'a Kórígótaava'a kwésa mináwíkóná ááimba a'nómayaapare supa'á kwésa ");
INSERT INTO kze_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ándá-aran-domba mairésa áí'a ánásainkwae sésa ikaa'ó vaí-yántáá'á mimpímbá marésa Ísumba ámúwana íma naráiye. ");
INSERT INTO kze_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ísu íma nówasa áí'maesa taaira'á aíyayaampimba máyuvusumaresa kwená unáánkwátói mayánáe sésa aávéiya kwétiyaananaya nááwa usáyaaitaindawai mayáníye sésa mirá ésa ");
INSERT INTO kze_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","aakaaká'ó máún-kanaa-avaura'a tuvúwúmba ");
INSERT INTO kze_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ísumbo tuvúwúwanamo puwún-ainkona ááimba aúváívimba agaimarésa sésa Ísu Yútaa-kwaasiti kawááná'án-iye agaimarésa taaira'á mósá marésa ");
INSERT INTO kze_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","umóyántémo uyan-kwáásíráí tí'maesa Ísumba évarevar-akwampa'a taaira'á tuvúsúmarowana  ");
INSERT INTO kze_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","naaóvá'á Áánútun-aai aúváívimba agaimaréna séna kwemá sáwí'a on-kwáásí máépa'a máyáísasa awánaraawe agaimaréna sirónka'a pósa mirá uráawe. ");
INSERT INTO kze_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","taaira'á tuvúsúmarowasa évakarawai tésa tiyáámba tóipimba áákesa timánáantata'a umánkesa aká'áámba simánkesa sésa úwé emá séma anóm-bono'-namba tawísíyuwe'a kaumbo-táwai kwaisuwé'a ó'omba ónaumne siráampo ");
INSERT INTO kze_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","esáváí enáúma áwa'naa ema eyááríka'a taairakémbá taútuwe marapá'á kumuwó suwasá ");
INSERT INTO kze_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","miráumai mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé sésa ó'owi túwa'naa ena kwesáváí kwenáúma íma kanaán-umai áwa'naa íníye. ");
INSERT INTO kze_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Áánútumo usásisinkaiwai é'a Ísareri-kwaasiti kawááná'á úne seémáyáimba póna árai'o seémáyáindamo éna kweyááríka'a taairakémbá kumínata awánéta séta árai'a Áánútu áánimban-iye sénaumne suwasaráí miwímó suntembá umóyántémo uyan-kwáásíráí évarevar-akwampa'a taaira'á tuvúsúmarowairai Ísumba kanaáráá'a ánkaraaiye. ");
INSERT INTO kze_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ísumba kanaáráá'a ánkówana kwáyá'wái amápa'-mapa'a túnkwena aaváúmá kaapa marówana túnkumba ");
INSERT INTO kze_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ísu anónka'a Yútaa-kwaasi tááivinkemba séna eroi eroi rama sapakataniyemo sún-aimba maarán-áímbá séna Áánútu kesí Áánútuwo nóra séwa siyuwáánó súwasa ");
INSERT INTO kze_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","minká'ó máyón-kwaasi isésa évakarawai sésa naaóvá'ó Áánútun-aai simátímakaiwaimba Íráiyaamba kwéaayaiye suwaná ");
INSERT INTO kze_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","moóráwai isaaiséna paru-táyánáma maimaéna ándá-aran-domba ikaa'-nómpímbá tu'maéna oviyen-támayopimba kinúvaimaena naínkwáe séna Ísu óika'a mósá maréna séna Íráiyaama kuména taairakémbá kunayútuwani. íya kunayútuwaniyo séta amu'maréta máyaumne súwana ");
INSERT INTO kze_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ísu anónka'a kwésena puwúwana ");
INSERT INTO kze_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","anóm-bono'-naumpa'a ampanta-óntámá úmakomba sanaan-áyáírákémbá utaváá'maena marapá'á móru taváákaar-umai kaesé umágúwana póna Áánútunopa'a iyónááon-amba kwi'makáiye. ");
INSERT INTO kze_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ísu anónka'a kwésena puwúmba i-kwáásítí kawáánákó Ísumo anónka'o sénamo miráumai puwúmba awánéna séna árai'a kwemá Áánútu ááninkoman-iye siráiye. ");
INSERT INTO kze_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","mináímbá súmba sáwívar-inimba awánanae sésa tumbá némpa'a tamésa awánara. miníníntómpínkémbá moórá-inimba Mágátáraa-naopaken-ininko áwí'a Máríyaa úwana moórá-inimba aú-kwaasi Yémésinte Yósisinte tinówama áwí'a Máríyaa úwana moórá-inimba áwí'a Sárómi ");
INSERT INTO kze_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","miráumai-inimba Ísumo Káríri-ayampa'o naaúpa'o kwenánaaembo kwa'maésamo áwa'naa úmaesamo kuráan-inimba Ísu Yérúsaremuva'a túmba miníníntómbá tésa taaira'á tuvúsúmaronka'a némpa'a tamésa awánaraawe. ");
INSERT INTO kze_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","miníníntómbá tamáyówana Yútaa-kwaasi monor-áímbá kwéison-kanaa aaváyaaraamba kwáyowana ívékaamba enónka'a moóráwai áwí'a Yósépi Árímátíyaa-naopakewai ");
INSERT INTO kze_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","kwemá anón-kwaasi éna kawe-kwáásí éna Áánútu kwená kwaási kawááiniye séna amu'maréna máyowai íma áá'a kómba Páírátinopa'a téna Ísun-auma utánáivo simiyó súwana ");
INSERT INTO kze_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Páíráti imáyáa éna ára pukuráína'iyo séna i-kwáásítí kawáánákómbá ááyena séna Ísu ára pukuráína'iyo súwana ");
INSERT INTO kze_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","owé á'a pukuráiye simámuwana Páíráti séna kanaampó Ísun-auma mayáníyone súwana ");
INSERT INTO kze_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yósépi aúná-ampantama komaimaéna tiréna Ísun-auma taairakémbá tamaimái minámpáántávímbá asááumai maimaéna aúsámakon-ontam-buri-aivimba mámarena óika'a anón-ontandei awááumasuwena kúwasarai ");
INSERT INTO kze_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Máríyaa Mágátáraa-naopaken-ininko úwana araámáó Yósisimba anówama úwasarai mésarai Ísumbo utamánkomba taawánésa kurááiye. ");
INSERT INTO kze_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yútaa-kwaasimo agándon-kanaa ánásowasa kaumbo-ínímbá Máríyaa Mágátáraa-naopaken-ininko úwana araámáó Yémésimba anówama úwana Sárómi úwasa miráumai-inimba Ísun-aura'a áséi-kwiyu-masawemba mápérankanae sésa ");
INSERT INTO kze_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ááéma aaváúmá usónka'a mimbásáwémbá maimaésa Ísumbo utamánkaropa'a kumbá ");
INSERT INTO kze_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","aampa'á kwégwesa iséise ésa sésa murí-áígó óika'a awááumasukaan-ontamba anón-ontamba póna nááwa akwásinkanintaa'iyo sésa ");
INSERT INTO kze_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","awánomba minóntámbá á'a akwátukowasa awánésa ");
INSERT INTO kze_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","mimbúrí-áírá'á íyúmba moóráwai ívé-kwaasi kwayán-únánkwátóigwara-kwaasi minká'á máyowasa awánomba táá'a kówana ");
INSERT INTO kze_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","simátimena séna íma táá'a kaíno. Ísumba Násáretivakewaimba taaira'á tuvúwówana púwíwaimba taawánanae sé'o kwétemba pukáimpinkemba usásinena kówéna íma maanká'á máyáivo utamánkaraampimba uawáné'a ");
INSERT INTO kze_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","kwená kwayó-kwáásíyé Pítaa iyai kosimátime'a sé'a Ísumo siráintemba pukáimpinkemba usásinena kentí aiva'á Káríri-ayampa'a kwína'a koawánanaaowe. mináímbá kosimátíméro súwasa ");
INSERT INTO kze_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","mimbúrí-áímá tuwésa táá'a kéna tiyántámbá tówasa isaaisésa kwésa táá'a kóntavai mináímbá íma kosimátímakaawe. Mááka kemó súnda-aimba ánásaiye. ");
INSERT INTO kze_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","sontaará'á ááéma Ísu pukáimpinkemba usásinena aiva'á Máríyaa Mágátáraa-naopaken-ininko aúranka'a paárúwana ááéma Ísu minínínkó arumpinkémbá avakaeté-taravaa-kwamba mayáúkain-ininko aúranka'a paárúwana ");
INSERT INTO kze_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","awánéna kwená kwaási ivi'ó kwétopa'a kosimátimuwasa ");
INSERT INTO kze_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ísumo aúvówanamo minínínkómó awánón-aimba simátimumba isésa íma ísámai kawe'á uráawe. ");
INSERT INTO kze_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","minkákémbá kae-kwáásí aampa'á nén-ampa'a kwéguyana Ísu ó'on-kwaasi túwawaakaamba makéna minkáé'nárai túranka'a paárúwasarai awánésarai ");
INSERT INTO kze_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","koyauwerésarai Ísuna kwaási tasimátímúyasa ísómba íma ísámai kawe'á uráawe. ");
INSERT INTO kze_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","minkákémbá Ísuna kwayó-kwáásí sísamaivakemba moórá kumbaimái-kwaasi toómbá kwénowana Ísu paárúwasa awánowana Ísu áwáá'a tiyéna séna kemá pukáundavinkemba usásinkaunda suwánaresa simátíméwa'a ísámai sirumbá kwéairaraawe sé'a ísámai tuwarónaawaro kwéowe. simátímén-aintavai áraire seráámbá íma áraire siráawe simásuwena ");
INSERT INTO kze_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","séna kesí áséi-kwasai amápa'-marava'a simátímapa'a koró. ");
INSERT INTO kze_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","kesááiyavesa áraire sésa kenká'á agevamái mésa nombá peráíyana Áánútu miwímá sáwí'o umáímo máyáampinkemba iyátinkanivo kesááiyavesa íma áraire síyawaima Áánútu aaivimbá maitinkáníye. ");
INSERT INTO kze_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","kesááiyavesa áraire sésa kenká'á agevamái máyáawai ímo awánaam-bayaima maésa kesí asirayándéí kwaási tirumpinkémbá taraváá-kwámbá maitiyuwésa ó'on-aimpinkemba sésa ");
INSERT INTO kze_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","áwáávi'o índa-iraankavayaambo tátoraiyanamo váíndamo ésa íma puwésa puwí-nómbó náíyambo ésa íma puwésa tí'o ín-kwaasira'a tiyáándei táto'mai asóvamatinkanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ísóigo Ísu mináímbá simásuwowana Áánútu Ísumba áí'maena kwíyómpa'a móankowana Áánútu ayáánúrapa'a asirayán-áyámpá'á máyowasa ");
INSERT INTO kze_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ísuna kwayó-kwáásí amápa'-marava'a áséi-kwasai simátímapa'a kuwaná Ísóigo kwétuwa'naa-uwasa kwaási ímo awánaraam-bayaima mayówasa awánésa sésa maanáímbó simásíménta árair-aimban-iye siráawe. mináímbá ánásaiye. ");
INSERT INTO kze_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","anóndako Tíóvíraasiyo moórá-kwasai sénaumpo isaaó. Áánútu kentáávímbá paáruraimba aiva'á awánaraan-kwaasi mintántáákón-áái simátíma'maesa iráamba isasá kentáá kwésimasimewe. sáwívarawai mináímbá árair-aimba agaimakáamba mináínkóná ááimba kawe'á umái isé'a aivakén-áímbá avupinkén-áímbá naaénken-aimba agaimái amúne. ísaraanda-aimba árair-aina'i. kampar-áíná'iyompo mindáyave'a maanáúváímá agaimái amúmpo awáné isaaó. ");
INSERT INTO kze_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yútiyaaa-maravaken-kawaanako áwí'a Éróti máyon-kanaavimba moóráwai áwí'a Sékáraya kwemá Ápáísana akún-ándárákén-kwáásí ména Áánútuna mono'-náúmpá'á mayáí kwémayowai máyowana awainínkó áwí'a Érísapeti kwemá Érónina akún-ándárákén-ínímbá póna Áánútuna mono'-náúmpá'á mayáí kwémayon-kwaasiti akún-ándárákén-ínímbá úwasarai ");
INSERT INTO kze_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Áánútu aúranka'a minákwá'á kawe'á umái mésarai Ísóigo arááíma kwégwaresarai kwená ámáámba kawe'á umái isésarai ");
INSERT INTO kze_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","iyámpóí íyaaimba ageínímbá ména anónu'mai áráankamba karááiye. ");
INSERT INTO kze_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","anónu'mai áráankamba kamáguyasa Sékárayaana akúmbá Áánútuna mono'-náúmpá'á mayáí kwémaesa mirá úmae kwéiyesa miwítí mayáí taaínkaar-ésa Sékárayaamba usásinankowana áséi-kwiyumba índa-yantaa'a agayáíndayavena Ísóigona anóm-bono'-naumpa'a iyúwasa ");
INSERT INTO kze_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","áséi-kwiyumba índa-yantaa'a agayáí-kánáámá amápa'a Yútaa-kwaasi máá'aruva'a mésa Áánútumpa'a námúnaa kwésuwana ");
INSERT INTO kze_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sékáraya Ísóigona anóm-bono'-naumpa'a iyúwana áséi-kwiyumbo ií-yántáá'ó agayáí-tááréígóná ayáánúrapa'a kwíyómpaken-kwayo'na'a paárúwana ");
INSERT INTO kze_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sékáraya awánéna kantúmba éna inkaisúwana ");
INSERT INTO kze_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","kwíyómpakewai séna Sékárayaao íma inkaisiyó. Áánútumpa'o námúnaamo sénda ísáíntavena enawainínkó Érísapeti iyámpói mayánívo miníyámpóígó áwí'a Yóniye siyó. ");
INSERT INTO kze_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","marankáínana enarunkó aamoí kwéinasa á'on-kwaasigwara'a aamoí ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","marankáíndara'a Áánútun-amanko miníyámpóígó arumpimbá anómba ínana ándá-aran-domba uwo'aó'-nómbá íma naíno. Áánútu aúranka'a kwenáwí'a anómba íníye. ");
INSERT INTO kze_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","kwemá anón-éna Ísareri-kwaasiyomba tavisínasa miwítí Ísóigo Áánútumpa'a ókwara'a ténááowe. ");
INSERT INTO kze_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","kwemá Áánútun-aai simátímakowai áwí'a Íráiyaa uráintemba asiramái ména Ísóigona aiva'á kwéna tivoísáíye táánimbaate tavisínasa tágárotamai ménaaowe. aaimó ímo isáíyan-kwaasi tavisínasa arupí-kwaasimo íyantemba miwí ésa kawer-ímáyáá ónááowe. miráumai Ísóigomo kumíníntavena kwená kwaási to'mayaa umátinkaniye kwíyómpakewai súwana ");
INSERT INTO kze_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sékáraya séna kesé kesuwainínté anónu'mai áráankamba kágurauvo nóra séra mináíntávé'a áraire sénaumno súwana ");
INSERT INTO kze_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","kwíyómpakewai séna kemá Képarieri mé'a Áánútu aúranka'a máyaunana kawe-kwásáí siména si'máráísa'a móru simámundayavai ");
INSERT INTO kze_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","íma áraire sémpo emá íma aaí sindá ménana naaén-kanaa kemó súnda-yantaa'a paárína kawe'á umái aaí síníyone súwasa ");
INSERT INTO kze_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","máá'aruva'a máyón-kwaasi Sékárayaamba amu'matuwé mésa sésa anóm-bono'-naumpa'a nóintavena ayáátááka'a máyáiyo kwésuwana ");
INSERT INTO kze_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","máápa'a kuména íma aaí súwasa anóm-bono'-naumpa'a kaainkáání'a umái awáraiye suwaná ayáán-awaame'a kwéena íma aaí súmba ména ");
INSERT INTO kze_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","kwená mayáí-kánáá ánásowana kwená naaópa'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","komáyowana awainínkó Érísapeti ámú'a paáréna aúpá'á éva'aasei-kwiyomba ména ");
INSERT INTO kze_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","séna Ísóigo kawe'á umásinkena mirá uráintave'a aamoí é'a ayáátááka'a iyámpói íma tinkáúnda misígáémó imbá kwéanasaiye Érísapeti siráiye. ");
INSERT INTO kze_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Érísapeti ámúkwa'a ména ava'moraé-kwiyomba maisuwówana Áánútu kwená kwayó'ná'á áwí'a Képarierimba kwíyómpakemba ai'marówana Káríri-marava'a Násáreti-naopa'a kuména ");
INSERT INTO kze_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","moórá-arasigomba áwí'a Máríyaamba simámindayavena kunkáiye. minárásígó íma kwaaí mairón-arasigo Tévíti-andaraken-kwaasira'a áwí'a Yósépinka'a siváúmaresa ítámakowana ");
INSERT INTO kze_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","kwíyómpakewai Máríyaanopa'a kuména séna mé'ono. Áánútu aamoí umánkena esé máyáiye simámuwana ");
INSERT INTO kze_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","anón-imayaa uwááena séna mináínkóná ááimba nóran-aintavaiya siíyó kwésuwana ");
INSERT INTO kze_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","miwámá séna Máríyaao Áánútu aamoí umánkáívo íma áá'a kaíno. ");
INSERT INTO kze_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ámú'o kaumáímo iyámpóímo maranké Ísuwe se áwí'a tamánkaniyone. ");
INSERT INTO kze_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","kwemá anón-éna anón-kwaasi-i'a ínasa usáyaaitamai-Isoigo ááninkoman-iye sénááowe. aíkwá'náon-awi'a Tévítimo kawáá-máyáí mairóntemba Áánútu kawáá-máyáí amínana ");
INSERT INTO kze_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yákópon-andaraken-kwaasi kawáá-máyáí kwaíkwai'a ínana minkáwáá-kwí'á íma ánásainda kwaíkwai'a íníye Képarieri súwana ");
INSERT INTO kze_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Máríyaa séna nóra se seénó. kemá íma kwaaí mairé'a úwoi máyaumne súwana ");
INSERT INTO kze_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","kwíyómpakewai séna Áánútun-amanko esé máyainana usáyaaitamai-Isoigona asirayámbá embá amína po maránkénasa ó'oran-iyampoi Áánútu áánimban-iye sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","enamááraa-ininko áwí'a Érísapeti áráankamba kéna ámú'a kauráiye. ageínímbán-iye kwésewana ámú'a kauréna ava'moraé-kwiyomba maisukáiye. ");
INSERT INTO kze_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Áánútu amápa-tantaa'a etóyóí kwéena kwenkwárá'á mirá kwéumankaiye súwana ");
INSERT INTO kze_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Máríyaa séna Áánútuna kwayór-árásí úmpo simásimendantemba Áánútu kembá mirá íníye súwana Áánútu ai'mákowai auwéna iráiye. ");
INSERT INTO kze_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","iyúwana sáwíyanka'a Máríyaa ména usásinena avekáán-umai Yútiyaa-marava'a omápar-ayampa'a moórá-naopa'a kwéna ");
INSERT INTO kze_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sékárayaana naaúmpa'a iyéna Érísapeti áwí'a mói tówana ");
INSERT INTO kze_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Érísapeti Máríyaa amósámba isówana iyámpóígo anówan-arumpimba ména úwauwa úwana Áánútun-amanko Érísapeti arumpimbá anómba úwana ");
INSERT INTO kze_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","anónka'a séna Áánútu kawe'á umánkena ó'on-inimba kítoka'a kawe'á umátinkena embá anónka'a kawe'á umánkaraiye. marankáníyonda-iyampoigonkwara'a kawe'á kwéumankaiye. ");
INSERT INTO kze_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","íma súwíkwarar-inimba úndanivo kesí Ísóigomba marankáníyonda-inimba éma kesí namu'á kwétene. ");
INSERT INTO kze_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","enamósámba isáúnana sirumpimbá máyáin-iyampoigo aamoí éna úwauwa uráiye. ");
INSERT INTO kze_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Áánútu simámakain-aimba árai'a paáriniye séndayavena Áánútu kawe'á kwéumankaiye Érísapeti siráiye. ");
INSERT INTO kze_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","súwana Máríyaa séna kesí imáyáago Ísóigo áwí'a mósá kwémaraisa'a ");
INSERT INTO kze_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","Áánútuna kwayór-árásí úwoi-arasi únana kentávéna imáyáa isaná sirunkó kawe'á isa'á Áánútu kawer-ámpá'á mésínkaiwaimba aamoí kwéumankaumne. Áánútu anón-asirayankwarawai anómba umásínkáimba pósa kentávésa sésa Áánútu kawe'á umánkaraiye sénááowe. ívé'a máyáan-kwaasigwara naaémbo paáronaaon-kwaasigwara'a mináímbá símaesa kónááowe. Áánútu ó'orawaima éna ");
INSERT INTO kze_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","kwenaísamaivimbo máyáan-kwaasiyavena naaóvá'ó maémáen-kwaasigwara ívé'o máyáan-kwaasigwara naaémbo paáronaaon-kwaasigwara'a arumbá umátínkámaena iyíníye. ");
INSERT INTO kze_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Áánútu asiramái ména asirayám-báyáí maéna kentúwí'o mósá máráan-kwaasi ti'mátu'makaiye. ");
INSERT INTO kze_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Áánútu túwí'o kwáyáin-kwaasi sáwíyanka'a móruna umátinkena ímo túwí'o kwáyáin-kwaasi anónka'a mósá kwéumatinkaiye. ");
INSERT INTO kze_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","táái kwétinkain-kwaasi kawe-tántáá'á tiména sáwíva-tantaa'a makáan-kwaasi íma tiména ti'mátukaiye. ");
INSERT INTO kze_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Áánútu kentáá síkwá'nágwara Ááváramuntavaigwara'a asiramái séna enkwárá enaísavutantambo íyawaigwara'a sirumbá umátínkámae iyónaumne siráin-aimba ááka'a makéna kentáá Ísareri-kwaasiya kwená kwayó-kwáásíyá kwésuwa'naa-iye Máríyaa séna ");
INSERT INTO kze_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Érísapetiye ména kaumbo-kwíyómbá maisuwéna kwená naaópa'a kunkáiye. ");
INSERT INTO kze_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","kumúwana Érísapetina kanaamá túwana iyámpói maránkówasa ");
INSERT INTO kze_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ísóigo arumbá umánkarain-aimba isésa kwenamááraawe kwená naaópakewaiye isésa anówankwara'a aamoí umánkaraawe. ");
INSERT INTO kze_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","aamoí uwaná miníyámpóígó avakaumboé-no'waamba kwaúwasa áúra'a kárámai araa'éna ónáe sésa avowá áwí'a Sékárayaawe simánkanae uwaná ");
INSERT INTO kze_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","anówama séna ímanivo kwenáwí'a Yóniye seró súwasa ");
INSERT INTO kze_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","miwí sésa íma ená kwaásiva'a mirán-kwí'á kwáyáiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","avowámbá áá'a kaúnkowasa tiyáándei umásítai'a ésa nóran-kwira tamáminiyono suwaná ");
INSERT INTO kze_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","avowámá aúváí-kwandaai síméro séna umásítai'a úwasa máámúwana agaimaréna kwenáwí'a Yóniye séna timúwasa awánésa anón-imayaa uwaná ");
INSERT INTO kze_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sékáraya agaimaréna ói'a etóyóí úwana aaí séna Áánútu áwí'a mósá marówasa ");
INSERT INTO kze_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","mindáópaken-kwaasi táá'a kówana Yútiyaa-marava'a omápar-ayampa'a mináímbá kóyáwé umágúwasa ");
INSERT INTO kze_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ísówai anón-imayaa ésa sésa miníyámpóígó naaémba nóran-kwaasiya méniyo sésa Ísóigona asirayámbá kwesé máyáiye siráawe. ");
INSERT INTO kze_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","miníyámpóígó avowámbá Sékárayaamba Áánútun-amanko anómba umánkowana Áánútun-aai simátimena séna ");
INSERT INTO kze_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Áánútu kentáásí Ísóigo éna kwená kwaásiya Ísareri-kwaasiya súwa'naa ena sáwí-imayaao tátoraimpinkemba iyásinkaindayavenaya kwéimba póta kwenáwíta mósá maránaumne. ");
INSERT INTO kze_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Áánútu kwená kwayó-kwáásí Tévítin-andarakewaimba asirayán-kwáásí usásinankaraimba póna sáwí'o umáíyaamo máyaundavinkemba kawer-ámpátá mésinkaniye. ");
INSERT INTO kze_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","naaóvá'á Áánútu mináímbá kwená kawe-kwáásí simátimuwasa agaimakáawe. ");
INSERT INTO kze_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","naaóvá'á Áánútu kentááyávéna asiramái séna tíyámbo kembó umátínkén-kwaasi namuro-kwáásí tátokaampinkemba métiranaumne siráiye. ");
INSERT INTO kze_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","naaóvá'á Áánútu kentáá síkwá'náyavena arumbó umátinkanin-aimba séna kwená asirayán-áímbá ááka'o maránín-aimba siráiye. ");
INSERT INTO kze_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Áánútu Ááváramu kentáá síkwá'náyavena kentáásí namuro-kwáásítópakemba mésinkainata íma sáá'a kwégainata kwená mayáí maéta ");
INSERT INTO kze_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kwenaúranka'a kawe'á umái arupí umái maí'mai'a ónaunda-ainta asiramái siráiye. Sékáraya simásuwena séna ");
INSERT INTO kze_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","kesááninkoo entávésa usáyaaitayan-Isoigon-aai simátiminiyondawai óne sénááowe. aiva'á kwé Ísóigona aambá kwiyíníyone. ");
INSERT INTO kze_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ísóigo kwená kwaásiti sáwí-imayaa maitiyuwéna kawer-ámpá'á métinkanin-aimba kwésimatime Ísóigona aambá kwiyíníyone. ");
INSERT INTO kze_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kentáásí Ísóigo ávááraumai arumbá umásinkenaya aaváúmó iyénamo sámo kaintembá kawer-ámpátá mésinkenaya sáma kamásinkanintaawe. ");
INSERT INTO kze_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","túnín-ayampa'o máyáawai puwónááontavena táá'a kaiwáí sáma kamátinkena kawer-ámpá'á métinkaniye Sékáraya siráiye. ");
INSERT INTO kze_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","súwana miníyámpóígó anón-éna kawer-ímáyáá kwéena kavóná-marava'a ména Ísareri-kwaasi túranka'a paárinin-kanaa kwétuwana kavóná-marava'a méraiye. ");
INSERT INTO kze_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","minkánáávímbá Árómáani-kamaani-anondako áwí'a Ógásitasi kwemá simátimena séna amápa'-marava-kwaasi túwí'a agayánááowe siráiye. ");
INSERT INTO kze_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","aiva'á túwí'o agayón-kanaavimba Sáíriniyasi Síriyaa-kwaasiti kawáánákó máyón-kanaavimba ");
INSERT INTO kze_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","namupa'ó maivá kuráawai koyauwerésa kentí akúmbó máyópa'a túwí'a agayáíyantavesa tiráawe. ");
INSERT INTO kze_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yósépi Tévítin-andaraken-kwaasi póna Káríri-marava'a Násáreti-naopa'a tuwéna Yútiyaa-marava'a Tévítina naaópa'a téna mindáó-kwi'a Pétáremuva'a túwana ");
INSERT INTO kze_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","awainínkó-árásígó Máríyaa ámúkwari'a úwana áwí'a mayáíndayavena áí'maena túwana ");
INSERT INTO kze_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","mindáópa'a ména iyámpóímo ankáí-kánáá túwana ");
INSERT INTO kze_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","aivar-íyámpóí marankéna iyámpóígona unáánkwátói úsúrena purumakankóná táávepimba ánkaraiye. túwí'a kwéagayowasa sáwíva-kwaasi kwirómpimba kwaásimo kwááyumo kwáén-daumpa'a íma ména purumakankóná naaúmpa'a ména maránkaraiye. ");
INSERT INTO kze_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","mimbápá'á sipisípira'o tavíkówai no'wáámba uvá'á kwégawaa-esa máyówana ");
INSERT INTO kze_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ísóigo kwená kwayó'ná'á kwíyómpakemba ai'marówana sipisípira'o tavíkówaitopa'a paárúwana Áánútuna ságayamba tuwówana kumúwasa awánésa ávááraumai táátavesa uwaná ");
INSERT INTO kze_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","kwíyómpakewai séna íma táá'a kaíno. áséi-kwasai kusimátimunda pósa sáwíva-kwaasi kwéisesa ávááraumai aamoí umánkanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ívé'a Tévítina naaópa'a iyámpói maránkáísana miníyámpóígóntávésa Áánútu usásinankaiwai Ísóigoman-iye sénááowe. miníyámpóígó keináraware ó'on-kwaasiye sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaniye. ");
INSERT INTO kze_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","miníyámpóímá ampantanéí úsúmai purumakankóná táávepimba máráísa'a koawáné'a sé'a simásímakain-aimba árair-aimba kentáá kawer-ámpá'á mésinkaniwaimba maránkaraiye sénááowe súwasa ");
INSERT INTO kze_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","avekáámbá kwíyómpakendarawa'a sáwíva'a paárésa Áánútu áwí'a mósá marésa sésa ");
INSERT INTO kze_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","kwíyómpa'a Áánútu áwí'a mósá maráúmne. marapá'á Áánútu aamoí umátínkáin-kwaasi paru umái máyáawe siráawe. ");
INSERT INTO kze_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","kwíyómpakendarawa'a kwíyómpa'a kuntauwerésa íyúwasa sipisípira'o tavíkówai sésa Ísóigo simásímakain-kwasaiyaveta Pétáremuva'a koawánanaisaiye sésa ");
INSERT INTO kze_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","avekáán-umai kumbá Máríyaae Yósépiye mésarai purumakankóná táávepimba Ísumba ánkaroyamba taawánésa ");
INSERT INTO kze_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","kwíyómpakewai sirón-kwasai miníyámpóígóná kwaasái tasimátimesa ");
INSERT INTO kze_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","20","koyauwerésa simásímakain-ainta árair-aine sésa ísaron-aintavesa koawánontavesa Áánútu áwí'a mósá makáawe. sipisípira'o tavíkówai simátimun-aimba ísówai imáyáa uwaná Máríyaa mináímbá áákar-aaka'a éna imáyáa uráiye. ");
INSERT INTO kze_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","iyámpói ánkáyuwena avakaumboé-no'waamba kwaúwasa miníyámpóígó áúra'a kárámai araa'éna uwaná áwí'a tamánkena anówamo ímo ámúkwari'o urónka'a kwíyómpakewai sirón-kwi'a tamánkena Ísuwe siráiye. ");
INSERT INTO kze_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","naaóvá'á Mósesi aaraimó iyámpóímo tinkésa nombó pétuwesa miwítí naaópa'o iyónááon-aimbo siráin-kanaa túwasarai Yósépi Máríyaae Ísumba áí'mesarai Ísóigombo amíyanesarai Yérúsaremu-naopa'a kurááiye. ");
INSERT INTO kze_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ísóigona ámáámba Mósesi agaimaréna séna Ísóigo séna kentí iyámpói aiva'á inaamai-íyámpóíyómbá tí'mae'a kesópa'a mátinke'a ená iyámpóíye sénááowe Ísóigo siráiye Mósesi agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","moóráva'a Ísóigona ámáámba agaimaréna séna Áánútuntavekai ísámai máái-numa kae'á vamái agáyáákaiyo. ímo mááimo makékai mááiraan-dumago áráá'a kae'á maimái agáyáákaiyo siráiye. mináímbá mirá óyááoiyantavesarai Ísumba áí'mesarai Yérúsaremu-naopa'a kurááiye. ");
INSERT INTO kze_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","kuyaná moóráwai áwí'a Símiyoni kwemá Yérúsaremuva'a ména kawe-kwáásí póna Áánútun-aaiyavena asiramái ména Ísareri-kwaasi kawe'á umátinkaniwaimba amu'maréna máyowana Áánútun-amanko kwesé ména ");
INSERT INTO kze_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ááéma simámena séna íma ááéma puwíníyompo Ísóigomo usásinankaiwaimba awáné puwíníyone simámakaimba ");
INSERT INTO kze_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Áánútun-amanko imáyáa amúwana anóm-bono'-naumpa'a umáyowasarai Ísu anóvowi ámáámba mirá siróntavesarai Ísumba áí'maesarai anóm-bono'-naumpa'a íyúyana ");
INSERT INTO kze_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Símiyoni miníyámpóí tapéna Áánútuntavena súwi simásuwena séna ");
INSERT INTO kze_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ísóigoo simásímakaanda-aimba ívé'a paárisana sirunkó kawe'á kwéimba pó'a úwoi puwónaumne. ");
INSERT INTO kze_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","amápa-kwaasiyavai ísámai kawer-ámpá'ó métinkaniwaimba usásinankaana'a á'a kwéawanaumne. ");
INSERT INTO kze_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ó'onkaa-kwaasi sáma kamátinkena kawer-ámbá agaráátinkainana póna Ísareri-kwaasi súwíta iyíníye Símiyoni siráiye. ");
INSERT INTO kze_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Símiyoni miníyámpóígóntávéna súwasarai anóvowi isésarai anón-imayaa uyaná ");
INSERT INTO kze_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Símiyoni séna Áánútu kawe'á umátinkaniye simásuwena miníyámpóígó anówantavena séna Áánútu maaníyámpóí usásinankaiye. kwentávésa Ísareri-kwaasi évakarawai Áánútuntavesa kawe'á umái méwasa évakarawai tínaaemba umámenaaowe. Áánútu kwembá awaamékáámbá umánkáísasa sáwí-aimbo simánkanaaowaiti ");
INSERT INTO kze_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","sáwí-imayaa amápa-kwaasi túranka'a paáriniye. ááigwara-tantaako airáráísanamo áí'o intenkáámbá umbai-yántáá'á enarumpimbá tíníye Símiyoni Máríyaantavena siráiye. ");
INSERT INTO kze_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","moórá-ininko áwí'a Ánaa kwemá Áánútun-aai simátímakon-ininko ména Ásan-andaraken-inimba Vániyueri ayáámúnko póna kwaaí mairéna avakaeté-ima maisuwówana awaikó puwúwana ayáátááka'a 84 ima maisuwéna áráankamba kéna aasiyaasi-táwai anóm-bono'-naumpa'a uména enónka'a aaváyaavimba no'wáámba Áánútu áwí'a mósá kwémarena námúnaawe su'mai síndayavena íma toómbá kwénena ");
INSERT INTO kze_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Símiyoni kwésun-tawai kwegwárá'á egwaa'á taména Áánútuntavena súwi séna miníyámpóígón-áái simátimena Áánútu Yérúsaremuvaken-kwaasi sáwí-imayaao tátokaimpinkemba iyásinkaindavenaya sirániwaimba kwéamu'maraundawaintavena miníyámpóígón-áái simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yósépiye Máríyaae Ísóigo siráin-amaamba ánásamasuwesarai Káríri-marava'a mindáraiti naaópa'a Násáreti-naopa'a komáyóyana ");
INSERT INTO kze_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","mindáraiti iyámpóígo anón-umagwena asiramái ména kawer-ímáyáá kwéuwana Áánútu kawe'á kwéumankowana méraiye. ");
INSERT INTO kze_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","naaóvá'á Áánútu Yútaa-kwaasi tíyótaasa í-tánón-kánáá túntemba Ísu anóvowi Yérúsaremu-naopa'a kóyo urááiye. ");
INSERT INTO kze_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ísu sísamaivakemba kae'á kumbaimái-ima maisukónka'a kóyo uyambá pósarai mintánómbá nayááoiyantavesarai Ísumba áí'maesarai Yérúsaremuva'a komáyóyana ");
INSERT INTO kze_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","mintánón-kánáá ánásowasa miwítí naaópa'a kóyáwé uwaná Ísu Yérúsaremuva'a máyowasarai anóvowi íma awánésarai ");
INSERT INTO kze_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","imáyáa ésarai kwenamááraewa aampa'á kwégwiyo-imayaa ésarai aampa'á kwégwesarai enónka'a kwétoyo uwasaráí mindárai miwítí naaóraavimba timááraavimba tíndawe sésarai avakáá uyambá ");
INSERT INTO kze_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","íma awánésarai avakáá uwááesarai ó'a tayauwerésarai Yérúsaremuva'a koavakáá úmaesarai kuyambá ");
INSERT INTO kze_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","kaumbo-táwai ánásowana anóm-bono'-naumpa'a máyowasarai anóvowi awánaraaiye. Yútaa-kwaasi aaimó simátímún-kwaasiti avumpimbá Ísu ména miwí táái kwéisena mináíntávéna tísaa úwasa ");
INSERT INTO kze_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","anondá kwembá áísaa uwaná kwená kawer-ímáyáávínkémbá simátimuwasa isésa táátavai uwasaráí ");
INSERT INTO kze_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","anóvowi taawánésarai táátavai ésarai tiyáámba tuvimpínésarai anówama séna kesááninkoo enavowé kesé avakáá úmaekai kwénaauyana sirunkó umbaí kwétaivo nóra éwa mirá kwéono súwana ");
INSERT INTO kze_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ísu séna nóra ékai sivakáá kwéoyo. kesivoná naaúmpa'a máyaumpo nóra ékai íma ísaraaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","mináínkóná ááimba íma kawe'á umái ísaraaiye. ");
INSERT INTO kze_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","íma ísóyana Ísu anóvowiye Yérúsaremuvakemba Násáreti-naopa'a téna miwí tááiyavena kató úmae kwéiyena tamáyowana anówama Ísumo uráimba imáyáa umái máyowana ");
INSERT INTO kze_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ísu anón-umagwena kawer-ímáyáá kwéuwasa Áánútugwara kwaásigwara'a aamoí umánkaraawe. ");
INSERT INTO kze_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Árómáani-kwaasiti anóndako áwí'a Táípíriyasi ména kawáá-máyáí mairéna sísamaivakemba éva'aasei kumbaimái-ima maisuwónka'a Yútiyaa-marara-kawaanako áwí'a Póntíyasi Páíráti máyowana Káríri-marara-kawaanako áwí'a Éróti máyowana áváko áwí'a Vírípi kwemá Ítúréa-maravare Tárékónaitisi-maravare kárákwirowana Áráíseni Ápíríni-marava'a kárákwirowasa ");
INSERT INTO kze_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","miráumai-kwaasi kárákwironka'a Ánásiye Káyavaasiye aiva'-mónó-káwáánákáí máyóyana Sékáraya ááninko áwí'a Yóni kavóná-marava'a máyowana Áánútu aaimá simámuwana ");
INSERT INTO kze_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yóni Yótáni-nonkona arúvá'á kwénaaena simátimena séna sáwí-imayaa tuwé'a Áánútunopa'a tíya'a nombá pétinkaanana Áánútu kentí sáwí-imayaa maitiyuwáníye Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","mirá súntavena naaóvá'á Áánútun-aai simátímakowai áwí'a Áísáya agaimaréna séna moóráwai kavóná-marava'a ména aayamáírakemba séna Ísóigona aambá kwirankánááomba kwená aambá arupí íyana minámpá'á kwíno. ");
INSERT INTO kze_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","omá'a kárámai ukwítu'mae koró. kae'náér-amba arupí oró. kuváúsaavau-amba maimái kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Áánútu sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaniwaimba ai'maráínana kumínímba amáparawaima awánanaaowe Áísáya agaimaréna sirónka'a póna Yónintavena mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","súwasa Yóni nombá pésinkainkwae sésa sáwíva-kwaasi kwenópa'a tóyo uwaná Yóni simátimena séna iyánkó póígon-araa'an-owe. Áánútu kentí sáwí-meyamba timínívo nááwa simátímísara iséra inkaiséra kwéteo. ");
INSERT INTO kze_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","kentí sáwí-mayai tuwé'o Áánútumpa'o té'o é'a kawe'-máyáí máyéwa'a tuwánanaumne. Ááváramu kentáá síkwá'ná imbá póta Áánútuna kawe-kwáásíyá úne sé'a mirán-ímáyáá íma oró. Áánútu Ááváramu aísaavutantamba ónááowe sénaraankasi maanóntámpínkémbá kanaám-po'a kwaási aúráaro sisa'á aúráasino. Ááváramu aísaavutantamba uráundawai póta kawe-kwáásíyá úne sé'a mirán-ímáyáá íma oró. ");
INSERT INTO kze_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","íma kawer-árámbá íyain-taima ááimpimba kwéayaisuwesa iravímbó agaisúwáántemba Áánútu miráumai kentí sáwí-meyamba timíníye Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","súwasa isésa sésa simásimenda-ainta nóraya ónaumno suwaná ");
INSERT INTO kze_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yóni séna kaer-únánkwátói makáawai ímo makáawaima moórá-mora-umai tímatuwaaro. toómbá makáawai ímo makáawaima moórá-mora-umai tímatuwaaro Yóni súwasa ");
INSERT INTO kze_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","táákísi-ontamba kwémayon-umoyan-kwaasi Yóni nombá pésinkainkwae sésa kwenópa'a tésa sésa anóndako ómpo nóraya ónaumno suwaná ");
INSERT INTO kze_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yóni séna íma kampa'á simái anón-ontamba maé'a táákísi-ontane su'mai máyáaro súwasa ");
INSERT INTO kze_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","i-kwáásí sésa kesáá nóraya ónaumno suwaná Yóni séna tínkantuke'a miwítí óísamba mayánáe íma seró. kampar-áímbá kwésimatime'a miwítí óísamba mayánáe íma seró. kentí mayáígóná meéyántávé'a íma kayoré'a tirunkó kawe'á kwéina'a máéro Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yútaa-kwaasi Áánútumo usásinankaiwaimba amu'marésa mésa Yónin-aai isésa anón-imayaa ésa sésa Áánútumo usásinankaiwai kwemá Yóniya'i. á'owaawa'iyo kwésuwana ");
INSERT INTO kze_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yóni séna kesínaaemba tíníwai kwemá anóndakoma kembá usáyaaitaraimba pó'a kwemó aaimó síndavimba kemá aaimá sendamá uwóví'a ónaumne. kemá nombá pétinkaundanivo kwemá Áánútun-amankomba ai'maráínana kuména keinárawapimba anómba umátinkaniye. iramó agáyáantemba íníye. ");
INSERT INTO kze_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","aawinkwínaumo sípétivimbo mósá makésamo iyaavumásúwááwanamo anómbo marapá'ó kúmísanamo ásima úndáomo tútúwaisasamo kaíkai'o ínín-iravimbo kwiyúmaimo agaisuwésamo anómbo naaúmpa'o mósá máráantemba kwaási miráráámbá íníye Yóni séna ");
INSERT INTO kze_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Áánútuna áséi-kwasai ísámai kawer-ígwáe séna mirán-áímbá simátíma'maena iráiye. ");
INSERT INTO kze_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Yóni simátíma'maena kwéiyena sáwíva-kwaasi nombá kwévetinkena naaémba Ísumba pérankowana námúnaa kwésuwana sokón-tawaai taaínkaar-úwana Áánútun-amanko mááiraamba úmaena ane'á kumbáyowana aaigówé su'mai kwíyómpakemba séna emá kesááninko óna'a ená imáyáa kwée'a ávááraumai aamoí umánkaumne siráiye. Yóni Áánútuna áséi-kwasai kwésimatimumbanivo Káríri-marara-kawaanako áwí'a Érótima áváko awainínkó áwí'a Erotíyasimba mairówana mindáyavena ó'on-o'on-tantaa'a sáwí'a uráintavena Yóni séna sáwísawaa kwéone súwana Éróti Yónimba áí'mai ándáva'a ankéna mindáyavena sáwí-mayai maimaéna iráiye. ");
INSERT INTO kze_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ísu marapá'á kumbéna kaumbo-síyáánkáí-ímá maisuwéna kwénaaena Áánútun-aai simátiminimba ááimba asówasa kwaási imáyáa ésa sésa Yósépi ááninkoman-iye kwésewe. Yósépi avowá áwí'a Írai úwana ");
INSERT INTO kze_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Írai avowá áwí'a Mátáta úwana Mátáta avowá áwí'a Árívái úwana Árívái avowá áwí'a Méokai úwana Méokai avowá áwí'a Yánai úwana Yánai avowá áwí'a Yósépi úwana ");
INSERT INTO kze_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yósépi avowá áwí'a Mátátayasi úwana Mátátayasi avowá áwí'a Émósi úwana Émósi avowá áwí'a Néamu úwana Néamu avowá áwí'a Ésérai úwana Ésérai avowá áwí'a Nágai úwana ");
INSERT INTO kze_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nágai avowá áwí'a Méata úwana Méata avowá áwí'a Mátátayasi úwana Mátátayasi avowá áwí'a Sémeni úwana Sémeni avowá áwí'a Yóséke úwana Yóséke avowá áwí'a Yóta úwana ");
INSERT INTO kze_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yóta avowá áwí'a Yóánana úwana Yóánana avowá áwí'a Árésa úwana Árésa avowá áwí'a Sérápápeo úwana Sérápápeo avowá áwí'a Síátio úwana Síátio avowá áwí'a Nérai úwana ");
INSERT INTO kze_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérai avowá áwí'a Méokai úwana Méokai avowá áwí'a Étai úwana Étai avowá áwí'a Kósamu úwana Kósamu avowá áwí'a Éómetamu úwana Éómetamu avowá áwí'a Eyá úwana ");
INSERT INTO kze_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eyá avowá áwí'a Yósúwa úwana Yósúwa avowá áwí'a Éríyesa úwana Éríyesa avowá áwí'a Yórimu úwana Yórimu avowá áwí'a Mátáta úwana Mátáta avowá áwí'a Árívái úwana ");
INSERT INTO kze_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Árívái avowá áwí'a Símiyoni úwana Símíyoni ávowá áwí'a Yútaa úwana Yútaa avowá áwí'a Yósépi úwana Yósépi avowá áwí'a Yónamu úwana Yónamu avowá áwí'a Éráyakimu úwana ");
INSERT INTO kze_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Éráyakimu avowá áwí'a Méríya úwana Méríya avowá áwí'a Ména úwana Ména avowá áwí'a Mátáta úwana Mátáta avowá áwí'a Nétáani úwana Nétáani avowá áwí'a Tévíti úwana ");
INSERT INTO kze_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tévíti avowá áwí'a Yési úwana Yési avowá áwí'a Ópéti úwana Ópéti avowá áwí'a Póási úwana Póási avowá áwí'a Sára úwana Sára avowá áwí'a Násoni úwana ");
INSERT INTO kze_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Násoni avowá áwí'a Ámínátapa úwana Ámínátapa avowá áwí'a Á'mini úwana Á'mini avowá áwí'a Ánái úwana Ánái avowá áwí'a Éséroni úwana Éséroni avowá áwí'a Pérési úwana Pérési avowá áwí'a Yútaa úwana ");
INSERT INTO kze_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yútaa avowá áwí'a Yákópo úwana Yákópo avowá áwí'a Áísákaa úwana Áísákaa avowá áwí'a Ááváramu úwana Ááváramu avowá áwí'a Téra úwana Téra avowá áwí'a Né'o úwana ");
INSERT INTO kze_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Né'o avowá áwí'a Séráka úwana Séráka avowá áwí'a Áríyu úwana Áríyu avowá áwí'a Péréki úwana Péréki avowá áwí'a Ípa úwana Ípa avowá áwí'a Síra úwana ");
INSERT INTO kze_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Síra avowá áwí'a Kénááni úwana Kénááni avowá áwí'a Avakatí úwana Avakatí avowá áwí'a Sému úwana Sému avowá áwí'a Nówaa úwana Nówaa avowá áwí'a Árémeki úwana ");
INSERT INTO kze_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Árémeki avowá áwí'a Métúsara úwana Métúsara avowá áwí'a Ínóki úwana Ínóki avowá áwí'a Yéréti úwana Yéréti avowá áwí'a Má'árario úwana Má'árario avowá áwí'a Kénááni úwana ");
INSERT INTO kze_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kénááni avowá áwí'a Ínosi úwana Ínosi avowá áwí'a Séti úwana Séti avowá áwí'a Áándamu éna kwemá Áánútu áánimban-iye. miwí Ísu aíkwá'ná owé-ímáyáá uráawe. ");
INSERT INTO kze_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yóni Ísumba nombá pérankaronka'a Áánútun-amankoma Ísumba anómba kwéumankena simámuwana Ísu Yótáni-nomba tuwéna kavóná-marava'a komáyowana ");
INSERT INTO kze_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Sáátáánigo Ísu sáwí'o índa awánanae kwésuwana Ísu íma toómbá nombá ména kae-kwááí aíyayaan-do'waamba 40 no'waamba kwaúwana ávááran-aai ankówana ");
INSERT INTO kze_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sáátáánigo séna emá Áánútu áánimba úne kwésempo maanóntánkóntáváí toómbá aúréna'a naanó siyó súwana ");
INSERT INTO kze_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ísu séna Áánútun-aai aúváí-kwandaaivinkemba séna toómbó náíyawaiye su'mai kwaási íma tátoranivo Áánútu siráini'a amápa'a íyana tátoraniye siráimba pó'a emó sénda íma mirá ónaumne súwana ");
INSERT INTO kze_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sáátáánigo Ísumba áí'maena iyéna avekáán-umai amápa'-marava'a kárákwiron-kwaasi agaráárankena ");
INSERT INTO kze_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","séna amápa'-marava'o kárákwiyuwo sénamo símakaimba moóráwaimba kesí imáyáavinkemba kanaán-umai timénaunda isa'á embá áménana enáwí'a iyíníye. ");
INSERT INTO kze_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","kesí imáyáamo mósá máréna'o é'a kárákwiyi-mayai áména kárákwiyiniyone Sáátáánigo súwana ");
INSERT INTO kze_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ísu séna Áánútun-aai aúváí-kwandaaivinkemba séna kesí Ísóigo Áánútumba imáyáa é'a kwenáwíre su'mai mósá maré'a kwená mayáíyé su'mai máyáaro siráimba pó'a emó sénda íma mirá ónaumne súwana ");
INSERT INTO kze_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Sáátáánigo Ísumba áí'maena Yérúsaremu-naopa'a kwéna anóm-bono'-nankona ávúmayaapa'a móankena séna Áánútun-aai aúváí-kwandaaivinkemba séna Áánútu kwíyómpakemba kwená kwayó'nárawa'a ti'maráínasa enká'á kárákwiyonaaowe. ó'omba séna óntanka'a aísamaima turaráanavo sésa tiyáándei aramónááowe siráiye. miráumai emá Áánútu áánimba úne kwésempo maankákémbá ásávenasa kwíyómpakendarawa'a arámbaesa marapá'á móru ankánááowe Sáátáánigo súwana ");
INSERT INTO kze_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ísu séna Áánútun-aai aúváí-kwandaaivinkemba á'a mirá siréna moórá-ainkwara'a séna kentí Ísóigo Áánútumba áísaa umai isánáe íma seró siráimba emó séndantembo mirámó ékai Áánútumba áísaa umai isáúsino. mindáyavai emó sénda íma mirá ónaumne Ísu súwana ");
INSERT INTO kze_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sáátáánigo amápa-tantaatavena Ísumba áísaa umai ísáiyuwena séna sáwíyanka'a ó'a taáísaa umai isánaumne séna auwéna kuráiye. ");
INSERT INTO kze_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","kúwana Áánútun-amankona asirayámbá Ísumpimba kwáyowana Ísu kavóná-marava'a tuwéna Káríri-marava'a komáyowasa kwenááigo amápa'-mapa'a kóyáwé úwana ");
INSERT INTO kze_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","miwítí mono'-náúmpímpá'á Ísu simátimuwasa amáparawai kwenáwí'a mósá makáawe. ");
INSERT INTO kze_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","minkákémbá Ísu kítokomo maémáin-daopa'a Násáreti-naopa'a koména Yútaa-kwaasi monor-áímbá kwéison-kanaama aasiyaasi-táwai mono'-náúmpá'á umaémáintemba miráumai uména Áánútun-aai aúváí-kwandaaivinkemba simátimindayavena usásinowasa ");
INSERT INTO kze_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","naaóvá'á Áánútun-aai sirówai Áísáya agaimakón-kwandaai ámúwana mairéna kwéarirena moórá-aimba awánéna táámpamai séna ");
INSERT INTO kze_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ísóigon-amanko kesé máyáiye. úwoi-kwaasiyavai kesí áséi-kwasai kosimátimiyo séna si'mákaimba póna Ísóigon-amanko kesé máyáiye. tátokaan-kwaasiyave'a kemá ayútínkáana'a máéro siyé-áímbá kosimátimiyo. túrambo kavíkáin-kwaasiyavai ó'a túramba awánamai kawe'á umátinkaao-aimba kosimátimiyo. tirumbó umbaimó táínda-kwaasiyavena minúmbáí-yántáá'á ánásaniye siyé-áímbá kosimátimiyo. ");
INSERT INTO kze_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ísóigo kwená kwaási kawe'á umátinkanin-kanaagon-aai kosimátimiyo séna si'mákaiye agaimaréna siráiye Ísu simásuwena ");
INSERT INTO kze_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","mináúváí-kwándááí tavúmai kárákwirowaimba aména aaí simátimindayavena mara'á máyowasa mindáúmpá'á máyón-kwaasi aaí síníye úwasa aúrampimba karákówana ");
INSERT INTO kze_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ísu séna mináímbá táámpamai súna'a iséiraan-aimba avora'á kwévaariye súwasa ");
INSERT INTO kze_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","isésa aiva'á kawer-áímbá kwésiye sésa aamoí umánkesa naaémba anón-imayaa ésa sésa Yósépi ááninko éna maankákéwáí póna kesáámó úndanten-kwaasiman-ivo nóra séna mirán-áímbá kwésiyo suwaná ");
INSERT INTO kze_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ísu séna kwaási kwántámai-aimba sésa emá sontaa-kwáásí ómpo enáúra'a eyááríka'a kawe'á uwó kwésewe. mináímbá kentávé'a simásuwe'a sé'a Kápénéamu-naopa'a kawe'-máyáí mairáanata ísaraumpo maanká ená naaópakwara'a mirám-báyáí mayaaó kentávé'a sénááombanivo ");
INSERT INTO kze_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","árai'a simátime'a sé'a Áánútun-aai simátímíwai kwená kwaásitopa'a Áánútun-aai kosimátiminiyenamo kwimbá kwenamááraa sésa kesáámó úndanten-kwaasiman-iye sésa kwenáwí'a íma mósá kwémaraawe. ");
INSERT INTO kze_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","árair-aimba sénaumpo ísáaro. naaóvá'á Áánútun-aai simátímakowai áwí'a Íráiyaa máyonka'a kaumbo-ímá umái ava'moraé-kwiyomba maisuwéna íma aa'á téna ayawaimá tówana minkánáámá Ísareri-kwaasiti maravá'á ketor-ínímbá sáwíva'a máyówana ");
INSERT INTO kze_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Áánútu íma minkétór-ínímbá kotúwa'naa íníyone séna ó'om-baravaken-ketor-inimba Sáítóni-marava'a Sárévati-naopaken-inimba koáwa'naa uwó séna Áánútu Íráiyaamba ai'marówana kuráiye. ");
INSERT INTO kze_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","naaóvá'á moóráwai Áánútun-aai simátímakowai áwí'a Íráisa máyonka'a Ísareri-kwaasiti maravá'á túma karón-kwaasi sáwíva'a máyówana Áánútu minkwáásíyómbá íma asóvamatinkaraimbanivo ó'om-barava'a Síriyaa-maravaken-kwaasi áúma karón-kwaasi áwí'a Néamanimba asóvamankaraiye Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","mimbónó'-náúmpá'á máyówai isésa imáyáa ésa kentááyávéna Áánútu íma túwa'naa íníye Ísu siyé sésa tirunkó ikaa'á vówasa ");
INSERT INTO kze_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","usásinesa Ísumba tátokesa tavisímaesa máápa'a kunákáruwesa miwítí naaór-omapa'a ámémpa'a améntáyuwanae uwaná ");
INSERT INTO kze_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ánivo Ísu minkwáásímívinkemba tuvíyuwena kóuraiye. ");
INSERT INTO kze_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ísu Káríri-marava'a Kápénéamu-naopa'a koména Yútaa-kwaasi monor-áímbá kwéison-kanaara'a mono'-náúmpá'á uména aaí simátimuwasa ");
INSERT INTO kze_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","isésa asiramái súntavesa anón-kwaasigoraamba siyé sésa táátavai uráawe. ");
INSERT INTO kze_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","táátavai uwaná mimbónó'-náúmpá'á moóráwai taraváá-kwámbá kwenarumpimbá máyon-kwaasigo ména anónka'a séna ");
INSERT INTO kze_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ísu Násáretivakewai óne. kentáá nóra éwa tasínkambaiya ánásaniyono. embá awánáúndawai Áánútuna kawe-kwáyó'ná'á óne súwana ");
INSERT INTO kze_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ísu taraváá-kwántávéna asiramái séna aaiseré minkwáásí tiyuwé kóaao súwana mintáráváá-kwánkó minkwáásí toká'mái túranka'a tuvámbarena íma sáwí'a umánkena úwoi kóúwasa ");
INSERT INTO kze_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","awánésa táátavai ésa keáímbá sésa nóran-aina kwésiyo. asirayán-áímbá taraváá-kwántávéna asiramái kwésimatimisasa tirumpinkémbá kwégowe suwaná ");
INSERT INTO kze_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","mirán-áímbá Ísun-aai mináyámpá'á kóyáwé úwasa ísaraawe. ");
INSERT INTO kze_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ísówana Ísu mimbónó'-náúmpá'á tuwéna Sáímonina naaúmpa'a íyúmba Sáímoni aísáankomba kokotámba kwéankowana máyowasa Ísumba simámúwana ");
INSERT INTO kze_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","iséna kwenópa'a téna kokotánkontavena séna ánásaao súwana minkókótámba ánásowana usásinkwena toómbá agaimái tímakaiye. ");
INSERT INTO kze_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","toómbá agai-timúwasa enónka'a ó'on-o'on-ti'o ún-kwaasi tí'maesa Ísunopa'a mátínkówana ayáámba tátorowasa asóvaraawe. ");
INSERT INTO kze_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","mirá úwasa taraváá-kwámbá sáwíva-kwaasi tirumpinkémbá tiyuwésa anónka'a sésa Áánútu ááninko óne simásuwesa kóuraawe. taraváá-kwámbá imáyáa ésa Ísuntavesa Áánútumo usásinankaiwaima iyé-ímáyáá untávéna Ísu aaiséráaro súwasa tiyuwésa kóuraawe. ");
INSERT INTO kze_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","kóuwana aaváúmá usónka'a Ísu mindáópa'a tuwéna námúnaa síndayavena íma kwaási máyópa'a komáyowasa avakáá-umai awánésa sésa kónavo keséya maiyó suwaná ");
INSERT INTO kze_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ísu séna ó'on-daopimpakwara'a áséi-kwasai Áánútu kwená kwaási kwégawaain-aimba kosimátimenaumne. mirá ónaundayavena Áánútu si'mákaisa'a kunkáumne séna ");
INSERT INTO kze_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","tiyuwéna Yútiyaa-ayampa'a koména mono'-náúmpímpá'á simátíma'maena iráiye. ");
INSERT INTO kze_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","moórá-tawai Ísu nonkwaaúnkón-awampa'a áwí'a Kénésáréti-kwaaunkon-awampa'a máyowasa Áánútun-aai isánáe sésa tóyo ésa kwenkuvará'á úmaesa tuwaná ");
INSERT INTO kze_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","3","kae'á sáwíyan-dompi-sipi nonáámááíva'a kwáyowana moórá Sáímonindei kwáyowana awánówasa noyáá'a tóróyan-kwaasi mindómpí-sípí tuwésa kwase-únámbá kwésese uwaná misípí úwoi kwáyowana awánéna Sáímonina nompí-sípívímbá usáatena Sáímonintavena séna egwaa'á maimaé kwaaó súwana egwaa'á avúsúmaena nonawámpá'á kúwana Ísu mimpímbá mara'á ména amápa-kwaasi simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","simásuwena Sáímonintavena séna nompí-sípí avúsúmae nonavuvumpá'á kuré egwárá ená kwaásigwara'a kwase-únámbá túwéwana nompímbá kumína'a noyáá'a asínáaro súwana ");
INSERT INTO kze_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sáímoni séna anóndakoo ívé'-no'waamba mirá úmae iyúndaya íya noyááta asinéta úwoiya máyaundayaanivo emó séndantemba ónaumne séna ");
INSERT INTO kze_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","nonavuvumpá'á kwésa kwase-únámbá túwówana nompímbá kumúwana sáwíva'-noyaa'a minúnámpímbá ógwitena taráráára'naraamba úwasa ");
INSERT INTO kze_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","moórá-nompi-sipivimba miwítí kwaási máyówasa awánésa tiyáán-tuwaa'a ésa tasúwa'naa oro suwasá tésa minkáé-sípívímbá noyáá'a mósá márówana ógwitena umbaí téna nompímbá kunávekora'naraamba úwana ");
INSERT INTO kze_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sáímoni Pítaa mirámó úmba awánéna Ísuma anóndakoman-iye séna aísamaivimba kívairena séna Ísóigoo sáwí-kwaasi úmpo siyuwé kwaaó siráiye. ");
INSERT INTO kze_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","sáwíva'-noyaa'a asínóntavena Pítaawe kwesé máyón-kwaasiye táátavai uwasá ");
INSERT INTO kze_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sáímoniye noyáá'a to'maésarai nááúyawai Sépéti ááninkai túwí'a moóráwai Yémési úwana moóráwai Yóni mindáraiye táátavai uyaná Sáímoni Pítaa Ísuntavena séna Ísóigoo sáwí-kwaasi úmpo siyuwé kwaaó súwana Ísu séna íma áá'a kaíno. noyáá'o to'maé kwénaaomba mimbáyáí ivátuwe'a ívé'a kwaási tavisíyasa kesirááíma kwáráaro súwasa ");
INSERT INTO kze_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","mindómpí-sípí tavisímaesa nonáámááíva'a mámaresa miwítí mayáímá ivátuwesa Ísun-ánaaemba kwa'maésa kwénaaowe. ");
INSERT INTO kze_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","moórá-tawai Ísu moórá-naopa'a máyowana moóráwai amápa-kuva'a áúma karón-kwaasi Ísumba awánéna anóndakoman-iye séna aísamaivimba takívairena séna kentávénamo ankáínamo e kanaán-umai aúnái'a umásinkaniyone súwana ");
INSERT INTO kze_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ísu ayáámba ane'á tátorena séna mirá ónaumpo enáúra'a karevú'a kawáúgwiye súwana avekáámbá kawáúguwana ");
INSERT INTO kze_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ísu asiramái séna enáúra'a kawáúgwimba po naaóvá'ó Mósesimo siráintemba mono'-máyáí-kwáásítópa'a kwéma enáúma máagaraatinke póíma tímínasa Áánútuntavesa ísámai tuvú'mái agayáíyasa amáparawai awánésa áúrakemba kawáúgwiye sénááowe. ánivo enáúra'o umánkaunda-aimba simátimunavo se kwaaó Ísu súwana ");
INSERT INTO kze_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ivátuwena kawe'á umánkon-aimba simátíma'maena iyúwana mináínkó naaó'-nao'a kóyáwé úwasa sáwívarawai tóyo ésa kwenáái kwéise'a onaná tí'o in-kwáásí asóvamatinkainkwae sésa tóyo uwaná ");
INSERT INTO kze_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ánivo Ísu Áánútumpa'a námúnaa síndayavena kavóná-marava'a kóyo uráiye. ");
INSERT INTO kze_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","moórá-tawai évakarawai ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé Yérúsaremu-naopakemba Káríri-ayampakemba Yútiyaa-ayampakemba tóyo ésa Ísu moórá-naumpa'a aaí kwésimatimumba taísaraawe. Áánútu Ísumba asóvamatinkanin-asirayamba ámakowana máyowasa ");
INSERT INTO kze_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","évakarawai aísamaimo pukówaimba kwandaaivímbá marésa taagwiya'maésa tésa Ísunopa'a máánkáananaya kawe'á ínkwáe sésa tumbá ");
INSERT INTO kze_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","mindáúmpá'á sáwíva-kwaasi sisipáá uwasá íma kanaán-umai íyóra'naraan-esa naanamiva'á taagwiya'maésa umésa avaa'á akósámaresa ándára tátoresa túwówana kumeémena kwaásivimbo Ísumo máyompimba aúranka'a kumúwana ");
INSERT INTO kze_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ísu taagwiya'maésamo tun-kwáásímó árai'a kawe'á umánkaniye-imayaamo umbá Ísu tuwánéna aísamaimo pukón-kwaasiyavena séna kesí kwaásiyo ená sáwí-imayaa mayauwáúmne súwasa ");
INSERT INTO kze_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé iséise esa sésa Áánútu kweyáá sáwí-imayaa maitiyuwánívo kwaási íma mirá ónááovo Áánútumba aká'áámba kwésimankaiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ísu minímáyáámó umbá awánéna séna nóra éra mirán-ímáyáá kwéoo. ");
INSERT INTO kze_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","moóráwaimo aísamaimo pukáindawaintavaimo sénamo ená sáwí-imayaa mayauwáúmne sínasamo ésa áraira sií. kampará siíyo sénááowe. ánivo moóráwaimo aísamaimo pukáindawaintavaimo sénamo eyááríka'a usásine kwaaó sínasamo ésa áraira sií. kampará siíyo awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","kemá kwaási úranda'a kumpaáruraundawai marapá'á máyaunda kwaásiti sáwí-imayaa maitiyuwáúnda-asirayamba tokáunda pó'a agaráátínkáanda awánanaaowe séna aísamaimo pukón-kwaasiyavena séna isaaó. usásinke ená kwandaaimá maimaé ená naaópa'a kwaaó súwana ");
INSERT INTO kze_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","túranka'a usásinkwena kwená kwandaaimá kwémaena Áánútu áwí'a mósá kwémarena kwená naaópa'a kúwasa ");
INSERT INTO kze_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","amáparawai táátavai ésa Áánútu áwí'a mósá marésa sésa íma awánaraundai'a isa'á awánáúmne sésa táátavai ésa tiyáámba tóipimba áákaawe. ");
INSERT INTO kze_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","naaémba Ísu aampa'á kwégwena awánómba táákísi-mayai kwémayowai áwí'a Árívái táákísimo máyón-daumpa'a máyowana Ísu awánéna séna usásine kesé tiyó súwana ");
INSERT INTO kze_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","usásinena amápa-tantaa'a tuwéna kwenánaaemba kwa'maéna kwéna ");
INSERT INTO kze_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ísuwe náíndayavena kwená naaúmpa'a anón-tomba agayówasa táákísimo máyón-kwaasiye ó'on-o'on-kwaasiye Áríváina naaúmpa'a tamésa mindáraiye tamésa tagwémandowasa ");
INSERT INTO kze_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ámáán-kawaa-kwaasiye miwítí ámáámba sun-kwáásíyé Ísuna kwayó'nárawatavesa áwáá'a tiyésa tísaa esa sésa táákísi máyáan-umoyan-kwaasiye sáwí'a on-kwáásíyé toómbá kwénaao suwaná ");
INSERT INTO kze_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ísu iséna séna sontaa-kwáásígó kawe'ó umáímo máyáan-kwaasi íma kwétuwa'naa-ivo tí'o in-kwáásí kwétuwa'naa-iye. ");
INSERT INTO kze_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","mindáyave'a arupí umái máyáan-kwaasi tááyaanasa Áánútunopa'a tígwáe sé'a íma kunkáumpo sáwí'o umáímo máyáan-kwaasi tááyaanasa Áánútunopa'a tígwáe sé'a kunkáumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","suwasá évakarawai Ísuntavesa sésa Yóni nombó pétinkaiwaina kwayó'nárawa'a moórá-mora-tawai Áánútuntavesa imáyáa ésa toómbá íma kwénesa námúnaawe su'mai kwésewasa ámáán-kawaa-kwaasiti kwayó'nárawakwara'a mirá kwéovo ená kwayó'nárawa'a íma mirá ésa toómbá nombá úwoi kwénaawe. nóra ésa mirá kwéoo suwaná ");
INSERT INTO kze_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ísu séna moóráwai aaraí mayáíndawai amááraawi tanómba kauntimínímba miwísé máyainasa aamoí ésa mintómbá íma a'áo sénááovo úwoi nánááowe. ");
INSERT INTO kze_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","naaémba minkwáásígómbá áí'maesa kówíyasa minkánáámá amááraawi tirunkó sáwí'a ínasa toómbá a'áo sénááowe Ísu séna kwemó ménamo naaémbo tiyuwénamo iyíníntavena mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ísu mináímbá simásuwena maarán-áímbá kwántámai-aimba séna ááéraan-ampantamo avaa'ó kwáyáísasamo ombá aúná-ampanta íma kárámai kwéaraapaawe. mirámó íyana aúná-ampanta sáwí'a ínana ááéraan-ampantao aúná-ampantaraani'a íma íníye. ");
INSERT INTO kze_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","aúná-anda-aran-domba ááéraa-sipisipi-auwarasi-anaveumpimba íma kwéatimaraawe. mirámó íyanamo éna aúná-anda-aran-domba anón-éna ááéraan-anaveumba kavámbaena sáwí'a ínana mindómbá úwoiva'a atígwiniye. ");
INSERT INTO kze_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","mindáyavesa aúná-anda-aran-domba aúná-sipisipi-auwarasi-anaveumpimba kwéatimaraawe. ");
INSERT INTO kze_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ááéraan-anda-aran-domba naawáímó ombá sésa ááéraan-anda-aran-domba áséi kwéiye kwésesa aúná-anda-aran-domba íma kwésinkaiye kwésewe. ");
INSERT INTO kze_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","moórá-tawai Yútaa-kwaasi agándon-kanaara'a Ísuwe kwená kwayó-kwáásíyé kígauvimba úwíti-ton-kigauvimba kwégwesa kwená kwayó-kwáásí úwíti-aramba kútúmai ásima pítuwesa kwénowasa ");
INSERT INTO kze_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ámáán-kawaa-kwaasi évaka'a tuwánésa sésa agándaan-kanaama aambá áúmbakaawa'a nóra era mirá kwéoo suwaná ");
INSERT INTO kze_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ísu séna naaóvá'á Tévítimo urómba aúváívimba agaimarón-ainkona ááimba íma ísaraawe. Tévítiye kwená kwaásiye táái kwétinkowana ");
INSERT INTO kze_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tévíti Áánútuna mono'-náúmpá'á iyéna Áánútu aúranka'o makón-tomba umairéna kwénena kwená kwaási timúwasa narááwe. mintómbá úwoi-kwaasi íma némáembanivo mono'-máyáí máyón-kwaasi némáembani. Tévíti mintómbá umairéna timúwasa nonká'á Áánútu íma áwáá'a siráimbanivo kesí kwaási mirá kwéowa'a áwáá'a ímo seráámbá áwáá'a kwésewe. ");
INSERT INTO kze_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","kwíyómpakemba kwaási úranda'a pó'a agándai-kanaara'o kárákwiraundawai úmpo agándai-kanaamo kwaásimo mayáí kwémayaamba kendéímán-iye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","moórá-tawai Yútaa-kwaasi agándon-kaaara'a Ísu mono'-náúmpá'á iyéna kwésimatimuwana moóráwai ayáánúrapar-ayaamba kawévaiguron-kwaasi máyowasa ");
INSERT INTO kze_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé mésa Ísuntavesa agándaira'a póna minkwáásímó kawe'ó umánkainataamo éta táto'maiya aaivintá mayankánaumne sésa Ísumba awánomba ");
INSERT INTO kze_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ísu minímáyáámó umbá awánéna ayáámba kawévaiguron-kwaasiyavena séna usásine kemó máyaundara'a umaiyó súwana usásinena Ísunopa'a túranka'a umaúwana ");
INSERT INTO kze_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ísu miwíyávéna séna moórá-aintave'a tísaa ónáe'a súne. kentáásí ámáán-aimpimba nóin-aina kwáyáiyo. agándai-kanaara'a póta kawe'-máyáíyá kwémayaum. sáwí-mayaiya kwémayaumno. kwaási áwa'naa onanayá kawerá umáíya méni. inkámónanaya puwíníyo tísaa ena súwasa íma aaí suwaná ");
INSERT INTO kze_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ísu móyuwana meyuwana éna ayáámba kawévaiguron-kwaasiyavena séna enayáámba árútuwaao súwana ayáámba árútuwowana kawe'á umánkowasa ");
INSERT INTO kze_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","miwí tirumbá ávááraumai sáwí'a úwasa nóra umáíya inkamónaumno sésa kemó máyómpimba iséise uráawe. ");
INSERT INTO kze_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","minkánáávímbá Ísu enónka'a omápa'a uména íma aúmá kwaéna Áánútumpa'a námúnaa símaena kwéiyuwana ");
INSERT INTO kze_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","móirarowana Ísun-ánaaemba kwarón-kwaasi tááyowasa íyúwana minkwáásívínkémbá sísamaivakemba kae'á kumbaimái-kwaasi táámpámarena séna kesí aantá-kwaasin-owe séna túwí'a taráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","miwí túwí'a téna moóráwai áwí'a Sáímoniye séna aúná-kwi'a tamámena Pítaawe súwana séna moóráwai Pítaa áváko áwí'a Éndaru moóráwai áwí'a Yémési moóráwai áwí'a Yóni moóráwai áwí'a Vírípi moóráwai áwí'a Pátóromu ");
INSERT INTO kze_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","moóráwai áwí'a Mátíyu moóráwai áwí'a Tómáasi moóráwai Árávíási ááninko áwí'a Yémési moóráwai áwí'a Sáímoni kwemá Árómáani-kamaani-kwaasi ti'mátuwanae siráiwai ");
INSERT INTO kze_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","moóráwai Yémési ááninko áwí'a Yútási moóráwai Yútási Isakéríóti kwemá naaémba Ísumba kwená namuro-kwáásírá'á agaráátínkaraiwai miráumai-kwaasi Ísu tááyaraiye. ");
INSERT INTO kze_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","omápakemba Ísu miwísé arúvá'á kumbáyowasa kwenánaaemba kwarón-kwaasi sáwívarawaiye Yútiyaa-ayampakemba Yérúsaremu-naopakemba uwí-nón-awampakemba Táyaa-naopakemba Sáíntóni-naopakemba sáwíva-kwaasiye tamésa ");
INSERT INTO kze_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ísun-aai isánáe sésa tí'a ún-kwaasigwara'a asóvamatinkainkwae sésa tóyo ésa taraváá-kwámbá tirumpimbá máyón-kwaasigwara'a tóyo uwaná Ísu taraváá-kwámbá tirumpinkémbá maitiyuwówasa ");
INSERT INTO kze_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","tí'a ún-kwaasi Ísun-ane'a tátoraanana sí'a ánásainkwae sésa mirá uwaná asirayámbá tokéna póna mintí'á asóvamatinkaraiye. ");
INSERT INTO kze_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ísu mirá umátiyuwena kwená kwayó-kwáásí tuwánéna séna keinárawa'a Áánútu súwa'naa ínkwáe sewáí Áánútu kawe'á kwéumatinkena kwégawaaiye. ");
INSERT INTO kze_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ívé'a táái kwétinkaiwai tirumbá etóyóí umái máéro. Áánútu kanaa umátinkaniye. ívé'a tirumbá sáwí'a kwéisasa ivi'á kwétaawai tirumbá etóyóí umái máéro. tirumbá kawe'á ína'a kwíráái sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","keinárawa'a kemá kwaási úranda'a kumpaáruraundawaintave'a asiramái máyáawai kwaási tínaaembo umátinkesa tíyámbo umátinkesa sáwí-aimbo simátinkesa sáwí-kwaasin-owe sénááomba tirumbá etóyóí umái máéro. ");
INSERT INTO kze_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","mirá íya'a tirunkó kawe'á kwéina'a imá kwéte'a kwíyómpakemba kentí kawe'-méyámbá mayánááowe. naaóvá'á miwítíkwá'ná mirá ésa Áánútun-aai simátímakowai sáwí'a umátínkaraawe. ");
INSERT INTO kze_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ánivo marapákén-tántáá'á makáawaima kárákwiyoro. tirunkó kawe'á kwéin-tantaa'a á'a makáamba pó'a íma moóráma kawe'-méyámbá mayánááowe. ");
INSERT INTO kze_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ívé'a tímú'a vaiwáí kárákwiyoro. naaémba táái tinkáníye. ívé'a kwíráái kwésewai kárákwiyoro. naaémba ivi'á tánááowe. ");
INSERT INTO kze_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","naaóvá'á kentíkwá'ná kampar-áímbá simátímakowai túwí'a mósá makáamba pósa mirámó kwésesamo kentúwí'o mósá kwémarewa'o é'a kárákwiyoro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ísu simásuwena séna kemó simátíménda-aimba ísáaro. kesááimo isé'o é'a kentí namuro-kwáásí tirumbá kawe'á umátinke'a tíyámbo umátínkéwai kawe'á umátínkáaro. ");
INSERT INTO kze_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","sáwí-aimba simátínkéwai kawe'á umátínkáaro. sáwí'a umátínkéwaimo é'a Áánútumpa'a námúnaa simái miwí túwa'naa oro. ");
INSERT INTO kze_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","táá'o tuwausíya'o é'a íma tinkamé'a ókwara'a kwántá-timiyasa tuwausónááowe. kentí unáánkwátói mairésa sésa ókwara'a mayánáe síya'o é'a íma a'áo seró. ");
INSERT INTO kze_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","moórá-yantaatavaimo simiyó síya'o é'a úwoi tíméro. kendéímo moórá-yantaa'o máyáíya'o é'a íma usisi'á síméro seró. ");
INSERT INTO kze_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","kembó tirááímo táínda-i'o umáímo kwétuwa'naa-iya'a miwí miráumai túwa'naa oro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ísu simásuwena séna amáparawai kentí kwaásiti imáyáamo kwéowasamo ombá anondá miwítí imáyáa kwéowe. sáwí'o kwéon-kwaasi íma kawe-kwáásí ombánivo miwítí kwaásiti imáyáamo kwéowasamo ombá anondá miwítí imáyáa kwéowe. miráumaimo kentí kwaásiti imáyáawe su'maimo kwéiyanamo éna Áánútu íma kawe'-méyámbá timínívo kentí namuro-kwáásígwárá'á imáyáa tíméro. ");
INSERT INTO kze_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","amáparawai kawe'á kwéumatinkaan-kwaasi kawe'á kwéumatinkaawe. sáwí-kwaasigwara'a mirá kwéowe. mirámó onten-umái kawe'ó kwéumatinkaan-kwaasiye su'maimo kawe'ó umátínkéwanamo éna Áánútu íma kawe'á owé síníye. kentí namuro-kwáásígwárá'á kawe'á umátínkáaro. ");
INSERT INTO kze_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","sáwí-kwaasi naaémba siménááowe-imayaa ésa kwétimewe. naaémbo timénááon-kwaasiye su'maimo timíyanamo éna Áánútu íma kawe'á owé síníye. naaémba siménááowe-imayaa íma é'a úwoi tíméro. ");
INSERT INTO kze_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","kentí namuro-kwáásí kawe'á umátinke'a imáyáa tíméro. anondá simígwáe-imayaa íma é'a úwoi tíméro. mirámó íyambo é'a Áánútumpakemba kawe'-méyámbá mayánááowe. Áánútu kwentávésa íma súwi sen-kwáásí úwoi kwétuwa'naa-ena sáwí-kwaasigwara'a mirá kwéisasa pósa kwaási keinárawa'a mirámó ombá tuwánésa sésa Áánútu kwíyómpakewai áánimbaa'a owé sénááówe. ");
INSERT INTO kze_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","kentivomá arumbá kwéumatinkaintemba mirá oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","tuwáné'o é'a sáwí-kwaasiye síyanamo éna Áánútu kentáváígwárá'á mirá sínívo tuwáné'o é'a sáwí-kwaasiye sevó. umbai-yántáá'ó timíyanamo éna Áánútu kenkwárá'á mirá ínívo umbai-yántáá'á tímévo. sáwí'o umátinkaiya'o é'a mináímbá íma tááka'a maré'a tuwinkásuwaaro. mirámó íyanamo éna Áánútu kemó sáwí'o ombá maitiyuwáníye. ");
INSERT INTO kze_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","timíyantemba Áánútu anondá kembá timíníye. toómbó tíméwasamo nawááesamo aráávara'o ontembá Áánútu mirá umái sáwíva-tantaa'a timíníye. miráumai tíméntemba Áánútu miráumai timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ísu simásuwena kwántámai-aimba séna moórá aúgavitawai moórá aúgavitawaimba ayáán-to'maesarai íma kanaán-umai kóyááoivo mirámó ésaraimo ésarai aísava'a tuvamóyááoiye. ");
INSERT INTO kze_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","kwená iyámpóímo agaráátínkáiwaimbo ombá íma kwembá kwéusayaaitaavo kwenáái ísámaesa kwemó intení'a kwéowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ísu simásuwena séna kentúrampimba irarumbá kwáyáísa'o ombá íma awánaamba kentí kwaási tuwáné'a enaúrampimba ayaantambá kwáyáiye kwésevo íma mirá seró. ");
INSERT INTO kze_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","kentúrampimbo irarumbó ímo awánaamba nóra sera kentí kwaási túrampinkemba tiyaantambá maitiyuwánáe kwéseo. kaumbo-káér-ainkwara-kwaasin-ovo kentúrampinkemba irarumbá maisuké'a tuwáné'a kentí kwaási túrampinkemba tiyaantambá kanaán-umai maitiyuwánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ísu simásuwena séna kawe-táígó íma sáwí-aramba iyáísana sáwí-taigo íma kawer-árámbá kwéiyaivo ");
INSERT INTO kze_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","mintáígó arambá awánésa sáwí-taiye kawe-táíyé kwésewe. tekómo éna íma áwí-yantaa'a iyánívo té'a iyáníye. ampaantarígo avo'árén-aramba íma iyánívo ampaantarí-aramba iyáníye. ");
INSERT INTO kze_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","miráumai kawe-kwáásí kawer-ímáyáávínkémbá kawe'-máyáí kwémayaavo sáwí-kwaasi sáwí-imayaavinkemba sáwí-mayai kwémayaawe. tirumpimbá kwáyáin-imayaanei kwésewe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ísu simásuwena séna kentáváí anóndako óne kwésembanivo kemó simátimunda-aimba íma kwa'mái kawe'á kwéowe. ");
INSERT INTO kze_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","kesópa'o tésa kesáái isésa kawe'á umái kwégwaraiyawai mirán-kwáásímó simátíméndara'a ísáaro. ");
INSERT INTO kze_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","naambá ónáe sésa maravímbá mai'á u'maésa kumeémesa óntamba kunavakáá-ésa minká'á naamayáámba aimái naambá úmaraiyana aa'á téna anón-kavirayan-domba kumínana mindámbá íma tawisínda asiramái kwéena óntanka'-namba póna úwoi kwéniye. miráráán-umai kwaásimo kesópa'o tésa kesáái isésa kawe'á umái kwégwaraawai asiramái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ánivo kesáímo isésamo ímo kawe'ó umáímo kwéisaawaima mirán-kwáásímó simátíméndara'a ísáaro. naambá ónáe sésa íma mai'á ukésa íyamba paáká'á úmakaiyana anón-a'a téna kavirayán-dómbá kuména mindámbá tawísíyuwainana sáwí'a íníye. miráráán-umai ímo kesááimo ísámaimo kawe'ó íyawai íma asiramái ménaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ísu mináyáátáár-áímbá simátímatuwena Kápénéamu-noapa'a komáyowana ");
INSERT INTO kze_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Árómáani-i-kwaasiti kawááná'á ména kwená kwayó'ná'á aráái tówaimba áí'a kwéuwana puwíndayavena kwéena máyowana ");
INSERT INTO kze_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","minkáwáánákó Ísumo tamáyon-aimba iséna Yútaa-anon-kwaasiyavena séna Ísumba koáí'mae'a tíyana taasóvamankaino séna ti'marówasa ");
INSERT INTO kze_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ísunopa'a asiramái kosésa minkáwáánákó Yútaa-kwaasiya kwésuwa'naa-ena kentáásí mono'-námbá úmakaimba póna kawe-kwáásí po kawe'á umái koáwa'naa íníyone suwaná ");
INSERT INTO kze_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ísu iséna miwísé kwéna minkáwáánákóná naambá egwaa'á kwáyonka'a kúwana minkáwáánákó kwená kwaási simátimena séna Ísunopa'a kosimáme'a maará simáméro. anóndakoo kentáásí kawáánákó séna kemá sáwíyan-kwaasi úmpo emá anón-kwaasi ómpo ivátuwe kesí naaúmpa'a íyínda uwóví'a íníyone. ");
INSERT INTO kze_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","mindáyavai íma enópa'a kosimámakaunda po íma kesí naaúmpa'a iyé úwoi aaiyé su'mai sinaná kesí kwayó'ná'á asóváíno. ");
INSERT INTO kze_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","kegwárá'á kawáá-máyáígóná ááimba awánaraunda kesí kawáánákó sisa'á kwená mayáí kwémae'a kesí i-kwáásíyávé'a súnasa kesí mayáí kwémayaawe. moóráwaintave'a sé'a kwaaó súnana kwégwisa'a moóráwaintave'a sé'a tiyó súnana kwétisa'a kesí kwayó'nátávé'a mirá uwómó súndantemba mirá kwéiye siyé. Ísumba kosimáméro súwasa ti'marówai tésa tasimámúwana ");
INSERT INTO kze_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ísu mináímbá iséna áátavai éna kogwanténa kwenánaaembo kwa'maésamo kun-kwáásíyóntávéna séna simátime'a sé'a minkwáásí Árómáani-kwaasigo kentávéna súwa'naa ií-ásíráyámbá tokáiye kwésivo kesí kwaási Ísareri-kwaasivinkene ó'on-kwaasivinkene íma mirán-áímbá kwésewe Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ti'marón-kwaasi koyauwerésa tésa taawánomba kwayó'ná'á kawe'á umái máyowasa taawánaraawe. ");
INSERT INTO kze_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ísu sáwíyanka'a ména tiyuwéna kwená kwayó-kwáásíyé sáwíva-kwaasiye kúmba Néni-naopa'a kwéna ");
INSERT INTO kze_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","mindáókona óntan-kurigona ontara'á kúnka'a moórá-ketor-ininko ááninko puwúwasa taagwiya'maésa sáwíva-kwaasi anówae kwétuwana ");
INSERT INTO kze_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ísóigo anówamba awánómba arumbá umánkena séna íma ivi'á taaó séna ");
INSERT INTO kze_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","kúkútaa-taira'a kotátorowasa taagwiya'maésa tun-kwáásí tamáúwana Ísu séna ívé-kwaasigoo usásinaao súwana ");
INSERT INTO kze_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","pukómpinkemba usásinena aaí kwésuwana Ísu anówantavena áí'mae kwaaó súwasa ");
INSERT INTO kze_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","amáparawai táátavai ésa Áánútu áwí'a mósá marésa sésa ívé'a Áánútun-aai sin-kwáásí anón-kwaasi kentáávímbá kwévaariye. Áánútu ai'máráísana kwená kwaásiya súwa'naa ií-kwáásíyá kúmiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","mináímbá Ísuntavesamo sun-áínkó Yútiyaa-ayampa'a évarevar-awampa'a kóyáwé uráiye. ");
INSERT INTO kze_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","mináínkó kóyáwé úwasa Yónina kwayó-kwáásí isésa Yónimba kosimámúwana kwená kwayó'nárai tááyowasarai tuyaná ");
INSERT INTO kze_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","simátimena séna Ísumba maanáímbá koáísaa okaiyó. emá kumíníyonemo siráawaiya'ono. á'owawa ónómpo kemá kumíníwaina amu'maránaumno siyé. kosekaiyó Yóni súwasarai isésarai ");
INSERT INTO kze_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ísunopa'a tasimámesarai Yóni nombá pétinkaiwai si'máráísakai enópa'a túye. Yónimo simbá kumíníyonemo siráawaiya'ono. á'owawa ónómpo kemá kumíníwaina amu'maránaumno siyé. Ísumba tasimámúyana ");
INSERT INTO kze_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","minkánáávímbá Ísu sáwíva-kwaasi ó'on-o'on-ti'a ún-kwaasi kawe'á umátinkena taraváá-kwámbá tirumpinkémbá kwémaitiyuwena túramba kavíkón-kwaasi túramba awánamai kawe'á uwaná ");
INSERT INTO kze_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ísu Yónimo ti'marón-kwaasiyavena séna tayauwerékai awánaan-tantaa'a ísáán-aimba Yónimba kosimámekai sékai túramba kavíkáiwai túramba awánamai kawe'á owaná táá'a kaúnkaiwai táá'a kwéisaawana tísamaima pukáiwai kawe'á umái tísamaima kwétaawana túma karáiwai kawe'á kwéumatinkena puwón-kwaasi kwéusasintinkena úwoi-kwaasi áséi-kwasai kwésimatimena séna ");
INSERT INTO kze_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","kentávéna íma kaer-ímáyáá íyawai tirunkó kawe'á kwéiye siyé. Yónimba kosimámékaiyo Ísu súwasarai kurááiye. ");
INSERT INTO kze_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yónina kwayó'nárai tayauwerésarai kuyaná Ísu Yónin-aai amápa-kwaasi simátimena séna Yóni kavóná-marava'a máyáísa'a koawáné'a nóran-imayaa kwéera koawánaraao. úndá toréna umá móma'mema'o intenkáán-kwáásí Yónima iyé-ímáyáá uráao. ímanivo Yóni íma mirán-kwáásímán-ivo asirayán-kwáásímán-iye. ");
INSERT INTO kze_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","nóran-imayaa kwéera koawánaraao. kawer-únánkwátói úmakainda-kwaasi Yónima iyé-ímáyáá uráao. ímanivo mirán-kwáásí kawer-únánkwátóigwara óísankwara-kwaasi anón-kwaasiti naaúmpa'a kwémaewe. ");
INSERT INTO kze_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","nóran-imayaa kwéera koawánaraao. Áánútun-aai kwésiwai Yónima iyé-ímáyáá uráao. owé. Áánútun-aai kwésiwaiman-iye. árai'a simátime'a sé'a kwemá Áánútun-aai siráawai usáyaaitaraiye. ");
INSERT INTO kze_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Áánútun-aai aúváí-kwandaaivimba Yónin-aai simái agaimaréna séna Áánútu séna isaaó. moóráwaimba ai'máráanana kesáái maimaéna ená aiva'á kwéna ená aambá kwiyíníye siráiye agaimaréna siráimba Yónintavena siráiye. ");
INSERT INTO kze_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","simátime'a sé'a Yónina mayáígó amápa-kwaasiti mayáígómbá usáyaaitaisana Áánútu kawe'á umánkaraivo Áánútu kwená kwaásira'o kawááin-kwaasi anón-kwaasiye úwoi-kwaasiye anómba kawe'á umátinkaniye Ísu siráiye.  ");
INSERT INTO kze_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","táákísi kwémayon-kwaasiye úwoi-kwaasiye mináímbá isésa Áánútumo siráin-aimba árair-aimba póta konanayá nombá pésinkainkwae sésa Yóninopa'a kuráawe. ");
INSERT INTO kze_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ánivo Yóni Áánútuna aambá agaráátínkaraimba ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé minámbá tínaaemba umámesa íma nombá perómba kóuraawe. ");
INSERT INTO kze_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ísu moórá-ainkwara'a simátimena séna ívé'a máyáan-kwaasi nóran-kwaasiraane sénaumno. ");
INSERT INTO kze_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","mirán-kwáásíráání'a kwéomba iyámpóíyomba naaópa'a marupímbá mésa aávéima kwétesa moórá-ayampa'o máyáan-iyampoi tááyesa imá tiré'a taseró. moórá-iya súna'a íma táásá uráawe. ivi'ó taan-íyá súna'a íma ivi'á taráawe. miníyámpóí uráantemba maamáyáan-kwaasi mirá kwéowe. ");
INSERT INTO kze_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yóni nombá pétinkaiwai ména ándá-aran-domba íma kwénena Áánútuntavena ísámai toónkwárá'á íma kwénaisa'a kwentávé'a sé'a taraváá-kwámbá arumpimbá máyáiwaiman-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","kemá kwaási úranda'a kumpaáruraundawai mé'a ándá-aran-donkwara toónkwárá'á kwénauna'a kentávé'a sé'a ándá-aran-donte toónté námae íyíwaima póna táákísi máyáan-umoyan-kwaasiye sáwí'a on-kwáásítí kwaásiman-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ánivo Áánútu simátímakaintemba kwéowai sésa Áánútu kawer-ímáyáágwáráwáímán-iye kwésewe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","moórá-tawai ámáán-kawaa-kwaasigo áwí'a Sáímoni kwemá Ísuntavena séna kesí naaúmpa'a toómbá tamandaaó súwana kwená naaúmpa'a iréna toómbá ugwénowana ");
INSERT INTO kze_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","mindáópaken-inimba eénánká'á naaún-ininko Ísu ámáán-kawaa-kwaasigona naaúmpa'a ména toómbá kwénaiye-aimba minínínkó iséna óntan-anaveumpimba áséi-kwiyumba úm-basawemba kwáyomba maimaéna ");
INSERT INTO kze_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","mindáúmpá'á iyéna Ísun-ánaaempa'a aísamaivimba uména ivi'á kwétowana a'numá ka'maéna Ísu aísamaira'a kumúwana minínínkó ayáátáár-a'nontaunei aísamairakemba kwéuwaena aísamai kwéamo'nena áséi-kwiyumbo úm-basawemba aísamaira'a atímarowana ");
INSERT INTO kze_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ámáán-kawaa-kwaasigo Ísumbo ááyowai awánéna imáyáa éna séna minkwáásígómó Áánútun-aai kwésiwaimo inkákáí aísamaira'o uyátokain-inimba eénánká'á naaín-ininko iyé-ímáyáá isinó séna mirán-ímáyáá úwana ");
INSERT INTO kze_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ísu minkwáásígóntávéna séna Sáímoniyo moórá-aimba simámenae súwana minkwáásígó séna anóndako siyó súwana ");
INSERT INTO kze_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ísu séna moóráwai óntamba kwétimiwai ména moóráwaimba sáwívar-ontamba siyáánkai-tamayor-ontamba aména moóráwaimba sáwíyan-ontamba moórá-tamayor-ontamba ámísana ");
INSERT INTO kze_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","aanávómbó amí-kánáá tisasaráí óntamba íma kwáyáísasarai avakáá uwááesarai kwenópa'a tíyana séna kanaánivo íma meéyámbá mayánaumpo keináraiti meéyán-túwí'a tawígauvatuwaumpo kokaiyó siráiye-aimba Ísu Sáímonimba simámena séna mindáyavena mirámó sintávéna minkáé-kwáásígóráí tirunkó aamoí kwéumankaiye. moóráwai ávááraumai aamoí kwéumankaimba nááwa'iyo Ísu áísaa ena súwana ");
INSERT INTO kze_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sáímoni séna sáwívar-ontambo mairénamo aanávómbó ímo máamisanamo meéyán-áwí'a tawígáúvatuwaiwai anón-aamoi kwéumankaiye Sáímoni súwana Ísu séna mindáyave'o súnda á'a séne simásuwena ");
INSERT INTO kze_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","kogwanténa minínínkómbá awánéna Sáímontavena séna minínínkómbá awánaao. ená naaúmpa'a iyúnda kentáásí ááimba sísamaimo sese ií-nómbá íma siménana minínínkó ivi'á kwétaisana a'numá sísamaira'a kúmísana kwena'nónáunei uwákaiye. ");
INSERT INTO kze_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","paruvará íma umásinkaanana minínínkó sísamaima taamó'namo'na uráiye. ");
INSERT INTO kze_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","kentáásí ááimba íma si'nómpá'á masawémba asinkáánana minínínkó sísamaira'a áséi-kwiyumba im-básáwémbá atímai asínkaraiye. ");
INSERT INTO kze_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","mináímbá simáme'a sé'a minínínkóná amápa-sawi-imayaa mayauwáúnda póna kembá anón-aamoi umásinkena mirán-tántáá'á kawe'á umásínkáiye. ánivo moóráwaimbo kíto-sawi-yantaa'o mayauwáúnda sáwíyan-aamoi kwéumasinkaiye Ísu Sáímonintavena simásuwena ");
INSERT INTO kze_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","minínínkóntávéna séna ená sáwí-imayaa mayauwáúmne súwasa ");
INSERT INTO kze_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","kwesémo toómbó kwénon-kwaasi keáímbá sésa kwaásiti sáwí-imayaa kwémaitiyuwaiwaima mindá nóran-kwaasiya'iyo suwaná ");
INSERT INTO kze_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ísu minínínkóntávéna séna kentáváí áraire séna'a ená sáwí-imayaa mayauwé'a kawe'á umánkaumpo aánoumai paru umái kwaaó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","minkákémbá Ísu naaó'-nao'a anón-daopimpare sáwíyan-daopimpare kwénaaena Áánútu kwená kwaási kwégawaain-aimba áséi-aimba simátíma'maena iráiye. Ísuwe kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi kwénaauwasa ");
INSERT INTO kze_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","évakar-ininte kwénaaesa miníníntómbá évaka'a tí'a úwana Ísu kawe'á umátínkaron-inimba uwasá évaka'a tirumpinkémbá taraváá-kwámbá maitíyukain-inimba uwaná moórá-inimba Mágátáraa-naopakemba áwí'a Máríyaa Ísu kwenarumpinkémbá avakaeté-taravaa-kwamba mayáúkon-ininko úwana ");
INSERT INTO kze_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","moórá-ininko áwí'a Yóánana awaikó áwí'a Súsa kwemá Érótina naanká'á kárákwirowai úwana moórá-ininko áwí'a Súsáana úwasa évakar-ininkwara'a uwasá miráumai-inimba pósa kentí náaindaampinkemba Ísuwe kwená kwayó-kwáásíyé túwa'naa úmaesa kuráawe. ");
INSERT INTO kze_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","naaó'-naoken-kwaasi sáwíva'a Ísunopa'a tóyo uwaná Ísu simátimena séna ");
INSERT INTO kze_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","moóráwai ánáyumba maimaéna kígauva'a kwégwena máyu'maraisana évakar-anayumba aampa'á kunkwáyáísasa kwaási tísamaigo tavútukaawana numaómá túkúnasukaiye. ");
INSERT INTO kze_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","évakar-anayumba óntankwara'-maravimba kunkwéna karuwéna anoníyaim-barava'a póna aáyánkaraiye. ");
INSERT INTO kze_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","évakar-anayumba karaampimbá kunkwéna kárúraisana karaan-tantáákó ara'násukaiye. ");
INSERT INTO kze_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","évakar-anayumba kawe'-márávímbá kunkwéna karúmai anón-éna arambá imái sáwívar-aramba iráiye. kwéisaawai ísámai kawe'á oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","súwasa Ísuna kwayó-kwáásí Ísuntavesa minkwántámáí-áínkóná ááimba sinatá ísáano suwaná ");
INSERT INTO kze_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ísu séna Áánútu kwená kwaási kawááin-ainkona ááimba kwésimatimunda Áánútu keinárawa'a imáyáa tímísa'a kwéisaavo ó'on-kwaasi kwántámai-aine su'mai kwésimatimumpo kwéisaambanivo íma ísámai kawe'á kwéowe. kwéawanaambanivo íma awánamai kawe'á kwéowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ísu simátímatuwena séna mináínkóná ááimba súnda ísáaro. moóráwaimo ánáyumbo tu'máráinten-umai Áánútun-aai simátímísana ");
INSERT INTO kze_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","évakar-anayumbo aampa'ó kúmímba kwaási tirumpintá kúmísasa Áánútun-aai ísááwana Sáátáánigo imáyáa éna Áánútun-aaiyavesa áraire síyana sáwí-ampakemba kawer-ámpá'á métínkáivo séna tirumpinkémbá tamaimái úwoiva'a kwétiyuwaiye. ");
INSERT INTO kze_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","évakar-anayumbo óntankwara'-maravimba kúmímba kwaási tirumpintá kúmísasa Áánútun-aai isésa aamoí ombánivo íma tirumpimbá táto'mai kawe'á ontávésa sáwíyanka'a áraire kwésewana ó'on-o'on-tantaako tisasá miwáná imáyáa ésa Áánútun-aai ivátukaawe. ");
INSERT INTO kze_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","évakar-anayumbo karaampimbó kúmímba kwaási tirumpintá kúmísasa Áánútun-aai ísáámbanivo marapár-úmbáí-yántáátávésa imáyáa úmae naaésa óísan-imayaama úmae kwénaaesa ó'on-o'on-tantaa'a mayánáe kwésimae naaésa mirán-ímáyááó Áánútun-aai káátasuwaisasa íma Áánútuna mayáí kwémayaawe. ");
INSERT INTO kze_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","évakar-anayumbo kawe'-márávímbó kúmímba kwaási tirumpintá kúmísasa Áánútun-aai isésa kawer-ímáyáágwárá-kwáásí isésa tirumpimbá táto'mai kawe'á ésa asiramái mésa Áánútuna mayáí kwémaesa ó'owima kwétuwa'naa-owe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ísu simásuwena séna oómbó kúra'maraamba íma aúpá'á marésa íma asípáa-amendaampa'a marésa avora'á mósá makéwasa amáparawai naaúmpa'o iyíyamba awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","mirámó onten-umái aúpá'ó kwáyáin-tantaa'a amápa'a avora'á paárínasa awánanaaowe. túnkaipa'a kwáyáin-tantaa'a avora'á paárínasa awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","kwéisaan-aimba imáyáa umái kawe'á oró. Áánútun-aaimo ísámaimo kawe'ó kwéowai Áánútu túwa'naa ínasa moórá-ainkwara'a isánááowe. Áánútun-aaimo ímo ísámaimo kawe'ó ésa kampa'á sésa kawe'á umái kwéisaumne kwésewai tirumpinkémbá maimayáínana íma kwéniye. mindáyave'a ísáan-aimba imáyáa umái kawe'á oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","súwasa Ísun-anówawe Ísun-áúnava'maate tésa sáwíva-kwaasi Ísuwe mésa sisipáá uróntavesa íma naaúmpa'a íyúmba máápata tamáyówana ");
INSERT INTO kze_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","mindáúmpá'ó máyon-kwaasigo Ísuntavena séna enanówe enáúnavare embá awánanae sésa máápa'a tamáyáawe súwana ");
INSERT INTO kze_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ísu amáparawaiyavena séna Áánútun-aaimo isésa kawe'á kwéowai kesinówe kesúnava'maa'an-owe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","moórá-tawai Ísu kwená kwayó-kwáásíyé nompí-sípívímbá usáatena nonkwaaúnkóná menávápá'á kónáe séna miwísé kúmba ");
INSERT INTO kze_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ísu aún-kwaigurówana minkwááúmpá'á anón-unda torówana nonkó tuvántááva éna nompí-sípívímbá ógwitowasa kunávekunavo sésa ");
INSERT INTO kze_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","inkaisésa Ísumba koaúsesa sésa anóndakoo puwúnavaiyaawe suwaná Ísu usásinena asiramái séna úndáonte nonkóntéyavena maiváyáakaiyo súwasarai úndáoe nonkóe maiváyóyana nonkómá kararépaguwana ");
INSERT INTO kze_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ísu simátimena séna kentávé'a nóra séra íma kesí imáyáa onkákémbá kwéseo súwana táá'a kówasa keáímbá sésa nóran-kwaasiya énawa úndáoe nonkóe kwenáái kwéisaiyo sésa tiyáámba uvakésa táátavesa ésa siráawe. ");
INSERT INTO kze_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","simásuwesa mindómpí-sípívímbá kumbá Káríri-marama tínaaempa'a kwáyowana Kégésaa-marama túrampa'a kwáyowasa ");
INSERT INTO kze_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","mimbárává'á kumbá Ísu mindómpí-sípívínkémbá mimbárává'á ásávowana moóráwai mindáópakewai Ísunopa'a téna kwenarumpimbá taraváá-kwámbá máyowana póna ayáátááka'a unáánkwátói-iyaaimba ména íma kwená naaúmpa'a maéna kwaásimo utamátínkóm-buri-aiva'a máyowana ");
INSERT INTO kze_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","sáwíva-tawai mintáráváá-kwánkó sáwí'a umánkowasa kwaási kárákwiresa aíyayaanka'a asááúmarowana minándá tarátuwena mintáráváá-kwánkó áí'maena kavóná-marava'a máánkarowana ména Ísumo túmba awánéna kwáá'a túwana Ísu taraváá-kwánkóntávéna séna auwé kóaao súwana Ísuma anóndakoman-iye séna aísamaivimba kumbéna anónka'a séna Ísuwo usáyaaitamai-Isoigo ááninko ómpo sínkamonavainivo nóra umásinkaniyono súwana ");
INSERT INTO kze_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ísu séna enáwí'a nááwa'ono súwana minkwáásígó sáwíva-taravaa-kwamba kwenarumpimbá máyontavena séna kesúwí'a sáwívarawai úne séna máyowasa ");
INSERT INTO kze_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","omáka'a sáwíva-poima mésa umá kwénowasa minkwáásígó arumpinkén-táráváá-kwántómbá Ísuntavesa asiramái sésa kwaántái naaópa'a íma si'maraaó. mimpóí tirumpimbá si'maraaó suwaná mirá oró súwasa ");
INSERT INTO kze_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","taraváá-kwántómbá minkwáásígó arumpinkémbá kárúwesa póí tirumpimbá kovérówasa mimpóíyómbá amápa'a ámémpakemba isaaisésa nonkwaaúmpíntá kumpérómba putásowasa ");
INSERT INTO kze_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","póíra'o tavíkówai úmba awánésa avekáán-umai naaópa'a kwésa kígauvimpa'o máyón-kwaasi mósimati mesimati uwasá ");
INSERT INTO kze_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","isésa koawánanae sésa kumbá Ísunopa'a koyorupésa awánomba taraváá-kwámbá arumpinkémbá kóun-kwaasigo unáánkwátói úmarena Ísu aísamaivimba kawe'á umái máyowasa koawánésa táátavai uwasá ");
INSERT INTO kze_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ísumo minkwáásígómbó kawe'ó umánkowasamo awánon-aimba simátímúwasa ");
INSERT INTO kze_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","isésa ávááraumai táátavai ésa pósa Kégésaa-maravaken-kwaasi amáparawai Ísuntavesa sésa maambárává'á ivá siyuwéya kóaao suwaná nompí-sípívímbá usámaaisowana ");
INSERT INTO kze_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","taraváá-kwámbó arupinkémbó mayauwón-kwaasigo Ísuntavena asiramái séna esé kónáe súwana ímanivo ");
INSERT INTO kze_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ená naaópa'a kuré Áánútumo embó kawe'ó umánkáin-aimba kosimátimiyo súwana Ísumo umánkon-aimba mindáópa'a simátíma'maena kuráiye. ");
INSERT INTO kze_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ísuma Káríri-kwaaunkona menávápákémbá nompí-sípívímbá koyauweréna túmba sáwíva-kwaasi amu'marésa máyówana túwasa aamoí uwaná ");
INSERT INTO kze_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","moóráwai mono'-nánká'ó kárákwirowai áwí'a Yáírasi téna Ísu anóndakoman-iye séna aísamaivimba kumbéna asiramái séna kímbora kesiyáámúmba puwíndayavena kwéivo tiré ane'á koyátorenana asóváíno súwana minínáámárúgó sísamaivakemba kae'á kumbaimái-ima tásukain-arasigontavena avowá tasúwana Ísu kwesé kúmba sáwíva-kwaasi Ísumba taúkúraa'namai kwa'maé kuwaná ");
INSERT INTO kze_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","moórá-ininkomba áí'a kwéun-ininko sísamaivakemba kae'á kumbaimái-ima naaeyámba kwéankowasa íma kanaán-umai asóvamankowana mináí'á úwoi kwáyowana ");
INSERT INTO kze_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","minínínkó sáwíva-kwaasivimba Ísun-ánaaemba kwa'maéna kwégwena kwená unáánkwátói-ayaaira'a koyátorowana mindááéyánkoma érankowana ");
INSERT INTO kze_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ísu séna nááwawa kesí unáánkwátóira'a tátoraina'iyo súwasa amáparawai sésa ímaniye suwaná Pítaa séna anóndakoo sáwíva-kwaasi kwenkuvará'a úmaesa íyómpimba tátokaawe súwana ");
INSERT INTO kze_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ísu séna kempínkén-ásíráyánkó moóráwaimba kawe'á umánkáimba awánare'a sé'a moóráwai kesí unáánkwátóira'a tátokaiye kwésune súwana ");
INSERT INTO kze_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","minínínkó imáyáa éna íma aúpá'á úmpo á'a suwánaraiye-imayaa éna ayántámbá kwétowana Ísu aísamaivimba kumbaéna amáparawai túranka'a kwená unáánkwátóira'o tátorowanamo asóvamankon-aimba simátimuwana ");
INSERT INTO kze_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ísu séna kesímánaako kentáváí se árai'a súwa'naa íníwaiman-iye sénda póna áí'a éránkáivo kawe'á umái kwaaó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ísu mináímbá kwésuwasa mono'-nánká'ó kárákwirowaina naaópaken-kwaasi tésa Yáírasintavesa sésa enayáámúnko pukáivo anóndakontavai ténavo simámiyo suwaná ");
INSERT INTO kze_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ísu mináímbá iséna Yáírasintavena séna mináíntáváí íma áákar-aaka'a éma kentáváí ísénana enayáámúmba kawe'á umái méniye Ísu séna kúmba ");
INSERT INTO kze_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yáírasina naan-egwáá'á kwéna kwa'maésamo kun-kwáásíyóntávéna maanká'á méwaro séna Pítaawe Yóniye Yémésiye minárásígó anóvowiye tí'maena naaúmpa'a usávé'mai iyúmba ");
INSERT INTO kze_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","mindáúmpá'ó máyón-kwaasi anón-ivi'a kwétowana Ísu séna íma ivi'á taaró. minárásígó íma pukáivo úwoi aúmá kwaiguráiye súwasa ");
INSERT INTO kze_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","minkwáásíyómbá á'a pukuráiye-imayaa ésa Ísuna awíráái suwaná ");
INSERT INTO kze_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ísu minárásígó ayáánka'a tátorena séna inaamarúgóo usásinaao súwana ");
INSERT INTO kze_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","minárásígón-amanko arupimbá túwana avekáámbá usásinowana Ísu séna toómbá amíyana naíno súwasarai ");
INSERT INTO kze_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","anóvowi táátavai uyaná Ísu asiramái séna kemó únda-aimba íma simátímékaiyo siráiye. ");
INSERT INTO kze_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","naaémba Ísu kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi tááyowasa tuwaná kwaási tirumpinkémbá taraváá-kwámbá maitíyu'mae'a nááóro-asirayamba tiména tí'o ún-kwaasi asóvamatinkai-asirayamba tiména ");
INSERT INTO kze_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","séna Áánútu kwená kwaási kawááin-aimba kogwésimatime'a tí'o índa-kwaasi kwéasovamatinke'a oró séna ");
INSERT INTO kze_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","aampa'ó kwíyamba íma moórá-yantaa'a maimaé'a koró. tááúmba íma maimaé'a kwé'a toón-únámbá íma maimaé'a kwé'a toómbá íma maimaé'a kwé'a óntamba íma maimaé'a koró. moórá-mora-umai unáánkwátói timantenká umái kuvé'mae'a koró. ");
INSERT INTO kze_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Áánútun-aai simátimenaaontave'a moórá-naopa'o kwíyasamo naambó timíya'a mindáúmpáré su'mai mé'a mindánkó avowá arunkó sáwí'an-ivai mindáúmpá'á mé'a kentí mayáí maimái ánáse'a mindámbá tuwé'a ó'on-daopa'a koró. ");
INSERT INTO kze_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","moórá-naopa'o kwíyasamo ímo naambó timíyana Áánútu mindáópaken-kwaasi íma aamoí umátinkanivo umásítai'a é'a tísamaivakem-baramo uwáéntemba unté'a koró Ísu simátimuwasa ");
INSERT INTO kze_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","kwená kwayó-kwáásí tuwésa naaó'-nao'a kwénaaesa Áánútuna áseí-kwasai simátíma'maesa kwégwesa tí'o ún-kwaasi asóvamatinkamae kuráawe. ");
INSERT INTO kze_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ísuna mayáígón-áái símae íyúwana Káríri-marara-kawaanako áwí'a Éróti mináímbá iséna anón-imayaa urái. Ísuntavesa évakarawai sésa kwemá Yóni nombó pétinkaraiwai pukáimpinkemba usásinkaiye suwasá ");
INSERT INTO kze_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","évakarawai sésa kwemá Áánútun-aai simátímakowai áwí'a Íráiyaa pukáimpinkemba usásinena máyáiye suwasá évakarawai sésa kwemá naaóvá'á Áánútun-aai simátímakaawaivinkemba moóráwai pukáimpinkemba usásinkaiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Éróti minámápár-áímbá iséna séna kemá simátinkaunasa Yónimba anumarambá arátúwááwana pukáivo mináímbó kwésemba nááwa'iyompo awánanaumne Éróti símae iráiye. ");
INSERT INTO kze_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ísuna aantá-kwaasi Ísumo timúm-bayai maisuwésa kwenópa'a tésa amápa'-mayaimo un-áímbá simámúwana Ísu miwíyé su'mai tí'maena Pétésáítaa-naopa'a komáyowasa ");
INSERT INTO kze_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ánivo sáwíva-kwaasi isésa kwa'maésa kuwaná Ísu tuwánéna aamoí éna Áánútu kwená kwaási kawááin-aimba simátimena tí'o ún-kwaasi asóvamatinkaraiye. ");
INSERT INTO kze_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","asóvamatinkowasa enónka'a kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi Ísunopa'a tésa sésa íma sáwíva-kwaasi máyáapa'an-ivo enáíndara'a ti'márénasa egwaa'-náópimpa'a kwénaaesa toón-ávákáí naan-avákáí oró suwaná ");
INSERT INTO kze_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ísu simátimena séna kemá toómbá tíméro súwasa miwí sésa sáwíyan-tomba éva'aaseigwara kae'-nóyáákwárá'á kwáyáivo sáwíva-kwaasivimba íma kanaán-ínívo toómbá komeéyán-oro-aina kwéseno áísaa esa suwasá ");
INSERT INTO kze_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","sáwíva-kwaasi 5,000 kwaaima uwasá aaraiyé iyámpóíye máyówana Ísu kwená kwayó-kwáásíyávéna séna inkwima'mái taaínkaa taainkaarumai 50 50 umai mara'á máéro simátíméro súwasa ");
INSERT INTO kze_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","isésa mirá umátinkowana ");
INSERT INTO kze_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ísu éva'aasei-tonkwara kae'-nóyáákwárá'á maisokéna kwíyómpa'a karákéna Áánútuntavena súwi simásuwena mintómbá topán-topan-umai kwená kwayó-kwáásí timúwasa misáwívá-kwáásí tímúwasa ");
INSERT INTO kze_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","amáparawai nowaná tímú'a vówasa Ísuna kwayó-kwáásí mintón-ayai sísamaivakemba kae'á kumbaimái-unampimba áítumai ógwitaraawe. ");
INSERT INTO kze_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","moórá-tawai Ísuwe kwená kwayó-kwáásíyé máyówana Ísuwe su'mai Áánútumpa'a námúnaa simásuwena tísaa ena séna kentávésa amáparawai nóran-kwaasiye kwéseo súwasa ");
INSERT INTO kze_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","miwí sésa évakarawai sésa emá Yóni nombá pétinkaandawai óne sewasá évakarawai sésa naaóvá'á Áánútun-aai simátímakaandawai áwí'a Íráiyaama óne sewasá évakarawai sésa naaóvá'á Áánútun-aai simátímakaiwai pukáandavinkemba usásinkaandawai óne kwésewe suwaná ");
INSERT INTO kze_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ísu séna keinárawa'a kentávé'a nóran-kwaasiye kwéseo súwana Pítaa séna Áánútu usásinankaiwaimba Yútaa-kwaasiya kwéamu'maraundawaiya óne súwana mináímbá íma simátíméro Ísu asiramái siráiye. ");
INSERT INTO kze_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ísu séna mináímbá íma simátíméro simásuwena ");
INSERT INTO kze_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","séna kemá kwaási úranda'a kumpaáruraundawai sí'a índai'a umásinkesa Yútaa-anon-kwaasiye mono-káwáá-kwáásíyé ámáámba sen-kwáásíyé tínaaemba umásimesa sínkamiya'a puwónaundanivo kaumbo-táwai maisuwéna Áánútu usásisinkaniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ísu simásuwena amáparawai simátimena séna kesínaaemba kwaránáe síyawai tirááímo táínda-yantaa'a íma tátoraaro. kemá puwónaunda-taima súgwaata'mae'a kondantembá kesínaaemba kwaránááowaima umbai-yántáá'á aasiyaasi-táwai timíyasa minúmbáí-yántáá'á úwoi maimaésa sínaaemba kwaránááowe. ");
INSERT INTO kze_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","tirááímo táíndai'o ésa íma kawe'á umái ménaaovo kentávésa ísámai tirááímo táínda-yantaa'o tuwésa puwésa aúnái'a umái maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","marapákémbó amápa-tantaa'o kwémaesamo puwíyambo éna mintántáákó íma túwa'naa íníye. ");
INSERT INTO kze_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","kesááiyavaigwara kentáváígwárá'ó tigaemó umásínkáámba pó'a aáno kemó marapá'ó kúmónda miwí sigaemá umátinkanaumne. kemá kwaási úranda'a kumpaáruraundawai aáno kesí ságayankwara kesivoná ságayankwara kwíyómpakembo Áánútuna kwayó'nárawati ságayankwara'o marapá'ó kúmónda miwí sigaemá umátinkanaumne. ");
INSERT INTO kze_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","árai'a simátime'a sé'a évaka'a maanká'ó máyáan-kwaasi íma aiva'á puwé'a Áánútu kwená kwaási kwégawaaimba awáné'a naaémba puwónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ísu simásuwena avakaumboé-no'waamba kwaéna Pítaante Yóninte Yémésinte tí'maena námúnaa síndayavena omápa'a uména ");
INSERT INTO kze_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","námúnaa kwésuwana ói'a ó'on-oi'a auvúwana kwená unáánkwátóirakemba kwayání'a kéna túgáyáagaya kwéuwasa ");
INSERT INTO kze_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","awánomba kae-kwáásíráí kwíyómpakemba paárésarai mindárai túwí'a Mósesiye Íráiyaae Yútaa-kwaasi tíkwá'nárai Ísuwe kwaasái kwésuyana kwíyómpake-sagayamba kwáyowarasarai naaóvá'á Áánútu Ísuntavena Yérúsaremuva'a puwíníye siráimba sáwíyanka'a mirá íníye-aimba kwésuyasa ");
INSERT INTO kze_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pítaae máyóyan-kwaasiye tuún-kwáyómba usásinesa Ísuna ságayamba Ísuwe máyóyan-kwaasi tuwánomba ");
INSERT INTO kze_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","mindárai Ísumba íma auwésarai íyúyana Pítaa Ísuntavena séna anóndakoo maanká'ó maúndaya kawe'á imbá póta kwááyu-namba kaumbomá ónaundaya moórá endéín-éta moórá Mósesindei éta moórá Íráiyaandei éta mirá ónaundayaawe Pítaa íma imáyáa úmba úwoi siráiye. ");
INSERT INTO kze_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","mirá kwésunka'a ainánkó kuména káátaguwasa táátavai uwaná ");
INSERT INTO kze_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ainámpínkémbá aaigówé su'mai séna maawámá kesáánimba éna kemá usásinankaundawain-ivo kwenáái ísáaro ");
INSERT INTO kze_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","simásuwowasa awánomba mindárai kwíyómpa'a íyúyana Ísuwe su'mai máyowasa awánaraamba minkánáá íma simátimesa mináímbá úwoi tátokaawe. ");
INSERT INTO kze_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","aaváyaaraamba omápakemba kúmúmba Ísunopa'a sáwívarawai tóyo uwaná ");
INSERT INTO kze_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","minkwáásíyómpínkémbá moóráwai anónka'a séna anóndakoo maandá'á kímbora kesáánimban-ivo arumbá umánkaao. ");
INSERT INTO kze_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","moórá-taravaa-kwamba arumpimbá taména kwáá'a kwétena amentánaanta isaná tanaambá váguvagu kwéena áwááyaamba akékúndena aigareó nonkáánéna aíyayaamba sápísimagwisana mirá úmaena kwéiyena sáwí'a kwéumankaisa'a ");
INSERT INTO kze_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ená kwayó-kwáásíyávé'a sé'a taraváá-kwámbá arupinkémbá mayaúwáaro súnasa íma kanaán-umai mayáúkaawe súwana ");
INSERT INTO kze_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ísu séna kentí imáyáa kae'náér-imayaa isa'á kentáváí íma imáyáa kwéowana póna sirumbá umbaí kwétaivo nóraumai-tawaiya kesé ménaumno simásuwena miníyámpóígó avowántávéna séna enáánimba áí'mae tiyó Ísu súwana ");
INSERT INTO kze_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","áí'maena túwana mintáráváá-kwánkó miníyámpóí améntayuwowana tanaambá vówana aíyayaamba sápísimaguwana aigareó nonkáánúwana Ísu awánéna mintáráváá-kwánkóntávéna séna auwé kóaao séna miníyámpóí kawe'á umánkena avowántávéna séna áí'mae kwaaó súwasa ");
INSERT INTO kze_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ísumo mirámó úmba Áánútuna anón-asirayamba awánésa amáparawai táátavai ésa tiyáámba tóipimba áákaawe. ");
INSERT INTO kze_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ísu amápa'-mayaimo mayómba awánésa táátavai uwaná kwená kwayó-kwáásíyávéna séna simátíménda tááka'a márááro. kembá kwaási úranda'a kumpaáruraundawaimba ó'on-kwaasi timíyasa sínkamiya'a puwónaumne súwasa ");
INSERT INTO kze_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","kwemó sún-ainkona ááimba íma isésa miwítí imáyáa umbaí tówana mináínkóná ááimba aúpá'á kwáyowasa íma ísámai kawe'á ésa áísaa ónáe sésa umbá táá'a kówasa íma áísaa uráawe. ");
INSERT INTO kze_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ísuna kwayó-kwáásí keáín-keaimba sésa kentáávínkémbá nááwa aiva-kwáásí-í'a íníyo sésa keíyáí kwésuwana ");
INSERT INTO kze_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ísu miwítí imáyáamo umbá awánéna moórá-iyampoi áí'mai akwámpa'a ankéna ");
INSERT INTO kze_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","simátimena séna kentáváí imáyáa kwéesa iyámpói áwa'naa onten-umái kwésuwa'naa-owe. súwa'naa onten-umái Áánútu si'mákaiwaimba kwéawa'naa-owe. keinárawapinkemba évakarawai sé'a kemá sáwíyan-kwaasima úne kwésiyawai Áánútu minkwáásíyávéna kwéusayaaitaawe kwésiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","súwana Yóni Ísuntavena séna anóndakoo moóráwai kwénaaena taraváá-kwántóntávéna séna Ísuna asirayámbá kwáyáintavena auwé kóaao simátímapa'a kwégwisasa mintáráváá-kwámbá kóuraawe. minkwáásígó íma kentáávínkén-kwáásímá ómpo íma miráne étuwaaoya siráumne Yóni súwana ");
INSERT INTO kze_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ísu séna íma tuvínankaaro. kentáásí maiyáígómbá íma sáwí'a kwéowai úwoi kwésuwa'naayaan-owe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Áánútu Ísumba airáínana kwíyómpa'a iyínín-kanaama sáwíyanka'a tíníye úwana Ísu kwenarumpin-ímáyáá éna asiramái séna Yérúsaremu-naopa'a kónáe séna kwéna ");
INSERT INTO kze_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","kwená kwaásiyavena kogwaénááon-damba koavakáá kwéiyaro séna ti'marówasa aiva'á Sámériyaa-kwaasiti naaópa'a kuwasá ");
INSERT INTO kze_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ísu Yérúsaremu-naopa'a kwíníye-aimba isésa tirunkó sáwí'a úwasa íma naambá tímúwasarai ");
INSERT INTO kze_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","kwená kwayó-kwáásívínkémbá kae-kwáásíráí Yémésiye Yóniye mináímbá isésarai sésarai Ísóigo Áánútu kwíyómpakemba iramá tuwáínana kuména minkwáásí kavúkoro-aimbo kwésuyamba kwéankaiyo suyaná ");
INSERT INTO kze_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ísu mégwantena asiramái séna íma mirá sekaiyó súwasa ");
INSERT INTO kze_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mindáópa'a tuwésa ó'on-daopa'a kuráawe. ");
INSERT INTO kze_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","aampa'á kwéguwana moóráwai Ísuntavena séna amápa'-naopa'o nááíndava'a esé naaónaumne súwana ");
INSERT INTO kze_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ísu minkwáásígómbá áísaa umai isánáe séna kwaankó taaiyaivimbá kwégwaisana numaómá ánáamba úmarena kwégwaivo kemá kwaási úranda'a kumpaáruraundawai íma naambá úmare'a kwégaumne séna ");
INSERT INTO kze_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","minkákémbá moóráwaintavena séna kesínaaemba kwa'maé kwíníyone súwana anóndakoo máyáanana kesivo puwína'a utamánke'a enánaaemba kwaránaumne súwana ");
INSERT INTO kze_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ísu séna ímanivo kesáái ímo isésamo pukáan-kwaasiraamba owáímá puwíyan-kwaasi utamátinkanaaovo emá Áánútumo kwená kwaásimo kwégawaain-aimba simátíma'mae kwíníyone súwana ");
INSERT INTO kze_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","moóráwai Ísuntavena séna anóndakoo enánaaemba kwaránaunda pó'a aiva'á kesimááraa siyáámba tímatuwe'a naaémba enánaaemba tágwaranaunda kanaawá'iyo súwana ");
INSERT INTO kze_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ísu séna Áánútuna mayáímó ááimbo ásámaimo kwémaesamo ivátuwesamo ó'on-imayaamo owáí Áánútu kwená kwaási kwégawaaipa'a íma kanaán-umai mayáí mayánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","naaémba Ísóigo sáwíva-kwaasi 72 kwaasi usásintinkena kaesé umásuwe kwemó kwínín-daopimpa'a aiva'á kónááowe séna ");
INSERT INTO kze_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Áánútunopa'o ténááontavesa kwenáái kosimátíma'mae koró-áímbá simátimena séna kígauva'a sáwíva-tomba ávu karáisasa mintómbá akaránááon-kwaasi esimáí-kwaasi máyáamba pó'a kígaugona avowámpa'o námúnaa síyana mayáí-kwáásí ti'maráínasa mintómbá akaránááovo ");
INSERT INTO kze_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","koró. sipisípi-araa'a kwínana áwááisaantemo in-íyánkómó intenkáámbá on-kwáásívímbá ti'maránaumne. ");
INSERT INTO kze_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","óntambo inaainaaimó sií-únámbá íma maimaé'a kwé'a toón-únámbá íma maimaé'a kwé'a tísamai ánáamba íma maimaé'a kwé'a aampa'ó kwégwe'a ayáátááka'a íma úwoi-aimba símae kwé'a ");
INSERT INTO kze_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","moórá-naumpa'o iyé'a sé'a paru umái máétaao serómó. ");
INSERT INTO kze_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","síyana paru umái maíndawaimo éna mimpárú-áímbá kwempímbá kwénivo ímo paru umái maíndawaimo éna mimpárú-áínkó koyauweréna keinárawatopa'a tíníye. ");
INSERT INTO kze_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","mayáí kwémayaiyawai meéyámbá máyáantavai timínda-naumpa'a uméwana timínda-tomba nánááowe. íma ó'on-daumpimpa'a naaé'a timínda-naumpare su'mai umáéro. ");
INSERT INTO kze_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","moórá-naopa'o kwíyasa naambá timésa toómbá timésa íya'o kwéne'a ");
INSERT INTO kze_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mindáópa'o tí'o índa-kwaasi kwéasovamatinke'a simátime'a sé'a Áánútu kwená kwaási kawááinin-kanaa kentópa'a sáwíyanka'a tíníye simátíméro. ");
INSERT INTO kze_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","moórá-naopa'o kwíyasamo naambó ímo timíya'a aampa'á kwégwe'a avora'á simátime'a sé'a ");
INSERT INTO kze_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","kentí naaópakem-baramo sísamaivakenta uwátuwaundaya Áánútu keinárawa'a íma aamoí umátinkaintavai umásítai'a umái agaráátinkaumne. ísáaro. Áánútu kwená kwaási kawááinin-kanaa sáwíyanka'a tíníye isa'á tínaaemba umámewe simátíméro. ");
INSERT INTO kze_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","simátime'a sé'a Áánútu kwaási máyáawaina ááintavena tísaa ínín-kanaa tínímba naaóvá'á Sótómu-naopa'a méraan-kwaasi sáwí-kwaasi sáwí-meyamba timínímbanivo keinárawa'o tínaaembo umátimenaaon-kwaasi sáwí-meyamba ávááraumai timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ísu simásuwena séna Kórásini-naopaken-kwaasiye Pétésáítaa-naopaken-kwaasiye kárákwiyoro. naaóvá'á Táyaa-naopaken-kwaasiye Sáítóni-naopaken-kwaasiye Áánútun-aaimo ímo ísaraawaivimbo ó'on-o'om-bayai ímo awánaraam-bayaimo kwémayaawandamo awánarekai kentí sáwí-mayai tukáasino. sáwí-mayaimo tuwésamo úwoi-unankwatoimo úmaesamo kanamó a'mákáankakai Áánútu tuwánaraisino. ");
INSERT INTO kze_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","mindáyave'a simátíménda ísáaro. maarán-ímáyáá kwée'a Áánútu kwaási máyáawaina ááintavena tísaa ínín-kanaa tínímba Áánútu Táyaa-naopaken-kwaasiye Sáítóni-naopaken-kwaasiye sáwí-meyamba anómba timíníye-imayaa kwéowe. kentí sáwí-meyanko minkáé'-náópakewaiti sáwí-meyankomba usáyaaitaya-sawi-meyamba timíníye. ");
INSERT INTO kze_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kápénéamu-naopaken-kwaasiyono. kentúwí'a mósá maré'a sé'a kwíyómpa'a iyónaumne sembánivo púwón-ayampa'a kónááowe Ísu simásuwena ");
INSERT INTO kze_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","kwená kwayó-kwáásíyávéna simátimena séna kentáái ísámai kawe'á kwéowai mirámó ombá kesáái ísámai kawe'á kwéovo tínaaemba kwéumatinkaawai kenkwárá'á mirá kwéowe. tínaaemba kwéumasinkaawai mirámó ombá si'mákaiwainkwara'a mirá kwéowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ísu súwasa minkwáásí 72 kwaasi isésa kóyáwé urésa Ísunopa'a tóyo ésa aamoí taumánkesa sésa Ísóigoo taraváá-kwántóntávéta séta Ísuna asirayámbá kwáyáintave'a tiyuwé kóro kwésunasaya isésa kóuraawe suwaná ");
INSERT INTO kze_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ísu séna mirá owaná kwíyómpakembo tawáombo intembá Áánútu Sáátáánigona asirayámbá maisukáimba awánaraumne. ");
INSERT INTO kze_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","simátíménda ísáaro. asirayámbá timúna'a pó'a kwaaivaainkómó váindamo é'a íma puwíyana áwááisaantemo índa-uvowankomo váindamo é'a íma puwónááowe. tímakaunda-asirayanko Sáátáánigona asirayánkómbá kwéusayaaitaimba póna íma amápa-tantaako sáwí'a umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","taraváá-kwántómbá kentáái isésa kóuraantave'a íma aamoí ovo Áánútu kwíyómpa'a aúváí-kwandaaivimba kentúwí'a agaimakáintave'a aamoí oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","minkánáá Áánútun-amanko Ísumba imáyáa amúwana arunkó kawe'á úwana séna kesivoó kwíyómpakwara mararákwárá'á kárákwiraandawai óne. amápa-tantaa'a kwéisaumne sen-kwáásí íma simátime úwoi-kwaasi simátime mirámó iíyávéna kwéankaisa'a pó'a enáwí'a mósá kwémaraumne Ísu simásuwena ");
INSERT INTO kze_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","simátimena séna kesivo amápa-tantaaka'a kárákwiyuwo séna símakaiye. amáparawai kesí ááimba íma kawe'á umái suwánaraavo kesivo kemá ááninko únana póna kesí ááimba suwánaraiye. amáparawai kesivoná ááimba íma kawe'á umái awánaraavo kesivombá pó'a keyáá awánaraumne. kesivoná ááimbo agaráátinkaundawai kwéawanaawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ísu simásuwena mégwantena kwená kwayó-kwáásíyáváíye su'mai séna awánaamba póna tirunkó kawe'á ína'a máéro. ");
INSERT INTO kze_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","simátime'a sé'a naaóvá'á Áánútun-aai simátímakowaiye anón-kwaasiye keinárawa'o kwéunda-mayai kwéawanaanten-umai awánanae sésa umbá íma awánaraawe. miwí keinárawa'o kwéisaanten-umai isánáe sésa umbá íma ísaraawe Ísu kwená kwayó-kwáásíyávéna siráiye. ");
INSERT INTO kze_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","moórá-tawai Ísu kwenáái kwésimatimuwana moóráwai ámáámba kawe'á umái ísarowai Ísunopa'a téna áísaa umai Ísumba isánáe séna anóndakoo nóra umáíya aúnái'a umáíya kwíyómpa'a maí'maira ónaumno súwana ");
INSERT INTO kze_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ísu séna Áánútun-aai aúváí-kwandaaivimba awánáánda mináíntáváí nóran-imayaa kwéono súwana ");
INSERT INTO kze_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","minkwáásígó séna Áánútun-aai aúváí-kwandaaivinken-ainko séna kentiruné kentí imáyáawe kentí asirayáné Áánútumpa'a kentí Ísóigomba áméro séna kesáváí-ímáyáámó ontembá kentí kwaásiti imáyáagwara'a oró siráiye súwana ");
INSERT INTO kze_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ísu séna árai'a séndanivo mirámó é aúnái'a umái kwíyómpa'a maí'mai'a íníyone Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","súwana minkwáásígó imáyáa éna ó'on-kwaasi suwánésa kawe-kwáásímán-iye sígwáe séna Ísuntavena séna kesí kwaási nááwa'iyo súwana ");
INSERT INTO kze_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ísu séna simátíménda isaaó. moóráwai Yútaa-kwaasi Yérúsaremu-naopakemba Yéríko-naopa'a kónáe séna aampa'á kwimbá umóyán-kwáásí tátokesa kwená unáánkwátói ayú'maesa tuvú'máráawana puwíndayavena aampa'á máyáísana ");
INSERT INTO kze_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","moóráwai Áánútuntavenamo ísámaimo póí'o tuvú'mái kwéagayaiwai minámpá'á kwimbá aanéiva'a máyáísana kóawanena moórá-aaneiva'a kóyaaitaisana ");
INSERT INTO kze_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","moóráwai Árívái-andarakewai mono'-náúmpá'á mayáí kwémayaiwai minámpá'á kwimbá aanéiva'a máyáísana kwená egwaa'á kwéna kóawanena moórá-aaneiva'a úwoi kóyaaitaisana ");
INSERT INTO kze_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","moóráwai Sámériyaavaken-kwaasi miwímá Yútaa-kwaasiti namuro-kwáásívínkémbá moóráwai minámpá'á kwimbá koawánéna arumbá umánkena ");
INSERT INTO kze_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","kwená egwaa'á koména masawémba ándá-aran-donkwara'a umái avivimbá arankéna asááumankena mósá árámbai kwená tónki-poi arósáánumpimba ankéna áí'maena kwááyumo ten-kwáásímó kwáén-daumpa'a móankarena kárákwirena ");
INSERT INTO kze_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","usá aaváyaavimba mindánkó avowámbá kae-táwai-mayaigona óntamba aména séna kawe'á umái kárákwire kwenane'ó túwénda-ontambo é'a ke té'a anondá embá máamenaumne simásuwena kóuraiye Ísu simásuwena ");
INSERT INTO kze_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","37","nóra umáíya aúnái'a umái maí'maira ónaumno súwaintavena Ísu áísaa ena séna umóyán-kwáásí tuvúkáan-kwaasigona kwaási minkáúmbó-kwáásívínkémbá nááwa'iyo Ísu súwana minkwáásígó séna arumbá umánkena áwa'naa uráiwai kwená kwaásiman-iye súwana Ísu séna kwemó intembá komé mirá íníyone Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ísuwe kwená kwayó-kwáásíyé aampa'á kúmba moórá-ininko áwí'a Mááta máyon-daopa'a kúwana Ísuntavena séna kesí naaúmpa'a toómbá umandaaó súwana ");
INSERT INTO kze_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","uména aaí kwésuwana minínínkón-áúnko áwí'a Máríyaa Ísuntavena anón-kwaasima iyé-ímáyáá éna aísamaivimba taména kwenáái kwéisowana ");
INSERT INTO kze_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mááta amápa-tomba kwéagayena anóm-bayai kwémaena anón-imayaa éna Ísunopa'a téna séna Ísóigoo kesúnko íma súwa'naa isa'á keyáá anóm-bayai kwémayaumpo kentáváí íma imáyáa éma simámínana tasúwa'naa íno súwana ");
INSERT INTO kze_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ísu arumbá umánkena séna Máátaao sáwíva-tantaa'a anón-imayaa ónana enarumbá umbaí kwétaivo ");
INSERT INTO kze_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kesááimo kwéisaimba mindá anón-tantaa'a póna mindáyavena Máríyaa máyáimba pó'a íma ivátuwe'a ai'máráanana kwíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ísu moórá-tawai Áánútuwe aaí kwésuwasa kwená kwayó-kwáásí máyówana Ísu simásuwowana kwená kwaásivinkemba moóráwai séna Ísóigoo Yóni nombá pétinkaiwai kwená kwayó-kwáásí agaráátínkáísasa Áánútuwe aaí kwésentemba kentáá agaráásínkénata Áánútuwe aaí senó súwana ");
INSERT INTO kze_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ísu séna Áánútuwe aaí sénááomba maará sé'a seró. kentáásivoo enáwí'a usáyaaitarain-awita kesáá mósá kwémaraumne. kentáárá'á kawáá-uwoya kwésune. ");
INSERT INTO kze_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","aasiyaasi-táwai kentáásí toóntá simiyó. ");
INSERT INTO kze_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","kwaásimo sáwí'o kwéumasinkewata mindáyaveta anondá íma sáwí'a umátinketa ivátá kwétuwaunaya miráumaiya kentáásí sáwí-imayaa maisiyuwaaó. sáwí'a ígwáe sésamo kentáámó íyamo e súwa'naa íníyone. mirá-áímbá Áánútuwe seró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","simásuwena simátimena séna moórá ená kwaási némpakemba no'wáán-avuntamba tína íma toómbá maké ená kwaásigona ontava'á komé áísaa-e se kesí kwaási némpakemba timbá íma toómbá makáunana káno'a máyáivo toómbá símína'a mááméno sinaná ");
INSERT INTO kze_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","kwená naaúmpakemba séna ontá umásuweta kesí aarai iyámpóíse suúyá kwaiguráumpo íma usásine'a aménaumpo kóaao síníye. ");
INSERT INTO kze_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","kesí kwaási pó'a aménaumne-imayaamo ímo kwéinanamo éna ayáátááka'a inaaí kwésinana íma aigaemá ínana inaaí kwésindayavena usásinena amíníye. ");
INSERT INTO kze_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","miráráán-umai simátime'a sé'a Áánútunopa'o námúnaamo kwésemba áísaa úmae kwéiyiyana timíníye. ááyamae kwéiyiyana kentáái isáníye. kwéavakaa úmae iyíyana Áánútu agaráátinkaniye. ");
INSERT INTO kze_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","áísaa íyanamo éna Áánútu timíníye. kwéaayewanamo éna Áánútu kentáái isáníye. avakáá íyanamo éna Áánútu agaráátinkaniye. ");
INSERT INTO kze_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","keinárawa'a iyámpóígwara-kwaasi kentáánimbaa'o noyáá'a simiyómó síya'o é'a íma iraankavayaambá timénááowe. ");
INSERT INTO kze_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","kokóri-auma simiyómó síya'o é'a íma áwááisaan-uvowamba timénááowe. ");
INSERT INTO kze_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ánivo sáwí-kwaasi ombánivo kentáánimbaa'a kawe-tántáá'á kwétimevo kwíyómpakemba kentáásivowa kaweré su'mai iwáí póna enamambá simiyó síyawai Áánútu kwenamambá timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","moóráwai arumpimbá taraváá-kwámbá máyowana íma aaí kwésuwana Ísu mayauwówana kóúwana minkwáásígó aaí súwasa sáwívarawai awánésa táátavai uwasá ");
INSERT INTO kze_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","évakarawai sésa taraváá-kwántóntí kawááná'á áwí'a Píyésepu asirayámbá amísana tokéna póna taraváá-kwámbá kwémaitiyuwaiye suwasá ");
INSERT INTO kze_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","évakarawai Ísumo sáwí-aimbo sínda isánáe sésa áraira Áánútumpakena kunkáana ímo awánáúnda-mayai máyénata awánaano suwaná ");
INSERT INTO kze_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ísu miwí tááma iséna simátimena séna moórá-andama áái'a tiyésa pósa taaínkaar-umai mésa íma asiramáívakaamba kwémaewe. moórá-akumba usíyán-ákúmbá pósa taaínkaar-umai íma asiramáívakaamba kwémaewe. ");
INSERT INTO kze_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sáátáánigo kwaásimo áái'o tiyésamo taaínkaa'o ésamo ésa íma asiramáívakaamba kwémaewe. kentávé'o sembá Píyésepu asirayámbá ámísana tokéna póna taraváá-kwámbá kwémaitiyuwaiye kwésemba ");
INSERT INTO kze_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ánivo Píyésepuna asirayánká'ó taraváá-kwámbó kwémaitiyuwaundarakai kentí kwaásigwara'a Píyésepuna asirayánká'á taraváá-kwámbá maitiyúwáásino. mirán-áímbó síyasamo ésa kentí kwaási kampa'á kwésewe sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ánivo kemá Áánútuna asirayánká'á taraváá-kwámbá kwémaitiyuwaundayavena Áánútuna asirayámbá keinárawapimba kwévaarisa'a kwéawanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","asirayán-kwáásígó iwevóí tokéna kwená naaka'á kárákwiraisana kwená náaindaamba kawe'á umái kwáyáivo ");
INSERT INTO kze_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","moóráwai kwená asirayámbá usáyaaitaraiwai téna tainkámbai kwená iwevóí asiramái tátokain-iwevoi tayaviyéna kwená náaindaamba tayavírena taaín-timakaiye. ");
INSERT INTO kze_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","kembá íma kwésuwa'naa-esa kesí namuro-kwáásíráámbá umái kwémaewe. íma súwa'naa esa kwaási torupamái símémba kóyáwé kwéumagowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ísu simásuwena moórá-aimba séna kwaási arumpinkémbá taraváá-kwánkó auwéna kavóná-marava'a nombá íma kwáyáipa'a kogwénaaena séna náávara ménaumno séna avakáá uwááena séna tayauweré'a kesí naambá kwaási arumpimbá pó'a koménaumne simásuwena ");
INSERT INTO kze_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","téna taawánaimba mindánkómbá kankambá kwiyú'mái kawer-umásukaisana taawánéna ");
INSERT INTO kze_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tayauweréna avakaeté-taravaa-kwamba miwítí sáwí-mayai anómba uráawai kotí'maena minkwáásígó arumpimbá tamáyáawana moórá-taravaa-kwamba arumpimbá máyáísana minkwáásígó sáwí'a umái máyáísasa naaémba sáwíva-taravaa-kwamba máyáawana kwemá anómba sáwí'a umái méraiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ísu mináímbá simásuwowana sáwíva-kwaasivinkemba moórá-ininko Ísuntavena anónka'a séna enanó embá maránkarena náámba ámakaiwaimba Áánútu kawe'á umánkaraiye súwana ");
INSERT INTO kze_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ísu séna árai'a sémpo Áánútu kwenáái ísámai kawe'á kwéowaima anón-kawe'a kwéumatinkaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","súwasa sáwíva-kwaasi Ísunopa'a tóyo uwaná simátimena séna ívé'o máyáan-kwaasi sáwí-kwaasiman-owe kentávé'a kwésemba Áánútumo ai'mákainamo e ímo awánáúnda-mayai máyénata awánaanomo kwésemba naaóvá'á Áánútu Yónaamba uráintemba kembá mirá ínívo mináímbá imáyáa oró. ");
INSERT INTO kze_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","naaóvá'á Nínívaa-naopaken-kwaasi Yónaa uráintavesa Áánútu ai'mákaiye siráantemba kemó ondá awáné'a Áánútu ai'mákaiye sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","naaóvá'á Yútaa-kwaasira'a kárákwirowai áwí'a Sórómoni kawer-ímáyáávínkémbá aaimá kwésimatimuwana moórá-ininko némpaken-kawaa-ininko Sórómonin-aai koisánáe séna kweémena kuráiye. ívé'a kemá Sórómonimba usáyaaitaraundawai máyauna'a kesáái íma kwéisaamba póna naaémba Áánútu kwaásimo máyáawaina ááintavena tísaa ínín-kanaa tínímba minínínkó keinárawa'a aaivimbá maitinkéna séna kemá némpakemba Sórómonin-aai taísaraumpo Sórómonimba usáyaaitaraiwai kentópa'a máyowa'a kwenááimo ísááraamba íma ísaraawe síníye. ");
INSERT INTO kze_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","naaóvá'á Yónaa Nínívaa-naopa'a Áánútun-aai kosimátimuwasa isésa sáwí-imayaa tuwésa Áánútun-aai ísaraawe. ívé'a Yónaamba usáyaaitaraundawai máyauna'a kesáái íma kwéisaamba póna naaémba Áánútu kwaásimo máyáawaina ááintavesa tísaa ínín-kanaa tínímba Nínívaa-naopaken-kwaasi keinárawa'a aaivimbá maitinkésa sésa Yónaa-aai iséta sáwí-mayai tukáundayaanivo Yónaamba usáyaaitaraiwai kentí naaópa'a máyowa'a kwenáái isé'o sáwí-mayaimo túwááraamba íma tukáawe Nínívaa-naopaken-kwaasi sénááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","oómbó kúra'maraamba íma aúpá'á maráíyamba avora'á mayáíyasa naaúmpa'o iyíyawai awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","miráumai túranko kentí imáyáavimbo sáma kaí-yántáá'án-iye. túrankomo kawe'ó umáímo awánáínanamo éna amápar-imayaa sáma káníye. túrankomo ímo kawe'ó umáímo awánáínanamo éna amápar-imayaa túnkwiniye. ");
INSERT INTO kze_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","kentí sáma kaí-yántáá'á túnkwiyavainivo kentúra'a kárákwimai kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","kentí imáyáago íma túnkwimba amápa'a sáma kwégaimba oómbá sáma kamátinkaintemba póna kentí imáyáago kentúra'a sáma kamátinkaniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ísu mináímbá simásuwowana moóráwai ámáán-kawaa-kwaasigo Ísunopa'a téna séna kesí naaúmpa'a toómbá umandaaó súwana toómbá naaíndayavena uména ");
INSERT INTO kze_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","íma ayáámba sese umásuwena toómbá kwénowana minkwáásígó awánéna áátavai éna imáyáa úwana ");
INSERT INTO kze_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ísóigo awánéna simámena séna kemá ámáán-kawaa-kwaasi anavéúne táávere paákáré su'mai kwésese ovo andáámpa'a sáwí'a uráisa'a túran-anda kwée'a sáwí'a kwéowe. ");
INSERT INTO kze_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","sáwí-imayaagwara-kwaasi máyáawe. Áánútu paáká-tántáá'á éna andáámpa-tantaare imáyáawe mindágwara'a uráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","kentí imáyáamo arupí é'o kemó makén-tantaa'o ímo makén-kwaasi timé'o é'a kentí imáyáao kawe'á íníye. ");
INSERT INTO kze_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","kemá ámáán-kawaa-kwaasi kentí kígauvakemba sáwíyan-tonkwara'a taaínkaar-umai siyáánkai maké'a moórá Áánútumba kwéame'a kawe'á kwée'a mirán-áímbá ísámai iyé'anivo anón-amaamba ivá'á tu'maré'a pó'a Áánútumba íma imáyáa kwéame'a óísaniyaain-kwaasi sáwí'a kwéumatinkaantavai kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","kemá ámáán-kawaa-kwaasi mono'-náúmpá'á umé'a kawer-áyámpá'á kwaási túranka'o umáémba tiráái kwétaiye. marupá'ó umáyáawasa kwaási tuwánésa kawer-áímbó sembá tiráái kwétaimba pó'a kentúra'a kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","kwaásimo maipímbó utámakaawanamo kaviraisasamó kwaási ímo awánaantemba kentirumpimbá mirá isa'á sáwí'a kwéowasa kwaási íma kwétuwanaamba pó'a kárákwiyoro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ísu simásuwowana moóráwai ámáámba sún-kwaasigo Ísuntavena séna mirámó sénda kentáágwárá'á simáíya sáwíta kwéumasinkaane súwana ");
INSERT INTO kze_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ísu séna kemá ámáámba sen-kwáásí kemó ámáámbo simátímén-ainko umbaí kwétiyaisa'a mináímbá íma kwétuwa'naa-omba pó'a kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","kentíkwá'ná Áánútun-aai simátímakaawai tínkamuwasa púwúwa'a utamátínkaraapa'a konaarirí kwéowe. naaóvá'á kentíkwá'ná uráantave'a kawe'á uráawe sé'a utamátínkaraapa'a konaarirí kwéomba pó'a kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","naaóvá'á Áánútu kawer-ímáyáávínkémbá séna kesáái simátimenaaowaiye agaráátinkanaaowaiye ti'máráanasa miwívímbá kwénaaiyasa évakarawai sáwí'a umátinkesa évakarawai tínkamiyasa puwónááowe Áánútumo siráimba mináímbá paáruraiye. ");
INSERT INTO kze_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","naaóvákwárá avumpinkwárá naaénkwara'a Áánútun-aai simátímakowaima tínkamuwasa pukáantavai póna misáwí'ó uráawaina anondá-meyamba ívé'o máyáan-kwaasitopa'a tíníye. ");
INSERT INTO kze_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","aiva'ó tuvúwanamo pukáin-kwaasigo áwí'a Épeo naaémba moóráwai áwí'a Sékáraya anóm-bono'-naumpa'a máyowana moórá-ayampa'a Áánútuntavesamo ísámaimo póímo tuvú'máímo agáyáan-ontan-tarei kwáyowana moórá-ayampa'a aiva'-mónó-káwáánákówé su'mai iyún-ontama kwáyowana avumpimbá Sékáraya umáyowasa túvúwana pukáiye. minkáé-kwáásíráí avumpimbá tínkamuwasa pukáawaigwara'a miwítí sáwí-meyamba ívé'o máyáan-kwaasi mayánááowe. ");
INSERT INTO kze_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","kemó ámáámbo sen-kwáásí árair-aimbo ímo aúpá'ó tukáankakai mináímbá ísámai kawer-osinó. kemá íma ísámai kawer-ombá ó'on-kwaasiti aambá aúnkaamba pó'a kárákwiyoro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ísu mináímbá simásuwena máápa'a kumúwasa ámáámba sun-kwáásíyé ámáán-kawaa-kwaasiye tirumpimbá áwáá'a aéésa ó'on-o'on-tantaatavesa áísaa umai ísáananamo ");
INSERT INTO kze_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","aaimó kaé'mái-aimbo sína'o é'a aaivimbá mayankánáe sésa áísaa uráawe. ");
INSERT INTO kze_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","mitáwai ávááraumai sáwíva-kwaasi torupésa sisipáá umái máyówana Ísu kwená kwayó-kwáásí simátimena séna ámáán-kawaa-kwaasi kaumbo-káér-ainkwara-kwaasiraamba ovó íma miráumai máéro. intóráín-tantaa'a sáwíyan-tantaa'a moórá-tonko áwí'a péréti mimpímbá kwémaraawana kwéintorena anómba intembá ámáán-kawaa-kwaasiti sáwí-aimba mirá kwéivo keinárawapimba misáwí-áínkó anómba tiváínivo kentúra'a kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","aúpá'ó kwáyáin-tantaa'a amápa'a avora'á paárínasa awánanaaowe. túnkaipa'a kwáyáin-tantaa'a avora'á paárínasa awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","no'wáámbo siráan-aimba sán-káíndara'a síyasa isánááowe. aúpá'ó siráan-aimba amápa-kwaasi túranka'a síyasa isánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ísu simásuwena séna kesí kwaási simátíménda ísáaro. évakarawai tínkamiya'a puwónááovo moórá sáwí'o umátinkai-yantaa'a íma kwéraivo íma miwíyávé'a inkáíséro. ");
INSERT INTO kze_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","kemá simátime'a sé'a Áánútu máyáivo kwenáároi inkáíséro. kwemó tínkamina'o puwónááombo éna kemá kanaán-umai sáwí-marupa'o iramó kwégaipa'a mátiyuwaniye. mináímbá Áánútuntave'a inkáíséro-aimba kwésune Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ísu simásuwena séna sáwíyan-dumama téntékaan-dumama éva'aasei-numama sáwíyan-ontandei kae-tóyáráán-óntándéí kwémeyan-ovo Áánútu kíraan-dumama íma awinkaiwáímá póna awánaraiye. ");
INSERT INTO kze_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","numamá kíto-tantaa'a awánaiwaima póna kwaásima anón-tantaa'a ovó íma táá'a kaíno. kenti'nóntáuma kwétaampaiwaiman-ivo íma táá'a kaíno Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ísu simásuwena séna simátime'a sé'a amáparawai túranka'a kentávésa sésa Áánútu ai'máráísana kunkáiwai kesí anóndakoman-iye síyawaiyave'a kemá kwaási úrandako kumpaáruraundawai Áánútuna kwayó'nárawa'a kwíyómpakewai túranka'a sé'a kesí kwaásiman-owe sénaumne. ");
INSERT INTO kze_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ánivo kwaási túranka'a kembá tínaaemba umásimiyawaiyave'a kemá Áánútuna kwayó'nárawa túranka'a sínaaemba umátimenaumne. ");
INSERT INTO kze_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","kembá kwaási úrandako kumpaáruraundawaimba simái sáwí'a umásinkanaaomba mindá Áánútu maitiyuwánívo Áánútun-amankomba simái sáwí'a umánkanaaomba mindá Áánútu íma maitiyuwáinana miwísé kwaíkwai'a íníye. ");
INSERT INTO kze_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","kesí kwaási-i'a ontáváí táto'mai tí'maesamo anón-kwaasiye mono-káwáá-kwáásíyé túranka'o mátínkaresamo aaivimbá maitínkéwa'o é'a nóran-aimbo síyamba íma táá'a káínana ");
INSERT INTO kze_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Áánútun-amanko sénááon-aimba úwoi tááka'a tinkáína'a sénááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","súwana sáwíva-kwaasivinkemba moóráwai Ísuntavena séna anóndakoo kesivo púwísana kesuwaá amápa-tantaa'a mairéna íma taaímbai kwésimivo emá sinaná taaímbai násimino súwana ");
INSERT INTO kze_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ísu séna kesí kwaásiyo mináímbá íma koisé'a keáváráwaiti náaindaamba íma taaín-timenaumne simámena ");
INSERT INTO kze_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","amáparawaiyavena séna kwaási kawe'á umái máyáawaiti ááimba íma sáwíva'-naaindaamba makáavo náaindaamba mayánáe seéme'a máyáavainivo kentúra'a kárákwiyoro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","simásuwena moórá-aimba simátimena séna moóráwai sáwíva'-naaindaamba makáindawai kwená kígauva'a sáwíva-tomba kwáyáísana ");
INSERT INTO kze_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","kwesáváí-ímáyáá éna sáwíva-tombo áká'maimo maránaunda-namba íma kwáyáivo nóra ónaumno. ");
INSERT INTO kze_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","mirámó é'a toómbá makáunda-namba tawísíyuwe'a anón-damba úmare'a mimpímbá amápa-tomba áká'mai maré'a kesí náaindaankwara'a maránaumne. ");
INSERT INTO kze_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","mirámó é'o é'a kesáváí sé'a amápa-tantaa'a íma aáváán-tuwáúnda toómbá námai iyé'a nombá námai iyé'a ayáátááka'a úwoi mé'a onaná sirunkó kawe'á kwéina'a ménaumne kwésisana ");
INSERT INTO kze_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Áánútu simámena séna sáwí'o úmae kwénaaonda-kwaasima óne. ívé'-no'waamba puwéma esáváí makáanda-naaindaamba túwénana nááwa mayáníyo Áánútu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","marapá'á esáváí-nááíndááné su'mai makáiyawai mirán-kwáásímán-ivo marapá-tántááré su'mai marésa Áánútumpaken-tantaa'a íma makáawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ísu mináímbá simásuwena kwená kwayó-kwáásíyávéna séna kwésimtime'a sé'a miráráán-umai máyáamba íma anón-imayaa é'a toómbó nánááontave'a íma anón-imayaa é'a kentúra'o unáánkwátóimo ónááontave'a íma anón-imayaa oró. ");
INSERT INTO kze_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","toómbó nánááomba úwoisambanivo kwaásimo máyáamba anón-tantaa'an-iye. unáánkwátói ónááomba úwoisambanivo kwaási túma anón-tantaa'an-iye. ");
INSERT INTO kze_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","numagómpá'á imáyáa oró. numaó íma kígau kwéena toómbá áká'mai naaúmpa'a makéna nánívo Áánútu miwítí toómbá tímísasa kwénaawe. Áánútu aúranka'a numaómá kíto-tantaa'an-ivo kwaási anón-tantaa'a póna kentí toómbó éna timíníye. ");
INSERT INTO kze_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","keinárawa'a anón-imayaamo é'o é'a kentí maíyan-kanaama íma kanaán-umai ayáátááka'a ménaaowe. ");
INSERT INTO kze_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","mindá sáwíyan-tantaa'a isa'á íma kanaán-umai ónááomba pó'a ó'on-o'on-tantaatave'a íma anón-imayaa oró. ");
INSERT INTO kze_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","kwaigwandáánká'á imáyáa oró. kwaigwandáánkó íma kígau éna íma kwená unáánkwátói makáivo simátime'a sé'a naaóvá'á Yútaa-kwaasiti anóndako áwí'a Sórómoni kwemá sáwívar-unankwatoiye konaariríyé makáiwai úwasa kwaási awánésa kawe'án-iye sumbánivo kwaigwandáán-aramba awánésa anón-kawe'an-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","uvá'á konaarirí-yántááré séna kwaigwandáámbá Áánútu uvá'á makáiye. umá íma kwaíkwai'a ínívo ívé'a ínasa aaváyaa kwaási agaisuwánááomba Áánútu mintántáá'á imáyáa kwéena konaarirí-yántáá'á makáiye. miráumai Áánútu kwaásiyavena imáyáa éna kentí unáánkwátói timínímba pó'a keinárawa'a maarán-áímbá ímo seráámbá Áánútu íma kanaán-umai kwésuwa'naa-iwaiman-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Áánútu kwétuwa'naa-imba pó'a toómbó nombó nánááontave'a íma anón-imayaa oró. ");
INSERT INTO kze_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","moórá-mora-maravaken-kwaasi Áánútun-aai íma ísáan-kwaasi toómbó nombó nánááontavesa anón-imayaa kwéowe. toómbó nombó ímo kwéne'o é'a puwónááontavena kentivo mintántáátávéna imáyáa kwéivo íma anón-imayaa kwée'a ");
INSERT INTO kze_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Áánútu kwená kwaási kwégawaaintave'a imáyáa íyana mintántáá'á timíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ísu simásuwena kwená kwayó-kwáásíyávéna séna kemá kesínaaemba kwégwaraawai kárákwiraumne. kentáásivomo simbá kesí kwaási kawáá ondá keinárawagwara'a kawáá ónááowe. mirá íyana kesirunkó kawe'á íníye simbá póna íma táá'a kaíno. ");
INSERT INTO kze_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","kentí náaindaamba kwétime'a meéyámbá mairé'a ímo makén-kwaasi tíméro. mirámó kwéiyana kentí kawe'-méyámbá kwíyómpa'a kwáyáinasa kwaási íma umóyámbá íyana íma avíyaraamba káínana kawe'á umái aasiyaasí kwaíkwai'a ína'a minkáwé'-méyántávé'a imáyáa é'a ");
INSERT INTO kze_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","marapá'ó kentí óísambo kwáyainanamo éna marapátávéna tinkánívo kwíyómpa'o kentí óísambo kwáyainanamo éna kwíyómpatavena tinkáníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ísu simásuwena séna anón-kwaasigo aaraimá kwétokwaa on-tánómbá komandánáe séna kwínasa kwená mayáí-kwáásí unáánkwátói úmaresa mésa oómbá kúra'makesa amu'matuwé méwana téna tááyainasa avekáámbá onta tiyankánááowe. miwí kwéto'mayaa ontembá keinárawa'a kwéto'mayaa e'a amu'maré'a máéro. ");
INSERT INTO kze_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","minánón-kwáásígó tínda kwená mayáí-kwáásí koku'á mésa amu'matuwé ménka'a tínana tirunkó kawe'á íníye. árai'a simátime'a sé'a minánón-kwáásígó mayáí mayáíndayavena unáánkwátói ayú'mái móruna maréna minkwáásíyóntávéna maanká'á méwa'a toómbá tíméro síníye. ");
INSERT INTO kze_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","minánón-kwáásígó no'wáán-avuntana'i. irataróra'iyo. tínda kwená mayáí-kwáásí koku'á mésa amu'matuwé ménka'a tínana tirunkó kawe'á íníye. ");
INSERT INTO kze_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","simátíménda-aimba imáyáa oró. naankó avowámó umóyán-kwáásímó tínín-kanaamo isénaraai umóyán-kwáásí timbá kwéto'mayaa ena awánéna kwatúwáísana kwená naaúmpakemba umóyámbá íma máyáísino. ");
INSERT INTO kze_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","miráumai kemá kwaási úrandako kumpaáruraundawai kumónaundayave'a pó'a keinárawa'a íma imáyáa kwéiyanka'a kumúnavainivo kwéto'mayaa e'a simu'maré'a máéro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","súwana Pítaa séna Ísóigoo emó sénda-aimba kentááyáváíyé su'mai kwése. amápa-kwaasiyavaigwarara kwéseno súwana ");
INSERT INTO kze_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ísóigo séna kawe'-máyáímó kwémayaawai kawer-ímáyáágwárá-kwáásíyávé'a kwésune. miwítí anóndako séna kesí mayáí-kwáásírá'á kárákwire'a toómbá taaímbai tíma'mae'a íyóro síníye. ");
INSERT INTO kze_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","miwítí anóndako téna mayáímó kawe'ó umáímo mayáínda tatuwánáínana mayáímó kwémayaindawai tirunkó kawe'á ínana ");
INSERT INTO kze_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","minánóndákó séna kesí náaindaamba amápa-tantaaka'a kárákwiyoro síníye. ");
INSERT INTO kze_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ánivo mimbáyáí-kwáásímó imáyáamo ésamo kesí anóndako ayáátááka'a íma tíníye sésamo mayáí-ínínákwá'ó tínkamesamo toómbó nésamo uwoaó'-nómbó kwénesamo uwoaó'ó ésamo ");
INSERT INTO kze_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","miwítí anóndako tínín-kanaa ímo ísaresamo ímo imáyáa kwéindara'a téna anónka'a tatínkambai Áánútun-aai ímo kwéisaan-kwaasi máyáapa'a mótinkaniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ísu simásuwena séna mayáí-kwáásí miwítí anón-kwaasigon-aai isésa kwemó síndantemba íma íyamba máyáawana anón-kwaasigo téna anónka'a tatínkaminiye. ");
INSERT INTO kze_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ánivo mayáí-kwáásí miwítí anón-kwaasigon-aai íma isésamo ombá sáwí'a ésa máyáawana anón-kwaasigo téna sáwíyanka'a tatínkaminiye. Áánútu kawer-ímáyáá anómba tímakaiyawai anóm-bayai máyáaro. kawer-ímáyáá anómba tokáiyawai kwaási túwa'naa oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ísu simásuwena séna iramó kaintembá mayáímá máyáandayave'a marapá'á kumbáyaunda mimbáyáí ánásainana kawe'á íníye-imayaa kwéune. ");
INSERT INTO kze_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","sáwíyanka'a kembá sí'a índai'a ónááontavena sirunkó umbaí kwétaisana sí'o índai'o ónááomba ánásainana sirunkó kawe'á íníye. ");
INSERT INTO kze_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","kentávé'a maarán-ímáyáá íma oró. kwaási amápa'a paru umái máyáantavena marapá'á kunkáiye. ímanivo marapá'á kunkáunda kwaási taaínkaa'a ésa évakarawai kesáái isáíyasa évakarawai íma isánááowe. ");
INSERT INTO kze_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ívékwara aánogwara'a moórá-naumpa'a éva'aasei-kwaasi mésa kesááiyavesa miwítí imáyáa taaínkaar-urésa kaumbonárau moórá-imayaa íyasa kae'nárai ó'on-imayaa óyááoiye. ");
INSERT INTO kze_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","avowámá moórá-imayaa ínana ááninko ó'on-imayaa íníye. anówama moórá-imayaa ínana ayáámúnko ó'on-imayaa íníye. anáávukoe ó'on-o'on-imayaa óyááoiye. kesááiyavesa miráumai miwítí imáyáa taaínkaa'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ísu sáwíva-kwaasiyavena séna ainámbó kwáyaina'o é'a sé'a aa'á tíníye kwésiyana aa'á tíníye. ");
INSERT INTO kze_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","úndá to'mái ánásaina'o é'a sé'a aa'á káníye kwésiyana aa'á káníye. ");
INSERT INTO kze_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","kwíyómpa'o awáné'o ombá sé'a aa'á káníye. aa'á tíníye kwésemba mintántáá'á awánaraawe. kae'náér-on-kwaasi pó'a mirán-tántáákóná ááimba awánaambanivo Áánútu ívé'o kwéin-tantaakona ááimba íma awánaraawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ísu séna simátíménda-aimba ísáiyuwe'a minkáér-ámpá'á taaínkaa'a uré'a moórá-ampare su'mai koró. ");
INSERT INTO kze_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","moórá-aimba ísáaro. aaimó simátinkanae síyawaimo tí'mae kwíyasa aampa'á mósimai paárumasuwesa koró. anón-kwaasimo mátimiyasamo ésa i-kwáásí timíyasa ándá-naumpa'a tinkánááowe. ");
INSERT INTO kze_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ímo mirámó íyasamo ésa ándá-naumpa'a mótinkaiyasa íma ááéma ánásanaumne sésa amápa'-meyamba tímatuwaiyasa ayútinkanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ísu kwésimatimuwasa évakarawai tasimámesa sésa Káríri-maravaken-kwaasi évakarawai Áánútuntavesa ísámai póímo tuvú'mái agáyáamba kámááni-kwaasiti anóndako áwí'a Páíráti évakarawai ti'máráísasa tínkamisasa pukáawe suwaná ");
INSERT INTO kze_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ísu séna miKárírívákémbá pukáan-kwaasiyave'a sembá miwítí sáwí-imayaao Kárírivakemba amáparawaiti sáwí-imayaagomba usáyaaitaraintavesa pukáawewa kwéseo. ");
INSERT INTO kze_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","íma mirá kwéovo simátime'a sé'a kentí sáwí-imayaamo ímo tuwé'o Áánútumpa'o té'o é'a keinárawakwara'a puwónááowe. ");
INSERT INTO kze_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","imáyáa oró. Síróamuva'a ayáátáá'-namba tawiséna sáwíva-kwaasi 18 kwaasi tínkamisasa pukáawe. mindáyave'a sembá miwítí sáwí-imayaao Yérúsaremuvakemba amáparawaiti sáwí-imayaagomba usáyaaitaraintavena pukáawewa kwéseo. ");
INSERT INTO kze_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","íma mirá kwéovo simátime'a sé'a kentí sáwí-imayaamo ímo tuwé'o Áánutumpa'o té'o é'a keinárawakwara'a puwónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ísu kwántámai-aimba simátimena séna moóráwai kwená ándá-aran-kigauva'a áséi-aramba íyain-taima u'makáisana áruma kwíkáísana arambá komayánáe séna koawánaimba íma iráisana ");
INSERT INTO kze_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","minkígáúrá'á kárákwirain-kwaasiyavena séna kaumborá'á áú'a simbá mintáéramba komayánáe'a koawánáúnda íma arambá iráisa'a úmpo mintáímá tumásuwaao. maragóná anombá nasúwáívainivo tumásuwaao sisaná ");
INSERT INTO kze_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","mindákó séna anóndako ímampo'a mintáíyááimpa'a oó'á túmake'a agámo'a maké'a ");
INSERT INTO kze_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","moórá-au'o sínda awánaanana arambó iyéna kawe'á ínívo mirámó ímo ína'a tumásuwanaumne siráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","moórá-tawai Yútaa-kwaasi monor-áímbá kwéison-kanaara'a Ísu mono'-náúmpá'á uména aaí kwésimatimuwana ");
INSERT INTO kze_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","moórá-ininko taraváá-kwámbá arumpimbá máyon-ininko ména ayáátááka'a sáwí'a umái ména 18 ima maisuwéna miráumai sáwí'a umái máyowana arósáánumba káínáívai kurówana íma kanaán-umai koku'á máyowana ");
INSERT INTO kze_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ísu minínínkómbá awánéna séna enáí'a ánásaino séna ");
INSERT INTO kze_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ane'á tátorowana avekáámbá arósáánumba arupí úwana koku'á usásinena Áánútu áwí'a mósá marówana ");
INSERT INTO kze_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ísu agándon-kanaara'a minínínkómbá asóvamankontavena mono'-nánká'á kárákwirowai arunkó sáwí'a úwana sáwíva-kwaasiyavena séna ava'moraé-kanaa mayáí kwémayenka'a sí'a asóvamasinkainkwae sé'o é'a té'a agándaan-kanaamo é'a íma teró súwana ");
INSERT INTO kze_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ísóigo séna kaumbo-káér-ainkwara-kwaasiman-owe. agándaan-kanaara'a kentí purumakankwárá'á tónki-poigwara'a naaúmpakemba ayúranke'a áí'mae'a nompá'á kowaná nombá kwénaiye. ");
INSERT INTO kze_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","minínínkó Ááváramu aísaavutantamba uráin-inimba isaná Sáátáánigo ayáátááka'a 18 ima tátokaisa'a agándaan-kanaara'a ayúrankauna'a sáwí'a kwéone kwésewe Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","simáímo sáwí'o umánkówai mináímbá isésa tigaemá uwaná kawe'-máyáí kwémayontavena úwoi-kwaasi tirunkó kawe'á uráiye. ");
INSERT INTO kze_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ísu séna Áánútu kwená kwaási kawááimba nóinkara kwégawaaiyompo maarán-áímbá simátínéna'a isánááowe. ");
INSERT INTO kze_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Áánútu kwená kwaási kwégawaaimba maarámán-iye. moóráwai sáwíyan-taeranko áwí'a másátati mintáérámbá kígauva'a u'makáisana anón-éna amaimá móivarena kóyáwé uráisana numaómá mimpímpá'á ánáamba úmarena kwémaiye. Áánútumo kwená kwaási kwégawaaimba miráráámbá éna kwenááigo sáwíyamba kwaási tirumpimbá kunkwéna anómba kwéiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","simásuwena séna Áánútu kwená kwaási kwégawaaimba nóinkara kwégawaaiyompo maarán-áímbá simátíména'a isánááowe. ");
INSERT INTO kze_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","moórá-ininko péréti-tomba agayánáe séna kanaráán-tántáákó áwí'a páráwaa'a maimaéna intoráí-yántáá'á sáwíyan-tantaa'a ayáúmaraisana kwéna intoréna kwéanon-iye. Áánútu kwená kwaásimo kawááimba miráráán-umai kwenááigo kwaási tirumpimbá sáwíyamba kunkwéna anómba kunkwéiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ísu mináímbá simásuwena Yérúsaremu-naor-ampa'a kúmba naaó'-nao'a kwenáái simátíma'maena kúwana ");
INSERT INTO kze_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","moóráwai séna anóndakoo Áánútu moórá-mora-kwaasiye su'maiya kawer-ámpá'á métinkaniyo súwana Ísu séna ");
INSERT INTO kze_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","tiyáántámba égési úmae'a sáwíyan-ontavimba usáveranaaowe. simátime'a sé'a sáwívarawai usáveranae sésa íyambanivo íma kanaán-umai usáveranaaowe. ");
INSERT INTO kze_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","naankó avowámá usásinena ontá úmaraina'a ontará'á umé'a ááye'a sé'a anóndakoo ontayá tisinkaaó síyana íma tuwánáúnda-kwaasi náávakena'oo sína'a ");
INSERT INTO kze_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","kentáásí naaópa'a te enáái tasimásimenata eséya toómbá nombá naráundayaawe síyana ");
INSERT INTO kze_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kwemá séna íma tuwánáúnda-kwaasi kentí naambárure kentóikare íma tuwánáúnda-kwaasin-ovo kóro naankó avowámá síníye Ísu simásuwena séna ");
INSERT INTO kze_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Áánútu kwená kwaási kawááipa'a ti'maráína'a máápakemba awánáíyamba kentíkwá'ná Ááváramuwe Áísákaawe Yákópowe Áánútun-aai simátímakowaiye Áánútu kwégawaaipa'a méwa'a tuwáné'a tíyántave'a é'a ivi'á tánááowe. ");
INSERT INTO kze_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","aaváúmá usaipakén-kwáásíyé aaváúmá kumpéráipaken-kwaasiye évarevar-awampaken-kwaasiye Áánútu kawááipa'a tésa tamésa nánááowe. ");
INSERT INTO kze_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","minkánáárá'á naaén-kwaasivinkemba évakarawai aivarí'a ónááovo aiva-kwáásí naaéni'a ónááowe Ísu Áánútumo kawááintavena mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","mitáwai ámáán-kawaa-kwaasi évakarawai Ísunopa'a tésa sésa anón-kwaasi áwí'a Éróti séna Ísumba tuvúwónana puwíníye kwésivo maanká'á tuwé ó'om-bapa'a kówaao suwaná ");
INSERT INTO kze_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ísu séna Érótimba iyánaankaraama túwáín-kwaasi kosimáme'a sé'a taraváá-kwámbá kwaási tirumpinkémbá kwémaitiyuwe'a tí'a on-kwáásí kwéasovamatinkaunda-mayai ívé'a maé'a aaváyaa maé'a ayúnká kesí mayáí ánásanaumne. ");
INSERT INTO kze_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Áánútun-aai simátímakaawai Yérúsaremu-naopare su'mai kwétinkamowasa kwévuwontave'a ívé'a aaváyaa ayúnká aampa'á kwégwe'a mayáí maivá kónaumne siyé Érótimba kosimáméro Ísu simásuwena ");
INSERT INTO kze_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yérúsaremu-naopaken-kwaasi arumbá umátinkena séna Yérúsaremu-naopaken-kwaasiyono. Áánútun-aai simátímakowai tínkambae'a kwéiyuwasa pukáawe. Áánútu ti'marówasa kurówai óntantamba tínkambae'a kwéiyuwasa pukáawe. kokórigomo áráátombo ayóí-ándámpá'ó tínkarenamo káátamatinkaintemba aasiyaasi-táwai kemá mirá ónaumne kwésundanivo tínaaemba kwéumasimewe. ");
INSERT INTO kze_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ísáaro. Áánútu tiyuwáína'a tu'nankáámbá ónááowe. simátime'a sé'a íma úwoi suwánanaaovo naaémbo sé'o Áánútu ai'máráísana kunkáiwaimba Áánútu kawe'á kwéumankaiye síyanka'a moórágwara'a suwánanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","moórá-tawai agándon-kanaara'a Ísu ámáán-kawaa-kwaasi anón-kwaasigona naaúmpa'a toómbá náíndayavena umáyowasa agándai-kanaara'o Ísumo nóramo índa awánanae sésa umésa awánowana ");
INSERT INTO kze_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","moóráwai aíyayaamba kwéintoron-kwaasigo kwená egwaa'á máyowana ");
INSERT INTO kze_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ísu minkwáásígómbá awánéna ámáán-kawaa-kwaasigo ámáámba sun-kwáásíyé tísaa ena séna agándaan-kanaara'a kanaarárá áí'o in-kwáásí asóvamankanaundaya'iyo súwasa ");
INSERT INTO kze_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","isésa íma aaí suwaná minkwáásígómbá áí'mai kawe'á umánkena séna ánivo kuwó súwana kóúwana ");
INSERT INTO kze_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","tísaa ena séna keinárawapinkemba kentí iyámpóíya'i. kentí póráára'iyo. maipímbó pékaina'o é'a agándai-kanaara'a ááéma mósá asinánááoo Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","mináímbá íma kanaán-umai anondá siráawe. ");
INSERT INTO kze_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","aaí íma anondá suwasá toómbó nánáesamo tun-kwáásí aiva'á uménaemo sumbá Ísu tuwánéna kwántámai-aimba séna ");
INSERT INTO kze_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","moóráwai séna aaraimó tokwaa on-tánómbá tamandaaó sína íma aiva'á umaiyó. aiva'ó uménanamo enáwí'o usáyaaitaraindawaimo tínanamo éna ");
INSERT INTO kze_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tááyaindawai entávéna séna usásinenana maankwáásígó maanká'á tamaíno sínana aigaemá umásuwe tínaaempa'a kumbéniyone. ");
INSERT INTO kze_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ánivo tááyainamo tínaaempa'o uménanamo tááyainda-kwaasigomo kweyááríka'o entávénamo séna kesí kwaásiyo usásine aiva'á umaiyó sínamo umáínasa awánésa enáwí'a mósá maránááowe. ");
INSERT INTO kze_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","anón-kwaasima úne síyawaima Áánútu miwí túwí'a móruna tiyuwánívo sáwíyan-kwaasima úne síyawaima Áánútu miwí túwí'a maimaé iyíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ísu simásuwena ááyarowaiyavena séna anón-tanomba kauvónáe sinda-táwai óísankwara-kwaasiye enamááraawe ená akúné ená kwaásiye su'mai íma tááyao. mirámó inasamó ésa naaémba ááyewa toómbá komandáníyonda mindá ená toónkóná anondáman-iye. ");
INSERT INTO kze_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ánivo anón-tanomba kauvónáe sinda-táwai ímo óísambo makén-kwaasiye tíyayaamba sáwí'a urén-kwaasiye aúgavitan-kwaasiye tááyenasa tamandánááombanivo ");
INSERT INTO kze_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ená toónkóná anondáma íma amíyambanivo enarunkó kawe'á ínana Áánútu ená toónkóná anondáma amíníye. naaémba arupí umái mén-kwaasi pukémpinkemba usásinaiya-tawai Áánútu amíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","mináímbá súwasa Ísuwe toómbá kwénowai isésa uwaná moóráwai séna Áánútu kwená kwaási kawááipa'a toómbá nánááowai tirunkó aamoí íníye súwana ");
INSERT INTO kze_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ísu séna árai'a simbánivo simátíménda imáyáa oró. moóráwai anón-tanomba kauvónáe séna sáwíva-kwaasi tááyamakena máyáísana ");
INSERT INTO kze_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","mintánómbó nánááon-kanaa sáwíyanka'a tínana kwená mayáí-kwáásígómbá ai'máráísana tááyaraiwaiyavena séna toómbó naí kwéto'mayaan-ivo teró sisasá ");
INSERT INTO kze_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","miwí íma tií-áímbá sewaná moóráwai séna maramá meéyán-ure'a koawánanaumpo íma tanómba kauvópa'a kónaumne siyé kosimámiyo sisaná ");
INSERT INTO kze_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","moóráwai séna siyáánkai-poima meéyán-ure'a koawánanaumpo íma tanómba kauvópa'a kónaumne siyé kosimámiyo sisaná ");
INSERT INTO kze_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","moóráwai séna ívé'a aaraí mairáunda pó'a tanómba kauvópa'a íma kónaumne siyé kosimámiyo sisaná ");
INSERT INTO kze_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","mimbáyáí-kwáásígó kwená anóndakonopa'a téna mirá sewé tasimámísana arunkó sáwí'a isaná séna avekáámbá naaó'-nao'a kwénaae tíyayaamba sáwí'a uráinda-kwaasiye túramba kavíkáinda-kwaasiye óísamba íma makén-kwaasiye tivakáá-umai tí'mae tiyó séna ai'máráísana ");
INSERT INTO kze_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","mimbáyáí-kwáásígó mirá kosimái koyauweréna taséna simásimendantemba kosimái tí'mae'a túnda ená naaúmpa'a paaí karekó'a umái máyáawe sisaná ");
INSERT INTO kze_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","kwená anóndako séna amápa-kwaasi kesí naaúmpata sisipáá oró. amápar-ampa'a kwénaae kwaásimo tivakáá-e asiramái simái tí'mae tiyó siráiye. ");
INSERT INTO kze_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ísu séna simátime'a sé'a aiva'ó tááyaraiwai íma tésa kwená toómbá íma tamandánááowe Ísu mináímbá kwántámai-aimba siráiye. ");
INSERT INTO kze_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","súwasa Ísuwe aampa'á kuwaná mégwantena simátimena séna ");
INSERT INTO kze_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","kesínaaemba kwaránáe síyawai aiva'á kembá imáyáa simésa naaémba anóvowiye awainínkówé kwená iyámpóíye kwenávárawaawe kwenáúnavare kwesáváíyé imáyáa oró. ímo mirámó íyamba uwóví'a ónááovo mirámó ésamo ésa kesínaaemba kwarésa kesí kwayó-kwáásí-í'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","kemó puwónaunda-taimo súgwaata'mae'o kondantembá kesínaaemba kwaránááowaima umbai-yántáá'á timíyasa minúmbáí-yántáá'ó ímo maimaésamo sínaaembo kwáráamba uwóví'a ombá pósa íma kesí kwayó-kwáásí-í'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","moórá-aimba ísáaro. ayáátáá'-namba ónáe síyawai aiva'á óntambo tuwésamo ónááon-imayaa ésa óntamba táámpamai awánáíyambo kanaamó ínasamo ésa mináyáátáá'-námbá ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","ímo táápamaimo awánaresamo mindámbó íyamba minóntámbá ánásagwinana mindámbá úwoi kwáyainasa kwaási awánésa íma áságwimai umásukaawe sésa tuwírááima sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","moórá-aimba ísáaro. moórá áái'a tiyáívín-ánón-kwáásígó áái'a tiyánáe séna aiva'á kwená i-kwáásí táámpainda sáwíva-kwaasi 10,000 kwaasi ínana ó'on-i-kwaasiti anóndako kwená i-kwáásí táámpainda ávááraumai sáwíva-kwaasi 20,000 kwaasi ínana imáyáa éna kembá usáyaaitanaao. íya usáyaaitanaaoo séna ");
INSERT INTO kze_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","íma kanaán-umai usáyaaitanaumne-imayaamo énamo éna anón-kwaasi némpa'a máyainana aantá-kwaasi ti'maréna séna íma áái'a tiyánaundayaanivo úwoiya ménaum. nóraya ónaumno siyé kosimáméro síníye. ");
INSERT INTO kze_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ísu mináímbá simásuwena séna aiva'á ónááon-imayaa urésa naaémba síyantemba ónááowe. miráumai kesínaaemba kwaránáe síyawai aiva'á makáan-tantaatavesa imáyáa urésa íma mintántáá'á tuwánaumnemo sésamo ésa kesínaaemba íma kwaránááovo mintántáá'á tuwánaumnemo sésamo ésa kesínaaemba kwarésa kesí kwayó-kwáásí-í'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ísu simásuwena séna uwímá kawe-tántáá'á imbánivo anómba ánásaisana ayáántámba kwáyáimbanivo ó'a uwímó káí'a íma úmaranaaowe. ");
INSERT INTO kze_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ayáántámba íma agámo'a maráíyana kawe'á ínívo úwoiva'a tuwánááowe. kwéisaawai ísámai kawe'á oró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","táákísi-ontamba kwémayon-umoyan-kwaasiye sáwí'a kwéun-kwaasiye Ísunopa'a kwenáái isánáe sésa tuwasá ");
INSERT INTO kze_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ámáán-kawaa-kwaasiye ámáámba sun-kwáásíyé tuwánésa tirunkó sáwí'a úwasa keáímbá sésa sáwí-kwaasiye toómbá kwénena aaí kwésimba sáwí'a kwéiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ísu mináímbá iséna kwántámai-aimba séna ");
INSERT INTO kze_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","sipisípira'a kárákwiyowai kwéon-aimba ísáaro. moóráwai sáwíva-sipisipi 100 sipisipira'a kárákwiraisana moórá-sipisipi áúyokwisasa misáwívá-sípísípí uvá'á máyáawana moóráma áúyokwimba koavakáá-émena awánéna ");
INSERT INTO kze_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","aamoí kwéena áúgwaata'maena ");
INSERT INTO kze_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","naaópa'a téna kwenamááraawe kwená naaópaken-kwaasiye tááyaisasa torupamái máyáawana séna kesí sipisípi áúyokwisa'a koavakáá-éme'a áí'mae'a túmpo aamoiyá ónáe sisasá aamoí uráawe. ");
INSERT INTO kze_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","simátime'a sé'a miráumai kwíyómpa'a máyáawai marapá'á tuwánaamba arupí umái máyáan-kwaasi kawe'á umái máyáamba tuwánésa aamoí kwéowasa sáwí'a umái máyáampinkemba sáwí-imayaa tuwésa Áánútunopa'a tíyasa Áánútuna kwayó'nárawa'a kwíyómpa'a máyáawai anón-aamoi kwéowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ísu séna moórá-aimba imáyáa oró. moórá-ininko siyáánkai-ontan-arumba makáisana moórá áúyokwisana oómbá kúra'makena kwená naaúmpa'a kankambá kwégwiyuvena kawe'á umái avakáá-éna ");
INSERT INTO kze_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","awánéna kwenamááraawe kwená naaópaken-kwaasiye tááyaisasa torupamái máyáawana simátimena séna kesí óntamba áúyokwisa'a avakáá-éme'a mayáúmpo aamoí íyataao sisasá aamoí uráawe. ");
INSERT INTO kze_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","simátime'a sé'a miráumai sáwí'a umái máyáampinkemba sáwí-imayaa tuwésa Áánútunopa'a tíyasa Áánútuna kwayó'nárawa'a kwíyómpa'a máyáawai anón-aamoi kwéowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ísu séna moórá-aimba imáyáa oró. moóráwai kaer-íyámpóí tínkaraiwai máyáísana ");
INSERT INTO kze_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","naaénkewai avowántávéna séna ená amápa-tantaa'a ímo pukéndara'a ívé'a taaímbai simiyó sisaná taaínkaar-umai ááninkai tímísana ");
INSERT INTO kze_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","naaénkewai sáwíyanka'a ména kwembó ámakain-daaindaamba kwétimena óntane su'mai maimaéna némpa'-marava'a koména sáwí'a úmaena kwéiyena kwená óntamba tu'mái ");
INSERT INTO kze_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ánásasuwaisana anón-ayawaima taisaná toóntávéna avakáá uwááena ");
INSERT INTO kze_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","mimbárávákén-kwáásígónópa'a kwéna mayáí mayánáe kosímae íyísana kesí maravá'á komé kesí póíra'a kárákwiyuwo sisaná ");
INSERT INTO kze_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","koména póíra'a kárákwirena ááesantavai úmae kwéiyena póíti toómpínkémbá nánáe séna sisasá íma áméwana ");
INSERT INTO kze_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ména naaémba kawer-ímáyáá éna séna kesivoná mayáí-kwáásí sáwíva-tomba nawááesa tímú'a vaisasá aráávara'a kwéomba pó'a maanká'á mé'a sáái sinkáína'a puwúnavaimpo'a ");
INSERT INTO kze_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","maanká'á tuwé'a kesivonópa'a kwé'a sé'a kesivoó Áánútu aúrankare enaúrankare sáwí'a únda pó'a ");
INSERT INTO kze_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","kentáváí kesáánine sénda uwóví'a ómpo kesí mayáí-kwáásíyé siyó kosénaumne séna ");
INSERT INTO kze_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","mivá'á tuwéna teémena aampa'á kwétisana némpakemba avowámá awánéna aruntavéna umánkena isaaiséna koyaparéna ivi'á kwétaisana ");
INSERT INTO kze_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ááninko séna kesivoó Áánútu aúrankare enaúrankare sáwí'a uráumpo kentáváí kesáánine sénda uwóví'a óne sisaná ");
INSERT INTO kze_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","avowámá mináímbá ivá kwéyuwena kwená mayáí-kwáásí tááyaisasa tewaná séna avekáámbá kawer-únánkwátói maimaé mágwéumanke'a kesáánimba intávé'a kwairambá kwéumanke'a aísamai ánáamba kwéumanke'a ");
INSERT INTO kze_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ánóígwara-purumakan-araa'a maimaé'a máyuvu'mai aamoi-tánómbá kauvíyata kwéneta aamoiyá umánkáano. ");
INSERT INTO kze_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kesááninko áúyokurai. pukurái. kwésunana úwoi ména timbá póta aamoiyá ónaumne sisasá aamoí uráawe. ");
INSERT INTO kze_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","aamoí owaná aivakéwáí kígauvakemba timbá naankóná egwaa'á téna aamoí on-áímbá taiséna ");
INSERT INTO kze_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","mayáí-kwáásígómbá ááyena séna nóinkara aamoí kwéoo sisaná ");
INSERT INTO kze_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","enává'a kawe'á umái tiráisana enavo séna ánóígwara-purumakan-araa'a tuvú'mái kaúvóro sisasá mirá kwéesa máyáawe sisaná ");
INSERT INTO kze_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","mináímbá ísáísana arunkó sáwí'a isaná kayoréna íma naaúmpa'a íyísana avowámá máápa'a kuména aivakéwai arumbá kusimái íyáísana ");
INSERT INTO kze_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","avowántávéna séna ayáátááka'a esé mé'a sáwívar-ima kwémaisuwe'a enáái íma ankaisé'a emó séndantemba mirá kwéuna anóm-poiye sáwíyam-poi méme-araare íma tuvú-simena'a kesí kwaásiye naráumne. ");
INSERT INTO kze_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","enááninko ená anón-ontamba maimaéna koména aarai tine'á minóntámbá máyu'mai ánásasuwena tisa ánóígwara-purumakan-araa'a tuvú'mái kwégaumai améne sisaná ");
INSERT INTO kze_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","avowámá séna ayáátááka'a kesé máyaanda kesí amápa-tantaa'a endéín-iye. ");
INSERT INTO kze_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","enáváko áúyokurai. pukurái. kwésunana úwoi ména tintávéta aamoiyá kwéumankaumne siráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ísu kwená kwayó-kwáásíyávéna séna moórá-aimba ísáaro. moóráwai náaindaankwara-kwaasigo mayáí-kwáásíyávéna séna kesí náaindaanka'a kárákwiyuwo sisaná mirá kwéisasa évakarawai tésa sésa ená náaindaanka'a íma kawe'á umái kárákwiraisana ená óntamba áúyokaiye sewaná ");
INSERT INTO kze_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","mindákó iséna kárákwiraiwaimba ááyaisana tisaná séna enáái sewa'á isáúnda po kesí náaindaanka'a íma kárákwiyiniyompo kesí náaindaanka'a kárákwiyonda-auvai agaimái símína'a ená mayáígóná ááimba awánaano sisaná ");
INSERT INTO kze_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","kwégwena imáyáa éna kesí anóndakomo si'mátuwaina'a nóra ónaumno. kemá íma asirayándá'á pó'a mara-máyáí íma kanaán-umai mayánaunda pó'a inaaimó siíyáváí sigaemá ínívo ");
INSERT INTO kze_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","mirá é'a aasósóí'a úmae kwénaaonana si'mátuwainasa naaémba meéyán-ónaumne sésamo úwoimo mairáan-kwaasiti naaúmpa'a sínkaresa toómbá siménááowe-imayaa umásuwena ");
INSERT INTO kze_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","kwená anóndakonopakembo naaémba meéyán-ónaumne sésamo úwoimo mairáan-kwaasi tááyaisana moóráwai tisaná séna kesí anóndakomba nóraumai-meyana amíníyono sisaná ");
INSERT INTO kze_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","séna sáwíva'-masawemba 1,000 masawemba ógwitamai aménaumne sisaná mindákó séna ená aúváívimba íma 1,000 iye se 500 iye simái agai-simiyó sisaná mirá isaná ");
INSERT INTO kze_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ó'a moóráwai tisaná séna kesí anóndakomba nóraumai-meyana amíníyono sisaná séna sáwíva-ton-unamba 1,000 unamba aménaumne sisaná mindákó séna ená aúváívimba íma 1,000 iye se 800 iye simái agayaaó sisaná ");
INSERT INTO kze_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","mináímbó simbá anóndakomba simáméwana iséna kwená náaindaanka'a sáwí'a umái kárákwiraiwaintavena séna kawer-ímáyáágwárá-kwáásí ontembá mirá óne siráiye. marapá-kwáásí kentí imáyáarakemba ásagwimai mirámó ondawáí kawe'á íníye simái kwémayaavo sámo kain-áyámpá'ó máyáan-kwaasi íma mirá kwéowe. miráumai anóndako kwená náaindaanka'a kárákwiraiwaintavena séna kawer-ímáyáágwárá-kwáásí ontembá mirá óne siráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ísu simásuwena mináíntávéna séna ísáaro. marapá'á kentí óntandei túwa'naa íyasa kentí kwaási-i'a íya'a kentí óntambo ánásaindara'a kwíyómpa'o ésa iyónááon-kanaa kwíyómpa'a minkwáásí tuwánésa aamoí umátinkanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","sáwíyan-tantaaka'a kawe'á umái kárákwiyowai anón-tantaaka'a kawe'á umái kárákwiyonaaowe. sáwíyan-tantaaka'a sáwí'a umái kárákwiyowai anón-tantaaka'a sáwí'a umái kárákwiyonaaowe. ");
INSERT INTO kze_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","marapá-tántááká'ó ímo kawe'ó umáímo kárákwiraiyawaimo éna Áánútu kwíyómpaken-tantaa'a íma tiména kárákwiyoro síníye. ");
INSERT INTO kze_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","marapá'ó Áánútumpaken-tantaaka'o ímo kawe'ó umáímo kárákwiraiyawaimo éna Áánútu kwíyómpaken-tantaa'a íma tiména kendéímán-iye síníye. ");
INSERT INTO kze_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","íma kanaán-umai kae-káwáá-kwáásítí mayáí kwémayaawe. mirámó ésamo ésa moóráwaimba aamoí ésa moóráwaimba íma aamoí umánkanaaowe. mirámó ésamo ésa moóráwaina mayáí kawe'á umái maésa moóráwaina mayáí sáwí'a umái mayánááowe. miráumai Áánútuna mayáímó maé'o é'a sáwívar-ontamba mayánaumne-imayaa íma úmae iyónááowe. sáwívar-ontamba mayánaumne-imayaamo é'o é'a Áánútuna mayáí íma mayánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ísu mináímbá súwasa ámáán-kawaa-kwaasi isésa óntantavai aamoí kwéesa pósa Ísuna awíráái suwaná ");
INSERT INTO kze_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ísu simátimena séna keinárawa'a kwaási túranka'a kawe'-máyáí kwémayaawasa tuwánésa sésa kawe-kwáásímán-owe kwésevo Áánútu kentí tááma kwétuwanaiye. amápa-tantaako áúmo mósá kwémaraan-tantaatavena Áánútu úwoisan-tantaa'an-iye kwésiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ísu simásuwena séna Mósesi Áánútuna ámáámba simátímakaimba Áánútun-aaimo simátímakaawaimo agaimakáamba naaóvá'á maémáen-kwaasiye minávúmpín-kwáásíyé naaén-kwaasiye Yónimo nombó pétinkaraiwaiye ména mináímbá taagwiyakáawe. ívé'a áséi-kwasai Áánútu kwená kwaási kawááin-aimba kwésimatimemba pósa kwaási Áánútu kawááipa'a tiyáántámba asirámaesa kwéusaveraawe. ");
INSERT INTO kze_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","maramá kwíyómba ánásanimbanivo Áánútuna ámáámba sáwíyan-aimba anón-aimba íma ánásena aasiyaasí kwaíkwai'a íníye. ");
INSERT INTO kze_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","moóráwaimo awainínkómbó ai'mátuwenamo ó'on-inimbo kwémayaimba umóyámbá kwémayaiye. moórá-kwaasigo ai'mátukain-inimbo kwémayaimba kwegwárá'á umóyámbá kwémayaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ísu séna moórá-aimba ísáaro. óísankwara-kwaasigo ména kawer-únánkwátói sáwíva'a makéna kawe-tómbá námae kwéiyisana ");
INSERT INTO kze_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","moóráwai áwí'a Árásárási íma óísamba makáiwai anón-karevu'a kwégaisana máyáísasa ayáí-tómbá amínana náníye sésa óísankwara-kwaasigona ontará'á móankaraawana máyáísana iyánkó téna minkárévú'á tauwá'naraiye. ");
INSERT INTO kze_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","naaémba ímo óísambo makáin-kwaasigo púwísasa Áánútuna kwayó'nárawa'a kwíyómpakendarawa'a kunáí'maesa Ááváramumo kawe'-mápá'ó máyáipa'a móankaraawana óísankwara-kwaasigo púwísasa utámakaawana ");
INSERT INTO kze_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","sáwí-marupa'o iramó kwégaipa'a anón-ai'a kwéisana ména mósá awánaimba némpa'a Ááváramuwe Árásárásiye máyaayana tuwánéna ");
INSERT INTO kze_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","aayamáívinkemba séna kesivoó Ááváramuwo sáwí-marupa'o iramó kwégaipa'a anó-si'a kwéisa'a máyaumpo arumbó umásinke Árásárásimba ai'márénana kunkéna ayáánánáma nompí tu'mái simáávíra'a maráínana tasíyasi íno sisaná ");
INSERT INTO kze_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ááváramu séna kesááninko marapá'á máyaandara'a amápa-kawe-tantaa'a makáampo Árásárási sáwí'a umái méraivo mindáyavai imáyáa uwó. ívé'a kwemá kawe'á umái máyaivo embá áí'a ipá'á máyaane. ");
INSERT INTO kze_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","senda-áínkwárá'á imáyáa uwó. avumpimbá kuvakamá anómba kwáyáivo maankákémbá íma kunámaatewasa mivákémbá íma usámaaisewasa ónááovo anón-kuvaka kwáyáiye sisaná ");
INSERT INTO kze_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","óísankwara-kwaasigo séna kesivoó Ááváramuwo emó sénda-aintave'a simáme'a sé'a Árásárásimba ai'márénana kesivoná naaópa'a ");
INSERT INTO kze_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","éva'aasei kesívárawaisai méraavo kusimátimena sáwí-marupa'o iramó kaipá'á tevó simátimino sisaná ");
INSERT INTO kze_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ááváramu séna Mósesi siráin-aine Áánútun-aai simátímakaawai siráan-aine aúváívimba agaimakáamba pósa táápamai isánááowe sisaná ");
INSERT INTO kze_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","kesivoó Ááváramuwo ímanivo moóráwai pukáimpinkemba usásinena kusimátiminasa sáwí-imayaa tuwésa Áánútumpa'a kónááowe sisaná ");
INSERT INTO kze_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ááváramu séna Mósesi siráin-aine Áánútun-aai simátímakaawai siráan-aine ímo isésamo ésa pukáimpinkemba usásinkaiwain-aai íma isánááowe Ááváramu siráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ísu kwená kwayó-kwáásíyávéna séna ó'on-o'on-tantaa'a kwaásitopa'a tínasa kesáái tuwánááowe. évakarawai tésa kesáái kwéisaawaima kampar-áímbá tasimátimiyasa kesáái tuwésa kówíyasa kampa'ó síyawainopa'a sáwí-meyamba tíníye. ");
INSERT INTO kze_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","miwímó tinumarampimbó anón-ontambo aríkwímaresamo nompímbó túwááwasamo kumésamo kumpuwésarakai kampar-áímbá íma simátíméwasa kesááimo ísaraan-iyampoi kesáái íma tuwésa sáwí'a osinó. ");
INSERT INTO kze_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","mindáyave'a kentúra'a kárákwiyoro. kentí kwaásimo kembó sáwí'o umátinkaiya'o é'a keinárawapa'a mindáyave'a simátimiyasa sáwí'a únemo síya'o é'a íma moórágwara'a imáyáa é'a ivá'á túwáaro. ");
INSERT INTO kze_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","kentí kwaásigomo kembó sáwí'o umántínkáva'o kwéiyesamo kentópa'o tésamo sáwí'a únemo símae kwéiyiya'o é'a íma moórágwara'a imáyáa é'a ivá'á túwáaro. mimbórá-táwaimo avakaetéra'o mirámó íya'o é'a íma imáyáa é'a ivá'á túwáaro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","suwasá Ísóigona aantá-kwaasi kwentávésa sésa esé aráápamaiya máyaundaya súwa'naa inatá esé aráápamaiya máyaundaya asiramáíya máéno suwaná ");
INSERT INTO kze_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ísóigo séna moórá-taigo áwí'a másátati sáwíyan-aramba to'makáawana áruma kwikéna anón-tainamba kwéiyintemba kesé kítoka'a aráápamai máyáamba pó'a naaémba anónka'a kesé aráápamai mé'a anón-taiyave'o sé'o taawí'mae anón-dompimba kunkaruwuwómó síyanamo éna mirá íníye. Ísu mináímbá siráimba kwesé aráápamai máyáamba kwená mayáí mayánááontavena siraíye. ");
INSERT INTO kze_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ísu kwená kwayó-kwáásíyávéna séna mayáí-kwáásígómbá ai'márááwana mayáímá kwémaena kígauvakena'i. póíra'a kárákwiraindavakena'i. timbá ená toómbá emá agaimái naaó íma sésa ");
INSERT INTO kze_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","kavegavé umái kawer-únánkwátói uré toómbá agai-símí'a nasúwáana naaémba ená toómbá agaimái náníyone mirán-áímbá kwésewe. ");
INSERT INTO kze_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","sintembá mayáí-kwáásí mirá kwéesa úwoi miwítí mayáí isasá mirá kwéomba pósa íma túwí'a mósá kwémaraawe. ");
INSERT INTO kze_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","miráumai keinárawa'a mirá kwée'a simátíméndantemba umái mé'a ánásanaaoka'a sé'a úwoi kwená mayáí-kwáásíyá úndaya póta úwoi kentáásí mayáíyá mairáumne sé'a íma kentúma maimaé'a íyóro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ísu Yérúsaremu-naor-ampa'a kúmba Sámériyaa-marawe Káríri-marawe avumpin-ámpá'á kwéena ");
INSERT INTO kze_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","moórá-naopa'a kwéguwasa túma karón-kwaasi siyáánkai-kwaasi kwétesa némpa'o Ísumo túmba awánésa ");
INSERT INTO kze_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aayamái sésa anóndako Ísuwo kentáá arumbá umásinkaao suwaná ");
INSERT INTO kze_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ísu tuwánéna séna mono'-máyáí-kwáásítópa'a kwé'a kentúma máagaraatinkewasa tuwánésa túma kawáúgwiye sénááowe súwasa aampa'á kumbá túma kawe'á umátinkowana ");
INSERT INTO kze_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","miwívínkémbá moóráwai áúma kawe'á umánkomba awánéna koyauweréna anónka'a tasiréna Áánútu áwí'a mósá maréna ");
INSERT INTO kze_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ísu anóndakoman-iye séna aísamaivimba takívairena súwi séna minkwáásí íma Yútaa-kwaasi Sámériyaa-maravaken-kwaasigo súwi súwana ");
INSERT INTO kze_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ísu séna siyáánkai-kwaasi túma kawe'á umátinkaunda avaréíyain-kwaasi íma koyauwérááwana ");
INSERT INTO kze_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","kímborawai ó'om-baravaken-kwaasigo koyauweréna Áánútu áwí'a mósá kwémaraiye simásuwena ");
INSERT INTO kze_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","minkwáásígóntávéna séna kentáváí súwa'naa íníwaiman-iye sénda póna enáúma kawe'án-ivo kwaaó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","súwasa ámáán-kawaa-kwaasi Ísumba áísaa esa sésa Áánútu kwená kwaási kwégawaain-kanaama nósa-tawaiya tíníyo suwaná Ísu séna Áánútu kwená kwaási kwégawaaimba íma kanaán-umai túrandei awánanaaovo ");
INSERT INTO kze_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Áánútu kwená kwaási kwégawaaimba kwaási túra'a ááimba ásáraimba pósa maanká'á ópa'a kárákwiraiye íma kanaán-umai sénááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ísu simásuwena kwená kwayó-kwáásíyávéna séna naaémba kemá kwaási úrandako kúmónda-kanaa awánanae síyambanivo íma mirán-kánáámá suwánanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","évakarawai sésa maavá'á máyáivo tawánaaromo síyasa ó'owima sésa maavá'á máyáivo tawánaaromo síya'o íma áraire sé'a kóyáwé oró. ");
INSERT INTO kze_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","kwíyómpa'o tawáombo úmae kwisasamó awánaantemba kemá kwaási úrandako miráumai avora'á ókwara'a kumónaumne. ");
INSERT INTO kze_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","misúnda-aimba íma paárurainasa aiva'á ívé'o máyáan-kwaasi tínaaemba umásinkesa sí'a índai'a umásinkanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","naaóvá'á moóráwai áwí'a Nówaa máyonka'a kwaási íma Áánútuna imáyáa ésa maémáentemba naaémba kemá kwaási úrandako kúmónda mirá ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nówaa máyonka'a nombá toómbá kwénesa tiyáámúmbaa'a kwétokwaa-esa aaraí máyówasa kwaaí máyówasa kwéuwana Nówaa naaúmpa'a non-avóvomayaa'o kún-daumpa'a umáyowana anón-a'a téna kavirayán-dónkó amápa-kwaasi tínkamuwasa putásaraawe. ");
INSERT INTO kze_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","naaóvá'á moóráwai áwí'a Áróti máyonka'a íma Áánútuna imáyáa kwéesa mésa nombá toómbá kwénesa kwémeya úmae kwénaaesa kígauma naambá úmae naaémáémba ");
INSERT INTO kze_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Áróti Sótómu-naopa'a tiyuwónka'a Áánútu óntankwara iraronkwárá'á kwíyómpakemba tuwówana kuména tínkamuwasa putásaraawe. ");
INSERT INTO kze_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Áróti máyonka'a kwaási íma Áánútuna imáyáa ésa maémáyáantemba kemá kwaási úrandako ókwara'a kumpaárondara'a mirá ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ókwara'a kúmóndara'a ontará'ó máyaiyan-kwaasi naaúmpakemba náaindaamba íma ó'a umayánááowe. kígauva'o máyaiyan-kwaasi náaindaamba naaúmpa'o kwáyainda ó'a íma umayánááowe. ");
INSERT INTO kze_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Áróti awainínkón-áái imáyáa oró. kwená náaindaamba tuwón-imayaa éna mógwantowana óntankwara iraronkwárá'á kuména tuvuwúwana pukáiye. ");
INSERT INTO kze_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","tirááímo táíndai'o ésa íma kawe'á umái ménaaovo kentávésa imáyáa ésa tirááímo táínda-yantaa'a tuwésa puwésa aúnái'a umái kwíyómpa'a maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","simátime'a sé'a ókwara'a kúmóndara'a mindó'wáámbá kae-kwáásí mimbórává'á tuúmá kwéreyana Áánútu moóráwaimba auwéna moóráwaimba airáníye. ");
INSERT INTO kze_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","minkánáá kaer-ínínkáí toómbá kwégwanteyana Áánútu moórá-inimba auwéna moórá-inimba airáníye.  ");
INSERT INTO kze_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","kaekóráí kígauva'a méyana Áánútu moóráwaimba auwéna moóráwaimba airáníye Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","kwená kwayó-kwáásí sésa Ísóigoo emó sénda-aimba náávatavai seénó suwaná póímo awáímó kaviraipá'ó náíndayavenamo evontáán-dúmáómó torupamáímo máyáintenba Áánútu sínana súnda-aimba paáriniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ísu séna aasiyaasí Áánútumpa'a námúnaa kwésesa túwáavo séna kwántámai-aimba simátimena séna ");
INSERT INTO kze_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","moórá-naopa'a aaimó isáí-kwáásígó ména íma Áánútu áároi inkaiséna íma kwaásiti imáyáa éna máyáísana ");
INSERT INTO kze_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","mindáópa'a ketor-ínínkó ména aasiyaasí aaimó isáí-kwáásígónópa'a tóyo éna séna sáwí'a umásinkanaesa kwéovo aaí súwa'naa umásinkaao sisaná ");
INSERT INTO kze_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ayáátááka'a kwenáái íma ísarena naaémba imáyáa éna séna Áánútu áá'a íma inkaisé'a kwaásiti imáyáa íma é'a kwéunda pó'a ");
INSERT INTO kze_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","minínínkó kesópa'o timbá suwesaráánivaimpo'a áwa'naa ónaumne siráiye. ");
INSERT INTO kze_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ísóigo simásuwena séna aaimó isáí-sáwí-kwáásígón-áái imáyáa oró. ");
INSERT INTO kze_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Áánútuna kwaási kwempá'ó námúnaamo símae kwéiyomba túwáavo séna íma ayáátááka'a úwoi maéna miwí táái iséna ");
INSERT INTO kze_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","sáwí'o umátínkénka'a ááéma túwa'naa íníye. naaémba kemá kwaási úrandako ókwara'a kúmóndara'a máyaiyan-kwaasivinkemba kesááiyavesamo áraire sésamo kesémo aráápai-i'a ónááo. íya ónááoo tuwánanaumne Ísu séna Áánútumpa'o námúnaamo símae kwéiyomba túwáavo séna mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","évakarawai kawe-kwáásí úne sésa kentúma maé iyésa ó'on-kwaasi túma simái sáwí'a umátínkén-kwaasiyavena kwántámai-aimba Ísu simátimena séna ");
INSERT INTO kze_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","kae-kwáásígórai moóráwai ámáán-kawaa-kwaasigon-ivo moóráwai táákísi-ontamba máyáin-kwaasigo isasaráí anóm-bono'-naumpa'a námúnaa séyáe sésarai iyóyamba ");
INSERT INTO kze_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ámáán-kawaa-kwaasigo koku'á ména kwenáúma maé iyéna séna Áánútuwo kemá évakarawai ontembá íma kwéumpo entávé'a súwi kwésune. umóyámbó maésamo kampa'ó kwésesamo aarai-úmóyámbá maésamo ombá kemá íma mirá kwéune. maa máyáiwai táákísi máyáin-umoyan-kwaasi intembá kemá íma mirá kwéune. ");
INSERT INTO kze_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","aasiyaasi-sóntáárá'á kae-kae-táwai monotávé'a imáyáa é'a íma toómbá kwénaumne. aasiyaasi-kígáúgóná sontaará'á mayáúnda-yantaa'a taaínke'a kemá avaréíyaimba maé'a moóráma embá áma'mae'a kwéiyune sisaná ");
INSERT INTO kze_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","táákísi máyáin-kwaasigo moóráva'a koku'á ména aigaemá éna kívairena séna Áánútuwo kempímbá sáwí-imayaa kwáyáivo arumbá umásinkaao siráiye. ");
INSERT INTO kze_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ísu mináímbá simátimena séna ísáaro. Áánútu táákísi máyáiwaina sáwí-imayaa mayáúwáísana Áánútuwe tágárotamai maéna kwená naaópa'a kwisaná ámáán-kawaa-kwaasigo kwempímbá sáwí-imayaa úwoi kwáyáísana kwená naaópa'a kuráiye. anón-kwaasi úne síyawaima Áánútu túwí'a móruna tuwánívo Áánútu aísamaivimba máyáawaima Áánútu túwí'a maimaé iyíníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","simátimuwasa évakarawai Ísu tátorena kawe'á umátinkainkwae sésa iyámpói tí'maesa tuwasá kwená kwayó-kwáásí tuwánésa kóro suwaná ");
INSERT INTO kze_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ísu miníyámpóíyávéna tááyena séna teró. íma kóro sé'a tiyuwáíyasa kesópa'a iyámpói úwoi teró. miníyámpóí kesópa'a tentembá Áánútu kwená kwaási kawááimba miráráán-umai kwégawaaimba iyámpói kesópa'a tí-amba íma ítátinkaaro. ");
INSERT INTO kze_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","árai'a simátime'a sé'a Áánútuntavesamo sésamo iyámpóíraan-umai kenká'á kwégawaa-onemo síyanamo éna miwírá'á kawááinivo ímo mirámó síyawaimo éna íma kawááiniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","súwana moóráwai Yútaa-kwaasiti anóndako Ísunopa'a téna séna anóndakoo kawe'ná'á óne. nóra umáíya aúnái'a umái kwíyómpa'a maí'mai'a ónaumno súwana ");
INSERT INTO kze_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ísu séna kentáváí nóra séwa kawe'ná'á óne kwéseno. mimbóráwáí Áánútu kweyáá kawe'ná'án-iye. ");
INSERT INTO kze_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Áánútuna ámáámba á'a ísaraane. minámáámbá aúváívimba agaimaréna séna íma aarai-úmóyámbá oró. kwaási tínkamiyasamo puwónááoni'a íma oró. íma umóyámbá máyáaro. íma kampar-áímbá simátinkaaro. kentinóvowi túwí'a anómba oró siráiye súwana ");
INSERT INTO kze_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","mindákó séna minámáámbá kesí iyámpóírakemba ísare'a pó'a kawe'á úmae kwéiyune súwana ");
INSERT INTO kze_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ísu iséna séna kawe'á éma moórá-yantaa'a íma kawe'á uráampo ená náaindaamba ó'on-kwaasi kwétime óntamba mairé ímo makéwai tímatuwenana ená kawe'-méyámbá Áánútu kwíyómpa'a ankáníye. tímatuwemo e kesínaaemba kwaráníyone súwana ");
INSERT INTO kze_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","mináímbá iséna sáwíva'-naaindaamba makóntavena anón-imayaa úwana arunkó sáwí'a uráiye. ");
INSERT INTO kze_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","arunkó sáwí'a kwéuwana Ísu awánéna séna sáwívar-oisambo makén-kwaasi Áánútumo kwená kwaási kawááipa'o kwíyamba umbaí táníye. ");
INSERT INTO kze_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","moórá-poigo áwí'a káámeri mimpóígó kwaigóná avaapimbá íma kanaán-umai kóveraniye. káámeri-poigomo kwaigóná avaapimbó kóverainkakai sáwívar-oisamba makén-kwaasi Áánútu kawááipa'a kosinó súwasa ");
INSERT INTO kze_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","mináímbá isésa áísaa esa sésa umbaí taintáváí nóran-kwaasiya Áánútu kawááipa'a ménaaoo suwaná ");
INSERT INTO kze_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ísu séna kwaási miwítí mayáínéí íma meéyámbaresa kónááovo Áánútu úwoi kanaán-umai mégwétinkaiye súwana ");
INSERT INTO kze_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pítaa séna isaaó. kentáásí naaópa'a tuwéta enánaaemba kwégwaraumne súwana ");
INSERT INTO kze_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ísu séna árai'a simátime'a sé'a Áánútu kwená kwaási kwégawaaintavesa imáyáa ombá naambáru'a tuwésa tuwaínímbáá'a tiyuwésa tuwaaísái tiyuwésa tinóvowi tiyuwésa táánimbaa'a tiyuwésa tiyáámúmbaa'a tiyuwésa miráumaimo túwáawaina anondáma ");
INSERT INTO kze_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","marapá'ó máyáanka'a túwáán-tantaa'a mirán-tántáá'á sáwíva'a mémaesa naaén-kanaa aúnái'a umái kwíyómpa'a maí'mai'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ísu kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasi tí'maena moórá-ayampa'a tínkarena simátimena séna maísáaro. Yérúsaremu-naopa'a konanayá naaóvá'ó Áánútun-aaimo simátímakowaimo kwaási úrandakon-aai agaimakáan-aimba paáriniye. ");
INSERT INTO kze_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","kembá sí'mai ó'onkaa-kwaasi timíyasa kanaáráá'a kwésinkesa simái sáwí'a umásinkesa tuwirááíma kwisinkésa ");
INSERT INTO kze_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","súwíruku'a nésa sínkamiya'a púwónasa utamásinkaiya'a kaumbo-táwai maisuwé'a usásinanaumne Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","kwená kwayó-kwáásí nóin-aintavena siíyó sésa mináínkóná ááimbo aúpá'ó kwáyontavesa íma ísámai kawer-ésa Yérúsaremu-naor-ampa'a kuráawe. ");
INSERT INTO kze_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ísu aampa'á kúmba Yéríko-naor-egwaa'a kúwana moóráwai aúramba kavíkówai óntamba inaai simái mayánáe séna aanéiva'a kumbéna kwéinaai séna ");
INSERT INTO kze_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","sáwíva-kwaasimo tésamo kínkimbo sumbá iséna nááwiya'o súwasa ");
INSERT INTO kze_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ísu Násáretivakewai kwétiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","anónka'a séna Ísuwo Tévítin-andarakewai ómpo arumbá umásinkaao súwasa ");
INSERT INTO kze_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","aiva'á tun-kwáásí áwáá'a aéésa sésa aaiseraaó suwaná mináímbá ivá kwétuwena ó'omba anónka'a séna Ísuwo Tévítin-andarakewai ómpo arumbá umásinkaao súwana ");
INSERT INTO kze_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ísu aampa'ó kweémáyomba kwená egwaa'á kousásinena séna áí'mae teró súwasa áí'maesa egwaa'á tuwaná Ísu áísaa ena séna ");
INSERT INTO kze_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","nóin-tantaara embó arááímo táínda-yantaa'a umánkanaumno súwana anóndakoo súramba kawe'á umásinkaao súwana ");
INSERT INTO kze_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ísu séna kentáváí kanaán-umai súwa'naa íníwaiman-iye sénda póna aúramba kawe'á íno súwana ");
INSERT INTO kze_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","avekáámbá aúramba kawe'á umái awánéna Ísun-ánaaemba kwa'mái kwégwena Áánútu áwí'a mósá marówasa sáwíva-kwaasi awánésa Áánútu áwí'a mósá makáawe. ");
INSERT INTO kze_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Áánútu áwí'a mósá márówana Ísu Yéríko-naopa'a kóyaaitanae séna kúmba ");
INSERT INTO kze_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","moóráwai áwí'a Sákíyasi táákísi-ontamba máyón-kwaasiti anón-kwaasigo póna sáwívar-ontamba makéna ");
INSERT INTO kze_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ísumba awánanae séna úmba sáwíva-kwaasi úyatukowana ákí-kwaasigo póna íma kanaán-umai awánéna ");
INSERT INTO kze_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","maanámpá'á tíníyone séna minkwáásí tínaaempakemba aiva'á úya'mai moórá-taiva'a usáatena máyowana ");
INSERT INTO kze_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ísu mintáígó ááimpa'a kwéna mósá awánéna séna Sákíyasiyo ená naaúmpa'a kónaumpo avekáámbá marapá'á kumuwó súwana ");
INSERT INTO kze_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","aamoí umásuwena avekáámbá marapá'á móruna tuwéna kunáí'maena kwená naaúmpa'a kúwasa ");
INSERT INTO kze_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","minkwáásíyómbá awánésa tirunkó sáwí'a úwasa sésa sáwí'a in-kwáásígóná naaúmpa'a kwégwiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sákíyasi kwená naaúmpa'a mósá ankena Ísóigontavena séna anóndakoo kesí óísamba avumpimbá taaínkaakai uré'a évaka'a ímo makáan-kwaasi timé'a évakarawai kampa'á simátiyuwe'a óntamba umóyámbá mairáunda pó'a éíyain-eiyain-umai tíma'mae'a kónaumne súwana ");
INSERT INTO kze_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ísu séna ívé'a maandáúmpá'ó máyáan-kwaasi kawer-ámpá'á métinkaumne. Ááváramu aísaavutantambo uráandayave'a mirá kwéune. ");
INSERT INTO kze_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","kemá kwaási úrandako kumpaáruraundawai enkáán-kwáásí tivakáá-umai sáwí'o umáímo máyáampinkemba kawer-ámpá'á métínkaandayave'a kunkáumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","mináímbá ísówana Ísu Yérúsaremu-naor-egwaa'a kúwasa kwesé kun-kwáásí imáyáa ésa sésa Áánútu kwená kwaásimo kwégawaaimba sáwíyanka'a paáriniye suntavéna kwántámai-aimba simátimena ");
INSERT INTO kze_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","séna moórá anóndakon-aai ísáaro. kámááni-kwaasi némpa'-marava'a máyáawana kotísaa onasamó kanaán-iye síya'o é'a kesí kwaásira'a takárákwiyonae séna ");
INSERT INTO kze_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","kwená mayáí-kwáásí siyáánkai-kwaasi tááyaisasa tewaná óntamba kae-támayo-tamayo'a tiména séna koméraana'a minóntánkákémbá mayáí kwémayewa'a té'a évakar-ontankwara'a tamáyáano séna kówisasa ");
INSERT INTO kze_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","kwenamááraawi tíyántavesa umánkesa kámááni-kwaasi kosimátime'a sé'a kentáárá'á íma takárákwiyiniye kosimátíméro sewasá kuráawe. ");
INSERT INTO kze_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ánivo minánóndákómbá kárákwiyi-mayai áméwana koyauweréna téna ááéma óntamba tímakain-kwaasi tááyaisasa tewaná séna tímakaunda-ontankakemba nóraumai-ontana mairáao sisaná ");
INSERT INTO kze_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","aiva'á ámakaiwai téna séna anóndakoo símakaanda-ontankakemba mayáí kwémae'a moórá-unan-ontamba mairáumne sisaná ");
INSERT INTO kze_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","anóndako séna kesí mayáí-kwáásígó kawe'á óne. sáwíyan-tantaaka'a kawe'á umái kárákwiraanda po siyáánkai-nao-kwaasira'a kárákwiyuwo sisaná ");
INSERT INTO kze_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","moórá-mayai-kwaasigo téna séna anóndakoo símakaanda-ontankakemba mayáí kwémae'a siyáánkai-tamayor-ontamba mairáumne sisaná ");
INSERT INTO kze_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ánivo éva'aasei-nao-kwaasira'a kárákwiyuwo sisaná ");
INSERT INTO kze_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","moórá-mayai-kwaasigo téna séna anóndakoo símakaanda-ontamba ampantavímbá mú'úmai aúpá'á makáunda po mayáníyone. ");
INSERT INTO kze_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","emá asirayán-kwáásí éma ímo makáanda-yantaa'a kwémae úwoi kwénaae ó'owiti kígauvaken-tomba kwénaana'a pó'a enáároi inkaisé'a úwoi aúpá'á makáunda po mayáníyone sisaná ");
INSERT INTO kze_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","anóndako séna sáwí-mayai-kwaasigo ónda pó'a kentáváímó séndantemba aaí simánkanaumne. kentáváí se asirayán-kwáásí éma ímo makáanda-yantaa'a kwémae úwoi kwénaae ó'owiti kígauvaken-tomba kwénaane sénda po ");
INSERT INTO kze_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kesí óntambo amápa-kwaasiti óntambo máráan-daumpa'o makáandarakai tiré'a kesí óntankwara aa'wáá-ontankwara'a mayáúsino séna ");
INSERT INTO kze_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","máyáan-kwaasiyavena séna maanóntámbá mairé'a kae-támayor-ontamba tokáiwaimba áméro sisasá ");
INSERT INTO kze_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","miwí sésa ímanivo kae-támayor-ontamba á'a tokáiye sewaná ");
INSERT INTO kze_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","simátime'a sé'a sáwíva-tantaaka'o kawe'ó umáímo kárákwisinkaawaima moórá-mora-yantaa'a tíménasa kárákwisinkanaaovo ímo kawe'ó umáímo kárákwisinkaawaivakemba makáan-tantaa'a máyáana'a ");
INSERT INTO kze_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","kesí namuro-kwáásí kentáárá'á íma kárákwiyiniyone siráawai tí'mae'a kesópa'a tiré'a tínkamiyasa púwóro siráiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ísu mináímbá simásuwena aiva'á Yérúsaremu-naor-ampa'a kúmba ");
INSERT INTO kze_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Óríve-omakar-egwaa'-naokai moórá Pétévasi-nao'a úwana moórá Pétáni-nao'a úwana minkáé'-náór-egwaa'a kwéna kwená kwayó-kwáásíráí kae'á máti'marena séna ");
INSERT INTO kze_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","epín-dáópa'a kurékai moórá-poigo áwí'a tónki koawáneyambo kwaásimo ímo ayáákainda-poi ándáma iyátuwekai áí'maekai tekaiyó. ");
INSERT INTO kze_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","moóránakomo tuwánénamo nóra óyáekai óyómo sínakai anóndako ayáá'mae'a kónáe siyé simámékaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","kuyaná súntemba mimpóí máyowasarai koawánésarai ");
INSERT INTO kze_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ándáma koiyátúwóyana mimpóígó avowámá awánéna séna nóra sékai mimpóígóná ándáma kwéiyatuwaaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","mindárai sésarai anóndako ayáá'maena kwínkwáe simásuwesarai ");
INSERT INTO kze_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","áí'maesarai Ísunopa'a tuyasá kwená kwayó-kwáásí paákár-únánkwátói ayú'mái mimpóígó arósáánumpimba kwandaaí uwí'márówana Ísu ayáá'maena kwéguwasa ");
INSERT INTO kze_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","sáwíva-kwaasi mésa anón-kwaasiye sésa paákár-únánkwátói ayú'mái aampa'á uwí'ma'mae kwéguwana minúnánkwátóira'a augwétámai kwégwena ");
INSERT INTO kze_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Óríve-omapinken-ampa'a kumúmba Yérúsaremu-naor-egwaa'a kúwasa Ísun-ánaaemba sáwíva-kwaasi kwa'maé kwégwesa aamoí ésa ó'on-o'om-bayai kawe'-máyáí mayómba awárontavesa Áánútu áwí'a mósá marésa anónkar-anonka'a sésa ");
INSERT INTO kze_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ísóigo ai'máráísana kunkáiwaimba Áánútu minkáwááná'á kawe'á kwéumankaiye. Áánútu kentááyavena séna paru umái máéro kwésimba póna kwenáwí'a anómba kwéiye anónka'a suwasá ");
INSERT INTO kze_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","misáwívá-kwáásívínkémbá évaka'a ámáán-kawaa-kwaasi sésa anóndakoo enánaaemba kwa'maé kwénaaon-kwaasiyavai se aaiseré nááóro siyó suwaná ");
INSERT INTO kze_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ísu séna simátime'a sé'a ímo aaimó senkákáí maanóntánkó kentáváíyé séna aaí sisinó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ísu Yérúsaremu-naor-egwaa'a kwéna awánéna kwaásiti ivi'á téna séna ");
INSERT INTO kze_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","paru umái kwémaewaina ááimba íma ísámai kawer-uráawe. ísarekaankasi paru umái máésino. ívé'a íma kanaán-umai kwéisaawe. ");
INSERT INTO kze_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","kentí namuro-kwáásí tésa kentí naaópa'a taúkúmakesa maramá u'mái ontavímbá karí'á tásuwesa ");
INSERT INTO kze_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","kentí aarai-iyámpóígwara'a kwétinkamesa kentí naambá tawísíyuwanaaowe. Áánútu kawer-ámpá'á métinkanae séna tisa'á tínaaemba umánkáamba pósa kentí namuro-kwáásí tésa mirá ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ísu mináímbá simásuwena Yérúsaremu-naopa'a anóm-bono'-naumpa'a iyéna mono'-náúmpá'ó meéyámbó kwémayon-kwaasi uti'mátuwena ");
INSERT INTO kze_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","simátimena séna Áánútun-aai aúváí-kwandaaivimba agaimaréna séna mindá kesí naambá Áánútumpa'o námúnaamo sen-dámbán-iye agaimaréna siráiye. ánivo umóyán-dáúmpá'ó ontenkáámbá uráawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","aasiyaasí anóm-bono'-naumpa'a Ísu simátíma'maena íyúwasa mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé anón-kwaasiye Ísuna ámááyu-aimba kwésuwasa ");
INSERT INTO kze_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","úwoi-kwaasi sáwíva'a Ísun-aai ísámae kwéiyuwasa tuvuwónááon-amba íma kanaán-umai avakáá uráawe. ");
INSERT INTO kze_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","moórá-tawai Ísu anóm-bono'-naumpa'a uména Áánútuna áséi-kwasai kwésimatimuwasa mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé Yútaa-anon-kwaasiye tésa ");
INSERT INTO kze_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","sésa nááwa ai'mákaisa tiréwa nááwampinkena mairéwa égési-mayai kwémayaanda simásimiyo suwaná ");
INSERT INTO kze_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ísu séna aiva'á moórá-aimba tísaa ona'á simásíméro. ");
INSERT INTO kze_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ááéma Yóni nombá pétinkaraiwaima Áánútuwa simámakaisana nombá pétinkarai. kwaásiya simámakaawana nombá pétinkaraiyo súwasa ");
INSERT INTO kze_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","miwímá keáímbá sésa nórayaawa sénaumno. Áánútu simámakaisana nombá pétinkaraiyemo senanayáámó éna nóra séra Yónin-aaiyave'a íma áraire siráao síníye. ");
INSERT INTO kze_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","kwaási simámakaawana nombá pétinkaraiyemo senasayáámó ésa úwoi-kwaasi sínkamonaaowe. úwoi-kwaasi sáwíva-kwaasi Yónintavesa sésa Áánútun-aai simásímakaiwai uráiye kwésemba pósa óntantamba mairésa sínkamonaaowe. ");
INSERT INTO kze_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ísuntavesa sésa emó sísaa ónda-ainta íma ísaraumne suwaná ");
INSERT INTO kze_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ísu séna ímo simásimiya'a nááwampinkena mairéra'i. égési-mayai kwémayaunda-aimba íma simátimenaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ísu kwántámai-aimba simátimena séna moóráwai ándá-aran-kigau úmarena ayáátááka'a ó'om-barava'a koménae séna maankígáúrá'ó taviyíyawaimo é'a kesáváí évakar-aramba maé'a évaka'a kembá siyúwáaro simátimena ó'om-bapa'a komáyáísana ");
INSERT INTO kze_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","arambó ávumo kain-kánáá tisaná aanávómá kesí ándá-aramba komayaaó séna kwená kwayó'ná'á ai'máráísana minkígáúrá'ó tavíyéwaitopa'a tisasá táto'mai tuvú'maresa ándá-aramba íma ámémba ai'mátuwaawana kówisana ");
INSERT INTO kze_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","aanávómá moóráwaimba ai'máráísana tisasá minkígáúrá'ó tavíyéwai táto'mai tuvú'maresa sáwí'a umánkesa ándá-aramba íma ámémba ai'mátuwaawana kówisana ");
INSERT INTO kze_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","aanávómá moóráwaimba ai'máráísana tisasá táto'mai tuvú'márááwana naaemá kúmísasa awéntayuwaawana kówisana ");
INSERT INTO kze_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","aanávómá séna nóra ónaumno. kesááninko imáyáa ámakaundawaimba ai'máráanana kwínasa kwenáái isánááowe séna ai'máráísana tisasá ");
INSERT INTO kze_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","minkígáúrá'ó tavíyéwai awánésa keáímbá sésa aanávómbá ááninko kwétimba póta tuvúwónana puwéna maankígáú íma mayáínata kesáá mayánáe sésa ");
INSERT INTO kze_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","táto'mai ándá-aran-kigauvakemba awéntáyuwesa tuvúwówana pukáiye. Ísu mináímbá simásuwena séna minkígáúgó aanávómá mirá íníye. ");
INSERT INTO kze_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","téna kígaura'o tavíyéwaima tínkaminasa puwíyana ó'onkaa-kwaasi kesí kígaura'a tavíyéro síníye Ísu súwasa mináímbá isésa sésa íma mirá oró suwaná ");
INSERT INTO kze_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ísu árimba tuwánéna tísaa umai isánáe séna imáyáa oró séna Áánútun-aai aúváí-kwandaaivimba maarán-áímbá agaimaréna séna eróntan-damba on-kwáásí moórá-ontantavesa sáwí'a kwéiye sésa maisukáawe. aáno minóntánkó ávonkaamba uráiye agaimaréna siráimba mináíntávé'a imáyáa oró. ");
INSERT INTO kze_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","kwíyamba minóntánká'á tanaambá kovésa sáwí'a umái ménaaovo minóntánkó tuvú'mái sáwí'a umásuwaniye Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé simbá kentááyávéna siyé sésa táto'mai tuvuwónáe sésa umbá amápa-kwaasiyavena táá'a kówasa ivátukaawe. ");
INSERT INTO kze_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ivátuwesa tátoranaaon-kanaa kárákwiyesa évakarawai ti'marésa sésa Ísun-aai kwéisaan-kwaasimo ontembá té'a áísaa íyana sáwí-aimbo sínata táto'mai kámááni-kawaanakonopa'a móankanaumne sésa ti'márówasa Ísunopa'a tésa ");
INSERT INTO kze_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","sésa anóndakoo árair-aimba kwése kwaási táároi íma inkaisé anón-kwaasiye úwoi-kwaasiye táároi íma inkaisé tirumbá airá'mái-aimba íma séma Áánútuna aambó kwáráan-aimba arupí umái kwésimatimendaya ísaraumne. ");
INSERT INTO kze_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","emá nóra se kwéisaano. kanaarátááwá táákísi-ontamba Árómáani-kamaani-kwaasiya timénaum. íya timénaumno. timénaundaya Yútaa-kwaasiya kentáásí ámáána araaisénaundaya'iyompo timénaum. íya timénaumno suwaná ");
INSERT INTO kze_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ísu miwí tááma iséna séna ");
INSERT INTO kze_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","moórá-ontamba maimái máagaraasinkaaro súwasa maimái máagaraarankowana séna nááwa óikaana uráinkara áwí'a kwáyáiyo súwasa Árómáani-kamaani-kawaanako óikaamba isaná áwí'a kwáyáiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Árómáani-kamaani-kawaanakondei kwembá áméro. Áánútundei Áánútumba áméro súwasa ");
INSERT INTO kze_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","mináímbá ísówana táá'a kówasa íma aaí siráawe. Ísu kwaási túranka'a ména íma sáwí-aimba súwasa pósa íma aaí sésa tátokaawe. ");
INSERT INTO kze_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","íma tátowasa Sátúsi-monor-aimbo sun-kwáásí púwómpinkemba íma usásinanaaowe kwésun-kwaasi pósa Ísunopa'a tésa ");
INSERT INTO kze_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","sésa anóndakoo naaóvá'á Mósesi séna moóráwai aaraí maimakéna iyámpói íma ankéna púwísana ávákoma maimakéna awaaóná anondáwe séna iyámpói ankáníye siráiye. ");
INSERT INTO kze_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","moórá-aimba isaaó. moórá-tawai avakaeté-avarawainonda mésa tuwaaómá aaraí maimakéna iyámpói íma ankéna púwísana ");
INSERT INTO kze_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","kwenánaaenkewai kware'á maimakéna iyámpói íma ankéna púwísana ");
INSERT INTO kze_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","kwenánaaenkewai kware'á maimakéna iyámpói íma ankéna púwísana mirá eémesa avakaeté-kwaasi putásaawana ");
INSERT INTO kze_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","minínímbá naaémba pukáiye simásuwesa ");
INSERT INTO kze_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ísumba áísaa esa sésa mirámó ombá kwaásimo puwíyampinkembo usásinaiya-tawai minínímbá avakaeté-kwaasi tuwainímbá póna nááwa mayáníyo suwaná ");
INSERT INTO kze_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ísu séna marapá'á máyáan-kwaasi aaraí máyáawasa kwaaí máyáawasa tiyáámúmbaa'a kwétokwaa-esa kwéowe. ");
INSERT INTO kze_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Áánútu tááyena séna pukémpinkemba usásine'a kwíyómpa'a uménaaowe siráimba minínínákwá'á kwíyómpa'a uménaaomba aaraí íma mayáíyasa kwaaí íma mayáíyasa ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Áánútuna kwayó'nárawa'o kwíyómpa'o mésamo ímo kwévuwontemba minkwáásí mirá ésa íma ókwara'a puwónááowe. pukémpinkemba usásinanaaomba Áánútuna kwaásiman-owe. ");
INSERT INTO kze_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","kwaási pukémpinkemba usásinanaaomba Mósesi mináíntávéna agaimakáiye. aúváívimba agaimaréna séna áru-taira'a iramá kaimbá íma mintáímá kágwisana mintáívínkémbá Áánútu Mósesintavena séna Áánútu úne. enaíkwá'ná Ááváramune Áísákaane Yákópone miwítí Áánútu úne siráiye. Áánútú mináímbá siráimba minkáúmbó-kwáásí á'a púwúwasa utamátínkaraambanivo ");
INSERT INTO kze_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","mináímbá siráimba pósa miwí úwoi máyáawe. Áánútu aúranka'a amáparawai máyáawe Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ámáámba sun-kwáásí sésa anóndakoo kawer-áímbá simásimakaane suwaná ");
INSERT INTO kze_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ísun-aaiyavena táá'a kóntavesa íma áísaa úmaesa iráawe. ");
INSERT INTO kze_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","íma áísaa úmaesa íyúwana Ísu séna Káráísitima Tévíti-andaraken-kwaasiman-iye kwésevo ");
INSERT INTO kze_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","naaóvá'á Tévítima Káráísitintavena séna kesí Ísóigoman-iye siráimba monor-ímá agaimakón-auvai-kwandaaivimba Tévíti agaimaréna séna erkesí Ísóigontavena Áánútu séna kesiyáánúrapa'a asirayán-áyámpá'á ");
INSERT INTO kze_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mara'á ména'a ená namuro-kwáásí usáyaaitaanasa miwí ánásanaaowe Áánútumo siráin-aimba Tévíti siráiye. ");
INSERT INTO kze_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","miráumai Tévíti Káráísitintavena séna kesí Ísóigoman-iye siráimbanivo nóraumaiya kwemá Tévítin-andaraken-kwaasiman-iye Ísu súmba Káráísiti Tévítina Ísóigoma éna Tévítin-andaraken-kwaasigoman-iye. ");
INSERT INTO kze_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","sáwíva-kwaasi mináímbá kwéisowana Ísu kwená kwayó-kwáásíyávéna séna ");
INSERT INTO kze_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","évaka'o ámáámbo sen-kwáásítí aambá kwáráávo. minkwáásí ayáátáár-ampantama iyésa naaópa'a avuvumpa'á kwénaaowasa pósa kwaási tuwánésa sésa anón-kwaasiman-owe kwésewe. minkwáásí mono'-náúmpá'ó umáyáapa'a anón-kwaasimo maí-áyámpá'á umésa tanómbo kaúvópa'o máyáapa'a kawer-áyámpá'á mésa kawe-tómbá kwénaawe. ");
INSERT INTO kze_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","minkwáásí ketor-íníntí óísankwara naankwará'á umóyámbá kwémaesa kwaási suwánésa súwí'a mósá maráígwáe sésa kampakómbá tavisimái-namunaa kwésewe. mirámó owáíná anondá umbai-yántáá'á mayánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","simásuwena Ísu anóm-bono'-naumpa'a ména tuwánómba óntambo túwón-anaveumpimba sáwívar-oisankwara-kwaasi sáwívar-ontamba túwówana ");
INSERT INTO kze_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","moórá-ketor-ininko íma óísamba makón-ininko téna sáwíyan-ontamba kae-tóyáráámbá tuwómba Ísu awánéna ");
INSERT INTO kze_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","kwená kwayó-kwáásíyávéna séna árai'a simátime'a sé'a minkétór-ínínkómó túwáin-ontankoma amápa-kwaasimo tukáan-ontankomba usáyaaitaiye. ");
INSERT INTO kze_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","miwímá sáwívar-oisampinkemba évaka'a tukáavo kwemá sáwíyan-oisampinkemba mútú'a túwáimba póna óísan-iyaaimba méniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","súwasa évakarawai anóm-bono'-nantavesa sésa kawer-óntánkákémbá úmakaawe. Áánútumba ámakaaan-tantaa'a konaarirí úmakaawata awánéta aamoiyá kwéune suwaná ");
INSERT INTO kze_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ísu séna aáno kwaási tésa awánaan-tantaa'a amápa'a tawísíyuwesa amápar-ontankwarare tawísíyuwanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ísu mináímbá súwasa áísaa esa sésa anóndakoo emó sénda nósa-tawaiya tíníyo. nóran-awaamera ínata séta ákíra'a Ísumo simbá mirá íníyeya sénaumno suwaná ");
INSERT INTO kze_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ísu séna kampar-áímbá isé'a áraire sevó kárákwiyoro. sáwíva-kwaasi tóyo ésa kesúwí'a mágwétesa sésa Áánútumo usásisinkaiwai únda póna minkánáá sáwíyanka'a tíníye sénááowe. mirán-áímbá síyawai tínaaemba íma kwáráaro. ");
INSERT INTO kze_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","áái'o tíyáán-aimba némpakena'i. egwaakéná'i. isáíyana íma táá'a kaíno. mirán-kánáámó tínda mindá íma amápa-tantaa'a ánásai-awaame'an-iye. ");
INSERT INTO kze_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","moórá-ayampa-kwaasimo ésa ó'on-ayampa-kwaasiye áái'a tiyánááowe. moórá-kawaa-kwaasigomo éna moórá-kawaa-kwaasigona amááraayavena usásimbai áái'a tíyáaro sínasa usásinesa áái'a tiyánááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ó'on-o'om-barava'a anóm-barima táníye. ó'on-o'om-barava'a ayawaimá táníye. sáwíva-kwaasi tí'a íníye. kwíyómpa'a ó'on-o'on-tantaa'a paárína'a awáné'a táátavai ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","mintántáá'ó ímo paárínasa keinárawa'a táto'mai sáwí'a umátinkesa mono'-náúmpá'á mono-káwáá-kwáásí aaivimbá maitinkésa ándáva'a mótinkanaaowe. kentáváímó asiramáímo máyáantavesa táto'mai anón-kwaasitopare kámááni-kawaa-kwaasitopare mótinkesa aaí simátinkaiya'a ");
INSERT INTO kze_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","minánón-kwáásí kesáái simátimenaaowe. ");
INSERT INTO kze_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","aaimó simátínkénka'a nóran-aina sénaumno-imayaa íma anómba íyana tirunkó íma umbaí taíno. ");
INSERT INTO kze_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","minkánáá kawer-ímáyáá timé'a aaí tááka'a tínkáana'a síyasa kentí namuro-kwáásí íma kanaán-umai kentááí araaisésa íma usáyaaitanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","kentinóvowiye kentívá'awaawiye kentimááraawiye kentí kwaásiye tí'maesa anón-kwaasitopa'a mótinkesa aaí simátinkaiyasa keinárawapinkemba évakarawai tínkamiya'a puwónááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","kentáváímó asiramáímo máyáantavesa amáparawai tíyámba umátinkanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","mirá ésa íma timambá tínkambai ánásanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","asiramáímo maé'o é'a kawe'á umái ménaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ísu mináímbá simásuwena séna Yérúsaremu-naopa'a namuro-kwáásí taúkúmaraiya'a sé'a amápa-tantaa'a tawísíyuwanaaon-kanaa tiyé sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yútiyaa-marava'o máyaiyan-kwaasi omápata isaaisésa iyónááowe. naaópa'o máyaiyan-kwaasi mindáópa'a tuwésa kóyáwé ónááowe. kígauva'o máyaiyan-kwaasi íma naaópa'a iyónááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","minkánáá Áánútu sáwí-meyamba timínana Áánútun-aai aúváí-kwandaaivinken-aimba paáriniye. ");
INSERT INTO kze_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","tímúkwarar-inimba ívér-iyampoigwarar-inimba minkánáá sáwí'a ónááowe. Áánútu maankwáásíyávéna áwáá'a tiyínana anón-umbai táníye. ");
INSERT INTO kze_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ó'om-baravakewai évakarawai ayáátáá'-mankara'nei tínkamesa évaka'a tí'maesa ó'on-o'on-kwaasiti maravá'á mótinkesa ó'onkaa-kwaasi Yérúsaremu-naopa'a kárákwiyesa sáwí'a íyana Áánútu séna kentí kanaamá ánásaiye síníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ísu mináímbá simásuwena séna aaváúrá'á kwíyónka'a oká'á ó'on-o'on-tantaa'a paáriniye. marapá'á ó'on-o'om-bapaken-kwaasi umbaí tiyáníye. uwí-nónkó anónka'a áái kwésena tuvántááva ínasa kwaási inkaisénááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","kwíyónko tora'naára'a ínasa kwaási sésa nóra íníyo sésa tiyántámbá kwétainasa táátavai kwéesa anón-imayaa ónááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","kemá kwaási úrandako anón-asirayankwara ságayankwara'a ainámpímbá kúmóna'a suwánanaaowe. ");
INSERT INTO kze_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","kemó súnda-yantaa'a ááimba ásámai paárína'a mósá awánanaaowe. Áánútu kawer-ámpá'á métinkanin-kanaa sáwíyanka'a tínímba pó'a to'mayaa umái mé'a mósá awánaaro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ísu mináímbá simásuwena séna moórá-tai naí-táígó áwí'a víki mindágwara ó'on-taigwara'a imáyáa oró. ");
INSERT INTO kze_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","aráságáyómó agayáínda awáné'a sé'a áú'o sínín-kanaa sáwíyanka'a tíníye sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","mirámó intembá kemá súnda-yantaa'a ína'a awáné'a sé'a Áánútu kwená kwaási kwégawaaimba sáwíyanka'a tíníye sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","árai'a simátime'a sé'a ívé'o máyáan-kwaasi évaka'a íma pukáiyanka'a kemó súnda-yantaa'a paáriniye. ");
INSERT INTO kze_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","kwíyómba maramá ánásainana kesáái íma ánásena úwoi kwaíkwai'a íníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ísu simásuwena séna kentúra'a kárákwiyoro. uwo'aó'-nómbá né'a kavóná mé'a marapá-tántáá'á anón-imayaa ováínivo. mirámó kwé'o é'a íma imáyáa kwéiyanka'a kumúnavainivo kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kívo'o aumakáawanamo ímo imáyáa imbó kwaígomo tavágwintemba ó'on-o'om-baravaken-kwaasi íma kwéisenka'a kumúnavainivo ");
INSERT INTO kze_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","kárákwiyoro. námúnaa símae kwéiyiyana kemó súnda-yantaa'a kentópa'o tína'o é'a asiramái é'a kwaási úrandako súranka'a ménaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","minkánáávímbá aasiyaasi-táwai Ísu anóm-bono'-naumpa'a uména kwenáái simátíma'maena kwéiyena enónka'a máápa'a kumbéna Óríve-omapa'a no'wáámba umaí'mai kwéuwasa ");
INSERT INTO kze_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","sáwíva-kwaasi aaváyaavimba ááéma Ísun-aai isánáe sésa anóm-bono'-naumpa'a umaí'mai'a úmae iráawe. ");
INSERT INTO kze_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","naaóvá'ó Áánútu Yútaa-kwaasi tíyótaasa í-tánómbá ímo intóráín-tantaakwara-pereti kwéagayon-kanaama sáwíyanka'a túwasa ");
INSERT INTO kze_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé Ísuna ámááyu-aimba suwaná úwoi-kwaasiyavena táá'a kówasa íma avora'á tátoranaumne siráawe. ");
INSERT INTO kze_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","suwaná Ísuna kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasivinkewai áwí'a Yútási moórá-awi'a Isakéríóti póna Sáátáánigo kwenarumpimbá koména imáyáa amúwana ");
INSERT INTO kze_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","mono-káwáá-kwáásítópare mono'-náká'ó kárákwirowaitopare kwéna séna túwa'naa ona'á Ísumba tátoranaaowe súwasa ");
INSERT INTO kze_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","isésa aamoí kwéesa sésa mirámó inda-méyámbá óntanta aménaumne suwaná ");
INSERT INTO kze_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yútási owé séna ímo kwaásimo mépa'o é'a nóraumai Ísumba agaráátínkáanasa tátoranaao-imayaa ááimba ásámai uráiye. ");
INSERT INTO kze_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yútaa-kwaasi ímo intóráin-tantaakwara-pereti kwéagayon-kanaa túntemba tíyótaasa í-tánón-kánáá sipisípi-araa'a tuvú'mái kwégauvunka'a ");
INSERT INTO kze_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ísu Pítaante Yóninte ti'maréna séna tíyótaasa í-tánómbá kogwégauviyata komandaanó súwasarai ");
INSERT INTO kze_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","mindárai sésarai náávara kogauvóyauyo suyaná ");
INSERT INTO kze_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ísu séna Yérúsaremu-naopa'a kwíyana moóráwaimo nonánámo maimaénamo kwíndawaimba kóánaaemba kwáráakaiyo. kwemó naaúmpa'o iyínanamo ");
INSERT INTO kze_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","naankó avowámó máyáinakai kosimámekai anóndakoma áísaa ena séna kesí kwayó-kwáásíyé náán-ayampara tíyótaasa í-tánómbá nánaumno kwésiye kosimámékaiyo. ");
INSERT INTO kze_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","kwemá avóvomayaa'-nankomba anón-ayaampa'a agaráátinkaniye. kísuvu'o umándanaaon-tantaa'a mimpímbá kwáyáiye. amápa-tantaa'a arúsámarekai minká'á kausínkáakaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","mindárai isésarai Yérúsaremu-naopa'a kwésarai Ísumo sún-tantaa'a kwáyowasarai minká'á tanómba mágauwankaraaiye. ");
INSERT INTO kze_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","tanómba nánááon-kanaa túwasa Ísuwe kwená aantá-kwaasiye toómbó naívá'á komáyówana ");
INSERT INTO kze_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ísu simátimena séna sáwíyanka'a sí'a índai'a umásinkanaaon-kanaa íma tiráina'a ááéma tíyótaasa í-tánómbá keinárawate nánaumne-imayaa úmae iráunda ívé'a minkánáá paárimba póta nánaumne. ");
INSERT INTO kze_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","simátime'a sé'a marapá'á maantánómbá íma ókwara'a nánaumpo Áánútu kwená kwaási kwégawaaipa'a maantánónkóná ááimba avora'á kwáyaina'a nánaumne séna ");
INSERT INTO kze_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ándá-aran-dombo kwáyon-anaveumba maisoréna Áánútumpa'a súwi séna maimái moórá-mora-umai naaró. ");
INSERT INTO kze_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","simátime'a sé'a ándá-aran-domba íma nánaumpo Áánútu kwená kwaási kwégawaaipa'a mé'a ókwara'a nánaumne séna ");
INSERT INTO kze_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","péréti maisoréna Áánútumpa'a súwi séna topámbai tímatuwena séna mindá kesúman-ivo keinárawatave'a ísámai kesúma tuwánaumne. miráumai kentávé'a imáyáa kwée'a námae íyóro súwasa ");
INSERT INTO kze_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","toómbá násúwówana ándá-aran-dombo kwáyon-anaveumba maisoréna pérétimo timúntemba miráumai ándá-aran-domba tiména séna mindá kesí naaemán-iye kesí naaemá keinárawatavena kumínímba póna Áánútu séna kesé tarúmai máyáawe séna mináúná-áímbá simái tarúmakaisa'a miráumai kentávé'a imáyáa kwée'a námae íyóro. ");
INSERT INTO kze_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","kembó namuro-kwáásírá'ó agaráátinkaniwai keséya ména toómbá kwénaiye. ");
INSERT INTO kze_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","naaóvá'á Áánútu séna kwaási úrandako puwíníye siráintemba pó'a púwónana namuro-kwáásímó agaráátinkaniwai sáwí-meyamba mayáníye Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","kwená kwayó-kwáásí keáímbá sésa nááwa mirá ínísana siyó siráawe. ");
INSERT INTO kze_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ísuna kwayó-kwáásí keáín-keaimba sésa kentáávínkémbá nááwa aiva-kwáásí-í'a íníyo kwésuwana ");
INSERT INTO kze_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ísu séna marapár-ánón-kwáásíyómbá usáyaaitamai asirayán-áímbá simáti simati kwéuwasa kwenkóyai kwentáyai'a ésa sésa kentáásí anón-kwaasi kawe'á kwéowe siráawe. ");
INSERT INTO kze_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","keinárawa'a miráumaimo anón-kwaasimo ontembá íma mirá oró. keinárawapinkemba anómba ménae síyawai amáparawaiti mayáí túwa'naa oró. usáyaaitanae síyawai ó'owiti kwayó'á márááro. ");
INSERT INTO kze_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","marapá-kwáásívínkémbó toómbó ménamo kwénaiwai anón-kwaasin-ivo kísuvu'o kwéumamiwai sáwíyan-kwaasi imbánivo kemá kentí anóndako íma mirá é'a kentí kwayó'nákáání'a kwéune. ");
INSERT INTO kze_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","mirá úna'a kembó sáwí'o umásínkáanka'a kesé mé'a íma síyukaawe. ");
INSERT INTO kze_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","kesivo kentávéna séna kwaási kawááuwo siráintemba keinárawatave'a mirán-áímbá simátimenaumne. ");
INSERT INTO kze_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kwaási kawáá ondará'á mé'a toómbá kwéne'a kawáá ondará'á mé'a Ísareri áánimbaa'a sísamaivakemba kae'á kumbaimái-aanimbaati minándárákén-kwáásí táái isé'a taaínkaa'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ísu Sáímonimba arumbá umánkena séna Sáímoniyo isaaó. owáímó to'máímo tuvimpí owanamó arú'ó marapá kúmísasamo anónka'a mósá máyáantemba kawe-tántáá'á mósá maé'a sáwí-yantaa'a úwoi kwáyaindayavena Sáátáánigo tísaa umai isánáe sína'a ");
INSERT INTO kze_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","mindáyave'a Áánútumpa'a námúnaa sé'a kesémo aráápamai máyaanda siyuwáanavo sé'a námúnaa siráumne. emá siyuwé koyauweré kesí kwaási asiramátinkaao Ísu súwana ");
INSERT INTO kze_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pítaa séna Ísóigoo ándáva'o áí'maesamo kwíya'o é'a kesé kóyauye. tuvuwíyamo puwína'o é'a kesé puwóyauye Pítaa súwana ");
INSERT INTO kze_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ísu séna Pítaao simáme'a sé'a ívé'a kokórigo íma áái siráindara'a emá kaumborá'á kentáváí se íma awánáúnda-kwaasiye síníyone Ísu Pítaantavena siráiye. ");
INSERT INTO kze_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ísu simásuwena kwená kwayó-kwáásíyávéna séna óntambo inaainaaimó sií-únámbá íma maimaé'a toón-únámbá íma maimaé'a kwé'a tísamai ánáamba íma maimaé'a koró mináímbá ááéma sé'a ti'mákaunda moórá-yantaatave'a aáváán-kuráina'iyo súwasa miwí sésa ímaniye suwaná ");
INSERT INTO kze_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ísu séna ívé'a óntan-unamba makáiyawai minúnámbá maimaésa koró. toón-únámbá makáiyawai minúnámbá maimaésa koró. taánasatama íma makáiyawai miwítí paákákén-únánkwátói ó'owima timésa óntamba mairésa taánasatama meéyán-uresa koró. ");
INSERT INTO kze_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","simátime'a sé'a naaóvá'á Áánútun-aai aúváí-kwandaaivimba Áísáya agaimaréna séna eráí'maesa sáwí'a uráan-kwaasi ermépa'a móankaraawe agaimaréna siráimba kentávéna siráimba póna paáriniye Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","kwená kwayó-kwáásí sésa Ísóigoo kae-tánasatama makáumne suwaná kwemó sún-ainkona ááimba íma ísóntavena séna á'aniye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ísu simásuwena máápa'a kuména Óríve-omapa'a umaé'mae kwéuntemba iyúwasa kwená kwayó-kwáásí ánaaemba kwa'maésa ");
INSERT INTO kze_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","íyúwana Ísu simátimena séna Sáátáánigo tísaa umai isánáe-aimba kentópa'a síyáváínivo Áánúmpa'a námúnaa seró séna ");
INSERT INTO kze_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","tiyuwéna egwaa'á kwéna Áánútu anónda'an-iye séna mara'á kumbaéna námúnaavinkemba ");
INSERT INTO kze_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","séna kesivoó embó ankáinamo e maanúmbáí-yántáá'ó kesópa'o tínímba maisiyuwéma ánivo kesí imáyáa íma kwáréna'a ená imáyáa kwáráano súwana ");
INSERT INTO kze_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Áánútuna kwayó'ná'á kwíyómpakewai paáréna asiramánkarowana ");
INSERT INTO kze_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","arunkó anón-umbai tówana Áánútumpa'a námúnaa asiramái kwésuwana umisimá naaeráámbá marapá'á úmae kumúwana ");
INSERT INTO kze_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","námúnaa simásuwena usásinena kwená kwayó-kwáásíráútópa'a téna tayuwánómba tirunkó umbaí tówasa tuún-kwaigurówana ");
INSERT INTO kze_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","tayúsena tasimátimena séna tuúmó kwáyáamba usásine'a námúnaa seró. Sáátáánigo tísaa umai isánáe-aimba kentópa'a síyáváínivo Áánútumpa'a námúnaa seró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ísu mináímbá kwésuwana sáwíva-kwaasi kwétuwana Ísuna kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasivinkemba moóráwai áwí'a Yútási kwemá misáwívá-kwáásívímbá aiva'á téna Ísumba paruvará umánkaindayavena Ísuna egwaa'á túwana ");
INSERT INTO kze_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","kampakómbá kwéuntavena Ísu séna Yútásiyo kemá kwaási úrandakomba kesí namuro-kwáásírá'ó agaráátínkéndayavai paruvará kwéumasinkaane súwasa ");
INSERT INTO kze_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ísuwe máyówai moórá-yantaa'o paárinin-imayaa ésa sésa Ísóigoo taánasataneiya karánaumno suwaná ");
INSERT INTO kze_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ísuna kwayó-kwáásívínkémbá moóráwai taánasata maimaéna aiva'-mónó-káwáánákóná kwayó-kwáásígón-áá'a agáúsuwowana ");
INSERT INTO kze_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ísu étuwaao séna minkwáásígón-áá'a maimái kawe'á umánkaraiye. ");
INSERT INTO kze_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","kawe'á umánkowasa mono-káwáá-kwáásíyé mono'-nánká-káwáá-kwáásíyé anón-kwaasiye Ísumba tátoraiyanesa tamáyówana Ísu simátimena séna kentávé'a umóyán-kwáásímán-iye sé'a pó'a taánasatagwara ánáyatankwara'a maimaé'a kembá tátoranae sé'a kwétewe. ");
INSERT INTO kze_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","sáwíva-tawai anóm-bono'-naumpa'a kesé máyaundara'a íma kembá tátokaawe. ívé'a kentí kanaamá tisa'á tunínkóná asirayánkwárá'á mé'a kembá tátoranaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","súwasa Ísumba tátoresa áí'maesa aiva'-mónó-káwáánákóná naaúmpa'a móankowana Pítaa tínaaemba nénka'a teémáyomba ");
INSERT INTO kze_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","mindánkóná naamaúva'a iramá agaimarésa máyówana Pítaa miwísé mara'á tamáyowana ");
INSERT INTO kze_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","iramá kawe'á umái kwégowana moórá-kwayor-arasigo téna Pítaamba takarákéna séna minkwáásígó kwesé máíwain-iye súwana ");
INSERT INTO kze_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pítaa séna ímanivo kemá íma awánáúnda-kwaasiman-iye súwana ");
INSERT INTO kze_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","sáwíyanka'a moóráwai Pítaamba taawánéna séna kwená kwaásivinkenda'a óne súwana Pítaa séna kemá ímaniye súwana ");
INSERT INTO kze_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","sáwíyanka'a moóráwai Pítaantavena asiramái séna árai'a súne. Kárírivakenda'a póna kwená kwayó-kwáásívínkéndá'án-iye súwana ");
INSERT INTO kze_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pítaa séna emó sénda-aimba íma kwéisaumne kwésuwana kokórigoma áái súwana ");
INSERT INTO kze_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ísóigo kwanténa Pítaamba awánówana Pítaa Ísóigo simámun-aimba ááka'a maréna mirá siráinka'a ívé'o kokórigomo ááimo ímo siráindara'a emá kaumborá'á kentáváí se íma awánáúndana'an-iye síníyone siráimba mináímbá ááka'a maréna ");
INSERT INTO kze_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","máápa'a kuména ávááraumai ivi'á taráiye. ");
INSERT INTO kze_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pítaa ivi'á tówasa Ísunka'a kárákwirowai kanaáráá'a ankésa tuvuwésa ");
INSERT INTO kze_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","aúrampa'a ampantanéí káátamakesa kwétuvuwesa sésa esáváí se Áánútumo usásisinkaiwai úne séndawai ómpo kemá nááwa kwétuvuwuna simásimiyo kwésesa ");
INSERT INTO kze_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ó'on-o'on-aimba simái sáwí'a umánkaraawe. ");
INSERT INTO kze_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","aaváúmá usónka'a Yútaa-kwaasiti anón-kwaasiye mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé torupamái máyówasa Ísumba áí'maesa móankowasa ");
INSERT INTO kze_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","sésa Áánútumo usásinankaiwai Káráísitiya'ona simásimiyo suwaná simátíména'o é'a íma kawe'á umái isánááowe. ");
INSERT INTO kze_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","moórá-aimbo tísaa ona'ó é'a íma simásimenaaowe. ");
INSERT INTO kze_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","kemá kwaási úrandako Áánútu asirayáwáíná ayáánúrapa'a asirayán-áyámpá'á uménaumne súwasa ");
INSERT INTO kze_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","amáparawai sésa ewá sé Áánútu ááninko úne kwéseno suwaná Ísu séna á'a sewé súwasa ");
INSERT INTO kze_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","miwí sésa kwesáváí siráimba póta mináíntávéta aavintá mayankéta ó'on-aimbo simánkáamba avakáá únda póta ivátá tuwánaumne siráawe. ");
INSERT INTO kze_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","mináíntávésa misáwíváráwáí usásinesa Ísumba áí'maesa Árómáani-kamaani-kawaanako áwí'a Páírátinopa'a máankesa ");
INSERT INTO kze_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","aaimá simánkesa sésa minkwáásígó Yútaa-kwaasi kampar-áímbá simátimena miwítí imáyáa simái sáwí'a kwéena séna Árómáan-kamaani-anondakomba táákísi-ontamba íma áméro kwésena kwesáváí séna Yútaa-kwaasiti kawááná'á é'a Áánútu usásisinkaiwai úne siráiye suwaná ");
INSERT INTO kze_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Páíráti Ísumba áísaa ena séna Yútaa-kwaasiti kawáánárá oónó súwana Ísu séna á'a séne súwana ");
INSERT INTO kze_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Páíráti mono-káwáá-kwáásíyáváíyé úwoi-kwaasiyavaiye séna minkwáásígó íma sáwí'a uráisa'a awánáúmne súwasa ");
INSERT INTO kze_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","asiramái sésa Káríri-ayampa'a kwaásiti imáyáa kwéyavisena minkákémbá Yútiyaa-ayampa'a taména mirá kwéiye siráawe. ");
INSERT INTO kze_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","suwaná Páíráti mináímbá iséna séna Káríri-ayampakendara'iyo súwasa ");
INSERT INTO kze_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","owé mináyámpákéndá'án-iye suwaná imáyáa éna séna Éróti mináyámpákén-káwááná'á póna ívé'a maanká'á Yérúsaremu-naopa'a tamáyáimba póna ai'máráanana kwenópa'a kwínana kwemá isáníye Páíráti simásuwena ai'marówasa áí'maesa Érótinopa'a máánkaraawe. ");
INSERT INTO kze_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ayáátááka'a Éróti Ísuntavena kwésun-aimba iséna Ísumba awánaanana ímo awánáúnda-mayai mayáína'a awánanae súwasa Ísumba Érótinopa'a máánkarowana awánéna aamoí éna ");
INSERT INTO kze_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ó'on-o'on-tantaatavena áísaa úwana Ísu íma aaí súmba úwoi máyowasa ");
INSERT INTO kze_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","mono-káwáá-kwáásíyé ámáámba sun-kwáásíyé mésa Ísumba simánkón-aimba asiramái suwasá ");
INSERT INTO kze_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Érótiye kwená i-kwáásíyé Ísumba simái sáwí'a kwéumankesa kanaáráá'a ankésa anón-kwaasiti unáánkwátói umánkesa áí'maesa Páírátinopa'a ókwara'a máánkaraawe. ");
INSERT INTO kze_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ááéma Érótiye Páírátiye aaisambá sirááyamba pósarai minkánáámá kawe'á umái máyóyasa Ísumba áí'maesa ókwara'a Páírátinopa'a máánkaraawe. ");
INSERT INTO kze_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","máánkarowana Páíráti mono-káwáá-kwáásíyé anón-kwaasiye úwoi-kwaasiye tááyena ");
INSERT INTO kze_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","séna minkwáásí kesópa'a máanke'a sé'a kwaásiti imáyáa simái sáwí'a kwéiye kwésewe. kentúranka'a áísaa únana simánkáan-ainkona ááimba íma kwáyáísa'a awánáúmne. ");
INSERT INTO kze_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Érótiye áísaa úyamba mináínkóná ááimba avakáá uwááekai úyana ai'máráísasa áí'maesa kesópa'a tiráawe. tuvuwíyanamo puwíníni'a uráimba ");
INSERT INTO kze_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","pó'a i-kwáásí senasá áwíruku'a násúwéwa'a ayúrankanaumne súwasa  ");
INSERT INTO kze_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yútaa-kwaasi tíyótaasa í-tánón-kánáá tóyo úntemba moórá-kwaasi tááyowana Páíráti minkwáásí ayúrankowana miwítópa'a kúwana Páíráti séna Ísumba ayúrankanae súwasa ");
INSERT INTO kze_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","amáparawai anónka'a sésa ímanivo tuvuwíyana pwínívo Párápásimba ayúrankaaao siráawe. ");
INSERT INTO kze_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ááéma évakarawai kámááni-kwaasiye áái'a tíyómba moóráwai áwí'a Párápásima kwemá moóráwaimba tuvuwúwana puwúwasa ándáva'a ánkarowasa sésa Párápásimba ayúrankaao suwaná ");
INSERT INTO kze_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Páíráti Ísumba ayúrankanae-imayaa éna simátimuwasanivo ");
INSERT INTO kze_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","anónkar-anonka'a sésa taaira'á tuvuwíyana puwíno suwaná ");
INSERT INTO kze_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Páíráti ókwara'a séna nóra-sawira uráina'iyo. tuvuwíyanamo puwíníni'a íma uráimba pó'a i-kwáásí senasá áwíruku'a násúwéwa'a ayúrankanaumne súwasa ");
INSERT INTO kze_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","anónka'a sésa taaira'á tuvuwíyana puwíno símae íyún-ainko Páírátin-aaigomba usáyaaitowana ");
INSERT INTO kze_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Páíráti miwí táái iséna owé séna kemó sentembá oró séna ");
INSERT INTO kze_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","moóráwaimba ayúrankena kámááni-kwaasi áái'o tíyómbo moóráwaimba tuvuwúwana puwúwasa ándáva'a ánkarowaimba tááyowaimba Páíráti ayúrankena taaira'á tuvuwíyana puwíníye-imayaa untávéna Ísumba i-kwáásírá'á tímakaiye. ");
INSERT INTO kze_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","timúwasa i-kwáásí Ísumba áí'maesa kumbá moóráwai Sáíríni-naopakewai áwí'a Sáímoni kwemá Yérúsaremu-naor-ampa'a túwasa i-kwáásí tátoresa Ísumbo tuvuwónááon-taima áúgwaatarankesa sésa Ísun-ánaaemba tiyó suwaná mirá úwasa ");
INSERT INTO kze_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","sáwíva-kwaasi Ísun-ánaaemba kwa'mái kwéguwasa aaraiyómbá tirumbá umánkesa imá sirésa ivi'á támaesa ánaaemba kwa'mái kwéguwana ");
INSERT INTO kze_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ísu kwanténa séna Yérúsaremu-naopaken-inintono. íma kesí ivi'á té'a kentí iyámpóíyavaiye kesáváíyé ivi'á taaró. ");
INSERT INTO kze_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yérúsaremu-naopa'a sáwí-kanaama tínímba ageíníné ímo iyámpóímo tinkésamo náámbo tímakaan-inine aamoí kwéesa iyámpói-iyaaimba pó'a inkaisé'a kónaumne sésa aamoí kwéowe sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","minkánáámó tínímba sáwíyan-omakontavaiye anón-omakontavaiye sésa ááéma pukónáivo kítímae kusiráápaao sénááowe. ");
INSERT INTO kze_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","kemá aúná-tairaani'a únda pósa sáwí'a kwéumasinkaavo keinárawa'a aáyánkayan-tairaamba ombá pósa sáwí'a anómba umátinkanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ísu súwasa kae-kwáásí sáwí'a urááyan-kwaasigwara'a tí'maesa Ísunte tínkamonae sésa tí'maesa ");
INSERT INTO kze_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","mimbárágó áwí'a a'nómayaampare supa'á kurésa Ísumba taaira'á tuvuwésa évarevar-akwampa'a kae-kwáásí taaira'á tuvúsúmarowana ");
INSERT INTO kze_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ísu séna kesivoó mayáígóná ááimba íma awánaresa kembá sáwí'a kwéumasinkaamba íma imáyáa e sáwí-meyamba íma timé sáwí-imayaa maitiyuwaaó súwasa i-kwáásí sésa kwená unáánkwátói nááwa mayáníyono sésa taaínkaar-urésa aávéima tésa usáyaaitaindawai mayáníye suwasá ");
INSERT INTO kze_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","kwaásiyomba mésa árimba awánésa Yútaa-anon-kwaasi kanaáráá'a ankésa sésa ó'owi túwa'naa ena Áánútumo usásinkaiwaimo énamo éna kwesáváí kwenáúma áwa'naa íníye suwasá ");
INSERT INTO kze_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","i-kwáásíyé kanaáráá'a ankésa ikaa'ó vón-domba maimaésa kwenópa'a tésa sésa naaó. ");
INSERT INTO kze_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Yútaa-kwaasiti kawááná'ó émo e esáváí enáúma áwa'naa uwo suwasá ");
INSERT INTO kze_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ááéma aúváíma agaimakésa sésa Yútaa-kwaasiti kawááná'án-iye sésa agaimái Ísu a'nónká-táírá'á mósá makáawe. ");
INSERT INTO kze_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","mósá márówana sáwí'o uyan-kwáásímó tínkamuyan-kwaasigorai moóráwai Ísumba kanaáráá'a ankéna séna Áánútumo usásinankaiwaimo émo e enáúma áwa'naa e kenkáígwárá'á súwa'naa uwo súwana ");
INSERT INTO kze_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","moóráwai séna íma mirá siyó. Áánútun-áá'o kwéinkaiseraai mirá íma sésino. kwembó sáwí-meyambo kwéamentemba kenkáígwárá'á mirá kwéowe. ");
INSERT INTO kze_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","kwemá íma sáwí'a uráiwaimba sáwí-meyamba kwéamevo keiráí sáwí'a uráuyawainkai sáwí-meyamba kwéumasinkaawe séna ");
INSERT INTO kze_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ísuntavena séna Ísuwo ená kwaási kawáá indará'á kesí imáyáagwara'a uwó súwana ");
INSERT INTO kze_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ísu séna árai'a simáme'a sé'a ívé'a kesé kawe'-mápá'á méniyone Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","súwana kwáyá'wái amápa'-mapa'a túnkwena aaváúmá kaapa marówana túnkumba ");
INSERT INTO kze_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","anóm-bono'-naumpa'a ampanta-óntámá úmakomba taváákaarumai kaesé umágúwana póna Áánútunopa'a iyónááon-amba onta tisuwówana ");
INSERT INTO kze_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ísu anónka'a séna kesivoó kesimambá enayáámpimba kwéto'maraumne simásuwena puwúwana ");
INSERT INTO kze_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","i-kwáásítí kawáánákó Ísumo puwúmba awánéna Áánútu áwí'a mósá maréna séna árai'a arupí-kwaasiman-iye súwasa ");
INSERT INTO kze_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","sáwíva-kwaasi koawánanaumne sésa torupamái máyón-kwaasi Ísumo puwúmba awánésa tirunkó umbaí tówasa miwítí naaópa'a kóyáwé uwasá ");
INSERT INTO kze_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ísuwemo naaún-kwaasiye Káríri-ayamapakemba Ísun-ánaaemba kwa'maésa Yérúsaremuva'a tirón-inine nénka'a tamésa amápa-tantaa'a awánaraawe. ");
INSERT INTO kze_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","awánowana moóráwai áwí'a Yósépi Yútiyaa-marava'a Árímátíyaa-naopakewai kwemá kawe'ná'á arupí umái máyowai Áánútu kwená kwaási kawáá íníye séna amu'maréna póna Ísumbo tuvuwónáe sun-kwáásí tááiyavena íma owé siráiwai kwemá ");
INSERT INTO kze_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Páírátinopa'a téna Ísun-auma utánáivo simiyó súwana owé súwana ");
INSERT INTO kze_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ísun-auma taairakémbá tamaimái aúná-ampantavimba asááumai maimaésa kwaási aúsámakon-ontam-buri-aivimba mámaresa kwaási íma makóm-buri-aivimba mámaresa ");
INSERT INTO kze_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","toómbó áká'maimo to'mayaa un-kánáá Yútaa-kwaasi agándon-kanaa sáwíyanka'a tíníye kwésuntavesa Ísumba utamánkówasa ");
INSERT INTO kze_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kárírivakembo Ísun-ánaaembo kwa'maésamo tirón-inimba Yósépi-ánaaemba kwa'maésa tésa Ísumbo utamánkomba taawánésa ");
INSERT INTO kze_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","tayauwerésa áúra'o mápérankanae sésa áséi-kwiyum-basawemba to'mayaa unká'á agándon-kanaama túwana ámáámbo sunten-umái úwoi méraawe. ");
INSERT INTO kze_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","agándon-kanaama úwoi máyówana ánásowasa aaváúmá usónka'a áúra'o mápérankanae sésa áséi-kwiyum-basawemba to'mayaa úmakom-basawemba maimaésa Ísumbo utamánkaropa'a kwésa ");
INSERT INTO kze_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","awánomba anón-ontamba óikakemba á'a akwátukowasa awánésa ");
INSERT INTO kze_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","mimbúrí-áírá'á íyúmba Ísóigo Ísun-auma íma kwáyowasa awánésa ");
INSERT INTO kze_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","anón-imayaa ésa awánomba kae-kwáásíráí túgáyáagaya ún-unankwatoi urésarai egwaa'á máyóyasa tuwánésa ");
INSERT INTO kze_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","6","táátavai ésa kívairowasarai sésarai púwísa'o máankaraam-buri-aivimba íma máyáivo usásinena kóuraivo íma maampímbá avakáá-oro. kwemá Káríriva'a úwoimo máyáinka'a simátímakain-aimba imáyáa oro. ");
INSERT INTO kze_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","maará séna kembá kwaási úrandakomba sáwí-kwaasira'a timíyasa sínkamiya'a puwé'a kaumbo-táwai maisuwé'a usásinanaumne siráiye suyasá ");
INSERT INTO kze_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","isésa simátímakain-aimba tááka'a marésa ");
INSERT INTO kze_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","mimbúrí-áímá tuwésa kwésa Ísuna kwayó-kwáásí sísamaivakemba moórá kumbaimái-kwaasiye ó'on-kwaasiye mináímbá kosimátimesa ");
INSERT INTO kze_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","minínímbá moórá Mágátáraa-naopaken-ininko áwí'a Máríyaa úwana moórá araámáó kwemá Yémésimba anówama úwana moórá Yóánana úwasa miwísé máyón-inimba Ísuna aantá-kwáásíyávésa mináímbá kosimátímúwasa ");
INSERT INTO kze_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","isésa sésa úwoi kampar-áímbá sewé simásuwesa úwoi máyówananivo ");
INSERT INTO kze_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pítaa usásinena isaaiséna utamánkóm-buri-aivimba kokívairena awánómba ampantanéímó asááúmaesamo máutamankaron-ampantawe su'mai kwáyowana awánéna koyauweréna mindáyavena anón-imayaa uráiye. ");
INSERT INTO kze_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","anón-imayaa úwasarai mitáwai Ísuna kwaásivinkemba kae'nárai Éméyási-naopa'a kóyáe siráái. mindáópa'a Yérúsaremuva'a ayáátáákakaamba kwáyowasarai Éméyási-naopa'a kóyáe sésarai Yérúsaremuva'a tuwésarai aampa'á kwégwesarai ");
INSERT INTO kze_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ísumbo éiron-aimba símaesarai kwéguyana ");
INSERT INTO kze_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ísu egwaa'á téna minkáé'náraiye kwéguwasarai ");
INSERT INTO kze_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","awánoyana Áánútu túrampa'a túntinkarowasarai íma aúyamai kawer-uyaná ");
INSERT INTO kze_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ísu séna nóin-aina aampa'á símae kwégooiyo súwasarai minká komésarai tirunkó sáwí'a kwéuwasarai ");
INSERT INTO kze_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","moóráwai áwí'a Kéríyópasi kwemá séna ívé-kanaama Yérúsaremu-naopa'a tóyo ésa éiraan-tantaa'a awánaraavo eyááma íya awánaraano áísaa ena súwana ");
INSERT INTO kze_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ísu séna nóra éiraana'iyo súwasarai mindárai sésarai Ísu Násáretivakewaintavairai kwésuye. Áánútun-aai siráiwai Áánútu aúranka'a asirayám-báyáí kwémaena asirayán-áímbá kwésimasimisata ísaraumne. ");
INSERT INTO kze_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","kentáásí anón-kwaasiye mono-káwáá-kwáásíyé Ísumba tuvuwíyanesa Árómáani-kamaani-kwaasigomba áméwana owé sisasá taaira'á tuvúwówana pukáiye. ");
INSERT INTO kze_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","kesáá Ísareri-kwaasiya séta kentáásí kawáánárí'a éna Árómáani-kamaani-kwaasi usáyaaitaniyeya siráundaya tuvúwówana pukáiye. moórá-ainkwara'a kwáyáiye. tuvúwówana pukáimba kaumbo-táwai maisukáiye. ");
INSERT INTO kze_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","évakar-inimbo simásímén-ainta sáátavaiya kwéune. ívé'a aaváyaavimba ááéma utamánkaraapa'a kombá ");
INSERT INTO kze_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kwenáúma íma kwáyáísasa koawánésa koyauwerésa tésa sésa kwíyómpakendarai tuwánáúnasaraiya sésarai pukáimpinkemba usásinkaiye séye tasewatá ");
INSERT INTO kze_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","kentáávínkémbá évakarawai utamánkaraapa'a koawánaawana minínímbó sentembá mirá éna íma kwáyáísasa awánaawe suyaná ");
INSERT INTO kze_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ísu séna sáwí-imayaagwara'a óye. naaóvá'á Áánútun-aai simátímakowai agaimarésa siráan-aintavekai íma ááéma áraire kwéseye. ");
INSERT INTO kze_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Áánútu usásinankaiwaimba áí'a índai'a umánkanaaombanivo ságayan-ayampa'a uméniye mirám-biran-aimba Áánútu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Áánútun-aai aúváívinkemba kwentávésa siráan-ainkona ááimba simátímakaiye. mináímbá Mósesi agaimaréna siráin-ainkwara minkákémbá Áánútun-aai sirón-kwaasi agaimarésa siráan-ainkwara'a simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","simátimuwasarai kuyan-dáókona egwaa'á kuyaná Ísu kógwéyaaitowasarai ");
INSERT INTO kze_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mindárai tátoresarai asiramái sésarai sáwíyanka'a enánivo kesérai méniyone suyaná mindáraiye naaúmpa'a uména ");
INSERT INTO kze_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","toómbá náíyanesa kwéuwana toómbá maisoréna Áánútumpa'a súwi séna topámbai timúwasarai ");
INSERT INTO kze_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","awánésarai Ísumba aúyoyana áúyokuwasarai ");
INSERT INTO kze_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","sésarai aampa'ó túyanamo Áánútun-aai aúváívinkemba simásímísanarai sirunkó anón-aamoi kwéiye sirááiye. ");
INSERT INTO kze_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","mináímbá simásuwesarai usásinesarai koyauwerésarai Yérúsaremu-naopa'a tuyambá Ísuna kwayó-kwáásí sísamaivakemba moórá kumbaimái-kwaasiye ó'on-kwaasiye torupamái máyómba tuwánoyasa ");
INSERT INTO kze_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","miwí sésa árai'a Ísóigo pukáimpinkemba usásinena Sáímoninopa'a paárisana awánériye suwasaráí ");
INSERT INTO kze_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","mindárai aampa'ó kuyan-áímbá simátimesarai sésarai toómbá topámbai símísakai Ísóigomba aúyarauye sirááiye. ");
INSERT INTO kze_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","mináímbá kwésuyana Ísu paáréna miwítí avumpimbá ména aánoumai máéro súwasa ");
INSERT INTO kze_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","inkaisésa kwaántá sewé sésa táátavai uwaná ");
INSERT INTO kze_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ísu séna íma táá'a kaíno. íma kaer-ímáyáá é'a ");
INSERT INTO kze_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","siyáánarumpin-avigwara sísamaivin-avigwara'a awáné'a kentávé'a kwemán-iye seró. kwaántá-kwaasi amagwárá ayáántánkwara'a íma kwáyáivo kembá úwoi kwáyáivo suwáné'a sine'á tátoraaro ");
INSERT INTO kze_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ísu simásuwena ayáánarumpin-avigwara aísamaivin-avigwara'a agaráátinkowasa ");
INSERT INTO kze_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","anón-aamoi kwéesa táátavai ésa anón-imayaa kwéuwana kwaántán-iye sevó séna Ísu naí-yántáá'á makáao tísaa ena súwasa ");
INSERT INTO kze_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","agaimakón-doyaa'a ámúwana ");
INSERT INTO kze_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","maimái túranka'a naráiye. ");
INSERT INTO kze_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","násuwena simátimena séna kesé úwoi máyaundara'a maará sé'a kentávéna Mósesi agaimaréna siráin-ainkwara Áánútun-aai sirón-kwaasi agaimarésa siráan-ainkwara monor-ímá agaimarésa siráan-ainkwara'a árai'a paáriniye simátímakaundawe. ");
INSERT INTO kze_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Áánútun-aai aúváí-kwandaaivinkemba kawe'á umái isánááontavena miwítí imáyáa kawe'á umátínkaraiye. ");
INSERT INTO kze_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Áánútun-aai aúváí-kwandaaivimba agaimaréna séna Áánútumo usásinankaiwaimba áí'a índai'a umánkaiyana puwínímbanivo kaumbo-táwai maisuwéna usásinainasa ");
INSERT INTO kze_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","kwená asirayánkwárá'á mésa aiva'á Yérúsaremu-naopa'a simátimesa minkákémbá ó'on-o'om-baravaken-kwaasi mósimatim-besimatin-esa sésa kentí sáwí-imayaa tuwé'a Áánútumpa'a tíyana kentí sáwí-imayaa maitiyuwáníye agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","awánaan-aimba simátíma'mae'a koró. ");
INSERT INTO kze_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","kesivo asiramái séna tíméndawaimba ai'máráanana keinárawate kumbéniye. Yérúsaremu-naopa'a máyaiyana keinárawapimba kumbéna kwíyómpaken-asirayamba timína'a awánaan-aimba simátíma'mae'a koró Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","simásuwena Ísu tí'maena Yérúsaremuva'a tuwéna Pétáni-naor-egwaa'a koména ayáándei káátarena séna Áánútu kawe'á umátinkaiye ");
INSERT INTO kze_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","kwésimatimuwana Áánútu airówana kwíyómpa'a iyúwasa ");
INSERT INTO kze_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ísuna imáyáa ésa áwí'a mósá marésa tirunkó anón-aamoi kwéuwasa koyauwerésa Yérúsaremu-naopa'a tésa ");
INSERT INTO kze_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","aasiyaasi-táwai anóm-bono'-naumpa'a kwéiyesa Áánútu áwí'a mósá makáawe. Árúku kemá súnda-aimba ánásaiye. ");
INSERT INTO kze_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ááinka'a maramá íma kwáyonka'a Áánútuna imáyáama agaráátínkáiwaima kwenáwí'a Áánútun-aaigoman-iye. Áánútun-aaigoma aasiyaasí ména Áánútuwe ména kwemá Áánútuma póna ");
INSERT INTO kze_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ááinka'a Áánútun-aaigoma Áánútuwe ména ");
INSERT INTO kze_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","amápa-tantaa'a úmarowana Áánútu imáyáama amúwana amápa-tantaa'a minkánáá paárurain-tantaa'a úmakaiye. ");
INSERT INTO kze_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Áánútun-aaigoma kwaásimo maí'mai'o ónááowaina ááimban-iye. miraúmai kwemá kwaásivimba sáma kamátinkena ");
INSERT INTO kze_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","túnín-ayampa'a sáma kaisaná túnín-tantaakoma sámo kain-tántáákómbá íma usáyaaitena uvisínkaiye. ");
INSERT INTO kze_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","moóráwai áwí'a Yóni máyowana Áánútuma ai'maréna ");
INSERT INTO kze_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","sámo kain-áímbá maimaé amápa-kwaasiva'a kwinasá mináímbá isésa sésa árai'a Ísu Káráísitima kwaási sáma kamátinkaiwaiman-iye sígwáe súwana ");
INSERT INTO kze_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yóni kwemá íma sámo kamátinkaina'a póna sámo kamátinkaindawain-aai maimaéna kuráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Áánútun-aaigoma amápa-kwaasivimba sáma kamátinkaiwaiman-iye. Yóni simátímakainka'a Áánútun-aaigoma marapá-kwáásívímbá kumpaáruraiye. ");
INSERT INTO kze_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Áánútun-aaigoma maramá tarórumakena marapá'á kumbáyowasa marapá-kwáásí kwená ááimba íma kawe'á umái awánaraawe. ");
INSERT INTO kze_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","kwenamáápa'a kumbáyowasa kwenamááraa íma paru umánkombanivo ");
INSERT INTO kze_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","évakarawai paru umánkesa kwentávésa sésa árai'a Áánútunopakemba kunkáiye suwaná póna miwíyávéna séna Áánútuna iyámpóíyomban-owe siráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","kwaási kentí imáyáavinkeni'a umái kwématinkaavo Áánútuna iyámpói íma miráumai Áánútuna iyámpóíraani'a kwéowe. Áánútu kwená imáyáavinkemba umátínkáimba pósa Áánútuna iyámpóíraani'a kwéowe. ");
INSERT INTO kze_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Áánútun-aaigoma kwaásima aúkena marapá'á ména kentáávímbá máyowata awánaraumne. paru-yántáákwárá arupí-yantaakwara'a kwempímbá sáwíva'a kwáyon-kwaasi póna ságayankwara-kwaasi úwata awánaraumne. avowámá ááninkomba kímborawaimba póna ságayamba amúwana miságáyánkwárá'á máyowata awánaraumne. ");
INSERT INTO kze_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yónima kwentávéna amápa-kwaasi simátimena séna kembá íma masínkaraanka'a kesínaaembo tíníwaima kweinónkáámbá paárurena ména póna kembá usáyaaitaraiye siráunda-aimba minkwáásíyávé'a siráumne siráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","paru-yántáá'á kwempímbá sáwíva'a kwáyáiwaima póna kentáá kawe'á kwéumasinkavata kwiyé. ");
INSERT INTO kze_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","naaóvá'á Áánútu Mósesimba ai'maréna séna kesí ámáámba simátimiyo séna naaémba Ísu Káráísitimba ai'maréna séna parumó ií-yántáá'á arupí-yantaa'a móruntimiyo siráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","naaóvá'-naovakwara ívékwara'a marará-kwáásí Áánútun-ane'a íma awánaraambanivo kímborawai ááninkoma kwesé ména mimbóráí'a umái ména póna kwéagaraasinkaintaawe. ");
INSERT INTO kze_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yérúsaremu-naopakemba Yútaa-kawaa-kwaasi mono'-máyáí-kwáásínté Árívái-andaraken-kwaasiyonte ti'márówasa Yóninopa'a tésa áísaa esa sésa emá nááwa'ono suwaná ");
INSERT INTO kze_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yóni íma umémpa'a tuwómba avora'á séna Áánútumo usásinankaiwaima Káráísitima íma kemá úne súwasa ");
INSERT INTO kze_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","emá nááwa'o. Íráiyaa naaóvá'á Áánútun-aai simátímakaiwaiya'ono suwaná Yóni séna ímaniye súwasa miwí sésa naaóvá'á Áánútu séna kesáái simátiminiwai Mósesiraan-kwaasi ai'máráanana kumíníye siráimba kwemá ewá'ono suwaná Yóni séna ímaniye súwasa ");
INSERT INTO kze_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","miwí sésa nááwa'ono súnaya simásimenda-aimba si'mákaawaiya kosimátimenaumne suwaná ");
INSERT INTO kze_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yóni simátimena séna Áánútun-aai simátímakowaima áwí'a Áísáya naaóvá'á agaimaréna séna kavóná-marava'a moóráwai ména aayamáírakemba séna Ísóigona aambá kwirankánááomba kwená aambá arupí íyana minámpá'á kwíno siráimba mindá kemá úne Yóni súwasa ");
INSERT INTO kze_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","taáísaa-un-kwaasivinkemba évaka'a ámáán-kawaa-kwaasi miwímá ");
INSERT INTO kze_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yónimba áísaa esa sésa emó sémo Áánútumo usásinankaiwaima íma kemá úne. íma kemá Íráiyaama úne. Áánútun-aai simátiminiwaima Mósesiraan-kwaasi íma kemá úne. emó siráandanivo nóintavai nombá kwévetinkaano suwaná ");
INSERT INTO kze_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yóni séna kemá noné su'mai kwévetinkaunana kentí avumpimbó moóráwaimo máyáimba íma kwéawanaamba póna ");
INSERT INTO kze_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","aáno kesínaaemba tíndawaima kwemó aaimó síndavimba kemá aaimá sendamá uwóví'a ónaumne. kwená mayáímá kwémayaundayave'a pó'a kemá úwoi-kwaasi úne Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yótáni-nonkona menávápá'á Pétáni-naopa'a Yóni nombá kwévetinkowasa áísaa uwaná Yóni mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","simásuwena usá aaváyaaraamba Ísumo túmba Yóni awánéna simátimena séna kentí sáwí-imayaayavesa ísámai sipisípi-araa'o tuvúwówanamo púwísasamo Áánútumbo áméntemba kwétin-kwaasi amápa-kwaasiti sáwí-imayaayavena ísámai maitiyuwáíndayavena póna puwíníye. mindáyavena Áánútu ai'máráísana kúmímba póna puwíníye. ");
INSERT INTO kze_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","kembá íma masínkaraanka'a kesínaaembo tíníwaima kweinónkáámbá ména kembá kwéusayaaitaiyemo siráunda-aimba minkwáásíyávé'a siráumne. ");
INSERT INTO kze_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Áánútumo usásinankaiwain-aai isé'a nááwantavesa seéo siráunda isa'á nombá kwévetinkaunda pósa Ísareri-kwaasi kwembá kawe'á umái awánanaaowe Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Yóni awánaron-aimba simátimena séna Áánútumo usásinankaiwaintave'a sé'a nááwa'iyo siráunda kwíyómpakemba Áánútun-amankoma mááiraamba úmaena kwenane'á kumbáísa'a awáné'a sááka'a makáunda póna Áánútu si'mákaiwaima séna nombá kwévetinkenana kesimankómá moórá-kwaasigo ane'á kumbaína emá awáné se Áánútun-amankoma tirumpimbá anómba umátinkaniwaiman-iye siráin-aimba sááka'a makáundara'a póna mirámó imbá awáné'a simátime'a sé'a kwemá Áánútu ááninkoman-iye Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","simásuwena usá aaváyaaraamba Yóniye kwená kwayó-kwáásíráíyé mésaya ");
INSERT INTO kze_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ísumo kúmba awánésaya uwaná Yóni séna minkwáásí Áánútu ai'mákain-kwaasi póna amápa-kwaasiti sáwí-imayaayavena ísámai puwíníye. kentí sáwí-imayaayavesa ísámai sipisípi-araa'o tuvúwówanamo púwísasamo Áánútumbo áméntemba amápa-kwaasiti sáwí-imayaayavena ísámai puwíníye súwasarai ");
INSERT INTO kze_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","mindárai isésarai Ísun-ánaaemba kwáróyana ");
INSERT INTO kze_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ísu kogwanténa métuwanena séna nóintavaiya'oyo súwasarai miwí tááivinkemba sésarai Araapaiyo náávara kwémaeno kwántámai sésarai anóndakoo náávara kwémaeno suyaná ");
INSERT INTO kze_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ísu séna taawánaakaiyo súwasarai kwesé kuyambá mindáúmpá'á komésaya aaváúmá toraétáápa'a marónka'a komáyáawe. ");
INSERT INTO kze_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yóni siráin-aimba iséna Ísun-ánaaemba kwakón-kwaasi moóráwai áwí'a Éndaru kwemá Sáímoni Pítaa ávákoma póna ");
INSERT INTO kze_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","aiva'á awaaómá avakáá-umai awánéna séna Áánútumo usásinankaiwaima Mésíyaa máyáísa'a awánaraumne sirái. Mésíyaawe-kwi'a kwántámai Kíríki-kwaasi tááivinkemba Káráísitiye sembá mináwíkóná ááimba Áánútumo usásinankaiwaiman-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sáímonimba áí'maena Ísunopa'a tuyaná Ísu awánéna séna Yóni ááninkoma úne. enáwí'a Sáímoniye. moórá-kwi'a Pítaawe simánkaumne Ísu siráiye. miwí tááivinkemba Pítaawemo sembá anón-ontankowe kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","usá aaváyaaraamba Ísu séna Káríri-ayampa'a kónáe séna Vírípimba avakáá-umai áí'maena séna kesínaaemba kwaraaó siráiye. ");
INSERT INTO kze_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","kwemá Pétésáítavakemba Éndarunte Pítaantei naaópaken-kwaasiman-iye. ");
INSERT INTO kze_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Vírípima Nátáníyomba avakáá-éna séna Mósesiye Áánútun-aai simátímakowaiye Áánútun-aai aúváívimba agaimarésamo siráan-kwaasigonta awánaraumne. kwemá Násáreti-naopakemba Yósépi ááninko áwí'a Ísuman-iye súwana ");
INSERT INTO kze_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nátáníyo séna kesáámó súndaya Násáreti-naopakemba íma kawe-kwáásímán-iye kwésune súwana Vírípi séna taawánaao súwasarai ");
INSERT INTO kze_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","kuyambá Ísu Nátáníyomba awánéna séna mendá árai'a Ísarerina'a íma kampar-ímáyáámá kwáyáinda'a kwétiye súwana ");
INSERT INTO kze_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nátáníyo áísaa ena séna nóintavaiya kesí imáyáama suwánéwa seénó súwana Ísu séna Vírípima íma ááyarainka'a ená naaópa'a víki-taaigona ááinka'a máyaana'a kesí imáyáavinkemba awánaraumne súwana ");
INSERT INTO kze_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nátáníyo séna anóndakoo emá Áánútu ááninko e Ísareri-kwaasi kentáásí kawááná'á óne súwana ");
INSERT INTO kze_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ísu séna víki-taigona ááinka'a máyaana'a kesí imáyáavinkemba awánaraumne súndayavai kentáváí se áraire Áánútu ááninko óne kwésene. ená naaópa'a máyaana'a imáyáavinkemba awáraundayavai sénda po mintántáákómbá usáyaaitanin-tantaa'a naaémba awánaniyone. ");
INSERT INTO kze_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","árai'a simátime'a sé'a kwíyómpa'a sokón-tawaai taaínkaa'a ínasa kwíyómpakemba kwaási úranda'a kumpaáruraundawaisopa'a kwíyómpaken-kwayo'narawa'a iré kunke íya'a tuwánanaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ayúnkáraamba Káríri-ayampa'a Kéna-naopa'a torupamái mésa aaraí kwétokwaa-esa Ísumba anówama komáyowasa ");
INSERT INTO kze_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ísunte kwená kwayó-kwáásíyé tááyowasa komáyówana ");
INSERT INTO kze_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ándá-aran-domba namái ánásowana Ísumba anówama Ísuntavena séna ándá-aran-domba ánásaiye súwana ");
INSERT INTO kze_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ísu séna kesí mayáíyáváí íma simásimiyo. amáparawaimo kesí ááimbo suwánanaaon-kanaama íma tiráiye súwana ");
INSERT INTO kze_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ísumba anówama mayáí máyón-kwaasiyavena séna simátimindantemba oró siráiye. ");
INSERT INTO kze_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yútaa-kwaasi tiyáánka'a nombá pékon-amaamba sáwíva'a kwáyomba mindáyavai ava'moraéma anó-sawei-anama kwáyowana ");
INSERT INTO kze_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ísu mayáímó máyón-kwaasiyavena séna misáwéí-ánávímbá nombá atímai ógwitaaro súwasa atímai ógwitamarowana ");
INSERT INTO kze_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ísu séna évaka'-nomba umaé'a toónká'ó kárákwiraiwaimba mááméro súwasa mirá uwaná ");
INSERT INTO kze_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","mindómbá ándá-aran-domba kasuvúwana toónká'ó kárákwirowai néna séna náávaken-dona'iyomo súmba mayáímó máyón-kwaasi Ísun-aai kwéisesa awánaraawe. náávaken-dona'iyo séna aaraimó mayón-kwaasigomba ááyowana túwana séna ");
INSERT INTO kze_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","amápa-kwaasi aiva'á kawer-ándá-árán-dómbá tíméwasa násúwáawasa úwoi-anda-aran-domba kwétimewe. emá íma mirá óndarakemba naaémba kawer-ándá-árán-dómbá kwésimene siráiye. ");
INSERT INTO kze_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Káríri-ayampa'a Kéna-naopa'a Ísu mimbáyáí-áwáámé'á úmba kwená ságayamba agaráátinkowasa kwená kwayó-kwáásí awánésa sésa áraire Áánútunopakemba kunkáiye siráawe. ");
INSERT INTO kze_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","minkákémbá Ísuwe anówawe mináváráwáínondawe kwená kwayó-kwáásíyé miráumai-kwaasi Kápénéamu-naopa'a sáwíyanka'a kumbéraawe. ");
INSERT INTO kze_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","naaóvá'ó Áánútu Yútaa-kwaasi tíyótaasa í-tánón-kánáá tóyo ún-kanaama ákíse kwéunka'a Ísu Yérúsaremu-naopa'a kwéna ");
INSERT INTO kze_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","anóm-bono'-naumpa'a iyúmba mivá'á kwaásiyomba mésa monotávésa purumakambá sipisípima máái-numama kwémeyambaresa mono'-nánkóná óntamba kwémeyanesa máyówana Ísu tuwánéna ");
INSERT INTO kze_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ándánankakemba taámbá tarórumaena mindánei purumakambá sipisípima tusú úmaena mono'-nánkóná óntambo meéyámbárón-kwaasiti taareimá tawísíyuwena ");
INSERT INTO kze_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","máái-numamo meéyámbáron-kwaasiyavena séna maimaé'a kóro. kesivoná naaúmpa'a íma máákéti maré'a maimaé'a kóro Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","kwená kwayó-kwáásí awánésa sésa naaóvá'á Áánútun-aai aúváívimba agaimaréna séna Áánútuwo ená naambá sáwí'a ovó sé'a ávááraumai imáyáa kwéune agaimaréna sirónka'a pósa mináímbá kwená kwayó-kwáásí tááka'a makáawe. ");
INSERT INTO kze_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yútaa-kawaa-kwaasi Ísuntavesa sésa nóin-awaamera inatá awánéta séta Áánútu asirayámbá ámakaintavenayawa anóm-bono'-naumpa'a mirá kwéoneya sénaumno suwaná ");
INSERT INTO kze_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ísu séna maambónó'-námbá tawísíyuwewa'a kaumbo-táwai umásuwanaumne súwasa ");
INSERT INTO kze_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","sésa maambónó'-námbá ayáátááka'a 46 ira'a mayáímá kwémayaan-damba isamá emá se kaumbo-táwai umásuwanaumne kwésene sumbánivo ");
INSERT INTO kze_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","mono'-nántávéna siráimba kwenáúyavena siráiye. ");
INSERT INTO kze_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","naaémba pukáimpinkemba Áánútu Ísumba usásinankainka'a kwená kwayó-kwáásí mináímbá tááka'a makésa sésa Ísu siráin-aimba árair-aimba siráiye sésa Áánútun-aai aúváívinken-aimba árair-aimban-iye siráawe. ");
INSERT INTO kze_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","naaóvá'ó Áánútumo Yútaa-kwaasi tíyótaasa í-tánón-kánáárá'á Yérúsaremuva'a Ísu ó'on-o'om-bayai kawe'-máyáímá mayówasa kwaásiyomba awánésa Ísuntavesa sésa áraire Áánútunopakemba kunkáiye sumbánivo ");
INSERT INTO kze_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ísu kwaási tirumbá tuwánéna séna mináímbá kentávésa íma tirunkakémbá kwésevo tívókari'a kembá umásinkanaaowe séna ");
INSERT INTO kze_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","kwaási íma simámun-aimpinkenban-ivo kwemá kwaási tirumbá tuwánarontavena Ísu mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","moóráwai ámáán-kawaa-kwaasi Yútaa-kwaasiti kawááná'á áwí'a Níkótimasi ");
INSERT INTO kze_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","kwemá moórá-no'waamba Ísunopa'a téna séna anóndakoo Áánútun-aai simásiminiyondayavena embá ai'máráísama tamáyaanata awánaraumne. Áánútumo embó asirayámbó ímo ámakainkakai ó'on-o'on-kawe'-mayai íma kanaán-umai mayáásino súwana ");
INSERT INTO kze_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ísu séna árai'a simáme'a sé'a ímo ókwara'o aúnáraan-umai matinkáiyawaimo ésa Áánútumo kawááipa'a íma ménaaowe súwana ");
INSERT INTO kze_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Níkótimasi séna anón-umáguraavo nóraumai aúnái'a ónááoo séna tinóisai tirumpimbá íma ó'a komáíyasa matinkánááowe súwana ");
INSERT INTO kze_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Ísu séna árai'a simáme'a sé'a kwaásimo matínkáamba mindá kwaásiman-ovo Áánútun-amankomo umátínkáimba mindá Áánútun-amankogwara'a aúnái'a kwéowe. ímo nonkwárá Áánútun-amankogwara'o aúnáraani'o umáímo ménaaoni'a umátínkáawai Áánútumo kawááipa'a íma ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ókwara'a aúnáraan-umai matinkáníyemo súnda-aintavena íma áá'a kaíno. ");
INSERT INTO kze_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","maarán-áímbá imáyáa uwó. úndáoma kwená imáyáavinkemba kwénaaisasa ane'á íma kwéawanesa sésa náávakena náávara kwénaaiyo kwésewe. mirámó intembá Áánútun-amankoma miráráán-umai kwaási kwéumatinkaiye súwana ");
INSERT INTO kze_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Níkótimasi séna nóra ena mirá íníyo súwana ");
INSERT INTO kze_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ísu séna Ísareri-kwaasivimba aaí kwésimatimendawai óndanivo mináímbá íma isááne. ");
INSERT INTO kze_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","árai'a simáme'a sé'a kesáá awáraunda-yantaa ísaraunda-yantaataveta kwésimatimunda isa'á íma kwéisaawe. ");
INSERT INTO kze_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","mirá kwéon-tantaa marapá'ó kwéon-tantaatave'o kwésimamunda íma áraire séndanivo kwíyómpa-tantaatave'o simáméndamo e nóra e áraire síníyono. ");
INSERT INTO kze_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","íma kwíyómpa'a irésa kunkáavo keyáá kwíyómpakemba kunké'a kumpaáruraundawai kwíyómpa-tantaa'a kanaán-umai agaráátinkaumne. ");
INSERT INTO kze_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","naaóvá'á Mósesi óntandei iraankavayaambá tarórumai taaira'ó mósá marówasa puwónáesamo un-kwáásí awánésa íma pukáawe. mirámó uráintemba kembá kwaási úranda'a kumpaáruraundawaimba sínkambai taaira'á mósá maránááomba pósa ");
INSERT INTO kze_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kesááiyavesamo árairemo síyawaimo ésa aúnái'a umái aasiyaasí maí'mai'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Áánútu marapá'á máyáan-kwaasiyavena ávááraumai aruntávéna éna póna kwenáánimba kímborawaimba ai'marówana kunkáimba pósa kwenááiyavesamo áraire síyawaima kwaási máyáawaina ááimba Áánútuna némpa'a íma maí'mai'a ónááovo kwená egwaa'á aúnái'a umái maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","marapá-kwáásí aavimbá maitinkaaó séna Áánútu ááninkomba íma ai'marówana kunkáivo marapá-kwáásí sáwí-imayaavimba máyáawima kuntí'mai kawer-ámpá'á métinkaao séna Áánútu ááninkomba ai'marówana kunkáiye. ");
INSERT INTO kze_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Áánútu ááninkon-aaiyavesa áraire kwésewai íma aaivimbá maitinkánívo ímo árairemo kwésewaima á'a aaivimbá maitínkaraiye. Áánútu kímbora-aaninkon-aaiyavesa árairemo ímo kwésentavena á'a aaivimbá maitínkaraiye. ");
INSERT INTO kze_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","sámo kamátinkaiwaima marapá'á kunkáimbanivo kwaási sáwí'a kwéesa pósa túnín-ayampatavesa imáyáama ésa sámo kamátinkaiwainopa'o ímo tentávéna aaivimbá kwémaitinkaiye. ");
INSERT INTO kze_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","sáwí'o kwéowai sámo kamátinkaiwaintavesa íma kwétinkaisasa kesí mayáímá paárivo sésa íma sámo kamátinkaiwainopa'a tagwémaewe. sáwí'o kwéowai mirá kwéovo ");
INSERT INTO kze_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","arupímo kwéowai sámo kamátinkaiwainopa'a tamáyáamba pósa Áánútu siráini'o kwéomba kwétuwanaawe. ");
INSERT INTO kze_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","minkákémbá Yútiyaa-ayampa'a Ísuwe kwená kwayó-kwáásíyé komésa nombá kwévetinkowana ");
INSERT INTO kze_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","minkánáávímbá Yóni íma ándáva'a máankaronka'a Ínóni-ayampa'a Sérími-naokona egwaa'-nónayumpa'a Yóni ména sáwíva'-nomba kwáyopa'a máyowasa kwaásiyomba tóyo uwaná Yóni nombá kwévetinkowasa ");
INSERT INTO kze_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yónina kwayó-kwáásíyónté moórá Yútaa-kwaasigoe mésa mono'-nómbó pétinkon-aintavesa kwesimá kwesiman-esa ");
INSERT INTO kze_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yónina kwayó-kwáásíyómbá kwenópa'a tasimámesa sésa anóndakoo Yóntáni-nonkona menávápá'á esé méraiwaimba kwenáwí'a mósá makáawaima kwemá nombá kwévetinkaisasa sáwíva-kwaasi kwétoyo owe suwaná ");
INSERT INTO kze_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yóni séna Áánútumo tímísasamo ombá mindá miwínéímán-iye. ");
INSERT INTO kze_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","kemó siráunda Áánútumo usásinankaiwaima íma kemá úmpo si'marówa'a kwená aiva'á tiráumne siráunda-aimba ísaraawe. ");
INSERT INTO kze_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","maarán-áímbá imáyáa oró. aúná-ininkomo awaikónópa'o tisanamá awaikó amááraanarawa'o aamoimó onten-umái Ísunopa'a tewa'á aamoí kwéune. ");
INSERT INTO kze_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","kwemá anón-kwaasi imbá póna kwenáwí'a iyínívo kemá kíto-kwaasima únda póna kesúwí'a kumíníye Yóni siráiye. ");
INSERT INTO kze_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","kwíyómpakewaima amáparawai usáyaaitaraiye. maankákén-kwáásí marapá-kwáásí pósa marapá'ó kwéon-tantaatavesa kwésevo kwíyómpaken-kwaasi usáyaaitarain-kwaasi póna ");
INSERT INTO kze_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","awánarain-tantaa ísarain-tantaatavena kwésisasa íma kwéisaambanivo ");
INSERT INTO kze_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","kwenááiyavesa áraire kwésewai sésa Áánútu árair-ainkona ááimban-iye sisasá tuwánésa sésa Áánútu árair-ainkona ááimban-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Áánútu ai'mákaiwaimba kwenamankómbá ámatukaimba póna Áánútun-aai kwésisasa mináíntávésamo árairemo kwésewai sésa Áánútu árair-ainkona ááimban-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Áánútu avowámá éna ááninkomba arumbá aména séna amápa-tantaa'a kawááumai taviyiyó siráiye. ");
INSERT INTO kze_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ááninkon-aaiyavesamo árairemo sésamo kwesé aráápamai maíyawai aúnái'a umái maí'mai'a ónááovo kwenááimo ímo ísámaimo kawe'ó kwéiyawai íma aúnái'a umái méwana Áánútumo áwáá'o tíyímba miwísé aasiyaasí kwaíkwai'a isasá kwémaewe. ");
INSERT INTO kze_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Yóni nombó pétinkarain-kwaasi Ísumo pétinkaraimba kóyaaitamai-kwaasi pétinkaraiye. ánivo Ísuma íma pétinkaraivo kwená kwayó-kwáásí pétinkaraawe. Yónimo kwévetinkain-kwaasi Ísumo kwévetinkaimba kóyaaitamai-kwaasi kwévetinkain-aimba ámáán-kawaa-kwaasimo ísón-aimba Ísu iséna Yútiyaa-ayampa'a tuwéna moórágwara'a Káríri-ayampa'a kónáe séna ");
INSERT INTO kze_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sámériyaa-ampa'a kónaumne séna ");
INSERT INTO kze_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","kúmba Sámériyaa-ayampa'a Sáíkaa-naopa'a naaóvá'ó Yákópomo ááninko Yósépimbo ámakom-barama egwaa'á kwáyon-daopa'a kúmba ");
INSERT INTO kze_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yákópo nombá uwíníyena u'makóm-bai'a kwáyowana aampa'á kwéguwana Ísumba ávón-kówana mimbáíká'á kwáyá'wái komáyowasa ");
INSERT INTO kze_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","kwená kwayó-kwáásí toómbá meéyán-onae sésa naaópa'a kuwaná Sámériyaa-ininko nombá uwíníyena túwana Ísu séna nombá usimiyó súwana ");
INSERT INTO kze_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","minínínkó séna emá Yútaa-kwaasi ómpo kemá Sámériyaa-inimba úmpo íma nombá usimiyó siyó siráiye. Yútaa-kwaasiye Sámériyaa-kwaasiye íma moórá-anavinkemba kwénaantavena íma nombá usimiyó siyó súwana ");
INSERT INTO kze_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ísu séna Áánútumo kanaán-umaimo amínín-tantaa'a íma awánaraane. nombá usimiyómó súnda-kwaasigona ááimba íma suwánáánda-kwaasi úne. kesí ááimba suwánáándawairaankasi kwántámai se aasiyaasí maí'mai'a ónááon-domba simiyó séna'a amúsino súwana ");
INSERT INTO kze_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","minínínkó séna maandómbá avéúmpá'ó kunkwáyáimba náán-anavina maí'mai'o ónááon-domba uwíníyono. ");
INSERT INTO kze_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","kentáá síkwá'náoma Yákópoma maandóm-báí'á u'maréna kwená sipisípiye kwená akúnté tímakaimba pósa maandómbá kwénaawe. kemó súnda emá timíníyonda-nonkoma Yákópo tímakain-donkomba íma usáyaaitaniye kwésune súwana ");
INSERT INTO kze_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ísu séna maandómbó kwénaiyawaimo éna ókwara'a nontávéna tinkánívo ");
INSERT INTO kze_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kemó tíménda-nombo náíyawaimo éna íma ókwara'a nontávéna tinkáníye. kemó tíménda-nombo náíyawaimo éna tirumpimbá nonayumpinkémbó usausa intenkáámbá ínasa pósa aúnái'a umái maí'mai'a ónááowe súwana ");
INSERT INTO kze_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","minínínkó séna emó sénda-nomba símína'a naananá nontávéna íma sinkáína'a íma maampínkémbá tauwónaumne súwana ");
INSERT INTO kze_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ísu séna enawaikómbá koááyamai áí'mae tiyó súwana ");
INSERT INTO kze_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","séna kesuwairíyaaimba úne súwana Ísu séna emá árai'a séndamanivo ");
INSERT INTO kze_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","éva'aasei-kwamba mairé miwísé maémaenda isamá ívé'o minkwáásígó emó máyaanda íma enawai'á isamá po árair-aimba simásimene súwana ");
INSERT INTO kze_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","minínínkó séna kemó imáyáamo únda Áánútun-aai simátimendana'a óne. ");
INSERT INTO kze_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sámériyaa-kwaasi kentáá síkwá'náma sésa maanómáká'á Áánútuna imáyáa mósá máráaro siráawa'a keinárawa'a Yútaa-kwaasi sé'a Yérúsaremu-naopa'a Áánútuna imáyáa mósá máráaro sewé súwana ");
INSERT INTO kze_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ísu séna kemó sendamá áraire siyó. moórá-kanaamo tínímba maanómákákwárá Yérúsaremu-naopakwarare su'mainivo amápa'-mapakwara'a kesivoná imáyáa mósá maránááowe. ");
INSERT INTO kze_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","keinárawa'a Sámériyaa-kwaasi kwená imáyáa máráambanivo kwená ááimba íma awánare'a owe. Yútaa-kwaasiya kwená imáyáa mósá maréta kwená ááinta awánaraumne. Áánútu séna moóráwai sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkanae síníwai Yútaa-kwaasivinkemba paáriniye siráiye. ");
INSERT INTO kze_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","kesivo séna kesí imáyáama mósá maráíyamba íma tóikakemba é'a árai'a tirunkakémbá kesí imáyáa mósá máráaro siráimba miráumai moórá-kanaama kwétisasamo árai'o kesivoná imáyáamo mósá kwémaraiyawaima tirunkakémbá arupí umái kesivoná imáyáama mósá maránááowe. ");
INSERT INTO kze_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Áánútumba áúma íma kwáyáísana amankómá máyáísasa pósa íma túrandei ane'á kwéawanaavo miráráán-umai Áánútuna imáyáamo mósá máráambo ombá kwenamankó túwa'naa isasá tirunkakémbá kwená imáyáa mósá máráaro súwana ");
INSERT INTO kze_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","minínínkó séna Áánútumo usásinankaiwaima Káráísitiye sewáí kumíníye. kumíndara'a amápa-tantaatavena simátiminiye sewa'á ísaraumne súwana ");
INSERT INTO kze_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ísu séna mináímbó séndawaima maandá kemá úne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ísu mináímbá súwasa kwená kwayó-kwáásí koyauwerésa Ísumo Sámériyaa-ininkontavena súmba Yútaa-kwaasiti namuro-ínínkóntávéna kwésuwana póna táá'a kówasa tirumpin-ímáyáámá ésa minínínkóntávéna nóintavaiya kwéankaisana íyó-imayaa ésa Ísuntavesa nóra séna minínínkóe kwésiyo-imayaa ésa íma taáísaa uwaná ");
INSERT INTO kze_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","minínínkómá kwená sawei-ánámá tuwéna naaópa'a kwéna simátimena séna ");
INSERT INTO kze_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","amápa'a uráunda-yantaa'a paárurain-kwaasi máyáiye. Áánútumo usásinankaiwaiya'iya taawánaaro súwasa ");
INSERT INTO kze_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","naaópa'a tuwésa Ísunopa'a tumbá ");
INSERT INTO kze_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ísuna kwayó-kwáásí Ísuntavesa sésa anóndakoo toómbá naaó amatáárá'á suwaná ");
INSERT INTO kze_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ísu séna kemá íma awánaan-tomba makáumne súwasa ");
INSERT INTO kze_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","kwená kwayó-kwáásí keáímbá sésa nááwa toómbá maimaéna máámakaiyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ísu séna toóntávénamo tááimo kwétinkaintemba si'mákaiwain-aai isé'a kwená mayáímá maimaé'a kwégwe'a ánásanaundayavai kwésinkaiye. ");
INSERT INTO kze_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","kígauva'a kwáyáin-tontave'a éíyain-kwiyomba ánásainana ávuma káínata áká'mai torupánaumne kwésevo kemá sé'a awánaaaro. ívé'a maankánáámá toómbó ávumo kaintembá miráráán-umai kwaásiyomba tí'mai Áánútunopa'a kwiyónááowe. ");
INSERT INTO kze_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","kwaásiyombo tí'mai Áánútunopa'a kwitinkáíyan-kwaasimo ésa miwí kawe'-méyámbá mayáíyasa Áánútunopa'a tíyan-kwaasi aúnái'a umái maí'mai'a ónááowe kwésune. évakarawai kígau úmaraiyasa ó'owima akaránááowe kwésewe. miráumai kígau íyawaigwara akaráíyawaigwara'o ésarai aamoí ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ó'owima kígau úmakaamba isa'á kemá ti'máráúna'a ó'owiti mayáívínkén-tómbá kwéakaraawe Ísu kwántámai-aimba simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ánivo minínínkó séna amápa'a uráunda-yantaa'a paáruraiye siráin-aimba isésa pósa Sámériyaa-kwaasi mindáópaken-kwaasi Ísuntavesa sésa árai'a Áánútumo usásinankaiwaiman-iye sésa ");
INSERT INTO kze_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ísunopa'a tésa sésa kentáásí naaópa'a tamaiyó suwaná Ísu kae-táwai koména ");
INSERT INTO kze_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","aaí simátimuwasa isésa sáwíva-kwaasigwara'a sésa árai'a sáwí'o umáímo máyaundavinkenta kawer-ámpátá mésinkaniwaiman-iye sésa ");
INSERT INTO kze_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","minínínkómbá simámesa sésa íma enááiye su'maiyavetaanivo kwenáái ísaraundayaveta séta marapá-kwáásí sáwí'o umáímo máyaundavinkemba kawer-ámpátá mésinkaniwaiman-iye siráawe. ");
INSERT INTO kze_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ísu kae'-nó'wáámbá kwaéna mindáópa'a tuwéna Káríri-ayampa'a kónáe séna kwéna ");
INSERT INTO kze_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","séna Áánútun-aai simátímíwain-awi'a kwenamááraa íma mósá máráavo á'on-daopaken-kwaasi kwenáwí'a mósá máráawe súwasa ");
INSERT INTO kze_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","miráumai Káríri-ayampa'a kúwasa mináyámpákén-kwáásí aamoí umánkaraawe. ááéma tíyótaasa í-tánón-kánáárá'á miwí Yérúsaremu-naopa'a komésa Ísuna mayáímó mairáimba awánaraamba pósa aamoí umánkaraawe. ");
INSERT INTO kze_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","aamoí umánkówana Ísu Káríri-ayampa'a kwénaaena Kéna-naopa'a non-úranko ándá-aran-dombo kasúkáin-daopa'a kúmba kámááni-kwaasi Kápénéamu-naopaken-kwaasigo ááninkomba áí'a kwéuwana ");
INSERT INTO kze_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ísu Yútiyaa-ayampakemba Káríri-ayampa'a tiráin-aimba iséna Ísunopa'a téna séna kesááninko puwíndayavena kwéisa'a úmpo kesí naaópa'a kuré koasóvamankaniyono súwana ");
INSERT INTO kze_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ísu séna ímo ó'om-bayai-awaame'o awáné'o é'a íma kesááiyave'a áraire sénááowe súwana ");
INSERT INTO kze_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","anóndakoo kesáánimba puwíndayavena kwéimba avekáán-umai tiyó súwana ");
INSERT INTO kze_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ísu séna enáánimba asóvagwivo kwaaó súwana Ísun-aaiyavena áraire séna kúmba ");
INSERT INTO kze_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","aampa'á kúmba kwená mayáí-kwáásí tésa sésa enáánimba áí'a éránkaraiye suwaná ");
INSERT INTO kze_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tísaa ena séna kesáánimba nósa-tawaiya áí'a éránkaraiyo súwasa sésa tíndauma kwáyá'wái kokotámba éránkaraiye suwaná ");
INSERT INTO kze_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","avowámá imáyáa éna séna mitáwai enáánimba asóvagwiyemo siráimba árai'a siráiye súmba pósa kwená akúmpákén-kwáásí amápa'a Ísun-aaiyavesa áraire siráawe. ");
INSERT INTO kze_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yútiyaa-ayampakemba Káríri-ayampa'a komáyomba moóráma kawe'-máyáí-áwáámé'á uréna minká'á miníyámpóígómbá asóvamankowasa kwená akúmbá áraire siráawe. ");
INSERT INTO kze_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","aáno Yútaa-kwaasi monotávésa tanómba kaumakónka'a Ísu Yérúsaremu-naopa'a kurái. ");
INSERT INTO kze_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yérúsaremu-naokona óntan-kuriva'a ontamá kwáyomba áwí'a sipisípigona ontamá miwáná egwaa'á nonkwaaúmbá áwí'a Pétéséta-nonkwaaumba kwáyowana ");
INSERT INTO kze_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","mindónkón-awampa'a kwááyu-namba éva'aasei-namba kwáyowasa mindáúmpátá tí'a ún-kwaasiyomba évaka'a túgavitan-kwaasiyonte tíyayaamba kararón-kwaasiyonte mésa nonkómó píví'namaemo kúmba amu'marésa máyówana ");
INSERT INTO kze_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","moórá-mora-tawai kwíyómpakewaima nompímbá kumúwana nonkómá píví'namae kúwana aiva'á nompímbá kumúwaimba áí'a éránkaraiye. ");
INSERT INTO kze_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","tí'o ún-kwaasiyompimba moóráwai ména ayáátááka'a 38 ira'a áí'a kwéun-kwaasi máyowana ");
INSERT INTO kze_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ísu awánéna ayáátááka'a áí'a kwéiye-imayaama éna áísaa ena séna embá asóvaiyavai kwéankaiyo súwana ");
INSERT INTO kze_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","séna nonkómá píví'namae kwíndara'a sí'maimo nompímbó sinkáníwaima íma máyáiye. kemá kumónáe'a úndanivo moóráwai kembá kumáyaaitena nompímbá aiva'á kúmísana kesí'a úwoi kwáyáiye súwana ");
INSERT INTO kze_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ísu séna usásinaao. ená tuvai'á maimaé kwaaó súwana ");
INSERT INTO kze_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","avekáán-umai áí'a érankowana kwená tuvai'á maimaéna kuráiye. Yútaa-kwaasi monor-áímbá kwéison-kanaara'a mirá úwasa ");
INSERT INTO kze_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yútaa-kawaa-kwaasi asóvamankon-kwaasiyavesa sésa ívé'a agándaan-kanaama po ená tuvai'á maimaé kwégonda aambá áúmbakaawe suwaná ");
INSERT INTO kze_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","séna asóvamasinkaraiwaima séna ená tuvai'á maimaé kwaaó siráiye súwasa ");
INSERT INTO kze_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","miwí áísaa esa sésa ená tuvai'á maimaé kwaaómó siráiwai nááwa'iyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","sáwíva-kwaasivimba Ísuma áúyokuwana póna asóvamankarowai séna áwí'a íma isáúnda-kwaasiman-iye siráiye. ");
INSERT INTO kze_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","simásuwena aáno anóm-bono'-naumpa'a iyúmba Ísuma avakáá-umai awánéna séna áí'a éránkáimba po sáwíyamba sínkáivo se sáwí-imayaa ivátuwaao súwana ");
INSERT INTO kze_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","iséna Yútaa-kawaa-kwaasi kosimátimena séna asóvamasinkaraiwaima Ísuman-iye súwasa ");
INSERT INTO kze_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yútaa-kwaasi monor-áímbá kwéison-kanaara'a Ísuma asóvamankarontavesa Yútaa-kawaa-kwaasi Ísumba sáwí'a umánkámae íyúwana ");
INSERT INTO kze_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ísu séna kesivo aasiyaasi-táwai mayáímá kwémayaimba pó'a miráráán-umai mayáímá mayánaumne súwasa ");
INSERT INTO kze_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","agándon-kanaara'a asóvamankarontavaigwara Áánútuma kesivomán-iye siróntavaigwara'a pósa Yútaa-kawaa-kwaasi sésa tuvuwónáe síma sima'a umbá Áánútuma kesivomán-iye sirónten-umai Áánútuwe kesé mimbóráí'a umái máyauye siráimba pósa Yútaa-kawaa-kwaasi sésa tuvuwónáe siráawe. ");
INSERT INTO kze_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","suwaná Ísu simátimena séna árai'a simátime'a sé'a ááninkoma pó'a íma kesí imáyáavinkemba únda kesivomó imbá awáné'a mirá kwéune. kesivomó intembá ááninko kwéune. ");
INSERT INTO kze_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","kesivo ááninkomba arumbá siména amápa-tantaa'o kwéimba kwéagaraasinkaiye. usáyaaitanim-bayai agaráásinkaina'a mimbáyáí máyáana'a táátavai ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","kesivomá pukáampinkembo usásintinkaintemba ááninko kesí imáyáavinkemba usásintinkanae'a kwéune. ");
INSERT INTO kze_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","kesivo séna íma aaivimbá maitinkánaumpo aaivimbó maitinkáním-bayai kesááninkomba ámakaumne siráiye. ");
INSERT INTO kze_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aaivimbó maitínkáanda-mayai símakaimba pósa kesivo áwí'o mósá máráantemba ááninko súwí'a mósá maránááowe. kesúwí'o ímo mósá maráíyawaimo ésa kesivomá si'mákaiwai áwí'a íma mósá maránááowe. ");
INSERT INTO kze_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","árai'a simátime'a sé'a kesááimo isésamo árai'a ai'mákaiwaima Áánútuma iyémó kwésiyawaima á'a ááimba ásámai aúnái'a umái maí'mai'a kwéowe. kwaási máyáawaina ááimba Áánútuna némpa'a kwaémáyaimba Áánútuna egwaa'á tamáyáamba pó'a íma aaivimbá maitinkánaumne. ");
INSERT INTO kze_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","árai'a simátime'a sé'a moórá-kanaa kwétinasa pukáiyan-kwaasi Áánútu ááninko-saai isánááowe. isáíyawaima usásinesa maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","kesivomá kwaási máyáawaina ááimban-iye. asirayámbá siména séna mirámó úndantemba kwaási máyáawaina ááimba óne siráiye. ");
INSERT INTO kze_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","kemá kwíyómpakemba kwaási úranda'a kumpaáruraundawai únana póna kesivo kentávéna séna aaivimbó maitinkáníyonda-mayai amúne siráiye. ");
INSERT INTO kze_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","mináíntávéna íma táá'a kaíno. moórá-kanaamo tínímba utamátínkaren-kwaasi amápa'a kesáái isésa ");
INSERT INTO kze_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","utamátínkarepakemba usásinanaaowe. kawe'ó uréwaimo usásinesa aúnái'a umái maí'mai'a ónááowe. sáwí'o uréwaimo usásinaiya'a aaivimbá maitinkánaumne. mináíntávéna íma táá'a kaíno Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ísu simásuwena séna íma kesí imáyáavinkemba úndanivo si'mákaiwaima simásímakaintemba mirá kwéune. íma kesí imáyáavinkemba úndayave'a arupí umái aaivimbá maitinkánaumne. kesivo simásímakainten-umai aaivimbá maitinkánaumne. ");
INSERT INTO kze_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","keyáámo kesáváímó súndarakai kamparé sesinó. ");
INSERT INTO kze_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","moóráwaigwara'o kentávénamo kwésimba árai'a kwésiye. ");
INSERT INTO kze_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","keinárawa'a évakarawai ti'márówasa Yóni nombá pétinkaiwaimba koáísaa uwaná Yóni kentávéna séna árai-kwaasiman-iye. kosimátíméro siráiye. ");
INSERT INTO kze_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","kesí ááimbo sénááontavai íma anón-imayaa úndanivo Yóni kentáváí siráin-aintavai áraire síya'a sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkanae-imayaa kwée'a mináímbá kwésimatimune. ");
INSERT INTO kze_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","oómbó aampa'ó kúra'mae konten-umái Yóni kentí aampa'ó kúratinkowa'a sáwíyanka'a aamoí uráawe. ");
INSERT INTO kze_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","moórá-yantaakoma Yónima kentávéna siráin-ainkomba usáyaaitaraiye. kesivomó simásímakaim-bayaima kwémayaunana mimbáyáígómá kesí ááimba kwévaariye. kesivomó siménamo si'mákaim-bayai kwémayaunasa kesí ááimba kwéawanaawe. mintántáákómá Yónima kentávéna siráin-ainkomba usáyaaitaraiye. ");
INSERT INTO kze_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","kesivo si'mákaiwaima kwegwárá'á kentávéna simbánivo kwenáái ísámai íma kawe'á é'a kwenane'á íma awánaraawe. ");
INSERT INTO kze_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","si'marówa'o kunkáundayave'a íma áraire kwésemba póna Áánútun-aai íma tirumpimbá kwáyáiye. ");
INSERT INTO kze_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","keinárawa'a sé'a aúnái'a umái maí'mai'a ónaumne sé'a Áánútun-aai aúváívimba awána-awana kwéowe. mináúváívímbá kesí ááimba agaimárówa'anivo íma kawe'á umái ísaraawe. ");
INSERT INTO kze_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","kawe'ó umáímo isé'o kesópa'o tékaankasi aúnái'a umái maí'mai'a osino. ");
INSERT INTO kze_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","kwaási kesúwí'a anómba umásinkanaaowe-imayaa íma kwéune. ");
INSERT INTO kze_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Áánútumbo ímo tirumbó áménka'a kwétuwanaumne. ");
INSERT INTO kze_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","kesivomá simásímakaintave'a kunkáundanivo íma kawe'á umásínkaraawe. ánivo moóráwaimbo kesivomó ímo simámakaindawaimo tína'o é'a kawe'á umánkanaaowe. ");
INSERT INTO kze_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","keinárawa'a sé'a kwaási kentáá súwí'a anómba umásinkanaaowe sé'a pó'a kesáái íma áraire kwésewe. Áánútuma kentáá súwí'a anómba umásinkaniye sékaankasi kentávé'a áraire sesinó. ");
INSERT INTO kze_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","kesivo aúranka'a íma aaivimbá maitinkánaunda póna Mósesi naaóvá'á ámáán-aimba agaimakáiwai aaivimbá maitinkáníye. Mósesi kwésuwa'naa iyémó sewáímó éna kwemá aaivimbá maitinkáníye. ");
INSERT INTO kze_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mósesi kesáái agaimarómba pó'a Mósesin-aaiyave'o árairemo kwésekaai kesááiyave'a áraire sesinó. ");
INSERT INTO kze_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mósesimo agaimakáin-aintave'a íma áraire kwésemba pó'a kesááiyave'a íma áraire kwésewe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","naaóvá'á Áánútu Yútaa-kwaasi tíyótaasa í-tánón-kánáá sáwíyanka'a tíníye kwéuwana Káríri-kwaaunkona menávápá'á Ísuma nompí-sípívímbá kwéna minkwáúnkóná moórá-awi'a Táípíriyasi nompá'á kúmba tí'o ún-kwaasiyomba asóvamatinkarowasa awánaresa pósa kwenánaaemba kwárówasa Ísuwe kwená kwayó-kwáásíyé nompí-sípívínkémbá marapá'á ásávesa omápa'a umáyówasa ");
INSERT INTO kze_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","sáwíva-kwaasi Ísunopa'a kwéiyuwana tuwánéna imáyáama éna séna naaémba mirá ónaumpo aiva'á Vírípimba áísaa umai isánáe séna áísaa ena séna náávakena toómbá meéyámba'maiya tíménara nánááoo súwana ");
INSERT INTO kze_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Vírípima séna sáwívar-ontankaken-tomba 200 kinaaraken-tomba meéyámba'maiya timúnasaya naasinó súwana ");
INSERT INTO kze_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","moórá-kwayo-kwaasi Sáímoni Pítaa áváko áwí'a Éndaru ");
INSERT INTO kze_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","kwemá séna moórá-iyampoigo éva'aasei-tonkwara kae'-nóyáákwárá'á makáimbanivo sáwíva-kwaasi máyáawe súwana ");
INSERT INTO kze_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ísu kwená kwayó-kwáásíyávéna séna mara'á máéro simátíméro súwasa simátímúwasa mara'á máúmba minkwáásívínkémbá sáwíva-kwaaima 5,000 kwaaima máyówana ");
INSERT INTO kze_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ísu mintómbá maisokéna Áánútuntavena súwi simásuwena toómbá topán-topan-umai kwená kwayó-kwáásírá'á timúwasa miwímá tímúwana toómbó nontenkáán-umai noyáá'a miráumai nowaná tímú'a vówasa miwítí imáyáaomo úni'a uwaná ");
INSERT INTO kze_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","kwená kwayó-kwáásíyávéna séna mintón-ayai íma úwoiva'a tuwé'a máyáaro súwasa ");
INSERT INTO kze_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","éva'aasei-tompinkemba nésamo túwón-ayaivinkemba sísamaivakemba kae'á kumbaimái-unampimba áítumai ógwitowasa ");
INSERT INTO kze_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ísumo úmba awánésa sésa Áánútun-aai simátímíwaima íya awánáúnda-awaame'a isatá awánáúmne sésa kwéamu'maraundawaiman-iye sésa ");
INSERT INTO kze_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","kentáásí kawááíta íníyemo sumbá Ísu miwí tirumpimbó sun-áímbá iséna íma mirá ónaunasa sewé séna tiyuwéna omápa'a iráiye. ");
INSERT INTO kze_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ísu omápa'a umáyowasa enónka'a kwená kwayó-kwáásí nonkwaúnkón-awampa'a kumésa ");
INSERT INTO kze_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kápénéamuva'a kónáe sésa nompí-sípívímbá usámaaisesa kuwaná Ísuma íma usauwerówana no'wáámba aúkúwana ");
INSERT INTO kze_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","anón-undaoma kwétena nonkómá tuvántááva kwéuwasa ");
INSERT INTO kze_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","tamayó'nei nombá tuwíntámaesa ayáátááka'a kuwaná Ísu non-avóvomayaapa'a kwénaaena nompí-sípígóná egwaa'á túwasa awánésa táátavesa kwéuwana ");
INSERT INTO kze_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ísu séna kemá úmpo táá'a kaivó aáno máéro súwasa ");
INSERT INTO kze_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","aamoí ésa sésa nompí-sípívímbá usámaaisaao suwaná avekáán-úwana nompí-sípígó non-awámpá'á kúpa'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","aaváyaavimba menávápá'á komáyón-kwaasi sésa tíndauma kímbora-nompi-sipima kwáyáísana Ísuma íma mimpímbá kwisasá kwená kwayó-kwáásí miwíyé su'mai kuráavo Ísuma náávara máyáiyo siráawe. ");
INSERT INTO kze_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","évaka-kwaasi nompí-sípívímbá Táípíriyasivakemba kwétoyo-esa tíndauraamba Ísu Áánútuntavena súwi súwasa kwaásiyomba toómbá néiron-ayampa'a tésa ");
INSERT INTO kze_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ísuwe kwená kwayó-kwáásíyé íma máyóntavesa tivakáá ónáe sésa mindómpí-sípívímbá usámaaisesa Kápénéamuva'a kuráawe. ");
INSERT INTO kze_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kápénéamu-ayampa'a kumbá Ísumba awánésa sésa kesí anóndakoo nósa-tawai maavá'á tiráano suwaná ");
INSERT INTO kze_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ísu séna maísáaro íma kawer-áwáámé'á agaráátínkaraundayave'a kwésivakaa-ovo toómbó naráantave'a kwésivakaa-owe. ");
INSERT INTO kze_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","toómbó ímo kwaíkwai'o índa-tontave'o é'a íma mayáímá maé'a kwaási maí'mai'o ónááon-tontave'o é'a mayáímá máyáaro. mintómbó timénaunda kemá kwaási úranda'a kumpaáruraundawai mintómbá timénaumne. Áánútu kesivomá kentávéna séna aamoí kwéumankaumne. kesí mayáímá mayaaó simbá pó'a mintómbá timénaumne súwasa ");
INSERT INTO kze_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","áísaa esa sésa nóraumaiya Áánútuna mayáímá mayánaumno suwaná ");
INSERT INTO kze_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ísu séna kentávé'o sé'o árai'a Áánútuma ai'mákaisana kunkáiwai iyémó sembá mindá Áánútuna mayáímá maé'a sewé súwasa ");
INSERT INTO kze_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","nóra awaamera'i. ímo awánáúnda-awaame'o inatáámó éta awánétaamo éta séta árai'a Áánútuma embá ai'máráísama kunkáandawaima óne. nóim-bayai-awaamera íníyono sésa ");
INSERT INTO kze_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","kentáá síkwá'náma kavóná-marava'a mésa kwíyómpaken-tomba áwí'a máána-tomba némáembanivo emó uráandawaimo éna íma mindá usáyaaitaraiye. naaóvá'á Áánútun-aai aúváívimba agaimaréna séna kwíyómpaken-tomba timúwasa naráawe agaimaréna siráiye suwaná ");
INSERT INTO kze_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ísu séna maísáaro Mósesimo tímakon-tomba íma kwíyómpaken-tomban-iye. kesivomá kwíyómpaken-tomba kawe-tómbá kwétimiye. ");
INSERT INTO kze_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","kwíyómpakembo marapá'ó kunkáiwaima kwemá Áánútuma kwétimin-tomban-iye. kwentávé'a pó'a maí'mai'a ónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","sésa sénda-tomba aasiyaasi-táwai simiyó suwaná ");
INSERT INTO kze_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ísu séna kemá maí'mai'a ónááon-tomba úne. kesópa'a kwétiyawai íma tááima kwétinkaiye. kenká'á aráápamai kwémaiyawai íma nontávéna kwétinkaiye. ");
INSERT INTO kze_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","á'a simátime'a sé'a kesí mayáí-áwáámé'á awánaambanivo kesááiyave'a íma áraire sésa kenká'á íma aráápamai kwémaewe. ");
INSERT INTO kze_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ánivo kesivomó kwésimin-kwaasimo é'a kesópa'a ténááowe. kesópa'o tíyan-kwaasiyave'o é'a íma kóro sénaumne. ");
INSERT INTO kze_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kesí imáyáa kwaránaundayave'a kwíyómpakemba íma kumbáyaumpo si'mákaiwaina imáyáa kwaránaundayave'a kumbáyaumne. ");
INSERT INTO kze_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","si'mákaiwaima simásimena séna amúnda-kwaasi sáwí-amba kwáráavo se kawááuwo. naaén-kanaama puwíyampinkemba usásintinkaano. ");
INSERT INTO kze_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","kesivomá simásimena séna kesááninkoo embá awánésa sésa Áánútu ááninkoman-iye síyawaima aúnái'a umái maí'mai'a ónááowe siráiye. naaén-kanaama puwíyampinkemba usásintinkanaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","kemá kwíyómpaken-tomba úne Ísu súntavesa Yútaa-anon-kwaasi tirunkó sáwí'a kwéuwasa iséise kwéesa ");
INSERT INTO kze_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","sésa kwemá Ísuma Yósépi ááninkoman-iye. anóvowi átaamo tuwánáúndayaanivo nóra sénawa kwíyómpakemba kunkáumne kwésiyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ísu simátimena séna íma mirá iséise oró séna ");
INSERT INTO kze_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","kesópa'a íma úwoima ténááovo kesivo kembá si'mákaiwaima tááyaina'a kesópa'a tíya'a naaén-kanaama puwíyampinkemba usásintinkanaumne. ");
INSERT INTO kze_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","mindáyavai naaóvá'á Áánútun-aai simátímakowai agaimarésa sésa Áánútu amápa-kwaasi simái agaráátinkaniye siráawe. kesivon-áái ísámai kawe'á íyawai kesópa'a ténááowe. ");
INSERT INTO kze_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","kesivombá íma awánaraavo kemá Áánútunopakemba kunkáundawai keyááma kesivombá awánaraumpo kesivon-áái ísámai kawe'á íyawai kesópa'a ténááowe. ");
INSERT INTO kze_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","árai'a simátime'a sé'a kesááiyavesa áraire sésa kenká'á aráápamai kwémaewai aúnái'a umái maí'mai'a kwéomba ááimba kwéasaawe. ");
INSERT INTO kze_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","kemá maí'mai'a ónááon-tomba úne. ");
INSERT INTO kze_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","kentíkwá'náma kavóná-marava'a mésa máána-tomba neémesa úwoi putáráawe. ");
INSERT INTO kze_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ánivo kwíyómpaken-tomba mirán-tómbá náíyawaima úwoi maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","kemá kwíyómpaken-tomba maí'mai'a ónááon-tomba úne. mintómbó nésamo ésa maí'mai'a ónááowe. kesúma timúna'a naantávé'a pó'a maí'mai'a ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ísu súwasa Yútaa-anon-kwaasi tirunkó sáwí'a kwéuwasa iséise ésa sésa nóra éna mindá'á kwenáúma simínata nánaumno suwaná ");
INSERT INTO kze_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ísu simátimena séna árai'a súne. kemá kwaási úranda'a kumpaáruraundawai pó'a kesúmo ímo né'o kesí naaemó ímo né'o é'a íma maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ánivo kesúma kesí naaemá naawáí aúnái'a umái maí'mai'a kwéomba ááimba kwéasaamba pó'a naaén-kanaama puwíyampinkemba usásintinkanaumne. ");
INSERT INTO kze_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","kesúma kawe-tómbán-iye. kesí naaemá kawe'-nómbán-iye. ");
INSERT INTO kze_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","kesúma kesí naaemá naawáí kesé tarúmai máyáawa'a kemá miwísé tarúmai máyaumne. ");
INSERT INTO kze_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","kesivo si'mákaiwaima maí'mai'a kwéintave'a kemá maí'mai'a kwéune. kemá maí'mai'a kwéundayave'a pó'a kesúma naawáí maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","kentíkwá'náma toómbá neémesa úwoi putáráawe. kemá súnda-tomba kwíyómpaken-tomba íma mirán-tómbán-iye. kemó súnda-tomba mintómbá naawáí aasiyaasí maí'mai'a ónááowe Ísu séna ");
INSERT INTO kze_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kápénéamu-naopa'a mono'-náúmpá'á mináímbá simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","61","Ísu simásuwowasa kwenánaaemba kwakón-kwaasi tirunkó sáwí'a kwéuwasa ísámai iséise ésa sésa kwemó sin-áínkómá íya sinkáin-aimba póna umbaí kwétaiye suwaná Ísu arumpin-ímáyáámá éna simátimena séna mináíntávé'a kayókáawe. ");
INSERT INTO kze_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","kemó kwíyómpakembo kwaási úranda'o kumpaáruraundawaimo kuntauweré'o íyóna'o suwáné'o é'a nóra imáyáawa ónááoo. ");
INSERT INTO kze_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","kwaásiti asirayánkó íma túwa'naa ivo Áánútun-amanko aúnái'a umái maí'mai'a kwéumatinkaiwaiman-iye. mirámó intembá kemó súnda-aimba aúnái'a umái maí'mai'a ónááon-aimba imbánivo ");
INSERT INTO kze_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","évakarawaima kentávé'a sé'a kampa'á siyé kwésewe Ísu súmba Ísuma kampa'á siyémó sun-áímbá kwená kuntaru'ó íníwainkwara'a naaóvá'á ísaronka'a póna évakarawai kentávé'a sé'a kampa'á siyé kwésewe Ísu simásuwena ");
INSERT INTO kze_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","séna mindáyave'a á'a simátime'a sé'a kesópa'a íma úwoima ténááovo kesivomó tááyaina'a ténááowe siráiye. ");
INSERT INTO kze_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ísu súwasa kwenánaaemba kwakón-kwaasi évakarawai Ísumba ivá'á auwésa kwesé íma kwénaauwana ");
INSERT INTO kze_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ísu kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasiyavena séna kegwárárá ivá'á kwésiyuwaao séna tísaa úwana ");
INSERT INTO kze_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sáímoni Pítaa séna anóndakoo nááwa ewa kónaunawa seénó. emá aúnái'a umái maí'mai'a ónaumne-aimba kwésene. ");
INSERT INTO kze_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ívé'a entávéta séta árai'a séne. Áánútunopakemba kawe'ná'á óneya kwésune súwana ");
INSERT INTO kze_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ísu simátimena séna kemá sísamaivakemba kae'á kumbaimái-kwaasima ítátinkaundanivo keinárawapinkemba moórá sáwína'a paáriniye súmba ");
INSERT INTO kze_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sáímoni Isakéríóti ááninko áwí'a Yútásintavena séna Yútási kwemá kwená kwayó-kwáásí sísamaivakemba kae'á kumbaimái-kwaasivinkemba Ísuna kuntaru'á mayáníwaiman-iye. kwentávéna mináímbá siráiye. ");
INSERT INTO kze_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","minkákémbá Yútiyaa-ayampaken-kwaasi Ísumba tuvuwónáe kwésuntavena Ísuma Yútiyaa-ayampa'a íma kwénaaena Káríri-ayampa'a kwénaauwana ");
INSERT INTO kze_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yútaa-kwaasimo kwááyu-nambo ésamo tanómbo kwégauvon-kanaama sáwíyanka'a túwasa ");
INSERT INTO kze_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ísu áúnava'maa'a aká'áámba simánkesa sésa maanáyámpá'á tuwéma Yútiyaa-ayampa'a kwaási torupanááopa'a ená mayáímá komáénasa pósa ená kwaási ená kawe'-máyáí awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","amápa-kwaasi suwánanaaowe síyawaima íma aúpá'á mayáímá mayánááomba po amápa-kwaasi túranka'a mayáí komayaaó sésa ");
INSERT INTO kze_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ísun-áúnava'maa'a kwentávésa íma imáyáa ésa sésa Áánútunopakemba kunkáiye sésa mináímbá simámúwana ");
INSERT INTO kze_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ísu simátimena séna amáparawai kesí ááimba suwánanaao-kanaama íma tiráivo kemá úwoi kwíyasa tuwánésa ");
INSERT INTO kze_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","marapá-kwáásí kembá íma áwáá'a tíkaavo miwíyávé'a sé'a kentí mayáímá sáwí'a kwéowe súndayavesa kembá áwáá'a síkaawe. ");
INSERT INTO kze_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","tanómbo opa'á koró. amáparawai kesí ááimba suwánanaao-kanaama íma tisa'á ívé'a íma tanómbo opa'á kúmpo kemá koró séna ");
INSERT INTO kze_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Káríri-ayampa'a méraiye. ");
INSERT INTO kze_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ísu máyomba áúnava'maa'a tanómbo upa'á kuwaná naaémba kwemá aúpá'á kúwasa ");
INSERT INTO kze_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yútaa-anon-kwaasi Ísumba kwéavakaa-esa sésa náávara máyáiyo sésa tísaa uwasá ");
INSERT INTO kze_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ísuntavesa úwoi-kwaasi sáwívar-aimba iséise ésa sésa évakarawai sésa kawe-kwáásímán-iye suwasá évakarawai sésa ímanivo kampa'naampa-kwáásímán-iye sésa ");
INSERT INTO kze_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yútaa-anon-kwaasi sáwí'a umásínkáavo sésa íma avora'á sumbá aúpá'á siráawe. ");
INSERT INTO kze_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yútaa-kwaasimo kwááyu-nambo ésamo tanómbo kwégauvon-kanaama évareva kwáyowana avumpin-táwai Ísu anóm-bono'-naumpa'a uména kwenááima simátimuwasa ");
INSERT INTO kze_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yútaa-anon-kwaasi isésa táátavai ésa tóipimba tiyáámba áákesa sésa monor-áímbó isópa'a íma koména ísaraimbanivo nórapakena ísaraiyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ísu minímáyáámó umbá iséna séna kesí imáyáavinkemba íma simátime'a Áánútu si'mákaiwaina imáyáavinkemba simátimune. ");
INSERT INTO kze_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","keinárawa'a imáyáama é'a sé'a náávaken-aina simásímakaiyo. kwená imáyáavinkena'i. Áánútuna imáyáavinkena'iyo-imayaama kwéowe. Áánútumo siráini'a ónáe síyawai miwímó ésa simátimunda-ainkona ááimba isánááowe. ");
INSERT INTO kze_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","kesáváí-ímáyáávínkén-áímbá síyawai kesúwí'a mósá maráígwáe sésa kentí imáyáavinkemba kwésevo ti'mákaiwai áwí'a mósá maránáe síyawai íma kampa'naampá'á sembá árair-aimba kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mósesi ámáámba simátímakombanivo íma ísámai kawer-urére sembá sínkamonae kwésewe súwasa ");
INSERT INTO kze_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","úwoi-kwaasiyomba sésa íma tuvuwónáe-imayaa kwéeta máyaumpo enarumpimbá taraváá-kwámbá máyáísa mirán-áímbá séne suwaná ");
INSERT INTO kze_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ísu séna monor-áímbá kwéisaan-kanaara'a íma awánaraan-awaame'a uráunda pó'a kemá sáwívar-imayaa kwéowe. ");
INSERT INTO kze_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","kentíkwá'nárakemba sésa iyámpói matínkaraawasa avakaumboé-no'waamba kwaésa túra'a araa'éna umái karánááowe suwaná naaémba Mósesi mináímbá agaimakómba pósa évaka-tawai monor-áímbá kwéisaan-kanaara'a mirá kwéowe. ");
INSERT INTO kze_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mósesina ámáámba íma ankáíraamba pó'a agándai-kanaara'a mirám-báyáímá iyámpói túra'a kwéowe. ánivo agándai-kanaara'a moóráwaimba asóvamankaraunda pó'a mayáímá mayaánavo sé'a áwáá'a kwésiyewe. ");
INSERT INTO kze_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","íma awáné-aase aintáváí íma simátínkáaro. árai'a awánáíyan-aintavai simátínkáaro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ísu simásuwowasa évakarawai Yérúsaremu-naopaken-kwaasi sésa minkwáásíyáváíya tuvuwónáewa kwéseo sésa ");
INSERT INTO kze_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","kwemá avora'á kwenááima simátímísa'anivo íma aaivimbá mayánkaraawe. anón-kwaasiyomba sésawa kwemá Áánútumo usásinankawaima Káráísitiman-iye mirá kwéseo. íya kwéseo. ");
INSERT INTO kze_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","maankwáásígóná naaópa'a awánáúndanivo Áánútumo usásinankaiwaina naaópa'a íma awánáúndavakemba tíníye siráawe. ");
INSERT INTO kze_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","minkákémbá Ísu anóm-bono'-naumpa'a simátimena séna kembá ára suwánéra kesi máápa'a ára awánéra mirá kwéoo. íma kesí imáyáavinkemba kunkáumpo moóráwai si'mákaisa'a kunkáumne. kwemá áraite siwáímán-iye. kwembá íma awánaambanivo ");
INSERT INTO kze_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","kemá á'a awánáúnda si'mákaisa'a kwenópakemba kunkáumne súwasa ");
INSERT INTO kze_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","mináímbó súnkakemba tátoranae suwááesa kwená kanaamá íma tiróntavesa íma tátorowasa ");
INSERT INTO kze_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","úwoi-kwaasivinkemba évakarawai sésa Áánútumo usásinankaiwaima tíndara'a kwená mayáígóná awaamékoma amápa'-mayaigomba usáyaaitaniye-imayaa kwéeta Ísuna mayáígómá mirám-báyáígómá póna Ísu Áánútumo usásinankaiwaiman-iye kwésune siráawe. ");
INSERT INTO kze_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","úwoi-kwaasiyomba mináímbá sumbá ámáán-kawaa-kwaasi isésa miwíyé mono-káwáá-kwáásíyé i-kwáásíyávésa sésa Ísumba koyátoraaro sésa ti'márówasa kuwaná ");
INSERT INTO kze_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ísu séna sáwíyanka'a keinárawate mé'a si'mákaiwainopa'a íyóna'a ");
INSERT INTO kze_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","sivakáá uwááe'a íma suwáné'a umáéndava'a íma kanaán-umai iyónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yútaa-anon-kwaasi iséise ésa sésa náávara kwíndayavena síyómpo avakáá uwááeta íya awánanaumne. Kíríki-ayampara Yútaa-kwaasi máyáapara kwéna kwenáái simátiminiyo sésa ");
INSERT INTO kze_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","kwemá séna sivakáá uwááe'a íma suwáné'a umáéndava'a íma iyónááowe simbá póta mináínkóná ááimba íma ísaraumne siráawe. ");
INSERT INTO kze_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yútaa-kwaasi kwááyu-nambo ésamo tanómbo kwégauvon-kanaara'a moórá-kanaama kwáyowana minkánáá anón-kanaama úwana minkánáárá'á Ísu usásinena anónka'a séna nontávénamo kwétinkaindawai kesópakemba tamandaaró. ");
INSERT INTO kze_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Áánútun-aai aúváívimba agaimaréna siráintemba nonayumpinkémbó usausa intenkáámbó kesááiyavesa áraire síyawaima tirumpinkémbá nonayumpinkémbó intembá íníye Ísu súmba ");
INSERT INTO kze_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Áánútun-amankontavena siráiye. Ísu íma kwíyómpa'a kuntauwékáintavena Áánútun-amanko íma kunkáiye. Ísu imáyáa éna séna kemá púwóndavinkemba usásine'a kesivonópa'a iyé'a Áánútun-amankomba ai'máráanana kuména kesááiyavesa áraire síyawai tirumpimbá kumbéniye-imayaa éna Ísu mináímbá simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ísumo simátimumba kwaásiyomba isésa évakarawai sésa árai'a kwemá Áánútun-aai simátímíwaiman-iye suwasá ");
INSERT INTO kze_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","évakarawai sésa kwemá Áánútumo usásinankaiwaima kwéamu'maraundawaiman-iye suwasá évakarawai sésa Áánútumo usásinankaiwaima íma Kárírivakemba tíníye. ");
INSERT INTO kze_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","naaóvá'á Áánútun-aai aúváívimba agaimaréna séna Áánútumo usásinankaiwaima Tévítin-andarakemba Tévítina naaópa'a Pétáremuva'a marankáníye agaimaréna siráiye sésa umbá ");
INSERT INTO kze_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ísuntavesa imáyáama taaínkaa'a ésa ");
INSERT INTO kze_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","évakarawai sésa tátoranae sumbánivo íma tátokaawe. ");
INSERT INTO kze_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","íma tátoresa i-kwáásí mono-káwáá-kwáásítópare ámáán-kawaa-kwaasitopare koyauwérówasa nóra séra íma táto'mai áí'mae'a teéó suwasá ");
INSERT INTO kze_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","i-kwáásí sésa kwenááigoma amápa-kwaasi tááigomba usáyaaitaraiye suwasá ");
INSERT INTO kze_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ámáán-kawaa-kwaasi tísaa esa sésa kenkwárá'á kampa'á simátiyuwaisara kwéseo. ");
INSERT INTO kze_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","anón-kwaasiye kesáá ámáán-kawaa-kwaasiyaawe íma árai'a kwíyómpakemba kunkáiye kwésumpo kegwárá'á mirá seró. ");
INSERT INTO kze_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","úwoi-kwaasiye su'mai áraire kwésewe. miwímá Mósesina ámáámba íma ísáamba póna Áánútu tínkaminiye suwaná ");
INSERT INTO kze_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ámáán-kawaa-kwaasivinkemba moóráwai áwí'a Níkótimasi ááéma Ísunopa'a iráiwaima simátimena séna ");
INSERT INTO kze_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","kentáásí ámáánko séna íma úwoi sé'a sáwí'a uráiye sé'a kwenááima ísare'a kwená mayáí awáné'a aaivimbá mayánkááro kentáásí ámáánko siráiye súwasa ");
INSERT INTO kze_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Níkótimasimba aká'áámba simánkesa sésa Kárírivakewain-ánaaemba kwaráánó. Áánútun-aai aúváívimba awánamai kawer-uréo. Áánútun-aai simátímíwaima íma Kárírivakenda'an-ivo kwemá íma Áánútun-aai simátímíwaiman-iye sésa  ");
INSERT INTO kze_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","kentí naaó'-nao'a kóyáwé uwaná Ísu Óríve-ompa'a iráiye. ");
INSERT INTO kze_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Óríve-omapa'a Ísu uména ");
INSERT INTO kze_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","aaváyaavimba kuména anóm-bono'-naumpa'a umáyowasa kwaásiyomba kwenópa'a torupowaná mara'á ména kwenáái simátimuwasa ");
INSERT INTO kze_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ámáámba sun-kwáásíyé ámáán-kawaa-kwaasiye aaraí áí'maesa minínínkó ó'on-kwaasiye máyomba pósa áí'mai amáparawai túranka'a ankésa ");
INSERT INTO kze_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ísuntavesa sésa anóndakoo minínímbá ó'on-kwaasiye máyáísata awánéta táto'mai áí'maeta túne. ");
INSERT INTO kze_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ámáán-auvaivimba Mósesi agaimaréna séna mirámó índawaimba óntandei tuvúwónanaya puwíníye agaimaréna siráiye. nóran-imayaa éwa seénó sésa ");
INSERT INTO kze_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ísumba maka sésa mirá senaná paárínata kwembá aaivimbá mayankánáe sésa suwaná Ísu kívairena ayáánauvi'nei marará'á aúvái agaimarówasa ");
INSERT INTO kze_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","áísaa aisaa uwaná usásinena simátimena séna imó sáwí'o uráindawai aivar-óntámbá maimé tuvuwíno simátimena ");
INSERT INTO kze_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","moórágwara'a kívairena ayáánauvi'nei marará'á aúvái agaimarówasa ");
INSERT INTO kze_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","isésa moórá-mora-kwaasi kunákárúwasowana anón-kwaasi aiva'á kumúwasa miwán-ánaaemba kwa'maésa kúmúwana minínínkówé su'mai Ísuwe máyowana ");
INSERT INTO kze_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","usásinena áísaa ena séna náávara máyaao. amáparawai íma aaivimbá mayankánááoo súwana ");
INSERT INTO kze_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","owé íma aaivimbá maisinkánááowe súwana kegwárá'á íma aaivimbá mayankáúna kómpo moórágwara'a íma mirán-uwo Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ókwara'a Ísu kwenáái simátimena séna kwaási sáma kamátinkaina'a úne. kesínaaembo kwaráíyawai íma tunínívo sáma kamái maí'mai'a ónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ámáán-kawaa-kwaasi sésa eyáá ená ááimba séndamanivo íma árai'a kwésene suwaná ");
INSERT INTO kze_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ísu séna ímanivo kesááigona ááimba árai'a kwésune. á'a awánáúndavakemba kunkáundayavai á'a awánáúndava'a iyónaunda pó'a kemá súnda-aimba árai'a kwésune. kesí ááimba íma suwánaraawe. ");
INSERT INTO kze_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","marapá-kwáásí kentí imáyáavinkemba aaimá maisínkaavo kemá íma aaimá kwémaitinkaumne. ");
INSERT INTO kze_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kemó aaimó maitinkáundarakai arupí úsino. íma kewé su'mai aaivimbá maitinkánaumpo kesé kesivoé aaivimbá maitinkáyauye. miráumai kemó aaimó maitinkáundarakai arupí úsino. ");
INSERT INTO kze_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","kentí ámáán-auvaivimba agaimaréna séna kae-kwáásíráí moórá-aimbo séyambo ékai mináímbá árai'a kwéseye agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","miráumai kemá kesáváí simátimunana kesivoé kesé mimbórá-áímbá simátimuyamba póna árair-aimban-iye súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","enavomá náávara máyáiyo áísaa esa suwaná kesí ááimbo ímo suwánaantavai kesivombá íma kwéawanaawe. kesí ááimbo suwánaankakenkai kesivombá awánaasino Ísu súmba ");
INSERT INTO kze_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","anóm-bono'-naumpa'a óntambo túwón-daumpa'a mináímbá simátimuwasa tátoranae sésa suwááesa kwená kanaamá íma túntavesa íma tátokaawe. ");
INSERT INTO kze_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","minkákémbá Ísu simátimena séna tiyuwé'a íyóna'a sivakáá uwááe'a íma suwánanaaowe. puwíyamba kentí sáwí-imayaa kwáyáina'a puwónááowe. íyóndava'a íma kanaán-umai iyónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yútaa-anon-kwaasi sésa kwemá séna íyóndava'a íma kanaán-umai iyónááowe simbá póna kweyááríkara puwíndayavena siíyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ísu séna keinárawa'a maankákén-kwáásímán-ovo kemá sanaankéndá'á úne. keinárawa'a marapákén-kwáásímán-ovo kemá kwíyómpakenda'a úne. ");
INSERT INTO kze_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","simátime'a sé'a puwíyamba kentí sáwí-imayaa kwáyáina'a puwónááowe. kemá kwíyómpakenda'a úmpo kentávé'o ímo áraire sé'o é'a kentí sáwí-imayaa kwáyáina'a puwónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","mináínkóná ááimba íma ísámai áísaa esa sésa nááwawa oónó suwaná Ísu séna aasiyaasi-táwai á'a simátímakaumne. ");
INSERT INTO kze_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","keinárawatave'a sáwívar-aimba kanaán-umai sé'a aaivimbá maitinkáundanivo si'mákaiwaina aaiyé su'mai amáparawaiyave'a kwésimatimune. kwemó arupí iwáín-áái kwésimatimune súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Áánútun-aaima súmbanivo íma ísówana ");
INSERT INTO kze_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","mindáyavai Ísu séna kemá kwaási úranda'a kumpaáruraundawai sí'mae'a taaira'á mói sínkamonaaomba pó'a suwáné'a sé'a kwemó siwáímá kwená imáyáavinkemba íma sivo avowamá simámakain-aimpinkemba siráiye mirá sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","si'mákaiwai aamoí ínkwáe-i'a úmae kwéiyunda póna íma siyuwéna kesé máyáiye súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","sáwíva-kwaasi isésa kwentávésa árai'a kwíyómpakenda'an-iye siráawe. ");
INSERT INTO kze_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ísuma Yútaa-anon-kwaasi kwentávésa árai'a kwíyómpakenda'a iyémó sirówaiyavena séna kesááimo ísámaimo kawe'ó é'o é'a kesí kwaási aú'mái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","árair-aimba íséwana tátokaiyampinkemba mináráír-áínkó ayútinkaniye súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ááváramun-andaraken-kwaasi únda póta íma ó'on-kwaasi tátokaawe. nóra se ayútinkaniye seénó suwaná ");
INSERT INTO kze_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ísu séna árai'a simátime'a sé'a sáwí'o kwéowaima misáwíkómá kembá kwétatoraiye. kesí mayáí úwoi mayáígwáe sésa meéyámba'mai tátokaantenkaan-kwaasin-owe. ");
INSERT INTO kze_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","mirán-kwáásí kawáánákóná naaúmpa'a íma maí'mai'a ónááovo kwenáánimbaa'a maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","kemó Áánútu ááninkomo ayútínkáana'o é'a ayútuwe'a ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ááváramun-andaraken-kwaasi ombánivo kesáái íma tirumpimbá kwáyáintave'a tuvuwónáe kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","kesivo agaráásínkáin-aimba kwésumpo kentivomá simátímín-aimba kwésewe súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ááváramu kentáásivoman-iye suwaná Ááváramun-andarakewaimo ékai Ááváramumo úntemba mirá uráasino. ");
INSERT INTO kze_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Áánútu árair-aimba simásímakaimba simátimundanivo tuvuwónáe kwésewe. Ááváramu íma mirá uráivo ");
INSERT INTO kze_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","kentivomó uráintemba mirá kwéowe súwasa kesáámá íma kesinóma eénkwááírákémbá kentáá masínkaraiye. kentáásivoma mimbóráwáí Áánútuman-iye suwaná ");
INSERT INTO kze_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Áánútunopakemba kunkáunda pó'a Áánútu áráá'o ékai kentirumbá simésino. íma kesí imáyáavinkemba kunkáumpo kwemá si'máráísa'a kunkáumne. ");
INSERT INTO kze_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","kemó súnda nóra séra íma kwéisaao. kesááigo umbaí kwétiyaiye. ");
INSERT INTO kze_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","kemá Sáátáánigo áráá'a pó'a kwenarááíma kwaránáe kwésewe. kwemá ááinkakemba tuvúkáiwaiman-iye. árai'o sií-yántáá'á íma kwempímbá kwáyáísana kampa'naampar-áínkómá avowaí'a kwéiye. ");
INSERT INTO kze_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","miráumai árair-aimba simátimundayavai árair-aimba iyémá íma kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","íma sáwí'a uráunda kwéisaawe. arupí-aimba simátimuna'anivo íma áraire kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Áánútu áráá'a pósa kwenáái isésa máyáavo keinárawa'a íma Áánútu áráá'maari'a uré'a pó'a kwenáái íma ísaraawe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ísu simásuwowasa Yútaa-anon-kwaasi aká'áámba simánkesa sésa árai'a séta Sámériyaa-kwaasi ónana taraváá-kwámbá enarumpimbá máyáísampo mináímbá siráane suwaná ");
INSERT INTO kze_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ísu séna taraváá-kwámbá íma kesirumpimbá máyáiye. kesivo áwí'a anómba úndanivo kesúwí'a sáwí'a umásínkáawe. ");
INSERT INTO kze_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","íma kesúwí'a anómba ónáe. Áánútu kentávéna séna kawe'-máyáí mayáánda pó'a enáwí'a mósá anómba umánkanaumne kwésiye. ");
INSERT INTO kze_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","árai'o senda-áímbá kesáái ísámai kawe'á íyawai íma puwónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yútaa-anon-kwaasi sésa sénda-aimba taraváá-kwámbó enarumpimbó máyáimba áta ísaraumne. Ááváramu puwúwasa Áánútun-aai simátímakowaima púwúmbanivo emá se kesáái ísámai kawe'á íyawai íma puwónááowe siráane. ");
INSERT INTO kze_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","kentáásivo Ááváramu puwúwasa Áánútun-aai simátímakowaima pukáambanivo miwí usáyaaitaniyono. emó sénda náávakendara'ono suwaná ");
INSERT INTO kze_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ísu séna kesúwí'o mósá maráúndarakai úwoi úsina. kesúwí'o mósá maránímba kesivomán-iye. kwentávé'a sé'a kentáásí Ísóigoman-iye kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","kwembá kwéawanaumpo kemá íma awánaraawe. kemó sé'o íma awánáúmnemo súndarakai kemó ontembá kampa'ná'á maúsino. á'a kwéawane'a pó'a kwenáái mósá kwémaraumne. ");
INSERT INTO kze_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","kentivo Ááváramu kemó marapá'ó kumónaunda-aimba iséna aamoí éna kembá suwánéna kwenarunkó kawe'á uráiye súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yútaa-anon-kwaasi sésa emá ívé-kwaasi íma kae-kwááí umái siyáánkai-ima maisukáampo emá séma Ááváramumba awánaraumnewa seénó suwaná ");
INSERT INTO kze_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","árai'a simátime'a sé'a Ááváramumbo ímo maránkaronka'a kemá maémaundaniye súwasa ");
INSERT INTO kze_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","mináíntáváí tuvuwónáe sésa óntamba máyómbanivo Ísu aúpá'á anóm-bono'-naumpakemba kárúwaguraiye. ");
INSERT INTO kze_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ísu kúmba moóráwaimba anówama aúgavitamba maránkarowaimba awánésa ");
INSERT INTO kze_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","kwená kwayó-kwáásí áísaa esa sésa anóndakoo nááwana sáwí-yantaakona anondáwa aúramba kavíkáiyo. kwendéígówá'i. anóvowineigowa'iyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ísu séna íma kwená sáwí-yantaakon-ivo íma anóvowiti sáwí-yantaakon-ivo Áánútuna kawe'-máyáí kwenane'á paárínasa awánanaaontavena aúramba kavíkáiye. ");
INSERT INTO kze_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","si'mákaiwaina mayáíyá máyáano. sámo kainká'ó mayáímó kwémayaawanamo no'wáámbo aúráísanamo mayáímó máyáan-kanaamo ánásaintemba miráumai mayáímá mayáúnda-kanaama ánásanimba póta ívé'a Áánútuna mayáíyá mayánaumne. ");
INSERT INTO kze_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","marapá'ó maúnda kwaási sáma kamátinkaina'a úne séna ");
INSERT INTO kze_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","marará'á awirááíma kwi'maréna mindánei toiraambá úmarena aúranka'a a'maréna ");
INSERT INTO kze_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","simámena séna nonkwaaúnkó áwí'a Síróamu-kwaaumpimba awaa'á koyoraaó súwana mirá uráiye. Síróamuwemo súmba kwenááivinkemba kwántámai séna ai'maráí-kwáúné súwana koyotuwéna aúramba awánamai kawe'á éna túwasa ");
INSERT INTO kze_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","kwená naaópaken-kwaasiye ókwaasiye awánésa sésa kwemá aampa'ó ména óntantemo inaai síma sima'a indará'iyo suwasá ");
INSERT INTO kze_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","évakarawai sésa owé kwemán-iye suwasá évakarawai sésa ímanivo mimbórá-óíkwárárá'iyo suwaná kwemá séna ímanivo kemá úne súwasa ");
INSERT INTO kze_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","áísaa esa sésa nóra ónana aúramba kawe'á iíyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","moóráwai áwí'a Ísuma kwemá awirááíma kwi'maréna mindánei toiraaní'a úmarena súranka'a a'maréna simásimena séna Síróamu-kwaaumpimba awaa'á koyoraaó sisa'á isé'a suwaa'á koyoráúnana súramba kawe'án-iye súwasa ");
INSERT INTO kze_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","áísaa esa sésa náávara kuráiyo suwaná íma awánáúmne siráiye. ");
INSERT INTO kze_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","simátimuwasa áí'maesa ámáán-kawaa-kwaasitopa'a máánkówana Ísuma toimá aúranka'a a'maréna aúramba kawe'á umánkaron-kanaama Yútaa-kwaasi monor-áímbá kwéison-kanaa mayáímá aambá áúmbakon-kanaama úwasa aúramba kawe'á umánkarowaimba áí'maesa ámáán-kawaa-kwaasitopa'a máánkówasa ");
INSERT INTO kze_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","áísaa esa sésa nóra ónana aúramba kawe'á iíyo suwaná toimá súranka'a asínkáisa'a suwaa'á koyoráúnana súramba kawe'á umásínkáiye súwasa ");
INSERT INTO kze_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ámáán-kawaa-kwaasi évaka'a sésa agándaan-kanaara'o mirá uráintavena íma Áánútunopakemba kunkáiye suwasá évakarawai sésa sáwí-imayaa-kwaasimo énaraankasi íma kanaán-umai kawe'-máyáí-áwáámé'á isinó suwasá imáyáama taaínkaa'a ésa ");
INSERT INTO kze_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","sésa enaúramba kawe'á umánkaraivo kwentáváí nóin-imayaawa kwéono áísaa esa suwaná Áánútun-aai simátímíwaiman-iye súwasa ");
INSERT INTO kze_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ánivo miYútáá-ánón-kwáásí aúrambo kawe'ó umánkontavesa íma imáyáa umbá anóvowi tááyowasa ");
INSERT INTO kze_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tuyasá tísaa esa sésa kenkáítí táánina'iyo. ánivo aúgavitana maránkaraayana'iyo. nóra ena aúramba awánamai kawe'á kwéiyo suwasaráí ");
INSERT INTO kze_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","kesááninkain-iye. maránkarauyamba aúgavitane. ");
INSERT INTO kze_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ánivo ívé'a nóra isaná aúramba kawe'á umái kwéawanaiyompo kwemá anómban-ivo áísaa íyana kweyááríka'a simátimino sirááiye. ");
INSERT INTO kze_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ááéma Yútaa-anon-kwaasi sésa Ísuntavesa Áánútumo usásinankaiwai kwéamu'maraundawaiman-iye síyawai mono'-náúmpá'á íma iyónááowe sumbá póna minánóvówí Yútaa-anon-kwaasiyavena táá'a kówasarai ");
INSERT INTO kze_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","sésarai anón-umaguraivo kwembá áísaa oro sirááiye. ");
INSERT INTO kze_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","simásúwóyasa ókwara'a aúramba kawe'á umánkarowaimba ááyowana túwasa sésa minkwáásígó sáwí-imayaa kwéiye sewatá ísaraunda po Áánútu aúranka'a arupí umái simásimiyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","sáwí-kwaasiya'i. kawe-kwáásíyá'iyo. kemá íma isáúmne. moórá-yantaatave'a isáúnda súramba kavíkwimbanivo ívé'a súramba awánáúmne súwasa ");
INSERT INTO kze_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","nóraumai aúramba kawe'á umánkaraiyo áísaa esa suwaná ");
INSERT INTO kze_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","á'a simátimundanivo íma ísáawe. ókwara'o simátimena'o é'a isánááoo. kwenaráái kwaránáemo sé'a kwená kwayó-kwáásí-í'a ónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","aká'áámba simánkesa sésa emá kwenaráái kwaráampo kesáámá Mósesi arááíya kwégwaraumne. ");
INSERT INTO kze_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Áánútu Mósesimba aaí simámakaivo minkwáásí náávaken-kwaasiya'iyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","mindá'á mirá séna kemá mirá sembánivo minkwáásí ó'oran-kwaasin-iye. kemá súramba kawe'á umásínkaraisa'a súne. ");
INSERT INTO kze_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","33","kwemó ímo Áánútunopakembo kunkénaraankasi íma mirá uráisino. Áánútuma sáwí-imayaa kwéowai tááima íma kwéisaivo kwená mayáímó máyáawai tááima kwéisaiye. Áánútu áwí'o mósá maráawai tááima kwéisaiye. maambárámó úmaronkakemba íma moórá-augavitan-kwaasi máyáísana kawe'á umánkaraiye sewa'á kwéisaumne súwasa ");
INSERT INTO kze_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","enanóma aampa'á maránkaraisa po úwoivaken-kwaasima éma enáái kentáá kawe-kwáásíyá kwésimasimendayaanivo mono'-náúmpákémbá kunákárúwaao suwaná kunákárúwaraiye. ");
INSERT INTO kze_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","minkákémbá Ísu ai'mátukaan-aimba iséna avakáá-umai awánéna áísaa ena séna kwíyómpakemba kwaási úrandakona arááíya kwégwaraano súwana ");
INSERT INTO kze_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ísuntavena séna anóndakoo emó sénda nááwawa'iyo. simásímína'a kwenaráái kwáráano súwana ");
INSERT INTO kze_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ísu séna á'o aúrambo suwánáánda kemá úne súwana ");
INSERT INTO kze_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","emá Ísóigoma óne séna kívairena kwená imáyáa mósá makáiye. ");
INSERT INTO kze_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","kwená imáyáa mósá marówana Ísu séna marapá'á kunkáunda pósa kwaási avuntambá taaínkaa'a ónááowe. túrambo kavíkáindawai túramba kawe'á umái awánáíyasa túrambo awánemayaiyawai túramba kaviyíníye súwasa ");
INSERT INTO kze_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ámáán-kawaa-kwaasimo évaka'o máyówai isésa áísaa esa sésa ewá séwa kentááyavaiya túramba kavíkáiwai owéwá seénó suwaná ");
INSERT INTO kze_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ísu séna túrambo kavíkáawaimo máyáankakai kentí sáwí-imayaagona meéyámbá íma kwáyáisino. áta awánáúmne sentávéna kentí sáwí-imayaagona meéyámbá kwáyáiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ísu séna árai'a simátime'a súmpo ísáaro. sipisípi kusavá'ó kónáe síyawai ímo sipisípigona ontavímbó usávekesamo ésa kusarákémbó maatésamo ésa miwí umóyándáraware sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","sipisípira'a kárákwiraiwai ontavímbá usá kwéveraiye. ");
INSERT INTO kze_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","miráumai ontará kawááná'á onta tiyánkáísana usáverena kwená sipisípi túwí'a utaisasá kwenáái isésa kwenópa'a kowaná ");
INSERT INTO kze_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","sipisípi kusavínkémbá tí'maena aiva'á kwisasá kwenáái ísáantavesa ánaaemba kwégwaraawe. ");
INSERT INTO kze_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ánivo ó'on-kwaasi táái íma ísámai tínaaemba íma kwa'maésa kwéesa inkaisésa kóyáwé kwéowe ");
INSERT INTO kze_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ísu mirá simátimuwasa mináínkóná ááimba íma ísaraawe. ");
INSERT INTO kze_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","mináínkóná ááimba íma ísóntavena Ísu séna árai'a simátime'a sé'a sipisípigona ontamá kemá úne. ");
INSERT INTO kze_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","íma kunkáundara'a évakarawai tiráawai umóyándáraware. miwí táái sipisípiyonko íma ísaraawe. ");
INSERT INTO kze_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","kemá ontamá úne. kesópa'o tíya'o é'a usáveraaro senasá usáveraiya'a kárákwiyonaumne. toómbó naíyávésamo ésa kunákárúwaresa násuwesa ó'a usáveranaaowe. ");
INSERT INTO kze_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","umóyán-ámpá-kwáásímó tíyawaimo ésa kwaási tínkambai áwáávi-tantaa'a ónááombanivo kemá kunkáunda pósa ó'oran-kawe'a umái maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","sipisípira'a kawe'á umái kárákwiraundana'a úne. sipisípira'o kawe'ó umáímo kárákwirainda'a séna kesí sipisípi túwa'naa ónaumne séna puwíníye. ");
INSERT INTO kze_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ánivo óntantavaiye sésa sipisípira'a tavíkáawai áwáávite in-íyánkómbá awánésa sipisípi ivátiyuwesa kóuwana sipisípiyomba vamái kwatúwáísasa kówitawaa'a umáguraawe. ");
INSERT INTO kze_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","miwí sipisípira'o taviyí-ímáyáámá tuwésa óntane su'maimo mayáí-ímáyáá kwéowe. ");
INSERT INTO kze_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","sipisípira'a kawe'á umái kárákwiraundana'a úne. kesivo kembá súyaisa'a kemá kesivombá aúyáunana mirámó úndantemba kesí sipisípi amápa'a túyáunasa kembá kwésuyaawe. kesí sipisípima túwa'naa ónaundayave'a pó'a kemá puwónaumne. ");
INSERT INTO kze_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","kesí sipisípi évaka'a ó'on-kusava'a máyáamba pó'a kotíráanasa kesáái ísámai tésa mimbóráí'a umái máyaiya'a amáparawaira'a kárákwiyonaumne. ");
INSERT INTO kze_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","18","púwóndavinkemba usásinanaunda-imayaama kesivomá símísa'a kemá owé súndayavena kwenarumbá kwésimiye. kemó ímo owé súndarakai íma kanaán-umai sínkamosino. kesí imáyáavinkemba puwónaunda pó'a kanaará'á puwónaumne. púwóndavinkemba kanaán-umai usásinanaumne. kesivomá simásimena séna mirán-uwo séna mirámó ónaunda-asirayamba símakaiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ísu mináímbá súntavesa Yútaa-anon-kwaasi imáyáa ésa taaínkaar-uwasá ");
INSERT INTO kze_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","évakarawai sésa taraváá-kwámbá arupimbá máyáintavena uwo'aó'á kwéiye. nóra séra kwenáái kwéisaao suwasá ");
INSERT INTO kze_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","évakarawai sésa taraváá-kwámbó arupimbó máyáinkakai íma mirá-áímbá sisinó. taraváá-kwámbó arumpimbó máyáinkakai íma aúgavitan-kwaasi aúramba kawe'á umái awánéna máísino siráawe. ");
INSERT INTO kze_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yútaa-kwaasi anóm-bono'-nambo uráan-kanaamo túntemba Yérúsaremu-naopa'a tanómba kwégauvunka'a minkánáá táúgwi-kanaa póna túwana ");
INSERT INTO kze_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ísu anóm-bono'-naumpa'a ména Sórómoni áúgwimai úmakopa'a kwéguwasa ");
INSERT INTO kze_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yútaa-anon-kwaasi torupésa taúkúmaresa áísaa esa sésa entávéta sáwívar-imayaaya kwéune. Áánútumo usásinankaiwai kwéamu'maraundawaima ewá ónómpo arupí umái sinatá ísáano suwaná ");
INSERT INTO kze_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ísu séna simátimuna'anivo íma ísaraawe. kesivo simásímakaim-bayaima kwémayaunda póna kesí ááimba avora'á kwévaariye. ");
INSERT INTO kze_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","keinárawa'a íma kesí sipisípiyomba pó'a kesááiyave'a íma áraire kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","kesí sipisípi túyáúnasa kesáái ísámai kesínaaemba kwégwaraawa'a ");
INSERT INTO kze_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","imáyáama timúnasa aúnái'a umái maí'mai'a kwéomba pósa íma puwónááowe. kawáá úndavinkemba íma kanaán-umai tayaviyénááowe. ");
INSERT INTO kze_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","kesivomá símakaimba kwená asirayánkó amápar-asirayankomba usáyaaitaisasa kesivomá kawááimpinkemba íma kanaán-umai tayaviyénááowe. ");
INSERT INTO kze_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","kesé kesivoé mimbóráí'a kwéuye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","súwasa Ísumo sún-aintavesa Yútaa-anon-kwaasi ókwara'a tuvuwónáe sésa óntamba máyówana ");
INSERT INTO kze_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ísu simátimena séna kesivomá simásímakaim-bayai kawe'-máyáímá kwémayauna'a kwéawanaavo nóim-bayaiya mayáúndayavaiya sínkamonaaoo súwasa ");
INSERT INTO kze_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","íma kawe'-máyáíyávéta inkamónáeta kwéumpo Áánútumba aká'áámba simánkaandayaveta inkamónaundayaawe. marapá-kwáásígómá séma Áánútuma úne séndayaveta inkamónaundayaawe suwaná ");
INSERT INTO kze_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Ísu séna Áánútun-aai aúváívimba ímo kampar-áímbó kwáyáin-auvaivimba agaimaréna séna Áánútu séna ísóigoman-owe siráiye agaimaréna siráiye. Áánútun-aai simátímakowaiyavena séna ísóigoman-owe siráiye. ");
INSERT INTO kze_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","kesivomá ításinkena si'mákaisa'a marapá'á kunkáumpo Áánútu ááninko úne kwésundayave'a Áánútumba íma aká'áámba kwésimankaumne. ");
INSERT INTO kze_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","kesivoná mayáímó ímo kwémayaundarakai kentávé'a kwíyómpakemba kunkáiye sé'a íma áraire sesinó. ");
INSERT INTO kze_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","kwíyómpakemba kunkáiye sé'a íma áraire sembánivo kesí mayáíyávé'a Áánútuna mayáímá kwémayaiye sé'o é'a minká'á sé'a kwesé avowáe mimbóráí'a kwéoye sénááowe Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","moórágwara'a tátoranae sésa umbá táto'mai tovíráyuwowana kóuraiye. ");
INSERT INTO kze_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ísu miwí tiyuwéna Yótáni-nomba kóaatena ááéma Yóni nombá pétinkaropa'a komáyowasa ");
INSERT INTO kze_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","kwaásiyomba torupésa sésa Yóni ímo awánáúnda-mayaima mairáimbanivo minkwáásíyávéna simásímakain-aimba árair-aimba siráiye suwasá ");
INSERT INTO kze_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","sáwíva-kwaasi Ísuntavesa árai'a Áánútunopakemba kunkáiye siráawe. ");
INSERT INTO kze_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","moóráwai áwí'a Árásárási Pétáni-naopa'a máyowana áí'a úwasarai ámánaakai túwí'a Máríyaae Máátaae mimbórává'á mésaya ");
INSERT INTO kze_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Máríyaa ó'on-tawai áséi-kwiyumba úm-basawemba Ísu aísamaira'a atímarena kwena'nóntáunei uwátukai-ininko éna tiyóvígomba áí'a kwéuwasarai ");
INSERT INTO kze_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","minúnándáráí moóráwaintavesarai sésarai Ísumba kosimáme se anóndakoo enarumbá ámakaandawaimba áí'a kwéiye kosimámiyo suyaná kosimámuwana ");
INSERT INTO kze_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ísu iséna séna Árásárásimbo áí'o kwéimba íma pu'mái ánásaindayavena áí'a kwéivo Áánútu áwíkwara ááninko súwíkwara'o mósá maránááontavena áí'a kwéiye Ísu séna ");
INSERT INTO kze_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Máátaante Máríyaante Árásárásinte kwenarumbá tímakomba póna ");
INSERT INTO kze_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","áí'a kwéun-aimba iséna kae-táwai aáno maéna ");
INSERT INTO kze_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","minká'á kwená kwayó-kwáásíyávéna séna ókwara'a Yútiyaa-ayampata kónaumne súwasa ");
INSERT INTO kze_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","sésa anóndakoo Yútaa-anon-kwaasi óntandei tuvuwónáe sésa kwéopa'a ókwara'a mináyámpá'á kónáe kwésene suwaná ");
INSERT INTO kze_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Ísu miwí simátimena séna túnkwisasamo kombá íma sáma kaisasá pósa tanaambá kwévaavo sámo kaisasamó kombá íma tanaambá kwévaawe. mirámó ontembá isa'á ívé-kanaa kawe'á umái mayáímá mayánaumne Ísu séna ");
INSERT INTO kze_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","kentáásí kwaásigo Árásárási aúmá kwégwaimba pó'a usásinankaandayave'a kónaumne súmba ");
INSERT INTO kze_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Árásárási pukóntavena Ísu súmbanivo kwená kwayó-kwáásí imáyáa ésa aún-kwaiguráimba póna usásinaniye-imayaa ésa sésa anóndakoo kawe'á imbá póna áí'a érankaniye suwaná ");
INSERT INTO kze_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ísu avora'á séna Árásárási pukwiyé. ");
INSERT INTO kze_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","áí'o ipa'á íma kwesé máyaunda kawe'á imbá póta kwenópataamo kondá suwáné'a kentáváí árai'a Áánútumpakemba kunkáiye simásinkanaaowe súwana ");
INSERT INTO kze_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","kwená kwayó-kwáásívínkémbá moóráwai áwí'a Tómáasi kwááyu áwí'a ávárawaama kwemá simátimena séna Yútaa-anon-kwaasi Ísumba inkamónááomba póta kweséya puwónáeta kónaumne Tómáasi siráiye. ");
INSERT INTO kze_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","súwana Ísu Pétáni-naopa'a kúmba Árásárási puwúwasa utámárówana éíyaimba kwaúnka'a Ísu koísaraiye. ");
INSERT INTO kze_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pétáni-nao'a Yérúsaremuva'a egwaa'á pósa ");
INSERT INTO kze_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Máátaante Máríyaante tiyóvígo pukóntavesa Yútaa-kwaasiyomba ivi'á kogwétesa máyówana ");
INSERT INTO kze_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ísu kwétiyemo sumbá Mááta iséna kwétupa'a kúwana Máríyaa naaúmpa'a máyowana ");
INSERT INTO kze_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mááta Ísuntavena koséna anóndakoo emó maanká'ó máyaandarakai kesiyóvi íma púwísino. ");
INSERT INTO kze_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ívé'o Áánútumbo áísaa inanamó éna mirá íníye-imayaa kwéune súwana ");
INSERT INTO kze_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ísu séna enayóvi pukáimpinkemba usásinaniye súwana ");
INSERT INTO kze_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mááta séna naaén-kanaama tínana pukáindavinkemba usásinaniye-imayaama kwéune súwana ");
INSERT INTO kze_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ísu séna púwómpinkemba kwéusasinaawemo sewáíná ááimba kemá úne. aúnái'a umái maí'mai'a ónááowaina ááimba kemá úne. kesááiyavesa áraire sésa kenká'á agevamái máyáawaimo ésa puwónááombanivo usásinanaaowe. ");
INSERT INTO kze_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","mésa kesááiyavai áraire sésa kenká'á agevamái máyáawaimo ésa íma puwónááowe. mindáyavai emá áraire kwéseno Ísu Máátaantavena súwana ");
INSERT INTO kze_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ísóigoo emá Áánútumo usásinankaiwai kwéamu'maraundawai óne. Áánútu ááninko óne. marapá'á kumíníyondawai emá óne Mááta siráiye. ");
INSERT INTO kze_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mááta simásuwena kwéna áúnkontavena aúpá'á áápimba simámena séna anóndako kwétena kwéaayaiye súwana ");
INSERT INTO kze_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Máríyaa iséna avekáán-umai usásinena kwétupa'a kúmba ");
INSERT INTO kze_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ísuma Máátaamo taawánónka'a ména íma naaópa'a túmba ");
INSERT INTO kze_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Máríyaa usásinenamo kúmba Yútaa-kwaasi ivi'á ton-kwáásí awánésa imáyáa ésa sésa utamánkáapa'o ivi'ó táíndayavena kwiyé sésa kwa'maésa kumbá ");
INSERT INTO kze_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ísu máyonka'a Máríyaa kwéna anóndakoman-iye séna aísamaivimba kívairena séna Ísóigoo emó maanká'ó máyaandarakai kesiyóvi íma púwísino súwasa ");
INSERT INTO kze_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Máríyaae kwenánaaemba kwakón-kwaasiye ivi'ó tombá Ísu tuwánówana arumbá éna umbai-yántáákómá arumbá sáwí'a úwana ");
INSERT INTO kze_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","tísaa ena séna náánkara utamánkaraao súwasa anóndakoo taawánaao suwaná ");
INSERT INTO kze_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ísu ivi'á tómba ");
INSERT INTO kze_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yútaa-kwaasi awánésa sésa pukáiwaimba aruntávéna umánkáiye suwasá ");
INSERT INTO kze_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","évakarawai sésa aúgavitan-kwaasi aúramba kawe'á umánkaraimbanivo nóra séna íma asóvamankaisana pukáiyo siráawe. ");
INSERT INTO kze_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","suwaná Ísuna umbai-yántáákómá arumbá sáwí'a úwana utamánkaropa'a kúmba murí-áívímbá mámakesa óika'a óntandei awáá umásúwówana Ísu koawánéna ");
INSERT INTO kze_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","séna óntamba akwátúwáaro súwana Mááta pukówai ámánaako séna Ísóigoo éíyain-tawai kwáímba póna ánkúte íníye súwana ");
INSERT INTO kze_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ísu séna á'a simáme'a súnda kesááiyavaimo áraire sémo kenká'ó agevamáímo mémo e Áánútuna kawe'-máyáímá awánaniyone súwasa ");
INSERT INTO kze_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","óntamba akwátúwówana Ísu kwíyómpa'a awánéna séna kesivoó kesáái kwéisaandayave'a súwi súne. ");
INSERT INTO kze_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","kesáái kwéisaampo maanáímbá kwésunda pósa maanká'á máyaan-kwaasi kentávésa árai'a Áánútu ai'mákaisana kunkáiye sénááowe simásuwena ");
INSERT INTO kze_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","anónka'a séna Árásárásiyo iyuwó súwana ");
INSERT INTO kze_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","pukówaima iráimba ampaantanéí avakúmá ánáan-kwisuwesa aíyayaanka'a asááúmaresa a'nómpá'á káátamaresa mirán-úmakon-tantaakwara'a iyúwana Ísu séna iyátúwéwana máíno siráiye. ");
INSERT INTO kze_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yútaa-kwaasiyomba Máríyaanopa'a kun-kwáásí Ísumo úmba awánésa sésa árai'a Áánútunopakemba kunkáiye suwasá ");
INSERT INTO kze_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","évakarawai ímaniye sésa ámáán-kawaa-kwaasitopa'a kosésa Ísumo ún-aimba simátímúwasa ");
INSERT INTO kze_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","mináímbá isésa ámáán-kawaa-kwaasiye mono-káwáá-kwáásíyé aaimó ísón-kwaasi tááyesa sésa íma awánáúnda-mayai maémáyáimba póta nóraya ónaumno. ");
INSERT INTO kze_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","úwoimo túwáananamo éna mirám-báyáímá maémáyainda pósa amáparawai kwenááiyavesa áraire sénááowe. minká'á Árómáani-kamaani-kwaasi tésa anóm-bono'-namba tayawísíyuwesa kentáámá amáparawaima sáwí'a umásínkáávainivo nóraya ónaumno suwaná ");
INSERT INTO kze_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","moóráwai áwí'a Káyavaasi minkánáá aiva'-mónó-káwááná'á póna séna íma kawe'á umái kwéisaawe. ");
INSERT INTO kze_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yútaa-kwaasi amápa'a púwóvo séna moóráwai puwíníye Káyavaasi siráiye. ");
INSERT INTO kze_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","mináímbó súmba íma kwená imáyáavinkemba siráivo minkánáá aiva'-mónó-káwááná'á máyontavena póna Áánútu imáyáama amúwana paárumai séna Yútaa-kwaasi amáparawaiyavena ísámai Ísu puwíníye. ");
INSERT INTO kze_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","íma Yútaa-kwaasiye su'mai Áánútu áráá'a ovó ó'on-o'om-baravaken-kwaasi mimbóráí'a umái méigwae séna Ísu puwíníye. ");
INSERT INTO kze_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Káyavaasi mináímbá súwasa minkákémbá Yútaa-anon-kwaasi Ísuna ámááyu-aimba suwaná ");
INSERT INTO kze_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","mindáyavena Ísu íma Yútaa-anon-kwaasi túranka'a kwéna tiyuwéna ugóná ayááívá'á Éváráímu-naopa'a kúmba kwená kwayó-kwáásíyé koméraawe. ");
INSERT INTO kze_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","komáyówana tíyótaasa í-tánón-kánáá sáwíyanka'a tínímba pósa tirumbó kawe'ó íyanesa naaó'-naokemba Yérúsaremu-naopa'a koyorupésa ");
INSERT INTO kze_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ísuntavesa mivá maava'a awánésa anóm-bono'-naumpa'a torupésa sésa tanómbo opa'á tíní. íya tíníyo siráawe. ");
INSERT INTO kze_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","mono-káwáá-kwáásíyé ámáán-kawaa-kwaasiye sumbá Ísumbo awánésamo ésa simásimiyata tátóráano sumbá mindáyavesa úwoi-kwaasi sésa tanómbo opa'á tíní. íya tíníyo siráawe. ");
INSERT INTO kze_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","tíyótaasa í-tánón-kánáámá sáwíyanka'a túwana ava'moraé-kanaa úwoi kwáyowana Ísu Pétáni-naopa'a kwéna pukómpinkemba usásinankarowai áwí'a Árásárásina naaópa'a kúwasa ");
INSERT INTO kze_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ísuna toómbá agaimarówana Ísuwe Árásárásiye toómbó naívá'á máyóyana Mááta mintómbá maimái tíma'maena kúwana ");
INSERT INTO kze_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Máríyaa áséi-kwiyumba úm-basawemba anón-ontankakemba meéyámbakena Ísu aísamaira'a sáwíva'a atímarena kwena'nóntáunei uwaúwana mimbásáwén-kwíyúnkó anónka'a naaúmpa'a iyúwana ");
INSERT INTO kze_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","moóráwai áwí'a Yútási Isakéríóti séna nóra sénawa mimbásáwémbá ivátuwena anón-ontamba 300 kina mairéna ímo óísambo makáan-kwaasi taaín-timiyo séna mináímbó siráimba Ísuna kuntaru'ó mayáníwaima séna ");
INSERT INTO kze_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","íma óísan-iyaain-kwaasiti imáyáa éna séna kwemá Ísuna kwaásiti óntanka'a kárákwironda'a umóyándá'á póna minóntámpínkémbá mayánáe séna mináímbá súwana ");
INSERT INTO kze_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ísu séna minínímbá aúwéwana úwoi máíno. púwónanamo pésinkanintavena mirá kwéiye. ");
INSERT INTO kze_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ímo óísambo máráán-kwaasi keséma maí'mai'a kwéiya'a túwa'naa ónáe sé'a túwa'naa ónááombanivo kemá keséma marapá'á íma maí'mai'a ónaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","súwasa Pétáni-naopa'a Ísu máyáiye sumbá sáwíva-kwaasi Yútaa-kwaasi isésa Árásárási pukówana usásinankarowainte kotuwánanae sésa kuráa. ");
INSERT INTO kze_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Árásárásimba usásinankarontavesa pósa Yútaa-kwaasima miwítí anón-kwaasi tiyuwésa Áánútunopakemba kunkáiwainopata kónáe sésa suntaváí mono-káwáá-kwáásí Árásárásina ámááyu-ainkwara'a siráawe. ");
INSERT INTO kze_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","tíndauraamba áséi-masawemba pérankomba póna ívékaamba Yérúsaremuva'a Ísu kwétiyemo sumbá kwaásiyomba isésa ");
INSERT INTO kze_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","taayánáma ayáiresa aampakémbá kogwéairesa anónkar-anonka'a sésa Ísóigo ai'máráísana kunkáiwaimba Áánútu kawe'á kwéumankaiye. kwená Ísareri-kwaasiti kawááná'án-iye kwenáwí'a mósá kwémaraumne suwaná ");
INSERT INTO kze_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","moórá-poima áwí'a tónkigo Ísumba ayáá'maena túmba ");
INSERT INTO kze_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","naaóvá'á Áánútun-aai aúváívimba agaimaréna séna Sáíyono-naopaken-kwaasi táá'a kaivó kentí kawááná'á kwétiye. naanté-tónkígó ayáá'maena kwétiye agaimarénamo siróntemba miráumai Ísu tiráiye. ");
INSERT INTO kze_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","mitáwai kwená kwayó-kwáásí íma imáyáama umái tááka'a makómba pósa Ísu pukómpinkemba kwíyómpa'a iyúnka'a tááka'a marésa sésa aúváívimba kwáyáinka'a póna mirán-iye siráawe. ");
INSERT INTO kze_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ísuma Árásárási pukómpinkemba usásinankomba awánésa évaka-kwaasi simátímúwasa ");
INSERT INTO kze_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","isésa mindáyavesa pósa aampakémbá koáírówasa ");
INSERT INTO kze_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","mono-káwáá-kwáásí iséise esa sésa amáparawai kentáámá siyuwésa kwenarááíye su'mai kwégwaraavo nóraya ónaumno siráawe. ");
INSERT INTO kze_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yérúsaremu-naopa'a monor-áímbá isánáe sésa Yútaa-kwaasi kuwasá Kíríki-kwaasiye kwésa ");
INSERT INTO kze_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Vírípima Káríri-ayampa'a Pétésáítaa-naopaken-kwaasigonopa'a tésa sésa Ísumba awánanaeta túne suwaná ");
INSERT INTO kze_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Vírípima Éndarumba kosimái áí'maesarai Ísumba kosimámúyana ");
INSERT INTO kze_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ísu séna kemá kwaási úranda'a kumpaáruraundawaimba póna kesúwíko anómbo índayavena ívé'a kwévaariye. ");
INSERT INTO kze_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","árai'a simátime'a sé'a ánáyumbo úwoimo kwaíndamo éna íma arambá iyánívo ayumbá u'máráawana aáyánkarena áruma kwiréna sáwívar-aramba imái ávu káníye. ");
INSERT INTO kze_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","mirámó ontembá tirááímo táíndai'o ésa íma kawe'á umái ménaaovo maambárárákén-ímáyáámó tuwáíyawai aúnái'a umái maí'mai'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","kentávésa ená mayáímá mayánáe síyawai kesínaaemba kwáráaro. mirámó íyawai kesé ménaaowe. kesí mayáímó mayáíyawaima kesivo kentúwí'a mósá maráníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ísu simásuwena séna kesirunkómá umbaiyé taimbá pó'a nóra sénaumno. kesivoó maanúmbáí-yántáá'ó kesópa'o tínímba maisiyuwaaó íma mirá sénaumpo kemá mindáyave'a kunkáumne. ");
INSERT INTO kze_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","kesivoó enáwíko anómba íníye súwana kwíyómpakemba aaí séna á'a kesúwí'a anómba uráunda pó'a moórágwara'a ónaumne súwasa ");
INSERT INTO kze_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","máyón-kwaasiyomba isésa évakarawai sésa kwíyónaai siyé suwasá évakarawai sésa Áánútuna kwayó'ná'á kwíyómpakewai aaí kwésimamiye suwaná ");
INSERT INTO kze_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ísu simátimena séna mináímbó isáámba íma kembá kwésuwa'naa-ivo kembá kwétuwa'naa-iye. ");
INSERT INTO kze_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","marapá-kwáásímó aaivimbó maitinkáín-kánáámá kwétiye. marapá-kwáásítí sáwí-kawaana'a kwatiyuwánín-kanaama kwétiye. ");
INSERT INTO kze_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","taaira'á mói sinkánááon-tawaima amáparawaima imáyáama tíménasa kesópata ténááowe Ísu séna ");
INSERT INTO kze_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","mirámó siráimba taaira'á inkamíyana puwíníntavena súwasa ");
INSERT INTO kze_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","kwaásiyomba isésa sésa Áánútun-aai aúváívimba agaimaréna séna Áánútumo usásinankaiwaima aasiyaasí maí'mai'a íníye siráivo emó sénda kemá kwaási úranda'a kumpaáruraundawaimba pósa taaira'á mói sínkamiya'a puwónaumne sémpo emá nááwa se ewá seénó suwaná ");
INSERT INTO kze_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ísu séna kwaási sáma kamátinkaina'a úndanivo sáwíyanka'a kesé ménaumne. kwaásimo túnín-ayampa'o kombá náávara'i kwégowasa pósa íma kwéawanaawe. túnín-tantaako kesópa'a tivó sé'a sáma kamátinkaipa'a máéro. ");
INSERT INTO kze_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","sáma kaimbá pó'a kentávé'a sé'a kentáásí ságayanda'a óne sembá pó'a ságayanko áráá'maa'a aú'mái ménaaowe Ísu siráiye. Ísu simásuwena tiyuwéna aúpá'á méraiye. ");
INSERT INTO kze_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","túranka'a kawe'-máyáí íma awánaraan-awaame'a uráimbanivo kwentávésa íma árai'a Áánútunopakemba kunkáiye siráawe. ");
INSERT INTO kze_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","mindáyavena naaóvá'á Áánútun-aai simátímakowaima áwí'a Áísáya siráin-aimba árai'a súmba Ísóigoo kawer-áímbá kosimátimunasaya mináíntávésa íma áraire kwésewe. ená asirayámbá agaráátinkaandamanivo íma kwéawanaawe Áísáya agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ísun-aaiyavesa íma áraire suntavéna naaóvá'á Áísáya agaimaréna séna ");
INSERT INTO kze_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Áánútuma túramba kavítúwáísasa pósa túramba íma kwéawanaawe. Áánútuma táá'a kaúntinkaisasa pósa íma kwéisaawe. Áánútumo simbá mirá uráunda pósa kesópa'a íma tíya'a sáwí-imayaa maitiyuwé'a kawe'á umátinkanaumne Áánútu siráiye Áísáya agaimaréna séna ");
INSERT INTO kze_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ísuna ságayamba awánomba póna mináímbá agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yútaa-anon-kwaasi évaka'a Ísuntavesa árai'a Áánútunopakemba kunkáiye sésa ámáán-kawaa-kwaasi mono'-náúmpá'á íyóvo sésa aambá áúmbaraavainiye sésa íma avora'á sumbá ");
INSERT INTO kze_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Áánútuma kesúwí'a mósá maráínkwáe-imayaama ímanovo kwaási évakarawai kesúwíta mósá maráígwáe-imayaama ésa mirán-ímáyáámá umbá pósa Ísuntavesa áraire íma avora'á siráawe. ");
INSERT INTO kze_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","íma avora'á suwaná Ísu anónka'a séna kesááiyavesa áraire sésa kenká'á agevamái máyáawai íma kentáváíyé su'mai kwésevo si'mákaiwaintavaigwara'a áraire kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","kesí ááimbo suwánaawaimo ombá íma kené su'mai kwésuwanaavo si'mákaiwainkwara'a kwéawanaawe. ");
INSERT INTO kze_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","marapá'ó kumúnda kwaási sáma kamátinkaina'a únda pósa kenká'á agevamái máyáawai íma túnín-ayampa'a ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","kesááima ísámai íma kawe'á kwéowai aaivimbó maitinkáima íma kemá úne. marapá-kwáásí íma aaivimbá maitínkáandayave'a kumúndanivo sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkanae'a kunkáumne. ");
INSERT INTO kze_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","naaén-kanaara'a kesáái isésa tínaaemba umásinkaiyawai sésa kawer-áímbá sínaaemba umámakaundaniye sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","íma kesí imáyáavinkemba súnda pó'a kesivo si'mákaiwaima simásímakain-aimba súnda pó'a naaén-kanaama tínasa sésa kawer-áímbá sínaaemba umámakaunda ímo oráámbá uráundaniye sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","kesivon-ááima aúnái'a umái maí'mai'a ónááon-aimban-iye. súnda-aimba kesivo simásímakain-aimba kwésimatimune Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","tíyótaasa í-tánón-kánáá aaváyaaraamba kwáyowana ívékaamba Ísu imáyáama éna séna marapá'á tuwé'a kesivonópa'a kuntauweré'a iyónaunda-kanaama kwétiye séna marapá-kwáásí kwenááima ísón-kwaasi ávááraumai imáyáama tiména miwíyáváíyé séna puwíníye súwana ");
INSERT INTO kze_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sáátáánigo Sáímoni ááninkomba áwí'a Yútási Isakéríótimba Ísuna kuntaru'á uwó-ímáyáámá ámakowasa Ísuwe kwená kwayó-kwáásíyé toómbá kwénowana ");
INSERT INTO kze_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","avowámá amápar-asirayamba ámakowana póna Áánútunopakemba kunkáunda pó'a kuntauweré'a iyónaumne-imayaama Ísu éna póna ");
INSERT INTO kze_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","toómbá némáyonkakemba usásinena paákákén-únánkwátói ayú'marena táúri úsúmaena ");
INSERT INTO kze_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","táávepimba nombá atímarena kwená kwayó-kwáásí tísamaira'a nombá pétinkena táúrinei uwátuwena ");
INSERT INTO kze_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ísuma Sáímoni Pítaanopa'a túwana séna Ísóigoo íma kesísamaira'a nombá pésinkaao súwana ");
INSERT INTO kze_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ísu séna kemó úndama ívé'a íma kwéisaanda po aáno isáníyone súwana ");
INSERT INTO kze_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pítaa séna kesísamaira'o nombó pésinkendayave'a a'áo síma sima'a ónaumne súwana Ísu séna enaísamaira'o ímo nombó pérankaanamo éma kesí kwaási-i'a íma íníyone súwana ");
INSERT INTO kze_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pítaa séna Ísóigoo ená kwaási-i'a ónáe súmpo sísamairare su'mai íma pésinkenda síyayaampakwara si'nómpákwárá'á nombá pésinkaao súwana ");
INSERT INTO kze_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ísu séna nombó pékaawaimo ésa íma amápa-kuva'a nombá peránááovo tísamairare su'mai nombá peránááowe. keinárawa'a nombá pétasaawana kímborawai íma nombá pékaiye súmba ");
INSERT INTO kze_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ísu kwená kuntaru-kwáásígómbá ísarontavena séna keinárawa'a nombá pétasaawana kímborawai íma nombá pékaiye siráiye. ");
INSERT INTO kze_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ísu simásuwena tísamaira'a nombá pétinkayuwena paákákén-únánkwátóimo ayú'maromba maimái úmaena ménamo toómbó némáyopa'a kwéna tísaa ena séna kemó úndawaina ááimba ára kwéisaao. ");
INSERT INTO kze_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","kentávé'a sé'a amápa-tantaa'a agaráásinkaandawaima Ísóigoma ónemo sembá árai'a mirán-kwáásímá úne. ");
INSERT INTO kze_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","kemá kentí agaráátinkaina'a Ísóigoma pó'a tísamaira'a nombá kwévetinkaundayave'a kemá moórá-mora-umai nombá pétinkaaro. ");
INSERT INTO kze_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","kemó kentí kwayó'ó maráúndantemba keinárawakwara'a mirán-oro. ");
INSERT INTO kze_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","árai'a simátime'a sé'a kwayó-kwáásímó ésa miwítí anón-kwaasigomba íma usáyaaitanaaowe. ti'mákaiwain-aai maimaésa kosimátímakaawaimo ésa ti'mákaiwaimba íma usáyaaitanaaowe. ");
INSERT INTO kze_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","miráumai kemó uráunda á'a awánaraavo mirámó íyambo é'a tirumbá kawe'á ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","keinárawapinkemba íma amáparawaiyave'a súmpo ítátinkaunda-kwaasi á'a túyaraumne. Áánútun-aai aúváívimba agaimaréna séna kesé moórávinkembo toómbó naráiwaima kesí kuntaru-kwáásímán-iye agaimaréna siráimba árai'a siráiye. ");
INSERT INTO kze_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","íma paáruraisa'a simátimunda póna aánomo paárína'a kentávé'a sé'a árai'a séna Áánútunopakemba kunkáiye sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","árai'a simátime'a sé'a ti'máráanasa kwíyawai táái ísámai kawe'á íyanten-umai kesáái ísámai kawe'á ónááowe. kesááimo isáíyanten-umai si'mákaiwain-aai isánááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ísu simásuwena kwenarumbá umbaí tówana séna árai'a simátime'a sé'a keinárawapinkemba moóráwai kembá namuro-kwáásírá'á agaráátinkaniye súwata ");
INSERT INTO kze_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","kwená kwayó-kwáásí moórá-mora-umai méta kwenaúvínaayaivimba éta nááwantavena siíyó séta ");
INSERT INTO kze_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","kwená kwayó-kwáásí Ísuma kembá arumbá símakowaima Ísuna egwaa'á máyaawanana ");
INSERT INTO kze_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sáímoni Pítaa kentávéna aúwánáán-awaame'a éna séna nááwantavai seénó se áísaa uwo súwa'a ");
INSERT INTO kze_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","avakáá-umai áísaa e'a sé'a Ísóigoo emó sénda nááwa'iyo séwánana ");
INSERT INTO kze_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ísu séna kemó toómbó nompí tu'mái aménaunda-kwaasi kwemán-iye séna toómbá maimaéna nompímbá tu'mái mindá'á Sáímoni Isakéríóti ááninko áwí'a Yútásimba amúwana ");
INSERT INTO kze_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","mintómbá mayówana Sáátáánigo kwenarumpimbá iyúwana Ísu simámena séna emó ónáe sindaí'a maaránka'a uwó Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","toómbó kwénaapa'o máyón-kwaasi Ísumo sún-ainkona ááimba íma ísámai kawer-umbá ");
INSERT INTO kze_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","sésa Yútási óntanka'a tavíkówaintavena Ísu séna ímo óísambo makáan-kwaasi évaka'a timiyó Ísu siyé sésa tanómbo káúvón-kanaaratavai sésa toómbá meéyán-uwo Ísu siyé suwaná ");
INSERT INTO kze_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yútási Ísumo amún-tomba maimaéna avekáán-umai máápa'a kumúwana túnkuraiye. ");
INSERT INTO kze_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yútási máápa'a kumúwana Ísu séna ívé'a kwaási úrandako súwí'a anómba umái kwévaarisana kesí mayáígómá Áánútu áwí'a anómba umái kwévaariye. ");
INSERT INTO kze_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","kesí mayáígómá Áánútu áwí'a anómba intembá ívé'a Áánútu kesúwí'a anómba íníye. ");
INSERT INTO kze_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","kesí iyámpóíyono. sáwíyanka'a kesé mé'a tiyúwáana'a sivakáá ónááowe. Yútaa-kwaasiyave'o á'o simátime'o súndantemba kentávé'a sé'a íyóndara'a íma kanaán-umai iyónááowe. ");
INSERT INTO kze_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","aúná-amaamba simátíména'a kesirumbó timúndanten-umai moórá-mora-umai kentirumbá tíméro. ");
INSERT INTO kze_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","moórá-mora-umaimo kentirumbó timíyasamo ésa tuwánésa sésa Ísuna kwayó-kwáásín-owe sénááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ísu simásuwowana Sáímoni Pítaa áísaa ena séna Ísóigoo náávara iyíníyono súwana íyóndara'a ívé'a íma sínaaemba kwaráníyompo aáno sínaaemba kwaráníyone súwana ");
INSERT INTO kze_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pítaa séna Ísóigoo nóintavaiya ívé'a íma ánaaemba kwaránaumno. íma pó'a áwa'naa umai púwónana kawe'á íníye súwana ");
INSERT INTO kze_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ísu séna áwa'naa umai puwónaumnemo sénda kemá árai'a simáme'a sé'a kokórigomo ímo ááimo siráindara'a kaumborá'á kentáváí séma íma awánáúnda-kwaasiye síníyone Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ísu simásuwena simátimena séna kentirumbá íma sáwí'a é'a íma anón-imayaa oró. Áánútuwe aráápamai mé'a kesé aráápamai máéro. kentí imáyáa Áánútumpa'a tuwé'a Áánútuna imáyáa é'a ánivo kesí imáyáa oró. ");
INSERT INTO kze_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","kesivoná naaópa'a sáwíva'-maru'a kwéraiye. ímo mirámó uráinkakai íma simátimusino. ");
INSERT INTO kze_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","kemó iyúnda kentí maru'á uto'mayaa umátinkanae'a iyúne. usauwé'mae'o kuntí'mae'o íyónda kemó máyaundara'a uménaaowe. mirá ona'á kesé ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","kemó iyúnda-amba á'a awánaawe súwana ");
INSERT INTO kze_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tómáasi simámena séna anóndakoo emó iyónda-naopa'a íma awánáúmne. nááraumai minámbá awánanaumno súwana ");
INSERT INTO kze_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ísu séna Áánútunopa'o iyónááon-amba kemá úne. kemá áraikona ááimba úne. kemá maí'mai'a ónááowaina ááimba úne. kesivoná naaópa'a íma úwoi iyónááomba pó'a kemá minámbá únda pó'a iyónááowe. ");
INSERT INTO kze_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","kesí ááimbo kwésuwanekai kesivombá awánaasino. ívé'a kwéawanaawe súwana ");
INSERT INTO kze_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Vírípi séna anóndakoo enavombá agaráásínkénanaya kentáá kanaa íno súwana ");
INSERT INTO kze_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ísu séna ayáátááka'a keséma máyaundanivo emá kesí ááimba íma kwésuwanaane. kesí ááimba suwánaawaima kesivombá á'a kwéawanaavo nóra isa enavombá agaráásinkaao seénó. ");
INSERT INTO kze_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","kemá kesivoé tarúmai máyaunana kesivomá kesé tarúmai máyáiye. mináíntávé'a áraire seró. íma kesí imáyáavinkemba súmpo kesivomá kesé ména kwená mayáímá isa'á súne. ");
INSERT INTO kze_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","kemá kesivoé tarúmai máyaunana kesivomá kesé tarúmai máyáimba pó'a mináíntávé'a áraire seró. ímo mirámó sé'o é'a kesí mayáímá awáné'a sé'a árai'a kwíyómpakemba Áánútunopakemba kunkáiye seró. ");
INSERT INTO kze_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","árai'a simátime'a sé'a kentávé'a árai'a Áánútunopakemba kunkáiye síyawaima kemó úndantem-bayai miwígwárá'á mayánááowe. kesivonópa'a iyé'a Áánútun-amamba ai'máráándayavena miwítí mayáígó kesí mayáígómbá usáyaaitaniye. ");
INSERT INTO kze_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","kesí imáyáamo é'o sísaa íya'o é'a mirá ónaumpo kentávé'a ísámai kesivo áwí'a mósá maránááowe. ");
INSERT INTO kze_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","kesí imáyáamo é'o sísaa íya'o é'a kemá mirá ónaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ísu mináímbá simásuwena séna kentirumbó símakaambo é'a kesáái ísámai kawe'á ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","kesivombá áísaa onaná karáá'á tutinkáníwaimba ai'maráínana kumbéna kesé aasiyaasí maí'mai'a íníye. kwemá áraikona ááimban-iye. ");
INSERT INTO kze_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","marapá-kwáásí kwembá íma awánésa kwenáái íma ísáamba pósa íma kanaán-umai sésa kesé tamaiyó sevó kesé ména kentirumpimbá maí'mai'a imbá pó'a kwembá kwéawanaawe. ");
INSERT INTO kze_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","sáwíyanka'a tiyuwáúndanivo íma megusaamó ontembá ónááovo usauweránáumne. ");
INSERT INTO kze_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","sáwíyanka'a marapá-kwáásí kembá íma suwánanaaombanivo keinárawa'a ókwara'a suwánanaaowe. kesé ménaunda pó'a kemá aúnái'a umái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","minkánáámá tínímba pó'a sé'a árai'a avowáe ména kesé máyáísata kwesé máyaumne mirá sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","kesááimo taagwiyavésamo kawe'ó kwéowai tirumbá kwésimewe. tirumbá simíyawaima kesivoé kesé sirunkáí timéyauye. kesirumbó timúndawaiyavaiye simái avora'á paárumai ménaumne súwana ");
INSERT INTO kze_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yútási Isakéríóti aráámáómá áwí'a Yútási séna Ísóigoo nóintavaiye séwa úwoi-kwaasiyavaiye simái íma avora'á paárumai ménaumne seénó. kentááyáváíyé simái avora'á paárumai ménaumne seénó súwana ");
INSERT INTO kze_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ísu séna tirumbá símakaawaima kesáái ísámai kawe'á íyana kesivomá arumbá miwí timínakai kesé kesivoé miwísé kumbéyauye. ");
INSERT INTO kze_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","kesáái ísámai íma kawe'á kwéowai tirumbá íma símakaawe. súnda-aimba íma kesí imáyáavinken-aimban-ivo kesivo si'mákaiwaina imáyáavinken-aimban-iye. ");
INSERT INTO kze_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","kesé máyaundara'a mináímbá kwésimatimune. ");
INSERT INTO kze_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ánivo kesivomá kwenamambá kentí karáákómbá ai'maráínana kumbéna kesí anondá éna amápa-tantaa'a agaráátinkena súnda-aimba timína'a tááka'a maránááowe. ");
INSERT INTO kze_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","tiyuwé'a paru kwéumatinke'a kentirumbó kwempa'ó maráí-yántáá'á kwétimune. marapá-kwáásí íma kwétimewa'anivo kesirumbó kwempa'ó maráúndantemba miráumai kwétimune. mindáyavena kentirumbá íma sáwí'a éna íma táá'a kaíno. ");
INSERT INTO kze_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","tiyúwáandanivo kentópa'a usauweránaumnemo súnda á'a kwéisaawe. kentirumbó símakaambo é'a kesivonópa'a íyóndayave'a aamoí ónááowe. kesivomá kembá usáyaaitaraintavaiye simái aamoí ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","íma paáruraisa'a simátimunda póna paárína'a kentávé'a sé'a árai'a siráiye sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sáátáánigo maambárárá'á sáwí-kawaana'a kwétimba pó'a íma ayáátááka'a aaimá simátimundanivo kwená asirayánkó íma kembá tátoraniye. ");
INSERT INTO kze_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kesivomá simásímakaimba mirá únda suwánésa sésa avowámbá arumbá ámakaiye sénááowe. usásinaiyata konó Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","5","Ísu simátimena séna árai'a ándáma kemá úne. kesivomá minándárá'á tavíkáiwaiman-iye. ándáma kemá úne. ándágo amaimá kemán-owe. ímo arambó iyáínda-amaimo éna ayááisiyuwaniye. arambó iyáínda-amaimo éna ayááe'marainana aráságáyó agaimái arambá iyáníye. ayááe'maraintemba simátímakaunda-ainkoma mirá kwéena tirumbá arupí kwéiye. kesé tarúmai maíya'a kemá kempá'á tarúmai máéno. amaiyé su'maigomo éna íma arambá iyáníye. mirámó intembá kesémo ímo tarúmaimo maíyambo éna íma arambá iyáníye. kemá kesé tarúmai máéna'a pó'a kesémo tarúmaimo maíyawaimo é'a sáwívar-aramba imái ménaaowe. kembó ivá'ó siyuwésamo ésa íma arambá imái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","amaimó ayááisuwainda-amaimo aáyánkáíndamo éna aú'mái agaisuwáníye. kesémo ímo tarusíyawaima mirá íníye. ");
INSERT INTO kze_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","kesémo tarúmaimo maíyawai kesááimo kentirumpimbó táto'maraiyawaima áísaa íyana póna mirá umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","sáwívar-arambo imáímo maíyan-kwaasimo tuwánésamo ésa sésa Ísu arááíma kwáráan-kwaasin-owe síyana kesivo áwíkomo éna anómba íníye. ");
INSERT INTO kze_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","kesivomó arumbó símakainten-umai kesirumbá kembá kwétimune. kemó é'a misírúntáváíyé simái máéro. ");
INSERT INTO kze_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","kesivoná ámáámba ísámai kwenaruntaváíyé simái máyaundantemba kesí ámáámbo isé'o é'a kesiruntaváíyé simái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","mináímbá simátímakaunda pó'a kesí aamoi-yántáákó kentirumpimbá anómba kwáyaina'a aamoí umái máéro. ");
INSERT INTO kze_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","kesirumbó timúndantemba moórá-mora-umai tirumbá tíméro. mindá kesí ámáámba kwétimune. ");
INSERT INTO kze_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","kentí kwaásiyavaiye simái kwétuwa'naa-e'a puwónáe sésamo puwíyamba íma moórá-aimba simái usáyaaitamai tirumbá timénááowe. ");
INSERT INTO kze_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","kesááimo isémáyayawaimo é'a kesí kwaási-i'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","anón-kwaasigona kwayó-kwáásí anóndakona mayáí íma awánaraambanivo kwenávárawaisai kwená mayáí awánaraawe. mirámó ontávé'a pó'a kesivomó amápar-aimbo simásímakaimba simátimunda pó'a íma kesí kwayó-kwáásíyé sendá kesívárawaisaiye sénaumne. ");
INSERT INTO kze_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","keinárawa'a íma kembá ításinkaawa'a kemá keinárawa'a ítátinkaunda pó'a kwégwe'a asirayán-árámbá koimái sáwívase umái máéro. kesí imáyáamo é'o kesivompá'ó áísaa íyanamo éna mirá umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","moórá-mora-umai tirumbá tíméro sé'a mirán-ámáámbá simátímakaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ísu mináímbá simátimena séna marapá-kwáásímó keinárawatavesamo tíyámbo umátinkaiya'o é'a tááka'a maré'a sé'a aiva'á kentáásí Ísóigomba áyámba umánkaraawe sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","kemá marapá-kwáásívínkémbá kembá ítátinke'a kendéín-owe súnda pósa marapá-kwáásí tíyámba kwéumatinkaawe. kembó úwoimo marapá-kwáásímó onkákáí kentávésa sésa kenkáán-kwáásín-owe sésa tirumbá timésino. ");
INSERT INTO kze_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","kwayó-kwáásí miwítí anón-kwaasigomba íma usáyaaitaraawemo súnda imáyáama oró. kentí anóndako únasa pósa marapá-kwáásí aká'áámba simásinkesa sáwí'a umásínkáanten-umai keinárawa'a aká'áámba simátinkesa sáwí'a umátinkanaaovo kesááima ísámai kawe'á íyawai kentááima isánááowe. ");
INSERT INTO kze_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","keinárawa'a kesí kwaási-i'a ombá pósa marapá-kwáásí aká'áámba simátinkesa sáwí'a umátinkanaaowe. si'mákaiwaimba íma awánaamba pósa sáwí'a umái mirá ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","kemó ímo kusimátimundarakai marapá-kwáásítí sáwí-imayaa úwoi aúpá'á kwáísino. kusimátimunasa miwítí sáwí-imayaama ivá'á túwááraamba íma ivá'á túwáawana úwoi kwáyáiye. ");
INSERT INTO kze_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","tíyámbo masinkáíyawai kesivonkwárá'á tíyámba kwéumankaawe. ");
INSERT INTO kze_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","kemó ó'owimo usáyaaitamaimo ímo ó'on-o'om-bayaimo mayáúndarakai marapá-kwáásítí sáwí-imayaa úwoi aúpá'á kwáísino. kesí mayáímá awánésa kenté kesivonté tíyámba kwéumasinkaawe. ");
INSERT INTO kze_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Áánútun-aai aúváívimba agaimaréna séna úwoiyavesa kembá tíyámba kwéumasinkaawe siráinka'a póna mináímbá ívé'a kwévaariye. ");
INSERT INTO kze_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","kesivonópa'a iyé'a kentí karáá'á tutinkáníwaimba ai'máráanana kesivonópakemba kwenamankó keinárawate kumbéna kwemá áraikona ááinda'a póna kentávéna amápa-tantaa'a kusimátiminiye. ");
INSERT INTO kze_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","kemó mayáímó ááimbo asááwándarakemba á'a suwánaraamba pó'a kentáváígwárá kesí mayáíyáváígwárá'á simátímapa'a kónááowe. ");
INSERT INTO kze_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","naaémba kesááiyave'a íma asiramái mé'a siyúwáavo sé'a mináímbá kwésimatimunda imáyáa oró. ");
INSERT INTO kze_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","naaémba marapá-kwáásímó keinárawatavesamo mono'-náúmpákémbá kwatuwánáemo sénááomba mindáyavesa sésa Ísuna kwayó-kwáásí tínkamiyawai Áánútuna mayáímá kwémayaawe kampa'á sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","kenté kesivonté íma suwánaamba pósa miráumai sáwí'a umátinkanaaowe. ");
INSERT INTO kze_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ívé'a mináímbá kwésimatimunda póna mindá paárína'a tááka'a maré'a sé'a simásimakaimba kwévaariye sénááowe. mindáyave'a kwésimatimune Ísu siráiye. Ísu simásuwena séna keinárawate máyaunda pó'a mináímbá íma simátímake'a ");
INSERT INTO kze_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","si'mákaiwainopa'a íyóndatavaiye sé'a ívé'a simátímakaana'a náávara iyónó sé'a íma sísaa owa'á ");
INSERT INTO kze_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","iyónaumne súnda-aimbo ísááwana tirunkó umbaí taisa'á pó'a náávara iyónó sé'a íma sísaa owe. ");
INSERT INTO kze_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","árai'a simátime'a sé'a ímo iyúndarakai kentí karáá'á tutinkáníwaima íma kúmísino. iyé'a kwembá ai'máráanana keinárawate kumbéna kawe'á umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","kumbéna marapá'á máyáan-kwaasi kentí sáwí-imayaagona ááimba agaráátinkaniye. arupímo umáímo maígona ááimba agaráátinkaniye. Áánútumo aaivimbó maitinkáníwaina ááimba agaráátinkaniye. ");
INSERT INTO kze_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","kesááiyavaimo ímo áraire síyawaiyavena simátimena séna kentí sáwí-imayaa úwoi kwáyáiye síníye. ");
INSERT INTO kze_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kesivonópa'a iyúnda íma suwánanaaomba póna kentí karáá'á tutinkáníwaima arupí umái ménaaomba kunagaráátinkaniye. ");
INSERT INTO kze_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","maambárárá'á sáwí-kawaana'a á'a aaivimbá mayánkaraimba póna Áánútu aaivimbá maitinkáníyema simátiminimbaniye. ");
INSERT INTO kze_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","sáwívar-aimba simátimusina umbai-áímbá pó'a ívé'a íma kanaán-umai isánááomba pó'a naaémba isánááowe. ");
INSERT INTO kze_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Áánútun-amankoma kumbéna amápa-tantaatavena árair-aama va'mái simátiminiye. íma kwená imáyáavinkemba simátiminivo simámakain-aimba simátimena aánomo paárinin-tantaa'a simátiminiye. ");
INSERT INTO kze_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","súnda-aimba simátiminana kesúwí'a anómba íníye. ");
INSERT INTO kze_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","amápar-aintomba kesivondéímá mindá kendéímán-iye. miráumai sé'a simámakaunda-aimba Áánútun-amankoma simátiminiye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ísu simásuwena séna sáwíyanka'a íma suwáné'a aáno suwánanaaowe súwasa ");
INSERT INTO kze_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","kwená kwayó-kwáásívínkémbá évakarawai sésa kesivonópa'a iyúnda pó'a sáwíyanka'a íma suwáné'a aáno suwánanaaowemo simbá nóintavaiya kwésiyo. ");
INSERT INTO kze_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","sáwíyankaremo simbá mináínkóná ááimba íya kwéisaumne. nóintavaiye séna kwésiyo suwaná ");
INSERT INTO kze_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ísu miwí tuwánarena áísaa ónáe kwéuwana simátimena séna sáwíyanka'a íma suwáné'a aáno suwánanaaowemo súnda-aintave'a keinárawa'a ávááraumai kemó súnda-aintave'a ísámae kwénaaowe. ");
INSERT INTO kze_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","árai'a simátime'a sé'a keinárawa'a ivi'á táíyasa marapá-kwáásí aamoí ónááombanivo kentirumbá umbaí tamái mé'a naaémba kentirumbá etóyóí ónááowe. ");
INSERT INTO kze_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","moórá-ininkomo iyámpóímo maránkarainda-kanaama tínanamo éna áí'o kwéuwanamo maránkaraintavaiye séna ísámai umbaí táínana naaémba miníyámpóí awánéna aamoí umánkaniye. ");
INSERT INTO kze_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","mirá ontembá kentirumbá ísámai umbaí té'a naaémba suwáné'a aamoí ónááowe. aamoimó ií-yántáá'á íma maitiyuwánááowe. ");
INSERT INTO kze_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","minkánáá tína'a íma sísaa ónááovo kesivombá áísaa íyamba kentávé'a ísámai áísaa íyantavena póna mirá umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","kesivombá íma áísaa uráavo ívé'a kentávé'a ísámai áísaa íyamba mirá umátinkainana kentirunkó anómba aamoí ína'a máéro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ísu simásuwena séna kwántámai-aimba simátimunda pó'a naaén-kanaama tína'a kesivon-áái paárumai simátimenaumne. ");
INSERT INTO kze_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","minkánáámó tína'a kesí imáyáa ontáváí kesivombá áísaa íya'a kemá íma áísaa onaná ");
INSERT INTO kze_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kwemá úwoi tiména kwenarumbá tímakaintavena póna úwoi timíníye. kentávé'a sé'a Áánútunopakemba kunkáiye sé'a tirumbá símakaantavena kesivomá arumbá tímakaiye. ");
INSERT INTO kze_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","kesivonópakemba marapá'á kumbáyaunda pó'a ívé'a marapá'á tuwé'a kesivonópa'a iyónaumne Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","kwená kwayó-kwáásí sésa ívé'a íma kwántámai-aimpinkemba sémpo avoratá kwésimasimene. ");
INSERT INTO kze_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","kesáámá séta áísaa ónáisaye íma súnayaama emá ísaraandana'a po paárumai kwésene. miráyá séta Áánútunopakemba kunkáane kwésune suwaná ");
INSERT INTO kze_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ísu séna kentávé'a Áánútunopakemba kunkáiye sembánivo ");
INSERT INTO kze_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","sáwíyanka'a siyuwé'a kentí naaó'-nao'a kóyáwé owa'á keyáá maúsina kesivomá kesé máyáiye. ");
INSERT INTO kze_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","mináímbá simátimunda pó'a kesé tarúmai mé'a aánoumai kwempa'á máéro. marapá-kwáásí aká'áámba simátinkesa sáwí'a umátinkanaaombanivo marapá-tántáákwárá kwaásigwara'a usáyaaitaraunda pó'a kentirumbá aamoí umái ménaaowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ísu simásuwena kwíyómpa'a awánéna séna kesivoó minkánáámá kwétiye. kesúwí'a anómba ina'á enáwí'a anómba umánkáano. ");
INSERT INTO kze_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","amápa-kwaasi tavíkáundayavai asirayámbá símakaanda pó'a símakaanda-kwaasi aúnái'a umái maí'mai'a umátinkaunda mindáyavai kesúwí'a anómba ina'á enáwí'a anómba umánkáano. ");
INSERT INTO kze_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","eyááma árair-Isoigoma óne. kembá si'mákaandana'a úne. empáré kempáré tésa kenkáísááima ísááwai aúnái'a umái maí'mai'a kwéowe. ");
INSERT INTO kze_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","marapá'á enáwí'a anómba umái símakaanda-mayaima ánásaumne. ");
INSERT INTO kze_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","kesivoó maramá íma taróruraandara'a esé máyauyana kesúwí'a anómba kwáyáinka'a po ókwara'a mirán-ínkwáe'a kwésune. ");
INSERT INTO kze_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","marapá-kwáásívínkémbá ená kwaási-i'a umátinke símakaandawaima entáváí mirándá'á máyáiye simái paárumatinkaunasa enáái kwéisaawe. ");
INSERT INTO kze_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","símakaandayavesa sésa mintántáá'á Áánútu ámakain-tantaare kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","símakaanda-aimba simátimunda kwéisaawe. enópakemba kunkáunda-aimba isésa sésa Áánútu ai'mákaisana kunkáiye kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","miwíyávé'a ísámai kwéaisaa-une. marapá-kwáásí úwoi-kwaasiyave'a íma áísaa úmpo símakaanda-kwaasi ená kwaásiyave'a ísámai kwéaisaa-une. ");
INSERT INTO kze_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ená kwaási kesí kwaásiman-owe. kesí kwaási ená kwaásima ésa kesúwí'a anómba kwéowe. ");
INSERT INTO kze_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","marapá'á íma máénda enópa'a íyóndanivo miwímá marapá'á ménaaowe. kawe-késívóo miwírá'á emá taviyénda pósa Áánútumbo ááyaan-kwaasi-i'a umái ménaaowe. esé kesémo tarúmaimo maúyantemba miwímá tarúmai ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","miwísé mé'a tavíkáunda Áánútumbo ááyaan-kwaasi-i'a umái mésa íma sáwí-amba kwakáawe. ánivo moóráwai sáwí-amba kwaránímba póna mináímbá Áánútun-aai aúváívimba agaimaréna siráin-aimba paáriniye. ");
INSERT INTO kze_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","enópa'a íma iyúnda marapá'á mé'a miwí tirumpimbá kesí aamoi-yántáákó anómba kwégwaintavai mináímbá kwésimatimune. ");
INSERT INTO kze_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","enáái simátímakaumne. kemó ímo árai'o marapá-kwáásímó úndantemba miwímá íma árai'a marapá-kwáásímá ombá pósa marapá-kwáásí úwoi-kwaasima tíyámba kwéumatinkaawe. ");
INSERT INTO kze_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","íma sé'a miwímá marapákémbá kuntiraaó súmpo Sáátáánigo sáwí'a umátínkáivo se taviyiyó kwésune. ");
INSERT INTO kze_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","kemó ímo árai'o marapá-kwáásímó úndanten-umai miwímá íma árai'a marapá-kwáásímán-owe. ");
INSERT INTO kze_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","enááima árair-aimba póna tirumpimbá kwáyainasa ená kwaási-i'a umái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","kembó si'maráána'o marapá'ó kunkáundantemba miwímá ti'máráanasa marapá-kwáásívímbá ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","miwíyáváíyé sé'a enarááíye su'mai kwaráúnda pósa enarááíye su'mai kwaránááowe. ");
INSERT INTO kze_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","íma maankwáásíyé su'maiyave'a áísaa e'a súmpo miwí táái isésa kentávésa sésa árai'a Áánútunopakemba kunkáiye síyawaiyavaigwara'a kwéaisaa-une. ");
INSERT INTO kze_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","kesivoó áísaa e'a sé'a esé kesémo tarúmaimo maúyantemba miwímá enté kentéva'a tarúmai ménaaowe. miwímá tarúmai máyáamba pósa marapá-kwáásí tuwánésa sésa árai'a Áánútuma Ísumba ai'mákaisana kunkáiye sénááowe. mindáyave'a námúnaavinkemba kwésimamune. ");
INSERT INTO kze_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","esé kesémo mimbóráí'o umáímo maúyantemba símakaanda-asirayamba tímakaunda pósa mimbóráí'a umái ménaaowe. ");
INSERT INTO kze_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","emá kesé tarúmai máéna'a kemá miwísé tarúmai máyaunda pósa miwímá tarúmai ménaaowe. marapá-kwáásí mindá tuwánésa sésa Áánútuma Ísumba ai'mákaisana kunkáiye sénááowe. enarumbá símakaandanten-umai miwígwárá'á tímakaanda pósa marapá-kwáásí tuwánésa sésa áraire sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","kesivoó maramá íma taróruronka'a enarumbá siméma asirayámbá símakaane. símakaanda-kwaasi kesé maígwáe sé'a súnda pósa kesí asirayámbá awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","kesivoó arupínako óne. marapá-kwáásí embá íma kwéawanaambanivo kemá awánáúnda símakaanda-kwaasi kentávésa sésa Áánútuma ai'mákaisana kunkáiwaiye kwésewe. ");
INSERT INTO kze_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","entáváí mirándá'á máyáiye simái paárumatimunasa enarumbó símakaandantemba miwí tirumbá simíya'a miwísé ménaumne. entáváí mirándá'á máyáiye simái paárumatinkare'a paárunte kónaumne Ísu námúnaavinkemba mirá siráiye. ");
INSERT INTO kze_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ísu simásuwena kwená kwayó-kwáásíyé Kítáróni-nomba kóaatesa taai-kanáágúnévímbá komáyówana ");
INSERT INTO kze_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ísuwe kwená kwayó-kwáásíyé mintáí-kánáágúnévímpá'á kóyo untavéna Yútási Ísuna kuntaru-kwáásí mintáí-kánáágúnévá'á awánéna ");
INSERT INTO kze_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","mivá'á kúmba ámáán-kawaa-kwaasiye mono-káwáá-kwáásíyé i-kwáásígwárá mono'-nánkár-í-kwáásígwárá'á ti'márówana Yútási tí'maena taánasatagwara ánáyatankwara'a maimaésa oómbá to'maésa mintáí-kánáágúnévá'á kumbá ");
INSERT INTO kze_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ísu kwenópa'o tínín-tantaakomba awánéna kwená kwaásivinkemba usásinena miwí túrampa'a koména tísaa ena séna nááwana avakáá-íya kwéoo súwasa ");
INSERT INTO kze_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ísu Násáretivakewaintaveta kwéavakaa-une suwaná miwántávé'o sembá kemá úne súwana Yútási Ísuna kuntaru-kwáásímá póna miwísé máyomba ");
INSERT INTO kze_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","kemá úne Ísu súwasa miwí tayauwérópa'a tanaambá vowaná ");
INSERT INTO kze_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ísu moórágwara'a tísaa ena séna nááwana avakáá-íya kwéoo súwasa Ísu Násáretivakewaintaveta kwéavakaa-une suwaná ");
INSERT INTO kze_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ísu séna á'a simátimunda maandá kemá úne. kembó sivakáá ontavé'a maankwáásí étinkaiyasa koró Ísu súmba ");
INSERT INTO kze_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Áánútuntavai siráimba símakaanda-kwaasi íma sáwí-amba kwakáawe sirónka'a póna paárumai mináímbá súwana ");
INSERT INTO kze_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sáímoni Pítaa taánasatama ámúrandavinkemba taú'maena aiva'-mónó-káwáánákóná kwayó-kwáásí áá'a agáúsuwomba minkwáyó-kwáásígó áwí'a Márákáasi kwenáá'a agáúsuwowana ");
INSERT INTO kze_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ísu Pítaantavena séna ená taánasatama ámúrandavimba kwiyuwó. sí'a índai'a umásinkanaaombanivo kesivoná mayáímá íma tuwánáúnda pó'a mirámá ónaumne Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ísu súwasa i-kwáásíyé miwítí anón-kwaasiye mono'-nánkár-í-kwáásíyé Ísumba táto'mai ayáánka'a asááúmaesa ");
INSERT INTO kze_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","áí'maesa aiva'á moórá-kawaana'a áwí'a Ánásinopa'a máánkówana kwemá Káyavaasi aísáánkoma póna minkánáámá Káyavaasima aiva'-mónó-káwáánákómá póna ");
INSERT INTO kze_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ááéma simátimena séna Yútaa-kwaasi amápa'a púwóvo séna moóráwai puwíníye siráiwaina aísáánkonopa'a máánkaraawe. ");
INSERT INTO kze_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","máánkówasarai Ísuna kwayó-kwáásíráí moóráwai Sáímoni Pítaawe moóráwaiye Ísun-ánaaemba kwa'maésarai kuyambá aiva'-mónó-káwáánákó moóráwaimba awánasuwowana aaimá ísópa'a Ísumba ánkaropa'a umáyowana ");
INSERT INTO kze_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pítaa aan-taaréívímbá máyowana aiva'-mónó-káwáánákómá awánówaima usauweréna ontará'óárákwiron-arasigontavena simámuwana ontá tiyankówana Pítaamba áí'maena usáverowana ");
INSERT INTO kze_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","minárásígó Pítaamba awánéna áísaa ena séna minkwáásígóná kwayó-kwáásíyá'ono súwana Pítaa séna a'áo ke ó'on-kwaasi úne súwasa ");
INSERT INTO kze_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","táúgwitavesa ésa mayáí-kwáásíyé i-kwáásíyé iramá agaimarésa tiyáámba kwégauvuwana Pítaa mináímbá simásuwena irará'á koména ayáámba kauráiye. ");
INSERT INTO kze_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pítaa irará'á kwégauvuwana aiva'-mónó-káwáánákómá Ísuntavena séna simátímakaanda-aimba simásimiyo. ená kwayó-kwáásíyáváígwárá'á simásimiyo súwana ");
INSERT INTO kze_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ísu séna Yútaa-kwaasiti anóm-bono'-naumpare sáwíyam-bono'-naumpare simáti simati eémáyaunda avora'á seémáyaunda íma aúpá'á simátimakaumpo ");
INSERT INTO kze_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","nóintavai kwésisaa-ono. kesááimo ísaraawai tísaa inasá simátimakaunda-aimba ísaraamba pósa sénááowe súwana ");
INSERT INTO kze_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","mono'-nánkár-í-kwáásígó Ísumba tuvuwéna séna aiva'-mónó-káwáánákómó simpímbá íma mirá siyó súwana ");
INSERT INTO kze_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ísu séna sáwí-aimbo súndarakai misáwí-áímbá ááéma avora'á isinó. kawer-áímbó súndayavai nóinkakena sínkamono súwana ");
INSERT INTO kze_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ánási ai'marówasa ayáámpinken-anda íma ayútuwesa mindánankwara'a áí'maesa Káyavaasi aiva'-mónó-káwáánákónópa'a máánkaraawe. ");
INSERT INTO kze_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","aiva'-mónó-káwáánákónópa'a Ísumba máánkówana Pítaa irará'á ména ayáámba kwégauvuwasa irará'ó máyón-kwaasi áísaa esa sésa egwárárá minkwáásígóná kwayó-kwáásí oónó suwaná mináímbá umémpa'a tuwéna séna ke ímaniye súwana ");
INSERT INTO kze_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","aiva'-mónó-káwáánákóná kwayó-kwáásí Pítaantavena séna emá minkwáásígóe taai-kigáúvá'á máyaaya'a tuwánaraunda áraira súno séna Pítaama áá'a agáúsukowai akún-ándárákéwáímá súwana ");
INSERT INTO kze_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pítaa moórágwara'a séna ke ímaniye súwana kokórigo áái siráiye. ");
INSERT INTO kze_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","kokórigo áái súwasa irataró'a Káyavaasina naaúmpakemba Ísumba áí'maesa kámááni-anondakona pááimpa'a máankesa sésa íma Yútaa-kwaasiti naaúmpa'an-ivo ó'on-kwaasiti naaúmpa'a iyéta tíyótaasa í-tánómbá íya náúnavaiyaawe sésa íma íyúwana ");
INSERT INTO kze_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Árómáani-kamaani-kawaanako áwí'a Páíráti kunákárúwena kuntísaa ena séna minkwáásí nóinkakena aaivimbá mayankánáe séo súwasa ");
INSERT INTO kze_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ímo sáwí'o uráinkakai íya áí'maeta túsino suwaná ");
INSERT INTO kze_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Páíráti séna keyááríka'a áí'mae'a kentí ámáámbo makénten-umai simánkáaro súwasa miYútáá-ánón-kwáásí sésa Árómáani-kamaani-kwaasi moóráwaimbo tuvú'máímo utaíyáváí aambá áúntukaawe sumbá ");
INSERT INTO kze_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ááéma Ísu simátimena séna taaira'á mói sínkamiya'a puwónáumne siráin-aimba paárúwasa áí'maesamo kumbá mináíntávésa uwaná ");
INSERT INTO kze_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Páíráti naaúmpa'a kuntauweréna iyéna Ísumba ááyena séna emá Yútaa-kwaasiti kawáánárá oónó súwana ");
INSERT INTO kze_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ísu séna ená imáyáavinkena sísaa ó. kwaási simámakaawa sísaa oónó súwana ");
INSERT INTO kze_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Páíráti séna kemá íma Yútaa-kwaasima úne. ená kwaásiye mono-káwáá-kwáásíyé áí'maesa kesópa'a tiráavo norá ónasawa'iyo súwana ");
INSERT INTO kze_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ísu séna kemó kawááí'o úndama íma marapá'á kwáyáiye. kemó kawááí'o úndamo marapá'ó kwáyáinkakai kesí kwayó-kwáásí áái'a tíyáásino. Yútaa-kwaasi kembá tátoraavo sésa áái'a tíyáásino sésa tátokaawe. kemó kawááí'o úndama íma marapá'á kwáyáiye súwana ");
INSERT INTO kze_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Páíráti áísaa ena séna kawáánárá oónó súwana Ísu séna á'a séne. mindáyave'a marapá'á kumúnana masínkaraimba pó'a arupí-aimba kwésimatimune. arupí-aintavesamo aamoimó owáí kesááima kwéisaawe súwana ");
INSERT INTO kze_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Páíráti séna nói-aina arupí-aimban-iyo siráiye. Páíráti simásuwena kunákáruwena Yútaa-kwaasitavena séna kwemó sáwí'o uráimbo simásímakaamba avakáá únda íma isáúmpo ");
INSERT INTO kze_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","tíyótaasa í-tánón-kánáá tintembá moórá-kwaasi ááyaawa'a ándávakemba ayúrankaundantemba minkánáámó tinká'á Yútaa-kwaasiti kawáánárá ayúrankanaumno tísaa ena súwasa ");
INSERT INTO kze_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","anónka'a sésa ímanivo kwembá íma ayúranke Párápásimba ayúrankaao suwaná Párápásima ááite tiyéna umóyánté in-kwáásímán-iye sésa kwembá ayúrankaao siráawe. ");
INSERT INTO kze_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","suwaná Páíráti i-kwáásí simátimuwasa Ísumba áwí-andanei áwíruku'-nesa ");
INSERT INTO kze_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","anón-kwaasiti kánumo'an-iye sésa áwí-andama owepamái Ísu a'nómpímbá kuvérankesa naaeyayán-únánkwátói anón-kwaasiti unáánkwátóiman-iye sésa umánkesa ");
INSERT INTO kze_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","kanaáráá'a ankésa moórá-mora-umai kwenópa'a tésa sésa Yútaa-kwaasiti kawááná'á óne sésa tiyáándei tuvúto'na uráawe. ");
INSERT INTO kze_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","tuvúto'na uwaná moórágwara'a Páíráti kunákáruwena amápa-kwaasiyavena séna maísáaro. íma sáwí'a uráintave'a áí'mae'a túranka'a máankaraana'a awánaaro. íma sáwí'a uráiye súwana ");
INSERT INTO kze_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ísu kunákáruwena a'nómpímbá áwí-andagwara naaeyayán-únánkwátóigwara'a kunákárúwowana Páíráti simátimena séna minkwáásígómbá awánaaro súwasa ");
INSERT INTO kze_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","mono-káwáá-kwáásíyé mono'-nánkár-í-kwáásíyé awánésa anónkar-anonka'a sésa taaira'á tuvuwíyana puwíno suwaná Páíráti séna kwemá íma sáwí'a uráimba pó'a kemá íma tuvuwónaumpo keinárawa'a áí'mae'a taaira'á máyuvuworo súwasa ");
INSERT INTO kze_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yútaa-kwaasi sésa kwemá séna Áánútu áánimba úne seémáyaimbanivo kentáásí ámáánkoma séna mirámó síndawaimba tuvuwíyana puwíno símakaampimba póta tuvuwónaumne suwaná ");
INSERT INTO kze_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Áánútu áánimba úne siráin-aimba Páíráti isówana ávááraumai áá'a kówana ");
INSERT INTO kze_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","naaúmpa'a kuntauweréna umaéna Ísumba áísaa ena séna náávakewaiya'ono súwana Ísu iséna íma aaí súwana ");
INSERT INTO kze_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Páíráti séna kemó áísaa únda nóra se íma aaí kwéseno. kemó aaimó senasamó ésa ayúrankanaaowe. kemó senasamó ésa taaira'á tuvuwíyama puwíníyone. minásíráyámbá tokáumne súwana ");
INSERT INTO kze_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ísu séna Áánútumo minásíráyámbó ímo ámakainkakai íma toráasino. Áánútu ámakaivo sí'maenamo enká'ó másínkaiwaina sáwí-mayaigoma ená sáwí-mayaigomba usáyaaitaraiye siráiye. ");
INSERT INTO kze_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ísu súwana Páíráti mináímbá iséna séna nóra'iyo ke minkwáásí ayúrankanae'a kwéune súwasa Yútaa-kwaasi anónka'a sésa emó ayúrankemo éma íma Árómáani-kamaani-aiva-kawaanakona kwaási-i'a kwéone. Ísu séna kemá kawáánákómá úne siráintavai Árómáani-kamaani-aiva-kawaanakomba usáyaaitanae siráintavai mindáyavaiye séma íma ayúrankaao suwaná ");
INSERT INTO kze_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","14","Páíráti mináímbá iséna Ísumba áí'maena máápa'a óntan-ayaumá kwáyom-barupa'a Yútaa-kwaasi tááivinkemba áwí'a Kápata-marupimba kumbéna aaivimbá maitínkarom-barupa'a kumbéna Yútaa-kwaasiyavena séna kentí kawáánákómán-iye súwana tíyótaasa í-tánón-kánáámá aaváyaaraamba tíníye úwana ívékaamba kwáyá'wái sáwíyanka'a tíníye úwana Páíráti Yútaa-kwaasiyavena séna kentí kawáánákómán-iye súwasa ");
INSERT INTO kze_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ímaniye sésa anónkar-anonka'a sésa taaira'á tuvuwíyana puwíno suwaná Páíráti tísaa ena séna kentí kawáánákómbá taaira'á tuvuwíyane'a kwéowe súwasa mono-káwáá-kwáásí sésa Árómáani-kamaani-aiva-kawaanako kweyááma kentáásí kawáánákómán-iye suwaná ");
INSERT INTO kze_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yútaa-kwaasi tááigo usáyaaitontavena Páíráti séna Ísumba taaira'á tuvúwóro séna tímakaiye. ");
INSERT INTO kze_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Páíráti timúwasa i-kwáásí Ísumba áí'maesa taaimá tuvuwónááon-taima kwenká'á ámúwana áúgwaata'maena tuvuwónááon-ayampa'a kúmba mináyámpáré sésa áwí'a a'nómayaampare Yútaa-kwaasi tááivinkemba Kórígótaavare mináyámpá'á kúwasa ");
INSERT INTO kze_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","taaira'á aíyayaampimba tuvúsúmaresa kae-kwáásíráí Ísuna évarevar-akwampa'a taaira'á tuvúsúmaresa Ísumba avumpimbá tuvúsúmarowana ");
INSERT INTO kze_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Páíráti kwená mayáí-kwáásíyávéna séna Ísu Násáretivakewaima Yútaa-kwaasiti kawááná'án-iye sé'a agaimái taaira'á aráápamankaaro súwasa ");
INSERT INTO kze_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","kaumbo-kwáásí tááivinkemba Yútaa-kwaasi tááivinkenkwara Árómáani-kwaasi tááivinkenkwara Kíríki-kwaasi tááivinkenkwara'a agaimái aráápamankarowasa sáwíva-kwaasi awánomba tuvúwún-ayampa'a anón-daopa'a egwaa'á kwáyontavai sáwíva-kwaasi mináúváímá awánésa táámpamai ísówasa ");
INSERT INTO kze_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yútaa-mono-kawaa-kwaasi Páírátintavesa sésa Yútaa-kwaasiti kawááná'án-iye íma mirá simái agayáámpo kwemá séna Yútaa-kwaasiti kawááná'á úne mirá simái agayaaó suwaná ");
INSERT INTO kze_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Páíráti séna á'a agaimakáumne siráiye. ");
INSERT INTO kze_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","i-kwáásí Ísumba taaira'á aíyayaampimba tuvúsúmaronka'a kwená unáánkwátói maimaésa éíyainka'a taaímbaresa moórá-mora-i-kwaasi éíyain-kwaasi minúnánkwátói maimaésa moórá-ampaanta paákár-únánkwátói íma arúmakon-ampaantama maimaésa sésa ");
INSERT INTO kze_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","taráráivo séta aávéiya kwétiyaananaya nááwa usáyaaitena mayáníyo sumbá Áánútun-aai aúváívimba agaimaréna séna kesí unáánkwátói taaímbai maimaésa moórá kesí ampaantarátávésa aávéima tiyaráawe sirónka'a pósa i-kwáásí mirá uráawe. ");
INSERT INTO kze_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","i-kwáásí mirá uwasá Ísuna kwaási taaira'á tuvúkón-taigona ááimpimbo máúmba Ísumba anówa úwana kwenáúnko Kórópasi awainínkó áwí'a Máríyaa úwana Mágátáraa-naopaken-ininko áwí'a Máríyaa úwasa miráumai-inimba taaigoná ááimpimba máyówana ");
INSERT INTO kze_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ísu kwenanówamba awánéna kembá Yónimba suwánéna anówantavena séna mindá enáánimban-iye séna ");
INSERT INTO kze_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","kentávéna séna mindá enanóman-iye súwa'a isé'a kesí naaúmpa'a móankare'a kárákwiraumne. ");
INSERT INTO kze_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","minkákémbá Ísu imáyáama éna amápa'-mayaima ánásaumne súmba sáwí-imayaagomo tátokaimpinkemba iyátinkaunda-mayai amápa'-mayai ánásasuwaumne séna Ísun-aai Áánútuna aúváívinkemba paárinintavena Ísu séna nontáváí kwésinkaiye súwana ");
INSERT INTO kze_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ándá-aran-domba ikaa'-nómbá anavéúmpímbá kwáyowana paru-táyánáma mindómpímbá tu'maéna oviyen-támayopimba kinúvaimaena naínkwáe séna Ísu óika'a mósá marówana ");
INSERT INTO kze_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ísu néna séna amápa'-mayaima ánásasuwaumne séna a'nómbá kívaimai avowa ayáámpimba kwenamambá to'maréna pukáiye. ");
INSERT INTO kze_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ísu kweyááríka'a puwúwana Yútaa-kwaasima agándon-kanaama tíyótaasa í-tánón-kánáámá aaváyaaraamba tíníye úwasa pósa sésa agándai-kanaara'a puwíyan-kwaasi taaira'á máévo sésa Páírátinopa'a tésa sésa puwíyan-kwaasi íma úwoi tiyúwéwasa taaira'á máéro. tísamaima ankaisíyasa ááéma puwíyasa taairakémbá marapá'á maitiyúwáaro suwaná ");
INSERT INTO kze_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Páíráti owé súwasa i-kwáásí Ísuna évarevar-akwampa'a taaira'á tuvúsúmaron-kwaasi tísamaima koankaisésa ");
INSERT INTO kze_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ísunopa'a tumbá á'a pukóntavesa kwenaísamaima íma ankáísúmba ");
INSERT INTO kze_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","moórá-i-kwaasigo Ísuna akwámpímbá kwaantáándéí agaivówana naaegwárá nonkwárá'á kunkáiye. ");
INSERT INTO kze_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","mindámó awánáúndawaima simátímakaumne. awáné'a árair-aimba súnda pó'a isé'a sé'a áraire sénááowe. ");
INSERT INTO kze_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Áánútun-aai aúváívimba agaimaréna séna kwenayáátámba íma ankaisíníye agaimaréna sirónka'a pósa i-kwáásí mirá uráawe. ");
INSERT INTO kze_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","moóráva'a agaimaréna séna kwaantáándéímó agaiváíndawaimba avuwónááowe agaimaréna sirónka'a póna paáruraiye. ");
INSERT INTO kze_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yósépima Árímátíyaa-naopakewaima Ísun-aai isówai póna Yútaa-anon-kwaasi táároi inkaiséna kwenáwí'a áúyotukomba póna Ísuma puwúnka'a Páírátinopa'a téna séna Ísun-auma utánáivo simiyó súwana Páíráti séna kanaámpó mayáníyone súwana Yósépi Ísun-auma komayówana ");
INSERT INTO kze_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Níkótimasima ááéma Ísunopa'a no'wáámba tiráiwai áséi-kwiyumba úm-basawemba anóm-basawemba kae'á maimaéna Yósépimba kóáí'maesarai ");
INSERT INTO kze_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ísun-auma komaimaésarai ampaantavímbá mináséí-kwíyúm-básáwénkwárá'á asááúmaesarai tésarai Yútaa-kwaasi miráumai utaantembá pósarai miráumai utarááiye. ");
INSERT INTO kze_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ísumbo tuvúkáan-ayampa'a taai-kigáúmá kwáyowana utaráam-buri-aima ímo kwaási utaróm-buri-aima kwáyowasarai ");
INSERT INTO kze_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","agándai-kanaama sáwíyanka'a tíníye sésarai mimbúrí-áímá egwaa'á kwáyontavesarai Ísumba mimpímbá máutaraaiye. ");
INSERT INTO kze_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","sontaará'á irataró'a íma sán-karowana Máríyaa Mágátáraa-naopaken-ininkoma utamánkaropa'a kwéna koawánómba murí-áígóná óikaken-ontamba maisukówana koawánéna ");
INSERT INTO kze_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","isaaiséna Sáímoni Pítaante kenté tasimásimena séna kentáásí anóndakon-áúma murí-áívínkémbá maimaésa náávara makááo súwakai ");
INSERT INTO kze_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pítaae kesé utamánkóm-buri-aiva'a kónáe sékai ");
INSERT INTO kze_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","isaaisékai kówáyamba kemá Pítaamba kóyaaita kwé'a aiva'á murí-áívímbá kówánda ");
INSERT INTO kze_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","kívaire'a ampaantawé su'mai kwáyomba awáné'a íma murí-áívímbá usáverááwánana ");
INSERT INTO kze_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sáímoni Pítaa téna murí-áívímbá usáverena awánómba ampaantawé su'mai kwáyowana ");
INSERT INTO kze_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ísu a'nónkákén-ámpáántá moórá-ayampa'a kwáyowana awánówa'a ");
INSERT INTO kze_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","murí-áívímbá aiva'á kówándawai usávere'a awáné'a sé'a árai'a pukáimpinkemba usásinkaiye séwándanivo ");
INSERT INTO kze_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Áánútun-aai aúváívimba agaimaréna séna pukáindavinkemba usásinaniye siráimba íma ísámai kawe'á ówáyamba ");
INSERT INTO kze_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","kenkáísí naaópakai kuráuye. ");
INSERT INTO kze_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","naaópa'a kówáyana Máríyaa murí-áígó óika'a ména ivi'á kwétena kívairena murí-áívímbá awánómba ");
INSERT INTO kze_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kae-kwáásí kwayán-únánkwátóigwara'a Ísumba utamánkóm-barupimba mésarai moóráwai a'nómpá'á maúwana moóráwai aísamaiva'a maúwana umái máyóyana Máríyaa tuwánówasarai ");
INSERT INTO kze_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","sésarai menínínkóo nóintavai ivi'á kwétaano suyaná Máríyaa séna kesí Ísóigomba maimaésa náávara makááo sé'a íma kwáyáísa'a kwéawanaumne ");
INSERT INTO kze_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","simásuwena tagwántámai awánómba Ísuma úmbanivo íma aúyówana ");
INSERT INTO kze_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ísu séna menínínkóo nóin-ivira kwétewa nááwana kwéavakaa-ono súwana Máríyaa séna taai-kigáúrá'á tavíkáiwaima iyé-ímáyáá éna séna emó maimaémo nááva'o maké simásimiyo. komayánáivo súwana ");
INSERT INTO kze_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ísu séna Máríyaao súwana mégwantena kwenááivinkemba séna Araponai súmba maanáípínkémbá kwántámai séna kesí Ísóigoo súwana ");
INSERT INTO kze_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ísu séna kesivonópa'a íyóndayavai kwéumpo íma tátoraao. kesívárawaisai kosimátime se kesivo kentivonópa'a iyúne. kesí Ísóigo kentí Ísóigonopa'a iyúne súwana ");
INSERT INTO kze_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Máríyaa Mágátáraa-naopaken-ininko Ísuna kwayó-kwáásí kosimátimena séna Ísóigomba awánáúmne séna Ísóigomo sún-aimba simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","misóntááóná enónka'a Ísuna kwayó-kwáásí Yútaa-anon-kwaasiyavena táá'a kówasa naaúmpa'a umésa ontá umái ítáyuwowana Ísuma paárumai túranka'a ména séna aánoumai máéro séna ");
INSERT INTO kze_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ayáánarumpin-avigwara akwámpín-ávígwárá'á agaráátinkowasa miwítí Ísóigomba awánésa pósa ávááran-aamoi umánkówana ");
INSERT INTO kze_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ísu moórágwara'a séna aánoumai máéro. kesivomó si'mákaintemba umái keinárawa'a ti'máráana'a kesí mayáímá komáyáaro séna ");
INSERT INTO kze_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","kwenááma aútimena séna Áánútun-amankomba tíménana kesé méniye. ");
INSERT INTO kze_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","sáwí-imayaamo maitiyuwáíyanamo éna misáwí-ímáyáámá ánásaniye. ímo maitiyuwáíyanamo éna misáwí-ímáyáámá úwoi kwaíkwai'a íníye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ísuma paárúwasa kwená kwayó-kwáásí awánasuwonka'a Tómáasi kwááyu-awi'a ávárawaao kwemá ó'opa'a máyomba ");
INSERT INTO kze_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","túwasa simámesa sésa Ísóigoma paárisata awánáúmne suwaná Tómáasi séna ayáánarumpin-avigwara akwámpín-ávígwárá'ó awáné'o tátorekai sé'a pukáimpinkemba usásinkaiye súsino súwana ");
INSERT INTO kze_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","avakaeté-no'waamba maisuwésa Tómáasigwarar-umai ókwara'a kwená kwayó-kwáásíyé naaúmpa'a umésa ontá umái ítáyuwowana Ísuma paárumai túranka'a ména séna aánoumai máéro séna ");
INSERT INTO kze_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tómáasintavena séna siyáánarumpimba táto'mai awáné sukwámpímbá táto'mai awáné se kentáváí kamparé sénavainivo áraire siyó súwana ");
INSERT INTO kze_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tómáasi séna kesí Ísóigoo emá kesí Áánútu óne súwana ");
INSERT INTO kze_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ísu séna ááéma íma suwánarempo kamparé siráandaniye. ívé'a suwánáánda po áraire kwésene. ímo suwánewaimo ésa árairemo sésamo ésa aamoí ésa tirumbá kawe'á ónááowe Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ísuma kwená kwayó-kwáásí súranka'a ó'on-o'om-bayai-awaame'a agaráásinkowa'a évaka'a maankwándááívímbá íma agaimaráúndanivo évaka'a agaimakáumne. ");
INSERT INTO kze_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ísuma Áánútu áánimba póna kwemá usásinankaiwaiman-iye séna maanáúváímá agaimakáunda pó'a Ísuntavesa áraire sénááowe. mirámó síyawaimo ésa Ísuwe tarúmai maí'mai'a ónááowe sé'a mindáyave'a maanáúváímá agaimakáumne. ");
INSERT INTO kze_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","naaémba Táípíriyasi-kwaaunkon-awampa'a Ísu miráumai paárúwasa kwená kwayó-kwáásí awánaraawe. ");
INSERT INTO kze_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","kwená kwayó-kwáásí torupésa miwí túwí'a Sáímoni Pítaawe Tómáasi kwááyu-awi'a ávárawaawe moóráwai Káríri-ayampakemba Kéna-naopaken-kwaasi áwí'a Nátáníyowe Sépéti ááninkaiye ó'on-kae-kwaasiye miráumai-kwaasi torupówana ");
INSERT INTO kze_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sáímoni Pítaa simátimena séna noyáá'a kotoránáe'a kúne súwasa kesáágwara'a montá kónáeta kwéune sésa nompí-sípívímbá usámaaisesa kumbá no'wáámba noyááramai kwima-kwimar-umbá íma noyáá'a torówana ");
INSERT INTO kze_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","irataró'a Ísu nonawámpá'á máyowasa íma aúyowana ");
INSERT INTO kze_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ísu séna iyámpóíyono. noyáá'a tokááo súwasa ímaniye suwaná ");
INSERT INTO kze_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ísu séna kwase-únámbá tiyáánúrapar-ayampa'a nompímbá túwéwana kumína'a noyáá'a asínáaro súwasa kwemó súnten-umai sáwíva'-noyaa'a asínówana mindómpí-sípívímbá íma kanaán-umai máráára'naraa éna ógwitowa'a ");
INSERT INTO kze_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","kemá Pítaantave'a sé'a epínda Ísóigoman-iye séwánana Pítaa mináímbá iséna mayáímó mayáíndayavena paákákén-únánkwátói ayú'maromba minúnánkwátói maimái úmaena nompí-sípí tuwéna nompímbá ásávena nonáámááíva'a kúwana ");
INSERT INTO kze_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","nonáámááí egwaa'á kwáyowata ó'on-kwaasiya mindómpí-sípí maimaéta kwase-únámbá tavisímaeta kówándaya ");
INSERT INTO kze_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","nonáámááíva'a ásávaawandaya iramá kwégowana noyáákwara toónkwárá'á kwéagayowata awánaawananaya ");
INSERT INTO kze_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ísu séna tóráan-doyaa'a évaka'a maimaé'a teró súwana ");
INSERT INTO kze_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sáímoni Pítaa nompí-sípívímbá usámaaisena kwase-únámbá tavisímaena nonáámááíva'a mámarowana anón-doyaa'a 153 noyáá'a kwéna sáwíva'-noyaa'a kwáyombanivo kwase-únámbá íma tararówana tavisímaena nonáámááíva'a mámarowana ");
INSERT INTO kze_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ísu simásimenaya séna tamandaaró súwata nááwa'ono séta áísaa ónáe séta ówándaya íma áísaa eta Ísóigoma iyé-ímáyáámá ówánanaya ");
INSERT INTO kze_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ísu noyáákwara toónkwárá'á maimái símakaintaawe. ");
INSERT INTO kze_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ísu pukómpinkemba usásinomba kaeká'á paárúmba ívékwarakaamba paárúwata awánaraundayaawe. ");
INSERT INTO kze_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","toómbá násuwowana Ísuma Sáímoni Pítaantavena séna Yóni ááninko Sáímoniyo. miwímá usáyaaitewa enarumbá kwésimeno súwana owé Ísóigoo ená imáyáamo umánkaunda á'a suwánaraane súwana Ísu séna kesí sipisípi-araaka'a taviyiyó séna ");
INSERT INTO kze_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ókwara'a Ísu áísaa ena séna Yóni ááninko Sáímoniyo. kesí imáyáama kwéono súwana owé Ísóigoo ená imáyáamo umánkaunda á'a suwánaraane súwana Ísu séna kesí sipisípira'a taviyiyó séna ");
INSERT INTO kze_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","kaumborá'á Ísu áísaa ena séna Yóni ááninko Sáímoniyo. kesí imáyáama kwéono súwana kaumborá'á áísaa ena súntavena Pítaa arumbá umbaí tówana séna Ísóigoo amápa-tantaa'a á'a awánaraandayavai ená imáyáamo umánkaundagwara'a á'a suwánaraane súwana Ísu séna kesí sipisípira'a taviyiyó. ");
INSERT INTO kze_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","árai'a simáme'a sé'a emá aú-kwaasima máyaanda po ená unáánkwátói ane'maké ená imáyáavinkemba úwoi kwénaaempo anónu'mai kéma enayáámba árútuwenasa ímo embó arááímo táíndava'a máankanaaowe Ísu séna ");
INSERT INTO kze_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","mináímbó súmba Pítaamo miráumai taaira'á puwéna mindá Áánútu áwí'a mósá maráníye séna Pítaantavena séna kesirááíma kwaraaó siráiye. ");
INSERT INTO kze_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ísu Pítaantavena simásuwowana Pítaa kogwanténa moóráwaimba awánarai. ááéma toómbá narópa'a Ísun-aóká'á ména séna Ísóigoo nááwa ená kuntaru-kwáásí íníyo siráiwaimba ");
INSERT INTO kze_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pítaa kogwanténa awánéna Ísuntavena áísaa ena séna Ísóigoo minkwáásíndó súwana ");
INSERT INTO kze_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ísu séna kemó súndamo é'o é'a kwemó éna úwoi maambárárá máyaina'a kemá kumónaumnemo súndamo énamo éna íma endéín-ivo kendéímán-iye. emá kesirááíma kwaraaó Ísu súwasa ");
INSERT INTO kze_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","kwená kwayó-kwáásí íma kawe'á umái ísónkakemba sésa kwemá íma puwíníye sésa simátíma'mae kuwaná kwemá íma puwíníye Ísu íma mirá siráimbanivo kwemó éna úwoi máyaina'a kemó kumónaumnemo súndamo énamo éna íma endéín-iye Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","íma puwíníyemo siráan-kwaasi kemá Yóni úne. mináímbá kwésimatimatuwe'a aúváívimba kwéagaisuwaunda mináímbá árair-aimban-iye. ");
INSERT INTO kze_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ísumo mairáim-bayaima évaka'a agaé'a évaka'a íma agairáunda pó'a amápa'o agaisuwé'o é'a maranéí káátamaranaumpo náávara maránaumno sé'a súne. kemá Yóni súnda-aimba ánásaiye. ");
INSERT INTO kze_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tíóvíráasiyo ívé-kwandaaivimba moórá-kwasai sénaumpo isaaó. aiva-kwándááívímbá Áánútu Ísumba ai'marówana marapá'á kunkáin-ainkwara mayáímá kumbairáin-ainkwara aaimá siráin-ainkwara avumpimbá amápa'-mayaima mairáinkwara'a komaé tamae umái kwená mayáí marapá'á ánásowana ");
INSERT INTO kze_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Áánútu kunairówana kwíyómpa'a iráin-ainkwara'a aiva-kwándááívímbá agaimakáunda isa'á ívé-kwandaaivinkwara'a agaimaráúmpo isaaó. Ísu kesí aantá-kwaasiye séna ítámakaiye. Ísu íma kwíyómpa'a irónka'a Áánútun-amankona asirayánkwárá'á ména aantá-kwaasi kwená ámáámba simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ísu pukáimpinkemba usásinena kae-kwááí aíyayaan-kanaama 40 kanaama moórá-mora-tawai paárurena kwenáúma kawe'á umái agaráátinkowasa awánésa sésa árai'a Ísu pukáimpinkemba usásinena máyáiye suwaná paáruronka'a Áánútu kwená kwaásimo kawááin-aimba simátíma'maena iráiye. ");
INSERT INTO kze_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","moórá-tawai torupésa toómbá kwénowana Ísu paáréna séna maanká'á Yérúsaremu-naopa'a íma tuwé'a úwoi mé'a kesivo kesimambá timénaumnemo asiramái siráimba kwéamu'mare'a máyáanana úwoi timíno. mináímbá á'a simátime'a sé'a ");
INSERT INTO kze_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yóni nombá pétinkaraimbanivo sáwíyanka'a Áánútun-amanko kuména keinárawapimba anómba umátinkanivo amu'maré'a máéro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Óríve-omapa'a Ísuwe aantá-kwaasiye torupésa Ísumba áísaa esa sésa Ísóigoo ívéra Árómáani-kamaani-kwaasi ti'mátuwewa Ísareri-kwaasiya kawáá íníyono suwaná ");
INSERT INTO kze_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ísu séna moórá-kanaamo tínímba ívéra'i. aánowa'iyo. Áánútu kwená imáyáavinkemba mirá íníye. kawe-kánáámó sáwí-kanaamo paárinimba Áánútu kwená imáyáavinkemba mirá íníye. mirán-kánáámó tínímba sáwíyan-aimbanivo ");
INSERT INTO kze_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kemó sendá anón-aimbanivo ísáaro. Áánútun-amankoma kentópa'a kúmínimba kwená asirayámbá tirumpimbá anómba umátinkaina'a kesááigwara kentáváígwárá'á simátime'a Yérúsaremu-naopare Yútiyaa-ayampare Sámériyaa-ayampare amápar-ayampare kosimátíma'mae'a nááóro ");
INSERT INTO kze_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ísu simásuwowasa awánomba Áánútu Ísumba kunairówana ainánkó Ísumba káátaguwasa íma awánowana ");
INSERT INTO kze_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ísumo iyúmba kwíyómpa'a karátuwesa máyówasarai avekáán-umai kae-kwáásí kwayán-únánkwátói úmaesarai egwaa'á mésarai ");
INSERT INTO kze_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","sésarai Káríri-ayampaken-kwaasiyono. íma kwíyómpa'a karátuwe'a máéro. awánaawanamo Áánútu kunairáísanamo kwíyómpa'o íyínten-umai ókwara'a miráumai kumíníye sirááiye. ");
INSERT INTO kze_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","mindárai simásúwóyasa aantá-kwaasi Óríve-omapa Yérúsaremu-naor-egwaar-omapa'a tuwésa Yérúsaremu-naopa'a koyauwerésa ");
INSERT INTO kze_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","máyón-daumpa'a ávúmayaatanaan-daumpa'a umésa miwímá Ísuna aantá-kwaasi moórá-morawai túwí'a Pítaawe Yóniye Yémésiye Éndaruwe Vírípiye Tómáasiye Pátóromuwe Mátíyuwe Árávíási ááninko áwí'a Yémésiye moóráwai kwemá Árómáani-kamaani-kwaasi ti'mátuwanae siráiwai áwí'a Sáímoniye moóráwai ó'on-Yemesi ááninko áwí'a Yútásiye miráumai-kwaasi aantá-kwaasi ");
INSERT INTO kze_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","tayorupontembá námúnaa seémáémbani. minkwáásíyónté évakar-inintone Ísumba anówawe Ísun-ává'awaawiye tayorupamái mésa námúnaa seémáémbani. ");
INSERT INTO kze_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","námúnaa síma-sima kwéesa moórá-kanaama sáwíva-kwaasi 120 kwaasi Ísun-aaiyavesa áraire siráan-kwaasi tayorupamái máyówana Pítaa usásinena simátimena séna ");
INSERT INTO kze_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","kesí kwaásiyono. naaóvá'á Áánútun-amankoma kentáá síkwá'náomba áwí'a Tévítimba simámena Yútási-aai súwana agaimakáimba póna mináímbá paáriniye. ááéma kentááyáváíyé Yútásintavaiye Ísu kesí mayáí máyáaro séna ításinkowata aantá-kwaasiti mayáí-íta umáíya mairáúndayaawe. naaémba Yútási tí'maena Ísunopa'a túwasa táto'mai áí'maesa ándávimba ánkaraawe.  ");
INSERT INTO kze_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yútási misáwí-máyáígóná meéyámbá óntamba mairéna maramá meéyán-umasuwena mimbárává'á ándáma uréna kweyááríka'a kwenanumarambá arátuwena ámú'a kuvánkaar-úwana ayánaruntomba marapátá kunturáíye. ");
INSERT INTO kze_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yérúsaremuvaken-kwaasi isésa miwí tááivinkemba mimbárágó áwí'a Akeotaava'an-iye sésa kwántámai-kwi'a naae-márává'án-iye siráawe. ");
INSERT INTO kze_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ánivo monor-ímó agaimakón-auvai-kwandaaivimba Tévíti agaimaréna séna kwená naambá tu'nambá isasá mimpímbá íma kwaási kwégwaewe agaimaréna séna moóráva'a agaimaréna séna kwená mayáírá'á moóráwai usámayaniye agaimaréna sirónka'a póta ");
INSERT INTO kze_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","moóráwai Yútásina mayáírá'á usámayaniwaimba avakáá-umaiya airánaundayaawe. Ísu Káráísitima pukáimpinkemba usásinkain-aimba kweséya tásáumai simátíma'maeta kónaunda póta Yóni nombá kwévetinkowana Ísu mayáímá ááimba ásámai mayówata kuré-ire úmae kwénaaowananaya Áánútu Ísumba kunairówana kwíyómpa'a iyúwasa awánaraawaivinkemba moóráwaimba aíráananaya kwemá Yútásimo tukáim-bayai usámayaniye Pítaa simásuwowasa ");
INSERT INTO kze_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","isésa kae-kwáásí túwí'a tésa moóráwai kaumbo-kwí'á tamámakaawai moórá-awi'a Yósépi moórá-awi'a Paasapasí moórá-awi'a Yásátasi uwaná moóráwai áwí'a Mátáyáasi miráumai-kwaasirai túwí'a tamásuwesa ");
INSERT INTO kze_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","námúnaa sésa Ísóigoo amápa-kwaasiti imáyáa awáné tirumbá tuwáné minkáé-kwáásívínkémbá nááwa Yútásina mayáí aantá-kwaasiti mayáírá'á usámayaniyo. agaráásínkénata awánaano. ");
INSERT INTO kze_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yútási kwená mayáí ivátuwena puwéna kwená mayáígóná meéyámbá sáwí-marupa'a kunkáiye sésa ");
INSERT INTO kze_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","námúnaa simásuwesa kae-kwáásí túwí'a kae-kwándááívímbá agaimái anavéúmpímbá kuvé'makowana moóráwai moórá-kwandaai mósá mairéna awánómba Mátáyáasiye sésa agaimakówana aantá-kwaasi sísamaivakemba moórá kumbaimái-kwaasivimba komayáí mairáiye. ");
INSERT INTO kze_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","naaémba toómbá áká'mai Áánútuntavesa ísámai kaunánáe sésa torupaan-kánáámá túwasa Ísun-aaiyavesa áraire siráawai amápa'a mimbórá-náúmpá'á torupamái máyówana ");
INSERT INTO kze_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","avekáán-úwana kwíyómpakemba anón-undaraamba torówasa kwéisowana máyón-daumpa'a kuména móanoni'a úwana ");
INSERT INTO kze_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","iraronkáán-tántáá'á paárurena taaínkaar-umai moórá-mora-kwaasi tinepimpá'á kóyáwé úwana ");
INSERT INTO kze_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Áánútun-amankoma tirumpimbá anómba umátinkowasa máyówana Áánútun-amankoma asirayámbá timúwasa ó'on-o'on-kwaasi tááivinkemba siráawe. ");
INSERT INTO kze_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","toómbá áká'mai Áánútuntavesa ísámai kaunánáe sésa torupaan-kánáá túntavesa Yútaa-kwaasi Áánútuna imáyáa mósá márówai ó'on-o'om-baravakemba Yérúsaremu-naopa'a tayorupamái máyówana ");
INSERT INTO kze_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","úndáraamba torónka'a isésa mindámbó kwáyopa'a tayorupowasá miwí tááivinkemba kwésuwasa isésa táátavai ésa ");
INSERT INTO kze_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ávááraumai imáyáa ésa sésa kwésewai amápa'a Kárírivakewai mináímbá kwésewain-owe sésa ");
INSERT INTO kze_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","moórá-morawai sésa kesááivinken-aine simásaraawe. ");
INSERT INTO kze_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","kesáámá évaka'a Páátiyaa-maravakewaiya évaka'a Mítiyaa-maravakewaiya évaka'a Iramu-márávákéwáíyá évaka'a Mésópótemiyaa-maravakewaiya évaka'a Yútiyaa-maravakewaiya évaka'a Kápátósiyaa-maravakewaiya évaka'a Pontasi-márávákéwáíyá évaka'a Ésiyaa-maravakewaiya ");
INSERT INTO kze_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","évaka'a Vírísiyaa-maravakewaiye évaka'a Pámpíriyaa-maravakewaiya évaka'a Ísípi-maravakewaiya évaka'a Árípiyaa-maravakewaiya Sáíríni-maragona egwaakéwáíyá évaka'a Árómáa-naopakewaiya miráumai-naopakemba tayorupamái méta ");
INSERT INTO kze_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Árómáa-naopakewaiya évaka'a Yútaa-kwaasiya évaka'a á'on-ampa'a tuwéta Yútaa-monor-ampata kwégwareta ánivo évaka'a Kíríti-maravakewaiya évaka'a Árépiyaa-maravakewaiya tayorupamái máyaunasaya Áánútu kawe'-máyáí mairáin-aimba kwésesa moórá-morawai kesááivinkenta kwésewata kwéisaundayaawe sésa ");
INSERT INTO kze_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","táátavai ésa ávááran-imayaa ésa iséise ésa sésa mintántáákóná ááimba náára íníyo suwasá ");
INSERT INTO kze_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","évakarawai kwíráái sésa miwí uwoaó'-nómbá nésa uwoaó'á ésa ó'on-o'on-kwaasi tááivinkemba kwésewe siráawe. ");
INSERT INTO kze_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","simásúwówana aantá-kwaasi 11 kwaasi usásinompimba Pítaa usásimbai ména torupamái máyón-kwaasiyavena anónka'a simátimena séna kesí Yútaa-kwaasiyono. Yérúsaremu-naopaken-kwaasiye ó'om-baravaken-Yutaa-kwaasiye maísáaro. Kárírivakewai ó'on-o'on-kwaasi tááivinkemba kwésewaina ááimba simátimumpo ísáaro. ");
INSERT INTO kze_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","uwoaó'-nómbó nésa uwoaó'ó owémó kwésemba minkwáásí íma uwoaó'á kwéowe. kwaási no'wáámba uwoaó'-nómbá nésa uwoaó'á kwéovo ívé'a aaváyaavimba isasá minkwáásí íma uwoaó'á kwéowe. mintántáákóná ááimba maará ínívo ");
INSERT INTO kze_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","naaóvá'á Áánútun-aai simátímakowai áwí'a Yóweri agaimaréna siráin-aimba kwévaariye. maarán-áímbá agaimaréna séna ");
INSERT INTO kze_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Áánútu séna naaén-kanaa maará ónaumne. kesimambó amáparawaimo timénaunda kentáánimbaare kentiyáámúmbaare kesáái avora'á simátimenaaowe. kentí ívé-kwaasiye anónutan-kwaasiye kaaimbá awánanaaowe. ");
INSERT INTO kze_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","árai'a minkánáárá'á kesimambá kesí kwayór-ínínákwá'á timénaunda kesáái avora'á simátimenaaowe. ");
INSERT INTO kze_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","kwíyómpa'a marapá'á ó'on-o'om-bayai-awaame'a ónaunda naaegwárá iragwárá anón-umunkwara'a paáriniye. ");
INSERT INTO kze_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","aaváúmá tunínana kwíyómba naaerírí'a váína'a mirámó ónaunda kesí ó'on-o'on-kanaa ságayan-kanaama paárinimba ");
INSERT INTO kze_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","kentávésamo Ísóigowemo síyawaima sáwí'o umáímo maíyampinkemba kawer-ámpá'á métinkanaumne Áánútu siráiye Yóweri agaimaréna siráiye Pítaa mináímbá simásuwena ");
INSERT INTO kze_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","séna Ísareri-kwaasiyono. senda-áímbá ísáaro. Áánútuma Ísumba Násáretivakewaimba asirayámbá amúwana simámakaim-bayai maéna kawe'-máyáí ó'on-o'om-bayai-awaame'a uráimba keinárawapimba úmba awánaraawe. ");
INSERT INTO kze_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","naaóvá'á Áánútu imáyáamo éna mirá-mira ónaumnemo siráinka'a pósa évakarawai Ísumba áí'mai keinárawa'a tímúwa'a tuvuwónáe sé'a sáwí-kwaasi tímúwasa áí'maesa taaira'á tuvúwúwana puwúmbanivo ");
INSERT INTO kze_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Áánútu pukáimpinkemba usásinankaraiye. pukéna marapá'á maígómá íma kanaán-umai tátorowana Áánútu Ísumba ayúrankowana pukáimpinkemba usásinkaiye. ");
INSERT INTO kze_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","mindáyavena naaóvá'á kentáá síkwá'náo áwí'a Tévíti Ísun-aai agaimaréna séna aasiyaasí Ísóigo kesé máyáísa'a awánaraumne. kwemá sirávaimai máyáimba pó'a íma sáwí-imayaa kwéune. ");
INSERT INTO kze_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","mindáyave'a kesirumbá kawe'á umái mé'a Áánútu áwí'a mósá kwémaraumne. púwón-ayampa'a kesimambá íma másiyuwaniyone. kesirumbá ámakaundawaima ená kwayó-kwáásí únda po puképa'a íma másiyuwenana súma kaviráníye. mindáyave'a máyaunda pó'a imáyáa é'a púwóndavinkemba usásisinkaniye. ");
INSERT INTO kze_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","púwíndavinkemba usásine maí'mai'a íníyone séma kesé máyaanda póna kesirumbá kawe'á umái anómba ína'a ménaumne Tévíti agaimaréna siráiye Pítaa mináímbá simásuwena séna ");
INSERT INTO kze_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","kesí kwaásiyono. kentáá síkwá'náo áwí'a Tévítin-aai avora'á simátimunda kwemó agaimakáimba íma kwesáváí siráiye. kwemá puwúwasa utámakowana kwená maravaraambá á'a awánaraamba póna agaimarómba íma kwesáváí siráiye. ");
INSERT INTO kze_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","naaóvá'á Áánútu séna Tévítimo kawááná'ó ménamo uráintemba moóráwai minákúmpákéwáí anondára'a kawááná'á méniye Áánútu siráimba Tévíti Áánútun-aai simátímakaiwai póna kwemá séna Áánútu siráin-aimba árai'a paáriniye Tévíti siráiye. ");
INSERT INTO kze_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tévíti Áánútumo naaémbo ínín-imayaa éna séna Áánútumo usásinkaiwaima Káráísiti kwemá puwíndavinkemba usásinaniye súntavena séna pukén-ayampa'a íma máuwainana áúma kaviráníye Tévíti súmba ");
INSERT INTO kze_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","mindá Ísuntavena siráiye. ánivo Áánútu Ísumba pukáimpinkemba usásinankowata áta awánaraundayaawe. ");
INSERT INTO kze_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Áánútu kunáí'maena anón-kwaasi póna ayáánúrapa'a asirayán-áyámpá'á móankena kwenamambá ámakaiye. avowámó árai'a kesimambá aménaumnemo siráimba ámakaisana kwenamambá kembá símakaimba kwéise'a kwésuwane'a kwéowe Pítaa mináímbá simásuwena séna ");
INSERT INTO kze_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tévíti íma kwíyómpa'a iráiwai séna kesí Ísóigontavena séna Áánútu séna kesiyáánúrapa'a asirayán-áyámpá'á mara'á ména'a ");
INSERT INTO kze_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ená namuro-kwáásí usáyaaitaanasa miwí ánásanaaowe Tévíti siráiye. kwemá íma kwíyómpa'a iráiwai póna kwesáváí íma siráiye. ");
INSERT INTO kze_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ánivo keinárawa'a taaira'á tuvúkáawaintavena Áánútu séna kemá usásinankaundawai Káráísiti éna Ísóigoma iyémá Áánútu siráimba pósa Ísareri-kwaasi amáparawai kawe'á umái ísáaro Pítaa simásuwowasa ");
INSERT INTO kze_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ísómba tirumbá umbaí tówasa Pítaawe aantá-kwaasiyavaiye sésa sáwí'a uráumpo nóra ónaunanayaawa siíyó suwaná ");
INSERT INTO kze_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pítaa séna keinárawa'a moórá-morawai amáparawai misáwí-ímáyáá tínaaemba umáme'a Áánútunopa'a té'a Ísu Káráísitintave'a ísámai nombá péráaro. mindáyavena kentí sáwí-imayaa maitiyuwéna Áánútun-amankomba úwoi timíníye. ");
INSERT INTO kze_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Áánútu kesópa'a terómó sendawáímá kesimambá timénaumne Áánútu siráimba pósa keinárawatavaiye kentíráá'maatavaiye ó'on-o'om-baravakewaiyavaiye asirayán-áímbá siráiye Pítaa siráiye. ");
INSERT INTO kze_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pítaa simásuwena ó'on-o'on-ainkwara kawer-áínkwárá'á simásuwena égési umái simátimena séna ívé'o sáwí-kwaasi méwaimo é'a sáwí-meyamba mayánááowe. kemá ívé'a sáwí-ampa'a tuwé'a pó'a íma sáwí-meyamba mayánááowe Pítaa súwasa ");
INSERT INTO kze_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","sáwíva-kwaasi isésa kwenááiyavesa áraire sésa nombá kwéveresa mitáwai sáwíva-kwaasi 3,000 kwaasi Ísun-aaiyavesa árairemo suwasá Ísuna kwaási sáwíva-kwaasi-i'a ésa ");
INSERT INTO kze_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","torupamái maivá'á iyésa aantá-kwaasi Ísun-aai simátíma'mae kwáávantan-úmaesa kwéiyesa moórá-mora-umai-kwaasi kwétuwa'naa-esa Ísuntavesa ísámai aráá-tomba kwénesa námúnaa sinté iráawe. ");
INSERT INTO kze_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","námúnaa sinté iyésa mirámó umbá aantá-kwaasi kawe'-máyáí ó'on-o'om-bayaima kwémayowasa pósa amáparawai táátavai uwasá ");
INSERT INTO kze_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ísun-aaiyavesa áraire suwáí mimbórá-ímáyáá kwéesa torupanté kwéiyesa imáyáa ésa kentáásí náaindaamba amáparawainein-iye sésa ");
INSERT INTO kze_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","miwítí maramá miwítí náaindaamba ó'on-kwaasi timésa óntamba mairésa taaínkaar-umai ímo makón-kwaasi tímatuwesa ");
INSERT INTO kze_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","aasiyaasi-táwai Yútaa-kwaasiti anóm-bono'-naumpa'a Áánútuntavesa ísámai torupanté kwéiyesa ó'on-o'owiti naaúmpa'a komésa Ísuntavesa ísámai aráá-tomba kwénesa tirumbá kawe'á umái mésa toómbá taaínkaar-umai kwétimesa nésa ");
INSERT INTO kze_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Áánútu áwí'a mósá marówasa amáparawai tuwánésa miwíyávésa kawe'á kwéowe suwaná aasiyaasi-táwai Ísóigo évakarawai sáwí'o umáímo máyómpinkemba kawer-ámpá'á métinkowasa Ísun-aaiyavesa áraire suwáíyé torupamái méraawe. ");
INSERT INTO kze_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","2","moórá-kwaasi anówa maránkarompinkemba aísamaima pukurón-kwaasi máyowasa aasiyaasi-táwai áí'maesa anóm-bono'-nankona ontará'á áwí'a kawer-óntárá'á móankarowana ména anóm-bono'-naumpa'o íyún-kwaasiyavena óntantavai inaainaaí sún-kwaasi máyonka'a anóm-bono'-naumpa'a Pítaae Yóniye íyúyana aaváúmá toraétáápa'a kúwasa námúnaa kwésen-kanaara'a íyúyana ");
INSERT INTO kze_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","tuwánéna séna óntamba símékaiyo súwasarai ");
INSERT INTO kze_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","túramba kararésarai Pítaa séna kenkáí suwánaao suyaná ");
INSERT INTO kze_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","siméyááoiye-imayaa éna tuwánówana ");
INSERT INTO kze_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pítaa séna íma óntamba makáumpo Ísuna asirayándéí kawe'á umánkanaumne. Ísu Káráísitima Násáretivakewaina asirayámbá kwáyáintave'a sé'a usásine naauwó súne Pítaa séna ");
INSERT INTO kze_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ayáánúrapa'a táto'mai usásinankowana aísaumba aísána kawe'á úwana ");
INSERT INTO kze_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","usásinkwena tokávara taúvaraa'a éna aamoí éna Áánútu áwí'a mósá kwémarena mindáraiye anóm-bono'-naumpa'a ");
INSERT INTO kze_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","kweyááríka'a marapá'á iyéna Áánútu áwí'a mósá marówasa amáparawai awánésa ");
INSERT INTO kze_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sésa miwá aasiyaasi-táwai anóm-bono'-nankona kawer-óntárá'á ména óntan-inaai síma-sima'a indá'án-iye sésa táátavai ésa kweyááríka'a marapá'á kwéiyuntavesa tiyáámba tuvimpín-ésa táátavai uráawe. ");
INSERT INTO kze_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","kweyááríka'a kwéiyena aamoí éna Pítaante Yóninte tine'á tátorowasa amáparawai táátavai ésa miwítópa'a tóyo ésa anóm-bono'-naumpa'a Sórómoni áúgwimai úmakopa'a tóyo uwaná ");
INSERT INTO kze_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pítaa tuwánéna séna Ísareri-kwaasiyono. mintántáátáváí íma táá'a kaíno. íma túramba kenkáí aráá'a sivuwóro. íma kenkáísí asirayánkó kawe'á umái arupí umái mékai kwéuvo ");
INSERT INTO kze_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Áánútuna asirayánkó mirá kwéisana minkwáásí kweyááríka'a kwénaaiye. mirá uráintavai Áánútu Ísu áwí'a mósá maréna kentáá síkwá'ná Ááváramu Áísákaa Yákópo miwítí Ísóigoma kwená kwayó'nákó áwí'a Ísumba póna mósá makáiye. ánivo Ísumba áí'mae'a Árómáani-kamaani-kawaanako áwí'a Páírátinopa'a máánkarowana Páíráti séna ayúrankanae súwa'a a'áo siráawe. ");
INSERT INTO kze_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kawe-kwáásí arupí umái máyon-kwaasiyave'a a'áo sé'a moórá-kwaasi inkamúwana puwúwasa ándáva'a áúkon-kwaasiyave'a ayúrankaao siráawe. ");
INSERT INTO kze_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","mirá uráantave'a aúnái'a umái maí'mai'a ónááowaina ááin-kwaasi kemá tuvúwana pukáimpinkemba Áánútu usásinankowakai awánarauye. ");
INSERT INTO kze_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","awánarauyawai Ísuna asirayánkó aísamaima pukón-kwaasi kawe'á umánkaraiye. Ísuna asirayántávéna áraire siráimba isaná minkwáásí kawe'á umái kwénaaisa'a kwéawanaawe Pítaa siráiye. ");
INSERT INTO kze_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pítaa mináímbá simásuwena séna keinárawate kentí kawáánárawate íma awánamai Ísumba kawer-uré'a tuvukáawe. ");
INSERT INTO kze_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","naaóvá'á Áánútu kwenáái simátímakowaiyavena séna simátime'a sé'a kemó usásinankaundawaimba sáwí'a umánkanaaowe Áánútu siráinka'a póna keinárawa'o Ísumbo uráamba mináímbá paáruraiye. ");
INSERT INTO kze_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","mindáyave'a kentí sáwí-imayaa tínaaemba umásuwe'a Áánútunopa'a tíyana póna Áánútu kentí sáwí-imayaa maitiyuwáníye. ");
INSERT INTO kze_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","moórá-mora-tawai Ísóigo kwená asirayámbá timína'a kwesé ménaaontave'a kentí sáwí-imayaa tuwé'a Áánútunopa'a teró. Áánútuma túwa'naa ínkwáe séna usásinankaiwaimba Ísumba ai'maráínana kumíníntave'a kentí sáwí-imayaa tuwé'a Áánútunopa'a teró. ");
INSERT INTO kze_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ísu kwíyómpa'a umáyáimba póna naaén-kanaamo éna amápa-tantaa'a aúnái'o índa-tawai ókwara'a marapá'á kumíníye. naaóvá'á Áánútu mináímbá simátimuwasa Áánútun-aai ísón-kwaasi kawe-kwáásí isésa simátímakaawe. ");
INSERT INTO kze_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Áánútun-aai simátímakowai áwí'a Mósesi séna Áánútu kentí Ísóigo kembá kesí mayáí mayaaó séna si'mákainten-umai Áánútun-aaimo simátiminiwaimba keándárakemba moóráwaimba ai'maráínana kwenáái simátiminasa isánááowe. ");
INSERT INTO kze_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ímo isáíyawaimo éna Áánútu kwená kwaásivinkemba tí'maena moóráva'o tinkáindawai ánásanaaowe Mósesi siráiye. ");
INSERT INTO kze_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Áánútun-aai simátímakowai áwí'a Sámúwéri kwemá simátímakonka'a naaén-kwaasi simátímíntemba mai-simátíma'maesa iyémáyáamba kwévaariye. ");
INSERT INTO kze_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","naaóvá'á Áánútu kentáá síkwá'ná áwí'a Ááváramuntavena séna enándáraken-kwaasiyavena amápa'-marava-kwaasi kawe'á umátinkanaumne Áánútu asiramái siráiye. Ááváramun-andaraken-kwaasi owaná póna keinárawatavena Áánútu mináímbá asiramái siráiye. ");
INSERT INTO kze_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","miráumai Áánútu Ísuntavena kesí mayáí mayaaó séna ai'marówana keinárawapimba kunkáiye. amáparawai kentí sáwí-imayaa tínaaemba umásuwaiyana aiva'á keinárawa'a kawe'á umátinkanintavena keinárawapimba kunkáiye Pítaa Ísareri-kwaasiyavena simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","anóm-bono'-naumpa'a Pítaae Yóniye kwésimatimuyasa tóyo ésa mono'-máyáí-kwáásíyé mono'-nánká'ó kárákwirowaiye Sátúsi-monor-aimbo sun-kwáásíyé tóyo ésa ");
INSERT INTO kze_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","miwí táái taisésa áwáá'a suwasaráí mindárai Ísu pukáimpinkemba usásinkain-aimba simátímúyasa úwoi-kwaasi isésa sésa Ísu pukáimpinkemba usásinkaintavesa amápa-kwaasi pukémpinkemba usásinanaaowe suwasá mináímbá isésa kamparé sésa áwáá'a kwésesa ");
INSERT INTO kze_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","mindárai tátoresa sésa eénáimba póta aaváyaavimba aaivimbá maitinkánaumne sésa kawáá-kwáásí ándáva'a tínkómbanivo ");
INSERT INTO kze_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","úwoi-kwaasi sáwíva'a 5,000 kwaasi mindárai tááiyavesa árairema siráawe. ");
INSERT INTO kze_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","aaváyaavimba aaivimbá maitinkánaumne sésa kwáúmba aaváyaavimba Yérúsaremu-naopa'a Yútaa-kawaa-kwaasiye anón-kwaasiye ámáámba sun-kwáásíyé miráumai-kwaasi miwí táái isánáe sésa torupésa ");
INSERT INTO kze_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","aiva'-mónó-káwáánákó áwí'a Ánásiye kwená akún-ándá-kwáásíyé Káyavaasiye Yóniye Arekesándaawe torupamái mésa ");
INSERT INTO kze_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pítaante Yóninte tááyowasarai miwítópa'a tuyasá tísaa esa sésa aísamaimo pukáin-kwaasi nóra urááiyo. nááwana asirayáná keináraivimba kwáyáintavaiya kawe'á umánkaraaiyo. nááwa áwíra tékai kawe'á umánkaraaiyo suwaná ");
INSERT INTO kze_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Áánútun-amankoma kwempímbá anómba umánkowana Pítaa séna Ísareri-kawaa-kwaasiye anón-kwaasiye ísáaro. ");
INSERT INTO kze_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","aísamaimo pukáin-kwaasi kawe'á umánkaraundayave'a kwésisaa-owe. nóra séra kawe'ó umánkaraundayave'a kwésisaa-owe. ");
INSERT INTO kze_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","avora'á simátíménda keinárawate amápar-Isareri-kwaasiye ísáaro. Ísu Káráísitima Násáretivakewaimba taaira'á tuvúwówana Áánútu pukáimpinkemba usásinankaraiwaimba kwenáwíka'a súyana kwená asirayánkó minkwáásí kawe'á umánkáísana keinárawapimba kawe'á umái máyáísa'a kwéawanaawe. ");
INSERT INTO kze_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Áánútun-aai aúváí-kwandaaivimba Ísun-aai agaimaréna séna óntan-damba on-kwáásí moórá-ontantavesa sáwí'a kwéiye sésa maisukáawe. aáno minóntánkó ávonkaamba uráiye mináímbá Ísuntavena agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","kwewé su'mai sáwí'o umáímo máyáampinkemba kawer-ámpátá mésinkanintaawe. Áánútu séna kwenáwíkare su'mai kwená asirayánkówé su'mai kwaási sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaniye Pítaa siráiye. ");
INSERT INTO kze_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pítaa mináímbá kwésimatimena Pítaae Yóniye íma táá'a kwégowasarai asiramái simátímúyasa minkáwáá-kwáásí tuwánésa táátavai ésa mindáraimo úwoi-kwaasirai ímo aúváívimbo awánaroyawaiyavesa pósa táátavai ésa sésa Ísuwe kwénaauyantavesarai mirá kwéoiye sésa ");
INSERT INTO kze_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","awánomba Pítaante Yóninteyopa'a aísamaima kawe'á umánkaron-kwaasi máyowasa awánésa mindáraimo simátimenaaon-aintavesa avakáá uwááesa ivátiyuwesa ");
INSERT INTO kze_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","sésa máápa'a kúmókaiyo suwasaráí kúmúyasa minkáwáá-kwáásí iséise esa sésa ");
INSERT INTO kze_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","mindáraiye nóra ónaumno. ó'om-bayai kawe'-máyáímá mairááyamba pósa Yérúsaremuvaken-kwaasi amápa'a ísáamba póta íma kamparéyá sénaundayaanivo ");
INSERT INTO kze_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ó'on-o'on-daopaken-kwaasi íma isánááontaveta mindáraiyaveta simátimeta séta Ísu áwíka'a íma simátímékaiyo sénaundayaaniye sésa ");
INSERT INTO kze_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","tááyowasarai íyúyasa sésa Ísun-aai íma simátímékaiyo. Ísu áwí'a íma taakaiyó suwasaráí ");
INSERT INTO kze_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pítaae Yóniye sésarai kemó mirá simásinkaiyakaimo Áánútun-aaimo tuwékaimo Áánútu aúrampimba kawerá íníya ke mináímbá ókwara'a ísáaro. ");
INSERT INTO kze_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","keiráímá awárauyan-tantaa ísarauyan-tantaa'a íma tuwáyauvo úwoi simátimeyauye suyasá ");
INSERT INTO kze_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","kawáá-kwáásí ó'onkwara'a asiramái simátímatuwesa sésa ánivo úwoi kárúwaakaiyo sirá. aísamaima kawe'á umánkaron-kwaasi kae-kwááí aíyayaan-ira'a 40 ira'a íma kweyááríka'a kwénaauwasarai kawe'á umánkóyasa úwoi-kwaasi isésa Áánútu áwí'a mósá maróntavesa mindárai íma tínkamesa úwoi kárúwaakaiyo siráawe. ");
INSERT INTO kze_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","kárúwaakaiyo suwasaráí Pítaae Yóniye kentí kwaásitopa'a tésarai mono-káwáá-kwáásíyé anón-kwaasiye simátímakaan-aimba másimátímúyasa ");
INSERT INTO kze_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","isésa Áánútumpa'a námúnaa sésa Ísóigoo kwíyómba maramá uwí-nómbá tarórumarena miwán-arumpimba tarórumaraanda-yantaakakwara'a kwégawaa-one. ");
INSERT INTO kze_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","naaóvá'á emá sunaná enamankómá ená kwayó-kwáásí kentáá síkwá'náomba Tévítimba kusimámuwana agaimaréna maará séna nóintavai ó'om-baravakewai áwáá'a sésa nóintavai ámááyu-aimba suwááesa áúkaawe. ");
INSERT INTO kze_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ó'om-baravaken-kawaa-kwaasi tokwaa úmae tayorupésa Ísóigonte kwemó usásinkaiwainte áái'a tiyamátinkanae siráawe mináímbá Tévíti agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","mináímbá paárúwasa Yérúsaremu-naopa'a Érótiye Póntiyasi Páírátiye ó'onkaa-kwaasiye Ísareri-kwaasiye torupésa Ísuna ámááyu-aimba sésa emó usásinankaandawaimba ená kawe-kwáyó-kwáásí Ísuntavesa ámááyu-aimba siráawe. ");
INSERT INTO kze_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","naaóvá'ó emó mirá ónááowemo siráanda pósa torupésa mirá uráawe. emó ímo mirá ónááowemo siráandarakai íma Ísumba tuvúkáasino. ");
INSERT INTO kze_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ísóigoo mono-káwáá-kwáásí tááimo simáímo káráraamba ísaraanda po súwa'naa íníyonda póta íma inkaiséta enáái úwoi asiramái simátimenaundayaawe. ");
INSERT INTO kze_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ená asirayámbá símínata tí'o índa-kwaasiya asóvamatinkavata konó. ená kawe-kwáyó-kwáásígó áwí'a Ísuwe súnanaya kwená asirayánkó ó'on-o'om-bayaima kawe'-máyáímá paáriniye ");
INSERT INTO kze_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","námúnaa simásúwówana torupamái máyón-daumpa'a toraa'náára'a úwana Áánútun-amankoma miwívímbá anómba umátinkowasa Áánútun-aai asiramái simátíma'mae kuráawe. ");
INSERT INTO kze_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ísuna aampa'á kwéguwai mimbórá-ímáyáá kwéesa mésa kentí náaindaantavesa íma kendéí kendeiye kwésesa úwoi moórá-mora-umai tíma'maesa kuwasá ");
INSERT INTO kze_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","aantá-kwaasi ávááraumai asirayánkwárá'á mésa Ísu pukáimpinkemba usásinkain-aimba asiramái simátíma'maesa kwégwesa Áánútu aantá-kwaasi túwa'naa úntavesa kawe'-máyáí maimaé kwéguwasa ");
INSERT INTO kze_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ísuna aampa'á kwéguwai maramá naambá makówai ó'on-kwaasi kwétimesa óntamba mairésa aantá-kwaasi tímúwasa taaínkaar-umai íma makón-kwaasi tímakaamba pósa Ísuna aampa'á kwéguwai amápa-tantaa'a íma aáváán-túwówana ");
INSERT INTO kze_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","moóráwai áwí'a Yósépi póna kwegwárá'á mirá éna moórá-marama ó'on-kwaasigomba aména óntamba mairéna aantá-kwaasi tiména kwemá Árívái-andarakewai Sáíparasi-ayampakemba tamáyowasa aantá-kwaasi moórá áwí'a simámesa Kíríki tááivinkemba Páánápáasiye sésa kwántámai-kwi'a tirávayaina'a iyémó suwáímá minóntámbá tímakaiye. ");
INSERT INTO kze_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Páánápáasi minóntámbá tímúwasarai moóráwai áwí'a Ánánáesi awainínkó áwí'a Sáváerae mésarai moórá-marama ó'on-kwaasi kwétimesarai óntamba mairésarai ");
INSERT INTO kze_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","taaináyauyo-aimba awainínkómbá simámuwana mirá íníyone súwana minóntámbá taaínkaar-urena évaka'a kwesáváí maéna évaka'a maimaéna aantá-kwaasi mói tiména kampa'á séna amápa'a timúne súwana ");
INSERT INTO kze_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pítaa séna Ánánáesiyo Sáátáánigo áísaa umai isánáe sintáváí owé se mararákén-óntámbá amápa'a timúne siráanda Áánútun-amankomba kampa'á simáukaane. ");
INSERT INTO kze_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","mimbárámá ená maramá isa tuwé óntamba mairé ená óntamba isa évaka'a timé íma sáwí'a éma mararákén-óntámbá évaka'a timúne íma sénda amápa'a timúne séndama sáwí'a ómpo íma kwaásiye su'mai kampa'á simátíyukaampo Áánútun-amankomba kampa'á simáukaane Pítaa súwana ");
INSERT INTO kze_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ánánáesi iséna pu'maéna tuvamúwasa mináímbá ísaraan-kwaasi ávááraumai táátavai uwasá ");
INSERT INTO kze_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ívé-kwaasi tésa puwúmba taasááúmaesa maimaésa máutaraawe. ");
INSERT INTO kze_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","máutaawana awainínkó sáwíyanka'a ména awaikómó puwún-aimba íma ísarena Pítaa-iyaitopa'a túwana ");
INSERT INTO kze_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pítaa séna keináraiti mararákén-óntámbá amápara símakaiyo súwana minínínkó séna owé amápa'an-iye kampa'á súwana ");
INSERT INTO kze_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pítaa séna enawaikóe esé mimbórá-ímáyáá ékai Ísóigon-amankomba kampa'á simáu'mai awánayae sirááiye. enawai'ó mágwéutaan-kwaasi tésa embá tamaimaésa máutanaaowe Pítaa súwana ");
INSERT INTO kze_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","pu'maéna Pítaa aísamaivimba tuvamúwasa ívé-kwaasi tésa puwúmba taawánésa maimaésa awaikómbó utamánkópa'a máutowasa ");
INSERT INTO kze_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ísóigona kwaásiye ó'on-kwaasiye isésa táátavai uráawe. ");
INSERT INTO kze_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","aantá-kwaasi kwaási túranka'a ó'on-o'om-bayai kawe'-máyáímá maimaésa íyúwasa Ísuna aampa'á kwéguwai anóm-bono'-namba Sórómoni áúgwimai úmakopa'a aasiyaaí torupamái kwémauwasa ");
INSERT INTO kze_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","ó'on-o'on-akwa'a sáwíva'a Ísóigon-aaiyavesa áraire sésa miwísé torupamái maémáémbanivo ó'on-kwaasi tuwánésa sésa kawe-kwáásín-owe sésa táátavai ésa íma miwísé torupamái máyówasa ");
INSERT INTO kze_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","aantá-kwaasimo uráamba isésa tí'o ún-kwaasi tuvaipímbá taagwiya'maésa naambáru'a mátinkesa sésa Pítaa kwénaaena amankó'naanko taaugwétáínasa asóvaigwae suwasá ");
INSERT INTO kze_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ó'on-o'on-daopakemba tí'o ún-kwaasigwara tirumpimbá taraváá-kwámbá máyon-kwaasigwara'a tí'maesa Yérúsaremu-naopa'a mátínkówana Áánútu Pítaamba áwa'naa úwasa amápa'a asóvasaraawe. ");
INSERT INTO kze_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","mirá kwéuwana aiva'-mónó-káwáánákóe kwená kwaási Sátúsi-monor-aimbo sun-kwáásíyé sésa amáparawai íma kentáásiraaima kwáráavo aantá-kwaasi tirááíma kwáráawe sésa tíyántavai ésa ");
INSERT INTO kze_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","táto'mai ándáva'a tiyúwówana ");
INSERT INTO kze_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","mindó'wáámbá kwáúnka'a Ísóigona kwayó'nákó kwíyómpakendako ontamá tisuwéna tí'maena máápa'a móruntinkena séna ");
INSERT INTO kze_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","anóm-bono'-naumpa'a umé'a aúná-amba kwaási kawe'á umái maí'mai'a ónááon-ankona ááimba usimátíméro súwasa ");
INSERT INTO kze_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","isésa irataró'a anóm-bono'-naumpa'a umésa mináímbá simátímakaawe. anóm-bono'-naumpa'a moóráva'a kwésimatimuwasa moóráva'a aiva'-mónó-káwáánákóe kwená kwaásiye tésa ándá-kwaasi táái isánáe sésa Ísareri-anon-kwaasi tááyowasa tésa mono'-nánkár-í-kwáásíyávésa sésa aantá-kwaasi ándáva'a máyáavo kotí'mae'a teró suwasá ");
INSERT INTO kze_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","kumbá íma máyówasa koyauwerésa tésa sésa ");
INSERT INTO kze_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ándá-namba ontamá umásuwesa i-kwáásí ontará'á máyáawata onta tisuwéta awánáúndaya íma máyáawata úne suwasá ");
INSERT INTO kze_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","mono-káwáá-kwáásíyé mono'-nánká'ó kárákwirowaiye isésa táátavai ésa sésa mindá nóraya ónaundaya'iyo simásuwesa sáwívar-imayaa kwéuwana ");
INSERT INTO kze_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","moóráwai téna séna ándáva'a mátíyukaan-kwaasi anóm-bono'-naumpa'a mésa kwésimatimewa'a tuwánáúmne súwasa ");
INSERT INTO kze_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","mono'-nánká'ó kárákwirowaiye kwembó áwa'naa un-kwáásíyé kotí'maesa kwempa'á tésa sésa úwoi-kwaasi miwí táái isésa sínkamovo sésa kwempa'á ");
INSERT INTO kze_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","tí'maesa aaimó isáí-kwáásítópa'a mátínkówana aiva'-mónó-káwáánákó ");
INSERT INTO kze_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","séna á'a simátimeta séta minkwáásígón-áái kwenáwíka'a íma simátíma'mae'a koróyá siráundaya isa'á á'a simátíméwasa Yérúsaremuvaken-kwaasi amápa'a ísáyaraawa'a ke kampa-kúvímbá sinkéta minkwáásí tuvúkáawe kwésewe aiva'-mónó-káwáánákó súwasa ");
INSERT INTO kze_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pítaa-iyai ó'on-aanta-kwaasiyonkwara'a sésa Áánútun-aai aivar-áínkómá póna kwaási tááigomba usáyaaitaraimba póta kentááiya íya iséta Áánútun-aaiya iséta miráyá ónaumne. ");
INSERT INTO kze_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","keinárawa'a Ísumba taaira'á inkámúwana puwúwana kentáá síkwá'náona Ísóigo Áánútu Ísumba pukáimpinkemba usásinankena ");
INSERT INTO kze_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","séna anón-kwaasi póna sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaniye séna ayáánúrapa'a asirayán-áyámpá'á móankena Ísareri-kwaasi kentí sáwí-imayaa tuwé'a Áánútunopa'a tíyana kentí sáwí-imayaa maitiyuwáníye séna Áánútu Ísumba pukáimpinkemba usásinankena ayáánúrapa'a asirayán-áyámpá'á móankaraiye. ");
INSERT INTO kze_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","mináímbá iséta kawe'á umáíya kwésimatimunanaya Áánútun-amanko mináímbá kawe'á umái kwésimatimiye. Áánútuma kwenáái ísámai kawe'á kwéowai kwenamambá kwétimisana Áánútun-amanko mináímbá kwésimatimiye aantá-kwaasi siráawe. ");
INSERT INTO kze_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","simásúwówasa aaimó isáí-kwáásí isésa tirumbá sáwíte úwasa tínkamonae-imayaa uwaná ");
INSERT INTO kze_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","miwítí avumpinkémbá moóráwai usásinena ámáán-kawaa-kwaasigo áwí'a Kámérieri kwemá usásinena miwí táái káráyuwena kwemá Áánútun-aai aúváí-kwandaaivinkemba aasiyaasí simáti simati kwéuwasa kwenáwí'a mósá makáawai kwemá usásinena aantá-kwaasiyavena séna sáwíyanka'a máápa'a kumónááowe súwasa máápa'a kúmúwana ");
INSERT INTO kze_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","séna Ísareri-kwaasiyono. minkwáásíyáváí mirá ónáemo síyamba kakaariyá íma mirá é'a ísáíyuwe'a mirán-oro. ");
INSERT INTO kze_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ááéma moóráwai áwí'a Tiutaásí usásinena séna anón-kwaasi únda pó'a kesirááíye sé'a kwaránááowe súwasa sáwíva-kwaasi 400 kwaasi kwarówana moóráwai Tiutaásímbá tuvuwúwana puwúwasa kwembó kwa'maésamo nááún-kwaasi kóyáwé ésa kwená mayáí ivátukaawe. ");
INSERT INTO kze_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","minkákémbá túwí'o aawásó-tawai moóráwai Kárírivakewai áwí'a Yútási usásinena tááyowasa sáwíva-kwaasi kwenarááíma kwa'maésa kwéguwana moóráwai tuvuwúwana puwúwasa kwembó kwa'maésamo nááún-kwaasi kóyáwé umáguraawe. ");
INSERT INTO kze_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","mindáyavai imáyáa é'a minkwáásíyómbá íma ándáva'a mátiyuwe'a tíyúwéwasa máéro. miwítí mayáígóná ááimbo marará-kwáásítí imáyáavinkembo énamo éna ánásaniye. ");
INSERT INTO kze_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","miwítí mayáígóná ááimbo Áánútuna imáyáavinkembo ína'o é'a íma kanaán-umai karánááovo úwoi kwaíkwai'a íníye. Áánútumpakembo ína'o é'a minkwáásí sáwí'o umátinke'o é'a Áánútunkwara'a sáwí'a umánkanaaowe Kámérieri súwasa aaimó isáí-kwáásí isésa kwenááiyavesa owé sésa ");
INSERT INTO kze_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","aantá-kwaasi tááyowasa íyúwasa túwíruku'a nésa asiramái sésa Ísun-aai kwená asirayámbá íma simátíméro sésa ti'mákaawe. ");
INSERT INTO kze_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ti'márówasa kwéesa tigaeyáváí uráasina Áánútu imáyáa timúwana tirunkó kawe'á úwasa sésa Áánútu asirayámbá símakaisata Ísuntaveta asiramáíya máyaundaya pósa sí'o iní'a umásínkáantaanivo sirunkó kawetá isatá máyaumne aantá-kwaasi simásuwesa ");
INSERT INTO kze_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","aasiyaasi-táwai anóm-bono'-naumpa'a kwaásiti naúmpimpa'a Ísuna áséi-kwasai simátíma'maesa kwénaaesa Áánútumo usásinankaiwai Yútaa-kwaasiya kwéamu'maraundayawai kwemá Ísuman-iye sésa simátíma'maesa kuráawe. ");
INSERT INTO kze_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","simátíma'maesa kuwasá Ísun-aai isésa sáwíva-kwaasi kwená aampa'á kwégwesa máyónka'a Yútaa-kwaasi ó'om-baravaken-kwaasi Kíríki tááivinken-aimba sun-kwáásí Yérúsaremuva'a máyón-Yutaa-kwaasiyavesa í'ái tinkésa óntamba taaínkesa Kíríki-ketorinimba íma tímúnkakemba í'ái tínkówasa ");
INSERT INTO kze_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","mindáyavesa aantá-kwaasi Ísuna aampa'á kwéguwai amáparawai tááyowasa tuwasá sésa Áánútun-aai simátimunda-mayai tuwéta óntamba taaínkaar-umai timúnda-mayaimo máyáandaya uwóví'a ónaundayaawe sésa ");
INSERT INTO kze_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","keinárawapinkemba avakaeté-kwaasi túwí'o tewatá óntambo taaináí-máyáí timénaumne. mindárawa'a kawer-ímáyáágwárá-kwáásí Áánútun-amanko miwívímbá anómba umátínkáin-kwaasi túwí'a tewatá óntambo taaináí-máyáíyá timéta ");
INSERT INTO kze_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kesáá Áánútunopata námúnaa kwéseta Áánútun-aai simátíma'maeta kónaundayaawe aantá-kwaasi suwasá ");
INSERT INTO kze_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","isésa tirumbá kawe'á kwéuwasa avakaeté-kwaasi túwí'a tombá moóráwai áwí'a Sítíveni kwemá Áánútun-amanko kwempímbá anómba umánkowana Ísuntavai imáyáa umái asiraiwáí úwana moóráwai áwí'a Vírípi úwana moóráwai áwí'a Pórókórasi úwana moóráwai áwí'a Náíkéna úwana moóráwai áwí'a Táímóno úwana moóráwai áwí'a Páménasi úwana moóráwai áwí'a Níkóráasi kwemá Ántíoku-naopaken-kwaasi póna ó'on-ampakemba Yútaa-monor-ampa'a kuréna minkákémbá Ísuna aampa'á kwétuwai úwasa ");
INSERT INTO kze_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","miráumai-kwaasi tí'mai aantá-kwaasitopa'a móitinkowasa Ísóigona mayáí mayóntavesa tine'á tátokesa Áánútumpa'a námúnaa siráawe. ");
INSERT INTO kze_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Áánútun-aai simátíma'maesa kwéguwasa Yérúsaremu-naopaken-kwaasi sáwíva'a Ísuna aampa'á kwéguwasa Áánútuna mono'-náúmpá'á mayáí máyón-kwaasi sáwíva'a Ísun-aai isésa kwená aampa'á kwéguwasa miráumai kwégwesa sáwíva-kwaasi-i'a uráawe. ");
INSERT INTO kze_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ísóigo Sítívenimba áwa'naa úwana asirayánkwárá'á ména amápa-kwaasi túranka'a ó'on-o'om-bayai kawe'-máyáímá maéna máyowasa ");
INSERT INTO kze_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","moórá-tawai évakarawai Sítíveninopa'a tésa kampar-áíné-ímáyáá ésa kwesimá kwesiman-esa miwímá Yútaa-kwaasima pósa évakarawai Sáíríni-maravakewai évaka'a Arekesándiyaa-maravakewai évaka'a Sírísiyaa-maravakewai évaka'a Ésiyaa-maravakewai miráumai-mapaken-kwaasi mimbórá-mónó'-náúmpá'á mésa Sítíveninopa'a tésa kampar-áíné-ímáyáá ésa kwesimá kwesiman-umbanivo ");
INSERT INTO kze_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Áánútun-amanko Sítívenimba kawer-ímáyáá amúwana póna Sítívenin-aaigo miwí tááigomba usáyaaitowasa ");
INSERT INTO kze_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ivátuwesa kwésa aúpá'á óntamba torupamái évaka-kwaasi timésa sésa Sítíveni Mósesimba simái sáwí'a umánkena Áánútumba simái sáwí'a umánkaraisata ísaraumne. kosimátíméro suwasá ");
INSERT INTO kze_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","minkámpár-áímbá tasimátímúwasa úwoi-kwaasiye anón-kwaasiye ámáámba sun-kwáásíyé ísówana tirunkó sáwí'a úwasa Sítíveninopa'a tésa tayáto'mai áí'maesa monor-ánón-kwáásítópa'a máankesa ");
INSERT INTO kze_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","kampar-áímbó sun-kwáásí kotí'maesa mátínkówasa kampa'á sésa minkwáásígó anóm-bono'-namba simái sáwí'a úmae iyéna Mósesina ámáámba simái sáwí'a úmae iyéna ");
INSERT INTO kze_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","séna naaóvá'á Mósesimo ámáámbo simátímakain-amaamba Ísu Násáretivakewaima ivátuwena ó'on-amaamba kwésena Yútaa-kwaasiti anóm-bono'-namba tawísíyuwaniye Sítíveni siráiye. mirán-kámpár-áímbá kwésuwasa ");
INSERT INTO kze_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","amápa-kwaasi Sítívenimba awánomba kwíyómpakemba Áánútuna kwayó-kwáásí tóikaamba aúkówasa awánaraawe. ");
INSERT INTO kze_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","mirá simásúwówana aiva'-mónó-káwáánákó Sítívenimba áísaa ena séna kwésen-aimba árair-aina'i. kampar-áíná'iyo súwana ");
INSERT INTO kze_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sítíveni séna kesivoísáí kesuwaaísáíyó simátíménda ísáaro. naaóvá'á kentáá síkwá'náo Ááváramu íma Áránaava'a komáyonka'a Mésópótemiyaa-marava'a máyonka'a Áánútu asirayánkwáráwáí kuména ");
INSERT INTO kze_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ááváramuntavena séna ená maragwárá enamááraawigwara'a tiyuwé kwina'á moórá-marama agarááránkáandava'a koméniyone súwana ");
INSERT INTO kze_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","iséna mimbárámá Káútéa-kwaasiti maravá'á tuwéna teémena Áránaava'a tamáyowana avowá puwúwana Áánútu ai'marówana teémena maavá'á máyaundava'a túwana ");
INSERT INTO kze_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","minkánáá Áánútu íma maramá amúmba asiramái séna aáno maambárámá enkwárá enaísaavutantambo íyawaigwara'a timénaumne. Áánútumo súmba Ááváramu iyámpói íma maránkaronka'a mináímbá simámena ");
INSERT INTO kze_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","moórá-ainkwara'a séna enaísaavutantambo íyawai ó'on-kwaasiti maravá'á koméwasa umbai-máyáí timésa sáwí'a umátínkéwana sáwívar-ima 400 ima ánásaina'a ");
INSERT INTO kze_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","sáwí'o umátinkanaaowaima sáwí-meyamba timénaunda pósa enaísaavutantambo íyawai mimbárámá tuwésa maavá'á tésa kesí imáyáa mósá maránááowe séna ");
INSERT INTO kze_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","mináímbá naaóvá'á Áánútu Ááváramuntavena séna aáno maambárámá enkwárá enaísaavutantambo íyawaigwara'a timénaumne siráimba mináímbá simái tarúmarena póna túra'a kárámai araa'éna uwó Áánútu siráiye. súwana Ááváramu ména Áísákaamba ankéna avakaumboé-no'waamba kwaéna áúra'a kárámai araa'éna umánkowana Áísákaa anón-éna Yákópomba ankéna áúra'a kárámai araa'éna umánkowana Yákópo anón-éna sísamaivakemba kae'á kumbaimái-iyampoi tinkéna túra'a kárámai araa'éna umátínkáva'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","mirá umátínkáva'a kúwasa mináváráwáínónda tíváko áwí'a Yósépintavesa naaénkewai íma kentáárá'á kárákwiyiniye sésa tirumbá sáwí'a umánkesa áí'maesa ó'on-kwaasiva'a mátimesa óntamba máyówasa miwí Yósépimba áí'maesa kweémesa Ísípi-marava'a máánkówana Áánútu kwesé máyowasa ");
INSERT INTO kze_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","umbai-máyáí amésa sáwí'a umánkómbanivo Áánútu kwesé ména áwa'naa ena kawer-ímáyáá aména kwená umbai-yántáá'á ánásamankowana mimbárámá Ísípi-marara-kawaanako Yósépina kawer-ímáyáá iséna séna Ísípi-marava'a amápa-kwaasira'a kawe'á umái kárákwiye kesí náaindaanka'a mirán-uwo súwana kwemó súntemba kwéuwana ");
INSERT INTO kze_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","naaémba ayawaimá téna Ísípi-maravare Kénááni-maravare amápar-ayampa'a ayawaimá tówasa tááiyavai ésa kentáá síkwá'náyomba toómbá íma kentáávímbá kwéraiye. ");
INSERT INTO kze_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ísípi-marava'a toómbá kwáyáiye-aimba isáúmpo komeéyán-oro Yákópo séna áánimbaa'a ti'marówasa komeéyá úmaesa ");
INSERT INTO kze_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","tivowánópa'a tamáyówana mintómbá ánásowana ó'a kuwaná Yósépi miwítí egwaa'á tamaéna séna kemá Yósépi kentívá'a úne súwasa kesí imáyáao pukáane súndayaawe suwaná Ísípi-marara-kawaanako Yósépina ááimba iséna awaaísáí tuwánówana ");
INSERT INTO kze_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Yósépi awaaísáí simátimena kesivombá kosimámiyana ená akúmbá tí'mae Ísípiva'a tiyó Yósépi siyé. kosimáméro Yósépi súwana avowámá iséna kwená akúmbá 75 kwaasi tí'maena Ísípiva'a kawe'á umái komésa púwúwasa ");
INSERT INTO kze_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","naaémba miwí tísaavutomba tiyáántámba maimaé teémesa Sékémuva'a máutomba naaóvá'á Ááváramu Émon-andaraken-kwaasima óntamba tímatukom-barava'a máutaraawe. ");
INSERT INTO kze_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ánivo kentáá síkwá'náyomba Ísípi-marava'a komésa sáwíva-kwaasi agairáawe. Áánútu Ááváramuntavena asirayán-áímbá séna Kénááni-marama enaísaavutantambo íyawai timénaumne siróntemba timínín-kanaa ákíse únka'a ");
INSERT INTO kze_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","moóráwai Ísípi-marara-kawaanako Yósépimo naaóvá'ó pukóntavena kwená mayáí-áímbá íma ísarowai póna ");
INSERT INTO kze_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","kentáá síkwá'náya umbai-máyáí tiména maimái sáwí'a kwéumatinkowasa iyámpói máápa'a tiyuwówasa pukáawe. ");
INSERT INTO kze_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","iyámpóíyomba púwúwana minkánáávímbá Mósesi kawer-óígwárár-íyámpóí ánkarena anówama naaúmpa'a aúpá'á ánkarowana kaumbo-kwíyómbá putuwéna ");
INSERT INTO kze_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","máápa'a áí'maena móru ánkarowana Ísípi-kawaanako ayáámúnkoma awánómba aráái tówana kesáánine séna kárákwirowana anón-úwasa ");
INSERT INTO kze_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ísípi-kwaasi miwítí ááimba kwésimama'mae íyúwana Mósesi kwéisena anón-éna kwemó mayóm-bayaigoe kwenááigoe kawe'á uráiye. ");
INSERT INTO kze_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mósesi mirán-kwáásí ména kae-kwááí aíyayaan-ima 40 íma maisuwéna kesí kwaási Ísareri-kwaasi kotuwánanae séna kúmba ");
INSERT INTO kze_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ísípi-kwaasigo Ísareri-kwaasigomba sáwí'a umánkowana Mósesi tuwánéna Ísareri-kwaasi áwa'naa ena Ísípi-kwaasigomba tuvúwúwana puwúwana ");
INSERT INTO kze_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mósesi imáyáa éna séna Áánútu mimbáyáírátávéna usásisinkaraimba pó'a Ísípivakemba Ísareri-kwaasi tí'mae'a koónaunda mimbáyáíyávésa owé sénááowe siráimbanivo Ísareri-kwaasi íma mirán-ímáyáá uwaná ");
INSERT INTO kze_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mósesi kogwaéna usásinena kúmba Ísareri-kwaasi kaekó áái'a tíyóyana tuwánéna tiyoráínda-imayaa éna séna kae'náraiyo mimbórá-naoraama óívo áái'a tiyaáyavo súwana ");
INSERT INTO kze_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","aiva'ó ááimba'maimo tiyón-kwaasigo Mósesimba améntáyuwena séna nááwa embá usásinankaraisa kentáásí kawááí'a éwa aaiyá kwésimasimeno. ");
INSERT INTO kze_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","tíndaumo Ísípi-kwaasimo tuvuwónanamo puwéiraintena kembá mirá íníyono súwana ");
INSERT INTO kze_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mósesi iséna inkaiséna kweéme kweémena Mítíyani-marava'a ó'on-kwaaiti maapa'a koména kaer-íyámpóí matínkaraiye. ");
INSERT INTO kze_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Mósesi kaer-íyámpóí matinkéna ména kae-kwááí aíyayaan-ima 40 íma maisuwéna moórá-tawai kavóná-marava'a kwégwena Sáínai-omapa'a egwaa'á kwáyonka'a kwéguwana sáwíyan-taivinkemba irá kwégena íma mintáí kówana Áánútuna kwayó'ná'á kwíyómpakewaima mimpímbá máyowana mintáí íma kówana ");
INSERT INTO kze_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Mósesi awánéna anón-imayaa éna egwaa'á koména awánówana Áánútu séna enaíkwá'ná Ááváramune Áísákaane Yákópone miwítí Áánútu úne súwana Mósesi mináímbá iséna ayántámbá tówana úwoiva'a karakówana ");
INSERT INTO kze_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ísóigo séna máyaunda póna á'oram-barama kwáyáipa'an-ivo kawe'-márává'á méraapa'an-ivo maambárámá sáwí'a ónavainivo aísamai ánáamba ayútuwaao. ");
INSERT INTO kze_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ísípiva'a kesí kwaási sáwí'o kwéumatinkaawasamo ivi'ó kwétaamba tuwánáúnda pó'a túwa'naa ónaumpo usásinena'a ai'máráana kweéme kweéme Ísípiva'a kuré kesí kwaási Ísareri-kwaasi kótí'mae Kénááni-marava'a kwaaó Áánútu Mósesintavena siráiye. ");
INSERT INTO kze_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","kwembá Mósesimba Ísareri-kwaasi tínaaemba umánkesa sésa nááwa embá usásinankaraisa kentáásí kawááí'a éwa aaiyá kwésimasimeno siráawe. siráan-kwaasiyavena Áánútu mináímbá siráiye. kwembá Mósesintavena Áánútuna kwayó'ná'á kwíyómpakewaima sáwíyan-taivinkemba aaí simámakaiye. kwembá Mósesimba Áánútu kawáá-máyáí aména ai'marówana Ísípivakemba Ísareri-kwaasi kótí'maena Kénááni-marava'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","kwemá Mósesima Ísípiva'a ímo awárom-bayai ó'om-bayai mayówasa sésa úwoi tí'mae kóuwo suwaná tí'maena kúmba nonkó áwí'a naae-nóné supa'á kwéna ímo awárom-bayai kawe'-máyáí komaéna tí'maena kúmba kavóná-marava'a kae-kwááí aíyayaan-ira'a 40 ira'a komáyówana ímo awárom-bayai kawe'-máyáí maimaéna iráiye. ");
INSERT INTO kze_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","kwemá Mósesima simátimena séna Áánútumo kembó usásisinkarainten-umai naaémba moóráwaimba kentísaavutantambo íyawaivinkemba usásinankaniye. Áánútun-aai simátiminiwaimba usásinankaniye. ");
INSERT INTO kze_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","kwemá Mósesima kavóná-marava'o Áánútuna kwaási Ísareri-kwaasimo méraapa'a miwísé ména kentáá síkwá'náyonte ména Áánútuna kwayó'ná'á kwíyómpakewai kwesé ména Sáínai-omapa'a umáyowana Áánútuna kwayó'ná'á kwíyómpakewai Áánútuna ámáámba simámuwana ímo ánásai-aimba simámuwasa simátíma'maesa kuráanta kwéisaumne. ");
INSERT INTO kze_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mósesin-aai simátímúmba kentáá síkwá'ná íma isésa tínaaemba umámesa Ísípiva'a tayauweránáe-imayaa uwaná ");
INSERT INTO kze_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","naaémba Áánútu Mósesimba ááyowana omápa'a umáyowasa Mósesi awaaó áwí'a Érónintavesa sésa Mósesi Ísípivakembo síkaiwaiya náávara kóuraiyo. íma awánáúndavata kóuraivo moórá-isoigomba tarórúmarewata kwenarááíya kwáráano sésa ");
INSERT INTO kze_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","óntandankakemba purumakan-áráákaamba úmaresa minkámpár-ísóígóná aamoimá umánkesa póíma tuvú'mái kwénesa úmakon-tantaatavesa aamoí ésa toóní'a umái kwénowana ");
INSERT INTO kze_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","mindáyavena Áánútu ánaaemba umátiyuwowasa kwíyóntavesa aaváúyávésa otávésa kesí ísóigoman-iye siráawe. mindáyavena naaóvá'á Áánútun-aai simátímakowai agaimaréna séna Ísareri-kwaasiyono. kavóná-marava'a kae-kwááí aíyayaan-ira'a 40 ira'a mé'a póíma tuvú'mái neémáémba íma kentávé'a ísámai neémáémbanivo ");
INSERT INTO kze_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","kentí kampar-ísóígóntávé'a ísámai kwená ampanta-námbá maimaé'a kwénaaowe. minkámpár-ísóígó áwí'a Mórókowe siráawe. okáán-tántáá'á tarórumake'a áwí'a Erevááníyé kwése'a toré kwénaaowe. minkámpá-káér-ísóíráí úmare'a kesí ísóigowe kampa'á sé'a áwí'a maé kwéiyowe. mirá uráantave'a kentí maravákémbá ti'máráana'a kweéme'a moórá-marava'a áwí'a Pépíróni-marava'a koménaaowe Áánútun-aai simátímakowai agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","naaóvá'á kavóná-marava'a Áánútu Mósesimba agaráárankena Áánútuna naambó ampantará'ó ónááomba maará ónááowe séna agaráárankowasa Áánútumo súntemba mirán-dámbá umái maimaésa kavóná-marava'a kwénaaowe. ");
INSERT INTO kze_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","naaémba miwí táánimbaa'a kentáá síkwá'náyomba mindámbá maimáyówana Yósúwa tí'maena Kénááni-marava'a kúmba Áánútu túwa'naa ena mimbárává'ó máyón-kwaasi kwatuwówasa kóuwasa koyavíresa mindámbá minká'á mámaresa máyówana naaémba Tévíti Ísareri-kwaasiti kawááná'á máyompimba mindámbá úwoi kwáyowana ");
INSERT INTO kze_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tévíti kawe'á umái máyowana Áánútu aamoí umánkowana Tévíti Áánútumba áísaa ena séna ená naambá ónaum. íya ónaumno. emá Yákópona Ísóigoma po owé sina'ó é'a ená naambá ónaumne súwana ");
INSERT INTO kze_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Áánútu séna emá íma íníyompo enááninko Sórómoni kesí naambá íníye siráimbanivo ");
INSERT INTO kze_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Áánútu kwíyómpa'o máyáimba kwaási úmakaan-daumpa'a íma máyáiye. mindáyavena naaóvá'á Áánútun-aai simátímakowai agaimaréna séna ");
INSERT INTO kze_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ísóigo séna kwíyómpa'a kárákwiye'a marará'á kárákwiyunda pó'a úmaraniyonda-naumpa'a íma úwoi marapá'á kumbénaumne. ");
INSERT INTO kze_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","kesáváí mintántáá'á amápa'a tarórumakaumne Ísóigo siráiye agaimaréna siráiye Sítíveni siráiye. Sítíveni mináímbá simátímatuwena aaimó isáí-kwáásíyáváí simátimena séna ");
INSERT INTO kze_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","keinárawa'a tirunté máráamba mé'a pó'a Áánútuna aampa'ó ímo kwáráan-kwaasiraani'a umái mé'a Áánútun-aai kwéisaambanivo íma ísámai kawe'á kwéowe. kentíkwá'náyomba Áánútun-amankomba tínaaemba umámemaentemba kemá mirá kwéowe. ");
INSERT INTO kze_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","kentíkwá'náyomba Áánútun-aai simátíma'maesa kwéguwai amáparawai sáwí'a umátinkesa Áánútuna kawe-kwáyóná'á kumíníye-aimba simátímakowai tínkamuwasa pukáawe. naaémba kwemá kumúwa'a kuntaru'á umái tuvúwúwana pukáiye. ");
INSERT INTO kze_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ánivo kwíyómpakewaima Áánútuna ámáámba simátímakowa'a keinárawa'a ísaraambanivo íma ísámai kawe'á uráawe Sítíveni siráiye. ");
INSERT INTO kze_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sítíveni mináímbá simátimumba aaimó isáí-kwáásí ávááraumai tirunkó sáwí'a úwasa i'naiyámbá mésa tíyántavesa uwaná ");
INSERT INTO kze_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sítívenimba Áánútun-amanko kwempímbá anómba umánkarowana kwíyómpa'a awánómba Áánútuna ságayamba kwáyowana Ísu ayáánúrapa'a asirayán-áyámpá'á máyowana Sítíveni awánéna ");
INSERT INTO kze_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","séna awánaaro. kwíyómba taaínkaar-isaná Áánútu ayáánúrapa'a asirayán-áyámpá'á Ísuma kwaási úrandako máyáimba awánaraumne súwasa ");
INSERT INTO kze_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","miwí anónka'a kwáá'a tésa kwenáái íma isánáe sésa tááka'a tiyáándei awááésa Sítívenimba tarááparaapa ésa ");
INSERT INTO kze_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","tátokesa taagwiya'maésa marur-awámpá'á máyuwesa óntamba mairésa tuvúkáawe. Sítívenintavesa kampar-áímbá siráawai paákár-únánkwátói ayútuwowana ívé-kwaasi áwí'a Sóro minúnánkwátói kárákwirowasa ");
INSERT INTO kze_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sítívenimba óntandei tuvúto'naa uwaná Ísóigonka'a námúnaavinkemba séna Ísu Ísóigoo kesimambá kumbaimaéna'a púwóno séna ");
INSERT INTO kze_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","arauntaúmbá airéna anónka'a séna Ísóigoo sáwí'a kwéumasinkaambanivo miwí íma sáwí'a umátinke miwítí sáwí-imayaa maitiyuwaaó Sítíveni simásuwena pukáiye. ");
INSERT INTO kze_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Sítívenimbo tuvúmba Sóro arunkó aamoí úmbanivo évakarawai Áánútun-aaiyavesamo asiramáímo máúwai Sítíveni áúma maimaé máutesa anón-ivi'a tombánivo Sóro Ísuna aampa'ó kwéguwai tínkambai ánásanae séna kúmba naaúmpimpakemba aarakwá'á koyavisimái ándáva'a tíyupa'a kúwasa Yérúsaremuva'a Ísuna aampa'ó kwéguwaima aivarí'a umái sáwí'a umátinkowasa kóyáwé uwasá aantá-kwaasiye su'mai Yérúsaremuva'a máyówasa ó'on-kwaasi Ísuna aampa'ó kun-kwáásí Yútiyaa-ayampa'a Sámériyaa-ayampa'a kóyáwé uráawe. ");
INSERT INTO kze_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ísuna aampa'ó kwéguwai kóyáwé ésa Ísuna áséi-kwasai kosimátíma'maesa kurá. ");
INSERT INTO kze_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Vírípi Sámériyaa-naopa'a kúmba kosimátimena séna Áánútumo usásinankaiwai amu'maráúndawaiyaamo á'o kunkáimba kwemá Ísuman-iye ");
INSERT INTO kze_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Vírípi simátimumba kawe'á umái ísówana ímo awánarom-bayai mayówasa awánowana ");
INSERT INTO kze_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","taraváá-kwámbá tirumpimbá máyówaiyavena aaí súwasa taraváá-kwámbá kwáá'a tumásuwesa kóuwasa kwaási kawe'á umái máyówana aíyayaamba pukón-kwaasi asóvamatinkowasa kawe'á umái mésa ");
INSERT INTO kze_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sámériyaavaken-kwaasi ávááraumai tirunkó kawe'á umái méraawe. ");
INSERT INTO kze_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sámériyaa-naopa'a moóráwai áwí'a Sáímoni ména anón-kwaasi úne séna pukaa'á agaimaéna kwéiyuwasa táátavai kwéesa ");
INSERT INTO kze_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","anón-kwaasiye úwoi-kwaasiye kwená mayáí awánésa kwenaráái kwégwaresa sésa Áánútuna asirayánkóe kwená asirayánkóe moórái'a uráiye kampa'á suwaná ");
INSERT INTO kze_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ayáátááka'a pukaa'á agaimaéna kwégum-bayai mayówasa kwenaráái kwégwaresa táátavai uráambanivo ");
INSERT INTO kze_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","naaémba Vírípi Áánútuna áséi-kwasai kosimátimena Áánútu kwená kwaási kwégawaain-kanaama kosimátimena Ísu Káráísitin-aai kosimátimuwasa isésa sésa árair-aimban-iye suwaná Vírípi minákwá'á nombá pétinkowana ");
INSERT INTO kze_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sáímoni kwegwárá'á áraire súntavai Vírípi nombá pérankowana Vírípiye kwénaauwana ímo awánóm-bayai mayówana awánéna áátavai uráiye. ");
INSERT INTO kze_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","mirámó Sámériyaava'o kwéumba Yérúsaremuva'a aantá-kwaasi mésa Sámériyaavaken-kwaasi Áánútuna áséi-kwasai isésa mináímbá méyatokaan-aimba isésa Pítaante Yóninte ti'márówasarai kweémesarai ");
INSERT INTO kze_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sámériyaava'a komésarai Ísuna aampa'ó kwéguwaiyavai ísámai námúnaavinkemba sésarai Áánútun-amankomba mayánááowe sirááiye. ");
INSERT INTO kze_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Vírípi nombá pétinkaronka'a Ísóigo Ísuntavena ísámai nombá pétinkowana Áánútun-amamba íma marómba pósarai Pítaae Yóniye námúnaavinkemba sésarai ");
INSERT INTO kze_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","tiyáámba tátoroyana Áánútun-amanko tirumpimbá kumúwasa mairáawe. ");
INSERT INTO kze_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","aantá-kwaasirai tiyáámba tátoroyana Áánútun-amanko tirumpimbá kumbaúwasa máyómba Sáímoni awánéna asirayámbá meéyámbaranae séna Pítaante Yóninteyavena séna óntamba maékai ");
INSERT INTO kze_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","minásíráyámbá simékaiyo. ó'on-kwaasi siyáámba tátoraanana Áánútun-amanko tirumpimbá kumbaínkwáe súwana ");
INSERT INTO kze_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pítaa séna Áánútu úwoi kwétimin-tantaatavai óntandei meéyán-ónáe sénda po ená óntankwara'a esé iravímbá ánásayaaoiye. ");
INSERT INTO kze_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Áánútu aúranka'a ená imáyáa íma arupí imbá po maambáyáí kenkáísí mayáí íma súwa'naa íníyone. ");
INSERT INTO kze_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ená sáwí-imayaagomba ánaaemba umásuwe Ísóigomba áísaa inaná ená sáwí-imayaagona anondá mayauwáníye. ");
INSERT INTO kze_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Áánútu íma asirayámbá ámakaintavai enarumbá sáwí'a umásinkaanana ená sáwí-imayaao anómba éna embá tátokaiye Pítaa súwana ");
INSERT INTO kze_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sáímonima Pítaante Yóninteyavena séna súwa'naa ékai Ísóigomba námúnaavinkemba áísaa íyana emó sénda misáwí-yántáá'á íma kempá'á tíno Sáímoni siráiye. ");
INSERT INTO kze_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","súwasarai Pítaae Yóniye Ísóigon-aai simátimesarai Ísuwe naaémáúyan-aimba simátimesarai Yérúsaremuva'a kónáe sésarai aampa'á kweémesarai Sámériyaa-ayampa'a naaó'-nao'a Áánútuna áséi-kwasai kosimátíma'maesarai kurááiye. ");
INSERT INTO kze_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","28","mindárai Yérúsaremuva'a kuyaná Vírípi Sámériyaava'a máyomba moóráwai anón-kwaasi Ítíópiyaa-maravakewai éna Ítíópiyaa-kwaasiti kawáá-ínínkó áwí'a Káándásina óntanka'a kárákwirowai Áánútuna imáyáa éna Yérúsaremuva'a kweémena Áánútu áwí'a mósá maréna koyauweréna kwená káárivimba anóm-poigo tavisímaena kún-kaarivimba kúmba Ísóigona kwayó'ná'á kwíyómpakewai Vírípintavena séna usásine Yérúsaremuvakemba Kásaava'a kwégon-ampa'a kwaaó súwana iséna usásinena minámpá'á kweémena kavóná-marava'a kúmba Ítíópiyaa-maravaken-anon-kwaasi kwená káárivimba kweémena aúváí-kwandaaivimba awánéna naaóvá'á Áánútun-aai simátímakowai áwí'a Áísáya agaimakón-aimba awánómba ");
INSERT INTO kze_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Áánútun-amanko Vírípintavena séna kwená káárigona egwaa'á kwaaó súwana ");
INSERT INTO kze_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","isaaísena kúmba Áísáya agaimakón-aimba táámpamai kwésuwana Vírípi iséna áísaa ena séna mináínkóná ááimba kwéisaano súwana ");
INSERT INTO kze_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","á'a moóráwai simásiminimba pó'a isánaumpo kesí káárivimba usáataao súwana Vírípi minkáárívímbá usáatena umaúwana ");
INSERT INTO kze_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","mináúváí-kwándááívínkén-áímbá táámpamai séna sipisípi áyáumo karánáesamo owanamó ímo kwáá'o tintembá minkwáásígó íma aaí siráiye. sipisípi tuvuwónáesamo owanamó ímo kwáá'o tintembá minkwáásígó íma aaí siráiye. ");
INSERT INTO kze_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","kwenáwí'a móruna tuwésa sáwí'a umái aaivimbá mayánkaraawe. kwená kwaási sáwí-mayai mairésa tuvuwówana marapá'á máyáin-kanaama ánásaraiye. mindáyavesa miwítí sáwí-mayai íma kanaán-umai avora'á simátimenaaowe agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ítíópiyaavaken-kwaasi mináímbá táámpamai simásuwena Vírípintavena áísaa ena séna Áánútun-aaimo simátímakowai nááwantavena mináímbá siráiyo. kwesávéna sirái. ó'owantavena siráiyo súwana ");
INSERT INTO kze_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Vírípi Áánútun-aaimo aúváívinkembo táámpamaimo simámakainten-umai Ísuna áséi-kwasai kwésimamena ");
INSERT INTO kze_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","aampa'á kuyambá nombá kwáyopa'a kwésarai uyaná Ítíópiyaavaken-kwaasigo séna nombá kwáyáínka'a pésinkainkwae sé'a únana nóinko aampimbá ítáraiyo súwana  ");
INSERT INTO kze_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Vírípi séna Ísumpa'o arumbó amé kwenááiyavai áraire simáímo maína'o é'a nombá pérankanaumne súwana Ísu Káráísintave'a árai'a Áánútu áánimban-iye kwésune séna ");
INSERT INTO kze_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","káárimo maisoréna kúwaintavena séna káári tátoraao súwana iséna tátorowasarai Vírípiye Ítíópiyaavaken-kwaasiye nompímbá kumbésarai Vírípi nombá pérankowasarai ");
INSERT INTO kze_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","úwoiva'a íyúyana Áánútun-amanko Vírípimba kunáí'maena kóúwana Ítíópiyaavaken-kwaasi awánómba íma máyombanivo aamoí untáva'a kwená naaópa'a kúmba ");
INSERT INTO kze_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Áánútun-amanko Vírípimba kunáí'maena Ásátóti-naopa'a máánkarowana Vírípi mináyámpá'-náópa'a Áánútuna áséi-kwasai simátíma'maena Sísáriyaa-naopa'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","minkánáámá Sóro Ísóigona aampa'á kwéguwaiyavena arumbá sáwí'a éna tínkamonae síma-sima'a kwéena aiva'-mónó-káwáánákónópa'a ");
INSERT INTO kze_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","koáísaa ena séna aúvái agaimái símína'a maimaé'a Támásikasi-naopa'o Yútaa-mono'-naumpimpa'o máyáan-kwaasiti anón-kwaasi mátíméno súwana owé séna mináímbá agaimaréna séna Sóro Ísuna aampa'á kwégwiyawai tivakáá-umai tuwánéna táto'mai tí'maena teémena Yérúsaremuva'a ándáva'a mátiyuwaniye séna agaimaréna súwana ");
INSERT INTO kze_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sóro mináúváí maimaéna kweémena Támásikasi-naopa'a egwaa'á kúmba kwíyómpakemba ságayamba tawáonkaan-tantaa'a tuwówana kuména aúgáyáagaya úwana ");
INSERT INTO kze_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","tuvamúwana aaigówé su'mai séna Sóroo nóra séwa kembá sáwí'a kwéono súwana ");
INSERT INTO kze_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","emá nááwa seénó súwana kemá Ísuma súmpo kembá sáwí'a umásinkaampo ");
INSERT INTO kze_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","usásine Támásikasi-naopa'a koménana moóráwaimo síndantemba mirán-uwo súwasa ");
INSERT INTO kze_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sóroemo kun-kwáásí íma aaí sumbá mésa íma kwaási ane'á kwéawanesa aaimó súne su'mai ísówana ");
INSERT INTO kze_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sóro usásinomba aúramba íma kawe'á umái awánówasa kwaási ayáán-to'maesa Támásikasi-naopa'a máánkarowana ");
INSERT INTO kze_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","kaumbo-nó'wáámbá ména íma aúramba awánéna toómbá nombá íma naráiye. ");
INSERT INTO kze_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Sóro kaumbo-nó'wáámbá kwaúwana moóráwai Támásikasiva'a ména Ísuna aampa'á kúwai áwí'a Ánánáesima aúramba karákéna kaainkáání'a umái awánómba Ísóigo simámena séna Ánánáesiyo súwana wó séna Ísóigoo kemá úne súwana ");
INSERT INTO kze_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","usásine aampa'á kwaaó. minánkó áwí'a apumó uráin-ampa'a kuré Yútásina naaúmpa'a kwée moóráwai Táásási-naopakewai áwí'a Sóromba koawánaao. kwe námúnaa kwésiye. ");
INSERT INTO kze_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kaainkáání'a awánarainka'a moóráwai áwí'a Ánánáesi téna ane'á tátoraisana aúramba kawe'á umái awánaraiye Ísóigo súwana ");
INSERT INTO kze_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ánánáesi séna Ísóigoo sáwíva-kwaasi kwenáái simásímakaawe. Yérúsaremuva'a ená kwaási sáwí'a umátínkarain-aimba simásímakaawe. ");
INSERT INTO kze_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","aiva'-mónó-káwáánákó aúvái agaimái ámísana ená imáyáa mósá máráan-kwaasi ándáva'o tiyuwáíndayavena Támásikasiva'a tiráiye súwana ");
INSERT INTO kze_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ísóigo séna kesí mayáí áménana kesáái kosimátin-tasimatimba ó'on-daopaken-kwaasiye kawáá-kwáásíyé kesí kwaási Ísareri-kwaasiye kosimátin-tasimatimba ínímba po usásine kwenópa'a kwinaná ");
INSERT INTO kze_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","kesí mayáí Sóro kwémayainasa kwaási sáwí'a umánkanaaowe. mindáyave'a ke agaráárankanaumne Ísóigo siráiye. ");
INSERT INTO kze_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","súwana Ánánáesi iséna kwéna sún-daumpa'a uména Sóro ane'á ayáámba tátorena séna Sóroo kesí kwaásima óne. aampa'á kwéte Ísóigo Ísumba awánaraandawaima si'máráísa'a túne. aúramba kawe'á umái awánenana Áánútun-amanko arupimbá anómba umánkaindayavena si'máráísa'a túne súwana ");
INSERT INTO kze_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sóro aúrampinkemba amanonoí tákúwana aúramba kawe'á umái awánéna usásinowana Ánánáesi mono'-nómbá pérankowana ");
INSERT INTO kze_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","toómbá násuwena áúgoma kawe'á úwana méraiye. Sóro Támásikasiva'a évaka'-no'waamba kwaéna Ísuna aampa'á kwéguwaise ména ");
INSERT INTO kze_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","avekáán-úwana mono'-náúmpá'á uména Ísun-aai simátimena séna árai'a Ísuma Áánútu áánimban-iye súwasa ");
INSERT INTO kze_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","kwenáái ísón-kwaasi táátavai ésa moórá-morawai tísaaisaa esa sésa Yérúsaremuva'a Ísuna imáyáa mósá máráan-kwaasi tínkamin-kwaasiman-iye. Ísuna imáyáa mósá máráan-kwaasi tí'mae ándáva'a mono-káwáá-kwáásírá'ó mátinkanae séna maanká'ó tiráin-kwaasiman-iye. Ísumpa'a téna máyáiye sésa táátavai uráawe. ");
INSERT INTO kze_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","suwaná Sóro asiramái simátíma'mae iyéna séna árai'a Áánútumo usásinankaiwaimba amu'maráúndawaiya Ísuman-iye séna kwenááigo iyúwasa Támásikasivaken-Yutaa-kwaasi isésa kwembá íma anondá simámakaawe. ");
INSERT INTO kze_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","íma anondá simámúmba sáwíva'-no'waamba kwaésa torupamái mésa Sórona ámááyu-aimba sésa ");
INSERT INTO kze_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","tuvuwíyanesa no'wáámba kwáyá'wái Támásikasi-naokona óntan-kurigona aaumémpa'a mésa ontará'á takárákwi-karakwi kwéuwana moóráwai ámááyu-aimba sumbá kosimámuwasa ");
INSERT INTO kze_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","moórá-no'waamba Sóron-aai isésa Ísuna aampa'á kwéguwai Sóromba powaivímbá áítumai óntan-kurigona avaapimbá túsúyuwesa ándára tátoresa túwówana kumeémena marapá'á móruna tuwéna kóuraiye. ");
INSERT INTO kze_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sóro Yérúsaremu-naopa'a kweémena kwéna séna Ísuna aampa'á kwégowaise koménae'a kúne súwasa miwí sésa Ísun-aai íma ísaraiwai kampar-áímbá kwésiye sésa kwenáároi inkáísúwana ");
INSERT INTO kze_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","moóráwai áwí'a Páánápáasi Sóron-aai iséna kawe'á úwana áí'maena aantá-kwaasitopa'a kwéna Sóron-aai kosimátimena Sóro Támásikasi-ampa'o kwégwenamo Ísóigombo awánówana aaí simámakain-aimba simátimena Sóro Támásikasi-naopa'o Ísun-aaimo asiramáímo simátíma'maena kuráin-aimba simátimuwasa ");
INSERT INTO kze_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","isésa áraire suwaná Sóro miwísé ména Ísuna asirayámbá kwáyowana Yérúsaremu-naopa'a Ísun-aai asiramái kosimátin-tasimatin-ena ");
INSERT INTO kze_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ó'on-Yutaa-kwaasi Kíríki-kwaasi tááivinkemba kwésen-kwaasi simátimuwasa aaí kwésima-kwesiman-esa tuvuwónáe sésa ");
INSERT INTO kze_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ámááyu-aimba sumbá Ísuna aampa'á kuwáí isésa Sóromba áí'maesa kweémesa Sísáriyaa-naopa'a máankesa sésa Táásási-naopa'a kwaaó sésa ai'márówana mindáópa'a kóuraiye. ");
INSERT INTO kze_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","kóúwasa Ísuna aampa'ó kun-kwáásímó tínkamumba étínkówasa aánoumai kwempa'á maésa Yútiyaa-ayampa'a Káríri-ayampa'a Sámériyaa-ayampa'a Ísuna aampa'á kwéguwai aánoumai kwempa'á máyówana Áánútun-amankoma túwa'naa úwasa asiramái mésa Ísun-aai simátímúwasa isésa áraire sésa mirá kwéesa sáwíva-kwaasi-i'a ésa Ísóigo áwí'a mósá marésa kwenaísamaivimba méraawe. ");
INSERT INTO kze_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pítaa aampa'á kwénaaena naaó'-nao-kwaasiti naaópa'a kwéna Áánútuna kwaási tuwánáíndayavena Árítaa-naopa'a kúmba ");
INSERT INTO kze_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","moóráwai áwí'a Íniyasi ména aambó naaí íma naaéna avakaumboé-ima maisuwéna naaúmpare su'mai ména kwégwauwana ");
INSERT INTO kze_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pítaa awánéna séna Íniyasiyo Ísu Káráísiti asóvamankaivo usásinke ená kwandaaí arusaaó súwana usásinkwena kúwasa ");
INSERT INTO kze_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Árítaa-naopaken-kwaasiye Séróno-naopaken-kwaasiye amápa'a awánésa Ísóigompa'a tésa méraawe. ");
INSERT INTO kze_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yópaa-naopa'a moórá-ininko ména áwí'a Tápítaama póna Kíríki-kwaasi tááivinkemba mináwí'a Tókáasiye kwésuwana kwemá Ísuna aampa'á kún-inimba aasiyaaí kawe'-máyáí kwémaena óísamba íma makón-kwaasi kwétuwa'naa úwana ");
INSERT INTO kze_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","áí'a úwana puwúwasa kwenáúma sese umásuwesa maimaésa ávúmayaatanaan-daumpa'a móankaraawe. ");
INSERT INTO kze_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yópaa-naopakemba Írítiyaa-naopa'a egwaa'á pósa Yópaavaken-kwaasi Ísuna kwaási Pítaa Írítiyaava'a tamáyon-aimba isésa kae-kwáásí ti'márówasarai Pítaamba kosimámesarai sésarai isaaisé kesópata tiyó sésa si'máráawakai túye suyaná ");
INSERT INTO kze_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pítaa usásinena mindáraise kúwasa áí'maesa minínímbá puwúwasa matuwé máyón-daumpa'a ávúmayaatanaan-daumpa'a íyúwasa Pítaanopa'a ketorínímbá tayorupamái maésa íví'a tésa Tókáasi íma pukáinka'a aru-símakain-unankwatoiye sésa agarááránkówana ");
INSERT INTO kze_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","awánéna séna máápa kárúwaaro súwasa kúmúwana Pítaa kívairena Ísóigompa'a námúnaa simásuwena mégwantena minínímbá awánéna séna Tápítaao usásinaao súwana aúramba kwégararena Pítaamba awánéna usátorauva'a maúwana ");
INSERT INTO kze_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pítaa kousásinankena Ísuna aampa'á kun-kwáásíyé ketoríníné tááyowasa áúvamankomba uawánésa ");
INSERT INTO kze_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yópaa-naopa'a kosimátíma'maesa kuwasá isésa sáwíva-kwaasi Ísóigon-aaiyavesa áraire sésa kwenká'á aráápamai máyówana ");
INSERT INTO kze_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pítaa Yópaa-naopa'a sáwíva'-no'waamba kwaéna moóráwai áwí'a Sáímoni kwená naaúmpa'a máyowana minkwáásígó kwaan-áúwarasinei kwená mayáí mayón-kwaasigona naaúmpa'a méraiye. ");
INSERT INTO kze_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sísáriyaa-naopa'a moóráwai áwí'a Kóníríyasi ména Árómáavakemba sáwívar-i-kwaasira'a 100 i-kwaasira'a kárákwirowai máyowasa miní-kwáásí túwí'a Ítári-i-kwaasiye kwésesa uwaná ");
INSERT INTO kze_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kóníríyasi Áánútun-aaiyavena asiramái ména kwená akúnté Áánútuna imáyáa éna áwí'a mósá maréna Yútaa-kwaasimo ímo óísambo makón-kwaasi kwétuwa'naa-ena Áánútumpa'a námúnaa símae iyúmba ");
INSERT INTO kze_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","moórá-tawai enónka'a námúnaa kwésuwana Áánútuna kwayó'ná'á kwíyómpakewai aúranka'a paárúwana kawe'á umái awánówana séna Kóníríyasiyo súwana ");
INSERT INTO kze_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","áá'a kówana aúramba kararéna séna Ísóigoo nóran-aina simásiminiyewa seénó súwana emó námúnaamo séndawai kwaásimo túwa'naa óndawai Áánútu aúranka'a kawe'á óndayavai Áánútu ená imáyáa imbá pó ");
INSERT INTO kze_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ená kwaási ti'márénasa Yópaa-naopa'a moóráwai áwí'a Sáímoni Pítaamba koaíráaro. ");
INSERT INTO kze_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","kwemá araámáó Sáímonina naaúmpa'a ména minkwáásígó kwaan-áúwarasi-mayaimo máyáin-kwaasigona naaúmpa'a uwí-nónkóná awámpá'-náúmpákémbá koaíráaro ");
INSERT INTO kze_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","simásuwena áúyokuwana Kóníríyasi kwená mayáí máyón-kwaasivinkemba kae-kwáyó-kwáásíráínte moórá-i-kwaasi Áánútuna imáyáa mósá marówainte miráumai-kwaasirau tááyowasa ");
INSERT INTO kze_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","tuwaná kwíyómpakewaimo simámakon-aimba simátimena séna miráumai Yópaa-naopakemba koaíráaro séna ti'mákaiye. ");
INSERT INTO kze_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ti'marówasa aampa'á kógwaesa kweémesa Yópaa-naopa'a egwaa'á kumbá kwáyá'wái Pítaama naan-ávúmayaapa'a uména Áánútumpa'a námúnaa kwésuwana ");
INSERT INTO kze_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","áái ankówana toómbá nánáe súwasa toómbá agáyómba kaainkáání'a umái awánómba ");
INSERT INTO kze_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","kwíyómba taaínkaar-úwana mimpínkémbá anón-ampanta éíyain-araaira'a tátoresa túwówana kuména marapá'á kumúwana awánómba ");
INSERT INTO kze_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","minámpántávímbá kwaí-kwaamba póíma iraankavayaambá aváá'-númámá ó'on-o'on-kwai-kwaamba máyowana ");
INSERT INTO kze_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","aaigówé su'mai séna Pítaao usásinke tuvú'mái agandaaó súwana ");
INSERT INTO kze_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pítaa séna Ísóigoo ímanivo kentáásí ámáámba Yútaa-kwaasiya mirán-tántáá'á aambá áúmbakaawata pó'a íma kwénaumne súwana ");
INSERT INTO kze_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","minááígówé su'mai ókwara'a séna Áánútu kawe-tántááré siráin-tantaatavai íma aambá áúmbakaawe siyó súwana ");
INSERT INTO kze_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","kaumborá'á kaainkáámbá awánówana kwíyómpa'a minámpántámá iráiye. ");
INSERT INTO kze_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","iyúwana Pítaa minkááínkáán-áínkóná ááimba nóra aainá'iyo súmba Kóníríyasimo ti'marón-kwaasi Sáímonina naambá taawánésa ontará'á tamésa ");
INSERT INTO kze_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","tááyamai taáísaa esa sésa Sáímoni Pítaa maandáúmpárá kwááyu máyáiyo suwaná ");
INSERT INTO kze_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pítaa minkááínkáán-áínkóná ááimba avakáá-úwana Áánútun-amankoma séna kaumbo-kwáásí embá avakáá-úmaesa kwétevo ");
INSERT INTO kze_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","usásinke kumuwó. kemá ti'maráúnasa tentáváí íma kaer-ímáyáá e miwísé úwoi kwaaó súwana ");
INSERT INTO kze_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pítaa kuména minkwáásíyávéna séna kwésivakaa-on-kwaasi úmpo nóintavera kwésivakaao súwasa ");
INSERT INTO kze_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","kentáásí kawáánákó áwí'a Kóníríyasi si'máráísata enópata túne. kwemá kawe-kwáásí Áánútuna imáyáa éna áwí'a mósá máráísasa pósa Yútaa-kwaasi amápa'a kwentávésa kawe-kwáásíyé kwésewe. moóráwai Áánútuna kwayó'ná'á kwíyómpakewai kusimámena séna ti'márénasa Pítaamba Yópaa-naopakemba koaíréwana enópa'a téna aaí tasína isaaó sisatá túne suwaná ");
INSERT INTO kze_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pítaa tí'maena naaúmpa'a tinkówasa kwáúmba aaváyaavimba Pítaa usásinena miwísé kuráiye. miwísé kúwasa Yópaa-naopakemba Ísuna aampa'á kun-kwáásí évaka'a aúyoresa ");
INSERT INTO kze_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","aampa'á kógwaesa kweémesa Sísáriyaa-naopa'a kumbá Kóníríyasi kwenamááraa kwená kwaásiye tááyowasa tayorupamái mésa Pítaamba amu'makówana ");
INSERT INTO kze_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pítaa Kóníríyasina naambó kwáyonka'a ontará'á kúwana Kóníríyasi aamoí éna anóndakoman-iye séna aísamaivimba kumbaúwana ");
INSERT INTO kze_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pítaa séna emó óndanten-kwaasi úmpo usásinaao séna usásinakena ");
INSERT INTO kze_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","aaí simáma'maena Kóníríyasiye naaúmpa'a iyúmba sáwíva-kwaasi torupamái máyómba utuwánéna ");
INSERT INTO kze_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","séna kentáásí ámáámba ísaraawe. Yútaa-kwaasiya ó'onkaa-kwaasiye íma moórárata tágárotamaiya kwémaumne. miwítí naaúmpata íya kwénaaundarata Áánútu agaráásinkena amápa-kwaasi íma sáwí-kwaasin-owe siráisa'a awáraunda póta íma sáwí-kwaasiye sénaunda pó'a úwoi kawe'á umái ménaumne. ");
INSERT INTO kze_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","mindáyavai sááyaamba íma a'áo súnda túmpo nóintavaiya sááyaraao Pítaa súwana ");
INSERT INTO kze_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kóníríyasi séna éíyain-do'waamba kwaé'a ívékaamba eénáínka'a kesí naaúmpa'a námúnaa súnana avekáámbá moóráwai ságayan-unankwatoi umásorena súranka'a kumbaéna ");
INSERT INTO kze_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","séna Kóníríyasiyo emó námúnaamo sémo kwaási túwa'naa ema Áánútu aúranka'a kawe'á óndayavena Áánútu ená imáyáa imbá pó ");
INSERT INTO kze_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ti'márénasa Yópaa-naopa'a moóráwai áwí'a Sáímoni Pítaamba koaíráaro. araámáó Sáímonina naaúmpa'a máyáiye. kwaan-áúwarasi-mayaimo máyáin-kwaasigona naaúmpakemba uwí-nónkóná awámpá'-náúmpákémbá koaíráaro súwa'a ");
INSERT INTO kze_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","avekáán-umai ti'maráúnasa embá koaíráawa kawe'á umái téne. kesáá Áánútu aúranka'a torupamái méta Ísóigo simámakain-aimba simásiminkwae séta amu'makáunaya kwétene Kóníríyasi siráiye. ");
INSERT INTO kze_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kóníríyasi simásuwowana Pítaa séna ívé'a kwéisaumne. árai'a Áánútu íma Yútaa-kwaasiye su'mai kwégarakwiyivo ");
INSERT INTO kze_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","amápa'-mapaken-kwaasi Áánútu aúranka'a arupí umái kawe'á umái máyáawai Áánútu miwí aamoí kwéumatinkaiye. ");
INSERT INTO kze_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Áánútu Ísu Káráísitimba ai'marówana Ísareri-kwaasiyavai áséi-kwasai simátímakaimba á'a ísaraawe. Ísu Káráísiti amápa-kwaasiti Ísóigoman-iye. mináséí-kwásáíyávésa árairemo síyawai tirumbá kawe'á umái kwempa'á ménaaomba ");
INSERT INTO kze_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ke ísaraawe. Yóni simátimena séna kentí sáwí-imayaa tuwé'a Áánútumpa'a té'a nombá peránááowe siráimba Ísun-aai aiva'á Káríri-ayampakemba kwétena Yútiyaa-marava'a kóyáwé uráiye. ");
INSERT INTO kze_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ísu Násáretivakewain-aai ísaraawe. Áánútu kwenamambá Ísumba ámakowana kwempímbá anómba umánkowana Áánútu asirayámbá aména kwesé méraintavena naaó'-nao'a kawe'-máyáí kóyáwé éna Sáátáánigo tátorain-kwaasi kawe'á umátínkáva'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yútiyaa-marava'a Yérúsaremu-naopa'a mayáímá mairáimba awánaraundayaawe. kwembá taaira'á aíyayaampimba tuvúsúmarowana puwéna ");
INSERT INTO kze_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kaumbo-táwai maisuwówana Áánútu Ísumba pukáimpinkemba usásinankowana paárúnta kesúrandeiya awáraumpo ");
INSERT INTO kze_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","íma amápa-kwaasi awánaraawe. Áánútu simátíméromo siráinta Ísunta awánéta pukáimpinkemba usásinonka'a toómbá nombá kweséya naráumne. ");
INSERT INTO kze_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ísu asiramái simásimena séna Áánútu imáyáa siména pukén-kwaasigwara túvaren-kwaasigwara'a aaivimbá maitinkáníyone siyé simátíméro Ísu siráiye. ");
INSERT INTO kze_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","naaóvá'á Áánútun-aai simátímakowai Ísun-aai simátimesa sésa kwenááiyavesa áraire sésa kwesé aráápamai maíyawai Ísuna asirayánká'á Áánútu miwítí sáwí-imayaa maitiyuwáníye naaóvá'á siráawe Pítaa siráiye. ");
INSERT INTO kze_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pítaa mináímbá kwésimatimuwana kwéison-kwaasivimba Áánútun-amankoma minámápáráwáívímbá kuména ");
INSERT INTO kze_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Áánútun-amankoma kumbaúwasa ó'on-o'on-aimpinkemba Áánútu áwí'a mósá márówasa Yútaa-kwaasi Ísuna aampa'á kun-kwáásí Pítaae Yópaavakemba tuwáíyé táátavai ésa sésa Áánútu ó'onkaa-kwaasigwara'a kwenamambá úwoi kwétimiye sésa táátavai uwaná Pítaa séna ");
INSERT INTO kze_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Áánútu kwenamantá símakaintenta miwígwárá'á kwétimimba póta nombá peránááomba íma aambá aunónaumpo úwoi nombá peránááovo ");
INSERT INTO kze_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","pétinkaaro súwasa Ísu Káráísitintavesa ísámai nombá pétinkowasa Pítaantavesa sésa kaumbo-káé'-no'waamba keséya kwaíníyone suwaná mirá uráiye. ");
INSERT INTO kze_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ó'onkaa-kwaasi Ísun-aai isésa tátokaawemo sumbá aantá-kwaasiye Ísuna aampa'á kuwáí Yútiyaa-maravaken-kwaasiye mináímbá isésa máyówana ");
INSERT INTO kze_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pítaa Yérúsaremu-naopa'a kúwasa évaka-kwaasi áwáá'a aéésa Yútaa-kwaasi túra'a kárámai araa'éna kwéontemba ó'onkaa-kwaasigwara'a mirá orómó sirón-kwaasi Pítaamba áwáá'a aéésa ");
INSERT INTO kze_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","sésa emá ó'onkaa-kwaasiti naaúmpa'a ugwaé ímo túmo kárámai araa'éna úmakaan-kwaasiti naaúmpakemba toómbá umandaráane suwaná ");
INSERT INTO kze_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pítaa amápa-tantaa'a uráimba simátimena ");
INSERT INTO kze_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","séna Yópaa-naopa'a mé'a Áánútumpa'a námúnaa séwándara'a kaainkáámbá awánaawanana kwíyómpakemba anón-ampanta éíyain-araaira'a tátoresa túwówana kuména kesí egwaa'á kumúwa'a ");
INSERT INTO kze_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","mimpímbá árimba awánaawanda póíma kwaí-kwaamba iraankavayaambá áváá'-numama máyowa'a awánaawanana ");
INSERT INTO kze_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","aaigówé su'mai séna Pítaao usásinke tuvú'mái agandaaó súwa'a isé'a ");
INSERT INTO kze_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","sé'a Ísóigoo ímanivo kentáásí ámáámba mirán-tántáá'á aambá áúmbakaawata pó'a íma kwénaumne séwánana ");
INSERT INTO kze_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","minááígówé su'mai ókwara'a séna Áánútu kawe-tántááré siráin-tantaatavai íma aambá áúmbakaawe siyó súwa'a ");
INSERT INTO kze_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","kaumborá'á kaainkáámbá awánaawanana kwíyómpa'a minámpántámá iráiye. ");
INSERT INTO kze_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","avekáámbá Sísáriyaavakemba kaumbo-kwáásí kesópa'a ti'marówai tumbá ");
INSERT INTO kze_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Áánútun-amanko simásimena séna íma kaer-ímáyáá e miwísé kwaaó súwa'a kówánasa Yópaavakemba maankwáásí ava'moraé-kwaasi Ísun-aai ísáawai súyorowata Sísáriyaa-naopata Kóníríyasina naaúmpata kówánana ");
INSERT INTO kze_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","simásimena séna Áánútuna kwayó'ná'á kwíyómpakewai kesí naaúmpa'a kumbáyáísa'a awánáúnana séna ti'márénasa Yópaa-naopakemba moóráwai áwí'a Sáímoni Pítaamba koaíréwana ");
INSERT INTO kze_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","téna aaí tagwésimatimina'a egwárá ená akúnkwárá'á amápa'a kwéisewana Áánútu sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaniye kwíyómpakewai siráiye Kóníríyasi súwa'a ");
INSERT INTO kze_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","aaí kwésewanana Áánútun-amanko aiva'ó kentáávímbó kunkáintemba miwívímbá mirá úwa'a ");
INSERT INTO kze_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","awáné'a moórá-aimba sááka'a makáumne. ááéma Ísóigo séna Yóni nombá pétinkaraimbanivo Áánútun-amanko kuména keinárawapimba anómba umátinkaniye Ísóigo siráin-aimba sááka'a makáumne. ");
INSERT INTO kze_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ánivo kesáá Ísóigo Ísu Káráísitin-aaiyaveta áraire séwánanaya Áánútu kwenamankómbó símakaintenta ó'onkaa-kwaasi miwí mirá kwéowa'a awánaraunda pó'a kemá Ísuna mayáí-kwáásímá pó'a nombá pérómba íma aambá aunówánasa úwoi nombá pékaawe Pítaa súwasa ");
INSERT INTO kze_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","mináímbá isésa áwáá'o áúmba ivátuwesa Áánútu áwí'a mósá marésa sésa Áánútu mirá kwéena íma Yútaa-kwaasiye su'maiya aaí kwésimasimintaanivo ó'onkaa-kwaasiyavaigwara'a aaí kwésimatimisasagwara'a miwítí sáwí-imayaa tínaaemba umámesa Áánútunopa'a tésa aúnái'a umái maí'mai'a ónááowe siráawe. ");
INSERT INTO kze_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ááéma Sítívenimba tuvúwúwana puwúwasa ó'on-kwaasi Ísuna aampa'ó kun-kwáásí sáwí'a umátínkówasa kóyáwé uráamba évaka'a Vínísiyaa-marava'a kuwasá évaka'a Sáíparasi-marava'a kuwasá évaka'a Ántíoku-naopa'a kuwasá miwímá minkáúmbó-márává'á máyón-kwaasi Yútaa-kwaasiye su'mai Ísun-aai kosimátimesa ");
INSERT INTO kze_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","miwívínkémbá évaka'a Sáíparasi-maravakewai évakarawai Sáírini-maravakewai miwímá Ántíoku-naopa'a komáyónka'a Yútaa-kwaasiye ó'onkaa-kwaasiyegwara'a Ísóigo Ísuna áséi-kwasai kosimátimuwana ");
INSERT INTO kze_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ísóigona asirayámbá miwísé máyowasa sáwíva-kwaasi Ísóigon-aaiyavesa áraire sésa kwempá'á tiráawe. ");
INSERT INTO kze_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ántíokuvaken-kwaasi Ísóigon-aaiyavesa áraire sésa kwempá'á tiráan-aimba suwasá Ísóigona kwaási Yérúsaremuva'a máyón-kwaasi mináímbá isésa Páánápáasimba ai'márówana Ántíoku-naopa'a kweémena ");
INSERT INTO kze_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","koména Áánútu kawe'á umátínkaromba tuwánéna aamoí éna asiramái simátimena séna kentirunkaké ísámai Ísóigontavai máéro séna ");
INSERT INTO kze_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Páánápáasi kawe-kwáásí úwana Áánútun-amanko kwempímbá anómba umánkowana Ísóigonte aráápamai asiramái ména aaí simátíma'maena kwéiyuwasa sáwíva-kwaasi isésa Ísóigompa'a tésa méraawe. ");
INSERT INTO kze_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","máyówana Páánápáasi Sóromba avakáá úmaena Táásási-naopa'a kúmba ");
INSERT INTO kze_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","koawánéna koáí'maena Ántíokuva'a tésarai moórá-i tamaisuwésarai Ísóigona kwaásiye mésarai sáwíva-kwaasi tayorupontembá Ísun-aai simátíma'maesarai íyúyasa Ísuna aampa'á kwéguwaiyavai sésa Káráísitina kwaásiye suwaná aiva'á Ántíokuva'a mináímbá paáruraiye. ");
INSERT INTO kze_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","mináímbá paárúwana minkánáá évakarawai Áánútun-aai simátímakowai Yérúsaremuva'a tuwésa kweémesa Ántíokuva'a kuwaná ");
INSERT INTO kze_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","miwívínkémbá moóráwai áwí'a Ákápáasi kwemá usásinena Áánútun-amanko kwesé máyowana séna anón-ayawaima amápa'-mapa'a táníye súnka'a póna naaémba Árómáani-kamaaniti kawááná'á áwí'a Kórótíyasa máyonka'a mináyáwáímá paáruraiye. Ákápáasi mináímbá súwasa ");
INSERT INTO kze_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","isésa Ísuna aampa'á kwéguwai moórá-morawai sésa óntamba torupamái Ísun-aai ísáawai Yútiyaa-marava'a máyáan-kwaasi timénáe sésa ");
INSERT INTO kze_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","mirá ésa minóntámbá Páánápáasinte Sóronte tímúwasarai maimaésarai kweémesarai Ísóigona kwaásiti anón-kwaasi mátímakaaiye. ");
INSERT INTO kze_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","minkánáá Érótimba anówainkoma araámáó Érótima Yútaa-kwaasiti kawááná'á kwemá Ísuna aampa'á kwéguwai évakarawai sáwí'a umátinkena ");
INSERT INTO kze_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","moóráwaimba ai'marówana Yóni awaaó áwí'a Yémésimba koyáto'mai anumarambá arátuwowana puwúwasa ");
INSERT INTO kze_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yútaa-kwaasi Ísun-aaiyavesamo ímo áraire suwáí aamoí kwéuwana Éróti awánéna aamoí umásinkaigwae séna moóráwaimba ai'marówana Pítaamba koyátokai. Yútaa-kwaasi ímo intóráin-tantaakwara-pereti kwéagayon-kanaavimba moórá-tawai Pítaamba koyáto'maena ");
INSERT INTO kze_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ándáva'a máánkowasa siyáánkain-umai ava'moraé-i-kwaasi kwenká'á kárákwirowasa éíyain-eiyain-kwaasi anondánonda umái kárákwiyuwasa Éróti séna naaóvá'á Áánútu Yútaa-kwaasi tíyótaasa í-tánón-kánáámá ánásaina'a Pítaamba áí'mae'a Yútaa-kwaasi túranka'a aaivimbá mayanké'a inkamónaumnemo kwésumba ");
INSERT INTO kze_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pítaa ándáva'a máyombanivo Ísóigona kwaási Ísóigompa'a námúnaa simái Pítaamba áwa'naa uráawe. ");
INSERT INTO kze_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","námúnaa kwésesa Pítaantavai ísámai áísaa uwaná aaváyaaraamba Éróti Yútaa-kwaasi túranka'a Pítaamba aaivimbá mayankánaumne kwésuwana ívé'-no'waankaamba Pítaamba aíyayaanka'a asááúmakesa kaer-í-kwáásí évareva'a máyóyana Pítaa aún-kwaigúwasarai kaer-í-kwáásí ontará'á kárákwiroyana ");
INSERT INTO kze_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","avekáámbá Ísóigona kwayó'ná'á kwíyómpakewai kumúwana ándá-naumpa'a sán-kówana Pítaamba ayoírá'á kwétuvuwena aúsuwana usásinowana séna avekáán-usásinaao kwésuwana Pítaa ayáámpinken-anda kweyááríka'a ayú'maena marapá'á kumúwana ");
INSERT INTO kze_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","kwíyómpakewai séna enámúranda uré enaísamai ánáamba maimái uwó súwana mirá úmayowana ená paákákén-únánkwátói kuvé'máenakai kesé kúmóyo súwana ");
INSERT INTO kze_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pítaa ándá-naumpakemba kwenánaaemba kuména íma kwaásin-iye-imayaa éna kaaimbá kwéawanaumne-imayaa kwéena ");
INSERT INTO kze_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","i-kwáásímó máyon-ontara'a kunáyaaitesarai minkákémbá moórá-ontara'a i-kwáásímó máyon-ontara'a kunáyaaitesarai minkákémbá ándávakembo naaópa'o kónáesamo uwasamó titinkémáen-ontara'a asirayán-óntárá'á kúmúyana kweyááríka'a tigúwasarai kunákárúwagwesarai aampa'á kuyaná avekáán-úwana kwíyómpakewai Pítaamba auwéna aúyokuwana ");
INSERT INTO kze_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pítaa imáyáa éna séna íma kaaimbá awánáúmpo árai'a Ísóigo kwená kwayó'ná'á ai'máráísana kuména Éróti sínkamonae kwéisana ayáámpinkemba kuntavíyuwaisa'a túne. Yútaa-kwaasigwara'a sínkamonaesamo ombá kuntavíyuwaisa'a túne Pítaa siráiye. ");
INSERT INTO kze_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pítaa simásuwena Máríyaana naambó kwáyopa'a kwéna Yóni Máákaamba anówana naambó kwáyopa'a kúwasa sáwíva-kwaasi mindáúmpá'á torupamái mésa Pítaantavai ísámai Ísóigompa'a námúnaa kwésuwana ");
INSERT INTO kze_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","mindánkóná ontará'á kotuwátuwar-úwana moórá-arasi mindáúmpá'á kígau ún-arasigo áwí'a Áróta ontará'á kuména ");
INSERT INTO kze_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","séna nááwa'ono súwana Pítaa séna kemá úne súwana Pítaa amósámba iséna kunaamoí úmaena ímo ontamó tiyankómba isaaiséna sáwíva-kwaasitopa'a usimátimena séna Pítaa ontará'á máyáiye súwasa ");
INSERT INTO kze_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","miwí sésa emá uwo'aó'á éma kampa'á séne suwaná minárásígó ókwara'a séna árai'a Pítaa ontará'á máyáiye súwasa miwí sésa Pítaan-amankon-iye ");
INSERT INTO kze_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","kwésuwana Pítaa ontará'á árimba tuván-tuvan-úwasa isésa onta kuntisuwésa awánomba kwemá Pítaa úwasa táátavai uwaná ");
INSERT INTO kze_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","aaisékéwa'a simátíméno séna Ísóigo ándávakemba kembá sí'maena aampa'á mésiyuwaivo Yémésinte Ísun-aaimo ísáan-kwaasiye kosimátíméro Pítaa simátimena tiyuwéna ó'on-daopa'a kuráiye. ");
INSERT INTO kze_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","kúwasa irataró'a i-kwáásí Pítaamba kárákwirowai awánomba íma máyowasa kantúmbá ésa Pítaa náávara kóuraiyo suwaná ");
INSERT INTO kze_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Éróti iséna Pítaamba avakáá oró súwasa avakáá uwááesa tuwówana Éróti miní-kwáásí aaivimbá maitinkéna séna tínkamoro séna évakarawai ti'marówasa tínkamuwasa púwúwana Éróti mirá umásuwena Yútiyaa-marava'a tuwéna kumeémena Sísáriyaa-naopa'a kumbéraiye. ");
INSERT INTO kze_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Éróti Sáítóni-naopaken-kwaasiye Táyaa-naopaken-kwaasiye ávááraumai áwáá'a tiyúwasa minkáé'-náópaken-kwaasi tayorupamái mésa sésa Érótimo kárákwirai-maravakemba kentáásí toómbá kwémayaundayaawe sésa mináímbá simái kawer-ónáe sésa Érótinopa'a tumbá kwená naaka'ó kárákwirowai áwí'a Párásatasimba másimamuwana isówasa minááísámbá másimai tukáawe. ");
INSERT INTO kze_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","minkákémbá Éróti anón-kanaa úwana kwenká'ó kárákwirowaina unáánkwátói úmaena kárákwirowai maé'maer-únka'a uména ayáátáár-aimba kwésuwasa ");
INSERT INTO kze_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Érótimba simái arumbá iyaésa sésa íma kwaásigo kwésivo Ísóigo kwésiye anónka'a suwaná ");
INSERT INTO kze_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Éróti mináíntávéna íma Ísóigo úmpo úwoi-kwaasi úne séna aúpá'á tuwówana Ísóigona kwayó'ná'á kwíyómpakewai tuvuwúwana uvowánkó arumbá unkarówana pukáiye. ");
INSERT INTO kze_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","puwúwasa Ísóigona kwaási Áánútun-aai kosimátin-tasimatin-uwasá isésa áraire sésa Ísóigompa'a tésa méraawe. ");
INSERT INTO kze_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ántíokuvaken-kwaasi Yérúsaremuvaken-kwaasiyavesa óntamba timénaumne sirómba pósarai Páánápáasiye Sórowe kwéti'matuwesarai mimbáyáí ánásowasarai ívé-kwaasigo áwí'a Yóni Máákaamba áí'maesarai Yérúsaremuva'a tuwésarai kweémesarai Ántíokuva'a kurááiye. ");
INSERT INTO kze_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ántíoku-naopa'a Ísóigona kwaásivinkemba Áánútun-aai kwésimatimen-kwaasiye kawer-ímáyáá kwéagaraantinkaan-kwaasiye mésa moóráwai áwí'a Páánápáasi úwana moóráwai avután-kwaasigo áwí'a Símiyoni úwana moóráwai Sáíríni-maravaken-kwaasigo áwí'a Árúsiyasi úwana moóráwai áwí'a Mánéyeni kwemá Éróti kawáánákóná naaúmpa'a maémaumba úwana moóráwai Sóro úwana umái mésa ");
INSERT INTO kze_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","moórá-kanaa Ísóigona kwaási Áánútuna imáyáa mósá kwémaresa toómbá íma kwénesa námúnaawe su'mai kwésunka'a Áánútun-amanko simátimena séna Páánápáasinte Sóronte kesí mayáírá'á usásintinkaraumpo mindárai tiyúwáaro súwasa ");
INSERT INTO kze_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","toómbá íma nombá námúnaawe su'mai kwésesa Áánútuna mayáí mayáígwáe sésa tine'á tiyáándei tátoresa ti'márówasarai kurááiye. ");
INSERT INTO kze_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Áánútun-amanko Páánápáasinte Sóronte ti'marówasarai Yóni Máákaamba áí'maesarai Ántíoku-naopa'a tuwésarai Sérúsiyaa-naopa'a kumésarai uwí-nónkóná avumpim-bárává'á áwí'a Sáíparasi-marava'a kónáe sésarai nompí-sípí táto'mai usáatesarai kweémesarai ");
INSERT INTO kze_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sáíparasi-marava'a Sárámisi-naopa'a mindómpí-sípívínkémbá kunásávesarai Yútaa-kwaasiti mono'-náúmpímpá'á Áánútun-aai simátíma'maesarai kwéguyana Yóni Mááka túwa'naa úmaena kúwasarai ");
INSERT INTO kze_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","kawer-áímbá simátíma'maesaya marapá'á kweémesaya Páávoso-naopa'a kuwaná moóráwai mindáópa'a Yútaa-kwaasigo ména kwenáwí'a Paayísu Kíríki táávinken-kwi'a Érímasa kwemá pukaa'á agayón-kwaasi póna kampa'á séna Áánútun-aai simátimundawai úne súwana ");
INSERT INTO kze_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","moóráwai kámááni-kwaanako áwí'a Sésiasa Porasa ména kawer-ímáyáágwárá-kwáásí póna Áánútun-aai isánáe séna Páánápáasinte Sóronte tááyowana Érímasa pukaa'á agayón-kwaasigo kámááni-kawaanakoe aasiyaasí maí'mai'a úwai máyowana kámááni-kawaanako Páánápáasinte Sóronte tááyowasarai tuyaná Érímasaagwara'a téna ");
INSERT INTO kze_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","mindárai táái tasimái karéna kámááni-kawaanako Ísun-aaiyavai áraire sivo séna mindárai táái tasimái karówana ");
INSERT INTO kze_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sóro moórá-awi'a Póro Áánútun-amanko kwempímbá anómba umánkowana Póro pukaa'á agayón-kwaasigomba aráá'a avuwéna ");
INSERT INTO kze_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","séna Sáátáánigo áráá'a po kawer-ánkóná uwa-kwáásí éma amápa-sawisawaa-imayaao empímbá anómba umánkaraimba po Ísóigona kawer-ámbá sáwí'a úmae iyóndayavena ");
INSERT INTO kze_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ívé'a Ísóigo ená meéyámbá amína aúramba kavíkwína évaka-tawai sámo káínda íma awánaniyone Póro súwana avekáámbá Érímasaamba aúrampa'a ítáguwana siyáánka'o táto'maesamo naaíyane séna kwaási tivakáá úmae kwénaauwana ");
INSERT INTO kze_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","kámááni-kawaanako Ísóigon-aai iséna áátavai éna Ísóigomo úmba awánéna séna Ísóigon-aai árair-aimban-iye séna kwempá'á téna méraiye. ");
INSERT INTO kze_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Póro kwesé kwénaauwaise Páávoso-naopa'a tuwésaya nompí-sípí táto'mai usáatesaya kwémesaya Pámpíriyaa-marava'a Pékaa-naopa'a mindómpí-sípívínkémbá kunásávesaya kúmúwana Yóni Mááka tiyuwéna Yérúsaremuva'a kóúwasarai ");
INSERT INTO kze_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","mindárai marapá'á kweémesarai Písítiyaa-marava'a Ántíoku-naopa'a kwésarai Yútaa-kwaasi monor-áímbá kwéison-kanaara'a Yútaa-mono'-naumpa'a mara'á umáyóyasa ");
INSERT INTO kze_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","aúváí-kwandaavinkemba Áánútuna ámáámba Mósesi agaimakómba simátimesa Áánútun-aai simátímakowai agaimakón-aimba simátímúwasa Yútaa-mono-kawaanarawa'a moóráwaimba ai'márówana mindáraitopa'a téna séna kentáásí kwaásiraiyo kwaasái kwáyainakaimo ékai kentáásí imáyáa simái kawe'á umásinkaakaiyo súwana ");
INSERT INTO kze_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Póro usásinena séna maísáaro. kesí Ísareri-kwaasiye ó'onkaa-kwaasi Áánútuna imáyáa mósá máráawaiye ísáaro. ");
INSERT INTO kze_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","naaóvá'á Ísareri-kwaasiti Ísóigo kentáá síkwá'náyavena séna kesí kwaásiman-owe súwasa ó'on-kwaasiti maravá'á Ísípi-marava'a mésa sáwíva-kwaasi agáyówana Áánútu kwená anón-asirayamba kwáyontavai Ísípivakemba tí'maena ");
INSERT INTO kze_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","kavóná-marava'a mátinkowasa sáwívar-ima 40 ira'a kwénaaesa aasiyaasí Áánútuntavesa sáwí-imayaa kwéumbanivo Áánútu miwírá'á kárákwirena íma tiyuwówasa ");
INSERT INTO kze_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kénááni-marava'a avakaeté-maravaken-kwaasi moórá-mora-umai máyówana Áánútu tínkambaena kwéiyuwasa évaka'a putásowana miwítí maramá maimaéna kwená kwaási Ísareri-kwaasi mátimuwasa ");
INSERT INTO kze_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","mimbárává'á mésa sáwívar-ima 450 ima maisukáawe. 450 ima maisúwówana Áánútu moórá-mora-kwaasi kawáá-máyáírá'á usásintinkava'a kúwana Áánútun-aai simátímakowai áwí'a Sámúwéri kwemá usávaaruwasa mirán-káwáá-kwáásí ánásasowasa ");
INSERT INTO kze_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ísareri-kwaasi Áánútu íma kentáárá'á kárákwiyinkwae sésa kentáávínkémbá moóráwaimo éna kentáárá'á kárákwiyiniye suwaná Áánútu séna Pénisamini-andarakewai Kísaa ááninko áwí'a Sóro kwemá kárákwiyi-mayai mayáníye súwana mimbáyáí mairéna 40 ima maisuwówana ");
INSERT INTO kze_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Áánútu mimbáyáí Sórompakemba Yési ááninko áwí'a Tévítimba amúwana mayówana séna Tévíti kemó súndanteni'a kwéimba pó'a aamoí kwéumankaumne Áánútu siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","naaóvá'á Áánútu séna Tévítin-andarakembo aánomo usásinankaandawai kwemó éna Ísareri-kwaasi sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaniye siráimba Ísuntavena árair-aimba siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ísu íma amápa-kwaasi túranka'a paárurowana Yóni nombó pétinkowai amápar-Isareri-kwaasiyavena simátimena séna kentí sawi-ímáyáá tínaaembo umáme'o Áánútumpa'o tíya'o é'a nombá pétinkanaumne súwasa mirá uwaná nombá pétinkena ");
INSERT INTO kze_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","kwená mayáí sáwíyanka'a ánásaniye kwéuwana simátimena séna kentí imáyáaomo kentáváímó nááwa'iyo sénááomba kwéamu'maraawai kemá íma kwemá úmpo kesínaaemba tíníwai kwemá anóndakoma kembá usáyaaitaraimba pó'a kwemó aaimó síndavimba kemá aaimó sendamá uwóví'a ónaumne Yóni siráiye Póro siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Póro simásuwena séna kesí kwaási Ááváramun-andaraken-kwaasiye ó'onkaa-kwaasi Áánútuna imáyáa mósá máráawaiye ísáaro. sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaimba kentááyávéna Áánútu siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yérúsaremuvaken-kwaasiye miwítí kawáánárawate sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaniyemo siráin-aimba Ísuntavai sirómba íma imáyáa uráawe. aasiyaasi-táwai monor-áímbá kwéison-kanaama Áánútun-aai simátímakowai agaimakón-aimba aúváí-kwandaavinkemba táámpamai kwésuwasa isésa Ísuntavai sirómba íma imáyáa uráavo tuvúwana pukáivo mináúváí-kwándááívínkén-áímbá paáruraiye. ");
INSERT INTO kze_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","tuvuwí-ámbá avakáá umbá íma sáwí'a uráimbanivo Páírátintavesa úwoi sésa tuvuwíníyone siráawe. ");
INSERT INTO kze_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Áánútun-aai aúváí-kwandaaivimba Ísun-aai agaimakómba amápa'a mirá uwasá taairakémbá maimái murí-áívímbá máutamankowana ");
INSERT INTO kze_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Áánútu pukáimpinkemba usásinankowana ");
INSERT INTO kze_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ayáátááka'a moórá-mora-tawai kwená kwaási túranka'a paáruraiye. ímo tuvúkónka'a Kárírivakemba Yérúsaremuva'a kwesé kuráawai pukómpinkemba usásinenamo moórá-mora-tawaimo paárumai máyomba minkwáásí awánésa sésa awáraundayavai ísaraundayavai Ísareri-kwaasi kosimátíma'maeta kónáe sésa kuráamba mimbáyáí paaí kwémayaawe. ");
INSERT INTO kze_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Páánápáasiye kesé mináséí-kwásáí simátíméyanekai túye. Áánútu kentáá síkwá'náyavena mirá ónaumne sirómba kesáá máyaunda-kanaavinta mirá éna Ísumba pukáimpinkemba usásinankaraiye. mináímbá monor-ímá agaimakón-auvaivimba kaepímbá agaimaréna séna emá kesáánimba óna'a kesí mayáírá'á ánkaraumne agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Áánútu pukáimpinkemba usásinankaraimba póna íma ókwara'a puwínana áúma kaviráníntavena Áánútu séna Tévítintave'a sé'a árai'a kawe'á umánkanaumne siráundantemba embá kawe'á umánkanaumne Áánútu siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","moóráva'a monor-ímá agaimakón-auvaivimba agaimaréna séna Áánútu kwená kawe-kwáyó'ná'á íma auwáínana áúma kaviráníye agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","mináímbá íma Tévítintavena siráivo Tévíti Áánútuna mayáí kwémaena puwúwasa maimaésa aíkwá'námo utámakompimba máutamarowana áúma kaviraráivo ");
INSERT INTO kze_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Áánútu Ísumba pukáimpinkemba usásinankarowaimba kwenáúma íma kaviraráiye Póro siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Póro simásuwena séna kesí kwaásiyono. ísámai kawe'á oró. Ísuma pukáimpinkemba usásinankaraiwaintavena kwaásiti sáwí-imayaa sáwí-mayai maitiyuwáníye Áánútu siráiye. mináímbá simátimunda ísámai kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Áánútu Mósesimbo simámakain-amaambo kwáráawaimo ombá minámáánkó kentí sáwí-imayaa íma maitiyuwáínana arupí umái máyáawain-owe Áánútu íma sínívo Ísumo éna kwenááiyavesa áraire sésa kwenká'á aráápamai máyáawaiti sáwí-imayaa maitiyuwáínana miwíyávéna arupí umái máyáawain-owe Áánútu síníye. ");
INSERT INTO kze_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","miráumai Áánútun-aai simátímakowai tááigo kempá'á tivó sé'a kárákwimai kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","naaóvá'á Áánútun-aai simátímakowai agaimarésa sésa árair-aintavai simái sáwí'a on-kwáásí ísáaro. keinárawa'o máyáan-kanaara'a mayáí máyáanda mimbáyáímó awáné'o é'o ímo kesópa'o té'o é'a úwoi puwónááowe. mimbáyáíyávésamo simátimiya'a mináíntávésa íma áraire sénááowe sésa agaimarésa siráawe. mináímbá kempá'á tivó sé'a kárákwimai kawe'á oró Póro siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","mináímbá simásuwena Pórowe Páánápáasiye máápa'a kumónáe kwéuyasa kwaási sésa ókwara'a monor-áímbó ísáan-kanaa tínakai mináímbá másíyata isánaumne ");
INSERT INTO kze_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","simásuwesa máápa'a kumésa sáwíva-kwaasi Yútaa-kwaasiye ó'onkaa-kwaasi Yútaa-monor-ampa'a kwéguwaiye Póronte Páánápáasinte kwa'maésa kuwasaráí sésarai Áánútu úwoi kawe'á umátinkanivo úwoi asiramái kwená aampa'á koró sirááiye. ");
INSERT INTO kze_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","suyaná Yútaa-kwaasi monor-áímbó kwéison-kanaa túwasa mindáópaken-kwaasi amápa'a Ísóigon-aai isánáe sésa Yútaa-mono'-naumpa'a umáyówasa ");
INSERT INTO kze_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yútaa-kwaasi tuwánésa tirumbá sáwí'a úwasa mináímbá kwáráavo sésa Póronte Páánápáasinte aká'áámba simátinkesa kampar-áímbá kwéseye sésa simái kárówasarai ");
INSERT INTO kze_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","miwí táároi íma inkaisésarai asiramái sésarai aiva'á árai'a Áánútun-aai simátimuyamba mináímbá tínaaemba umáme'a íma sínkáiye sembá pó'a aúnái'o umáímo maí'mai'o ónaunda uwóví'a ónaumne-imayaa ombá pókai tayauwerékai ó'onkaa-kwaasiva'a Áánútun-aai kosimátimeyauye. ");
INSERT INTO kze_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ááéma Ísóigo simásimenaya séna emá ó'onkaa-kwaasi sáma kamátinke kesáái kwésimatiminasa kesí aambá awánáíya'a amápa'-maravaken-kwaasi sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkanaumne Áánútu mináímbá simásímakaimba pókai ó'onkaa-kwaasi kwenáái kosimátimeyauye Póro siráiye. ");
INSERT INTO kze_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Póro súwasa ó'onkaa-kwaasi isésa Ísóigon-aaiyavesa aamoí ésa tirumbá kawe'á umái máyówana Áánútu séna kesí kwaási é'a aúnái'a umái maí'mai'a ónááowe súwasa miwí Ísóigon-aaiyavesa áraire sésa kwempá'á tésa méraawe. ");
INSERT INTO kze_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ísóigompa'a aráápamai mésa mimbárává'á Ísóigon-aai kosimátin-tasimatin-uwasá sáwíva-kwaasi isésa ");
INSERT INTO kze_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yútaa-kwaasi Póronte Páánápáasinte tirumbá sáwí'a umátinkesa mindáópaken-anon-kwaasiye aarai túwí'a kwáyon-inimba Yútaa-monor-aimba asiramái máyón-ininte mindárai táái simátimesa miwítí imáyáa tavisuwasá isésa Póronte Páánápáasinte sáwí'a umátinkesa aaisambá tiyésa miwítí maravákémbá ti'mátuwowasarai ");
INSERT INTO kze_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Áánútu minkwáásí íma aamoí umátinkaniye-umasitai'a ésarai tísamaivakem-barama uwáésarai Ántíoku-naopa'a tuwésarai Áíkóniyamu-naopa'a kuyasá ");
INSERT INTO kze_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ántíoku-naopa'a Ísuna aampa'á kun-kwáásí máyówana Áánútun-amanko miwívímbá anómba umátinkowasa tirumbá kawe'á umái méraawe. ");
INSERT INTO kze_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Póroe Páánápáasiye Áíkóniyamu-naopa'a kwésarai ááémo urááyantemba Yútaa-mono'-naumpa'a umésarai áséi-kwasai asiramái simátímúyasa isésa sáwíva-kwaasi Yútaa-kwaasiye ó'onkaa-kwaasiye Ísun-aaiyavesa áraire sésa kwempá'á tésa máyómbanivo ");
INSERT INTO kze_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","évaka-Yutaa-kwaasi Ísun-aaiyavesa tínaaemba umámesa íma áraire sirówai Póronte Páánápáasinte sáwí-aimba simátínkówasa ó'onkaa-kwaasi isésa mindáraiye Ísun-aai ísówaiye tirumbá sáwí'a umátínkómbanivo ");
INSERT INTO kze_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","mindárai ayáátááka'a mindáópa'a mésarai miwí táároi íma inkaisésarai Ísóigon-aai asiramái simátímúyana Ísóigo kwaási úwoi kawe'á kwéumatinkaimba awánaigwae séna mindárai kwená asirayámbá timúwasarai ímo awánarom-bayai kawe'-máyáí máyóyasa ");
INSERT INTO kze_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","mindáópakewai kaepí taaínkaar-urésa évakarawai sésa Yútaa-kwaasi tááiyavesa áraire suwasá évakarawai sésa aantá-kwaasi tááiyavesa áraire siráawe. ");
INSERT INTO kze_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","suwasá ó'onkaa-kwaasiye Yútaa-kwaasiye miwítí anón-kwaasiye torupamái mésa tímááyu-aimba sésa óntandei Póronte Páánápáasinte tínkamonae suwasaráí ");
INSERT INTO kze_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","mináímbá isésarai kawe'ó íyapa'a méyae sésarai Áríkoniyaa-marava'a kwésarai Árísitaa-naopare Tépi-naopare ó'on-o'on-daopare ");
INSERT INTO kze_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","áséi-kwasai simátíma'maesarai kurááiye. ");
INSERT INTO kze_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","moóráwai Árísitaa-naopa'a anówa arupinkémbá aísamai sáwí'a umáguromba maránkarowana íma aaíntómba ááémo maúnka'a ména ");
INSERT INTO kze_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Póro kwésimatimun-aimba iséna árair-aimba kwésimba póna kawe'á umásinkaniye-imayaa úwana Póro minímáyáámó úmba awánéna aráá'a avuwéna ");
INSERT INTO kze_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","anónka'a séna enaísamaine usásinaao súwana usásinkwena aamoí éna kweyááríka'a marapá'á kúmba ");
INSERT INTO kze_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","sáwíva-kwaasi Póromo úmba awánésa miwí tááivinkemba Áríkoniyaa-aimpinkemba sésa kentáásí ísóigorai kwaásiraan-umai marapá'á kentáávímbá kumbáyaaiye sésa ");
INSERT INTO kze_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","miwítí ísóigo áwí'a mindárai tamátimesa sésa Páánápáasintavesa Súsiye sésa Pórontavesa aaiyé simátímíwaiye sésa Émísiye sirá. ");
INSERT INTO kze_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","marukón-awampa'a minkámpár-ísóígó áwí'a Súsi kwená mono'-námbá kwáyowana minkámpár-ísóígóntáváí ísámai póí'o umándon-kwaasigo purumakambá kwémaena moigwáán-aramba kwétararena umái maimaéna mindáókona kuri-óntárá'á mói marówasa sáwíva-kwaasi miwítí ísóigontavaimo póí'o umándaante miráumai Ísuna aantá-kwaasiraira'a póí'a umándanae ");
INSERT INTO kze_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","sun-áímbá isésarai sáwí'an-iye sésarai kentí unáánkwátói tarátuwesarai isaaisésarai sáwíva-kwaasivimba komaésarai anónka'a sésarai ");
INSERT INTO kze_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","kenkáí nóra ónáera kwéoo. keiráí kemó onten-kwáásí úye. áséi-kwasai tasimátimuyamba pó'a mirán-kámpárí'o tuwé'a árair-Isoigompa'a teró. árair-Isoigo kwíyómba éna maramá éna uwí-nómbá éna mimpímbá kwáyáin-tantaa'a úmarena asirayánkwáráwáí máyáiye. ");
INSERT INTO kze_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ááéma Áánútu úwoi tíyukowa'a kentí imáyáavinkemba amápa'-mapaken-kwaasi kwénaaesa ");
INSERT INTO kze_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","miráumai kwéombanivo Áánútu máyáiye sígwáe séna aaí sisaná aa'á téna toónkó kawe'á isa'á kwéne'a tirumpimbá aamoí kwéowe. miráumai awáné'a mirámá iní-Ísóígó máyáiye sígwáe séna Áánútu kawerí'a kwéiye ");
INSERT INTO kze_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","mindárai mináímbá suyasá amápa-kwaasi asirésa mindáraira'a póí'a umándanaumne kwésuwasarai íma mirá oró simái tuvímbaesarai íyúyasa ivátukaawe. ");
INSERT INTO kze_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ivátuwowasa évaka'-Yútaa-kwaasi Písítiyaa-marava'a Ántíoku-naopakemba évaka'a Áíkóniyamu-naopakemba tésa amápa-kwaasiti imáyáa tavisuwasá isésa Póromba óntandei tuvuwésa á'a púwiye-imayaa ésa tavisímaesa mindáókona awámpá'á mátúwówasa ");
INSERT INTO kze_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ísuna aampa'á kuwáí taúkúmakesa taawánowana usásinena mindáópa'a kwéna kogaúmba usá aaváyaavimba usásinesarai Pórowe Páápápáasiye mindáópa'a tuwésarai Tépi-naopa'a kurááiye. ");
INSERT INTO kze_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pórowe Páánápáasiye Tépi-naopa'a áséi-kwasai kosimátímúyasa isésa áraire sésa Ísuna aampa'á kwéguwasarai mindárai Árísitaa-naopa'a ókwara'a komésarai minkákémbá Áíkóniyamu-naopa'a komésarai minkákémbá Písítiyaa-marava'a Ántíoku-naopa'a ókwara'a komésarai ");
INSERT INTO kze_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","miráumai kwénaaesarai Ísóigon-aaiyavesa áraire sirówai miwítí imáyáa asiramátinkesarai sésarai Ísuna aampa'á asiramái koró sésarai Áánútu kwená kwaási kwégawaaipa'a kónáe sé'o é'a minámpá'á umbaiyé tain-ámpá'á kónááowe sésarai ");
INSERT INTO kze_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","miráumai mindáópata kwénaaesarai maará ésarai Ísóigona kwaásivinkemba miwítí anón-kwaasi usásintinkava'a kuyasá Áánútuna imáyáa ésa toómbá íma nésa námúnaawe su'mai kwésesa mindárai Ísóigompa'a aráápamai máyówaiyavai Ísóigo kárákwitinkamae iyíníye simátímakaaiye. ");
INSERT INTO kze_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","simátimesarai Písítiyaa-marava'a kóyaaitesarai Pámpíriyaa-marava'a kwésarai ");
INSERT INTO kze_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pékaa-naopa'a komésarai áséi-kwasai kosimátimesarai minkákémbá Átériyaa-naopa'a kumésarai ");
INSERT INTO kze_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","nompí-sípí táto'mai usáatesarai teémesarai Síriyaa-marava'a Ántíoku-naopa'a ókwara'a tirááiye. ááéma mindáópa'a Ísóigona kwaási mindáraiyavesa Áánútu túwa'naa úmaena iyínívo kwená mayáí komáyáakaiyo sirówasarai mimbáyáí komaisuwésarai tirááiye. ");
INSERT INTO kze_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ántíokuva'a tuyasá Ísóigona kwaási tayorupamái máyówasarai Áánútumo simátimuni'o urááyan-aimba sésarai Ísuna aampa'á ó'onkaa-kwaasi agaráátinkauyasa mináíntáváí áraire sésa minámpá'á kwégowe-aimba tasimátimesarai ");
INSERT INTO kze_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","mindáópa'a Ísun-aai ísówai ayáátááka'a méraaiye. ");
INSERT INTO kze_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ántíoku-naopa'a máyóyasa évakarawai Yútiyaa-maravakemba Ántíoku-naopa'a komésa Ísun-aai ísówaiyavesa sésa Áánútumo Mósesimbo simámakon-amaambo ímo isé'o túra'o kárámaimo araa'énamo íyanamo éna Ísóigo sáwí'o umáímo máyáampinkemba kawer-ámpá'á íma métinkaniye suwasaráí ");
INSERT INTO kze_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pórowe Páánápáasiye mináíntáváí áwáá'a tiyésarai kwesimá kwesiman-esa Ántíokuvakewai Ísun-aai ísówai sésa Yérúsaremuva'a aantá-kwaasiye Ísóigona kwaásiti anón-kwaasiye mináíntáváí kotísaa oró sésa Póronte Páánápásinte évaka-kwaasiye ti'márówasa kuráawe. ");
INSERT INTO kze_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ísóigona kwaási ti'márówasa kweémesa Vínísiyaa-marava'a Sámériyaa-marava'a naaó'-nao'a komáyówasa Ísun-aai ísówai torupamái máyówai simátimesa sésa ó'onkaa-kwaasi Ísun-aai isésa áraire sésa kwempá'á tésa máyáawe suwasá isésa tirumbá kawe'á úwasa ");
INSERT INTO kze_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","naaó'-nao'a simátímatuwesa kweémesa Yérúsaremu-naopa'a komáyówasa aantá-kwaasiye Ísóigona kwaásiye miwítí anón-kwaasiye tiyáámba kwétimesa aamoí uwasá Áánútumo mayáímó tímakaim-bayaimo mairáan-aimba másimatimuwasa ");
INSERT INTO kze_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","isésa évakarawai Ísun-aaiyavai áraire sumbánivo ámáán-kawaa-kwaasiti aampa'á kwéguwai usásinesa sésa ó'onkaa-kwaasi Ísun-aaiyavai áraire kwésewai Mósesi simátímakon-amaamba isésa túra'a kárámai araa'éna orómá kosimátíméro suwasá ");
INSERT INTO kze_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","aantá-kwaasiye anón-kwaasiye sésa mináímbá torupamái méta imáyáa umáíya senó siráawe. ");
INSERT INTO kze_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","suwasá torupamái mésa ayáátááka'a mináímbá suwaná Pítaa usásinena séna kesí kwaásiyono. ó'onkaa-kwaasi áséi-kwasai isésa Ísun-aaiyavai áraire sígwáe séna ááéma Áánútu keinárawapinkemba usásisinkena si'marówa'a kosimátimewanasa isésa áraire siráawe. kemá mináímbá á'a ísaraawe. ");
INSERT INTO kze_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Áánútu amápa-kwaasiti imáyáa tuwánéna ó'onkaa-kwaasiyavena séna kesí kwaásiman-owe séna kwenamambó símakonten-umai miwímó tímakomba awánaraumne. ");
INSERT INTO kze_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Áánútu Yútaa-kwaasiya ór-amba íma agaráásinkenaya ó'onkaa-kwaasi íma ór-amba agaráátinkena kwéivo Áánútu amápa-kwaasiya mimbórá-ámbá kwéagaraasinkaiye. miwí Ísun-aaiyavai áraire sunkákémbá miwítí sáwí-imayaa maitiyuwéna kawer-ímáyáá umátínkaraiye. ");
INSERT INTO kze_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mósesin-aaigo kentáá síkwá'náya umbaí tiyówasa íma kanaán-umai kwakáawe. kentáágwárá'á miráumai umbaí taisatá íya kanaán-umai kwakáumne. mindáyavai ó'onkaa-kwaasi Ísuna aampa'á kowáíyáváímó Mósesin-aai kwáráaro síyasamo ésa umbai-ámbá kwaránááowe. mirámó íyanamo éna Áánútu áwáá'a sína'a pó'a íma mirá ónááowe. ");
INSERT INTO kze_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ísóigo Ísu úwoi súwa'naa enaya sáwí'o umáímo máyaundavinkenta kawer-ámpá'á mégwésinkaintaawe. mináíntáváíyá áraireya sénáisae mirámó kwéintenta ó'onkaa-kwaasigwara'a mirá kwéiye Pítaa siráiye. ");
INSERT INTO kze_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pítaa súwasa isésa amáparawai árai'a siyé sésa íma aaí suwasaráí Pórowe Páánápáasiye Áánútu tímakaim-bayai ó'onkaa-kwaasivimba mimbáyáí mairááyan-aimba simátimesarai Áánútuna mayáí ímo awánaraam-bayai kawe'-máyáí mairááyan-aimba ");
INSERT INTO kze_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","simátímatuwoyana Yémési séna kesí kwaásiyono. kesáái ísáaro. ");
INSERT INTO kze_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ááéma Áánútu ó'onkaa-kwaasiyavena imáyáa éna minkwáásívínkémbá évakarawai usásintinkena séna kesí kwaásiman-owe siráin-aimba Pítaa ívé'a simásímakaiye. ");
INSERT INTO kze_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Áánútun-aai simátímakowai mináímbá aúváí-kwandaaivimba agaimarésa sésa ");
INSERT INTO kze_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ísóigo séna naaémba kumé'a Tévítina naambá tawísíyukaan-damba kunumásuwanaumne. sáwí-yantaakwara'a kawe'á kunumásuwanaunda pósa ");
INSERT INTO kze_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ó'onkaa-kwaasi kesópa'a ténááowe. kesí kwaásiman-owe sendawáí kesópa'a ténááowe séna ");
INSERT INTO kze_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ísóigo mináímbá naaóvá'á sirómba póna ívékwara'a mirá kwésiye Yémési siráiye. ");
INSERT INTO kze_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yémési simásuwena séna Ísóigo siráin-aintave'a imáyáa é'a sé'a ó'onkaa-kwaasi Áánútumpa'a kwéten-kwaasi umbai-máyáí íma timénaumpo ");
INSERT INTO kze_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","aúváíma agaimái timéta séta kampar-ísóígóntáváí imáyáa ésa póí'o umándaamba mimpóí íma naaró. aarai-úmóyámbá kwaai-úmóyámbá íma oró. póíma tuvú'newana kwená naaemá ímo kumíndamo úwoimo kwáyáina'a mimpóí íma naaró. naaegwárá'á íma naaró. mináímbá aúváí-kwandaaivimba agaimaráúmpo awánaaro. ");
INSERT INTO kze_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ááémo maémáén-kwaasiye ívé'o máyáan-kwaasiye ayáátááka'a aasiyaasí monor-áímbá kwéisaan-kanaara'a mináímbá Mósesin-aai simátíma'maesa kuráawe. mindáyaveta aúváí-kwandaaivimba agaimaráúmpo awánaaro Yémési siráiye. ");
INSERT INTO kze_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","súwasa aantá-kwaasiye Ísóigona kwaásiye miwítí anón-kwaasiye sésa kanaám-pota kentáávímbá évakarawaiye ti'máráanasaya Pórowe Páánápáasiye Ántíokuva'a kwíyapa'a miwísé kónááowe sésa miwítí avumpinkémbá kae-kwáásí túwí'a mósá makáan-kwaasirai túwí'a tombá moóráwai áwí'a Sáírási úwana moóráwai kaer-áwí'á Yútásiye Paasapasíyé umái ");
INSERT INTO kze_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","aúvái timésa ti'márówasa kurá. mináúváívímbá agaimarésa maará sésa kesáá kentí kwaásiya úne. aantá-kwaasiye anón-kwaasiye moórá-aimba sénaumpo kentáásí kwaási ísáaro. ó'onkaa-kwaasi Ántíoku-naopa'a Síriyaa-marava'a Sírísiyaa-marava'a máyáan-kwaasi ísáaro. ");
INSERT INTO kze_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","kentáávínkémbá évakarawai kentópa'a kwésa ímo simátímakaunda-aimba miwítí imáyáavinkemba kosimátímúwa'a isé'a tirumbá sáwí'a úwa'a umbaí taráanta iséta ");
INSERT INTO kze_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","torupamái méta imáyáa éta mimbórá-áímbá simái kae-kwáásí usásintinketa ti'maráúnasaya Páánápáasiye Póroe migóiye. mindárai kesí kwaásiya siruntá tímakaundanaraiye sínkamiyakai puwúyavo-imayaa íma ésarai Ísóigo Ísu Káráísitina mayáí kwémayauye-imayaa ésarai asiramái kwémayaaiye. ");
INSERT INTO kze_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yútásinte Sáírásinte ti'maráúnasarai migóíyamba pósarai aúváívinken-ainkwara simátimeyaaoi-ainkwara'a mimbórá-áímbá pósarai kosimátimeyaaoiye. ");
INSERT INTO kze_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Áánútun-amankowe kesááwé mimbórá-áímbá simáíya íma umbai-áímbá simátimumpo maanáúváívínkén-áímbá simátimundaya ísáaro. ");
INSERT INTO kze_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kampar-ísóígóntáváí imáyáa ésa póí'o umándaamba mimpóí íma naaró. naaemá íma naaró. póímo tuvú'newana kwená naaemó ímo kumíndamo úwoimo kwáyáina'a mimpóí íma naaró. aarai-úmóyámbá kwaai-úmóyámbá íma oró. kesáámó súnda-aimbo é'o é'a kawe'á ónááowe. mináímbá ánásaiye. aúváíma agaimái timésa siráawe. ");
INSERT INTO kze_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","suwasá mináúváímá timésa ti'márówasa maimaésa kweémesa Ántíoku-naopa'a kuwasá Ísóigona kwaási torupamái máyówasa mátímúwasa ");
INSERT INTO kze_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","mináúváí-kwándááívínkémbá táápamai simátímúwasa kawer-áímbá isésa tirumbá kawe'á úwasarai ");
INSERT INTO kze_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yútásiye Sáírásiye Áánútun-aai simátímakoyan-kwaasi ayáátááka'a simátimesarai miwítí imáyáa arupí umátímúyasa isésa asiramái máyówasarai ");
INSERT INTO kze_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","miwísé évaka'-no'waamba máyóyasa Ísun-aai ísówai sésa á'a kanaán-ivo ti'mákaan-kwaasitopa'a kawer-áímbá kosimátímékaiyo suwaná ");
INSERT INTO kze_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sáírási ó'on-imayaa éna mindáópa'a máyowasarai ");
INSERT INTO kze_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pórowe Páánápáasiye ayáátááka'a Ántíokuva'a mésarai mindáraiye évakarawaiye mésa Ísóigon-aai simátíma'maesa kuráawe. ");
INSERT INTO kze_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","naaémba Póro Páánápáasintavena séna naaó'-nao'a Ísóigon-aaimo simátímakauyamba Ísun-aaimo ísaraawai kawerá umáíya máyáawa tuwánámaekai kóyauye Póro súwana ");
INSERT INTO kze_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Páánápáasi séna Yóni Máákaamba áí'mekai kóyáe súwana ");
INSERT INTO kze_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Póro séna kweséya téwáyana Pámpíriyaa-marava'a kenkáí másiyuwena kwená naaópa'a tayauweréna kuráimba pókai íma áí'mekai kóyauye Póro súwasarai ");
INSERT INTO kze_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","mináíntáváí kayorésarai aaisambá simásuwesarai mindárai tarákaar-uyaná Páánápáasi Yóni Máákaamba áí'maena nompí-sípí táto'mai usáatesarai kweémesarai Sáíparasi-marava'a kuyaná ");
INSERT INTO kze_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Póro séna ke Sáírásimba airánaumne súwasa Ísun-aai ísówai námúnaa simásuwesa sésa Ísóigo úwoi kawe'á umátinkanivo kokaiyó suwaná Sáírásimba áí'maena kúmba ");
INSERT INTO kze_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Síriyaa-marava'a Sírísiyaa-marava'a naaó'-nao'a kwénaaesarai Ísóigona kwaási túwa'naa úmaesarai kuyasá kawe'á umái méraawe. ");
INSERT INTO kze_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pórowe Sáírásiye mirá uyambá Tépi-naopa'a Árísitaa-naopa'a kuyaná moóráwai áwí'a Tímóti mindáópa'a ména Ísuna aampa'á kwéguwai úwana anówama Ísuna aampa'á kwégun-inimba Yútaa-inimba úwana avowámá Kíríki-kwaasi úwana umái máyówasa ");
INSERT INTO kze_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Árísitaa-naopakewai Áíkóniyaa-naopakewai Ísun-aai ísówai Tímóti áwí'a mósá makáawe. ");
INSERT INTO kze_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","avowámá Kíríki-kwaasi póna áúra'a íma kárámai araa'éna urómba pósa Yútaa-kwaasi mináyámpá'ó máyáan-kwaasi mirán-áímbá ísówana Póro séna Ísóigona mayáírá'á Tímótimba airánáe séna Yútaa-kwaasi aamoí ígwáe séna Tímótimba áúma kárámarena ");
INSERT INTO kze_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","áí'maena naaúwasa naaó'-nao'a kwénaaesa aantá-kwaasiye Ísóigona kwaásiti anón-kwaasiye Yérúsaremuva'a siráan-aimba Ísóigona kwaásiyavai simátíma'maesa kweésa sésa mináímbá ísáaro suwasá ");
INSERT INTO kze_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ísóigona kwaási Ísumpa'a asiramái mésa ó'on-kwaasi simátíma'maesa kuwasá isésa aasiyaasi-táwai évakarawai Ísun-aaiyavesa áraire sinté kwégwesa sáwíva-kwaasi-i'a uráawe. ");
INSERT INTO kze_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pórowe Sáírásiye Tímótiye Vírísiyaa-marava'a Kárésiyaa-marava'a kwénaaesa Ésiyaa-marava'a áséi-kwasai kosimátimenae sumbá Áánútun-amanko íma kónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","isésa kweémesa Mísiyaa-maragona oóvímbá kwésa Pítíniyaa-marava'a kónáe sésa uwaná Ísun-amanko íma kónááowe súwasa ");
INSERT INTO kze_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","isésa Mísiyaa-marava'a kómaatesa kweémesa Táróasi-naopa'a kumbésa ");
INSERT INTO kze_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","no'wáámba Póro kaainkáámbá awánówana Másétóniyaa-maravaken-kwaasigo koku'á taména séna Másétóniyaava'a tasúwa'naa uwo asiramái súwana ");
INSERT INTO kze_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Póro kaainkáámbá awánéna simásimuwata usásineta séta Másétóniyaa-kwaasiya áséi-kwasaiya kosimátimunanaya Áánútuya kwésaayaisata Másétóniyaava'a kónáeya siráundayaawe. ");
INSERT INTO kze_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","séta Táróasi-naopa'a nompí-sípí táto'mai usáateta kówánanaya mindómpí-sípígó apu úmaena kúwata Sámóteresi-marava'a kogwaéwándaya usá aaváyaavimba kweémeta Níápórisi-naopa'a marapá'á kunásáveta ");
INSERT INTO kze_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","minkákémbá Vírípai-naopa'a marapá'á kuráundayaawe. mindá Másétóniyaa-marava'a anón-daopa'a Árómáani-kamaani-kwaasi kárákwiraan-daopa'a évaka'-no'waamba kógwaeta ");
INSERT INTO kze_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Yútaa-kwaasi monor-áímbá kwéison-kanaa túwata imáyáa éta Yútaa-kwaasi nonawámpá'á torupamái mésa námúnaa kwésewe séta naaópa'a tuwéta nonawámpá'á kumówándaya aaraiyómbá torupamái máyówata kumbéta simátimewanasaya ");
INSERT INTO kze_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","isésa uwaná moórá-ininko Táyátaira-naopaken-ininko áwí'a Árítiyaama kwená mayáí óoraan-tantaa'a ampantará'á tásuwena kwétimena óntamba kwémaena kwemá Áánútuna imáyáa éna kwenáwí'a mósá makón-inimba Ísóigo imáyáa amúwana Póron-aai kawe'á umái isówana ");
INSERT INTO kze_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","minínínkógwárá kwená akúnkwárá'á nombá pétinkowana minínínkó séna kentáváí sé'a Ísóigon-aaiyavena áraire séna Ísumpa'a asiramái máyáin-ininkoman-iye sé'a kesí naaúmpa'a taménaaowe asiramái súwata kwená naaúmpata koméraumne. ");
INSERT INTO kze_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","moórá-arasi mayáí kwémayon-arasigomba évakarawai óntamba tuwésa meéyán-uráan-arasigomba taraváá-kwámbá kwenarumpimbá máyowana évaka-kwaasitopa'o naaémbo kwínín-aimba simátimuwasa óntambo ámúmba kwembó meéyámbakaan-kwaasi timúwasa maémáémbani. moórá-tawai námúnaa kwésupa'a kumówánanaya minárásígó suwánéna ");
INSERT INTO kze_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Póronte kenté sínaaemba kwa'maéna kwégwena anónka'a séna Áánútu kwíyómpa'a máyáiwaina mayáí kwémayaan-kwaasiman-owe. Áánútu sáwí'o umáímo máyáampinkemba kawer-ámpá'á mégwétinkain-aimba kwésimatimewaiman-owe minárásígó séna ");
INSERT INTO kze_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","sáwívaka'a kwa'maéna kwégwena mirá súwana Póro arumbá umbaí tówana mégwantena kwenarumpimbó máyon-taravaa-kwankontavena séna Ísu Káráísitina asirayámbá kwáyáintavai égési umái sé'a minárásí auwé kóaao súwana avekáámbá auwéna kóúwasa ");
INSERT INTO kze_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","minárásígómbó meéyán-uráawai awánésa tirunkó sáwí'a úwasa sésa íma kawer-óntámbá mayánaumne sésa Póronte Sáírásinte tiyáánka'a táto'mai tavisímaesa naambárupa'a kawáá-kwáásítópa'a mátinkesa ");
INSERT INTO kze_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Árómáani-kamaani-kwaasitop'a mátinkesa sésa maandárai Yútaa-kwaasirai kentáásí naaópa'a sáwí-mayai kwémayaaiye. ");
INSERT INTO kze_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","kentáásí ámáámba kwégaresarai ó'on-ampar-amaamba kwéseye. maandáraimo séyan-amaamba íya kwaránaumpo Árómáani-kwaasiti ámáámba kwaránaumne suwasá ");
INSERT INTO kze_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","sáwíva-kwaasi taúkúmaresa anónka'a símae iyésa sésa áraire suwasá kawáá-kwáásí mindáraiti unáánkwátói tarátiyuwesa sésa kunánaandei tínkamoro suwasá ");
INSERT INTO kze_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ávááraumai tínkambaresa tavisímaesa ándáva'a avúsúyuwesa ándáva'o kárákwiron-kwaasiyavai sésa ontará'á kárákwimai mindárai kawe'á uwo suwaná ");
INSERT INTO kze_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","avumpin-dáúmpá'á móavusuyuwena tísamairai taaí umairéna aráápamarena ándánei kárárumarowasarai méraaiye. ");
INSERT INTO kze_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","mésarai no'wáán-avuntamba Pórowe Sáírásiye námúnaa kwésesarai Áánútuna imá kwésuyasa ándáva'o máyón-kwaasi ísówana ");
INSERT INTO kze_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","avekáámbá anóm-barima tówana naamayáámbá karekó'a umágúwana amápar-ontama tigúwana ándáva'o máyón-kwaasi tíyayaampimpaken-andama kweyááríka'a ayúkúwasa ");
INSERT INTO kze_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ándá-naumpa'o kárákwirowai aúmá kwáyomba póna usásinena awánómba ontan-tigurówana usáawanena séna ándá-kwaasi kóuraawe-imayaa éna anón-kwaasigon-aaroi inkaiséna kwená taánasatama mósá taúkéna kwenáúvimba agaiváíndayavena úwana ");
INSERT INTO kze_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Póro awánéna anónka'a séna íma mirán-uwo. kesáámá amápata úwoiya máyaumne súwana ");
INSERT INTO kze_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ándá-naumpa'o kárákwirowai kwená kwaásiyavai séna oómbá kúra-simero súwasa kúrar-amuwana avekáán-umai ándá-naumpa'a iyúmba ayántámbá kwétowana anóndaraima óye séna Póronte Sáírásinte tísamaivimba kumbaéna ");
INSERT INTO kze_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","usásinena tí'maena máápa'a kumbéna séna nóra onaná sáwí'o umáímo máyaundavinkemba Áánútu kawer-ámpá'á mésinkaniyo súwasarai ");
INSERT INTO kze_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","mindárai sésarai Ísóigo Ísu Áánútumpakemba kunkáiwain-aaiyavai áraire sinaná ewé ená akúné sáwí'o umáímo máyáampinkemba kawer-ámpá'á métinkaniye simámesarai ");
INSERT INTO kze_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","minkwáásíyómbá Ísóigon-aai simátímúyasa isésa ");
INSERT INTO kze_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","mindó'wáán-avuntamba ándá-naumpa'o kárákwirowai tí'maena tirósáánumpar-avima kwésese umátiyuwena mitáwai kwesé kwená kwaásiye mono'-nómbá pékaawe. ");
INSERT INTO kze_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","nombá pé'maena Póronte Sáírásinte tí'maena kwená naaúmpa'a mátínkarena toómbá timúwasarai kwénoyasa kwewé kwená akúné Ísun-aaiyavai áraire siráamba pósa tirumbá kawe'á umái méraawe. ");
INSERT INTO kze_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","máyówasa usá aaváyaavimba Árómáani-kawaa-kwaasi i-kwáásí ti'márówasa ándá-naumpa'a kwésa sésa mindárai ayútínkénasarai kókaiyo suwaná ");
INSERT INTO kze_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ándá-naumpa'o kárákwirowai Pórontavai séna Árómáani-kawaa-kwaasi i-kwáásí ti'márááwasa tésa sésa Póronte Sáírásinte ayútinkaao sembá pókai ayútínkáanakai tirumbá kawe'á ínakai kokaiyó súwana ");
INSERT INTO kze_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Póro i-kwáásíyáváí séna íma kawer-áímbá sésa kempímbá íma kwáyáin-aimba simái kunánaantamba sínkamesa ándáva'a avúsúyukaawe. Árómáani-kwaasiti aúváíma tokáuyan-kwaasi úyambanivo sínkamomba uwóví'a ésa minámáámbá káráyukaawe. ívé'a aúpá'á ayúsinkai-imayaa owakáí íma mirá óyauye-imayaa ékai Árómáani-kawaa-kwaasi kesópa'a tésa ontá tayisúwéwakai kóyauye Póro súwasa ");
INSERT INTO kze_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","i-kwáásí isésa koyauwerésa Póron-aai tasimátimesa Árómáani-kwaasiti aúvái tokááin-kwaasiye simátímúwasa isésa táátavai ésa ");
INSERT INTO kze_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ándá-naumpa'a komésa sésa keinárai Árómáani-kwaasiti aúváíma tokááyan-kwaasi óyata íma ísareta úwoiya tínkankaunda mindá uwóvíta éta tínkankaumne sésa tí'maesa máápa'a kumésa aánoumai sésa kentáásí naaópa'a tuwékai kokaiyó suwasaráí ");
INSERT INTO kze_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pórowe Sáírásiye ándáva'a tuwésarai Árítiyaana naaúmpa'a kuyasá Ísun-aai ísówai torupamái máyówasarai miwítí imáyáa kawe'á umátinkesarai tiyuwésarai kurááiye. ");
INSERT INTO kze_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pórowe Sáírásiye kwésarai Ámpíporisi-naopa'a Ápóróniyaa-naopa'a kóyaatesarai Tésárónaikaa-naopa'a kuyaná mindáópa'a Yútaa-kwaasiti mono'-námbá kwáyowana ");
INSERT INTO kze_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Póro úntemba Yútaa-kwaasi monor-áímbá kwésunka'a mono'-náúmpá'á uména Áánútun-aai aúváí-kwandaaivinken-aimba simátimumba monor-áímbó ísáan-kanaara'a kaumborá'á simátimena ");
INSERT INTO kze_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","séna aúváí-kwandaaivinkemba séna Áánútumo usásinankaiwaimba áí'a índai'a umánkaiyana puwéna usásinaniye siráimba mináínkóná ááimba avora'á simátimune. mináímbá Ísuntavesa siráawe Póro súwasa ");
INSERT INTO kze_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","isésa Yútaa-kwaasi évaka'a mináíntávésa áraire sésa Póronte Sáírásinte tínaaemba kwarésa Kíríki-kwaasi Áánútuna imáyáa mósá márówaiye sáwívar-inimba túwí'a kwáyon-ininte miráumai-sawiva-kwaasi kwakáawe. ");
INSERT INTO kze_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","kwárówasa Yútaa-kwaasi tuwánésa tirumbá sáwí'a úwasa sésa mináímbá kwáráavo sésa sáwí-kwaasi kavóná-kwaasi tirówasa torupamái mésa áái'a tiyánáe sésa imáyáa tímúwasa Yésónona naambá taúkúmaresa Póronte Sáírásinte tayáto'maeta amápa-kwaasi túranka'a aaivintá maitinkánáisaiye sésa tivakáá umbá ");
INSERT INTO kze_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","íma máyóyasa Yésónowe Ísun-aai ísówai évakare tavisímaesa mindáópaken-kawaa-kwaasitopa'a mátinkesa anónka'a sésa Pórowe Sáírásiye sáwí-aimba kwémaresarai amápa'-marava'a kwétesarai ívé'a maankákwárá'á kentáásí naaópa'a tamáyaayana ");
INSERT INTO kze_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yésóno kwená naaúmpa'a matínkaraiye. Árómáani-aiva-kawaanakona ámáámba karésa sésa kentáárá'ó kárákwiraiwai Ísuman-iye kwésewe suwasá ");
INSERT INTO kze_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","amápa-kwaasiye kámááni-kawaa-kwaasiye isésa tirumbá sáwí'a úwasa áái'a tiyáí-ímáyáá uwasá ");
INSERT INTO kze_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","kawáá-kwáásí Yésónompi kwimái évaka-kwaasiyavai sésa óntamba simíyata ayútínkáana'a ti'mátuwaaro suwasá óntamba tímúwasa ayútínkówasarai kurááiye. ");
INSERT INTO kze_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ayútínkówasarai kuyasá no'wááni'a únka'a Ísun-aai ísówai Póronte Sáírásinte tínkamovo sésa ti'márówasarai Pérea-naopa'a kweémesarai kuyambá Yútaa-kwaasiti mono'-náúmpá'á umésarai Ísun-aai simátímúyasa ");
INSERT INTO kze_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","minkwáásíyómbá íma Tésárónaikaa-kwaasiraamba ésa kawer-ímáyáá kwéesa Póron-aai kawe'á umái isésa aasiyaasi-táwai Áánútun-aai aúváí-kwandaaivimba awánésa sésa Póro áraira kwési. kampará kwésiyo sésa aasiyaasi-táwai Áánútun-aai aúváí-kwandaaivimba táámpamai awánomba ");
INSERT INTO kze_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yútaa-kwaasi sáwívarawai Ísun-aaiyavesa áraire suwasá Kíríki-inimba túwí'o kwáyon-inimba sáwíva'a Ísun-aaiyavesa áraire suwasá Kíríki-kwaasi sáwívarawai Ísun-aaiyavesa áraire suwasá ");
INSERT INTO kze_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Póro Pérea-naopa'a Áánútun-aai kwésimatimiyemo sun-áímbá Yútaa-kwaasi Tésárónaikaavaken-kwaasi isésa Pérea-naopa'a tésa miwítí imáyáa tayavisimái suwasá isésa Póromba áwáá'a aéésa áái'a tiyamánkai-imayaa uwasá ");
INSERT INTO kze_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","avekáámbá Ísun-aai ísówai Pórontavai inkámóvo sésa uwí-nómpá'á kumuwó suwaná kumúwasarainivo Sáírásiye Tímótiye mindáópa'a úwoi máyóyasa ");
INSERT INTO kze_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Póromba áí'maesa kumeémesa Áténesi-naopa'a móruna auwésa kuntauwerésa miwítí naaópa'a iyésa Sáírásinte Tímótinte usimátimesa sésa avekáán-umai kesópa'a kúmókaiyo Póro siyé usimátímakaawe. ");
INSERT INTO kze_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Póro Áténesi-naopa'a kuména Sáírásinte Tímótinte kwétimu'marena awánómba mindáópaken-kwaasi sáwíva'a kampar-ísóí úmakesa miwán-áwí'a mósá kwémarowana Póro tuwánéna arumbá umbaí tówana ");
INSERT INTO kze_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yútaa-kwaasiti mono'-náúmpá'á uména Yútaa-kwaasiye ó'onkaa-kwaasi Áánútuna imáyáa mósá márówaiye usimátimena Áánútuna áséi-kwasai usimátimena aasiyaasi-táwai mindáókona marupá'á máyón-kwaasi Áánútun-aai simátíma'maena iyúwasa ");
INSERT INTO kze_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Épíkúriyaan-aai ísámai kuwáíyé Sítóikin-aai ísámai kuwáíyé Póronopa'a tésa kwesimán-kwesiman-esa évakarawai sésa aaiyé símaena nááín-kwaasi nóine kwésiyo suwasá évakarawai sésa ó'om-bapaken-isoigontavena kwésiye sumbá Póro Ísun-aai séna pukáimpinkemba usásinkaiye simátímakaintavesa mináímbá suwasá ");
INSERT INTO kze_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Póromba áí'maesa kawáá-kwáásímó torupamái mésamo évakar-aimbo simáímo kawer-un-áyámpá'á áwí'a Áríópagasi-ayampa'a Póromba áí'maesa máankesa sésa aúná-aimbo kwésimatimenda-aimba simásímínata ísáano. ");
INSERT INTO kze_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","kesáá mináíntá isáúnda mináínkó á'oran-ivo ókwara'a mináínkóná ááimba simásímínata ísáano sésa ");
INSERT INTO kze_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Áténisi-naopaken-kwaasiye ó'om-bapaken-kwaasi mindáópa'a tamáyón-kwaasiye aasiyaasi-táwai torupamái mésa aúná-aine su'mai kwésewe. mindáyavesa mináínkóná ááimba simásímínata ísáano siráawe. ");
INSERT INTO kze_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","suwaná Póro usásinena Áríópagasiva'a torupamái máyón-kwaasiyavena séna Áténisi-naopaken-kwaasi ísáaro. monotávé'o asiramáímo máyáawai á'a tuwánaraumne. ");
INSERT INTO kze_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","kentí naaópa'a kwénaae'a tuwánáúna'a évaka-tantaa'a úmake'a miwán-áwí'a mósá kwémaraamba tuwánaraumne. óntan-taareira'a aúváíma agaimaréna séna íma awánáúnda-isoigontavai maanóntán-tááréímá úmakaumne agaimaréna siráimba úwa'a awánaraumne. minísóígómbá íma awánaan-isoigon-aai simátimune. ");
INSERT INTO kze_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","kwemá kwíyómba maramá mimpímbá kwáyáin-tantaa'a úmarena amápa-tantaaka'a kárákwirena íma kwaási úmakaan-daumpa'a méraiye. ");
INSERT INTO kze_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","kweyááma kwaásimo máyáawaina ááinkoma póna tááma kwétimena amápa-kwaasira'a kárákwiyena kwempímbá ímo ááimo ánkaraiwaima póna íma kwaási kwembá áwa'naa owáímán-iye. ");
INSERT INTO kze_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Áánútu aiva'á moórá-kwaasi úmakowasa kwempínkémbá ó'on-o'on-kwaasi sáwíva'a paáruresa amápa'-marava'a kóyáwé uráawe. Áánútu kwená imáyáavinkemba amápa'-marama taaín-timena amápa-kwaasiti kanaamá makáiye. ");
INSERT INTO kze_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","kembá sivakáá-umai suwánaigwae séna Áánútu mirá uráiye. kwemá íma némpa'a máyáivo egwaa'á máyáimba póta awánanaundayaawe. ");
INSERT INTO kze_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","moóráwai séna kwemá máyáísata póta kesáámá máyaumne siráiye. keinárawapinkemba moóráwai agaimaréna séna árai'a kwená iyámpóíya úne agaimaréna siráiye. ");
INSERT INTO kze_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Áánútuna iyámpóíya póta kwaásimo kentí imáyáavinkembo óntambo úmaken-tantaatavetaamo éta kesivowéyá íma sénaumne. ");
INSERT INTO kze_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ááémo miwímó mésamo sáwí'o umbá Áánútu miwíyávéna íma sáwívar-aimba siráivo ívé'a amápa'-mapaken-kwaasiyavena séna sáwí-amba tuwé'a kesópa'a teró Áánútu kwésiye. ");
INSERT INTO kze_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","kwená imáyáavinkemba amápa-kwaasi aaivimbá maitinkánín-kanaama tíníye. aaivimbó maisinkánín-kwaasiya á'a usásinankaraiye. pukáimpinkemba usásinankaraimba pósa árai'a kwemá aaivimbá maisinkáníntaaniye sénááowe Póro siráiye. ");
INSERT INTO kze_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","pukáimpinkemba usásinankaraiyemo súmba isésa évakarawai aká'áámba suwasá évakarawai sésa moórá-tawaimo índa simásímínata ísáano suwaná ");
INSERT INTO kze_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Póro tiyuwéna kóúwasa ");
INSERT INTO kze_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","évakarawai kwenánaaemba kwa'maésa kwésa kwenáái isésa Ísun-aaiyavesa áraire sumbá miwívínkémbá moóráwai áwí'a Táyónisi kwemá Áríópagasi kánísórona'a úwana moórá-ininko áwí'a Tamarísiye minkáé'nárai umái évakarawaivi kwimái Ísun-aaiyavesa áraire sésa kwempá'á tiráawe. ");
INSERT INTO kze_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Póro Áténisi-naopa'a simátímatuwena tiyuwéna Kórínti-naopa'a komáyowana ");
INSERT INTO kze_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","moóráwai Yútaa-kwaasigo áwí'a Ákwíra máyowana kwembá anówa Pontasi-márává'á ména maránkarowana ména anón-éna Ítári-marava'a Árómáa-naopa'a koména awainínkó áwí'a Párísirae máyóyana mimbárává'á kárákwiron-kawaa-kwaasigo áwí'a Kórótíyasa Yútaa-kwaasi áwáá'a tí'mai Árómáa-naopakemba ti'mátuwowasa kuwasaráí Ákwírae Párísirae Kórínti-naopa'a komáyóyana Póro mindáraitopa'a kwéna ");
INSERT INTO kze_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","kwená moórá-mayai-kwaasitopa'a póna mindáraise koména ampanta-námbá kwéesaya óntamba kwémaesaya ");
INSERT INTO kze_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Yútaa-kwaasimo monor-áímbó kwéison-kanaamo túntemba Póro Yútaa-kwaasiti mono'-náúmpá'á uména Yútaa-kwaasiye Kíríki-kwaasiye Ísun-aaiyavesa áraire sésa kwempá'á tígwáe séna Ísun-aai simátíma'maena iráiye. ");
INSERT INTO kze_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","kwésimatimunka'a Sáíráiye Tímótiye Másétóniyaa-marava'a tuwésarai Kórínti-naopa'a kúmúyana Póro aasiyaai-táwai kawer-áímbá simátíma'maena kwéiyena Yútaa-kwaasiyavena séna Áánútumo usásinankaiwaimba Yútaa-kwaasiya amu'maráúndawaiya kwemá Ísuman-iye súwasa ");
INSERT INTO kze_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","kwenáái araaisésa sáwí-aimba simánkówana kwená unáánkwátóirakemba kankambá apivíyéna séna Áánútumo sáwí'o umáímo máyáampinkembo kawer-ámpá'ó ímo métinkanimba kentí ááinko ína'a sáwí'a ónááowe. kemá íma sáwí'a umátinkaumpo keyááríka'a sáwí'a ontávé'a tiyuwé'a ó'onkaa-kwaasiva'a kosimátíma'mae'a kónaumne Póro simásuwena ");
INSERT INTO kze_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","tiyuwéna moórá-kwaasigona naaúmpa'a komáyowana mindáúmpákén-kwáásígó áwí'a Tísíyasi Yásási kwemá ó'onkaa-kwaasigo éna Áánútuna imáyáa mósá marówai úwana kwená naambá Yútaa-kwaasiti mono'-nánkóná egwaa'á kwáyowana Póro mindáúmpá'á koména kawer-áímbá kosimátíma'maena iyúwana ");
INSERT INTO kze_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","moóráwai áwí'a Kárísipasi Yútaa-kwaasiti mono'-nánkár-ánón-kwáásígó Ísóigon-aaiyavena áraire súwasa kwená akúnkwárá'á áraire kwésuwasa Kórínti-naopaken-kwaasi sáwívarawai Póron-aai isésa Ísóigon-aaiyavesa áraire sésa mono'-nómbá pékaawe. ");
INSERT INTO kze_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","nombá pérówana moórá-no'waamba Póro kaainkáámbá awánówana Ísóigo séna íma áá'a kaíno. kemá esé ménaunda po íma ivátuwe kesáái úwoi simátíma'mae kwaaó. mindáópakemba sáwívarawai kesáái isésa kesí kwaási-i'a ónááomba pósa íma sáwí'a umánkanaaowe Ísóigo súwana ");
INSERT INTO kze_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Póro mindáópa'a moórá-i umái ava'moraé-kwiyomba ména Áánútun-aai simátíma'maena iráiye. ");
INSERT INTO kze_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","simátimuwana Árómáani-kamaani-kwaasi áwí'a Káriyomba ai'márówana Kíríki-kwaasiti maravá'á kogárákwironka'a Yútaa-kwaasi Póromba tátoresa áí'maesa Káriyonopa'a máankesa ");
INSERT INTO kze_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","sésa maankwáásígó évakar-aimba kwésimatimena Áánútumpa'o iyónááon-amba moórá-ankwara'a kwéagaraatinkaiye. mináínkó kentáásí ámáámba kwéaraaisiye suwaná ");
INSERT INTO kze_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Póro sénáe súwana Káriyo Yútaa-kwaasiyavena séna minkwáásígó kámááni-kwaasi tááimo sáwí'o énamo sáwí-mayaimo mairáinkakai kentáái ívé'a kawe'á umái isáúsina. ");
INSERT INTO kze_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ánivo kentí ááine kentúwíre kentí ámááne su'maiyave'a tasísaa ontávé'a ivátuwe'a keyááríka'a mináímbá másimai kawe'á oró. ke íma mirán-áímbá isánaumne séna ");
INSERT INTO kze_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","aaimó sií-náúmpákémbá ti'mátuwowasa ");
INSERT INTO kze_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","moóráwai áwí'a Sósénisi Yútaa-kwaasiti mono'-nánkár-ánón-kwáásígómbá tátokesa aaimó ísón-dankona egwaa'á inkámúwana Káriyo mindáyavaimo ímo imáyáamo úmba ivátukaiye. ");
INSERT INTO kze_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Póro Kórínti-naopa'a ayáátááka'a Ísun-aai ísówaiye ména tiyuwéna séna Párísiraante Ákwíraante tí'maena Síriyaa-marava'a kónáe séna Sénkíriyaa-naopa'a kumbéna Áánútuntavena árair-aimba séna a'nóntáu amápa'a káráyuwena mindárai tí'maena nompí-sípí táto'mai usáatesaya kweémesaya ");
INSERT INTO kze_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Évésasi-naopa'a mindómpí-sípívínkémbá marapá'á kunásávesaya Póro Párísiraante Ákwíraante minká tiyuwéna Yútaa-kwaasiti mono'-náúmpá'á uména aaí kwesimá kweiman-uwasa ");
INSERT INTO kze_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","miwí sésa ayáátááka'a keséya méniyone suwaná ímaniye simásuwena ");
INSERT INTO kze_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","kwéna séna Áánútumo owé sénamo si'maráína'o é'a koyauweránaumne séna nompí-sípí táto'mai usáatena Évésasi-naopa'a tuwéna kweémena ");
INSERT INTO kze_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sísáriyaa-naopa'a mindómpí-sípívínkémbá marapá'á kunásávena kunkéna Yérúsaremuva'a marapá'á iyéna Ísóigona kwaásiyavena kawer-áímbá simátímatuwena Síriyaa-marava'a Ántíoku-naopa'a koména ");
INSERT INTO kze_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","évaka'-no'waamba kwaitinkéna tiyuwéna Kárésiyaa-ayampa'a Vírísiyaa-ayampa'a naaó'-nao'a kwénaaena Ísun-aai ísówaiyavena simátíma'maena iyúwasa asiramái méraawe. ");
INSERT INTO kze_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","moóráwai Yútaa-kwaasi áwí'a Ápórosi éna kwemá Arekesándiyaavaken-kwaasi Évésasi-naopa'a tamérai. kwemá Áánútun-aai kawe'á umái kwéisena aúváí-kwandaaivinken-aimba kawe'á umái simátíma'maena iyúwana ");
INSERT INTO kze_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","moóráwai Ísóigona aampa'á kwégun-aimba simámakowana aamoí éna asiramái simátimena Ísun-aai arupí umái simátíma'maena iyéna Yóni nombó pétinkon-aine su'mai iséna Ísuna kwaási nombó kwévetinkon-aimba íma isómba ");
INSERT INTO kze_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Évésasi-naopa'a taména Yútaa-kwaasiti mono'-náúmpá'á asiramái simátímúwasarai Párísirae Ákwírae isésarai áí'maesarai kentí naaúmpa'a máankesarai Áánútuna aampa'á kwégun-aimba amápar-aimba kawe'á umái simámakaaiye. ");
INSERT INTO kze_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","simámuyana Ápórosi iséna séna Ákáyaa-marava'a kónáe súwasa Évésasi-naopaken-kwaasi Ísun-aai ísówai áwa'naa ónaumne sésa aúváíma agaimái áménaya Ísun-aai ísááwai Ákáyaa-marava'a máyáawai mátímínasa kawe'á umánkáaro suwaná mináúváí maimaéna kweémena kúmba Áánútu úwoi áwa'naa úwana Ísuna aampa'á kuwáí túwa'naa ena ");
INSERT INTO kze_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","avora'á Yútaa-kwaasiye aaí kwesimá kwesiman-ena Áánútun-aai aúváí-kwandaaivinken-aimba simátimena séna Áánútumo usásinankaiwaimba kwéamu'maraundawaiya kwemá Ísuman-iye súmba kwenááigo miwí tááigomba usáyaaitowana miráumai Ísuna aampa'ó kuwáí túwa'naa uráiye. ");
INSERT INTO kze_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ápórosi Kórínti-naopa'a máyowana Póro avumpim-bárává'á kweémena Évésasi-naopa'a kúmba Ísuna aampa'ó kun-kwáásí máyówana ");
INSERT INTO kze_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Póro tuwánéna tísaa ena séna Ísun-aaiyave'a áraire siráan-kanaa ára Áánútun-amankoma kentirumpimbá kumbéraiyo súwasa miwí sésa ímaniye. Áánútun-amankon-aaiya íya ísaraumne suwaná ");
INSERT INTO kze_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Póro séna nóran-aaina kwésesa nombá pétinkaraao súwasa miwí sésa Yóni simátímakain-aimba kwésimasimesaya nombá pésinkaraawe suwaná ");
INSERT INTO kze_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Póro séna Yóni séna sáwí-imayaa tínaaemba umásuwe'a Áánútumpa'a teró súwasa mirá uwaná nombá pétinkena séna moóráwai kesínaaemba tíníwain-aaiyavai áraire sé'a kwesé aráápamai máéro Yóni siráiye. miwántávéna Ísuwe siráiye Póro súwasa ");
INSERT INTO kze_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","miwí isésa Ísóigo Ísuntavesa ísámai nombá pérówana ");
INSERT INTO kze_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Póro tine'á ayáámba tátorowana Áánútun-amanko miwívímbá anómba umátinkowasa ó'on-o'on-kwaasi tááivinkemba kwésesa Áánútun-aai simátimesa ");
INSERT INTO kze_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","sísamaivakemba kae'á kumbaimái-kwaasi mirá uráawe. ");
INSERT INTO kze_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","mirá uwaná Póro miwísé ména kaumbo-kwíyónká'á Yútaa-kwaasiti mono'-náúmpá'á kwéiyena Áánútu kwená kwaási kwégawaa-in-aimba asiramái simátíma'maena iyúwasa ");
INSERT INTO kze_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","évakarawai tirunté marésa mináíntávésa íma áraire sésa amáparawai túranka'a Ísóigona aantavésa simái sáwí'a uwaná Póro tiyuwéna Ísuna aampa'ó kun-kwáásí tí'maena moóráwai áwí'a Tíránasi ira-námbá úmakon-daumpa'a mói tínkarena aasiyaasi-táwai Ísóigon-aai simátíma'maena kwéiyena ");
INSERT INTO kze_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","kaer-í maisuwówasa Yútaa-kwaasiye ó'onkaa-kwaasiye Ésiyaa-marava'a máyón-kwaasi amápa'a Ísóigon-aai ísaraawe. ");
INSERT INTO kze_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ísóigon-aai ísówana Áánútu Póromba asirayámbá amúwana ímo awárom-bayai ó'om-bayai mayówasa ");
INSERT INTO kze_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","évaka-kwaasiyomba ampantanéí Póro ane'á to'maésa kentí kwaásimo tí'o úwai tine'á máyo'marowasa asóvawasa kentí kwaási tirumpimbá taraváá-kwámbá máyowasa mirá máumatinkowana taraváá-kwámbá kóuwasa ");
INSERT INTO kze_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","évaka'-Yutaa-kwaasi kwénaaesa kwaási tirumpinkémbá taraváá-kwámbá maitíyu'maesa kwégwesa taraváá-kwántávésa sésa asiramái séta Ísu áwíka'a Póro kwésin-awika'a kóroya kwésune suwaná ");
INSERT INTO kze_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","moóráwai áwí'a Síva Yútaa-mono-kawaa-kwaasigo áánimbaa'a avakaeté mésa pósa mirám-báyáí máyówana ");
INSERT INTO kze_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","taraváá-kwánkó simátimena séna kemá Ísumba awáné'a Póromba awáné'a kwéumpo kemá nááwiya'o simásuwowana ");
INSERT INTO kze_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","taraváá-kwánkó arumpimbá máyon-kwaasigo tínkamuwana naaé kwégumuwana unáánkwátói tarátiyuwena minávákáété-kwáásí usáyaatena tuwéntáíyuwowasa unáánkwátói-iyaaimba máápa'a kúmúwasa ");
INSERT INTO kze_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Yútaa-kwaasiye ó'onkaa-kwaasiye amápa'a Évésasi-naopaken-kwaasi mináímbá isésa táátavai ésa Ísóigo Ísu áwí'a mósá makáawe. ");
INSERT INTO kze_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","sáwívarawai máyónka'a Ísun-aaiyavesa áraire suwáí tésa kwaási túranka'a paárésa sésa sáwí'a uráumne sésa ");
INSERT INTO kze_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","miwívínkémbá pukaa'ó agayáán-kwaasi miwítí aúváí-kwandaai tamairésa pukaa'ó agáyón-aimba kwáyontavesa tamaimái iravímbá agaisuwésa mináúváí-kwándááímó meéyán-uraamba sáwíva-kwaasi aíyayaamba naikamáiyavai minóntánkó áwí'a 50,000 kina tuwésa ");
INSERT INTO kze_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","mirá anón-tantaa'a umbá pósa Ísóigon-aai asiramái simátíma'maesa kuwasá sáwívarawai mináíntávésa áraire siráawe. ");
INSERT INTO kze_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","mirá uwaná Póro séna Másétóniyaa-marava'a Ákáyaa-marava'a kwénaae'a Ísóigon-aai simátíma'mae'a naaónáe séna minkákémbá Yérúsaremuva'a kuré'a Árómáa-naopa'a kónaumne séna ");
INSERT INTO kze_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tímótinte Érásátasinte áwa'naa í-kwáásíráí ti'marówasarai Másétóniyaa-marava'a kuyaná Ésiyaa-marava'a kweyáá méraiye. ");
INSERT INTO kze_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","máyowasa minkánáá Évésasi-naopaken-kwaasi Ísóigona aampa'ó kuwáíyávésa tirumbá sáwí'a umátinkesa mindáópakemba anónkar-anonka'a suwaná ");
INSERT INTO kze_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","moóráwai áwí'a Témítiyasi minkwáásígó óntandei úmakena miwítí kampar-ísóígóná kíto'-mono'-nane séna minkámpár-ísóí-ínínkó áwí'a Átémísiye sésa kwená mayáí-kwáásíyómbá úmakowasa sáwíva-kwaasi óntamba mágwétimesa minkámpár-ísóígóná naambá kwémeyan-uwana ");
INSERT INTO kze_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Témítiyasi mimbórá-máyáí kwémayon-kwaasi tááyowasa tayorupowaná simátimena séna kentáásí anón-ontamba mimbáyáírákéntá kwémayaumne. ");
INSERT INTO kze_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ánivo Póro séna kwaásimo úmáráamba kampar-ísóígómbá kwéumaraawemo sin-áímbá Ésiyaa-marava'a Évésasi-naopaken-kwaasiye ó'on-o'on-daopaken-kwaasiye isésa áraire kwésewe. kemá Póron-aai á'a ísaraawe. ");
INSERT INTO kze_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Póron-aaigo kentáásí mayáímó sáwí'o índayavena kwéiye. íma miráwé su'mai ínívo Ésiyaa-maravaken-kwaasiye amápa'-maravaken-kwaasiye kentáásí ísói-ininko áwí'a Átémísi mósá kwémaraamba Póron-aaigo Átémísina mono'-námbá úwoisankaamba simái umásukaimba póna kwenáwí'a kumíníye siráiye. ");
INSERT INTO kze_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","súwasa mináímbá isésa tirumbá sáwí'a úwasa aaisambá sésa anónkar-anonka'a sésa Évésasi-naopaken-kwaasi kentáásí Átémísi áwí'a anómba kwéiye sésa ");
INSERT INTO kze_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ayamái suwasá mindáópa'a tésa anónkar-anonka'a kwésesa Pórowe kwénaauyan-kwaasi Másétóniyaavaken-kwaasirai moóráwai áwí'a Káyási uwaná moóráwai áwí'a Árísítakasi mindárai tavisímaesa torupamái máyópa'a mátínkówana ");
INSERT INTO kze_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Póro amápa-kwaasi torupepá'á iyónáe súwasa Ísuna aampa'ó kuwáí íma kwaaó sésa tátorowasa ");
INSERT INTO kze_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","mimbárávákén-ánón-kwáásí évakarawai Pórona kwaási pósa aaí tuwésa sáwíva-kwaasi torupepá'á íma iyuwó Pórontavesa siráawe. ");
INSERT INTO kze_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","suwasá torupon-kwáásíyómbá sáwívar-imayaa uwaná miwítí imáyáa sáwí'a úwasa évakarawai ó'on-aintavesa suwasá évakarawai mirá suwasá évakarawai sésa nóin-aintavaiye sétaawa tayoruparáumno-imayaa uwasá ");
INSERT INTO kze_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yútaa-kwaasi miwítí avumpinkémbá moóráwai áwí'a Arekesándaamba túranka'a máánkarowasa évakarawai anónka'a sésa emá aaí siyó suwaná miwí táái karánáe séna ayáámba mósá tuwówasa ");
INSERT INTO kze_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","awánomba Yútaa-kwaasi úntavesa mimbórá-áímbá ayáátááka'a tavisimái anónka'a sésa Évésasi-naopaken-kwaasi kentáásí Átémísi áwí'a anómba kwéiye siráawe. ");
INSERT INTO kze_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","anónka'a kwésuwana mindáópaken-anon-kwaasigo aúváímo agayóndako tiyoráí-ímáyáá éna séna Évésasi-kwaasiyono. amáparawaiya awánáúnda Átémísina mono'-námbá kwégawaa-eta ó'oran-ontamba kwíyómpakemba marapá'á kunkáin-ontamba kwégawaa-une. ");
INSERT INTO kze_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","mináímbá íma kanaán-umai karánááovo amápa'a aaiseré'a mé'a íma sáwí'a oró. ");
INSERT INTO kze_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","mindárai mono'-náúmpákémbá íma umóyámbá ésarai kentáásí ísói-inintavai íma simái sáwí'a uráaya'anivo úwoi tí'mae'a maanká'á tiráawe. ");
INSERT INTO kze_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Témítiyasiye kwená mayáí-kwáásíyé aaí simátinkanae sésamo ésa aaimó simátinkai-kanaa úwoi kwáyáiye. anón-kwaasi máyáamba pósa aaí simái kawe'á umátinkanaaowe. ");
INSERT INTO kze_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ánivo keinárawa'o ó'on-aimbo kwáyáina'o é'a amápa-kwaasimo torupamáímo máyáampimba simái kawe'á umásuwanaaowe. ");
INSERT INTO kze_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","kesáámó aaivintáámó ménaundaya ívé'o áái'o tiyéta Árómáani-kamaani-kwaasi tésamo tasísaa esayaamo nóinkaken-aira tiyááomo síyata kesáámó sénaunda-ainta íma kwáyáiye. ");
INSERT INTO kze_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","aúváímo agayón-kwaasigo simásuwena torupamáímo máyón-kwaasi ti'mátuwowasa kóuraawe. ");
INSERT INTO kze_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","miwí táái ánásowana Póro Ísuna aampa'á kun-kwáásí tááyowasa tuwaná miwítí imáyáa simái kawe'á umátinkena séna Ísun-aaiye su'mai maimái tirumpimbá kawe'á oró séna ánivo méwaro séna tiyuwéna Másétóniyaa-marava'a kweémena ");
INSERT INTO kze_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","mivá'á naaó'-nao'a kwénaaena Ísuna aampa'á kun-kwáásíyávéna ávááraumai simátíma'maena kwénaauwasa tirumbá kawe'á úwana tiyuwéna Kíríki-marava'a kweémena ");
INSERT INTO kze_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","koména kaumbo-kwíyómbá maisuwéna nompí-sípívímbá Síriyaa-marava'a kónáe séna úwasa Yútaa-kwaasi kwená ámááyu-aimba sumbá iséna ivátuwena Másétóniyaa-marava'a marapá'á kónaumne súwasa ");
INSERT INTO kze_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","maaráumai-kwaasi moóráwai Pérea-naopakewai Pírasi ááninko áwí'a Sópata úwana Tésárónaikaa-naopakendarai túwí'a Árísítakasiye Sékandaawe uyaná Tépi-naopakewai áwí'a Káyási úwasarai Ésiyaa-maravakendarai túwí'a Tikikásaawe Tóvimasiye uyaná Tímóti úwasa umái Pórowe kwésa ");
INSERT INTO kze_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","aiva'á Táróasi-naopa'a komésa kentáásimu'a makówata ");
INSERT INTO kze_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yútaa-kwaasimo ímo intóráin-tantaakwara-pereti úwoi-peretimo kwéagayon-kanaama ánásonka'a Vírípai-naopakemba nompí-sípí táto'mai usáateta kweémeta éva'aasei-no'waamba mindómpí-sípívímbá kógwaeta Táróasi-naopa'a marapá'á kunásáveta aiva'ó komésamo kentáásimu'o makón-kwaasiyeya kométa moórá-sontaaya méraumne. ");
INSERT INTO kze_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","sontaará'á Ísuntaveta ísámai toómbá néta aráá-tomba naandayávéta torupamái máyaawananaya Póro aaváyaa kónáe séna simátíma'maena no'wáán-avuntamba iyúmba ");
INSERT INTO kze_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ávúmayaatanaan-daumpa'a méta sáwívar-omba kúra'maketa máyaawananaya ");
INSERT INTO kze_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","moóráwai ívé-kwaasigo áwí'a Yútíkása naan-aváápímbá umáyowana Póro Ísun-aai simátíma'maena kwéiyuwana Yútíkásaamba áúgávaa'a úwana kwaeguréna meminkákémbá toká'maena marapá'á kuntuvamúwasa marapá'á kunkésa kunawánomba pukúwasa uwaná ");
INSERT INTO kze_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Póro kuména kunkívairena taparéna awánéna séna íma imáyáa oró. pukéna kusúvarena umái máyáiye simátimena ");
INSERT INTO kze_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","mindáúmpá'á iyéna Ísuntavena ísámai toómbá topámbai timúwasa nowaná Póro simátíma'maena kwéiyuwana mói irataró'a tiyuwéna kúwasa ");
INSERT INTO kze_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","puwúwanamo usásinankon-kwaasigomba áí'maesa kwená naaúmpa'a máankesa tirumbá kawe'á úwasa méraawe. ");
INSERT INTO kze_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","máyówana Póro simásimenaya séna keinárawa'a nompí-sípívímbá Ásoso-naopa'a kwégwiya'a kemá marapá'á kweéme'a Ásoso-naopakemba nompí-sípí táto'mai usáate'a kónaumne súwata aiva'á kunkéta nompí-sípí táto'mai usáateta kweémeta Ásoso-naopa'a kówánanaya ");
INSERT INTO kze_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Póro marapá'á kweémena Ásoso-naopa'a kuréna nompí-sípí táto'mai usáatowata kweémeta Mítíríni-naopa'a kógwaeta ");
INSERT INTO kze_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","irataró'a kweémeta Káyoso-marava'a kóyaaitaawananaya enówata kógwaeta usá aaváyaavimba kweémeta Sémóso-marava'a kóyaaitaawananaya enówata kógwaeta usá aaváyaavimba kweémeta Máíritasi-naopa'a kówánanaya ");
INSERT INTO kze_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","toómbá áká'mai Áánútuntavesa ísámai kaunánáe sésa torupaan-kánáá sáwíyanka'a tíníye kwéuwana Póro séna avekáámbá Yérúsaremu-naopa'a kuré'a mintánómbá komandánáe séna nompí-sípívímbá Évésasi-naopa'a kóyaaitanaundapo Ésiyaa-marava'a íma ayáátááka'a ménaumne súwata Máíritasi-naopata kuráumne. ");
INSERT INTO kze_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Máíritasi-naopata kówánanaya Póro moóráwaimba ai'marówana Évésasi-naopa'a kweémena Ísóigona kwaásiti anón-kwaasiyavena kosimátimena séna Póro kwétaayaivo teró siráiye súwasa ");
INSERT INTO kze_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","tuwaná simátimena séna kesáái ísáaro. kesí aiva-táwai Ésiyaa-marava'a kesé komé'a kemó ówánda suwánaraawe. ");
INSERT INTO kze_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yútaa-kwaasi sínkamiyanesa kwésuwana sirunkó umbaí kwétowa'a íma imáyáa é'a Ísóigona kwayó'ná'á úne sé'a kwenaísamaivimba mé'a kwená mayáí mairáumne. ");
INSERT INTO kze_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","íma aúpá'á tuwé'a amápar-aimba úwoi simátime'a kembó túwa'naa ií-áímbá torupamái máyáampine kentí naaúmpare simátíma'mae'a iráunda á'a ísaraawe. ");
INSERT INTO kze_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yútaa-kwaasiye ó'onkaa-kwaasiye ávááraumai simátime'a sé'a sáwí-imayaa tuwé'a Áánútumpa'a té'a Ísóigo Ísun-aaiyave'a áraire sé'a kwesé aráápamai máéro simátíma'mae'a iráumne. ");
INSERT INTO kze_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ánivo Áánútun-amanko Yérúsaremuva'a kwaaó simásímakaimba pó'a mirá ónaumne. kesine'ó paárinintavai íma isáúnda úwoi kwégune. ");
INSERT INTO kze_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","amápa'-naopa'o kúnda Áánútun-amanko asiramái simásimena séna umbai-yántáá'á umánkesa ándáva'a máánkanaaowe simásímímba mindáwe su'mai ísaraumne. ");
INSERT INTO kze_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","sínkamiya'o puwónaundara'a íma kárákwiyonaunda pó'a Ísóigo Ísu símakaim-bayai maimái ánásanaumne. Áánútu úwoi kwésuwa'naa-i-aimba áséi-kwasai simátíma'mae'o kwéiyunda-mayai maimái ánásanaumne. ");
INSERT INTO kze_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","mimbáyáí mairáunda keinárawapimba kwénaae'a Áánútu kwená kwaási kwégawaain-aimba simátímakaunda pó'a naaémbo é'a kembó ímo suwánáíyamba ken-ísaraumne. ");
INSERT INTO kze_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","íma inkaiséwánda Áánútun-aai amápar-aimba simátímakaunda pósa keinárawapinkembo évakarawaimo kesááimo ímo isésamo Áánútumpa'o ímo tésamo ombá íma kesí ááinkoman-ivo kentí ááinko ína'a mirá ónááontave'a mináímbá ívé'a asiramái kwésimatimune. ");
INSERT INTO kze_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Áánútu ááninkomba ai'marówana kuména kumpuwéna kwená naaenéí meéyán-umásukaimba Ísóigona kwaásin-ovo kárákwiyoro. Áánútun-amanko kembá usásintinkaraivo kentúrakwara Ísóigona kwaásirakwara'a kawe'á umái kárákwiyoro. sipisípira'o kárákwiyonten-umai kárákwiyoro. ");
INSERT INTO kze_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","áwáávitemo índa-iyamba téna sipisípi tavamáímo kwáráíntemba kemá kónasa kwaási tésa tasáwí'a ónááowe. ");
INSERT INTO kze_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","moórá-kanaa tínasa keinárawapinkemba évakarawai usásinesa Ísuna aampa'á kon-kwáásítí imáyáa tavisénáe sésa kampar-áímbá síyasa évakarawai áraire sésa kwaránááowe. ");
INSERT INTO kze_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","mindáyave'a kárákwimai kawe'á oró. kaumbo-í kwéte'a moórá-morawaimba sirumbá kwéumatinke'a aaváyaavimba enónka'a no'wáámba aasiyaasí simátínkámae'a iráumne. mináíntávé'a imáyáa umái kawe'á oró. ");
INSERT INTO kze_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","kawe'á íyana Áánútu kárákwitinkamae iyína'a máéro. kwenááigo asiramátinkaniye. kwená kwaásimo kawe'ó kwéumatinkaintemba kenkwárá'á kawe'á umátinkaniye. ");
INSERT INTO kze_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","óntantavai unáánkwátóiyavai á'owiti náaindaantavai íma súran-anda kwéune. ");
INSERT INTO kze_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","mayáímá kwémae'a minóntándéí ímo makáunda-yantaa'a mégwémae'a kembó súwa'naa on-kwáásítí toómbá unáánkwátói kwémaitime'a kwéune. mirámó ówánda á'a suwánaraawe. ");
INSERT INTO kze_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","asirayám-báyáímó mayááwánda suwánaraamba pó'a mirá kwée'a pasusimáímo máyáan-kwaasi túwa'naa ónááowe. Ísóigo Ísu siráin-aimba imáyáa oró. kwemá séna kwémayaawai tirunkó kawe'á kwéimbanivo kwétimatuwaawai tirunkó kaweté kwéiye Ísu siráin-aimba Póro siráiye. ");
INSERT INTO kze_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Póro simásuwena kívairena minánón-kwáásíyé Ísóigompa'a námúnaa simásuwowasa ");
INSERT INTO kze_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","amáparawai ávááran-ivi'a kwétesa Póromba tayaparésa paruvará umánkesa uwaná ");
INSERT INTO kze_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Póro séna naaémbo é'a íma suwánanaaowe siráin-aintavai tirumbá umbaí kwétowasa nompí-sípívímbá móruna áúkaawe. ");
INSERT INTO kze_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","móruna aúwówata minkwáásíyávéta méwaro séta tiyuwéta nompí-sípívímbá usáateta arupí umái kweémeta Kóso-naopa'a kóyaaiteta kweémeta kógwaeta usá aaváyaavinkaamba Áróso-naopa'a kóyaaiteta kweémeta Pátaraa-naopa'a kuréta marapá'á ásáveta ");
INSERT INTO kze_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","awánaawandaya Vínísiyaa-marava'a kwíní-nompi-sipi kwáyowata mimpímbá usáateta kweémeta ");
INSERT INTO kze_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sáíparasi-marama siyáánepa'a kwáyowata kóyaaiteta kweémeta Síriyaa-marava'a kówándaya Táyaa-naopa'a náaindaamba mógwéyuwowata marapá'á ásávaawanasaya ");
INSERT INTO kze_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ísuna aampa'á kuwáí máyówata tuwánéta moórá-sontaa miwísé máyaawanasaya sésa Áánútun-amanko simátímakain-aimba Pórontavesa simámesa sésa inkámóvo Yérúsaremuva'a íma kwaaó simáma'maesa íyúwata ");
INSERT INTO kze_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","miwísé máyaawanda-kanaa ánásowata mindáópa'a tuwéta kówánasaya minkwáásíyómbá miwítí aarai-iyámpóíse sí'maesaya naambáru'a tuwésa uwí-nómpá'á kúmúwata kívaireta Áánútumpa'a námúnaa simásuweta ówánasaya ");
INSERT INTO kze_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","kentááyávésa ánivo koró suwatá miwíyávéta ánivo méwataao simásuweta nompí-sípívímbá usáataawanasaya miwí kuntauwerésa miwítí naaópa'a iráawe. ");
INSERT INTO kze_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","miwítí naaópa'a íyúwata nompí-sípívímbá Táyaa-naopata tuwéta Tórémesi-naopata marapá'á ásáveta Ísun-aai ísówai tuwánéta siyáánta kwétimeta moórá-no'waamba miwísé kwaéta ");
INSERT INTO kze_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","usásineta marapá'á kweémeta Sísáriyaa-naopa'a kówándaya ááéma aantá-kwaasi avakaeté-kwaasira'a Ísuna mayáí tímakowaivinkemba moóráwai áwí'a Vírípina naaúmpata umáyaawananaya kwemá Ísun-aai kwésimatimuwai máyowasa ");
INSERT INTO kze_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ayáámúmbaa'a éíyaimba mésa íma kwaaí mairésa úwoi mésa Áánútun-aai kwésimatimesa tivowáe máyówata ");
INSERT INTO kze_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","évaka'-no'waamba mindáúmpátá kwégwaewananaya moóráwai Áánútun-aai kwésimatimuwai áwí'a Ákápáasi Yútiyaa-maravakemba ");
INSERT INTO kze_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","kuména Póro ámúr-anda kumbairéna kwenaísamai ayáánka'a asááumai umásítai'a umái agaráárankena séna Áánútun-amanko séna maanámúr-ándáó avowámó Yérúsaremuva'o iyínasamo ésa Yútaa-kwaasi táto'mai miráumai asááúmaresa áí'maesa ó'onkaa-kwaasi mátimenaaowe Áánútun-amanko siráiye Ákápáasi kusúwata ");
INSERT INTO kze_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","iséta keséya máyón-kwaasiye Pórontaveta séta Yérúsaremuva'a íma iyuwó asiramái séwánanaya ");
INSERT INTO kze_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Póro séna nóintavai ivi'á kwétera kaer-ímáyáá kwéumasinkaawana kesirunkó umbaí kwétaiyo. Yérúsaremuva'o íyónasamo kembó tátoranaaomba íma sáá'a kwégaiye. Ísóigo Ísun-aai simátimudayavaimo sínkamonaesamo sésa úwoi sínkamonaaowe Póro súwata ");
INSERT INTO kze_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","kwenááiya íma kanaán-umaiya araaisénaumne séta ivátuweta séta Ísóigona imáyáara'a mirá ónááowe siráundayaawe. ");
INSERT INTO kze_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","mirá simásuweta évaka'-no'waamba miwísé kwaéta kentáásí náaindaamba to'mayaa úmaeta mindáópa'a tuwéta Yérúsaremuva'a iyówánasaya ");
INSERT INTO kze_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sísáriyaavaken-kwaasi Ísuna aampa'á kuwáí évaka'a keséya Yérúsaremuva'a iyésa moóráwai áwí'a Nésonona naaúmpata móisinkowana minkwáásígó Sáíparasi-maravaken-kwaasi ayáátááka'a Ísuna aampa'á kwéguwai séna kesí naaúmpa'a ménaaowe súwasa kwená naaúmpata móisinkaraawe. ");
INSERT INTO kze_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","móisinkesaya kentí naaópa'a kúmúwata Yérúsaremuva'a umáyaawanasaya Ísun-aai ísówai aamoí kwéumpinkemba sirówata ");
INSERT INTO kze_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ugwaéwándaya usá aaváyaavimba Ísóigona kwaásiti anón-kwaasi Yémési torupamátinkowasa máyópata Póro sí'maenaya kúwata komáyaawananaya ");
INSERT INTO kze_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Póro ayáámba tíma'mai paruvará éna séna Áánútu ámakaim-bayaimo ó'onkaa-kwaasivimbo mairáin-aimba amápar-aimba simátimuwasa ");
INSERT INTO kze_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","isésa Áánútu áwí'a mósá marésa Pórontavesa sésa kentáásí kwaásiyo. sáwíva-kwaasi Yútaa-kwaasi Ísun-aaiyavesa áraire kwésesa Mósesina ámáámba íma tuwésa asiramái isésa méraamba á'a ísaraane. ");
INSERT INTO kze_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","évakarawai miwíyáváí sésa Póro ó'onkaa-kwaasiti naaó'-nao'a kwénaaena Yútaa-kwaasi mindáópaka'a máyáan-kwaasiyavai simátimena séna Mósesina ámáámba ivátuwe'a kentí iyámpói túra'a íma kárámai araa'éna umátinke'a Yútaa-kwaasiti aambá íma kwáráaro Póro kwésiye sewasá isésa ");
INSERT INTO kze_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","emó tiráanda-aimba isésa áwáá'a kwésevo ");
INSERT INTO kze_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","simáméndantenta uwó. maanká'á éíyain-kwaasi mésa Áánútumpa'a árair-aimba símakaamba po ");
INSERT INTO kze_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","egwárá'á mirán-uwo. Yútaa-kwaasiti ámáámba ísámai kawe'ó ií-yántáá'á e minéíyáín-kwáásítí póí'o meéyán-umátiyuwe mono-káwáá-kwáásí timé miwísé a'nóntáu káráyuwenasa awánésa Yútaa-kwaasi Ísun-aaiyavesa áraire sewáí sésa emá Mósesina ámáámba isé máyaanasa entáváí kampar-áímbá simánkaraawe seró. ");
INSERT INTO kze_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ánivo ó'onkaa-kwaasi Ísun-aaiyavesa áraire siráawaiyaveta ááéma moórá-aimba séta agaimaréta séta kampar-ísóígóntáváí imáyáa ésa póí'o umándaamba mimpóí íma naaró. naaemá íma naaró. póímo tuvú'newana kwená naaemá ímo kumíndamo úwoimo kwáyáina'a mimpóí íma naaró. aarai-úmóyámbá kwaai-úmóyámbá íma oró. ááéma mináímbá agaimaréta tukáundayaawe suwaná Póro iséna ");
INSERT INTO kze_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","usá aaváyaavimba minkwáásí tí'maena Yútaa-kwaasiti ámáámba ísámai kawe'ó ií-yántáá'á usá umásuwena Póro anóm-bono'-naumpa'a iyéna mono-káwáá-kwáásíyávéna séna avakaeté-no'waamba maisuwéta Yútaa-kwaasiti ámáámba ísámai kawe'ó ií-yántáá'á umái ánásasuweta moórá-morawai póí'a úmaeta Áánútunka'a máamenaundayaaniye simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","simátimena máyowana minávákáété-nó'wáámbá ánásowana Póro anóm-bono'-naumpa'a umáyomba évaka'a Yútaa-kwaasi Ésiyaa-maravakewai uawánésa Pórontavesa sáwí-aimba simánkesa inkamí-ímáyáá kwéesa tátokesa anónka'a sésa ");
INSERT INTO kze_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ísareri-kwaasi súwa'naa oro. maankwáásígó naaó'-nao'a kwénaaena Ísareri-kwaasiyavena sáwí-aimba simátinkena Mósesina ámáámba simái sáwí'a kwéumankena maanánóm-bónó'-námbá simái sáwí'a kwéiye. ívé'a ó'onkaa-kwaasi tí'maena maanánóm-bónó'-náúmpá'á Yútaa-kwaasiye su'maimo iyí-náúmpá'á mógwétinkaisana póna maankáwé'-námbá sáwí'a kwéiye sumbá ");
INSERT INTO kze_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Évésasi-naopaken-kwaasigo áwí'a Tóvimasi Póroe Yérúsaremuva'a kwénaauwasa awánonka'a pósa imáyáa ésa Póro áí'maena anóm-bono'-naumpa'a móankaraiye-imayaa kampa'á ésa mindáyavesa mináímbá siráawe. ");
INSERT INTO kze_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","mináímbá anónka'a simásuwowasa mindáópaken-kwaasi mimbórávímbá takwiyésa Póromba tayáto'mai mono'-náúmpákémbá tavisímaesa máá'aruva'a móruna auwésa mono'-nánkóná onta mósá kwéumaresa ");
INSERT INTO kze_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","sáwíva-kwaasi Póromba inkamír-inkami'a kwéuwana moóráwai Árómáani-i-kwaasiti anóndakontavena usimámena séna Yérúsaremuva'a amápa-kwaasi áái'a kwétiyaawe súwana ");
INSERT INTO kze_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","avekáán-umai i-kwáásíyé miwítí kawáá-kwáásíyé tí'maena isaaiséna kuména kwaási torupamái máyómpimba tavákáraa'a úmaena kumúwasa i-kwáásíyé miwítí anóndakone tuwánésa inkamé máyómba úwoi máyówana ");
INSERT INTO kze_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","anóndako Póromba tayátorena i-kwáásíyávéna séna kaer-ándánéí taasááóro simásuwena tísaa ena séna maankwáásí nááwa'iyo. kwe nóra uráiyo súwasa ");
INSERT INTO kze_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","évakarawai ó'on-o'on-aintavesa suwasá évakarawai mirá suwasá uwaná anóndako mináínkóná ááimba íma iséna i-kwáásíyávéna séna mindá'á áí'mae'a i-kwáásítí naaúmpa'a íyóro súwasa ");
INSERT INTO kze_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","áí'maesa ontaví-káráúrávámbá íyúmba inkamónáesa kwéuntavai i-kwáásí tiyáánka'a toká'maesa kwéiyuwasa ");
INSERT INTO kze_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","tínaaemba kwa'maé kwéiyesa tuvuwíyana puwíno símaesa anónka'a iráawe. ");
INSERT INTO kze_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","i-kwáásí Póromba áí'maesa miwítí naaúmpa'a iyónáe suwaná Póro miwítí anóndakomba simámena séna moórá-aimba simámenae súwana anóndako séna Kíríki-kwaasi tááivinkemba kwésempo ");
INSERT INTO kze_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","emá íma Ísípi-maravaken-kwaasi óne. minkwáásígó Árómáani-kamaani-kwaasiyavena aaisambá tiyéna sáwíva-kwaasi 4,000 kwaasi simái tí'maena áái'o tiyáí-yántáá'á maimaésa kavóná-marava'a kuráamba íma kwemá óne súwana ");
INSERT INTO kze_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Póro séna Yútaa-kwaasi úne. kesinó kembá Sírísiyaa-marava'a Táásási-naopa'a masínkarena anón-daopa'a masínkaraiye simásuwena séna moórá-aimba simátimenae súwana ");
INSERT INTO kze_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","anóndako séna ánivo mirán-uwo súwana Póro ontará-káráúrá'á ména aaiseránááontavena ayáámba mósá tuwéna séna kemó senda-áímbá ísáaro súwasa aaisérówana Yútaa-kwaasi tááivinkemba Ípírun-aimpinkemba simátímakaiye. ");
INSERT INTO kze_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Póro simátimena séna kesívárawaisai kesivoísáíyo aaí simátínkáamba anondá mináímbá sénaumpo ísáaro séna ");
INSERT INTO kze_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ípírun-aimpinkemba súwasa miwí tááivinken-aimba pósa isésa aaisékésa kwenáái kawe'á umái ísówana Póro séna ");
INSERT INTO kze_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","kemá Yútaa-kwaasi úne. kesinó Sírísiyaa-marava'a Táásási-naopa'a masinkówa'a anón-é'a Yérúsaremuva'a Kámérierinopa'a tamáyaawanana kentáá síkwá'nái ámáámba asiramái simásíma'maena iráiye. maanká'ó máyáan-kwaasimo Áánútuntavaimo asiramái máyáantemba Áánútun-aai asiramái mé'a méyatokaumne. ");
INSERT INTO kze_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ísuna aampa'á kun-kwáásí sáwí'a kwéumatinke'a tavisímae'a ándáva'a aarai-kwaaí mátínkaraumne. ");
INSERT INTO kze_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ááéma aiva'mónó-káwáánákówé monor-ánón-kwáásíyé aúvái simésa Támásikasi-naopa'a Yútaa-kwaasi maimaé mátimiyo suwa'á Ísuna aampa'á kun-kwáásí kotí'mae'a Yérúsaremuva'a ándáva'a mátinkanae sé'a Támásikasi-naopa'a kuráumne. ááémo mináúváímó símakaan-kwaasi kotísaa e'o é'a kentáváí árai'a kwésiye seró. ");
INSERT INTO kze_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ánivo aampa'á kweéme'a Támásikasi-naopa'a egwaa'á kówánana kwáyá'wái kwíyómpakemba ságayamba tawáonkaan-tantaa'a tuwówana kuména súgáyáagaya úwa'a ");
INSERT INTO kze_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","marapá'á tuvamówánana aaiyé su'mai kwéisaawanana sááyena séna Sóroo nóra séwa kembá sáwí'a kwéono súwa'a ");
INSERT INTO kze_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","emá nááwa kwéseno séwánana kemá Násáretivakewaima Ísuma únama sáwí'a kwéumasinkaane súwasa ");
INSERT INTO kze_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","kesémo máyón-kwaasi ságayamba awánésa kwésimasimun-aimba íma kawe'á umái ísówa'a ");
INSERT INTO kze_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","áísaa e'a sé'a Ísóigoo ke nóra ónaumno séwánana Ísóigo séna usásine Támásikasi-naopa'a kwinaná moóráwai Áánútumo embó ámakaim-bayai-aimba simámino súwana ");
INSERT INTO kze_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ságayanko súgáyáagaya úwa'a íma kwéawanaawanasa kesé kwénaaun-kwaasi siyáán-to'maesa Támásikasi-naopa'a kuráawe. ");
INSERT INTO kze_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","kuwaná moóráwai áwí'a Ánánáesi Áánútun-aaiyavena asiramái ména kentáásí ámáámba kwéisowasa Yútaa-kwaasi Támásikasi-naopakewai kwenáwí'a mósá makówai ");
INSERT INTO kze_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","kesópa'a téna kesí egwaa'á taména séna Sóroo kesí kwaásiyo. ó'omba kawe'á umái aúramba awánaniyone súwa'a avekáámbá súramba awánamai kawe'á ówánana ");
INSERT INTO kze_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","séna kentáá síkwá'nási Ísóigo embá usásinankaintavai kwená imáyáa kwaráníyone. kwená kawe-kwáyóná'á awáné kwenáái isé ónda po kwenáái kwaráníyone. ");
INSERT INTO kze_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","awánáánda-yantaa isáánda-yantaa'a amápa-kwaasi simátíma'mae naaíníyone. ");
INSERT INTO kze_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","íma úwoi maé usásine Ísóigo Ísumba ááyenana ená sáwí-imayaa mayauwáína Ís