﻿USE sofia;
DROP TABLE IF EXISTS sofia.kyzNT_vpl;
CREATE TABLE kyzNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kyzNT_vpl WRITE;
INSERT INTO kyzNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","'Agamũ Jejui Kristu 'ga pytunera 'gã. Abraão 'ga juapyrera 'ga Davia. Davi 'ga juapyrera 'ga Jejui Kristua. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraão 'ga Isaki 'ga ruwa. Isaki 'ga Jako 'ga ruwa. Jako 'ga Juda 'ga ruwa, 'ga rewirera 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda 'ga Peres 'ga ruwa, Sera 'ga retee. 'Gã y ẽẽ rera Tamar. Peres 'ga Esrom 'ga ruwa. Esrom 'ga Arão 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arão 'ga Aminatape 'ga ruwa. Aminatape 'ga Nasom 'ga ruwa. Nasom 'ga Saumõ 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saumõ 'ga Poasi 'ga ruwa. Poasi 'ga y ẽẽ Raape ẽẽ. Poasi 'ga Opete 'ga ruwa. Opete 'ga y ẽẽ Rute. Opete 'ga Jese 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese 'ga Davi 'ga ruwa. Davi 'ga 'ũina 'wyriaramũ judeu 'gã nupe rakue. Davi 'ga Uri 'ga remirekofera ẽẽ rerekou. 'Gã na'yra 'ga Sarumãu 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sarumãu 'ga Ropoãu 'ga ruwa. Ropoãu 'ga Apiasi 'ga ruwa. Apiasi 'ga Asa 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa 'ga Josafa 'ga ruwa. Josafa 'ga Jorãu 'ga ruwa. Jorãu 'ga Usiasi 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiasi 'ga Jotãu 'ga ruwa. Jotãu 'ga Akasi 'ga ruwa. Akasi 'ga Esekiasi 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiasi 'ga Manase 'ga ruwa. Manase 'ga Amom 'ga ruwa. Amom 'ga Josiasi 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiasi 'ga Jekoni 'ga ruwa, 'ga rewirera 'gã nuwa nanẽ nũ. Jekoni 'ga rekoramũ Israeu juapyrera 'gã nee iporomutare'ema 'gã 'ua ojemorypa 'gã nee, 'gã pyyka, 'gã faa, 'gã nerawau Papironi ywy pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Papironi ywy pe weroo re Jekoni 'ga wa'yramũ. Jekoni 'ga Saratieu 'ga ruwa 'ga. Saratieu 'ga Soropapeu 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Soropapeu 'ga Apiute 'ga ruwa. Apiute 'ga Eriakĩ 'ga ruwa. Eriakĩ 'ga Aso 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso 'ga Satoki 'ga ruwa. Satoki 'ga Akĩ 'ga ruwa. Akĩ 'ga Eriute 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriute 'ga Eriesa 'ga ruwa. Eriesa 'ga Matã 'ga ruwa. Matã 'ga Jako 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jako 'ga Jose 'ga ruwa. Jose 'ga Mari ẽẽ mena. Mari ẽẽ ra'yra 'ga Jejui 'ga. Ẽẽ wi futat 'ga 'ari rakue. Jejui Kristu 'ga Janeruwarete 'ga remimurera te. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraão 'ga remyminũ juapyret awau ojemomytuna katosi rakue. Awau owaẽma Davi 'ga upe rakue. A'eramũ Davi 'ga remyminũ juapyrera nãnẽwẽjẽmĩ ojemomytuna katosi rakue. Awau owaẽma Papironi ywy pe 'gã nerooawa upe. Papironi ywy pe weroo re 'gã nãnẽwẽjẽmĩ 'gã nemymĩnũ juapyrera ojemomytuna katosi rakue. Awau owaẽma Kristu 'ga i'aawa upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nan Janeruwarete 'ga Jejui Kristu 'ga muri ywy pe rakue. Janeruwarete 'ga 'Agesagea Jejui 'ga mua Mari ẽẽ upe rakue, ẽẽ ra'yramũ rakue. Mari ẽẽ merama 'ga Jose 'ga. A'ere Jose 'ga ẽẽ rerekoe'emauwe Janeruwarete 'ga 'Agesagea kunumĩ muri ẽẽ upe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","“Mari ẽẽ ta'yt” 'e kwaapawe Jose 'ga 'jau ojeupe: “Najera'yra rũi futat. Nakoi we je ẽẽ ree”, 'jau 'ga ojeupe. “Narekokatui je ẽẽ 'awamũ. Maran ajee je ẽẽ rerekoi 'awamũ 'ũ? Namome'ua'uweri je ẽẽ 'gã nupe. ‘Ta'yr ẽẽ’ 'e kwaawe'emauwe pa je ẽẽ retygi kwy”, 'jau 'ga ojeupe. Jose 'ga esage ma'ea. A'jeteetewi tee 'ga mama'e apoi rakue. A'eramũ 'ga a'eramũ oporerekowere'emamũ ẽẽ ree. A'ere 'ga nafutari ẽẽ mojenosĩa nanẽ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wemiaporam are 'ga wea'aramũ oser enune. 'Ga ser ire Janeruwarete 'ga pyriwara 'ga amũ 'ua ojesaukaa 'ga upe, 'ga fayupaw ipe. A'eramũ 'ga oje'ega Jose 'ga upe, judeu 'gã 'wyriat ymanera 'ga juapyrera 'ga upe, Davi 'ga juapyrera 'ga upe: —Ku'jywa 'ga 'Agesagea te kunumĩ amut Mari ẽẽ upe. A'eramũ ene epy'a'wyre'emamũ ẽẽ ree. “Narekoi je ẽẽ”, ere awi. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kũima'ea futat ẽẽ ra'yra 'ga. 'Ga 'aramũ ene 'ga re'roka. 'Ga futat 'ut opytuna 'gã tywera moiawamũ 'gã nui. A'eramũ ene Jejui nuga 'ga ree— 'jau ywagipewara 'ga Jose 'ga fayupaw ipe 'ga upe. (Grego 'gã je'eg imũ aekatu'okat 'ea futat poromũ Jejui 'ea.) ");
INSERT INTO kyzNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Ymã te 'ã Janeruwarete 'ga oje'ega mome'ui Isai 'ga upe rakue. “Anure nipo kũjãmuku ẽẽ mũ ra'yramũ. Kunumĩ 'ga 'ar ire nipo 'ga 'jau Emanueu 'jau 'ga upe”, 'jau 'ga Isai 'ga upe rakue. (Epyreu 'gã je'eg imũ Emanueu 'ea Janeruwarete 'ga ako jane pyri 'ea futat.) U'eawer imũ etee futat Janeruwarete 'ga Jejui 'ga muri kũjãmuku ẽẽ mũ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Opag ire Jose 'ga awau Mari ẽẽ 'wyr ipe, ẽẽ rerua oje'wyr ipe, ywagipewara 'ga 'eawer imũ etee futat rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","A'ere 'ga ẽẽ ra'yra 'ga 'are'emauwe nokoi futari ẽẽ ree. Ẽẽ ra'yra 'ga 'ar ire Jose 'ga 'ga re'rogi. Jejuja 'ga inuga 'ga ree, ywagipewara 'ga 'eawer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Perẽi me Jejui 'ga u'aa rakue. Judeja ywy pype Perẽi 'jawa amunawa 'upa. Israeu juapyrera 'gã nupe 'wyriaramũ Erote 'ga renamũ Jejui 'ga u'aa rakue. Jejui 'ga 'ar ire kũima'e 'gã amũ 'ua Jerusareg ipe, Erote 'ga rekwaw ipe. Muku awi 'gã nuri. Kwara poawa katy awi 'gã nuri. Jaytata mojopyrũara 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","'Gã poromũ 'ut muku awi. A'eramũ 'gã oporonupa ee judeu 'gã nupe: —Ma'ape te pẽ'wyriarareterama 'ga 'ari 'awamueuu rai'i? Oroje'wyr ipe ore rekoramũ jaytata yau renyfugamũ ojesaukaa oree ai'i. Esakawe ore 'jau arajaupe ai'i: “Judeu 'gã 'wyriarareterama 'ga u'at ra'e”, 'jau ore arajaupe ai'i. A'eramũ ore arajua koromũ 'ga muorypa arakou— 'jau 'gã Jerusareg ipewara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","A'eramũ Erote 'ga opy'a'wyramũ ee. “Ma'ape te judeu 'gã 'wyriarareterama 'ga 'ari rai'i” 'e renupawe 'ga opy'a'wyramũ ee. “Tỹỹ. Je futat nã'ã a'ỹi 'wyriaramũ judeu 'gã nupe re'ã”, 'jau 'ga ojeupe. “Awỹja upe sipo 'gã 'i poromũ 'wei?” 'jau 'ga ojeupe. A'eramũ 'ga opy'a'wyramũ akou ee. Jerusareg ipewara 'gã juejue futat nanẽ opy'a'wyramũ aipo are nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A'eramũ Erote 'ga mainana 'wyriara 'gã murukaa ojepyri Moisesi 'ga je'eger are moromu'jara 'gã neewe. —Ma'ape te Janeruwarete 'ga remimurama 'ga 'ari e'i te 'gã nakue— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—“Perẽi me nipo 'ga 'ari”, e'i 'gã nakue. “Judeja ywy pype 'up ma'e pype nipo 'ga 'ari”, e'i 'gã nakue— 'jau mainana 'gã Erote 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","—Ymã te Janeruwarete 'ga oje'ega kwasiarukari ka'aran are oje'ega mome'wara 'ga upe rakue: “Perẽi mewaramũ pẽẽ pejejenosõue'em pejeje'wyr awi. Sikõi'ĩ agawewi pẽ'wyra. A'etea nipo pẽ'wyr ipe futat pẽ'wyriarareterama 'ga u'at anure. Poromũ futat nipo 'ga 'ua ajemogou 'wyriarareteramũ jeremiayuwamũ pẽ nupe, Israeu juapyreramũ pẽ nupe”, 'jau 'ga ikwasiarukaa Mikeiasi 'ga upe rakue— 'jau mainana 'wyriara 'gã imome'wau Erote 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","A'eramũ Erote 'ga muku awi 'ut ma'efera 'gã nenũina. —Pe'je pejejua. 'Gã nemianuwa tywi saporogyta jarejetee 'jau— 'jau 'ga 'gã nupe. A'eramũ 'gã awau oporogytau 'ga upe. A'eramũ 'ga 'jau 'gã nupe: —Maranime te peesak jaytata yaua rai'i? Ma'e 'ara rupi te peesak rai'i?— 'jau 'ga 'gã nupe. A'eramũ 'gã jaytata yau resakawera mome'wau esage 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A'eramũ Erote 'ga 'jau 'gã nupe: —Pe'je pejewau Perẽi me. “Perẽi me futat ore'wyriarareterama 'ga 'ari”, e'i mainana 'wyriara 'gã jee— 'jau 'ga jaytata yau resakarera 'gã nupe. —A'eramũ pẽẽ pejewau 'ga rekaa. 'Ga resag ire tepejot 'ga rekwawa mome'wau jee 'jau. A'eramũ je nanẽ tewau 'ga muorypa— 'jau Erote 'ga 'gã nupe. A'ere o'meramũ te Erote 'ga 'i 'gã nupe. “'Ga rekwawa tejeupe 'gã imome'u re too 'ga jukau 'jau kwy”, e'i te 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ojeupe 'ga imome'u re 'gã awau nũ. 'Gã waw ipe jaytata yau ojesaukaru'japa 'gã nupe nũ. —Kuu. Kweramũ janeremiesagera rekoi ra'e kũi— 'jau 'gã ajaupe. A'eramũ 'gã aku'iramũ jaytata yau are. Jaytata weny rerawau 'gã nenune. A'eramũ 'gã jaytata reny rewiri etee futat akou. Awau jaytata opytau Jejui 'ga rekwawa 'oga 'arimũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","A'eramũ 'gã awau osou 'ga 'wyr ipe. Kunumĩ'ĩ 'ga 'gã esaka 'ga y ẽẽ retee, Mari ẽẽ retee. A'eramũ 'gã wapyka wenupy'ãu Jejui 'ga rowase 'ga muorypa. A'eramũ 'gã wemirerurera okaraemã renũ'jãu imua wepyrũ awi imonou 'ga upe. Ouru, Janeruwarete 'ga upe iapypyra jany kasig, mira 'jawa jany kasig. Mĩmera 'gã imonou Jejui 'ga upe. 'Ga upe 'gã nemirerurera epy ete mama'ea. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ypytunimũ Janeruwarete 'ga oje'ega jaytata mojopyrũara 'ga amũ upe 'ga fayupaw ipe: —Pejewyt kasi pejewau Erote 'ga pyu ne— 'jau 'ga 'ga upe, 'ga fayupaw ipe. Opag ire ofayup ma'efera 'ga imome'wau opytuna 'gã nupe. A'eramũ 'gã awawe'em Erote 'ga pyu. Amutee pe rupi etee 'gã awau ojewya oje'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","'Gã o re ywagipewara 'ga amũ ojesaukaa Jose 'ga upe. 'Ga fayupaw ipe 'ga ojesaukaa oje'ega 'ga upe: —Erote 'ga ifuewet Jejui 'ga ree. Anurenure'i nipo 'ga wemiayuwa 'gã murukari Jejui 'ga rekaa, 'ga jukaawamũ. A'eramũ ene 'awauwe futat 'ga rerawau 'ga y ẽẽ retee eroka'jama 'ga wi. Egitu ywy pe pekwap. Peu futat pejepytau. “Pe'je pejejewya Judeja ywy pe”, pejejeupe je'e'emamũ pẽẽ pejekou Egitu ywy pe etee futat— 'jau ywagipewara 'ga Jose 'ga upe, 'ga fayupaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A'erauwe Jose 'ga ojypa, okaraemã mogatyrũmũ. Ypytunimũwe futat 'ga Jejui 'ga rerawau 'ga y ẽẽ reewe 'gã neroka'jama erawau Egitu ywy pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Erote 'ga manũe'emamũ 'gã akou Egitu ywy pe etee futat. Ymã te Janeruwarete 'ga oje'ega kwasiarukari Oseja 'ga upe rakue: “Egitu ywy awi je teja'yra 'ga muri”, 'jau 'ga ikwasiarukaa 'ga upe rakue. A'eramũ 'ga u'eawer imũ etee futat 'gã monoukaa Egitu ywy pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erote 'ga jaytata mojopyrũara 'gã napesaka 'ũina numiamũ. A'ere 'gã nooi 'ga pyu. “Tỹỹ. Nuri futari te 'gã imome'wau jee 'wei. Je morytee pa 'gã nai'i”, 'jau 'ga ojeupe. A'eramũ 'ga amara'neramũ 'ũina 'gã nee. A'eramũ 'ga wea'aramũ jaytata mojopyrũara 'gã je'eger are jaytata yau resakawer are. A'eramũ 'gã 'jau: “Nomagwawi we kunumĩ 'ga mukũi kwara”, 'jau 'ga ojeupe. A'eramũ 'ga 'jau wemiayuwa 'gã nupe: —Pe'je pejewau kunumĩ'ĩ'ĩ apisaupap. Perẽi mewara 'gã na'yra 'gã, ipyriu'i ajemogy ma'e 'gã na'yra 'gã. Mĩmera ki peapisi. Mukũi kwara magwapare'ema 'gã juejue ki peapisi— 'jau Erote 'ga wemiayuwa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ymã te Jeremi 'ga ka'arana kwasiari ee rakue. “Rama 'jaw ipewara 'gã wapirũ wa'yra 'gã. Opapap 'gã na'yra 'gã nui. Rakeu ẽẽ taetu wa'y'ri are u'arasigeteteramũ. Ni'arasĩmawa'uweri te ẽẽ wa'yra 'gã nee”, 'jau Jeremi 'ga ikwasiaa inuga rakue. A'jea futat 'ga remikwasiarera. 'Ga remikwasiarer imũ etee futat Erote 'ga kunumĩ'ĩ'ĩ apisaupawukaa wemiayuwa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Anure, Erote 'ga manũ re, Janeruwarete 'ga ojepyriwara 'ga amũ resaukaa Jose 'ga upe, 'ga fayupaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Jejui 'ga ree ifuewet ma'e 'ga amanũ 'awamũ. A'eramũ ene 'ga rerawau erojewya 'ga y ẽẽ retee pejejewya Israeu juapyreramũ pejeywy pe— 'jau ywagipewara 'ga Jose 'ga upe 'ga fayupaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A'erauwe Jose 'ga ojypa, okaraemã mogatyrũmũ. A'eramũ 'ga Jejui 'ga rerawau 'ga y ẽẽ reewe, 'gã nerojewya oywy pe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Oywy upe owaẽmawe Jose 'ga 'wyriara 'ga rera renupa. “Erote 'ga ra'yra 'ga, Akirau 'ga 'ũi 'wyriaramũ Judeja ywy pewara 'gã nupe”, 'jau 'ga amũ Jose 'ga upe. A'eramũ 'ga okyjau 'ga pyri oo awi. A'eramũ ywagipewara 'ga ojesaukaa 'ga upe nũ, 'ga fayupaw ipe nũ. “Garireja ywy pe pekwap”, 'jau 'ga 'ga upe, 'ga fayupaw ipe. A'eramũ Jose 'ga 'gã nerawau Garireja ywy pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasare 'jawa amunawa 'upa Garireja ywy pype. A'eramũ Jose 'ga 'gã nerawau 'gã neropytau Nasare pe. Ymã te Janeruwarete 'ga je'ega mome'wara 'gã 'i rakue: “Anure nipo 'gã 'i 'ga remimono 'ga upe, Nasare pe waranup ma'efera 'ga, 'jau nipo 'gã 'ga upe”, 'jau Janeruwarete 'ga je'ega mome'wara 'gã nakue. A'eramũ Jose 'ga Jejui 'ga muaranupa Nasare pe futat, 'gã 'eawer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Anure, Jejui 'ga aranuw ire, Juã Batista 'ga awau amunawe'em ipe oje'ega ojepyri oo ma'e 'gã nupe. Judeja ywy pype 'ga rekoi oje'ega 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Peru'arasig tee awi pejetywera. Pepoit tãmẽjẽ pejetywer awi— 'jau 'ga 'gã nupe. —Anurenure'i nipo Janeruwarete 'ga wemimura 'ga resaukari janee. 'Ga remimurera 'ga 'ã Janejararetea. A'eramũ ki pẽẽ pejepoia pejetywer awi 'ga rur enune— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ymã te Janeruwarete 'ga ka'arana kwasiarukari Isai 'ga upe, Juã 'ga rekwawam are rakue: “Amunawe'em ipe nipo 'ga amũ awau akou wafukaita 'ga nupe: Pe'je Jarejararete 'ga rape katu'oka imonou 'ga renune. Pepyo esage etee futar iki imonou jarejeupe 'ga ruawamũ, 'jau nipo 'ga akou wafukaita amunawe'em ipe”, 'jau Janeruwarete 'ga ikwasiarukaa Isai 'ga upe rakue. “Jarejararete 'ga rapea pekatu'ok imonou 'ga renunewe”, 'jau 'ga 'gã nupe. Aipo 'ga “pejetywer awi pepoit”, e'i te 'ga 'ua janee. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juã 'ga kameru rawa apopyrera rerekou waityramũ imunepa. Wyra pirera 'ga erekou aku'afaawamũ. 'Ga raitya ymãwarera 'ga raity 'jawerimũ etee futat, Eliasi 'ga raity 'jawerimũ etee futat. 'Ga remi'ua tukut, eit. Mĩmera etee 'ga remi'ua rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A'eramũ 'gã 'ua Jerusareg awi 'ga je'ega renupa ajatykau. Judeja ywy awi, Jotãuy ka'a awi. Mĩmer awi 'gã 'ua ajatykau 'ga je'ega renupa. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Otywer awi 'gã poir ire Juã 'ga 'gã pymĩãu 'y pe. Jotãuy pe 'ga 'gã pymĩãu. “'Awamũ je mama'e esage etee iapoi, Jarejuwarete 'ga je'eg imũ”, 'jau 'gã ojepymĩãukaa 'y pe 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","A'eramũ fariseu 'gã satuseu 'gã netee 'ua kwaiwete ojepymĩãukaa Juã 'ga upe. A'eramũ 'ga 'gã nesakawe 'jau 'gã nupe: —Ma'eramũ pẽẽ pejejua pejejepymĩãukaa ekoete jee ki 'ei, pejetywer awi opoit ma'e 'jawe 'ũ? Pejetywer awi ra'ne pepoit kũi. A'eramũ te je pẽ pymĩ kũi— 'ga 'i etee 'gã nupe ojee 'gã jatykaramũ. A'eramũ 'ga 'jau 'gã nupe: —Janeruwarete 'ga imara'ne pẽ nee. Pẽtywer are 'ga mara'neramũ pẽ nee. A'eramũ nipo 'ga pẽ nerekou tyweaete pẽtywer are. “Ene'me awi”, pe'je awi etee jee. A'jea futat nipo 'ga pẽ nereko tyweretei. “Nore rereko tywera'uweri 'ga”, pe'je awi. A'jea futat 'ga pẽ nereko tyweretei— 'jau Juã 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","—Pe'je pejewau mama'e esage mũ apou pejetywer awi pejepoira resaukaawamũ kũi— 'jau 'ga oje'ega moywyrafena 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","—“O'meramũ 'ga 'i”, pe'je kasi jee ne. “Je 'ã Abraão 'ga juapyrera te. A'eramũ 'ga a'eramũ je rereko tywere'ema”, pe'je kasi ne. Janeruwarete 'ga ifutar ire amunipo 'ã 'ga ita mu'jagi Abraão 'ga juapyreramũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","—Sã'ã ae 'ywa i'a a'wyre'ema iypy mosoga. A'eramũ 'ã ae erawau imonou imomoa tata pe. Nan tee futat 'ga pẽ nerekoi pejetywer awi pepoire'emamũ— 'jau 'ga fariseu 'gã nupe satuseu 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","A'eramũ 'ga 'jau najuejue etee 'gã nupe: —Je 'ã a'jea futat apymĩ pẽẽ 'y pe tekou pejetywer awi pẽ poira resaukaawamũ. A'ere je rewiri 'ut ma'e 'ga te Jarejuwarete 'ga 'Agesage muri pẽ nupe. Je rewiri 'ut ma'e 'ga te kũima'eeteetea te. Je naani. Je akotee'i ma'ea te. Apoat te je 'ga tekou— 'jau 'ga 'gã nupe. —Werowiaara 'gã nupe 'ga 'Uwarete 'ga 'Agesage muri. Werowiare'ema 'gã te nipo aje 'ga wereko tywerete anure— 'jau Juã 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","—Sã'ã ae juowuuran ape 'oga. A'eramũ 'ã ae a'ỹi esage mũ'jãu jui. A'eramũ 'ã ae iapefera monou tata pe. Nan tee futat nipo 'ga werowiare'ema 'gã monoi mama'eukwaawa rapyaw ipe. Aipoa tata nowewi futari. Nitywi futari imowepara 'ga amũ— 'jau 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jotãuy pe Juã Batista 'ga rekoramũ, Jejui 'ga 'ua owaẽma 'ga upe rakue. Garireja ywy awi 'ga 'ua owaẽma ojepymĩãukaa 'y pe Juã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A'ere Juã 'ga 'i: —Naani nũ'ũ. Naje rũi ene pymĩara. Ene te 'ã kũima'eeteetea. Je 'ã naani. Je 'ã akotee'i ma'ea te. A'eramũ je te amunipo 'ã tejepymĩãukaa enee— 'jau Juã 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A'ere Jejui 'ga 'i 'ga upe: —A'jea futat ere poromũ jee. A'ere Janeruwarete 'ga ene je pymĩa futari. A'eramũ jane iapou 'ga remifutar imũ etee futat— 'jau Jejui 'ga Juã 'ga upe. —Nai'i— 'jau 'ga 'ga upe. A'eramũ 'ga 'ga pymĩãu 'y pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Opymĩ re Jejui 'ga 'ua awua 'y awi. 'Y awi 'ga wyrauwe ywaga owoka 'ga upe. A'eramũ 'ga 'Uwarete 'ga 'Agesage rura resaka. Pykau 'jawe 'ua ywag awi wapyka 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","U'agesage jyw ire Janeruwarete 'ga oje'ega mua ywag awi: —Koromũ futat jera'yrarete 'ga. Jeremifutararetea 'ga. 'Ga etee futat je muorypararetea ojee— 'jau 'ga oje'ega mua ywag awi 'gã nupe, Jejui 'ga 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","'Y pe 'ga jepymĩ re Janeruwarete 'ga 'Agesagea Jejui 'ga rerawau erekou amunawe'em ipe, mama'eukwaawa 'wyriara 'ga resakaawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Peu akou Jejui 'ga ojemi'ware'ema akou. Kwarẽta 'ara 'ga imagwapa akou ojemi'ware'ema. A'eramũ 'ga opy'arayparamũ akou. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","A'eramũ mama'eukwaawa 'wyriara 'ua 'ga resaka. “Taesak 'ga poira 'uwa 'ga rerowiar awi 'jau kwy”, 'jau akou ojeupe etee futat. “Teje'ega taenuwukat esaka 'ga upe 'jau kwy”, 'jau 'ũina ojeupe etee futat. A'eramũ 'jau Jejui 'ga upe: —“Ku'jywa 'ga ra'yra je”, ere 'ã. A'eramũ ene ita mu'jaga ejemi'uramamũ— 'jau mama'eukwaawa 'wyriara 'ua Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aipo ojeupe 'eramũ Jejui 'ga 'jau jupe: —Naani. Naene rũi je arowiat tekou. Tejuwarete 'ga etee te je arowiat tekou. Jeruwarete 'ga e'i oree: “Nawemi'uram are tee rũi ae rekoi”, 'jau oree jepi— 'jau etee 'ga jupe. —“Jeje'ega renupara 'gã etee te ajemogy a'jea futat”, e'i 'ga ikwasiarukaa inuga oree rakue. A'eramũ je 'ga je'ega renupa tekou— 'jau Jejui 'ga mama'eukwaawa 'wyriara upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","A'ere mama'eukwaawa 'wyriara Jejui 'ga rerawau Jerusareg ipe. Jerusarega pype Janeruwarete 'ga mogytaawa 'ũina. A'eramũ 'gã 'jau, Janeruwarete 'ga 'wyrarete, 'jau 'gã Jerusarega upe. Peu futat 'ga rerawau. Janeruwarete 'ga mogytaawa apyte'rarimũ 'ga rerawau erojeupia. Ywatewate 'ga mogytaawa. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A'eramũ mama'eukwaawa 'wyriara 'jau 'ga upe nũ: —Ku'jywa 'ga ra'yra 'ã ene. A'eramũ ene ewau epoa 'aw awi. Nerepena'uweri ewau. Jaruete ereo e'aa. Ymã ako Ku'jywa 'ga ka'arana kwasiarukari 'ga amũ upe wa'yramũ ene ree ikue. “Tejepyriwara 'gã je omono enee. A'eramũ 'gã ojejukau ene ree. A'eramũ ene ejemokanãje'ema ewau e'aa. Epya miamũ ene imokanãje'ema ita are”, 'jau ako Ku'jywa 'ga ka'arana kwasiarukaa wa'yra 'ga ree ikue— 'jau mama'eukwaawa 'wyriara Jejui 'ga upe. “Omorytee pa je 'ga kwy”, 'jau ojeupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A'ere Jejui 'ga 'i etee jupe: —A'jea futat aipo 'ea numiamũ. A'ere je narowiari futari eneje'ega. Jeruwarete 'ga ka'arana okwasiarukat ajepeja 'ga upe nanẽ nũ: “A'jea futat sipo ajee 'ga jejukai je ree, pe'je kasi jee ne, je rerowiare'ema ne”, e'i 'ga ikwasiarukaa ajepeja 'ga upe rakue— 'jau 'ga jupe. —A'eramũ je eneje'ega mojerowiare'ema— 'jau etee Jejui 'ga mama'eukwaawa 'wyriara upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A'eramũ mama'eukwaawa 'wyriara Jejui 'ga rerawau 'ga rerojeupia ywytyr apyte'rarimũ nũ. Peu 'ga rerowaẽm ire mama'eukwaawa 'wyriara ywy resaukaa 'ga upe. Mama'ea ipype ajemogy ma'e reewe futat esaukapap 'ga upe. Kamẽsĩete futat mama'e resaukaa ywy pypewara resaukapap 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Ikaturam te 'ã eneremiesaga. Je rowase eapyk ejenupy'ãu je muorypa. A'eramũ je eneremiesagera monoupap enee— 'jau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","A'eramũ Jejui 'ga 'jau jupe: —Ere ejepe'au je wi, ki mama'eukwaawaiwet. Ymã 'ã Jeruwarete 'ga oje'ega kwasiarukari ka'aran are 'ga amũ upe rakue. “Je te 'ã Pẽjararetea. Je te 'ã Pẽnuwaretea. A'eramũ ki pẽẽ jeje'ega tee enupa pejejemogyau. Je tee ki je muoryp pejepe pejejemogyau”, 'jau 'ga 'ã ikwasiarukaa 'ga amũ upe rakue— 'jau etee Jejui 'ga jupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amojerowiare'emauwe mama'eukwaawa 'wyriara ojepe'au awau Jejui 'ga wi. 'Ga wi iorauwe ywagipewara 'gã amũ 'ua ojejukau 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aipo re Jejui 'ga Juã Batista 'ga rera renupa. “Juã Batista 'ga 'gã opyyk imonou imunepa imỹina moromunepawa pype” 'e renupa. A'eramũ Jejui 'ga awau ojewya Garireja ywy pe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A'ere 'ga nopytai oje'wyr ymaner ipe, Nasare pe. Kafanaũ 'jaw ipe etee 'ga awau opytau. Kafanaũ 'jawa 'upa ypiauu pyri, Garireja 'jawa pyri. Ymã te Sepurõ 'ga juapyrera 'gã 'upa Garireja ywy pype Nafitari 'ga juapyrera 'gã netee 'gã 'upa rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Ymã te Janeruwarete 'ga je'ega mome'wara 'ga, Isai 'ga ka'arana kwasiari ee rakue, peuwara 'gã mome'wau rakue. Sepurõ 'ga juapyrera 'gã nekwaw ipewat, Nafitari 'ga juapyrera 'gã nekwaw ipewat, Jotãuy pyriwat, 'yẽ'ẽ pyriwat, Garireja ywy pewat. Mĩmera 'gã 'ga imome'wau rakue. Garireja ywy pe judeue'ema 'gã nekoi judeu 'gã pyri rakue: “Anure nipo ypytunimũ ajemogy ma'e 'jawewara 'gã mama'e reny 'jawewara resagi. 'Awamũ 'gã nokwaawi Janeruwarete 'ga. A'ere nipo 'gã anure 'ga kwaawi”, 'jau Isai 'ga ikwasiaa rakue. Isai 'ga 'eawer imũ etee futat Jejui 'ga oi peu, Garireja ywy pe Jarejuwarete 'ga mome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pejetywer are ki pẽnea'at peje'arasigamũ pejejemogyau. A'eramũ futat pejepoia pejetywer awi. Anurenure'i nipo Janeruwarete 'ga wemimureramũ je mỹi 'wyriaramũ pẽ nupe. Pejetywer awi pepoir ire 'ga pẽ mogyi wemiayuwamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","A'ere Jejui 'ga awau watau Garireja ypiauu reme'y'warimũ. Aipo pe awau 'ga ipira rewara 'gã nesaka. Simão 'ga, Andre 'ga. Mĩmera 'gã 'ga esaka. Simão 'ga rer irũa Pedroa. Andre 'ga Simão Pedro 'ga rewirera. Jejui 'ga wesagamũ 'gã taityuu monou etyka 'y pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pe'je pejejua je rupi. Simu'e pẽẽ 'jau. Naipira rewara rũi pẽẽ 'awamũ. Jarejuwarete 'ga je'ega mome'wara te pẽẽ 'awamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","A'erauwe 'gã taityuu rejaa awau 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Awaw ipe Jejui 'ga Tiago 'ga resaka 'ga rewirera 'ga retee, Juã 'ga retee. Sepeteu 'ga ra'yra poromũ. Yaruu pype 'gã 'upa 'uwa 'ga pyri, taityuu momyka. A'eramũ Jejui 'ga 'gã mo'wya: —Pe'je pejejua je rupi— 'jau 'ga Tiago 'ga upe, Juã 'ga retee. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A'erauwe 'gã ũ'jãu yaruu awi, 'uwa 'ga rejaa awau Jejui 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Garireja ywy pyterimũ Jejui 'ga awau akou peuwara 'gã mu'jau 'Uwarete 'ga ree. —Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga pẽtywera moiri pẽ nui. A'eramũ 'ga pẽ mogyau wemiayuwamũ— 'jau 'ga 'gã nupe, 'gã mu'jau 'Uwarete 'ga ree. 'Gã jatykaaw ipe 'ga 'gã mu'jau 'ga ree. Ojero'wu ma'e 'gã 'ga ikatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","“Jejui 'ga ojero'wu ma'e 'gã okatu'ok” 'ea awau uãina Siria ywy pypiaruga. A'eramũ kwe pewara 'gã we futat ikwaapa. A'eramũ kwe pewara 'gã ojero'wu ma'e 'gã nerua 'ga upe. Ojero'wu ma'e, iypip ma'e, ika'na ma'e, iteu ma'e, mama'eukwaawa rerekwat. Mĩmera 'gã 'gã erua Jejui 'ga upe. A'eramũ Jejui 'ga 'gã katu'okapap. ");
INSERT INTO kyzNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A'eramũ kwaiwete 'gã awau Jejui 'ga rewiri. Tekapuru ywy awi, Garireja ywy awi, Jerusareg awi, Judeja ywy awi, Jotãu ry owajara katywar awi. Mĩmer awi 'gã 'ua ajatykau Jejui 'ga ree, 'ga je'ega renupa. Ojero'wu ma'e 'gã katu'oga resaka nanẽ 'gã 'ua ajatykau 'ga ree nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kwaiwete 'gã nesakawe Jejui 'ga ojeupia'i awau ywytyra rupi. A'eramũ 'ga wapyka. 'Ga apygauwe 'ga ree ijemu'ewet ma'e 'gã 'ua wapyka 'ga pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A'erauwe Jejui 'ga oje'ega 'gã nupe, 'gã mu'jau 'Uwarete 'ga remifutar are. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Jarejuwarete 'ga upe “Jetywerete je tekou. Ejejuka je ree” 'jara 'gã aku'iramũ ajemogyau. A'e 'gã Janeruwarete 'ga imogyau wemiayuwamũ. A'eramũ 'gã aku'iramũ ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ojoo'o ma'e 'gã aku'iramũ ajemogyau. Anure nipo Janeruwarete 'ga 'gã mojemogypyyka'i 'gã mogyau 'gã 'arasig awi. A'eramũ nipo 'gã aku'iramũ ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ajuee ipota'wa ma'e 'gã aku'iramũ ajemogyau. 'Gã nupe Janeruwarete 'ga mama'e esage monoi u'eawer imũ etee futat. A'eramũ 'gã aku'iramũ ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","A'jea futat Janeruwarete 'ga remifutar imũ etee mama'e are iparuapowet ma'e 'gã aku'iramũ ajemogyau. A'e 'gã a'jea futat Janeruwarete 'ga opoat mama'e apoukaa wemifutar imũ. A'eramũ 'gã aku'iramũ ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ajuee ajemuaẽm ma'e 'gã a'jea futat iku'i ajemogyau. 'Gã nee nipo Janeruwarete 'ga jemuaẽmi. A'eramũ 'gã aku'iramũ ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","A'jea futat mama'e esage are etee ea'at ma'e 'gã iku'i futat ajemogyau. “Tamuoryp Jarejuwarete 'ga 'jau”, 'jau nipo 'gã ojeupe. A'eramũ nipo anure aipo 'gã awau Jarejuwarete 'ga pyri. A'eramũ 'gã a'e are aku'iramũ ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ajaupe ojomota'waara 'gã aku'iramũ ajemogyau. Anure nipo Janeruwarete 'ga 'i 'gã nupe: “'Agamũ jera'yra 'gã”, 'jau nipo 'ga 'gã nupe. A'eramũ 'gã aku'iramũ ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Jarejuwarete 'ga remifutara apo are ereko tyweripyrera 'gã nipo aku'iramũ ajemogyau. A'e 'gã Janeruwarete 'ga amogy wemiayuwamũ. A'eramũ 'gã aku'iramũ ajemogyau— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Jeremiayuwamũ pejemogyramũ nipo je rerowiare'ema 'gã pẽ kurawi. Pẽ nerekou tyweaete je ree. Pẽ je'ẽwu'jaga je ree. A'ere pẽẽ pejejereko tywereteramũ pẽku'i etee futat pejejemogyau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","—Anure nipo Janeruwarete 'ga mama'e esage monoi pẽ nupe kwaiwete. A'eramũ pẽẽ pejeku'iramũ etee pejejemogyau. Ymã te 'ã Janeruwarete 'ga rerowiare'ema 'gã 'ga je'ega mome'wara 'gã nereko tyweretei rakue. A'eramũ nipo 'ga rerowiare'ema 'gã pẽẽ nanẽ pẽ nerekou tyweaete 'ga rerowiaaramũ— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Jukyra 'jawe pẽẽ. Sã'ã jukyra. Ipyu omosa re 'ã miaro'oa oneme'emamũ. Nan tee futat pẽẽ. Mama'e esage apo re mama'e tywera apoukare'ema 'gã nupe. Sã'ã ae jukyra tyweramũ monoa imỹina imomoa ukupepe. A'eramũ 'ã ipyu wata ma'e 'gã opyruga ee. Nan tee futat pẽẽ. Mama'e tywera aporamũ 'gã mu'jawarũe'em mama'e esage apo are. Nepẽ nerowiari 'gã a'eramũ— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Tata reny 'jawe nanẽ pẽẽ nũ. Tata renya 'ã ypytunaiwa mojesaka. Nan tee futat pẽẽ. Jarejuwarete 'ga remifutar imũ etee mama'e apo re pẽ nesakara 'gã neapyoramũ Jarejuwarete 'ga ree. A'eramũ nipo 'gã 'ga muorypa pẽ nee. Ywytyr apyte'rarimũ amunawa apo re ipyriwara 'gã juejue esaka. Nomimarũi 'ga amũ. Nan tee pẽẽ. Pẽ pyriwara 'gã juejue pẽnemiapofera resaka ajemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","—Nomonyga'uweri ae arãparĩna mũ imỹina imima mama'e 'ag are. Imonyg ire ae imonoi imỹina ajuesawamũ te. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nan tee futat ki pẽẽ. Jarejuwarete 'ga rerowiare'ema 'gã nowase mama'ea peapo. A'eramũ nipo pẽ nesakara 'gã Jarejuwarete 'ga muorypa pẽ nee, pẽ nemiapofer are— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—NaMoisesi 'ga remikwasiarera mateepapa rũi je ruri. “Moisesi 'ga remikwasiarer imũ kasi mama'ea peapo ne”, na'e rũi je tekou. “Janeruwarete 'ga je'ega mome'wara 'gã je'ega nia'wyri”, na'ea'uweri je tekou. Naani. Ee pẽ mueapyo katuawamũ te je ruri. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A'jea futat 'gã nemikwasiarer ymanera resageramũ janee 'awamũ miamũ futat. A'jea futat nateepawa'uweri Janeruwarete 'ga je'ega jane wi. Ywaga teepawamũ ywy reewe 'eramũ miamũ futat nateepawa'uweri Janeruwarete 'ga je'ega— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","—Anure, Jarejuwarete 'ga pyri 'ga je'ega renuparera 'gã jemogyi kũima'eeteeteramũ. A'ere 'ga je'ega renupap katuare'ema 'gã naani. 'Ga je'ega renup katuare'ema 'gã ajemogyau akotee ma'e 'jawe 'ga pyri oo re. “Peapo kasi mama'ea aipo 'ga je'eg imũ ne” 'jara 'gã nanẽ ajemogyau akotee ma'e 'jawe 'ga pyri oo re nũ. Aipo 'gã namojeupawa rũi 'ga pyri oo re— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","—Fariseu 'gã, Moisesi 'ga remikwasiarer are moromu'jara 'gã netee mama'e esagea wapo 'me ae reape etee. A'eramũ nipo 'gã nesakara 'gã 'jau: “Mama'e esagea 'gã wapo”, 'jau nipo 'gã 'gã nesakara 'gã. A'ere 'gã naJarejuwarete 'ga muorypawamũ rũi mama'e apoi. 'Gã 'jawe kasi peko ne. Jarejuwarete 'ga muorypawamũ etee mama'e apou 'eramũ etee nipo 'ga pẽ mogyi wemiayuwamũ— 'jau 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Ymã te 'ga amũ 'i janeypy 'gã nupe rakue: “Pejuka kasi 'ga amũ ne. Oporojuka ma'e 'ga nipo 'gã weroo amũ 'wyriara 'ga upe. A'eramũ nipo 'wyriara 'ga oporojuka ma'e 'ga jukaukaa 'gã amũ nupe, 'ga remijukafera repyaawamũ”, 'jau 'ga amũ janeypy 'gã nupe rakue— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","—A'jea futat 'gã 'eawera. A'ere 'awamũ je 'i pẽ nupe: Pẽmara'ne ekoete kasi pejepytuna 'ga ree ne. Opytuna 'ga ree imara'ne ekoete ma'e 'ga nanẽ nipo 'gã erawau ekoete 'wyriara 'ga upe nũ. Opytuna kurapara 'ga nanẽ nipo 'gã erawau ekoete 'wyriara poara 'gã nupe nũ. “Nene'akwaawi te 'ã ene” 'ga amũ upe 'eramũ Janeruwarete 'ga aipo 'jara 'ga monoi mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—A'eramũ ki pẽẽ pejejemogyau esage Jarejuwarete 'ga upe. Jarejuwarete 'ga mogytaaw ipe mama'e mũ rerooaw ipe pejejea'aramũ pejepytuna 'ga ree, pejejee iporomutare'ema 'gã nee 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","A'eramũ ki pejejee iporomutare'ema 'ga upe ra'ne pejewau 'ga mojyrũmũ pejejeupe. Pejejeupe 'ga mojyrũ re tãmẽjẽ pejewau Jarejuwarete 'ga mogytaaw ipe nũ, mama'e rerawau 'ga upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—“Mama'e tywera 'ga wapo jee”, pejejeupe 'ga amũ 'eramũ pejewau pejeporogytau 'ga upe, 'ga mota'wau pejejeupe. Kasi a'e pe 'ga pẽ nerooi 'wyriara 'ga upe ne. A'eramũ 'wyriara 'ga pẽ monoukaa jefaruu 'ga upe, pẽ munewukaa ne. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Moromunepawa pype pejemono re nipo nepe'ẽarũi jui. Mama'e tywera apo mepy re tãmẽjẽ te pe'ẽ jui— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Ymã te 'ã Moisesi 'ga 'i janee rakue: “Peko kasi pejejuemireko are ne”, 'ga 'i janee rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A'jea futat 'ga 'eawera. A'ere 'awamũ je 'i pẽ nupe: Kũjã mũ resag ire nipo pẽẽ mũ 'jau: “Kuu. Ikatura'mĩ te ẽẽ nũ'ũ. Ako pa je ẽẽ ree kwy”, 'jau nipo pẽẽ pejejeupe. Aipo 'jara 'ga wemirekoe'em are ako ma'ea futat. Wea'aw imũ etee futat aipo 'ga akou wemirekoe'em are— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","—“Jerea je motywet. Ẽẽ resage'em ire amunipo 'ã je najerea'ari ẽẽ ree teko are”, 'jau nipo pẽẽ pejejeupe. A'eramũ je 'jau pẽ nupe: “Orereaa ore motywerukat”, 'jau pejejea pemosok imonou imomoa pejejewi. Kasi a'e pe pẽnea pẽ motywerukaru'jaw ine— 'jau 'ga 'gã nupe. —Wea mosoga ay futat wea mosokara 'gã nupe numiamũ. A'ere mama'eukwaawa rapyaw ipe pẽo te naay teepawi pẽ nui. Janeruwarete 'ga mama'e tywera apoara 'gã monou mama'eukwaawa rapyaw ipe. A'ea te nipo ayay futat aipo pype imonopyra 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","—“Mama'e apoa ore motywerukat”, 'jau pejepoa pemonok imonou imomoa pejejewi. Aepo monoga ay futat numiamũ. A'ere Janeruwarete 'ga mama'e tywera apoara 'gã mama'eukwaawa rapyaw ipe imomopora teayramũ. A'eramũ waywayramũ imonopyra 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Ymã te Moisesi 'ga 'i rakue: “Pejejemireko retyka ki ka'arana pekwasiarukat 'ga amũ upe ẽẽ ree. ‘Aetyk je ene tejemirekoferamũ akiko’, pe'je ki ikwasiarukaa pejejemirekofera ẽẽ ree, imonou ẽẽ upe”, 'jau 'ga rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","—A'ere je 'awamũ je 'i pẽ nupe: Peetyk ekoete kasi pejejemirekoa ne. 'Ga amũ ẽẽ ree 'ga reko re etee pẽẽ etyka. Kasi a'e pe tekotee 'gã 'i ẽẽ upe: “Oko nipo ẽẽ amutee 'ga ree ra'e. A'eramũ ẽẽ mena 'ga ẽẽ retyka”, 'jau nipo 'gã ẽẽ upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. —A'eramũ 'gã anure kũima'e ẽẽ ree amũ remiarũnamũ 'jau ẽẽ upe ne: “Kuu. Emã'ẽ 'ga kũjã tywera ẽẽ 'ga wereko wemirekoramũ”, 'jau nipo 'gã ẽẽ upe. A'eramũ 'ga ẽẽ rereko re nipo amutee 'gã 'jau: “Amutee 'ga remireko ẽẽ 'ga wereko”, 'jau nipo 'gã 'ga upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Ymã te Moisesi 'ga 'i janeypy 'gã nupe rakue: “Pẽ'me kasi Jarejuwarete 'ga upe ne. ‘Taapo mama'e esagea ene upe 'jau’ Jarejuwarete 'ga upe 'jaramũ pẽẽ aipoa etee futat iapou 'ga upe peje'eawer imũ etee futat. A'ere kasi pẽ'me ne”, 'jau 'ga rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A'ere je 'i pẽ nupe: “Ywaga teepawe'emamũ je mama'e apoi enee”, 'jawe'em pẽẽ pejejaupe, pejeje'ega rerowiarukaawamũ. Pe'je peje'me'emamũ pejejaupe. Ywag ipe Janeruwarete 'ga rekoi. A'eramũ pẽẽ ywaga mome'wau ekoete'em pejejaupe erowiarukaa futatee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ywya nanẽ pẽẽ imome'wau ekoete'em pejejaupe nũ. Ywya 'ã 'ga py rupawa futat. A'eramũ pẽẽ peje'me'emamũ ee nũ. Jerusareg are nanẽ peje'me ekoete'emamũ nũ. Jerusarega jane'wyriarareterete 'ga 'wyraretea te. A'eramũ pẽẽ imome'wau ekoete'em pejejaupe erowiarukaa futatee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Mama'ea taapo ene upe 'jau” 'eramũ pẽẽ aipo etee futat iapou peje'eawer imũ etee futat. Pejeje'ega ekoete'em futat pejejemogyau. “Teakag are je 'i enee mama'ea taapo enee 'jau”, 'jawe'em pẽẽ pejejaupe erowiarukaa futatee. Naene rũi e'awa mosigara. Naene rũi nanẽ e'awa moũnara nũ. A'eramũ ki pẽẽ pejeakag are peje'me'emamũ pejejaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Mama'ea taapo enee 'jau” 'eramũ pẽẽ aipo etee futat iapou. Mama'e are pejeparuapowere'emamũ pẽẽ “Naani. Najeparuapoweri je ee”, 'jau tãmẽjẽ ki pẽẽ pejejaupe. Pẽ'me kasi pejejaupe ne. Ojeupe pẽ'me'emamũ 'gã pẽje'ega rerowiaa. Ojeupe pẽ'meramũ 'gã pẽje'ega nuerowiari futari. “I'me ma'e 'gã te ako”, 'jau etee 'gã pẽ nupe ne. “Janeruwarete 'ga remianuwamũ je 'i enee: Mama'ea taapo enee 'jau, a'e je enee”, 'jau nipo 'gã o'me rerowiarukaawamũ ajaupe. Mama'eukwaawa 'wyriara i'me ma'ea futat. A'eramũ ki pẽẽ peje'me'emamũ pejejaupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Ymã te 'ã Moisesi 'ga 'i rakue: “Pejepyg iki 'gã amũ nee. 'Gã amũ nipo pẽnea mamuka 'eramũ pejejepyka 'ga ree, 'ga rea mamuka. 'Ga amũ pejejãja mopen ire pẽẽ 'ga rãja mũ mopena, pejejepyka 'ga ree”, 'jau 'ã Moisesi 'ga rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","—A'ere je 'awamũ je 'i pẽ nupe: Pejepyk kasi nanuara 'gã nee ne, a'e je pẽ nupe. 'Ga amũ nipo eneretywape nupãu. A'eramũ ki ejetywape nupãnamũ erowag etee amogaty 'ga upe— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","—Eneraitya mũ futaa nipo 'ga amũ ene rerawau 'wyriara 'ga upe. “Ejaitya emut amũ 'ga upe, 'ga mepyawamũ”, ere ki 'ga upe, 'jau futatee nipo 'ga ene rerawau 'wyriara 'ga upe. A'eramũ ki ejaitya emono etee 'ga upe ejaity poakuwuu reewe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","—“Majepei kilometro rupi ene jekaraemã eroo jee”, ejeupe 'ga amũ 'eramũ ene erawau mukũi kilometro rupi 'ga upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","—“Mama'e mũ emut jee”, ejeupe 'ga amũ 'eramũ imonou etee futat 'ga upe— 'jau Jejui 'ga 'gã nupe. —“Ekaraemã mũ emut jee ra'ne”, ejeupe 'ga amũ 'eramũ “naani”, ere kasi 'ga upe ne. Emono futat 'ga upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Pẽmu'jara 'gã 'ã e'i pẽ nupe: “Pẽporomutar ete ki pẽẽ pejejekoty'aawa 'gã nee. Pereko esage etee ki 'gã. A'ere ki pejejee iporomutare'ema 'gã pereko tywet”, 'jau 'gã pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A'ere 'ã je 'i pẽ nupe: Pereko esage pejejekoty'aawa 'ga. Pejejee iporomutare'ema 'gã nee nanẽ pejejejukau esage nũ. “Ejejuka esage ki ore rereko tyweara 'gã nee”, 'jau etee ki pẽẽ Jarejuwarete 'ga upe 'ga nee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aipo apo re nipo pẽ nesakara 'gã 'i: “A'jea futat. 'Gã Ku'jywa 'ga remiayuwaretea. A'eramũ 'gã 'ã 'ga 'jawe 'gã ojee iporomutare'ema 'gã nereko esagei”, 'jau nipo 'gã pẽ nesaka. Janeruwarete 'ga mama'e esagea wapo pãwẽ pãwẽ janee. Kwara 'ga imuenyu esage ma'e 'gã nupe, ia'wyre'ema 'gã nupe we. Amana 'ga imogyrukaa mama'e esage apoara 'gã nupe, mama'e tywera apoara 'gã nupe we— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Pejejee iporomutat ma'e 'gã nereko esagea etee sipo Janeruwarete 'ga afutat? Pejejee iporomutare'ema 'gã nereko tywera sipo 'ga afutat? Naani. Pẽ mepy sipo 'ga pejejee iporomutat ma'e 'gã nereko esage are? Naani. Nomepyi futari 'ga pẽ nupe. “Itywerete 'wyriara upe ka'aranũũ rerooara 'gã”, 'jau 'ã pẽẽ jepi. A'etea 'gã miamũ wereko esage ojee iporomutat ma'e 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pejejee iporomutat ma'e 'gã nupe etee oporogyta ma'eramũ 'ã pejejemogyau Janeruwarete 'ga rerowiare'ema 'gã 'jawe. 'Ga rerowiare'ema 'gã miamũ oporogytau ojee iporomutat ma'e 'gã nupe. A'eramũ je 'jau pẽ nupe: 'Gã nupe juejue ki peporogyta. Pejejee iporomutat ma'e 'gã nupe, pejejee iporomutare'ema 'gã nupe. Mĩmera 'gã nupe pejeporogytau pejejemogyau— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","—Janeruwarete 'ga 'ã mama'e esagea etee wapo pãwẽ pãwẽ janee. A'eramũ ki pẽẽ pejejemogyau 'ga 'jawe futat— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","A'eramũ Jejui 'ga 'jau akou 'gã nupe, 'gã mu'jau 'gã neko esage are: —Jarejuwarete 'ga upe mama'e apou kasi peapo amutee 'gã nupe pejejee 'gã moporesakawamũ etee ne. Pẽnemiapo resakara 'gã nipo 'jau: “Kuu. Esage ma'e 'ga ra'e”, 'jau nipo 'gã pẽ nupe. A'eramũ nipo nanuaramũ Janeruwarete 'ga pẽ mepyawe'em pẽnemiapofer are. Aipo 'gã 'ea te futat pẽnemiapofera repya ra'e— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—A'eramũ pẽẽ, imama'e'ema 'gã nupe mama'e mono re imonowe'em amutee 'gã neape. Pejejuea tywi pejejaupe mama'e mũ monou miamũ pẽẽ imome'wawe'em pejejaupe, pejejerowiaraipe'ema pejejemiapofer are. Sã'ã ae mama'e esage apoaramũ. Nan tee futat aipo 'gã numiamũ. A'ere 'gã iapoi amutee 'gã ojee 'gã moporesakawamũ etee. Judeu 'gã jatykaaw ipe kwaiwete 'gã ajatykau 'upa. A'eramũ 'gã 'gã neape mama'e monou imama'e'ema 'ga amũ upe. Amunawa myter ipe nanẽ 'gã mama'e monou 'gã nupe nũ. Wemiapoa 'gã iapou mytuna 'gã nemiesagamũ. 'Gã nupe esaukaripyramũ te 'gã iapoi. A'eramũ nipo 'gã nesakara 'gã 'jau: “Kuu. Esage pa'e 'gã na'e nũ. Mama'ea 'gã omono imama'e'ema 'gã nupe”, 'jau nipo 'gã 'gã nesakawe. A'eramũ nipo 'gã nesakarera 'gã 'eawera etee futat 'gã nemiapofera repya. Janeruwarete 'ga 'gã mepyawe'em anure— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","—A'eramũ ki pẽẽ, ikaraemãe'ema 'gã amũ nupe mama'e mono re, imonou jemime futat. 'Gã nupe imonou kasi amutee 'gã nupe pejesaukar etee ne. Pejejekoty'aawa 'gã nupe miamũ pẽẽ pejejemiapofera mome'wawe'em. Jarejuwarete 'ga upe pejejesakawamũ futat pẽẽ iapou. A'eramũ nipo Janeruwarete 'ga pẽ mepyau pẽnemiapofer are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Jarejuwarete 'ga upe pejeje'ega monou ki, 'ga upe etee futat peje'eg. A'ere 'ã 'ga upe oporogyta 'me ma'e 'gã porogyta 'mei etee 'ga upe. Judeu 'gã jatykaaw ipe 'gã 'ã Jarejuwarete 'ga upe oporogytau 'me ajemogyau. Amunawa pyter ipe nanẽ 'ã 'gã oporogytau 'me ajemogyau 'ga upe nũ. A'ere 'gã amutee 'gã nemianuwamũ tee 'gã porogyta 'me 'ga upe. 'Gã wesakawamũ etee 'gã porogyta 'mei 'ga upe. A'eramũ nipo Janeruwarete 'ga 'gã mepyawe'em anure— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A'eramũ 'ga 'jau wenupara 'gã nupe: —Pejemogy kasi 'gã 'jawe ne. Jarejuwarete 'ga upe pejeporogytau pejejepe'au'i 'gã nui ra'ne. Pejejetee pejewau peje'ỹina pejeporogytau 'ga upe. Jarejuwarete 'ga upe ete'i futat peporogyta pejejemogyau. A'eramũ nipo 'ga anure pẽ mepyau ojeupe pẽporogyta are— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Peporogyta ekoete kasi Jarejuwarete 'ga upe ne, 'ga upe pejeporogytau ne. 'Ga rerowiare'ema 'gã oporogyta 'me etee 'ga upe. Oporogytau 'me kwaiwete 'ga upe. “Ojeupe je porogyta kwajamũ nipo 'ga jeje'ega renuwi”, 'jau 'gã ojeupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A'ere kasi peporogyta 'ga upe aipo 'gã 'jawe ne. Pejejea'awa etee peenũi 'ga upe. Ojeupe peporogyta enune 'ga pẽnemifutara kwaawi. A'eramũ ki pẽẽ pejejemifutara etee enũina 'ga upe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Nan iki peporogyta 'ga upe: “Kiapi'ni. Ene 'ã Oreruwaretea. Ywag ipe 'ã ere'ỹi. A'eramũ ore oroje'ega arajupa enee. Tene muoryp ki 'gã najuejue etee. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kamẽsĩete ki 'gã najuejue etee tene rerowiat ajemogyau. Kamẽsĩete tere'ỹi 'wyriaramũ oree najuejue etee 'jau. Ywagipewara 'gã 'ã mama'ea wapo eneremifutar imũ etee futat. Nan tee futat ywy pewara 'gã iapoa ore arafutat. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","'Awamũ ki mama'ea emut oree oreremi'uramamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Norerea'aru'jawi ore mama'e tywera orojeupe 'ga iapoawer are. A'eramũ ki ene ejea'aru'jawe'emamũ oretywer are. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ore mamuakat futar iki ape mama'e tywera apoe'em are. Mama'e tywera jar awi ene ore a'gwau, mama'eukwaawa 'wyriar awi”, pe'je ki 'ga upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau 'Uwarete 'ga upe 'gã porogyta are. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—'Gã amũ pejejereko tyweawer are pẽẽ 'gã naykae'emamũ Janeruwarete 'ga nanẽ nepẽ naykai pẽnemiapo tywer are. Imoia etee futat 'ga pẽtywera pẽ nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A'ere 'ga pejejuaykapawe'emamũ 'ga nanẽ pẽ nakyaupawe'em ee nũ— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—'Ga upe pejeporogytaawa upe iwaẽmauwe pẽẽ pejewau pejejemi'ware'ema pejeporogytau Jarejuwarete 'ga upe. Aipoa esage. Aipoa Janeruwarete 'ga amuoryp. A'ere kasi pejejeakwara pemu'arasig ee ne. Janeruwarete 'ga remiayup 'me 'gã i'arasig ajemogyau. Weakwara nipo 'gã imotyaipa ajemogyau. A'eramũ nipo 'gã nesakara 'gã 'jau: “Kwe 'ga ty'ara weroporogyta Ku'jywa 'ga upe ra'e”, 'jau nipo 'gã nesakara 'gã 'gã nupe. A'eramũ 'gã 'eawera etee futat 'gã nemiapofera repya. Janeruwarete 'ga nomepyi futari 'gã ee— 'jau Jejui 'ga 'gã nupe 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","—A'eramũ pẽẽ 'ga upe pejeporogytaawa upe iwaẽmauwe pejejowaeita, pejejemoyma pejeje'wyr awi peje'jãue'ẽwe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","A'eramũ pẽ nesakara 'gã ty'ara pereko kwaape'ema ajemogyau. A'eramũ Janeruwarete 'ga etee futat ikwaapa 'ũina. A'eramũ 'ga pẽ mepyau ee anure— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Anure nipo Janeruwarete 'ga pẽ mepyi ojeupe pẽnemiapofer are. A'eramũ ki pẽẽ pejejea'aramũ pejejeupe imepyram are. 'Au kasi pemomytun pejekaraemã ne. 'Auwara mama'ea teepaw etee. Jypemeruua etee taity a'upap. Itaju apopyrera miamũ eposipopora etee a'upap. Muna'ywa nanẽ amunarũmũ pẽkaraemã are 'jau. A'eramũ ateepawamũ etee pẽ nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","A'eramũ ki pẽẽ mama'e apou Jarejuwarete 'ga upe etee. A'eramũ 'ga anure mama'e esage monou pẽ nupe, ojeupe pẽnemiapofera mepyawamũ. Peu te mama'ea nateepawa'uweri. Nitywi futari mama'e mateepaara. Nitywi futari jypemeruua. Naeposipopori futari mama'ea. Nitywi futari amunarũ ma'ea peu. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ojeupe pẽẽ mama'e aporamũ 'ga mama'e mũ mỹigatui pẽ nupe peu ojepyri. Ojeupe pẽnemiapofer imũ etee futat 'ga pẽ mepyau peu. Ojeupe kwaiwete mama'ea pẽẽ iapo re 'ga kwaiwete futat mama'e mỹigatui pẽ nupe. Ojepyri peo re te nipo 'ga wemimỹigatufera muri pẽ nupe. A'eramũ ki pẽẽ mama'e apou 'ga upe kwaiwete futat. 'Auwara karaemã momytunara 'gã ea'at 'auwara ako ma'e are etee ajemogyau. A'ere ywag ipe karaemã momytunara 'gã nearamũ Jarejuwarete 'ga ree— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","—Tata reny 'jawe aereaa. Sã'ã tata enya mama'e resaukara janee. Nan tee futat jarejeau jane mama'e resagi. Ea ma'e 'gã wesak katu katu futat mama'ea. Eawep ma'e 'ga te aje 'ã nuesakatui mama'ea. Nan tee futat pẽẽ. Ea ma'e 'gã 'jawewaramũ pẽẽ pẽneapyo pejejemogyau jeje'eg are, erowiaa pejejemogyau. A'eramũ pẽẽ mama'e apou Jarejuwarete 'ga je'eg imũ etee futat. A'ere eawep ma'e 'jawewaramũ nepẽneapyoi futari jeje'eg are. Neperowiari jeje'ega. A'eramũ pẽẽ pejejemifutar imũ etee futat mama'e apou pejejemogyau. Ypytunaiwa pype wata ma'e 'jawe pẽẽ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Namukũja 'wyriara 'gã nemiayuwamũ rũi 'ga amũ rekoi. Noporowykya'uweri 'ga amũ mukũja 'wyriara upe. Kasi a'e pe 'ga majepeja 'ga ree etee 'ga poromutaramũ akou ne. Ajepeja 'ga ree jẽmĩ oporomutare'emamũ ne. Wemifutara 'ga je'eg imũ etee mama'e apou ne. A'eramũ 'ga wemifutare'ema 'ga je'eg imũ mama'e apowe'em ne. Nan tee futat pẽẽ. Pejeka'aranũũ kwai are etee ea'at ma'eramũ nepẽnea'aru'jawi Jarejuwarete 'ga ree— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Ma'eramũ 'ã je 'i pẽ nupe: Pẽnea awi mama'e are etee pejejemogyau, je 'i pẽ nupe. “Ma'ja je i'wau 'awamũ”, pe'je awi pejejeupe— 'jau Jejui 'ga 'gã nupe 'ũina. —Pẽnea'ar awi pejejaity are etee pejejemogyau. Jarejuwarete 'ga ree te pejemogypyyk pejejemogyau, 'jau je 'ã pẽ nupe— 'jau 'ga 'gã nupe 'ũina. —'Ga te 'ã pẽ apo rakue. A'eramũ 'ga ojee pejemogypyygamũ mama'e mua pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sã'ã wyra'ia. Wyra'ia 'ã nuapoi agawewi mama'ea. Nitywi agawewi 'ã mama'e tymawa. A'etea 'ã Janeruwarete 'ga mama'ea omono jupe— 'jau Jejui 'ga 'gã nupe. —Niapoi agawewi wyra'ia 'ga upe. A'etea 'ga ojejukau ee. Pẽẽ taetu aje 'ã aeramũ 'ga upe. A'etea sipo 'ga nojejukai pẽ nee?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","—Peko sipo amũ pejeymane'em are ete ea'at ma'eramũ amũ pejeymane'emamũ namutat?— 'jau Jejui 'ga 'gã nupe. —Naani. Nia'wyri futari aipoa miamũ pẽ nupe ee pẽnea'ara. A'etea te nipo pẽyman pejejemogyau. Pejeywyr are tee pejejea'aramũ miamũ pemanũ futat. Mama'e are etee pẽnea'at pẽ nekoa nepẽ koga'uweri— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—A'eramũ ki pẽẽ pejejea'are'emamũ pejejemogyau pejejaity are ete. Sã'ã 'ywotyra jũ mewara. 'Ywa 'ã noporowykyi agawewi opotyr are. A'ere 'ã ipotyra esageteeramũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","—Ymã te janepytunera 'ga, Sarumãu 'ga, ikaraemã kwai ma'ea rakue. 'Ga te 'ã taity esage ma'ea rakue. A'ere 'ã 'ywotyra te 'ga raity esage apyraawi. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","'Ywotyra 'ã majepei 'ara rupi etee wesageramũ. A'eramũ 'ã ai'iwe opỹijagamũ. A'eramũ nipo 'ga amũ iapyau. A'etea 'ã Janeruwarete 'ga omokaturam ipotyra jupe— 'jau 'ga 'gã nupe. —Jupe iapo re sipo 'ga nomonoi mama'e esagea pẽ nupe? Pẽẽ taetu aje 'ã pẽnesage 'ywotyra resage apyraapa 'ga upe. Ma'eramũ pẽẽ 'ga rerowiaraipa etee 'ũ? Pe'je 'ga rerowiaa a'jea futat pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Au'je mama'e are etee pẽnea'ar ire. Pejemuaẽm awi pejejemi'uram are etee. Pejemuaẽm awi nanẽ pejejaity are etee nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","—Janeruwarete 'ga rerowiare'ema 'gã te ajemuaẽm mama'e are etee. A'ere kasi pẽẽ 'gã 'jawe peko ne. Janeruwarete 'ga pẽnemifutara okwaap. Ojejuka 'ga pẽ nee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","—Jarejuwarete 'ga remifutar are etee pejejea'aramũ pejejemogyau. 'Ga je'ega renuw are ki pẽnea'at. “'Ga remifutar imũ sipo je mama'e apoi” 'e are etee ki pejejea'aramũ pejejemogyau. Wemifutar imũ mama'e apo are pejejuka re 'ga mama'e esage muri pẽ nupe, ojejukau pẽ nee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","—A'eramũ ki pẽẽ pejemuaẽme'ema ai'iwewar are. “Au'je pa 'awauwewara kwy”, pe'je ki pejejemuaẽme'ema ee— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—“Nepẽa'wyri pẽẽ Jarejuwarete 'ga upe”, pe'je kasi 'gã amũ nupe ne. Aipoa 'gã nupe 'e'emamũ Janeruwarete 'ga nanẽ aipo ne'i pẽ nupe. “Mama'e tywerete 'ã ereapo ekou”, pe'je kasi 'gã nupe ne. Aipoa 'gã nupe pẽẽ 'e'emamũ Janeruwarete 'ga nanẽ aipo ne'i pẽ nupe nũ— 'jau Jejui 'ga 'gã nupe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","—'Gã nupe pẽ'eawera 'jawerimũ etee futat nipo Janeruwarete 'ga 'i pẽ nupe. Mama'ea 'gã nupe iapoawera 'jawerimũ etee futat Janeruwarete 'ga iapoi pẽ nupe— 'jau 'ga 'gã nupe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","—Najuejue etee futat pẽtywet. A'eramũ pẽẽ “Itywet ma'ea pẽẽ” 'jawarũe'em pejejaupe. A'eramũ ki pẽẽ pejejaupe aipo 'e enune pejetywera ra'ne etyka. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","“Najetywi je tetywera pyu”, pe'je nipo numiamũ. A'ere pẽtyp futat. A'eramũ pẽẽ pejetywer awi ra'ne pejepoia. A'ere pejejewirera tepepoat 'jau. “Ere epoia etywer awi”, tepe'je pejejewirera 'ga upe 'jau— 'jau Jejui 'ga 'gã nupe 'ũina. —Sã'ã ae 'ywa tuwyrera weape i'aramũ ajuea pewara resage'ema ajaui. A'eramũ 'ã ae enuẽmukaa ra'ne wea awi. Ojewi enuẽm ire 'ã ae ojoma'e resaka ajuea awi. Nan tee futat ae otywer awi ra'ne ae poiri. A'ere ojopoaa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Pe'je pejewau kwe pewara 'gã mu'jau Jarejuwarete 'ga ree, a'e je 'awamũ pẽ nupe. Ee iporenuwiwere'ema 'gã nipo e'i pẽ nupe: “Noreporenuwiweri ore 'ga je'eg are”, 'jau nipo 'gã pẽ nupe. A'eramũ pẽẽ 'ga mome'wau'jape'ema 'gã nupe. Pejewau kamẽsĩete 'gã nui. Amutee 'gã nupe etee pejewau imome'wau nũ. Kasi a'e pe iparuerowiariwere'ema 'gã mara'neramũ pẽ nee ne. Kasuru jarũ 'jawe aipo 'gã. Sã'ã kasuru jarũa ujare'emamũ ae murukare'ema ojepyri. Nan tee futat aipo 'gã. Sã'ã tajaurana. Ojeupe ita esage momor ire ipyruga etee ee. Nan tee futat aipo 'gã— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","A'eramũ Jejui 'ga 'gã mu'jau Jarejuwarete 'ga upe 'gã porogyta are: —Ojeupe pẽẽ mama'e renũjamũ Janeruwarete 'ga imuri pẽ nupe. “Je poar ape” ojeupe 'eramũ 'ga pẽ poari futari. Kamẽsĩete 'ga pejepoare'emamũ, pejeje'ega pejejemogyau pejeojere'emamũ 'ga upe. Sã'ã mama'e 'ara ae wi. A'eramũ 'ã ae ijaramũ awau ekaa. Esag ire tãmẽjẽ 'ã ae opoia ekar awi. Nan tee futat kasi peojet 'ga upe mama'e renũi awi ne. A'eramũ 'ga mama'e mua pẽ nupe— 'jau Jejui 'ga 'gã nupe. —'Okwara mopogara 'ga 'jawe ki peko. 'Okwara rawopytymo'wog ire etee 'ga poiri imopog awi. Nan tee futar iki pẽẽ. Pepoit kasi 'ga upe pejeporogyta awi ne. A'eramũ 'ga pẽ poari futari— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","—“Mama'e emut amũ jee” 'jara 'gã nupe 'ga imuri futari. “Je poar ape” 'jara 'gã 'ga opoat futat. Ojeupe peje'egamũ 'ga je'egi futari pẽ nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Pejenosĩ kasi mama'ea 'ga upe enũina ne. Mama'e esage tee te 'ga amut pẽ nupe. Namura'uweri 'ga mama'e tywera pẽ nupe. Sã'ã pẽẽ. “Mama'ea emut amũ jee, Kiapi'ni”, pejeja'yra pejejeupe i'eramũ mama'e katurama etee imonoa pejeja'yra upe. Nan tee futat Janeruwarete 'ga mama'e esagea etee imuri pẽ nupe, “mama'e esagea emut jee” 'eramũ. Ta'yriaramũ sipo ita pemono pejeja'yra upe, mani'oko'o renũjamũ? Naani. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Moja sipo pemono pejeja'yra upe, ipira renũjamũ? Naani. Mama'e esagea etee futat pemono pejeja'yra upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","—Pẽẽ 'ã aetywera agawewi. A'etea 'ã mama'e esagea etee pemono pejeja'yra upe. Nan tee futat ywag ipe 'ũi ma'e 'ga— 'jau 'ga 'gã nupe. —Janeruwarete 'ga taetu 'ã esage te. Ma'eramũ sipo 'ga mama'e esage mure'ema pẽ nupe, ojeupe pẽẽ enũjamũ? Amut futat 'ga mama'e esagea ojeupe enũinaramũ pẽ nupe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Pẽẽ 'ã Jarejuwarete 'ga remiayuwa. Pefutat 'gã pejejereko esagea. A'eramũ pẽẽ nanẽ pejejejukau esage 'gã nee nũ. Aipo are Moisesi 'ga ikwasiari inuga janee rakue. Janeruwarete 'ga je'ega mome'wara 'gã nanẽ ikwasiaa ee rakue nũ— 'jau 'ga 'gã nupe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","—Pe'i'i rupi ki pekwap. Pe'i'ia ywag ipe oo ma'ea. A'ere noko ayeteramũ jupi ae oa. Amume'riramũ etee te peo aipoa pe'i'i rupi. Pe'i'i rupi oo ma'eramũ etee te peo Jarejuwarete 'ga pyri nakwaparimũ warãu rũi pejejemogyau peu. Peuu rupi ae oa te ajee naayi futari numiamũ. Kwaiwete te 'gã oi peuu rupi. A'ere peuu rupi oo ma'e 'gã oi mama'eukwaawa rapyaw ipe te. Peu futat 'gã oi ajemogyau nakwaparimũ warãu rũi. Peu 'gã awau ajemogyau tywet— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—A'eramũ ki pẽẽ pejejea'gwau Jarejuwarete 'ga je'ega mome'wararũare'ema 'gã nui. 'Ga je'ega nipo 'gã omome'u 'me pẽ nupe. 'Ga je'ega mome'wara 'jawe futat nipo 'gã numiamũ. A'ere 'gã o'meramũ te 'gã 'i. “Tamomoirukat 'gã Jarejuwarete 'ga rerowiar awi 'jau kwy”, e'i tee 'gã ajemogyau. A'eramũ pẽẽ 'gã nerowiare'ema pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","—'Gã je'eg are ki pekwaap 'gã. Jarejuwarete 'ga je'eg imũ etee 'gã mama'e mome'uramũ pẽẽ 'gã kwaapa. “Aipo 'gã a'jea futat 'ga je'ega omome'u”, pe'je ki 'gã je'ega renupa. 'Ga 'eawer imũ moromu'jare'ema 'gã sigaty etee omome'u 'ga je'ega ajemogyau. Sã'ã y'waa 'ywa. Nooi ae ju'yw are maga rekaa. Nopo'oi ae mamãũũa amyneju 'yw awi. Nan tee kasi peo moromu'jat tywera 'gã je'ega renuwu'japa ne— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","—Y'wa 'yp katurama i'a katuram tãmẽjẽ futat. Y'wa 'yw a'wyre'ema o'ywa 'jawe etee futat ni'aa'wyri. Y'wa 'yp katurama pekwaap i'a esage are. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ni'a katurama'uweri futari y'wa 'ywa tywera. Y'wa a'wyre'ema etee 'ã akã are. Y'wa katurama 'aa o'ywa katurama 'jawe tãmẽjẽ futat— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","—Nan tee futat pẽẽ. Jarejuwarete 'ga je'eg are moromu'jat tywera 'gã ia'wyre'ema futat. 'Gã je'eg are pẽẽ moromu'jat tywera 'gã kwaapa tãmẽjẽ futat. O'me are 'gã mu'e re nipo moromu'jat tywera 'gã wa'wyre'emamũ. Sã'ã y'wa a'wyre'ema jara 'gã y'wa 'ywa retyga imonoa imomoa tata pe. Nan tee futat nipo Janeruwarete 'ga moromu'jat tywera 'gã monoi imomopoa mama'eukwaawa rapyaw ipe anure— 'jau 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—“Ore 'ã Jejui 'ga remiayuwa”, e'i futatee nipo 'gã amũ. “Jejui 'ga Orejararetea”, 'jau futatee nipo 'gã. A'ere 'gã nosei futari ywag ipe. Nuapoi futari 'gã mama'ea Jeruwarete 'ga remifutar imũ. Nuenuwi 'gã 'ga je'ega. A'eramũ 'gã osowe'em ywag ipe. 'Ga je'ega renupara 'gã etee futat oo ajemogyau ywag ipe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","—Anure nipo Jarejuwarete 'ga rowase pejemajatykaaw ipe kwaiwete 'gã 'i ekoete jee: “Jarejuwarete 'ga je'eg are ore oi kwe pewara 'gã mu'jau ikue”, 'jau nipo 'gã jee. “Eneremiayuwa 'jawe futat ore mama'eukwaawa moia erekwara 'gã nui. Eneremiayuwa 'jawe futat ore aeremiapoe'ema apou ikue”, 'jau nipo 'gã jee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","—A'ere nipo je 'i 'gã nupe: “Pẽẽ pekwap futat je wi muku. Jeremiayup 'mea te pẽẽ. Mama'e tywera apoarera te pẽẽ”, 'jau nipo je 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Jeje'ega renuparamũ pẽ'akwaap pejejemogyau. Sã'ã i'akwaap ma'e 'ga 'oga mỹja ywy ãtã pype. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kwaiwete agawewi 'ã amana 'ua. Ywytuu agawewi 'ã erua. A'etea 'ã 'oga nu'ari futari ywytuu upe. 'Y ruwiretea miamũ 'ã owaẽme'ema jupe. A'eramũ 'ã aipoa 'oga awawe'em ypy pe. Nan tee futat jeje'ega renuparamũ pẽẽ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","—A'ere jeje'ega renupare'emamũ pejemogy i'akwaawe'ema 'ga 'jawe. I'akwaawe'ema 'ga te ajee 'oga omỹi amũ 'y apopewa pype. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A'eramũ amanakyr ypy are we 'ga roga awau ypy pe 'ga wi. A'eramũ futat 'ã 'y rypojuga 'ga roga retyka 'ga wi. A'eramũ nipo jeje'ega renupare'emamũ pẽẽ aipoa 'oga apoara 'ga 'jawe etee futat. Aipo 'ga 'jawewaramũ nipo pẽẽ anure pejepapa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jejui 'ga porogytapaw ire, 'ga renuparera 'gã oporesagamũ ajemogyau 'ga ree. —Kuu. 'Ga pa'e aipo e'i ae mu'jau ra'e nũ— 'jau 'gã ajaupe. —NaMoisesi 'ga remikwasiarer are moromu'jara 'gã 'jawe rũi 'ga porogytai. Moisesi 'ga 'eawer are moromu'jara 'gã Moisesi 'ga 'eawer imũ etee futat 'gã ae mu'ei— 'jau 'gã ajaupe. —A'ere Jejui 'ga nanarũi. U'eawer imũ etee futat 'ga jane mueapyoi ee— 'jau 'gã ajaupe, oporesagamũ 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","'Gã nupe oporogytapaw ire Jejui 'ga 'ua ojypa ywytyr awi nũ. Kwaiwete 'gã 'ua ojypa 'ga reewe te futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Poje ipito'om ma'e 'ga amũ 'ua wapyka wenupy'ãu 'ga rowase. A'eramũ 'ga 'jau Jejui 'ga upe: —Je resag ape, ki Ku'jyp. “Jejui 'ga ae katu'okara”, e'i 'gã jee. A'eramũ je tejua tejesaukaa enee. Je ree ejemuaẽmiweramũ je mokã'ẽ ape— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aipo ojeupe 'erauwe Jejui 'ga opo monou 'ga 'arimũ: —Ko ajee je ene mokã'ẽi 'wei— 'jau Jejui 'ga 'ga upe. Oje'arimũ 'ga po mono ypyrauwe okã'jãu 'ga pito'oma 'ga wi. A'eramũ futat 'ga pira ojekatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'Ga mokã'ẽ re Jejui 'ga 'jau 'ga upe: —Eremome'u kasi emokã'ẽawera tekotee 'gã nupe ne. Ere ewau ejesaukaa mainana 'ga upe ra'ne. “Je resag ape. Jepito'oma okã'ẽ je wi”, ere ewau 'ga upe. “A'jea futat ra'e”, te'i 'ga enee 'jau, ene resag ire 'jau— 'jau Jejui 'ga 'ga upe. —A'ere ene ejeymawa mũ rerawau 'ga upe. A'eramũ 'ga iapyau Jarejuwarete 'ga upe, 'ga muorypa enekã'ẽawer are— 'jau Jejui 'ga 'ga upe. —Moisesi 'ga 'eawer imũ etee futat ene ejeymawa mũ rerawau iapyaukaa Jarejuwarete 'ga muorypawamũ. Ejeymawa mũ rapyukara ene ekã'ẽawera resaukaawa futat— 'jau Jejui 'ga 'ga upe. A'eramũ ipito'om ma'efera 'ga awau ojeupe 'ga 'eawer imũ etee futat iapou. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kafanaũ pe 'gã waẽm ire jefaruu 'gã 'wyria'ri 'ga amũ 'ua owaẽma Jejui 'ga upe. Tapy'ỹi amuteea te 'ã 'ga, romanũa te 'ã 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","A'eramũ 'ga 'jau Jejui 'ga upe: —Jeremiayuwa 'ga ojero'wu 'upa ayrũgatugatu 'ga 'upa— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aipo ojeupe 'eramũ Jejui 'ga 'jau 'ga upe: —Ere iruukwe. Too ene rupi 'ga katu'oka 'jau— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Naani nũ'ũ. Ene 'ã kũima'eeteetea te. Je 'ã akotee ma'ea te. Eje'eg imũ etee futat ekatu'ok 'ga. “Ojekatu'ok futat 'ga” ene 'eramũ 'ga jekatu'ogi futari— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","—Je 'ã jefaruua. A'eramũ je te'wyriara 'ga je'eg imũ etee futat mama'e apou tekou jepi. Je 'ã jefaruua 'gã 'wyria'ria. Sẽg jeremiayuwa jefaruu 'gã pytuna. A'eramũ jeremiayuwa 'gã jeje'eg imũ etee futat mama'e apou ajemogyau. 'Ga amũ upe je 'jau: “Ere ewau peu jee”, 'jau je 'ga upe. A'eramũ 'ga awau. Ajepeja 'ga upe je 'jau jepi: “Ere ejua 'au je pyri”, 'jau je 'ga upe jepi. A'eramũ 'ga 'ua je pyri jepi. Tejeupe oporowyky ma'e 'ga amũ upe je 'jau: “Ekwap mama'e apou jee”, 'jau je 'ga upe. A'eramũ 'ga jeje'eg imũ etee futat mama'e apou jee jepi. A'eramũ ene nanẽ eje'eg imũ etee futat jeremiayuwa 'ga katu'oka jee— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aipo ojeupe 'eramũ Jejui 'ga oporesagamũ etee 'ga ree. A'eramũ 'ga 'jau wewiri ako ma'e 'gã nupe: —Israeu juapyrera agawewi 'ã pẽẽ. A'etea 'ã naje rerowiari pejepe. Inãinãnĩ'ĩ etee futat 'ã pẽẽ je rerowiaa pejejemogyau. Ko 'ga judeue'ema agawewi. A'etea 'ga je rerowiat kwaiwete ra'e jepi— 'jau Jejui 'ga wewiri ako ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","—Peapyaka jeje'eg are? Anure nipo kwaiwete 'gã oi osou ywag ipe. Amunap tesirũmer awi we futat nipo 'gã oi ajatykau ore ree ywag ipe. Peu futat 'gã jemi'wari ymãwarera 'gã pyri. Abraão 'ga, Isaki 'ga, Jako 'ga. Mĩmera 'gã pyri nipo 'gã awau ojemi'waa. Judeue'ema 'gã agawewi. A'etea 'gã je rerowiat ajemogyau. A'eramũ nipo 'gã awau ajatykau ore ree peu Jarejuwarete 'ga pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A'ere 'ã judeu 'gã jẽmĩ naani. Ywag ipe oo ma'eramera 'gã futat numiamũ. A'ere 'gã naje rerowiari etee. Amume'ri 'gã etee 'ã je rerowiaa. A'eramũ nipo Jeruwarete 'ga je rerowiare'ema 'gã monou 'gã pe'au muku ojewi. Ypytunaiwayay pype nipo 'ga 'gã monoi. Peu futat nipo 'gã wayrũ ojere'emamũ ajemogyau. Aya nipo 'gã nerekou, 'gã maema 'gã na'jywa mokãina 'gã mogyau— 'jau Jejui 'ga wewiri ako ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","A'ere 'ga 'jau jefaruu 'gã 'wyria'ri 'ga upe nũ: —Ere ewau ejewya eje'wyr ipe nũ. Je rerowiar ape ekou ra'e jepi. A'eramũ eneremiayuwa 'ga ojekatu'oka enee nũ— 'jau Jejui 'ga 'ga upe. A'eramũ 'ga awau ojewya oje'wyr ipe nũ. Owaẽma ypy we 'ga wemiayuwa 'ga resaka, jaruete 'ga reko esaka. Jejui 'ga 'eawa rupi we etee futat 'ga remiayuwa 'ga ojekatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","A'ere Jejui 'ga awau Pedro 'ga 'wyr ipe nũ. 'Ga roga pype osouwe 'ga Pedro 'ga rojo ẽẽ resaka. Iro'y ẽẽ 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A'eramũ 'ga awau ẽẽ popyyka. A'erauwe ẽẽ ro'ya ateepawamũ ẽẽ wi. A'erauwe ẽẽ afu'ama okama awi mama'e apou 'ga upe 'ga mojemi'waa. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kaaruwamũ peuwara 'gã kwaiwete mama'eukwaawa rerekwara 'gã nerua Jejui 'ga upe. A'eramũ 'ga mama'eukwaawa moia 'gã nui, oje'eg imũ etee futat. Ojero'wu ma'e 'gã nanẽ 'ga ikatu'oka nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ymã te Janeruwarete 'ga je'ega mome'wara 'ga, Isai 'ga 'ga mome'ui rakue: “Janekaruara 'ga omoit jane wi, jane katu'oka”, 'jau Isai 'ga ikwasiaa ka'aran are rakue. Jejui 'ga remiaporama 'ga imome'wau inuga ka'aran are rakue. A'eramũ 'ga 'gã katu'oka, Isai 'ga 'eawer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Anure kwaiwete 'gã 'ua ajatykau 'ga ree. 'Gã nesakawe Jejui 'ga 'jau wemimu'e 'gã nupe: —Kwe katy soo jareyaapa 'jau, 'y owajara katy 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'Gã o enunewe Moisesi 'ga remikwasiarer are moromu'jara 'ga amũ 'ua oje'ega Jejui 'ga upe: —Too ene rupi 'jau, ki Ku'jyp— 'jau 'ga 'ga upe. —Taata tekou ene rewiri kwe pe ene orauwe 'jau— 'jau 'ga 'ua Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat nipo eneatawet je rupi ki sa? A'ere 'ã je najerogi te tekou a'i kũi. Kasuru'miara te 'ã ok. Ywy kwara 'ã 'ga roga. Wyra'i nanẽ 'ã waityramũ nũ. A'eramũ 'ã kaaruwauwe ojewya 'ua waity pype osea. A'ere je nanarũi. Aset ekoete tee futat je tekou. Tekaarupaw ipe je tesea ekoete tee futat tekou. Je 'ã pẽneki'yra agawewi. A'etea 'ã je najerogi tekou. Jeremiayuwamũ nan tee futat pejemogy nũ. A'etea futat te eneatawet je rupi?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A'eramũ Jejui 'ga rerowiaara 'ga amũ 'jau 'ga upe: —Tene ajee jeruwa manũi ra'ne. Tejuwa 'ga manũ re too ene rupi 'jau. 'Ga manũ re nipo a'jea futat tekou ywyapi ene rewiri. Tejuwa 'ga manũa ra'ne je aesak— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A'ere Jejui 'ga 'i etee 'ga upe: —Naani. Ene'me awi. 'Awauwe futat ejot je rupi. Eneruwa 'ga manũ re amutee 'gã totym 'ga enee 'jau— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","A'ere Jejui 'ga u'aa yaruu pype, wemimu'e 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","'Gã yaapaw ipe ywyruua 'ua erujewi 'gã nupe. 'Y ryjuapia yara matyneema imotypywyka ja'wyja'wy 'gã nupe. A'ere Jejui 'ga seri etee futat 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A'eramũ 'ga remimu'e 'gã 'ga renũina 'ga momaka: —Ku'jyp! Ere ejua epaka kũi! Sapap jane kũi!— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Opag ire 'ga 'jau 'gã nupe: —Ma'eramũ pejekyjau nanimenime 'ũ? Maran ajee nepejemogypyygi etee je ree 'ũ? Nepeesagi nipo pejejepype je rekoa ki sa? Je te 'ã areko pẽẽ. Je rerowia'ri etee 'ã pejepe pejejemogyau— 'jau 'ga wemimu'e 'gã nupe. A'erauwe 'ga fu'ami oje'ega ywyruu upe, tyjapetega upe nanẽ nũ. A'erauwe futat ywyruua wojeramũ. 'Y rajapetega nanẽ wojeramũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A'eramũ 'ga remimu'e 'gã oporesagamũ etee 'ga ree. —Ma'e pãjẽ 'ga te jane sireko jarejepype nũ'ũ?— 'jau etee 'gã ajaupe. —Ywyruua te 'ã 'ga amuojet erujewi jarejewi a'i kũi. 'Y rajapetega nanẽ 'ga 'ã imuojea erujewi nũ. Ma'e pãjẽ 'ga te nũ'ũ? Naesagi pa je 'ga amũ je'ega ywytu upe jepi nũ, ywytu muojera erujewi jepi nũ— 'jau 'gã ajaupe oporesagamũ 'ga ree. —Janeruwarete 'ga te wapoukat 'ga upe nũ'ũ— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Garireja ypiauu owajara katy owaẽm ire 'gã oyaruu monou imojekoka Gatara ywy are. Yaruu awi Jejui 'ga ẽm ypyrauwe mukũja 'gã 'ua 'ga rowosõu. Mama'eukwaawa rerekwara 'gã poromũ. Tywy 'arimũ etee futat 'gã nekoi. A'eramũ 'gã 'ua tywy awi Jejui 'ga repejãna. Mama'eukwaawa 'gã muarũukare'ema 'gã mamara'neu 'gã mogyau. Ipojyte 'gã ajemogyau. A'eramũ 'gã pyriwara 'gã okyjau 'gã nui. Nooi futari 'gã 'gã pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A'eramũ Jejui 'ga resakawe mama'eukwaawa werekwara 'gã muafukajukaa Jejui 'ga upe: —Ku'jywa 'ga ra'yra 'ã ene. Maran te ore rereko ape? Norowaẽmi we ore orojereko tyweawa upe— 'jau mama'eukwaawa Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aipo 'eramũ mukuu'i tajaurana ajemogyau ojemi'waa. Kwaiwete tajaurana. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","A'eramũ mama'eukwaawa 'jau Jejui 'ga upe: —'Gã nui ore moir ire ore monoukar ape tajaurana ywyterimũ ore mojejaga— 'jau mama'eukwaawa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Pe'je ajee pejewau— 'jau Jejui 'ga jupe. A'erauwe mama'eukwaawa awau ũ'jãu 'gã nui. Awau ojejaga tajaurana pype. A'eramũ tajaurana mama'eukwaawa ojepype ijejagamũ erowawaka erajemogyau. A'eramũ erawau enujãna ywy'amuku rupi eropopoa erawau eropapa 'y pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A'erauwe tajauran are omaenun ma'e 'gã awau imome'wau amunaw ipewara 'gã nupe: —Ekoay Jejui 'ga 'ua tywy 'arimũ ako ma'e 'gã pirewara omoit 'gã nui ko, imonou tajaurana pype ko. A'eramũ tajaurana opapa ko— 'jau 'gã awau imome'wau amunaw ipewara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A'erauwe amunaw ipewara 'gã 'uapap Jejui 'ga resaka. A'eramũ 'gã 'jau Jejui 'ga upe: —Ere ejepe'au oreywy awi. Nenea'wyri ene ra'e. Orereymawa 'ã ereapisipap— 'jau 'gã Jejui 'ga upe. A'eramũ Jejui 'ga awau 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A'eramũ Jejui 'ga awau 'gã nui. Awau u'aa yaruu pype, awau oyaapa nũ. Oje'wyr ipe 'ga awau ojewya nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","A'eramũ peuwara 'gã teewi iteu ma'e 'ga rerua Jejui 'ga upe nũ. 'Ga rerua 'ga rupia 'ga rupawa reewe Jejui 'ga upe. “Je rerowiat pa 'gã ajemogyau ra'e”, 'jau Jejui 'ga ojeupe. A'eramũ 'ga 'jau iteu ma'e 'ga upe: —Erekyje awi je wi kũi. Enetywera je amoit ene wi— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'gã 'ga rerowiare'ema ajemogyau. A'eramũ 'gã 'jau ajaupe: —Awỹja 'agamũ 'ũ? Janeruwarete 'ga etee te janetywera omoit jane wi— 'jau 'gã ajaupe. —Enetywera je amoit ene wi 'eramũ 'ga Jarejuwarete 'ga 'jawe je rekoi 'ga 'i te janee— 'jau 'gã ajaupe 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","A'ere Jejui 'ga 'gã kwaawi ojee. A'eramũ 'ga 'jau 'gã nupe: —Ma'eramũ pẽẽ poromũ 'jau pejejeupe 'ũ?— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","—Je upe naayi. Iteu ma'e mafu'amaramũ ae nanẽ ojotywera moiri ajaui nũ kũi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","—Pẽneki'yra je 'ã. A'eramũ je tepãjẽ resaukaa pẽ nupe. Iteu ma'e 'ga je amafu'am pẽ neape— 'jau 'ga 'gã nupe. —'Ga fu'ama resaka taje kwaap pejepe 'jau— 'jau Jejui 'ga 'gã nupe. —“Aeteufera 'ga amafu'am. Aetywera 'ga omoit nanẽ ae wi nũ”, tepe'je 'jau. Jeruwarete 'ga te 'ã opãjẽ amut jee. A'eramũ je pẽtywera moia pẽ nui, iteu ma'e mafu'ama nanẽ nũ— 'jau 'ga 'gã nupe. A'eramũ 'ga 'jau iteu ma'e 'ga upe: —Ere efu'ama jui. Ejupawa pyyka erawau eje'wyr ipe— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aipo ojeupe 'erauwe iteu ma'e 'ga afu'ama 'gã neape. A'eramũ 'ga wupawa pyyka erawau oje'wyr ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","A'eramũ esakarera 'gã ajemogyau okyjau, oporesagamũ 'ga ree. A'e pype 'gã aku'iramũ 'ga ree. A'eramũ 'gã 'jau ajaupe. —Kuu. Namafu'ami sipo 'ga 'ga pa, a'e ako je ko re'ã— 'jau 'gã ajaupe. —Ku'jywa 'ga 'ga amafu'amukat 'ga upe— 'jau 'gã ajaupe. A'eramũ 'gã 'jau Jarejuwarete 'ga upe: —Ene te 'ã esage ma'eramũ, ki Ku'jyp. Ene 'ã eremafu'amukat 'ga 'ga upe. Epãjẽa 'ã eremut 'ga upe rai'i— 'jau 'gã Jarejuwarete 'ga upe, 'ga muorypa ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","A'eramũ Jejui 'ga awau watau nũ. Awaw ipe 'ga Mateuramũ je resaka. 'Wyriararete upe ka'aranũũ pyykarera je. Jeporowyky je renamũ Jejui 'ga 'ua oje'ega jee: —Ere ejua je rupi— 'jau 'ga jee, je mo'wya ojeupi. A'erauwe je tepoia teporowyky awi ejaa inuga a'e pe te futat. A'eramũ futat je tewau 'ga rupi, 'ga remimu'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A'ere je 'ga mo'wya teje'wyr ipe: —Ere ejua ejemi'waa je pyri. Ere ejemiayuwa 'gã nenũina erua erojemi'waa jerog ipe— 'jau je 'ga upe. A'eramũ 'gã 'ua ojemi'waa jerog ipe. Orojemi'waaw ipe kwaiwete 'wyriararete 'ga upe ka'aranũũ pyykara 'gã 'ua ojemi'waa ore pyri. Mama'e tywera apoara 'gã nanẽ 'ua ojemi'waa ore pyri nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Poje fariseu 'gã amũ 'ua ore resaka. A'eramũ 'gã 'jau Jejui 'ga remiayuwa 'gã nupe: —Kuu. Ma'eramũ pẽmu'jara 'ga ojemi'waa 'wyriararete 'ga upe ka'aranũũ pyykara 'gã pyri 'ũ? Nia'wyri 'gã kũi. Mama'e tywera apoara 'gã pype nanẽ 'ga reni ojemi'waa kũi. Nojemi'wari noko ae 'gã pyri 'ja. Nia'wyri 'gã ajemogyau kũi— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Aipo 'gã 'e renupawe Jejui 'ga 'jau 'gã nupe: —'Gã pyri je rekoi 'gã poaawamũ te nũ'ũ. Je 'ã morofuanugara 'jawewara te ako 'gã nupe. Sã'ã morofuanugara 'ga muaga monoa ojero'wu ma'e 'gã nupe etee. Nomono ekoetei futari 'ga ijero'wue'ema 'gã nupe muaga. Nan tee futat je. Ia'wyre'ema 'gã katu'okawamũ te je ruri. “Je jeresage”, pe'je 'ã. A'ere je naesage ma'eramũ rũi je ruri pẽ katu'oka. Itywet ma'e katu'oka tee je ruri. Pe'je pejewau pejejemu'jau Jarejuwarete 'ga 'eawer are— 'jau 'ga 'gã nupe. —Ymã te Janeruwarete 'ga oje'ega kwasiarukari Oseja 'ga upe rakue: “Je upe mama'e mura esage futat jee. A'ere pejejuee pẽpota'wa esagea taetu esageramũ jee. Nafutari je tejeupe pẽnemimurera, pejejuee pejepota'wa esage'em ire”, 'jau 'ga ikwasiarukaa 'ga upe rakue— 'jau Jejui 'ga fariseu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Anure Juã Batista 'ga remiayuwa 'gã amũ 'ua oje'ega Jejui 'ga upe: —Juã Batista 'ga remiayuwamũ ore orojemi'ware'ema futat oroje'ega monou Jarejuwarete 'ga upe jepi. Fariseu 'gã nemiayuwa 'gã nanẽ ojemi'ware'ema futat oje'ega 'ga upe jepi nũ. 'Ga upe oporogytaawa upe iwaẽmauwe ore orojemi'ware'ema Jarejuwarete 'ga upe oroporogytau jepi. A'ere 'ã eneremiayuwa 'gã nanarũi. Niojeri agawewi 'gã 'ã ojemi'war awi. A'etea 'ã 'gã oje'ega omono Jarejuwarete 'ga upe— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A'eramũ Jejui 'ga 'jau 'gã nupe: —Akokatu ma'e 'gã nekokaturamũ sipo 'gã nekokatu resakara 'gã ty'ara rerajemogyi maraka are? Naani. Maraka teepaw ire tãmẽjẽ te 'gã py'arayparamũ nũ— 'jau Jejui 'ga 'gã nupe. —'Gã nui akokatu ma'e 'gã jepe'aramũ tee esakara 'gã poiri ojemi'war awi oporogytau Jarejuwarete 'ga upe— 'jau Jejui 'ga oje'ega 'gã nupe u'ama. —Nan tee futat jeremiayuwa 'gã wojere'emamũ ojemi'war awi ojepyri je rekoramũ. Ojewi je o re te nipo 'gã nojemi'wari ajemogyau. Je o re te nipo 'gã 'arasigamũ ajemogyau je ree. A'eramũ te nipo 'gã nojemi'wari ajemogyau wea'aramũ etee je ree— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Ymã te 'ã aeypy 'gã pẽ mu'ei mama'e are rakue. A'ere je 'ã 'awamũ pẽ mu'ei nũ. Amutee are je 'awamũ pẽ mu'ei nũ. A'ere nepemojopypea'uweri jeporogyta aeypy 'gã nemimome'ufer are. Jeporogyta are ojemu'e ma'eramũ ki a'ea etee futat pejemu'e. Pemojopype kasi morogyta ymaner are ne. Morogyta ymaner are ojemu'e ma'e 'gã nuapoi jeporogytau mama'ea— 'jau Jejui 'ga 'gã nupe. —Naperugi ae taity ymanera taity yau pyu. Kasi a'e pe taity yau opoejamũ erojefuapygi etee ne. A'eramũ futat taity ymanera otoroka etee nũ— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","—Y'way yau ae nueko'wogi yrũ ymanera pype. Yrũ yau pype te ae eko'wogi. Yrũ ymana pype sieko'wok 'eramũ ajaiwayramũ erujewi. A'eramũ futat opy'apefugamũ wajaiwamũ yrũ pype. A'eramũ futat wyrũ kakau. A'eramũ ojeko'woka— 'jau 'ga 'gã nupe. —Yrũ yau pype eko'wog ire ojeko'woke'ema. Yrũa kawe'em nanẽ nũ— 'jau Jejui 'ga 'gã nupe 'gã mu'jau ee. —Nan tee futat nepemojopypea'uweri jeporogytafera morogyta ymaner are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","'Ga porogyta 'ga renamũ kũima'e 'ga amũ 'ua owaẽma Jejui 'ga upe. Judeu 'gã 'wyria'ri 'ga amũ 'ua wapyka wenupy'ãu 'ga rowase. A'eramũ 'ga 'jau 'ga upe: —Jera'jyr ẽẽ amanũ 'awamue futat ko. A'eramũ ene ejua ẽẽ resaka. Epoa ẽẽ 'arimũ imonoramũ nipo ẽẽ ferawi nũ— 'jau 'ga 'ua 'ga upe. —Ere ajee iruukwe. Taesak ẽẽ enee 'jau— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A'eramũ Jejui 'ga afu'ama awau 'ga rupi. 'Ga remimu'eramũ ore nanẽ arawau 'gã nupi nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Orewaw ipe kũjã ẽẽ mũ 'ua Jejui 'ga rupisika, 'ga raity pypireme'ywa pyyka. Ojero'wu ma'e ẽẽ. Tusi kwara ẽẽ imu'aa akou ojero'wau. Nuogi futari ẽẽ ry ẽẽ wi. Ymã te ẽẽ rekoi rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A'eramũ ẽẽ 'jau ojeupe etee futat: “Kĩã raity pyygamũ tajekatu'ok 'jau kwy”, 'jau ẽẽ ojeupe etee futat. A'eramũ ẽẽ 'ua 'ga raity pypireme'ywa etee agawewi ipyyka. A'etea ẽẽ ojekatu'ok 'ga raity pypireme'ywa pyyg ypyrauwe futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A'erauwe Jejui 'ga ojerowaka amã'jãu ẽẽ ree. A'eramũ 'ga 'jau ẽẽ upe: —Erekyje awi kari. Je rerowiar ape ekou ra'e jepi. A'eramũ je ene katu'oka akiko— 'jau 'ga ẽẽ upe. Ẽẽ upe aipo 'ga 'erauwe ẽẽ ojekatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","A'ere Jejui 'ga ore reruatau nũ. “Jera'jyra ẽẽ ree epoa emono” 'jara 'ga 'wyra upe orowaẽm ire orosou. Orosouwe Jejui 'ga ẽẽ ree ajatyka ma'e 'gã nesaka. 'Ga mo'wyarera 'ga ra'jyra ẽẽ rapirũmũ ẽẽ rerekou. Jumi'ara'nĩ moje'egara 'gã nanẽ 'ga esaka nũ Kwaiwete 'gã 'upa 'oga pype. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pe'je peje'jãu pejewau ukupepe. Namanũi ẽẽ. Oset tee ẽẽ 'upa. Peesag iki je ẽẽ momaga— 'jau 'ga 'gã nupe. Aipo ojeupe 'ga 'eramũ 'gã 'ga rerekoemãu etee. —Ene'me awi nũ'ũ. Amanũ futat akiko— 'jau 'gã 'ga upe. “Amoferap nipo je ẽẽ re'ã”, 'jau 'ga ojeupe. A'eramũ 'ga poromũ 'jau 'gã nupe, “oset tee ẽẽ 'upa”, 'jau etee 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","'Og awi 'gã mũ'ẽ re 'ga amanũ ma'efera ẽẽ popyyka. —Ere ejua ewya, ky'ri— 'jau Jejui 'ga ẽẽ upe. A'erauwe ẽẽ ferawi owya afu'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A'eramũ 'gã ẽẽ moferapawera mome'wau imuãina ojepyriwara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ẽẽ moferaw ire Jejui 'ga awau pe awi nũ. 'Ga remimu'eramũ ore arawau 'ga rupi. Orewaw ipe mukũja eae'ema 'gã 'ua ore rewiri wafukaita Jejui 'ga upe: —Jejui! Ene 'ã Janeruwarete 'ga remimurera! Ore resag ape. Epãjẽ mũ ore katu'og ape— 'jau 'gã wafukaita 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","'Og ipe ore se re, 'gã nanẽ awau osou nũ, Jejui 'ga rerowyka. A'eramũ Jejui 'ga 'jau 'gã nupe: —Je rerowiat te pejepe pejejemogyau jepi? “Ore mamã'ẽ 'ga nũ” 'ea te perowiat pejejemogyau?— 'jau 'ga 'gã nupe. —Aruerowiat futat ore ene— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","A'eramũ Jejui 'ga opo monou 'gã nea are. —Tejerowiat pejemogyramũ je pẽ mamã'ẽi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","A'erauwe futat 'gã amã'jãu. A'eramũ Jejui 'ga 'jau 'gã nupe: —Je mome'u kasi pejepe kwe pewara 'gã nupe kamẽsĩete ne, jerera muãje'ema kamẽsĩete amunawa pype ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","A'ere 'gã naani. Nuereko katui 'gã 'ga 'eawera, 'ga rera muãina kamẽsĩete peuwara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jejui 'ga wi 'gã o ypyrauwe 'gã amũ mama'eukwaawa rerekwara 'ga rerua Jejui 'ga upe. —Mama'eukwaawa mũ 'upa 'ga pir are. A'eramũ 'ga oje'ege'ema akou. Mama'eukwaawa 'ga nomoje'egukari imogou— 'jau 'gã Jejui 'ga upe. A'erauwe Jejui 'ga imoia 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ojewi Jejui 'ga imoir ire 'ga oje'ega nũ. A'eramũ 'ga resakara 'gã oporesagamũ 'ga ree ajemogyau. —Niesagi pa jane nanuara Israeu juapyreramũ jareywy pe jepi nũ— 'jau 'gã ajaupe, oporesagamũ 'ga ree ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A'ere fariseu 'gã nuerowiari 'ga. A'eramũ 'gã 'jau: —Naani nũ'ũ. Mama'eukwaawa 'wyriara je'eg imũ tee 'ga 'ga pirewara moiri 'ga wi nũ'ũ— 'jau futatee 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pe awi Jejui 'ga awau nũ. Awau 'ga amunawa moymoyka akou. 'Ga remimu'eramũ ore arakou 'ga retee te futat. Judeu 'gã jatykaaw ipe 'ga awau 'gã mu'jau 'Uwarete 'ga ree: —Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga pẽtywera moiri pẽ nui. A'eramũ 'ga pẽ mogyau wemiayuwamũ— 'jau 'ga 'gã nupe akou, 'gã mu'jau 'Uwarete 'ga ree. Ojero'wu ma'e 'gã 'ga ikatu'oka akou. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kwaiwete 'gã jatykai 'ga ree, 'ga porogyta renupa. 'Gã nesakawe Jejui 'ga ajemuaẽma 'gã nee. “Karupa'mĩ jare'ema 'jawe 'gã jemogyi. Ojejukawe'emamũ nanẽ nũ. Worypawamũ 'gã ajemogyau. Nitywi futari 'gã poara 'ga amũ”, 'jau Jejui 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A'eramũ 'ga 'jau wemimu'eramũ oree: —Inãinãnĩ'ĩ etee Janeruwarete 'ga je'ega mome'wara 'gã jemogyi. A'ere 'ã kwaiwete je te 'gã jemogyi Janeruwarete 'ga kwaape'ema— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","—A'eramũ ki pẽẽ pejeje'ega monou Jarejuwarete 'ga upe aipo are: “Emonou'jau'jap ejemiayuwa 'gã emome'waramũ kwe pewara 'gã nupe”, pe'je ki 'ga upe aipo are— 'jau Jejui 'ga oree. —Sã'ã juowuurana. Omonookara ae mũ tywe'emamũ 'ã ototokapaw ekoete. Nan tee futat nipo 'gã 'ga je'ega ojeupe 'gã imome'ue'emamũ 'gã pawi etee mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jejui 'ga wemimu'eramũ ore majatykau ojee, tusiramũ ore majatykau ojee. Opãjẽa 'ga imua ore upe ore moporowykyawamũ. —Tepãjẽa je amono pẽ nupe amutee 'gã poaawamũ. Pe'je pejewau mama'eukwaawa moia erekwara 'gã nui. Ojero'wu ma'e 'gã nanẽ pẽẽ ikatu'oka nũ— 'jau 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","'Ga remimonoramũ orepytuna tusi. Simão, Andre, Tiago, Juã, Filipe, Patarumeu, Tome, Mateuramũ je, ajepeja Tiago, Tadeu, ajepeja Simão, Judas. Mĩmeramũ ore Jejui 'ga remimu'eramũ. Simão 'ga mukũi 'ga rera. Pedro 'ga rer irũa. Ajepeja Simão 'ga rera nanẽ mukũi nũ. Serote 'jau 'ga rer irũa. Andre 'ga Pedro 'ga rewirera 'ga. Tiago 'ga rewirera 'ga Juãnamũ. Sepeteuramũ Tiago 'ga ruwa 'ga Juã 'ga retee. Je Mateuramũ 'wyriara upe ka'aranũũ pyykareramũ. Ajepeja Tiago 'ga Aufeu 'ga ra'yra 'ga. Judas 'ga nanẽ mukũi 'ga rera nũ. Iskariote 'ga rer irũa. Kũima'e tywera 'gã nupe 'ga monoara 'ga poromũ. Mĩmeramũ ore Jejui 'ga remimonoramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Wemimu'eramũ Jejui 'ga 'jau oree: —Pe'je pejewau je mome'wau kwe pewara 'gã nupe. A'ere ki judeu 'gã nupe etee je mome'u pejepe. Judeue'ema 'gã nupe kasi je mome'u pejepe ne. Samari ywy pewara 'gã nupe nanẽ je mome'wawe'em nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israeu juapyrera 'gã nupe etee futat pejewau morogyta esage mome'wau. Sã'ã karupa'mĩ ka'jama ujar awi. Nan tee futat Israeu juapyrera 'gã jemogyi. Ymã te 'gã ypya Jarejuwarete 'ga je'ega renuwi rakue. A'eramũ 'gã 'ga kwaapa katu katu rakue— 'jau 'ga oree. —A'ere 'awauwara 'gã nokwaawi futari 'ga. 'Ga remifutara nanẽ 'gã ikwaape'ema nũ. A'eramũ 'gã ajemogyau karupa'mĩ ka'jama 'jawe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","—“Otywer awi opoit ma'e 'gã Janeruwarete 'ga omogy wemiayuwamũ. A'eramũ ki pẽẽ pejepoia pejetywer awi”, pe'je ki pejewau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ojero'wu ma'e 'gã pẽẽ ikatu'oka. Amanũ ma'e 'gã pẽẽ imoferapa. Ipito'om ma'e 'gã pẽẽ imokã'jãu. Mama'eukwaawa pẽẽ imoia mama'eukwaawa rerekwara 'gã nui— 'jau Jejui 'ga oree. —Tepãjẽa je amono pẽ nupe. A'ere naje mepyi pejepe tepãjẽa pejejeupe imono are. A'eramũ pẽẽ pejewau 'gã katu'oka ekoete te futat pejejemogyau. “Je mepy pejepe. Pejekatu'okawera pemepy jee”, 'jawe'em futat pẽẽ 'gã nupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","—Ka'aranũũa kasi peroo ne. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pejekaraemã nanẽ erawawe'em nũ. Pejejyrũ, pejepyapaap. Mĩmera miamũ kasi peroo ne. Pejepir arewara etee futar iki peroo. Ywyra nanẽ pẽẽ erawawe'em pejepo pe. Ojeupe peporogytaramũ 'gã pẽ mojemi'waa. Aipoa esage— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—'Gã 'wyrarete upe pejewaẽma pejewau pejeseawa rekaa. “Pe'je pejejua pejesea 'au ore pyri” 'jara 'gã noga pype etee futar iki pejup. Peo kasi kwe pe pejejemogyau ne. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Gã nog ipe pejewau ki “'Awamũ Janeruwarete 'ga nepẽ mu'arasigukari pẽ mogyau”, pe'je pejewau pejesou 'gã nupe. “Arafutar ore Jarejuwarete 'ga pẽ muekõẽãja pẽ mogya”, pe'je ki 'gã nupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","—“Pe'je pejejua pejepytau ore'wyr ipe” 'gã 'eramũ ki pe'je 'gã nupe: “A'jea futat. Janeruwarete 'ga aku'i muri pẽ nupe, pẽ mopy'ata'wau a'jea futat”, pe'je ki 'gã nupe— 'jau Jejui 'ga oree. —“Narafutari ore pẽpyta oroje'wyr ipe” 'gã 'eramũ pẽẽ 'jau 'gã nupe: “Janeruwarete 'ga aku'ia namura'uweri pẽ nupe”, pe'je ki 'gã nupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","—A'eramũ nipo pẽẽ pejewau majepeja 'gã amũ 'wyr ipe nũ. A'eramũ nipo 'gã 'jau: “Noreporenuwiweri ore Jarejuwarete 'ga je'eg are”, 'jau nipo 'gã pẽ nupe. A'eramũ ki pe'je 'gã nupe “Janeruwarete 'ga 'ã wemiayuwamũ pefutat numiamũ. A'ere 'ã nepefutari etee 'ga. A'eramũ nipo 'ga anure pẽ mu'arasiga pẽ mogyau”, pe'je ki 'gã nupe— 'jau Jejui 'ga oree u'ama. —A'eramũ pẽẽ 'gã 'wyrarete awi peje'jãu pejepyapaawa nupãnupãu ajuee, 'yja motototoka jui. “Janeruwarete 'ga pẽ katu'og are ifuewet numiamũ. A'ere 'ã nepefutari etee 'ga”, pe'je ki pejepyapaawa nupãu ajuee 'gã nupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","—A'jea futat je 'i. Anure, wowase pẽ majatykaaw ipe nipo Janeruwarete 'ga Sodom ipewarera 'gã nereko tyweretei Gomora pewarera 'gã netee. Sodom ipewarera 'gã ityweretei Janeruwarete 'ga upe, Gomora pewarera 'ga netee rakue. A'eramũ nipo 'ga 'gã nerekou tyweaete 'gã tywer are. A'ere “noreporenuwiweri ore Jarejuwarete 'ga je'eg are” 'jara 'gã Sodom ipewara 'gã tywera apyraawi. A'eramũ nipo 'ga taetu 'gã nerekou tyweaete etee te nũ Sodom ipewarera 'gã apyraapa— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Sã'ã kasurua tajau jarũ pyterimũ isea. A'eramũ 'ã tajaua iu'wau. Nan tee futat pẽẽ. Jarejuwarete 'ga kwaapare'ema 'gã pyterimũ pese. 'Gã amũ nipo amara'neramũ akou pẽ nee. A'ere ki pẽ'akwaap pejejemogyau 'gã nupe. Pejepota'waramũ etee futar iki 'gã nee— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","—Pejea'gu te ki ajee pejejerowiare'ema 'gã nui. 'Gã amũ nipo pẽ pyyka pẽ nerawau o'wyria'ri 'gã nowase pẽ moporogytaukaa o'wyriara upe. Judeu 'gã jatykaaw ipe nipo 'gã amũ pẽ pyyka pẽ nupãnupãu. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Je rerowiaaramũ pẽ nekoramũ nipo 'gã pẽ pyygi pẽ nerawau judeue'ema 'gã 'wyriara 'gã nowase. O'wyriararete 'gã nowase pejejerooramũ pẽẽ je ree morogyta esage mome'wau 'gã nupe. A'eramũ futat nipo o'wyriara 'gã nowase pẽ nerawarera 'gã morogyta esagea pẽẽ imome'u renuwi o'wyriara 'gã neewe futat— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","—A'ere kasi pekyje pejejerooramũ ne. “Ma'ja 'jau sipo je teje'ega 'gã nupe 'wei”, pe'je kasi ne, pejekyjau ne. Janeruwarete 'ga te peje'egawa amut pẽ nupe peu pẽ nerooramũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","—Napẽẽ tee rũi peporogyta 'gã nupe. Pẽnuwarete 'ga 'Agesagea te nipo pẽ mueapyo pẽ'eaw are— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Je rerowiare'ema 'gã nipo wewirera 'ga miamũ futat omono 'gã nupe, ijukaukaa, wewirera 'ga je rerowiar ire. Wa'yra 'gã miamũ nipo 'gã imonou 'gã nupe iapisaukaa. 'Uwa miamũ, oya miamũ 'jau nipo 'gã imonou iapisaukaa 'gã nupe je rerowiaaramũ 'gã jemogyramũ— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","—Je rerowiare'ema 'gã oporomutare'emamũ je ree. A'eramũ nipo 'gã je rerowiaramũ pẽ nee nanẽ oporomutare'emamũ nũ. A'ere Janeruwarete 'ga je rerowiar awi ipoire'ema 'gã nerooi imogyau ojepyri nakwaparimũ ete rũi futat— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","—Amunaw ipewara 'gã pejejereko tyweramũ, pejeka'jama pejewau 'gã nui. Ajepeja amunaw ipe pejewau je mome'wau. Israeu ywy pypewara amunawa moyge'emauwe nipo je ruri tejewya nũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Ojemu'e yau ma'e 'gã amu'jara 'ga nuapyraawi futari. I'wyriat ma'e 'gã o'wyriara 'ga nanẽ nuapyraawi nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ojemu'e ma'e 'ga e'i ojeupe: “Tako temu'jara 'ga 'jawe 'jau kwy”, 'jau nipo 'ga ojeupe. Ma'eramũ 'ã je 'i pẽ nupe: Je rerowiare'ema 'gã je kurapara te ajemogyau. “Mama'eukwaawa 'wyriara je'eg imũ tee 'ga mama'eukwaawa moia 'gã nui”, 'jau futatee nipo 'gã jee je kurapa ajemogyau. A'eramũ nipo 'gã pẽẽ taetu je rerowiaramũ pẽ kurapa— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Pekyje awi 'gã nui. Nomima'uweri futari ae mama'ea. Anure te nipo imimipyrera jesaukari katu katu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","'Awamũ je je'egi pẽ nupe etee futat. A'ere tepeo jeje'ega mome'wau 'gã nupe najuejue etee futat 'jau— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","—Pekyje awi pejejee ifuewet ma'e 'gã nui. Pẽ apisi 'gã numiamũ. A'ere 'gã pẽ'aga nomateepawa'uweri. Jarejuwarete 'ga wi te a'jea futat pekyje ete. 'Ga te a'jea futat pẽ mateepap ywawuje futat werowiare'emamũ. Pẽ'aga we futat 'ga imonou mama'eukwaawa rapyaw ipe— 'jau 'ga oree. —'Ga te a'jea futat mama'e tywera ojeupe iapoaramũ ae apisi— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","—Janeruwarete 'ga te 'ã pãjẽretea. A'ere 'ga jejuka esagei futari ae ree. Peesak wyra'ia. Wyra'ia 'ã niapoi agawewi. A'etea Janeruwarete 'ga imanũnamũ wesak 'ũina. 'Ga remifutarimũ etee te wyra'ia imanũi. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ae taetu aje 'ã ae ate 'ga upe. Ma'eramũ 'ã 'ga jejukai ae ree taetu— 'jau 'ga imome'wau oree 'ũina. —Pẽ'awa we futat ojemojopyrũmap ajemogyau pẽakag are. Aeakag are ijemogya we futat 'ga okwaapap. “Nojejukai nipo 'ga ore ree?” pe'je kasi ne. Naani. Ojejuka futat 'ga pẽ nee. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","A'eramũ ki pẽẽ pejekyjawe'em pejejereko tyweara 'gã nui— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Pejenosĩ kasi je mome'wau 'gã nupe ne— 'jau 'ga 'gã nupe. —'Gã nowase pẽẽ je mome'u renosĩe'em ire je nanẽ najenosĩ pẽ mome'wau nũ. “Je Jejui 'ga remiayuwamũ je” pẽẽ 'eramũ je ywag ipe peoramũ je nanẽ futat ywagipewara 'gã nowase a'e 'gã nupe nũ: “Koromũ noko jeremiayuwa 'gã 'ja”, 'jau nipo je pẽ nupe ywag ipe peoramũ, ywagipewara 'gã nowase pẽ mome'wau enosõue'em 'gã nupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","—“Je naJejui 'ga remiayuwa rũi” 'jaramũ je ywag ipe peoramũ pẽẽ 'jawerimũ etee futat nipo je pẽ nenosõu pẽ mome'wau Tejuwarete 'ga rowase: “Najeremiayuwa 'ga rũi noko 'agamũ”, 'jau nipo je pẽ nupe pẽ mome'wau 'ga rowase. A'eramũ je aipo 'jarera 'gã monou muku tejewi— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—“Jarejuwarete 'ga remimurera 'ga rur ire nipo ore jamuepawi”, pe'je kasi ne. Naani. Je ree taetu nipo pejamue pejejemogyau— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","—Kũima'e 'ga amũ nipo je rerowiaa. A'ere nipo 'ga ra'yra naje rerowiari. A'eramũ nipo 'gã ajamueu je ree. Kũjã ẽẽ mũ nipo je rerowiaa. A'ere nipo ẽẽ ra'yra ẽẽ naje rerowiari. Ẽẽ ra'ytatya nanẽ nipo je rerowiare'ema nũ. A'eramũ nipo aipo 'gã je rerowiaara ẽẽ mueu je ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Amumẽ je rerowiaara 'gã pytuna 'gã we futat nipo 'gã nerekou tyweaete je ree. Je rerowiaara 'gã nereko tyweara 'gã 'gã pytuna futat— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Pẽporomutat 'ã pẽẽ pejepytuna 'gã nee. A'eramũ pẽẽ mama'e apou 'gã maku'iu. A'ere je 'i 'awamũ pẽ nupe: Jeremiayuwamũ pejejekoweramũ ki pẽporomutat je ree, pejepytuna 'gã nee pejeporomutara apyraapa. Pejejuw are, pejey are, pejeja'yr are. Mĩmera 'gã nee pejeporomutara apyraapa. Je ree pejeporomutaramũ ki mama'e apou jeremifutar imũ etee je muorypawamũ. “Ereapo awi nanuara ki sa”, 'jau nipo pẽpytuna 'gã pẽ nupe. A'ere kasi eremojerowiat 'gã ne. Jeje'eg imũ etee futat pẽẽ iapou. Kasi a'e pe pẽẽ najeremiayuwa rũi ne— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","—Anure nipo 'gã pẽ nereko tyweretei je ree, pẽ apisau je ree. A'eramũ futat nipo pẽẽ mũ je rerowiar awi pejepoia. A'ere pẽẽ je rerowiar awi opoit ma'eramũ najeremiayuwa rũi pejemogy. Jeremiayuwamũ pejejekoweramũ jeremifutara etee futat pẽẽ iapou, pejekyjawe'em 'gã pejejereko tywer awi. “Tene 'gã je jukai kwy. Napoira'uweri je Jejui 'ga rerowiar awi”, 'jau etee ki pẽẽ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","—“Najemanũweri je Jejui 'ga mome'u are” 'jara 'gã nooa'uweri futari ywag ipe Jarejuwarete 'ga pyri. “Je naapoa'uweri futari mama'ea Jejui 'ga remifutar imũ” 'jara nanẽ awawe'em ywag ipe Jarejuwarete 'ga pyri nũ— 'jau Jejui 'ga oree. —A'ere “tene 'gã je jukai kwy. Napoira'uweri je 'ga rerowiar awi” 'jara 'gã oi futari ywag ipe, Jarejuwarete 'ga pyri— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—“Pe'je pejewau je mome'wau kwe pewara 'gã nupe”, a'e ako je pẽ nupe ko. A'jea futat je 'i: Je rerowiaramũ pẽ nereko esageara 'gã je nanẽ je rereko esage nũ. Je rereko esageara 'gã je muarera 'ga nanẽ wereko esage nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ojeupe 'ga amũ waẽmamũ nipo 'gã 'jau: “Janeruwarete 'ga 'ga mut janee, ojee jane mu'jawamũ. Ma'eramũ 'ã oreporenuwiweramũ 'ga je'eg are”, 'jau nipo 'gã. “Torojejuka esage 'ga ree nanẽ 'jau nũ”, 'jau nipo 'gã. A'jea futat je 'i: Anure nipo Janeruwarete 'ga oje'eg are moromu'jarera 'gã mepyi. 'Ga ree ojejuka esage ma'e 'gã nanẽ 'ga omepy nũ, moromu'jarera 'ga repy 'jawe etee futat. Ojeupe 'ga amũ waẽm ire nipo 'gã amũ 'jau: “Koromũ esage ma'e 'ga. Ma'eramũ 'ã ore jejuka esagei 'ga ree”, 'jau nipo 'gã. A'jea futat je 'i: Anure nipo Janeruwarete 'ga esage ma'e 'gã mepyi. A'eramũ 'ga esage ma'e 'gã nee ojejuka esage ma'e 'gã nanẽ imepyau nũ, esage ma'e 'gã nepy 'jawe etee futat nũ— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","—A'jea futat je 'i: Anure nipo Janeruwarete 'ga je rerowiaara 'gã nereko esageara 'gã mepyi. 'Yro'ysaga etee agawewi nipo 'gã imonou je rerowiaara 'ga amũ upe, i'yuwei ma'eramũ. A'etea Janeruwarete 'ga 'yro'ysaga monoara 'gã mepyau 'ga upe imonoawer are— 'jau 'ga oree, kwe pe omome'wawamũ 'ga ore monoi. A'eramũ ore arawau kwe pe 'ga mome'wau oropytuna judeu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ojewi 'ga remimu'e 'gã orauwe Jejui 'ga awau ipyriu'iwara 'gã mu'jau 'Uwarete 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A'e pype Juã Batista 'ga remiayuwa 'gã amũ 'ua owaẽma Jejui 'ga upe. Juã Batista 'ga remiayuwa 'gã Jejui 'ga remiapofera mome'wau 'ga upe moromunepawa pype 'ga renaw ipe rakue. A'eramũ Juã 'ga 'gã amũ monou 'gã moporonuwukaa ee Jejui 'ga upe: —“Ene te Jarejuwarete 'ga remimurera? 'Ga amũ te ra'u nũ?” pe'je ki pejewau 'ga upe jee— 'jau 'ga wemiayuwa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","A'eramũ 'gã awau oporonupa ee Jejui 'ga upe: —“Ene te Jarejuwarete 'ga remimurera? 'Ga amũ te ra'u nũ?” e'i Juã 'ga enee ko— 'jau 'gã awau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pe'je pejewau pejejemiesagera mome'wau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Eae'ema 'gã 'ga amamã'ẽ akou. Iteu ma'e 'gã 'ga amafu'am. Ipito'om ma'e 'gã 'ga imokã'jãu. Iapyae'ema 'gã 'ga imuapyau. Amanũ ma'e 'gã 'ga imoferapa. Iporiay'i ma'e 'gã nupe 'ga morogyta esage mome'wau akou” pe'je ki, jeremiapofera mome'wau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“Je rerowiar awi ipoire'ema 'gã niku'ipawi futari ajemogyau”, e'i 'ga enee ko, pe'je ki 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ojewi Juã 'ga remiayuwa 'gã o ypyrauwe Jejui 'ga oporonupa Juã 'ga rekwawer are ojepyriwara 'gã nupe. —Amunawe'em ipe pejewau te maran peesak 'ga rai'i? Ma'ja 'jawe te 'ga rai'i? Sã'ã juowa ywytua erojetyjetyga erekoa. Nan te 'ga rekoi rai'i? Naani te ra'u nũ?— 'jau 'ga 'gã nupe. —Nanarũi futat 'ga rekoi— 'jau 'ga 'gã nupe. —Najuejue etee futat 'ga rekoi oje'egawer imũ etee futat 'ga oje'ega 'gã nupe ai'i, wesakara 'gã nupe ai'i. “Pejetywer awi pẽpoiriweramũ Ku'jywa 'ga imoiri pẽ nui”, 'jau pãwẽ pãwẽ etee futat 'ga akou 'gã nupe. Kũima'eeteete 'gã nupe, akotee ma'e 'gã nupe 'jau 'ga akou 'ga mome'wau 'gã nupe ai'i— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","—Taity esagea sipo 'ga wereko eruatau pẽnemiesagamũ rai'i? Naani. Taity esage ma'e 'gã ako 'og esage pype etee. A'ere Juã 'ga nanarũi. Taity ekoetea etee futat 'ga wereko imunepa. Nu'ari futari 'ga taity esage rerekwar ipe. Ikaraemã kwai ma'e 'gã 'ã waity esage etee te wereko imunepa. A'ere Juã 'ga nanarũi— 'jau Jejui 'ga u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","—Juã 'ga 'ã Jarejuwarete 'ga mome'wararete ako rai'i. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari Juã 'ga ree inuga rakue. “Koromũ jeje'ega mome'wara 'ga”, 'jau 'ga 'ã ikwasiarukaa inuga 'gã nupe rakue— 'jau Jejui 'ga imome'wau 'gã nupe. —“Tomono 'ga ene renunewe 'jau, kwe pewara 'gã mu'jau ene ree 'jau, ene rura futarukaa 'gã nupe 'jau”, 'jau 'ga inuga ikwasiaa ka'aran are rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Aeypy 'gã porogytafera wesageramũ agawewi. A'ere Juã 'ga porogytafera te 'gã porogytafera resage apyraawi Jarejuwarete 'ga upe. A'ere 'awamũ je rerowiaara 'gã te Juã 'ga porogytafera apyraawi. Imu'epyre'ema 'gã agawewi 'ã. A'etea 'gã 'ga ma'e apyraapa Jarejuwarete 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","—Juã 'ga ra'ne 'ã 'gã mu'jau Jarejuwarete 'ga ree rakue. “Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga pẽtywera moiri pẽ nui, pẽ mogyau wemiayuwamũ”, 'jau 'ã Juã 'ga 'gã nupe rakue. 'Awamũ 'ã je nanẽ aipo 'jau pẽ nupe nũ— 'jau Jejui 'ga 'ũina 'gã nupe. —A'eramũ kwaiwete itywet ma'e 'gã oreje'ega rerowiaa. 'Gã ku'ia 'gã nerekou. “Arowiat je 'gã je'ega. A'eramũ Janeruwarete 'ga jetywera moia je wi, je mogou wemiayuwamũ. Tene 'ga rerowiare'ema 'gã je rereko tyweretei kwy. Napoiri futari je 'ga rerowiar awi”, 'jau nipo 'gã aku'iramũ ajemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","—Ymã we te 'ã Janeruwarete 'ga je'ega mome'warera 'gã Moisesi 'ga retee imome'ui pẽ nupe rakue. “Anure nipo Janeruwarete 'ga wemimurama 'ga muri, 'ga mogou 'wyriaramũ ae upe. Otywer awi opoit ma'e 'gã nipo 'ga imogyau wemiayuwamũ”, 'jau 'gã nakue. Juã 'ga nanẽ Janeruwarete 'ga remimureramũ je mome'wau pẽ nupe rai'i nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ymã te Janeruwarete 'ga je'ega mome'wara 'gã amũ 'i rakue: “Anure nipo Eliasi 'ga 'jawewaramũ ra'ne ijesaukari pẽ nupe. 'Ga rewiri etee nipo ajee Janeruwarete 'ga remimura 'ga jesaukari”, 'jau 'gã ikwasiaa ee rakue. A'eramũ je ee iparuerowiariwet ma'eramũ pẽ mueapyou 'gã je'eg are. Juã 'ga futat Eliasi 'ga 'jawewara. A'eramũ 'ga 'ua Jarejuwarete 'ga remimuramamũ je renune ai'i. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ee pejejeapyoweramũ ki peapyaka katu jeje'eg are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","—Ma'ja 'jawe te 'awauwaramũ pẽẽ?— 'jau 'ga 'gã nupe. —Kunumĩarũe'ema 'jawe futat pẽẽ. Sã'ã kunumĩa. “Soo jarejerokyau 'jau” 'eramũ, “Naani. Najeataweretei je”, 'jau etee 'ã ajaupe. “Pe'je ajee sajeawotee 'ũ”, 'jau 'ã kunumĩa ajaupe nũ. “Najejeawoteeweri futari je”, a'e ako je ko, 'jau ete 'ã kunumĩa ajaupe. Nan tee futat pẽẽ. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juã Batista 'ga 'ã ojemi'ware'ema akou Jarejuwarete 'ga upe oporogytau rakue. A'eramũ 'ã pẽẽ “mama'eukwaawa 'ga wereko opir are ra'e”, 'jau 'ã pẽẽ 'ga upe, 'ga jemi'ware'emamũ rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","—A'ere 'ã je ruri Juã 'ga rewiri nũ. Je 'ã tekou teojere'emamũ tejemi'waa Jarejuwarete 'ga upe teporogytau. A'eramũ 'ã pẽẽ “Emi'uu 'ã 'ga ra'e”, 'jau etee jee nũ— 'jau 'ga 'gã nupe. —“Itywet ma'e 'gã jekoty'aawa 'ga ra'e, 'wyriararete upe ka'aranũũ pyykara 'gã jekoty'aawa 'ga ra'e”, 'jau etee 'ã pẽẽ jee nũ— 'jau 'ga 'gã nupe. —Kunumĩ 'jawe pẽẽ. Juã 'ga ree ra'ne 'ã pẽẽ pejeporomutare'emamũ rai'i. 'Awamũ 'ã pẽẽ je ree nanẽ pejeporomutare'emamũ nũ— 'jau Jejui 'ga 'gã nupe. —Kunumĩ 'jawe 'ã pejemogy. Jarejuwarete 'ga je'eg imũ mama'ea jane iaporamũ nipo jane pyriwara 'gã 'i janee: “A'jea futat. Janeruwarete 'ga 'ã i'akwaap. Sã'ã 'ga remiayuwa 'gã neko esagea”, 'jau nipo 'gã janee, janereko esage resag ire— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A'eramũ Jejui 'ga oje'ega moywyrafena wemiapofera resakara 'gã nupe. 'Gã 'wyr ipe agawewi Jejui 'ga aeremiapoe'ema apou 'gã nowase. A'etea 'gã nopoiri futari otywer awi. A'eramũ Jejui 'ga oje'ega moywyrafena 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—A'e je ki 'ei. Naje moporomutarukari te 'ã pejepe a'i kũi. Pẽporiay'i 'ã pejejemogyau numiamũ a'i kũi. Korasĩ pewaramũ, Pesaita pewaramũ. Mĩmer ipewaramũ 'ã pẽporiay'i pejejemogyau numiamũ. Pẽ'wyr ipe ako je Jarejuwarete 'ga mome'ui tekou pẽ nupe ikue numiamũ. Ojero'wu ma'e 'gã katu'oka ako tekou pẽ neape ikue numiamũ. A'ere ako nepẽporenuwiweri jeje'eg are ikue. Nepẽpoiriweri ako pejetywer awi ikue. Pejetywera retee ako pẽẽ ikue. Tiro pe 'gã katu'og ire amunipo 'ã peuwara 'gã poiri otywer awi rakue. Sidom ipe. Mĩmer imũ 'gã katu'og ire amunipo 'ã peuwara 'gã poiri futari otywer awi rakue. Tanimuga amunipo 'ã 'gã wereko wapyte'rarimũ otywer awi opoira resaukaawamũ. A'ere ako je 'au agawewi iapoi tekou pẽ'wyr ipe ikue. A'etea ako nepepoiri pejetywer awi ikue— 'jau Jejui 'ga 'gã nupe, wemiapofera resakarera 'gã pyu oje'ega magwamagwapa. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","—A'eramũ nipo Janeruwarete 'ga pẽ majatykaawa 'ara rupi Tiro pewara 'gã majatykau wowase. A'eramũ nipo 'ga 'gã nerekou tyweaete. Sidom ipewarera 'gã nanẽ nipo 'ga erekou tyweaete nũ. 'Gã tywer are wejue nipo 'ga 'gã nerekou tyweaete etee. A'ere nipo 'ga pẽẽ te pẽ nereko tyweretei kwaiwete. Pẽẽ te 'ã neperowiari 'ga, 'ga pãjẽ resakareramũ miamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","—Pẽporiay'i pejejemogyau numiamũ, a'e je 'ã pẽ nupe, Kafanaũ pewaramũ nanẽ nũ. “Ore Kafanaũ pewaramũ oreresage”, pe'je numiamũ. “A'eramũ ore arawau ywag ipe”, pe'je pejejaupe numiamũ. A'ere je 'i pẽ nupe: Mama'eukwaawa rapyaw ipe oo ma'eramũ futat pẽẽ, a'e je 'ã pẽ nupe— 'jau Jejui 'ga Kafanaũ pewarera 'gã nupe. —Nepepoiri te 'ã pejetywer awi. A'eramũ pẽẽ pejewau mama'eukwaawa rapyaw ipe futat— 'jau Jejui 'ga 'gã nupe. —Pẽ neape futat je ako pẽnemiapoe'ema apou tekou ai'i. A'ere ako nepẽpoiriweri pejetywer awi ikue. Sodom ipe iapo re amunipo 'ã peuwara 'gã poiri otywer awi rakue. A'eramũ amunipo 'ã 'gã 'wyra ateepawe'emamũ futat rakue. 'Upa we futat amunipo 'ã 'gã 'wyra 'awamũ miamũ futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","—Wowase pẽ majatykaaw ipe nipo Janeruwarete 'ga pẽ nereko tyweretei te futat kwaiwete Sodom ipewarera 'gã nereko tywera apyraapa— 'jau 'ga oje'ega moywyrafena Kafanaũ pewara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A'ere Jejui 'ga 'jau 'Uwarete 'ga upe: —Kiapi'ni. Ene 'ã mama'e jararetea. Ene 'ã ywag ipewara mama'e jara. Ywy pewara jara nanẽ 'ã ene nũ. Ene te 'ã mama'e jararetea. Nai'akwaap ma'e 'gã etee rũi 'ã eremueapyo jeje'eg are. Akotee ma'e 'gã na'ne 'ã eremueapyo ee nũ. I'akwaap ma'e 'gã jẽmĩ 'ã ene imueapyowe'em ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ejemifutar imũ etee futat 'ã ene akotee ma'e 'gã mueapyo ee. Nanuara futat te 'ã erefutat rakue— 'jau 'ga oje'ega 'Uwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","A'eramũ 'ga 'jau ojepyriwara 'gã nupe nũ: —Jeruwarete 'ga je mu'akwaap mama'e are ikue. Ma'eramũ je 'ã ikwaawi— 'jau 'ga 'gã nupe imome'wau. —Jeruwarete 'ga je kwaap katu katu futat. Nitywi 'gã amũ je kwaaparamũ. Jeruwarete 'ga etee te je kwaap. Je 'ã Tejuwa 'ga akwaap katu katu futat. A'ere 'gã nitywi amũ je 'jawewara Jeruwa 'ga kwaapa katu katuara 'gã amũ— 'jau Jejui 'ga 'gã nupe. —Ma'eramũ je 'ã tejemipyyrũmera 'gã mu'ei Tejuwarete 'ga ree. A'eramũ 'gã a'eramũ 'ga kwaapa je pyri— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","A'eramũ Jejui 'ga 'jau ojepyriwara 'gã nupe nũ: —Pe'je pejejua jee jeje'ega renupawamũ je pyri. Tejerowiar ire je jejuka esagei pẽ nee. Pẽẽ mũ mama'e poyjuu rupiara 'jawe. Sã'ã ae mama'e poyjuu upiaramũ. Nan tee futat pẽfuakapawamũ. Pejepy'a'wyramũ pejejemogyau mama'e are. A'eramũ pẽẽ pejefuakapawamũ pejejemogyau. Tejerowiar ire je jejukai pẽ nee. A'eramũ nipo pejepy'a'wyre'emamũ mama'e are pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","—Pejemu'e je ree. Jeje'eg are nanẽ pejejemu'jau nũ. Je te 'ã ajemuaẽm pẽ nee. Jeporopoariwet je tekou pẽ nee. Je ree pejejemu'e re nipo pẽẽ pejepy'a'wyre'emamũ mama'e are pejejemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Naayi futari jeje'ega renuwa. Ay futat numiamũ. Je futat apoat pẽẽ mama'e apo are teje'eg imũ futat. A'eramũ aye'ema 'jawe akou pẽ nupe. Jeje'ega renuw ire nipo pẽẽ pejeku'iramũ pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Morowykye'ema mũ rupi Jejui 'ga awau juowuurana ko pyterimũ akou. 'Ga rewiri oo ma'e 'gã opy'arayparamũ ajemogyau. A'eramũ 'gã a'ỹja pa'wau erawau opo pe. A'eramũ 'gã ipe'oka i'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","'Gã nesakawe fariseu 'gã amũ 'jau Jejui 'ga upe: —Kuu. Emã'ẽ 'gã nee ki sa. Eneremiayuwa 'gã opo'o a'ỹja i'wau ra'e ki sa. “Noporowykya'uweri ae morowykye'ema rupi”, e'i nã'ã Moisesi 'ga jepi re'ã. Juowuuran a'ỹja po'oa aeporowykya futat. Ymã te 'ã Moisesi 'ga 'i rakue: “Peporowyky kasi morowykye'ema rupi ne”, 'jau 'ga 'ã rakue a'i kũi— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'ja te Davi 'ga wapo rakue? Nepemogytai nipo ka'arana 'ga remiapofer are? Ymã te 'ã 'ga py'arayparamũ opytuna 'gã netee akou rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A'eramũ 'ã 'ga awau Jarejuwarete 'ga mogytaaw ipe osou rakue. A'e pe 'ga 'ã kanape pyyka i'wau opytuna 'gã netee rakue. Pekwaap 'ã aipoa. Na'gã nemi'ua rũi poa numiamũ. Mainana 'gã etee te a'u aipoa rakue. A'etea Davi 'ga a'u opytuna 'gã netee rakue. Ipy'araypat 'gã awau osou peu. A'eramũ 'ga amũ “Nepẽa'wyri pẽẽ” 'jawe'em 'gã nupe rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","—Morowykye'ema rupi mainana nanẽ oporowykyau nũ. Nepemogytai nipo Moisesi 'ga remikwasiarera ka'arana mainana 'gã porowyky are ki sa? Morowykye'ema mũ magwamagwapa 'gã wyra rapyau Jarejuwarete 'ga upe. A'ere 'gã amũ “Iro peporowyky morowykye'ema rupi pejejupa” ne'i 'gã 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","—A'jea futat je 'i: Esage futat Janeruwarete 'ga mogytaawa. Esage futat 'ga mogytaawa pype 'gã nemiapofera— 'jau 'ga 'gã nupe. —A'ere 'awamũ je rekoi. A'eramũ jeje'ega renuwa wesageramũ futat 'ga mogytaawa pype 'gã nemiapofera apyraapa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","—Ymã Janeruwarete 'ga oje'ega kwasiarukari Oseja 'ga upe rakue: “Je upe mama'e mura esage futat jee. A'ere pejejuee pẽpota'wa esagea etee esageramũ jee. Nafutari je tejeupe pẽnemimurera, pejejuee pejepota'wa esage'em ire”, 'jau 'ga ikwasiarukaa rakue. Nepẽneapyoi nipo pẽẽ 'ga remikwasiarer are pejejemogyau ki sa. Ee pejejeapyo re amunipo 'ã “Nia'wyri pẽnemiapofera” nepe'jei 'gã nupe, a'ỹja po'wara 'gã nupe. Nuapoi futari 'gã mama'e tywera— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","—Je 'ã pẽneki'yraretea, Jarejuwarete 'ga remimurera. A'eramũ je 'jau pẽ nupe: “Je 'ã morowykye'ema jara”. A'eramũ je tee pẽ mu'jau morowykye'ema rupi pẽnemiapoe'em are— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","'Gã nupe oporogytapaw ire Jejui 'ga awau osou judeu 'gã jatykaaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A'e pe ipoteu ma'e 'ga wapyka 'ũina. A'eramũ Jejui 'ga ree iporomutare'ema 'gã 'jau ajaupe: —'Awamũ morowykye'ema. Maran sipo 'ga 'awamũ ipoteu ma'e 'ga rerekoi nũ?— 'jau 'gã ajaupe. —'Ga po katu'ogamũ ki sa'e 'ga upe: “Nuenuwi futari 'ga Moisesi 'ga porogytafera ra'e”, sa'e ki 'ga upe a'i kũi— 'jau 'gã 'upa ajaupe. A'eramũ 'gã 'jau Jejui 'ga upe: —Esageay te Moisesi 'ga remikwasiarer imũ ae katu'oga morowykye'ema rupi enee?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pejejeymawa ywy kwara pype i'aramũ sipo nepenuẽmi ywy kwar awi morowykye'ema rupi? Morowykye'ema rupi agawewi nipo i'ari ywy kwara pype pẽ nui. A'etea nipo penuẽm futat jui morowykye'ema rupi. Nepeejara'uweri ywy kwara pype imỹina— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","—Pẽ nupe pẽneymawa repyramũ futat. A'eramũ pẽẽ pejejejukau esage futat ee. Ae taetu ajee 'ã ae ate Jarejuwarete 'ga upe. A'eramũ 'ga ajemuaẽma iteu ma'e 'ga ree taetu pejejeymaw are pejemuaẽma apyraapa. Ma'eramũ sipo jane jarejopoare'ema morowykye'ema rupi? “Pejopoar iki”, e'i 'ã Janeruwarete 'ga ikwasiarukaa Moisesi 'ga upe rakue— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A'eramũ 'ga 'jau ipoteu ma'e 'ga upe: —Epo epopyo— 'jau 'ga 'ga upe. A'erauwe futat 'ga opo popywau. A'eramũ futat 'ga po ojekatu'oka 'ga po owajara 'jawe etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A'e resakawe fariseu 'gã awau ũ'jãu jui. Morowykye'ema rupi 'ga katu'ogamũ 'gã amara'neramũ Jejui 'ga ree. A'eramũ 'gã afuewereteteramũ 'ga ree. —Maran te jane Jejui 'ga rerekoi? Jemime te ra'u jane 'ga jukai nũ?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","“Fariseu 'gã ifuewerete te ene ree” 'e renupawe Jejui 'ga awau jui. Kwaiwete 'gã awau 'ga rupi. A'eramũ 'ga ojero'wu ma'e 'gã katu'okapap. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","'Gã katu'og ire 'ga 'jau 'gã nupe: —Je mome'u kasi pejepe 'gã nupe ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ymã te Janeruwarete 'ga oje'ega mome'wara 'ga upe ka'arana kwasiarukari Jejui 'ga ree rakue. A'eramũ Jejui 'ga mama'e apou Isai 'ga remikwasiarer imũ etee futat rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Koromũ je upe oporowyky ma'e 'ga, jeremipyyrũmera 'ga. Jeremifutararete 'ga. A'eramũ je teku'iramũ tekou 'ga ree. Te'agesagea je amono 'ga upe 'ga rerekwaramũ. A'eramũ nipo 'ga jepãjẽ mũ etee futat mama'e apou akou. Ywy pewara 'gã nupe nipo 'ga jeremiaporama mome'wau akou. ‘Otywer awi opoit ma'e 'gã nipo 'ga imogyau wemiayuwamũ’, 'jau 'ga 'gã nupe najuejue etee. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nimara'nei 'ga ae ree. A'eramũ 'ga oje'egayawe'em. Wafukaite'ema 'ga kwe pewara 'gã nupe. Ojee etee 'ga ojerowiaraipe'ema. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ajemuaẽm te 'ga ae ree. Ojero'wu ma'e 'gã nee 'ga opota'waramũ. Iku'ipap ma'e 'gã nee 'ga ojejukau esage. A'eramũ 'gã aku'iramũ ajemogyau nũ. Afuakaramũ 'ga 'gã nee. ‘Jeruwarete 'ga oje'ega pẽ nupe’, 'jau 'ga 'gã nupe, 'ga je'ega 'gã erowiare'emauwe. A'eramũ nipo 'gã 'ga je'ega rerowiaa ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'Ga ree nipo judeue'ema 'gã jemogypyygi. ‘Anure nipo 'ga jane katu'ogi Jarejuwarete 'ga upe’, 'jau nipo 'gã ajaupe”, 'jau Isai 'ga ikwasiaa Jejui 'ga ree rakue. A'eramũ Jejui 'ga mama'e apou 'ga remikwasiarer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Anure 'gã amũ mama'eukwaawa rerekwara 'ga rerua Jejui 'ga upe. 'Gã nemierurera 'ga noje'egi futari. Mama'eukwaawa 'ga moje'egukare'ema 'ga mogou. Mama'e resagukare'ema nanẽ 'ga upe nũ. A'eramũ 'gã 'ga rerua Jejui 'ga upe. A'erauwe Jejui 'ga 'ga katu'oka, mama'eukwaawa moia 'ga wi. A'erauwe ikatu'ogipyrera 'ga je'egi 'gã nupe. Mama'e resaka nanẽ 'ga akou nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A'e resakarera 'gã oporesagamũ ajemogyau Jejui 'ga ree. —Tỹỹ. Okatu'ok 'ga 'ga ra'e— 'jau 'gã ajaupe. —Janeruwarete 'ga remimurera 'ga te 'ũi? Janeremiapesagera 'ga te 'agamũ 'ũi?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","A'e renupawe fariseu 'gã 'jau 'gã nupe: —Mama'eukwaawa 'wyriara je'eg imũ te 'ga 'ga pirewara moiri 'ga wi— 'jau 'gã 'gã nupe. —Pesepu pãjẽ mũ etee 'ga imoiri 'ga wi— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","'Gã 'eawera kwaapawe Jejui 'ga 'jau 'gã nupe: —'Gã amũ nipo ojo'oka oywy pype ajamueu— 'jau 'ga 'gã nupe. —Maran sipo 'gã amũ a'eramũ ojo'oka oywy pype ajamueu. Ajaupi etee futat ajuapisaupap, ojomateepapa ajaupi etee futat— 'jau Jejui 'ga u'ama oporogytau 'gã nupe. —Maran sipo a'eramũ majepeja amunaw ipewara 'gã ojo'oka ajaupi tee futat ajuapisawamũ— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","—Nan iapo re amunipo 'ã mama'eukwaawa remiayuwa ijomateepawi ajaupi etee futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","—“Pesepu pãjẽ mũ 'ga mama'eukwaawa pe'ai 'gã nui”, pe'je ako jee ko. A'eramũ je 'jau pẽ nupe: Ma'ja pãjẽ mũ ajee pẽnemiayuwa 'gã mama'eukwaawa moiri 'gã nui jepi? NaJarejuwarete 'ga pãjẽ mũ rũi nipo 'gã imoiri 'gã nui jepi?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","—Je nanẽ futat 'ã Jarejuwarete 'ga pãjẽ mũ etee futat je amoit 'ga wi nũ. A'eramũ pẽẽ a'e are je kwaapa. “Janeruwarete 'ga remimurera 'ga futat ra'e, janeremiapesagera 'ga futat ra'e”, 'jau amunipo 'ã pẽẽ jee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Ose sipo muna'ywa ifuakat ma'e 'ga rog ipe, 'oga jara 'ga fare'emamũ? Naani. Nosei futari. Ifuakat ma'e 'ga far ire etee isei 'ga rog ipe, 'ga karaemã pojekau 'ga wi— 'jau Jejui 'ga 'gã nupe. —Mama'eukwaawa 'wyriara ifuakat ma'e 'jawe. Ipãjẽ futat numiamũ. A'ere Janeruwarete 'ga te pãjẽretea, mama'eukwaawa 'wyriara pãjẽ apyraap. Ma'eramũ 'ã ae Jarejuwarete 'ga pãjẽ mũ etee mama'eukwaawa moiri 'gã nui— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Je ree iporomutare'ema 'gã najeremiayuwa rũi— 'jau Jejui 'ga 'gã nupe. —Jeporowyky are je poare'ema 'gã nanẽ naje upe rũi oporowyky. Mama'eukwaawa upe te 'gã porowykyi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","—Ma'eramũ 'ã je 'i pẽ nupe: Janeruwarete 'ga pẽtywera omoit pẽ nui, jui pẽpoiriweramũ, je 'i pẽ nupe. A'ere 'ga nomoiri futari U'agesage kuraparamũ pẽtywera pẽ nui— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","—Pẽẽ mũ nipo je kurapa agawewi pejejemogyau. A'etea nipo Janeruwarete 'ga pẽtywera moiri pẽ nui, ojeupe peporogytaramũ. A'ere 'ga U'agesage kuraw ire pẽtywera nomoiri futari pẽ nui. Jarejuwarete 'ga 'Agesage pãjẽ mũ etee je mama'eukwaawa moiri 'ga wi. “Pesepu pãjẽ mũ te 'ga mama'eukwaawa moiri 'ga wi” 'jaramũ pẽẽ Jarejuwarete 'ga 'Agesage kuraparamũ. A'eramũ nipo Janeruwarete 'ga pẽtywera moire'ema pẽ nui. 'Awamũ miamũ 'ga namoiri futari pẽtywera pẽ nui. Anure nanẽ nipo 'ga imoire'ema U'agesage kuraparamũ pẽ nui nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Y'wa 'ywa 'jawe pẽẽ. Y'wa 'yp katurama i'a katuram tãmẽjẽ futat. Y'wa 'yw a'wyre'ema o'ywa 'jawe etee futat ni'aa'wyri. A'eramũ ki pẽẽ y'wa katurama resag ire 'jau jupe: “'Agamũ 'ywa katurama. Sã'ã i'a katurama tãmẽjẽ”, 'jau ki pẽẽ jupe. A'ere pẽẽ y'wa a'wyre'ema resag ire ki 'jau tãmẽjẽ jupe: “'Agamũ 'ywa a'wyre'ema. Sã'ã i'a a'wyre'ema”, 'jau tãmẽjẽ pẽẽ jupe esaka— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","—Esage ma'e 'jawe futat pejemogy numiamũ. A'ere pẽtywet futat pejejemogyau— 'jau 'ga 'gã nupe. —Maran sipo ajee nanuaramũ pejemogy esage ma'e 'jawe pejeje'ega? Naesage ma'e arũi futat pẽẽ. Esage ma'e 'gã ea'at mama'e esage are etee futat. A'eramũ 'gã mama'e esage are etee futat oporogytau. Ia'wyre'ema 'gã ea'at mama'e tywer are etee futat. A'eramũ mama'e tywer are etee futat 'gã oporogytau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","—Pẽẽ mũ nipo pejeje'ega ekoete pejejemogyau. A'eramũ je 'jau pẽ nupe: Anure wowase pẽ majatykaaw ipe nipo Janeruwarete 'ga 'i pẽ nupe: “Ma'eramũ te ereje'eg ekoete ekou rakue?” 'ga 'i pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pẽ'eawer imũ etee futat nipo Janeruwarete 'ga pẽ mepyau. Mama'e esage mome'wareramũ te nipo ajee Janeruwarete 'ga 'i pẽ nupe: “Eneresage jee”, 'jau nipo 'ga pẽ nupe. A'ere nipo 'ga mama'e tywer are tee nipo peporogyta pejejemogyau 'eramũ nipo 'ga 'i pẽ nupe: “Pẽtywet jee”, 'jau nipo 'ga pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'gã oje'ega 'ga upe, fariseu 'gã netee: —Oreremiapoe'ema eapo amũ oree. Taruesak 'jau— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A'eramũ Jejui 'ga 'jau 'gã nupe: —'Awauwaramũ miamũ 'ã nepẽa'wyri futari pejejemogyau 'ga upe. “Oreremiapoe'ema eapo amũ oree”, pe'je 'ã jee numiamũ. A'ere je naapoa'uweri mama'ea pẽ nupe pẽnemiesagamũ. Juna 'ga ree etee je pẽ muea'ari pẽ mogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","—Sã'ã ipira Juna 'ga mokona rakue. A'eramũ 'ga 'ã muapyt osea ipira reweg ipe rakue. Nan tee futat nipo pẽneki'yramũ je seri muapyr etee ywy pe, 'gã tejuka re— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Ymã te 'ã Juna 'ga rekoi Jarejuwarete 'ga je'ega mome'waramũ rakue. A'eramũ 'ã Janeruwarete 'ga 'ga monou ojemome'waukaa Ninewa pewara 'gã nupe rakue. “Kwe pe ekwap je mome'wau Ninewa pewara 'gã nupe”, 'jau 'ga 'ã 'ga upe rakue. Ipira amun ire te 'ã Juna 'ga awau Jarejuwarete 'ga mome'wau Ninewa pewara 'gã nupe rakue. Juna 'ga je'ega renupawe peuwara 'gã opoia otywer awi rakue. A'eramũ nipo 'gã 'jau pẽ nupe: “Norokwaawi futari ore Ku'jywa 'ga ikue. A'etea ore orojeupe Juna 'ga 'ga mome'u ypyrauwe oropoit orotywer awi ikue”, 'jau nipo 'gã pẽ nupe, Jarejuwarete 'ga rowase pẽ majatykaaw ipe— 'jau Jejui 'ga 'gã nupe. —Juna 'ga a'jea futat esage ma'ea rakue. A'ere 'ã je te esage ma'ea Juna 'ga apyraapa. A'etea 'ã naje rerowiari pejepe pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Janeruwarete 'ga rowase pẽ majatykaaw ipe nipo Sepa ywy pewara 'wyriara ẽẽ nanẽ nipo 'jau pẽ nupe: “NaKu'jywa kĩã remiayuwa rũi agawewi je ikue. A'etea je ojot muku awi Sarumãu kĩã je'ega renupa ikue. Sarumãu kĩã i'akwaawa agawewi kĩã ikue”, 'jau nipo ẽẽ pẽ nupe. A'eramũ je 'jau pẽ nupe: A'jea futat Sarumãu 'ga i'akwaap ma'ea rakue. A'ere 'ã je te i'akwaawete ma'ea je rekoi. Ma'eramũ gatu nipo 'ã naje rerowiari pejepe, a'e je 'ã pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Pẽ nui omoir ire nipo mama'eukwaawa ioi ywy akỹme'ema rupi opytaawa mũ rekaa akou. A'eramũ nipo opytaawa mũ resake'emawe 'jau ojeupe etee futat nũ: “Maran te 'ã nooi tejekwawer ipe etee futat tejewya nũ 'i?” 'jau nipo ojeupe. A'eramũ nipo ojewya 'ua werekwarera 'ga resaka. Erekwarera 'wyriar amuteeramũ nipo akowe'em ee. Ijekatu'oguu tuwamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","A'eramũ nipo opytuna majatykau awau. Sete nipo opytuna rerua. A'ea te nipo itywerete. A'eramũ te nipo erekwarera 'ga te'arareteramũ— 'jau Jejui 'ga 'gã nupe imome'wau. —Nan tee pẽẽ. Jeje'ega rerowiare'emamũ pẽtywet pejejemogyau jee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","'Ga porogyta pype Jejui 'ga y ẽẽ 'ua, 'ga rewirera 'gã netee. Ukupepewara 'gã nupe owaẽma. —Toroporogyta Jejui kĩã upe 'jau— 'jau ẽẽ 'gã amũ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","A'eramũ 'ga amũ 'jau Jejui 'ga upe: —Eney ẽẽ 'ut owaẽma enerewirera 'gã netee janee. “Toroporogyta kĩã upe 'jau”, e'i ẽẽ oree— 'jau 'ga Jejui 'ga upe. Aipo ojeupe 'eramũ Jejui 'ga 'jau 'ga upe: —A'jea— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A'eramũ Jejui 'ga 'jau ojepyriwara 'gã nupe: —Maranuaramũ te pẽẽ jey 'jawe jee? Maranuaramũ te pẽẽ jerewirera 'gã 'jawe jee?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A'eramũ 'ga wemimu'eramũ ore mome'wau 'gã nupe: —Koromũ jey ẽẽ 'jawewara 'gã, jerewirera 'gã 'jawewara 'gã— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","—Jeruwarete 'ga je'ega renuparamũ pẽẽ jepytunamũ pejemogy, jerewireramũ nanẽ pejemogy nũ. Kũjãmeramũ pẽẽ jerenyramũ pejejemogyau nũ, jeyramũ nanẽ pejejemogyau nũ. Jarejuwarete 'ga remifutar imũ mama'e apoaramũ jepytunamũ pejemogy jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aipo 'ara rupiwewe futat Jejui 'ga uẽma 'og awi awau wapyka ypia reme'y'warimũ. Ajatyka ma'e 'gã nupe oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A'eramũ kwaiwete 'gã 'ua ajatykau 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A'eramũ 'ga awau u'aa wapyka yaruu pype. A'eramũ 'ga yaruu pype u'ar ire 'gã oporogytau ojee ajatyka ma'e 'gã nupe, mama'e mũ mome'wau 'gã nupe, 'gã mu'jau 'Uwarete 'ga ree. 'Ga renupara 'gã 'upa 'yisiga pype. —Kũima'e 'ga amũ akou oko pe juowuuran a'ỹja momopoa. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A'eramũ a'ỹja mũ u'aa pe pe 'ga wi. A'ere 'ga imomopor ire wyra'i ruri i'wau etee 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Amumera u'aa ywy a'wyre'ema pype 'ga wi. Kwaiwete ita. A'eramũ 'yja otywe'emamũ jupe. 'Yi tywe'ria te. Jaruete futat opopoa numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","A'ere nooi apoa kwe pe. A'eramũ kwaraya imomỹijaga etee. Ita rakuwa ijukau etee. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Amumera a'ỹja u'aa juemy pype. A'eramũ jua imoteu etee 'ga wi. A'eramũ jawaiwa iapisau etee. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amumera a'ỹja te ajee u'at ywy katurama pype. A'eramũ opopoa. A'eramũ ywy esage pype u'at ma'efera te u'aramũ kwaiwete. Ajepeja 'ywa'aa sẽg i'aa. Ajepeja 'ywa'aa sesẽta i'aa. Ajepeja 'ywa'aa trĩta i'aa— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","—Ee pejejeapyoweramũ ki peapyaka katu jeje'eg are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Oporogytapaw ire 'ga uẽma yaruu awi nũ. A'eramũ ore 'ga remimu'eramũ 'ga rerowyka, oroporonupa ee 'ga upe: —Ma'eramũ te ereporogyta sigaty etee te 'gã nupe? Ma'eramũ ene 'gã mu'jau morogytau etee ki 'ei?— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A'eramũ Jejui 'ga 'jau oree: —Tejuwarete 'ga je'eg imũ futat je ruri pẽ mu'jau 'ga ree. 'Awamũ Jeruwa 'ga pẽ mogyi wemiayuwamũ jeje'ega renupa katu katuaramũ, a'e je 'ã pẽ nupe— 'jau 'ga oree. —A'ere je porogytai sigaty etee te pẽ mu'jau ee. Kasi a'e pe tesirũmera 'gã we ikwaawi erujewi ne, a'e je— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","—Jeje'eg are eapyowet ma'eramũ Janeruwarete 'ga pẽ mueapyoi ee. A'ere 'ga jeje'eg are eapyowere'ema 'gã namueapyoi ee. Ee 'gã neapyoweramũ etee te 'ga 'gã mueapyoi ee— 'jau 'ga oree. —A'ere ee eapyowere'ema 'gã 'gã amu'eawera moka'jamawi etee. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jeje'eg are eapyowere'ema 'gã wanup futat jeje'ega numiamũ. A'ere 'gã naeapyoi futari ee. Amã'jãu agawewi 'gã jeremiapofer are. A'etea 'gã naeapyoi ee. Ma'eramũ je 'ã morogytau etee imome'ui pẽ nupe pẽ mu'jawamũ. Imome'u katu re 'gã neapyo ekoeteramũ ajemogyau ee ne— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","—Ymã te Janeruwarete 'ga ka'arana kwasiarukari 'gã nee Isai 'ga upe rakue: “Jeje'eg are nipo 'gã apyakai agawewi ajemogyau. A'etea nipo 'gã naeapyoi ee. Amã'jãu nipo 'gã mama'e are. A'ere nipo 'gã nuesakatui. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","U'akwaawe'emamũ nipo 'gã ee. Wapya rawopytyma ete nipo 'gã jui. Wapymĩãu ete nipo 'gã jui nanẽ nũ. ‘Kasi janereapyoramũ ee ne’, 'jau nipo 'gã. Ee weapyo re amunipo 'ã 'gã poiri futari otywer awi. A'eramũ amunipo 'ã je 'gã katu'ogi 'gã tywer awi”, 'jau Janeruwarete 'ga oje'ega kwasiarukaa 'gã nupe rakue— 'jau Jejui 'ga wemimu'eramũ oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—'Gã amũ nipo naeapyoweri futari jeje'eg are. A'eramũ 'gã weapyoe'emamũ futat ajemogyau ee. A'ere 'ã na'gã 'jawe rũi te pẽẽ. Pẽneapyowet te pẽẽ jeje'eg are pejejemogyau. A'eramũ pẽẽ pejejeapyoramũ pejejemogyau ee. A'eramũ pẽẽ a'eramũ pejeku'iramũ pejejemogyau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Janeypy 'gã 'ã iporesagiwet futat jeremiapo are rakue numiamũ. Janeruwarete 'ga je'ega mome'wara 'gã, amumera 'ga remiayuwa 'gã. Mĩmera 'gã iporesagiwet ee rakue numiamũ. Iporenuwiwet jeje'eg are rakue numiamũ. A'ere 'ã 'gã manũi erujewi je rure'emauwe rakue— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Peapyaka ki jeje'eg are. Tamueapyo pẽẽ teje'eg are 'jau— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","—Sã'ã y'wa a'ỹja. Nan tee futat Janeruwarete 'ga je'ega. A'ỹja mũ nipo 'ã u'aa pe pe 'ga wi. A'ea nipo 'ã wyra'ia 'ua i'wau etee 'ga wi. Nan tee futat nipo Janeruwarete 'ga je'ega renupara 'gã amũ. 'Ga je'ega renuwi futari numiamũ. A'ere nipo 'gã naeapyoi ee. A'eramũ mama'eukwaawa 'wyriara 'ua erowiarukare'ema 'gã nupe: “Perowiar awi”, 'jau 'ua 'gã nupe. A'eramũ futat 'gã momoirukaa je rerowiar awi— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Sã'ã y'wa a'ỹja mũ 'ara ywy a'wyre'ema pype ipopora numiamũ. A'ere nitywi apoa. A'eramũ 'ã opapapa etee. Nan tee futat nipo 'gã amũ je rerowiaraiwi etee. Kamẽsĩete nipo 'gã je rerowiari. A'ere 'gã poiri kamẽsĩete je rerowiar awi nũ. Ojeupe mama'eay jesaukarauwe nipo 'gã opoia je wi. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","A'ere nipo amumera 'gã “Iro ererowiat aipoa?” 'jau nipo 'gã 'ua 'gã nupe, 'gã nerekou tyweaete je rerowiar are. A'erauwe nipo 'gã poiri je rerowiar awi je upe oporogyta awi. “Nia'wyri 'ga porogyta ra'e”, ojeupe 'erauwe nipo 'gã poiri je wi— 'jau Jejui 'ga oree ore mueapyou ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Sã'ã y'wa a'ỹja 'ara ju pype. A'eramũ 'ã opopoa futat numiamũ. A'eramũ 'ã jua imoteu etee. Nan tee futat nipo 'gã amũ Jarejuwarete 'ga je'ega renuwaiwi etee. A'eramũ nipo 'gã wemifutar are etee wea'aramũ ajemogyau nũ. Wea'aru'jawe'emamũ nipo 'gã jeje'eg are. Ojemuorypaw are etee nipo 'gã wea'aramũ akou. Okaraemã momytun are etee nipo 'gã wea'aramũ akou nũ. A'eramũ futat nipo 'gã wea'aru'jawe'emamũ jeje'eg are. Jeremifutar imũ nipo 'gã mama'e apowe'em futat— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Sã'ã y'wa a'ỹja ywy katurama pype u'at ma'ea. A'ea nipo awau waranupa u'aramũ. Nan tee futat Ku'jywa 'ga je'ega renupara 'gã neapyoramũ ajemogyau ee. Wago'oramũ miamũ 'gã nopoira'uweri futari je rerowiar awi. Ojemogypyyka etee futat nipo 'gã ajemogyau je ree. Janeruwarete 'ga pãjẽ mũ etee futat nipo mama'e esage apou ajemogyau. Sã'ã ywy katurama pype u'at ma'e 'ara. A'eramũ 'ã u'aramũ kwaiwete. Ajepeja 'ywa'aa sẽg i'aa. A'ere ajepeja 'ywa'aa sesẽta i'aa. Ajepeja 'ywa'aa trĩta i'aa. Nan tee futat jeje'ega renupara 'gã mama'e esage apoi Jarejuwarete 'ga remifutar imũ etee futat— 'jau Jejui 'ga oree, ore mueapyou ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","A'eramũ Jejui 'ga mama'e mũ mome'wau 'gã nupe najuejue etee futat nũ: —Mama'e mũ je amome'u pẽ nupe. Jarejuwarete 'ga rowase pẽ majatykaaw are je pẽ mu'ei— 'jau 'ga 'gã nupe. —Kũima'e 'ga amũ akou juowuu ra'ỹja tyma oko pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","A'ere ypytun imũ, 'ga seramũ, 'ga ree iporomutare'ema 'ga ruri juowuunana ra'ỹja tyma juowuu ra'ỹja põ'õ me 'ga wi. A'ere 'ga itym ire awau jui nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","A'eramũ opopoa waranupa awau. Aju'jaju'jawe futat numiamũ. I'ywa nanẽ nũ aju'jaju'jawe etee futat. A'ere i'a oteei ajaui. A'eramũ 'gã i'aramũ tãmẽjẽ esaka. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A'eramũ ko jara 'ga remiayuwa 'gã 'jau 'ga upe: “Juowuunana nipo eretym eko pype rai'i ki sa. Ma'eramũ nã'ã ipopori eewe re'ã”, 'jau 'gã 'ga upe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","—A'eramũ ko jara 'ga 'jau 'gã nupe: “Je ree iporomutare'ema 'ga nipo a'ỹja werut ityma jeko pe rai'i. ‘Tamote'at 'ga koa 'jau’ e'i nipo 'ga jee rai'i”, 'jau 'ga 'gã nupe. —A'eramũ 'ga remiayuwa 'gã 'jau 'ga upe: “Juowuunana jui ipo'oa te erefutat?” 'jau nipo 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—A'ere 'ga 'i etee 'gã nupe: “Naani. Pepo'o awi. Kasi a'e pe pemososok eewe te ne. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tene ijuwamũ ra'ne. A'ere tamũ'ẽukat ajaui imonookara 'gã nupe 'jau. ‘Pemũ'ẽ ra'ne juowuunana jui. A'eramũ pẽẽ imono'oga, iku'afaa, erawau iapyau. Iapy re pẽẽ juowuurete monooka erawau ejaa yrũ pype’ ta'e 'gã nupe 'jau”, 'jau ko jara 'ga wemiayuwa 'gã nupe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Imome'upaw ire Jejui 'ga mama'e mũ mome'wau 'gã nupe nũ, 'gã mu'jau Jarejuwarete 'ga remiayuwa 'gã nee: —Sã'ã y'wa'ỹi'ĩ'ĩa, mostarda 'jawa. A'eramũ 'ã ae ityma. A'eramũ 'ã opopoa awau o'ywuuramũ. A'eramũ 'ã wyra'ia aja'yrapyau akã are, waity mogyau ee— 'jau Jejui 'ga u'ama 'gã nupe. Aipo Jejui 'ga 'ea wemiayuwa jemomytunawama upe 'ga 'i poromũ. 'Awamũ 'ga rerowiaara 'gã inãinãnĩ'ĩ etee. A'ere 'gã anure kwaiwete 'gã jemomytuni nipo ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A'eramũ 'ga mama'e mũ mome'wau 'gã nupe, 'gã mu'jau ee nũ: —Sã'ã kũjã u'i mojerawa. A'eramũ 'ã imojopypeawa monou ipype. Inãinãnĩ'ĩ etee agawewi 'ã imonou ipype. A'etea 'ã awua— 'jau Jejui 'ga 'gã nupe u'ama. Aipo Jejui 'ga 'ea nanẽ wemiayuwa jemomytunawama upe 'ga 'i poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mama'e mũ 'ga omome'u 'gã nupe 'gã mu'jawamũ nũ. Mama'e mũ mome'ue'em ire amunipo 'ã 'ga nimu'jawi futari. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari ee 'ga amũ upe rakue: “Mama'e mũ je amome'u 'gã nupe Tejuwarete 'ga ree 'gã mu'jawamũ. Ywy apoe'emauwe 'gã naeapyoi ee. A'eramũ je 'gã mueapyou ee”, 'jau 'ga ikwasiaa Jejui 'ga ree rakue. A'eramũ Jejui 'ga morogyta mome'wau 'gã nupe, ee 'gã mu'jawamũ, 'ga remikwasiarer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","'Gã nupe oporogytapaw ire Jejui 'ga awau 'gã nui. Awau osou 'og ipe nũ. 'Ga remiayuwamũ nanẽ ore arawau orosou 'ga rupi nũ. A'eramũ ore 'jau 'ga upe: —Ore mueapyo ape eporogyta are, juowuu pype opopot ma'e are— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A'eramũ Jejui 'ga 'jau oree: —Sã'ã ae a'ỹja esage tyma. Nan tee futat je, Jarejuwarete 'ga remimureramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","'Awa ywya ko 'jawewara. Je rerowiaara 'gã a'ỹi esagea 'jawewara. Je rerowiare'ema 'gã a'ỹi esage pype opopot ma'e 'jawewara. Mama'eukwaawa 'wyriara remiayuwa futat aipo 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","41","Je ree iporomutare'ema 'gã mama'eukwaawa 'wyriara futat. A'eramũ mama'eukwaawa 'wyriara je rerowiare'ema 'gã mokwasi'wau jeremiayuwa 'gã pype. Anure nipo je Jarejuwarete 'ga rowase pẽ majatykaramũ, Jarejuwarete 'ga remimureramũ ywagipewara 'gã monou kwe pe mama'e tywera apoara 'gã mono'ogukaa. Ojomotywerukaarera 'gã neewe nipo je 'gã mono'ogukaa 'gã nupe, mama'eukwaawa rapyawa pype 'gã momopoawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tata rakuwa pype futat nipo 'gã awau ajemogyau. Eukwere nipo 'gã jemogyi waemamũ. Wa'jykãjamũ nipo 'gã ajemogyau ay upe— 'jau 'ga oree imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","—Janeruwarete 'ga remiayuwa 'gã etee te ywagipewara 'gã weroo ywag ipe 'gã mogyau Jarejuwarete 'ga pyri. A'eramũ nipo 'gã najuejue etee 'ga remiayuwa 'gã nesaka, 'ga pyri 'gã jemogyramũ. A'eramũ nipo 'gã nesakara 'gã 'jau: “A'jea futat 'gã jemogyi Ku'jywa 'ga remiayuwamũ”, 'jau nipo 'gã 'gã nesakawe— 'jau Jejui 'ga oree, ore mueapyou ee. —Ee pejejeapyoweramũ ki peapyaka katu jeje'eg are— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","A'eramũ Jejui 'ga mama'e mũ mome'wau oree nũ: —Sã'ã 'ga amũ mama'e epy mũ resaga ywy pype. A'eramũ nipo esakarera 'ga 'jau ojeupe: “Kuu. Ymã te sipo 'ã 'ga amũ imimi imỹina rakue. 'Awa pa je ywy amut tejee kwy”, 'jau 'ga ojeupe etee futat. “A'eramũ jema'ea futat imimipyrera 'jau kwy”, 'jau nipo 'ga ojeupe. A'eramũ 'ga imỹina gatu ra'ne. A'eramũ nipo 'ga awau okaraemã me'ega ka'aranũũ are. A'eramũ nipo 'ga ka'aranũũ rerawau ywy jara 'ga upe, ojeupe imuawamũ. Nan tee futat pẽẽ. Jarejuwarete 'ga remiayuwamũ pejejemogyweramũ pẽẽ pejepoia pejejemifutar imũ mama'e apo awi— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","A'eramũ 'ga mama'e mũ mome'wau oree nũ: —Jarejuwarete 'ga remiayuwamũ ae rekoa ita epy 'jawe. Sã'ã ita muara 'ga ita epy resaga. Esakawe nipo 'ga 'jau ojeupe: “Koa je afutat”, 'jau nipo 'ga ojeupe. A'eramũ nipo 'ga okaraemã me'ega ita epy muawamũ— 'jau Jejui 'ga oree. —Nan tee futat pẽẽ. Jarejuwarete 'ga remiayuwamũ pejejemogyweramũ pẽẽ pejepoia pejejemifutar imũ etee mama'e apo awi— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","A'eramũ 'ga mama'e mũ mome'wau oree nũ: —Jarejuwarete 'ga rowase pẽ majatykaaw are je pẽ mu'ei— 'jau 'ga oree. —Taityuu momoara 'gã 'ã taityuu monou imomoa 'y pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ipype kwaiwete pira jejag ire 'ã, 'gã imatãu imua nũ. A'eramũ nipo 'gã ipira renũ'jãu jui. Pira esagea etee nipo 'gã imonou yrũ pype. Pira a'wyre'ema nipo 'gã imomopoa etee. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nan tee futat Janeruwarete 'ga rowase pẽ majatykaaw ipe ywagipewara 'gã oi mama'e tywera apoara 'gã pe'au esage ma'e 'gã nui, 'gã mojo'oka 'gã monou mama'eukwaawa rapyaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tata rakuwa pype futat nipo 'gã oi ajemogyau akuekuewamũ. Aya nipo 'gã maema 'gã na'jywa mokãina 'gã mogyau— 'jau 'ga oree imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","A'eramũ 'ga oporonupa ee oree: —Pẽneapyo te pejejeupe jeremimome'u are ra'e?— 'jau 'ga oree. —Orereapyo ore ee arajemogyau— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A'eramũ Jejui 'ga 'jau oree: —Pejejeupe jeremimome'ufer are pejejeapyoramũ pejejemogyau pejemu'jara 'gã 'jawe etee futat. Jarejuwarete 'ga remikwasiarukarer are pejamu'jaramũ nipo pẽẽ. Ymã we te 'ã pẽneapyo Jarejuwarete 'ga je'eg are rakue. A'ere 'ã 'awamũ pẽneapyo jeje'eg are nũ. A'eramũ nipo pẽẽ 'gã mu'earũmũ 'ga je'eg ymaner are, jeje'ega reewe— 'jau 'ga oree. —Karaemã jara 'jawe pẽẽ pejejemogyau. Sã'ã karaemã jara 'ga okaraemã rerekoa. Iymanera 'ga nuetygi futari. Okaraemã momytuna erekou ipyu. Mama'e pyaua nanẽ 'ga 'ã erekou nũ. Nan tee futat pẽẽ. Pẽneapyo jeje'eg are. Jarejuwarete 'ga je'eg ymaner are nanẽ 'ã pejejeapyoramũ pejejemogyau nũ— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Morogyta mome'upaw ire Jejui 'ga awau uẽma amunaw awi. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Oje'wyr ipe 'ga awau, Nasare pe 'ga awau opytawaipa. Peu wekwaw ipe 'ga peuwara 'gã mu'jau judeu 'gã jatykaaw ipe. A'eramũ peuwara 'gã ajemogyau oporesagamũ 'ga ree: —Awỹja te 'ga amu'akwaap mama'e are nũ'ũ? Ma'ja pãjẽ mũ sipo 'ga aeremiapoe'ema apoi?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—Ma'eramũ sipo 'ga jane mu'ei mama'e are? NaMoisesi 'ga remikwasiarer are moromu'jara 'ga ra'yra rũi agawewi 'ga. A'etea 'ga 'ã ifuewet jane mu'e are. A'ere jane nienuwi 'ga porogytaa— 'jau 'gã 'ga upe. —'Yjepana pinara 'ga ra'yra 'ga te 'ã. Mari ẽẽ te 'ã 'ga ya. Tiago 'ga, Jose 'ga, Simão 'ga, Judas 'ga. Mĩmera 'gã 'ã 'ga rewirera. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'Ga renyra 'gã nanẽ 'ã ajemogyau 'au jane pype nũ. Maran ajee 'ga jane mu'ei 'ũ? Ma'ja pãjẽ mũ sipo 'ga mama'e apoi akou?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nuerowiari futari 'gã 'ga. A'ere Jejui 'ga 'i 'gã nupe: —Sã'ã Janeruwarete 'ga je'ega mome'wara 'gã oa kwe pe 'ga je'ega mome'ua. A'eramũ 'ã kwe pewara 'gã jẽmĩ 'gã je'ega rerowiaa. A'ere 'ã 'gã 'wyr ipewara 'gã jẽmĩ nuerowiari 'gã. 'Gã pytuna 'gã miamũ 'ã 'ga rerowiare'ema ajemogyau— 'jau Jejui 'ga oje'wyr ipewara 'gã nupe. —Nan tee futat ajee 'ã kwe pewara 'gã jẽmĩ je rerowiari. A'ere 'ã je'wyr ipewaramũ jẽmĩ naje rerowiari pejepe pejejemogyau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nuerowiari wejue 'gã 'ga. A'eramũ 'ga aeremiapoe'ema mama'e apoarũme'em oje'wyr ipe. Inãinãnĩ'ĩ etee 'ga iapoi peu. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Anure Erote 'ga, Garireja ywy pewara 'gã 'wyriara 'ga, Jejui 'ga rera renupa. 'Ga amũ Jejui 'ga remiapofera mome'wau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A'eramũ 'ga 'jau wemiayuwa 'gã nupe: —Juã Batista 'ga nipo 'ut oferapa rai'i nũ. A'eramũ nipo a'e 'ga aeremiapoe'em apou— 'jau 'ga 'gã nupe. Erote 'ga Juã 'ga jukaukaa 'gã nupe rakue. A'eramũ 'ga wea'aramũ 'ga ree, Jejui 'ga remiapofera renupawe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ymã te Erote 'ga wewirera 'ga remireko ẽẽ pojekai 'ga wi rakue. Erotiasi ẽẽ pojekau 'ga wi rakue, Filipe 'ga wi rakue. A'eramũ 'ga ẽẽ rerekou katu rakue. A'eramũ Juã 'ga 'jau 'ga upe: “Nia'wyri nanuara. Ejewirera remireko 'ã erepojeka 'ga wi. Ymã 'ã Janeruwarete 'ga oje'ega kwasiarukari Moisesi 'ga upe rakue: ‘Peko awi pejejuemireko are’, 'jau 'ga 'ã ikwasiarukaa 'ga upe rakue. A'etea 'ã ereapo nanuara. A'eramũ ene etywereteramũ ekou Jarejuwarete 'ga upe” 'jau Juã 'ga Erote 'ga upe rakue. A'eramũ Erote 'ga amara'neramũ Juã 'ga ree, 'ga pofaa, 'ga munewukaa moromunepawa pype rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Ga jukaa 'ga ifutaa numiamũ. A'ere 'ga kyjei judeu 'gã nui. “Juã 'ga 'ã Janeruwarete 'ga je'ega mome'wara futat”, e'i te 'ã judeu 'gã ajaupe jepi. A'eramũ Erote 'ga okyjau Juã 'ga juka awi. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anure Erote 'ga maraka apou. U'aawera 'ara rupi 'ga maraka apoi. A'eramũ Erotiasi ẽẽ ra'yra ẽẽ ojerokyau maraka are ajatyka ma'e 'gã nowase. A'eramũ Erote 'ga aku'iramũ ẽẽ jeroky are. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A'eramũ 'ga 'jau ẽẽ upe: —Ma'ja te erefutat? Tamono eneremifutara enee 'jau— 'jau 'ga ẽẽ upe. —Ma'ja te erefutat? Na'e ekoetei je enee. “Tamono eneremifutara enee 'jau”, a'e te je enee— 'jau 'ga ẽẽ upe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A'erauwe ẽẽ awau ujãna oy ẽẽ upe 'jau: —“Ma'ja te erefutat?” e'i kĩã jee. “Tomono eneremifutara enee 'jau”, e'i kĩã jee. Ma'ja te je aenũi kĩã upe?— 'jau ẽẽ oy ẽẽ upe rakue. —“Juã Batista kĩã akagera erurukat imonogukaa paratu pype jee”, ere kĩã upe kyn— 'jau ẽẽ wa'yra ẽẽ upe rakue. A'eramũ ẽẽ awau ojewya 'jau 'ga upe: —Juã Batista kĩã akagera erurukat paratu pype imonogukaa wã nupe jee kĩ'ĩ— 'jau ẽẽ 'ga upe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aipo ojeupe ẽẽ 'eramũ Erote 'ga u'arasigamũ 'ũina ẽẽ 'e are. “Ma'eramũ je 'jau ẽẽ upe ra'e 'ũ: ‘Eneremifutara tomono enee 'jau’, 'jau ẽẽ upe ra'e 'ũ”, 'jau 'ga ojeupe, u'arasigamũ 'ũina. A'ere 'ga wemimo'wy'wyrera 'gã nemianuwamũ aipo 'ga 'i ẽẽ upe. A'eramũ 'ga ojenosõu iapoe'em are. “Kasi a'e pe je'me are 'gã nekoi ajaupe ne kwy”, 'jau 'ga ojeupe. A'eramũ 'ga ẽẽ remienũiwera apoukaa ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A'eramũ 'ga wemiayuwa 'gã amũ monou Juã 'ga ajuwonogukaa rakue. —Moromunepawa pype Juã 'ga 'ami. Pe'je pejewau 'ga ajuwonoka. A'eramũ pẽẽ 'ga akagera rerua paratu pype ẽẽ upe— 'jau 'ga 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A'eramũ 'gã iapou, ojeupe 'ga 'eawer imũ etee futat. A'eramũ 'gã paratu pype Juã 'ga akagera rerua 'ga upe. A'eramũ Erote 'ga imonou Erotiasi ẽẽ ra'yra ẽẽ upe. Ojeupe 'gã imurauwe ẽẽ imonou oy ẽẽ upe. —Kweramũ, a'ni— 'jau ẽẽ oy upe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","“Erote 'ga 'ga jukaukat 'gã nupe” 'e renupawe Juã 'ga remiayuwa 'gã awau 'ga reumera upe erawau imonou inuga ita kwara pype. A'eramũ 'gã awau imome'wau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ojeupe Juã 'ga jukaawera mome'urauwe Jejui 'ga 'jau wemimu'eramũ oree: —Awotywe'eme soo ra'ne 'jau— 'jau 'ga oree. A'eramũ ore arawau oroyaapa yaruu pype. A'ere 'gã kwaiwete oreo kwaawi. —Soo 'ga rewiri 'ga porogyta renupa 'jau— 'jau 'gã ajaupe. A'eramũ 'gã awau ypia ywyri. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ojekog ire Jejui 'ga uẽma yaruu awi. Ko'iko'i ete mytuna 'gã 'ua owaẽma oree. 'Gã nesakawe Jejui 'ga ajemuaẽma 'gã nee. Ojero'wu ma'e 'gã 'gã erua 'ga upe. A'eramũ 'ga 'gã katu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kaaruwamũ ore 'ga remimu'eramũ 'jau 'ga upe: —Kaarup, ki 'ei. A'ere nitywi mama'ea 'au 'gã nemi'uramũ ki 'ei— 'jau ore 'ga upe. —Emono 'gã jarejewi. Too 'gã amunawa mũ pype wemi'urama mua ojeupe 'jau— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A'ere Jejui 'ga 'i etee oree: —Naani. Nooi futari 'gã. Pẽẽ te mama'ea pemono 'gã nupe— 'jau etee 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Nitywi futari mama'ea— 'jau ore 'ga upe. —Sĩku etee kanape'ia. Mukũi'ĩ etee ipira'ia. A'ea niapoi 'gã nupe— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A'eramũ 'ga 'jau oree: —Perut ajee jee— 'jau 'ga oree. A'eramũ ore erawau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A'eramũ 'ga ojee ajatyka ma'e 'gã nupe 'jau: —Pe'je pejeapyka juo'wi 'arimũ— 'jau 'ga 'gã nupe. A'eramũ 'gã wapyka. A'ere Jejui 'ga kanape'i pyyka opo pe ipira'i reewe. A'ere 'ga eramã'jãu ywau opo pe. A'eramũ 'ga 'jau 'Uwarete 'ga upe: —Au'jete mama'ea eremut oree. Ene te 'ã eneresage oree— 'jau 'ga 'Uwarete 'ga upe. Aipo 'e re 'ga kanape'i mowowoka ipira reewe 'ga imopẽpena imonou wemimu'eramũ oree. Omowowogamũ ojeme'yita oree. A'eramũ ore imonou wapyk ma'efera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A'eramũ futat 'gã ojemi'waa. Ojemi'wapaw ire 'gã 'jau: —Niapoi agawewi akiko. A'etea ojeme'yi 'ga upe 'ga omowowogamũ— 'jau 'gã ajaupe. —Janeruwarete 'ga te ome'yi janee. A'eramũ jane jarejewegamũ rẽwẽjẽmĩ jarejemogyau. Janeruwarete 'ga jarejeupe ime'yje'em ire amunipo 'ã jane ty'ara rerekoi— 'jau 'gã ajaupe. 'Gã jemi'wapaw ire ore emyrera mono'oga yrũ pype. Tusi yrupemũũ matyneema. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kwaiwete 'gã ojemi'waa. Sĩku miu agawewi kũima'efera 'gã pytuna. A'e pe kũjãmera nũ kunumĩmera 'gã netee. A'etea 'gã na'upawi kumia. Wewegamũ 'gã jui. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A'ere Jejui 'ga wemimu'eramũ ore monou ojewi: —Pe'je iruukwe je renune. Kwe katy pejewau pejeyaapa— 'jau 'ga oree. —Je apyta ra'ne. Tamono 'gã 'gã 'wyr ipe 'jau nũ. A'eramũ pẽẽ pejewau je renune— 'jau 'ga oree. A'eramũ ore arawau 'ga wi 'ga rejaa ojetee'i. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ojewi mytuna 'gã mono re Jejui 'ga awau ojeupia ywytyra rupi. Ojetee futat 'ga 'ũina oporogytau 'Uwarete 'ga upe ypytunimũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A'e pe ore arawau arakou oroyaapa. Mukuu te ore oi. Poje ywytuua 'ua oree, 'y ryjuapi retee. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ku'em ja'wyja'wyramũ Jejui 'ga 'ua ore rewiri. 'Y rajape 'arimũ etee futat 'ga 'ua watau akou. 'Ua 'ga ore rupisika. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","'Y rajape 'arimũ 'ga ata resakawe ore orokyjau 'ga wi. Orekyjea ore pifuaka'roka. —Ajaga nipo kwe 'ut owaẽma janee kũi— 'jau ore aruafukaita arajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A'erauwe Jejui 'ga 'jau oree: —Pekyje awi je wi. Je te ojot pẽ newiri— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A'erauwe Pedro 'ga 'jau 'ga upe: —Ene futat nipo ereko, ki Ku'jyp? Je futat 'jau, je mono ape je muatau 'y rajape 'arimũ eje'jawe— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A'eramũ Jejui 'ga 'jau 'ga upe: —Ere ajee ejua— 'jau 'ga 'ga upe. A'erauwe Pedro 'ga awau ojypa yaruu awi. A'eramũ futat 'ga awau watau 'y rajape 'arimũ Jejui 'ga repejãna. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Poje 'ga wea'aramũ erujewi ywytu are. A'erauwe 'ga kyjei. A'eramũ 'ga awau wypywygamũ. A'eramũ 'ga wafukaita Jejui 'ga upe: —Je poar ape, ki Ku'jyp! Jerypywyk je tekou— 'jau 'ga wafukaita, Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A'eramũ Jejui 'ga 'ga popyyka oje'ega 'ga upe: —Ma'eramũ ene ekyjau ete 'ũ? Ma'eramũ te ene nerejemogypyygi etee je ree? Je rerowia'ri'i tãmẽjẽ 'ã ape— 'jau 'ga Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A'eramũ 'ga 'ga rerua eru'aa yaruu pype. Ore pype 'gã 'arauwe ywytu wojeramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A'erauwe ore 'jau Jejui 'ga upe, yaruu pype ajemogy ma'eramũ: —A'jea futat. Ene te 'ã Jarejuwarete 'ga ra'yraretea— 'jau ore 'ga upe, 'ga muorypa. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A'eramũ ore arawau oroyaapa orojekoka Genesare ywy are. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jejui 'ga kwaaw ire peuwara 'gã oje'ega monou kwe pewara 'gã nupe: —Pe'je pejejua Jejui 'ga resaka. Ojero'wu ma'e 'gã nerua 'ga upe— 'jau 'gã oje'ega monou 'gã nupe. A'eramũ 'gã ojero'wu ma'e 'gã nerua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","A'eramũ 'gã 'jau Jejui 'ga upe: —Tene 'gã eneraity pypireme'ywa pyygi etee agawewi— 'jau 'gã 'ga upe. A'eramũ 'ga raity pypireme'ywa pyygarera 'gã ojekatu'okapap najuejue etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Anure fariseu 'gã amũ 'ua Moisesi 'ga remikwasiarer are moromu'jara 'gã netee Jerusareg awi oporonupa ee Jejui 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Ma'eramũ te eneremiayuwa 'gã nuapoi mama'ea jareypy 'gã je'eg ymaner imũ?— 'jau 'gã 'ga upe. —Ymã te 'ã janeypy 'gã 'i ajaupe rakue: “Janeruwarete 'ga janejepoeja afutat. Mama'e 'u enune jarejepoeite'ema 'eramũ janetyweramũ Jarejuwarete 'ga upe”, 'jau 'gã ajaupe rakue. A'eramũ ore orojepoeita orojemi'war enune 'gã 'eawer imũ etee futat jepi. A'ere 'ã eneremiayuwa 'gã nojepoei ojemi'war enune 'gã 'eawer imũ— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'eramũ ajee nepeenuwi Jarejuwarete 'ga je'ega pejejemogyau 'ũ? Na'ga je'eg imũ rũi nanẽ pẽẽ mama'e apou nũ. Peje'eawer imũ etee 'ã pẽẽ mama'e apou. A'eramũ kasi pẽẽ jeremiayuwa 'gã ago'wau ekoete pejejemimu'e tywer are ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","—Ymã te 'ã Janeruwarete 'ga 'i rakue: “Peanuw etee ki pejejuwa 'ga je'ega. Pejey ẽẽ je'ega nanẽ ianupa etee nũ”, 'jau 'ga 'ã rakue. “Ujara 'gã kurapara 'gã ki peapisi”, 'jau 'ã Janeruwarete 'ga ikwasiarukaa rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","—A'ere 'ã pemu'e 'gã 'gã jara 'gã je'ega renuw etee'em are etee pejejemogyau. “Pejejara 'gã nupe mama'e are pejeporomonowere'emamũ ki pe'je 'gã nupe: ‘Pẽ nupewara je amono Jarejuwarete 'ga upe ai'i. A'eramũ je mama'e mũ monowe'em pẽ nupe’, pe'je ki pejejara 'gã nupe”, 'jau 'ã pẽẽ 'gã mu'jau tywet pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","—Aipo apoaramũ pẽẽ pejejar are iporomutare'emamũ futat. A'eramũ pẽẽ aipo apoaramũ Jarejuwarete 'ga je'ega renupare'emamũ futat nanẽ nũ. Jarejuwarete 'ga je'eg imũ jẽmĩ 'ã mama'e apowe'em. Pejejea'aw imũ etee te 'ã pẽẽ mama'e apou ekoete pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","—“Ore Jarejuwarete 'ga je'eg are oreporenuwiwet jepi”, 'jau futatee 'ã pẽẽ pejejemogyau. A'ere pẽ'me ate. Ymã we te 'ã Janeruwarete 'ga oje'ega kwasiarukari inuga ka'aran are Isai 'ga upe pẽ nee rakue: ");
INSERT INTO kyzNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Nomỹi agawewi 'gã weaa je ree. A'etea nipo 'gã e'i ekoete futat: ‘Arafutar ore Jarejuwarete 'ga. Oroporenuwiweramũ 'ga je'eg are’, 'jau futatee nanẽ 'gã ajemogyau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","‘Aramuoryw ore Orojuwarete 'ga’, 'jau futatee 'gã jee”, 'jau Janeruwarete 'ga. “A'ere 'ã 'gã 'meramũ te. Nomỹi 'gã weaa je ree. Naje rerowiari tãmẽjẽ 'gã. U'eawer are etee 'gã jamu'ei. A'ere 'gã 'jau ajaupe: ‘Jarejuwarete 'ga je'eg are je pẽ mu'ei’, 'jau futatee 'gã ajaupe”, 'jau Janeruwarete 'ga ikwasiarukaa inuga ka'aran are Isai 'ga upe rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A'eramũ Jejui 'ga 'jau mytuna 'gã nupe: —Pe'je pejejua pejeapyakau jeje'eg are. Pejejeapyoramũ ee pejejemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Napẽ pype oo ma'efera rũi pẽ motywet Janeruwarete 'ga upe pẽ mogyau. Pẽ nui uẽm ma'ea te pẽ motywet Janeruwarete 'ga upe. Pẽje'egaiwa te pẽ motywet Janeruwarete 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A'eramũ ore Jejui 'ga remimu'eramũ 'ga rerowyka arajua oroporogytau 'ga upe: —Nafutari fariseu 'gã eneje'ega ra'e— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A'eramũ Jejui 'ga 'jau oree: —Anure nipo Janeruwarete 'ga 'gã nereko tyweretei 'gã 'eawer are. Sã'ã koa. Ko jara 'ga 'ã opopot ekoete ma'e ka'a po'oa. Wemitymera etee 'ã 'ga imuaranuwukaa oko pype. Nan tee futat nipo Janeruwarete 'ga iapoi. Oje'eg are ajamu'jatyweara 'gã nereko tyweri. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","A'eramũ pẽẽ pejejemuaẽme'ema 'gã nee. Eae'ema 'jawe 'gã. Eae'ema 'gã ojopopyyk ekoete ajuerawau kwe pe. A'ere nipo 'gã ajueru'ari etee ajuerawau ywy kwara pype. Nan tee fariseu 'gã. Naeapyoi 'gã Jarejuwarete 'ga je'eg are. A'etea 'gã ajamu'e ekoete ee. A'eramũ nipo 'gã wemimu'e 'gã nerawau mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A'eramũ Pedro 'ga 'jau 'ga upe: —Ore mueapyo ape e'eawer are, ki Ku'jyp. “Napẽ pype oo ma'efera rũi pẽ motywet Janeruwarete 'ga upe pẽ mogyau. Pẽ nui uẽm ma'ea tee pẽ motywet Janeruwarete 'ga upe. Pẽje'egaiwa te 'ã pẽ motywet Janeruwarete 'ga upe” 'eawer are— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A'eramũ Jejui 'ga 'jau oree: —Pẽẽ nanẽ nipo nepepyygi we pejeakag imũ ra'e ki sa? Ekoay pẽẽ na'e ki 'ei. Pẽẽ nanẽ meewei etee pẽneapyo ee ra'e ki 'ei. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nepẽneapyoi we futat nipo je'eawer are ki sa? Pejejemi'ua nipo pẽẽ imonou pejejuru pe. A'ere nipo pẽẽ imokona. Pẽnemi'ua osou pẽnawyrũ pype. A'ere nipo “pẽnemi'ufera okwapa pẽ nui” 'ea miamũ pẽ motywere'ema Janeruwarete 'ga upe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","—Pẽje'egaiwa te a'jea futat pẽ motywet 'ga upe. Pejejea'aw imũ etee pejeje'ega. Pẽje'egaiwa te a'jea futat pẽywyter a'wyre'ema wesaukat Janeruwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mama'e tywer are etee pejejea'aramũ. A'eramũ pẽẽ mama'e apou pejejea'ar imũ. 'Ga amũ nipo wea'aramũ akou oporojuka are. A'eramũ nipo 'ga oporojukau. 'Ga amũ nipo wea'aramũ akou wemirekoe'ema kũjã are oko are. A'eramũ nipo 'ga okou ẽẽ ree. Kũjã ẽẽ mũ nipo wea'aramũ akou omene'ema kũima'e are oko are. A'eramũ nipo ẽẽ okou 'ga ree. 'Gã amũ nipo wea'aramũ mama'e tesirũ apo are. A'eramũ nipo 'ga otyweramũ akou Jarejuwarete 'ga upe. 'Ga amũ nipo ojokaraemã futaa akou. A'eramũ nipo 'gã amunarũmũ ee. Wemifutar imũ etee o'meramũ nipo. Wea'aw imũ etee futat nipo 'gã ajuago'wau ajemogyau. Wea'aw imũ etee futat nipo 'gã Jarejuwarete 'ga kurapa. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Poromũ te 'gã jemotyweawa Jarejuwarete 'ga upe. Na'gã nemi'ua rũi futat 'gã motywet 'ga upe. 'Gã jepoeje'ema miamũ nomotyweri 'gã Janeruwarete 'ga upe— 'jau Jejui 'ga oree, ore mueapyou ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A'ere Jejui 'ga ore rerawau pe awi nũ. Tiro 'jawa pyri ore oi, Sidoma 'jawa pyri 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Peu ore rekoramũ peuwara ẽẽ mũ, judeue'ema ẽẽ mũ 'ua oje'ega Jejui 'ga upe: —Ene 'ã Jarejuwarete kĩã remimurera, Ku'jyp. Ejemuaẽm iki je ree, Ku'jyp— 'jau ẽẽ 'ua 'ga upe. —Mama'eukwaawa 'up jera'yra kyna pir are. Ojero'wu etee te kyna. Epe'a kyna wi jee, Ku'jyp— 'jau ẽẽ 'ga upe au'jeteramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A'ere Jejui 'ga ẽẽ je'eg anupare'ema 'jawe etee futat. A'eramũ ore 'ga remimu'eramũ 'jau 'ga upe: —Emono ẽẽ jarejewi. Jane rewiri etee 'ã ẽẽ rekoi wafukaita— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A'eramũ Jejui 'ga 'jau oree: —Janeruwarete 'ga je mua Israeu juapyrera 'gã nupe etee. Judeu 'gã karupa'mĩ ka'jama 'jawe jee. A'eramũ 'ga je mua 'gã nupe, 'gã mu'jaukaa ojee— 'jau 'ga oree. —A'ere ẽẽ najudeu arũi. Amutee ẽẽ te— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A'ere 'ã ẽẽ ruri ojea'gwawe'em futat wapyka wenupy'ãu 'ga rowase 'jau 'ga upe: —Je resag ape, Ku'jyp. Ejemuaẽm je ree— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A'eramũ Jejui 'ga 'jau ẽẽ upe: —Sã'ã ae kunumĩa mama'e 'ue'emamũ ae kunumĩ remi'urama monoe'ema weymawa upe. Nan tee futat je— 'jau Jejui 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—A'jea futat ere. A'ere ywyu mama'e 'ar ire wã neymawa i'ui futari— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A'eramũ Jejui 'ga 'jau ẽẽ upe: —Je rerowiat ape ekou ra'e ĩ. A'eramũ je enera'yra ẽẽ katu'oka enee— 'jau 'ga ẽẽ upe. Aipo 'ga 'e ypyrauwe futat mama'eukwaawa ojepe'au ẽẽ ra'yra ẽẽ wi. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","A'ere Jejui 'ga wemimu'eramũ ore rerawau pe awi nũ. Arawau orowaẽma Garirei ypiauu reme'y'warimũ. A'eramũ ore arawau orojeupia ywytyra rupi. A'eramũ Jejui 'ga wapyka wewiri oo ma'e 'gã mu'jau 'Uwarete 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kwaiwete 'gã 'ua owaẽma 'ga upe. Ojero'wu ma'e 'gã 'gã erua 'ga upe 'gã katu'okawamũ. Iteu ma'efet, eae'em, ika'na ma'e, ije'ege'em, ikaruat ma'e. Mĩmera 'gã 'gã werut 'ga upe. A'eramũ Jejui 'ga 'gã katu'okapap. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","'Gã katu'oga resakara 'gã oporesagamũ 'gã nee. —Kuu. Ije'ege'emera 'gã 'ga omoje'egukat! Iteu ma'e 'gã 'ga amafu'amukat! Ika'na ma'e 'gã 'ga ikatu'oka. Eae'ema 'gã 'ga imamã'jãu. Israeu juapyrera 'gã Nuwarete 'ga 'gã katu'ogukaa 'ga upe— 'jau 'gã ajaupe. A'eramũ 'gã Ku'jywa 'ga muorypa ee. —Ene te 'ã eneresage oree, ki Ku'jyp. Ojero'wu ma'e 'gã erekatu'ogukat 'ga upe ore reape— 'jau 'gã Ku'jywa 'ga upe, 'ga muorypa ee. —Israeu juapyrera 'gã Nuwareteramũ ene 'gã katu'ogukaa 'ga upe oree— 'jau 'gã Ku'jywa 'ga upe, 'ga muorypa 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kwaiwete 'gã katu'og ire, Jejui 'ga 'jau wemimu'eramũ oree: —Ajemuaẽm je tekou 'gã nee. Muapyt 'ã 'gã kaaruwamũ jane pyri. A'eramũ 'awamũ 'gã nemi'urama ateepawamũ 'gã nui. A'ere je najeporomonoweri 'gã nee tejewi, 'gã nupe mama'e monowe'emamũ. Kasi 'gã oje'wyr ipe awau 'gã manũaiwi ty'ara upe ne kwy— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A'eramũ ore 'jau 'ga upe: —Amunawe'em ipe jane rekoi nũ'ũ. Nitywi mama'ea 'au. Mõ awi sipo ore mama'e muri 'gã mojemi'waawamũ?— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A'eramũ 'ga 'jau oree: —Marãmaran te pẽkanape'i pytuna?— 'jau 'ga oporonupa ee oree. —Sete kanape'i pytuna muapyapy'ri etee pira'ia— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A'eramũ Jejui 'ga 'jau mytuna 'gã nupe: —Pe'je pejeapyka ywyu— 'jau 'ga 'gã nupe. A'erauwe 'gã wapyka. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A'eramũ 'ga kanape'i pyyka opo pe ipira'i reewe. A'eramũ 'ga 'jau 'Uwarete 'ga upe: —Au'jete mama'ea eremut oree. Ene te 'ã eneresage oree, Kiapi'ni— 'jau 'ga 'Uwarete 'ga upe. A'ere 'ga kanape'i mowowoka imonou wemimu'eramũ oree. Omowowogauwe ojeme'yita oree. A'eramũ ore imonou wapyk ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A'eramũ futat 'gã ojemi'waa wewegamũ. —Niapoi agawewi akiko re'ã. A'etea ojeme'yi 'ga upe janee 'ga omowowogamũ— 'jau 'gã ajaupe. —Janeruwarete 'ga te 'ã ome'yi janee. A'eramũ 'ã jane jarejewegamũ rẽwẽjẽmĩ jarejemogyau. Janeruwarete 'ga jarejeupe ime'yje'em ire amunipo 'ã jane ty'ara rerekoi— 'jau 'gã ajaupe. 'Gã jemi'wapaw ire ore emyrera mono'oga ijaga yrũũũ pype. Sete yrupemũũ ore imatyneema. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kwaiwete te ojemi'wat ma'efera 'gã pytuna. Kwaturu miu kũima'efera 'gã pytuna. A'e pe 'ã kũjãmera 'gã pytunamũ nũ, kunumĩmera 'gã netee. Kwaiwete ojemi'wat ma'efera 'gã pytuna. ");
INSERT INTO kyzNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","'Gã jemi'wapaw ire Jejui 'ga 'gã monou ojewi: —Pe'je pejewau pejeje'wyr ipe nũ— 'jau 'ga 'gã nupe. 'Gã mono re Jejui 'ga ore reru'aa yaruu pype nũ. A'eramũ ore arawau oroyaapa arawau orojekoka Magatã ywy are. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Anure fariseu 'gã amũ satuseu 'gã amũ netee 'ua oporogytau Jejui 'ga upe. Nuerowiari 'gã 'ga. “NaJarejuwarete 'ga pãjẽ mũ rũi 'ga mama'e apoi akou”, e'i etee 'gã ajaupe. A'eramũ 'gã 'ua 'ga resaka. A'eramũ 'gã 'jau Jejui 'ga upe: —Aeremiapoe'ema eapo amũ ore reape. Taruesak ene mama'e apoa orojemiesagamũ 'jau ki sa— 'jau 'gã 'ua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A'ere Jejui 'ga 'gã kwaawi ojee. A'eramũ 'ga 'jau 'gã nupe: —Naani. Naapoa'uweri je amũ pẽ neape. Naje rerowiari te 'ã pejepe. A'eramũ je mama'e apowe'em pẽ nemiesagamũ— 'jau ete 'ga 'gã nupe. —Kaaruwamũ ywak piraga resaka ki pe'je pejejaupe: “Ai'iwe nipo 'ã nokyri amana”, pe'je ki ywak piraga resag ire. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A'ere nipo ku'emamũ ywak piragamũ resag ire pe'je pejejaupe: “'Awamũ amana ra'e”, 'jau nipo pẽẽ ywak piragũũ resag ire. Ywaga resag ire nipo pẽẽ mũ amana kwaapa futat. A'ere nipo naje kwaawi pejepe. Jeremiapofera resaka agawewi nipo pẽẽ. A'etea nipo naje rerowiari pejepe. “Janeruwarete 'ga futat 'ga mut janee”, 'jawe'em nipo pẽẽ jee jeremiapofera resag ire miamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","—'Awauwaramũ miamũ 'ã nepẽa'wyri futari pejejemogyau 'ga upe. “Oreremiapoe'ema eapo amũ oree”, pe'je 'ã jee numiamũ. A'ere je naapoa'uweri mama'ea pẽ nupe pẽnemiesagamũ. Juna 'ga ree etee je pẽ muea'ari pẽ mogyau— 'jau Jejui 'ga 'gã nupe. 'Gã nupe oporogytapaw ire Jejui 'ga awau pe awi nũ. 'Ga remimu'eramũ nanẽ arawau 'ga rupi nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Arawau yaruu pype aru'aa. A'eramũ ore oroyaapa arawau. Garireja ry owajara katy ore arawau. A'ere ore 'ga remimu'eramũ kanape'i reroo moka'jami. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Arawaw ipe Jejui 'ga 'jau oree: —Pejea'gu ki fariseu 'gã nui, 'gã mani'oko'o jopype awi, satuseu 'gã ma'e awi 'jau— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aipo orojeupe 'ga 'eramũ ore 'jau arajaupe: —Kanape'i rerura jane simoka'jam ra'e. Ma'eramũ 'ã 'ga poromũ 'ga 'i janee— 'jau ore arajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","A'ere Jejui 'ga, arajaupe 'e renupawe, 'ga 'i oree: —Naje rerowiari tãmẽjẽ pejepe pejejemogyau ki 'ei. Ma'eramũ nã'ã aipo pe'je pejejaupe re'ã “Kanape'i rerure'em are 'ga 'i poromũ janee”, pe'je re'ã— 'jau 'ga oree. —Nakanape'i upe rũi je 'i poromũ pẽ nupe. “Pejea'gu ki fariseu 'gã mani'oko'o jopypeaw awi, satuseu 'gã ma'e awi nanẽ nũ”, a'e te je pẽ nupe kũi. “Morogyta 'gã pejejeupe imowuwut ekoete awi ki pejea'gu”, a'e te je pẽ nupe kũi— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","—Nepẽneapyoi we jeje'eg are ra'e. Pemoka'jam nipo jeremiapofera rai'i? Kanape'ia je ime'yitawera rai'i? Sĩku etee agawewi ako ai'i. A'etea ako je kanape'ia omowowok imonou sĩku miu kũima'e 'gã mojemi'waawamũ ai'i. 'Gã jemi'wapaw ire ako pẽẽ emyrera jaga tusi yrũ pype ai'i— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","—A'ere ako je sete kanape'i mowowoka kwaturu miu 'gã mojemi'waawamũ ai'i nũ. 'Gã jemi'wapaw ire marãmaran yrũa ajee pematyneem emyrera pyu rai'i? Sete yrũ etee futat ako ai'i. Pemoka'jam te ra'u jeremiapofera rai'i nũ? Ma'eramũ sipo ajee jerea'aramũ kanape'i pyu jaretywe'em are?— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","—Nakanape'ia rũi je amome'u pẽ nupe “Pejea'gu ki fariseu 'gã mani'oko'o jopypeaw awi” je'ea. A'ere 'ã nepẽneapyoi je'eawer are— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aipo orojeupe 'ga 'eramũ ore orojeapyoramũ 'ga 'eawer are. —“Pejea'gu ki fariseu 'gã 'e awi, satuseu 'gã 'e awi nanẽ nũ” 'e upe te je 'i numiamũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Orojekog ire ore arawau ywyu. Sesariafiripai ywy pe ore arawau. Peu orowaẽm ire Jejui 'ga oporonupa ee oree: —Ma'ja e'i te tekotee 'gã jee, pẽneki'yramũ jee jepi?— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—“Juã Batista 'ga te nipo 'ã 'ut oferapa rai'i nũ”, e'i 'gã amũ enee jepi. Amumera 'gã: “Eliasi 'ga nipo 'ã 'ut ojewya rai'i nũ”, 'jau enee jepi. Amumera 'gã: “Jeremi 'ga nipo, 'ga je'ega mome'warera 'ga amũ te nipo 'ua oferapa oporogytau akou janee nũ”, 'jau 'gã enee jepi— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Pẽẽ nũ. Ma'ja pe'je ajee jee jepi nũ'ũ?— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A'eramũ Simão Pedro 'ga 'jau 'ga upe: —“Janeruwarete 'ga remimurera 'ga futat”, aru'e ore jepi— 'jau Pedro 'ga 'ga upe. —“Okoeteete ma'e 'ga ra'yrarete 'ga futat”, aru'e ore jepi— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat ere poromũ, Simão— 'jau 'ga 'ga upe, Juã 'ga ra'yra 'ga upe. —Janeruwarete 'ga mama'e esagea wapo enee, 'agamũ ene mueapyoukaa je ree. Na'ga amũ rũi ene mueapyo je ree. Ywag ipe ako ma'e 'ga, Jeruwarete 'ga futat ene mueapyo je ree— 'jau 'ga Simão 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","—Enerer irũa Pedroa. Ita enerer irũa. Sã'ã pẽẽ 'oga apoaramũ ita 'arimũ imỹinaramũ itauu monoa ikokaramũ. Aipoa te itauua 'oga opyygete etygukare'ema. Nan tee futat ene'eawera “Janeruwarete 'ga remimurera 'ga. Okoeteete ma'e 'ga ra'yrarete 'ga futat”, ene'eawera. Aipo ene'eawera rerowiaara 'gã je amogy tejemiayuwamũ. Ene 'ã je amogo tejerowiarukaawamũ kwaiwete 'gã nupe. Anure nipo ene je rerowiaara 'gã 'wyriaramũ futat ereko. Kwaiwete nipo 'gã je rerowiaa. Je rerowiar ywyapi futat nipo 'gã ajemogyau. Mama'eukwaawa 'wyriara remiayuwa agawewi nipo afuewereteramũ 'gã nee. A'etea nipo 'gã nopoiri futari je rerowiar awi. Sã'ã 'oga omỹi esage re i'are'ema. Nan tee futat je rerowiaararetea 'gã nopoiru'jawi je wi— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","—Sã'ã saawi rerekwara. 'Wyriararete 'ga woga saawi monou wemiayuwa 'ga amũ upe. A'eramũ aipo 'ga mama'e apou o'wyriara 'ga upe, o'wyriara 'gã je'eg imũ etee futat. Nan tee futat je ene mogou 'wyriaramũ teje'eg irũnamũ. Ene futat 'awamũ ereko jeremiayuwa 'gã mu'jau jeremifutar are. “Nan tee siapo 'jau”, 'jau nipo ene ekou 'awamũ. Jeremiayuwa 'gã nupe aipo ene 'eramũ Janeruwarete 'ga nanẽ aipo 'jau enee nũ. “Nan siapo awi”, 'gã nupe ene 'eramũ Janeruwarete 'ga nanẽ aipo 'jau enee nũ— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A'eramũ 'ga 'jau oree nũ: —Je mome'u kasi pejepe tekotee 'gã nupe ne. “Jejui 'ga Janeruwarete 'ga remimurera”, 'jawe'em pẽẽ 'gã nupe— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A'e pe futat Jejui 'ga amanũawama mome'wau ypy oree: —Too Jerusareg ipe 'jau. Peu futat nipo judeuramũ jane'wyria'ri 'gã je rereko tyweri. Jane'wyria'ri, mainana 'wyriat, Moisesi 'ga remikwasiarer are moromu'jat. Mĩmera 'gã nipo je rerekou tyweaete je jukaukaa jefaruu 'gã nupe. A'ere nipo imuapyra 'ara rupi Janeruwarete 'ga je moferawi nũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aipo 'ga 'eramũ Pedro 'ga 'ga rerojepe'au'i ore wi, oje'egayau 'ga upe: —Ene'me awi nũ'ũ. Nene rereko tywera'uweri 'gã nũ'ũ. Janeruwarete 'ga nene rereko tywerukara'uweri 'gã nupe kũi— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A'eramũ Jejui 'ga ojerowaka amã'jãu 'ga ree: —Ejepe'a je wi, ki Satanasi. Mama'eukwaawa 'wyriara ene mu'eukat poromũ jee, ki Pedro. “Tamomoirukat 'ga 'ga Ruwarete 'ga remifutara apo awi 'jau”, e'i te Satanasi ojeupe. A'eramũ poromũ ene mu'jaukaa jee kũi— 'jau 'ga Pedro 'ga upe. —NaJarejuwarete 'ga remifutar imũ rũi ere aipo 'jau jee. Ejemifutar imũ te ere aipo 'jau jee— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","A'ere 'ga 'jau oree: —Jeremiayuwamũ pejejekoweramũ ki jeremifutar imũ etee futat mama'ea peapo. Pejekyjawe'em futat pejejereko tywer awi— 'jau 'ga oree. —Pejemanũ awi miamũ pejekyjawe'em futat. “Tene 'gã je jukai kwy. Napoira'uweri je Jejui 'ga rerowiar awi”, pe'je etee ki— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","—“Najemanũweri je Jejui 'ga mome'u are” 'jara 'gã nooa'uweri futari ywag ipe Jarejuwarete 'ga pyri— 'jau 'ga oree. —“Je naapoa'uweri futari mama'ea Jejui 'ga remifutar imũ” 'jara 'gã nanẽ nooa'uweri ywag ipe Jarejuwarete 'ga pyri— 'jau Jejui 'ga oree. —Amumera 'gã te nipo ajee e'i “tene 'gã je jukai kwy. Je napoira'uweri Jejui 'ga rerowiar awi”, 'jau. Aipo 'jara 'gã etee awau ywag ipe, Jarejuwarete 'ga pyri— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","—Okaraemã mono'og are etee ea'at ma'e 'gã ni'akwaawi futari. Kwaiwete agawewi 'gã karaemã. A'ere aipo 'gã miamũ nooi futari ywag ipe. Nomỹi 'gã weaa Jarejuwarete 'ga ree. A'eramũ 'gã awawe'em 'ga pyri. Mama'eukwaawa rapyaw ipe etee 'gã oi. Peu oo re 'gã nuẽmarũi futari jui. Nitywi mama'e mũ mama'eukwaawa rapyaw awi 'gã nẽnũ'jãawamũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","—Anure nipo pẽneki'yramũ je ruri tejewya nũ. Tejuwarete 'ga renyfuga pype nipo tejua, 'ga pyriwara 'gã netee. A'eramũ futat je pẽ mepyau pẽnemiapofer are najuejue etee futat. Teje'eg imũ mama'ea apoarera 'gã je imonou imogyau ywag ipe Jarejuwarete 'ga pyri. Tejerowiare'ema 'gã nipo je imonou imogyau mama'eukwaawa rapyaw ipe— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","—A'jea futat je 'i. A'eramũ futat nipo je tejua pẽ'wyriarareteramũ te'ỹina pẽ nupe. Pẽẽ mũ nipo je resaka pejemanũ enune, peje'wyriarareteramũ je ruramũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Anure seis oser ire Jejui 'ga awau ywyty'rarimũ. Ore mũ etee 'ga erawau ojeupi. Muapyra 'gã etee 'ga erawau ojeupi. Pedro 'ga, Tiago 'ga, 'ga rewirera Juã 'ga. Mĩmera 'gã etee 'ga erawau erojeupia ywyty'rarimũ ojeupi. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Peu Jejui 'ga ojesowo'gõka 'gã neape. 'Ga reakwara wenyfugamũ kwara reny 'jawe. 'Ga raitya nanẽ waparasigamũ 'ga ree nũ. Iaparasig enyfuk te 'ga raitya 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","A'erauwe 'gã Moisesi 'ga resaka Eliasi 'ga reewe. Ywag awi 'gã nuri oporogytau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ywag awi 'ut ma'e 'gã nesakawe Pedro 'ga 'jau Jejui 'ga upe: —'Awa esageay janee ra'e. 'Au etee sapyta 'jau, ki Ku'jyp— 'jau Pedro 'ga Jejui 'ga upe. —Ere futat te je tapỹja apoa pejejeupe? Muapyra tapỹja taruapo pẽ nupe 'jau. Ene upe, Moisesi 'ga upe, Eliasi 'ga upe 'jau— 'jau Pedro 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","'Ga porogyta pype ywasiga mũ 'ua ojypa 'gã nee nũ. Enyfug esage te ywasiga. A'e rupi futat Janeruwarete 'ga oje'ega mua 'gã nupe: —Koromũ futat jera'yrarete 'ga. Jeremifutararete 'ga. 'Ga 'ã je muorypararetea ojee. A'eramũ ki pẽẽ pejeapyakau 'ga je'eg are— 'jau Janeruwarete 'ga oje'ega mua ywasiga rupi 'gã nupe. 'Ga porogytapaw ire ywasiga ojeupiapap 'gã nui nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jarejuwarete 'ga je'ega renupawe Jejui 'ga remimu'e 'gã piryyjamũ jui. 'Ga je'ega 'gã mogyjau etee. A'eramũ 'gã awau wããpyramũ anuruka ywyu. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A'erauwe Jejui 'ga awau 'gã nepejãna opo mowyka 'gã nee. —Pekyje awi. Pe'je pejejua pejefu'ama— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A'eramũ 'gã wowowyramũ warekou. A'ere 'gã Jejui 'ga etee futat esagi 'ga 'amamũ. Ywag awi 'ut ma'efera 'gã awau ojeupia ywasiga rupi 'gã nui nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ywytyr awi 'gã neruaw ipe Jejui 'ga 'jau wemimu'e 'gã nupe: —Pemome'ua'ne kasi 'gã nupe ne. Pejejeki'yramũ je feraw ire tãmẽjẽ tepemome'u 'gã nupe 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A'eramũ 'gã 'jau Jejui 'ga upe: —Ma'eramũ ajee Moisesi 'ga remikwasiarer are moromu'jara 'gã 'i 'ũ: Ymã 'ã Janeruwarete 'ga ka'arana kwasiarukari 'ga amũ upe rakue: “Eliasi 'ga ra'ne nipo ojesaukat 'gã nupe. A'ere nipo 'ga rewiri jeremimonorama 'ga oi ojesaukaa 'gã nupe”, 'jau 'ga 'ã ikwasiarukaa inuga ka'aran are rakue, 'jau 'gã imome'wau oree jepi— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat 'gã 'i. Eliasi 'ga 'jawewara 'ga ra'ne futat ako 'ut ai'i. “Au'je ki mama'e tywera apo re. Pe'je ki pejepoia pejetywer awi. Ku'jywa 'ga tepẽ mogy wemiayuwamũ 'jau”, 'jau ako 'ga awau pẽ nupe ai'i je renune ai'i. A'ere nepekwaawi futari 'ga. A'eramũ 'gã 'ga rerekou tyweaete wemifutar imũ etee futat. Anure nipo 'gã je miamũ je rerekou tyweaete 'ga 'jawerimũ futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aipo ojeupe 'ga 'eramũ 'gã weapyoramũ ee ajemogyau. —Juã Batista 'ga 'ga omome'u janee— 'jau 'gã. —Juã Batista 'ga Eliasi 'ga 'jawewara futat— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ywytyr awi ojyw ire 'gã kwaiwete 'gã nesaka ywytyra raimy 'wyr ipe. Poje kũima'e 'ga amũ 'ua, wapyka wenupy'ãu Jejui 'ga rowase. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ejemuaẽm jera'yra 'ga ree, ki Ku'jyp. Mama'eukwaawa 'up 'ga pir are. A'eramũ 'ga moypipa— 'jau 'ga Jejui 'ga upe. —Oypiwauwe 'ga 'ari tata pe jepi. 'Y pe nanẽ 'ga u'aa jepi nũ— 'jau 'ga imome'wau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","—Arut futat je 'ga eneremimu'e 'gã nupe esaukaa ko numiamũ. A'ere 'gã nomoiri etee 'ga wi ko— 'jau 'ga imome'wau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A'eramũ Jejui 'ga 'jau oree: —Ma'eramũ sipo pẽẽ je rerowiare'ema pejejemogyau 'wei? Ymã agawewi nã'ã je pẽ mu'ei re'ã. A'etea nipo 'ã naje rerowiari tãmẽjẽ 'ã pejepe. “Nokoa'uweri je namutamutat pẽ pype”, a'e agawewi je 'ã pẽ nupe jã'nũ'ũ— 'jau 'ga tesirũmera 'gã nupe nanẽ nũ. —Pe'je 'ga ra'yra 'ga rerua jee— 'jau Jejui 'ga ore mũ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kunumĩ 'ga resakawe Jejui 'ga 'jau 'ga pirewara upe: —Ejepe'a 'ga wi— 'jau 'ga jupe. 'Ga 'e ypyrauwe ojepe'au 'ga wi. A'eramũ kunumĩ 'ga ajarueteramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","A'eramũ ore 'ga remimu'eramũ arawau 'ga repejãna 'ga pyri katu katu. A'eramũ ore 'ga upe etee oroporonupa ee: —Ma'eramũ ajee ore norope'aarũi 'ga wi ra'e 'ũ?— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","—Naje rerowiari wejue te 'ã pejepe. A'eramũ pẽẽ a'eramũ 'ga pirewara moirarũme'em 'ga wi— 'jau Jejui 'ga oree. —Mostarda 'jawa ra'ỹi 'ã sikõsikõi'ĩ agawewi. A'etea 'ã otym ire waranup. Aipoa aranuwa 'jawe pejemogy re amunipo 'ã pẽẽ peapo futat mama'ea. Je rerowiar etee te te nipo 'eramũ tee pearanup— 'jau 'ga oree. —Je rerowia'ri re amunipo 'ã peapo mama'ea pejejemiapoe'ema jepãjẽ mũ. Ywytyra upe amunipo 'ã pẽẽ 'jau: “Ejepe'a 'aw awi. Peu'i ewau e'ỹina”, 'jau amunipo 'ã ywytyra upe. Aipo ojeupe pẽẽ 'erauwe amunipo 'ã ywytyra ojepe'au awau pẽ'eawer imũ etee futat. Tejerowiaramũ te je tepãjẽ monoi pẽ nupe pẽnemiapoe'ema apoawamũ— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Anure Jejui 'ga remimu'eramũ ore arajatykau 'ga ree Garireja ywy pe nũ. A'eramũ 'ga 'jau oree: —Pẽneki'yra agawewi je 'ã. A'etea nipo Janeruwarete 'ga je pyygukat anurenure'i je ree iporomutare'ema 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","A'eramũ nipo 'ga je jukaukaa 'gã nupe. A'ere nipo 'ga imuapyra 'ara rupi ete je moferawi nũ— 'jau 'ga oree. A'eramũ ore aru'arasigamũ arajemogyau. Aipo 'ga 'ea ore mu'arasiga. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Anure Jejui 'ga wemimu'eramũ ore rerawau Kafanaũ 'jaw ipe nũ. Peu ore waẽmauwe Janeruwarete 'ga mogytaawa upe ka'aranũũ pyykara 'gã 'ua oporonupa ee Pedro 'ga upe: —Omepy te pẽ mu'jara 'ga ka'aranũũ pyu Jarejuwarete 'ga mogytaawa apokatuawa?— 'jau 'gã Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A'eramũ 'ga 'jau 'gã nupe: —Omepy futat 'ga— 'jau Pedro 'ga 'gã nupe. Pedro 'ga rog ipe osouwe Jejui 'ga 'jau 'ga upe: —Maran te enereapyo ee, ki Simão? Awỹja te ka'aranũũ amono ywy jara 'ga upe? 'Ga remiayuwa 'gã te omepy ywy jara 'ga upe, ywy are ako ma'e 'gã te ra'u nũ?— 'jau 'ga Simão Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Ywy are ako ma'e 'gã omepy ywy jara 'ga upe. Naywy jara 'ga remiayuwa 'gã nũi omepy— 'jau Pedro 'ga 'ga upe. —A'jea futat— 'jau Jejui 'ga 'ga upe. —'Ga remiayuwa 'gã nomepyi futari— 'jau Jejui 'ga. —Janeruwarete 'ga futat omogytaawa jara. Je 'ã 'ga remiayuwa. ");
INSERT INTO kyzNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","A'ere 'ã je ka'aranũũ pyykara 'gã mepyi. Kasi a'e pe 'gã je raykai ee ne— 'jau Jejui 'ga Pedro 'ga upe. —A'eramũ ene ewau ypiauu reme'y'warimũ epinaetyka. Eneremimu'ar ypya pira juru pe ka'aranũũ ywope'ia mũ ruwi. A'ea tereroo 'gã mepyau jarejee 'jau— 'jau Jejui 'ga Pedro 'ga upe. A'eramũ Pedro 'ga awau iapou 'ga 'eawer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Anure Jejui 'ga remimu'eramũ ore arajua oroporonupa ee Jejui 'ga upe: —Manamũ te jane Jarejuwarete 'ga upe esage ma'eramũ jarejuapyraapa?— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ojeupe aipo ore 'erauwe Jejui 'ga kunumĩ renũina: —Ere ejua 'au je pyri— 'jau 'ga 'ga upe. A'erauwe kunumĩ 'ga amũ 'ua 'ga repejãna 'ga rerowyka. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","4","A'eramũ Jejui 'ga 'jau oree: —Peesak te kunumĩ 'ga 'ama je pyri?— 'jau 'ga oree. —Kunumĩ 'gã nojerowiaraiwi ojee tee jepi. Ujar are 'gã jemogypyygi. Ujara 'gã je'eg imũ etee 'gã mama'e apoi. A'eramũ je 'jau pẽ nupe: Kunumĩ 'jawewara 'gã etee je amogy 'wyriaramũ tejepyri. Kunumĩ 'gã 'jawe pejemogy re te je pẽ mogyau 'wyriaramũ tejepyri. Kunumĩ 'jawewara 'gã etee esage ma'eramũ jee— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","—Kunumĩ 'gã nee ojejukau esage ma'eramũ je reewe futat pejejuka esage— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Kwaiwete kunumĩ 'gã je rerowiari ajemogyau. 'Ga amũ nipo je rerowiar awi kunumĩ 'gã momoirukaa 'eramũ nipo Janeruwarete 'ga 'gã nereko tyweretei— 'jau 'ga oree. —Sã'ã ae ita mogoa ojojuri. A'eramũ 'ã ae ojomonou ojomomoa 'yẽ'ẽ pype ajajukau. A'ere nipo 'y pe imomoripyrera 'ga reko tyweri'i etee. A'eramũ futat 'ga amanũmũ. A'ere nipo je rerowiar awi kunumĩ 'gã momoirukarera 'gã Janeruwarete 'ga ereko tyweretei futari— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","—Nateepawi futari nipo ajaupe mama'e tywera apoara 'gã. Iporiay'i aipo 'gã numiamũ. Aipo 'gã te nipo Ku'jywa 'ga wereko tywerete futat imojero'wau etee— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—“Jepoa je motywerukat Jarejuwarete 'ga upe. Mama'e tywera apoukaa jee, je motywerukaa Jarejuwarete 'ga upe”, 'jau ki pejepoa pemonok imonou imomoa pejejewi. Kasi a'e pe pẽpoa pẽ motywerukaru'jaw ine. “Tepyu nanẽ je mama'e tywer apoi ra'e” 'jaramũ pejepya nanẽ imonoka nũ. Kasi a'e pe pẽpya pẽ motyerukaru'jaw ine nũ. Pẽpo monoga rayramũ futat pẽ nupe. A'ere Janeruwarete 'ga mama'e tywera apoaramũ pẽ momopori pẽ monou mama'eukwaawa rapyaw ipe. Aipoa te ayrete ma'ea imomoripyrera 'gã nupe. “Janepoa jane motywet” 'jau pejepoa pemososopap pejewi. A'eramũ te nipo mama'e tywera nepeapou'jawi. A'eramũ te peo ywag ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Jarejea pyu mama'e resaga jane motywet” 'jaramũ pejejea mosoka imonou imomoa pejejewi. Imosog ire te nipo mama'e tywera nepeapou'jawi— 'jau Jejui 'ga oree. —Wea mosoga ay futat wea mosokara 'gã nupe. A'ere nipo Janeruwarete 'ga te mama'e tywera apoara 'gã momopori imonou mama'eukwaawa rapyaw ipe. A'ea te nipo ayay futat aipo pype imonopyrera 'gã nupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","—Kunumĩ 'gã nupe kasi pe'je ne, “nepeapoi pẽẽ kunumĩ'ĩ”, 'jawe'em pẽẽ kunumĩ'ĩ 'gã nupe, 'jau je pẽ nupe. Ywagipewara 'gã futat kunumĩ are ojejuka ma'ea. Weape futat 'gã kunumĩ rerekoi. Ywag ipe futat 'gã nee ojejuka ma'e 'gã jemogyi Jarejuwarete 'ga pyri— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—Maran te pekwaap? Wyra jara 'ga amũ sẽg karupa'mĩ wereko. Poje karupa'mĩa mũ awau oka'jama 'ga wi. Ma'ja sipo ijara 'ga wapo? Wejat futat 'ga weymawa jũ me, juowa 'wawamũ. A'eramũ 'ga awau oka'jam ma'e rekaa akou. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Esakawe 'ga aku'iramũ oka'jam ma'efer are. A'e pe 'ga aku'iramũ agawewi futat oka'jame'em are. A'eramũ 'ga oka'jam ma'efer are taetu aku'iramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nan tee futat Janeruwarete 'ga nafutari kunumĩ amũ oa mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Je rerowiaara 'ga amũ nipo mama'e tywera wapo enee. A'eramũ ki ekwap eporogytau 'ga upe ejetee'i ra'ne— 'jau Jejui 'ga oree. —Ojeupe 'ga tywera ene imome'u re nipo 'ga 'jau enee: “A'jea futat ako je mama'e tywera apoi enee ai'i. A'ere je 'awamũ naapou'jawi”, 'jau nipo 'ga enee. A'eramũ ene 'ga mojekoty'aa ejee nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A'ere ki 'ga ejaykapawe'emamũ epytuna 'gã amũ eroo ejeupi eroporogytau 'ga upe. Ymã te Janeruwarete 'ga ka'arana kwasiarukari 'ga amũ upe rakue: “'Ga upe 'ga remiapo tywera mome'uramũ ki pemome'u 'gã amũ nemianuwamũ 'jau. Majepei 'ga remianuwamũ ki pemome'u maranamũ mukũja 'gã nemianuwamũ. A'eramũ 'gã ene'e kwaapa 'jau”, 'jau 'ga ikwasiarukaa ka'aran are rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A'ere ki mama'e tywera apoara 'ga 'gã je'ega renuwetee'emamũ pẽ mome'u 'ga Jejui 'ga rerowiaara 'gã nupe. A'eramũ 'gã oje'ega 'gã nupe Jejui 'ga rerowiaara 'gã je'ega renuwetee'emamũ pẽẽ 'jau 'ga upe: “NaJaneruwarete 'ga remiayuwa rũi ene. Mama'eukwaawa 'wyriara remiayuwa te ene ra'e”, pe'je ki otywer awi ipoire'ema 'ga upe— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—A'eramũ je 'jau pẽ nupe: 'Gã amũ nupe “Janeruwarete 'ga pẽtywera omoit pẽ nui”, pẽẽ 'eramũ 'ga imoiri futari 'gã nui. 'Gã amũ nupe te nipo aje pe'je “Nepẽpoiriweri 'ã pejetywer awi. A'eramũ 'ga imoire'ema futat pẽ nui”, pẽẽ 'eramũ 'ga nomoiri futari 'gã nui— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","—A'jea futat je'ea: Ojeupe mukũjamũ pẽẽ mama'e renũjamũ, Jeruwarete 'ga mama'e apoi futari pẽ'eawer imũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Je rerowiaara 'gã ajatykau 'upa je upe oje'ega. A'eramũ je nanẽ tekou 'gã pype nũ. Maranamũ mukũi etee agawewi. Maranamũ muapy'ri etee agawewi nipo 'gã 'upa. A'ete je ako 'gã pype— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","A'eramũ Pedro 'ga awau Jejui 'ga rerowyka oporonupa ee 'ga upe: —Tepytuna 'ga mama'e tywera tejeupe iapou'jau'jawamũ sipo je maran tejemota'wau 'ga upe? Sete te sipo je teta'waramũ 'ga upe?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","A'ere Jejui 'ga 'i 'ga upe: —Naani nũ'ũ. Ejeupe 'ga mama'e tywera apou'jau'jawamũ ene nanẽ ejemota'wau'jau'japa etee futat ekou 'ga upe, au'jeteramũ— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Mama'e mũ je amome'u pẽ nupe pẽ mu'jau pẽmota'wa are— 'jau 'ga oree. —'Wyriara 'ga amũ nipo 'jau ojeupe oporowyky ma'e 'gã nupe: “Pe'je jeremiayuwa 'gã nerua jee. Taje mepy 'gã 'jau. Kwaiwete ako 'gã jekaraemã rerooi imepyawe'em ai'i. A'eramũ 'awamũ pejewau 'gã nerua je mepyawamũ”, 'jau 'ga ojeupe oporowyky ma'e 'gã nupe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","—A'eramũ 'ga upe oporowyky ma'e 'gã awau 'ga remiayuwa 'ga amũ rerua 'ga upe. Kwaiwete karaemã 'ga weroo imepyawe'em rakue. A'eramũ “Je mepy ape”, ojeupe 'wyriara 'ga 'eramũ 'ga 'jau etee 'ga upe “nitywi futari”, 'jau 'ga o'wyriara 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","A'eramũ 'wyriara 'ga 'jau ojeupe oporowyky ma'e 'gã nupe: “Peroo 'ga me'ega tekotee 'gã nupe 'gã nemifajamũ. 'Ga remireko, 'gã na'yt, 'ga karaemã. Mĩmera peroo ime'ega. A'eramũ pẽẽ 'gã nepyfera rerua jee”, 'jau 'ga opoirũ 'gã nupe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","—O'wyriara 'ga 'e renupawe, 'ga wapyka wenupy'ãu 'ga rowase: “Ejemuaẽm te je ree. Erejeaei awi je ree. Tene je ra'ne. Tamepy ene 'jau”, 'jau 'ga 'ga upe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—A'eramũ 'wyriara 'ga ajemuaẽma 'ga ree. A'eramũ 'ga 'jau 'ga upe: “Ajemuaẽm je ene ree. A'eramũ je tejea'aru'jawe'emamũ temepye'em are. Ere ewau”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","A'erauwe imepyare'ema 'ga awau uẽma 'ga rog awi. Awaw ipe 'ga opytuna 'ga amũ rowosõu. Inãinãnĩ'ĩ agawewi 'ga pytuna 'ga 'ga mepyawe'em rai'i. A'etea 'ga 'ga ajue'opyyk 'ga majaetyetyka: “Ere je mepyau 'awamũ”, 'jau 'ga oje'ega moywyrafena 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—A'eramũ 'ga pytuna 'ga wapyka wenupy'ãu 'ga rowase: “Ejemuaẽm te je ree. Tene je ra'ne. Tamepypap ene 'jau”, 'jau 'ga 'ga upe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—A'ere 'ga 'i etee 'ga upe: “Naani. Napoiri futari je ene wi”, 'jau etee 'ga 'ga upe, 'ga monou imomoa moromunepawa pype. “Je mepye'emamũ nereẽmi jui”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—'Wyriara 'ga poirũ 'gã 'ga resaka. A'eramũ 'gã awau 'ga mome'wau o'wyriara 'ga upe. “Ene 'ã erejemuaẽm agawewi 'ga ree. A'etea 'ga najemuaẽmi opytuna 'ga ree”, 'jau 'gã imome'wau o'wyriara 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","—A'eramũ 'wyriara 'ga 'ga renũina: “Ere ejua. Taporogyta enee 'jau”, 'jau 'ga 'ga upe. —Ojepyri 'ga rurauwe 'wyriara 'ga oje'ega moywyrafena 'ga upe. “Enetywerete jee 'awamũ. ‘Ejemuaẽm je ree’ ere ako jee ai'i. A'eramũ ako je tejemuaẽma ene ree ai'i. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","A'etea 'ã nerejemuaẽmi epytuna 'ga ree rai'i. Ejee je jemuaẽma 'jawe ki ejemuaẽma epytuna 'ga ree”, 'jau 'ga 'ga upe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","—Opytun are wemiayuwa 'ga jemuaẽme'emamũ 'wyriara 'ga amara'neramũ 'ga ree. “Nerejemuaẽmi epytuna 'ga ree. A'eramũ je tejemuaẽmu'jape'ema ene ree”, 'jau 'ga wemiayuwa 'ga upe 'gã monou imu'ama moromunepawa pype. A'eramũ 'ga 'jau moromunepawa raarana 'gã nupe: “Naje mepyi 'ga. Najemuaẽmi nanẽ 'ga opytuna 'ga ree. A'eramũ pẽẽ 'ga rerekou tyweaete jee, 'ga mayrũmũ jee”, 'jau 'ga 'gã nupe. “Je mepyawe'em 'ga nuẽma'uweri”, 'jau 'ga 'gã nupe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","—Nan tee futat Jeruwarete 'ga. Pejepytuna 'gã pẽ nereko tyweawer are pẽẽ au'jeteramũ 'gã nayka re Janeruwarete 'ga nanẽ pẽ naykau pẽtywer are. Pẽnaykaupawe'em pẽtywer are. Nomoiri futari 'ga pẽtywera pẽ nui. A'eramũ 'ga pẽ monou pẽ nerekou tyweaete mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga oree, ore mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","'Gã nupe oporogytapaw ire Jejui 'ga ore reruatau nũ. Garireja ywy awi arawau oroyaapa. Jotãu ry owajara katywara rape rupi arawau. A'eramũ ore orojewya oroyaapa nũ, Judeja ywy pe arajua nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","A'eramũ mytuna 'gã awau ore rewiri. Amumera 'gã ojero'wau. A'eramũ Jejui 'ga ojero'wu ma'e 'gã katu'okapap. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Poje fariseu 'gã amũ 'ua 'ga rerowyka. “Siesak 'ga je'eg amutee jarejee 'jau”, 'jau 'gã ajaupe. “'Ga je'eg ekoeteramũ, ‘Nuenuwi 'ga Moisesi 'ga je'ega ra'e’, sa'e 'ga upe 'jau”, 'jau 'gã ajaupe. A'eramũ 'gã 'jau 'ga upe: —Jaruete sipo kũima'e 'ga amũ wemireko retygi mama'e'emete are we?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽnea'ar iki pejejemimogytafer are. “Mama'e apoawamũ Janeruwarete 'ga kũima'e 'ga apoi, kũjã ẽẽ reewe rakue” 'eawer are pejejea'aramũ pejejemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Janeruwarete 'ga te 'ã e'i rakue: “Kũima'e 'ga je aapo kũjã ẽẽ reewe. A'eramũ 'ga wemirekoramũ kũima'e 'ga opojo'ogamũ ujara 'gã nui ojemujaa wemireko ẽẽ ree etee”, 'jau Janeruwarete 'ga rakue. “Ajuee ojemujar ire 'gã jemogyi majepei teewara 'jawe jee”, 'jau Janeruwarete 'ga rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ajuerekoe'ẽwe 'gã mukũi futat 'gã nekoi. A'ere ajuereko re 'gã majepei teewara 'jawe 'gã nekoi Jarejuwarete 'ga upe. Janeruwarete 'ga wejue werekoukat 'gã ajaupe. A'eramũ pẽẽ pejejomojo'ogukararũme'em pejejaui, pejejuereko re— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","—Ma'eramũ sipo ajee Moisesi 'ga 'i rakue: “Pejejemireko retyka ki ka'arana pekwasiarukat 'gã amũ nupe ẽẽ ree. ‘Aetyk je ene tejemirekoramũ akiko’, pe'je ki ikwasiarukaa pejejemirekofera ẽẽ ree, imonou ẽẽ upe”, 'jau 'ga ikwasiaa rakue— 'jau fariseu 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat. Niporenuwiweri wejue pẽypy 'gã Jarejuwarete 'ga ree rakue. A'eramũ Moisesi 'ga 'gã mueapyoukaa aipo are rakue. A'ere Janeruwarete 'ga aipo ne'i aeypy 'gã nupe rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","—A'ere a'jea futat je 'i: 'Ga amũ ẽẽ ree 'ga reko re etee ki pejejemirekoa peetyk. A'ere kasi ee pejeporetygiwere'emamũ peetyg ine. 'Ga amũ ẽẽ ree 'ga rekoe'emamũ pẽẽ pejejemireko retyka ekoete'em. Kasi a'e pe pejejemirekoe'em are ako ma'e 'jawe pejemogoukat amutee ẽẽ rereko re ne— 'jau Jejui 'ga fariseu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A'eramũ ore Jejui 'ga remimu'eramũ 'jau 'ga upe: —Ma'eramũ sipo ae wemireko retyke'ema najemogyi nan etee futat— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A'eramũ Jejui 'ga 'jau oree: —'Gã amũ nauagi ojetee ajemogyau. Jarejuwarete 'ga remifutar imũ etee futat 'gã amũ remirekoramũ. A'ere 'ga amũ naemirekoi, 'ga remifutar imũ etee futat— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","—'Gã amũ nipo u'aa oteuramũ. A'eramũ 'gã wemirekowere'emamũ. Amumera 'gã nipo ojeapi'a oogukaa 'ga amũ upe. A'eramũ 'gã wemirekoe'emamũ futat ajemogyau. Amumera 'gã te nipo ajee naemirekoweri futari. “Jarejuwarete 'ga upe toporowyky 'jau kwy. A'eramũ je tejemirekoe'emamũ tekou”, 'jau nipo 'gã ojeupe. A'eramũ emirekowere'ema 'gã wemirekoe'emamũ futat ajemogyau— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Anure kũjã 'gã amũ wa'yra 'gã nerua Jejui 'ga upe nũ: —Orera'yra apyte'rarimũ epo emono a'i kĩ'ĩ— 'jau 'gã erua 'ga upe. —Jarejuwarete kĩã upe eporogyta wã nee. A'eramũ Janeruwarete kĩã ojejukau esage wã nee, aru'e ore enee kĩ'ĩ— 'jau kũjãmera 'gã 'ga upe. A'ere ore Jejui 'ga remimu'eramũ ore 'i etee 'gã nupe: —Perur awi pejeja'yra 'gã 'ga upe 'ga porogyta 'ga 'amamũ. Nepemaruukari 'ga porogyta— 'jau ore 'ga remimu'eramũ 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","A'eramũ Jejui 'ga 'jau oree: —Naani. Peapo awi nanuara. Tene kunumĩ 'gã nuri je pyri— 'jau etee 'ga oree. —Janeruwarete 'ga kunumĩ 'gã afutat wemiayuwamũ. Kunumĩ 'jawewara 'gã nupe etee Janeruwarete 'ga reni 'wyriaramũ. Kunumĩ 'gã ojemogypyyk Jarejuwarete 'ga ree. Ojerekokatuukat 'gã 'ga upe. 'Gã 'jawe peko— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A'eramũ 'ga opo monou kunumĩ 'gã apyte'rarimũ. A'eramũ 'ga 'jau 'gã nupe: —Janeruwarete 'ga ojejuka esage pẽ nee, kunumĩ— 'jau 'ga 'gã nupe. 'Gã apyte'rarimũ opo mono re 'ga awau 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Anure kũima'e 'ga amũ 'ua Jejui 'ga rerowyka'i oporonupa ee 'ga upe: —Ma'ja te je aapo esage ma'eramũ Jarejuwarete 'ga upe tewawamũ ywag ipe temanũ re?— 'jau 'ga oporonupa ee Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A'eramũ Jejui 'ga 'jau 'ga upe: —Ma'eramũ ene ejua eporonupa ee jee nũ ki 'ei? Mama'e esagerete are ki 'ei?— 'jau Jejui 'ga 'ga upe. —Janeruwarete 'ga etee futat esage ma'ea. “Ene 'ã Jarejuwarete 'ga 'jawewara futat”, ere te jee?— 'jau 'ga 'ga upe. —Ywag ipe eoweramũ mama'ea eapo 'ga je'eg imũ etee, Moisesi 'ga upe 'ga remikwasiarukarer imũ etee— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Maranuara a'eramũ je mama'e apou ki 'ei?— 'jau 'ga Jejui 'ga upe. —Ymã te 'ã Moisesi 'ga Janeruwarete 'ga je'ega kwasiari inuga ka'aran are janee rakue. A'e are ejea'at. “Peporojuka awi. Peko awi pejejuemireko are. Pemunarũ kasi mama'e are ne. Peje'ẽwu'jag kasi 'ga amũ ne. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pejejara 'gã je'ega ki peanuw etee. Pereko esage ki 'gã pejejereko esage 'jawe etee futat”, 'jau 'ga 'ã ikwasiaa inuga ka'aran are rakue. Mĩmera 'ã erekwaapap— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A'eramũ 'ga 'jau Jejui 'ga upe: —Je kunumĩawe futat aipoa akwaap ikue. Moisesi 'ga je'eg imũ etee futat je mama'e apoi tekou. Ma'ja'ja jee je aapo 'ũ?— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat ere. A'ere 'awamũ mama'e mũ eapo, 'ga ree eparuerowiar ywyapiweramũ. Ekaraemã eme'ẽmap. A'ere ene ka'aranũũ monou ika'aranũũe'ema 'gã nupe. Aipoa ene iapo re, Janeruwarete 'ga ene monoi ojepyri ene manũ re. Mama'e esagea te nipo 'ga amut enee anure, ekaraemã 'gã nupe imonoawera mepyau enee anure. Ekaraemã me'eg ire ene ejua je rewiri— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aipo ojeupe Jejui 'ga 'eramũ 'ga u'arasigamũ etee okaraemã are. Kwaiwete te 'ga karaemã. A'eramũ 'ga oporome'egiwere'emamũ okaraemã are. A'eramũ 'ga 'jau ojeupe etee futat: “Naani. Naapoa'uweri je nanuara”, 'jau 'ga ojeupe etee futat. A'eramũ 'ga u'arasigamũ awau Jejui 'ga aipo ojeupe 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A'eramũ Jejui 'ga 'jau wemimu'eramũ oree: —Ayay te ikaraemã kwai ma'e 'gã jemogyi Jarejuwarete 'ga remiayuwamũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","—Ayay te ikaraemã kwai ma'e 'gã jekatu'ogukari Jarejuwarete 'ga upe. Kwaiwete 'gã karaemã. A'eramũ 'gã okaraemã are etee wea'aramũ. Okaraemã are etee aipo 'gã jemogypyygi akou. NaJarejuwarete 'ga ree rũi 'gã jemogypyygi ajemogyau. Jarejuwarete 'ga opoara futare'ema ajemogyau. Jeje'ega renupe'ema futat ajemogyau— 'jau Jejui 'ga oree. —Sã'ã kawaruu 'jawewara kamerua aguja kwara rupi ikwawe'ema. Nan tee futat ayayramũ ikaraemã kwai ma'e 'gã ojekatu'ogukaa Jarejuwarete 'ga upe. Ikaraemã kwai ma'e 'gã nijekatu'ogukariweri futari Jarejuwarete 'ga upe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aipo renupawe ore oroporesagamũ etee 'ga ree arajemogyau. A'eramũ ore oroporonupa ee arajaupe etee futat: —Maranuara 'gã tete Janeruwarete 'ga okatu'ok?— 'jau ore arajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aipo ore 'eramũ Jejui 'ga amã'jãu ore ree 'jau oree: —Pẽ nupe nayrareferi futari. Ayay futat mama'e apoa pẽ nupe. A'ere nitywi futari Janeruwarete 'ga remiapoe'ema mũ mama'ea. Mama'ea naayi futari 'ga upe. Ikaraemã kwai ma'ea miamũ Janeruwarete 'ga okatu'ok, “Jekatu'og ape” ojeupe 'gã 'eramũ— 'jau etee Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A'eramũ Pedro 'ga 'jau 'ga upe: —Ore ako aruejat orokaraemã arajua ene rupi ai'i. Oropytuna nanẽ futat ako ore ejaa ai'i nũ. Ma'ja te ore mama'e rejaawera repya?— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat ako ai'i. A'eramũ je 'jau pẽ nupe: Anure nipo Janeruwarete 'ga mama'e momyaui nũ. Aipoa 'ara rupi nipo je te'ỹina pẽneki'yrareteramũ 'wyriarareteramũ pẽ nupe. A'eramũ nipo je pẽẽ nanẽ futat pẽ mogyau 'wyriaramũ tejepyri. Israeu 'ga ra'yra 'gã pytuna tusi. A'eramũ je pẽ monou pẽ mogyau 'wyria'riramũ 'gã nupe Israeu juapyrera 'gã nupe. A'eramũ Israeu juapyrera 'gã nipo awau pẽ nowase. A'eramũ nipo pẽẽ 'jau mama'e esage apoara 'gã nupe: “Mama'e esage ereapo rakue, Jarejuwarete 'ga je'eg imũ rakue. A'eramũ 'ga ene mepyau eneremiapofer are”, 'jau nipo pẽẽ 'gã nupe— 'jau Jejui 'ga oree. —Mama'e tywera apoarera 'gã nupe nipo pẽẽ 'jau: “Mama'e tywera etee ereapo Jarejuwarete 'ga upe rakue. 'Ga je'eg imũ jẽmĩ mama'e apowe'em rakue. A'eramũ 'ga pẽ mepyau pẽnemiapo tywer imũ etee futat”, 'jau nipo pẽẽ 'gã nupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","—Amanũ re je ree omama'e rejaarera 'gã juejue awau ajemogyau Jarejuwarete 'ga pyri. Peu te 'ga mama'e teepawe'ema muri 'gã nupe kwaiwete, je ree 'gã mama'e rejaawera repyramũ futat mua 'gã nupe. Oy ẽẽ rejaarera 'gã, 'uwa 'ga rejaarera 'gã, wa'yra 'gã nejaarera 'gã, weki'yra 'gã nejaarera 'gã, wenyra 'gã nejaarera 'gã, okywyra 'gã nejaarera 'gã, wykiera 'gã nejaarera 'gã, woga rejaarera 'gã, oywy rejaarera 'gã. Mĩmera 'gã juejue ajemogyau Jarejuwarete 'ga pyri amanũ re. 'Gã nupe juejue futat Janeruwarete 'ga mama'e esage muri kwaiwete— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","—'Awamũ 'gã amũ reni 'wyriaramũ ajaupe. A'ere nipo anure aipo 'gã jemogyi akotee ma'eramũ etee nũ. 'Awamũ 'gã amũ jemogyi akotee ma'e 'gã 'jawe. A'ere anure nipo aipo 'gã jemogyi 'wyriara 'jawewaramũ nũ. 'Awamũ omama'e rejaarera 'gã akotee ma'e 'jawe etee futat 'gã jemogyi. A'ere nipo anure, 'wyriarareteramũ je renamũ, je ree omama'e rejaarera 'gã jemogyi 'wyriaramũ je pyri— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","A'eramũ Jejui 'ga 'jau: —Mama'e mũ je amome'u pẽ nupe pẽ mu'jau tejeupe pẽnemiapofera mepy are. Sã'ã uwa ko jara 'ga amũ oa ai'iwetetewe ojeupe oporowyky ma'e 'gã amũ nekara. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iporowykye'ema 'gã nesakawe 'ga 'jau 'gã nupe: “Pejot pejeporowykyau jee”, 'jau 'ga 'gã nupe. —“Maran sipo ajee ore mepy ape?” 'jau 'gã 'ga upe. —“Majepeja ka'aranũũ ywope'i pyu etee futat je tejeupe pẽporowykyawera mepyi pẽ nupe”, 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—A'eramũ 'gã awau 'ga rupi oporowykyau 'ga ko pe. Kwarawyruu'iramũ ko jara 'ga awau amunawa pyter ipe nũ, iporowykye'ema 'gã amũ nesaka nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A'eramũ 'ga 'jau 'gã nupe: “Pejot pejeporowykyau jeko pe. Kaaruwamũ tamepy pẽẽ 'jau, tejeupe pẽporowykyawer are 'jau”, 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A'eramũ 'gã awau oporowykyau 'ga upe. —Aje kwara kwawamũ ko jara 'ga awau, 'gã amũ nerua 'gã moporowykyaukaa ojeupe nũ. Kwara jerewamũ 'ga awau, 'gã amũ nerua nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kaarup ja'wyja'wyramũ 'ga awau amunawa pyter ipe nũ. A'eramũ 'ga iporowykye'ema 'gã amũ nesaka nũ. A'eramũ 'ga 'jau 'gã nupe: “Ma'eramũ pẽẽ pejeporowykyawe'em pejejemogyau 'ũ?” 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—“Nitywi ‘pe'je pejejua pejeporowykyau jee’ 'jara 'ga amũ oree”, 'jau 'gã 'ga upe. —A'eramũ 'ga 'jau 'gã nupe: “Pe'je ajee pejewau pejeporowykyau jee 'ũ”, 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Kaarup katu katuramũ ko jara 'ga 'jau opoirũ 'ga upe: “Emepy ki oporowyky ma'e 'gã jee. Kaarup ja'wyja'wyramũ oporowyky ma'e 'gã na'ne ki emepy jee. A'ere aje 'ut ma'efera 'gã, a'ere 'ut ypy ma'efera 'gã maapawamũ 'jau”, 'jau 'ga opoirũ 'ga upe. —“Nai'i”, 'jau 'ga poirũ 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—A'eramũ 'ga ka'aranũũ ywope'ia mũ monou kwara ooramũ oporowyky ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","'Gã mepy resakawe, oporowyky ypy ma'e 'gã 'jau ajaupe: “Kuu. Ka'aranũũ ywope'ia 'ga omono 'gã nupe jane upe 'ga 'eawera 'jawe etee futat”, 'jau 'gã ajaupe. “Jane upe taetu sipo ajee 'ga imuri kwaiwete'i. Ko'aramuku te ako jane porowykyi ko a'i kũi”, 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","—A'ere naani. Kaaruwamũ oporowyky ma'e 'gã mepy 'jawe etee futat 'ga imonoi 'gã nupe. A'eramũ 'gã amara'neramũ ko jara 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ko'aramuku agawewi ako ore porowykyi ko, kwaray pype ko. A'etea 'ga 'ã ore mepy kaaruwamũ oporowyky ma'e 'gã 'jawe etee. Nore mepy esagei ako ape ko”, 'jau 'gã oje'egayau ko jara 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—A'eramũ ko jara 'ga 'jau 'gã nupe: “Naani. Pẽ nupe teporogytau ako je 'i pẽ nupe ko: ‘majepei tee ka'aranũũ ywope'ia tomono pẽ nupe 'jau, tejeupe pẽporowyky mepyawamũ 'jau’, a'e ako je pẽ nupe ko. ‘Nai'i’, 'jau ako pẽẽ jee ko. A'eramũ 'ga je'eawer imũ etee futat pẽ mepyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Pe'je pejeka'aranũũ pyyka erawau pejejog ipe”, 'jau 'ga 'gã nupe. “Jema'ea te 'ã ka'aranũũa. A'eramũ je tema'ea etee futat erekou nan oporowyky'i'i ma'e 'gã mepyau pẽ 'jawe etee futat. Mama'e esage te je aapo 'gã nupe. A'e are 'ã pẽmara'ne je ree?” 'jau ko jara 'ga 'gã nupe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","—Nan tee futat Janeruwarete 'ga wemiayuwa 'gã mogyi pãwẽ pãwẽ ojepyri anure— 'jau 'ga oree. —Werowiaar ymanera 'gã, amanũ ja'wyja'wy pype werowiaara 'gã nanẽ 'ga imonou ojepyri futat nũ. Wemifutar imũ etee futat 'ga werowiaaramũ pẽ mogyau ojepyri futat. Aju'jaju'jawe etee futat 'ga 'gã mogyi ojepyri— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","A'eramũ Jejui 'ga ore rerawau Jerusareg ipe wemimu'eramũ. A'ere mytuna 'gã oi ore rupi. A'eramũ 'ga ore renũina ojeupe: —Pejepe'a'i 'gã nui ra'ne. Taporogyta pẽ nupe etee 'jau— 'jau 'ga oree. A'eramũ ore orojepe'au'i mytuna 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","A'eramũ 'ga 'jau oree: —Jerusareg ipe jane oi 'awamũ. Peu futat nipo 'ga amũ pẽneki'yramũ je monoi mainana 'wyriara 'gã nupe, Moisesi 'ga remikwasiarer are moromu'jara 'gã netee— 'jau 'ga imome'wau oree. —A'eramũ nipo 'gã 'jau jee: “Sijukaukat 'ga 'gã nupe 'jau”, 'jau nipo 'gã jee. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A'eramũ nipo 'gã je monou judeue'ema 'gã po pe. A'eramũ nipo judeue'ema 'gã je kurapa, je nupãnupãu, je monou je mu'ama 'ypeywar are jejywa pypiraa je manamamũ futat. A'ere nipo imuapyra 'ara rupi Janeruwarete 'ga je moferawi etee nũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A'ere Sepeteu 'ga remireko ẽẽ wa'yra 'gã nerua Jejui 'ga rerowyka'i. A'eramũ ẽẽ wããpyramũ 'jau Jejui 'ga upe: —Mama'e esagea eapo jera'yra wã nupe, Ku'jyp— 'jau ẽẽ 'ga upe. Tiago, Juã. Mĩnamũ ẽẽ ra'yra 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","A'eramũ 'ga 'jau ẽẽ upe: —Ma'ja ene ifutaa 'gã nupe je iapoa?— 'jau 'ga ẽẽ upe. A'eramũ ẽẽ 'jau 'ga upe: —Jera'yra wã emuapygukat ejepyri, oree 'wyriarareteramũ e'ỹinaaw ipe. Ejakwatawa katy kĩã amũ emuapygukat. Ajepeja kĩã ejau katy emuapygukat, wã mogyau 'wyriaramũ ejepyri— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A'eramũ Jejui 'ga 'jau ẽẽ ra'yra 'gã nupe: —Nepẽneapyoi futari nipo ee ki sa. 'Wyriarareteramũ je reko enune nipo 'gã naje rerekoarũi. Je rereko tywerete te nipo 'gã. Pejereko tywerukat sipo je pyri? Pẽnuag sipo pejejereko tywera upe?— 'jau 'ga ẽẽ ra'yra 'gã nupe. —Oreruag futat ore jupe nũ'ũ— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—A'jea futat nipo 'gã pẽ nereko tyweri anure. A'ere je miamũ namuapygarũi pẽẽ tejepyri tepoaawamũ. Jeruwarete 'ga etee te okwaap. Wemifutar imũ etee 'gã amũ mũ'jãu 'gã muapygukaa je pyri— 'jau Jejui 'ga 'gã mu'jau ojepyri wapyk ma'e 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","'Gã je'ega renupawe ore amumeramũ Jejui 'ga remimu'eramũ aramara'neramũ mukũja 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A'eramũ Jejui 'ga ore renũina ore majatykau ojee. A'eramũ 'ga 'jau oree: —Pekwaap judeue'ema 'gã 'wyriara 'gã nemiapoa. 'Gã 'wyriara 'gã wemiayuwa 'gã monou kwe pe mama'e apoukaa ojeupe: “Nan iki peapo jeje'egawer imũ etee futat”, 'jau nipo 'wyriara oje'ega wemiayuwa 'gã nupe. Iapo esage'emamũ nipo 'gã 'wyriara 'gã nereko tyweretei. A'etea nipo 'ga 'jau ojeupe: “Je 'ã kũima'eeteeteramũ”, 'jau nipo 'ga 'ũina ojeupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","—A'ere pẽẽ jeremiayuwamũ na'gã 'jawe rũi pejemogy. 'Wyriaramũ pejejekoweramũ pẽẽ mama'e apou pejejaupe, pejejopoaa etee futat mama'e apou pejejaupe. Pejejaupe oporowyky ma'eramũ etee futat pejemogy. A'eramũ nipo je pẽ mogyau 'wyriaramũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","—Je 'ã pẽneki'yraretea agawewi. A'etea je 'ã ojot 'awa ywy pe mama'e apou pẽ nupe. Natejeupe mama'e apoukaa rũi je ruri. Pẽ nupe mama'e apoawamũ te je ruri. Temanũmũ te 'ã je ruri 'au pẽ nupe. Pẽ katu'okawamũ te je ruri 'awa ywy pe. A'eramũ taetu 'gã taje rerowiat 'jau kwy, a'e te je 'ã— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jerikoa 'jawa amunaw awi ore oramũ mytuna 'gã 'ua ore rewiri. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mukũi eae'ema 'gã 'upa wapyka peyse pe. A'eramũ 'gã kwaiwete 'gã je'ega renupa 'upa. —Awỹja te poromũ ako?— 'jau 'gã ojepyriwara 'gã nupe. —Jejui 'ga okwap akou— 'jau 'gã 'gã nupe. Aipo ojeupe 'gã 'eramũ 'gã wafukaita 'ga upe: —Ku'jyp! Ene 'ã Davi 'ga juapyrera, Jarejuwarete 'ga remimurera! Ejemuaẽm ore ree. Epãjẽ mũ ore katu'og ape!— 'jau 'gã wafukaita Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A'eramũ mytuna 'gã 'jau 'gã nupe: —Pepije pejejupa. Aereau toko re'ã— 'jau 'gã 'gã nupe. A'ere 'gã jero'wuro'wui etee futat wafukaita 'ga upe: —Ku'jyp! Ene te 'ã Davi 'ga juapyrera, Jarejuwarete 'ga remimurera. Ejemuaẽm ore ree. Ore resag ape, aru'e ore enee— 'jau 'gã ojero'waro'wau etee wafukaita 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A'eramũ Jejui 'ga opytau pe pe 'gã nee. —Pe'je ajee pejejua— 'jau 'ga eae'ema 'gã nupe. A'erauwe eae'ema 'ga 'ua 'ga je'ega repejãna. A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'ja te pefutat pejejeupe je iapoa?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Taramã'ẽ 'jau nũ, aru'e ore enee, ki Ku'jyp. Orereapaw ore ikue— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A'eramũ Jejui 'ga ajemuaẽma 'gã nee. A'eramũ 'ga opo monou 'gã nea 'arimũ. —Amamã'ẽ je pẽẽ nũ— 'jau Jejui 'ga 'gã nupe. Aipo 'ga 'erauwe 'gã amã'jãu nũ. A'eramũ futat 'gã awau Jejui 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusarega pyriu'i ore oropytau amuna'wi pe, Pefaje pe. Pefajea 'upa ywytyra pyri, Oriweira 'jawa pyri. A'eramũ Jejui 'ga 'jau mukũjamũ oree: ");
INSERT INTO kyzNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Pe'je pejewau pejekwapa je renune pejewau pejewaẽma iruupeuwara amunawa upe. Pejesouwe nipo pẽẽ kawaru'i mũ resaka. Nuatai we nipo 'gã amũ i'arimũ. A'ea ki perut iamoia jee— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","—“Ma'eramũ te peko ee?” pejejeupe 'gã 'eramũ ki “Janejara 'ga te e'i oree ko: Kawaru'ia perut jee ra'ne, e'i 'ga oree ko. A'ere nipo 'ga ko'iko'i ete imuri pẽ nupe nũ”, pe'je ki 'gã nupe— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari oje'ega mome'wara 'ga amũ upe ee rakue: ");
INSERT INTO kyzNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pe'je Jerusareg ipewara 'gã nupe: ‘Owaẽm futat pẽ'wyriararete 'ga ra'e. Ipota'wa ma'e 'ga. Kawaru'i aranuwamueuu 'arimũ 'ga ruri akou’, pe'je ki Jerusareg ipewara 'gã nupe”, 'jau Janeruwarete 'ga ikwasiarukaa Sakari 'ga upe rakue. A'eramũ Jejui 'ga ore mũ monou kawaru'i rerurukaa ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A'eramũ 'gã awau 'ga 'eawer imũ etee erua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A'eramũ 'gã kawaru'i rerua ta'yra reewe 'ga upe. A'ere 'ga amũ opiara mosoka imonou kawaru'i 'arimũ Jejui 'ga apykawamũ. A'ere 'gã kawaru'i pyyka Jejui 'ga upe 'ga apykawamũ. A'eramũ Jejui 'ga awau Jerusareg ipe kawaru'i 'arimũ. 'Ga remimu'eramũ ore arawau 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kwaiwete 'gã awau ujãna 'ga renune opiara mososoka, imonou pe rupi imogyau 'ga kwapawamũ. 'Ga ree oporomutaawa resaukaawamũ 'gã iapou. Pinowa nanẽ 'gã imonou pe rupi 'ga kwapawamũ. Ymã 'gã aipo apou 'wyriararete upe rakue, 'ga ree ipojejuka resaukaawamũ rakue. A'eramũ 'gã a'eramũ iapou Jejui 'ga upe. —'Ga nipo ako 'wyriaramũ 'awamũ janee— 'jau 'gã ajaupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","'Ga renune oo ma'e 'gã wafukaita 'ga rewiri oo ma'e 'gã netee: —Au'je katu te 'ã Janeruwarete 'ga resageayramũ janee. Ene 'ã 'ga remimurera futat. Ene 'ã ore'wyriar ymanera juapyreramũ, Davi 'ga juapyreramũ. Janeruwarete 'ga ojejuka esage ene ree. A'eramũ ene eku'iramũ ekou. Janeruwarete 'ga 'ã esage oree. Ene 'ga 'ã ene mua oree— 'jau 'gã wafukaita Jejui 'ga upe. Arawau orowaẽma Jerusareg ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusareg ipe Jejui 'ga reserauwe peuwara 'gã aku'iaiwamũ 'ga ree. A'eramũ 'gã 'jau ajaupe: —Awỹja te 'agamũ?— 'jau peuwara 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A'eramũ Jejui 'ga rupi oo ma'e 'gã 'jau 'gã nupe: —'Agamũ futat Jejui 'ga, Nasare pe waranup ma'efera 'ga, Garireja ywy pewarera 'ga. Jarejuwarete 'ga je'ega mome'wara 'ga futat— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jerusareg ipe owaẽmawe Jejui 'ga ojypa kawaru'i awi. A'eramũ 'ga awawayayau osou Jarejuwarete 'ga mogytaaw ipe wemimu'eramũ ore retee. Irãã'ã wyra me'egara 'gã jemogyramũ. A'eramũ Jejui 'ga amara'neramũ 'gã nee: —Pe'je pejewau peje'jãu 'aw awi. Nawyra me'egawa rũi te 'ã. Jeruwarete 'ga mogytaawa te 'ã 'oga. 'Au futat jane ruri jareporogytau 'ga upe. A'ere 'ã pẽẽ nanarũi pereko. Pemỹi wyra me'egawamũ etee. Pejejeymawa etee 'ã pẽẽ erua ime'ega erupa 'ga mogytaawa 'oga pype— 'jau 'ga 'gã nupe. Wyra muara 'gã nanẽ 'ga imũ'jãu jui nũ. A'eramũ 'ga ka'aranũũ mojopy'ruara 'gã 'yjepana monou imuewiwya imojerepa 'gã nui. Aipo ka'aranũũ mojopy'ruara 'gã kwe pewara 'gã ka'aranũũ mojopy'rau ajaupe. A'eramũ Jejui 'ga 'gã 'yjepana monou imuewiwya imojerepa 'gã nui. Ka'aranũũ monou imomopomopoa 'gã nui. Pykau me'egara 'gã kanawaa nanẽ 'ga imojerepa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A'eramũ 'ga 'jau 'gã nupe: —Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari Isai 'ga upe rakue: “'Agamũ jemogytaawa 'oga futat. 'Au futat 'gã nuri oporogytau jee”, 'jau 'ga 'ã ikwasiarukaa 'ga upe rakue. A'ere 'ã pemỹi wyra me'egawamũ etee. Pejejeymawa me'ega pejejaupe pejejeymawa repy rowoupia ekoete 'ã pejejupa 'au pejejaupe. Ma'eramũ pẽẽ 'ga mogytaawa 'oga mỹina pejemunarũawamũ etee 'ũ?— 'jau 'ga 'gã nupe, 'gã mũ'jãu jui. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","'Ga mogytaaw ipe Jejui 'ga rekoramũ kwaiwete ojero'wu ma'e 'gã 'ua owaẽma 'ga upe. Eae'em, iteu ma'e. Mĩmera 'gã 'ua owaẽma Jejui 'ga upe. A'eramũ 'ga 'gã katu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jejui 'ga remiapofera resakawe kunumĩ 'gã amũ wafukaita: —Eneresage futat. Ene 'ã ore'wyriar ymanera juapyreramũ, Davi 'ga juapyreramũ— 'jau kunumĩ 'gã wafukaita Jejui 'ga upe. Mainana 'gã nanẽ Jejui 'ga remiapofera resaka nũ Moisesi 'ga remikwasiarer are moromu'jara 'gã netee. A'etea 'gã imara'ne Jejui 'ga ree aipo kunumĩ 'gã 'e renupawe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","A'eramũ 'gã 'jau Jejui 'ga upe: —Nereenuwi nipo kunumĩ 'gã 'ea ki sa? “Ene 'ã Janeruwarete 'ga remimurera” 'gã 'ea ki sa?— 'jau 'gã Jejui 'ga upe. —Aenup futat je te'ama— 'jau 'ga 'gã nupe. —Pẽnea'ar iki 'ga amũ remikwasiarer are. Janeruwarete 'ga je'ega rerekwara ka'aran are 'ga amũ ikwasiaa rakue: “Kunumĩ 'gã nupe Janeruwarete 'ga ene muorywukari, oy popewara 'gã neewe futat. ‘Ene te 'ã eneresage’ 'ea 'ga 'gã mu'eukaa”, 'jau 'ga ikwasiaa ka'aran are rakue. Pẽnea'ar iki ee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A'eramũ 'ga awau 'gã nui nũ. 'Ga remimu'eramũ nanẽ ore arawau 'ga rupi nũ. Petani 'jaw ipe ore arawau orosea. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ai'iwe ore arawau orojewya Jerusareg ipe nũ. Arawaw ipe Jejui 'ga opy'arayparamũ akou. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A'eramũ 'ga y'wa 'ywa repejãna. Peyse pe u'at ma'e repejãna i'a rekaa akã are, figu 'jawa rekaa akã are. A'ere nitywi i'a ee. Oowa etee esaka akã are. A'eramũ 'ga 'jau 'ywa upe: —Au'je katu katu ki e'a re 'awa y'wa 'ywa mũ— 'jau 'ga y'wa 'ywa upe. Aipo 'ga 'e ypyrauwe wakã oypiwamũ amanũmũ osiniga. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Esakawe ore 'ga remimu'eramũ oroporesagamũ ee. —Kuu. Kamẽsĩete nipo imanũi osiniga ki sa— 'jau ore arajaupe esakawe. —Ma'eramũ sipo oypiwamũ erujewi 'wei?— 'jau ore arajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A'eramũ Jejui 'ga 'jau oree: —Pẽnea'ar iki je'eawer are. Je rerowiar ire nanẽ pejejemiapoe'ema peapo je 'jawe nũ. 'Ywa nipo pẽẽ imosinigukaa je 'jawe je rerowiar ywyapiramũ— 'jau 'ga oree. —Ywytyra miamũ futat nipo pẽẽ imojepe'aukaa tenaw awi imonou 'yẽ'ẽ rypyter ipe imỹina. “Ekwap 'aw awi 'yẽ'ẽ rypyter ipe e'ỹina”, ojeupe pẽẽ 'eramũ nipo awau pẽ'eawer imũ etee futat— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","—Je rerowiar ire Janeruwarete 'ga mama'e monou pẽ nupe, “Mama'ea emut amũ oree”, ojeupe pẽẽ 'eramũ— 'jau Jejui 'ga oree, Jerusareg ipe arawaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jerusareg ipe orowaẽmawe Jejui 'ga awau osou Jarejuwarete 'ga mogytaaw ipe ore retee. Peu wekwaw ipe Jejui 'ga ojepyriwara 'gã mu'jau 'Uwarete 'ga ree. 'Gã mu'jau mainana 'wyriara 'gã 'ua judeu 'gã 'wyria'ri 'gã netee oporonupa ee 'ga upe: —Awỹja rer imũ te erejot rakue? Awỹja pãjẽ mũ te mama'ea ereapo? Awỹja te ene mut oree rakue?— 'jau 'gã 'ua oporonupa ee Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pe'je ajee pẽẽ na'ne imome'wau jee 'ũ. Tejeupe pẽẽ imome'u re je nanẽ tajemome'u pẽ nupe 'jau nũ— 'jau etee 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Awỹja je'eg imũ ajee Juã Batista 'ga ruri ae pymĩãu 'y pe rakue 'ũ? Jarejuwarete 'ga je'eg imũ te 'ga ruri rakue? Kũima'e 'ga amũ je'eg imũ te ra'u nũ?— 'jau Jejui 'ga oporonupa ee 'gã nupe u'ama. A'eramũ 'gã 'jau ajaupe: —Ma'ja sa'e te jane 'ga upe?— 'jau 'gã ajaupe etee futat. —“Jarejuwarete 'ga je'eg imũ 'ga ruri”, ojeupe jane 'eramũ te 'ga 'i janee nũ a'i kũi, “A'etea neperowiari 'ga”, 'ga 'i janee nũ a'i kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","—“Kũima'e 'ga je'eg imũ 'ga ruri”, jane 'eramũ te tekotee 'gã jane apisi etee ita pyu nũ a'i kũi. “Juã 'ga Jarejuwarete 'ga je'ega mome'wara futat janee”, e'i 'gã jepi. A'eramũ nipo 'gã aipo jane 'eramũ amara'neramũ jane ree ne nũ'ũ— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A'eramũ 'gã 'jau Jejui 'ga upe: —Norokwaawi ore Juã 'ga muarera 'ga nũ'ũ— 'jau 'gã o'meramũ 'ga upe. A'eramũ Jejui 'ga nanẽ 'jau 'gã nupe nũ: —A'eramũ je nanẽ temuarera 'ga mome'wawe'em pẽ nupe nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Morogyta je amome'u amũ pẽ nupe. Maran te pẽnea'at pejejemogyau ee? Kũima'e 'ga amũ mukũi 'ga ra'yra. A'eramũ 'ga 'jau tuwi ma'e 'ga upe: “Ekwap eporowykyau ko pe jee 'awamũ, kisit”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A'ere nipo 'ga 'i 'uwa 'ga upe: “Naani. Nooi je. Najeporowykyweri je enee ko pe 'awamũ”, 'jau 'ga 'uwa 'ga upe. A'ere nipo anure 'ga 'arasigamũ 'uwa 'ga upe u'eawer are. A'eramũ nipo 'ga awau anure oporowykyau 'ga ko pe akou. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ajepeja wa'yra 'ga upe nanẽ nipo 'ga 'jau nũ: “Ekwap eporowykyau jeko pe, kisit”, 'jau nipo 'ga wa'yra 'ga upe. A'eramũ 'ga ra'yra 'ga 'jau 'ga upe: “Nai'i. Too teporowykyau enee 'jau”, 'jau nipo 'ga 'uwa 'ga upe. A'ere 'ga nooi futari— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—Maranuara te 'ga ra'yra 'ga wapo mama'ea 'uwa 'ga remifutar imũ?— 'jau Jejui 'ga 'gã nupe. A'eramũ 'gã 'jau 'ga upe: —Tuwi ma'e 'ga. A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat ere poromũ. A'eramũ je 'jau pẽ nupe: Nia'wyri agawewi 'wyriararete 'ga upe ka'aranũũ pyykara 'gã, kũjãmene'ema 'gã netee. Nuerowiari futari 'gã Jarejuwarete 'ga rakue. A'etea 'gã jẽmĩ je rerowiat ajemogyau 'awamũ. Tejerowiaramũ je 'gã tywera moia 'gã nui. A'eramũ nipo 'gã awau ywag ipe ajemogyau Jarejuwarete 'ga pyri. A'ere 'ã pẽẽ naani. “Jarejuwarete 'ga ore aruerowiat arajemogyau”, 'jau futat te 'ã pẽẽ pejejemogyau numiamũ. A'ere 'ã naje rerowiari pejepe pejejemogyau. A'eramũ nipo pẽẽ pejewawe'em ywag ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juã Batista 'ga 'ã pẽ mu'jau agawewi Jarejuwarete 'ga remifutar are rakue. “Pe'je pejepoia pejetywer awi. Au'je ki mama'e tywera apo re. Mama'e esagea etee futar iki peapo Jarejuwarete 'ga remifutar imũ”, 'jau 'ga 'ã pẽ nupe rakue. “A'eramũ 'ga pẽ mogyau wemiayuwamũ”, 'jau 'ga 'ã pẽ nupe rakue numiamũ. A'ere 'ã neperowiari 'ga 'eawera rai'i. Ia'wyre'ema 'gã etee 'ã 'ga rerowiaa rai'i, opoia otywer awi rai'i. A'eramũ 'ã Janeruwarete 'ga 'gã mogyau wemiayuwamũ. A'ere 'ã neperowiari 'ga. Ia'wyre'ema 'gã otywer awi 'gã poira resag ire miamũ 'ã pẽẽ 'ga rerowiare'ema pejejemogyau rai'i— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Peapyaka jeje'eg are. Mama'e mũ je amome'u pẽ nupe, pẽ mu'jawamũ ee pẽ mueapyoawamũ— 'jau 'ga 'gã nupe. —Kũima'e 'ga amũ y'wa 'ywa rakã otym oko pe, uwa 'jawa 'ywa rakã otym oko pe. Kwaiwete 'ga uwa rakã tyma. A'ea tee futat 'ga ityma ipype. A'eramũ 'ga oko osõu. A'ere 'ga y'wa apikawa apou. Y'wa tyarũnamũ 'gã iapikau y'wayramũ. A'eramũ futat 'ga y'wa apikawa apou. A'ere 'ga 'og ywate apou iaarana 'ga upe. A'eramũ 'ga 'gã amũ monou oko raaranamũ imỹina ojeupe. “Y'waa mũ jema'ea futat. Emyreramũ te aje pẽma'e futat pẽporowykyawera repya futat”, 'jau ijara 'ga 'gã nupe. A'ere 'ga awau watau 'gã nui. A'eramũ 'ga namutamutat awau akou muku 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Y'wa tyarama upe iwaẽmauwe ijara 'ga wemiayuwa 'gã amũ monou oma'ea uwa 'a piaramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","A'ere ko raarana 'gã 'gã pyygi etee 'gã nerekou tyweaete. 'Ga amũ 'gã inupãnupãu etee. 'Ga amũ 'gã ijukau etee. 'Ga amũ 'gã ijukau ita pyu. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A'eramũ ko jara 'ga wemiayuwa 'gã monou kwaiwete. A'ere ko raarana 'gã nãnẽwẽjẽmĩ 'gã nerekoi nũ 'gã pyygi etee 'gã apisau. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A'eramũ ko jara 'ga 'jau ojeupe: “Teja'yra 'ga pa je omono kwy. 'Ga nipo 'gã opojeup re'ã. Jera'yra 'ga ree nipo 'gã pojyramũ re'ã”, 'jau nipo 'ga ojeupe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","—A'eramũ 'gã 'ga ra'yra 'ga resakawe 'jau ajaupe: “Wa'yra 'ga 'ga amut y'wa piaramũ ra'e. 'Ga futat 'uwa 'ga py'rau ko jaramũ 'uwa 'ga manũ re. A'eramũ jane 'ga jukau jui. A'eramũ janema'ea futat koa 'ga ruwa 'ga manũ re kũi”, 'jau nipo 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A'eramũ 'gã 'ga pyyka 'ga rerawau enuẽma ko awi 'ga jukau— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","A'eramũ Jejui 'ga oporonupa ee mainana 'wyriara 'gã nupe: —Maran sipo ko jara 'ga wa'yra jukaarera 'gã nerekoi?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A'eramũ 'gã 'jau 'ga upe: —'Ga futat oo ko raarana 'gã apisau nũ'ũ. A'ere nipo 'ga 'gã amũ monou 'gã py'rau oko raaranamũ nũ. Aipo 'gã te nipo y'wa mono ijara 'ga upe y'wa tyarama rupi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —A'jea futat pe'je poromũ. Pẽnea'ar iki 'ga amũ remikwasiarer are. Ymã te 'ã Janeruwarete 'ga oje'ega kwasiarukari 'ga amũ upe rakue: “Mĩa ita nia'wyruui ra'e, 'jau nipo itaoga apoara 'gã ajaupe, ita monou imomoa ajaui. A'ere nipo 'ga amũ aipoa ita eroyrũmyrera ita pyygi etee imonou imỹina tenawera pype 'oga ypywotypawamũ. Janeruwarete 'ga imỹjukaa 'gã nupe rakue. A'eramũ 'ga remiapofera wesageayramũ futat oree”, 'jau 'ga ikwasiarukaa ka'aran are inuga rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—A'jea futat je 'i. Ymã te 'ã Janeruwarete 'ga Israeu juapyreramũ pẽ mũ'ẽi wemiayuwamũ rakue. A'ere 'ã nepeenuwi futari 'ga. Nepefutari 'ga peje'wyriarareteramũ. A'eramũ nipo 'ga wenupara 'gã mogyau wemiayuwamũ pẽ py'rau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","—'Ga amũ nipo u'aa ita 'arimũ. A'e 'ga open futat. A'ere 'ga amũ 'arimũ ita 'ar ire a'e 'ga ku'jo'jogi futari. Nan tee futat Janeruwarete 'ga oje'ega renupare'emamũ pẽ nereko tyweretei— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","'Ga je'ega renupawe mainana 'wyriara 'gã fariseu 'gã netee 'jau ajaupe: —Mama'e mũ mome'uramũ 'ga 'i janee poromũ— 'jau 'gã ajaupe. A'eramũ 'gã amara'neramũ akou 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A'eramũ 'gã oporopyygiweramũ 'ga ree. A'ere 'gã kyjei mytuna 'gã nui. —“Jejui 'ga te 'ã Jarejuwarete 'ga je'ega mome'wararetea ra'e”, 'jau 'gã ajemogyau ajaupe. A'ere nipo 'gã jane apisi etee Jejui 'ga jane ipyygamũ— 'jau 'gã ajaupe, okyjau Jejui 'ga rerowiaara 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mama'e mũ Jejui 'ga imome'wau 'gã nupe 'gã mu'jau nũ: ");
INSERT INTO kyzNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Morogyta mũ je amome'u pẽ nupe pẽ mu'jawamũ Tejuwarete 'ga rerowiaara 'gã nee. Janeruwarete 'ga 'ã 'wyriararete 'ga 'jawe janee— 'jau 'ga 'gã nupe. —Sã'ã 'wyriararete 'ga maraka apoa wa'yra 'ga remirekoramũ. Kwaiwete 'ga 'ã kumi apoukaa wemiayuwa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Erojyw ire 'ga 'jau wemiayuwa 'gã amũ nupe: “Pe'je pejewau 'gã nupe kwe pe, jeremimo'wy'wyrera 'gã nerua jee”, 'jau 'ga 'gã nupe 'gã monou kwe pe. A'ere 'wyriara 'ga remimo'wy'wyrera 'gã nioweri maraka pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A'eramũ nipo 'wyriara 'ga amumera 'gã wemiayuwa 'gã monou wemimo'wy'wyrera 'gã nupe. “Pe'je jeje'ega rerawau 'gã nupe. ‘Pe'je pejejua pejejemi'waa ore pyri, e'i 'ga pẽ nupe ko. Kwataua je aapisiukat ai'i. A'eramũ je eyrukaa 'gã nupe. A'eramũ pẽẽ pejejua pejejemi'waa ore pyri, e'i 'ga pẽ nupe ko’, pe'je ki 'gã nupe”, 'jau 'ga wemiayuwa 'gã nupe oje'ega rerawaukaa— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—A'eramũ 'ga remiayuwa 'gã awau 'ga remimo'wy'wyrera 'gã nupe. A'ere 'gã ojeupe aipo 'gã 'eramũ 'gã 'i etee 'gã nupe: “Naani. Najeoweri je”, 'jau etee 'gã 'gã nupe. A'eramũ 'gã awau etee oporowykyau 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Amumera 'gã 'wyriara 'ga remiayuwa 'gã pyyka inupãnupãu 'gã apisau. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A'eramũ 'wyriara 'ga amara'neramũ akou 'gã nee. A'eramũ 'ga 'gã amũ monou wemiayuwa 'gã apisara 'gã apisau. 'Gã apisi re 'gã 'gã 'wyra rapyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A'eramũ 'wyriara 'ga wemiayuwa 'gã amũ nenũina nũ. “Mama'ea ako je aapo maraka are ko numiamũ. A'ere 'ã jeremimo'wy'wyrera 'gã nia'wyri futari. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","A'eramũ pẽẽ pejewau 'gã 'wyrarete rukawõ'õ rupi ajemogy ma'e 'gã mo'wy'wya jemaraka are”, 'jau 'ga wemiayuwa 'gã nupe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—A'eramũ 'ga remiayuwa 'gã awau amunawarete rukawõ'õ rupi ajemogy ma'e 'gã majatykau erawau werekwara 'ga maraka pe. Esage ma'e 'gã 'gã erawau ia'wyre'ema 'gã netee. 'Gã waẽmauwe 'wyriara 'ga remiayuwa 'ga amũ taity esage monou imunewukaa 'gã nupe. A'eramũ 'gã awau ojejaga 'wyriara 'ga roga matyneema. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Poje 'wyriara 'ga 'ua ajatyka ma'e 'gã nesaka. A'eramũ 'ga taity esage rerekware'ema 'ga resaka. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A'eramũ 'ga 'jau 'ga upe: “Ma'eramũ te neremunewi taity esagea?” 'jau 'ga 'ga upe. —Taity esage rerekware'ema 'ga noje'egi 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","—A'eramũ 'wyriara 'ga 'jau wemiayuwa 'gã nupe: “Pepyyk 'ga, 'ga po faa 'ga py faa 'jau. A'ere pẽẽ 'ga monou imomoa ukupepe. Ypytunaiwa pype pẽẽ 'ga momoa. Peu ajemogyaw ipe nipo 'ga waemamũ akou wa'jywa mokãina akuwa rerekou”, 'jau 'ga 'gã nupe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","—Aipoa morogyta je amome'u pẽ nupe, pẽ mu'jau Jarejuwarete 'ga remiayuwarete 'gã nee. Mytuna 'gã nupe Jarejuwarete 'ga 'i: “Tejerowiar ire je pẽ mogyi tejemiayuwamũ”, 'jau 'ga mytuna 'gã nupe. A'ere inãinãnĩ'ĩ etee 'gã 'ga rerowiari. A'eramũ 'ga inãinãnĩ'ĩ etee 'gã mogyau wemiayuwamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A'eramũ fariseu 'gã amũ awau 'ga wi. —Siesak Jejui 'ga ra'ne 'jau— 'jau 'gã ajaupe. —Tesirũgatu 'ga rekoramũ sipyyk 'ga 'jau. 'Gã amũ simono imoporogytaukaa 'ga upe ra'ne 'jau. Morogyta 'gã nupe imowuwuramũ sipyyk 'ga 'jau— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A'eramũ 'gã wemimu'e 'gã amũ monou Jejui 'ga upe imoporogytaukaa. Erote 'ga remiayuwa 'gã amũ netee Jejui 'ga upe 'gã monou imoporonuwukaa ee: —A'jea futat 'ã ereporogyta a'jeteetewi— 'jau 'gã 'ga upe. —Nereporogyta ekoetei futari te 'ã. A'jea futat 'ã erejejuka pãwẽ pãwẽ ae ree. A'jea futat te 'ã ore mu'e ape mama'e are. Eneje'eg are 'gã amũ oporenuwiwere'emamũ agawewi. A'ere 'ã mama'e a'jea etee eremome'u— 'jau 'gã oporonupa 'me Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","—A'eramũ ene 'awamũ 'jau oree: Jane 'ã judeua. Simono te jane ka'aranũũa 'wyriararete 'ga upe, Sesa 'ga upe? Naani te ra'u nũ?— 'jau 'gã 'ga upe. —Najudeu arũi te 'ã 'wyriararete 'ga. Tapy'ỹi amuteea te 'ã 'ga. Romanũa te 'ã 'ga. A'etea te jane simepy 'ga?— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","A'ere Jejui 'ga 'gã kwaawi ojee. “Jeje'ega renupa 'gã nuri numiamũ. ‘Siesak 'ga mama'e mũ mome'ua sigaty jarejee 'jau’ e'i 'gã jee numiamũ”, 'jau 'ga ojeupe. A'eramũ 'ga 'jau 'gã nupe: —Nepeporonuwi tee pejejua ee jee. “Simowuwut ekoete jarejaupe 'ga 'eawera jarejaupe 'jau”, pe'je te jee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—Ka'aranũũ ywope'ia pemut amũ jee ra'ne, Sesa 'ga mepyawa mũ jee ra'ne— 'jau 'ga 'gã nupe. A'eramũ 'gã amũ imonou 'ga upe. —Kweramũ ajee 'wei— 'jau 'ga imonou 'ga po pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A'eramũ Jejui 'ga ka'aranũũ ywope'i resaukaa 'gã nupe: —Awỹja ra'agawa te 'up ee? Awỹja rera ajee 'awamũ 'up ee nũ'ũ?— 'jau 'ga esaukaa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—'Wyriararete 'ga ma'ea futat— 'jau 'gã 'ga upe. A'eramũ Jejui 'ga 'jau 'gã nupe: —'Ga ra'agawa rerekwara 'ga ma'ea futat. A'eramũ pẽẽ imonou 'ga upe etee futat. A'ere Jarejuwarete 'ga mama'ea pemono 'ga upe etee futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","A'e renupawe 'ga upe ee oporonup ma'efera 'gã oporesagamũ etee 'ga ree: —Kuu. I'akwaap 'ga ra'e nũ'ũ— 'jau 'gã ajaupe. A'eramũ 'gã awau 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ko'iko'i satuseu 'gã amũ 'ua oporogytau Jejui 'ga upe ee nũ. Aipo 'gã e'i ajaupe: “Amanũ re ae noferawu'jawi nũ. Amanũmũ ae teepawamũ ywawuje futat”, 'jau agawewi satuseu 'gã ajaupe jepi. A'etea 'gã 'ut oporonupa ee Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","A'eramũ 'gã 'jau 'ga upe: —“Moromu'jara 'ga”, e'i 'gã enee jepi. A'eramũ ene ore mueapyou katu mama'e are. Ymã te 'ã Moisesi 'ga ka'arana kwasiari inuga janee rakue. “Kũima'e 'ga amũ nipo amanũ wa'yre'emauwe. A'eramũ nipo 'ga manũ re 'ga rewirera 'ga 'ga remirekofera ẽẽ rerekou. A'eramũ nipo 'ga aja'yrapyau ẽẽ pype. A'eramũ nipo 'ga ra'yr ypy 'ga amanũ ma'efera 'ga ra'yrera 'jawe futat”, 'jau 'ã Moisesi 'ga ikwasiaa inuga rakue— 'jau 'gã Jejui 'ga upe. A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A'eramũ 'gã 'jau 'ga upe nũ: —A'ere nipo kũima'e 'ga amũ 'ga ra'yra sete. A'eramũ nipo u'at ypy ma'efera 'ga kũjã mũ rerekou. A'ere nipo 'ga wa'yre'emauwe 'ga manũi jui. A'eramũ wemireko ẽẽ rejaa wewirerera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A'eramũ nipo imanũ re a'e rewirerera 'gã amũ ẽẽ rerekou ipy'rau nũ. A'ere a'ea nanẽ imanũi nũ wa'yre'emauwe nũ, ẽẽ rejaa wewirerera 'gã nupe nũ. A'eramũ nipo 'gã ojopy'rapy'rau etee ẽẽ ree, ajamanũnamũ. A'ere 'gã nata'yri'i futari ẽẽ pype. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ojee 'gã jomoypaw ire nipo ẽẽ nanẽ amanũmũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","A'eramũ nipo 'ga ae moferapawa 'ara rupi manamũ sipo ẽẽ menaretea?— 'jau 'gã Jejui 'ga upe. —'Gã juejue futat ẽẽ wereko kũi— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A'eramũ Jejui 'ga aipo ojeupe 'gã 'eramũ 'jau 'gã nupe: —Pẽ'me awi. Nanarũi. Nepẽneapyoi Jarejuwarete 'ga je'ega rerekwara ka'aran are ra'e. 'Ga pãjẽa nanẽ 'ã pẽẽ ikwaape'ema ra'e nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","—'Au etee te 'gã nemirekoramũ kũi. A'ere 'gã oferaw ire naemirekou'jawi kũi. Ywagipewara 'gã 'jawe etee futat 'gã jemogyi. Niporerekoweru'jawi 'gã kũjã are. Kũjãmera 'gã nanẽ omenariwere'emamũ futat nũ kũi, kũima'e 'gã 'jawe etee futat nũ kũi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","—Nepẽneapyoi nipo Jarejuwarete 'ga 'eawer are. Ymã te 'ã 'ga 'i rakue: “Je te 'ã 'gã Nuwaretea ako. Abraão 'ga, Isaki 'ga, Jako 'ga. Mĩmera 'gã Nuwaretea je ako”, 'jau 'ga 'ã ikwasiarukaa rakue. 'Gã manũ re 'ga poromũ 'jau rakue. A'ere 'gã 'aga namanũi futari, ateepawe'emamũ futat 'gã 'aga. A'eramũ Janeruwarete 'ga poromũ 'jau Moisesi 'ga upe. 'Gã 'aga tywe'em ire amunipo 'ã 'ga aipo ne'ia'uweri Moisesi 'ga upe. Ako ma'e 'gã nupe etee te 'ga aeruwamũ— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aipo 'ga 'e renupawe mytuna 'gã oporesagamũ etee 'ga ree. —Kuu. Nomoryteea'uweri futari ae 'ga ra'e nũ'ũ— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aipo ojeupe 'ga 'eramũ satuseu 'gã ajemogyau etee futat. Noporonuwu'jawi futari 'gã ee 'ga upe nũ. A'eramũ fariseu 'gã amũ 'jau ajaupe: “Satuseu 'gã noporonuwu'jawi futari ee 'ga upe nũ”, 'jau 'gã ajaupe. A'eramũ 'ga amũ awau oporonupa aipo 'ga 'eawer are Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Moisesi 'ga je'eger are moromu'jara 'gã poromũ awau oporonupa Jejui 'ga 'eawer are 'ga upe: “Je pa 'ga omorytee kwy”, 'jau 'ga ojeupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","A'eramũ 'ga poromũ awau oporonupa 'ga 'eawer are 'ga upe: —Ene te 'ã ore mu'e ape Jarejuwarete 'ga ree. A'ere 'ã kwaiwete Janeruwarete 'ga u'eawera kwasiarukari Moisesi 'ga upe rakue. Maranuara te ajee 'ga 'eaweraretea?— 'jau 'ga Jejui 'ga upe. “Tomojenosĩ Jejui 'ga 'jau kwy”, 'jau 'ga ojeupe numiamũ. A'ere Jejui 'ga ikwaawi futari ojee. “Tamu'akwaawukar eme 'ga, e'i 'ga jee numiamũ”, 'jau Jejui 'ga ojeupe. A'eramũ Jejui 'ga 'jau 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—“Je te 'ã Pẽjararetea. Pẽporomutat je ree pejepytuna 'gã apyraapa”, e'i 'ã Janeruwarete 'ga pẽ nupe rakue. “Mama'ea peapo jee, jeremifutar imũ. Pejejea'aramũ pejejemogyau je ree 'gã nee pejejea'ara apyraapa. Aipo aporamũ nipo pejeporomutaramũ je ree”, e'i futat Janeruwarete 'ga pẽ nupe— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","—Aipoa te 'ga 'eaweraretea— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","—Ajepeja 'ga 'eaweraretea nanẽ nũ. “Pẽporomutat pejejepyriwara 'gã nee pejejee pejeporomutara 'jawe”, e'i 'ga 'ã ikwasiarukaa Moisesi 'ga upe rakue— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","—Aipoa 'ga remikwasiarera renupara 'gã wenup katu katu 'ga remikwasiarera ajemogyau. Ajepeja 'ga remikwasiarera moromu'jau ajuee aejejuka esage are etee futat. Janeruwarete 'ga je'ega mome'wara 'gã nanẽ oporomu'jau aipo are nũ— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ojee fariseu 'gã jatykaramũ Jejui 'ga oporonupa ee 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Maran te pẽneapyo Jarejuwarete 'ga remimurera 'ga ree? Awỹja juapyrera te 'ga?— 'jau 'ga 'gã nupe. —Davi 'ga juapyrera 'ga— 'jau 'gã 'ga upe. A'eramũ Jejui 'ga 'jau 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Ma'eramũ sipo ajee Janeruwarete 'ga 'Agesagea Davi 'ga mu'eukari “Jejara 'ga” 'ga mu'eukari ajuapyrera 'ga upe? ");
INSERT INTO kyzNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ymã te 'ã Davi 'ga ka'arana kwasiari 'ga ree rakue: “Jeruwarete 'ga 'jau Jejararete 'ga upe rakue: ‘Eapyk 'au je pyri. Je 'jawe futat ene. Enepãjẽretea je 'jawe. A'eramũ ene eapyka je yse katy. Anure nipo je ene mogoi 'wyriaramũ 'gã nupe najuejue etee futat. Ene ree iporomutare'ema 'gã 'arimũ je ene magwawukari. A'eramũ ene je iapoe'emauwe eapyka 'au je yse katy’, 'jau 'ga Janejararete 'ga upe”, 'jau Davi 'ga ikwasiaa rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","—Janeruwarete 'ga remimurera 'ga ree 'ga ka'arana kwasiari rakue. Ma'eramũ sipo ajee 'ga 'i, “Jejararete 'ga”, 'jau ajuapyrera 'ga upe nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aipo 'ga 'e renupawe 'gã ajemogymogyau etee futat. Ojenosõu 'gã 'ga wi. A'eramũ 'gã oporonuwu'jape'ema ee 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","A'eramũ Jejui 'ga oje'ega wemimu'eramũ oree, mytuna 'gã nupe we futat: ");
INSERT INTO kyzNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisesi 'ga remikwasiarer are moromu'jara 'gã weapyoramũ Moisesi 'ga remikwasiarer are fariseu 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","A'eramũ ki pẽẽ 'gã je'ega renupa etee futat 'gã pejemu'eramũ. A'eramũ ki pẽẽ mama'e apou 'gã pejemu'eawer imũ etee futat. A'ere kasi pejemu'e 'gã nemiapo are ne. Nuapoi futari 'gã pẽ mu'eawer imũ mama'ea. A'eramũ pẽẽ pejejemu'jawe'em 'gã nemiapo are. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Nan iki peapo”, 'jau nipo 'gã pẽ nupe numiamũ. A'ere nipo 'gã nepẽ poari mama'e apo are u'eawer imũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tekotee 'gã nupe ojesaukaawamũ te 'gã mama'e apoi. “Je te 'ã a'jea futat kũima'eeteetea”, 'jau nipo 'gã ajaupe. A'eramũ nipo 'gã mama'e apou ekoete ajemogyau ojesaukaawamũ 'gã nupe. “Tiporesagete 'gã je ree 'jau”, 'jau nipo 'gã ajemogyau. Jane 'ã kũima'eferamũ juejue Jarejuwarete 'ga je'ega kwasiaa ka'ara'nĩ pe ree. A'eramũ jane imonou yrũ'ĩ'ĩ pype ifaa jareakag are. A'eramũ jane jarejeapykag are erekou, jarejywaypy are nanẽ erekou nũ. A'ere 'ã fariseu 'gã imonoi yrũũũ pype. Aipo 'gã erekou ifaa imỹina weapykag are, ojywa are 'jau. “Tiporesak 'gã ore ree 'jau kwy”, 'jau 'gã 'ã ajemogyau. “'Gã te a'jea futat Jarejuwarete 'ga ree iporomutarete ma'ea ra'e, te'i 'gã janee jane resaka 'jau”, 'jau 'gã akou ojeupe. Jane 'ã kũima'eramũ juejue taity pẽũ'ĩ sireko jarejasi'y'warimũ. A'e pyu jane 'ã jareakaga au'jau Jarejuwarete 'ga upe jareporogytauwe. A'ere 'ã fariseu 'gã imopypireme'ytyra fukui oma'ea. “Tiporesagete 'gã jane ree 'jau”, 'jau 'gã 'ã ajaupe. A'eramũ 'gã taity pypireme'ytyra fuku rerekou— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","—Maraka apoaw ipe ojemi'waaw ipe nanẽ 'gã na'ne wẽjẽmĩ awau wapyka. Kũima'eeteete 'gã apykaw ipe etee 'gã wapygiweramũ. Jarejatykaaw ipe nanẽ 'gã kũima'eeteete 'gã apykaw ipe etee wapygiweramũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Amunawa pyterimũ awaw ipe nanẽ 'gã kũima'eeteete 'gã 'jawe wapeje'ega 'gã ifutaa. “Moromu'jara 'ga” ojeupe 'ga amũ 'eramũ 'gã aku'iramũ ajemogyau— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—A'ere kasi pejemogy 'gã 'jawe ne. “'Ga 'ã ore mu'jara”, 'gã mu'eukare'ema pejejeupe. Majepei tee tup ma'e 'jawe futat pẽẽ pejeju'jaju'jawe etee pejemogy. Majepei tee futat je pẽ mu'jaramũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","—Kiapi'ni pe'je nanẽ kasi pejejuwe'ema 'ga amũ upe ne. Majepei tee Pẽnuwaretea. Ywag ipe ako ma'eramũ etee futat Pẽnuwaretea. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“'Ga nanẽ 'ã ore'wyriara”, 'gã amũ mu'eukare'ema nanẽ pejejeupe nũ. Janeruwarete 'ga remimureramũ etee te je pẽ'wyriaramũ je rekoi— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","—A'jea futat je 'i. Pejejaupe mama'e apoaramũ pẽẽ eteete ma'ea Jarejuwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","“Je te 'ã kũima'eeteetea” 'jara Janeruwarete 'ga imogyau tywet. A'ere 'ga “Je nakũima'eeteete arũi” 'jara 'gã etee 'ga mogyau kũima'eeteeteramũ 'gã nupe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","A'eramũ Jejui 'ga 'jau fariseu 'ga nupe nũ, Moisesi 'ga remikwasiarer are moromu'jara 'gã nupe we futat: —Pẽporiay'i pejejemogyau numiamũ. Esage ma'e 'jawe futat nipo pẽẽ numiamũ. A'ere nipo anure Janeruwarete 'ga pẽ nereko tyweri futari. Nepefutari te 'ã Jarejuwarete 'ga remiayuwamũ pejejemogya. A'eramũ nipo pẽẽ 'ga remiayuwamũ 'gã jemogy futare'ema nanẽ nũ. A'eramũ nipo anure Janeruwarete 'ga pẽ nerekou tyweaete— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Pẽporiay'i pejejemogyau numiamũ— 'jau Jejui 'ga Moisesi 'ga remikwasiarer are moromu'jara 'gã nupe, fariseu 'gã nupe nanẽ 'ga 'jau nũ. —Kwe pe 'ã peo amunawa moymoyka kwe pewara 'gã amũ mu'jau pejejee etee. Pejejemiapo are te 'ã pemu'e 'gã. A'eramũ nipo pẽẽ 'gã mu'jau pejejemiapo are te. “Pe'je pejejemu'jau je ree”, 'jau nipo pẽẽ 'gã nupe numiamũ. A'ere nipo anure Janeruwarete 'ga wowase pẽ majatykaaw ipe nipo 'ga 'i pẽ nupe: “Je rerowiat 'me etee pejepe. A'eramũ pẽẽ pejea'wyre'emamũ jee”, 'jau nipo 'ga pẽ nupe, pẽ monou mama'eukwaawa rapyaw ipe. A'eramũ nipo 'ga pẽ nee ojemu'e ma'efera 'gã nupe 'jau: “Je rerowiat 'me are etee pejemu'e. A'eramũ pẽẽ pejea'wyre'emamũ jee. A'eramũ je mama'eukwaawa rapyaw ipe pẽ momopoa”, 'jau nipo 'ga pẽ nee ojemu'e ma'e 'gã nupe, 'gã monou mama'eukwaawa rapyaw ipe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Pẽporiay'i futat pejejemogyau numiamũ. A'ere pẽẽ Jarejuwarete 'ga ree moromu'jat tyweramũ pejemogy. Nepẽneapyoi agawewi 'ga je'eg are. A'etea nipo pẽẽ 'gã mu'jau 'me ee— 'jau 'ga 'gã nupe. —“Jarejuwarete 'ga mogytaawa renamũ je mama'e apoi enee 'e ekoete re nepeapoi futari mama'ea ee pejeparuapowere'emamũ”, 'jau pẽẽ 'gã nupe. “A'ere ki Jarejuwarete 'ga mogytaawa pypiara ouru apopyrera renamũ je mama'e apoi enee peje'e re mama'ea peapo futat peje'eawer imũ. Kasi a'e pe pejemotywet Jarejuwarete 'ga upe ne, mama'e apoe'em ire ne”, 'jau 'ã pẽẽ pejejemogyau pejejaupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","—A'eramũ taetu nipo peje'akwaawe'emetyg etee te. Maranuara sipo esage ma'eramũ Janeruwarete 'ga upe? 'Ga mogytaawa tee esage ma'eramũ 'ga upe. Ouru apopyrera 'ũi 'ga mogytaawa pype. A'eramũ wesageramũ 'ga upe. Omogytaawa pype tene'em ire amunipo 'ã 'ga naea'ari ee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—“Jarejuwarete 'ga upe wyra rapyawa ruwamũ je mama'e apoi enee 'e ekoete re nepeapoi futari mama'ea peje'eawer imũ ee pejeparuapowere'emamũ”, 'jau pẽẽ pejejemogyau. “A'ere ki Janeruwarete 'ga upe jeremimonofera 'up wyra rapyawa 'arimũ 'e re mama'ea peapo futat peje'eawer imũ. Kasi a'e pe pejemotywet Jarejuwarete 'ga upe ne”, 'jau 'ã pejejemogyau 'gã mu'jau tywet. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Peje'akwaawe'emamũ futat nipo pẽẽ pejejemogyau. Maranuara ajee esage ma'eramũ Janeruwarete 'ga upe? Mama'ea jane imỹina wyra rapyawa 'arimũ Jarejuwarete 'ga upe imonopyramũ. A'eramũ 'ã wyra rapyawa i'arimũ 'up ma'e retee wesageramũ 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","—“Janeruwarete 'ga upe wyra rapyawa ruwamũ je mama'e apoi enee” 'jaramũ pẽẽ i'arimũ 'up ma'e upe nanẽ futat pe'je poromũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Jarejuwarete 'ga mogytaawa renamũ je mama'e apoi enee” 'jaramũ pẽẽ Jarejuwarete 'ga upe nanẽ futat pe'je poromũ. Omogytaawa pype futat 'ga reni. A'eramũ pẽẽ aipo 'jaramũ 'ga upe futat 'jau pejejemogyau aipo 'jaramũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","—“Ywaga ruwamũ je mama'e apoi enee” 'ga upe 'jaramũ nanẽ Jarejuwarete 'ga renawa upe futat pe'je nũ. Ywag ipe futat 'ga renawaretea. A'eramũ aipo 'jara 'gã 'ga renawa upe futat 'jau poromũ. 'Ga renawa renũinara 'gã Jarejuwarete 'ga futat wenũi. Wenawa 'arimũ futat 'ga reni. A'eramũ 'ga renawa renũinara 'gã 'ga futat enũina— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Pẽporiay'i pejejemogyau numiamũ— 'jau 'ga Moisesi 'ga remikwasiarer are moromu'jara 'gã nupe, fariseu 'gã nupe nanẽ nũ. —Pẽẽ 'ã esage 'me ma'ea te. A'eramũ nipo anure Janeruwarete 'ga pẽ nerekou tyweaete pẽtywer are. Nepekoarũi futari te 'ã 'ga upe. A'eramũ nipo 'ga pẽ nerekou tyweaete pẽtywer are. Mama'ea pẽẽ imojo'oka pejepo 'jawe pejejeupe. Ko pypiara nanẽ pẽẽ imojo'oka nũ. A'eramũ pẽẽ majepeja monou Jarejuwarete 'ga upe. A'eramũ emyrera pẽma'ea. Kumi kasiga miamũ pẽẽ imojo'oka imonou Jarejuwarete 'ga upe. Nanuara te esage 'ga upe numiamũ. A'ere namĩa etee rũi peapo. “Mama'ea pemojo'ok amũ imonou jee” 'ga 'eawera 'ã pẽẽ enupa. Aipoa pẽẽ iapoa Janeruwarete 'ga afutat. A'ere 'ã ajepeja 'ga 'eawera nepeenuwi futari. “Pejuereko esage ki” 'ga 'eawera nepeenuwi. “Pẽpota'wa esage ki pejejuee” 'ga 'eawera nepeenuwi. “Pejejaupe peje'eawer imũ etee futat pẽẽ mama'e apou pejejaupe” 'ga 'eawer imũ jẽmĩ 'ã mama'e apowe'em— 'jau 'ga 'gã nupe. —“Pejuereko esagea te esage Janeruwarete 'ga upe. 'Gã nee pẽpota'wa esagea nanẽ esage 'ga upe nũ” 'ea te esage ete 'gã upe. Mĩmera pẽẽ iapoa Janeruwarete 'ga afutarete. Peenupaw iki 'ga 'eawera 'ga je'ega— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","—'Ga 'eawera jẽmĩ 'ã nepeapoi. A'eramũ 'ã pẽẽ 'ga 'eawere'ema jẽmĩ iapou— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Pẽporiay'i pejejemogyau numiamũ— 'jau 'ga Moisesi 'ga remikwasiarer are moromu'jara 'gã nupe, fariseu 'gã nupe nanẽ nũ. —Pẽẽ 'ã esage 'me ma'ea te. A'eramũ nipo anure Janeruwarete 'ga pẽ nerekou tyweaete pẽtywer are. Sã'ã ae y'a kupe pireja futat numiamũ. A'ere 'ã ae waipy katy nokatu'ogi. Nan tee futat 'ã pẽẽ. Pẽpira esageay futat numiamũ. Pejauk futat pejepiky'a awi numiamũ. A'eramũ 'ã pẽpira ojekatu'oka futat numiamũ. A'ere pẽywytera nia'wyri. Nepepoiri futari mama'e tywera apo awi— 'jau Jejui 'ga 'gã nupe oporogytau 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","—Pẽ'akwaawe'ema pẽ nereko, a'e je 'ã pẽ nupe jã'nũ'ũ. Janeruwarete 'ga 'ã pẽ katu'oga futaa numiamũ. Napẽpira katu'og are tee rũi 'ga fueweramũ. Pẽywytera katu'oga we futat 'ã 'ga afutat numiamũ. Pẽporiay'i 'ã pejejemogyau numiamũ— 'jau 'ga oje'ega moywyrafena 'gã nupe. —Pejetywer awi pepoir ire amunipo 'ã 'ga pẽ katu'ogi. A'eramũ amunipo 'ã pẽẽ pejejesageramũ pejejemogyau 'ga upe, a'e je 'ã tekou pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Pẽporiay'i pejejemogyau numiamũ. Pẽẽ 'ã esage 'me ma'ea te— 'jau 'ga Moisesi 'ga remikwasiarer are moromu'jara 'gã nupe. Fariseu 'ga nupe nanẽ 'ga 'jau nũ. —A'eramũ nipo anure Janeruwarete 'ga pẽ nerekou tyweaete pẽtywer are. Sã'ã teumera rupawa ita kwara. A'eramũ 'ã pẽẽ ita pitupa ipitupawa parasiga pyu. A'eramũ 'ã i'arimũ etee okaturãturamamũ. A'ere 'ã ita kwara pype teumera nema ete. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nan tee futat pẽẽ. Esage ma'e 'jawe futat pejemogy numiamũ. A'ere mama'e tywera peapo, o'meramũ te pe'je pejejemogyau— 'jau Jejui 'ga oje'ega moywyrafena 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Pẽporiay'i pejejemogyau numiamũ— 'jau Jejui 'ga Moisesi 'ga remikwasiarer are moromu'jara 'gã nupe, fariseu 'gã nupe nanẽ nũ. —Esage 'me ma'e ate pẽẽ. A'eramũ nipo anure Janeruwarete 'ga pẽ nerekou tyweaete pẽtywer are. Pẽypy 'gã 'ã Jarejuwarete 'ga mome'wara 'gã je'ega nuenuwi etee rakue. Ma'eramũ 'ã 'gã 'gã apisi rakue. A'eramũ 'ã pẽẽ iapisipyrera rywy mojewaka. Ita esage apopyrera pyu imogyau ekoete iapisipyrera 'arimũ. “Ita esagea simowyt esage ma'efera 'gã nee jarejea'awamũ 'jau”, 'jau futatee 'ã pẽẽ pejejaupe rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","—“Ymã we jarejeko re amunipo 'ã jane nipoari jareypy 'gã Jarejuwarete 'ga je'ega mome'wara 'gã apisi are. Niapisiukari amunipo 'ã jane 'gã”, 'jau futatee 'ã pẽẽ pejejaupe, pejejerowiaraipa 'ã pejejee. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","A'ere 'ã pẽ'me ate. A'ere 'ã pejeypy 'gã 'jawerimũ etee futat pejemogy— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","—Pejeypy 'gã 'jawerimũ etee pejejemogy re nipo pejemogy mama'e apou 'gã 'jawerimũ etee futat. A'eramũ nipo Janeruwarete 'ga pẽ nerekou tyweaete 'gã 'jawerimũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Moja 'jawe pẽẽ. Sã'ã moja ae u'ua ae jukau 'ã. Nan tee futat pejomomoirukat Jarejuwarete 'ga rerowiar awi. A'eramũ nipo anure Janeruwarete 'ga pẽ monou pẽ mogyau mama'eukwaawa rapyaw ipe pẽtywer are— 'jau Jejui 'ga oje'ega moywyrafena 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","—Anure nipo je teje'ega mome'wara 'ga monoi pẽ nupe. I'akwaap ma'e 'gã, pẽ mu'jara 'gã. Mĩmera 'gã nipo je imonou pẽ nupe. A'ere nipo pepyyg etee 'gã amũ iapisau. Amumera 'gã nipo pẽẽ imonou imu'ama 'ypeywar are iapisau. Amumera 'gã nipo pẽẽ inupãnupãu etee pejejatykaaw ipe. A'eramũ nipo 'gã oka'jama awau kwe pe. Ajepeja amunaw ipe nipo 'gã awau. A'ere nipo peo etee 'gã newiri 'gã nerekou tyweru'japa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","A'eramũ nipo a'e are futat Janeruwarete 'ga werowiaara 'gã nepyaa pẽ nerekou tyweaete. Pẽypy 'gã nemiapofer are we futat nipo 'ga pẽ nerekou tyweaete. Pẽypy 'gã 'ã Jarejuwarete 'ga je'ega mome'wara 'gã apisau ekoete rakue. Ywy apo ypyrauwe 'ã 'gã 'ga rerowiaara 'gã apisi rakue— 'jau Jejui 'ga 'gã nupe 'ũina. —Apeu 'ga ra'ne 'ã 'gã ijukau ypy ypy rakue. Nuapoi agawewi 'ga 'ã mama'e tywera rakue. A'etea 'ga 'ã 'ga jukau ekoete rakue. Ma'eramũ 'gã 'ã 'awamũ taetu Jarejuwarete 'ga rerowiaara 'gã apisi kwaiwete. 'Awamue 'gã 'ã Sakari 'ga, Pereki 'ga ra'yra 'ga jukau rai'i nũ. Jarejuwarete 'ga rukawõ'õ me agawewi 'ga 'ami. A'etea 'ã 'gã 'ga jukau rai'i— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","—A'jea futat je'ea. Anurenure'i nipo Janeruwarete 'ga pẽ nereko tyweretei 'gã nepyaa, iapisipyrera 'gã juejue epyaa— 'jau Jejui 'ga oje'ega moywyrafena 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","A'eramũ 'ga 'jau Jerusareg ipewara 'gã nupe: —Jerusareg ipewaramũ futat te 'ã pẽẽ Jarejuwarete 'ga je'ega mome'wara 'gã apisaramũ pejup— 'jau Jejui 'ga 'gã nupe. —Sã'ã wyrasokwẽa kwanũ resakawe wa'yra renũja imajatykau wakape 'wyripe. Nan tee futat je— 'jau Jejui 'ga 'gã nupe. —Tajejuka esage Jerusareg ipewara 'gã nee 'jau, je 'i pẽ nupe numiamũ. A'ere 'ã nepefutari etee. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A'eramũ 'awamũ Janeruwarete 'ga opoia futat pẽ nui— 'jau Jejui 'ga 'gã nupe. —A'eramũ nipo pẽ nee iporomutare'ema 'gã 'ua pẽ'wyrarete pojekau pẽ nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","'Awamũ 'ã je nanẽ tewau pẽ nui nũ. A'eramũ pẽẽ 'awamũ je resagu'jape'ema. “Esageay Janeruwarete 'ga remimurera 'ga”, 'jawe'ẽwe pẽẽ je resagu'jape'ema futat— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","'Gã nupe oporogytapaw ire Jejui 'ga wemimu'eramũ ore renũ'jãu Jarejuwarete 'ga mogytaaw awi. Jui aru'ẽ re ore 'jau 'ga upe: —Kuu. Ikaturam te Janeruwarete 'ga mogytaawa 'oga jã'nũ'ũ— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A'eramũ 'ga 'jau oree: —A'jea futat esageramũ numiamũ. A'ere nipo anurenure'i jane ree iporomutare'ema 'gã nuri imonou etyka. Nomỹi'i futari nipo 'gã itaa mũ aju'arimũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Arawau ywytyr ipe. Oriweira 'jaw ipe ore arawau orojeupia ywytyra 'arimũ. A'eramũ Jejui 'ga wapyka opytu'wau. Nitywi futari 'ga amũ ore pyri. A'eramũ ore 'ga rerowyka 'jau 'ga upe: —“Jane ree iporomutare'ema 'gã 'ut Janeruwarete 'ga mogytaawa monou etyka”, ere ako oree ko. Maranime te 'gã nuri imonou etyka? Maranime sipo ene ejua nũ? Ma'ja ra'ne sipo ajee ojesaukat oree ene rur enune? Maranime sipo mama'e teepawamũ?— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A'eramũ Jejui 'ga 'jau oree: —Je renune 'ut ma'e 'gã nipo i'me ma'ea. Perowiat kasi 'gã 'mea ne. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Anure nipo kwaiwete 'gã nuri “Janeruwarete 'ga je mut pẽ katu'okaramũ”, 'jau nipo 'gã 'ua pẽ nupe. A'ere kasi perowiat 'gã ne. O'meramũ te nipo 'gã 'i. Kwaiwete nipo 'gã 'gã moryteeu ojee— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","7","—Anure nipo amutee amunaw awi 'gã nuri 'wyriararete 'ga rowajaa, 'ga remiayuwa 'gã neewe futat. A'ere kasi aipo renupa pẽpiryyi ne. Nan futat nipo mama'e teepaw enune. A'ere nipo naporomũ rũi mama'e mateepaawa. Naporomũ etee rũi futat nipo mama'e rekoi— 'jau Jejui 'ga oree. —Akou'jau'jap futat nipo mama'ea. Amunap tesirũmera pypewara 'gã we futat nipo ajuowajat. Ywya we futat nipo oyyi peu peu peu 'jau. Ty'ara nipo amunawa pype peu peu 'jau. A'eramũ 'gã nipo kwaiwete ty'ara rerekou. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sã'ã kũjã wa'yra ray ypyrauwe wa'yra 'a ja'wyja'wy kwaawa. Ayypeyperauwe 'ã i'ara kwaapa. Ẽẽ wi u'aa ja'wyja'wy taetu 'ã wayreteramũ ẽẽ upe. Nan tee futat nipo pẽẽ. Aipo ijeapo resakawe je rura pekwaap. “Owaẽm 'ga ruawa upe ra'e”, 'jau nipo pẽẽ pejejaupe. A'ere nipo je rur enune mama'e tywera jeapoi kwaiwete— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Je rure'emauwe nipo 'gã je rerowiaaramũ pẽ nerekou tyweaete. Oporomutare'emamũ jeremiayuwamũ pẽ nee. A'eramũ nipo pẽ nee iporomutare'ema 'gã pẽ pyyka pẽ monou pẽ munepa moromunepawa pype. A'eramũ nipo 'gã pẽ nerekou tywerukaa 'gã nupe. A'eramũ nipo 'gã pẽ apisaukaa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aipo jeaporamũ nipo 'gã kwaiwete opoia je rerowiar awi. Je wi opoir ire nipo 'gã oporomutare'emamũ je wi ipoire'ema 'gã nee. A'eramũ nipo 'gã 'gã monou 'gã nee ifuewerete ma'e 'gã po pe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","—A'ere nipo 'gã kwaiwete 'ua o'meramũ tekotee 'gã nupe. “Je te 'ã Jarejuwarete 'ga je'ega mome'waramũ”, 'jau futatee nipo 'gã 'gã nupe. A'eramũ nipo 'gã 'gã moryteeu ojee. A'ere 'gã o'meramũ te 'gã 'i. A'eramũ nipo 'gã kwaiwete 'gã nerowiaa. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A'eramũ nipo mama'e tywera apoara 'gã ojeme'yita ajemogyau. Mama'e tywera etee nipo 'gã iapou'jau'japa nũ. A'eramũ nipo 'gã kwaiwete opoia je ree oporomutar awi. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","A'ere nipo Janeruwarete 'ga je rerowiar awi ipoire'ema 'gã nerooi imogyau ojepyri nakwaparimũ warãu rũi futat— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","—Mama'e teepawe'emauwe nipo pẽẽ je rerowiaaramũ pejewau je mome'wau 'gã nupe. “Jejui 'ga rerowiaara 'gã Janeruwarete 'ga 'gã omogy wemiayuwamũ”, 'jau nipo pẽẽ pejewau je mome'wau 'gã nupe, amunawa moymoyka. Kwe pewara 'gã jerera renupaw ire te nipo mama'e teepawamũ. A'eramũ futat nipo tejua— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Ymã te 'ã Janeruwarete 'ga ijeaporama kwasiarukari oje'ega mome'wara 'ga upe rakue, Danieu 'ga upe rakue. “Anure nipo 'gã amũ mama'e tywetywera apoi Jarejuwarete 'ga mogytaaw ipe”, 'jau 'ga ikwasiaa inuga janee rakue. A'eramũ nipo 'gã anurenure'i iapou Danieu 'ga 'eawer imũ etee futat. (A'eramũ je 'ga remikwasiarera ka'arana mogytaaramũ ee pẽneapyoa futaa)— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","21","A'ere Jejui 'ga 'jau oree nũ: —Anure nipo 'gã amũ nuri 'auwara rerekou tyweaete. Ywy apo ypyramũ nitywi futari ae rereko tyweara aipo 'jawe rakue. A'ere nipo anure mama'earũe'em ete jesaukari. 'Auwara 'gã nipo ajemogyau tywetywet futat. A'eramũ pẽẽ Judeja ywy pe ako ma'eramũ 'gã nesakawe pejeka'jama pejewau ywytyr ipe. Kasi a'e pe 'gã pẽ apisi ne. Pejejopewuu apyte'rarimũ wapyk ma'eramũ pẽẽ pejewawe'em pejesowe'em pejekaraemã pyyke'ema. Pejeka'jamayayau etee futat pejejemima 'gã nui. Ko pewaramũ nanẽ pẽẽ pejejewyre'ema pejejog ipe pejejaity mojopy'rawe'em— 'jau Jejui 'ga oree. —Iporiay'i nipo ta'yryrũ ma'e kũjã ajemogyau, ta'yky'ri ma'ea nanẽ nipo nũ. Nujãnarũi eweguu ma'ea. Ta'y'ri'i ma'ea nanẽ nujãnarũi nũ— 'jau 'ga oree. —A'eramũ ki nanuar are pejeporogytau Jarejuwarete 'ga upe ee: “Eremurukat kasi 'gã 'ara ro'ysaga rupi oree ne. Morowykye'ema rupi nanẽ ene 'gã murukare'ema nũ. Morowykye'ema rupi ore noroka'jama'uweri. Ymã te 'ã Moisesi 'ga 'i oreypy 'gã nupe rakue: ‘Peata kasi morowykye'ema rupi ne’, 'jau 'ã 'ga rakue. A'eramũ ore oroka'jamarũme'em morowykye'ema rupi 'gã nui”, pe'je ki Jarejuwarete 'ga upe ee— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","—A'ere Janeruwarete 'ga mama'e tywera 'gã nupe iapoukaru'jau'jaw ire nipo 'ga 'gã muojeri 'gã mogyau jui nũ. Kasi a'e pe ywy pewaramũ pepap najuejue etee ne. A'ere Janeruwarete 'ga pẽẽ mũ mũ'jãu 'gã nui pẽ katu'oka. Wemimũ'ẽmeramũ pẽ nee Janeruwarete 'ga 'gã muojeri 'gã mogyau jui nũ— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","—Je jewyre'emauwe nipo kwaiwete 'gã nuri o'meramũ pẽ nupe. “Je Jarejuwarete 'ga je'ega mome'waramũ”, 'jau futatee nipo 'gã 'ua pẽ nupe. Amumera 'gã nipo 'ua 'jau “Janeruwarete 'ga je mut. Je 'ga remimurera futat”, 'jau futatee nipo 'gã pẽ nupe. Pẽnemiapoe'ema we futat nipo 'gã iapou pẽ neape je rerowiar awi pẽ momoirukaawamũ. “Simomoirukat 'gã Jarejuwarete 'ga rerowiar awi 'jau”, e'i te 'gã pẽ nupe. A'eramũ nipo 'gã mama'e apou pẽ neape ojerowiarukaawamũ pẽ nupe. A'ere kasi a'e are miamũ perowiat 'gã ne. Pẽ nupe nipo 'gã amũ 'jau: “Koromũ Kristu 'ga”, 'jau nipo 'gã amũ pẽ nupe. A'ere kasi perowiat 'gã ne. “Kwe pe Kristu 'ga oi”, 'gã 'eramũ pẽẽ 'gã nerowiare'ema. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pemoka'jam kasi je'eawera ne. Ijeapoe'emauwe je imome'ui pẽ nupe, ee pẽ mueapyoawamũ— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—“Jũ me Kristu 'ga rekoi. Pe'je pejewau 'ga resaka”, 'gã 'eramũ kasi peo jũ me ne. O'meramũ te 'gã 'i pẽ nupe. “Pe'je pejejua Kristu 'ga resaka. 'Au 'ga jemimi 'ũina ore pyri”, 'gã 'eramũ kasi perowiar ine. O'meramũ te 'gã 'i. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pejejeki'yramũ je jewyramũ nipo najuejue etee je resak pejepe. Sã'ã tupã werawa. A'eramũ 'ã ae najuejue etee esaka. Nan tee futat nipo je jewyramũ najuejue etee je resak pejepe. Najemimi futari je tejewya tejua nũ— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","—Je rura nipo pẽẽ najuejue etee ikwaapa. Sã'ã uruwua mama'e nema kwaawa. A'eramũ 'ã 'ua ajatykau ee. Nan tee futat nipo pẽẽ ikwaapa. Je jewyru'jawamũ nipo pẽẽ je kwaapa katu katu futat— 'jau Jejui 'ga oree imome'wau ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Ae rereko tyweawa 'ara kwaw ire nipo kwara owepa. Jaya nanẽ nipo owepa nũ. Jaytataa nipo ototoka ywag awi 'ua. Ywag ipewara nipo oyyita nũ. Kwat, jay, jaytata. Mĩmera nipo oyyita— 'jau Jejui 'ga oree imome'wau ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","—Ywag ipe nanẽ nipo mama'e ojesaukaa pẽ nupe nũ. Aipo resaga nipo pẽẽ je rura kwaapa. “Anurenure'i nipo Jejui 'ga ruri”, 'jau nipo pẽẽ pejejaupe. Aipo resaka nipo je rerowiare'ema 'gã okyjau. 'Gã kyjea nipo 'gã nerekou— 'jau Jejui 'ga oree. —A'erauwe nipo pẽneki'yramũ je tejua tejewya. Ywasiga rupi nipo tejua tejypa. A'eramũ nipo ywy pewara 'gã je resaka najuejue etee futat. Tepãjẽ mũ nipo je ruri, tejenyfuga pype futat nipo tejua tejypa— 'jau 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","—A'e pype futat nipo pẽẽ jumi'aranũũ py renupa. Jumi'aranũũ pyrauwe nipo Janeruwarete 'ga ywagipewara 'gã monou wemiayuwa 'gã majatykaukaa. “Pe'je pejewau amunawa moymoyka jeremiayuwa 'gã majatykau 'gã nerua jee”, 'jau nipo 'ga 'gã nupe. A'eramũ nipo 'gã awau 'gã nerua 'ga upe— 'jau Jejui 'ga imome'wau oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","A'ere Jejui 'ga mama'e mũ mome'wau oree nũ, ore mu'jau ee: —Mama'ea je amome'u pẽ nupe pẽ mu'jau tejuaw are— 'jau 'ga oree. —Sã'ã ae siaka'gywa potyramũ amana jewyra kwaawa. Ipotyrauwe 'ã ae amana jewyt ja'wyja'wy kwaapa. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nan tee futat ki je'eawer imũ mama'e jeaporamuerauwe pe'je pejejaupe: “'Ut ja'wyja'wy Jejui 'ga janee 'wyriaramũ akou ra'e”, pe'je ki pejejaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A'jea futat je 'i. Je'eawer imũ mama'e jeapo resakara 'gã papawe'emauwe nipo je ruri tejewya nũ— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","—Ywaga nipo ateepawamũ futat. Ywya nanẽ nipo ateepawamũ futat nũ. A'ere nipo jeremimome'ufera nateepawa'uweri futari. Je'eawer imũ etee futat nipo aipoa ojeapou— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Nitywi futari je ruawa kwaapara 'gã amũ. Nepekwaawi futari je ruawa. Ywagipewara 'gã miamũ nokwaawi. Je miamũ nanẽ nakwaawi tejuawa 'ara. Jeruwarete 'ga etee te okwaap. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","A'ere nipo anure je ruru'jawi erujewi pẽ nupe. Je kwaapare'ema 'gã nipo aipoa 'ara rupi ajemogyau oporowykyau. Ojemi'waa, wemirekoramũ 'jau nipo ajemogyau. Wemiapo apo are tee futat wea'aramũ ajemogyau— 'jau Jejui 'ga 'gã nupe u'ama. —Janeruwarete 'ga ree jẽmĩ nipo 'gã wea'are'emamũ ajemogyau. Sã'ã Nue 'ga rekoramũ 'gã jemogya rakue. Janeruwarete 'ga ree 'gã 'ã wea'are'emamũ ajemogyau rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nokwaawi futari 'gã Janeruwarete 'ga remiaporama rakue. Poje 'ga 'ã amana mua erujewi 'gã nupe rakue, 'gã apisaukaa 'y pyu rakue. Nan tee futat nipo je ruri erujewi 'gã nupe. Wemiapo are etee 'gã nea'at 'gã jemogyramũ nipo je tejua erujewi 'gã nupe— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","—Je jewyramũ nipo mukũja 'gã akou oporowykyau oko pe. A'eramũ nipo majepeja 'ga je rerowiaa. A'eramũ nipo 'ga awau ojeupia je repejãna. Ajepeja 'ga nipo naje rerowiari. A'eramũ nipo a'e 'ga awawe'em. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kũjãmera 'gã nanẽ nipo 'upa mukũi ygu'ai nũ. A'eramũ nipo majepeja ẽẽ awau je repejãna. A'eramũ nipo ajepeja ẽẽ awawe'em. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Je ruawa 'ã nepekwaawi futari. A'eramũ ki pẽẽ pejetywer awi pejepoia pejejemogyau je rapesaka— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","—Sã'ã 'oga jara 'ga muna'ywa rura kwaawe'ema. Muna'ywa rura kwaaw ire amunipo 'ã 'oga jara 'ga woga rarũi 'ũina. A'ere 'ga nokwaawi futari muna'ywa rura wog ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nan tee futat nepekwaawi pejejeki'yramũ je ruawa. A'eramũ ki pẽẽ pejejemogyau au'jeteramũ je rapesaka pejeojere'emamũ futat je rerowiaramũ— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","A'ere Jejui 'ga mama'e mũ mome'wau oree, ore mu'jau 'uaw are nũ. —'Wyriara 'ga remiayuw esage 'ga i'akwaap ma'ea. O'wyriara 'ga je'eg imũ etee futat 'ga mama'ea wapo. A'eramũ 'wyriara 'ga wata enune wemiayuw esage 'ga mỹina wemiayuwa 'gã nesakawamũ. “Aata je. A'eramũ je ene mỹina 'gã nesakawamũ”, 'jau 'wyriara 'ga wemiayuw esage 'ga upe. “Mama'ea ki emono 'gã nupe 'gã nemi'uramamũ”, 'jau 'ga 'ga upe. A'eramũ nipo 'ga 'wyriara 'ga awau watau 'gã nui. Anure nipo 'ga ojewya 'ua nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'Ga 'eawer imũ etee mama'e apo re nipo 'wyriara remiayuw esage 'ga aku'iramũ 'ũina o'wyriara 'ga resakawe. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'Wyriara 'ga nanẽ nipo aku'iramũ wemiayuw esage 'ga ree nũ. 'Ga porowyky resag ire nipo 'ga 'ga mỹina okaraemã are ojejuka ma'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A'ere nipo ajepeja 'wyriara 'ga remimỹimera 'ga 'i ojeupe: “Mukuu nã'ã je'wyriara 'ga oi re'ã, oporomukuramũ re'ã”, 'jau nipo 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","A'eramũ nipo 'ga opytuna 'gã nupã are etee futat 'ũina. A'eramũ nipo 'ga awau ojemi'waa kawĩajaiwa 'wara 'gã pyri. A'eramũ nipo 'ga kawĩajaiwa rykua 'gã pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aipo aporamũ nipo 'ga 'wyriara 'ga 'ua owaẽma erujewi 'ga upe. Wapesage'emeteramũ nipo 'ga 'ua owaẽma erujewi 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A'eramũ nipo 'wyriara 'ga wemiayup tywera 'ga mopẽpẽpẽpena 'ga monou tata pe i'me ma'e 'gã pyri. Peu nipo 'ga waemamũ akou wa'jywa mokãina akuwa rerekou— 'jau Jejui 'ga imome'wau oree. —Jeje'eg imũ etee futat mama'e apoaramũ pẽẽ 'wyriara remiayuw esage 'ga 'jawe jee. Jeje'eg imũ etee mama'e apoare'emamũ pẽẽ 'wyriara remiayup tywera 'ga 'jawe jee. A'eramũ ki pẽẽ pejejemogyau 'ga remiayuw esage 'ga 'jawe. A'eramũ nipo je tejua 'jau pẽ nupe: “Pẽẽ 'ã jeremiayuw esageramũ. Pe'je pejejua pejesou jeruwa 'ga rog ipe je rupi”, 'jau nipo je pẽ nupe— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","A'ere Jejui 'ga mama'e mũ mome'wau oree ore mu'jawamũ nũ. 'Wyriaramũ Jarejuwarete 'ga omogo are 'ga ore mu'jau. —Anure nipo Janeruwarete 'ga je mogoi 'wyriaramũ pẽ nupe— 'jau 'ga oree. —A'eramũ nipo pẽẽ je ruramũ pejewau je rupi, Jeruwarete 'ga pyri. A'ere nipo 'gã amũ nooi futari. Sã'ã maraka apoaw ipe oo ma'e 'gã. Opytuna 'gã nekokaturamũ 'gã 'ã maraka apoa. A'eramũ 'ã kũjãmuku 'gã awau akokatu ma'e 'ga rapesaka maraka pe okwap ma'e 'gã napesaka. Teis 'ã kũjãmuku 'gã awau 'gã napesaka 'upa. “Ko rupi nipo wã kwawi”, 'jau 'gã 'upa. “A'eramũ jane jarejupa 'au wã napesaka. Wã nuramũ soo wã nupi maraka pe 'jau”, 'jau 'gã ajaupe 'upa. A'eramũ 'gã 'upa peyse pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sĩku nipo i'akwaap ma'e 'gã kũjãmuku 'gã. Sĩku wẽjẽmĩ i'akwaawe'ema 'gã 'upa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","I'akwaawe'ema 'gã arãparĩna pyyka erawau. A'ere 'gã nuerooi miarakawenana tyramũ ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","I'akwaap ma'e 'gã te ajee miarakawenana weroo tyramũ ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A'ere nipo akokatu ma'e 'gã poromukuramũ 'ua 'gã nupe. A'eramũ nipo 'gã wopeyjamũ 'upa— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—A'eramũ nipo ypyaje 'ga amũ 'ua wafukaita 'gã nupe. “Kwe 'gã nuri. Pe'je pejejua pejepaka pejewau 'gã nowosõu”, 'jau nipo 'ga 'ua 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A'erauwe nipo kũjãmuku 'gã opaka arãparĩna monyka. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A'eramũ nipo i'akwaawe'ema 'gã 'jau: “Miarakawenana pemut ara oree. Orema'ea owep ja'wyja'wy ore wi”, 'jau nipo 'gã miarakawenana rerekwara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A'ere nipo miarakawenana rerekwara 'gã 'i etee 'gã nupe: “Naani. Pẽ nupe ore imono re orema'e wewi ne. Pekwap ara mua pejejeupe”, 'jau etee nipo 'gã 'gã nupe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—A'eramũ nipo i'akwaawe'ema 'gã awau miarakawenana mua. A'ere nipo miarakawenana muaw awi 'gã jewyra'ne'emauwe akokatu ma'e 'gã nuri. A'eramũ nipo miarakawenana ojeupe erawarera 'gã etee awau akokatu ma'e 'ga rowosõu. A'eramũ nipo 'gã osou maraka apoaw ipe 'gã nupi. 'Gã nesepaw ire nipo maraka'ywa 'ga 'okwara motypa 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—A'ere'ere'i nipo miarakawenana muaw awi ojewyt ma'efera 'gã 'ua owaẽma. A'eramũ nipo 'gã 'upa wafukaita ukupepe 'ga upe. “Ku'jyp. 'Okwara eawopytymo'wok oree. Torose orosou ore nanẽ 'jau nũ”, 'jau nipo 'gã 'upa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—A'ere nipo akokatu ma'e 'ga 'i etee 'gã nupe: “Pe'je pejewau ore wi. Najepytuna rũi pẽẽ”, 'jau etee nipo 'ga 'gã nupe— 'jau Jejui 'ga oree imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Imome'upaw ire Jejui 'ga 'jau oree: —Nan tee futat nipo nepekwaawi je ruawa 'ara. A'eramũ ki pẽẽ pejejemomoita etee pejejemogyau je rur are— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","A'ere Jejui 'ga mama'e mũ mome'wau oree, ore mu'jawamũ nũ, 'wyriaramũ Jarejuwarete 'ga omogoram are wẽjẽmĩ nũ. —Anure nipo Janeruwarete 'ga je mogoi 'wyriaramũ pẽ nupe. Mama'e mũ je amome'u pẽ nupe, pẽ mu'jawamũ ee— 'jau Jejui 'ga oree. —Kũima'e 'ga amũ nipo awau watau oje'wyr awi. Oo enune nipo 'ga wemiayuwa 'gã nenũina 'gã mua oporogytau 'gã nupe. “Oo je teatau pẽ nui”, 'jau nipo 'ga wemiayuwa 'gã nupe. “Jekaraemã pearũ jee”, 'jau nipo 'ga wemiayuwa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A'eramũ nipo 'ga ka'aranũũ ywope'i monou 'gã nupe. I'akwaap ma'e 'ga upe nipo 'ga imonou kwaiwete. Sĩku ka'aranũũ ywope'i monou 'ga upe. Mukũi tee nipo 'ga ka'aranũũ ywope'i monou i'akwaa'wi ma'e 'ga upe. I'akwaawe'ema 'ga upe 'ga majepei tee imonou. “Pemomytun jeka'aranũũa jee”, 'jau nipo 'ga 'gã nupe. 'Gã nupe imonopaw ire nipo 'ga awau watau 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—'Ga o ypyrauwe sĩku ka'aranũũ ywope'i rerekwara 'ga ojeupe 'ga remimurera rerawau mama'e mua ipyu. A'ere 'ga imuripyrera rerawau kwe pe ime'ega. Epyfera apyraapa ime'ega 'gã nupe. Aipo aporamũ 'ga o'wyriara 'ga ka'aranũũ ywope'i momytuna 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mukũi ka'aranũũ ywope'i rerekwara 'ga nanẽ nãnẽwẽjẽmĩ futat iapou nũ. Ojeupe 'ga remimurera momytuna 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A'ere majepei tee erekwara 'ga nanarũi iapoi. Uẽma ypy we 'ga ywy rywykaita 'ga poroywera mimawamũ. A'ere 'ga ityma imonou imỹina— 'jau Jejui 'ga imome'wau oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Anure wata ma'efera 'ga 'ua ojewya 'gã nupe nũ. A'eramũ 'ga wemiayuwa 'gã nenũina. “Maran sipo 'gã jeka'aranũũ rerekoi rai'i? Ome'yi sipo 'gã nai'i?” 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","—A'eramũ 'ga wemiayuwa 'gã nenũina. A'eramũ 'ga remiayuwa 'gã 'ua ajatykau 'ga ree, 'ga ka'aranũũ mome'wau 'ga upe. Sĩku rerekwara 'ga tãmẽjẽ 'ua 'jau 'ga upe: “Sĩku ako ka'aranũũ ywope'i eremut jee ikue. A'eramũ je erawau imomytuna enee ikue kũi. 'Awamũ teis eneka'aranũũ ywope'ia”, 'jau nipo 'ga erua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—A'eramũ nipo 'ga 'jau wemiayuwa 'ga upe: “A'jea futat. Ene 'ã jeremiayuw esagea futat”, 'jau nipo 'ga 'ga upe. “Inãinãnĩ'ĩ agawewi je ako imonoi enee ikue. A'ere 'ã ereme'yi jee rai'i. A'eramũ je ene mogou teka'aranũũ pyykaramũ tejeupe. Ere ejua eku'iramũ je pyri”, 'jau nipo 'ga 'ga upe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—A'ere mukũja rerekwara 'ga 'ua nũ: “Mukũi ako ka'aranũũ ywope'ia eremut jee ikue. A'eramũ je ime'yita enee ikue. 'Awamũ irũpãwẽ eneka'aranũũ ywope'ia”, 'jau 'ga 'ga upe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—A'eramũ 'ga 'jau aipo 'ga wemiayuwa 'ga upe: “A'jea futat. Ene 'ã jeremiayuw esagea futat ra'e”, 'jau 'ga 'ga upe. “Mukũi agawewi ako je imonoi enee ikue. A'ere 'ã ereme'yi jee rai'i. A'eramũ je ene mogou teka'aranũũ pyykaramũ tejeupe. Ere ejua eku'iramũ je pyri”, 'jau nipo 'ga 'ga upe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","—A'ere majepei tee ka'aranũũ ywope'i rerekwara 'ga 'ua 'jau 'ga upe nũ: “Kweramũ eneka'aranũũa. Namomyi etee je eneka'aranũũa. Akyje etee je ene wi. Akwaap je ene jepi. Enemara'ne 'ã ene. Emepy ekoetea te te 'ã erefutat ka'aranũũ pyu. A'eramũ 'ã ene eporowyky are jẽmĩ ejea'are'emamũ. A'eramũ je tekyjau ene wi ai'i, eneka'aranũũ momyawe'em ene wi ai'i. A'eramũ je eneka'aranũũ ywope'i auwana imima ywy kwara pype ai'i”, 'jau 'ga 'wyriararete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—A'eramũ nipo ka'aranũũ jara 'ga amara'neramũ 'ga ree. “Nenea'wyri futari te 'ã ene. Nenepokagi tãmẽjẽ futat te 'ã ene”, 'jau nipo 'ga 'ga upe. “Erekwaap futat te 'ã jemara'nea jepi. A'jea futat ere aipo 'jau jee. ‘Emepya te 'ã erefutat ka'aranũũ pyu. A'eramũ 'ã ene eporowyky are jẽmĩ ejea'are'emamũ’, ere ako jee ko. A'jea futat ere jee. Ka'aranũũa etee je afutat”, 'jau 'wyriararete 'ga aipo 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","“Ma'eramũ sipo ene imomytune'ema jee rai'i? Je upe imomytun are efuewere'emamũ amunipo 'ã eremono ka'aranũũ rerekwara 'gã nupe rai'i kũi? A'eramũ amunipo 'ã 'gã jeka'aranũũ momyawera mepyau enee jee rai'i kũi”, 'jau 'wyriararete 'ga aipoa kũima'e 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—A'eramũ 'ga 'jau ajepeja wemiayuwa 'gã nupe: “Pe'je jeka'aranũũ pyyka 'ga wi. Imonou teis ka'aranũũ ywope'i rerekwara 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Ga je'eg imũ ereko esageara 'gã opyygu'jap futat”, 'jau 'ga 'gã nupe. “'Ga je'eg imũ ereko esageare'ema 'gã te ajee wemirerekofera miamũ futat nopyygu'jawi”, 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Nia'wyri futari 'ga. A'eramũ pẽẽ 'ga pyyka 'ga monou imomoa ypytunaiwa pype. Peu futat nipo 'ga 'ũina waemamũ wa'jykãjamũ”, 'jau 'ga wemiayuwa 'gã nupe— 'jau Jejui 'ga imome'wau oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","A'ere Jejui 'ga 'uawa mome'wau oree: —Anure nipo Pẽneki'yramũ je rekoi 'wyriaramũ pẽ nupe. A'eramũ nipo je tejua tejewya nũ. Tejenyfuga pype futat nipo tejua nũ. Ywagipewara 'gã juejue nipo 'ua je rupi. A'eramũ nipo je teapyka 'wyriararete renawa 'arimũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A'eramũ nipo 'awa ywy pewarera 'gã najuejue etee futat 'ua ajatykau je rowase. A'eramũ nipo je tejerowiaara 'gã mojo'oka tejerowiaare'ema 'gã nui. Sã'ã wyra jara 'ga weymawa mojo'oga. Karupa'mĩ mojo'oga karupana'nĩ awi. Nan tee futat nipo je ywy pewarera 'gã mojo'ogi ajaui. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tejerowiaaramũ pẽ nupe nipo je 'i: “Ko katy pekwap, jejakwatawa katy”, 'jau nipo je tejerowiaaramũ pẽ nupe. A'eramũ nipo je tejerowiaare'ema 'gã nupe nipo je 'jau: “Kwe katy pekwap je wi”, 'jau nipo je 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","—A'eramũ nipo je 'jau tejerowiaaramũ pẽ nupe: “Je rerowiaara pejemogy. A'eramũ Jeruwarete 'ga pẽ maku'iu. A'eramũ pẽẽ 'awamũ pejejua 'au je pyri. Ymã te 'ã, ywy apoe'ẽwe, Janeruwarete 'ga 'i jee ikue: ‘Anure nipo je ene rerowiaara 'gã mogyi 'wyriaramũ ene pyri’, 'jau 'ga jee ikue. A'eramũ pẽẽ 'awamũ pejeapyka 'au je pyri. 'Ga 'ã pẽ mogy 'wyriaramũ je pyri”, 'jau nipo je tejerowiaaramũ pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Jepy'arayparamũ ako pẽẽ je mojemi'waa ai'i. Je'yuwejamũ ako pẽẽ 'y mua jee ai'i. Napẽpytuna rũi agawewi futat je. A'etea ako pẽẽ je mua pejeje'wyr ipe ai'i. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jeraitye'emamũ ako pẽẽ taity mua jee ai'i. Jekaruaramũ ako pẽẽ je fuanuga ai'i. Moromunepawa pype je renamũ ako pẽẽ pejewau je pyri ai'i”, 'jau nipo je tejerowiaaramũ pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—A'eramũ nipo pẽẽ pejeporonupa ee jee: “Maranime sipo ore ene mojemi'wari rai'i? Maranime sipo ore 'y monoi enee nanẽ rai'i nũ? ");
INSERT INTO kyzNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Maranime sipo ore ene muri oroje'wyr ipe rai'i nũ? Maranime sipo ore taity monoi enee rai'i? ");
INSERT INTO kyzNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Maranime sipo ore ene fuanugi rai'i? Maranime sipo ore arawau ene resaka moromunepawa pype ene renamũ rai'i?” 'jau nipo pẽẽ pejeporonupa ee jee— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—A'eramũ nipo je 'wyriarareteramũ te'ỹina 'jau pẽ nupe: “A'jea futat je 'i. Je rerowiaara 'gã amũ ako okaraemãe'emamũ ikue. A'eramũ ako pẽẽ mama'e monou 'gã nupe ikue. Je rerowiaara 'gã nupe mama'e mono re pẽẽ je upe mama'e muara 'jawe futat jee”, 'jau nipo je tejerowiaaramũ pẽ nupe— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—A'eramũ nipo je 'jau tejerowiare'ema 'gã nupe: “Pe'je pejewau je wi. Janeruwarete 'ga pẽ mono pẽ mogyau mama'eukwaawa rapyaw ipe. Aipoa tata 'ga wapo mama'eukwaawa 'wyriara upe tee rakue numiamũ, emiayuwa reewe numiamũ. A'ere 'ã pẽẽ je rerowiare'emamũ mama'eukwaawa remiayuwamũ futat pejemogy. A'eramũ Janeruwarete 'ga pẽ monou pẽ mogyau eewe futat iapyaw ipe”, 'jau nipo je 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","“Nepemuri 'ã mama'ea jee. Naje mojemi'wari nanẽ ako pejepe jepy'arayparamũ ai'i. Je'yuwejamũ nanẽ ako pẽẽ 'y mure'ema jee ai'i. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Naje muri nanẽ ako pejepe pejeje'wyr ipe ai'i, pejejepyri je ruramũ ai'i. Jeraitye'emamũ nanẽ ako pẽẽ taity pe mure'ema jee ai'i. Jekaruaramũ nanẽ ako pẽẽ je fuanuge'ema ai'i. Moromunepawa pype je renamũ nanẽ ako pẽẽ pejewawe'em je pyri ai'i”, 'jau nipo je 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—A'eramũ nipo 'gã oporonupa ee jee: “Maranime sipo ore ene resagi enepy'arayparamũ rai'i? Maranime sipo ore ene resagi ene'yuwejamũ rai'i nũ? Maranime sipo ore ene mure'ema oroje'wyr ipe rai'i? Maranime sipo ore ene resagi eneraitye'emamũ rai'i? Maranime sipo ore ene resagi enekaruaramũ rai'i? Maranime sipo ore ene resagi moromunepawa pype ene renamũ rai'i?” 'jau nipo 'gã oporonupa ee jee. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—A'eramũ nipo je 'wyriarareteramũ te'ỹina 'jau 'gã nupe: “A'jea futat je 'i. Je rerowiaara 'gã ikaraemãe'ema 'gã nupe mama'e monoe'em ire pẽẽ je upe mama'e muare'ema 'jawe futat”, 'jau nipo je 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—A'eramũ nipo aipo 'gã awau ajemogyau mama'eukwaawa rapyaw ipe. Je rerowiaara 'gã etee te nipo oo osou ywag ipe Jarejuwarete 'ga pyri nakwaparimũ rũi— 'jau Jejui 'ga imome'wau oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Imome'upaw ire Jejui 'ga 'jau wemimu'eramũ oree: ");
INSERT INTO kyzNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ikoai'i maraka apoawa 'ara rekoi, Pasikwa 'jawa rekoi. Aipo rupi futat nipo 'gã Pẽneki'yramũ je pyygi je jukaawamũ. Je rekoa futat nipo 'gã ipokutuka je monou je mu'ama 'ypeywar are— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A'e pe a'eramũ peramũ mainana 'wyriara 'gã 'upa ajatykau judeu 'gã 'wyria'ri 'gã netee. Mainana 'wyriararete 'ga rog ipe 'gã 'upa, Kaifasi 'ga rog ipe 'gã ajatykau 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","5","—Maran te jane Jejui 'ga rerekoi? Jemime te jane 'ga pyygi?— 'jau 'gã ajaupe 'upa. —Jerusareg ipewara 'gã iporomutat 'ga ree. A'eramũ jane 'gã nowase jarekowe'em 'ga ree maraka apoaw ipe— 'jau 'gã ajaupe. —Kasi a'e pe wowase 'ga rerekoramũ 'ga remiayuwa 'gã jane apisi ne. Jemime te sireko 'ga 'jau. 'Gã nowase atywi te jane 'ga jukai— 'jau 'gã 'upa ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Petani pe Jejui 'ga akou, Simão 'ga rog ipe, ipito'om ma'efera 'ga 'wyr ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Poje kũjã ẽẽ mũ 'ua 'ga rerowyka. Jany kasiga ryrũa ẽẽ erua. Itasiga apopyra aipo yrũnamũ, aripasi 'jawa apopyra. Jany kasig epy epy ete poromũ. 'Ga jemi'wat 'ga renamũ ẽẽ ojany kasiga rerua eko'woka 'ga akag are. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ẽẽ remiapo resakawe ore Jejui 'ga remimu'eramũ aramara'neramũ ee. A'eramũ ore 'jau arajaupe: —Ma'eramũ sipo ẽẽ imomy ekoetei 'wei? ");
INSERT INTO kyzNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Epy te 'ã 'aga jany kasiga a'i kũi. A'eramũ amunipo 'ã ẽẽ ime'ega ka'aranũũ are janee. A'eramũ amunipo 'ã ẽẽ epyfera mua janee. A'eramũ amunipo 'ã jane imojo'oka ikaraemãe'ema 'gã nupe 'jau kũi— 'jau ore arajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","A'ere Jejui 'ga arajaupe ore'eawera kwaawi. A'eramũ 'ga 'jau oree: —Ma'eramũ pejemara'neramũ ẽẽ ree 'ũ? Mama'e esagea te ẽẽ wapo jee— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","—Ikaraemãe'ema 'gã nooa'uweri futari pẽ nui. A'eramũ pẽẽ anure mama'e monou 'gã nupe. A'ere je te nako fukui futari pẽ pype— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","—Je tymaw ipe je ree eko'wogipyrama futat jany kasiga numiamũ. A'ere ẽẽ 'awauwe eko'wogi je ree, je manũe'emauwe. Tene ẽẽ iapoi jee— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","—A'jea futat je 'i. Anure nipo 'gã je mome'ui kwe pewara 'gã nupe. Amunawa tesirũmera moyka nipo 'gã awau je mome'wau kwe pewara 'gã nupe. Je mome'uramũ nipo 'gã ẽẽ remiapofera nanẽ imome'wau 'gã nupe nũ. A'eramũ nipo 'gã anure najuejue etee futat wea'aramũ ẽẽ remiapofer are— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A'ere Jejui 'ga remimu'eramũ ore mũ oi oporogytau mainana 'wyriara 'gã nupe. Judas Iskariote 'ga futat poromũ oo oporogytau 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Taesaukat Jejui 'ga pẽ nupe 'jau. A'eramũ sipo pẽẽ ma'ja mua jee 'ga resaukara repyramũ?— 'jau 'ga awau 'gã nupe. —Trĩta prata apopyrera ka'aranũũ ywope'ia simono enee 'jau— 'jau 'gã 'ga upe. —Nai'i— 'jau 'ga 'gã nupe. A'eramũ 'gã trĩta ka'aranũũ ywope'ia monou 'ga upe, Jejui 'ga ojeupe esaukaawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A'eramũ Judas 'ga wea'aramũ akou ee. “Ojetee 'ga rekoramũ tomono 'ga 'gã nupe 'jau kwy”, 'jau 'ga ojeupe. A'eramũ 'ga Jejui 'ga rerekou weape. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Awau owaẽma mani'oko'o jopype'ema 'wawa upe, Pasikwa 'jawa apoawa upe. A'eramũ Jejui 'ga remimu'eramũ ore 'jau 'ga upe: —Ma'ape te jane jemi'wari? karupa'mĩ ro'o reyri jarejee?— 'jau ore 'ga upe. —Awỹja rog ipe ore erawau eya ki 'ei?— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A'eramũ Jejui 'ga 'jau oree: —Pe'je pejewau Jerusareg ipe jarejekoty'aawa 'ga rog ipe. A'e futat je 'ga upe ai'i. A'eramũ pẽẽ pejewau 'jau 'ga upe: “Ku'jywa 'ga ore mut 'au. ‘Nako fukui je 'gã nupe. A'eramũ je enerog ipe tejemi'wariweramũ tejemimu'e 'gã netee. Karupa'mĩ eyr are jeporo'uweramũ tejemimu'e 'gã netee enerog ipe’, e'i 'ga enee”, pe'je ki 'ga upe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A'eramũ ore arawau iapou Jejui 'ga 'eawer imũ etee futat. Maraka are ore iapou, Pasikwa 'jawa maraka are. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kaaruwamũ Jejui 'ga awau ojemi'waa wemimu'eramũ ore retee. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Orojemi'waaw ipe Jejui 'ga 'jau oree: —A'jea futat je 'i. A'jea futat nipo pẽẽ mũ je mono pejepe je ree iporomutare'ema 'ga nupe je jukaukaa— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Aipo renupawe ore aru'arasigamũ 'ga je'eg are. A'eramũ ore oroporonupa majepeinume ee 'ga upe aipo 'ga 'eramũ: —Je upe te ere poromũ?— 'jau ore 'ga upe. Majepeinumenume ore oroporonupa ee 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A'eramũ Jejui 'ga 'jau oree: —Je pyri ojemi'wat ma'eramũ futat nipo pẽẽ mũ je monou 'gã nupe— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","—Ymã te Janeruwarete 'ga ka'arana kwasiarukari 'gã amũ nupe rakue, jemanũ are rakue. Pẽneki'yra agawewi je 'ã. A'etea je ree iporomutare'ema 'gã je jukaukat 'gã nemikwasiarer imũ etee futat. A'ere 'gã nupe je monoara 'ga tywereteramũ te akou. Iporiay'i 'gã po pe je monoara 'ga numiamũ. A'ere nipo Janeruwarete 'ga rereko tyweretei. Ma'eramũ gatu nipo 'ã 'ga jeuwi rakue 'ja— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A'eramũ ae a'wyre'ema 'gã po pe 'ga monoarama 'ga, Judas 'ga, oporonupa ee 'ga upe: —Je upe te ere poromũ, ki Ku'jyp?— 'jau futatee Judas 'ga 'ga upe. —Ẽẽ. Ene upe futat je 'i— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Orojemi'waaw ipe Jejui 'ga mani'oko'o'i pyyka. A'ere 'ga eramã'jãu ywau eroje'ega 'Uwarete 'ga upe: —Au'jete mani'oko'o'ia eremut oree, Kiapi'ni— 'jau Jejui 'ga 'ga upe. A'ere 'ga mani'oko'o'i mowoka imonou oree. —Mani'oko'o'ia pepyyk i'wau. Koromũ jero'oa— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A'ere 'ga y'way ryrũ pyyka nũ, eramã'jãu ywau nũ. A'eramũ futat 'ga oje'ega monou 'Uwarete 'ga upe nũ: —Au'jete y'waya eremut oree, Kiapi'ni— 'jau Jejui 'ga 'ga upe. A'ere 'ga imua oree. —Pe'je itykua pãwẽ pãwẽ. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Koa y'way jerya futat. A'ere'ere'i nipo 'gã amũ je jukai jery reko'woka. Aipoa jery jeko'woga pẽtywera omepy. Jemanũ are futat Jeruwarete 'ga pẽ katu'ogi kwaiwete. 'Awamũ karupa'mĩa nepejukau'jawi pejetywera mepyawamũ. Poromũ futat ako 'ga je'eg ymanera ai'i. A'ere 'awamũ 'ga je'eg yaua. 'Awamũ jerya tee pẽ pirei pẽtywer awi— 'jau 'ga oree. —Jemanũ are tee Jeruwarete 'ga pẽtywera moia pẽ nui je rerowiaaramũ. 'Awamũ poromũ futat Janeruwarete 'ga je'eg yaua 'awamũ. A'ea 'ga je'ega nimojopy'ruawi futari 'awamũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","—A'jea futat je 'i. Je natykuru'jawi futari 'aga y'waya pẽ pyri. Anure tãmẽjẽ te nipo je itykuri pẽ pyri, Tejuwarete 'ga pyri pẽ neroo re tãmẽjẽ nũ— 'jau Jejui 'ga oree ikue. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","'Ga porogytapaw ire ore aramaraka'aga 'ga retee Jarejuwarete 'ga muorypawamũ. Aramaraka'ag ire ore arawau ywytyr ipe, Oriweira 'jaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Arawaw ipe Jejui 'ga 'jau oree: —'Awamũ futat nipo pekwasi'o je wi je rejaa je mu'ama ojetee'i— 'jau 'ga oree. —Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari 'ga amũ upe ee rakue: “Tajuka karupa'mĩ are omaenun ma'e 'ga 'jau kwy. A'eramũ 'ga reymawera 'gã awau okwasi'wau kwe pe 'jau kwy”, 'jau Janeruwarete 'ga ikwasiarukaa inuga ka'aran are rakue. A'eferupi tee futat nipo pekwasi'o pejewau je wi— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—A'ere je temanũ re je ferawi nũ. Teferaw ire nipo je oi Garireja ywy pe pẽ nenune— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A'eramũ Pedro 'ga 'jau 'ga upe: —'Me te pa 'ga poromũ 'jau nũ. Je naejara'uweri futari ene mogou ojetee'i kũi. 'Gã te nipo opyamũ ene wi ene rejaa ojetee'i kũi. A'ere je naejara'uweri ene kũi— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—A'jea futat sipo ere— 'jau Jejui 'ga 'ga upe. —Je te a'jea futat a'e enee nũ'ũ: 'Awa ypytuna rupi nipo je kwakuw ape muapyapyt katu 'gã nupe. “Nakwaawi je 'ga”, 'jau nipo ene wyrasokwẽ je'ege'emauwe— 'jau 'ga Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","A'ere Pedro 'ga fuakaramũ 'ga upe: —Naani futari nũ'ũ. Na'ea'uweri futari je aipo 'jau nũ'ũ. “Nakwaawi je 'ga”, na'ea'uweri je. “Tene 'gã je jukai 'ga reewe futat”, a'e ete nipo je. Nakwakuwa'uweri futari je ene— 'jau Pedro 'ga Jejui 'ga upe. Ore juejue nanẽ Pedro 'ga 'eawera rupi etee futat 'jau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jejui 'ga awau owaẽma Getsemani 'jaw ipe, wemimu'eramũ ore retee. A'eramũ Jejui 'ga 'jau oree: —'Au ete pejup ra'ne. Iruupeu'i je oi teporogytau Tejuwarete 'ga upe ra'ne— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A'ere 'ga muapyra 'gã etee erooi ojeupi. Pedro 'ga, Tiago 'ga, Juã 'ga. Mĩmera 'gã etee 'ga erawau ojeupi. Tiago 'ga, Juã 'ga retee Sepeteu 'ga ra'yra 'gã. Jejui 'ga 'arasiga 'ga mopy'aywyrafenayau 'ga mogou. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A'eramũ 'ga 'jau muapyra 'gã nupe: —Je'arasiga nipo 'ã je juka. Peser awi ete pejejupa. Peporogyta Jarejuwarete 'ga upe je pyri— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A'eramũ 'ga ojepe'au'i 'gã nui. Awau 'ũina peu'i wenupy'ãu wapyka weakwara rerawau enũina ywy are futat erujaa oporogytau 'Uwarete 'ga upe: —Kiapi'ni. 'Wyria'ri 'gã imara'ne je ree. 'Gã nipo 'ã je rereko tywerete 'ja. Ojeupe ene iapoukare'em ire amunipo 'ã 'gã nuapoa'uweri nanuara je ree. A'ere 'ã najeremifutar imũ rũi te ereapoukat. Ejemifutar imũ etee te 'ã ereapoukat 'gã nupe jee— 'jau 'ga 'Uwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Oporogytapaw ire 'ga afu'ama awau muapyra 'gã pyri. A'ere 'gã seri 'upa. A'eramũ 'ga 'jau Pedro 'ga upe: —Peset te pejejupa? Pejeje'ega te nepemonoi'i Jarejuwarete 'ga upe je pyri? A'e'ja'wiramũ miamũ sipo nepeporogytai Jarejuwarete 'ga upe?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","—Peser awi. Peporogyta Jarejuwarete 'ga upe. A'eramũ pẽẽ pejefuakaramũ mama'e tywera apowe'em. Kasi a'e pe nepẽfuakari ne. A'eramũ pẽẽ mama'e tywera etee iapou 'ga upe ne. Nepẽparuapoweri agawewi nipo mama'e tywer are. A'etea nipo peapo. 'Ga upe pejeporogytawe'em 'eramũ mama'e tywera etee futat peapo pejekou— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aipo 'ga upe 'e re Jejui 'ga awau 'gã nui nũ oje'ega monou 'Uwarete 'ga upe nũ: —Kiapi'ni. Je ree iporomutare'ema 'gã ifuewet je ree. 'Gã te nipo 'ã je rereko tywerete 'ja. Ojeupe ene iapoukare'em ire amunipo 'ã 'gã nuapoi. A'ere 'ã najeremifutar imũ rũi te ereapoukat. Ejemifutar imũ etee te 'ã ereapoukat 'gã nupe jee— 'jau 'ga 'Uwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A'ere 'ga awau ojewya wemimu'e 'gã pyri nũ. Nãnẽwẽjẽmĩ 'gã 'upa nũ. Osea etee 'gã 'upa nũ. Wopeypeyjamũ etee 'gã ajemogyau. A'eramũ 'gã osea 'upa 'ga ruramũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A'eramũ Jejui 'ga awau oporogytau'japa 'Uwarete 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Uwarete 'ga upe oporogyta re 'ga 'ua nũ. Nãnẽwẽjẽmĩ 'gã osea 'upa nũ. A'eramũ 'ga 'jau 'gã nupe nũ: —Peser etee futat nipo pejejupa nũ ki sa? Au'je pejeser ire. 'Awamũ futat 'gã Pẽneki'yramũ je monoi ae a'wyre'ema 'gã po pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pe'je iruukwe soo 'gã nekoaa 'jau. Kweramũ ae a'wyre'ema 'gã po pe je monoara 'ga ruri— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jejui 'ga porogytapawe'emauwe Judas Iskariote 'ga 'ua. Jejui 'ga remimu'eferamũ ore mũ poromũ. Kwaiwete 'gã nerua erojemorypa Jejui 'ga ree. A'eramũ mainana 'wyriara 'gã kwaiwete 'gã mua Judas 'ga rupi. Judeu 'gã 'wyria'ri 'gã nanẽ kwaiwete 'gã mua 'ga rupi. Jyuua 'gã erua muap. Mĩmera 'gã erua erojemorypa 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mainana 'wyriara 'gã nupe oporogytau Judas 'ga 'jau 'gã nupe rai'i: “Oo nipo je Jejui 'ga retywape pytea pẽ neape. A'eramũ pẽẽ a'e are 'ga kwaapa 'ga retywape pyteramũ. A'erauwe futar iki pẽẽ pejewau 'ga pyyka 'ga rerawau”, 'jau 'ga 'gã nupe rai'i. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A'eramũ 'ga owaẽma ypy we awau Jejui 'ga rerowyka 'jau 'ga upe: —'Au te ereko, ki Ku'jyp?— 'jau 'ga 'ga upe. A'eramũ futat 'ga 'ga retywape pytea. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","A'eramũ Jejui 'ga 'jau 'ga upe: —Ejemifutara eapo etee futat— 'jau Jejui 'ga 'ga upe. A'erauwe Judas Iskariote 'ga remireroofera 'gã 'ua Jejui 'ga pyyka, 'ga pofaa. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","A'ere Jejui 'ga remimu'eferamũ ore mũ ojyuu rekyita kũima'e 'ga amũ ree, 'ga namĩ monoka. Furuk. Mainana 'wyriararete 'ga remiayuwa 'ga namĩ yypa. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aipo 'ga namĩ yywamũ Jejui 'ga 'jau 'ga upe: —Ereapo awi nanuara. Ere ejy monou imunepa yrũ pype kũi— 'jau 'ga 'ga upe. —Jyuu pyu ajajukaara 'ga te anure 'gã tajuka jyuu pyu 'jau— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","—“Nopoari nipo 'ga ruwa 'ga 'ga”, pe'je nipo kũi. Ojeupe je enũi re amunipo 'ã Jeruwarete 'ga je poari futari. Kwaiwete amunipo 'ã 'ga ywagipewara 'gã mua je poaa— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","—A'ere je naenũi 'ga upe. Wemifutar imũ 'ga iapoa etee futat je afutat. Ymã te Jeruwarete 'ga ka'arana kwasiarukari 'gã amũ nupe je pyyg are rakue. A'eramũ je 'gã nemikwasiarer imũ etee futat mama'e jeapo futaa tejee— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A'ere 'ga 'jau opyykara 'gã nupe: —Ma'eramũ pẽẽ ma'eramũ pejejua muawa pyu je nupãu ekoete 'ũ? muna'ywa 'jawe 'ũ? Ma'eramũ pẽẽ muawa we erua jyuu reewe jepiara rupi 'ũ? Jarejuwarete 'ga mogytaaw ipe 'gã mu'e je rekoramũ miamũ ako naje pyygi pejepe ai'i— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","—Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari 'ga amũ upe jemanũ are ikue. A'eramũ 'ã pẽẽ iapou 'ga remikwasiarer imũ etee futat— 'jau 'ga 'gã nupe. A'e renupawe ore Jejui 'ga remimu'eramũ orokwasi'wau 'ga wi, 'ga rejaa, oroka'jama 'gã nui. Orokyjau 'gã oropyyg awi. A'eramũ ore oroka'jama 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","A'ere Jejui 'ga pyykara 'gã 'ga rerawau mainana 'wyriararete 'ga rog ipe, Kaifasi 'ga rog ipe. Peu futat judeu 'gã 'wyria'ri 'gã ajatykau Moisesi 'ga remikwasiarer are moromu'jara 'gã netee. A'eramũ 'gã Jejui 'ga rerawau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro 'ga awau 'gã newiri. A'ere 'ga nuerowygi Jejui 'ga. Mukuu etee futat 'ga akou 'ga wi. Awau 'ga owaẽma mainana 'wyriararete 'ga roga upe. A'ere Pedro 'ga nooi osou. Ukupepe etee futat 'ga awau akou 'oga osoma pype mainana 'ga remiayuwa 'gã pyri, Janeruwarete 'ga mogytaawa raarana 'gã pyri nanẽ nũ. Jejui 'ga rereko renuw are Pedro 'ga oporenuwiweramũ akou. A'eramũ 'ga akou mukuu'i etee futat 'ga rereko renupa. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ojeupe 'gã Jejui 'ga reruramũ mainana 'wyriara 'gã oje'ẽma'e 'gã netee 'ga remiapo tywera mome'waramũ rekaa. Judeu 'gã 'wyria'ri 'gã ajatykau 'gã nee nũ. —Sijuka futat 'ga 'jau— 'jau 'gã ajaupe. —A'ere jane nijuka ekoetei 'ga. Kasi a'e pe mytuna 'gã mara'neramũ jane ree ne. A'eramũ pẽẽ i'me ma'e 'gã amũ nerua. Jejui 'ga remiapo tywera 'gã tomome'u 'me janee 'jau— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","A'eramũ kwaiwete 'gã 'ua o'meramũ Jejui 'ga ree. A'ere 'gã naju'jaju'jawe rũi imome'ui 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Poje mukũja 'gã 'ua o'meramũ 'gã nupe: —Ore aruenup 'ga je'ega ai'i. “Anure nipo je Jarejuwarete 'ga mogytaawa retygi. A'ere nipo je imuapyra 'ara rupi etee imowyri nũ”, 'jau 'ga oreremianuwamũ ai'i— 'jau 'gã imome'wau mainana 'wyriararete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aipo ojeupe 'gã 'e renupawe mainana 'wyriararete 'ga afu'ama 'jau Jejui 'ga upe: —Ma'ja ere te 'gã nupe? Nereje'egi te 'ã 'gã nupe aipo 'gã 'eramũ a'i kũi?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A'ere Jejui 'ga pigi etee u'ama. A'eramũ mainana 'wyriararete 'ga 'jau 'ga upe: —Jarejuwarete 'ga remianuwamũ ere jee: Ene te Jarejuwarete 'ga remimurera? Ene futat te 'ga ra'yraretea?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—A'jea futat ere poromũ. Je te 'ã Pẽneki'yraretea. Anure nipo je apygi Pãjẽrete 'ga yse katy, 'ga jakwatawa katy. Peu je renamũ nipo pẽẽ je resaka. Anure nipo je ruri tejewya ywag awi ywasiga rupi— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A'erauwe mainana 'wyriararete 'ga waity monoroka amara'nea resaukaawamũ. —A'jea futat 'ga Jarejuwarete 'ga kurawi akou ra'e— 'jau 'ga 'gã nupe. —Jane futat te 'ã Jarejuwarete 'ga kurawa sienup 'awamũ jarejemogyau. Na'gã amũ rũi futat 'ã omome'u janee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","—Ma'ja pe'je te 'ga upe?— 'jau 'ga 'gã nupe. —Sijukaukat futat jane 'ga— 'jau 'gã 'ga upe. —Jarejuwarete 'ga te 'ã 'ga akurap. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","A'eramũ futat 'gã onymuna 'ga reakwar are, opo afuapyka erofaa 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Amumera 'gã 'jau 'ga nupã re 'ga upe: —“Je te 'ã Jarejuwarete 'ga remimurera”, ere 'ã oree. A'eramũ ene 'jau oree: Awỹja ene nupãu 'awamũ 'ũ?— 'jau 'gã 'ga upe, 'ga rerekoemãu erekou. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A'e pe Pedro 'ga 'ũina ukupepe. Poje mainana 'wyriararete 'ga remiayuwa ẽẽ mũ 'ua 'ga pyri 'jau 'ga upe: —Ene Garireja ywy awi 'ut ma'efera kĩã rewiri ako ma'eferamũ ene, 'jau je rã, Jejui kĩã rewiri ako ma'eferamũ ene, 'jau je rã— 'jau ẽẽ 'ga upe. Janeruwarete 'ga mogytaawa raarana 'gã pyri 'ga renamũ ẽẽ 'jau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—Tee. Naani nũ ĩ. Nakwaawi je 'ga nũ ĩ. A'eramũ awỹja upe ene 'jau ekou ĩ— 'jau futatee 'ga ẽẽ upe, ojepyriwara 'gã nemianuwamũ. —Nakwaawi je ene'ea nũ ĩ— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A'erauwe 'ga afu'ama awau 'oga osoma rokwara katy. Poje peu oporowyky ma'e ẽẽ mũ 'ga resaka nũ. A'eramũ ẽẽ 'jau ojepyriwara 'ga upe: —Ko kĩã Jejui kĩã rewiri ako ma'efera kĩã futat. Nasare pe waranup ma'efera kĩã rewiri ako ma'efera kĩã futat— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A'eramũ Pedro 'ga 'jau nũ: —Kuu. Ene'me awi ĩ. Manamũ te je aipoa kũima'e 'ga kwaawi 'i ĩ— 'jau futatee 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A'ere peu u'am ma'e 'ga amũ 'jau 'ga upe nũ: —A'jea futat ẽẽ 'i enee. Ene futat 'ga rewiri ako ma'eferamũ— 'jau 'ga 'ga upe. —Sã'ã ene Garireja ywy pewara 'gã je'ega rerekoa. A'eramũ ene 'ga rewiri ako ma'efera futat— 'jau 'gã Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—“Nakwaawi je 'ga” a'e je akiko. Janeruwarete 'ga remianuwamũ te 'ã je 'eu'jawi. Nakwaawi je 'ga, 'jau. Nakwaawi je aipo pẽ'ea nũ'ũ. A'eramũ pẽẽ ma'ja upe 'jau pejejemogyau 'ũ?— 'jau 'ga 'gã nupe. —Te'me re je Jarejuwarete 'ga tejereko tywera futari tejee nũ'ũ— 'jau 'ga 'gã nupe. A'erauwe wyrasokwẽ je'egi. ");
INSERT INTO kyzNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","A'erauwe Pedro 'ga wea'aramũ Jejui 'ga 'eawer are. “Wyrasokwẽ je'ege'emauwe nipo ‘Nakwaawi je 'ga’ ereu'jau'jap 'gã nupe” 'eawer are Pedro 'ga wea'aramũ. A'eramũ 'ga ojenosõu aipo u'eawera rerawau enujãna pe awi. A'eramũ futat 'ga u'arasigamũ wea'aramũ ee. —Ma'eramũ je aipo 'jau ra'e 'ũ?— 'jau 'ga 'ũina u'arasigamũ. —Mama'e esage na'ga 'ã wapo jee jepi re'ã. A'etea pa je 'ã aipo a'e ekoete 'gã nupe ra'e nũ— 'jau 'ga ojeupe. A'eramũ 'ga ajaa'wau awau u'eawera raykau. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ai'iwetetewe mainana 'wyriara 'gã judeu 'gã 'wyria'ri 'gã netee oje'ega ajaupe: —“Je te 'ã Jarejuwarete 'ga ra'yraretea”, e'i ako Jejui 'ga janee ko. A'eramũ jane 'ga jukaukaa 'gã nupe— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A'eramũ 'gã 'ga faa, 'ga rerawau Piratu 'ga rog ipe. Romanũ 'gã opytuna 'ga amũ monou 'wyriaramũ 'ga mỹina judeu 'gã nupe rakue, Piratu 'ga monou 'wyriaramũ 'gã nupe rakue. A'eramũ 'gã Jejui 'ga rerawau Piratu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","“Sijukaukat Jejui 'ga 'gã nupe 'jau” 'e renupawe Judas Iskariote 'ga u'arasigamũ 'gã nupe 'ga monoawer are. A'eramũ 'ga Jejui 'ga resaukaawera repyfera rerawau erojewya mainana 'wyriara 'gã nupe, judeu 'gã 'wyria'ri 'gã nupe nanẽ nũ. —Kweramũ trĩta ywope'ia je upe pẽnemimurera. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mama'e tyweretea je aapo ai'i. Nuapoi futari 'ga mama'e tywera. A'etea je 'ga omono ekoete pẽ nupe ijukaukaa ai'i— 'jau 'ga awau 'gã nupe. —Tee. Ene te futat te 'ã ere 'gã nupe rai'i— 'jau etee 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aipo ojeupe 'gã 'eramũ Judas Iskariote 'ga ka'aranũũ ywope'i monou imomopoa ywyu 'gã nowase. A'eramũ 'ga uẽma awau ojejukau tupaama pyu. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Judas Iskariote 'ga ẽmauwe mainana 'wyriara 'gã wowase 'ga remimomoporera ka'aranũũ ywope'i mono'oga. —Koa ako jane ka'aranũũa simono Jejui 'ga resaukaawamũ 'ga upe ai'i. A'eramũ koromũ 'ga repyfera futat— 'jau 'gã ajaupe. —“Aerepyfera perur awi Jarejuwarete 'ga mogytaaw ipe”, e'i 'ã Moisesi 'ga rakue. A'eramũ jane imonowarũe'em Jarejuwarete 'ga mogytaawa ka'aranũũ ryrũ pype— 'jau 'gã ajaupe. —Maran ajee jane erekoi 'ũ?— 'jau 'gã ajaupe. —Ywya simut ape judeue'ema 'gã nywyramũ kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Oporogytapaw ire 'gã erawau japepo apoara 'ga upe, 'ga ywy muawamũ. —'Awa ywya judeue'ema 'gã nywya— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ka'aranũũ ae repyfera 'gã imonou 'gã nupe ywy muawamũ ojeupe. A'eramũ 'gã aipo ywy re'roka, “wy rupap” 'jau 'gã e'roka. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ymã te 'ã Jeremi 'ga oje'ega kwasiari aipo are rakue: “Ywya pemut 'ga repyfera pyu. Japepo apoara 'ga ywya pemut, ere ki 'gã nupe”, 'jau Ku'jywa 'ga jee ikue. “A'eramũ je 'ga 'eawera mome'wau 'gã nupe. ‘Trĩta ka'aranũũ ywope'ia simono 'ga muawamũ 'jau’, 'jau 'ga rakue. A'eramũ 'gã 'ga repyfera pyu ywy mua, Ku'jywa 'ga 'eawer imũ etee futat”, 'jau Jeremi 'ga ikwasiaa rakue. A'jea futat 'ga remikwasiarera. Ywya 'gã imua Jejui 'ga repyfera pyu, Jeremi 'ga 'eawer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ojeupe Jejui 'ga reruramũ Piratu 'ga oporonupa ee 'ga upe: —A'jea te ene 'wyriaramũ judeu 'gã nupe?— 'jau 'ga Jejui 'ga upe. —A'jea futat— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A'eramũ mainana 'wyriara 'gã 'ga je'ẽwu'jaga judeu 'gã 'wyria'ri 'gã netee. A'ere 'ga noje'egi futari oje'ẽwu'jagamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","A'eramũ Piratu 'ga 'jau 'ga upe: —Nereenuwi te 'gã je'ega? Ma'eramũ nã'ã nereje'egi 'gã nupe re'ã?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A'ere Jejui 'ga noje'egi futari 'gã nupe. O'meramũ te 'gã 'i. A'eramũ 'ga oje'ege'ema 'gã nupe. A'eramũ Piratu 'ga oporesagamũ etee 'ga ree. “Ma'eramũ sipo 'ga noje'egi?” 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mani'oko'o jopype'ema 'wawa maraka apoawa rupi Piratu 'ga moromunepawa pype imunewipyrera 'ga amũ muẽma judeu 'gã nupe jepi, 'gã nemienũiwera 'ga 'ga imuẽma 'gã nupe jepi. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A'e pe a'eramũ Parapasi 'ga 'ũina moromunepawa pype. Oporojuka ma'e 'ga. Judeu 'gã nemiesagete 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","A'eramũ Piratu 'ga 'jau 'gã nupe: —Maranuara te je amuẽm pẽ nupe? Jejui 'ga, Ku'jywa 'ga remimurera 'jawa 'ga te ra'u pefutat nũ? Parapasi 'ga te ra'u pefutat nũ?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Piratu 'ga mainana 'wyriara 'gã kwaapa futat. “Werekoay pa 'gã 'ga ra'e. A'eramũ pa 'gã a'eramũ 'ga rerua jee ra'e”, 'jau Piratu 'ga ojeupe. “A'ere mytuna 'gã poromutaramũ 'ga ree. A'eramũ nipo 'gã 'jau: ‘Jejui 'ga emut oree’, 'jau nipo 'gã jee”, 'jau Piratu 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","'Wyriara kanawa 'arimũ Piratu 'ga 'ũina oporogytau 'gã nupe. Poje 'ga amũ 'ua 'ga remireko ẽẽ je'ega rerua 'ga upe: “Epoit kĩã wi. Nuapoa'uweri kĩã mama'e tywera. Afayup je kĩã ree ko. Jefayuwa je mopiryyi ko. A'eramũ ene epoia kĩã wi. Erereko tywet kasi kĩã ne”, 'jau ẽẽ oje'ega mua omena 'ga upe, Piratu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A'e pype mainana 'wyriara 'gã judeu 'gã 'wyria'ri 'gã netee mytuna 'gã mojerowiarukaa oje'eg are. —“Parapasi 'ga ki emuẽm imua oree”, sa'e 'ga upe 'jau. “A'eramũ ene Jejui 'ga jukaukaa jefaruu 'gã nupe”, sa'e 'ga upe 'jau— 'jau 'gã mytuna 'gã nupe, 'gã mojerowiarukaa ee. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A'eramũ Piratu 'ga 'jau 'gã nupe: —Maranuara 'ga te pefutat je imuẽma pejejeupe?— 'jau 'ga 'gã nupe. —Parapasi 'ga te ki emuẽm imua oree— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A'eramũ Piratu 'ga 'jau 'gã nupe: —Maran te jane Jejui 'ga rerekoi? “Ku'jywa 'ga remimurera” 'jawa 'ga rerekoi?— 'jau 'ga 'gã nupe. —Ejukaukat 'ga 'ypeywar are— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A'eramũ Piratu 'ga oporonupa ee 'gã nupe: —Ma'ja te 'ga wapo ajukaawamũ pẽ nupe rai'i?— 'jau 'ga 'gã nupe. A'ere 'gã afukafukai tee ajemogyau: —Ejukaukat futat Jejui 'ga 'ypeywar are 'gã nupe— 'jau 'gã wojere'emamũ futat wafukaita 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Niporenuwiweri 'gã 'ga je'eg are. A'eramũ 'gã ojopy'rapy'rau etee futat wafukaita Piratu 'ga upe. A'eramũ Piratu 'ga 'jau ojeupe: “Amono pa ajee je 'ga 'gã nupe kwy. Kasi a'e pe 'gã ore apisi ne kwy”, 'jau 'ga ojeupe. A'eramũ 'ga 'jau wemiayuwa 'ga amũ upe: —'Ya erut ara jee— 'jau 'ga 'ga upe. A'eramũ 'ga 'y rerua 'ga upe. A'eramũ Piratu 'ga ojepoeita mytuna 'gã nowase. —Peesak je jepoeja. Je najeporojukaweri 'ga ree. “Nuapoi 'ga mama'e tywera”, a'e je ako pẽ nupe ko— 'jau Piratu 'ga 'gã nupe. —Je apoit futat 'ga wi, 'ga monou pẽpo pe. A'eramũ je tejepoeita pẽ nowase 'ga wi tepoiawa resaukaawamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A'eramũ mytuna 'gã 'jau 'ga upe: —“Ejukaukat 'ga”, aru'e ore enee. Ore te 'ã arajukaukat 'ga 'gã nupe. A'eramũ nipo a'e are Janeruwarete 'ga ore rerekou tyweaete orera'yra 'gã neewe— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A'eramũ Piratu 'ga Parapasi 'ga muẽmukaa moromunepaw awi 'gã nupe. A'eramũ 'ga 'jau jefaruu 'gã nupe: —Pe'je Jejui 'ga rerawau 'ga nupãu jea'gue'em futat. 'Ga nupãmaw ire pẽẽ 'ga rerawau 'ga mu'ama 'ypeywar are— 'jau 'ga 'gã nupe. —A'eramũ 'ga peu etee futat amanũmũ u'ama 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","'Ga nupã jea'gue'em ire jefaruu 'gã Jejui 'ga rerawau 'ga rerosou Piratu 'ga rog ipe nũ. A'eramũ 'gã opytuna 'gã majatykau 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A'eramũ 'gã 'ga raity mosoka 'ga wi. 'Wyriara raity piraga pyu 'gã 'ga kupe piaa. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A'ere 'gã juapekagũũ muapỹina akagyrũnamũ iapou 'ga upe. A'eramũ 'gã imonou imunepa 'ga akaga pype. A'ere 'gã ywyra'i'i monou 'ga po pe. A'ere 'gã wapyka wenupy'ãu 'ga rowase 'ga rerekoemãawamũ etee. —Pemã'ẽ judeu 'gã 'wyriararete 'ga ree ki sa. 'Wyriara raity piraga 'ga wereko imunepa 'awamũ. 'Wyriara akagyrũa nanẽ 'ga wereko nũ. Ywyra'i'ia nanẽ 'ga wereko opo pe. 'Wyriararete 'ga nipo ki sa— 'jau 'gã ajaupe 'ga jaita 'ga rerekoemãu. A'ere 'gã 'jau Jejui 'ga upe: —Ene te 'ã 'wyriararetea judeu 'gã nupe ra'e. 'Awamũ ereko 'wyriarareteramũ nakwaparimũ rũi futat 'gã nupe— 'jau 'gã Jejui 'ga upe, 'ga rerekoemãu erekou. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A'ere 'gã onymuna 'ga ree. Ywyra'i'i 'gã ekyita 'ga po awi, 'ga akaga nupãu ipyu. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","A'ere 'gã 'ga rerekoemã re taity piraga moia 'ga wi nũ. A'ere 'gã 'ga raity munepa 'ga wi nũ. A'ere 'gã 'ga rerawau 'ga jukaaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jerusareg awi Jejui 'ga renuẽma ypy we 'gã Simão 'ga rekoaa, Sirene ywy pewara 'ga rekoaa. A'eramũ jefaruu 'gã 'jau 'ga upe: —'Ypeywara erokwap 'ga upe— 'jau 'gã 'ga upe. A'eramũ 'gã iupirukaa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Awau 'gã owaẽma Gogata 'jaw ipe. ('Gã je'eg imũ Gogata 'ea Aeakagera 'jawewara 'ea futat poromũ). ");
INSERT INTO kyzNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'Ga rerowaẽm ire 'gã muaga monou y'way pype 'ga upe numiamũ. A'ere 'ga reapyoramũ ee. A'eramũ 'ga itykure'ema. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","A'ere 'gã 'ga jywa pypiraa 'ypeywar are. A'ere 'gã itaju pyu 'ga pokutuka 'ypeywar are. A'ere 'gã 'ga py maju'aa aju'arimũ ikutuka itaju pyu. A'ere 'gã 'ga mafu'ama 'ga monou 'ga mu'ama 'ypeywara reewe futat. 'Ga rekoa futat 'gã imonou imu'ama 'ypeywar are ipokutuka. 'Ypeywar are 'ga mu'am ire 'gã 'ga raityfera mojo'oka ajaupe. Ita'i 'jawewara 'gã imomopoa 'upa ywyu. A'eramũ 'gã ijewag are 'ga raity mojo'oka. Sã'ã ae jugu momora. Nan futat 'gã ita'i 'jawewara momopori 'upa 'ga raityfera mojo'okawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Ga raityfera mojo'og ire 'gã wapyka 'upa 'ga rarũmũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A'ere 'gã 'yjepa'nĩ are ikwasiaripyrera monou inuga ikutuka 'yw are 'ga apyte'rarimũ. “Koromũ futat judeu 'gã 'wyriararetea” 'ea 'gã imonou ikwasiaa 'yjepa'nĩ are. A'ere 'ga resakara 'gã 'ga jukaawera kwaawi. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","'Ga reewe 'gã mukũja muna'ywa 'gã monou imu'ama 'ypeywar are. Muna'ywa põ'õ me 'gã Jejui 'ga mu'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","'Gã pyu okwap ma'e 'gã Jejui 'ga rerekoemãu 'ga kurapa: ");
INSERT INTO kyzNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—“Anure nipo je Jarejuwarete 'ga mogytaawa retygi. A'ere nipo je imuapyra 'ara rupi imowyri nũ”, ere 'ã rai'i. A'eramũ ene ejua ejypa 'ypeywar awi. Ejepoat ejetee futat— 'jau 'gã 'ga upe. —“Jarejuwarete 'ga ra'yramũ je”, ere 'ã jepi. A'eramũ ene ejua ejypa 'ypeywar awi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mainana 'wyriara 'gã, Moisesi 'ga remikwasiarer are moromu'jara 'gã, judeu 'gã 'wyria'ri 'gã. Mĩmera 'gã nanẽ 'ga rerekoemãu 'upa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Opoat 'ga 'gã jepi. A'ere 'ga nojepoara'uweri futari. Israeu juapyreramũ jane'wyriararetea e'i na a'e 'ga jepi re'ã? Siesag iki ajee 'ga rura 'ga jywa 'wei. 'Ga jyp 'ga ruramũ sirowiat 'ga 'jau 'wei— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","—“Jarejuwarete 'ga ree je jemogypyygi”, e'i 'ga 'ã akou jepi. Siesak 'ga 'ga poara 'jau. “Je 'ã 'ga ra'yra”, e'i 'ga 'ã akou jepi— 'jau 'gã 'ga rerekoemãu 'upa 'ga jaita. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","'Ga pyri imu'amipyrera 'ga amũ nanẽ 'ga kurapa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kwara okwapa aje owepa. Ypytuna 'jawe futat oypytunaiwamũ. Kwara ajerewamũ tãmẽjẽ awau weny jesagamũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kwara renye'emauwe Jejui 'ga wafukaita oje'eg imũ futat. —Eli eli lama sabactani— 'jau 'ga oje'eg imũ. Oje'eg imũ 'ga 'eawera: “Kiapi'ni, Kiapi'ni, ma'eramũ te erepoit je wi?” 'ga 'ea futat poromũ 'ga afukaja. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aipo 'ga 'e renupara 'gã amũ 'jau: —Eliasi 'ga 'ga wenũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Ga pyriwara 'gã amũ ujãna amynejuranũũ pyyka imonou imunepa y'waynana pype. A'ere 'ga imonou iupia 'ywa rapefã are imonou Jejui 'ga upe 'ga remipyteramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A'ere amumera 'gã 'i: —Tene ra'ne. Siesak Eliasi 'ga rura 'ga mosoga 'ypeywar awi ra'ne 'jau— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A'ere Jejui 'ga wafukaju'japa nũ. A'eramũ futat 'ga amanũmũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A'eramũ futat Janeruwarete 'ga mogytaawa my'jawa rowopypea taitya otoroka opojo'ogamũ mytera rupi. Ywate awi we futat 'ua opojo'ogamũ ywyu. Ywya otomoga 'ga manũnamũ, itauu nanẽ ojekajekau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Teumera monoawera nanẽ ojeawopytymo'woka nũ. Janeruwarete 'ga remiayuwa 'gã kwaiwete oferapa ũ'jãu ita kwar awi. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A'ere oferap ma'efera 'gã Jejui 'ga feraw ire etee te 'gã oi osou Jarejuwarete 'ga 'wyrarete pe, Jerusareg ipe. Kwaiwete Jerusareg ipewara 'gã 'gã nesaka. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jejui 'ga manũnamũ 'ga rarũarera 'gã 'ga manũ resaka. Jefaruu 'gã, o'wyriara 'ga retee 'ga manũ resaka. Mama'e tesirũgatua nanẽ 'gã esaka ywy yyja reewe. A'eramũ 'gã okyjau ajemogyau. A'eramũ 'gã 'jau: —A'jea futat 'ga Ku'jywa 'ga ra'yra futat ra'e— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A'e pype nanẽ Jejui 'ga rewiri ako ma'efera 'gã kũjãmera 'gã 'upa muku'i 'ga manũ resaka nũ. Garireja ywy awi 'ga rupi 'ut ma'efera 'gã futat. 'Ga rewiri futat 'gã akou mama'ea 'ga upe iapoaramũ. Poromũ kũjãmera 'gã 'up 'ga manũ resaka. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ẽẽ mũ rera Mari Matarena, ajepeja ẽẽ rera Mari. Aipoa Mari ẽẽ Tiago 'ga y ẽẽ Jose 'ga retee. Sepeteu 'ga ra'yra 'gã y ẽẽ nanẽ akou 'gã pyri nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Kaaruwamũ Jose 'ga, Arimateja pewarera 'ga awau Jejui 'ga reumera renũina Piratu 'ga upe. —Amanũ Jejui 'ga ko. 'Ga reumera toroo inuga ita kwara pype 'jau— 'jau 'ga awau Piratu 'ga upe. A'eramũ Piratu 'ga 'jau 'ga upe: —Ere 'ga rerawau inuga ipype— 'jau 'ga 'ga upe. A'eramũ Piratu 'ga oje'ega monou jefaruu 'gã nupe: “Pemut Jejui 'ga reumera imojypa 'ypeywar awi imonou Jose 'ga upe”, 'jau 'ga oje'ega monou 'gã nupe. Jose 'ga Jejui 'ga rerowiaara 'ga futat. Ika'aranũũ kwai ma'e 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","'Ga poromũ Jejui 'ga reumera weroo iauwana inuga taity yau pyu, linu 'jawa pyu. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A'eramũ 'ga 'ga reumera monou inuga ita kwara pype. Ita kwar yaua poromũ. Jose 'ga futat iapoukaa rakue. Ojeupe futat 'ga iapoukaa rakue numiamũ. A'ere 'ga Jejui 'ga reumera monoi inuga oma'eramera pype futat. 'Ga mono re 'ga itapewuu mojerepa imonou imỹina ita kwara rawopytymawamũ. A'ere 'ga awau jui. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Matarena ẽẽ ajepeja Mari ẽẽ retee wapyka 'upa ita kwara rowase. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ai'iwe mainana 'wyriara 'gã fariseu 'gã netee awau oporogytau Piratu 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Orerea'ar ore Jejui 'ga 'meawer are. Amanũme'ẽwe 'ga 'meramũ oree ikue: “Anure nipo je manũi. A'ere nipo imuapyra 'ara rupi je ferawi nũ”, e'i futatee 'ga ikue— 'jau 'gã imome'wau Piratu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","—A'eramũ jefaruu 'gã amũ iarũmũ oree. Kasi a'e pe 'ga remiayuwera 'gã nuri 'ga reumera rerawau imima kwe pe ne. A'eramũ 'gã 'jau ne: “Oferap futat 'ga u'eawer imũ etee futat ra'e”, 'jau futatee nipo 'gã 'ga reumera mim ire ne. Aipo 'e re taetu 'gã 'mea 'ga 'meawera apyraawi ne— 'jau 'gã Piratu 'ga upe. —“Je te 'ã Ku'jywa 'ga remimurera”, e'i futatee 'ga ako ikue. A'ere 'ga 'me ate 'ga rekoramũ rakue. A'eramũ 'ga reumera mimarera 'gã 'mea 'ga 'meawera apyraapa ne— 'jau 'gã Piratu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","A'eramũ Piratu 'ga 'jau 'gã nupe: —Pe'je ajee jefaruu 'gã amũ rerawau iaaranamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A'eramũ 'gã jefaruu 'gã nerawau ita kwar ipe. A'ere 'gã ita kwara rawopytymawa mojewaka. “'Gã amũ ipe'aramũ torokwaap 'gã iawopytymo'wokawera imojewakawer are 'jau”, 'jau 'gã jefaruu 'gã nupe. A'ere judeu 'gã awau imojewag ire. Jefaruu 'gã etee ejaa iarũmũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ikoai'i, ku'emaiw are, Mari Matarena ẽẽ awau ajepeja Mari ẽẽ retee ita kwara resaka. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Poje ywy oyyita 'gã nee. Janeruwarete 'ga pyriwara 'ga amũ 'ua ojypa ywag awi 'gã nupe, ita kwara rawopytymawa pe'au jui 'gã nupe. A'ere 'ga 'ũina i'arimũ 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wenyfugamũ 'ga tupã werawa 'jawe. 'Ga ryrũa nanẽ waparasigayramũ 'ga ree nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ywag awi 'ut ma'efera 'ga resakawe ita kwara rarũara 'gã okyjau oyyita 'ga wi. A'eramũ 'gã ajemogymogyau etee amanũ ma'e 'jawe. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A'eramũ ywag awi 'ut ma'efera 'ga 'jau kũjãmera 'gã nupe: —Pekyje awi je wi— 'jau 'ga 'gã nupe. —Jejui 'ga resaka te 'ã pejot, 'ypeywar are amanũ ma'efera 'ga resaka te 'ã pejot. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A'ere 'ga nitywi 'au. Oferap ako 'ga ko, u'eawer imũ etee futat ko. Pe'je pejejua 'ga rupawera resaka— 'jau 'ga 'gã nupe. A'eramũ 'gã awau osou esaka. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A'eramũ 'ga 'jau 'gã nupe nũ: —Pe'je pejewau pejejãna imome'wau 'ga remimu'e 'gã nupe. “Oferap kĩã awau Garireja ywy pe pẽ nenune. Peu nipo kĩã peesak”, pe'je ki 'gã nupe— 'jau 'ga kũjãmera 'gã nupe. —A'jea futat je imome'ui pẽ nupe— 'jau 'ga kũjãmera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A'erauwe kũjãmera 'gã awau ũ'jãu ita kwar awi. Awau ujãna Jejui 'ga remimu'eferamũ orepiara rupi. “Pekwap imome'wau” 'e ypyrauwe 'gã ujãna awau orepiara rupi. Okyjau futat 'gã ywag awi 'ut ma'e 'ga wi numiamũ. A'ere 'gã ku'iramũ etee ajemogyau awau ujãna. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","'Gã waw ipe Jejui 'ga 'ua 'gã nekoaa. —'Au te peko ra'e? Pẽpy'ata'waawa owaẽm pẽ nupe— 'jau 'ga 'gã nupe. A'erauwe kũjãmera 'gã 'ua 'ga rerowyka anuruka 'ua 'ga py pyyka opou. A'eramũ 'gã 'jau 'ga upe: —Ene te 'ã eneresage oree, Ku'jyp— 'jau 'gã 'ga upe 'ga rowase wããpyramũ 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pekyje awi. Pe'je pejewau je mome'wau jeremimu'efera 'gã nupe. “Pe'je pejewau Garireja ywy pe. Peu tajesaukat pẽ nupe 'jau”, e'i kĩã pẽ nupe ko, pe'je ki 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","A'e pype ita kwara rarũarera 'gã amũ awau osou Jerusareg ipe. Mainana 'wyriara 'gã nupe 'gã awau, wemiesagera mome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ojeupe 'gã imome'u re mainana 'wyriara 'gã judeu 'gã 'wyria'ri 'gã majatykau ojee. A'eramũ 'gã ojeupe imome'upyrera mome'wau ajaupe: —Ma'ja te jane siapo 'awamũ?— 'jau 'gã ajaupe. —Simono kwaiwete ka'aranũũa iarũarera 'gã nupe kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","14","A'ere 'gã iarũarera 'gã nenũina oporonupa ee 'gã nupe. Imome'u re 'gã 'jau 'gã nupe: —Pemome'u kasi 'gã nupe ne. Pẽ'me oree. “Ypytunimũ ore serauwe Jejui 'ga remiayuwa 'gã amũ nuri amunarũmũ 'ga ree ra'e”, pe'je oree peje'meramũ— 'jau 'gã 'gã nupe. A'eramũ esakarera 'gã 'jau 'gã nupe: —Tee nũ'ũ. Mama'e rarũaramũ ae nosera'uweri nũ'ũ. “Oroser ore jui ra'e” 'e renuw ire 'wyriara 'ga amara'neramũ ore ree ne nũ'ũ— 'jau 'gã 'gã nupe. —Naani. 'Wyriara 'ga pẽ nenuw ire ore je'egi 'ga upe pẽ nupe. A'eramũ 'ga amara'ne'emamũ pẽ nee— 'jau etee 'gã 'gã nupe nũ. —Simepy pẽẽ pẽ'meramũ 'jau— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A'eramũ 'gã aipo 'gã 'eramũ 'gã mojerowiaa etee. —Nai'i— 'jau 'gã 'gã nupe. A'eramũ 'gã ka'aranũũ pyyka 'gã nui. A'eramũ 'gã awau o'me mokwasi'wau kwe pe. A'eramũ kwaiwete judeu 'gã 'gã 'me rerowiaa ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","“Garireja ywy pe pekwap Jejui 'ga resaka”, 'jau ywagipewara 'ga kũjãmera 'gã nupe rai'i. A'eramũ ore Jejui 'ga remimu'eferamũ arawau Garireja ywy pe. Peu oroo re ore arawau ywytyr ipe, 'ga 'eawer ipe etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jejui 'ga resakawe ore 'ga muorypa arajemogyau. —Ene te 'ã eneresage, ki Ku'jyp— 'jau ore 'ga upe 'ga resakawe. 'Ga resaka agawewi ore arajemogyau. A'etea 'gã amũ nuerowiari 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jejui 'ga 'ua ore rerowyka oje'ega oree: —Janeruwarete 'ga je mogo 'wyriaramũ najuejue etee futat pẽ nupe 'awamũ. Ywagipewara 'gã nupe, ywy pewaramũ pẽ nupe nanẽ nũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","—A'eramũ je 'jau 'awamũ pẽ nupe: Pe'je pejewau je mome'wau kwe pewara 'gã nupe najuejue etee futat. Amunawa moymoyka pejewau je mome'wau 'gã nupe, je rerowiarukaa 'gã nupe. Je rerowiar ire pẽẽ 'gã pymĩãu 'y pe. 'Gã pymĩãu pẽẽ iapou Jarejuwarete 'ga rer imũ, 'Ga ra'yrareteramũ je rer imũ, 'Ga 'Agesage 'ga rer imũ. Mĩmeramũ ore rer imũ ki pẽẽ 'gã pymĩãu 'y pe. ");
INSERT INTO kyzNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","A'eramũ pẽẽ 'gã mu'jau jeje'eg are. “Peenup katu katu ki 'ga je'ega”, pe'je ki 'gã nupe. Kwe pe pejewau pejejemogyau pejejea'aramũ je'e are. “Ywy teepawe'emamũ je rekoi pẽ pyri au'jeteramũ futat” je'e are pejejea'aramũ pejejemogyau au'jeteramũ futat— 'jau 'ga oree.");
INSERT INTO kyzNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Jejui Kristu 'ga je amome'u pẽ nupe. 'Ga 'ã Janeruwarete 'ga ra'yraretea. A'eramũ je morogyta esage mome'wau pẽ nupe 'ga ree. Ymã Janeruwarete 'ga ka'arana kwasiarukari Isai 'ga upe wa'yra 'ga ree rakue: “Teje'ega mome'wara 'ga ra'ne nipo je amono ene renune, ene raperugawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Amunawe'em ipe nipo 'ga amũ awau akou wafukaita 'gã nupe: ‘Pe'je Jarejararete 'ga rape katu'oka imonou 'ga renune. Pepyo esage etee futar iki imonou jarejeupe 'ga ruawamũ’, 'jau nipo 'ga akou wafukaita amunawe'em ipe”, 'jau Janeruwarete 'ga ikwasiarukaa Isai 'ga upe rakue. “Jarejararete 'ga rapea pekatu'ok 'ga renunewe”, 'jau 'ga 'gã nupe. Aipo upe 'ga 'i “pejetywer awi pepoit” 'e upe te 'ga 'i. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Isai 'ga remikwasiarer imũ etee futat ajee 'ã Juã Batista 'ga rekoi amunawe'em ipe Jarejuwarete 'ga je'ega mome'wau 'gã nupe rakue: —Pe'je pejepoia pejetywer awi. Jui pepoir ire je pẽ pymĩãu 'y pe, pejetywer awi pẽpoiawera resaukaawamũ. A'eramũ Janeruwarete 'ga pẽtywera moia pẽ nui, pẽ mogyau wemiayuwamũ— 'jau 'ga akou 'gã nupe amunawe'em ipe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judeja ywy pewara 'gã, Jerusareg ipewara 'gã netee awau Juã 'ga je'ega renupa. Otywer awi 'gã poir ire, Juã 'ga 'gã pymĩãu 'y pe. Jotãuy pe 'ga 'gã pymĩãu. “'Awamũ mama'e esage etee taapo 'jau, Jarejuwarete 'ga je'eg imũ 'jau”, 'jau 'gã ojepymĩãukaa 'y pe 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juã 'ga kameru rawa apopyrera rerekou waityramũ imunepa. Wyra pirera 'ga erekou aku'afaawamũ. 'Ga remi'ua tukut, eit. Mĩmera 'ga remi'ua rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jejui 'ga ree 'ga aipo 'jau rakue: —Je rewiri te nipo 'ga amũ ruri. 'Ga te kũima'eeteetea. Je nakũima'eeteete rũi. Akotee'i ma'ea te je— 'jau Juã 'ga 'gã nupe. —Apoat te je 'ga tekou. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Je 'ã a'jea futat apymĩ pẽẽ 'y pe tekou. A'ere 'ga te nipo Janeruwarete 'ga 'Agesagea amut pẽ nupe— 'jau Juã 'ga wenupara 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jotãuy pe Juã Batista 'ga rekoramũ Jejui 'ga 'ua owaẽma 'ga upe rakue. Garireja ywy awi, Nasare 'jaw awi 'ga 'ua owaẽma 'ga upe. A'e pe 'ga ojepymĩãukaa 'y pe Juã 'ga upe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","'Y awi awua ypy we Jejui 'ga amã'jãu ywau ywaga woga resaka. A'e awi Janeruwarete 'ga 'Agesagea 'ua ojypa 'ga ree. Pykau 'jawe 'ua ojypa 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","U'agesage jyw ire Janeruwarete 'ga oje'ega mua ywag awi wa'yra 'ga upe: —Ene te 'ã Jera'yraretea. Ene 'ã jeremifutararetea. Ene 'ã je muorypararetea ejee— 'jau 'ga oje'ega mua ywag awi 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aipo re Janeruwarete 'ga 'Agesagea Jejui 'ga rerawau amunawe'em ipe 'ga rerekou. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kwarẽta 'ara magwapa Jejui 'ga akou jũ me. Aipo pe 'ga rekwaw ipe futat mama'eukwaawa 'wyriara 'jau 'ga upe: “Tamotywerukat 'ga 'jau kwy”, 'jau mama'eukwaawa 'wyriara Jejui 'ga upe numiamũ. A'ere Jejui 'ga nomojerowiari futari mama'eukwaawa 'wyriara akou rakue. Aipo jũ me wyra jarũa kwaiwete agawewi. A'etea wyra nokoi 'ga ree. Omojerowiare'emauwe mama'eukwaawa 'wyriara ojepe'au 'ga wi. A'eramũ ywagipewara 'gã amũ 'ua ojejukau Jejui 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Anure Jejui 'ga Juã Batista 'ga rera renupa. “Juã Batista 'ga 'gã opyyk imonou imunepa imỹina moromunepawa pype ai'i” 'e renupawe Jejui 'ga awau jui, awau ojewya Garireja ywy pe nũ. Morogyta esagea 'ga awau imome'wau peuwara 'gã nupe, Jarejuwarete 'ga wi 'ut ma'efera morogyta esage mome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A'eramũ 'ga 'jau 'gã nupe: —Wemiayuwamũ pẽ mogy are Janeruwarete 'ga fueweramũ. A'eramũ ki pẽẽ pejepoia pejetywer awi. Anurenure'i nipo Janeruwarete 'ga wemimureramũ je mỹi 'wyriaramũ pẽ nupe. “Pejetywer awi pepoir ire 'ga pẽ katu'ogi pẽ mogyau wemiayuwamũ”, aipo 'ea ki perowiat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Garireja ypiauu reme'y'warimũ wataaw ipe Jejui 'ga pira rewara 'gã nesaka, mukũja 'gã nesaka. Simão Pedro 'ga taityuu momoa wewirera 'ga, Andre 'ga retee. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pe'je pejejua je rupi. Simu'e pẽẽ 'jau. Naipira rewara rũi pẽẽ 'awamũ. Jarejuwarete 'ga je'ega mome'wara te nipo pẽẽ 'awamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","A'erauwe 'gã taityuu rejaa awau 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iruupeu'i Jejui 'ga 'gã amũ nesaka nũ, Tiago 'ga 'ga rewirera 'ga, Juã 'ga retee nũ. Sepeteu 'ga ra'yra 'gã poromũ. Yaruu pype 'gã 'upa 'uwa 'ga pyri, taityuu momyka. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A'eramũ Jejui 'ga 'gã mo'wya nũ: —Pe'je pejejua je rupi pẽẽ nanẽ nũ— 'jau 'ga 'gã nupe. A'erauwe 'gã 'ua ũ'jãu yaruu awi. 'Uwa 'ga 'gã ejaa, 'ga upe oporowyky ma'e 'gã neewe. A'eramũ 'gã awau Jejui 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jejui 'ga wemimu'e 'gã nerekou eruatau. Awau 'gã owaẽma Kafanaũ pe. Morowykye'ema rupi 'gã awau osou judeu 'gã jatykaaw ipe. A'eramũ Jejui 'ga ajatyka ma'e 'gã mu'jau 'Uwarete 'ga je'eg are. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","'Ga renupara 'gã oporesagamũ ajemogyau 'ga ree. 'Wyriara 'jawe 'ga oporogytau 'gã nupe. A'eramũ 'ga 'gã moporesagukaa etee ojee. —Kuu. 'Ga pa'e aipo e'i ae mu'jau ra'e nũ. NaMoisesi 'ga remikwasiarer are moromu'jara 'gã 'jawe rũi 'ga porogytai. Moisesi 'ga 'eawer are moromu'jara 'gã Moisesi 'ga 'eawer imũ etee futat 'gã ae mu'ei— 'jau 'gã ajaupe. —A'ere Jejui 'ga nanarũi. U'eawer imũ etee futat 'ga jane mueapyoi ee— 'jau 'gã ajaupe, oporesagamũ Jejui 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A'e pype mama'eukwaawa rerekwara 'ga amũ 'ua owaẽma 'gã nupe. Mama'eukwaawa 'ga wereko. A'eramũ 'ga muafukaita: ");
INSERT INTO kyzNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jejui! Nasare pe waranup ma'eramũ je 'i ene upe: Ma'ja are te ereko ki sa?— 'jau mama'eukwaawa Jejui 'ga upe. —Ore momapa te erejot ra'e? Akwaap je ene. Jane 'arimũwara 'ga remimurera te 'ã ene— 'jau mama'eukwaawa Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A'eramũ Jejui 'ga 'jau jupe: —Epije ene ekou. Ere ejepe'au 'ga wi— 'jau Jejui 'ga jupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A'eramũ 'ga pirewara 'ga wi uẽmawamũ 'ga monou 'ga moyyita nanimenime. A'eramũ 'ga pirewara waemamũ ojepe'au 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A'eramũ esakarera 'gã opiryyjamũ 'ga pirewara pe'aramũ. A'eramũ taetu 'gã oporesagamũ 'ga ree. A'eramũ 'gã 'jau ajaupe: —Kuu. Maran te 'ga mama'eukwaawa pe'ai 'ga wi nũ'ũ? Mama'e yau are te 'ga jane mu'ei? Mama'eukwaawa miamũ 'ga je'ega wenup a'i kũi. Oje'eg imũ etee futat 'ga mama'eukwaawa mojepe'aukari erekwara 'ga wi— 'jau 'gã ajaupe, oporesagamũ Jejui 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mama'eukwaawa wejue 'ga imonou 'ga wi. A'eramũ taetu Jejui 'ga rera okwasi'wau Garireja ywy pype kamẽsĩete. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","A'ere Jejui 'ga uẽma judeu 'gã jatykaaw awi wemimu'e 'gã netee. A'eramũ Simão Pedro 'ga, wewirera Andre 'ga retee 'ga mo'wya oje'wyr ipe. A'eramũ Jejui 'ga awau. Tiago 'ga, Juã 'ga. Mĩmera 'gã 'ga erawau. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simão 'ga rojo ẽẽ oro'yramũ 'upa okama pype. Jejui 'ga rerowaẽmawe Pedro 'ga 'jau 'ga upe: —Jerojo ẽẽ iro'y. Esak ẽẽ ẽẽ ro'y awi— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A'erauwe Jejui 'ga awau ẽẽ resaka. A'eramũ 'ga ẽẽ popyyka, ẽẽ ro'ya moia ẽẽ wi. A'eramũ 'ga ẽẽ mowya ẽẽ kama awi. A'eramũ futat ẽẽ afu'ama mama'e apou 'gã nupe, 'gã mojemi'waa. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kwara rese re, peuwara 'gã ojero'wu ma'e 'gã nerua Jejui 'ga upe. Mama'eukwaawa rerekwara 'gã nanẽ 'gã erua nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Amunaw ipewara 'gã ajatykaupap futat ukaripe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A'eramũ Jejui 'ga ojero'wu ma'e 'gã majarueteupap. Mama'eukwaawa nanẽ 'ga ipe'au kwaiwete 'gã nui. Mama'eukwaawa Jejui 'ga okwaap futat numiamũ. A'ere Jejui 'ga nomoje'egukari, erekwara 'gã nui ipe'au. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ypytu'nĩnauwe Jejui 'ga afu'ama awau awotywe'eme oje'ega monou 'Uwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simão Pedro 'ga, opytuna 'gã netee awau kwe pe Jejui 'ga rekaa. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","'Ga rekoar ire 'gã 'jau 'ga upe: —Mytuna 'gã ene rekat, ki Ku'jyp. Soo jarejewya 'gã pyri 'jau— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pe'je iruukwe. 'Awamũ jane oi ajepeja amunaw ipe te— 'jau 'ga wemimu'e 'gã nupe. —Janeruwarete 'ga je mono kwe pe nũ. “Kwe pe ekwap je mome'wau 'gã nupe”, e'i 'ga jee ikue. “Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoiri pẽ nui, pẽ mogyau wemiayuwamũ”, ta'e 'gã nupe 'jau— 'jau 'ga 'gã nupe. —Kwe pewara 'gã nupe aipo mome'wawamũ nanẽ je ruri nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A'eramũ Jejui 'ga awau watau Garireja ywy raapa. Judeu 'gã jatykaaw ipe 'ga 'gã mu'jau morogyta esage are. “Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoiri pẽ nui, pẽ mogyau wemiayuwamũ”, 'jau 'ga 'gã nupe, 'gã mu'jau ee. Mama'eukwaawa nanẽ 'ga imoia erekwara 'gã nui nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ipito'om ma'e 'ga 'ua Jejui 'ga pyri. Wenupy'ãu 'ga wapyka 'jau Jejui 'ga upe: —Je resag ape, ki Ku'jyp. “Jejui 'ga ae katu'okara”, e'i 'gã jee. A'eramũ je tejua tejesaukaa enee. Je ree ejemuaẽmiweramũ je mokã'ẽ ape— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aipo ojeupe 'ga 'erauwe Jejui 'ga ajemuaẽma 'ga ree. A'eramũ 'ga opo monou ipito'om ma'e 'ga 'arimũ. —Ko ajee je ene mokã'ẽi 'wei— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Oje'arimũ 'ga po mono ypyrauwe okã'jãu 'ga pito'oma 'ga wi. A'eramũ futat 'ga pira ojekatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","A'eramũ Jejui 'ga 'jau 'ga upe: —Eremome'u kasi emokã'ẽawera tekotee 'gã nupe ne. Ere ewau ejesaukaa mainana 'ga upe ra'ne. “Je resag ape. Jepito'oma okã'ẽ je wi”, ere ewau 'ga upe. “A'jea futat ra'e”, te'i 'ga enee 'jau, ene resaka 'jau— 'jau Jejui 'ga 'ga upe. —A'ere ene ejeymawa mũ rerawau 'ga upe. A'eramũ 'ga iapyau Jarejuwarete 'ga upe, 'ga muorypa enekã'ẽawer are— 'jau Jejui 'ga 'ga upe. —Moisesi 'ga 'eawer imũ etee futat ene ejeymawa mũ rerawau iapyaukaa Jarejuwarete 'ga muorypawamũ. Ejeymawa mũ rapyaukara ene ekã'ẽawera resaukaawa futat— 'jau Jejui 'ga ipito'om ma'efera 'ga upe. A'eramũ Jejui 'ga 'ga monou mainana 'ga pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","A'ere ipito'om ma'efera 'ga omokã'ẽawera nomimi futari, Jejui 'ga rera mokwasi'wau amunawa pype. A'eramũ Jejui 'ga rera renupara 'gã aku'iramũ 'ga ree. —Kuu. Jejui 'ga 'ga pito'oma omokã'ẽ 'ga wi. Niesagi futari jane 'ga amũ 'gã pito'oma mokã'ẽa jepi— 'jau 'gã ajaupe. A'eramũ 'gã oporesagiweramũ Jejui 'ga ree. A'eramũ Jejui 'ga osowe'em amunawa pype. Amowapirukare'emamũ 'ga nosei amunawa pype. Awotywe'em ipe etee futat 'ga akou. A'eramũ kwaiwete 'gã 'ua 'ga rekaa. Tesirũmer imũwara 'gã 'ua 'ga rekaa. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ko'iko'i ete Jejui 'ga awau ojewya Kafanaũ pe nũ. A'erauwe 'ga rera okwasi'wau amunawa pype kamẽsĩete. “'Ut Jejui 'ga owaẽma ra'e”, 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A'eramũ mytuna 'gã awau ajatykau 'ga ree, ojejaga 'ga rekwawa 'oga pype. A'eramũ 'gã 'oga matyneema. Nitywi futari ae pyrugawa. 'Okwar ipe miamũ futat nitywi ae pyrugawa. A'eramũ Jejui 'ga Jarejuwarete 'ga je'ega mome'wau 'gã nupe. “Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga pẽtywera moiri pẽ nui, pẽ mogyau wemiayuwamũ”, 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","A'e pype irũpãwẽ 'gã iteu ma'e 'ga rerua, 'ga rupia. 'Ga rupawa pype 'gã 'ga rerua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","A'ere 'oga nijumypykwari ae pyu. A'eramũ 'gã 'ga rerosowarũe'em. A'eramũ 'gã 'ga rerawau 'ga rerojeupia 'opewuu apyte'rarimũ. A'eramũ 'gã 'oga pyrau'jaw ape mopoka jui. Imopog ire 'gã iteu ma'e 'ga monou imojypa. 'Ga rupawa reewe futat imonou tupaama pyu Jejui 'ga rowase. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","A'eramũ Jejui 'ga 'jau ojeupe: “Je rerowiat pa 'gã ajemogyau ra'e”, 'jau 'ga ojeupe. A'eramũ 'ga 'jau iteu ma'e 'ga upe: —Enetywera je amoit ene wi ki 'ei— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jejui 'ga 'e renupawe Moisesi 'ga remikwasiarer are moromu'jara 'gã amũ 'jau ojeupe etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kuu. Maran te 'ga nokyjei aipo 'e awi nũ'ũ? Jarejuwarete 'ga 'ga akurap ra'e. Janeruwarete 'ga etee te janetywera omoit jane wi. A'ere 'ga ‘Enetywera je amoit ene wi’ 'eramũ 'ga ‘Je Jarejuwarete 'ga 'jawe je rekoi’ 'ga 'i”, 'jau 'gã ojeupe etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","A'ere Jejui 'ga 'gã kwaawi ojee. A'eramũ 'ga 'jau 'gã nupe: —Ma'eramũ pẽẽ poromũ 'jau pejejeupe 'ũ?— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","—Je upe naayi. Iteu ma'e mafu'amaramũ ae nanẽ ojotywera moiri ajaui nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","—Pẽneki'yra je 'ã. A'eramũ je tepãjẽ resaukaa pẽ nupe. Iteu ma'e 'ga je amafu'am pẽ neape. 'Ga fu'ama resaka tajekwaap pejepe 'jau— 'jau Jejui 'ga 'gã nupe. —“Aeteufera 'ga amafu'am. Aetywera 'ga omoit nanẽ ae wi nũ”, tepe'je 'jau. Jeruwarete 'ga te 'ã opãjẽ amut jee. A'eramũ je pẽtywera moia pẽ nui, iteu ma'ea mafu'ama nanẽ nũ— 'jau 'ga 'gã nupe. A'eramũ 'ga 'jau iteu ma'e 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ere efu'ama jui. Ejupawa pyyka erawau eje'wyr ipe— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aipo ojeupe 'erauwe iteu ma'e 'ga afu'ama 'gã neape. A'eramũ 'ga wupawa pyyka erawau enuẽma 'og awi. A'eramũ 'ga resakarera 'gã 'jau: —Kuu. Amafu'am 'ga 'ga ki 'ei— 'jau 'gã ajaupe. A'eramũ 'gã oporesagamũ 'ga ree. A'eramũ 'gã 'jau Jarejuwarete 'ga upe: —Ene te 'ã eneresage. Naruesagi ore nanuara mama'ea jepi— 'jau 'gã Jarejuwarete 'ga upe, 'ga muorypa ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A'ere Jejui 'ga awau Garireja ypiau upe nũ. Kwaiwete 'gã awau 'ga rewiri 'ga rekaa. Wekoaramũ 'ga 'gã mu'jau 'Uwarete 'ga je'eg are. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Awaw ipe Jejui 'ga Levi 'ga resaka. Aufeu 'ga ra'yra 'ga. 'Wyriararete upe ka'aranũũ pyykara 'ga poromũ Leviramũ. 'Ga porowyky 'ga renamũ Jejui 'ga 'jau 'ga upe: —Ere ejua je rupi— 'jau 'ga 'ga upe. A'erauwe Levi 'ga afu'ama awau Jejui 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Anure Jejui 'ga ojemi'waa Levi 'ga 'wyr ipe wemimu'e 'gã netee. 'Gã neewe 'wyriararete upe ka'aranũũ pyykara 'gã ojemi'waa. Mama'e tywera apoara 'gã nanẽ ojemi'waa 'gã pyri nũ. Jejui 'ga rewiri oo ma'e 'gã poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'gã Jejui 'ga resaka, mama'e tywera apoara 'gã pyri 'ga jemi'waa 'ga renamũ. Aipo moromu'jara 'gã fariseua. Jejui 'ga resakawe 'gã 'jau 'ga remimu'e 'gã nupe: —Kuu. Ma'eramũ pẽ mu'jara 'ga ojemi'waa 'wyriararete upe ka'aranũũ pyykara 'gã pyri 'ũ? Nia'wyri 'gã kũi. Mama'e tywera apoara 'gã pype nanẽ 'ga reni ojemi'waa kũi. Nojemi'wari noko ae 'gã pyri 'ja. Nia'wyri 'gã ajemogyau kũi— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aipo 'ga 'e renupawe Jejui 'ga 'jau 'gã nupe: —'Gã pyri je rekoi 'gã poaawamũ te nũ'ũ. Je 'ã morofuanugara 'jawewara te ako 'gã nupe. Sã'ã morofuanugara 'ga muaga monoa ojero'wu ma'e 'gã nupe etee. Nomono ekoetei futari 'ga ijero'wue'ema 'gã nupe muaga. Nan tee futat je. Ia'wyre'ema 'gã katu'okawamũ te je ruri ikue. “Je jeresage”, pe'je 'ã. A'ere je naesage ma'eramũ rũi je ruri pẽ katu'oka. Itywet ma'e 'gã katu'okawamũ tee je ruri ikue— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juã Batista 'ga remiayuwa 'gã oporogytau Jarejuwarete 'ga upe ojemi'ware'eme. Fariseu 'gã nanẽ 'gã 'jawe ete iapou nũ. A'eramũ 'gã amũ 'jau Jejui 'ga upe: —A'jea futat nũ'ũ. Juã Batista 'ga remiayuwa 'gã ojemi'ware'ema futat oje'ega Jarejuwarete 'ga upe jepi. Fariseu 'gã nanẽ ojemi'ware'ema oporogytau 'ga upe nũ. Ma'eramũ ajee eneremiayuwa 'gã nanarũi 'ũ? Niojeri agawewi 'gã 'ã ojemi'war awi. A'etea 'ã 'gã oje'ega omono Jarejuwarete 'ga upe— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A'eramũ Jejui 'ga 'jau 'gã nupe: —Akokatu ma'e 'gã nekokaturamũ sipo 'gã nekokatu resakara 'gã ty'ara rerajemogyi maraka are? Naani. Sã'ã akokatu ma'e 'gã nekoramũ ae poire'ema ojemi'war awi. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","A'eramũ 'gã ore tãmẽjẽ opoia ojemi'war awi oporogytau Jarejuwarete 'ga upe— 'jau Jejui 'ga oje'ega 'gã nupe. —Nan tee futat jeremiayuwa 'gã niojeri ojemi'war awi ojepyri je rekoramũ. Ojewi je o re te nipo 'gã nojemi'wari ajemogyau. Je o re nipo 'gã 'arasigamũ ajemogyau je ree. A'eramũ nipo 'gã ojemi'ware'ema ajemogyau wea'aramũ je ree— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Ymã te 'ã aeypy 'gã pẽ mu'ei mama'e are rakue. A'ere je 'ã 'awamũ pẽ mu'ei nũ. Amutee are je 'awamũ pẽ mu'ei nũ. A'ere nepemojopypea'uweri jeporogyta aeypy 'gã nemimome'ufer are. Jeporogyta are ojemu'e ma'eramũ ki a'ea etee futat peapo. Pemojopype kasi morogyta ymaner are ne. Morogyta ymaner are ojemu'e ma'e 'gã nuapoi jeporogytau mama'ea— 'jau Jejui 'ga 'gã nupe. —Naperugi ae taity ymanera taity yau pyu. Kasi a'e pe opoejamũ taity yau erojefuapygi etee ne. A'eramũ futat taity ymanera otoroka etee nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y'way yau ae nueko'wogi yrũ ymanera pype. Yrũ yau pype te ae eko'wogi. Yrũ ymana pype sieko'wok 'eramũ ajaiwamũ erujewi. A'eramũ futat opy'apefugamũ wajaiwamũ yrũ pype. A'eramũ futat wyrũ kakau. A'eramũ ojeko'woka. Yrũ yau pype eko'wog ire ojeko'woke'ema. Wyrũa kawe'em nanẽ nũ. Nan tee futat nepemojopypearũi jeporogytafera morogyta ymanera pyu— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Morowykye'ema mũ rupi Jejui 'ga awau juowuurana ko pyterimũ wemimu'e 'gã netee. Wataaw ipe 'ga remimu'e 'gã a'ỹja pa'wau opo pe erawau. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'Gã nesakawe fariseu 'gã amũ 'jau Jejui 'ga upe: —Kuu. Emã'ẽ 'gã nee ki sa. Eneremiayuwa 'gã opo'o a'ỹja i'wau ra'e ki sa. “Noporowykya'uweri ae morowykye'ema rupi”, e'i nã'ã Moisesi 'ga jepi re'ã. Juowuuran a'ỹja po'oa aeporowykya futat. Ymã te 'ã Moisesi 'ga 'i rakue: “Peporowyky kasi morowykye'ema rupi ne”, 'jau 'ga 'ã rakue a'i kũi— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'ja ajee Davi 'ga wapo rakue? Nepemogytai nipo ka'arana 'ga remiapofer are? Davi 'ga 'ã opy'arayparamũ opytuna 'gã netee akou rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A'eramũ 'ã 'ga awau osou Jarejuwarete 'ga mogytaaw ipe rakue. Ymã Apiata 'ga 'ũina 'wyriaramũ mainana 'gã nupe rakue. 'Ga renaw ipe Davi 'ga osou Jarejuwarete 'ga mogytaaw ipe rakue. A'e pe 'ga kanape pyyka ojeupe rakue. A'eramũ 'ga i'wau. Opytuna 'gã nupe nanẽ 'ga imonou 'gã i'wawamũ rakue. Na'gã nemi'ua rũi poa numiamũ. Mainana 'gã etee aipo a'u. A'etea Davi 'ga opy'araypara rerekou a'u opytuna 'gã netee rakue— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A'eramũ 'ga 'gã mueapyou morowykye'em are: —Ymã Janeruwarete 'ga morowykye'ema mogoi janeypy 'gã nupe rakue, 'gã pytu'wawamũ rakue. Omuorypawamũ nanẽ 'ga iapou rakue nũ. Namorowykye'ema rũi 'ga wapo tenune. Aeypy 'gã na'ne tee 'ga wapo rakue. A'ere te 'ga morowykye'ema apoi 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Je 'ã pẽneki'yraretea, Jarejuwarete 'ga remimurera. A'eramũ je 'jau pẽ nupe: “Je 'ã morowykye'ema jara”, 'jau je pẽ nupe. A'eramũ je tee pẽ mu'jau morowykye'ema rupi pẽnemiapoe'em are— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Anure Jejui 'ga awau osou judeu 'gã jatykaaw ipe nũ. A'e pe ipoteu ma'e 'ga wapyka 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","'Ga resakawe Jejui 'ga ree iporomutare'ema 'gã amũ 'jau ajaupe nũ: —'Awamũ 'ã morowykye'ema. Maran sipo 'ga 'awamũ ipoteu ma'e 'ga rerekoi nũ?— 'jau 'gã ajaupe. —'Ga po katu'ogamũ ki sa'e 'ga upe: “Nuenuwi futari 'ga Moisesi 'ga porogytafera ra'e”, sa'e ki 'ga upe a'i kũi— 'jau 'gã 'upa ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A'ere Jejui 'ga ikwaawi ojee. A'eramũ Jejui 'ga 'jau ipoteu ma'e 'ga upe: —Ere ejua 'au je pyri— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A'eramũ 'ga 'jau wesakara 'gã nupe: —Ma'ja e'i te Moisesi 'ga morowykye'ema upe rakue? “Esage ma'ea etee ki peapo”, e'i te 'ga janee rakue? “Ia'wyre'ema etee ki peapo”, e'i te ra'u 'ga janee rakue nũ? “Pejokatu'og iki”, e'i te 'ga janee rakue, “Tene imanũi”, e'i te ra'u 'ga janee rakue nũ?— 'jau Jejui 'ga 'gã nupe. A'ere 'gã noje'egi futari amũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A'eramũ Jejui 'ga amã'jãu 'gã nee ra'ne 'gã moyka. Amara'neramũ 'ga 'gã nee. A'ere 'ga 'arasigamũ nanẽ 'gã nee nũ. Naeapyoweri wejue 'gã 'ga je'eg are. A'eramũ 'ga 'gã neru'arasiga. A'ere 'ga 'jau ipoteu ma'e 'ga upe: —Epo epopyo— 'jau 'ga 'ga upe. A'erauwe futat ipoteu ma'e 'ga opo popywau. A'eramũ futat 'ga po ojekatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","A'e resakawe fariseu 'gã ũ'jãu Erote 'ga remiayuwa 'gã netee. Amara'neramũ 'gã Jejui 'ga ree, morowykye'ema rupi 'ga 'ga katu'ogamũ. A'eramũ 'gã afueweramũ 'ga ree. —Maran te jane Jejui 'ga jukai?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","A'ere Jejui 'ga awau wemimu'e 'gã netee Garireja ypiauu pe nũ. Kwaiwete 'gã awau 'ga rupi. Garireja ywy pewara 'gã, ");
INSERT INTO kyzNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judeja ywy pewara 'gã, Jerusareg ipewara 'gã, Itumeja ywy pewara 'gã, Jotãu ry owajara katywara 'gã, Tiro 'jawa pyriwara 'gã, Sidoma 'jawa pyriwara 'gã. Mĩmer ipewara 'gã awau Jejui 'ga pyri. 'Ga rera wejue 'gã wanup. A'eramũ 'gã awau 'ga pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Kwaiwete 'gã nuri 'ga pyri. Kwaiwete wejue 'ga ojero'wu ma'e 'gã majarueteu. A'eramũ ojero'wu ma'e 'gã ajamuajãna 'ga ree 'ga pyyg are. —Eyry'gi je wi. Je pa'e nũ, ene py'rau nũ— 'jau 'gã ajaupe. A'eramũ Jejui 'ga 'jau wemimu'e 'gã nupe: —Yara perut amũ jee. Yar ipe too te'aa 'gã nui 'jau. Kasi a'e pe 'gã naje moporogytaarũukari ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","'Ga resakawe mama'eukwaawa rerekwara 'gã u'aa ojenuga Jejui 'ga rowase. A'eramũ 'gã wafukaita: —Ene 'ã Ku'jywa 'ga ra'yraretea— 'jau mama'eukwaawa rerekwara 'gã wafukaita. Mama'eukwaawa 'gã muafukaita. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A'eramũ Jejui 'ga 'jau jupe: —Pẽẽ we aipo pe'je awi. Pẽẽ we 'ã aipo pe'je ekoete— 'jau 'ga mama'eukwaawa rerekwara 'gã nupe, oje'ega moywyrafena. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Anure Jejui 'ga awau ojeupia ywyty'rarimũ. Wemifutara 'gã 'ga enũina: —Pe'je pejejua 'au je pyri— 'jau 'ga 'gã nupe. A'eramũ 'gã awau 'ga repejãna 'ga rerowyka. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A'eramũ 'ga 'gã amũ mũ'jãu 'gã nui. 'Ga remimũ'ẽmera 'gã pytuna tusi. —Pẽẽ je amũ'ẽ 'gã nui tejepyriwaramũ. Anure nipo je pẽ monoi kwe pe morogyta esage mome'waramũ 'gã nupe, “Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoiri pẽ nui, pẽ mogyau wemiayuwamũ” 'e mome'waramũ— 'jau 'ga 'gã nupe. A'eramũ 'ga 'jau 'gã nupe nũ: “Jeremimonorama 'gã”, 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","'Gã nupe nanẽ 'ga opãjẽ monoi. —Tepãjẽa je amono pẽ nupe mama'eukwaawa pe'aawamũ erekwara 'gã nui— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aipo 'gã 'ga imũ'jãu wemimonoramamũ: Simão 'ga. Anure Jejui 'ga 'ga re'roka Pedroa pyu. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiago 'ga, Juã 'ga retee. Aipo 'gã nuwa Sepeteu. Oje'eg imũ Jejui 'ga 'jau 'gã nupe Puanerigi 'jau 'ga 'gã nupe. Aeje'eg imũ Puanerigi 'ea Tupã ra'yra 'ea poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre 'ga, Filipe 'ga, Patarumeu 'ga, Mateu 'ga, Tome 'ga, Tiago 'ga. Ajepeja 'ga, Tiago 'ga Aufeu 'ga ra'yra. Tadeu 'ga, Simão Serote 'ga, ");
INSERT INTO kyzNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariote 'ga. Kũima'e tywera 'gã nupe 'ga me'egara 'ga poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","'Og ipe 'ga oramũ mytuna 'gã ajatykau 'ga ree. Kwaiwetewete wejue 'gã. A'eramũ Jejui 'ga ojemi'wararũme'em wemimu'e 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aipo renupawe Jejui 'ga jara 'gã 'jau 'ga upe. “'Ga jemuarũe'ema te 'ga wereko”, 'jau 'gã Jejui 'ga upe. A'eramũ 'gã awau 'ga upe. —Ere ejua 'gã nui— 'jau 'gã awau 'ga upe. A'ere 'ga nooi. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusareg awi Moisesi 'ga remikwasiarer are moromu'jara 'gã nuri rai'i. A'eramũ 'gã 'jau 'ga upe: —Mama'eukwaawa 'wyriara je'eg imũ etee 'ga mama'e apoi. Pesepu pãjẽ mũ etee 'ga 'gã pirewara pe'ai 'gã nui— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","A'eramũ Jejui 'ga 'gã nenũina ojepyri. A'eramũ 'ga 'gã mu'jau ee. Mama'ea 'ga imome'wau 'gã nupe, 'gã mu'jawamũ. —Maran sipo mama'eukwaawa 'wyriara a'eramũ wemiayuwa pe'ai 'gã nui? Nope'ai futari. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sã'ã ywy pypewara 'gã ajuee amara'neramũ 'gã jo'oga ajaui. A'eramũ 'gã amunipo ajuapisau. A'eramũ futat 'gã amunipo ojomateepapa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","—Sã'ã majepeja amunaw ipewara 'gã. Ajaui ojo'og ire majepeja amunaw ipewara 'gã nãnẽwẽjẽmĩ ajuapisau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nan iapo re amunipo 'ã mama'eukwaawa remiayuwa jomateepawi ajaupi etee futat. Mama'eukwaawa 'wyriara nomonoi futari wemiayuwa erekwara 'gã nui— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","—Ose sipo muna'ywa ifuakat ma'e 'ga rog ipe, 'oga jara 'ga fare'em ire? Naani. Nosea'uweri. Ifuakat ma'e 'ga far ire etee isei 'ga rog ipe, 'ga karaemã pojekau 'ga wi. Mama'eukwaawa 'wyriara ifuakat ma'e 'jawe futat. Ipãjẽ futat numiamũ. A'ere Janeruwarete 'ga te pãjẽretea, mama'eukwaawa 'wyriara pãjẽ apyraapa. Ma'eramũ 'ã ae Jarejuwarete 'ga pãjẽ mũ etee mama'eukwaawa pe'ai 'gã nui— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Pẽnea'at ki pẽẽ je'e are. Janeruwarete 'ga pẽtywera moia pẽ nui, jui pẽpoiriweramũ. Akuraparamũ miamũ 'ga pẽtywera moiri pẽ nui ojeupe pẽẽ enũjamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","A'ere 'ga U'agesage kuraparamũ 'ga naekatu'ogu'jawi. 'Ga 'Agesage kurapara 'gã ojereko tywerukaa 'ga upe. Nomoiri futari 'ga aipo 'gã tywera 'gã nui— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Mama'eukwaawa 'wyriara pãjẽ mũ te 'ga mama'eukwaawa pe'ai 'gã nui” 'eramũ 'gã Jarejuwarete 'ga 'Agesage kurawi. A'eramũ 'ga 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jejui 'ga y ẽẽ 'ut owaẽma 'gã nupe 'ga rewirera 'gã netee. A'ere 'gã nosei. A'eramũ 'gã ukupepe etee 'upa. A'eramũ 'ga y ẽẽ 'jau ukupepewara 'gã nupe: —Peenũi kĩã jee. Toroporogyta kĩã upe 'jau— 'jau ẽẽ 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kwaiwete 'gã 'upa Jejui 'ga pyri. A'eramũ 'ga amũ 'jau 'ga upe: —Eney ẽẽ 'ut owaẽma enerewirera 'gã netee. Ukupepe 'gã nuri 'upa. “Toroporogyta kĩã upe 'jau”, e'i eney ẽẽ oree— 'jau 'ga Jejui 'ga upe. Aipo ojeupe 'eramũ Jejui 'ga 'jau 'ga upe: —A'jea— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A'eramũ Jejui 'ga 'jau ojepyriwara 'gã nupe: —Maranuaramũ te pẽẽ jey 'jawe jee? Maranuaramũ te pẽẽ jerewirera 'gã 'jawe jee nanẽ nũ?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A'eramũ 'ga amã'jãu wenupara 'gã nee. A'eramũ 'ga 'jau 'gã nupe: —'Aga jey ẽẽ 'jawewara 'gã, jerewirera 'gã 'jawewara 'gã— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","—Jarejuwarete 'ga je'ega renuparamũ pẽẽ jepytuna 'jawe pejemogy, jerewirera 'jawe pejejemogyau nũ. Kũjãmeramũ jerenyra 'jawe pejemogy, jey 'jawe nanẽ nũ pejejemogyau nũ. Jarejuwarete 'ga remifutar imũ mama'e apoaramũ jepytuna 'jawe pejemogy jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Anure Jejui 'ga awau Garireja ypia reme'y'warimũ nũ. Kwaiwete 'gã ajatykau 'ga ree. A'eramũ 'ga awau u'aa wapyka yaruu pype. A'eramũ 'ga yaruu pype u'ar ire oporogytau ojee ajatyka ma'e 'gã nupe. 'Ga renupara 'gã 'upa 'yisiga pype. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mama'e mũ 'ga imome'wau 'gã nupe, 'gã mu'jau 'Uwarete 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kũima'e 'ga amũ awau juowuuran a'ỹja momopoa oko pe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A'eramũ a'ỹja mũ u'aa pe pe 'ga wi. A'ere 'ga imomopor ire wyra'i ruri i'wau etee 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Amumera u'aa ywy a'wyre'ema pype 'ga wi. Kwaiwete ita. A'eramũ 'yja otywe'emamũ jupe. 'Yi tywe'ria te. Jaruete futat opopoa numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","A'ere nooi apoa kwe pe. A'eramũ kwaraya imomỹijaga etee. Ita rakuwa ijukau etee. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Amumera a'ỹja u'aa juemy pype. A'eramũ jua imoteu etee 'ga wi. A'eramũ jawaiwa iapisau etee. A'eramũ u'ae'emamũ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amumera a'ỹi te aje u'at ywy katurama pype. A'eramũ opopoa. A'eramũ ywy esage pype u'at ma'efera te u'aramũ. Kwaiwete u'aramũ. Ajepeja 'ywa'aa trĩta i'aa. Ajepeja 'ywa'aa sesẽta i'aa. Ajepeja 'ywa'aa sẽg i'aa— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","—Ee pejejeapyoweramũ ki peapyaka katu jeje'eg are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ojeupe 'ga porogytapaw ire mytuna 'gã awau ojewya oje'wyr ipe nũ. A'ere 'gã amũ pytai oporonupa ee 'ga upe. A'eramũ opyta ma'e 'gã awau 'ga repejãna oporonupa 'ga remimome'u are 'ga remimu'e 'gã netee: —Ma'ja are te ore mu'e ape poromũ morogytau ra'e? Norereapyoi ete ore ee ki 'ei— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Tejuwarete 'ga je'eg imũ futat je ruri pẽ mu'jau 'ga ree. 'Awamũ Jeruwa 'ga pẽ mogyi wemiayuwamũ jeje'ega renupa katu katuaramũ, a'e je pẽ nupe— 'jau 'ga 'gã nupe. —A'eramũ je morogytau etee pẽ mu'jau ee. Nomome'uayayi tãmẽjẽ je pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kasi a'e pe tesirũmera 'gã we ikwaaw ekoete ne, a'e je pẽ nupe— 'jau Jejui 'ga 'gã nupe. —Jeje'eg are eapyowere'ema 'gã wanup futat jeje'ega numiamũ. A'ere 'gã naeapyoi futari ee. Wesak agawewi 'gã 'ã mama'ea jeremiapoa. A'etea 'gã naeapyoi ee. Ma'eramũ je 'ã morogyta etee imome'ui pẽ nupe pẽ mu'jawamũ. Imome'u katu re 'gã neapyo ekoeteramũ ajemogyau ee ne. Ee weapyo re amunipo 'ã 'gã poiri otywer awi. A'eramũ te amunipo 'ã Janeruwarete 'ga 'gã katu'ogi 'gã tywer awi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","—Ee pejejeapyoe'em ire maran amusipo 'ã pẽẽ pẽneapyo mama'e are pejejeupe je imome'uramũ?— 'jau Jejui 'ga 'gã nupe oporonupa ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A'eramũ 'ga 'gã mueapyou ee: —Sã'ã y'wa a'ỹja. Nan tee futat Janeruwarete 'ga je'ega. 'Ga je'ega mome'wara 'gã y'wa a'ỹi tymara 'gã 'jawe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A'ỹja mũ 'ã u'aa pe pe 'ga wi. A'ea 'ã wyra'ia 'ua i'wau etee. Nan tee futat Janeruwarete 'ga je'ega renupara 'gã amũ. 'Ga je'ega renuwi futari numiamũ. A'ere 'gã naeapyoi ee. A'eramũ mama'eukwaawa 'wyriara 'ua erowiarukare'ema 'gã nupe: “Perowiar awi”, 'jau 'ua 'gã nupe. A'eramũ futat 'gã momoirukaa je rerowiar awi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","—Sã'ã y'wa a'ỹja mũ 'ara ywy a'wyre'ema pype ipopora numiamũ. A'ere nitywi apoa. A'eramũ opapapa etee nũ. Nan tee futat nipo Janeruwarete 'ga je'ega renupara 'gã amũ. Enupawe 'gã erowiaa. A'ere 'gã naeapyoi ee. A'eramũ 'gã opoia kamẽsĩete erowiar awi. Erowiaramũ nipo 'gã amũ 'gã nerekou tyweaete ee. A'eramũ 'gã opoia 'ga je'ega renuw awi. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Sã'ã y'wa a'ỹja 'ara ju pype. A'eramũ 'ã opopoa futat numiamũ. A'eramũ 'ã jua imoteu etee. Nan tee futat nipo 'gã amũ Jarejuwarete 'ga je'ega renuwaiwi etee. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","A'eramũ nipo 'gã wemifutar are etee wea'aramũ ajemogyau nũ. Ojeka'aranũũrug are etee wea'aramũ ajemogyau. Ojemuorypaw are etee nipo 'gã wea'aramũ ajemogyau. A'eramũ 'gã wea'aru'jawe'emamũ nipo 'ga je'eg are. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","—Amumera 'gã te nipo ajee. Sã'ã y'wa a'ỹja ywy katurama pype u'at ma'ea. A'ea awau waranupa u'aramũ. Nan tee futat Ku'jywa 'ga je'ega renupara 'gã neapyoramũ ajemogyau ee. Wago'oramũ miamũ 'gã nopoira'uweri futari je rerowiar awi. Ojemogypyyka etee futat nipo 'gã ajemogyau je ree. Janeruwarete 'ga pãjẽ mũ etee futat mama'e esage apou ajemogyau. Sã'ã ywy katurama pype u'at ma'e 'ara. A'eramũ 'ã u'aramũ kwaiwete. Ajepeja 'ywa'aa trĩta i'aa. A'ere ajepeja 'ywa'aa sesẽta i'aa. Ajepeja 'ywa'aa sẽg i'aa. Nan tee futat jeje'ega renupara 'gã mama'e esage apoi Jarejuwarete 'ga remifutar imũ etee futat— 'jau Jejui 'ga 'gã nupe, 'gã mueapyou 'Uwarete 'ga je'ega renuw are. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A'ere Jejui 'ga 'jau 'gã nupe nũ: —Nomonyga'uweri ae arãparĩna mũ imỹina imima mama'e 'ag are. Imonyg ire ae imonoi imỹina ajuesawamũ te. A'eramũ ose ma'e 'gã esaka tenamũ. Nan tee futat ki pẽẽ. Ee eapyo ma'eramũ ki pẽẽ tekotee 'gã mu'jau Jarejuwarete 'ga porogyta are. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mama'e jemima pẽẽ ikwaape'ema. A'ere nipo anure te pekwaap. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ee pejejeapyoweramũ ki peapyaka katu jeje'eg are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A'eramũ 'ga 'jau 'gã nupe nũ: —Pejejuka ki je'e are. Pejejaupe pẽẽ mama'e apo 'jawerimũ etee futat nipo Janeruwarete 'ga mama'e apoi pẽ nupe. A'ere 'ga taetu aipo mama'e apoi pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mama'e rereko esageara 'gã a'jeteetewi mama'ea wereko. A'eramũ taetu 'ga mama'e pyygu'japa ojeupe. A'ere mama'e rereko esageare'ema 'gã nuerekou'jawi futari mama'ea. Erekopyrera miamũ futat 'ga erekou'jape'ema— 'jau Jejui 'ga 'gã nupe. —Nan tee pẽneapyo Jarejuwarete 'ga je'eg are. Oje'ega pẽẽ enuw ire 'ga pẽ mueapyou oje'eg are. Oje'ega pẽẽ enuwe'emamũ 'ga nepẽ mueapyou'jawi oje'eg are— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","29","A'ere 'ga mama'e mũ mome'wau 'gã nupe 'gã mu'jau nũ: —Sã'ã ko jara 'ga y'wa a'ỹi tyma oko pe. A'ere 'ga 'ã awau jui. Wea'aru'jawe'emamũ futat a'ỹja tymawer are. “Ko sipo 'wei”, 'jawe'em futat 'ga 'ã y'wa a'ỹja upe. Opopoa nã'ã ojetee futat re'ã, u'aramũ 'jau nã'ã re'ã 'jau 'ga. Weapyoe'emamũ agawewi itymarera 'ga ee. Ywy pype otym ire 'ã awau u'aramũ, otyarũmũ ko jara 'ga upe. A'eramũ 'ga 'ã ipa'wau. Nan tee futat Janeruwarete 'ga remiayuwa. Oje'ega rerowiaramũ Janeruwarete 'ga 'gã mogyau wemiayuwamũ. Jane 'ã 'ga je'ega te simome'u. A'ere 'ga te 'gã mueapyoi ee erowiarukaa 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A'ere Jejui 'ga 'jau 'gã nupe nũ: —Ma'ja 'jawe ajee Janeruwarete 'ga remiayuwa 'gã?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","—Sã'ã y'wa a'ỹi'ĩ'ĩa, mostarda 'jawa. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","A'ere 'ã otym ire 'ã opopoa awau o'ywuuramũ. A'eramũ 'ã wyra'ia aja'yrapyau akã are, waity mogyau ee— 'jau Jejui 'ga 'gã nupe nũ. Aipo upe Jejui 'ga wemiayuwa jemomytunawama te imome'ui 'gã nupe. 'Awamũ 'ga rerowiaara 'gã inãinãnĩ'ĩ etee. A'ere 'gã anure kwaiwete 'gã jemomytuni nipo ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Morogytau Jejui 'ga mytuna 'gã mu'jau 'Uwarete 'ga ree. A'eramũ 'gã weapyoramũ 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mytuna 'gã nupe 'ga morogytau etee imome'wau. A'ere 'ga wemimu'e 'gã mueapyoi oje'eg are, wemiayuwa 'gã etee erekou. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aipo 'ara rupi, ypytunimũ, Jejui 'ga 'jau wemimu'e 'gã nupe: —Pe'je soo jareyaapa 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A'eramũ 'ga remimu'e 'gã mytuna 'gã monou ojewi. —Pe'je pejewau pejeje'wyr ipe— 'jau 'gã 'gã nupe. Yaruu pype 'ga renamũ 'ga remimu'e 'gã awau u'aa yaruu pype Jejui 'ga pyri. A'eramũ 'gã awau 'ga rupi. A'ere amumera 'gã oi oyaruu pype 'gã newiri. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","'Gã yaapaw ipe ywyruua 'ua erujewi 'gã nupe. 'Y ryjuapia yara matyneema imotypywyka ja'wyja'wy 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A'ere Jejui 'ga seri etee futat 'upa yara ku'a pe. Wakaga rerupa akagytapawa 'jawewara 'arimũ. A'eramũ 'ga remimu'e 'gã 'ga renũina 'ga momaka: —Ku'jyp! Ere epaka kũi! Sapap jane kũi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A'erauwe Jejui 'ga fu'ami oje'ega ywyruu upe, 'y rajapetega upe nanẽ nũ: —Peojet ki 'y rajapetek ywyruu retee— 'jau 'ga jupe. A'erauwe ywyruua wojeramũ. 'Y rajapetega nanẽ wojeramũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A'ere 'ga 'jau wemimu'e 'gã nupe: —Ma'eramũ pejekyjau nanimenime 'ũ? Naje rerowiari tãmẽjẽ 'ã pejepe pejejemogyau— 'jau 'ga wemimu'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A'eramũ 'gã kyjea 'gã nerekou. —Kuu. Ma'e pãjẽ 'ga te jane sireko jarejepype nũ'ũ?— 'jau etee 'gã ajaupe. —Ywyruua te 'ã 'ga amuojet erujewi jarejewi a'i kũi. 'Y rajapetega nanẽ 'ga 'ã imuojea erujewi nũ. Ma'e pãjẽ 'ga te nũ'ũ? Naesagi pa je 'ga amũ je'ega ywytu upe jepi nũ, ywytu muojera erujewi jepi nũ— 'jau 'gã ajaupe oporesagamũ ete 'ga ree. —Janeruwarete 'ga te wapoukat 'ga upe nũ'ũ— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Garireja ypiauu raapaw ire 'gã awau ojekoka Gerasa ywy are. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","A'e pe Jejui 'ga uẽma yaruu awi. Yar awi 'ga ẽm ypyrauwe kũima'e 'ga amũ 'ua 'ga repejãna. Mama'eukwaawa rerekwara 'ga poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Tywy 'arimũ ete futat 'ga rekoi. A'eramũ 'ga 'ua tywy awi Jejui 'ga repejãna. Ipojy te 'ga akou. A'eramũ 'ga pyriwara 'gã okyjau 'ga wi 'ga rekoramũ. Apo fat agawewi futat 'gã 'ga, 'ga kupy faa itaju pyu agawewi. A'etea 'ga omonoonoog etee futat. A'eramũ 'gã 'ga pofaa, 'ga pyfaa 'jau itaju pyu. A'ere 'ga imopeni etee. A'ere 'ga nipoje'okawi futari 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ywytyra rupi 'ga awau akou awotywe'eme. Opytawaipa etee peu. A'ere 'ga awau tywy pe nũ. Mama'eukwaawa 'ga maema. Ita pyu 'ga ojekysau. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jejui 'ga resakawe 'ga ujãna u'aa wapyka wenupy'ãu 'ga rowase. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","A'eramũ mama'eukwaawa 'ga muafukaita: —Jejui. Ku'jywa 'ga ra'yra 'ã ene. Maran te ore rereko ape 'awamũ? Ore rereko tywer awi ape— 'jau mama'eukwaawa Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","“Ejepe'a 'ga wi”, e'i Jejui 'ga mama'eukwaawa upe ra'e. A'eramũ mama'eukwaawa aipo werekwara 'ga mu'eukaa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A'eramũ Jejui 'ga 'jau jupe: —Ma'ja te enerera?— 'jau Jejui 'ga mama'eukwaawa upe. A'erauwe 'jau 'ga upe: —Kwaiwete ore 'ga pirewaramũ. A'eramũ 'gã ore renũina “kwai” 'jau oree— 'jau mama'eukwaawa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A'ere mama'eukwaawa 'jau Jejui 'ga upe: —'Ga wi ore monou kasi muku ore monoukar ape ne— 'jau mama'eukwaawa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mama'eukwaawa rerekwara 'ga upe Jejui 'ga porogyta 'ga 'amamũ tajaurana ojemi'waa 'upa ywyty'rarimũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A'eramũ mama'eukwaawa 'jau 'ga upe: —Tajaurana ywyteripe ore mono ape ore mogyau— 'jau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A'eramũ Jejui 'ga 'jau jupe: —Pe'je ajee pejewau— 'jau 'ga jupe. Tajaurana pytuna tois miu. A'erauwe mama'eukwaawa ũ'jãu werekwarera 'ga wi awau ojejaga tajaurana pype. A'eramũ tajaurana mama'eukwaawa ojepype ijejagamũ erowawaka erajemogyau. A'eramũ erawau enujãna erojypa ywy'amuku rupi eropopoa erawau eropapa 'y pe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A'eramũ tajauran are omaenun ma'e 'gã awau imome'wau amunaw ipewara 'gã nupe, jũ mewara 'gã nupe. Mĩmera 'gã nupe 'gã 'ga rera mokwasi'wau. A'eramũ kwaiwete 'gã 'ua 'ga resaka. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jejui 'ga pyri 'uawe 'gã mama'eukwaawa rerekwarera 'ga resaka. 'Ga resakawe 'gã oporesagamũ etee 'ga ree ajemogyau. Jejui 'ga pyri 'ga reni wapyka. Mama'e tywera ojewi iẽm ire 'ga 'ũina wapyka ojeyrũwunepa. I'akwaap 'ga a'eramũ futat. A'eramũ amunaw awi 'ut ma'efera 'gã oporesagamũ etee 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A'erauwe 'ga katu'oga resakarera 'gã imome'wau 'gã nupe: —Jejui 'ga mama'eukwaawa ope'a 'ga wi ko. A'eramũ 'ga imonoukaa tajaurana pype ko. Ojepype mama'eukwaawa reseramũ tajaurana awau opopoa wypy'awygamũ 'y pe ko— 'jau 'gã imome'wau 'ut ma'efera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Weymawa manũ re 'gã 'jau Jejui 'ga upe: —Ere ejepe'au ore wi kũi. Ene nenea'wyri ra'e kũi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","A'erauwe 'ga awau u'aa yaruu pype nũ. A'e pype mama'eukwaawa rerekwarera 'ga 'jau Jejui 'ga upe: —Tene je oi ene rupi, ki Ku'jyp— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","A'ere Jejui 'ga 'i etee 'ga upe: —Naani. Eje'wyr ipe te ekwap ejemome'wau epytuna 'gã nupe. Janeruwarete 'ga ajemuaẽm ene ree. A'eramũ 'ga mama'e esage apou ene upe. A'eramũ ene ewau imome'wau epytuna 'gã nupe— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A'ere mama'eukwaawa rerekwarera 'ga awau amunawa moymoyka okatu'okawera mome'wau kwe pewara 'gã nupe. Tekapuru ywy pe 'ga awau Jejui 'ga remiapofera mome'wau. A'eramũ enuparera 'gã oporesagamũ 'ga ree, okatu'okawera 'ga imome'uramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","A'ere Jejui 'ga awau ypiauu raapa wemimu'e 'gã nupi nũ. 'Gã jekog ire mytuna 'gã 'ua ajatykau 'ga ree 'yisiga pype. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","A'eramũ Jairo 'ga 'ua oporogytau Jejui 'ga upe. Aipo 'ga judeu 'gã jatykaawa raarana 'ga. 'Ga 'ut wapyka wenupy'ãu Jejui 'ga rowase. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Jera'jyra ẽẽ amanũ ja'wyja'wy 'upa ki 'ei. A'eramũ je ene poreawua kũi. Teresak ẽẽ jui 'jau, 'jau je tejua enee kũi— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","A'erauwe Jejui 'ga awau 'ga rupi. Kwaiwete 'gã awau 'gã newiri. Ojopypypypyk te 'gã awau. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Poje kũjã ẽẽ mũ 'ua Jejui 'ga rakyfet katy 'ga repejãna. Ojero'wu ma'e ẽẽ. Tusi kwara ẽẽ imu'aa akou ojero'wau. Nuogi futari ẽẽ rya ẽẽ wi. Ymã te 'ã ẽẽ rekoi rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Morofuanugara upe ojesaukaa numiamũ. A'ere morofuanugara mepyetea ẽẽ ka'aranũũ mateepapa ekoete ẽẽ wi. A'ere ẽẽ nojekatu'ogi futari akou. A'ere ẽẽ jero'wu jerekoetei ẽẽ ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","A'eramũ ẽẽ Jejui 'ga rera renupawe 'jau ojeupe etee futat: “Kĩã raity pyygamũ tajekatu'ok 'jau kwy”, 'jau ẽẽ ojeupe etee futat. A'eramũ ẽẽ 'ua 'ga rewiri. 'Ga rupisikawe ẽẽ 'ga raity pyyka. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A'erauwe ẽẽ ry uoka ẽẽ wi. A'eramũ ẽẽ 'jau ojeupe etee futat: “A'jea futat kĩã pãjẽa ra'e”, 'jau ẽẽ ojeupe. “Jejaruete je 'awamũ nũ”, 'jau ẽẽ ojeupe etee futat akou. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","A'erauwe Jejui 'ga 'jau ojeupe etee futat: “'Ga amũ ijaruete jepãjẽ mũ”, 'jau 'ga ojeupe etee futat. A'eramũ 'ga ojerowaka 'jau mytuna 'gã nupe: —Awỹja te owyk jeraity are ra'e?— 'jau 'ga 'gã nupe. —Tee. Naje rũi— 'jau 'ga rewiri oo ma'e 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A'eramũ 'ga remimu'e 'gã 'jau 'ga upe: —Kwaiwete agawewi 'gã 'ã. A'etea 'ã ere “Awỹja te owyk jeraity are ra'e?” ere oree— 'jau 'gã Jejui 'ga upe. —Nereesagi nipo 'gã jopypypypyga?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","A'erauwe Jejui 'ga amã'jãu 'gã moyka ojee owyk ma'efera rekaa. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A'erauwe ijaruete ma'efera ẽẽ 'jau ojeupe: “Najemima'uweri je kĩã wi. Okwaap futat kĩã”, 'jau ẽẽ ojeupe. A'eramũ ẽẽ awau wapyka wenupy'ãu 'ga rowase. Oyyita ẽẽ ojemome'wau 'ga upe: —Je ako awyk eneraity are ko. Ymã te jerya nuogi je wi. A'ere eneraity are je wygauwe iogi je wi ko— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A'eramũ Jejui 'ga 'jau ẽẽ upe: —Je rerowiat wejue te ape. A'eramũ je ako ene katu'oka ko— 'jau 'ga ẽẽ upe. —A'eramũ ki ene epy'ata'waramũ ekou. Enejaruete ene ekou— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ẽẽ upe Jejui 'ga porogyta 'ga 'amamũ Jairo 'ga remiayuwa 'gã amũ 'ua 'ga rewiri: —Amanũ katu enera'jyra ẽẽ ki 'ei. Au'je 'ga reruri re— 'jau 'gã 'ua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","A'ere Jejui 'ga 'i etee 'ga upe: —Ene'arasig awi. Je rerowiat ki ape— 'jau ete Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A'ere Jejui 'ga 'jau wewiri oo ma'e 'gã nupe: —'Au etee ki pejup. Ore tee oroo orosou ẽẽ resaka— 'jau 'ga 'gã nupe. A'eramũ 'ga muapyra 'gã etee erawau ojeupi. Pedro 'ga, Tiago 'ga, 'ga rewirera Juã 'ga. Mĩmera 'gã etee 'ga erawau ojeupi. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairo 'ga 'wyr ipe owaẽmawe 'gã amanũ ma'efera ẽẽ ree ajatyka ma'e 'gã nesaka. Jairo 'ga ra'jyra ẽẽ rapirũmũ ẽẽ rerekou. Wafukaita 'gã ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'eramũ te pejoo'o ẽẽ ree? Namanũi futari ẽẽ. Oset tee ẽẽ 'upa— 'jau 'ga ajatyka ma'efera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aipo ojeupe 'ga 'eramũ 'gã 'ga rerekoemãu etee: —Ene'me awi nũ'ũ. Amanũ futat akiko— 'jau 'gã 'ga upe. “Amoferap je ẽẽ”, 'jau 'ga ojeupe. A'eramũ 'ga 'jau 'gã nupe “Oset tee ẽẽ 'upa”, 'jau ete 'ga 'gã nupe. A'ere Jejui 'ga 'jau 'gã nupe: —Pe'je pejewau peje'jãu ukupepe— 'jau 'ga 'gã nupe. A'eramũ 'ga muapyra 'gã nerawau, kũjãmuku'i ẽẽ jara 'gã neewe. A'eramũ 'gã awau osou imy'ja'wi pype. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A'eramũ 'ga amanũ ma'efera ẽẽ popyyka oje'ega ẽẽ upe: —Ere ejua ewya, ky'ri— 'jau 'ga ẽẽ upe. (Oje'eg imũ 'ga 'i: Tarita kumi. Tarita kumi 'ea ere ejua efu'ama jui 'ea poromũ.) ");
INSERT INTO kyzNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A'erauwe kũjãmuku'i ẽẽ afu'ama okama awi, afu'ama awau watau. Tusi kwara ẽẽ amu'at. A'eramũ ẽẽ watau 'gã neape. A'eramũ 'gã oporesagamũ etee ẽẽ ree. A'eramũ futat ẽẽ ruwa 'ga 'jau ojeupe: “Amanũ ako jera'jyra ako re'ã. A'ere pa 'ga 'ã jera'jyra moferawi jee nũ”, 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A'ere Jejui 'ga 'jau 'gã nupe: —Je mome'u kasi pejepe kwe pe 'gã nupe ne, 'au je iapoawera ne— 'jau 'ga 'gã nupe. A'ere 'ga 'jau ẽẽ jara 'gã nupe: —Pe'je ẽẽ mojemi'waa— 'jau 'ga ẽẽ jara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Anure Jejui 'ga awau ojewya Nasare pe nũ, waranupawer ipe nũ. Wemimu'e 'gã 'ga erawau ojeupi. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Morowykye'ema rupi 'ga awau osou judeu 'gã jatykaaw ipe. A'eramũ 'ga 'gã mu'jau 'Uwarete 'ga porogyta are. A'eramũ enupara 'gã amũ oporesagamũ 'ga ree. —Ma'ape te 'ga jemu'ei mama'e are nũ'ũ? Awỹja te 'ga amu'akwaap mama'e are nũ'ũ?— 'jau 'gã ajaupe. —Ma'ja pãjẽ mũ ajee 'ga aeremiapoe'ema apoi?— 'jau 'gã ajaupe. —Maran ajee 'ga mama'e apoi mĩnamũ nũ, aeremiapoe'ema mama'e apou nũ?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—Ma'eramũ sipo 'ga jane mu'ei mama'e are? NaMoisesi 'ga remikwasiarer are moromu'jara rũi agawewi 'ga 'ã. A'etea 'ga jane mu'e are ifuewet— 'jau 'gã ajaupe. —'Yjepana pinara agawewi 'ga 'ã. A'etea 'ga 'ã jane mu'e are ifuewet. Mari ẽẽ ra'yra 'ga te 'ã. 'Ga rewirera 'gã ako 'au jane pyri. Tiago 'ga, Jose 'ga, Judas 'ga, Simão 'ga. Mĩmera 'gã 'ga rewirera. 'Ga renyra 'gã nanẽ 'ã ajemogyau 'au jane pype nũ. Ma'eramũ sipo 'ga jane mu'e are afueweramũ? Nienuwa'uweri jane 'ga porogytaa— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","A'eramũ Jejui 'ga 'jau 'gã nupe: —Sã'ã Janeruwarete 'ga je'ega mome'wara 'gã oa kwe pe 'ga je'ega mome'ua. A'eramũ 'ã kwe pewara 'gã jẽmĩ 'gã je'ega rerowiaa. A'ere 'ã 'gã 'wyr ipewara 'gã jẽmĩ nuerowiari 'ga. 'Ga pytuna 'gã miamũ 'ã 'ga rerowiare'ema ajemogyau— 'jau Jejui 'ga oje'wyr ipewara 'gã nupe. —Nan tee futat ajee 'ã kwe pewara 'gã jẽmĩ je rerowiari. A'ere 'ã je'wyr ipewaramũ jẽmĩ naje rerowiari pejepe pejejemogyau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nuerowiari wejue 'gã 'ga. A'eramũ 'ga aeremiapoe'ema mama'e apoarũme'em 'gã pype. Ojero'wu ma'e 'gã amũ etee 'ga imajarueteu, opo monou 'gã 'arimũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","“Naje rerowiari te 'gã 'ã. A'eramũ je 'gã poararũme'em”, 'jau 'ga ojeupe, oporesagamũ 'gã nee. Aipo awi Jejui 'ga awau Nasare pyri 'ut ma'e amunaw ipe, 'gã mu'jau 'Uwarete 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Anure 'ga wemimu'e 'gã majatykau, tusi 'gã majatykau. A'eramũ 'ga opãjẽ monou 'gã nupe mama'eukwaawa pe'aawamũ erekwara 'gã nui. A'eramũ 'ga 'gã mokwasi'wau mukũi juejue 'gã monou kwe pe. —Pe'je pejewau je mome'wau kwe pewara 'gã nupe. Jerer imũ ki pẽẽ mama'eukwaawa pepe'a erekwara 'gã nui— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Pejemama'ea te kasi ajee peroo ne. Ywyraa etee pẽẽ erawau pejepo pe. Pejejemi'ua miamũ pẽẽ erawawe'em. Mama'e ryrũ, ka'aranũũ. Mĩmera nanẽ pẽẽ erawawe'em nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pejepyapaawunepa ete. A'ere pejejyrũa miamũ pẽẽ erawawe'em. Pejepir arewara etee futat pẽẽ erawau. Nan tee futar iki pekwap— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—'Gã 'wyrarete upe pejewaẽma pẽẽ majepeja 'oga pype etee futat pejejupa. Peo kasi kwe pe pejekou ne. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pejeporogyta renuwe'emamũ kamẽsĩete pejewau 'gã 'wyr awi. 'Gã nui pejewau ki pẽẽ pejepytyry'wory'woka. “Nepeenuwi ete oreporogyta. A'eramũ nipo Janeruwarete 'ga amara'neramũ pẽ nee”, 'jau ki pẽẽ 'gã nupe, pejepytyry'woka 'gã neape— 'jau Jejui 'ga wemimono 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A'eramũ Jejui 'ga remimu'e 'gã awau peuwara 'gã mu'jau Jarejuwarete 'ga ree: —Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoiri pẽ nui. “Je katu'og ape”, pẽẽ 'eramũ 'ga pẽ katu'ogi futari, pẽ mogyau wemiayuwamũ— 'jau 'gã awau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mama'eukwaawa 'gã ipe'au erekwara 'gã nui. Miarakawenana 'gã imonou ojero'wu ma'e 'gã akag are. A'eramũ Janeruwarete 'ga 'gã katu'oka 'gã jero'wu awi. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jejui 'ga rera okwasi'wasi'wau kwe pe. A'eramũ Erote 'ga nanẽ 'ga rera renupa nũ. A'eramũ 'ga 'jau 'gã nupe: —Awỹja te poromũ? Aeremiapoe'ema te a'e 'ga wapo a'i kũi— 'jau 'ga 'gã nupe. A'eramũ 'gã amũ 'jau 'ga upe: —Juã Batista 'ga nipo 'ut oferapa rai'i nũ. A'eramũ nipo 'ga a'eramũ janeremiapoe'ema resaukaa janee— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","A'ere amumera 'gã 'i: —Eliasi 'ga nipo 'ut ojewya rai'i— 'jau 'gã 'ga upe. Amumera 'gã 'jau: —Janeruwarete 'ga je'ega mome'wara 'ga, ymãwarera 'jawewara 'ga futat— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aipo ajaupe 'gã 'e renupawe, Erote 'ga 'jau: —Juã Batista futat 'ut oferapa rai'i nũ. Ajuwonogukat agawewi ako je 'ga ikue. A'etea sipo 'ga oferawu'jap nũ— 'jau Erote 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ymã Erote 'ga wewirera 'ga remireko ẽẽ pojekai 'ga wi rakue. Erotiasi ẽẽ pojekau 'ga wi rakue, Filipe 'ga wi rakue. A'eramũ 'ga ẽẽ rerekou katu rakue. A'eramũ Juã 'ga 'jau 'ga upe: —Nia'wyri nanuara. Ejewirera remireko 'ã erepojeka 'ga wi. Ymã 'ã Janeruwarete 'ga oje'ega kwasiarukari Moisesi 'ga upe rakue: “Peko awi pejejuemireko are”, 'jau 'ga ikwasiarukaa 'ga upe rakue. A'ere 'ã ereapo “Peapo awi” 'jawera rai'i. A'eramũ ene etywereteramũ ekou Jarejuwarete 'ga upe— 'jau Juã 'ga Erote 'ga upe rakue. A'eramũ Erote 'ga amara'neramũ Juã 'ga ree, 'ga pofaa, 'ga munewukaa moromunepawa pype. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erotiasi ẽẽ Juã 'ga raykau 'ga 'eawer are. A'eramũ ẽẽ afuewereteramũ 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","A'ere Erote 'ga kyjei 'ga juka awi. “Esage ma'e 'ga, Ku'jywa 'ga remiayuwa 'ga”, 'jau Erote 'ga Juã 'ga upe. A'eramũ 'ga okyjau 'ga juka awi. A'eramũ 'ga 'ga jukaukare'ema Erotiasi ẽẽ upe. 'Ga je'egamũ Erote 'ga wapyakau Juã 'ga je'eg are. 'Ga je'ega renupawe 'ga 'jau ojeupe: “Maran je 'ga rerekou 'ũ”, 'jau 'ga ojeupe. A'ere 'ga nokwaawi futari. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A'ere Erotiasi ẽẽ Juã 'ga juka rapesagi etee futat akou. U'aawera 'ara rupi Erote 'ga maraka apou. A'eramũ 'ga kwaiwete 'gã mo'wy'wya omaraka are. Opoirũ, jefaruu 'wyriat, Garireja ywy pewara 'gã 'wyria'ri. Mĩmera 'gã 'ga imo'wy'wya oje'wyr ipe. A'eramũ 'gã wemimo'wyrera 'gã mojemi'waa. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","'Gã jemi'waaw ipe Erotiasi ẽẽ ra'yra ẽẽ awau osou ojerokyau maraka are ajatyka ma'e 'gã nowase. A'eramũ Erote 'ga aku'iramũ ẽẽ jeroky are wemimo'wy'wyrera 'gã netee. A'eramũ Erote 'ga 'jau ẽẽ upe: —Ma'ja te erefutat? Tamono eneremifutara enee 'jau— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A'eramũ 'ga 'jau nũ: —“Ma'ja te erefutat?” a'e ako je enee ko. Eneremifutara etee futat tamono enee 'jau, a'e ako je enee ko. Na'e ekoetei je enee. Jarejuwarete 'ga remianuwamũ je 'i. Amono futat je enee— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A'erauwe ẽẽ awau imome'wau oy ẽẽ upe. A'eramũ ẽẽ 'jau ẽẽ upe: —Ma'ja te je aenũi kĩã upe?— 'jau ẽẽ oy ẽẽ upe. —“Juã Batista kĩã akagera erurukat imonogukaa wã nupe jee”, ere ki kĩã upe— 'jau ẽẽ wa'yra ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A'erauwe ẽẽ ra'yra ẽẽ awau ojewya 'jau 'ga upe: —Juã Batista kĩã akagera erurukat paratu pype imonogukaa wã nupe jee kĩ'ĩ. 'Awauwe je ifutari— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A'erauwe Erote 'ga u'arasigamũ aipo ẽẽ 'erauwe. Niporojukaweri 'ga Juã 'ga ree. A'eramũ 'ga a'eramũ u'arasigamũ. “Ma'eramũ je 'jau ẽẽ upe ra'e 'ũ: Eneremifutara tamono enee 'jau, 'jau ẽẽ upe ra'e 'ũ”, 'jau 'ga ojeupe, u'arasigamũ. A'ere 'ga wemimo'wy'wyrera 'gã nemianuwamũ aipo 'ga 'i ẽẽ upe. A'eramũ 'ga ojenosõu. “Kasi 'gã a'e pe je iapoe'emamũ naje rerowiari ne kwy, 'gã nekoi je'me are ne kwy”, 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A'eramũ 'ga a'eramũ jefaruu 'gã amũ monou Juã 'ga juwonogukaa. —Moromunepawa pype Juã 'ga 'amamũ. Pe'je pejewau 'ga ajuwonoka. A'eramũ pẽẽ 'ga akagera rerua paratu pype ẽẽ upe— 'jau 'ga 'gã nupe. A'erauwe 'gã awau 'ga ajuwonoka. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A'eramũ 'gã paratu pype 'ga akagera rerua ẽẽ upe. A'eramũ ẽẽ erua oy ẽẽ upe rakue. —Kweramũ a'ni— 'jau ẽẽ oy upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","“Erote 'ga 'ga jukaukat 'ga upe” 'e renupawe Juã 'ga remiayuwa 'gã awau 'ga reumera upe erawau imonou inuga ita kwara pype rakue. A'eramũ Erote 'ga wea'aramũ Juã 'ga ree, Jejui 'ga rera renupawe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ko'iko'i ete Jejui 'ga remimonofera 'gã 'ua ojewya nũ. A'eramũ 'gã wemiapofera mome'wau Jejui 'ga upe. Oporogyta nanẽ 'gã imome'wau 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kwaiwete 'gã ajatykau Jejui 'ga ree. A'eramũ Jejui 'ga ojemi'wararũme'em wemimu'e 'gã netee. A'eramũ Jejui 'ga 'jau wemimonofera 'gã nupe: —Pe'je soo awotywe'eme jarepytu'wau ra'ne 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A'eramũ 'gã tee awau u'aa yaruu pype. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A'ere kwaiwete 'gã 'gã oa resagi. —Oo Jejui 'ga— 'jau 'gã ajaupe. A'eramũ amunaw ipewara 'gã ojeko'woka 'ga piara rupi awau ujãna ypia ywyri owaẽma 'gã nenune. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ojekog ire Jejui 'ga uẽma yaruu awi. Wenune 'ut ma'efera 'gã nesakawe, Jejui 'ga ajemuaẽma 'gã nee. “Karupa'mĩ jare'ema 'jawe pa 'gã jemogyi jee nũ”, 'jau 'ga ojeupe. Ni'wyriari 'gã. A'eramũ 'gã omogytawe'emamũ. A'eramũ 'ga a'eramũ ajemuaẽma 'gã nee. A'eramũ 'ga 'gã mu'jau 'Uwarete 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kaaruwamũ Jejui 'ga remimonofera 'gã 'jau 'ga upe: —Kaarup ki 'ei. Nitywi futari mama'ea 'au 'gã nemi'uramamũ— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","—Emono 'gã jarejewi. Too 'gã amunawa mũ pype wemi'urama mua ojeupe 'jau— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A'ere Jejui 'ga 'i 'gã nupe: —Pẽẽ te mama'ea pemono 'gã nupe— 'jau 'ga 'gã nupe. A'eramũ 'gã 'jau: —Kuu. Mytuna 'gã nũ'ũ. Tusẽtu ka'aranũũ oo kanape'i muawamũ 'gã nupe kũi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Marãmaran te kanape'i pyu pẽtyp? Pe'je pejewau esaka— 'jau 'ga 'gã nupe. A'erauwe 'gã awau esaka. A'eramũ 'gã 'jau 'ga upe: —Sĩku etee kanape'ia. Mukũi'ĩ etee ipira'ia 'jau ra'e— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A'eramũ 'ga 'jau ojee ajatyka ma'e 'gã nupe: —Pe'je pejepojo'oka'i pejejaui pejeapyka juo'wi 'arimũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","A'erauwe 'gã opojo'ojo'o'giramũ wapyka juo'wi 'arimũ. Peu sẽg 'gã wapyka. Peu sĩkwẽta 'gã wapyka. Peu sẽg 'gã wapyka nũ. Nan tee futat 'gã wapyka juo'wi 'arimũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A'eramũ Jejui 'ga kanape'i pyyka opo pe ipira'i reewe. A'ere 'ga eramã'jãu ywau opo pe. A'eramũ 'ga 'jau 'Uwarete 'ga upe: —Au'jete mama'ea eremut oree. Ene te 'ã eneresage oree— 'jau 'ga 'Uwarete 'ga upe. A'erauwe 'ga kanape'i mowowoka imonou wemimu'e 'gã nupe. Omowowogamũ ojeme'yita 'gã nupe. Ipira'ia nanẽ ojeme'yita 'gã nupe. A'eramũ 'gã imonou wapyk ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","A'eramũ wapyk ma'e 'gã juejue ojemi'waa wewegamũ jui. —Janeruwarete 'ga kumia ome'yi janee— 'jau 'ga 'gã nupe. —A'eramũ 'ã jane jarejewegamũ jarejupa. Jarejuwarete 'ga jarejeupe ime'yje'em ire amunipo 'ã jane ty'ara reruwi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A'eramũ Jejui 'ga remimu'e 'gã emyrera mono'oga ijaga yrũ pype. Tusi yrupemũũa 'gã imatyneema emyrera pyu. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sĩku miu agawewi kũima'e 'gã pytuna. A'etea 'gã na'upawi kumia. Wewegamũ 'gã jui. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Emyrera 'gã ijag ire Jejui 'ga 'jau wemimu'e 'gã nupe: —Pe'je pejewau peje'aa yaruu pype. Pesaita pe pejewau pejeyaapa je renune. Je apyta ra'ne. Tamono 'gã 'gã 'wyr ipe 'jau nũ— 'jau 'ga 'gã nupe. A'eramũ 'gã awau 'ga wi 'ga rejaa ojetee'i. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ojewi 'gã o re Jejui 'ga awau ojeupia ywytyra rupi. 'Uwarete 'ga upe 'ga awau oporogytau. Ojetee'i futat 'ga awau akou. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Ypytunimũ Jejui 'ga wemimu'e 'gã nesaka. Ypiauu pyter ipe 'gã 'upa. A'ere ywytua napywurukari 'gã nupe. A'eramũ Jejui 'ga ku'em ja'wyja'wyramũ awau 'gã nepejãna. 'Y rajape 'arimũ 'ga awau watau. “Tafen 'gã 'jau kwy”, 'jau 'ga ojeupe. Ojepyu 'ga kwap ja'wyja'wyramũ 'gã 'ga resaka. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","—Ma'ja katu 'ut kweramũ janee?— 'jau 'gã ajaupe. —Ajaga nipo kwe 'ut owaẽma janee kũi— 'jau 'gã amũ wafukaita ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","A'eramũ 'gã okyjau ajemogyau. 'Gã kyjea 'gã pifuaka'roka. A'erauwe Jejui 'ga 'jau 'gã nupe: —Pekyje awi je wi. Je tee ojot pẽ newiri— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A'erauwe 'ga awau yaruu pype u'aa 'gã pyri. A'erauwe ywytua wojeramũ 'gã nupe. A'ere 'ga remimu'e 'gã yyi ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Naeapyoi 'gã kanape'i jeme'yitawer are. Naeapyoi wejue 'gã Jejui 'ga ree. A'eramũ 'gã okyjau 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","A'eramũ Jejui 'ga awau oyaapa wemimu'e 'gã netee. Awau 'gã ojekoka Genesare ywy are. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yaruu awi 'ga ẽmauwe peuwara 'gã Jejui 'ga kwaapa. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A'eramũ 'gã awau ujãna ojero'wu ma'e 'gã nerua amunaw awi. Amunawa moymoyka ojero'wu ma'e 'gã nerua 'gã nupawa pype Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jejui 'ga waw ipe 'gã ojero'wu ma'e 'gã nerua 'gã nuga 'ga kwapaw ipe. Amuna'wi'i pewara 'gã, amunawarete pewara 'gã, jũ mewara 'gã. Mĩmer awi 'gã ojero'wu ma'e 'gã nerua 'gã nuga 'ga rape pe. —Tene 'gã eneraity pypireme'ywa pyygi ene wi— 'jau 'gã 'ga upe. A'eramũ 'ga raity pypireme'ywa pyygarera 'gã ajaruetepawamũ najuejue etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Anure fariseu 'gã amũ Moisesi 'ga remikwasiarer are moromu'jara 'gã netee ajatykau Jejui 'ga ree. Jerusareg awi 'ut ma'efera 'gã poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jejui 'ga remimu'e 'gã jemi'wara resaka ajemogyau. A'eramũ 'gã 'jau ajaupe: —Kuu. Nojepoei 'gã ojemi'war enune jareypy je'egawer imũ— 'jau 'gã ajaupe. —Nuapoi 'gã jarejemiapoa ra'e— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Judeu 'gã mama'ea wapo oypy je'egawer imũ etee futat. Fariseu 'gã taetu iapou. Ojemi'war enune 'gã ojepoeipoeita. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wemimurera kumia nanẽ 'gã ipireipireita nũ. Oypy 'gã je'egawer imũ etee futat kumi'wawa nanẽ 'gã ipireita nũ. Kaneeku, 'y ryrũ, japepo. Mĩmera 'gã opirei. Oypy 'gã je'egawer imũ etee futat 'gã iapou. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A'eramũ fariseu 'gã Moisesi 'ga remikwasiarer are moromu'jara 'gã netee oporonupa ee Jejui 'ga upe: —Ma'eramũ ajee eneremiayuwa 'gã nuapoi mama'ea jareypy 'gã je'eg ymaner imũ 'ũ? Nojepoei nanẽ 'gã 'ã jareypy je'egawer imũ ojemi'war enunewe— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽẽ 'ã “mama'e esagea ore aruapo”, pe'je numiamũ. A'ere 'ã pẽ'me ate pejemogyramũ— 'jau Jejui 'ga 'gã nupe. —Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari Isai 'ga upe rakue: “Aramuoryw ore Orojuwarete 'ga, 'jau futatee 'gã jee”, 'jau Janeruwarete 'ga. “A'ere 'ã 'gã 'meramũ te. Nomỹi 'gã weaa je ree. Naje rerowiari tãmẽjẽ 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","U'eawer are etee 'gã jamu'ei. A'ere 'gã 'jau ajaupe: Jarejuwarete 'ga je'eg are je pẽ mu'ei, 'jau futatee 'gã ajaupe”, 'jau Janeruwarete 'ga ikwasiarukaa Isai 'ga upe rakue— 'jau Jejui 'ga 'gã nupe, oje'ega moywyrafena. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","—Nepeenuwi agawewi 'ã Jarejuwarete 'ga je'ega pejejemogyau. Na'ga je'eg imũ rũi nanẽ pẽẽ mama'e apou nũ. Tesirũmera 'gã je'eg imũ etee 'ã pẽẽ mama'e apou— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","—Pejepoia 'ã Jarejuwarete 'ga je'ega renuw awi. A'eramũ 'ã pẽẽ pejejemifutar imũ etee mama'e apou. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ymã Janeruwarete 'ga ka'arana kwasiarukari Moisesi 'ga upe rakue: “Peanuw etee ki pejejuwa 'ga je'ega. Pejey ẽẽ je'ega nanẽ ianupa etee nũ”, 'jau 'ga 'ã ikwasiarukaa 'ga upe rakue. “Ujara 'gã kurapara 'gã ki peapisi”, 'jau 'ga ikwasiarukaa rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","A'ere 'ã pemu'e 'gã 'gã jara 'gã nee 'gã je'ega renuw etee'em are. “Pejejara 'gã nupe mama'e are pejeporomonowere'emamũ ki pe'je 'gã nupe: ‘Pẽ nupewara je amono Jarejuwarete 'ga upe ai'i. A'eramũ je mama'e mũ monowe'em pẽ nupe’, 'jau futatee ki pẽẽ pejejara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A'eramũ ki pẽẽ imonowe'em pejejara 'gã nupe”, 'jau 'ã pẽẽ 'gã mu'jau tywet pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","—Aipo 'jaramũ pẽẽ Jarejuwarete 'ga je'ega renupe'ema pejejemogyau. Tesirũmera 'gã je'egawer imũ te 'ã pẽẽ mama'e apou. Namĩmera etee rũi futat pẽẽ iapou. Amumeramũ taetu ajee 'ã pẽẽ mama'e tywera peapo— 'jau Jejui 'ga fariseu 'ga nupe, Moisesi 'ga remikwasiarer are moromu'jara 'gã neewe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A'ere Jejui 'ga 'jau mytuna 'gã nupe: —Pe'je pejejua pejeapyakau jeje'eg are— 'jau 'ga 'gã nupe. —A'eramũ pẽẽ pejejeapyoramũ ee pejejemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Napẽ pype oo ma'efera rũi pẽ motywet Janeruwarete 'ga upe pẽ mogyau. Pẽ nui uẽm ma'ea te pẽ motywet Janeruwarete 'ga upe. Pẽje'egaiwa te pẽ motywet Janeruwarete 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A'ere Jejui 'ga mytuna 'gã nejaa awau osou 'og ipe wemimu'e 'gã netee. 'Og ipe ose re 'ga remimu'e 'gã oporonupa 'ga upe: —A'eramũ ene ma'ja upe poromũ 'jau ra'e 'ũ? Norereapyoi ore ene 'e are ki 'ei— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽẽ nanẽ nipo nepẽneapyoi we ee ra'e ki sa? Ekoay pẽẽ na'e ki 'ei. Pẽẽ nanẽ meewei etee pẽneapyo ee ra'e ki 'ei? Nepẽneapyoi ymani te 'ã pẽẽ je'eawer are a'i kũi. Pejejemi'waa nipo pẽẽ. A'eramũ nipo pẽẽ pejejemi'u monou pejejuru pe. A'ere nipo pẽẽ imokona. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pẽnemi'ua osou pẽnawyrũ pype etee futat. Nokwasi'oi pẽywytera pype. Pẽnawyrũ pype etee futat mama'e oi. A'eramũ okwapa etee pẽ nui. A'eramũ mama'ea pẽ motywerukare'ema Janeruwarete 'ga upe— 'jau Jejui 'ga 'gã nupe. Aiporamũ futat Jejui 'ga 'i 'gã nupe: “Nitywi futari pẽnemi'ue'ema mũ mama'ea” 'e upe futat 'ga 'i poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A'eramũ 'ga 'jau 'gã nupe nũ: —Pẽywyter awi 'ut ma'efera tee pẽ motywet Janeruwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mama'e tywer are etee pẽẽ pejejea'aramũ. A'eramũ pẽẽ mama'e apou pejejea'ar imũ etee futat. 'Ga amũ wea'aramũ mama'e are amunarũ are. A'eramũ 'ga amunarũmũ ee. 'Ga amũ wea'aramũ oporojuka are. A'eramũ 'ga oporojukau. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","'Ga amũ wea'aramũ wemirekoe'em are ako are. A'eramũ 'ga akou kũjã ẽẽ ree. 'Ga amũ wea'aramũ okaraemã momytun are etee. A'eramũ 'gã okaraemã momytuna ekoete. 'Ga amũ wea'aramũ mama'e tesirũ apo are te. A'eramũ nipo 'ga otyweramũ akou Jarejuwarete 'ga upe. Wemifutar imũ etee o'meramũ. Wea'ar imũ etee ajuago'wau ajemogyau. 'Gã amũ ajuerekoayau. 'Gã amũ ojerowiaraipa etee ojee. 'Gã amũ ojemuarũme'em. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mĩmera 'ã pẽẽ iapou pejejemifutar imũ etee futat. A'eramũ pẽẽ mĩmera apoaramũ te pejejemotywea Jarejuwarete 'ga upe. Napẽnemi'ua rũi pẽ motywet 'ga upe. Pejepoeje'ema miamũ nepẽ motyweri 'ga upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau 'gã motyweawa mama'e are etee. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A'ere Jejui 'ga awau pe awi. Tiro 'jawa pyri 'ga awau. Awau osou peuwara 'gã amũ 'wyr ipe. —Je mome'u kasi pejepe ne. “'Au 'ga ruri akou”, pe'je kasi ne— 'jau 'ga 'gã nupe. A'ere 'ga rera nimimawi futari. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A'eramũ kũjã ẽẽ mũ 'ga rera renupa. Mama'eukwaawa 'up ẽẽ ra'yra ẽẽ pir are. A'eramũ ẽẽ 'ua wapyka wenupy'ãu Jejui 'ga rowase, 'ga rera renupawe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Najudeu arũi agawewi ẽẽ. Sirufenisi pewara ẽẽ te. Poromũ 'ut oporogytau Jejui 'ga upe: —Mama'eukwaawa epe'a jera'yra kyna wi, a'e je tejua enee— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","A'ere 'ga 'i etee ẽẽ upe: —Sã'ã ae kunumĩa mama'e 'ue'emamũ ae kunumĩ remi'urama monoe'ema weymawa upe. Nan tee futat je. Judeu 'gã poaawamũ je ruri 'au ywy pe ikue— 'jau Jejui 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A'eramũ ẽẽ 'jau 'ga upe: —A'jea futat ere. A'ere ywyu mama'e 'ar ire wã neymawa i'ui futari— 'jau ete ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","A'eramũ Jejui 'ga 'jau ẽẽ upe: —Je rerowiat ape ekou ra'e a'i ĩ. Ere ewau ejewya eje'wyr ipe nũ. Mama'eukwaawa ojepe'a 'awamũ enera'yra ẽẽ wi— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A'eramũ kũjã ẽẽ awau ojewya oje'wyr ipe nũ. Ẽẽ ra'yra ẽẽ 'upa anuruka okama pype. Jaruete ẽẽ 'upa. Ẽẽ pirewara ojepe'au awau ẽẽ wi ra'e. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jejui 'ga awau pe awi. Sidoma pyu 'ga okwapa. A'ere 'ga awau Tekapuru ywy raapa awau owaẽma Garireja ypiauu upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A'e pe kũima'e 'gã amũ iapyae'ema 'ga rerua Jejui 'ga upe. Nuenuwi 'ga mama'ea. Nije'ẽkarakatui nanẽ 'ga nũ. A'eramũ 'gã 'jau Jejui 'ga upe: —Epo emono 'ga 'arimũ. Tajekatu'ok 'ga 'jau— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A'eramũ Jejui 'ga 'ga pe'au mytun awi. A'erauwe 'ga ofã monou 'ga apya rupi. 'Ga apya rupi ofã mono re 'ga onymuna opo are. A'ere 'ga weny monou 'ga kũ are. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","'Ga kũ are weny mono re Jejui 'ga wowowyramũ ywau ojepytuekyjayau. A'e pe 'ga 'jau: —Ejeawopytymo'wok 'ga wi— 'jau 'ga. (Oje'eg imũ 'ga 'i Efata. Efata 'ea ejeawopytymo'wok 'ga wi 'ea futat poromũ.) ");
INSERT INTO kyzNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A'erauwe iapyae'ema 'ga wapyakwafugamũ. 'Ga kũa nanẽ ojekatu'oka nũ. A'eramũ 'ga oje'eg esageayramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A'eramũ Jejui 'ga 'jau esakarera 'gã nupe: —Pemome'u kasi ne— 'jau 'ga 'gã nupe numiamũ. A'ere 'ga rera nikokawi futari. A'ere 'gã 'ga rera muãi kwe pe. ");
INSERT INTO kyzNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","'Ga rera renupara 'gã wea'aramũ 'ga ree ajemogyau. A'eramũ 'gã 'jau ajaupe: —A'jeteetewi 'ga mama'e apoi ki sa! Iapyae'ema 'gã miamũ 'ga imuapyau. Ije'ege'ema 'gã nanẽ 'ga imoje'egukaa— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Anure 'gã awau ajatykau Jejui 'ga ree nũ. Kwaiwete 'gã awau ajatykau 'ga ree. Temi'u teepawamũ Jejui 'ga 'jau wemimu'e 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ajemuaẽm je tekou 'gã nee. Muapyt 'ã 'gã kaaruwamũ jane pyri. A'eramũ 'awamũ 'gã nemi'urama ateepawamũ 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","A'eramũ je teporomonowere'emamũ 'gã nee 'gã nemi'urame'eme. Kasi a'e pe ty'ara 'gã pifuaka'rogi woga piara rupi 'gã oramũ ne, a'e je. A'eramũ je teporomonowere'emamũ 'gã nee tejewi, 'gã nupe mama'e monowe'emamũ. Kasi 'gã oje'wyr ipe awau 'gã manũaiwi ty'ara upe ne. Amumera 'gã taetu nã'ã muku awi 'ut re'ã, a'e je— 'jau Jejui 'ga wemimu'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A'eramũ 'ga remimu'e 'gã 'jau 'ga upe: —Amunawe'em ipe jane rekoi nũ'ũ. Nitywi mama'ea 'au. Mõ awi sipo ore mama'e muri 'gã mojemi'waawamũ?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Marãmaran pẽkanape'i pytuna?— 'jau 'ga oporonupa ee 'gã nupe. A'eramũ 'gã 'jau 'ga upe: —Sete ete ipytuna— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A'eramũ Jejui 'ga 'jau mytuna 'gã nupe: —Pe'je pejeapyka ywyu— 'jau 'ga 'gã nupe. A'erauwe 'gã wapyka. A'ere 'ga kanape'i pyyka opo pe. A'ere 'ga 'jau 'Uwarete 'ga upe: —Au'jete 'ã mama'ea eremut oree. Ene te 'ã eneresage oree, Kiapi'ni— 'jau 'ga 'Uwarete 'ga upe. A'ere 'ga kanape'i mowowoka imonou wemimu'e 'gã nupe. Omowowogamũ ojeme'yita 'gã nupe. A'eramũ 'gã imonou wapyk ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ipira'ia nanẽ niapoi nũ. A'ere Jejui 'ga eroje'ega opo pe 'Uwarete 'ga upe nũ, 'ga muorypa ee. A'eramũ 'ga ipira'i monou wemimu'e 'gã nupe. A'erauwe ipira'ia ojeme'yita nũ. A'eramũ 'ga remimu'e 'gã imonou wapyk ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A'eramũ 'gã ojemi'waa wewegamũ. Weweg ire Jejui 'ga remimu'e 'gã emyrera mono'oga imonou yrũũũ pype. Sete yrupemũũa 'gã imatyneema. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kanape'i 'warera 'gã pytuna kwaturu miu agawewi 'gã pytuna. 'Gã jemi'war ire Jejui 'ga 'gã monou 'gã 'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","A'eramũ 'ga u'aa yaruu pype wemimu'e 'gã netee. Awau 'gã oyaapa awau ojekoka Taumanuta ywy are. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Peu fariseu 'gã amũ 'ua oporogytau Jejui 'ga upe. Nuerowiari 'gã 'ga. “NaJarejuwarete 'ga pãjẽ mũ rũi 'ga mama'e apoi”, e'i etee 'gã ajaupe. A'eramũ 'gã 'ua 'ga resaka. A'eramũ 'gã 'jau Jejui 'ga upe: —Aeremiapoe'ema eapo amũ ore reape. Taruesak ene mama'e apoa orojemiesagamũ 'jau. “Jarejuwarete 'ga pãjẽ mũ futat 'ga aeremiapoe'ema apoi ra'e”, taru'e enee 'jau. A'eramũ ene mama'e apou 'ga pãjẽ resaukaawamũ oree— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A'eramũ Jejui 'ga ojepytuekyita 'gã nee. A'ere 'ga 'jau 'gã nupe: —Naani. Naapoa'uweri je pẽnemiapoe'ema pẽ neape. Naje rerowiari futari pejepe. A'eramũ je mama'e apowe'em pẽnemiesagamũ— 'jau ete Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A'eramũ Jejui 'ga awau 'gã nui nũ. Yaruu pype 'ga awau u'aa wemimu'e 'gã netee. A'eramũ 'gã awau oyaapa. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A'ere 'ga remimu'e 'gã nuerooi kanape'i ojeupi. Amoka'jam 'gã erooa. Majepei'ia te 'gã erawau. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A'e pype Jejui 'ga 'jau 'gã nupe: —Pejea'gu ki fariseu 'gã nui, 'gã mani'oko'o jopypeaw awi. Erote 'ga ma'e awi 'jau ki pejejea'gwau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aipo ojeupe 'ga 'eramũ 'gã 'jau ajaupe: —Kanape'i rerura ako jane simoka'jam ko. A'eramũ 'ga poromũ 'jau janee kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","A'ere Jejui 'ga 'gã 'e renuwi. A'eramũ 'ga 'jau 'gã nupe: —Naje rerowiari tãmẽjẽ pejepe pejejemogyau ki sa. Ma'eramũ nã'ã aipo pe'je pejejaupe re'ã. “Kanape'i rerure'em are 'ga 'i poromũ janee”, pe'je re'ã— 'jau Jejui 'ga 'gã nupe. —Ma'eramũ sipo pẽẽ pejejeapyoe'emamũ je'eawer are pejejemogyau 'wei? ");
INSERT INTO kyzNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pẽnea 'ã pẽẽ numiamũ. A'ere 'ã nepeesagi mama'ea. Pejeapyaramũ 'ã numiamũ. A'ere 'ã nepeanuwi jeje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pemoka'jam nipo jeremiapofera rai'i? Kanape'ia je ime'yitawera rai'i? Sĩku etee agawewi ako ai'i. A'etea ako je kanape'ia omowowok imonou sĩku miu kũima'e 'gã mojemi'waawamũ ai'i. 'Gã jemi'wapaw ire marãmaran ajee yrũa pematyneem emyrera pyu rai'i?— 'jau Jejui 'ga 'gã nupe. —Tusi yrũa ako tyneema ai'i— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A'eramũ Jejui 'ga oporonuwu'japa ee 'gã nupe nũ: —A'ere ako je sete kanape'i mowowoka kwaturu miu 'gã mojemi'waawamũ ai'i nũ. 'Gã jemi'wapaw ire marãmaran yrũa ajee pematyneem emyrera pyu rai'i nũ?— 'jau 'ga 'gã nupe. —Sete yrũa ako tyneema ai'i— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Nepẽneapyoi we tãmẽjẽ pẽẽ ee? “Pejea'gu ki fariseu 'gã mani'oko'o mojopypeaw awi”, a'e ako je pẽ nupe ko. A'ere ako je nakanape'i upe rũi je 'i ko. “'Gã nemimu'e morogyta awi ki pejea'gu”, a'e te je ako pẽ nupe ko— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","A'ere Jejui 'ga awau owaẽma Pesaita 'jawa upe wemimu'e 'gã netee. A'eramũ peuwara 'gã amũ eae'ema 'ga rerua Jejui 'ga upe. —Epoa emono 'ga rea 'arimũ. 'Ga rea tajekatu'ok 'jau— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A'erauwe Jejui 'ga eae'ema 'ga popyyka 'ga rerawau 'ga renuẽma amunaw awi. A'erauwe 'ga onymuna opo are. A'ere 'ga weny monou 'ga rea are. A'ere 'ga opo monou 'ga 'arimũ. A'ere 'ga 'jau 'ga upe: —Ereesak te mama'ea 'awamũ?— 'jau 'ga 'ga upe oporonupa ee 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A'eramũ eae'ema 'ga 'jau 'ga upe: —Aesak futat je numiamũ. A'ere 'gã 'ywa 'jawe etee jee wesagamũ— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A'ere Jejui 'ga opo monou'japa 'ga rea 'arimũ nũ. A'eramũ te 'ga mama'e resagi katu. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","A'erauwe Jejui 'ga eae'emera 'ga monou 'ga 'wyr ipe nũ. —Eje'wyr ipe ekwap. Ereo kasi amunaw ipe ne— 'jau 'ga 'ga upe, 'ga monou 'ga 'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A'ere Jejui 'ga awau Sesariafiripai ywy pe wemimu'e 'gã netee. Awaw ipe Jejui 'ga 'jau wemimu'e 'gã nupe: —Ma'ja e'i te tekotee 'gã jee jepi?— 'jau 'ga 'gã nupe oporonupa ee 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A'eramũ 'ga remimu'e 'gã 'jau 'ga upe: —“Juã Batista 'ga te nipo 'ã 'ut oferapa rai'i nũ”, e'i amumera 'gã enee jepi. Amumera 'gã: “Eliasi 'ga nipo 'ã 'ut ojewya rai'i nũ”, 'jau enee. Amumera 'gã: “Jarejuwarete 'ga je'ega mome'warera 'gã amũ te nipo 'ã 'ut oferapa rai'i nũ. 'Agamũ 'ua oporogytau akou janee nũ”, 'jau 'gã enee jepi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Pẽẽ nũ. Ma'ja pe'je ajee jee jepi?— 'jau 'ga 'gã nupe. —Ene Jarejuwarete 'ga remimurera, aru'e ore jepi— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pemome'u kasi ajee aipoa 'gã nupe ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aipo pe futat Jejui 'ga ajukaawama mome'wau ypy ypy wemimu'e 'gã nupe. —Je 'ã pẽneki'yr ymanera. A'ere nipo 'gã anurenure'i je rereko tyweretei. 'Wyriara 'gã nipo je reroyrũmũ. Judeuramũ jane 'wyria'ri, mainana 'wyriat, Moisesi 'ga remikwasiarer are moromu'jat. Mĩmera 'gã nipo je reroyrũ. A'eramũ nipo 'gã je jukaukaa 'gã nupe. A'ere nipo imuapyra 'ara rupi Janeruwarete 'ga je moferawi nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jejui 'ga ajukaawama mome'wau katu tãmẽjẽ 'gã nupe. A'eramũ Pedro 'ga 'ga rerojepe'au'i 'gã nui. A'eramũ 'ga oje'egayau 'ga upe: —Ene'me awi nũ'ũ. Nene rereko tywera'uweri 'gã nũ'ũ. Janeruwarete 'ga nene rereko tywerukara'uweri 'gã nupe kũi— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A'erauwe Jejui 'ga ojerowaka amã'jãu wemimu'e 'gã nee. A'eramũ 'ga 'jau Pedro 'ga upe: —Ejepe'a je wi, ki Satanasi. Mama'eukwaawa 'wyriara ene mu'eukat poromũ jee, ki Pedro. “Tamomoirukat 'ga 'ga Ruwarete 'ga remifutara apo awi 'jau”, e'i te Satanasi jee. A'eramũ poromũ ene mu'eukaa jee kũi. NaJarejuwarete 'ga remifutar imũ rũi ere aipo 'jau jee. Ejemifutar imũ te ere aipo 'jau jee— 'jau Jejui 'ga Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A'ere Jejui 'ga mytuna 'gã majatykau ojee, wemimu'e 'gã neewe. A'eramũ 'ga 'jau 'gã nupe: —Jeremiayuwamũ pejejekoweramũ ki pẽẽ jeremifutar imũ etee futat mama'ea peapo. Pejekyjawe'em futat pejejereko tywer awi— 'jau 'ga 'gã nupe. —Pejemanũ awi miamũ pejekyjawe'em futat. “Tene 'gã je jukai kwy. Napoira'uweri je Jejui 'ga rerowiar awi”, pe'je etee ki— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","—“Najemanũweri je Jejui 'ga mome'u are” 'jara 'gã nooa'uweri futari ywag ipe Jarejuwarete 'ga pyri. “Je naapoa'uweri futari mama'ea Jejui 'ga remifutar imũ” 'jara 'gã nanẽ nooa'uweri ywag ipe Jarejuwarete 'ga pyri— 'jau Jejui 'ga 'gã nupe. —Amumera 'gã te nipo ajee e'i “tene 'gã je jukai kwy. Je napoira'uweri 'ga mome'u awi”, 'jau. Aipo 'jara 'gã etee awau ywag ipe Jarejuwarete 'ga pyri— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","—Okaraemã mono'og are etee ea'at ma'e 'gã nanẽ ni'akwaawi futari. Kwaiwete agawewi 'gã karaemã. A'ere aipo 'gã miamũ nooi futari ywag ipe. Nomỹi 'gã weaa Jarejuwarete 'ga ree. Okaraemã me'yi are etee 'gã fueweramũ. A'ere 'gã je rerowiar are jẽmĩ wea'are'emamũ. A'eramũ 'gã awawe'em 'ga pyri. Mama'eukwaawa rapyaw ipe etee nanuara 'gã awau. Peu oo re 'gã nuẽmarũi futari jui. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nitywi mama'e mũ mama'eukwaawa rapyaw awi 'gã nenũ'jãawamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","—'Awamũ ete 'gã naje rerowiari futari. Nomỹi futari 'gã weaa je ree. Kwaiwete 'gã mama'e tywera etee iapou. A'eramũ nipo je rerowiaara 'gã o'meramũ je rerowiare'ema 'gã nupe. “Na'ga rerowiaara rũi je”, 'jau futatee nipo 'gã ajemogyau 'gã nupe. Ojenosĩ 'gã jeje'ega mome'u awi. “Je 'ã Jejui 'ga remiayuwa”, 'jawe'em 'gã. Aipo 'ea 'gã enosõu. A'eramũ nipo je anure tejewya je nanẽ futat aipo 'gã nui tejenosõu. Tejuawa rupi je ruri Tejuwarete 'ga renyfuga pype, ywagipewara 'gã nenyfuga pype 'jau. A'eramũ je aipo 'ara rupi tejenosõu tekwakuparera 'gã nui— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Anure nipo pẽẽ mũ je resak pejepe pejemanũme'ẽwe peje'wyriaramũ je rekoa. Jarejuwarete 'ga pãjẽa nipo pẽẽ mũ esaka— 'jau 'ga u'ama 'gã nupe oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Anure seis oser ire Jejui 'ga awau ywyty'rarimũ. Muapyra 'gã etee 'ga erawau ojeupi. Pedro 'ga, Tiago 'ga, Juã 'ga. Mĩmera 'gã etee 'ga erawau erojeupia ywyty'rarimũ ojeupi. Peu Jejui 'ga ojesowo'gõka 'gã neape. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'Ga raitya waparasigamũ 'ga ree. Iaparasig enyfuk te 'ga raitya 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A'erauwe 'gã Moisesi 'ga resaka Eliasi 'ga reewe. Ywag awi 'gã 'ua oporogytau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ywag awi 'ut ma'e 'gã nesakawe Pedro 'ga 'jau Jejui 'ga upe: —'Awa esageay janee ra'e. 'Au etee sapyta 'jau, ki Ku'jyp— 'jau Pedro 'ga Jejui 'ga upe. —Muapyra tapỹja taruapo pẽ nupe 'jau. Ene upe, Moisesi 'ga upe, Eliasi 'ga upe 'jau— 'jau Pedro 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jejui 'ga remimu'e 'gã kyjea 'gã nerekou. A'eramũ Pedro 'ga u'akwaawe'emamũ poromũ 'jau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","'Ga porogytapaw ire ywasiga 'ua ojypa 'gã nee nũ. A'e rupi futat Janeruwarete 'ga oje'ega mua 'gã nupe: —Koromũ futat Jera'yrarete 'ga. Jeremifutararete 'ga. A'eramũ ki pẽẽ 'ga je'eg are pejeapyakau— 'jau Janeruwarete 'ga oje'ega mua ywasiga rupi 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A'erauwe 'gã warekou. A'ere 'gã Jejui 'ga etee futat esagi 'ga 'amamũ. Ywag awi 'ut ma'efera 'gã awau ojeupia ywasiga rupi 'gã nui nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ywytyr awi 'gã neruaw ipe Jejui 'ga 'jau 'gã nupe: —Pemome'ua'ne kasi 'gã nupe ne. Pejejeki'yramũ je feraw ire tãmẽjẽ tepemome'u 'gã nupe 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aipoa 'gã nomome'ui futari 'gã nupe. A'ere 'gã naeapyoi 'ga 'eawer are, “Je feraw ire” 'eawer are. A'eramũ 'gã imome'waukaa ajaupe: —Ma'ja upe 'ga aipo 'jau janee nũ'ũ? Ma'ja are sipo 'ga jane mu'ei? Ma'ja upe sipo 'ga 'i “jeferaw ire tepemome'u 'jau”, 'jau janee— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A'eramũ 'gã oporonupa ee Jejui 'ga upe: —Ma'eramũ ajee Moisesi 'ga remikwasiarer are moromu'jara 'gã 'i 'ũ: “Ymã 'ã Janeruwarete 'ga ka'arana kwasiarukari 'ga amũ upe rakue: ‘Eliasi 'ga ra'ne nipo ojesaukat 'gã nupe. A'ere nipo 'ga rewiri jeremimonorama 'ga oi ojesaukaa 'gã nupe’, 'jau 'ga 'ã ikwasiarukaa inuga ka'aran are rakue”, 'jau 'gã imome'wau oree— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat 'gã 'i. Eliasi 'ga 'jawewara 'ga ra'ne futat ako 'ut ai'i. “Au'je ki mama'e tywera apo re. Pe'je ki pejepoia pejetywer awi. Janeruwarete 'ga tepẽ mogy wemiayuwamũ 'jau”, 'jau ako 'ga awau pẽ nupe ai'i, je renune ai'i. Juã Batista 'ga futat Eliasi 'ga 'ut 'jawamũ. A'ere nepekwaawi futari 'ga. A'eramũ 'gã 'ga rerekou tyweaete wemifutar imũ etee 'ã rai'i. Anure nipo 'gã je miamũ je rereko tyweretei 'ga 'jawerimũ futat. Ymã 'ã Janeruwarete 'ga ka'arana kwasiarukari 'gã nupe je rereko tyweaw are rakue. A'eramũ nipo 'gã je rerekou tyweaete je reroyrũmũ 'ga 'eawer imũ etee futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ywytyr awi ojyw ire 'gã 'gã nesaka kwaiwete wemimu'e 'gã ywyri. Moisesi 'ga remikwasiarer are moromu'jara 'gã amũ oporogytau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A'ere 'ga resakawe mytuna 'gã oporesagamũ Jejui 'ga ree. A'eramũ 'gã awau ujãna 'ga rapeje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A'erauwe Jejui 'ga oporonupa ee 'gã nupe: —Ma'ja are te pejamue pejejupa ra'e?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A'eramũ kũima'e 'ga amũ mytuna 'gã pyter awi oje'ega mua 'ga upe: —Teja'yra 'ga je arut enee, ki Ku'jyp. Mama'eukwaawa 'up 'ga pir are. A'eramũ mama'eukwaawa 'ga moje'egukare'ema. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mama'eukwaawa 'ga pyykawe 'ga moywyrupãu 'ga monou 'ga retyka. A'eramũ 'ga moypipa, 'ga mua'jykã'jykãina 'ga motyjuita. A'eramũ 'ga mopifuakare'ema 'ga mogou. “Pepe'a 'ga wi”, a'e futat je eneremimu'e 'gã nupe ko numiamũ. A'ere 'gã nope'ai ete 'ga wi ko— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A'eramũ Jejui 'ga 'jau 'gã nupe: —Maranime gatu nipo 'ã je rerowiat pejepe pejejemogyau? Ymã agawewi 'ã je pẽ mu'ei. A'etea nipo 'ã naje rerowiar ymani pejepe 'ja. “Nakoa'uweri je namutamutat pẽ pype”, a'e agawewi je 'ã pẽ nupe— 'jau 'ga wemimu'e 'gã nupe, tesirũmera 'gã neewe futat. —Pe'je 'ga ra'yra 'ga rerua jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A'erauwe 'gã 'ga rerua. A'ere Jejui 'ga resakawe 'ga pirewara 'ga moyyita 'ga monou 'ga retyka 'ga mojerejerepa ywyu. 'Ga motyjuita 'ga juru rupi. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","A'eramũ Jejui 'ga oporonupa ee kunumĩ 'ga ruwa 'ga upe: —Maranime te mama'eukwaawa ruwi enera'yra 'ga pir are rai'i 'ũ?— 'jau 'ga 'ga upe. A'eramũ 'ga ruwa 'ga 'jau 'ga upe: —'Ga kunumĩa we futat mama'eukwaawa wereko opir are ikue— 'jau 'ga ruwa 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Amumẽ mama'eukwaawa 'ga monoukaa 'ga retyka tata pe jepi. Amumẽ 'ga momorukaa 'y pe, 'y pe 'ga jukaawamũ jepi numiamũ. A'eramũ ore 'ga rerua enee. Maran gatu nipo ene nanẽ ipe'awe'em 'ga wi nũ. Ejemuaẽm ore ree jera'yra 'ga retee— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Tejerowiaramũ je mama'e apoi pẽ nupe. Nitywi futari mama'ea jeremiapoe'ema, pẽẽ je rerowiaa 'eramũ— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A'eramũ 'ga 'jau 'ga upe nũ: —Arowiat je ene. Ejerowiar ywyapiukat jee— 'jau 'ga wafukaita 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","A'eramũ mytuna 'gã 'ua ajatykau 'gã nee. 'Gã nesakawe Jejui 'ga 'jau mama'eukwaawa upe: —Ejepe'a 'ga wi. Erejewyt kasi 'ga upe ne— 'jau 'ga mama'eukwaawa upe. 'Ga pirewara aipo 'ga kunumĩ 'ga muapyaukare'ema, 'ga moje'egukare'ema 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ojeupe Jejui 'ga 'eramũ 'ga pirewara 'ga mopapaga, 'ga maema. A'eramũ ojepe'au 'ga wi. Amanũ ma'e 'jawe 'ga monou 'ga retyka. A'eramũ esakara 'gã 'jau ajaupe: —Amanũ ete nipo kwe 'ga— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","A'eramũ Jejui 'ga kunumĩ 'ga popyyka 'ga mafu'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A'ere Jejui 'ga wemimu'e 'gã nerawau 'gã nerosou 'og ipe. A'eramũ 'ga remimu'e 'gã 'jau 'ga upe: —Maran ajee ore norope'aarũi 'ga wi ra'e 'ũ?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A'eramũ Jejui 'ga 'jau 'gã nupe: —Nepeporogytai tãmẽjẽ Jarejuwarete 'ga upe pejejemogyau. A'e are nepẽfuakari'i nanuara apou. A'eramũ 'ã pẽẽ a'eramũ 'ga pirewara pe'aarũme'em 'ga wi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","A'eramũ Jejui 'ga awau aipo awi, wemimu'e 'gã netee. Garireja ywy raapa 'gã awau. Wemimu'e 'gã mu'ea 'ga ifutaa. “Nafutari je mytuna 'gã tejeko kwaawa. Tamu'e tejemimu'e 'gã etee tejee 'jau”, 'jau 'ga ojeupe. A'eramũ 'ga 'jau 'gã nupe: —Pẽneki'yra agawewi je 'ã. A'etea nipo 'ga amũ anurenure'i je mono ae a'wyre'ema 'gã po pe. Janeruwarete 'ga nipo je pyygukaa je ree iporomutare'ema 'gã nupe. A'eramũ nipo 'ga je jukaukaa 'gã nupe. A'ere nipo 'ga imuapyra 'ara rupi je moferawi nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A'ere 'gã naeapyoi 'ga 'eawer are. A'eramũ 'gã “simome'uukat 'ga upe 'jau”, 'jau 'gã ajaupe numiamũ. A'ere 'gã jenosĩ 'ga upe imome'uukar are. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Anure Jejui 'ga awau owaẽma Kafanaũ 'jawa upe wemimu'e 'gã netee. 'Og ipe ose re Jejui 'ga oporonupa ee 'gã nupe: —Ma'ja are te peporogyta pejejaupe pe rupi ra'e?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A'ere 'gã pigi etee. “Manamũ te jane Jarejuwarete 'ga upe esage ma'eramũ jarejuapyraapa?” 'jau 'gã ajaupe, ajamueu ee. A'eramũ 'gã ojenosõu imome'u awi. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A'ere Jejui 'ga 'gã 'eawera kwaawi. A'eramũ 'ga wapyka oporogytau 'gã nupe: —'Wyriaramũ pejejekoweramũ mama'ea peapo etee futat, pejejopoaa— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aipo 'e re 'ga kunumĩ 'ga pyyka 'ga mafu'ama wemimu'e 'gã pyter ipe. A'ere 'ga kunumĩ 'ga mana imome'wau wemimu'e 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Kunumĩ 'gã nee ijejuka esage ma'eramũ je reewe futat pejejuka esage. Je ree ijejuka esage ma'eramũ je muarera 'ga reewe futat pejejuka esage— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A'eramũ Juã 'ga 'jau Jejui 'ga upe: —Kũima'e 'ga amũ ore aruesak mama'eukwaawa pe'aa 'gã nui ko, enerer imũ ko. A'ere norepytuna 'ga rũi. A'eramũ ore 'jau 'ga upe ko: “Ereapo awi nanuara”, 'jau ore 'ga upe ko— 'jau 'ga imome'wau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aipo 'eramũ Jejui 'ga 'jau 'gã nupe: —Aipo pe'je awi 'gã nupe. “Peapo awi nanuara”, pe'je awi 'gã nupe. Jerer imũ aeremiapoe'ema apoara 'gã naje kurawa'uweri. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Najanepytuna 'gã nũi numiamũ. A'ere 'gã jane poari te jane porowyky are. A'eramũ 'gã janepytuna 'jawe futat ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'Yro'ysaga etee agawewi nipo 'gã imonou jeremiayuwamũ pẽẽ mũ nupe i'yuwei ma'eramũ. A'etea Janeruwarete 'ga 'yro'ysaga monoarera 'gã mepyau ee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Kunumĩ'ĩ'ĩ 'gã etee te a'jea futat je rerowiat ajemogyau. A'eramũ nipo Janeruwarete 'ga je rerowiar awi kunumĩ'ĩ'ĩ 'gã momoirukaara 'gã nerekou tyweaete. Nanuara apoara 'gã amunipo 'ã ita mogou tãmẽjẽ 'ga jur are. A'ere 'ga monou 'ga momoa 'y pe 'ga mateepawamũ. 'Y pe imomoripyra 'ga ako tywet futat numiamũ. A'ere je rerowiar awi kunumĩ'ĩ'ĩ 'gã mosĩara 'gã te ia'wyre'emaretea. Janeruwarete 'ga miamũ najemuaẽmi nanuara 'gã nee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","—“Jepoa je motywerukat Jarejuwarete 'ga upe. Mama'e tywera apoukaa jee, je motywerukaa Jarejuwarete 'ga upe”, 'jau ki pejepoa pemonok imonou imomoa pejejewi. Aepo monoga ay futat numiamũ. A'ere mama'eukwaawa rapyaw ipe pẽoa te ayrete ma'ea. Peu tataa nowewa'uweri. Nateepawa'uweri mama'eukwaawa rapyawa tataa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","—“Jepya je motywet Jarejuwarete 'ga upe”, 'jau nipo pẽẽ pejepy upe. A'eramũ pẽẽ imonoka imonou imomoa pejejewi. Aepy monoga ay futat numiamũ. A'ere mama'e tywera apoara 'gã mama'eukwaawa rapyaw ipe 'gã oa te ayramũ. A'jea futat ay ma'ea. A'eramũ nipo waywayramũ futat aipo pe imonopyrera 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","—“Jerea je motywet. Ẽẽ resage'em ire amunipo 'ã je najerea'ari ẽẽ ree tekou”, 'jau nipo pẽẽ pejejeupe. A'eramũ je 'jau pẽ nupe: “Orereaa ore motywerukat”, 'jau pejejeaa pemosok imonou imomoa pejejewi. Kasi a'e pe pẽnea pẽ motywerukaru'jaw ine nũ— 'jau 'ga 'gã nupe. —Pẽnea mosoga ay futat. A'ere mama'e tywera apoara 'gã mama'eukwaawa rapyaw ipe 'gã oa te ayramũ. A'jea futat ayay aipo pype imonopyrera 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","—Mama'eukwaawa rapyaw ipe merua'yra amanũme'em futat peuwara 'gã no'o 'u awi. Nowewi futari tataa mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","—Anure nipo Janeruwarete 'ga werowiare'ema 'gã nereko tyweretei 'gã monou mama'eukwaawa rapyaw ipe. A'ere 'ga wemiayuwamũ pẽ nupe mama'eay resaukari mama'e tywera pẽẽ iapoe'em are pẽ mu'jawamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","—Esage jukyra numiamũ. A'ere mama'e tywer are imojopype re jane imote'ari. Imote'ar ire jane imuesageu'jape'ema. A'ere mama'e tywera ojepype imojopype re nia'wyru'jawi janee a'eramũ— 'jau 'ga 'gã nupe. —Pẽẽ ki pejemogy jukyr esage 'jawe. Pejejomojyrũmũ pejejaupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A'ere Jejui 'ga awau Judeja ywy pe. Jotãuy raapa 'ga oramũ mytuna 'gã 'ua ajatykau'japa Jejui 'ga ree. 'Uwarete 'ga ree 'ga 'gã mu'ei jepi. A'eramũ 'ga 'awamũ nanẽ 'gã mu'jau 'ga ree nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A'eramũ fariseu 'gã amũ 'ua oporogytau Jejui 'ga upe. “Siesak 'ga je'eg amuteea jarejee 'jau”, 'jau 'gã ajaupe. “'Ga je'eg amuteeramũ, sa'e 'ga upe 'jau: Nuenuwi 'ga Moisesi 'ga je'ega ra'e, sa'e 'ga upe 'jau jaremu'e amuteeramũ 'jau”, 'jau 'gã ajaupe. A'eramũ 'gã 'jau 'ga upe: —Jaruete sipo kũima'e 'ga wemireko retygi?— 'jau 'gã 'ga upe oporonupa ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'ja e'i Moisesi 'ga rakue?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A'eramũ 'gã 'jau 'ga upe: —“Pejejemireko retyka ki ka'arana pekwasiarukat 'ga amũ upe ẽẽ ree. ‘Aetyk je ene tejemirekoramũ akiko’, pe'je ki ikwasiarukaa pejejemirekofera ẽẽ ree, imonou ẽẽ upe”, 'jau 'ga ikwasiaa rakue— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—A'jea futat— 'jau Jejui 'ga 'gã nupe. —Niporenuwiweri wejue pẽypy 'gã Jarejuwarete 'ga je'eg are rakue. A'eramũ Moisesi 'ga 'gã mueapyoukaa aipo are rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","A'ere Janeruwarete 'ga aipo ne'i aeypy 'gã nupe rakue. “Kũima'e 'ga je aapo kũjã ẽẽ reewe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","A'eramũ 'ga wemireko re kũima'e 'ga opojo'ogamũ ujara 'gã nui ojemujaa wemireko ẽẽ ree etee”, 'jau Janeruwarete 'ga rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","“Ajuee ojemujar ire 'gã jemogyi majepei teewara 'jawe jee”, 'jau Janeruwarete 'ga rakue. Ajuerekoe'ema 'gã mukũi futat 'gã nekoi. A'ere 'gã ajuereko re 'gã majepei 'jawe etee 'gã nekoi Jarejuwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Janeruwarete 'ga wejue 'ga werekoukat 'gã ajaupe. A'eramũ pẽẽ pejejomojo'ogarũme'em pejejaui, pejejuereko re— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","'Og ipe ose re Jejui 'ga remimu'e 'gã oporonupa ee 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Wemireko retykarera 'gã kũima'e 'gã ajemogoukat kũjã wemirekoe'em are ako ma'e 'jawewara ẽẽ ree amutee ẽẽ rerekou nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kũjã nanẽ nũ. Omena retykarera ẽẽ ajemogoukaa kũjãmene'ema 'jawe amutee 'ga etee erekou nũ— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Anure 'gã amũ wa'yra 'gã nerua Jejui 'ga upe nũ: —Orera'yra apyte'rarimũ epo emono a'i kĩ'ĩ— 'jau 'gã erua 'ga upe. —Jarejuwarete kĩã upe eporogyta wã nee. A'eramũ Janeruwarete kĩã ojejukau esage wã nee, aru'e ore enee kĩ'ĩ— 'jau kũjãmera 'gã 'ga upe. A'ere Jejui 'ga remimu'e 'gã 'i etee 'gã nupe: —Perur awi pejeja'yra 'gã 'ga upe 'ga porogyta 'ga 'amamũ. Nepemaruukari 'ga porogyta— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","A'ere Jejui 'ga nafutari. A'eramũ 'ga 'jau 'gã nupe: —Naani. Peapo awi nanuara. Tene kunumĩ 'gã nuri je pyri— 'jau ete 'ga wemimu'e 'gã nupe. —Janeruwarete 'ga kunumĩ 'gã afutat wemiayuwamũ. Kunumĩ 'jawewara 'gã nupe etee Janeruwarete 'ga reni 'wyriaramũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","—Pẽnea'ar iki je'e are. Kunumĩ 'gã ojemogypyyk te Jarejuwarete 'ga ree. Ojereko katuukat 'gã 'ga upe. 'Gã 'jawe pejemogyramũ 'ga pẽ katu'ogi. Kunumĩ 'jawewara 'gã etee te Janeruwarete 'ga omogy wemiayuwamũ. A'ere 'ga ojee ijemogypyyke'ema 'gã Janeruwarete 'ga nomogyi wemiayuwamũ. Nakunumĩ 'jawe rũi 'gã. A'eramũ 'ga 'gã mogyawe'em wemiayuwamũ— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A'eramũ Jejui 'ga kunumĩ 'gã mana enu'ama, opo monou kunumĩ 'gã apyte'rarimũ. A'eramũ 'ga 'jau 'gã nupe: —Janeruwarete 'ga ojejuka esage pẽ nee, kunumĩ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jejui 'ga 'wyt 'ga rekoramũ kũima'e 'ga amũ 'ua ujãna wapyka wenupy'ãu 'ga rowase. A'eramũ 'ga 'jau 'ga upe: —Ene 'ã eneresage. Ma'ja te je aapo 'awamũ tejeupe, temanũ re ywag ipe tejesawamũ, Jarejuwarete 'ga pyri tewawamũ?— 'jau 'ga 'ua Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A'eramũ Jejui 'ga 'jau 'ga upe: —Ma'eramũ te aipo ere jee? Janeruwarete 'ga etee te esage. “Ene 'ã Jarejuwarete 'ga 'jawewara futat”, ere te jee?— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","—Erekwaap nipo Moisesi 'ga remikwasiarera. “Peporojuka awi. Peko awi pejejuemireko are. Pemunarũ kasi mama'e are ne. Peje'ẽwu'jag kasi 'ga amũ ne. Pẽ'me kasi pejejaupe ne. Pejejomoryteewe'em 'jau. Pejejara 'gã je'ega anupa etee 'jau”, 'jau 'ga 'ã ikwasiaa inuga ka'aran are rakue. Mĩmera 'ã erekwaapap— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A'eramũ 'ga 'jau 'ga upe nũ: —Je kunumĩawe futat aipoa akwaap ikue. Moisesi 'ga je'eg imũ etee futat je mama'e apoi tekou— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aipo 'ga 'eramũ Jejui 'ga amã'jãu 'ga ree, iporiaa 'ga 'ga ree. A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat ere. A'ere 'awamũ mama'e mũ eapo. Ekaraemã eme'ẽmap. A'ere ene ka'aranũũ monou ika'aranũũe'ema 'gã nupe. Aipoa ene iapo re, Janeruwarete 'ga ene monoi ojepyri ene manũ re. Mama'e esagea te nipo 'ga amut enee anure, ekaraemã monoawera mepyau enee anure nũ. Ekaraemã me'eg ire ene ejua je rewiri— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aipo ojeupe Jejui 'ga 'eramũ 'ga u'arasigamũ etee okaraemã are. Kwaiwete te 'ga karaemã. A'eramũ 'ga oporome'egiwere'emamũ ee. A'eramũ 'ga 'jau ojeupe etee futat: “Naani. Naapoa'uweri je nanuara”, 'jau 'ga ojeupe etee futat. A'eramũ 'ga u'arasigamũ awau Jejui 'ga aipo ojeupe 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A'eramũ Jejui 'ga amã'jãu wemimu'e 'gã nee. A'eramũ 'ga 'jau 'gã nupe: —Ayay te ikaraemã kwai ma'e 'gã ajemogyau Jarejuwarete 'ga remiayuwamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aipo 'ga 'erauwe 'ga remimu'e 'gã oporesagamũ 'ga ree. A'eramũ 'ga 'jau'japa: —Ayay te 'gã ajemogyau Jarejuwarete 'ga remiayuwamũ. Kwaiwete 'gã karaemã. A'eramũ 'gã okaraemã are etee wea'aramũ. Okaraemã are etee aipo 'gã jemogypyygi akou. NaJarejuwarete 'ga ree rũi 'gã jemogypyygi ajemogyau. Jeje'ega 'gã nuenuwi futari ajemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","—Sã'ã kawaruu 'jawewara kamerua aguja kwara rupi ikwawe'ema. Nan tee futat ayayramũ ikaraemã kwai ma'e 'gã ojekatu'ogukaa Jarejuwarete 'ga upe. Ikaraemã kwai ma'e 'gã nijekatu'ogukariweri futari Jarejuwarete 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aipo renupawe 'ga remimu'e 'gã oporesagamũ etee Jejui 'ga ree ajemogyau. A'eramũ 'gã oporonupa ee ajaupe etee futat: —Maranuara 'gã tete Janeruwarete 'ga okatu'ok?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Pẽ nupe nayrareferi futari. Ayay futat mama'e apoa pẽ nupe. A'ere nitywi futari Janeruwarete 'ga remiapoe'ema mũ mama'ea. Mama'ea naayi futari 'ga upe. Ikaraemã kwai ma'ea miamũ Janeruwarete 'ga okatu'ok, “Je katu'og ape”, ojeupe 'gã 'eramũ— 'jau etee Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A'eramũ Pedro 'ga 'jau 'ga upe: —Ore ako aruejat orokaraemã arajua ene rupi ai'i. Oropytuna nanẽ futat ako ore ejaa ai'i nũ— 'jau Pedro 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat ako ai'i. A'eramũ je 'jau pẽ nupe: Anure nipo Janeruwarete 'ga mama'e monoi omama'e rejarera 'gã nupe. Je mome'u are woga rejaarera 'gã, weki'yra rejaarera 'gã, wewirera rejaarera 'gã, wenyra rejaarera 'gã, oy rejaarera 'gã, 'uwa rejaarera 'gã, wa'yra rejaarera 'gã, oywy rejaarera 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Mĩmera 'gã nupe nipo Janeruwarete 'ga mama'e monoi. 'Awamũ futat 'ga mama'e monoi 'gã nemiejarera apyraapa jẽmĩ nũ. Woga rejaarera 'gã nupe Janeruwarete 'ga kwaiwete 'oga monoi, sẽg 'oga monou 'gã nupe. Weki'yra rejaarera 'gã nupe Janeruwarete 'ga kwaiwete 'gã mogyau 'gã neki'yra 'jawewaramũ, sẽg 'gã mogyau 'gã neki'yra 'jawewaramũ. Wewirera rejaarera 'gã nupe Janeruwarete 'ga kwaiwete 'gã mogyau 'gã newirera 'jawewaramũ, sẽg 'gã mogyau 'gã newirera 'jawewaramũ. Wenyra rejaarera 'gã nupe Janeruwarete 'ga kwaiwete 'gã mogyau 'gã nenyra 'jawewaramũ, sẽg 'gã mogyau 'gã nenyra 'jawewaramũ. Oy rejaarera 'gã nupe Janeruwarete 'ga kwaiwete 'gã mogyau 'gã y 'jawewaramũ, sẽg 'gã mogyau 'gã y 'jawewaramũ. Oywy rejaarera 'gã Janeruwarete 'ga imogyau kwaiwete ywy jaramũ, sẽg ywy jaramũ. Je rerowiare'ema 'gã nanẽ 'gã nerekou tyweaete je mome'u are nũ. A'ere nipo je mome'wara 'gã anure 'gã oi ajemogyau ywag ipe nakwaparimũ ete rũi futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","—'Awamũ 'gã amũ reni 'wyriaramũ ajaupe. A'ere anure nipo aipo 'gã jemogyi akotee ma'eramũ etee nũ. 'Awamũ 'gã amũ ajemogyau akotee ma'e 'gã 'jawe. A'ere nipo anure aipo 'gã jemogyi 'wyriara 'jawewaramũ nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","A'ere Jejui 'ga awau watau wemimu'e 'gã nupi nũ. Jerusareg ipe 'gã awau. A'eramũ Jejui 'ga awau tenune, 'ga remimu'e 'gã awau akou 'ga rewiri. “Jerusareg ipe nipo 'gã je jukai anure”, 'jau 'ga imome'wau 'gã nupe rakue. A'eramũ 'gã wea'aramũ ojeupe Jejui 'ga 'eawer are. A'eramũ 'gã oporesagamũ 'ga ree. A'ere tekotee 'ga rewiri oo ma'e 'gã oi 'gã newiri. Opy'a'wyramũ 'gã awau. A'ere Jejui 'ga 'i wemimu'e 'gã nupe: —Pe'je pejejua pejejepe'au 'gã nui ra'ne. Taporogyta pẽ nupe etee 'jau— 'jau 'ga 'gã nupe. A'eramũ 'gã ojepe'au 'gã nui. A'eramũ Jejui 'ga ajukaawa mome'wau 'gã nupe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A'eramũ Jejui 'ga 'jau 'gã nupe: —Jerusareg ipe jane oi 'awamũ. Peu futat nipo 'ga amũ pẽneki'yramũ je monoi mainana 'wyriara 'gã nupe, Moisesi 'ga remikwasiarer are moromu'jara 'gã netee— 'jau 'ga imome'wau 'gã nupe. —A'eramũ nipo 'gã 'jau jee: “Sijukaukat 'ga 'gã nupe 'jau”, 'jau nipo 'gã jee. A'eramũ nipo 'gã je monou judeue'ema 'gã po pe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A'eramũ nipo judeue'ema 'gã je kurapa, je rerekoemãu. A'eramũ nipo 'gã onymuna je ree, je nupãnupãu, je monou, je mu'ama 'ypeywar are jepo kutuka je manamamũ futat. A'ere nipo imuapyra 'ara rupi Janeruwarete 'ga je moferawi etee nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A'ere Sepeteu 'ga ra'yra 'gã 'ua Jejui 'ga pyri katu katu 'jau 'ga upe: —Mama'e esagea eapo oree, ki Ku'jyp— 'jau Tiago 'ga 'ua, Juã 'ga retee 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A'eramũ 'ga 'jau 'gã nupe: —Ma'ja pẽẽ ifutaa pejejeupe je iapoa?— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A'eramũ 'gã 'jau 'ga upe: —Ore muapygukar iki ape ejepyri, 'wyriarareteramũ e'ỹi re. 'Wyriarareteramũ ene renamũ nipo 'gã 'ua ene muorypa najuejue etee. A'eramũ ore aruapygiweramũ ene pyri. Ore mũ ki emuapygukat ejakwatawa katy. Ajepejamũ ki ore muapygukat ape ejau katy. 'Wyriaramũ ore mogo ape ejepyri— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A'eramũ Jejui 'ga 'jau 'gã nupe: —Nepẽneapyoi futari ee. 'Wyriarareteramũ teko enune nipo je jerayrũnamũ ra'ne kwaiwete. Je rerekou tyweaete te nipo 'gã. Pejereko tywerukat sipo je pyri? Pẽnuag sipo pejejereko tywera upe?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","A'eramũ 'gã 'jau 'ga upe: —Oreruag futat nipo ore jupe nũ'ũ— 'jau 'gã 'ga upe. A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —A'jea futat nipo 'gã pẽ nereko tyweri anure. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","A'ere je miamũ namuapygarũi pẽẽ tejepyri tepoaawamũ. Je pyriwara 'gã Jeruwarete 'ga te okwaap. 'Ga etee te okwaap. Wemifutar imũ etee 'gã amũ mũ'jãu 'gã muapygukaa je pyri— 'jau Jejui 'ga 'gã mu'jau ojepyri wapyk ma'e 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","'Gã je'ega renupawe amumera 'gã Jejui 'ga remimu'e 'gã amara'neramũ Tiago 'ga ree, Juã 'ga ree nanẽ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","A'ere Jejui 'ga 'gã nenũi 'gã majatykau ojee. A'eramũ 'ga 'jau 'gã nupe: —Pekwaap judeue'ema 'gã 'wyriara 'gã nemiapoa. 'Gã 'wyriara 'gã wemiayuwa 'gã amono kwe pe mama'e apoukaa ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","A'ere pẽẽ jeremiayuwamũ na'gã 'jawe rũi pejemogy. 'Wyriaramũ pejejekoweramũ pẽẽ mama'e apou pejejaupe, pejejopoaa etee futat mama'e apou pejejaupe. Pejejaupe oporowyky ma'eramũ etee futat pejejemogyau. A'eramũ nipo je pẽ mogyi 'wyriaramũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","—Je 'ã pẽneki'yraretea agawewi. A'etea je 'ã ojot 'awa ywy pe mama'e apou pẽ nupe. Natejeupe mama'e apoukaa rũi je ruri. Pẽ nupe mama'e apoawamũ etee te je ruri. Temanũmũ te 'ã je ruri 'au pẽ nupe. Pẽ katu'okawamũ te je ruri 'awa ywy pe. A'eramũ taetu 'gã taje rerowiat 'jau kwy, a'e te je 'ã— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jeriko pe Jejui 'ga awau wemimu'e 'gã netee. Pe awi 'gã oramũ mytuna 'gã awau 'gã nupi. Awaw ipe 'gã eae'ema 'ga amũ resaka, Patimeu 'ga resaka. Aipo 'ga ruwa 'ga Timeua. Peyse pe eae'ema 'ga 'ũina ka'aranũũ renũina ojepyu okwap ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Poje 'ga amũ 'jau 'ga upe: —Jejui 'ga okwap 'awamũ, Nasare pe waranup ma'efera 'ga okwap akou nũ— 'jau 'ga amũ 'ga upe. A'erauwe 'ga Jejui 'ga rera renupawe wafukaita 'ga upe: —Ku'jyp! Ene 'ã Davi 'ga juapyrera, Jarejuwarete 'ga remimurera! Erejemuaẽm te je ree? Epãjẽ mũ je katu'og ape!— 'jau 'ga wafukaita Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","A'eramũ mytuna 'gã 'jau 'ga upe: —Epije e'ỹina kũi— 'jau 'gã 'ga upe, 'ga afukai 'ga renamũ. A'ere 'ga jero'wuro'wui etee wafukaita 'ga upe: —Ku'jyp! Ene te 'ã Davi 'ga juapyrera, Jarejuwarete 'ga remimurera. Ejemuaẽm je ree. Je resag ape!— 'jau 'ga wafukaita ojero'waro'wau etee 'ũina, Jejui 'ga upe wafukaita. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A'erauwe Jejui 'ga opytau pe pe 'ga ree. —Peenũi 'ga— 'jau Jejui 'ga wemiayuwa 'gã nupe. A'eramũ 'gã 'ga renũina. —“Ere ejua”, e'i 'ga enee. A'eramũ ene ekyjawe'em efu'ama ejua ore rupi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A'erauwe Patimeu 'ga opiara momoa ywyu kamẽsĩete afu'ama awau Jejui 'ga repejãna. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","A'eramũ Jejui 'ga 'jau 'ga upe: —Ma'ja te erefutat ejeupe je iapoa?— 'jau 'ga 'ga upe. —Tamã'ẽ 'jau nũ, a'e te je enee, ki Ku'jyp. Jereapap je ikue— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A'eramũ Jejui 'ga 'jau 'ga upe: —Je rerowiar ape ekou ra'e jepi. A'eramũ je ene mamã'jãu nũ— 'jau Jejui 'ga 'ga upe. Aipo 'ga 'erauwe 'ga amã'jãu nũ. A'eramũ futat 'ga awau Jejui 'ga rewiri. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusarega pyriu'i owaẽmamũ 'gã awau ywytyr ipe, Oriweira 'jaw ipe. Mukũi amunawa 'upa ywytyra pyri. Pefaje, Petani. Mĩmera amunawa 'upa ywytyra pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","A'eramũ Jejui 'ga 'jau wemimu'e 'gã amũ nupe, mukũja 'gã nupe: —Pe'je pejewau pejekwapa je renune pejewau pejewaẽma iruupeuwara amunawa upe. Pejesouwe nipo pẽẽ kawaru'i mũ resaka. Nuatai we 'ga amũ i'arimũ. A'ea ki perut iamoia jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","—“Ma'eramũ te peko ee?” pejejeupe 'gã 'eramũ ki “Janejara 'ga te e'i oree ko: Kawaru'ia perut jee ra'ne, e'i 'ga oree ko. A'ere nipo 'ga ko'iko'i ete imuri pẽ nupe nũ”, pe'je ki 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","A'eramũ 'gã awau. Awau 'gã kawaru'i resaka. 'Oga rokwar ipe 'upa ojeamogou. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","'Gã iamoiramũ 'gã amũ 'jau 'gã nupe: —Ma'eramũ pẽẽ pejekou ee ki 'ei? Ma'eramũ pẽẽ iamoia ki 'ei?— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A'eramũ 'gã 'jau 'gã nupe, ojeupe Jejui 'ga 'eawer imũ etee futat: —Janejara 'ga te e'i oree ko: “Kawaru'ia pekwap amũ rerua jee ra'ne”, e'i 'ga oree ko. A'ere nipo 'ga ko'iko'i ete imuri nũ— 'jau 'gã 'gã nupe. A'eramũ ee 'gã nupe oporonup ma'efera 'gã kawaru'i rerawaukaa 'gã nupe. —A'jea. Pe'je ajee erawau 'ga upe— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","A'eramũ 'gã kawaru'i rerawau Jejui 'ga upe. A'eramũ 'gã amũ opiara mososoka imonou kawaru'i 'arimũ Jejui 'ga apykawamũ. A'ere Jejui 'ga wapyka i'arimũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kwaiwete 'gã awau 'ga renunewe opiara mososoka, imonou pe rupi imogyau 'ga kwapawamũ. 'Ga ree oporomutaawa resaukaawamũ 'gã iapou. Pinowa nanẽ 'gã imonou pe rupi 'ga kwapawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","'Ga renune oo ma'e 'gã wafukaita 'ga rewiri oo ma'e 'gã netee: —Au'je katu te 'ã Janeruwarete 'ga resageayramũ janee. Ene 'ã 'ga remimurera futat. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ene 'ã ore 'wyriar ymanera juapyreramũ, Davi 'ga juapyreramũ. 'Awamũ nipo 'ã ene e'ỹina 'wyriarareteramũ oree. Janeruwarete 'ga ojejuka esage ene ree. Janeruwarete 'ga 'ã esage oree. Ene 'ã 'ga imua oree— 'jau 'gã wafukaita Jejui 'ga kawaru'i 'arimũ 'ga rut 'ga rekoramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusarega upe owaẽmawe Jejui 'ga ojypa kawaru'i 'ar awi awau osou 'Uwarete 'ga mogytaaw ipe. A'eramũ 'ga peu ose re amã'jãu mama'e are, mama'ea ipypewar are. A'ere 'ga noje'egi 'gã nupe. Kaaruwamũ futat. A'eramũ 'ga uẽma jui, awau Petani pe wemimu'e 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ai'iwe 'gã awau ojewya Jerusareg ipe nũ. Jejui 'ga opy'arayparamũ akou aipo pe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Awaw ipe 'ga y'wa 'ywa resaka, figu 'jawa 'ywa resaka, kwaiwete oowa resaka. A'eramũ 'ga epejãna i'a rekaa. A'ere nitywi i'aa. Oowa etee esaka akã are. Nowaẽmi we i'aawa upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A'eramũ Jejui 'ga 'jau 'ywa upe: —Au'je katu katu ki e'a re 'awa y'wa 'ywa mũ— 'jau 'ga y'wa 'ywa upe. Aipo 'ga 'ea 'ga remimu'e 'gã enupa. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusareg ipe owaẽmawe Jejui 'ga awau osou Jarejuwarete 'ga mogytaawa osoma pype wemimu'e 'gã netee. Irãã'ã wyra me'egara 'gã jemogyramũ. A'eramũ Jejui 'ga amara'neramũ 'gã nee: —Pe'je pejewau peje'jãu 'aw awi. Nawyra me'egawa rũi te 'ã. Janeruwarete 'ga mogytaawa te 'ã 'oga. 'Au futat jane ruri jareporogytau 'ga upe. A'ere 'ã pẽẽ nanarũi pereko. Pemỹi wyra me'egawamũ etee. Pejejeymawa etee 'ã pẽẽ erua ime'ega erupa 'ga mogytaawa 'oga pype— 'jau Jejui 'ga 'gã nupe. Wyra muara 'gã neewe futat 'ga 'gã mũ'jãu jui. Ka'aranũũ mojopy'ruara 'gã 'yjepana 'ga imonou imuewiwya imojerepa 'gã nui. Aipo ka'aranũũ mojopy'ruara 'gã kwe pewara 'gã ka'aranũũ mojopy'rau ajaupe. A'eramũ Jejui 'ga 'gã 'yjepana monou imuewiwya imojerepa 'gã nui. Ka'aranũũ monou imomopomopoa 'gã nui. Pykau me'egara 'gã kanawaa nanẽ 'ga imojerepa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jarejuwarete 'ga mogytaawa rukara 'ga iaawukare'ema mama'e rerooara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A'eramũ 'ga 'gã mu'jau ee: —Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari Isai 'ga upe rakue: “'Agamũ jemogytaawa 'oga futat. 'Au futat 'gã nuri oporogytau jee, najuejue etee 'gã nuri oporogytau jee”, 'jau 'ga ikwasiarukaa 'ga upe rakue. A'ere 'ã pemỹi wyra me'egawamũ etee. Pejejeymawa me'ega pejejaupe pejejeymawa repy rowoupia ekoete 'ã pejejupa 'au pejejaupe. Ma'eramũ pẽẽ 'ga mogytaawa 'oga mỹina pejemunarũawamũ ete 'ũ?— 'jau 'ga 'gã nupe, oje'ega moywyrafena. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jejui 'ga remiapofera rera renupawe mainana 'wyriara 'gã, Moisesi 'ga remikwasiarer are moromu'jara 'gã netee amara'neramũ 'ga ree. A'eramũ taetu 'gã afuewereteramũ 'ga ree. —Maran tete jane Jejui 'ga jukaarũi?— 'jau 'gã ajaupe. Okyje wejue 'gã mytuna 'gã nui. A'eramũ 'gã poromũ 'jau. Kwaiwete wejue 'gã porenuwiweramũ Jejui 'ga 'e are. A'eramũ 'gã okyjau 'gã nui. “'Ga jukaramũ te 'gã jane apisi ete nũ a'i kũi”, 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kaaruwamũ Jejui 'ga awau uẽma Jerusareg awi wemimu'e 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ai'iwe 'gã awau okwapa y'wa 'ywa pyu nũ, jupe Jejui 'ga 'eawera 'ywa pyu nũ. A'eramũ 'gã esaka nũ. Amanũmũ osiniga u'ama. Apoa we futat oypiwamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A'eramũ Pedro 'ga wea'aramũ Jejui 'ga 'e are. A'eramũ 'gã 'jau Jejui 'ga upe: —Esak, ki Ku'jyp. Jupe ene'eawera ay y'wa 'ywa rai'i. Iypip u'ama amanũmũ ojeupe ene je'eg ire rai'i— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽnea'ar iki je'e are. Jarejuwarete 'ga rerowiar ire pẽẽ nanẽ pejejemiapoe'ema peapo nũ. Ywytyra miamũ futat nipo pẽẽ imojepe'aukaa tenaw awi imonou 'yẽ'ẽ rypyter ipe imỹina. “Ekwap 'aw awi 'yẽ'ẽ rypyter ipe e'ỹina”, ojeupe pẽẽ 'eramũ nipo awau pẽ'eawer imũ etee futat. A'ere pẽẽ nepeapoa'uweri pejejemiapoe'ema Jarejuwarete 'ga rerowiar ywyapie'em ire— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","—A'eramũ je ako 'jau pẽ nupe jepi: Werowiar ire Janeruwarete 'ga mama'e monoi pẽ nupe, “mama'ea emut amũ oree”, ojeupe pẽẽ 'eramũ. “Amut 'ga jee” 'e rerowiar ire 'ga mama'e monoi pẽ nupe ojeupe pẽ'eawer imũ etee futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","—Jarejuwarete 'ga upe pejeporogytaramũ nipo pẽẽ pejejea'aramũ pejejeupe 'gã amũ mama'e tywera apoawer are. A'eramũ ki pẽẽ pejejeateeramũ jui. A'eramũ Janeruwarete 'ga pẽtywera moia pẽ nui— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A'eramũ 'gã awau owaẽma Jerusareg ipe nũ. Jarejuwarete 'ga mogytaawa pype 'gã ata 'gã nekoramũ, 'gã amũ 'ua oporogytau Jejui 'ga upe. Mainana 'wyriat, Moisesi 'ga remikwasiarer are moromu'jat, judeu 'gã 'wyria'ri. Mĩmera 'gã 'ua oporonupa ee Jejui 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—Awỹja rer imũ te erejot rakue? Awỹja pãjẽ mũ te mama'e ereapo? Awỹja te ene mut oree rakue?— 'jau 'gã 'ua oporonupa ee Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pe'je ajee pẽẽ na'ne imome'wau jee 'ũ. Tejeupe pẽẽ imome'u re je nanẽ tajemome'u pẽ nupe 'jau nũ— 'jau ete Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","—Awỹja je'eg imũ Juã Batista 'ga ruri ae pymĩãu 'y pe rakue 'ũ? Jarejuwarete 'ga je'eg imũ te 'ga ruri rakue? Kũima'e 'ga amũ je'eg imũ te ra'u nũ?— 'jau Jejui 'ga oporonupa ee 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A'eramũ 'gã 'jau ajaupe: —Ma'ja sa'e te jane 'ga upe? “Jarejuwarete 'ga je'eg imũ 'ga ruri” ojeupe jane 'eramũ te 'ga 'i janee nũ a'i kũi, “A'etea neperowiari 'ga”, 'ga 'i etee janee nũ a'i kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","—“Kũima'e 'ga je'eg imũ 'ga ruri”, jane 'eramũ nipo tekotee 'gã jane apisi ita pyu nũ a'i kũi— 'jau 'gã ajaupe. Okyje 'gã mytuna 'gã nui. “Juã 'ga Jarejuwarete 'ga je'ega mome'wara futat janee”, e'i 'gã jepi. A'eramũ 'gã okyjau 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","A'eramũ 'gã 'jau Jejui 'ga upe: —Norokwaawi ore Juã 'ga muarera 'ga nũ'ũ— 'jau 'gã 'ga upe. A'eramũ Jejui 'ga nanẽ 'jau 'gã nupe nũ: —A'eramũ je nanẽ temuarera 'ga mome'wawe'em pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe 'gã mu'jawamũ. —Kũima'e 'ga amũ y'wa 'ywa rakã otym oko pe, uwa 'jawa 'ywa rakã otym oko pe. Kwaiwete 'ga uwa rakã tyma. A'eramũ 'ga oko osõu. A'ere 'ga y'wa apikawa apou. A'ere 'ga 'og ywate apou iaarana 'ga upe. A'eramũ 'ga 'gã amũ monou oko raaranamũ imỹina ojeupe. A'eramũ 'ga 'jau “Y'waa mũ jema'ea futat. Emyreramũ te ajee pẽma'e futat pẽporowykyawera repya futat”, 'jau ijara 'ga 'gã nupe. A'ere 'ga awau watau 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Y'wa tyarama upe iwaẽmauwe ijara 'ga wemiayuwa 'ga amũ monou oma'ea uwa 'a piaramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","A'ere ko raarana 'gã 'ga pyygi ete 'ga nupãnupãu etee 'ga mojewya 'ga monou. Nan etee futat 'gã 'ga monou nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A'ere ko jara 'ga 'ga amũ monou nũ, oma'e piaramũ te 'ga 'ga monou numiamũ. A'eramũ ko raarana 'gã nãnẽwẽjẽmĩ 'ga rerekoi nũ. 'Ga pyygi etee 'ga akãnupãu 'ga rerekou nũ. A'erauwe 'ga ojewya awau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A'eramũ ko jara 'ga 'ga amũ monou nũ. A'ere ko raarana 'gã 'ga jukai etee. A'eramũ ko jara 'ga 'gã amũ monou nũ. A'ere ko raarana 'gã 'gã pyygi ete 'gã nerekou tyweaete. 'Gã amũ 'gã iapisau. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nitywi futari ko jara 'ga remimonorama. Wa'yra etee 'ga wereko. A'eramũ 'ga 'jau ojeupe: “Teja'yra 'ga pa je omono ipiaramũ kwy. 'Ga 'ã jeremifutararetea re'ã. A'etea je 'ga amono tey'wa piaramũ tejeupe”, 'jau 'ga ojeupe. “Jera'yra 'ga nipo 'gã opojeup re'ã. Jera'yra 'ga ree nipo 'gã pojyramũ re'ã”, 'jau nipo 'ga ojeupe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","—A'ere 'gã 'ga ra'yra 'ga resakawe 'jau ajaupe: “Wa'yra 'ga 'ga amut y'wa piaramũ ra'e. 'Ga futat 'uwa 'ga py'rau ko jaramũ 'uwa 'ga manũ re. A'eramũ jane 'ga jukau jui. A'eramũ janema'ea futat koa 'ga ruwa 'ga manũ re kũi”, 'jau nipo 'gã ajaupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","—A'eramũ 'gã 'ga pyyka 'ga jukau. 'Ga juka re 'ga reumera rerawau enuẽma ko awi inuga— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","A'eramũ Jejui 'ga 'jau mainana 'wyriara 'gã nupe: —Maran sipo ko jara 'ga wa'yra jukaarera 'gã nerekoi? 'Ga futat oo ko raarana 'gã apisau. A'ere nipo 'ga 'gã amũ monou 'gã py'rau oko raaranamũ nũ. Aipo 'gã te nipo y'wa mono ijara 'ga upe y'wa tyarũnamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","—Pẽnea'ar iki 'ga amũ remikwasiarer are. Ymã te 'ã Janeruwarete 'ga oje'ega kwasiarukari 'ga amũ upe rakue. “Mĩa ita nia'wyruui ra'e, 'jau nipo itaoga apoara 'gã ajaupe, ita monou imomoa ajaui. A'ere 'ga amũ aipoa ita eroyrũmyrera ita pyygi etee imonou imỹina tenawera pype 'oga ypywotypawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Janeruwarete 'ga imỹjukaa 'gã nupe rakue. A'eramũ 'ga remiapofera wesageayramũ futat oree”, 'jau 'ga ikwasiarukaa ka'aran are inuga rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'Ga je'ega renupawe mainana 'wyriara 'gã 'jau fariseu 'gã nupe: —Mama'e mũ mome'uramũ 'ga 'i janee poromũ— 'jau 'gã ajaupe. A'eramũ taetu amara'neramũ Jejui 'ga ree. Afueweramũ 'ga pyyg are. A'ere 'gã kyjeetei mytuna 'gã nui. —“Jejui 'ga te 'ã Jarejuwarete 'ga je'ega mome'wararetea ra'e”, 'jau 'gã ajemogyau ajaupe. A'eramũ nipo 'gã jane apisi ete. Jejui 'ga jane ipyygamũ nipo 'gã jane pyygi nanẽ nũ— 'jau 'gã ajaupe, okyjau Jejui 'ga rerowiaara 'gã nui. A'eramũ 'gã 'ga pyyke'ema. A'eramũ 'gã awau 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","A'eramũ judeu 'gã 'wyriana'nĩ 'gã 'jau ajaupe: —'Gã amũ simono imoporogytaukaa 'ga upe 'jau. Morogyta 'ga imome'u tyweramũ sipyyk 'ga 'jau— 'jau 'gã ajaupe. A'eramũ 'gã fariseu 'gã amũ imonou Erote 'ga remiayuwa 'gã netee Jejui 'ga upe imoporogytaukaa. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A'eramũ 'gã awau 'jau Jejui 'ga upe: —A'jea futat 'ã ereporogyta a'jeteetewi ra'e. Nereporogyta ekoetei te 'ã. A'jea futat te 'ã erejejuka pãwẽ pãwẽ ae ree. A'jea futat te 'ã ore mu'e ape mama'e are. Eneje'eg are 'gã amũ oporenuwiwere'emamũ agawewi. A'etea ene mama'e a'jea etee eremome'u— 'jau 'gã Jejui 'ga upe. —A'eramũ ene 'awamũ 'jau oree: Jane 'ã judeua. Simono te jane ka'aranũũa 'wyriararete 'ga upe, Sesa 'ga upe? Naani te ra'u nũ? Ma'ja e'i te Moisesi 'ga ee rakue? Najudeu arũi te 'ã 'wyriararete 'ga. Tapy'ỹi amuteea 'ga. Romanũa te 'ga. A'etea te jane simepy 'ga?— 'jau 'gã oporonupa 'me Jejui 'ga upe ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A'ere Jejui 'ga 'gã kwaawi ojee. “Jeje'ega renupa 'gã nuri numiamũ. ‘Siesak 'ga mama'e mũ mome'ua sigaty jarejee 'jau’, e'i te 'gã jee numiamũ”, 'jau Jejui 'ga ojeupe. A'eramũ 'ga 'jau 'gã nupe: —Nepeporonuwi tee pejejua ee jee. “Simosimot ekoete jarejaupe 'ga 'eawera 'jau”, pe'je te jee— 'jau Jejui 'ga 'gã nupe. —Ka'aranũũ ywope'ia pemut amũ jee ra'ne, Sesa 'ga mepyawa mũ jee ra'ne— 'jau ete Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","A'eramũ 'ga amũ imonou 'ga upe. —Kweramũ ajee 'wei— 'jau 'ga imonou 'ga po pe. A'eramũ Jejui 'ga ka'aranũũ ywope'i resaukaa 'gã nupe: —Awỹja ra'agawa te 'up ee 'ga rera retee?— 'jau 'ga esaukaa 'gã nupe. —'Wyriararete 'ga ma'ea futat— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","A'eramũ Jejui 'ga 'jau 'gã nupe: —'Ga ra'agawa rerekwara 'ga ma'ea futat. A'eramũ pẽẽ imonou 'ga upe etee futat. A'ere Jarejuwarete 'ga mama'ea pemono 'ga upe etee futat— 'jau Jejui 'ga 'gã nupe. A'e renupawe 'ga upe imome'uukarera 'gã oporesagamũ etee 'ga ree. —Kuu. I'akwaap 'ga ra'e nũ'ũ— 'jau 'gã ajaupe. A'eramũ 'gã awau 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ko'iko'i ete satuseu 'gã amũ 'ua oporogytau Jejui 'ga upe nũ. Aipo 'gã e'i ajaupe ra'e jepi: “Amanũ re ae noferawu'jawi nũ. Amanũmũ ae teepawamũ ywawuje futat”, 'jau agawewi satuseu 'gã ajaupe ra'e jepi. A'etea 'gã 'ut oporonupa ee Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","A'eramũ 'gã 'jau Jejui 'ga upe: —“Moromu'jara 'ga” 'jau 'gã enee jepi. A'eramũ ene ore mueapyou katu mama'e are. Ymã 'ã Moisesi 'ga ka'arana kwasiari inuga janee rakue. “Kũima'e 'ga amũ nipo amanũ wa'yre'emauwe. A'eramũ nipo 'ga manũ re 'ga rewirera 'ga 'ga remirekofera ẽẽ rerekou. A'eramũ nipo 'ga aja'yrapyau ẽẽ pype. A'eramũ nipo 'ga ra'yr ypy 'ga amanũ ma'efera 'ga ra'yrera 'jawe futat”, 'jau 'ã Moisesi 'ga ikwasiaa inuga rakue— 'jau 'gã Jejui 'ga upe. A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A'eramũ 'gã 'jau 'ga upe nũ: —A'ere nipo kũima'e 'ga amũ 'ga ra'yra sete. A'eramũ nipo u'ar ypy ma'efera 'ga kũjã mũ rerekou. A'ere nipo 'ga wa'yre'emauwe 'ga manũi jui. A'eramũ nipo 'ga amanũmũ ẽẽ wi ẽẽ rejaa ẽẽ mogou wewirerera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A'eramũ nipo 'ga manũ re 'ga rewirerera 'ga amũ ẽẽ rerekou 'ga py'rau nũ. A'ere nipo 'ga nanẽ 'ga manũi wa'yre'emauwe nũ, ẽẽ rejaa ete wewirerera 'gã nupe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","A'eramũ nipo 'gã ojopy'rapy'rau etee 'gã ẽẽ ree, ajamanũnamũ. A'ere nipo 'gã nata'yri'i futari ẽẽ pype. Ojee 'gã jemoypaw ire nipo ẽẽ nanẽ amanũmũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","A'eramũ nipo 'ga ae moferapawa 'ara rupi manamũ sipo ẽẽ menaretea? 'Gã juejue futat ẽẽ wereko kũi— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A'eramũ Jejui 'ga aipo ojeupe 'gã 'eramũ 'jau 'gã nupe: —Pẽ'me awi. Nanarũi. Nepẽneapyoi Jarejuwarete 'ga je'ega rerekwara ka'aran are ra'e. 'Ga pãjẽa nanẽ pẽẽ ikwaape'ema. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","'Au etee te 'gã nemirekoramũ kũi. A'ere 'gã oferaw ire naemirekou'jawi kũi. Ywagipewara 'gã 'jawe etee futat 'gã jemogyi. Niporerekoweru'jawi 'gã kũjã are. Kũjãmera 'gã nanẽ omenariwere'emamũ futat nũ, kũima'e 'gã 'jawe etee futat nũ kũi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","—Nepẽneapyoi nipo Jarejuwarete 'ga 'eawer are. Nepemogytai nipo Moisesi 'ga remikwasiarera, ae feraw are 'ga ka'arana kwasiaripyrera rai'i? Ka'a'i ikai are 'ga ka'arana kwasiari rakue. A'eramũ 'ga 'jau: “Ka'a'ia je upe imueny re Janeruwarete 'ga oje'ega jee ikue. ‘Je te 'ã Eneruwaretea. Enepytunera 'gã Nuwaretea 'jau. Abraão 'ga, Isaki 'ga, Jako 'ga. Mĩmera 'gã Nuwaretea je ako’, 'jau 'ga jee ikue”, 'jau Moisesi 'ga ikwasiaa inuga janee rakue— 'jau Jejui 'ga 'gã nupe. —“Ymã te je 'gã Nuwaretea ikue”, 'jawe'em Janeruwarete 'ga 'ga upe rakue. A'ere 'ga 'i: “Je te 'ã 'gã Nuwaretea ako”, 'jau 'ga rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","—Aipo 'gã amanũ futat rakue numiamũ, Moisesi 'ga tywe'emauwe futat rakue numiamũ. A'ere 'gã 'aga namanũi futari. A'eramũ Janeruwarete 'ga poromũ 'jau Moisesi 'ga upe rakue. 'Gã 'aga tywe'em ire amunipo 'ã 'ga aipo ne'ia'uweri Moisesi 'ga upe rakue. Ako ma'e 'gã nupe etee te 'ga Aeruwaretea— 'jau Jejui 'ga 'gã nupe u'ama imome'wau. —A'eramũ 'ã pẽẽ 'gã mu'jau tywet aipo are. “Noferawu'jawi aea amanũ re” 'e are pẽẽ 'gã mu'jau tyweaete— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moisesi 'ga remikwasiarer are moromu'jara 'ga amũ 'gã je'ega renupa. A'eramũ 'ga 'jau ojeupe: “A'jea futat 'ga 'i. Tamoporogytaukat 'ga mama'e are”, 'jau 'ga ojeupe etee futat. —Maranuara te ajee Janeruwarete 'ga 'eaweraretea?— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","A'eramũ Jejui 'ga 'jau 'ga upe: —'Awamũ futat 'ga 'eaweraretea. “Peapyaka jeje'eg are ki Israeu juapyreramũ. Je te 'ã pẽjararetea. Nitywi futari 'ga amũ je 'jawe pẽ nupe”,— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","—“Pẽporomutat je ree pejepytuna 'gã apyraapa”, e'i 'ã Janeruwarete 'ga pẽ nupe rakue. “Mama'ea peapo jee jeremifutar imũ. Pejejea'aramũ pejejemogyau je ree 'gã nee pejejea'ara apyraapa. Je upe mama'e apou pẽẽ iapou etee futat. Pejefuakara pyu pẽẽ mama'e apou je upe. Aipo aporamũ nipo pejeporomutaramũ je ree a'jea futat 'gã nee pejeporomutara apyraapa pejejemogyau”, e'i Janeruwarete 'ga pẽ nupe rakue— 'jau Jejui 'ga 'ga upe. —Poromũ te 'ga 'eaweraretea. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ajepeja 'ga 'eaweraretea nanẽ nũ. “Pẽporomutat pejepyriwara 'gã nee pejejee pejeporomutara 'jawe etee futat”, 'jau 'ga 'ã ikwasiarukaa Moisesi 'ga upe rakue. Amumera 'ga 'eawera nuapyraawi futari aipo 'ga 'eaweraretea— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'ga 'jau 'ga upe: —A'jea futat ere poromũ. Majepei tee futat te 'ã Janeruwarete 'ga. Nitywi futari 'ga amũ 'ga 'jawe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A'eramũ ki jane jareporomutaramũ 'ga ree jarepytuna 'gã jareporomutara apyraapa. A'eramũ jane a'jea futat jareporomutaramũ 'ga ree. 'Ga upe mama'e apou ki jane iapou 'ga remifutar imũ etee futat. 'Ga ree ki jane jarejea'aramũ jarejemogyau. 'Ga upe mama'e apou ki jane iapou a'jea futat. 'Ga remifutar imũ ki jane jarejepyriwara 'gã nerekou esage jarejereko esage 'jawe etee futat— 'jau 'ga 'ga upe. —Aipo 'ga 'eawera renuwa wesageramũ 'ga upe mama'e rapya apyraapa. 'Ga je'ega renuwa esage 'ga upe mama'e monoa apyraapa— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Aipo ojeupe 'ga 'eramũ Jejui 'ga 'jau ojeupe: “I'akwaap ma'e 'ga pa ra'e”, 'jau 'ga ojeupe etee futat 'ga resaka. A'eramũ Jejui 'ga 'jau 'ga upe: —Ererowyk Jarejuwarete 'ga ekou ra'e— 'jau 'ga 'ga upe. Aipo 'ga 'e renupawe mytuna 'gã ajemogymogyau etee futat. Ojenosõu 'ga wi. A'eramũ 'gã imome'waukaru'jape'ema 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jarejuwarete 'ga mogytaawa pype akou Jejui 'ga oporonupa ee 'gã nupe: —Ma'eramũ te Moisesi 'ga remikwasiarer are moromu'jara 'gã 'i pẽ nupe: “Janeruwarete 'ga remimurera 'ga Davi 'ga juapyrera”, 'jau 'gã pẽ mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A'ere Janeruwarete 'ga 'Agesagea ka'arana kwasiarukari ee Davi 'ga upe rakue: “Jeruwarete 'ga 'jau Jejararete 'ga upe rakue: ‘Eapyk 'au je pyri. Je 'jawe futat ene. Enepãjẽretea je 'jawe. A'eramũ ene eapyka je yse katy. Anure nipo je ene mogoi 'wyriaramũ 'gã nupe najuejue etee futat. Ene ree iporomutare'ema 'gã 'arimũ je ene magwawukari. A'eramũ ene je iapoe'emauwe eapyka 'au je yse katy’, 'jau 'ga Jarejararete 'ga upe”, 'jau Davi 'ga ikwasiaa rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","—Janeruwarete 'ga remimurera 'ga ree 'ga ka'arana kwasiari rakue. Ma'eramũ sipo ajee Davi 'ga 'i “Jejararete 'ga”, 'jau ajuapyrera 'ga upe nũ— 'jau Jejui 'ga 'gã nupe. Mytuna 'gã oporenuwiweramũ Jejui 'ga porogyta are. 'Ga remimome'ufera 'gã muekõẽãina. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A'eramũ 'ga 'jau 'gã nupe: —Pejea'gu ki Moisesi 'ga remikwasiarer are moromu'jara 'gã nui. 'Gã 'ã e'i ajemogyau ojeupe: “Je 'ã kũima'eeteetea”, 'jau 'gã 'ã ajemogyau ojeupe, waity fuku rerekou. A'eramũ 'gã ataramũ 'gã naitya ajasimana 'gã nee. “Tiporesagete 'gã je ree 'jau”, 'jau 'gã akou ojeupe. Wapeje'ega tãmẽjẽ 'gã ifutaa. 'Wyriara apykawa 'arimũ etee wapyka awau Jarejuwarete 'ga mogytaaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ojemi'waaw ipe nanẽ nũ 'wyriara renawa 'arimũ etee wapygiweramũ ojemi'waa. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kũjã men manũ ma'efera 'gã nupe nanẽ 'gã 'jau nũ: “Je tamaenun tekou enekaraemã are 'jau”, 'jau futatee 'gã 'gã nupe. “Je te nipo ako esage temaenuna enekaraemã are”, 'jau futatee 'gã 'gã nupe. A'ere 'ga etee 'gã karaemã pyygi ojeupe, ka'aranũũa nanẽ nũ. A'eramũ 'gã 'jau ojeupe etee futat: “Kwakwai'i teje'ega monoi Jarejuwarete 'ga upe. Kasi a'e pe 'gã je kwaawi mama'e tywera je iaporamũ ne kwy”, 'jau 'gã ojeupe etee futat. A'eramũ nipo 'gã oje'ega monou fuku o'meramũ akou Jarejuwarete 'ga upe, wemiapo tywera mimawamũ. A'ere nipo anure Janeruwarete 'ga 'gã nereko tyweri 'gã nemiapo tyweawer are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jarejuwarete 'ga mogytaawa pype Jejui 'ga wapyka 'ũina Jarejuwarete 'ga upe ka'aranũũ ryrũ pyri. A'eramũ 'ga ose ma'e 'gã nesaka 'ũina, yrũ pype 'gã nemimonoa nanẽ 'ga esaka nũ. Ika'aranũũ kwai ma'e 'gã ka'aranũũ monou Jarejuwarete 'ga ma'e yrũ pype 'ga upe kwaiwete. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","'Gã nesepaw ire majawera ẽẽ mũ 'ua osou 'og ipe. Nika'arani ẽẽ akou. Itywerete ẽẽ akou. A'etea ẽẽ oka'aranũũ ywope'i omono ipype. Mukũi'ĩ etee ẽẽ imonou ipype. Naepyi agawewi ẽẽ remimonofera. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ẽẽ resakawe Jejui 'ga 'jau wemimu'e 'gã nupe: —Kweramũ kũjãa ẽẽ imen manũ ma'efera ẽẽ. Nitywa'uweri agawewi ẽẽ mama'ea. A'etea ẽẽ oka'aranũũ monoupap futat yrũ pype. A'eramũ ẽẽ otywe'emamũ futat mama'ea ojeupe imuawamũ. Ẽẽ remimonofera ika'aranũũ kwai ma'e 'gã ma'e wapyraap futat Janeruwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","'Gã kwaiwete agawewi omono 'ga upe. A'etea 'gã kwaiwete wẽjẽmĩ wereko ojeupe nũ. A'ere ẽẽ ma'ea nitywi futari. Omonopap futat ẽẽ 'ga upe. Naemyreri futari ẽẽ upe. Wemi'urama muawa we futat ẽẽ omonopap 'ga upe— 'jau Jejui 'ga ẽẽ mome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jarejuwarete 'ga mogytaaw awi ũ'ẽ re Jejui 'ga remimu'e 'ga amũ 'jau 'ga upe: —Kuu. Ikaturam te Janeruwarete 'ga mogytaawa 'oga jã'nũ'ũ. Sã'ã itauu esagea epy ete ma'ea. Mytuna 'gã ka'aranũũa rerua kwaiwete Jarejuwarete 'ga mogytaawa 'oga muesageawamũ— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat esageramũ numiamũ. A'ere nipo anurenure'i jane ree iporomutare'ema 'gã nuri imonou etyka. Nomỹi'i futari nipo 'gã itaa mũ aju'arimũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Anure Jejui 'ga wapyka 'ũina ywytyr apyte'rarimũ, Oriweira 'jawa apyte'rarimũ wemimu'e 'gã netee. Jarejuwarete 'ga mogytaaw are 'gã amã'jãu 'upa. Poje Pedro 'ga, Tiago 'ga, Juã 'ga, Andre 'ga, mĩmera 'gã oporonupa 'ga 'eawer are 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Maranime sipo aipo 'gã Jarejuwarete 'ga mogytaawa monoi etyka? Ma'ja ra'ne sipo ajee ojesaukat oree iapo enune?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aipo 'eramũ Jejui 'ga 'jau 'gã nupe: —Je renune 'ut ma'e 'gã nipo i'me ma'ea. Perowiat kasi 'gã 'mea ne. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anure nipo kwaiwete 'gã nuri “Janeruwarete 'ga je mut pẽ katu'okaramũ. Je Janeruwarete 'ga remimurera ako”, 'jau futatee nipo 'gã 'ua pẽ nupe. A'ere kasi perowiat 'gã ne. O'meramũ te nipo 'gã 'i. Kwaiwete nipo 'gã 'gã moryteeu ojee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","—Anure nipo amutee amunaw awi 'gã nuri 'wyriararete rowajaa, 'ga remiayuwa reewe futat. A'ere kasi aipo renupa pẽpiryyi ne. Nan futat nipo mama'e teepaw enune. A'ere nipo naporomũ rũi mama'e mateepaawa. Naporomũ etee rũi futat nipo mama'ea rekoi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","—Akou'jau'jap futat nipo mama'ea. Amunap tesirũmera pypewara 'gã we futat nipo ajuowajat. Ywya we futat nipo oyyi peu peu peu 'jau. Ty'ara nipo amunawa pype peu peu 'jau. A'eramũ 'gã nipo kwaiwete ty'ara rerekou. Sã'ã kũjã wa'yra ray ypyrauwe wa'yra 'a ja'wyja'wy kwaawa. Ayypeyperauwe 'ã ẽẽ i'ara kwaapa. Ẽẽ wi u'aa ja'wyja'wy taetu 'ã wayreteramũ ẽẽ upe. Nan tee futat nipo pẽẽ. Aipo ijeapo resakawe ki je rura pekwaap. “Owaẽm 'ga ruawa upe ra'e”, 'jau nipo pẽẽ pejejaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Pejea'gu ki 'gã nui. Je rura'ne'emauwe nipo 'gã je rerowiaaramũ pẽ nereko tyweretei. Pẽẽ mũ nipo 'gã ipyyka imopimopika ae mopikawa pyu. Judeu 'gã jatykaawa pype miamũ nipo 'gã pẽ mopimopigi. Amumeramũ je ree nipo 'gã pẽ nerawau 'wyriara upe. A'eramũ pẽẽ 'wyriararete upe pejejerooramũ pẽẽ je mome'wau 'gã nupe. “Jejui 'ga iporokatu'ogiwet pẽ nee”, 'jau ki pẽẽ 'wyriara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Teepaw enune nipo 'gã je mome'ui amunawa moymoyka. Tesirũmera 'gã jeje'ega renuw ire te nipo mama'e ateepawamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","—Pẽ pyygamũ, 'wyriara 'gã nowase pejejerooramũ kasi pẽpy'a'wyt ne. “Ma'ja 'jau sipo je teje'ega 'gã nupe 'wei?” pe'je kasi ne. Janeruwarete 'ga te peje'egawa amut pẽ nupe peu pẽ nerooramũ. A'eramũ pẽẽ 'ga 'ea etee imome'wau 'gã nupe. Napejejea'ar imũ rũi pẽẽ peje'eg 'gã nupe. Pejejeupe Jarejuwarete 'ga 'Agesage 'eawera etee pẽẽ imome'wau 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","—Kwaiwete nipo je rerowiare'ema 'gã weki'yra 'gã, wewirera 'gã we 'gã monou ia'wyre'ema 'gã nupe 'gã apisaukaa. 'Ga ruwa 'gã miamũ wa'yra 'gã monou 'gã nupe 'gã apisaukaa. 'Ga ra'yra 'gã nanẽ ujara 'gã imonou 'gã nupe 'gã apisaukaa. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Je rerowiare'ema 'gã nipo oporomutare'emamũ je rerowiaramũ pẽ nee. A'ere Janeruwarete 'ga je rerowiar awi ipoire'ema 'gã nerooi imogyau ojepyri nakwaparimũ ete rũi futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Ymã te Janeruwarete 'ga ijeaporama kwasiarukari oje'ega mome'wara 'ga upe rakue, Danieu 'ga upe rakue. “Anure nipo 'ga amũ mama'e tywerete apoi Jarejuwarete 'ga mogytaaw ipe”, 'jau 'ga ikwasiaa inuga janee rakue. A'eramũ nipo 'ga amũ anure iapou Danieu 'ga 'eawer imũ etee futat. (A'eramũ je 'ga remikwasiarera ka'arana mogytaaramũ ee pẽneapyo futaa)— 'jau Jejui 'ga 'gã nupe. —A'eramũ pẽẽ Judeja ywy pewara ako ma'eramũ 'gã nesakawe pejejeaiteramũ pejewau pejeka'jama ywytyr ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","'Opewuu apyte'rarimũ ako ma'eramũ pẽẽ pejewawe'em pejesowe'em pejekaraemã pyyke'ema. Pejeka'jamayayau etee futat pejewau. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ko pewaramũ nanẽ pẽẽ pejejewyre'ema pejejog ipe pejejaity mojopy'rawe'em— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","—Kũjãmera 'gã nipo ta'yryrũ ma'e 'gã iporiay'i ajemogyau. Ta'yky'ri ma'ea nanẽ nipo nũ. Nujãnarũi eweguu ma'ea. Ta'yky'ri ma'e nanẽ nujãnarũi nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","A'eramũ ki nanuar are pejeporogytau Jarejuwarete 'ga upe ee: “Eremurukat kasi 'gã 'ara ro'ysaga rupi oree ne”, 'jau ki pẽẽ Jarejuwarete 'ga upe ee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","—Aipoa kwara rupi 'gã 'gã nerekou tyweaete. Ywy apo ypyramũ nitywi futari ae rereko tywera aipo 'jawe rakue. Anure nanẽ nipo nitywi futari ae rereko tywera 'jawe nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","—A'ere Janeruwarete 'ga mama'e tywera 'gã nupe iapoukaru'jau'jaw ire 'gã muojeri 'gã mogyau jui nũ. Kasi a'e pe ywy pewaramũ juejue 'gã papawi ne. A'ere Janeruwarete 'ga pẽẽ mũ mũ'jãu 'gã nui pẽ katu'oka. A'eramũ 'ga wemimũ'ẽmeramũ pẽ nee Janeruwarete 'ga 'gã muojeri 'gã mogyau jui nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—“Koromũ Kristu 'ga”, pejejeupe 'gã amũ 'eramũ kasi perowiat 'gã ne. “Kwe pe 'ga oi”, 'gã 'eramũ pẽẽ 'gã nerowiare'ema pejejemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jejewyt ja'wyja'wyramũ nipo kwaiwete 'gã nuri o'meramũ pẽ nupe. “Je Jarejuwarete 'ga je'ega mome'waramũ”, 'jau futatee nipo 'gã pẽ nupe. Amumera 'gã nipo 'ua 'jau pẽ nupe: “Janeruwarete 'ga je mut. Je 'ga remimureraretea futat”, 'jau futatee nipo 'gã pẽ nupe. Pẽnemiapoe'ema miamũ nipo 'gã iapou pẽ neape je rerowiar awi pẽ momoirukaawamũ. “Simomoirukat Ku'jywa 'ga remimũ'ẽmera 'gã 'ga rerowiar awi 'jau”, e'i te nipo 'gã pẽ nupe numiamũ. A'eramũ nipo 'gã mama'e apou pẽ neape. Ojerowiarukaawamũ te nipo 'gã iapoi pẽ nupe numiamũ. A'ere kasi a'e are miamũ perowiat 'gã ne. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Perowiar iki aipoa je'eawera. Ijeapoe'emauwe je imome'ui pẽ nupe, ee pẽ mueapyoawamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Pẽ nereko tyweawa kwaw ire nipo ywag awi nanẽ mama'e jesaukari pẽ nupe nũ. Kwara nipo owepa. Jaya nanẽ nipo owepa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jaytataa nipo ototoka ywag awi 'ua. Ywag ipewara nipo oyyita nũ. Kwat, jay, jaytata. Mĩmera nipo oyyita— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","—A'ere nipo pẽneki'yramũ je tejua tejewya ywasiga rupi. Tepãjẽ mũ nipo je ruri, tejenyfuga pype futat tejua nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A'eramũ nipo je tejeupe oporowyky ma'e ywagipewara 'gã monou tejemiayuwa 'gã majatykaukaa. “Pe'je pejewau amunawa moymoyka jeremiayuwa 'gã majatykau 'gã nerua jee”, 'jau nipo je 'gã nupe. A'eramũ nipo 'gã awau 'gã nerua jee— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Anure Jejui 'ga mama'e mũ mome'wau 'gã nupe, 'gã mu'jau ee: —Mama'ea je amome'u pẽ nupe pẽ mu'jau tejuawa 'ar are— 'jau 'ga 'gã nupe. —Sã'ã ae siaka'gywa potyramũ amana jewyra kwaawa. Ipotyrauwe 'ã ae amana jewyra kwaapa. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nan tee futat ki je'eawer imũ mama'e jeaporamuerauwe pe'je pejejaupe: “'Ut ja'wyja'wy Jejui 'ga janee 'wyriaramũ akou”, pe'je ki pejejaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A'jea futat je 'i. Je'eawer imũ mama'e jeapo resakara 'gã papawe'emauwe nipo tejua tejewya nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ywaga nipo ateepawamũ futat. Ywya nanẽ nipo ateepawamũ futat nũ. A'ere nipo jeremimome'ufera nateepawa'uweri futari. Je'eawer imũ etee futat nipo aipoa ojeapou— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","A'ere Jejui 'ga 'jau 'gã nupe nũ: —Nitywi futari je ruawa kwaapara 'gã amũ. Nepekwaawi futari je ruawa. Ywagipewara 'gã miamũ ikwaape'ema. Je miamũ nanẽ nakwaawi tejuawa 'ara. Jeruwarete 'ga etee te okwaap. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A'eramũ ki pẽẽ je rapesaka pejejemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sã'ã kũima'e 'ga amũ ooa iataa muku oje'wyr awi. A'eramũ 'ã 'ga oo enunewe 'jau wemiayuwa 'gã nupe: “Aata je tewau. A'eramũ pẽẽ pejeporowykyau je'eawer imũ etee futat”, 'jau 'ga 'gã nupe. 'Oga raarana 'ga upe 'ga 'jau: “Earũ jeroga ra'ne muku je rekoramũ. Je rura nanẽ ene apesaka nũ”, 'jau 'ga 'ga upe. A'eramũ 'ga awau watau muku oje'wyr awi. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nan tee futat pẽẽ je rura rapesakaramũ pejejemogyau. Nepekwaawi je ruawa. A'eramũ ki pẽẽ pejeporowykyau pejejeupe je'eawer imũ, je rura rapesaka pejejemogyau. Meewei 'ur ire ako re nipo wata ma'e 'ga 'ua ypyaje owaẽma. Maranamũ kwara ajerewamũ, maranamũ ai'iwe. Nokwaawi 'gã 'ga ruawa. ");
INSERT INTO kyzNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A'eramũ nipo 'oga jara 'ga 'ua erujewi ojeupe oporowyky ma'e 'gã nupe. Opak sipo 'gã ajemogyau 'ga rapesaka? ");
INSERT INTO kyzNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aipo are je 'i pẽ nupe: Je rura ki peapesak pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Egitu ywy awi judeu ypyfera 'gã nenũ'ẽawer are wea'awa maraka upe iwaẽm ja'wyja'wyrauwe mainana 'wyriara 'gã ajatykau Moisesi 'ga remikwasiarer are moromu'jara 'gã nee. —Maran te jane Jejui 'ga pyygi 'ga jukau?— 'jau 'gã ajaupe. —Jemime sipyyk 'ga 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jerusareg ipewara 'gã iporomutat 'ga ree. A'eramũ jane 'gã nowase jarekowe'em 'ga ree maraka apoaw ipe. Kasi a'e pe jane 'ga remiayuwa 'gã mamara'nei ne— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Petani pe Jejui 'ga akou, Simão 'ga rog ipe, ipito'om ma'efera 'ga 'wyr ipe. 'Gã jemi'waa 'gã nuwamũ kũjã ẽẽ mũ 'ua ojany kasiga ryrũ rerua opo pe. Itasiga apopyrera aipo yrũnamũ, aripasi 'jawa apopyrera poromũ. A'eramũ ẽẽ yrũ mopena, jany kasiga reko'woka Jejui 'ga akag are. “Naritu” 'jau 'gã aipoa jany kasiga upe. Epy ete aipoa jany kasiga. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","A'eramũ wapyk ma'e 'gã amũ amara'neramũ jany kasiga ẽẽ eko'wog are. —Ma'eramũ sipo ẽẽ imomy ekoetei 'wei? ");
INSERT INTO kyzNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Epy te 'ã 'aga jany kasiga a'i kũi— 'jau 'gã ajaupe. —A'eramũ amunipo 'ã ẽẽ ime'ega ka'aranũũ are janee. Tresẽtu ka'aranũũa 'ut ee. A'eramũ amunipo 'ã ẽẽ epyfera mua janee. A'eramũ amunipo 'ã jane imojo'oka ikaraemãe'ema 'gã nupe 'jau kũi— 'jau 'gã ajaupe, kũjã ẽẽ ago'wau. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A'eramũ Jejui 'ga 'jau 'gã nupe: —Tene ẽẽ iapoi. Ma'eramũ pejemara'neramũ ẽẽ ree 'ũ? Mama'e esagea te ẽẽ wapo jee. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ikaraemãe'ema 'gã nooa'uweri futari pẽ nui. A'eramũ pẽẽ anure mama'e monou 'gã nupe pejejemifutar imũ. A'ere je te ajee nako fukui pẽ pype. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Je tymaw ipe je ree eko'wogipyrama futat jany kasiga numiamũ. A'ere ẽẽ 'awauwe eko'wogi je ree, je manũe'emauwe. Tene ẽẽ iapoi jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","—A'jea futat je 'i. Anure nipo 'gã je mome'ui kwe pewara 'gã nupe. Amunap tesirũmera moyka nipo 'gã awau je mome'wau kwe pewara 'gã nupe. Je mome'uramũ nipo 'gã ẽẽ remiapofera nanẽ imome'wau 'gã nupe nũ. A'eramũ nipo 'gã anure najuejue etee futat wea'aramũ ẽẽ remiapofer are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","A'ere Jejui 'ga remimu'e 'ga amũ awau oporogytau mainana 'wyriara 'gã nupe. Judas Iskariote 'ga futat poromũ oo oporogytau 'gã nupe: —Jejui 'ga je apyygukat pẽ nupe. Je apoat pẽẽ 'ga pyyka pẽ pyri— 'jau Judas Iskariote 'ga awau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ojeupe 'ga 'eramũ mainana 'wyriara 'gã aku'iramũ 'ga ree. A'eramũ 'gã 'jau 'ga upe: —Ka'aranũũa nipo ore oromono ene upe 'ga pyyga repyramũ— 'jau 'gã 'ga upe. A'eramũ Judas 'ga wea'aramũ akou ee. “Ojetee 'ga rekoramũ tomono 'ga 'gã nupe 'jau kwy”, 'jau 'ga ojeupe. A'eramũ 'ga Jejui 'ga rerekou weape. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Awau owaẽma mani'oko'o jopype'ema 'wawa upe, Pasikwa 'jawa apoawa upe. Karupa'mĩ jukaawa 'ara upe 'gã owaẽma. A'eramũ 'ga remimu'e 'gã amũ 'jau Jejui 'ga upe: —Ma'ape te jane jemi'wari, karupa'mĩ ro'o reyri jarejee?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A'eramũ Jejui 'ga mukũja 'gã monou amunawarete pe. —Pe'je pejewau Jerusareg ipe. Peu nipo 'y ryrũ rerekwara 'ga peekoat. A'eramũ pẽẽ pejewau 'ga rewiri. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'Og ipe 'ga seramũ pejeporogytau 'oga jara 'ga upe: —Jarejara 'ga ore mut imome'waukaa enee: “‘Ma'ape te je karupa'mĩ eyra 'ui tejemimu'e 'gã netee?’ e'i 'ga. ‘Ma'ape te ore kumi apoi? Ma'ape te je tejemimu'e 'gã nerojemi'wari’ e'i 'ga enee kũi”, pe'je ki 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","—Aipo ojeupe pẽẽ 'e re 'ga tepẽ neroo ywatewara imy'jawa pype 'jau. Ityp futat aejemi'waawa peu. Ae renawa nanẽ otywamũ futat nũ. A'eramũ pẽẽ pejejeupe 'ga esaukar ire peu futat iapou ewara reewe jarejeupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","A'eramũ mukũja 'gã awau amunawarete pe. A'eramũ 'gã mama'e resaka ojeupe Jejui 'ga 'eawer imũ etee futat. A'eramũ 'gã kumi apou maraka are. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kaaruwamũ Jejui 'ga awau ojemi'waa wemimu'e 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ojemi'waaw ipe Jejui 'ga 'jau 'gã nupe: —A'jea futat je 'i. A'jea futat nipo pẽẽ mũ je mono pejepe je ree iporomutare'ema 'gã nupe je jukaukaa— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aipo renupawe 'ga remimu'e 'gã u'arasigamũ ojeupe 'ga 'eawer are. A'eramũ 'gã oporonupa majepeinume ee 'ga upe: —Je upe te ere poromũ?— 'jau 'gã 'ga upe. Majepeinumenume 'gã oporonupa ee 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A'eramũ Jejui 'ga 'jau 'gã nupe: —Je pyri ojemi'wat ma'eramũ futat pẽẽ mũ nipo je monoi 'gã nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","—Ymã te Janeruwarete 'ga ka'arana kwasiarukari 'gã amũ nupe rakue, jemanũ are rakue. Pẽneki'yra agawewi je 'ã. A'etea je ree iporomutare'ema 'gã je jukaukat 'gã nemikwasiarer imũ etee futat. A'ere 'gã nupe je monoara 'ga tywereteramũ te akou. Iporiay'i 'gã po pe je monoara 'ga numiamũ. A'ere nipo Janeruwarete 'ga 'ga rereko tyweretei. Ma'eramũ gatu nipo 'ã 'ga jeuwi rakue 'ja— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ojemi'waaw ipe Jejui 'ga mani'oko'o'i pyyka. A'ere 'ga eramã'jãu ywau eroje'ega 'Uwarete 'ga upe: —Au'jete mani'oko'o'ia eremut oree, Kiapi'ni— 'jau Jejui 'ga 'ga upe. A'ere 'ga mani'oko'o'i mowoka imonou 'gã nupe. —Mani'oko'o'ia pepyyk i'wau. Koromũ jero'oa— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A'ere 'ga y'way ryrũ pyyka nũ, eramã'jãu ywau nũ. A'eramũ futat 'ga oje'ega monou 'Uwarete 'ga upe nũ: —Au'jete y'waya eremut oree, Kiapi'ni— 'jau Jejui 'ga 'ga upe. A'ere 'ga imonou 'gã nupe. A'erauwe 'gã itykua pãwẽ pãwẽ. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A'eramũ Jejui 'ga 'jau 'gã nupe: —Koa y'waya jerya futat. A'ere'ere'i nipo 'gã amũ jejukai jery reko'woka. Aipoa jery jeko'woga pẽtywera omepy. Jemanũ are tee Jeruwarete 'ga pẽ katu'ogi kwaiwete. 'Awamũ karupa'mĩa nepejukau'jawi pejetywera mepyawamũ. Poromũ futat 'ga je'eg ymanera numiamũ. A'ere 'awamũ 'ga je'eg yauramũ. 'Awamũ jery tee pẽ pirei pẽtywer awi. Jemanũ are tee Jeruwarete 'ga pẽtywera moiri pẽ nui je rerowiaramũ. Poromũ futat Janeruwarete 'ga je'eg yaua 'awamũ. A'ea 'ga je'ega nomojopy'ruawi futari 'awamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","—A'jea futat je 'i. Je natykuru'jawi futari 'aga y'waya pẽ pyri. Anure tãmẽjẽ te nipo je itykuri pẽ pyri, Tejuwarete 'ga pyri pẽ neroo re tãmẽjẽ nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Oporogytapaw ire 'gã amaraka'aga Jarejuwarete 'ga muorypawamũ. Amaraka'ag ire 'gã awau ywytyr ipe, Oriweira 'jaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Awaw ipe Jejui 'ga 'jau wemimu'e 'gã nupe: —'Awamũ futat nipo pekwasi'o je wi je rejaa je mu'ama ojetee'i— 'jau 'ga 'gã nupe. —Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari 'ga amũ upe ee rakue: “Tajuka karupa'mĩ are omaenun ma'e 'ga 'jau kwy. A'eramũ 'ga reymawera 'gã awau okwasi'wau kwe pe 'jau kwy”, 'jau Janeruwarete 'ga ikwasiarukaa inuga ka'aran are rakue. A'eferupi tee futat nipo pekwasi'o pejewau je wi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","—A'ere je temanũ re je ferawi nũ. Teferaw ire nipo je oi Garireja ywy pe pẽ nenune— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A'eramũ Pedro 'ga 'jau 'ga upe: —'Me te pa 'ga poromũ 'jau nũ. Je naejara'uweri futari ene imogou ojetee'i kũi. 'Gã te nipo opyamũ ene wi ene rejaa ojetee'i kũi. A'ere je naejara'uweri ene kũi— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—A'jea futat sipo ere— 'jau Jejui 'ga 'ga upe. —Je te a'jea futat a'e enee nũ'ũ: 'Awa ypytuna rupi nipo je kwakuw ape muapyapyt katu 'gã nupe. “Nakwaawi je 'ga”, 'jau nipo ene mukũi wyrasokwẽ je'egauwe— 'jau 'ga Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","A'ere Pedro 'ga fuakaramũ 'ga upe: —Naani futari nũ'ũ. Aipo na'ea'uweri futari je. “Nakwaawi je 'ga”, na'ea'uweri je. “Tene 'gã je jukai futari 'ga reewe futat”, a'e ete nipo je. Nakwakuwa'uweri futari je ene— 'jau Pedro 'ga Jejui 'ga upe. 'Ga remimu'e 'gã nanẽ Pedro 'ga 'eawer imũ etee futat 'jau 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jejui 'ga awau owaẽma Getsemani 'jaw ipe, wemimu'e 'gã netee. A'ere Jejui 'ga 'jau 'gã nupe: —'Au ete pejup ra'ne. Iruupeu'i je oi teporogytau Tejuwarete 'ga upe ra'ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A'eramũ 'ga muapyra 'gã etee erawau ojeupi. Pedro 'ga, Tiago 'ga, Juã 'ga. Mĩmera 'gã 'ga erawau ojeupi. 'Ga 'arasiga 'ga mopy'aywyrafenayau 'ga mogou. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A'eramũ 'ga 'jau 'gã nupe: —Je'arasiga nipo 'ã je juka. Peser awi etee. Peporogyta Jarejuwarete 'ga upe je pyri— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","A'eramũ 'ga ojepe'au'i 'gã nui. Awau peu'i wenupy'ãu wapyka weakwara rerawau enũina ywy are futat erujaa oporogytau 'Uwarete 'ga upe: —Kiapi'ni. 'Wyria'ri 'gã imara'ne je ree. 'Gã nipo 'ã je rereko tywerete 'ja. Ojeupe ene iapoukare'em ire amunipo 'ã 'gã nuapoa'uweri nanuara je ree. A'ere 'ã najeremifutar imũ rũi te ereapoukat. Ejemifutar imũ etee te 'ã ereapoukat 'gã nupe jee— 'jau 'ga 'Uwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Oporogytapaw ire 'ga afu'ama awau ojewya muapyra 'gã nupe nũ. Osea 'gã 'upa. A'eramũ 'ga 'jau Pedro 'ga upe: —Ereset te ejupa? Eje'ega te neremonoi'i Jarejuwarete 'ga upe je pyri? A'e'ja'wiramũ miamũ sipo nereporogytai Jarejuwarete 'ga upe?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","—Peser awi. Peporogyta Jarejuwarete 'ga upe. A'eramũ pẽẽ pejefuakaramũ mama'e tywera apowe'em. Kasi a'e pe nepẽfuakari ne. A'eramũ pẽẽ mama'e tywera etee iapou 'ga upe ne. Nepẽparuapoweri agawewi nipo mama'e tywer are. A'etea nipo peapo pejeporogytawe'em 'ga upe 'eramũ mama'e tywera etee futat peapo pejekou— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aipo 'ga upe 'e re Jejui 'ga awau 'gã nui nũ oje'ega monou 'Uwarete 'ga upe nũ. 'Ga upe u'eawera 'ga 'jau'japa. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A'ere 'ga awau ojewya wemimu'e 'gã nupe nũ. Nãnẽwẽjẽmĩ nũ. Osea 'gã 'upa. Wopeypeyjamũ etee 'gã ajemogyau. A'eramũ 'gã osea 'upa. Opag ire 'gã oporesagamũ etee 'ga ree. Ojenosõu 'gã 'ga wi. A'eramũ 'gã 'jawe'em 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A'eramũ Jejui 'ga awau oporogytau'japa 'Uwarete 'ga upe nũ. 'Uwarete 'ga upe oporogyta re 'ga 'ua nũ. Nãnẽwẽjẽmĩ nũ, 'gã set 'gã nuwamũ nũ. A'eramũ 'ga 'jau 'gã nupe: —Peser ete futat nipo pejejupa nũ ki sa?— 'jau Jejui 'ga 'gã nupe. —Au'je pejeser ire. 'Awamũ futat 'gã pẽneki'yramũ je monoi ae a'wyre'ema 'gã po pe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pe'je iruukwe soo 'gã nekoaa 'jau. Kweramũ ae a'wyre'ema 'gã po pe je monoara 'ga ruri— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jejui 'ga porogytapawe'emauwe Judas Iskariote 'ga, Jejui 'ga remimu'efera 'ga futat, kwaiwete 'gã nerua erojemorypa Jejui 'ga ree. Mainana 'wyriara 'gã kwaiwete 'gã muri Judas 'ga rupi. Judeu 'gã 'wyria'ri 'gã nanẽ kwaiwete 'gã mua 'ga rupi. Jyuua 'gã erua muap. Mĩmera 'gã erua erojemorypa 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mainana 'wyriara 'gã nupe oporogytaaw ipe Judas 'ga 'jau 'gã nupe rai'i: “Oo nipo je Jejui 'ga retywape pytea pẽ neape. A'eramũ pẽẽ a'e are 'ga kwaapa 'ga retywape pyteramũ. A'erauwe futar iki pẽẽ pejewau 'ga pyyka 'ga rerawau”, 'jau Jejui 'ga monoara 'ga 'gã nupe rai'i. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A'eramũ 'ga owaẽma ypy we awau Jejui 'ga rerowyka 'jau 'ga upe: —'Au te ereko, ki Ku'jyp?— 'jau 'ga 'ga upe. A'eramũ futat 'ga 'ga retywape pytea. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","A'erauwe Judas 'ga remireroofera 'gã 'ua Jejui 'ga pyyka 'ga pofaa. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A'ere Jejui 'ga remimu'efera 'ga amũ ojyuu rekyita kũima'e 'ga amũ ree, 'ga namĩ monoka. Furuk. Mainana 'wyriararete 'ga remiayuwa 'ga namĩ yypa. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A'ere Jejui 'ga 'jau opyykara 'gã nupe: —Ma'eramũ pẽẽ ma'eramũ pejejua muawa pyu je nupãu ekoete 'ũ, muna'ywa 'jawe 'ũ? Ma'eramũ pẽẽ muawa we erua jyuu reewe jepiara rupi 'ũ? ");
INSERT INTO kyzNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pejejepype je rekoramũ miamũ ako naje pyygi pejepe ai'i. Jarejuwarete 'ga mogytaaw ipe ako je oi ai'iwe, ai'iwe 'jau ai'i. Peu futat ako je reni 'gã mu'jau Jarejuwarete 'ga ree ai'i. A'ete ako naje pyygi pejepe ai'i. A'ere jemanũawa upe iwaẽmi. A'eramũ Jeruwarete 'ga je pyygukaa rẽwẽjẽmĩ pẽ nupe. Ymã te Janeruwarete 'ga ka'arana kwasiarukari jemanũ are ikue. A'eramũ 'ã pẽẽ iapou 'ga remikwasiarera 'eawer imũ etee futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","A'e renupawe Jejui 'ga remimu'e 'gã okwasi'wau 'ga wi, 'ga rejaa, oka'jama 'gã nui. Okyjau 'gã opyyg awi. A'eramũ 'gã oka'jama 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kunumĩũũ 'ga amũ 'ua Jejui 'ga rewiri. Taity fuku pyu etee 'ga ojeuwana akou. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","'Ga amũ 'ga pyyka numiamũ. A'ere 'ga raity etee ipyygi. Waity pyygamũ 'ga opoia etee jui. A'eramũ 'ga awau ujãna taitye'eme. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","A'ere Jejui 'ga pyykara 'gã 'ga rerawau mainana 'wyriararete 'ga rog ipe, Kaifasi 'ga rog ipe. Peu futat judeu 'gã 'wyria'ri 'gã ajatykau mainana 'wyriara 'gã nee. Moisesi 'ga remikwasiarer are moromu'jara 'gã nanẽ ajatykau 'gã nee nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro 'ga awau 'gã newiri. A'ere 'ga nuerowygi Jejui 'ga. Mukuu etee futat 'ga akou 'ga wi. Awau 'ga owaẽma mainana 'wyriararete 'ga roga upe. A'ere Pedro 'ga nooi osou. Ukupepe etee futat 'ga awau akou 'oga osoma pype ojepe'jau mainana 'ga remiayuwa 'gã pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ojeupe 'gã Jejui 'ga reruramũ mainana 'wyriara 'gã oje'ẽma'e 'gã netee 'ga remiapo tywera mome'waramũ rekaa. —Awỹja te 'ga remiapo tywera wesak rai'i? Ma'ja ajee 'ga wapo ajukaawamũ rai'i?— 'jau 'gã ajaupe. A'ere nitywi 'ga amũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kwaiwete 'gã 'ua o'meramũ Jejui 'ga ree. A'ere 'gã naju'jaju'jawe rũi imome'ui 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Poje 'gã amũ 'ua o'meramũ 'gã nupe: —Ore aruenup 'ga je'ega ai'i. “Anure nipo je Jarejuwarete 'ga mogytaawa retygi. 'Awa 'ga mogytaawa kũima'e 'gã nemiapofera tee. A'ere nipo je imuapyra 'ara rupi ajepeja 'ga mogytaawa mowya nũ. Aipo 'ga mogytaawa nakũima'e 'gã nemiapofera rũi”, 'jau 'ga oreremianuwamũ ai'i— 'jau 'gã imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","A'ere aipo 'gã nanẽ naju'jawe rũi imome'ui 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A'eramũ mainana 'wyriararete 'ga afu'ama 'jau Jejui 'ga upe: —Ma'ja ere te 'gã nupe? Nereje'egi te 'ã 'gã nupe aipo 'gã 'eramũ a'i kũi?— 'jau 'ga oporonupa ee 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A'ere Jejui 'ga pigi etee u'ama. A'eramũ mainana 'wyriararete 'ga 'jau 'ga upe: —Jarejuwarete 'ga remimurera te ene? 'Ga ra'yra te ene?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat ere poromũ. Je te 'ã pẽneki'yraretea. Anure nipo je apygi Pãjẽrete 'ga yse katy, 'ga jakwatawa katy. Peu je renamũ nipo pẽẽ je resaka. Anure nipo je ruri tejewya ywag awi ywasiga rupi— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A'erauwe mainana 'wyriararete 'ga amara'neramũ. 'Ga mara'nea 'ga rerekou 'ga raity monorogukaa 'ga upe. A'eramũ 'ga 'jau 'gã nupe: —A'jea futat 'ga Jarejuwarete 'ga kurawi akou ra'e— 'jau 'ga 'gã nupe. —Jane futat 'awamũ sienup 'ga kurawa jarejowase— 'jau 'ga 'gã nupe. —Na'gã amũ rũi 'ã omome'u janee. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ma'ja pe'je ajee 'ga upe 'awamũ?— 'jau 'ga 'gã nupe. —Sijukaukat futat jane 'ga. Jarejuwarete 'ga te 'ã 'ga akurap. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A'eramũ 'gã amũ onymuna 'ga ree. A'eramũ 'gã 'ga reakwapiaa taity pyu, opo afuapyka erofaa 'ga ree. A'eramũ 'gã 'jau 'ga upe: —Awỹja te ene nupã?— 'jau 'gã 'ga upe. —Ene 'ã i'akwaawete ma'ea. A'eramũ ene enupãara 'ga mome'wau oree— 'jau 'gã 'ga upe. A'erauwe jefaruu 'gã nanẽ 'ga pyyka opo rerofaa 'ga ree nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","A'e pe Pedro 'ga 'ũina ukupepe. Poje mainana 'wyriararete 'ga remiayuwa ẽẽ mũ 'ua 'ga pyri. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tata are 'ga jepe'eramũ ẽẽ 'ga resaka 'jau 'ga upe: —Jejui kĩã rewiri ako ma'eferamũ ene, 'jau je rã, Nasare pe waranup ma'efera kĩã rewiri ako ma'eferamũ ene, 'jau je rã— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","A'eramũ 'ga 'jau ẽẽ upe: —Tee. Naani nũ ĩ. Nakwaawi je 'ga nũ ĩ. A'eramũ awỹja upe ene 'jau ekou ĩ— 'jau futatee 'ga ẽẽ upe. A'erauwe 'ga afu'ama awau 'oga osoma pyri. A'erauwe wyrasokwẽa oje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Peu oporowyky ma'e ẽẽ mũ 'ga resaka nũ. A'eramũ ẽẽ 'jau ojepyriwara 'gã nupe: —Koromũ futat Jejui kĩã rewiri ako ma'efera kĩã mũ— 'jau ẽẽ 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A'eramũ Pedro 'ga 'ga kwakupa nũ. A'ere'ere'i peu u'am ma'e 'ga amũ 'jau 'ga upe nũ: —A'jea futat ẽẽ 'i enee. Garireja ywy pewaramũ futat ene, 'ga 'jawe futat ene ra'e— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A'eramũ Pedro 'ga 'jau 'ga upe: —Nakwaawi je 'ga, a'e je akiko. Jarejuwarete 'ga remianuwamũ te 'ã je 'eu'jawi. Nakwaawi je 'ga, 'jau. Te'me re je Jarejuwarete 'ga tejereko tywera futari— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A'e pype wyrasokwẽ oje'ega nũ. A'erauwe Pedro 'ga wea'aramũ Jejui 'ga 'eawer are. “Wyrasokwẽ je'egu'jaw enunewe nipo ereu'jau'jap, nakwaawi je 'ga, 'jau 'gã nupe” 'eawer are Pedro 'ga wea'aramũ. A'eramũ 'ga aipo u'eawera rerojenosõu. A'eramũ 'ga awau ujãna Jejui 'ga kwakupawera renosõu. A'eramũ futat 'ga u'arasigamũ wea'aramũ ee. A'eramũ 'ga ajaa'wau awau u'eawera raykau. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ai'iwetetewe mainana 'wyriara 'gã ajatykau judeu 'gã 'wyria'ri 'gã nee, Moisesi 'ga remikwasiarer are moromu'jara 'gã neewe. Opytuna 'gã nupe oje'ẽma'e 'gã nanẽ ajatykau 'gã nee nũ. A'eramũ 'gã oje'ega ajaupe: —“Je te 'ã Jarejuwarete 'ga ra'yraretea”, e'i ako Jejui 'ga janee ko. A'eramũ jane 'ga jukaukaa 'gã nupe— 'jau 'gã ajaupe. A'eramũ 'gã 'ga pofaa itaju pyu, 'ga rerawau Piratu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","A'eramũ Piratu 'ga oporonupa ee 'ga upe: —A'jea te ene 'wyriaramũ judeu 'gã nupe?— 'jau 'ga 'ga upe. —A'jea futat ere poromũ— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A'eramũ taetu mainana 'wyriara 'gã 'ga je'ẽwu'jawu'jaga etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","A'eramũ Piratu 'ga 'jau 'ga upe nũ: —Nereenuwi te 'gã je'ega? Nerewawagi te 'ã aipo 'e are a'i kũi?— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","A'ere Jejui 'ga noje'egi futari 'gã nupe. O'meramũ te 'gã 'i. A'eramũ Jejui 'ga oje'ege'ema 'gã nupe. A'eramũ Piratu 'ga oporesagamũ etee 'ga ree. “Ma'eramũ sipo 'ga noje'egi?” 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mani'oko'o jopype'ema 'wawa maraka apoawa rupi Piratu 'ga moromunepawa pype imunewipyrera 'ga amũ muẽma judeu 'gã nupe jepi, 'gã nemienũiwera 'ga 'ga imuẽma 'gã nupe jepi. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jejui 'ga pyykawa rupi Parapasi 'ga 'ũina moromunepawa pype. Parapasi 'ga futat amunaw ipewara 'gã mamara'neukaa 'wyriara 'ga ree. Opytuna 'gã netee 'ga 'gã mamara'neukaa 'wyriara 'ga ree rakue. Oporojuka ma'efera 'gã wejue nũ. A'eramũ 'gã 'gã monou 'gã munepa 'gã mu'ama rakue. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A'eramũ mytuna 'gã 'ua 'jau Piratu 'ga upe: —Ejemiapou moromunepawa pypewara 'ga amũ emuẽmukat oree— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A'eramũ Piratu 'ga 'jau 'gã nupe: —Pefutat te judeuramũ peje'wyriararete 'ga je imuẽma pejejeupe?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Piratu 'ga mainana 'wyriara 'gã kwaapa futat. “Werekoay pa mainana 'wyriara 'gã Jejui 'ga. A'eramũ pa 'gã 'ga rerua jee ra'e”, 'jau Piratu 'ga ojeupe. “A'ere mytuna 'gã poromutaramũ 'ga ree. A'eramũ nipo 'gã 'jau, Jejui 'ga emut oree, 'jau nipo 'gã jee”, 'jau Piratu 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","A'ere mainana 'wyriara 'gã afuakaramũ 'ga ree. —Parapasi 'ga ki emuẽm imua oree, sa'e 'ga upe 'jau. Jejui 'ga kasi eremuẽm oree ne, sa'e 'ga upe 'jau— 'jau 'gã mytuna 'gã nupe. 'Ga rerure'emauwe 'gã mogyau 'gã mu'akwaapa. A'eramũ 'gã afuakaramũ 'ga ree. A'eramũ Piratu 'ga oporonupa ee 'gã nupe: —Pefutat te judeuramũ peje'wyriararete 'ga je imuẽma pejejeupe?— 'jau 'ga 'gã nupe. A'ere 'gã 'i etee 'ga upe: —Naani. Parapasi 'ga te ki emuẽm imua oree— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A'eramũ Piratu 'ga 'jau 'gã nupe: —Maran te jane Jejui 'ga rerekoi, “judeuramũ pẽẽ 'wyriararete 'ga” 'jawa 'ga rerekoi?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Emu'amukat 'ga 'ypeywar are 'ga pokutuka 'ga jukaawamũ futat— 'jau 'gã wafukaita 'ga upe. A'eramũ 'ga: ");
INSERT INTO kyzNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Ma'ja te 'ga wapo ajukaawamũ pẽ nupe rai'i, a'e te je a'i kũi?— 'jau 'ga 'gã nupe. A'ere 'gã afukafukai etee ajemogyau: —Emu'amukat futat Jejui 'ga 'ypeywar are 'gã nupe— 'jau 'gã wojere'emamũ futat wafukaita 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Piratu 'ga oporomaku'iweramũ mytuna 'gã nee. A'eramũ 'ga Parapasi 'ga muẽmukaa moromunepaw awi 'ga monou 'gã nupe. Jejui 'ga jẽmĩ 'ga imopigukaa jefaruu 'gã nupe. —Pe'je 'ga rerawau 'ga mopika 'ga a'gwawe'em futat. Pẽporia kasi 'ga nupãu ne. 'Ga mopig ire pẽẽ 'ga rerawau 'ga mu'ama 'ypeywar are. A'eramũ 'ga peu etee futat amanũmũ u'ama— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","'Ga mopig ire jefaruu 'gã Jejui 'ga rerawau 'ga rerosou Piratu 'ga rog ipe. A'ere 'gã opytuna 'gã majatykau 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A'ere 'gã 'wyriara raity piraga munepa 'ga wi. A'ere 'gã juapekagũũ muapỹina 'ga akagyrũnamũ iapou 'ga upe. A'eramũ 'gã imonou imunepa 'ga akaga pype. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","A'ere 'gã 'jau 'ga upe: —Ene 'ã judeu 'gã 'wyriararetea 'gã nupe ra'e jepi. 'Awamũ ereko 'wyriarareteramũ nakwaparimũ rũi futat 'gã nupe— 'jau 'gã Jejui 'ga upe 'ga rerekoemãu erekou. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A'e pype 'gã 'ga akaga nupãu ywyra'i'i pyu. Onymuna 'gã 'ga ree. A'ere 'gã wapyka wenupy'ãu 'ga rowase, 'ga muorypa 'me. A'ere 'gã 'jau ajaupe: —Pemã'ẽ judeu 'gã 'wyriararete 'ga ree ki sa— 'jau 'gã ajaupe. —'Wyriara raity piraga 'ga wereko imunepa 'awamũ. 'Wyriara akagyrũa nanẽ 'ga wereko nũ. 'Wyriararete pype tãmẽjẽ 'ga 'ari ra'e— 'jau 'gã ajaupe 'ga rerekoemãu. 'Ga jaita nanẽ 'gã nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","'Ga rerekoemã re 'gã taity piraga mosoka 'ga wi nũ. 'Ga raity munepa 'ga wi nũ. A'ere 'gã 'ga rerawau 'ga jukaaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","'Ga jukaawa piara rupi 'gã Simão 'ga rowosõu. Jũ awi 'ga 'ua akou awau amunawarete pe. Sirene ywy pewara 'ga poromũ Simãoramũ. Mukũi Simão 'ga ra'yra 'gã. Aresãri 'ga, Rufu 'ga. Mĩmera 'gã Simão 'ga ra'yra. Simão 'ga resakawe jefaruu 'gã 'jau 'ga upe: —'Ypeywara erokwap 'ga upe— 'jau 'gã 'ga upe. A'eramũ 'gã iupirukaa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","A'eramũ 'gã Jejui 'ga rerawau Gogata 'jaw ipe. ('Gã je'eg imũ Gogata 'ea Aeakagera 'jawewara 'ea futat poromũ). ");
INSERT INTO kyzNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","'Ga rerowaẽm ire 'gã muaga monou y'way pype 'ga upe numiamũ. Mira 'jawa 'gã imonou y'way pype 'ga upe numiamũ. —Koa etykut ejayrũ upe— 'jau 'ga 'ga upe numiamũ. A'ere 'ga notykuri. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A'ere 'gã 'ga jywaa pypiraa 'ypeywar are. A'ere 'gã itaju pyu 'ga pokutuka 'ypeywar are. A'ere 'gã 'ga py maju'aa aju'arimũ ikutuka itaju pyu. A'ere 'gã 'ga mafu'ama 'ga monou 'ga mu'ama 'ypeywara reewe futat. 'Ga rekoa futat 'gã imonou imu'ama 'ypeywar are ipokutuka. 'Ypeywar are 'ga mu'am ire 'gã 'ga raityfera mojo'oka ajaupe. Ita'i 'jawewara 'gã imomopoa 'upa ywyu 'ga raityfera mojo'okawamũ. Sã'ã ae jugu momora. Nan futat 'gã ita'i 'jawewara momopori 'upa 'ga raityfera mojo'okawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kwara awyruu'iramũ etee 'gã 'ga mu'ama 'ypeywar are. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","A'ere 'gã 'yjepa'nĩ are ikwasiaripyrera monou inuga ikutuka 'yw are 'ga apyte'rarimũ. “Koromũ futat judeu 'gã 'wyriararetea” 'ea 'gã amũ ikwasiaa 'yjepa'nĩ are rai'i. A'eramũ 'gã imonou inuga 'yw are 'ga apyte'rarimũ. A'eramũ 'ga resakara 'gã 'ga jukaawera kwaapa. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","'Ga reewe 'gã mukũja 'gã muna'ywa 'gã imonou imu'ama 'ypeywara mũ ree. Muna'ywa põ'õ me 'gã Jejui 'ga mu'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ymã te Janeruwarete 'ga ka'arana kwasiarukari ee rakue: “Mama'e tywera apoara pyri 'ga 'ami”, 'jau 'ga ikwasiarukaa rakue. A'eramũ 'gã 'ga monou imu'ama muna'ywa põ'õ me, Janeruwarete 'ga je'egawer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","'Gã pyu okwap ma'e 'gã Jejui 'ga rerekoemãu 'ga kurapa nanẽ nũ. —“Anure nipo je Jarejuwarete 'ga mogytaawa retygi. A'ere nipo je imuapyra 'ara rupi imowyri nũ”, ere 'ã rai'i. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","A'eramũ ene ejua ejypa 'ypeywar awi— 'jau 'ga pyu okwap ma'e 'gã 'ga upe, 'ga rerekoemãu. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mainana 'wyriara 'gã, Moisesi 'ga remikwasiarer are moromu'jara 'gã. Mĩmera 'gã nanẽ 'ga rerekoemãu 'upa nũ: —Opoat 'ga 'gã jepi. A'ere 'ga najepoara'uweri futari. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israeu juapyreramũ jane'wyriararetea e'i na a'e 'ga re'ã. Siesag iki ajee 'ga rura 'ga jywa 'wei. 'Ga jyp 'ga ruramũ sirowiat 'ga 'jau 'wei— 'jau 'gã ajaupe. 'Ga pyri imu'amipyrera 'gã, muna'ywa 'gã amũ nanẽ 'ga kurapa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kwara okwapa aje owepa. Ypytuna 'jawe futat oypytunaiwamũ. Kwara ajerewamũ tãmẽjẽ awau weny jesagamũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kwara renye'emauwe Jejui 'ga wafukaita oje'eg imũ futat. —Eli eli lama sabactani— 'jau 'ga oje'eg imũ. Oje'eg imũ 'ga 'eawera: “Kiapi'ni, Kiapi'ni. Ma'eramũ te erepoit je wi?” 'ga 'ea futat poromũ 'ga afukaja. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aipo 'ga 'e renupara 'gã amũ 'jau: —Eliasi 'ga 'ga wenũi!— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Ga pyriwara 'ga amũ ujãna amynejuranũũ pyyka imonou imunepa y'waynana pype. A'ere 'ga imonou iupia 'ywa rapefã are imonou Jejui 'ga upe 'ga remipyteramũ. A'ere 'ga 'i etee esakara 'gã nupe: —Tene jane 'ga resagi ra'ne. Siesak Eliasi 'ga rura 'ga mosoga 'ypeywar awi ra'ne 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A'ere Jejui 'ga wafukaita amanũmũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A'eramũ futat Janeruwarete 'ga mogytaawa my'jawa rowopypea taity otoroka opojo'ogamũ imytera rupi. Ywate awi we futat 'ua opojo'ogamũ ywyu. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","'Ga manũnamũ jefaruu 'gã 'wyria'ri 'ga 'ga manũ resaka. 'Ypeywara rowase 'ga u'ama Jejui 'ga afukajamũ. A'eramũ 'ga 'jau ojeupe: —A'jea futat pa 'ga Ku'jywa 'ga ra'yra futat ra'e!— 'jau 'ga u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kũjãmera 'gã amũ 'upa muku'i 'ga manũ resaka nũ. Ẽẽ mũ rera Mari Matarena, ajepeja ẽẽ rera Sarume, ajepeja ẽẽ rera Mari. Poromũ Mari ẽẽ ra'yra 'gã Jose 'ga, Tiago 'ga. Aipoa Tiago 'ga kunumĩũũa. Mĩmera 'gã 'ga manũ resaka amumera 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Poromũ kũjãmera 'gã Jejui 'ga rewiri ako ma'efera 'gã futat poromũ. Garireja ywy pype 'ga rekoramũ 'gã awau watau 'ga rupi, 'ga poaa mama'e apo are rakue. Amumera kũjãmera 'gã 'upa 'ga manũ resaka. Aipo 'gã nanẽ 'ua 'ga rupi Garireja ywy awi Jerusareg ipe 'ga oramũ rai'i nũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Kaaruwamũ Jose 'ga, Arimateja pewarera 'ga awau oporogytau Piratu 'ga upe. Opytuna 'gã nupe oje'ẽma'e 'ga poromũ. A'ere 'ga Jejui 'ga rerowiari. “Anure nipo Jejui 'ga 'ũina 'wyriaramũ janee”, 'jau 'ga ojeupe. Morowykye'ema piara rupi 'gã Jejui 'ga jukaukaa ra'e. A'eramũ Jose 'ga awau “Jejui 'ga reumera emut jee”, 'jau Piratu 'ga upe: —Amanũ Jejui 'ga ko. 'Ga reumera toroo inuga ita kwara pype 'jau— 'jau 'ga Piratu 'ga upe. Morowykye'ema rupi judeu 'gã nojotymi rakue. “Morowykye'ema piara rupi futat sitym 'ga 'jau”, 'jau Jose 'ga ojeupe etee futat. A'eramũ 'ga Piratu 'ga pojeupe'ema futat awau Jejui 'ga reumera renũina 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","—Amanũ te 'ga ra'e?— 'jau Piratu 'ga 'ga upe. —Amanũ ako 'ga ko nũ'ũ— 'jau 'ga 'ga upe. —Kuu. Kamẽsĩete nipo 'ga manũi ra'e— 'jau Piratu 'ga oporesagamũ 'ga ree. A'erauwe 'ga 'jau jefaruu 'gã 'wyria'ri 'ga upe: —Maranime te 'ga manũi ra'e?— 'jau 'ga imome'waukaa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Kwara jerewamũ ako 'ga manũi ko— 'jau 'ga 'ga upe. Aipo ojeupe jefaruu 'gã 'wyria'ri 'ga 'e re 'ga 'jau Jose 'ga upe: —Ere 'ga rerawau inuga ita kwara pype— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A'erauwe Jose 'ga awau taity fuku mua Jejui 'ga reumera auwanawamũ. Linu 'jawa apopyrera 'ga imua. A'eramũ 'ga Jejui 'ga reumera mosoka imua 'ypeywar awi 'ga reumera auwana aipoa taity pyu. A'ere 'ga 'ga reumera monou inuga ita kwara pype. A'ere 'ga itapewuu mojerepa imonou imỹina ita kwara rawopytymawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kũjãmera 'gã amũ awau 'ga imono resaka. Mari Matarena ẽẽ, Mari ẽẽ. Aipoa Mari ẽẽ Jose 'ga ya. Mĩmera 'gã Jejui 'ga reumera rupawa resaka. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Ikoai'i, ku'emaiw are, kũjãmera 'gã jany kasiga mua erawau Jejui 'ga reumer are eko'wogipyramũ. Mari Matarena ẽẽ, Sarume ẽẽ, Mari ẽẽ. Poromũ Tiago 'ga y ẽẽ. Mĩmera 'gã jany kasiga amut erawau. Ku'emaiw are 'gã erawau Jejui 'ga rupaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Awau 'gã 'jau: —Awỹja sipo itaa ope'a jui janee?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tuwiuu wejue itauua. A'eramũ 'gã poromũ 'jau ajaupe. Awau 'gã owaẽma ja'wyja'wy jupe itauu resaka, ita kwara rawopytymawera resaka. —Tỹỹ. Ojepe'a jui ra'e— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","A'erauwe kũjãmera 'gã awau osou ita kwara pype. Peu 'gã ywagipewara 'ga resaka kunumĩũũ 'jawe. 'Ga raitya waparasigamũ. Jejui 'ga rupawera jakwatawa katy 'ga wapyka. 'Ga resakawe kũjãmera 'gã okyjau 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A'eramũ 'ga 'jau 'gã nupe: —Pekyje awi je wi— 'jau 'ga 'gã nupe. —Jejui 'ga resaka te 'ã pejot, Nasare pe waranup ma'efera 'ga resaka te 'ã pejot, 'ypeywar are amanũ ma'efera 'ga resaka te 'ã pejot— 'jau ywagipewara 'ga kũjãmera 'gã nupe. —A'ere 'ga nitywi 'au. Oferap ako 'ga ko. Pe'je pejejua 'ga rupawera resaka— 'jau 'ga 'gã nupe. A'eramũ 'gã awau esaka. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","A'eramũ ywag awi 'ut ma'efera 'ga 'jau 'gã nupe nũ: —Pe'je pejewau imome'wau Pedro 'ga upe, amumera 'ga remimu'e 'gã nupe we: “Oferap kĩã awau Garireja ywy pe pẽ nenune. Peu te nipo 'ga peesak nũ, pejejeupe 'ga 'eawer imũ etee futat nũ”, pe'je ki 'gã nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","A'erauwe kũjãmera 'gã awau ujãna ita kwar awi. 'Gã kyjea 'gã nerekou 'gã moyyita. A'eramũ 'gã ojeupe 'ga 'eawera mome'wawe'em awau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo rupi Jejui 'ga ferawi rakue. Ku'em enune 'ga ferawi rakue. Mari Matarena ẽẽ upe ra'ne 'ga ojesaukaa. Ẽẽ pirewara 'ga imoia ẽẽ wi rakue. Sete ẽẽ pirewara pytuna. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ojeupe 'ga jesaukar ire ẽẽ awau imome'wau 'ga remimu'e 'gã nupe rakue. U'arasigamũ 'gã ajemogyau ajaa'wau Jejui 'ga ree. A'eramũ Mari Matarena ẽẽ awau imome'wau 'gã nupe: —Oferap kĩã ra'e. Ojesaukat kĩã jee ko— 'jau ẽẽ 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A'ere 'gã nuerowiari etee ẽẽ ojeupe 'ga mome'uramũ. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A'ere Jejui 'ga ojesaukaa mukũja werowiaara 'gã nupe. Jũ me 'ga awau watau akou. Poje Jejui 'ga ojesaukaa 'gã nupe. A'ere 'ga jesowo'gõgi 'gã nupe. A'eramũ 'gã 'ga kwaape'ema. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A'ere 'gã 'ga kwaaw ire awau ojewya 'ga mome'wau amumera 'ga remimu'e 'gã nupe. A'ere 'ga remimu'e 'gã nuerowiari etee 'gã 'ea. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Poje Jejui 'ga ojesaukaa wemimu'e 'gã nupe. 'Gã jemi'waaw ipe 'ga ojesaukaa 'gã nupe. A'eramũ 'ga 'jau 'gã nupe: —Ma'eramũ te neperowiari 'gã, “oferap 'ga” pejejeupe 'gã 'eramũ ra'e 'ũ? Ma'eramũ sipo ajee neperowiari je'eawera ra'e?— 'jau 'ga 'gã nupe oje'ega moywyrafena 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A'eramũ 'ga 'jau 'gã nupe: —Pe'je pejewau je mome'wau kwe pewara 'gã nupe najuejue etee futat. Amunawa moymoyka pejewau je mome'wau 'gã nupe, je rerowiarukaa 'gã nupe pejejemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Je rerowiaara 'gã ki pepymĩ 'y pe, otywer awi 'gã poira resaukaawamũ. A'eramũ je tejerowiaara 'gã katu'oka. Tejerowiare'ema 'gã nipo je nakatu'ogi. A'eramũ nipo 'gã awau mama'eukwaawa rapyaw ipe amanũ re— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Tepãjẽa nipo je imonou tejerowiaaramũ pẽ nupe. A'eramũ pẽẽ mama'eukwaawa moia erekwara 'gã nui jerer imũ. Pejejemikwaawe'ema pejeje'ega nipo pẽẽ iapou. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Moja pyyka miamũ nepemanũi. Ae jukaara muaga 'wau miamũ nanẽ nepẽ jukai. Oje'arimũ je rerowiaaramũ pejepo mono re ojero'wu ma'e 'gã ojekatu'oka ajemogyau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","'Gã nupe oje'ẽmaw ire Janeruwarete 'ga Janejararete 'ga, Jejui 'ga monoukaa 'ga mojeupirukaa ywag ipe. Ywag ipe 'ga waẽmawe Janeruwarete 'ga 'jau 'ga upe: “Ene 'ã je 'jawe futat. A'eramũ ene eapyka jejakwatawa katy”, 'jau Janeruwarete 'ga Jejui 'ga upe. A'eramũ Jejui 'ga awau wapyka 'Uwarete 'ga jakwatawa katy. ");
INSERT INTO kyzNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A'eramũ 'ga remimu'e 'gã awau 'ga mome'wau kwe pe. “Werowiaramũ Jejui 'ga pẽtywera moia pẽ nui, pẽ katu'oka”, 'jau 'gã imome'wau kwe pewara 'gã nupe. Janejararete 'ga 'gã opoat. Aeremiapoe'ema 'ga wapoukat 'gã nupe. A'eramũ 'gã nenupara 'gã 'gã 'eawera rerowiaa. “A'jea futat 'gã 'ea. Sã'ã Ku'jywa 'ga janeremiapoe'ema apoukara 'gã nupe”, 'jau enupara 'gã ajaupe, aipo 'gã 'e rerowiaa.");
INSERT INTO kyzNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Teofiru. Ene 'ã kũima'eeteetea. A'eramũ je ene upe ka'arana kwasiaa inuga. Je Luka. Jejui 'ga ree je ka'arana kwasiari inuga ene upe. A'eramũ ene jeremikwasiarera mogytau. A'eramũ ene “Na pa je 'gã a'jea futat imome'ui jee ra'e”, 'jau ene jeremikwasiarera mogyta re. Ae pype akou 'ã Jejui 'ga awau watau kwe pe akou rakue, mama'eukwaawa pe'au 'gã nui rakue. Ojero'wu ma'e 'gã katu'oka 'ga awau kwe pe akou rakue. 'Gã mu'jau 'Uwarete 'ga je'eg are rakue. A'eramũ 'gã 'awamũ kwaiwete 'ga renuparera 'gã 'ga rera mome'wau awau kwe pe ajemogyau 'gã nupe. Amumera 'gã ka'arana kwasiaa 'ga ree, 'ga rekwawer are. A'ere 'gã nomome'upawi 'ga rekwawera rakue. A'eramũ je “amome'upap pa je ikwasiaa inuga ka'aran are 'gã nupe kwy”, 'jau je tejeupe. A'eramũ je a'eramũ tewau Jejui 'ga resakarera 'gã nupe teporogytau tekou ai'i. Je naesagi futari Jejui 'ga. A'eramũ je tewau 'ga resakarera 'gã nupe teporogytau tekou. Namajepei'i 'gã nupe etee rũi futat je porogytai. Kwaiwete je porogytai 'ga resakarera 'gã nupe tewau tekou ai'i. “Pemome'upap pejejemiesagera jee”, 'jau je 'gã nupe tewau tekou ai'i. “Jejui 'ga remiapofera pemome'upap jee”, 'jau je tewau tekou 'gã nupe ai'i. A'eramũ 'gã imome'waupap jee. Wemiesagera 'gã imome'wau jee. A'eramũ je 'awamũ ka'arana kwasiaa inuga 'gã nemimome'ufer are pẽ nupe. A'eramũ ene jeremikwasiarera resaka ka'aran are. “A'jea futat 'gã Jejui 'ga mome'ui jee rakue”, tere jeremikwasiarera mogyta re 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A'ere je Juã Batista 'ga ra'ne imome'ui enee. Juã 'ga rekoramũ Erote 'ga rekoi 'wyriaramũ judeu 'gã nupe rakue. Juã 'ga ruwa 'ga rera Sakari. Sakari 'ga mainana. Apiasi 'ga remiayuwa 'gã pyri 'ga oporowykyau Jarejuwarete 'ga mogytaawa pype. Mainana 'gã juejue Arão 'ga juapyrera. Sakari 'ga remireko ẽẽ nanẽ Arão 'ga juapyrera ẽẽ nũ, Isapeu ẽẽ. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ẽẽ mama'e tywera nuapoi futari Jarejuwarete 'ga upe. Sakari 'ga nanẽ nuapoi futari 'ga upe nũ. Jarejuwarete 'ga je'eg are 'gã apyakai. Jarejuwarete 'ga remifutar imũ etee futat 'gã mama'e apou akou namutamutat 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Isapeu ẽẽ nata'yri futari 'gã nupe. Ẽẽmena 'ga nanẽ futat osawa'eramũ. Nokoi'i futari 'gã na'yra mũ. Namanũi futari 'gã na'yra mũ. Ẽẽ ra'yre'em teea futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jarejuwarete 'ga upe 'ga porowykyaw ipe Sakari 'ga ruramũ 'ga pytuna 'gã 'jau 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","—'Awamũ ene ekwap esou 'au myter ipewara pype jany kasiga rapyau, Jarejuwarete 'ga muorypawamũ— 'jau 'gã 'ga upe. A'erauwe 'ga awau osou jany kasiga rerawau iapyau. Awau osou imy'ja'wi pype. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jany kasiga 'ga upe eroo iapyramũ tekotee 'gã 'upa oporogytau ukupepe Jarejuwarete 'ga upe, 'ga ẽma poromukuran. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jany kasiga imonygauwe ywagipewara 'ga 'ua ojesaukaa 'ga upe. 'Ua u'ama tata eny pyri. Jany kasiga 'ga iapyramũ 'ga 'ua u'ama ojesaukaa 'ga upe. Iapyawa rowajara katy ojesaukaa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","'Ga resakawe Sakari 'ga okyjau etee 'ga wi. —Kuu. Ma'ja te 'wei? Ma'ja te koromũ 'ut ojesaukaa jee 'wei?— 'jau 'ga okyjau etee futat u'ama ywagipewara 'ga wi, ojeupe 'ga jesaukaramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ojewi 'ga kyjeramũ ywagipewara 'ga oje'ega 'ga upe: —Erekyje awi. Janeruwarete 'ga eneje'ega wanup 'ũina— 'jau 'ga 'ga upe ojewi 'ga kyjeramũ. —“Kunumĩa emut amũ jee”, ere ako 'ga upe rakue. A'eramũ 'ga 'awamũ eneremifutara mua enee— 'jau 'ga 'ga upe. —Anurenure'i nipo eneremireko ẽẽ ra'yramũ— 'jau 'ga Sakari 'ga upe. —Eja'yra 'ga 'ar ire ki Juã enug 'ga ree. 'Ga 'aramũ nipo eneku'i 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Enepytuna 'gã we futat nipo aku'iramũ ene pyri 'ga 'aramũ 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Waranuw ire nipo enera'yra 'ga kũima'eeteetea Jarejuwarete 'ga upe— 'jau 'ga 'ga upe u'ama. —'Ga aranuw ire ene kawĩajaiwa rykurukare'ema 'ga upe. Y'way ajaiwaye'ema miamũ futat itykurukare'ema 'ga upe. 'Ga 'ar ypyrauwe Janeruwarete 'ga 'Agesagea 'ga rerekoi— 'jau 'ga 'ga upe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","—Waranuw ire nipo enera'yra 'ga awau akou kwe pe oporogytau Israeu juapyrera 'gã nupe. A'eramũ nipo 'ga 'gã mojewyrukaa Jarejuwarete 'ga rerowiara upe nũ— 'jau 'ga 'ga ruwa 'ga upe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","—Sã'ã ymã Eliasi 'ga rekoa Jarejuwarete 'ga pãjẽ mũ etee mama'e apoa rakue. Nan tee futat nipo enera'yra 'ga rekoi, 'ga 'jawerimũ etee futat. Jarejararete 'ga rur enune nipo enera'yra 'ga rekoi 'gã mu'jau. 'Gã na'yra mota'waukaa 'gã nuwa 'gã nupe— 'jau 'ga imome'wau 'ga upe. —A'ere te nipo Janejararete 'ga ruri enera'yra 'ga rewiri. Kwaiwete te 'ã 'gã Janeruwarete 'ga je'ega nuenuwi. A'eramũ enera'yra 'ga a'eramũ 'ua Janeruwarete 'ga je'ega renuwukaa 'gã nupe. Janejararete 'ga rura futarukaa 'gã nupe kwaiwete— 'jau ywagipewara 'ga Sakari 'ga upe u'ama imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A'ere aipo 'eramũ Sakari 'ga nuerowiari 'ga je'ega. —Ene'me awi jee kũi. Iwãiwĩ jeremireko ẽẽ nũ'ũ. Je nanẽ 'ã tesawa'eramũ nũ. A'jea futat sipo ẽẽ wãiwĩ pype ẽẽ ra'yramũ?— 'jau 'ga ywagipewara 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A'eramũ ywagipewara 'ga 'jau 'ga upe: —Naani. Ereapo awi aipoa. Je 'ã Gaprieua futat. Je 'ã Ku'jywa 'ga pyriwara futat. 'Ga te 'ã je mut je moporogytaukaa enee. 'Ga te 'ã moranuw esage werurukat imome'waukaa enee jee. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A'ere 'ã 'ga nererowiari etee ejeupe je 'ga mome'uramũ. A'eramũ nipo 'ga ene je'ẽwoka'jama. Ije'ege'ema 'jawe nipo ekou. Enera'yra 'are'emauwe nipo nereje'egi. 'Ga 'ar ire te ereje'eg nũ— 'jau ywagipewara 'ga Sakari 'ga upe. —Eja'yra 'aramũ te nipo ejeupe jeporogytawera ererowiat. A'eramũ te nipo ereje'eg nũ— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A'eramũ ukupepewara 'gã Sakari 'ga rapesaka 'upa. —Ma'ja te 'ga wapo 'ũina oporomukuramũ 'i?— 'jau 'gã ajaupe 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ojeupe ywagipewara 'ga porogytapaw ire Sakari 'ga 'ua uẽma ukupepewara 'gã nupe. A'ere 'ga noje'egi futari 'ua. Opoa etee futat 'ga imowawaka 'gã nupe. A'eramũ ukupepewara 'gã 'jau: —Ywagipewara 'gã nipo kwe ojesaukaa 'ga upe ra'e. A'eramũ 'ga oje'ẽka'jamamũ ra'e— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Oporowykypaw ire Sakari 'ga awau ojewya oje'wyr ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kamẽsĩete 'ga remireko ẽẽ wa'yramũ. A'eramũ ẽẽ 'ũina wog ipe etee futat. Watawe'em futat kwe pe awau. Sĩku jaya moka'jama 'ũina wog ipe watawe'em. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","A'eramũ ẽẽ 'jau ojeupe etee futat 'ũina: “Janeruwarete kĩã esage jee”, 'jau ẽẽ 'ũina. “Teja'yre'ema je anosĩ jepi. A'ere 'ã je 'awamũ jera'yramũ. Jemena agawewi je 'ã. A'etea je najera'yri jepi. A'ere 'ã 'awamũ jera'yramũ. A'eramũ je 'awamũ tejenosõumap”, 'jau ẽẽ 'ũina ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Isapeu ẽẽ ra'yryrũũnamũ, Janeruwarete 'ga ywagipewara 'ga mua Mari ẽẽ upe, Nasare pewara ẽẽ upe. Gaprieua ywagipewara 'ga rera. Gaprieu 'ga 'ua, Janeruwarete 'ga je'ega rerua Mari ẽẽ upe. Nimeni we Mari ẽẽ. Ẽẽmẽrama 'ga Jose 'ga. Jose 'ga Davi 'ga juapyrera. Iypy we 'gã nupe 'wyriarareteramũ 'ũi ma'efera 'ga futat poromũ, Daviramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A'eramũ Gaprieu 'ga 'jau Mari ẽẽ upe: —Ere eku'iramũ ekou 'awamũ, kari. Janeruwarete 'ga nipo 'ã ojejuka ene ree 'awamũ ĩ— 'jau 'ga ẽẽ upe 'ua. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A'ere ẽẽ naeapyoi ojeupe 'ga 'e are. “Ma'eramũ kĩã aipo 'jau jee 'ũ?” 'jau ẽẽ ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A'eramũ 'ga 'jau ẽẽ upe: —Erekyje awi, kari. Janeruwarete 'ga te ene rereko. Iku'i 'ga 'ũina ene ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Enera'yt nipo ene. Kũima'e 'ga nipo enera'yra 'ga. Jejui 'jau ki ene eja'yra 'ga renũina— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","—Kũima'eeteete 'ga te nipo. Janeruwarete 'ga te'i pẽ nupe 'jau: “Koromũ jera'yra 'ga”, te'i pẽ nupe 'ga resaukaa 'jau— 'jau 'ga ẽẽ upe. —'Ga futat nipo anure Janeruwarete 'ga omogo 'wyriarareteramũ pẽ nupe, judeuramũ pẽ nupe, Jako 'ga juapyreramũ pẽ nupe— 'jau 'ga ẽẽ upe. —Ymã we te ako Davi 'ga juapyrera 'ga peapesak pejejemogyau ikue. “Maranime gatu nipo Davi 'ga juapyrera 'ga ruri 'wyriarareteramũ akou janee?” pe'je 'ã pejejemogyau jepi. A'ere 'awamũ 'ga ruri pẽ nupe. Enera'yramũ 'ga 'ga muri pẽ nupe, pẽnemiapesagera 'ga. Namutat 'ga rekoi 'wyriarareteramũ pẽ nupe. Nipy'ruawi futari 'ga akou. Nateepawa'uweri futari nipo 'ga akou— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A'eramũ Mari ẽẽ 'jau 'ga upe: —Kũjãmukua we te 'ã je ako. Nokoi we te 'ã kũima'ea je ree. Ma'eramũ je kũima'e tejee ekoe'emauwe teja'yr ekoeteramũ nũrã?— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A'eramũ 'ga 'jau ẽẽ upe nũ: —Ku'jywa 'ga 'Agesagea te nipo ene rereko ĩ. 'Ga te kunumĩa amut enee ĩ. A'eramũ nipo ene eja'yramũ. Ku'jywa 'ga te wa'yra 'ga amut enee. A'eramũ nipo 'ga wesageramũ. Nitywi'i futari 'ga tywera 'ga ree— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","—Nenerea'ari nipo epytuna ẽẽ ree, Isapeu ẽẽ ree? “Ta'yre'ema kyna”, 'jau 'gã 'ã ẽẽ upe jepi. A'ere 'awamũ ẽẽ ra'yramũ. Ta'yryrũũũ ẽẽ. Owãiwĩ pype ẽẽ ra'yramũ ai'i. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wapo katu katu te 'ã Ku'jywa 'ga mama'ea. A'eramũ 'ga ẽẽ mena 'ga ra'yra pyygukaa ẽẽ upe. Nokoi'i te 'ã Ku'jywa 'ga remiapoe'ema mama'e mũ— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A'eramũ ẽẽ 'jau 'ga upe: —Nai'i. A'jea futat Janeruwarete kĩã jejararetea futat. Tene kĩã iapoi jee wemifutar imũ etee futat— 'jau Mari ẽẽ ywagipewara 'ga upe. Aipo 'epaw ire 'ga awau ẽẽ wi ywag ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","A'eramũ Mari ẽẽ ikoai'i awau Isapeu ẽẽ 'wyr ipe. “Oo pa je kyna resaka tekou kwy”, 'jau ẽẽ ojeupe. A'erauwe futat ẽẽ okaraemã mogatyrũmũ awau. Isapeu ẽẽ Judeja ywy pewara. Ywytyra pyte'rarimũ 'gã 'wyra ruwi. A'eramũ Mari ẽẽ awau peu. Amunaw ipe owaẽmawe Mari ẽẽ awawayayau osou Isapeu ẽẽ 'wyr ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mari ẽẽ resakawe Isapeu ẽẽ 'jau ẽẽ upe: —Tereko? —Je rekoi 'we. Ene pyri je ruri tekou— 'jau Mari ẽẽ ẽẽ upe. Mari ẽẽ je'ega renupawe Isapeu ẽẽ ra'yra 'ga omỹina ẽẽ reweg ipe. A'erauwe futat Janeruwarete 'ga 'Agesage ruri osou Isapeu ẽẽ pype. Ẽẽ rerekwaramũ futat 'ua. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A'eramũ ẽẽ 'jau Mari ẽẽ upe: —Janeruwarete kĩã ojejuka ene ree kyn. Janeruwarete kĩã esage janee. Ma'eramũ 'ã ereko eku'iramũ. Eneku'i 'ã ekou tekotee wã ku'i apyraapa— 'jau Isapeu ẽẽ Mari ẽẽ upe. —Enera'yra kĩã ree taetu nipo kĩã jejukai ene ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Janeruwarete kĩã esage jee. Ene 'ã jejara kĩã ya— 'jau ẽẽ Mari ẽẽ upe. —Je te 'ã nakũjãeteete rũi te pẽ nupe. A'etea te 'ã erejot je resaka rai'i— 'jau ẽẽ Mari ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","—Ene te 'ã jarejara kĩã ya. A'eramũ jera'yra kĩã omỹina aku'iramũ jereweg ipe eneje'ega renupawe ko— 'jau ẽẽ ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","—“Tene ki kĩã iapoi jee”, ere 'ã kĩã upe rai'i. “Tene ki kĩã kunumĩ muri jee”, ere 'ã kĩã upe rai'i. A'eramũ taetu kĩã tojejuka ene ree 'jau— 'jau Isapeu ẽẽ Mari ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A'eramũ Mari ẽẽ 'jau: —Janejara kĩã esage janee, a'e je jepi. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Janeruwarete kĩã jane katu'okara. A'eramũ je a'eramũ teku'iramũ tekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Je 'ã nakũjãeteetea rũi agawewi. A'etea kĩã 'ã ojejuka je ree je rekoramũ. Janeruwarete kĩã 'ã pãjẽretea. Kĩã 'ã aeremiapoe'ema wapo jee. Anure nipo je manũ re je rewiri 'ut ma'e wã 'jau jee: “Janeruwarete kĩã ojejuka kyna ree”, 'jau nipo wã 'ã jee je manũ re. Anure taetu nipo wã aipo wã 'i jee. Janeruwarete kĩã tekatu futat 'ã eteete ma'eramũ akou. Nokoi futari wã amũ kĩã 'jawe. Kĩã etee futat Okoeteete ma'eramũ— 'jau Mari ẽẽ Isapeu ẽẽ upe 'ũina imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","—Kĩã 'ã ajemuaẽm ojee iporomutat ma'e wã nee. Ymã we te 'ã kĩã jemuaẽmi wã nee rakue. Opoire'ema futat nipo kĩã jane ree ajemuaẽm awi. Anure taetu nipo kĩã jemuaẽmi wã nee— 'jau ẽẽ imome'wau ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","—'Awamũ taetu 'ã kĩã opãjẽ resaukaru'jau'japa wã nupe. Ojee ojerowiaraip ma'e wã kĩã imomapa nipo. Wã nemiaporama nipo kĩã imateepapa wã nui— 'jau ẽẽ 'ũina ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","—'Wyriara wã nipo kĩã imuẽma. 'Wyriare'ema wã etee nipo kĩã imỹina 'wyriara py'rau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ikaraemãe'ema wã nupe etee nipo kĩã mama'e esage monou nũ— 'jau ẽẽ imome'wau ẽẽ upe. —A'ere nipo kĩã ikaraemã kwai ma'e wã momoirukari wã karaemã awi. A'eramũ nipo kĩã wã monou kwe pe, wã karaemãe'eme futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Janeypy upe kĩã 'jau rakue: “Ajemuaẽm je pẽ nee. A'eramũ je pẽ poaa mama'e apo are”, 'jau kĩã rakue. A'eramũ kĩã u'eawer imũ etee mama'e apou wã nupe, wã poaa, Israeu kĩã juapyrera wã poaa. Wenuparera wã kĩã ipoaa. Nomoka'jami futari kĩã u'eawera. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Wea'aramũ etee futat kĩã akou wã nee. Kĩã 'ã ajemuaẽma janeypy wã nee rakue. Abraão kĩã ree, kĩã juapyrera wã nee nanẽ futat kĩã 'ã ojejukau rakue. Oje'eg imũ etee futat kĩã 'ã iapoi— 'jau Mari ẽẽ Isapeu ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Muapyra jay magwapa Mari ẽẽ akou peu Isapeu ẽẽ 'wyr ipe. A'ere ẽẽ ojewya 'ua oje'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Oje'wyr ipe Mari ẽẽ o re Isapeu ẽẽ ra'yra 'ga u'aa ẽẽ wi. Kũima'e 'ga futat ẽẽ ra'yra. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","59","A'eramũ ẽẽ pytuna 'gã aku'iramũ 'ga ree. Kwaiwete futat 'gã aku'iramũ 'ga ree. Ẽẽ pyriwara 'gã nanẽ aku'iramũ 'ga ree nũ. —Janeruwarete kĩã 'ã esage kyna upe. Ajemuaẽm kĩã kyna ree. A'eramũ kĩã kyna mena ra'yra pyygukaa kyna upe— 'jau kũjãmera 'gã. Kũima'efera 'gã we futat 'jau ẽẽ upe: —Esage te 'ã Janeruwarete 'ga 'gã nupe— 'jau 'gã ajaupe ẽẽ ra'yra 'aramũ. —Iwãiwĩ agawewi 'ã ẽẽ. A'etea 'ã ẽẽ ta'yt owãiwĩ pype— 'jau 'gã ẽẽ upe ẽẽ ra'yramũ. Majepeja etee kunumĩ 'ga morowykye'ema magwapa. A'ere 'gã 'ua 'ga mojewaga resaka. 'Ga mojewaga resaka 'ut ma'e 'gã 'jau ajaupe: —'Ga ruwa 'ga rera etee futat sinug 'ga ree kũi, Sakari kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A'ere 'ga y ẽẽ: —Naani. Nafutari je. Juã te je afutat kĩã reramũ— 'jau ẽẽ 'gã nupe. —Juã te je anug kĩã ree— 'jau etee ẽẽ 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aipo 'ga y ẽẽ 'eramũ 'gã 'jau ẽẽ upe: —Ma'eramũ a'i ĩ? Nitywi te 'ã enepytuna Juã pyu era a'i ĩ— 'jau 'gã ẽẽ upe. —Ma'eramũ ene inuga ekoete 'ga ree a'i ĩ?— 'jau 'gã ẽẽ upe. 'Ga ruwa 'ga peu futat 'ũina. A'ere 'ga noje'egi 'ũina. Ije'ẽka'jam 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A'eramũ 'gã 'jau 'ga ruwa 'ga upe: —Ma'ja pyu te jane 'ga renũi?— 'jau 'gã 'ga upe. Opou etee futat 'gã oje'ega Sakari 'ga upe 'ga 'jawe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A'erauwe 'ga iapoi 'gã 'jawe etee futat 'gã nupe. Opo warawarau etee 'gã nupe. —Ka'arana perut jee— 'jau 'ga. Opou etee futat 'ga 'jau 'gã nupe. A'erauwe 'gã ka'arana rerua 'ga upe. Ka'arana 'ga ikwasiaa wa'yra 'ga rer are 'gã nupe. Ka'aran are 'ga rera kwasiaramũ 'gã esaka. —'Ga rera Juã futat ra'e kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aipoa 'ga ikwasiaa 'ga renamũ futat 'ga je'ega ojewya 'ga upe. A'eramũ futat Janeruwarete 'ga 'ga je'ega mamuka 'ga wi, ywagipewara 'gã 'eawer imũ etee futat. A'eramũ futat 'ga imome'ui oje'eg imũ 'gã nupe, 'ga oporogytau 'ũina 'gã nupe. —Janeruwarete 'ga 'ã esage janee— 'jau 'ga oje'ega fug ire 'ũina, Jarejuwarete 'ga mome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","'Ga je'egauwe futat peuwara 'gã ajemogymogyau etee futat 'ga renupa. —Kuu. Maran te 'ga je'egi nũ 'wei?— 'jau 'gã ajemogyau etee futat 'ga je'ega rerowiare'ema 'ga je'egamũ. A'eramũ futat 'gã awau kwe pe ẽẽ rera mokwasi'wau ajaupe. —Iwãiwĩ agawewi 'ã Isapeu ẽẽ. A'etea ẽẽ ta'yt. Ẽẽ mena 'ga oje'ẽka'jamamũ ai'i. 'Ga ra'yra 'ga 'arauwe 'ga je'ega fugi 'ga wi ai'i nũ. A'eramũ futat 'ga oporogytau 'ũina Jarejuwarete 'ga upe oree ai'i— 'jau 'gã imome'wau ajaupe. Amunawa moyka awau imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","A'eramũ 'ga je'ega renupara 'gã 'jau: —Ma'e kũima'e 'ga sipo 'i? Kũima'e esage 'ga nipo kũi— 'jau 'gã ajaupe, 'gã na'yra rera renupa. A'eramũ Juã 'ga 'ar ypyrauwe Janeruwarete 'ga ojejukau esage 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","'Ga je'ega mamug ire Janeruwarete 'ga U'agesage mua Juã 'ga ruwa 'ga upe, Sakari 'ga upe. 'Ga 'Agesagea 'ga rerekou 'ga moje'egukaa 'gã nupe. Janeruwarete 'ga remimurama 'ga 'ga imome'wau 'gã nupe, wa'yra 'ga rewiri 'ut ma'e 'ga 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Ene 'ã eneresage oree, ki Ku'jyp. Nitywi 'ga amũ ene 'jawe oree. Ene etee futat te 'ã eneresage oree, sa'e ki Jarejuwarete 'ga upe. Janeypy 'gã 'ã, Israeu juapyrera 'gã 'ã, werowiat futat Jarejuwarete 'ga rakue. Janeruwarete 'ga te 'ã wemiayuwa 'gã wenũ'ẽukat Egitu ywy awi rakue. Anure nipo 'ga jane katu'okara 'ga muri janee. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jane katu'okara 'ga 'ã pãjẽretea. Jane katu'okara 'ga 'ã Davi 'ga juapyrera, Janeruwarete 'ga upe oporowyky ma'efera 'ga juapyrera 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ymã te 'ã Janeruwarete 'ga je'egi oje'ega mome'wara 'gã nupe rakue. A'eramũ 'ã 'ga 'eawera 'ga je'ega mome'wara 'gã imome'wau awau kwe pewara 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Tajejuka pẽ nee 'jau, pẽ jukaukare'ema pẽ nee iporomutare'ema 'gã nupe 'jau, pẽ nereko tywerukare'ema 'gã nupe 'jau, e'i 'ã Janeruwarete 'ga janee rakue”, 'jau 'gã awau 'ga 'eawera mome'wau 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Janeruwarete 'ga 'ã ajemuaẽm futat nanẽ janepytunera 'gã nee rakue. U'eawer imũ etee futat Janeruwarete 'ga iapoi 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Ymã te 'ã 'ga 'i Abraão 'ga upe rakue: “Amuẽm je ene ene ree iporomutare'ema 'gã nui”, 'jau 'ga 'ga upe rakue. “A'eramũ ene ekyjawe'em jeje'ega renupa. Je'eawer imũ etee futar iki ene mama'e apou ekou. A'eramũ ene etywere'emamũ ekou jee. Mama'e tywera apoare'ema ene. A'eramũ ene nan etee futat ewau emanũmũ jee”, 'jau Janeruwarete 'ga Abraão 'ga upe rakue. Aipo 'jau 'ga oje'ega Abraão 'ga upe rakue. A'ere 'ga na'ga upe etee rũi 'ga 'i. Abraão 'ga juapyreramũ jane upe juejue nanẽ futat 'ga 'i nũ— 'jau Sakari 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A'ere Sakari 'ga 'jau wa'yra 'ga upe: —Ene 'ã Janeruwarete 'ga remimurera 'ga renunewara, kisit. Ene aranuw ire nipo Janeruwarete 'ga 'jau enee: “Je te 'ã pãjẽretea”, 'jau nipo Janeruwarete 'ga enee. “Juã 'ga jeje'ega mome'wara 'gã nupe”, 'jau nipo 'ga enee ene rekoramũ. Ene nipo kũima'eeteete futat ereko 'gã nupe. Ene nipo ereo Jarejararete 'ga renunewe kwe pe 'gã mu'jau ekou Jarejararete 'ga rura futarukaa 'gã nupe. Janeruwarete 'ga ajemuaẽm ae ree. A'eramũ 'ga ene monou kwe pe ene moporogytaukaa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","79","“Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoiri pẽ nui, pẽ mogyau wemiayuwamũ pẽ katu'oka”, 'jau nipo ene ewau ekou 'gã nupe. “Janeruwarete 'ga ajemuaẽma jane ree. Ipota'wa te 'ã 'ga jane ree”, 'jau nipo ene ewau ekou 'gã nupe— 'jau 'ga wa'yra 'ga upe 'ũina oporogytau. —Janejararete 'ga 'ara 'jawe futat. Sã'ã ae kwara poromũ mama'e resak katu katua. Ypytunaiwa pypewara 'gã tee ajemogy okyjau mama'e awi. 'Arimũ wata ma'e 'gã nokyjei futari ajemogyau. Nan tee Janejararete 'ga 'ur ire jane mu'ei 'Uwarete 'ga ree. A'eramũ jane 'ga kwaaw ire jarekyjawe'em. 'Ga kwaapare'ema 'gã tee okyje ajemogyau. Amanũ awi 'gã kyjea 'gã nerekou. A'ere 'ga kwaapara 'gã nokyjei. Okwaawamũ Janeruwarete 'ga janekyje mateepawi. Ojeupe jane porogytaramũ Janeruwarete 'ga janetywera moia jane wi, jane monou wemiayuwamũ. A'eramũ jane a'eramũ jarekyjawe'em jaremanũ awi— 'jau Sakari 'ga wa'yra 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Waranuw ire Juã 'ga awau akou kwe pe. Janeruwarete 'ga 'Agesagea futat 'ga rerekou. Ojetee'i futat 'ga awau akou amunawe'em ipe namutamutat. A'ere Israeu juapyrera 'gã awau ajatykau 'ga porogyta renupa. A'eramũ 'ga Jarejuwarete 'ga je'ega mome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","'Wyriararete 'ga Augusto 'ga. A'eramũ 'ga 'jau ojeupe: “Marãmaran te jeremiayuwa pytuna nũ?” 'jau 'ga ojeupe. A'eramũ 'ga 'gã nera kwasiarukaa ojeupe. —Pekwap pejeje'wyr ipe pejejera kwasiarukaa 'gã nupe— 'jau 'ga 'gã nupe, oje'ega monou wemiayuwa 'gã nupe. —A'ere simojopyrũ pẽẽ 'jau, pẽnera kwasiarukar ire 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aipoa 'ga iapoukaramũ Sireniu 'ga 'ũina 'wyriaramũ Siria ywy pewara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A'eramũ 'gã awaupap wera kwasiarukaa wamỹja jeupawer ipe etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","A'eramũ Jose 'ga nanẽ awau Garireja ywy awi. Nasare awi 'ga awau Judeja ywy pe, wamỹja 'ga Davi 'ga 'wyrer ipe. Perẽi me Davi 'ga 'ari rakue. A'eramũ 'ga awau peu, wamỹja jeupawer ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wemirekoram ẽẽ rerawau, Mari ẽẽ rerawau ojeupi wera kwasiarukaa 'gã nupe. Ẽẽ ra'y'ra ja'wyja'wyramũ 'ga ẽẽ rerawau Perẽi me. A'ere kwaiwete 'gã oi peu. A'eramũ 'gã wawa 'oga ojumypykware'emamũ 'gã nupe. A'eramũ Jose 'ga ẽẽ rerawau wyra jagawa pype erosou 'ara ro'ysag awi. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Peu 'gã nekoramũ Mari ẽẽ ra'yr ypy 'ga u'aa. 'Ga 'ar ire 'ga auwana taity pyu, 'ga monou 'ga nuga ywya'ri pype ");
INSERT INTO kyzNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","9","Jejui 'ga 'aramũ ywagipewara 'ga 'ua ojypa ojesaukaa wyra jara 'gã nupe. Mukuu'i 'gã nekoi Perẽi awi. Jũ me 'gã nekoi weymawa pyri. Karupa'mĩa 'gã neymawa. Ypytunimũ agawewi. A'etea 'ara 'jawe imojesaka 'gã nupe. Tata eny 'jawewara rerua erojypa 'gã nupe. Janeruwarete 'ga ojemuenyu 'gã nupe. A'eramũ 'gã okyjau 'ga reny awi. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A'eramũ jui 'gã kyjeramũ ywagipewara 'ga 'jau 'gã nupe: —Pekyje awi. Moranuw esagea te je arut amũ imome'wau pẽ nupe. A'ea moranuwa pyu tamaku'i pẽẽ 'jau— 'jau 'ga 'gã nupe. —A'ea nipo 'gã amaku'i imogyau najuejue etee. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","'Awa 'ara rupi pẽ katu'okara 'ga 'ari Perẽi me ko. Janeruwarete 'ga remimurera 'ga 'ari ko. Pẽjararete 'ga 'ari ko, pẽnemiapesagera 'ga 'ari ko— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","—Taity pyu 'ga jeuwani 'upa ywya'ri pype. A'eramũ pẽẽ 'awamũ pejewau 'ga resaka. Jeremimome'ufer imũ etee futat nipo peesak 'ga ruwamũ. “A'jea futat jane esagi 'ga remimome'ufer imũ etee futat”, 'jau nipo pẽẽ pejejaupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ojetee'i ra'ne ywagipewara 'ga 'ua. A'ere kwaiwete 'gã 'ua ajatykau 'ur ypy ma'e 'ga ree. —Nitywi 'ga amũ Janeruwarete 'ga 'jawe. 'Ga te 'ã esage— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Ywagipewaramũ ore 'jau: “Ene te 'ã eneresage jepi.” Ywy pewara 'gã nanẽ 'jau nũ: “Ene te 'ã eneresage jepi” 'jau 'gã ajemogyau Jarejuwarete 'ga upe. A'eramũ 'ga ojee oryp ma'e 'gã mopy'ata'wau— 'jau 'gã ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","A'ere ywagipewara 'gã awau ojewya ywag ipe nũ. A'eramũ wyra jara 'gã 'jau ajaupe: —Pe'je ajee soo Perẽi me 'ga resaka 'ũ. “Pe'je pejewau 'ga resaka, e'i Janeruwarete 'ga pẽ nupe”, e'i ako ywagipewara 'ga janee ko. A'eramũ jane jarewau 'ga resaka— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A'eramũ futat 'gã awau jupiwewe futat kunumĩakyra 'ga resaka. Owaẽm ire 'gã 'ga resaka. Mari ẽẽ resaka Jose 'ga reewe. Kunumĩakyra 'ga resaka ywya'ri pype 'ga ruwamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","18","'Ga resag ire 'gã awau 'ga mome'wau amunaw ipewara 'gã nupe: —Ywagipewara 'ga 'ut ojesaukaa oree ko. “Pẽ katu'okara 'ga u'at Perẽi me ko”, e'i 'ga oree ko. A'eramũ ore arajua 'ga resaka. A'ere a'jea'jea futat 'ga 'i ra'e. 'Ga 'eawer imũ etee futat ore kunumĩakyra 'ga resagi— 'jau 'gã 'gã nupe. A'eramũ 'gã aipo ojeupe 'gã 'eramũ ajemogyau oporesagamũ 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari ẽẽ 'upa etee enupa 'gã porogytaramũ. Wapyakau 'upa 'gã je'eg are. Wea'aramũ etee 'upa wa'yra 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A'ere wyra jara 'gã awau ojewya nũ. —Ene te 'ã eneresage oree— 'jau 'gã awau Jarejuwarete 'ga upe, 'ga muorypa akou. —Mama'e esagea te 'ã eremome'u oree. Nitywi 'ga amũ ene 'jawe— 'jau 'gã awau akou pe rupi 'ga upe. —Ywagipewara 'gã nemimome'ufer imũ etee futat jane esagi— 'jau 'gã ajaupe, awau akou pe rupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","'Ga 'ar ire 'gã majepeja etee morowykye'ema magwapa. A'ere 'gã 'ga mojewagukaa 'ga upe. Ywagipewara 'ga je'egawer imũ etee futat 'gã 'ga re'roka, Jejui 'jau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","'Ga mojewag ire 'ga ru'wyra 'ga 'ga rerawau Jerusareg ipe 'ga y ẽẽ retee. 'Ga rerawau esaukaa mainana 'ga upe. Moisesi 'ga 'eawer imũ etee futat 'gã 'ga rerawau esaukaa mainana 'ga upe Jarejuwarete 'ga rowase. Ymã te Moisesi 'ga 'i 'gã nupe rakue: “Pẽna'yr ypya nipo Janeruwarete 'ga remiayuwa futat. A'eramũ pẽẽ 'ga 'ar ire 'ga rerawau esaukaa mainana 'ga upe, Jarejuwarete 'ga rowase”, 'jau 'ga ka'arana kwasiaa inuga 'gã nupe rakue. A'eramũ 'gã a'eramũ 'ga rerawau esaukaa 'ga upe, Moisesi 'ga je'egawer imũ etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ymã te Moisesi 'ga ka'arana kwasiari inuga ee rakue. “Mukũja ki pykaua peroo mainana 'ga upe iapyaukaa Jarejuwarete 'ga upe pejeja'yra 'arauwe”, 'jau 'ga 'gã nupe rakue. “Pykau tywe'emamũ mukũja wyra'i rerawau iapyau”, 'jau 'ga ikwasiaa inuga rakue. A'eramũ Jejui 'ga ru'wyra 'ga 'ga rerawau erosou Jarejuwarete 'ga mogytaaw ipe. Mukũja pykaua 'ga erawau erosou ojeupi mainana 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","27","Poje Janeruwarete 'ga 'Agesage oje'ega Simeão 'ga upe: —Ere ewau esou peu, jemogytaaw ipe— 'jau Janeruwarete 'ga 'ga upe. A'erauwe 'ga awau osou 'ga mogytaawa pype. Awau osou Jejui 'ga ru'wyra 'ga resaka 'ga y ẽẽ retee. Jejui 'ga nanẽ 'ga esaka nũ. 'Ga resakawe 'ga 'ga rupia 'ga mua ojywa pe. A'erauwe 'ga oje'ega monou Jarejuwarete 'ga upe. Jerusareg ipewara 'ga futat Simeão 'ga. Esage ma'e 'ga te Jarejuwarete 'ga upe. Jarejuwarete 'ga upe oporogyta ma'e 'ga te poromũ, Simeãonamũ. Simeão 'ga akou ae katu'okara 'ga rura rapesaka rakue. Janeruwarete 'ga remimura 'ga rapesaka 'ga akou. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","A'eramũ 'ga Jejui 'ga wuja rupia ojywa pe. A'eramũ futat 'ga oje'ega monou Jarejuwarete 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","—Ku'jyp. Ene te 'ã mama'ea ereapo oree rakue. Ene te 'ã mama'e jararetea. Nitywi futari 'ga amũ ene 'jawewara. Ene te 'ã mama'ea ereapo katu katu ore upe rakue. Ymã te ako Ene'agesage je'egi jee ikue: “Emanũme'ẽwe nipo ae katu'okara 'ga ereesak”, 'jau ako ene jee ikue. A'efer imũ etee je 'ã 'ga resagi. 'Awamũ je 'ga resagi tejeau. A'eramũ je 'awamũ temanũarũmũ. Aesak je 'ga enu'ama 'awamũ. A'eramũ je tewau ene pyri 'awamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","'Ga nipo 'ara 'jawe futat. Sã'ã ae najuejue etee mama'e resaga 'arimũ. Nan tee futat nipo 'ga Jarejuwarete 'ga kwaawukari 'gã nupe, 'ga je'ega mome'wau judeue'ema 'gã nupe. Jejui 'ga 'ã judeua. A'eramũ nipo tesirũmera 'gã Jejui 'ga ree te judeu 'gã pojeupa ajemogyau. Eneremiayuwa 'gã pojeupa ajemogyau— 'jau 'ga oje'ega Jarejuwarete 'ga upe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aipo 'ga 'eramũ Jejui 'ga jara 'gã oporesagamũ Simeão 'ga ree. —Ma'eramũ 'ga aipo 'jau janera'yra upe 'ũ?— 'jau 'gã ajemogyau oporesagamũ 'ga ree, 'ga porogyta 'ga 'amamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","A'ere Simeão 'ga 'jau Jarejuwarete 'ga upe nũ: —Ejejuka esage ki 'ga jara 'gã nee, 'gã nekoramũ— 'jau 'ga oje'ega monou Jarejuwarete 'ga upe. A'eramũ futat Jejui 'ga monou 'ga y ẽẽ upe nũ. A'eramũ futat Simeão 'ga 'jau Mari ẽẽ upe: —Janeruwarete 'ga 'Agesagea 'ã kunumĩa amut enee rai'i— 'jau 'ga ẽẽ upe. —A'ere nipo 'ga aranuw ire amumera 'gã niporomutari 'ga ree. 'Ga rerekou tyweaete nipo 'ga rekoramũ— 'jau 'ga imome'wau ẽẽ upe. —Aipo resaga nipo wayeteramũ enee. Sã'ã ae jepokysia tuwiuu raya. Nan futat nipo ayramũ enee— 'jau 'ga imome'wau ẽẽ upe u'ama. —'Ga rereko tywearera 'gã nipo Janeruwarete 'ga omomap. Amumera 'gã etee te nipo iporomutat enera'yra 'ga ree— 'jau 'ga ẽẽ upe imome'wau. —A'eramũ futat nipo 'gã aku'iramũ ajemogyau 'ga ree iporomutat ma'e 'gã nerekou— 'jau 'ga ẽẽ upe. A'eramũ Simeão 'ga 'jau 'gã nupe: —Anure te nipo Janeruwarete 'ga janerea'awa kwaap katu katuukari janee. Ae nokwaawa'uweri ajuea'awa. 'Ga tee okwaap katu katuukat aerea'awa ae upe— 'jau 'ga 'gã nupe imome'wau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","'Ga porogyta 'ga 'amamũ kũjã ẽẽ mũ 'ua 'gã nerowyka. Wãiwĩ ẽẽ 'ua 'gã nerowyka. Jejui 'ga resakawe wãiwĩ ẽẽ oje'ega Jarejuwarete 'ga upe: —Ku'jyp. Eneresage 'ã oree. Ore katu'okara kĩã eremut oree rai'i— 'jau Ana ẽẽ 'ga upe u'ama. A'eramũ ẽẽ 'jau ojepyriwara 'gã nupe: —'Awamũ nipo 'ã kĩã rekoi janee. Janeruwarete kĩã remimurera kĩã futat u'at rai'i— 'jau ẽẽ ojepyriwara 'gã nupe imome'wau. —Kĩã futat nipo jane katu'ok, Jerusareg ipewaramũ— 'jau ẽẽ 'gã nupe. Ana ẽẽ Jarejuwarete 'ga je'ega mome'wara futat. Ẽẽ ruwa 'ga rera Fanueu. Aseri 'ga juapyrera ẽẽ. Ẽẽ iwãiwĩ gatu gatu te. Oitẽtai kwaturu kwara amu'at. Ana ẽẽ omenaat rakue. A'ere sete kwara magwaw ire, ẽẽ mena manũi ẽẽ wi. A'eramũ ẽẽ akou Jarejuwarete 'ga mogytaaw ipe. Jarejuwarete 'ga upe oje'ega 'ga muorypa akou. —Ene te 'ã eneresage oree— 'jau ẽẽ 'ga upe 'ũina. —Nitywi futari kĩã amũ ene 'jawe. Ene tee futat te 'ã eneresage oree— 'jau ẽẽ oje'ega 'ga upe akou. Ojemi'ware'ema ẽẽ 'ga upe oje'eg enune. Ojety'ajaga etee te futat akou 'ga upe oje'egaw ipe. Aipo kũjã ẽẽ futat Jejui 'ga mome'wau ojepyriwara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ẽẽ porogytapaw ire Jejui 'ga jara 'gã 'ga rerawau mainana 'ga upe mukũja pykaua retee. Moisesi 'ga 'eawer imũ etee futat 'gã erawau imonou mainana 'ga upe. A'eramũ mainana 'ga pykau apyau Jarejuwarete 'ga muorypawamũ. A'ere Jose 'ga Mari ẽẽ retee wa'yra 'ga rerawau erojewya Nasare pe nũ. Nasare 'jawa amunawa 'upa Garireja ywy pype. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Peu futat Jejui 'ga waranupa. 'Ga wujawuja'ia we futat u'akwaakwaawamũ. 'Ga Ruwarete 'ga ojejukau 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Maraka apoawa upe iwaẽmauwe Jejui 'ga jara 'gã awau Jerusareg ipe. Wea'aramũ awau ajatykau. “Janeruwarete 'ga 'ã esage janee. Ymã te 'ga 'ã janepytuna 'gã nenũ'ẽi Egitu ywy awi rakue”, 'jau 'gã ajaupe wea'aramũ ee. Aipoa aejatykaawa rera pasikwa. Kwara 'arauwe 'gã awau ajatykau wea'aramũ opytunera 'gã nenũ'ẽawer are. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tusi kwara Jejui 'ga imu'ar ire 'ga jara 'gã 'ga rerawau poromũ ojeupi. Majepeja etee 'gã morowykye'ema magwapa peu ajatykaaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Maraka teepaw ire 'gã okwasi'wau awau oje'wyr ipe. A'ere Jejui 'ga nooi 'gã nupi. A'e pe 'ga pytai 'gã nui. Nokwaawi 'ga jara 'gã 'ga pytaa. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ojewyaw ipe Mari ẽẽ 'ga resake'ema. A'eramũ ẽẽ 'jau ojeupe: “Kũima'efera wã nupi nipo turi re'ã”, 'jau etee ẽẽ ojeupe. A'eramũ ẽẽ weae'emamũ 'ga ree. Awau akou ko'aramuku watau. Awau 'gã peu okaaruwamũ pe aje. Okaarupaw ipe 'gã 'ga rekaa. —Peesak te jera'yra kĩã ra'e?— 'jau ẽẽ opytuna 'gã nupe. —Naani nũ ĩ— 'jau etee 'gã ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","'Ga resake'emawe 'ga jara 'gã awau ojewya 'ga rekaa Jerusareg ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mukũi 'gã osea 'ga rekaa. Imuapyra rupi 'gã awau Jarejuwarete 'ga mogytaaw ipe 'ga rekaa. A'e pe 'gã 'ga resaka. Moromu'jara 'gã nupe 'ga 'ũina oporogytau. A'eramũ 'gã a'e pe 'ga renamũ, awau owaẽma 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A'eramũ moromu'jara 'gã oporesagamũ ajemogyau 'ga ree: —Tete 'ga 'akwaaweteramũ, oporogytau 'ũ— 'jau 'gã ajaupe ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","'Ga jara 'gã nanẽ oporesagamũ etee 'ga ree nũ. A'eramũ 'ga y ẽẽ oje'ega 'ga upe: —Ma'eramũ ene epytau rai'i rã? Erejekarukat oree kĩ'ĩ— 'jau ẽẽ 'ga upe. —Arajemuaẽm ore ene ree kĩ'ĩ— 'jau 'ga y ẽẽ 'ga upe. —“Oka'jam nipo 'ã rai'i”, aru'e ore arakou ene rekaa kĩ'ĩ— 'jau 'ga y ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—Ma'eramũ pẽẽ je rekaa ĩ? 'Au te je rekoi Tejuwarete 'ga rog ipe tepytau nũ ĩ— 'jau 'ga oy ẽẽ upe oje'ega wekat ẽẽ rekoramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","A'ere 'gã naeapyoi 'ga je'eg are aipo 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A'eramũ futat 'gã 'ga rerawau oje'wyr ipe Nasare pe nũ. Mari ẽẽ akou wea'aramũ wa'yra 'ga ree, 'ga muawer are. ");
INSERT INTO kyzNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","'Ga ru'wyra 'ga futat 'ga muaranupa 'ga y ẽẽ retee. Jejui 'ga awau waranupa, 'gã je'eg imũ etee futat mama'e apou akou. Wenuw etee futat 'ga 'gã je'ega. U'akwaawa 'ga erawau eruaranupa. A'eramũ 'gã najuejue etee futat 'ga futaa. Janeruwarete 'ga nanẽ 'ga futaa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Amunawe'em ipe Juã 'ga rekoramũ Janeruwarete 'ga oje'ega 'ga upe rakue: —Ekwap jeje'ega mome'wau 'gã nupe— 'jau Janeruwarete 'ga 'ga upe rakue, Sakari 'ga ra'yra 'ga upe rakue. —Ikwaapare'ema 'gã nupe jeje'ega mome'wau ewau— 'jau 'ga 'ga upe. Tiperiu 'ga te futat 'wyriarareteramũ 'ũina romanũ 'gã nupe. Kĩsi kwara magwapa 'ũina 'wyriar ymanamũ 'gã nupe. A'eramũ 'ga 'wyriarareteramũ 'ga renauwe futat tesirũmera 'gã 'ga imogyau 'wyria'riramũ 'gã nupe. Põsiu Piratu 'ga 'ũina 'wyriaramũ Judeja ywy pewara 'gã nupe. Erote 'ga 'ũina 'wyriaramũ Garireja ywy pewara 'gã nupe. Erote 'ga rewirera 'ga, Filipe 'ga 'ũina 'wyriaramũ Iturea ywy pewara 'gã nupe. Trakoniki ywy pewara 'gã nupe nanẽ nũ. Lisanias 'ga 'ũina 'wyriaramũ Apireni ywy pewara 'gã nupe. Aipo 'gã jemogyramũ Anasi 'ga akou 'wyriaramũ mainana 'gã nupe Kaifasi 'ga retee. Aipo 'gã jemogyramũ Janeruwarete 'ga oje'ega Juã 'ga upe: —Ekwap jeje'ega mome'wau 'gã nupe— 'jau 'ga 'ga upe, Sakari 'ga ra'yra 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ojeupe 'ga porogytapaw ire Juã 'ga awau akou kwe pe. Jotãuy pewara 'gã nupe 'ga awau Jarejuwarete 'ga je'ega mome'wau akou. —Peru'arasig tee awi pejetywera. Pepoit tãmẽjẽ pejetywer awi. A'eramũ je pejetywer awi pepoir ire je pẽ pymĩãu 'y pe. A'eramũ Janeruwarete 'ga pẽtywera moia pẽ nui— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isai 'ga je'eger imũ etee futat Juã 'ga awau imome'wau 'gã nupe nũ. Ymã te 'ã Janeruwarete 'ga je'egi Isai 'ga upe rakue. A'eramũ 'ga ojeupe 'ga 'e kwasiaa inuga ka'aran are 'gã nupe rakue: “Peu 'ga amũ rekoi wafukaita amunawe'em ipe. Janeruwarete 'ga porogyta are ae mu'jau, Jarejararete 'ga rura futarukaa 'gã nupe. ‘Pe'je Janejararete 'ga rape katu'oka imonou 'ga renune. Pepyo esage etee futar iki imonou imojewarawe'em. Ywyaty'ria nanẽ ene imomẽmõumap nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ywyperewa ene imatyneema 'jau. A'eramũ akware'emamũ futat pe awau ywy kwara matyneem ire. Ikwakwara ene imomẽmõu’, 'jau 'ga wafukaita. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A'eramũ nan ene iaporamũ, 'gã najuejue etee futat ae katu'okara 'ga kwaapa, ‘A'jea futat Janeruwarete 'ga ae katu'ogi ra'e’, e'i nipo 'gã 'gã nupe najuejue etee”, 'jau Isai 'ga ikwasiaa Juã 'ga ree inuga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A'eramũ 'gã awau kwaiwete ajatykau Juã 'ga ree numiamũ ojepymĩãukaa 'ga upe numiamũ. “'Y pe 'ga je pymĩ re nipo Janeruwarete 'ga je rerekou tywere'ema jetywer are”, 'jau 'gã ojeupe numiamũ. A'ere Juã 'ga 'i etee 'gã nupe: —Naani. Pejetywer awi ra'ne pepoit. A'ere te je pẽ pymĩ— 'ga 'i etee 'gã nupe ojee 'gã jatykaramũ. A'eramũ 'ga 'jau 'gã nupe nũ: —Janeruwarete 'ga imara'ne pẽ nee. Pẽtywer are 'ga mara'neramũ pẽ nee. A'eramũ nipo 'ga pẽ nerekou tyweaete pẽtywer are. “Ene'me awi”, pe'je awi jee. A'jea futat nipo 'ga pẽ nereko tyweretei. “Nore rereko tywera'uweri 'ga”, pe'je awi. A'jea futat 'ga pẽ nereko tyweri nipo— 'jau Juã 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","—Pe'je pejewau mama'e esage mũ apou pejetywer awi pejepoira resaukaawamũ kũi— 'jau 'ga oje'ega moywyrafena 'gã nupe. —“O'meramũ 'ga 'i”, pe'je kasi jee ne. “Je 'ã Abraão 'ga juapyrera te. A'eramũ 'ga a'eramũ je rerekou tywere'em”, pe'je kasi ne. Janeruwarete 'ga ifutar ire amunipo 'ã 'ga ita mu'jagi Abraão 'ga juapyreramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sã'ã ae 'ywa i'a a'wyre'ema iypy mosoga. A'eramũ erawau imonou imomoa tata pe. Nan tee futat 'ga pẽ nerekoi pejetywer awi pepoire'emamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A'eramũ 'gã 'jau Juã 'ga upe: —Ma'ja ajee ore aruapo a'eramũ orotywer awi oropoiawamũ 'ũ?— 'jau 'gã 'ga upe. —Au'je ki pejejee etee pejejea'ar ire. Najuejue etee ki 'awamũ pejejuka esage pejejuee. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Taity kwaiwete ma'eramũ pemono ape taitye'ema 'gã nupe. Emi'uram kwaiwete ma'eramũ pẽẽ mama'e monou emi'urame'ema 'gã nupe nũ— 'jau 'ga 'gã nupe, aipoa ojeupe 'gã 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A'eramũ 'wyriara upe ka'aranũũ pyykara 'gã oje'ega Juã 'ga upe nũ: —Ma'ja ajee ore aruapo orojee, orotywer awi oropoiawamũ nũ'ũ?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A'eramũ Juã 'ga 'jau ka'aranũũ pyykara 'gã nupe: —Au'je ki ka'aranũũ muruu re 'gã nui. 'Wyriara je'eg imũ etee futar iki ka'aranũũa pepyyk pejekou 'ga upe— 'jau 'ga 'gã nupe, aipo ojeupe 'gã 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","A'eramũ jefaruu 'gã 'jau 'ga upe nũ: —Ore nũ'ũ? Ma'ja ajee ore aruapo orotywer awi oropoiawamũ 'ũ?— 'jau 'gã 'ga upe. A'eramũ Juã 'ga 'jau jefaruu 'gã nupe: —“Ka'aranũũa tejeupe imure'emamũ je ene nupãi ne”, ere kasi 'awamũ 'gã nupe ne, 'gã je'ẽwu'jage'ema ne. Mama'ea a'jea etee futat imome'wau ekou. “Temepy'i'ia je nafutari”, 'jawe'em pẽẽ pejekou. “Temepyuua te je afutat”, 'jawe'em futat pejekou— 'jau 'ga jefaruu upe. —Pejeporowyky repy are etee futat pẽnekõẽãi pejekou— 'jau 'ga 'gã nupe. “Topoit tetywer awi 'jau” 'jara 'gã jefaruu 'gã nupe 'ga 'jau poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aipo 'gã nupe Juã 'ga 'eramũ 'gã amũ 'upa 'ga porogyta renupa. —Janeruwarete 'ga remimurera 'ga nipo kweramũ ki sa— 'jau 'gã ajaupe 'upa. —'Ga futat nipo ae katu'okara— 'jau 'gã 'upa ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aipo 'gã 'eramũ Juã 'ga enupa. A'eramũ 'ga oje'ega 'gã nupe: —Naani. Naae katu'okara rũi je. Naje rũi 'ga remimurera— 'jau 'ga 'gã nupe, aipo ojeupe 'gã 'eramũ. —Naani. Janeruwarete 'ga remimura 'ga 'ã kũima'eeteetea te— 'jau 'ga imome'wau 'gã nupe. —Je naani. Je akotee'i ma'ea te. Apoat te je 'ga tekou— 'jau 'ga 'gã nupe u'ama. —Je 'ã a'jea futat apymĩ pẽẽ 'y pe tekou. A'ere je rewiri 'ut ma'e 'ga te Jarejuwarete 'ga 'Agesage muri pẽ nupe— 'jau 'ga 'gã nupe imome'wau. —'Ga te amut 'Uwarete 'ga 'Agesagea werowiaaramũ pẽ nupe. Werowiare'ema 'gã nupe te ajee 'ga namuri futari U'aga. Wereko tywerete futat nipo 'ga 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sã'ã ae juowuuran ape 'oga. A'eramũ 'ã ae a'ỹi esage imũ'jãu jui. A'eramũ 'ã ae iapefera monou tata pe. Nan tee futat nipo 'ga werowiare'ema 'gã monou mama'eukwaawa rapyaw ipe. Aipoa tata nowewi futari. Nitywi futari imowepara 'ga amũ— 'jau 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A'eramũ Juã 'ga 'jau 'gã nupe nũ: —Peru'arasig tee awi pejetywera. Pepoit pejetywer awi. Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoia pẽ nui— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","A'eramũ 'gã a'eramũ kwakwai'i opoia otywer awi. A'eramũ Juã 'ga otywer awi 'gã poiramũ 'gã pymĩãu 'y pe. 'Gã pymĩmaw ire Jejui 'ga 'ua 'gã pymĩaw ipe owaẽma 'ga upe. A'eramũ Juã 'ga Jejui 'ga monou ipymĩãu 'y pe. Juã 'ga opymĩ re Jejui 'ga oje'ega monou u'ama 'Uwarete 'ga upe. Ojeupe 'ga je'ega monoramũ Janeruwarete 'ga U'agesage mua 'ga upe. Pykau 'jawe 'ua ojypa 'ga jasi'y'warimũ wapyka. Ywag awi 'ga upe U'agesage jywamũ Janeruwarete 'ga oje'ega Jejui 'ga upe. —Ene te 'ã Jera'yraretea. Ene 'ã jeremifutararetea. Ene 'ã je muorypararetea ejee— 'jau 'ga wa'yra 'ga upe oje'ega mua. Anure Erote 'ga Juã 'ga munewukaa 'gã nupe. Erote 'ga 'wyriaramũ peuwara 'gã nupe. A'eramũ 'ga 'ga munewukaa. Erote 'ga wewirera 'ga remireko ẽẽ pojekau 'ga wi, Erotiasi ẽẽ pojekau 'ga wi. A'eramũ Juã 'ga 'jau 'ga upe: —Nia'wyri nanuara. Ejewirera remirekoa 'ã erepojeka 'ga wi. Nenea'wyri ene ra'e. Kwaiwete enetywera ra'e— 'jau Juã 'ga 'ga upe. A'eramũ 'ga a'eramũ Erote 'ga mamara'neukaa ojee. A'eramũ 'ga Juã 'ga munewukaa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Trĩta kwara magwaw ire Jejui 'ga awau 'gã mu'jau 'Uwarete 'ga porogyta are. Jose 'ga Jejui 'ga ru'wyra. Eli 'ga Jose 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matate 'ga Eli 'ga ruwa. Levi 'ga Matate 'ga ruwa. Meki 'ga Levi 'ga ruwa. Janai 'ga Meki 'ga ruwa. Jose 'ga Janai 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiasi 'ga Jose 'ga ruwa. Amosi 'ga Matatiasi 'ga ruwa. Naum 'ga Amosi 'ga ruwa. Esi 'ga Naum 'ga ruwa. Nagai 'ga Esi 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maate 'ga Nagai 'ga ruwa. Matatiasi 'ga Maate 'ga ruwa. Semei 'ga Matatiasi 'ga ruwa. Jose 'ga Semei 'ga ruwa. Jota 'ga Jose 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanã 'ga Jota 'ga ruwa. Resa 'ga Joanã 'ga ruwa. Soropapeu 'ga Resa 'ga ruwa. Saratieu 'ga Soropapeu 'ga ruwa. Neri 'ga Saratieu 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Meki 'ga Neri 'ga ruwa. Ati 'ga Meki 'ga ruwa. Kosã 'ga Ati 'ga ruwa. Ematãu 'ga Kosã 'ga ruwa. Eri 'ga Ematãu 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josue 'ga Eri 'ga ruwa. Eriese 'ga Josue 'ga ruwa. Jorim 'ga Eriese 'ga ruwa. Matate 'ga Jorim 'ga ruwa. Levi 'ga Matate 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeão 'ga Levi 'ga ruwa. Juda 'ga Simeão 'ga ruwa. Jose 'ga Juda 'ga ruwa. Jonã 'ga Jose 'ga ruwa. Eriakĩ 'ga Jonã 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Merea 'ga Eriakĩ 'ga ruwa. Mena 'ga Merea 'ga ruwa. Matata 'ga Mena 'ga ruwa. Natã 'ga Matata 'ga ruwa. Davi 'ga Natã 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jese 'ga Davi 'ga ruwa. Opete 'ga Jese 'ga ruwa. Poasi 'ga Opete 'ga ruwa. Sara 'ga Poasi 'ga ruwa. Nasom 'ga Sara 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminatape 'ga Nasom 'ga ruwa. Amin 'ga Aminatape 'ga ruwa. Arni 'ga Amin 'ga ruwa. Esrom 'ga Arni 'ga ruwa. Peres 'ga Esrom 'ga ruwa. Juda 'ga Peres 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jako 'ga Juda 'ga ruwa. Isaki 'ga Jako 'ga ruwa. Abraão 'ga Isaki 'ga ruwa. Tera 'ga Abraão 'ga ruwa. Nako 'ga Tera 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruki 'ga Nako 'ga ruwa. Ragau 'ga Seruki 'ga ruwa. Faleki 'ga Ragau 'ga ruwa. Eperi 'ga Faleki 'ga ruwa. Sara 'ga Eperi 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainã 'ga Sara 'ga ruwa. Arfasate 'ga Kainã 'ga ruwa. Sem 'ga Arfasate 'ga ruwa. Nue 'ga Sem 'ga ruwa. Lameki 'ga Nue 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusarem 'ga Lameki 'ga ruwa. Enoki 'ga Metusarem 'ga ruwa. Jarete 'ga Enoki 'ga ruwa. Maleleu 'ga Jarete 'ga ruwa. Kainã 'ga Maleleu 'ga ruwa. ");
INSERT INTO kyzNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enosi 'ga Kainã 'ga ruwa. Sete 'ga Enosi 'ga ruwa. Atãu 'ga Sete 'ga ruwa. Janeruwarete 'ga Atãu 'ga ruwa. Atãu 'ga ae ypy ypya. Janeruwarete 'ga remiapo ypyfera 'ga. A'eramũ 'ga a'eramũ Atãu 'ga ruwa Jarejuwaretea futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","'Y pe 'ga jepymĩ re Janeruwarete 'ga 'Agesagea Jejui 'ga rerawau amunawe'em ipe 'ga rerekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kwarẽta 'ara 'ga imagwapa akou ojemi'ware'ema. A'eramũ 'ga opy'arayparamũ akou. A'e pe 'ga rekwaw ipe mama'eukwaawa 'wyriara 'ua 'ga resaka. “Taesak 'ga poira 'uwa 'ga rerowiar awi 'jau kwy”, 'jau ojeupe etee futat. “Teje'ega taenuwukat esaka 'ga upe 'jau kwy”, 'jau 'ũina ojeupe etee futat numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A'eramũ oje'ega Jejui 'ga upe: —“Ku'jywa 'ga ra'yra je”, ere 'ã. A'eramũ ene ita mu'jaga ejemi'uramamũ— 'jau mama'eukwaawa 'wyriara Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aipo ojeupe 'eramũ Jejui 'ga 'jau jupe: —Naani. Naene rũi je arowiat tekou. Tejuwarete 'ga etee te je arowiat tekou. Jeruwarete 'ga e'i oree: “Nawemi'uram are tee rũi ae rekoi”, 'jau oree jepi— 'jau 'ga jupe. —Oreruwarete 'ga te 'ã ae mogoara— 'jau etee 'ga jupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A'ere mama'eukwaawa 'wyriara 'ga rerawau 'ga rerojeupia ywytyr apyte'rarimũ nũ. Peu 'ga rerowaẽm ire mama'eukwaawa 'wyriara ywy resaukaa 'ga upe. Mama'ea ipype ajemogy ma'e reewe futat esaukaapap 'ga upe. Kamẽsĩete futat ywy pypewara resaukaa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","—Ejuwarete 'ga rerowiar awi ene poir ire 'agera tomonopap enee 'jau— 'jau mama'eukwaawa 'wyriara Jejui 'ga upe. —Tejerowiaramũ tomonopap enee 'jau— 'jau 'ga upe oporogytau, mama'e resaukaa 'ga upe. —Ymã te ako 'ga 'agera muri jee ikue. A'eramũ je ene tejerowiaramũ 'agera monoupap enee nũ. A'eramũ je ene mogou 'wyriarareteramũ 'agera mama'e upe. A'eramũ ene e'ỹina jeje'eg imũ etee futat 'wyriaramũ 'gã nupe. Je te omono enee temuoryw ire— 'jau mama'eukwaawa 'wyriara Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A'eramũ aipo ojeupe 'eramũ Jejui 'ga 'jau jupe: —Naani. Ymã Jeruwarete 'ga oje'ega kwasiarukari ka'aran are 'ga amũ upe rakue. “Je te 'ã Pẽjararetea. Je te 'ã Pẽnuwaretea. A'eramũ ki pẽẽ jeje'ega etee enupa pejejemogyau. Je te ki je muoryp pejepe pejejemogyau”, 'jau 'ga ikwasiarukaa 'ga amũ upe rakue— 'jau etee 'ga jupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A'ea ywyty'rar awi mama'eukwaawa 'wyriara Jejui 'ga rerawau Jerusareg ipe nũ. Janeruwarete 'ga mogytaawa apyte'rarimũ 'ga rerawau erojeupia. Ywatewate 'ga mogytaawa. A'eramũ 'jau 'ga upe nũ: —Ku'jywa 'ga ra'yra 'ã ene. A'eramũ ene ewau epoa 'aw awi. Nerepena'uweri ewau. Jaruete ereo e'aa. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Eneruwa 'ga futat oje'ega okwasiarukat pẽ nee rakue: “Tejepyriwara 'gã je omono enee. A'eramũ 'gã ojejukau ene ree. A'eramũ ene ejemokanãje'ema ewau e'aa. Epya miamũ ene imokanãje'ema ita are”, 'jau ako Ku'jywa 'ga ka'arana kwasiarukaa wa'yra 'ga ree ikue— 'jau mama'eukwaawa 'wyriara Jejui 'ga upe. “Omorytee pa je 'ga kwy”, 'jau ojeupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A'ere Jejui 'ga 'i etee jupe: —A'jea futat aipo 'ea numiamũ. A'ere je narowiari futari eneje'ega. Jeruwarete 'ga ka'arana okwasiarukat 'ga amũ upe nanẽ nũ: “A'jea futat sipo ajee 'ga jejukai je ree, pe'je kasi jee ne, je rerowiare'ema ne”, e'i 'ga ikwasiarukaa ajepeja 'ga upe rakue— 'jau 'ga jupe. —A'eramũ je eneje'ega mojerowiare'ema— 'jau Jejui 'ga mama'eukwaawa 'wyriara upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","A'eramũ mama'eukwaawa 'wyriara awau Jejui 'ga wi. “Anurenure'i nipo tomorytee 'ga 'jau kwy”, 'jau awau ojeupe etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Mama'eukwaawa 'wyriara ojewi io re Jejui 'ga ojewya awau Garireja ywy pe nũ. 'Ga Ruwarete 'ga 'Agesagea 'ga rerekou. A'eramũ 'ga a'eramũ awau kwe pe watau akou. Judeu 'gã jatykaaw ipe 'ga awau akou 'gã mu'jau 'Uwarete 'ga je'eg are. A'eramũ 'ga renuparera 'gã 'jau ajaupe: —Ae mu'e katuram 'ga ra'e nũ'ũ— 'jau 'gã ajaupe. —'Ga porogyta are pa 'ã jeporenuwiweramũ nũ. Esage te 'ã 'ga porogyta ra'e a'i kũi— 'jau 'gã ajaupe. A'eramũ 'gã 'ga rera mokwasi'wau. —Esage 'ga porogyta ra'e— 'jau 'gã 'ga rera mokwasi'wau amunawa pype. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","A'ere Jejui 'ga awau ojewya oje'wyr ipe nũ, Nasare pe nũ. Waranupawer ipe 'ga awau ojewya nũ opytuna 'gã nesaka. Morowykye'ema rupi 'ga awau osou judeu 'gã jatykaaw ipe wapyka oporogytau 'gã nupe. Wemiapo etee futat 'ga iapou 'gã nupe. 'Gã jatykapaw ire 'ga awau afu'ama 'gã mogytaawa rowase katy. A'eramũ ajatykaawa raarana 'ga ka'arana monou 'ga po pe. A'ere 'ga ipypekau esaka. A'eramũ 'ga Isai 'ga remikwasiarer ipe ipypekau esaka. Isai 'ga Janeruwarete 'ga je'ega mome'warera rakue. A'eramũ 'ga oje'ega Isai 'ga upe rakue. A'eramũ Isai 'ga ojeupe 'ga je'egawera kwasiaa inuga ka'aran are. Aipoa ka'arana kwasiaripyrera Jejui 'ga imogytau 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Janeruwarete 'ga 'Agesagea je rereko”, 'jau 'ga u'ama imogytau. “'Ga 'ã je mono morogyta esage mome'waramũ itywerete ma'e 'gã nupe. 'Ga 'ã je mono moromunepawa pypewara 'gã mũ'jãukaa jee. 'Ga 'ã je mono eae'ema 'gã mamã'ẽukaa. 'Ga 'ã je mono 'gã nemirereko tywerete 'gã mũ'jãukaa 'gã nui jee. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","'Ga futat 'ã je mono, ‘'Awamũ Janeruwarete 'ga ae katu'ogi’ 'e mome'waukaa jee 'gã nupe”, 'jau 'ga imogytau u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Imogytapaw ire 'ga ka'arana mamana nũ. A'ere 'ga ka'arana monou ojeupe imuarera 'ga po pe nũ. 'Ga po pe imono re 'ga awau wapyka 'ũina. A'eramũ peuwara 'gã ajemogyau oporesagamũ 'ga ree. —Awỹi are te Isai 'ga ka'arana kwasiari rakue? “Je ree 'ga ikwasiari inuga rakue”, e'i sipo kwe 'ga 'i?— 'jau peuwara 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A'eramũ Jejui 'ga 'jau 'gã nupe: —'Ga remikwasiarer imũ etee futat je ruri— 'jau 'ga 'ũina wapyka oporogytau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A'eramũ 'gã 'jau ajaupe: —Kuu. Ae mu'e katuram 'ga ra'e nũ'ũ. Jane 'jawewara 'ga agawewi 'ã. A'etea 'ga morogyta esagea omome'u janee— 'jau 'gã aipo 'ga 'e 'ga renamũ. A'eramũ 'gã amũ 'jau: —NaJose 'ga ra'yra 'ga rũi nipo ki sa? Maran ajee 'ga ae mu'ei aipo 'jau ki 'ei— 'jau amumera 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A'eramũ Jejui 'ga 'jau 'gã nupe: —“Aeremiapoe'ema 'awamũ eapo amũ oree”, pe'je 'ã jee. “Kafanaũ pe 'ã ereapo futat. A'eramũ ene 'au nanẽ iapou nũ”, pe'je 'ã jee— 'jau 'ga 'gã nupe. —“Earanupawer ipe eapo oree”, pe'je 'ã jee. “Ojero'wu ma'e 'gã 'ã erekatu'ok rai'i. A'ere 'awamũ ene ejetee futat erejekatu'ok”, 'jau nipo pẽẽ jee. “Kafanaũ pe 'ã ojero'wu ma'e 'gã erekatu'ok rai'i. A'eramũ ene 'awamũ earanupawer ipe taetu nanuara apou oree. Ore 'ã enepytuna futat. A'eramũ ene epytunamũ taetu ore katu'oka. Taruesak orokatu'oga 'jau”, 'jau nipo pẽẽ jee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","—Janeruwarete 'ga je'ega mome'wara 'ga amũ oo kwe pe 'ga je'ega mome'wau. A'eramũ kwe pewara 'gã jẽmĩ 'ga je'ega rerowiaa. A'ere 'ga 'wyr ipewara 'gã jẽmĩ nuerowiari 'ga. 'Ga pytuna 'gã miamũ 'ga rerowiare'ema ajemogyau— 'jau Jejui 'ga oje'wyr ipewara 'gã nupe. —Nan tee futat kwe pewara 'gã je rerowiari. A'ere je'wyr ipewaramũ jẽmĩ naje rerowiari pejepe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","—Ymã te 'ã Janeruwarete 'ga Eliasi 'ga monoi ajepeja amunaw ipe rakue, Sarepata pe rakue. Sidoma ywy pe aipo 'upa. Peu futat 'ga 'ga monou kũjã ẽẽ upe rakue, imen manũ ma'efera ẽẽ upe rakue. NaIsraeu juapyrera rũi ẽẽ. A'etea Janeruwarete 'ga Eliasi 'ga monoukat imoporogytaukaa ẽẽ upe. “Ene ejot ekou jeremi'urama rerua jee”, 'jau 'ga ẽẽ upe. Muapyra kwara u'aa amana okyre'ema. A'eramũ 'gã nemi'urama opapa 'gã nui. A'eramũ 'gã a'eramũ ty'ara rerajemogyau— 'jau 'ga imome'wau ojepyriwara 'gã nupe. —Kwaiwete agawewi futat judeu 'gã jemogyi peu ty'ara rerajemogyi. A'etea Janeruwarete 'ga ẽẽ upe etee futat mama'e nomateepawukari. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nãnẽwẽjẽmĩ futat Janeruwarete 'ga judeue'ema 'ga amũ katu'oka 'ga pito'om awi nũ, Naamã 'ga katu'oka 'ga pito'om awi nũ. Kwaiwete agawewi futat ipito'om ma'e 'gã Israeu juapyrera 'gã jemogyi peu. A'etea 'ga judeue'ema 'ga etee okatu'ok 'gã nui. Siria ywy pewara 'ga 'ga ikatu'ogukaa Eliseu 'ga upe— 'jau 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","—Najudeu 'gã etee rũi 'ga opoat— 'jau Jejui 'ga 'gã nupe. A'e renupawe 'gã amara'neramũ Jejui 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","A'eramũ 'gã 'ga rerawau ywytyra rupi 'ga rerojeupia 'ga rerawau iapyte'rarimũ. 'Ga rerawau 'gã iããpyraya 'arimũ 'ga rerawau. —Simono 'ga imomoa ijukau— 'jau 'gã ajaupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","A'ere 'ga kwawi 'gã pyterimũ awau kwe pe 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ajepeja 'gã 'wyrarete pe Jejui 'ga awau, Kafanaũ pe. Garireja ywy pype Kafanaũ 'jawa amunawa 'upa. A'e pe 'ga awau 'gã mu'jau Jarejuwarete 'ga ree. Morowykye'ema rupi judeu 'gã mu'jau akou 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","'Wyriara 'jawe 'ga oporogytau 'gã nupe. A'eramũ 'ga 'gã moporesaka etee ojee. —Kuu. 'Ga pa'e aipo e'i ae mu'jau ra'e nũ— 'jau 'gã ajaupe. —NaMoisesi 'ga remikwasiarer are moromu'jara 'gã 'jawe rũi 'ga porogytai. Moisesi 'ga 'eawer are moromu'jara 'gã Moisesi 'ga 'eawer imũ etee futat 'gã ae mu'ei— 'jau 'gã ajaupe. —A'ere Jejui 'ga nanarũi. U'eawer imũ etee futat 'ga jane mueapyoi ee— 'jau 'gã ajaupe, oporesagamũ 'ga ree. 'Ga porogyta renupa etee ajemogyau, ojeupe 'ga 'eramũ. Judeu 'gã jatykaawa pype 'ga oporogytau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A'e pype mama'eukwaawa rerekwara 'ga amũ akou. A'eramũ 'ga muafukaita: ");
INSERT INTO kyzNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jejui! Nasare pe waranup ma'eramũ je 'i ene upe: Ma'ja are te ereko ki sa?— 'jau mama'eukwaawa Jejui 'ga upe. —Ore momapa te erejot ra'e? Akwaap je ene. Jane 'arimũwara 'ga remimurera te 'ã ene— 'jau mama'eukwaawa Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A'eramũ 'ga 'jau jupe: —Epije ene ekou. Ere ejepe'au 'ga wi— 'jau Jejui 'ga jupe. A'eramũ 'ga pirewara 'ga wi uẽmawamũ 'ga moywyrupãu. A'ere namuayrũi 'ga uẽma 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A'eramũ esakarera 'gã opiryyjamũ 'ga pirewara pe'aramũ. A'eramũ taetu 'gã oporesagamũ 'ga ree. A'eramũ 'gã 'jau ajaupe: —Kuu. Opãjẽ mũ futat ako 'ga mama'eukwaawa pe'ai 'ga wi ko— 'jau 'gã ajaupe. —Mama'eukwaawa miamũ 'ã pãjẽa. Jejui 'ga taetu pãjẽretea. Sã'ã 'ga mama'eukwaawa pe'aa 'ga wi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mama'eukwaawa wejue 'ga imonou 'ga wi. A'eramũ taetu Jejui 'ga rera okwasi'wau Garireja ywy pype kamẽsĩete, amunawa moymoyka. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Judeu 'gã jatykaaw awi uẽm ire Jejui 'ga awau Simão 'ga rog ipe. Simão 'ga rojo ẽẽ oro'yramũ 'upa. A'eramũ 'gã 'jau Jejui 'ga upe: —Waiwa ẽẽ iro'y 'upa. Ejot ẽẽ resaka ẽẽ ro'y awi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A'erauwe Jejui 'ga awau ẽẽ resaka. A'eramũ 'ga 'jau ẽẽ ro'y upe: —Ejepe'a ẽẽ wi— 'jau 'ga ẽẽ ro'y upe. A'erauwe ẽẽ ro'ya oia ẽẽ wi. A'erauwe ẽẽ afu'ama awau mama'e apou 'gã nupe 'gã mojemi'waa. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kaaruwamũ peuwara 'gã ojero'wu ma'e 'gã nerua esaukaa Jejui 'ga upe. Opoa etee agawewi 'ga imonou 'gã 'arimũ. A'etea ojero'wu ma'e 'gã ojekatu'okapap. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kwaiwete 'gã nui 'ga mama'eukwaawa pe'au. —Pejepe'a 'gã nui— 'jau Jejui 'ga 'gã pirewara upe. A'eramũ mama'eukwaawa awau wafukaita: —Jane 'arimũwara 'ga ra'yra te 'ã ene— 'jau wafukaita 'ga upe. —Orokwaaw ore ene— 'jau mama'eukwaawa wafukaita 'ga upe. Aipo ojeupe 'eramũ 'ga 'jau mama'eukwaawa upe: —Peafukai awi pejewau— 'jau 'ga jupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ai'iwe, ypytu'nĩnauwe, Jejui 'ga afu'ama awau awotywe'eme oje'ega monou 'Uwarete 'ga upe. A'ere Kafanaũ pewara 'gã nuri 'ga rekaa. 'Ua owaẽma 'ga upe. A'eramũ 'gã 'jau 'ga upe: —Ereo awi. Taruenup eneporogyta 'jau— 'jau 'gã 'ga upe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A'ere 'ga 'i etee 'gã nupe: —Naani. Peuwara amunaw ipe je oi nũ— 'ga 'i etee 'gã nupe, “Epyta” ojeupe 'gã 'eramũ. —Janeruwarete 'ga je mono kwe pe nũ. “Kwe pe ekwap je mome'wau 'gã nupe”, e'i 'ga jee. “Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoiri pẽ nui, pẽ mogyau wemiayuwamũ”, ta'e 'gã nupe 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Najuejue etee futat 'ga awau akou imome'wau 'gã nupe. Judeu 'gã jatykaaw ipe etee te futat 'ga awau akou imome'wau. Amunawa moyka imome'wau akou. —'Awamũ Janeruwarete 'ga 'wyriarareteramũ janee. Pejetywer awi pepoiramũ 'ga pẽ mogyi wemiayuwamũ— 'jau 'ga awau akou imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Genesare ypia reme'y'warimũ Jejui 'ga 'amamũ kwaiwete 'gã 'ua ajatykau 'ga ree, 'ga porogyta renupa. Ojopypypypyka 'gã 'ua. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A'eramũ Jejui 'ga yaruu resaka. Mukũi yaruua 'ua ojekoka 'upa. Yara jara 'gã ũ'jãumap yar awi. Taityuua 'gã ipireita 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A'eramũ Jejui 'ga awau u'aa Simão 'ga yara pype. —Ty pyteripe'i eyara emono jee— 'jau 'ga Simão 'ga upe. A'erauwe 'ga imonou ty pyteripe'i 'ga upe. A'erauwe Jejui 'ga wapyka oporogytau 'yisiga pypewara 'gã nupe 'gã mu'jau Jarejuwarete 'ga je'eg are. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Oporogytapaw ire 'ga 'jau Simão 'ga upe: —Typyu'i pype eyara emono— 'jau Jejui 'ga 'ga upe. —A'eramũ ene eirũ 'gã netee taityuu imomoa esaka— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Aruetyg ore koypytunamuku arakou ko nũ'ũ. A'ere nojejagi'i amũ oree ko nũ'ũ. A'ere 'ã ene te ere oree. A'eramũ ore imomoa esaka nũ'ũ— 'jau Simão 'ga 'ga upe. —Ko ajee ore imonoi esaka nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Etyg ypyrauwe ipira ojejaga taityuu pype 'gã nupe imatyneema. Kwaiwete ipira ojejaga ipype 'gã nupe. A'eramũ imonoroka werewi. Omonorok ja'wyja'wy futat. Ipira rarefe'ria te. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","A'eramũ 'gã ojepoetyka opytuna 'gã nupe: —Pejot imatãu ore pyri 'wei. Kwaiwete ipiraa. Norefuakari ore ee— 'jau 'ga 'gã nupe. A'erauwe 'gã 'ua 'gã nepejãna. 'Ua owaẽma 'gã nupe. A'eramũ 'gã imatãu 'gã pyri, mukũja yaruu matyneema ipira pyu. Ipira poyja yara motypywyka werewi 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Ipiraa ojeupe i'aramũ 'gã ajemogymogyau etee 'gã kyjea 'gã nerekou. Ipiraa 'gã moporesaka etee ojee. —Kuu. Kwaiwete ipiraa. Awỹja te koromũ ako nũ'ũ? Ae rekoetea nuapoa'uweri nanuara. Ku'jywa 'ga te nipo 'ã ako nũ'ũ— 'jau 'gã ajaupe. A'eramũ Simão Pedro 'ga awau wenupy'ãu wapyka Jejui 'ga rowase. —Eyry'gi je wi. Jetywet noko je jepi 'ja. Ene te 'ã eneresage. A'eramũ ene je pyri epytawe'em— 'jau Pedro 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tiago 'ga, Juã 'ga. Mĩmera 'gã Pedro 'ga porowyky irũa. 'Gã nuwa rera Sepeteu, Tiago 'ga ruwa, Juã 'ga retee. Mĩmera 'gã ajemogyau oporesagamũ ipira are. A'eramũ Jejui 'ga 'jau Simão 'ga upe, 'ga poirũ 'gã neewe: —Pẽporesag awi ee. 'Awamuete je 'ã pẽ mu'ei. Naipira rewara rũi pẽẽ 'awamũ. Jarejuwarete 'ga je'ega mome'wara te pẽẽ 'awamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A'erauwe 'gã yaruu mojekoka imonou 'yisig are. Peu etee futat 'gã yaruu rejaa inuga taityuu reewe. A'eramũ 'gã awau Jejui 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Amunawaretea mũ pype Jejui 'ga rekoramũ, ipito'om ma'e 'ga amũ 'ua owaẽma 'ga upe. Ymã te ipito'om ma'e 'gã nokoi futari opytuna 'gã pype rakue. Okyje 'gã ipito'om ma'e 'gã nui. 'Gã pito'oma pyyg awi 'gã kyjei. A'eramũ 'gã muku 'gã mỹina ojewi. A'eramũ aipo ipito'om ma'e 'ga Jejui 'ga resakawe awau ojenuga 'upa ywyu 'ga rowase. —Je resag ape, ki Ku'jyp. “Jejui 'ga ae katu'okara”, e'i 'gã jee. A'eramũ je tejua tejesaukaa enee. Je ree ejemuaẽmiweramũ je mokã'ẽ ape— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aipo ojeupe 'erauwe Jejui 'ga opo monou 'ga 'arimũ: —Ko ajee je ene mokã'ẽi 'wei— 'jau Jejui 'ga 'ga upe. Oje'arimũ 'ga po mono ypyrauwe okã'jãu 'ga pito'oma 'ga wi. A'eramũ futat 'ga pira ojekatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A'erauwe Jejui 'ga 'jau 'ga upe: —Eremome'u kasi emokã'ẽawera tekotee 'gã nupe ne. Ere ewau ejesaukaa mainana 'ga upe ra'ne. “Je resag ape. Jepito'oma okã'ẽ je wi”, ere ewau 'ga upe. “A'jea futat ra'e”, te'i 'ga enee 'jau, ene resaka 'jau— 'jau Jejui 'ga 'ga upe. —A'ere ene ejeymawa mũ rerawau 'ga upe. A'eramũ 'ga iapyau Jarejuwarete 'ga upe, 'ga muorypa enekã'ẽawer are— 'jau Jejui 'ga 'ga upe. —Moisesi 'ga 'eawer imũ etee futat ene ejeymawa mũ rerawau iapyaukaa Jarejuwarete 'ga muorypawamũ. Ejeymawa mũ rapyaukara ene ekã'ẽawera resaukaawa futat— 'jau Jejui 'ga ipito'om ma'efera 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'Ga mokã'ẽnamũ Jejui 'ga rera okwasi'wau amunawa moymoyka. A'eramũ futat 'gã ojeko'woka 'ga piara rupi ajatykaupap 'ga ree. 'Ga porogyta renupa 'ua, ojekatu'ogukaa nanẽ 'ua 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A'eramũ futat Jejui 'ga uẽma etee 'gã nui. Awotywe'eme 'ga awau oporogytau 'Uwarete 'ga upe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Anure 'gã ajatykau Jejui 'ga ree. Jerusareg awi, Garireja ywy awi, Judeja ywy awi. Mĩmer awi 'gã 'ua ajatykau 'ga ree. Fariseu 'gã amũ 'ua, Moisesi 'ga remikwasiarer are moromu'jara 'gã netee ajatykau 'ga porogyta renupa. Janeruwarete 'ga pãjẽa 'ga rerekou. A'eramũ 'ga oporogytau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A'e pype 'gã iteu ma'e 'ga rerua Jejui 'ga upe. Wupawa pype 'ga 'upa ojenuga. —Soo 'ga rerawau Jejui 'ga upe 'jau— 'jau 'gã ajaupe. A'eramũ 'gã 'ga rupia 'ga rupawa reewe 'ga rerua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","A'ere 'gã nuerosearũi 'ga. Nijumypykwari'i 'oga 'gã nupe. A'eramũ 'gã a'eramũ 'ga rerosowe'em. A'eramũ 'gã 'opewuu apyte'rarimũ 'ga rerawau 'ga rerojeupia. 'Oga pyrape mopoka 'ga upe. Imopog ire 'gã 'ga monou imojypa tupaama pyu Jejui 'ga rowase. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","A'eramũ Jejui 'ga 'jau ojeupe: “Je rerowiat pa 'gã ajemogyau ra'e”, 'jau 'ga ojeupe. A'eramũ 'ga 'jau iteu ma'e 'ga upe: —Enetywera je omoit 'awamũ ene wi ki 'ei— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'gã, fariseu 'gã netee 'jau ajaupe: —Kuu. Awỹja 'agamũ 'ũina Jarejuwarete 'ga kurapa 'ũ? Janeruwarete 'ga etee te 'ã janetywera omoit jane wi. “Enetywera je amoit ene wi” 'eramũ 'ga 'i “Je Jarejuwarete 'ga 'jawe” 'jau— 'jau 'gã ajaupe 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A'ere Jejui 'ga ikwaawi ojee. A'eramũ 'ga 'jau 'gã nupe: —Ma'eramũ pẽẽ poromũ 'jau pejejeupe 'ũ?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—Je upe te naayi. Iteu ma'e mafu'amaramũ ae nanẽ ojotywera moiri ajaui nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","—Pẽneki'yra je 'ã. A'eramũ je tepãjẽ resaukaa pẽ nupe iteu ma'e 'ga mafu'ama pẽ neape— 'jau 'ga 'gã nupe. —'Ga fu'ama resaka taje kwaap pejepe 'jau— 'jau Jejui 'ga 'gã nupe. —“A'efera 'ga amafu'am. Aetywera 'ga omoit nanẽ ae wi nũ”, tepe'je 'jau. Jeruwarete 'ga te 'ã opãjẽ amut jee. A'eramũ je pẽtywera moia pẽ nui, iteu ma'e mafu'ama nanẽ nũ— 'jau 'ga 'gã nupe. A'eramũ 'ga 'jau iteu ma'e 'ga upe: —Efu'ama jui. Eatau ewau eje'wyr ipe nũ. Jaruete ene 'awamũ— 'jau 'ga 'ga upe. —Ere ewau. Ere ejupawa rerawau eje'wyr ipe nũ— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A'erauwe 'ga afu'ama. A'eramũ futat 'ga awau. 'Gã nowase 'ga afu'ama. Najuejue etee futat 'gã 'ga resaka. A'eramũ 'ga wupawa rerawau oje'wyr ipe nũ. —Esage ete Janeruwarete 'ga. Je mafu'am 'ga— 'jau 'ga 'gã nupe awau, Jarejuwarete 'ga muorypa ee. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","A'eramũ peuwara 'gã oporesagamũ 'upa 'ga ree. A'eramũ 'gã 'jau ajaupe: —Kuu. Ku'jywa 'ga 'ga amafu'am. Iteu ma'efera 'ga wata nũ— 'jau 'gã ajaupe. —Siesak ako jane 'ga mafu'ama akiko! A'eramũ nipo 'ga aetywera moia nanẽ ae wi nũ— 'jau 'gã ajaupe. A'eramũ 'gã Jarejuwarete 'ga muorypa ee. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A'eramũ Jejui 'ga awau jui. Awau pe aje kũima'e 'ga amũ resaka, Levi 'ga resaka. Levi 'ga 'wyriararete upe ka'aranũũ pyykara 'ga. 'Ga porowyky 'ga renamũ Jejui 'ga awau owaẽma 'ga upe. A'eramũ Jejui 'ga 'jau 'ga upe: —Ere ejua je rupi— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A'erauwe 'ga opoia oporowyky awi ejaa inuga a'e pe te futat. A'eramũ futat 'ga awau akou Jejui 'ga remiayuwamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","A'ere Levi 'ga 'jau Jejui 'ga upe: —Ere ejemiayuwa 'gã nerua erojemi'waa je pyri— 'jau 'ga oje'ega Jejui 'ga upe. A'erauwe 'ga wemiayuwa 'gã nerawau erojemi'waa 'ga rog ipe. Kwaiwete 'gã jatykai ojemi'waa 'gã pyri 'wyriararete upe ka'aranũũ pyykara 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ae tywera pype 'gã jemi'wara resakawe fariseu 'gã Moisesi 'ga remikwasiarer are moromu'jara 'gã netee 'jau Jejui 'ga remiayuwa 'gã nupe: —Kuu. Ma'eramũ pẽẽ pejejemi'waa 'wyriararete upe ka'aranũũ pyykara 'gã pype 'ũ? itywet ma'e 'gã pype 'ũ? Nojemi'wari noko ae 'gã pyri 'ja. Nia'wyri 'gã ajemogyau kũi— 'jau 'gã 'gã nupe, oje'ega moywyrafena. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aipo wemiayuwa 'gã nupe 'gã 'eramũ Jejui 'ga 'jau 'gã nupe: —'Gã pyri je rekoi 'gã poaawamũ te nũ'ũ. Je 'ã morofuanugara 'jawewara te ako 'gã nupe. Sã'ã morofuanugara 'ga muaga monoa ojero'wu ma'e 'gã nupe etee. Nomono ekoetei futari 'ga ijero'wue'ema 'gã nupe muaga. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nan tee futat je. Ia'wyre'ema 'gã katu'okawamũ te je ruri— 'jau 'ga 'gã nupe. —“Je jeresage”, pe'je 'ã. A'ere naesage ma'eramũ rũi je ruri pẽ katu'oka. Itywet ma'e katu'oka tee je ruri— 'jau 'ga 'gã nupe. —Nan tee 'ã je rekoi, “Pejetywer awi pepoit”, 'jau 'gã nupe. “Pejetywer awi pẽpoiriweramũ Jeruwarete 'ga tomoit pẽ nui 'jau”, 'jau je 'ã tekou 'gã nupe. “Pẽ nui imoir ire 'ga pẽ mogyau wemiayuwamũ”, 'jau je 'ã tekou 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Anure amumera 'gã 'ua oje'ega Jejui 'ga upe nũ: —Juã Batista 'ga remiayuwa 'gã ojemi'ware'ema futat oje'ega monou Jarejuwarete 'ga upe jepi. Fariseu 'gã nemiayuwa 'gã nanẽ ojemi'ware'ema futat oje'ega monou 'ga upe jepi. Oporogytaawa upe iwaẽmawe 'gã awau ojemi'ware'ema oporogytau Jarejuwarete 'ga upe jepi. A'ere 'ã eneremiayuwa 'gã nanarũi. Niojeri agawewi 'gã 'ã ojemi'war awi. A'etea 'ã 'gã oje'ega omono Jarejuwarete 'ga upe— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A'eramũ Jejui 'ga 'jau 'gã nupe: —Naani. Ojepyri je rekoramũ 'gã niojeri futari ojemi'waa. Sã'ã ae ajuekokaturamũ ty'ara rerekoe'ema. Nan tee futat 'gã ojepyri je rekoramũ jeremiayuwa 'gã niojeri ojemi'waa. Akokatu ma'e 'gã nekokaturamũ sipo 'gã nekokatu resakara 'gã opy'araypara rerajemogyi maraka are? Naani. Maraka teepaw ire te nipo 'gã nojemi'waru'jawi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","—Pe awi akokatu ma'e 'gã jepe'a re tee esakarera 'gã poiri ojemi'war awi oporogytau Jarejuwarete 'ga upe— 'jau Jejui 'ga oje'ega 'gã nupe u'ama. —Nan tee futat jeremiayuwa 'gã niojeri ojemi'waa ojepyri je rekoramũ. Je jepe'a re te nipo 'gã nojemi'wari ajemogyau. U'arasigamũ ajemogyau je ree je o re. A'eramũ nipo 'gã ojemi'ware'ema ajemogyau je ree, wea'aramũ ajemogyau je ree— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","—Ymã te 'ã aeypy 'gã pẽ mu'ei mama'e are rakue. A'ere je 'ã 'awamũ pẽ mu'ei nũ. Amutee are je 'awamũ pẽ mu'ei nũ. A'ere nepemojopypea'uweri jeporogytafera aeypy 'gã nemimome'ufer are. Jeporogytafer are ojemu'e ma'eferamũ ki a'ea etee futat pejemu'e. Pemojopype kasi morogyta ymaner are ne. Morogyta ymaner are ojemu'e ma'e 'gã nuapoi jeporogytafer imũ mama'ea— 'jau Jejui 'ga 'gã nupe. —Taity yaua ae nomonoroga'uweri taity ymanera perugawamũ. Nia'wyri taity yaua awau taity ymanera perugawamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","—Y'way yau ae nueko'wogi yrũ ymanera pype. Yrũ yau pype te ae eko'wogi. Yrũ ymana pype sieko'wok 'eramũ wajaiwamũ kamẽsĩete. A'eramũ futat opy'apefugamũ wyrũ kakau. A'eramũ futat ojeko'woka— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","—Y'waya ajai'wi tykur ire ae notykuri futari y'way yaua. Nan tee 'ã pẽẽ mũ. Pejemu'e morogyta ymaner are tee. Pẽnea'at aeypy 'gã pejemu'eawer are etee. Pejemu'e yau are jẽmĩ 'ã nepẽjemu'eweri— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Morowykye'ema mũ rupi Jejui 'ga awau juowuurana ko pyterimũ. 'Ga rewiri oo ma'e 'gã a'ỹja pa'wau erawau opo pe. A'eramũ 'gã ipe'oka i'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","'Gã nesakawe fariseu 'gã amũ 'jau 'gã nupe: —Ma'eramũ te pepo'o a'ỹja? Nepeporowykya'uweri morowykye'ema rupi. A'ỹja po'oa aeporowykya futat. Ymã te 'ã Moisesi 'ga 'i rakue: “Peporowyky awi morowykye'ema rupi”, 'jau 'ga 'ã rakue— 'jau 'gã Jejui 'ga remiayuwa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'ja te Davi 'ga wapo rakue? Nepemogytai nipo ka'arana 'ga ree? Ymã te 'ã 'ga py'arayparamũ opytuna 'gã netee rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A'eramũ 'ga awau Jarejuwarete 'ga mogytaaw ipe osou rakue. A'e pe 'ga kanape pyyka ojeupe rakue. A'eramũ 'ga 'ã ape monou opytuna 'gã nupe rakue. Pekwaap 'ã aipoa. Na'gã nemi'u arũi poa numiamũ. Mainana 'gã etee te a'u aipoa rakue. A'etea Davi 'ga a'u opytuna 'gã netee rakue. Ipy'araypat 'gã awau osou peu. A'eramũ 'ga amũ “Nepẽa'wyri pẽẽ” 'jawe'em 'gã nupe rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Je 'ã pẽneki'yraretea, Jarejuwarete 'ga remimurera. A'eramũ je 'jau pẽ nupe: Je 'ã morowykye'ema jara. A'eramũ je te amunipo 'ã “peapo awi”, 'jau pẽ nupe. Iapoare'emamũ nepeje'eg ekoetei 'gã nupe. Je te 'ã iapoarera— 'jau 'ga fariseu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ajepeja morowykye'ema rupi Jejui 'ga awau osou judeu 'gã jatykaaw ipe nũ. A'e pe futat ipoteu ma'e 'ga wapyka 'ũina. 'Ga jakwatawa nia'wyri. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisesi 'ga remikwasiarer are moromu'jara 'gã fariseu 'gã netee Jejui 'ga resaka 'upa. A'eramũ 'gã 'jau ajaupe: —'Awamũ 'ã morowykye'ema. 'Awamũ nipo 'ga 'ga katu'ogi 'ja? Ma'ja e'i sipo 'ga 'awamũ oje'ega ipoteu ma'e 'ga upe? 'Ga po katu'ogamũ ki sa'e 'ga upe: Nuenuwi futari 'ga Moisesi 'ga remikwasiarera ra'e, sa'e ki 'ga upe. Sã'ã 'ga porowykya morowykye'ema rupi. 'Ga poa 'ga wapokatu morowykye'ema rupi, sa'e 'ga upe 'jau— 'jau 'gã 'upa ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A'ere Jejui 'ga 'gã kwaawi etee ojee. A'eramũ 'ga 'jau ipoteu ma'e 'ga upe: —Efu'am e'ama 'gã pyteripe. Tene resak 'gã 'jau— 'jau 'ga ipoteu ma'e 'ga upe. A'erauwe 'ga afu'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A'eramũ Jejui 'ga 'jau moromu'jara 'gã nupe: —Ma'ja e'i te Moisesi 'ga rakue? morowykye'ema upe rakue? “Esageay etee ki peapo”, e'i te 'ga janee rakue? “Ia'wyre'ema etee ki peapo”, e'i te ra'u 'ga janee rakue nũ? “Pejokatu'og iki”, e'i te Moisesi 'ga janee rakue nũ? “Tene imanũi”, e'i te ra'u 'ga janee nũ?— 'jau Jejui 'ga 'gã nupe. —Pekwaap futat 'ã. “Esageay etee ki peapo”, e'i 'ã Moisesi 'ga janee rakue. “Pekatu'og iki 'gã”, e'i 'ã 'ga janee rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aipo 'e re Jejui 'ga amã'jãu 'gã nee ra'ne 'gã moyka. A'ere 'ga 'jau ipoteu ma'e 'ga upe: —Epo epopyo— 'jau 'ga 'ga upe. A'erauwe futat 'ga opo popywau. A'erauwe futat 'ga poa ojekatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Morowykye'ema rupi 'ga katu'ogamũ Moisesi 'ga remikwasiarer are moromu'jara 'gã amara'neramũ 'ga ree. A'eramũ 'gã 'jau ajaupe: —Maran te jane Jejui 'ga rerekoi? Sijuka te jane 'ga? Naani te ra'u nũ?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aipo 'gã nupe 'epaw ire Jejui 'ga awau ojeupia ywyty'rarimũ. Awau oporogytau 'Uwarete 'ga upe. Koypytunamuku 'ga oporogytau 'Uwarete 'ga upe. Noseri futari 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ai'iwetetewe 'ga wewiri oo ma'e 'gã majatykau ojee. Kwaiwete 'ga rewiri oo ma'e 'gã. A'ere 'ga tusi 'gã etee imũ'ẽi 'gã pytuna 'gã nui. A'eramũ 'ga 'jau 'gã nupe: —Pẽẽ te 'ã jeremimu'ea. Je te 'ã amu'e pẽẽ— 'jau 'ga 'gã nupe. —A'eramũ je anure pẽ monou kwe pe tejemome'waukaa 'gã nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Simão, Andre, Tiago, Juã, Filipe, Patarumeu, Mateu, Tome, ajepeja Tiago, ajepeja Simão, Judas, ajepeja Judas. Mĩmera 'gã Jejui 'ga imũ'jãu wemimu'eramũ. Simão 'ga mukũi 'ga rera. Pedro 'jau Jejui 'ga inuga 'ga ree. Ajepeja Simão 'ga mukũi 'ga rera nanẽ nũ. Serote 'jau 'ga rer irũa. Andre 'ga Pedro 'ga rewirera. Tiago 'ga Aufeu 'ga ra'yra 'ga. Judas 'ga Tiago 'ga ra'yra 'ga. Ajepeja Judas 'ga mukũi 'ga rera. Iskariote 'jau 'ga rer irũa. Kũima'e tywera 'gã nupe 'ga monoara 'ga poromũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jejui 'ga 'ua ojypa ywytyra apyte'rar awi nũ. Wemimu'e 'gã nerua erojypa ojeewe. Waimy 'wyr ipe 'gã 'ua. Kwaiwete 'gã 'upa 'ga rapesaka. Judeja ywy pewara 'gã, Jerusareg ipewara 'gã, Tiro pewara 'gã, Sidom ipewara 'gã 'jau 'ua. Tiroa 'upa 'yẽ'ẽ pyri Sidoma nanẽ nũ. Mĩmer amunaw awi 'gã 'ua ajatykau 'ga rapesaka 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kwaiwete 'gã 'ua. 'Ga porogyta renupa ajatykau 'ga ree. Ojero'wu ma'e 'gã nanẽ 'ua ajatykau 'ga ree. Ojekatu'ogukaa 'ua 'ga upe. Mama'eukwaawa rerekwara 'gã nanẽ nũ. Ojekatu'ogukaa 'ua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","'Ga Ruwarete 'ga opãjẽ mua Jejui 'ga upe. A'eramũ 'ga 'Uwa 'ga pãjẽ mũ te 'gã katu'oka. Opokoka etee agawewi 'gã Jejui 'ga ree. A'etea 'gã ojekatu'ok. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ojero'wu ma'e 'gã katu'opaw ire Jejui 'ga amã'jãu 'gã nee, ojepyri ajatyka ma'e 'gã nee. A'eramũ 'ga oje'ega 'gã nupe: —“Jetywerete je tekou. Ejejuka je ree” 'jaramũ Janeruwarete 'ga pẽ poari futari. “Jetywerete je. Je katu'og ape” 'jaramũ Janeruwarete 'ga pẽ katu'ogi futari. A'eramũ pẽẽ pejeku'iramũ pejejemogyau. Pẽẽ 'ã 'ga remiayuwamũ 'awamũ pejemogy. A'eramũ pẽẽ anure nipo pejewau 'ga pyri. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pẽẽ 'ã “torokwaap 'ga 'jau”, pe'je. A'eramũ pẽẽ a'jea futat 'awamũ 'ga kwaapa katu katu pejejemogyau. A'eramũ nipo pẽẽ pejeku'iramũ pejejemogyau. Nanamũ pejetywera peru'arasig erajemogyau. A'ere 'awamũ Janeruwarete 'ga imoiri pẽ nui. Pejejewi imoir ire pejejemogyau pejeku'iramũ nipo. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jeremiayuwamũ pejemogyramũ nipo je rerowiare'ema 'gã niporomutari pẽ nee. Je 'ã pẽneki'yraretea agawewi. A'etea 'gã je rerekou tyweaete. A'eramũ nipo jeremiayuwe'ema 'gã pẽ nee taetu oporomutare'emamũ ajemogyau. Je ree nipo 'gã pẽ ago'wau ajemogyau. A'etea nipo pejeago'oramũ nepẽku'ipawa'uweri pejejemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pẽ nereko tywerete agawewi nipo 'gã. A'etea ki pẽku'i etee pejejemogyau. Pẽẽ 'ã pejemogy esage pejejemogyau jeje'eg imũ etee. A'eramũ pẽẽ pejewau je rupi ywag ipe. Peu te Janeruwarete 'ga mama'e esage monoi pẽ nupe. Peu te 'ga pẽneko esageawera repy monoi pẽ nupe. Ymã te 'ã 'gã ypy 'gã Jarejuwarete 'ga je'ega mome'wara 'gã nereko tyweretei rakue. A'ere 'ã nãnẽwẽjẽmĩ 'gã pẽ nerekoi nũ. 'Awamũ ojeup ma'e 'gã nanẽ pẽ nereko tyweretei nũ. A'ere 'ã nãnẽwẽjẽmĩ pẽku'i etee pejejemogyau nũ— 'jau Jejui 'ga oje'ega renupara 'gã nupe u'ama oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","A'ere Jejui 'ga 'jau ikaraemã kwai ma'e 'gã nupe, “nafutari je Jarejuwarete 'ga tepoara” 'jara 'gã nupe: —'Awamũ etee futat pẽkaraemã pejejemogyau. “Akwaap futat je Jarejuwarete 'ga”, pe'je numiamũ. A'ere 'ga anure namuru'jawi mama'ea pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Pẽporiay'i pejejemogyau numiamũ. 'Awamũ etee te pẽku'i pejejemogyau pejekaraemã kwaiwete are numiamũ. A'ere nipo anure peko tywet etee nũ, pejekaraemã are pẽku'iawera rayramũ etee pẽ nupe nũ. Nepekwaawi futari Jarejuwarete 'ga. Nepẽporomutari te 'ã 'ga je'eg are. A'eramũ pẽẽ 'ga resake'ema futat pejewau. Pẽporiay'i pejejemogyau numiamũ. 'Awamũ pefuka etee pejejemogyau numiamũ. Pejetywera etee 'ã pefutat. A'ere nipo anure pejoo'o pejejemogyau. A'eramũ nipo pẽẽ pejejemogyau, “Ma'eramũ je tetywer are etee teku'iramũ tekou rakue 'ũ?” 'jau nipo pẽẽ pejejemogyau pejejaa'wau. Anure peo futat pejejemogyau tyweaete mama'eukwaawa rapyaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pẽporiay'i numiamũ. 'Awamũ kwaiwete 'gã poromutaramũ pẽ nee numiamũ. Ymã te 'ã kũima'e 'gã amũ 'i 'gã nupe rakue: “Je 'ã Jarejuwarete 'ga je'ega mome'wara”, 'jau futatee 'gã nupe o'meramũ rakue. A'etea 'ã pẽypy 'gã 'gã nerowiaa rakue. “Esage ma'e 'gã”, 'jau 'gã 'ã i'me ma'e 'gã nupe 'gã nekoramũ rakue. Nan tee 'awamũ pẽporiay'i pejejemogyau numiamũ. A'eramũ nipo 'gã najuejue etee pẽ futaa ajemogyau numiamũ. A'eramũ pẽẽ najeremiayuwa rũi. Jeremiayuwamũ nipo 'gã amũ niporomutari pẽ nee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","A'ere Jejui 'ga oje'ega 'gã nupe, oje'eg are wapyaka ajemogy ma'e 'gã nupe: —'Awamũ je je'egi pẽ nupe najuejue etee teje'ega renuparamũ. Pejejuka esage ki pejejee iporomutare'ema 'gã nee. Niporomutari nipo 'gã pẽ nee numiamũ. A'ere ki 'gã pereko esage etee futat. Pẽmara'ne kasi 'gã nee ne— 'jau Jejui 'ga u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","—Jarejuwarete 'ga upe pejeje'ega ki pe'je 'ga upe: “Ejejuka esage ki 'gã nee, ore ree iporomutare'ema 'gã nee”, pe'je ki 'ga upe pejeje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","'Ga amũ nipo pẽnetywape nupãu. A'eramũ ki pejejetywape nupãnamũ perowag etee pejejetywape owajara 'ga upe— 'jau Jejui 'ga 'gã nupe u'ama. —'Ga amũ nipo pẽnaity poakuwuu rerawau pẽ nui. A'ere kasi pẽnea ee ne. Tene ki 'ga erooi pẽneteyrũa nanẽ nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","—“Mama'e mũ emut jee”, pejejeupe 'ga amũ 'eramũ imonou etee futat 'ga upe— 'jau 'ga 'gã nupe u'ama. —'Ga amũ nipo pẽkaraemã pyyka erawau pẽ nui. A'ere kasi “pe'je imua jee nũ”, pe'je 'gã nupe ne, pejeje'egayau ne. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pefutat te 'gã pejejereko esagea? A'eramũ pẽẽ nanẽ pejejejukau esage 'gã nee nũ— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Pejejee te iporomutat ma'e 'gã nereko esagea etee sipo Janeruwarete 'ga afutat? Pejejee iporomutare'ema 'gã nereko tywera sipo 'ga afutat? Naani. Oporojuka ma'e 'gã miamũ futat ipota'wa ajuee, ojee iporomutat ma'e 'gã nee. A'ere kasi pẽẽ nanarũi ne. Pejejee iporomutare'ema 'gã nee miamũ futat pejeporomutaramũ— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","—Pejejereko esageara 'gã nee etee pejeporomutaramũ sipo Janeruwarete 'ga pẽ mepyi? Naani. Aetywera 'gã miamũ futat nanuara wapo ojekoty'aawa upe. A'ere ki najuejue etee futat pẽpota'wa 'gã nee— 'jau 'ga 'gã nupe u'ama oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","—A'ere “Nipo 'gã imepyi jee re'ã” 'jara 'gã nupe etee kasi ekaraemã eremono ne— 'jau 'ga 'gã nupe. —A'ere 'ã aipoa miamũ futat aetywera 'gã iapoi. A'ere kasi pẽẽ nan ine. Nanarũi pẽẽ. Pemono ekoete tee futar iki ikaraemãe'ema 'gã nupe. Karaemã mepye'ema 'gã nupe nanẽ pemono ekoete tee nũ. Mama'ea 'gã nupe itywe'emamũ ki pemono ekoete tee 'gã nupe— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","—Nan pẽẽ iaporamũ Janeruwarete 'ga pẽporowyky repy muri pẽ nupe anure. A'eramũ 'ga pẽ mogyau wemiayuwamũ. 'Ga te 'ã Janeruwaretea janee— 'jau Jejui 'ga 'gã nupe u'ama. —Kwaiwete te 'ã Janeruwarete 'ga upe iporogytae'ema 'gã jemogyi. A'etea 'ã Janeruwarete 'ga esage 'gã nupe, ojeupe oje'eg ma'e 'jawe— 'jau Jejui 'ga 'gã nupe imome'wau. —Itywerete ma'e 'gã nupe nanẽ 'ga 'ã mama'e esage monou nũ, ajemuaẽma 'gã nee nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","A'eramũ ki pẽẽ nanẽ pejejemuaẽma 'gã nee nũ, Jarejuwarete 'ga 'jawe nũ— 'jau Jejui 'ga 'gã nupe 'gã mu'jau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—“Nepẽa'wyri pẽẽ Jarejuwarete 'ga upe”, pe'je kasi 'gã amũ nupe ne. Aipo 'gã nupe 'e'emamũ Janeruwarete 'ga nanẽ aipo ne'i pẽ nupe— 'jau Jejui 'ga 'gã nupe u'ama. —“Mama'e tywerete ereapo”, pe'je kasi 'gã nupe ne. Aipo pẽẽ 'e'emamũ Janeruwarete 'ga nanẽ aipo ne'i pẽ nupe nũ— 'jau Jejui 'ga 'gã nupe u'ama. —'Gã pejejereko tywearer are kasi pẽnea'at pejejemogyau au'jeteramũ ne. Ee pẽnea'aru'jawe'emamũ Janeruwarete 'ga nanẽ futat naea'aru'jawi pẽtywer are nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","—Mama'ea 'gã nupe pẽẽ imonoramũ Janeruwarete 'ga nanẽ mama'e muri pẽ nupe nũ. Inãinãnĩ'ĩ nipo pemono 'gã nupe. A'eramũ Janeruwarete 'ga nanẽ imua inãinãnĩ'ĩ etee pẽ nupe nũ. Imonoawera 'jawerimũ etee futat imua pẽ nupe nũ— 'jau Jejui 'ga 'gã nupe. —Mama'ea 'gã nupe imonouu re te amunipo 'ã Janeruwarete 'ga i'jawerimũ etee futat imuri pẽ nupe— 'jau Jejui 'ga u'ama 'gã nupe 'gã mu'jau. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","—Eae'ema 'gã nokoi ajuee ojopopyyke'ema. Kasi 'gã a'e pe ajuerooi ajueru'aa ywy kwara pype ne. Nan tee pẽẽ. Mama'e tywera apoaramũ pẽẽ najuejue etee. A'eramũ pẽẽ a'eramũ “Mama'e tywera ereapo”, 'jawe'em futat pejejaupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","—Ojemu'e yau ma'e 'gã amu'jara nuapyraawi futari. Amu'jara 'ga amu'e re tee 'ga ka'arana kwaawi. 'Ga 'jawe etee futat ikwaapa— 'jau Jejui 'ga 'gã nupe oporogytau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","—Najuejue etee te 'ã pẽtywet. A'eramũ pẽẽ “Itywet ma'ea pẽẽ”, 'jawarũe'em pejejaupe. A'eramũ pejepoia futat pejetywer awi. “Nitywi oretywera”, pe'je futat numiamũ. A'ere pẽẽ pẽtyp futat. Pejetywer awi ra'ne pepoit. A'ere pejejewirera tepepoat 'jau. “Ere epoia etywer awi”, tepe'je pejejewirera 'gã nupe 'jau— 'jau Jejui 'ga 'gã nupe u'ama. —Sã'ã ae 'ywa tuwyrera weape i'aramũ ajuea pewara resake'ema ajaui. A'eramũ 'ã ae weapewara ra'ne enuẽm. Ojewi enuẽm ire 'ã ae ojoma'e resaka ajuea awi. Nan tee futat ae otywer awi ra'ne ae poiri. A'ere ojopoaa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Y'wa 'ywa 'jawe ae. Y'wa 'yp katurama i'a katuram tãmẽjẽ futat. Y'wa 'yw a'wyre'ema o'ywa 'jawe etee futat ni'aa'wyri. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A'e are y'wa 'ywa pekwaap i'a esage are. Sã'ã y'wa mũ i'ae'ema ojo'yw ekoete are. O'yw are etee i'aa— 'jau Jejui 'ga 'gã nupe oporogytau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","—A'eramũ ae nan tee futat. Aeywyter esagea mama'e esagea etee futat imome'wau akou ojopoaa. Aeywyter a'wyre'ema mama'e tywera etee futat imome'wau akou. Mama'e katurama jẽmĩ imome'wawe'em— 'jau Jejui 'ga 'gã nupe oporogytau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Ma'eramũ ajee je renũi pejepe, “Jejara 'ga”, pe'je jee. A'etea 'ã nepeenuwi pejejeupe jeje'ega. “Jejara 'ga” 'jaramũ pẽẽ jeje'ega renupa katu katu. Jeje'ega renupare'emamũ kasi pe'je jee ne, “Jejara 'ga”, pe'je jee ne— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","—Jeje'ega renuparamũ pẽ'akwaap pejejemogyau. Sã'ã i'akwaap ma'e 'ga 'oga mỹja ywy ãtã pype. A'eramũ 'y ruwiretea miamũ 'ã owaẽme'ema 'ga roga upe. A'eramũ 'ã aipo 'oga awawe'em ypy pe. Aipo 'og apoara 'ga i'akwaap. Nan tee pẽẽ jeje'ega renuparamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","—A'ere jeje'ega renupare'emamũ pejemogy i'akwaawe'ema 'ga 'jawe. I'akwaawe'ema 'ga te ajee 'oga omỹi 'y apopewa pype. A'eramũ 'ã 'y ruwia 'ga roga rupia 'ga wi, imonou ypy pe 'ga wi. Ni'akwaawi 'ga akou. Nan pẽẽ jeje'ega renupare'emamũ. Aipo 'ga 'jawewaramũ nipo pẽẽ anure pejepapa— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aipoa 'gã nupe imome'upaw ire Jejui 'ga awau 'gã nui Kafanaũ pe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A'e pe futat jefaruu 'gã 'wyria'ri 'ga reni. Amutee 'ga romanũa 'ga. 'Ga remiayuwa 'ga ojero'wu 'upa. Kwaiwete 'ga jero'wui 'upa. Amanũ ja'wyja'wy futat 'ga 'upa. Aipo 'ga ree 'wyriara 'ga oporomutaramũ. A'eramũ 'ga a'eramũ ajemuaẽma 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A'eramũ 'ga Jejui 'ga rera renupawe, oje'ega judeu 'gã 'wyria'ri 'gã nupe: —Pe'je pejewau Jejui 'ga rerua jee. Jeremiayuwa 'ga tomoferap 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","A'eramũ judeu 'gã 'wyria'ri 'gã awau Jejui 'ga renũina: —“Ejot”, e'i 'ga enee ko. “Jeremiayuwa amanũ ja'wyja'wy amũ 'upa”, e'i 'ga enee ko— 'jau judeu 'gã 'wyria'ri 'gã awau Jejui 'ga upe. —Ejot 'ga remiayuwa resaka 'ga upe. Ore muara 'ga esageay te. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","'Ga futat judeuramũ janejatykaawa apoawera omepy ai'i. A'eramũ ene ejua 'ga resaka ore rupi— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","A'eramũ Jejui 'ga awau 'gã nupi, ojero'wu ma'e 'ga resaka. 'Ga waẽm ja'wyja'wyrauwe jefaruu 'gã 'wyriara 'ga oje'ega ojekoty'aawa 'gã nupe: —Pe'je pejewau 'jau 'ga upe: “Tut kasi 'ga osou 'au jerog ipe ne”, e'i 'ga enee ko, pe'je pejewau 'ga upe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","A'erauwe 'gã awau 'jau Jejui 'ga upe: —“Tut kasi 'ga osou 'au ne”, e'i 'ga enee ko. “Naesage ma'ea rũi je. Nakũima'eeteete rũi te 'ã je”, e'i 'ga enee ko— 'jau 'wyriara 'ga jekoty'aawa 'gã awau oje'ega Jejui 'ga upe. —“Ojenosĩ je 'ga wi”, e'i 'ga enee ko. “Naesage ma'ea rũi te 'ã je”, e'i 'ga enee ko. “A'eramũ je a'eramũ tejenosõu 'ga wi tejog ipe 'ga reseramũ ne”, e'i 'ga enee ko. “'Ga te 'ã esageay ma'ea”, e'i 'ga enee ko. “Peu etee futat pejewau pejeje'ega 'ga upe jee”, 'jau 'ga oree ko. “A'eramũ 'ga oje'eg imũ etee futat jeremiayuwa moferapa jee 'jau”, e'i 'ga enee ko— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","—“Je 'ã jefaruua. A'eramũ je 'ã te'wyriara 'ga je'eg imũ etee futat mama'e apou tekou jepi. Je 'ã 'gã 'wyria'ria. Ma'eramũ 'ã jeremiayuwa 'gã jeje'eg imũ etee futat mama'e apoi ajemogyau. 'Ga amũ upe je 'jau: Kwe pe ekwap ajepei amunaw ipe. A'eramũ 'ga awau ojeupe je'eawer imũ. Amumera 'gã nupe je 'jau jepi: 'Au pejot je pyri, 'jau je 'gã nupe”, e'i 'ga oree ko. “Ma'eramũ 'gã 'ã jeje'eg imũ etee futat 'gã je'egi ajemogyau ajaupe. Tejeupe oporowyky ma'e 'gã nupe je 'jau: Pekwap mama'e apou jee, 'jau je 'ã 'gã nupe. A'erauwe 'gã jeje'eg imũ etee futat mama'e apou jee jepi. A'eramũ 'ga nan tee futat jeje'ega ojeupe imome'uramũ jeremiayuwa 'ga moferapa oje'eg imũ etee futat jee 'jau”, e'i 'ga enee ko— 'jau aipo 'gã awau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aipo ojeupe 'gã 'eramũ Jejui 'ga oporesagamũ 'gã nee. A'eramũ 'ga 'jau ojepyriwara 'gã nupe: —Israeu juapyrera agawewi 'ã pẽẽ. A'etea 'ã naje rerowiari pejepe. Inãinãnĩ'ĩ etee 'ã pẽẽ je rerowiari pejejemogyau. Ko 'gã muarera 'ga judeue'ema agawewi. A'etea 'ga je rerowiat kwaiwete ra'e jepi— 'jau Jejui 'ga ojepyriwara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","O'wyriara 'ga je'ega Jejui 'ga upe eroo re aipo 'gã ojewya 'ua nũ. Owaẽma ypy we 'gã ojero'wu ma'efera 'ga resaka: —Kuu. Oferap nipo 'ga ra'e ki sa. Oje'eg imũ etee futat 'ga 'ga moferawi ra'e— 'jau Jejui 'ga upe oporogyta ma'efera 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Anure Jejui 'ga awau ajepeja amunaw ipe nũ. Naĩ me 'ga awau, wemimu'e 'gã nerawau. Mytuna 'gã nanẽ awau 'gã nupi nũ. Ojoywyywyr ipe 'gã awau watau. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aipoa amunawa ojeosõu. Awau 'gã owaẽma iosoma rokwara upe. 'Gã waẽm ja'wyja'wyramũ, Naĩ mewara 'gã amanũ ma'e rerawau ityma numiamũ. Majawera ẽẽ ra'yra 'ga amanũmũ. Ẽẽ mena amanũ rakue. A'eramũ ẽẽ omene'emamũ akou. Majepei tee ẽẽ ra'yra 'ga. A'e 'ga amanũ ẽẽ wi. Ẽẽ ra'yra 'ga rerawau ityma numiamũ. Kwaiwete 'gã awau ẽẽ rupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ẽẽ resakawe Jejui 'ga ajemuaẽma ẽẽ ree. —Erejoo'o awi ĩ— 'jau Jejui 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Awau 'ga erowyka. A'erauwe 'ga pokogi ae rupiaw are. Erawara 'gã opytau imuapyka 'ga upe. A'eramũ futat 'ga 'jau teumera upe: —Ere ejua ewya— 'jau 'ga amanũ ma'efera 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A'eramũ futat amanũ ma'efera 'ga owya oporogytau. A'eramũ Jejui 'ga 'jau 'ga y ẽẽ upe: —'Agamũ enera'yra 'ga reni owya nũ— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","'Ga ferawa resakara 'gã oporesagamũ etee 'ga ree. —Janeruwarete 'ga 'ã esage janee. Oje'ega mome'wara 'ga 'ga amut ojemome'waukaa janee— 'jau 'gã ajaupe. —Janeruwarete 'ga 'ga amut imojejukaukaa jane ree— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Amanũ ma'e 'ga imoferaw ire 'ga rera okwasi'wau amunawa pype. Amunawa pypiarugamap. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Moromunepawa pype Juã Batista 'ga renamũ 'ga remimu'e 'gã awau Jejui 'ga mome'wau 'ga upe: —Ekoay 'ga aeremiapoe'ema apou akou. Majawera ẽẽ ra'yra 'ga omoferap imanũ re ko— 'jau Juã 'ga remimu'e 'gã awau imome'wau 'ga upe, moromunepawa pype 'ga renamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","A'erauwe Juã 'ga 'jau mukũja 'gã nupe: —Pe'je pejewau pejeje'ega 'ga upe jee. “Ene te Jarejuwarete 'ga remimurera? 'Ga amũ te ra'u nũ?” pe'je ki 'ga upe jee— 'jau 'ga 'gã nupe. —“Ymã we te 'ã ore Jarejuwarete 'ga remimura 'ga rapesagi arajemogyau. Ene te? Naani te ra'u nũ?” pe'je ki 'ga upe jee— 'jau Juã 'ga 'gã nupe, 'gã monou 'gã oporonupa ee Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","A'eramũ 'gã awau oporonupa ee Jejui 'ga upe: —“Ene te Jarejuwarete 'ga remimurera? 'Ga amũ te ra'u nũ?” e'i Juã 'ga enee ko— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aipo ojeupe 'e re 'ga ojepyriwara 'gã katu'oka. Kwaiwete 'gã katu'oka. Eae'ema 'gã mamã'jãu. Mama'eukwaawa rerekwara 'gã nui mama'eukwaawa pe'au. Iteu ma'e 'gã katu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Gã katu'og ire Jejui 'ga 'jau 'gã nupe: —Peesak te je iapoa ra'e?— 'jau 'ga Juã 'ga remimonofera 'gã nupe. —Pe'je pejewau 'awamũ pejejemiesagera mome'wau 'ga upe. “Iteu ma'e 'gã 'ga amafu'am ko. Ipito'om ma'e 'gã 'ga imokã'jãu. Eae'ema 'gã 'ga imamã'jãu”, pe'je ki pejewau imome'wau Juã 'ga upe— 'jau 'ga 'gã nupe. —“Iapyae'ema 'gã 'ga imuapyau ko. Amanũ ma'efera 'gã nanẽ 'ga imoferapa ko nũ”, pe'je ki imome'wau 'ga upe. “Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoiri pẽ nui. Pejejewi imoir ire 'ga remiayuwamũ tepeko 'jau”, e'i 'ga 'gã nupe, “Jarejuwarete 'ga takwaap 'jau” 'jara 'gã nupe 'ga 'i ko, pe'je ki 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“Je rerowiar awi ipoire'ema 'gã niku'ipawi futari ajemogyau”, e'i 'ga enee ko, pe'je ki 'ga upe— 'jau Jejui 'ga 'gã nupe. —“'Gã amũ te nipo ajee mama'eaya ojeupe ijesaukaramũ opoit je rerowiar awi”, e'i 'ga, pe'je ki 'ga upe. “Nakwaawi je 'ga iapoa. A'eramũ je tepoia 'ga wi 'jara 'gã te nipo ajee niku'i futari ajemogyau”, e'i 'ga, pe'je ki 'ga upe imome'wau— 'jau Jejui 'ga ojeupe Juã 'ga remimurera 'gã nupe. —“Je rerowiar awi ipoire'ema 'gã a'jea futat iku'i ajemogyau”, 'jau ki pẽẽ imome'wau 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","A'erauwe Juã 'ga remimonofera 'gã awau ojewya nũ. 'Gã orauwe Jejui 'ga Juã 'ga ree oporonupa ojepyriwara 'gã nupe: —Amunawe'em ipe pejewau te maran peesak 'ga rai'i? Ma'ja 'jawe te 'ga rai'i? Sã'ã juowa ywytua erojetyjetyga erekoa. Nan tee 'ga rai'i? Naani te ra'u rai'i nũ?— 'jau 'ga 'gã nupe. —Nanarũi futat 'ga. Ae 'jawe etee futat 'ga oje'ega nanẽ nũ 'gã nupe. “Pejetywer awi pẽpoiriweramũ 'ga imoiri futari pẽ nui”, 'jau 'ga pãwẽ pãwẽ 'gã nupe ai'i. Kũima'eeteete 'gã nupe, akotee ma'e 'gã nupe 'jau 'ga akou imome'wau ai'i— 'jau Jejui 'ga Juã 'ga mome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","—Taity esagea sipo 'ga wereko eruatau pẽnemiesagamũ rai'i? Naani. Taity esage ma'e 'gã ako 'og esage pype etee. A'ere Juã 'ga nanarũi. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Juã 'ga 'ã Jarejuwarete 'ga mome'wararetea ako rai'i. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari inuga Juã 'ga rur are rakue. “Koromũ jeje'ega mome'wara 'ga” 'ea 'ga ikwasiarukaa inuga 'gã nupe rakue. “Je tomono 'ga ene renunewe kwe pewara 'gã mueapyou ene ree ene rura futarukaa 'gã nupe 'jau”, 'jau 'ga ikwasiaa inuga rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Aeypy 'gã wesageramũ agawewi rakue. A'ere 'ã Juã 'ga 'gã nesagea apyraawi Jarejuwarete 'ga upe. A'ere 'awamũ je rerowiaara 'ga amũ Juã 'ga apyraawi. Imu'epyre'ema 'ga agawewi. A'etea 'ga je rerowiaramũ 'ga apyraawi Jarejuwarete 'ga upe. A'eramũ nipo 'ga je rerowiaramũ ojejukau 'gã nee— 'jau Jejui 'ga 'gã nupe imome'wau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aipo renupa 'gã amũ 'jau Jarejuwarete 'ga upe: —Ene te 'ã eneresage oree. Nitywi 'ga amũ ene 'jawewara esage ma'eramũ— 'jau 'gã 'ga maku'iu. Aipo 'ga renupara 'gã amũ ka'aranũũ pyykarera. Mytuna 'gã nanẽ 'ga renupa nũ. Aipo 'gã Jarejuwarete 'ga je'ega renupa rakue. A'eramũ 'gã ojepymĩãukaa 'y pe Juã 'ga upe rakue. Mĩmera 'gã juejue Jarejuwarete 'ga muorypa ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A'ere amumera 'gã mara'neramũ 'ga ree ojeupe Juã 'ga mome'uramũ: —Iro Juã 'ga eremome'u oree— 'jau 'gã amara'neramũ 'ga ree. Fariseu 'gã amara'neramũ 'ga ree, Moisesi 'ga remikwasiarer are moromu'jara 'gã nanẽ amara'neramũ 'ga ree nũ. Aipo 'gã nuapoi futari mama'ea Jarejuwarete 'ga remifutar imũ. A'eramũ 'gã wemifutar imũ etee futat oporowykyau ajemogyau. “Pejetywer awi pepoit”, Juã 'ga ojeupe 'eramũ amara'neramũ etee 'ga ree. Nopoiri futari 'gã otywer awi. A'eramũ 'gã awawe'em futat ojepymĩãukare'ema Juã 'ga upe. Jejui 'ga remimome'ua miamũ futat 'gã nafutari. A'eramũ Jejui 'ga 'jau 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—Ma'ja 'jawe te aipo 'gã?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","—Kunumĩarũe'ema 'jawe 'gã niapyai ajemogyau. Nuenuwi 'gã ujara je'ega. Sã'ã kunumĩa “soo jarejerokyau 'jau” 'eramũ, “Naani. Najeataweretei je”, 'jau etee 'ã ajaupe. “Pe'je ajee sajeawotee 'ũ”, 'jau 'ã kunumĩa ajaupe nũ. “Najejeawoteeweri futari je, a'e ako je ko”, 'jau ete 'ã kunumĩa ajaupe. Nan tee futat aipo 'gã niapyai— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","—Juã 'ga 'ã ojemi'ware'ema akou Jarejuwarete 'ga upe oporogytau rakue. A'eramũ 'gã 'ã “Mama'eukwaawa 'ga wereko opir are ra'e”, 'jau 'gã 'ã 'ga upe, 'ga jemi'ware'emamũ rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","—A'ere 'ã je ruri Juã 'ga rewiri nũ. Je 'ã tekou teojere'emamũ tejemi'waa Jarejuwarete 'ga upe teporogytau. A'eramũ 'gã 'ã “Emi'uu 'ã 'ga ra'e”, 'jau etee jee nũ. “Itywet ma'e 'gã jekoty'aawa 'ga ra'e, 'wyriararete upe ka'aranũũ pyykara 'gã jekoty'aawa 'ga ra'e”, 'jau etee 'gã jee nũ— 'jau 'ga 'gã nupe. —Kunumĩ 'jawe 'gã. Juã 'ga ree ra'ne 'gã 'ã oporomutare'emamũ rakue. 'Awamũ 'gã 'ã je ree nanẽ oporomutare'emamũ nũ. Kunumĩ 'jawe 'ã 'gã jemogyi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","—Jarejuwarete 'ga je'eg imũ jane mama'e aporamũ, jane pyriwara 'gã nipo 'jau: “A'jea futat. Janeruwarete 'ga 'ã i'akwaap. Sã'ã 'ga remiayuwa 'gã neko esagea”, 'jau nipo 'gã janee, janereko esage resag ire— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anure fariseu 'ga amũ 'ua, Simão 'jawa 'ga 'ua Jejui 'ga upe oje'ega: —Ekwaw iki ejemi'waa ore pyri— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A'erauwe Jejui 'ga wemiayuwa 'gã nerawau ojemi'waa Simão 'ga rog ipe. A'eramũ kũjã tywera ẽẽ 'ga rera renupa. “'Au 'ga ruri 'ũina ojemi'waa 'ga pyri” 'e renupa. A'erauwe ẽẽ ojany kasiga pyyka erua. Itasiga apopyra aipo jany kasiga ryrũa, aripasi 'jawa apopyra. A'eramũ ẽẽ ipyyka erua enafu'ama Jejui 'ga py pyri. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'Ua ajaa'wau 'ga ree. A'eramũ ẽẽ 'ga py pireita weay pyu etee futat. A'ere ẽẽ 'ga py mukagi u'awa pyu etee futat. A'ere ẽẽ 'ga py sĩmytea. A'ere 'ga py sĩmyter ire jany kasiga reko'woka 'ga py are 'ga pyeita ipyu. Werowiaramũ Jejui 'ga ẽẽ tywera moia ẽẽ wi. A'eramũ ẽẽ 'ua otywera moiawamũ ẽẽ 'ga py sĩmytea, jany kasiga reko'woka 'ga py are. Ẽẽ ku'ia ẽẽ rerekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","A'eramũ “ekwaw iki ejemi'waa ore pyri”, 'ga upe 'jarera 'ga 'jau ojeupe: “A'jea futat sipo 'ga Jarejuwarete 'ga je'ega mome'wara 'ga? Ma'eramũ sipo ajee 'ga kũjã tywera nokwaawi?” 'jau 'ga 'ũina ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A'eramũ Jejui 'ga ikwaapa aipo 'ga 'e 'ga renamũ. A'eramũ 'ga 'jau 'ga upe: —Morogyta mũ je amome'u enee, ki Simão. A'eramũ ene ikwaapa 'jau— 'jau 'ga 'ga upe. —Ere ki ajee imome'wau jee 'wei— 'jau Simão 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A'erauwe Jejui 'ga mama'e mũ mome'wau 'ga upe aipo ojeupe 'erauwe: —Kũima'e 'gã amũ ka'aranũũ jara 'ga upe 'jau: “Ka'aranũũa emut ape oree”, 'jau 'gã awau 'ga upe. A'erauwe ka'aranũũ jara 'ga ka'aranũũ muri 'gã nupe. Majepeja 'ga “kwaiwete emut jee”, 'jau 'ga upe. Ajepeja 'ga “inãinãnĩ'ĩ etee emut jee”, 'jau 'ga upe. —Ko'iko'i ete nipo ka'aranũũ jara 'ga ruri ojewi erawarera 'gã nupe 'jau: “Pe'je je mepyau. Teka'aranũũa ako je omono pẽ nupe ai'i”, 'jau 'ga awau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","—A'ere 'ga wi ka'aranũũ rerawarera 'ga 'i etee 'ga upe: “Nitywi ka'aranũũa. Noreka'aranũũi we ore”, 'jau etee erawarera 'gã ka'aranũũ jara 'ga upe. —A'eramũ ka'aranũũ jara 'ga 'jau 'gã nupe: “Au'je nipo ajee 'ja. Nafutari je ka'aranũũa. Nafutaru'jawi je tejeupe pẽẽ imepya nanẽ nũ. Najerea'aru'jawi je 'awamũ ka'aranũũ are”, 'jau nipo 'ga 'gã nupe— 'jau Jejui 'ga Simão 'ga upe. A'eramũ Jejui 'ga 'jau Simão 'ga upe: —Mõ 'ga te ka'aranũũ jara 'ga afutarete?— 'jau 'ga Simão 'ga upe. —Inãinãnĩ'ĩ erawarera 'ga? Tuwiuu erawarera 'ga te ra'u nũ?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A'erauwe Simão 'ga 'i: —Tuwiuu erawarera 'ga te 'ga futarete. Inãinãnĩ'ĩ erawarera 'ga 'ga inãinãnĩ'ĩ etee afutat— 'jau Simão 'ga Jejui 'ga upe. —A'jea futat ere. Kwaiwete te 'ã ẽẽ tywera. Ma'eramũ 'ã ẽẽ ojewi je imoiramũ je futari nanimenime. Inãinãnĩ'ĩ etee itywet ma'e 'gã inãinãnĩ'ĩ etee je futaa otywera moir ire— 'jau 'ga 'ũina imome'wau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aipo 'e re Jejui 'ga ojerowaka kũjã ẽẽ ree. Ẽẽ ree ojerowag ire 'ga oje'ega Simão 'ga upe: —Ereesak te 'aga kũjã ẽẽ ra'e?— 'jau 'ga Simão 'ga upe. —Sipokwaap te 'ã jane jarejuog ipe jaresea 'oga jara 'ga remiayuwa jarejepyeja— 'jau 'ga Simão 'ga upe. —A'ere ako nereapoi jee nan ko. A'ere 'ã ko kũjã ẽẽ ruri weay pyu je pyeita. A'ere 'ã ẽẽ jepy pirei re u'awa pyu etee futat jepy mukaga nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Eje'wyr ipe je waẽmamũ ako najeretywape pyteri ape ko. Jarejemiapo 'ã nereapoi jee— 'jau 'ga Simão 'ga upe. —A'ere 'ã koa kũjã ẽẽ ruri owaẽma jee jepy sĩmytea. Jepy sĩmyteru'jau'japa. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Janya ako ene imonowe'em jeakag are ko. A'ere 'ã ẽẽ jẽmĩ jany monoi jepy are— 'jau 'ga Simão 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","—Ẽẽ tywera 'ã kwaiwete ẽẽ rekoramũ ra'e jepi. Ma'eramũ 'ã ẽẽ otywera ojewi je imoiramũ je futari je rerekou— 'jau 'ga Simão 'ga upe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A'ere Jejui 'ga 'jau kũjã ẽẽ upe: —Enetywera ako je omoit ene wi ko— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aipo Jejui 'ga 'eramũ 'ga pyriwara 'gã 'jau ajaupe: —Awỹja a'eramũ ẽẽ tywera moia ẽẽ wi 'ũ?— 'jau 'gã ajaupe. —Janeruwarete 'ga etee te wapo nanuara aetywera omoit ae wi— 'jau 'gã ajaupe, “omoit je ako enetywera ene wi ko” 'e renuw ire 'gã 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A'ere Jejui 'ga 'jau ẽẽ upe: —Je rerowiat te 'ã ape ekou rai'i. A'eramũ je 'agamũ tejerowiaramũ ene katu'oka enetywera pe'au ene wi— 'jau 'ga kũjã ẽẽ upe. A'eramũ Jejui 'ga 'jau ẽẽ upe: —Ere ewau eje'wyr ipe nũ. Jaruete ene 'awamũ. Ere ewau ejewya eje'wyr ipe. Enepy'a'wyt kasi ewau ekou ne— 'jau 'ga ẽẽ upe oje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Anure Jejui 'ga awau akou watau amunawa moyka 'gã mu'jau: —Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga imoiri pẽ nui. A'eramũ 'ga pẽ mogyau wemiayuwamũ— 'jau 'ga awau akou 'gã nupe oporogytau. —Pejemogy esage ki Jarejuwarete 'ga remifutar imũ etee futat— 'jau Jejui 'ga 'gã nupe akou. 'Ga remimu'e 'gã awau 'ga rupi. Tusi 'gã awau 'ga rupi. Tusi 'gã etee 'ga amũ'ẽ wemiayuwamũ rakue. A'eramũ 'gã akou 'ga rewiri etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kũjãmera 'gã nanẽ awau 'ga rewiri nũ. Kũjãmera 'gã nanẽ 'ga ikatu'oka rakue nũ. Ojero'wu ma'e 'gã nanẽ 'ga ikatu'oka rakue, mama'eukwaawa rerekwara ẽẽ retee rakue. A'eramũ 'gã awau 'ga rupi. Okatu'og ire 'gã awau 'ga rupi, mama'e apoawamũ akou 'ga upe, 'ga poaa akou. Ajepeja ẽẽ rera Maria. Mari ẽẽ rera mukũi. Matarena 'jau ẽẽ upe. Janeruwarete 'ga okatu'oge'emamũ ẽẽ pirewara kwaiwete ẽẽ ree rakue, sete ẽẽ tywera rakue. A'ere Jejui 'ga imoia ẽẽ wi. A'eramũ ẽẽ awau 'ga rewiri. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ajepeja ẽẽ rera Juana. Ẽẽ mena 'ga rera Kusa. Erote 'ga roga raarana 'ga poromũ Kusaramũ. Jejui 'ga okatu'og ire Juana ẽẽ awau 'ga rupi. Ajepeja ẽẽ rera Susana. 'Gã pytuna 'gã awau 'gã nupi. Kwaiwete futat kũjãmera 'gã pytuna awau 'gã nupi. Okaraemã 'gã imonou Jejui 'ga upe. Ka'aranũũ, taity, temi'uram. Mĩnamũ kũjãmera 'gã imonou 'ga upe 'ga poaa. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kwaiwete 'gã 'ua ajatykau Jejui 'ga resaka. Amunap tesirũmer awi 'gã 'ua ajatykau 'ga ree. 'Gã jatykapaw ire Jejui 'ga mama'e mũ mome'wau 'gã nupe 'gã mu'jawamũ: ");
INSERT INTO kyzNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Kũima'e 'ga amũ juowuuran a'ỹja momopoa oko pe. A'eramũ a'ỹja mũ u'aa pe pe 'ga wi. A'eramũ pe rupi oo ma'e 'gã a'e are opyruga 'ga wi. Wyra'ia nanẽ futat 'ua ojypa i'wau 'ga wi nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Amumera ywy a'wyre'ema pype u'aa 'ga wi. A'eramũ nipo opopoa futat numiamũ. A'ere nipo ita rakuwa ijukai etee. Nitywi wejue 'yja jupe. A'eramũ awau owaẽma kamẽsĩetei ita upe. A'eramũ ita rakuwa ijukau etee. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Amumera u'aa juemy pype. A'eramũ jua imoteu etee 'ga wi. Ikaapire'ema pype u'aa 'ũina. A'eramũ jawaiwa iapisau etee. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amumera a'ỹja te aje u'aa ywy katurama pype. A'eramũ opopoa. A'eramũ futat nipo awau u'aramũ. Kwaiwete u'aramũ. Aipo 'ywa sẽg i'aa 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. —Ee pejejeapyoweramũ ki peapyaka katu jeje'eg are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A'eramũ Jejui 'ga remimu'e 'gã 'jau 'ga upe: —Norokwaawi ore. Ma'ja are te ore mu'e ape poromũ?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A'eramũ Jejui 'ga 'jau 'gã nupe: —Jeruwarete 'ga je mut pẽ mu'jau morogyta yau are. 'Awamũ Jeruwa 'ga pẽ mogyi wemiayuwamũ jeje'ega renupa katu katuaramũ, a'e je pẽ nupe. A'ere je morogytai etee imome'ui pẽ nupe pẽ mu'jaawamũ ee. Kasi a'e pe tesirũmera 'gã we, ikwaawi erujewi ne, a'e je. Jeje'eg are eapyowere'ema 'gã wanup futat jeje'ega numiamũ. A'ere 'gã naeapyoi futari ee. Amã'jãu agawewi 'gã jeremiapofer are. A'etea 'gã naeapyoi ee. Ma'eramũ je 'ã morogytau etee imome'ui pẽ nupe pẽ mu'jawamũ. Imome'u esage re 'gã neapyo ekoeteramũ ajemogyau ee ne— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Peapyaka jeje'eg are. Tamueapyo pẽẽ teje'eg are 'jau. Sã'ã y'wa a'ỹja mũ 'ara pe pe 'ga wi. A'ea 'ã wyra'ia 'ua i'wau etee. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nan tee futat Janeruwarete 'ga je'ega renupara 'gã amũ. 'Ga je'ega renuwi futari numiamũ. A'ere nipo 'gã naeapyoi ee. A'eramũ mama'eukwaawa 'wyriara 'ua erowiarukare'ema 'gã nupe. “Perowiar awi”, 'jau nipo 'ua 'gã nupe. A'eramũ nipo 'gã momoirukaa je rerowiar awi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Sã'ã amumera y'wa a'ỹja 'ara ywy a'wyre'ema pype ipopora numiamũ. A'eramũ 'ã jawaiwa ijukau etee nũ. Nan tee futat nipo 'gã amũ je rerowiaa numiamũ. A'ere nipo amumera 'gã nuri, “Iro ererowiat aipoa?” 'jau nipo 'ga 'ua 'gã nupe. A'erauwe nipo 'gã poiri je rerowiar awi, je upe oporogyta awi. “Nia'wyri 'ga porogyta ra'e”, ojeupe 'erauwe nipo 'ga poiri je rerowiar awi— 'jau Jejui 'ga 'gã nupe u'ama imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Amumera y'wa a'ỹja u'aa ju pype. A'eramũ opopoa futat numiamũ. A'ere jua imoteu etee. Nan tee futat nipo 'gã amũ jeje'ega renuwaiwi etee. A'ere nipo 'gã wemifutar are etee wea'aramũ akou nũ. Wea'aru'jawe'emamũ nipo 'gã jeje'eg are. Ojemuorypaw are etee nipo 'gã wea'aramũ akou. Okaraemã momytun are etee nanẽ nipo 'gã wea'aramũ akou nũ. A'eramũ futat 'gã wea'aru'jawe'emamũ nipo 'gã jeje'eg are. Jeremifutar imũ nipo mama'e apowe'em futat— 'jau Jejui 'ga 'gã nupe u'ama imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Amumera y'wa a'ỹja mũ nipo u'aa ywy katurama pype. A'ea nipo awau waranupa u'aramũ. Nan tee futat nipo Ku'jywa 'ga je'ega renupara 'gã neapyoramũ ajemogyau ee. Wago'oramũ miamũ 'gã nopoira'uweri futari je rerowiar awi. Ojemogypyyka etee futat nipo 'gã ajemogyau je ree. Jarejuwarete 'ga pãjẽ mũ etee futat nipo 'gã mama'e esage apou ajemogyau— 'jau Jejui 'ga 'gã nupe u'ama imome'wau, 'gã mu'jau 'Uwarete 'ga je'ega renuw are. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A'eramũ 'ga 'jau 'gã nupe nũ: —Peenup katu katu ki je'ea. Nomonyga'uweri ae arãparĩna mũ imỹina imima mama'e 'ag are. Imonyg ire ae imonoi jakatupe te imỹina ajuesawamũ te. A'eramũ ose ma'e 'gã esaka tenamũ. Nan tee futat kasi jeje'ega pemim ine. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mama'e jemima 'ã nepekwaawi. A'ere nipo anure te pekwaap. Sã'ã ae mama'e monoa imima imỹina. A'eramũ 'ã ae mũ esake'ema. A'ere 'ã ae anure esaka ajaupe. Nan tee futat pẽẽ. 'Awamũ jeje'ega nepekwaawi. A'ere anure te nipo pekwaap ikwaapare'emamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Peenup katu katu ki je'ea. Jeje'eg are eapyowet ma'eramũ Janeruwarete 'ga pẽ mueapyoi ee. A'ere 'ga jeje'eg are eapyowere'ema 'gã namueapyoi ee. Ee 'gã neapyoweramũ etee te 'ga 'gã mueapyoi ee— 'jau 'ga 'gã nupe. —A'ere ee eapyowere'ema 'gã amu'eawera moka'jamawi etee— 'jau Jejui 'ga 'gã nupe u'ama imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Ga porogyta 'ga 'amamũ 'ga y ẽẽ 'ua, 'ga rewirera 'gã netee 'ua owaẽma 'ga upe. A'ere mytuna 'gã nuwi 'ga porogyta renupa. A'eramũ 'ga y ẽẽ 'ure'ema 'ga rerowyka. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A'eramũ 'ga amũ 'jau Jejui 'ga upe: —Eney ẽẽ 'ut owaẽma janee. “Taporogyta kĩã upe 'jau”, e'i eneya. Enerewirera 'gã netee ẽẽ ruri ra'e— 'jau 'ga Jejui 'ga upe. Aipo ojeupe 'eramũ Jejui 'ga 'jau 'ga upe: —A'jea— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A'eramũ 'ga 'jau ojepyriwara 'gã nupe: —Jeruwarete 'ga je'ega renuparamũ jerewirera 'jawe futat pejemogy jee— 'jau 'ga 'gã nupe. —Kũjãmeramũ nanẽ Jeruwarete 'ga je'ega renuparamũ jey 'jawe pejejemogyau jee nũ— 'jau Jejui 'ga u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jejui 'ga wemimu'e 'gã neru'aa erawau erekou eroyaapa yaruu pype. —Soo jareyaapa 'jau— 'jau 'ga 'gã nupe. A'eramũ futat 'gã awau oyaapa. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Oyaapaw ipe Jejui 'ga osea 'upa yaruu pype. 'Ga set 'ga ruwamũ ywyruua 'ua 'gã nupe. A'eramũ 'y monou yara pype 'gã nupe. Yaruu matyneema werewi 'y pyu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A'eramũ 'gã Jejui 'ga momaka: —Ku'jyp! Ere ejua epaka kũi! Sapap jane kũi— 'jau 'gã 'ga upe. A'erauwe futat 'ga fu'ami oje'ega ywyruu upe, 'y rajapetega upe nanẽ nũ. A'eramũ futat ywyruua wojeramũ. 'Y rajapetega nanẽ wojeramũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A'eramũ 'ga 'jau 'gã nupe: —Ma'eramũ te nepejemogypyygi etee je ree? Nepeesagi nipo pejejepype je rekoa ki sa? Je te 'ã areko pẽẽ— 'jau 'ga 'gã nupe. A'eramũ 'gã oporesagamũ etee 'ga ree. —Ma'e pãjẽ 'ga te jane sireko jarejepype nũ'ũ?— 'jau etee 'gã ajaupe. —Ywyruua te 'ã 'ga amuojet erujewi jarejewi a'i kũi. 'Y rajapetega nanẽ 'ga 'ã imuojea nũ— 'jau 'gã ajaupe. —Ma'e pãjẽ 'ga te nũ'ũ? Naesagi pa je 'ga amũ je'ega ywytu upe jepi nũ, ywytu muojera erujewi jepi nũ— 'jau 'gã ajaupe oporesagamũ 'ga ree. —Janeruwarete 'ga te wapoukat 'ga upe nũ'ũ— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Garireja ypiauu raapa 'gã awau akou. Kwe katywara 'gã 'wyra katy 'gã awau akou. Gerasa 'jau 'gã oje'wyra upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Peuwara 'ga amũ 'ua yar awi 'ga ẽm ypyrauwe 'ga repejãna. Mama'eukwaawa rerekwara 'ga 'ua 'ga repejãna. Aipo 'ga akou imara'ne ma'e 'jawe. Waitye'eme 'ga akou. Namutat 'ga akou. Nokoi 'ga 'og ipe. Tywy 'arimũ etee futat 'ga akou. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Mama'eukwaawa 'ga pyyka 'ga rerekou. A'eramũ peuwara 'gã okyjau 'ga wi. A'eramũ 'gã 'ga kupyfaa itajuu pyu. A'ere 'ga imopeni etee. A'eramũ mama'eukwaawa 'ga rerawau ejaa imỹina ae rekwawe'em ipe. A'e 'ga poromũ 'ut Jejui 'ga resakawe u'aa 'ga rowase. A'eramũ 'ga pirewara wafukaita Jejui 'ga upe: —Jejui. Ku'jywa 'ga ra'yra 'ã ene. Maran te ore rereko ape? Ore rereko tywet kasi ape ne— 'jau mama'eukwaawa Jejui 'ga upe. Kũima'e 'ga wi uẽme'emawe 'jau poromũ 'ga upe, “ore rereko tywet kasi ape ne”, 'jau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—Ma'ja te enerera?— 'jau 'ga mama'eukwaawa upe. —Kwai 'jau 'gã oree— 'jau etee 'ga upe. Kwaiwete 'ga pirewara. A'eramũ 'gã 'ga renũina, Kwai 'jau etee 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—Ore monoukat kasi ape ore rereko tyweaw ipe ne— 'jau 'ga pirewara Jejui 'ga upe. —Tajaurana ywyteripe ore mono ape ore mogyau— 'jau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aipo 'eramũ tajaurana ajemogyau muku'i te ojemi'waa. “Tajaurana pype ore mono ape ore mogyau” 'erauwe 'ga 'jau jupe: —Pe'je ajee pejewau— 'jau 'ga 'ga pirewara upe. A'erauwe awau. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","A'eramũ tajaurana mama'eukwaawa ojepype ijejagamũ erowawaka erajemogyau. A'eramũ erawau enujãna erojypa ywy'amuku rupi eropopoa erawau eropapa 'y pe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A'ere tajauran are omaenun ma'e 'gã awau imome'wau 'gã nupe: —Jejui 'ga 'ga pirewara omono tajaurana pype ko. A'eramũ opapa ko— 'jau 'gã awau imome'wau 'gã nupe 'gã moymoyka. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A'eramũ 'gã awau esaka. Awau 'gã amã'jãu mama'eukwaawa rerekwarera 'ga ree. Irãã'ã 'ga renamũ 'ga apygamũ. A'eramũ futat 'gã mopy'a'wya etee. —Nanarũi 'ga rekoi jepi— 'jau 'gã ajaupe. —A'ere 'ga 'ã ojewi imoir ire 'ga rekoi ojekatu'oka. Ojeyrũwunepa 'ga 'ã akou 'awamũ— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","'Ga resakarera 'gã imome'wau tesirũmera 'gã nupe: —Jejui 'ga mama'eukwaawa omoit 'ga wi ai'i. A'eramũ 'ga 'awamũ ojekatu'oka akou— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","A'eramũ peuwara 'gã okyjau Jejui 'ga wi. Nokwaawi wejue 'gã 'ga porowykya. 'Ga pãjẽa nanẽ 'gã nokwaawi nũ. A'eramũ 'gã okyjau Jejui 'ga wi. A'eramũ 'gã 'ga monou ojewi. —Ere ejepe'au ore wi, ki Ku'jyp— 'jau 'gã Jejui 'ga upe. A'erauwe 'ga awau u'aa yar ipe nũ. A'eramũ futat 'ga awau oyaapa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","—Too ene rupi 'jau— 'jau mama'eukwaawa rerekwarera 'ga Jejui 'ga upe. A'ere 'ga nuerooi 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Naani. Ere ewau eje'wyr ipe nũ. Ekatu'okawera ekwap imome'wau ekou 'gã nupe— 'jau 'ga 'ga upe. —“Janeruwarete 'ga je katu'ok”, ere ki epytuna 'gã nupe— 'jau 'ga 'ga upe. A'erauwe 'ga ojewya awau oje'wyr ipe nũ. A'eramũ futat 'ga okatu'okawera mome'wau akou 'gã nupe: —Janeruwarete 'ga je katu'ok ai'i. A'eramũ 'ga 'agamũ je katu'oka je mogou— 'jau 'ga 'gã nupe. —A'eramũ je tejua tekou pẽ pype nũ, mama'eukwaawa tejewi enuẽm ire nũ— 'jau 'ga 'gã nupe. A'eramũ 'ga awau akou amunawarete pyterimũ imome'wau peuwara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","A'eramũ Jejui 'ga awau ojewya oyaapa nũ. Mytunũũ 'gã ajatykau 'upa 'ga renune. A'eramũ 'gã aku'iramũ 'ga ree, 'ga ruramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A'eramũ kũima'e 'ga amũ 'ua owaẽma Jejui 'ga upe. Jairo 'ga 'ua wapyka wenupy'ãu 'ga rowase. Esage ma'e 'ga te Jairo 'ga. Judeu 'gã jatykaawa raarana 'ga. Jejui 'ga porogyta 'ga erowiaa. A'eramũ 'ga 'ua wapyka wenupy'ãu 'ga rowase, oje'ega 'ga upe. —Ejot je'wyr ipe. Jera'jyra nipo 'ã amanũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ejot ẽẽ resaka jee. Nirũi jera'jyra ẽẽ. Kũjãmuku'ia ẽẽ— 'jau 'ga Jejui 'ga upe. —Ere ajee iruukwe. Taesak ẽẽ enee 'jau— 'jau Jejui 'ga 'ga upe. A'eramũ 'ga awau 'ga rupi. Kwaiwete 'gã awau 'gã newiri. Ojopypypypyka 'gã awau. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nan 'gã waw ipe kũjã ẽẽ mũ 'ua Jejui 'ga rupisika. Ojero'wu ma'e ẽẽ 'ua 'ga rewiri. Tusi kwara ẽẽ imu'aa akou ojero'wau. Nuogi futari ẽẽ rya ẽẽ wi. Ymã te ẽẽ rekoi rakue. Morofuanugara 'gã nupe ojesaukaa rakue numiamũ. A'ere 'gã nokwaawi ẽẽ karuara. Ajepeja 'ga upe ẽẽ awau ojesaukaa nũ. A'ere 'ga nãnẽwẽjẽmĩ nokwaawi ẽẽ wi nũ. A'eramũ morofuanugara mepyetea ẽẽ ka'aranũũ mateepapa ekoete ẽẽ wi. A'ere ẽẽ nojekatu'ogi futari. Nitywi futari muaga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A'eramũ ẽẽ 'ua 'gã ata pype Jejui 'ga rewiri. “Kĩã raity pyygamũ tajekatu'ok 'jau kwy”, 'jau ẽẽ ojeupe. A'eramũ ẽẽ 'ua 'ga rupisika, 'ga raity pypireme'ywa pyyka. A'erauwe ẽẽ rya uoka ẽẽ wi. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A'eramũ Jejui 'ga 'jau 'gã nupe: —Awỹja te owyk jeraity are ra'e?— 'jau 'ga 'gã nupe. —Tee. Naje rũi— 'jau tee 'ga rewiri oo ma'e 'gã 'ga upe. A'eramũ Pedro 'ga 'jau 'ga upe: —Kwaiwete te 'gã 'ã ki jã. A'eramũ 'gã okwaapawe'emamũ. Ojopypypypyk te 'gã 'ã— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A'ere Jejui 'ga 'i 'ga upe: —Naani. Akwaap je 'ga amũ tepyyga. Jepãjẽa oo oporokatu'oka— 'jau etee Jejui 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A'erauwe ijaruete ma'efera ẽẽ 'jau ojeupe: “Najemima'uweri je kĩã wi. Okwaap futat kĩã”, 'jau ẽẽ ojeupe. A'eramũ ẽẽ awau wapyka wenupy'ãu 'ga rowase. Oyyita ẽẽ ojemome'wau 'ga upe: —Je ako awyk eneraity are ko. Ymã te jerya nuogi je wi. A'ere eneraity are je wygauwe iogi je wi ko— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A'eramũ Jejui 'ga 'jau ẽẽ upe: —Je rerowiat wejue te 'ã ape ra'e jepi. A'eramũ je ako ene katu'oka ko— 'jau 'ga ẽẽ upe. —A'eramũ ki ene epy'ata'waramũ ekou. Enejaruete ene ekou— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ẽẽ upe Jejui 'ga porogyta 'ga 'amamũ, Jairo 'ga remiayuwa 'ga amũ 'ua 'ga rewiri. —Amanũ enera'jyra ko. Au'je 'ga reruri re— 'jau 'ga 'ua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A'ere Jejui 'ga enuwi 'ga upe 'ga 'ea. A'eramũ 'ga 'jau 'ga upe: —Ene'arasig awi. Tejerowiaramũ je enera'jyra moferawi enee nũ— 'jau 'ga 'ga upe. A'eramũ 'ga awau 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","'Og ipe owaẽmawe Jejui 'ga 'jau wewiri oo ma'e 'gã nupe: —Peu etee futar iki pejup. Ore tee futat oroo orosou ẽẽ resaka— 'jau 'ga 'gã nupe. A'eramũ 'ga rupi oo ma'efera 'gã ukupepe etee futat 'upa. Pedro 'ga, Tiago 'ga, Juã 'ga, kũjãmuku ẽẽ y ẽẽ, ẽẽ ruwa 'ga. Mĩmera 'gã etee awau osou Jejui 'ga rupi ẽẽ resaka. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ẽẽ pytuna 'gã ajaa'wau ẽẽ ree. A'eramũ Jejui 'ga 'jau 'gã nupe: —Pejoo'o awi ẽẽ ree. Oset tee ẽẽ 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A'eramũ 'gã 'jau 'ga upe: —Ene'me awi nũ'ũ. Amanũ futat akiko— 'jau 'gã 'ga upe. “Amoferap nipo je ẽẽ re'ã”, 'jau 'ga ojeupe. A'eramũ 'ga poromũ 'jau 'gã nupe, “Oset tee ẽẽ 'upa”, 'jau etee 'ga 'gã nupe. A'eramũ 'ga 'gã mũ'jãu ojewi. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","A'eramũ 'ga awau amanũ ma'efera ẽẽ popyyka. —Ere ejua ewya, ky'ri— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A'eramũ futat ẽẽ oferapa. A'erauwe futat ẽẽ afu'ama. A'ere 'ga 'jau ẽẽ y ẽẽ upe: —Pe'je ẽẽ mojemi'waa— 'jau 'ga ẽẽ upe. A'erauwe ẽẽ wa'yra ẽẽ mojemi'waa. ");
INSERT INTO kyzNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ẽẽ ferawamũ ẽẽ jara 'gã oporesagamũ ẽẽ ree. A'eramũ futat ẽẽ ruwa 'ga 'jau ojeupe: “Amanũ ako jera'jyra ako re'ã. A'ere pa 'ga 'ã jera'jyra moferawi jee nũ”, 'jau 'ga ojeupe. A'eramũ Jejui 'ga 'jau 'gã nupe: —Je mome'u kasi ape kwe pe 'gã nupe ne, 'au je iapoawera ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Anure 'ga wemimu'e 'gã majatykau, tusi 'gã majatykau. A'eramũ 'ga opãjẽ monou 'gã nupe: —Pe'je pejewau je mome'wau kwe pewara 'gã nupe. Mama'eukwaawa ki pemoit 'gã nui jeje'eg imũ. Pekatu'og iki 'gã je 'jawe futat. “Je katu'og ape” 'eramũ Ku'jywa 'ga pẽ katu'ogi pẽ monou wemiayuwamũ, pe'je ki tesirũmera 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","—Pejemama'e mũ rerawawe'em futat pejejeupe. Ywyraa miamũ futat erawawe'em pejepo pe. Ka'aranũũ ryrũa nanẽ erawawe'em nũ. Pejejemi'urama nanẽ pẽẽ erawawe'em futat nũ. Ka'aranũũ miamũ pẽẽ erawawe'em. Pejejyrũmũ rerawawe'em futat 'jau. Pejepit arewara etee futar iki peroo. Nan etee te futar iki pekwap. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","'Gã 'wyrarete upe pejewaẽma majepeja 'oga pype etee futat ki pejup. Peo kasi kwe pe pejejemogyau ne. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pejeporogyta renuwe'emamũ pẽẽ kamẽsĩete pejewau amunaw awi. Ajepeja 'gã 'wyrarete pe pejewau nũ. 'Gã nui pejewau ki pejepyapaawa penupãnupã, 'yja motototoka jui. “Janeruwarete 'ga 'ã pẽ katu'og are ifuewet numiamũ. A'ere 'ã nepefutari etee,” 'jau ki pẽẽ pejewau pejejemogyau pejepyapaawa nupãu ajuee 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A'eramũ 'ga wemimu'e 'gã monou mukũi juejue amunawa moymoyka. Jejui 'ga ree morogyta esagea 'gã awau imome'wau 'gã nupe. Ojero'wu ma'e 'gã katu'oka nanẽ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Anure Erote 'ga, Garireja ywy pewara 'gã 'wyriara 'ga, Jejui 'ga rera renupa. 'Ga amũ Jejui 'ga remiapofera mome'wau 'ga upe. A'eramũ 'ga opy'a'wyramũ 'ga rer are. A'eramũ 'ga 'jau wemiayuwa 'gã nupe: —Awỹja te poromũ ako?— 'jau 'ga 'gã nupe. A'eramũ 'gã amũ 'jau: —Amanũ ma'efera 'ga amunipo 'ã 'ut oferapa rai'i nũ kũi— 'jau 'gã 'ga upe. A'eramũ amumera 'gã 'jau: —Nipo ajee Juã Batista 'ga 'ut oferapa rai'i nũ 'ja. Maranamũ nipo Eliasi 'ga kũi— 'jau 'gã 'ga upe. A'eramũ 'gã amũ 'jau: —Tee nũ'ũ. Amutee 'ga te nipo nũ'ũ— 'jau 'gã 'ga upe. —Naokoiwera 'gã nũi nipo nũ'ũ. Janeruwarete 'ga je'ega mome'wara 'ga amũ te nipo nũ'ũ— 'jau 'gã 'upa 'ga rera renupa. Aipo 'gã 'e 'gã jemogyramũ Erote 'ga 'ũina etee futat 'gã je'ega renupa. A'eramũ 'ga 'jau: —Tee. A'jea futat nipo. NaJuã Batista 'ga rũi. Je te ako 'ga ajukaukat ai'i. Ajuwonogukat 'ga ai'i. A'eramũ sipo awỹja 'wei?— 'jau 'ga 'ũina aipo 'eramũ. “Aesak werewi pa je 'ã 'ga nũ”, 'jau 'ga 'ga rera renupa 'ũina. A'ere 'ga nuesagi 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Anure Jejui 'ga remimonofera 'gã 'ua ojewya nũ. Imome'wau 'ua Jejui 'ga upe: —Kwe pe ako ore mono ape ejemome'waukaa 'gã nupe ai'i. A'eramũ ore ojero'wu ma'e 'gã katu'oka arakou ene 'jawe ai'i. Mama'eukwaawa nanẽ ore imoia arakou 'gã nui ai'i nũ— 'jau 'gã 'ua wekwawera mome'wau Jejui 'ga upe. Imome'upaw ire 'ga 'gã nerawau ajepeja amunaw ipe, Pesaita 'jaw ipe nũ. Kwaiwete tekotee 'gã nejaa. 'Gã tee awau. Wemimu'e 'gã tee futat 'ga erawau numiamũ. A'ere tekotee 'gã 'ga o kwaawi futari. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","A'eramũ 'gã 'jau ajaupe: —Oo futat 'ga ra'e nũ'ũ— 'jau 'gã ajaupe. —Pe'je soo 'gã newiri— 'jau 'gã ajaupe. A'eramũ 'gã awau 'gã newiri. Ojeupe 'gã waẽmamũ Jejui 'ga oporogytau 'gã nupe: —Janeruwarete 'ga afutat pejetywer awi pepoira. Pejetywer awi pepoiramũ 'ga pẽ monoi wemiayuwamũ. Najuejue etee futat 'ga pejetywer awi pepoira futari— 'jau 'ga 'gã nupe. 'Gã nupe oporogytapaw ire, 'ga ojero'wu ma'e 'gã katu'oka nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kaaruwamũ 'ga remimu'e 'gã 'jau 'ga upe: —Emono 'gã amunaw ipe 'gã nemi'urama murukaa 'gã nupe. Nitywi mama'ea 'au. “Pe'je pejewau mama'e mua pejejeupe. Peu pekwap pejesea”, ere 'gã nupe— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A'ere Jejui 'ga 'i etee 'gã nupe: —Naani. Pẽẽ futat mama'ea pemono 'gã nupe— 'jau etee 'ga 'gã nupe. —Nitywi mama'ea. Mukũi'ĩ etee ipira'ia. Sĩku etee nanẽ kanape'ia nũ. A'ea niapoi 'gã nupe. Eneporomuriwet nipo mama'e mua 'gã nupe? Kwaiwete te 'ã 'gã a'i kũi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kwaiwete 'gã. Sĩku miu te kũima'efera 'gã nuri 'upa 'ga porogyta renupa. A'eramũ 'gã poromũ 'jau 'ga upe: “Niapoi mama'ea 'gã nupe”, 'jau 'ga upe. A'ere Jejui 'ga 'i etee 'gã nupe: —Naani. Pemojo'ok 'gã. Kwaiwete 'gã 'ã. A'eramũ pẽẽ 'gã mojo'oka. 'Au sĩkwẽta 'gã pemuapyk. Peu sĩkwẽta 'gã muapyka 'jau. Peu nanẽ nũ. Peu nanẽ nũ 'jau 'gã muapykapap— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A'erauwe futat 'gã 'ga je'ega rupiwewe futat 'gã muapyka. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A'ere Jejui 'ga kanape'i pyyka opo pe ipira'i reewe. A'ere 'ga eramã'jãu ywau opo pe. A'eramũ 'ga oje'ega 'Uwarete 'ga upe: —Au'jete mama'ea eremut oree. Ene te 'ã eneresage oree— 'jau 'ga 'Uwarete 'ga upe. A'ere 'ga kanape'i mowowoka ipira reewe imopẽpena 'gã nupe. A'ere 'ga imonou wemimu'e 'gã nupe. —Pe'je imonou 'gã nupe— 'jau 'ga 'gã nupe. A'eramũ futat 'gã imonou 'gã nupe. 'Gã nupe omonorauwe ojeme'yita. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","A'eramũ 'gã ojomoyka kanape'i are ipira'i reewe. A'eramũ futat 'gã wewegamũ. —Janerewek jane ki 'ei— 'jau 'gã ajaupe. —Niapoi agawewi akiko. A'etea ojeme'yi janee 'ga omowowogamũ— 'jau 'gã ajaupe. —Janeruwarete 'ga te ome'yi janee. A'eramũ 'ã jarejewegamũ jarejemogyau— 'jau 'gã ajaupe. Ojemi'wapaw ire 'gã emyrera monou ijaga yrũ pype. Tusi yrupemũũ matyneema. 'Gã jemi'wapaw ire 'ga 'gã monou 'gã 'wyr ipe nũ. Opy'araypare'emamũ 'gã awau ajemogyau oje'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A'ere anurenure'i Jejui 'ga 'ũina oporogytau 'Uwarete 'ga upe ojetee'i. 'Ga porogytaaw ipe 'ga remimu'e 'gã 'ua owaẽma 'ga upe. A'eramũ 'gã 'ga rerowyka. A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'ja e'i te tekotee 'gã jee jepi?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—“Amanũ ma'efera 'gã amũ te nipo 'ã 'ut oferapa rai'i nũ”, e'i 'gã enee jepi. Amumera 'gã: “Juã Batista 'ga te nipo 'ã 'ut oferapa rai'i nũ”, 'jau 'gã enee jepi. Amumera 'gã: “Eliasi 'ga nipo 'ã 'ut ojewya rai'i nũ”, 'jau enee jepi. Amumera 'gã: “Janeruwarete 'ga je'ega mome'warera 'gã amũ nipo 'ã 'ut oferapa rai'i nũ”, 'jau 'gã enee jepi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Pẽẽ nũ. Ma'ja pe'je ajee jee jepi nũ'ũ?— 'jau 'ga wemimu'e 'gã nupe. A'eramũ Simão Pedro 'ga 'jau 'ga upe: —“Janeruwarete 'ga remimurera 'ga”, aru'e ore enee jepi— 'jau Pedro 'ga 'ga upe. —Je mome'u kasi ajee pejepe 'gã nupe ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat pe'je. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Je 'ã a'jea futat pẽneki'yraretea— 'jau 'ga 'gã nupe aipo ojeupe 'eramũ. —Anure nipo 'gã je rereko tyweretei. Kwaiwete nipo je ree iporomutare'ema 'gã. A'eramũ nipo 'gã je rerekou tyweaete. Judeu 'gã 'wyria'ri, mainana 'wyriat, Moisesi 'ga remikwasiarer are moromu'jat. Mĩmera 'gã nipo oporomutare'emamũ je ree— 'jau 'ga 'ũina imome'wau 'gã nupe. —'Gã nipo je juka. A'ere nipo imuapyra 'ara rupi Jeruwarete 'ga je moferawi etee nũ— 'jau 'ga 'ũina imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","24","—Jeremiayuwamũ pejejekoweramũ pẽẽ jeremifutar imũ etee futat mama'ea peapo. Pejekyjawe'em futat pejejereko tywer awi— 'jau 'ga 'gã nupe. —Pejemanũ awi miamũ pejekyjawe'em futat. Amumera 'gã nipo “Jejui 'ga rerowiaara je” 'eramũ ifuewet pẽ apisi are. A'ere kasi “naJejui 'ga rerowiaara rũi je”, pe'je 'gã nupe ne— 'jau 'ga wemimu'e 'gã nupe. —“Tene 'gã je jukai kwy”, pe'je etee ki. “Napoira'uweri je Jejui 'ga rerowiar awi”, pe'je etee ki. Jeremiayuwamũ pejejekoweramũ ki jeje'eg imũ etee futat peko— 'jau 'ga 'gã nupe. —“Najemanũweri je Jejui 'ga mome'u are” 'jara 'gã nooa'uweri futari ywag ipe Jarejuwarete 'ga pyri— 'jau 'ga 'gã nupe. —“Je naapoa'uweri futari mama'ea Jejui 'ga remifutar imũ” 'jara nanẽ awawe'em ywag ipe Jarejuwarete 'ga pyri— 'jau Jejui 'ga 'gã nupe. —Amumera 'gã te nipo ajee e'i “tene 'gã je jukai kwy”, e'i ajemogyau. “Napoira'uweri je 'ga rerowiar awi” 'jara 'gã etee awau ywag ipe, Jarejuwarete 'ga pyri— 'jau 'ga 'gã nupe 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","—Okaraemã mono'og are etee ea'at ma'e 'gã nanẽ ni'akwaawi futari. Kwaiwete agawewi 'gã karaemã. A'ere aipo 'gã miamũ nooi futari ywag ipe. Nomỹi 'gã weaa Jarejuwarete 'ga ree. Okaraemã me'yi are etee 'ga fueweramũ. A'eramũ 'gã awawe'em 'ga pyri. Mama'eukwaawa rapyaw ipe etee 'gã awau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","—Temome'u awi 'ga amũ jenosĩ re je nanẽ nipo tejenosõu 'ga wi tejewya nũ. “Je naJejui 'ga remiayuwa rũi” 'jara 'gã nipo okyjau je ree amanũ awi. A'eramũ je 'jau aipo 'jarera 'gã nupe: “Najeremiayuwa rũi 'ga”, 'jau nipo je 'gã nupe tejewya nũ— 'jau Jejui 'ga 'gã nupe. —Amanũ awi ikyje'ema 'gã te nipo 'jau, “Je te 'ã Jejui 'ga remiayuwa”, 'jau 'gã 'gã nupe. Aipo 'jarera 'gã te nipo je anure tejewya naenosĩ 'gã— 'jau 'ga 'gã nupe. —Anure je ruri tejewya ywagipewara 'gã netee 'awa ywy pe nũ. Mama'e tywera apoare'ema 'gã netee nipo tejua tejewya 'awa ywy pe nũ. Tejuwarete 'ga renyfuga pype je tejua tejewya anure. A'eramũ nipo 'gã 'jau jee: “Nitywi 'ga amũ ene 'jawe esage ma'e 'gã. Ene tete 'ã eneresageay oree”, 'jau nipo 'gã jee anure je jewyt je ruramũ— 'jau Jejui 'ga u'ama oporogytau 'gã nupe. —Aipo 'ara rupi futat nipo je 'i 'gã nupe, 'gã nowase. “'Agera 'gã jeje'ega wanuwa ajemogyau rai'i”, 'jau nipo je 'gã nupe 'gã nowasewase— 'jau 'ga u'ama oporogytau 'gã nupe. —Tejewyru'japa te nipo je ruri pẽ nupe pẽ'wyriat pãwẽ pãwẽnamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","—Anure nipo pẽẽ mũ je resak pejepe pejemanũme'ẽwe peje'wyriaramũ je rekoa. Jarejuwarete 'ga pãjẽa nipo pẽẽ mũ esaka— 'jau 'ga u'ama 'gã nupe oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Majepeja morowykye'ema magwaw ire, Jejui 'ga awau ywyty'rarimũ oporogytau 'Uwarete 'ga upe. Muapyra 'gã etee 'ga erawau ojeupi. Pedro 'ga, Juã 'ga, Tiago 'ga. Mĩmera 'gã etee 'ga erawau ojeupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","'Uwarete 'ga upe 'ga porogytaramũ 'ga reakwara ojesowo'gõka. 'Ga reakwara wenyfugamũ. 'Ga raitya nanẽ waparasigamũ 'ga ree nũ. Iaparasig enyfuk te 'ga raitya 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","A'eramũ futat mukũja 'gã 'ua oporogytau 'ga upe. Ywag awi 'gã 'ua oporogytau 'ga upe. Moisesi 'ga, Eliasi 'ga retee 'ua oporogytau 'ga upe. Tata enyfuga 'jawewara ywyteripe 'gã u'ama oporogytau. Jejui 'ga manũawama mome'wau 'ga upe: —Jerusareg ipe nipo ereo emanũmũ Jarejuwarete 'ga remifutar imũ etee futat. “'Ga manũa 'gã tywera tomepy 'jau”, e'i Janeruwarete 'ga enee— 'jau 'gã 'ga upe. —“A'eramũ 'ga 'gã katu'okaramũ akou 'jau”, e'i Janeruwarete 'ga enee— 'jau 'gã 'ga upe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","'Gã porogytaramũ 'ga rupi oo ma'efera 'gã osea 'upa. Poje 'gã opaka. Amã'jãmayayau Jejui 'ga renyfug are. Irãã'ã mukũja 'gã 'amamũ 'gã porogytaramũ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mukũja 'gã oja'wyja'wyramũ Pedro 'ga 'jau Jejui 'ga upe: —'Awa esageay janee ra'e. 'Au etee sapyta 'jau, ki Ku'jyp— 'jau 'ga 'ga upe. —'Au etee tapỹja taruapo amũ pẽ nupe 'jau. Ene upe, Moisesi 'ga upe, Eliasi 'ga upe 'jau— 'jau 'ga 'ga upe. Osera 'ga enafu'ama. A'eramũ 'ga u'akwaawe'emamũ oporogytau tyweruu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","'Ga porogytarauwe ywasiga mũ 'ua ojypa 'gã nee. A'eramũ futat ywasiga 'gã mima 'gã nui. Ywasiga etee 'gã mopiryyita ojypa 'gã nee nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","A'erauwe futat Janeruwarete 'ga oje'ega muri imojypa ywasiga rupi 'gã nupe: —Koromũ je ra'yrarete 'ga, jeremimurera 'ga. A'eramũ ki pẽẽ pejeapyakau 'ga je'eg are— 'jau 'ga 'gã nupe, oje'ega mua. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","'Ga porogytapawauwe ywasiga ojeupiapap 'gã nui nũ. Irãã'ã Jejui 'ga etee 'ga 'amamũ ojetee. Ywasiga rupi mukũja 'gã ojeupia awau. A'eramũ futat 'ga remimu'e 'gã opika etee futat. Nomome'ui futari 'gã tekotee 'gã nupe, miamũ ojewyr ire. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ai'iwe 'gã 'ua ojypa ywyty'rar awi nũ. A'eramũ futat kwaiwete 'gã 'ua Jejui 'ga rowosõu. 'Ga porogyta renupa 'gã 'ua. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jejui 'ga resakawe kũima'e 'ga amũ 'ua wafukaita 'ga upe: —Jejui! Esak jera'yra 'ga jee. Majepei tee jera'yra 'ga. Nirũi 'ga jee. A'eramũ ene ejua 'ga resaka jee. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mama'eukwaawa 'ga opyyk 'ga moypiwukaa 'ga muafukajukaa 'ga motyjuita 'ga juru rupi. A'ere 'ga pikapikapikau 'ga rerekou. Nopoiri futari 'ga wi. Esak 'ga jee— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","—“Pemoit 'ga wi”, a'e futat je eneremimu'e 'gã nupe ko. A'ere 'gã nomoiri etee 'ga wi ko— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'eramũ sipo pẽẽ je rerowiare'ema pejejemogyau 'ũ? Ymã agawewi nã'ã je pẽ mu'ei re'ã. A'etea nipo 'ã naje rerowiari tãmẽjẽ 'ã pejepe. “Nokoa'uweri je pẽ pype namutamutat”, a'e je pẽ nupe jepi— 'jau 'ga tesirũmera 'gã nupe nanẽ nũ. A'ere 'ga 'jau kunumĩ 'ga ruwa 'ga upe: —Ere 'ga rerua 'au jee. Taesak 'ga 'jau— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","A'erauwe futat 'ga wa'yra 'ga rerua. 'Ga upe 'ga waẽm ja'wyja'wyramũ mama'eukwaawa 'ga pyyka nũ. A'eramũ futat 'ga retyka ywyu. A'eramũ Jejui 'ga 'jau 'ga pirewara upe: —Ejepe'a 'ga wi— 'jau Jejui 'ga jupe. A'eramũ futat 'ga imoia 'ga wi. A'ere Jejui 'ga 'jau kunumĩ 'ga ruwa 'ga upe: —Kweramũ enera'yra 'ga nũ. Jaruete 'ga nũ— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A'eramũ esakarera 'gã oporesagamũ etee futat 'ga ree. —Mama'eukwaawa miamũ 'ã pãjẽa. Ku'jywa 'ga taetu te 'ã pãjẽretea— 'jau 'gã 'upa ajaupe. Aipo resakarera 'gã oporesagamũ 'ga ree kunumĩ 'ga katu'ogamũ. —Janeruwarete 'ga 'ã pãjẽretea futat. Nitywi 'gã amũ 'ga 'jawe— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Aipo 'gã 'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽneki'yra agawewi je 'ã. A'etea nipo Janeruwarete 'ga je pyygukat anurenure'i je ree iporomutare'ema 'gã nupe— 'jau Jejui 'ga wemiayuwa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","A'ere 'gã naeapyoi 'ga 'eawer are. Janeruwarete 'ga namueapyoi 'gã ee. A'ere 'gã jenosĩ 'ga upe oporonuw are. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A'ere 'ga remimu'e 'gã 'jau ajaupe: —Manamũ te jane Jarejuwarete 'ga upe esage ma'eramũ jarejuapyraapa?— 'jau 'ga remimu'e 'gã 'upa. Ajaupe etee futat oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","A'ere Jejui 'ga 'gã kwaawi. Ajaupe 'gã 'e kwaawi. Nuenuwi futari 'ga numiamũ. A'ere 'ga ikwaawi futari ajaupe 'gã 'ea. A'eramũ 'ga 'jau kunumĩ 'ga amũ upe: —Ere ejua 'au je pyri— 'jau 'ga 'ga upe. A'erauwe kunumĩ 'ga amũ 'ua 'ga repejãna 'ga rerowyka. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Peesak te kunumĩ 'ga 'ama je pyri?— 'jau Jejui 'ga 'gã nupe. —'Ga ree pejejejuka esageramũ je ree we futat pejejuka esage. Je ree pejejejuka esageramũ je muarera 'ga ree we futat pejejuka esage— 'jau Jejui 'ga 'gã nupe u'ama. —Aipo apoara 'gã esage ma'eramũ Jarejuwarete 'ga upe— 'jau Jejui 'ga 'gã nupe. A'eramũ 'ga 'jau 'gã nupe nũ: —“Je jeresage” na'jara 'gã nũi esage ma'eramũ Jarejuwarete 'ga upe. A'ere ajuee ojejuka esage ma'eramũ te ae esage ma'eramũ 'ga upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau esage ma'e 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A'eramũ Juã 'ga 'jau Jejui 'ga upe: —Kũima'e 'ga amũ ore aruesak mama'eukwaawa pe'aa 'gã nui ko, enerer imũ ko. A'ere norepytuna 'ga rũi ko. A'eramũ ore 'jau 'ga upe ko: “Ereapo awi nanuara”, 'jau ore 'ga upe ko— 'jau Juã 'ga imome'wau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aipo 'eramũ Jejui 'ga 'jau 'gã nupe: —Aipo pe'je awi 'gã nupe. “Peapo awi nanuara”, pe'je awi 'gã nupe. Najanepytuna 'gã nũi numiamũ. A'ere 'gã jane poari te janeporowyky apo are. A'eramũ 'gã janepytuna 'jawe futat ajemogyau— 'jau Jejui 'ga u'ama 'gã nupe aipo 'gã 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ywag ipe awawa upe iwaẽm ja'wyja'wyrauwe Jejui 'ga 'jau 'gã nupe: —Jerusareg ipe futat too 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A'ere 'ga wemiayuwa 'gã mũ ra'ne imonou wenune Samari ywy pe. —Amunaw ipe pekwap 'oga mũ resaka jarejee jareseawamũ— 'jau 'ga 'gã nupe. A'erauwe 'gã awau. Awau 'ga owaẽma amunawa mũ upe. A'eramũ 'gã oporogytau peuwara 'gã nupe: —Jejui 'ga ore mut 'au oroseawa mũ rekarukaa orojee ko— 'jau 'gã peuwara 'gã nupe. —A'ere nipo 'ga ruri ore rewiri. Ityp te oreseawa 'au?— 'jau 'gã peuwara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","A'ere peuwara 'gã 'i etee 'gã nupe: —Nitywi pẽseawa 'au nũ'ũ. Jerusareg ipe etee futat pekwap. Nepesera'uweri 'au— 'jau etee 'gã 'gã nupe. Samari ywy pewara 'gã najudeu joporemũremũa rũi. Ojopypepype 'gã. A'eramũ 'gã judeu 'gã futare'ema peu ojepype. A'eramũ 'gã ojewya 'ua Jejui 'ga pyri nũ. —“Nitywi pẽseawa 'au”, e'i 'gã oree ko— 'jau 'gã 'ua Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","A'e renupa Tiago 'ga 'jau Juã 'ga retee Jejui 'ga upe: —Jarejuwarete 'ga upe tee pa ore 'i “Tata emut 'gã nupe 'gã apisaupap”, aru'e te pa ore 'ga upe— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A'eramũ Jejui 'ga amã'jãu 'gã nee: —Ma'eramũ pẽẽ aipo 'jau ki 'ei. Naani. Aipo pe'je awi— 'jau 'ga 'gã nupe, oje'ega moywyrafena. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","—Pe'je ajee soo ajepeja amunaw ipe etee— 'jau Jejui 'ga 'gã nupe. A'eramũ 'gã awau. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","'Gã waw ipe kũima'e 'ga amũ 'ua oje'ega Jejui 'ga upe: —Too ene rupi 'jau— 'jau 'ga 'ua 'ga upe. —Taata tekou ene rewiri kwe pe ene orauwe 'jau— 'jau 'ga 'ua Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat nipo eneatawet je rupi ki sa? A'ere 'ã je najerogi te tekou a'i kũi. Kasuru'miara te 'ã ok. Ywy kwara 'ã 'ga roga. Wyra'i nanẽ 'ã waityramũ nũ. A'eramũ 'ã kaaruwauwe ojewya 'ua waity pype osea. A'ere je nanarũi. Aset ekoete te futat je tekou. Tekaarupaw ipe je tesea ekoete te futat tekou. Je 'ã pẽneki'yra agawewi. A'etea 'ã je najerogi tekou. Jeremiayuwamũ nan tee futat pejemogy. A'etea futat te eneatawet je rupi?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A'ere Jejui 'ga oje'ega ajepeja 'ga upe nũ: —Erejot te je rupi? Naani te ra'u nũ?— 'jau 'ga 'ga upe. —Naani. Nooi je 'awauwe ene rupi. Tene jeruwa 'ga manũi ra'ne. Tejuwa 'ga manũ re too ene rupi 'jau. 'Ga manũ re nipo a'jea futat tekou ywyapi ene rewiri. Tejuwa 'ga manũa ra'ne je aesak— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A'ere Jejui 'ga 'i etee 'ga upe: —Naani. Ene'me awi. 'Awauwe futat ejot je rupi. Eneruwa 'ga manũnamũ amutee 'gã totym 'ga enee 'jau— 'jau 'ga 'ga upe. —Ene tereko “Pe'je pejepoia pejetywer awi” 'gã nupe 'jaramũ 'jau— 'jau Jejui 'ga 'ga upe. —“Pejetywer awi pepoiramũ Janeruwarete 'ga pẽ monoi wemiayuwamũ” 'gã nupe 'jaramũ tereko 'jau— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A'ere 'ga amũ 'jau Jejui 'ga upe nũ: —Tene ajee je ra'ne. Too ene rupi 'jau— 'jau 'ga Jejui 'ga upe. —A'ere je oi tepytuna 'gã momoranupa ra'ne, “Oo je 'ga rupi”, 'jau 'gã nupe ra'ne— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A'eramũ Jejui 'ga 'jau 'ga upe: —Je rupi iatawet ma'eramũ pejot ekoete te futat je rupi pejejea jewyre'emamũ futat pejejemiejarera mama'e are. Wemiejarer are eajewyt ma'e 'gã nooi futari je rupi. Eajewyt ma'e 'gã nokoarũi je mome'waramũ kwe pewara 'gã nupe— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Anure Jejui 'ga kwaiwete 'gã mũ'jãu 'gã pytuna 'gã nui. Setẽtai tois etee 'ga 'gã mũ'jãu. 'Gã mũ'ẽ re 'ga 'gã mokwasi'wau. Mukũi juejue Jejui 'ga 'gã monou amunaw ipe wenune. —A'ere too pẽ newiri 'jau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","—Inãinãnĩ'ĩ etee Janeruwarete 'ga je'ega mome'wara 'gã. Kwaiwete je 'gã jemogyi Jarejuwarete 'ga kwaape'ema— 'jau Jejui 'ga 'gã nupe. —A'eramũ pẽẽ pejeje'ega monou Jarejuwarete 'ga upe: “Emuru'jap ejemiayuwa 'gã amũ emome'waramũ”, pe'je ki 'ga upe— 'jau Jejui 'ga 'gã nupe. —Sã'ã juowuurana. Omonookara tywe'emamũ 'ã ototokapaw ekoete. Nan tee futat nipo 'gã 'ga je'ega ojeupe 'gã imome'ue'emamũ 'gã pawi etee mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—Ma'eramũ je 'ã pẽ monoi kwe pe, Jarejuwarete 'ga je'ega mome'waukaa 'gã nupe, ikwaapare'ema 'gã nupe. Sã'ã kasurua tajau jarũa pyterimũ isea. A'eramũ 'ã tajaua iu'wau. Nan tee futat pẽẽ. Jarejuwarete 'ga kwaapare'ema 'gã pyterimũ pese. 'Gã amũ nipo amara'neramũ akou pẽ nee. A'ere nipo je jejukai pẽ nee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","—Peroo kasi karaemã ne. Ka'arana nanẽ kasi peroo ne. Pejejemi'urama nanẽ kasi peroo ne. Pejepyapaawa nanẽ pẽẽ erawawe'em nũ. Pejepytawe'em nanẽ pe aje pejeporogytau 'gã nupe nũ— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","—Amunaw ipe pejewaẽmawe ki pe'je 'gã nupe: “'Awamũ Janeruwarete 'ga pẽ mopy'ata'wai pẽ mogyau”, pe'je ki pejesou pejewau 'gã nog ipe— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","—Pẽ nee 'gã ku'iramũ Janeruwarete 'ga aku'i monoi 'gã nupe. Pẽ nee 'gã ku'ie'emamũ 'ga aku'ia nomonoa'uweri 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","—Pejejeupe 'oga resaukaripyra pype etee futat ki pejup. Pejejejyite'ema ajepeja 'oga pype. Pejejeupe imuripyrera 'wau etee futat— 'jau Jejui 'ga 'gã nupe u'ama. —Sã'ã ae ojeupe ojomoporowyky re ojomepya. Nan tee futat nipo 'gã pẽnemi'urama muri pẽ nupe ojeupe pẽporogyta repyramũ— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—'Gã 'wyrarete upe pejewaẽmawe ki pe'je 'gã nupe: “'Au ore ruri Jarejuwarete 'ga porogyta mome'wau pẽ nupe”, pe'je ki 'gã nupe. “Pe'je ajee pejejua 'ga imome'wau oree” 'eramũ peu pejepytau pejejupa imome'wau 'gã nupe. 'Gã 'wyr ipe etee futat pejejemogyau pejejeupe mama'e muripyra 'wau etee— 'jau Jejui 'ga 'gã nupe u'ama oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","—Ojero'wu ma'e 'gã ki pekatu'ok. Jarejuwarete 'ga ree pẽẽ 'gã mu'jau. “Werowiaramũ 'ga pẽ mogoi wemiayuwamũ”, pe'je ki 'gã nupe— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","—Pejewau nipo 'gã 'wyrarete mũ upe pejewaẽma. A'eramũ nipo 'gã “noreporenuwiweri ore Jarejuwarete 'ga je'eg are”, 'jau nipo 'gã pẽ nupe. A'eramũ ki pe'je 'gã nupe: “Janeruwarete 'ga 'ã wemiayuwamũ pẽ futat numiamũ. A'ere 'ã nepefutari etee 'ga”, pe'je ki 'gã nupe. “A'eramũ nipo 'ga anure pẽ mu'arasiga pẽ mogyau”, 'jau ki pẽẽ 'gã nupe— 'jau Jejui 'ga 'gã nupe u'ama. —A'eramũ pẽẽ 'gã 'wyrarete pyterimũ pejewau pejejemogyau pejepyapaawa nupãnupãu, 'yja motototoka jui. “Janeruwarete 'ga 'ã ifuewet pẽ katu'og are futat numiamũ. A'ere 'ã nepefutari etee”, pe'je ki pejewau— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—A'jea futat je 'i. Anure, wowase pẽ majatykaaw ipe nipo Janeruwarete 'ga Sodom ipewarera 'gã nereko tyweretei nũ. Sodom ipewarera 'gã itywetywet Janeruwarete 'ga upe rakue. A'eramũ 'ga 'gã nerekou tyweaete 'gã tywer are nipo. A'ere “Noreporenuwiweri ore Jarejuwarete 'ga je'eg are” 'jara 'gã Sodom ipewara 'gã tywera apyraawi. A'eramũ 'ga a'eramũ nipo 'gã nerekou tyweaete nũ Sodom ipewarera 'gã apyraapa— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A'eramũ 'ga 'jau 'Uwarete 'ga ree oporomutare'ema 'gã nupe: —A'e je ki 'ei pẽporiay'i 'ã pejejemogyau numiamũ a'i kũi. Korasĩ pewaramũ, Pesaita pewaramũ. Mĩmer ipewaramũ 'ã pẽporiay'i pejejemogyau numiamũ. Pẽ'wyr ipe ako je Jarejuwarete 'ga mome'ui tekou pẽ nupe ikue numiamũ. Ojero'wu ma'e 'gã katu'oka ako tekou pẽ neape ikue numiamũ. A'ere ako nepẽporenuwiweri jeje'eg are ikue. Nepẽpoiriweri ako pejetywer awi ikue. Pejetywera retee ako pẽẽ ikue. Tiro pe 'gã katu'og ire amunipo 'ã peuwara 'gã poiri otywer awi rakue. Sidom ipe nanẽ je iapo re amunipo 'ã peuwara 'gã poiri futari otywer awi rakue. Tanimuga amunipo 'ã 'gã wereko wapyte'rarimũ otywer awi opoira resaukaawamũ. A'ere ako je 'au agawewi iapoi tekou pẽ'wyr ipe ikue. A'etea ako nepepoiri pejetywer awi ikue— 'jau Jejui 'ga u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","—A'eramũ nipo Jarejuwarete 'ga pẽ majatykaawa 'ara rupi Tiro pewara 'gã majatykau wowase. A'eramũ nipo 'ga 'gã nerekou tyweaete. Sidom ipewarera 'gã nanẽ nipo 'ga erekou tyweaete nũ. 'Gã tywer are wejue nipo 'ga 'gã nerekou tyweaete etee. A'ere nipo 'ga pẽẽ te pẽ nereko tyweretei kwaiwete. Pẽẽ te 'ã neperowiari 'ga, 'ga pãjẽ resakareramũ miamũ— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","—Pẽporiay'i pejejemogyau numiamũ, a'e je 'ã pẽ nupe, Kafanaũ pewaramũ nanẽ nũ. “Ore Kafanaũ pewaramũ oreresage. A'eramũ ore arawau ywag ipe”, pe'je pejejaupe numiamũ. A'ere je 'i pẽ nupe: Mama'eukwaawa rapyaw ipe oo ma'eramamũ futat pẽẽ, a'e je 'ã pẽ nupe— 'jau Jejui 'ga Kafanaũ pewara 'gã nupe. —Nepepoiri te 'ã pejetywer awi. A'eramũ pẽẽ pejewau mama'eukwaawa rapyaw ipe futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","A'eramũ 'ga 'jau wemimu'e 'gã nupe: —Pe'je pejewau jeporogyta mome'wau kwe pe 'gã nupe— 'jau Jejui 'ga 'gã nupe u'ama. —A'eramũ pẽ nee wapyaka ma'e 'gã je ree nanẽ futat wapyakau nũ. Pẽje'ega renupara 'gã futat jeje'eg are nanẽ wapyaka nũ— 'jau 'ga 'gã nupe. —Pẽje'ega renupare'ema 'gã je ree nanẽ nuapyakai nũ— 'jau Jejui 'ga 'gã nupe. —Je renupare'ema 'gã nanẽ futat je muarera 'ga nuenuwi nũ— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","A'eramũ Jejui 'ga wemimũ'ẽmera 'gã monou kwe pe, 'gã mu'jau Jarejuwarete 'ga porogyta are. Setẽtai tois 'gã awau kwe pe 'gã mu'jau Jarejuwarete 'ga porogyta are. Anure 'gã 'ua ojewya nũ. 'Gã ku'ia 'gã nerekou. A'eramũ 'gã 'ua 'jau Jejui 'ga upe: —Mama'eukwaawa miamũ futat ore oromoit arakou 'gã nui ai'i— 'jau 'gã 'ua 'ga upe imome'wau. —“Jejui 'ga rer imũ ore pẽ moiri 'gã nui”, 'jau ore mama'eukwaawa upe ai'i— 'jau 'gã 'ua imome'wau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aipo ojeupe 'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea— 'jau etee futat 'ga 'gã nupe ojeupe imome'uramũ. —Ymã te je mama'eukwaawa 'wyriara resagi ikue, ywag awi tut i'ara resagi ikue, Satanasi turi 'ara resagi ikue. Sã'ã tupã werawa 'ara. Nan tee futat i'ari. Janeruwarete 'ga imuẽma imua imomoa ikue. A'eramũ je a'eramũ esaka ikue. Janeruwarete 'ga ipãjẽ renuẽma jui ikue. A'eramũ inãinãnĩ'ĩ etee erekou. Ma'eramũ 'ã emiayuwa pemoit 'gã nui rai'i. Tepãjẽa te ako je omono pẽ nupe ai'i. A'eramũ 'ã pẽẽ imoia pejejemogyau 'gã nui rai'i— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","—Ma'eramũ 'ã mama'eukwaawa 'wyriara ipãjẽa niapoa'uweri pẽ nupe. Jeje'eg imũ peata pẽ nekoramũ mama'eukwaawa 'wyriara nepẽ apisiukari mama'e tywera upe— 'jau Jejui 'ga 'gã nupe u'ama. —A'eramũ nipo pẽẽ pejepyruga agawewi futat moi are. A'eramũ nipo pẽ u'wau agawewi. A'etea nipo nepemanũi jupe. Jawa'jyra nipo pẽ piau agawewi. A'ere nipo naya'uweri pẽ nupe— 'jau Jejui 'ga 'gã nupe u'ama oporogytau. —Jeje'eg imũ peata pẽ nekoramũ nitywa'uweri mama'e tywera pẽ nupe. Ma'eramũ 'ã a'jea futat mama'eukwaawa pemoit pejejemogyau 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","A'ere kasi a'e are pejerowiaraip pejejee pejejemogyau ne. Jeremiayuwamũ wejue te pejemogy. Ma'eramũ 'ã pẽku'i pejejemogyau— 'jau Jejui 'ga u'ama 'gã nupe oporogytau. —Jeremiayuwamũ pẽnera jekwasiari 'upa jeka'aran are ywag ipe. A'e are ki pẽku'i pejejemogyau jeremiayuwamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Janeruwarete 'ga pãjẽa Jejui 'ga rerekou. A'eramũ 'ga a'eramũ aku'iramũ akou oje'ega 'Uwarete 'ga upe: —Kiapi'ni. Ene 'ã mama'e jararetea. Ene 'ã ywag ipewara mama'e jara. Ywy pewara jara nanẽ 'ã ene nũ. Ene te 'ã mama'e jararetea. Nai'akwaap ma'e 'gã etee rũi 'ã eremueapyo jeje'eg are. Akotee ma'e 'gã na'ne 'ã eremueapyo ee nũ. I'akwaap ma'e 'gã jẽmĩ 'ã ene imueapyowe'em ee. Ejemifutar imũ etee futat 'ã ene akotee ma'e 'gã mueapyo ee. Nanuara futat te 'ã erefutat rakue— 'jau 'ga oje'ega 'Uwarete 'ga upe. —Ma'eramũ 'ã itywera 'gã etee futat eremueapyo ee— 'jau 'ga oje'ega 'Uwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'Uwarete 'ga upe oje'eg ire Jejui 'ga 'jau wemiayuwa 'gã nupe: —Jeruwarete 'ga je mu'akwaap mama'e are ikue. Ma'eramũ je 'ã ikwaawi— 'jau 'ga 'gã nupe imome'wau. —Jeruwarete 'ga je kwaap katu katu futat. Nitywi 'ga amũ je kwaapara mũ. Jeruwarete 'ga etee te je kwaap— 'jau Jejui 'ga 'gã nupe u'ama imome'wau. —Je 'ã Tejuwa 'ga akwaap katu katu futat. A'ere 'ga nitywi amũ je 'jawewara Jeruwa 'ga kwaapa katu katuara 'ga— 'jau Jejui 'ga 'gã nupe. —Ma'eramũ je 'ã tejemipyyrũmera 'gã mu'ei Tejuwarete 'ga ree. A'eramũ 'gã a'eramũ 'ga kwaapa je pyri— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A'eramũ Jejui 'ga 'jau wemimu'e 'gã nupe etee: —Jeporokatu'okawera 'ã peesak. Mama'eukwaawa rerekwara 'gã katu'oga nanẽ 'ã pẽẽ esaka nũ. Ma'eramũ 'ã pẽku'i pejejemogyau— 'jau 'ga wemimu'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","—Janeypy 'gã 'ã iporesagiwet futat jeremiapo are rakue numiamũ. A'ere 'ã 'gã manũi erujewi je rure'emauwe rakue. 'Gã 'ã oporenuwiweramũ jeje'eg are rakue numiamũ. A'ere 'ã 'gã manũi erujewi je rure'emauwe rakue— 'jau Jejui 'ga u'ama 'gã nupe. —Pẽẽ 'ã jeremiapoa peesak katu katu. Ma'eramũ 'ã 'gã ku'ia peapyraap— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'ga amũ 'ua oporonupa ee Jejui 'ga upe. “Tomojenosĩ Jejui 'ga 'jau kwy”, 'jau 'ga ojeupe numiamũ. —Maran ae awau Jarejuwarete 'ga pyri ki 'ei? Emome'u jee 'i— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A'eramũ Jejui 'ga 'jau 'ga upe: —Ma'ja e'i Moisesi 'ga ka'aran are ikwasiaa inuga rakue? Eremogyta nipo jepi? Maran enereapyo ee?— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—Aipo e'i futat 'ã Moisesi 'ga ka'aran are ikwasiaa inuga rakue. “Peenup Jarejuwarete 'ga je'ega. Pẽporomutat Jarejuwarete 'ga ree a'jea futat. Mama'ea peapo 'ga upe, 'ga remifutar imũ. Pejejea'aramũ pejejemogyau 'ga ree 'gã nee pejejea'ara apyraapa. Aipo aporamũ nipo pejeporomutaramũ 'ga ree a'jea futat”, e'i 'ga ka'aran are rakue. “Pẽporomutat pejepyriwara 'gã nee pejejee pejeporomutara 'jawe etee futat”, e'i 'ga 'ã ka'aran are inuga janee rakue— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—A'jea futat aipo 'ea— 'jau Jejui 'ga 'ga upe. —Namutar iki peapo. A'eramũ pejewau Jarejuwarete 'ga pyri pejemanũ re— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","A'eramũ 'ga 'jau Jejui 'ga upe nũ: —A'eramũ je maranuara 'gã nee tepota'waramũ ki 'ei? Awỹja je pyriwaramũ ki 'ei?— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A'eramũ kwe pe etee Jejui 'ga mama'e mũ mome'wau 'gã nupe nũ, 'gã mu'jau ajuee 'gã pojejuka are. —Kũima'e 'ga 'ut amũ akou ojypa Jerusareg awi. Ajepeja amunaw ipe 'ga 'ua numiamũ, Jeriko pe 'ga 'ua numiamũ. A'ere 'ga ruaw ipe muna'ywa 'gã 'ga rekoari. A'eramũ muna'ywa opokoka 'ga ree. 'Ga raitya mosoka 'ga wi 'ga nupãnupãu 'ga monou 'ga nuga. 'Ga jukaaipa 'ga rejaa inuga peyse pe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A'eramũ mainana 'ga amũ awau akou pe rupi. Awau owaẽma 'ga upe. Irãã'ã 'ga ruwamũ peyse pe. Amã'jãu etee 'ga ree. Okwapa etee 'ga pyu. A'ere mainana 'ga nokoi 'ga ree. Awau etee 'ga pyu. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A'ere 'ga amũ 'ua nũ. Levi 'ga juapyrera 'ga amũ 'ua 'ga pyu nũ. 'Gã pytuna 'ga futat numiamũ. A'ere nãnẽwẽjẽmĩ 'ga nokoi 'ga ree. Okwapa etee 'ga pyu nũ— 'jau 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","—A'ere Samari ywy pewara 'ga 'ua pe rupi akou. Na'ga jekoty'aawa 'ga rũi agawewi. 'Ga ree iporomutare'ema 'ga agawewi. Inupãmyrera 'ga judeua. A'etea Samari ywy pewara 'ga inupãmyrera 'ga resakawe ajemuaẽm 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A'eramũ 'ga opytau 'ga ree. Na'ga remiesaga 'ga rũi agawewi. A'etea 'ga opytau 'ga ree. Oporiaramũ 'ga ree. Iporiay'i 'ga 'upa 'ga upe. “Maran poko ene 'i?” 'jau 'ga 'ga upe. —“Muna'ywa opokok je ree ki 'ei, jekaraemã areewi ki 'ei”, 'jau 'ga 'ga upe. —A'eramũ futat 'ga muagy monou 'ga ree, 'ga pi'rokawer are. Muaga 'ga ree imono re ifaa 'ga wi. A'ere 'ga 'ga monou kawaru'i 'arimũ, weymawa 'arimũ 'ga rupia. A'eramũ futat 'ga 'ga rerua erowaẽma ae seawa 'og ipe. A'e pe futat 'ga 'ga fuanuga 'ga rerekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","—Ai'iwe 'ga, oo enune, oka'aranũũ monou 'oga jara 'ga upe. “Efuanug 'ga jee. Maran gatu nipo owaẽme'ema ka'aranũũa jupe. Jupe iwaẽme'emamũ tejewya tamepypap ene 'jau”, 'jau 'ga 'oga jara 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Imome'upaw ire Jejui 'ga oje'ega moromu'jara 'ga upe nũ: —Muapyra 'gã inupãmyrera 'ga resaka. Maranuara 'ga ajemuaẽma 'ga ree? 'Ga pytuna 'ga te ajemuaẽm 'ga ree?— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Naani. 'Ga pytune'ema 'ga futat ajemuaẽm 'ga ree, ojejukau 'ga ree— 'jau 'ga 'ga upe. —A'jea futat. 'Ga pytune'ema 'ga futat ojejuka 'ga ree. A'eramũ pẽẽ nanẽ iapou nan— 'jau Jejui 'ga 'ga upe. —Nan aeresage jejukai ajuee. Namutar iki pẽẽ nanẽ peapo nũ— 'jau Jejui 'ga 'gã nupe. A'eramũ moromu'jara 'ga awau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aipo mome'upaw ire Jejui 'ga wemimu'e 'gã nerawau ajepeja amunaw ipe nũ. Marta ẽẽ rog ipe awau osou. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ẽẽ kypy'yra ẽẽ, Mari ẽẽ awau wapyka Jejui 'ga pyri, 'ga porogyta renupa 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A'eramũ Marta ẽẽ kumi apou erekou. A'eramũ ẽẽ 'jau ojeupe: “Koo. Je tee 'i nipo aje ako mama'e apou jarejee”, 'jau ẽẽ. “Maran tete Mari kyna nuapoi mama'ea je pyri. Wapyg etee pa 'ã kyna 'ũina kĩã pyri nũ”, 'jau ẽẽ ojeupe. A'eramũ ẽẽ 'ua oje'ega Jejui 'ga upe: —Emut kyna je poaa. Je etee ako teporowykyau. “Ekwap ẽẽ poaa mama'e apou”, ere kyna upe jee— 'jau ẽẽ Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—Naani. Ene te 'ã eporowyky are etee enerea'at. Epytu'u'i jui. Erejemuaẽm awi eporowyky are etee— 'jau 'ga ẽẽ upe. —Tene Mari ẽẽ reni. Jeporogyta are ẽẽ porenuwiweramũ. Jaruete ẽẽ reni je renupa, jeporogyta are wea'aramũ— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","—Ene te 'ã mama'e apoawamũ etee ereko rakue. Ẽẽ jeje'ega renuparamũ etee ako. Ẽẽ te 'ã oporowyky esagea wesak ojeupe. Nomomoira'uweri 'gã ẽẽ jui— 'jau Jejui 'ga ẽẽ upe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Anure Jejui 'ga 'ũina oporogytau 'Uwarete 'ga upe. 'Ga pig ire 'ga remiayuwa 'gã 'jau 'ga upe: —Ore mu'e ape Jarejuwarete 'ga upe oroje'eg are ki jã— 'jau 'gã 'ga upe. —Sã'ã Juã Batista 'ga wemiayuwa 'gã mu'ea rakue. Nan ore mu'e ape, ene taetu— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aipo ojeupe 'eramũ Jejui 'ga 'jau 'gã nupe: —Nan iki peporogyta 'ga upe: Kiapi'ni. Oroje'eg ore arajupa enee. Tene muoryp ki 'gã najuejue etee. Kamẽsĩete ki 'gã najuejue etee tene rerowiat ajemogyau. Kamẽsĩete tere'ỹi 'wyriaramũ oree najuejue etee 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","'Awamũ ki mama'ea emut oree oreremi'uramamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Norerea'aru'jawi ore mama'e tywera orojeupe 'ga iapoawer are. A'eramũ ki ene ejea'aru'jawe'emamũ oretywer are. Ore mamuakat futar iki ape mama'e tywera apoe'em are, pe'je ki Jarejuwarete 'ga upe pejeje'ega— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Jarejuwarete 'ga upe pejeporogyta awi kasi pepoit futar ine. Ojewi pepoire'emamũ nipo 'ga mama'e esage muri pẽ nupe— 'jau 'ga 'gã nupe u'ama. A'ere 'ga mama'e mũ mome'wau 'gã nupe nũ, 'gã mu'jawamũ nũ: —Sã'ã nipo kũima'e 'ga amũ rura iwaẽma opytuna 'ga upe ypyaje. A'eramũ nipo 'gã osea ajemogyau. A'eramũ nipo 'ga 'ga momaka. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Kanape'ia emut amũ jee. Muapyra kanape'ia emut jee. Jepytuna 'ga 'ut amũ owaẽma jee. A'ere nitywi mama'ea 'ga upe. A'eramũ je tejua, emut amũ mama'ea jee, 'jau enee”, 'jau nipo 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A'eramũ nipo oset ma'e 'ga 'jau ajaupe: “Aset je tejupa. Najefu'amiweri je. Jera'yra 'gã oset 'upa. Awopytym je 'okwara ko”, 'jau nipo ta'yt ma'e 'ga ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—A'ere nipo 'ga pytuna ojero'waro'wau etee 'okwara mopoga u'ama 'ga upe wojere'emamũ. Pog pog pog. A'eramũ nipo 'ga omogerukare'emamũ afu'ama, kanape'i monou 'ga upe, opytuna 'ga omogerukare'emauwe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—A'eramũ je 'jau pẽ nupe: Nan tee futar iki pejemogy pejeje'ega Jarejuwarete 'ga upe pejeojere'emamũ. A'eramũ 'ga pẽnemifutara mua pẽ nupe— 'jau Jejui 'ga 'gã nupe u'ama. —Ojeupe pẽẽ mama'e renũjamũ Janeruwarete 'ga imuri pẽ nupe. “Je poar ape” ojeupe 'eramũ 'ga pẽ poari futari. Kamẽsĩete 'ga pejepoare'emamũ, pejeje'ega pejejemogyau pejeojere'emamũ 'ga upe. Sã'ã mama'e 'ara ae wi. A'eramũ 'ã ae ijaramũ awau ekaa. Esag ire tãmẽjẽ 'ã ae opoia ekar awi. Nan tee futar iki pẽẽ, pejeje'ega pejeojere'emamũ futat 'ga upe mama'e renũi awi. A'eramũ 'ga mama'e mua pẽ nupe— 'jau Jejui 'ga 'gã nupe. —'Okwara mopogara 'ga 'jawe ki peko. 'Okwara rawopytymo'wog ire etee 'ga poiri imopog awi. Nan tee futar iki pẽẽ. Pepoit kasi 'ga upe pejeporogyta awi ne. A'eramũ 'ga pẽ poari futari— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","—“Mama'e emut amũ jee” 'jara 'gã nupe 'ga imuri futari. “Je poar ape” 'jara 'gã 'ga opoat futat. Ojeupe peje'egamũ 'ga je'egi futari pẽ nupe— 'jau 'ga u'ama 'gã nupe oporogytau. —Pejenosĩ kasi mama'ea 'ga upe enũina ne. Mama'e esage tee te 'ga amut pẽ nupe. Namura'uweri 'ga mama'e tywera pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sã'ã pẽẽ. “Mama'e emut amũ jee, Kiapi'ni”, pejeja'yra pejejeupe i'eramũ mama'e katurama etee imonoa pejeja'yra upe. Nan tee futat Janeruwarete 'ga mama'e esagea etee imuri pẽ nupe, “mama'e esagea emut jee” 'eramũ. Moja sipo pemono pejeja'yra upe, “ipira emut jee” 'eramũ? Naani. Mama'e esagea etee te pemono pejeja'yra upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","“Wyraupi'a emut amũ jee” 'eramũ sipo jawa'jyra pemono pejeja'yra upe? Naani. Nepemonoa'uweri jawa'jyra pejeja'yra upe. Nan tee futat Ku'jywa 'ga— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","—Pẽẽ 'ã aetywera agawewi. A'etea 'ã mama'e esagea etee pemono pejeja'yra upe— 'jau Jejui 'ga 'gã nupe. —Nan tee futat peapo numiamũ. A'ere Ku'jywa 'ga te mama'e esagerete muri pẽ nupe “mama'e esagea emut oree” ojeupe pẽẽ 'eramũ— 'jau Jejui 'ga 'gã nupe u'ama. —U'agesagea miamũ futat 'ga amut pẽ nupe, “Emut E'agesagea jee” ojeupe 'eramũ— 'jau 'ga oporogytau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Oporogytapaw ire Jejui 'ga mama'eukwaawa pe'au erekwara 'ga wi. A'ea 'ga moje'egukare'ema 'ga mogou. Ije'ege'ema 'jawe 'ga pirewara 'ga mogou. A'eramũ 'ga ojewi ipe'a re oje'ega nũ. A'e resakarera 'gã oporesagamũ ajemogyau 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A'ere 'gã amũ “o'meramũ te 'gã 'i”, 'gã 'i etee ajaupe: —Mama'eukwaawa 'wyriara je'eg imũ te 'ga 'ga pirewara moiri 'ga wi— 'jau 'gã ajaupe. —Pesepu je'eg imũ te 'ga imoiri 'ga wi— 'jau etee esakarera 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A'eramũ peuwara 'gã 'jau 'ga upe: —Oreremiesage'ema eapo amũ oree. A'e resaka “A'jea futat ra'e”, taru'e enee 'jau. “Janeruwarete 'ga opãjẽ muri 'ga upe ra'e”, taru'e enee 'jau— 'jau 'gã 'ga upe numiamũ. A'ere 'ga nuapoi 'gã nupe. “Mama'e tywera siapoukat esaka 'ga upe jarejee 'jau”, 'jau 'gã ajaupe numiamũ. A'ere 'ga nuapoi 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Okwaap 'ga 'gã je'eg jemima ojee. A'eramũ Jejui 'ga aipo 'jau etee 'gã nupe: —Maran sipo 'gã amũ a'eramũ ojo'oka oywy pype ajamueu? Ajaupi etee futat ajuapisaupap, ojomateepapa ajaupi etee futat— 'jau Jejui 'ga u'ama oporogytau 'gã nupe. —Maran sipo a'eramũ ajepeja amunaw ipewara 'gã ojo'oka ajaupi etee futat ajuapisawamũ?— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","—Nan iapo re amunipo 'ã mama'eukwaawa remiayuwa ojomateepawi ajaupi etee futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—“Pesepu pãjẽ mũ 'ga mama'eukwaawa pe'ai 'gã nui”, 'jau ako pẽẽ jee ko. A'eramũ je 'jau pẽ nupe: Ma'ja pãjẽ mũ ajee pẽnemiayuwa 'gã mama'eukwaawa pe'ai 'gã nui? NaJaneruwarete 'ga pãjẽ mũ rũi nipo 'gã imoiri 'gã nui?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","—Je nanẽ futat 'ã Jarejuwarete 'ga pãjẽ mũ etee je 'ã imoiri 'gã nui. A'eramũ pẽẽ a'e are je kwaapa. “Janeruwarete 'ga remimurera 'ga te nipo 'ã”, 'jau amunipo 'ã pẽẽ jee— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Ifuakat ma'e 'ga 'ã u'ywa renu'ama 'okwar ipe woga rarũmũ. A'eramũ 'ã muna'ywa osowe'em. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A'eramũ ifuakararete ma'e 'ga 'ua 'ga muajãna 'ga monou 'ga retyka u'ywa pojekau 'ga wi. A'eramũ futat osou 'ga karaemã upe. A'eramũ futat 'ã erawau ime'ega ajaupe— 'jau 'ga 'gã nupe imome'wau. —Mama'eukwaawa 'wyriara ifuakat ma'e 'jawe. Ipãjẽ futat numiamũ. A'ere Janeruwarete 'ga te pãjẽretea. Mama'eukwaawa 'wyriara pãjẽa te 'ga wapyraap. Ma'eramũ 'ã ae Jarejuwarete 'ga pãjẽ mũ mama'eukwaawa pe'ai 'gã nui— 'jau Jejui 'ga 'gã nupe u'ama, oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Je ree iporomutare'ema 'gã najeremiayuwa rũi— 'jau Jejui 'ga 'gã nupe. —Jeporowyky are je poare'ema 'gã naje upe rũi oporowyky. Mama'eukwaawa upe te 'gã porowykyi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽ nui omoir ire mama'eukwaawa nipo ioi ywy akỹme'ema rupi opytaawa mũ rekaa akou. A'eramũ nipo opytaawa mũ resake'emawe 'jau ojeupe etee futat nũ: “Maran te 'ã nooi tejekwawer ipe etee futat tejewya nũ 'i?” 'jau nipo ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A'eramũ nipo ojewya 'ua werekwarera 'ga resaka. Erekwarera 'wyriar amuteeramũ nipo akowe'em ee. Ijekatu'oguu tuwamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A'eramũ nipo opytuna majatykau awau. Sete nipo opytuna rerua. A'ea te nipo itywerete. A'eramũ te nipo erekwarera 'ga te'arareteramũ— 'jau Jejui 'ga 'gã nupe imome'wau. —A'ere Janeruwarete 'ga 'Agesagea mama'eukwaawa rerekwarera pype ose re mama'eukwaawa noseu'jawi 'ua nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","A'ere Jejui 'ga oporogytapaw ire kũjã ẽẽ mũ mytun awi wafukaja mua 'ga upe: —Iku'i nipo eney kyna nanimenime ene ree— 'jau ẽẽ wafukaja mua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aipo ojeupe 'eramũ Jejui 'ga 'jau ẽẽ upe: —A'jea futat nũ ĩ. Iku'i futat ẽẽ je ree nũ ĩ— 'jau 'ga ẽẽ upe. —Je rerowiaara 'gã taetu nipo ẽẽ ku'i wapyraap— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ojee 'gã jatykapaw ire Jejui 'ga oje'ega 'gã nupe nũ: —'Awauwaramũ miamũ 'ã nepẽa'wyri futari pejejemogyau 'ga upe— 'jau 'ga 'gã nupe. —Oreremiapoe'ema eapo amũ oree, pe'je 'ã jee numiamũ. A'e resaka “A'jea futat Janeruwarete 'ga opãjẽ muri 'ga upe ra'e”, taru'e enee 'jau, pe'je 'ã jee numiamũ. A'ere je naapoa'uweri mama'ea pẽ nupe pẽnemiesagamũ— 'jau Jejui 'ga 'gã nupe. —Juna 'ga ree etee je pẽ muea'ari pẽ mogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","—Sã'ã ipira Juna 'ga mokona rakue. A'eramũ 'ã imuapyra 'ara rupi 'ga rerua eropy'apojyau rakue. Nan tee futat je ferawi imuapyra 'ara rupi. Je manũ re nipo Janeruwarete 'ga futat je moferapa imuapyra 'ara rupi Juna 'ga 'jawerimũ etee futat. Aiporamũ tãmẽjẽ te nipo pekwaap. “Na pa je Janeruwarete 'ga 'ga muri rakue”, 'jau nipo pẽẽ jee je feraw ire— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Wowase pẽ majatykaaw ipe Janeruwarete 'ga 'jau pẽẽ mũ nupe. “Ko 'gã esage ra'e. Werowiat wejue 'gã jera'yra 'ga. A'eramũ je 'gã mua tejemiayuwamũ. A'eramũ 'awamũ 'gã 'ua osou ywag ipe je pyri. Jera'yra 'ga 'gã werowiat rakue”, 'jau nipo 'ga pẽ nupe. “Ko 'gã te aje nia'wyri. Nuerowiari 'gã jera'yra 'ga rakue”, 'jau nipo 'ga pẽ nupe— 'jau Jejui 'ga 'gã nupe. —Aipo 'eramũ nipo Sepa ywy pewara 'wyriara ẽẽ 'jau pẽ nupe: “NaKu'jywa kĩã remiayuwa rũi agawewi je ikue. A'etea je ojot muku awi Sarumãu kĩã je'ega renupa ikue”, 'jau nipo ẽẽ pẽ nupe— 'jau Jejui 'ga 'gã nupe. —“A'ere 'ã Jejui kĩã rekoi agawewi pẽ pype rakue. I'akwaap ma'e kĩã jẽmĩ. A'etea 'ã nepeanuwi kĩã je'ega rakue”, 'jau nipo ẽẽ oje'ega 'ua pẽ nupe— 'jau Jejui 'ga 'gã nupe. —A'jea futat ẽẽ 'i. Sarumãu 'ga a'jea futat okwaap numiamũ. A'ere 'ga nokwaapawi. Je te 'ã a'jea futat okwaap katu katu. A'etea 'ã jeje'ega nepeanuwi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Janeruwarete 'ga rowase pẽ majatykaaw ipe nipo Ninewa pewara 'gã afu'ama pẽ nupe. “Ore nanẽ nũ. Norokwaawi ore Ku'jywa 'ga ikue. A'etea ore orojeupe Juna 'ga 'ga mome'u ypyrauwe oropoit orotywer awi ikue”, 'jau nipo 'gã pẽ nupe. “A'ere 'ã nepeenuwi futari Jejui 'ga je'ega rakue”, 'jau nipo 'gã pẽ nupe— 'jau Jejui 'ga 'gã nupe. —Juna 'ga a'jea futat esage ma'ea rakue. A'ere 'ã je te 'ga apyraawi. A'etea 'ã naje rerowiari pejepe pejejemogyau— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A'ere Jejui 'ga oje'ega 'gã nupe nũ: —Arãparĩna monyg ire ae nomima'uweri mama'e 'ag are. Imonyg ire ae imonoi jakatupe te imỹina ajuesawamũ te— 'jau 'ga u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","—Tata eny 'jawe aereaa. Sã'ã tata enya mama'e resaukara janee. Nan tee futat jarejeau jane mama'e resagi. Ea ma'e 'gã wesak katu katu futat mama'ea. Eawep ma'e 'ga te aje 'ã nuesakatui mama'ea. Nan tee futat pẽẽ. Ea ma'e 'gã 'jawewaramũ pẽẽ pẽneapyo pejejemogyau jeje'eg are, erowiaa pejejemogyau. A'eramũ pẽẽ mama'e apou Jarejuwarete 'ga je'eg imũ etee futat. A'ere eawep ma'e 'jawewaramũ nepẽneapyoi futari jeje'eg are. Neperowiari jeje'ega. A'eramũ pẽẽ pejejemifutar imũ etee futat mama'e apou pejejemogyau. Ypytunaiwa pype wata ma'e 'jawe pẽẽ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","—A'eramũ pẽẽ jeje'ega renupa futat. Jeje'ega tata eny 'jawe. Sã'ã tata enya pe resaukara pẽ nupe. Nan tee futat jeje'ega pẽ mu'ei ywaga piar are. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A'eramũ pẽẽ jeje'ega renuparamũ tata eny pype futat pejejemogyau pejeatau. Jeje'ega renupara 'gã a'jea futat ajemogyau mama'e apou esage Jarejuwarete 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jejui 'ga porogytapaw ire fariseu 'ga amũ 'jau 'ga upe: —Ere ejua ejemi'waa je'wyr ipe— 'jau 'ga 'ga upe. A'eramũ Jejui 'ga awau 'ga rupi. 'Ga rog ipe owaẽm ire Jejui 'ga awau osou. Awau wapyka. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A'eramũ 'ga mo'wyarera 'ga 'jau ojeupe: “Kuu. Nojepoei futari nipo ajee 'ga ki sa”, 'jau 'ga ojeupe. “Najane 'jawe rũi 'ga jepoei ojemi'war enune”, 'jau 'ga 'ga ago'wau ojeupe etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A'ere Jejui 'ga ikwaawi ojee. —Ene 'ã jarejemiapou etee futat mama'ea ereapo ekou numiamũ— 'jau Jejui 'ga 'ga upe. —A'jeteetewi 'ã ene mama'e apou ekou numiamũ. A'etea 'ã nenea'wyri. Pẽẽ 'ã y'a kupe pireita futat numiamũ. A'ere 'ã nepekatu'ogi waipy katy. Nan tee futat 'ã pẽẽ. Pẽpir esageay futat numiamũ. Pejauk futat pejepiky'a awi numiamũ. A'eramũ 'ã pẽpira ojekatu'oka numiamũ. A'ere pẽkurasãu nia'wyri futari. Iky'auuramũ futat pẽkurasãua. A'ere 'ã pejekurasãu nepekatu'ogi futari— 'jau Jejui 'ga 'gã nupe oporogytau 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","—Pẽ'akwaawe'ema pẽ nereko kũi— 'jau Jejui 'ga oje'ega moywyrafena 'gã nupe. —Janeruwarete 'ga 'ã pẽ apoarera. A'eramũ 'ga afueweramũ pẽ katu'og are numiamũ. Napẽpira katu'og are rũi 'ga fueweramũ. Pẽkurasãu katu'og are tee 'ga fueweramũ numiamũ— 'jau 'ga oje'ega moywyrafena 'gã nupe. —Pejetywer awi pepoir ire amunipo 'ã 'ga pẽ katu'ogi. A'eramũ amunipo 'ã pẽẽ pejejesageramũ pejejemogyau 'ga upe, 'jau je 'ã tekou pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","—Pejejakate'em awi pepoit. Ikaraemãe'ema 'gã nupe pejekaraemã pemono amũ. Nan pẽẽ iaporamũ pejekatu'ok, pẽpira we futat pẽywyter ipe nanẽ nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Pẽporiay'i pẽẽ numiamũ. A'ere nipo anure Janeruwarete 'ga pẽ nereko tyweri pejejuee pejeporomutare'em are. Fariseu 'ã pẽẽ. A'eramũ pẽẽ mama'e mojo'oka pejepo 'jawe pejejeupe. Ko pypiara nanẽ imojo'oka nũ. A'eramũ pẽẽ majepeja monou Jarejuwarete 'ga upe. A'eramũ emyrera pẽma'ea. Kumikasiga miamũ pẽẽ imojo'oka imonou Jarejuwarete 'ga upe. Nanuara te esage futat 'ga upe numiamũ. A'ere namĩa etee rũi peapo. Pejejuee nanẽ futar iki pejejuka esage nũ. Mĩmera apoa esageay Janeruwarete 'ga upe— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. —A'ere 'ã pẽẽ nanarũi. Pẽẽ 'ã pejuereko tywerete. A'eramũ nipo Janeruwarete 'ga pejejuee pejeporomutare'em are pẽ nerekou tyweaete— 'jau 'ga 'gã nupe 'ũina. —Pejepytuna 'gã nereko esagearamũ Jarejuwarete 'ga ree we futat pejejuka esage— 'jau Jejui 'ga 'gã nupe. —A'ere pejepytun are pejejukae'emamũ Jarejuwarete 'ga we futat pereko tywerete— 'jau 'ga 'gã nupe 'ũina oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Pẽporiay'i nipo pẽẽ numiamũ. “Je jeresage” pe'je numiamũ. A'ere nipo anure Janeruwarete 'ga pẽ nereko tyweretei. Pejejatykaaw ipe pejewau 'ã kũima'eeteete 'gã apykaw ipe etee pẽapygiwet. Ukawõ'õ me pejeatau pejejemogyau miamũ 'ã pejejeapeje'ega futaa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Judeuramũ jane nipyruga'uweri tywy are. Tywya nia'wyri. Aeto'omera ajemogy. A'eramũ jane jarepyruge'ema futat ee. A'eramũ jane mama'e monou tãmẽjẽ futat imỹina tywy 'arimũ imojewakawamũ ajaupe. A'eramũ ae tywy 'arimũ opyruge'ema. Tywya 'ã 'ũina ojewage'emamũ. A'eramũ 'ã ae okwapa i'arimũ. Ikwaape'ema rerekou. Nan tee futat pẽẽ. Nepẽywyter a'wyri pejejemogyau. A'ere 'gã nokwaawi te. Tywy jewage'ema 'jawe futat— 'jau Jejui 'ga 'gã nupe. —“Oreresageay” pe'je 'ã jepi numiamũ. A'ere 'gã nepekwaawi te. Pẽywyter a'wyre'ema nokwaawi te— 'jau 'ga 'ũina 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'gã amũ 'jau Jejui 'ga upe, aipo 'ga 'eramũ. —'Gã nupe aipo 'jau te ore nanẽ futat ore ago'o ape e'ỹina nũ— 'jau 'gã 'ga upe aipo 'ga 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","—Pẽẽ nanẽ nipo moromu'jaramũ pejemogy tywet 'gã 'jawe futat nũ— 'jau Jejui 'ga 'gã nupe. —Napejejemimu'efer imũ etee rũi te 'ã mama'ea peapo. A'eramũ nipo Janeruwarete 'ga pẽ nerekou tyweaete futat. Sã'ã 'gã amũ mama'e poyja monoa aju'arimũ. A'eramũ 'gã ojopoare'ema iupia. Nan etee pẽẽ. Pẽẽ 'ã Moisesi 'ga remikwasiarer are pemu'e katu katu 'gã numiamũ. “Peko esage 'ã pejejemogyau Moisesi 'ga je'eger imũ. Pepoit kasi 'ga je'eger awi ne”, pe'je 'ã 'gã nupe pejejemogyau numiamũ. A'ere 'ã pẽẽ te nepeko esagei pejejemogyau Moisesi 'ga je'eger imũ— 'jau 'ga 'gã mu'jara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","A'ere 'ga 'jau 'gã nupe nũ: —Pẽporiay'i pẽẽ pejejemogyau numiamũ. Nepeenuwi futari Jarejuwarete 'ga je'ega mome'wara 'gã je'ega. A'eramũ nipo Janeruwarete 'ga pẽ nerekou tyweaete futat. Pẽypy 'gã 'ã Janeruwarete 'ga mome'wara 'gã je'ega nuenuwi etee rakue. Ma'eramũ 'ã 'gã 'ga je'ega mome'wara 'gã apisi rakue. Pẽẽ nanẽ 'ã 'gã je'egera renupe'ema nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","—Pejeypy 'gã 'gã apisi re 'ã pẽẽ ita esage monou 'gã nywy 'arimũ peje'arasiga resaukaawamũ. A'ere 'ã pẽ'arasig 'mea te pẽ nerekoi. Pẽku'ia te pẽ nereko 'gã apisiawer are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","—Janeruwarete 'ga 'ã i'akwaap tãmẽjẽ futat. A'eramũ 'ga jane kwaapa. A'eramũ 'ga 'jau “Teje'ega mome'wara 'gã tomono 'gã nupe 'jau kwy”, 'jau 'ga rakue. “Amumera 'gã te nipo 'gã wereko tywerete. Amumera 'gã te nipo ajee 'gã wapisi”, 'jau Janeruwarete 'ga 'gã nupe rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","—A'eramũ Janeruwarete 'ga pẽ nerekou tyweaete werowiaara 'gã nepyaa. Nepẽ'arasigi te 'ã pejetywer are. Pejetywer are, jareypy 'gã tywer are. Mĩmer are 'ga pẽ nereko tyweretei. Janeypy 'gã 'ã Jarejuwarete 'ga je'ega mome'wara 'gã apisau ekoete rakue. Ywy apo ypyrauwe te 'ã 'gã 'ga rerowiaara 'gã apisi rakue— 'jau Jejui 'ga 'gã nupe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","—Apeu 'ga ra'ne te 'ã 'gã ajuka ypy ypy rakue. A'ere 'gã 'ã 'awamũ taetu 'ga rerowiaara 'gã apisi kwaiwete. 'Awamue 'gã 'ã Sakari 'ga jukau rai'i nũ— 'jau Jejui 'ga 'gã nupe. —Jarejuwarete 'ga rukawõ'õ me 'ga 'amamũ 'gã 'ã 'ga jukau rai'i. A'eramũ nipo 'ga pẽ nerekou tyweaete iapisipyrera 'gã nepyaa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Moromu'jara pẽẽ numiamũ. Pẽporiay'i pejejemogyau numiamũ. A'ere nipo anure Janeruwarete 'ga pẽ nereko tyweri futari— 'jau Jejui 'ga 'gã nupe. —Jarejuwarete 'ga je'ega te 'ã neperowiari futari. A'eramũ 'ã pẽẽ erowiarukare'ema 'gã nupe. Pẽ'me etee 'ã 'gã nupe. A'eramũ 'gã a'jea futat ikwaape'ema. A'eramũ nipo anure Janeruwarete 'ga pẽ nerekou tyweaete— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Oporogytapaw ire Jejui 'ga awau 'gã nui. Fariseu 'gã amũ awau 'ga rupi Moisesi 'ga remikwasiarer are moromu'jara 'gã netee. A'eramũ 'gã awau akou oporogytau pe rupi. Ajamueu awau akou. Oje'ega moywyrafena 'ga upe, 'ga rerawau 'ga rerekou, 'ga moporogytaukaa ojeupe. A'eramũ 'gã 'jau ajaupe: —Pe'je ajee 'ga simoporogytaukat jarejee 'ũ— 'jau 'gã ajaupe. —Siesak 'ga mama'e tywera mome'ua jarejee 'jau 'ũ— 'jau 'gã ajaupe, ajuerawau ajuerekou. A'eramũ 'gã a'eramũ 'ga moporogytaukaa 'ga rerawau 'ga rerekou pe rupi. A'ere 'ga morogyta a'jea etee imome'ui 'gã nupe 'gã nerawau 'gã nerekou. Nomome'ui futari 'ga mama'e tywera. ");
INSERT INTO kyzNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","—'Ga je'eg ekoete 'ga rekoramũ sipyyk 'ga 'jau— 'jau 'gã ajaupe numiamũ. A'ere 'ga morogyta a'jea etee imome'ui 'gã nupe 'gã nerekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","A'eramũ 'gã ajatykau Jejui 'ga ree. 'Ga porogyta renupa 'ua ajatykau. Kwaiwete 'gã. A'eramũ 'gã opyruga pãwẽ gatu etee te futat ojopy are. Opyrugawe'ema rerekou 'gã opyruga ajuee. A'ere Jejui 'ga je'egi wemimu'e 'gã nupe etee ra'ne: —Peko kasi fariseu 'gã 'jawe ne— 'jau 'ga wemimu'e 'gã nupe. —“Ore 'ã oreresageay”, e'i 'gã numiamũ. A'ere o'meramũ te 'gã 'i ajemogyau— 'jau 'ga 'gã nupe. —Nepeesagi te 'gã tywera. A'ere 'gã tywereteramũ futat. Mama'e tywera 'gã wapo ajemogyau. A'ere 'gã imimi te. Kanape'i jopypeawa 'jawe 'gã tywera. Nuesaga'uweri ae kanape'i jopypeawa. A'ere imopy'apirupaw ire ae imopy'apiruawa kwaawi futari. Nan tee 'gã tywera. Ae nuesaga'nei nipo 'gã tywera. A'ere anure te nipo ae esagi futari. Pejemogy kasi 'gã 'jawe ne— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","—Nomima'uweri futari mama'e tywera. Anure te nipo imimipyrera jesaukari 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Awamũ 'gã amũ jemogyi jemime oje'ega ajaupe. A'ere aipo 'ara rupi te nipo 'gã amũ imome'ui 'gã nupe wafukaita. A'eramũ te nipo najuejue etee futat pekwaap— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","A'ere Jejui 'ga 'jau 'gã nupe nũ: —Pekyje awi pejeapisi are ifuewet ma'e 'gã nui. Pẽ apisi 'gã numiamũ. A'ere 'gã pẽ'aga nomateepawa'uweri. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jarejuwarete 'ga wi te pekyje ete. 'Ga te a'jea futat pẽ mateepap ywawuje tee werowiare'emamũ. Pẽ'aga we futat 'ga imonou mama'eukwaawa rapyaw ipe— 'jau 'ga imome'wau 'gã nupe. —'Ga te a'jea futat mama'e tywera ojeupe iaporamũ ae apisi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Janeruwarete 'ga te 'ã pãjẽretea. A'ere 'ga jejukai esagei futari ae ree. Peesak wyra'ia. Wyra'ia 'ã niapoi agawewi. A'etea Janeruwarete 'ga imanũnamũ wesak 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ae taetu aje 'ã ae ate 'ga upe. Ma'eramũ 'ã 'ga jejukai ae ree taetu— 'jau 'ga imome'wau 'gã nupe u'ama. —Pẽ'awa we futat ojemojopyrũmawa ajemogyau pẽakag are. Aeakag are ijemogya we futat 'ga okwaapap. “Nojejukai nipo 'ga ore ree?” pe'je kasi ne. Naani. Ojejuka futat 'ga pẽ nee. A'eramũ ki pẽẽ pejekyjawe'em pejejereko tyweara 'gã nui— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","A'ere Jejui 'ga oje'ega 'gã nupe nũ: —Je 'ã pẽneki'yraretea. Pejenosĩ kasi je mome'wau 'gã nupe ne— 'jau 'ga 'gã nupe. —'Gã nowase pẽẽ je mome'u renosĩe'em ire je nanẽ najenosĩ pẽ mome'wau nũ. “Je Jejui 'ga remiayuwamũ”, pẽẽ 'eramũ je ywag ipe peoramũ je nanẽ futat ywag ipewara 'gã nowase a'e 'gã nupe nũ: “Koromũ noko jeremiayuwa 'gã 'ja”, 'jau nipo je pẽ nupe ywag ipe peoramũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","—Pẽẽ mũ nipo 'jau 'gã nupe: “Je naJejui 'ga remiayuwa rũi”, 'jau nipo pẽẽ. A'eramũ nipo je nanẽ futat ywag ipe peoramũ “Najeremiayuwa rũi koromũ”, 'jau nipo je 'gã nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Ojeupe peporogyta re Janeruwarete 'ga pẽtywera moiri pẽ nui. Je kuraw ire pẽtywerete futat. A'ere nipo anure 'ga 'Agesage je'egi pẽ nupe, pẽtywera resaukaa pẽ nupe. A'eramũ nipo pẽẽ pejepoia pejetywer awi. Jui pepoir ire Janeruwarete 'ga imoia pẽ nui— 'jau 'ga 'gã nupe imome'wau. —A'ere 'ga 'Agesage kuraw ire nitywi 'ga amũ pẽtywera resaukaawamũ pẽ nupe. A'eramũ pẽẽ jui pejepoire'ema. Nan tee futat pejejemogyau. Pejetywer awi pẽpoiriwere'emamũ Janeruwarete 'ga nomoiri futari pẽ nui. A'eramũ aipo 'gã awau mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Anure nipo 'gã amũ je rerowiaaramũ pẽ pyygi pẽ nerawau pejejatykaaw ipe 'wyriara rowase pẽ moporogytaukaa jupe. “Ekoay 'ga akou mama'e tywera apou”, 'jau nipo 'gã pẽ nerawau 'wyriara upe pẽ mome'wau 'me jupe. A'eramũ kasi pekyje pejejerooramũ ne— 'jau 'ga 'gã nupe. —A'eramũ “Ma'ja 'jau sipo je 'gã nupe teporogytau 'wei”, pe'je kasi ne, pejekyjau ne. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Janeruwarete 'ga peu pẽ nerooramũ 'gã nupe peje'egawa amut pẽ nupe— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A'ere kũima'e 'ga amũ mytun awi wafukaja mua Jejui 'ga upe: —Jeruwa amanũ ai'i. A'ere jereki'yra 'ga arajuwa karaemãmera nomojo'ogi jee ai'i— 'jau 'ga wafukaja mua 'ga upe. —A'eramũ ene eje'ega 'ga upe jee: “Emojo'ok pejejuwa karaemãmera ejewirera 'ga upe”, ere ki 'ga upe jee— 'jau 'ga oje'ega mua Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A'eramũ Jejui 'ga 'jau etee 'ga upe: —Naejeki'yra ene iago'o anupa rũi je ruri ai'i— 'ga 'i etee 'ga upe, aipo ojeupe 'ga 'eramũ. —Naamanũ ma'e karaemã mojo'oka rũi je ruri ai'i— 'jau etee 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A'eramũ 'ga 'jau 'gã nupe nũ: —“Kwaiwete je karaemã futari”, pe'je awi. Nakaraemã rũi pẽ mogeukat ywag ipe. Tejerowiaramũ te je pẽ mogeukari ywag ipe Tejuwarete 'ga pyri— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","17","A'eramũ Jejui 'ga mama'e mũ mome'wau 'gã nupe nũ: —Kũima'e 'ga amũ ikaraemã kwaiwete ma'e 'ga amũ e'i ojeupe: “Kwaiwete te 'awamũ jeko pypiara 'wei. Kwaiwete jeremi'ua 'awamũ 'wei” 'jau 'ga ojeupe. “A'ere ijagawa niapoi jupe. A'eramũ je ma'ja apou jupe nũ'ũ. Najeporomonoweri je ee 'gã nupe”, 'jau 'ga 'ũina ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Sikõi'ĩ ma'ea pa je omono etyka kwy. Taapo tee amũ tuwiuu ma'e tejemi'u ryrũnamũ 'jau kwy. Tekaraemã reewe tomono inuga tupaw yau pype 'jau kwy”, 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“A'ere ta'e tejeupe 'jau kwy: Kwaiwete te jeremi'ua 'wei. Noporowykyi futari te je 'awamũ 'wei. Ajemi'wat etee futat te je 'awamũ te'ỹina 'wei” ta'e tejeupe etee futat 'jau kwy. “Teku'iramũ tejemi'u are te'ỹina 'jau kwy”, 'jau 'ga ojeupe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","—A'eramũ nipo aipo 'ga upe Janeruwarete 'ga 'jau: “Eremut ekoete eje'ega e'ỹina ra'e”, 'jau nipo 'ga 'ga upe, amara'neramũ 'ga ree. “Ene manũ re awỹja ma'ea eneremi'ua ki 'ei? 'Awauwe futat eremanũ ejemi'u awi kũi”, 'jau nipo 'ga oje'ega mua 'ga upe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","—Pẽẽ mũ nipo pejekaraemã are etee futat pejejea'aramũ. A'eramũ Jarejuwarete 'ga ree jẽmĩ nipo pejejea'are'emamũ futat— 'jau 'ga 'gã nupe. —Aipoa kũima'e 'ga 'jawe futat nipo pẽẽ. 'Ga 'jawe futat nipo pejemama'ea peetypap pejemanũnamũ— 'jau 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","A'eramũ Jejui 'ga 'jau wemiayuwa 'gã nupe nũ: —Ma'eramũ 'ã je 'i pẽ nupe: Pẽnea awi mama'e are etee pejejemogyau, je 'i pẽ nupe. “Ma'ja je i'wau 'awamũ”, pe'je awi pejejeupe. Pẽnea'ar awi pejejaity are etee pejejemogyau. Jarejuwarete 'ga ree te pejemogypyyk pejejemogyau, 'jau je 'ã pẽ nupe— 'jau 'ga 'gã nupe. —'Ga te 'ã pẽ apo. A'eramũ 'ga ojee pejemogypyygamũ mama'e mua pẽ nupe— 'jau 'ga 'gã nupe u'ama oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","—Sã'ã wyra'ia. Wyra'ia 'ã nuapoi agawewi mama'ea. Nitywi agawewi 'ã mama'e tymawa. A'etea 'ã Janeruwarete 'ga mama'ea omono jupe— 'jau Jejui 'ga 'gã nupe. —Niapoi agawewi wyra'ia 'ga upe. A'etea 'ga ojejukau ee. Pẽẽ taetu aje 'ã aeramũ. A'etea sipo 'ga nojejukai pẽ nee?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","—Peko sipo amũ pejeymane'em are ete ea'at ma'eramũ amũ pejeymane'emamũ namutat?— 'jau 'ga 'gã nupe u'ama. —Naani. Nia'wyri futari aipoa miamũ pẽ nupe ee pẽnea'ara. A'etea te nipo pẽyman pejejemogyau. Pejeywyr are tee pejejea'aramũ miamũ pemanũ futat. Mama'e are etee pẽnea'at pẽ nekoa nepẽ koga'uweri— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","—Ma'eramũ pẽẽ pejejea'aramũ mama'e are etee pejejemogyau ki 'ei?— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Sã'ã 'ywotyra. 'Ywa 'ã noporowykyi agawewi futat opotyr are. A'ere ipotyra esageteeramũ— 'jau 'ga 'gã nupe. —Ymã te janepytunera 'ga, Sarumãu 'ga, ikaraemã kwai ma'ea rakue. 'Ga te 'ã taity esage ma'ea rakue. A'ere 'ã 'ywotyra te 'ga raity esage apyraawi. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","'Ywotyra 'ã majepei 'ara rupi etee wesageramũ. A'eramũ 'ã ai'iwe opỹijagamũ. A'etea 'ã Janeruwarete 'ga omokaturam ipotyra jupe— 'jau Jejui 'ga 'gã nupe. —Jupe iapo re sipo 'ga nomonoi mama'e esagea pẽ nupe? Pẽẽ taetu aje 'ã pẽnesage 'ga upe. Ma'eramũ pẽẽ 'ga rerowiaraipa etee 'ũ? Pe'je 'ga rerowiaa futat nanimenime. Perowiaraiw awi etee 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Au'je mama'e are etee pẽnea'ar ire. Pejemuaẽm awi pejejemi'uram are etee. Pejemuaẽm awi nanẽ pejejaity are etee nũ. Jarejuwarete 'ga je'eg are etee pejejuka ete— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","—Janeruwarete 'ga rerowiare'ema 'gã te 'ã ajemuaẽm mama'e are etee. A'ere kasi pẽẽ 'ga 'jawe peko ne. Janeruwarete 'ga pẽnemifutara okwaap. Ojejuka 'ga pẽ nee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","—Jarejuwarete 'ga je'ega peenup katu katu. 'Ga je'eg imũ peko esage. A'eramũ 'ga mama'e esage mua pẽ nupe, pẽnemifutara mua pẽ nupe— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Pekyje futat kasi mama'ea pejejewi teepap ja'wyja'wyramũ ne. Pejemogypyyk futar iki pejejemogyau 'ga ree. Janeruwarete 'ga ojee pejemogypyygamũ iku'i futat 'ũina pẽ nee. A'eramũ 'ga mama'e esage mua pẽ nupe. Anure ywag ipe pẽ nesaka 'ga aku'iramũ futat pẽ nee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","—Pejekaraemã ki peme'eg amũ ka'aranũũ are. A'e repyfera monou ikaraemãe'ema 'gã nupe. A'eramũ Janeruwarete 'ga ka'aranũũa 'gã nupe imonoramũ ywag ipe mama'e mua pẽ nupe. Mama'ea pejejaupe imonoawera mepyau pẽ nupe. Peu mama'e nateepawa'uweri. Nitywi mama'e mateepaara. Nitywi agu'jaa peu. Nitywi jypemeruua. Nitywi muna'ywa. A'eramũ mama'ea ateepawe'emamũ futat peu— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","—Pejekaraemã are etee pẽnea'aramũ 'au ywy pe etee futat pejekaraemã pereko. A'ere Janeruwarete 'ga ojee pẽnea'aramũ, ywag ipe nanẽ mama'e esage muri pẽ nupe nũ. 'Auwara karaemã momytunara 'gã ojejuka 'au ojeapo ma'e are etee ajemogyau. A'ere ywag ipe karaemã momytunara 'gã jejukai Jarejuwarete 'ga ree te— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","—Anurenure'i nipo je oi Jarejuwarete 'ga pyri pẽ nui. Anure te nipo je ruri nũ. A'eramũ pẽẽ je ruru'jawa rapesaka pejejemogyau— 'jau Jejui 'ga 'gã nupe oporogytau 'ũina. —Sã'ã aeporowykya 'wyriara upe. A'eramũ 'ã 'wyriara 'ga awau watau wemiayuwa 'gã nui, maraka pe 'ga awau 'gã nui. A'eramũ 'gã 'ã 'upa tata monyka imỹina 'ga rura rapesaka. Owaẽmawe 'ga 'ã 'okwara mopoga wemiayuwa upe. A'erauwe 'ã 'wyriara 'ga remiayuwa iawopytymo'woka 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","A'eramũ 'gã aku'iramũ 'upa. 'Ga waẽma rapesakara 'gã aku'iramũ. “Au'je katu pa 'ga ruri jane sere'emauwe nũ”, 'jau 'gã ajaupe— 'jau Jejui 'ga 'gã nupe. —A'ere nipo 'ga opiara mosoka, oje'ega wemiayuwa 'gã nupe: “Pe'je pejejua pejejemi'waa”, 'jau nipo 'ga ojewyra rapesakara 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","—Meewei 'ur ire nipo 'ga ypyaje 'ua owaẽma. A'etea nipo 'gã ajemogyau 'ga rapesaka. 'Ga waẽmamũ nipo 'gã aku'iramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","Nan tee futat nipo pẽẽ je rura rapesakaramũ pejejemogyau au'jeteramũ je rapesaka— 'jau Jejui 'ga 'gã nupe. —Nepekwaawi futari je jewyawa. A'eramũ pẽẽ pejejemogyau au'jeteramũ je rapesaka— 'jau Jejui 'ga 'gã nupe u'ama. —Sã'ã 'oga jara 'ga muna'ywa rura kwaawe'ema. Muna'ywa rura kwaaw ire amunipo 'ã 'oga jara 'ga awawe'em 'og awi. A'ere 'ga nokwaawi futari muna'ywa rura wog ipe. Nan tee futat nepekwaawi pejejeki'yramũ je jewyawa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aipo 'ga 'eramũ Pedro 'ga 'jau 'ga upe: —Ore upe te ere aipo 'jau? Najuejue etee te 'ã ere oree nũ?— 'jau Pedro 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A'eramũ Jejui 'ga 'jau Pedro 'ga upe: —Je rerowiaaramũ etee futat pejemogy najuejue etee futat je rapesaka, je jewyra rapesaka— 'jau Jejui 'ga Pedro 'ga upe. A'eramũ Jejui 'ga mama'e mũ mome'wau 'gã nupe, 'gã mu'jau 'uaw are nũ: —'Wyriara 'ga remiayuw esage 'ga i'akwaap ma'ea. O'wyriara 'ga je'eg imũ etee futat mama'ea wapo. A'eramũ 'wyriara 'ga wata enune wemiayuw esage 'ga mỹina wemiayuwa 'gã nesakawamũ. “Aata je. A'eramũ je ene mỹina 'gã nesakawamũ”, 'jau 'wyriara 'ga wemiayuw esage 'ga upe. “Mama'ea ki emono 'gã nupe 'gã nemi'uramamũ”, 'jau 'ga 'ga upe. A'eramũ nipo 'ga 'wyriara 'ga awau watau 'gã nui. Anure nipo 'ga ojewya 'ua nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'Ga 'eawer imũ etee mama'e apo re nipo 'wyriara remiayuw esage 'ga aku'iramũ ajemogyau o'wyriara 'ga resakawe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A'eramũ 'wyriara 'ga we futat aku'iramũ 'ga ree wemifutar imũ etee 'ga porowykyramũ— 'jau Jejui 'ga 'gã nupe. —A'eramũ nipo 'ga a'jea futat 'ga monou 'ga mỹina okaraemã are ojejuka ma'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A'ere nipo imỹimyrera 'ga amũ 'i ojeupe: “Mukuu nã'ã je'wyriara 'ga oi re'ã, oporomukuramũ re'ã”, 'jau nipo 'ga ojeupe. A'eramũ nipo 'ga opytuna 'gã amũ nupãnupãu. A'ere nipo 'ga awau ojemi'waa, kawĩajaiwa rykua. A'eramũ nipo 'ga weawyrywamũ akou. Oporowykyawe'em nipo 'ga 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","A'e pype nipo 'ga 'wyriara 'ga 'ua owaẽma erujewi 'ga upe. Wapesage'emeteramũ nipo 'ga 'ua owaẽma erujewi 'gã nupe. A'eramũ nipo 'ga 'ga rekoarũe'ema resakawe 'ga mopimopika. A'ere nipo 'ga 'ga monou tata pe imomoa 'ga rerekou tyweaete— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—'Gã amũ nipo 'wyriara remifutara kwaapa futat numiamũ. A'ere nipo 'gã nuapoi jupe. A'eramũ nipo 'ga 'wyriara 'gã nupãnupãukaa tesirũmera 'gã nupe— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","—Amumera 'gã te nipo ajee nokwaap katui 'wyriara remifutara. A'e 'gã 'gã nonupãuui. Nonupãi kwaiwete. Inãinãnĩ'ĩ etee nipo 'gã nupãi, mama'e tywera apo re— 'jau Jejui 'ga 'gã nupe imome'wau. —'Gã amũ nipo 'wyriara remifutara kwaapa katu katu futat. 'Gã a'jea futat oporowyky jupe. Wemiesaga 'gã nee ojemogypyyka etee. Wemiesage'ema 'gã nee 'ga nojemogypyyga'uweri— 'jau Jejui 'ga 'gã nupe u'ama imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","A'eramũ Jejui 'ga 'jau 'gã nupe: —Mama'e mateepapa je ruri. Sã'ã tata mama'e tywera mateepawa. Nan tee futat nipo je ruri mama'e tywera mateepapa— 'jau Jejui 'ga 'gã nupe. —Janeruwarete 'ga nipo je rerekou tywerukaa pẽtywer are 'gã nupe. A'eramũ nipo 'ga werowiaara 'gã nerekou tywerukare'ema. A'ere je anure 'ga rerowiaare'ema 'gã etee ereko tyweretei— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","—Anurenure'i nipo je rerowiaare'ema 'gã je rereko tyweri. A'e are etee je rea'aramũ tekou— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","A'ere 'ga 'jau 'gã nupe: —“Jarejuwarete 'ga remimurera 'ga rur ire nipo ore jamuepawi”, pe'je kasi ne. Naani. Je ree taetu nipo pejamue pejejemogyau— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","—Je ree naju'jaju'jawe tee rũi pẽnea'at mama'e are. Mukũja 'gã nipo pẽpytuna 'gã oporomutaramũ je ree. Muapyra 'gã tee nipo ajee pẽpytuna 'gã niporomutari je ree. A'eramũ nipo 'gã naju'jaju'jawe tee rũi wea'aramũ je ree— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","—Kũima'e 'ga amũ nipo je rerowiaa. A'ere nipo 'ga ra'yra naje rerowiari. Kũjãmuku ẽẽ mũ nipo je rerowiaa. A'ere nipo ẽẽ ya naje rerowiari. A'eramũ nipo 'gã ajamueu je ree— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Ywagũna resakawe 'ã pẽẽ mũ 'jau pejejaupe: “Amana nipo 'ã 'ja”, 'jau 'ã pẽẽ pejejaupe. A'eramũ a'jea futat amana. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ywytu ruramũ 'ã pẽẽ, “'Arasimiũna nipo 'ã”, 'jau 'ã pẽẽ pejejaupe. A'eramũ 'arasimiũna futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","—Ywagũna resakawe 'ã pẽẽ amana kwaapa pejejemogyau. Ywytu ro'ysag are 'ã pẽẽ 'arasimiũna kwaapa— 'jau 'ga 'gã nupe. —Tejuwarete 'ga remiaporama je amome'u pẽ nupe. Ma'eramũ sipo nepekwaawi? Nepẽporokwaawiweri te 'ã ee. Ma'eramũ 'ã nepekwaawi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'eramũ ajee mama'e esagea pejejeupe iapoa nepekwaawi pejejemogyau 'ũ?— 'jau 'ga 'gã nupe. A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe nũ: ");
INSERT INTO kyzNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","—“Mama'e tywera 'ga wapo jee”, pejejeupe 'ga amũ 'eramũ pejewau pejeporogytau 'ga upe, 'ga mota'wau pejejeupe. Kasi a'e pe 'ga pẽ nerooi 'wyriara 'ga upe ne. A'eramũ 'wyriara 'ga pẽ monoukaa jefaruu 'ga upe, pẽ munewukaa ne. ");
INSERT INTO kyzNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Moromunepawa pype pejemono re nipo nepe'ẽarũi jui. Mama'e tywera apo mepy re tãmẽjẽ te pe'ẽ jui— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. —Nan tee futat ki pẽẽ. Mama'e tywera apo re peje'eg tãmẽjẽ futat Jarejuwarete 'ga upe. A'eramũ 'ga pẽ katu'oka tãmẽjẽ pẽ mogyau nũ. Ojeupe peje'ega'ne'emamũ 'ga pẽ nereko tyweretei aipo are— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jejui 'ga porogyta 'ga 'amamũ 'gã amũ 'ua owaẽma 'ga upe. —Ekoay 'wyriara 'ga, Piratu 'ga Garireja ywy pewara 'gã apisaukaa Jarejuwarete 'ga upe 'gã porogyta 'gã nupawamũ. Itywerete nipo 'gã. Ma'eramũ nipo 'ã Janeruwarete 'ga 'gã apisaukaa 'gã nupe, aru'e ore kũi— 'jau 'gã 'ua u'ama imome'wau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","3","A'eramũ Jejui 'ga 'jau 'gã nupe: —Naani. Nityweri 'gã kwaiwete. Ajepeja Garireja ywy pewara 'gã tywera 'gã nuapyraawi. Pẽẽ nanẽ pẽtywerete futat nũ. Pejetywer awi pejepoire'ema pẽẽ nanẽ futat pemanũ 'gã 'jawe. Pemanũ re nipo, Janeruwarete 'ga pẽ'aga monou mama'eukwaawa rapyaw ipe— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—'Awamũ 'ã 'og ywate u'aa Sirue pewara 'gã 'arimũ rai'i, 'gã apisau rai'i. Tesoitu 'gã pytuna. Itywerete ma'e 'gã sipo poromũ rai'i? Pẽtywera sipo 'gã wapyraap rai'i? ");
INSERT INTO kyzNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Naani. Pẽẽ juejue futat pepapap pejetywer awi pejepoire'emamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe nũ: —Kũima'e 'ga amũ 'ũina. A'eramũ y'wa 'ywa u'ama 'ga ko pe. Y'wa 'aawa rupi 'ga awau y'wa 'ywa resaka. A'ere nokoi'i futari i'a mũ akã are 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A'eramũ 'ga 'jau wemiayuwa 'ga upe: “Muapyra kwara 'ara rupi je ruri 'au y'wa 'ywa resaka ai'i. A'ere je naesagi amũ i'aa ai'i. A'eramũ ene etyka”, 'jau 'ga wemiayuwa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","—Aipo 'ga 'eramũ 'ga remiayuwa 'ga 'jau 'ga upe: “Tene i'ami ra'ne, 'awa kwara rupi tee ra'ne”, 'jau 'ga 'ga upe. “Taypywykai 'jau. A'ere 'yja esage tarut ara iypy are esaka 'jau”, 'jau 'ga 'ga upe. “Siesag i'a 'jau, 'yi esage oypy are erur ire 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","I'aramũ simu'am gatu etee 'jau. A'jea futat i'ae'emamũ sietyk 'jau”, 'jau 'ga 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau u'ama. —A'jea futat i'ae'emamũ ijetygi futari— 'jau Jejui 'ga 'gã nupe imome'wau. —Nan tee futat Janeruwarete 'ga mama'e tywera apo awi pepoira rapesagi ra'ne. Jui pepoire'emamũ 'ga nan tee futat pẽ netygi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Morowykye'ema rupi Jejui 'ga awau osou judeu 'gã jatykaaw ipe oporogytau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A'e pe ojero'wu ma'e ẽẽ mũ 'ua 'gã pyri. Ymã ẽẽ jero'wui akou rakue. Tesoitu te ẽẽ kwara mu'ari akou ojero'wau. Mama'eukwaawa ẽẽ erekou opir are. Iteu ma'e 'jawe ẽẽ mogoukaa. Najepyoi futari ẽẽ watau. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ẽẽ resakawe Jejui 'ga oje'ega ẽẽ upe: —Erefu'am ĩ. Enejaruete ene 'awamũ ĩ— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A'ere 'ga opo monou ẽẽ 'arimũ. Ẽẽ 'arimũ etee agawewi opo monou. A'erauwe ẽẽ u'ama gatu. Ojepywau. —Au'jete je katu'og ape wa'iko. Ene te 'ã eneresage jee— 'jau ẽẽ Jarejuwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A'ere judeu 'gã jatykaawa raarana 'ga amara'neramũ 'ga ree. Morowykye'ema rupi Jejui 'ga ẽẽ mafu'ami. “Ae katu'oga ae porowykya futat”, 'jau 'ga ojeupe. A'eramũ 'ga amara'neramũ Jejui 'ga ree. A'eramũ 'ga a'eramũ 'jau 'gã nupe: —Pejor awi pejejekatu'ogukaa morowykye'ema rupi— 'jau 'ga 'gã nupe. —Ymã te 'ã Moisesi 'ga ka'arana kwasiari inuga janee rakue. “Morowykye'ema rupi kasi peporowyky ne”, 'jau 'ga 'ã janee rakue. Ma'eramũ 'ã pejot morowyky rupi etee pejejekatu'ogukaa— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A'eramũ Jejui 'ga 'jau 'gã nupe: —“Morowykye'ema rupi kasi peporowyky ne”, pe'je awi oree. Pẽẽ nanẽ te 'ã peporowyky pejejemogyau morowykye'ema rupi. Wyra jara agawewi 'ã pẽẽ. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A'etea 'ã “ereporowyky awi morowykye'ema rupi”, pe'je jee. A'etea pejejeymawa pemoy'u morowykye'ema rupi. Ẽẽ taetu aea. Abraão 'ga juapyrera ẽẽ. Janepytuna futat ẽẽ. Ma'eramũ sipo je mama'eukwaawa moire'ema morowykye'ema rupi ẽẽ wi? Ymã te 'ã ẽẽ mama'eukwaawa rerekoi opir are rakue. Ma'eramũ je imoire'ema ẽẽ wi morowykye'ema rupi 'ũ, a'e te je nũ a'i kũi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Aipo 'eramũ 'gã opoyje'emamũ ajemogyau 'ga wi. 'Ga ree iporomutare'ema 'gã opoyje'emamũ. A'ere tesirũmera 'gã ku'iramũ 'ga ree, ẽẽ wi imoiramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Ma'ja 'jawe ajee je rerowiaara 'gã?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","—Sã'ã y'wa'ỹi'ĩ'ĩa, mostarda 'jawa. A'eramũ 'ã ae ityma. A'eramũ 'ã opopoa awau 'ã o'ywuuramũ. A'eramũ 'ã wyra'ia aja'yrapyau akã are, waity mogyau ee. Nan tee futat je rerowiaara 'gã— 'jau Jejui 'ga u'ama 'gã nupe. —'Awamũ 'gã inãinãnĩ'ĩ etee. A'ere nipo 'gã anure kwaiwete je rerowiaara 'gã jemomytuni awau— 'jau 'ga 'gã nupe u'ama imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","—Ma'ja'ja 'jawe ajee je rerowiaara 'gã?— 'jau 'ga oje'ega 'gã nupe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","—Sã'ã kũjã u'i mojerawa. A'eramũ 'ã imojopypeawa monou ipype. Inãinãnĩ'ĩ etee agawewi 'ã imonou ipype. A'etea 'ã awua. Nan tee futat je rerowiaara 'gã jemomytuni nipo— 'jau 'ga 'gã nupe u'ama. —'Awamũ 'gã inãinãnĩ'ĩ etee je rerowiari. A'ere nipo anure je rerowiaara 'gã jemomytuni kwaiwete— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jejui 'ga awau akou Jerusarega repejãna. Awaw ipe 'ga awau pe rupiwara 'gã mu'jau akou. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A'eramũ kũima'e 'ga amũ 'jau Jejui 'ga upe: —Inãinãnĩ'ĩ etee sipo ore oi ywag ipe?— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Aipo 'ga 'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽnea'at kasi pejejemogyau tesirũmera 'gã nee ne. Pejetywer awi pepoit. A'eramũ pẽẽ pejeporowykyau esage pejejemogyau pejejeupe ywag ipe pejejesawamũ— 'jau Jejui 'ga 'ga upe. A'eramũ futat 'ga 'jau 'gã nupe: —Ywaga rokwara nokwaruui. Je rerowiaara 'gã etee te oo osou ywaga rokwara rupi— 'jau 'ga 'gã nupe u'ama. —Jeje'ega renupare'ema 'gã nipo e'i “Ywag ipe je oi”, 'jau nipo 'gã numiamũ. A'ere jeje'ega renupare'ema 'gã nosea'uweri ywag ipe— 'jau 'ga 'gã nupe u'ama. A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe u'ama nũ: ");
INSERT INTO kyzNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","—'Okwara motyw ire 'oga jara 'ga nuawopytymo'wogi tekotee 'gã nupe. A'ere 'gã amũ nipo 'ua 'okwara mopoga 'ga upe. “Toroo orosou 'jau”, 'jau nipo 'gã numiamũ. A'eramũ 'oga jara 'ga awau oje'ega 'gã nupe: “Pe'je pejewau je wi. Nakwaawi je pẽẽ”, 'jau etee 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","—Nan tee futat nipo peo peu ywag ipe jeje'ega renupare'emamũ 'okwara mopoga jee. A'ere nipo je “Najeremiayuwa rũi pẽẽ”, je 'i etee pẽ nupe. “Pe'je pejewau pejejewya je wi”, je 'i etee pẽ nupe— 'jau 'ga 'gã nupe u'ama. —A'eramũ nipo pẽẽ 'jau jee: “Orojemi'wat ako ore ene pyri ikue. Ore'wyr ipe futat ako ore mu'e ape ikue”, 'jau nipo pẽẽ jee. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A'ere nipo je 'i etee pẽ nupe: “Najeremiayuwa rũi pẽẽ. Pe'je pejewau je wi”, 'jau etee nipo je pẽ nupe— 'jau 'ga 'gã nupe u'ama. —“Nepeenuwi futari jeje'ega. Pe'je pejewau je wi”, 'jau nipo je pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Aipoa 'ara rupi nipo pẽẽ jareypy 'gã nesaka. Abraão 'ga, Isaki 'ga, Jako 'ga, Jeruwarete 'ga je'ega mome'wara 'gã. Mĩmera 'gã nipo peesak ywag ipe numiamũ. A'ere nipo pẽẽ nepesei futari. A'eramũ nipo pẽẽ pejejaa'wau pejejupa pejese'ema rerekou. “Ma'eramũ ore 'ga rerowiare'ema arakou rakue 'ũ?” 'jau nipo pẽẽ— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","—A'ere nipo kwe pewara 'gã 'ua ajatykau je ree. Najuejue etee nipo 'gã 'ua ajatykau je ree. Awau ojejaga ywag ipe ojemi'waa je pyri— 'jau Jejui 'ga 'gã nupe oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","—Akotee nipo 'gã amũ numiamũ. A'etea nipo 'gã oo ojejaga ywag ipe je pyri ojemi'waa— 'jau 'ga 'gã nupe. —A'ere amumera 'gã nosea'uweri ywag ipe je pyri. “Je ika'aranũũ kwaiwete ma'ea. Je kũima'eeteetea 'jau. A'eramũ je Jejui 'ga tepoara futare'ema” 'jara 'gã nosea'uweri ywag ipe— 'jau 'ga 'gã nupe imome'wau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A'e pype fariseu 'gã amũ 'ua oje'ega Jejui 'ga upe: —Eka'jam 'aw awi ewau. Erote 'ga ene juka are ifuewet. A'eramũ ene ewau 'aw awi eka'jama kwe pe— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A'eramũ Jejui 'ga wea'aramũ ojeupe 'gã 'e are: “Mõ. Siesak 'ga poira oporowyky awi 'jau, e'i nipo 'gã jee”, 'jau 'ga ojeupe. A'ere 'ga 'i etee 'gã nupe: —Naani. Naka'jama'uweri je tewau. Tejuwarete 'ga remifutara 'ara rupi te je manũi. Nopoira'uweri je teporowyky awi. Erote 'ga 'me ate 'ga renamũ. Pekwap 'jau 'ga upe: “Nopoira'uweri je teporowyky awi. Mama'eukwaawa je omoit tekou 'gã nui. Ojero'wu ma'e 'gã je akatu'ok tekou, e'i etee 'ga”, pe'je 'ga upe pejewau— 'jau etee Jejui 'ga aipo 'gã nupe. —“Namateepawi we je Tejuwarete 'ga porowykya, e'i 'ga”, pe'je 'ga upe pejewau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","—Tejuwarete 'ga remifutar imũ etee futat je porowykyi tekou. Oporowykya je iapopaw ire te nipo 'ga je jukaukari 'gã nupe— 'jau 'ga 'gã nupe u'ama. —Jerusareg ipe futat nipo tewau temanũmũ. Peu futat Jeruwarete 'ga je'ega mome'wara 'gã apisara 'gã nuwi. A'eramũ je peu futat tewau temanũmũ nipo— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","A'eramũ 'ga 'jau Jerusareg ipewara 'gã nupe: —Jerusareg ipewaramũ futat te 'ã pẽẽ Jarejuwarete 'ga je'ega mome'wara 'gã apisaramũ pejup— 'jau Jejui 'ga 'gã nupe. —Sã'ã wyrasokwẽa wa'yra majatyka wakape 'wyripe imonoa kwanũ awi. Nan tee futat je— 'jau Jejui 'ga 'gã nupe. —“Tajejuka esage Jerusareg ipewara 'gã nee”, 'jau je 'ã pẽ nupe numiamũ. A'ere 'ã nepefutari etee. ");
INSERT INTO kyzNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A'eramũ 'awamũ Janeruwarete 'ga opoia futat pẽ nui— 'jau Jejui 'ga 'gã nupe. —A'eramũ nipo pẽ nee iporomutare'ema 'gã 'ua pẽ'wyrarete pojekau pẽ nui. 'Awamũ 'ã je nanẽ tewau pẽ nui nũ. A'eramũ pẽẽ je resagu'jape'ema 'awamũ. “Esageay Janeruwarete 'ga remimurera 'ga”, 'jawe'ẽwe pẽẽ je resagu'jape'ema futat— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Morowykye'ema mũ rupi Jejui 'ga awau osou fariseu 'ga amũ rog ipe ojemi'waa. 'Wyria'ri 'ga rog ipe awau osou. A'eramũ fariseu 'gã amũ 'ua Moisesi 'ga remikwasiarer are moromu'jara 'gã netee. 'Gã 'ua osou 'ga resaka. —Pe'je soo 'ga resaka. Mama'e tywera 'ga iapo re sipyyk 'ga 'jau— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Poje kũima'e 'ga amũ 'ua osou Jejui 'ga pyri. Awuwut ma'e 'ga 'ua osou 'ga pyri. A'eramũ fariseu 'gã 'jau ajaupe: —'Awamũ 'ã morowykye'ema. A'etea sipo 'ga awuwut ma'e 'ga okatu'ok?— 'jau 'gã ajaupe. —Ae katu'oga ae porowykya futat morowykye'ema rupi. Nokatu'oga'uweri nipo 'ga 'awauwe 'ga— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'ja e'i te Moisesi 'ga rakue? “Pekatu'ok kasi 'gã morowykye'ema rupi ne”, e'i te 'ga janee rakue? Naani. Aipo ne'i 'ga rakue— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","A'ere 'ga ree ajatyka ma'e 'gã noje'egi futari. Ojenosĩ 'gã 'ga wi aipo ojeupe 'ga 'eramũ. A'eramũ Jejui 'ga opo monou awuwut ma'e 'ga 'arimũ 'ga katu'oka. A'ere 'ga oje'ega 'ga upe 'ga katu'og ire: —'Awamũ enejaruete. A'eramũ ene ewau eje'wyr ipe— 'jau 'ga awuwut ma'efera 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A'eramũ Jejui 'ga 'jau esakarera 'gã nupe: —Pejeja'yra ywy kwara pype i'aramũ sipo nepenuẽmi jui morowykye'ema rupi? Pejejeymawa ywy kwara pype i'aramũ sipo nepenuẽmi jui morowykye'ema rupi?— 'jau 'ga 'gã nupe. —Nepeejara'uweri pejeja'yra imỹina ywy kwara pype. A'ea 'ara rupi pẽẽ iaporamũ je nanẽ ojero'wu ma'e 'ga katu'ogi morowykye'ema rupi nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A'ere 'gã noje'egi futari ajemogyau ojeupe 'ga 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ojemi'war enune Jejui 'ga awau afu'ama wewiri oo ma'e 'gã nesaka. 'Gã apyga resaka u'ama. “Naakotee ma'e 'gã nenawa 'arimũ rũi pa 'gã apygiweramũ ra'e. Esage ma'e 'gã apykawa 'arimũ etee pa 'gã apygiweramũ ra'e”, 'jau 'ga ojeupe 'gã nesaka. A'eramũ 'ga mama'e mũ mome'wau 'gã nupe 'gã mu'jawamũ: ");
INSERT INTO kyzNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—'Ga amũ nipo 'ua ene mo'wya, “Ere ejua ejemi'waa jerog ipe”, 'jau enee. A'eramũ nipo ene ewau eapyka esage ma'e 'gã apykawa 'arimũ. A'eramũ nipo esage ma'e 'ga amũ 'ua wapykawa 'arimũ ene renamũ osou. A'eramũ nipo ene mo'wyarera 'ga “Eyryk 'ga renaw awi”, 'jau enee. A'eramũ nipo ene ejenosõu ekou 'gã nowase— 'jau 'ga u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","—A'eramũ ene 'gã amũ emo'wyramũ eapyka akotee ma'e 'gã apykawa 'arimũ te. A'eramũ nipo ene mo'wyarera 'ga 'ua osou. A'eramũ 'ga te 'jau enee: “'Au te ejot eapyka je pyri”, 'jau enee— 'jau 'ga 'gã nupe. —A'eramũ ene ekou 'wyria'ri 'jawe 'gã nowase— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—“Je 'ã kũima'eeteetea” 'jara Janeruwarete 'ga imogyau tywet. A'eramũ Janeruwarete 'ga “Nakũima'eeteete rũi je” 'jara 'gã etee 'ga imogyau kũima'eeteeteramũ 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A'eramũ Jejui 'ga 'jau omo'wyarera 'ga upe: —Eremo'wy'wyt kasi esage ma'e 'gã etee ne, epytuna etee ne. Ajemogy tee ma'e 'gã we futar iki emo'wyt imojemi'waa ejepyri— 'jau 'ga 'ga upe u'ama. —Esage ma'e 'gã etee ene imo'wy'wyramũ 'gã nanẽ ene mo'wyri ene rerawau oje'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Itywetywet ma'e 'gã nanẽ ki emo'wy'wyt imojemi'waa ejepyri nũ— 'jau 'ga 'ga upe. —Iteu ma'e, eae'em. Mĩmera 'gã nanẽ ki emo'wy'wyt eje'wyr ipe nũ— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","—'Gã nene mepya'uweri. A'eramũ anure Janeruwarete 'ga 'gã mojemi'waawera mepyau enee— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A'eramũ Jejui 'ga pyri ojemi'wat ma'e 'ga amũ 'jau 'ga upe: —'Au aejemi'wara miamũ pa 'ã esage nũ. Peu ywag ipe taetu 'ã aeku'iawa te— 'jau 'ga 'ga upe, 'gã nemianuwamũ 'ũina. —Jarejuwarete 'ga pyri ojemi'wat ma'e 'gã taetu aku'iramũ nanimenime— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A'eramũ aipo 'ga 'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat nũ'ũ. A'jea futat ere poromũ— 'jau 'ga 'ga upe. A'eramũ 'ga mama'e mũ mome'wau 'gã nupe nũ: —Kũima'e 'ga amũ kumia wapoukat 'gã nupe. Kwaiwete 'ga iapoukaa. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","A'ere 'ga erojyw ire oje'ega wemiayuwa 'ga amũ upe: “Ere ewau 'gã nupe kwe pe, jeremimo'wy'wyrera 'gã nerua”, 'jau 'ga 'ga upe oje'ega. A'eramũ 'ga awau. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Awau 'ga owaẽma 'ga remimo'wy'wyrera 'ga amũ upe: “Ere ejua ejemi'waa, e'i 'ga enee ko”, 'jau 'ga awau 'ga upe. —A'ere aipo 'ga 'i etee 'ga upe: “Naani ki 'ei. Ywya je amut ape ko ki 'ei. A'eramũ je tewau esaka ki 'ei”, 'jau etee 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—Aipo ojeupe 'ga 'eramũ 'ga awau ajepeja 'ga upe etee 'jau nũ, 'ga remimo'wy'wyrera 'ga upe 'jau nũ: “Ere ejua ejemi'waa, e'i 'ga enee ko”, 'jau 'ga awau 'ga upe. —“Tee. A'ere nipo je nooi nũ'ũ. Teis kwataua je amut ko. A'eramũ je tewau tejemimurera resaka ra'ne”, 'jau etee 'ga 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—Awau 'ga aipo 'ga wi nũ. Awau 'ga ajepeja 'ga upe 'jau nũ: “Ere ejua ejemi'waa, e'i 'ga enee ko”, 'jau 'ga awau ajepeja 'ga upe etee nũ. A'ere “Je nooi ki 'ei. Jeremireko je 'awamue ko. A'eramũ je a'eramũ ejararũme'em. Nooi je”, 'jau etee 'ga 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—A'eramũ 'ga remiayuwa 'ga ojewya awau imome'wau 'ga upe. “Nuri etee 'gã je rupi ki 'ei”, 'jau 'ga awau imome'wau 'ga upe. A'eramũ 'ga a'eramũ amara'neramũ akou 'gã nee— 'jau Jejui 'ga 'gã nupe. —A'eramũ 'ga oje'ega 'ga upe nũ, aipo 'ga upe wẽjẽmĩ futat nũ. “Ekwap ajemogy tee ma'e 'gã mo'wy'wya. Erut ekoete te futar iki 'gã. Eae'ema 'gã we futat ki erut. Iteu ma'e 'gã miamũ futar iki erut. Itywet ma'e 'gã nanẽ ki erut. Mĩmera 'gã futar iki erut”, 'jau 'ga wemiayuwa 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","—A'erauwe 'ga awau nũ. A'eramũ 'ga 'gã nerua, kwaiwete. A'ere 'gã nomatyneemi 'ga roga. A'eramũ 'ga wemiayuwa 'ga mojewyru'japa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—“Ere ajee ewau kwe pe nũ. Kwe pe ekwap pe rupi nũ. Pe rupiwara 'gã nerua imajatykau jee. Tejoga ryneem gatu gatua te je afutat”, 'jau 'ga 'ga upe. —A'erauwe 'ga ojewya awau nũ. Ojewya awau 'gã nupe nũ. A'eramũ 'ga 'gã nerua, kwaiwete nũ. A'eramũ te 'ga 'ga roga matyneemi 'gã nerua. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","—“Amo'wy'wyt futat je 'gã ai'i numiamũ, kwaiwete ai'i numiamũ. A'ere 'ã 'gã jẽmĩ nuri ojemi'waa je pyri. A'eramũ 'gã 'awamũ jeremi'u 'wawe'em futat. Nomonoi futari je tejemi'ua 'gã nupe”, 'jau 'ga 'gã nupe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Anure Jejui 'ga awau watau akou nũ. Kwaiwete 'gã awau 'ga rupi. A'eramũ 'gã awau akou oporogytau pe rupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Pẽporomutat pẽẽ pejepytuna 'gã nee. Pejey are, pejejuw are, pejejewirer are, pejejenyr are, pejepytun are, pejejee nanẽ nũ— 'jau 'ga 'gã nupe 'gã nerawau 'gã nerekou pe rupi. —A'ere je 'i pẽ nupe: Jeremiayuwamũ pejejekoweramũ ki pẽporomutat je ree pejepytuna 'gã nee pejeporomutara apyraapa. Je ree pejeporomutaramũ ki pẽẽ mama'e apou jeremifutar imũ je muorypawamũ. “Ereapo awi nanuara ki sa”, 'jau nipo pẽpytuna 'gã pẽ nupe. A'ere kasi eremojerowiat 'gã ne. Jeje'eg imũ etee futat pẽẽ iapou. Kasi a'e pe pẽẽ najeremiayuwa rũi ne— 'jau 'ga 'gã nupe 'gã nerawau 'gã nerekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","—Jeremiayuwamũ pejejekoweramũ jeremifutara etee futat pẽẽ iapou, pejekyjawe'em 'gã pejejereko tywer awi. “Tene 'gã je jukai kwy. Napoira'uweri je Jejui 'ga rerowiar awi”, 'jau etee ki pẽẽ— 'jau 'ga 'gã nerawau 'gã nerekou pe rupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Kũima'e 'ga amũ nipo 'og ywate are aparuapoweramũ. A'eramũ 'ga ka'aranũũa ra'ne imojopyrũmũ 'ũina. “Taesak ka'aranũũa i'jawe jooa 'jau kwy, 'oga apoa 'jawe jooa 'jau kwy”, 'jau nipo 'ga 'ũina imojopyrũmũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","“Kasi 'gã a'e pe 'oga je imateepawe'emamũ je jai ne kwy”, 'jau nipo 'ga ojeupe— 'jau Jejui 'ga 'gã nupe imome'wau 'gã nerawau 'gã nerekou. —Nan tee futat nipo pẽẽ— 'jau Jejui 'ga 'gã nupe. —A'eramũ pẽẽ je rerowiaaramũ pejejemogyau pejejea'aramũ ra'ne. “A'jea futat sipo je rekoi 'ga rerowiarareteramũ 'wei?” 'jau ki pẽẽ pejejemogyau pejejea'aramũ ra'ne— 'jau 'ga 'gã nupe. —“A'jea futat sipo je 'ga porowykya etee futat iapoi 'wei”, 'jau ki pẽẽ pejejeupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—'Wyriara 'ga amũ remiayuwa nipo amara'neramũ ajepeja 'wyriara 'ga remiayuwa 'gã nee te. A'eramũ nipo 'gã 'jau o'wyriara 'ga upe: “Soo 'gã apisau 'jau” 'jau nipo 'gã 'ga upe. A'eramũ nipo 'wyriara 'ga 'jau 'gã nupe: “Tee. Tene ra'ne. Kwaiwete 'ga remiayuwa pytuna. Wĩti miu 'ga remiayuwa pytuna. Jane najanepytuni. Teis miu etee te 'ã janepytuna. Siapisipap sipo jane 'gã?” 'jau nipo 'ga wemiayuwa 'gã nupe. —“Tee. Naani nipo nũ'ũ. 'Gã etee nipo jane apisipap”, 'jau 'ga remiayuwa 'gã 'ga upe. A'eramũ nipo 'wyriara 'ga oje'ega ra'ne imonou ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A'eramũ 'gã oje'ega pyu etee futat ojomojyrũmũ— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Nan tee futar iki pẽẽ. Jeremiayuwamũ pejejekoweramũ pejejea'aramũ ra'ne pejejemogyau— 'jau 'ga 'gã nupe. —Pẽẽ je rerowiaraipa etee. A'ere etyka 'ea nia'wyri— 'jau 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Sã'ã jukyra resagea futat numiamũ. A'ere kumi pype omonoramũ nomẽ'ẽi futari. Aipoa jukyra nia'wyri futari. ");
INSERT INTO kyzNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A'ea jukyra numiamũ. A'ere namuei mama'ea. A'eramũ ae imonou imomoa yty apy'rarimũ. Nan tee futat je rerowiar awi opoit ma'e 'gã— 'jau Jejui 'ga 'gã nupe. —'Ga amũ te nipo ajee mama'eaya ojeupe ijesaukaramũ opoit je rerowiar awi. 'Gã je rerowiaa numiamũ— 'jau 'ga 'gã nupe. —Ee pejejeapyoweramũ ki peapyaka katu jeje'eg are— 'jau 'ga 'gã nupe 'gã nerawau 'gã nerekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Anure itywet ma'e 'gã 'ua Jejui 'ga renupa 'upa. 'Wyriararete upe ka'aranũũ pyykara 'gã nanẽ kwaiwete nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Gã nesakawe fariseu 'gã amũ Moisesi 'ga remikwasiarer are moromu'jara 'gã netee Jejui 'ga ago'wau 'upa: —Kuu. Itywet ma'e 'gã jekoty'aawa 'ga ra'e— 'jau 'gã ajaupe 'upa. —Ojemi'waa nanẽ 'ga 'gã pyri ra'e nũ— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","A'e renupawe Jejui 'ga 'jau 'gã nupe: —Itywet ma'e 'gã werowiara we futat Janeruwarete 'ga afutat— 'jau 'ga 'gã nupe. A'eramũ 'ga mama'e mũ mome'wau 'gã nupe 'gã mu'jau 'Uwarete 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Kũima'e 'ga amũ nipo wyra jara. Karupa'mĩa nipo 'ga reymawa. Kwaiwete nipo 'ga reymawa. Sẽg nipo 'ga reymawa pytuna. A'ere nipo karupa'mĩ amũ ka'jami opytun awi ka'a pe. A'eramũ nipo ijara 'ga ipytuna jaga ukaja pype inuga. Ipytuna jãmaw ire nipo 'ga awau oka'jam ma'efera rekaa akou. A'eramũ nipo 'ga awau owaẽma jupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Esakawe aipo 'ga iupia imonou imopeywaa ojasi'y'warimũ erua. Aku'iramũ 'ga oka'jam ma'efera rerua oje'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wog ipe owaẽmawe nipo 'ga oje'ega monou opytuna 'gã nupe: “Pe'je pejejua pejeku'iramũ je pyri. Tejeymawa je aesak ko”, 'jau nipo 'ga 'gã nupe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","—Nan tee futat Jeruwarete 'ga ku'iramũ 'ũina. Otywer awi itywet ma'e 'ga poiramũ 'ga ku'iramũ 'ũina ywag ipe, ywagipewara 'gã netee— 'jau Jejui 'ga 'gã nupe imome'wau. —Nan tee otywer awi opoit ma'e 'gã nee 'ga ku'iramũ 'ũina. Esage ma'e 'gã nee aku'ia 'ga iapyraapa 'ũina itywet ma'efera 'gã nee— 'jau 'ga 'gã nupe 'gã mu'jau 'Uwarete 'ga ree 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe nũ: —Kũjã ẽẽ mũ 'ywope'ia wereko, ka'aranũũ 'ywope'ia. Teis ẽẽ ka'aranũũ 'ywope'ia pytuna. Epyuu ma'ea juejue ẽẽ upe. A'ere nipo amũ 'ari ẽẽ wi. A'eramũ ẽẽ tata monyka esakawamũ 'oga peia imua imono'oga esaka. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Esakawe ẽẽ oje'ega ojepyriwara 'gã nupe: “Pe'je pejejua je pyri pejeku'iramũ. Aesak je teka'aranũũa ko”, 'jau ẽẽ 'gã nupe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—Nan tee futat Janeruwarete 'ga ku'iramũ otywer awi 'gã poiramũ. Ywagipewara 'gã netee 'ga aku'iramũ 'ũina— 'jau 'ga 'gã nupe 'gã mu'jau. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A'ere Jejui 'ga 'ũina mama'e mũ mome'wau 'gã nupe nũ, 'gã mu'jau 'Uwarete 'ga ree: —Kũima'e 'ga amũ mukũi tee 'ga ra'yra 'gã. Kũima'ea jue 'ga ra'yra 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iwujaa 'ga 'jau 'uwa 'ga upe: “Anure ki ekaraemã emut oree. A'ere je tema'ea 'awauwe ifutari. Emanũme'ẽwe jema'ea emut jee”, 'jau iwujaa 'ga 'uwa 'ga upe. —A'erauwe 'ga okaraemã mojo'oka wa'yra 'gã nupe. Kwaiwete 'ga ka'aranũũa. A'eramũ 'ga okaraemã kwajamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","—Anurenure'i 'ga ra'yra 'gã awau 'ga wi, iwujaa 'ga awau muku 'ga wi. Tapy'ỹja mũ 'wyrarete pe 'ga awau 'ga wi. Peu 'ga oka'aranũũ momyaupap. Kũjãmene'em are, kawĩajaiw are 'jau. Mĩmer are 'ga oka'aranũũ momyaupaw ekoete. Nan etee etee 'ga akou nũ. Ika'aranũũe'ema 'jawe akou nũ. Oka'aranũũ momypaw ire 'ga akou ty'ara upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aman ipe agawewi. A'etea amana nokyri 'gã nupe. A'eramũ temi'ua opapapap. A'eramũ peuwara 'gã ty'ara upe ajemogyau. Peu oo ma'efera 'ga nanẽ akou ty'ara upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","—A'eramũ 'ga 'jau peuwara 'gã nupe: “Jeporowykywet je tekou”, 'jau 'ga akou 'gã nupe, morowyky rekaa ojeupe. A'eramũ 'ga amũ 'jau 'ga upe: “Peu ekwap ekou, tajaurana poitawamũ”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","—A'erauwe 'ga awau akou tajaurana poitawamũ. A'eramũ 'ga ty'ara rerekou. Tajaurana futawa resaka 'ũina. A'eramũ 'ga tajaurana futawa uweita jui numiamũ. A'ere teymajara 'ga a'ea miamũ na'uukari 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ty'ara rerekou 'ga aipo 'jau. “Kwaiwete agawewi nã'ã jeruwa 'ga remiayuwa jepi re'ã. A'etea nã'ã kumia emyret jepi re'ã. A'ere pa je 'ã 'au ty'ara rerekoi nũ. Maran te 'ã nooi tekou tejewya tejuwa 'ga resaka nũ 'i”, 'jau 'ga akou ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Tajemome'u tejuwa 'ga upe 'jau kwy”, 'jau 'ga 'ũina u'arasigamũ. “Jetywerete je tekou jarejee ai'i, Jarejuwarete 'ga upe nanẽ ai'i nũ, ta'e imome'wau tejuwa 'ga upe 'jau kwy”, 'jau 'ga akou ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","“Eja'yra 'jawe kasi je rereko ape 'awamũ ne, ta'e 'ga upe 'jau kwy. Au'je je rereko ape eja'yramũ je rekoramũ jepi, ta'e 'ga upe 'jau kwy”, 'jau 'ga ojeupe 'ũina. “A'eramũ ene 'awamũ je moporowykyau etee ejee, ta'e tejuwa 'ga upe 'jau kwy. Tejemi'ua tamepy tekou 'jau, ta'e tejuwa 'ga upe 'jau kwy”, 'jau 'ga 'ũina ojeupe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","—A'erauwe 'ga afu'ama o'wya. Pe awi etee futat 'ga awau. Ojewya awau owaẽma 'uwa 'ga upe. Muku 'ga rekorauwe 'ga ruwa 'ga 'ga resaka. “Kweramũ nipo jera'yra ruri akou nũ”, 'jau 'ga ojeupe. —'Ga resakawe 'ga awau ujãna 'ga rowosõu awau 'ga mana. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","—A'eramũ 'ga 'jau 'uwa 'ga upe: “Jetywerete je tekou jarejee ai'i, Kiapi'ni. Jarejuwarete 'ga upe nanẽ ai'i nũ, Kiapi'ni”, 'jau 'ga 'uwa 'ga upe. “Eja'yra 'jawe kasi je rereko ape 'awamũ ne”, 'jau 'ga 'uwa 'ga upe. “Au'je je rereko ape eja'yramũ je rekoramũ jepi”, 'jau 'ga 'uwa 'ga upe oje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—A'ere 'ga ruwa 'ga 'i etee 'ga upe: “Ene'me awi. Eremur awi aipoa ki sira ko. Jera'yra futat ene kũi”, 'jau etee 'ga ruwa 'ga 'ga upe. “Nafutari je nanuara. Wesaga'uwe'emamũ te ae poromũ ae 'i ujara upe”, 'jau tee 'ga wa'yra 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. —A'ere 'ga ruwa 'ga 'jau wemiayuwa 'ga amũ upe: “Ekwap taity esage pe rerua kamẽsĩete imunepa 'ga wi. Fãyrũ reewe futar iki erut 'ga upe. Myapaawa nanẽ amũ rerua 'ga pyapaawamũ”, 'jau 'ga wemiayuwa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“Wyra pejuka amũ jera'yra 'ga upe. Kwatau ra'yru'ia, oreremimoky'rafera ki perut ijukau. Janeroryp jarejupa 'jau”, 'jau 'ga wemiayuwa 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","—“Jera'yra nipo 'ã amanũ rakue”, a'e je tekou jepi. A'ere 'ã jaruete jera'yra rekoi ra'e jepi— 'jau 'ga 'gã nupe, ojeupe wa'yra 'ga poromũ. “Oka'jam 'ga ako je wi ikue. A'ere 'ã ekoje ra'e jepi. A'ere 'ã turi opoa akou jee nũ. A'eramũ jane jarejemuekõẽãina 'ga rur are”, 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Wewirera 'ga waẽmamũ tuwi ma'e 'ga akou ko pe oporowykyau. A'ere 'ga 'ua. Oporowykypaw ire 'ua, maraka renupa. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A'eramũ 'ga 'jau 'gã amũ nupe: “Ma'ja poromũ nũ?” 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","—“Enerewirera 'ut ojewya akou ra'e. A'eramũ eneruwa 'ga kwatau ra'yru'i jukaukaa oree ko. ‘Sajemuekõẽãi jera'yra 'ga ree’, 'jau 'ga oree ko”, 'jau 'gã 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—A'erauwe tuwi ma'e 'ga amara'neramũ. A'eramũ 'ga osowe'em. 'Ga mara'nea 'ga rerekou. A'eramũ 'ga ruwa 'ga uẽma 'ga resaka. “Ere ejua esou, kisit”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","30","—A'eramũ 'ga 'jau 'uwa 'ga upe: “Je ree jẽmĩ 'ã nenerorywi jepi. Nerejemogypyygi 'ã je ree jepi. Je etee agawewi 'ã oporowyky tekou enee. Tekotee 'jawe je 'ã eneje'ega oware'ema jepi”, 'jau 'ga 'uwa 'ga upe. Wewirera 'ga ree 'uwa 'ga rorywamũ 'ga aipo 'jau 'ga upe. “Majawer are etee agawewi 'ga 'ã ka'arana momypaw ekoetei rai'i. A'etea 'ã eneporia 'ga ree. Je ree jẽmĩ 'ã eporiae'emamũ jepi. Je upe jẽmĩ 'ã jarejeymawa mũ jukawe'e'mĩ jarejee jepi. Wyrasokwẽ miamũ 'ã amũ jukaukare'ema jarejee jepi, oporowyky ma'eramũ jẽmĩ jepi”, 'jau 'ga 'uwa 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. —Wyra jukaramũ amara'neramũ 'uwa 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A'ere 'ga ruwa 'ga 'i etee 'ga upe: “Ene 'ã jepir are ereko. Nereoi 'ã muku je wi. Janemama'ea enemama'ea futat”, 'jau 'ga wa'yra 'ga upe, aipo ojeupe 'ga 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","“Omomot sipo 'gã jera'yra rakue pa”, a'e je tekou jepi. A'ere 'ã turi akou opoa janee. A'eramũ je 'jau 'gã nupe ko: “Sajemuekõẽãi 'ga ree 'jau, 'jau je 'gã nupe ko”, 'jau 'ga wa'yra 'ga upe— 'jau Jejui 'ga imome'wau 'gã nupe. —Saa'e kũima'e 'ga ku'ia. Wa'yra ojeupe ijewyt turamũ 'ga ku'ia rakue. Nan tee futat Janeruwarete 'ga ku'iramũ 'ũina otywer awi opoit ma'e 'gã nee— 'jau Jejui 'ga 'ũina imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe nũ: —Kũima'e 'ga amũ wemiayuwa 'ga omono okaraemã pyykaramũ numiamũ. A'ere aipo 'ga nia'wyri. Ka'aranũũ jara 'ga wi ka'aranũũ momyaupap ekoete etee futat 'ũina 'ga wi. A'eramũ 'ga a'eramũ 'ga amũ 'ua imome'wau 'ga upe. “Enekaraemã pyykara 'ga nia'wyri ra'e ki 'ei. Ekoay 'ga enekaraemã mateepapa ekoete ki 'ei”, 'jau 'ga 'ua imome'wau karaemã jara 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","—A'eramũ karaemã jara 'ga 'ga renũina, okaraemã raarana 'ga renũina. A'eramũ 'ga 'jau 'ga upe: “A'jea te jekaraemã eremomypap ekoete e'ỹina?” 'jau nipo 'ga 'ga upe. “Ere ajee ewau ikwasiaa jee ka'aran are inuga”, 'jau 'ga okaraemã pyykara 'ga upe. “'Gã nera ki ekwasiat inuga jee ka'aran are. Erawarera 'gã nera ki ekwasiat inuga jee. 'Gã nemireroofera nanẽ ki ekwasiat inuga jee ka'aran are”, 'jau karaemã jara 'ga 'ga upe. “Aipo apo re tomono 'ga amũ imỹina ene py'rau 'jau nũ”, 'jau 'ga 'ga upe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—A'eramũ 'ga awau 'ga wi. A'eramũ 'ga 'jau ojeupe: “Tỹỹ. Maran je tekou 'awamũ 'ũ? Ma'ja je iapou mama'ea tejeupe imuawamũ 'ũ? Najefuakara'uweri je teporowyky apou”, 'jau 'ga ojeupe. “Ajenosĩ je tekou mama'e renũina 'gã nupe ne kwy”, 'jau 'ga ojeupe etee futat 'ũina. “Ma'ja ajee je aapo 'awamũ 'ga upe 'ũ? Je muẽm are 'ga fueweramũ 'awamũ”, 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Amorytee pa je tejara 'ga kwy”, 'jau 'ga ojeupe. “'Ga karaemã rerawarera 'gã pa je apoat kwy”, 'jau 'ga ojeupe. “A'eramũ 'gã je muẽmamũ ‘Ere ejua 'au ore pyri. Mama'e toromono ene upe 'jau’, 'jau jee kwy”, 'jau 'ga ojeupe etee futat 'ũina— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—A'eramũ 'ga 'ga karaemã rerawarera 'gã nenũina: “Ma'ja te ereroo rai'i?” 'jau 'ga 'ga amũ upe. —“'Miara kawera ako je aroo ai'i”, 'jau erawarera 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Marana te ereroo rai'i?” 'jau 'ga erawarera 'ga upe. —“Kwaiwete je erooi ai'i. Sẽg yrũũ te je aroo ai'i”, 'jau erawarera 'ga imome'wau 'ga upe. —A'eramũ 'ga 'jau erawarera 'ga upe: “Ekwasiat 'au. Sĩkwẽta etee ki ekwasiat inuga ka'aran are”, 'jau 'ga erawarera 'ga upe. “Jane'me ijara 'ga upe 'jau”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","—A'ere 'ga ajepeja 'ga renũina nũ: “Ma'ja te ene ereroo rai'i?” 'jau 'ga 'ga upe nũ. —“Juowuuran ako je aroo ai'i, miu yrũ ai'i”, 'jau 'ga 'ga upe. —“Ere ajee inuga ikwasiaa 'au oito sẽtu etee ka'aran are”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Aipo kwaapawe karaemã jara 'ga amara'neramũ 'ga ree. “Ene 'ã muna'ywa. Jekaraemã are 'ã eremunarũ ekou. A'etea 'ã ene'akwaap. 'Awamũ nipo 'gã jejukai ene ree numiamũ”, 'jau 'ga 'ga upe— 'jau Jejui 'ga 'gã nupe. A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —A'jea futat. Janeruwarete 'ga je'ega renupare'ema 'gã i'akwaap futat numiamũ. A'ere 'ga rerowiaara 'gã nanẽ nokwaawi katu 'ga remiapoa. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A'eramũ je pẽ mu'jau 'ga remifutar are. Pejekaraemã pemono amũ ikaraemãe'ema 'gã nupe. Nanuara 'ga afutat 'ũina, a'e je 'ã pẽ nupe— 'jau Jejui 'ga u'ama 'gã nupe. —Nanuara pẽẽ iaporamũ Janeruwarete 'ga pẽ monoi peu ojepyri. Nanuaramũ 'ga pẽ napesagi 'ũina peu ywag ipe 'jau agawewi je 'ã pẽ nupe imome'wau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Ika'aranũũe'ema 'gã amũ nipo oka'aranũũa wereko esage, mama'e esage are etee imomyau. A'e 'ga nanẽ oka'aranũũ kwajamũ wereko esage futat nũ, mama'e esage are etee imomyau. Imomyau ekoete'ema akou— 'jau Jejui 'ga 'gã nupe. —Ika'aranũũe'ema 'gã amũ oka'aranũũ'ĩnamũ imomyau ekoete etee futat. A'e 'ga nan tee futat oka'aranũũ kwajamũ omomy ekoete te futat ajemogyau— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","—Nan pẽẽ iaporamũ Janeruwarete 'ga namura'uweri omama'ea pẽ nupe— 'jau Jejui 'ga 'gã nupe imome'wau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","—Janeruwarete 'ga ma'e ete ate 'agamũ mama'ea. 'Ga te 'ã jane mogy 'agamũ oma'ea ywy pype— 'jau 'ga 'gã nupe. —Oma'ea mama'e are ae jejuka esage'emamũ 'ga namura'uweri mama'ea ae upe peu— 'jau 'ga 'gã nupe u'ama oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Namukũja 'wyriara 'gã nemiayuwa rũi 'ga amũ rekoi. Noporowykya'uweri 'ga amũ mukũja 'wyriara upe. Kasi a'e pe 'ga ajepeja 'ga ree etee 'ga poromutaramũ akou ne. Majepeja 'ga ree jẽmĩ oporomutare'emamũ ne. Wemifutara 'ga je'eg imũ etee mama'e apou ne. A'eramũ 'ga wemifutare'ema 'ga je'eg imũ mama'e apowe'em ne. Nan tee futat pẽẽ. Pejeka'aranũũ kwaiwete are etee ea'at ma'eramũ nepẽnea'aru'jawi Jarejuwarete 'ga ree. Nepejemogypyyga'uweri ka'aranũũ are Jarejuwarete 'ga reewe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aipo 'ga 'erauwe fariseu 'gã 'ga rerekoemãu etee. Ka'aranũũa tee 'gã afutat. A'eramũ 'gã Jarejuwarete 'ga je'ega jẽmĩ futare'ema. A'eramũ 'gã a'eramũ Jejui 'ga rerekoemãu etee. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽẽ 'ã ka'aranũũa pemono ika'aranũũe'ema 'gã nupe jepi. “Esage ma'e 'ga ra'e. Ka'aranũũa 'ga omono itywet ma'e 'gã nupe”, te'i etee 'gã oree 'jau, pe'je 'ã jepi. Ma'eramũ 'ã ka'aranũũa pemono 'gã nupe jepi. A'ere naJaneruwarete 'ga rũi imonoukari pẽ nupe. Pemono ekoete te 'gã nupe. “Tore futarete 'gã 'jau”, pe'je tee jepi— 'jau Jejui 'ga 'gã nupe. —A'ere Janeruwarete 'ga pẽ kwaawi futari. Janeruwarete 'ga naea'ari pẽ 'jawe mama'e are etee— 'jau Jejui 'ga 'gã nupe. —Aeremifutara 'ga nafutari— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Ymã te 'ã Moisesi 'ga Janeruwarete 'ga je'ega kwasiari inuga ka'aran are janee rakue. Moisesi 'ga manũ re 'ã, 'ga amũ ete akou 'ga py'rau rakue. 'Ga upe nanẽ 'ã Janeruwarete 'ga oje'ega rakue nũ. A'eramũ 'ga nanẽ futat 'ã 'ga je'ega kwasiaa inuga ka'aran are janee rakue. Ymã we 'gã 'ã ajamu'jau Jarejuwarete 'ga je'eg are rakue— 'jau 'ga imome'wau 'gã nupe. —'Awamũ 'ã Juã 'ga nanẽ pẽ mu'jau 'ga je'eg are rai'i nũ. “Pejetywer awi pepoiramũ Janeruwarete 'ga pẽ monoi wemiayuwamũ”, 'jau 'ã Juã 'ga pẽ nupe rai'i. A'eramũ 'ã mytuna 'gã wekoweramũ Janeruwarete 'ga remiayuwamũ rai'i. A'eramũ 'ã 'gã opoia otywer awi rai'i. Juã 'ga ojeupe 'ga mome'uramũ 'gã 'ã opoia kwaiwete otywer awi rai'i. A'eramũ Janeruwarete 'ga 'gã monou wemiayuwamũ— 'jau Jejui 'ga imome'wau u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—A'jea futat 'gã nemikwasiarer ymanera resageramũ janee 'awamũ miamũ futat. A'jea futat nateepawa'uweri Janeruwarete 'ga je'ega jane wi. Ywaga teepawamũ ywy retee 'eramũ miamũ futat nateepawa'uweri Janeruwarete 'ga je'ega— 'jau Jejui 'ga 'gã nupe u'ama imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—“Kũima'e 'ga amũ nipo wemireko retyka awau amutee rerekou nũ” 'ea nia'wyri Janeruwarete 'ga upe. Itywerete a'e 'ga akou Janeruwarete 'ga rowase. Etygipyrer are, kũjã are nanẽ kasi peko ne nũ. Imen futat aipoa kũjã akou. “Pejejemogyau nipo pejejuemireko are” 'ea Janeruwarete 'ga nafutari— 'jau Jejui 'ga imome'wau 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe nũ, 'gã mu'jawamũ nũ: —Kũima'e 'ga amũ akou waity esagea te imunepa rakue, ika'aranũũ kwai ma'e 'ga rakue. A'eramũ 'ga maraka apou 'gã nupe au'jeteramũ akou rakue. Maraka apoaw ipe 'ga mama'e monou 'gã nupe. Kwaiwete 'gã mojemi'waa rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","—Ajepeja 'ga ipito'om ma'e 'ga otywereteramũ. Lasaru 'ga rera. A'eramũ 'ga pytuna 'gã 'ga rerawau 'ga mỹina ika'aranũũ kwai ma'e 'ga pyri 'ga rejaa. “Siesak 'ga mama'e'i mũ mura 'ga upe 'jau”, 'jau 'gã numiamũ. A'ere 'ga namuri'i mama'ea 'ga upe. Kasurua etee 'ua 'ga pira rerepa 'ga wi, 'ga pito'oma rerepa. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Anure ipito'om ma'e 'ga amanũmũ. A'eramũ 'ga manũ re ywagipewara 'gã 'ua 'ga rerawau ojepyri. Abraão 'ga pyri 'ga rerawau imỹina, 'ga muapyka 'ga mojemi'waa. A'ere ika'aranũũ kwai ma'e 'ga amanũmũ nũ. A'eramũ 'ga pytuna 'gã 'ga rerawau 'ga tyma. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","'Ga 'aga nanẽ awawayayau mama'eukwaawa rapyaw ipe nũ. A'eramũ 'ga 'ũina akou tyweaete. Tata rakuwa 'ga mỹina 'ga rerekou tyweaete. A'eramũ 'ga Abraão 'ga piresaka. Ipito'om ma'efera 'ga resaka Abraão 'ga pyri. Mukuu 'ga 'ũina Abraão 'ga resaka. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A'eramũ 'ga wafukaita 'ga upe: “Abraão! Ene 'ã jeramỹja! Ejemuaẽm iki je ree. 'Y'ia erurukat ara jee Lasaru 'ga upe, 'ga fã'ĩ are etee jekũ muakỹmawamũ. Ekoay jekũ osinisiniga”, 'jau ika'aranũũ kwai ma'efera 'ga oje'ega Abraão 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—A'eramũ Abraão 'ga 'jau 'ga upe: “Naani nũ'ũ. 'Auwaramũ ore 'ã norooarũa'uweri peu enerekwaw ipe. Pẽẽ nanẽ pe awi pejejorarũme'em 'au orerekwaw ipe nũ”, 'jau Abraão 'ga 'ga upe. “Nenerea'ari nipo ejekwawer are? Eka'aranũũ are etee ako ejerowiaraipa ikue. A'eramũ ene 'awamũ e'ỹina eko tyweaw ipe” 'jau 'ga 'ga upe. “A'ere ako Lasaru 'ga nitywi mama'ea ikue. A'eramũ 'ga 'awamũ akou 'au futat je pyri wekõẽãjamũ. Wekõẽãimawe'emamũ futat 'ga akou 'awamũ je pyri. A'eramũ je a'eramũ 'ga monowe'em futat kwe pe tejewi”, 'jau Abraão 'ga oje'ega 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“Nerekwaawi nipo 'ga oarũe'ema kwe katy ki sa”, 'jau 'ga 'ga upe. “Maran 'ga awau kwe katy ene pyri ki 'ei? Maran 'ga awau ikwara apyraapa ene pyri ki 'ei? Nooarũi 'auwara 'gã kwe katy. Peuwaramũ nanẽ pejejorarũme'em futat 'au nũ”, 'jau Abraão 'ga oje'ega monou 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","—A'eramũ mama'eukwaawa rapyaw ipe 'ũi ma'e 'ga 'jau Abraão 'ga upe: “Ere ajee 'ga monou jepytuna 'gã nupe, 'ga moporogytaukaa 'ũ”, 'jau 'ga 'ga upe. “Sĩku futat jerewirera 'gã. Kasi 'gã nuri je pyri ne. Ekoay je tejua te'ỹina 'au tekou tywet, e'i enereki'yra pẽ nupe, te'i 'ga awau 'gã nupe peu ywyu jeruwa 'ga rog ipe 'gã nupe 'jau”, 'jau 'ga oje'ega Abraão 'ga upe. “Kasi 'gã nuri je pyri ne”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Aipo 'ga 'eramũ Abraão 'ga 'jau 'ga upe: “Naani. Okwaap futat 'gã 'ã Moisesi 'ga remikwasiarera numiamũ. Janeruwarete 'ga je'ega mome'wara 'gã nemikwasiarera nanẽ 'ã ityp futat. Tene 'gã aipo etee erowiari”, 'jau Abraão 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Aipo 'eramũ 'ga 'jau Abraão 'ga upe: “Naani. Moisesi 'ga je'egera 'gã nuerowiari futari jepi”, 'jau etee 'ga 'ga upe. “Amanũ ma'efera 'ga je'ega te nipo 'gã werowiat. A'eramũ te nipo 'gã poiri otywer awi”, 'jau etee 'ga Abraão 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—A'eramũ Abraão 'ga 'jau 'ga upe: “Naani nũ'ũ. Moisesi 'ga je'egera renuwe'em ire 'gã amanũ ma'efera 'ga je'ega taetu nuerowiara'uweri futari. Janeruwarete 'ga je'ega mome'wara 'gã nemikwasiarera mogytau miamũ te 'gã 'ã nuerowiari. Oferap ma'e 'ga je'ega taetu 'gã nuenuwi futari nũ'ũ”, 'jau Abraão 'ga 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A'ere Jejui 'ga 'jau wemiayuwa 'gã nupe nũ: —Nateepawi futari nipo ajaupe mama'e tywera apoukaara 'gã— 'jau 'ga 'gã nupe oporogytau. —Iporiay'i aipo 'gã numiamũ. Aipo 'gã te nipo Ku'jywa 'ga wereko tywerete futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","—Sã'ã ae ita mogoa ojojuri. A'eramũ 'ã ae ojomonou ojomomoa ajajukau 'yẽ'ẽ pype nũ. 'Y pe imomoripyrera 'ga ako tywe'ri etee. Amanũ etee 'ga. A'ere nipo kunumĩ upe mama'e tywera apoukaara 'gã te Janeruwarete 'ga ereko tyweretei. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","A'eramũ pẽẽ pejejea'gwau pejejemogyau. Mama'e tywera kasi peapoukat 'gã nupe ne— 'jau Jejui 'ga oporogytau 'gã nupe. —Je rerowiaara 'ga amũ nipo mama'e tywera wapo pẽ nupe. A'eramũ ki pejeporogytau 'ga upe. “A'jea futat ako je mama'e tywera apoi ene upe ai'i. A'ere je 'awamũ naapou'jawi nũ”, pejejeupe 'ga 'eramũ pẽẽ 'ga rerekou esage etee. Pejejea'aru'jawe'emamũ futat ee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","—Majepeja 'ara rupi etee mama'e tywera pejejeupe kwaiwete 'ga iaporamũ pejewau pejeporogytau 'ga upe. “Mama'e tywera ereapo jee. A'eramũ je ene raykau tekou. Au'je ki je rayka re ekou”, pe'je ki 'ga upe pejeporogytau. “Naapou'jawi je 'awamũ”, pejejeupe 'gã 'eramũ pejejea'aru'jawe'emamũ ee. Pejepota'waramũ 'gã nee— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A'eramũ Jejui 'ga remimu'e 'gã 'jau 'ga upe: —Jejui. Ejerowiarukat oree— 'jau 'gã oje'ega 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A'eramũ Jejui 'ga 'jau 'gã nupe: —Inãinãnĩ'ĩ etee pẽẽ 'ga rerowiaa 'eramũ miamũ Janeruwarete 'ga mama'e muri pẽ nupe— 'jau 'ga oje'ega 'gã nupe. —Pẽẽ inãinãnĩ'ĩ etee Jarejuwarete 'ga rerowiaa 'eramũ miamũ peje'eg 'ywu upe. “Ejemosok ywy awi jee. A'eramũ ene ewau e'ama 'y rypyter ipe jee”, pe'je ki jupe. Janeruwarete 'ga pẽẽ erowiaramũ 'ywa sogi pẽ nupe. Peje'eg imũ etee futat awau u'ama peu pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe: —Sã'ã ae kũima'eramũ ae wemiayuwamũ monoa ko pe. Ajepejamũ 'ã awau wyra poita. A'eramũ 'ã ae kaaruwamũ 'ua ojewya oporowyky re. 'Gã nur ire sipo ijara 'ga 'gã nenũi 'gã muapyka 'gã mojemi'waa ra'ne? ");
INSERT INTO kyzNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Naani. Nanarũi. A'ere 'gã monoarera 'ga 'i etee 'gã nupe: “Je upe ra'ne mama'ea peapo. Je ra'ne je muewek pejepe. A'ere tepejemi'wat 'jau, je mueweg ire 'jau”, 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mĩnamũ futat 'gã porowykya. A'e apoawamũ futat 'ga 'gã mepyi— 'jau Jejui 'ga imome'wau 'ga nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","—Nan tee futat pẽẽ. Jarejuwarete 'ga remiapo apo re “Ore resageramũ”, pe'je kasi ne. “Ore arujara 'ga remiapoa etee aruapo”, pe'je etee ki— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusareg ipe Jejui 'ga awau. Garireja ywy 'upa Samari ywy are oje'aa etee futat. A'eramũ 'ga awau ipõ'õ rupi ");
INSERT INTO kyzNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","owaẽma amuna'wi'i mũ upe. 'Ga waẽmauwe ipito'om ma'e 'gã 'ua 'ga rowosõu. Teis 'gã 'ua 'ga rowosõu. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mukuu we 'gã 'ua opytau wafukaita Jejui 'ga upe: —Ipito'om ma'eramũ ore rekoi, aruafukaita enee. A'eramũ ene ejemuaẽma ore ree, ore mokã'jãu— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","'Gã nesakawe Jejui 'ga 'jau 'gã nupe: —Mainana 'ga upe pekwap, pejejesaukaa ra'ne— 'jau 'ga 'gã nupe. A'eramũ mainana 'ga repejãna 'gã orauwe 'gã pito'oma okã'jãu 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Esakawe 'gã 'jau ajaupe: —Tỹỹ. Jane mokã'ẽmap 'ga ra'e nũ'ũ— 'jau 'gã ajaupe. A'eramũ 'ga amũ ojewya 'gã nui. Samari ywy pewara 'ga ojewya. —Ene te 'ã eneresage oree, ki Ku'jyp— 'jau 'ga 'ua Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","'Ua 'ga wenupy'ãu wapyka Jejui 'ga rowase. —Ene te 'ã eneresage oree. Au'jete ore mokã'ẽ ape— 'jau 'ga 'ga upe. 'Ga ku'ia 'ga rerekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","A'eramũ Jejui 'ga 'jau 'ga upe: —Mytuna 'gã te je 'ã amokã'ẽ. Ma'ape ajee enepytuna 'gã ki 'ei? Maran ajee ene tee erejewyt ejua ki 'ei? Maran ajee 'gã nojewyri ene rupi 'ũ?— 'jau 'ga ojewyt ma'e 'ga upe. A'ere Jejui 'ga 'jau wewiri oo ma'e 'gã nupe: —'Agamũ Samari ywy pewara 'ga. Najanepytuna rũi agawewi 'ga. A'etea 'ga ojetee futat ojewyt 'ua oje'ega jee. Ajepeja 'gã juejue janepytuna futat numiamũ, judeu 'gã futat numiamũ. A'etea 'gã nojewyri 'ua, “Au'jete ore mokã'ẽ ape”, 'jawe'em jee— 'jau 'ga wewiri oo ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A'eramũ Jejui 'ga 'jau ojewyt ma'e 'ga upe nũ: —Ere ewau nũ. Mainana 'ga upe ekwap ejesaukaa. Je rerowiat wejue 'ã ape ra'e jepi. A'eramũ je ene mokã'jãu— 'jau 'ga 'ga upe. —Ere efu'ama. Erekã'ẽ futat ra'e— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Poje fariseu 'gã amũ 'ua oporogytau Jejui 'ga upe: —Maranime te Janeruwarete 'ga wemipyyrũmera 'ga muri imogou oree 'wyriaramũ?— 'jau 'gã 'ua oporonupa ee Jejui 'ga upe. A'eramũ Jejui 'ga 'jau 'gã nupe: —Janeruwarete 'ga remimureramũ je na'awa ywy pewara 'wyriara 'jawe rũi. Inãinã'nĩ te je rekoi 'wyriaramũ pẽ nupe— 'jau Jejui 'ga aipo 'gã nupe. —'Awa ywy pewara 'wyriaramũ te 'ã ae ojo'wyriat pãwẽ pãwẽnamũ ae rekoi. A'ere je Jarejuwarete 'ga remimureramũ je reni 'wyriaramũ tejerowiaaramũ pẽ nupe. Namajepei ywy pype tee rũi jeremiayuwamũ pejemogy. Ywy tesirũmera pype we futat jeremiayuwa 'gã jemogyi okwasi'wasi'wau najuejue etee. Na'au etee rũi te je 'ã 'wyriara. A'eramũ pẽẽ “'auwaramũ etee 'ga 'wyriaramũ janee”, 'jawe'em pejejaupe. Najuejue etee futat je rekoi 'wyriaramũ tejerowiaaramũ pẽ nupe. A'ere 'awamũ Janeruwarete 'ga remimureramũ je rekoi pẽ pype— 'jau Jejui 'ga fariseu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A'eramũ Jejui 'ga 'jau wemimu'e 'gã nupe: —Anure nipo pe'je pejejaupe. “Ma'ape te 'ga? Taesak 'ga 'jau”, 'jau nipo pẽẽ pejejaupe. A'ere nipo naje resagi pejepe. A'eramũ pẽẽ pejejemogyau je jewyra rapesaka. A'eramũ te nipo je resak pejepe najuejue etee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","—Je ruru'jawa'ne'emamũ nipo amumera 'gã 'jau pẽ nupe: “Peu futat 'ga rekoi”, 'jau nipo 'gã pẽ nupe. A'ere kasi perowiat 'gã ne. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Je ruru'jawamũ nipo najuejue etee je resak pejepe. Sã'ã tupã werawa. A'eramũ 'ã ae najuejue etee esaka. Nan tee futat nipo je jewyramũ najuejue etee je resak pejepe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","—A'ere nipo je o enune itywerete ma'e 'gã je rereko tyweretei ra'ne. Niporomutari nipo 'gã je ree. A'eramũ nipo 'gã je monou je jukaukaa 'wyriara 'ga po pe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","A'ere nipo anure je ruru'jawi erujewi pẽ nupe. Je kwaapare'ema 'gã nipo aipoa 'ara rupi ajemogyau oporowykyau. Ojemi'waa, wemirekoramũ 'jau nipo. Wemiapo apo are tee futat wea'aramũ ajemogyau— 'jau Jejui 'ga 'gã nupe u'ama. —Janeruwarete 'ga ree jẽmĩ nipo 'gã wea'are'emamũ ajemogyau. Sã'ã Nue 'ga rekoramũ 'gã jemogya rakue. Janeruwarete 'ga ree 'gã 'ã wea'are'emamũ rakue. Nan nipo 'ga ajemogyau. Poje 'ga 'ã amana mua 'gã nupe, 'gã apisaukaa jupe rakue. Nan tee futat nipo je kwaapare'ema 'gã jemogyi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Sã'ã Lo 'ga rekoramũ nanẽ 'gã 'ã iapou rakue nũ. Sodom ipewara 'gã awau kwe pe ojemi'waa ojekoty'aawa 'gã pyri. Oporowykyau akou oko tyma, amumera 'gã 'ã 'oga apou 'jau rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","A'ere 'ã ywagipewara 'gã Lo 'ga renuẽmi 'gã nui rakue. 'Ga ẽm ire Janeruwarete 'ga tata mua 'gã nupe rakue, itatata reewe rakue, ẽsõfyri 'jawa reewe rakue. Itywerete 'gã ajemogyau. Naea'ari futari 'gã Jarejuwarete 'ga ree. A'eramũ 'ã Janeruwarete 'ga 'gã apisau rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nan tee futat nipo pejemogy je ruramũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—Aipo 'ara rupi je jewyramũ nipo ko pewara 'gã ojewyre'ema futat okaraemã pyyka. Ko pewara 'gã nanẽ nipo nooi futari osou okaraemã pyyka nũ. Okaraemã are tee ea'at ma'e 'gã okaraemã reewe futat teepap. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","—Pẽnea'at Lo 'ga remireko ẽẽ manũawer are. Niporejariweri ẽẽ okaraemã are rakue. A'eramũ ẽẽ awawayayawe'em. A'eramũ ẽẽ amanũmũ rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pejekaraemã are tee ea'at ma'eramũ nepeoi futari Jarejuwarete 'ga pyri. Jarejuwarete 'ga ree ea'at ma'eramũ te peo 'ga pyri pejeferapa— 'jau 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Je jewyru'jawamũ nipo 'gã amũ ajuerosea ajuerupa. A'ere nipo 'ga amũ ẽmi ajaui. Ajepeja 'ga nipo opyta. Naje rerowiari 'ga. A'eramũ 'ga awawe'em je rupi nipo. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kũjãmera 'gã nipo 'upa mukũi ygu'ai. A'ere nipo majepeja ẽẽ oi je repejãna. A'eramũ nipo ajepeja ẽẽ te awawe'em. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","'Gã amũ nipo awau oporowykyau ko pe akou mukũi. A'ere nipo majepeja 'ga etee 'ga oi je rowosõu. Ajepeja 'ga awawe'em nipo. Je rerowiare'ema 'gã nooi je rowosõu— 'jau Jejui 'ga 'gã nupe 'gã mu'jau ojewyru'jaw are. ");
INSERT INTO kyzNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A'eramũ 'ga remimu'e 'gã 'jau Jejui 'ga upe: —Ma'ape sipo erejot poromũ ejewyr ire?— 'jau 'gã Jejui 'ga upe. —Je ruramũ te nipo pekwaap katu katu— 'jau etee 'ga 'gã nupe. —Sã'ã uruwua mama'e nema kwaawa. A'eramũ 'ã 'ua ajatykau ee. Nan tee futat nipo pẽẽ. Je jewyru'jawamũ je kwaap katu katu pejepe— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Anure Jejui 'ga 'jau wemiayuwa 'gã nupe: —Peojet kasi pejejemogyau pejeporogytau Jarejuwarete 'ga upe ne— 'jau Jejui 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A'ere 'ga mama'e mũ mome'wau 'gã nupe nũ: —Tapy'ỹja 'wyrarete pe 'wyriara 'ga amũ rekoi. 'Gã ago'o anupawe 'ga 'jau 'gã nupe: “Ene te 'ã mama'e tywera ereapo 'ga upe. A'eramũ ene te 'ga mepyau”, 'jau 'ga itywet ma'e 'gã nupe. “'Ga mepye'emamũ 'gã ene munewi ne”, 'jau 'ga 'gã nupe. Aipoa 'wyriara nopojeuwi futari Jarejuwarete 'ga. Aea nanẽ futat nopojeuwi futari nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","—Aipo amunawa pype majawera ẽẽ mũ akou. 'Wyria'ri 'ga upe ẽẽ awau 'jau: “Jekaraemã rerawarera wã nomepyi jee”, 'jau ẽẽ awau 'ga upe. “A'eramũ ene je mepyukaa wã nupe”, 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","A'ere 'ga naani. Noje'egi futari aipo 'gã nupe. A'eramũ ẽẽ ojewya 'ga ree nũ. A'ere ẽẽ ojewyru'japa 'ga ree nũ. Ojewyjewya akou 'ga ree, oporogytau 'ga upe. A'eramũ 'ga 'jau ojeupe: “Ku'jywa 'ga miamũ je 'ã napojeuwi jepi re'ã. Ae 'gã taetu je 'ã napojeuwi jepi re'ã”, 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","“A'ere pa 'ã koa majawera ẽẽ je mopiro'ysãy'sagi nũ”, 'jau 'ga ojeupe. “A'eramũ pa je ẽẽ karaemã rerawarera 'gã nupe ẽẽ karaemã mepyukaa kwy”, 'jau 'ga 'ũina ojeupe. “Kasi a'e pe ẽẽ ruru'jau'jawi 'au je marukare'ema ne nũ kwy”, 'jau 'ga ojeupe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","—Aipoa 'wyria'ri 'ga nia'wyri. Nakamẽsĩete rũi 'ga ẽẽ mepyukari 'gã nupe. A'etea 'ã pejemu'e 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aipo 'ga kũima'e 'ga nia'wyri agawewi futat. A'etea 'ga opoat ẽẽ— 'jau Jejui 'ga 'gã nupe. —Janeruwarete 'ga taetu 'ã esage futat. A'eramũ 'ga 'ã wemiayuwa 'gã poari futari. Ojeupe oporogyta ma'e 'gã ojere'emamũ 'ga 'gã poari futari. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'Ga niporomukui futari ae poaa— 'jau Jejui 'ga 'gã nupe. Aipo 'e re Jejui 'ga 'jau 'gã nupe: —Tejoru'japa sipo je tejerowiaara 'gã amũ nesagi? Je ruru'jawa poromukuran sipo 'gã jemogyi kwaiwete je rerowiaa? Kwaiwete tejerowiaara 'gã nesaga je afutat— 'jau Jejui 'ga 'gã nupe. —A'eramũ pẽẽ je rerowiaarareteramũ pejejemogyau. Jarejuwarete 'ga upe pejeje'ega pejeojere'emamũ futat pejejemogyau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A'ere 'ga mama'e mũ mome'wau 'gã nupe nũ, 'gã mu'jawamũ nũ. “Je jeresageay. Tekotee 'gã nia'wyri. A'ere 'ã je jeresage” 'jara 'gã nupe te 'ga 'i. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Mukũja kũima'e 'gã awau osou Jarejuwarete 'ga mogytaaw ipe oporogytau 'ga upe. Majepeja 'ga fariseua. A'eramũ ajepeja 'ga 'wyriara upe ka'aranũũ pyykara 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A'eramũ fariseu 'ga ojemome'wau u'ama Ku'jywa 'ga upe. “Na'gã 'jawe rũi je rekoi ene reape, ki Ku'jyp”, 'jau 'ga 'ga upe u'ama. “Amumera 'gã te aje 'ã muna'ywamũ ako ene reape. A'ere je 'ã nanarũi. Naapoa'uweri je 'ã mama'e tywera ene reape tekou, ki Ku'jyp. 'Gã 'ã nako esagei futari ene reape. A'ere 'ã je te je reko esagei ene reape”, 'jau 'ga oporogytau u'ama Jarejuwarete 'ga upe. “'Gã 'ã okou futat ajuemireko are. A'ere je 'ã nanarũi. Nokoa'uweri je 'gã nemireko are. Je 'ã na'gã 'jawe rũi futat. Kwe 'ga te 'ã 'wyriara upe oreka'aranũũ pyykara te”, 'jau 'ga, ajepeja 'ga kũima'e 'ga mome'wau u'ama Ku'jywa 'ga upe. “Nia'wyri 'ga. A'ere je na'ga 'jawe rũi. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mukũi 'ara rupi je 'ã teporogytau tekou enee ty'ara rerekou. Teka'aranũũa miamũ je 'ã imonou ene upe jepi. Teis ka'aranũũ je majepeja monou enee jepi”, 'jau 'ga u'ama oporogytau Jarejuwarete 'ga upe numiamũ. A'ere Janeruwarete 'ga nuenuwi. Ojeupe etee futat 'ga 'i u'ama— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—A'ere 'wyriara upe ka'aranũũ pyykara 'ga awau u'ama ojetee oporogytau Jarejuwarete 'ga upe. Aipo 'ga kũima'e 'ga werojenosĩ otywera enu'ama. A'eramũ 'ga a'eramũ wowowyre'emamũ u'ama oporogytau Jarejuwarete 'ga upe. “Je 'ã jetywerete tekou enee jepi. Ejemuaẽm je ree, ki Ku'jyp”, 'jau 'ga Jarejuwarete 'ga upe. A'eramũ aipo 'ga 'eramũ Janeruwarete 'ga 'ga tywera moia 'ga wi. A'eramũ 'ga a'eramũ 'ga katu'oka. Otywera renosĩarera 'ga Ku'jywa 'ga ikatu'oka. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aipo 'ga ikatu'ogipyra 'ga esage akou Janeruwarete 'ga upe. Ajepeja 'ga naani. Nia'wyri 'ga 'ga upe. Wog ipe 'gã jewyramũ 'ga remikatu'ogera 'ga etee futat wesageramũ akou 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau. —“Je jeresage” 'jara 'gã Janeruwarete 'ga nafutari. Aipo 'jara 'gã nojekatu'ogukari Jarejuwarete 'ga upe. A'ere 'ga “je 'ã jetywerete” 'jara 'gã katu'ogi. Aipo 'jara 'gã etee ojekatu'ogukat Jarejuwarete 'ga upe— 'jau Jejui 'ga 'gã nupe imome'wau u'ama, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Anure amumera 'gã wa'yra 'gã nerua Jejui 'ga upe: —Orera'yra apyte'rarimũ epo emono a'i kĩ'ĩ— 'jau 'gã erua 'ga upe. —Jarejuwarete kĩã upe eporogyta wã nee. A'eramũ Janeruwarete kĩã ojejukau esage wã nee, aru'e ore enee kĩ'ĩ— 'jau kũjãmera 'gã 'ga upe. A'ere Jejui 'ga remimu'e 'gã 'gã nesakawe 'gã 'i 'gã nupe: —Perur awi pejeja'yra 'gã 'ga upe 'ga porogyta 'ga 'amamũ. Nepemaruukari 'ga porogyta 'ga 'amamũ— 'jau 'ga remimu'e 'gã 'gã nupe. Aipo 'gã 'eramũ Jejui 'ga oje'ega wemimu'e 'gã nupe: —Naani. Peapo awi aipoa. Tene kunumĩ 'gã nuri je pyri— 'jau 'ga wemimu'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","A'eramũ futat 'ga kunumĩ'ĩ 'gã nenũina: —Pe'je pejejua je pyri— 'jau 'ga kunumĩ 'gã nupe. A'eramũ 'ga 'jau: —Janeruwarete 'ga kunumĩ 'gã afutat wemiayuwamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","—Kunumĩ 'jawewara 'gã nupe etee Janeruwarete 'ga reni 'wyriaramũ. Kunumĩ 'gã ojemogypyyk te Jarejuwarete 'ga ree. Ojerekokatuukat 'gã 'ga upe. 'Gã 'jawe pejemogyramũ 'ga pẽ katu'ogi. Kunumĩ 'jawewara 'gã etee te Janeruwarete 'ga omogy wemiayuwamũ. A'ere 'ga ojee ijemogypyyke'ema 'gã Janeruwarete 'ga nomogyi wemiayuwamũ. Nakunumĩ 'jawe rũi 'gã. A'eramũ 'ga 'gã mogyawe'em wemiayuwamũ— 'jau Jejui 'ga 'gã nupe, 'gã mu'jau ee. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A'ere judeu 'gã 'wyria'ri 'ga amũ awau oporogytau Jejui 'ga upe: —Jejui. Ene 'ã eneresage. Ma'ja te je aapo 'awamũ tejee, temanũ re ywag ipe tejesawamũ, Jarejuwarete 'ga pyri tewawamũ?— 'jau 'ga oporonupa ee 'ua Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A'eramũ Jejui 'ga 'jau 'ga upe: —Ma'eramũ “Ene 'ã eneresage” 'jau jee ejua 'ũ? Janeruwarete 'ga etee te esage ma'ea kũi. “Ene 'ã Jarejuwarete 'ga 'jawewara”, ere te jee?— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","—Ymã te 'ã Moisesi 'ga Jarejuwarete 'ga je'ega kwasiari inuga ka'aran are janee rakue. A'ea 'ã erekwaap. “Peko awi pejejuemireko are” 'ea 'ã erekwaap. “Peporojuka awi. Pemunarũ kasi mama'e are ne. Peje'ẽwu'jag kasi 'ga amũ ne. Peanuw etee ki pejejara 'gã”. Mĩmera 'ea 'ã erekwaapap— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A'eramũ 'ga 'jau Jejui 'ga upe: —Je kunumĩawe futat aipo aapopap ikue, Moisesi 'ga je'eger imũ etee futat ikue— 'jau aipoa kũima'e 'ga Jejui 'ga upe oje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","A'eramũ Jejui 'ga 'jau 'ga upe: —A'jea futat ere. A'ere 'awamũ mama'e mũ eapo. Ekaraemã eme'ẽmap. A'ere ene ka'aranũũ monou ika'aranũũe'ema 'gã nupe. Aipoa ene iapo re, Janeruwarete 'ga ene monoi ojepyri ene manũ re. Mama'e esagea te nipo 'ga amut enee anure, enekaraemã monoawera mua enee anure. Ekaraemã me'eg ire ene ejua je rewiri— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A'ere 'ga aipo ojeupe 'ga 'eramũ 'ga 'arasigamũ etee okaraemã are. Kwaiwete te 'ga karaemã. A'eramũ 'ga okaraemã me'ega futare'ema. A'eramũ 'ga 'jau ojeupe etee futat: “Naani. Naapoa'uweri je nanuara”, 'jau 'ga ojeupe etee futat. A'eramũ 'ga u'arasigamũ awau, Jejui 'ga aipo ojeupe 'eramũ awau. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","'Ga 'arasiga resakawe Jejui 'ga 'jau 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","—Ayay te ikaraemã kwai ma'e 'gã ajemogyau Jarejuwarete 'ga remiayuwamũ— 'jau 'ga 'gã nupe. —Ayay te ikaraemã kwai ma'e 'gã ojekatu'ogukaa Jarejuwarete 'ga upe. Kwaiwete 'gã karaemã. A'eramũ 'gã okaraemã are etee wea'aramũ ajemogyau. Okaraemã are etee aipo 'gã jemogypyygi akou. NaJarejuwarete 'ga ree rũi 'gã jemogypyygi ajemogyau. Jarejuwarete 'ga opoara futare'ema ajemogyau. Jeje'ega 'gã nuenuwi futari ajemogyau— 'jau Jejui 'ga 'gã nupe. —Sã'ã kawaruua 'jawewara kamerua aguja kwara rupi ikwawe'ema. Nan tee futat ayramũ ikaraemã kwai ma'e 'gã ojekatu'ogukaa Jarejuwarete 'ga upe. Ikaraemã kwai ma'e 'gã nijekatu'ogukariweri futari Jarejuwarete 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A'eramũ 'ga renupara 'gã 'jau 'ga upe: —Maranuaramũ ajee 'ga ae katu'ogi ki 'ei?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pẽ nupe nayrareferi futari. Ayay futat mama'e apoa numiamũ. A'ere nitywi futari Janeruwarete 'ga remiapoe'ema amũ mama'ea. Mama'ea naayi futari 'ga upe. Ikaraemã kwai ma'ea miamũ Janeruwarete 'ga okatu'ok, “Je katu'og ape” ojeupe 'gã 'eramũ— 'jau etee Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A'eramũ Pedro 'ga 'jau 'ga upe: —Ore ako aruejat orokaraemã arajua ene rupi ai'i. Oropytuna nanẽ futat ako ore ejaa ai'i nũ. Ma'ja te ore mama'e rejaawera repya?— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A'eramũ Jejui 'ga 'jau wemimu'e 'gã nupe: —A'jea futat ako ai'i. A'eramũ je 'jau pẽ nupe: Anure nipo Janeruwarete 'ga mama'e monoi pẽ nupe pẽnemiejarera apyraapa. Je mome'u are woga rejaarera 'gã, wemireko rejaarera 'gã, weki'yra rejaarera 'gã, wewirera rejaarera 'gã, wenyra rejaarera 'gã, ujara rejaarera 'gã, wa'yra rejaarera 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Mĩmera 'gã nupe Janeruwarete 'ga mama'e monoi. 'Awamũ futat 'ga mama'e monoi 'gã nemiejarera apyraapa. Amanũ re je ree omama'e rejaarera 'gã juejue awau ajemogyau Jarejuwarete 'ga pyri— 'jau Jejui 'ga Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Aipo 'gã nupe 'e re Jejui 'ga wemimu'e 'gã nenũina: —Pejepe'a'i 'gã nui ra'ne. Taporogyta pẽ nupe etee 'jau— 'jau Jejui 'ga 'gã nupe. A'eramũ 'gã ojepe'au mytuna 'gã nui 'ua. A'eramũ 'ga 'jau 'gã nupe: —Jerusareg ipe jane oi 'awamũ. A'eramũ je pẽ muea'aa Jarejuwarete 'ga je'ega mome'wara 'gã nemikwasiarer are— 'jau 'ga wemimu'e 'gã nupe. —Ymã te 'ã 'gã ka'arana kwasiari Jarejuwarete 'ga je'eg are rakue, “Anure tamut teja'yra 'ga pẽ nupe 'jau” 'e are rakue. “A'eramũ ia'wyre'ema 'gã jera'yra 'ga rerekou tyweaete nipo. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A'eramũ nipo 'gã 'ga monou romanũ 'wyriara 'ga po pe 'ga jukaukaa. A'eramũ nipo jefaruu 'gã 'ga kurapa, onymuna 'ga ree, 'ga nupãnupãu, 'ga monou, 'ga mu'ama 'ypeywar are 'ga jywa pypiraa 'ga manũawamũ futat”, 'jau 'ga 'gã nupe rakue— 'jau Jejui 'ga 'gã muea'aa ikwasiaripyrer are. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","—“A'ere nipo je imuapyra 'ara rupi 'ga moferawi etee nũ”, 'jau 'ã Janeruwarete 'ga 'gã nupe, ikwasiarukaa inuga rakue— 'jau Jejui 'ga 'gã muea'aa ee. A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Je 'ã pẽneki'yraretea. Janeruwarete 'ga je mut pẽ nupe. A'eramũ 'gã je ree futat poromũ ka'arana kwasiaa inuga rakue— 'jau Jejui 'ga 'ga nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A'ere 'gã nokwaawi 'ga 'ea. Naeapyoi 'gã 'ga 'e are. —Ma'ja are te 'ga jane mu'ei?— 'jau etee 'gã ajaupe. —Ma'eramũ 'ga aipo mome'wau janee?— 'jau 'gã ajaupe. —Tee. Je nakwaawi ki 'ei— 'jau etee 'gã amũ ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jeriko 'jawa amunawa upe iwaẽm ja'wyja'wyuuramũ eae'ema 'ga amũ 'ũina wapyka peyse pe: —Ka'aranũũ'ĩa pemut ape jee— 'jau 'ga 'ũina pe rupi okwap ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Peyse pe 'ũinaw ipe 'ga 'ũina wapyakau 'gã fu are. Kwaiwete 'gã fu renupa 'ũina. A'eramũ 'ga 'jau: —Awỹja te poromũ ako?— 'jau 'ga wafukaita 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Jejui 'ga ako, Nasare pe waranup ma'efera 'ga okwap akou— 'jau 'ga amũ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A'eramũ eae'ema 'ga wafukaita Jejui 'ga upe: —Jejui! Ene 'ã Davi 'ga juapyrera, Jarejuwarete 'ga remimurera! Erejemuaẽm te je ree? Epãjẽ mũ je katu'og ape, ki Jejui— 'jau 'ga wafukaita 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A'eramũ 'ga pyu okwap ma'e 'gã 'jau 'ga upe: —Epije e'ỹina kũi. Aereau toko re'ã— 'jau 'gã 'ga upe. A'ere 'ga jero'wuro'wui etee wafukaita 'ga upe: —Jejui! Ene 'ã Davi 'ga juapyrera, Jarejuwarete 'ga remimurera. Ejemuaẽm je ree. Je resag ape, a'e je enee— 'jau 'ga ojero'waro'wau etee wafukaita 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A'eramũ Jejui 'ga awau opytau pe pe. —Pe'je ajee eae'ema 'ga rerua jee— 'jau 'ga 'gã nupe. A'erauwe 'gã 'ga rerua 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ojeupe 'ga rerurauwe Jejui 'ga 'jau 'ga upe: —Ma'ja te erefutat ejeupe je iapoa?— 'jau Jejui 'ga 'ga upe. —Tamã'ẽ 'jau nũ, a'e je enee, ki Ku'jyp. Jereapap je ikue— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A'eramũ Jejui 'ga 'jau 'ga upe: —Eremã'ẽ futat nũ. Je rerowiar ape ekou ra'e. A'eramũ je ene mamã'jãu nũ— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","A'eramũ 'ga opo monou 'ga reakwara 'arimũ 'ga mamã'jãu nũ. A'erauwe 'ga amã'jãu awau Jejui 'ga rupi. —Ene te 'ã eneresage jee— 'jau 'ga Jarejuwarete 'ga upe 'ga muorypa amamã'ẽawer are. 'Ga resakara 'gã nanẽ oje'ega Jarejuwarete 'ga upe nũ: —Ene te 'ã eneresage oree— 'jau 'gã oje'ega 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jeriko 'jawa amunawa upe owaẽmawe Jejui 'ga awau amunawa pyterimũ akou. Kwaiwete 'gã awau 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A'eramũ Sakeu 'ga oporesagiweramũ Jejui 'ga ree. Sakeu 'ga ika'aranũũ kwai ma'ea. 'Wyriararete upe ka'aranũũ pyykara 'gã nupe 'ga reni 'wyriaramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'Ga poromũ iporesagiwet Jejui 'ga ree. A'ere 'ga nifukui. A'eramũ 'ga a'eramũ 'ga resake'ema. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A'eramũ 'ga awau ujãna 'ga renune awau ojeupia 'ywa rupi. Figu 'ywa rakã 'arimũ 'ga awau ojeupia 'ũina, Jejui 'ga kwapawa 'arimũ. “Ko rupi futat nipo 'ga kwawi re'ã”, 'jau Sakeu 'ga ojeupe, awau 'ũina 'ywa rakã 'arimũ 'gã nenune. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","'Ua Jejui 'ga owaẽma 'ga upe. A'eramũ Jejui 'ga amã'jãu 'ga ree. A'eramũ Jejui 'ga 'jau 'ga upe: —Sakeu. Ere ejua ejypa. Too ene rupi ene'wyr ipe 'jau— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A'erauwe 'ga 'ua ojypa. A'eramũ 'ga Jejui 'ga rerawau oje'wyr ipe. A'eramũ futat Sakeu 'ga aku'iramũ 'ga rerawau oje'wyr ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A'eramũ aipo resakarera 'gã 'jau ajaupe: —Kuu. Nokwaawi 'ga Sakeu 'ga ra'e— 'jau 'gã ajaupe. —Sakeu 'ga 'ã 'wyriararete upe janeka'aranũũ pyykara. A'eramũ 'ga ia'wyre'emamũ akou. Nia'wyri ka'aranũũ pyykara 'gã najuejue etee. Amunarũ ma'e 'gã juejue te 'ã. A'etea Jejui 'ga oo 'ga 'wyr ipe jã'nũ'ũ— 'jau 'gã Jejui 'ga ago'wau 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ojemi'war ire Sakeu 'ga 'jau Jejui 'ga upe: —Apoit je tetywer awi 'awamũ. A'eramũ je tekaraemã mojo'oka ikaraemãe'ema 'gã nupe. Amumera 'gã nui je ka'aranũũ reroouu re je ka'aranũũ monoi 'gã nupe nũ. Irũpãwẽ juejue je imonoi 'gã nupe nũ, 'gã nui eruripyrera mepyau 'gã nupe nũ— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A'eramũ Jejui 'ga 'jau wesakara 'gã nupe: —Ko 'ga kũima'e 'ga judeua futat. A'etea 'ga mama'e tywera wapo akou rai'i. A'ere 'awamũ Janeruwarete 'ga 'ga katu'ogi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","—Je 'ã pẽneki'yraretea futat. Ma'eramũ 'ã je ruri oka'jam ma'e 'jawewara 'gã nekaa tekou. Jeruwarete 'ga je'ega renupare'ema 'gã oka'jam ma'e 'jawewara futat ajemogy. A'eramũ je 'gã nekaa te tejua etee. 'Gã katu'okawamũ tejua etee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jerusarega pyri awauwe 'ga rupi oo ma'e 'gã 'jau ajaupe: —Sawaẽm ja'wyja'wy jane Jerusarega upe ra'e. 'Awamũ futat nipo 'ga rekoi 'wyriaramũ janee— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A'ere Jejui 'ga nuenuwi agawewi futat 'gã 'ea. A'etea 'ga okwaap aipo 'gã 'ea ajaupe. A'eramũ 'ga mama'e mũ mome'wau 'gã nupe, 'gã mu'jawamũ. —'Wyriararete 'ga ika'aranũũ kwai ma'e 'ga renũina. “Ere ejua 'au je pyri. Tomono ene 'wyriaramũ 'gã nupe 'jau”, 'jau 'ga oje'ega monou 'ga upe. Mukuu 'wyriararete 'ga rekoi. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","—A'eramũ 'ga oo enunewe wemiayuwa 'gã nupe oporogytau. Teis 'ga remiayuwa 'gã pytuna. A'eramũ 'ga ka'aranũũ 'ywope'i monou 'gã nupe. “Oo je teatau pẽ nui. A'eramũ je ka'aranũũ 'ywope'ia monou pãwẽ pãwẽ pẽ nupe. A'eramũ pẽẽ pejewau imomytuna jee je ruru'jawe'emauwe”, 'jau 'ga 'gã nupe, ka'aranũũ monou 'gã nupe. Oporogytapaw ire 'ga awau 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","—A'eramũ 'ga 'wyr ipewara 'gã amũ 'ga futare'ema 'wyriaramũ 'ga rekoa. “Kuu. Nia'wyri 'ga. Nifutari jane 'ga 'wyriaramũ 'ga rekoa jarejee”, 'jau 'gã ajaupe. A'eramũ 'gã 'gã amũ monou imoporogytaukaa 'wyriararete 'ga upe. “Narafutari ore 'ga 'wyriaramũ orojeupe 'ga ruwa”, 'jau 'gã oje'ega monou 'wyriararete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—A'ere 'wyriararete 'ga nomojerowiari 'gã je'ega. A'eramũ 'ga 'ga mogou 'wyriaramũ 'gã nupe. A'eramũ 'ga 'wyriaramũ omogo re 'ua ojewya oje'wyr ipe nũ. Owaẽm ire 'ga wemiayuwa 'gã nenũina. “Maran gatu nipo 'gã jeka'aranũũa rerekoi rai'i?” 'jau 'ga ojeupe. “Ika'aranũũ kwaiwete sipo 'gã nai'i?” 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","—A'ere 'ga amũ 'ua owaẽma 'ga upe nũ: “majepei'i etee agawewi ako ka'aranũũa eremut jee ikue. A'ere 'awamũ je imomytuni teis enee ai'i”, 'jau 'ga 'ga upe erua. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","—“A'jea futat. Majepei'i etee agawewi ako je imonoi enee ai'i. Ene 'ã jeremiayuw esagea futat. A'eramũ je a'eramũ ene monou teis amunawa mo'wyriaa”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—A'ere 'ga amũ 'ua nũ. “Majepei'i etee ako eka'aranũũa eremut jee ikue. A'ere je imomytuna sĩku 'awamũ ene upe”, 'jau 'ga o'wyriara 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—“A'jea. 'Awamũ je ene monoi 'wyriana'nĩnamũ sĩku amunawa mo'wyriaa”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—A'ere 'ga remiayuwa 'ga amũ 'ua nũ. “Kweramũ eneka'aranũũa. Namomyi etee je. Akyje te je ene wi. A'eramũ je iauwana taity pirera pype imima erekou muna'yw awi ai'i. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Akwaap je ene jepi. Enemara'ne 'ã ene. Ejemepya te 'ã erefutat ka'aranũũ pyu. A'eramũ 'ã ene eporowyky are jẽmĩ ejea'are'emamũ. A'eramũ je tekyjau ene wi ai'i, eneka'aranũũa momyawe'em ene wi ai'i”, 'jau 'ga 'wyriara 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—A'eramũ 'wyriara 'ga amara'neeteeteramũ 'ga ree. “Nenea'wyri futari te 'ã ene. Erekwaap futat te 'ã jemara'nea jepi. A'jea futat ere aipo 'jau jee. ‘Emepy ekoete ate te 'ã erefutat ka'aranũũ pyu. A'eramũ 'ã ene eporowyky are jẽmĩ ejea'are'emamũ’, ere ako jee ko. A'jea futat ere jee. Ka'aranũũa etee je afutat”, 'jau 'wyriararete 'ga aipo 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“Ma'eramũ sipo ene imomytune'ema jee rai'i? Je upe imomytuna ene ifutare'emamũ amunipo 'ã eremono ka'aranũũ rerekwara 'gã nupe rai'i kũi. A'eramũ amunipo 'ã 'gã jeka'aranũũ momyawera mepyau enee jee rai'i kũi”, 'jau 'wyriara 'ga aipoa kũima'e 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—A'eramũ 'ga 'jau ojepyriwara 'ga upe: “Ere ka'aranũũ pyyka 'ga wi. Imonou teis ka'aranũũ pyykarera 'ga upe”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—A'eramũ 'ga 'jau 'wyriara 'ga upe: “Naani kũi. Kwaiwete 'ga ma'ea kũi. Teis 'ga ma'e pytuna kũi”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—A'eramũ 'ga 'jau 'ga upe: “A'jea futat. Ereko esageara 'gã opyygu'jap futat nũ”, 'jau etee 'ga 'gã nupe. “Ereko esage'emara 'gã te ajee nuerekoi futari. Erekopyrera miamũ futat 'ga erekowe'em”, 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","—A'ere 'ga 'jau 'gã nupe nũ: “A'eramũ pẽẽ 'awamũ je ree iporomutare'ema 'gã nerua iapisaupap 'au je rowase. Narafutari ore 'wyriaramũ 'ga rekoa 'jarera 'gã nerua iapisau je rowase”, 'jau 'ga 'gã nupe— 'jau Jejui 'ga imome'wau 'gã nupe, 'gã mu'jawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aipo mome'upaw ire Jejui 'ga watau wemiayuwa 'gã nenune. A'eramũ futat 'gã awau 'ga rewiri. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","A'eramũ 'gã awau owaẽma ywytyra upe. Oriweira 'jawa upe owaẽma. Kwaiwete aipoa 'ywa oriweira 'jawa peu. A'eramũ 'gã a'eramũ ywytyra renũina, Oriweira 'jau jupe. Mukũja amunawa 'upa aipoa ywytyra pyri. Pefaje, Petani. Mĩmera amunawa 'upa ywytyra pyri. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","A'eramũ Jejui 'ga 'jau wemimu'e 'gã amũ nupe, mukũja 'gã nupe: —Pe'je pejewau pejekwapa je renune pejewau pejewaẽma iruupeuwara amunawa upe. Pejesouwe nipo pẽẽ kawaru'i mũ resaka. Nuatai we 'gã amũ i'arimũ. A'ea ki perut iamoia jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","—“Ma'eramũ te peko ee?” pejejeupe 'gã 'eramũ ki “Janejara 'ga te e'i oree ko: Kawaru'ia perut jee ra'ne, e'i 'ga oree ko. A'ere nipo 'ga ko'iko'i ete imuri pẽ nupe nũ”, pe'je ki 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A'eramũ 'gã awau kawaru'i resaka. 'Ga je'eg imũ etee futat 'gã kawaru'i resaka. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kawaru'i amoiramũ, ijara 'ga 'jau 'gã nupe: —Ma'eramũ pẽẽ pejekou ee ki 'ei? Ma'eramũ pẽẽ iamoia ki 'ei?— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A'eramũ 'gã 'jau 'ga upe: —Janejara 'ga te e'i oree ko: “Kawaru'ia pekwap amũ rerua jee ra'ne”, e'i 'ga oree ko. A'ere nipo 'ga ko'iko'i ete imuri nũ— 'jau 'gã 'ga upe. —A'jea. Pe'je ajee erawau 'ga upe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A'eramũ 'gã erawau Jejui 'ga upe. A'ere 'gã amũ opiara mososoka imonou kawaru'i 'arimũ Jejui 'ga upe. A'ere 'gã kawaru'i pyyka Jejui 'ga upe 'ga apykawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A'eramũ Jejui 'ga awau Jerusareg ipe kawaru'i 'arimũ. A'ere 'ga rupi oo ma'e 'gã awau ujãna 'ga renunewe opiara mososoka, imonou pe rupi imogyau 'ga kwapawamũ. 'Ga ree oporomutaawa resaukaawamũ 'gã iapou. Ymã 'gã aipo apou 'wyriararete upe rakue, 'ga ree opojejuka resaukaawamũ rakue. A'eramũ 'gã a'eramũ iapou Jejui 'ga upe. —'Ga nipo ako 'awamũ 'wyriaramũ janee— 'jau 'gã ajaupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","38","Ywytyra awau wããpyramũ Jerusarega upe. Jerusarega 'upa ywytyray 'arimũ. Jerusarega rerowykawe 'gã ajatykau wafukaita ajaupe: —Janeruwarete 'ga esage futat ra'e. Koromũ futat Jejui 'ga, Janeruwarete 'ga remimurera 'ga. Kwaiwete 'ga 'gã moferawi. Mama'eukwaawa rerekwara 'gã nanẽ 'ga okatu'ok nũ— 'jau 'gã ajaupe wafukaita. —A'ea ore aruesak ai'i. Janeruwarete 'ga 'ã ene mua— 'jau 'gã ajaupe. Kwaiwete 'gã awau Jejui 'ga repejãna. A'eramũ 'gã a'eramũ awau akou meewei. A'eramũ 'gã amũ 'jau 'ga upe wafukaita: —Ene 'ã Janeruwarete 'ga remimurera. Ene ree 'ã Janeruwarete 'ga ta'waramũ akou oree. Ywagipewara 'gã najuejue etee opy'ata'waramũ ajemogyau nũ. 'Ga te 'ã ene mut ore'wyriarareteramũ. Ene 'ã eneresage ekou oree. A'eramũ ene 'awamũ ekou 'wyriarareteramũ oree— 'jau 'gã 'ga upe. A'ere 'gã amũ 'jau Jarejuwarete 'ga upe: —Ene te 'ã eneresage oree jepi. Ene 'ã Jejui 'ga eremut oree. Eneje'eg imũ futat 'ga ruri. Nitywi futari 'ga amũ ene 'jawe— 'jau 'gã Jarejuwarete 'ga upe, 'ga muorypa Jejui 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A'eramũ fariseu 'gã amũ 'jau Jejui 'ga upe: —Jejui! “Aipo pe'je awi”, ere 'gã nupe. Jarejuwarete 'ga upe te aipo jane 'i jepi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A'eramũ Jejui 'ga 'jau 'gã nupe: —Naani. 'Gã je'ege'em ire amunipo 'ã itaa we futat ije'egi jee je muorypa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusarega pyri katu katu awauwe Jejui 'ga amã'jãu amunaw are. A'eramũ 'ga u'arasigamũ. A'eramũ futat 'ga ajaa'wau. “Jerusareg ipewara 'gã Jeruwarete 'ga je'ega renupare'ema”, 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Je 'ã ae katu'okara futat. Je 'ã Jarejuwarete 'ga mota'waara pẽ nupe. Je rerowiaramũ nipo 'ga ota'waramũ akou pẽ nupe. Aipo pẽẽ ikwaawa je afutat numiamũ. A'ere 'ã nepekwaawi futari. Ikwaaw ire amunipo 'ã ia'wyre'ema 'gã nepẽ nereko tyweri— 'jau 'ga amã'jãu Jerusareg are. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","—A'ere 'ã Jerusareg ipewaramũ nepẽporomutari je ree. A'eramũ nipo ia'wyre'ema 'gã anure 'ua pẽ'wyra osõu pẽ nee. A'eramũ nipo pẽẽ mũ pejeka'jame'ema futat. Tujugeyra pyu pẽ osõu. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A'eramũ nipo 'gã pẽ'wyrarete mateepapa pẽ nui— 'jau 'ga 'ũina. —Pẽẽ nanẽ futat pẽ apisaupap katu katu nũ. Nepeka'jami futari nipo pẽẽ mũ. Kunumĩaky'ria we futat nipo 'gã wapisipap katu katu. Pẽnoga we futat etyka nipo pẽ nui. Iku'jo'joka pẽ nui imuãmuãina pẽ nui. Janeruwarete 'ga 'ã je mut ae katu'oka. A'ere 'ã nepẽporomutari je ree. A'eramũ 'awamũ mama'e tywera ojeapou pẽ nupe— 'jau 'ga 'ũina amã'jãu 'gã 'wyr are. A'eramũ futat 'ga ajaa'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","'Gã 'wyrarete upe owaẽmawe Jejui 'ga ojypa kawaru'i awi. A'eramũ 'ga awawayayau osou Jarejuwarete 'ga mogytaaw ipe. Irãã'ã wyra me'egara 'gã nuwamũ. A'eramũ Jejui 'ga amara'neramũ 'gã nee: —Pe'je pejewau peje'jãu 'aw awi. Nawyra me'egawa rũi te 'ã. Jeruwarete 'ga mogytaawa te 'ã 'oga— 'jau 'ga wyra me'egara 'gã nupe, 'gã karaemã muãina, 'gã neymawa mopyamãu 'gã nui. A'ere 'ga 'jau 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Ymã te Janeruwarete 'ga oje'ega kwasiarukari 'gã nupe rakue. “Jemogytaawa 'og ipe 'gã nuri oporogytau jee”, 'jau 'ga ka'arana kwasiarukaa rakue. 'Au futat Janeruwarete 'ga mogytaawa 'oga. 'Au futat jane ruri jareporogytau 'ga upe. A'ere 'ã pemỹi pejemunarũawamũ ete. Pejejeymawa etee 'ã pẽẽ erua ime'ega erupa 'au. “Pe'je pejejua jereymawa mua iapyau Jarejuwarete 'ga upe”, 'jau 'ã pẽẽ 'gã nupe pejejupa. A'ere 'ã pemepyuukat pejejaupe epy apyraapa. Pejemunarũmũ 'ã pejejupa pejejoka'aranũũ are— 'jau Jejui 'ga oje'ega moywyrafena 'gã nupe. —A'eramũ pẽẽ pejewau 'aw awi peje'jãu— 'jau Jejui 'ga 'gã nupe, amara'neramũ 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","A'eramũ Jejui 'ga awau ai'iwe ai'iwe 'jau, 'ga awau 'gã mu'jau Jarejuwarete 'ga mogytaaw ipe. Kwaiwete 'ga ree iporomutare'ema 'gã. Mainana 'wyriara 'gã, Moisesi 'ga remikwasiarer are moromu'jara 'gã, 'wyria'ri 'gã. Mĩmera 'gã amara'neramũ 'ga ree. 'Ga juka are 'gã afueweramũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","A'ere 'gã najukaarũi 'ga. Kwaiwete wejue Jejui 'ga ree iporomutat ma'e 'gã jemogyi. A'eramũ 'gã okyjau 'gã nui, 'ga juka ekoete awi. Nokoi wejue Jejui 'ga tesirũgatu 'gã nupe. A'eramũ 'gã a'eramũ 'ga jukawarũe'em. —'Ga ree janereko ekoeteramũ 'ga ree iporomutat ma'e 'gã jane apisi ne— 'jau 'ga ree imara'ne ma'e 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","'Uwarete 'ga mogytaaw ipe Jejui 'ga akou 'gã mu'jau 'ga ree: —Pejetywer awi pẽpoiriweramũ Janeruwarete 'ga pẽ katu'ogi futari, pẽ mogyau wemiayuwamũ— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","A'e pype mainana 'wyriara 'gã 'ua oje'ega Jejui 'ga upe Moisesi 'ga remikwasiarer are moromu'jara 'gã netee, judeu 'gã 'wyria'ri 'gã. Mĩmera 'gã 'ua oje'ega 'ga upe: —Awỹja rer imũ te erejot rakue? Awỹja pãjẽ mũ te mama'ea ereapo? Awỹja te ene mut oree rakue?— 'jau 'gã 'ua oporonupa ee Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A'eramũ Jejui 'ga nanẽ 'jau 'gã nupe nũ: —Pe'je ajee pẽẽ na'ne imome'wau jee 'ũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Awỹja je'eg imũ ajee Juã Batista 'ga ruri ae pymĩãu 'y pe rakue 'ũ? Jarejuwarete 'ga je'eg imũ te 'ga ruri rakue? Kũima'e 'ga amũ je'eg imũ te ra'u nũ?— 'jau Jejui 'ga oporonupa ee 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A'eramũ 'gã 'jau ajaupe: —Ma'ja sa'e te jane 'ga upe?— 'jau 'gã ajaupe etee futat. —“Jarejuwarete 'ga je'eg imũ 'ga ruri” ojeupe jane 'eramũ te 'ga “te a'etea neperowiari 'ga” 'ga 'i janee nũ a'i kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","—“Kũima'e 'ga je'eg imũ 'ga ruri”, 'ga upe jane 'eramũ nipo tekotee 'gã jane apisi ete ita pyu nũ'ũ. “Juã 'ga Jarejuwarete 'ga je'ega mome'wara futat janee” e'i 'gã jepi. A'eramũ nipo 'gã aipo jane 'eramũ amara'neramũ jane ree ne nũ a'i kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","A'eramũ 'gã 'jau Jejui 'ga upe: —Norokwaawi ore Juã 'ga muarera 'ga nũ'ũ— 'jau 'ga o'meramũ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A'eramũ Jejui 'ga nanẽ 'jau 'gã nupe nũ: —Je nanẽ temuarera 'ga namome'ui futari pẽ nupe nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Peapyaka jeje'eg are. Mama'e mũ je amome'u pẽ nupe, pẽ mu'jawamũ ee, pẽ mueapyou ee— 'jau 'ga 'gã nupe. —Kũima'e 'ga amũ y'wa 'ywa rakã otym. Kwaiwete uwa 'jawa 'ywa rakã 'ga otym oko pe. A'eramũ ijara 'ga 'gã amũ monou uwa ko raaranamũ ojeupe. “Y'wa mũ jema'ea futat. Emyreramũ te ajee pẽma'e futat pẽporowykyawera repya futat”, 'jau ijara 'ga 'gã nupe. A'ere 'ga awau watau 'gã nui. A'eramũ 'ga namutamutat akou muku 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uwa atyarama upe iwaẽmauwe ijara 'ga wemiayuwa 'ga amũ monou oma'e uwa 'a piaramũ. A'ere ko raarana 'gã 'ga nupãnupãi etee 'ga monou 'ga mojewya. Nan etee futat 'ga monou. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aipo 'ga waẽm ire ko jara 'ga 'ga amũ monou nũ, oma'e piaramũ 'ga 'ga monou numiamũ. A'eramũ 'ga awau owaẽma uwa ko pe. “Uwa pemut amũ jee, e'i ijara 'ga pẽ nupe”, 'jau 'ga iaarana 'gã nupe. A'ere 'gã nãnẽwẽjẽmĩ 'ga rerekoi nũ. 'Ga pyygi etee 'ga nupãnupãu 'ga rerekou nũ. A'erauwe 'ga ojewya awau nũ. “Namuri etee 'gã amũ jee ki 'ei. Je nupãnupã etee 'gã je mua je mojewya nũ ki 'ei. Ene agawewi ako je mono ape ai'i. A'etea 'gã nojepojeuwi etee ki 'ei”, 'jau 'ga 'ua ijara 'ga upe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","—A'eramũ 'ga 'ga amũ monou nũ. A'ere 'gã nãnẽwẽjẽmĩ 'ga rerekoi nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","A'eramũ ko jara 'ga 'jau ojeupe: “Ma'ja ajee je aapo 'gã nupe 'ũ? Teja'yra 'ga pa je omono nũ kwy”, 'jau 'ga ojeupe. “Jera'yra 'ga nã'ã jeremifutararetea re'ã. A'etea pa je 'ga omono 'gã nesaka kwy. 'Ga nipo 'gã opojeup re'ã. Jera'yra 'ga ree nipo 'gã pojyramũ re'ã”, 'jau nipo 'ga ojeupe— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","—A'ere nipo 'gã 'ga ra'yra 'ga resakawe 'gã 'i ajaupe: “Wa'yra 'ga 'ga amut y'wa piaramũ ra'e. 'Ga futat 'uwa 'ga py'rau ko jaramũ 'uwa 'ga manũ re. A'eramũ jane 'ga jukau jui. A'eramũ janema'ea futat koa 'ga ruwa 'ga manũ re”, 'jau nipo 'gã ajaupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","—A'eramũ 'gã 'ga pyyka 'ga rerawau enuẽma ko awi 'ga jukau— 'jau Jejui 'ga imome'wau 'gã nupe. A'eramũ Jejui 'ga 'jau 'gã nupe: —Maran sipo ko jara 'ga wa'yra jukaarera 'gã nerekoi? ");
INSERT INTO kyzNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","'Ga futat oo ko raarana 'gã apisau. A'ere nipo 'ga 'gã amũ monou 'gã py'rau oko raaranamũ nũ— 'jau 'ga 'gã nupe imome'wau. A'eramũ aipo renupara 'gã 'jau 'ga upe: —A'jea futat sipo 'gã 'ga ra'yra 'ga jukai?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","A'eramũ Jejui 'ga 'jau: —Ymã te 'ã Janeruwarete 'ga oje'ega kwasiarukari 'gã nupe rakue. Je ree futat 'gã ka'arana kwasiari rakue. “Mĩa ita nia'wyruui ra'e, 'jau nipo itaoga apoara 'gã ajaupe, ita monou imomoa ajaui. A'ere 'ga amũ aipoa ita eroyrũmyrera ita pyygi etee imonou imỹina tenawera pype 'oga ypywotypawamũ”, 'jau 'gã ka'arana kwasiaa je ree rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","—'Ga amũ nipo u'aa ita 'arimũ. A'e 'ga open futat. A'ere 'ga amũ 'arimũ ita 'ar ire a'e 'ga ku'jo'jogi futari. Nan tee futat Janeruwarete 'ga oje'ega renupare'emamũ iapoi pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'gã, mainana 'wyriara retee amara'neramũ Jejui 'ga ree. —Jane upe futat nipo ajee 'ga 'i u'ama— 'jau 'gã ajaupe. —Pe'je ajee sipyyk 'ga 'ũ— 'jau 'gã ajaupe. A'ere 'gã kyjei etee Jejui 'ga ree iporomutat ma'e 'gã nui. A'eramũ 'gã 'ga pyyke'ema. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A'eramũ 'gã 'ga rerekou weape etee. 'Gã amũ 'gã imepyau imonou 'ga rewiri 'ga resakawamũ: —Pe'je pejewau 'ga renupa pejejemogyau— 'jau 'gã 'gã nupe. A'eramũ 'gã awau 'ga rewiri akou 'ga renupa. —Tepeenup 'ga 'wyriararete 'ga kurawa 'jau— 'jau 'gã 'gã nupe. —'Wyriararete 'ga kurawamũ sipyyk 'ga 'jau. A'eramũ 'wyriara 'ga 'ga jukaukaa janee 'jau— 'jau 'gã aipo 'gã nupe, 'ga rewiri imonopyra 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","A'eramũ imepypyra 'gã awau oporonupa ee 'ga upe: —Jejui. A'jea futat 'ã ereporogyta esage. Nereporogyta ekoetei 'ã ekou. A'jea futat 'ã erejejuka pãwẽ pãwẽ ore ree. A'jea futat te ore mu'e ape mama'e are— 'jau 'gã Jejui 'ga upe oporonupa 'me ee. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","—A'eramũ ene 'awamũ 'jau oree. Jane 'ã judeua. Simono te jane ka'aranũũa 'wyriararete 'ga upe? Naani te ra'u nũ? Najudeu arũi te 'ã 'wyriararete 'ga. Tapy'ỹi amuteea 'ga. Romanũa te 'ga. A'etea te jane simepy 'ga?— 'jau 'gã oporonupa 'me Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","A'ere Jejui 'ga 'gã kwaawi ojee. “Jeje'ega renupa 'gã nuri numiamũ. Siesak 'ga 'wyriararete 'ga kurawa 'jau, e'i 'gã jee numiamũ”, 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","A'eramũ 'ga 'jau 'gã nupe: —Ka'aranũũ 'ywope'ia pemut amũ jee ra'ne, Sesa 'ga mepyawa mũ ra'ne— 'jau 'ga 'gã nupe. A'eramũ 'gã amũ imonou 'ga upe: —Kweramũ ajee 'wei— 'jau 'gã imonou 'ga po pe. A'eramũ 'ga esaukaa 'gã nupe: —Awỹja ra'agawa te 'up ee? —'Wyriararete 'ga ra'agawa 'up ee!— 'jau 'gã 'ga upe. —Awỹja rera ajee 'awamũ ojekwasiat 'upa ikupe katy nũ?— 'jau 'ga esaukaa 'gã nupe. —'Wyriararete 'ga rera futat 'up ee— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—'Ga ra'agawa rerekwara 'ga ma'ea futat. A'eramũ pẽẽ imonou 'ga upe etee futat. A'ere Jarejuwarete 'ga mama'ea pemono 'ga upe etee futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A'eramũ 'ga upe ee oporonup ma'efera 'gã oporesagamũ etee 'ga ree: —Kuu. I'akwaap 'ga ra'e nũ'ũ. Nakurawi futari 'ga 'wyriararete 'ga janee jã'nũ'ũ— 'jau 'gã ajaupe. A'eramũ 'gã ajemogyau etee futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ko'iko'i ete satuseu 'gã amũ 'ua oporogytau Jejui 'ga upe nũ. Aipo 'gã e'i ajaupe: “Amanũ re ae noferawu'jawi. Amanũmũ ae teepawamũ ywawuje futat”, 'jau agawewi satuseu 'gã ajaupe jepi. A'etea 'gã 'ut imome'waukaa Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","A'eramũ 'gã 'jau 'ga upe: —“Moromu'jara 'ga” e'i 'gã enee jepi. A'eramũ ene ore mueapyo katuu mama'e are. Ymã te 'ã Moisesi 'ga ka'arana kwasiari inuga janee rakue. “Kũima'e 'ga amũ nipo amanũ wa'yre'emauwe. A'eramũ nipo 'ga manũ re 'ga rewirera 'ga 'ga remirekofera ẽẽ rerekou nũ. A'eramũ nipo 'ga wa'yramũ ẽẽ pype. A'ere nipo 'ga ra'yr ypya amanũ ma'efera 'ga ra'yrera 'jawe futat”, 'jau Moisesi 'ga ikwasiaa inuga rakue— 'jau 'gã Jejui 'ga upe. A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A'eramũ 'gã oporogytau'japa nũ: —Kũima'e 'ga amũ nipo 'ga ra'yra sete. A'eramũ nipo u'ar ypy ma'efera 'ga kũjã mũ rerekou. A'ere nipo 'ga wa'yre'emauwe 'ga manũi jui. A'eramũ 'ga wemireko ẽẽ rejaa wewirerera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A'eramũ nipo 'ga manũ re 'ga rewirerera 'ga amũ ẽẽ rerekou 'ga py'rau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ojopy'rapy'rau etee 'gã ẽẽ ree, ajamanũ re. A'ere 'gã nata'yri'i futari ẽẽ pype. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ojee 'gã jomoypaw ire ẽẽ nanẽ amanũmũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A'eramũ nipo 'ga ae moferapawa 'ara rupi manamũ sipo ẽẽ menaretea?— 'jau 'gã Jejui 'ga upe. —'Gã juejue futat ẽẽ wereko kũi— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A'eramũ Jejui 'ga 'jau 'gã nupe: —'Au etee te 'gã nemirekoramũ kũi. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","A'ere oferap ma'e 'gã nuerekou'jawi kũjãa. Niporerekoweru'jawi 'gã kũjã are. Kũjãmera 'gã nanẽ omenariwere'emamũ futat nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","—Ywagipewara 'gã 'jawe futat 'gã jemogyi amanũu'jape'ema futat. Janeruwarete 'ga 'gã omoferap imogyau nũ. A'eramũ 'gã a'eramũ 'ga ra'yramũ futat ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ymã te 'ã Moisesi 'ga jane mu'ei ae feraw are rakue— 'jau Jejui 'ga 'gã nupe. —“Ka'a'ia je upe imueny re Janeruwarete 'ga oje'ega jee ikue: Je 'ã Eneruwaretea, 'jau 'ga oje'ega jee ikue”, 'jau Moisesi 'ga imome'wau rakue. “Je te 'ã Eneruwaretea. Enepytuna 'gã Nuwaretea je. Abraão 'ga, Isaki 'ga, Jako 'ga. Mĩmera 'gã Nuwaretea je ako, 'jau 'ga jee ikue”, 'jau Moisesi 'ga ka'arana kwasiaa inuga janee rakue— 'jau Jejui 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","—Aipo 'gã amanũ futat rakue numiamũ, Moisesi 'ga tywe'emauwe futat rakue numiamũ. A'ere 'gã 'aga namanũi futari. Ateepawe'emamũ futat 'gã 'aga. A'eramũ Janeruwarete 'ga poromũ 'jau Moisesi 'ga upe. 'Gã 'aga tywe'em ire amunipo 'ã 'ga aipo ne'ia'uweri Moisesi 'ga upe. Ako ma'e 'gã nupe etee te 'ga ae ruwamũ— 'jau Jejui 'ga 'gã nupe u'ama imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A'eramũ Moisesi 'ga remikwasiarer are moromu'jara 'gã amũ 'jau 'ga upe: —A'jea futat— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A'ere amumera 'gã noje'egi futari ajemogyau. Ojenosĩ 'gã 'ga wi. A'eramũ 'gã oje'ege'ema futat 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","A'eramũ Jejui 'ga 'jau 'gã nupe: —Maran sipo ajee Ku'jywa 'ga remimurera 'ga Davi 'ga juapyreramũ wẽjẽmĩ 'ga rekoi nũ? Ymã te Davi 'ga manũi rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Davi 'ga futat ka'arana okwasiat inuga janee rakue, Saumu 'jawa ka'aran are 'ga ikwasiari inuga janee rakue: “'Ga te eteetea. Janeruwarete 'ga 'jau Jejararete 'ga upe: ‘Eapyk 'au je pyri. Je 'jawe futat ene. Enepãjẽretea je 'jawe. A'eramũ ene eapyka je yse katy. Anure nipo je ene mogoi 'wyriaramũ 'gã nupe najuejue etee. Ene ree iporomutare'ema 'gã 'arimũ je ene magwawukari. A'eramũ ene je iapoe'emauwe eapyka 'au je yse katy’, 'jau 'ga Jejararete 'ga upe ai'i”, 'jau Davi 'ga ikwasiaa rakue— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","—Janeruwarete 'ga remimurera 'ga ree 'ga ka'arana kwasiari rakue. Ma'eramũ sipo ajee Davi 'ga 'i “Jejararete 'ga”, 'jau ajuapyrera 'ga upe nũ?— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mytuna 'gã ajemogyau Jejui 'ga porogyta renupa. A'ere 'ga ojerowaka oje'ega wemimu'e 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Pejea'gu ki Moisesi 'ga remikwasiarer are moromu'jara 'gã nui— 'jau 'ga 'gã nupe. —'Gã 'ã e'i ojeupe: “Je kũima'eeteetea”, e'i 'gã 'ã ojeupe ajemogyau, waity fuku rerekou. A'eramũ 'gã ataramũ 'gã naitya ajasimana 'gã nee. “Tiporesag ete 'gã je ree 'jau”, 'jau 'gã akou ojeupe. Wapeje'ega tãmẽjẽ 'gã ifutaa. 'Wyriara apykawa 'arimũ etee wapyka awau pejejatykaaw ipe. Ojemi'waaw ipe nanẽ nũ 'wyriara renawa 'arimũ etee wapygiweramũ ojemi'waa— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","—Kũjã men manũ ma'e 'gã nupe nanẽ 'gã 'jau: “Je tamaenun tekou enekaraemã are 'jau”, 'jau futatee 'gã 'gã nupe. “Je tareko esage enekaraemã enee 'jau”, 'jau futatee 'gã 'gã nupe. A'ere 'ga etee 'gã karaemã pyygi ojeupe, ka'aranũũa nanẽ nũ. A'eramũ 'gã 'jau ojeupe etee futat: “Kwakwai'i teje'ega monoi Jarejuwarete 'ga upe. Kasi a'e pe 'gã je kwaawi mama'e tywera je iaporamũ ne kwy”, 'jau 'gã ojeupe etee futat. A'eramũ nipo 'gã oje'ega monou fukuu 'me futat Jarejuwarete 'ga upe, wemiapo tywera mimawamũ. A'ere nipo anure Janeruwarete 'ga 'gã nereko tyweri 'gã nemiapo tyweawer are— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jarejuwarete 'ga mogytaawa pype 'ũinaw ipe Jejui 'ga ose ma'e 'gã nesaka 'ũina. Ika'aranũũ kwai ma'e 'gã ka'aranũũ monou yrũ pype Jarejuwarete 'ga upe kwaiwete. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","'Gã nesepaw ire majawera ẽẽ mũ 'ua osou 'og ipe. Nika'arani ẽẽ akou. Itywerete ẽẽ akou. A'etea ẽẽ oka'aranũũ ywope'i omono ipype. Mukũi'ĩ etee ẽẽ imonou ipype. Naepyi agawewi ẽẽ remimonofera. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Ẽẽ resakawe Jejui 'ga 'jau ojeupi oo ma'efera 'gã nupe: —Kweramũ kũjãa ẽẽ imen manũ ma'efera ẽẽ. Nitywa'uweri agawewi ẽẽ mama'ea. A'etea ẽẽ oka'aranũũ monoupap futat yrũ pype. A'eramũ ẽẽ otywe'emamũ futat mama'ea ojeupe imuawamũ. Ẽẽ remimonofera ika'aranũũ kwai ma'e 'gã ma'e wapyraap futat Janeruwarete 'ga upe. 'Gã kwaiwete agawewi omono 'ga upe. A'etea 'gã kwaiwete wẽjẽmĩ wereko ojeupe nũ. A'ere ẽẽ ma'ea nitywi futari. Omonopap futat ẽẽ 'ga upe. Naemyreri futari ẽẽ upe. Wemi'urama muawa we futat ẽẽ omonopap 'ga upe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anure Jejui 'ga rewiri oo ma'e 'gã 'jau: —Kuu. Ikaturam te Janeruwarete 'ga mogytaawa 'oga jã'nũ'ũ— 'jau 'gã ajaupe. —Sã'ã ita esagea. Mytuna 'gã ka'aranũũ momỹi Jarejuwarete 'ga mogytaawa 'oga apoawamũ— 'jau 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","A'eramũ Jejui 'ga 'jau: —A'jea futat esageramũ numiamũ. A'ere nipo anurenure'i jane ree iporomutare'ema 'gã nuri imonou etyka. Nomỹi'i futari nipo 'gã itaa mũ aju'arimũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","A'eramũ 'gã 'jau 'ga upe: —Maranime sipo aipo 'gã Jarejuwarete 'ga mogytaawa monoi etyka? Ma'ja ra'ne sipo ajee ojesaukat oree iapo enune?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A'eramũ Jejui 'ga 'jau 'gã nupe: —Je renune 'ut ma'e 'gã nipo i'me ma'ea. Perowiat kasi 'gã 'mea ne. Anure nipo kwaiwete 'gã nuri, “Janeruwarete 'ga je mut pẽ katu'okaramũ”, 'jau nipo 'gã 'ua pẽ nupe. A'ere kasi perowiat 'gã ne. “O'meramũ 'gã 'i”, pe'je etee ki 'gã nupe. Kwaiwete nipo 'gã 'gã moryteeu ojee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","—Anure nipo amutee amunaw awi 'gã nuri 'wyriararete rowajaa 'ga remiayuwa 'gã neewe futat. A'ere kasi aipo renupa pekyje ne. Nan futat nipo teepaw enune. A'ere nipo naporomũ rũi imateepaawa. Naporomũ etee rũi futat nipo mama'e rekoi— 'jau Jejui 'ga 'gã nupe. —Akou'jau'jap futat nipo mama'ea. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Amunap tesirũmera pypewara 'gã we futat nipo ajuowajat. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A'eramũ nipo jero'wua ojeupa kwaiwete. Ywya we futat nipo oyyi peu peu peu 'jau. Amumera 'gã nipo opapa kwaiwete ty'ara rerekou. Ywag ipe nanẽ nipo mama'e mũ ojesaukaa pẽ mogyjawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Jeremiayuwamũ nipo 'gã amũ pẽ nereko tyweretei. Pẽ monou nipo pẽ munepa pẽ mu'ama moromunepawa pype. Teepaw enune nipo 'gã pẽ monoi pẽ munepa pẽ mu'ama moromunepawa pype. Pẽ pyyka nipo 'gã pẽ nerawau judeu 'gã jatykaaw ipe pẽ moporogytaukaa. Amumeramũ nipo 'gã pẽ nerawau 'wyriara upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'Wyriararete upe pejejerooramũ ki pẽẽ je mome'wau 'gã nupe. “Jejui 'ga iporokatu'ogiwet pẽ nee”, 'jau ki pẽẽ 'wyriara 'gã nupe, moromunepawa pypewara 'gã nupe. Mĩmera 'gã nupe ki je mome'wau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","—A'eramũ “Ma'ja 'jau sipo je teje'ega 'gã nupe 'wei”, pe'je kasi ne. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Je te 'gã nupe peje'egawa amut pẽ nupe peu pẽ nerooramũ— 'jau Jejui 'ga 'gã nupe. —A'eramũ 'gã “i'me 'ga ra'e”, 'jawe'em pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pẽpytuna 'gã we futat nipo pẽ mono amũ ia'wyre'ema 'gã po pe, pẽ munewukaa. Pẽjara 'gã, pẽnewirera 'gã, pẽneki'yra 'gã, pẽjekoty'aawa 'gã. Mĩmera 'gã miamũ nipo pẽ monou ia'wyre'ema 'gã nupe pẽ munewukaa. A'eramũ nipo 'gã pẽẽ mũ jukau futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Je rerowiaara 'ã pẽẽ. A'eramũ nipo je rerowiare'ema 'gã najuejue etee futat oporomutare'emamũ pẽ nee. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","A'ere nipo je nopoiri futari pẽ nui. Tejejukau esage etee pẽ nee. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","A'eramũ ki pẽẽ je rerowiaa pejejemogyau. Pejepoire'ema futat je rerowiar awi. A'eramũ pẽẽ pejemanũ re pejewau ywag ipe je pyri— 'jau Jejui 'ga oporogytau 'ũina 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Anure nipo pẽ nee iporomutare'ema 'gã nuri Jerusarega osõu. Aipo resakawe ki pe'je pejejaupe: “'Awamũ nipo 'ã 'gã Jerusarega retygi 'ja”, 'jau ki pẽẽ pejejaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A'eramũ ki pẽẽ Judeja ywy pe ako ma'eramũ 'gã nesakawe pejeka'jama pejewau ywytyr ipe. Jerusareg ipe ako ma'eramũ nanẽ pẽẽ pejeka'jamayayau jui. Jũ me ako ma'eramũ pejewawe'em Jerusareg ipe. Jerusareg awi ki peka'jamap futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","—Jefaruua Jerusarega upe iwaẽmauwe futat ki pe'je pejejaupe “owaẽm Janeruwarete 'ga werowiare'ema 'gã nereko tyweawa upe ra'e”, pe'je ki. Ymã te 'ã 'gã ka'arana kwasiari ee rakue. “A'ere 'ga 'awamũ ikwasiaripyrer imũ etee futat iapoi”, 'jau ki pẽẽ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","—Oporiay'iramũ nipo ta'yryrũ ma'e kũjã ajemogyau, ta'yky'ri ma'ea nanẽ nipo nũ. Nujãnarũi eweguu ma'ea. Ta'y'ri'i ma'e nanẽ nujãnarũi nũ— 'jau 'ga 'gã nupe. —Imara'ne te nipo Janeruwarete 'ga 'ũina. Ika'jame'ema 'gã nipo ako tywerete futat. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ika'jame'ema 'gã 'ga wapisiukat jyuu pyu 'gã nupe. Amumera 'gã nipo 'ga ipofarukaa 'gã nupe. A'eramũ nipo 'gã 'gã nerawau kwe pe. Ajepeja ywy pe 'gã nerawau imunepa. Jerusareg ipe judeue'ema 'gã 'wyriara 'gã jemogyramũ nipo ojeapou, kwaiwete futat. Janeruwarete 'ga remifutar imũ etee futat nipo 'gã 'ũina. Awau nipo owaẽma 'ga muẽmawa upe. A'erauwe nipo Janeruwarete 'ga 'ga muẽmukari— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Ywag ipe nanẽ nipo mama'e mũ jesaukari pẽ nupe nũ. Jay are, jaytata are, kwar are. Mĩmer are nipo ojesaukaa pẽ mogyjawamũ. 'Yẽ'ẽa nanẽ nipo oyyita nũ. A'eramũ futat nipo wyjapetegamũ. A'eramũ nipo pẽẽ pejekyjau ipyamu awi. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ywag ipewara nanẽ nipo oyyita nũ. Kwat, jay, jaytata. Mĩmera nipo oyyita— 'jau Jejui 'ga 'gã nupe imome'wau. —A'eramũ nipo pẽẽ ywy pewaramũ najuejue etee pejekyjau jui. Amumera 'gã nipo amanũaipa okyje rerekou. 'Gã kyjea nipo 'gã apisawaipa 'gã mogyau— 'jau Jejui 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","—Aipo pẽẽ esag ire nipo pẽneki'yramũ je tejua tejewya. Ywasiga rupi nipo tejua tejypa. A'eramũ nipo ywy pewara 'gã je resaka, je ruramũ. Tepãjẽ mũ nipo je ruri, tejenyfuga pype futat tejua nũ. A'eramũ nipo 'gã 'jau jee: “Nitywi 'ga amũ ene 'jawe. Ene te 'ã pãjẽretea. Ene te 'ã esage ma'eramũ. Nitywi futari 'ga amũ ene 'jawe”, 'jau nipo 'gã jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","—Aipoa mama'ea pejejeupe ijesaukar ypyrauwe ki pejemogy pejeku'iramũ. Aipo pẽẽ esag ire nipo je anurenure'i je ruri pẽ nerawau 'aw awi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","A'ere Jejui 'ga mama'e mũ mome'wau 'gã nupe, 'gã mu'jau ee ikue: —Mama'ea je amome'u pẽ nupe pẽ mu'jawamũ tejuawa 'ar are— 'jau 'ga 'gã nupe. —Sã'ã ae siaka'gywa potyramũ amana jewyra kwaawa. Ipotyrauwe 'ã ae amana jewyt ja'wyja'wy kwaapa. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nan tee futat ki je'eawer imũ mama'e jeaporamuerauwe pe'je pejejaupe: “'Ut ja'wyja'wy Jejui 'ga janee 'wyriaramũ akou ra'e”, pe'je ki pejejaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A'jea futat je 'i. Je'eawer imũ mama'e jeapo resakarera 'gã papa katu katue'emauwe nipo tejua tejewya— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","—Ywaga nipo ateepawamũ futat. Ywya nanẽ nipo ateepawamũ futat nũ. A'ere nipo jeremimome'ufera nateepawa'uweri futari. Je'eawer imũ etee futat nipo aipoa ojeapou— 'jau Jejui 'ga 'gã nupe ikue. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","A'ere Jejui 'ga oje'ega 'gã nupe nũ: —Pe'je pejejemogyau je ruru'jawa rapesaka au'jeteramũ futat. Pẽnea'at kasi pejejemogyau 'auwara mama'e are etee ne. Maraka apo are etee kasi pejemogy pejeje'aramũ ne. Kasi a'e pe je rura pẽ mopiryyi erujewi ne— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","—Sã'ã ae ywy kwara resage'ema. A'eramũ 'ã ae u'aa erujewi ipype. A'eramũ 'ã ae opiryyjamũ jui. Nan tee futat nipo pẽẽ je jewyra rapesakare'emamũ pẽpiryyi erujewi aipoa mama'e resaka— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","—A'eramũ pẽẽ pejejemogyau pejeje'ega Jarejuwarete 'ga upe, pejeojere'emamũ. “Ku'jyp. Je momoirukat kasi ape eja'yra 'ga rerowiar awi ne. Je poar ape, 'ga rerowiarukaa jee”, pe'je ki 'ga upe. “Mama'e tywera je aesak kwaiwete. A'ere je jemogypyygi 'ga ree”, pe'je ki 'ga upe. “Najepoiriweri je 'ga wi”, pe'je ki 'ga upe. Kasi a'e pe aipo pe'je'emamũ nepeẽma'uweri mama'e tywer awi ne— 'jau Jejui 'ga 'gã mu'jau ee. —Je rerowiar awi pejepoire'ema pejejemogyau je ruramũ tepẽku'i 'jau. Pejejua pejeku'iramũ je rowase je jewyramũ 'jau— 'jau Jejui 'ga 'ũina 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Aipo are 'ga 'gã mu'jau akou. Ai'iwe, ai'iwe 'jau 'ga awau Jarejuwarete 'ga mogytaawa pype 'gã mu'jau. A'ere 'ga kaaruwauwe awau ojepe'au Jerusareg awi. Awau osea Oriweira 'jaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ai'iwe 'ga 'gã nerawau nũ. Tekotee 'gã nanẽ awau 'ga rupi nũ. Kwaiwete 'gã awau 'ga porogyta renupa nũ. Jarejuwarete 'ga mogytaawa pype awau 'ga je'ega renupa ajatykau. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Egitu ywy awi judeu ypy ypy 'gã nenũ'ẽawer are wea'awa maraka upe iwaẽm ja'wyja'wyrauwe mainana 'wyriara 'gã ajatykau Moisesi 'ga remikwasiarer are moromu'jara 'gã nee. —Maran te jane Jejui 'ga pyygi 'ga jukau?— 'jau 'gã ajaupe. A'ere 'gã kyjei 'ga remiayuwa 'gã nui. —Jerusareg ipewara 'gã iporomutat 'ga ree. Soko kasi 'ga ree mytuna pype ne— 'jau 'gã ajaupe. —Wowase 'ga rerekoramũ 'ga remiayuwa 'gã jane apisi ne. Awotywe'eme te sireko 'ga 'jau— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","A'ere 'ga remimu'e 'ga amũ ree mama'eukwaawa 'wyriara ruwi, Judas Iskariote 'ga ree. Jejui 'ga remimu'e 'ga futat numiamũ. A'ere mama'eukwaawa 'wyriara namu'akwaawukari 'ga imogou. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A'eramũ 'ga awau oporogytau mainana 'wyriara 'gã nupe: —Je oo Jejui 'ga resaukaa pẽ nupe. Tepepyyk 'ga 'jau. Je akwaap 'ga rekwawa. A'eramũ je pẽ nerawau 'ga rekwaw ipe— 'jau Judas 'ga 'gã nupe. —'Ga upe jarewaẽmawe nipo je 'ga retywape pyteri 'ga resaukaawamũ pẽ nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","A'eramũ mainana 'gã aku'iramũ 'ga ree, aipo 'ga 'eramũ. —'Ga resaukaramũ toromepy ene 'jau— 'jau 'gã Judas 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Pe'je ki ajee 'wei— 'jau 'ga 'gã nupe. A'eramũ 'gã 'jau 'ga upe nũ: —Tene 'ga jepe'ai ra'ne. Emaenun etee ekou ee ra'ne. Ojetee 'ga rekoramũ toropyyk 'ga 'jau. Jemime toropyyk 'ga 'jau, awotywe'eme 'jau. A'eramũ 'ga rewiriwara 'gã ikwaape'ema 'jau— 'jau 'gã 'ga upe. —Nai'i— 'jau 'ga 'gã nupe. A'eramũ 'ga Jejui 'ga rerekou weape. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Awau owaẽma mani'oko'o jopype'ema 'wawa upe, Pasikwa 'jawa apoawa upe. Maraka fukua te poromũ. A'e awi awau owaẽma karupa'mĩ jukaawa 'ara upe. A'e 'ara rupi futat judeu 'gã karupa'mĩ jukau i'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aipo 'ara rupi Jejui 'ga oje'ega Pedro 'ga upe Juã 'ga retee: —Pe'je pejewau karupa'mĩ mũ jukau eya jarejee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A'eramũ 'gã 'jau 'ga upe: —Ma'ape ki 'ei? Awỹja rog ipe ki 'ei?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A'eramũ Jejui 'ga 'jau 'gã nupe: —Pe'je pejewau Jerusareg ipe. Peu nipo 'y ryrũ rerekwara 'ga peekoat. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","A'eramũ pẽẽ pejewau 'ga rewiri. 'Og ipe 'ga seramũ pejeporogytau 'oga jara 'ga upe: “Janejara 'ga ore mut imome'waukaa enee: ‘Ma'ape te je karupa'mĩ eyra 'ui tejemimu'e 'gã netee?’ e'i 'ga kũi. ‘Ma'ape te ore kumi apoi?’ e'i 'ga enee kũi”, pe'je ki 'ga upe— 'jau 'ga 'gã nupe. —“Tajemi'wat tejemiayuwa 'gã pyri 'jau, e'i 'ga enee ko”, pe'je ki 'ga upe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","—Aipo ojeupe pẽẽ 'e re 'ga tepẽ neroo ywatewara imy'jawa pype 'jau. Ityp futat aejemi'waawa peu. Ae renawa nanẽ otywamũ futat nũ. A'eramũ pẽẽ pejejeupe 'ga esaukar ire peu futat iapou ewara reewe jarejeupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ojeupe Jejui 'ga 'e re 'gã awau. Awau 'gã 'ga 'eawer imũ etee futat esaka. A'eramũ 'gã kumi apou maraka are wea'awamũ. A'ere Jejui 'ga awau 'gã newiri, wemimu'e 'gã nerawau. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kumi apopaw ire Jejui 'ga awau wapyka kumi'wawa pyri wemiayuwa 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","—Karupa'mĩa je auwei tekou pẽ pyri jepi. Ko'iko'i ete 'gã nuri je pyyka je rerekou tyweaete. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","'Awamũ 'ã maraka apoawa. Maraka apoawa upe iwaẽmauwe 'ã peapo maraka jepi. A'ere je 'awamũ etee futat iapoi pẽ pyri. Pẽ'wyriat pãwẽ pãwẽnamũ tejewya te nipo je iapou'jawi pẽ pyri nũ. 'Aga maraka teepap kamẽsĩete. Aipo te nipo marakareteretea futat— 'jau 'ga 'ũina 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A'ere 'ga y'way pyyka, yrũ pypewara reramã'jãu ywau eroje'ega 'Uwa 'ga upe: —Ene te 'ã mama'ea eremut oree— 'jau 'ga 'Uwa 'ga upe. 'Uwa 'ga upe oje'eg ire 'ga itykurukaa 'gã nupe najuejue etee. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","—Je natykuru'jawi pẽ pyri. Tejewyru'japa tãmẽjẽ tatykuru'jap pẽ pyri 'jau nũ— 'jau 'ga wemimu'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A'ere 'ga mani'oko'o'i pyyka nũ. A'eramũ 'ga oje'ega 'Uwarete 'ga upe nũ. 'Ga upe oje'eg ire 'ga imonou imo'jau 'gã nupe. 'Gã moykapap mani'oko'o'i pyu. —Koromũ futat jero'oa. Sã'ã mani'oko'o'i jemo'ia. Nan futat nipo jero'oa jemo'i— 'jau 'ga 'gã nupe. —Amanũ je pẽ nupe pẽ katu'okawamũ. A'eramũ pẽẽ jemanũawer are pejejea'aramũ mani'oko'o'i 'wau pejejemogyau pejeojere'emamũ. Pejejea'aramũ jemanũawer are mani'oko'o'i 'wauwe futat— 'jau 'ga 'gã nupe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ojemi'wapaw ire 'ga kaneeku pyyka nũ. —Sã'ã y'waya. Nan futat nipo jery jeko'wogi pẽ nupe— 'jau 'ga 'gã nupe 'ũina. —A'ere'ere'i futat nipo 'gã amũ jery reko'wogi. A'eramũ nipo jery reko'wog ire Janeruwarete 'ga pẽ katu'oka jery pyu— 'jau 'ga 'gã nupe. —Jery jeko'woge'em ire amunipo 'ã Janeruwarete 'ga nepẽ katu'ogi futari. A'eramũ 'ga pẽ nee futat jery reko'wogukaa. 'Awamũ karupa'mĩa nepejukau'jawi pejetywera mepyawamũ. Poromũ futat 'ga je'eg ymanera numiamũ. 'Awamũ jerya tee pẽ pirei pẽtywer awi. Jemanũ are tee Jeruwarete 'ga pẽtywera moiri pẽ nui je rerowiaramũ. Poromũ futat Janeruwarete 'ga je'eg yaua 'awamũ. A'ea 'ga je'ega nimojopy'ruawi futari 'awamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","—'Au futat ia'wyre'ema 'gã po pe je monoara 'ga reni wapyka je pyri. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Amanũ futat je Tejuwarete 'ga je'eg imũ etee futat. Iporiay'i ia'wyre'ema 'gã po pe je monoara 'ga numiamũ. Anure nipo Janeruwarete 'ga aipo 'ga rereko tyweretei kwaiwete— 'jau 'ga 'gã nupe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aipo 'ga 'eramũ 'ga remimu'e 'gã amã'jãmã'jãu etee ajueakwar are: —Awỹja sipo 'ga monou poromũ ia'wyre'ema 'gã po pe 'wei?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A'ere 'ga remimu'e 'gã eewi ajamueu nũ: —Manamũ te jane Jarejuwarete 'ga upe esage ma'eramũ jarejuapyraapa?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A'e are 'gã ajamueramũ Jejui 'ga 'jau 'gã nupe: —Pekwaap judeue'ema 'gã 'wyriara 'gã nemiapoa. 'Gã 'wyriara 'gã wemiayuwa 'gã amũ monou mama'e apoukaa ojeupe: “Nan iki peapo jeje'egawer imũ etee futat”, 'jau nipo 'wyriara oje'ega wemiayuwa 'gã nupe. Iapo esage'emamũ nipo 'gã 'wyriara 'gã nereko tyweretei. A'etea nipo 'ga 'jau ojeupe: “Je 'ã 'gã nee ojejuka esage ma'ea”, 'jau nipo 'ga 'ũina ojeupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","—A'ere kasi pẽẽ nanarũi ne. 'Wyriaramũ pejejekoweramũ ki pẽẽ mama'e apou etee futat pejejaupe, pejejopoaa etee futat— 'jau 'ga 'ũina 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A'eramũ 'ga 'jau 'gã nupe nũ: —Manamũ te pẽ nupe kũima'eeteete 'ga? Kumi'wawa pyri wapyk ma'e 'ga, kumi apoara 'ga te ra'u nũ?— 'jau 'ga 'gã nupe. —Kumi'wawa pyri wapyk ma'e 'ga futat— 'jau 'gã 'ga upe. —A'jea futat. A'ere 'ã je kumi apoara 'jawe futat je rekoi pẽ nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Ia'wyre'ema 'gã ako je rereko tywerete agawewi ai'i. A'etea 'ã naje rejari pejepe je mogou ojetee'i. A'eramũ je a'eramũ anure pẽ mepyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Tejuwarete 'ga 'wyriaramũ pẽ nupe temonoramũ tomono pẽẽ 'wyria'riramũ imogyau 'jau, tepoaawamũ 'jau. Israeu 'ga ra'yra 'gã pytuna tusi. A'eramũ je pẽ monou pẽ mogyau 'wyria'riramũ Israeu juapyrera 'gã nupe. A'eramũ Israeu juapyrera 'gã nipo awau pẽ nowase. A'eramũ nipo pẽẽ 'jau mama'e esage apoara 'gã nupe: “Mama'e esage ereapo rakue, Jarejuwarete 'ga je'eg imũ rakue. A'eramũ 'ga ene mepyau eneremiapofer are”, 'jau nipo pẽẽ 'gã nupe— 'jau Jejui 'ga 'gã nupe. —Mama'e tywera apoarera 'gã nupe nipo pẽẽ 'jau: “Mama'e tywera etee ereapo Jarejuwarete 'ga upe rakue. 'Ga je'eg imũ jẽmĩ mama'e apowe'em rakue. A'eramũ 'ga ene mepyau eneremiapo tywer imũ etee futat”, 'jau nipo pẽẽ 'gã nupe— 'jau 'ga 'gã nupe. —Aipo 'ara rupi nanẽ nipo pejewau pejejemi'waa je pyri nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","A'eramũ Jejui 'ga 'jau Simão Pedro 'ga upe: —Mama'eukwaawa 'wyriara oje'eg jee ai'i. “Taesak eneremimu'efera 'gã poira ene rerowiar awi 'jau”, e'i mama'eukwaawa 'wyriara jee ai'i. Sã'ã ae juowuu apefera renũ'ẽa a'ỹi esage awi. Nan tee futat nipo mama'eukwaawa 'wyriara pẽ nenuẽm are ifueweramũ jeremiayuwa 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","A'ere 'ã je 'i Tejuwarete 'ga upe tekou ene ree. “Epoar iki Simão 'ga. 'Ga momoirukare'ema je rerowiar awi”, 'jau je 'ã 'ga upe tekou ene ree— 'jau Jejui 'ga 'ga upe imome'wau. —A'eramũ nipo ene epoiraipa etee je wi. A'ere nipo erejewyt je rerowiaa nũ. A'eramũ te nipo nerepoiru'jawi je rerowiar awi— 'jau Jejui 'ga 'ga upe. —A'eramũ ene ejewirera 'gã poaa je rerowiarukaa 'gã nupe— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aipo 'ga 'eramũ Pedro 'ga 'jau: —Naani kũi. Napoira'uweri je ene wi kũi. Moromunepaw ipe miamũ futat je oi ene pyri ene munewamũ kũi. Ene reewe futat temanũmũ kũi— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Ene'me awi kũi. 'Awa ypytuna rupi nipo ene'me 'gã nupe kũi. Muapyapyt katu nipo ene 'jau 'gã nupe: “Nakwaawi je 'ga”, 'jau nipo ene 'gã nupe je kwakupa wyrasokwẽ je'ege'emauwe— 'jau 'ga Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","A'ere Jejui 'ga 'jau 'gã nupe nũ: —Ymã te ako je pẽ monoi kwe pe tejemome'waukaa 'gã nupe ai'i. “Peroo kasi pejekaraemã ne”, 'jau ako je pẽ nupe ai'i. “Ka'aranũũa miamũ futat pẽẽ erawawe'em. Pejepyapaawa miamũ futat kasi peroo ne”, 'jau je ako pẽ nupe ai'i. Kwe pe je pẽ monoramũ te mama'ea nitywi pẽ nupe rai'i?— 'jau 'ga 'gã nupe. —Naani nũ'ũ— 'jau 'ga remimu'e 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—A'jea futat nũ'ũ. A'ere 'awamũ nanarũi. Pejejemi'urama peroo 'awamũ. Ka'aranũũa peroo 'awamũ. Jyuu tywe'emamũ pẽẽ pejejaity poakuwuu mũ me'ega jyuu muawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ymã te 'gã 'ã ka'arana kwasiari inuga je ree rakue: “Wereko tywerete nipo 'gã 'ga oporojuka ma'e 'jawe”, 'jau 'gã ikwasiaa inuga je ree rakue— 'jau Jejui 'ga 'gã nupe 'ũina. —Ikwasiaripyrer imũ etee futat nipo 'gã je rereko tyweretei. 'Awamũ futat 'gã je rereko tyweri— 'jau 'ga 'gã nupe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A'eramũ 'ga remimu'e 'ga amũ 'jau 'ga upe: —'Awamũ mukũi jyuu ruwi kũi— 'jau 'ga 'ga upe. A'eramũ Jejui 'ga 'jau: —Au'je ra'ne— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ojemi'wapaw ire Jejui 'ga awau ywytyr ipe, Oriweira 'jaw ipe. Awawete pe 'ga awau. 'Ga remimu'e 'gã awau 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Owaẽmawe 'ga 'jau 'gã nupe: —Pe'je pejeporogytau Jarejuwarete 'ga upe. A'eramũ pẽẽ pejefuakaramũ pejetywera apowe'em— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ojepe'au'i 'ga awau 'gã nui. A'ere 'ga awau wenupy'ãu wapyka, oporogytau 'Uwarete 'ga upe: ");
INSERT INTO kyzNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Kiapi'ni. 'Wyria'ri 'gã imara'ne je ree. 'Gã nipo 'ã je rereko tywerete 'ja. Ojeupe ene iapoukare'em ire amunipo 'ã 'gã nuapoa'uweri nanuara je ree. A'ere 'ã najeremifutar imũ rũi ereapoukat. Ejemifutar imũ etee te 'ã ereapoukat 'gã nupe jee— 'jau 'ga 'Uwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","A'e pype ywag ipewara 'ga 'ua ojypa 'ga pyri, 'ga mojemogypyygukaa 'ua ojee. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A'eramũ Jejui 'ga oje'egu'japa 'Uwarete 'ga upe nũ. 'Ga 'arasiga 'ga py'a moywyrafenayau 'ga mỹina. A'eramũ 'ga ry'aja otykya 'ga ry 'jawe ywyu. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Oporogytapaw ire Jejui 'ga afu'ama awau wemimu'e 'gã pyri. A'ere 'gã seri 'upa. I'arasig 'gã 'ga ree. A'eramũ 'gã a'eramũ osea ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A'eramũ Jejui 'ga 'jau 'ua 'gã nupe: —Ma'eramũ te peset etee pejejupa? Pefu'am jui. “Pe'je pejeje'ega Jarejuwarete 'ga upe. A'eramũ pẽẽ pejefuakaramũ mama'e tywera apowe'em”, a'e je ako pẽ nupe ko. “Kasi a'e pe nepẽfuakari mama'e tywer awi ne”, a'e je ako pẽ nupe ko— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aipo 'gã nupe 'ga 'e 'ga 'amamũ 'ga pyykara 'gã 'ua owaẽma 'gã nupe. Judas 'ga 'gã nerua pe resaukaa 'gã nupe. —'Au 'ga ruri jepi— 'jau 'ga 'gã nupe. A'eramũ 'ga 'gã nerawau peu. Tenune 'ga 'upa 'gã nupe. A'eramũ 'gã ojekyita 'ga rewiri. 'Ga porogyta 'ga 'amamũ 'gã 'ua owaẽma Jejui 'ga upe. A'eramũ Judas 'ga awau 'ga rerowyka 'ga retywape pytea. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","A'eramũ Jejui 'ga 'jau 'ga upe: —Je resaukaawamũ te 'ã jeretywape pyter ape jejekoty'aawa 'jawe?— 'jau 'ga Judas 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aipo resakawe 'ga remimu'e 'gã ikwaapa. —'Ga pyyka 'gã nuri ra'e— 'jau 'gã ajaupe. A'eramũ 'ga remiayuwa 'gã 'jau Jejui 'ga upe: —Ene pyyka 'gã nuri ra'e. Erefutat te ore jyuu pyu 'gã apisia?— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A'erauwe 'ga amũ ojy rekyita kũima'e 'ga amũ namĩ monoka. Mainana 'ga remiayuwa 'ga namĩ monoka 'ga wi. Furuk. Mainana 'wyriararete 'ga remiayuwa 'ga namĩ 'ga iyypa. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aipo 'ga namĩ yywamũ Jejui 'ga oje'ega 'gã nupe: —Peapo awi nanuara— 'jau 'ga 'gã nupe. A'eramũ Jejui 'ga 'ga namĩ pyyka imonou imỹina 'ga ree nũ, 'ga namĩ renawer ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","A'eramũ Jejui 'ga oje'ega opyykara 'gã nupe. Mainana 'wyriara 'gã, Janeruwarete 'ga mogytaawa raarana 'wyriara 'gã, judeu 'gã 'wyria'ri 'gã. Mĩmera 'gã 'ua 'ga pyyka. A'eramũ 'ga 'jau 'gã nupe: —Ma'eramũ pẽẽ ma'eramũ pejejua muawa pyu je nupãu ekoete 'ũ, muna'ywa 'jawe 'ũ? ");
INSERT INTO kyzNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pejejepype je rekoramũ miamũ ako naje pyygi pejepe ai'i. A'ere jemanũawa upe iwaẽmi 'awamũ. A'eramũ Jeruwarete 'ga je pyygukaa rẽwẽjẽmĩ pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","A'eramũ futat 'gã Jejui 'ga pyyka 'ga rerawau mainana 'wyriararete 'ga rog ipe. Pedro 'ga awau 'ga rewiri. A'ere 'ga mukuu etee 'ga rekoi 'ga wi. Awau 'ga owaẽma mainana roga upe. A'ere 'ga oi akou ukupepe etee mainana 'ga remiayuwa pyri etee. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ukupepe mainana 'ga remiayuwa 'gã tata mojopy'wau 'upa 'ga roga pyri. A'eramũ Pedro 'ga awau wapyka ojepe'jau 'gã pyri. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","A'eramũ mainana 'ga remiayuwa ẽẽ mũ 'ga resaka. —Mĩnamũ kĩã rewiriwara kĩã amũ reni ra'e— 'jau ẽẽ, 'ga resaka tata ypyu 'ga renamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aipo ẽẽ 'eramũ Pedro 'ga 'jau ẽẽ upe: —Tee. Naani nũ ĩ. Nakwaawi je 'ga nũ ĩ— 'jau futatee 'ga ẽẽ upe. Okyjau 'ga opyyg awi. A'eramũ 'ga o'meramũ ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A'ere kũima'e 'ga amũ 'ga resaka nũ. —Ene futat 'ga rewiri ako ma'efera, 'jau je 'ũ— 'jau 'ga Pedro 'ga upe. A'ere Pedro 'ga 'i etee 'ga upe: —Naani nũ'ũ. Naje rũi kũi— 'jau etee Pedro 'ga 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A'ere'ere'i ajepeja 'ga 'jau 'ga upe nũ: —Ene futat 'ga rewiriwarera kũi. Garireja ywy pewara ene. A'eramũ ene a'jea futat kũi, 'ga rewiriwara futat ene kũi— 'jau 'ga Pedro 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—Nakwaawi je aipo ene'ea nũ'ũ— 'jau futatee Pedro 'ga 'ga upe, Jejui 'ga kwakupa 'gã nui. Aipo 'ga 'e 'ga renamũ wyrasokwẽ oje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A'erauwe Jejui 'ga ojerowaka amã'jãu Pedro 'ga ree. A'eramũ Pedro 'ga wea'aramũ 'ga 'eawer are. “Wyrasokwẽ je'ege'emauwe nipo je kwakuw ape 'gã nupe muapyt”, 'ga 'eawer are. —A'eferupi tee pa 'ã je 'ga kwakuwi nũ— 'jau 'ga wea'aramũ 'ga je'egawer are. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aipo 'e re Pedro 'ga awau ujãna ojenosõu. A'eramũ futat u'arasigamũ wea'aramũ ee. —Ma'eramũ je aipo 'jau ra'e 'ũ?— 'jau 'ga awau 'ũina u'arasigamũ. —Mama'e esage na'ga 'ã wapo jee jepi re'ã. A'etea pa je 'ã aipo a'e ekoete 'gã nupe ra'e nũ— 'jau 'ga ojeupe, u'arasigamũ u'eawer are. A'eramũ 'ga ajaa'wau awau u'eawera raykau. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","'Ga pyykara 'gã Jejui 'ga nupãu. 'Ga kurapa kypyre'emete futat 'ga rerekou 'ga nupã pype. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","A'eramũ 'gã 'ga reakwapiaa taity pyu. A'ere 'gã 'jau 'ga upe: —Ene 'ã i'akwaap ma'ea. Awỹja te ene nupã?— 'jau 'gã 'ga upe 'ga rerekoemãu erekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A'e pype 'ga nupãara 'gã 'ga kurapa ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ku'emamũ mainana 'gã ajatykau 'wyria'ri 'gã, Moisesi 'ga remikwasiarer are moromu'jara 'gã netee: —Perut 'ga 'au oree. Toromoporogytaukat 'ga 'au orojee 'jau— 'jau 'gã 'gã nupe. A'eramũ 'gã 'ga rerua 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","A'eramũ 'gã 'jau 'ga upe: —Ene futat te Jarejuwarete 'ga remimurera?— 'jau 'gã 'ga upe. —“A'jea futat” je 'eramũ naje rerowiari pejepe ne— 'jau etee Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","—Pejejeupe mama'e mũ ree jeporonuwamũ, nepemome'ui jee ne. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","A'ere anurenure'i je apygi Tejuwa 'ga yse katy. Tejuwarete 'ga 'jawe futat nipo je rekoi pãjẽreteramũ. A'eramũ nipo je 'ga yse katy te'ỹina teapyka 'awamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","—Koromũ futat nipo ajee ene Jarejuwarete 'ga ra'yramũ?— 'jau 'gã 'ga upe. —A'jea futat poromũ pe'je— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aipo 'ga 'eramũ taetu 'gã amara'neramũ 'ga ree kwaiwete. —Aruenuw ore 'ga 'awamũ. “Tejuwa 'ga 'jawe futat je rekoi nipo”, e'i 'ga oree— 'jau 'gã ajaupe. —Pe'je ajee sijuka 'ga 'ũ— 'jau 'gã ajaupe. —Narafutari ore 'ga je'ega mome'wara 'gã. 'Ga futat 'awamũ ojemome'u esage oree— 'jau 'gã ajaupe, amara'neramũ 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aipo 'e re 'gã 'ga rerawau 'wyriara 'ga upe, Piratu 'ga upe. Najuejue etee futat 'gã 'ga rerawau. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A'eramũ 'gã 'ga je'ẽwu'jaga 'ga upe: —Koromũ 'wyriararete 'ga ree 'gã mamara'neukaara. “Pemepy awi 'wyriararete 'ga”, e'i 'ga oree ai'i— 'jau futatee 'gã, Jejui 'ga je'ẽwu'jaga Piratu 'ga upe. —Koromũ futat “Je Jarejuwarete 'ga remimureramũ”, 'jau nanẽ 'ga oree ai'i nũ. “A'eramũ je 'awamũ 'wyriarareteramũ pẽ nupe. 'Ga py'rau tejua”, e'i 'ga oree ai'i. A'eramũ ore 'ga pyyka 'ga rerua— 'jau futatee 'gã Jejui 'ga je'ẽwu'jaga Piratu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A'eramũ Piratu 'ga 'jau Jejui 'ga upe: —Ene futat nipo ajee judeu 'gã 'wyriararetea?— 'jau 'ga 'ga upe. —A'jea futat ere poromũ— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","A'eramũ Piratu 'ga 'jau 'gã nupe: —'Agamũ ae kũima'e tywere'emamũ, a'e je 'ã pẽ nupe jepi. Ma'eramũ ajee jane 'ga jukai 'ũ? Ma'ja 'ga iapou pẽ nupe rai'i 'ũ?— 'jau etee Piratu 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","A'ere mainana 'gã 'i etee futat 'ga upe: —Pe'je 'ga jukau futat. Kwe pe te 'ã 'ga oi ae mu'jau tyweruu akou. A'ere 'ga remimome'ufera nia'wyri futari. Amunawa moyka oporogyta tywera pyu. Pẽnemiayuwa 'gã 'ga amu'e 'wyriararete 'ga rerowiarukare'em are. Garireja ywy pe ra'ne ako 'ga rekoi 'gã mu'jau ai'i. A'ere 'ã 'ga ruri akou 'au nũ— 'jau futatee 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aipo ojeupe 'gã 'eramũ Piratu 'ga 'jau 'gã nupe: —Garireja ywy awi 'ut ma'efera 'ga nipo ajee?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Pe awi futat 'ga ruri— 'jau 'gã 'ga upe. A'eramũ Piratu 'ga 'jau 'gã nupe: —Pe'je ajee 'ga rerawau Erote 'ga upe. Ako je nipo 'ga 'au. Garireja ywy pewara 'gã 'wyriara 'ga. A'eramũ pẽẽ 'ga rerawau imome'wau 'ga upe— 'jau Piratu 'ga 'gã nupe. A'eramũ 'gã 'ga rerawau Erote 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jejui 'ga resakawe Erote 'ga aku'iramũ 'ga ree. Jejui 'ga rera renupawe 'ga 'jau ojeupe: “Ymã we 'ã jeporesagiweramũ 'ga ree numiamũ. A'ere 'awamũ 'ga ruri 'au je resaka. Ojero'wu ma'e 'gã 'ga okatu'ok. Amanũ ma'e 'gã nanẽ 'ga omoferap nũ, 'jau 'gã jee jepi. Ma'ja sipo ajee 'ga wapo jee wesagamũ?” 'jau 'ga ojeupe, oporesagiweramũ 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A'eramũ Erote 'ga Jejui 'ga moporogytaukaa ojeupe numiamũ. A'ere Jejui 'ga noje'egi Erote 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A'eramũ mainana 'wyriara 'gã 'ua, Moisesi 'ga remikwasiarer are moromu'jara 'gã netee. Jejui 'ga je'ẽwu'jaga Erote 'ga upe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A'eramũ Erote 'ga 'ga kurapa jefaruu 'gã netee. A'ere 'ga 'wyriara raity piraga pyu 'ga kupe piari, 'ga rerekoemãawamũ. —“Je 'wyriara” e'i 'ga. A'eramũ pẽẽ 'awamũ pejemã'jãu 'ga raity esage are. 'Wyriara 'jawe futat 'ga— 'jau 'gã Jejui 'ga rerekoemãu 'ga kurapa. A'ere Erote 'ga 'jau 'gã nupe: —Pe'je 'ga rerawau 'ga rerojewya Piratu 'ga upe nũ— 'jau 'ga 'gã nupe. A'eramũ futat 'gã 'ga rerawau erojewya Piratu 'ga po pe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aipoa 'ara rupi Piratu 'ga akou Erote 'ga jekoty'aawamũ. Imara'ne 'gã akou ajuee. A'ere aipo 'ara rupi 'gã ta'waramũ ajaupe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A'eramũ Piratu 'ga 'gã majatykau. Mainana 'gã, judeu 'gã 'wyria'ri 'gã, tekotee 'gã. Mĩmera 'gã 'ga imajatykau 'gã mua oporogyta anupa. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—Perur ete 'ã Jejui 'ga. Erojewya jee nũ. Pẽẽ te 'ã perut ekoete 'ga rai'i. “Ekoay 'ga akou 'wyriararete 'ga rerowiare'em are 'gã mu'jau”, 'jau 'ã pẽẽ 'ga upe. A'eramũ je ako teporonupa ee pẽ nowase 'ga upe ai'i. A'ere 'ã 'ga nuapoi futari mama'e tywera rai'i. O'meramũ te 'ã pe'je. Peje'ẽwu'jag ekoete 'ã 'ga— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","—Erote 'ga nanẽ 'ã 'jau rai'i nũ: “Nuapoi 'ga mama'e tywera ajukaawamũ”, 'jau 'ga 'ã 'ga upe rai'i nũ. A'eramũ 'ga 'ã 'ga mua imojewya 'au rai'i nũ— 'jau Piratu 'ga 'gã nupe. —Najeporojukaweri je 'ga ree. Nia'wyri je upe 'ga jukaa ekoetea. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","A'eramũ je 'ga nupãukaa etee 'gã nupe ra'ne. A'ere 'ga tomono imuẽma 'jau nũ, 'ga nupã re 'jau nũ— 'jau Piratu 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mani'oko'o jopype'ema 'wawa maraka apoawa rupi Piratu 'ga moromunepawa pype imunewipyrera 'ga amũ muẽma judeu 'gã nupe jepi. A'eramũ Piratu 'ga 'jau ojeupe: “Jejui 'ga wi jepoiriweramũ”, 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","A'ere tesirũmera 'gã afukai etee 'ga upe: —Erepoir awi 'ga wi. Ejukaukat tãmẽjẽ 'ga oree. Moromunepawa pypewara 'ga te erejukaukar awi. Epoit etee 'ga wi oree. Parapasi 'ga te emuẽm moromunepaw awi oree. A'eramũ ene Jejui 'ga jukaukaa oree— 'jau 'gã wafukaita 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Parapasi 'ga futat 'gã mamara'neukaa 'wyriara 'ga ree rakue. “Simuẽm 'ga 'wyriaramũ 'ga ren awi 'jau”, 'jau 'ga 'gã nupe, 'gã mamara'neukaa 'ga ree. Oporojuka ma'efera 'ga wejue nanẽ poromũ nũ. A'eramũ 'gã 'ga monou 'ga munepa 'ga mu'ama rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A'ere Piratu 'ga 'ga muẽm are nifueweri. A'eramũ 'ga oje'egu'japa 'gã nupe nũ: —Naani futari. Jejui 'ga wi futat je poiri— 'jau etee 'ga 'gã nupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","A'ere 'gã afukai etee 'ga upe nũ: —Naani futari. Erepoir awi futat 'ga wi. Ere 'ga jukaukaa futat oree. Ere 'ga monoukaa futat imu'ama 'ypeywar are oree— 'jau judeu 'gã Piratu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A'ere Piratu 'ga je'egu'jawi etee 'gã nupe nũ: —Natesirũgatu 'ga rekorãu rũi 'ã pejukaukat 'ga jee. Kũima'e esagea te 'ga 'ã. Anupãukat etee futat je 'ga 'gã nupe. A'ere je 'gã momoirukaa 'ga wi— 'jau Piratu 'ga 'gã nupe numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","A'ere 'gã jopy'rupy'rui etee futat wafukaita 'ga upe nũ: —Naani futari. “Ere 'ga jukaukaa futat oree”, aru'e ako ore ko— 'jau etee 'gã wafukaita 'ga upe afuakaramũ futat Piratu 'ga ree. Wojere'emamũ futat 'gã wafukaita 'ga upe aipo 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","—Nepeenuwi etee 'ã jeje'ega. “Ere ki 'ga jukaukaa futat oree”, pe'je 'ã jee. A'eramũ je 'ga jukaukaa pẽ nupe— 'jau Piratu 'ga 'gã nupe ojee 'gã fuakarauwe. A'eramũ Piratu 'ga oporojuka ma'efera 'ga jẽmĩ imuẽmukaa moromunepaw awi 'gã nupe. Aipoa imuẽmipyra kũima'e 'ga futat 'wyriara 'gã ajuee 'gã mamara'neukarera. A'etea 'ga 'ga omomoirukat 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","A'eramũ futat jefaruu 'gã Jejui 'ga rerawau 'ypeywar are 'ga pokutukaw ipe. A'eramũ 'gã pe aje Simão 'ga rekoaa, Sirene ywy pewara 'ga rekoaa. —'Ypeywara erokwap 'ga upe. Ifuakapap 'ga ee— 'jau jefaruu 'gã Simão 'ga upe, oje'ega moywyrafena. A'eramũ futat 'gã imonou 'ga 'arimũ, 'ypeywara rupirukaa 'ga upe. A'eramũ 'ga erawau erekou 'gã newiri. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kwaiwete 'gã ojekyita 'gã newiri awau. —Siesak 'ga jukaa 'jau— 'jau 'gã ajaupe. A'eramũ 'gã ojekyita 'ga rewiri awau. Kũjãmera 'gã nanẽ awau Jejui 'ga rewiri. Awau 'gã ajaa'wau 'ga ree: —Esage ma'e kĩã. Janepytuna ako kĩã okatu'ok ai'i. A'ere wã 'awamũ kĩã rerooi ijukau— 'jau 'gã ajaupe ajaa'wau 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A'eramũ Jejui 'ga ojerowaka 'gã nee, oje'ega 'gã nupe: —Pejoo'o awi je ree. Pejeja'yra 'gã nee tepejoo'o pejejee nanẽ futat pejejaa'wau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Anure nipo pe'je pejejaupe: “Ta'yre'ema wã jaruete ajemogy. Jane te aje 'ã ta'yt ma'eramũ jareja'yra eko tywera siesak jarejemogyau”, 'jau nipo pẽẽ pejejaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Anure nipo peko tywet futat. Ywytyra upe nipo pẽẽ 'jau: “Ejot e'aa ore 'arimũ. Noreruagi ore arako tywera upe”, 'jau nipo pẽẽ ywytyra upe. A'ere nipo nuri futari u'aa pẽ 'arimũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","—Je 'ã Tejuwarete 'ga remifutar imũ etee futat aporowyky. A'etea 'gã 'ã je jukau ekoete. Pẽẽ taetu aje 'ã mama'e tywera peapo. Na'ga remifutar imũ etee rũi pejemogy pejeporowykyau— 'jau 'ga 'gã nupe. —Je miamũ te 'ga 'ã je rereko tywerukat wa'yramũ miamũ. Pẽẽ taetu aje 'ã 'ga rerowia'ria te. A'eramũ 'ga pẽ taetu pẽ nerekou tyweaete futat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mukũja muna'ywa 'gã nanẽ 'gã erawau iapisau Jejui 'ga reewe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aeakagera 'jawewat 'jau ae apisawa rera. Mukũja muna'ywa põ'õ me 'gã Jejui 'ga mu'ama 'ypeywar are. 'Ga ryrũ mosoka 'ga wi. A'ere 'gã 'ga monou imu'ama muna'ywa 'gã põ'õ me. Itaju pyu 'gã 'ga pokutuka ajuowai. 'Ga py maju'aa ikutuka. 'Ga rekoa futat 'gã imonou imu'ama 'ypeywar are ipokutuka. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","A'ere Jejui 'ga 'jau 'Uwarete 'ga upe: —Enemara'ne kasi 'gã nee ne, Kiapi'ni. Je repyat kasi ape ne, Kiapi'ni. Nokwaawi 'gã je rekoa— 'jau 'ga 'Uwarete 'ga upe oje'ega. A'ere 'ga pokutukarera 'gã 'ga raityfera me'egawamũ, ita'i 'jawewara momopoa 'upa ywyu. A'eramũ ijewag are, 'ga raity mojo'oka. Sã'ã ae jugu momora. Nan futat 'gã ita'i 'jawewara momopori 'upa 'ga raityfera mojo'okawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A'eramũ judeu 'gã 'wyria'ri 'gã 'gã nesaka 'upa. 'Ga momoria 'ga rerekoramũ 'gã 'upa 'ga rerekoemãu etee 'upa. —“Janeruwarete 'ga te ako je mut ikue”, e'i 'ga jepi. Opoat 'ga 'gã jepi. Siesak 'ga jepoara 'jau— 'jau 'gã 'upa ajaupe. —Ere ejua ejypa. Taruesak ene rura ene jywa 'jau kũi. Ene jyp ene ruramũ taruerowiat ene 'jau kũi. “Na pa je 'ga Janeruwarete 'ga remimurera futat ra'e”, taru'e enee 'jau kũi— 'jau 'gã Jejui 'ga upe 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jefaruu 'gã nanẽ 'ga kurapa 'upa nũ 'ypeywar are 'ga 'amamũ nũ. Y'way ajaiwaya 'gã erawau erojeupia itykurukaa 'ga upe numiamũ. A'ere 'ga notykuri. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—“'Wyriara je” ere 'ã. A'eramũ ene ejua ejypa esaka oree— 'jau 'gã 'ga upe. A'ere 'ga nojywi futari. Enupare'ema 'jawe etee futat 'ga u'ama 'ypeywar are werekoemãnamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A'ere Piratu 'ga 'yjepa'nĩ kwasiaa 'gã nupe: “Koromũ futat 'wyriararetea judeu 'gã nupe” 'ea 'ga ikwasiaa 'yjepa'nĩ are. A'ere 'gã erawau ikutuka inuga 'ga apyte'rarimũ 'yw are. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","'Ga pyri u'am ma'ea mũ muna'ywa oje'egayau 'ga upe: —“Janeruwarete 'ga remimurera je”, ere 'ã. A'eramũ ene ewau ejypa jarejee, tore mososog ape 'ypeywar awi 'jau— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Aipo 'eramũ ajepeja muna'ywa 'ga amara'neramũ aipo 'jara 'ga ree. —Nerekyjei nipo 'ã Jarejuwarete 'ga wi? Ene we 'ã aipo ere e'ama 'ga upe. Noporojukai 'ga 'ã. A'etea nipo 'ga 'ã amanũ. Au'je katu te 'gã jane taetu jane apisi. A'eramũ jane 'awamũ jaretywera mepyau. 'Ga tywere'ema miamũ 'ã amanũ— 'jau 'ga ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A'ere 'ga 'jau Jejui 'ga upe: —Ejea'ar iki je ree, ki Jejui, 'wyriaramũ ejewya— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","A'eramũ Jejui 'ga 'jau 'ga upe: —'Awauwe futat ereo je rupi jerupaw ipe. Esage te 'ã jerupawa. 'Awauwe futat jane oi peu— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kwara okwapa aje owepa. Ypytuna 'jawe futat oypytunaiwamũ. Kwara ajerewamũ tãmẽjẽ awau weny jesagamũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Janeruwarete 'ga mogytaawa rowopypea my'jawa taity otoroka Jejui 'ga manũnamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A'e pype Jejui 'ga wafukaita 'Uwarete 'ga upe: —Amanũ je. Te'aga je omono enepo pe, Kiapi'ni. Eneremifutar imũ etee futat je manũi 'gã tywera mepyau, Kiapi'ni— 'jau Jejui 'ga 'Uwarete 'ga upe. A'eramũ futat 'ga amanũmũ. Aipo 'e re 'ga opika amanũmũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A'eramũ jefaruu 'gã 'wyriara 'ga enupa u'ama 'ga manũ resaka. A'eramũ 'ga 'jau Jarejuwarete 'ga upe: —A'jea futat 'ga kũima'e esagea rai'i— 'jau 'ga u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","'Ga manũ resakara 'gã u'arasigamũ awau ojewya oje'wyr ipe nũ. —Ma'eramũ jane 'ga jukaukaa ekoete rai'i 'ũ? Esage futat 'ga rai'i— 'jau 'gã ajaupe pe rupi awau akou. A'eramũ u'arasigamũ awau ojewya oje'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","'Ga pytunera 'gã, kũjãmera 'gã. Mĩmera 'gã muku'i 'upa 'ga manũ resaka. Kũjãmera 'gã 'ua Garireja ywy awi Jejui 'ga rupi rakue. A'eramũ 'gã 'upa 'ga manũ resaka nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kũima'e 'ga amũ 'ũina Jejui 'ga manũ resaka. Josea 'ga rera. Arimateja pewarera 'ga. Arimateja 'jawa amunawa 'upa Judeja ywy pype. Jose 'ga esage ma'ea. “Jejui 'ga Janeruwarete 'ga remimurera futat”, 'jau 'ga akou ojeupe etee jepi. Jejui 'ga 'ga werowiat. Opytuna 'gã nupe oje'ẽma'e 'ga poromũ. A'eramũ 'ga ajatykau ajepeja oje'ẽma'e 'gã nee rakue. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ajatykaaw ipe 'gã 'jau rakue: “Sijuka Jejui 'ga”, 'jau 'gã ajaupe rakue. A'ere Jose 'ga 'i 'gã nupe: “Naani. Nafutari je 'ga jukaa”, 'jau 'ga 'gã nupe rakue numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aipo 'ga awau oje'ega Piratu 'ga upe: —Amanũ Jejui 'ga ko. 'Ga reumera toroo inuga ita kwara pype 'jau— 'jau 'ga Piratu 'ga upe. —Ere 'ga rerawau inuga ipype— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A'eramũ 'ga awau Jejui 'ga reumera mosoka 'ypeywar awi. A'ere 'ga 'ga reumera auwana taity pyu. Iauwan ire 'ga erawau inuga ita kwara pype. Jejui 'ga reumera erawau inuga ita kwara pype, teumera monoawe'ema pype. Jejui 'ga tãmẽjẽ futat 'ga imonou aipoa ita kwara pype. Ymã te 'gã kwaiwete 'gã neumera monoi ita kwara pype ra'e jepi. A'ere aipoa nipa'ruawi we. Ita kwar yaua te poromũ. A'eramũ 'ga Jejui 'ga reumera tãmẽjẽ imonou ipype. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sexta feira kaaruwa rupi 'ga 'ga monou ita kwar yau pype. Sabado morowykye'ema judeu 'gã nupe. A'eramũ morowykye'ema piara rupi 'gã 'ga monou ita kwara pype. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kũjãmera 'gã 'ua Garireja ywy awi 'ga rupi rakue. Aipo 'gã awau 'ga rupi ita kwara pype 'ga rerooramũ. —Taruesak ene imonoa 'jau— 'jau 'gã Jose 'ga upe. —A'jea— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jejui 'ga reumera mono resag ire 'gã awau wog ipe nũ. Jany kasiga mogatyrũmũ imogyau Jejui 'ga reumer are imonopyramũ. A'ere 'gã sabado rupi 'gã noporowykyi. “Sabado rupi peporowyky awi”, 'jau Moisesi 'ga 'gã nupe rakue. A'eramũ 'gã oporowykyawe'em. Opytu'wau ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ikoai'i, ku'emaiw are, kũjãmera 'gã awau. Mari Matarena ẽẽ, Juana ẽẽ, ajepeja Mari ẽẽ, Tiago 'ga y ẽẽ. Amumera 'gã nanẽ awau 'gã nupi nũ. Mĩmera 'gã jany kasiga rerawau eko'woka Jejui 'ga auwanawa taity are. Ita kwar ipe 'gã erawau numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Owaẽmawe 'gã itauu resaka. Ita kwara rawopytymawera 'gã esaka. Ojepe'au jui. Ita ojepe'au ikwar awi. —Koo. Awỹja ita pe'au jui ra'e nũrã?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","A'eramũ 'gã awau ita kwara pype osou. A'ere 'gã nuesagi Jejui 'ga reumera. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A'eramũ 'gã 'jau: —Ma'eramũ kĩã maran akou rai'i nũrã? Nitywi ra'e— 'jau 'gã ajaupe. Poje mukũi ywagipewara 'gã 'ua ojesaukaa kũima'eramũ etee 'gã nupe. 'Gã naitya wenyfugaiwayramũ 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","A'eramũ kũjãmera 'gã okyjau etee ajemogyau. Wããpyramũ ajemogyau. 'Gã kyjea 'gã nerekou. A'eramũ 'gã nupe ojesaukat ma'e 'gã 'jau 'gã nupe: —Ma'eramũ te peekat 'ga 'au ita kwara pype? Oferap ako 'ga ko. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","'Au 'ga nitywi. 'Ga Ruwarete 'ga 'ga moferap ko nũ. Nepẽnea'ari nipo 'ga 'eawer are? “Je 'ã pẽneki'yra. A'eramũ nipo 'gã jejywaa pypiraa 'ypeywar are. A'eramũ nipo je temanũmũ futat”, 'ga 'eawer are?— 'jau 'gã 'gã nupe. —“A'ere nipo mukũi etee je seri. Imuapyra 'ara rupi teferapa nũ”, pejejeupe 'ga 'eawer are nipo pejejea'are'emamũ pejejemogyau? A'eferupi tee 'ã 'ga ferawi nũ. Sã'ã 'ga 'amamũ nũ— 'jau 'gã kũjãmera 'gã nupe. 'Gã ããpyt 'gã jemogyramũ 'gã aipo 'jau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","A'eramũ futat 'gã wea'aramũ ee. Ojeupe Jejui 'ga 'eawer are wea'aramũ ajemogyau. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","A'eramũ futat 'gã ojewya awau imome'wau 'ga remimu'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","A'ere 'gã nuerowiari 'gã. —Pẽ'me nipo nũ ĩ. Naruerowiari ore pẽẽ— 'jau etee 'gã 'gã nupe, ojeupe 'gã imome'uramũ. A'ere 'gã fuakaramũ etee. —A'jea futat kĩã ferawi ra'e— 'jau etee 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","A'ere Pedro 'ga fu'ami uẽma awau esaka. Jejui 'ga monoawer ipe owaẽmawe 'ga anuruka amã'jãu 'ga rupawer are. Irãã'ã taitya etee tuwamũ 'ga rupawera pype. A'ere nitywi 'ga reumera. A'ere Pedro 'ga 'ua wog ipe nũ. “A'jea sipo 'ga ferawi ra'e? Ma'ape sipo ajee 'ga rekoi? Aesak werewi pa 'ã je 'ga nũ”, 'jau 'ga 'ũina. Ojeupe etee futat wea'aramũ 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aipo 'ara rupiwe mukũja 'gã awau ajepeja amunaw ipe. Emausi pe 'gã awau. Jejui 'ga rewiriwarera 'gã futat poromũ. Jerusareg ipyriuu Emausi 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jejui 'ga ree 'gã awau akou wea'aramũ. Oporogytau akou ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","'Gã porogyta 'gã nekoramũ Jejui 'ga 'ua 'gã nupisika pe aje. A'eramũ futat 'ga oporogytau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","'Ga resakarera 'gã futat numiamũ. A'ere 'gã nokwaawi 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'eramũ pẽẽ ma'ja 'jau pejejemogyau 'ũ?— 'jau 'ga 'gã nupe. A'eramũ 'gã opytau. Ojeupe 'ga je'egauwe 'gã opytau. U'arasigamũ opytau 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","A'eramũ Kreopas 'ga 'jau 'ga upe: —Nerekwaawi nipo ekou ki sa? Jerusareg awi 'ut ma'e agawewi nã'ã ene re'ã. A'etea nipo nerekwaawi ekou ki sa?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—Ma'eramũ maran ki 'ei?— 'jau Jejui 'ga 'gã nupe. —Jejui 'ga Nasare pe waranup ma'efera 'ga. 'Ga poromũ Jarejuwarete 'ga je'eg are ore mu'jarera. Jarejuwarete 'ga pãjẽa 'ga wereko ai'i kũi. Ojero'wu ma'e 'gã 'ga ikatu'oka 'jau ai'i kũi. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","A'ere mainana 'wyriara, ore'wyria'ri 'gã netee 'ga monou Piratu 'ga po pe, 'ga jukaukaa ai'i— 'jau 'gã 'ga upe. 'Ga jukaawera mome'wau Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","—“Israeu juapyreramũ jane'wyriara 'ga”, 'jau ore 'ga upe jepi numiamũ. “'Ga 'awamũ jane pojeka tapy'ỹjamũ te 'wyriar awi”, 'jau ore ai'i numiamũ. A'ere ako 'gã ikokaru'wi futat 'ga jukai ai'i. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","A'eramũ 'awamue futat orepytuna 'gã awau ita kwar ipe wyrasokwẽ je'egauwe ra'e. A'ere 'gã nuesagi 'ga reumera ra'e. “Ywagipewara wã etee ore aruesak ita kwara pype”, 'jau 'gã ko. “Oferap 'ga ko, 'jau wã oree”, 'jau kũjãmera 'gã imome'wau oree ko. A'eramũ aipo 'gã 'ea ore moporesaka etee ore mogyau ko, ore ikwaape'ema arajemogyau ko. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","A'eramũ orepytuna 'gã amũ awau esaka ko nũ. A'ere 'gã miamũ nuesagi 'ga ra'e. “A'jea futat ra'e”, 'jau 'gã oree ko— 'jau 'gã 'ga upe, imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","A'eramũ Jejui 'ga 'jau 'gã nupe: —Ma'eramũ sipo pẽẽ Jarejuwarete 'ga porogytafera mome'wara 'gã je'ega rerowiara'ne'ema pejejemogyau? ");
INSERT INTO kyzNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nepekwaawi we nipo. Wemimurera 'ga manũe'em ire amunipo 'ã Janeruwarete 'ga nepẽ katu'oga'uweri futari. A'eramũ 'ga amanũmũ futat 'au. A'ere 'ga ferawi nũ. A'ere 'ga awau ojeupia ywag ipe nũ. Nan nipo “'ga rekoi pẽ katu'okaramũ” 'eawera— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","'Gã mu'jau amanũawer are. —Ymã te 'ã Moisesi 'ga ka'arana kwasiari 'ga manũ are rakue. Janeruwarete 'ga je'ega mome'wara 'gã nanẽ futat, ka'arana kwasiaa 'ga manũ are rakue— 'jau 'ga 'gã mu'jau, wataaw ipe 'gã nerekou. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emausi 'jawa amunawa upe owaẽm ire Jejui 'ga 'jau 'gã nupe: —Iruupeu'i je oi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","A'ere 'gã fuakaramũ 'ga ree: —Naani. 'Au etee futat eko ore pyri. Kaarup. Iypytunaiway enee ne— 'jau 'gã 'ga upe. A'eramũ futat 'ga awau osou 'gã nog ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A'eramũ 'gã awau wapyka ojemi'waawa pyri. A'ere 'gã ojemi'war enune Jejui 'ga kanape'i pyyka oje'ega 'Uwarete 'ga upe: —Ene te 'ã eneresage oree. Mama'ea eremut oree eojere'emamũ— 'jau 'ga Jarejuwarete 'ga upe. A'eramũ futat 'ga eruapyka kanape'i mopena 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kanape'i mopena resakawe 'gã 'ga kwaapa. —Kuu. 'Ga futat ra'e kũi— 'jau 'gã ajaupe. Okwaawauwe 'ga ojemoteu 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","A'eramũ 'gã 'jau ajaupe: —Jarejeupe 'ga je'egamũ janepy'ata'waramũ akiko kũi. A'eramũ jareku'iramũ 'ga ree. Jarejuwarete 'ga je'eg are ako 'ga jane mu'jau jane reruaw ipe ko kũi. Jarepy'ata'waramũ akiko, Jarejuwarete 'ga je'ega mome'urauwe— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","A'eramũ futat 'gã afu'ama ojewya awau imome'wau Jejui 'ga remimu'e 'gã nupe Jerusareg ipe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","A'ere 'gã imome'ue'emauwe 'gã amũ 'jau 'gã nupe: —A'jea futat 'ga ferawi rai'i kũi. Simão 'ga “aesak je 'ga ko”, e'i ko kũi— 'jau 'ga 'gã nupe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A'eramũ Emausi 'jaw ipe oo ma'efera 'gã wemiesagera mome'wau 'gã nupe: —Emausi pe ore oi ko. A'eramũ 'ga ipiara rupi ojesaukaa oree ko. A'ere ore norokwaawi 'ga ko. 'Og ipe orowaẽm ire 'ga kanape'i mopena oree ko. A'eramũ te ore 'ga kwaawi ko— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aipoa 'gã imome'u 'gã nuwamũ Jejui 'ga ojesaukaa 'gã pyter ipe. —Pẽpy'ata'waawa owaẽm pẽ nupe ki 'ei. Pẽpy'ata'wa 'awamũ ki 'ei— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","—Ajaga nipo 'ã 'ja— 'jau 'gã ajaupe. A'eramũ 'gã okyjau 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","—Ma'eramũ ajee pekyje etee je wi ki 'ei? Naje rerowiari nipo pejepe?— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","—Jepo are pemã'ẽ, jepy are 'jau. Jepo kutukawera peesak. A'e are je kwaap pejepe. Je ete ako. Pepokok je ree esaka. Taje rerowiat pejepe 'jau. Ajaga no'oi. Je futat ako. Pepokok je ree esaka. Tepeesak jero'oa 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A'erauwe 'ga opo kutukawera resaukaa 'gã nupe. Opya nanẽ nũ. Opy resaukaa 'gã nupe. —Kuu. 'Ga futat ra'e kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aku'iramũ 'ga ree. A'ere 'gã a'eramũ miamũ nuerowiari katu 'ga. A'eramũ Jejui 'ga 'jau 'gã nupe: —Ityp te 'au i'upyra?— 'jau 'ga 'gã nupe. —Ityp futat nũ'ũ— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","A'eramũ 'gã ipira eyra monou 'ga upe. A'eramũ 'ga ojemi'waa 'gã neape. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ojemi'war ire 'ga oporogytau 'gã nupe: —Ymã te 'ã Moisesi 'ga ka'arana kwasiari jemanũ are rakue. “Imara'ne ma'e 'gã nipo 'ga ajuka”, 'jau 'ga ikwasiaa ka'aran are rakue. Jarejuwarete 'ga je'ega mome'wara 'gã nanẽ nũ, Saumu 'jaw are ikwasiaa inuga jemanũ are rakue. A'ea ako je amome'u pẽ nupe ai'i. A'eferupi te ako 'gã je rerekoi ai'i— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A'eramũ futat Jejui 'ga 'gã mueapyou ee, ikwasiaripyrer are. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—'Awamũ tepekwaap. 'Gã nemikwasiarer imũ etee futat je manũi. Imuapyra 'ara rupi etee teferapa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","'Awamũ pe'je pejewau je mome'wau 'gã nupe. Jerusareg ipewara 'gã nupe ra'ne je mome'wau. “Jejui 'ga amanũ futat. A'ere imuapyra 'ara rupi 'ga ferawi nũ, jane katu'okaramũ. A'eramũ pẽẽ pejepoia pejetywer awi”, pe'je ki 'gã nupe. “Pejetywer awi pẽpoiriweramũ Jejui 'ga ipe'ai pẽ nui pẽ katu'oka”, pe'je ki 'gã nupe. Anure kwe pe pejewau tekotee 'gã momoranupa— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","—Peesak futat ako je manũa ai'i. 'Awamũ 'ã pẽẽ je ferawa resaka nũ. Je kwaap 'ã pejepe. “Janeruwarete 'ga je mut ae katu'okawamũ” 'ea 'ã pekwaap. A'eramũ pẽẽ pejewau je mome'wau 'gã nupe, amunawa moymoyka— 'jau 'ga 'gã nupe, oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","—A'ere 'awamũ 'au etee futat pejemogy ra'ne. 'Au futat nipo je tepãjẽ muri pẽ nupe— 'jau Jejui 'ga 'gã nupe. —Ymã te 'ã Jeruwa 'ga 'i jee: “Simono jarepãjẽa jarejerowiaara 'gã nupe 'jau”, e'i 'ga jee ikue. A'ere anure tomono oropãjẽa pẽ nupe 'jau. Pejejeupe imure'emamũ 'au etee futat iapesaka pejejupa ra'ne. Pejejeupe je imono re tãmẽjẽ tepeata je mome'wau 'gã nupe 'jau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aipo 'e re Jejui 'ga 'gã nerawau Petani pe. A'eramũ 'ga opo monou 'gã 'arimũ oporogytau 'Uwarete 'ga upe: —Ejejuka 'gã nee jee, Kiapi'ni— 'jau 'ga 'Uwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Oporogytau u'ama Jejui 'ga ojepe'au'i awau akou 'gã nui. A'ere 'ga Ruwarete 'ga 'ga mojeupirukaa 'ga monou ywag ipe 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","'Ga jeupira resakarera 'gã 'jau Jarejuwarete 'ga upe: —Ene te 'ã eneresage. Naene 'jawe rũi 'ga amũ— 'jau 'gã Jarejuwarete 'ga upe, 'ga muorypa. A'ere 'gã awau ojewya Jerusareg ipe nũ. Worywamũ 'gã awau. ");
INSERT INTO kyzNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Namutamutat 'gã nekoi Jarejuwarete 'ga mogytaaw ipe. —Ene te 'ã eneresage oree, Kiapi'ni. Naene 'jawe rũi 'ga amũ. Nitywi futari 'ga amũ kwe pe ene 'jawe— 'jau 'gã Jarejuwarete 'ga upe 'ga muorypa.");
INSERT INTO kyzNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ywy apoe'emauwe Jarejuwarete 'ga kwaawukaara 'ga akou rakue. Jarejuwarete 'ga ra'yra 'ga futat 'ga kwaawukaara janee. 'Uwarete 'ga retee futat 'ga akou rakue. 'Uwarete 'ga 'jawe futat 'ga rekoi. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ywy apoe'emauwe futat 'ga akou 'ga pyri rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Janeruwarete 'ga mama'e apoukaa 'ga upe. Nitywi futari 'ga amũ 'ga poaawamũ mama'e are rakue. Jarejuwarete 'ga kwaawukaara 'ga etee futat mama'e apou rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","'Ga futat 'ara resaukaa ae upe. Jarejuwarete 'ga 'ga ikwaawukaa nanẽ ae upe nũ. Mama'e reny 'jawe 'ga. Sã'ã ae mama'e renyramũ mama'e resak katu katua. Nan futat 'ga Jarejuwarete 'ga kwaawukaa ae upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ypytunimũ 'ã ae tata monyka. A'ere 'ã ypytunaiwa nomowewa'uweri tataa. Nan tee futat aetywera nomateepawa'uweri Janeruwarete 'ga kwaawa. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Janeruwarete 'ga 'ga amũ mua oje'ega mome'waramũ rakue. Aipo 'ga rera Juã. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aipo 'ga upe Janeruwarete 'ga 'i rakue: “Ere ewau je kwaawukaara 'ga mome'wau 'gã nupe”, 'jau 'ga 'ga upe rakue. A'eramũ Juã 'ga awau 'ga mome'wau 'gã nupe, 'ga rerowiarukaa 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","NaJuã 'ga rũi Janeruwarete 'ga kwaawukaara 'ga. A'ere 'ga ruri 'ga mome'wau te 'gã nupe rakue. —Janeruwarete 'ga kwaawukaara 'ga mome'wau je ruri pẽ nupe— 'jau 'ga 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","—'Au futat 'ga ruri. 'Ga ae mu'e oje'eg a'je are futat. Janeruwarete 'ga je'eg are nipo 'ga awau ae mu'jau. A'eramũ nipo 'ga Jarejuwarete 'ga kwaawukaa ae upe— 'jau Juã 'ga 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jarejuwarete 'ga kwaawukaara 'ga 'ut 'au ywy pe rakue. 'Au futat 'ga oporogytau ywy pewaramũ ae upe. Ymã te 'ga ywy pewaramũ ae apoi rakue. A'etea 'ã 'gã 'ga rerowiare'ema. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Opytuna 'gã ywy pe 'ga ruri. A'etea 'ã 'ga pytuna 'gã 'ga rerowiare'ema futat. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A'ere 'gã amũ 'ga rerowiari. A'eramũ 'ga werowiaara 'gã mogyau 'Uwarete 'ga ra'yramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Naywy pewara 'gã na'yra 'jawe rũi aipo 'gã. Omenar ire te 'ã kũjã wa'yramũ. A'eramũ 'ã ẽẽ mena ra'yra u'aa ẽẽ wi. A'ere nanarũi ae rekoi Jarejuwarete 'ga ra'yramũ. Wemifutar imũ etee futat Janeruwarete 'ga jane mogyau wa'yramũ. Wa'yrarete 'ga rerowiaara 'gã etee te 'ga imogyau wa'yramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jarejuwarete 'ga kwaawukaara 'ga ojemu'jaga aeramũ rakue. Jane pype 'ga akou rakue. Jane ree 'ga oporomutaramũ. 'Ga 'ã mama'e a'jea mome'wara te. Jarejuwarete 'ga nanẽ 'ga ikwaawukaa janee nũ. 'Ga futat Janeruwarete 'ga ra'yraretea. Nirũi futari 'ga. A'eramũ Janeruwarete 'ga wa'yrarete 'ga mogou oje'jawewaramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aipoa 'ga Juã 'ga imome'wau ojepyriwara 'gã nupe rakue: —Je rewiri 'ga ruri, a'e je ako pẽ nupe ikue. Jejeuwe'emauwe futat 'ga rekoi rakue. A'eramũ 'ga a'eramũ kũima'eeteeteramũ akou. Je apyraapa akou kũima'eeteeteramũ— 'jau Juã 'ga 'gã nupe rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iporomutat 'ga nanimenime jane ree. A'eramũ 'ga opota'waramũ jane ree. Mama'e esagea 'ga iapou'jau'japa janee. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ymã te Janeruwarete 'ga oje'ega monou Moisesi 'ga upe rakue. A'eramũ Moisesi 'ga janeypy 'gã mu'jau 'ga je'eg are. “'Ga je'ega renup katu katuaramũ pẽnesageay Jarejuwarete 'ga upe”, 'jau Moisesi 'ga 'gã nupe rakue. A'ere Jejui 'ga 'i janee: “Pẽtywerete agawewi 'ã pẽẽ. A'etea 'ã Janeruwarete 'ga iporomutat pẽ nee”, 'jau Jejui 'ga janee. Jejui 'ga amanũmũ janetywera mepyau. A'e pyu 'ga 'Uwarete 'ga mota'wau jane upe. 'Uwarete 'ga je'eg are nanẽ 'ga jane mu'jau nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nitywi 'ga amũ Janeruwarete 'ga resakara mũ. 'Ga ra'yrarete 'ga etee te 'ga wesak. A'eramũ 'ga etee futat 'Uwarete 'ga kwaawukaa janee. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judeu 'gã 'wyria'ri 'gã amũ akou Jerusareg ipe. A'e 'gã 'jau mainana 'gã amũ nupe, Levita 'gã amũ netee: —Pe'je pejewau pejeporonupa Juã Batista 'ga upe. “Maranuaramũ te ereko?” pe'je ki pejewau 'ga upe— 'jau 'gã 'gã nupe. A'eramũ 'gã awau 'yrete pe, Jotãuy pe. Ty owajara katy 'gã awau. Amunawa mũ pyri 'gã awau, Petani 'jawa pyri. Owaẽmawe 'gã 'jau Juã 'ga upe: —Maranuaramũ te ereko, aru'e ore enee kũi?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","A'eramũ Juã 'ga 'jau 'gã nupe: —Jarejuwarete 'ga remimura 'ga rapesakara nipo peko. Naa'eramũ rũi je rekoi— 'jau etee Juã 'ga aipo 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","A'eramũ 'gã 'jau 'ga upe nũ: —Maranuaramũ ajee ereko ki 'ei? Eliasiramũ nipo ereko? Saa'e ene rekoa 'ager imũ Jarejuwarete 'ga mome'ua 'gã nupe rakue. A'eramũ nipo ene?— 'jau 'gã 'ga upe. —Naani. Na'ga rũi je— 'jau etee Juã 'ga 'gã nupe aipo 'ga 'eramũ. —Jarejuwarete 'ga je'ega mome'waramũ te ra'u ene nũ? Oreremiapesaga 'ga futat te ra'u ene nũ?— 'jau 'gã 'ga upe. —Naani. Naaipo arũi je— 'jau etee Juã 'ga 'gã nupe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","A'eramũ 'gã 'jau Juã 'ga upe nũ: —Ejemome'u oree. Maran ajee ore aramuarera 'gã nupe ene mome'ui ki 'ei?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A'eramũ Juã 'ga 'jau 'gã nupe: —Ajemome'u je pẽ nupe. Pẽnea'at nipo Jarejuwarete 'ga je'ega mome'wara 'ga je'eger are? Isai 'ga je'eger are? Ymã te 'ã Janeruwarete 'ga ka'arana kwasiarukari Isai 'ga upe rakue: “Amunawe'em ipe 'ga amũ rekoi wafukaita. ‘Pekwap Jarejararete 'ga rape katu'oka imonou 'ga renune’, 'jau 'ga amũ wafukaita akou”, 'jau Isai 'ga ikwasiaa inuga rakue— 'jau Juã 'ga 'gã nupe. “Pekwap Jarejararete 'ga rape katu'ok imonou 'ga renune” 'ea “pejetywer awi pepoit” 'ea. A'eramũ Juã 'ga aipo 'ga 'eawer imũ etee futat 'ua wafukaita ojepyriwara 'gã nupe. —Pejetywer awi pepoit. Pe'je pejejekatu'oka Jarejararete 'ga ruawamũ, 'jau je 'ã pẽ nupe tekou— 'jau Juã 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aipo 'erauwe fariseu 'gã nemimurera 'gã 'jau nũ: ");
INSERT INTO kyzNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Ma'eramũ ajee 'gã erepymĩ ekoete ekou 'ũ? “NaJarejuwarete 'ga remimurera rũi je. NaEliasi 'ga rũi je. Napẽnemiesaga rũi je”, ere te 'ã oree— 'jau 'gã Juã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ojeupe aipo 'erauwe Juã 'ga 'jau 'gã nupe: —Je futat 'ã apymĩ 'gã 'y pe. A'ere 'ga amũ rekoi pẽ pype. Nepekwaawi we te 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Je rewiri te nipo 'ga ruri. 'Ga te kũima'eeteetea. Je nakũima'eeteete rũi. Je akotee'i ma'ea te— 'jau Juã 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jotãuy pe Juã 'ga otywer awi opoit ma'e 'gã pymĩnamũ 'gã 'ua oporonupa ee 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ai'iwe Juã 'ga Jejui 'ga resaka. Wepejãn 'ga ruramũ 'ga 'ga resaka. A'eramũ Juã 'ga 'jau tekotee 'gã nupe: —Pe'je pejemã'jãu 'ga ree. Kwe 'ga ako je amome'u pẽ nupe ai'i. Kweramũ Janeruwarete 'ga remimurera 'ga ruri. Sã'ã mainana 'gã karupa'mĩ jukaa iapya Jarejuwarete 'ga upe. A'e resag ire 'ã Janeruwarete 'ga janetywera moia jane wi. Nan tee futat nipo kwe 'ga. Anure 'ga manũi janetywera moiawamũ. 'Ga manũ are nipo Janeruwarete 'ga janetywera moia jane wi— 'jau Juã 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","—Kaaruwamũ ako je 'ga mome'ui pẽ nupe ai'i. “Je rewiri 'ga ruri”, 'jau je ako pẽ nupe ai'i. “'Ga kũima'eeteetea. Naje 'jawe rũi 'ga”, 'jau je ako pẽ nupe te'ama kaaruwamũ ai'i. “Je rewiri 'ut ma'e 'ga jejeuwe'emauwe 'ga rekoi rakue”, 'jau je ako pẽ nupe ai'i— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","34","—Ymã te Janeruwarete 'ga 'i jee ikue: “Ere ewau 'gã pymĩãu 'y pe, otywer awi 'gã poira resaukaawamũ tekotee 'gã nupe. Anure 'ga amũ ruri ojepymĩãukaa enee. 'Ga ree tereesak je 'Agesage jywa pykau 'jawe 'jau”, 'jau Janeruwarete 'ga jee ai'i— 'jau Juã 'ga 'gã nupe. —“Aipo 'ga anure nipo je 'Agesage omono pẽ nupe pẽnerekwaramũ”, 'jau Janeruwarete 'ga jee ai'i— 'jau Juã 'ga 'gã nupe. —“Je 'Agesagea tepẽ momyau 'jau”, 'jau Janeruwarete 'ga jee ikue— 'jau Juã 'ga 'gã nupe. —A'ea je aesak 'ga ree ai'i. 'Ga pymĩ re 'ua ojypa pykau 'jawe ai'i— 'jau Juã 'ga 'gã nupe. —A'eramũ “'ga futat Jarejuwarete 'ga ra'yra”, a'e je ako pẽ nupe ai'i— 'jau 'ga 'gã nupe. —Ymã te je 'i te'ỹina tejeupe ikue: “Awỹja sipo poromũ Aeruwarete 'ga amut oree oretywera moiawamũ?” 'jau je te'ỹina tejeupe ikue. Je nanẽ 'ga kwaape'ema futat ikue nũ. A'etea ako je ojot pẽ pymĩãu 'y pe tekou ai'i— 'jau 'ga 'gã nupe. —Ae pymĩãu je ruri Jarejuwarete 'ga ra'yra 'ga kwaawukaawamũ Israeu 'ga juapyreramũ pẽ nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ai'iwe Juã 'ga oporogytau u'ama wemiayuwa 'gã nupe nũ. Mukũja 'gã nupe oporogytau u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Poje Jejui 'ga okwapa 'gã pyu. 'Ga resakawe Juã 'ga 'jau wemiayuwa 'gã nupe: —Kweramũ Janeruwarete 'ga remimurera 'ga kwawi. Karupa'mĩ 'jawe futat nipo 'ga manũi janetywera moiawamũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ojeupe 'ga mome'urauwe Juã 'ga remiayuwa 'gã awau Jejui 'ga rewiri. A'eramũ futat 'gã Jejui 'ga ree ojemojo'okaipa Juã 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Wewiri 'gã orauwe Jejui 'ga ojerowaka 'gã nee: —Ma'ja are te peko?— 'jau 'ga 'gã nupe. —Naani. Ma'ape te ene'wyra, aru'e tee ore enee— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Pe'je pejejua je rupi. Tepeesak 'jau— 'jau 'ga 'gã nupe. A'eramũ 'gã awau Jejui 'ga rupi. Awau 'gã owaẽma 'ga rekwawa upe 'ga pyri. Kwara jerewamũ 'gã awau owaẽma. Owaẽm ire 'gã 'upa oporogytau kwara rese poromukuran. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Jejui 'ga rewiri oo ma'e 'ga amũ rera Andrea. Juã 'ga Jejui 'ga mome'ua renuparera poromũ. A'eramũ Andre 'ga awau 'ga rewiri. A'ere Andre 'ga awau weki'yra 'ga rog ipe, Simão 'ga rog ipe: —Janeruwarete 'ga remimurera 'ga ore aruesak ai'i— 'jau 'ga weki'yra 'ga upe awau. Kristu 'jau 'gã Jarejuwarete 'ga remimurera 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A'eramũ Andre 'ga weki'yra 'ga rerawau Jejui 'ga upe. 'Ga resakawe Jejui 'ga 'jau 'ga upe: —Simão nipo enerera. Eneruwa 'ga rera Juãa. 'Awamũ je ene re'rogi. Sefa je anug ene ree— 'jau 'ga 'ga upe. 'Gã je'eg imũ Sefa 'ga inuga 'ga ree. Pedro 'ea futat poromũ. Pedroa 'ea itaa. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ai'iwe Jejui 'ga 'jau 'gã nupe: —Garireja ywy pe je oi— 'jau 'ga 'gã nupe. Wata enunewe Jejui 'ga awau Filipe 'ga rekaa. 'Ga resakawe 'ga Filipe 'ga mo'wya: —Ere ejua je rupi— 'jau 'ga 'ga upe. —Nai'i— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe 'ga Pesaita pewara. Simão Pedro 'ga, Andre 'ga. Mĩmera 'gã aipo pewara. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Omo'wyrauwe Filipe 'ga awau Natanaeu 'ga rekaa. 'Ga resakawe 'ga 'jau: —Ymã te 'ã Moisesi 'ga ka'arana kwasiari inuga 'ga amũ ree rakue. Aipo 'ga ore aruesak. Jarejuwarete 'ga je'ega mome'wara 'ga nanẽ ka'arana kwasiaa 'ga ree rakue nũ— 'jau 'ga 'ga upe awau. —'Ga futat ore aruesak ai'i. Jose 'ga ra'yra 'ga. Jejui 'ga. Nasare awi 'ga ruri— 'jau 'ga Natanaeu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aipo 'ga 'eramũ Natanaeu 'ga 'jau: —A'jea sipo? Nasare awi sipo mama'e esage ruri?— 'jau Natanaeu 'ga Filipe 'ga upe, aipo 'eramũ. —Ere ejua 'ga resaka— 'jau Filipe 'ga 'ga upe. A'erauwe 'ga awau 'ga resaka 'ga rupi. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Werowygauwe Jejui 'ga Natanaeu 'ga resaka. —Koromũ esage ma'e 'ga. Israeu 'ga juapyrerarete 'ga— 'jau 'ga 'ga resakawe. —Ni'mei 'ga. Mama'e a'jea te tee noko 'ga omome'u. Niporerekoemãi 'ga— 'jau Jejui 'ga 'ga upe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—Kuu. 'Awamue te 'ã je resag ape kũi. Maran ene a'eramũ je kwaapa ki 'ei?— 'jau 'ga Jejui 'ga upe aipo 'eramũ. —Figueira 'ywa 'wyr ipe ene renamũ je ene resagi ai'i. Ene upe Filipe 'ga porogyta enunewe je ene resagi ai'i— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Kuu. Jarejuwarete 'ga ra'yraretea futat nipo ajee ene ki sa— 'jau Natanaeu 'ga Jejui 'ga upe. —Ene 'ã 'wyriararetea oree, Israeu 'ga juapyreramũ oree— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—Figueira 'ywa 'wyr ipe je ene resagi 'erauwe te je rerowiar ape ra'e?— 'jau Jejui 'ga 'ga upe. —Anure nipo mama'e esagea pẽnemiapoe'ema futat je iapoi. Aipoa tereesak 'jau— 'jau Jejui 'ga Natanaeu 'ga upe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A'eramũ Jejui 'ga 'jau 'gã nupe najuejue etee: —Mama'e a'jea te tee je amome'u pẽ nupe. Je 'ã pẽneki'yraretea. Anure nipo pẽẽ ywaga woga resaka. Ywagipewara 'gã jywa je ree tura nipo pẽẽ esaka. 'Gã jeupira nanẽ nipo pẽẽ esaka nũ. A'eramũ nipo pẽẽ 'jau: “A'jea futat. Janeruwarete 'ga remimurera 'ga ra'e”, 'jau nipo pẽẽ jee aipo resag ire— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Mukũi oser ire Jejui 'ga awau ajepeja amunaw ipe, Kana 'jaw ipe. Peu 'gã amũ akoukatu. A'eramũ 'gã maraka apou 'gã ajuerekokatuawamũ. A'eramũ akokatu ma'e 'ga Jejui 'ga y ẽẽ mo'wya wekokatu resaka. Jejui 'ga nanẽ imo'wya nũ. 'Ga remimu'eramũ nanẽ ore mo'wy'wya 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","A'ere maraka teepawe'emauwe y'way teepawamũ 'gã nui, 'gã nekokatuawa rewara teepawamũ 'gã nui. A'eramũ Jejui 'ga y ẽẽ 'jau 'ga upe: —Si'ri. Y'waya teepap— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aipo 'eramũ ẽẽ ra'yra 'ga 'jau ẽẽ upe: —Tene ra'ne. Nowaẽmi we futat Janeruwarete 'ga pãjẽ resaukaawa upe jee— 'jau 'ga oy ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aipo 'ga 'eramũ 'ga y ẽẽ 'jau maraka'ywa 'ga remiayuwa 'gã nupe: —Jera'yra kĩã 'eawer imũ etee ki peapo mama'ea— 'jau ẽẽ 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aipoa 'gã jatykaaw ipe 'y ryrũa 'upa. Tuwiuu ma'ea. Aipoa 'y ryrũa 100 litro pyyka. Itakanafũa poromũ. 'Gã jepoeitawa yrũa futat. Judeu 'gã au'jeteramũ ojepoeita ojekatu'okawamũ Jarejuwarete 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","A'ere Jejui 'ga oje'ega maraka'ywa 'ga remiayuwa 'gã nupe: —Pe'je pejewau 'y rerua 'y ryrũ pype imatyneema— 'jau 'ga 'gã nupe. Aipo 'ga 'erauwe maraka'ywa 'ga remiayuwa 'gã 'y rerawau 'y ryrũ matyneema. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","'Y ryrũa 'gã imatyneem ire Jejui 'ga oje'ega imatyneemarera 'gã nupe: —Pe'je ara jaraa erawau maraka'ywa 'ga upe— 'jau 'ga 'gã nupe. A'erauwe 'gã ara jaraa erawau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ojeupe erurauwe maraka'ywa 'ga itykua esaka. A'ere 'ga itykure'emauwe ijemu'jagi y'wayramũ, uwayramũ. Maraka'ywa 'ga nokwaawi 'y jemu'jaga y'wayramũ. A'ere 'ga remiayuwa 'gã ikwaawi futari. 'Ga itykura resakawe 'ga akokatu ma'e 'ga renũina. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Esageay ma'ea ra'ne te 'ã y'waya neretykurukari jarejee rai'i. 'Gã itykupaw ire amunipo 'ã y'waynana rykurukaa 'gã nupe rai'i. A'ere 'ã ene y'waynana ra'ne eretykurukat 'gã nupe. Y'wayrete mỹina mapawamũ itykurukaripyramũ 'gã nupe rai'i— 'jau 'ga akokatu ma'e 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aipo resaka taetu ore, 'ga remimu'eramũ, 'ga rerowiaa. —Jarejuwarete 'ga pãjẽa futat 'ga wereko ra'e— 'jau ore arajaupe. Kana 'jawa amunaw ipe ra'ne Jejui 'ga aeremiapoe'ema apo ypy ypy oree ikue. 'Uwarete 'ga pãjẽ resaukaa oree ikue. Aipoa amunawa 'upa Garireja ywy pe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Aipo apo re Jejui 'ga awau ajepeja amunaw ipe nũ, Kafanaũ pe nũ. 'Ga y ẽẽ, 'ga rewirera 'gã, 'ga remimu'eramũ 'jau ore arawau 'ga rupi ikue. Peu oropytawaipa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Egitu ywy awi oroypy ypy 'gã nenũ'ẽawer are wea'awa maraka apoawa upe iwaẽm ja'wyja'wyrauwe ore arawau Jerusareg ipe. Peu ore arawau orosou Jarejuwarete 'ga mogytaaw ipe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","'Ga mogytaaw ipe osouwe Jejui 'ga wyra me'egara 'gã nesaka. Kwaiwete wyra me'egara 'gã 'upa peu. Kwatau, karupa'mĩ, pykau. Mĩmera 'gã ime'ega 'upa. Amumera 'gã ajemogyau 'yjepana pyri ka'aranũũ mojopy'rau judeu ka'aranũũ are. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","'Gã nesakawe Jejui 'ga tupaama pyyka wyra mopikawamũ. A'eramũ 'ga ipyu imonou imũ'jãu jui. Kwatau, karupa'mĩ. Mĩmera 'ga imonou imũ'jãu jui. Ka'aranũũ mojopy'ruara 'gã 'yjepana 'ga imonou imuewiwya imojerepa 'gã nui. Ka'aranũũ monou imomopomopoa futat 'gã nui. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pykau me'egara 'gã nupe 'ga oje'ega: —Pe'je pykau rerawau enũ'jãu. Au'je Jeruwarete 'ga mogytaawa mỹi re pykau me'egawamũ— 'jau 'ga oje'ega moywyrafena 'gã nupe. —Au'je Jeruwarete 'ga mogytaawa mỹi re wyra me'egawamũ. 'Ga muorypawa te 'ã 'aga 'oga— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aipo renupawe orojea'aramũ ikwasiaripyrer are. A'eramũ ore 'jau arajaupe: —Ymã te Janeruwarete 'ga ka'arana kwasiarukari 'gã nupe aipo are rakue— 'jau ore arajaupe. —“Ku'jyp. Mama'e tywera 'gã wapo enemogytaawa 'og ipe. A'eramũ je temara'neramũ 'gã nee. A'eramũ je tejejukau enerog are”, 'jau 'ga amũ ikwasiaa inuga ymã rakue— 'jau ore arajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A'e pype judeu 'gã 'wyria'ri 'gã 'ua oje'ega Jejui 'ga upe: —Ma'eramũ ene 'gã mũ'jãu 'ũ? Awỹja 'gã mũ'jãukaa enee ki 'ei?— 'jau 'gã 'ga upe. —Jarejuwarete 'ga emur ire aeremiapoe'ema eapo amũ oree 'ga pãjẽ mũ kũi. A'e resag ire taru'e enee 'jau: “A'jea futat 'ga 'gã mũ'ẽi Ku'jywa 'ga je'eg imũ ra'e”, taru'e enee 'jau kũi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—'Aga 'oga retyg ire je imuapyra 'ara rupi etee imowyri kũi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Kuu. Ereapo ekoete awi nũ'ũ. Namuapyra 'ara rupi etee rũi 'gã 'aga 'oga apoi rakue kũi. Kwarẽtai seis te 'gã kwara magwawi 'aga 'oga apoupap rakue kũi— 'jau 'gã 'ga upe aipo 'ga 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","A'ere 'ga naoga tee rũi imome'ui 'gã nupe. 'Aga 'oga 'eramũ 'ga wete are te 'ga oje'ega rerekoi. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","A'eramũ ore anure Jejui 'ga remimu'eramũ 'ga 'eawer are orojea'aramũ, 'ga feraw ire ikue. “A'jea futat Jejui 'ga imome'ui ikue”, 'jau ore arajaupe. A'eramũ ore Jarejuwarete 'ga je'ega rerowiaa. Jejui 'ga 'eawera nanẽ ore erowiaa nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusareg ipe Jejui 'ga kwaiwete aeremiapoe'ema apou 'Uwarete 'ga pãjẽ mũ ikue. Aipo resag ire kwaiwete 'gã 'ga rerowiaa. A'ere amumera 'gã 'ga rerowiat 'mei etee. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","A'eramũ Jejui 'ga ojemogypyyke'ema 'gã nee. Okwaap 'ga 'gã. Wereko tywearama 'gã 'ga ikwaapa. A'eramũ 'ga ojerowiare'ema 'gã nee. ");
INSERT INTO kyzNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A'eramũ Jejui 'ga oporonupe'ema ee: “Ma'ja e'i sipo 'gã ajaupe?” 'jawe'em Jejui 'ga 'gã nupe. Jejui 'ga ae kwaapa. Aerea'awa miamũ 'ga okwaap katu katu. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Poje Nikutemu 'ga 'ua oporogytau Jejui 'ga upe. Nikutemu 'ga opytuna 'gã nupe oje'ẽma'ea. Fariseua nanẽ 'ga nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ypytunimũ Nikutemu 'ga 'ua oporogytau Jejui 'ga upe: —Janeruwarete 'ga 'ga amut jane mu'jawamũ, aru'e ore arajaupe ene ree jepi. Janeruwarete 'ga remiayuwamũ etee ae aeremiapoe'ema apoi. 'Ga remiayuwe'emamũ ae nuapoa'uweri. A'eramũ ore 'jau enee: Janeruwarete 'ga pãjẽ mũ futat 'ga mama'e apoi. A'eramũ ore 'jau arajaupe: Janeruwarete 'ga remimurera 'ga futat ra'e, 'jau ore arajaupe— 'jau Nikutemu 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aipo 'erauwe Jejui 'ga 'jau 'ga upe: —Mama'e a'jea je amome'u amũ enee. 'Ga amũ nipo u'aru'jape'ema. A'eramũ 'ga nosea'uweri Jarejuwarete 'ga rupaw ipe awau— 'jau Jejui 'ga Nikutemu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A'eramũ Nikutemu 'ga 'jau: —Maran ae kũima'eramũ u'aru'japa nũ ki 'ei? Maran ae waranuw ire osou awau oy reweg ipe nũ ki 'ei?— 'jau Nikutemu 'ga Jejui 'ga upe aipo 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","—Pejey awi peje'aa pẽẽ ẽẽ mena ra'yra futat. A'ere Janeruwarete 'ga werowiar ire te pẽ mogyi wa'yramũ. A'eramũ 'ga U'agesage mua pẽ nupe pẽnerekwaramũ. A'eramũ pẽẽ pejejemogyau u'aru'jap ma'e 'jawe. 'Ga 'Agesage rerekware'ema 'gã nu'aru'jawi— 'jau 'ga Nikutemu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","—Eneporesag awi je ree aipo ejeupe 'eramũ. A'jea futat je 'i enee. E'aru'jaw iki, a'e je enee. Aipoa a'jea futat. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sã'ã ywytua. Neresaga'uweri 'ã ywytua. Ifua etee 'ã ereenup. Nerekwaawa'uweri tuawa. Nerekwaawi nanẽ iwawa nũ. Nan tee futat Janeruwarete 'ga 'Agesagea. Neresaga'uweri 'ga 'Agesagea. Wemifutar imũ etee te Janeruwarete 'ga U'agesage monoi 'gã amũ nupe, 'gã mu'aru'japa nũ. A'ere nenereapyoi ee— 'jau Jejui 'ga Nikutemu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Maran poa ojeapou ki 'ei? Nakwaawi je ene'ea ki 'ei— 'jau Nikutemu 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A'eramũ Jejui 'ga 'jau 'ga upe nũ: —Ene 'ã moromu'jara agawewi Israeu 'ga juapyrera 'gã nupe. A'etea 'ã ene jeje'ega kwaape'ema? ");
INSERT INTO kyzNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mama'e a'jea te je amome'u pẽ nupe. Orojemikwaawa 'ã ore oromome'u pẽ nupe, orojemiesaga retee. A'etea 'ã neperowiari oreje'ega— 'jau 'ga Nikutemu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","—Ywy pewara agawewi je 'ã amome'u mama'ea pẽ nupe. A'etea 'ã naje rerowiari pejepe. Maran sipo ajee je rerowiat pejepe ywag ipewara mama'ea je imome'uramũ?— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","—Nitywi ae ywag ipe oo ma'eferamũ. Je tee te 'ã ojot ywag awi ikue. A'eramũ je tejemiesagera mome'wau pẽ nupe. Je 'ã pẽneki'yra futat. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","—Enerea'at nipo ene jareypy are? Moja a'agawa apoawer are? Ymã te janeypy 'gã atai awau jũ me rakue. A'ere 'gã kwaiwete nuenuwi Jarejuwarete 'ga je'ega. A'eramũ 'ga oje'ega renupare'ema 'gã u'waukaa moja upe. A'eramũ Janeruwarete 'ga 'jau Moisesi 'ga upe: “Ita eapo moja a'agawamũ. A'ere imonou imu'ama ikutuka 'yw are”, 'jau 'ga Moisesi 'ga upe rakue. A'eramũ Moisesi 'ga ita apou moja a'agawamũ rakue. Aipo apo re 'ga imonou imu'ama 'yw are rakue. A'eramũ moja remiu'ufera 'gã amã'jãu aipo itamoi a'agaw are. A'eramũ futat moja remiu'ufera 'gã oferapap. Namanũi futari 'gã. Nan tee futat nipo imara'ne ma'e 'gã je monoi 'ypeywar are je mu'ama— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","—A'eramũ nipo je rerowiaara 'gã juejue awau ajemogyau Jarejuwarete 'ga pyri amanũu'jape'ema futat— 'jau Jejui 'ga Nikutemu 'ga upe, 'ga mu'jau ojee. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Janeruwarete 'ga iporomutat nanimenime pẽ nee. A'eramũ 'ga a'eramũ wa'yramũ je mua 'au ywy pe ikue. Majepei tee agawewi je 'ga ra'yramũ. A'etea 'ga je mut 'awa ywy pe je jukaukaa pẽ nupe. A'eramũ je rerowiaara 'gã amanũmũ numiamũ. A'ere 'gã oi oferapa Jarejuwarete 'ga rupaw ipe 'ga pyri amanũu'jape'ema futat. Peu futat 'gã jemogyi nakwaparimũ ete rũi— 'jau Jejui 'ga Nikutemu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","—Napẽ nereko tyweawamũ rũi 'ga je muri 'au ywy pe. Pẽ katu'okawamũ te 'ga je muri— 'jau 'ga Nikutemu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","—Jeruwarete 'ga je rerowiaaramũ pẽ nerekou tywere'em. A'ere 'ga je rerowiare'ema 'gã nupe 'ga 'i: “Pejerekoukat tywet futat nipo”, 'jau. Naje rerowiari 'gã. A'eramũ 'ga aipo 'jau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Janeruwarete 'ga ra'yramũ je tejua 'au ywy pe pẽ mu'jau Tejuwarete 'ga ree. A'ere pẽẽ mũ nepẽporokwaawiweri 'ga ree. 'Ga remifutar are nanẽ pẽẽ pejeporokwaawiwere'emamũ nũ. Mama'e tywera etee pẽẽ iapou. A'eramũ pẽẽ mama'e esage are pejeporokwaawiwere'emamũ. A'eramũ nipo Janeruwarete 'ga aipo 'gã nerekou tyweaete 'gã manũ re— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","—Mama'e tywera apoara 'gã nioweri Jarejuwarete 'ga ra'yramũ je pyri. Naapoi futari je mama'e tywera. A'eramũ mama'e tywera apoara 'gã ojenosõu je pyri oo awi. “Omo'gõguu je 'ga tewau 'ga pyri ne”, 'jau itywet ma'e 'gã ojenosõu je wi. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A'ere mama'e esage apoara 'gã nuri Jarejuwarete 'ga ra'yramũ je pyri katu katu futat. A'eramũ nipo 'gã nesakara 'gã 'jau: “A'jea futat. Jarejuwarete 'ga je'ega 'gã werowiat”, 'jau nipo 'gã 'gã nemiapofera resag ire— 'jau Jejui 'ga Nikutemu 'ga upe, 'ga mu'jau ojee. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A'e awi Jejui 'ga wemimu'eramũ ore rerawau Judeja ywy pe nũ. Peu ore oropytawaipa. Peu futat 'ga 'gã amũ pymĩãu 'y pe, otywer awi 'gã poira resaukaawamũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juã 'ga nanẽ 'gã amũ pymĩãu akou ajepeja amunaw ipe, Enom 'jaw ipe. Enom 'jawa 'upa Salim 'jawa pyri. Peu typyu'iramũ 'ya. A'eramũ 'ga 'gã pymĩãu akou peu. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Moromunepawa pype amunewe'emauwe Juã 'ga 'gã pymĩãu akou aipo pe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A'eramũ Juã 'ga remimu'e 'gã amũ oje'ega moywyrafena judeu 'ga amũ upe. Ae pymĩ are 'gã ajamueu. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","A'eramũ Juã 'ga remimu'e 'gã amũ awau oporogytau 'ga upe: —Enerea'at te ene ejemimome'uawera 'ga ree? Jotãu tyowajara katy 'ga rekoi ene retee rakue. 'Awamũ nanẽ 'ga akou 'gã pymĩãu 'y pe nũ. A'eramũ 'gã awaupap 'ga rewiri ojepymĩãukaa 'ga upe. Ene rewiri ako ma'efera 'gã we futat awau ojepymĩãukaru'japa 'ga upe nũ— 'jau 'gã awau imome'wawayau Juã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A'eramũ Juã 'ga 'jau wemimu'e 'gã nupe: —Je nanẽ jerekõẽãi 'ga ree nũ. Sã'ã Janeruwarete 'ga je monoa je moporowykyukara ojeupe ikue. Nan tee futat 'ga Jejui 'ga monoi imoporowykyaukaa ojeupe. Ojeupe Janeruwarete 'ga ore moporowykyukare'em ire amunipo 'ã ore noroporowykyi 'ga upe— 'jau 'ga imome'wau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","—A'e je ako pẽ nupe ai'i: “NaJarejuwarete 'ga remimurera rũi je. 'Ga renunewara te je”, 'jau je ako pẽ nupe ai'i— 'jau Juã 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","—Sã'ã aeku'ia ajuee kũjãmuku rerekokaturamũ. Nan tee futat jeku'iramũ tekou 'ga ree. “Kwaiwete 'gã oi 'ga rewiri” 'e renupa jeku'iramũ— 'jau Juã 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","—Jejui 'ga rewiri oo ma'e 'gã ojeme'yi kwaiwete futat. Je rewiri oo ma'e 'gã te ajee nojeme'yi futari. Jema'e 'gã inãinãnĩ'ĩ etee futat— 'jau Juã 'ga 'gã nupe. —Nanuara futat esage je upe— 'jau etee Juã 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ywy pewara 'gã akotee ma'ea futat. Wemiapo'i are tee 'gã porogytai. A'ere ywag awi 'ut ma'e 'ga nanarũi. 'Ga a'jea futat 'ga kũima'eeteetea. 'Ga ree te a'jea futat ae jemogypyygaretei. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ywag ipe wemiesagera ywag awi 'ut ma'e 'ga imome'wau. Wemienuwera nanẽ 'ga imome'wau nũ. A'ere 'gã inãinãnĩ'ĩ etee 'ga rerowiari. Nuerowiari 'gã kwaiwetewete 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","'Ga je'ega rerowiaara 'gã 'jau ajaupe: —A'jea futat 'ga Janeruwarete 'ga je'ega kwaawukaara 'ga ra'e— 'jau 'gã ajemogyau ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Janeruwarete 'ga U'agesage muapap wemimurera 'ga upe. A'eramũ 'ga amuarera 'ga je'ega mome'wau katu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Janeruwarete 'ga oporomutaramũ wa'yra 'ga ree. A'eramũ 'ga opãjẽ mua wa'yra 'ga upe. A'eramũ 'ga 'jau: —Tepãjẽa je omono teja'yra 'ga upe. A'eramũ 'ga mama'e esage apou jee— 'jau 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Janeruwarete 'ga ra'yra 'ga rerowiaara 'gã ajemogyau ipyauramũ. Amanũ re 'gã awau Jarejuwarete 'ga pyri. Peu futat 'gã ajemogyau namutat. A'ere 'ga je'ega renupare'ema 'gã nanarũi. Nooi futari 'gã Jarejuwarete 'ga pyri amanũ re. Nuenuwi 'gã 'ga ra'yra 'ga je'ega. A'eramũ nipo 'ga 'gã nerekou tyweaete wojere'emamũ futat. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Anure 'gã amũ awau Jejui 'ga mome'wau fariseu 'gã nupe: —Ekoay Jejui 'ga kwaiwete 'gã pymĩãu 'y pe. Wemiayuwamũ 'ga 'gã pymĩ kwaiwete— 'jau 'gã awau imome'wau fariseu 'gã nupe. —Juã 'ga 'ã kwaiwete agawewi 'gã opymĩ. A'ere Jejui 'ga te Juã 'ga remipymĩmera 'gã apyraawi— 'jau 'gã awau imome'wau fariseu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Na'ga rũi agawewi 'gã pymĩãu 'y pe. 'Ga remimu'eramũ agawewi ore 'gã pymĩ. A'etea 'gã “Jejui 'ga 'gã opymĩ 'y pe”, e'i imome'wau fariseu 'gã nupe). ");
INSERT INTO kyzNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseu 'gã nupe omome'u kwaaw ire, Jejui 'ga awau Judeja ywy awi. —Garireja ywy pe soo jarejewya 'jau nũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","—A'ere jeoweramũ Samari ywy pyterimũ. Kwe rupi futat jarewau jarewaẽma Garireja ywy pe— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A'eramũ ore arawau Samari ywy rupi. Arawau orowaẽma amunawa mũ upe. Sika 'jawa upe orowaẽma. Peu ore oropytawaipa. Ymã te janeypy 'ga, Jako 'ga ywy pe monoi wa'yra 'ga upe, Jose 'ga upe rakue. Sika 'jawa 'upa aipo ywya pyri. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Peu Jako 'ga remiywykaiwera ywy kwawukuua 'ũina, 'ymuawa. Aje kwara kwawamũ arawau orowaẽma 'ymuawa upe. A'eramũ Jejui 'ga afuakapawamũ. A'eramũ 'ga wapyka 'ũina 'ymuawa reme'y'warimũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","'Ga pytu'uramũ ore arawau amunaw ipe orojemi'urama mua. Orojemi'urama mua ore orauwe Samari pewara ẽẽ mũ 'ua 'y piaramũ. A'eramũ Jejui 'ga 'jau ẽẽ upe: —Emut ara 'ya jee— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A'eramũ ẽẽ 'jau 'ga upe: —Ma'eramũ ene eje'ega jee rã, judeuramũ rã?— 'jau ẽẽ 'ga upe. —Je Samari pewara— 'jau ẽẽ 'ga upe. Judeu 'gã niporomutari Samari pewara 'gã nee ra'e jepi. A'eramũ ẽẽ judeu ojeupe ije'egamũ aipo 'jau 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A'eramũ Jejui 'ga 'jau ẽẽ upe nũ: —“'Ya emut ara jee”, a'e ako je enee ko. A'ere 'ã naje kwaawi te ape. Jarejuwarete 'ga remimurama nanẽ nerekwaawi nũ— 'jau 'ga ẽẽ upe. —Je kwaaw ire amunipo 'ã “'Ya emut ara jee”, ere jee ra'e. 'Ya tejeupe ene enũi re amunipo je 'ã 'y monoi enee ra'e— 'jau 'ga ẽẽ upe 'ũina. —Je remimonoa amunipo 'ã ene mogou nakwaparimũ warãu rũi— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aipo ojeupe 'ga 'eramũ ẽẽ 'jau 'ga upe: —Nenetywi 'y muawa pyu. Ikwawukuu 'ymuawa. A'eramũ ene imuawa pyu etywe'emamũ, maran sipo ene 'y mua jee?— 'jau ẽẽ 'ga upe. Naeapyoi ẽẽ ojeupe 'ga 'e are. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","—Janeramỹiwera kĩã Jako te 'ã kũima'eeteetea ako rakue. Ymã kĩã futat ywy kwawukuu ywykajukari 'ymuawamũ rakue. 'Aga 'ymuawa pypewara 'ya futat kĩã itykua rakue. Kĩã ra'yra wã, kĩã reymap. Mĩmera oy'wau 'au rakue. 'Awamũ kĩã remiapofera orema'ea futat 'ũina— 'jau ẽẽ 'ga upe. —“Je te jarejamỹja aapyraap”, ere te jee poromũ?— 'jau ẽẽ Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A'eramũ Jejui 'ga 'jau ẽẽ upe: —'Aga 'y rykuara 'gã oo o'yuweju'jawa futat nũ— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","—A'ere 'gã jema'e tykur ire ni'yuweju'jawi akou. Jema'ea 'ywu'ywura 'jawe tee 'ũi itykuara 'gã ywyteripe, 'gã mogyau nakwaparimũ rũi futat— 'jau 'ga ẽẽ upe. —Sã'ã 'ywu'ywura rypawe'ema. Nan futat jema'ea. Jema'ea ae mogyau namutat. Jema'ea rykur ire nene'yuweju'jawi futari— 'jau 'ga ẽẽ upe. —Jeporoywera ene mogo nakwaparimũ rũi futat— 'jau Jejui 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A'eramũ kũjã ẽẽ 'jau 'ga upe: —Ere ajee ema'e ara mua jee rã. A'eramũ je te'yuweju'jawe'emamũ, tejoru'jape'ema 'au 'y piaramũ— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Ere ajee ewau emena 'ga rerua 'au jee ra'ne— 'jau Jejui 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aipo ojeupe 'ga 'eramũ ẽẽ 'jau: —Najemeni je tekou— 'jau ẽẽ 'ga upe. A'eramũ Jejui 'ga 'jau ẽẽ upe: —A'jea futat ere nũ ĩ. Nenemeni futari ene nũ ĩ. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nenemenu'jau'jawi tãmẽjẽ futat ene nũ ĩ. Nomoygi tãmẽjẽ futat sĩku pyu nũ ĩ— 'jau Jejui 'ga ẽẽ upe, aipo 'eramũ. —A'jea futat 'awamũ nenemeni futari. Ene pyri ako ma'e 'ga naenemena rũi futat— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aipo ojeupe 'ga 'eramũ ẽẽ 'jau 'ga upe: —Koo. Maran ene je kwaapa a'i rã? Ene futat nipo Jarejuwarete kĩã je'ega mome'wara. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ymã te oreypya Jarejuwarete kĩã muorywi 'au futat rakue. A'ere pẽẽ judeuramũ “Jerusareg ipe tee futat Jarejuwarete 'ga simuoryp”, pe'je ra'e jepi— 'jau ẽẽ 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A'eramũ Jejui 'ga 'jau ẽẽ upe nũ: —Anure nipo 'gã 'jawe'em 'aga ywytyra upe: “'Agamũ futat 'ga muorypawa ywytyra”, 'jawe'em futat 'gã. Jerusarega upe nanẽ nipo 'gã aipo 'jawe'em futat nũ— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","—“Ore Samari pewaramũ Jarejuwarete 'ga aramuoryp”, 'jau pẽẽ na'e jepi numiamũ. A'ere nepekwaawi 'ga. A'ere ore judeuramũ 'ga kwaawi futari. 'Ga ojekwaawukaa oree. Judeuramũ 'ga ore mũ mogoi ae katu'okaramũ— 'jau 'ga 'ũina ẽẽ upe imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","—Anure nipo Jarejuwarete 'ga muorypara 'gã 'ga muorypa a'jea futat. 'Awamuete 'gã 'ga kwaawi ramue. 'Ga 'Agesagea 'ga muorywukaa 'gã nupe. Omuorypararetea Janeruwarete 'ga wekat ojeupe— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","—Naae 'jawe rũi Janeruwarete 'ga. Nuesaga'uweri ae 'ga. No'oi 'ga ae 'jawe. A'eramũ 'ga muorypara 'gã ojepoarukaa 'ga 'Agesage upe. A'eramũ 'gã 'ga muorypa futat, 'ga kwaapa futat— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A'eramũ ẽẽ 'jau 'ga upe: —A'jea futat aipoa. Anure nipo Jarejuwarete kĩã remimurama kĩã ruri futari, Kristu kĩã. Kĩã futat nipo jane mueapyou mama'e are— 'jau ẽẽ Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Je futat aipoa. Je futat Kristua. Je futat aje'eg te'ỹina enee— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ẽẽ upe aipo 'epawa pype ore arajua orojewya amunaw awi nũ. Ẽẽ upe 'ga porogyta 'ga renamũ ore oroporesagamũ etee 'ga ree. Judeu 'gã noje'egarũi futari kũjã upe ra'e jepi. A'ere ore a'eramũ miamũ noroporonuwi ee 'ga upe: “Ma'eramũ te ereporogyta e'ỹina ẽẽ upe?” naru'ei futari ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A'erauwe ẽẽ awau ojewya amunaw ipe. 'Y ryrũa ẽẽ ejaa imỹina awau peuwara 'gã nupe Jejui 'ga mome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Pe'je pejejua soo kĩã resaka 'jau. Jerekwawera kĩã omome'upap jee ko— 'jau ẽẽ peuwara 'gã nupe. —Kristu kĩã ra'u 'ut 'ũina peu ko. Janeruwarete kĩã remimurera kĩã ra'u 'ũi peu ko— 'jau ẽẽ awau imome'wau amunaw ipewara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","A'erauwe 'gã nuri ojekyita amunaw awi 'ga resaka. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ẽẽ o ypyrauwe ore 'jau Jejui 'ga upe: —Kweramũ janeremi'urama. Ere ejemi'waa— 'jau ore 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Naani. Irãinã'nĩ te 'ã jeremi'ua. Nepekwaawi futari jeremi'ua mama'ea— 'jau etee 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","—'Ga amũ sipo mama'ea werut 'ga upe pa ra'e?— 'jau etee ore arajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A'eramũ 'ga 'jau oree: —Pẽẽ te 'ã pejejemi'urama tywamũ etee pẽnekõẽãi pejejemogyau. A'ere je temuarera 'ga remifutar imũ mama'e apo are te jerekõẽãjamũ. 'Ga porowyky apoupap te je ruri ikue— 'jau etee 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—“Irũpãwẽ jay magwaw ire oreko pypiara sinigi”, 'jau pẽẽ 'ã jepi. A'ere 'awamũ je 'i pẽ nupe: Pemã'ẽ pejeko are esaka. Osinig futat ra'e. A'ere je napeko arũi imome'ui pẽ nupe. 'Awamũ futat 'gã kwaiwete je rerowiari ja'wyja'wy. 'Awamũ futat 'gã je rerowiari ojeupe pẽẽ je mome'u re. Sã'ã pẽẽ pejeko pypiara sinigamũ peoa imono'oga. Nan tee futat 'awamũ iwaẽmi je rerowiarukaawa upe. Pẽporomuku awi pejewau je mome'wau 'gã nupe— 'jau 'ga 'ũina oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","—Sã'ã kojara 'ga wemiayuwa 'gã mepya. A'ỹi tymara 'gã 'ga 'ã imepyau imono'ogara 'gã neewe. A'eramũ 'gã 'ã wekõẽãjamũ. Nan tee futat jeremiayuwa 'gã. A'ỹi tymara 'gã 'jawe je mome'wara 'gã. Ko pypiara mono'ogara 'gã 'jawe je rerowiarukaara 'gã— 'jau Jejui 'ga oree. —Najuejue etee futat nipo 'gã wekõẽãjamũ 'ga amũ je rerowiaramũ. Je rerowiaara 'gã juejue nipo awaupap ywag ipe ajemogyau Jarejuwarete 'ga pyri amanũ re— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","—Amono je pẽẽ kwe pe tejerowiarukaa kwe pewara 'gã nupe ikue. A'jea futat aipo jane'ea, “'Ga amũ nipo awau ityma. A'ere isinig ire nipo ajepeja 'ga 'ua imono'ogaramũ”, 'jau jane jepi— 'jau 'ga oree. —Nan futat je pẽ monoi tejemome'waukaa 'gã nupe ikue. 'Gã amũ 'ã awau pẽ nenunewe je mome'wau 'gã nupe rai'i. A'eramũ kwaiwete 'gã a'eramũ je rerowiat eneje'ega anupawe ikue— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ore upe 'ga porogytapaw ire, Samari pewara 'gã 'ua kwaiwete 'ga resaka. “Jejui kĩã jerekwawera amome'u jee”, kũjã ẽẽ 'eramũ 'gã awau kwaiwete Jejui 'ga resaka, 'ga rerowiaa kwaiwete. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A'eramũ 'gã 'jau Jejui 'ga upe: —Epyta 'au ore pype ra'ne, 'jau 'gã 'ga upe. A'eramũ ore oropytau 'gã pyri. Mukũi etee orosea. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","'Gã pype akou Jejui 'ga ojemome'wau 'gã nupe. A'eramũ tekotee 'gã nanẽ 'ga rerowiaa kwaiwete nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A'eramũ 'gã 'jau kũjã ẽẽ upe: —Eneje'ega ra'ne ako ore aruerowiat ai'i. A'ere ore 'awamũ 'ga je'ega rerowiari. Ojemome'u 'ga oree— 'jau 'ga ẽẽ upe. —“'Ga futat 'ã ae katu'okara”, 'jau ore jepi— 'jau 'gã ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mukũi oroser ire ore arawau Garireja ywy pe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jejui 'ga retea futat 'jau ikue: “Sã'ã Janeruwarete 'ga je'ega mome'wara 'ga oa kwe pe 'ga je'ega mome'wau. A'eramũ 'ã kwe pewara 'gã jẽmĩ erowiaa. A'ere 'ã 'ga 'wyr ipewara 'gã jẽmĩ nuerowiari 'ga. 'Ga pytuna 'gã miamũ 'ã 'ga rerowiare'ema ajemogyau”, 'jau 'ga ikue. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","A'eramũ ore arawau Garireja ywy pe nũ, Jejui 'ga ywy pe nũ. 'Ga resakawe peuwara 'gã wekõẽãjamũ ajemogyau. 'Gã nanẽ awau Jerusareg ipe maraka magwapa rai'i. Peu 'gã Jejui 'ga remiapofera resaka rai'i. A'e resakarera 'gã wekõẽãjamũ ajemogyau oywy pe 'ga resakawe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kana 'jawa amunaw ipe, Garireja ywy pype 'up ma'e pe, ore arawau orojewya nũ. Peu futat 'ga 'y mu'jaga y'wayramũ ai'i. A'e pe ore rekoramũ 'wyriara 'ga remiayuwa 'ga 'ua Jejui 'ga renũina. —Ejot jera'yra 'ga resaka jee— 'jau 'ga 'ua Jejui 'ga upe. 'Ga upe 'ut ma'e 'ga ra'yra futat ojero'wu ete 'upa, tapojete 'upa ajepei amunaw ipe 'upa, Kafanaũ pe 'upa. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","“Judeja ywy awi Jejui 'ga ruri ojewya akou 'au nũ” 'e renupawe ta'yjero'wu ma'e 'ga awau Kana 'jaw ipe Jejui 'ga poreawua: —Ejot jera'yra 'ga resaka jee. Tapojete 'ga 'upa. Amanũ ja'wyja'wy 'ga. A'eramũ ene ejua 'ga resaka jee— 'jau 'ga Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A'eramũ Jejui 'ga 'jau: —Aeremiapoe'ema apo resag ire tãmẽjẽ te je rerowiat pejepe. Je iapoe'emamũ neperowiari futari— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","A'ere ta'yjero'wu ma'e 'ga 'iu'jawi etee futat Jejui 'ga upe nũ: —Ere ejua futat je rupi jera'yra 'ga manũe'emauwe— 'jau etee 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aipo 'eramũ Jejui 'ga oje'ega 'ga upe: —Ere ewau ejewya eje'wyr ipe. Namanũi futari enera'yra 'ga— 'jau 'ga ta'yriara 'ga upe. Aipo ojeupe 'eramũ 'ga Jejui 'ga rerowiaa. A'eramũ 'ga awau ojewya wa'yra 'ga resaka. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","'Ga waw ipe 'ga remiayuwa 'gã 'ua 'ga rowosõu. —Namanũi futari enera'yra kũi. Ijaruete 'ga ai'i kũi— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aipo 'ga 'eramũ ta'yriara 'ga oporonupa ee 'gã nupe: —Ma'ape kwara kwawamũ 'ga ajarueteramũ rai'i ki 'ei?— 'jau 'ga 'gã nupe. —Aje kwara kwawamũ futat ai'i— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A'eramũ 'ga ikwaapa: —Aje kwara kwawamũ futat Jejui 'ga 'i jee ai'i— 'jau 'ga Jejui 'ga mome'wau wemiayuwa 'gã nupe. A'eramũ ta'yriara 'ga Jejui 'ga rerowiaa nanimenime opytuna 'gã netee. ");
INSERT INTO kyzNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aiporamũ futat Jejui 'ga aeremiapoe'ema apou'japa ikue. Garireja ywy pewara 'gã nupe ra'ne 'ga 'y mu'jaga y'wayramũ ikue. A'ere 'ga poromũ 'wyriara 'ga remiayuwa 'ga ra'yra majarueteu 'gã nupe nũ. Judeja ywy awi 'ur ire 'ga aipo apou Garireja ywy pewara 'gã nupe ikue. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Anure Jejui 'ga awau Jerusareg ipe nũ. Judeu 'gã maraka apou peu. A'eramũ Jejui 'ga awau maraka apo resaka. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusarega ojeosõu futat. Kwaiwete iosoma rokwara. Iosoma rokwara mũ rupi 'gã karupa'mĩ rerawau. A'eramũ 'gã karupa'mĩ okwat 'jau jupe. Aipo okwara pyri 'yupawu'ia mũ 'upa. Judeu 'gã aipo 'yupawu'ia renũina, Peseta 'jau jupe. Iywyri tapỹi'ĩa ajemogyau, sĩku tapỹja ajemogyau iywyri. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aipoa tapỹja 'wyr ipe futat 'gã ojero'wu ma'e 'gã majatykau erua. Eae'em, ika'na ma'e, iteu ma'e. Mĩmera 'gã 'gã imajatykau, 'gã katu'okawa rapesaka 'gã nerua imogyau tapỹja 'wyr ipe. Kwaiwete 'gã 'upa iapesaka peu. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","'Y ryjuapirauwe ipyriwara 'gã 'jau ajaupe: —Ywagipewara 'ga nipo kwe 'ut 'y motyjuapiau jã'nũ— 'jau 'gã ajaupe. Tyjuapi ypyrauwe ojero'wu ma'e 'gã awau ojemunepa 'y pe ajemogyau. A'ere ipype ose ypy ypy ma'e 'ga etee 'ga jekatu'ogi. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Iteu ma'e 'ga amũ 'ũina peu namutat. Trĩtai oito 'ga kwara magwapa oteuramũ 'ũina. A'ere 'ga nojekatu'og ymani. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Poje Jejui 'ga awau peu. A'eramũ Jejui 'ga 'ga resakawe 'jau ojeupe: “Ymã we te 'ga teuramũ rakue pa”, 'jau 'ga ojeupe. A'eramũ 'ga 'jau 'ga upe: —Erefutat te je ekatu'oga?— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Ẽẽ. Afutat futat je tekatu'oga nũ'ũ— 'jau 'ga 'ga upe. —Naje poari'i 'gã amũ ki 'ei. 'Y ryjuapirauwe je rerawawe'em je munepe'ema 'y pe ki 'ei— 'jau 'ga 'ga upe 'ũina. —'Y repejãn je orauwe 'gã amũ na'ne 'gã oi je renunewe opo 'y pe jepi— 'jau 'ga 'ga upe 'ũina imome'wau. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A'eramũ Jejui 'ga 'jau 'ga upe: —Efu'am ejupaw awi. Efu'am ejupawa pyyka erawau eruatau. Akatu'ok je ene 'awamũ— 'jau 'ga iteu ma'e 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aipo ojeupe 'erauwe iteu ma'e 'ga ojekatu'oka. A'eramũ 'ga afu'ama wupawa pyyka erawau eruatau. Judeu 'gã morowykye'ema rupi Jejui 'ga 'ga katu'ogi. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","A'eramũ judeu 'gã 'wyria'ri 'gã 'jau 'ga upe: —'Awamũ morowykye'ema. Ejupawa kasi ereroo ne. “Mama'e rerooa ae porowykya futat”, e'i 'ã janeypya rakue— 'jau 'gã wupawa 'ga erooramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A'eramũ 'ga 'jau 'gã nupe: —Je katu'okara 'ga, “ejupawa epyyk erawau eruatau”, e'i 'ga jee ko— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—Awỹja te aipo e'i enee ra'e?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","A'ere 'ga nokwaawi 'ga. 'Ga katu'oka ypy we Jejui 'ga oi mytuna 'gã wyterimũ. Kwaiwete ajatyka ma'e 'gã peu. A'eramũ Jejui 'ga 'ga katu'oka ypy we awawayayau ojepe'au 'ga wi. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A'ere Jejui 'ga iteu ma'efera 'ga resaka nũ, Jarejuwarete 'ga mogytaaw ipe nũ. —Erejekatu'ok futat 'awamũ. Au'je ki mama'e tywera apo re— 'jau 'ga 'ga upe. —Kasi mama'e tywera jeapoi enee ne, kwaiwete enee ne— 'jau 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A'eramũ ikatu'ogipyrera 'ga awau Jejui 'ga mome'wau judeu 'gã 'wyria'ri 'gã nupe: —Jejui 'ga je katu'ok ko— 'jau 'ga awau 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Morowykye'ema rupi Jejui 'ga 'ga katu'oka. A'eramũ judeu 'gã Jejui 'ga rerekou tyweramue morowykye'ema rupi ae katu'ogamũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","—Jeruwarete 'ga mama'e esage wapo ae upe au'jeteramũ. A'eramũ je nanẽ aipo apou nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aipo ojeupe 'ga 'eramũ 'gã amara'neramũ 'ga ree. —Sijuka 'ga 'jau. Morowykye'ema rupi 'ga porowykyi akou, 'gã katu'oka awau kwe pe— 'jau 'wyria'ri 'gã ajaupe. —Morowykye'ema rupi oporowyky re 'ã 'ga aipo 'jau wẽjẽmĩ nũ. “Ku'jywa 'ga Jeruwaretea”, 'jau 'ga 'ã 'ga upe nũ— 'jau 'gã ajaupe. —“Je 'ã Ku'jywa 'ga 'jawe”, 'jau wẽjẽmĩ aipo 'ga janee nũ. Aipo taetu itywetywet— 'jau 'gã ajaupe amara'neramũ 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —A'jea futat je 'i. Je 'ã Ku'jywa 'ga ra'yra futat. Nateje'eg imũ rũi je mama'e apoi. 'Ga je'eg imũ etee te je mama'e apoi. 'Ga remiapoa je aesak. A'eramũ je nanẽ aipo apou 'ga 'jawe nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","—Jeruwarete 'ga iporomutat nanimenime je ree. A'eramũ 'ga wemiapo resaukaa jee. A'eramũ je tewau ojero'wu ma'e 'gã katu'oka. Ae katu'oga esage futat. A'ere je anure mama'e esageay apoi futari tejuwa 'ga remifutar imũ. A'eramũ nipo pẽẽ pejeporesagamũ pejejemogyau ee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","—Amanũ ma'efera 'gã nipo Jeruwarete 'ga imũ'jãu imowywya tywy awi 'gã mogyau nũ. 'Ga 'jawe futat je tejemimũ'ẽ 'gã mogyau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","—NaJeruwarete 'ga rũi pẽ mojo'ok. 'Ga te 'ã pẽ mojo'ogukaa jee. A'eramũ nipo je ia'wyre'ema 'gã nupe 'jau: “Pẽẽ nepẽa'wyri. Mama'eukwaawa rapyaw ipe pekwap”, 'jau nipo je ia'wyre'ema 'gã nupe. Tejerowiaara 'gã nupe nipo je 'jau: “Je rerowiat pejepe ra'e. A'eramũ je pẽtywera moia pẽ nui. Pe'je pejejua 'au ore pyri”, 'jau nipo je tejerowiaara 'gã nupe. Mĩmera 'gã nupe nipo je 'jau, je retea futat. Jeruwarete 'ga nipo je mu'eukaa 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","—A'eramũ nipo aipo are 'gã najuejue etee je pojeupa. 'Awamũ 'gã Jeruwarete 'ga pojeuwi. A'eramũ 'gã, 'ga 'jawe futat, je pojeupa nũ. Je pojeupare'ema 'gã nanẽ Jeruwarete 'ga nopojeuwi futari, je muarera 'ga— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—A'jea futat je 'i. Jeje'ega rerowiaara 'gã ojemomyauu jeje'eg imũ. Je muarera 'ga nanẽ 'gã erowiaa nũ. Tejerowiaryauramũ je 'gã mogyau namutat. A'eramũ 'gã najuejue etee futat awau akou Janeruwarete 'ga pyri amanũ re. Na'gã nupe rũi je 'i: “Enetywerete Ku'jywa 'ga upe” 'jau. Natata pe oo ma'e 'gã nũi ore rerowiaara. Ywag ipe oo ma'e tee aipo 'gã— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","—A'jea futat je 'i. Je te 'ã Ku'jywa 'ga ra'yra. Amanũ ma'e 'jawe futat mama'e tywera apoara 'gã. A'etea nipo 'gã anure jeje'ega wanup akou. 'Awamũ futat 'gã enuwi. Jeje'ega renuw ire te nipo 'gã jemogyi oferapa— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","—Nitywi 'ga amũ Ku'jywa 'ga mogoaramũ. Ojetee futat 'ga jemogoi. A'eramũ 'ga ae nanẽ ae mogyau nũ. Je nanẽ nũ. Je Ku'jywa 'ga ra'yra. A'eramũ 'ga ae mogyaukaa jee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","—Je futat 'ã pẽneki'yra. A'eramũ Jeruwarete 'ga 'jau jee: “Ene 'ã 'gã neki'yra. A'eramũ ene 'gã mojo'oka. Itywet ma'e 'gã nupe ki ere: Pẽtywerete pẽẽ Ku'jywa 'ga upe, 'jau. Tata pe pekwap, 'jau ki ene 'gã nupe”, 'jau 'ga jee. “Ejerowiaara 'gã nupe ki ere: Je rerowiat 'ã pejepe. A'eramũ pẽẽ pejejua ywag ipe ore pyri, 'jau ki ene ejerowiaara 'gã nupe”, 'jau 'ga jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","—Pẽporesag awi je ree. A'jea futat je 'i. Anure nipo amanũ ma'efera 'gã we jeje'ega renupawe 'gã nuri ũ'jãu tywy awi. Mama'e esage apoara 'gã nipo awau ywag ipe Jarejuwarete 'ga pyri. Mama'e tywera apoarera 'gã nupe nipo je 'jau: “Naje rerowiari futari pejepe. Nepẽpoiriweri futari pejetywer awi. A'eramũ pẽẽ 'awamũ pejekwapa tata pe”, 'jau nipo je 'gã nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—Nateje'eg imũ rũi je mama'e mome'ui. Ku'jywa 'ga je'eg imũ tee je 'i. 'Ga ra'ne 'ã oje'eg jee. A'eramũ je 'ga 'eawera rupi etee futat imome'wau pẽ nupe. Natejemifutar imũ rũi je je'egi. Ku'jywa 'ga, temuarera 'ga remifutar imũ etee te je je'egi— 'jau Jejui 'ga 'gã nupe. —Ma'eramũ je 'ã a'jea futat mama'e mome'ui tekou pẽ nupe— 'jau 'ga 'gã nupe oporogytau. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Je tee tejemome'u re taetu amunipo 'ã naje rerowiari pejepe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","—A'ere nanarũi. 'Ga amũ nanẽ je mome'wau nũ. Ku'jywa 'ga je mome'wau. A'jea futat 'ga 'i— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","—'Awamueuu pẽẽ 'gã amũ monou 'ga moporogytaukaa Juã Batista 'ga upe rai'i nũ. 'Ga remimome'ua a'jea futat. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","A'ere je naekari futari “a'jea futat 'ga 'ea” 'jara 'gã. Juã 'ga 'eawera je amome'u pẽ nupe tejerowiarukaawamũ. Tejerowiar ire je pẽ katu'ogi— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Sã'ã tatara'nĩa mama'e resaukara ae upe. Nan tee Juã 'ga. Juã 'ga pẽ mueapyou je ree. 'Ga 'eawer are pẽnekõẽãi numiamũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","—Juã 'ga ra'ne je mome'u pẽ nupe. A'ere je pẽnemiapoe'ema apoi pẽ neape. Jeruwarete 'ga aipo apoukaa jee. A'eramũ pẽẽ 'jau: “A'jea futat. Ku'jywa 'ga 'ga muri janee”, 'jau pẽẽ jeremiapofera resag ire— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","—Jeruwarete 'ga nanẽ je mome'u nũ, je muarera 'ga. Nepeesaga'uweri 'ga. 'Ga je'ega miamũ futat nipo nepekwaawi pejeapyau. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","“Je 'ã 'ga remimurera”, 'jau agawewi je 'ã pẽ nupe. A'ere 'ã aipo je'ea miamũ neperowiari. A'eramũ pẽẽ 'ga je'eg are taetu pejejea'are'emamũ pejejemogyau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","—Jarejuwarete 'ga je'ega rerekwara ka'aran are pejejemu'jau. “Aipo are jarejeapyoramũ jane oi ywag ipe jarepytau”, 'jau 'ã pẽẽ na'e jepi. 'Gã amũ 'ã ka'arana kwasiaa agawewi je ree. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","A'etea 'ã pẽẽ je rerowiare'ema. Je upe pẽẽ 'jawe'em, “Ore mogy ape eje'jawe”, 'jawe'em 'ã pẽẽ jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—“Esage ma'e 'ga”, pe'je ki jee, na'ei je pẽ nupe. “Je muoryp ki pejepe”, 'jawe'em je 'ã pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","A'ere je pẽ kwaawi. “Niporomutari pa 'gã Ku'jywa 'ga ree ra'e”, 'jau je 'ã pẽ nupe— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","—Tejuwarete 'ga je'eg imũ agawewi je ruri. A'etea jeje'ega nepeenuwi futari. A'ere anure nipo tekotee 'ga amũ ruri oje'eg imũ etee futat oje'ega pẽ nupe. A'ea nipo peanup, erowiaa pejejemogyau— 'jau 'ga 'gã nupe u'ama. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","—Akotee ma'e 'gã “'ga esage”, pejejeupe 'gã 'eramũ nipo pejeku'iramũ futat pejejemogyau. A'ere nipo nepẽnea'ari pejejeupe Ku'jywa 'ga 'e are. Ku'jywa 'ga etee te Janeruwaretea. Nirũi futari 'ga. A'etea nipo nepẽnea'ari pejejeupe Ku'jywa 'ga 'e are. A'jea futat neperowiari 'ga— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—Naje rũi pẽtywera mome'u Ku'jywa 'ga upe. Moisesi 'ga te 'ã pẽtywera mome'u 'ga upe— 'jau 'ga 'gã nupe. —“Moisesi 'ga je'egera ore aruenup. A'eramũ 'ga ore mome'wau Ku'jywa 'ga upe”, 'jau pẽẽ numiamũ. A'jea futat 'ga pẽ mome'ui Ku'jywa 'ga upe. A'ere 'ga pẽtywera tee imome'ui 'ga upe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","—Moisesi 'ga remikwasiarera rerowiar ire amunipo 'ã je nanẽ je rerowiari pejepe nũ. Moisesi 'ga ka'arana okwasiat je ree futat rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","A'ere 'ã 'ga remikwasiarera neperowiari pejejemogyau. A'eramũ pẽẽ je rerowiare'ema futat pejejemogyau— 'jau Jejui 'ga 'wyria'ri 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Anure Jejui 'ga ore rerawau ore reroyaapa Garireja ry owajara katy. Tiperia 'jau nanẽ 'gã aipo ypiauu upe. Egitu ywy awi oreypy renũ'ẽawer are wea'awa maraka apoawa upe iwaẽm ja'wyja'wyrauwe ore arawau oroyaapa. Kwaiwete 'gã awau ore rewiri. 'Gã nemiapoe'ema Jejui 'ga iapou 'gã neape. Ojero'wu ma'e 'gã 'ga ikatu'oka. A'eramũ 'gã awau 'ga rewiri, kwaiwete. —Siesak 'ga iapou'jawa jarejeape— 'jau 'gã ajaupe. Ty owajara upe orowaẽmawe ore arawau orojeupia ywyty'ri rupi Jejui 'ga rupi. Peu ore aruapyka arajupa. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Oree Jejui 'ga porogyta 'ga renamũ mytuna 'gã 'ua owaẽma oree nũ. Poje Jejui 'ga ojerowaka 'gã nesaka. 'Gã nesakawe 'ga 'jau Filipe 'ga upe: —Maran maran te jane mama'e muri 'gã mojemi'wawamũ?— 'jau Jejui 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","“Tamojemi'wat 'gã 'jau”, 'jau Jejui 'ga ojeupe. A'eramũ 'ga poromũ 'jau “Ma'ja 'i sipo Filipe 'ga oje'ega jee?” 'jau 'ga ojeupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","—Kuu. Mytuna 'gã nũ'ũ. 'Gã nemi'urama murawa niapoi 'gã nupe. Tusẽtu agawewi futat ka'aranũũ rerooi. A'etea nowaẽmi futari mama'e muawamũ 'gã nupe— 'jau Filipe 'ga 'ga upe, aipo ojeupe 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","A'eramũ Andre 'ga 'jau 'ga upe: —Koromũ kunumĩ 'ga kanape'i rerekoi wemi'ura'mĩnamũ numiamũ kũi. Sĩku kanape'ia mukũi pira'i 'jau 'ga erekou numiamũ kũi. A'ere mytuna 'gã nupe niapoi nũ'ũ— 'jau Andre 'ga Jejui 'ga upe. Aipoa Andre 'ga Simão Pedro 'ga rewirera. Jejui 'ga remimu'e nanẽ 'ga nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A'eramũ Jejui 'ga 'jau oree: —Pe'je pejewau 'gã muapyka. Peapyk, e'i 'ga, pe'je ki 'gã nupe— 'jau 'ga oree. A'eramũ ore arawau 'gã muapyka. Kwaiwete juo'wia peu. A'eramũ ore a'e 'arimũ 'gã muapyka 'gã mogyau. Kwaiwete kũima'e 'gã. Sĩku miu kũima'e 'gã. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","A'eramũ Jejui 'ga kunumĩ 'ga remi'urama pyyka enafu'ama, eroje'ega 'Uwarete 'ga upe: —Au'jete mama'ea eremut oree. Ene 'ã eneresage oree— 'jau 'ga 'Uwarete 'ga upe oje'ega. A'eramũ 'ga 'Uwarete 'ga upe oje'ẽmaw ire kunumĩ 'ga remi'urama erawaukaa oree 'gã nupe. Ore 'gã nupe omonorauwe ojeme'yita aipoa kanape'ia ipira'i reewe. A'eramũ ore erawau imonou wapyk ma'e 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kwaiwete agawewi 'gã. A'etea 'gã omoyk. Wewegamũ 'gã jui. 'Gã jemi'wapaw ire Jejui 'ga 'jau oree nũ: —Pe'je pejewau emyrera rerua imono'oga yrũ pype. Pemomy kasi emyrera ne— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","A'eramũ ore arawau emyrera rerua ijaga yrũ pype. Tusi yrupemũũa ore imatyneema emyrera pyu. Aipo kanape'i apopyra sewata. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jejui 'ga wemi'u me'yita opãjẽ mũ. A'eramũ aipo resakara 'gã 'jau: —Jejui 'ga 'ã ome'yi janee. 'Ga te nipo 'ã Jarejuwarete 'ga je'ega mome'wara. Janeremiapesaga 'ga nipo 'ã— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A'ere Jejui 'ga 'gã kwaawi ojee. “Je futat 'gã je mogou 'wyriaramũ”, 'jau 'ga ojeupe. “A'ere je na'awauwe rũi je rekoi 'gã nupe”, 'jau 'ga ojeupe. A'eramũ 'ga awau ojepe'au ore wi. Ore rejaa peu futat. Ojetee 'ga awau ojeupia ywytyra rupi. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ypytu'nĩnauwe Jejui 'ga remimu'eramũ ore arawau orojypa ypiauu pe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","“Pe'je pejewau 'aw awi Kafanaũ pe”, 'jau 'ga oree ai'i. A'erauwe ore arawau aru'aa yaruu pype nũ. —Soo Kafanaũ pe 'jau— 'jau ore arajaupe. A'eramũ ore arawau oroyaapa nũ. Ypytunimũwe futat ore arawau. A'ere Jejui 'ga nuri ore rupi. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Poje ywytuua 'ua erujewi oree, 'y muorypa ore ree. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mukuu ore wawa. Sĩku kilometro ore arawau oroyaapa. Poje ore 'y rypyter ipe arakou Jejui 'ga resaka. Jejui 'ga 'ua akou 'y rajape 'arimũ, watau ore katy. 'Ga resakawe ore oropifuakare'emamũ. Orekyjea ore rerekou, ore pifuaka'roka. —Ma'ja katu nipo kwe kweramũ 'ut 'ja?— 'jau ore arajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aipo ore 'eramũ 'ga 'jau oree: —Pekyje awi je wi. Je tee ojot pẽ newiri— 'jau Jejui 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aipo orojeupe 'gã 'eramũ araku'iramũ 'ga ree. —Ere ejua e'aa ore pype— 'jau ore 'ga upe. Ore pype 'ga 'arauwe yaruua ojekoka erujewi ywy'am are. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ai'iwe kwe katy opyta ma'e 'gã Jejui 'ga rekaa. —Kaaruwamũ ako majepei tee yara ruwi 'au ai'i. A'ere ako Jejui 'ga remimu'e 'gã erooi ai'i— 'jau 'gã ajaupe. —A'ere nipo 'ã 'ga ma'ja pype katu 'ga oi 'gã newiri ra'e? Nooi 'ga 'gã nupi ai'i. Marupi ajee 'ga oi ra'e ki 'ei?— 'jau 'gã 'ga rekaa. —Ma'ape sipo ajee 'ga oi ra'e?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","'Gã 'ga rekaramũ tekotee 'gã 'ua ojekoka ajepeja amunaw awi oyaruu pype. Tiperia 'jaw awi 'gã 'ua owaẽma. Kanape'i 'waw ipe 'gã oyaruu mojekoka. Peu futat Jejui 'ga porogytai 'Uwarete 'ga upe ai'i. Oporogytapaw ire Jejui 'ga kanape'i monou 'gã nupe ai'i. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","'Gã jekog ire 'yisiga pypewara 'gã 'jau 'gã nupe: —Nitywi 'ga 'au. 'Ga remiayuwa 'gã nanẽ nitywi 'au nũ— 'jau 'gã 'gã nupe. —Pẽyara pype soo 'gã nekaa Kafanaũ pe 'jau— 'jau 'gã 'gã nupe. —Nai'i— 'jau yaruu jara 'gã aipo 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ty owajara katy ojekog ire 'gã Jejui 'ga resaka. A'eramũ 'gã 'jau 'ga upe: —Maran te erejot rai'i, ki Ku'jyp?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A'eramũ Jejui 'ga 'jau 'gã nupe: —Nepẽneapyoi we jeremiapofer are. “Jejui 'ga 'ã Jarejuwarete 'ga remimurera”, pe'je amunipo 'ã jee rai'i, jeremiapofera resag ire rai'i. Kwaiwete agawewi 'ã jeremiapofera. A'etea 'ã naje rerowiari pejepe. Kaaruwamũ ako je kanape'i me'yi pẽ nupe ai'i, pẽ mueweka ai'i. Aipo are nipo je rekat pejepe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","—Pẽpy'a'wyt kasi pejejemi'u are etee ne. Pẽnea'at kasi pejejemi'u are etee ne. Pẽnemi'ua pẽ mueweka 'au etee. A'ere mama'e mũ rekoi temi'u 'jawe pẽ pype. A'ea pẽ mogy nakwaparimũ rũi. Jeje'ega renuw ire pejejemomyauu. Jeje'eg are ki pẽnea'at pejejemogyau. Janeruwarete 'ga je mut 'au aeremi'u 'jawewara monoukaa pẽ nupe jee— 'jau Jejui 'ga 'gã nupe. —Ku'jywa 'ga 'ã Jeruwaretea. Opãjẽ mũ 'ga 'ã pẽnemiapoe'ema apoukari jee, pẽ nupe je resaukaawamũ. “Jejui 'ga jera'yraretea. Je 'ã 'ga mua pẽ nupe”, 'jau 'ga 'ã pẽ nupe jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","A'eramũ 'gã 'jau 'ga upe: —Ma'ja te Ku'jywa 'ga afutat ore iapoa?— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Je 'ã 'ga remimurera. A'eramũ ki pẽẽ je rerowiaa. A'ea te 'ga amaku'i— 'jau 'ga 'gã nupe aipo 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—Ma'ja te ereapo epãjẽ resaukaa oree? Aipo resakawe taruerowiat ene 'jau— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","—Ymã te janeypy oi watau amunawe'em ipe rakue. Peu wataaw ipe 'gã kanape'i 'jawewara 'wau rakue, mana 'jawa 'wau rakue. Aipo are 'ga amũ ka'arana kwasiaa inuga janee rakue. “Kanape'i 'ga amut ywag awi 'gã nemi'uramamũ rakue”, 'jau 'ga ikwasiaa inuga janee rakue. Moisesi 'ga aipo kanape'i monou 'gã nupe rakue. Ma'ja te eremut jarejee 'awamũ?— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A'eramũ Jejui 'ga 'jau 'gã nupe: —A'jea futat je'ea. NaMoisesi 'ga rũi kanape'i omono 'gã nupe rakue. Jeruwarete 'ga te 'ã amut 'gã nupe rakue. 'Awamũ 'ga poromuriweramũ kanape'irete 'jawewar are pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","'Ga remimurera futat aipoa kanape'i 'jawewara. Ywag awi 'ga 'ga muri ae mogyaukaa nakwaparimũ rũi futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","A'eramũ 'gã 'jau 'ga upe: —Aipoa emut ekou oree— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Tejeupe je aipo je 'i. Je te 'ã 'ga remimurera. Tejerowiar ire je pẽ momyaui pẽ mogyau namutat. Je rerowiaaramũ pẽnekõẽãi pejejemogyau. Ipy'araypare'ema 'jawe, i'yuweje'ema 'jawe 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—“Je resak agawewi 'ã pejepe pejejemogyau. A'etea pẽẽ je rerowiare'ema pejejemogyau”, a'e ako je pẽ nupe ko. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jeruwarete 'ga je rerowiarukaa 'gã amũ nupe. A'eramũ nipo 'gã je rerowiaa futat. Namonoi futari je tejerowiaara 'gã amũ tejewi. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Natejemifutara apou rũi je ruri ywag awi. Temuarera 'ga remifutara apou etee je ruri— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","—A'eramũ je tejerowiaara 'gã momoirukare'ema tejerowiar awi. Tejerowiarukaa 'gã nupe. A'eramũ je 'gã mũ'jãu tywy awi 'gã mowywya 'gã mogyau tejua nũ. Aipoa je aapo futat 'ga remifutar imũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","—Tejerowiaara 'gã juejue nipo je imonou tejemiayuwamũ. A'eramũ je tejoru'japa tejerowiaara 'gã mowywya 'gã mogyau nakwaparimũ warãu rũi. Aipoa Jeruwarete 'ga afutat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aipo 'erauwe judeu 'gã oje'egaiwamũ 'ga ree: —Kuu. “Ywag awi 'urete ma'ea je 'ã. Aeremi'uretea je”, e'i 'ga 'ã janee— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—NaJose 'ga ra'yra rũi te 'ga jepi? Naaipo rũi te Jejui 'ga ako? 'Ga jara 'gã ore orokwaap. Ma'eramũ gatu nipo 'ã 'ga 'i poromũ “ywag awi je ruri”, 'jau ekoete?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A'eramũ Jejui 'ga 'jau 'gã nupe: —Au'je ki je ree pejeje'egaiw ire. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jeruwarete 'ga te 'gã nupe je rerowiarukaara. 'Gã etee te je rerowiararũ. Tejerowiaara 'gã etee te je amũ'ẽ tywy awi 'gã mogyau nũ tejoru'japa— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","—Ymã te Janeruwarete 'ga je'ega mome'wara 'ga ka'arana kwasiari inuga 'ga je'eg are rakue. “Janeruwarete 'ga tamu'e 'gã najuejue etee 'jau”, 'jau 'ga ikwasiaa inuga rakue— 'jau Jejui 'ga 'gã nupe. —Amu'eramũ Jeruwarete 'ga je'ega renupara 'gã juejue je rerowiari. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nitywi 'ga amũ Jeruwarete 'ga resakara 'ga. Je tee te 'ga aesak. 'Ga wi je ruri ikue. A'eramũ je 'ga resaka— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","—A'jea futat je'ea. Tejerowiaara 'gã je amomyau imuesageu imogyau nakwaparimũ warãu rũi futat. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ywag awi te 'ga kanape'i muri pẽ nupe rakue, a'e je akiko. Je te 'ã aipoa. Je te 'ã amogy pẽẽ nakwaparimũ warãu rũi. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ymã te 'ã pẽypya mana 'jawa 'ui akou amunawe'em ipe rakue. A'ere 'ã po 'u re 'gã manũi etee rakue— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","—'Awamũ ako Janeruwarete 'ga kanape'irete muri ywag awi ai'i. Aipo 'u re ae namanũi futari. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Je te 'ã aipoa kanape'ia. Ywag awi 'ut ma'ea te 'ã je. Je rerowiaara 'gã aipoa kanape'i 'wara 'jawe futat. 'Awamũ kanape'i 'waramũ pejemogy futat. A'ere je rerowiaara 'gã jemogyi namutat. Aipoa kanape'i 'jawewara jero'oa futat. Tejo'oa tomono pẽ nupe 'jau, pẽnemi'uramamũ 'jau. Anure nipo je temanũmũ namutat pẽ mogyukari. Temanũawa 'ara rupi je tejo'oa monoi pẽ nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aipo ojeupe 'erauwe judeu 'gã amara'neramũ 'ga ree. A'eramũ 'gã oje'egayau ajaupe: —Maran sipo 'ga poromũ wo'o muri janee, janeremi'uramamũ?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","—A'jea futat je'ea. Jero'o 'ware'emamũ nepejemogyi namutat. Jerya nanẽ nũ. Jerya tykuare'emamũ nepejemogyi je pyri. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jero'oa nipo 'gã amũ i'wau, jerya retee. 'Gã etee futat nipo ajemogy a'jea futat. A'eramũ je tejoru'japa 'gã mowywya— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","—Jero'oa nipo aeremi'urama a'jea futat jerya retee. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jero'oa 'gã amũ i'wau jerya retee. 'Gã etee futat je rerekou. Je nanẽ 'gã nerekou nũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","—Jeruwarete 'ga 'ã okoeteete ma'ea. 'Ga 'ã je mut. 'Ga 'ã je mogou. Nan tee futat je tejo'oa 'wara 'gã mogyi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","—Koromũ kanape'ia. Ywag awi 'ut ma'ea futat. Pẽypy 'gã 'ã mana 'jawa a'u akou rakue. A'ere 'ã 'gã manũi etee rakue. Koa kanape'i 'wara 'gã te nipo ajemogyau namutat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Aiporamũ futat Jejui 'ga 'gã mu'ei ojee 'gã jatykaaw ipe. Kafanaũ pe 'ga 'gã mu'jau. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aipo renupawe Jejui 'ga rewiri oo ma'e 'gã 'jau ajaupe: —Kuu. Janereapyoa'nei jane aipo are ra'e nũ'ũ. Nikwaapawi 'ga je'ega ra'e nũ'ũ. Sirowiar awi nũ'ũ— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Noje'egi agawewi 'gã 'ga upe. A'etea Jejui 'ga aipo 'gã 'ea okwaap. A'eramũ 'ga 'jau 'gã nupe: —Aipo are nipo pẽmara'ne je ree? ");
INSERT INTO kyzNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Je te 'ã pẽneki'yra. Ma'ja 'jau sipo pẽẽ ywag ipe jejeupira resaka nũ? Pe awi futat je ruri— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","—Janeruwarete 'ga 'Agesagea te pẽ mogy. Naae rũi ojomogy. Jeje'ega renuw ire te Janeruwarete 'ga 'Agesagea pẽ monoi 'ga remiayuwamũ pẽ mogyau namutat. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","A'ere 'ã naje rerowiari pejepe— 'jau 'ga 'gã nupe. Jejui 'ga 'gã kwaapa. Ymã we 'ga werowiare'ema 'gã kwaawi akou rakue. A'eramũ 'ga ia'wyre'ema 'gã nupe omonoara 'ga kwaapa futat akou. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","—Pẽẽ mũ jeje'ega rerowiare'emamũ pejemogy. A'eramũ je 'jau pẽ nupe akiko: “Jeruwarete 'ga je rerowiarukaa 'gã amũ nupe. 'Gã etee futat nipo je rerowiaa”, 'jau ako je pẽ nupe ko— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A'eramũ 'ga rewiri oo ma'e 'gã oporenuwiwere'emamũ 'ga je'eg are ojewya 'gã wi kwaiwete. Noou'jawi 'gã 'ga rewiri. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","A'eramũ Jejui 'ga 'jau wemimu'eramũ oree: —Pẽẽ nanẽ te pẽjewyriwet je wi nũ?— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A'eramũ Simão Pedro 'ga 'jau 'ga upe: —Awỹja rewiri ore arawau nũ ki 'ei? Ene tee te 'ã ore mu'e ape ore jemogy are. Eneje'ega rerowiaaramũ te 'ã ore mogyi namutat. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aruerowiar ore ene. Ene kwaaparamũ 'ã ore. Ene rerowiaaramũ 'ã ore rekoi. “'Ga te 'ã Janeruwarete 'ga remimurera. 'Ga te 'ã esageay ma'ea”, aru'e ore enee jepi— 'jau Pedro 'ga 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—Amũ'ẽ je pẽẽ 'gã nui, tejemimu'eramũ. Tusi 'ã pẽẽ— 'jau Jejui 'ga oree. —A'ere pẽẽ mũ mama'eukwaawa 'wyriara remiayuwa peko amũ— 'jau 'ga oree. ");
INSERT INTO kyzNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aipo ore upe 'jau 'ga Judas 'ga upe te 'ga 'i numiamũ. Judas 'ga Simão Iskariote 'ga ra'yra. Judas 'ga Jejui 'ga remimu'ea agawewi. A'etea 'ga Jejui 'ga monou ia'wyre'ema 'gã po pe 'ga jukaukaa 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Anure Jejui 'ga awau watau Garireja ywy pype etee. Judeja ywy pe 'ga awawe'em. “Judeja ywy pewara 'gã ifuewet je juka are”, 'jau 'ga ojeupe. A'eramũ 'ga peu awawe'em. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A'ere maraka apoawa upe iwaẽmi ja'wyja'wy. Aipo maraka upe 'gã tapỹi apou oseawamũ. A'eramũ 'gã 'jau tapỹi 'jawa maraka 'jau jupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","A'eramũ Jejui 'ga rewirera 'gã 'jau 'ga upe: —Ere ki ekwapa Judeja ywy pe. A'eramũ peuwara 'gã, ene rewiri oo ma'e 'gã netee eneremiapoa resaka 'jau. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ajaupe ojekwaawukaa ae mama'e apoi ajueape. A'eramũ ene ewau aeremiapoe'ema apou 'gã neape, ejesaukaa 'gã nupe— 'jau 'gã 'ga upe, 'ga rerekoemãu. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","'Ga rewirera 'gã miamũ nuerowiari 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","—Naani. Nowaẽmi we je wawa upe. A'eramũ je tewawe'em. A'ere pẽẽ peoarũ je renune. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Napẽ nee rũi Janeruwarete 'ga rerowiare'ema 'gã amara'neramũ ajemogyau. Je ree tee 'gã mara'neramũ. 'Gã tywera je 'ã amome'u 'gã nupe. A'eramũ 'gã 'ã oporomutare'emamũ je ree— 'jau 'ga wewirera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","—Pe'je pejewau maraka pe. Nooa'nei je— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A'eramũ Jejui 'ga opytau peu futat, Garireja ywy pe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Maraka apoaw ipe wewirera 'gã o re Jejui 'ga awau wewirera 'gã newiri. A'ere 'ga oi jemime, ojetee'i akou 'gã newiri. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judeu 'gã 'wyria'ri 'gã Jejui 'ga rekaa. Maraka apoaw ipe 'gã 'ga rekaa ajemogyau. —Ma'ape te 'ga? Nuri te 'ga ra'e?— 'jau 'gã ajaupe 'ga rekaa. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kwaiwete 'gã ajamueu Jejui 'ga ree. Amumera 'gã 'jau ajaupe: —Esage ma'ea futat 'ga— 'jau 'gã ajaupe. Amumera 'gã: —O'meramũ 'ga 'i. Nia'wyri 'ga. I'me 'ga akou— 'jau etee 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","A'ere 'gã nueropori futari oje'ega. 'Gã kyjea 'gã nerekou. 'Wyria'ri awi 'gã kyjei. A'eramũ 'gã oje'ega meewere'i etee ajemogyau ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Majepeja tee 'gã morowykye'ema magwapa maraka apou. Muapyra oser ire, Jejui 'ga awau osou Jarejuwarete 'ga mogytaaw ipe. A'eramũ futat 'ga peuwara 'gã mu'jau. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jejui 'ga je'ega renupawe, judeu 'gã 'wyria'ri 'gã oporesagamũ ajemogyau 'ga ree. —Maran 'ga aipo kwaapa ki 'ei? Nojemu'euui agawewi te 'ga 'ã a'i kũi. A'etea te 'ga 'ã okwaap aipoa a'i kũi— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A'eramũ Jejui 'ga 'jau 'gã nupe: —Nateje'eg are rũi je 'gã mu'jau. Temuarera 'ga je'eg are futat je 'gã mu'ei— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","—Jarejuwarete 'ga remifutar imũ mama'e apoara 'gã te'i 'jau: “A'jea futat. Jarejuwarete 'ga je'eg are futat 'ga ore mu'jau. Noje'eg ekoetei 'ga”, te'i 'gã jee 'jau— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","—Oje'eg ekoete ma'e 'gã “tajepojeuwukat 'gã nupe”, 'jau 'gã numiamũ. A'ere Jarejuwarete 'ga rer imũ oje'eg ma'e 'gã nanarũi. “Jarejuwarete 'ga tapojeuwukat 'ga 'gã nupe 'jau”, 'jau 'gã. Aipo 'gã 'ea a'jea futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","—Ymã te Moisesi 'ga ka'arana kwasiari Jarejuwarete 'ga je'eg are rakue. A'ere nepeenuwi'i futari 'ga je'ega. 'Ga je'ega renuw ire amunipo 'ã pejefuewere'emamũ je ree— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Kuu. Mama'eukwaawa aipo ene mu'eukat. Awỹja sipo a'eramũ ifuewet ene ree?— 'jau ajatyka ma'e 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","22","—Morowykye'ema rupi je aeremiapoe'ema apoi. A'e resakawe 'ã pẽẽ 'jau: “Ma'eramũ 'ga nanuara apou morowykye'ema rupi ra'e ki 'ei?” 'jau 'ã pẽẽ. A'ere 'ã pẽẽ nanẽ futat peapo mama'ea morowykye'ema rupi— 'jau 'ga 'gã nupe. —Ymã te 'ã Moisesi 'ga 'i pẽ nupe rakue: “Majepeja etee ki morowykye'ema pemagwap. A'ere pejeja'yra 'ga rerawau imojewagukaa”, 'jau 'ga 'ã ikwasiaa inuga rakue. A'eramũ morowykye'ema rupi pejeja'yra 'ar ire iko morowykye'ema rupi pejeja'yra rerawau imojewaka. A'ere naMoisesi 'ga rũi pẽ mu'e ypy aipo are rakue. Pẽypy 'gã na'ne futat pẽ mu'e aipo are rakue. A'ere Moisesi 'ga 'jau rakue nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","'Ga je'eg imũ 'ã pẽẽ pejeja'yra 'ga mojewaka morowykye'ema rupi. Aipo apo re 'ã ma'eramũ ajee je ree pẽmara'ne pejejemogyau morowykye'ema rupi kũima'e 'ga amũ katu'ogamũ?— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","—Mama'e tywera etee 'ã ereapo ekou, pe'je 'ã jee. Au'je aipo 'e re. Pẽneapyo ra'ne ki jeremiapo are. Jeremiapo are pejejeapyo re te mama'e a'jea 'ga wapo, pe'je jee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jejui 'ga resaka Jerusareg ipewara 'gã 'jau ajaupe: —Na'ga ree rũi nipo jane'wyriara 'gã afueweramũ ki sa?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","—Esak 'ga 'ama 'ga porogytaa janee. A'ere 'gã noje'egayi 'ga upe. “Jarejuwarete 'ga remimurera 'ga futat”, e'i te ra'u 'gã 'ga upe nũ?— 'jau 'gã amũ ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","A'ere amumera 'gã 'i: —NaJarejuwarete 'ga remimurera rũi 'ga. Nitywi ae amũ Jarejuwarete 'ga remimurera 'ga ruawera kwaapara mũ. A'ere jane Jejui 'ga ruawera kwaawi. Garireja ywy awi futat 'ga ruri— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","A'ere Jejui 'ga oje'ega momoa 'gã nupe nũ. 'Uwarete 'ga mogytaaw ipe akou 'ga oje'ega 'gã nupe: —A'jea'jea futat sipo je kwaap pejepe? A'jea futat sipo je ruawera pekwaap? Nateje'eg imũ rũi je ruri. Temuarera 'ga je'eg imũ tee je ruri. 'Ga te 'ã mama'e a'jea etee futat omome'u. A'ere nepekwaawi 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","'Ga wi futat je ruri. 'Ga futat 'ã je muarera. A'eramũ je 'ga kwaapa futat— 'jau 'ga u'ama 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aipo 'ga 'e 'ga 'amamũ 'gã 'ga pyyg are afueweramũ numiamũ. A'ere 'gã nopyygi 'ga. Nowaẽmi we 'ga pyykawa upe. A'eramũ Janeruwarete 'ga 'ga pyygukare'ema 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A'eramũ 'gã kwaiwete 'ga rerowiaa. A'eramũ 'gã 'jau ajaupe: —'Au 'ur ire 'ã Janeruwarete 'ga remimurera 'ga aeremiapoe'ema apoi, 'ga pãjẽ resaukaa janee. Jejui 'ga 'ã nanuara wapo jepi. A'eramũ 'ga futat 'ga remimurera ra'e— 'jau 'gã ajaupe, Jejui 'ga rerowiaa. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aipo renuw ire fariseu 'gã 'jau mainana 'wyriara 'gã nupe: —Soo 'ga pyygukaa jefaruu 'gã nupe 'jau— 'jau 'gã 'gã nupe. A'eramũ 'gã jefaruu 'gã monou Jejui 'ga pyygukaa numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","A'e pype Jejui 'ga oporogytau akou wenupara 'gã nupe: —Pẽ pype je pytaaiwi etee. Anurenure'i je oi tejewya temuarera 'ga pyri nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A'eramũ nipo pẽẽ je rekaa. A'ere nipo naje resagi pejepe. Nepeoa'uweri je waw ipe. Nepekwaawi je wawa piara— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A'eramũ judeu 'gã 'wyria'ri 'gã 'jau ajaupe: —Ma'ape te 'gã oi poromũ? Ma'ape te jane niesagi 'ga? Judeue'ema 'gã 'wyrarete pe te ra'u 'ga oi nũ? Janepytuna 'gã kwasi'ofera 'gã pyri te ra'u 'ga oi nũ?— 'jau 'gã ajaupe. —Judeue'ema pypewara 'gã pyri nũ? Judeue'ema 'gã mu'jau te ra'u 'ga oi nũ? ");
INSERT INTO kyzNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Maran ajee poromũ 'ga 'i ki 'ei: “Naje resagi pejepe”, 'ga 'i ki 'ei. “Nepeoa'uweri je waw ipe”, 'ga 'i ki 'ei— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Majepeja morowykye'ema poromukuran 'gã maraka apou. Maraka apo maapawa 'ar esagea 'gã nupe. Aipo 'ara rupi Jejui 'ga afu'ama oje'ega momoa 'gã nupe: —Pẽ'yuwei te pẽẽ mũ? A'eramũ pẽẽ i'yuwei ma'eramũ pejejua je pyri. Mama'ea tomono pẽ nupe pẽnemi'uramamũ 'jau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","—Aipo are janeypya ka'arana kwasiari rakue. “Je rerowiaara 'gã pype 'y 'jawewara tujãn 'gã ywyterimũ 'jau”, 'jau 'gã ikwasiaa Jarejuwarete 'ga je'ega rerekwara ka'aran are rakue— 'jau 'ga 'gã nupe. —Aipoa 'y 'jawewara 'gã mu'jaga Janeruwarete 'ga remiayuwamũ. A'eramũ itykuara 'gã ajemogyau namutat— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","'Uwarete 'ga 'Agesage upe 'ga poromũ 'jau. A'ere Jejui 'ga 'ga 'Agesage muri werowiaara 'gã nupe, 'gã nerekwaramũ. A'ere aipo 'eramũ nuri we Janeruwarete 'ga 'Agesagea 'gã nupe. Jejui 'ga nojewyri we 'Uwarete 'ga pyri. A'eramũ Jejui 'ga 'ga 'Agesage mure'ema we werowiaara 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Aipo renupawe 'gã amũ 'jau: —A'jea futat. 'Ga Jarejuwarete 'ga je'ega mome'wara ra'e— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Amumera 'gã 'jau: —'Ga 'ã Jarejuwarete 'ga remimurera— 'jau 'gã ajaupe. A'ere tekotee 'gã 'i ajaupe: —Garireja ywy awi sipo Jarejuwarete 'ga remimurera 'ga ruri?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","—Janeypy 'gã 'ã ka'arana okwasiat Jarejuwarete 'ga remimurama 'ga ree rakue: “Davi 'ga juapyrera futat Jarejuwarete 'ga remimurama 'ga. Perẽi me nipo 'ga 'ari, Davi 'ga jeupawer ipe”, 'jau 'gã ikwasiaa inuga janee rakue— 'jau 'gã 'gã nupe. Nokwaawi wejue 'gã Jejui 'ga 'aawera. Perẽi me futat 'gã 'ari rakue. A'ere 'gã nokwaawi te 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","A'eramũ 'gã amũ Jejui 'ga rerowiaa. A'ere amumera 'gã nuerowiari 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","'Gã amũ oporopyygiweramũ 'ga ree. A'ere 'gã nopyygi 'ga. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","'Ga je'ega renuw ire jefaruu 'gã awau ojewya amuarera 'gã nupe. A'eramũ mainana 'wyriara 'gã 'jau 'gã nupe, fariseu 'gã netee: —Ma'eramũ te neperuri 'ga oree?— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","A'eramũ 'gã 'jau amuarera 'gã nupe: —Naruanuwi ore 'ga amũ je'ega 'ga 'jawe jepi— 'jau 'gã awau amuarera 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","—Pẽẽ nanẽ nipo 'ga pẽ morytee rai'i nũ? Pẽ nupe nanẽ nipo 'ga jerowiarukari rai'i nũ?— 'jau 'gã 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","—Fariseuramũ te ore mũ 'ga rerowiari ra'e nũ? Jane'wyria'ri 'gã amũ te werowiat 'ga ra'e nũ?— 'jau 'gã 'gã nupe. —Naani. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'Auwara 'gã 'ga werowiat kwaiwete. A'ere 'gã Moisesi 'ga remikwasiarera nokwaawi. A'eramũ nipo Janeruwarete 'ga 'gã momapa etee— 'jau fariseu 'gã jefaruu 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Aipo 'gã nupe 'e re Nikutemu 'ga oje'ega 'gã nupe. Fariseu 'ga amũ Nikutemu 'ga. Ypytunimũ Jejui 'ga upe oporogyta ma'efera 'ga poromũ. Aipo 'ga 'jau 'gã nupe: ");
INSERT INTO kyzNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Ymã te Moisesi 'ga ka'arana kwasiari inuga janee rakue. “Naaipo kũima'e 'ga je'ega renupa rũi 'ã ‘nia'wyri 'ga’, pe'je ekoete 'ga upe”, 'jau Moisesi 'ga ikwasiaa inuga rakue— 'jau Nikutemu 'ga 'gã nupe. —A'eramũ jane 'ga je'ega renupe'emawe “Nia'wyri 'ga”, 'jawe'em 'ga upe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","—Kuu. Enejekoty'aawa te 'ga? Garireja ywy awi te erejot 'ga 'jawe?— 'jau 'gã aipo 'ga 'eramũ. —Ikwasiaripyrer are ejemu'e. A'eramũ ene ikwaapa. Nuri futari Jarejuwarete 'ga je'ega mome'wara mũ Garireja ywy awi— 'jau etee 'gã Nikutemu 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Oporogytapaw ire 'gã okwasi'wau awau oje'wyr ipe nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","'Gã kwasi'opaw ire Jejui 'ga awau ywytyr ipe. Oriweira 'jaw ipe 'ga awau osea. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ai'iwetetewe Jejui 'ga awau osou Jarejuwarete 'ga mogytaaw ipe. 'Ga serauwe peuwara 'gã 'ua ajatykau 'ga ree. A'eramũ 'ga wapyka 'ũina 'gã mu'jau 'Uwarete 'ga ree. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","'Gã mu'e 'ga renamũ Moisesi 'ga remikwasiarer are moromu'jara 'gã 'ua fariseu 'gã netee kũjã ẽẽ mũ rerua erosou. Omene'em are ẽẽ rekoi. A'eramũ 'gã ẽẽ pyyka ẽẽ rerua ẽẽ mafu'amukaa 'gã nowase. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","A'eramũ 'gã 'jau Jejui 'ga upe: —Koa kũjã ẽẽ oko omene'em are ko. A'eramũ ore ẽẽ pyyka ẽẽ rerua esaukaa enee, ki Ku'jyp— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","—Ymã te Moisesi 'ga ka'arana kwasiari inuga aipo are rakue: “Pejuka ki omene'em are oko ma'ea kũjã”, 'jau 'ga ikwasiaa inuga rakue. “Ita ki pemomot imonou aipo apoara akag are ijukau”, 'jau Moisesi 'ga ikwasiaa inuga rakue— 'jau 'gã. A'eramũ 'gã 'jau Jejui 'ga upe: —Ma'ja ere te jupe?— 'jau 'gã Jejui 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","—Siesak 'ga je'ega amuteea te 'jau. 'Ga je'eg amuteeramũ “nuenuwi 'ga Moisesi 'ga je'egera ra'e”, sa'e 'ga upe 'jau, 'ga mome'wau 'wyria'ri upe 'jau— 'jau 'gã ajaupe, kũjã ẽẽ rerua 'ga upe. Aipo ojeupe 'eramũ Jejui 'ga wããpyramũ 'ũina ywy kwasiaa ofã mũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","A'ere 'gã nopigi futari aipo 'jau 'ga upe. A'eramũ 'ga 'gã pige'emamũ wowowyramũ 'gã nee, amã'jãu 'gã nee. A'eramũ 'ga 'jau 'gã nupe: —Mama'e tywera apoare'emamũ ra'ne pemomot ita ẽẽ ree, ẽẽ jukau— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aipo 'e re 'ga wããpyramũ nũ. A'eramũ futat 'ga 'ũina ywy kwasiaa ofã mũ nũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aipo ojeupe 'ga 'e re 'ga pyriwara 'gã awau 'ga wi majepeinume. Sawa'e 'gã na'ne futat awaupap tenune 'ga wi. A'ere kunumĩũũ 'gã awaupap. A'eramũ 'gã ẽẽ rejaa ẽẽ tee'i ẽẽ mu'ama Jejui 'ga rowase. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","'Gã o re Jejui 'ga wowowyramũ ẽẽ ree nũ, oje'ega ẽẽ upe: —Ma'ape ajee ene ree ifuewet ma'e 'gã? Nopytai te 'ga amũ ra'e?— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Naani kĩ'ĩ— 'jau ẽẽ 'ga upe. —Je miamũ naereko tyweri ene. Ere ewau. Ereapou'jap kasi mama'e tywera ne— 'jau 'ga ẽẽ upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aipo re Jejui 'ga 'jau peuwara 'gã nupe nũ: —Je te 'ã ywy pewaramũ pẽ nupe 'ara renyfuga 'jawewaramũ. Sã'ã jane 'ara kujaurauwe mama'e resaga. Nan tee futat je Jarejuwarete 'ga kwaawukaa pẽ nupe. Jeje'ega renupara 'gã nokoa'uweri ypytunaiwa pype. “Nakwaawi je Jarejuwarete 'ga remifutara”, 'jawe'em. Jeje'ega renupara 'gã Jarejuwarete 'ga remifutara okwaapap. 'Ara kujau pype futat 'gã nekoi— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A'eramũ fariseu 'gã amũ 'jau 'ga upe nũ: —Kuu. Ejee futat nipo ajee ereporogyta. Natekotee 'gã nũi ene mome'u 'awamũ oree. Ereje'eg ekoete etee 'ã ekou oree— 'jau etee 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —A'jea futat. Je jemome'ui pẽ nupe. A'ere je mama'e a'je are tee futat je je'egi. Nepekwaawi futari jeruawera. Je wawa nanẽ pẽẽ ikwaape'ema nũ. A'ere je ikwaawi tejuawera. Tewawa nanẽ je ikwaapa nũ— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","—Pejuesak 'ã pejejemogyau. Nepejokwaawi futari. A'eramũ pẽẽ 'jau ekoete pejejemogyau, “Nenea'wyri futari”, 'jau ekoete pejejaupe. A'ere je aipo na'ei pẽ nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aipo 'e re amunipo 'ã a'jea futat je'ea. Najetee rũi amunipo 'ã aipo a'e pẽ nupe. Jeruwarete 'ga we futat amunipo 'ã aipo e'i pẽ nupe. Jeruwarete 'ga je muarera— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","—Ymã te 'ã 'ga amũ ka'arana kwasiari inuga pẽ nupe rakue: “Mukũja 'gã nipo oje'ega aju'jawe etee futat 'eramũ ki sirowiat 'gã”, 'jau 'ga ikwasiaa rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Je 'ã ajemome'u pẽ nupe. Jeruwa 'ga nanẽ 'ã je mome'wau pẽ nupe nũ. 'Ga 'ã je muarera— 'jau Jejui 'ga 'gã nupe 'ũina. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—Ma'ape ajee eneruwa 'ga ki 'ei?— 'jau 'gã aipo 'ga 'eramũ 'ga upe. —Naje kwaawi 'ã pejepe. Jeruwa 'ga nanẽ 'ã pẽẽ ikwaape'ema nũ. Je kwaaw ire amunipo 'ã pekwaap 'ga— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Aipoa Jejui 'ga imome'wau 'Uwarete 'ga mogytaaw ipe 'gã nupe 'gã mu'jau. 'Ga mogytaawa pype ka'aranũũ pyykawa 'upa. A'e pype judeu 'gã ka'aranũũ monou Jarejuwarete 'ga upe. Aipo pyri Jejui 'ga 'gã mu'jau 'ũina. 'Ga pyyg are 'gã amũ afueweramũ numiamũ. A'ere nowaẽmi we 'ga pyykawa upe. A'eramũ 'gã 'ga pyyke'ema. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","A'eramũ Jejui 'ga 'jau 'gã nupe: —Anure nipo je oi 'aw awi. Je rekat nipo pejepe numiamũ. A'ere nipo naje resaga'uweri pejepe. Anure nipo peramanũ amũ pejetywera. A'eramũ nipo pẽẽ pejewawe'em je waw ipe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A'eramũ judeu 'gã 'wyria'ri 'gã 'jau ajaupe: —Ma'eramũ sipo 'ga aipo 'jau nũ 'wei? Ma'ape sipo 'ga oi? Ojejuka te ra'u 'ga nũ?— 'jau 'gã ajaupe. —Ma'eramũ sipo 'ga 'i poromũ “Nepeoa'uweri je waw ipe”, 'jau nũ 'wei?— 'jau 'gã ajaupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A'eramũ aipo 'gã 'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Pẽẽ 'awa ywy pewara futat. A'ere je na'auwara rũi. Ywag awi je ruri. A'eramũ je mama'e tywer are tejea'are'emamũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","A'eramũ je ako aipo 'jau pẽ nupe ko: “Peramanũ nipo pejetywera”, 'jau je ako pẽ nupe ko. Ajemome'u je ako pẽ nupe ko. Je rerowiare'ema peramanũ futat pejetywera— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—Ma'jaramũ ene ki 'ei?— 'jau 'gã 'ga upe. —Ymã we te ako je jemome'ui pẽ nupe ikue. Aipo je'ea a'jea futat. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Pẽnekoarũe'ema pẽ nupe imome'u re amunipo 'ã je a'jea futat imome'wau pẽ nupe, “Nepẽa'wyri futari te 'ã”, 'jau amunipo 'ã je pẽ nupe. Je muarera 'ga mama'e a'jea tee omome'u. Tejeupe 'ga remimome'ufera etee te je amome'u ywy pewaramũ pẽ nupe— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","'Uwarete 'ga upe 'ga 'i, “Je muarera 'ga”, 'jau. A'ere 'gã naeapyoi 'ga je'eg are aipo 'ga 'eramũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Je 'ã pẽneki'yra. 'Ypeywar are je mu'am ire nipo pẽneapyo je ree. “A'jea futat 'ga 'i. Janeruwarete 'ga je muarera, 'ga 'i rai'i”, 'jau nipo pẽẽ jee. “A'jea futat 'ga nuapoi mama'ea oje'eg imũ etee futat. 'Uwarete 'ga omu'e are futat 'ga jane mu'ei rai'i”, 'jau nipo pẽẽ jee— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","—Je muarera 'ga ako je pyri etee futat namutamutat. 'Ga muorypawa etee je mama'e apou jepi. A'eramũ 'ga akou je pyri etee futat— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aipo 'ga 'e 'ga renamũ kwaiwete 'gã 'ga rerowiaa. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","A'eramũ Jejui 'ga 'jau werowiaara 'gã nupe: —Jeje'ega rerowiar ire pẽẽ jeremiayuwa futat. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A'jea futat je Jarejuwarete 'ga mome'ui. Aipoa jeje'ega renuparamũ pẽẽ na'wyriara tywera remiayuwa 'jawe rũi pejemogy— 'jau Jejui 'ga 'gã nupe. —Sã'ã 'wyriara tywera wemiayuwa rereko tyweretea. Aipo 'wyriara remiayuwa 'jawe 'ã pejemogy rakue. A'ere a'jea futat je 'i Jarejuwarete 'ga ree. Aipo kwaaw ire pejejemũ'jãu pejejemogyau aipoa 'wyriara tywera remiayuwa 'gã nui— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A'eramũ 'gã 'jau 'ga upe: —Ma'eramũ te aipo ere oree ki 'ei? Na'wyriara tywera remiayuwa rũi ore. Ore 'ã Abraão 'ga juapyrera te. Na'gã amũ nemifaja rũi 'ã ore arajemogy— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —A'jea futat je'ea. Mama'e tywera apoara 'gã juejue mama'e tywera remifaja futat. 'Gã tywera 'gã nerekou. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wemifutar imũ nipo 'gã 'wyriara 'ga wemifaja 'gã monou ojewi. A'ere nipo aipoa 'wyriara 'ga wa'yra 'ga nomonoi futari ojewi. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Je te 'ã Jarejuwarete 'ga ra'yraretea futat. Pẽ katu'og ire je pẽ mũ'ẽi mama'e tywera apoara 'gã nui. A'eramũ te nipo pejetywer awi pẽneatee— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","—Abraão 'ga juapyreramũ pẽẽ numiamũ. A'etea 'ã je juka are pẽfuewet. Nepefutari jeje'ega. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tejeupe tejuwa 'ga remimome'ua tee je 'ã amome'u pẽ nupe. A'etea 'ã mama'e apou pejejuwa pejemu'eawer imũ etee rai'i— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A'eramũ 'gã 'jau: —Abraão 'ga juapyreramũ ore— 'jau 'gã 'ga upe. —Abraão 'ga juapyreramũ ore 'e re amunipo 'ã mama'e esagea te peapo 'ga 'jawe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pejeporojukawere'emamũ amunipo 'ã je ree. Tejeupe Tejuwarete 'ga remimome'ua te je amome'u pẽ nupe. A'jea futat aipoa. A'ere 'ã pẽporojukawet etee je ree. Nanarũi Abraão 'ga iapoi rakue. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pejejuwa 'jawe futat pẽẽ mama'ea peapo— 'jau 'ga 'gã nupe. —Ku'jywa 'ga tee futat oreruwaretea. Ore futat 'ga ra'yraretea— 'jau 'gã 'ga upe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A'eramũ Jejui 'ga 'jau 'gã nupe nũ: —Ku'jywa 'ga oreruwaretea 'e re amunipo 'ã pẽporomutat je ree. Ku'jywa 'ga 'wyr awi futat je ruri. Nateje'eg imũ rũi je ruri 'au ywy pe. 'Ga je'eg imũ etee je ruri. 'Ga futat je muri ikue— 'jau 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","—Ma'eramũ sipo ajee nepẽneapyoi jeje'eg are? Nepẽporenuwiweri 'ã ee. A'eramũ pẽẽ pejejeapyoe'emamũ jeje'eg are. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mama'eukwaawa 'wyriara ra'yra futat pẽẽ. A'eramũ pẽẽ emifutar are etee pejeparuapoweramũ pejejemogyau. Ywya Janeruwarete 'ga iapo ypy ypyrauwe mama'eukwaawa 'wyriara oporojuka ma'e futat. Nuenuwi futari mama'e a'jea. Mama'e a'jea miamũ futat nafutari. Wemifutar imũ etee futat e'i. I'me ma'ea futat. A'eramũ emiayuwa nanẽ i'jawe etee futat o'meramũ— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","—A'eramũ pẽẽ i'me are etee pejeparuenuwiweramũ. A'eramũ pẽẽ a'eramũ je rerowiare'ema pejejemogyau. Mama'e a'jea etee je 'ã omome'u numiamũ. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Awỹja te jeremiapo a'wyre'ema wesak? Nitywi futari 'ga amũ. Naapoi futari je mama'e tywera. Mama'e a'jea etee te je amome'u. Ma'eramũ sipo pẽẽ je rerowiare'ema?— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","—Jarejuwarete 'ga remiayuwa 'gã wenup katu katu 'ga je'ega. A'ere pẽẽ na'ga remiayuwa rũi. A'eramũ pẽẽ 'ga je'ega renupe'ema— 'jau Jejui 'ga 'gã nupe. ");
INSERT INTO kyzNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A'eramũ judeu 'gã 'jau: —A'jea futat ore 'i. “Mama'eukwaawa 'ga wereko opir are”, ore 'i enee jepi 'ja. Esak ene je'eg ekoetea ene rekoa. “Nia'wyri 'ga. Samari ywy pewara 