﻿USE sofia;
DROP TABLE IF EXISTS sofia.kyu_vpl;
CREATE TABLE kyu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kyu_vpl WRITE;
INSERT INTO kyu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Liyěma a rǎmárǎdyǎ Jesǔ Krístu aklwǐalyǎ dố a ícû̌tǎ̤ dǐtû́ lǔ tahe ari-akyǎ. È ma aklwǐalyǎ ícû̌tǎ̤ dố Khwí Davi ná Abraham. ");
INSERT INTO kyu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham aphútǎ̤ dǐtû́ Isaac, Isaac aphútǎ̤ dǐtû́ Jacob, Jacob aphútǎ̤ dǐtû́ Juda ná apuố̤avyá̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda aphútǎ̤ dǐtû́ Perez ná Zera, èthǐ thè́nyě̤ amuố̤ ma amwi̤ ná Tama. Perez aphútǎ̤ dǐtû́ Hezrò, Hezrò aphútǎ̤ dǐtû́ Ram, ");
INSERT INTO kyu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram aphútǎ̤ dǐtû́ Amminadab, Amminadab aphútǎ̤ dǐtû́ Nasho, Nasho aphútǎ̤ dǐtû́ Salmon, ");
INSERT INTO kyu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon aphútǎ̤ dǐtû́ Boaz dố amuố̤ mwi̤ ná Raha, Boaz aphútǎ̤ dǐtû́ Obed dố amuố̤ mwi̤ ná Rutha, Obed aphútǎ̤ dǐtû́ Jesse. ");
INSERT INTO kyu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse ma má̤hò́ Khwí Davi aphè̌ nuô hò́. Khwí Davi nuô aphútǎ̤ dǐtû́hò́ Solomo rò amuố̤ ma má̤hò́ Uria amě nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomo aphútǎ̤ dǐtû́ Rehoboa, Rehoboa aphútǎ̤ dǐtû́ Abijah, Abijah aphútǎ̤ dǐtû́ Asa, ");
INSERT INTO kyu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa aphútǎ̤ dǐtû́ Jehoshapha, Jehoshapha aphútǎ̤ dǐtû́ Jora, Jora aphútǎ̤ dǐtû́ Uzzia, ");
INSERT INTO kyu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzzia aphútǎ̤ dǐtû́ Jotha, Jotha aphútǎ̤ dǐtû́ Ahaz, Ahaz aphútǎ̤ dǐtû́ Hezekia, ");
INSERT INTO kyu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia aphútǎ̤ dǐtû́ Manasseh, Manasseh aphútǎ̤ dǐtû́ Amon, Amon aphútǎ̤ dǐtû́ Josia, ");
INSERT INTO kyu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia aphútǎ̤ dǐtû́ Jekonia ná apuố̤vyá̤ tômṳ. Shuốkhè̌ yěnuô atǒ bí Israelphú cuốhtwǒ tyahí cṳ̂́ dố Babylonia ké̤ to anyěhyǎ takiphú akhè̌nuô. ");
INSERT INTO kyu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bí a cuố ohò́ dố Babylonia ké̤ akhè̌nuô, Jekonia aphútǎ̤ dǐtû́ Shealtiel, Shealtiel aphútǎ̤ dǐtû́ Zerubababe. ");
INSERT INTO kyu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubababe aphútǎ̤ dǐtû́ Abiud, Abiud aphútǎ̤ dǐtû́ Eliakim, Eliakim aphútǎ̤ dǐtû́ Azor, ");
INSERT INTO kyu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor aphútǎ̤ dǐtû́ Zadok, Zadok aphútǎ̤ dǐtû́ Akim, Akim aphútǎ̤ dǐtû́ Eliud, ");
INSERT INTO kyu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud aphútǎ̤ dǐtû́ Eleazar, Eleazar aphútǎ̤ dǐtû́ Matha, Matha aphútǎ̤ dǐtû́ Jacob, ");
INSERT INTO kyu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob aphúo tǎ̤dǐtû́ Joseph dố a má̤ Maria avè̤ nuôhò́. Maria phúoní̤ hò́ Jesǔ dố ǔ è́ è ná Krístu yěnuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Me̤phúnuôrò cáhtya bí Abraham ahtû̌khè̌ tuố̤hyǎ dố Davi ahtû̌khè̌ nuôma a o shyélwǐ̤htû̌. Cáhtya bí Davi ahtû̌khè̌ tuố̤hyǎ dố ǔ pṳ̂́cuốkyǎ Israelphú dố Babylonia ké̤ nuôma a o shyélwǐ̤htû̌. Cáhtya bí ǔ pṳ̂́cuốkyǎ Israelphú dố Babylonia ké̤ tuố̤hyǎ dố Krístu ahtû̌khè̌ nuôma a o shyélwǐ̤htû̌. ");
INSERT INTO kyu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesǔ Krístu nuô a hyǎlya̤ opacè̤̌ phútě hénuôma, Joseph nuô a hyǎ sudyǎ dyémá htuô̌hò́ Jesǔ Krístu amuố̤ Maria dố a ki phyé lǔ. Manárò bí a phyé tyahí lǔ to akhè̌nuô, Cò́marya dyémuố̤dò̌htya lǔ ná Thè́ Sǎsè̌ Byacè. ");
INSERT INTO kyu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph ma kayǎ dố acò́ate̤ tôprè̤ htuô̌to pǎma ǔ thè́gně rò Maria thè́tarè̤̌he a tane̤ akhu-akhyě a kíré̤ dyakyǎhuô dyakyǎthwè́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A tane̤ phúnuô tadû́rò, bí a omyě akhè̌, a omyěmyá̤ myáhtye Byacè Cò́marya a tanémò́khuphú tôprè̤ hyǎoluô̌htya pé̤ lǔ rò a hé lǔ, “Davi aphúkhǔ Joseph, bèzò̤bèthi tǎ dố nè̤ ki phyé Maria yěnuô tǎmé̤, mame̤těhérò, a muố̤dò̌ nuôma Cò́marya a Thè́ Sǎsè̌ dyémuố̤dò̌htya lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A ki phúprè̤khǔ pǎ rò nè̤ bè è́ amwǐ̤ ná Jesǔ ní꤮, me̤těhérò a ki me̤lwóhteka̤ akayǎ tahe dố a tè̤thû́tè̤ora akǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lò̌꤮ tè̤yě tahe ki me̤lốme̤bǎhtya Cò́marya héone prè̤pro̤ tôprè̤ hé, ");
INSERT INTO kyu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Prè̤mòphúthè tôprè̤ ki muố̤dò̌htya rò a ki phúoní̤ a phúprè̤khǔ pǎ, rò ǔ ki è́ amwi̤ ná Emmanuelè pǎ,” Emmanuelè angó̤lasá ma, “Cò́marya okuô̌ ná pè̤.” ");
INSERT INTO kyu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bí Joseph thè́né̤htya akhè̌, a me̤phú Byacè a tanémò́khuphú mekyǎ lǔ nuô. A ka̤sǒdya ná Maria rò a è́ka̤ lǔ dố ahi. ");
INSERT INTO kyu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Manárò bí Maria phúoní̤ tyahí aphúprè̤khǔ yětôprè̤ hítonuô, a omyě tố̤hí lǔ to. Joseph è́ lǔmwi̤ ná Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesǔ opacè̤̌lya̤ dố vǐ̤ Bethelehem, ké̤ Juda akǔ, bí Khwí Herodè pốhtyěpốké̤ akhè̌nuô. Jesǔ opacè̤̌lya̤ htuô̌nuô prè̤thíphè́phú dố ké̤cíhte tahe hyǎ dố vǐ̤ Jerusalem rò hyǎsudyǎ khwí, ");
INSERT INTO kyu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Pacè̤̌phú dố a kíré̤ htwǒhtya Juda akhwí yětôprè̤ nuôma a opacè̤̌lya̤ tǒbítě tôpho? Me̤těhérò pè̤ myáhtye asè ohtyaluô̌ dố ké̤cíhte tôkyě rò pè̤ hyǎ dố pè̤ ki cò́bucò́bè̌htya è.” ");
INSERT INTO kyu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bí Khwí Herodè ní̤huô̌ tè̤hébè phúyě akhè̌nuô, a thè́plòkṳ́ thè́plòkyǎ̤. Lò̌꤮ vǐ̤ Jerusalemphú tahe thè́plòkṳ́ thè́plòkyǎ̤ kuô̌ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A è́ okú plò́lò̌ lò̌꤮ bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe. Rò a sudyǎ èthǐ, “Prè̤pro̤ tahe héone ná Messia yětôprè̤nuô a ki opacè̤̌lya̤ tǒpǎ bítě tôphotě pǎ,” a hé. ");
INSERT INTO kyu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Rò èthǐ hésû lǔ, “A ki opacè̤̌lya̤ dố vǐ̤ Bethelehem, ké̤ Juda akǔ pǎ, prè̤pro̤ Mica rǎ rò a hé, ");
INSERT INTO kyu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Byacè hé, ‘Kố꤮ vǐ̤ Bethelehem꤮, vǐ̤ dố a odố ké̤ Juda akǔ yětahe aklè̌nuô, nè̤ ma vǐ̤ patílốǔ dố amwi̤ luô̌htyěluô̌ké̤ kuô̌ǔ to phúnuô má̤to. Me̤těhérò prè̤pốtè̤ tôprè̤ dố a ki takò́takè̤ rò a ki zṳ̌klyázṳ̌klǒní̤ vǎ Israelphú yětômṳ ki ohtya dố nè̤kǔ pǎ.’” ");
INSERT INTO kyu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Phúnuôrò Khwí Herodè è́huôè́thwè́ prè̤thíphè́phú dố a o dố ké̤cíhte hyǎ yětahe rò a sudyǎ tǎ̤te̤ èthǐ ná sè yětôměnuô a oluô̌htya pé̤ èthǐ bò́khè̌tě phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A nò̌cuố èthǐ dố vǐ̤ Bethelehem rò a hé èthǐ, “Cuốmyápṳ̌ tǎ̤te̤ lahyǎ pacè̤̌phú nuôtôprè̤ ní꤮. Thyáphú vǎ ki cuố cò́bucò́bè̌htya ní̤kuô̌ è nuô, thǐ ki myáhtye hò́hò́ ná ka̤dyáso lè̤́pé̤ kuô̌ vǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bí èthǐ ní̤huô̌htuô̌ khwí hé ngó̤ phúyě rò a htecuố lahyǎ. Bí èthǐ htecuố akhè̌nuô, sè dố èthǐ myáhtye dố ké̤cíhte nuôtômě oluô̌htya pé̤ khyěthyá èthǐ. Sè nuôtômě thǔcuố ré̤ èthǐ dố nyě rò a cuố okuố tǒdè̌htya cò́ pé̤ èthǐ bí pacè̤̌phú oní̤ akhǎlé̤ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bí èthǐ myáhtye sènuôtômě akhè̌nuô, a thè́krṳ̂̌thè́lò̌ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Rò èthǐ nuô̌ dố hikǔ rò nuô̌myáhtye pacè̤̌phúyě otố̤ná amuố̤ Maria. Èthǐ dángṳ̂lya̤ cò́bucò́bè̌htya lǔ. Htuô̌rò a phyéhte htè̌ ná tè̤nuô̤mû́ dố ǔ è́ ná lòban ná myrra dố angṳdupri̤du yětahe rò a dyé ná pacè̤̌ shyězṳ́. ");
INSERT INTO kyu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Rò Cò́marya dyérò̤dyéryě̤ prè̤thíphè́phú yětahe dố a tè̤omyěmyá̤ akǔ ná èthǐ ki ka̤tǒ pǎ tǎ Khwí Herodè tǎmé̤. Rò èthǐ ka̤khókyǎ klyá dố aruô tôbǒ dố aké̤. ");
INSERT INTO kyu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bí prè̤thíphè́phú yětahe ka̤htuô̌hò́ nuô, Cò́marya amò́khu tanéphú tôprè̤ hyǎoluô̌htya pé̤ Joseph dố a tè̤omyěmyá̤ akǔ rò a hé lǔ, “Ihtòmò̌! Rò è́ní̤ pacè̤̌phú ná amuố̤nuô rò hteklyacuốkyǎ mò̌ dố Egypt ké̤ nuô. Vǎ ki héso hí nè̤ tôcô꤮ to kihérò tarú otadû lahyǎ bínuô ní꤮, me̤těhérò Khwí Herodè kíré̤ nò̌ aklyěphú tahe pṳ̌me̤thyě pacè̤̌phú yětôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A pá̤ihtò rò a kahtò è́ní̤ pacè̤̌phúyě ná amuố̤ rò htecuố dố Egypt ké̤ bí mò̤́khímò̤́ne̤ akhè̌. ");
INSERT INTO kyu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A cuốo bínuô tuố̤dố Khwí Herodè thyě. Tè̤htwǒhtya ané̤ phúyěnuôma a me̤lốme̤bǎhtya Byacè Cò́marya nò̌ héonekyǎ aprè̤pro̤ Hosea, “Vǎ è́hteka̤kyǎ vǎphú dố Egypt ké̤.” ");
INSERT INTO kyu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bí Khwí Herodè thè́gněhò́ ná prè̤thíphè́phú tahe lahǒkyǎ hò́ lǔ akhè̌nuô, a thè́plòdu lakálakǒ cò́. Phú a pṳ̌thè́gně tǎ̤te̤ ní̤htuô̌hò́ dố prè̤thíphè́phú yětahe alo̤ ná sè oluô̌htya pé̤ èthǐ bíkhè̌tě nuô, a nò̌me̤thyě lò̌ prè̤khǔ pacè̤̌phú nyě̤na tǎ̤palya̤ tahe dố a o dố vǐ̤ Bethelehem akǔnuô ná dò̌o tavǐtava̤ bínuô lò̌꤮ plǐ. ");
INSERT INTO kyu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Me̤phúnuôrò, Cò́marya héone hò́ angó̤ ná Prè̤pro̤ Jeremia nuô a lốbǎ htyahò́. ");
INSERT INTO kyu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Prè̤pro̤ Jeremia hé, “Tè̤nguố̤tè̤hè ki ohtya dố vǐ̤ Rama akǔ pǎ. Ǔ ki nguố̤tadû thè́plò, ǔ ki hètadû thuôhtyě cò́ pǎ. Rakělè aklwǐalyǎ tahe kinguố̤kihè dyélò̌ aphú pǎ. Dố aphú tahe thyělò̌ rò a tane̤ takhǒthè́ yěnuô, ǔ ilò̌ oícyá̤ lǔ tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bí Khwí Herodè thyěhtuô̌hò́ rò Joseph opǎ dố Egypt ké̤ akhè̌ nuô, Cò́marya a tanémò́khuphú tôprè̤ hyǎoluô̌htya pé̤ lǔ dố a tè̤omyěmyá̤ akǔ. ");
INSERT INTO kyu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Rò a hé lǔ, “Ihtòmò̌! È́ní̤ pacè̤̌ ná amuố̤nuô rò ka̤khyě khyěthyámò̌ dố Israel ké̤nuô, me̤těhérò kayǎ dố a pṳ̌me̤thyě pacè̤̌phú yětôprè̤nuô, a thyěhò́.” ");
INSERT INTO kyu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Rò a pá̤ihtò, rò a ihtòè́ní̤ pacè̤̌phúyě ná amuố̤ rò a ka̤khyě dố Israel ké̤. ");
INSERT INTO kyu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Manárò bí Joseph ní̤huô̌ ná Khwí Herodè aphúkhǔ Khwí Arkelao htyapố aphè̌ khǎlé̤ dố ké̤ Juda akhè̌nuô, a thè́isě rò a ka̤tǒ bûto. Cò́marya dyérò̤ Joseph dố a tè̤omyěmyá̤ akǔ rò a taklyé ka̤khyě odố Galilea ké̤kǔ. ");
INSERT INTO kyu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Èthǐ ka̤-o ní̤dyé vǐ̤nuô tôvǐ̤ ma ǔ è́ ná vǐ̤ Nazarè. Yěma a me̤lốme̤bǎhtya hò́ prè̤pro̤ tahe héone, “Ǔ ki è́ lǔ ná Nazarèphú pǎ,” nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nanyě̤lè̌nyě̤ hyǎhò́ akhè̌nuô, kayǎ otôprè̤, a lě hésodônyǎ tè̤ dố Judaké̤ ké̤sè̌htyěkya̤ lò̤́tamákhu, rò ǔ è́ lǔ ná Giovanni Baptista. ");
INSERT INTO kyu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Rò a hé, “Za̤ ní̤dû lahyǎ thǐné̤, me̤těhérò mò́khu ahtyěaké̤ phûhtyahò́.” ");
INSERT INTO kyu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","È ma má̤ kayǎ nuôtôprè̤ dố Prè̤pro̤ Isaiah héone lǔrilǔkyǎ, “Kayǎ tôprè̤ è́htǒhtya dố ké̤sè̌htyěkya̤ lò̤́tamákhu rò a hé, ‘Taritaryǎ one lahyǎ klyá dố Byacè agně. Me̤cò́me̤pě̤ lahyǎ Byacè lé̤hyǎklyá agně tôbǒ ní꤮.’” ");
INSERT INTO kyu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Giovanni kû̌thyáhtyaní̤ hyeca̤ dố ǔ bò́ ná tathíbuô̌du asû, rò a ryá̤htyaní̤ nyá̤htò́phá. Rò a eprè́ takǐ ná vyáhtyě. ");
INSERT INTO kyu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kayǎ dố a odố vǐ̤ Jerusalem akǔ ná Juda tôké̤lè̤̌ ná lò̌꤮ kayǎ dố a o tavǐtava̤ rwó Jordano htyěklǒ nuôtahe a hyǎ lahyǎ dố Giovanni a o. ");
INSERT INTO kyu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Èthǐ hyǎ héso lǐlò̌ a tè̤me̤thû́ tahe rò Giovanni plwǒ pé̤ èthǐ htyě dố Jordano htyěklǒkǔ. ");
INSERT INTO kyu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Manárò bí Giovanni myáhtye Pharisěophú ná Saducěophú tahe hyǎpluhyǎphè dố a ki hyǎplwǒ kuô̌ ané̤ ná htyě akhè̌nuô, a hé èthǐ, “Rṳ́thíthǐ꤮! Maǔpě tôprè̤ dyérò̤dyéryě̤ thǐ ná thǐ ki siplè́bè́ ná Cò́marya a tè̤cirya dố a ki hyǎpǎ yěnuô pě? ");
INSERT INTO kyu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Thǐ ki za̤ ní̤dû má̤lakǒ hò́ thǐné̤ hò́ kihérò dyéluô̌ lahyǎ thǐ tè̤ohtwǒprè̤ tahe ná thǐ tè̤dya thǐ thè́plòthuôhtyě tahe. ");
INSERT INTO kyu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Héhtǒhélya̤ tǎ thǐné̤, ‘Pè̤ ma Abraham aklwǐalyǎ’ nuôtǎmé̤. Vǎ hé thǐ, Cò́marya me̤htwǒhtya lò̤́yětahe ná Abraham aphú má̤ a me̤cyá̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kwǒ tôbè ohò́ dố thòkhǎshyéhò́ rò ǔ ki ikwǒ̤ khû́hò́ thòmò̤́ tahe pǎ, rò ǔ ki icǒtṳ̂̌ tuố̤ cò́ dố arwí̤ahtwo pǎ. Thòmò̤́ tômò̤́mò̤́ dố athèaphǒ twó̤ryá to nuô, ǔ ki ikwǒ̤ khû́kyǎ è pǎ rò ǔ ki vǐnuô̌kyǎ è dố mikǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Dố thǐ za̤ ní̤ thǐné̤ akhu-akhyě vǎ plwǒ thǐ ná htyě. Manárò kayǎ otôprè̤ dố a taryěpro̤prya̤ shyosò̌ lốklò̌ cò́ ná vǎ tôprè̤nuô a ki hyǎ dố vǎkhyěkhu pǎ. A ki plwǒ thǐ ná Thè́ Sǎsè̌ Byacè ná mi pǎ. Vǎ cò̤̌cuố pé̤ prè́ lǔkhuphá nuô, a kòná vǎ to. ");
INSERT INTO kyu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A pṳ̂́ohò́ dǎkò̤ dố a takhukǔ, rò a taritaryǎ onehò́ dố a ki ikrè́sè́ buố pǎ. A ikrè́sè́ htuô̌hò́ pǎ rò a ki dya-oplò́ buốsè́ dố cyǎkǔ pǎ. Rò athu-aphǐ tahenuô a ki isû́kyǎ ná mi dố a pǐ̤pé̤ tôphuố꤮ to nuôtôphè akǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Htuô̌rò thyáphú Jesǔ ki plwǒ kuô̌ ané̤ ná htyě dố Giovanni a takhukǔ agně nuô a odố Galilea ké̤ rò a hyǎ dố Jordano lyǎ̤muố̤ a o. ");
INSERT INTO kyu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Manárò Giovanni thè́zṳ̂́ plwǒ pé̤ lǔ to. Rò a hé lǔ, “Vǎ tǒ plwǒ taplé꤮ kuô̌ vǎné̤ dố nè̤ o kǒkǒ rò nè̤ cuốhyǎ plwǒ pé̤ nè̤né̤ dố vǎo phútě?” ");
INSERT INTO kyu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesǔ hésû lǔ, “Khǒnyá̤ rò tarú plwǒ pé̤ mò̌ vǎ, me̤těhérò pè̤ tǒbè me̤lốbǎ lò̌lò̌꤮ Cò́marya a tè̤thè́zṳ̂́ nò̌me̤ pè̤ nuôtahe,” a hé rò Giovanni thè́plòo plwǒ pé̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bí Jesǔ plwǒhtuô̌ ané̤ ná htyě rò a ngò̤kahtò dố htyěkhukhu ná mò́khu lṳmǒǎyǎ. Rò a myáhtye Cò́marya a Thè́ Sǎsè̌ hyǎtǎ̤ odố lǔlo̤ thyáná htulwí̤ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Htuô̌rò ngó̤pra̤htya tômû̌ dố mò́khunuô rò a hé, “Yětôprè̤ ma vǎphúkhǔ dố vǎ mo̤ní̤ è htuô̌to vǎphú dố vǎ myádu ní̤dyé è tôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Thyáphú khǐnéricyá̤ khuklò́ ki iloní̤ Jesǔ rò Thè́ Sǎsè̌ Byacè thǔcuố lǔ dố ké̤sè̌htyěkya̤ lò̤́tamákhu. ");
INSERT INTO kyu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesǔ duôesè anyělwǐ̤shyě athè̌lwǐ̤shyě htuô̌rò a ladyá thè́ethè́ǒ. ");
INSERT INTO kyu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bínuôakhè̌ khǐnéricyá̤ khuklò́ hyǎ dố lǔo rò a hé lǔ, “Nè̤ ki má̤ Cò́marya aphúkhǔ tôprè̤ hérò, hétǎ̤ lò̤́ yětahe rò nò̌htwǒhtya è ná khò́mǔ nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Manárò Jesǔ hé lǔ, “Lisǎsè̌ héphúyě, ‘Prè̤lukayǎ htwǒprè̤ tû́prè́ ná sèesèǒ nuô má̤to. Thyáphú prè̤lu ki htwǒprè̤ agněnuô, lò̌꤮ Cò́marya hébèngó̤ nuôtahe ma a lo kuô̌ dûdû.’” ");
INSERT INTO kyu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Htuô̌rò khǐnéricyá̤ khuklò́ è́cuố Jesǔ dố Jerusalem vǐ̤sǎsè̌ rò a nò̌cuốihtòo lǔ dố tè̤lǔhǒdu a khuklwókhu htyalô̌lố tôtó̤. ");
INSERT INTO kyu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Rò a hé lǔ, “Nè̤ ki má̤ Cò́marya aphúkhǔ tôprè̤ kihérò, pá̤tǎ̤mò̌! Me̤těhérò, lisǎsè̌kǔ hé, ‘Cò́marya nò̌ myákhwè takò́takè̤ní̤ nè̤ ná a tanémò́khuphú tahe pǎ. Rò thyáphú nè̤ khǎduô ki bèsè̌ ná lò̤́ tǎmé̤ nuô, èthǐ ki phyáhtyasûdû nè̤ pǎ.’” ");
INSERT INTO kyu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesǔ hésû lǔ, “Lisǎsè̌kǔ hépó̤, ‘Nè̤ bè me̤myání̤ nè̤ Byacè Cò́marya to.’” ");
INSERT INTO kyu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Khǐnéricyá̤ khuklò́ è́cuố khyěthyá lǔ dố sohtyalô̌ tômě alo̤ rò a dyéluô̌ lǔ ná htyěké̤ pwǒ̤tôba dố hekhuyě ná a tè̤lǐtè̤takhè̌ ná a tè̤duzá̤htyathè̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Khǐnéricyá̤ khuklò́ hé Jesǔ, “Nè̤ ki dángṳ̂cò́bè̌ vǎ kihérò, lò̌꤮ yětahenuô vǎ ki dyélò̌ ná nè̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Htuô̌rò Jesǔ hé lǔ, “Khǐnéricyá̤ khuklò́꤮! Cuố taphǎye̤kyǎ. Lisǎsè̌kǔ hé, ‘Cò́bè̌htya prè́tû́ nè̤ Byacè Cò́marya rò me̤prè́tû́ ètè̤me̤ prè́ ní,’” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Khǐnéricyá̤ khuklò́ htecuốkyǎ htuô̌ lǔkhǎlé̤ rò, mò́khu tanéphú tahe hyǎmyákhwè me̤cwó̤ ní̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bí Jesǔ ní̤huô̌ ná ǔ pṳ̂́dò́tǎ̤ Giovanni dố htò̌kǔ hò́ akhè̌nuô, a hteka̤kyǎ dố Galilea ké̤. ");
INSERT INTO kyu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A htecuốkyǎ ná vǐ̤ Nazarè rò dốkhyěnuô a cuố odố vǐ̤ Capernaum dố a ophû ná Galilea htyěòdu akhǎshyé nuô tôvǐ̤. Khǎlé̤ bínuô tôpho ma a ophû ná Zebulu ké̤ ná Naphtali ké̤. ");
INSERT INTO kyu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yěma a me̤lốbǎkyǎ hò́ Prè̤pro̤ Isaiah a tè̤héone, ");
INSERT INTO kyu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kố꤮ Galilea ké̤muố̤ dố Judaphú má̤to tahe o ní̤dyé hò́, Zebulu ké̤ ná Naphtali ké̤, dố a o dố htyěòduhtû̌ tahe, ná Jordano ahtyěklǒ bè́rè̤̌ tahe, lò̌꤮ plǐ thǐ꤮, ");
INSERT INTO kyu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","kayǎ dố a o dố tè̤thû́ a tè̤khítè̤lò̤ alè̤̌ thǐ꤮, thǐ myáhtyehò́ tè̤lǐtè̤takhè̌ du hò́. Kayǎ dố a o dố tè̤thyětè̤mé̤ alè̤̌ thǐ, tè̤lǐ sátakhè̌ tǎ̤hò́ thǐ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tǎ̤plehyǎ bínuôrò Jesǔ cáhtya hésodônyǎ pé̤ ǔ, “Za̤ ní̤dû lahyǎ thǐné̤, me̤těhérò mò́khu ahtyěaké̤ phûhtyahò́.” ");
INSERT INTO kyu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bí Jesǔ cuốrwó Galilea htyěòhtû̌ akhè̌nuô, a myáhtye puố̤ ná vyá̤ thè́nyě̤. Tôprè̤ rò amwi̤ ná Simonè má̤torò ǔ è́ lǔ ná Petru, ná apuố̤ Andrea. Bínuôakhè̌ èthǐ cò̤́etè̤̌ ná itavǐ dố nókǔ, me̤těhérò a pṳ̌e lahyǎ prè́ ahò́kǔsè ná tè̤̌ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Rò Byacè hé èthǐ, “Cuố꤮ krwǒkuô̌ vǎkhyě. Vǎ ki ithyóithya ní̤ thǐ thyáphú thǐ ki è́ní̤ kayǎ phú thǐ pṳ̂́e ní̤ tè̤̌yě nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tôphuốtuô̌ èthǐ dyakyǎ atavǐ rò a krwǒcuốkuô̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Byacè cuốplehyǎ pó̤ dố nyě takiphú rò a myáhtye pó̤ puố̤návyá̤ thè́nyě̤ dố amwi̤ ná Jakomo ná Giovanni. Èthǐ ma Zebedeo aphú. Èthǐ onyǎtố̤ ná aphè̌ dố thòklyěkǔ rò isè́ri̤ ní̤dyé a itavǐ tahe. Rò Byacè è́krwǒ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tôphuốtuô̌ èthǐ dyakyǎ athòklyě ná aphè̌ rò a krwǒcuốkuô̌ Jesǔ akhyě. ");
INSERT INTO kyu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesǔ lě lò̌ Galilea tôké̤lè̤̌ rò a lě ithyóithya ǔ dố tè̤cò́bè̌ hǒkǔ pwǒ̤꤮ tôpho. A hésodônyǎ pé̤ ǔ ná Cò́marya ahtyěaké̤ tè̤thè́krṳ̂̌mila ari-akyǎ. Rò a zasǐmé̤ pé̤ lò̌ ǔ tè̤swí pwǒ̤tômyě tè̤sè̌ pwǒ̤tôcô. ");
INSERT INTO kyu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Byacè amwi̤ luô̌pasǐ cuốlò̌ Syria ké̤ tôké̤꤮ lè̤̌ akhu-akhyě ǔ è́hyǎ kayǎ dố a bè tè̤swítè̤sè̌ è́myěè́cô dố lǔo. Rò ǔ è́hyǎ kayǎ dố a sè̌cyě̤sè̌cṳ̂ lǔné̤ tahe, khǐnékhǐnò̌ me̤bè lǔ tahe, a taryé thǐ tahe, ná a thyětôkyě thǐ tahe dố a o rò a zasǐmé̤ lò̌pé̤ ǔ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kayǎ odố Galilea ké̤, ná vǐ̤ avǐ̤shyé oplò́cû̌ tố̤lǔ dố ǔ è́ ná Decapoli, ná vǐ̤ Jerusalem, ná Judaké̤, ná kayǎ odố Jordano htyěklǒ bè́rè̤̌ tahe krwǒplukrwǒphè kuô̌ lò̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bí Byacè Jesǔ myáhtye ná kayǎ bè́mṳ tahe akhè̌nuô, a cuốhtya onyǎo dố sorò̤̌lo̤. Rò a khǒpacè̤̌ tahe hyǎ dố lǔo. ");
INSERT INTO kyu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Rò a cáhtya ithyó èthǐ rò a hé, ");
INSERT INTO kyu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kayǎ dố a thè́lè̤htyaní̤ tû́prè́ Cò́marya dố tè̤lò̌꤮ plǐ akǔ tahenuô, a ní̤bè tè̤sò̌ri. Me̤těhérò mò́khu htyělé̤ké̤kǔ nuôma kayǎ phúnuô tahe atè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kayǎ dố anguố̤ahè thǐ tahenuô, a ní̤bè tè̤sò̌ri. Me̤těhérò Cò́marya ki ilò̌í èthǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kayǎ dố a thè́dǒthè́nga̤ rò a shyalya̤ athè́plò tahenuô, a ní̤bè tè̤sò̌ri. Me̤těhérò hekhu yětôbanuô a ki htwǒlò̌ lǔtè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kayǎ dố a thè́zṳ̂́ má̤lakǒ tè̤cò́tè̤te̤ tahenuô, a ní̤bè tè̤sò̌ri, me̤těhérò a ki ní̤bèdû lò̌꤮ tè̤cò́tè̤te̤ dố a thè́zṳ̂́ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kayǎ dố a thè́zò̤klabèní̤ ǔ tahenuô, a ní̤bè tè̤sò̌ri. Me̤těhérò Cò́marya ki thè́zò̤ sûke èthǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kayǎ dố athè́plò mwǒ̤plǐthǐplo tahenuô, a ní̤bè tè̤sò̌ri. Me̤těhérò a ki myáhtye phûtatò cò́ ané̤ ná Cò́marya pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kayǎ dố a me̤pě̤me̤dwǒ tè̤ tahenuô, a ní̤bè tè̤sò̌ri. Me̤těhérò Cò́marya ki è́ èthǐ ná aphú tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kayǎ dố ǔ me̤cyě̤me̤cṳ̂ lǔ dố tè̤cò́tè̤te̤ akhu-akhyě tahenuô, a ní̤bè tè̤sò̌ri. Me̤těhérò dố mò́khu ahtyěaké̤kǔ nuôma kayǎ phúnuô tahe atè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Bí ǔ pacyé̤ishyé thǐ, ǔ me̤cyě̤me̤cṳ̂ thǐ, ǔ kè̤bò̌kè̤bye thǐ rò ǔ hé mǔmyá̤ricyá̤ thǐ dố vǎkhuvǎkhyě tahenuô, thǐ ní̤bè tè̤sò̌ri. ");
INSERT INTO kyu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Thè́krṳ̂̌thè́lò̌ lahyǎ, thè́luố̤phòphû̌ lahyǎ ní꤮, thǐ tè̤me̤ní̤khwókè dố mò́khu nuô adu lakálakǒ cò́. Prè̤pro̤ dố꤮ nyénu tahenuô ǔ me̤cyě̤me̤cṳ̂ htuô̌hò́ èthǐ phúnuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Thǐ tahe ma athyáná hekhu ithè nuô. Manárò ithè ki sû̌hè̌ pǎto hérò cuốme̤ sû̌hè̌ ka̤khyě cyá̤pǎ è phútě? Ǔ nò̌e cyá̤pǎto. Ǔ ki vǐkyǎ kyǎ è dố klyádè̌kǔ rò ǔ zí̤taprò́ cuốkyǎ lò̌ prè́ è. ");
INSERT INTO kyu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Thǐ tahe ma athyáná hekhu atè̤lǐ nuôhò́. Vǐ̤ odố solo̤ tôvǐ̤ nuô ǔ me̤ tadwǒbícyá̤ è to. ");
INSERT INTO kyu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ǔ isǐlǐ htuô̌ mikò̌ rò ǔ taklwǒ̤bí è ná cǒ̤nuô a o tôprè̤꤮ to. Ǔ dyahtya è dố mikò̌rè̤́khu rò a lǐ pé̤ lò̌ǔ tôhitôphyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Phúnuôhò́, thyáphú ǔ ki htuthè́htya pè̤phè̌ odố mò́khu yětôprè̤ agněnuô nò̌lǐtakhè̌ htyaluô̌ kuô̌ thǐ tè̤me̤ryá nuôtahe dố ǔ pwǒ̤꤮ tôprè̤ anyěhyǎ nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Tane̤thû́ tǎ lahyǎ vǎ ná vǎ hyǎme̤pyé Mosè a tè̤thyótè̤thya ná li dố prè̤pro̤ rǎkyǎ nuôtahe tǎmé̤ ní꤮. Vǎ hyǎ dố vǎ ki hyǎ me̤pyéme̤kyǎ tè̤nuô tahe má̤to. Vǎ hyǎ me̤lốme̤bǎ pé̤ tè̤rǎone yětahe nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Vǎ hécò́cò́ thǐ, mò́khu ná hekhu tǎ̤prò̤kyǎ tadû́rò, liplò dố a patílốǔ tôplò bèbè, liplò amáadyǎ dố a patílố tôplò nuôbèbè, taki꤮ ma a bè lamé̤kyǎ ní̤ to. Lò̌꤮ liyě tahe héone nuô a bè lốbǎ ré̤lò̌. ");
INSERT INTO kyu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ǔpěpě꤮ bèbè, dố a khè̌talwócuốtalye̤ tè̤mekyǎngó̤ dố a patílốǔ tômǎ̤ rò a ki ithyó ǔ ná ǔ ki khè̌talwócuốtalye̤ thyákuô̌phú ènuô kihéma dố mò́khu htyělé̤ké̤kǔ pǎnuô, Cò́marya ki dya è phú kayǎ dố a patílố ǔ tôprè̤ pǎ. Manárò ǔpěpě꤮ bèbè, dố a ohtwǒprè̤ krwǒ tè̤thyótè̤thya rò a ithyó ǔ dố ǔ ki krwǒ me̤kuô̌ phúnuô hénuôma, dố mò́khu htyělé̤ké̤kǔ nuô, Cò́marya ki dya è ná kayǎ dố adulố꤮ ǔ tôprè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Phúnuôrò vǎ hécò́cò́ thǐ, thǐ kicò́kite̤klò̌ ná prè̤ithyó tè̤thyótè̤thya athárá yětahe ná Pharisěophú yětahe to hénuôma, thǐ nuô̌bè́ cyá̤ dố mò́khu htyělé̤ké̤kǔ taki꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Thǐ ní̤huô̌ htuô̌dûhò́ ná Cò́marya hé ǔ mú꤮ nukhè̌, ‘Me̤thyě tǎ kayǎ tǎmé̤. Kayǎ tôprè̤prè̤ dố a me̤thyě ǔ nuô, ǔ bè cirya lǔ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Manárò vǎ hé thǐ, kayǎ tôprè̤prè̤ dố a thè́plòdu a khǒbò́thyó tahenuô, ǔ tǒbè cirya è. Htuô̌to kayǎ tôprè̤prè̤ dố a hé mǔmyá̤ricyá̤ a khǒbò́thyó tahenuô, ǔ tǒbè è́cuố cirya lǔ dố Judaphú a khuklò́dukhusuhtǔ tahe anyěhyǎ. Manárò kayǎ tôprè̤prè̤ ki hé ǔ, ‘Kayǎ olốoklò̌’ phúnuô hénuôma, a tǒ rò̤ ní̤dyé ané̤, me̤těhérò a hyǎtǒ phûhò́ ná mò́rapò̤tya̤ akǔhò́. ");
INSERT INTO kyu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Me̤phúnuôrò, nè̤ phyéhyǎní̤ nè̤ tè̤lǔtè̤tyǎ dố tè̤lǔrè̤́ a o rò bí nè̤ kíré̤ lǔhtya akhè̌, nè̤ ki tane̤htyabètuố̤ kayǎ tôprè̤prè̤ dố nè̤ me̤thû́ lǔ rò athè́plò mǐpé̤hí nè̤ to kihérò, ");
INSERT INTO kyu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dyakyǎ nè̤ tè̤lǔtè̤tyǎ bí tè̤lǔrè̤́ anyěhyǎ nuô, rò ka̤me̤ pě̤dwǒ krṳ̂̌klè̌ ré̤ ná ènuô. Htuô̌rò hyǎ lǔhtya no nè̤ tè̤lǔtè̤tyǎ yě. ");
INSERT INTO kyu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kayǎ tôprè̤prè̤ ki hé nè̤ ná nè̤ me̤thû́me̤plá lǔ rò a ki è́htya nè̤ dố khwíhi kihérò, bí thǐ hyǎ ró̤lǔ dố klyálo̤ akhè̌nuô, me̤ tǎ̤tǒtǎ̤bè pryǎré̤lè́kyǎ ná ènuô. Pǎma a dyétǎ̤kyǎ nè̤ dố prè̤ciryatè̤ a takhukǔ, rò prè̤ciryatè̤ yě ki dyétǎ̤ dǐtû́ nè̤ dố prè̤opò̤́ dò́tǎ̤ ǔ dố htò̌kǔ tahe a takhukǔ rò a ki dò́nuô̌kyǎ nè̤ dố htò̌kǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Vǎ hécò́cò́ nè̤, nè̤ ki plálǐlò̌bè́ nè̤su yěnuô to hénuôma, nè̤ htebè́ to.” ");
INSERT INTO kyu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Thǐ ní̤huô̌ htuô̌hò́ ná Cò́marya hé ǔ mú꤮ nukhè̌, ‘Cuốthû́ tǎ ǔphúǔmě tǎmé̤.’ ");
INSERT INTO kyu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Manárò vǎ hé thǐ, kayǎ tôprè̤prè̤ dố a myá prè̤mò rò a tane̤ patánuô, a cuốthû́hò́ ná prè̤mò nuôtôprè̤ dố a thè́plòkǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nè̤mèthè cò́htwó tôkyě ki nò̌me̤ nè̤ tè̤thû́ kihérò, kaǔhtekyǎ rò vǐkyǎ kyǎ è nuô. Phû꤮ ná ǔ ki vǐtǎ̤kyǎ lò̌ nè̤ né̤klò̤́ sǐprè̤ lò̌ dố ngarakǔ nuô, nè̤mèthè lè̌kyǎ tôkyě ma aryáklò̌ pǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nè̤ takhu cò́htwó tôkyě ki nò̌me̤ nè̤ tè̤thû́ kihérò, pǎ̤tṳ̂̌ rò vǐkyǎ kyǎ ènuô. Phû꤮ ná ǔ ki vǐtǎ̤kyǎ lò̌ nè̤ né̤klò̤́ sǐprè̤ lò̌ dố ngarakǔ nuô, nè̤ takhu tṳ̂̌kyǎ tôkhó ma aryáklò̌ pǎ cò́.” ");
INSERT INTO kyu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ǔ hé, ‘Kayǎ dố a thè́zṳ̂́ okyǎ amě nuô, a tǒbè dyé prè̤mò nuôtôprè̤ ná li-okyǎ plû́ lǔ a tè̤rǎmárǎdyǎ tôba.’ ");
INSERT INTO kyu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Manárò vǎ hé thǐ, prè̤khǔ ǔpěpě꤮ bèbè, amě cuốthû́ prè̤khǔ má̤to rò a ki okyǎ amě hénuô, a nò̌hò́ amě dố a ki cuốthû́ ná prè̤khǔ hò́. Ǔpěpě꤮ bèbè dố a ki cuốphyé ná prè̤mò dố avè̤ okyǎ lǔ yětôprè̤nuô, a cuốthû́hò́ ná prè̤mò nuôtôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Vǎ hé khyěthyá, thǐ ní̤huô̌ htuô̌dûhò́ Cò́marya hé ǔ mú꤮ nukhè̌, ‘Nè̤ ò́lya̤ htuô̌hò́ nè̤ngó̤ nuô, me̤pyékyǎ tǎmé̤. Cò́ná nè̤ tè̤ò́lya̤ dố nè̤ ò́lya̤ htuô̌hò́ ná Byacè Cò́marya tahenuô.’ ");
INSERT INTO kyu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Manárò vǎ hé thǐ, bí thǐ ò́lya̤ tôcôcô akhè̌nuô, cuốbyǎ tǎ taki꤮ tǎmé̤. Mò́khu bèbè, cuốbyǎ tǎ taki꤮ tǎmé̤. Mò́khu ma Cò́marya khǎlé̤ lé̤onyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hekhu bèbè, cuốbyǎ tǎ taki꤮ mé̤, me̤těhérò hekhu ma Cò́marya khǎduô lé̤zí̤. Vǐ̤ Jerusalem bèbè cuốbyǎ tǎ taki꤮ mé̤mé̤, me̤těhérò vǐ̤ Jerusalem ma khwídu cò́phyahtǔ lé̤o akhǎlé̤. ");
INSERT INTO kyu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Cuốbyǎ ka̤dyé tǎ nè̤ khuklò́ tǎmé̤mé̤, me̤těhérò khuluô̤ tôbǒphú prè́nuô nè̤ me̤lò̤me̤bǔ cyá̤to. ");
INSERT INTO kyu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nè̤ hébè akhè̌nuô, amá̤rò ‘amá̤’ hénuô, amá̤torò ‘amá̤to’ hénuô, lò̌꤮ tè̤hélốhéklò̌ nuôtahe ma a hyǎ dố khǐnéricyá̤ khuklò́ a o prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Thǐ ní̤huô̌ htuô̌dûhò́ ǔ hé, ‘Ki kayǎ tôprè̤prè̤ me̤lè̌ takè ǔmèthè nuô, ǔ bè me̤lè̌sûkhyě amèthè. Htuô̌rò a ki me̤lakè̤́ takè ǔkhukhyě nuô, ǔ bè me̤lakè̤́sûkhyě akhukhyě.’ ");
INSERT INTO kyu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Manárò vǎ hé thǐ, me̤lyě̤sû ka̤khyě tǎ kayǎcyě̤ kayǎricyá̤ nuôtôprè̤ tǎmé̤. Ki a plyá̤ thǐ khǎlí̤shyé tôkyě hérò dyé plyá̤ pó̤ è dố nuô tôkyěnuô. ");
INSERT INTO kyu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kayǎ tôprè̤prè̤ ki hé thǐ ná thǐ me̤thû́ lǔ, rò a ki kwǐplá thǐ ná ca̤ tôba dố prè̤cirya anyěhyǎ kihérò dyépó̤ è ná thǐ ca̤klò̌du nuô. ");
INSERT INTO kyu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kayǎ dố a pé̤epé̤ǒ thǐ rò a nò̌zácuố thǐ tǎ̤tè̤ tômilenuô, zácuố pé̤ è nyě̤mile nuô. ");
INSERT INTO kyu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kayǎ dố a kwǐ thǐ tôprè̤prè̤nuô, dyépé̤ è. Kayǎ dố a kwǐbòkwǐló̤ thǐnuô, dyébòdyéló̤ pé̤ è ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Thǐ ní̤huô̌ htuô̌dûhò́ ǔ hé, ‘Mo̤ní̤ nè̤khǒnè̤thyó rò thè́htekyǎ kayǎ dố a thè́hte nè̤ nuô.’ ");
INSERT INTO kyu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Manárò vǎ hé thǐ, mo̤ní̤ kayǎ dố a thè́hte thǐ nuôtahe rò kwǐcò́bè̌ pé̤ kayǎ dố a me̤cyě̤me̤cṳ̂ thǐ nuô tahe. ");
INSERT INTO kyu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Thǐ ki mo̤ní̤ ǔ phúnuô kihérò thǐ má̤hò́ Phè̌ Cò́marya dố mò́khu tôprè̤ a phúmòphúkhǔ thǐtahe hò́, me̤těhérò, kayǎcyě̤ kayǎricyá̤ tahe bèbè, kayǎ ryá tahe bèbè, Cò́marya nò̌htyaprè́ tamò̤́ tôbèbè꤮ tuô̌ prè́. Kayǎcò́ tahe bèbè, kayǎ cò́to tahe bèbè, Cò́marya nò̌cṳ̂tǎ̤ ké̤nuô ma a thyálǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Thǐ ki mo̤ní̤ prè́tû́ kayǎ dố a mo̤ní̤ thǐ nuôtahe prè́ kihérò Cò́marya dyé thǐ tè̤me̤ní̤khwókè to. Ki me̤prè́ phúnuô kihérò prè̤kwǐamo-arǎ tahe꤮ ma a me̤cyá̤ prè́prè́. ");
INSERT INTO kyu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Thǐ ki hémo̤héryá prè́tû́ thǐpuố̤thǐvyá̤ kihérò, a lé̤khólé̤khye tó̤ phútě? Kayǎ dố a zṳ̂́enyá̤e kuô̌ǔ Cò́marya to tahe꤮ rò phú thǐ me̤nuô꤮ ma a me̤cyá̤prè́ vǎhéto? ");
INSERT INTO kyu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Me̤phúnuôrò, phú thǐphè̌ dố mò́khu yětôprè̤ a ryálốryábǎ nuô, ryálốryábǎ thyákuô̌ ná è nuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Thyáphú ǔ ki myáhtye thǐ rò ǔ ki htuthè́ní̤ thǐ agněnuô, pṳ̌me̤ryá prè́ tè̤ dố kayǎ nyěhyǎ nuôma a tǒto. Thǐ ki me̤phúnuô héma, Phè̌ Cò́marya dố mò́khu tôprè̤ dyé pé̤ thǐ tè̤me̤ní̤khwókè to. ");
INSERT INTO kyu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Me̤phúnuôrò, bí thǐ me̤lǔme̤tyǎ kayǎ sǒrya̤sǒpháphú tahe akhè̌nuô, è́htǒè́mo̤ rò hésoluô̌ pé̤ tǎ ǔ phú kayǎ cyé̤zò́cò́te̤ ané̤ nuôtahe me̤nuô tǎmé̤ ní꤮, me̤těhérò thyáphú ǔ ki dyaduzṳ̂́nyá̤ èthǐ agněnuô, èthǐ me̤lǔme̤tyǎ kayǎ sǒrya̤sǒpháphú tahe dố Judaphú tè̤cò́bè̌ hǒkǔ ná dố klyádè̌kǔ. Vǎ hécò́cò́ thǐ, èthǐ ní̤bè lốbǎ htuô̌lò̌hò́ a tè̤me̤ní̤khwókè tahehò́. ");
INSERT INTO kyu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Manárò, thyáphú thǐ lǔhuôlǔthwè́ cyá̤ kuô̌ǔ kayǎ sǒphásǒrya̤phú tahe agněnuô, thǐ takhu cò́htwó dyétè̤nuô nò̌thè́gně tǎ takhu cò́ci tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Thǐ ki me̤phúnuô hò́rò, thǐphè̌ dố a myáhtye cyá̤ thǐ tè̤dyéhuôdyéthwè́ tôprè̤nuô, a ki dyé thǐ tè̤me̤ní̤khwókè tahe pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Rò bí thǐ kwǐcò́bè̌ akhè̌nuô, me̤ tǎ phú kayǎ cyé̤zò́cò́te̤ ané̤ tahe me̤nuô tǎmé̤, me̤těhérò, thyáphú ǔ ki myáhtye èthǐ nuô, èthǐ thè́zṳ̂́ cuốihtò kwǐcò́bè̌ lahyǎ dố Judaphú tè̤cò́bè̌ hǒkǔ htuô̌rò a thè́zṳ̂́ cuốihtòo dố klyáhtû̌klyáto̤ phúnuô. Vǎ hécò́cò́ thǐ, èthǐ ní̤bè lốbǎ htuô̌lò̌hò́ tè̤me̤ní̤khwókè tahehò́. ");
INSERT INTO kyu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Manárò thǐyě, bí thǐ kwǐcò́bè̌ akhè̌nuô, kanuô̌ dố hidò́kǔ rò thò́bí kadǎnuô. Htuô̌rò kwǐcò́bè̌htya pè̤phè̌ dố a odố tè̤tadwǒ akhǎlé̤ tôprè̤ a o nuô. Thǐphè̌ dố a myáhtye cyá̤ tè̤o tadwǒ tôprè̤nuô, a ki dyé thǐ tè̤me̤ní̤khwókè pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Thǐ kwǐcò́bè̌ akhè̌nuô, kwǐcò́bè̌ tǎ phú kayǎ dố a thè́gně kuô̌ǔ Cò́marya to nuôtahe kwǐcò́bè̌ nuô tǎmé̤. Èthǐ ma a kwǐcò́bè̌htǔ rò angó̤lasá oto. Ki kwǐcò́bè̌htǔ tû́ma Cò́marya dyé èthǐ prè́ a tane̤ lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Me̤ kuô̌ tǎ lahyǎ phú èthǐ me̤nuô tǎmé̤ ní꤮, me̤těhérò bí thǐ kwǐ tyahíto nuô, thǐphè̌ thè́gně ré̤lò̌ dûhò́ thǐ tè̤lo hò́. ");
INSERT INTO kyu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Thǐ tǒbè kwǐcò́bè̌ phútě hénuôma, kwǐ lahyǎ phúyě, ‘Kố꤮ pè̤ Phè̌ Cò́marya odố mò́khu꤮ ǔ ki dyadudyahtǔ bezṳ̂́benyá̤ ní̤dû nè̤mwi̤ sǎsè̌ yě ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nè̤ ki hyǎ isò́o ní̤dû nè̤htyěnè̤ké̤ bí hekhu yě ní꤮. Phú nè̤ tè̤thè́zṳ̂́thè́lò̌ lốbǎ htuô̌dûhò́ dố mò́khunuô, nò̌lốbǎ kuô̌dû è bí hekhuyě ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dyépé̤ pè̤ lé̤elé̤ǒ dố pè̤ lobè è yětônyě agně nuôtahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Phú pè̤ plwǒkyǎ htuô̌hò́ kayǎ dố a me̤thû́ pè̤ tahe atè̤thû́ nuô, plwǒkyǎ pé̤kuô̌ ré̤ pè̤ tè̤thû́tè̤ora dố pè̤ cuốme̤thû́ ǔ yěnuôtahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nò̌cuốnuô̌ tǎ pè̤ dố tè̤ilo-ilyá aklè̌nuô tǎmé̤ ní꤮. Má̤tôkhónuô me̤lwóhteka̤ ré̤ pè̤ dố khǐnéricyá̤ khuklò́ a takhukǔ yěnuô ní꤮. (Me̤těhérò htyěké̤ bèbè, tè̤pro̤tè̤prya̤ bèbè, tè̤taryědu taryěhtǔ bèbè má̤dûhò́ nè̤tè̤ tacṳ́prè̤ talèkrè́ hò́. Amèn.)’ ");
INSERT INTO kyu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Me̤těhérò thǐ ki plwǒkyǎ kayǎ dố a me̤thû́ thǐnuô tahe atè̤thû́ kihérò, thǐphè̌ o dố mò́khu yětôprè̤ ki plwǒkyǎkuô̌ thǐ tè̤thû́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Manárò thǐ ki plwǒkyǎ kayǎ dố a me̤thû́ thǐ nuôtahe atè̤thû́ to kihérò, thǐphè̌ o dố mò́khu yětôprè̤ plwǒkyǎkuô̌ thǐ tè̤thû́ toto.” ");
INSERT INTO kyu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bí thǐ duôesè akhè̌nuô, cyé̤nócyé̤kǎ tǎ thǐmèthè phú kayǎ cyé̤zò́cò́te̤ ané̤ nuôtahe tǎmé̤ ní꤮. Thyáphú ǔ ki thè́gně ná èthǐ duôesè nuôrò a cyé̤nócyé̤kǎ amèthè. Vǎ hécò́cò́ thǐ, dố ǔ htuthè́ èthǐ akhu-akhyě, èthǐ ní̤bè lốbǎ lò̌hò́ akhwóakèyě hò́. Khwókè dố aruô nuô a ní̤bè pǎtohò́. ");
INSERT INTO kyu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Manárò thǐyě, bí thǐ duôesè akhè̌nuô, plò̤́ lahyǎ thǐ khuklò́ ná máǔhtyě, khwípró̤ lahyǎ thǐ khuluô̤ rò plè̤́plǐ lahyǎ thǐ mèthè. ");
INSERT INTO kyu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Thyáphú ǔ ki myáhtyethè́gně tǎ ná thǐ duôesè tǎmé̤ nuô, me̤ lahyǎ phúnuô. Manárò thǐphè̌ odố tè̤tadwǒ yětôprè̤nuô a ki myáhtye tè̤me̤ dố a tadwǒ tahe rò a ki dyé thǐ tè̤me̤ní̤khwókè pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tè̤duzá̤htyathè̌ dố hekhu yěnuô, pṳ̌ dya-oplò́ tǎ dố thǐgně tǎmé̤, me̤těhérò tè̤ yětahe nuôma karò̤́ akrè̤́ e cyá̤, a hte-ihtekrè́ pyécyá̤, prè̤ehuôehí htyanuô̌ ehuô cyá̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Manárò dya-oplò́ lahyǎ thǐ tè̤duzá̤htyathè̌ dố mò́khu bí karò̤́ akrè̤́ e cyá̤ to, a hte-ihtekrè́ pyécyá̤to, prè̤ehuôehí htyanuô̌ cyá̤to akhǎlé̤ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Me̤těhérò, thǐ tè̤duzá̤htyathè̌ obítě tôphonuô, thǐ thè́plò otố̤kuô̌ bínuô.” ");
INSERT INTO kyu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mèthèplò yěnuôma athyáná mikò̌ tômě dố né̤klò̤́ agněhò́, thǐ mèthèplò ki lǐsè́ryá hérò, thǐ né̤klò̤́ sǐprè̤lò̌ ki luô̌lǐphó ryáklò̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Manárò thǐ mèthèplò ki lǐò́ruố̤ hénuôma, thǐné̤ ki khílò̌ sǐprè̤ pǎ. Tè̤lǐ dố a tǒ odố thǐkǔnuô, a ki oto hérò, a khítarṳ̂ cò́ bá꤮ těnuô tane̤ myádû ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ǔ me̤cyá̤ tè̤me̤ dố Byacè thè́nyě̤ atè̤nò̌ alè̤̌nuô a o tôprè̤꤮ to. A ki thè́htekyǎ ní̤dyé tôprè̤ pǎ, rò a ki mo̤ ní̤dyé tôprè̤ pǎ. Má̤torò a ki thè́plòícû̌ ní̤dyé tôprè̤ pǎ, rò a ki me̤takhwótakè sûkyǎ ní̤dyé tôprè̤ pǎ. Thǐ me̤pé̤lò̌ Cò́marya agněgně, rû̌ agněgně nyě̤côlò̌ nuô, aní̤ to.” ");
INSERT INTO kyu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Me̤phúnuôrò vǎ hé thǐ, bèkṳ́bèkyǎ̤ tǎ dố thǐ tè̤ohtwǒprè̤ agněnuô tǎmé̤. Dố thǐ lé̤elé̤ǒ agně bèbè, thǐ lé̤kû̌lé̤thyá agně bèbè, kṳ́kyǎ̤ tǎ lahyǎ tǎmé̤. Pè̤ thè́htwǒprè̤ yěnuô a loduklò̌ ná lé̤elé̤ǒ má̤to è̌? Pè̤ né̤klò̤́yě a loduklò̌ ná lé̤kû̌lé̤thyá má̤to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Myábû̌kuô̌ lahyǎ htuphúzuố̤phú dố mò́lè̤̌ nuôtahe. A isò́iplû̌ kuô̌ǔ to, a kè́ kuô̌ǔ buố to, a buốcyǎ okuô̌ǔ to tadû́rò thǐ Phè̌ Cò́marya dố mò́khu tôprè̤ buôe èthǐ. Thǐ rò, thǐ ngṳdupri̤duklò̌ ná htuphúzuố̤phú nuôtahe má̤to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Dố thǐkṳ́thǐkyǎ̤ akhu-akhyěrò, thǐ cwihtǔhyǎ è́htya cyá̤ ní̤dyéklò̌ pó̤ thǐ mò̤́nyěmò̤́thè̌ taki꤮ phú prè́nuô a o tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Thǐ cuốkṳ́cuốkyǎ̤ ná thǐ tè̤kû̌tè̤thyá agně me̤tě? Tè̤phǒtè̤kí̤ dố nyekhu nuôtahe a phè́htyaphǒhtya lahyǎ phútěnuô, tane̤ myámò̌ lahyǎ. Èthǐ erya̤ kuô̌ǔ tôcô꤮ to, a ihí kuô̌ǔ taphyá to. ");
INSERT INTO kyu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Manárò vǎ hé thǐ꤮, Khwí Solomo dố a o cò́ ná a tè̤duzá̤htyathè̌ lò̌꤮ plǐ cò́ yětôprè̤nuô, a hyeca̤ dố atwó̤ krṳ̂nya̤lè́ ná tè̤phǒ nuôtôphǒ prè́nuô a o tôba꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kayǎ dố a tè̤zṳ̂́ patíthǐ꤮ mi̤mò̤́ thòtò̤̌mò̤́ dố yětônyě rò aphè́htya, parǒpǎ rò ǔ bè isû́û̌ nuô̌kyǎ prè́ è ná mi prè́ yětahe꤮ rò Cò́marya dyékû̌dyéthyá lǔ kihérò, thǐyě tahenuô, Cò́marya ki dyékû̌dyéthyá tǎ̤te̤ lakǒ cò́ thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Me̤phúnuôrò, thukṳ́thè́kyǎ̤ lahyǎ tǎmé̤ ní꤮. ‘Pè̤ kíré̤ e pǎ ǐtě?’ ‘Pè̤ kíré̤ ǒ pǎ ǐtě?’ Tomaná ‘Pè̤ kíré̤ kû̌thyá pǎ ǐtě?’ Hé lahyǎ phúnuô tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Me̤těhérò kayǎ dố a thè́gně kuô̌ǔ Cò́marya to tahenuô, a lṳ̂myápṳ̌ me̤ lahyǎ phúnuô prè́. Manárò thǐphè̌ dố mò́khu yětôprè̤nuô a thè́gně lò̌plǐ hò́ thǐ tè̤lo nuôtahe hò́. ");
INSERT INTO kyu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Myápṳ̌ ré̤ lahyǎ Cò́marya ahtyěaké̤ ná a tè̤cò́tè̤te̤ tahenuô, rò lò̌꤮ tè̤dố thǐ lo yětahenuô, Cò́marya ki dyé kuô̌pó̤dû thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Me̤phúnuôrò, parǒpǎ agněnuô kṳ́kyǎ̤ tǎ lahyǎ tǎmé̤ ní꤮, me̤těhérò, parǒpǎ agněnuô, a tè̤kṳ́tè̤kyǎ̤ okhò ní̤dyédû pǎ. Tônyě ná tônyě a tè̤kṳ́tè̤kyǎ̤ nuô a pòkṳ́pòkyǎ̤ ní̤dyédû hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Hébò̌hébye ǔ, tane̤thû́bò̌tane̤thû́bye tǎ ǔ tǎmé̤ ní꤮. Cò́marya ki me̤lyě̤ ka̤khyěsû thyákuô̌khyě thǐ phúnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Me̤těhérò Cò́marya ki me̤lyě̤ ka̤khyěsû nè̤ phú nè̤ hébò̌hébye ǔ, nè̤ tane̤thû́bò̌thû́bye ǔ nuô pǎ. Nè̤ me̤ ǔ nè̤ hé ǔ bá꤮ těnuô, Cò́marya ki me̤ ka̤khyěsûlǐ kuô̌ke nè̤ bá꤮ nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Amûamá oprè́ dố thǐ puố̤vyá̤ prè̤zṳ̂́etè̤phú tôprè̤ a mèthèplòkǔ prè́ rò thǐ myáhtye, manárò thòklò̤́ tôklò̤́ o cò́ dố thǐ mèthèplòkǔ cò́ rò, thǐ myáhtye ní̤dyé kuô̌ǔ to me̤tě? ");
INSERT INTO kyu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bí thòklò̤́ o cò́ dố thǐ mèthèplòkǔ akhè̌nuô, thǐ cuốhétuố̤ thǐ puố̤vyá̤ tôprè̤, ‘Vǎ takhwó htekyǎ pé̤ nè̤ amûamá odố nè̤ mèthèplòkǔ nuô,’ hénuôma, a ní̤dè nyǎ è̌? ");
INSERT INTO kyu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Prè̤ cyé̤zò́cò́te̤ ané̤ thǐ꤮ phyéhtekyǎ ré̤lố thòklò̤́ o dố thǐ mèthèplòkǔ nuô, tû́rò thǐ myáhtyeluô̌ryá rò thǐ takhwó htekyǎ cyá̤ pé̤ amûamá o dố thǐ puố̤vyá̤ a mèthèplòkǔ yěnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tè̤sǎsè̌ nuô dyé tǎ ná htwitahe tǎmé̤, vǐtǎ̤ pé̤ tǎ lò̤́thélò̤́pro̤ tahe dố htyátahe anyěhyǎ nuô tǎmé̤, thǐ ki vǐtǎ̤ pé̤ è hénuôma a ki zí̤taprò́kyǎ lò̌ pǎ, htuô̌pǎrò a ki a̤ ka̤khyě thǐ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kwǐ mò̌ lahyǎ, thǐ ki ní̤bè pǎ! Myápṳ̌ mò̌ lahyǎ, thǐ ki myáhtye pǎ. Dòmò̌ lahyǎ kadǎnuô, Cò́marya ki bámǒ pé̤dû thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Me̤těhérò lò̌꤮ kayǎ dố a kwǐtè̤ tahenuô, a ki ní̤bè pǎ, rò lò̌꤮ kayǎ dố a myápṳ̌ tè̤ tahenuô, a ki myáhtye pǎ, rò lò̌꤮ kayǎ dố a dò kadǎ tahenuô, Cò́marya ki bámǒ pé̤ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Dố thǐklè̌nuô thǐphú ki kwǐe thǐ sèe hérò thǐ dyée èthǐ ná lò̤́ nuôma a onyǎ tôprè̤prè̤ è̌? ");
INSERT INTO kyu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tomaná thǐphú ki kwǐe thǐtè̤̌ hérò thǐ dyée èthǐ ná rṳ́nuôma a onyǎ tôprè̤prè̤ è̌? ");
INSERT INTO kyu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Thǐ ma kayǎ dố a cyě̤ricyá̤ tahe prè́ tadû́rò thǐ thè́gně dyée thǐphúthǐlye̤ tahe ná tè̤dố aryá tahe cò́ kihérò, tane̤myámò̌ lahyǎ thǐphè̌ dố mò́khu yětôprè̤nuô, a ki dyé tǎ̤te̤ má̤lakǒ pé̤ cò́ tè̤ryá tahe ná kayǎ dố a kwǐhtya lǔ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Me̤pé̤ ǔ phú thǐ thè́zṳ̂́ nò̌me̤ ǔ ná thǐné̤ nuô ní꤮. Mame̤těhérò lò̌꤮ Mosè a tè̤thyótè̤thya ná prè̤pro̤ tahe a tè̤hékyǎngó̤ tahenuô, a thè́zṳ̂́ hé angó̤lasá nuôma yěnuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Cuốnuô̌ lahyǎ dố lo̤kadǎ a-i nuôtôkǔ, me̤těhérò lo̤kadǎlyá̤ yětôkǔnuô ná klyályá̤ yětôbǒnuô a thǔcuố ǔ dố tè̤thyě tacṳ́prè̤ akhǎlé̤ rò ǔ cuố nuô̌ró̤nuô̌è́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Manárò lo̤kadǎ a-i yětôkǔ ná klyái yětôbǒ dố a thǔcuố ǔ dố tè̤htwǒprè̤ tacṳ́prè̤ yěnuô kayǎ myáhtye patí꤮ nyacò́ lǔ.” ");
INSERT INTO kyu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Rò̤ní̤ lahyǎ thǐné̤ ná prè̤klwo lahǒ ané̤ phú prè̤pro̤ nuôtahe ní꤮. A klwohyǎ lahǒ ané̤ phú thímí dố a thè́dǒthè́nga̤ nuô tadû́rò èthǐ athè́plòkǔ nuôma a mǔmyá̤ricyá̤ thyácò́ná htwimi̤ nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dố èthǐ me̤ tè̤mǔmyá̤ akhu-akhyě, thǐ thè́gně cyá̤ ná èthǐ ma prè̤klwo lahǒhyǎ ané̤ tahe prè́. Kayǎ dố a cuốpṳ̌ iba-e thòbǐthè dố thòshyámò̤́lo̤, kimá̤torò a cuốpṳ̌ iba-e kadwíthè dố thòshyámò̤́lo̤ nuôma a o nyǎ è̌? ");
INSERT INTO kyu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Phúnuôhò́, thò dố aryá nuô, a ki thèhtya dố aryá. Manárò thòmò̤́ dố aryáto nuô, a ki thèhteprè́ thòthè dố aryáto prè́. ");
INSERT INTO kyu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Thòmò̤́ dố aryá nuô, athèhte cyá̤ thòthè dố a mǔmyá̤ to. Htuô̌rò thòmò̤́ dố a mǔmyá̤ nuô, a thèhte cyá̤ thòthè dố aryáto. ");
INSERT INTO kyu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lò̌꤮ thòmò̤́ dố a thèhtya aryáto tahenuô, ǔ ki pǎ̤tṳ̂̌kyǎ lǔ pǎ rò ǔ ki vǐnuô̌kyǎ lò̌ lǔ dố mikǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Me̤phúnuôrò thǐ ki thè́gně cyá̤ prè̤klwo lahǒ ané̤ yětahenuô ná a tè̤thèhtyaphǒhtya nuôtahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Lò̌꤮ kayǎ dố a è́ vǎ, ‘Byacè꤮ Byacè’ nuô, a nuô̌ ní̤lò̌ dố mò́khu htyělé̤ké̤kǔ pwǒ̤꤮ tôprè̤ má̤to. A nuô̌ní̤ prè́tû́ kayǎ dố a me̤tǒme̤bè vǎphè̌ dố mò́khu tôprè̤ athè́plò nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Shyé꤮ mò̤́nyě cirya pǎ tônyěnuô, kayǎ ki hyǎ héluô̌htya ró̤è́lǎ lahyǎ pǎ rò a ki hé lahyǎ, ‘Byacè꤮ Byacè, pè̤ hésodônyǎ pé̤ ǔ phú Thè́ Sǎsè̌ Byacè héso pé̤ pè̤ nuô ná nè̤mwi̤, htuô̌rò pè̤ vè̤́htekyǎ khǐnékhǐnò̌ tahe ná nè̤mwi̤, htuô̌rò pè̤ dyéluô̌ tè̤pro̤tè̤prya̤ tahe ná nè̤mwi̤ nuô a è́lǎ hò́, vǎhéto.’ ");
INSERT INTO kyu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bínuô akhè̌pǎ vǎ ki hélǐsû èthǐ, ‘Vǎ thè́gněnò́ thǐ takhyá꤮ to. Kayǎ dố a me̤ tè̤mǔmyá̤ricyá̤ thǐ꤮ htecuố taphǎkyǎ ye̤ ná vǎ.’” ");
INSERT INTO kyu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Phúnuôrò kayǎ tôprè̤prè̤ dố a ní̤huô̌ vǎlǎ̤vǎngó̤ rò a ní̤dǎ krwǒme̤ phú vǎ hé nuô hénuôma, a thyáhò́ ná kayǎ plǒphè́ tôprè̤ sò́o ahi dố lò̤́khu nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ké̤cṳ̂duhyǎ htyěduhtyabǎ, ké̤lathè́ lalyǎdu hyǎbè hiyě tadû́rò a lakhû́to, me̤těhérò ǔ isò́htya è dố lò̤́khu. ");
INSERT INTO kyu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Manárò kayǎ tôprè̤prè̤ dố a ní̤huô̌ vǎlǎ̤vǎngó̤ rò a ki ní̤dǎ krwǒme̤ kuô̌ phú vǎ hénuô to hénuô, athyáná kayǎ tane̤plǒtane̤phè́ kuô̌ǔ to tôprè̤ isò́htya-o ahi dố hethǒkhu nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ké̤cṳ̂duhyǎ htyěduhtyabǎ, ké̤lathè́ lalyǎ hyǎbè hiyě rò a latǎ̤prò̤ lò̌lá̤takli prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bí Byacè Jesǔ héhtuô̌hò́ tè̤yětahe akhè̌nuô, kayǎ bè́mṳ dố a ní̤huô̌ lǔ tè̤ithyóithya yětahenuô, a khyéthukhyéthè́ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Me̤těhérò, a ithyóithya thyákuô̌phú prè̤ithyó tè̤thyótè̤thya athárá nuôtahe ithyó nuô to. A ithyó thyácò́ná kayǎ dố a o ná a taryěshyosò̌ tôprè̤ ithyó nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bí a o dố sorò̤̌lo̤ rò a hítǎ̤lya̤ akhè̌nuô, kayǎ tahe krwǒplukrwǒphè kuô̌lò̌ lǔkhyě è́lǎ. ");
INSERT INTO kyu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kayǎ tè̤sè̌mǔmyá̤ dố phálo̤ tôprè̤ hyǎ dángṳ̂lya̤ dố lǔnyěhyǎ rò a hé lǔ, “Byacè, nè̤ ki thè́plòo zasǐmé̤ pé̤ vǎ tè̤sè̌yě hénuôma, nè̤ zacyá̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Byacè zó̤hyǎ atakhu rò a tôbèhtuô̌ lǔ rò a hé lǔ, “Vǎ thè́plòo prè́,” a hé htuô̌rò “Tè̤sè̌꤮ sǐmé̤kyǎ mò̌,” a hé pó̤ phúnuô, rò tôphuốtuô̌ tè̤sè̌ sǐmé̤kyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Rò Byacè Jesǔ hé lǔ, “Hésoluô̌ pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮, manárò cuố dyéluô̌myá nè̤né̤ yěnuô dố bwídu nuôtôprè̤ a o nuô ní꤮. Htuô̌rò thyáphú a ki htwǒhtya tè̤khyáthè́ dố ǔ pwǒ̤꤮ tôprè̤ a mèthènyě ná nè̤ tè̤sè̌ sǐmé̤hò́ rò a mwǒ̤plǐhò́ agněnuô, lǔhtya tè̤lǔtè̤tyǎ phú Mosè mekyǎ nuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bí Byacè Jesǔ hyǎnuô̌ dố vǐ̤ Capernaum akǔ akhè̌nuô, Roma klyětôzè̤ akhuklò́ tôprè̤ hyǎkwǐ lǔ tè̤me̤cwó̤. ");
INSERT INTO kyu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Rò a hé lǔ, “Byacè vǎlulé tôprè̤ aswí thyětôkyě rò a omyětyá̤ prè́ dố lé̤omyěkǔ phúnuô. Acyě̤ nyacò́ lǔ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Byacè Jesǔ hésû lǔ, “Vǎ cuố zasǐmé̤dû pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Klyěphú tôzè̤ akhuklò́ nuôtôprè̤ hésû, “Byacè, nè̤ hyǎnuô̌prè́ dố vǎhikǔ prè́nuô a kò ná vǎ to. Hétǎ̤prè́ nè̤ngó̤ tômû̌prè́ nuôma vǎlulé omo̤khyě nyǎdûhò́. ");
INSERT INTO kyu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mame̤těrò vǎ hé phúyě hénuôrò vǎ né̤byacè ní̤dû vǎ bè ní̤dǎ kayǎ dố aduklò̌ ná vǎ tahe angó̤. Phúnuôhò́ klyěphú dố a o dố vǎlè̤̌ tahenuô a bè ní̤dǎ kuô̌dû vǎngó̤ phúnuônuô. Ki vǎ hé klyěphú tôprè̤prè̤, ‘cuốmò̌,’ hénuôma a bècuố prè́, ki vǎ hé ke dố aruôtôprè̤, ‘hyǎmò̌,’ hénuôma a bè hyǎ prè́. Htuô̌to vǎ ki hé vǎcṳ̂́, ‘me̤mò̌yě,’ hénuôma a bè me̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bí Byacè Jesǔ ní̤huô̌ tè̤hébè yě akhè̌, a khyéthukhyéthè́ nyacò́ rò a hé kayǎ dố a krwǒ lǔkhyě tahe, “Vǎ hécò́cò́ thǐ, tè̤zṳ̂́tè̤nyá̤ sò̌phúyě dố Israelphú aklè̌nuô vǎ myáhtyenò́ híto. ");
INSERT INTO kyu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Vǎ hé thǐ, kayǎ o dố ké̤cíhte ké̤cínuô̌ tahe ki hyǎ è́lǎ pǎ. Èthǐ ki hyǎ onyǎ etố̤kuô̌ ná pè̤phuô̌ Abraham, Phuô̌ Isaac, Phuô̌ Jacob dố mò́khu a htyělé̤ké̤kǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Judaphú tahenuô, a tǒkò htwǒ Cò́marya akayǎ dố Cò́marya ahtyěaké̤kǔ nuô tadû́rò Cò́marya ki vǐnuô̌kyǎ èthǐ dố tè̤khítè̤lò̤ akhǎlé̤ pǎ. Tè̤khǎlé̤ bí èthǐ ki cuố o yětôpho pǎnuô, èthǐ ki cuố nguố̤plyá̤nguố̤rya̤ rò èthǐ ki a̤takrṳ̂ ní̤dyé lò̌plǐ cò́ akhukhyě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Htuô̌rò a hé klyěkhuklò́, “Ka̤mò̌, a ki htwǒhtyadû phú nè̤ zṳ̂́e nuô pǎ.” Rò alulé nuôtôprè̤ omo̤ka̤ tǒtû́ bí Byacè hé lǔ ashuốkhè̌nuô. ");
INSERT INTO kyu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bí Byacè Jesǔ cuốnuô̌ dố Petru ahikǔ akhè̌nuô, a myáhtye Petru a prè̤́prè̤mò thè́swíné̤kṳ́ rò a omyětyá̤ prè́ dố lé̤myěkhu prè́. ");
INSERT INTO kyu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A pṳ̂́ lǔtakhu rò a tè̤swí sǐmé̤kyǎ. Htuô̌rò a ihtò me̤-eme̤ǒsû pé̤ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bí mò̤́hémò̤́tǎ̤ akhè̌nuô, ǔ hyǎthǔ è́lǎ kayǎ dố khǐnékhǐnò̌ me̤bè lǔ tahe dố Jesǔ a o. A hétǎ̤ prè́ angó̤ tômû̌mû̌꤮ tuô̌ prè́ rò khǐnékhǐnò̌ htecuốkyǎ lò̌. Htuô̌rò a zasǐmé̤ pé̤ lò̌plǐ lò̌꤮ ǔswíǔsè̌ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tè̤ yětahenuô a me̤lốme̤bǎhtya Prè̤pro̤ Isaiah a tè̤héone, “A phyécuốkyǎ pè̤ tè̤swítè̤sè̌ tahe.” ");
INSERT INTO kyu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bí Byacè Jesǔ myáhtye ná kayǎ bè́mṳ hyǎ otava̤ lò̌ è akhè̌nuô, a hétǎ̤ angó̤ dố a khǒpacè̤̌ tahe a o ná pè̤ ki cuố dố htyěòdu abè́rè̤̌ pó꤮, a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bínuôakhè̌, prè̤ithyó tè̤thyótè̤thya athárá tôprè̤ hyǎ dố lǔ o rò a hé lǔ, “Thárá, nè̤ cuố bítě꤮ tôpho bèbè, vǎ cuốkuô̌ ná nè̤.” ");
INSERT INTO kyu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Byacè Jesǔ hé lǔ, “Htwimi̤ tahe o ná akǔ, htutahe o ná apwi̤, tadû́rò prè̤lukayǎ aphúkhǔyě, bí akhuklò́ lé̤dyatǎ̤ prè́nuô a oto.” ");
INSERT INTO kyu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A khǒpacè̤̌ dố aruôtôprè̤ hé lǔ, “Byacè, dyéré̤ vǎ ashuốkhè̌ dố vǎ ki ka̤ iluố ré̤ kuốré̤ vǎphè̌ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Manárò Byacè Jesǔ hésû lǔ, “Krwǒkuô̌ cò́ vǎkhyě khǒnyá̤yě, kayǎ dố a ní̤dǎ Cò́marya angó̤ to tahe nuôma athyáná kayǎthyě yěnuôhò́. Nò̌iluố ní̤dyédû kayǎthyě yěnuô ná èthǐnuô.” ");
INSERT INTO kyu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bínuôakhè̌ Byacè Jesǔ nuô̌ dố thòklyěkǔ rò a khǒpacè̤̌ tahe krwǒnuô̌ kuô̌ lǔ rò èthǐ htecuốkyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bí èthǐ cuốtuố̤ dố htyě klǎměkǔ akhè̌nuô, ké̤lathè́ lalyǎ hyǎ khyé. Htyě háhódu rò a plyá̤nuô̌ lò̌ dố thòklyěkǔ. Bínuôakhè̌ Byacè Jesǔ omyění̤ sǒtapa̤. ");
INSERT INTO kyu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Rò a khǒpacè̤̌ tahe cuố hturyǎ̤ihtò lǔ rò a hé lǔ, “Byacè, me̤cwó̤mò̌ pè̤, pè̤ kíré̤ lacû́thyě lò̌hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Rò Byacè Jesǔ hé èthǐ, “Kayǎ tè̤zṳ̂́patí thǐ꤮, vǎ okuô̌ ná thǐ rò thè́isě lahyǎ tǎmé̤.” A héhtuô̌ rò a ihtò thè́prwǒ̤ ké̤lathè́yě ná htyěháhó yětahe. Rò ké̤lathè́ okuố hyǎkhyécò́. ");
INSERT INTO kyu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A khǒpacè̤̌ tahe khyéthukhyéthè́ lò̌plǐ rò a hé lahyǎ lǔ, “Kayǎ yětôprè̤ ma kayǎ cò́ phútětě? Ataryě cuốdu cò́ bánuônuô. Ké̤lathè́ ná htyěháhó ní̤dǎ cò́ lǔngó̤ngó̤.” ");
INSERT INTO kyu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bí Jesǔ cuốtuố̤ dố htyěòdu bè́rè̤̌, Gadarene ké̤ akhè̌nuô, kayǎphè̌ dố khǐnékhǐnò̌ me̤bè lǔ thè́nyě̤yě a o dố luô̤̌khu hte rò a htecuố myáhtyesû ná lǔ. Kayǎphè̌ yěthè́nyě̤ nuô, khǐné me̤bè lǔ akhu-akhyě, ashyo-asò̌, a taròthè́ thè́isě nyacò́ rò klyá cuố bí luô̤̌htû̌ nuôtôbǒ nuô ǔ cuốphûbû tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Èthǐ è́htǒ, “Cò́marya aphúkhǔ, nè̤ thè́zṳ̂́ me̤ pè̤ phútě? Cò́marya amò̤́nyě cirya ǔ ashuốkhè̌ tuố̤ tyahíto akhè̌nuô, nè̤ kíré̤ hyǎme̤ kryá꤮ pè̤ ǐtě?” ");
INSERT INTO kyu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bí aye̤lǎ ná èthǐ to nuô, htyá o tômṳdu rò a e lahyǎ asè bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Khǐné me̤bè kayǎphè̌ yěthè́nyě̤ nuô, a kwǐthè́zò̤ Byacè Jesǔ, “Ki nè̤ vè̤́htecuốkyǎ pè̤ hérò, nò̌cuốnuô̌o ré̤ pè̤ dố htyá nuôtahe akǔ nuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Byacè hésû èthǐ, “Cuốnuô̌omò̌ lahyǎ!” Rò èthǐ htecuố nuô̌ olò̌ lahyǎ dố htyá nuôtômṳ akǔ, rò htyá tahe klya talwǒ̤tǎ̤ bè́mṳlò̌ rwólá̤ tanyálo̤ rò lacû́ tǎ̤thyě nuô̌lò̌ dố htyěòdukǔ. ");
INSERT INTO kyu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Prè̤kyě̤htyá yětahe klyaka̤ dố vǐ̤kǔ rò a klyaka̤ dyásoluô̌ pé̤ ǔ ná lò̌꤮ tè̤htwǒhtya ané̤ yětahe ná tè̤me̤-ané̤ ná kayǎphè̌ thè́nyě̤yě lò̌꤮ plǐ. ");
INSERT INTO kyu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kayǎ tôvǐ̤lò̌ hyǎhtemyá lò̌ cò́ Jesǔ. Htuô̌rò bí èthǐ myáhtye Byacè Jesǔ akhè̌, a kwǐthè́zò̤ lǔ ná a ki htecuố taphǎkyǎ ná èthǐ ké̤kû̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Byacè Jesǔ nuô̌ dố thòklyěkǔ rò cuốbè́ htyěòdu rò a ka̤ dố adò̌ dố a cuốo yětôdò̌. ");
INSERT INTO kyu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kayǎ tahe záhyǎní̤ kayǎ thyětôkyě tôprè̤ dố Byacè Jesǔ a o rò a omyěo prè́ dố lé̤myěkhu. Bí Byacè Jesǔ myáhtye èthǐ tè̤zṳ̂́ akhè̌nuô, a hé kayǎ thyětôkyě nuôtôprè̤, “Vǎ phúprè̤khǔ꤮ dyashyodyasò̌ nè̤ thè́plò ní꤮. Vǎ plwǒkyǎhò́ nè̤ tè̤thû́ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bínuôakhè̌ prè̤ithyó tè̤thyótè̤thya athárá tahe tane̤ lahyǎ dố a thè́plòkǔ, “Kayǎ yětôprè̤ hébèthû́ hò́ Cò́marya hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Byacè Jesǔ thè́gně luplú lò̌plǐ èthǐ tè̤tane̤ nuôtahe rò a hé èthǐ, “Mame̤těrò thǐ cuố tane̤ mǔmyá̤ricyá̤ tuố̤ tè̤phúnuô tahe dố thǐ thè́plòkǔ me̤tě? ");
INSERT INTO kyu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Vǎ plwǒkyǎ nè̤ tè̤thû́ hò́’ héma azǔklò̌ è̌? Kimá̤torò ‘Kahtò rò cuốmò̌’ héma azǔklò̌ è̌? ");
INSERT INTO kyu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Manárò prè̤lukayǎ aphúkhǔ má̤ vǎyě, thyáphú thǐ ki thè́gně lahyǎ ná dố hekhu yěnuô, vǎ o ná taryěshyosò̌ dố vǎ plwǒkyǎbè́ ǔ tè̤thû́tè̤plá tahenuôrò, vǎ ki dyéluô̌ pé̤ thǐ,” a hé htuô̌phúnuôrò, a hé kayǎphè̌ thyětôkyě yětôprè̤, “Ihtò talǔní̤ nè̤ klolé̤myě nuôrò ka̤mò̌ dố nè̤ hinuô.” ");
INSERT INTO kyu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kayǎ nuôtôprè̤ ihtòka̤ dố ahi. ");
INSERT INTO kyu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cò́marya dyétǎ̤pé̤ kayǎ a taryěshyosò̌ phúyě akhu-akhyě, bí kayǎ bè́mṳ myáhtye tè̤me̤-ané̤ phúnuô akhè̌, èthǐ thè́isě bezṳ̂́nyá̤ lahyǎ Cò́marya rò htuthè́htya lahyǎ Cò́marya. ");
INSERT INTO kyu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bí Byacè Jesǔ htecuốkyǎ bínuôakhè̌, a myáhtye kayǎ tôprè̤ amwi̤ ná Matteo onyǎo me̤ tè̤me̤ dố lé̤kwǐ amo-arǎ hikǔ. Byacè Jesǔ hé lǔ, “Cuố꤮, krwǒkuô̌ vǎkhyě rò htwǒkuô̌ vǎ khǒpacè̤̌.” Rò Matteo ihtòcuố rò krwǒkuô̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bí Byacè Jesǔ edǐ mò̤́hé dố Matteo hi akhè̌nuô, prè̤kwǐamo-arǎ tahe ná prè̤oraphú tahe hyǎ etố̤plu-etố̤phè kuô̌lò̌ ná Jesǔ ná a khǒpacè̤̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bí Pharisěophú tahe myáhtye phúyě akhè̌, a sudyǎ a khǒpacè̤̌ tahe, “Thǐ Thárá rò a cuố etố̤ǒtố̤ kuô̌tuố̤ ná prè̤kwǐamo-arǎ ná prè̤tè̤oraphú nuôtahe me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Byacè Jesǔ ní̤huô̌huô̌ ná a hésû èthǐ, “Kayǎ dố a oshyo-opryǎ tahenuô, a lo ná tè̤khuthárádu to. Kayǎ dố aswíasè̌ tahenuô tû́ma a lo prè́ tè̤khuthárádu prè́. ");
INSERT INTO kyu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Manárò pṳ̌thè́gně lahyǎ Cò́marya thè́zṳ̂́ hé angó̤lasá tahe dố a hé, ‘Vǎ thè́zṳ̂́ tè̤lǔtè̤tyǎ to, vǎ thè́zṳ̂́prè́ tè̤thè́zò̤klabè ní̤ lǔ tôprè̤ ná tôprè̤ nuôprè́.’ Me̤těhérò, vǎ hyǎ è́ka̤ kayǎ dố acò́ate̤ nuôtahe má̤to. Vǎ hyǎ è́ka̤prè́ kayǎ dố a tè̤thû́tè̤ora odûgně nuôtahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Htuô̌rò Giovanni Baptista a khǒpacè̤̌ tahe hyǎ dố Byacè Jesǔ a o rò a hyǎ sudyǎ lǔ, “Pè̤ ná Pharisěophú tahenuô, pè̤ duôesè, manárò nè̤ khǒpacè̤̌ yětahe rò a duôe kuô̌ǔ sè to me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Byacè Jesǔ hésû èthǐ ná ngó̤khákho tômû̌ rò a hé, “Bí khǒmè̤̌khǔphè̌ otố̤kuô̌pǎ ná akhǒ sǐpré̤sǐmya̤ akhè̌nuô, a khǒsǐpré̤ yětahe cuốthè́plè̤̌ cyá̤ phútě? Manárò shyé꤮ shuốkhè̌ hyǎtuố̤hò́ dố ǔ è́cuố taphǎkyǎhò́ khǒmè̤̌khǔphè̌ hò́pǎ akhè̌nuô, èthǐ ki duôeduôǒ lahyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ǔ isè́phè hyeca̤lye̤ ná ikè̤̌thè̌ dố a tanuố hítoyě nuô a o tôprè̤꤮ to, me̤těhérò ki isè́phè hénuô ikè̤̌thè̌yě a ki htò́tanuốka̤ rò a lé htò́tazwí lazè̤̌ cuốlyá̤ryá pó̤ hyeca̤lye̤yě pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ǔ zṳ̂nuô̌ htyězǎ̤thè̌ dố htyěǒphálye̤kǔ nuô a o tôprè̤꤮ to. Ǔ ki zṳ̂nuô̌ phúnuô hérò, htyěǒphá ki pò̤́pruố rò htyězǎ̤ ki lakuố̤lò̌ pǎ. Htuô̌to htyěǒphá ki pyékyǎ lò̌ pǎ. Phúnuôrò ǔ zṳ̂nuô̌ prè́ htyězǎ̤ athè̌ yěnuô dố htyěǒphá athè̌kǔ prè́. Ki me̤phúnuô hérò htyězǎ̤ bèbè, htyěǒphá bèbè, a pyé pǎ to.” ");
INSERT INTO kyu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bí a hébè ǔ phúyě akhè̌nuô, tè̤cò́bè̌hǒ khuklò́du tôprè̤ hyǎ dángṳ̂lya̤ dố lǔnyěhyǎ rò a hé lǔ, “Vǎ phúprè̤mò thyěmópǎprè́, manárò ka̤kuô̌ vǎ rò ka̤dyahtya nè̤ takhu dố alo̤ ma a klyá htwǒprè̤ nyǎ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Byacè Jesǔ ihtò rò krwǒka̤kuô̌ lǔ. Rò a khǒpacè̤̌ krwǒka̤kuô̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bí èthǐ ka̤ dố klyálo̤ akhè̌nuô, prè̤mò dố a khyábè tè̤sè̌thwitǎ̤ dố anyě̤ cò́hò́ shyényě̤na nuô a o tôprè̤, rò a krwǒka̤kuô̌ Byacè khyěkhu rò a hyǎ tôbè Jesǔ ca̤kyǎkhǎmí̤. ");
INSERT INTO kyu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Vǎ ki tôbè prè́bí aca̤cwo̤ yěnuôprè́ ma vǎ tè̤sè̌thwitǎ̤ yě klyá sǐmé̤ nyǎ hò́,” a hé huô ní̤dyédû ané̤ rò a hyǎ dố Jesǔ khyěkhu rò a hyǎ tô lǔ ca̤kyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Byacè Jesǔ tarí myáka̤khyě rò myáhtye lǔ akhè̌ a hé lǔ, “Phúmò, dyashyodyasò̌ nè̤ thè́plò ní꤮, nè̤ tè̤zṳ̂́ yěnuô, a zasǐmé̤ kyǎhò́ nè̤ tè̤sè̌hò́.” Yětôphuốrò prè̤mò yětôprè̤ a tè̤sè̌nuô, a lamé̤ tôphuố lamé̤kyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bí Byacè hyǎnuô̌ dố Judaphú khuklò́ yětôprè̤ ahikǔ akhè̌nuô, a myáhtye kayǎ uốtěló tahe ná kayǎ nguố̤hè pra̤rû́pra̤tè́ tôplutôphè rò a hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Cuốtaphǎ lò̌ lahyǎ. Pacè̤̌muố̤phú yětôprè̤ ma a thyě má̤to, a omyě sǒtapa̤ prè́.” A hé rò ǔ nyě̤kruô̌ lò̌plǐ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bí ǔ nò̌htelò̌ htuô̌ kayǎ bè́mṳ nuôtahe dố aklò̌ khè̌nuô, Jesǔ nuô̌ dố hidò́kǔ bí pacè̤̌muố̤phú yětôprè̤ lé̤omyěo khǎlé̤ nuô rò a pṳ̂́ lǔtakhu akhè̌ pacè̤̌muố̤phú yětôprè̤ ihtòka̤khyě. ");
INSERT INTO kyu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tè̤ritè̤kyǎ yě a luô̌ pasǐ cuốlò̌ cò́ pwǒ̤htyěpwǒ̤ké̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bí Byacè Jesǔ htecuốkyǎ bínuô tôpho akhè̌, kayǎ mèthèkhí thè́nyě̤ krwǒ è́htǒ kuô̌ lǔkhyě, “Kố꤮ Davi aphúkhǔ, thè́zò̤ rò me̤cwó̤ré̤ pè̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bí Byacè cuốnuô̌ dố hi tôměkǔ akhè̌nuô, kayǎ yěthè́nyě̤ krwǒnuô̌ kuô̌ lǔ rò Byacè Jesǔ sudyǎ èthǐ, “Vǎ me̤lǐ cyá̤ thǐ mèthè nuô thǐ zṳ̂́e è̌?” Èthǐ hésû, “Ò, pè̤ zṳ̂́e, Byacè.” ");
INSERT INTO kyu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Rò Byacè tôhyǎ èthǐ mèthèplò rò a hé, “Dố thǐ zṳ̂́e akhu-akhyě, vǎ zasǐmé̤ thǐ.” ");
INSERT INTO kyu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Rò èthǐ mèthè lǐka̤khyě khyěthyá lò̌. Byacè Jesǔ metǎ̤mete̤kyǎ èthǐ, “Dyásoluô̌ pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Manárò èthǐ htecuố rò cuốlě dyáso pasǐlò̌ tè̤ritè̤kyǎ yě bí nuôtôké̤ akǔ dố khǎlé̤ pwǒ̤꤮ tôpho. ");
INSERT INTO kyu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bí kayǎ mèthèkhí yěthè́nyě̤ htecuố htuô̌nuô, ǔ è́hyǎní̤ kayǎphè̌ dố khǐné me̤bè lǔ rò a pè́ tôprè̤ dố Byacè Jesǔ a o. ");
INSERT INTO kyu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bí Byacè Jesǔ vè̤́htekyǎ htuô̌hò́ khǐné akhè̌nuô, kayǎpè́ yětôprè̤ hébè cyá̤ ka̤khyě khyěthyá. Rò kayǎ bè́mṳ tahe khyéthukhyéthè́ nyacò́. “Ǔ me̤cyá̤ tè̤ phúyě dố Israelphú aklè̌nuô myáhtye nò́hí takhyá꤮ to,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Manárò, Pharisěophú tahe hé, “A vè̤́htekyǎ cyá̤ khǐné tahe phúyě nuôma má̤prè́ khǐné khuklò́du nuôtahe yǒ dyé lǔ taryěpro̤prya̤ nuô khukhyě prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Byacè Jesǔ lě cuốlò̌ vǐ̤ pwǒ̤tôvǐ̤ dò̌ pwǒ̤꤮ tôdò̌ rò lě ithyóithya pé̤ ǔ dố Judaphú tè̤cò́bè̌hǒ tahe akǔ, rò cuốnuô̌ dônyǎhéso pé̤ ǔ ná Cò́marya ahtyěaké̤ a tè̤thè́krṳ̂̌mila ari-akyǎ, rò zasǐmé̤ pé̤ lò̌ ǔ tè̤swítè̤sè̌ pwǒ̤tôcô. ");
INSERT INTO kyu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bí a myáhtye kayǎ bè́mṳ dố a bèpyá̤bèsè̌ rò a lé̤thè́lè̤ní̤ ǔ a o kuô̌ǔ tôprè̤꤮ to rò athyáná thímí tômṳ dố ǔ prè̤kyě̤ èthǐ oto yětahe akhè̌nuô, a thè́zò̤ ní̤dyé nyacò́ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bínuôakhè̌, a hé a khǒpacè̤̌ tahe, “Lé̤kè́buố akhǎlé̤ oè́lǎ, manárò prè̤kè́buố opatí꤮ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rò kwǐ lahyǎ lyá̤byacè ná a ki nò̌hyǎ prè̤kè́buố tahe dố alyá̤khu yěnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Thyáphú a khǒpacè̤̌ shyéthè́nyě̤yě ki vè̤́htekyǎbè́ kuô̌ khǐné mǔmyá̤ tahe, htuô̌to thyáphú èthǐ ki zasǐmé̤bè́ lò̌ tè̤swítè̤sè̌ pwǒ̤꤮ tôcô agněnuô, Byacè Jesǔ è́hyǎ èthǐ dố a o rò a dyé pé̤ èthǐ taryěshyosò̌. ");
INSERT INTO kyu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Prè̤dônyǎphú shyéthè́nyě̤ amwi̤ ma kryá꤮ ǔpě hérò, aré̤lố tôprè̤ ma amwi̤ ná Simonè má̤torò ǔ è́ lǔ ná Petru ná apuố̤ Andrea, htuô̌rò Zebedeo aphúprè̤khǔ Jakomo ná apuố̤ Giovanni, ");
INSERT INTO kyu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","htuô̌rò Philipu ná Bartholomeo, Thomazo ná prè̤kwǐamo-arǎ Matteo, htuô̌rò Alphaeo aphúkhǔ Jakomo htuô̌rò Thaddeo, ");
INSERT INTO kyu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","htuô̌rò Simonè, è ma ǔ è́ lǔ ná Zeloto aplò́amṳphú aklè̌ tôprè̤, htuô̌rò Juda Iscariot dố a isè̌tǎ̤kyǎ Byacè nuôtôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bí Byacè Jesǔ nò̌cuố a khǒpacè̤̌ shyéthè́nyě̤ yě akhè̌nuô, a mecuốní̤ èthǐ ngó̤, “Cuố tǎ dố Judaphú má̤to tahe aklè̌nuô tǎmé̤ ní, htuô̌rò cuốnuô̌ tǎ dố Samariaphú adò̌asokǔ nuô tǎmé̤mé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cuốtû́prè́ dố pè̤ myěcô Israelphú aklè̌ dố athyáná thímí lamé̤ nuôtahe a o nuôprè́ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bí thǐ cuố akhè̌, hésodônyǎ pé̤ ǔ, ‘Mò́khu ahtyěaké̤ phûhtyahò́,’ phúnuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Zasǐmé̤ kayǎ dố aswíasè̌ tahe, me̤htwǒprè̤ ka̤khyě kayǎ dố a thyě tahe, zasǐmé̤ka̤ kayǎ tè̤sè̌mǔmyá̤ dố phálo̤ tahe, vè̤́htekyǎ lahyǎ khǐnékhǐnò̌, thǐ ní̤bè krǎ lò̌hò́ lò̌꤮ tè̤yě tahe akhu-akhyě kwǐ tǎ ǔ akhwóakè tǎmé̤ ní, me̤krǎ pé̤prè́ ǔ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Htè̌bèbè, rû̌bèbè, talǐbyǎ bèbè sucuố ní̤ tǎ lahyǎ dố thǐ nyá̤htò́kǔ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pyě̤ bèbè, phyécuốlốphyécuốklò̌ ní̤tǎ lahyǎ tǎmé̤ ní, ca̤ bèbè, khuphá bèbè, tomaná ihtyábǒ bèbè phyécuốní̤ lahyǎ tǎmé̤ ní꤮. Me̤těhérò kayǎ dố a me̤ tè̤me̤ tahenuô a tǒkò ní̤bè tè̤ dố a lo tahe. ");
INSERT INTO kyu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Bí thǐ cuốnuô̌hò́ dố dò̌tôdò̌ akǔnuô, myápṳ̌ ní̤ kayǎ dố thǐ lé̤thè́lè̤ní̤ lǔ tôprè̤prè̤ rò cuốokuố dố ahi nuô. Rò otadû kuô̌ná è bínuô tuố̤dố thǐ hteka̤pǎ tôphuố nuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bí thǐ nuô̌ dố hinuô tôměkǔ akhè̌nuô, kwǐ Cò́marya dố a ki sò̌riní̤ hinuô tômě ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hinuô tômě ki a tǒkò ní̤bè tè̤sò̌ri kihérò dya-okyǎ thǐ tè̤pě̤tè̤dwǒ a tè̤sò̌ri dố èthǐ ahikǔ nuô. Ki èthǐ è́mo̤sûryá thǐ to kihérò phyéka̤khyě khyěthyá thǐ tè̤pě̤tè̤dwǒ nuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kayǎ tôprè̤prè̤ ki è́sû thǐ to, a ki ní̤dǎ thǐngó̤ to kihérò, bí thǐ htecuốkyǎ hò́ ná hi nuôtômě akhè̌, kimá̤torò dò̌ nuôtôdò̌ akhè̌nuô, thuô̌tǎ̤kyǎ hemû dố thǐ khǎduôlo̤ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Vǎ hécò́cò́ thǐ, shyé꤮ Cò́marya cirya prè̤lukayǎ pǎ akhè̌nuô, è ki cirya cyě̤lốklò̌ cò́ kayǎ yěnuôtôdò̌ ná vǐ̤ Sodomphú ná vǐ̤ Gomorraphú dố Cò́marya cirya èthǐ mú꤮ nukhè̌ nuôtahe cò́pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Vǎ nò̌cuố thǐ thyáná vǎ plwǒcuố thímí dố htwimi̤ aklè̌ nuô. Me̤phúnuôrò limyǎ kuô̌ lahyǎ phú rṳ́tahenuô, rò thè́plò mwǒ̤plǐ kuô̌ lahyǎ phú htulwí̤ nuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Rò̤ní̤ lahyǎ thǐné̤, me̤těhérò ǔ ki pṳ̂́ thǔcuố thǐ dố tè̤cò́bè̌ khuklò́ tahe lé̤okú myáhtye tǎ̤sû lǔ ahikǔ pǎ rò a kimṳ̂̌kipò̤ thǐ dố tè̤cò́bè̌hǒ tahe akǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dố vǎkhuvǎkhyě rò ǔ ki cwitarṳ́htò́taè̌ hyǎ thǐ dố prè̤pốtè̤ dố a htwǒ khuklò́ tahe ná khwítahe a o pǎ. Thǐ ki hésodônyǎ ní̤pé̤ èthǐ ná vǎrivǎkyǎ pǎ. Thǐ ki khyáluô̌ pé̤ní̤ thǐthè́ ná èthǐ nuôtahe ná Judaphú má̤to tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Manárò bí èthǐ pṳ̂́ thǐ akhè̌nuô, bèkṳ́bèkyǎ̤ one tǎ ná thǐ ki hébè matě pǎ má̤torò thǐ ki hébè phútěnuô tǎmé̤. Shuốkhè̌ hyǎtuố̤ pǎnuô, Cò́marya ki dyé thǐ ngó̤ dố thǐ tǒ hébè nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ngó̤ nuôtahe ma thǐ tè̤hébè ní̤dû má̤to, a má̤dû pè̤ Phè̌ Cò́marya a Thè́ Sǎsè̌ hébè thǐ dố thǐ bèhé prè́. ");
INSERT INTO kyu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Bínuôakhè̌ pǎnuô, puố̤ ki nò̌me̤thyě ní̤dyédû avyá̤ ná ǔruô pǎ, rò vyá̤ ki nò̌me̤thyě ní̤dyédû apuố̤ ná ǔruô pǎ, phè̌ ki nò̌me̤thyě ní̤dû aphú ná ǔruô pǎ, phú tahe ki vû́ ka̤khyěsû ní̤dyédû amuố̤aphè̌ tahe pǎ, rò a ki nò̌me̤thyě ní̤dyédû ǔ ná amuố̤aphè̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dố vǎkhuvǎkhyě rò, ǔ pwǒ̤꤮ tôprè̤ ki thè́hte lò̌ thǐ pǎ. Manárò kayǎ dố a ihtòtanyǎ oklò̤sò́ma dố a tè̤zṳ̂́tè̤nyá̤ akǔ tuố̤dố atadû tahenuô Cò́marya ki me̤lwóhteka̤ èthǐ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ǔ ki me̤cyě̤me̤cṳ̂ thǐ bíyě tôpho kihérò klyacuố dǐtû́ dố aruô tôpho nuô. Vǎ hécò́cò́ thǐ, bí thǐ cuố pwǒ̤lò̌ tyahí lò̌꤮ Israelphú avǐ̤ yětahe hítonuô, prè̤lukayǎ aphúkhǔyě ki hyǎlè́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Khǒpacè̤̌nuô acyá̤adè lốklò̌ ná athárá takhyá꤮ to. Prè̤me̤tè̤phú tôprè̤nuô, aduklò̌ ná abyacè takhyá꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Khǒpacè̤̌ tôprè̤ ki cyá̤ bá athárá nuô, rò prè̤me̤tè̤phú tôprè̤ ki cyá̤ bá abyacè nuô héma pòhò́. Vǎ htwǒ cò́ hikhuklò́ tôprè̤ rò èthǐ ki è́ vǎ ná khǐnékhǐnò̌ a khuklò́du dố amwi̤ ná Beelzebul yě kihérò thǐ dố a htwǒ prè́ hiphúphyǎphú tahenuô a ki è́cyě̤è́cṳ̂ lốklò̌ pǎ cò́ thǐmwi̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Me̤phúnuôrò thè́isě tǎ èthǐlé̤ tǎmé̤. Lò̌꤮ tè̤ dò́uốdò́bí tahenuô, Cò́marya ki bámǒhtya luô̌lò̌ è pǎ, rò lò̌꤮ tè̤me̤huôme̤thwè́ tahenuô, Cò́marya ki me̤hteluô̌lò̌ è pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngó̤ dố vǎ hé pé̤ thǐ dố akhíatapa̤kǔ tahenuô, cuốhébè lahyǎ dố alǐklè̌ nuô ní꤮. Ngó̤ dố thǐ ní̤huô̌huô ní̤huô̌thwè́ tahenuô, htya è́htǒ lahyǎ dố hikhuklwókhu nuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kayǎ dố a me̤thyě cyá̤ thǐ né̤klò̤́ tadû́rò a me̤thyě cyá̤ thǐ thè́htwǒprè̤ to tahenuô, thè́isě tǎ alé̤ tǎmé̤. Thè́isě lahyǎ Cò́marya dố a me̤thyě cyá̤ thǐ né̤klò̤́ ná thǐ thè́htwǒprè̤ nyě̤côlò̌ yěnuô dố ngarakǔ nuôtôprè̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Htupré̤phú nyě̤bènuô ǔ isè̌ prè́ lǔ ná rû̌zye tômyé prè́, vǎhéto? Manárò Phè̌ Cò́marya ki nò̌latǎ̤ thyě èthǐ to hénuô, bí tôbè prè́nuô a latǎ̤thyě dố hekhuto. ");
INSERT INTO kyu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lò̌꤮ thǐ khuluô̤ dố thǐ khuklò́lo̤ nuôtahe cò́rò, Cò́marya dyábè one htuô̌lò̌plǐ cò́hò́. ");
INSERT INTO kyu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Phúnuôrò thè́isě tǎmé̤! Thǐ ngṳdupri̤du klò̌lố cò́ ná htupré̤phú nuô tôplutôphè cò́. ");
INSERT INTO kyu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ǔpěpě꤮ bèbè a ki ò́lya̤ ná a zṳ̂́e vǎ dố kayǎ è́prè̤ a mèthènyě hénuô, vǎ ki ò́lya̤kuô̌ è phúnuô dố Cò́marya a tanémò́khuphú tahe a mèthènyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Manárò ǔpěpě꤮ bèbè a ki htésûbíkyǎ vǎ ná a zṳ̂́e vǎ to dố kayǎ è́prè̤ a mèthènyě pǎ tôprè̤prè̤ hénuô, dố mò́khu vǎphè̌ a mèthènyě pǎnuô, è ma vǎkayǎ má̤to vǎ ki hé kuô̌ke phúnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tane̤ tǎ lahyǎ ná vǎ phyéhyǎ tè̤pě̤tè̤dwǒ dố hekhu yěnuô tǎmé̤. Vǎ phyéhyǎ tè̤pě̤tè̤dwǒ má̤to. Vǎ phyéhyǎ nè́ tôbè. ");
INSERT INTO kyu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Me̤těhérò, vǎ hyǎ dyéohtwǒhtya ‘Phúprè̤khǔ ná phè̌, phúprè̤mò ná muố̤, dya ná prè̤́prè̤mò kiklyékingǎ lǔ pǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kayǎ tôprè̤prè̤ dố ǔ ki thè́htethè́hǎ ní̤ lǔ pǎ nuôma a ki má̤dûprè́ a hiphúphyǎphú ní̤dû pǎ prè́.’ ");
INSERT INTO kyu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kayǎ tôprè̤prè̤ dố a mo̤ní̤ lốklò̌ amuố̤aphè̌ ná vǎ hénuô, a kò ná vǎ to. Kayǎ tôprè̤prè̤ dố a mo̤ní̤ lốklò̌ a phúmòphúkhǔ ná vǎ hénuô, a kò ná vǎ to. ");
INSERT INTO kyu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kayǎ tôprè̤prè̤ dố a krusu rò a zá ní̤dyédû toto, vǎkhyě rò a krwǒ toto tahenuô, a kò ná vǎ to. ");
INSERT INTO kyu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kayǎ tôprè̤prè̤ dố a thè́lǒ ní̤dyé athè́plò htwǒprè̤ nuô, a thè́htwǒprè̤ ki lacṳ́kyǎ pǎ. Kayǎ dố a dyélya̤kyǎ athè́plò htwǒprè̤ dố vǎgněnuô, a ki myáhtye thè́htwǒprè̤ tacṳ́prè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kayǎ dố a è́sû thǐ nuôma a è́sûhò́ vǎ hò́. Rò kayǎ dố a è́sû vǎ nuôma, a è́sûhò́ Phè̌ Cò́marya dố a nò̌hyǎ vǎ yěnuô tôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kayǎ tôprè̤prè̤ yǒ htwǒ Cò́marya aprè̤pro̤ rò kayǎ tôprè̤prè̤ ki è́mo̤sû prè̤pro̤ yětôprè̤nuô, Cò́marya ki dyé è tè̤me̤ní̤khwókè phú a dyé prè̤pro̤ tahenuô pǎ. Kayǎ tôprè̤prè̤ yǒ htwǒ kayǎcò́kayǎte̤ rò kayǎ tôprè̤prè̤ ki è́mo̤sû kayǎcò́kayǎte̤ yětôprè̤nuô, Cò́marya ki dyé è tè̤me̤ní̤khwókè phú a dyé kayǎcò́kayǎte̤ tahenuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Vǎ hécò́cò́ thǐ, kayǎ tôprè̤prè̤ yǒ htwǒ vǎ khǒpacè̤̌ dố a patílố tôprè̤ akhu-akhyě, ǔpěpě꤮ bèbè dố a dyéǒ kayǎ yětôprè̤ ná htyěkacṳ́ tôbě prè́ nuô, Cò́marya ki dyé má̤lakǒ cò́ lǔ tè̤me̤ní̤khwókè pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bí Byacè Jesǔ ithyó zṳ̌klyázṳ̌klǒ htuô̌hò́ a khǒpacè̤̌ shyéthè́nyě̤yě akhè̌nuô, a htecuốkyǎ bínuô rò a htecuố dố vǐ̤ dố a o dố Galilea ké̤ tahe thyáphú a ki cuố ithyóithya dônyǎhéso pé̤ ǔ obínuô tahe. ");
INSERT INTO kyu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bí Giovanni o dố ǔ lé̤dò́tǎ̤ lǔ htò̌kǔ akhè̌nuô, a ní̤huô̌ ná Byacè me̤ tè̤pro̤tè̤prya̤ tahe rò a nò̌cuốsudyǎ a khǒpacè̤̌ tahe ná Byacè Jesǔ rò èthǐ sudyǎ lǔ, ");
INSERT INTO kyu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Nè̤ ma Messia dố prè̤pro̤ tahe héone ná a ki hyǎ pǎ nuôtôprè̤ hò́ è̌? Má̤torò pè̤ tǒbè opò̤́myásû̌pǎ dố aruôtôprè̤ ki hyǎ pǎ agně nuô è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Byacè Jesǔ hésû, “Ka̤khyě dyásokhyě pé̤ Giovanni ná lò̌꤮ thǐ ní̤huô̌ myáhtye yětahenuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kayǎ mèthèkhí tahe myáhtye cyá̤hò́, kayǎ khǎduôdá tahe cuốcyá̤hò́, kayǎ tè̤sè̌mǔmyá̤ dố phálo̤ tahe sǐmé̤ ka̤khyě lò̌hò́, kayǎ khǎlèkaò̌ tahe khǎlèlǐ lò̌hò́, kayǎthyě tahe ihtòhtwǒprè̤ ka̤khyě khyěthyáhò́, kayǎ sǒrya̤sǒpháphú tahe ní̤huô̌bè kuô̌hò́ tè̤thè́krṳ̂̌mila hò́. ");
INSERT INTO kyu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dố vǎkhuvǎkhyě rò kayǎ dố a thè́plòpyé pé̤to, a zṳ̂́e tadû plehyǎlǎ tahenuô a ki ní̤bè má̤lakǒ cò́ tè̤sò̌ri hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bí Giovanni a khǒpacè̤̌ tahe hteka̤ htuô̌nuô, Byacè Jesǔ cáhtya hébè pé̤ kayǎ bè́mṳ nuôtahe ná Giovanni ari-akyǎ. Rò a hé pé̤ èthǐ, “Thǐ htecuố lahyǎ dố ké̤sè̌htyěkya̤ lò̤́tamákhu nuôma, thǐ cuốmyá kryá꤮ ǔpě? Ma thǐ cuốmyá lahyǎ ké̤lathè́ kazuô̤̌ pǒ̤mò̤́ nuôtahe è̌? ");
INSERT INTO kyu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Phúnuô má̤to kihérò, ma thǐ htecuốmyá kryá꤮ ǐtě? Ma thǐ htecuốmyá prè́ lahyǎ kayǎ dố a kû̌thyá pé̤ thǐ hyeca̤ takhè̌plyarashyǐ tôprè̤prè̤ nuôprè́ è̌? Kayǎ dố a kû̌thyá phúnuô tahe ma a oprè́ dố khwíhǒ tahe akǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hépé̤myá vǎ, thǐ htecuốmyá kryá꤮ ǐtětě? Thǐ htecuốmyá prè̤pro̤ tôprè̤prè̤ è̌? Thǐ ki cuốmyá prè̤pro̤ tôprè̤prè̤ hénuôma a má̤hò́. Vǎ hé thǐ, kayǎ dố aduklò̌lố cò́ ná prè̤pro̤nuô, thǐ myáhtye hò́ lǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Giovanni ma kayǎ tôprè̤ dố Cò́marya héone lǔrilǔkyǎ, ‘Myámò̌ è ma prè̤thǔ pé̤ vǎ tè̤ritè̤kyǎ tôprè̤hò́, thyáphú a ki me̤lá̤ one ré̤ pé̤ nè̤klyá lé̤hyǎ agněnuôrò, vǎ nò̌hyǎ ré̤hò́ è dố nè̤nyěhyǎ hò́.’” ");
INSERT INTO kyu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jesǔ hé pó̤, “Vǎ hécò́cò́ thǐ, lò̌꤮ kayǎ dố a opacè̤̌lya̤ tahe aklè̌nuô, adulốklò̌ cò́ ná Giovanni Baptista nuô a o tôprè̤꤮ to. Manárò kayǎ dố a patílốǔ dố mò́khu htyělé̤ké̤kǔ tôprè̤nuô, adulốklò̌ pǎ cò́ ná Giovanni cò́. ");
INSERT INTO kyu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Cáhtya bí Giovanni Baptista ahtû̌khè̌ tuố̤khǒnyá̤nuô, kayǎ tahe nuô̌ sácyě̤sácṳ̂ mò́khu htyělé̤ké̤kǔ. Kayǎhǎkayǎkǎkè tahe yácû́ nuô̌pṳ̂́phe tadû mò́khu htyělé̤ké̤kǔ. ");
INSERT INTO kyu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tuố̤dố Giovanni htû̌khè̌ nuô, lò̌꤮ prè̤pro̤ ali tahe ná lò̌꤮ Mosè a tè̤ithyóithya tahenuô a héone lò̌hò́ Cò́marya ahtyěké̤ ari-akyǎyě dố a ki htwǒhtya pǎ nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Elia ki hyǎ khyěthyá pǎ, prè̤pro̤ tahe hé phúnuô. A thè́zṳ̂́ hé ǔpě nuô vǎ ki hésoluô̌ pé̤ thǐ. Thǐ ki zṳ̂́e vǎngó̤ hénuô thǐ thè́gněplǒ prè́. Prè̤pro̤ hé ná Elia ki hyǎ khyěthyá pǎ, a hé nuôma, a hé hò́ Giovanni yěnuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kayǎ dố a o ná akhǎlè tahenuô, nò̌ ní̤dǎ lahyǎ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Vǎ ki talô těradû̌myá pé̤ thǐ kayǎ yětôhtû̌ ná maǐtě? Èthǐ ma athyáná pacè̤̌phú dố a cuố onyǎo lahyǎ dố klè́kǔ nuôtahe rò a è́htǒè́mo̤ cuố ní̤dyé lǔ tôprè̤ ná tôprè̤ rò a hé lahyǎ, ");
INSERT INTO kyu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Pè̤ uố pé̤ thǐ těló rò thǐ ilě toto, pè̤ ihè pé̤ thǐ luô̤̌ rò, thǐ nguố̤ toto,’ a è́htǒ ní̤dyé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Me̤těhérò Giovanni hyǎ duôesè, hyǎ duôǒhtyězǎ̤ tahe rò ‘Khǐnékhǐnò̌ me̤bè lǔ hò́,’ ǔ hé lò̌plǐ lǔrilǔkyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě hyǎehyǎǒ kuô̌ke rò ‘Myámò̌ kayǎ yětôprè̤lé, a eshyoǒpryá, a bò́thyókhè́khǒ dûgně ná prè̤kwǐamo-arǎ ná prè̤oraphú nuôtahelé꤮,’ èthǐ hé lahyǎ phúnuô. Manárò bí ǔ me̤ryá tè̤ phú Cò́marya a tè̤thíphè́ yěrò aphǒathè hteluô̌hò́ akhè̌pǎnuô, kayǎ dố aruô tahe ki myáhtye thè́gněhyǎ ná Cò́marya a tè̤thíphè́ yěnuôma a tǒprè́, phúnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Byacè Jesǔ dyéluô̌ è́klò̌lố ǔ tè̤pro̤tè̤prya̤ dố vǐ̤nuô tahe akǔ tadû́rò èthǐ za̤ ní̤dû kuô̌ǔ ané̤ to akhu-akhyě athè́plò mo̤to rò a hélǐhélá̤kyǎ èthǐ, ");
INSERT INTO kyu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kố꤮ vǐ̤ Chorazin ná vǐ̤ Bethsaida, Cò́marya ki plí thǐ pǎ. Vǎ ki dyéluô̌ bye tè̤pro̤tè̤prya̤ yěnuô dố vǐ̤ Tyre ná vǐ̤ Sido nuô héma, èthǐ ki za̤ ní̤dû lahyǎ ané̤ nyě̤꤮ lǎhò́ rò èthǐ ki kû̌thyáhtya hyeca̤ taprú rò a ki onyǎ tarò̤̌ lahyǎ dố kò́phèkhu hò́. ");
INSERT INTO kyu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Manárò vǎ hé thǐ, shyé꤮ mò̤́nyěcirya pǎ tônyěnuô, vǐ̤ Tyrephú tahe ná vǐ̤ Sidophú taheyě, Cò́marya ki thè́zò̤ní̤ è́klò̌ ná thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kố꤮ vǐ̤ Capernaumphú thǐ꤮, thǐ tane̤ lahyǎ ná Cò́marya ki dyahtyalô̌ tuố̤ cò́ nè̤ dố mò́khu pǎ nè̤ tane̤ phúnuô è̌? A ki vǐtǎ̤kyǎ nè̤ dố ngarakǔ pǎ. Tè̤pro̤tè̤prya̤ dố vǎ dyéluô̌ dố nè̤kǔ yětahenuô, vǎ ki dyéluô̌ bye dố vǐ̤ Sodom vǐ̤kǔ hénuôma vǐ̤nuô tôvǐ̤ ki o tuố̤pǎ tuố̤khǒnyá̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Manárò vǎ hé thǐ, mò̤́nyěcirya pǎ tônyěnuô, vǐ̤ Sodomyě, Cò́marya ki thè́zò̤ duní̤klò̌ ná thǐ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bínuôakhè̌ Byacè Jesǔ hé Cò́marya, “Kố꤮ mò́khu Byacè, hekhu Byacè, vǎ Phè̌ Cò́marya꤮ vǎ hébwíhétaryě nè̤, tè̤ dố nè̤ dya dò́uốdò́bí pé̤ prè̤thíphè́phú tahe ná prè̤pṳ̌thè́gnětè̤phú tahenuô, nè̤ dyéluô̌htya pé̤hò́ ná kayǎ dố a tane̤patí ní̤dyé ané̤ thyáná pacè̤̌phú nuôtahehò́ akhu-akhyě, vǎ hébwíhétaryěhtya nè̤. ");
INSERT INTO kyu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kố꤮ phè̌꤮, nè̤ thè́plòo thè́plòtǒ má̤nyǎhò́ ná a kibè htwǒhtyanyǎ phúyěhò́ akhu-akhyě, vǎ hébwíhétaryě nyacò́ nè̤. ");
INSERT INTO kyu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Vǎphè̌ dyétǎ̤lò̌ hò́ vǎ tè̤pwǒ̤꤮ tôcô hò́. Kayǎ dố a thè́gně phúkhǔ matû́ a Phè̌ Cò́marya tôprè̤prè̤꤮ tuô̌ prè́. Kayǎ dố a thè́gně Phè̌ Cò́marya nuôma tû́prè́ aphúkhǔ tôprè̤ ná kayǎ dố phúkhǔ nwóhtya lǔ dố a ki dyéluô̌ pé̤ lǔ pǎ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Lò̌꤮ kayǎ dố a víhtuôzáhtuô rò a thè́prá ladyá thǐ tahenuô, hyǎ dố vǎoyě, rò vǎ ki dyéokuố tabè́thè́prá thǐ. ");
INSERT INTO kyu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Zá lahyǎ vǎ izáyě rò ithyóthè́gně kuô̌ tè̤ dố vǎoyě, me̤těhérò vǎ thè́dǒthè́nga̤ rò vǎ shyalya̤ vǎthè́ akhu-akhyě, nè̤ ki myáhtye nè̤ thè́plò a lé̤okuố tabè́thè́prá pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Me̤těhérò vǎ nò̌zá thǐ vǎizá yěnuô, azǔnyé꤮ hu prè́. Vǎ tǎ̤muô̌tǎ̤tè̤ ma ahtuô to.” ");
INSERT INTO kyu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dốkhyě nyě̤tyatonuô, Byacè Jesǔ cuốnuô̌cuốbè́ ǔ buốkǔlǎ prè́lé̤khu tahe, rò atǒ ná Judaphú a Mò̤́nyěduô. A khǒpacè̤̌ tahe thè́ethè́ǒ rò a práe ǔ buốkǔlǎthè. ");
INSERT INTO kyu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bí Pharisěophú tahe myáhtye èthǐ akhè̌nuô, a hé Byacè Jesǔ, “Myámò̌, nè̤ khǒpacè̤̌ nuôtahe, tè̤ dố ǔ tǒ me̤ní̤ Mò̤́nyěduô to nuôtahe rò a cuốme̤ dûgně lé꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Byacè Jesǔ hésû èthǐ, “Bí Davi ná a khǒbò́thyó tahe ladyáeladyáǒ akhè̌nuô, a me̤kryá꤮ ǐtětě nuôma thǐ hốnò́ kuô̌nyǎ ǔ to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Khò́mǔ dố ǔ lǔhtya dố Cò́marya a o tahenuô, ení̤ prè́tû́ bwídu tahe prè́ tadû́rò Davi ná a khǒpacè̤̌ tahe cuốnuô̌phyée vǎhéto? ");
INSERT INTO kyu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Htuô̌to bwídu dố Cò́marya ahikǔ tahenuô, bí Mò̤́nyěduô akhè̌ ki èthǐ cuốtalwókhè̌talye̤ Mò̤́nyěduô a tè̤thyótè̤thya tadû́rò atè̤thû́ oto hénuôma thǐ hốnò́ takhyá꤮ to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Vǎ hé thǐ, kayǎ dố aduklò̌ pǎ cò́ ná tè̤lǔhǒdu nuô a o bíyě tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Vǎ thè́zṳ̂́ tè̤lǔtè̤tyǎ to, vǎ thè́zṳ̂́ prè́ tè̤thè́zò̤klabè ní̤ lǔ tôprè̤ ná tôprè̤ prè́,’ Cò́marya hé ngó̤ yětômû̌nuô, thǐ ki thè́gněbye angó̤lasá hénuôma, kayǎ dố atè̤thû́ oto tahenuô, thǐ dya ná èthǐ tè̤thû́ takhyá꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Vǎ hé phúyě me̤těhérò, prè̤lukayǎ aphúkhǔ má̤dû vǎ yěnuôma Mò̤́nyěduô a Byacè tôprè̤hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Byacè Jesǔ htecuốkyǎ bí lyá̤khu nuôrò a cuốnuô̌ dố Judaphú tè̤cò́bè̌hǒkǔ. ");
INSERT INTO kyu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Rò bí tè̤cò́bè̌ hǒkǔ nuô, kayǎ takhuthyě tôkhó o tôprè̤. Pharisěophú dố a thè́zṳ̂́ myápṳ̌ Jesǔ tè̤thû́ tahenuô a o tahe rò a sudyǎ lǔ, “Bí Mò̤́nyěduô akhè̌, ki zasǐmé̤ kayǎ tôprè̤prè̤ hénuôma, aní̤ prè́ Judaphú a tè̤thyótè̤thya hé phúnuô è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A hé èthǐ, “Kayǎ tôprè̤prè̤ athímí ki latǎ̤ otyá̤ dố hekǔ bí Mò̤́nyěduô akhè̌nuô hérò, thǐ cuố cwihtya è pǎ è̌? Ma to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kayǎ tôprè̤nuô a ngṳdupri̤du klò̌pǎ cò́ ná thímí tôduô̌ bá꤮ tě. Phúnuôrò, bí Judaphú a Mò̤́nyěduô akhè̌nuô, me̤tè̤ryá ma aní̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Rò a hé kayǎ takhuthyě tôkhó yětôprè̤, “Zó̤hte nè̤ takhuthyě nuôtôkhó nuô,” a zó̤hte rò atè̤ ryáka̤khyě thyákhyě ná a takhuryá nuôtôkhó. ");
INSERT INTO kyu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Manárò Pharisěophú tahe htecuố taphǎkyǎ rò èthǐ cuốokú hébè ní̤dyélǔ ná tǒbè me̤thyě Jesǔ phútěnuô ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Byacè Jesǔ thè́gně èthǐ atè̤tane̤ mǔmyá̤ rò a htecuốkyǎ ná khǎlé̤ bínuô. Kayǎ krwǒplukrwǒphè kuô̌lò̌ lǔkhyě rò a zasǐmé̤ pé̤ lò̌plǐ cò́ ǔ tè̤swítè̤sè̌ pwǒ̤꤮ tôprè̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A hé èthǐ ná vǎ ma ǔpěnuô hésoluô̌ pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yěma a me̤ lốbǎhtya phú Prè̤pro̤ Isaiah héone, ");
INSERT INTO kyu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Èyě ma vǎ prè̤me̤tè̤phú dố vǎ nwóhtya lǔ, è ma kayǎ tôprè̤ dố vǎ mo̤ní̤ lǔ rò vǎ thè́plò oní̤ lǔ. Vǎ ki nò̌hyǎo vǎ Thè́ Sǎsè̌ Byacè dố èlo̤ pǎ rò a ki hésoluô̌ pé̤ Judaphú má̤to tahe ná a ki bè phyésû tè̤cò́tè̤te̤ dố vǎ o phútě nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Manárò ènuô aklyéangǎ kuô̌ǔ to. A è́htǒè́mo̤ kuô̌ǔ to. A cuốè́htǒè́mo̤ dố klyádu nuôtahe akǔnuô, ǔ ní̤huô̌nò́ to. ");
INSERT INTO kyu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kayǎ dố a hè̌cè̤́recè̤́ thyáná pǒ̤mò̤́ langò̤ tôprè̤nuô, è pǎ̤tṳ̂̌kyǎ lǔ to. Kayǎ dố a tè̤zṳ̂́patí thyáná mikò̌ dố a kíré̤ pǐ̤hò́ tôprè̤nuô è uốpǐ̤ lǎ lǔtè̤ to. A ki me̤ryá plehyǎ rò a ki thè́zò̤ plehyǎ lǎpó̤ tè̤ tuố̤dố a ki dyéohtwǒhtya tè̤cò́tè̤te̤ ki me̤pé̤kyǎ tè̤mǔmyá̤ yěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ké̤pwǒ̤tôké̤ myěcô pwǒ̤tôcô ki thè́lè̤htyaní̤ è pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Htuô̌rò èthǐ è́hyǎní̤ kayǎphè̌ dố khǐné me̤bè lǔ rò a mèthèkhí rò a pè́ ní̤dyé yětôprè̤ dố Byacè Jesǔ a o. Thyáphú a ki hébècyá̤, myáhtye cyá̤ ka̤khyě khyěthyá nuô, a zasǐmé̤ pé̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kayǎ bè́mṳ tahe khyéthukhyéthè́ nyacò́, rò a hé lahyǎ, “Kayǎ yětôprè̤ ma Khwí Davi aphúkhǔ cò́kǒ?” ");
INSERT INTO kyu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Manárò bí Pharisěophú tahe ní̤huô̌ ǔ hé phúnuô akhè̌, èthǐ hé, “A vè̤́htebè́ khǐnékhǐnò̌ nuôtahe mamá̤ prè́ khǐnékhǐnò̌ a khuklò́du Beelzebul me̤cwó̤ lǔ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Byacè Jesǔ thè́gně èthǐ tè̤tane̤ tahe rò a hé èthǐ, “Ké̤tôké̤ akǔnuô akayǎ tahe kisákipǎ̤ ní̤dyédû lǔ tôprè̤ ná tôprè̤ kihérò a lṳpruốlṳpryǎkyǎ pǎ. Vǐ̤tôvǐ̤ bèbè, kayǎ tômuố̤tôcô bèbè ki aklyéangǎ lǔ hénuô, a ki lṳpruốlṳpryǎ lò̌ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Khǐnékhǐnò̌ ki vè̤́htekyǎ ní̤dyé khyěthyádû akayǎ tahe kihérò athyáná a sá ka̤khyě ní̤dyé khyěthyá dû ané̤ prè́. Phúnuôrò ahtyěaké̤ cuốo khyǎ cyá̤ phútě? ");
INSERT INTO kyu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ki vǎ vè̤́hte khǐnékhǐnò̌ ná Beelzebul a taryěshyosò̌ kihérò thǐ khǒpacè̤̌ tahe kuô̌ke rò a nò̌e maǔpě a taryěshyosò̌ rò a vè̤́hte pě? Ma a nò̌e khǐnéricyá̤ khuklò́ a taryěshyosò̌ è̌? A nò̌e má̤ náto. Phúnuô akhu-akhyě, thǐ khǒpacè̤̌ ki dyéluô̌ ní̤dyédû thǐ tè̤thû́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Manárò vǎ ki vè̤́htekyǎ khǐnékhǐnò̌ yětahe ná Cò́marya a Thè́ Sǎsè̌ kihérò yěnuôma a zṳ̌luô̌hò́ ná Cò́marya ki hyǎ pốhtyěpốké̤ yěnuô a hyǎtuố̤hò́ dố thǐ ohò́. ");
INSERT INTO kyu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Má̤torò, bí kayǎ tôprè̤ cuốnuô̌ dố khǐnéricyá̤ khuklò́ dố athyáná kayǎshyokayǎsò̌ tôprè̤ ahikǔ akhè̌nuô, a ki nuô̌ cò̌klò̤ma ré̤ lǔ to kihérò a cuố phyéphe cyá̤ lǔtǎ̤tè̤ phútě? A cò̌klò̤ma htuô̌ lǔ tû́ma a phyéphe ní̤ cyá̤ lǔ tǎ̤tè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kayǎ dố a okuô̌ dố vǎ tôkyě to nuôma kayǎ dố a thè́hte vǎ hò́, kayǎ dố a me̤tố̤kuô̌ tè̤ ná vǎ to nuôma kayǎ dố a me̤pruốme̤pryǎ tè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Me̤phúnuôrò vǎ hé thǐ, Cò́marya ki plwǒkyǎ kayǎ dố a me̤thû́ lǔ, a héthû́ lǔ nuôtahe a tè̤thû́. Manárò kayǎ dố a héthû́me̤thû́ Thè́ Sǎsè̌ Byacè nuô Cò́marya plwǒkyǎ cyá̤ pǎ èthǐ tè̤thû́ to. ");
INSERT INTO kyu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kayǎ tôprè̤prè̤ ki héthû́ prè̤lukayǎ aphúkhǔ má̤hò́ vǎ yěnuô Cò́marya ki plwǒkyǎ lǔtè̤thû́ prè́. Manárò kayǎ dố a héthû́ Thè́ Sǎsè̌ Byacè nuô, yětôhtû̌ bèbè, nopǎ tôhtû̌ bèbè, Cò́marya plwǒkyǎ cyá̤ pǎ lǔtè̤thû́ to. ");
INSERT INTO kyu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Thòmò̤́ dố ari̤-aruô̤̌ atwó̤aryá nuô, a ki thèhte thòthè dố aryá pǎ. Manárò thòmò̤́ dố a tazwítaphuô̌ nuô, athèhte ryá to. Me̤těhérò nè̤ myá athè nuô, nè̤ thè́gně cyá̤ dû hò́ amò̤́ ari-akyǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Rṳ́thí aklwǐalyǎ thǐ꤮, thǐ ma kayǎ klwǐlyǎ cyě̤ rò thǐ cuố hébè ryá bè́cyá̤ phútě? Kayǎ nuô a thè́plòkǔ obǎ tǎ̤pòtǎ̤pè̤̌ phútěrò akhǎu krwǒ hébèhte kuô̌ phúnuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kayǎ ryá tôprè̤nuô, a yǒ sunuô̌ oplò́ tè̤ryá tahe dố a thè́plòkǔ akhu-akhyě, a ki hébèhte ngó̤ dố aryá tahe prè́. Manárò kayǎcyě̤ricyá̤ tôprè̤nuô, a yǒ sunuô̌ oplò́ tè̤mǔmyá̤ tahe dố a thè́plòkǔ akhu-akhyě, a ki hébèhte ngó̤ dố a mǔmyá̤ricyá̤ tahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Manárò vǎ hé thǐ, shyé꤮ Cò́marya cirya kayǎ akhè̌pǎnuô, a ki cirya lò̌lò̌꤮ kayǎ dố a hébè tane̤ kuô̌ǔ to rò a hébè ngó̤ dố abwíataryě oto nuôtahe pwǒ̤꤮ tômû̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Me̤těhérò, nè̤ ki hébè ngó̤ dố aryá tahe hénuôma, Cò́marya ki hé nè̤ ná nè̤ tè̤thû́ oto pǎ. Nè̤ ki hébè ngó̤ dố a mǔmyá̤ tahe kihérò, a ki hé nè̤ ná nè̤ tè̤thû́ o pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Htuô̌rò Pharisěophú tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe hé Jesǔ, “Thárá, nè̤ dyéluô̌ pé̤ myá pè̤ tè̤pro̤tè̤prya̤ tôcô to, pè̤ thè́zṳ̂́ myáhtye lǎ vǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Rò a hésû èthǐ, “Kayǎcyě̤ kayǎricyá̤, kayǎ dố acò́ kuô̌ǔ ná Cò́marya to yětôhtû̌ tahe cuốkwǐmyá tuố̤ vǎ tè̤me̤ tè̤pro̤tè̤prya̤ tôcô, manárò vǎ ki dyéluô̌ pé̤tû́prè́ èthǐ tè̤pro̤tè̤prya̤ tôcô dố athyáná Prè̤pro̤ Jona nuô pǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Me̤těhérò, phú Jona o dố tè̤̌du hò́kǔ thuô̌nyěthuô̌thè̌ nuô, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě a ki okuô̌dû dố helè̤̌ thuô̌nyěthuô̌thè̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dố Jona a tè̤hésodônyǎ luô̌ pé̤ vǐ̤ Ninevephú tahe rò a za̤ ní̤dû lò̌plǐ hò́ ané̤ akhu-akhyě, shyé꤮ Cò́marya cirya ǔ pǎ tônyěnuô, vǐ̤ Ninevephú tahe ki ihtò tố̤kuô̌ ná kayǎ dố a htwǒprè̤ khǒnyá̤ yětôhtû̌ tahe pǎ rò a ki dya èthǐ tè̤thû́ pǎ. Khǒnyá̤yě kayǎ dố adulố ná Jona nuô a o bíyě tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tè̤cirya amò̤́nyě pǎ tônyěnuô, ké̤ dố cílya̤ tôkyě akhwímuố̤ Sheba ki ihtò tố̤kuô̌ ná kayǎ dố a htwǒprè̤ khǒnyá̤yě tôhtû̌ tahe pǎ rò a ki betè̤thû́ dố èthǐ yětahe alo̤ pǎ, me̤těhérò thyáphú a ní̤huô̌nò́ kuô̌ Khwí Solomo a tè̤ithyóithya dố a lốbǎ ná tè̤thíphè́ yětahe agněnuôrò, a o cò́ dố ké̤ye̤ dố aruô tôké̤ tadû́rò a hyǎ cò́. Rò vǎ hé thǐ, kayǎ dố aduklò̌lố cò́ ná Khwí Solomo nuô a o bíyě tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Bí khǐnékhǐnò̌ tôduô̌ htecuốkyǎ htuô̌hò́ dố kayǎ tôprè̤ akǔ akhè̌nuô, a htecuố dố khǎlé̤krǎkrè tôpho rò a cuố myápṳ̌ akhǎlé̤ lé̤okuố tabè́thè́prá tadû́rò a myáhtye to. ");
INSERT INTO kyu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Rò a hé, ‘Vǎ ki ka̤khyě khyěthyá dố vǎ khǎlé̤ lye̤nuô héni,’ a hé rò bí a ka̤tuố̤ akhè̌nuô, a ka̤myáhtye ná akhǎlé̤ lye̤ yěnuô a o kò̌khǔ, aplǐaphuốryá, a o taná̤tashuô̌ twó̤ryá lò̌plǐ cò́ pwǒ̤꤮ tôcô. ");
INSERT INTO kyu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Rò a htecuố è́krwǒka̤ní̤ pó̤ akhǒ dố a cyě̤ricyá̤ lốklò̌ cò́ ná lǔnuô thuô̌thyótôduô̌ cò́ rò èthǐ ka̤kanuô̌ o lahyǎ bínuô. Rò kayǎ nuôtôprè̤ ki cyě̤ lốklò̌ cò́ ná a khǎlé̤lye̤ nuô cò́ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bí Byacè Jesǔ hébèhésû̌ ná kayǎ bè́mṳ akhè̌nuô, amuố̤ ná a puố̤prè̤khǔ tahe hyǎ ihtò opò̤́ o lǔ dố aklò̌ rò a thè́zṳ̂́ myáhtye hébè lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kayǎ tôprè̤ hé lǔ, “Nè̤muố̤ ná nè̤ puố̤prè̤khǔ tahe hyǎihtò opò̤́ nè̤ dố aklò̌nuô. Èthǐ thè́zṳ̂́ myáhtye hébè ná nè̤ hénuô.” ");
INSERT INTO kyu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Rò Byacè Jesǔ hésû lǔ, “Vǎmuố̤ ma maǔpě? Vǎ puố̤ ma maǔpě?” ");
INSERT INTO kyu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Rò a zṳ̌cuố ná a khǒpacè̤̌ tahe rò a hé, “Dốnuôlé, èthǐ ma vǎmuố̤ ná vǎpuố̤vǎvyá̤ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Me̤těhérò kayǎ dố a me̤tǒ phú vǎphè̌ dố mò́khu tôprè̤ a tè̤thè́zṳ̂́ nuôtahe ma má̤hò́ vǎpuố̤vǎvyá̤ tahe ná vǎmuố̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bínuô tônyěhò́, Byacè Jesǔ htecuốkyǎ bí hinuô tômě akǔ rò a cuố onyǎo dố htyěòduhtû̌. ");
INSERT INTO kyu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kayǎ hyǎo tava̤plutava̤phè lò̌ lǔ rò a cuốnuô̌ onyǎo dố thòklyěkǔ. Kayǎ bè́mṳ tahe ke rò a ihtòo lò̌plǐ dố khǒlǒkhu. ");
INSERT INTO kyu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Rò a dyá è́ pé̤ lǎ èthǐ tè̤dyá khákho tahe, rò a hé èthǐ, “Ní̤dǎ tǎ̤te̤ lahyǎ! Bètôphuố, prè̤me̤prè́phú o tôprè̤. Rò tônyěkhè̌ a hyǎ pruốtǎ̤ tè̤klwǐ. ");
INSERT INTO kyu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Rò bí a hyǎpruốtǎ̤ tè̤klwǐ akhè̌, tahehenuô a latǎ̤tǒ dố klyádè̌kǔ, rò htuphúzuố̤phú tahe hyǎihtuôekyǎ lò̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tahehenuô a latǎ̤tǒ dố lò̤́klè̌ hekhuphábû̌ akhǎlé̤ nuô. Rò hekhu yǒ phábû̌ akhu-akhyě a dyáhtya pryǎ lè́. ");
INSERT INTO kyu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Manárò arwí̤ yǒ sátǎ̤zǎ̤ to akhu-akhyě, bí tamò̤́ sábè lǔ akhè̌nuô, akṳ́lwó lò̌ amò̤́ tahe rò anó hyǎlò̌plǐ. ");
INSERT INTO kyu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tè̤klwǐ tahehenuô a latǎ̤tǒ dố thòshyáthòprǔklè̌ rò thòshyámò̤́ yětahe duhtya khyábí lò̌ amò̤́ patí yětahe. ");
INSERT INTO kyu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Manárò tahehenuô a latǎ̤tǒ dố hezyeri̤zyeryákhu rò a phè́htya rò athèaphǒhte è́htya aphuố tôzè̤, aphuố shyěthuô̌thyó, aphuố thuô̌shyě. ");
INSERT INTO kyu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kayǎ dố akhǎlè ki o rò ní̤dǎdû ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","A khǒpacè̤̌ tahe hyǎ dố lǔo rò hyǎsudyǎ lǔ, “Bí nè̤ hébè ná kayǎ nuôtahe akhè̌ nè̤ cuố dyápé̤ tuố̤ èthǐ ná tè̤dyá khákho tahe me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Byacè Jesǔ hésû èthǐ, “Cò́marya dyéthè́gněplǒ pé̤hò́ thǐ ná mò́khu htyělé̤ké̤kǔ a tè̤thè́khuthè́gně dố a dò́uốdò́bí tahe tadû́rò a dyéthè́gně tuố̤ pé̤kuô̌ èthǐ to. ");
INSERT INTO kyu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Me̤těhérò kayǎ dố a o ná tè̤thè́khuthè́gně má̤dû mò́khu htyělé̤ké̤kǔ ari-akyǎ tahenuô Cò́marya ki dyé è́htya pó̤ lǔ pǎ. Kayǎ dố a o kuô̌ ná tè̤thè́khuthè́gně má̤dû mò́khu a htyělé̤ké̤kǔ ari-akyǎ to tahenuô, a ki o prè́ takiphú bèbè, Cò́marya ki phyékyǎlò̌phe lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bí vǎ hébè èthǐ akhè̌nuô, vǎ dyání̤ pé̤ èthǐ ná ngó̤khákho tahe, me̤těhérò Èthǐ myá tadû́rò a myáhtye to. Èthǐ ní̤huô̌ tadû́rò a thè́gně to. ");
INSERT INTO kyu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Prè̤pro̤ Isaiah héone ngó̤nuô a lốhtyabǎhtya ná èthǐ yěnuô hò́. Rò a héone, ‘Thǐ ní̤huô̌htuô̌ ní̤huô̌ thyáthyá cò́ pǎ tadû́rò thǐ thè́gněplǒ pé̤ angó̤lasá tômû̌꤮ to, thǐ myáhtyehtuô̌ myáhtye thyáthyá cò́ pǎ tadû́rò thǐ myáhtyeplǒ angó̤lasá tômû̌꤮ to pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Me̤těhérò kayǎ yětahe ma a khuklò́pryě̤, èthǐ khǎlè o tadû́rò a ní̤huô̌plǒ to, èthǐ bòkri̤bí amèthè me̤těhérò èthǐ thè́zṳ̂́ myáhtye tè̤má̤tè̤cò́ to. Èthǐ ki me̤ lahyǎ phúnuôto hérò èthǐ ki myáhtye ná amèthè pǎ, a ki ní̤huô̌plǒ vǎ hé yětahe pǎ, a ki tane̤plǒ thè́gněryá lahyǎ pǎ, a ki za̤ ní̤dû lahyǎ ané̤ pǎ, rò vǎ ki zasǐmé̤ èthǐ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Manárò thǐ yětahenuô, thǐmèthè myáhtye tè̤, thǐkhǎlè ní̤huô̌ tè̤ akhu-akhyě thǐ ki ní̤bè tè̤sò̌ri. ");
INSERT INTO kyu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Me̤těhérò, vǎ hécò́cò́ thǐ, prè̤pro̤ è́prè̤ ná kayǎcò́kayǎte̤ è́prè̤ thǐtahe èthǐ thè́zṳ̂́ myáhtyekuô̌ lahyǎ tè̤ dố thǐ myáhtye yěnuôtahe tadû́rò èthǐ myáhtyenò́ kuô̌ǔ to. Htuô̌to èthǐ thè́zṳ̂́ ní̤huô̌kuô̌ lahyǎ tè̤ dố thǐ ní̤huô̌ nuôtahe tadû́rò èthǐ ní̤huô̌nò́ kuô̌ǔ to. ");
INSERT INTO kyu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Me̤phúnuôrò ní̤dǎ lahyǎ tè̤dyá khákho prè̤pruốtǎ̤ tè̤klwǐ angó̤lasá ari-akyǎ yě. ");
INSERT INTO kyu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bí kayǎ tôprè̤prè̤ ní̤huô̌plǒ Cò́marya ahtyěaké̤ tè̤ritè̤kyǎ rò a thè́gněplǒ to tahe nuôma athyáná tè̤klwǐ latǎ̤ dố klyádè̌kǔ rò khǐnéricyá̤ khuklò́ hyǎphyé taphǎkyǎ tè̤klwǐ dố ǔ pruốtǎ̤ dố èthǐ thè́plòkǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tè̤klwǐ dố a latǎ̤tǒ dố lò̤́klè̌ yětahe nuôma athyáná kayǎ dố a ní̤huô̌ Cò́marya alǎ̤angó̤ rò tôphuốtuô̌ a thè́krṳ̂̌thè́lò̌ phyésû nuôtahe hò́. ");
INSERT INTO kyu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Manárò a zṳ̂́e lahyǎ taplô̤phú prè́, me̤těhérò Cò́marya alǎ̤angó̤ nuô, a nuô̌ oklò̤sò́ma dố èthǐ thè́plòkǔ to. Dố èthǐ zṳ̂́e Cò́marya alǎ̤angó̤ yě akhu-akhyě, a khyábè tè̤pyá̤tè̤sè̌, tè̤me̤cyě̤me̤cṳ̂ rò a vǐkyǎ khyěthyá a tè̤zṳ̂́tè̤nyá̤. ");
INSERT INTO kyu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tè̤klwǐ dố a latǎ̤ dố thòshyáthòprǔklè̌ nuôtahe ma athyáná kayǎ dố a ní̤huô̌ Cò́marya alǎ̤angó̤ tadû́rò a yǒ bèkṳ́bèkyǎ̤ ní̤dyé ná a tè̤ohtwǒprè̤ htuô̌rò a yǒ thè́zṳ̂́ duzá̤htyathè̌ lahyǎ akhu-akhyě, lò̌꤮ tè̤yětahenuô a iplûkhyábíkyǎ lò̌hò́ lǔ rò athèaphǒ htebè́ pǎtohò́. ");
INSERT INTO kyu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tè̤klwǐ dố a latǎ̤ dố hezyeheryákhu tahe nuôma athyáná kayǎ dố a ní̤huô̌ Cò́marya alǎ̤angó̤ rò a thè́gněplǒ nuôtahe hò́. Kayǎ yětahenuô athè è́htya tuố̤ cò́ dố aphuố tôzè̤, aphuố shyěthuô̌thyó, aphuố thuô̌shyě.” ");
INSERT INTO kyu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesǔ dyá pé̤ pó̤ èthǐ ngó̤khákho dố aruô tôtó̤ rò a hé, “Mò́khu htyělé̤ké̤kǔ nuô athyáná prè̤me̤prè́phú tôprè̤ hyǎpruốtǎ̤kyǎ buốkǔlǎklwǐ dố ashuô̌ryá tahe dố prè́khu. ");
INSERT INTO kyu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","A vǐtǎ̤ htuô̌rò bí èthǐ ka̤ omyění̤ sǒtapa̤ lò̌ pwǒ̤꤮ tôprè̤ akhè̌nuô, prè̤ thè́kháthè́hte hyǎ pruốtǎ̤kuô̌ arwè́klwǐ tahe bí èthǐ buốkǔlǎ aklè̌nuô, htuô̌rò a htecuốkyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bí amò̤́ dyáhtya rò aplyǎ̤ htehò́ akhè̌nuô, rwè́mò̤́ tahe plyǎ̤htekuô̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Rò a prè̤me̤tè̤phú ka̤hé abyacè, ‘Byacè, nè̤ hyǎ pruốtǎ̤ buốkǔlǎklwǐ dố ashuô̌ryá nuôtahe prè́ vǎhéto꤮? Rò rwè́mò̤́ tahe cuốphè́htya tuố̤kuô̌ me̤tě?’ ");
INSERT INTO kyu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Rò a hésû a prè̤me̤tè̤phú, ‘Nuôma prè̤thè́kháthè́hte nuôtôprè̤ hyǎme̤ prè́.’ “Rò a prè̤me̤tè̤phú hé lǔ, ‘Ki me̤phúnuôrò, pè̤ hyǎ htò́htekyǎ è ma nè̤ thè́plòo è̌?’ ");
INSERT INTO kyu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Manárò abyacè hésû lǔ, ‘Hyǎhtò́htekyǎ tǎmé̤, a odû, pǎma thǐ htò́htethû́ tuố̤lò̌ buốkǔlǎ mò̤́he. ");
INSERT INTO kyu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nò̌duhtya ró̤dû lǔ bínuô hò́, rò shyé꤮ shuốkhè̌tǒkè́hò́ pǎ rò vǎ nò̌kè́kyǎ ré̤ ǔ rwè́mò̤́ nuôtahe pǎ rò kyě̤klò̌kyǎ è rò isû́kyǎ è ná mi pǎ. Buốkǔlǎ nuôtahe pǎ rò kikè́kipò̤ è pǎ rò dyaplò́ è dố cyǎkǔ pǎ.’” ");
INSERT INTO kyu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Byacè Jesǔ dyápé̤pó̤ èthǐ ngó̤khákho dố aruô tôtó̤, “Mò́khu htyělé̤ké̤kǔ nuôma athyáná kayǎ tôprè̤ iluố̤dyá taplèplò tôplò dố aprè́khu nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tè̤klwǐ pwǒ̤꤮ tôcô aklè̌nuô taplèplò ma a patílố ǔ hò́. Manárò bí a duhtyahò́ akhè̌nuô, adulố ná thòtò̤̌mò̤́ dố aruô tahe. A htwǒhtya thòphú tômò̤́ rò htuphúzuố̤phú tahe hyǎme̤ lahyǎ apwi̤ dố aphyǎ tahe alo̤ cò́.” ");
INSERT INTO kyu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Byacè Jesǔ dyápé̤ pó̤ èthǐ ngó̤khákho dố aruô tôtó̤, “Mò́khu htyělé̤ké̤kǔ nuôma athyáná prè̤mò tôprè̤ phyéní̤ huô̌mû rò a cimû lwítố̤ dố dǐphè́ tôplutôphè aklè̌ rò athè̌ tapho htyalò̌plǐ dǐphè́ yěnuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Bí Byacè Jesǔ hébè ná kayǎ bè́mṳ yětahe akhè̌nuô, a dyápé̤ èthǐ ná lò̌꤮ ngó̤khákho yětahe. A hébè èthǐ rò a dyápé̤ èthǐ ná ngó̤khákho tonuô a o tôphuố꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Me̤phúnuôrò yěma a hyǎtǒ phú Cò́marya héone prè̤pro̤ rò a hé, “Vǎ ki hébè ǔ ná ngó̤khákho tahe pǎ, vǎ ki hésoluô̌ pé̤ èthǐ ná tè̤ dố ǔ dò́uốdò́bí è dố hekhu htwǒlúpǎ nuôtahe pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Rò a htecuốkyǎ dố kayǎ oró̤oè́ aklè̌ rò a cuốnuô̌ dố hikǔ, a khǒpacè̤̌ tahe hyǎ hé lǔ, “Héplǒ pé̤ pè̤ ná nè̤ dyá khákho rwè́mò̤́ o dố prè́khu nuôtahe angó̤lasá nuô to.” ");
INSERT INTO kyu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Rò a hésû èthǐ, “Kayǎ dố a pruốtǎ̤ tè̤klwǐ dố ashuô̌ryá yětôprè̤ angó̤lasá ma prè̤lukayǎ aphúkhǔ yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Prè́ angó̤lasá ma hekhu yětôba hò́, buốkǔlǎklwǐ dố ashuô̌ tahe angó̤lasá ma mò́khu htyělé̤ké̤kǔphú tahehò́, rwè́mò̤́ tahe angó̤lasá ma khǐnéricyá̤ khuklò́ aphú tahehò́. ");
INSERT INTO kyu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Prè̤thè́kháthè́hte dố a hyǎ pruốtǎ̤ rwè́klwǐ nuôtahe angó̤lasá ma khǐnéricyá̤ khuklò́ hò́. Kè́buốkǔlǎ ashuốakhè̌ angó̤lasá ma shyé꤮ mò̤́nyě tadûpǎ nuô hò́. Prè̤kè́ buốkǔlǎ ma tanéphú nuôtahe hò́. ");
INSERT INTO kyu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Phú ǔ htò́hte plò́lò̌ rwè́mò̤́ tahe rò ǔ sû́û̌kyǎ ná mi nuô, shyé꤮ mò̤́nyě tadû pǎma a ki htwǒhtya thyákuô̌ phúnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lò̌꤮ tè̤ dố a thǔ thû́ǔklyá tahenuô, ná lò̌꤮ kayǎ dố pwǒ̤꤮ phuốphuố a me̤ tè̤mǔmyá̤ricyá̤ tahenuô, prè̤lu aphúkhǔ má̤hò́ vǎyě, vǎ ki nò̌hyǎ vǎ tanéphú tahe pǎ rò a ki hyǎ htò́hte taphǎkyǎ èthǐ dố Cò́marya a htyělé̤ké̤kǔ yěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Htuô̌rò a ki vǐtǎ̤lò̌ èthǐ dố Mò́rapò̤tya̤ kǔ pǎ. Bínuô tôpho pǎnuô èthǐ kinguố̤kihè, a ki a̤takrṳ̂ lò̌ akhukhyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bínuôakhè̌ pǎnuô, kayǎcò́kayǎte̤ tahe kilǐkitakhè̌ thyáná tamò̤́ nuô dố Phè̌ Cò́marya ahtyěaké̤kǔ nuô pǎ. Nè̤ ki khǎlèo rò ní̤dǎdû ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mò́khu a htyělé̤ké̤kǔ ma athyáná ǔ cuốdya ouố tè̤ngṳdupri̤du dố lyá̤ tôlé̤ alè̤̌nuô hò́. Bí kayǎ tôprè̤ cuốmyáhtye tè̤yě akhè̌nuô, a plû̌bí ka̤khyě lǔ rò a thè́krṳ̂̌thè́lò̌ rò a ka̤ dố ahi. Rò a isè̌kyǎ lò̌ a tǎ̤muô̌tǎ̤tè̤ tahe rò a ipri̤ ná lyá̤nuô tôlé̤. ");
INSERT INTO kyu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Me̤khyěthyá, mò́khu htyělé̤ké̤kǔ nuôma athyáná prè̤ me̤kuố̤me̤khá tè̤ dố a myápṳ̌ ipri̤ lò̤́ ngṳdupri̤du tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bí a myáhtye lò̤́ dố a ngṳdupri̤du lakǒ cò́ tômě akhè̌nuô, a ka̤ isè̌kyǎ a tǎ̤muô̌tǎ̤tè̤ lò̌꤮ plǐ rò ipri̤ ná lò̤́ nuôtômě. ");
INSERT INTO kyu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Me̤khyěthyá, mò́khu htyělé̤ké̤kǔ nuô athyáná prè̤me̤-etè̤̌ tôprè̤ dố a vǐtǎ̤ itavǐ dố htyěkǔ rò tè̤̌ pwǒ̤myěpwǒ̤cô hyǎní̤ nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bí tè̤̌ ní̤ bǎlò̌hò́ akhè̌nuô, a ilyě itavǐ rò htya-onyǎ iběhte tè̤̌ dố khǒlǒkhu. Tè̤̌ dố aryá tahenuô a dya-odwó dố phò́byekǔ, tè̤̌ dố aryáto tahenuô a vǐkyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Shyé꤮ mò̤́nyě tadû pǎ tônyěnuô, athyáná nuôhò́, tanéphú nuôtahe ki hyǎ pǎ rò a ki hyǎ ihtuô htekyǎ kayǎricyá̤ nuôtahe dố kayǎcò́kayǎte̤ tahe aklè̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Rò a ki vǐtǎ̤kyǎ èthǐ dố Mò́rapò̤tya̤ kǔ pǎ. Bínuô tôphonuô ǔ kinguố̤kihè pǎ, ǔ ki a̤ takrǐtakrṳ̂ lahyǎ cò́ ǔkhukhyě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Byacè Jesǔ sudyǎ a khǒpacè̤̌, “Lò̌꤮ yětahe ma thǐ thè́gně è̌?” Èthǐ hésû, “Ò, pè̤ thè́gně vǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Rò a hésû èthǐ, “Me̤phúnuô akhu-akhyě ǔ ki ithyóthè́gně ka̤lò̌ lò̌꤮ prè̤ithyó tè̤thyótè̤thya athárá nuôtahe ná mò́khu htyělé̤ké̤kǔ hénuôma, athyáná hibyacè tôprè̤ dố a phyéhte a tè̤ngṳdupri̤du dố athè̌ ná alye̤ tahe dố alé̤ dya-oplò́ tè̤khǎlé̤ akǔ.” ");
INSERT INTO kyu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bí Byacè Jesǔ dyá pé̤ htuô̌lò̌hò́ èthǐ ná ngó̤khákho yětahenuô a htecuốkyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Rò a ka̤khyě khyěthyá dố adò̌aso ní̤dûnuô, rò a ka̤ cáhtya ithyóithya ní̤pé̤ adò̌phúsophú tahe dố èthǐ tè̤cò́bè̌hǒkǔ rò èthǐ khyéthukhyéthè́ lò̌plǐ, rò a hé, “Kayǎ yětôprè̤ cuốme̤cyá̤ tuố̤ tè̤pro̤tè̤prya̤ yětahe nuôma a cuốní̤bè tǒ tè̤thítè̤phè́ yěnuô ná tè̤pro̤tè̤prya̤ yěnuô bítětě ha? ");
INSERT INTO kyu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","È ma prè̤sò́cyá̤hi nuôtôprè̤ aphú vǎhéto? Amuố̤ ma amwi̤ ná Maria vǎhéto? Apuố̤ ma Jakomo, Jose, Simonè ná Juda nuôtahe prè́ vǎhé꤮? ");
INSERT INTO kyu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lò̌꤮ apuố̤prè̤mò nuôtahe ma pè̤ dò̌kǔmuố̤ prè́ vǎhéto꤮? Rò a cuố phyéní̤tǒ tè̤yě tahe bítě?” ");
INSERT INTO kyu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Èthǐ hé lahyǎ phúnuô, htuô̌to èthǐ thè́hte Jesǔ rò a è́sû lǔ to, tadû́rò. Jesǔ hé èthǐ, “Kayǎ dố a dyazṳ̂́dyanyá̤ ní̤dyékuô̌ prè̤pro̤ to tahe nuôma tû́prè́ adò̌kǔphú ní̤dû ná a hiphúphyǎphú ní̤dû tahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kayǎ bínuô tahe yǒ zṳ̂́ení̤ Byacè Jesǔ to akhu-akhyě, a dyéluô̌prè́ tè̤me̤ tè̤pro̤tè̤prya̤ nuôtahe takiphú prè́. ");
INSERT INTO kyu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bínuôakhè̌ Prè̤pốtè̤ Herodè ní̤huô̌ Byacè Jesǔ ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Rò a hé a prè̤me̤tè̤phú tahe, “È ma Giovanni Baptista prè́, a thyěihtòka̤khyě hò́, tû́rò a me̤cyá̤ tè̤pro̤tè̤prya̤ nuôtahe hò́nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Khwí Herodè yǒ cuốphyé ní̤dyé khyěthyádû akhǐ Herodia má̤hò́ apuố̤ Philipu amě akhu-akhyě, Giovanni héhtuô̌héthyáthyá lǔ, “Nè̤ cuốphyéní̤ khyěthyá nè̤khǐ phúnuô ma atǒ ná tè̤thyótè̤thya to.” A hé lǔ phúnuôrò a nò̌cuốpṳ̂́ cò̌klò̤ma aklyěphú tahe ná Giovanni rò a nò̌dò́tǎ̤kyǎ lǔ dố htò̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Khwí Herodè thè́zṳ̂́ me̤thyěkyǎ cò́ Giovanni tadû́rò Judaphú tahe yǒ zṳ̂́e ná Giovanni ma prè̤pro̤ tôprè̤ akhu-akhyě, a thè́isě èthǐ alé̤ rò a me̤thyě bû lǔ to. ");
INSERT INTO kyu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Manárò bí Khwí Herodè o pacè̤̌lya̤ amò̤́nyě hyǎtuố̤hò́ akhè̌nuô, Herodia aphúprè̤mò ilě dố Khwí Herodè anyěhyǎ ná sǐpré̤ tahe anyěhyǎ rò Khwí Herodè thè́plòmo̤ thè́plòmǐ kanó̤꤮ to akhu-akhyě, ");
INSERT INTO kyu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","a ò́lya̤ ná a thè́zṳ̂́ kwǐ ǐtětě꤮ nuô, a ki dyé lǔ a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Rò bèkwǐ maǐtěnuô amuố̤ hé pé̤ lǔ rò a cuố hé Khwí Herodè, “Pǎ̤tṳ̂̌ pé̤ vǎ Giovanni Baptista akyǎ̤bǒ rò dya pé̤ vǎ akhuklò́ yěnuô dố dǐbě taè̌dukǔ rò hyǎdyé vǎ bíyě,” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Khwíyě a thè́plòmo̤ to tadû́rò a yǒ ò́lya̤ htuô̌hò́ dố asǐpré̤ tahe anyěhyǎ akhu-akhyě a hétǎ̤ aklyěphú tahe ná a ki cuốme̤phú pacè̤̌muố̤ yětôprè̤ kwǐ lǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Èthǐ cuố dố ǔ lé̤dò́o kayǎ htò̌kǔ rò a cuốpǎ̤tṳ̂̌ ka̤ Giovanni akyǎ̤bǒ. ");
INSERT INTO kyu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Èthǐ dyanuô̌ Giovanni a khuklò́yě dố dǐbětaè̌du akǔ rò a hyǎdyé ná pacè̤̌muố̤ nuôtôprè̤ rò pacè̤̌muố̤yě cò̤̌ka̤ dố amuố̤ o. ");
INSERT INTO kyu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Giovanni a khǒpacè̤̌ tahe hyǎphyéka̤ lǔ né̤klò̤́ okyǎyě rò ka̤ iluốkyǎ lǔ. Htuô̌rò èthǐ cuố dyásopé̤ Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bí Byacè Jesǔ ní̤huô̌ ná ǔ me̤thyě htuô̌hò́ Giovanni akhè̌nuô, è ná a khǒpacè̤̌ tahe cuốnuô̌ sidyání̤ thòklyě rò htecuốkyǎ lahyǎ tû́dû dố khǎlé̤thuôkrě dố ǔ o tôprè̤꤮ to tôpho. Rò bí kayǎ bè́mṳ ní̤huô̌hò́ akhè̌nuô, a o lahyǎ bí vǐ̤kǔ nuôtahe rò a htekrwǒ cuốkuô̌ lahyǎ ná khǎduô dố khǒkhu tôkyě. ");
INSERT INTO kyu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bí Byacè Jesǔ o dố thòklyěkǔ hte akhè̌nuô, a myáhtye kayǎ bè́mṳdu cuố opò̤́ one ré̤ lò̌hò́ dố nyěhò́. Bí a myáhtye èthǐ akhè̌ a thè́zò̤ ní̤dyé èthǐ rò a zasǐmé̤ pé̤lò̌ kayǎswí dố èthǐklè̌ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bí mò̤́hé tamò̤́ kíré̤ phûtǎ̤hò́ akhè̌nuô, a khǒpacè̤̌ tahe hyǎ dố lǔo rò a hyǎhé lǔ, “Khǎlé̤ bíyětôphoma dò̌ ophû tôdò̌꤮ to, htuô̌to mò̤́hé hò́ akhu-akhyě thyáphú èthǐ ki cuốipri̤-e ní̤dyédû lahyǎ a lé̤elé̤ǒ dốdò̌dốso nuôtahe akǔ rò nò̌ka̤mò̌ kayǎ yětahe.” ");
INSERT INTO kyu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Byacè Jesǔ hésû èthǐ, “Lonò̌ka̤ èthǐ to. Myá dyéedyéǒ pé̤ èthǐ tôcôcô nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rò èthǐ hésû lǔ, “Pè̤tè̤ o prè́tû́ khò́mǔ nyǎ̤klò̤́ ná tè̤̌phú nyě̤bè prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Rò a hé èthǐ, “Phyéhyǎ dố vǎ o yě.” ");
INSERT INTO kyu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Rò a nò̌onyǎlya̤lò̌ lò̌꤮ kayǎ nuôtahe dố mi̤thuô̌lè̌khu. A phyé khò́mǔ nyǎ̤klò̤́ ná tè̤̌ nyě̤bèyě rò a tṳ́htya dố mò́lè̤̌ rò a hébwíhétaryěhtya Cò́marya htuô̌rò a ibikyě khò́mǔ. Htuô̌rò a dyétǎ̤ dố a khǒpacè̤̌ tahe a o. Rò a khǒpacè̤̌ tahe zṳ́tǎ̤ dǐtû́ dố kayǎ bè́mṳ tahe a o. ");
INSERT INTO kyu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Èthǐ e pòepòǒ ekò́ǒbǎ lò̌plǐ cò́ pwǒ̤꤮ tôprè̤ cò́. A khǒpacè̤̌ tahe phyédwóplò́ khyě a okyǎlố tahenuô a obǎ pǎ cò́ ná krí̤nuô shyényě̤mě cò́. ");
INSERT INTO kyu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dyáshuô̌shuô̌prè́ prè̤khǔdu dố a e sè yětahenuô a phû꤮ odû nyǎ̤rí cò́. Prè̤mò ná pacè̤̌phú tahenuô dyátuố̤ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Èthǐ ihtuôplò́ htuô̌htuô̌ ná Jesǔ nò̌cuốnuô̌ sidyá lò̌ a khǒpacè̤̌ tahe thòklyě rò a nò̌htecuố ré̤kyǎ èthǐ dố htyěò bè́rè̤̌. Rò bí a khǒpacè̤̌ htyasidyá thòklyě akhè̌nuô, è rò a plwǒka̤kyǎ lò̌ kayǎ bè́mṳ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","A plwǒka̤htuô̌ kayǎ bè́mṳ rò, a cuốhtya kwǐcò́bè̌ dố solo̤ tû́dû tôprè̤ prè́. Bí mò̤́khípaló̤ hyǎ hò́ akhè̌nuô, a o tû́dû bínuô tôprè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Manárò bí thòklyě nuôtôbè htecuố ye̤lǎhò́ dố nókǔ akhè̌nuô, ké̤lathè́du hyǎsásû èthǐ rò htyěháhó hyǎplyá̤ kò́klí lò̌ èthǐ thòklyě. ");
INSERT INTO kyu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bí shyě i-utazè̤̌ mò̤́ kíré̤ lǐbǔhò́ akhè̌nuô, Byacè Jesǔ cuố dố htyěkhu rò a hyǎtǒ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bí a khǒpacè̤̌ tahe myáhtye lǔ cuố dố htyěkhu akhè̌nuô, èthǐ thè́isě tanyǎ̤tadè cò́ rò a è́htǒ lahyǎ, “Kố꤮ luô̤̌taprya̤.” ");
INSERT INTO kyu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Manárò tôphuốtuô̌, Byacè Jesǔ hé èthǐ, “Dyakhû̌dyahǎ lahyǎ thǐ thè́plò. Thè́isě lahyǎ tǎmé̤, yěma vǎ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Rò Petru hé, “Byacè, ki nè̤ má̤lakǒ hérò hé vǎ dố vǎ ki hyǎkuô̌ dố htyěkhu dố nè̤ o.” ");
INSERT INTO kyu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Rò a hé lǔ, “hyǎmò̌.” Rò Petru tǎ̤hte dố thòklyěkǔ rò a hyǎtǒkuô̌ dố Jesǔ a o dố htyěkhu. ");
INSERT INTO kyu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Manárò bí a myáhtye ké̤lathè́ htyěháhó akhè̌nuô, a thè́isě rò a lacû́tǎ̤, rò a è́htǒ, “Byacè, me̤cwó̤ ré̤ vǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Byacè Jesǔ zó̤hyǎ atakhu tôphuốtuô̌ rò a cwihtya lǔ rò a hé lǔ, “Nè̤ tè̤zṳ̂́ patí꤮ lǎ vǎ꤮, nè̤ thè́plò rare me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bí èthǐ htyanuô̌ dố thòklyěkǔ akhè̌nuô, ké̤tacố hyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bínuôakhè̌ kayǎ o dố thòklyěkǔ nuôtahe cò́bè̌htya Byacè Jesǔ rò a hé, “Nè̤ ma Cò́marya aphúkhǔ tôprè̤ má̤lakǒ nyǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Èthǐ cuốbè́ hò́ htyěòduyě rò a cuốtuố̤ lahyǎ dố Gennesaret ké̤. ");
INSERT INTO kyu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dò̌phúsophú bínuô tahe tǒ̤maní̤ Jesǔ rò èthǐ cuốhéso pé̤lò̌ lò̌꤮ kayǎ dố a o lahyǎ dố ké̤kǔ bínuô tahe rò ǔ è́hyǎ lò̌ kayǎswí kayǎsè̌ tahe dố Jesǔ o. ");
INSERT INTO kyu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Èthǐ kwǐthè́zò̤ Byacè ná nò̌tôbè prè́ nè̤ ca̤htû̌ yěnuô ná prè̤swí prè̤sè̌ yětahenuô takiphúprè́. Rò kayǎ dố a tôbè lǔ ca̤htû̌ tahenuô, a tè̤swítè̤sè̌ lamé̤ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pharisěophú ná prè̤ithyó tè̤thyótè̤thya athárá aklè̌ tahehenuô, a o dố vǐ̤ Jerusalem rò a hyǎ sudyǎ Byacè Jesǔ, ");
INSERT INTO kyu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nè̤ khǒpacè̤̌ yětahe nuôma me̤těrò a krwǒlṳ̂me̤ kuô̌ǔ phú tè̤cò́bucò́bè̌ alé̤klǒ o nuôtahe to me̤tě? Èthǐ kíré̤ esè rò a sǐplǐ kuô̌ǔ atakhu to.” ");
INSERT INTO kyu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Byacè Jesǔ hésû èthǐ, “Thǐ vǐkyǎ Cò́marya mekyǎngó̤ tahe rò thǐ cuốkrwǒ lṳ̂me̤ tuố̤ thǐ phyěphuô̌ alé̤klǒ me̤tě? ");
INSERT INTO kyu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Me̤těhérò, Cò́marya hé, ‘Bezṳ̂́benyá̤ nè̤muố̤nè̤phè̌ ní,’ rò ‘Kayǎ dố a isò̌ amuố̤aphè̌ tôprè̤prè̤nuô bè me̤thyěkyǎ lǔ.’ ");
INSERT INTO kyu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Manárò thǐ nò̌hé ǔmuố̤ǔphè̌, ‘Kố꤮ muố̤, Kố꤮ phè̌, rû̌htè̌ dố vǎ tǒbè myákhwè me̤cwó̤ ná thǐnuô a o vǎ, manárò vǎ yǒ belya̤ htuô̌hò́ vǎ thè́plò ná vǎ tǒbè dyé ná Cò́marya,’ thǐ nò̌hé ǔ ná ǔmuố̤ǔphè̌ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kayǎ tôprè̤prè̤ ki ka̤ hé amuố̤aphè̌ phúnuô hérò thǐ nò̌bezṳ̂́benyá̤ pǎ ǔ ná ǔmuố̤ǔphè̌ to hò́. Thǐ lṳ̂krwǒ thǐ phyěphuô̌ alé̤klǒ akhu-akhyě thǐ me̤taphǔkyǎlò̌ hò́ Cò́marya a tè̤mekyǎngó̤ yětômû̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kayǎ cyé̤zò́cò́te̤ ané̤ thǐ꤮, Prè̤pro̤ Isaiah héone thǐrithǐkyǎ nuôma a tǒtû́ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kayǎ yětahe bezṳ̂́benyá̤ lahyǎ vǎ ná akhǎu manárò athè́plò nuôma a otaphǎye̤ ná vǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Èthǐ cò́bè̌htya vǎ yěnuô angó̤lasá o tôcô꤮ to. Èthǐ ithyóithya prè́ ǔ ná prè̤lukayǎ alé̤klǒ tahe prè́ manárò a hé ní̤dyé lahyǎ ná a ithyóithya cò́ ǔ ná Cò́marya a tè̤thyótè̤thya tahe cò́.’” ");
INSERT INTO kyu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Byacè Jesǔ è́hyǎphû kayǎ bè́mṳ dố akhǎshyé rò a hé èthǐ, “Ní̤dǎ rò yácû́ pṳ̌thè́gně tǎ̤te̤ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tè̤ dố a nuô̌ dố kayǎ kyǎ̤kǔ tahenuô, a me̤ taprómǔmyá̤ lǔ dố Cò́marya anyěhyǎ to. Manárò tè̤ dố a hte dố kayǎ kyǎ̤kǔ tahenuô, a me̤ taprómǔmyá̤ lǔ.” ");
INSERT INTO kyu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bínuôakhè̌ a khǒpacè̤̌ tahe hyǎ dố lǔo rò a hé lǔ, “Nè̤ hébè ngó̤ nuôtahenuô, Pharisěophú tahe thè́plòsè̌ lò̌plǐ nè̤ nuôma nè̤ thè́gně ní̤dyé nè̤né̤ è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Rò a hésû èthǐ, “Vǎphè̌ dố mò́khu tôprè̤ ki htò́htekyǎ lò̌plǐ thòmò̤́ dố a isò́ má̤to nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tane̤ tuố̤ tǎ èthǐ tǎmé̤, plwǒ okyǎdû èthǐ phúnuô hò́. Èthǐ ma kayǎ mèthèkhí tahe dố a thǔpé̤ kayǎ mèthèkhí tahe aklyá prè́. Kayǎ mèthèkhí tôprè̤ ki thǔpé̤ kayǎ mèthèkhí dố aruôtôprè̤ klyá hénuôma èthǐ ki latǎ̤lò̌ dố hekǔ thè́nyě̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Htuô̌rò Petru hé lǔ, “Héplǒ pé̤ pè̤ ngó̤khákho yě angó̤lasá nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Byacè Jesǔ hésû èthǐ, “Thǐ tane̤plǒ pé̤ kuô̌nyǎhí ǔ to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tè̤lò̌꤮ plǐ dố a nuô̌ dố kyǎ̤kǔ tahe nuôma, a nuô̌ dố phuô̤̌kǔ, a nuô̌ htuô̌ dố phuô̤̌kǔ rò a bè htecuốkyǎ dố dò̌klò̌ nuôma thǐ thè́gně to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Manárò tè̤ dố a o dố kyǎ̤kǔ hte tahe nuôma a o dố thè́plòkǔ hyǎ, rò a me̤ taprómǔmyá̤ kayǎ. ");
INSERT INTO kyu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Me̤těhérò tè̤me̤thyě prè̤lukayǎ, cuốthû́ ǔphúǔmě, cuốthû́ prè̤mòprè̤khǔ, ehuôehí, khyálahǒlahya tè̤, dyámwi̤htyězo̤ ǔ, ná tè̤tane̤ taprómǔmyá̤ tahe, lò̌꤮ tè̤ yětahe nuôma a hyǎhtelò̌ dố kayǎ a thè́plòkǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tè̤yě tahe ma a me̤ taprómǔmyá̤ kayǎ. Sǐplǐ takhu to rò esè nuôma a me̤ taprómǔmyá̤ kayǎ to.” ");
INSERT INTO kyu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Byacè Jesǔ htecuốkyǎ ná khǎlé̤ bí a ophû tavǐtava̤ ná vǐ̤ Tyre ná vǐ̤ Sido nuôtôpho. ");
INSERT INTO kyu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Rò Canan myěcômuố̤ dố a o dố ké̤bínuô tôprè̤ hyǎ dố Byacè Jesǔ a o rò a hyǎ è́htǒ kwǐthè́zò̤htya lǔ, “Kố꤮ Byacè, Khwí Davi aphúkhǔ, thè́zò̤ré̤ vǎ ní꤮ khǐné me̤bè vǎphúmò rò a me̤shyo nyacò́.” ");
INSERT INTO kyu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Manárò Byacè Jesǔ hésû lǔ tômû̌꤮ to. Rò a khǒpacè̤̌ tahe hyǎ rò kwǐthè́zò̤ lǔ, “Nò̌ ka̤kyǎ prè̤mò nuô tôprè̤, a krwǒ è́htǒè́mo̤ tadû kuô̌ pè̤ nuô̌.” ");
INSERT INTO kyu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Rò Byacè Jesǔ hésû prè̤mò yětôprè̤, “Cò́marya nò̌hyǎ tû́prè́ vǎ dố Israelphú dố athyáná thímí lamé̤ tahe agně prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Rò prè̤mò yětôprè̤ hyǎ dángṳ̂lya̤ dố Byacè Jesǔ nyěhyǎ rò a hé lǔ, “Kố꤮ Byacè, khyáthè́dǒ me̤cwó̤ ré̤ vǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Rò Byacè hésû lǔ, “Pè̤ phyé phú yětahe asèe rò buôekyǎ ná htwitahe nuôma a kòto.” ");
INSERT INTO kyu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Rò a hésû, “Amá̤, Byacè꤮ manárò htwitahe nuôma a enò́ nyǎprè́ abyacè atè̤ tǎ̤kuố̤tǎ̤vè̤̌ dố dǐrè̤́lè̤̌ nuôtahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yětôphuốrò Byacè Jesǔ hésû lǔ, “Mòmuố̤, nè̤ tè̤zṳ̂́tè̤nyá̤ sò̌nyacò́! Phú nè̤ kwǐ nuô a ki htwǒ pé̤dû nè̤ ní꤮.” A phúprè̤mò omo̤-oryá ka̤ takrò̤̌ cò́ bí Byacè hé lǔ akhè̌ nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Byacè htecuốkyǎ bínuô rò a cuốrwó Galilea htyěòduhtû̌ nuô rò a cuốhtya onyǎo dố sorò̤̌lo̤ tôpho. ");
INSERT INTO kyu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kayǎ tahe hyǎpluhyǎphè kuô̌ lò̌plǐ lǔ. Rò èthǐ è́hyǎní̤, záhyǎní̤ lahyǎ kayǎ khǎduôdá tarṳ́-otyá̤ tahe, kayǎ mèthèkhí tahe, kayǎ dátò̤̌ tahe, kayǎ pè́ tahe ná dố aruô tahe è́lǎ rò èthǐ hyǎdyatǎ̤ dố Byacè khǎduôshyé rò a zasǐmé̤ pé̤ lò̌ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bí kayǎ tahe myáhtye ná kayǎ pè́ tahe hébè cyá̤ ka̤khyě, kayǎ dátò̤̌ tahe ryáka̤khyě, kayǎ khǎduôdá tarṳ́-otyá̤ tahe cuốcyá̤khyě, kayǎ mèthèkhí tahe mèthè lǐka̤khyě akhè̌nuô, èthǐ khyéthukhyéthè́ rò htuthè́htya Israel a Cò́marya. ");
INSERT INTO kyu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Byacè Jesǔ è́hyǎ a khǒpacè̤̌ tahe dố a o rò a hé èthǐ, “Vǎ thè́zò̤ ní̤dyé nyacò́ kayǎ yětahe, a o kuô̌ lahyǎ ná vǎ bíyě ma a bǎ hò́ thuô̌nyě hò́. Èthǐ lé̤elé̤ǒ o lahyǎ tôcô꤮ to. Vǎ thè́zṳ̂́ plwǒka̤ tavǐ̤takò̌ èthǐ to, pǎma èthǐ ladyáeladyáǒ rò lakhû́lapò̤ ka̤lò̌ lahyǎ dố klyálo̤ he.” ");
INSERT INTO kyu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Rò a khǒpacè̤̌ tahe hésû lǔ, “Khǎlé̤ bíyě tôphoma dò̌so ophûowó tôdò̌꤮ to. Pè̤ kíré̤ buôe kayǎ yě tôplutôphè agněnuô, pè̤ ki cuốipri̤ etǒ sèe bítě?” ");
INSERT INTO kyu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Rò Byacè Jesǔ sudyǎ èthǐ, “Thǐkhò́mǔ o báklò̤́tě?” Rò èthǐ hésû lǔ, “A o thuô̌thyótôklò̤́ ná tè̤̌phú takiphú꤮ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Rò Jesǔ nò̌onyǎtǎ̤ lò̌ kayǎ bè́mṳ yětahe dố hekhu. ");
INSERT INTO kyu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A phyéhtya khò́mǔyě thuô̌thyótôklò̤́ ná tè̤̌phú yětahe rò a hébwíhétaryě htuthè́htya Cò́marya rò a ibikyě khò́mǔ yětahe, htuô̌rò a dyétǎ̤ ná a khǒpacè̤̌ tahe. A khǒpacè̤̌ tahe cuốzṳ́etǎ̤ dǐtû́ pé̤lò̌ ná kayǎ bè́mṳ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Èthǐ epwǒ̤edwǒ ní̤lò̌ pwǒ̤꤮ tôprè̤, rò a ekò́ǒbǎ pòepòǒ lò̌plǐ cò́. A khǒpacè̤̌ phyédwókhyě khò́mǔ okyǎ yětahenuô a bǎpǎ cò́ ná krí̤nuô thuô̌thyótômě cò́. ");
INSERT INTO kyu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dyá shuô̌shuô̌prè́ prè̤khǔdu dố a esè yěnuô, a o lwǐ̤rí. Prè̤mò ná pacè̤̌ nuô ǔ dyá tố̤kuô̌ to. ");
INSERT INTO kyu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bí Byacè plwǒka̤kyǎ htuô̌hò́ kayǎ bè́mṳ akhè̌nuô, a cuốnuô̌ dố thòklyěkǔ rò a htecuố dố Magada ké̤. ");
INSERT INTO kyu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pharisěophú ná Saducěophú tahe hyǎ dố Byacè Jesǔ a o rò a hyǎ kwǐmyá takè lǔ dố a ki dyéluô̌ pé̤ èthǐ tè̤pro̤tè̤prya̤ dố a o dố mò́khu hyǎ tôcô. ");
INSERT INTO kyu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Rò a hésû èthǐ, “Tamò̤́ kíré̤ tǎ̤hò́ akhè̌nuô, mò́ ki li̤ hérò thǐ hé lahyǎ, parǒpǎ ma ké̤cṳ̂ to. ");
INSERT INTO kyu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Htuô̌rò mò̤́lǐ akhè̌nuô, mò́ ki li̤, ò́luố̤ ki duô̌ hò́rò thǐ hé lahyǎ, ké̤lalyǎ hyǎ pǎ. Thǐ myá mò́lè̤̌ tè̤me̤htwǒhtya tahe rò thǐ myálwó thè́gněone ré̤ ké̤cṳ̂ ké̤lathè́ ari-akyǎ tadû́rò tè̤me̤htwǒhtya ané̤ khǒnyá̤yě tahenuô thǐ cuố thè́gně lwó ré̤ angó̤lasá to ma phútě? ");
INSERT INTO kyu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kayǎcyě̤ kayǎricyá̤ kayǎ dố acò́ kuô̌ǔ ná Cò́marya to yětôhtû̌ tahe cuốkwǐmyá tuố̤ vǎ tè̤me̤ tè̤pro̤tè̤prya̤ tôcô, manárò vǎ ki dyéluô̌ pé̤tû́prè́ èthǐ tè̤pro̤tè̤prya̤ tôcô dố athyáná Prè̤pro̤ Jona nuô pǎ prè́,” a héhtuô̌rò a htecuố taphǎkyǎ ná èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bí èthǐ htecuốbè́ htuô̌hò́ htyěòdu akhè̌nuô, a khǒpacè̤̌ tahe sǒtapa̤ sucuốní̤ khò́mǔ. ");
INSERT INTO kyu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Byacè Jesǔ hé èthǐ, “Rò̤ní̤ lahyǎ Pharisěophú tahe ná Saducěophú tahe ahuô̌mû nuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rò èthǐ dônyǎ ní̤dyé lǔ Jesǔ hé ngó̤ yěnuô tôprè̤ ná tôprè̤ rò a hé lahyǎ phúyě, “Byacè hé pè̤ phúyěnuôma má̤dố pè̤ sǒtapa̤ phyécuốní̤ pé̤ lǔ khò́mǔnuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Byacè Jesǔ thè́gně ná èthǐ hébè lǔ ná khò́mǔ ari-akyǎ akhu-akhyě, a sudyǎ èthǐ, “Kayǎ tè̤zṳ̂́ patí thǐ꤮, mame̤těrò thǐ cuốdônyǎ ní̤dyé khyělǔ ná thǐ sǒtapa̤ phyécuốní̤ khò́mǔ ari-akyǎ phútě? ");
INSERT INTO kyu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tuố̤khǒnyá̤rò thǐ thè́gněplǒ pé̤ kuô̌nyǎ híǔ to è̌? Bí vǎ buôe khò́mǔ nyǎ̤klò̤́ ná kayǎ nyǎ̤rí akhè̌nuô, thǐ phyédwóplò́ khyěthyá a okyǎlố nuôtaherò a o bákrí̤tě nuôma thǐ sǒtapa̤hò́ è̌? ");
INSERT INTO kyu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Má̤torò bí vǎ buôe kayǎ lwǐ̤rí ná khò́mǔ thuô̌thyótôklò̤́ akhè̌nuô, thǐ phyédwóplò́ khyěthyá a okyǎlố nuôtaherò a o bákrí̤tě nuôma thǐ sǒtapa̤ hò́ è̌? ");
INSERT INTO kyu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vǎ hé khò́mǔ ari-akyǎ má̤to nuôma thǐ tǒ thè́gně kuô̌hò́ ǔ hò́. Vǎ hé thǐ, rò̤ní̤ lahyǎ Pharisěophú tahe ná Saducěophú tahe ahuô̌mû nuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bínuôkhè̌ a khǒpacè̤̌ tahe thè́gněplǒhyǎ ná Byacè Jesǔ nò̌rò̤ní̤ èthǐ ná huô̌mû dố ǔ me̤ tapho duhtya è ná khò́mǔ nuô má̤to. A nò̌rò̤ní̤ èthǐ ná Pharisěophú tahe ná Saducěophú tahe a tè̤ithyóithya tahe nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bí Byacè Jesǔ cuốtuố̤ dố vǐ̤ Caesarea Philipi akhè̌nuô, a sudyǎ a khǒpacè̤̌ tahe, “Ǔ hé lahyǎ prè̤lukayǎ aphúkhǔ má̤ vǎyě ná vǎ ma ǔpě?” ");
INSERT INTO kyu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Èthǐ hésû lǔ, “Taheherò a hé ná Giovanni Baptista, tahehe kuô̌kerò a hé ná Prè̤pro̤ Elia, taheherò a hé ná Prè̤pro̤ Jeremia, tomaná prè̤pro̤ khódû dố aruô tahe aklè̌ tôprè̤prè̤ prè́,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Manárò, thǐ kuô̌kelé꤮, thǐ ki hé kuô̌ vǎ ná ǔpě?” A hé rò, ");
INSERT INTO kyu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simonè Petru hésû lǔ, “Nè̤ ma Krístu dố a me̤lwóhteka̤ ǔ tôprè̤ hò́. Nè̤ ma Cò́marya dố a htwǒprè̤ tôprè̤ aphúkhǔ.” ");
INSERT INTO kyu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Rò Byacè Jesǔ hésû lǔ, “Jona aphúkhǔ Simonè, Cò́marya sò̌ri hò́ nè̤ me̤těhérò yěma prè̤lu kayǎ dyéthè́gně htyaluô̌ nè̤ má̤to, má̤dû Phè̌ Cò́marya dố mò́khu tôprè̤ dyéthè́gně htyaluô̌ nè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Rò vǎ hé nè̤, nè̤mwi̤ ná Petru rò vǎ ki sò́lya̤ vǎ prè̤zṳ̂́etè̤plò́mṳ dố lò̤́yě alo̤ pǎ. Tè̤thyě ashyo-asò̌ ki lacṳ́ lò̌ alé̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Vǎ ki dyé nè̤ mò́khu htyělé̤ké̤kǔ thò́hti pǎ. Lò̌꤮ nè̤ cò̌klò̤ma ǔ dố hekhu yěnuô, Cò́marya ki cò̌klò̤ma kuô̌dû ǔ dố mò́khu pǎ. Lò̌꤮ nè̤ ilyě plwǒkyǎ dố hekhu yětahenuô Cò́marya ki ilyě plwǒkyǎ kuô̌dû dố mò́khu pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Rò Byacè Jesǔ dyérò̤dyéryě̤ a khǒpacè̤̌ tahe, vǎ ma Krístu tôprè̤nuô cuốhésoluô̌ pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Cáhtya bínuô rò Byacè Jesǔ héluô̌plǒ pé̤ a khǒpacè̤̌ tahe ná vǎ bècuố dố vǐ̤ Jerusalem rò Judaphú muố̤prû̌muố̤prè̤́ tahe ná bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe ki me̤cyě̤me̤cṳ̂ vǎ è́myěè́cô cò́ pǎ. Èthǐ ki me̤thyě vǎ pǎ htuô̌rò thuô̌nyě bè́htya tônyěpǎ nuô Cò́marya ki me̤htwǒprè̤ ka̤khyě vǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petru è́cuố taphǎ cò̤́cè̤̌kyǎ Byacè takiphú rò a thè́prwǒ̤ lǔ, “Byacè Cò́marya ki me̤tǎ̤tṳ̂̌ pé̤dû nè̤ pǎ. A bè htwǒhtyaní̤ taki꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Byacè Jesǔ tarí ka̤khyětǒ Petru rò a hé lǔ, “Kố꤮ khǐnéricyá̤ khuklò́, htecuố taphǎkyǎ ná vǎ, nè̤ ma athyáná lò̤́ tômě dố ǔ lé̤taphò̌ sítakluô̌ tômě nuôprè́. Nè̤ tè̤tane̤ tahenuô athyáná prè̤lukayǎ a tè̤tane̤ nuô prè́, a thyákuô̌ ná Cò́marya a tè̤tane̤ tahenuô má̤to.” ");
INSERT INTO kyu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Htuô̌rò Byacè Jesǔ hé a khǒpacè̤̌ tahe, “Kayǎ tôprè̤prè̤ ki thè́zṳ̂́ krwǒ vǎkhyě hénuô, a tǒbè me̤ phú vǎ thè́zṳ̂́nò̌me̤ lǔ nuôtahe, a me̤ cṳ́꤮ dû athè́plò ma aní̤ to. A bè záhtya ní̤dyédû a krusu rò a bè krwǒ vǎkhyě. ");
INSERT INTO kyu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Me̤těhérò kayǎ tôprè̤prè̤ dố a thè́lǒ ní̤dyé athè́plò htwǒprè̤ nuô, a ki thyě tacṳ́prè̤ talèkrè́ pǎ. Manárò kayǎ dố a vǐkyǎ athè́plò htwǒprè̤ dố vǎgně tôprè̤nuô a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kayǎ tôprè̤prè̤ ki ní̤bè lò̌ cò́ hekhusǐba a tè̤duzá̤htyathè̌ tahe cò́ tadû́rò a ki lacṳ́kyǎ a thè́htwǒprè̤ tacṳ́prè̤ yě hénuô abwío dố lǔgně ǐtě? Kayǎ dố a thè́zṳ̂́ ní̤bè ka̤khyě khyěthyá a thè́htwǒprè̤ tacṳ́prè̤ yě tôprè̤prè̤nuô tè̤duzá̤htyathè̌ dố a ki ipri̤bè́ ná a thè́plòhtwǒprè̤ yěnuô a o tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Me̤těhérò prè̤lukayǎ aphúkhǔ má̤ vǎyě ki hyǎ ná aphè̌ alǐatakhè̌ pǎ, ná amò́khu tanéphú tahe pǎ rò a ki dyé ǔ pwǒ̤꤮ tôprè̤ a tè̤me̤ní̤khwókè phú èthǐ me̤htuô̌hò́ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Vǎ hé má̤lakǒ cò́ thǐ, kayǎ dố a ihtòo bí thǐklè̌yě tahehenuô, bí èthǐ thyětyahí to akhè̌, èthǐ ki myáhtyenò́ lahyǎ prè̤lukayǎ aphúkhǔ má̤ vǎyě ki hyǎ phú khwí tôprè̤nuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mò̤́nyě thuô̌thyó bǎhtuô̌nuô Byacè Jesǔ è́ní̤ Petru, Jakomo ná apuố̤ Giovanni rò a cuốhtya dố sohtyalô̌ tômě alo̤. Rò a thè́zṳ̂́ cuốotû́dû kuô̌ná èthǐ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bí èthǐ o bínuôakhè̌ Byacè Jesǔ ané̤klò̤́ htulya taklya khólò̌ dố èthǐ nyěhyǎ. Amèthè tôbè nuô a takhè̌ thyácò́ná tamò̤́nuô, ahyeca̤ nuô a bǔthǒ plyatakhè̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Taplô̤phú akǔnuô, èthǐ myáhtye Mosè ná Prè̤pro̤ Elia hyǎoluô̌htya rò èthǐ hébè lahyǎ ná Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petru hé Jesǔ, “Byacè꤮, khǎlé̤ bíyě tôpho rò atwó̤ mo̤ryá lǎ. Nè̤ ki thè́plòo hérò vǎ ki isò́pé̤ thǐ lé̤thû thuô̌mě, tôměrò nè̤gně, tôměrò Mosè agně, tôměrò Prè̤pro̤ Elia agně.” ");
INSERT INTO kyu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bí a hébè pǎprè́ akhè̌nuô, ò́luố̤ takhè̌ tôba lapò̤ tǎ̤bíkyǎ èthǐ rò ngó̤pra̤htya tômû̌ dố ò́luố̤ akǔ, “Yěma vǎphú dố vǎ mo̤ ní̤dyé è rò vǎ thè́plòo ní̤dyé è tôprè̤, ní̤dǎ lahyǎ angó̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bí a khǒpacè̤̌ ní̤huô̌ phúyě akhè̌nuô, èthǐ thè́isě kanó̤꤮ to, rò a vǐ lakhû́ takluô̤̌ tǎ̤lò̌ ané̤ dố hekhu. ");
INSERT INTO kyu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Manárò, Byacè Jesǔ hyǎ tô èthǐ rò a hé èthǐ, “Ihtò lahyǎ, thè́isě tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bí èthǐ myáhtya akhè̌, a myáhtye tû́ Byacè Jesǔ tôprè̤prè̤꤮ tuô̌. ");
INSERT INTO kyu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bí èthǐ o dố solo̤ hítǎ̤ akhè̌nuô, Byacè Jesǔ mekyǎ ní̤ èthǐ ngó̤, “Prè̤lukayǎ aphúkhǔyě ki thyě ihtòhtwǒprè̤ ka̤khyě hí dố tè̤thyě hítonuô, cuố hésoluô̌ pé̤ tǎ ǔ ná thǐ myáhtye tè̤yětahe ari-akyǎ tôprè̤꤮ tǎmé̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A khǒpacè̤̌ tahe sudyǎ lǔ, “Prè̤ithyó tè̤thyótè̤thya athárá tahe hé ná Prè̤pro̤ Elia bèhyǎ ré̤klò̌ ná Messia dố a ki me̤lwóhteka̤ ǔ yěnuô tôprè̤ pǎ, a cuốhétuố̤ phúnuô me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rò Byacè Jesǔ hésû èthǐ, “Prè̤pro̤ Elia bè hyǎ má̤nyǎ pǎ rò a bè hyǎ taritaryǎ me̤ryá ka̤khyě tè̤lò̌꤮ plǐ nuôma a má̤lakǒ cò́ vǎ. ");
INSERT INTO kyu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Manárò vǎ hé thǐ, Prè̤pro̤ Elia hyǎ htuô̌hò́ manárò èthǐ thè́gně lǔ to rò kayǎ tahe me̤ lǔ cṳ́꤮ èthǐ thè́plò thè́zṳ̂́ me̤ lǔ nuôprè́. Thyáphúnuôhò́, prè̤lukayǎ aphúkhǔyě ki khyábè tè̤cyě̤tè̤cṳ̂ dố èthǐ takhukǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bínuôakhè̌ a khǒpacè̤̌ tahe thè́gněplǒhyǎ ná a hé hò́ Giovanni Baptista ari-akyǎ yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bí èthǐ hítǎ̤lya̤ myáhtye kayǎ bè́mṳ dố solè̤̌ akhè̌nuô, kayǎphè̌ tôprè̤ hyǎ dángṳ̂lya̤ dố anyěhyǎ rò a hé lǔ, ");
INSERT INTO kyu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Byacè, thè́zò̤ní̤ ré̤ vǎ phúprè̤khǔ, a taryé shyonyacò́ rò a lakhû́ nuô̌ tamǒmǒ dố mikǔ, má̤torò a latǎ̤nuô̌ tamǒmǒ dố htyěkǔ. ");
INSERT INTO kyu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Vǎ è́hyǎ lǔ dố nè̤ khǒpacè̤̌ tahe a o tadû́rò a zasǐmé̤cyá̤ pé̤ vǎ to.” ");
INSERT INTO kyu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Byacè Jesǔ hé èthǐ, “Kayǎ sǒdǒ tè̤zṳ̂́ thǐ꤮, ná kayǎ cuốthû́klyá thǐ꤮, vǎ bè onyě̤ tố̤kuô̌pǎ ná thǐ bátě? Vǎ tǒbè khyáthè́dǒ nyě̤pé̤kuô̌pǎ thǐ bátě?” A héhtuô̌ phúnuôrò a héke kayǎphè̌ nuôtôprè̤, “È́hyǎ nè̤phúkhǔ bíyě.” ");
INSERT INTO kyu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Byacè Jesǔ thè́prwǒ̤ khǐné rò khǐné htecuốkyǎ dố pacè̤̌phú nuô tôprè̤ akǔ rò atè̤sè̌ lamé̤kyǎ tôphuố lamé̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Htuô̌rò a khǒpacè̤̌ tahe hyǎhuôhyǎthwè́ dố lǔo rò a hyǎ sudyǎhuô lǔ, “Pè̤ vè̤́htekyǎ bè́kuô̌ khǐné to me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Rò a hésû èthǐ, “Mame̤tě thǐ vè̤́htekyǎbè́ kuô̌ǔ khǐné to hérò, thǐ tè̤zṳ̂́ patí dû thǐgněnuô̌. Vǎ hécò́cò́ thǐ꤮, thǐ tè̤zṳ̂́ ki o tí꤮ taplèplò tôplò nuôprè́ tadû́rò thǐ ki hé soyětômě, ‘Thò́thû́ cuố taphǎkyǎ ná khǎlé̤ bíyě,’ kihéma꤮ a ki thò́thû́cuố prè́. Thǐ tè̤zṳ̂́ ki o hénuô, tè̤ dố thǐ me̤cyá̤to nuô a o tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Manárò, thǐ ki duôesè kwǐcò́bè̌ to hénuô, khǐné htecuốkyǎ cyá̤ to.)” ");
INSERT INTO kyu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bí èthǐ cuố myáhtye tǎ̤sû plò́lò̌ lǔ dố Galilea ké̤ akhè̌nuô, Byacè Jesǔ hésoluô̌ pé̤ èthǐ, “Prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě, ǔ ki isè̌ tǎ̤kyǎ è dố prè̤lukayǎ a takhukǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Èthǐ ki me̤thyě lǔ pǎ rò thuô̌nyě bè́htya tônyě pǎnuô a ki htwǒprè̤ ka̤khyě pǎ.” Rò a khǒpacè̤̌ tahe thè́plè̤̌thè́zò̤ lò̌plǐ. ");
INSERT INTO kyu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Bí Byacè Jesǔ ná a khǒpacè̤̌ tahe cuốtuố̤ dố vǐ̤ Capernaum akhè̌nuô, prè̤ihtuôplò́ tè̤lǔhǒdu amo-arǎ tahe hyǎ dố Petru a o rò a sudyǎ lǔ, “Thǐthárá dyékuô̌ tè̤lǔhǒdu amo-arǎ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petru hésû èthǐ, “To, a dyé vǎ꤮” Bí Petru nuô̌ dố hidò́kǔ akhè̌, Byacè Jesǔ hé ré̤ lǔ, “Simonè, nè̤ tane̤ phútě? Hekhu akhwí tahe a hyǎkwǐ amo-arǎ dố maǔpě opě? A kwǐ ní̤dû dố a htyěphúké̤phú tahe a o è̌? Má̤torò a kwǐ lahyǎ dố htyěruô ké̤klò̌phú tahe a o è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petru hésû lǔ, “A kwǐ dố htyěruô ké̤klò̌phú tahe a o prè́.” Rò Byacè Jesǔ hésû lǔ, “Ki me̤phúnuôrò a htyěphúké̤phú ní̤dû tahenuô, a ki ní̤ tè̤palǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Manárò thyáphú èthǐ ki thè́plòsè̌ tǎ pè̤ tǎmé̤ nuô, cuốbímò̌ tè̤̌phú dố Galilea a htyěòkǔ nuô. Tè̤̌phú dố a ní̤ ré̤lố tôbènuô bámǒ myáré̤lố akyǎ̤kǔ nuô. Nè̤ ki myáhtye rû̌zye tôbè pǎ. Phyé rû̌nuô rò cuốdyé ná nè̤gně ná vǎgně tè̤lǔhǒdu amo-arǎ agně nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bínuôakhè̌, Byacè Jesǔ a khǒpacè̤̌ tahe hyǎ dố lǔo rò hyǎ sudyǎ lǔ, “Dố mò́khu htyělé̤ké̤kǔ nuôma, ǔpě ki htwǒdulố ǔ pǎpě?” ");
INSERT INTO kyu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Byacè Jesǔ è́ pacè̤̌ tôprè̤ rò a nò̌hyǎ kahtòo lǔ dố èthǐklè̌. ");
INSERT INTO kyu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Rò a hé èthǐ, “Vǎ hécò́cò́ thǐ꤮, thǐ ki htulya taple thǐ thè́plò to, thǐ ki htwǒhtya thyáná pacè̤̌phú yětahe to hénuô, thǐ nuô̌ní̤ cyá̤ dố mò́khu htyělé̤ké̤kǔ takhyá꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Me̤phúnuôrò, kayǎ dố a shyalya̤ athè́plò phú pacè̤̌phú yětôprè̤nuô, dố mò́khu htyělé̤ké̤kǔ nuôma adulốǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Kayǎ dố a myá vǎmèthè rò a ki è́mo̤sû pacè̤̌phú thyáná yětôprè̤ tôprè̤prè̤nuô a è́mo̤sû hò́ vǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kayǎ tôprè̤prè̤ ki nò̌me̤thû́ kayǎ patílố dố a zṳ̂́e vǎ yětahe aklè̌ tôprè̤prè̤ hénuô, cò̌ lò̤́du dố a kyǎ̤bǒlo̤nuô rò tá̤tǎ̤kyǎ è dố htyědutava̤kǔ nuôma aryáklò̌ pǎ cò́ dố lǔgně cò́. ");
INSERT INTO kyu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Tè̤ dố a hyǎ ilo-ilyápyé kayǎ rò a nò̌me̤thû́ ǔ nuô a o tahe. Phúnuô akhu-akhyě Cò́marya ki ciryacyě̤ ciryacṳ̂ prè̤lu hekhuphú tahe pǎ. Tè̤ yětahenuô, a bè hyǎ má̤lakǒ nyǎpǎ. Manárò Cò́marya ki ciryacyě̤ ciryacṳ̂ kayǎ dố a me̤ htwǒhtya tè̤ yěnuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nè̤ takhu bèbè, nè̤ khǎduô bèbè, a ki nò̌me̤ nè̤ tè̤thû́ hérò pǎ̤tṳ̂̌ rò vǐkyǎ kyǎ ènuô. Nè̤ takhutṳ̂̌ nè̤ khǎduôtṳ̂̌ rò nè̤ ka̤kanuô̌bè́ dố mò́khunuô aryáklò̌ pǎ cò́ ná nè̤ takhu khǎduô ǒpwǒ̤ rò ǔ bè vǐtǎ̤kyǎ nè̤ dố mikyǎ̤ tacṳ́prè̤ talèkrè́ nuôtôphè akǔ pǎnuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nè̤mèthè ki nò̌me̤ nè̤ tè̤thû́ hérò kaǔhtekyǎ rò vǐkyǎ kyǎ ènuô. Nè̤mèthè oprè́ tôkyě rò nè̤ ka̤kanuô̌bè́ dố mò́khu nuô aryáklò̌ pǎ cò́ ná nè̤mèthè opwǒ̤odwǒ lò̌nyě̤kyě rò ǔ bè vǐtǎ̤kyǎ nè̤ dố Mò́rapò̤tya̤ kǔ pǎnuô cò́.” ");
INSERT INTO kyu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Thyáphú thǐ ki tane̤ patí tǎ kayǎ patílố dố ǔklè̌ yětahe tǎmé̤ nuô, rò̤ní̤ lahyǎ thǐné̤. Me̤těhérò vǎ hé hò́ thǐ, èthǐ atanémò́khuphú dố a opò̤́ myá lǔ tahenuô a ophû ná Phè̌ Cò́marya dố mò́khu nuô pwǒ̤꤮ tôphuố cò́. ");
INSERT INTO kyu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Me̤těhérò, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě, vǎ hyǎlya̤ è́ka̤ kayǎ dố a lamé̤ tahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Thǐ tane̤ myámyá, kayǎ tôprè̤ ki athímí o aduô̌ tôzè̤, rò a ki cuốpè̤̌ mé̤kyǎ tôduô̌ kihérò a ki dyakyǎ aduô̌ lwǐ̤thyótôshyě ná lwǐ̤thyó tôduô̌ yěnuô dố asèekhu rò a klyá htecuố myápṳ̌ nyǎprè́ a cuốpè̤̌ mé̤kyǎ yětôduô̌ nuôprè́ má̤to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Vǎ hécò́cò́ thǐ, ki a myáhtye ka̤khyě a lamé̤ yětôduô̌ hérò, a ki thè́krṳ̂̌ lốklò̌ pǎ cò́ ná a okyǎ lwǐ̤thyótôshyě ná lwǐ̤thyó tôduô̌ dố a cuốpè̤̌ kuô̌ǔ to yětahe cò́. ");
INSERT INTO kyu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Thyáphúnuôhò́, dố kayǎ patílố dố ǔklè̌ yětahenuô, a ki thyěkyǎ dốthudốthè́ tôkyě bí tôprè̤ prè́ nuô, thǐphè̌ dố mò́khuyě tôprè̤ thè́plòo taki꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nè̤ puố̤vyá̤ prè̤zṳ̂́etè̤phú tôprè̤prè̤ ki me̤thû́ nè̤ bíkhè̌tě꤮ bèbè, cuốmyáhtye hébè tû́dû ná è rò hésoluô̌ pé̤ lǔ tè̤ dố a me̤thû́ nè̤ nuô tahe. Ki a thè́plòtǒ kuô̌ ná nè̤ rò a ki ò́lya̤ a tè̤me̤thû́ kihérò nè̤ ní̤bè ka̤khyě khyěthyá hò́ nè̤ puố̤vyá̤yě tôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Manárò a ki ní̤dǎ nè̤ngó̤ to hérò, nè̤ kè̤ lǔ ná atè̤thû́ o yěnuô, thyáphú a kiklò̤kima agněnuôrò, prè̤ myáhtye ní̤huô̌ kuô̌ tè̤ ná nè̤nuô, a tǒbè o thè́nyě̤, thè́thuô̌ bá nuô. Phúnuôrò è́krwǒhyǎní̤ kuô̌ǔ tôprè̤, tomaná thè́nyě̤ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ki a ní̤dǎkuô̌ èthǐngó̤ to kihérò dyásoluô̌ ná prè̤zṳ̂́etè̤ plò́mṳphú nuô tahe, rò prè̤zṳ̂́etè̤ plò́mṳphú hé lǔ rò a ki ní̤dǎ toto kihérò hébèhésû̌ è phú thǐ dya kayǎ dố a zṳ̂́enyá̤e kuô̌ǔ to tôprè̤nuô, tomaná hébèhésû̌ è phú prè̤kwǐamo-arǎ tôprè̤nuô. ");
INSERT INTO kyu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Vǎ hécò́cò́ thǐ, dố hekhuyě thǐ cò̌klò̤ma ǐtětě꤮ bèbè, dố mò́khu nuô, Cò́marya ki cò̌klò̤ma kuô̌dû phúnuô pǎ. Dố hekhu yěnuô thǐ ilyěplwǒkyǎ ǐtětě꤮ bèbè, Cò́marya ki ilyěplwǒkyǎ kuô̌dû dố mò́khu pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Vǎ hé pé̤ pó̤ thǐ, dố hekhu yěnuô, kayǎ thè́nyě̤ ki thè́plò thyálǔ hérò a kwǐcò́bè̌ tè̤ǐtětě꤮ bèbènuô vǎphè̌ dố mò́khu yětôprè̤ ki dyépé̤ lò̌lò̌꤮ èthǐ kwǐnuô tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mame̤těhérò, kayǎ thè́nyě̤prè́ bèbè, thè́thuô̌prè́ bèbè, èthǐ ki otố̤oplò́ lǔ dố vǎmwi̤ akǔ kihérò vǎ ki otố̤oplò́ kuô̌dû ná èthǐ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Htuô̌rò Petru hyǎ dố Byacè Jesǔ a o rò a sudyǎ lǔ, “Byacè, vǎ puố̤vyá̤ tôprè̤ ki me̤thû́ vǎ hérò vǎ tǒbè plwǒkyǎ lǔtè̤thû́ báphuố cò́tě? Ma vǎ bè plwǒkyǎ bǎ cò́ è thuô̌thyótôphuố cò́ è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Rò Byacè Jesǔ hésû è, “Vǎ hé nè̤ ná bè plwǒkyǎ prè́ thuô̌thyótôphuố má̤to, nè̤ bè plwǒkyǎ bǎ cò́ è thuô̌thyótôshyě nuô aphuố thuô̌thyótôphuố cò́. ");
INSERT INTO kyu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Phúnuô akhu-akhyě, dố mò́khu htyělé̤ké̤kǔ nuô athyáná khwí tôprè̤ dố a thè́zṳ̂́ me̤lá̤me̤lǐkyǎ lò̌ a rǎmárǎdyǎ oní̤ alulé tahe nuố̤su o lǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Rò bí a cáhtya me̤lá̤me̤lǐ hò́ alulé anuố̤asu tahe akhè̌nuô, a nò̌è́hyǎ ré̤lố alulé dố asu-o è́talwósû́lû̌ lǔ yěnuô tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Rò alulé yětôprè̤ plábè́ lǔ to akhu-akhyě, abyacè hétǎ̤ngó̤ ná a bèka̤ isè̌tǎ̤kyǎ dyé ané̤ ná aphúamě ná a tǎ̤muô̌tǎ̤tè̤ lò̌꤮ plǐ rò a bè hyǎ plálǐkyǎ anuố̤asu. ");
INSERT INTO kyu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Rò a dángṳ̂lya̤ dố khwí nyěhyǎ rò a kwǐthè́zò̤ lǔ, ‘Khyáthè́dǒ kuốré̤ vǎ ní꤮. Vǎ ki plálǐ lò̌dû nè̤ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Rò Byacè yětôprè̤ thè́zò̤ní̤ lǔ rò a dyahtuô̌ pé̤kyǎ lǔsu rò a plwǒka̤kyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Manárò, lulé yětôprè̤nuô, bí a hteka̤ akhè̌ a myáhtye ná akhǒ luléphú thyálǔ dố asu-o lǔ rû̌tôcwè̤́ yětôprè̤. Rò a pṳ̂́ma lǔ rò a ci lǔ kyǎ̤bǒ rò a hé lǔ, ‘Nè̤ lodyé vǎrû̌nuô dyémò̌ vǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Rò lulé yětôprè̤nuô a dángṳ̂lya̤ rò a kwǐthè́zò̤ lǔ, ‘Khyáthè́dǒ kuốré̤ vǎ ní꤮, vǎ plálǐ lò̌dû nè̤ pǎ,’ a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Manárò a ní̤dǎ lǔ tè̤kwǐthè́zò̤ to. A plálǐbè́ hí lǔ to rò a nò̌dò́tǎ̤ tadû ǔ dố htò̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Rò lulé dố aruô tahe myáhtye a me̤ ǔ phúnuôrò èthǐ thè́plòmo̤pǎ cò́ taki꤮ to. Rò a me̤kryá꤮ phútěnuô èthǐ cuốhéso pé̤lò̌ ná khwí nuôtôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Yětôphuốrò khwí nuôtôprè̤ è́hyǎ lǔ rò a hé lǔ, ‘Kayǎ sǒdǒ thè́plò, nè̤ kwǐthè́zò̤ vǎ rò vǎ dyahtuô̌kyǎ pé̤lò̌ nè̤nuố̤nè̤su tahe, ");
INSERT INTO kyu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","nè̤ tǒkò thè́zò̤ ní̤kuô̌ nè̤ khǒlulé thyálǔ yěnuô phú vǎ thè́zò̤ní̤ nè̤ nuô, má̤to è̌?’ ");
INSERT INTO kyu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Rò khwí yětôprè̤ thè́plòdu nyacò́ lǔ rò bí a plálǐ tyahí lǔ to yěnuô a dyétǎ̤kyǎ lǔ dố prè̤me̤cyě̤me̤cṳ̂ lǔ yětahe a takhukǔ.” ");
INSERT INTO kyu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Rò Byacè Jesǔ hé tadûkyǎ dốkhyě, “Thǐ ki plwǒkyǎ lò̌thulò̌thè́ má̤lakǒ thǐ puố̤vyá̤ prè̤zṳ̂́etè̤phú tôprè̤ ná tôprè̤ atè̤thû́ to hénuôma, Phè̌ Cò́marya dố mò́khu tôprè̤ ki me̤ kuô̌ thǐ thyáphúnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bí Byacè Jesǔ hé htuô̌hò́ tè̤yě tahe akhè̌nuô, a o bí Galilea ké̤ nuôrò a htecuốkyǎ dố Judaké̤ bí Jordano htyěklǒ bè́rè̤̌ tôkyě. ");
INSERT INTO kyu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kayǎ krwǒplukrwǒphè kuô̌lò̌ lǔkhyě rò a zasǐmé̤ pé̤ ǔ tè̤swítè̤sè̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Rò Pharisěophú tahehenuô a hyǎ tố̤kuô̌ dố Jesǔ a o rò èthǐ thè́zṳ̂́ hyǎ myápṳ̌ pṳ̂́ Byacè Jesǔ atè̤thû́ rò a hyǎ sudyǎ takè lǔ, “Kayǎ tôprè̤prè̤ okyǎ amě ma aní̤ prè́ pè̤ tè̤thyótè̤thya hényǎ phúnuô è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Byacè hésû èthǐ, “Dố hekhuhtwǒlú mò́khuhtwǒthè̌ akhè̌nuô, ‘Cò́marya byálya̤tû́ prè̤mò tôprè̤ ná prè̤khǔ tôprè̤ prè́,’ nuôma thǐ hốnò́ kuô̌ǔ to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Htuô̌rò Cò́marya hé, ‘Dố tè̤ritè̤kyǎ yě akhu-akhyě prè̤khǔ yěnuô a bè dyakyǎ amuố̤aphè̌ rò a bè cuố otố̤kuô̌ ná amě, rò kayǎ yěthè́nyě̤nuô a htwǒhtyahò́ tôprè̤꤮ tuô̌hò́.’ ");
INSERT INTO kyu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Phúnuôrò èthǐ ma kayǎ thè́gně má̤pǎtohò́. A htwǒhtyahò́ lǔ tôprè̤꤮ tuô̌hò́ akhu-akhyě, tè̤ dố Cò́marya dya otố̤ lǔ nuô, prè̤lukayǎ bè htò́pè̤̌kyǎní̤ tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Rò Pharisěophú tahe sudyǎ pó̤ lǔ, “Kihéphúnuôrò, mame̤těrò Mosè cuố hétuố̤ ná prè̤khǔ tôprè̤prè̤ ki rǎ li-okyǎmě a tè̤rǎmárǎdyǎ tôba rò a dyé ná amě rò a ki okyǎ amě hénuôma aní̤ prè́, a cuố nò̌dyétuố̤ phúnuôma me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Rò Byacè Jesǔ hésû èthǐ, “Mosè plwǒ thǐ dố thǐ okyǎ mě phúyěnuôma aní̤ prè́, me̤těhérò thǐ ma kayǎ myěcô dố a khuklò́pryě̤ khódûgně akhu-akhyě a plwǒ pé̤ thǐ phúnuô prè́. Manárò Cò́marya byálya̤lú tè̤ akhè̌ nuôma a nò̌okyǎ ǔ to. ");
INSERT INTO kyu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Vǎ hé thǐ, kayǎ tôprè̤prè̤ dố amě cuốthû́ prè̤khǔ má̤to tadû́rò a ki okyǎ amě ná tè̤ritè̤kyǎ dố aruô rò a ki cuốphyé taple amě dố aruôtôprè̤ hénuôma a cuốthû́hò́ prè̤mòhò́.” ");
INSERT INTO kyu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Rò a khǒpacè̤̌ tahe hé lǔ, “Tè̤ritè̤kyǎ phúyě ki htwǒhtya cyá̤ dố měnávè̤ aplèkǔ kihérò ki phyémě to ma aryáklò̌ kǒ?” ");
INSERT INTO kyu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Manárò Jesǔ hésû èthǐ, “Kayǎ cṳ̌ebè́ kuô̌ tè̤ithyó yě pwǒ̤꤮ tôprè̤ to. Tè̤ithyó yěnuô a cṳ̌ebè́ tû́prè́ kayǎ dố Cò́marya dyé lǔ dố a ki ohtwǒprè̤bè́ tahe agně prè́. ");
INSERT INTO kyu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Me̤těhérò kayǎ tahehe nuô, ahè̌are oto pǎ dố a muố̤hò́kǔ pǎ akhu-akhyě, a phyé lahyǎ phúmě to. Tahehe nuô ǔ swíkyǎ lǔdye. Dố Cò́marya htyěké̤gně akhu-akhyě tahehe nuô a dyalya̤ hò́ athè́plò ná a ki phyé pǎ aměavè̤ to. Kayǎ dố a cṳ̌ebè́ tè̤ithyó yětahenuô, nò̌me̤ èthǐ nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ǔ phyáhyǎ pacè̤̌phú tahe dố Byacè Jesǔ a o, me̤těhérò èthǐ thè́zṳ̂́ nò̌dyahtya Byacè Jesǔ atakhu dố pacè̤̌phú yětahe alo̤ htuô̌rò a thè́zṳ̂́ nò̌kwǐcò́bè̌ Jesǔ. Manárò a khǒpacè̤̌ tahe thè́prwǒ̤sû kayǎ dố a è́hyǎ pacè̤̌phú yětahe. ");
INSERT INTO kyu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Rò Byacè Jesǔ hé èthǐ, “Plwǒhyǎ pacè̤̌phú nuôtahe dố vǎoyě, me̤tǎ̤tṳ̂̌ tǎ èthǐ tǎmé̤, me̤těhérò mò́khu ahtyěaké̤ nuôma kayǎ dố a shyalya̤ athè́plò thyáná pacè̤̌phú yěnuôtahe atè̤hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Rò a dyahtyahtuô̌ atakhu dố èthǐ alo̤ rò a htecuốkyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kayǎ tôprè̤ hyǎ dố Byacè Jesǔ a o rò a hyǎ sudyǎ lǔ, “Thárá, thyáphú vǎ ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ agněnuô, tè̤ aryá tôcôcô dố vǎ tǒbè me̤nuôma kryá꤮ maǐtě?” ");
INSERT INTO kyu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Byacè Jesǔ sudyǎ lǔ, “Me̤těrò nè̤ cuố sudyǎtuố̤ vǎ ná tè̤ryá ari-akyǎ me̤tě? Kayǎ dố aryá má̤lakǒ nuôma a o prè́tû́ Cò́marya tôprè̤prè̤꤮ tuô̌ prè́. Nè̤ ki thè́zṳ̂́ ní̤bè thè́htwǒprè̤ tacṳ́prè̤ kihérò lṳ̂krwǒ me̤kuô̌ phú Cò́marya mekyǎngó̤ nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kayǎ nuôtôprè̤ sudyǎsû lǔ, “Bítě tahetě?” Byacè Jesǔ hésû lǔ, “‘Me̤thyě tǎ kayǎ tǎmé̤, cuốthû́ tǎ ǔphúǔmě tǎmé̤, ehuôehí tǎmé̤, khyá lahǒlahya tǎ tè̤ tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bezṳ̂́nyá̤ nè̤muố̤nè̤phè̌, mo̤ ní̤dyé nè̤hi khǎsò̌khǎshyé tahe phú nè̤ mo̤lya̤ ní̤dyé nè̤né̤ nuô.’” ");
INSERT INTO kyu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Yětahenuô vǎ me̤htuô̌lò̌hò́. Vǎ lome̤pǎ kryá꤮ maǐtě?” Prè̤khǔ phúthè yětôprè̤ hésû ka̤khyě lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Rò Byacè Jesǔ hé lǔ, “Ki nè̤ thè́zṳ̂́ htwǒhtya kayǎ dố a lốbǎ tôprè̤ kihérò ka̤ isè̌kyǎlò̌ nè̤ tǎ̤muô̌tǎ̤tè̤ nuôtahe rò dyékyǎ ná kayǎ sǒphásǒrya̤phú tahenuô. Nè̤ ki me̤phúnuô hérò nè̤ ki ní̤bè tè̤duzá̤htyathè̌ dố mò́khu pǎ. Ka̤me̤htuô̌ phúnuô rò hyǎ krwǒkuô̌ vǎkhyě.” ");
INSERT INTO kyu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Prè̤khǔ phúthè yětôprè̤nuô, a yǒ duzá̤ tǎ̤pòtǎ̤pè̤̌ cò́ akhu-akhyě, bí a ní̤huô̌ htuô̌ Byacè Jesǔ hé lǔ phúyě akhè̌nuô, a mèthèpyé rò a hteka̤kyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yětôphuốrò Jesǔ hé a khǒpacè̤̌ tahe, “Vǎ hécò́cò́ thǐ, kayǎ duzá̤ tôprè̤ kíré̤ nuô̌ dố mò́khu htyělé̤ké̤kǔ nuôma, apyá̤ nyacò́ dố lǔgně. ");
INSERT INTO kyu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Vǎ hé pó̤ thǐ꤮, tathíbuô̌du tôduô̌ kíré̤ plyénuô̌ dố htè́khǎlí̤kǔnuô azǔ klò̌pǎ cò́ ná kayǎ duzá̤htyathè̌ tôprè̤ kíré̤ nuô̌ dố mò́khu htyělé̤ké̤kǔ nuô cò́.” ");
INSERT INTO kyu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bí a khǒpacè̤̌ tahe ní̤huô̌ a hé phúyě akhè̌, a khyéthukhyéthè́ lò̌ lahyǎ rò a sudyǎ lǔ, “Ki me̤phúnuôrò ǔpě tôprè̤ kíré̤ ní̤bèpǎ tè̤me̤lwóhteka̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Byacè Jesǔ myárè̤̌ tǒdè̌ èthǐ rò a hé èthǐ, “Prè̤lukayǎ me̤lwóhteka̤ cyá̤ ní̤dyé ané̤to tadû́rò Cò́marya me̤cyá̤tè̤ pwǒ̤tôcô.” ");
INSERT INTO kyu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Rò Petru hésû è, “Myámò̌, pè̤ dyakyǎ lò̌ cò́hò́ tè̤pwǒ̤꤮ tôcô rò pè̤ krwǒkuô̌hò́ nè̤khyěhò́. Phúnuôrò pè̤ kíré̤ ní̤bè kuô̌ akhwóakè ǐtětě pǎ?” ");
INSERT INTO kyu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Byacè Jesǔ hésû èthǐ, “Vǎ hécò́cò́ thǐ꤮, bí Cò́marya taritaryǎ thè̌taple lò̌hò́ tè̤lò̌꤮ plǐ pǎ, htuô̌rò vǎ dố a má̤hò́ prè̤lukayǎ aphúkhǔyě ki onyǎ dố khuklyáhtè̌ htyalô̌ alǐatakhè̌ yětôkhu akhu hò́pǎnuô, thǐ dố a krwǒ vǎkhyě yětahe ki onyǎnò́ kuô̌dû dố khuklyáhtè̌ htyalô̌ shyényě̤khu alo̤ yěnuô pǎ rò thǐ ki cirya ní̤dû Israelphú shyényě̤muố̤ yěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Htuô̌to ǔpěpě꤮ bèbè, dố vǎ akhu-akhyěrò a dyakyǎ ahi-aprè́ bèbè, apuố̤avyá̤ tahe bèbè, amuố̤aphè̌ bèbè, aphúalye̤ tahe bèbè, a ki ní̤bè è́lốklò̌ pǎ cò́ ná a dyakyǎ nuôtahe aphuố dố azè̤kǔ pǎ, htuô̌rò a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Manárò kayǎ dố ǔ tane̤ lǔ ná a lodulố ǔ tôprè̤nuô, a ki okyǎ dốkhyělố ǔ pǎ, kayǎ dố a okyǎ dốkhyělố ǔ tahenuô a ki htwǒhtya kayǎ dố ǔ lodulố lǔ pǎ,” Jesǔ hé pé̤ èthǐ phú nuô. ");
INSERT INTO kyu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Me̤těhérò, mò́khu htyělé̤ké̤kǔ ma athyáná prè́byacè tôprè̤ dố a htecuố ro̤mû́ rò a cuố dakè hyǎ ǔ dố a thòbǐthèphèkhu yěnuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Prè́byacè yětôprè̤ ná prè̤dakèephú yětahenuô, a thè́plòtǒ lǔ ná a ki dakè lǔ tônyě ma rû̌zye denari tôbè. ");
INSERT INTO kyu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Bí mò̤́plyǎ̤sè̌htya lwǐ̤thyótômû̌ bèhò́ akhè̌nuô, a cuố dố klè́kǔ rò a cuố myáhtye kayǎ okǒodǎ prè́ rò atè̤me̤ oto tahe ihtò ohtǒolya̤ lahyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Rò a hé èthǐ, ‘Hyǎ rya̤kuô̌ lahyǎ dố vǎ thòbǐthèphèkhu nuô rò vǎ ki myá dyétǒdyébè pé̤dû thǐ akhwóakè pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Rò èthǐ hyǎ lahyǎ dố lǔprè́khu rò prè́byacè yě htecuố khyěthyá dố klè́kǔ bí mò̤́htuô shyényě̤mû̌ bè akhè̌nuô, htuô̌rò a htecuố khyěthyá bí mò̤́hélya̤ thuô̌mû̌bè akhè̌ rò a cuố dakè hyǎkhyě ǔ dố a thòbǐthè lé̤khu rò a hé ǔ phú a hé ré̤ htuô̌hò́ ǔ nuô tahe. ");
INSERT INTO kyu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Rò a htecuố khyěthyá dố klè́kǔ bí mò̤́hélya̤ nyǎ̤mû̌ akhè̌, rò a cuố myáhtyepǎ kayǎ dố a okǒ tǎ̤dǎ, a tè̤me̤ oto tahe kahtòohtǒ kahtòolya̤ bínuô rò a sudyǎ èthǐ, ‘Tôcô꤮ rò thǐ me̤tè̤to rò thǐ cuố ihtòo kyǎdě lò̌ bíyě tônyě mò̤́hé me̤tě?’ ");
INSERT INTO kyu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Rò èthǐ hésû lǔ, ‘Prè̤dakè hyǎkuô̌ pè̤ a o tôprè̤꤮ to.’ “Rò a hé èthǐ, ‘Hyǎme̤ kuô̌ lahyǎ dố vǎ thòbǐthè lé̤khu nuô.’ ");
INSERT INTO kyu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Bí mò̤́tǎ̤hò́ akhè̌nuô, prè́byacè yě hé aprè̤ pốtarí myákhwèní̤ prè́ yětôprè̤, ‘È́hyǎ lahyǎ prè̤me̤tè̤phú nuôtahe rò dyépé̤ èthǐ akhwóakè nuô. Dyéré̤lố a hyǎ tǎ̤nolố akhǒ nuôtahe ní, rò a hyǎ ré̤lố nuôtahe rò dyénolố ǔ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Prè̤me̤tè̤phú dố a hyǎ me̤tè̤ dố mò̤́hélya̤ nyǎ̤mû̌ akhè̌ tahe hyǎphyé ré̤lố khwókè rò prè̤ dố a pốtaríní̤ prè́ yětôprè̤ dyé èthǐ tôprè̤ ná rû̌zye denari tôbè. ");
INSERT INTO kyu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yětôphuốrò shuốkhè̌ tǒke hò́ dố a hyǎrya̤ ré̤lốklò̌ ǔ tahe rò èthǐ tane̤ ná a ki ní̤bè è́klò̌ rû̌ ná ǔ pǎ tadû́rò èthǐ ní̤bè rû̌zye denari tôprè̤ tôbè thyáná ǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bí èthǐ ní̤bè khwókèyě akhè̌ a tamwǒ̤talè̌ prè́byacè azo̤. ");
INSERT INTO kyu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Èthǐ hé prè́byacè, ‘Kayǎ yětahe rò a hyǎ me̤ní̤ nyě̤prè́ tômû̌ khǎlé̤phú prè́ rò a ka̤lè́ hò́ tadû́rò nè̤ dyé èthǐ khwókè thyáná pè̤pè̤. Pè̤ rò pè̤ me̤ sǒphásǒrya̤ dố ké̤kṳ́klè̌ tônyě꤮ mò̤́hé cò́ rò nè̤ dyélố pè̤ toto.’ ");
INSERT INTO kyu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Manárò prè́byacè hésû dố a hé phúyě aklè̌ tôprè̤, ‘Vǎ me̤-e dố nè̤khu tôcô꤮ to, vǎ me̤ tǒ prè́, nè̤ thè́plòtǒ htuô̌hò́ ná vǎ ki dyé nè̤ tônyě ma rû̌zye denari tôbè vǎhéto? ");
INSERT INTO kyu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Phyéní̤ nè̤ khwókèyě rò ka̤mò̌. Vǎ thè́zṳ̂́ dyé kayǎ dố a hyǎ rya̤nolố ǔkhǒ yětahe akhwóakè thyáná vǎ dyé nè̤ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Vǎrû̌ ná vǎné̤ prè́, vǎ thè́zṳ̂́ me̤phútě rò a ní̤nyǎ to è̌? Vǎ dyézǔdyéye̤ tè̤ phúyě rò nè̤ thè́khwè́ vǎ è̌?’ ");
INSERT INTO kyu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Phúnuôrò ǔ tane̤ patí è́lǎ kayǎ tahe tadû́rò Cò́marya ki dyadu lǔ pǎ. Ǔ tane̤du è́lǎ kayǎ tahe tadû́rò Cò́marya ki dya patílố lǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bí Byacè Jesǔ htya dố vǐ̤ Jerusalem rò bí a cuố dố klyálo̤ akhè̌nuô, a è́cuố plò́khó a khǒpacè̤̌ shyéthè́nyě̤yě tôpho rò a hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pè̤ htya dố vǐ̤ Jerusalem, rò ǔ ki isè̌tǎ̤kyǎ prè̤lukayǎ aphúkhǔ má̤dû vǎyěnuô dố bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe a takhukǔ pǎ. Rò èthǐ ki thè́plò tǒ lò̌ lǔ dố a ki me̤thyěkyǎ vǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Èthǐ ki dyétǎ̤ dǐtû́ vǎ dố Judaphú má̤to tahe a khadǎkǔ pǎ. Rò Judaphú má̤to tahe ki hébè takhwótakè kanǐkano lò̌ vǎ pǎ. Htuô̌rò èthǐ ki mṳ̂̌ vǎ ná suplye̤ iplírwí̤ pǎ rò èthǐ ki mṳ̂̌thyěhtya vǎ dố krusulo̤ pǎ. Manárò thuô̌nyě tônyě pǎnuô Cò́marya ki me̤htwǒprè̤ kahtò ka̤khyě khyěthyá vǎ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Htuô̌rò Zebedeo aphúkhǔ Jakomo ná Giovanni amuố̤ yěnuô a hyǎ ró̤kuô̌ ná a phúprè̤khǔ yěthè́nyě̤ dố Byacè Jesǔ a o. Amuố̤yě hyǎ dángṳ̂tǎ̤ dố Byacè anyěhyǎ rò a kwǐthè́zò̤ lǔ ná a ki me̤ pé̤ lǔ tè̤tôcô. ");
INSERT INTO kyu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Rò Byacè hé lǔ, “Nè̤ thè́zṳ̂́ dố vǎ ki me̤cwó̤ pé̤ nè̤ ǐtě?” Rò a hésû Byacè, “Shyé꤮ nè̤ htwǒ hò́ khwí dố Cò́marya htyělé̤ké̤kǔ hò́ pǎnuô dyéonyǎ pé̤kuô̌ vǎphú yěthè́nyě̤ dố nè̤ takhu cò́htwó tôkyě tôprè̤, dố nè̤ takhu cò́ci tôkyě tôprè̤ pǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Byacè hésû èthǐ, “Thǐ hyǎkwǐ tè̤yěnuô thǐ thè́gně ní̤dyé ari-akyǎ to. Tè̤cyě̤tè̤cṳ̂ dố vǎ kíré̤ khyábè yě pǎnuôma thǐ ki khyábè́ kuô̌nyǎ pǎ è̌?” Rò èthǐ hésû, “Pè̤ khyábè́ kuô̌ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Byacè hésû èthǐ, “Thǐ ki khyábè má̤ kuô̌ lakǒ dû phú vǎ khyábè yěnuô pǎ. Manárò nè̤ tǒ onyǎ dố vǎ takhu cò́ci tôkyě è̌, cò́htwó tôkyě è̌ nuô a o dố vǎ khadǎkǔ má̤to. Vǎphè̌ dố mò́khu yětôprè̤ taritaryǎ pé̤ hò́ khǎlé̤yě ná cṳ́꤮ a thè́zṳ̂́ dyé ní̤dû ǔnuôtahe agně hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bí a khǒpacè̤̌ dố a okyǎ prè̤shyé yětahe ní̤huô̌ a sudyǎ phúyě akhè̌ nuô, èthǐ thè́plòdu lò̌ puố̤ ná vyá̤ nuô thè́nyě̤. ");
INSERT INTO kyu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Byacè Jesǔ è́plò́lò̌ èthǐ rò a hé èthǐ, “Thǐ thè́gnědû hò́ ná khwíducò́phyahtǔ tahe nuôma a nò̌e ní̤dyé lahyǎ a taryěshyosò̌ dố htyěphúké̤phú tahe akhu. Htyěphúké̤phú a khuklò́khuklyǎ thǐ taherò a nò̌e ní̤kuô̌dûhò́ a taryěshyosò̌ yěnuô dố htyěphúké̤phú tahe akhukhu. ");
INSERT INTO kyu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Thǐ ke rò thǐ tǒ me̤phúnuô to. Dố thǐklè̌nuô, kayǎ tôprè̤prè̤ ki thè́zṳ̂́ htwǒdu hérò a tǒbè htwǒ thǐ prè̤me̤tè̤phú. ");
INSERT INTO kyu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Htuô̌rò dố thǐklè̌nuô, kayǎ tôprè̤prè̤ ki thè́zṳ̂́ htwǒ thǐbyacè hérò a tǒbè htwǒ thǐcṳ̂́. ");
INSERT INTO kyu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Myábû̌kuô̌ vǎ má̤dû prè̤lukayǎ aphúkhǔyě, vǎ hyǎ dố ǔ ki me̤pé̤ vǎgně nuô má̤to. Vǎ hyǎ dố vǎ ki me̤pé̤ ǔgně prè́. Rò thyáphú vǎ ki ihtaka̤ní̤ èthǐ agněnuôrò, vǎ dyélya̤kyǎ vǎ thè́plò htwǒprè̤ dố kayǎ è́prè̤ agně.” ");
INSERT INTO kyu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bí Byacè Jesǔ ná a khǒpacè̤̌ tahe htecuốkyǎ bí vǐ̤ Jeriko akhè̌nuô, kayǎ bè́mṳdu krwǒkuô̌ lò̌ lǔkhyě tôplutôphè. ");
INSERT INTO kyu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kayǎ mèthèkhí thè́nyě̤ onyǎo dố klyáhtû̌ rò bí a ní̤huô̌ ǔ hé ná Byacè Jesǔ hyǎhò́ dố èthǐ khǎshyé akhè̌nuô, a è́htǒ rò a hé, “Kố꤮ Davi aphúkhǔ, Byacè꤮, thè́zò̤ kuô̌ ré̤ pè̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","“Thuôthuô꤮ omyá,” kayǎ bè́mṳ tahe hé èthǐ shyoshyo, a lé è́htǒhtya shyoshyo pó̤, “Kố꤮ Davi aphúkhǔ, Byacè꤮, thè́zò̤ kuô̌ ré̤ pè̤ ní꤮,” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Byacè Jesǔ okuố è́ èthǐ rò sudyǎ èthǐ, “Thǐ thè́zṳ̂́ nò̌me̤ vǎ maǐtě?” ");
INSERT INTO kyu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Rò èthǐ hé lǔ, “Byacè, pè̤ thè́zṳ̂́ mèthèlǐ kuô̌ǔ.” ");
INSERT INTO kyu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Byacè Jesǔ thè́zò̤ní̤ èthǐ rò a tôhyǎ èthǐ mèthèplò rò èthǐ mèthè lǐhtya khyé cò́. Rò èthǐ cáhtya krwǒkuô̌ lò̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bí Byacè Jesǔ ná a khǒpacè̤̌ tahe hyǎphûhò́ ná vǐ̤ Jerusalem akhè̌nuô, a hyǎtuố̤ lahyǎ dố dò̌ Bethphage dố a o bí Oliva sokhu nuô. Jesǔ nò̌hyǎ ré̤ a khǒpacè̤̌ thè́nyě̤ rò a hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Hyǎnuô̌ ré̤ lahyǎ dò̌ dố nyěnuô tôdò̌, thǐ hyǎ nuô̌nuô̌ ná thǐ ki myáhtye ǔ cò̌klò̤o mya̤ò́lyǎmuố̤ tôduô̌ ná aphúpatí otathwo tố̤kuô̌ná lǔ bínuô tôduô̌ pǎ. Ilyě è rò cwika̤lò̌ dố vǎoyě. ");
INSERT INTO kyu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kayǎ tôprè̤prè̤ ki hé thǐ tôcôcô hérò, hésoluô̌ pé̤ lǔ ná Byacè lo èthǐ héphúnuô, thǐ ki hé phúnuôma a plwǒka̤ thǐ tôphuố plwǒka̤ cò́.” ");
INSERT INTO kyu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tè̤yěnuô a ki me̤lốbǎhtya prè̤pro̤ a tè̤héone, ");
INSERT INTO kyu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Hésoluô̌ pé̤ vǐ̤ Zionphú tahe, ‘Myámò̌ lahyǎ, thǐ khwícò́phya hyǎ dố thǐ o hò́. È ma a thè́dǒthè́nga̤ rò a sidyá hyǎní̤ mya̤ò́lyǎ. Rò a sidyá hyǎ dố aphúpatí tôduô̌.’” ");
INSERT INTO kyu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A khǒpacè̤̌ yěthè́nyě̤ cuốme̤ phú a héní̤ èthǐ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Èthǐ cwika̤ní̤ mya̤ò́lyǎmuố̤ ná aphú rò èthǐ idè̌htya lahyǎ aca̤klò̌ dố mya̤ò́lyǎ yětahe anyá̤khu rò Byacè htya-onyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kayǎ bè́mṳdu yětahe dè̌tǎ̤ lahyǎ aca̤klò̌ tahe dố klyádè̌kǔ. Taheherò a kè̤́tǎ̤ lahyǎ thòphyǎphú tahe rò dè̌tǎ̤ dố klyádè̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kayǎ cuố ré̤ dố Byacè anyěhyǎ tôplutôphè, a krwǒkuô̌ dốkhyě tôplutôphè rò a è́htǒ lahyǎ, “Hosanna, htuthè́htya lahyǎ Khwí Davi aphúkhǔ.” “Byacè dố a hyǎ dố Cò́marya amwi̤yě tôprè̤nuô, tè̤sò̌ri ki lya̤bèdû è ní꤮” “Hosanna, htuthè́htya lahyǎ Cò́marya dố a o dố mò́khu akhǎlé̤ htyalô̌lố yětôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bí Byacè Jesǔ nuô̌ dố vǐ̤ Jerusalem akhè̌nuô, vǐ̤ Jerusalemphú tôvǐ̤lò̌ thè́plò tapṳ̂́kazò̤́ lò̌plǐ rò èthǐ sudyǎ, “È ma ǔpě?” ");
INSERT INTO kyu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kayǎ bè́mṳyě hésû, “È ma Jesǔ. È ma prè̤pro̤ dố a o dố Galilea ké̤, Nazarè vǐ̤nuô tôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Byacè Jesǔ cuốnuô̌ dố tè̤lǔtyǎ hǒkǔ rò a cuốnuô̌ vè̤́htekyǎ lò̌lò̌꤮ kayǎ ipri̤-isè̌tè̤ bínuô tahe rò a nuô̌htu laklò̤̌tǎ̤kyǎ lò̌ ǔ lé̤htulya rû̌ a dǐrè̤́htyalô̌ nuôtahe ná khuklyáhtyalô̌ dố ǔ lé̤onyǎ isè̌ ná htulwí̤ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Htuô̌rò a hé, “Lisǎsè̌kǔ hé, ‘Vǎhi ma ǔ ki è́ ná tè̤cò́bè̌ ahi,’ manárò thǐ cuố nò̌htwǒ lò̌hò́ vǎphè̌ ahi ná ‘Prè̤ehuôehí lé̤owóo akhǎlé̤ hò́.’” ");
INSERT INTO kyu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kayǎ mèthèkhí khǎduôdá tahe hyǎnuô̌tǒ kuô̌lò̌ Byacè Jesǔ dố tè̤lǔtyǎ hǒkǔ, rò a zasǐmé̤ pé̤lò̌ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Manárò bí bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe myáhtyehò́ Byacè Jesǔ me̤ tè̤pro̤tè̤prya̤ tahe htuô̌rò a myáhtye ná pacè̤̌phú tahe è́htǒhtya lahyǎ, “Hosanna, htuthè́htya Khwí Davi aphúkhǔ,” dố tè̤lǔtyǎ hǒkǔ akhè̌nuô, èthǐ thè́plòdu kanó̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Èthǐ sudyǎ Byacè, “Pacè̤̌phú thǐtahe è́htǒ nuôma nè̤ ní̤huô̌ è̌?” Rò Byacè hésû èthǐ, “Ò, vǎ ní̤huô̌ vǎ꤮, lisǎsè̌ hé, ‘Pacè̤̌phú thǐtahe ná pacè̤̌phú dố a ǒnúpǎ tahenuô, nè̤ ki nò̌htuthè́htya èthǐ pǎ,’ a hé phúnuô ma thǐ hốnò́ kuô̌nyǎ ǔ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Htuô̌rò Byacè Jesǔ htecuốkyǎ dố dò̌ Bethania rò a cuố omyěo bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Anotôrǒ bí mò̤́lǐ ro̤mû́ akhè̌nuô, Byacè ná a khǒpacè̤̌ tahe ka̤khyě khyěthyá dố vǐ̤ Jerusalem, rò bí èthǐ ka̤ dố klyálo̤ akhè̌, Jesǔ thè́e dǐ. ");
INSERT INTO kyu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Rò Jesǔ myáhtye kadwímò̤́ tôthò o dố klyáhtû̌ rò a cuố tǒ lǔ tadû́rò a myáhtye athè o tôplò꤮ to. A o shuô̌shuô̌ alè prè́. Yětôphuốrò a hé kadwímò̤́ yětôthò, “Thèkuô̌ pǎ tǎ ǔ tôphuố꤮ tǎmé̤ ní꤮” a hé rò kadwímò̤́ krǎthyě cò́ tôphuốthyě cò́. ");
INSERT INTO kyu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bí a khǒpacè̤̌ tahe myáhtye tè̤htwǒhtya phúyě akhè̌, a khyéthukhyéthè́ lò̌plǐ cò́. Rò èthǐ sudyǎ Byacè, “Kadwímò̤́ yětôthò a cuốthyě tôphuốthyě cyá̤tuố̤ phútětě ha?” ");
INSERT INTO kyu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Byacè hésû èthǐ, “Vǎ hécò́cò́ thǐ꤮, nè̤ zṳ̂́e rò nè̤ ki thè́plòrare to hénuôma phú vǎ hé kadwímò̤́ rò a thyěkrǎkyǎ yěnuô, thǐ ma꤮ thǐ me̤ cyá̤kuô̌dû phúnuô prè́. Thǐ ki me̤cyá̤lốklò̌ pǎ cò́ ná nuô pǎ. Thǐ ki hé so yětômě, ‘Thò́thû́ cuố taphǎkyǎ dố htyědutava̤ akǔnuô,’ hénuôma a ki htwǒhtya pé̤ thǐ phú thǐ hé nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Thǐ ki zṳ̂́e nuô, thǐ kwǐtè̤ dố Phè̌ Cò́marya a o ǐtětě꤮ bèbè thǐ ní̤bè pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Byacè Jesǔ nuô̌ dố tè̤lǔhǒdu vǐ̤kǔ rò bí a ithyóithyatǎ̤ ǔ akhè̌nuô, bwídukhu tahe ná Judaphú tè̤cò́bucò́bè̌ khuklò́khuklyǎ tahe hyǎ dố Byacè a o rò a sudyǎ lǔ, “Nè̤ cuốme̤tuố̤ tè̤phúyě tahe ròma nè̤ cuốme̤ ná ǔpě a taryěshyosò̌ pě? Ǔpě nò̌me̤ nè̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Byacè hésû èthǐ, “Vǎ sudyǎ kuô̌ thǐ ngó̤ tômû̌, thǐ ki hésû pé̤ kuô̌ vǎ hérò vǎ me̤ tè̤yětahe ná ǔpě a taryěshyosò̌ pěnuô vǎ ki hésoluô̌ pé̤kuô̌ thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Giovanni Baptista plwǒ pé̤ ǔ htyě yěnuôma Cò́marya dyé lǔ taryěshyosò̌ è̌? Má̤torò prè̤lukayǎ dyé lǔ è̌?” Rò èthǐ hé ní̤dyélǔ, “Pè̤ ki hé, ‘Cò́marya dyé lǔ’ kihérò, a klyá sudyǎ nyǎ hò́ pè̤, ‘Kihéphúnuôrò thǐ zṳ̂́e lǔ to me̤tě?’ A klyá hé nyǎ phúnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Manárò pè̤ ki hé, ‘Prè̤lukayǎ dyé lǔ’ kihérò, pè̤ thè́isě kayǎ bè́mṳ yětahe alé̤lé̤, me̤těhérò kayǎ yětahe yǒ zṳ̂́e lahyǎ ná Giovanni ma Cò́marya aprè̤pro̤ má̤lakǒ tôprè̤, phúnuônuô.” ");
INSERT INTO kyu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Phúnuô akhu-akhyě èthǐ hésû Jesǔ, “Pè̤ thè́gněto.” Rò Jesǔ hésû èthǐ, “Kihéphúnuôrò vǎ me̤tè̤ yětahe ná ǔpě a taryěshyosò̌ pě nuô vǎ hésoluô̌ pé̤ thǐ toto.” ");
INSERT INTO kyu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Hé pé̤myá vǎ thǐ tane̤ phútě? Kayǎ tôprè̤ rò a phúprè̤khǔ o thè́nyě̤. Rò a cuố hé a vyá̤duklò̌ tôprè̤, ‘Yětônyě hyǎ dố prè́khu rò hyǎmyákhwè thòbǐthèmò̤́ ní꤮.’ ");
INSERT INTO kyu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Rò a hésû aphè̌, ‘Vǎ hyǎ to,’ a hé tadû́rò dốkhyě nuô a tane̤ ní̤khyě rò a hyǎ khyěthyá. ");
INSERT INTO kyu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Htuô̌rò phè̌yě tôprè̤nuô a cuốke dố aphúpatí tôprè̤ a o rò a hé thyálǔ phú a hé a phúvyá̤prè̤́ nuôtôprè̤. Rò a hésû aphè̌, ‘Ò phè̌, vǎ hyǎdû pǎ,’ tadû́rò a hyǎ péto. ");
INSERT INTO kyu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Phúprè̤khǔ yěthè́nyě̤nuô, a me̤tǒ aphè̌ thè́plò bítě tôprè̤tě?” Rò èthǐ hésû lǔ, “Adu tôprè̤.” Rò Byacè hé èthǐ, “Vǎ hécò́cò́ thǐ, thǐ lé̤nuô̌o akhǎlé̤ dố mò́khu htyělé̤ké̤kǔ nuô, prè̤kwǐamo-arǎ ná himyáphèmuố̤ tahe cuốnuô̌phekyǎ thǐ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Me̤těhérò Giovanni hyǎ dyéluô̌ thǐ ná tè̤cò́tè̤te̤ aklyá tadû́rò thǐ zṳ̂́e lǔ to. Manárò prè̤kwǐamo-arǎ ná himyáphèmuố̤ tahe zṳ̂́e lǔ. Thǐ myáhtye cò́ kayǎ yětahe athè́plò htulya ka̤ cò́ tadû́rò thǐ thè́plò htulyaka̤ kuô̌ǔ to htuô̌to thǐ zṳ̂́ekuô̌ cò́ ǔ taki꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ní̤dǎ pó̤ lahyǎ tè̤dyá dố aruô yětôtó̤. Bètôphuốnuô prè́byacè dố a isò́iplû̌ ní̤dyé a thòbǐthèmò̤́ tahe otôprè̤. A ira̤tava̤bí ní̤dyé lò̌ a tarè́yě, rò a ikhûo ní̤dyé ahekǔ tôkǔ dố a ki ivǐ̤hte ná thòbǐthèhtyě agně, htuô̌rò a isò́htya ní̤ lé̤thûhtyalô̌ dố ǔ lé̤opò̤́myá ná prè́ agně tômě. Htuô̌rò a plwǒkhyǎekyǎ aprè́yě ná prè̤me̤prè́ tahe rò a htecuốkyǎ dố ké̤aruô tôké̤. ");
INSERT INTO kyu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Thyáphú prè̤khyǎe lǔ prè́ tahe ki běepé̤ kuô̌ lǔ thòthè tahenuôrò, bí shuốkhè̌ phûhyǎ hò́ dố tǒ ibaplò́ hò́ thòbǐthè akhè̌ nuô, a nò̌hyǎ a prè̤me̤tè̤phú tahe dố prè̤khyǎeprè́ tahe a o. ");
INSERT INTO kyu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Prè̤khyǎeprè́ tahenuô a pṳ̂́ prè́byacè a prè̤me̤tè̤phú yětahe rò a mṳ̂̌ lǔtè̤ tôprè̤, a me̤thyěkyǎ lǔtè̤ tôprè̤, tôprè̤ rò a tá̤ lǔ ná lò̤́. ");
INSERT INTO kyu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yětôphuốrò a nò̌hyǎ è́lốklò̌ke prè̤me̤tè̤phú dố èthǐ o rò a hyǎè́ klò̌ ná a hyǎ ré̤ nuôtahe cò́ tadû́rò prè̤khyǎeprè́ nuôtahe me̤cyě̤me̤cṳ̂ èthǐ thyáná a hyǎ ré̤ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dốkhyětadûrò, a nò̌hyǎ a phúprè̤khǔ dố èthǐ a o. ‘Vǎphú ná vǎné̤ ma èthǐ klyá thè́nyá̤thè́tarè̤̌ klò̌nyǎ prè́,’ a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Manárò bí prè̤khyǎeprè́ yětahe myáhtye lǔ akhè̌nuô, èthǐ hé ní̤dyélǔ, ‘È ma prè̤ dố a ní̤bè ucè̌tazè̌ nuôtôprè̤ hò́, cuố! Cuốme̤thyěkyǎ lǔ pó꤮, rò pè̤ ki phyé a ucè̌tazè̌ pǎ pó꤮,’ a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Rò a pṳ̂́ lǔ rò a cwihtekyǎ lǔ dố tarè́klò̌ rò a me̤thyěkyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Phúnuôrò shyé꤮ prè́byacè hyǎtuố̤ pǎnuô, a ki me̤ èthǐ phútě pǎ?” ");
INSERT INTO kyu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Prè̤lǔtyǎ khuklò́ tahe ná Judaphú tè̤cò́bè̌ khuklò́khuklyǎ tahe hésû, “A ki me̤cyě̤me̤cṳ̂, me̤thyěkyǎ kayǎcyě̤kayǎcṳ̂ nuôtahe pǎ. Rò a ki plwǒkhyǎ khóke aprè́ yěnuô ná prè̤khyǎeprè́ dố a ki ibě ka̤khyěe pé̤ lǔ bí tè̤thètè̤phǒ hte ashuốakhè̌ nuôtahe pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Byacè hé èthǐ, “Lisǎsè̌kǔ hé, ‘Kayǎ me̤htya hi rò lò̤́ dố èthǐ vǐkyǎ lǔ nuôtôměnuô a htwǒhtya lò̤́ dố a tahtwóma lò̌ cò́ hitômě cò́. Yěnuôma Byacè Cò́marya me̤tè̤ prè́, rò a me̤tè̤ yěnuôma a tè̤pro̤tè̤prya̤ nyacò́.’ “Lisǎsè̌kǔ hé phúyěnuôma thǐ hốnò́ kuô̌ǔ tôphuố꤮ to è̌? Thǐ klyá hốnò́ nyǎprè́. ");
INSERT INTO kyu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Phúnuôrò vǎ hé thǐ mò́khu htyělé̤ké̤kǔ dố thǐ tǒkò ní̤bènuô Cò́marya ki phyéphekyǎphe thǐ pǎ. Rò a ki dyé ná kayǎ dố a cṳ̌e Cò́marya angó̤ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kayǎ dố a latǎ̤ dố lò̤́ yětômě alo̤nuô, akrwí ki lakè̤́ prè́ pǎ, manárò lò̤́ yětômě ki latǎ̤ dố lǔlo̤ pǎ nuô, akrwíakrwó ki mû kaprǐ̤ lò̌ cò́ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bí bwídukhu tahe ná Pharisěophú tahe ní̤huô̌ Byacè Jesǔ dyákhákho akhè̌nuô, èthǐ thè́gně ná Byacè hékho èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Rò èthǐ myápṳ̌ lahyǎ klyá dố a kíré̤ pṳ̂́ Jesǔ tadû́rò Jesǔ ma prè̤pro̤ tôprè̤, kayǎ bè́mṳ tahe yǒ zṳ̂́e lahyǎ phúnuô akhu-akhyě, èthǐ thè́isě kayǎ bè́mṳ nuôtahe alé̤. ");
INSERT INTO kyu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Byacè Jesǔ dônyǎ khákho pé̤ khyěthyá èthǐ rò a hé, ");
INSERT INTO kyu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mò́khu a htyělé̤ké̤kǔ nuôma athyáná khwí tôprè̤ dố a taritaryǎ one pé̤ a phúprè̤khǔ pwè̌ ka̤sǒdya dố a ki buôebuôǒ sû ǔ agně yěnuô tôprè̤hò́. ");
INSERT INTO kyu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A nò̌cuố è́hyǎ kayǎ dố a mehyǎehyǎǒ lǔ tahenuô ná prè̤me̤tè̤phú tahe tadû́rò èthǐ hésû lahyǎ, ‘To, pè̤ hyǎkuô̌ nè̤ to.’ ");
INSERT INTO kyu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Htuô̌rò a nò̌cuốè́ pó̤ ná a prè̤me̤tè̤phú dố aruô tahe rò a hécuốní̤ lǔ, ‘Héso pé̤ kayǎ dố vǎ mehyǎehyǎǒ lǔ nuôtahe, vǎ taritaryǎ htuô̌lò̌ hò́ dǐmò̤́hé agněhò́. Vǎ me̤thyěe cò́ pṳ́phè̌du ná pṳ́phú katúkatya tahe azye cò́. Hyǎehyǎǒ lahyǎ ka̤sǒmè̤̌sǒdya a tè̤etè̤ǒ yěnuôma aní̤ hò́, cuốhéso pé̤ lahyǎ èthǐ phúyěnuô ní꤮’ a hécuốní̤ a prè̤me̤tè̤phú tahe phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Manárò kayǎ dố khwí mehyǎ lǔ tahenuô a bezṳ̂́benyá̤ tôcô꤮ to. A htecuố khókyǎ lò̌. Tôprè̤ rò a hyǎ dố prè́khu, tôprè̤ rò a cuố me̤kuố̤me̤khá. ");
INSERT INTO kyu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A okyǎ tahe ke rò a pṳ̂́ me̤cyě̤me̤cṳ̂ khwí a prè̤me̤tè̤phú tahe, htuô̌rò a me̤thyě lǔtè̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yětôphuốrò khwí thè́plòdu rò a nò̌cuố aklyěphú tahe rò èthǐ cuốme̤thyěkyǎ lò̌꤮ kayǎ dố a me̤thyě lǔ prè̤me̤tè̤phú nuôtahe rò sû́û̌kyǎ lò̌ èthǐ vǐ̤. ");
INSERT INTO kyu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Rò a hé prè̤me̤tè̤phú tahe, ‘Ǔ taritaryǎ one lò̌hò́ ka̤sǒdya a tè̤etè̤ǒ tadû́rò kayǎ dố vǎ mehyǎ lǔ tahe nuôma kayǎ tahe dố a tǒkò mehyǎ to. ");
INSERT INTO kyu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cuốmò̌ lahyǎ dố klyáto̤ klyásásû lǔ nuô rò myáhtye ǔpěpě꤮ bèbè è́hyǎlò̌ èthǐ dố pwè̌kǔyě ní꤮.’ ");
INSERT INTO kyu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Phúnuôrò a prè̤me̤tè̤phú tahe htecuố dố klyádu tahe akǔ rò a cuốè́ka̤ plò́lò̌ lò̌꤮ kayǎ dố a myáhtye nuôtahe. Acyě̤ bèbè, aryá bèbè, a hé pǎ to, a è́ka̤ lò̌plǐ cò́ rò dố ka̤sǒdya ahikǔ nuô sǐpré̤ bǎtapí꤮ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Manárò bí khwí hyǎnuô̌myá sǐpré̤sǐmya̤ akhè̌nuô, a myáhtye sǐpré̤ dố a kû̌thyá kuô̌ǔ ka̤sǒdya a hyeca̤ to o tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A sudyǎ lǔ, ‘Khǒmè̤̌꤮, nè̤ kû̌thyání̤ kuô̌ǔ hyeca̤ ka̤sǒdya to rò nè̤ cuố hyǎnuô̌ ní̤ kuô̌ǔ phútě?’ Tadû́rò a hésû lǔ tômû̌꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Yětôphuốrò khwí hé a prè̤me̤tè̤phú tahe, ‘Cò̌klò̤lò̌ atakhu khǎduô nuô rò tá̤htekyǎ è dố akhíklè̌ nuô. Khǎlé̤ bínuô tôphoma tè̤nguố̤plyá̤nguố̤rya̤ akhǎlé̤ ná tè̤ a̤takrṳ̂ cò́ khukhyě akhǎlé̤.’ ");
INSERT INTO kyu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Me̤těhérò Cò́marya mehyǎ è́lǎ kayǎ tadû́rò a nwóhtya patíprè́ ǔ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Htuô̌rò thyáphú Pharisěophú tahe ki pṳ̂́ní̤ Byacè Jesǔ hébèthû́ ngó̤ tahe agněnuôrò, a htecuố okúokyá ní̤dyé lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Èthǐ nò̌cuố tố̤kuô̌ a khǒpacè̤̌ tahe ná Khwí Herodè aplò́amṳphú tahe dố Byacè a o rò èthǐ cuốhé Byacè, “Thárádu, pè̤ thè́gně ná nè̤ ma kayǎ cò́cû́cò́ tôprè̤. Nè̤ ithyó cò́ ǔ phú Cò́marya thè́zṳ̂́ nò̌ohtwǒprè̤ ǔ nuôtahecò́. Nè̤ dǎ ithyóithyahò́ ǔ hénuôma nè̤ ithyó pé̤prè́ ǔ tè̤má̤tè̤cò́ prè́. Prè̤lukayǎ tahe tane̤cò́ nè̤ phútě bèbè, nè̤ thè́isě kuô̌ǔ tôcô꤮ to. Nè̤ myádu myápatí kuô̌ǔ toto. ");
INSERT INTO kyu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Phúnuôrò nè̤ hépé̤myá pè̤ yětôcô, ma nè̤ tane̤ phútě? Ma pè̤ tǒkòdyé Roma akhwídu Caesare amo-arǎ è̌? Ma pè̤ tǒdyé to è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Manárò Byacè Jesǔ thè́gněone htuô̌hò́ dố èthǐ kíré̤ pṳ̂́ lǔngó̤ rò a hésû èthǐ, “Kayǎ cyé̤zò́cò́te̤ né̤ thǐ꤮, mame̤těrò thǐ hyǎcyé̤ sudyǎkho ngó̤ phúyě me̤tě? ");
INSERT INTO kyu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dyéluô̌ pé̤myá vǎ rû̌zye dố thǐ dyé ná amo-arǎ yěnuô,” rò èthǐ hyǎdyé lǔ rû̌zye denari tôbè. ");
INSERT INTO kyu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Rò a sudyǎ èthǐ, “Yěma ǔpě khuklò́zǎ̤zo̤ pě? A rǎo ná ǔpě amwi̤pě?” ");
INSERT INTO kyu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rò èthǐ hésû, “Khwí a khuklò́zǎ̤zo̤ ná khwí amwi̤.” Htuô̌rò Byacè hésû èthǐ, “Khwídu Caesare atè̤ kihérò dyé ná khwídunuô, Cò́marya atè̤ kihérò dyé ná Cò́marya nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bí èthǐ ní̤huô̌ Jesǔ hé phúyě akhè̌nuô, a htetapa̤ lò̌plǐ èthǐ rò èthǐ hteka̤ taphǎkyǎ lò̌ lǔlé̤. ");
INSERT INTO kyu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bínuô tônyěhò́, Saducěophú dố a zṳ̂́edû agně ná shyé꤮ thyěhtuô̌pǎ nuô tè̤htwǒprè̤ ka̤khyě o pǎ to tômṳnuô a hyǎ dố Byacè a o rò a hyǎ sudyǎ lǔ ngó̤ tômû̌. ");
INSERT INTO kyu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Rò èthǐ sudyǎ Byacè Jesǔ, “Thárádu, Mosè hé pé̤ pè̤ ná prè̤khǔ tôprè̤prè̤ ki thyě rò aphú ki okyǎ tôprè̤꤮ to hénuô, thyáphú aklwǐalyǎ ki okyǎ kuô̌ǔ nuôrò, a puố̤prè̤khǔ bè phyédwó akhǐ okyǎyě, a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Khǒnyá̤rò dố pè̤klè̌nuô puố̤ ná vyá̤ prè̤khǔ o thuô̌thyótôprè̤. A vyá̤prè̤́lố tôprè̤ phyé amě rò dốkhyěnuô a thyěkyǎ amě lé̤, rò aphú okyǎ tôprè̤꤮ to akhu-akhyě apuố̤ dốkhyě tôprè̤ bèphyédwó akhǐ okyǎ yětôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Apuố̤ nyě̤prè̤ tôprè̤ htuô̌rò thuô̌prè̤ tôprè̤ tuố̤dố aprè̤ thuô̌thyótôprè̤ yětôprè̤nuô a htwǒhtya thyákuô̌ lò̌ phú avyá̤prè̤́ htwǒhtya nuô. ");
INSERT INTO kyu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dốkhyětadû rò prè̤mò yětôprè̤ thyě kuô̌no prè́. ");
INSERT INTO kyu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Phúnuôrò shyé꤮ thyěihtòka̤khyě amò̤́nyě pǎ tônyěnuô, yě thuô̌thyótôprè̤. Aklè̌nuô, bítě tôprè̤ ki htwǒ avè̤ pǎ? Me̤těhérò èthǐ htwǒnò́lò̌ lǔvè̤ nuô̌꤮,” a sudyǎ Jesǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Rò Byacè Jesǔ hésû ka̤khyě èthǐ, “Thǐ thû́ lò̌hò́, me̤těhérò thǐ thè́gně tǎ̤te̤ kuô̌ǔ lisǎsè̌ ná Cò́marya a tè̤pro̤tè̤prya̤ me̤cyá̤ tè̤ tahe to. ");
INSERT INTO kyu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Me̤těhérò shyé꤮ ǔ thyě ihtòka̤khyě pǎnuô ǔ phyéphúphyémě, ǔ phyéphúphyévè̤ o pǎtohò́, èthǐ ki thyákuô̌lò̌ phú mò́khutanéphú nuôtahe pǎhò́. ");
INSERT INTO kyu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Tè̤thyě ihtòka̤khyě ari-akyǎ yěnuô, Cò́marya hékyǎ, ‘Vǎ ma Abraham a Cò́marya, Isaac a Cò́marya, ná Jacob a Cò́marya,’ a hé phúyě nuôma thǐ hốnò́ kuô̌ǔ to è̌? Cò́marya ma kayǎthyě tahe a Cò́marya má̤to, kayǎ htwǒprè̤ tahe a Cò́marya.” ");
INSERT INTO kyu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bí kayǎ bè́mṳ ní̤huô̌ a tè̤ithyóyě akhè̌nuô, a khyéthukhyéthè́ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pharisěophú tahe ní̤huô̌ ná Saducěophú tahe héka̤khyě sûbè́ Byacè Jesǔ tômû̌꤮ to rò Pharisěophú tahe è́oplò́ ní̤dyé khyělǔ. ");
INSERT INTO kyu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dố èthǐ aklè̌nuô, a thè́gně lốbǎklò̌ Judaphú a tè̤thyótè̤thya nuô a otôprè̤ rò a hyǎ sudyǎkhomyá Byacè Jesǔ, ");
INSERT INTO kyu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Thárá, tè̤mekyǎngó̤ a tè̤thyótè̤thya aklè̌ yětahe nuôma bítě tômû̌ rò a lodulố ǔ?” ");
INSERT INTO kyu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Byacè hésû ka̤khyě, “‘Mo̤ lò̌thulò̌thè́ thǐ Cò́marya ná thǐ thè́plò sǐmělò̌, mo̤ lò̌thulò̌thè́ è ná thǐ tè̤ohtwǒprè̤ lò̌꤮ plǐ, mo̤ lò̌thulò̌thè́ è ná thǐ tè̤tane̤ lò̌꤮ plǐ.’ ");
INSERT INTO kyu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yěma tè̤mekyǎngó̤ dố a lodulố tômǎ̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nyě̤mǎ̤tômǎ̤ ma, a thyáhò́ ná aré̤ nuô tômǎ̤ hò́, ‘Mo̤ kayǎ dố a ophûowó ná thǐ nuôtahe phú thǐ mo̤lya̤ ní̤dyé thǐné̤ nuô.’ ");
INSERT INTO kyu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lò̌꤮ Mosè ná prè̤pro̤ thǐtahe a tè̤ithyóithya a khǎshyékhǎrya̤ tahenuô a tatehtya lò̌plǐ dố tè̤mekyǎngó̤ yěnyě̤mû̌ alo̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bí Pharisěophú cuố oplò́oplu lò̌ lǔ akhè̌nuô, Byacè Jesǔ sudyǎ èthǐ, ");
INSERT INTO kyu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Krístu dố a me̤lwóhteka̤ ǔ yětôprè̤ ari-akyǎ nuô, thǐ tane̤ lǔ phútě? Aklwǐalyǎ tǎ̤kalya̤ dố ǔpě o?” Rò èthǐ hésû, “Khwí Davi aklwǐalyǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Rò a hé èthǐ, “Ki me̤phúnuôrò mame̤těrò Thè́ Sǎsè̌ Byacè hturyǎ̤ Davi rò a cuốnò̌ è́tuố̤ Krístu yěnuô, ‘Byacè’ me̤tě꤮? Me̤těhérò a cuốhé tuố̤, ");
INSERT INTO kyu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Byacè Cò́marya hé vǎ Byacè, “Bí vǎ me̤pé̤ lò̌lá̤takli tyahí prè̤thè́hte nè̤ nuôtahe rò vǎ dya-olò̌ èthǐ dố nè̤ khanyělè̤̌ híto nuô, onyǎo dố vǎ takhu cò́htwó yětôkyě.”’ ");
INSERT INTO kyu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Rò Khwí Davi ki è́ lǔ, ‘Byacè’ kihérò a cuố htwǒ cyá̤ Khwí Davi aphúkhǔ phútě?” ");
INSERT INTO kyu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ǔ hésû ka̤khyě cyá̤ pǎ lǔ tôprè̤꤮ to. Cáhtya bínuô tônyě tǎ̤plehyǎ nuô ǔ sudyǎbû pǎ lǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Byacè hé kayǎ bè́mṳ tahe ná a khǒpacè̤̌ tahe, ");
INSERT INTO kyu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Prè̤ithyó tè̤thyótè̤thya athárá tahe ná Pharisěophú tahe ma a ní̤bè taryěshyosò̌ dố a bè ithyóithya héhte taple luô̌ pé̤ ǔ ná Mosè a tè̤thyótè̤thya tahe. ");
INSERT INTO kyu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Me̤phúnuôrò thǐ bè ní̤dǎ èthǐngó̤, thǐ bè krwǒme̤ lò̌ phú a hésoluô̌ pé̤ thǐ nuô. Manárò krwǒme̤ kuô̌ tǎ phú èthǐ me̤nuô tǎmé̤, me̤těhérò èthǐ yětahe nuôma a krwǒme̤ kuô̌ phú a hé pé̤ ǔ nuôtahe to. ");
INSERT INTO kyu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Èthǐ nò̌lṳ̂krwǒme̤ ǔ tè̤cò́bucò́bè̌ a tè̤thyótè̤thya è́cô thyáná a nò̌zá ǔ tǎ̤muô̌tǎ̤tè̤ dố ahtuôanyé tahenuô tadû́rò thyáphú ǔ ki zábè́ tǎ̤muô̌tǎ̤tè̤ dố ahtuôanyé tahe agněnuô, taki꤮ ma èthǐ me̤cwó̤ cò́ ǔ to. ");
INSERT INTO kyu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Lò̌꤮ èthǐ me̤ hò́ nuôtahe nuô a thè́zṳ̂́ nò̌myáhtye ǔ ná ané̤ prè́. Èthǐ isè́ tapye̤ lyá̤du lisǎsè̌ htò̌ rò a cò̌ lahyǎ dố a mǎ̤htè́lo̤ ná a takyǎ̤lo̤, htuô̌to èthǐ thè́zṳ̂́ thyá lahyǎ ca̤cwo̤karo̤ dố akhǎmí̤ htǔklò̌ ná ǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bípwè̌bíla akhè̌nuô, èthǐ thè́zṳ̂́ onyǎo lahyǎ dố khǎlé̤ htyalô̌ tahe. Kidố tè̤cò́bè̌ hǒkǔ hérò èthǐ thè́zṳ̂́ onyǎo lahyǎ khǎlé̤ dố ǔ lé̤bezṳ̂́benyá̤ lǔ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Dố klè́kǔ kayǎ oplu-ophè aklè̌ hénuô, a thè́zṳ̂́ nò̌hébè bezṳ̂́ ǔ ná ané̤, rò a thè́zṳ̂́ nò̌è́ ‘Thárá’ ǔ ná ané̤né̤. ");
INSERT INTO kyu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Manárò thǐ rò nò̌ è́ ‘Thárá’ tǎ ǔ ná thǐné̤ tǎmé̤ ní꤮, me̤těhérò thǐthárá ma a o prè́ tôprè̤prè̤꤮ tuô̌ prè́. Htuô̌to thǐ ma thǐpuố̤thǐvyá̤ thyálò̌ lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dố hekhu yěnuô è́ ‘phè̌’ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮, me̤těhérò nè̤phè̌ oprè́ tôprè̤prè̤꤮ tuô̌ prè́. È ma a o dố mò́khu. ");
INSERT INTO kyu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","‘Thárádu,’ nò̌ è́ tǎ thǐné̤ ná ǔ tôprè̤꤮ tǎmé̤mé̤, me̤těhérò nè̤ thárádu o prè́ tôprè̤prè̤꤮ tuô̌ prè́, è ma Byacè Krístu. ");
INSERT INTO kyu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kayǎ dố a htwǒ thǐ prè̤me̤tè̤phú nuôma kayǎ dố adulốǔ dố thǐklè̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kayǎ dố a phyéhtyalô̌ ané̤ nuô, Cò́marya ki shyatǎ̤ lǔ pǎ. Kayǎ dố a shyalya̤ ané̤ nuô Cò́marya ki dyahtyalô̌ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Judaphú a prè̤ithyó tè̤thyótè̤thya athárá thǐtahe ná Pharisěophú thǐ꤮, Cò́marya ki cirya thǐ pǎ. Thǐ ma kayǎ dố a cyé̤zò́cò́te̤ ané̤ tahe. Thǐ me̤bí phekyǎlò̌ lò̌꤮ kayǎ dố a myápṳ̌nuô̌ dố mò́khu htyělé̤ké̤kǔ nuôtahe kadǎ. Thǐ né̤byacè ní̤dû cò́ rò thǐ nuô̌ní̤ to tadû́rò thǐ pṳ̌ me̤tǎ̤tṳ̂̌bí kyǎlò̌ kayǎ dố a myápṳ̌nuô̌ nuôtahe akadǎ. ");
INSERT INTO kyu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Judaphú a prè̤ithyó tè̤thyótè̤thya athárá thǐtahe ná Pharisěophú thǐ꤮ Cò́marya ki cirya thǐ pǎ. Thǐ ma kayǎ dố a cyé̤zò́cò́te̤ ané̤ tahe. Me̤těhérò thǐ cuố hébè taklyé phyéphekyǎlò̌ prè̤mòokryá ahi ná a tǎ̤muô̌tǎ̤tè̤ tahe rò thyáphú ǔ ki myáhtye thǐ phú kayǎcò́kayǎte̤ tahe nuôrò thǐ kwǐ cò́bè̌htǔ pé̤ ǔ. Me̤phúnuôrò Cò́marya ki cirya cyě̤klò̌ thǐ ná ǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Prè̤ithyó tè̤thyótè̤thya athárá ná Pharisěophú thǐ꤮, Cò́marya ki cirya thǐ pǎ. Thǐ ma kayǎ dố a cyé̤zò́cò́te̤ ané̤ tahe. Thyáphú thǐ ki ilo kanuô̌ ní̤kuô̌ kayǎ tôprè̤nuô, thǐ cuốlě tava̤ ye̤nyacò́ dố khǒlǒ khukhu, dố htyěkǔkǔ cò́, rò bí kayǎ tôprè̤prè̤ thè́plòo zṳ̂́e krwǒme̤ kuô̌ hò́ thǐ dố a kò ná ngarakǔ tahenuô, thǐ ithyóithya lǔ dố a ki htwǒhtya thǐ khǒpacè̤̌ dố acyě̤acṳ̂klò̌ ná thǐ nyě̤phuố. ");
INSERT INTO kyu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kayǎ mèthèkhí dố a thǔ pé̤ ǔ klyá thǐ꤮, Cò́marya ki cirya thǐ pǎ. Thǐ hé, ‘Kayǎ tôprè̤prè̤ ki byǎangó̤ ná tè̤lǔhǒdu hénuô, a lé̤héo ná tôcô꤮ to, manárò ki a cuốbyǎ angó̤ ná htè̌ dố a o dố tè̤lǔtyǎ hǒkǔ nuôtahe hénuôma a bè htwǒhtya phú a hé nuô.’ ");
INSERT INTO kyu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kayǎ olốoklò̌ thǐ꤮, thǐ thè́plò a mèthè yěnuô a lè̌ vǎ꤮. Tane̤ myámò̌, bítě tôcô a loduklò̌. Htè̌ loduklò̌ è̌? Ma tè̤lǔhǒdu dố a me̤sǎsè̌ htè̌yěnuô a loduklò̌ è̌? ");
INSERT INTO kyu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Thǐ hé, ‘Kayǎ tôprè̤prè̤ ki byǎ angó̤ ná tè̤lǔtyǎ arè̤́ yěnuôma, a lé̤héo ná tôcô꤮ to. Manárò ki a cuố byǎ angó̤ ná tè̤lǔ dố a o dố tè̤lǔrè̤́khu yěnuôma a bè htwǒhtya phú a hé nuô.’ ");
INSERT INTO kyu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kayǎ mèthèlè̌ thǐ꤮, tane̤ myámyá, bítě tôcô duklò̌, ma tè̤lǔ è̌? Tomaná tè̤lǔrè̤́ dố a dyé sǎsè̌ tè̤lǔ nuô è̌? ");
INSERT INTO kyu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Phúnuôrò kayǎ dố a byǎ angó̤ ná tè̤lǔrè̤́ akhè̌nuô, a byǎpa tố̤kuô̌ lò̌ hò́ ná lò̌꤮ tè̤ dố a o dố tè̤lǔrè̤́ alo̤ nuôtahe hò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Htuô̌rò kayǎ dố a byǎ angó̤ ná tè̤lǔhǒdu nuô, a byǎ nuô̌tố̤kuô̌ lò̌ hò́ ná Cò́marya dố a o dố tè̤lǔhǒdu akǔ yěnuô tôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kayǎ dố a byǎ angó̤ ná mò́khu nuô, a byǎ nuô̌tố̤kuô̌ lò̌ hò́ ná Cò́marya lé̤onyǎ ná prè̤ dố a onyǎ bí alo̤nuô tôprè̤hò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Prè̤ithyó tè̤thyótè̤thya athárá thǐ ná Pharisěophú thǐ꤮, Cò́marya ki cirya thǐ pǎ. Thǐ ma kayǎ dố a cyé̤zò́cò́te̤ ané̤ tahe. Thǐ me̤ phú Mosè a tè̤thyótè̤thya hénuô to. Thǐ myá talwókyǎ tè̤ dố a loduklò̌ tahe vǎ꤮. Thǐ me̤cò́tè̤to, thǐ thè́zò̤ní̤ ǔ to. Thǐ cò́ ná thǐngó̤ to. Thǐ ahóacǐ̤ tahe dố ǔ è́ ná mí, dilá ná kumí thǐ tahenuô, thǐ dyé ná pwíshyétôpwí tadû́rò bè ciryatè̤ cò́cò́te̤te̤, bè thè́zò̤ní̤ ǔ, bè ohtwǒprè̤ cò́ ná ngó̤ yětahe nuôma tè̤ dố a lodu rò thǐ tǒbè me̤pró̤ tố̤kuô̌ ná thǐ pwíshyétôpwí yěnuô. ");
INSERT INTO kyu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kayǎ mèthèkhí dố a thǔ pé̤ ǔ klyá thǐ꤮, thè́isě ná thǐ ǒnuô̌ ní̤tyá̤ lakǒ phò̌tháphú tôbè rò thǐ pryě̤kyǎ lǔ manárò thǐ píklǔ nuô̌ní̤ cò́ tathíbuô̌du tôduô̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Prè̤ithyó tè̤thyótè̤thya athárá ná Pharisěophú thǐ꤮, Cò́marya ki cirya thǐ pǎ. Thǐ ma kayǎ dố a cyé̤zò́cò́te̤ ané̤ tahe. Thǐ yětahe nuôma a thyácò́dû ná kayǎ dố a sǐplǐ bělò̤́dǐbě dố aklò̌ nuôtahe cò́ni, dố thǐ thè́plòkǔ nuô a o bǎtapí cò́ ná tè̤pṳ̂́phe zè́plè́phe ǔ ná lṳ̂me̤mo̤ ní̤dyédû thè́plò yěnuô tahe cò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pharisěophú dố a mèthèkhí thǐ꤮, sǐplǐkyǎ ré̤lố bělò̤́běkyá ná dǐbě dố akǔ nuôtahe. Thǐ ki me̤phúnuô tû́ma dố aklò̌nuô a plǐhyǎ kuô̌dû pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Prè̤ithyó tè̤thyótè̤thya athárá ná Pharisěophú thǐ꤮, Cò́marya ki cirya thǐ pǎ, thǐ ma kayǎ dố a cyé̤zò́cò́te̤ ané̤ tahe. Thǐ ma athyáná ǔ byá luô̤̌kǔ ná lò̤́ rò ǔ plò̤́bǔ è dố aklò̌ nuôtahe hò́. Aklò̌ rò abǔsútú twó̤lǎ tadû́rò dố akǔ rò a o shuô̌shuô̌ prè́ ná luô̤̌krwíluô̤̌krwó ná athò̌alò tahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Phúnuôhò́ dố aklò̌ rò ǔ myáhtye thǐ ná kayǎcò́kayǎte̤ ryálǎ tahe tadû́rò dố akǔ rò a o bǎtapí cò́ ná tè̤cyé̤zò́cò́te̤ né̤ ná tè̤thû́tè̤plá tahe cò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Prè̤ithyó tè̤thyótè̤thya athárá ná Pharisěophú thǐ꤮, Cò́marya ki cirya má̤lakǒ cò́ thǐ pǎ. Thǐ ma kayǎ dố a cyé̤zò́cò́te̤ ané̤ tahe. Thǐ byá pé̤ prè̤pro̤ mú꤮ nukhè̌ nuôtahe aluô̤̌kǔ ná lò̤́. Thǐ taritaryǎ twó̤ pé̤ kayǎcò́kayǎte̤ tahe aluô̤̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Htuô̌rò thǐ hé, ‘Pè̤ ki ohtwǒprè̤ tǒ bye dố phyěphuô̌ yětahe ahtû̌khè̌ hénuôma, pè̤ klyá onuô̌ tố̤kuô̌ nyǎ dố kayǎ dố a me̤thyě prè̤pro̤ nuôtahe aklè̌ to,’ thǐ hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Phúnuôrò thǐ dyéluô̌ lǐphó cò́hò́ thǐné̤ ná thǐ ma kayǎ dố aklwǐalyǎ hò́ ná a me̤thyě prè̤pro̤ nuôtahe cò́hò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Phúnuôrò tarú me̤ plehyǎ tadû pó̤ lahyǎ dû ní꤮. Me̤lốme̤bǎhtya lò̌ pé̤pó̤dû thǐphyěthǐphuô̌ a tè̤thû́tè̤plá nuôtahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Rṳ́mǔmyá̤ thǐ꤮, rṳ́thí aphúalye̤ thǐ꤮, Cò́marya kíré̤ ciryatǎ̤ thǐ dố ngarakǔ pǎnuô, thǐ cuố siplè́bè́ cyá̤ phútě? ");
INSERT INTO kyu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Phúnuôrò vǎ ki nò̌hyǎ pé̤ thǐ prè̤pro̤ tahe, prè̤thè́khuthè́gně tahe ná Thárá thǐtahe pǎ, tahehenuô thǐ ki mṳ̂̌thyěhtya èthǐ dố krusulo̤ pǎ, tahehenuô thǐ ki mṳ̂̌ lǔ ná iplírwí̤ dố tè̤cò́bè̌hǒkǔ pǎ rò thǐ ki cuốlě pṳ̂́ èthǐ tôvǐ̤ htuô̌ tôvǐ̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lò̌꤮ kayǎcò́kayǎte̤ dố ǔ me̤thyě èthǐ bí hekhu yětahe athwi, cáhtya bí Abělè athwi nuôrò, tuố̤hyǎ dố Barakia aphúprè̤khǔ Zekaria athwi dố ǔ me̤thyě lǔ bí tè̤lǔhǒdu ná tè̤lǔrè̤́ aplèkǔ yěnuô, Cò́marya dyahtyalò̌hò́ tè̤thû́ yětahenuô dố thǐkhu hò́. ");
INSERT INTO kyu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Vǎ hécò́cò́ thǐ꤮, tè̤ yětahenuô a ki lya̤bè lò̌ thǐ dố a ohtwǒprè̤ khǒnyá̤ yětôhtû̌ tahe akhu pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Kố꤮ vǐ̤ Jerusalem, vǐ̤ Jerusalem꤮ prè̤pro̤ dố ǔ nò̌hyǎ èthǐ dố nè̤o tahenuô, taheherò nè̤ me̤thyěkyǎ èthǐ, taheherò nè̤ tá̤ èthǐ ná lò̤́. Phú shyěmuố̤ takò́takè̤bí ní̤dyé aphú dố adálè̤̌ nuô, vǎ yácû́ takò́takè̤bíní̤ tamǒmǒ cò́ nè̤ tadû́rò nè̤ thè́zṳ̂́ nò̌takè̤bí ní̤ vǎ ná nè̤né̤ to. ");
INSERT INTO kyu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Myámò̌ lahyǎ꤮ Cò́marya ki dya-okryákyǎ tû́dû thǐ tè̤lǔhǒdu yěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rò vǎ hé thǐ, thǐ ki myáhtye pǎ vǎ tohò́, rò shyé꤮ thǐ héhò́, ‘Kayǎ dố a hyǎ dố Cò́marya amwi̤kǔ yětôprè̤nuô, a ki ní̤bè dûhò́ tè̤sò̌ri ní꤮.’ Thǐ héhtuô̌hò́ phúnuô pǎ rò thǐ ki myáhtye khyěthyá no vǎ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Bí Byacè Jesǔ htecuốkyǎ dố tè̤lǔhǒdu vǐ̤kǔ akhè̌nuô, a khǒpacè̤̌ tahe hyǎ dố lǔo rò a nò̌myá lǔ ná tè̤lǔhǒdu dố ǔ isò́htya lǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Rò a sudyǎ a khǒpacè̤̌ tahe, “Lò̌꤮ tè̤nuô tahe thǐ myáhtye lò̌ è̌? Vǎ héluô̌ cò́ pé̤ cò́ thǐ, lò̌꤮ yě tahenuô, ǔ ki hyǎ dòtǎ̤prò̤kyǎ lò̌ è pǎ. Lò̤́ yětahenuô a oícû̌ pǎ lǔ tômě꤮ to pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bí Byacè Jesǔ onyǎo dố Oliva sokhu akhè̌nuô, a khǒpacè̤̌ tahe hyǎophûkuô̌ tû́dû lǔ rò èthǐ hé lǔ, “Hésoluô̌ pé̤kuô̌myá pè̤ dố nè̤ hé pǎnu tahenuô, a ki htwǒhtya bíkhè̌tě pǎ? Nè̤ kíré̤ hyǎ bíkhè̌tě pǎ htuô̌rò hekhuyě ki tadûkyǎ bíkhè̌tě pǎnuô tè̤pro̤tè̤prya̤ amáadyǎ tôcôcô ki oluô̌htya ré̤ pǎ è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Byacè hésû èthǐ, “Rò̤ní̤ lahyǎ thǐné̤ ní꤮, nò̌ilolahǒ cuốní̤ tǎ ǔ ná thǐné̤ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Me̤těhérò kayǎ ki hyǎdákwó lahǒlya̤ ní̤dyé lahyǎ ané̤ ná vǎmwi̤ pǎ tahenuô a o è́lǎ pǎ, rò èthǐ ki dákwó lahǒ lya̤ ní̤dyé lahyǎ ané̤, ‘Vǎ ma Krístu’ rò èthǐ ki ilolahǒ è́lǎ ǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Thǐ ki ní̤huô̌ tè̤sátè̤pǎ̤ dố a htwǒhtya khǒnyá̤ yěnuôtahe pǎ, htuô̌to thǐ ki ní̤huô̌htǒ ní̤huô̌lya̤ ná ǔ kisákipǎ̤ lǔ pǎ tadû́rò thè́isě bèzò̤bèthi tǎ lahyǎ tǎmé̤ ní꤮. Phúyě tahe nuôma a bè htwǒhtya nyǎ pǎ, manárò yěnuôma hekhu kíré̤ tadû hò́nuô má̤híto. ");
INSERT INTO kyu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Me̤těhérò myěcô tôcô ná tôcô, htyěké̤ tôké̤ ná tôké̤ kisákipǎ̤ lǔ pǎ. Ké̤vǐ̤ké̤kò̌ ná tanéhtò́dǐ tahe ki ohtyahtǒohtyalya̤ lò̌plǐ dố hekhuyě tôpho htuô̌ tôpho pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lò̌꤮ tè̤htwǒhtya yětahe nuôma má̤pǎprè́ tè̤cyě̤tè̤cṳ̂ a khǎshyékhǎrya̤ dố athyáná prè̤mò kíré̤ phúo hò́sè̌ mópǎ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Htuô̌rò ǔ kipṳ̂́kicò̌ lò̌ thǐ pǎ, ǔ kimṳ̂̌kipò̤ lò̌ thǐ pǎ htuô̌to ǔ ki me̤thyě thǐ pǎ. Dố thǐ cò́ ná vǎ akhu-akhyěrò kayǎ pwǒ̤꤮ tôprè̤ ki thè́hte lò̌ thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bínuôkhè̌ pǎ kayǎ ki vǐkyǎ è́lǎ a tè̤zṳ̂́tè̤nyá̤ pǎ. A ki isè̌e lǔmwi̤ tôprè̤ ná tôprè̤ pǎ. A ki thè́hte ní̤dyé lò̌ lǔ tôprè̤ ná tôprè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Htuô̌to prè̤pro̤ klwolahǒ ané̤ tahe ki oluô̌htya è́lǎ pǎ rò a ki ilolahǒ è́lǎ ǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tè̤mǔmyá̤ricyá̤ ohtyaè́ akhu-akhyě, tè̤mo̤ní̤ lǔ tôprè̤ ná tôprè̤ ki sǐmé̤ hyǎ ná hyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Manárò kayǎ dố a ihtòtanyǎ oklò̤sò́ma dố a tè̤zṳ̂́tè̤nyá̤ akǔ tuố̤dố atadû tahenuô Cò́marya ki me̤lwóhteka̤ èthǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Htuô̌rò mò́khu ahtyěké̤ a tè̤thè́krṳ̂̌mila yěnuô, ǔ ki hésodônyǎ ní̤huô̌ pé̤lò̌ kayǎ o dố hekhuyě tôba lò̌ pǎ, htyěké̤ pwǒ̤tôké̤ ki ní̤huô̌nò́ lò̌htuô̌hò́ tè̤khyáthè́yě pǎ tû́ma hekhuyě ki tadûkyǎ no prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Thǐ ki myáhtye ǔ ihtòo dố tè̤sǎsè̌ akhǎlé̤ pǎ. Tè̤thè́zò̤́thè́ryǎ̤ ki me̤ taprómǔmyá̤ lò̌ Cò́marya tè̤lǔhǒdu pǎ. Prè̤pro̤ Danielè rǎ tè̤thè́zò̤́thè́ryǎ̤ yě ari-akyǎ. Nò̌ thè́gněplǒ lahyǎ kayǎ dố a hố li thǐtahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Htuô̌rò bí thǐ myáhtyehò́ tè̤htwǒhtya phúyě hò́ pǎ akhè̌nuô, kayǎ dố a o dố Juda ké̤kǔ tahe bè klyahtya lahyǎ dố sokhunuô. ");
INSERT INTO kyu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kayǎ ki o dố hikhuklwó tabyekhu tôprè̤prè̤ nuô nò̌klyatǎ̤ phyéní̤ tǎ a tǎ̤muô̌tǎ̤tè̤ dố hikǔ nuôtahe tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kayǎ o dố lyá̤khu tahenuô nò̌ka̤ phyéní̤ tǎ aca̤klò̌ tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bínuôkhè̌pǎ nuô a ki sǒrya̤sǒphá pé̤ nyacò́ prè̤mò dố a o ná ahò́athè́ tahe agně ná aphú ǒnú pǎlǔ nuôtahe agně pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Thǐ bè hteklya ashuốakhè̌ yěnuô, thyáphú a ki tǎ̤tǒ tǎ ná ké̤ró̤khè̌ tǎmé̤ tomaná Judaphú a Mò̤́nyěduô tǎmé̤nuô, kwǐcò́bè̌ lahyǎ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bínuôkhè̌pǎ tè̤pyá̤tè̤sè̌ ná tè̤cyě̤tè̤cṳ̂ tahe ki ohtya pǎ. Dố hekhu htwǒhtyalú pǎ tuố̤khǒnyá̤ yěnuô cò́ bèbè, dốnodốkhyě pǎ bèbè, tè̤pyá̤tè̤sè̌, tè̤cyě̤tè̤cṳ̂ dố myáhtyenò́ takhyá꤮ to tahenuô, a ki ohtya pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cò́marya ki me̤phuô pé̤ tè̤cyě̤tè̤cṳ̂ yě ashuốakhè̌ to hénuô, kayǎ ohtwǒprè̤bè́ tôprè̤ to. Manárò Cò́marya yǒ myá kayǎ dố a nwóhtya yětahe amèthè akhu-akhyě, a ki me̤phuôhyǎ ashuốakhè̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Bínuôakhè̌pǎ nuô, kayǎ tôprè̤prè̤ ki hé, ‘Nè̤ hyǎ myámò̌, Krístu obíyě,’ tomaná ‘A o dốnuô,’ a ki hé thǐ phúnuô pǎ tadû́rò zṳ̂́e tǎ lahyǎ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Me̤těhérò prè̤klwo lahǒ phú Krístunuô ná prè̤klwo lahǒ phú prè̤pro̤ thǐ tahenuô a ki ohtya è́lǎ pǎ. Èthǐ ki me̤luô̌ cyá̤ pé̤ ǔ tè̤ dố a htetapa̤ cò́ ǔ nuôtahe ná tè̤pro̤tè̤prya̤ tahe pǎ. A ki me̤cyá̤ hénuôma a thè́zṳ̂́ ilolahǒ ní̤ cò́ kayǎ dố Cò́marya nwóphyé htuô̌hò́ lǔ nuô tahecò́. ");
INSERT INTO kyu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tè̤me̤-ané̤ yětahe hyǎtuố̤ tyahíto akhè̌nuô, vǎ dyérò̤dyéryě̤ one pé̤ hò́ thǐ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Phúnuôrò kayǎ tôprè̤prè̤ ki hé thǐ, ‘Cuốmyá lahyǎ mò̌lé, Messia odố lò̤́tamámû nyekhu nuô,’ a ki hé thǐ tadû́rò cuốmyá lahyǎ tǎmé̤ ní꤮. Tomaná a ki hé thǐ, ‘A o bí hidò́kǔ yě prè́,’ a ki hé tadû́rò zṳ̂́e tǎmé̤mé̤. ");
INSERT INTO kyu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Me̤těhérò phú shyeli̤bò́ takhè̌htya dố ké̤cíhte rò kayǎ o dố ké̤cínuô̌ tahe myáhtyenuô, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎ pǎ ma a thyá phúnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tè̤thò̌tè̤lò̤ obítě꤮ ma latya ihíplò́ bínuô.” ");
INSERT INTO kyu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bí tè̤cyě̤tè̤cṳ̂, tè̤pyá̤tè̤sè̌ ashuốakhè̌ ohtwǒhtya talwó htuô̌hò́ pǎnuô, tôphuốtuô̌ ‘Cò́marya ki me̤khíkyǎ tamò̤́ pǎ. Lè̌ ki lǐ pǎtohò́. Sè dố mò́lè̤̌ tahe ki latǎ̤prò̤kyǎ lò̌pǎ. Cò́marya ki me̤ kazikazuô̤̌ lò̌lò̌꤮ mò́lè̤̌ a tè̤pro̤tè̤prya̤ nuôtahe pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Bínuôakhè̌ pǎnuô, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě atè̤hyǎ amáadyǎ ki oluô̌htya dố mò́lè̤̌ pǎ. Htuô̌rò lò̌꤮ kayǎ o dố ké̤ pwǒ̤tôké̤ tahe kinguố̤kihè lò̌ pǎ. Èthǐ ki myáhtye lahyǎ prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě a ki sidyáhyǎní̤ ò́luố̤ dố mò́lè̤̌ pǎ rò a ki olốbǎ cò́ ná a tè̤pro̤tè̤prya̤ ná a tè̤taryědu taryěhtǔ dố ashyo-asò̌ yěnuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ǔ ki uố pra̤shyohtya kwo̤ pǎ. Rò kayǎ dố Byacè nwóhtya htuô̌hò́ èthǐ rò a o lahyǎ dố hekhu lwǐ̤kyělwǐ̤ná̤, cáhtya dố mò́dá khǎshyé tuố̤dố mò́dá tadû pwǒ̤꤮ tôprè̤nuô, Cò́marya ki nò̌hyǎlya̤ tanéphú tahe pǎ rò a ki hyǎè́oplò́ tố̤lò̌ èthǐ lò̌꤮ plǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Khǒnyá̤rò phyéní̤ lahyǎ tè̤ithyó tôcô dố kadwímò̤́ alo̤ yěnuô. A dǎ lè dyácè̤́ tamahtehò́, alè bèhò́ hérò thǐ thè́gně ná ké̤kṳ́khè̌ phûhyǎ tuố̤hò́. ");
INSERT INTO kyu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Phúnuôhò́ bí thǐ myáhtyehò́ lò̌꤮ tè̤yě tahe htwǒhtyahò́ akhè̌pǎnuô, thè́gně lahyǎ ná prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě a hyǎphûtuố̤hò́ dố kadǎkǔhtû̌ hò́ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Vǎ héluô̌ cò́cò́꤮ pé̤ cò́ thǐ, lò̌꤮ kayǎ dố a ohtwǒprè̤ khǒnyá̤yětôhtû̌ tahe thyělò̌ tyahíto nuô, tè̤yětahe ki htwǒhtya lò̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mò́khu ná hekhu ki sǐmé̤kyǎ pǎ tadû́rò vǎlǎ̤vǎngó̤ yětahenuô a sǐmé̤kyǎ pé̤ takhyá꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Manárò tè̤yětahe ki htwǒhtya mò̤́nyěmò̤́thè̌, ashuốakhè̌ bíkhè̌tě pǎnuô ǔ thè́gně tôprè̤꤮ to. Tanéphú o dố mò́khu nuôtahe cò́ bèbè a thè́gně to. Aphúkhǔ ná ané̤ yětôprè̤ cò́꤮ bèbè, a thè́gně toto. A thè́gně prè́tû́ vǎphè̌ tôprè̤꤮ tuô̌prè́. ");
INSERT INTO kyu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Phú a htwǒhtya dố Noah htû̌khè̌nuô, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎpǎ akhè̌nuô, a ki htwǒhtya thyákuô̌dû phúnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Me̤těhérò bí htyědubí tyahíto akhè̌nuô, ǔeǔǒ, ka̤sǒmè̤̌sǒdya lǔ tuố̤ cò́ bí Noah nuô̌ dố thòklyědukǔ nuôtônyě cò́. ");
INSERT INTO kyu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tè̤ kíré̤ htwǒhtya phúyě pǎnuô, tuố̤ cò́ bí htyěhyǎ dubí thyěkyǎ lò̌ cò́hò́ èthǐ akhè̌ cò́ nuô꤮, a thè́gněhí lahyǎ tôcô꤮ to. Shyé꤮ prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě kíré̤ hyǎhò́ pǎ akhè̌nuô, a ki htwǒhtya thyákuô̌dû phúyěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bínuôkhè̌pǎ, prè̤khǔ thè́nyě̤ dố a rya̤ ró̤lǔ tè̤ dố lyá̤khu nuô, tôprè̤ rò ǔ ki è́ka̤kyǎ lǔ pǎ, tôprè̤ rò a ki okyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Prè̤mò isátṳ̂̌sû lǔ buốkǔlǎ thè́nyě̤nuô, Cò́marya ki è́ka̤kyǎ è tôprè̤ pǎ. Tôprè̤rò a ki dya-okyǎ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Me̤phúnuôrò othǎklyǎ lahyǎ, me̤těhérò thǐbyacè ki hyǎ bítě tônyě pǎ nuô thǐ thè́gně to. ");
INSERT INTO kyu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Manárò thè́né̤ lahyǎ, hibyacè ki thè́gně ná prè̤ehuô kíré̤ hyǎ bítě tôthè̌tě pǎ hénuô, a ki opò̤́sû pǎ rò prè̤ehuô hyǎnuô̌ ehuôcyá̤to. ");
INSERT INTO kyu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Phúnuô akhu-akhyě, thǐ yětahenuô bèbè, otaritaryǎ one kuô̌ lahyǎ thǐné̤ ní꤮, me̤těhérò shuốkhè̌ bí thǐ tane̤tuố̤ to pǎnuô, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Prè̤me̤tè̤phú dố acò́ rò a plǒphè́ tôprè̤ma ǔpě? Prè̤me̤tè̤phú dố acò́ tôprè̤ mamá̤hò́ abyacè dyétǎ̤ lǔ tè̤me̤ dố a bè myákhwè buôebuôǒní̤ prè̤me̤tè̤phú dố aruô tahe dố lǔ takhukǔ rò a buôe tǒshuốtǒkhè̌ èthǐ yětôprè̤nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Abyacè ki ka̤myáhtye ná a prè̤me̤tè̤phú yětôprè̤ me̤ tè̤me̤ kihérò a ki dyé lǔ tè̤me̤ní̤khwókè pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Vǎ hécò́cò́꤮ cò́ thǐ, Byacè yětôprè̤ a tǎ̤muô̌tǎ̤tè̤ lò̌꤮ plǐnuô a ki dyétǎ̤lò̌ dố lǔ khadǎkǔ pǎ rò a ki nò̌myánò̌khwè ní̤ ná lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Manárò hékuốré̤ prè̤me̤tè̤phú dố acyě̤ tôprè̤nuô, a ki tane̤, ‘Vǎbyacè ka̤khyě lè̤́pryǎ ná híto,’ a tane̤ rò, ");
INSERT INTO kyu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","a kimṳ̂̌kipò̤, pé̤epé̤ǒ prè̤me̤tè̤phú dố aruô tahe pǎ, rò a ki emṳ̂ǒpryá tố̤ná kayǎ lé̤klǒ emṳ̂ǒmṳ̂ tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Rò shuốkhè̌ bí a tane̤ tuố̤to rò a eǒsǒtapa̤ tônyěnuô, abyacè ki ka̤khyětǒ bínuô tônyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Abyacè ki ciryacyě̤ ciryacṳ̂ lǔ pǎ rò a ki dyanuô̌ tố̤kyǎ lǔ ná bí kayǎ cyé̤zò́cò́te̤ ané̤ nuôtahe lé̤o akhǎlé̤ nuô pǎ. Khǎlé̤ bínuô tôphonuô ǔ kinguố̤kihè, ǔ ki a̤ takrǐtakrṳ̂ cò́ ǔkhukhyě cò́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Mò́khu htyělé̤ké̤kǔ nuô, athyáná prè̤mò krwǒkruô̌ ǔ aprè̤shyé phyéní̤ mikò̌ rò cuốopò̤́ myásû̌ khǒmè̤̌ prè̤khǔ hyǎ ari-akyǎ yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nyǎ̤prè̤ rò a plǒphè́, nyǎ̤prè̤ rò a plǒphè́ kuô̌ǔ to. ");
INSERT INTO kyu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Prè̤mò dố a plǒphè́ kuô̌ǔ to yěthè́nyǎ̤ nuô, a phyéhyǎ ní̤kuô̌ amikò̌ tadû́rò a phyéhyǎ ní̤lố kuô̌pó̤ mihtyě to. ");
INSERT INTO kyu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Manárò prè̤mò dố a plǒphè́ yěthè́nyǎ̤ nuô a phyéhyǎní̤ amikò̌ rò a phyéhyǎní̤lố pó̤ mihtyě ná pyǎ̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Khǒmè̤̌prè̤khǔ hyǎtuố̤ pyá̤zè̤́pyá̤sè̌ akhu-akhyě èthǐ omyěkhǎmyěnuô htuô̌rò a omyění̤ lò̌ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Bí mò̤́ne̤khè̌ nuô, ǔ è́htǒ, ‘Kố꤮ khǒmè̤̌prè̤khǔ hyǎhò́, htecuố myásû mò̌ lahyǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Rò prè̤mò dố a krwǒkruô̌ ǔ yělò̌꤮ plǐ ihtò rò taritaryǎ lahyǎ ami pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Prè̤mò plǒphè́ kuô̌ǔ to tahe hé prè̤mò plǒphè́ tahe, ‘Dyékuô̌ pè̤ thǐmihtyě, pè̤mi kíré̤ pǐ̤hò́.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Manárò èthǐ hésû, ‘Tokǒle, a pòpé̤ tuố̤kuô̌ pǎ thǐgně to, aryálố ma thǐ cuốipri̤ ní̤dyé khòdû thǐgně dố ǔ lé̤isè̌ mihtyě khǎlé̤nuô.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Bí èthǐ cuốpǎprè́ dố klyálo̤ akhè̌nuô, khǒmè̤̌prè̤khǔ hyǎtuố̤ lè́hò́, prè̤mò plǒphè́ dố a o taritaryǎ ané̤ tahe hyǎnuô̌ tố̤kuô̌ ná khǒmè̤̌prè̤khǔ dố ka̤sǒmè̤̌sǒdya a tè̤etè̤ǒ khǎlé̤ rò ǔ me̤bíkyǎ kadǎ. ");
INSERT INTO kyu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Dốkhyě rò prè̤mò dố a plǒphè́ kuô̌ǔ to yětahe ka̤tuố̤ rò a hé lahyǎ, ‘Byacè, Byacè, bámǒ pé̤kuô̌ ré̤ pè̤ kadǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Tadû́rò khǒmè̤̌ prè̤khǔ hésû èthǐ, ‘Vǎ hélakǒ cò́ thǐ, vǎ thè́gněnò́ thǐ to.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Phúnuôrò othǎklyǎ lahyǎ, me̤těhérò mò̤́nyěmò̤́thè̌ dố prè̤lu aphúkhǔ yě ki hyǎkhyěthyá bíkhè̌tě pǎnuô thǐ thè́gněcyá̤to. ");
INSERT INTO kyu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Mò́khu htyělé̤ké̤kǔ nuô a thyá kuô̌pó̤dû ná kayǎ tôprè̤ dố a kíré̤ htecuố klyá rò è́plò́ a prè̤me̤tè̤phú tahe, rò a dyékyǎ a tè̤duzá̤htyathè̌ tahe dố a prè̤me̤tè̤phú tahe a takhukǔ. ");
INSERT INTO kyu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tôprè̤ rò a dyékyǎ lǔ htè̌ nyǎ̤cwè̤́, tôprè̤pó̤ rò tôko, dố aruôtôprè̤ kuô̌ke rò tôcwè̤́, phú èthǐ oná a tè̤cyá̤tè̤dè nuô a ibě pé̤ èthǐ htuô̌rò a htecuốkyǎ klyá. ");
INSERT INTO kyu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kayǎ dố a ní̤bè htè̌ nyǎ̤cwè̤́ yětôprè̤nuô, a ní̤bè hò́hò́ ná a htecuố me̤kuố̤ rò a cuố me̤ní̤hte è́lốpó̤ nyǎ̤cwè̤́. ");
INSERT INTO kyu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Phúnuôrò a ní̤bè htè̌ tôko yětôprè̤nuô, a cuố me̤kuố̤hte è́htyalố pó̤ nyě̤cwè̤́. ");
INSERT INTO kyu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Manárò dố a ní̤bè htè̌ tôcwè̤́ yětôprè̤nuô, a htecuố rò a cuố ivè̤̌ hekǔ tôkǔ rò a cuố iplû̌ uốbíkyǎ abyacè htè̌yě dố helè̤̌. ");
INSERT INTO kyu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mò̤́nyěmò̤́thè̌ nyě̤hyǎhò́ rò èthǐ Byacè ka̤tuố̤ rò a ka̤sudyǎ plǒkhyě htè̌ dố a dyékyǎ èthǐ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kayǎ dố a ní̤bè htè̌ nyǎ̤cwè̤́ yětôprè̤nuô, a phyéhyǎ è́htyapó̤ nyǎ̤cwè̤́ rò a hé abyacè, ‘Byacè, nè̤ dyékyǎ vǎ htè̌arǎ nyǎ̤cwè̤́. Rò yělé, vǎ me̤htení̤ è́lốpó̤ hò́ nyǎ̤cwè̤́ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Abyacè hésû lǔ, ‘Ò, aryá nyacò́, nè̤ ma prè̤me̤tè̤phú dố aryá rò acò́ ná vǎ, nè̤ cò́ ná vǎ dyé nè̤ tè̤patíphú yětahe akhu-akhyě, vǎ ki dyé è́htya lố꤮ klò̌pó̤ nè̤ tè̤me̤ dố nè̤ ki pốtarí è́lốklò̌ pó̤ ná yěnuô pǎ. Hyǎ thè́krṳ̂̌thè́lò̌ ró̤kuô̌dû ná vǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kayǎ dố a ní̤bè htè̌ tôko yětôprè̤nuô, a phyéhyǎ è́htyapó̤ tôko rò a hé abyacè, ‘Byacè, nè̤ dyé vǎ htè̌ arǎ tôko, rò yělé, vǎ me̤ htení̤ è́lốpó̤ hò́ tôko hò́.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Rò abyacè hésû lǔ, ‘Ò, aryá nyacò́. Nè̤ ma prè̤me̤tè̤phú dố aryá rò acò́ ná vǎ. Nè̤ cò́ ná tè̤ dố vǎ dyé nè̤ patíphú yětahe akhu-akhyě vǎ ki dyé è́htya lố꤮ klò̌pó̤ nè̤ tè̤me̤ dố nè̤ ki pốtarí è́lố klò̌pó̤ ná yěnuô pǎ. Hyǎ thè́krṳ̂̌thè́lò̌ ró̤kuô̌mò̌ ná vǎ!’ ");
INSERT INTO kyu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Yětôphuốrò kayǎ dố a ní̤bè htè̌ tôcwè̤́ yětôprè̤nuô a hyǎhé abyacè, ‘Byacè, vǎ thè́gně ná nè̤ ma kayǎ dố apyá̤ nyacò́ tôprè̤. Buố dố nè̤ isò́ kuô̌ǔ to tahenuô nè̤ cuố kè́ka̤ dûgně, buố dố nè̤ iluố̤ kuô̌ǔ to tahenuô nè̤ cuốpò̤ka̤plò́ dûgně. ");
INSERT INTO kyu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Phúnuô akhu-akhyě vǎ thè́isě rò vǎ cuố iplû̌ uốkyǎ nè̤htè̌ yětôcwè̤́ dố helè̤̌, myámò̌, yělé꤮ htè̌ dố nè̤ dyékyǎ vǎ nuô.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Rò abyacè héka̤khyěsû lǔ, ‘Kayǎcyě̤ kayǎcṳ̂, kayǎtaklě kayǎlěbyá, nè̤ thè́gně ná buố dố vǎ isò́ má̤to tahenuô, vǎ cuố kè́ka̤ dûgně, buố dố vǎ iluố̤ má̤to tahenuô vǎ cuố pò̤ka̤plò́ dûgně vǎhé? ");
INSERT INTO kyu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nè̤ ki thè́gně phúnuôrò nè̤ dyébòkyǎ vǎ htè̌yě dố prè̤ phyébòphyéló̤ htè̌tahe a takhukǔ to me̤tě? Nè̤ ki me̤phúnuô hérò shyé꤮ vǎ ka̤khyě pǎnuô vǎ ki ní̤bè ka̤khyě aphúphú amuố̤muố̤ pǎ kǒkǒ. ");
INSERT INTO kyu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Phyé ka̤khyědwó khyěthyá htè̌nuô tôcwè̤́ rò dyé ná kayǎ dố a ní̤bè acwè̤́shyé yěnuô tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Me̤těhérò lò̌꤮ kayǎ dố ǔ zṳ̂́ení̤ lǔ rò ǔ dya-oní̤ tǎ̤tè̤ dố lǔo tahenuô, ǔ ki dyéè́htya lố꤮ pó̤ lǔ pǎ. Rò atè̤ ki o tǎ̤pòtǎ̤pè̤̌ cò́ pǎ. Manárò kayǎ dố ǔ dya-o tǎ̤tè̤ patíphúprè́ dố lǔlo̤ rò ǔ zṳ̂́ení̤ lǔ to tahenuô, ǔ ki phyéka̤khyě lò̌phe khyěthyá èthǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tá̤htekyǎ prè̤me̤tè̤phú olốoklò̌ yětôprè̤ dố tè̤khítè̤lò̤ aklè̌ nuô. Bínuôtôphonuô ǔ ki cuốnguố̤cuốhè, ǔ ki a̤ takrǐtakrṳ̂ cò́ ǔkhukhyě pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Shyé꤮ prè̤lu aphúkhǔyě ki hyǎ ná alǐatakhè̌ pǎ rò amò́khu tanéphú tahe ki hyǎ tố̤kuô̌ ná lǔ akhè̌pǎnuô a ki onyǎo dố a khuklyáhtyalô̌ takhè̌ akhu pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Myěcô lò̌꤮ plǐ nuô a ki hyǎ oplò́lò̌ dố lǔnyěhyǎ pǎ rò phú prè̤kyě̤thímíphú iběkhó ní̤dyé athímí tahe ná pé̤ tahenuô, a ki ibě khólò̌ kayǎ yětahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A ki dyakhó thímí tahe dố atakhu cò́htwó tôkyě pǎ rò pé̤ tahenuô a ki dya khó dố atakhu cò́ci tôkyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Bínuôakhè̌ pǎnuô, khwí yětôprè̤ ki hé kayǎ dố atakhu cò́htwó yětahe pǎ, ‘Hyǎmò̌ lahyǎ, thǐ ma kayǎ dố a ní̤bè vǎphè̌ a tè̤sò̌ri tahe, hyǎnuô̌ phyédwó lahyǎ mò́khu htyělé̤ké̤kǔ dố a má̤hò́ nè̤ ucè̌tazè̌ dố ǔ taritaryǎ one pé̤ thǐ dố mò́khu htwǒlú hekhu htwǒthè̌pǎ akhè̌yě nuô. ");
INSERT INTO kyu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Me̤těhérò bí vǎ thè́vǐ̤thè́e akhè̌ thǐ dyéedyéǒ vǎ, bí vǎ thè́ǒhtyě akhè̌ thǐ dyéǒ vǎ, bí vǎ cuốhtwǒ sǐpré̤ akhè̌ thǐ è́omyě mo̤sû vǎ. ");
INSERT INTO kyu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bí vǎ oryá̤ lé̤kû̌lé̤thyá akhè̌, thǐ dyékû̌dyéthyá vǎ, bí vǎswívǎsè̌ akhè̌, thǐmyáthǐkhwè ní̤dyé vǎ. Bí ǔ dò́tǎ̤ vǎ dố htò̌kǔ akhè̌nuô, thǐ hyǎ olě kuô̌ vǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Rò kayǎcò́kayǎte̤ yětahe ki hésû è, ‘Byacè, pè̤ cuốmyáhtyenò́ nè̤ thè́vǐ̤thè́e rò pè̤ cuố dyéenò́ nè̤ bò́khè̌tě? Nè̤ thè́ǒhtyě rò pè̤ cuố dyéǒnò́ nè̤ bò́khè̌tětě? ");
INSERT INTO kyu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nè̤ htwǒ sǐpré̤ rò pè̤ cuố è́sûnò́ nè̤, tomaná nè̤ oryá̤ lé̤kû̌lé̤thyá rò pè̤ cuố dyékû̌dyéthyánò́ nè̤ bò́khè̌tětě? ");
INSERT INTO kyu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bí nè̤ oswíosè̌ akhè̌nuô bèbè, bí ǔ dò́tǎ̤ nè̤ dố htò̌kǔ akhè̌ nuôbèbè pè̤ cuố hyǎ olěnò́ kuô̌ nè̤ bò́khè̌tě?’ ");
INSERT INTO kyu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Khwí yětôprè̤ ki hésû èthǐ, ‘Vǎ hélakǒ cò́ thǐ, dố vǎ puố̤vyá̤ tahe aklè̌, thǐ me̤cwó̤nò́ kayǎ dố ǔ tane̤ patílố lǔ tôprè̤ nuôma má̤hò́ thǐ me̤cwó̤ vǎ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Htuô̌rò a ki héke kayǎ o dố atakhu cò́ci tahe, ‘Htecuố taphǎkyǎ ná vǎ, thǐ ma kayǎ dố a ní̤bè tè̤sò̌hǎ tahe, cuốnuô̌ kuô̌ lahyǎ dố ǔ taritaryǎ one pé̤ khǐnéricyá̤ khuklò́ nuôtôduô̌ ná a khǐnékhǐnò̌ nuôtahe agně dố èthǐ ki cuốo bí mi dố a pǐ̤pé̤ tôphuố꤮ to nuôtôphè akǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Me̤těhérò bí vǎ thè́ethè́ǒ akhè̌, thǐ dyéedyéǒ vǎ to. ");
INSERT INTO kyu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bí vǎ htwǒ sǐpré̤ akhè̌, thǐ è́sû vǎ to. Bí vǎ oryá̤ lé̤kû̌lé̤thyá akhè̌, thǐ dyékû̌dyéthyá vǎ to. Bí vǎswívǎsè̌ akhè̌, htuô̌to bí ǔ dò́o vǎ dố htò̌kǔ akhè̌, thǐ hyǎmyáhyǎkhwè vǎ to.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Rò èthǐ ki hésû lǔ, ‘Byacè, nè̤ thè́vǐ̤thè́e bèbè, nè̤ thè́ǒhtyě akhè̌ bèbè, nè̤ cuố htwǒ sǐpré̤ akhè̌ bèbè, nè̤ oryá̤kû̌ oryá̤thyá akhè̌ bèbè, nè̤swínè̤sè̌ akhè̌ bèbè, ǔ dò́tǎ̤ nè̤ dố htò̌kǔ akhè̌ bèbè, pè̤ cuốmyáhtye nè̤ rò pè̤ me̤cwó̤ nè̤ to bò́khè̌tě?’ ");
INSERT INTO kyu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Rò a ki hésû èthǐ, ‘Vǎ hélakǒ cò́ thǐ, dố vǎ puố̤vyá̤ tahe aklè̌, thǐ ki me̤cwó̤nò́ kuô̌ǔ kayǎ dố ǔ tane̤ patílố lǔ nuôtôprè̤꤮ to hénuôma má̤hò́ thǐ me̤cwó̤ vǎ to hò́.’ ");
INSERT INTO kyu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Phúnuôrò èthǐ ki khyábè tè̤cirya tacṳ́prè̤ talèkrè́ pǎ, manárò kayǎ cò́ yětahenuô a ki cuố nuô̌ní̤ dố mò́khu rò a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bí Byacè hésoluô̌ pé̤ lò̌ htuô̌hò́ yětahe akhè̌nuô, a hé a khǒpacè̤̌ tahe, ");
INSERT INTO kyu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Thǐ thè́gněhò́, alopǎ nyě̤nyě ma pwè̌ dố ǔ è́ ná tè̤cuốtalwópwè̌ hyǎtuố̤hò́. Ǔ ki isè̌tǎ̤kyǎ prè̤lukayǎ aphúkhǔyě pǎ rò ǔ ki mṳ̂̌thyěhtyakyǎ lǔ dố krusulo̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Bínuôakhè̌nuô, bwídukhu tahe ná Judaphú tè̤cò́bucò́bè̌ khuklò́khuklyǎ tahe oplò́lò̌ lǔ dố bwídukhulố Caipha ahǒkǔ. ");
INSERT INTO kyu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Èthǐ taritaryǎ one lò̌ hò́ ná a ki pṳ̂́me̤thyě huôkyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Manárò èthǐ hé ní̤dyélǔ, “Bí pè̤ me̤pwè̌ akhè̌yěnuô pè̤ tǒ pṳ̂́ní̤ lǔ to, pǎma kayǎ bè́mṳ tahe thè́plòdu rò a me̤tarû̌tapyǎ lò̌he.” ");
INSERT INTO kyu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bí Byacè Jesǔ o dố dò̌ Bethania Simonè dố tè̤sè̌mǔmyá̤ dố phálo̤ bènò́ lǔ nuôtôprè̤ ahikǔ rò a edǐ akhè̌nuô, ");
INSERT INTO kyu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","prè̤mò tôprè̤ hyǎ dố lǔo rò a phyéhyǎní̤ pyǎ̤ dố ǔ me̤ è ná lò̤́bǔ dố a obǎ ná htyěnuô̤mû́ ngṳdupri̤du yětôpyǎ̤ rò a hyǎlyátǎ̤ dố Byacè Jesǔ a khuklò́lo̤. ");
INSERT INTO kyu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bí a khǒpacè̤̌ tahe myáhtye akhè̌nuô, a thè́plòdu rò a sudyǎ lǔ, “Cuốme̤lò̌ kyǎdě me̤tě? ");
INSERT INTO kyu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ki isè̌ htyěnuô̤mû́ yěnuô héma a ní̤ ngṳdupri̤du nyacò́ rò a ní̤ rû̌ yěnuô dyékuô̌ ná kayǎ sǒphásǒrya̤phú nuô kǒkǒ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Byacè Jesǔ thè́gně akhu-akhyě, a hé èthǐ, “Thǐ cuố me̤dídyǎ prè̤mò yětôprè̤ me̤tě? A me̤tè̤yě nuôma aryá nyacò́ dố vǎgně hò́. ");
INSERT INTO kyu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kayǎ sǒphásǒrya̤phú tahe otố̤kuô̌ ná thǐ pwǒ̤꤮ tôphuố cò́, manárò vǎyěnuô vǎ otố̤lǎ kuô̌ ná thǐ to. ");
INSERT INTO kyu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bí a lyátǎ̤ htyěnuô̤mû́ yě dố vǎ né̤lo̤ akhè̌ yěnuôma, má̤hò́ a tari one pé̤hò́ vǎ dố ǔ ki iluốtǎ̤ vǎ dố luô̤̌kǔ pǎ nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Vǎ hécò́꤮ cò́ thǐ, shyé꤮ ǔ lě hésodônyǎ hò́ tè̤thè́krṳ̂̌mila yě dố hekhu yětôba bítě꤮ tôpho pǎ bèbè, ǔ ki tane̤htya tuố̤bèní̤ è pǎ rò ǔ ki dyáluô̌ní̤ tè̤ dố a me̤htuô̌hò́ yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dố Byacè Jesǔ a khǒpacè̤̌ shyéthè́nyě̤ aklè̌ amwi̤ ná Juda Iscariot héyětôprè̤nuô, a cuố dố bwídukhu tahe a o. ");
INSERT INTO kyu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Rò a cuố sudyǎ èthǐ, “Vǎ ki dyétǎ̤kyǎ Jesǔ dố thǐ takhukǔ hérò thǐ dyé vǎ bátě?” Rò èthǐ dyé lǔ rû̌zye thakha. ");
INSERT INTO kyu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cáhtya bínuô rò Juda htû́myá shuốkhè̌ dố a ki tǎ̤tǒtǎ̤bè dố a ki isè̌tǎ̤kyǎní̤ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bí pwè̌ e khò́mǔ sǒdǒ huô̌mûtapho aré̤lố tônyě nuô, a khǒpacè̤̌ tahe hyǎ dố Jesǔ a o rò a hyǎsudyǎ lǔ, “Tè̤cuốtalwópwè̌ sèesǎsè̌ mò̤́hé yěnuô, nè̤ thè́zṳ̂́ nò̌taritaryǎ tǒ pè̤ bítě tôphotě?” ");
INSERT INTO kyu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Rò a hésû èthǐ, “Cuốnuô̌ dố vǐ̤kǔ nuôrò cuố dố prè̤khǔ nuôtôprè̤ a o nuô rò cuố hé lǔ, ‘Thárá hé, shuốkhè̌ phûhò́ dố vǎgně hò́, rò vǎ bèebèǒ tố̤ tè̤cuốtalwópwè̌ sèesǎsè̌ mò̤́hé ná vǎ khǒpacè̤̌ dố nè̤hikǔ’ hé è phúnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Rò a khǒpacè̤̌ tahe me̤phú a hé èthǐ nuô rò èthǐ cuố taritaryǎní̤ lahyǎ tè̤cuốtalwópwè̌ sèesǎsè̌ mò̤́hé agně bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bí mò̤́khípaló̤hò́ akhè̌nuô, Byacè ná a khǒpacè̤̌ shyéthè́nyě̤ onyǎo tava̤ ró̤lò̌ lǔ dố lé̤edǐrè̤́ akhǎshyé. ");
INSERT INTO kyu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Rò bí èthǐ edǐ akhè̌nuô, a hé èthǐ, “Vǎ hécò́cò́꤮ thǐ, dố thǐklè̌ yě, kayǎ dố a ki isè̌tǎ̤kyǎ vǎ pǎnuô a o tôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yětôphuốrò èthǐ thè́plò mo̤pǎ cò́ taki꤮ to, rò a sudyǎ lahyǎ Byacè tôprè̤ htuô̌ tôprè̤, “Byacè, nè̤ hénuô tôprè̤ma vǎ má̤to vǎhé?” ");
INSERT INTO kyu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Byacè hésû èthǐ, “Kayǎ dố a bò́nuô̌e tố̤kuô̌ ná vǎ dố bělò̤́kǔ nuôtôprè̤ ma má̤hò́ prè̤ dố a ki isè̌tǎ̤kyǎ vǎ pǎ nuôtôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Phú lisǎsè̌kǔ héone ná prè̤lu aphúkhǔ má̤hò́ vǎyě a bè thyě nyǎpǎ tadû́rò kayǎ dố a ki isè̌tǎ̤kyǎ prè̤lu aphúkhǔ yětôprè̤nuô, Cò́marya ki cirya lǔ pǎ. A ki opacè̤̌lya̤ to hénuôma aryáklò̌ pǎ cò́ dố lǔgně cò́.” ");
INSERT INTO kyu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yětôphuốrò Juda dố a ki isè̌tǎ̤kyǎ lǔ yětôprè̤ sudyǎ lǔ, “Thárá, nè̤ hé nuôtôprè̤ma vǎ má̤to, vǎhé?” Byacè hésû lǔ, “To, nè̤ má̤hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bí èthǐ esè akhè̌nuô, Byacè Jesǔ phyé khò́mǔ rò a hébwíhétaryě Cò́marya, htuô̌rò a ibiphè́ rò a dyétǎ̤ dố a khǒpacè̤̌ tahe a takhukǔ, rò a hé èthǐ, “Phyéemò̌ lahyǎ, yěma vǎ né̤klò̤́ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Htuô̌rò a phyéhtya bě rò a hébwíhétaryě rò a dyétǎ̤ dǐtû́ dố a khǒpacè̤̌ tahe a o rò a hé èthǐ, “Ǒmò̌ lahyǎ yě. ");
INSERT INTO kyu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Běyě ma tè̤emaklò̤ athè̌ dố a má̤hò́ vǎthwi dố a ki htwítǎ̤ rò a ki plwǒkyǎ kayǎ è́prè̤ atè̤thû́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Vǎ héso pé̤ thǐ, cáhtya khǒnyá̤yě tǎ̤plehyǎnuô vǎ ǒnò́ pǎ thòbǐthèhtyě yě tohò́. Vǎ ki ka̤ǒ ró̤kuô̌ khyěthyá thòbǐthèhtyě athè̌ ná thǐ dố vǎphè̌ ahtyěaké̤kǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Htuô̌rò èthǐ irǒ htuthè́htya Cò́marya ali-irǒ tôtó̤ rò a htecuốhtyakyǎ dố Oliva sokhu. ");
INSERT INTO kyu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Htuô̌rò Byacè Jesǔ hé èthǐ, “Lisǎsè̌kǔ hé, ‘Vǎ ki mṳ̂̌ prè̤kyě̤thímí pǎ, rò thímímṳ tahe ki klyapruốklyapryǎ lò̌ pǎ.’ “Me̤těhérò yětôthè̌ pǎ nuô, tè̤ ki htwǒhtya ná vǎ phúyě pǎ akhu-akhyě, thǐ ki hteklya cuốkhókyǎlò̌ vǎlé̤ pǎ,” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Manárò shyé꤮ vǎ thyě ihtòka̤khyě htuô̌pǎnuô, vǎ ki cuố ré̤ thǐ dố Galilea ké̤kǔ nuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petru hésû, “Ǔ ki thè́plòpyékyǎ lò̌ cò́ nè̤ khǎlé̤ bèbè, vǎ klyá thè́plò pyékyǎ vínyǎ ná nè̤ taki꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Manárò Byacè Jesǔ hésû lǔ, “Vǎ hécò́cò́ nè̤, yětôthè̌ bí shyěphè̌ i-uhtya tyahíto pǎ nuô, vǎ thè́gněnò́ lǔ to, nè̤ ki htébíkyǎ bǎ vǎ thuô̌phuố pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Manárò Petru hésû, “Vǎ tǒbè thyě tố̤kuô̌ cò́ ná nè̤ bèbè, vǎ thè́gněnò́ lǔ to nuô vǎ hécò́ nyǎ taki꤮ to hò́.” Rò a khǒpacè̤̌ dố aruô tahe krwǒhékuô̌ lò̌ phúnuônuô. ");
INSERT INTO kyu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Htuô̌rò Byacè Jesǔ ná a khǒpacè̤̌ tahe cuố dố khǎlé̤ tôpho dố ǔ è́ ná Gethsemani rò a hé èthǐ, “Bí vǎ cuố cò́bè̌ dố nuôtôpho akhè̌pǎnuô, onyǎokyǎ kuốré̤ lahyǎ bíyě ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A è́krwǒcuốní̤ Petru ná Zebedeo aphúprè̤khǔ thè́nyě̤ rò a thè́plè̤̌thè́zò̤ hyǎ rò a thè́plòkṳ́ thè́plòkyǎ̤ hyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Htuô̌rò a hé èthǐ, “Vǎ thè́plè̤̌thè́zò̤ thyěkyǎhò́, a thyácò́ná vǎ kíré̤ thyě cò́hò́nuô. Okyǎ lahyǎ bíyě rò othǎklyǎ lahyǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A cuố plehyǎpó̤ dố nyě takiphú rò a omyě takluô̤̌tǎ̤ dố hekhu rò a kwǐcò́bè̌ rò a hé, “Kố꤮ phè̌꤮ nè̤ ki phyé taphǎkyǎ pé̤ vǎ tè̤cyě̤tè̤cṳ̂ abělò̤́ yětôbè ma aní̤ prè́ kihérò phyétaphǎkyǎ pé̤ vǎ, manárò vǎ thè́zṳ̂́ me̤ cṳ́꤮ dû vǎ thè́plò to. Cṳ́꤮ dûprè́ nè̤ thè́plò ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Htuô̌rò a ka̤khyě khyěthyá dố a khǒpacè̤̌ tahe a o rò a ka̤ myáhtye èthǐ omyění̤ sǒtapa̤ lò̌, rò a sudyǎ Petru, “Thǐ othǎklyǎ nyě̤ tố̤kuô̌ ná vǎ bí tômû̌nuôprè́ rò thǐ thǎklyǎ khyǎbè́to è̌? ");
INSERT INTO kyu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Thyáphú thǐ ki cuốnuô̌ tố̤kuô̌ tǎ dố tè̤ilo-ilyá akǔ tǎmé̤nuô, thǎklyǎ rò kwǐcò́bè̌ lahyǎ ní꤮. Thǐ thè́plòshyome̤ nyacò́ tè̤ dố atǒ tadû́rò thǐ né̤klò̤́ yěnuô a hè̌cè̤́recè̤́ nyacò́.” ");
INSERT INTO kyu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A cuố khyěthyá nyě̤phuốtôphuố rò a kwǐcò́bè̌, “Kố꤮ vǎ phè̌thè́dǒ꤮, vǎ bè ǒ꤮ nyǎ hò́ tè̤cyě̤tè̤cṳ̂ a bělò̤́yě, phyétaphǎkyǎ ní̤ to kihérò, cṳ́꤮ dûprè́ nè̤ thè́plòní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bí a ka̤khyě myá khyěthyá a khǒpacè̤̌ tahenuô, a ka̤myáhtye ná èthǐ omyěsǒtapa̤ lò̌plǐ. Èthǐ thè́omyě cyě̤talwósû́lû̌ rò a myáhtebè́ pǎ cò́ to. ");
INSERT INTO kyu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Rò a htecuố kwǐcò́bè̌ khyěthyá thuô̌phuốtôphuố rò a héthyá khyěthyá phú a hé ré̤ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Htuô̌rò a ka̤khyě dố a khǒpacè̤̌ tahe a o rò a hé èthǐ, “Thǐ o꤮ myě tadûpǎ lahyǎ, thǐ okuố tabè́thè́prá tadû pǎ cò́ lahyǎ phútě? Ní̤dǎ myámò̌ lahyǎ, shuốkhè̌ dố ǔ ki isè̌tǎ̤kyǎ prè̤lukayǎ aphúkhǔyě dố prè̤oraphú tahe a takhukǔnuô, a hyǎtuố̤hò́. ");
INSERT INTO kyu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ihtòmò̌ lahyǎ, rò pè̤ ki cuố꤮, prè̤ isè̌tǎ̤kyǎ vǎ yětôprè̤ hyǎtuố̤hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bí Byacè Jesǔ hébè pǎprè́ akhè̌nuô, Juda dố a otố̤kuô̌ dố lǔ khǒpacè̤̌ shyéthè́nyě̤ aklè̌ yětôprè̤nuô a hyǎtuố̤ bínuô. Rò ǔ krwǒhyǎkuô̌ lǔ tôplutôphè cò́ rò a phyéhyǎní̤ lahyǎ imṳ̂̌, ipò̤ ná nè́ tahe. Kayǎ yětahe nuôma má̤prè́ bwídukhu tahe ná myěcôphú a khuklò́khuklyǎ tahe plwǒhyǎ èthǐ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Prè̤isè̌tǎ̤kyǎ Byacè yětôprè̤nuô a dyéthè́gně one ré̤ htuô̌hò́ èthǐ, “Kayǎ dố vǎ nuô̤mû́ è tôprè̤ nuôma má̤hò́ Jesǔ dố pè̤ thè́zṳ̂́pṳ̂́ è nuôtôprè̤ hò́ rò hyǎpṳ̂́ lahyǎ lǔ ní,” a héone èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A hyǎ tǒdè̌ tôphuốhyǎ dố Byacè Jesǔ a o rò a hyǎ hé lǔ, “Thárá, nè̤ omo̤-oryá è̌?” Htuô̌rò a nuô̤mû́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Rò Byacè héka̤khyěsû lǔ, “Khǒmo̤, nè̤ hyǎ bíyě rò nè̤ lé̤hyǎ me̤ǐtěnuô tarú me̤mò̌.” Htuô̌rò kayǎ tahe hyǎpṳ̂́kyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kayǎ dố a krwǒ hyǎkuô̌ ná Byacè Jesǔ aklè̌ tôprè̤nuô a báhte anè́ rò a pǎ̤tṳ̂̌kyǎ bwídukhulố a prè̤me̤tè̤phú tôprè̤ akhǎlè tôkhó. ");
INSERT INTO kyu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Byacè hé lǔ, “Ryǎ̤nuô̌ dwókyǎ nè̤nè́ nuô. Me̤těhérò kayǎ dố a pṳ̂́ nè́nuô a kipyékikyǎ khyě ná nè́khyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Thyáphú mò́khuphú tahe ki hyǎlya̤ takè̤bíní̤ vǎ agněnuô, vǎ ki kwǐ vǎphè̌ dố a ki nò̌hítǎ̤ èthǐ klyěmṳdu shyényě̤mṳ hénuô vǎphè̌ dyétǎ̤ tôphuố dyétǎ̤ cò́ vǎ ma꤮ a ní̤ cò́ nuôma thǐ thè́gněto è̌? ");
INSERT INTO kyu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ki vǎ me̤phúnuô hérò lisǎsè̌ a tè̤rǎone dố a bè htwǒhtya phúyěnuô a cuốlốcuốbǎhtya cyá̤ phútě?” ");
INSERT INTO kyu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Htuô̌rò Byacè Jesǔ hé kayǎ bè́mṳ, “Vǎ ma kayǎ dố a me̤thû́ tè̤thyótè̤thya tôprè̤ nyǎ è̌? Thǐ hyǎpṳ̂́ vǎ rò thǐ hyǎ cò́ ná nè́ ná imṳ̂̌ipò̤ cò́ phútě? Vǎ onyǎ ithyóithya ǔ dố tè̤lǔtyǎ hǒkǔ pwǒ̤nyěpwǒ̤thè̌ cò́ rò thǐ pṳ̂́ vǎ toto. ");
INSERT INTO kyu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Manárò tè̤htwǒhtya ané̤ phúyě nuôma thyáphú prè̤pro̤ rǎonekyǎ tahe kilốkibǎhtya agně prè́.” Htuô̌rò lò̌꤮ a khǒpacè̤̌ tahe hteklya taphǎkyǎ lò̌ lǔlé̤. ");
INSERT INTO kyu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kayǎ dố a hyǎpṳ̂́ Jesǔ yětahenuô, a pṳ̂́ka̤ lǔ dố bwídukhulố Caipha héyě tôprè̤nuô ahi. Bínuô ma prè̤ithyó tè̤thyótè̤thya athárá tahe ná tè̤cò́bucò́bè̌ khuklò́khuklyǎ tahe oplò́ lò̌hò́ lǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petru krwǒcuố lǒ kuô̌ prè́ Byacè Jesǔ. A cuố nuô̌tuố̤kuô̌ dố prè̤lǔtyǎ akhuklò́ dulố yětôprè̤ ahǒ lo̤tarè́kǔ rò a nuô̌ onyǎ tố̤kuô̌ ná klyěphú dố a opò̤́ takè̤ní̤ nuôtahe. Rò Petru opò̤́myá ná ǔ kíré̤ cirya kryá꤮ Byacè phútě pǎ, phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Thyáphú èthǐ ki cirya me̤thyěkyǎ ní̤ Jesǔ agněnuôrò, bwídukhu tahe ná Judaphú dố a o ná a taryěshyosò̌ htyalô̌ klò̌lố ǔ tahe myápṳ̌ lahyǎ lé̤kè̤lahǒ lé̤nè̌lahya Jesǔ atè̤thû́ tahe. ");
INSERT INTO kyu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kayǎ hyǎkhyá lahǒlahya è́lǎ lǔtè̤thû́ phúyěphúnuô tadû́rò a htwǒ khuklò́du khusuhtǔ tahe myáhtye ná a nè̌ lǔ tè̤thû́ yětahenuô a tǎ̤te̤ to. Dố khyětadûrò kayǎ thè́nyě̤ hyǎhte rò a hé, ");
INSERT INTO kyu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Kayǎ yětôprè̤nuô a hé, ‘Vǎ me̤tǎ̤prò̤kyǎ Cò́marya tè̤lǔhǒduyě rò thuô̌nyě akǔ vǎ isò́htyabè́ khyěprè́’ a hé phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Htuô̌rò bwídukhulố tôprè̤ ihtò rò sudyǎ Jesǔ, “Nè̤ hé ka̤khyěsû ǔ hyǎdya nè̤ tè̤thû́ yětahe tômû̌꤮ to me̤tě? Ǔ hyǎkè̤hyǎnè̌lò̌ nè̤ tè̤thû́ yěnuôma nè̤ ní̤huô̌ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Manárò a dyátaklwo prè́. Bwídukhulố nuôtôprè̤ hé, “Vǎ byǎ vǎngó̤ ná Cò́marya dố a htwǒprè̤ yětôprè̤ rò vǎ ki sudyǎ nè̤, nè̤ ma Messia má̤hò́ Cò́marya aphúkhǔ nuôtôprè̤ má̤lakǒ hò́ è̌ nuô hépé̤myá pè̤.” ");
INSERT INTO kyu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Rò Byacè Jesǔ hésû lǔ, “Ò, nè̤ hénuôma amá̤ tadû́rò vǎ ki hépé̤ lò̌ thǐ pwǒ̤꤮ tôprè̤ ná nopǎnuô thǐ ki myáhtye prè̤lukayǎ aphúkhǔyě ki onyǎ bí prè̤ dố a tè̤pro̤tè̤prya̤ dulốǔ yětôprè̤ atakhu cò́htwó nuôtôkyě pǎ. Htuô̌rò vǎ sidyáhyǎ ò́luố̤ pǎ nuô thǐ ki myáhtye pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yětôphuốrò bwídukhulố yětôprè̤ htò́zè̤̌ aca̤ rò a hé, “A héthû́hò́ Cò́marya hò́. Pè̤ cuốlotuố̤pǎ prè̤khyáthè́ tahe phútě? Myámò̌ lahyǎ, thǐ ní̤huô̌ lahyǎ hò́ a hébèthû́ Cò́marya ná thǐné̤ cò́ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Thǐ tane̤ phútě?” Rò èthǐ hésû lahyǎ, “A tǒ thyě nyǎhò́,” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Htuô̌rò èthǐ htuplá lǔmèthè, mṳ̂̌ lǔ, plú lǔ, tahehe rò a plyá̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Rò èthǐ hé lǔ, “Kố꤮ Krístu, pro̤ pé̤ myá pè̤, maǔpě mṳ̂̌ nè̤pě?” ");
INSERT INTO kyu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bínuôakhè̌ Petru onyǎo dố lo̤tarè́kǔ rò prè̤me̤tè̤ prè̤mòphú tôprè̤ hyǎtǒ dố lǔo rò a hé lǔ, “Nè̤ ma tômṳmṳ꤮ tuô̌prè́ lǔ ná Galileaphú Jesǔ nuôtôprè̤ prè́ vǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Manárò Petru htésû lò̌ èthǐ bínuô tahe rò a hé, “Vǎ otố̤kuô̌ to. Prè̤mò yětôprè̤ hé yěnuôma vǎ thè́gněnò́ kuô̌ǔ to.” ");
INSERT INTO kyu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Htuô̌rò a htecuố dố lo̤kadǎhtû̌ rò prè̤me̤tè̤phú prè̤mò dố aruôtôprè̤ myáhtyeke lǔ rò a hé pé̤ ǔ bínuô tahe, “Yětôprè̤ ma a krwǒkuô̌ ná vǐ̤ Nazarèphú Jesǔ Krístu nuô tôprè̤ vǎ꤮” ");
INSERT INTO kyu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A htésû khyěthyá rò a byǎ ané̤, “Vǎ thè́gněnò́ lǔ to.” ");
INSERT INTO kyu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Okhyěthyá dốkhyě taplô̤phú rò kayǎ ihtò tavǐtava̤ phû bínuô tahe hyǎtǒ Petru rò a hé lǔ, “Nè̤ ma èkhǒpacè̤̌ tôprè̤ má̤lakǒ cò́ hò́, nè̤ hébè talǎ̤ nuô a klwo Galilea talǎ̤ cò́.” ");
INSERT INTO kyu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yětôphuốrò Petru cáhtya byǎlya̤ní̤ ané̤ dố Cò́marya nyěhyǎ rò a hé, “Kayǎ yětôprè̤ ma vǎ thè́gněnò́ lǔ tôphuố꤮ to,” A héhtuô̌htuô̌ ná shyěphè̌ i-uhtya. ");
INSERT INTO kyu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yětôphuốrò Petru tane̤htya tuố̤bè Byacè Jesǔ héonekyǎ lǔ ngó̤, “Bí shyěphè̌ i-uhtya tyahíto akhè̌, nè̤ ki htébíkyǎ ǔ ná vǎ thè́gněnò́ è to thuô̌phuố pǎ,” akhu-akhyě a htecuố dố aklò̌ rò a cuố nguố̤thyěnguố̤o cò́. ");
INSERT INTO kyu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Anotôrǒ mò̤́lǐ ro̤mû́ akhè̌nuô, lò̌꤮ bwídukhu tahe ná myěcôphú khuklò́khuklyǎ tahe okúokyá lò̌ lǔ ná èthǐ ki me̤thyě Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Èthǐ cò̌klò̤ htuô̌ Byacè Jesǔ rò a cwicuốkyǎ lǔ dố Khwí Pilato a o rò a cuốdyé tǎ̤kyǎ lǔ dố a takhukǔ. ");
INSERT INTO kyu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Bí Juda dố a isè̌tǎ̤kyǎ lǔ nuôtôprè̤ myáhtye dố ǔ cirya thyě Byacè Jesǔ akhè̌nuô, a thè́plè̤̌thè́zò̤ nyacò́ rò a hyǎ dyédwó khyěthyá rû̌zyeyě thakha dố bwídukhu tahe a o ná Judaphú muố̤prû̌muố̤prè̤́ tahe a o. ");
INSERT INTO kyu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Rò a hé èthǐ, “Vǎ me̤thû́hò́ Cò́marya hò́, me̤těhérò vǎ isè̌kyǎhò́ kayǎ dố a tè̤thû́o tôcô꤮ to yětôprè̤ hò́.” Rò èthǐ hésû ka̤khyě lǔ, “Nè̤ ná nè̤dûhò́ pè̤ thè́gně tuố̤kuô̌ nè̤ to.” ");
INSERT INTO kyu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Èthǐ héphúnuô rò Juda prò̤tǎ̤kyǎ rû̌zyeyě bí tè̤lǔtyǎ hǒkǔ nuô rò a hteka̤kyǎ. Htuô̌rò a htecuố dố aruô tôpho rò a cuố cò̌thyěkyǎ ané̤. ");
INSERT INTO kyu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bwídukhu tahe ihtuô dwókhyě rû̌zye yětahe rò a hé lahyǎ, “Rû̌zyeyě pè̤ Juda a tè̤thyótè̤thya o ná a tǒkò sunuô̌tố̤ ná tè̤lǔhǒdu arû̌ to, me̤těhérò rû̌ yěnuôma ǔ dyé ná lé̤me̤thyě kayǎ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Èthǐ belya̤ lahyǎ athè́plò ná a ki ipri̤ ná prè̤byápò̤ tôprè̤ aprè́ tôlé̤ rò èthǐ ki dya pé̤ ná Judaphú má̤to tahe aluô̤̌khu. ");
INSERT INTO kyu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Phúnuô akhu-akhyě, tuố̤khǒnyá̤ hekhu bínuô tôphonuô ǔ è́ ná thwihekhu. ");
INSERT INTO kyu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Prè̤pro̤ Jeremia a tè̤héone yěnuô a lốhtyabǎhtya hò́, “Èthǐ phyé rû̌zye thakha rò Israelphú tahe hé lǔ, pè̤ dya lǔ angṳ báyě ma a kòhò́. ");
INSERT INTO kyu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rò èthǐ ipri̤ rû̌zye nuôtahe ná prè̤byápò̤ aprè́ tôlé̤ phú Byacè nò̌ipri̤ vǎnuô.” ");
INSERT INTO kyu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bínuôakhè̌ Jesǔ ihtò odố Khwí Pilato anyěhyǎ rò a sudyǎ lǔ, “Nè̤ ma Judaphú akhwí tôprè̤ má̤lakǒ è̌?” Rò a hésû khwí, “Ò, a má̤lakǒ phú nè̤ hénuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bí bwídukhu tahe ná Judaphú muố̤prû̌muố̤prè̤́ dố a htwǒ khuklò́khuklyǎ tahe kè̤ lǔ tè̤thû́ akhè̌nuô, a hé ka̤khyěsû tômû̌꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Khwí Pilato sudyǎ lǔ, “Ǔ kè̤ lò̌ nè̤ ná nè̤ me̤thû́me̤plá phúyě phúnuôma nè̤ ní̤huô̌ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Manárò Byacè Jesǔ héka̤khyěsû lǔ ngó̤ tômû̌꤮ to akhu-akhyě khwí khyéthukhyéthè́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Khwíyě alé̤klǒ o ná pwǒ̤nana꤮ tè̤cuốtalwópwè̌ dǎ bè hò́ hénuô, a hé kayǎ bè́mṳ tahe ki nwóhte kayǎcyě̤ dố ǔ dò́tǎ̤ lǔ dố htò̌kǔ nuôtahe tôprè̤. Rò èthǐ nwóhte bítě꤮ tôprè̤ bèbè, khwí plwǒhte pé̤ èthǐ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bínuôakhè̌ ǔ dò́tǎ̤ kayǎ mwi̤du dố acyě̤ tôkyě rò amwi̤ ná Barabba otôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Rò bí kayǎ bè́mṳ hyǎopò̤́ lò̌ lǔ akhè̌, Khwí Pilato sudwǒ èthǐ, “Thǐ thè́zṳ̂́ nò̌plwǒhte vǎ bítě tôprè̤tě? Ma thǐ thè́zṳ̂́ nò̌plwǒhte vǎ dố Barabba è̌? Má̤toma Jesǔ dố ǔ è́ lǔ ná Krístu yětôprè̤nuô è̌?” A sudyǎ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Me̤těhérò a thè́gně htuô̌hò́ ná tè̤cò́bè̌ khuklò́khuklyǎ tahe thè́khwè́ní̤kuô̌ Jesǔ rò èthǐ hyǎdyétǎ̤kyǎ Jesǔ dố lǔo prè́. ");
INSERT INTO kyu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bí Khwí Pilato onyǎo dố a lé̤cirya ǔ khuklyáhtyalô̌ alo̤ akhè̌nuô, amě nò̌hyǎthǔ ǔ tè̤ritè̤kyǎ tôcô dố avè̤ Khwí Pilato a o rò a hé, “Cuốme̤bè tǎ kayǎ dố atè̤thû́ oto yětôprè̤nuô taki꤮ tǎmé̤ ní꤮, me̤těhérò vǎ omyěmyá̤ ryá cò́ ari-akyǎ taki꤮ cò́ to.” ");
INSERT INTO kyu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Manárò bwídukhu tahe ná Judaphú muố̤prû̌muố̤prè̤́ dố a htwǒ khuklò́khuklyǎ tahenuô a cuố ilò̌ kayǎ bè́mṳ tahe ná a ki kwǐhte Barabba rò ki cirya thyěkyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Rò Khwí Pilato sudyǎ èthǐ, “Yěthè́nyě̤ aklè̌ thǐ thè́zṳ̂́ nò̌plwǒkyǎ vǎ bítě tôprè̤tě?” Rò èthǐ è́htǒhtyasû, “Barabba.” ");
INSERT INTO kyu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Rò Khwí Pilato sudyǎ èthǐ, “Ki me̤phúnuôrò Jesǔ dố ǔ è́ lǔ ná Krístu yětôprè̤nuô vǎ bè me̤ è phútě?” Rò èthǐ hésû, “Mṳ̂̌thyě htyakyǎ è dố krusulo̤ nuô,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Rò Khwí Pilato sudyǎ èthǐ, “Cuố mṳ̂̌thyě htyakyǎ è me̤tě? A cuố me̤thû́me̤plá kryá꤮ ǐtě?” Rò èthǐ lé꤮ è́htǒhtyashyo klò̌lố pó̤, “Mṳ̂̌thyěhtyakyǎ è dố krusulo̤ nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bí Khwí Pilato myáhtye thè́gněhò́ ná ǔ ní̤dǎpǎ lǔ tè̤hébè to, htuô̌to kayǎ yětahe ki cáhtya me̤tarû̌tapyǎ súsá hyǎhò́ akhu-akhyě a phyé htyěkacṳ́ rò a thǐplǐkyǎ atakhu dố kayǎ bè́mṳ a mèthènyě rò a hé, “Kayǎ yětôprè̤ athwinuô a tǎ̤bè tuố̤kuô̌ pǎ dố vǎkhu tohò́. Thǐ ná thǐdûhò́.” ");
INSERT INTO kyu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Rò kayǎ lò̌꤮ plǐ hésû, “Athwi nuô nò̌lya̤bèdû dố pè̤ ná pè̤phúpè̤lye̤ tahe akhu nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Rò a plwǒhtekyǎ pé̤ èthǐ Barabba rò a nò̌ klyěphú tahe ki mṳ̂̌ Byacè Jesǔ ná iplírwí̤, htuô̌rò a dyétǎ̤ dố klyěphú tahe a khadǎkǔ dố a ki cuố mṳ̂̌thyěhtyakyǎ Byacè Jesǔ dố krusulo̤. ");
INSERT INTO kyu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Htuô̌rò khwí aklyěphú tahe è́cuố Byacè Jesǔ dố klyěklǒ lé̤o bí khwíhǒ tarè́kǔnuô rò klyěphú zè̤thuô̌thyó hyǎoplò́ tava̤lò̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Htuô̌rò èthǐ plwókyǎ Byacè Jesǔ aca̤ rò a thyáhtya pé̤ lǔ ca̤cwo̤ li̤lò́thò̌ tôpṳ̂. ");
INSERT INTO kyu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Htuô̌rò èthǐ ikhu tava̤ thòshyámò̤́ thyáná khuklwǒ̤ nuôrò a klwǒ̤htya pé̤ lǔ rò èthǐ hé takhwótakè, me̤lavilavò̌ kano lò̌ lǔ. Èthǐ nò̌pṳ̂́ lǔ ihtyábǒ dố atakhu cò́htwó tôkyě rò èthǐ dángṳ̂lya̤ dố lǔnyěhyǎ rò a hé lavò̌ kano lò̌ lǔ, “Kố꤮ Juda akhwídu, ohtwǒprè̤ mò̤́nyě htǔdû ní꤮!” ");
INSERT INTO kyu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Èthǐ htuplá lǔ ná pli̤htyě, èthǐ phyé ihtyábǒ rò mṳ̂̌htuô̌ mṳ̂̌thyáthyá cò́ ná lǔ khuklò́cò́. ");
INSERT INTO kyu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bí èthǐ me̤zò́me̤lě nyě̤kruô̌htuô̌ lǔ nuô a plwótǎ̤kyǎ khyěthyá ca̤cwo̤htǔ nuôtôpṳ̂ rò a thyáhtya taple pé̤ khyěthyá lǔ ná aca̤ ní̤dû nuôtôpṳ̂. Htuô̌rò a è́htecuốkyǎ lǔ rò a ki cuố mṳ̂̌thyěhtyakyǎ lǔ dố krusulo̤. ");
INSERT INTO kyu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bí èthǐ htecuố akhè̌nuô, a myáhtye Cyreneo vǐ̤phè̌ dố amwi̤ ná Simonè yětôprè̤ rò klyěphú tahe nò̌zá tadû lǔ ná Jesǔ krusu. ");
INSERT INTO kyu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Èthǐ cuố dố khǎlé̤ tôpho dố ǔ è́ ná Goghotha hé yěnuôtôpho. (Goghotha angó̤lasá ma khuklò́krwí akhǎlé̤). ");
INSERT INTO kyu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bínuô akhè̌nuô, èthǐ dyéǒ lǔ htyězǎ̤ dố a kluô̌ sǐlyǎ̤tố̤ ná tè̤khukhè tôcô dố ǔ è́, “kò̌” rò Jesǔ puô̤myá htuô̌rò a thè́ǒto. ");
INSERT INTO kyu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bí èthǐ mṳ̂̌thyěhtya htuô̌hò́ Jesǔ nuô, èthǐ iběphyé ró̤lǔ Jesǔ aca̤ tahe. Bí èthǐ ibě tyahí lǔ to akhè̌nuô, èthǐ bò́ lahyǎ tè̤byǎbwí tôcô, me̤těhérò a bò́ tôprè̤ htuô̌ tôprè̤, rò a tǎ̤tǒ bítě tôprè̤ tǒ phyé bítě tôkyětě nuô, cṳ́꤮ dû abwí tǎ̤tǒ prè́. ");
INSERT INTO kyu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Htuô̌rò èthǐ onyǎtǎ̤ lahyǎ rò opò̤́myání̤ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dố a khuklò́htè́ nuô, èthǐ rǎhtya-o lidyatè̤thû́ tôklǒ, “È ma Jesǔ, Judaphú tahe akhwí.” ");
INSERT INTO kyu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ǔ mṳ̂̌thyěhtya tố̤kuô̌ lǔ ná prè̤pṳ̂́phe zè́plè́phe ǔ thè́nyě̤, dố cò́htwó tôprè̤ dố cò́ci tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kayǎ dố a cuốphûka̤phû lahyǎ bí akhǎshyé nuôtahe nuô lahyǎ akhuklò́, pacyé̤ishyé rò a hé lahyǎ lǔ, ");
INSERT INTO kyu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Nè̤ hé ná nè̤ ki me̤tǎ̤prò̤kyǎ tè̤lǔhǒdu rò thuô̌nyě akǔ nè̤ isò́htya htuô̌bè́ khyěprè́ nè̤ hé vǎhé. Me̤lwóhteka̤ ní̤dyémò̌ nè̤né̤ to. Nè̤ ki má̤lakǒ Cò́marya aphúkhǔ hérò hítǎ̤mò̌ dố krusulo̤ yěnuô to.” ");
INSERT INTO kyu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe ná tè̤cò́bucò́bè̌ a khuklò́khuklyǎ tahe hétakhwótakè thyákuô̌ lò̌ dû lǔ phúnuô, ");
INSERT INTO kyu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A me̤lwóhteka̤ cyá̤ ǔ thè́htwǒprè̤ tadû́rò a me̤lwóhteka̤ cyá̤ ní̤dyékuô̌ ané̤to vǎ꤮. È ma Israel akhwí vǎhéto. Nò̌hítǎ̤ mò̌ è dố krusulo̤nuô to, rò pè̤ zṳ̂́e kuô̌dû kǒ. ");
INSERT INTO kyu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A zṳ̂́e Cò́marya vǎhé. Cò́marya ki thè́plòoní̤ lǔ hérò nò̌me̤lwóhteka̤ mò̌ lǔ khǒnyá̤yěnuô kǒkǒ? Me̤těhérò a hé dyé ané̤, ‘Vǎ ma Cò́marya aphúkhǔ’ meně.” ");
INSERT INTO kyu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Prè̤pṳ̂́phe zè́plè́phe ǔ dố ǔ mṳ̂̌thyěhtya tố̤kuô̌ ná Jesǔ yěthè́nyě̤nuô a pacyé̤ishyé kuô̌dû lǔ phúnuônuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Cáhtya bí mò̤́htuô cò́ranè́ nuô rò a tuố̤hyǎ dố mò̤́kwí̤lya̤ thuô̌mû̌ akǔnuô ké̤ khítarṳ̂ tǎ̤lò̌ cò́ tôké̤lè̤̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tavǐtava̤ bí mò̤́kwí̤lya̤ thuô̌mû̌ akhè̌nuô, Jesǔ cyé̤pryě̤ è́htǒhtya, “Éli, Éli, lema sabathani,” angó̤lasá ma “Vǎ Cò́marya, vǎ Cò́marya, nè̤ vǐkyǎ vǎ me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kayǎ ihtòo bínuô tahe ní̤huô̌ lahyǎ Jesǔ è́htǒhtya phúyě rò èthǐ hé lahyǎ, “A è́htǒhtyahò́ Prè̤pro̤ Elia.” ");
INSERT INTO kyu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bí èthǐ aklè̌ nuôtôprè̤, tôphuốtuô̌ a klyacuốphyé tè̤tôcô dố athyáná phyáplyé rò a cuốcye̤nuô̌ dố htyězǎ̤shye thǒkǔ rò a cò̌klò̤ma dố vèlǎ̤khyě rò a dyéhtya nò̌cwíǒ ná Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lò̌꤮ a okyǎ nuôtahe hé lǔ, “A o dûhò́ phúnuô, pè̤ opò̤́myá kuốré̤ taplô̤phú pó꤮, ma pè̤ myáhtye sálé̤ Prè̤pro̤ Elia hyǎ me̤lwóhteka̤ lǔ pǎ è̌, ma to è̌,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bí Byacè è́htǒhtyashyo khyěthyápó̤ tôphuố htuô̌nuô athè́plò htwǒprè̤ htecuốkyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bínuôakhè̌ ikè̤̌badu dố ǔ cò̤́tǎ̤tṳ̂̌bí dố tè̤lǔtyǎ hǒkǔ nuôtôba lazè̤̌ kahtyakalya̤ plû́kyǎ nyě̤kyě. Tanéhtò́dǐ htuô̌rò lò̤́ tahe lṳǎyǎ phè́lò̌. ");
INSERT INTO kyu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Luô̤̌kǔ tahe kǔmǒhtya lò̌ rò prè̤sǎsè̌phú dố a thyěhtuô̌hò́ nuôtahe ihtòhtwǒprè̤ ka̤khyě è́lǎ. ");
INSERT INTO kyu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Èthǐ o dố luô̤̌kǔ rò hteka̤. Htuô̌rò dố khyě bí Byacè Jesǔ Krístu thyě ihtòka̤khyě htuô̌nuô èthǐ ka̤ kanuô̌ lahyǎ dố vǐ̤sǎsè̌ Jerusalem akǔ rò ǔ myáhtye ró̤kúlǎ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bí Roma klyětôzè̤ khuklò́ yětôprè̤ ná kayǎ dố a opò̤́maní̤ Jesǔ yětahe myáhtye tanéhtò́dǐ ná lò̌꤮ tè̤htwǒhtya ané̤ yětahe akhè̌nuô, èthǐ thè́isě rò a hé lahyǎ, “È ma Cò́marya aphúkhǔ má̤lakǒ nyǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Prè̤mò dố a opò̤́ myácuốlǒ dố aye̤ tahe oró̤oè́ kúlǎ bínuô. Èthǐ ma prè̤mò tahe dố a o dố Galilea ké̤ rò a krwǒkuô̌ ná Jesǔ. Rò èthǐ myákhwèní̤ lahyǎ tè̤ dố Byacè lo tahe. ");
INSERT INTO kyu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dố èthǐ yětahe aklè̌nuô Magdalena dò̌kǔmuố̤ Maria, Jakomo ná Jose amuố̤ Maria ná Zebedeo aphú tahe amuố̤. ");
INSERT INTO kyu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bí mò̤́hélya̤ hò́ akhè̌nuô, kayǎphè̌duzá̤ o dố vǐ̤ Arimathea rò amwi̤ ná Joseph hé yětôprè̤ hyǎtuố̤. È ma a htwǒ htuô̌hò́ Byacè Jesǔ a khǒpacè̤̌ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A cuố dố Khwí Pilato a o rò a cuốkwǐ Jesǔ aluô̤̌to̤ rò Khwí Pilato hétǎ̤ ǔ ná ǔ ki dyé Jesǔ aluô̤̌to̤ yěnuô ná Joseph. ");
INSERT INTO kyu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Rò Joseph cuốphyétǎ̤ luô̤̌to̤yě rò a bobí lǔ ná ikè̤̌báplǐhtǔ tôba. ");
INSERT INTO kyu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Rò ǔ cuốsunuô̌ lǔ dố luô̤̌kǔthè̌ tôkǔ. Luô̤̌kǔthè̌ yěnuôma Joseph atè̤ ní̤dû. A nò̌ikhûkǔnuô̌ one ǔ dố lò̤́kǔ. A htulò̌bí luô̤̌kǔ yěnuô ná lò̤́du tômě htuô̌rò a ka̤kyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdalena dò̌kǔmuố̤ Maria ná Maria dố aruôtôprè̤ onyǎo tǒdè̌ dố luô̤̌kǔ anyěhyǎ. ");
INSERT INTO kyu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mò̤́nyǎ̤nyě ma mò̤́nyě dố Judaphú tahe taritaryǎ one tè̤lò̌꤮ plǐ dố shyéparǒ Mò̤́nyěduô nuôtônyě agně. Mò̤́nyǎ̤nyě htuô̌ shyéparǒ Mò̤́nyěduô yě akhè̌nuô, bwídukhu tahe ná Pharisěophú tahe cuố lahyǎ dố Khwí Pilato a o. ");
INSERT INTO kyu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Rò èthǐ cuố hé lǔ, “Khwí꤮ pè̤ tǒ̤maní̤ pǎ ná bí phè̌lahǒdu nuôtôprè̤ ohtwǒprè̤pǎ akhè̌nuô, a hé, ‘Thuô̌nyěhtuô̌pǎ nuô, vǎ ki ihtòhtwǒprè̤ ka̤khyě pǎ,’ a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Phúnuôrò hétǎ̤ klyěphú tahe rò nò̌opò̤́ma tǎ̤te̤ bǎ è thuô̌nyěnuô. Pǎma a khǒpacè̤̌ tahe hyǎphyéhuô ní̤dyé lǔ rò a cuố hé pé̤ ǔ ná a ihtòhtwǒprè̤ ka̤khyě hò́꤮, phúnuôhe. Pǎma tè̤lahǒ dốkhyě yětômû̌ nuô thè́isě ná a cyě̤lốklò̌ ná tè̤lahǒ dố aré̤ nuôtômû̌ he.” ");
INSERT INTO kyu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Khwí Pilato hésû, “Ki me̤phúnuôrò è́cuốní̤ lahyǎ prè̤opò̤́ tahe rò cuốmò̌ lahyǎ, yácû́ opò̤́ma ryá lahyǎ bá꤮ thǐ opò̤́mabè́ tadû nuô.” ");
INSERT INTO kyu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Thyáphú èthǐ ki me̤klò̤me̤ma ryá luô̤̌kǔyě rò èthǐ cuốklè́htya luô̌ a tè̤mátè̤dyǎ tôcô dố luô̤̌kǔ mǎ̤htè́lo̤ htuô̌rò a nò̌opò̤́maní̤ ná klyěphú tahe. ");
INSERT INTO kyu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bí Judaphú a Mò̤́nyěduô htuô̌ anotôrǒ mò̤́lǐ ro̤mû́ mò̤́khíò́pǎ akhè̌nuô, Magdalena dò̌kǔmuố̤ Maria ná Maria dố aruôtôprè̤ hyǎmyá lahyǎ Byacè aluô̤̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Rò tanéhtò́dǐ shyonyacò́, me̤těhérò Byacè a tanéphú tôprè̤ o dố mò́khu hyǎlya̤ htulò̌ taphǎkyǎ lò̤́nuô tômě rò a hyǎ onyǎo dố lò̤́ nuôtômě akhu. ");
INSERT INTO kyu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ané̤klò̤́ rò a takhè̌ thyácò́ná shyeli̤bò́ nuô cò́, htuô̌rò aca̤nuô a bǔplya thyácò́ná bǔkhu lya̤ nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Prè̤opò̤́ tahe tanyǎ̤tadè lò̌plǐ cò́. Èthǐ thè́isě talwósû́lû̌ rò èthǐ thyá cò́ ná kayǎthyě nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Rò mò́khu tanéphú hé prè̤mò yěthè́nyě̤, “Thè́isě lahyǎ tǎmé̤, me̤těhérò thǐ myápṳ̌ Jesǔ dố ǔ mṳ̂̌thyěhtya lǔ dố krusu alo̤ nuôtôprè̤ prè́ nuôma vǎ thè́gně. ");
INSERT INTO kyu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Manárò a opǎ bíyě tohò́. Phú a héone htuô̌hò́ nuô, a ihtòhtwǒprè̤ ka̤khyě htuô̌hò́. Hyǎmyámò̌ a lé̤omyě khǎlé̤yě. ");
INSERT INTO kyu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Vǎ hé thǐ꤮ ka̤dyáso pé̤ pryǎmò̌ a khǒpacè̤̌ nuôtahe, ‘A ihtòhtwǒprè̤ ka̤khyě hò́ khǒnyá̤ hò́ rò a cuố one ré̤ hò́ thǐ dố Galilea ké̤kǔ nuô hò́, thǐ ki cuốmyáhtye è bínuô pǎ,’ khǒnyá̤ rò vǎ héluô̌ pé̤ thǐ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Phúnuôrò prè̤mò yěthè́nyě̤ o bí luô̤̌kǔ nuô rò a tapluố̤taplyě hteka̤ lahyǎ. Èthǐ thè́isěsě, thè́krṳ̂̌krṳ̂̌ cò́ rò a klyaka̤ dyáso pé̤ lahyǎ a khǒpacè̤̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tôphuốtuô̌ Byacè Jesǔ myáhtye tǎ̤sû èthǐ rò a hémo̤héryásû èthǐ. Rò èthǐ hyǎtǒ Byacè rò a hyǎ pṳ̂́ma lǔ khǎduô tarǎ rò cò́bucò́bè̌htya lǔ. ");
INSERT INTO kyu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Htuô̌rò Byacè hé èthǐ, “Thè́isě tǎ lahyǎ tǎmé̤. Ka̤héso pé̤ lahyǎ vǎpuố̤vǎvyá̤, cuố lahyǎ dố Galilea ké̤ nuô, thǐ ki cuốmyáhtye vǎ bínuô pǎ, hésopé̤ èthǐ phúnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bí prè̤mò yětahe ka̤ dố klyálo̤ akhè̌nuô, prè̤opò̤́ luô̤̌kǔ tahe ka̤ kanuô̌ tuố̤lò̌ hò́ dố vǐ̤kǔ rò a me̤kryá꤮ phútěnuô, èthǐ ka̤ hésoluô̌ pé̤ ná bwídukhu tahe. ");
INSERT INTO kyu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bí bwídukhu tahe myáhtye tǎ̤sû ná Judaphú muố̤prû̌muố̤prè̤́ dố a khuklò́khuklyǎ tahe akhè̌nuô, èthǐ bè me̤ lahyǎ phútě pǎnuô a taritaryǎ lahyǎ. Htuô̌rò èthǐ dyé cò́ klyěphú tahe rû̌ tôplutôphè rò a hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Thǐ tǒbè hé lahyǎ phúyě, ‘Bí pè̤ omyě sǒtapa̤ akhè̌nuô, a khǒpacè̤̌ tahe hyǎphyéhuô ka̤kyǎ lǔ hò́,’ hé lahyǎ phúyě nuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tè̤ritè̤kyǎ yě ki luô̌cuốtuố̤ dố khwí o pǎ hérò thyáphú a ki me̤pyá̤me̤sè̌ tǎ thǐ tǎmé̤nuô, pè̤ myá hédû è pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Phúnuôrò klyěphú tahe phyé lahyǎ rû̌ yěnuô rò a hé phú èthǐ ithyó lǔ nuô. Ngó̤ yětômû̌nuô Judaphú tôké̤lè̤̌ hé ní̤dyé lò̌pǎ cò́ tuố̤khǒnyá̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yětôphuốrò a khǒpacè̤̌ yě shyétôprè̤ cuố lahyǎ dố Galilea sokhu phú Byacè héso onekyǎ èthǐ nuô. ");
INSERT INTO kyu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bí èthǐ myáhtye a Byacè akhè̌nuô, èthǐ cò́bè̌htya lǔ tadû́rò tahehe nuô athè́plò rare pǎ. ");
INSERT INTO kyu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Rò Byacè Jesǔ hyǎ dố èthǐ o rò a hé èthǐ, “Taryěshyosò̌ dố mò́khu bèbè, dố hekhuyěnuô bèbè, ǔ dyé lò̌hò́ ná vǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Me̤phúnuôrò, vǎ hé thǐ꤮, cuố lahyǎ dố kayǎ myěcô tahe a o rò cuốme̤ htwǒhtya èthǐ ná vǎ khǒpacè̤̌ ní꤮. Cuố plwǒ pé̤ lahyǎ èthǐ htyě ná phè̌ amwi̤, phúkhǔ amwi̤ ná Thè́ Sǎsè̌ Byacè amwi̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Htuô̌rò ithyóithya lahyǎ èthǐ ná a ki cṳ̌e krwǒme̤ kuô̌lò̌ phú vǎ mekyǎ thǐ ngó̤ nuôtahe ní꤮. Vǎ ki otố̤kuô̌ ná thǐ pwǒ̤꤮ phuố cò́ pǎ, tuố̤ cò́ dố hekhu tadûkyǎ cò́pǎ bèbè vǎ ki okuô̌dû ná thǐ pǎ.”");
INSERT INTO kyu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yěma tè̤thè́krṳ̂̌mila akhǎshyé dố a hésoluô̌ pé̤ Cò́marya aphúkhǔ Jesǔ Krístu ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tè̤thè́krṳ̂̌mila yěnuô ǔ rǎ o è dố Prè̤pro̤ Isaiah alikǔ, rò Cò́marya hé, “Myámò̌, è ma prè̤thǔ pé̤ vǎ tè̤ritè̤kyǎ tôprè̤hò́, thyáphú a ki me̤mǒ one ré̤ pé̤ nè̤klyá lé̤hyǎ agněnuôrò, vǎ nò̌hyǎ ré̤hò́ è dố nè̤nyěhyǎ hò́, ");
INSERT INTO kyu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","kayǎ tôprè̤ è́htǒhtya dố ké̤sè̌htyěkya̤ lò̤́tamákhu rò a hé, ‘Taritaryǎ one lahyǎ klyá dố Byacè agně. Me̤cò́me̤pě̤ lahyǎ Byacè lé̤hyǎklyá agně tôbǒ ní꤮.’” ");
INSERT INTO kyu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Rò prè̤ héso pé̤ ǔ tè̤ritè̤kyǎ yětôprè̤nuô a hyǎ htuô̌hò́. È ma Giovanni Baptista nuô hò́. A htecuố dố ké̤sè̌htyěkya̤ lò̤́tamákhu rò a hésodônyǎ pé̤ ǔ ná za̤ ní̤dû lahyǎ thǐné̤ rò plwǒ lahyǎ thǐné̤ ná htyě tû́rò Cò́marya plwǒkyǎ thǐ tè̤thû́ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kayǎ o dố Juda ké̤kǔ nuôtahe ná vǐ̤ Jerusalem akǔ nuôtahe hyǎró̤è́lǎ dố Giovanni a o rò èthǐ hyǎ ò́lya̤nuôlya̤ lahyǎ atè̤thû́ rò Giovanni plwǒ pé̤ èthǐ htyě dố Jordano htyěklǒkǔ. ");
INSERT INTO kyu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Giovanni kû̌thyáhtyaní̤ hyeca̤ dố ǔ bò́ ná tathíbuô̌du asû, rò a ryá̤htyaní̤ nyá̤htò́phá. Rò a eprè́ takǐ ná vyáhtyě. ");
INSERT INTO kyu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Rò a hésodônyǎ pé̤ ǔ rò a hé, “Kayǎ ki hyǎ dố vǎkhyěkhu pǎ tôprè̤ nuôma, a taryěpro̤prya̤ shyosò̌ lốklò̌ cò́ ná vǎ pǎ. Vǎ ngò̤takò̤ htulyě pé̤ prè́ è khupháplye̤ prè́ nuô vǎ kò ná è to. ");
INSERT INTO kyu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Vǎ plwǒ thǐ ná htyě tadû́rò a ki plwǒ thǐ ná Thè́ Sǎsè̌ Byacè pǎ,” Giovanni hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bí Giovanni plwǒ pé̤ kayǎ tahe ná htyě akhè̌nuô, Jesǔ o dố vǐ̤ Nazarè Galilea ké̤ rò a hyǎ dố Jordanohtyěklǒ a o rò Giovanni plwǒ pé̤ lǔhtyě dố Jordano htyěklǒkǔ. ");
INSERT INTO kyu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bí a o dố htyělè̤̌ rò a nyǎ̤kahtòhtò ná a myáhtye mò́khu lṳmǒǎyǎ rò Thè́ Sǎsè̌ Byacè dố athyáná htulwí̤ nuô a hyǎlya̤ dố lǔlo̤. ");
INSERT INTO kyu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Rò Cò́marya o dố mò́khu, rò a hébètǎ̤ lǔ, “Nè̤ ma vǎphúkhǔ dố vǎ mo̤ ní̤dyé rò a me̤mo̤ vǎ thè́plò tôprè̤,” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A héhtuô̌ phúnuônuô, Thè́ Sǎsè̌ Byacè cò̤̌cuố lǔ dố lá̤mi̤soklè̌. ");
INSERT INTO kyu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesǔ o bí lá̤mi̤soklè̌ nuô anyě lwǐ̤shyě, rò mò̤́nyě lwǐ̤shyě akǔ yěnuô, khǐnéricyá̤ khuklò́ hyǎ ilo-ilyá lǔ. Jesǔ otố̤ ná tè̤phútè̤lye̤, tè̤mi̤tè̤myá̤ tahe bínuô, rò tanéphú tahe myání̤khwèní̤ dyé lǔ. ");
INSERT INTO kyu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bí ǔ pṳ̂́dò́tǎ̤ Giovanni dố htò̌kǔ akhè̌nuô, Jesǔ cuố dố Galilea ké̤ rò a hésodônyǎ pé̤ ǔ ná Cò́marya a tè̤thè́krṳ̂̌mila bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Rò a hé, “Tè̤shuốtè̤khè̌ hyǎtuố̤hò́. Cò́marya ahtyěaké̤ phûhtyahò́ rò za̤ ní̤dû lahyǎ thǐné̤ rò zṳ̂́ka̤nyá̤ka̤ mò̌ lahyǎ tè̤thè́krṳ̂̌mila yě.” ");
INSERT INTO kyu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Htuô̌rò Jesǔ cuố dố Galilea htyěòduhtû̌ rò a cuốmyáhtye Simonè ná apuố̤ Andrea. Rò bínuôakhè̌ èthǐ cò̤́etè̤̌ ná itavǐ dố nókǔ, me̤těhérò a pṳ̌eprè́ lahyǎ ahò́kǔsè ná tè̤̌ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Rò Jesǔ hé èthǐ, “Cuố꤮ krwǒkuô̌ vǎkhyě. Vǎ ki ithyóithya ní̤ thǐ thyáphú thǐ ki è́ní̤ kayǎ phú thǐ pṳ̂́e ní̤ tè̤̌yě nuô.” ");
INSERT INTO kyu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rò tôphuốtuô̌ èthǐ dyakyǎ a itavǐ rò a krwǒkuô̌ Jesǔ akhyě. ");
INSERT INTO kyu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Rò èthǐ cuố plehyǎ pó̤ dố nyě takiphú rò a myáhtye Zebedeo aphúkhǔ Jakomo ná apuố̤ Giovanni isè́ri̤ ní̤dyé lahyǎ a itavǐ dố thòklyěkǔ. ");
INSERT INTO kyu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesǔ myáhtyehtyená a è́ èthǐ rò èthǐ htecuố krwǒkuô̌ lǔkhyě. Rò aphè̌ Zebedeo ná prè̤me̤dakèe tahe okyǎ ní̤dyédû lahyǎ bí a thòklyěkǔ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Htuô̌rò èthǐ cuốtuố̤ dố vǐ̤ Capernaum rò bí Mò̤́nyěduô nuôtônyěnuô, a cuốnuô̌ dố tè̤cò́bè̌hǒkǔ rò a cuốnuô̌ ithyó pé̤ ǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rò kayǎ tahe khyéthukhyéthè́ lò̌plǐ cò́ Jesǔ a tè̤ithyóithya yěnuôtahe cò́. A ithyó thyá cò́ ná kayǎ dố a o ná a taryěshyosò̌ nuôtahe ithyó nuô cò́, htuô̌to a ithyó khódû ná prè̤ithyó tè̤thyótè̤thya athárá nuôtahe cò́. ");
INSERT INTO kyu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bínuôkhè̌ kayǎphè̌ dố khǐné me̤bè lǔ yětôprè̤nuô, a o dố tè̤cò́bè̌hǒkǔ rò a hyǎhte khyé. ");
INSERT INTO kyu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Rò a è́htǒhtya, “Kố꤮ vǐ̤ Nazarèphú Jesǔ꤮, nè̤ thè́zṳ̂́ me̤ pè̤ phútě? Nè̤ kíré̤ hyǎ me̤pyéme̤kyǎ me̤thyěme̤mé̤ kyǎlò̌hò́ pè̤ pǎ è̌? Nè̤ ma ǔpě nuôma vǎ thè́gně prè́, nè̤ ma Cò́marya aphúkhǔ sǎsè̌ tôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Manárò Jesǔ thè́prwǒ̤ sû khǐnékhǐnò̌, “Thuôthuô꤮ o lahyǎ, htecuốkyǎmò̌ dố kayǎphè̌ yětôprè̤ akǔnuô.” ");
INSERT INTO kyu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Rò khǐnékhǐnò̌ o dố kayǎphè̌ yětôprè̤ akǔ yětôduô̌nuô, a è́htǒè́mo̤ tanyǎ̤tapluố̤ rò a htecuốkyǎ dố kayǎphè̌ nuôtôprè̤ akǔ. ");
INSERT INTO kyu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lò̌꤮ kayǎ obí tè̤cò́bè̌hǒkǔ nuôtahe khyéthukhyéthè́ lò̌plǐ cò́ rò a héhuô ní̤dyé khyělǔ, “Yěma ǐtětě? Yěma tè̤ithyóithya athè̌ è̌? Athyáná a o cò́ ná a taryěshyosò̌ nuô. A hétǎ̤ prè́ angó̤ ná a nò̌htecuốkyǎ khǐné mǔmyá̤ricyá̤ yětahe prè́ rò a ní̤dǎ cò́ lǔngó̤ngó̤,” èthǐ hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yětôphuốrò Jesǔ ari-akyǎ luô̌pasǐ cuốpryǎ lò̌plǐ cò́ dố Galilea ké̤kǔ yěnuô pwǒ̤꤮ tôphocò́. ");
INSERT INTO kyu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesǔ ná a khǒpacè̤̌ tahe htecuốkyǎ dố tè̤cò́bè̌hǒkǔ yě rò èthǐ htecuố lahyǎ dố Simonè ná Andrea ahi. Jakomo ná Giovanni cuố tố̤kuô̌ ná èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bínuô akhè̌ Simonè a prè̤́prè̤mò thè́swíné̤kṳ́ rò omyěotyá̤ prè́ dố lé̤myěkhu prè́, rò tôphuốtuô̌ èthǐ hésoluô̌sû ná Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yětôphuốrò Jesǔ cuố dố lǔo rò a cuốpṳ̂́ lǔtakhu rò a cwikahtò lǔ. Rò a tè̤swí sǐmé̤kyǎ rò a ihtò me̤-eme̤ǒsû pé̤ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bí mò̤́hémò̤́tǎ̤ akhè̌nuô, kayǎ bínuô tahe è́hyǎní̤ kayǎ dố aswíasè̌ tahe ná khǐnékhǐnò̌ me̤bè lǔ tahe dố Jesǔ a o. ");
INSERT INTO kyu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vǐ̤kǔphú pwǒ̤꤮ prè̤ hyǎ oplò́oplu lò̌plǐ lahyǎ dố kadǎ khǎshyé. ");
INSERT INTO kyu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Htuô̌rò tè̤swítè̤sè̌ ǐtětě꤮ bèbè Jesǔ zasǐmé̤ lò̌plǐ cò́. Rò a zasǐmé̤ pé̤ è́nyacò́ kayǎ tahe a tè̤swítè̤sè̌ rò a vè̤́htekyǎ è́nyacò́ khǐnékhǐnò̌ tahe, manárò Jesǔ ma ǔpěnuô khǐnékhǐnò̌ tahe yǒ thè́gně akhu-akhyě, Jesǔ nò̌hébè èthǐ tômû̌꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bí mò̤́lǐ ro̤mû́ mò̤́khíò́ pǎprè́ akhè̌nuô, Jesǔ kahtò cuốcò́bè̌ dố khǎlé̤ dố ǔ o tôprè̤꤮ to tôpho. ");
INSERT INTO kyu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Rò Simonè ná kayǎ dố a otố̤kuô̌ ná lǔ tahe cuố myápṳ̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bí èthǐ myáhtye hò́ Jesǔ akhè̌nuô, èthǐ hé lǔ, “Kayǎ myápṳ̌thû́ lò̌plǐ nè̤,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Rò Jesǔ hésû èthǐ, “Pè̤ ki cuố pó̤ dố dò̌ruô dố a o tavǐtava̤ lahyǎ bíyě tahe pó꤮, rò vǎ ki hésodônyǎ ithyóithya pé̤ èthǐ ná Cò́marya alǎ̤angó̤. Vǎ hyǎ bíyěnuôma tè̤ritè̤kyǎ yěhò́,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Rò a cuốlě tava̤lò̌ Galilea tôké̤lè̤̌ rò a lě hésodônyǎ, ithyóithya pé̤ ǔ ná Cò́marya alǎ̤angó̤ dố Galileaphú tahe a tè̤cò́bè̌hǒkǔ pwǒ̤꤮ tôpho, rò a vè̤́htekyǎ pé̤ ǔ khǐnékhǐnò̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Htuô̌rò kayǎ dố a tè̤sè̌mǔmyá̤ o dố phálo̤ otôprè̤, rò a hyǎ dángṳ̂lya̤ dố Jesǔ khǎshyé rò a kwǐthè́zò̤htya lǔ, “Nè̤ ki thè́plòo zasǐmé̤ pé̤ vǎ tè̤sè̌yě hénuôma nè̤ za cyá̤ prè́,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesǔ thè́zò̤ní̤ lǔ, htuô̌rò a zó̤hyǎ atakhu rò a tôbèhtuô̌ lǔ rò a hé lǔ, “Vǎ thè́plòo prè́,” a hé htuô̌rò “Tè̤sè̌꤮ sǐmé̤kyǎmò̌,” a hé pó̤ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yětôphuốrò tôphuốtuô̌ kayǎphè̌ yětôprè̤ a tè̤sè̌mǔmyá̤ yěnuô sǐmé̤khyékyǎ rò apháazye atwó̤aryáhtya khyěthyá. ");
INSERT INTO kyu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Rò Jesǔ plwǒcuốkyǎ lǔ rò a metǎ̤te̤ cuốní̤ angó̤, ");
INSERT INTO kyu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Héso pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮. Cuố dyéluô̌myá nè̤né̤ yěnuô dố bwídu nuôtôprè̤ a o nuô, htuô̌rò thyáphú kayǎ lò̌plǐ ki myáhtye agněnuô, lǔtyǎhtyatè̤ phú Mosè a tè̤thyótè̤thya onuô ní,” a mecuốní̤ lǔ ngó̤ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Manárò a htecuố hésoluô̌ pé̤ lò̌plǐ ǔ akhu-akhyě, Jesǔ cuốnuô̌ luô̌ lá̤lǐní̤ pǎ dố vǐ̤kǔ to, a bè cuốo prè́ dố vǐ̤klò̌ dố khǎlé̤thuôkrě tahenuô prè́ tadû́rò kayǎ o dố khǎlé̤ pwǒ̤꤮ tôpho hyǎtǒ lò̌ dố lǔo. ");
INSERT INTO kyu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ano thuô̌lwǐ̤nyěnuô Jesǔ ka̤khyě dố vǐ̤ Capernaum akǔ rò kayǎ tahe ní̤huô̌ lahyǎ ná a o dố hi. ");
INSERT INTO kyu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Phúnuôrò kayǎ hyǎ tadwítashya ró̤ talwósû́lû̌ rò bí kadǎklò̌ prè́nuô rò akhǎlé̤ odǎ pǎ cò́ tôpho꤮ to. Jesǔ hésodônyǎ ithyóithyatǎ̤ pé̤ èthǐ ná Cò́marya alǎ̤angó̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bínuô akhè̌ prè̤khǔ thè́lwǐ̤ záhyǎní̤ kayǎné̤ thyětôkyě dố Jesǔ a o tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Manárò kayǎ yǒ oró̤ talwósû́lû̌ akhu-akhyě, èthǐ hyǎnuô̌phûcyá̤ pǎ dố Jesǔ a o to rò a htya me̤plǒ tǒdè̌ hikhuklwó bí Jesǔ oní̤ akhunuô rò a cya̤tǎ̤ kayǎ thyětôkyě yětôprè̤ ná icò̤̌. ");
INSERT INTO kyu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bí Jesǔ myáhtye èthǐ atè̤zṳ̂́tè̤nyá̤ o phúnuô rò a hé kayǎ swí thyětôkyě nuôtôprè̤, “Vǎphú꤮ vǎ plwǒkyǎhò́ nè̤ tè̤thû́ hò́,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bínuô akhè̌ prè̤ithyó tè̤thyótè̤thya athárá tahe onyǎo lahyǎ bínuô rò a tane̤ lahyǎ dố a thè́plòkǔ, ");
INSERT INTO kyu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kayǎ yětôprè̤ a cuố hétuố̤ phúyě me̤tě? È hébèthû́ hò́ Cò́marya hò́. Ǔpě tôprè̤ ki plwǒkyǎ cyá̤ tè̤thû́ pě? Prè̤ plwǒkyǎ cyá̤ tè̤thû́ ma tû́prè́ Cò́marya tôprè̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tôphuốtuô̌ Jesǔ thè́gně èthǐ tè̤tane̤ dố thè́plòkǔ rò a hé èthǐ, “Thǐ cuốtane̤ tuố̤ lahyǎ dố thǐ thè́plòkǔ phúnuôma me̤tě? ");
INSERT INTO kyu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ki vǎ hé kayǎ thyětôkyě yětôprè̤, ‘Vǎ plwǒkyǎhò́ nè̤ tè̤thû́ hò́’ má̤torò ‘Kahtò phyéní̤ nè̤ lé̤myěnuô rò cuố mò̌’ kihéma azǔklò̌ bítě tôcôtě? ");
INSERT INTO kyu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Manárò prè̤lukayǎ aphúkhǔ má̤ vǎyě, thyáphú thǐ ki thè́gně lahyǎ ná dố hekhu yěnuô, vǎ o ná taryěshyosò̌ dố vǎ plwǒkyǎbè́ ǔ tè̤thû́tè̤plá tahenuôrò, vǎ ki dyéluô̌ pé̤ thǐ,” a hé htuô̌phúnuôrò, a hé prè̤thyětôkyě yětôprè̤, ");
INSERT INTO kyu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Vǎ hé nè̤, ihtò talǔní̤ nè̤ klolé̤myě nuôrò ka̤mò̌ dố nè̤ hinuô.” ");
INSERT INTO kyu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Rò tôphuốtuô̌ a ihtò talǔní̤ a klolé̤myě rò a htecuố dố kayǎ lò̌꤮ plǐ a mèthènyě. Kayǎ pwǒ̤꤮ tôprè̤ khyéthukhyéthè́ lò̌plǐ rò htuthè́htya lahyǎ Cò́marya rò a hé lahyǎ, “Tè̤me̤-ané̤ phúyěnuô, pè̤ myáhtyenò́ takhyá꤮ to,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesǔ htecuố khyěthyá dố Galilea htyěò khǎshyé rò kayǎ bè́mṳ hyǎ otava̤ lò̌ khyě lǔ rò a cáhtya ithyóithya pé̤ khyěthyá èthǐ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bí a cuố akhè̌nuô, a myáhtye Alphaeo aphú Levi. È ma prè̤kwǐ amo-arǎ tôprè̤. A myáhtye a onyǎo dố lé̤kwǐamo-arǎ hikǔ rò Byacè Jesǔ hé lǔ, “Krwǒkuô̌ vǎkhyě,” rò Levi kahtò krwǒcuốkuô̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bí Jesǔ ná a khǒpacè̤̌ edǐ mò̤́hé dố Levi hi akhè̌, prè̤kwǐ amo-arǎ tahe ná prè̤oraphú tahe e ǒ tố̤kuô̌ ná èthǐ, me̤těhérò kayǎ dố a krwǒ Jesǔ akhyě tahenuô, a thyáprè́ ná èthǐnuô a oparó̤ è́lǎ. ");
INSERT INTO kyu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bí Pharisěophú dố a ithyó Cò́marya a tè̤thyótè̤thya nuôtahe myáhtye Jesǔ etố̤ǒtố̤ ná prè̤me̤thû́me̤phyetè̤phú tahe ná prè̤kwǐ amo-arǎ tahe akhè̌nuô, a sudyǎ Jesǔ a khǒpacè̤̌ tahe, “Mame̤těrò è cuố etố̤ǒtố̤ kuô̌tuố̤ ná kayǎ kwǐ amo-arǎ nuôtahe ná prè̤oraphú nuôtahe me̤tě?” A sudyǎ lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bí Jesǔ ní̤huô̌ èthǐ sudyǎ phúyě akhè̌nuô, a héka̤khyěsû èthǐ, “Kayǎ dố a oshyo-opryǎ tahenuô, a lo ná tè̤khuthárádu to, kayǎ dố aswíasè̌ tahenuô tû́ma a lo prè́ tè̤khuthárádu prè́. Vǎ hyǎ è́ka̤ kayǎ dố acò́ate̤ nuôtahe má̤to. Vǎ hyǎ è́ka̤prè́ kayǎ dố a tè̤thû́tè̤ora odûgně nuôtahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bínuô akhè̌ Giovanni a khǒpacè̤̌ ná Pharisěophú tahe a duôeduôǒ lahyǎ. Rò kayǎ tahehe hyǎ sudyǎ Jesǔ, “Giovanni a khǒpacè̤̌ ná Pharisěophú a khǒpacè̤̌ tahe duôe sèesèǒ, manárò nè̤ khǒpacè̤̌ tahenuô a duôe kuô̌ǔ sèesèǒ to me̤tě?” A hyǎ sudyǎ lǔ phú nuô. ");
INSERT INTO kyu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Byacè Jesǔ hésû èthǐ ná ngó̤khákho tômû̌ rò a hé, “Bí khǒmè̤̌khǔphè̌ otố̤kuô̌pǎ ná akhǒ sǐpré̤sǐmya̤ akhè̌nuô, a khǒsǐpré̤ yětahe cuốduôeduôǒ cyá̤ phútě? Bí khǒmè̤̌prè̤khǔ cuốkyǎ híto, a dǎ otố̤kuô̌pǎ ná akhǒathyó tahe hénuô, èthǐ duôe cyá̤ sèesèǒ to. ");
INSERT INTO kyu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Shyé꤮ ǔ è́cuố taphǎkyǎhò́ khǒmè̤̌khǔphè̌ hò́ pǎ akhè̌nuô, èthǐ ki duôeduôǒ lahyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ǔ isè́phè hyeca̤lye̤ ná ikè̤̌thè̌ dố a tanuố hítoyě nuô a o tôprè̤꤮ to. Ki isè́phè phúnuô hénuôma ikè̤̌thè̌yě a ki htò́tanuốka̤ rò a lé htò́tazwí lazè̤̌ cuốlyá̤ryá pó̤ hyeca̤lye̤yě pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ǔ zṳ̂nuô̌ htyězǎ̤thè̌ dố htyěǒphálye̤kǔ nuô a o tôprè̤꤮ to. Ǔ ki zṳ̂nuô̌ phúnuô hérò htyězǎ̤ yěnuô a ki thè̌phè́kyǎ htyěǒphálye̤ yětômě pǎ, rò htyězǎ̤ ki lakuố̤kyǎ lò̌ pǎ. Htyězǎ̤ athè̌ yěnuô ǔ bè zṳ̂nuô̌ prè́ lǔ dố htyěǒ athè̌kǔ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bí Mò̤́nyěduô nuôtônyě akhè̌nuô, Jesǔ ná a khǒpacè̤̌ tahe cuốnuô̌cuốbè́ ǔ buốkǔlǎ prè́lé̤khu tahe, rò a khǒpacè̤̌ tahe ipráe cuố ǔ buốkǔlǎthè. ");
INSERT INTO kyu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Rò Pharisěophú tahe hé Jesǔ, “Myámò̌, tè̤me̤ dố èthǐ tǒbè me̤ní̤ to dố Mò̤́nyěduô yětahenuô, èthǐ cuốme̤dû lahyǎ agně phúnuô me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Rò a hésû èthǐ, “Dố nuôkhè̌ bí Davi ná a khǒbò́thyó tahe ladyáeladyáǒ rò a lobè lé̤elé̤ǒ akhè̌nuôrò, a me̤kryá꤮ ǐtětě nuôma thǐ hốnò́ kuô̌nyǎ ǔ to è̌? ");
INSERT INTO kyu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Èthǐ cuốnuô̌ lahyǎ dố Cò́marya ahikǔ rò khò́mǔ dố ǔ lǔhtya ná Cò́marya tahe nuôma a o bínuô, rò ení̤ prè́tû́ prè̤lǔtyǎtè̤phú tahe prè́ tadû́rò Davi ná a khǒpacè̤̌ tahe cuốnuô̌phyée vǎhéto? Bínuôkhè̌ nuôma atǒ ná Abiathar htwǒ bwídukhulố.” ");
INSERT INTO kyu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Byacè Jesǔ hépó̤ èthǐ, “Kayǎ nuôma Mò̤́nyěduô agně má̤to, Mò̤́nyěduô nuôma kayǎ lò̌꤮ plǐ agně. ");
INSERT INTO kyu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Prè̤lu kayǎ aphúkhǔ má̤dû vǎ yěnuôma Mò̤́nyěduô a Byacè cò́ tôprè̤hò́,” a hésû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesǔ kanuô̌ khyěthyá dố tè̤cò́bè̌hǒkǔ rò bínuô tôphonuô, kayǎ takhuthyě o tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A yǒ tǒ ná Mò̤́nyěduô akhu-akhyě, Pharisěophú tahehenuô a thè́zṳ̂́ pṳ̌ pṳ̂́ Byacè Jesǔ atè̤thû́ rò a opò̤́ myá lǔ ná Mò̤́nyěduô yěnuôma a zasǐmé̤ kayǎ dá yětôprè̤ pǎ è̌, ma to è̌ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Rò Jesǔ hé kayǎ takhuthyě tôkhó yětôprè̤, “Hyǎ dố nyěyě.” ");
INSERT INTO kyu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Htuô̌rò a sudyǎ èthǐ, “Pè̤ tè̤thyótè̤thya hé pè̤ ná bí Judaphú a Mò̤́nyěduô akhè̌nuôma, pè̤ tǒbè me̤cwó̤ ǔ è̌? Má̤toma pè̤ tǒbè me̤pyá̤me̤sè̌ ǔ è̌? Pè̤ tǒbè me̤lwóhteka̤ kayǎ tôprè̤prè̤ athè́plò htwǒprè̤ è̌? Má̤torò pè̤ tǒbè me̤thyě ǔ è̌?” Manárò èthǐ dyátaklwo lò̌plǐ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A bèsè̌ Jesǔ athè́plò, me̤těhérò èthǐ khǎlèduô̌ lò̌plǐ cò́ pwǒ̤꤮ tôprè̤, tè̤thè́zò̤ní̤ ǔnuô a o cò́ taki꤮ to akhu-akhyě, Jesǔ myá èthǐ rò a thè́plòdu talwósû́lû̌ rò a hé kayǎ takhuthyě tôkhó yětôprè̤, “Zó̤hte nè̤ takhunuô,” rò a zó̤hte atakhu, rò atakhu ryáka̤khyě plû́lò̌ khyěthyá. ");
INSERT INTO kyu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pharisěophú tahe htecuố taphǎkyǎ rò tôphuốtuô̌ èthǐ cuốoplò́ tố̤ná kayǎ dố a krwǒkuô̌ Khwí Herodè akhyě nuôtahe rò èthǐ cuố okú hébè ní̤dyélǔ ná tǒbè me̤thyě Jesǔ phútě ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesǔ ná a khǒpacè̤̌ tahe htecuố taphǎkyǎ dố Galilea htyěòdu rò kayǎ dố Galilea ké̤kǔ nuôtahe krwǒ ró̤è́꤮ kuô̌ nyacò́ èthǐkhyěcò́. Tahehe nuôma dố Juda ké̤kǔ, ");
INSERT INTO kyu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tahehe nuôma dố vǐ̤ Jerusalem, tahehe nuôma dố Idumea ké̤ ná dố Jordano htyěklǒ cíhte tôkyě, tahehe nuôma a o tavǐtava̤ lahyǎ bí vǐ̤ Tyre ná vǐ̤ Sido yěnuôtahe lò̌꤮ plǐ krwǒkuô̌ lò̌ èthǐ akhyě. Lò̌꤮ kayǎ yětahe nuôma kayǎ dố a ní̤huô̌ lò̌plǐ Jesǔ me̤ tè̤pro̤tè̤prya̤ yětahe rò a krwǒcuốkuô̌ èthǐkhyě prè́. ");
INSERT INTO kyu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesǔ hé a khǒpacè̤̌ tahe ná thyáphú kayǎ bè́mṳdu yětahe ki hyǎ tadwítashya tǎ lǔ tǎmé̤ agněnuô, a nò̌taritaryǎ one èthǐ thòklyě tôbè. ");
INSERT INTO kyu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesǔ cuố hétuố̤ a khǒpacè̤̌ phúyě me̤těhérò a yǒ me̤sǐmé̤ è́nyacò́ hò́ kayǎswíkayǎsè̌ tahe hò́, rò kayǎ dố aswíasè̌ pǎ tahenuô, a yǒ dwíhyǎtǒ lǔ rò kíré̤ hyǎ tôbè lò̌ lǔ akhu-akhyěrò a nò̌me̤ ǔ phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Né me̤bè kayǎ yětahenuô, a myáhtye Jesǔ bíkhè̌tě꤮ bèbè, a lakhû́tǎ̤ dố Jesǔ a mèthènyě rò a è́htǒ lahyǎ, “Nè̤ ma Cò́marya aphúkhǔ tôprè̤,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Rò a thè́prwǒ̤ khǐné nuôtahe, “Vǎ ma ǔpěnuô hésoluô̌ pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Htuô̌rò Jesǔ htya dố solo̤ rò a è́hyǎ kayǎ dố atǒ lǔthè́plò nuôtahe dố a o rò èthǐ hyǎ lahyǎ dố lǔo. ");
INSERT INTO kyu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesǔ nwóphyé a khǒpacè̤̌ shyéthè́nyě̤ rò a hé èthǐ, “Vǎ nwóhtya thǐ ná thǐ tǒbè otố̤kuô̌ ná vǎ htuô̌to vǎ ki nò̌htecuố thǐ pǎ rò thǐ ki cuốhésodônyǎ pé̤ ǔ ná Cò́marya alǎ̤angó̤ pǎ. Rò a è́ ní̤dyé èthǐ yě shyéthè́nyě̤ amwi̤ ná Prè̤dônyǎphú. ");
INSERT INTO kyu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Htuô̌to vǎ ki dyé thǐ tè̤taryěshyosò̌ dố thǐ ki vè̤́htekyǎbè́ khǐné nuôtahe pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesǔ nwóhtya a khǒpacè̤̌ shyéthè́nyě̤ yětahe nuôma kryá꤮ ǔpě hé rò, Simonè (Dố Jesǔ è́thè̌taple lǔmwi̤ ná Petru) ");
INSERT INTO kyu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeo aphúprè̤khǔ Jakomo ná apuố̤ Giovanni, rò Jesǔ è́thè̌taple èthǐmwǐ̤ ná Boanerge. Angó̤lasá ma shyelya̤ a phúprè̤khǔ tahe. ");
INSERT INTO kyu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrea, Philipu, Bartholomeo, Matteo, Thomazo, Alphaeo aphúkhǔ Jakomo, Thaddeo, Simonè dố a mo̤ ní̤dyé ahtyěaké̤ yěnuô tôprè̤, ");
INSERT INTO kyu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ná Juda Iscariot dố a isè̌tǎ̤kyǎ Jesǔ nuôtôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yětôphuốrò Jesǔ ka̤ dố hi. Kayǎ hyǎ oplu-ophè kuô̌lò̌ khyěthyálǔ tuố̤ cò́ dố èthǐ elè́ǒlè́ pǎ cò́ sè to. ");
INSERT INTO kyu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bí a puố̤vyá̤muố̤phè̌ ní̤huô̌ hò́ tè̤me̤-ané̤ phúyě akhè̌nuô, èthǐ htecuố rò a ki cuố cwika̤ lǔ me̤těhérò èthǐ hé lǔzo̤, “A cô ná a tamwǐ,” èthǐ hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Htuô̌rò kayǎ thè́gně tè̤thyótè̤thya o dố vǐ̤ Jerusalem tahe hyǎlya̤ rò a hé lahyǎ, “Khǐnékhǐnò̌ Beelzebul o dố Jesǔ akǔ, rò a yǒ ní̤bè khǐné khuklò́du nuôtahe a taryěpro̤prya̤ tû́rò a vè̤́htekyǎ bè́ prè́ khǐné nuôtahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Rò Jesǔ è́hyǎ èthǐ dố a o rò a hé èthǐ ná ngó̤khákho phúyě, “Khǐnéricyá̤ khuklò́ cuố vè̤́htebè́ cyá̤ khyěthyá khǐnéricyá̤ khuklò́ phútě? ");
INSERT INTO kyu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Htyěké̤phú ná htyěké̤phú ki sá ní̤dyé khyědû lǔ hérò ahtyěaké̤ oklò̤ma plehyǎ ícû̌ tố̤cyá̤ pǎ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hiphúphyǎphú kiklyékingǎ ní̤dyé khyědû lǔ hérò hiphúphyǎphú yě o plehyǎ tố̤cyá̤ pǎ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Phúnuôrò khǐnéricyá̤ khuklò́ ná khǐnéricyá̤ khuklò́ ki sá ní̤dyé khyěthyádûlǔ hérò a taryěshyosò̌ tahenuô, a oklò̤ma cyá̤to. A taryěshyosò̌ tahe ki lamé̤kyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Manárò bí kayǎ tôprè̤ cuốnuô̌ dố khǐnéricyá̤ khuklò́ dố athyáná kayǎshyokayǎsò̌ tôprè̤ ahikǔ akhè̌nuô, a ki nuô̌ cò̌klò̤ma ré̤ lǔ to kihénuô, a nuô̌ phyéphení̤ cyá̤ lǔtǎ̤tè̤ takhyá꤮ to. A cò̌klò̤ma htuô̌ lǔ tû́ma a phyéphe ní̤ cyá̤ lǔ tǎ̤tè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Vǎ hécò́cò́ thǐ, lò̌꤮ prè̤lukayǎ a tè̤thû́ tahe ná lò̌꤮ a hébè mǔmyá̤ricyá̤ Cò́marya tahenuô Cò́marya ki plwǒkyǎ lò̌ èthǐ tè̤thû́ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Manárò kayǎ dố a pacyé̤ishyé Thè́ Sǎsè̌ Byacè nuô Cò́marya plwǒkyǎbè́ pǎ cò́ lǔtè̤thû́ taki꤮ to. Atè̤thû́ yěnuô a ki omacyá̤ lǎ tacṳ́prè̤ talèkrè́ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesǔ cuốhétuố̤ phúyě me̤těhérò, “Khǐnékhǐnò̌ o dố lǔkǔ,” èthǐ yǒ hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesǔ amuố̤ ná a puố̤prè̤khǔ tahe hyǎo kahtò dố hiklò̌ rò a nò̌cuốè́ ǔ ná Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Rò kayǎ è́prè̤ onyǎ tava̤ pluphè lò̌ ná Jesǔ. Ǔ hé Jesǔ, “Myámò̌ dố nuô, nè̤muố̤ ná nè̤ puố̤prè̤khǔ nè̤ puố̤prè̤mò tahe olò̌ dố hiklò̌nuô rò a sudyǎthû́ lahyǎ nè̤.” ");
INSERT INTO kyu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Rò a hésû èthǐ, “Vǎmuố̤ ná vǎ puố̤prè̤khǔ tahema ǔpě?” ");
INSERT INTO kyu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A myá tavǐtava̤ní̤ kayǎ onyǎplu tava̤ lǔ nuôtahe rò a hé, “Yělé, kayǎ dố a o bíyě tahe nuôma má̤hò́ vǎmuố̤ ná vǎ puố̤prè̤khǔ tahehò́. ");
INSERT INTO kyu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kayǎ dố a me̤tǒ phú Cò́marya a tè̤thè́zṳ̂́ nuôtahema má̤hò́ vǎpuố̤vǎvyá̤ tahe ná vǎmuố̤ hò́,” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesǔ cáhtya ithyó pé̤pó̤ ǔ dố htyěòduhtû̌ rò kayǎ hyǎo tava̤plutava̤phè lò̌ è akhu-akhyě a nuô̌ onyǎ o dố thòklyěkǔ rò lò̌꤮ kayǎ nuôtahe rò a o lahyǎ dố htyěhtû̌. ");
INSERT INTO kyu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesǔ ithyóithya kho èthǐ ná ngó̤khákho è́nyacò́. Bí a ithyó èthǐ akhè̌nuô, a hé, ");
INSERT INTO kyu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ní̤dǎ tǎ̤te̤ lahyǎ! Bètôphuố, kayǎ o tôprè̤, a hyǎpruốtǎ̤ tè̤klwǐtè̤lwí. ");
INSERT INTO kyu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bí a pruốtǎ̤ akhè̌, tè̤klwǐ tahehenuô, a latǎ̤tǒ dố klyádè̌kǔ rò htu hyǎihtuôekyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tè̤klwǐ tahehenuô a latǎ̤tǒ dố lò̤́klè̌ hephábû̌khu rò he yǒ phábû̌ akhu-akhyě, a dyáhtya pryǎlè́prè́, ");
INSERT INTO kyu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","rò arwí̤ yǒ sátǎ̤zǎ̤ to akhu-akhyě, bí tamò̤́htya rò a sákṳ́nó amò̤́ tamadyácè̤́ htyayě akhè̌nuô, a thyěkrǎkyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tè̤klwǐ tahehenuô a latǎ̤tǒ dố thòshyáthòprǔklè̌ rò thòshyámò̤́ yětahe duhtya khyábí lò̌plǐ lǔ rò athèhtebè́ tôplò꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tè̤klwǐ tahehenuô a latǎ̤tǒ dố hezyeri̤zyeryákhu rò a phè́htyaduhtyabè́ rò athèhte ní̤è́ pé̤ cò́ aphuố thuô̌shyě tahe, aphuố shyěthuô̌thyó tahe, aphuố tôzè̤ tahe cò́.” ");
INSERT INTO kyu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Htuô̌rò a hé, “Kayǎ dố a o ná akhǎlè tahenuô, nò̌ ní̤dǎ lahyǎ èthǐ.” ");
INSERT INTO kyu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bí a o tû́dû ná a khǒpacè̤̌ shyéthè́nyě̤ ná kayǎ dố a krwǒkuô̌ lǔkhyě tahe akhè̌nuô, èthǐ sudyǎ Jesǔ ná ngó̤khákho yěnuô angó̤lasá. ");
INSERT INTO kyu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Rò a hésû èthǐ, “Cò́marya dyéthè́gněplǒ pé̤hò́ thǐ ná a htyělé̤ké̤kǔ a tè̤thè́khuthè́gně dố a dò́uốdò́bí ní̤dyé yětahe hò́ tadû́rò kayǎ dố aruô tahe agněnuô, ");
INSERT INTO kyu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Èthǐ myá htuô̌ myá thyáthyá cò́ tadû́rò thyáphú èthǐ myáhtye kuô̌ǔ to, èthǐ ní̤dǎ htuô̌ ní̤dǎ thyáthyá cò́ tadû́rò thyáphú èthǐ thè́gněplǒ kuô̌ǔ to,’ agněnuô, vǎ hé pé̤ èthǐ ná ngó̤khákho prè́. Vǎ ki hébè pé̤ èthǐ ná ngó̤khákho to hénuô, ‘Pǎma èthǐ shyalya̤ lahyǎ athè́plò rò Cò́marya plwǒkyǎ èthǐ tè̤thû́ he.’” ");
INSERT INTO kyu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Rò Jesǔ thè́prwǒ̤ èthǐ, “Ngó̤khákhoyě, thǐ ki thè́gněplǒ to hérò, thǐ cuố thè́gněplǒ cyá̤ lò̌꤮ ngó̤khákho dố vǎ hé yěnuô tahe phútě? ");
INSERT INTO kyu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kayǎ dố a pruốtǎ̤ tè̤klwǐ angó̤lasá mamá̤hò́ kayǎ dố a pruốtǎ̤ Cò́marya alǎ̤angó̤ nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kayǎ tahehenuô, athyáná tè̤klwǐ latǎ̤ dố klyádè̌kǔ nuôtahe, èthǐ ní̤huô̌ Cò́marya alǎ̤angó̤ ná tôphuốtuô̌ khǐnéricyá̤ khuklò́ hyǎphyé taphǎphekyǎ Cò́marya alǎ̤angó̤ dố èthǐ thè́plòkǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Dố aruô tahehe kuô̌ke rò athyáná ǔ pruốtǎ̤ tè̤klwǐ dố lò̤́klè̌ hephábû̌khu nuôtahehò́. Èthǐ ní̤huô̌ tôphuốtuô̌ a phyésû ná tè̤thè́krṳ̂̌thè́lò̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Manárò arwí̤ yǒ sátǎ̤zǎ̤ to akhu-akhyě, a htwǒprè̤ taplô̤phú prè́. A zṳ̂́e Cò́marya alǎ̤angó̤ tadû́rò bí tè̤cyě̤tè̤cṳ̂ tè̤mǔmyá̤ricyá̤ hyǎ bè èthǐ akhè̌nuô, tôphuốtuô̌ athè́plò lṳcuốkhókyǎ rò a lakhû́ ka̤khyěkyǎ khyěthyá prè́. ");
INSERT INTO kyu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tahehenuô athyáná tè̤klwǐ latǎ̤tǒ dố thòshyáthòprǔklè̌ nuôtahe hò́. Èthǐ ní̤huô̌ Cò́marya alǎ̤ngó̤ ");
INSERT INTO kyu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","manárò èthǐ yǒ bèkṳ́bèkyǎ̤ ní̤dyé ná a tè̤ohtwǒprè̤ htuô̌rò a yǒ thè́zṳ̂́ duzá̤htyathè̌ lahyǎ akhu-akhyě, èthǐ atè̤thè́zṳ̂́ yěnuô a lahǒ ní̤dyéhò́ èthǐ hò́. Èthǐ thè́zṳ̂́ tè̤tôcô htuô̌ tôcô rò a tè̤thè́zṳ̂́ yětahenuô a iplûkhyábíkyǎ lò̌hò́ lǔ rò athèaphǒ htebè́ pǎtohò́. ");
INSERT INTO kyu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kayǎ tahehenuô athyáná tè̤klwǐ latǎ̤tǒ dố hezyeri̤zyeryákhu nuôtahehò́. Èthǐ ní̤huô̌ Cò́marya alǎ̤angó̤ rò a zṳ̂́e rò athèhtebè́ è́ lốklò̌ cò́ aphuố thuô̌shyě tahe aphuố shyěthuô̌thyó tahe, aphuố tôzè̤ tahe phúnuô cò́.” ");
INSERT INTO kyu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Htuô̌rò Jesǔ hé èthǐ, “Thǐ phyénuô̌ mikò̌ dố hidò́kǔ rò thǐ nuô̌dya è dố cǒ̤lè̤̌ è̌? Má̤torò ma thǐ nuô̌dya è dố lé̤myěrè̤́ alè̤̌ è̌? Thǐ dyahtya è dố mikò̌rè̤́khunuô vǎhéto? ");
INSERT INTO kyu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lò̌꤮ tè̤ me̤uốme̤bí tahenuô, ǔ ki phyéhteluô̌ lò̌ è pǎ. Lò̌꤮ tè̤ dố ǔ thè́gněplǒ to khǒnyá̤yě tahenuô, ǔ ki thè́gněplǒ lò̌ è shyé꤮ nopǎ. ");
INSERT INTO kyu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tè̤ dố thǐ ní̤huô̌ è khǒnyá̤ yětahenuô thǐ tǒ bezṳ̂́ è.” ");
INSERT INTO kyu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Htuô̌rò a hé pó̤ èthǐ, “Ní̤dǎ tǎ̤te̤ lahyǎ vǎ tè̤hébèyě. Nè̤ ki ní̤dǎ tǎ̤te̤ tè̤ hénuôma, Cò́marya ki dyé nè̤ tè̤thè́gněplǒ pǎ, htuô̌to a ki nò̌thè́gně è́htya lốklò̌ pó̤ cò́ nè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kayǎ dố atè̤one cò́hò́ bá꤮ tě bèbè, ǔ lédyé è́htya pé̤pó̤ cò́ lǔ pǎ, manárò kayǎ dố atè̤ o to tôprè̤nuô, atè̤ oprè́ takiphúprè́ bèbè, ǔ ki phyéphekyǎphe lò̌ pó̤ lǔtè̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesǔ hé pó̤, “Cò́marya ahtyěaké̤nuô athyáná kayǎ tôprè̤ pruốtǎ̤ tè̤klwǐtè̤lwí dố hekhu nuô. ");
INSERT INTO kyu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mò̤́khí rò omyě, mò̤́lǐ rò kahtò, mò̤́khí rò omyě, mò̤́lǐ rò kahtò, a me̤ prè́ phúnuô rò tè̤klwǐyě a phè́htya duhtya phútěnuô a thè́gně tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hekhu dyéduhtya ní̤dyédû atè̤ prè́. Amò̤́ tamahtya ré̤lố htuô̌rò aplyǎ̤ hteno, rò athè bǎkò̌no dố khyělố prè́. ");
INSERT INTO kyu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Athè mǐ hyǎ hò́hò́ná a hyǎ kè́ ní̤dyé atè̤thètè̤phǒ yě ná tacě, me̤těhérò kè́buố shuốkhè̌ hyǎtuố̤hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesǔ hé, “Cò́marya ahtyěaké̤ yěnuô pè̤ ki talô byábû̌ cyá̤ pé̤ ǔ phútě? Má̤torò pè̤ ki talô dyéluô̌ cyá̤ pé̤ ǔ ná ngó̤khákho phútě? ");
INSERT INTO kyu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Cò́marya ahtyěaké̤ nuôma athyáná taplèplò nuô. Bí ǔ ivǐtǎ̤ taplèplò dố hekhu akhè̌, dố tè̤klwǐtè̤lwí lò̌꤮ plǐ aklè̌nuô taplèplò ma a patílố ná akhǒ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Manárò ǔ pruốtǎ̤ htuô̌rò a dyáhtya hò́ akhè̌nuô, dố thòtò̤̌mò̤́, ithwídò̌byǎlèmò̤́ aklè̌nuô adulố ǔkhǒ, a phyǎduhtya tahuốhtya lốklò̌ná ǔ rò htuphúzuố̤phú tahe hyǎme̤ lahyǎ apwi̤ dố aphyǎ tahe alo̤ cò́.” ");
INSERT INTO kyu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Bí Jesǔ hésodônyǎ pé̤ ǔ ná Cò́marya alǎ̤angó̤ akhè̌nuô, a dônyǎ nuô̌tố̤ pé̤ ǔ ná ngó̤khákho tahe. Thyáphú ǔ ki thè́gněplǒbè́ ryá nuôrò è́taki a dônyǎ pé̤ ǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A hébè pé̤ kayǎ tahe ná ngó̤khákho tahe tû́prè́ tadû́rò bí a o tû́dû ná a khǒpacè̤̌ tahe akhè̌nuô, a hésoluô̌ pwǒ̤ pé̤ lò̌ èthǐ lò̌꤮ ngó̤khákho angó̤lasá nuô tahe. ");
INSERT INTO kyu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bí nuôtônyě hò́, bí mò̤́hémò̤́tǎ̤ hò́ akhè̌nuô, Jesǔ hé èthǐ, “Pè̤ ki cuố dố htyěò bè́rè̤̌ tôkhó pó꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Rò èthǐ htecuố khókyǎ ná kayǎ bè́mṳ. Rò Jesǔ a khǒpacè̤̌ tahe cuốnuô̌ dố Jesǔ onyǎo ní̤dyé hò́ thòklyě nuôtôbè akǔ rò èthǐ htecuốró̤ lò̌ lǔ. Thòklyě dố aruô okuô̌ bínuô tahe. ");
INSERT INTO kyu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ké̤lathè́ duhyǎ rò htyěháhó nuô̌ dố thòklyěkǔ rò htyě kíré̤ htyabǎ cò́ ná thòklyě cò́. ");
INSERT INTO kyu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Manárò Jesǔ omyě ná mwókuố̤ tômě dố thòipè̤ tôkyě rò èthǐ cuố hturyǎ̤ ihtò lǔ rò a hé lǔ, “Kố꤮ Thárá, pè̤ kíré̤ lacû́thyě lò̌ cò́hò́ rò mame̤tě nè̤ bezṳ̂́ kuô̌ pǎ cò́ pè̤ tôcô꤮ toto?” ");
INSERT INTO kyu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A kahtò thè́prwǒ̤htuô̌ ké̤lathè́ rò a hé htyěháhóyě, “okuố!” A hé rò ké̤lathè́ okuốtôphuố okuố cò́ rò htyěháhó pǎ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A hé èthǐ, “Thǐ thè́isě me̤tě? Thǐ tè̤zṳ̂́tè̤nyá̤ o híto vǎ?” ");
INSERT INTO kyu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Rò èthǐ thè́isě talwósû́lû̌ rò èthǐ hé ní̤dyé khyělǔ, “È ma kayǎ phútě tôprè̤ tě? Ké̤lathè́ ná htyěháhó tahe rò a ní̤dǎ cò́ lǔngó̤ngó̤.” ");
INSERT INTO kyu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesǔ ná a khǒpacè̤̌ tahe cuốtuố̤ dố htyěòdu bè́rè̤̌ Gerasenephú tahe a htyěké̤kǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bí a o dố thòklyěkǔ hte akhè̌nuô, kayǎphè̌ dố khǐné me̤bè lǔ yětôprè̤nuô a o dố luô̤̌khu hte rò a htecuố myáhtyesû ná Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kayǎphè̌ yětôprè̤nuô a cuốo prè́ bí krò̌kǔ ǔ lé̤iluố luô̤̌ akhǎlé̤ yěnuô prè́. Rò ǔ cò̌klò̤ma pé̤ lǔ tôprè̤꤮ to, ǔ cò̌klò̤ma cò́ lǔ ná suplye̤tò̤́htè́ rò a pé̤to. ");
INSERT INTO kyu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ǔ cò̌klò̤ma tamǒtamǒ lǔtakhu ná suplye̤tò̤́htè́ tadû́rò a htò́tû̌kyǎ. Akhǎduô rò ǔ cò̌klò̤ma ná suplye̤tò̤́htè́htè́, tadû́rò a cwitû̌kyǎ prè́prè́. Rò kayǎ dố a me̤pé̤ lǔ nuô, a o tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bí a o dố krò̌kǔ luô̤̌khǎlé̤ akhè̌nuô, ná bí a o dố sokǔ akhè̌nuô, a è́htǒè́mo̤ rò a me̤cume̤htyǎ tamǒtamǒ ní̤dyé lò̌ ané̤ ná lò̤́ pwǒ̤꤮ tôphuố cò́. ");
INSERT INTO kyu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bí a myáhtyecuốlǒ pǎprè́ Jesǔ akhè̌nuô, a klyahyǎtǒ dố lǔo rò a hyǎ dángṳ̂lya̤ dố lǔnyěhyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Rò a è́htǒhtya rò a hé, “Tè̤dutè̤htǔ tadû Cò́marya aphúkhǔ Jesǔ꤮ nè̤ kíré̤ hyǎme̤ kryá꤮ vǎ ǐtě? Vǎ kwǐthè́zò̤ cò́ nè̤ dố Cò́marya a mèthènyě, me̤cyě̤me̤cṳ̂ tǎ vǎ tǎmé̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Me̤těhénuôrò Jesǔ héhtuô̌hò́ lǔ, “Khǐnékhǐnò̌, htecuố taphǎkyǎ dố prè̤khǔ nuôtôprè̤ alo̤,” a héhtuô̌ lǔ phúnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesǔ sudyǎ lǔ, “Nè̤mwi̤ ná ǔpě?” Rò a hésû, “Vǎmwi̤ ná Legion, me̤těhérò pè̤ oró̤oè́ nyacò́,” a hésû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Thyáphú Jesǔ ki vè̤́kyǎ tǎ èthǐ tǎmé̤, rò nò̌htecuốokyǎ tǎ èthǐ dố ké̤klò̌ tǎmé̤nuô, èthǐ kwǐthè́zò̤ tadû cò́ Jesǔ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bínuôkhè̌, htyá tômṳdu kanúe tavǐtava̤phû asè bí sorò̤̌lo̤nuô. ");
INSERT INTO kyu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Khǐnékhǐnò̌ nuôtahe kwǐthè́zò̤ Jesǔ, “Nò̌cuốnuô̌o ré̤ pè̤ dố htyá nuôtahe akǔ rò plwǒnuô̌ ré̤ pè̤ dố htyá nuôtahe akǔ ní,” a kwǐthè́zò̤ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Htuô̌rò Jesǔ nò̌htecuố èthǐ, rò èthǐ htecuốkyǎ dố kayǎphè̌ nuôtôprè̤ ané̤lo̤ rò a cuốnuô̌okyǎ dố htyá nuôtômṳ akǔ. Htyá nuôtômṳ ma a o aduô̌nyě̤rí rò a pá̤tǎ̤ rwó lá̤taprǐ yě alo̤ rò a latǎ̤lacû́ thyěkyǎ lò̌ dố htyěòdukǔ. ");
INSERT INTO kyu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Prè̤kyě̤htyá tahe klyaka̤ dyásoluô̌ cuốpye̤ pé̤lò̌ ǔ dố vǐ̤kǔ ná dốdò̌dốso tahe akǔ ná tè̤ritè̤kyǎ yětahe. Rò a me̤kryáané̤ phútěnuô ǔ hyǎmyá lahyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Rò èthǐ hyǎ dố Jesǔ a o rò a myáhtye kayǎphè̌ dố khǐné htecuốkyǎ dố lǔkǔ nuôtôprè̤ onyǎ bínuô rò a kû̌htyathyáhtya ryákhyě ahyeca̤ rò athè́plò ryáka̤khyě khyěthyá. Kayǎ tahe myáhtye lǔ rò a thè́isě lò̌plǐ cò́ lǔlé̤. ");
INSERT INTO kyu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kayǎ dố a myáhtye khǐnékhǐnò̌ htecuốkyǎ dố kayǎphè̌ nuôtôprè̤ akǔ ná htyá nuôtahe me̤kryá ané̤ phútě nuô, èthǐ cuố héso pé̤ lò̌ǔ dố aruô. ");
INSERT INTO kyu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kayǎ tahe cáhtya kwǐthè́zò̤ Jesǔ ná a ki htecuố taphǎkyǎ ná èthǐ ké̤kû̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bí Jesǔ nuô̌ dố thòklyěkǔ akhè̌nuô, kayǎphè̌ dố khǐné htecuốkyǎ dố lǔkǔ nuôtôprè̤ kwǐthè́zò̤ lǔ, “Khyáthè́dǒ è́krwǒcuố pé̤kuô̌ ré̤ vǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Manárò Jesǔ è́krwǒní̤ lǔ to, a hé lǔ, “To, ka̤ dố nè̤ hinuô rò ka̤hésoluô̌ pé̤kuô̌ré̤ nè̤ puố̤vyá̤muố̤phè̌ ná Byacè me̤ryá pé̤ cò́ nè̤ bá꤮ těnuô ná a tè̤thè́zò̤ní̤ nè̤ phútě nuô ní꤮,” a héhtuô̌ lǔ phúnuôrò, ");
INSERT INTO kyu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","kayǎ dố khǐné htecuốkyǎ dố lǔkǔ nuôtôprè̤ htecuố rò a cáhtya lě héso pé̤ ǔ pwǒ̤tôdò̌ dố ké̤tôké̤ ǔ è́ ná “Vǐ̤ shyé” akǔ rò Jesǔ me̤pé̤ kryá꤮ è phútěnuô ná kayǎ lò̌꤮ plǐ tapa̤ khyéthukhyéthè́ lò̌ kryá꤮ phútěnuô a cuố dônyǎluô̌ pé̤ lò̌ǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Bí Jesǔ ka̤khyě khyěthyá dố htyěòdu bè́rè̤̌ tôkyě ná thòklyě akhè̌nuô, kayǎ bè́mṳ hyǎ oplò́oplu ró̤è́ nyacò́ dố htyěòdu htû̌ nuô. ");
INSERT INTO kyu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Rò tè̤cò́bè̌hǒ khuklò́du tôprè̤, amwi̤ ná Jairus hyǎmyáhtye Jesǔ rò a dángṳ̂lya̤ dố lǔkhǎduô shyé. ");
INSERT INTO kyu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Rò a kwǐthè́zò̤ lǔ, “Vǎ phúprè̤mòphú tôprè̤ kíré̤ thyěhò́ rò thyáphú atè̤swí ki sǐmé̤kyǎ rò a ki htwǒprè̤ nuô, cuố dyahtya pé̤ré̤ vǎ nè̤ takhu dố alo̤.” ");
INSERT INTO kyu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Rò Jesǔ krwǒka̤kuô̌ lǔ. Kayǎ tôplutôphè tadwítashya cuố kuô̌ lò̌ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bínuô aklè̌ prè̤mò dố a khyábè tè̤sè̌thwitǎ̤ dố anyě̤ cò́hò́ shyényě̤na nuô a o tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tè̤khuthárá è́prè̤ myákhwèní̤ lǔ tadû́rò a yakhye to. A za ní̤dyé ané̤ rò arû̌ahtè̌ lò̌hò́ tadû́rò a yakhyehyǎtó̤ lǔ to, atè̤sè̌ yěnuô taklya ná a me̤shyohyǎ ná shyohyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A ní̤huô̌ Jesǔ ari-akyǎ rò a dwíhyǎnuô̌ dố kayǎ oró̤oè́klè̌ rò a hyǎtuố̤ dố Jesǔ khyěkhu rò a hyǎtô lǔ ca̤cwo̤. ");
INSERT INTO kyu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","A héní̤ ané̤, “Vǎ ki tôbè prè́bí aca̤cwo̤ yěnuôprè́ ma vǎ tè̤sè̌thwitǎ̤ yě a klyá sǐmé̤ nyǎ hò́,” a hé rò, ");
INSERT INTO kyu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tôphuốtuô̌ athwihyǎ okuố rò a thè́gně ní̤dyé ané̤ ná atè̤sè̌ yěnuô a lamé̤kyǎhò́. ");
INSERT INTO kyu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yětôphuốrò Jesǔ thè́gně ní̤dyé ané̤ ná a tè̤pro̤tè̤prya̤ htecuốkyǎ dố ané̤lo̤. A taríhtǒtarílya̤ ané̤ dố kayǎ oró̤oè́klè̌ rò, a sudyǎ ǔ, “Maǔpě tôbè vǎ ca̤cwo̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rò a khǒpacè̤̌ hésû lǔ, “Nè̤ myáhtyedûhò́ ná kayǎ o tava̤plutava̤phè tadwítashya lò̌ nè̤ rò mame̤těrò nè̤ cuốsudyǎ tuố̤, ‘Maǔpě tôbè vǎ ca̤cwo̤ pě phútě?’” ");
INSERT INTO kyu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Thyáphú a ki myáhtye kayǎ dố a hyǎ tôbè lǔ nuôtôprè̤ rò a myáka̤myáhyǎ tadû. ");
INSERT INTO kyu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Rò prè̤mò yětôprè̤nuô bí a hyǎtôbè lǔ ca̤cwo̤ akhè̌, tè̤htwǒhtya-ané̤ ná è phútěnuô a thè́gnělya̤ ní̤dyé ané̤ akhu-akhyě, a thè́isě tanyǎ̤tadè rò a hyǎdángṳ̂lya̤ dố Jesǔ mèthènyě rò a hésoluô̌ cò́ pé̤ lò̌plǐ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Rò Jesǔ hé lǔ, “Phúmò꤮, nè̤ tè̤zṳ̂́ yěnuô, a zasǐmé̤kyǎhò́ nè̤ tè̤sè̌hò́, ka̤mo̤mo̤ ka̤ryáryá dû ní꤮, nè̤ tè̤sè̌ yě a lamé̤ lǎnyǎdûhò́.” ");
INSERT INTO kyu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bí Jesǔ hébèpǎprè́ akhè̌nuô, kayǎ tahe o dố Jairus dố a htwǒ tè̤cò́bè̌hǒ khuklò́ yětôprè̤ ahi hyǎ, rò a hyǎhéso pé̤ Jairus, “Nè̤phúmò thyěhò́. Rò thǐ cuốme̤dídyǎ tadûpǎ Thárá me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Manárò Jesǔ ní̤dǎ èthǐ atè̤hébè to. A hé tè̤cò́bè̌hǒ khuklò́du nuôtôprè̤, “Bèzò̤ tǎmé̤, tarú zṳ̂́e vǎnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Htuô̌rò a è́krwǒní̤ prè́tû́ Petru, Jakomo ná apuố̤ Giovanni prè́. A è́ní̤ kayǎ dố aruô tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Èthǐ cuốtuố̤ dố tè̤cò́bè̌hǒ khuklò́du nuôtôprè̤ ahi rò a myáhtye ǔ me̤pra̤rû́pra̤tè́ tahe, ǔnguố̤ǔhè tahe. ");
INSERT INTO kyu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bí a nuô̌ dố hidò́kǔ akhè̌, a hé èthǐ, “Thǐnguố̤thǐhè me̤tarû̌tapyǎ me̤tě? Pacè̤̌muố̤phú yětôprè̤ma a thyě má̤to. A omyění̤ sǒtapa̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Rò èthǐ nyě̤kruô̌ lò̌plǐ Jesǔ. Htuô̌rò Jesǔ vè̤́htekyǎ lò̌꤮ kayǎ nuôtahe dố aklò̌ rò a è́ní̤ pacè̤̌muố̤phú yětôprè̤ amuố̤aphè̌ ná a khǒpacè̤̌ thè́thuô̌ rò a kanuô̌ dố pacè̤̌phú nuôtôprè̤ a o. ");
INSERT INTO kyu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Rò a pṳ̂́ pacè̤̌phú nuôtôprè̤ atakhu rò a hé lǔ, “Talí thakúmi” (Angó̤lasá ma, “Kố꤮ pacè̤̌muố̤phú꤮ vǎ hé nè̤꤮ kahtòmò̌.”), ");
INSERT INTO kyu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","rò tôphuốtuô̌ pacè̤̌muố̤phú shyényě̤na yětôprè̤ kahtòcuố rò èthǐ khyéthukhyéthè́ nyacò́ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Rò Jesǔ mekyǎ tǎ̤te̤ èthǐ ngó̤, tǒbè hésoluô̌ní̤ pé̤ ǔ tôprè̤꤮ to, htuô̌rò a hé èthǐ, “Dyée pé̤ pacè̤̌muố̤phú nuôtôprè̤ lé̤elé̤ǒ tôcôcô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesǔ htecuốkyǎ bínuô rò è ná a khǒpacè̤̌ tahe ka̤khyě khyěthyá lahyǎ dố adò̌aso ní̤dû vǐ̤ Nazarè nuôtôvǐ̤. ");
INSERT INTO kyu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bí Mò̤́nyěduô akhè̌nuô, Jesǔ cáhtya ithyóithya tè̤ dố tè̤cò́bè̌hǒkǔ. Kayǎ è́prè̤ ní̤huô̌ a tè̤ithyóithya rò a khyéthukhyéthè́ lò̌ cò́ rò a hé lahyǎ, “A tè̤thítè̤phè́ yěnuô ná atè̤me̤ tè̤pro̤tè̤prya̤ lò̌꤮ plǐ yětahe nuôma a cuốní̤bè tǒ bítětě? A tè̤thítè̤phè́ dố a ní̤bè yětahe nuôma tè̤thíphè́ phútětôcô tětě? Htuô̌rò a cuốme̤ cyá̤ tuố̤ tè̤pro̤tè̤prya̤ yětahe nuôma phútětě? ");
INSERT INTO kyu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","È ma prè̤sò́cyá̤hi nuôtôprè̤ vǎhé? Rò è ma Maria aphúprè̤khǔ vǎhé? Apuố̤ tahe nuôma Jakomo, Jose, Juda, ná Simonè yětahe má̤ vǎhéto? Rò apuố̤prè̤mò tahe nuôma a o prè́ bí dò̌kǔyě prè́ vǎhéto?” Èthǐ hé lahyǎ phúnuôrò, èthǐ thè́hte Jesǔ rò è́mo̤sû lǔ to. ");
INSERT INTO kyu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Rò Jesǔ hé èthǐ, “Kayǎ dố a dyazṳ̂́dyanyá̤ ní̤dyékuô̌ prè̤pro̤ to tahe nuôma tû́prè́ adò̌kǔphú ní̤dû, aklwǐalyǎ ní̤dû ná a hiphúphyǎphú ní̤dû tahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Èthǐ zṳ̂́e to akhu-akhyě Jesǔ me̤cyá̤ pǎ atè̤me̤ tè̤pro̤tè̤prya̤ nuôtahe tôcô꤮ to, a me̤cyá̤kyǎ prè́tû́ a dyahtya atakhu dố kayǎ swísè̌ nuôtahe alo̤ prè́, rò a me̤ sǐmé̤ pé̤ kayǎswíkayǎsè̌ tahe patíprè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Dò̌phúsophú tahe zṳ̂́ení̤ lǔ to akhu-akhyě a khyéthukhyéthè́ kanó̤꤮ to. Yětôphuốrò Jesǔ htecuốlě dò̌ dố a o tavǐtava̤ bínuô tôdò̌htuô̌tôdò̌ rò ithyóithya pé̤ ǔ. ");
INSERT INTO kyu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Htuô̌rò a è́hyǎ plò́lò̌ a khǒpacè̤̌ shyéthè́nyě̤ rò a nò̌htecuố lǔ tômṳ ná thè́nyě̤ phúnuô. Htuô̌rò thyáphú èthǐ ki vè̤́htekyǎbè́ khǐnékhǐnò̌ agněnuôrò, a dyé pé̤ èthǐ taryěshyosò̌. ");
INSERT INTO kyu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jesǔ mecuốní̤ a khǒpacè̤̌ tahe angó̤, “Thǐ htecuốklyá rò phyécuốní̤ tǎ tôcô꤮ tǎmé̤ ní, phyécuốní̤ tǎ khò́mǔ, pyě̤, ná rû̌htò̌ yěnuôtahe tǎmé̤ ní꤮. Phyéní̤ prè́tû́ ihtyábǒ nuô prè́ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Dyácuốní̤ lahyǎ khuphá nuô manárò phyécuố tǎ ca̤ nyě̤pṳ̂ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Thǐ ki cuốnuô̌ o dố hi tôměmě akǔ hérò, thǐ dǎ htecuố hí dố dò̌ nuôtôdò̌ akǔ híto nuô, tarú o tadû lahyǎ bínuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dò̌ tôdò̌dò̌ dố a ki thè́zṳ̂́ è́sû thǐ to rò a ki ní̤dǎ thǐngó̤ to hérò bí thǐ htecuốkyǎ akhè̌nuô, thuô̌tǎ̤kyǎ hemû dố thǐ khǎduôlo̤ nuôtahe, thǐ ki me̤phúnuô héma athyáná thǐ dyéluô̌kyǎhò́ tè̤mátè̤dyǎ tôcô dố Cò́marya ki cirya èthǐ pǎ nuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A khǒpacè̤̌ tahe htecuốlě hésodônyǎ pé̤ kayǎ tahe ná a tǒkò za̤ ní̤dû lahyǎ ané̤, a lě héso pé̤ ǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Èthǐ vè̤́htekyǎní̤ è́lǎ khǐnékhǐnò̌ rò a plò̤́ró̤ní̤ è́ pé̤ lǎ kayǎswíkayǎsè̌ tahe ná htahtyě rò a me̤sǐmé̤ ka̤khyě è́ pé̤ lǎ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesǔ amwi̤ luô̌htyěluô̌ké̤ akhu-akhyě Khwí Herodè ní̤huô̌ lò̌lò̌꤮ a me̤ tè̤ nuôtahe ari-akyǎ. Htuô̌to kayǎ tahehe hé lahyǎ, “Jesǔ ma Giovanni Baptista thyěihtòka̤khyě prè́, tû́rò a me̤cyá̤ tè̤pro̤tè̤prya̤ nuôtahe hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Taheherò a hé, “È ma Prè̤pro̤ Elia prè́.” Htuô̌to tahehe rò a hé, “È ma prè̤pro̤ khòkedû tôprè̤ dố athyáná prè̤pro̤ dố꤮ nyénu aklè̌ tôprè̤prè̤ prè́,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bí Khwí Herodè ní̤huô̌ Jesǔ me̤ tè̤pro̤tè̤prya̤ akhè̌nuô, a hé, “Giovanni dố vǎ nò̌pǎ̤tṳ̂̌kyǎ èkyǎ̤bǒ ná vǎ klyěphú nuôtôprè̤ htwǒprè̤ ka̤khyě khyěthyá hò́,” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Dố aré̤khè̌nuô ma Khwí Herodè nò̌cuốpṳ̂́ cò̌klò̤ma aklyěphú tahe ná Giovanni rò a nò̌dò́tǎ̤kyǎ lǔ dố htò̌kǔ nuôma Herodia khukhyě hò́. Herodia ma Khwí Herodè akhǐ, apuố̤ Philipu amě rò Giovanni hétǎ̤tṳ̂̌ tamǒmǒ Khwí Herodè ná a tǒ phyéní̤ apuố̤ Philipu amě to. ");
INSERT INTO kyu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Giovanni hé Khwí Herodè, “Nè̤ phyé khyěthyá nè̤ khǐnuô a lṳkhókyǎ hò́ ná Cò́marya tè̤thyótè̤thya hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Phúnuô akhu-akhyěrò khwí amě Herodia yěnuô a pṳ̂́ma tadû Giovanni tè̤thû́ rò a thè́zṳ̂́ me̤thyěkyǎ lǔ tadû́rò a me̤cyá̤ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Me̤těhérò Khwí Herodè yěnuô a myádu ní̤dyé Giovanni, me̤těhérò a thè́gně ná è ma kayǎ dố acò́ate̤ asǎsè̌ tôprè̤ akhu-akhyě, a takè̤bí ní̤dyé lǔ. Bí khwí ní̤huô̌ Giovanni hébè akhè̌nuô, a bèzò̤ nyacò́ tadû́rò a thè́zṳ̂́ ní̤huô̌ nyǎprè́ lǔ hébè prè́. ");
INSERT INTO kyu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bí Khwí Herodè opacè̤̌lya̤ amò̤́nyě hyǎtuố̤khyě akhè̌nuô, ashuốakhè̌ ryányacò́ dố Herodia ki me̤thyěkyǎ Giovanni. Khwí me̤pwè̌ ní̤dyé a opacè̤̌lya̤ amò̤́nyě rò a buôebuôǒ klyě khuklò́khuklyǎ tahe, htyěké̤ khuklò́khuklyǎ tahe, ná kayǎ htwǒ khuklò́khuklyǎ dố Galilea ké̤kǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bí Khwí Herodè amě Herodia aphúprè̤mòphú hyǎnuô̌ ilě akhè̌nuô, a me̤ thè́plòmo̤ thè́plòmǐ ní̤ Khwí Herodè ná asǐpré̤ lò̌꤮ plǐ khukhyě Khwí Herodè hé pacè̤̌muố̤phú yěnuô tôprè̤, “Nè̤ thè́zṳ̂́thè́lò̌ ǐtěnuô héso vǎ, vǎ ki dyé nè̤.” ");
INSERT INTO kyu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Htuô̌rò a ò́lya̤ rò a byǎní̤ angó̤ ná a tè̤hébè phúnuô rò “Nè̤ kwǐ cò́ vǎ ǐtě꤮ bèbè vǎ ki dyé nè̤ pǎ, nè̤ kwǐ cò́ vǎhtyěvǎké̤ taklǎmě cò́ bèbè, vǎ dyébè́ nè̤ pǎ,” a ò́lya̤ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Rò pacè̤̌muố̤phú nuôtôprè̤ klyahte dố aklò̌ rò htesudyǎ amuố̤, “Muố̤꤮ vǎ tǒbè kwǐ khwí ǐtětě?” “Kwǐ Giovanni Baptista a khuklò́nuô” amuố̤ hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Rò a tapluố̤taplyě klyakanuô̌ khyěthyá dố khwí o rò “Vǎ thè́zṳ̂́ nò̌dya nuô̌ nè̤ Giovanni Baptista akhuklò́ dố dǐbě taè̌dukǔ rò hyǎdyé cò́ vǎ khǒnyá̤yěnuô” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Khwíyě a thè́plòmo̤ pǎtaki꤮ to tadû́rò a yǒ ò́lya̤ htuô̌hò́ dố sǐpré̤ tôplutôphè a mèthènyě hò́ akhu-akhyě ngó̤ dố a ò́lya̤ htuô̌hò́ ná pacè̤̌muố̤phú yěnuô, a thè́zṳ̂́ me̤pyékyǎ to. ");
INSERT INTO kyu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Phúnuôrò tôphuốtuô̌ a nò̌cuốphyé aklyěphú prè̤opò̤́tè̤ nuôtôprè̤ ná Giovanni akhuklò́ rò aklyěphú yětôprè̤ cuố dố ǔ lé̤dò́o kayǎ htò̌kǔ rò a cuốpǎ̤tṳ̂̌ ka̤ Giovanni akyǎ̤bǒ. ");
INSERT INTO kyu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Htuô̌rò a dyanuô̌ Giovanni a khuklò́yě dố dǐbětaè̌du akǔ rò a hyǎdyé ná pacè̤̌muố̤ nuôtôprè̤ rò pacè̤̌muố̤yě dyé ná amuố̤. ");
INSERT INTO kyu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Giovanni Baptista a khǒpacè̤̌ ní̤huô̌ rò èthǐ hyǎphyéka̤ lǔ né̤klò̤́ okyǎyě rò ka̤ iluốkyǎ lǔ dố luô̤̌khu. ");
INSERT INTO kyu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Prè̤dônyǎphú tahe ka̤-oplò́ tava̤lò̌ Jesǔ rò èthǐ héso pé̤lò̌ lǔ ná lò̌꤮ èthǐ me̤htuô̌hò́ tè̤nuôtahe ari-akyǎ ná èthǐ ithyóithya pé̤ ǔ nuôtahe ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Prè̤ hyǎ dố lǔo rò hyǎ, prè̤ka̤ rò ka̤ oró̤oè́ talwósû́lû̌ khukhyě Jesǔ ná a khǒpacè̤̌ tahe lé̤okuố eǒ ashuốkhè̌nuô꤮ a opǎ cò́ to, rò Jesǔ hé a khǒpacè̤̌ tahe, “Pè̤ cuố ró̤lǔ dố khǎlé̤thuôkrě tôpho dố kayǎ o tôprè̤꤮ to nuô rò pè̤ ki okuố tabè́thè́prá taplô̤phú pó꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Rò Jesǔ ná a khǒpacè̤̌ tahe cuốnuô̌ sidyání̤ thòklyě rò htecuốkyǎ lahyǎ tû́dû dố khǎlé̤thuôkrě tôpho. ");
INSERT INTO kyu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Manárò kayǎ è́prè̤ dố a myáhtye èthǐ cuố yětahenuô, a thè́gně tǎ̤te̤ lahyǎ hò́ ná Jesǔ ná a khǒpacè̤̌ tahe má̤nyǎhò́ akhu-akhyě, vǐ̤phú pwǒ̤tôvǐ̤ klyacuố ná khǎduô dố khǒkhu rò klyacuốtuố̤ ré̤ dố Jesǔ ná a khǒpacè̤̌ tahe anyěhyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bí Byacè Jesǔ o dố thòklyěkǔ hte akhè̌nuô, a myáhtye kayǎ bè́mṳdu cuố opò̤́ one ré̤ lò̌hò́ dố nyěhò́ rò a thè́zò̤ ní̤dyé nyacò́ èthǐ cò́, me̤těhérò kayǎ yětahenuô athyáná thímí tahe dố prè̤kyě̤ o lǔ to nuô akhu-akhyě a cáhtya ithyó è́pé̤ nyacò́ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bínuô akhè̌ mò̤́hélǎ hò́ rò Jesǔ a khǒpacè̤̌ tahe hyǎ dố lǔo rò a hyǎhé lǔ, “Khǎlé̤ bíyětôpho ma dò̌ ophû tôdò̌꤮ to, htuô̌to mò̤́hélǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Thyáphú èthǐ ki cuốlě ipri̤-epri̤ǒ ní̤dyé lahyǎ dû asèesèǒ agněnuôrò, nò̌cuốkyǎ mò̌ èthǐ dố dò̌kǔsokǔ dố a o tavǐtava̤ bíyě tôpho nuô.” ");
INSERT INTO kyu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Manárò Jesǔ hésû èthǐ, “Myá dyéedyéǒ pé̤ èthǐ tôcôcô nuô.” Rò èthǐ sudyǎ lǔ, “Pè̤ ki cuốipri̤ pé̤ èthǐ khò́mǔ rò alò̌ krṳ̂nya̤kǒ ná prè̤me̤tè̤phú tôprè̤ alè̌kè lè̌lwǐ̤thyó cò́ kǒkǒ, rû̌zye denari o prè́ tôkoko꤮ tuô̌ prè́ rò a kíré̤ cuố pòepòǒ èthǐ phútě?” ");
INSERT INTO kyu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesǔ sudyǎ a khǒpacè̤̌ tahe, “Dố thǐklè̌nuô khò́mǔ o báklò̤́tě? Cuốmyámyá,” a hé èthǐ phúnuô akhè̌, èthǐ cuốmyá rò èthǐ myáhtye prè́, “Khò́mǔ nyǎ̤klò̤́ ná tè̤̌phú nyě̤bè prè́,” èthǐ hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Htuô̌rò Jesǔ nò̌onyǎ oplò́ èthǐ tômṳ ná tômṳ dố mi̤thuô̌lè̌khu. ");
INSERT INTO kyu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rò èthǐ onyǎoplò́ lǔ tômṳ ná aprè̤ nyǎ̤shyě tahe aprè̤ tôzè̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesǔ phyé khò́mǔ nyǎ̤klò̤́ ná tè̤̌ nyě̤bèyě rò a tṳ́htya dố mò́lè̤̌ rò a hébwíhétaryě htuthè́htya Cò́marya rò ibikyě khò́mǔ. Htuô̌rò a dyétǎ̤ dố a khǒpacè̤̌ tahe a o. Rò a khǒpacè̤̌ tahe zṳ́etǎ̤ dǐtû́ pé̤ ná kayǎ nuôtahe. Htuô̌rò a zò́kè̤́khǎkwo kuô̌ tè̤̌phú nuônyě̤bè phúnuônuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Èthǐ e pòepòǒ ekò́ǒbǎ lò̌plǐ cò́ pwǒ̤꤮ tôprè̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A khǒpacè̤̌ tahe phyédwóplò́ khyěthyá khò́mǔ ná tè̤̌phú dố a ibikyě rò a okyǎlố tahenuô a obǎ pǎ cò́ ná krí̤nuô shyényě̤mě cò́. ");
INSERT INTO kyu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Prè̤khǔdu dố a e khò́mǔ lò̌꤮ plǐ nuôma a o kayǎ nyǎ̤rí. ");
INSERT INTO kyu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Èthǐ ihtuôplò́ htuô̌htuô̌ ná Jesǔ nò̌cuốnuô̌ sidyá lò̌ a khǒpacè̤̌ tahe dố thòklyěkǔ rò a nò̌htecuố ré̤kyǎ èthǐ dố vǐ̤ Bethsaida dố a o dố htyěòbè́rè̤̌ nuôtôvǐ̤. Rò bí a khǒpacè̤̌ htyasidyá thòklyě akhè̌nuô, è rò a plwǒka̤kyǎ lò̌plǐ kayǎ bè́mṳ. ");
INSERT INTO kyu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Htuô̌rò Jesǔ htecuốkyǎ rò a cuốhtya cò́bè̌ dố sokhu. ");
INSERT INTO kyu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bí mò̤́khípaló̤ hyǎ hò́ akhè̌nuô, a khǒpacè̤̌ thòklyě cuốtuố̤ hò́ dố htyěklǎmě hò́ tadû́rò Jesǔ okyǎ tû́dû prè́ dố khǒkhu tôprè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesǔ myáhtye ná ké̤lathè́ yǒ htò̌hyǎsû a khǒpacè̤̌ tahe akhu-akhyě, èthǐ khyǎsû ké̤lathè́ rò a thè́práladyá lò̌plǐ. Bí shyěi-utazè̤̌ mò̤́ kíré̤ lǐbǔhò́ akhè̌nuô, Byacè Jesǔ cuố dố htyěkhu rò hyǎtǒ dố a khǒpacè̤̌ tahe a o. A kíré̤ cuốtalwó ná a khǒpacè̤̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Manárò bí a khǒpacè̤̌ tahe myáhtye lǔ cuố dố htyěkhu akhè̌nuô, èthǐ tane̤ lǔ ná luô̤̌taprya̤ rò a è́htǒè́mo̤ lò̌plǐ. ");
INSERT INTO kyu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Me̤těhérò èthǐ pwǒ̤꤮ tôprè̤ myáhtye lò̌plǐ lǔ rò thè́isě lò̌plǐ cò́. Tôphuốtuô̌ Jesǔ hé èthǐ, “Dyakhû̌dyahǎ lahyǎ thǐ thè́plò. Thè́isě lahyǎ tǎmé̤, yěma vǎ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Htuô̌rò a htyanuô̌kuô̌ dố a khǒpacè̤̌ tahe a thòklyěkǔ rò ké̤lathè́ okuốhyǎkyǎ rò a khǒpacè̤̌ tahe khyéthukhyéthè́ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Me̤těhérò èthǐ yǒ khǎlèduô̌ akhu-akhyě Jesǔ dyéluô̌ pé̤ cò́ èthǐ ná buôe ǔ khò́mǔ atè̤me̤ tè̤pro̤tè̤prya̤ yě cò́ tadû́rò èthǐ thè́gněplǒ lahyǎ to. ");
INSERT INTO kyu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Èthǐ cuốbè́ hò́ htyěòduyě rò a cuốtuố̤ lahyǎ dố Gennesaret ké̤ rò a cuố báokuố lahyǎ athòklyě bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Èthǐ hte hò́ dố thòklyěkǔkǔ ná kayǎ tahe thè́gnětǎ̤te̤no lahyǎ ná Jesǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Èthǐ klyahtǒklyalya̤ lò̌ lahyǎ rò a cáhtya záhyǎ lahyǎ kayǎswíkayǎsè̌ tahe ná icò̤̌ rò záhyǎtǒ lahyǎ bí èthǐ ní̤huô̌ ná Jesǔ o ní̤dyé akhǎlé̤ nuôtôpho. ");
INSERT INTO kyu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Byacè Jesǔ cuốtǒ bítě꤮ tôpho bèbè, a cuố dố dò̌kǔ bèbè, a cuố dố vǐ̤kǔ bèbè, a cuố dố vǐ̤klò̌ bèbè, èthǐ dyatǎ̤ lahyǎ kayǎswíkayǎsè̌ tahe dố klè́kǔ rò èthǐ kwǐthè́zò̤ Byacè ná nò̌tôbè prè́ nè̤ ca̤htû̌ yěnuô ná prè̤swí prè̤sè̌ yětahenuô takiphúprè́. Rò kayǎ dố a tôbè lǔ ca̤htû̌ tahenuô, a tè̤swítè̤sè̌ lamé̤ lò̌plǐcò́. ");
INSERT INTO kyu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bínuô akhè̌ prè̤ithyó tè̤thyótè̤thya athárá ná Pharisěophú dố a o lahyǎ dố vǐ̤ Jerusalem akǔ hyǎ tahenuô, a hyǎ oplò́oplu tava̤ lò̌plǐ dố Jesǔ khǎshyé. ");
INSERT INTO kyu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Èthǐ myáhtye Byacè a khǒpacè̤̌ tahe esèe rò a sǐplǐ kuô̌ǔ atakhu to. Angó̤lasá ma èthǐ thè́zṳ̂́ hé ná phú tè̤cò́bucò́bè̌ alé̤klǒ o ná bí e tyahí sè to akhè̌ tǒbè sǐplǐ ré̤ takhu tadû́rò a khǒpacè̤̌ tahe me̤kuô̌ phúnuô to. ");
INSERT INTO kyu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Me̤těhénuôrò Pharisěophú tahe ná lò̌꤮ Judaphú tahenuô a ki sǐplǐ lahyǎ atakhu tuố̤dố takhutarǎ tû́rò èthǐ phyéeno sèesèǒ prè́, èthǐ pṳ̂́maní̤ lahyǎ èthǐ phyěphuô̌ lé̤klǒ tahe. ");
INSERT INTO kyu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Èthǐ ki o dố klè́ ka̤ hérò a ki sǐplǐsǐplè̤́kyǎ atakhu to hénuô, èthǐ eǒ tôcô꤮ to. Htuô̌to èthǐ pṳ̂́maní̤ tadûpǎ lé̤klǒ dố aruô tahenuô a o è́lǎ pǎ. Kryá꤮ maǐtě hérò, èthǐ sǐplǐ ryá bělé̤ǒ tahe, dǐithwípò̤ tahe, ná bětalǐ thǐtahe.) ");
INSERT INTO kyu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Htuô̌rò Pharisěophú tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe sudyǎ Jesǔ, “Nè̤ khǒpacè̤̌ tahe rò a krwǒme̤ kuô̌ phú phyěphuô̌ lé̤klǒ ithyókyǎ ǔ nuô to vǎ? Bí èthǐ esèǒhtyě akhè̌nuô, a sǐplǐkyǎ kuô̌ lahyǎ atakhu to me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesǔ hésû èthǐ, “Prè̤pro̤ Isaiah héone thǐrithǐkyǎ nuôma a tǒtû́ cò́. Thǐ ma prè̤ cyé̤zò́cò́te̤ ané̤ tahe. Prè̤pro̤ Isaiah rǎkyǎ dố nuôkhè̌ rò a hé, Cò́marya hé, ‘Kayǎ yětahe bezṳ̂́benyá̤ lahyǎ vǎ ná akhǎu manárò athè́plò nuôma a otaphǎye̤ ná vǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Èthǐ cò́bè̌htya vǎ yěnuô angó̤lasá o tôcô꤮ to. Èthǐ ithyóithya prè́ ǔ ná prè̤lukayǎ alé̤klǒ tahe prè́ manárò a hé ní̤dyé lahyǎ ná a ithyóithya cò́ ǔ ná Cò́marya a tè̤thyótè̤thya tahecò́.’ ");
INSERT INTO kyu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Thǐ dyataphǎ khókyǎ Cò́marya a tè̤thyótè̤thya tahe rò thǐ pṳ̂́klò̤ma ní̤dyé lahyǎ prè̤lukayǎ a lé̤klǒlé̤khya tahe.” ");
INSERT INTO kyu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Htuô̌rò a hé èthǐ, “Thyáphú thǐ ki pṳ̂́ma ní̤dyé thǐ lé̤klǒ tè̤thyótè̤thya tahe agněnuôrò, Cò́marya mekyǎngó̤ tahenuô, thǐ limyǎ htésûkyǎ cyá̤ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosè hé, ‘Bezṳ̂́benyá̤ nè̤muố̤nè̤phè̌ ní,’ rò ‘Kayǎ dố a isò̌ amuố̤aphè̌ tôprè̤prè̤nuô bè me̤thyěkyǎ lǔ.’ ");
INSERT INTO kyu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Manárò thǐ nò̌hé ǔmuố̤ǔphè̌, ‘Kố꤮ muố̤, Kố꤮ phè̌, rû̌htè̌ dố vǎ kitǒ myákhwè me̤cwó̤ ná thǐnuô a o vǎ, manárò vǎ ki nò̌e è ná Kòban,’ thǐ nò̌hé ǔ ná ǔmuố̤ǔphè̌ phúnuô, ");
INSERT INTO kyu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","htuô̌rò thǐ nò̌me̤cwó̤ myákhwèní̤ pǎ èthǐ ná amuố̤aphè̌ to. ");
INSERT INTO kyu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Phúnuô akhu-akhyě thǐ me̤taphǔkyǎlò̌ hò́ Cò́marya alǎ̤angó̤ hékyǎ yěnuôtahe hò́, me̤těhérò thǐ pṳ̂́klò̤maní̤ thǐ lé̤klǒ rò thǐ dyétǎ̤ dǐtû́ ǔ. Thǐ me̤thyá phúyě dố aruô tahenuô a o è́pǎ nyacò́.” ");
INSERT INTO kyu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Rò Byacè Jesǔ è́hyǎphû kayǎ bè́mṳ dố akhǎshyé rò a hé èthǐ, “Pwǒ̤꤮ tôprè̤ ní̤dǎ lahyǎ vǎ hé thǐyě rò yácû́ pṳ̌thè́gně tǎ̤te̤ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tè̤ dố a o dố aklò̌ rò a hyǎnuô̌ dố kayǎ tôprè̤prè̤ akǔ tahenuô a me̤ taprómǔmyá̤ cyá̤ lǔ to, manárò tè̤ dố a o dố kayǎ thè́plòkǔ rò a hte tahe nuôma a me̤ taprómǔmyá̤ lǔ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(“Lò̌꤮ thǐ yětahe, thǐ ki thè́zṳ̂́ thè́gně hérò, thǐ tǒkò ní̤dǎ lahyǎ.”) ");
INSERT INTO kyu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesǔ htecuố taphǎkyǎ dố kayǎ oró̤klè̌ rò bí a cuốnuô̌ dố hidò́kǔ akhè̌nuô, a khǒpacè̤̌ tahe sudyǎ lǔ ngó̤khákho angó̤lasá tahe. ");
INSERT INTO kyu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Rò a hé pé̤ èthǐ, “Thǐ thè́gně kuô̌nyǎ ǔ to è̌? Thǐ tǒbè thè́gně, sèe ǐtětě꤮ bèbè, a o dố aklò̌ rò a hyǎnuô̌ dố kayǎkǔ tahe nuôma, a me̤ taprómǔmyá̤ cyá̤ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Me̤těhérò sèe yěnuô, a nuô̌ dố lǔ thè́plòkǔ má̤to, a nuô̌ dố phuô̤̌kǔ rò a bè htecuốkyǎ dố dò̌klò̌ prè́.” (A hé phúyěnuôma, a thè́zṳ̂́ hé, sèe ǐtětě꤮ bèbè, e ma a ní̤ lò̌prè́.) ");
INSERT INTO kyu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Htuô̌rò a hé, “Tè̤ dố a o dố kayǎ thè́plòkǔ rò a hte tahe nuôma a me̤ taprómǔmyá̤ lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tè̤ dố a o dố kayǎ thè́plòkǔ hyǎhte tahe nuôma má̤hò́ tè̤tane̤ mǔmyá̤ricyá̤ tahe, cuốthû́ prè̤mòprè̤khǔ, ehuôehí, me̤thyě kayǎ, cuốthû́ ǔměǔvè̤, ");
INSERT INTO kyu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tè̤lò̤̌phǎ kò́vè̌kò́pra e ní̤dyégně, tè̤thè́kháthè́hte ǔ, lahǒeǔ, tè̤me̤ mǔmyá̤ricyá̤, thè́khwè́ní̤ǔtè̤, pacyé̤ishyéǔ, phyéduné̤, me̤tè̤ rò tane̤ tǎ̤te̤ to. ");
INSERT INTO kyu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lò̌꤮ tè̤ dố aryáto yětahenuô a o dố kayǎ thè́plòkǔ hte rò a me̤ taprómǔmyá̤ kayǎ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesǔ htecuốkyǎ ná khǎlé̤ bínuôtôpho rò a htecuốtuố̤ dố khǎlé̤ tôpho dố aphû ná vǐ̤ Tyre ná vǐ̤ Sido. Htuô̌rò a cuốnuô̌ dố hitômě akǔ rò a thè́zṳ̂́ dyéthè́gně ané̤ ná kayǎ bè́mṳ yětahe to tadû́rò a owóouố bícyá̤ to. ");
INSERT INTO kyu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Prè̤mò tôprè̤ ní̤huô̌ Jesǔ ari-akyǎkyǎ ná tôphuốtuô̌ a hyǎ dángṳ̂cò́bè̌lya̤ dố Jesǔ khǎduôshyé. Rò prè̤mò yětôprè̤nuô a phúprè̤mò patíphú o tôprè̤ rò khǐnékhǐnò̌ me̤bè lǔ tè̤. ");
INSERT INTO kyu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Prè̤mò yětôprè̤ ma Judaphú má̤to, a o dố Syria ké̤muố̤ alè̤̌ Phonicia ké̤kǔ, rò a o ní̤dyé ná a phúprè̤mò tôprè̤. Rò a hyǎ kwǐthè́zò̤ tadû Jesǔ ná a ki vè̤́htekyǎ pé̤ khǐnékhǐnò̌ dố a phúprè̤mò yěnuô akǔ. ");
INSERT INTO kyu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Htuô̌rò Jesǔ hé è, “Phú tahenuô a tǒbè ekò́ǒbǎ ré̤, pè̤ phyé phú yětahe asèe rò buôekyǎ ná htwi tahe nuôma a kòto.” (Jesǔ hé ná pacè̤̌phúyě angó̤lasá ma Judaphú rò htwi a hé nuôma Judaphú má̤to tahe.) ");
INSERT INTO kyu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Manárò a hésû Jesǔ, “A má̤lakǒ cò́ Byacè, htwi dố a o dố dǐrè̤́ alè̤̌ tahenuô a enò́ kuô̌nyǎprè́ phú tahe asèe tǎ̤kuố̤tǎ̤vè̤̌ nuôtahe nyǎprè́.” ");
INSERT INTO kyu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesǔ hé lǔ, “Nè̤ hésû ka̤khyě tè̤yě aryá nyacò́ akhu-akhyě nè̤ ka̤ dố hi ma aní̤ hò́. Khǐnékhǐnò̌ o dố nè̤ phúprè̤mò akǔ nuôtôduô̌ htecuốkyǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A ka̤ dố ahi rò a myáhtye ná a phúprè̤mò omyěkhû́ o dố lé̤myěkhu rò a thè́gně ná khǐnékhǐnò̌ htekyǎhò́ dố lǔkǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Htuô̌rò Jesǔ o bí vǐ̤ Tyre tavǐtava̤ nuô rò a nuô̌ cuốplúbè́ vǐ̤ Sido, htuô̌rò a ka̤khyě dố Galilea htyěò. Htyěò yěnuô a ophû ná vǐ̤ shyé dố ǔ è́ ná Decapoli hé yěnuô tôké̤ akǔ. ");
INSERT INTO kyu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kayǎ tahe è́hyǎní̤ kayǎphè̌ khǎlèkaò̌ rò a pè́ uốáyá hébè cyá̤ kadákadǒ tôprè̤ dố Jesǔ a o rò èthǐ kwǐthè́zò̤ tadû Jesǔ dố a ki dya atakhu dố lǔlo̤. ");
INSERT INTO kyu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Rò Jesǔ è́hte taphǎcuốkhókyǎ tû́dû kayǎphè̌ yětôprè̤ dố kayǎ oró̤klè̌ rò kǐ̤nuô̌ htuô̌ akanò̌ dố kayǎphè̌ nuôtôprè̤ a khǎlèkǔ rò a htupláco apli̤htyě ná akanò̌ rò a tô ná kayǎphè̌ nuôtôprè̤ apli̤. ");
INSERT INTO kyu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Htuô̌rò a tṳ́htya dố mò́khu rò a thè́muố̤, rò a hé lǔ, “Éphatha!” Angó̤lasá ma “lǐhtyamò̌!” nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Rò kayǎphè̌ nuôtôprè̤ khǎlè lǐka̤khyě rò apli̤ cè̤́ ka̤khyě rò a hébè cyá̤ ryá khyěthyá. ");
INSERT INTO kyu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesǔ hé èthǐ ná héso pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮, a hé èthǐ phúnuô tadû́rò Jesǔ nò̌héluô̌ to shyoshyo, èthǐ lé héluô̌ shyoshyo. ");
INSERT INTO kyu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Rò lò̌꤮ kayǎ dố a ní̤huô̌ tahenuô, a khyéthukhyéthè́ lahyǎ kanó̤꤮ to. Rò èthǐ hé lahyǎ, “Lò̌꤮ è me̤tè̤ tahe nuôma aryá nyacò́! Kayǎ khǎlèkaò̌ ma a me̤lǐka̤khyě, kayǎ pè́ ma a me̤hébè cyá̤ ka̤khyě pé̤ cò́ ǔ ni,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Bínuô akhè̌ kayǎ bè́mṳdu dố aruô tômṳ hyǎoplò́oplu kuô̌ lò̌ ke lǔ rò èthǐ lé̤elé̤ǒ lò̌kyǎ hò́ rò Jesǔ è́hyǎ a khǒpacè̤̌ tahe dố a o rò a hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Vǎ thè́zò̤ ní̤dyé nyacò́ kayǎ yětahe, a o kuô̌ lahyǎ ná vǎ bíyě ma a bǎ hò́ thuô̌nyě hò́. Èthǐ lé̤elé̤ǒ o lahyǎ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Vǎ ki plwǒka̤ tavǐ̤takò̌ èthǐ dố ahi hérò, a enò́ǒnò́ lahyǎ to rò a ladyáeladyáǒ ka̤ lò̌ dố klyálo̤ he, me̤těhérò kayǎ tahehe ma a o lahyǎ dố aye̤ hyǎ cò́.” ");
INSERT INTO kyu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Rò a khǒpacè̤̌ tahe hésû lǔ, “Pè̤ tǒbè dyée èthǐ lé̤e ma amá̤vǎ, manárò dố lá̤mi̤soklè̌ phúyěnuô, pè̤ ki cuốmyápṳ̌ dyée cyá̤ pé̤ èthǐ phútě?” ");
INSERT INTO kyu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesǔ sudyǎ èthǐ, “Thǐkhò́mǔ o báklò̤́tě?” “A o thuô̌thyótôklò̤́” èthǐ hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesǔ nò̌onyǎtǎ̤ lò̌ kayǎ bè́mṳ yětahe dố hekhu rò a phyéhtya khò́mǔ yěthuô̌thyótôklò̤́ rò a hébwíhétaryě htuthè́htya Cò́marya, rò a ibikyě htuô̌ khò́mǔ yětaherò a dyé ná a khǒpacè̤̌ tahe rò a nò̌cuốzṳ́ èthǐ rò a khǒpacè̤̌ tahe cuốzṳ́tǎ̤ dǐtû́ ná kayǎ bè́mṳ tahe. ");
INSERT INTO kyu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Èthǐ phyéhyǎ tuô̌kuô̌ tè̤̌phú tôbè nyě̤bè rò Jesǔ hébwíhétaryě htuthè́htya Cò́marya htuô̌rò a nò̌zṳ́tǎ̤ e ná kayǎ bè́mṳ yětahe. ");
INSERT INTO kyu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Èthǐ ekò́ǒbǎ pòepòǒ lò̌plǐ cò́. Rò a khǒpacè̤̌ phyédwókhyě khò́mǔ dố a okyǎpǎ yětahenuô a bǎpǎ cò́ ná krí̤nuô thuô̌thyótôkrí̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kayǎ esèe yětahenuô a phû꤮ o cò́ kayǎ lwǐ̤rí. ");
INSERT INTO kyu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesǔ plwǒka̤kyǎ htuô̌ kayǎ bè́mṳ yětahe rò tôphuốtuô̌ è ná a khǒpacè̤̌ tahe cuốnuô̌ dố thòklyěkǔ rò htecuố dố Dalmanutha ké̤. ");
INSERT INTO kyu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisěophú tahe hyǎ dố Jesǔ a o rò a hyǎ cáhtya kryá̤ lǔ. Jesǔ yěnuôma a o dố Cò́marya a o hyǎ má̤ è̌, má̤to è̌ nuô, èthǐ hyǎkwǐ khákhomyábyeprè́ lǔ ná a ki dyéluô̌ pé̤ èthǐ tè̤pro̤tè̤prya̤ tôcô. ");
INSERT INTO kyu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesǔ thè́muố̤ rò a hé èthǐ, “Kayǎ yětôhtû̌ tahe cuốkwǐmyá tuố̤ vǎ tè̤me̤ tè̤pro̤tè̤prya̤ me̤tě? Vǎ hécò́cò́ thǐ vǎ dyéluô̌ pé̤ thǐ tè̤me̤ tè̤pro̤tè̤prya̤ tôcô꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A hé rò a htecuố taphǎkyǎ ná Pharisěophú nuôtahe, rò a ka̤ kanuô̌khyě dố thòklyěkǔ rò htecuốkyǎ htyěòbè́rè̤̌ tôkyě. ");
INSERT INTO kyu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesǔ a khǒpacè̤̌ tahe sǒtapa̤ phyécuốní̤ lahyǎ khò́mǔ rò dố thòklyěkǔ yěnuô èthǐ phyécuốní̤ prè́ khò́mǔ tôklò̤́phú prè́. ");
INSERT INTO kyu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesǔ mekyǎ tǎ̤te̤ a khǒpacè̤̌ tahe, “Rò̤ní̤ lahyǎ thǐné̤ ná Pharisěophú tahe ahuô̌mû ná Khwí Herodè ahuô̌mû yěnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Èthǐ hé ní̤dyé khyělǔ, “Byacè hé pè̤ phúyěnuôma, má̤ dố pè̤ khò́mǔ o pé̤ lǔ to nuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Byacè Jesǔ thè́gně ná èthǐ hébè ní̤dyélǔ ná khò́mǔ ari-akyǎ akhu-akhyě, a sudyǎ èthǐ, “Mame̤těrò thǐ cuốdônyǎ ní̤dyé khyělǔ ná thǐ khò́mǔ oto ari-akyǎ phútě? Ma thǐ myáhtye thè́gněplǒ kuô̌nyǎ híǔ to è̌? Thǐ cuốthè́gněplǒ pé̤ kuô̌ǔ to phútětě? ");
INSERT INTO kyu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Thǐ mèthèplò o kuô̌ǔ rò thǐ myáhtye kuô̌ǔ to, thǐkhǎlè o kuô̌ǔ rò thǐ ní̤huô̌ kuô̌ǔ to. ");
INSERT INTO kyu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bí vǎ ibikyě khò́mǔ nyǎ̤klò̤́ rò vǎ buôe ná kayǎ nyǎ̤rí akhè̌nuô, thǐ phyédwóplò́ khyěthyá a okyǎlố nuôtaherò a opǎ bákrí̤tě nuôma thǐ tǒ̤ní̤dyé pǎto è̌?” Èthǐ hésû lǔ, “A okyǎlố shyényě̤krí̤.” ");
INSERT INTO kyu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Bí vǎ ibikyě khò́mǔ thuô̌thyótôklò̤́ rò vǎ buôe ná kayǎ lwǐ̤rí akhè̌, thǐ phyédwóplò́ khyěthyá khò́mǔ dố vǎ ibikyě tahenuô, a okyǎlố pǎ bákrí̤tě?” Èthǐ hésû lǔ, “A okyǎlố pǎ thuô̌thyó tôkrí̤.” ");
INSERT INTO kyu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Rò a hé èthǐ, “Thǐ thè́gně pé̤kuô̌nyǎ híǔ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesǔ ná a khǒpacè̤̌ tahe cuốtuố̤ dố vǐ̤ Bethsaida rò kayǎ tahe è́hyǎní̤ kayǎ mèthèkhí tôprè̤ rò a hyǎkwǐthè́zò̤ Jesǔ ná a ki tôbè pé̤ kuô̌ kayǎ yětôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesǔ pṳ̂́ní̤ kayǎ mèthèkhí yětôprè̤ atakhu rò a è́hte lǔ dố dò̌klò̌ rò a htuplárè̤̌ lǔ mèthèplò rò a tôrè̤̌ kayǎphè̌ yětôprè̤ a mèthèplò rò a sudyǎ lǔ, “Nè̤ myáhtye tè̤ tôcôcô è̌?” ");
INSERT INTO kyu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A myáhtǒmyálya̤ rò a hé, “Vǎ myáhtye kayǎ tahe tadû́rò athyáná thòmò̤́ rò a cuốka̤cuốhyǎ phúnuô prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesǔ tôrè̤̌ khyěthyá kayǎphè̌ mèthèkhí yětôprè̤ a mèthèplò rò kayǎ nuôtôprè̤ yácû́ myátǎ̤te̤ khyěthyá rò a mèthèplò lǐhtya rò a myáhtye ryálò̌ tè̤pwǒ̤tôcô. ");
INSERT INTO kyu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Rò Jesǔ héní̤ lǔ, “Ka̤ tôphuốka̤ dố hi ní꤮, ka̤ kanuô̌ tǎ dố dò̌kǔ tǎmé̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesǔ ná a khǒpacè̤̌ tahe cuố lahyǎ dố dò̌ o dố vǐ̤ Caesarea Philipi akhǎsò̌khǎshyé tahe rò bí a cuố dố klyálo̤ akhè̌nuô, Jesǔ sudyǎ èthǐ, “Kayǎ tahe hékryá꤮ vǎ ná vǎ ma kayǎ phútě tôprè̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Èthǐ hésû lǔ, “Taheherò a hé ná Giovanni Baptista, tahehe kuô̌kerò a hé ná Prè̤pro̤ Elia, taheherò a hé ná prè̤pro̤ tomaná prè̤pro̤ khódû dố aruô tahe aklè̌ tôprè̤prè̤ prè́,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Rò a sudyǎ èthǐ, “Thǐ kuô̌kelé꤮, thǐ ki hé ke vǎ ná ǔpě?” A hé rò Petru hésû è, “Nè̤ ma prè̤me̤lwóhteka̤ ǔ dố Cò́marya nwóhtya è nuôtôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Phúnuôrò Jesǔ mekyǎ èthǐ, “Vǎ ma prè̤me̤lwóhteka̤ ǔ dố Cò́marya nwóhtya è nuôtôprè̤ hò́, thǐ bè cuố hésoluô̌ní̤ pé̤ ǔ phúnuô tôprè̤꤮ to ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Rò Jesǔ cáhtya ithyó a khǒpacè̤̌ tahe, “Vǎ ma prè̤lu kayǎ aphúkhǔ rò vǎ tǒbè khyábè è́nyacò́ tè̤cyě̤tè̤cṳ̂ pǎ, rò Judaphú khuklò́khuklyǎ tahe, bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe ki thò́taná̤ thò́taphǎkyǎ vǎ pǎ rò èthǐ ki me̤thyěkyǎ vǎ pǎ. Rò vǎ thyěhtuô̌pǎ rò thuô̌nyě pǎnuô, vǎ ki htwǒprè̤ ka̤khyě khyěthyá dố tè̤thyě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A héluô̌ lá̤lǐ plǒ pé̤lò̌ cò́ èthǐ ná lò̌꤮ tè̤yětahe akhu-akhyě Petru è́cuố taphǎ cò̤́cè̤̌kyǎ Byacè takiphú rò a thè́prwǒ̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Manárò Jesǔ taríhtǒtarílya̤ rò a myárè̤̌ htuô̌ a khǒpacè̤̌ tahe rò a thè́prwǒ̤ ka̤khyěsû Petru, “Kố꤮ khǐnéricyá̤ khuklò́, htecuố taphǎkyǎ ná vǎ, me̤těhérò nè̤ tè̤tane̤ tahenuô athyáná prè̤lukayǎ a tè̤tane̤ nuô prè́, a thyákuô̌ ná Cò́marya a tè̤tane̤ tahenuô má̤to.” ");
INSERT INTO kyu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Htuô̌rò Jesǔ è́hyǎplò́tố̤ lò̌ kayǎ bè́mṳ tahe ná a khǒpacè̤̌ tahe dố a o rò a hé èthǐ, “Kayǎ tôprè̤prè̤ ki thè́zṳ̂́ krwǒ vǎkhyě hénuô, a tǒbè me̤ phú vǎ thè́zṳ̂́nò̌me̤ lǔ nuôtahe, a me̤ cṳ́꤮ dû athè́plò ma aní̤ to. A bè záhtya ní̤dyédû a krusu rò a bè krwǒ vǎkhyě. ");
INSERT INTO kyu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Me̤těhérò kayǎ dố a thè́zṳ̂́ me̤lwóhteka̤ ní̤dyé a thè́plòhtwǒprè̤ tôprè̤prè̤ nuô, a thè́plòhtwǒprè̤ ki lamé̤kyǎ pǎ. Manárò dố vǎkhuvǎkhyě rò kayǎ tôprè̤prè̤ ki dyélya̤kyǎ a thè́plòhtwǒprè̤ ná tè̤thè́krṳ̂̌mila yěnuô dố vǎgně hénuô, a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kayǎ tahe ki ní̤bè lò̌ cò́ hekhusǐba a tè̤duzá̤htyathè̌ tahe cò́ rò a ki lacṳ́kyǎ a thè́htwǒprè̤ tacṳ́prè̤ yě hénuô abwío dố lǔgně ǐtě? ");
INSERT INTO kyu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kayǎ dố a thè́zṳ̂́ ní̤bè ka̤khyě khyěthyá a thè́htwǒprè̤ tacṳ́prè̤ yě tôprè̤prè̤nuô tè̤duzá̤htyathè̌ dố a ki ipri̤bè́ ná a thè́plòhtwǒprè̤ yěnuô a o tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Htû̌khè̌ dố a o shuô̌shuô̌prè́ ná kayǎ dố a me̤thû́me̤plátè̤, kayǎ dố a krwǒlṳ̂me̤ tǒ Cò́marya athè́plò o pǎ to yětôhtû̌ akǔyě, kayǎ tôprè̤prè̤ dố a thè́tarè̤̌ vǎ htuô̌to a thè́tarè̤̌ vǎlǎ̤vǎngó̤ yětahe tôprè̤prè̤ nuô, shyé꤮ prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎhò́ ná vǎphè̌ a taryědutaryěhtǔ hò́pǎ, rò vǎ hyǎtố̤hò́ ná tanémò́khuphú sǎsè̌ tahe hò́pǎ akhè̌nuô, vǎ ki thè́tarè̤̌ kuô̌ke è pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesǔ hé èthǐ, “Vǎ hé má̤lakǒ cò́ thǐ, kayǎ dố a ihtòo bí thǐklè̌yě tahehenuô, bí èthǐ thyě tyahí tokhè̌, èthǐ ki myáhtyenò́ lahyǎ Cò́marya hyǎ pốhtyěpốké̤ ná a taryěpro̤prya̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mò̤́nyě thuô̌thyó bǎhtuô̌hò́nuô Byacè Jesǔ è́ní̤ Petru, Jakomo ná apuố̤ Giovanni rò a cuốhtya dố sohtyalô̌ tômě alo̤. Bí a o tû́dû ná èthǐ akhè̌nuô, Byacè Jesǔ ané̤klò̤́ htulya taklya khólò̌ dố èthǐ nyěhyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A hyeca̤ tahenuô abǔplyatakhè̌htya lò̌plǐ cò́ rò a bǔthúlú klò̌pǎ cò́ ná ǔ ishuôphuố hyeca̤ dố hekhuyě nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Phúnuôhtuô̌rò a khǒpacè̤̌ nuô thè́thuô̌ myáhtye Prè̤pro̤ Elia dố꤮ nyénu nuôtôprè̤ ná Mosè oluô̌htya rò èthǐ hébè lahyǎ ná Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petru hé Jesǔ, “Thárá꤮, khǎlé̤ bíyě tôpho rò atwó̤ mo̤ryá lǎ. Pè̤ ki isò́pé̤ thǐ lé̤thû thuô̌mě, tôměrò nè̤gně, tôměrò Mosè agně, tôměrò Prè̤pro̤ Elia agně.” ");
INSERT INTO kyu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Èthǐ thè́isě talwó sû́lû̌ rò Petru tǒbè hé phútěnuô a thè́gně pǎto akhu-akhyě a héhte phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Rò ò́luố̤ tôba lapò̤ tǎ̤bíkyǎ èthǐ rò ngó̤pra̤htya dố ò́luố̤kǔ rò a hé, “Yětôprè̤ ma vǎphúkhǔ dố vǎ mo̤ ní̤dyé è tôprè̤, rò ní̤dǎ lahyǎ angó̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","O taplô̤phú rò èthǐ myátarítava̤ rò myáhtye prè́tû́ Jesǔ tôprè̤꤮ tuô̌, dố aruô thè́nyě̤nuô myáhtye pǎto hò́. ");
INSERT INTO kyu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bí èthǐ o dố solo̤ hítǎ̤ akhè̌nuô, Jesǔ mekyǎ èthǐ ngó̤, “Lò̌꤮ thǐ myáhtye yětahenuô hésoluô̌ pé̤ tǎ hí ǔ tôprè̤꤮ tǎmé̤ ní꤮, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ihtòhtwǒprè̤ ka̤khyě hò́ dố tè̤thyě pǎ tû́rò hésoluô̌ pé̤ noprè́ ǔ ní꤮,” a mekyǎ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rò èthǐ me̤phú Jesǔ mekyǎ èthǐ nuô tadû́rò èthǐ dônyǎ ní̤dyé khyělǔ tôprè̤ ná tôprè̤ rò a hé lahyǎ, “Tè̤thyě ihtòhtwǒprè̤ ka̤khyě angó̤lasá ma ǐtě ha?” A sudyǎ ní̤dyé lò̌ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Èthǐ sudyǎ Jesǔ, “Prè̤ithyó tè̤thyótè̤thya athárá tahe hé ná Prè̤pro̤ Elia bèhyǎ ré̤klò̌ ná Messia dố a ki me̤lwóhteka̤ ǔ yěnuô tôprè̤ pǎ, a cuốhétuố̤ phúnuô me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Rò a hésû èthǐ, “Prè̤pro̤ Elia bè hyǎ ré̤lốpǎ rò a bè hyǎ taritaryǎ me̤ryá ka̤khyě tè̤lò̌꤮ plǐ nuôma a má̤lakǒ cò́ vǎ. Manárò lisǎsè̌ hé ná prè̤lu kayǎ aphúkhǔyě a tǒbè khyábè è́nyacò́ tè̤cyě̤tè̤cṳ̂ pǎ rò ǔ ki thò́taná̤taphǎkyǎ è pǎ a cuốhétuố̤ phúyěme̤tě? ");
INSERT INTO kyu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Manárò vǎ hé thǐ, Prè̤pro̤ Elia hyǎhtuô̌hò́ rò kayǎ tahe me̤ lǔ cṳ́ èthǐ thè́plò thè́zṳ̂́ me̤ lǔ nuôprè́. Yěma a htwǒhtya hò́ phú lisǎsè̌ rǎone è ari-akyǎ nuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bí Jesǔ ná a khǒpacè̤̌ thè́thuô̌ cuốtuố̤ dố a khǒpacè̤̌ aruô tahe a o akhè̌nuô, a myáhtye kayǎ bè́mṳdu hyǎoplò́oplu tava̤ lò̌ èthǐ rò prè̤ithyó tè̤thyótè̤thya athárá tahe hyǎkréhyǎkryá̤ lahyǎ ná èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bí kayǎ bè́mṳ myáhtye Jesǔ akhè̌, tôphuốtuô̌ èthǐ khyéthukhyéthè́ lahyǎ rò èthǐ klyacuố hébè è́mo̤sû lahyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Rò Jesǔ sudyǎ a khǒpacè̤̌ tahe, “Ma thǐ krékryá̤ lahyǎ èthǐ ná tè̤ritè̤kyǎ ǐtě?” ");
INSERT INTO kyu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dố kayǎ bè́mṳ aklè̌nuô kayǎphè̌ o tôprè̤ rò a hésû Jesǔ, “Thárá꤮ vǎ è́hyǎní̤ vǎ phúprè̤khǔ dố khǐnékhǐnò̌ me̤pè́ lǔ rò a hébè cyá̤ to tôprè̤ dố nè̤o. ");
INSERT INTO kyu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Dǎ khǐnékhǐnò̌ me̤bè hò́ è bíkhè̌tě꤮ nuô a bè́ lakhû́tǎ̤ ané̤ dố hekhu rò akyǎ̤kǔ bò́bè́hte lò̌plǐ. Htuô̌rò a a̤takrṳ̂ akhukhyě rò ané̤ pryǎ̤htya lò̌plǐ. Vǎ kwǐthè́zò̤ nè̤ khǒpacè̤̌ tahe ki vè̤́htekyǎ pé̤ lǔ khǐnékhǐnò̌yě tadû́rò èthǐ vè̤́htekyǎbè́ pé̤kuô̌ lǔ phúnuôto.” ");
INSERT INTO kyu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Rò Byacè Jesǔ hé èthǐ, “Kayǎ sǒdǒ tè̤zṳ̂́ thǐ꤮ ma vǎ bè onyě̤ tố̤kuô̌pǎ ná thǐ bátě pǎ? Vǎ tǒbè khyáthè́dǒ nyě̤pé̤kuô̌pǎ thǐ bátě? È́hyǎ è dố vǎ oyě.” ");
INSERT INTO kyu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Rò èthǐ è́hyǎ pacè̤̌phè̌phú nuôtôprè̤ dố Jesǔ o. Bí khǐnékhǐnò̌ myáhtye Jesǔ akhè̌ tôphuốtuô̌ a me̤ tanyǎ̤tapluố̤ htyashyo pacè̤̌phè̌phú yětôprè̤ rò lakhû́tǎ̤ dố hekhu rò a htulò̌ taplò̌taple ané̤ bínuô rò akyǎ̤kǔ bò́bè́hte lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Rò Jesǔ sudyǎ pacè̤̌phú nuôtôprè̤ aphè̌, “A me̤ phúyě nuôma anyě̤lǎ hò́ è̌?” Rò a hésû lǔ, “A me̤pǎ dố a patíkhè̌ nuôpǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Khǐnékhǐnò̌ thè́zṳ̂́ me̤thyě lǔ rò a me̤ lakhû́nuô̌ tamǒmǒ lǔ dố mikǔ, a me̤ latǎ̤nuô̌ tamǒmǒ lǔ dố htyěkǔ cò́. Nè̤ ki me̤cyá̤ hérò thè́zò̤ rò me̤cwó̤ pé̤ré̤ pè̤ to꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Rò Jesǔ hé lǔ, “Me̤těrò nè̤ cuố hétuố̤, ‘Nè̤ ki me̤cyá̤,’ phúnuô me̤tě? Kayǎ tôprè̤prè̤ dố a zṳ̂́e Cò́marya nuôma a me̤cyá̤ lò̌plǐ pwǒ̤꤮ tôcô prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tôphuốtuô̌ pacè̤̌ aphè̌ è́htǒ hé, “Vǎ zṳ̂́e, manárò vǎ tè̤zṳ̂́ opatílǎ, thyáphú vǎ tè̤zṳ̂́ kishyokisò̌ agněnuô, me̤cwó̤ kuô̌ ré̤ vǎ!” A è́htǒ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bí Jesǔ myáhtye ná kayǎ bè́mṳ klyahyǎtǒphû ró̤è́lǎ lǔ akhè̌nuô, a thè́prwǒ̤ khǐnékhǐnò̌ yěnuô, “Kố꤮ khǐnékhǐnò̌ dố a me̤kaò̌ kayǎ akhǎlè rò a me̤pè́ kayǎ yětôprè̤, vǎ nò̌htecuố taphǎkyǎ nè̤ dố pacè̤̌phè̌phú yětôprè̤ akǔ hò́, nè̤ bè ka̤khyě nuô̌ní̤ pǎ tôphuố꤮ to ní,” a héhtuô̌ phúnuô rò. ");
INSERT INTO kyu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Khǐnékhǐnò̌yě a è́htǒhtya rò a me̤ tapluố̤shyotapluố̤sò̌ htuô̌ pacè̤̌phè̌phú nuôtôprè̤ rò a htecuốkyǎ dố lǔkǔ. Rò pacè̤̌phè̌phú yětôprè̤nuô, a thyá cò́ ná a thyěnuô cò́. Rò kayǎ tahe hé lahyǎ, “A thyěhò́ nuô̌꤮” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Manárò Jesǔ cwikahtò lǔ rò a kahtòbè́ khyěthyá. ");
INSERT INTO kyu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesǔ me̤htuô̌ phúnuôrò, bí è ná a khǒpacè̤̌ tahe ka̤khyě nuô̌ dố hi dố ǔ o tôprè̤꤮ to nuôtômě akǔ akhè̌nuô, a khǒpacè̤̌ tahe sudyǎ lǔ, “Pè̤ vè̤́htekyǎ bè́kuô̌ǔ khǐné to me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Rò Jesǔ hé èthǐ, “Khǐnékhǐnò̌ phúyě tahe nuôma thǐ vè̤́htekyǎbè́ prè́ è ná tû́ tè̤kwǐcò́bè̌ tôcô prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesǔ ná a khǒpacè̤̌ tahe htecuốkyǎ htuô̌ ná khǎlé̤ bínuô rò èthǐ lěcuốrwó Galilea ké̤kǔ nuô. Jesǔ thè́zṳ̂́ nò̌thè́gně ǔ tôprè̤꤮ to, ");
INSERT INTO kyu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","me̤těhérò a ithyóithya a khǒpacè̤̌ tahe rò a hé èthǐ, “Prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě, ǔ ki isè̌ tǎ̤kyǎ è dố prè̤lukayǎ a takhukǔ pǎ rò èthǐ ki me̤thyě vǎ pǎ. Vǎ thyěhtuô̌ thuô̌nyě pǎ nuô, vǎ ki htwǒprè̤ ka̤khyě khyěthyá pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A khǒpacè̤̌ thè́gněplǒryá a tè̤ithyóithya èthǐ yě angó̤lasá to tadû́rò èthǐ sudyǎbû lǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Èthǐ cuốtuố̤ dố vǐ̤ Capernaum rò bí a o dố hikǔ akhè̌nuô, a sudyǎ a khǒpacè̤̌ tahe, “Bí thǐ cuố dố klyálo̤ akhè̌nuô, thǐ hébè cuố kryá꤮ lǔ ǐtě?” ");
INSERT INTO kyu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bí èthǐ cuố dố klyálo̤ akhè̌nuô, èthǐ yǒ krékryá̤cuố ní̤dyélǔ ná dố pè̤klè̌ yěnuô, ǔpě htwǒdulố ǔ pě ari-akyǎ akhu-akhyě, èthǐ othuôtakrû́ lahyǎ prè́, a hé ka̤khyěsû lǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesǔ onyǎo rò a è́hyǎ èthǐ dố akhǎshyé rò a hé èthǐ, “Kayǎ dố a thè́zṳ̂́ htwǒdulố ǔ tôprè̤ nuôma a tǒbè o dố ǔ lè̤̌lố rò a bè htwǒpé̤ lò̌ ǔ pwǒ̤꤮ tôprè̤ a prè̤me̤tè̤phú.” ");
INSERT INTO kyu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Htuô̌rò a è́hyǎ pacè̤̌phú tôprè̤ rò a nò̌hyǎ kahtòo lǔ dố èthǐklè̌ rò a phyáhtya lǔ rò a hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kayǎ dố a myá vǎmèthè rò a ki è́mo̤sû pacè̤̌phú thyáná yětôprè̤ tôprè̤prè̤nuô a è́mo̤sû hò́ vǎ hò́. Htuô̌rò kayǎ dố a è́mo̤sû vǎ tôprè̤prè̤nuô athyáná a è́mo̤sû hò́ prè̤ dố a nò̌hyǎ vǎ bíyě nuôtôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Giovanni hésoluô̌ pé̤ Jesǔ, “Thárá꤮ pè̤ myáhtye kayǎ tôprè̤ dố a cuố vè̤́htekyǎ khǐnékhǐnò̌ tahe ná nè̤mwi̤. A yǒ otố̤kuô̌ dố pè̤amṳkǔ má̤to rò pè̤ hé tǎ̤tṳ̂̌kyǎ lǔ.” ");
INSERT INTO kyu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Manárò Jesǔ hésû èthǐ, “Hétǎ̤tṳ̂̌ tǎ è tǎmé̤, kayǎ tôprè̤prè̤ dố a me̤ htwǒhtya tè̤pro̤tè̤prya̤ tôcôcô ná vǎ mwi̤nuô dốkhyěpǎ a pacyé̤ishyé zǔnyé pǎ ná vǎ to. ");
INSERT INTO kyu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kayǎ dố a thè́hte pè̤ to tahe nuôma a otố̤kuô̌ dố pè̤ tôkyě prè́. ");
INSERT INTO kyu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Vǎ hécò́cò́ thǐ, dố thǐ krwǒ vǎkhyě akhu-akhyěrò, kayǎ tôprè̤prè̤ ki dyéǒsû thǐ htyě tôbě hénuôma a ki ní̤bè má̤lakǒ cò́ tè̤me̤ní̤khwókè pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kayǎ tôprè̤prè̤ ki nò̌me̤thû́ kayǎ patílố dố a zṳ̂́e vǎ yětahe aklè̌ tôprè̤prè̤ hénuô, cò̌ lò̤́du dố a kyǎ̤bǒlo̤nuô rò tá̤tǎ̤kyǎ è dố htyědutava̤kǔ nuôma aryáklò̌ pǎ cò́ dố lǔgně cò́. ");
INSERT INTO kyu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nè̤ takhu ki nò̌me̤ nè̤ tè̤thû́ hérò pǎ̤tṳ̂̌kyǎ ènuô. Nè̤ takhutṳ̂̌ tôkhó rò nè̤ ka̤kanuô̌bè́ dố mò́khunuô aryáklò̌ pǎ cò́ ná nè̤ takhu opwǒ̤lò̌ nyě̤khó cò́. Nè̤ ka̤kanuô̌ dố mò́khu ná nè̤ takhu tṳ̂̌yětôkhó prè́ yěnuô, aryáklò̌ pǎ cò́ ná nè̤ takhu opwǒ̤lò̌ nyě̤khó rò nè̤ latǎ̤ dố Mò́rapò̤tya̤ kǔ dố mi pǐ̤ cyá̤ pǎ tôphuố꤮ to yěnuô tôò akǔ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Bínuô tôpho pǎnuô lò ki e èthǐ zye rò lò yětahenuô a thyěpé̤to rò mi dố a û̌ èthǐ yěnuô, a pǐ̤pé̤ pǎ tôphuố꤮ to.) ");
INSERT INTO kyu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nè̤ khǎduô ki nò̌me̤thû́ nè̤ hérò pǎ̤tṳ̂̌kyǎ è nuô. Nè̤ nuô̌ dố mò́khu ná nè̤ khǎduô tṳ̂̌yětôkhó prè́ yěnuô, aryáklò̌ pǎ cò́ ná nè̤ khǎduô opwǒ̤lò̌ nyě̤khó rò ǔ vǐtǎ̤kyǎ nè̤ dố mò́rapò̤tya̤ akǔ yěnuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Bínuô tôpho pǎ nuô, lò ki e èthǐ zye pǎ rò lò yětahe nuô a thyěpé̤ tôphuố꤮ to rò mi dố a û̌ èthǐ yěnuô, a pǐ̤pé̤ pǎ tôphuố꤮ to.) ");
INSERT INTO kyu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nè̤mèthè ki nò̌me̤ nè̤ tè̤thû́ hérò kaǔhtekyǎ rò vǐkyǎ kyǎ ènuô. Nè̤mèthè oprè́ tôkyě rò nè̤ ka̤kanuô̌bè́ dố mò́khu nuô aryáklò̌ pǎ cò́ ná nè̤mèthè opwǒ̤odwǒ lò̌nyě̤kyě rò ǔ bè vǐtǎ̤kyǎ nè̤ dố Mò́rapò̤tya̤ kǔ pǎnuô cò́. ");
INSERT INTO kyu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Bínuô tôpho pǎ nuô, ‘Lò ki e èthǐ zye pǎ rò lò yětahenuô, a thyěpé̤ tôphuố꤮ to. Mi dố a û̌ èthǐ yěnuô, a pǐ̤pé̤ pǎ tôphuố꤮ to.’ ");
INSERT INTO kyu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kayǎ pwǒ̤꤮ tôprè̤ bè me̤mwǒ̤plǐthǐplo è ná mi pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ithè nuôma aryá prè́ tadû́rò a ki sû̌hè̌ pǎto hénuô me̤sû̌hè̌ ka̤khyě khyěthyá è nuô aní̤ pǎto hò́. Thǐ bè o ní̤dyé lahyǎ ithè má̤dû tè̤bò́thyóbò́lǎ ní̤ lǔ tôprè̤ ná tôprè̤, htuô̌to oplò́ocû̌ krṳ̂̌klè̌ ní̤dyé lǔ tôprè̤ ná tôprè̤ yěnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Htuô̌rò Jesǔ o bínuô rò a htecuốkyǎ dố Judaké̤ rò a cuố dố Jordano htyěklǒ bè́rè̤̌ tôkyě. Kayǎ bè́mṳ hyǎoplò́tava̤ kuô̌lò̌ khyěthyá lǔ tôplutôphè rò a ithyótǎ̤ pé̤ ǔ phú alé̤klǒ ithyó pé̤ ǔ pwǒ̤꤮ phuố nuô. ");
INSERT INTO kyu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisěophú tahehenuô a hyǎ tố̤kuô̌ dố Jesǔ a o rò èthǐ thè́zṳ̂́ hyǎ myápṳ̌ pṳ̂́ Byacè Jesǔ atè̤thû́ rò a hyǎ sudyǎ takè lǔ, “Kayǎ tôprè̤prè̤ okyǎ amě ma aní̤ prè́ pè̤ tè̤thyótè̤thya hényǎ phúnuô è̌?” ");
INSERT INTO kyu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Rò Jesǔ sudyǎ èthǐ, “Mosè hékyǎ thǐ ngó̤ phútě?” ");
INSERT INTO kyu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Èthǐ hésû, “Kayǎ dố a okyǎ amě tahenuô Mosè plwǒprè́ èthǐ dố a ki rǎ li-okyǎmě a tè̤rǎmá tôba rò a dyé ná amě rò a ki okyǎ amě hénuôma aní̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Rò Jesǔ hésû èthǐ, “Mosè rǎkyǎ pé̤ thǐ tè̤thyótè̤thya phúyě me̤těhérò thǐ yǒ khuklò́pryě̤ dû thǐgně nuô. ");
INSERT INTO kyu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Manárò dố Cò́marya byálya̤lú hekhu ná mò́khu akhè̌nuôma ‘Cò́marya byálya̤tû́ prè̤mò tôprè̤ ná prè̤khǔ tôprè̤ prè́.’ ");
INSERT INTO kyu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Dố tè̤ritè̤kyǎ yě akhu-akhyě prè̤khǔ yěnuô a bè dyakyǎ amuố̤aphè̌ rò a bè cuố otố̤kuô̌ ná amě, ");
INSERT INTO kyu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","rò kayǎ yěthè́nyě̤nuô a htwǒhtyahò́ tôprè̤꤮ tuô̌hò́.’ Phúnuôrò èthǐ ma kayǎ thè́nyě̤ má̤pǎtohò́. A htwǒhtyahò́ lǔ tôprè̤꤮ tuô̌hò́. ");
INSERT INTO kyu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Phúnuôrò tè̤ dố Cò́marya dya-otố̤ lǔnuô, prè̤lukayǎ bè htò́pè̤̌kyǎní̤ lǔ tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bí èthǐ ka̤tuố̤ dố hi akhè̌nuô, a khǒpacè̤̌ tahe sudyǎpó̤ lǔ tè̤ritè̤kyǎ yě. ");
INSERT INTO kyu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Rò a hésû èthǐ, “Prè̤khǔ tôprè̤ ki okyǎ amě rò a ki cuốphyé taple ná prè̤mò dố aruôtôprè̤ hénuôma a cuốthû́hò́ amělye̤ yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Htuô̌rò prè̤mò tôprè̤ ki okyǎ avè̤ rò a ki cuốphyé taple ná prè̤khǔ dố aruôtôprè̤ hénuôma a cuốthû́hò́ avè̤lye̤ yěnuô tôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Thyáphú Jesǔ ki dyahtya atakhu dố pacè̤̌phú yětahe alo̤ nuô, kayǎ tahe è́hyǎní̤ lahyǎ pacè̤̌phú dố Jesǔ a o. Manárò a khǒpacè̤̌ tahe thè́prwǒ̤sû kayǎ cwihyǎní̤ pacè̤̌phú yěnuô tahe. ");
INSERT INTO kyu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesǔ myáhtye èthǐ me̤phúnuôrò a thè́plòdu èthǐ rò a hé èthǐ, “Plwǒhyǎ pacè̤̌phú nuôtahe dố vǎ oyě. Me̤tǎ̤tṳ̂̌ tǎ èthǐ tǎmé̤, me̤těhérò Cò́marya ahtyěaké̤ nuôma kayǎ dố a shyalya̤ athè́plò thyáná pacè̤̌phú yěnuôtahe atè̤hò́. ");
INSERT INTO kyu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Vǎ hécò́cò́ thǐ, thǐ ki nò̌pố thǐné̤ ná Cò́marya phú pacè̤̌phú tahe nò̌pốní̤ ané̤ nuôto hénuô, thǐ nuô̌ ní̤ cyá̤ dố Cò́marya htyělé̤ké̤kǔ takhyá꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Htuô̌rò a phyáhtya pacè̤̌phú dố ané̤lo̤ tôprè̤ htuô̌ tôprè̤ rò a dyahtyahtuô̌ atakhu dố pacè̤̌phú tahe alo̤ rò a sò̌risò̌bǔ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bí Jesǔ cáhtya htecuốkyǎhò́ akhè̌nuô, kayǎ tôprè̤ klyahyǎ dố lǔo rò a hyǎ dángṳ̂lya̤ dố lǔ mèthènyě rò a sudyǎ Jesǔ, “Kố꤮ tháráryá꤮ thyáphú vǎ ki ní̤bè kuô̌ǔ thè́htwǒprè̤ tacṳ́prè̤ talèkrè́ nuôrò, vǎ tǒbè me̤kryá꤮ maǐtě?” ");
INSERT INTO kyu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesǔ sudyǎ lǔ, “Nè̤ cuốè́ tuố̤ vǎ ná tháráryá me̤tě? Kayǎryá o tôprè̤꤮ to, a o prè́tû́ Cò́marya tôprè̤prè́. ");
INSERT INTO kyu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nè̤ thè́gně Cò́marya mekyǎngó̤ tahe hé, ‘Me̤thyě tǎ kayǎ tǎmé̤, cuốthû́ tǎ ǔphúǔmě tǎmé̤, ehuôehí tǎ ǔtè̤ tǎmé̤, khyá lahǒlahya tǎ tè̤ tǎmé̤, cuốetṳ̂̌ǒplè tǎ ǔkhu tǎmé̤, bezṳ̂́nyá̤ nè̤muố̤nè̤phè̌.’” ");
INSERT INTO kyu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Rò a hésû Jesǔ, “Thárá꤮ yětahenuô vǎ tǒ̤ní̤ htuô̌lò̌hò́ rò vǎ krwǒme̤ htuô̌lò̌hò́ dố vǎ pacè̤̌khè̌ nuô pǎ cò́hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Rò Jesǔ myá tǎ̤tǎ̤꤮ lǔ rò a thè́zò̤ní̤ lǔ rò a hé, “Tè̤ dố nè̤ lome̤ nuô a opǎ tôcô, ka̤ isè̌kyǎlò̌ nè̤ tǎ̤muô̌tǎ̤tè̤ nuôtahe rò dyékyǎ ná kayǎ sǒphásǒrya̤phú nuô. Nè̤ ki me̤phúnuô hérò nè̤ ki ní̤bè tè̤duzá̤htyathè̌ dố mò́khu pǎ. Ka̤me̤htuô̌ phúnuô rò hyǎ krwǒkuô̌ vǎkhyě.” ");
INSERT INTO kyu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A yǒ duzá̤ tǎ̤pòtǎ̤pè̤̌ cò́ akhu-akhyě, bí a ní̤huô̌ htuô̌ Byacè Jesǔ hé lǔ phúyě akhè̌nuô, a khyé htuô̌rò a mèthèpyé rò a hteka̤kyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesǔ tarítava̤ myá rò a hé a khǒpacè̤̌ tahe, “Kayǎ duzá̤htyathè̌ tahe kíré̤ nuô̌ dố Cò́marya ahtyěaké̤kǔ nuô, apyá̤ nyacò́ dố èthǐgně cò́!” ");
INSERT INTO kyu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A khǒpacè̤̌ tahe ní̤huô̌ lǔ hébè phúyě rò a htetapa̤ lò̌plǐ cò́ lǔ. Htuô̌rò a hé khyěpó̤ èthǐ, “Vǎphú thǐ꤮, ǔ kíré̤ nuô̌ dố Cò́marya ahtyěaké̤kǔ nuôma apyá̤ nyacò́꤮. ");
INSERT INTO kyu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tathíbuô̌du tôduô̌ kíré̤ plyénuô̌ dố htè́khǎlí̤kǔnuô azǔ klò̌pǎ cò́ ná kayǎ duzá̤htyathè̌ tôprè̤ kíré̤ nuô̌ dố mò́khu htyělé̤ké̤kǔ nuô cò́.” ");
INSERT INTO kyu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A khǒpacè̤̌ tahe a hte tapa̤ lò̌plǐ lǔ rò èthǐ hé ní̤dyélǔ, “Ki me̤phúnuôrò ǔpě tôprè̤ kíré̤ ní̤bècyá̤pǎ tè̤me̤lwóhteka̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesǔ myá èthǐ rò a hé èthǐ, “Prè̤lukayǎ me̤lwóhteka̤ cyá̤ ní̤dyé ané̤to tadû́rò Cò́marya yǒ me̤cyá̤tè̤ pwǒ̤꤮ tôcô akhu-akhyě, a me̤lwóhteka̤ cyá̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petru hé lǔ, “Myámò̌, pè̤ dyakyǎ lò̌ cò́hò́ tè̤pwǒ̤꤮ tôcô rò pè̤ krwǒkuô̌hò́ nè̤khyěhò́.” ");
INSERT INTO kyu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesǔ hé lǔ, “Vǎ hélakǒ cò́ thǐ, dố vǎgně ná vǎ tè̤thè́krṳ̂̌mila agně rò kayǎ tôprè̤prè̤ ki vǐkyǎ ahi-aphyǎ ná apuố̤avyá̤, amuố̤aphè̌, aphúalye̤, ná aprè́alyá̤ thǐtahe hénuô, ");
INSERT INTO kyu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a ohtwǒprè̤ yětôhtû̌rò, a ki ní̤bè è́htya lốklò̌pó̤ ahi, apuố̤avyá̤, amuố̤aphè̌, aphúalye̤, aprè́alyá̤ thǐtahe dố aphuố tôzè̤ cò́ pǎ. Manárò ǔ ki me̤cyě̤me̤cṳ̂ è pǎ. Nopǎ tôhtû̌ rò a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ talèkrè́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Manárò kayǎ dố ǔ tane̤ lǔ ná a lodulố ǔtôprè̤nuô, a ki okyǎ dốkhyělố ǔ pǎ, kayǎ dố a okyǎ dốkhyělố ǔ tahenuô a ki htwǒhtya kayǎ dố ǔ lodulố lǔ pǎ,” Jesǔ hé pé̤ èthǐ phú nuô. ");
INSERT INTO kyu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesǔ ná a khǒpacè̤̌ tahe htya lahyǎ dố vǐ̤ Jerusalem rò bí a htya dố klyálo̤ akhè̌nuô, Jesǔ cuố ré̤ èthǐ dố nyě. Jesǔ htya pé̤ èthǐ dố vǐ̤ Jerusalem akhu-akhyě, a khǒpacè̤̌ tahe khyéthukhyéthè́ lò̌plǐ cò́ lǔ, rò kayǎ dố a krwǒhtya tố̤kuô̌ ná lǔ tahenuô, a thè́isě lò̌ lahyǎ. Rò Jesǔ è́plò́ khyěthyá a khǒpacè̤̌ shyéthè́nyě̤ rò a cáhtya hésoluô̌ pé̤ èthǐ ná shyé꤮ èthǐ cuốtuố̤ dố vǐ̤ Jerusalem pǎnuô a ki htwǒhtya kryá꤮ ané̤ phútě pǎ nuôtahe ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rò a hé èthǐ, “Ní̤dǎ tǎ̤te̤ lahyǎ, khǒnyá̤ rò pè̤ htya dố vǐ̤ Jerusalem. Bínuô pǎma ǔ ki isè̌tǎ̤kyǎ prè̤lukayǎ aphúkhǔ má̤dû vǎyěnuô dố bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe a takhukǔ pǎ. Rò èthǐ ki thè́plò tǒ lò̌ lǔ dố a ki me̤thyěkyǎ vǎ pǎ. A ki dyétǎ̤kyǎ vǎ dố Judaphú má̤to tahe a takhukǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Phúnuôrò Judaphú má̤to tahe ki hébè lavilavò̌ kanǐkano lò̌ vǎ pǎ, èthǐ ki htupláhtuthǐ lò̌ vǎ pǎ, a ki plí vǎ pǎ, rò èthǐ ki me̤thyěkyǎ vǎ pǎ tadû́rò a bǎhtyahò́ thuô̌nyě pǎma vǎ ihtòhtwǒprè̤ ka̤khyě khyěthyá pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeo aphúkhǔ Jakomo ná Giovanni hyǎphû dố Jesǔ a o rò a hé lǔ, “Thárá꤮ pè̤ kwǐ nè̤ ǐtětě bèbè, pè̤ thè́zṳ̂́ dố nè̤ ki me̤ pé̤ pè̤.” ");
INSERT INTO kyu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesǔ hésû èthǐ, “Thǐ thè́zṳ̂́ nò̌me̤ vǎ ǐtětě?” ");
INSERT INTO kyu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rò èthǐ hésû lǔ, “Bí nè̤ htya onyǎhò́ dố nè̤htyěnè̤ké̤ rò nè̤ ohò́ dố nè̤taryěduhtǔ akǔ hò́ pǎnuô, dyéonyǎ pé̤kuô̌ pè̤ dố nè̤ takhu cò́htwó tôkyě tôprè̤, ná dố nè̤ takhu cò́ci tôkyě tôprè̤ pǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Rò Jesǔ hésû èthǐ, “Thǐ kwǐ tè̤yěnuô thǐ thè́gně ní̤dyé ari-akyǎ to. Tè̤cyě̤tè̤cṳ̂ ahtyěbě dố vǎ kíré̤ ǒ yěnuô thǐ ǒ bè́kuô̌nyǎ sálé̤ pǎ è̌? Htuô̌rò tè̤khyácyě̤khyácṳ̂ dố vǎ kíré̤ khyá yě pǎ nuôma thǐ khyábè́kuô̌ sálé̤ pǎ è̌?” ");
INSERT INTO kyu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Rò èthǐ hésû lǔ, “Pè̤ khyábè́kuô̌ prè́.” Rò Jesǔ hésû èthǐ, “Htyěbě dố vǎ kíré̤ ǒ yěnuô thǐ ki ǒnò́kuô̌ pǎ, htuô̌rò tè̤cyě̤tè̤cṳ̂ dố vǎ kíré̤ khyábè yěnuô thǐ ki khyábènò́ kuô̌dû pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Manárò lé̤onyǎ akhǎlé̤ dố cò́ci tôkyě nuô bèbè, dố cò́htwó tôkyě nuô bèbè, a o dố vǎ takhukǔ má̤to, Cò́marya ki dyéonyǎ khǎlé̤ yěnuô ná kayǎ dố a taritaryǎ one pé̤htuô̌hò́ lǔ nuôtahe agně pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bí a khǒpacè̤̌ dố a okyǎ prè̤shyé yětahe ní̤huô̌ a sudyǎ phúyě akhè̌ nuô, èthǐ thè́plòdu Jakomo ná Giovanni. ");
INSERT INTO kyu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Phúnuôrò Jesǔ è́hyǎ plò́lò̌ èthǐ dố a o rò a hé èthǐ, “Thǐ thè́gně dûhò́ ná Judaphú má̤to tahenuô a o ná a khuklò́khuklyǎ dố a pố ní̤dyé èthǐ tahe. Htuô̌rò htyěké̤phú khuklò́khuklyǎ yětahenuô a nò̌e ní̤dyé lahyǎ a taryěshyosò̌ yěnuô dố htyěphúké̤phú tahe akhu. ");
INSERT INTO kyu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Manárò lò̌꤮ thǐ yětahenuô thǐ tǒbè me̤phúnuô to. Dố thǐklè̌nuô, kayǎ tôprè̤prè̤ ki thè́zṳ̂́ htwǒdu hérò a tǒbè htwǒ thǐ prè̤me̤tè̤phú. ");
INSERT INTO kyu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Dố thǐklè̌nuô, kayǎ tôprè̤prè̤ ki thè́zṳ̂́ htwǒ kayǎ dố ǔ lodulố lǔ kihérò a tǒbè htwǒ kayǎ lò̌꤮ plǐ acṳ̂́. ");
INSERT INTO kyu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Me̤těhérò prè̤lu kayǎ aphúkhǔ má̤hò́ vǎyě, vǎ hyǎ dố ǔ ki me̤pé̤ vǎgně nuô má̤to. Vǎ hyǎ dố vǎ ki me̤pé̤ ǔgně prè́. Rò thyáphú vǎ ki ihtaka̤ní̤ èthǐ agněnuôrò, vǎ dyélya̤kyǎ vǎ thè́plò htwǒprè̤ dố kayǎ è́prè̤ agně.” ");
INSERT INTO kyu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesǔ ná a khǒpacè̤̌ tahe cuốtuố̤ dố vǐ̤ Jeriko rò bí èthǐ htecuốkyǎhò́ ná vǐ̤ Jeriko akhè̌nuô, kayǎ bè́mṳdu bí vǐ̤kǔ nuôtahe htecuố kuô̌ ná èthǐ. Bí èthǐ htecuố akhè̌nuô, kayǎphè̌ mèthèkhí kwǐesè onyǎo bí klyáhtû̌nuô tôprè̤. Amwi̤ ná Bartimeo, è ma Timeo aphúkhǔ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bí a ní̤huô̌ ná vǐ̤ Nazarèphú Jesǔ hyǎ dố klyálo̤ akhè̌nuô, a cáhtya è́htǒ, “Kố꤮ Davi aphúkhǔ Jesǔ꤮ thè́zò̤ní̤ kuô̌ ré̤ vǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kayǎ è́prè̤ thè́prwǒ̤ lǔ rò a hé lahyǎ lǔ, “Thuôthuô꤮ omyá꤮” tadû́rò a lé è́htǒhtya shyoshyo, “Kố꤮ Davi aphúkhǔ Jesǔ꤮ thè́zò̤ní̤ kuô̌ ré̤ vǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesǔ okuố rò a hé, “Cuốè́hyǎ è bíyě” rò èthǐ cuố è́hyǎ lǔ rò a hé lǔ, “Thè́plè̤̌ tǎmé̤, kahtòmò̌, Jesǔ è́ hò́ nè̤.” ");
INSERT INTO kyu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Rò a plwóhte aca̤klò̌ rò a phatǎ̤kyǎ. Htuô̌rò a pá̤kahtò rò a hyǎ dố Jesǔ a o. ");
INSERT INTO kyu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesǔ sudyǎ lǔ, “Nè̤ thè́zṳ̂́ nò̌me̤ vǎ maǐtě?” Kayǎ mèthèkhí yětôprè̤ hésû lǔ, “Thárá꤮ vǎ thè́zṳ̂́ myáhtye cyá̤ kuô̌ǔ.” ");
INSERT INTO kyu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Rò Jesǔ hé lǔ, “Nè̤ ka̤ní̤ hò́. Nè̤ tè̤zṳ̂́ me̤sǐmé̤ pé̤ nè̤ hò́.” Bínuô tôphuốtuô̌ amèthè lǐhyǎ rò a krwǒcuốkuô̌ Jesǔ akhyě. ");
INSERT INTO kyu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bí èthǐ hyǎtuố̤phû hò́ ná vǐ̤ Jerusalem bí dò̌ Bethphage ná dò̌ Bethania dò̌htû̌ Oliva so khǎshyéakhè̌nuô, Jesǔ nò̌hyǎ ré̤ a khǒpacè̤̌ thè́nyě̤. ");
INSERT INTO kyu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Rò a hé èthǐ, “Hyǎnuô̌ ré̤ lahyǎ dò̌ dố nyěnuô tôdò̌, thǐ hyǎ nuô̌nuô̌ ná thǐ ki myáhtye mya̤ò́lyǎphú plya̤ tôduô̌ dố ǔ sidyánya̤ nò́hí lǔ tôphuố꤮ to tôduô̌ pǎ. Thǐ ki myáhtye ǔ cò̌klò̤ tala̤-e asè bínuô pǎ rò ilyě è rò cwika̤ è bíyě ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kayǎ tôprè̤prè̤ ki sudyǎ thǐ, ‘Thǐ cuố ilyě tuố̤ mya̤ò́lyǎphúyě me̤tě?’ Hérò, ‘Byacè lo nò̌ lǔ nuô, a nò̌htuô̌ lǔ pǎ rò a thǔka̤pryǎ khyěthyá dû pǎ,’ hésû lǔ phúnuô ní꤮.” Jesǔ hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bínuô akhè̌ èthǐ cuốmyáhtye mya̤ò́lyǎphú dố ǔ cò̌klò̤ ophû è ná hikadǎ khǎshyé rò a kahtòo dố klyákǔ tôduô̌. Rò èthǐ cuốilyě lǔplye̤. ");
INSERT INTO kyu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kayǎ kahtòo bí akhǎshyé nuôtahe sudyǎ èthǐ, “Thǐ cuốilyě tuố̤ mya̤ò́lyǎphú plye̤ me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rò èthǐ hésû phú Jesǔ nò̌hé èthǐ nuô rò kayǎ nuôtahe plwǒcwika̤ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Èthǐ cwika̤ní̤ mya̤ò́lyǎphú yěnuô dố Jesǔ a o rò èthǐ idè̌htya lahyǎ aca̤klò̌ dố mya̤ò́lyǎ nyá̤khu rò Jesǔ htyasidyá è. ");
INSERT INTO kyu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kayǎ bè́mṳ dè̌tǎ̤ lahyǎ aca̤klò̌ tahe dố klyádè̌kǔ htuô̌rò dố aruô tahe kuô̌ke rò a pǎ̤ka̤ní̤ thòphyǎ dố alèo tahe dố nyekhu rò ka̤-idè̌tǎ̤ dố klyádè̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Rò kayǎ cuố ré̤ lahyǎ dố nyě tahe, tahe rò a krwǒcuốkuô̌ lahyǎ dốkhyě rò a è́htǒ lahyǎ, “Htuthè́htya lahyǎ Cò́marya!” “Kayǎ dố a hyǎ ná Byacè amwi̤ yětôprè̤nuô, Cò́marya ki sò̌ridû è ní!” ");
INSERT INTO kyu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Kayǎ dố a kíré̤ hyǎ pố pè̤ thyáná pè̤phè̌ Khwí Davi dố꤮ nyénu yětôprè̤nuô, Cò́marya ki sò̌ridû è ní!” “Htuthè́htya lahyǎ Cò́marya dố a o dố mò́khu akhǎlé̤ htyalô̌lố yětôprè̤!” Èthǐ è́mo̤sû lahyǎ Jesǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesǔ cuốtuố̤ dố vǐ̤ Jerusalem akǔ akhè̌nuô, a cuốnuô̌ dố tè̤lǔhǒdu lo̤kǔ rò a cuốlěmyá tava̤lò̌ tè̤pwǒ̤tôcô. Tamò̤́ kíré̤ tǎ̤hò́ akhu-akhyě è ná a khǒpacè̤̌ shyéthè́nyě̤ htecuốkyǎ dố dò̌ Bethania. ");
INSERT INTO kyu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Dốkhyě tônyěnuô bí èthǐ o dố dò̌ Bethania hteka̤ dố klyálo̤ akhè̌, Jesǔ thè́e dǐ. ");
INSERT INTO kyu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Rò a myáhtyecuốlǒ kadwímò̤́ dố alè tahuố tômò̤́. Ma athè o è̌ a tane̤ rò a cuốtǒ dố kadwímò̤́ o, manárò bí a cuốtuố̤ dố kadwímò̤́ o akhè̌nuô, a myáhtye athè tôplò꤮ to, ashuốakhè̌ tǒthè híto akhu-akhyě a o shuô̌shuô̌prè́ alè prè́. ");
INSERT INTO kyu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesǔ hé kadwímò̤́ nuôtômò̤́, “Tôprè̤꤮ ki enò́ kuô̌pǎ tǎ nè̤thè tǎmé̤ ní꤮” a hé phúyěnuô a khǒpacè̤̌ tahe ní̤huô̌ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bí èthǐ cuốtuố̤ dố vǐ̤ Jerusalem akhè̌nuô, Jesǔ cuốnuô̌ dố tè̤lǔtyǎ hǒkǔ rò a cuốnuô̌ cáhtya vè̤́htekyǎ kayǎ ipri̤-isè̌tè̤ bínuô tahe rò a nuô̌htu laklò̤̌tǎ̤kyǎ ǔ lé̤htulya rû̌ a dǐrè̤́htyalô̌ nuôtahe ná khuklyáhtyalô̌ dố ǔ lé̤onyǎ isè̌ ná htulwí̤ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ǔ o bí tè̤lǔhǒdu vǐ̤kǔ nuôrò ǔ kíré̤ cò̤̌cuốkhó ǔtǎ̤tè̤ dố aruô tôpho akhè̌ Jesǔ dyécò̤̌ cuốkhóǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Htuô̌rò a ithyóithya èthǐ, “Dố lisǎsè̌kǔnuô, Cò́marya hé, ‘Vǎhi ma ǔ ki è́ ná myěcôruô pwǒ̤꤮ tôcô lé̤cò́bucò́bè̌ ahi’ “Manárò thǐ cuốnò̌ htwǒhtya lò̌hò́ è ná ‘Prè̤ehuôehí lé̤owóo akhǎlé̤ hò́.’” ");
INSERT INTO kyu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe ní̤huô̌ Jesǔ hé phúyě rò èthǐ myápṳ̌ klyá dố a ki pṳ̌me̤thyě Jesǔ. Kayǎ bè́mṳ tahe yǒ khyéthukhyéthè́ lò̌plǐ Jesǔ a tè̤ithyóithya akhu-akhyě, èthǐ htwǒ khuklò́khuklyǎ nuôtahe thè́isě lahyǎ Jesǔ alé̤. ");
INSERT INTO kyu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bí mò̤́tǎ̤ hò́ akhè̌nuô, Jesǔ ná a khǒpacè̤̌ tahe hteka̤kyǎ dố vǐ̤klò̌. ");
INSERT INTO kyu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Shyéparǒ mò̤́lǐro̤mû́ akhè̌nuô, èthǐ htecuố rwókhyě klyá nuôtôbǒ rò kadwímò̤́ dố Jesǔ isò̌kyǎ lǔ nuô tômò̤́nuô èthǐ myáhtye ná akrǎlò̌ sǐmò̤́ tuố̤ cò́ dố arwí̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Rò Petru thè́né̤htyabè tuố̤ Jesǔ isò̌kyǎ thòmò̤́ yěnuô rò a hé lǔ, “Thárá꤮ myámò̌ dốnuô lé, kadwímò̤́ dố nè̤ isò̌kyǎ lǔ nuôtôthò a thyěkrǎkyǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Rò Jesǔ hésû lǔ, “Zṳ̂́e Cò́marya nuô. ");
INSERT INTO kyu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Vǎ hécò́ cò́ nè̤, kayǎ tôprè̤prè̤ a ki hé soyětômě, ‘Thò́thû́ cuố taphǎkyǎ dố htyědutava̤ akǔnuô,’ rò a ki thè́plòrare to rò a ki zṳ̂́e má̤lakǒ hénuô, a ki htwǒhtya pé̤ lǔ phú a hé nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Phúnuô akhu-akhyě vǎ hé thǐ, thǐ kwǐtè̤ dố Phè̌ Cò́marya a o ǐtětě꤮ bèbènuô zṳ̂́e ná thǐ ní̤bèhò́ nuô, rò thǐ ki ní̤bè má̤lakǒ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Bí thǐ kahtò kwǐcò́bè̌ akhè̌nuô, thǐ ki pṳ̂́o kayǎ tôprè̤prè̤ atè̤thû́ kihérò plwǒkyǎ ètè̤thû́nuô. Thǐ ki plwǒkyǎ tû́ma thǐphè̌ o dố mò́khu yětôprè̤ ki plwǒkyǎkuô̌ thǐ tè̤thû́ phúnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(“Manárò thǐ ki plwǒkyǎ ǔtè̤thû́ to kihérò, thǐphè̌ o dố mò́khu yětôprè̤ plwǒkyǎkuô̌ thǐ tè̤thû́ toto.”) ");
INSERT INTO kyu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesǔ ná a khǒpacè̤̌ tahe cuốtuố̤ khyěthyá dố vǐ̤ Jerusalem rò bí Jesǔ lěcuố dố tè̤lǔtyǎ hǒkǔ akhè̌nuô, bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe, ná Judaphú khuklò́khuklyǎ tahe hyǎ dố lǔo, ");
INSERT INTO kyu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","rò èthǐ sudyǎ Jesǔ, “Nè̤ cuốme̤tuố̤ tè̤phúyě tahe ròma nè̤ cuốme̤ ná ǔpě a taryěshyosò̌ pě? Nè̤ ki me̤tè̤ phúyětahe agněnuô ǔpě nò̌me̤ nè̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesǔ hésû èthǐ, “Vǎ sudyǎ kuô̌ thǐ ngó̤ tômû̌, rò hésû pé̤ kuô̌ vǎ, rò vǎ me̤ tè̤yětahe ná ǔpě a taryěshyosò̌ pěnuô vǎ ki héluô̌ pé̤kuô̌ thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Giovanni Baptista plwǒ pé̤ ǔ htyě yěnuôma Cò́marya dyé lǔ taryěshyosò̌ è̌? Má̤torò prè̤lukayǎ dyé lǔ è̌? Héso pé̤ myá vǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Rò èthǐ kré ní̤dyélǔ, “Pè̤ ki hé, ‘Cò́marya dyé lǔ’ kihérò, a klyá sudyǎ nyǎ hò́ pè̤, ‘Kihéphúnuôrò thǐ zṳ̂́e lǔ to me̤tě?’ Phúnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Rò pè̤ ki hé è, ‘Prè̤lukayǎ dyé lǔ’ kihérò, pè̤ thè́isě kayǎ bè́mṳ yětahe alé̤lé̤.” (Me̤těhérò kayǎ pwǒ̤꤮ tôprè̤ yǒ zṳ̂́e lò̌ ná Giovanni ma prè̤pro̤ má̤lakǒ tôprè̤.) ");
INSERT INTO kyu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Phúnuô akhu-akhyě èthǐ hésû Jesǔ, “Pè̤ thè́gněto.” Rò Jesǔ hésû èthǐ, “Kihéphúnuôrò vǎ me̤tè̤ yětahe ná ǔpě taryěshyosò̌ pě nuô vǎ hésoluô̌ pé̤ thǐ toto.” ");
INSERT INTO kyu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesǔ cáhtya dyá pé̤ bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe ná Judaphú khuklò́khuklyǎ tahe ná ngó̤khákho tahe phúyě, “Bètôphuố, kayǎ o tôprè̤, a isò́iplû̌ ní̤dyé a thòbǐthèmò̤́ tahe dố aprè́khu yě rò a ira̤tava̤bí ní̤dyé lò̌ a thòbǐthèphè yě, rò a ikhûo ní̤dyé ahekǔ tôkǔ dố a lé̤izí̤hte ná thòbǐthèhtyě, rò a isò́htyaní̤ lé̤thûhtyalô̌ dố ǔ lé̤opò̤́myá ná thòbǐthèphè yěnuô tômě. Htuô̌rò a khyǎekyǎ kuố ná prè̤khyǎe tahe rò a htecuốkyǎ dố ké̤aruô tôké̤. ");
INSERT INTO kyu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Bí thòbǐthè mǐhò́ akhè̌nuô, thòbǐthèphè byacè nò̌hyǎ a prè̤me̤tè̤phú tôprè̤ dố prè̤khyǎe yětahe a o rò a nò̌hyǎ phyéka̤kuô̌ lǔ thòbǐthè dố a tǒkò ní̤bèkuô̌ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Prè̤khyǎeprè́ yětahe pṳ̂́ lǔ rò mṳ̂̌sûpò̤sûhtuô̌ lǔlulé yětôprè̤ rò a plwǒka̤ kazuô̌klíkyǎ prè́ lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Htuô̌rò thòbǐthèphè byacè nò̌hyǎ tapleke a prè̤me̤tè̤phú dố aruô tôprè̤ dố èthǐ a o rò èthǐ mṳ̂̌ lǔkhuklò́ htuô̌to me̤tarè̤̌ lò̌plǐ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Thòbǐthèphè byacè nò̌hyǎ pó̤ a prè̤me̤tè̤phú dố khyě tôprè̤ rò èthǐ me̤thyěkyǎ lǔ. Èthǐ mṳ̂̌pò̤ ǔ tahe me̤thyěkyǎ ǔ tahe. Èthǐ me̤ ǔ phúyě nuôma a o è́ nyacò́ hò́. ");
INSERT INTO kyu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Thòbǐthèphè byacè lé̤nò̌hyǎpó̤ ǔ nuô a okyǎ pǎprè́tû́ aphúkhǔ dố a mo̤ ní̤dyé yětôprè̤ prè́. Dốkhyětadû rò a tane̤, ‘Vǎ ki nò̌hyǎ vǎ phúprè̤khǔ ma a bezṳ̂́benyá̤ klò̌pǎ kǒle,’ a tane̤ rò a nò̌hyǎ lǔ dố prè̤khyǎe yětahe a o. ");
INSERT INTO kyu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Manárò prè̤khyǎe yětahenuô a hébèdônyǎ dyé lǔ tôprè̤ ná tôprè̤ rò a hé lahyǎ, ‘Kayǎ yětôprè̤ ma thòbǐthèphè byacè aphúkhǔ dố a kíré̤ ní̤bè ucè̌tazè̌ nuôtôprè̤ hò́. Cuố! Cuốme̤thyěkyǎ lǔ pó꤮! A ucè̌tazè̌ tahenuô a ki htwǒlò̌ pè̤tè̤ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A hé lahyǎ rò èthǐ pṳ̂́ me̤thyěkyǎ thòbǐthèphè byacè aphúkhǔyě rò a vǐhtekyǎ lǔ dố thòbǐthèphèklò̌,” Jesǔ hékhákho pé̤ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Htuô̌rò Jesǔ sudyǎ èthǐ, “Ki me̤phúnuôrò thòbǐthèphè byacè yětôprè̤nuô a ki me̤ phútě pǎ? A hyǎ me̤thyěkyǎ prè̤khyǎeprè́ nuôtahe rò a ki plwǒkhyǎe tapleke ná kayǎ dố aruô tahe pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Htuô̌rò Jesǔ hé khyěthyá èthǐ, “Lisǎsè̌kǔ hé, ‘Kayǎ me̤htya hi rò lò̤́ dố èthǐ vǐkyǎ lǔ nuôtôměnuô a htwǒhtya lò̤́ dố a tahtwóma lò̌ cò́ hitômě cò́. ");
INSERT INTO kyu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yěnuôma Byacè Cò́marya me̤tè̤ prè́, rò a me̤tè̤ yěnuôma a tè̤pro̤tè̤prya̤ nyacò́.’ “Lisǎsè̌kǔ hé phúyěnuôma thǐ hốnò́ kuô̌ǔ tôphuố꤮ to è̌? Thǐ klyá hốnò́ nyǎ prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Judaphú khuklò́khuklyǎ tahenuô, a thè́gně ná Jesǔ dyá khákho èthǐ ná prè̤vǐkyǎ lò̤́ nuôtômě ma èthǐ hò́ akhu-akhyě a myápṳ̌ lahyǎ klyá dố a kíré̤ pṳ̂́ Jesǔ tadû́rò èthǐ thè́isě kayǎ bè́mṳ nuôtahe alé̤ rò èthǐ htecuố taphǎkyǎ prè́ Jesǔ khǎlé̤. ");
INSERT INTO kyu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ǔ nò̌hyǎ Pharisěophú tahe ná Khwí Herodè akayǎ tahe dố Jesǔ a o dố a ki hyǎ myápṳ̌ pṳ̂́ lahyǎ Jesǔ hébèthû́ngó̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Èthǐ hyǎ dố Jesǔ a o rò a hé lahyǎ lǔ, “Thárádu꤮ pè̤ thè́gně ná nè̤ ma kayǎcò́kayǎte̤ rò a hébècò́prè́ ngó̤ tôprè̤. Nè̤ thè́isě kuô̌ǔlé̤ tôprè̤꤮ to, nè̤ myádumyápatí kuô̌ǔ tôprè̤꤮ to. Nè̤ dǎ ithyóithyahò́ ǔ tè̤má̤tè̤cò́ hénuôma, nè̤ ithyó pé̤ cò́ ǔ phú Cò́marya thè́zṳ̂́ nò̌ithyó nè̤ nuô cò́. Phúnuôrò pè̤ dyé amo-arǎ dố Khwí Caesare a o nuôma atǒ è̌? Ma atǒ to è̌? ");
INSERT INTO kyu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pè̤ tǒkò dyé è è̌? Ma pè̤ tǒkò dyé to è̌? Héso pé̤myá pè̤.” Tadû́rò èthǐ hyǎ hébè khobye prè́ nuô Jesǔ thè́gně rò a hésû èthǐ, “Thyáphú thǐ ki pṳ̌ pṳ̂́ní̤ vǎ tè̤hébèthû́ tahe rò thǐ hyǎ sudyǎkhásudyǎkho myábye vǎ phútě? Hyǎdyé pé̤ myá vǎ thǐrû̌zye nuôtôbè,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Rò èthǐ hyǎdyé lǔ rû̌zye denari nuôtôbè rò a sudyǎ èthǐ, “Yěma ǔpě khuklò́zǎ̤zo̤ pě? A rǎo ná ǔpě amwi̤pě?” Rò èthǐ hésû lǔ, “Khwí a khuklò́zǎ̤zo̤ ná khwí amwi̤.” ");
INSERT INTO kyu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Htuô̌rò Jesǔ hé èthǐ, “Khwídu Caesare atè̤ kihérò dyé ná khwídunuô, Cò́marya atè̤ kihérò dyé ná Cò́marya nuô.” Jesǔ hé èthǐ phúnuô rò èthǐ khyéthukhyéthè́ lò̌plǐ cò́ Jesǔ khǎlé̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saducěophú thǐtahe lé̤klǒ hé lahyǎ ná ǔ thyěhtuô̌ nuô ǔ htwǒprè̤ ka̤khyě cyá̤ pǎ takhyá꤮ to phúnuô. Rò èthǐ hyǎ dố Jesǔ a o rò sudyǎ lǔ, ");
INSERT INTO kyu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Thárádu꤮, Mosè rǎkyǎ tè̤thyótè̤thya tômû̌ dố pè̤gně rò a hé, kayǎ tôprè̤prè̤ ki thyěkyǎ amě khǎlé̤, rò aphú ki okyǎ tôprè̤꤮ to hénuô, thyáphú aklwǐalyǎ ki okyǎ nuôrò, a puố̤prè̤khǔ bè phyédwó akhǐ okyǎyě, a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tôphuốnuô puố̤ ná vyá̤ prè̤khǔ o thuô̌thyótôprè̤. A vyá̤prè̤́lố tôprè̤ phyé amě rò bí a thyěkhè̌nuô aphú okyǎ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Rò apuố̤ ahò́lè̤̌lya̤ tôprè̤ phyédwó khyěthyá akhǐyě rò a thyěkyǎpó̤ rò aphúalye̤ okyǎ tôprè̤꤮ to. Apuố̤ thuô̌prè̤tôprè̤ nuô a htwǒhtya thyá kuô̌lò̌ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Puố̤návyá̤ thuô̌thyótôprè̤ yěnuô, a htwǒhtya thyá lò̌plǐ lǔ phúnuô, rò èthǐ yě thuô̌thyótôprè̤ ní̤cû̌ lò̌plǐ lǔ amě tôprè̤꤮ tuô̌ rò a thyěkyǎ lò̌plǐ, aphúokyǎ lahyǎ tôprè̤꤮ to rò dốkhyětadûnuô prè̤mò yětôprè̤ thyěkyǎ kuô̌ pó̤. ");
INSERT INTO kyu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Phúnuôrò shyé꤮ ǔ thyěihtòka̤khyě amò̤́nyě pǎ tônyěnuô, prè̤mò yětôprè̤ ki htwǒ bítě tôprè̤ amě pǎpě? Me̤těhérò èthǐ puố̤návyá̤ thuô̌thyótôprè̤ ní̤cû̌lò̌ lǔ prè̤mò yětôprè̤ prè́ nuô̌꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesǔ hésû èthǐ, “Thǐ zṳ̂́ethû́ lò̌hò́, thǐ thè́gně tǎ̤te̤ kuô̌ǔ lisǎsè̌ ná Cò́marya a tè̤pro̤tè̤prya̤ me̤cyá̤ tè̤ tahe to. ");
INSERT INTO kyu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Me̤těhérò shyé꤮ ǔ thyě ihtòka̤khyě pǎnuô ǔ phyéphúphyémě, ǔ phyéphúphyévè̤ o pǎtohò́, èthǐ ki thyákuô̌lò̌ phú mò́khutanéphú nuôtahe pǎhò́. ");
INSERT INTO kyu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mosè rǎmákyǎ tè̤htwǒprè̤ ka̤khyě ari-akyǎ dố a libakǔ bí miû̌ cǎcuố̤ atè̤dyá nuôtôtó̤ akǔnuô, vǎ tane̤ ná thǐ hốnò́ hò́. Bí likǔnuô, Cò́marya hé Mosè phútě hérò, ‘Vǎ ma Abraham a Cò́marya, Isaac a Cò́marya, ná Jacob a Cò́marya,’ Mosè rǎkyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Cò́marya ma kayǎthyě tahe a Cò́marya má̤to, kayǎ htwǒprè̤ tahe a Cò́marya. Thǐ zṳ̂́ethû́ lò̌lá̤takli cò́,” a hé Saducěophú thǐtahe phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bínuôakhè̌ prè̤ithyó tè̤thyótè̤thya athárá obínuô tôprè̤ rò a ní̤huô̌ èthǐ kryá̤ lǔ. A myáhtye ná Jesǔ hé ka̤khyěsû cyá̤ nyacò́ èthǐ akhu-akhyě a sudyǎ Jesǔ, “Tè̤mekyǎngó̤ lò̌꤮ plǐ aklè̌ nuôma a lodulố ǔ ma bítě tômû̌tě?” ");
INSERT INTO kyu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Rò Jesǔ hésû lǔ, “Tè̤mekyǎ dố a lodulố ǔ ma ǐtě hérò, ‘Kố꤮ Israelphú thǐ꤮, ní̤dǎ lahyǎ꤮ Byacè o prè́tû́ pè̤ Byacè Cò́marya yětôprè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Rò thǐ bè mo̤ lò̌thulò̌thè́ thǐ Cò́marya ná thǐ thè́plò sǐmělò̌, mo̤ lò̌thulò̌thè́ è ná thǐ tè̤ohtwǒprè̤ lò̌꤮ plǐ, mo̤ lò̌thulò̌thè́ è ná thǐ tè̤tane̤ lò̌꤮ plǐ,’ yěnuôma tè̤mekyǎngó̤ aré̤lố tômû̌ dố a lodulố ǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tè̤mekyǎngó̤ nyě̤mû̌tômû̌ ma, ‘Thǐ bè mo̤ ní̤dyé thǐhi khǎsò̌khǎshyé tahe phú thǐ mo̤lya̤ ní̤dyé thǐné̤ nuô.’ Tè̤mekyǎngó̤ dố a lodulố ná yě dố aruô nuôma a o pǎto hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Prè̤ithyó tè̤thyótè̤thya athárá yětôprè̤ hésû Jesǔ, “Thárá꤮ nè̤ hé nuôma a tǒtû́ cò́, nè̤ hé ná Cò́marya o prè́tû́ tôprè̤꤮ tuô̌, Cò́marya dố aruônuô a o pǎ tôprè̤꤮ to nè̤ hé nuôma a má̤lakǒ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pè̤ bè mo̤ lò̌thulò̌thè́ pè̤ Cò́marya ná pè̤ thè́plò sǐmělò̌, ná pè̤ tè̤tane̤ lò̌꤮ plǐ, pè̤hè̌pè̤re lò̌꤮ plǐ. Htuô̌to pè̤ bè mo̤ní̤ kayǎ dố aruôtahe thyáná pè̤ mo̤ ní̤dyé pè̤né̤ nuôma aryáklò̌ pǎ cò́ ná lò̌꤮ pè̤ sû́û̌ me̤lǔhtya tè̤phútè̤lye̤ sǐduô̌ ná mi ná lò̌꤮ pè̤ me̤lǔhtya tè̤ dố aruô tahe cò́ nuôma vǎ thè́gně,” a hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesǔ myáhtye ná kayǎ yětôprè̤ hésû cyá̤dè nyacò́ rò a hé lǔ, “Nè̤ phû nuô̌ní̤ talí꤮ lǎ hò́ dố Cò́marya a htyělé̤ké̤kǔ hò́,” a héhtuô̌ lǔ rò dốkhyěnuô ǔ sudyǎbû pǎ Jesǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bí Jesǔ ithyóithya ǔ dố tè̤lǔtyǎ hǒkǔ akhè̌nuô, a sudyǎ ǔ, “Prè̤ithyó tè̤thyótè̤thya athárá tahe a hé ná Krístu dố a me̤lwóhteka̤ ǔ yětôprè̤ nuôma a tǎ̤klwǐtǎ̤lyǎ kalya̤ dố Khwí Davi a hé phúnuô vǎhéto? ");
INSERT INTO kyu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Me̤těhérò Khwí Davi ané̤byacè ní̤dû nuô Thè́ Sǎsè̌ Byacè hturyǎ̤ lǔthè́plò rò a nò̌hé lǔ, ‘Byacè Cò́marya hé vǎ Byacè, “Onyǎo dố vǎ takhu cò́htwó yětôkyě, onyǎo tuố̤ shyé꤮ vǎ me̤pé̤ lò̌plǐ hò́ lò̌꤮ kayǎ dố a thè́hte nè̤ nuôtahe hyǎcṳ̌e ò́lya̤ lò̌hò́ dố nè̤ o pǎ nuô ní꤮.”’ ");
INSERT INTO kyu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Davi ané̤byacè ní̤dû a è́ Krístu dố a me̤lwóhteka̤ ǔ yěnuô tôprè̤, ‘Byacè’ akhu-akhyě a cuố htwǒ cyá̤ Khwí Davi aphúkhǔ phútě?” Kayǎ bè́mṳ tahe thè́krṳ̂̌thè́lò̌ ní̤dǎ lahyǎ Jesǔ a tè̤ithyóithya. ");
INSERT INTO kyu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bí Jesǔ ithyóithya ǔ akhè̌nuô, a hé, “Rò̤ní̤ lahyǎ thǐné̤ ná prè̤ithyó tè̤thyótè̤thya athárá nuôtahe ní꤮. Èthǐ nuôtahe ma a phyéduphyéhtyalô̌ lahyǎ ané̤ rò a thè́zṳ̂́ thyá lahyǎ ca̤cwo̤karo̤ tahe rò bí a myáhtye tǎ̤sû ná ǔ dố klè́kǔ akhè̌nuô, a thè́zṳ̂́ nò̌hébè bezṳ̂́benyá̤ ǔ ná ané̤. ");
INSERT INTO kyu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Htuô̌to dố tè̤cò́bè̌hǒkǔ nuôbèbè, dố pwè̌kǔ nuôbèbè, èthǐ thè́zṳ̂́ onyǎo lahyǎ khǎlé̤ dố ǔ dyaduzṳ̂́nyá̤ní̤ è nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Thyáphú èthǐ ki ní̤bè prè̤mòokryá tahe ahinuôrò, èthǐ ilò̌ilyá ǔ, htuô̌to thyáphú ǔ ki ní̤dǎní̤ rò ǔ ki myáhtye pǎ tǎ èthǐ tè̤thû́ tǎmé̤ agněnuô, a kwǐcò́bè̌htǔ pé̤ ǔ. Dố èthǐ me̤phúnuô akhu-akhyě èthǐ ki khyábè cyě̤klò̌lố cò́ ǔ tè̤cirya pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesǔ onyǎphû bí ǔ lé̤be-oplò́ rû̌tố khǎlé̤ anyěhyǎ nuô rò a myá kayǎ tahe hyǎ sunuô̌ rû̌ akhè̌, kayǎ duzá̤htyathè̌ è́prè̤ hyǎ sunuô̌ è́nyacò́ rû̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Manárò prè̤mòokryá dố a sǒphásǒrya̤ o tôprè̤ rò a hyǎ sunuô̌ kuô̌ rû̌ talǐli̤ nyě̤myé dố angṳ krṳ̂nya̤ prè́ ná rû̌ tôpè̌ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Rò Jesǔ è́plò́ a khǒpacè̤̌ tahe dố a o rò a hé èthǐ, “Vǎ hécò́cò́꤮ thǐ, lò̌꤮ kayǎ dố a hyǎsunuô̌ rû̌ dố lé̤sunuô̌ rû̌tốkǔ yěnuô prè̤mòokryá nuôtôprè̤ sunuô̌ è́klò̌lố cò́ ǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Me̤těhérò lò̌꤮ a hyǎsunuô̌ rû̌ nuôtahema, a tè̤olốobǎ sû́lû̌ rò a hyǎsunuô̌ prè́ lahyǎ atè̤ o kyǎsò̌kyǎse kyǎ nuôtahe prè́. Manárò prè̤mòokryá yětôprè̤ nuôma a sǒphásǒrya̤, a tè̤olốobǎ to tadû́rò a hyǎsunuô̌ lò̌plû́kyǎ cò́ arû̌ dố a lé̤buôe ná a thè́plòhtwǒprè̤ agně yěnuô cò́.” ");
INSERT INTO kyu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bí Jesǔ htecuốkyǎ dố tè̤lǔhǒdu vǐ̤kǔ akhè̌nuô, a khǒpacè̤̌ tôprè̤ hé lǔ, “Thárá꤮ nè̤ myámò̌ lò̤́du ná hiduhihtǔ dố nuôtahe lé, atwó̤ nyacò́!” ");
INSERT INTO kyu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Rò Jesǔ hésû lǔ, “Hiduhihtǔtwó̤ dốnuô tahenuô, thǐ myáhtye vǎ hé? Lò̌꤮ lò̤́du nuôtahenuô ǔ ki hyǎdò tǎ̤prò̤kyǎ lò̌ è pǎ. Lò̤́ yětahenuô a oícû̌ pǎ cò́ lǔ tômě꤮ cò́ to pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bí Jesǔ onyǎo dố Oliva sokhu rò a myácuố tǒdè̌ dố tè̤lǔhǒdu o akhè̌nuô, Petru, Jakomo, Giovanni, Andrea, hyǎhuôní̤ dố lǔo rò hyǎsudyǎ lǔ, ");
INSERT INTO kyu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nè̤ hé yětahenuô a ki htwǒhtya bíkhè̌tě pǎ? Bí lò̌꤮ tè̤yětahe kíré̤ htwǒhtya htuô̌plû́lò̌hò́ pǎnuô tè̤pro̤tè̤prya̤ amáadyǎ tôcôcô ki oluô̌htya ré̤ pǎ è̌?” ");
INSERT INTO kyu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesǔ hé èthǐ, “Rò̤ní̤ lahyǎ thǐné̤ ná kayǎ dố a ki hyǎ ilolahǒ thǐ pǎ nuôtahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kayǎ è́prè̤ ki klwohyǎ ané̤ thyáná vǎ nuô pǎ rò a ki dákwó lahǒ lya̤ ní̤dyé lahyǎ ané̤, ‘Vǎ ma Krístu dố a me̤lwóhteka̤ ǔ nuôtôprè̤’ htuô̌rò a ki ilolahǒní̤ è́nyacò́ ǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bí thǐ ní̤huô̌ ǔ sá pra̤rû́pra̤tè́ lǔ dố aphû bèbè, thǐ ní̤huô̌ ǔ dyá pé̤ thǐ tè̤sátè̤pǎ̤ ari-akyǎ dố aye̤ tahenuô bèbè, thè́isě lahyǎ tǎmé̤ ní꤮. Me̤těhérò phúyě tahe nuôma a bè htwǒhtya nyǎ pǎ, manárò yěnuôma hekhu kíré̤ tadû hò́nuô má̤híto. ");
INSERT INTO kyu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Me̤těhérò myěcô tôcô ná tôcô, htyěké̤ tôké̤ ná tôké̤ kisákipǎ̤ lǔ pǎ. Tanéhtò́dǐ tahe ki ohtyahtǒohtyalya̤ lò̌plǐ dố hekhuyě tôpho htuô̌ tôpho pǎ. Ké̤vǐ̤ké̤kò̌ ki ohtya pǎ. Tè̤htwǒhtya yětahe nuôma má̤pǎprè́ tè̤cyě̤tè̤cṳ̂ a khǎshyékhǎrya̤ dố athyáná prè̤mò kíré̤ phúo hò́sè̌nuô hyǎtuố̤ mópǎprè́. ");
INSERT INTO kyu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Thǐ bè rò̤ní̤ lahyǎ thǐné̤. Dố vǎkhuvǎkhyě rò ǔ ki pṳ̂́ thǐ pǎ, rò ǔ ki thǔhtya thǐ dố prè̤cirya khuklò́khuklyǎ tahe a mèthènyě pǎ. Ǔ kimṳ̂̌kipò̤ thǐ dố tè̤cò́bè̌hǒkǔ pǎ. Thǐ bè kahtòo dố prè̤pốtarítè̤ tahe ná khwí tahe anyěhyǎ pǎ rò a ki cirya thǐ pǎ rò thǐ ki hésodônyǎ ní̤pé̤ èthǐ ná tè̤thè́krṳ̂̌mila ari-akyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Manárò bí hekhu tadû tyahíto yě akhè̌nuô, thǐ tǒbè cuố hésoluô̌ pé̤ prè̤lumyě pwǒ̤꤮ tôcô ná tè̤thè́krṳ̂̌mila ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ǔ pṳ̂́thǔhtya thǐ dố khwíhi bíkhè̌tě꤮ bèbè, thǐ tǒbè hébè phútě phútěnuô bèzò̤one ré̤ tǎ lahyǎ tǎmé̤ ní꤮. Me̤těhérò shuốkhè̌ hyǎtuố̤ pǎ rò thǐ ki hébè tû́dû má̤to, Thè́ Sǎsè̌ Byacè ki héso me̤cwó̤ dû thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","“Bínuôakhè̌ pǎnuô, puố̤ ki nò̌me̤thyě ní̤dyédû avyá̤ ná ǔruô pǎ, rò vyá̤ ki nò̌me̤thyě ní̤dyédû apuố̤ ná ǔruô pǎ, phè̌ ki nò̌me̤thyě ní̤dû aphú ná ǔruô pǎ, phú tahe ki vû́ ka̤khyěsû ní̤dyédû amuố̤aphè̌ tahe pǎ, rò a ki nò̌me̤thyě ní̤dyédû ǔ ná amuố̤aphè̌ pǎ. Dố vǎkhuvǎkhyě rò kayǎ pwǒ̤꤮ tôprè̤ ki thè́hte lò̌ thǐ pǎ. Manárò kayǎ dố a ihtòtanyǎ oklò̤sò́ma dố a tè̤zṳ̂́tè̤nyá̤ akǔ tuố̤dố atadû tahenuô Cò́marya ki me̤lwóhteka̤ èthǐ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jesǔ héplehyǎ pó̤, “Manárò tè̤tôcô dố Cò́marya thè́zò̤́ thè́hte myáhtye è nuô, thǐ ki myáhtye è pǎ. A tǒ o dố tè̤lǔtyǎ hǒkǔ má̤to rò a cuố o bínuô pǎ. (Kayǎ hố li yětahe tǒbè thè́gněplǒ lahyǎ.) Bí thǐ myáhtye a htwǒhtya hò́ phúyě akhè̌ pǎnuô, kayǎ o dố Juda ké̤kǔ nuôtahe bè klyahtya siplè́ lahyǎ ané̤ dố sokhu. ");
INSERT INTO kyu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kayǎ dố a o dố hikhu tahenuô, bí a klyatǎ̤ akhè̌ a tǒbè nuô̌phyécuốní̤ a tǎ̤muô̌tǎ̤tè̤ dố hikǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kayǎ me̤tè̤ dố lyá̤khu tahenuô a bè klyaka̤ phyéní̤ aca̤ dố hi to. ");
INSERT INTO kyu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bínuôtônyě pǎma prè̤mò dố amuố̤dò̌ ná muố̤ dố a oná aphú dố a ǒnú pǎprè́ lǔ nuôtahe agněma shuốkhè̌ cyě̤cṳ̂ nyacò́ dố èthǐgně pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Thyáphú tè̤cyě̤tè̤cṳ̂ yě ki tǎ̤tǒ tǎ ná ké̤ró̤khè̌ tǎmé̤ nuô, thǐ tǒ kwǐcò́bè̌ lahyǎ Cò́marya pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Èthǐ tǒbè kwǐcò́bè̌ lahyǎ me̤těhérò, tè̤cyě̤tè̤cṳ̂ amò̤́nyě yětahe pǎ nuô, cáhtya dố Cò́marya byálya̤lú tè̤ tuố̤khǒnyá̤ yěnuô a me̤nò́ phúnuô tôphuố꤮ to. Bínuôkhè̌pǎ tè̤cyě̤tè̤cṳ̂ yětahenuô a ki cyě̤lốǔkhǒ pǎ rò dốkhyěpǎ nuô a ki htwǒhtyanò́ pǎ phúnuô tôphuố꤮ to pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Byacè ki me̤phuô tè̤cyě̤tè̤cṳ̂ amò̤́nyěmò̤́thè̌ to hénuôma ǔ siplè́bè́ nuô a o tôprè̤꤮ to. Manárò kayǎ dố Cò́marya nwóhtya one htuô̌hò́ lǔ tahe agněnuô Byacè ki me̤phuô pé̤ èthǐ amò̤́nyěmò̤́thè̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","A htwǒhtya phúnuô htuô̌pǎrò kayǎ tôprè̤prè̤ ki hé thǐ, ‘Myámò̌ lahyǎ, yě ma Krístu dố a me̤lwóhteka̤ ǔ nuô tôprè̤ hò́,’ má̤torò a ki hé thǐ, ‘Cuố myámò̌ lahyǎ, Krístu dố a me̤lwóhteka̤ ǔ nuôtôprè̤ a o dố nuô,’ a ki hé thǐ phúnuô pǎ manárò zṳ̂́e tǎ lahyǎ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Me̤těhérò kayǎ dố a klwolahǒ ané̤ phú Krístu dố a me̤lwóhteka̤ ǔ yětôprè̤ tahenuô ná kayǎ dố a klwolahǒ ané̤ phú prè̤pro̤ tahenuô, a ki oluô̌htya pǎ. Thyáphú èthǐ ki ilolahǒ ní̤tuố̤ kuô̌dû kayǎ dố Cò́marya nwóhtya htuô̌hò́ lǔ yětahenuô, èthǐ ki me̤cyá̤ hérò, a ki me̤luô̌htya atè̤me̤ tè̤pro̤tè̤prya̤ tahe ná atè̤me̤ tapa̤ khyéthukhyéthè́ ǔ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Rò̤ní̤ lahyǎ thǐné̤ ní꤮. Bí tè̤yětahe htwǒhtya tyahíto yěnuô, vǎ héso one ré̤ pé̤ lò̌ htuô̌hò́ thǐ pwǒ̤꤮ tôcô hò́,” Jesǔ hékyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Rò Jesǔ hé plehyǎ pó̤, “Bí tè̤cyě̤tè̤cṳ̂ amò̤́nyěmò̤́thè̌ tahe cuố talwóhtuô̌hò́ pǎ nuô, ‘Cò́marya ki me̤ khíkyǎ tamò̤́ pǎ. Lè̌ ki lǐ pǎtohò́. ");
INSERT INTO kyu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sè dố mò́lè̤̌ tahe ki latǎ̤prò̤kyǎ lò̌pǎ. Cò́marya ki me̤kazikazuô̤̌ lò̌lò̌꤮ mò́lè̤̌ a tè̤pro̤tè̤prya̤ nuôtahe pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Htuô̌rò èthǐ ki myáhtye lahyǎ prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎlya̤ dố ò́luố̤klè̌ pǎ, rò a ki olốbǎ cò́ ná a tè̤pro̤tè̤prya̤ ná a tè̤taryědu taryěhtǔ dố ashyo-asò̌ yěnuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Htuô̌rò prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě a ki nò̌hyǎlya̤ tanéphú tahe pǎ rò vǎ ki nò̌cuố èthǐ dố hekhu lwǐ̤ná̤ pǎ, èthǐ ki cáhtya cuố dố mò́dá khǎshyé tuố̤dố mò́dá tadû pǎ rò èthǐ ki cuốè́plò́ kayǎ dố Cò́marya nwóhtya htuô̌hò́ èthǐ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Phyéní̤ lahyǎ tè̤ithyó dố kadwímò̤́ onuô. Bí aphyǎ tahe dyácè̤́htya hò́ rò alè tahe dyácè̤́hte hò́ akhè̌nuô, ké̤kṳ́khè̌ phûhyǎtuố̤hò́, thǐ thè́gně lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Phúnuôhò́ bí thǐ myáhtyehò́ tè̤yě tahe htwǒhtyahò́ akhè̌pǎnuô, thè́gně lahyǎ ná prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě a hyǎphûtuố̤hò́ dố kadǎkǔhtû̌ hò́ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Vǎ héluô̌cò́cò́꤮ cò́ thǐ, lò̌꤮ kayǎ dố a ohtwǒprè̤ khǒnyá̤yětôhtû̌ tahe thyělò̌ tyahíto nuô, tè̤yětahe ki htwǒhtya lò̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mò́khu ná hekhu ki sǐmé̤kyǎ pǎ tadû́rò vǎlǎ̤vǎngó̤ yětahenuô a sǐmé̤kyǎ pé̤ takhyá꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Manárò tè̤yětahe ki htwǒhtya mò̤́nyěmò̤́thè̌, má̤torò ashuốakhè̌ bíkhè̌tě pǎnuô ǔ thè́gně tôprè̤꤮ to. Tanéphú o dố mò́khu nuôtahe cò́ bèbè a thè́gně to. Aphúkhǔ ná ané̤ yětôprè̤ cò́꤮ bèbè, a thè́gně toto. A thè́gně prè́tû́ vǎphè̌ tôprè̤꤮ tuô̌prè́. ");
INSERT INTO kyu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Otaritaryǎ lahyǎ thǐné̤, rò̤ní̤ lahyǎ thǐné̤ ní꤮, me̤těhérò a ki htwǒhtya pǎ bíkhè̌tě nuô thǐ thè́gně to. ");
INSERT INTO kyu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yěma athyáná kayǎ tôprè̤ dố a kíré̤ htecuố klyá dố htyěké̤ aruô tôké̤ rò a nò̌myánò̌khwèkyǎ ahi ná a prè̤me̤tè̤phú tahe rò a htecuố. A dyétǎ̤kyǎ khódû èthǐ tôprè̤ ná tôprè̤ atè̤me̤ rò a hékyǎ prè̤opò̤́ kadǎ nuôtôprè̤ ná a ki opò̤́ thǎklyǎsû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Hibyacè ki ka̤khyě bíkhè̌tě pǎ nuô thǐ thè́gně to. Ma a ka̤khyě shyé꤮ mò̤́hé pǎ è̌, má̤torò ma a ka̤khyě shyé꤮ mò̤́ne̤khè̌ pǎ è̌, má̤torò ma a ka̤khyě shyé꤮ shyě i-u pǎ è̌, má̤torò shyé꤮ mò̤́lǐkhè̌ pǎ è̌ nuô, thǐ thè́gně to akhu-akhyě thǎklyǎsû lahyǎ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Me̤těhérò hibyacè ki ka̤tuố̤khyé pǎ rò thyáphú a ki myáhtye tǎ thǐ omyění̤ sǒtapa̤ tǎmé̤ nuô, o thǎklyǎsû lahyǎ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tè̤ dố vǎ hé pé̤ thǐyě tahe nuôma, vǎ hétuố̤pé̤ kuô̌lò̌ ǔ pwǒ̤prè̤, phúnuôrò ‘Opò̤́ thǎklyǎsû lahyǎ ní꤮.’” ");
INSERT INTO kyu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bí tè̤cuốtalwópwè̌ ná pwè̌ekhò́mǔ sǒdǒ huô̌mûtapho bè tyahíto nyě̤nyě akhè̌nuô, bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe myápṳ̌ klyá tôbǒbǒ dố a ki pṳ̂́me̤thyě huôkyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Me̤těhérò èthǐ hé, “Bí pè̤ me̤pwè̌ akhè̌yěnuô pè̤ tǒ pṳ̂́ní̤ lǔ to, pǎma kayǎ bè́mṳ tahe thè́plòdu rò a me̤tarû̌tapyǎ lò̌he.” ");
INSERT INTO kyu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bí Byacè Jesǔ o dố dò̌ Bethania Simonè dố tè̤sè̌mǔmyá̤ dố phálo̤ bènò́ lǔ nuôtôprè̤ ahi rò a onyǎ esè dố dǐrè̤́htyalô̌ akhǎshyé akhè̌nuô, prè̤mò tôprè̤ phyéhyǎní̤ pyǎ̤ dố ǔ me̤ è ná lò̤́bǔ dố a obǎ ná nardú htyěnuô̤mû́ ngṳdupri̤du tashuô̌ryá yěnuô tôpyǎ̤. A hyǎdòphè́ pyǎ̤ akhǎu yěrò a lyátǎ̤ dố Byacè Jesǔ khuklò́lo̤. ");
INSERT INTO kyu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rò dố èthǐklè̌ tahehenuô a thè́plòdu rò a hé ní̤dyélǔ, “A cuố me̤kyǎdě lò̌ htyěnuô̤mû́ phúnuôma me̤tě? ");
INSERT INTO kyu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Htyěnuô̤mû́ yětôpyǎ̤nuô angṳ o cò́ rû̌zye denari thuô̌cwè̤́ lố cò́ rò, isè̌kyǎ è rò cuốdyé ná kayǎ sǒphásǒrya̤phú nuôma aryáklò̌,” èthǐ héhtuô̌ phúnuô rò èthǐ dya lahyǎ prè̤mò nuôtôprè̤ a tè̤thû́. ");
INSERT INTO kyu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Rò Jesǔ hé èthǐ, “Me̤dídyǎ tǎ è tǎmé̤. Thǐ cuố me̤dídyǎ tǎ̤tṳ̂̌ è me̤tě? A me̤dû kǒkǒ. A me̤twó̤me̤ryá nyacò́ hò́ tè̤ dố vǎgně hò́. ");
INSERT INTO kyu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kayǎ sǒphásǒrya̤phú tahe otố̤kuô̌ ná thǐ pwǒ̤꤮ tôphuố cò́. Thǐ ki thè́zṳ̂́ me̤cwó̤ èthǐ bíkhè̌tě꤮ nuôma aní̤ prè́, manárò vǎyěnuô vǎ otố̤lǎ kuô̌ ná thǐ to. ");
INSERT INTO kyu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Prè̤mò yětôprè̤nuô bá꤮ a me̤bè́ nuô rò a me̤ htuô̌hò́ vǎ hò́. A hyǎ plò̤́ vǎné̤ ná htyěnuô̤mû́ yěnuôma bí ǔ iluố tyahí vǎ to yěnuô a taritaryǎ one ré̤ hò́ tè̤ dố vǎgně hò́. ");
INSERT INTO kyu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Vǎ hécò́꤮ cò́ thǐ, shyé꤮ ǔ lě hésodônyǎ hò́ tè̤thè́krṳ̂̌mila yě dố hekhu yětôba bítě꤮ tôpho pǎ bèbè, ǔ ki tane̤htya tuố̤bèní̤ è pǎ rò ǔ ki dyáluô̌ní̤ tè̤ dố a me̤htuô̌hò́ yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dố Byacè Jesǔ a khǒpacè̤̌ shyéthè́nyě̤ aklè̌ amwi̤ ná Juda Iscariot héyětôprè̤nuô, thyáphú a ki isè̌tǎ̤kyǎ ní̤ Jesǔ nuô rò a htecuố dố bwídukhu tahe a o. ");
INSERT INTO kyu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bí bwídukhu tahe ní̤huô̌ tè̤ritè̤kyǎ yě akhè̌nuô, èthǐ thè́krṳ̂̌thè́lò̌ ò́lya̤sû Juda ná a ki dyé lǔ rû̌ pǎ. Yětôphuốrò a myápṳ̌hò́ klyá dố a ki isè̌tǎ̤kyǎní̤ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bí pwè̌ e khò́mǔ sǒdǒ huô̌mûtapho aré̤lố tônyě nuô ǔ me̤thyě thímíphú rò ǔ me̤lǔhtya akhè̌, Jesǔ a khǒpacè̤̌ tahe sudyǎ lǔ, “Tè̤cuốtalwópwè̌ sèesǎsè̌ mò̤́hé yěnuô, nè̤ thè́zṳ̂́ nò̌cuố taritaryǎ tǒ pè̤ bítě tôphotě?” ");
INSERT INTO kyu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Phúnuôrò Jesǔ nò̌ a khǒpacè̤̌ thè́nyě̤ rò a hé èthǐ, “Cuốnuô̌ dố vǐ̤kǔnuô rò thǐ ki myáhtyesû ná kayǎphè̌ hyǎdyá cò̤̌ka̤htyě ná thǒví tôprè̤ pǎ. Rò krwǒka̤kuô̌ lǔkhyě nuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Rò krwǒka̤ kanuô̌ kuô̌ è dố a ka̤ kanuô̌ ní̤dyé hi nuôtômě akǔ rò sudyǎ hibyacènuô, ‘Thárá hé, sǐpré̤ hidò́kǔ akhǎlé̤ dố vǎ ná vǎ khǒpacè̤̌ tahe ki eǒ tè̤cuốtalwópwè̌ lé̤e agněnuô a otǒ bítě?’ Sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Htuô̌pǎrò a ki zṳ̌luô̌ thǐ hidò́kǔ khǎlé̤lyá̤ dố akhu nuôtôtó̤ dố a olốobǎ cò́ ná tǎ̤muô̌tǎ̤tè̤ dố pè̤ lo nuôtahe cò́ pǎ. Rò okyǎ lahyǎ bínuô rò taritaryǎ pé̤ lahyǎ pè̤ sèesèǒ bínuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","A khǒpacè̤̌ yěthè́nyě̤ htecuố rò a cuốnuô̌ dố vǐ̤kǔ rò èthǐ cuốmyáhtye má̤lakǒ cò́ phú Jesǔ héone èthǐ nuô cò́. Rò èthǐ cuố taritaryǎní̤ lahyǎ tè̤cuốtalwópwè̌ sèesǎsè̌ mò̤́hé agně bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bí mò̤́khípaló̤hò́ akhè̌nuô, Byacè ná a khǒpacè̤̌ shyéthè́nyě̤ hyǎtuố̤kuô̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bí èthǐ onyǎ esè akhè̌nuô, Jesǔ hé, “Vǎ hécò́cò́ thǐ, dố thǐklè̌ yěnuô, kayǎ dố a etố̤ǒtố̤ tè̤ ná vǎ rò a ki isè̌tǎ̤kyǎ vǎ pǎnuô a o tôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Cáhtya bínuô rò èthǐ thè́plòmo̤ pǎto, rò èthǐ sudyǎhyǎ Jesǔ tôprè̤ htuô̌ tôprè̤, “Nè̤ hénuô tôprè̤ma vǎ má̤to vǎhé?” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesǔ hésû èthǐ, “Kayǎ yětôprè̤ nuôma dố thǐ shyéthè́nyě̤ yěaklè̌nuô prè́. È ma kayǎ dố a bò́nuô̌e tố̤kuô̌ ná vǎ dố bělò̤́kǔ nuôtôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Phú lisǎsè̌kǔ héone ná prè̤lu aphúkhǔ má̤dû vǎyě a bè thyě nyǎpǎ tadû́rò kayǎ dố a ki isè̌tǎ̤kyǎ prè̤lu aphúkhǔ yětôprè̤nuô, Cò́marya ki cirya lǔ pǎ. A ki opacè̤̌lya̤ to hénuôma aryáklò̌ pǎ cò́ dố lǔgně cò́.” ");
INSERT INTO kyu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bí èthǐ esè akhè̌nuô, Jesǔ phyé khò́mǔ rò hébwíhétaryěhtya Cò́marya htuô̌rò a ibikyě khò́mǔ rò a zṳ́tǎ̤ pé̤ a khǒpacè̤̌ tahe rò a hé, “Phyé rò e lahyǎ, yěma vǎ né̤klò̤́.” ");
INSERT INTO kyu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Htuô̌rò a phyé thòbǐthèhtyěbě rò a hébwíhétaryě Cò́marya htuô̌rò a zṳ́tǎ̤ pé̤ èthǐ rò èthǐ ǒ lahyǎ thòbǐthèhtyě dố běkǔ yěnuô pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Rò Jesǔ hé èthǐ, “Yěma vǎthwi dố a ki htwílya̤ pé̤ dố kayǎ è́prè̤ agně pǎ. Yěma tè̤mátè̤dyǎ tôcô dố a ki me̤klò̤me̤ma pé̤ tè̤ò́lya̤thè̌ agně hò́. ");
INSERT INTO kyu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Vǎ hécò́ pé̤ cò́꤮ thǐ, cáhtya khǒnyá̤yě tǎ̤plehyǎnuô vǎ ǒnò́ pǎ thòbǐthèhtyě yě tohò́. Vǎ ki ka̤ǒ ró̤kuô̌ khyěthyá thòbǐthèhtyě athè̌ ná thǐ dố Cò́marya ahtyěaké̤kǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Htuô̌rò èthǐ irǒ htuthè́htya Cò́marya ali-irǒ tôtó̤ rò a htecuốhtyakyǎ dố Oliva sokhu. ");
INSERT INTO kyu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesǔ hé èthǐ, “Cò́marya hékyǎ mú꤮ nukhè̌, ‘Vǎ ki mṳ̂̌thyě prè̤kyě̤thímí pǎ, rò thímí tahe ki klyapruốklyapryǎ lò̌ pǎ,’ lisǎsè̌kǔ hé phúnuô. “Lò̌꤮ thǐ yětahe nuôma athyáná thímí yětahe nuôhò́. Thǐ ki hteklya cuốkhókyǎlò̌ vǎ khǎlé̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Manárò shyé꤮ vǎ thyě ihtòka̤khyě htuô̌pǎnuô, vǎ ki cuố ré̤ thǐ dố Galilea ké̤kǔ nuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petru hésû lǔ, “Ǔruô ki hteklya cuốkhókyǎlò̌ cò́ ná nè̤ tadû́rò vǎ klyá hteklya cuốkhó nyǎ ná nè̤ to.” ");
INSERT INTO kyu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Rò Jesǔ hésû lǔ, “Vǎ hé má̤lakǒ cò́ nè̤, yětôthè̌ pǎ bí shyěphè̌ i-uhtya tyahí nyě̤phuố to nuô, nè̤ ki htésûbíkyǎ ǔ ná nè̤ thè́gněnò́ vǎ tonuô, thuô̌phuố pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petru hésûkhyě Jesǔ, “Vǎ tǒbè thyě tố̤kuô̌ cò́ ná nè̤ bèbè vǎ thè́gněnò́ lǔ to nuô vǎ hécò́ nyǎ taki꤮ to hò́,” a hésû sò̌kadố cò́ angó̤ ná Jesǔ, rò a khǒpacè̤̌ dố aruô tahenuô, a krwǒhé thyákuô̌lò̌ phúnuô pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Èthǐ cuố dố khǎlé̤ tôpho dố ǔ è́ ná Gethsemani rò a hé a khǒpacè̤̌ tahe, “Bí vǎ cuốkwǐcò́bè̌ akhè̌nuô, onyǎokyǎ lahyǎ bíyě ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Rò a è́krwǒní̤ Petru, Jakomo ná Giovanni dố a ki cuố tố̤kuô̌ ná lǔ. Rò Jesǔ cáhtya bèzò̤bèthi bèkṳ́bèkyǎ̤ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Rò a hé a khǒpacè̤̌ nuô thè́thuô̌, “A cyě̤ nyacò́ vǎ thè́plò hò́ a tuố̤ cò́ dố vǎ kíré̤ thyě cò́hò́nuô, okyǎ lahyǎ bíyě rò othǎklyǎ lahyǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","A cuố plehyǎpó̤ dố nyě takiphú rò a omyě takluô̤̌tǎ̤ dố hekhu rò a kwǐcò́bè̌ rò a hé, “Tè̤cyě̤tè̤cṳ̂ dố vǎ bè khyábè khǒnyá̤ yěnuô, nè̤ ki plwǒ talwó cuốkyǎbè́ pé̤ vǎ ki aní̤ hérò plwǒtalwó cuốkyǎ pé̤ vǎ,” a hé phúnuô. Rò a kwǐcò́bè̌, “Abba, Phè̌꤮, nè̤ me̤cyá̤ tè̤lò̌꤮ plǐ, phyé taphǎkyǎ pé̤ vǎ tè̤cyě̤tè̤cṳ̂ abělò̤́ yětôbè. Manárò vǎ thè́zṳ̂́ me̤ cṳ́꤮ dû vǎ thè́plò to. Cṳ́꤮ dûprè́ nè̤ thè́plò ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A cò́bè̌ htuô̌rò a ka̤khyě khyěthyá rò a ka̤myáhtye ná a khǒpacè̤̌nuô thè́thuô̌ omyění̤ sǒtapa̤ lò̌ rò a sudyǎ Petru, “Simonè ma nè̤ omyění̤ sǒtapa̤ hò́ è̌, nè̤ thǎklyǎ prè́ bí tômû̌ khǎlé̤ prè́nuô ma a bè́ pǎ cò́nyǎ to è̌” ");
INSERT INTO kyu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","a hé lahyǎ èthǐ, “Thyáphú thǐ ki cuốnuô̌ tố̤kuô̌ tǎ dố tè̤ilo-ilyá akǔ tǎmé̤nuô, thǎklyǎ rò kwǐcò́bè̌ lahyǎ ní꤮. Thǐ thè́plòshyome̤ nyacò́ tè̤ dố atǒ tadû́rò thǐ né̤klò̤́ yěnuô a hè̌cè̤́recè̤́ nyacò́.” ");
INSERT INTO kyu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesǔ cuốkhyěthyá tôphuố rò a cuốkwǐcò́bè̌ khyěthyá Cò́marya thyáná a cò́bè̌ ré̤ nuô prè́. ");
INSERT INTO kyu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Htuô̌rò a ka̤ khyěthyá dố a khǒpacè̤̌ nuôthè́thuô̌ a o rò a ka̤myáhtye ná èthǐ omyěsǒtapa̤ lò̌plǐ. Èthǐ thè́omyě cyě̤talwósû́lû̌ rò a myáhtebè́ pǎ cò́ to. A tǒ hébèsû lahyǎ Jesǔ phútěnuô a thè́gně pǎ lahyǎ cò́ to. ");
INSERT INTO kyu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bí a ka̤khyě myá èthǐ bǎhò́ thuô̌phuốtôphuố akhè̌nuô, a hé èthǐ, “Thǐ o꤮ myě tadûpǎ lahyǎ, thǐ okuố tabè́thè́prá tadû pǎ cò́ lahyǎ phútě? Bánuôma pò hò́. Ní̤dǎ myámò̌ lahyǎ, shuốkhè̌ dố ǔ ki isè̌tǎ̤kyǎ prè̤lukayǎ aphúkhǔyě dố prè̤oraphú tahe a takhukǔnuô, a hyǎtuố̤hò́. ");
INSERT INTO kyu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ihtò mò̌! Pè̤ bè cuốhò́! Myámò̌dốnuô, kayǎ dố a isè̌ vǎ nuôtôprè̤ hyǎtuố̤hò́!” ");
INSERT INTO kyu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bí Byacè Jesǔ hébè pǎprè́ akhè̌nuô, Juda dố a otố̤kuô̌ dố lǔ khǒpacè̤̌ shyéthè́nyě̤ aklè̌ yětôprè̤nuô a hyǎtuố̤ bínuô. Rò kayǎ krwǒ hyǎró̤hyǎè́ kuô̌ nyacò́ ná lǔ. Kayǎ yětahenuô a phyéhyǎní̤ lahyǎ nè́tahe, imṳ̂̌tahe. Èthǐ yětahe nuôma má̤prè́ bwídukhu nuôtahe ná prè̤ithyó tè̤thyótè̤thya athárá nuôtahe ná Judaphú khuklò́khuklyǎ nuôtahe nò̌hyǎ lǔ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Prè̤isè̌tǎ̤kyǎ Byacè yětôprè̤nuô a dyéthè́gně one ré̤ htuô̌hò́ èthǐ, “Kayǎ dố vǎ nuô̤mû́ è tôprè̤ nuôma má̤hò́ Jesǔ dố pè̤ thè́zṳ̂́pṳ̂́ è nuôtôprè̤ hò́ rò hyǎpṳ̂́ lahyǎ lǔ rò opò̤́ma ní̤ryádyédû è ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Juda hyǎtuố̤tuố̤ ná a cuốtǒ dố Jesǔ o rò a hé lǔ, “Thárá꤮” htuô̌rò a nuô̤mû́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","A me̤phúnuô htuô̌rò kayǎ tahe hyǎpṳ̂́ cò̌klò̤makyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bínuô akhè̌ kayǎ ihtòo bínuô tôprè̤ báhte anè́ rò a pǎ̤tṳ̂̌kyǎ bwídukhulố a prè̤me̤tè̤phú tôprè̤ akhǎlè tôkhó. ");
INSERT INTO kyu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesǔ hé èthǐ, “Thǐ lě hyǎpṳ̂́ vǎ rò thǐ phyéhyǎní̤ lò̌plǐ cò́ dihtónè́kuố, imṳ̂̌ipò̤ a thyácò́ná thǐ lě hyǎpṳ̂́ prè̤ehuôehí nuô cò́ vǎ? Vǎ ma kayǎcyě̤ kayǎricyá̤ dố a cuốpṳ̂́phezè́plè́ e ǔtè̤ tôprè̤ nyǎ è̌? ");
INSERT INTO kyu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pwǒ̤nyěnyě꤮ vǎ otố̤kuô̌ dố thǐklè̌ rò vǎ ithyóithya thǐ dố tè̤lǔtyǎ hǒkǔ rò thǐ pṳ̂́ vǎ toto. Manárò thǐ cuốhyǎpṳ̂́ tuố̤ vǎ phúyě me̤těhénuôma a bè htwǒhtya phú lisǎsè̌kǔ hénuô prè́nuô̌.” ");
INSERT INTO kyu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bínuôkhè̌ a khǒpacè̤̌ tahe hteklya cuốkhókyǎ lò̌plǐ lǔkhǎlé̤. ");
INSERT INTO kyu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Prè̤khǔ taló tôprè̤ krwǒkuô̌ Jesǔ akhyě rò a kû̌thyá tû́prè́ ikè̤̌bǔ rò kayǎ o bínuô tahe pṳ̂́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Manárò a plwótǎ̤kyǎ a ikè̤̌bǔyě rò a hteklya khǎklo̤kyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Rò èthǐ è́cuố Jesǔ dố bwídukhulố tôprè̤ a o rò bwídukhu tahe, ná Judaphú a khuklò́khuklyǎ tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe hyǎoplò́oplu lò̌plǐ lǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petru krwǒcuố lǒ kuô̌ prè́ Jesǔ dố khyě rò a cuốnuô̌ tuố̤kuô̌ dố bwídukhulố yětôprè̤ ahǒ lo̤tarè́kǔ rò a cuố onyǎ iswí tố̤kuô̌ mi ná kayǎ opò̤́tè̤ bínuô tahe. ");
INSERT INTO kyu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bwídukhu tahe ná lò̌꤮ kayǎ dố a htwǒduhtwǒkhutahe, thyáphú èthǐ ki cirya me̤thyěkyǎ ní̤ Jesǔ agněnuôrò, a myápṳ̌ lahyǎ lé̤kè̤lahǒ lé̤nè̌lahya Jesǔ atè̤thû́ tahe. Manárò èthǐ myáhtye lǔtè̤thû́ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Èthǐ kayǎ è́prè̤ hyǎdya bò̌bye lahyǎ Jesǔ tè̤thû́ tadû́rò kayǎ dố a hyǎ pṳ̌dya lahyǎ Jesǔ atè̤thû́ yětahe a tè̤hébè tahenuô a thyákhyělǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kayǎ tahehe ihtò rò kè̤bò̌kè̤bye lò̌ lǔtè̤thû́ rò a hé lahyǎ, ");
INSERT INTO kyu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Pè̤ ní̤huô̌ a hé, ‘Vǎ me̤ tǎ̤prò̤kyǎ tè̤lǔhǒdu dố prè̤lukayǎ me̤htya yěnuôtômě rò thuô̌nyě akǔnuô vǎ ki isò́htya khóke dố aruô tômě, dố prè̤lukayǎ isò́htya ná atakhu má̤to yěnuô tômě pǎ,’ a hé phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Manárò èthǐ dya lǔtè̤thû́ yětahenuô a thyákhyělǔ tômû̌꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bwídukhulố yětôprè̤ ihtò dố ǔ lò̌꤮ plǐ a mèthènyě rò a sudyǎ Jesǔ, “Nè̤ hé ka̤khyěsû ǔ hyǎdya nè̤ tè̤thû́ yětahe tômû̌꤮ to me̤tě? Ǔ hyǎkè̤hyǎnè̌lò̌ nè̤ tè̤thû́ yěnuôma nè̤ ní̤huô̌ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Manárò Jesǔ odyátaklwo pé̤ lǔ prè́, a hébè ka̤khyěsû lǔ tômû̌꤮ to. Rò bwídukhulố yětôprè̤ sudyǎ pó̤ khyěthyá lǔ, “Nè̤ ma Cò́marya dố ǔ htuthè́htyaní̤ lǔ yětôprè̤ aphúprè̤khǔ Krístu dố a me̤lwóhteka̤ ǔ nuô tôprè̤ è̌?” ");
INSERT INTO kyu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Rò Jesǔ hésû lǔ, “Ò, vǎ hò́. Rò thǐ ki myáhtye prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki onyǎo dố Cò́marya dố ashyo-asò̌ yětôprè̤ atakhu cò́htwó nuôtôkyě pǎ, rò thǐ ki myáhtye vǎ sidyáhyǎní̤ mò́khu a ò́luố̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bwídukhulố nuôtôprè̤ htò́zè̤̌kyǎ aca̤ rò a hé, “Pè̤ lopǎ kayǎ dố a ki zṳ̌luô̌ lǔtè̤thû́ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","A hébè radû̌ ní̤dyé cò́ ané̤ phú Cò́marya tôprè̤ nuôma thǐ ní̤huô̌ lò̌dûhò́ rò ma thǐ tane̤ lahyǎ phútě?” A héhtuô̌ phúnuô rò èthǐ pwǒ̤tôprè̤ hésû lǔ ná atè̤thû́ o rò tǒbè me̤thyěkyǎ lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kayǎ dố aruô tahe cáhtya htuplá lǔ, htuô̌rò cò̌bí lǔmèthè rò plú lǔ. Èthǐ hé lahyǎ Jesǔ, “Pro̤myámyá, ǔpě plú nè̤ pě?” Htuô̌rò klyěphú dố a opò̤́ tè̤ tahe pṳ̂́cuố lǔ rò plyá̤ pó̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bí Petru opǎprè́ dố hikhyěkhu lo̤tarè́kǔ akhè̌nuô, prè̤mòphú dố a me̤ pé̤ bwídukhulố nuôtôprè̤ atè̤me̤ yětôprè̤nuô a okuô̌ bínuô, rò a hyǎtǒ dố lǔo. ");
INSERT INTO kyu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bí a myáhtye Petru iswími akhè̌nuô, a myárè̤̌tǎ̤tǎ̤ lǔ rò a hé lǔ, “Nè̤ ma tômṳmṳ꤮ tuô̌prè́ lǔ ná Nazarèphú Jesǔ nuôtôprè̤ prè́ vǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Rò Petru htébíkyǎ rò a hé, “Nè̤ hé ǐtěnuô vǎ thè́gněplǒ nè̤tè̤ to,” a héhtuô̌rò a htecuố otaphǎkyǎ dố lo̤kadǎhtû̌ rò bínuôakhè̌ shyěphè̌ tôbè i-uhtya. ");
INSERT INTO kyu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Prè̤me̤tè̤phú prè̤mò pǎnu nuôtôprè̤ myáhtye khyěthyá Petru cuốo bínuô rò a cuốhéso pé̤ khyěthyá kayǎ ihtòo tavǐtava̤ phû bínuô tahe, “Kayǎ yětôprè̤ ma tômṳmṳ꤮ tuô̌ lǔ ná dố nuôtahe prè́ meně.” ");
INSERT INTO kyu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Manárò Petru htébísû khyěthyá. Okhyěthyá dốkhyě taplô̤phú rò kayǎ ihtòo tavǐtava̤ phû bínuô tahe hé khyěthyá Petru, “Nè̤ otố̤kuô̌ dố kayǎ nuôtômṳ aklè̌ má̤lakǒ cò́, me̤těhérò nè̤ ma Galileaphú prè́.” ");
INSERT INTO kyu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Manárò Petru byǎlya̤ní̤ ané̤ dố Cò́marya nyěhyǎ, “Kayǎ dố thǐ hé ari-akyǎ khǒnyá̤yě tôprè̤nuô vǎ thè́gně lǔ to,” a byǎní̤ angó̤ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A byǎ htuô̌htuô̌ ná shyěphè̌ i-uhtya pó̤khyěthyá nyě̤phuốtôphuố. Bínuôkhè̌ Petru tane̤htya tuố̤bè Byacè Jesǔ héonekyǎ lǔ ngó̤, “Bí shyěphè̌ i-uhtya tyahí nyě̤phuốtôphuố tonuô, nè̤ ki htébíkyǎ vǎ thuô̌phuố pǎ” a hé lǔ ngó̤ phúnuô akhu-akhyě cí꤮ asè̌htya cò́ lǔthè́plò rò a nguố̤thyěnguố̤o cò́. ");
INSERT INTO kyu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bí mò̤́lǐ tamò̤́htyahò́ akhè̌nuô, bwídukhu tahe, Judaphú khuklò́khuklyǎ tahe, prè̤ithyó tè̤thyótè̤thya athárá tahe, ná kayǎ htwǒ khuklò́khuklyǎ tahe okúokyá lǔ rò èthǐ sukǔ héplû́kyǎ lò̌ lǔ ngó̤ ná Jesǔ ari-akyǎ. Èthǐ cò̌klòhtuô̌ Jesǔ rò a cwicuốdyékyǎ lǔ dố Khwí Pilato a takhukǔ. ");
INSERT INTO kyu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Khwí Pilato sudyǎ Jesǔ, “Nè̤ ma Judaphú akhwí tôprè̤ má̤lakǒ è̌?” Rò a hésû khwí, “Ò, a má̤lakǒ phú nè̤ hénuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Rò bwídukhu tahe hyǎdya è́lǎ tè̤thû́ dố Jesǔ alo̤. ");
INSERT INTO kyu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Phúnuôrò Khwí Pilato sudyǎ pó̤ Jesǔ, “Nè̤ hésû kuô̌ǔ tôcô꤮ to me̤tě? Nè̤ myámò̌, èthǐ hyǎ dyaluô̌htya è́nyacò́ nè̤ tè̤thû́.” ");
INSERT INTO kyu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Manárò Jesǔ héka̤khyěsû lǔ tôcô꤮ to akhu-akhyě Khwí Pilato khyéthukhyéthè́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Khwí Pilato alé̤klǒ o ná pwǒ̤nana꤮ tè̤cuốtalwópwè̌ dǎ bè hò́hénuô, ǔ ki kwǐ lǔ ná a ki plwǒhte pé̤ kayǎcyě̤ dố ǔ dò́tǎ̤ èthǐ dố htò̌kǔ bítě꤮ tôprè̤ bèbènuô, a plwǒhte pé̤ ǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bínuôakhè̌ kayǎ dố a sásû me̤tarû̌tapyǎ lahyǎ khwí rò a me̤thyě kayǎ tahenuô, ǔ dò́tǎ̤o lahyǎ èthǐ dố htò̌kǔ. Kayǎ tǎ̤ dố htò̌kǔ yětahe aklè̌nuô kayǎ mwi̤ ná Barabba héyětôprè̤nuô a opatố̤kuô̌ bí èthǐklè̌ nuô. ");
INSERT INTO kyu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Rò kayǎ è́prè̤ hyǎ lahyǎ dố Khwí Pilato a o rò hyǎkwǐ lǔ phú alé̤klǒ me̤pé̤ htuô̌hò́ èthǐ nuô. ");
INSERT INTO kyu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Rò Khwí Pilato sudyǎsû èthǐ, “Vǎ plwǒhte pé̤ thǐ Judaphú akhwídu yětôprè̤ ma thǐ thè́plò o è̌?” ");
INSERT INTO kyu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Me̤těhérò Khwí Pilato thè́gně ná bwídukhu tahenuô, a thè́khwè́ní̤kuô̌ Jesǔ rò èthǐ hyǎdyétǎ̤kyǎ Jesǔ dố lǔo prè́. ");
INSERT INTO kyu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Manárò bwídukhu tahenuô a cuốnò̌shyo kayǎ bè́mṳ ki kwǐhtya khwí ná a ki plwǒhte pé̤ èthǐ dố Barabba, plwǒhte pé̤ tǎ pè̤ Jesǔ tǎmé̤, a cuốhé lò̌ǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Khwí Pilato sudyǎpó̤ kayǎ bè́mṳ yětahe, “Ki me̤phúnuôrò kayǎ dố thǐ è́ è ná Judaphú tahe akhwí yětôprè̤ nuôlě vǎ tǒbè me̤ ní̤dyé lǔ phútě?” ");
INSERT INTO kyu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Rò èthǐ è́htǒhtya pó̤ lahyǎ, “Mṳ̂̌thyěhtyakyǎ è dố krusulo̤ nuô!” ");
INSERT INTO kyu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Rò Khwí Pilato sudyǎ èthǐ, “Cuố mṳ̂̌thyěhtyakyǎ è me̤tě? A cuố me̤thû́me̤plá kryá꤮ ǐtě?” A sudyǎ èthǐ phúnuô tadû́rò èthǐ lé꤮ è́htǒhtyashyo klò̌lố pó̤, “Mṳ̂̌thyěhtyakyǎ è dố krusulo̤ nuô!” ");
INSERT INTO kyu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Rò Khwí Pilato thè́zṳ̂́ krwǒme̤kuô̌ phú kayǎ bè́mṳ a tè̤thè́zṳ̂́ nuô rò a plwǒhtekyǎ pé̤ èthǐ Barabba, rò Khwí Pilato nò̌ klyěphú tahe ki cyé̤pryě̤plí lahyǎ Jesǔ ná suplye̤-iplí, htuô̌rò a dyétǎ̤kyǎ Jesǔ dố klyěphú tahe a khadǎkǔ dố èthǐ ki cuố mṳ̂̌thyěhtyakyǎ lǔ dố krusulo̤. ");
INSERT INTO kyu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Klyěphú tahe è́cuố Jesǔ dố Khwí Pilato hǒkǔ khǎlé̤ tôpho. (Khǎlé̤ nuôtôpho ma ǔ è́ ná Pretorium) htuô̌rò èthǐ è́hyǎplò́ lò̌ pó̤ klyěphú dố aruô tahe. ");
INSERT INTO kyu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Èthǐ me̤zò́me̤lě nyě̤kruô̌ lahyǎ Jesǔ rò thyáhtya pé̤ lǔ ca̤cwo̤ taphèlò́thò̌ tôpṳ̂. Htuô̌rò èthǐ ikhu tava̤ thòshyámò̤́ thyáná khuklwǒ̤ nuôrò a klwǒ̤htya pé̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Htuô̌rò èthǐ me̤ lǔ phú a bezṳ̂́benyá̤ní̤ lǔ nuô rò a hétakè lǔ, “Kố꤮ Juda akhwídu, ohtwǒprè̤ mò̤́nyě htǔdû ní꤮!” ");
INSERT INTO kyu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Èthǐ mṳ̂̌ lǔkhuklò́ ná ihtyábǒ, htuplá lǔ, hyǎ dángṳ̂lya̤ dố lǔnyěhyǎ tôprè̤ htuô̌ tôprè̤, rò a me̤takè lǔ phú a bezṳ̂́benyá̤ lǔ nuô rò a hyǎcò́bè̌ kanǐkano lǔ tôprè̤ htuô̌ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bí èthǐ me̤zò́me̤lě nyě̤kruô̌htuô̌hò́ lǔ nuô èthǐ plwótǎ̤kyǎ khyěthyá ca̤cwo̤ taphèlò́thò̌ nuôtôpṳ̂ rò a thyáhtya taple pé̤ khyěthyá lǔ ná aca̤ ní̤dû nuôtôpṳ̂. Htuô̌rò èthǐ è́htecuốkyǎ lǔ rò a ki cuố mṳ̂̌thyěhtyakyǎ lǔ dố krusulo̤. ");
INSERT INTO kyu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Vǐ̤ Cyreneophú dố amwi̤ ná Simonè nuô a o tôprè̤, rò Simonè yěnuô, a phúo thè́nyě̤, tôprè̤ rò amwi̤ ná Alexandro, tôprè̤pǎ rò amwi̤ ná Rufo. Bínuôakhè̌ a o dố adò̌aso rò a kíré̤ hyǎnuô̌ dố vǐ̤kǔ akhè̌, a hyǎ tǎ̤sû ná klyěphú tahe rò èthǐ nò̌zá tadû lǔ ná Jesǔ krusu. ");
INSERT INTO kyu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Èthǐ è́cuố Jesǔ dố ǔ è́ ná Golgotha hé yěnuôtôpho. (Golgotha angó̤lasá ma khuklò́krwí akhǎlé̤). ");
INSERT INTO kyu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bínuô akhè̌nuô, èthǐ dyéǒ Jesǔ htyězǎ̤ dố a kluô̌sǐlyǎ̤ tố̤ná tè̤khu me̤sǐmé̤ tè̤sè̌né̤sè̌bya yěnuô tadû́rò Jesǔ ǒ to. ");
INSERT INTO kyu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Rò èthǐ mṳ̂̌thyěhtyahtuô̌ Jesǔ dố krusulo̤ rò èthǐ phyé Jesǔ aca̤ tahe rò a bò́ lahyǎ tè̤byǎbwí tôcô dố cṳ́꤮ dû a tǎ̤tǒ bítě tôprè̤ tǒphyé bítě tôkyě phúnuôprè́. ");
INSERT INTO kyu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bí mò̤́plyǎ̤sè̌htya lwǐ̤thyótômû̌ akhè̌nuô, èthǐ mṳ̂̌thyěhtya Jesǔ dố krusulo̤. ");
INSERT INTO kyu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rò ǔ rǎhtya o lidyatè̤thû́ Jesǔ, “Judaphú tahe akhwí” phúnuô, ");
INSERT INTO kyu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","rò èthǐ mṳ̂̌thyěhtya tố̤kuô̌ ná prè̤pṳ̂́phe zè́plè́phe ǔ thè́nyě̤. Èthǐ mṳ̂̌thyěhtya lǔ dố Jesǔ cò́htwó tôkyě tôprè̤ dố cò́ci tôkyě tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Phú lisǎsè̌kǔ hé, “Ǔ dyathyá è phú prè̤oraphú nuôprè́,” tè̤hébè yěnuô a lốhtyabǎhtya hò́.) ");
INSERT INTO kyu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kayǎ dố a cuốka̤phû lahyǎ bí akhǎshyé nuôtahe nuô lahyǎ akhuklò́, pacyé̤ishyé rò a hé lahyǎ lǔ, “Ò꤮ nè̤ hé ná nè̤ ki me̤tǎ̤prò̤kyǎ tè̤lǔhǒdu rò thuô̌nyě akǔ nè̤ isò́htya htuô̌bè́ khyěprè́ nè̤ hé vǎhé. ");
INSERT INTO kyu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Phúnuôrò o dố krusulo̤ yěnuôrò hítǎ̤ mò̌ to rò me̤lwóhteka̤ ní̤dyémò̌ nè̤né̤ to.” ");
INSERT INTO kyu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Htuô̌rò, bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe pacyé̤ thyákuô̌ Jesǔ phúnuô rò èthǐ hé lahyǎ, “A me̤lwóhteka̤ cyá̤ ǔ thè́htwǒprè̤ tadû́rò a me̤lwóhteka̤ cyá̤ ní̤dyékuô̌ ané̤to vǎ꤮. ");
INSERT INTO kyu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nè̤ hé ní̤dyé nè̤né̤ ná nè̤ ma Juda akhwí dố a me̤lwóhteka̤ ǔ nuôtôprè̤ vǎhé. Pè̤ ki myáhtye nè̤ hítǎ̤ cyá̤ dố krusulo̤ khǒnyá̤ kihérò pè̤ zṳ̂́e nè̤,” a héhtuô̌ phúnuôrò, kayǎ dố ǔ mṳ̂̌thyěhtya tố̤kuô̌ ná Jesǔ yěthè́nyě̤nuô a pacyé̤ishyé kuô̌dû Jesǔ phúnuônuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cáhtya bí mò̤́htuô cò́ranè́ nuô rò a tuố̤hyǎ dố mò̤́kwí̤lya̤ thuô̌mû̌ akǔnuô ké̤ khítarṳ̂ tǎ̤lò̌ cò́ tôké̤lè̤̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bí mò̤́kwí̤lya̤ thuô̌mû̌ bèhò́ akhè̌nuô, Jesǔ cyé̤pryě̤ è́htǒhtya, “Éli, Éli, lema sabathani,” angó̤lasá ma “Vǎ Cò́marya, vǎ Cò́marya, nè̤ vǐkyǎ vǎ me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kayǎ ihtòo bínuô tahe ní̤huô̌ lahyǎ Jesǔ è́htǒhtya phúyě rò èthǐ hé lahyǎ, “Ní̤dǎ lahyǎ, a è́htǒhtyahò́ Prè̤pro̤ Elia.” ");
INSERT INTO kyu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Rò dố èthǐklè̌nuô kayǎ o tôprè̤ rò a klyacuốphyé tè̤tôcô dố athyáná phyáplyé rò a cuốcye̤nuô̌ dố htyězǎ̤shye thǒkǔ rò a cò̌klò̤ma dố vèlǎ̤khyě rò a dyéhtya nò̌cwíǒ ná Byacè Jesǔ rò a hé lahyǎ, “Pè̤ opò̤́myámyá kuốré̤ taplô̤phú pó̤, ma pè̤ myáhtye sálé̤ Prè̤pro̤ Elia ki hyǎphyétǎ̤kyǎ è dố krusulo̤ nuôpǎ è̌.” ");
INSERT INTO kyu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Rò Jesǔ è́htǒ pra̤shyo htuô̌rò athè́plò htwǒprè̤ htecuốkyǎ. ");
INSERT INTO kyu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Rò ikè̤̌badu dố ǔ cò̤́tǎ̤tṳ̂̌bí dố tè̤lǔtyǎ hǒkǔ nuôtôba lazè̤̌ kahtyakalya̤ plû́kyǎ nyě̤kyě. ");
INSERT INTO kyu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bí Roma klyětôzè̤ khuklò́ yětôprè̤ ihtòo bí krusu nyěhyǎ akhè̌nuô, a myáhtye Jesǔ thyě me̤phúnuô rò a hé, “Kayǎ yětôprè̤ ma Cò́marya aphúkhǔ má̤lakǒ nyǎhò́!” A hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Prè̤mò dố a ihtòo myácuốlǒ dố aye̤ yětahe aklè̌nuô Magdalena dò̌kǔmuố̤ Maria, ná Jakomo dố a pacè̤̌klò̌ nuôtôprè̤ ná Jose amuố̤ Maria, ná Salome otố̤kuô̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Prè̤mò yětahe ma bí Jesǔ o dố Galilea ké̤ akhè̌nuô, a krwǒ Jesǔ akhyě rò a me̤cwó̤me̤kǒ pé̤ tè̤ dố Jesǔ lo tahe. Prè̤mò aruô tahe dố a o lahyǎ dố vǐ̤ Jerusalem rò a krwǒhyǎ tố̤kuô̌ ná Byacè tahenuô a opa è́kú kuô̌lǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tè̤me̤htwǒhtya nuôtônyě ma mò̤́nyǎ̤nyě. Mò̤́nyě nuôtônyě ma Judaphú tahe taritaryǎ sèesèǒ bí èthǐ amò̤́nyěduô bè tyahíto nuôtônyě. ");
INSERT INTO kyu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Bí mò̤́hélya̤hò́ akhè̌nuô, vǐ̤ Arimatheaphú Joseph yětôprè̤ a bekhû̌ athè́plò rò a cuốkwǐ Jesǔ aluô̤̌to̤ yě dố Khwí Pilato a o. È ma a opatố̤kuô̌ dố kayǎ htwǒdu aplò́amṳ dố ǔ bezṳ̂́benyá̤ ní̤ yěnuôtômṳ aklè̌ tôprè̤. È ma kayǎ dố a opò̤́myásû̌ kuô̌ Cò́marya ahtyěaké̤ tôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jesǔ thyěhò́, Khwí Pilato ní̤huô̌ phúnuô rò a khyéthukhyéthè́ rò a è́hyǎ klyětôzè̤ akhuklò́ tôprè̤ dố a o rò “Ma Jesǔ thyě nyě̤lǎhò́ è̌?” A sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Klyětôzè̤ akhuklò́ yětôprè̤ hésoluô̌ Khwí Pilato ná Jesǔ thyěhtuô̌hò́ rò Khwí Pilato plwǒ Joseph dố a ki cuốphyétǎ̤ Jesǔ aluô̤̌to̤. ");
INSERT INTO kyu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph cuố ipri̤ní̤ ikè̤̌ báplǐngṳdu tôpṳ̂ rò a cuốphyétǎ̤ Jesǔ dố krusulo̤. A bobí lǔ ná ikè̤̌báplǐ ngṳdu yětôba rò a cuố benuô̌ lǔ dố ǔ ikhû one htuô̌hò́ luô̤̌kǔ tôkǔ akǔ. Luô̤̌kǔ yěnuôma lò̤́kǔ dố a o dố lá̤lo̤ rò a htulò̌ bíkyǎ luô̤̌kǔ yěnuô ná lò̤́du tômě. ");
INSERT INTO kyu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdalena dò̌kǔmuố̤ Maria ná Jose amuố̤ Maria myátǒ̤ma ní̤kyǎ ǔ lé̤dyanuô̌ Jesǔ akhǎlé̤ yětôpho. ");
INSERT INTO kyu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bí Judaphú a Mò̤́nyěduô talwókyǎ htuô̌ nuôtôrǒnuô, Magdalena dò̌kǔphú Maria, Jakomo amuố̤ Maria ná Salome ipri̤ní̤ htyěnuô̤mû́ rò a kíré̤ cuốplò̤́ lahyǎ ná Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mò̤́nyě thuô̌thyótônyě aklè̌ kalúlố nuôtônyě bí mò̤́lǐro̤mû́ mò̤́khíò́pǎ akhè̌nuô, èthǐ hyǎ lahyǎ dố luô̤̌khu. ");
INSERT INTO kyu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bí èthǐ hyǎ dố klyálo̤ akhè̌nuô, èthǐ hé ní̤dyé khyělǔ, “Maǔpě kíré̤ htulò̌ taphǎkyǎ pé̤ pè̤ lò̤́ dố ǔ htulò̌bí ná luô̤̌kǔ nuôtômě pě?” Me̤těhérò lò̤́nuô tômě ma adu nyacò́. ");
INSERT INTO kyu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Manárò bí èthǐ myácuố akhè̌nuô, a myáhtye ná ǔ htulò̌cuốtaphǎ onekyǎ htuô̌hò́ lò̤́du nuôtômě hò́. ");
INSERT INTO kyu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bí èthǐ nuô̌ dố luô̤̌kǔ akhè̌nuô, a myáhtye prè̤khǔphúthè thyání̤ ca̤cwo̤bǔ tôpṳ̂ tôprè̤ onyǎo dố luô̤̌kǔ dố cò́htwó nuôtôkyě rò èthǐ khyé lò̌plǐcò́. ");
INSERT INTO kyu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Rò a hé èthǐ, “Khyéthukhyéthè́ lahyǎ tǎmé̤꤮, thǐ myápṳ̌ Nazarèphú Jesǔ dố ǔ mṳ̂̌thyěhtya lǔ dố krusulo̤ nuôtôprè̤ prè́ nuôma vǎ thè́gně. A ihtòhtwǒprè̤ ka̤khyě htuô̌hò́. A opǎ bíyě to. Hyǎmyámò̌ lahyǎ, yěma akhǎlé̤ dố ǔ dyanuô̌ lǔ nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ka̤dyáso pé̤ Petru ná Jesǔ a khǒpacè̤̌ dố aruô nuôtahe ná Jesǔ cuố one ré̤ hò́ thǐ dố Galilea ké̤kǔ nuô hò́. Phú a héone htuô̌hò́ thǐnuô thǐ ki myáhtye dû è bínuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Èthǐ khyé rò ané̤ tanyǎ̤tacố lò̌plǐ cò́ akhu-akhyě, èthǐ klyahtekyǎ dố luô̤̌kǔ. Èthǐ thè́isě talwósû́lû̌ rò bí a htecuố akhè̌nuô, a hébè pǎ cò́ ǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesǔ thyěihtò htwǒprè̤ ka̤khyě bí mò̤́nyě thuô̌thyótônyě akǔ akalúlố nuôtônyě mò̤́lǐro̤mû́ nuôtôrǒ. Htuô̌rò dốkhyěnuô a cuốdyéluô̌ ré̤lố pé̤ ané̤ ná Magdalena dò̌kǔmuố̤ Maria. Rò Maria yětôprè̤ nuôma a má̤ hò́ prè̤mò dố Jesǔ vè̤́htekyǎ pé̤ lǔ khǐnékhǐnò̌ thuô̌thyótôduô̌ dố alo̤ nuôtôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Phúnuôrò, Maria cuốhésoluô̌ pé̤ kayǎ dố a cuốtố̤khè̌tố̤nò́ ná Jesǔ nuôtahe ná Jesǔ oluô̌htya pé̤ lǔ ari-akyǎ. Bínuôakhè̌ èthǐ thè́plè̤̌nebè rò anguố̤ahè pǎprè́ lahyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Èthǐ ní̤huô̌ Maria héso pé̤ èthǐ, “Jesǔ htwǒprè̤ prè́, vǎ myáhtye cò́ è ná vǎné̤ cò́,” a hé pé̤ èthǐ phúnuô tadû́rò èthǐ zṳ̂́eto. ");
INSERT INTO kyu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dốkhyěnuô a khǒpacè̤̌ thè́nyě̤ htecuố dốdò̌dốso akhè̌ èthǐ myáhtye Jesǔ klwokhó pé̤ lǔ ané̤ rò a dyéluô̌ pé̤ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A khǒpacè̤̌ yěthè́nyě̤ ka̤khyě héso pé̤ a khǒpacè̤̌ dố aruôtahe tadû́rò èthǐ zṳ̂́e lahyǎ kayǎ yěthè́nyě̤ angó̤ to. ");
INSERT INTO kyu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dố khyěpó̤ tôphuố rò bí a khǒpacè̤̌ shyétôprè̤ esè akhè̌nuô, a dyéluô̌ pé̤ khyěthyá èthǐ ná ané̤. Kayǎ dố a myáhtye Jesǔ thyěihtò htwǒprè̤ ka̤khyě yětahe héso pé̤ èthǐ tadû́rò èthǐ zṳ̂́e lahyǎ ǔngó̤ to akhu-akhyě, Jesǔ thè́prwǒ̤ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Rò a hé èthǐ, “Cuố dố hekhu pwǒ̤tôba rò cuốlě dônyǎhéso pé̤kuô̌ lò̌ ǔ pwǒ̤꤮ tôprè̤ ná tè̤thè́krṳ̂̌mila yěnuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kayǎ dố a zṳ̂́e tè̤thè́krṳ̂̌mila yě rò a plwǒka̤ ané̤ ná htyě tôprè̤prè̤ nuô a ki ní̤bè tè̤me̤lwóhteka̤ pǎ. Manárò kayǎ dố a zṳ̂́e to tahenuô a ki khyábè tè̤cirya pǎ꤮. ");
INSERT INTO kyu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kayǎ dố a zṳ̂́e tahenuô vǎ ki dyé èthǐ taryěpro̤prya̤ dố a ki me̤cyá̤ lahyǎ tè̤pro̤tè̤prya̤ tahe pǎ. Èthǐ ki vè̤́htebè́ lahyǎ khǐnékhǐnò̌ tahe ná vǎmwi̤ pǎ, èthǐ ki hébè cyá̤ ngó̤aruô nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Èthǐ ki pṳ̂́ cò́ rṳ́mǔmyá̤ tahe bèbè, a ki cuốebèǒbè cò́ tè̤cûtè̤plè̤́ htyě tahe bèbè, a me̤pyá̤me̤sè̌ ná èthǐ tôcô꤮ to. Èthǐ ki dyahtya atakhu dố kayǎswíkayǎsè̌ tahe alo̤ hénuô, èthǐ tè̤swítè̤sè̌ ki sǐmé̤kyǎ lò̌ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Byacè Jesǔ hébèhtuô̌ ná a khǒpacè̤̌ tahe rò Cò́marya è́ka̤ kahtyakyǎ lǔ dố mò́khu rò a htya-onyǎo dố Cò́marya atakhu cò́htwó tôkyě. ");
INSERT INTO kyu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesǔ a khǒpacè̤̌ tahe cuốlě dônyǎhéso pé̤ ǔ ná Cò́marya alǎ̤angó̤ dố khǎlé̤ pwǒ̤꤮ tôpho. Thyáphú kayǎ ki zṳ̂́enyá̤e kuô̌ lahyǎ ná tè̤thè́krṳ̂̌mila dố èthǐ dônyǎ pé̤ ǔ yěnuôma a má̤lakǒ cò́ agněnuô, Byacè dyé pé̤ èthǐ dố a ki me̤cyá̤ lahyǎ tè̤me̤ tè̤pro̤tè̤prya̤ tahe è́nyacò́.");
INSERT INTO kyu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kayǎ è́prè̤ yácû́ rǎmárǎdyǎ lahyǎ tè̤ dố a htwǒhtya bí pè̤klè̌ yětahe ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Èthǐ krwǒrǎkuô̌ prè́ phú kayǎ dố a myáhtye ná ané̤ dố kalúkhè̌ rò a hésodônyǎ luô̌ pé̤ ǔ ná tè̤ritè̤kyǎ nuôtahe héso dǐtû́ pé̤ pè̤ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Phúnuô akhu-akhyě, Thárádu Theophilo꤮, vǎ myápṳ̌ thè́gně tǎ̤te̤ htuô̌lò̌ hò́ tè̤htwǒhtya dố a khǎshyékhǎrya̤ tahehò́ akhu-akhyě, vǎ dyalya̤ hò́ vǎ thè́plò ná vǎ ki rǎ pé̤ nè̤ phú a htwǒhtya tôtó̤ htuô̌ tôtó̤ hénuôma a klyá ryá nyǎ prè́ vǎ tane̤ phúyě. ");
INSERT INTO kyu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Thyáphú nè̤ ki thè́gně tǎ̤te̤ lò̌lá̤takli lò̌ tè̤ritè̤kyǎ má̤lakǒ phú nè̤ ithyónò́ htuô̌hò́ nuôtahe agněnuôrò, vǎ rǎ phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bí Khwí Herodè htwǒ khwí dố Juda ké̤kǔ akhè̌nuô, bwídu dố amwi̤ ná Zekaria otôprè̤. Rò ènuô a opatố̤kuô̌ dố prè̤lǔtyǎ aplò́amṳ dố ǔ è́ lǔmwi̤ ná Abijah mú꤮ nukhè̌ nuôtômṳ akǔ, rò amě mwi̤ ná Elizabeth. È ma aklwǐalyǎ ícû̌tố̤ ná bwídu tahe. ");
INSERT INTO kyu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Èthǐ thè́nyě̤ lò̌ a ohtwǒprè̤ cò́te̤ryá lò̌ cò́ dố Cò́marya a mèthènyě cò́ rò phú Byacè Cò́marya a tè̤thyótè̤thya ná a tè̤mekyǎngó̤ tahe héonuô èthǐ cṳ̌e me̤lốme̤bǎ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elizabeth sǒphú akhu-akhyě èthǐ phúo kuô̌ lahyǎ ǔ to, htuô̌to èthǐ thè́nyě̤lò̌ a muố̤prè̤́ lǎhò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tônyěnuô, shuốkhè̌ tuố̤hò́ dố Zekaria tǒ phyéní̤ tè̤me̤ dố a lya̤bè lǔ yě. A me̤ tè̤me̤ phú bwídu tôprè̤ dố tè̤lǔhǒdu akǔ. ");
INSERT INTO kyu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Phú bwídu tahe lé̤klǒ onuô, ǔ nwóhtya hò́ è ná a tǒbè sû́û̌htya tè̤nuô̤mû́ dố tè̤lǔtyǎ hǒkǔ bínuô tônyě akhu-akhyě, a cuốnuô̌ dố tè̤lǔtyǎ hǒkǔ. ");
INSERT INTO kyu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bí a sû́û̌htya tè̤nuô̤mû́ akhè̌nuô, dố aklò̌nuô, ǔ kwǐcò́bè̌ró̤cò́bè̌è́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Cò́marya tanémò́khuphú tôprè̤ oluô̌htya pé̤ dố Zekaria anyěhyǎ rò a kahtò o bí lé̤sû́û̌htya tè̤nuô̤mû́ akhǎlé̤ dố cò́htwó nuôtôkyě. ");
INSERT INTO kyu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Bí Zekaria myáhtye tanémò́khuphú akhè̌nuô, a khyé rò a thè́isě. ");
INSERT INTO kyu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Manárò tanémò́khuphú hé lǔ, “Zekaria꤮ thè́isě tǎmé̤! Cò́marya ní̤huô̌ hò́ nè̤ tè̤kwǐcò́bè̌ akhu-akhyě nè̤mě Elizabeth ki phúo pé̤ nè̤ phúprè̤khǔ tôprè̤ pǎ rò nè̤ tǒbè è́ amwǐ̤ ná Giovanni pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Shyé꤮ a o pacè̤̌lya̤ pǎ ma a ki me̤ thè́krṳ̂̌thè́lò̌ nè̤ pǎ rò kayǎ ki thè́krṳ̂̌plu thè́krṳ̂̌phè kuô̌lò̌ ná nè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","È ma a ki htwǒ du dố Cò́marya a mèthènyě pǎ tôprè̤. Thòbǐthèhtyězǎ̤ bèbè, htyěsípré̤ bèbè a tǒbè eǒní̤ tôcô꤮ to. A ki lốbǎ ná Thè́ Sǎsè̌ Byacè dố a muố̤hò́kǔ akhè̌ cò́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Rò a ki thǔ ka̤khyě è́nyacò́ Israelphú tahe dố èthǐ Byacè Cò́marya a o pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A ki hyǎ ré̤ ná Byacè pǎ, rò athè́plò ki hè̌shyoresò̌ rò a ki o ná taryěshyosò̌ phú Prè̤pro̤ Elia nuô pǎ. A ki me̤rè̤̌ ka̤khyě khyěthyá phè̌tahe ná phútahe pǎ. A ki buô̌tarí ka̤khyětǒ khyěthyá kayǎ ní̤dǎ kuô̌ǔ ngó̤ to nuôtahe dố prè̤cò́prè̤te̤ tahe a klyádè̌kǔ pǎ. Thyáphú kayǎ tahe ki otaritaryǎsû Byacè atè̤hyǎ pǎ yěnuôrò, a ki taritaryǎ one pé̤ kayǎ tômṳ dố Byacè agně pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekaria sudyǎ tanémò́khuphú, “Yěnuôma amá̤ è̌, amá̤to è̌ nuô, vǎ ki thè́gně myálwó cyá̤ phútě? Vǎ rò vǎ muố̤prè̤́ lǎ hò́hò́, vǎmě rò a muố̤prè̤́ lǎhò́hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Rò tanémò́khuphú hésû lǔ, “Vǎ ma Gabrielè, vǎ kahtò dố Cò́marya a mèthènyě rò a nò̌hyǎlya̤ vǎ dố vǎ ki hyǎ héso pé̤ nè̤ ná tè̤thè́krṳ̂̌mila yětôcô nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Vǎ hyǎ héso pé̤ nè̤ rò nè̤ zṳ̂́eto akhu-akhyě, nè̤ ki pè́ tuố̤dố a htwǒhtya phú vǎ ò́lya̤kyǎ nè̤ nuôtônyě pǎ. Shyé꤮ ashuốakhè̌ bè pǎnuô, a ki lốhtyabǎhtya dû phú vǎ hénuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bínuôkhè̌ dố aklò̌nuô ǔ opò̤́ è́nyacò́ Zekaria rò a cuốnuô̌ onyě̤ nyacò́ dố tè̤lǔtyǎ hǒkǔ mame̤tě èthǐ tane̤ lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bí a hte tuố̤dố aklò̌ khè̌nuô a hébè cyá̤ pǎ èthǐ to rò èthǐ thè́gně ná a klyá myáhtye nyǎ tè̤myáhtyelwó tôcôcô dố tè̤lǔhǒdu akǔ nuô hò́. A hébè cyá̤ pǎ ná akhǎu tômû̌꤮ to rò a vû́vyá̤luô̌ prè́ ná takhukhadǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Rò bí a tè̤phyétè̤me̤ dố tè̤lǔtyǎ hǒkǔ htuô̌hò́ akhè̌nuô, Zekaria ka̤ dố ahi. ");
INSERT INTO kyu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nyě̤tyatonuô amě Elizabeth muố̤dò̌htya rò a owóouố dố hikǔ nyǎ̤lè̌ khǎlé̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Rò a hé, “Khǒnyá̤yě Byacè me̤cwó̤ hò́ vǎ hò́. A phyékyǎ pé̤ hò́ vǎ tè̤thè́tarè̤̌ dố ǔ pacyé̤ishyé vǎ nuôtahe hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bí Elizabeth muố̤dò̌ bǎhò́ lè̌thuô̌thyó akhè̌nuô, Cò́marya nò̌hyǎlya̤ tanémò́khuphú Gabrielè dố vǐ̤ Nazarè dố a o dố Galilea ké̤ nuôtôvǐ̤ akǔ. ");
INSERT INTO kyu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A phyéhyǎ ní̤pé̤ prè̤mòphúthè dố amwi̤ ná Maria yěnuô tôprè̤ a tè̤ritè̤kyǎ. Maria yěnuô a ò́lya̤ htuô̌hò́ dố a ki phyé ná prè̤khǔ dố amwi̤ ná Joseph yěnuô tôprè̤ hò́. Joseph ma Khwí Davi aklwǐlyǎ tǎ̤lya̤ dǐtû́ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tanémò́khuphú hyǎ dố a o rò a hé lǔ, “Cò́marya myádu khóní̤dûhò́ nè̤ hò́, rò Byacè ki okuô̌dû ná nè̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mò́khutanéphú hyǎ hésoluô̌ pé̤ Maria tè̤ritè̤kyǎ yěnuô, a tane̤plǒ ní̤dyé angó̤lasá to, a tane̤pyá̤tane̤sè̌ ní̤dyé nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tanémò́khuphú hé lǔ, “Maria꤮ thè́isě tǎmé̤ ní! Cò́marya me̤bwíme̤taryě hò́ nè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nè̤ ki muố̤dò̌htya pǎ rò nè̤ ki phúo ní̤dyé pacè̤̌ prè̤khǔphú tôprè̤ pǎ, rò è́ amwǐ̤ ná Jesǔ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","È ma kayǎ dố abwídu-ataryěhtǔ tôprè̤ pǎ rò ǔ ki è́ è ná tè̤dutè̤htǔ tadû Cò́marya aphúkhǔ tôprè̤ pǎ. Byacè Cò́marya ki dyé htwǒ è ná khwí tôprè̤ phú aklwǐalyǎ Davi nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Htuô̌rò a ki htwǒhtya Israelphú tahe akhwí pwǒ̤tôhtû̌ pwǒ̤taple pǎ rò ahtyěaké̤ nuô atadû pé̤ cyá̤ pǎ cò́ to.” ");
INSERT INTO kyu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Rò Maria hésû tanémò́khuphú, “Vǎ phúthè prè́yě, vǎ ki muố̤dò̌ rò ki phúo cyá̤ phútě?” ");
INSERT INTO kyu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rò tanémò́khuphú hésû è, “Thè́ Sǎsè̌ Byacè ki hyǎlya̤ dû dố nè̤lo̤ pǎ rò dố tè̤dutè̤htǔ tadû Cò́marya a tè̤pro̤tè̤prya̤ akhu-akhyě pǎ rò pacè̤̌phú tôprè̤ ki hyǎo pacè̤̌lya̤ pǎ. Dố tè̤ritè̤kyǎ yě akhu-akhyěrò pacè̤̌sǎsè̌ yětôprè̤nuô ǔ ki è́ lǔ ná Cò́marya aphúkhǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tane̤tuố̤dû nè̤ tôpuố̤bǔ Elizabeth nuô, a muố̤prè̤́ lǎhò́. Ǔ hé lǔ ná aphú o cyá̤ pǎto hò́ tadû́rò, khǒnyá̤yě a muố̤dò̌ bǎhò́ lè̌thuô̌thyó hò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cò́marya me̤cyá̤ tè̤pwǒ̤tôcô.” ");
INSERT INTO kyu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Rò Maria hésû, “Vǎ ma Byacè a lulémuố̤ tôprè̤ prè́. A ki htwǒhtyadû phú nè̤ hénuô pǎ ní꤮.” Rò tanémò́khuphú htecuố taphǎkyǎ ná lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nyě̤tyato nuô, Maria otaritaryǎ ané̤ rò a htetalwǒ̤ cuố dố vǐ̤ dố a o dố solo̤ nuôtôvǐ̤, bí Judaké̤kǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A cuốnuô̌ dố Zekaria a hidò́kǔ rò a hémo̤héryá avyá̤ Elizabeth. ");
INSERT INTO kyu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Rò bí Elizabeth ní̤huô̌ Maria hémo̤héryá lǔ akhè̌nuô, pacè̤̌phú dố ahò́kǔ yětôprè̤nuô, a kṳ́ká̤htya. Rò Elizabeth yěnuô a lốbǎhtya ná Thè́ Sǎsè̌ Byacè. ");
INSERT INTO kyu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Rò a hébèshyo, “Dố prè̤mò lò̌꤮ plǐ aklè̌nuô nè̤ ma prè̤mò dố a ní̤bè lốhò́ ǔ tè̤sò̌ri tôprè̤ hò́ rò pacè̤̌phú dố nè̤ ki phúo ní̤dyé lǔ pǎ yětôprè̤nuô a ní̤bè kuô̌dûhò́ tè̤sò̌ri hò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Vǎ Byacè amuố̤ cuốhyǎtuố̤ dố vǎ o me̤tě? Vǎ cuố ní̤bè khódû tè̤myádu vǎ me̤tě? ");
INSERT INTO kyu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Vǎ ní̤huô̌ nè̤ hémo̤héryá vǎvǎ ná pacè̤̌phú o dố vǎhò́kǔ yětôprè̤ kṳ́ká̤htya thè́krṳ̂̌thè́lò̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nè̤ zṳ̂́e ná Byacè a tè̤ritè̤kyǎ yě ki hyǎ lốhtyabǎhtya má̤lakǒ dố nè̤gně pǎ akhu-akhyě nè̤ ní̤bèhò́ tè̤sò̌ri hò́!” ");
INSERT INTO kyu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria hé, “Vǎ ki htuthè́htya lò̌thulò̌thè́ vǎ Byacè. ");
INSERT INTO kyu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cò́marya ma prè̤me̤lwóhteka̤ vǎ tôprè̤ htuô̌to è ma vǎ Byacè tôprè̤ akhu-akhyě vǎ thè́krṳ̂̌thè́lò̌ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Vǎ ma a lulémuố̤ dố amèthè okuô̌ǔ to tôprè̤ manárò a thè́né̤htyabè tuố̤ vǎ. Cáhtya khǒnyá̤yě tǎ̤plehyǎnuô myěcô pwǒ̤꤮ tôcô ki è́ vǎ ná prè̤mò dố a ní̤bè tè̤sò̌ri tôprè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Me̤těhérò Cò́marya dố ashyo-asò̌ yětôprè̤ dyéo htwǒhtya pé̤hò́ vǎ tè̤acò́azǎ̤ tadû yěnuô ná a tè̤pro̤tè̤prya̤ tahe dố vǎgně hò́. Amwi̤ ma asǎsè̌. ");
INSERT INTO kyu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aphúalye̤ dố a dyaduzṳ̂́nyá̤ lǔ tahenuô, a ki thè́zò̤klabèní̤ èthǐ tôhtû̌ htuô̌ tôhtû̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bí a zó̤htya atakhu dố ashyo-asò̌ yě akhè̌, kayǎ dố a tane̤du ní̤dyé ané̤ tahenuô, a ki lṳpruốlṳpryǎkyǎ lò̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A dyatǎ̤kyǎ khwí shyosò̌ tahe dố èthǐ akhǎlé̤ rò a dyahtyalô̌ tapleke kayǎ dố amèthè okuô̌ǔ to nuôtahe hò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A dyéekò́ dyéǒbǎ hò́ kayǎ dố a ovǐ̤okò̌ tahe rò a plwǒka̤ kazuô̌kyǎ kayǎ duzá̤htyathè̌ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A thè́né̤htya tuố̤bèhò́ tè̤ dố a ò́lya̤ htuô̌hò́ ná pè̤phyěpè̤phuô̌ dố꤮ nyénu nuôtahe rò a hyǎme̤cwó̤ hò́ alulé Israelphú tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Thyáphú a ki thè́zò̤klabèní̤ Abraham ná aklwǐalyǎ yětahe tôhtû̌ htuô̌ tôhtû̌ agněnuôrò, a thè́né̤htya ní̤dyé hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria cuốokuốkuô̌ ná Elizabeth yěnuô a phûbǎ cò́ thuô̌lè̌ hò́ rò a ka̤no dố ahi prè́. ");
INSERT INTO kyu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bí Elizabeth ahò́athè́ tǒlè̌ hò́ akhè̌nuô, aphú oní̤ phúprè̤khǔ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kayǎ ophûowó ná lǔ bínuô tahe ná aklwǐalyǎ phûwó tahe ní̤huô̌ ná Byacè dyéluô̌ hò́ a tè̤thè́zò̤ní̤ lakǒ lǔ akhè̌nuô, èthǐ thè́krṳ̂̌thè́lò̌ kuô̌lò̌ lǔ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Èthǐ lé̤klǒ o ná ki pacè̤̌ bǎhò́ agně lwǐ̤thyó hénuô, ǔ bè dû́talí ní̤pé̤ lǔphá. Bí atǒ dû́talíphá akhè̌nuô, aklwǐalyǎ tahe hyǎkuô̌ lahyǎ rò èthǐ thè́zṳ̂́ pó̤ní̤ lahyǎ amwǐ̤ ná aphè̌ Zekaria amwi̤ ní̤dû. ");
INSERT INTO kyu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Manárò amuố̤ hé, “Má̤to! Tǒbè pó̤ní̤ lǔmwǐ̤ ná Giovanni.” ");
INSERT INTO kyu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Èthǐ hésû amuố̤, “Dố thǐklwǐthǐlyǎ aklè̌nuô, amwi̤ ná Giovanni nuô a o tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aphè̌ thè́zṳ̂́ è́ amwǐ̤ ná ǔpěnuô èthǐ thè́zṳ̂́ thè́gně akhu-akhyě, èthǐ dyéluô̌ lahyǎ a takhukhadǎ rò sudyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aphè̌ kwǐ lò̤́ba rò a rǎtǎ̤, “Amwi̤ ma Giovanni.” Rò èthǐ khyéthukhyéthè́ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bínuô tôphuốtuô̌ Zekaria hébè cyá̤ ka̤khyě rò a htuthè́htya Cò́marya. ");
INSERT INTO kyu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kayǎ ophûowó bínuô tahe khyéthukhyéthè́ lò̌plǐ cò́, rò tè̤htwǒhtya phúyěnuô a luô̌pasǐ cuốlò̌ cò́ Judaké̤ tôké̤lè̤̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Byacè a tè̤pro̤tè̤prya̤ yǒ okuô̌ ná pacè̤̌phú yětôprè̤ akhu-akhyě, lò̌꤮ kayǎ dố a ní̤huô̌ tè̤ritè̤kyǎ yětahenuô a khyéthukhyéthè́ rò a hé lahyǎ, “Pacè̤̌phú yětôprè̤nuô a ki htwǒhtya ǐtě pǎ ha?” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Giovanni aphè̌ Zekaria lốbǎhtya ná Thè́ Sǎsè̌ Byacè rò a hépro̤ one ré̤ Cò́marya ari-akyǎ, ");
INSERT INTO kyu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pè̤ ki htuthè́htya ró̤lǔ Israel a Byacè Cò́marya pó꤮. Me̤těhérò a hyǎhò́ dố akayǎ tahe a o hò́ rò a hyǎ me̤lwóhteka̤ hò́ akayǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dố Cò́marya a prè̤me̤tè̤phú Davi aklwǐalyǎ akǔnuô, Cò́marya dyéohtwǒhtya pé̤ hò́ pè̤ prè̤me̤lwóhteka̤ Byacè dố a o ná a taryěshyosò̌ yětôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Cò́marya ò́lya̤ one htuô̌hò́ ná aprè̤pro̤ sǎsè̌ dố nuôkhè̌ tahe, ");
INSERT INTO kyu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","è ki me̤lwóhteka̤ pè̤ dố khura tahe ná kayǎ dố a thè́hte pè̤ nuôtahe a takhukǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A hé ná a ki dyéluô̌ a tè̤thè́zò̤klabè dố pè̤phyěpè̤phuô̌ tahe alo̤ pǎ, htuô̌to a ki thè́né̤htya bètuố̤ khyěthyá a tè̤ò́lya̤ sǎsè̌ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Pè̤ tè̤ohtwǒprè̤ tôhtû̌ kayǎyě, thyáphú pè̤ ki htwǒhtya kayǎsǎsè̌, kayǎcò́kayǎte̤ dố Cò́marya anyěhyǎ nuô rò, a héklò̤héma htuô̌hò́ angó̤ ná Abraham hò́, rò a ò́lya̤nuôlya̤ htuô̌hò́ dố a ki me̤lwóhteka̤ pè̤ ná kayǎ dố a thè́hte pè̤ nuôtahe a takhukǔ rò a plwǒme̤ hò́ a tè̤me̤yě ná pè̤ hò́, rò pè̤ ki me̤ tǎ ná tè̤taròthè́ thè́isě tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zekaria hé aphú, “Vǎphúkhǔ, ǔ ki è́ nè̤ ná tè̤dutè̤htǔ tadû Cò́marya aprè̤pro̤ tôprè̤ pǎ, me̤těhérò nè̤ ki hyǎ taritaryǎ one ré̤ pé̤ Byacè lé̤hyǎklyá agně pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nè̤ ki héso pé̤ Byacè akayǎ è́prè̤ ná Cò́marya ki plwǒkyǎ èthǐ tè̤thû́tè̤ora pǎ, rò èthǐ ki ní̤bè tè̤me̤lwóhteka̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Me̤těhérò pè̤ Cò́marya yěnuô, a thè́zò̤ní̤ nyacò́ ǔ rò a khyáthè́dǒ nyacò́. A nò̌hyǎlya̤hò́ kayǎ o dố mò́khu tôprè̤ ki hyǎ me̤lwóhteka̤ hò́ pè̤, prè̤me̤lwóhteka̤ pè̤ yětôprè̤nuô, a thyáhò́ ná tamò̤́ lǐhtyaré̤ dố mò̤́lǐbǔkhè̌ nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Rò tamò̤́yě a htya dố mò́lè̤̌ rò a ki lǐtakhè̌tǎ̤ pé̤ kayǎ o dố tè̤khítè̤lò̤, tè̤thyě azo̤uô akǔ nuôtahe lò̌꤮ plǐ pǎ, rò a ki zṳ̌klyázṳ̌klǒ cuố ní̤pé̤dû pè̤ tè̤ohtwǒprè̤ dố tè̤kacṳ́kabè́ aklyákǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bí Giovanni duhtyahò́ akhè̌nuô, Cò́marya a Thè́ Sǎsè̌ dyé lǔ tè̤taryěshyosò̌. Bí a cáhtya me̤luô̌ tyahí atè̤me̤ dố Israelphú tahe a mèthènyě híto akhè̌nuô, a cuốo prè́ dố ké̤sè̌htyěkya̤ lò̤́tamákhu akǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Bínuôakhè̌ khwí Augusto nò̌ihtuô rǎmá plò́lò̌ kayǎ mwi̤ dố Romaké̤ tôké̤lè̤̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yěma tè̤rǎmá plò́mwi̤ aré̤lố tôhû bí Quirino htwǒ khwídu dố Syria ké̤ akhè̌nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Rò kayǎ pwǒ̤꤮ tôprè̤ ka̤ lahyǎ dố adò̌, avǐ̤ rò ka̤sunuô̌ lahyǎ amwi̤. ");
INSERT INTO kyu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph o bí vǐ̤ Nazarè, Galilea ké̤kǔ nuô rò a htecuốkuô̌ dố vǐ̤ Bethelehem, Judaké̤, bí khwí Davi lé̤opacè̤̌lya̤ khǎlé̤nuô. Joseph ma Davi aklwǐalyǎ kalya̤ dǐtû́ tôprè̤ akhu-akhyě a ka̤kuô̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","È ná Maria dố a dyémá htuô̌hò́ lǔ dố a ki phyé lǔ nuôtôprè̤ cuố benuô̌kuô̌ amwi̤. Bínuôakhè̌ ma Maria ohò́ ná ahò́athè́ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Rò bí èthǐ o pǎ bí vǐ̤ Bethelehem akhè̌nuô, Maria ahò́ tǒlè̌ hò́ dố a ki phúo hò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A phúoní̤ phúvyá̤prè̤́ prè̤khǔ tôprè̤ rò a phyáplû̌ lǔ ná ikè̤̌ rò a dya omyětǎ̤ lǔ dố pṳ́klókǔ, me̤těhérò hidò́kǔ dố agněnuô a o pǎ tôtó̤ to. ");
INSERT INTO kyu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Khǎlé̤ tavǐtava̤ bínuô tôphonuô, prè̤kyě̤thímíphú o tahe. Èthǐ hyǎ omyěpò̤́ ní̤dyé athímíphú tahe dố mi̤klè̌, dố nyelá̤khu tôpho. ");
INSERT INTO kyu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bínuôakhè̌ Byacè a tanémò́khuphú tôprè̤ hyǎ oluô̌htya pé̤ èthǐ, rò Byacè Cò́marya a tè̤lǐtè̤takhè̌ tahe lǐ tava̤ lò̌plǐ èthǐ rò èthǐ thè́isě taròthè́ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Manárò tanémò́khuphú hé èthǐ, “Thè́isě tǎmé̤! Vǎ phyéhyǎní̤ pé̤hò́ thǐ tè̤thè́krṳ̂̌mila dố a ki me̤ thè́krṳ̂̌ lakálakǒ cò́ ǔpwǒ̤꤮ prè̤ pǎ yěnuôhò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yětôthè̌ dố Davi avǐ̤kǔ nuô, prè̤me̤lwóhteka̤ a Byacè má̤hò́ Krístu yě hyǎ o pacè̤̌lya̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Thǐ ki myáhtye pacè̤̌ tôprè̤ pǎ, rò ǔ phyáplû̌ lǔ ná ikè̤̌ rò ǔ be-omyětǎ̤ è dố pṳ́klókǔ nuô pǎ. Thǐ ki myáhtye phúnuôma má̤hò́ pacè̤̌phú dố vǎ hésoluô̌ pé̤ thǐ yěnuô tôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bínuôakhè̌ tanémò́khuphú aklyěphú tômṳ hyǎoluô̌htya khyé tố̤kuô̌ ná tanémò́khuphú yětôprè̤ rò èthǐ irǒ htuthè́htya Cò́marya rò a irǒ lahyǎ, ");
INSERT INTO kyu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Me̤lǐme̤takhè̌ htuthè́htya lahyǎ Cò́marya dố a o dố khǎlé̤htyalô̌ tadûlố ǔ dố mò́khu yěnuô tôprè̤ pó꤮. Tè̤pě̤tè̤dwǒ ná tè̤kacṳ́kabè́ ki ohtya kuô̌dû dố hekhuyě rò a ki otố̤kuô̌dû ná kayǎ dố Cò́marya thè́plò oní̤ lǔ nuôtahe ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bí tanémò́khuphú ka̤ kahtya htuô̌hò́ dố mò́khu akhè̌nuô, prè̤kyě̤thímí tahe hé ní̤dyé khyělǔ, “Cuố꤮, pè̤ cuố dố vǐ̤ Bethelehem rò pè̤ cuốmyákuô̌ tè̤htwǒhtya-ané̤ dố Byacè hyǎ dyéthè́gněkyǎ pè̤ tè̤ritè̤kyǎ yěnuô pó꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Rò èthǐ htecuố tapluố̤taplyě lahyǎ rò cuốmyáhtye Maria ná Joseph, htuô̌rò èthǐ cuốmyáhtye ǔ dya omyětǎ̤ pacè̤̌phú tôprè̤ dố pṳ́klókǔ. ");
INSERT INTO kyu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bí prè̤kyě̤thímíphú yětahe myáhtye pacè̤̌phú yě ná amuố̤aphè̌ akhè̌nuô, a cuố héluô̌ pé̤ ǔ phú tanémò́khuphú hésoluô̌kyǎ pé̤ èthǐ ná pacè̤̌phú yětôprè̤ ari-akyǎ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lò̌꤮ kayǎ dố a ní̤huô̌ prè̤kyě̤thímíphú yětahe hésoluô̌ pé̤ lǔ tè̤ritè̤kyǎ yětahenuô a khyéthukhyéthè́ lò̌ lahyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria tǒ̤maní̤ lò̌ tè̤ritè̤kyǎ yětahe rò a tane̤ ní̤dyé ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Prè̤kyě̤thímíphú yětahe ka̤khyě khyěthyá dố èthǐ thímí tahe a o. Rò phú tanémò́khuphú hésoluô̌ pé̤ èthǐ rò èthǐ ní̤huô̌nò́, èthǐ cuố myáhtyebènò́ akhu-akhyě, èthǐ htuthè́htya Cò́marya, htuô̌to èthǐ me̤lǐme̤takhè̌htya Cò́marya. ");
INSERT INTO kyu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bí pacè̤̌ yětôprè̤ bǎhtya hò́ athè̌ lwǐ̤thyó hò́rò a tǒbè dû́talí hò́ phá akhè̌nuô, èthǐ è́ ní̤dyé lǔmwi̤ ná Jesǔ phú tanémò́khuphú pó̤onekyǎ pé̤hò́ lǔmwǐ̤ bí amuố̤ muố̤dò̌ tyahí lǔ to akhè̌nuô. ");
INSERT INTO kyu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Phú Mosè mekyǎ a tè̤thyótè̤thya ná èthǐ tǒbè me̤mwǒ̤plǐthǐplo lahyǎ ané̤nuô, ashuốkhè̌ hyǎtuố̤hò́. Rò thyáphú Joseph ná Maria ki besǎsè̌htya pacè̤̌phúyě dố Byacè anyěhyǎ nuôrò, èthǐ phyéní̤ pacè̤̌phúyě rò a cuố lahyǎ dố vǐ̤ Jerusalem. ");
INSERT INTO kyu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Phú Byacè tè̤thyótè̤thya tè̤rǎmárǎdyǎ o, “Lò̌꤮ phúvyá̤prè̤́ prè̤khǔ tahenuô tǒbè besǎsè̌htya è dố Byacè a mèthènyě.”) ");
INSERT INTO kyu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Phú Byacè héokyǎ a tè̤thyótè̤thya nuô, èthǐ tǒbè cuố lǔtyǎhtya kuô̌ “Htulwí̤thǒ nyě̤bè má̤torò htulwí̤ dǐkrǎ nyě̤bè.” ");
INSERT INTO kyu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bínuôkhè̌, dố vǐ̤ Jerusalem akǔnuô kayǎ otôprè̤, amwi̤ ná Simeonè. È ma kayǎ cṳ̌e bezṳ̂́nyá̤ Cò́marya tôprè̤, htuô̌to Thè́ Sǎsè̌ Byacè okuô̌ ná è. È ma kayǎ dố a opò̤́myásû̌ Cò́marya ki me̤lwóhteka̤ Israelphú dố tè̤cyě̤tè̤cṳ̂ akǔ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Htuô̌rò Thè́ Sǎsè̌ Byacè dyémyáhtyelwó tǎ̤te̤ one hò́ è, a ki myáhtye tyahí Krístu dố Byacè Cò́marya nwóhtya lǔ yětôprè̤ híto hénuô, a bèthyění̤ híto. ");
INSERT INTO kyu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Thè́ Sǎsè̌ Byacè thǔ è rò a cuốnuô̌ dố tè̤lǔtyǎ hǒkǔ. Bí Jesǔ amuố̤aphè̌ phyáhyǎní̤ lǔ, rò a ki hyǎme̤ pé̤ lǔ phú Cò́marya a tè̤thyótè̤thya héonekyǎ akhè̌nuô, ");
INSERT INTO kyu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeonè phyáhtya pacè̤̌phú dố a takhulo̤ rò a htuthè́htya Cò́marya rò a hé, ");
INSERT INTO kyu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kố꤮ Byacè, phú nè̤ héone htuô̌hò́ nè̤ngó̤ nuô khǒnyá̤rò a lốhtyabǎhtya hò́, nò̌thyě kacṳ́kabè́ mo̤dû mò̌hò́ nè̤lulé má̤ vǎyě. ");
INSERT INTO kyu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Nè̤ tè̤me̤lwóhteka̤ dố nè̤ taritaryǎ one pé̤ nè̤ kayǎ pwǒ̤prè̤ agně yěnuô, vǎ myáhtye shyěklò̤́ cò́hò́ ná vǎmèthè hò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","È ma tè̤lǐ tômě dố a ki dyéluô̌htya pé̤ Judaphú má̤to tahe, htuô̌to a phyéhyǎní̤ pé̤ tè̤sò̌ri dố nè̤ myěcô Israelphú tahe a o.” ");
INSERT INTO kyu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dố Simeonè hébè tè̤ritè̤kyǎ yě akhu-akhyě, pacè̤̌phú yětôprè̤ amuố̤aphè̌ khyéthukhyéthè́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeonè sò̌ri htuô̌ èthǐ rò a hékyǎní̤ pacè̤̌phú amuố̤ Maria yěnuô, “Pacè̤̌yě Cò́marya nwóhtyahò́ lǔ dố a ki me̤lwóhteka̤ Israelphú tahe pǎ, rò a ki dyadudyahtyalô̌ kuô̌ke kayǎ dố aruô tahe pǎ. È ma Cò́marya a tè̤mátè̤dyǎ tôcô, rò kayǎ è́prè̤ ki hébè takhwótakèsû lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Phúnuôrò kayǎ è́prè̤ tane̤ dò́uốdò́bí tè̤ dố èthǐ athè́plòkǔ tahenuô, Cò́marya ki bámǒhtyaluô̌ pǎ” htuô̌rò a hé Maria, “Tè̤thè́plè̤̌nebè dố a htyǎ thyácò́ná nè́ nuô a ki prǒnuô̌ nè̤ thè́plò pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Prè̤pro̤muố̤ okryá dố a muố̤prè̤́ nyacò́ hò́ o tôprè̤, amwi̤ ná Anna. È ma Phanuel aphúprè̤mò, è ma Asher myěcôphú tôprè̤. A phyéhtuô̌ avè̤ rò a otố̤ní̤ lǔ thuô̌thyótôna prè́. ");
INSERT INTO kyu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Avè̤ thyěkyǎ lǔkhǎlé̤ rò a okryákyǎ ní̤dû prè́. Khǒnyá̤rò ana o hò́ shyělwǐ̤thyó ná lwǐ̤na hò́. A htecuố tôpho꤮ to, a oprè́ bí tè̤lǔtyǎ hǒkǔnuô prè́. A cò́bucò́bè̌htya Cò́marya dố tè̤lǔtyǎ hǒkǔ mò̤́khíkhí mò̤́sè̌klè̌klè̌ cò́, htuô̌to a duôe sèesèǒ rò a kwǐcò́bè̌ pwǒ̤nyěpwǒ̤thè̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bínuôkhè̌, a hyǎtuố̤ tǒtû́ dố èthǐ o rò a htuthè́htya Cò́marya. Htuô̌rò a hésoluô̌ pé̤ pacè̤̌phú yětôprè̤ ari-akyǎ ná lò̌꤮ kayǎ dố a opò̤́myásû̌ Cò́marya ki me̤lwóhteka̤ vǐ̤ Jerusalemphú pǎ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bí Joseph ná Maria me̤htuô̌lò̌hò́ phú lò̌꤮ Byacè mekyǎ tè̤thyótè̤thya tahe akhè̌nuô, èthǐ ka̤khyě khyěthyá dố alé̤o ní̤dyé vǐ̤ Nazarè nuô. Vǐ̤yěnuô a o bí Galilea ké̤kǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pacè̤̌yě a duhtya rò a hè̌shyoresò̌ hyǎ, rò a lốbǎ cò́ ná tè̤thíphè́ rò Cò́marya sò̌risò̌bǔní̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pwǒ̤nana꤮ bí ǔ me̤pwè̌me̤la ní̤dyé pwè̌ dố ǔ è́ ná tè̤cuốtalwópwè̌ akhè̌nuô, Jesǔ amuố̤aphè̌ cuốkuô̌ dố vǐ̤ Jerusalem. ");
INSERT INTO kyu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bí Jesǔ na ohò́ shyényě̤na akhè̌, amuố̤aphè̌ yěnuô, alé̤klǒ cuố lahyǎ tè̤cuốtalwópwè̌, rò a è́ cuốní̤ pacè̤̌phú Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bí tè̤cuốtalwópwè̌ htuô̌hò́ akhè̌nuô, èthǐ ka̤khyě dố adò̌aso. Bínuôakhè̌, pacè̤̌ Jesǔ yě a okyǎ dố vǐ̤ Jerusalem akǔ, manárò amuố̤aphè̌ thè́gně to. ");
INSERT INTO kyu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Èthǐ tane̤ ná a ka̤ tố̤kuô̌ hò́ ná kayǎ dố a cuốpwè̌ka̤ nuôtahe aklè̌ hò́. Bí èthǐ ka̤ htuô̌hò́ tônyě꤮ mò̤́hé akhè̌nuô, a myápṳ̌ sudyǎní̤ no Jesǔ dố aklwǐalyǎ tahe aklè̌ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bí èthǐ myápṳ̌ rò a myáhtye pé̤ pǎ to akhè̌nuô, èthǐ ka̤khyě khyěthyá lahyǎ dố vǐ̤ Jerusalem. ");
INSERT INTO kyu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Thuô̌nyětônyěnuô, a cuố myáhtyeno ná Jesǔ cuố o dố tè̤lǔtyǎ hǒkǔ prè́. A cuố onyǎo tố̤kuô̌ ná Juda a thárádu thǎmǎhtǔ tahe rò a cuốní̤dǎkuô̌ Cò́marya alǎ̤angó̤ tahe rò a hébèsudyǎ kuô̌ǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bí kayǎ lò̌꤮ plǐ ní̤huô̌ pacè̤̌phú yětôprè̤ a tè̤hébèhésû̌ akhè̌nuô, èthǐ khyéthukhyéthè́ lò̌plǐ cò́ a tè̤cyá̤tè̤dè ná a tè̤hésû ka̤khyě ǔ nuôtahe cò́. ");
INSERT INTO kyu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Joseph ná Maria cuốmyáhtye lǔ rò a khyéthukhyéthè́ nyacò́, rò amuố̤ hé lǔ, “Phúkhǔ, nè̤ cuố me̤tuố̤ phúyě me̤tě? Vǎ ná nè̤phè̌ kṳ́kyǎ̤ rò myápṳ̌ lakǒ nè̤ ma tadû꤮ ké̤ cò́ meně.” ");
INSERT INTO kyu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Rò pacè̤̌ Jesǔ hésû, “Thǐ cuố myápṳ̌ vǎ katè̤́ nuô me̤tě? Thǐ thè́gně nyǎ ná vǎ o dố vǎphè̌ ahikǔ to è̌.” ");
INSERT INTO kyu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Manárò amuố̤aphè̌ thè́gněplǒ lǔ tè̤hébè yě angó̤lasá to. ");
INSERT INTO kyu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Htuô̌rò pacè̤̌phúyě a krwǒ ka̤kuô̌khyě amuố̤aphè̌ dố vǐ̤ Nazarè rò a cṳ̌ muố̤lǎ̤phè̌ngó̤ pwǒ̤꤮ tôphuố. Amuố̤ tǒ̤ma oplò́lò̌ lò̌꤮ tè̤htwǒhtya ané̤ yěnuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesǔ duhtya lốbǎ ná tè̤thítè̤phè́ rò Cò́marya ná prè̤lukayǎ myámo̤myádu ní̤dyé lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bí Khwídu Tiberia pốtè̤ bǎhtya hò́ shyényǎ̤ na akhè̌nuô, Pontio Pilato htwǒhtya khwídu dố Judaké̤. Rò prè̤pố Galilea ké̤ ma Khwí Herodè. Rò Khwí Herodè apuố̤ Philipu ma prè̤pố Ituraea ké̤ ná Trakoniti ké̤. Khwí Lysania rò a pốní̤ ke Abilene ké̤. ");
INSERT INTO kyu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Prè̤lǔtyǎ dulốǔ ma Anna ná Caipha hò́. Bínuôakhè̌ Zekaria aphúkhǔ Giovanni o dố ké̤sè̌htyěkya̤ lò̤́tamákhu rò Cò́marya hésoluô̌ tǎ̤pé̤ alǎ̤angó̤ dố Giovanni a o. ");
INSERT INTO kyu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Phúnuô akhu-akhyě lò̌꤮ dò̌ ophû tavǐtava̤ bí Jordano lyǎ̤muố̤ khǎshyé tahenuô, Giovanni cuốlě hésodônyǎ pé̤lò̌ ǔ ná za̤ ní̤dû lahyǎ thǐné̤ rò plwǒ lahyǎ thǐné̤ ná htyě tû́rò Cò́marya plwǒkyǎ thǐ tè̤thû́ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Phú Cò́marya alǎ̤angó̤ rǎone htuô̌hò́ dố Prè̤pro̤ Isaiah a likǔnuô, rò a hé, “Kayǎ tôprè̤ è́htǒhtya dố ké̤sè̌htyěkya̤ lò̤́tamákhu rò a hé, ‘Taritaryǎ one lahyǎ klyá dố Byacè agně. Me̤cò́me̤pě̤ lahyǎ Byacè lé̤hyǎklyá agně tôbǒ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lò̌꤮ ké̤tò̤kǔ tahenuô, bè thốbǎ lò̌. Lò̌꤮ khǒmǎ̤khǒlǒ ná sodusohtǔ tahenuô, bè me̤pě̤ lò̌. Me̤cò́ lò̌ klyá dố a takǐtaka̤ nuôtahe. Rò bè me̤thye lò̌ klyá dố a taprǐtaprú nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kayǎ pwǒ̤꤮ tôprè̤ ki myáhtye lò̌ Cò́marya nwóhtya prè̤me̤lwóhteka̤ prè̤lu hekhuphú yěnuô tôprè̤ pǎ.’” ");
INSERT INTO kyu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kayǎ tahe kíré̤ hyǎ plwǒ lahyǎ ané̤ ná htyě rò a hyǎró̤hyǎè́ nyacò́ dố Giovanni a o. Rò Giovanni hé èthǐ, “Rṳ́thíthǐ꤮! Maǔpě tôprè̤ dyérò̤dyéryě̤ thǐ ná thǐ ki siplè́bè́ ná Cò́marya a tè̤cirya dố a ki hyǎpǎ yěnuô pě? ");
INSERT INTO kyu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Thǐ ki za̤ ní̤dû má̤lakǒ hò́ thǐné̤ hò́ kihérò dyéluô̌ lahyǎ thǐ tè̤ohtwǒprè̤ tahe ná thǐ tè̤dya thǐ thè́plòthuôhtyě tahe. Héhtǒhélya̤ tǎ thǐné̤, ‘Pè̤ ma Abraham aklwǐalyǎ’ nuôtǎmé̤. Vǎ hé thǐ, Cò́marya me̤htwǒhtya lò̤́yětahe ná Abraham aphú má̤ a me̤cyá̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kwǒ tôbè ohò́ dố thòkhǎshyéhò́ rò ǔ ki ikwǒ̤ khû́hò́ thòmò̤́ tahe pǎ, rò ǔ ki icǒtṳ̂̌ tuố̤ cò́ dố arwí̤ahtwo pǎ. Thòmò̤́ tômò̤́mò̤́ dố athèaphǒ twó̤ryá to nuô, ǔ ki ikwǒ̤ khû́kyǎ è pǎ rò ǔ ki vǐnuô̌kyǎ è dố mikǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Rò kayǎ è́prè̤ sudyǎ Giovanni, “Ki hé phúnuôrò pè̤ tǒbè me̤phútě?” ");
INSERT INTO kyu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Rò a hésû èthǐ, “Kayǎ dố aca̤ o nyě̤pṳ̂nuô bè dyé pé̤ kuô̌ kayǎ dố aca̤ o kuô̌ǔ tôpṳ̂꤮ to nuôtahe. Htuô̌rò kayǎ dố a lé̤elé̤ǒ o tahenuô, iběeběǒ pé̤ kuô̌ǔ.” ");
INSERT INTO kyu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Prè̤kwǐamo-arǎ tahe ki plwǒ kuô̌ lahyǎ ané̤ ná htyě rò a hyǎ dố Giovanni a o rò a hyǎ sudyǎ lǔ, “Thárá, pè̤ tǒbè me̤phútě?” ");
INSERT INTO kyu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Rò a hésû èthǐ, “Kwǐ lahyǎ amo-arǎ phú ǔ nò̌kwǐ thǐnuô, kwǐlốkwǐklò̌ tǎ ná ǔ nò̌kwǐ thǐ nuô tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Klyěphú tahe sudyǎkuô̌ lǔ, “Pè̤kuô̌lé? Pè̤ tǒbè me̤phútě?” Rò a hésû èthǐ, “Bè pṳ̂́phezè́plè́ ní̤ ǔrû̌ǔhtè̌ to. Kè̤bò̌kè̤bye tǎ ǔ tôprè̤꤮ tǎmé̤. Thè́plòmǐ ní̤ lahyǎ ná khwókè dố thǐ ní̤bè nuôtahe.” ");
INSERT INTO kyu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kayǎ è́prè̤ myásû̌ thè́lè̤ rò tane̤ lahyǎ Giovanni, “Taryá꤮ ma Krístu dố Cò́marya nwóhtya è dố a ki hyǎ me̤lwóhteka̤ prè̤lu hekhuphú hénuôma è cò́ hò́ kǒ꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Phúnuô akhu-akhyě Giovanni hé èthǐ pwǒ̤꤮ tôprè̤, “Vǎ plwǒ thǐ ná htyě prè́, manárò prè̤ dố a taryěpro̤prya̤ shyosò̌ lốklò̌ cò́ ná vǎ tôprè̤nuô a ki hyǎ pǎ. Vǎ ilyě pé̤prè́ è khuphá plye̤ prè́ nuô꤮ vǎ kò ná è to. A ki hyǎ plwǒ thǐ ná Thè́ Sǎsè̌ Byacè ná mi pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","È yěnuô athyáná kayǎ tôprè̤ dố a ikrè́sè́kyǎ buốthu ná buốsè́ nuô. Abuốsè́ tahenuô a ki ka̤klò̤̌plò́ dố acyǎkǔ pǎ, tadû́rò buốthu tahenuô a ki isû́û̌kyǎ ná mi dố a pǐ̤pé̤ cyá̤ pǎ tôphuố꤮ to yětôphè akǔ nuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Giovanni hésodônyǎ pé̤ ǔ tè̤thè́krṳ̂̌mila dố klyá è́bǒ rò a dyéhè̌dyére ní̤dû kayǎ bè́mṳ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Manárò Khwí Herodè yǒ cuốphyé ní̤dyé khyěthyádû akhǐ Herodia akhu-akhyě, Giovanni hé lǔ ná a me̤tè̤ yěnuôma a thû́. Htuô̌to dố aré̤khè̌nuô ma Khwí Herodè yǒ me̤ tè̤mǔmyá̤ricyá̤ tahe akhu-akhyě a dyapó̤ lǔ tè̤thû́ ná nuônuô. ");
INSERT INTO kyu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tû́yěnuô htuô̌to, Khwí Herodè me̤ tè̤mǔmyá̤ricyá̤ dulốpó̤ tôcô ma má̤hò́ a dò́tǎ̤kyǎ Giovanni dố htò̌kǔ yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bí kayǎ bè́mṳ plwǒ htuô̌lò̌hò́ ané̤ ná htyě akhè̌nuô, Byacè Jesǔ plwǒ kuô̌ no htyě dố khyě. Bí a kwǐcò́bè̌ akhè̌nuô, mò́khu lṳmǒ ǎyǎhtya. ");
INSERT INTO kyu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Htuô̌rò Thè́ Sǎsè̌ Byacè klwo ané̤ phú htulwí̤ rò a hyǎ tǎ̤o dố lǔlo̤. Bínuôakhè̌ ngó̤pra̤tǎ̤ dố mò́khu rò a hé, “Nè̤ ma vǎphúkhǔ dố vǎ mo̤ ní̤dyé rò atǒabè ná vǎ thè́plòthuôhtyě tôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bí Jesǔ cáhtya ithyó ǔ akhè̌nuô, a na phûbǎ hò́ thuô̌shyě hò́. Ǔ tane̤tyá̤ lǔ ná Joseph aphú prè́. Joseph ma Heli aphú, ");
INSERT INTO kyu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli aphè̌ma Mathat, Mathat aphè̌ma Levi, Levi aphè̌ma Melchi, Melchi aphè̌ma Jannai, Jannai aphè̌ma Joseph, ");
INSERT INTO kyu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph aphè̌ma Matathia, Matathia aphè̌ma Amò, Amò aphè̌ma Nahu, Nahu aphè̌ma Esli, Esli aphè̌ ma Naggai, ");
INSERT INTO kyu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai aphè̌ma Maatha, Maatha aphè̌ma Matathia, Matathia aphè̌ma Semein, Semein aphè̌ma Josech, Josech aphè̌ma Joda, ");
INSERT INTO kyu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda aphè̌ma Joana, Joana aphè̌ma Rhesa, Rhesa aphè̌ma Zerubabe, Zerubabe aphè̌ma Shealtiel, Shealtiel aphè̌ma Neri, ");
INSERT INTO kyu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri aphè̌ma Melchi, Melchi aphè̌ma Addi, Addi aphè̌ma Cosam, Cosam aphè̌ma Elmadam, Elmadam aphè̌ma Er, ");
INSERT INTO kyu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er aphè̌ma Joshua, Joshua aphè̌ma Eliezer, Eliezer aphè̌ma Jori, Jori aphè̌ma Mathat, Mathat aphè̌ma Levi, ");
INSERT INTO kyu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi aphè̌ma Simeonè, Simeonè aphè̌ma Juda, Juda aphè̌ma Joseph, Joseph aphè̌ma Jona, Jona aphè̌ma Eliakim, ");
INSERT INTO kyu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim aphè̌ma Melea, Melea aphè̌ma Menna, Menna aphè̌ma Matatha, Matatha aphè̌ma Natha, Natha aphè̌ma Davi, ");
INSERT INTO kyu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi aphè̌ma Jesse, Jesse aphè̌ma Obed, Obed aphè̌ma Boaz, Boaz aphè̌ma Salmon, Salmon aphè̌ma Nasho, ");
INSERT INTO kyu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasho aphè̌ma Amminadab, Amminadab aphè̌ma Admin, Admin aphè̌ma Arni, Arni aphè̌ma Hezrò, Hezrò aphè̌ma Perez, Perez aphè̌ma Juda, ");
INSERT INTO kyu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda aphè̌ma Jacob, Jacob aphè̌ma Isaac, Isaac aphè̌ ma Abraham, Abraham aphè̌ma Tera, Tera aphè̌ ma Nahor, ");
INSERT INTO kyu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor aphè̌ma Serug, Serug aphè̌ma Reo, Reo aphè̌ma Pelè, Pelè aphè̌ma Eber, Eber aphè̌ ma Shela, ");
INSERT INTO kyu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela aphè̌ma Caina, Caina aphè̌ma Arphaxad, Arphaxad aphè̌ma Shèm, Shèm aphè̌ma Noah, Noah aphè̌ma Lamech, ");
INSERT INTO kyu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech aphè̌ma Methusela, Methusela aphè̌ma Enoch, Enoch aphè̌ma Jare, Jare aphè̌ma Mahalaleel, Mahalaleel aphè̌ma Caina, ");
INSERT INTO kyu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Caina aphè̌ma Eno, Eno aphè̌ma Sèth, Sèth aphè̌ma Adam má̤hò́ Cò́marya aphúkhǔ nuôtôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bí Byacè Jesǔ o dố Jordano lyǎ̤muố̤ rò a ka̤ akhè̌nuô, a lốbǎ ná Thè́ Sǎsè̌ Byacè. Rò Thè́ Sǎsè̌ Byacè okuô̌ ná lǔ rò a thǔcuố lǔ dố ké̤sè̌htyěkya̤ lò̤́tamákhu. ");
INSERT INTO kyu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Khǐnéricyá̤ khuklò́ hyǎ ilo-ilyá lǔ athè̌lwǐ̤shyě anyělwǐ̤shyě. Rò anyělwǐ̤shyě athè̌lwǐ̤shyě akǔyěnuô a esèe tôcô꤮ to akhu-akhyě anyělwǐ̤shyě htuô̌rò athè́ethè́ǒ hyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bínuôakhè̌ khǐnéricyá̤ khuklò́ hé lǔ, “Nè̤ ki má̤ Cò́marya aphúkhǔ hérò hétǎ̤ lò̤́ yěnuôtômě rò nò̌htwǒhtya è ná khò́mǔ nuô.” ");
INSERT INTO kyu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Rò Jesǔ hésû è, “Cò́marya alǎ̤angó̤ hé, ‘Prè̤lukayǎ htwǒprè̤ tû́prè́ ná sèesèǒ nuô má̤to.’” ");
INSERT INTO kyu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Htuô̌rò khǐnéricyá̤ khuklò́ è́cuố Jesǔ dố khǎlé̤htyalô̌ tôpho rò a dyéluô̌ lò̌ lǔ ná htyěké̤ dố a o dố hekhu yěnuô pwǒ̤tôba. ");
INSERT INTO kyu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Khǐnéricyá̤ khuklò́ hé è, “Lò̌꤮ taryěpro̤prya̤ yětahe ná tè̤duzá̤htyathè̌ yětahenuô, vǎ ki dyé ná nè̤ pǎ. Lò̌꤮ yětahe nuôma a o lò̌hò́ dố vǎ khadǎkǔ hò́, vǎ ki dyépé̤ kayǎ dố vǎ thè́zṳ̂́ dyé lǔ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Phúnuôrò nè̤ ki cò́bè̌htya vǎ hénuô, lò̌꤮ yětahenuô vǎ ki dyé lò̌ ná nè̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesǔ hésû lǔ, “Cò́marya alǎ̤angó̤ hé phúyě, ‘Cò́bè̌htya prè́tû́ nè̤ Byacè Cò́marya rò me̤prè́tû́ ètè̤me̤ prè́ ní,’” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Htuô̌rò khǐnéricyá̤ khuklò́ è́cuố lǔ dố vǐ̤ Jerusalem rò a nò̌ihtòo lǔ dố tè̤lǔhǒdu a khuklwókhu dố a htyalô̌lố tôtó̤ rò a hé lǔ, “Nè̤ ki má̤ Cò́marya aphúkhǔ tôprè̤ hérò pá̤tǎ̤ mò̌! ");
INSERT INTO kyu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Me̤těhérò, Cò́marya alǎ̤angó̤ hé, ‘Cò́marya nò̌ myákhwè takò́takè̤ní̤ nè̤ ná a tanémò́khuphú tahe pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“Htuô̌to a hé pó̤, ‘Thyáphú nè̤ khǎduô ki bèsè̌ ná lò̤́ tǎmé̤ nuô èthǐ ki phyáhtyasûdû nè̤ pǎ.’” ");
INSERT INTO kyu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Manárò Jesǔ hésû lǔ, “Cò́marya alǎ̤angó̤ hé, ‘Nè̤ bè me̤myání̤ nè̤ Byacè Cò́marya to.’” ");
INSERT INTO kyu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bí khǐnéricyá̤ khuklò́ ilo-ilyá pwǒ̤ htuô̌lò̌ hò́ Byacè Jesǔ akhè̌nuô, khǐnéricyá̤ khuklò́ htecuố taphǎkyǎ ná Jesǔ taplô̤phú rò a opò̤́myá pó̤ tuố̤dố ashuốakhè̌ ryá dố a ki ilo khyěthyá lǔ tôphuố. ");
INSERT INTO kyu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Htuô̌rò Byacè Jesǔ ka̤khyě khyěthyá dố Galilea ké̤ rò a lốbǎ ná Thè́ Sǎsè̌ Byacè a tè̤pro̤tè̤prya̤. È ari-akyǎ yěnuô ǔ héso pasǐ luô̌cuốtuố̤ lò̌plǐ dố Galilea ké̤ ná dò̌so ophû tavǐtava̤ bínuô tahe. ");
INSERT INTO kyu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A ithyó pé̤ ǔ dố tè̤cò́bè̌hǒkǔ, rò ǔ htuthè́ní̤ lǔ pwǒ̤꤮ tôprè̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Byacè Jesǔ ka̤khyě dố vǐ̤ Nazarè bí a lé̤duhtya ní̤dyé nuôtôvǐ̤. Bí Judaphú Mò̤́nyěduô akhè̌, phú alé̤klǒ onuô, a cuốnuô̌ dố tè̤cò́bè̌hǒkǔ. Bí a kíré̤ ihtòhố Cò́marya alǎ̤angó̤ akhè̌nuô, ");
INSERT INTO kyu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ǔ dyé lǔ li dố Prè̤pro̤ Isaiah rǎokyǎ dố꤮ nyénu nuôtôba. A htulyěmǒ litalǔ yětôklǔ rò a myáhtye ǔ rǎo li tômǎ̤ dố a hé, ");
INSERT INTO kyu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Cò́marya Thè́ Sǎsè̌ o dố vǎkǔ, me̤těhérò a nwóhtya hò́ vǎ ná vǎ ki héso pé̤ kayǎ sǒphásǒrya̤phú tahe ná tè̤thè́krṳ̂̌mila yěnuô hò́. Kayǎ dố ǔ pṳ̂́ dò́tǎ̤ o lǔ dố htò̌kǔ tahe ki ní̤bè tè̤me̤lwóhteka̤ agně, kayǎ dố a mèthèkhí tahe ki mèthèlǐ ka̤khyě agně, ná kayǎ dố ǔ me̤cyě̤me̤cṳ̂ lǔ tahe ki ní̤bè tè̤me̤lwóhteka̤ agněnuô a nò̌hyǎ hò́ vǎ dố vǎ ki héso pé̤ èthǐ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Htuô̌to Cò́marya nò̌hyǎ vǎ dố vǎ ki hésothè́gně pé̤ ǔ ná Byacè ki me̤lwóhteka̤ ní̤dyé akayǎ nuô ashuốakhè̌ hyǎtuố̤hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Rò Byacè Jesǔ htulǔdwó khyěthyá litalǔ nuôtôklǔ rò a dyéka̤khyědwó khyěthyá dố prè̤myákhwèní̤ tè̤cò́bè̌hǒ nuôtôprè̤ a takhukǔ rò a onyǎtǎ̤. Lò̌꤮ kayǎ o dố tè̤cò́bè̌hǒkǔ nuôtahe myátǎ̤tố̤ lò̌plǐ cò́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Rò Jesǔ hé lahyǎ èthǐ, “Cò́marya alǎ̤angó̤ dố thǐ ní̤huô̌ vǎ hố pé̤ thǐ yětômǎ̤ nuôma a lốhtyabǎhtya cò́ hò́ yětônyě hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lò̌꤮ ǔ ní̤huô̌ tahenuô, ǔ htuthè́ní̤ lò̌plǐ cò́ lǔ pwǒ̤꤮ tôprè̤ cò́, rò a tè̤hébèmo̤ hébèní̤ yěnuô, ǔ khyéthukhyéthè́ lò̌plǐ cò́ rò èthǐ hé lahyǎ, “È ma Joseph aphúprè̤khǔ prè́ vǎhéto?” ");
INSERT INTO kyu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Rò a hésû èthǐ, “Vǎ zṳ̂́e tǎ̤te̤ cò́ ná thǐ ki hékháhékho vǎ ná ngó̤dônyǎ otômû̌ dố a hé, ‘Tè̤khuthárá꤮ zasǐmé̤ ní̤dyédû nè̤né̤ nuô.’ Htuô̌rò thǐ ki hépó̤ vǎ, ‘Tè̤me̤ tè̤pro̤tè̤prya̤ dố pè̤ ní̤huô̌ nè̤ me̤ dố vǐ̤ Capernaum akǔ nuôtahenuô, me̤luô̌ pé̤kuô̌ myá pè̤ bí nè̤ duhtya ní̤dyé vǐ̤yě tôvǐ̤ akǔyě nuô̌꤮’” phúnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Rò Jesǔ hé pó̤, “Vǎ hécò́cò́ thǐ꤮, Cò́marya aprè̤pro̤ bítě꤮ tôprè̤ bèbè, adò̌kǔphú ní̤dû è́sû ní̤dyékuô̌ lǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Vǎ hécò́cò́ thǐ꤮ dố Prè̤pro̤ Elia ahtû̌khè̌ nuô, nakla thuô̌na ná tôkwo rò ké̤vǐ̤ké̤kò̌ cyě̤cṳ̂ ohtya dố Israelké̤ tôké̤lè̤̌ cò́. Bínuô htû̌khè̌, dố Israel ké̤kǔ nuô, prè̤mòokryá oè́ kú꤮ lǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Manárò Cò́marya nò̌cuố tǒ Prè̤pro̤ Elia dố prè̤mòokryá nuôtahe a o tôprè̤꤮ to. Cò́marya nò̌cuố tǒ prè́ lǔ dố prè̤mòokryá dố a o dố vǐ̤ Zarepha, Sidoké̤kǔ nuôtôprè̤ a o prè́. ");
INSERT INTO kyu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Htuô̌rò, dố Israel ké̤kǔ, bí Prè̤pro̤ Elizeo htû̌khè̌nuô kayǎ ní̤bè tè̤sè̌mǔmyá̤ dố phálo̤ tahenuô a o è́nyacò́ tadû́rò Cò́marya zasǐmé̤ pé̤ èthǐ tôprè̤꤮ to, a zasǐmé̤ pé̤ tû́prè́ Syria ké̤phú Naama tôprè̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Rò lò̌꤮ kayǎ o bí tè̤cò́bè̌hǒkǔ nuôtahe ní̤huô̌ Jesǔ hébè yětahe akhè̌nuô, èthǐ thè́plòdu lǔ kanó̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Èthǐ ihtò rò cwihtecuốkyǎ Jesǔ dố vǐ̤klò̌, rò èthǐ cwihtya lǔ dố èthǐ lé̤oní̤dyé vǐ̤ solo̤ lá̤taprǐ tôpho. Rò èthǐ tane̤ lě shyalatǎ̤kyǎ lǔ dố solè̤̌, ");
INSERT INTO kyu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","manárò a htecuốkyǎ bí kayǎ bè́klò́bè́mṳ nuôtahe aklǎměkǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesǔ cuố dố vǐ̤ Capernaum dố a o bí Galilea ké̤kǔ yěnuô rò bí Judaphú Mò̤́nyěduô akhè̌nuô, a ithyóithya pé̤ ǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A tè̤ithyóithya yěnuô a o ná a taryěshyosò̌ akhu-akhyě, kayǎ khyéthukhyéthè́ è́nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dố tè̤cò́bè̌hǒ akǔnuô, khǐné mǔmyá̤ricyá̤ tôduô̌ me̤bè kayǎphè̌ otôprè̤ rò a cyé̤pryě̤ è́htǒè́mo̤htya, ");
INSERT INTO kyu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kố꤮ vǐ̤ Nazarèphú Jesǔ꤮, nè̤ thè́zṳ̂́ me̤ pè̤ phútě? Nè̤ kíré̤ hyǎ me̤pyéme̤kyǎ me̤thyěme̤mé̤ kyǎlò̌hò́ pè̤ pǎ è̌? Nè̤ ma ǔpě nuôma vǎ thè́gně prè́, nè̤ ma Cò́marya aphúkhǔ sǎsè̌ tôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesǔ thè́prwǒ̤ sû khǐnékhǐnò̌, “Thuôthuô꤮ o lahyǎ, htecuốkyǎmò̌ dố kayǎphè̌ yětôprè̤ akǔnuô.” Rò khǐnékhǐnò̌ me̤lakhû́ tǎ̤kyǎ kayǎphè̌ yětôprè̤ dố èthǐ mèthènyě rò a htecuốkyǎ dố lǔkǔ tadû́rò a me̤ bèsè̌ ní̤ná lǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Èthǐ khyéthukhyéthè́ lò̌plǐ cò́ rò èthǐ hé ní̤dyé khyělǔ, “A tè̤ithyóithya yětôkuôrò tè̤ithyóithya cò́ phútě tôcôtětě? A hétǎ̤ prè́ angó̤ ná a nò̌htecuốkyǎ prè́ khǐné rò khǐné mǔmyá̤ricyá̤ yětahe htecuốkyǎ cò́cò́.” ");
INSERT INTO kyu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yětôphuốrò Jesǔ mwi̤la yěnuô ǔ hésoluô̌ pasǐcuố lò̌ dố vǐ̤ Capernaum ná dò̌o tavǐtava̤ bínuô tôpho. ");
INSERT INTO kyu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesǔ htecuốkyǎ dố tè̤cò́bè̌hǒkǔ rò a cuố dố Simonè ahi. Simonè a prè̤́prè̤mò thè́swíné̤kṳ́ htyashyo nyacò́ rò èthǐ kwǐthè́zò̤ Jesǔ ná a ki zasǐmé̤ pé̤ lǔ tè̤swí. ");
INSERT INTO kyu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Rò Jesǔ cuố okahtò bí kayǎswí yětôprè̤ alé̤myě khǎshyé rò a hé lǔ, “Nè̤ ki omo̤ ka̤khyě ryákhyěthyá dûní꤮” a hé rò tôphuốtuô̌ atè̤kṳ́ tǎ̤ rò a ihtò me̤-eme̤ǒsû pé̤ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bí mò̤́tǎ̤ akhè̌nuô, kayǎ tahe è́hyǎ lò̌plǐ a khǒbò́thyó dố aswíasè̌ amyěmyě acôcô tahe dố Jesǔ a o rò Jesǔ dyahtya atakhu dố èthǐ alo̤ tôprè̤ htuô̌ tôprè̤ rò a zasǐmé̤kyǎ pé̤ lò̌plǐ èthǐ tè̤swítè̤sè̌ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bí èthǐ è́hyǎ kayǎ yětahe aklè̌nuô, khǐnékhǐnò̌ me̤bè lǔ tahenuô a opatố̤ è́lǎ. Rò a htecuốkyǎ dố kayǎ nuôtahe akǔ rò a è́htǒhtya, “Nè̤ ma Cò́marya aphúprè̤khǔ” phúnuô. Èthǐ yǒ thè́gně lahyǎ ná Jesǔ ma Krístu dố Cò́marya nwóhtya lǔ rò a ki me̤lwóhteka̤ prè̤luhekhuphú nuôtôprè̤ akhu-akhyě, Jesǔ thè́prwǒ̤ èthǐ rò a nò̌hébè èthǐ tômû̌꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bí mò̤́lǐbǔ hò́ akhè̌nuô, Jesǔ o dố vǐ̤kǔ rò a htecuố dố khǎlé̤ dố ǔ o tôprè̤꤮ to tôpho. Kayǎ lṳ̂myápṳ̌ è́nyacò́ lǔ, rò bí èthǐ myáhtye hò́ lǔ akhè̌nuô, a kwǐthè́zò̤ lahyǎ lǔ, htecuố taphǎ khókyǎ tǎ ná pè̤ tǎmé̤ ní꤮, a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Manárò, Jesǔ hésû èthǐ, “Vǎ tǒbè cuố hésodônyǎ luô̌ pé̤kuô̌ kayǎ o dố vǐ̤ aruô tahe ná Cò́marya ahtyěaké̤ a tè̤thè́krṳ̂̌mila ari-akyǎ, me̤těhérò Byacè Cò́marya nò̌hyǎ vǎ ná vǎ kibè me̤ tè̤me̤ yětôcô agně hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Phúnuô akhu-akhyě, a lě hésodônyǎ pé̤ ǔ ná Cò́marya alǎ̤angó̤ dố Judaké̤ tè̤cò́bè̌hǒ nuôtahe akǔ. ");
INSERT INTO kyu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tônyěkhè̌ bí Jesǔ kahtò o dố Gennesaret htyěòduhtû̌ akhè̌nuô, kayǎ tahe thè́zṳ̂́ ní̤huô̌ lahyǎ Cò́marya alǎ̤angó̤ rò a hyǎ tadwítashya ró̤è́ nyacò́ dố Jesǔ a o. ");
INSERT INTO kyu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesǔ myáhtye thòklyě dố ǔ ka̤ báo è dố htyěhtû̌ nyě̤bè. Prè̤me̤-etè̤̌phú tahe htecuốkyǎ dố thòklyěkǔ rò èthǐ cuố ishuôplǐ ní̤dyé lahyǎ a itavǐ. ");
INSERT INTO kyu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesǔ cuốhtyanuô̌ dố Simonè a thòklyěkǔ rò a nò̌khyǎ thò́thû́nuô̌ lǔ thòklyě yěnuô dố htyězǎ̤ taki, htuô̌rò Jesǔ onyǎtǎ̤ dố thòklyěkǔ rò a ithyótǎ̤ kayǎ bè́mṳ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bí a ithyó htuô̌hò́nuô, a hé Simonè, “Khyǎnuô̌ye̤ nè̤ thòklyěyě dố htyězǎ̤nuô. Thyáphú thǐ ki pṳ̂́ní̤ lahyǎ tè̤̌ agněnuôrò, cò̤́tǎ̤ lahyǎ thǐ itavǐ nuôtahe.” ");
INSERT INTO kyu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simonè hésû lǔ, “Thárá, pè̤ cò̤́htuô̌hò́ tôthè̌꤮ tôthè̌ cò́hò́ rò tè̤̌ní̤ tôbè꤮ to, tadû́rò phú nè̤ hénuô vǎ ki cò̤́tǎ̤ pó̤khyě è꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Èthǐ cò̤́tǎ̤ itavǐ rò tè̤̌ní̤ è́nyacò́, a tuố̤ cò́ dố itavǐ phû lazè̤̌kyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Phúnuô akhu-akhyě, èthǐ è́hyǎ pó̤ lahyǎ akhǒ o dố thòklyěkǔ dố aruô tôbè tahe ki hyǎ me̤cwó̤kuô̌ èthǐ. Akhǒ tahe hyǎ me̤cwó̤ kuô̌ èthǐ rò a pṳ̂́nuô̌ lahyǎ tè̤̌ dố thòklyěkǔ rò a bǎ cò́ ná thòklyě nyě̤bè, rò tuố̤ cò́ dố thòklyě yěnyě̤bè phûlacû́ talí cò́. ");
INSERT INTO kyu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bí Simonè Petru myáhtye tè̤me̤-ané̤ phúyě akhè̌, a dángṳ̂lya̤ dố Jesǔ a khǎduôshyé rò a hé, “Byacè, htecuố taphǎkyǎ ná vǎ, vǎ ma kayǎ tè̤thû́tè̤oraphú prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","È ná akhǒ dố a o kuô̌ ná lǔ tahe pṳ̂́ní̤ è́nyacò́ tè̤̌ akhu-akhyě, èthǐ khyéthukhyéthè́ lò̌ lahyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Prè̤me̤ró̤kuô̌ tè̤̌ ná Simonè tahema Zebedeo aphúkhǔ, Jakomo ná Giovanni prè́. Èthǐ ma a khyéthukhyéthè́ kuô̌ nyacò́ cò́. Jesǔ hé Simonè, “Thè́isě tǎmé̤, cáhtya yětônyě tǎ̤plehyǎ, nè̤ ki htwǒhtya kayǎ dố a cuốè́hyǎ ǔ dố Cò́marya a o thyáná nè̤ pṳ̂́tè̤̌ yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Èthǐ báokyǎ thòklyě yětahe dố htyěhtû̌ rò, bekyǎ lò̌lò̌꤮ tè̤ dố a o ná èthǐ nuôtahe htuô̌rò èthǐ krwǒkuô̌ Jesǔ akhyě. Rò èthǐ htwǒhtyakuô̌ Byacè Jesǔ Krístu a khǒpacè̤̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tôphuốkhè̌ bí Jesǔ o dố vǐ̤tôvǐ̤ akhè̌nuô, prè̤bè tè̤sè̌mǔmyá̤ dố phálo̤ o tôprè̤. Bí a myáhtye Jesǔ akhè̌nuô, a dángṳ̂lya̤ dố Jesǔ a khǎduôshyé, rò a kwǐthè́zò̤ lǔ, “Byacè꤮, nè̤ ki thè́plòo zasǐmé̤ pé̤ vǎ tè̤sè̌yě hénuôma nè̤ za cyá̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesǔ zó̤hyǎ atakhu rò a tôbèhtuô̌ lǔ rò a hé lǔ, “Vǎ thè́plòo prè́,” a hé htuô̌rò “Tè̤sè̌꤮ sǐmé̤kyǎmò̌,” a hé pó̤ phúnuô, rò tôphuốtuô̌ tè̤sè̌ sǐmé̤kyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesǔ mekyǎ lǔ ngó̤, “Hésoluô̌ pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮. Cuố dyéluô̌myá nè̤né̤ dố bwídu nuôtôprè̤ a o nuô ní꤮. Htuô̌rò nè̤ tè̤sè̌ sǐmé̤hò́ yěnuô, thyáphú a ki khyáluô̌ pé̤kuô̌ dố kayǎ è́prè̤ a mèthènyě nuôrò lǔtyǎhtya kuô̌ phú Mosè a tè̤mekyǎngó̤ o nuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","A nò̌héluô̌ ǔ tôprè̤꤮ to tadû́rò Byacè Jesǔ ari-akyǎ yěnuô, kayǎ lé héso luô̌pasǐcuố ye̤klò̌ ná a khǎlé̤lye̤ nuô cò́, rò kayǎ tahe thè́zṳ̂́ ní̤huô̌ lahyǎ a tè̤hébè, htuô̌rò a thè́zṳ̂́ nò̌hyǎ zasǐmé̤ lahyǎ a tè̤swítè̤sè̌ rò a hyǎró̤hyǎè́ nyacò́ dố lǔo cò́. ");
INSERT INTO kyu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Manárò Jesǔ htecuốkyǎ tamǒmǒ dố ké̤sè̌htyěkya̤ lò̤́tamákhu rò cuố kwǐcò́bè̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tônyěkhè̌ bí Jesǔ ithyóithyatǎ̤ ǔ akhè̌nuô, Pharisěophú tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe onyǎo kuô̌ lahyǎ bínuô. Èthǐ yětahe nuôma a o lahyǎ hò́ dố lò̌꤮ dò̌ o dố Galilea ké̤kǔ, nuôtahe ná lò̌꤮ dò̌ o dố Juda ké̤kǔ nuôtahe ná dố vǐ̤ Jerusalem akǔnuô hyǎ hò́. Thyáphú Jesǔ ki zasǐmé̤ pé̤ kayǎswíkayǎsè̌ yětahenuôrò Byacè Cò́marya a tè̤pro̤tè̤prya̤ okuô̌ ná lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kayǎ tahe záhyǎ kayǎ thyětôkyě tôprè̤, rò èthǐ záhyǎ sǐhtě ná lé̤myě. Rò thyáphú a ki dyatǎ̤ní̤ lǔ dố Jesǔ a mèthènyě nuôrò, a yácû́ cò̤̌nuô̌ lǔ dố hidò́kǔ. ");
INSERT INTO kyu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Manárò kayǎ yǒ oró̤ talwósû́lû̌ akhu-akhyě, èthǐ zánuô̌ cyá̤ pǎto. Phúnuôrò èthǐ záhtya lǔ dố hikhuklwó tabyekhu rò htyame̤plǒ lahyǎ hikhuklwó rò cya̤tǎ̤ sǐhtělò̌ lé̤myěmyě kayǎyǎ dố kayǎ tôplutôphè aklǎměkǔ dố Jesǔ anyěhyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bí Jesǔ myáhtye èthǐ atè̤zṳ̂́sò̌ nyacò́ akhè̌nuô, a hé kayǎ swí nuôtôprè̤, “Khǒbò́thyó꤮ vǎ plwǒkyǎ hò́ nè̤ tè̤thû́tè̤ora tahe hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Prè̤ithyó tè̤thyótè̤thya athárá tahe ná Pharisěophú tahe hé ní̤dyé khyělǔ, “Kayǎ yětôprè̤ hébèthû́ hò́ Cò́marya hò́. Ǔpě tôprè̤ ki plwǒkyǎ cyá̤ tè̤thû́ pě? Prè̤ plwǒkyǎ cyá̤ tè̤thû́ ma tû́prè́ Cò́marya tôprè̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesǔ thè́gně èthǐ hé ní̤dyé khyělǔ yětahe rò a sudyǎ èthǐ, “Thǐ cuốtane̤ tuố̤ lahyǎ dố thǐ thè́plòkǔ phúnuôma me̤tě? ");
INSERT INTO kyu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ki hé, ‘Plwǒkyǎhò́ nè̤ tè̤thû́tè̤ora hò́,’ má̤torò ‘Kahtò rò cuốmò̌,’ kihéma bítě tôcô azǔklò̌? ");
INSERT INTO kyu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Manárò prè̤lukayǎ aphúkhǔ má̤ vǎyě, thyáphú thǐ ki thè́gně lahyǎ, dố hekhu yěnuô, vǎ o ná taryěshyosò̌ dố vǎ plwǒkyǎbè́ ǔ tè̤thû́tè̤plá tahenuôrò, vǎ ki dyéluô̌ pé̤ thǐ,” a héhtuô̌ phúnuô rò a hé prè̤thyětôkyě yětôprè̤, “Vǎ hé nè̤, ihtò talǔní̤ nè̤ klolé̤myě nuôrò ka̤mò̌ dố nè̤ hinuô.” ");
INSERT INTO kyu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tôphuốtuô̌ kayǎphè̌ nuôtôprè̤ ihtò talǔní̤ a klolé̤myě dố kayǎ tôplutôphè anyěhyǎ rò hteka̤kyǎ dố ahi rò a htuthè́htya Cò́marya. ");
INSERT INTO kyu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ǔ khyéthukhyéthè́ lò̌plǐ cò́ pwǒ̤꤮ prè̤ cò́. Rò èthǐ htuthè́htya lahyǎ Cò́marya rò a hé lahyǎ, “Yětônyě, pè̤ myáhtyehò́ tè̤pro̤tè̤prya̤ tahe hò́!” ");
INSERT INTO kyu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A me̤htuô̌ phúnuô rò, Jesǔ htecuốkyǎ, rò a cuốmyáhtye ná prè̤kwǐe amo-arǎ tôprè̤ dố amwi̤ ná Levi. Rò a onyǎo dố lé̤kwǐ amo-arǎ hikǔ. Rò Jesǔ hé lǔ, “Krwǒkuô̌ vǎkhyě rò htwǒ kuô̌ vǎ khǒpacè̤̌.” ");
INSERT INTO kyu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi kahtò rò dyakyǎ lò̌lò̌꤮ tè̤ dố a o ná lǔ nuôtahe rò a krwǒcuốkuô̌ Jesǔ akhyě. ");
INSERT INTO kyu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yětôphuốrò, Levi me̤ní̤ pwè̌du tôpwè̌ dố ahi, rò a me̤pwè̌ pé̤ Jesǔgně prè́. Rò a mehyǎní̤ akhǒathyó dố a kwǐ amo-arǎ tahe ná sǐpré̤sǐmya̤ dố aruôtahe, rò a hyǎepluhyǎephè kuô̌ lò̌ ná lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pharisěophú tahe ná prè̤ithyó tè̤thyótè̤thya athárá dố èthǐ aplò́amṳkǔ tahe dya lò̌ tè̤thû́ dố Byacè Jesǔ a khǒpacè̤̌ tahe akhu rò a hé, “Thǐ cuố etố̤ǒtố̤kuô̌ ná prè̤kwǐamo-arǎ tahe ná prè̤oraphú nuôtahe me̤tě?” Èthǐ sudyǎ lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesǔ hésû èthǐ, “Kayǎ dố a oshyo-opryǎ tahenuô a lo ná tè̤khuthárádu to. Kayǎ dố aswíasè̌ tahenuô tû́ma a lo prè́ tè̤khuthárádu prè́. ");
INSERT INTO kyu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Vǎ hyǎ è́ka̤ kayǎ dố acò́ate̤ nuôtahe má̤to. Thyáphú prè̤oraphú tahe ki za̤ ní̤dû lahyǎ ané̤ nuôrò, vǎ hyǎ è́ka̤ èthǐ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pharisěophú tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe hé Jesǔ, “Giovanni a khǒpacè̤̌ tahe ná Pharisěophú a khǒpacè̤̌ tahe duôe sèesèǒ rò kwǐcò́bè̌ tamǒtamǒ cò́ tadû́rò nè̤ khǒpacè̤̌ taherò a duôeduôǒ kuô̌ǔ to vǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Byacè Jesǔ hésû èthǐ ná ngó̤khákho tômû̌ rò a hé, “Bí khǒmè̤̌khǔphè̌ otố̤kuô̌pǎ ná akhǒ sǐpré̤sǐmya̤ akhè̌nuô, ǔ nò̌ duôeduôǒ cyá̤nyǎ sǐpré̤sǐmya̤ tahe sè è̌? ");
INSERT INTO kyu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tônyěnyě pǎnuô ǔ ki è́cuố taphǎkyǎ khǒmè̤̌khǔphè̌ pǎ. Bínuôakhè̌ pǎma èthǐ ki duôeduôǒ lahyǎ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesǔ hé pé̤ pó̤ èthǐ ná ngó̤khákho tôtó̤ rò a hé, “Ǔ htò́zè̤̌ ca̤thè̌ rò ǔ isè́phèbí ná ca̤lye̤ nuô a o tôprè̤꤮ to. Ki me̤phúnuô hérò ca̤thè̌yěnuô a ki lazè̤̌pyékyǎ pǎ, htuô̌to ikè̤̌thè̌ ná ikè̤̌lye̤ yěnuô arè̤̌thò́rè̤̌htyě pǎ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ǔ zṳ̂nuô̌ thòbǐthèhtyězǎ̤thè dố htyěǒphálye̤kǔ nuô a o tôprè̤꤮ to. Ǔ ki zṳ̂nuô̌ phúnuô hérò htyězǎ̤thè̌ yěnuô a ki thè̌phè́kyǎ htyěǒphálye̤ yětômě pǎ, rò htyězǎ̤ ki lakuố̤kyǎ lò̌ pǎ, rò htyěǒ ki phè́pyékyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ǔ tǒbè zṳ̂nuô̌ prè́ htyězǎ̤thè̌ dố htyěǒpháthè̌ akǔ prè́꤮. ");
INSERT INTO kyu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Htuô̌rò kayǎ dố a ǒnò́ htuô̌hò́ htyězǎ̤lye̤ tahenuô a thè́zṳ̂́ ǒ pǎ htyězǎ̤thè̌ tôprè̤꤮ to. ‘Htyězǎ̤lye̤ nuô a viklò̌ ná athè̌,’ a hé pé̤ èthǐ phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bí Judaphú Mò̤́nyěduô tônyě khè̌nuô, Jesǔ ná a khǒpacè̤̌ tahe htecuốklyá rò cuốnuô̌cuốbè́ ǔ buốkǔlǎ prè́lé̤khu tahe. Rò a khǒpacè̤̌ tahe prá lahyǎ ǔ buốkǔlǎ plyǎ̤ rò ithǐplǐkyǎ lò̌ buốkǔlǎphá rò a e lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Rò Pharisěophú tahe sudyǎ, “Cò́marya tè̤thyótè̤thya hé ná Judaphú a Mò̤́nyěduô yěnuô, tè̤me̤ dố thǐ tǒbè me̤ní̤ to tahenuô, thǐ cuốme̤dû lahyǎ thǐgně phúnuô me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesǔ hésû èthǐ, “Bí Davi ná a khǒbò́thyó tahe ladyáeladyáǒ akhè̌nuô, a me̤kryá꤮ ǐtětě nuôma thǐ hốnò́ kuô̌nyǎ ǔ to è̌? ");
INSERT INTO kyu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Èthǐ cuốnuô̌ lahyǎ dố Cò́marya ahikǔ rò a phyée khò́mǔ dố ǔ lǔhtya ná Cò́marya nuôtahe, khò́mǔ yětahe nuôma ení̤ prè́tû́ prè̤lǔtyǎtè̤phú tahe prè́ tadû́rò Davi ná a khǒpacè̤̌ tahe cuốnuô̌phyée vǎhéto?” ");
INSERT INTO kyu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Rò Jesǔ hé pé̤ pó̤ èthǐ, “Prè̤lukayǎ aphúkhǔ má̤dû vǎ yěnuôma Mò̤́nyěduô a Byacè tôprè̤hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bí Judaphú a Mò̤́nyěduô dố aruô tônyě kenuô, Jesǔ cuốnuô̌ dố tè̤cò́bè̌hǒkǔ rò cuốnuô̌ ithyóithyaní̤ ǔ bínuô. Bí tè̤cò́bè̌ hǒkǔnuô kayǎphè̌ takhuthyě dố cò́htwó tôkhó o tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Prè̤ithyó tè̤thyótè̤thya athárá tahe ná Pharisěophú tahe myápṳ̌ lahyǎ tè̤ritè̤kyǎ tôcôcô dố a ki pṳ̂́ní̤ lahyǎ Byacè Jesǔ a tè̤thû́. Phúnuô akhu-akhyě èthǐ opò̤́myá lahyǎ ná Judaphú a Mò̤́nyěduô yěnuôma a zasǐmé̤ pé̤ ǔtè̤sè̌ pǎ è̌, ma to è̌, phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Manárò Jesǔ thè́gně èthǐ atè̤tane̤ tahe akhu-akhyě a hé kayǎ takhuthyě tôkhó yětôprè̤, “Hyǎihtòo dố ǔ klǎměkǔyě,” rò kayǎ nuôtôprè̤ hyǎihtòo bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Phúnuôhtuô̌rò Jesǔ hé èthǐ, “Vǎ sudyǎ pó̤ thǐ ngó̤ tômû̌, pè̤ tè̤thyótè̤thya hé pè̤ ná bí Judaphú a Mò̤́nyěduô akhè̌nuôma, pè̤ tǒbè me̤ cwó̤ ǔ è̌? Má̤torò pè̤ tǒbè me̤pyá̤me̤sè̌ ǔ è̌? Pè̤ tǒbè me̤lwóhteka̤ kayǎ tôprè̤prè̤ athè́plò htwǒprè̤ è̌? Má̤toma pè̤ tǒbè me̤pyéme̤kyǎ ǔ è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A myá tarítava̤ htuô̌lò̌ èthǐ rò a hé kayǎ takhuthyě tôkhó yětôprè̤, “Zó̤hte nè̤ takhunuô,” rò a krwǒme̤ kuô̌phú Jesǔ hé lǔ nuô, rò atakhu ryáka̤khyě plû́lò̌ khyěthyá. ");
INSERT INTO kyu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Manárò prè̤ithyó tè̤thyótè̤thya athárá tahe ná Pharisěophú tahe thè́plòdu nyacò́ Byacè rò èthǐ tǒbè me̤ Jesǔ phútěnuô, èthǐ cuố okú hébè ní̤dyé lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bínuôhtuô̌rò, Jesǔ kíré̤ cuố kwǐcò́bè̌ rò a cuốhtya dố solo̤. Rò a cuố kwǐcò́bè̌htya Cò́marya bínuô tôthè̌꤮ tôthè̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bí mò̤́lǐbǔ hò́ akhè̌nuô, a è́hyǎplò́ lò̌ a khǒpacè̤̌ tahe dố a o, rò a nwóhtya kayǎ shyéthè́nyě̤ dố èthǐ aklè̌, rò èthǐ shyéthè́nyě̤ yěnuô, a è́ní̤ pé̤ lǔmwi̤ ná prè̤dônyǎphú tahe. ");
INSERT INTO kyu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simonè (Dố Jesǔ è́ pé̤ pó̤ lǔmwi̤ ná Petru) ná apuố̤ Andrea, Jakomo ná Giovanni, Philipu ná Bartholomeo, ");
INSERT INTO kyu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matteo ná Thomazo, Alphaeo aphúkhǔ Jakomo, ná Simonè (A yǒ mo̤ní̤ ahtyěaké̤ rò a o dố Zeloto aplò́amṳkǔ rò ǔ è́ lǔ ná Zelotophú.) ");
INSERT INTO kyu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jakomo aphúkhǔ Juda, ná Juda Iscariot dố a htwǒhtya prè̤isè̌tǎ̤kyǎ Jesǔ nuôtôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesǔ ná a khǒpacè̤̌ tahe o dố sokhu hítǎ̤ rò a tǎ̤kahtò o lahyǎ bí ké̤pě̤khu tôpho. A khǒpacè̤̌ dố aruô tôplutôphè ná kayǎ o dố Judaké̤ sǐké̤lò̌ tahe ná dố vǐ̤ Jerusalem akǔ ná vǐ̤ Tyrephú ná vǐ̤ Sidophú dố a o dố htyědutava̤htû̌ tahe hyǎ opò̤́plu-opò̤́phè ré̤ lò̌plǐ dû hò́ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Èthǐ thè́zṳ̂́ ní̤huô̌ lahyǎ Jesǔ a tè̤hébèdônyǎ htuô̌to a thè́zṳ̂́ nò̌zasǐmé̤ lahyǎ Jesǔ ná a tè̤swítè̤sè̌ rò a hyǎ lahyǎ prè́. Jesǔ vè̤́htekyǎ pé̤ kayǎ dố khǐnékhǐnò̌ me̤bè lǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kayǎ pwǒ̤prè̤ pṳ̌ tôbè lò̌ lǔ, me̤těhérò tè̤pro̤tè̤prya̤ o dố lǔné̤lo̤ hte rò a zasǐmé̤ pé̤ lò̌plǐ cò́ ǔ tè̤swítè̤sè̌ pwǒ̤꤮ prè̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesǔ myátǎ̤tǎ̤꤮ dố a khǒpacè̤̌ tahe rò a hé èthǐ, “Thǐ dố a sǒphásǒrya̤ yětahenuô, Cò́marya ki sò̌ri má̤lakǒ cò́ thǐ hò́, me̤těhérò Cò́marya htyělé̤ké̤kǔ nuôma kayǎ phúnuôtahe atè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Thǐ dố a thè́vǐ̤thè́e khǒnyá̤ yětahenuô, Cò́marya ki sò̌ri má̤lakǒ cò́ thǐ hò́, me̤těhérò Cò́marya ki dyé ekò́ǒbǎ thǐ pǎ! Thǐ dố a nguố̤hè khǒnyá̤ yětahenuô, Cò́marya ki sò̌ri má̤lakǒ cò́ thǐ hò́, me̤těhérò thǐ ki nyě̤hǎnò́ pǎ! ");
INSERT INTO kyu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Thǐ yǒ zṳ̂́e prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě akhu-akhyě rò ǔ thè́hte thǐ, ǔ è́mo̤sû thǐ to, ǔ pacyé̤ishyé thǐ rò ǔ hé mǔmyá̤ricyá̤ thǐ akhu-akhyě, thǐ ki ní̤bè má̤lakǒ cò́hò́ tè̤sò̌ri hò́. ");
INSERT INTO kyu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Me̤těhérò èthǐ aphyěaphuô̌ dố꤮ nyénu tahenuô, a me̤cyě̤me̤cṳ̂ htuô̌lò̌hò́ prè̤pro̤ tahe phúnuô hò́. Bí thǐ myáhtye bèhò́ phúnuô pǎ akhè̌nuô, thè́krṳ̂̌thè́lò̌ lahyǎ ní꤮. Thè́lò̌thè́lya̤ rò pá̤ilě lahyǎ ní꤮, me̤těhérò dố thǐgněnuô, Cò́marya dya-one pé̤hò́ thǐ tè̤me̤ní̤khwókè dố mò́khu nuô adu lakálakǒ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Manárò thǐ dố a duzá̤htyathè̌ lahyǎ yětôhtû̌ tahe thǐ, thǐ yǒ ohtwǒprè̤nò́ lahyǎ hò́ dố tè̤ aphwǐamo̤ akǔ hò́ akhu-akhyě, tè̤cyě̤tè̤cṳ̂ ki hyǎbè má̤lakǒ cò́ thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Thǐ dố a ekò́ǒbǎ lahyǎ khǒnyá̤yě tahe thǐ꤮, tè̤cyě̤tè̤cṳ̂ ki bè má̤lakǒ cò́ nyǎ thǐ pǎ, thǐ ki ovǐ̤okò̌ kuô̌ke pǎ! Thǐ dố a nyě̤hǎtakǎ̤nò́ khǒnyá̤yě tahe thǐ, tè̤cyě̤tè̤cṳ̂ ki hyǎbè má̤lakǒ cò́ thǐ pǎ, me̤těhérò shuốkhè̌ ki hyǎtuố̤ dố thǐ ki thè́plè̤̌nebè rò kinguố̤kihè kuô̌ke pǎ! ");
INSERT INTO kyu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Thǐ dố kayǎ pwǒ̤prè̤ htuthè́ ní̤dyé hò́ thǐ yětahenuô, thǐ ki ní̤bè má̤lakǒ cò́ tè̤cyě̤tè̤cṳ̂ pǎ, me̤těhérò thǐphyěthǐphuô̌ dố꤮ nyénu tahenuô a htuthè́ ní̤dyé htuô̌dûhò́ prè̤pro̤lahǒ prè̤pro̤lahya tahe phúnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Manárò thǐ ki thè́zṳ̂́ ní̤dǎ hérò vǎ thè́zṳ̂́ hésoní̤ pé̤ thǐ tè̤tahe, mo̤ní̤ lahyǎ kayǎ dố a thè́hte thǐ nuôtahe rò me̤ryásû kayǎ dố a thè́hte thǐ nuôtahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sò̌riní̤ kayǎ dố a isò̌ thǐ nuôtahe, rò kwǐcò́bè̌ pé̤ kayǎ dố a me̤ mǔmyá̤ricyá̤ thǐ nuôtahe agně ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kayǎ tôprè̤prè̤ ki plyá̤ nè̤ khǎlí̤shyé kihérò dyé plyá̤ pó̤ è dố a okyǎ nuôtôkyě ní꤮. Kayǎ tôprè̤prè̤ ki phyéphe nè̤ ca̤klò̌ kihérò, nò̌phyécuốní̤ pó̤ è ná nè̤ca̤ dố akǔ nuôtôpṳ̂ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ǔpěpě꤮ bèbè ki a kwǐ nè̤tè̤ tôcôcô hérò dyépé̤ è rò bí kayǎ tôprè̤prè̤ phyé nè̤tè̤ tôcôcô akhè̌nuô, kwǐ ka̤khyě tǎ è tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Me̤pé̤ ǔ phú thǐ thè́zṳ̂́ nò̌me̤ ǔ ná thǐné̤ nuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Thǐ ki mo̤ní̤ prè́tû́ kayǎ dố a mo̤ní̤ thǐ nuôtahe prè́ kihérò ǔ htuthè́ní̤ ná thǐ tôprè̤꤮ to. Kayǎ tè̤thû́tè̤oraphú prè́ tahe rò a mo̤ ka̤khyěsû thyákuô̌dû kayǎ dố a mo̤ní̤ lǔ nuôtahe phúnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Rò thǐ ki me̤ryá tû́prè́ kayǎ dố a me̤ryá thǐ nuôtahe prè́ kihérò ǔ htuthè́ní̤ ná thǐ tôprè̤꤮ to. Kayǎ tè̤thû́tè̤oraphú prè́ tahe rò a me̤ryá ka̤khyěsû thyákuô̌ dû kayǎ dố a me̤ryá èthǐ nuôtahe phúnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Rò thǐ ki dyébò tû́prè́ thǐ tǎ̤tè̤ ná kayǎ dố thǐ myásû̌ dố thǐ ki ní̤bè ka̤khyě khyěthyá thǐ tǎ̤tè̤ dố a o nuôtahe prè́ kihérò ǔ htuthè́ní̤ ná thǐ tôprè̤꤮ to. Kayǎ tè̤thû́tè̤oraphú prè́ tahe꤮ rò a dyébò pé̤ atǎ̤tè̤ ná prè̤oraphú dố èthǐ myásû̌ ná a ki dyé ka̤khyě bè́ bǎ khyěthyá lǔ pǎnuô tahe a o, thyákuô̌dû phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tǒbè me̤ní̤ phúnuô to! Mo̤ní̤ kayǎ dố a thè́hte thǐ nuôtahe rò me̤ryá èthǐ nuô. Dyébò tè̤ rò myásû̌ ní̤bè ka̤khyě tǎ tè̤tôcô꤮ tǎmé̤. Thǐ ki me̤phúnuô hérò Cò́marya ki sò̌risò̌bǔ tǎ̤pòtǎ̤pè̤̌ cò́ thǐ pǎ, thǐ ki dyébò ǔ rò thǐ ki myásû̌ ní̤bè ka̤khyě khyěthyá tè̤ tôcô꤮ to hénuôma ǔ ki myáhtye thǐ ná tè̤htǔtadû Cò́marya aphúmòphúkhǔ thǐtahe pǎ, me̤těhérò Cò́marya me̤ryásû kayǎ dố a thè́gně sû kuô̌ ǔbwíǔtaryě to nuôtahe ná kayǎ dố acyě̤aricyá̤ dûgně nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Thǐ bè thè́zò̤ní̤ kuô̌ǔ phú thǐ Phè̌ Cò́marya thè́zò̤ní̤ ǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Hébò̌hébye ǔ, tane̤thû́bò̌tane̤thû́bye tǎ ǔ tǎmé̤. Thǐ ki hébò̌hébye ǔ, tane̤thû́bò̌tane̤thû́bye ǔ to hénuôma Cò́marya me̤lyě̤ ka̤khyěsû thǐ to. Betè̤thû́ tǎ ǔ tǎmé̤, tû́ma Cò́marya betè̤thû́ thǐ to. Plwǒkyǎ ǔtè̤thû́ ní꤮, tû́ma Cò́marya plwǒkyǎ thǐ tè̤thû́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dyépé̤ ǔ, tû́ma Cò́marya ki dyé pé̤ kuô̌ke thǐ pǎ. Cò́marya ki ruô̤̌ laklya̤ rò tò̤́bǎ cǒmǒ tǎ̤pòtǎ̤pè̤̌ sûpé̤ cò́ thǐ pǎ, me̤těhérò, Cò́marya ki tò̤́sû pé̤ thǐ phú thǐ tò̤́ pé̤ ǔ nuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Htuô̌rò Jesǔ hé pé̤ èthǐ ná ngó̤khákho tômû̌, rò a hé pé̤ èthǐ, “Kayǎ mèthèkhí tôprè̤nuô a thǔcuố cyá̤ pé̤ kayǎ mèthèkhí dố aruôtôprè̤ klyá to. Ki a thǔ hérò èthǐ ki latǎ̤lò̌ dố hekǔ thè́nyě̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Khǒpacè̤̌nuô acyá̤adè lốklò̌ ná athárá takhyá꤮ to. Manárò, khǒpacè̤̌ tôprè̤prè̤ dố a ithyó plû́htuô̌ lò̌hò́ dố athárá o tôprè̤nuô a ki cyá̤ thyáná athárá nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Amûamá oprè́ dố thǐ puố̤vyá̤ prè̤zṳ̂́etè̤phú tôprè̤ a mèthèplòkǔ prè́ rò thǐ myáhtye, manárò thòklò̤́ o cò́ dố thǐ mèthèplòkǔ cò́ rò, thǐ myáhtye ní̤dyé kuô̌ǔ to me̤tě? ");
INSERT INTO kyu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Thǐ cuốhétuố̤ thǐ puố̤vyá̤, ‘Puố̤vyá̤꤮ vǎ takhwó htekyǎ pé̤ré̤ nè̤ amûamá o dố nè̤ mèthèplòkǔ yěnuô,’ thǐ hé phúnuô tadû́rò thòklò̤́ o cò́ dố thǐ mèthèplòkǔ cò́rò thǐ myáhtye ní̤dyé è to. Thǐ cuốhé ǔ phúnuô ma aní̤ to. Prè̤ cyé̤zò́cò́te̤ ané̤ thǐ꤮ phyéhtekyǎ ré̤lố thòklò̤́ o dố thǐ mèthèplòkǔ nuô, tû́rò thǐ myáhtyeluô̌ryá rò thǐ takhwó htekyǎ cyá̤ pé̤ amûamá o dố thǐ puố̤vyá̤ a mèthèplòkǔ yěnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Thòryá tômò̤́nuô athèhte thòthè dố aryáto nuô a oto. Phúnuôhò́ thòryáto tômò̤́nuô athèhte cyá̤ thòthèryá to. ");
INSERT INTO kyu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Lè́lè́꤮ nè̤ myáprè́ athè nuô̌꤮ nè̤ thè́gněcyá̤prè́ amò̤́ prè́. Ǔ cuốba-e kadwíthè dố thòshyámò̤́ alo̤ tôprè̤꤮ to. Phúnuôhò́ ǔ cuốba-e thòbǐthè dố cǎcuố̤cǎprya̤lo̤ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kayǎryá tôprè̤nuô a hébèhte prè́ tè̤ryá o dố lǔ thè́plòkǔ nuôtahe prè́. Kayǎcyě̤ricyá̤ tôprè̤nuô, a hébèhte prè́ tè̤mǔmyá̤ricyá̤ o dố lǔ thè́plòkǔ nuôtahe prè́. Kayǎ nuô a thè́plòkǔ obǎ tǎ̤pòtǎ̤pè̤̌ phútěrò akhǎu krwǒ hébèhte kuô̌ phúnuôprè́. ");
INSERT INTO kyu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Tômû̌꤮ thǐ ní̤dǎ vǎngó̤ to rò thǐ cuố è́tuố̤ vǎ ná ‘Byacè꤮ Byacè,’ phúnuôma me̤tě? ");
INSERT INTO kyu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Vǎ ki zṳ̌luô̌ pé̤ thǐ ná lò̌꤮ kayǎ dố a hyǎ dố vǎ o rò a ní̤huô̌ vǎlǎ̤vǎngó̤, rò a ní̤dǎ krwǒme̤kuô̌ tahenuô athyáná ǐtě hénuôma, ");
INSERT INTO kyu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","a thyáhò́ná kayǎ dố a isò́htya hi rò, a ikhûtǎ̤ zǎ̤zǎ̤ hekǔ rò a byá hikhǎshyé ná lò̤́ yěnuô tôprè̤ hò́. Htyěduhtya, htyělyá̤htyěkhǒ hyǎsábè hiyě tômě tadû́rò ǔ yǒ isò́lya̤ klò̤maryá è dố lò̤́lo̤ akhu-akhyě, a kazuô̤̌ pé̤to. ");
INSERT INTO kyu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Manárò kayǎ tôprè̤prè̤ dố a ní̤huô̌ vǎlǎ̤vǎngó̤ rò a ní̤dǎ krwǒme̤kuô̌ to tôprè̤nuô, athyáná kayǎ dố a isò́htya ahi rò a byáma kuô̌ akhǎshyé ná lò̤́ to tôprè̤ nuôhò́. Bí htyěduhtya, htyělyá̤htyěkhǒ hyǎsábè hiyě tômě akhè̌nuô, tôphuốtuô̌ a latǎ̤prò̤kyǎ rò a lakè̤́lamûkyǎ lò̌ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bí Jesǔ hé pé̤ htuô̌lò̌ hò́ ǔ ná lò̌꤮ tè̤yětahe akhè̌nuô, a ka̤khyě dố vǐ̤ Capernaum. ");
INSERT INTO kyu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Bí vǐ̤kǔnuô Roma klyěkhuklò́ o tôprè̤, rò alulé phè̌tôprè̤ dố a mo̤ní̤ nyacò́ lǔnuô, a swí rò a phû kíré̤ thyětalí lǎ cò́ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bí klyěkhuklò́ yětôprè̤ ní̤huô̌ Jesǔ ari-akyǎ akhè̌nuô, a nò̌cuố Juda muố̤prû̌muố̤prè̤́ dố a htwǒ khuklò́khuklyǎ tahe dố Jesǔ a o rò a nò̌cuốkwǐthè́zò̤ lǔ ná a ki hyǎ zasǐmé̤ pé̤ lǔ lulé yětôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bí èthǐ cuốtuố̤hò́ dố Jesǔ o akhè̌nuô, a kwǐthè́zò̤ tadû cò́ Jesǔ, “Nè̤ ki me̤cwó̤ klyěkhuklò́ yětôprè̤ hénuôma a kò prè́. ");
INSERT INTO kyu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Me̤těhérò a mo̤ní̤ pè̤ myěcôphú tahe, rò a isò́htya pé̤ pè̤ tè̤cò́bè̌hǒ tômě cò́ ni,” ");
INSERT INTO kyu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","rò Jesǔ krwǒcuốkuô̌ èthǐ. Bí a cuốtuố̤ phû larò̌lare hò́ ná ahi akhè̌nuô, klyěkhuklò́ nuôtôprè̤ nò̌cuốsû a khǒbò́thyó tahe dố Byacè a o rò a nò̌cuốhé èthǐ, “Byacè꤮, hyǎ thè́práthè́tuô̤̌, sǒrya̤sǒphá tǎ nè̤né̤ tǎmé̤, nè̤ hyǎnuô̌prè́ dố vǎ hikǔnuô vǎ kò ná nè̤ to. ");
INSERT INTO kyu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Htuô̌to vǎ tane̤lya̤ ní̤dyé vǎné̤ ná vǎ hyǎmyáhtyesû prè́ nè̤ nuô vǎ kò ná nè̤ to. Manárò hétǎ̤ prè́ nè̤ngó̤ tômû̌ nuôma, vǎlulé tè̤swí klyá omo̤ka̤ nyǎ dû hò́. ");
INSERT INTO kyu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mame̤těrò vǎ hé phúyě hénuôma vǎ né̤byacè ní̤dû vǎ bè ní̤dǎ kayǎ dố aduklò̌ ná vǎ tahe angó̤. Phúnuôhò́ klyěphú dố a o dố vǎlè̤̌ tahenuô a bè ní̤dǎkuô̌dû vǎngó̤ phúnuônuô. Ki vǎ hé klyěphú tôprè̤prè̤, ‘cuốmò̌,’ hénuôma a bècuố prè́, ki vǎ hé ke dố aruôtôprè̤, ‘hyǎmò̌,’ hénuôma a bè hyǎ prè́. Htuô̌to vǎ ki hé vǎcṳ̂́, ‘me̤mò̌yě,’ hénuôma a bè me̤ prè́, klyěkhuklò́ nò̌hyǎ hé pè̤ phúyě.” ");
INSERT INTO kyu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bí Jesǔ ní̤huô̌ a hé phúyě akhè̌nuô, a khyéthukhyéthè́ cò́. A tarítǒ ka̤khyě ané̤ dố kayǎ krwǒkuô̌ lǔkhyě tahe a o rò a hé kayǎ bè́mṳ yětahe, “Vǎ hé pé̤ thǐ, tè̤zṳ̂́ phúyě nuô, vǎ myáhtyenò́ hí tôphuố꤮ to. Dố Israelphú tahe aklè̌ cò́bèbè, vǎ myáhtyenò́ hí tè̤zṳ̂́sò̌ phúyěnuô híto.” ");
INSERT INTO kyu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bí klyěkhuklò́ akhǒ yětahe ka̤tuố̤ dố klyěkhuklò́ yětôprè̤ ahi akhè̌nuô, èthǐ myáhtye ná alulé swí yětôprè̤ omo̤-oryá ka̤khyě khyěthyá hò́. ");
INSERT INTO kyu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nyě̤tyatorò, Jesǔ cuố dố vǐ̤ Nain rò a khǒpacè̤̌ tahe ná kayǎ bè́mṳ tahe krwǒcuốplu krwǒcuốphè kuô̌lò̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bí a kíré̤ cuốtuố̤hò́ dố vǐ̤ kadǎhtû̌ akhè̌nuô, a cuố tǎ̤sû ná kayǎ tômṳ záhyǎ iluốluô̤̌. Luô̤̌ tato̤ yěnuôma má̤dû prè̤mò dố a okryá tû́dû ná a phúprè̤khǔ nuôtôprè̤ thyěkyǎ phe lǔ khǎlé̤. Kayǎ dò̌phúsophú tahe krwǒ hyǎpluhyǎphè kuô̌lò̌ ná prè̤mòokryá yětôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bí Byacè myáhtye prè̤mòokryá yětôprè̤ akhè̌nuô, a thè́zò̤ ní̤dyé nyacò́ lǔ rò a hé lǔ, “Nguố̤ tǎmé̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Rò Jesǔ cuốtǒ dố luô̤̌to̤ yě a o rò a cuốtô lǒnuô. Bínuôakhè̌ kayǎ dố a záhyǎ luô̤̌ tahe okuố. Rò Jesǔ hé, “Prè̤khǔphúthè ihtò mò̌.” ");
INSERT INTO kyu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Rò kayǎ thyě yětôprè̤ ihtòonyǎo, rò a hébè khyěthyá. Rò Jesǔ nò̌cuốtǒkhyě lǔ dố amuố̤ o. ");
INSERT INTO kyu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kayǎ bè́mṳ yětahe khyéthukhyéthè́ lò̌plǐ cò́ rò htuthè́htya lahyǎ Cò́marya rò a hé lahyǎ, “Prè̤pro̤du oluô̌htya hò́ dố pè̤klè̌ tôprè̤ hò́” rò “Cò́marya hyǎlya̤ me̤cwó̤ hò́ akayǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kayǎ hésoluô̌ pasǐcuố lò̌ Jesǔ ari-akyǎyě dố Judaké̤ tôké̤lè̤̌ ná dò̌ o tavǐtava̤ bí Judaké̤ khǎsò̌khǎshyé nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Giovanni Baptista a khǒpacè̤̌ tahe héso pé̤ Giovanni ná lò̌꤮ tè̤ritè̤kyǎ yětahe. ");
INSERT INTO kyu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Rò Giovanni è́hyǎ dố a khǒpacè̤̌ aklè̌ yětahe thè́nyě̤ rò a nò̌cuố èthǐ dố Jesǔ a o rò a nò̌cuốsudyǎ lǔ, “Nè̤ ma Messia dố prè̤pro̤ tahe héone ná a ki hyǎ pǎ nuôtôprè̤ hò́ è̌? Má̤torò pè̤ tǒbè opò̤́myásû̌pǎ dố aruôtôprè̤ ki hyǎ pǎ agně nuô è̌? Cuốsudyǎ phúnuô ní,” a hécuố èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bí èthǐ hyǎtuố̤ dố Jesǔ o akhè̌nuô, èthǐ hé lǔ, “Giovanni Baptista nò̌hyǎ pè̤ rò a nò̌hyǎsudyǎ pè̤ ná nè̤rinè̤kyǎ rò a hé hyǎ pè̤, ‘Nè̤ ma Messia dố prè̤pro̤ tahe héone ná a ki hyǎ pǎ nuôtôprè̤ hò́ è̌? Má̤torò pè̤ tǒbè opò̤́myásû̌pǎ dố aruôtôprè̤ ki hyǎ pǎ agně nuô è̌? A hé pè̤ phúnuô.’” ");
INSERT INTO kyu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bí èthǐ hyǎ akhè̌nuô, atǒ ná Jesǔ zasǐmé̤ka̤ è́nyacò́ kayǎ dố atè̤swí o tahe, kayǎ dố atè̤sè̌ o tahe, kayǎ dố khǐnékhǐnò̌ me̤bè lǔ tahe ná kayǎ dố a mèthèkhí tahe rò a me̤lǐka̤khyě pé̤ ǔ è́lǎ. ");
INSERT INTO kyu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A hésû ka̤khyě pé̤ Giovanni nò̌hyǎ sudyǎ èthǐ tè̤ritè̤kyǎ yětahe, “Ka̤héso pé̤ Giovanni ná lò̌꤮ tè̤ dố thǐ myáhtye ní̤huô̌ yětahenuô ní꤮. Kayǎ mèthèkhí tahe myáhtye cyá̤hò́, kayǎ khǎduôdá tahe cuốcyá̤hò́, kayǎ tè̤sè̌mǔmyá̤ dố phálo̤ tahe sǐmé̤ ka̤khyě lò̌hò́, kayǎ khǎlèkaò̌ tahe khǎlèlǐ lò̌hò́, kayǎthyě tahe ihtòhtwǒprè̤ ka̤khyě khyěthyáhò́, kayǎ sǒrya̤sǒpháphú tahe ní̤huô̌bè kuô̌hò́ tè̤thè́krṳ̂̌mila hò́. ");
INSERT INTO kyu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dố vǎkhuvǎkhyě rò kayǎ dố a thè́plòpyé pé̤to, a zṳ̂́e tadû plehyǎlǎ tahenuô a ki ní̤bè má̤lakǒ cò́ tè̤sò̌ri hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bí Giovanni aprè̤thǔ tè̤ritè̤kyǎ tahe hteka̤ htuô̌hò́ akhè̌nuô, Byacè Jesǔ cáhtya hébè pé̤ kayǎ bè́mṳ nuôtahe ná Giovanni ari-akyǎ. Rò a hé pé̤ èthǐ, “Thǐ htecuố lahyǎ dố ké̤sè̌htyěkya̤ lò̤́tamákhu nuôma, thǐ cuốmyá kryá꤮ ǔpě? Ma thǐ cuốmyá lahyǎ ké̤lathè́ kazuô̤̌ pǒ̤mò̤́ nuôtahe è̌? ");
INSERT INTO kyu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Phúnuô má̤to kihérò, ma thǐ htecuốmyá kryá꤮ ǐtě? Ma thǐ htecuốmyá prè́ lahyǎ kayǎ dố a kû̌thyá pé̤ thǐ hyeca̤ takhè̌plyarashyǐ tôprè̤prè̤ nuôprè́ è̌? Kayǎ dố a kû̌thyá phúnuô tahema kayǎ dố a duzá̤htyathè̌ nuôtahe prè́, phúnuô tahe ma nè̤ myáhtye cyá̤ prè́ dố khwíhǒ tahe akǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hépé̤myá vǎ, thǐ htecuốmyá kryá꤮ ǐtětě? Thǐ htecuốmyá prè̤pro̤ tôprè̤prè̤ è̌? Thǐ ki cuốmyá prè̤pro̤ tôprè̤prè̤ hénuôma a má̤hò́. Vǎ hé thǐ, kayǎ dố aduklò̌lố cò́ ná prè̤pro̤nuô, thǐ myáhtye hò́ lǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Giovanni ma kayǎ tôprè̤ dố Cò́marya héone lǔrilǔkyǎ, ‘Myámò̌ è ma prè̤thǔ pé̤ vǎ tè̤ritè̤kyǎ tôprè̤hò́, thyáphú a ki me̤lá̤ one ré̤ pé̤ nè̤klyá lé̤hyǎ agněnuôrò, vǎ nò̌hyǎ ré̤hò́ è dố nè̤nyěhyǎ hò́.’” ");
INSERT INTO kyu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesǔ hé pó̤, “Vǎ hé pé̤ thǐ, lò̌꤮ kayǎ dố a opacè̤̌lya̤ tahe aklè̌nuô, adulốklò̌ cò́ ná prè̤plwǒhtyě Giovanni a o tôprè̤꤮ to. Manárò kayǎ dố a patílốǔ dố Cò́marya htyělé̤ké̤kǔ tôprè̤nuô, adulốklò̌ pǎ cò́ ná Giovanni cò́.” ");
INSERT INTO kyu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lò̌꤮ kayǎ yětahe ná prè̤kwǐamo-arǎ tahenuô a yǒ plwǒré̤ htuô̌hò́ htyě dố Giovanni o akhu-akhyě, bí èthǐ ní̤huô̌ lahyǎ Jesǔ hébè phúyě akhè̌nuô, èthǐ cṳ̌e ná Cò́marya a tè̤mekyǎngó̤ yětahe nuôma acò́ate̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Manárò Cò́marya taze-one pé̤ Pharisěophú ná prè̤ithyó tè̤thyótè̤thya athárá tahe agně yěnuô, èthǐ cṳ̌e kuô̌ǔ to me̤těhérò èthǐ plwǒ kuô̌ lahyǎ ané̤ ná htyě dố Giovanni a khadǎkǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesǔ hé pó̤, “Kayǎ yětôhtû̌ tahe ma, a thyádû ná maǐtě? Vǎ kíré̤ těradû̌ dyéluô̌ byábû̌myá pé̤dû èthǐ ná maǐtě? ");
INSERT INTO kyu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Èthǐ ma athyáná pacè̤̌phú cuốonyǎ bè́mṳlǔ dố klè́dǎ nuôtahe prè́. Rò a è́htǒè́mo̤ cuố ní̤dyé lǔ tôprè̤ ná tôprè̤ rò a hé lahyǎ, ‘Pè̤ uố pé̤ thǐ těló rò thǐ ilě toto, Pè̤ irǒihè pé̤ thǐ luô̤̌ rò, thǐ nguố̤ toto.’ ");
INSERT INTO kyu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Giovanni Baptista hyǎduôe sèesèǒ, hyǎduôǒ thòbǐthèhtyězǎ̤ rò thǐ hé lǔ, ‘Khǐnékhǐnò̌ me̤bè lǔ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě hyǎehyǎǒ kuô̌ke rò thǐ hé, ‘Myámò̌ kayǎ yětôprè̤lé, a ǒshyo nyacò́ thòbǐthèhtyězǎ̤, a cuố bò́thyókhè́khǒ dûgně ná prè̤kwǐamo-arǎ ná prè̤oraphú nuôtahelé,’ thǐ hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Manárò bí kayǎ tahehe ohtwǒprè̤ phú Cò́marya a tè̤thíphè́ yěakhè̌nuô, kayǎ dố aruô tahe ki myáhtye thè́gněhyǎ ná Cò́marya a tè̤thíphè́ yěnuôma a tǒprè́, phúnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisěophú tôprè̤ hyǎè́e Jesǔ dǐmò̤́hé rò Jesǔ ka̤kuô̌ dố lǔhi rò ka̤-onyǎ ekuô̌ lǔ dố dǐrè̤́ khǎshyé. ");
INSERT INTO kyu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bí vǐ̤ nuôtôvǐ̤ akǔnuô prè̤mò dố a me̤thû́tè̤ otôprè̤. A ní̤huô̌ ná Jesǔ hyǎedǐ bí Pharisěophúyě ahi rò a phyéhyǎní̤ pyǎ̤ dố ǔ me̤ ná lò̤́bǔ dố a obǎ ná htyěnuô̤mû́ tôpyǎ̤. ");
INSERT INTO kyu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Rò a hyǎihtòo phûtatò dố Jesǔ akhyěkhu rò a nguố̤ rò a mèthèhtyě tǎ̤co lò̌plǐ cò́ Byacè Jesǔ akhǎduô. Rò a htû́thǔplǐ pé̤kyǎ Byacè Jesǔ khǎduôyě ná akhuluô̤, rò a nuô̤mû́ lǔ khǎduô. Htuô̌rò a lyátǎ̤ htyěnuô̤mû́yě dố lǔ khǎduôlo̤. ");
INSERT INTO kyu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bí Pharisěophú dố a è́mo̤sû Jesǔ yětôprè̤ myáhtye a me̤phúyě akhè̌nuô, a tane̤ dố a thè́plòkǔ, “Kayǎ yětôprè̤nuô, a ki má̤lakǒ prè̤pro̤ tôprè̤ kihérò, prè̤mò dố a tôbè lǔ yětôprè̤ nuôma prè̤mò phútě tôcôtě, rò dố aré̤ano nuôma a ohtwǒprè̤ me̤kryá꤮ phútěnuô a tǒ thè́gně vǎ,” ");
INSERT INTO kyu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Rò Jesǔ hé lǔ, “Simonè, vǎ thè́zṳ̂́ hé nè̤ tè̤tôcô.” Rò Simonè hésû lǔ, “Hémò̌ Thárá, aní̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesǔ hé lǔ, “Bètôphuố kayǎ othè́nyě̤, anuố̤asu o rò a tǒbè pláka̤khyě kayǎ dố a plwǒbò èthǐ rû̌ yětôprè̤. Tôprè̤nuô asu-o rû̌zye nyǎ̤cwè̤́, rò dố aruô tôprè̤nuô asu-o rû̌zye hákhya. ");
INSERT INTO kyu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Èthǐ plá ka̤khyěbè́ pǎ asu tôprè̤꤮ to akhu-akhyě rû̌byacè yětôprè̤ dyalwókyǎ pé̤ èthǐsu yětahe. Ki me̤phúnuôrò, bítě tôprè̤ ki mo̤lốklò̌ lǔ pě?” ");
INSERT INTO kyu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Rò Simonè hésû è, “Vǎ tane̤ myáma, kayǎ dố a plwǒlwókyǎ è́ pé̤klò̌ lǔsu nuôtôprè̤ mo̤ní̤ è́klò̌ lǔ kǒle.” Rò Jesǔ hésû lǔ, “Nè̤ hé tǒ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Htuô̌rò Byacè Jesǔ tarí ka̤khyětǒ dố prè̤mò yětôprè̤ a o rò a hé Simonè, “Nè̤ myáhtye sálé̤ prè̤mò yětôprè̤ è̌? Vǎ hyǎnuô̌ cò́ dố nè̤ hidò́kǔ cò́ rò, phú pè̤ lé̤klǒ o ná nè̤ tǒbè dyé vǎ htyě lé̤sǐplǐ khǎduô agněnuô nè̤ dyé vǎ to. Manárò èyěnuô a htû́plǐ cò́ vǎ khǎduô ná a mèthèhtyě cò́ rò a htû́thǔ cò́ ná akhuluô̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nè̤ rò nè̤ nuô̤mû́sû vǎ to, manárò è rò cáhtya bí vǎ hyǎnuô̌ akhè̌, a nuô̤mû́ vǎ khǎduônuô a okuố cò́ tôphuố꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Phú pè̤ lé̤klǒlé̤khya onuô, nè̤ plò̤́ pé̤kuô̌ vǎ khuklò́ ná máǔhtyě to, manárò è rò a lyátǎ̤ cò́ htyěnuô̤mû́ dố vǎ khǎduôlo̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Phúnuôrò vǎ hé nè̤, prè̤mò dố atè̤thû́ oè́ yětôprè̤nuô, Cò́marya plwǒkyǎ lò̌hò́ lǔtè̤thû́ hò́. Phúnuôrò a khyáluô̌ hò́ ná a mo̤ ní̤dyé nyacò́ vǎ hò́. Manárò kayǎ dố Cò́marya plwǒkyǎ patí prè́ lǔtè̤thû́ tahenuô a ki mo̤ní̤ ka̤khyěsû patíprè́ Cò́marya prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Htuô̌rò Jesǔ hé prè̤mò nuôtôprè̤, “Vǎ plwǒkyǎ lò̌hò́ nè̤ tè̤thû́tè̤ora hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kayǎ dố a onyǎo tava̤kuô̌ ná Jesǔ bí lé̤edǐrè̤́ khǎshyé nuôtahe hé ní̤dyélǔ, “A cuố plwǒkyǎ cyá̤ cò́ ǔ tè̤thû́tè̤ora cò́ rò è ma kayǎ phútě tôprè̤ cò́tě?” ");
INSERT INTO kyu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Manárò Jesǔ héní̤ prè̤mò nuôtôprè̤, “Nè̤ tè̤zṳ̂́tè̤nyá̤ nuô, a me̤lwóhteka̤ hò́ nè̤ hò́. Ka̤mo̤mo̤ ka̤ryáryá dû ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dốkhyě nyě̤tyato nuô, Jesǔ htecuốklyá rò a cuốnuô̌ tôdò̌ htuô̌ tôdò̌, tôvǐ̤ htuô̌ tôvǐ̤, rò a cuốlě hésodônyǎ pé̤ ǔ ná Cò́marya ahtyěaké̤ a tè̤thè́krṳ̂̌mila ari-akyǎ. Rò a khǒpacè̤̌ shyéthè́nyě̤ krwǒcuốkuô̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Htuô̌to prè̤mò dố khǐnékhǐnò̌ me̤bè lǔ rò Jesǔ vè̤́htekyǎ pé̤ lǔ tahe, ná aswíasè̌ lahyǎ rò Jesǔ zasǐmé̤ pé̤ lǔ tahenuô, a krwǒcuố tố̤kuô̌. Èthǐ yětahe nuôma kryá꤮ ǔpě hénuôma, Maria (Dố ǔ è́ lǔ ná Magdalena dò̌kǔmuố̤), è ma khǐné thuô̌thyótôduô̌ o dố lǔkǔ rò Jesǔ vè̤́htekyǎ pé̤ lǔ nuôtôprè̤ hò́ rò a krwǒcuố tố̤kuô̌. ");
INSERT INTO kyu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Htuô̌rò Chuza dố a myákhwèní̤ pé̤ Khwí Herodè a tǎ̤muô̌tǎ̤tè̤ dố khwí hǒkǔnuô tôprè̤ amě Joanna ná Susanna ná prè̤mò dố aruô tahe krwǒcuố pa è́kuô̌lǎ lǔ. Prè̤mò yětahenuô, thyáphú èthǐ ki me̤cwó̤me̤kǒ ní̤ Jesǔ ná a prè̤dônyǎphú yětahenuôrò, èthǐ lò̌kyǎ ní̤dyédû lahyǎ arû̌ahtè̌ rò a krwǒcuốkuô̌ èthǐ akhyě. ");
INSERT INTO kyu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bí kayǎ bè́mṳ dố a hyǎ pé̤tó̤ tôvǐ̤ htuô̌ tôvǐ̤ tahe hyǎoplò́ tǎ̤sûlò̌ lǔ dố Byacè Jesǔ o akhè̌nuô, Byacè dyákho pé̤ èthǐ ná ngó̤khákho tôtó̤ rò a hé, ");
INSERT INTO kyu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Bètôphuố prè̤me̤prè́phú o tôprè̤. Rò tônyěkhè̌ a hyǎ pruốtǎ̤ tè̤klwǐ. Rò bí a pruốtǎ̤ tè̤klwǐ dố prè́khu akhè̌, tahehenuô a latǎ̤ dố klyádè̌kǔ, rò ǔ izí̤taprò́ cuố lò̌plǐ lǔ, htuô̌to htuphúzuố̤phú tahe hyǎihtuôekyǎ lò̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tahehenuô a latǎ̤tǒ dố lò̤́klè̌ rò bí a phè́htya akhè̌nuô, hekhu yǒ caǐ to akhu-akhyě, amò̤́ krǎthyě sǐmò̤́lò̌ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tahehenuô, a latǎ̤tǒ dố thòshyáthòprǔklè̌ rò a duhtya tố̤ná thòshyáthòprǔ akhu-akhyě thòshyáthòprǔ duhtya khyábí lò̌plǐ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Rò tè̤klwǐ tahehenuô a latǎ̤tǒ dố hezyeri̤zyeryákhu rò a phè́htyaduhtya rò athèhte è́klò̌ cò́ aphuố tôzè̤.” Htuô̌rò Jesǔ è́htǒ rò a hé, “Phúnuôrò, kayǎ dố a o ná akhǎlè tahenuô, nò̌ ní̤dǎ lahyǎ èthǐ.” ");
INSERT INTO kyu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tè̤dyá khákho yětôtó̤nuô a thè́ hé angó̤lasá phútěnuô, a khǒpacè̤̌ tahe sudyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Rò a hé pé̤ èthǐ, “Cò́marya dyéthè́gněplǒ pé̤hò́ thǐ ná a htyělé̤ké̤kǔ a tè̤thè́khuthè́gně dố a dò́uốdò́bí tahe hò́ tadû́rò kayǎ dố aruô tahe agněnuô vǎ hébè pé̤ èthǐ ná ngó̤khákho prè́. ‘Èthǐ myá lahyǎ tè̤ dố vǎ me̤ nuôtahe tadû́rò thyáphú èthǐ myáhtye thè́gněplǒ kuô̌ǔ angó̤lasá to, èthǐ ní̤dǎ tadû́rò thyáphú èthǐ thè́gněplǒ kuô̌ǔ to,’” agněnuô, vǎ hé pé̤ èthǐ ná ngó̤khákho prè́. ");
INSERT INTO kyu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tè̤dyá khákho yětôtó̤nuô angó̤lasá hyǎ phútě hérò, tè̤klwǐ angó̤lasá ma Cò́marya alǎ̤angó̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tè̤klwǐ dố a latǎ̤ cuốrwó klyálo̤ angó̤lasá ma má̤hò́ kayǎ dố a ní̤huô̌ lahyǎ Cò́marya alǎ̤angó̤ tadû́rò khǐnéricyá̤ khuklò́ hyǎphyé taphǎphekyǎ Cò́marya alǎ̤angó̤ dố èthǐ thè́plòkǔ. Htuô̌to thyáphú èthǐ thè́plò ki dídòdídyǎ dố tè̤zṳ̂́tè̤nyá̤ akǔ rò ki ní̤bè tǎ tè̤me̤lwóhteka̤ tǎmé̤nuô rò khǐnéricyá̤ khuklò́ hyǎme̤ phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tè̤klwǐ tǎ̤ dố lò̤́klè̌ angó̤lasá nuôma má̤hò́ kayǎ dố a ní̤huô̌ Cò́marya alǎ̤angó̤ tahe rò a thè́krṳ̂̌thè́lò̌ phyésû lahyǎ tadû́rò athyáná tè̤klwǐ dố arwí̤ sátǎ̤zǎ̤to nuô. Èthǐ zṳ̂́e lahyǎ prè́ taplô̤taplyáphú prè́. Rò bí tè̤me̤myá hyǎbè èthǐ akhè̌nuô, a tè̤zṳ̂́tè̤nyá̤ lamé̤kyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tè̤klwǐ latǎ̤tǒ dố thòshyáthòprǔklè̌ angó̤lasá yěnuôma má̤hò́ kayǎ dố a ní̤huô̌ Cò́marya alǎ̤angó̤ yětahenuô hò́. Manárò, bí a ohtwǒprè̤ plehyǎ akhè̌nuô, tè̤thukṳ́thè́kyǎ̤, tè̤duzá̤htyathè̌ tahe ná a mo̤ní̤ yětôhtû̌ a tè̤thè́zṳ̂́thè́lò̌ tahe khyábípé̤kyǎ lò̌ èthǐ phú thòshyáthòprǔ khyábí nuô akhu-akhyě athèprè̤́ bè́kuô̌ pǎ ǔ tôphuố꤮ to hò́. ");
INSERT INTO kyu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tè̤klwǐ latǎ̤tǒ dố hezyeri̤zyeryákhu angó̤lasá ma má̤hò́ kayǎ dố a ní̤huô̌ Cò́marya alǎ̤angó̤ rò a zṳ̂́e cò́cû́ rò a tǒ̤ní̤ phyéma dố a thè́plòkǔ, htuô̌to a ní̤dǎ ryá Cò́marya ngó̤ rò a khyáthè́plòhtǔ tuố̤ cò́ dố athèhtephǒhtecò́. ");
INSERT INTO kyu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ǔ isǐlǐ htuô̌ mi rò ǔ taklwǒ̤bí lǔ ná cǒ̤nuô a o tôprè̤꤮ to. Má̤torò ǔ dya lǔ dố lé̤myěrè̤́ alè̤̌nuô a o tôprè̤꤮ to. Thyáphú a ki lǐ pé̤ kayǎ dố a hyǎnuô̌ tahe agně nuô, ǔ isǐlǐ htuô̌ lǔ rò ǔ dyahtya è dố mikò̌rè̤́khu. ");
INSERT INTO kyu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tè̤pwǒ̤꤮ tôcô dố ǔ me̤uố è tahenuô, Cò́marya ki be-oluô̌hte è pǎ. Rò tè̤pwǒ̤꤮ tôcô dố ǔ me̤bí ènuô, Cò́marya ki dyéthè́gně hteluô̌ è pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Bí thǐ ní̤dǎ tè̤ akhè̌nuô, ní̤dǎ tǎ̤te̤ lahyǎ. Me̤těhérò kayǎ dố a thè́gně tǎ̤te̤ htuô̌hò́ Cò́marya ahtyěaké̤ tahenuô, Cò́marya ki dyéthè́gně è́htya lốklò̌pó̤ lǔ ná a khǎlé̤lye̤ yěnuô pǎ. Manárò kayǎ dố a thè́gně prè́ takiphúprè́ tahenuô, Cò́marya ki phyéphekyǎ lò̌phe pó̤ è pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesǔ amuố̤ ná a puố̤prè̤khǔ tahe hyǎ dố lǔo, manárò ǔ yǒ oró̤oè́ talwósû́lû̌ akhu-akhyě èthǐ hyǎnuô̌ tuố̤htwóbè́ dố lǔo to. ");
INSERT INTO kyu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kayǎ tahe hé lǔ, “Nè̤muố̤ ná nè̤ puố̤prè̤khǔ tahe hyǎihtò opò̤́ nè̤ dố aklò̌nuô. Èthǐ thè́zṳ̂́ myáhtye ná nè̤ hénuô.” ");
INSERT INTO kyu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesǔ hésû èthǐ, “Lò̌꤮ kayǎ dố a ní̤huô̌ Cò́marya alǎ̤angó̤ rò a zṳ̂́enyá̤e tahe nuôma vǎmuố̤ ná vǎpuố̤vǎvyá̤ lò̌꤮ plǐ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tônyěnuô Jesǔ ná a khǒpacè̤̌ tahe cuốnuô̌ dố thòklyě tôbè akǔ rò a hé èthǐ, “Pè̤ htecuố dố htyěòbè́rè̤̌ nuôtôkyě pó꤮” rò èthǐ htecuố lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bí èthǐ htecuố akhè̌nuô, Jesǔ omyěsǒtapa̤, rò bínuô akhè̌, ké̤lathè́ lalyǎ hyǎdu, htyěháhó nuô̌bǎlò̌ dố thòklyěkǔ, rò èthǐ bèzò̤bèthi lò̌plǐ cò́ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A khǒpacè̤̌ tahe cuố hturyǎ̤kahtò lǔ rò a hé lǔ, “Kố꤮ Thárá, Kố꤮ Thárá! Pè̤ kíré̤ lacû́thyě lò̌hò́!” Jesǔ pá̤ihtò rò a thè́prwǒ̤ ké̤lathè́ ná htyěháhó rò ké̤lathè́ okuốkyǎ rò htyětacố hyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Rò a hé a khǒpacè̤̌ tahe, “Thǐ tè̤zṳ̂́tè̤nyá̤ otǒ lò̌kryá bítě?” Èthǐ khyéthukhyéthè́ lò̌plǐ cò́, htuô̌to èthǐ thè́isě lahyǎ rò a hé ní̤dyélǔ, “È ma kayǎ phútě tôprè̤tě? A thè́prwǒ̤prè́ ké̤lathè́ ná htyěháhó prè́ rò a ní̤dǎ cò́ lǔ ngó̤ngó̤꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Byacè ná a khǒpacè̤̌ tahe cuốtuố̤ dố Gerasene ké̤. Gerasene ké̤ yěnuôma a o bí htyěòdu bè́rè̤̌ Galilea ké̤kǔnuô. ");
INSERT INTO kyu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bí Jesǔ htyahò́ dố khǒkhu akhè̌nuô, a myáhtye tǎ̤sû ná vǐ̤kǔphú dố khǐné me̤bè lǔ tôprè̤ bínuô. A okhǎklo̤ nyě̤lǎhò́, rò a okuô̌ǔ dố hi to, a htecuố o prè́ dố luô̤̌kǔ dố ǔ iluố nuô̌o ná luô̤̌yěnuô akǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bí a myáhtye Jesǔ akhè̌, a cyé̤pryě̤ è́htǒ rò a hyǎ dángṳ̂lya̤ dố Jesǔ nyěhyǎ rò a cyé̤pryě̤ è́htǒhébè, “Tè̤dutè̤htǔ tadû Cò́marya aphúkhǔ Jesǔ, nè̤ kíré̤ hyǎme̤ kryá꤮ vǎ ǐtě? Vǎ kwǐthè́zò̤ nè̤, me̤cyě̤me̤cṳ̂ tǎ vǎ tǎmé̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesǔ yǒ vè̤́ htuô̌hò́ khǐné yě dố a ki bè htecuốkyǎ dố kayǎphè̌ yětôprè̤ alo̤ akhu-akhyě, a hé lǔ phúnuôprè́. Khǐnékhǐnò̌ me̤bècyě̤ me̤bècṳ̂ tamǒmǒ cò́ lǔ rò ǔ cò̌klò̤ma cò́ lǔtakhu khǎduô ná tò̤́htè́plye̤ htuô̌to ǔ opò̤́maní̤ cò́ lǔ tadû́rò a cwi tṳ̂̌kyǎ pé̤ prè́ tò̤́htè́plye̤ prè́. Rò khǐné nò̌htecuốkyǎ lǔ dố ké̤sè̌htyěkya̤ lò̤́tamákhu. ");
INSERT INTO kyu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesǔ sudyǎ lǔ, “Nè̤mwi̤ ná ǔpě?” Rò a hésû, “Vǎmwi̤ ná Legion,” me̤těhérò khǐnékhǐnò̌ yǒ hyǎ nuô̌o è́nyacò́ hò́ dố lǔkǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Thyáphú Jesǔ ki cirya latǎ̤kyǎ tǎ èthǐ dố krò̌kǔdu krò̌kǔzǎ̤ tôkǔ tǎmé̤nuôrò, khǐné yětahe kwǐthè́zò̤ lahyǎ Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bínuôkhè̌, htyá tômṳdu kanúe tavǐtava̤phû asè bí sorò̤̌lo̤nuô. Rò khǐnékhǐnò̌ tahe kwǐthè́zò̤ Jesǔ ná a ki nò̌cuốnuô̌ o èthǐ dố htyá nuôtômṳ akǔ. Rò Jesǔ nò̌cuốnuô̌ okyǎ èthǐ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Phúnuôrò khǐné yětahe htecuốkyǎ dố kayǎphè̌ nuôtôprè̤ akǔ rò a cuốnuô̌okyǎ dố htyá nuôtômṳ akǔ. Yětôphuốrò htyá yětômṳ pá̤tǎ̤ rwó lá̤taprǐ yě alo̤ rò a latǎ̤lacû́ thyěkyǎ lò̌ dố nódukǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Prè̤kyě̤htyá tahe myáhtye tè̤me̤htwǒhtya ané̤ phúyě rò a klyaka̤ dyásoluô̌ cuốpye̤ pé̤lò̌ ǔ dố vǐ̤kǔ ná dốdò̌dốso tahe akǔ ná tè̤ritè̤kyǎ yětahe. ");
INSERT INTO kyu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tè̤me̤-ané̤ phúyě rò kayǎ tahe htecuốmyá lahyǎ. Èthǐ hyǎtuố̤ dố Jesǔ o rò a myáhtye lahyǎ kayǎphè̌ dố khǐné tahe htecuốkyǎ dố lǔkǔ nuôtôprè̤ thè́plòte̤ ka̤khyě hò́ rò a onyǎo bí Jesǔ khǎshyé rò a kû̌thyáhtya ryá lò̌ khyěthyá ahyeca̤. Èthǐ myáhtye lǔ rò a thè́isě lò̌plǐ cò́ lǔlé̤. ");
INSERT INTO kyu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kayǎ dố a myáhtye Jesǔ zasǐmé̤ ka̤khyě khǐné me̤bè lǔ yětôprè̤ ná ané̤ rò a me̤kryá꤮ phútěnuô, a dônyǎplǒ pé̤ ǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tè̤me̤htuô̌ané̤ phúnuôrò, lò̌꤮ kayǎ dố a o tavǐtava̤ bí Gerasene ké̤ htû̌ nuôtahe thè́isě talwósû́lû̌ akhu-akhyě èthǐ kwǐthè́zò̤ Jesǔ ná a ki htecuố taphǎkyǎ ná èthǐ bínuô. Rò Jesǔ htecuốhtyanuô̌ dố thòklyěkǔ rò a hteka̤kyǎ dố Galilea ké̤. ");
INSERT INTO kyu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kayǎphè̌ dố khǐné htecuốkyǎ htuô̌hò́ dố lǔkǔ yětôprè̤nuô a kwǐthè́zò̤ Jesǔ, “È́krwǒcuố pé̤kuô̌ré̤ vǎ,” manárò Jesǔ cṳ̌ lǔ to, rò a hé ka̤khyěsû lǔ, ");
INSERT INTO kyu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Cò́marya me̤ tè̤pro̤tè̤prya̤ kryá tè̤adu-azǎ̤ dố nè̤gně phútěnuô, ka̤ dố nè̤hi nuô rò ka̤hésoluô̌ pé̤ kuô̌ ǔruô tahe ní꤮.” Rò kayǎphè̌ yětôprè̤ kanuô̌ dố vǐ̤kǔ rò Jesǔ me̤ pé̤ kryá lǔ phútěnuô, a cuốlě dyásoluô̌ pé̤ lò̌plǐ ǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bí Jesǔ ka̤khyě khyěthyá dố htyěòdu bè́rè̤̌ tôkyě akhè̌nuô, kayǎ bè́mṳyě yǒ opò̤́myásû̌ lò̌plǐ hò́ lǔ akhu-akhyě, èthǐ è́mo̤sû lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Htuô̌rò tè̤cò́bè̌hǒ khuklò́du dố amwi̤ ná Jairus hé yětôprè̤ hyǎtuố̤ dố Jesǔ o rò a hyǎ dángṳ̂lya̤ dố lǔ khǎduôshyé, rò a kwǐthè́zò̤ Jesǔ ná a ki krwǒka̤kuô̌ dố lǔhi. ");
INSERT INTO kyu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Me̤těhérò a phúprè̤mò oprè́ tôprè̤꤮ tuô̌ rò atè̤ na ohò́ shyényě̤na yětôprè̤ kíré̤ thyětalí lǎhò́ akhu-akhyě, a cuố è́ka̤ Jesǔ dố ahi prè́. Bí Jesǔ krwǒka̤kuô̌ lǔ dố klyálo̤ akhè̌, kayǎ krwǒ tadwítashya pluphèbílò̌ è dǐkhódǐnyě cò́. ");
INSERT INTO kyu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Prè̤mò dố a khyábè tè̤sè̌thwitǎ̤ dố anyě̤ cò́hò́ shyényě̤na nuô a o tôprè̤. Manárò ǔ zasǐmé̤bè́ pé̤ lǔnuô, a o tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A hyǎnuô̌ dố kayǎ oró̤oè́ klè̌ rò a krwǒcuốkuô̌ dố Jesǔ khyěkhu, rò a hyǎ tôbè Jesǔ ca̤kyǎkhǎmí̤, rò a tè̤sè̌thwitǎ̤ yěnuô a okuố tôphuố okuốkyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesǔ sudyǎ ǔ, “Ǔpě tôbè vǎ pě?” Ǔ othuôtakrû́ lò̌plǐ pwǒ̤꤮ tôprè̤ rò Petru hésû lǔ, “Thárá, ǔ hyǎdwítashya lò̌ nyǎ nè̤ nuô̌.” ");
INSERT INTO kyu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Manárò Jesǔ hésû, “Kayǎ hyǎtôbèkhò nyǎdû vǎ tôprè̤, me̤těhérò vǎ tè̤pro̤tè̤prya̤ htecuốkyǎ dố vǎlo̤ nuô vǎ thè́gně.” ");
INSERT INTO kyu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yětôphuốrò prè̤mò yětôprè̤ thè́gněhò́ ná a o tadwǒuốbí cyá̤ pǎ to akhè̌nuô, a hyǎdángṳ̂lya̤ tanyǎ̤tadètǎ̤ dố Jesǔ nyěhyǎ. A cuốhyǎtôbè tuố̤ Jesǔ me̤těnuô, a hésoluô̌ pé̤lò̌ ǔ dố kayǎ pwǒ̤꤮ tôprè̤ a mèthènyě, htuô̌to a hésoluô̌ní̤ pé̤ pó̤ ǔ ná a tôbèhtuô̌ lǔ rò atè̤sè̌ sǐmé̤ tôphuố sǐmé̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Rò Jesǔ hé lǔ, “Phúmò꤮, nè̤ tè̤zṳ̂́ yěnuô, a zasǐmé̤ kyǎhò́ nè̤ tè̤sè̌hò́, ka̤mo̤mo̤ ka̤ryáryá dûní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bí Jesǔ hébèpǎprè́ akhè̌nuô, kayǎ tôprè̤ o dố Jairus dố a htwǒ tè̤cò́bè̌hǒ khuklò́ yětôprè̤ ahi hyǎ, rò a hyǎhéso pé̤ Jairus, “Nè̤phúmò thyěhò́, me̤dídyǎ pǎ tǎ Thárá tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesǔ ní̤huô̌ tè̤yě rò a hé Jairus, “Bèzò̤ tǎmé̤, tarú zṳ̂́e vǎ nuô ní꤮, nè̤phúmò ki ryá ka̤khyě khyěthyá dû pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bí a cuốtuố̤ dố hi akhè̌nuô, a dyénuô̌ ǔ dố hidò́kǔ tôprè̤꤮ to, a è́nuô̌ní̤ tû́prè́ Petru, Giovanni, Jakomo ná pacè̤̌muố̤ yětôprè̤ amuố̤aphè̌ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kayǎ o bínuô tahe nguố̤hè ní̤dyélò̌ pacè̤̌muố̤phú yětôprè̤. Manárò Jesǔ hé èthǐ, “Nguố̤ lahyǎ tǎmé̤. Pacè̤̌muố̤phú yětôprè̤nuô, a thyě má̤to, a omyění̤ sǒtapa̤ prè́!” ");
INSERT INTO kyu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Èthǐ thè́gně lahyǎ ná pacè̤̌muố̤phú yětôprè̤nuô a thyěhò́ akhu-akhyě, èthǐ nyě̤kruô̌ lò̌plǐ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Manárò Jesǔ pṳ̂́ pacè̤̌muố̤phú yětôprè̤ atakhu rò a hé lǔ, “Phúmò꤮ ihtò mò̌꤮!” ");
INSERT INTO kyu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A thè́htwǒprè̤ ka̤kanuô̌ khyěthyá rò a ihtò tôphuố ihtò cò́. Rò Jesǔ hé èthǐ ná dyée pé̤ lǔ sèe tôcôcô nuô. ");
INSERT INTO kyu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Amuố̤aphè̌ khyéthukhyéthè́ lò̌plǐ cò́, manárò Jesǔ mekyǎ èthǐ ngó̤ ná vǎ me̤ phúyě nuô cuố héso pé̤ tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesǔ è́hyǎ plò́lò̌ a khǒpacè̤̌ shyéthè́nyě̤ rò thyáphú prè̤dônyǎphú yětahe ki vè̤́htekyǎbè́ lò̌ khǐnétahe rò a ki zasǐmé̤bè́ lò̌ tè̤swítè̤sè̌ tahe agněnuôrò, a dyé pé̤ èthǐ tè̤pro̤tè̤prya̤ ná tè̤taryěshyosò̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Htuô̌rò a plwǒcuố èthǐ dố a ki cuố hésodônyǎ pé̤ ǔ ná Cò́marya ahtyěaké̤, rò a ki zasǐmé̤ pé̤ kayǎswíkayǎsè̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesǔ hé èthǐ, “Thǐ cuốklyá rò phyécuốní̤ tǎ tôcô꤮ tǎmé̤ ní꤮, ihtyábǒ bèbè, pyě̤ bèbè, sèe bèbè, rû̌htè̌ bèbè phyéní̤ tǎmé̤. Phyécuốlốphyécuốklò̌ tǎ ca̤ tôpṳ̂꤮ tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Otadûkuô̌ bí hi dố a è́mo̤sû thǐ nuôtômě akǔ tuố̤dố thǐ htecuốkyǎ bí vǐ̤kǔnuô pǎní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ǔ ki è́mo̤sû thǐ tôpho꤮ to hénuô, thuô̌tǎ̤kyǎ hemû dố thǐ khǎduôlo̤ nuôtahe rò htecuốkyǎ dố vǐ̤nuô tôvǐ̤ akǔ ní꤮. Thǐ ki me̤phúnuô héma athyáná thǐ dyéluô̌kyǎhò́ tè̤mátè̤dyǎ tôcô dố Cò́marya ki cirya èthǐ pǎ nuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Prè̤dônyǎphú tahe htecuố rò a cuốnuô̌ tôdò̌ htuô̌ tôdò̌ rò a cuố hésodônyǎ pé̤ ǔ tè̤thè́krṳ̂̌mila, rò a cuố zasǐmé̤ pé̤ ǔ tè̤swítè̤sè̌ dố khǎlé̤ pwǒ̤꤮ tôpho. ");
INSERT INTO kyu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bínuôakhè̌ Galilea ké̤ a Khwí Herodè ní̤huô̌ ná Jesǔ me̤tè̤ yětahe, rò a súsá lò̌ lǔ thè́plò, me̤těhérò, kayǎ tahehe hé ná Giovanni Baptista thyěihtòka̤khyě hò́. ");
INSERT INTO kyu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tahe kuô̌ke rò a hé ná Elia hyǎoluô̌htya khyěthyáhò́, tahehe rò a hé kuô̌ke ná prè̤pro̤ dố꤮ nyénu aklè̌ tôprè̤prè̤ htwǒprè̤ ka̤khyě khyěthyá hò́. ");
INSERT INTO kyu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Rò Khwí Herodè hé, “Vǎ nò̌pǎ̤tṳ̂̌kyǎ htuô̌hò́ Giovanni akhuklò́ hò́ rò kayǎ dố vǎ ní̤huô̌ ari-akyǎ yětôprè̤ nuôma ǔpěpě è̌?” Rò, “Vǎ ki myáhtye cyá̤ Jesǔ phútětě,” a tane̤ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Prè̤dônyǎphú tahe ka̤khyě rò ka̤héso pé̤lò̌ Jesǔ ná lò̌꤮ èthǐ me̤htuô̌hò́ tè̤nuôtahe ari-akyǎ. Jesǔ è́ní̤ èthǐ rò a htecuố tû́dû lahyǎ dố vǐ̤tôvǐ̤ dố ǔ è́ ná Bethsaida nuôtôvǐ̤. ");
INSERT INTO kyu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bí kayǎ bè́mṳ ní̤huô̌ ná Byacè Jesǔ ná a khǒpacè̤̌ tahe cuốhò́ dố vǐ̤ nuôtôvǐ̤ akhè̌, èthǐ krwǒcuốkuô̌ lahyǎ bínuô. Jesǔ è́mo̤sû èthǐ rò hésodônyǎ pé̤ èthǐ ná Cò́marya ahtyěaké̤ ari-akyǎ rò a zasǐmé̤ pé̤ kayǎ tahe a tè̤swítè̤sè̌. ");
INSERT INTO kyu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bí mò̤́ kíré̤ tǎ̤ hò́ akhè̌nuô, a khǒpacè̤̌ shyéthè́nyě̤yě hyǎ dố lǔo rò a hyǎhé lǔ, “Thyáphú èthǐ ki cuố myápṳ̌e myápṳ̌ǒ, ki cuốmyápṳ̌ ní̤dyé lahyǎ dû èthǐ lé̤omyě khǎlé̤khǎbya agněnuôrò, nò̌ka̤kyǎ mò̌ èthǐ dố dò̌kǔsokǔ dố a o tavǐtava̤ bíyě tôpho nuô, me̤těhérò khǎlé̤ bíyětôphoma dò̌ ophû tôdò̌꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Manárò Jesǔ hé èthǐ, “Myá dyéedyéǒ pé̤ èthǐ tôcôcô nuô.” Rò èthǐ hésû, “Pè̤tè̤ o prè́tû́ khò́mǔ nyǎ̤klò̤́ ná tè̤̌phú nyě̤bè prè́. Ma nè̤ thè́zṳ̂́ nò̌ cuốipri̤ pè̤ sèesèǒ dố kayǎ bè́mṳ yětahe agně è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dyáshuô̌shuô̌prè́ prè̤khǔdu yětahenuô a phû꤮ odû nyǎ̤rí cò́. Rò Jesǔ hétǎ̤ a khǒpacè̤̌ tahe, “Kayǎ bè́mṳ yětahenuô, nò̌onyǎ oplò́ èthǐ tômṳ ná prè̤nyǎ̤shyě, tômṳ ná prè̤nyǎ̤shyě nuô.” ");
INSERT INTO kyu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A khǒpacè̤̌ tahe nò̌onyǎo kayǎ bè́mṳ phú a hétǎ̤ èthǐ nuô. ");
INSERT INTO kyu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Rò Jesǔ phyé khò́mǔnuô nyǎ̤klò̤́ ná tè̤̌phúnuô nyě̤bè rò a tṳ́htya dố mò́lè̤̌ rò a hébwíhétaryěhtya Cò́marya. Htuô̌rò a ibikyě khò́mǔ ná tè̤̌phúyě rò a dyétǎ̤ ná a khǒpacè̤̌ nuôtahe. Rò a khǒpacè̤̌ tahe zṳ́tǎ̤e pé̤ ná kayǎ bè́mṳ yětahe. ");
INSERT INTO kyu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Èthǐ e pòepòǒ ekò́ǒbǎ lò̌plǐ cò́ pwǒ̤꤮ tôprè̤ cò́ rò a khǒpacè̤̌ tahe phyédwóplò́ khyěthyá khò́mǔ ná tè̤̌phú dố a ibikyě rò a okyǎlố tahenuô a obǎ pǎ cò́ ná krí̤nuô shyényě̤mě cò́. ");
INSERT INTO kyu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tônyěkhè̌ bí Jesǔ kwǐcò́bè̌ tû́dû tôprè̤ akhè̌nuô, a khǒpacè̤̌ tahe ophû ná lǔ rò Byacè sudyǎ èthǐ, “Kayǎ bè́mṳ tahe hékryá lahyǎ vǎ ná vǎ maǔpě?” ");
INSERT INTO kyu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rò èthǐ hésû, “Taheherò a hé nè̤ ná Giovanni Baptista, tahehe kuô̌kerò a hé ná Prè̤pro̤ Elia, taheherò a hé ná prè̤pro̤ dố꤮ nyénu tahe aklè̌ tôprè̤prè̤ ihtòhtwǒprè̤ ka̤khyě prè́,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Rò Jesǔ sudyǎke èthǐ, rò a hé èthǐ, “Thǐ kuô̌kelé꤮, thǐ hé vǎ ná ǔpě?” Rò Petru hésû lǔ, “Nè̤ ma Krístu dố Cò́marya nwóhtya è ná a ki me̤lwóhteka̤ prè̤luhekhuphú yětahe nuôtôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Rò Jesǔ mekyǎ tǎ̤te̤kyǎ angó̤ rò a hé èthǐ ná thǐ bè cuố hésoluô̌ní̤ pé̤ ǔ tôprè̤꤮ to ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Htuô̌rò a hé pé̤ pó̤ èthǐ, “Prè̤lu aphúkhǔ má̤ vǎyě, a bè khyábè nyǎ tè̤cyě̤tè̤cṳ̂ è́myěè́cô pǎ, rò Judaphú aplò́amṳ akhuklò́ tahe ná bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe ki cṳ̌ vǎ to, a ki thò́taná̤kyǎ vǎ pǎ. Ǔ me̤thyěkyǎ vǎ pǎ rò thuô̌nyětônyě pǎnuô Cò́marya ki me̤htwǒprè̤ ka̤khyě khyěthyá vǎ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Htuô̌rò Jesǔ héso pé̤ èthǐ pwǒ̤꤮ tôprè̤, “Kayǎ tôprè̤prè̤ ki thè́zṳ̂́ krwǒ vǎkhyě hénuô, a tǒbè me̤ phú vǎ thè́zṳ̂́nò̌me̤ lǔ nuôtahe, a me̤ cṳ́꤮ dû athè́plò ma aní̤ to. A bè záhtya ní̤dyédû a krusu pwǒ̤꤮ tônyě rò a bè krwǒ vǎkhyě. ");
INSERT INTO kyu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Me̤těhérò kayǎ dố a thè́zṳ̂́ me̤lwóhteka̤ ní̤dyé a thè́plòhtwǒprè̤ tôprè̤prè̤ nuô, a thè́plòhtwǒprè̤ ki lamé̤kyǎ pǎ. Manárò dố vǎkhuvǎkhyě rò kayǎ tôprè̤prè̤ ki dyélya̤kyǎ a thè́plòhtwǒprè̤ ní̤dû hénuô, a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kayǎ tôprè̤prè̤ ki ní̤bè lò̌ cò́ hekhusǐba a tè̤duzá̤htyathè̌ tahe cò́ tadû́rò a ki lacṳ́kyǎ a thè́htwǒprè̤ tacṳ́prè̤ yě hénuô abwío dố lǔgně ǐtě? ");
INSERT INTO kyu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kayǎ tôprè̤prè̤ dố a thè́tarè̤̌ vǎ ná vǎlǎ̤vǎngó̤ yětahe tôprè̤prè̤ nuô, shyé꤮ prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎhò́ ná a taryědutaryěhtǔ ná aphè̌ a taryědutaryěhtǔ ná tanémò́khuphú sǎsè̌ tahe a taryědutaryěhtǔ hò́pǎ akhè̌nuô, vǎ ki thè́tarè̤̌ kuô̌ke lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Vǎ hé má̤lakǒ cò́ thǐ, kayǎ dố a ihtòo bí thǐklè̌yě tahehenuô, bí èthǐ thyě tyahí tokhè̌, èthǐ ki myáhtyenò́ lahyǎ Cò́marya hyǎ pốhtyěpốké̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bí Jesǔ hébèhtuô̌ phúyě dốkhyě a phû bǎhò́ nyělwǐ̤thyó akhè̌nuô, a è́ní̤ Petru, Giovanni ná Jakomo rò a cuốhtya dố so tômě alo̤ rò Byacè Jesǔ kíré̤ cuốkwǐcò́bè̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bí a kwǐcò́bè̌ akhè̌nuô, amèthè htulyahtya khólò̌ rò a hyeca̤ tahenuô abǔplyatakhè̌htya lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kayǎ hyǎ oluô̌htyakhyé bínuô thè́nyě̤ rò a hébè ná Jesǔ. Èthǐ ma Mosè ná Prè̤pro̤ Elia. ");
INSERT INTO kyu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Rò a oluô̌htya tố̤ ná mò́khu a tè̤lǐtè̤takhè̌ tahe rò a hébè ná Jesǔ. Èthǐ hébè ní̤dyélǔ ná nyě̤tyato pǎnuô Jesǔ ki me̤lốme̤bǎhtya Cò́marya a tè̤taze-one yěnuô pǎ, rò a ki thyěkyǎ bí vǐ̤ Jerusalem akǔnuô pǎ ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petru ná a khǒbò́thyó tahe omyění̤sè̌ tadû́rò bí èthǐ thè́né̤htya akhè̌nuô, a myáhtye Jesǔ a taryědutaryěhtǔ tahe htuô̌ná kayǎ thè́nyě̤ ihtò otố̤kuô̌ ná lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bí Mosè ná Prè̤pro̤ Elia htecuốkyǎ hò́ akhè̌nuô, Petru hé Jesǔ, “Byacè꤮, khǎlé̤ bíyě tôpho rò atwó̤ mo̤ryá lǎ. Pè̤ ki isò́pé̤ thǐ lé̤thû thuô̌mě, tôměrò nè̤gně, tôměrò Mosè agně, tôměrò Prè̤pro̤ Elia agně.” (A hé phúyě tadû́rò a hékryá꤮ ǐtěnuô a thè́gně ní̤dyé to.) ");
INSERT INTO kyu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bí Petru hébè pǎprè́ akhè̌nuô, ò́luố̤ tôba hyǎ oluô̌htya rò a lapò̤ tǎ̤bíkyǎ èthǐ. Bí ò́luố̤ lapò̤bí èthǐ akhè̌nuô, a khǒpacè̤̌ tahe thè́isě lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Rò ngó̤pra̤hte dố ò́luố̤ akǔ rò a hé, “È ma vǎphúkhǔ dố vǎ nwóhtya htuô̌hò́ è tôprè̤. Ní̤dǎ lahyǎ angó̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bí ngó̤pra̤ okuốhò́ akhè̌nuô, a khǒpacè̤̌ yěthè́thuô̌ myáhtye ná Jesǔ okyǎ tû́dûprè́ tôprè̤ prè́. Lò̌꤮ tè̤ritè̤kyǎ dố èthǐ myáhtye a htwǒhtya yětahenuô a hésoluô̌ pé̤ ǔ tôprè̤꤮ to, bínuôkhè̌ èthǐ othuôtakrû́ ní̤dyé lò̌plǐ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Dốkhyětônyě, bí èthǐ o dố sokhu hítǎ̤ akhè̌nuô, kayǎ bè́mṳdu hyǎmyásû cò́ èthǐ tôplutôphè. ");
INSERT INTO kyu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dố kayǎ bè́mṳ aklè̌ tôprè̤nuô a è́htǒ, “Thárá꤮! Vǎ kwǐthè́zò̤ nè̤, nè̤ myámò̌ vǎphúkhǔ yělé. Vǎphúkhǔ oprè́ tôprè̤꤮ tuô̌ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Khǐnékhǐnò̌ me̤bè lǔ rò a è́htǒhtyakhyé. Htuô̌rò a me̤taryé lǔ rò akyǎ̤kǔ bò́bè́hte. Khǐnékhǐnò̌ yětôduô̌nuô, pwǒ̤phuốphuố꤮ a me̤bè lǔ rò a htecuố zǔnyé to, a me̤cyě̤me̤cṳ̂ me̤ thè́práladyá lò̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Vǎ kwǐthè́zò̤ nè̤ khǒpacè̤̌ tahe ki vè̤́htekyǎ pé̤ lǔ khǐnékhǐnò̌yě tadû́rò èthǐ vè̤́htekyǎ bè́to.” ");
INSERT INTO kyu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Byacè Jesǔ hé èthǐ, “Thǐ tè̤zṳ̂́tè̤nyá̤ oto, thǐ khǎlèduô̌ nyacò́! Vǎ bè onyě̤ tố̤kuô̌pǎ ná thǐ bátě pǎ? Vǎ tǒbè khyáthè́dǒ nyě̤pé̤kuô̌pǎ thǐ bátě?” A héhtuô̌ phúnuôrò a héke kayǎphè̌ nuôtôprè̤, “È́hyǎ nè̤ phúkhǔ bíyě.” ");
INSERT INTO kyu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bí pacè̤̌phè̌ yětôprè̤ hyǎ akhè̌nuô, khǐnékhǐnò̌ me̤lakhû́tǎ̤ lǔ dố hekhu rò a me̤taryé lǔ. Rò Jesǔ thè́prwǒ̤ khǐnéyě, rò a zasǐmé̤kyǎ pé̤ lǔ, rò a dyéka̤khyě khyěthyá ná aphè̌. ");
INSERT INTO kyu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kayǎ o bínuô pwǒ̤꤮ tôprè̤ khyéthukhyéthè́ lò̌plǐ cò́ Cò́marya a tè̤pro̤tè̤prya̤ shyosò̌ yěnuô cò́. Bí ǔ pwǒ̤꤮ tôprè̤ khyéthukhyéthè́ lò̌pǎprè́ lò̌꤮ Jesǔ me̤ tè̤pro̤tè̤prya̤ yětahe akhè̌nuô, Jesǔ hésoluô̌ pé̤ a khǒpacè̤̌ tahe, ");
INSERT INTO kyu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ní̤dǎ tǎ̤te̤ lahyǎ ngó̤ dố vǎ ki hésoluô̌ pé̤ thǐ khǒnyá̤ yětahe ní꤮. Prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě, ǔ ki isè̌ tǎ̤kyǎ è dố prè̤lukayǎ a takhukǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Manárò a khǒpacè̤̌ tahe thè́gněplǒ lǔ tè̤hébè yětômû̌ angó̤lasá to. Thyáphú èthǐ ki thè́gně tǎmé̤ nuô, ǔ beuốbebíkyǎ angó̤lasá prè́. Èthǐ sudyǎbû Byacè Jesǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Byacè a khǒpacè̤̌ tahe krékryá̤ ní̤dyélǔ ná dố èthǐ aklè̌nuô, ǔpě ki htwǒdulố ǔ pǎpě, phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesǔ thè́gně èthǐ atè̤tane̤ dố a thè́plòkǔ tahe akhu-akhyě a è́hyǎ pacè̤̌ tôprè̤ rò a nò̌hyǎ kahtòo lǔ dố akhǎshyé, ");
INSERT INTO kyu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","rò a hé èthǐ, “Kayǎ dố a myá vǎmèthè rò a ki è́mo̤sû pacè̤̌phú thyáná yětôprè̤ tôprè̤prè̤nuô a è́mo̤sû hò́ vǎ hò́. Rò kayǎ tôprè̤prè̤ dố a è́sû vǎ nuôma a è́sû prè̤ dố a nò̌hyǎlya̤ vǎ yětôprè̤nuô hò́. Me̤těhérò, kayǎ dố a tane̤patí ní̤dyélố ané̤ dố thǐklè̌ tôprè̤prè̤ nuôma kayǎ dố a htwǒdulố ǔ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Giovanni héhte, “Byacè꤮ pè̤ myáhtye kayǎ tôprè̤ dố a cuố vè̤́htekyǎ khǐnékhǐnò̌ tahe ná nè̤mwi̤. A yǒ otố̤kuô̌ dố pè̤amṳkǔ má̤to rò pè̤ hé tǎ̤tṳ̂̌kyǎ lǔ.” ");
INSERT INTO kyu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Manárò Jesǔ hésû Giovanni, “Cuốpṳ̌ me̤tǎ̤tṳ̂̌ tǎ è tǎmé̤. Me̤těhérò kayǎ dố a htésû thǐ to tahe nuôma kayǎ dố a pó̤ ní̤dyé thǐ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bí mò̤́nyěmò̤́thè̌ phûhyǎhò́ dố ǔ ki è́htyahò́ Jesǔ dố mò́khu akhè̌nuô, a belya̤ athè́plò ná a ki cuố dố vǐ̤ Jerusalem. ");
INSERT INTO kyu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesǔ nò̌cuốone ré̤ prè̤thǔ tè̤ritè̤kyǎ tahe dố nyě, rò thyáphú èthǐ ki taritaryǎ one pé̤ Byacè agně lò̌꤮ plǐ nuôrò, èthǐ htecuố nuô̌ okuốlá dố Samaria dò̌tôdò̌ akǔ. ");
INSERT INTO kyu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Manárò dò̌phúsophú tahe è́mo̤sû Jesǔ to, me̤těhérò èthǐ thè́gně tǎ̤te̤hò́ ná è ki cuố hò́ dố vǐ̤ Jerusalem hò́. ");
INSERT INTO kyu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bí a khǒpacè̤̌ Jakomo ná Giovanni myáhtye èthǐ me̤phúyě rò, èthǐ hé Byacè, “Byacè, pè̤ è́tǎ̤ mi dố mò́khu rò nò̌hyǎlya̤ û̌kyǎ lò̌ èthǐ pǎ nuôma nè̤ thè́plò o to è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesǔ tarí ka̤khyě rò a thè́prwǒ̤ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Rò èthǐ htecuố plehyǎ khókyǎ dố aruô tôdò̌. ");
INSERT INTO kyu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bí èthǐ cuố dố klyálo̤ akhè̌nuô, kayǎ tôprè̤ hé Jesǔ, “Nè̤ cuố bítě꤮ tôpho bèbè, vǎ ki krwǒcuốkuô̌ ná nè̤ rò vǎ htwǒkuô̌ nè̤ khǒpacè̤̌.” ");
INSERT INTO kyu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Rò Jesǔ hésû è, “Htwimi̤ tahe o ná akǔ, htuphú tahe o ná apwi̤, tadû́rò prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě, bí vǎ lé̤omyě kuố tabè́thè́prá khǎlé̤ agně prè́nuô a o tôpho꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A hé kuô̌ke kayǎ dố aruôtôprè̤, “Krwǒkuô̌ vǎkhyě rò htwǒkuô̌ vǎ khǒpacè̤̌.” Manárò yětôprè̤ hésû lǔ, “Byacè, dyéré̤ vǎ ashuốkhè̌ dố vǎ ki ka̤ iluốré̤ kuốré̤ vǎphè̌ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesǔ hésû lǔ, “Kayǎthyě yětahenuô, nò̌iluố ní̤dyédû ná kayǎ dố a thyě lahyǎ nuôtahe. Manárò nè̤yě, cuố hésodônyǎ pé̤ré̤ ǔ ná Cò́marya htyěké̤ ari-akyǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dố aruô pó̤ke tôprè̤ rò a hé, “Byacè꤮ vǎ htwǒkuô̌ nè̤ khǒpacè̤̌, manárò plwǒka̤ hémo̤héryá kuô̌ré̤ vǎ ná vǎ hiphúphyǎphú tahe.” ");
INSERT INTO kyu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesǔ hésû è, “Kayǎ tôprè̤prè̤ dố a pṳ̂́htáhtè̌ rò a tarí ka̤khyě nuô, abwítaryě o dố Cò́marya ahtyěaké̤ agně tôcô꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Htuô̌rò Byacè Jesǔ nwóhtya ró̤è́ pó̤ hò́ a khǒpacè̤̌ dố aruô thuô̌thyótôshyě ná thè́nyě̤ rò a nò̌cuố èthǐ tôpho ná thè́nyě̤. Rò a nò̌ cuố ré̤ lò̌ èthǐ dố dò̌ pwǒ̤tôdò̌ akǔ, vǐ̤ pwǒ̤tôvǐ̤ akǔ ná khǎlé̤ pwǒ̤꤮ tôpho bí khǎlé̤ dố Byacè kíré̤ cuố yěnuô tahe. ");
INSERT INTO kyu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A hé pé̤ èthǐ, “Lé̤kè́buố akhǎlé̤ oè́lǎ, manárò prè̤kè́buố opatí꤮ nyacò́. Rò kwǐ lahyǎ lyá̤byacè ná a ki nò̌hyǎ prè̤kè́buố tahe dố alyá̤khu yěnuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cuốmò̌! Vǎ plwǒcuố hò́ thǐ phú ǔ plwǒcuố thímí tahe dố htwimi̤ tahe aklè̌nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Rû̌pyě̤ bèbè, pyě̤hó bèbè, khuphá bèbè, phyécuốní̤ tǎ tôcô꤮ tǎmé̤ ní꤮. Bí thǐ cuố dố klyálo̤ akhè̌nuô, cuố okuố hémo̤héryá tǎ ǔ tôprè̤꤮ tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Bí thǐ cuốnuô̌ dố hi tôměmě akǔ khè̌nuô, héré̤lố, ‘Tè̤thè́plò kacṳ́kabè́ ki o dû dố hiyě tômě akǔ ní꤮!’ Hé lahyǎ phúnuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kayǎ dố a mo̤ tè̤pě̤tè̤dwǒ ki o bínuô tôprè̤ hénuôma, a ki ní̤bè dû nè̤ tè̤hémo̤héryá a tè̤pě̤tè̤dwǒ yěnuô pǎ. Kayǎ dố a mo̤ tè̤pě̤tè̤dwǒ ki oto hénuô, nè̤ tè̤hémo̤héryá tè̤pě̤tè̤dwǒ yěnuô a ki ka̤khyětǒ khyěthyá dû dố nè̤ o pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","O bí hinuô tômě akǔ rò hibyacè dyéedyéǒ thǐ ǐtětě꤮ bèbè, tarú e lahyǎ, me̤těhérò prè̤me̤tè̤phú tôprè̤nuô, a tǒkò ní̤bè nyǎ akhwóakè. Cuốlěomyě ǔhi tômě htuô̌ tômě tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Thǐ cuốnuô̌ dố vǐ̤ tôvǐ̤vǐ̤ akǔ bíkhè̌tě꤮ bèbè nuô, ǔ ki è́mo̤sû thǐ kihérò, ǔ dyée thǐ ǐtětě꤮ bèbè nuô, tarú e lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Zasǐmé̤ pé̤ kayǎ dố aswíasè̌ bí vǐ̤nuô tôvǐ̤ akǔ nuô. Rò héso pé̤ kayǎ o bínuô tahe, ‘Cò́marya kíré̤ pốhtyěpốké̤ amò̤́nyěmò̤́thè̌ nuô a hyǎtuố̤phû hò́ ná thǐ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Manárò bí thǐ cuốnuô̌ dố vǐ̤ tôvǐ̤vǐ̤ akǔ khè̌nuô, ǔ ki è́mo̤sû thǐ to kihérò, cuố dố klyádukǔnuô, rò cuố hé, ");
INSERT INTO kyu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Thǐ vǐ̤kǔ hemû dố a byáma pè̤ khanyělè̤̌ yětahenuô, pè̤ thuô̌tǎ̤kyǎ pé̤hò́ thǐ hò́. Pè̤ thè́zṳ̂́ nò̌thè́gně thǐ ná pè̤ dyakyǎhò́ thǐ hò́. Manárò tǒ̤ma lahyǎ ná Cò́marya kíré̤ pốhtyěpốké̤ amò̤́nyěmò̤́thè̌ nuô a hyǎtuố̤phû hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Vǎ hé thǐ, shyé꤮ Cò́marya cirya prè̤lukayǎ pǎ akhè̌nuô, è ki thè́zò̤ní̤ lốklò̌ pǎ cò́ vǐ̤ Sodom yěnuô ná a thè́zò̤ní̤ vǐ̤yě tôvǐ̤nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Vǐ̤ Chorazinphú thǐ꤮, tè̤cirya ki hyǎbè má̤lakǒ cò́ thǐ pǎ. Thǐ vǐ̤ Bethsaidaphú tahe bèbè, tè̤cirya ki hyǎbè kuô̌ cò́ thǐ pǎpǎ. Tè̤pro̤tè̤prya̤ dố vǎ dyéluô̌ pé̤ hò́ thǐ tahenuô, vǎ ki dyéluô̌ tǒbye dố vǐ̤ Tyre ná vǐ̤ Sido hénuôma, htyěphúké̤phú bínuô tahe klyá onyǎo dố kò́phèmûkhu rò èthǐ klyá kû̌thyáhtya hyeca̤taprú dố a dyéluô̌ ná èthǐ za̤ ní̤dû khyě ané̤ hò́, èthǐ ki me̤ lahyǎ phúyě nyě̤lǎhò́. ");
INSERT INTO kyu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Shyé꤮ tè̤cirya amò̤́nyě hyǎtuố̤ pǎ rò, vǐ̤ Tyrephú ná vǐ̤ Sidophú yětahenuô, Cò́marya ki thè́zò̤ní̤klò̌ ná thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Vǐ̤ Capernaumphú thǐ꤮, thǐ tane̤ dyé cò́ lahyǎ thǐné̤ ná Cò́marya dyahtyalô̌ tuố̤ cò́ thǐ dố mò́khu è̌? A dyahtyalô̌ tuố̤ ná thǐ to. A ki vǐtǎ̤kyǎ thǐ dố Mò́rapò̤tya̤ kǔ pǎ!” ");
INSERT INTO kyu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesǔ hé a khǒpacè̤̌ shyéthè́nyě̤ yětahe, “Kayǎ dố a ní̤dǎ thǐngó̤ tahe nuôma má̤hò́ a ní̤dǎ hò́ vǎngó̤ hò́. Kayǎ dố a htésûkyǎ thǐ tahe nuôma a htésûkyǎhò́ vǎ hò́. Rò kayǎ dố a htésûkyǎ vǎ tahe nuôma a htésûkyǎhò́ kayǎ dố a nò̌hyǎlya̤ vǎ yěnuô tôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kayǎ thuô̌thyótôshyě ná thè́nyě̤ ka̤khyětuố̤ lahyǎ ná tè̤thè́luố̤phòphû̌. Rò èthǐ hé Byacè, “Byacè, bí pè̤ pó̤ ná nè̤mwi̤ akhè̌nuô, khǐnékhǐnò̌ rò a cṳ̌e cò́ pè̤ngó̤ cò́.” ");
INSERT INTO kyu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesǔ hésû èthǐ, “Vǎ myáhtye Cò́marya me̤pé̤ khǐnéricyá̤ khuklò́ rò a o dố mò́khu latǎ̤ thyá cò́ ná shyeli̤bò́ nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ní̤dǎ lahyǎ! Thyáphú thǐ ki khè̌zí̤cuố dố rṳ́tahe ná dǎmè̤tahe akhu pǎ, rò thǐ ki me̤pé̤kyǎ khǐnéricyá̤ khuklò́ dố a thè́hte thǐ yětôduô̌ a tè̤pro̤tè̤prya̤ tahe lò̌꤮ plǐ agně pǎnuô rò, vǎ dyéhò́ thǐ tè̤pro̤tè̤prya̤ hò́. Rò tè̤ dố a ki me̤bème̤sè̌ thǐ nuô a opǎ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Manárò, khǐnékhǐnò̌ tahe cṳ̌e thǐngó̤ khukhyěrò thè́krṳ̂̌ lahyǎ tǎmé̤ ní꤮. Thè́krṳ̂̌ lahyǎ dố ǔ rǎmá o hò́ thǐmwi̤ dố mò́khu yěnuô.” ");
INSERT INTO kyu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bínuôkhè̌, dố Thè́ Sǎsè̌ Byacè akhu-akhyěrò Jesǔ lốbǎ ná tè̤thè́krṳ̂̌thè́lò̌ rò a hé, “Kố꤮ mò́khu Byacè, hekhu Byacè, vǎ Phè̌ Cò́marya꤮, vǎ hébwíhétaryě nè̤, tè̤ dố nè̤ dya dò́uốdò́bí pé̤ prè̤thíphè́phú tahe ná prè̤pṳ̌thè́gnětè̤phú tahenuô, nè̤ dyéluô̌htya pé̤hò́ ná kayǎ dố a tane̤patí ní̤dyé ané̤ thyáná pacè̤̌phú nuôtahehò́ akhu-akhyě, vǎ hébwíhétaryěhtya nè̤. Kố꤮ phè̌꤮, nè̤ thè́plòo thè́plòtǒ má̤nyǎhò́ ná a kibè htwǒhtyanyǎ phúyěhò́ akhu-akhyě, vǎ hébwíhétaryě nyacò́ nè̤. ");
INSERT INTO kyu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Vǎphè̌ dyétǎ̤lò̌ hò́ vǎ tè̤pwǒ̤꤮ tôcô hò́. Phúkhǔ ma ǔpěnuô ǔ thè́gně tôprè̤꤮ to. Thè́gně tû́prè́ phè̌tôprè̤ prè́. Rò phè̌ ma ǔpěnuô ǔ thè́gně tôprè̤꤮ to, thè́gně tû́prè́ phúkhǔ ná kayǎ dố phúkhǔ nwóhtya lǔ dố a ki dyéluô̌ pé̤ lǔ pǎ nuôtahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Htuô̌rò Jesǔ tarí ka̤khyě dố a khǒpacè̤̌ tahe a o rò a hésohuô pé̤ èthǐ, “Lò̌꤮ kayǎ dố a myáhtye hò́ tè̤dố thǐ myáhtye hò́ yětahe tahenuô, èthǐ ní̤bèhò́ tè̤sò̌risò̌bǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Vǎ hé pé̤ thǐ, prè̤pro̤ è́prè̤ ná khwí è́prè̤ dố a ohtwǒprè̤ dố꤮ nyénu tahenuô, èthǐ thè́zṳ̂́ myáhtyekuô̌ lahyǎ tè̤ dố thǐ myáhtye yěnuôtahe tadû́rò èthǐ myáhtyenò́ kuô̌ǔ to. Htuô̌to èthǐ thè́zṳ̂́ ní̤huô̌kuô̌ lahyǎ tè̤ dố thǐ ní̤huô̌ nuôtahe tadû́rò èthǐ ní̤huô̌nò́ kuô̌ǔ to.” ");
INSERT INTO kyu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Prè̤ithyó tè̤thyótè̤thya athárá tôprè̤ kahtò rò a thè́zṳ̂́ ce̤myáme̤myá Jesǔ a tè̤cyá̤tè̤dè tahe rò a sudyǎ Jesǔ, “Thárá꤮, thyáphú vǎ ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ nuô, vǎ tǒbè me̤ phútě?” ");
INSERT INTO kyu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesǔ hésû è, “Lisǎsè̌ a tè̤thyótè̤thya hé phútě? Nè̤ hốbènò́ rò nè̤ thè́gně phútě?” ");
INSERT INTO kyu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Rò a hésû, “‘Thǐ bè mo̤ lò̌thulò̌thè́ thǐ Byacè Cò́marya ná thǐ thè́plò sǐmělò̌, mo̤ lò̌thulò̌thè́ è ná thǐ tè̤ohtwǒprè̤ lò̌꤮ plǐ, mo̤ lò̌thulò̌thè́ è ná thǐhè̌thǐre, mo̤ lò̌thulò̌thè́ è ná thǐ tè̤tane̤ lò̌꤮ plǐ. Thǐ bè mo̤ ní̤dyé thǐhi khǎsò̌khǎshyé tahe phú thǐ mo̤lya̤ ní̤dyé thǐné̤ nuô.’” ");
INSERT INTO kyu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesǔ hésû è, “Nè̤ tè̤hésû vǎ nuôma atǒ hò́. Ohtwǒprè̤ krwǒ thyáná nè̤ hénuô, rò nè̤ ki ní̤bè dû thè́htwǒprè̤ tacṳ́prè̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Manárò a thè́zṳ̂́ dyéluô̌ ané̤ phú kayǎ cò́ tôprè̤nuô akhu-akhyě a sudyǎ Jesǔ, “Kayǎ o dố vǎhi khǎsò̌khǎshyé tahe rò ma ǔpěpě?” ");
INSERT INTO kyu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesǔ hésû lǔ, “Bètôphuố, kayǎ o tôprè̤, a o dố vǐ̤ Jerusalem rò a cuố dố vǐ̤ Jeriko. Rò bí a cuố akhè̌nuô, a cuố tǎ̤sû ná prè̤pṳ̂́phe zè́plè́e ǔ tahe, rò èthǐ plwókyǎ lò̌ lǔ hyeca̤, mṳ̂̌pò̤ lò̌ lǔ rò a phûthyě talí cò́ rò a dya-okyǎ prè́ lǔ phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bínuôakhè̌, prè̤lǔtyǎ tôprè̤ cuốrwóklyá nuôtôbǒ rò a myáhtye lǔ tadû́rò a cuốvò̤kyǎ prè́ lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nyě̤tyato rò Leviphú tôprè̤ hyǎtuố̤kuô̌ bínuô hò́ rò a myáhtye lǔ tadû́rò a cuốvò̤kyǎ kuô̌ prè́prè́. ");
INSERT INTO kyu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Manárò Samariaphú tôprè̤ htecuốklyá rò bí a hyǎtuố̤ bí kayǎ bèpyá̤bèsè̌ yětôprè̤ a o akhè̌nuô, a myáhtye lǔ rò a thè́zò̤ní̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A cuố dố lǔo rò a plò̤́ pé̤ lǔné̤htyǎ yětahenuô ná tè̤khuhtyě, rò a bobí pé̤ lǔ. A me̤htuô̌ phúnuôrò a dyahtyaní̤ lǔ dố a tathílo̤, rò a cuố thǔ lǔ dố sǐpré̤lé̤o hitômě akǔ rò a myákhwèní̤ lǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Dốkhyě tônyěnuô, a phyéhte rû̌zye nyě̤bè rò a dyé ná prè̤opò̤́hi yětôprè̤ rò a hé lǔ, ‘Myákhwèní̤ ryá è ní꤮ rò shyé꤮ vǎ ka̤tuố̤ khyěthyá pǎ rò, alò̌ pó̤ bá꤮ tě pǎnuô vǎ ki dyé pó̤ dû nè̤ pǎ.’” ");
INSERT INTO kyu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Rò Jesǔ me̤tadûkyǎ atè̤dyá rò a sudyǎ prè̤ithyó tè̤thyótè̤thya athárá yětôprè̤, “Nè̤ tane̤ myámyá kayǎ yěthè́thuô̌ aklè̌ nuôma, bítětôprè̤ rò a htwǒ prè̤pṳ̂́phe zè́plè́e ǔ yětahe mṳ̂̌ lǔ nuôtôprè̤ ahi khǎsò̌khǎshyé pě?” ");
INSERT INTO kyu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Rò a hésû Jesǔ, “Kayǎ dố a thè́zò̤ me̤cwó̤ní̤ lǔ nuôtôprè̤ prè́.” Rò Jesǔ hésû lǔ, “Cuố me̤kuô̌ phúnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bí Jesǔ ná a khǒpacè̤̌ tahe cuố plehyǎ pó̤ klyá dố nyě akhè̌nuô, èthǐ cuốnuô̌ dố dò̌tôdò̌ rò prè̤mò dố amwi̤ ná Martha héyě tôprè̤nuô a è́mo̤sû lǔ dố a hidò́kǔ. ");
INSERT INTO kyu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Apuố̤prè̤mò dố amwi̤ ná Maria o tôprè̤. Rò a onyǎo bí Byacè a khǎduôshyé rò a ní̤dǎ lǔ tè̤ithyóithya tahe. ");
INSERT INTO kyu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha tane̤súsá ná a tè̤phyétè̤me̤ tahe akhu-akhyě, a cuốtǒ dố Jesǔ a o rò a cuố hé lǔ, “Byacè꤮ vǎ puố̤prè̤mò me̤cwó̤kuô̌ vǎ tôcô꤮ to, vǎ bème̤ lò̌ ní̤dyé tû́dû prè́ tôprè̤ prè́, rò nè̤ hé pé̤ kuô̌ vǎ tôcô꤮ to è̌? Hé pé̤ vǎ rò nò̌cuố me̤cwó̤ kuô̌ vǎ to!” ");
INSERT INTO kyu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Rò Jesǔ hésû lǔ, “Martha, Martha! Nè̤kṳ́nè̤kyǎ̤ rò nè̤ thè́plò súsá ná tè̤me̤ è́myěè́cô cò́. ");
INSERT INTO kyu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Manárò tè̤ dố alo̤nuô a o prè́ tôcôcô tuô̌ prè́. Maria nwóphyé htuô̌hò́ tè̤ dố aryáklò̌ yětôcô hò́. Ǔ phyéphekyǎ cyá̤ pǎ è tôprè̤꤮ to hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tônyěkhè̌ Jesǔ kwǐcò́bè̌ dố khǎlé̤ tôpho. Bí a kwǐcò́bè̌ htuô̌hò́ akhè̌, dố a khǒpacè̤̌ tahe aklè̌ tôprè̤nuô a hé lǔ, “Byacè, ithyó pé̤ kuô̌ pè̤ tè̤kwǐcò́bè̌ phú Giovanni ithyó pé̤ a khǒpacè̤̌ tahenuô.” ");
INSERT INTO kyu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesǔ hé èthǐ, “Bí thǐ kwǐcò́bè̌ akhè̌nuô, kwǐ lahyǎ phúyě ní: ‘Kố꤮ phè̌꤮ ǔ ki dyadudyahtǔ bezṳ̂́benyá̤ ní̤dû nè̤mwi̤ sǎsè̌ yě ní꤮. Nè̤ ki hyǎ isò́o ní̤dû nè̤htyěnè̤ké̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dyépé̤ pè̤ lé̤elé̤ǒ dố pè̤ lobè è tônyě ná tônyě agně yěnuô tahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Plwǒkyǎ pé̤ré̤ pè̤ tè̤thû́ tahe ní꤮. Me̤těhérò pè̤ plwǒkyǎ htuô̌hò́ ǔ tè̤me̤thû́ dố ǔ me̤thû́ pè̤ nuôtahe hò́. Nò̌cuốnuô̌ tǎ pè̤ dố tè̤ilo-ilyá aklè̌nuô tǎmé̤ ní꤮.’” ");
INSERT INTO kyu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Htuô̌rò Jesǔ hé a khǒpacè̤̌ tahe, “Hékuốré̤ dố thǐklè̌ tôprè̤prè̤nuô a ki cuố dố a khǒbò́thyó tôprè̤ ahi bí mò̤́ne̤khè̌ rò a ki cuốhé lǔ, ‘Khǒbò́thyó dyéló̤kuô̌ré̤ vǎ nè̤khò́mǔ thuô̌klò̤́. ");
INSERT INTO kyu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Vǎ khǒbò́thyó tôprè̤ a cuốklyá rò a hyǎtuố̤kuô̌ vǎ rò vǎ lé̤dyéesû è sèesèǒ o pǎ tôcô꤮ to hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Rò a khǒbò́thyó o dố hidò́kǔ yětôprè̤ ki hésû lǔ, ‘Me̤súsá pǎ tǎ vǎ tǎmé̤. Vǎ me̤ mahò́ vǎkadǎ hò́, rò vǎ ná vǎphú tahe pè̤ cuốomyě lò̌ hò́. Vǎ kahtò dyé cyá̤ pǎ nè̤ to.’ ");
INSERT INTO kyu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Phúnuôrò vǎ hé thǐ, dốkhyě rò akhǒ yětôprè̤ ihtò dyé pé̤ lǔ khò́mǔ, manárò dố èthǐ yǒ mo̤ ní̤dyé nyacò́ lǔ akhu-akhyě yěnuô má̤to. A yǒ kwǐtadû lǔ akhu-akhyě a dyé pé̤ lò̌ lǔ lò̌꤮ tè̤ dố a lo nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Phúnuô akhu-akhyě vǎ hé thǐ, kwǐ mò̌ lahyǎ, thǐ ki ní̤bè pǎ! Myápṳ̌ mò̌ lahyǎ, thǐ ki myáhtye pǎ. Dòmò̌ lahyǎ kadǎnuô, Cò́marya ki bámǒ pé̤dû thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Me̤těhérò lò̌꤮ kayǎ dố a kwǐtè̤ tahenuô, a ki ní̤bè pǎ, rò lò̌꤮ kayǎ dố a myápṳ̌ tè̤ tahenuô, a ki myáhtye pǎ, rò lò̌꤮ kayǎ dố a dò kadǎ tahenuô, Cò́marya ki bámǒ pé̤ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Thǐ dố a htwǒ phè̌ tahenuô, thǐphú ki kwǐe thǐ tè̤̌phú rò, thǐ dyée è ná rṳ́ nuôma a o nyǎ tôprè̤prè̤ è̌? ");
INSERT INTO kyu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Má̤torò thǐphú ki kwǐe thǐ shyědye rò thǐ dyée è ná dǎmè̤ è̌? ");
INSERT INTO kyu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Thǐ ma kayǎ dố a cyě̤ricyá̤ taheprè́ tadû́rò thǐ thè́gně dyée thǐphúthǐlye̤ tahe ná tè̤dố aryá tahe cò́ kihérò, tane̤myámò̌ lahyǎ thǐphè̌ dố mò́khu yětôprè̤nuô, a ki dyé tǎ̤te̤ má̤lakǒ pé̤ cò́ kayǎ dố a kwǐhtya lǔ Thè́ Sǎsè̌ Byacè yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesǔ vè̤́htekyǎ khǐné dố a me̤pè́ ǔ nuôtôduô̌. Bí khǐné htecuốkyǎ htuô̌hò́ akhè̌nuô, kayǎpè́ yětôprè̤ hébè cyá̤ ka̤khyě khyěthyá rò kayǎ bè́mṳ tahe khyéthukhyéthè́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Manárò kayǎ tahehe rò a hé, “A vè̤́htekyǎ cyá̤ khǐné tahe phúyě nuôma má̤prè́ khǐné khuklò́du Beelzebul dyé lǔ tè̤taryěpro̤prya̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kayǎ dố aruô tahe hyǎkwǐ khákhomyábyeprè́ Jesǔ ná a ki dyéluô̌ pé̤ èthǐ tè̤pro̤tè̤prya̤ dố a o dố mò́khu hyǎ tôcôcô. ");
INSERT INTO kyu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Manárò Byacè Jesǔ thè́gně èthǐ tè̤tane̤ tahe rò a hé èthǐ, “Ké̤tôké̤ akǔnuô akayǎ tahe kisákipǎ̤ ní̤dyédû lǔ tôprè̤ ná tôprè̤ kihérò a lṳpruốlṳpryǎkyǎ pǎ. Hiphúphyǎphú tômuố̤ dố a krṳ̂̌klè̌ ní̤dyé lǔ to rò a kiklyékingǎ ní̤dyé lǔ hénuô, a ki lṳpruốlṳpryǎkyǎ lò̌ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Phúnuô akhu-akhyě, khǐnéricyá̤ khuklò́ ahtyěaké̤ ki o ná khǐnékhǐnò̌ dố a me̤takhwótakè ní̤dyé khyělǔ tômṳ ná tômṳ hénuô, a oklò̤sò́ma cyá̤ to. Mame̤tě vǎ hé phúyě hénuôrò, thǐ hé ná vǎ vè̤́htekyǎ khǐné tahe nuôma má̤prè́ Beelzebul dyé vǎ tè̤pro̤prya̤ akhu-akhyě prè́, thǐ hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ki vǎ vè̤́htekyǎ khǐné tahe ná Beelzebul a tè̤pro̤tè̤prya̤ prè́ hérò, thǐ khǒpacè̤̌ tahe vè̤́htekyǎ khǐnétahe ná ǔpě a tè̤pro̤tè̤prya̤ pě? Thǐ hébè yě athû́ prè́ nuô, thǐ khǒpacè̤̌ tahe ki khyáluô̌ athè́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Manárò, vǎ ki vè̤́htekyǎ khǐnékhǐnò̌ yětahe ná Cò́marya a tè̤pro̤tè̤prya̤ kihérò yěnuôma a zṳ̌luô̌hò́ ná Cò́marya ki hyǎ pốhtyěpốké̤ yěnuô a hyǎtuố̤hò́ dố thǐ o hò́. ");
INSERT INTO kyu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Bí kayǎ hè̌shyoresò̌ tôprè̤ opwǒ̤odwǒ ní̤dyé ná a takuô̤tabè̌ rò a opò̤́ ní̤dyé ahi akhè̌nuô, a tǎ̤muô̌tǎ̤tè̤ tahe lamé̤ cyá̤ to. ");
INSERT INTO kyu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Manárò, bí kayǎ hè̌shyoresò̌klò̌ ná è tôprè̤ hyǎsápé̤kyǎ è akhè̌nuô, a ki phyéphekyǎ lò̌ lǔ takuô̤tabè̌ dố a thè́lè̤ ní̤dyé yětahe rò a tǎ̤muô̌tǎ̤tè̤ yětahenuô, a ki ibě pé̤ lò̌ ná akhǒ tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kayǎ tôprè̤prè̤ dố a pó̤ ní̤dyékuô̌ vǎ to nuôma, má̤hò́ kayǎ dố a htékyǎ hò́ vǎ hò́. Kayǎ tôprè̤prè̤ dố a ihtuôplò́ cwó̤kuô̌ vǎ to nuôma má̤hò́ kayǎ dố a me̤ lṳpruốlṳpryǎ tè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Bí khǐnékhǐnò̌ tôduô̌ htecuốkyǎ htuô̌hò́ dố kayǎ tôprè̤ akǔ akhè̌nuô, a htecuố dố khǎlé̤krǎkrè tôpho rò a cuố myápṳ̌ akhǎlé̤ lé̤okuố tabè́thè́prá tadû́rò a ki myáhtye akhǎlé̤ tôpho꤮ to hérò, a hélya̤ ní̤dyé ané̤, ‘Vǎ ki ka̤khyě khyěthyá dố vǎhi dố vǎ lé̤htecuốkyǎ è nuôtômě héni,’ a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Rò bí a ka̤tuố̤ khyěthyá dố kayǎ nuôtôprè̤ a o akhè̌nuô, a ka̤myáhtye dố akhǎlé̤ lye̤ yěnuô, aplǐaphuố ryá, a o taná̤tashuô̌ twó̤ryá lò̌plǐ cò́ pwǒ̤tôcô. ");
INSERT INTO kyu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Rò a htecuố è́ka̤ní̤ pó̤ akhǒ dố a cyě̤ricyá̤ lốklò̌ cò́ ná lǔnuô thuô̌thyótôduô̌ cò́ rò èthǐ ka̤kanuô̌ o lahyǎ bínuô. Rò kayǎ nuôtôprè̤ ki cyě̤ lốklò̌ cò́ ná a khǎlé̤lye̤ nuô cò́ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bí Jesǔ hébèhtuô̌ ngó̤ phúyě akhè̌nuô, prè̤mò tôprè̤ o dố kayǎ oró̤oè́ aklè̌ rò a è́htǒcuố Jesǔ, “Prè̤mò dố a phúo ní̤dyé nè̤ rò a dyéǒnú ní̤dyé nè̤ nuôtôprè̤ nuôma má̤hò́ prè̤mò dố a ní̤bè tè̤sò̌ri hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Manárò Jesǔ hésû lǔ, “Kayǎ dố a ní̤bè má̤lakǒ tè̤sò̌ri nuôma má̤hò́ kayǎ dố a ní̤huô̌ Cò́marya alǎ̤angó̤ rò a cṳ̌e nuôtahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bí kayǎ bè́mṳ hyǎplu ná hyǎplu dố Jesǔ o akhè̌nuô, Jesǔ hé èthǐ, “Kayǎ yětôhtû̌ tahe acyě̤aricyá̤ nyacò́. Èthǐ cuốkwǐmyá tuố̤ vǎ tè̤me̤ tè̤pro̤tè̤prya̤ tôcô manárò vǎ ki dyéluô̌ pé̤tû́prè́ èthǐ tè̤pro̤tè̤prya̤ tôcô dố athyáná Prè̤pro̤ Jona nuô pǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Phú Jona htwǒhtya tè̤mátè̤dyǎ tôcô dố Ninevephú tahe agněnuô, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě a ki má̤ kuô̌dû tè̤mátè̤dyǎ tôcô dố kayǎ khǒnyá̤yě tôhtû̌ tahe agně pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tè̤cirya amò̤́nyě pǎ tônyěnuô, ké̤ dố cílya̤ tôkyě akhwímuố̤ Sheba ki ihtò tố̤kuô̌ ná kayǎ dố a htwǒprè̤ khǒnyá̤yě tôhtû̌ tahe pǎ rò a ki betè̤thû́ dố èthǐ yětahe alo̤ pǎ, me̤těhérò thyáphú a ní̤huô̌nò́ kuô̌ Khwí Solomo a tè̤ithyóithya dố a lốbǎ ná tè̤thíphè́ yětahe agněnuôrò, a o cò́ dố ké̤ye̤ dố aruô tôké̤ tadû́rò a hyǎ cò́. Rò vǎ hé thǐ, kayǎ dố aduklò̌lố cò́ ná Khwí Solomo nuô a o bíyě tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Shyé꤮ tè̤cirya amò̤́nyě pǎ tônyěnuô, vǐ̤ Ninevephú tahe ki ihtò rò betè̤thû́ dố kayǎ khǒnyá̤ yětôhtû̌ tahe alo̤ pǎ, me̤těhérò bí èthǐ ní̤huô̌bè Jona hésodônyǎ pé̤ èthǐ akhè̌nuô, èthǐ za̤ ní̤dû kyǎlò̌. Rò vǎ hé thǐ, kayǎ dố aduklò̌lố ná Jona nuô, a o bíyě tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ǔ isǐlǐ htuô̌ mi rò ǔ dyauốbí lǔ takhyá꤮ to, kimá̤torò ǔ dya lǔ dố cǒ̤lè̤̌ takhyá꤮ to. Thyáphú a ki lǐ pé̤ kayǎ dố a hyǎnuô̌ tahe agně rò, ǔ dyahtya è dố mikò̌rè̤́khu. ");
INSERT INTO kyu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Thǐ mèthèplò tahe nuôma athyáná mikò̌ tômě dố thǐ né̤klò̤́ agně yěnuôhò́. Thǐ mèthèplò ki lǐsè́ryá hérò, thǐ né̤klò̤́ sǐprè̤lò̌ luô̌lǐphó ryálò̌ hò́, manárò thǐ mèthè ki khí hérò, thǐ né̤klò̤́ sǐprè̤lò̌ a khílò̌plǐ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Me̤phúnuôrò tè̤lǐ o dố thǐkǔ yěnuô, thyáphú a ki htwǒ tǎ tè̤khítè̤lò̤ tǎmé̤nuô, rò̤ní̤ lahyǎ thǐné̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Phúnuôrò thǐ né̤klò̤́ sǐprè̤ ki lốbǎ ná tè̤lǐ, rò a ki o dố tè̤khítè̤lò̤ akǔ to hénuô, a ki lǐtakhè̌rasǒ lò̌ thǐ né̤sǐprè̤ thyáná mikò̌ tômě lǐ takhè̌rasǒhtya dố thǐgněnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bí Jesǔ hébèhtuô̌ akhè̌nuô, Pharisěophú tôprè̤ è́e lǔ dǐ rò a krwǒcuốkuô̌ dố lǔhi. Èthǐ kíré̤ e lahyǎ hò́ dǐ rò a cuố onyǎo lahyǎ dố dǐrè̤́ khǎshyé. ");
INSERT INTO kyu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesǔ kíré̤ esèe akhè̌nuô, a sǐplǐ kuô̌ǔ atakhu to rò Pharisěophú dố a kremyá lǔ yětôprè̤nuô, a khyéthukhyéthè́ kanó̤꤮ to, me̤těhérò Judaphú alé̤klǒ o ná bí ǔ e tyahí sè tonuô ǔ tǒbè sǐplǐré̤ takhu. ");
INSERT INTO kyu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Phúnuô akhu-akhyě Byacè Jesǔ hésû lǔ, “Pharisěophú thǐ, thǐ sǐplǐ ryá nyacò́ bělò̤́ ná dǐbě dố aklò̌ nuôtôkyě cò́. Manárò dố thǐ thè́plòkǔnuô, a lốbǎ cò́ ná tè̤kò́vè̌kò́pra e ní̤dyényě ná tè̤mǔmyá̤ricyá̤ thǐtahe cò́. ");
INSERT INTO kyu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kayǎ olốoklò̌ thǐ꤮, Cò́marya dố a byálya̤ tè̤aklò̌ yětôprè̤nuô, akǔ nuôma a byálya̤lya̤, má̤to è̌? ");
INSERT INTO kyu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tè̤ dố a o dố thǐ bělò̤́kǔ ná thǐ dǐběkǔ nuôtahenuô, dyékyǎ ná kayǎ sǒphásǒrya̤phú nuô tû́ma tè̤lò̌꤮ plǐ ki mwǒ̤plǐ lò̌ dố thǐgně prè́. ");
INSERT INTO kyu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Pharisěophú thǐ꤮ tè̤cirya ki bè má̤lakǒ cò́ thǐ pǎ, me̤těhérò thǐ phyé lò̤́vya̤lè, bòkhèlè ná lò̌꤮ thòtò̤̌byǎlè yětahenuôrò thǐ lǔtyǎ ná Cò́marya pwíshyétôpwí. Manárò thǐ myá bè́khutǎ̤phuôkyǎhò́ tè̤cò́tè̤te̤ ná tè̤mo̤ Cò́marya tahe hò́. Thǐ dyé pwíshyétôpwí nuôma amá̤ hò́. Tû́nuôhtuô̌to, thǐ tǒbè dyakyǎní̤ tè̤cò́tè̤te̤ ná tè̤mo̤ Cò́marya yěnuôtahe to. ");
INSERT INTO kyu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Pharisěophú thǐ꤮, tè̤cirya ki bè má̤lakǒ cò́ thǐ pǎ, me̤těhérò thǐ thè́zṳ̂́ onyǎo lahyǎ khǎlé̤ htyalô̌ dố ǔ bezṳ̂́benyá̤ è dố tè̤cò́bè̌hǒkǔ nuôtahe, htuô̌to dố klè́kǔ nuôbèbè thǐ thè́zṳ̂́ nò̌hébè bezṳ̂́ ní̤ ǔ ná thǐné̤. ");
INSERT INTO kyu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Tè̤cirya ki bè má̤lakǒ cò́ thǐ pǎ, me̤těhérò thǐ thyáná luô̤̌khu dố ǔ me̤máme̤dyǎ lǔ to tahe, rò kayǎ tahe cuố dố lǔkhu tadû́rò ǔ thè́gně ná luô̤̌khu má̤to.” ");
INSERT INTO kyu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Prè̤ithyó tè̤thyótè̤thya athárá tôprè̤ hé Byacè, “Thárá꤮, nè̤ hé ngó̤ yětômû̌ nuôma nè̤ hé takhwótakè hé mǔmyá̤ricyá̤ prè́ pè̤ vǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Rò Jesǔ hésû è, “Prè̤ithyó tè̤thyótè̤thya athárá thǐ꤮, tè̤cirya ki bè má̤lakǒ kuô̌ cò́ thǐ pǎpǎ, me̤těhérò thǐ dyahtya tè̤thyótè̤thya dố ǔlo̤ dố athyáná tè̤vítè̤zá dố ǔvíǔzá zǔ è to tahe, manárò thǐ rò, thǐ ki cò̤̌cwó̤ pé̤kuô̌ǔ tè̤vítè̤zá yětahe agněnuô, thǐ ki cò̤̌htyacwó̤ kuô̌ prè́ ná thǐ kanò̌ tômě prè́nuô, thǐ hyǎtôbè to. ");
INSERT INTO kyu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Thǐ bèbè, Cò́marya ki cirya má̤lakǒ cò́ thǐ pǎ, me̤těhérò thǐ byá pé̤ prè̤pro̤ dố thǐphyěthǐphuô̌ me̤thyě èthǐ mú꤮ nukhè̌ nuôtahe aluô̤̌kǔ ná lò̤́ nuô̌. ");
INSERT INTO kyu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Phúnuôrò thǐ dyéluô̌ lǐphó cò́hò́ thǐné̤ ná thǐ thè́plò oícû̌ tố̤kuô̌, thǐ thè́plò thyákuô̌hò́ ná thǐphyěthǐphuô̌ dố꤮ nyénu tahe me̤tè̤thû́ nuôtahe hò́. Me̤těhénuô thǐphyěthǐphuô̌ tahe rò a yǒ me̤thyě prè̤pro̤ nuôtahe, thǐ rò thǐ yǒ byá pé̤ prè̤pro̤ nuôtahe aluô̤̌kǔ a yǒ me̤nuô̌. ");
INSERT INTO kyu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dố tè̤ritè̤kyǎ yětôcô akhu-akhyě, Cò́marya o ná a tè̤thíphè́ rò a hé, ‘Vǎ ki nò̌hyǎ pé̤ èthǐ prè̤pro̤ tahe, ná prè̤dônyǎphú tahe pǎ, rò èthǐ ki me̤thyěkyǎ tahehe pǎ, taheherò èthǐ ki me̤cyě̤me̤cṳ̂ lǔ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Phúnuô akhu-akhyě cáhtya dố hekhuhtwǒlú mò́khuhtwǒthè̌ akhè̌, lò̌꤮ kayǎ dố a me̤thyě prè̤pro̤ tahe a tè̤thû́nuô, Cò́marya ki cirya dố kayǎ yětôhtû̌ yětahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Vǎ hé thǐ꤮, cáhtya bí Adam aphú me̤thyě ní̤dyé apuố̤ Abělè nuôrò tuố̤hyǎ dố ǔ me̤thyě Zekaria dố tè̤lǔtyǎ akhǎlé̤ ná tè̤khǎlé̤sǎsè̌ aplèkǔnuô, Cò́marya ki cirya má̤lakǒ cò́ dố thǐ yětôhtû̌ tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Prè̤ithyó tè̤thyótè̤thya athárá thǐ꤮, tè̤cirya ki bè má̤lakǒ cò́ thǐ pǎ, me̤těhérò thò́hti dố ǔ lé̤vǐ̤mǒ tè̤thíphè́ ahi akadǎ yěnuô, thǐ phyécuốkyǎ. Thǐné̤ ní̤dû rò thǐ nuô̌ toto, kayǎ dố a thè́zṳ̂́ cuốnuô̌ tahe rò thǐ me̤tǎ̤tṳ̂̌ èthǐ thǐ.” ");
INSERT INTO kyu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bí Jesǔ htecuốkyǎ htuô̌hò́ èthǐ khǎlé̤ akhè̌nuô, prè̤ithyó tè̤thyótè̤thya athárá tahe ná Pharisěophú tahenuô, a me̤takhwótakè nyacò́ lǔ rò pṳ̌ sudyǎhtǒsudyǎlya̤ è́lǎ lǔ ngó̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Thyáphú èthǐ ki pṳ̂́ní̤ lǔ tè̤hébèthû́ tahenuôrò, èthǐ opò̤́ ní̤dǎ lǔ tè̤hébè tahe. ");
INSERT INTO kyu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bínuôkhè̌ kayǎ bè́mṳ dố aríkǔ hyǎ oplò́oplu bǎtapí lò̌ cò́, a tuố̤ cò́ dố tôprè̤ ná tôprè̤ zí̤bè khyě cò́ lǔ akhè̌nuô, Jesǔ héso-one a khǒpacè̤̌ tahe, “Rò̤ní̤ lahyǎ thǐné̤ ná Pharisěophú tahe ahuô̌mû dố èthǐ cyé̤zò́cò́te̤ byeprè́ ané̤ nuôtahe ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lò̌꤮ tè̤ dò́uốdò́bí tahenuô, Cò́marya ki bámǒhtya luô̌lò̌ è pǎ, rò lò̌꤮ tè̤me̤huôme̤thwè́ tahenuô, Cò́marya ki me̤hteluô̌lò̌ è pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Phúnuô akhu-akhyě ngó̤ dố nè̤ hébè dố mò̤́khí tahenuô, ǔ ki ní̤huô̌ke è dố mò̤́sè̌klè̌ pǎ. Htuô̌rò ngó̤ dố nè̤ hébèhuôhébèthwè́ è dố hidò́kǔ tahenuô, ǔ ki htya è́htǒluô̌ è dố hikhuklwókhu pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Vǎ khǒbò́thyó thǐ꤮, vǎ hé thǐ, kayǎ dố a me̤thyě cyá̤ thǐ né̤klò̤́ tadû́rò dốkhyěnuô, a me̤cyě̤me̤cṳ̂ cyá̤ pǎ thǐ to tahenuô, thè́isě tǎ è tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Thǐ tǒbè thè́isě ǔpě nuô, vǎ ki dyéluô̌ pé̤ré̤ thǐ. Thè́isě lahyǎ Cò́marya dố a me̤thyě cyá̤ thǐ né̤klò̤́ rò dốkhyěnuô a o pǎ ná a tè̤pro̤tè̤prya̤ dố a ki vǐtǎ̤ thǐ dố Mò́rapò̤tya̤ kǔ pǎ yěnuô tôprè̤ ní꤮. Vǎ ki hé pó̤ khyěthyá thǐ ná thè́isě lahyǎ è ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Htupré̤phú nyǎ̤bènuô ǔ isè̌ prè́ lǔ ná rû̌zye nyǎ̤myé prè́ vǎhéto? Manárò Cò́marya sǒtapa̤ èthǐ tôbè꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lò̌꤮ thǐ khuluô̤ dố thǐ khuklò́lo̤ nuôtahe cò́rò, Cò́marya dyábè one htuô̌lò̌plǐ cò́hò́. Thè́isě tǎmé̤! Thǐ ngṳdupri̤du klò̌lố cò́ ná htupré̤phú nuô tôplutôphè cò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Vǎ hé thǐ, ǔpěpě꤮ bèbè a ki ò́lya̤ ná Jesǔ Krístu ma vǎ Byacè dố kayǎ è́prè̤ a mèthènyě hénuô, prè̤lu aphúkhǔ má̤hò́ vǎyě, vǎ ki ò́lya̤kuô̌dû è phúnuô dố Cò́marya a tanémò́khuphú tahe a mèthènyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Manárò ǔpěpě꤮ bèbè a ki htésûbíkyǎ vǎ ná a zṳ̂́e vǎ to dố kayǎ è́prè̤ a mèthènyě hénuô, prè̤lu aphúkhǔ má̤hò́ vǎyě, vǎ ki htésûbíkyǎ kuô̌ è dố Cò́marya a tanémò́khuphú tahe a mèthènyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Lò̌꤮ kayǎ dố a héthû́ prè̤lukayǎ aphúkhǔ má̤hò́ vǎ yěnuô, Cò́marya ki plwǒkyǎ lǔtè̤thû́ prè́. Manárò kayǎ dố a héthû́ Thè́ Sǎsè̌ Byacè nuô, Cò́marya plwǒkyǎ cyá̤ pǎ èthǐ tè̤thû́ to. ");
INSERT INTO kyu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Shyé꤮ ǔ pṳ̂́thǔcuố thǐ dố tè̤cò́bè̌hǒkǔ pǎ akhè̌nuô bèbè, dố khwídu tahe anyěhyǎ pǎnuô bèbè, ná dố prè̤pốhtyěpốké̤ tahe a mèthènyě akhè̌pǎnuô bèbè, nè̤ tǒbè hébè takè̤bí ní̤dyé nè̤né̤ phútě rò nè̤ tǒbè hésû phútěnuô bèkṳ́bèkyǎ̤ tǎmé̤ ní. ");
INSERT INTO kyu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Me̤těhérò shyé꤮ nè̤ tǒ hébèhò́ ashuốakhè̌ pǎnuô, Thè́ Sǎsè̌ Byacè ki ithyótǎ̤ dû nè̤ ná nè̤ tǒbè hébè phútě pǎ nuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dố kayǎ è́prè̤ aklè̌ tôprè̤nuô a hé Byacè Jesǔ, “Thárá꤮ hé pé̤kuô̌ vǎ vyá̤prè̤khǔ ná a ki ibě pé̤kuô̌ vǎ ucè̌tazè̌ dố pè̤phè̌ bekyǎ pé̤ pè̤nuô tahe.” ");
INSERT INTO kyu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Rò Jesǔ hésû è, “Ma ǔpě dyahtya vǎ ná vǎ ki htwǒ pé̤ thǐ prè̤cirya tè̤, má̤torò prè̤ ibě pé̤ thǐ ucè̌tazè̌ dố thǐ thè́nyě̤ aplèkǔ nuô pě.” ");
INSERT INTO kyu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Htuô̌rò a hé pó̤ èthǐ, “Orò̤oryě̤ lahyǎ, cuốvò̤ khè̌vò̤kyǎ lahyǎ tè̤myápṳ̌ kò́vè̌kò́pra e ní̤dyé dûgně nuôtahe ní꤮, me̤těhérò kayǎ tôprè̤nuô, a duzá̤htyathè̌ cò́bátě꤮ bèbè, a tè̤duzá̤htyathè̌ yěnuô a me̤ryá cwó̤cyá̤ lǔ tè̤ohtwǒprè̤ tôcô꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Htuô̌rò Jesǔ hé èthǐ ná ngó̤khákho tômû̌, “Bètôphuốnuô kayǎ duzá̤htyathè̌ o tôprè̤, rò a o ní̤dyé ná aprè́ tôlé̤ rò a tè̤mò̤́tè̤bǒ tahenuô, a thètwó̤thèryá nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Rò a tane̤ ní̤dyé ané̤, ‘Vǎ lé̤klò̤̌plò́ vǎ thòthèvèphǒ yětahe agněnuô, a khǎlé̤khǎbya o pǎ to hò́, rò vǎ bè me̤ phútě?’ ");
INSERT INTO kyu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Yětôphuốrò a hé, ‘Vǎ ki me̤phúyě pǎ héni, vǎ ki me̤pruốkyǎ vǎ cyǎ yětahe rò vǎ ki isò́htyadu isò́htyalyá̤ taple klò̌ ná yětahe, rò vǎ ki klò̤̌plò́dyaplò́ lò̌ ná vǎ thòthèvèphǒ, vǎbuốvǎhuô̌ ná vǎ tǎ̤muô̌tǎ̤tè̤ tahe bínuô pǎ héni. ");
INSERT INTO kyu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Htuô̌rò vǎ ki hélya̤ ní̤dyé vǎné̤, Phè̌bwíryá, nè̤ dya-oplò́ lò̌ hò́ tè̤pwǒ̤꤮ tôcô dố nè̤ ki eǒní̤ nyě̤ ní̤dyé cò́ è è́naè́lè̌ cò́ pǎ. Omyě ná emò̌, ekò́ǒbǎ, okacṳ́kabè́ mò̌.’” ");
INSERT INTO kyu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Manárò Cò́marya hé lǔ, ‘Phè̌olốoklò̌, yětôthè̌ pǎ ma vǎ ki phyéhtekyǎ hò́ nè̤ thè́htwǒprè̤ pǎ. Phúnuôrò lò̌꤮ tè̤ dố nè̤ beplò́ one dố nè̤gně yětahenuô ǔpě tôprè̤ ki ní̤bè pǎ pě?’” ");
INSERT INTO kyu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Rò Jesǔ hé, “Kayǎ tôprè̤prè̤ dố a beplò́ ní̤dyédû a tè̤duzá̤htyathè̌ dố agně, manárò dố Cò́marya a mèthènyěnuô, a ki sǒphásǒrya̤ hénuô a ki htwǒhtya thyáphú yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Htuô̌rò Jesǔ hé a khǒpacè̤̌ tahe, “Phúnuô akhu-akhyě vǎ hé thǐ, bèkṳ́bèkyǎ̤ tǎ dố thǐ tè̤ohtwǒprè̤ agněnuô tǎmé̤. Thǐ loe loǒ agně bèbè, thǐ lokû̌lothyá bíná thǐ né̤klò̤́ agně bèbè, bèkṳ́bèkyǎ̤ tǎ lahyǎ tǎmé̤ ní. ");
INSERT INTO kyu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Me̤těhérò thǐ tè̤ohtwǒprè̤ nuô a lodulốklò̌ pǎ cò́ ná thǐ lé̤elé̤ǒ cò́, rò thǐ né̤klò̤́ yěnuô a lodulốklò̌ pǎ cò́ ná thǐ lé̤kû̌lé̤thyá tahe cò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tane̤myá lahyǎ cò́vè tahenuô, èthǐ isò́iplû̌ kuô̌ǔ tè̤klwǐtè̤lwí to, a kè́plò́bedwó kuô̌ǔ tè̤thètè̤phǒ to. A lé̤beplò́ lé̤elé̤ǒ khǎlé̤ o kuô̌ǔ to, a lé̤beplò́ buốcyǎ o kuô̌ǔ to tadû́rò Cò́marya buôebuôǒ èthǐ. Phúnuôrò, thǐ yětahenuô, thǐ ngṳdupri̤du lốklò̌ cò́ ná htu yětahe cò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dố thǐkṳ́thǐkyǎ̤ akhu-akhyěrò, thǐ cwihtǔhyǎ è́htya cyá̤ ní̤dyéklò̌ pó̤ thǐ mò̤́nyěmò̤́thè̌ takiphú prè́nuô a o tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Cwihtǔhyǎ pó̤ mò̤́nyě phúyě takiphú prè́ rò, thǐ ki me̤cyá̤to hénuô thǐ cuố bèkṳ́bèkyǎ̤ tuố̤ tè̤ dố aruô tahe me̤tě? ");
INSERT INTO kyu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tè̤phǒtè̤kí̤ nuôtahe a phè́htyaphǒhtya lahyǎ phútěnuô, tane̤ myámò̌ lahyǎ. Èthǐ erya̤ kuô̌ǔ tôcô꤮ to, a ihí kuô̌ǔ taphyá to tadû́rò vǎ hé thǐ꤮, Khwí Solomo dố a o cò́ ná a tè̤duzá̤htyathè̌ lò̌꤮ plǐ cò́ yětôprè̤nuô, a hyeca̤ dố atwó̤ krṳ̂nya̤lè́ ná tè̤phǒ nuôtôphǒ prè́nuô a o tôba꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kố꤮ kayǎ tè̤zṳ̂́patí thǐ꤮, mi̤mò̤́ tahenuô, yětônyě a o lahyǎ dố nyekhu, parǒpǎ ǔ isû́nuô̌kyǎ è dố mikǔ prè́ tadû́rò Cò́marya dyékû̌dyéthyá è kihérò a ki dyékû̌dyéthyá ryá lốklò̌ pǎ cò́ thǐ ná nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Phúnuô akhu-akhyě, bèkṳ́bèkyǎ̤ bèzò̤bèthi tǎ lahyǎ tǎmé̤. Tǒ ekryá pǎ ǐtě, tǒ ǒkryá pǎ ǐtěnuô, tane̤ tǎ lahyǎ tǎmé̤ ní. ");
INSERT INTO kyu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Me̤těhérò, kayǎ dố a zṳ̂́enyá̤e kuô̌ǔ Cò́marya to tahenuô, akṳ́akyǎ̤, a myápṳ̌myávyá̤ lahyǎ phúnuôhò́. Tè̤ dố thǐ lo tahenuô thǐ phè̌ thè́gnědû hò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bèzò̤bèthi tǎ lahyǎ phúnuô tǎmé̤! Myápṳ̌ lahyǎ tè̤ dố a lodu dố Cò́marya ahtyěaké̤kǔ nuôtahe rò lò̌꤮ tè̤dố thǐ lo yětahenuô, Cò́marya ki dyé kuô̌pó̤dû thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kố꤮ thímímṳ patíphú thǐ꤮, thè́isě tǎmé̤ ní꤮, me̤těhérò thǐphè̌ thè́plòo dố a ki dyé thǐ ná ahtyěaké̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Isè̌kyǎ thǐ tǎ̤muô̌tǎ̤tè̤ tahe rò me̤lǔ ná kayǎ sǒphásǒrya̤phú nuôtahe. Thǐ ki me̤phúnuô hérò thǐ benuô̌ oplò́ lahyǎ hò́ thǐ tè̤duzá̤htyathè̌ dố rû̌pyě̤ dố a lazè̤̌ pé̤to yěnuôtahe akǔ hò́. Dố thǐ dyé kayǎ sǒphásǒrya̤phú tahe phúnuô khukhyě, a ki htwǒhtya pé̤ thǐ tè̤duzá̤htyathè̌ dố mò́khu pǎ. Thǐ ki dya-oplò́ dố mò́khu hénuôma, thǐ tè̤duzá̤htyathè̌ yětahenuô a yokalya̤ tó̤cyá̤ tôphuố꤮ to, prè̤ehuôehí tahe ehuôcyá̤to, akrè̤́ahtwo me̤pyé cyá̤ to akhu-akhyě dya-oplò́ lahyǎ dố mò́khunuô. ");
INSERT INTO kyu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Me̤těhérò, thǐ tè̤duzá̤htyathè̌ obítě tôphonuô, thǐ thè́plò otố̤kuô̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Otaritaryǎ one lahyǎ thǐné̤ dố thǐ ki me̤ tè̤me̤ agně, rò nyá̤htya one lahyǎ thǐnyá̤htò́, sǐlǐ one lahyǎ thǐmi tahe. ");
INSERT INTO kyu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Me̤ lahyǎ phú hibyacè o dố pwè̌ ka̤sǒmè̤̌sǒdya ka̤ rò alulé tahe opò̤́sûní̤ lǔnuô. Bí a ka̤ dònuô̌ kadǎ akhè̌nuô, alulé tahe bámǒ pé̤ lǔ kadǎ tôphuốtuô̌. ");
INSERT INTO kyu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Lulé dố abyacè ka̤myáhtye èthǐ ná a othǎklyǎ, a otaritaryǎ one lahyǎ ané̤ tahenuô, a ní̤bè lahyǎ tè̤sò̌ri. Vǎ hé má̤lakǒ cò́ thǐ, Byacè yětôprè̤nuô a ki kû̌htyathyáhtya prè̤me̤tè̤phú ahyeca̤ rò a ki nò̌onyǎo èthǐ thyáná sǐpré̤ tahenuô pǎ, rò a ki buôebuôǒ èthǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A ki ka̤ dố mò̤́ne̤khè̌ bèbè, má̤torò dố mò̤́lǐro̤mû́ ǔ omyěpǎ akhè̌ bèbè, a ki ka̤myáhtye ná èthǐ otaritaryǎ one ané̤ hénuôma, èthǐ ki ní̤bè má̤lakǒ cò́ tè̤sò̌ri pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Manárò thè́né̤htyabè lahyǎ vǎ ki hé pé̤ thǐ yěnuô ní꤮. Hibyacè ki thè́gně ná prè̤ehuô kíré̤ hyǎ ashuốakhè̌ hénuôma a ki opò̤́sû rò prè̤ehuô hyǎnuô̌bû to. ");
INSERT INTO kyu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Rò thǐ yětahenuô bèbè, otaritaryǎ one kuô̌ lahyǎ thǐné̤ ní꤮, me̤těhérò shuốkhè̌ bí thǐ tane̤tuố̤ to pǎnuô, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petru hé, “Byacè꤮ nè̤ hé ngó̤khákho yěnuôma dố pè̤gně è̌? Má̤toma, kayǎ pwǒ̤꤮ tôprè̤ agně è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Byacè hésû lǔ, “Phúnuôrò, a htwǒ lulékhuklò́ dố acò́ rò a o ná tè̤thíphè́ tôprè̤ma ǔpě? Lulékhuklò́ dố acò́ yětôprè̤ nuôma má̤hò́ kayǎ tôprè̤ dố abyacè ki dyétǎ̤ lò̌ alulé aruôtahe dố lǔ takhukǔ rò a ki nò̌myánò̌khwèní̤ lǔ ná èthǐ, rò è ki dyéetǒdyéǒbè pé̤ ǔ ashuốakhè̌ tôphuố ná tôphuố nuôtôprè̤ pǎ má̤to è̌? ");
INSERT INTO kyu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Abyacè ki ka̤myáhtye ná a lulékhuklò́ yětôprè̤ me̤ tè̤me̤ kihérò a ki dyé lǔ tè̤me̤ní̤khwókè pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Vǎ hécò́cò́꤮ cò́ thǐ, Byacè yětôprè̤ a tǎ̤muô̌tǎ̤tè̤ lò̌꤮ plǐnuô a ki dyétǎ̤lò̌ dố lǔ khadǎkǔ pǎ rò a ki nò̌myánò̌khwè ní̤ ná lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Manárò lulékhuklò́ yětôprè̤ ki hélya̤ ní̤dyé ané̤, ‘Phû꤮ ná vǎbyacè ka̤khyěma anyě̤꤮ lǎ pǎ kǒle,’ a hé rò amṳ̂̌apò̤ní̤ lulé prè̤mòprè̤khǔ tahe, htuô̌rò a emṳ̂ǒpryá. ");
INSERT INTO kyu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Rò shuốkhè̌ bí a tane̤ tuố̤to rò a eǒ sǒtapa̤ tônyěnuô, abyacè ki ka̤khyětǒ bínuô tônyě pǎ. Abyacè ki ciryacyě̤ ciryacṳ̂ lǔ pǎ rò a ki dyanuô̌ tố̤kyǎ lǔ ná kayǎ dố a zṳ̂́e kuô̌ǔ Cò́marya to nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Lulékhuklò́ dố a thè́gněhò́ abyacè a tè̤thè́zṳ̂́ tadû́rò a ki o taritaryǎ one ané̤ to, htuô̌to a ki me̤phú abyacè a tè̤thè́zṳ̂́nuô to hénuô, abyacè ki cirya plísè̌ nyacò́ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Manárò lulékhuklò́ dố a thè́gně abyacè a tè̤thè́zṳ̂́ to tôprè̤nuô, ki a me̤thû́ tè̤ tôcôcô dố a tǒkò plí lǔ hénuô, abyacè ki cirya plísè̌ yakhyeklò̌ lǔ pǎ. Kayǎ dố a ní̤bè è́ tè̤cyá̤tè̤dè tôprè̤prè̤nuô, Cò́marya myásû̌ní̤ lǔ dố a ki bème̤ è́lốklò̌ ná ǔ. Kayǎ dố Cò́marya zṳ̂́ení̤ lǔ rò a dyé è́lốklò̌ lǔ tôprè̤nuô, Cò́marya kwǐ è́klò̌lố lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Vǎ hyǎ vǐtǎ̤ tè̤cirya mi dố hekhuyě hò́. Vǎ thè́zṳ̂́ nò̌û̌htya lǎ hò́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Manárò tè̤plwǒhtyě dố vǎ lo plwǒ nuô a opǎ tôcô. Tè̤me̤ yětôcô ki htuô̌talwó híto rò vǎ thè́plò bèkṳ́bèkyǎ̤ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ma thǐ tane̤ ná vǎ phyéhyǎ tè̤pě̤tè̤dwǒ dố hekhu yěnuô è̌? Vǎ hé thǐ꤮, vǎ phyéhyǎ tè̤pě̤tè̤dwǒ má̤to. Vǎ hyǎlya̤ me̤pruốme̤pryǎ tè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cáhtya khǒnyá̤yě tǎ̤plehyǎ nuô, kayǎ tômuố̤ rò a ki o thè́nyǎ̤ hénuô thè́thuô̌ rò a ki o tôkyě pǎ, dố yě thè́gně rò a ki o tôkyě pǎ rò èthǐ ná èthǐ ki thè́htethè́hǎ ní̤dyé khyědû lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Èthǐ ná èthǐ ki lṳ sipruốsipryǎ lò̌ lǔ pǎ. Phè̌ tahe ki thè́hte ní̤dyé a phúprè̤khǔ tahe pǎ, rò phúprè̤khǔ tahe ki thè́hte ní̤dyé aphè̌ tahe pǎ. Muố̤ tahe ki thè́hte ní̤dyé phúmò tahe pǎ, rò phúmò tahe ki thè́hte ní̤dyé amuố̤ tahe pǎ, prè̤́prè̤mò tahe ki thè́hte ní̤dyé adya tahe pǎ, rò adya tahe ki thè́hte ní̤dyé a prè̤́prè̤mò tahe pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesǔ hé pé̤ kayǎ bè́mṳ tahe, “Bí thǐ myáhtye ò́luố̤tahe htya dố cínuô̌ tôkyě akhè̌nuô, tôphuốtuô̌ thǐ hé dû, ‘Ké̤ kíré̤ cṳ̂ hò́,’ rò ké̤cṳ̂ má̤lakǒ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Rò bí ké̤lathè́ hyǎ dố cílya̤ tôkyě akhè̌nuô, thǐ hé, ‘Ké̤kṳ́ hò́ pǎ,’ rò ké̤kṳ́ má̤lakǒ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Prè̤ cyé̤zò́cò́te̤ byeprè́ ané̤ thǐ꤮, thǐ myá hekhu ná mò́lè̤̌ rò tè̤ ki htwǒhtya phútě pǎnuô thǐ myálwó thè́gněone ré̤ cò́ tadû́rò Cò́marya me̤htwǒhtya tè̤ khǒnyá̤yě tahe angó̤lasánuô, thǐ myálwó thè́gněone ré̤ cyá̤to me̤tě? ");
INSERT INTO kyu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tè̤ dố a kòme̤ ná a kòme̤to nuô, thǐ bè sudyǎlya̤ ní̤dyédû thǐ thè́plò. ");
INSERT INTO kyu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bí kayǎ dố a thè́hte nè̤ tôprè̤ è́htya nè̤ dố pokáhi akhè̌nuô, yácû́ me̤krṳ̂̌me̤klè̌ pryǎré̤lè́kyǎ è dố klyálo̤nuô. Pǎma a ki è́htya nè̤ dố pokáhi rò prè̤ciryatè̤ ki dyétǎ̤ dǐtû́ nè̤ dố prè̤me̤tè̤phú a takhukǔ pǎ rò a ki dò́nuô̌kyǎ nè̤ dố htò̌kǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Vǎ hé thǐ꤮, nè̤ ki plálǐlò̌bè́ nè̤su yěnuô to hénuôma, nè̤ htebè́ to.” ");
INSERT INTO kyu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bínuôkhè̌ kayǎ tahe hyǎ hésoluô̌ Jesǔ ná bí Galileaphú tahe lǔtyǎhtya akhè̌nuô, Roma Khwí Pilato aklyěphú tahe me̤thyě èthǐ. ");
INSERT INTO kyu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Rò Jesǔ hésû èthǐ, “Ǔ me̤thyě Galileaphú tahe phúyě rò thǐ tane̤ ná èthǐ ma a tè̤thû́tè̤ora tahe mǔmyá̤ricyá̤klò̌ ná lò̌ Galileaphú dố aruôtahe phúnuô è̌? ");
INSERT INTO kyu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Vǎ hé thǐ, èthǐ mǔmyá̤ricyá̤klò̌ ná thǐ má̤to. Thǐ bèbè, thǐ ki za̤ ní̤dûkuô̌ lahyǎ thǐné̤ to hénuôma, thǐ ki thyě kuô̌ lò̌ pwǒ̤꤮ tôprè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bí Siloa hihtyalô̌ nuôtômě latǎ̤prò̤ thyě kayǎ shyélwǐ̤thyó akhè̌nuô, thǐ tane̤ ná èthǐ ma a tè̤thû́tè̤ora o è́klò̌ ná lò̌꤮ kayǎ aruô dố a o lahyǎ dố vǐ̤ Jerusalem akǔ nuôtahe è̌? ");
INSERT INTO kyu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Amá̤to, vǎ hé thǐ, thǐ yětahe bèbè, thǐ ki za̤ ní̤dû lahyǎ thǐné̤ to hénuôma, thǐ ki thyěkuô̌ lò̌ pwǒ̤꤮ tôprè̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Htuô̌rò Jesǔ dônyǎ pé̤ èthǐ ná ngó̤khákho tôtó̤ rò a hé, “Bètôphuố, kayǎ o tôprè̤, rò dố a thòthèphè lé̤khunuô, a isò́o ní̤dyé kuô̌ a kadwímò̤́ tômò̤́. Rò a cuố myápṳ̌ ba-e ní̤dyé a kadwíthè, manárò a myáhtye athè o tôplò꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Rò, a hé prè̤myákhwèní̤ thòthèphè yěnuô, ‘Vǎ hyǎ myápṳ̌ ba-e kadwímò̤́ nuô tôthò athènuô a bǎhò́ thuô̌na hò́ tadû́rò vǎ myáhtye athè tôplò꤮ to. Ikwǒ̤ khû́kyǎ è nuô, a o dídyǎkyǎdě prè́ hekhu prè́.’ ");
INSERT INTO kyu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Manárò prè̤myákhwè thòthèphè yětôprè̤ hésû lǔ, ‘Byacè꤮, myá pó̤ kuốré̤ prè́ yětôna nuôprè́. Vǎ ivè̤̌ tava̤ ré̤ akhǎshyé pǎ rò vǎ sunuô̌ ná asè pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nabè pǎ ma a klyá thèryá nyǎ dû pǎ. A ki thèto hé pǎ rò vǎ ikwǒ̤kyǎ dû è pǎ.’” ");
INSERT INTO kyu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bí Judaphú Mò̤́nyěduô bè tônyěkhè̌nuô, Jesǔ ithyóithyatǎ̤ ǔ dố tè̤cò́bè̌hǒ tômě akǔ. ");
INSERT INTO kyu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bí tè̤cò́bè̌hǒkǔ nuô, prè̤mò dố khǐné me̤bè lǔ rò aswí nyá̤dákhò̌ otyá̤ o tôprè̤. A khyábè phúyěnuô anyě̤ cò́hò́ ana shyélwǐ̤thyó cò́ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bí Jesǔ myáhtye lǔ akhè̌ a è́hyǎ lǔ dố nyě rò a hé lǔ, “Mòmuố̤꤮, nè̤ tè̤sè̌ sǐmé̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Rò a dyahtya atakhu dố lǔlo̤ rò tôphuốtuô̌ anyá̤ cò́htyakhyě rò a htuthè́htya Cò́marya. ");
INSERT INTO kyu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Manárò Jesǔ zasǐmé̤ pé̤ ǔ tè̤swítè̤sè̌ dố Judaphú a Mò̤́nyěduô akhu-akhyě tè̤cò́bè̌hǒ khuklò́ yětôprè̤ thè́plòdu, rò a hé kayǎ bè́mṳ tahe, “Mò̤́nyěmò̤́thè̌ dố pè̤ tǒkò me̤ tè̤phyétè̤me̤ nuô, a o nyěthuô̌thyó cò́. Hyǎ zasǐmé̤ lahyǎ thǐ tè̤swí bí mò̤́nyě thuô̌thyóyě akǔnuô. Mò̤́nyěduô rò hyǎza tǎ lahyǎ thǐné̤ tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Rò Byacè hésû ka̤khyě lǔ, “Prè̤ cyé̤zò́cò́te̤ byeprè́ ané̤ thǐ꤮ thǐ pwǒ̤꤮ tôprè̤ ilyě lahyǎ thǐ pṳ́plye̤, má̤torò thǐ tathíplye̤ dố apo̤kǔ rò thǐ cwihtecuố buôǒ ahtyě bí Judaphú Mò̤́nyěduô akhè̌nuô má̤to è̌? ");
INSERT INTO kyu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Khǒnyá̤rò Abraham aklwǐlyǎ mòmuố̤ dố khǐnéricyá̤ khuklò́ nò̌cò̌klò̤ma khǐnékhǐnò̌ ná lǔ yě, a onyě̤ cò́hò́ ana shyélwǐ̤thyó nuô a obíyě tôprè̤. Rò ilyěhte siplè́kyǎ pé̤ è ná khǐnéricyá̤ khuklò́ cò̌klò̤ma lǔ yě bí Judaphú a Mò̤́nyěduô yěnuôma, a kò nyǎto è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bí Jesǔ hésû ngó̤ yětômû̌ akhè̌nuô, lò̌꤮ kayǎ dố a pṳ̌ lǔ tè̤thû́ nuôtahe thè́tarè̤̌ lya̤ ní̤dyé lò̌plǐ ané̤. Manárò Jesǔ me̤ tè̤pro̤tè̤prya̤ lò̌plǐ yě akhu-akhyě, kayǎ bè́mṳ thè́plòmo̤ lò̌plǐ cò́ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Htuô̌rò Jesǔ hé, “Cò́marya htyělé̤ké̤kǔ nuôma athyáná matě? Vǎ ki talô byábû̌myá pé̤ thǐ ná maǐtě? ");
INSERT INTO kyu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Cò́marya htyělé̤ké̤kǔ nuôma athyáná kayǎ tôprè̤ iluố̤dyá taplèplò tôplò dố aprè́khu nuôhò́. A phè́htya rò a duhtyahtǔhtya thyáná thòmò̤́nuô, rò tuố̤ cò́ dố htuphúzuố̤phú tahe hyǎme̤ lahyǎ apwi̤ dố aphyǎ tahe alo̤ cò́.” ");
INSERT INTO kyu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Rò Jesǔ hé pó̤, “Cò́marya htyělé̤ké̤kǔ nuôma vǎ ki talô byábû̌myá pé̤ thǐ ná maǐtě? ");
INSERT INTO kyu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cò́marya htyělé̤ké̤kǔ nuôma athyáná prè̤mò tôprè̤ phyéní̤ huô̌mû rò a cimû lwítố̤ dố dǐphè́ tôplutôphè aklè̌ rò athè̌ tapho htyalò̌plǐ dǐphè́ yěnuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bí Jesǔ cuố dố vǐ̤ Jerusalem akhè̌, a ithyóithya cuố rwó ǔ dố klyálo̤, tôvǐ̤ htuô̌ tôvǐ̤, tôdò̌htuô̌ tôdò̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Htuô̌rò kayǎ tôprè̤ sudyǎ lǔ, “Byacè꤮ kayǎ dố a ní̤bè tè̤me̤lwóhteka̤ tahenuôma, a o patíprè̤ prè́ è̌?” Rò Jesǔ hésû èthǐ, ");
INSERT INTO kyu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yácû́ cuốpṳ̌nuô̌ lahyǎ dố kadǎ a-i nuôtôkǔ, me̤těhérò, kayǎ tahe yácû́ cuốpṳ̌nuô̌ ró̤nyacò́ tadû́rò a nuô̌bè́ lahyǎ to. ");
INSERT INTO kyu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hibyacè ki kahtò me̤bíkyǎphe thǐ kadǎ tôphuố pǎ. Bínuôakhè̌ pǎ thǐ ki kahtò o dố aklò̌ pǎ rò thǐ ki dò kadǎ pǎ. Rò thǐ ki hé, ‘Byacè꤮ bámǒ pé̤kuô̌ré̤ pè̤ kadǎ.’ “Rò a ki hésû thǐ, ‘Thǐ ma kayǎ bítě nuô, vǎ thè́gněnò́ thǐ to.’ ");
INSERT INTO kyu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Bínuôakhè̌, thǐ ki hésû è, ‘Pè̤ eǒtố̤ htuô̌hò́ ná nè̤, nè̤ ithyóithyatǎ̤ htuô̌pé̤hò́ pè̤ dố pè̤ vǐ̤kǔ nuô vǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Manárò a ki hésû pó̤ thǐ, ‘Thǐ ma kayǎ bítě nuô vǎ thè́gněnò́ thǐ to. Lò̌꤮ thǐ yětahe nuôma kayǎ dố a me̤ tè̤mǔmyá̤ricyá̤ nuôtahe prè́, htecuố taphǎkyǎ ye̤ lahyǎ ná vǎ nuô.’ ");
INSERT INTO kyu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Dố Cò́marya htyělé̤ké̤kǔ nuô, thǐ myáhtye ná Abraham, Isaac, Jacob ná prè̤pro̤ lò̌꤮ plǐ nuôtahe hyǎ nuô̌lò̌ bínuô tadû́rò thǐ né̤byacè ní̤dû rò ǔ ki vè̤́htekyǎ thǐ dố aklò̌ pǎ. Tè̤khǎlé̤ bí thǐ ki cuố o yětôpho pǎnuô, thǐ ki cuố nguố̤plyá̤nguố̤rya̤ rò thǐ ki a̤takrṳ̂ ní̤dyé lò̌ cò́ thǐ khukhyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kayǎ o dố cínuô̌, cíhte, cíhtya, cílya̤ tahe ki hyǎ pǎ rò èthǐ ki hyǎnuô̌ onyǎphyé lahyǎ akhǎlé̤ dố Cò́marya ahtyěaké̤kǔ nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bínuô akhè̌pǎ nuô, kayǎ o dốkhyě tahe ki hyǎtuố̤ ré̤lố dố nyě pǎ, rò kayǎ o dố nyě tahenuô, a ki hyǎ tǎ̤nokyǎ dốkhyě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bínuôakhè̌, Pharisěophú tahe hyǎ dố Jesǔ o rò a hyǎ hé lǔ, “Nè̤ tǒ htecuố taphǎkyǎ dố aruô tôpho, me̤těhérò Khwí Herodè thè́zṳ̂́ me̤thyě nè̤.” ");
INSERT INTO kyu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Rò Jesǔ hésû èthǐ, “Cuốhéso pé̤ htwimi̤nuô, ‘Yětônyě ná parǒ pǎnuô, vǎ ki vè̤́htekyǎ khǐnékhǐnò̌ tahe pǎ, htuô̌rò vǎ ki zasǐmé̤ tè̤swítè̤sè̌ tahe pǎ. Thuô̌nyětônyě pǎnuô, vǎ ki me̤htuô̌kyǎ vǎ tè̤phyétè̤me̤ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Manárò yětônyě ná parǒ ná sǒví pǎnuô, vǎ tǒbè htecuố plehyǎ tadûpǎ klyá. Vǎ má̤hò́ Cò́marya aprè̤pro̤ yě bè cuốthyě nyǎ dố vǐ̤ Jerusalem akǔnuô pǎ hò́, me̤těhérò khǎlé̤ bínuôtôpho ma khǎlé̤ dố ǔ lé̤me̤thyě Cò́marya aprè̤pro̤ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Kố꤮ vǐ̤ Jerusalem, vǐ̤ Jerusalem꤮ prè̤pro̤ dố ǔ nò̌hyǎ èthǐ dố nè̤o tahenuô, taheherò nè̤ me̤thyěkyǎ èthǐ, taheherò nè̤ tá̤ èthǐ ná lò̤́. Phú shyěmuố̤ takò́takè̤bí ní̤dyé aphú dố adálè̤̌ nuô, vǎ yácû́ takò́takè̤bíní̤ tamǒmǒ cò́ nè̤ tadû́rò nè̤ thè́zṳ̂́ nò̌takè̤bí ní̤ vǎ ná nè̤né̤ to. ");
INSERT INTO kyu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Myámò̌ lahyǎ꤮ Cò́marya ki dya-okryákyǎ tû́dû thǐ tè̤lǔhǒdu yěnuô pǎ. Rò vǎ hé thǐ, thǐ ki myáhtye tadû prè́ vǎ ná shyé꤮ thǐ héhò́, ‘Kayǎ dố a hyǎ dố Cò́marya amwi̤kǔ yětôprè̤nuô, a ki ní̤bè dûhò́ tè̤sò̌ri ní꤮.’ Thǐ héhtuô̌hò́ phúnuôpǎrò thǐ ki myáhtye khyěthyá no vǎ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bètôphuố bí Judaphú Mò̤́nyěduô bè akhè̌nuô, Jesǔ cuố dố Pharisěophú khuklò́ tôprè̤ ahi. Bí a kíré̤ esè akhè̌nuô, kayǎ bínuô tahe myácǒhuô lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dố Jesǔ anyěhyǎ nuô kayǎ yábuô̌tò̤htyě o tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Rò Jesǔ sudyǎ prè̤ithyó tè̤thyótè̤thya athárá tahe ná Pharisěophú tahe rò a hé èthǐ, “Dố pè̤ lisǎsè̌ tè̤thyótè̤thya akǔnuô, zasǐmé̤ kayǎ bí Judaphú a Mò̤́nyěduô akhè̌ nuôma aní̤ nyǎ è̌? Ma aní̤ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Manárò èthǐ hésû lǔ tôcô꤮ to. Jesǔ behtya atakhu dố kayǎ yětôprè̤ alo̤ rò a zasǐmé̤ pé̤kyǎ lǔ, rò a plwǒ ka̤kyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Htuô̌rò Jesǔ hé èthǐ, “Bí Judaphú a Mò̤́nyěduô bè akhè̌nuô, thǐ phúkhǔ tôprè̤prè̤ kimá̤torò thǐ pṳ́ tôduô̌duô̌ ki latǎ̤ dố htyěklûkǔ hénuô, thǐ ki cuốphyéhtya cò́ lǔ tôphuốphyéhtya cò́ pǎ è̌? Ma to è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Manárò èthǐ héka̤khyěsû lǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bí sǐpré̤ dố Pharisěophú khuklò́ yětôprè̤ è́hyǎe èthǐ dǐ yětahe hyǎnuô̌ akhè̌nuô, a hyǎnwóphyé lahyǎ akhǎlé̤ dố aryá. Jesǔ myáhtye èthǐ me̤phúnuôrò a hékhoní̤ pé̤ èthǐ ná ngó̤khákho tôtó̤. ");
INSERT INTO kyu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bí ǔ mehyǎemehyǎǒ nè̤ dố kayǎ tôprè̤prè̤ a pwè̌khǒmè̤̌ akhè̌nuô, nwó onyǎ phyé tǎ khǎlé̤ dố aryá tǎmé̤, me̤těhérò kayǎ dố a htwǒ khuklò́ dố aduklò̌ ná nè̤ nuô, taryá꤮ ma ǔ mehyǎeǒ ní̤ cyá̤ kuô̌ è. ");
INSERT INTO kyu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ki ǔ mehyǎ tố̤kuô̌ è hérò hibyacè ki hé nè̤, ‘Dyéonyǎo pé̤ré̤ nè̤ khǎlé̤ yěnuô ná èyě ní,’ rò bínuôkhè̌ pǎ, nè̤ bè cuốonyǎkyǎ dố khǎlé̤ larṳ̂́lố tôpho pǎ rò nè̤ ki thè́tarè̤̌kyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aryálốma, ki ǔ mehyǎ nè̤ hérò cuốonyǎ dố khǎlé̤ larṳ̂́lố nuôtôpho. Nè̤ ki me̤phúnuô hérò, hibyacè ki hyǎ hé nè̤, ‘Khǒbò́thyó, htya-onyǎo dố akhu nuôtôpho,’ rò bínuôkhè̌pǎ, nè̤ ki mèthèo dố ǔ pwǒ̤tôprè̤ anyěhyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Me̤těhérò kayǎ tôprè̤prè̤ dố a phyédu ané̤nuô, ǔ ki shyatǎ̤ è pǎ, rò kayǎ tôprè̤prè̤ dố a shyalya̤ athè́ nuô, ǔ ki dyahtyalô̌ è pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Htuô̌rò Jesǔ hé kuô̌ke hibyacè, “Bí nè̤ taritaryǎ mò̤́htuô sèesèǒ akhè̌ bèbè, kimá̤torò mò̤́hé sèesèǒ akhè̌nuô bèbè, nè̤ khǒbò́thyó tahe bèbè, nè̤puố̤nè̤vyá̤ tahe bèbè, nè̤klwǐnè̤lyǎ tahe bèbè, nè̤hi khǎsò̌khǎshyé dố a duzá̤htyathè̌ tahenuô bèbè, è́ tǎ èthǐ tǎmé̤. Nè̤ ki è́e èthǐ phúnuô hérò èthǐ ki è́e ka̤khyěsû ke nè̤ pǎ rò thǐ me̤lyě̤me̤kè dyé prè́ lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Manárò bí nè̤ me̤pwè̌ akhè̌nuô, taritaryǎ sèesèǒ rò è́ pé̤ kayǎ dố a sǒphásǒrya̤ nuôtahe, kayǎdátarṳ nuôtahe, kayǎ khǎduôdá nuôtahe ná kayǎ mèthèkhí nuôtahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Rò nè̤ ki è́e kayǎ phúyě tahe hénuô, nè̤ ki ní̤bè tè̤sò̌ri pǎ, me̤těhérò èthǐ è́e ka̤khyěsûbè́ kuô̌ nè̤ tôcô꤮ to. Bí kayǎcò́te̤ tahe ihtòhtwǒprè̤ ka̤khyě dố tè̤thyě akhè̌ pǎnuô, Cò́marya ki dyékhyě nè̤ tè̤bwítè̤taryě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kayǎ onyǎo kuô̌ ná Jesǔ bí lé̤e dǐrè̤́khǎshyé nuôtahe aklè̌ tôprè̤nuô, a ní̤huô̌ tè̤hébèyě rò a hé Jesǔ, “Kayǎ dố a onyǎ eǒnò́ dố Cò́marya ahtyěaké̤kǔ pǎ tahenuô, a ki ní̤bè má̤lakǒ cò́ tè̤sò̌ri pǎ cò́!” ");
INSERT INTO kyu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Rò Jesǔ hé è, “Bètôphuố, kayǎ tôprè̤ me̤pwè̌du rò a buôebuôǒ ǔ, rò a mehyǎehyǎǒ è́nyacò́ kayǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bí pwè̌eǒ ashuốakhè̌ hyǎtuố̤hò́ akhè̌nuô, a nò̌cuốhéso alulé tôprè̤ ná kayǎ dố a mehyǎehyǎǒ htuô̌hò́ lǔ nuôtahe, rò a luléyě cuố hé, ‘Hyǎehyǎǒ lahyǎ mò̌ hénuô̌꤮, ǔ taritaryǎ one lò̌plǐ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Manárò tôprè̤ tôcôcô꤮ a kè̤htǒkè̤lya̤ ní̤dyé lò̌plǐ ná alè́ to. Aré̤lố tôprè̤ rò a hé alulé yěnuô, ‘Vǎ ipri̤ lyá̤ tôlé̤ rò vǎ tǒbè cuốmyá ní̤dyé è. Rò khyáthè́dǒ ré̤ vǎ ní꤮.’ ");
INSERT INTO kyu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Aruô tôprè̤ ke rò a hé, ‘Vǎ ipri̤ pṳ́ nyǎ̤sě rò vǎ tǒbè cuố nò̌emyá ní̤dyé è khǒnyá̤. Rò khyáthè́dǒ ré̤ vǎ ní꤮.’ ");
INSERT INTO kyu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Dố aruôtôprè̤ rò a hékuô̌ke, ‘Vǎ khǒmè̤̌htuô̌thè̌ mópǎprè́ rò vǎ hyǎbè́ to.’ ");
INSERT INTO kyu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Lulé yětôprè̤ ka̤khyě khyěthyá rò a ka̤héso pé̤ abyacè ná lò̌꤮ tè̤ritè̤kyǎ yětahe. Rò hibyacè yětôprè̤ thè́plòdu rò a hé alulé, ‘Htecuố pryǎpryǎ cò́ dố klyádukǔ nuô ná dố klyáphú nuôtahe akǔ, rò è́ka̤ lahyǎ kayǎ sǒphásǒrya̤phú, kayǎdátarṳ, kayǎ mèthèkhí, ná kayǎ khǎduôdá nuôtahe ní꤮.’ ");
INSERT INTO kyu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Alulé ka̤tuố̤khyě rò a hé abyacè, ‘Byacè꤮ vǎ cuốme̤htuô̌ lò̌hò́ phú nè̤ hétǎ̤ nè̤ngó̤ nuôtahe hò́, manárò khǎlé̤ odǎpǎ tahe.’ ");
INSERT INTO kyu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Phúnuô akhu-akhyě Byacè hé alulé, ‘Cuố kuô̌ke dố dò̌phúsophú nuôtahe akǔ rò nò̌hyǎ obǎ lò̌ dố vǎ hikǔyě. ");
INSERT INTO kyu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Vǎ hé thǐ, kayǎ dố vǎ mehyǎ è tahenuô, a hyǎ enò́ kuô̌ vǎ pwè̌eǒduyě tôprè̤꤮ to!’” ");
INSERT INTO kyu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tônyě akhè̌nuô, kayǎ krwǒ cuốró̤è́ kuô̌lǎ Jesǔ rò a tarí myáka̤khyě èthǐ rò a hé, ");
INSERT INTO kyu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kayǎ dố a thè́zṳ̂́ htwǒ vǎ khǒpacè̤̌ tôprè̤prè̤nuô, amuố̤aphè̌ bèbè, aphúamě bèbè, apuố̤avyá̤, ná ané̤byacè ní̤dû cò́ bèbè, a ki mo̤ lốklò̌ cò́ ná a mo̤ vǎ hénuôma a htwǒhtya cyá̤ vǎ khǒpacè̤̌ to. ");
INSERT INTO kyu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kayǎ tôprè̤prè̤ dố a krusu rò a zá ní̤dyédû toto, vǎkhyě rò a krwǒ toto tôprè̤nuô, a htwǒhtya cyá̤ vǎ khǒpacè̤̌ to. ");
INSERT INTO kyu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Hékuốré̤, dố thǐklè̌ tôprè̤prè̤ nuô, a ki tane̤-onehò́ ná a ki byáhtya hihtyalô̌ tômě kihérò, a ki lò̌ bá꤮ tě pǎ nuô a bè onyǎ dyámyá ré̤. Tuố̤dố a me̤htuô̌me̤plû́ lò̌ hi yětômě nuôma, arû̌ ki pò pǎ è̌ ma a pòto è̌ nuô a bè thè́gně ré̤. ");
INSERT INTO kyu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A ki me̤ré̤ phúnuôto, rò a ki byáhtyaré̤ ahi khǎduô, rò a ki me̤htya htuô̌plû́bè́ ahi yěnuô to hénuô, lò̌꤮ kayǎ dố a myáhtye è me̤tarè́htya okyǎ ahi yětahenuô, a ki nyě̤kruô̌ lò̌ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Èthǐ ki hé lahyǎ, ‘Kayǎ yětôprè̤ isò́htya ní̤dyé ahi rò a me̤plû́me̤htuô̌bè́ ní̤dyé to vǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kimá̤torò, hékuốré̤, khwí tôprè̤ ki htecuố ní̤dyé ná aklyěphú aprè̤ tôthò́, rò a kíré̤ cuốsásû ná khwí dố aruôtôprè̤ dố a o ní̤dyé ná aklyěphú aprè̤ nyě̤thò́ tôprè̤ yěnuô, a ki sásû ná khwí yětôprè̤ nuôma, a pé̤ dè pǎ è̌, ma a pé̤ dè to è̌ nuô, a bè onyǎo tane̤ myá kuốré̤. ");
INSERT INTO kyu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ki aryá pé̤ dè to kihérò, bí a oye̤ pǎ ná lǔ akhè̌nuô, a bè nò̌cuố ré̤ akayǎ tahe dố a ki cuố hépě̤hédwǒ ré̤. ");
INSERT INTO kyu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Phúnuô akhu-akhyě, lò̌꤮ tè̤ dố a o ná thǐ lò̌꤮ plǐ tahenuô, thǐ ki dyakyǎ to kihérò, thǐ htwǒhtya cyá̤ vǎ khǒpacè̤̌ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ithè nuôma aryá prè́ tadû́rò ithè a tè̤sû̌hè̌ yěnuô a ki lamé̤kyǎ hérò, ǔ cuố me̤sû̌hè̌ ka̤khyě cyá̤ pǎ è phútě? ");
INSERT INTO kyu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ithè dố asû̌hè̌ pǎtonuô, dố hekhu agně bèbè, dố thòmò̤́ lé̤ní̤hè̌ní̤re agně bèbè, abwítaryě o pǎ tôcô꤮ to. Rò ǔ vǐkyǎ kyǎ prè́ è prè́.” “Kayǎ dố a o ná akhǎlè dố a ní̤huô̌ cyá̤ tè̤tahenuô a tǒbè ní̤dǎ lahyǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bètôphuố prè̤kwǐamo-arǎ tahe ná prè̤oraphú tahe hyǎ oplu tava̤ ní̤dǎ lahyǎ Jesǔ a tè̤dônyǎhébè tahe. ");
INSERT INTO kyu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisěophú tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe tamwǒ̤talè̌ ní̤lò̌dû Jesǔ zo̤, “Kayǎ yětôprè̤ è́mo̤sû prè̤oraphú tahe, rò a cuố etố̤ǒtố̤kuô̌ cò́ ná èthǐ vǎ꤮!” ");
INSERT INTO kyu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Phúnuô akhu-akhyě, Jesǔ dyá pé̤ èthǐ ná ngó̤khákho tôtó̤ rò a hé, ");
INSERT INTO kyu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hékuốré̤ kayǎ tôprè̤prè̤ dố thǐklè̌nuô, athímí o aduô̌ tôzè̤ rò a ki lamé̤kyǎ pé̤ lǔ tôduô̌ hénuô, a ki me̤phútě? A ki dyakyǎ thímí lwǐ̤thyótôshyě ná lwǐ̤thyó tôduô̌ yěnuô dố asèekhu rò a ki cuốmyápṳ̌ a lamé̤ yětôduô̌ htú a myáhtye ka̤khyě khyěthyá è pǎ má̤to è̌? ");
INSERT INTO kyu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bí a myáhtye ka̤khyě khyěthyá hò́ lǔ akhè̌nuô, a ki thè́krṳ̂̌thè́lò̌ rò a ki dyahtya lǔ dố aplǎkhu pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Rò a ki hóka̤ ní̤dyé lǔ dố hi pǎ. Rò a ki mehyǎ plò́ní̤ a khǒbò́thyó ná ahi khǎsò̌khǎshyé tahe rò a ki hé èthǐ, ‘Vǎ myáhtye ka̤khyě khyěthyá hò́ vǎ thímí dố a lamé̤ yěnuô tôduô̌ hò́, rò vǎ thè́krṳ̂̌ nyacò́, rò hyǎ thè́krṳ̂̌thè́lò̌ ró̤kuô̌ lahyǎ ná vǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A thyá kuô̌dû phúnuôhò́, vǎ hé thǐ, prè̤oraphú tôprè̤ za̤ ní̤dû khyěthyá hò́ ané̤ akhu-akhyě dố mò́khunuô ǔ ki thè́krṳ̂̌thè́lò̌ lốklò̌ pǎ cò́ ná kayǎcò́kayǎte̤ lwǐ̤thyótôshyě ná lwǐ̤thyótôprè̤ dố a lo za̤ ní̤dû ané̤ hò́ to yěnuô tahe cò́. ");
INSERT INTO kyu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tomaná, hékuốré̤ prè̤mò tôprè̤ dố arû̌zye o abèshyé rò ki a lamé̤ pé̤kyǎ lǔ tôbè hénuôma a ki me̤phútě? A ki isǐlǐ mi, htuô̌rò a ki dǔplǐdǔlá̤ ahi, rò a myápṳ̌tǎ̤ myápṳ̌te̤ htú a myáhtye cò́ vǎhéto. ");
INSERT INTO kyu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bí a myáhtye ka̤khyě khyěthyá hò́ akhè̌nuô, a ki mehyǎplò́ a khǒbò́thyó ná ahi khǎsò̌khǎshyé tahe rò a ki hésoluô̌ pé̤ èthǐ, ‘Vǎ myáhtye ka̤khyě khyěthyá hò́ vǎrû̌zye dố a lamé̤kyǎ yětôbè akhu-akhyě vǎ thè́krṳ̂̌ nyacò́ rò hyǎ thè́krṳ̂̌thè́lò̌ ró̤kuô̌ lahyǎ ná vǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Phúnuôhò́, vǎ hé thǐ꤮, prè̤oraphú tôprè̤ za̤ ní̤ hò́ akhu-akhyě, Cò́marya a tanémò́khuphú tahe thè́krṳ̂̌thè́lò̌ nyacò́.” ");
INSERT INTO kyu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesǔ hé pó̤, “Bètôphuố kayǎ otôprè̤, a phúprè̤khǔ o thè́nyě̤. ");
INSERT INTO kyu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Apuố̤ tôprè̤ ka̤ hé aphè̌, ‘Phè̌꤮ ucè̌tazè̌ dố vǎ tǒbè ní̤bè è tahenuô, dyémò̌hò́ vǎ khǒnyá̤.’ Phúnuô akhu-akhyě aphè̌ ibětǎ̤ pé̤kyǎ aphú yěthè́nyě̤ ucè̌tazè̌ yětahe. ");
INSERT INTO kyu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nyě̤tyato rò apuố̤ yětôprè̤nuô, a phyéní̤ lò̌lò̌꤮ a ucè̌tazè̌ dố aphè̌ dyé è yětahe rò a htecuốkyǎ dố ké̤ye̤ tôké̤. Rò a cuố me̤lò̌kyǎdě lò̌ arû̌ ná a tè̤emṳ̂ǒpryá, atè̤lṳ̂ prè̤mòthè̌mě tahe. ");
INSERT INTO kyu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bí a me̤ lò̌kyǎ lò̌ hò́ arû̌ahtè̌ dố a o ná è tahe akhè̌nuô, tè̤ovǐ̤okò̌ ohtya dố ké̤ bínuôtôké̤ akǔ, rò tôcô꤮ opǎ ná lǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Phúnuô akhu-akhyě a cuốkwǐ me̤kuô̌ tè̤me̤ dố htyěphúké̤phú bínuô tôprè̤ a o rò a nò̌cuốkyě lǔ htyá dố a prè́lyá̤khu tôpho. ");
INSERT INTO kyu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yětôphuốrò a ladyá thè́ethè́ǒ rò a tuố̤ cò́ dố a thè́zṳ̂́ e kuô̌ nyacò́ kò́bǐthè dố htyá yětahe e yěnuô tadû́rò ǔ dyée pé̤ lǔ lé̤e tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Dốkhyěnuô, a thè́né̤lya̤ ní̤dyé ané̤ rò a hé, ‘Lò̌꤮ prè̤me̤tè̤phú dố vǎphè̌ ahikǔ nuôtahema, a ekò́ǒbǎ lò̌ lahyǎ, htuô̌to a olốkyǎ pluphè cò́ nyǎ hò́, vǎ rò vǎ kíré̤ cuố ovǐ̤okò̌ thyě cò́ bíyě cò́ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vǎ tǒ ihtò ka̤khyě khyěthyá dố vǎphè̌ o rò vǎ tǒbè ka̤ hé vǎphè̌, “Phè̌꤮ vǎ me̤thû́hò́ Cò́marya ná nè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ǔ ki è́ vǎ ná nè̤ phúprè̤khǔ tôprè̤nuô a kò pǎ to hò́. Dya vǎ phú nè̤ prè̤me̤tè̤phú dố a hyǎdakèe prè́ dố aklè́kǔ yěnuô tôprè̤ prè́.”’ ");
INSERT INTO kyu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Phúnuôrò a ihtòka̤ khyěthyá dố aphè̌ o. “Bí aphè̌ myáhtyecuốlǒ a phúprè̤khǔ o dố aye̤ ka̤ akhè̌nuô, a thè́zò̤ní̤ nyacò́ lǔ rò a klyacuố phyánuô̤mû́sû ní̤dyé aphú. ");
INSERT INTO kyu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Aphúprè̤khǔ hésû lǔ, ‘Phè̌꤮ vǎ me̤thû́hò́ Cò́marya ná nè̤ hò́, ǔ ki è́ vǎ ná nè̤phúkhǔ tôprè̤ nuô̌꤮ a kò pǎ cò́ to hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Manárò aphè̌ hé alulé tahe, ‘Me̤pryǎpryǎ, phyéhyǎ ca̤cwo̤ dố aryálố nuôtôpṳ̂, rò thyáhtya pé̤ lahyǎ ná è yě, rò taplwó nuô̌ pé̤ è cò́taplwó tômě dố a kanò̌kǔnuô, rò dyé sidyá pé̤ è khuphá nuô. ");
INSERT INTO kyu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Htuô̌rò cuốcwihyǎ pṳ́phú dố pè̤ buôbû katúlố ní̤dyé è nuôtôduô̌ rò me̤thyě è nuô. Pè̤ ki me̤pwè̌me̤la, rò takruô̤̌etakruô̤̌ǒ ró̤lò̌ lǔ pó꤮. ");
INSERT INTO kyu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Me̤těhérò è ma athyáná vǎphúkhǔ dố a thyěhtuô̌hò́ tôprè̤, rò a htwǒprè̤ ka̤khyě khyěthyá yětônyě tôprè̤nuô hò́. È ma athyáná vǎphúkhǔ dố a lamé̤ rò myáhtye ka̤khyě khyěthyá hò́ è yětônyě tôprè̤ nuôhò́.’ Phúnuôrò èthǐ cáhtya me̤pwè̌me̤la, takruô̤̌takrè́ eǒ ró̤lò̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Bínuôkhè̌ a phúprè̤khǔ dố adu tôprè̤ o dố lyá̤khu. Rò bí a ka̤phûhò́ ná hi akhè̌nuô, a ní̤huô̌ ǔ dòhtò̌dòmo̤ rò ilěpré̤ilěmya̤ pra̤rû́pra̤tè́ lò̌ dố lǔhi. ");
INSERT INTO kyu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Phúnuôrò a è́ lulé tôprè̤ rò a sudyǎ lǔ, ‘Mame̤těrò ǔ cuốme̤ pra̤rû́pra̤tè́ lò̌plǐ phúnuô me̤tě?’ ");
INSERT INTO kyu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Rò alulé hésû lǔ, ‘Nè̤ puố̤prè̤khǔ ka̤tuố̤mo̤ ka̤tuố̤ryá khyě dố hi akhu-akhyě, nè̤phè̌ me̤thyě pé̤ è pṳ́phú dố pè̤ buôbûkatú ní̤dyé è nuô tôduô̌ nuô̌꤮.’ ");
INSERT INTO kyu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Yětôphuốrò a vyá̤prè̤khǔdu yětôprè̤ thè́plòdu rò a ka̤kanuô̌ pǎ dố hikǔ to. Rò aphè̌ hte ilò̌kanuô̌ lǔ dố hidò́kǔ. ");
INSERT INTO kyu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Manárò a hésû aphè̌, ‘Phè̌꤮ nè̤ myámò̌ kǒkǒ, vǎevǎrya̤ pé̤ nè̤ phú cṳ̂́ tôprè̤nuô dố anana dố alè̌lè̌kǔ cò́, vǎhtévǎtaǎyǎ sûnò́ ná nè̤ngó̤ tômû̌꤮ to. Nè̤ dyénò́ pé̤ hò́ vǎ maǐtě? Thyáphú vǎ ki me̤pwè̌, vǎ ki eró̤ǒró̤ kuô̌ ná vǎ khǒbò́thyó tahe agněnuô, bí pé̤phú tôduô̌ prè́꤮ nuô nè̤ dyé nò́ pé̤náhí vǎ tôphuố꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Manárò bí nè̤phúkhǔ yětôprè̤ cuố me̤lò̌ kyǎdě nè̤ ucè̌tazè̌, cuốlṳ̂ prè̤mòthè̌mě ka̤tuố̤ khyěthyá rò, nè̤ me̤thyě pé̤ cò́ è pṳ́phú dố pè̤ buôbûkatú ní̤dyé lǔ nuôtôduô̌ cò́cò́!’ ");
INSERT INTO kyu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Rò aphè̌ hésû lǔ, ‘Phúkhǔ꤮, nè̤ o dố vǎ khǎduôshyé pwǒ̤꤮ tôphuố rò tè̤ dố a o ná vǎ lò̌꤮ plǐ tahe nuôma nè̤tè̤ lò̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Manárò nè̤ puố̤prè̤khǔ yěnuô athyáná a thyěhtuô̌hò́ rò khǒnyá̤yě a htwǒprè̤ ka̤khyě nuôhò́, athyáná a lamé̤ rò myáhtye ka̤khyě khyěthyá è yětônyě nuôhò́ akhu-akhyě, pè̤ tǒbè me̤pwè̌me̤la ní̤dyé è, rò pè̤ tǒkò thè́krṳ̂̌thè́lò̌ eró̤ǒró̤lǔ kǒkǒ.’” ");
INSERT INTO kyu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesǔ hé a khǒpacè̤̌ tahe, “Bètôphuố kayǎ duzá̤htyathè̌ o tôprè̤. Rò a o ní̤dyé ná prè̤myákhwèní̤ a tǎ̤muô̌tǎ̤tè̤ tôprè̤. Ǔ héluô̌ pé̤ lǔ ná a me̤lò̌ kyǎdě lò̌ abyacè tǎ̤muô̌tǎ̤tè̤ pwǒ̤꤮ tôcô. ");
INSERT INTO kyu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kayǎ duzá̤ yětôprè̤ è́hyǎ aprè̤ myákhwè tǎ̤muô̌tǎ̤tè̤ yětôprè̤ rò a hé lǔ, ‘Nè̤rinè̤kyǎ dố vǎ ní̤huô̌ yěnuôma phútě tôcôtě? Nè̤ bè dyahtyaluô̌ nè̤ rǎmárǎdyǎ, nè̤ myákhwèní̤ vǎ tǎ̤muô̌tǎ̤tè̤ nuôtahe ari-akyǎ, me̤těhérò vǎ nò̌ htwǒ cyá̤ pǎ nè̤ ná prè̤myákhwè vǎ tǎ̤muô̌tǎ̤tè̤ tôprè̤ pǎto hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Prè̤myákhwè tǎ̤muô̌tǎ̤tè̤ yětôprè̤ hélya̤ ní̤dyédû ané̤, ‘Vǎbyacè nò̌htekyǎhò́ vǎ dố a tè̤me̤kǔ hò́ rò vǎ bème̤ phútě? Vǎ ki iphuô̌ivè̤̌ e hekǔ hérò, vǎhè̌vǎre lốbǎ toto, vǎ ki kwǐesè hérò, vǎ thè́tarè̤̌ lǎlǎ. ");
INSERT INTO kyu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bí vǎ tè̤me̤ o pǎ to yěakhè̌nuô, thyáphú vǎ ki o kuô̌ná vǎ khǒbò́thyó dố a ki è́mo̤sû kuô̌ vǎ dố èthǐ hikǔ pǎnuô rò, khǒnyá̤yě vǎ tǒbè me̤phútě nuô, vǎ thè́gně hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Phúnuô akhu-akhyě, a è́hyǎ lò̌꤮ kayǎ dố a su-o abyacè nuôtahe tôprè̤ htuô̌ tôprè̤. Rò a sudyǎ a hyǎ ré̤lố nuôtôprè̤, ‘Nè̤ su-o vǎbyacè bátě?’ ");
INSERT INTO kyu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“A hésû lǔ, ‘Vǎ su-o lǔ olivahtyě akò̌du tôzè̤.’ “Rò prè̤myákhwè tǎ̤muô̌tǎ̤tè̤ yětôprè̤ hé lǔ, ‘Phyé nè̤ lirǎmárǎdyǎ nuôtôba rò onyǎ rǎtǎ̤ mò̌, rò rǎnuô̌ prè́ nyǎ̤shyě nuô.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“A sudyǎ pó̤ dố aruôtôprè̤, ‘Nè̤lé꤮ nè̤su o lǔ bátě?’ “Rò a hésû lǔ, ‘Vǎsu o lǔ buốkǔlǎ akhwótôzè̤.’ Prè̤myákhwè tǎ̤muô̌tǎ̤tè̤ yětôprè̤ hé lǔ, ‘Phyé nè̤ lirǎmárǎdyǎ nuôtôba rò rǎnuô̌ prè́ shyělwǐ̤thyó nuô.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Prè̤myákhwè tǎ̤muô̌tǎ̤tè̤ dố acò́ate̤ to yětôprè̤nuô, abyacè htuthè́ ní̤dyé nyacò́ lǔ, me̤těhérò a me̤limyǎ tè̤. Prè̤luhekhuphú yětahenuô a limyǎ lahǒlahya ní̤dyé khyědû lǔ, rò a dèlốklò̌ pǎ cò́ ná kayǎ o dố tè̤lǐkǔ nuôtahe cò́.” ");
INSERT INTO kyu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Htuô̌rò Jesǔ hé, “Phúnuô akhu-akhyě vǎ héso thǐ, thyáphú nè̤ ki ní̤bè è́ nè̤khǒnè̤thyó tahe dố a ki htwǒ nè̤tè̤ nuô, nò̌e nè̤hekhu tè̤duzá̤htyathè̌ yětahenuô. Phúnuôrò shyé꤮ nè̤ tè̤duzá̤htyathè̌ lò̌hò́ pǎnuô, ǔ ki è́sû dû nè̤ dố tè̤htwǒprè̤ tacṳ́prè̤ dố mò́khu ahtyěaké̤kǔ nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kayǎ dố ǔ zṳ̂́ení̤ cyá̤ è dố tè̤patíphú prè́ akǔ tôprè̤nuô, tè̤adu-azǎ̤ kǔnuô̌꤮ ma ǔ ki zṳ̂́ení̤ cyá̤ è pǎ. Manárò kayǎ dố ǔ zṳ̂́ení̤ cyá̤ è dố tè̤patíphú akǔ to tôprè̤nuô, tè̤adu-azǎ̤ kǔnuô̌꤮ ma ǔ zṳ̂́ení̤ cyá̤ lǔ toto. ");
INSERT INTO kyu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ki me̤phúnuô hérò, thǐ ki cò́te̤ ná tè̤myákhwè hekhu a tè̤duzá̤htyathè̌ to hérò, mò́khu tè̤duzá̤htyathè̌ má̤lakǒ yěnuô, ǔ zṳ̂́e cyá̤ thǐ to. ");
INSERT INTO kyu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Rò thǐ ki cò́te̤ ná ǔruô tǎ̤muô̌tǎ̤tè̤ to kihérò ǔ ki dyé thǐ tǎ̤tè̤ dố a ki htwǒ nè̤ tè̤nuô a o tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Lulé tôprè̤ me̤cyá̤ tè̤me̤ dố Byacè thè́nyě̤ atè̤nò̌ alè̤̌nuô a o tôprè̤꤮ to. A ki thè́htekyǎ ní̤dyé tôprè̤ pǎ, rò a ki mo̤ ní̤dyé tôprè̤ pǎ. Má̤torò a ki thè́plòícû̌ ní̤dyé tôprè̤ pǎ, rò a ki me̤takhwótakè sûkyǎ ní̤dyé tôprè̤ pǎ. Thǐ me̤pé̤lò̌ Cò́marya agněgně, rû̌ agněgně nyě̤côlò̌ nuô, aní̤ to.” ");
INSERT INTO kyu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisěophú dố a mo̤ní̤ rû̌htè̌ nuôtahe ní̤huô̌ ngó̤yě akhè̌nuô, a nyě̤kruô̌ lahyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesǔ hé èthǐ, “Thǐ ma kayǎ dố a cyé̤zò́cò́te̤ prè́ ané̤ dố kayǎ a mèthènyě nuôtahe prè́, manárò Cò́marya thè́gně lò̌plǐ hò́ thǐ thè́plòkǔ. Me̤těhérò, tè̤ dố kayǎ tane̤ ná angṳdupri̤dulố ǔ tahenuô, dố Cò́marya mèthènyě nuôma má̤ prè́ tè̤mǔmyá̤ricyá̤ dố ǔ lé̤thè́zò̤́thè́ryǎ̤ è nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mosè tè̤thyótè̤thya ná prè̤pro̤ a tè̤rǎkyǎ tahenuô, ǔ hésodônyǎ tuố̤ tadû è bí Giovanni Baptista a htû̌khè̌ nuôprè́. Dốkhyěyě vǎ hésodônyǎ pé̤ ǔ ná Cò́marya htyělé̤ké̤kǔ tè̤thè́krṳ̂̌mila ari-akyǎ rò ǔ yácû́ nuô̌phe lò̌ cò́ lǔ pwǒ̤꤮ tôprè̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Manárò phû꤮ ná Cò́marya a tè̤thyótè̤thya dố a patílố tôplò kíré̤ pyékyǎ agněnuô, mò́khu ná hekhu pyékyǎ zǔklò̌lố pǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Prè̤khǔ tôprè̤prè̤ dố a okyǎ amě rò a ki cuốphyé taple ná prè̤mò dố aruô tôprè̤prè̤ hénuôma a cuốthû́hò́ ná prè̤mò nuôtôprè̤ hò́. Rò prè̤khǔ tôprè̤prè̤ dố a phyé prè̤mò dố a vè̤ okyǎ lǔ yětôprè̤ nuôma a cuốthû́hò́ ná prè̤mò nuôtôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Bètôphuốnuô, kayǎ duzá̤htyathè̌ otôprè̤. Akû̌athyá shuô̌shuô̌ cò́ hyeca̤ dố angṳdulố tahe, rò a eviǒsû̌, me̤mo̤ ní̤dyé ané̤ pwǒ̤꤮ tônyě cò́. ");
INSERT INTO kyu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kayǎ sǒphásǒrya̤phú otôprè̤. Rò amwi̤ ná Lazarú. Avǎ htelò̌ né̤sǐprè̤ cò́, rò ǔ cò̤̌hyǎ dya omyěkhû́ lǔ bí kayǎ duzá̤htyathè̌ yětôprè̤ a lo̤kadǎdu shyé nuô. ");
INSERT INTO kyu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A opò̤́ myásû̌myátṳ́ e kuô̌ prè́ kayǎduzá̤ yětôprè̤ asèe tǎ̤kuố̤tǎ̤vè̤̌ dố a dǐrè̤́lè̤̌ nuôtahe prè́. Htuô̌to htwitahe hyǎilye lò̌plǐ lǔvǎ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Bí kayǎ sǒphásǒrya̤phú yětôprè̤ thyě akhè̌nuô, tanémò́khuphú tahe cò̤̌htya è dố Abraham akhǎshyé. Kayǎ duzá̤htyathè̌ yětôprè̤nuô, a thyěkuô̌ke rò ǔ cuố iluốkyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bí a khyábè nyacò́ tè̤cyě̤ dố ngarakǔ akhè̌nuô, a myáhtya dố mò́khu rò a myáhtye htyacuốlǒ Abraham, rò Lazarú okuô̌ dố lǔ khǎshyé. ");
INSERT INTO kyu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Rò a è́htǒhtya, ‘Kố꤮ Abraham꤮! Thè́zò̤ré̤ vǎ ní꤮, nò̌cye̤nuô̌ré̤ Lazarú a kanò̌khyě dố htyěkǔ rò nò̌cya̤tǎ̤mè̌ kacṳ́ pé̤ré̤ vǎ pli̤yě ní꤮, me̤těhérò vǎ khyábè tè̤ dố mikǔ yěnuô acyě̤acṳ̂ nyacò́ vǎ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Manárò Abraham hésû lǔ, ‘Vǎphúkhǔ꤮ tane̤htyabè tuố̤khyě bí nè̤ ohtwǒprè̤ pǎ ashuốkhè̌nuô, nè̤ o ná tè̤ dố a me̤mo̤me̤phwǐ nè̤ nuôtahe, manárò Lazarú yěnuô, a ní̤bè lò̌plǐ tè̤cyě̤tè̤cṳ̂ tahe, tadû́rò khǒnyá̤yě, è ní̤bè kuô̌ke hò́ tè̤omo̤-opě̤ khǎlé̤ bíyě hò́, rò nè̤ rò nè̤ khyábè kuô̌ke tè̤cyě̤tè̤cṳ̂ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tû́nuôhtuô̌to, pè̤ ná thǐ acò̤kǔ yěnuô, lyǎ̤zǎ̤du꤮ nyacò́ o tôbǒ rò kayǎ dố a o bíyě tahenuô, a thè́zṳ̂́ cuố dố thǐ o tadû́rò a cuố cyá̤ to, htuô̌to kayǎ dố thǐ o tahenuô, a thè́zṳ̂́ hyǎ bí pè̤ o yě tadû́rò a hyǎ cyá̤ to.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Rò kayǎ duzá̤htyathè̌ yětôprè̤ hésû, ‘Ki me̤phúnuô hérò, Abraham꤮, vǎ kwǐthè́zò̤ nè̤, nò̌ka̤ré̤ Lazarú dố vǎphè̌ ahi nuô. ");
INSERT INTO kyu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Vǎ puố̤vyá̤ prè̤khǔ okyǎ pǎ cò́ thè́nyǎ̤ cò́. Thyáphú a ki hyǎtuố̤kuô̌ tǎ bí tè̤cyě̤tè̤cṳ̂ akhǎlé̤ yětôpho tǎmé̤ nuô, plwǒka̤ pé̤ré̤ vǎ Lazarú nuô, rò nò̌ka̤ dyérò̤dyéryě̤ pé̤ré̤ ná èthǐ nuôtahe.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham hésû lǔ, ‘Mosè ná prè̤pro̤ tahe one dû hò́ dố a ki dyérò̤dyéryě̤ pé̤ nè̤ puố̤vyá̤ prè̤khǔ nuôtahe hò́. Èthǐ tǒkò ní̤dǎ dûhò́ èthǐngó̤ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Rò kayǎ duzá̤htyathè̌ yětôprè̤ hésû, ‘Abraham꤮ tû́yěnuô rò a lốbǎ híto. Kayǎthyě tôprè̤ ki ihtòhtwǒprè̤ ka̤khyě, rò a ki ka̤khyě dyáso pé̤ èthǐ tû́ma a za̤ ní̤ no prè́ ané̤ prè́.’ ");
INSERT INTO kyu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Manárò Abraham hésû lǔ, ‘Èthǐ ki krwǒme̤ kuô̌ phú Mosè ná prè̤pro̤ rǎkyǎ nuôtahe to hérò, kayǎ tôprè̤prè̤ ki ihtòhtwǒprè̤ ka̤khyě pé̤ cò́ èthǐ cò́ ma, a zṳ̂́e pé̤ ná nè̤ to.’” ");
INSERT INTO kyu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesǔ hé a khǒpacè̤̌ tahe, “Tè̤ilo-ilyáthû́ ǔ tahenuô a bè ohtya nyǎ pǎ tadû́rò kayǎ dố a me̤-o htwǒhtya tè̤ilo-ilyá thû́ ǔ yětôprè̤nuô, tè̤cyě̤tè̤cṳ̂ ki bè nyacò́ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kayǎ phúnuô tôprè̤nuô phû꤮ ná a kíré̤ me̤-ohtwǒhtya tè̤ dố kayǎ patílố dố ǔklè̌ tôprè̤prè̤ ki me̤tè̤thû́ phúyě nuôrò, cò̌ lò̤́du dố a kyǎ̤bǒlo̤nuô rò tá̤tǎ̤kyǎ è dố htyědutava̤kǔ nuôma aryáklò̌ pǎ cò́ dố lǔgně cò́. ");
INSERT INTO kyu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Rò̤ní̤ lahyǎ thǐné̤ ní꤮. “Thǐ puố̤vyá̤ dố a zṳ̂́e Jesǔ tôprè̤ ki me̤tè̤thû́ hérò, bè ithyóithya è. A ki za̤ ní̤ hò́ ané̤ hérò plwǒkyǎ lǔ tè̤thû́ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tônyě akǔ, a ki me̤thû́ nè̤ thuô̌thyótôphuố hérò, a ki hyǎtǒ khyěthyá nè̤ thuô̌thyótôphuố rò a ki hyǎ hé, ‘Vǎ za̤ ní̤dû hò́ vǎné̤’ hénuô, nè̤ bè plwǒkyǎ lǔ tè̤thû́.” ");
INSERT INTO kyu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Prè̤dônyǎphú tahe héso Byacè, “Me̤sò̌htya pé̤ pè̤ tè̤zṳ̂́.” ");
INSERT INTO kyu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Rò Byacè hésû èthǐ, “Thǐ tè̤zṳ̂́ ki o tí꤮ taplèplò tôplò nuôprè́ tadû́rò thǐ ki hé thòmò̤́du yětômò̤́, ‘Cû́hte nè̤rwí̤nuô, rò cuốisò́o nè̤né̤ dố htyědutava̤ akǔnuô,’ thǐ ki hé è nuô, a ki cṳ̌e thǐngó̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Hékuốré̤, kayǎ dố thǐklè̌ tôprè̤prè̤nuô, a ki o ní̤dyé ná alulé dố a hyǎhtá prè́ tôprè̤, má̤torò prè̤kyě̤thímíphú tôprè̤ hébyenuô. Bí alulé o dố prè́khu ka̤tuố̤khè̌, tôphuốtuô̌ thǐ è́nò́ sálé̤, ‘Hyǎ onyǎ epryǎ mò̌ dǐyě,’ a hé phúyě nuôma a o nyǎ tôprè̤prè̤ è̌? ");
INSERT INTO kyu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Thǐ ki hé è, ‘Phǒe mò̌ dǐ, htulya taple mò̌ nè̤ hyeca̤nuô rò khwóe pé̤ vǎ dǐ rò opò̤́myákhwè buôebuôǒní̤ vǎ bíyě, vǎ ehtuô̌pǎ rò eno dốkhyě pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Lulé tôprè̤ me̤phú abyacè hé lǔ nuô tadû́rò abyacè lo hébwíhétaryě lǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Thǐ bèbè thyáphúnuô hò́. Bí thǐ me̤htuô̌lò̌hò́ lò̌꤮ tè̤ dố ǔ nò̌ thǐ nuôtahe akhè̌nuô, thǐ tǒ hé, ‘Pè̤ ma lulé tahe dố a me̤htuô̌kyǎ cò́cû́ prè́ tè̤me̤ dố a lya̤bè pè̤ yěnuôtahe prè́.’” ");
INSERT INTO kyu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bí Jesǔ cuố dố vǐ̤ Jerusalem akhè̌nuô, a cuốrwó bí Samaria ké̤ ná Galilea ké̤ ké̤kû̌plè lǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A cuốnuô̌ dố dò̌tôdò̌ akǔ rò a myáhtye tǎ̤sû ná kayǎphè̌ prè̤shyé dố a ní̤bè lahyǎ tè̤swímǔmyá̤ dố phálo̤ tahe. Èthǐ ihtòo taphǎye̤ rò, ");
INSERT INTO kyu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","a è́htǒcuố, “Kố꤮ Byacè Jesǔ! Thè́zò̤ kuô̌ré̤ pè̤ ní꤮!” ");
INSERT INTO kyu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesǔ myáhtye èthǐ rò a hé èthǐ, “Cuố dyéluô̌ myá lahyǎ thǐné̤ dố bwídu tahe a o nuô.” Bí èthǐ cuố dố klyálo̤ akhè̌, èthǐ tè̤sè̌ sǐmé̤kyǎ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dố èthǐ aklè̌ tôprè̤nuô, a myáhtyethè́gně ná Jesǔ zasǐmé̤kyǎ hò́ è akhu-akhyě, a ka̤khyě rò a è́htǒhtuthè́htya Cò́marya. ");
INSERT INTO kyu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Htuô̌rò a dángṳ̂cò́bè̌lya̤ dố Jesǔ a khǎduôshyé rò a hébwíhétaryěhtya lǔ. È ma Samariaphú tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Rò Jesǔ hé lǔ, “Kayǎ dố vǎ zasǐmé̤ pé̤ lǔ tahe nuôma a o prè̤shyé vǎhéto! Lwǐ̤thyótôprè̤ pǎ lě꤮ a otǒ bítě? ");
INSERT INTO kyu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mame̤těrò a ka̤khyě hébwíhétaryě htuthè́htya khyěthyá Cò́marya tû́prè́ myěcôruôphú yětôprè̤prè́ ròma phútě?” ");
INSERT INTO kyu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Htuô̌rò Jesǔ hé è, “Ihtòcuốmò̌, nè̤ tè̤zṳ̂́ zasǐmé̤kyǎ pé̤ hò́ nè̤ tè̤sè̌ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisěophú tahe sudyǎ Jesǔ ná Cò́marya ahtyěaké̤ ki hyǎtuố̤ bíkhè̌tě pǎ. Rò a hésû èthǐ, “Cò́marya ahtyěaké̤ hyǎisò́o nuô ǔ myáhtye cyá̤ phúnuô má̤to. ");
INSERT INTO kyu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tôprè̤꤮ ma ǔ hé, ‘Myámò̌ bíyě,’ ‘Myámò̌ dốnuô,’ phúnuô tôprè̤꤮ to, me̤těhérò Cò́marya ahtyěaké̤ yěnuô a hyǎisò́o hò́ dố thǐ thè́plòkǔ nuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Htuô̌rò Jesǔ hé a khǒpacè̤̌ tahe, “Prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě amò̤́nyěmò̤́thè̌ dố thǐ thè́zṳ̂́ myáhtye nyacò́ yěnuô, a ki hyǎtuố̤ tônyěnyě pǎ, manárò thǐ myáhtye cyá̤ è to. ");
INSERT INTO kyu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ǔ ki héso pé̤ thǐ, ‘Myámò̌ dố nuô’ má̤torò ‘Myámò̌ bíyě’ phúnuô pǎ! Tadû́rò cuốkrwǒ zṳ̂́e kuô̌ tǎ èthǐ tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vǎ cuốhétuố̤ thǐ phúyě me̤těhérò, bí prè̤lu aphúkhǔ má̤hò́ vǎyě ki hyǎ khyěthyá pǎ akhè̌nuô, ǔ pwǒ̤꤮ tôprè̤ ki myáhtye è pǎ. A ki thyáná shyeli̤bò́ dố mò́lè̤̌ rò a ki sátakhè̌ rasǒ cuố lò̌ mò́lè̤̌sǐba pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Manárò vǎ ki khyábè è́lốklò̌ ré̤ cò́ tè̤cyě̤tè̤cṳ̂ pǎ, rò kayǎ yětôhtû̌ zṳ̂́e vǎ to. ");
INSERT INTO kyu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎpǎ akhè̌nuô, a ki htwǒhtya thyákuô̌dû phú Noah htû̌khè̌ nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bínuôkhè̌ kayǎ tahe eǒ lahyǎ, ní̤phúní̤mě tuố̤ lahyǎ cò́ bí Noah nuô̌ dố thòklyědukǔ nuôtônyě cò́. Rò htyěduhtya thyěkyǎ lò̌plǐ kayǎ okyǎ dố aklò̌ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Bí vǎ hyǎ khyěthyá akhè̌pǎnuô, a ki thyáná kayǎ dố Abraham aphúdu Lot htû̌khè̌ nuô pǎ. Kayǎ bínuô tôhtû̌ tahenuô, ae-aǒ lahyǎ, ipri̤-isè̌, isò́iplû̌ rò sò́ lahyǎ ahi-aphyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Manárò bí Lot htecuố taphǎkyǎ ná vǐ̤ Sodom nuôtônyě akhè̌nuô, Cò́marya nò̌cṳ̂tǎ̤ ké̤ ná mi ná lò̤́miû̌ dố mò́khu rò miû̌ thyěkyǎ lò̌ èthǐ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Shyé꤮ prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě kíré̤ hyǎhò́ pǎ akhè̌nuô, a ki htwǒhtya thyákuô̌dû phúyěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mò̤́nyě bínuô tônyě pǎ ma, kayǎ o dố a hikhuklwó tabyekhu tahenuô bè hítǎ̤ nuô̌ phyéní̤ a tǎ̤muô̌tǎ̤tè̤ tahe dố hidò́kǔ tôcô꤮ to! Kayǎ o dố lyá̤khu tôprè̤prè̤ nuô a bè klya ka̤khyě phyéní̤ atǎ̤tè̤ dố ahi to. ");
INSERT INTO kyu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tane̤htyatuố̤ bèkhyě lahyǎ dû Lot amě nuô. ");
INSERT INTO kyu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Me̤těhérò kayǎ dố a thè́zṳ̂́ me̤lwóhteka̤ ní̤dyé a thè́htwǒprè̤ tôprè̤prè̤nuô, a thè́htwǒprè̤ ki sǐmé̤kyǎ pǎ. Manárò kayǎ dố a dyélya̤kyǎ a thè́htwǒprè̤ dố vǎkhuvǎkhyě tôprè̤prè̤nuô, a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Vǎ hé thǐ, bí nuôtôthè̌ pǎma, kayǎ thè́nyě̤ ki omyětố̤lǔ dố lé̤myěkhu tôphotuô̌ pǎ. Rò Cò́marya ki è́ka̤kyǎ pǎ tôprè̤, tôprè̤rò a ki dya-okyǎ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Prè̤mò thè́nyě̤ ki isátṳ̂̌sû lǔ buốe pǎ. Rò Cò́marya ki è́ka̤kyǎ lǔ pǎ tôprè̤, rò a ki dya-okyǎ lǔ tôprè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Prè̤khǔ o dố lyá̤khu thè́nyě̤nuô, tôprè̤rò Cò́marya ki è́ka̤kyǎ lǔ pǎ, tôprè̤nuô Cò́marya ki dyakyǎ lǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesǔ a khǒpacè̤̌ tahe sudyǎ lǔ, “Byacè, a ki htwǒhtya tǒ bítě tôphotě pǎ?” Rò Jesǔ héka̤khyěsû pé̤ èthǐ ngó̤ tômû̌, “Tè̤thò̌ otǒ bítě꤮ nuô, latya ki oplò́lǔ bínuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Htuô̌rò Jesǔ thè́zṳ̂́ ná a khǒpacè̤̌ tahe ki kwǐcò́bè̌ lahyǎ pwǒ̤꤮ tôphuố, rò èthǐ ki thè́plòpyé tǎ taki꤮ tǎmé̤ nuôrò, a dyákhákho pé̤ a khǒpacè̤̌ tahe ná ngó̤ tômû̌. ");
INSERT INTO kyu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jesǔ dyá pé̤ èthǐ phútě hérò, “Dố vǐ̤tôvǐ̤ akǔnuô, prè̤ciryatè̤ otôprè̤. Kayǎ tôprè̤nuô a thè́isě bezṳ̂́benyá̤ kuô̌ǔ Cò́marya toto, a bezṳ̂́benyá̤ kuô̌ǔ prè̤lu kayǎ toto. ");
INSERT INTO kyu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bí vǐ̤ nuôtôvǐ̤ akǔ nuôprè́, prè̤mòokryá o tôprè̤. Rò a hyǎ kwǐthè́zò̤ tamǒmǒ prè̤ciryatè̤ yětôprè̤, ‘Me̤cwó̤ pé̤ré̤ vǎ rò ciryacò́cò́ pé̤ré̤ vǎ ná prè̤ dố a thè́hte vǎ yěnuô.’ ");
INSERT INTO kyu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“A cṳ̌kuô̌ prè̤mòokryá yětôprè̤ to tadû́rò dốkhyěnuô a tane̤lya̤ ní̤dyé ané̤, ‘Vǎ ma kayǎ dố a thè́isě kuô̌ǔ Cò́marya to, bezṳ̂́benyá̤ kuô̌ǔ kayǎ to tadû́rò, ");
INSERT INTO kyu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","prè̤mòokryá yětôprè̤nuô, a yǒ hyǎme̤súsá tamǒtamǒ vǎ rò vǎ ki myá taritaryǎ pé̤kyǎ è pǎ. Vǎ ki me̤phúnuô to héma, a hyǎ me̤súsá tamǒtamǒ vǎ pǎ rò tadû꤮ tadû ma vǎ ladyáladǎ kyǎdě prè́.’” ");
INSERT INTO kyu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Htuô̌rò Byacè hé, “Thǐ ní̤dǎ myámyá prè̤ciryatè̤ cò́te̤to yětôprè̤ hé ngó̤ yětômû̌ nuô. ");
INSERT INTO kyu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kayǎ dố Cò́marya nwóhtya è tahenuô, ki a kwǐ tè̤me̤cwó̤ pwǒ̤nyěpwǒ̤thè̌ hénuô, Cò́marya cirya cò́te̤ pé̤ èthǐ toma a ocyá̤ nyǎ è̌? Thyáphú a ki me̤cwó̤ pé̤ ǔ agně nuôrò a ki me̤khò̌me̤zò̌ pǎ è̌? ");
INSERT INTO kyu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Vǎ hé thǐ, Cò́marya ki cirya cò́te̤ pryǎpryǎ pé̤ èthǐ pǎ. Manárò bí prè̤lu aphúkhǔ má̤hò́ vǎyě hyǎ pǎ akhè̌nuô, dố hekhuyě pǎ vǎ myáhtye pǔ kayǎ tahe ki opǎ lahyǎ ná tè̤zṳ̂́tè̤nyá̤ pǎ è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kayǎ dố a zṳ̂́e ní̤dyé ané̤ ná acò́ate̤ rò a tane̤patí ǔruô tahenuô, Jesǔ dyá pé̤ èthǐ ná ngó̤khákho tôtó̤. ");
INSERT INTO kyu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kayǎ thè́nyě̤ cuốhtya kwǐcò́bè̌ dố tè̤lǔtyǎ hǒkǔ. Tôprè̤ rò Pharisěophú, dố aruôtôprè̤ rò prè̤kwǐamo-arǎ. ");
INSERT INTO kyu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisěophú tôprè̤ cuố ihtòo kwǐcò́bè̌ rò a hé, ‘Kố꤮ Cò́marya, vǎ hébwíhétaryě nè̤, me̤těhérò phú ǔruô tahe cuốpṳ̂́phe zè́plè́ e ǔtè̤, lahǒlahya ǔ, cuốthû́ ǔphúǔmě nuô vǎ me̤nò́ kuô̌ǔ to. Vǎ thyákuô̌ ná prè̤kwǐe amo-arǎ nuôtôprè̤ to akhu-akhyě vǎ hébwíhétaryě nyacò́ nè̤. ");
INSERT INTO kyu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Thuô̌thyótônyě akǔnuô, vǎ duôe sèesèǒ nyě̤nyě pwǒ̤꤮ tôphuố cò́, htuô̌rò lò̌꤮ vǎ ní̤bè tè̤ tahenuô, vǎ dyé ka̤khyě cò́ nè̤ pwíshyétôpwí cò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Manárò prè̤kwǐamo-arǎ yětôprè̤nuô, a cuốkahtòo lǒ dố aye̤, rò a tṳ́htya bû cò́ amèthè dố mò́khu to. A thè́plè̤̌ rò a htòlya̤ ní̤dyé ataǒ rò a hé, ‘Kố꤮ Cò́marya꤮ thè́zò̤ní̤ré̤ vǎ. Vǎ ma prè̤oraphú tôprè̤.’” ");
INSERT INTO kyu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Rò Jesǔ hé èthǐ, “Vǎ hé thǐ, kayǎ dố acò́ate̤ dố Cò́marya a mèthènyě nuôma Pharisěophú yětôprè̤nuô má̤to. Prè̤kwǐamo-arǎ yětôprè̤nuô, bí a ka̤ dố ahi akhè̌, acò́ate̤ dố Cò́marya a mèthènyě hò́, me̤těhérò kayǎ dố a phyéhtyalô̌ ané̤ tôprè̤nuô, Cò́marya ki shyalya̤ è pǎ rò kayǎ dố ashyalya̤-athè́ tôprè̤nuô, Cò́marya ki dyahtyalô̌ è pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kayǎ tahe è́hyǎ aphúpatí tahe dố Jesǔ a o rò a thè́zṳ̂́ nò̌dyahtya Jesǔ takhu dố pacè̤̌phú yětahe alo̤, manárò a khǒpacè̤̌ tahe myáhtye rò a thè́prwǒ̤sû èthǐ. ");
INSERT INTO kyu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Manárò Jesǔ è́hyǎ pacè̤̌phú thǐtahe dố a o rò a hé, “Plwǒhyǎ pacè̤̌phú nuôtahe dố vǎoyě, me̤tǎ̤tṳ̂̌ tǎ èthǐ tǎmé̤, me̤těhérò Cò́marya ahtyěaké̤ nuôma kayǎ dố a shyalya̤ athè́plò thyáná pacè̤̌phú yěnuôtahe atè̤hò́. ");
INSERT INTO kyu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Vǎ hécò́cò́ thǐ, thǐ ki nò̌pố thǐné̤ ná Cò́marya phú pacè̤̌phú tahe nò̌pốní̤ ané̤ nuôto hénuô, thǐ nuô̌ ní̤ cyá̤ dố Cò́marya htyělé̤ké̤kǔ takhyá꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kayǎ htwǒ khuklò́ tôprè̤ sudyǎ Jesǔ, “Kố꤮ tháráryá꤮ thyáphú vǎ ki ní̤bè kuô̌ǔ thè́htwǒprè̤ tacṳ́prè̤ talèkrè́ nuôrò, vǎ tǒbè me̤kryá꤮ maǐtě?” ");
INSERT INTO kyu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesǔ sudyǎ lǔ, “Nè̤ cuốè́ tuố̤ vǎ ná tháráryá me̤tě? Kayǎryá o tôprè̤꤮ to, a o prè́tû́ Cò́marya tôprè̤prè́. ");
INSERT INTO kyu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nè̤ thè́gně Cò́marya mekyǎngó̤ tahe hé, ‘Cuốthû́ tǎ ǔphúǔmě tǎmé̤, me̤thyě tǎ kayǎ tǎmé̤, ehuôehí tǎ ǔtè̤ tǎmé̤, khyá lahǒlahya tǎ tè̤ tǎmé̤, bezṳ̂́nyá̤ nè̤muố̤nè̤phè̌.’” ");
INSERT INTO kyu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Rò kayǎphè̌ yětôprè̤ hésû lǔ, “Lò̌꤮ yětahenuô vǎ tǒ̤ní̤ htuô̌lò̌hò́ rò vǎ krwǒme̤ htuô̌lò̌hò́ dố vǎ pacè̤̌khè̌ nuô pǎ cò́hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bí Jesǔ ní̤huô̌ a hé phúyě akhè̌nuô, a hé lǔ, “Tè̤ dố nè̤ lome̤ nuô a opǎ tôcô, ka̤ isè̌kyǎlò̌ nè̤ tǎ̤muô̌tǎ̤tè̤ nuôtahe rò zṳ́tǎ̤ pé̤ lò̌ ná kayǎ sǒphásǒrya̤phú nuôtahe. Nè̤ ki me̤phúnuô hérò nè̤ ki ní̤bè tè̤duzá̤htyathè̌ dố mò́khu pǎ. Ka̤me̤htuô̌ phúnuô rò hyǎ krwǒkuô̌ vǎkhyě.” ");
INSERT INTO kyu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kayǎphè̌ yětôprè̤nuô, a yǒ duzá̤ tǎ̤pòtǎ̤pè̤̌ cò́ akhu-akhyě bí a ní̤huô̌ ngó̤ yětômû̌ akhè̌nuô, a thè́plè̤̌ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesǔ myátǎ̤tǎ̤꤮ htuô̌ lǔ rò a hé, “Kayǎ duzá̤htyathè̌ tahe kíré̤ nuô̌ dố Cò́marya ahtyěaké̤kǔ nuô, apyá̤ nyacò́ dố èthǐgně cò́! ");
INSERT INTO kyu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tathíbuô̌du tôduô̌ kíré̤ plyénuô̌ dố htè́khǎlí̤kǔnuô azǔ klò̌pǎ cò́ ná kayǎ duzá̤htyathè̌ tôprè̤ kíré̤ nuô̌ dố mò́khu htyělé̤ké̤kǔ nuô cò́.” ");
INSERT INTO kyu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kayǎ dố a ní̤huô̌ Jesǔ tè̤hébè yětahenuô, a sudyǎ lǔ, “Ki me̤phúnuôrò ǔpě tôprè̤ kíré̤ ní̤bè cyá̤pǎ tè̤me̤lwóhteka̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Rò Jesǔ hésû, “Tè̤ dố kayǎ me̤cyá̤tonuô, Cò́marya me̤cyá̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petru hé, “Myámò̌, pè̤ dyakyǎ lò̌ cò́ hò́ pè̤hipè̤phyǎ tahe rò pè̤ krwǒkuô̌hò́ nè̤khyě hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Rò Jesǔ hé èthǐ, “Vǎ hélakǒ cò́ thǐ cò́, dố Cò́marya ahtyěaké̤ agněrò, kayǎ tôprè̤prè̤ ki dyakyǎ ahi-aphyǎ bèbè, aphúamě bèbè, apuố̤avyá̤ tahe bèbè, amuố̤aphè̌ bèbè hénuôma, ");
INSERT INTO kyu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Cò́marya ki dyépludyéphè è́lốklò̌ pǎ cò́ thǐ ná yětôhtû̌nuô pǎ, htuô̌to shyé꤮ nopǎ tôhtû̌nuô, Cò́marya ki dyé lǔ thè́htwǒprè̤ tacṳ́prè̤ talèkrè́ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesǔ è́ní̤huô tû́ prè̤dônyǎphú shyéthè́nyě̤, rò a hé èthǐ, “Pè̤ ki htya lò̌ dố vǐ̤ Jerusalem. Rò lò̌꤮ tè̤ritè̤kyǎ dố prè̤pro̤ tahe rǎ onekyǎ prè̤lukayǎ aphúkhǔ ari-akyǎ yětahenuô, a ki lốhtyabǎhtya pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Vǐ̤ Jerusalemphú tahe ki dyétǎ̤kyǎ vǎ dố Judaphú má̤to tahe a takhukǔ pǎ, rò èthǐ ki pacyé̤ nyě̤kruô̌ lò̌ vǎ rò htuplá lò̌ vǎ ná pli̤htyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Èthǐ ki plí vǎ rò me̤thyě vǎ pǎ tadû́rò thuô̌nyě tônyě pǎ nuô, vǎ ihtòhtwǒprè̤ ka̤khyě khyěthyá pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Manárò a khǒpacè̤̌ tahe thè́gněplǒ lǔ tè̤hébè yětômû̌꤮ to. Tè̤hébèyě angó̤lasá yěnuô, ǔ dya dò́uốdò́bí pé̤ èthǐ akhu-akhyě, èthǐ thè́gněplǒ lahyǎ a hé pé̤ èthǐ yěnuô to. ");
INSERT INTO kyu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bí Jesǔ hyǎtuố̤phûhò́ ná vǐ̤ Jeriko akhè̌nuô, kayǎ mèthèkhí kwǐesè onyǎo dố klyáhtû̌ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bí a ní̤huô̌ kayǎ bè́mṳ cuố bí lǔkhǎshyé akhè̌nuô, a sudyǎ ǔ, “Ǔ me̤ kryá꤮ ǐtě?” ");
INSERT INTO kyu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rò èthǐ héso pé̤ lǔ, “Vǐ̤ Nazarèphú Jesǔ hyǎnuô̌ cuốplúrwó bí vǐ̤kǔyě prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Rò a è́htǒhtya, “Kố꤮ Davi aklwǐalyǎ Jesǔ꤮ thè́zò̤ní̤ré̤ vǎ ní!” ");
INSERT INTO kyu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kayǎ cuố ré̤ dố nyě tahenuô a thè́prwǒ̤ lǔ rò, a nò̌ thuôthuô꤮ o lǔ tadû́rò a lé è́htǒ pra̤shyo ryáryá, “Kố꤮ Davi aphúkhǔ Jesǔ, thè́zò̤ní̤ kuô̌ré̤ vǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Phúnuô akhu-akhyě, Jesǔ okuố rò a nò̌è́hyǎ ǔ ná kayǎ mèthèkhí yěnuô tôprè̤ dố a o. Bí a hyǎtuố̤hò́ akhè̌nuô, Jesǔ sudyǎ lǔ, ");
INSERT INTO kyu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nè̤ thè́zṳ̂́ nò̌me̤ vǎ maǐtě?” Rò a hésû lǔ, “Byacè, vǎ thè́zṳ̂́ myáhtye cyá̤ kuô̌ǔ.” ");
INSERT INTO kyu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesǔ hé è, “Mèthè, lǐ mò̌꤮. Nè̤ tè̤zṳ̂́ zasǐmé̤hò́ nè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tôphuốtuô̌ a myáhtye cyá̤ rò a krwǒkuô̌ Jesǔ akhyě, rò a hébwíhétaryě Cò́marya. Rò bí kayǎ bè́mṳ myáhtye tè̤me̤htwǒhtya phúyě akhè̌nuô, a htuthè́htya lò̌plǐ cò́ Cò́marya pwǒ̤꤮ tôprè̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bí Jesǔ nuô̌cuốluplú rwó vǐ̤ Jeriko akǔ akhè̌nuô, ");
INSERT INTO kyu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","kayǎ htwǒ prè̤kwǐamo-arǎ khuklò́ dố amwi̤ ná Zakeǔ o tôprè̤, rò a duzá̤ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesǔ ma ǔpě nuô a thè́zṳ̂́ myáhtye kuô̌ tadû́rò a yǒ tapò́ dûgně, htuô̌rò kayǎ yǒ oró̤oè́sû́lû̌ akhu-akhyě a myáhtyehtwó kuô̌ǔ Jesǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Phúnuô akhu-akhyě, thyáphú a ki tṳ́htwó kuô̌ǔ Jesǔ rò, a klyacuố ré̤ dố kayǎ bè́mṳ anyěhyǎ bí Jesǔ lé̤cuố plehyǎ klyá yěnuô tôbǒ rò a cuốhtya dố kadwímò̤́ tômò̤́ alo̤. ");
INSERT INTO kyu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bí Jesǔ hyǎtuố̤ bí lǔkhǎshyé akhè̌nuô, a tṳ́htya lǔ rò a hé lǔ, “Zakeǔ, hítǎ̤pryǎ mò̌, me̤těhérò yětônyě pǎnuô, vǎ bè cuốolěo kuô̌ dố nè̤hi pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakeǔ hítǎ̤ tapluố̤taplyě rò a thè́krṳ̂̌thè́lò̌ è́mo̤sû cò́ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lò̌꤮ kayǎ dố a myáhtye Jesǔ cuố kuô̌ dố Zakeǔ ahi tahenuô, a tamwǒ̤talè̌ lò̌ lahyǎ rò a hé, “Kayǎ yětôprè̤ cuốolě tố̤kuô̌ tuố̤dố prè̤oraphú ahi.” ");
INSERT INTO kyu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakeǔ ihtò rò a hé Byacè, “Byacè, myámò̌, khǒnyá̤yě vǎ ucè̌tazè̌ dố a o ná vǎ taklǎměnuô, vǎ ki dyétǎ̤kyǎ ná kayǎ sǒphásǒrya̤phú tahe. Htuô̌to ki vǎ etṳ̂̌ǒplè ǔkhu tôprè̤prè̤ kihérò, vǎ ki dyéka̤khyě khyěthyá è lwǐ̤pwí pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Rò Jesǔ hé è, “Yětônyě, tè̤me̤lwóhteka̤ hyǎtuố̤ dố hiyě tômě akǔhò́ me̤těhérò kayǎ yětôprè̤ ma má̤kuô̌dû hò́ Abraham aklwǐalwí hò́! ");
INSERT INTO kyu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Me̤těhérò prè̤lu aphúkhǔ má̤hò́ vǎyě, vǎ hyǎ myápṳ̌ me̤lwóhteka̤ kayǎ dố a lamé̤ tahe.” ");
INSERT INTO kyu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bí kayǎ è́prè̤ ní̤dǎ Jesǔ tè̤hébè yě akhè̌nuô, a hé pé̤ pó̤ èthǐ ná ngó̤khákho tômû̌, me̤těhérò Jesǔ hyǎtuố̤ phû hò́ ná vǐ̤ Jerusalem hò́ khukhyě, Cò́marya ki cáhtya pố tôphuố pố cò́hò́ htyěké̤ hò́, èthǐ tane̤thû́ lò̌ lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Phúnuô akhu-akhyě a dyá pé̤ èthǐ, “Bètôphuố kayǎ htwǒdu otôprè̤. Thyáphú ǔ ki dyahtya lǔ ná khwí rò a ki htwǒ pé̤ ǔ khwí dố ahtyěaké̤kǔ ní̤dû agněnuôrò, a htecuố dố htyěruôké̤klò̌ tôba, htuô̌rò a ka̤khyě khyěthyá dố aké̤. ");
INSERT INTO kyu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bí a htecuố tyahíto akhè̌nuô, a è́plò́ alulé prè̤shyé, rò a dyé èthǐ htè̌ba tôprè̤ tôba, rò a hé èthǐ, ‘Bí vǎ oto yěakhè̌nuô, cuố me̤kuố̤me̤khá lahyǎ, me̤myéhte ní̤dyé lahyǎ tuố̤dố vǎ ka̤khyě pǎ nuô ní,’ a hékyǎ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Manárò, a htyěphúké̤phú thè́htethè́hǎ ní̤dyé lǔ rò èthǐ nò̌cuố lè̤́ prè̤thǔ tè̤ritè̤kyǎ tôprè̤ dố khwí o, rò a nò̌hé lǔ, ‘Kayǎ yětôprè̤nuô, pè̤ thè́zṳ̂́ nò̌htwǒ è ná pè̤khwí to.’ ");
INSERT INTO kyu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Manárò kayǎ htwǒdu yětôprè̤nuô, ǔ nò̌htwǒ è ná khwí rò a ka̤tuố̤ khyěthyá. Thyáphú èthǐ ki hyǎ dyéluô̌htya lahyǎ ná èthǐ me̤phúhteè́ tó̤ bá꤮ tě agněnuôrò, a ka̤tuố̤ rò a è́hyǎ alulé dố a dyékyǎ èthǐ htè̌ba yětahe dố a o. ");
INSERT INTO kyu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Aré̤lố tôprè̤ hyǎ dố a mèthènyě rò a hé lǔ, ‘Byacè, dố vǎ nò̌e htè̌ba dố nè̤ dyékyǎ vǎ yětôba akhu-akhyě vǎ ní̤bè è́htyalốpó̤ hò́ abashyé hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Rò a hé lǔ, ‘Aryá nyacò́! Nè̤ ma lulé dố aryá tôprè̤! Nè̤ cò́ ná vǎ dyé nè̤ tè̤patíphú yětahe akhu-akhyě, vǎ ki nò̌pố nè̤ ná vǐ̤ avǐ̤shyé pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Lulé nyě̤prè̤ tôprè̤ hyǎ dố a mèthènyě rò a hé lǔ, ‘Byacè, vǎ nò̌e htè̌ba dố nè̤ dyé vǎ yětôba akhu-akhyě, vǎ ní̤bè è́htyalốpó̤ hò́ htè̌nyǎ̤ba hò́.’ ");
INSERT INTO kyu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Rò a hé alulé yětôprè̤, ‘Vǎ ki nò̌pố nè̤ vǐ̤ nyǎ̤vǐ̤ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Rò lulé thuô̌prè̤ tôprè̤ hyǎ dố a mèthènyě rò a hyǎhé lǔ, ‘Byacè, yě lé꤮ nè̤ htè̌ba dố nè̤ dyékyǎ vǎnuô. Vǎ bedwóuố è dố zè̤̌krikǔ. ");
INSERT INTO kyu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Vǎ thè́isě nè̤lé̤, me̤těhérò nè̤ ma kayǎ dố apyá̤ nyacò́ tôprè̤. Nè̤tè̤ má̤to tahenuô, nè̤ cuố phyé dûgně. Htuô̌to nè̤ isò́iplû̌nò́ kuô̌ǔ to rò nè̤ cuố kè́ka̤plò́ dû nè̤gněnuô̌.’ ");
INSERT INTO kyu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Rò a hé lǔ, ‘Cṳ̂́cyě̤cṳ̂́cṳ̂, vǎ ki cirya nè̤ phú nè̤ hébèhte ní̤dyé nè̤ngó̤ yěnuôtahe pǎ. Nè̤ thè́gněhò́ ná vǎ ma kayǎ dố apyá̤ nyacò́ tôprè̤. Vǎtè̤ má̤to tahenuô vǎ cuốphyé dûgně. Vǎ isò́iplû̌tǎ̤nò́ kuô̌ǔ to rò vǎ cuốkè́ ka̤ dûgně tôprè̤ vǎhé! ");
INSERT INTO kyu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Phúnuôrò mame̤těrò nè̤ cuốsunuô̌ vǎ htè̌bayě dố ǔ lé̤be-oplò́ ǔ lé̤plwǒbò rû̌ hidukǔ nuô to me̤tě? Nè̤ ki me̤phúnuô hérò, shyé꤮ vǎ ka̤tuố̤ khyěthyá pǎ nuô, vǎ ki ní̤bè ka̤khyěkǔ aphúphú amuố̤muố̤ pǎ kǒkǒ.’ ");
INSERT INTO kyu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Htuô̌rò a hé kayǎ ihtòo bínuô tahe, ‘Phyé ka̤khyědwó khyěthyá htè̌banuô rò dyékyǎ ná kayǎ dố ahtè̌ba o abashyé yěnuô tôprè̤.’ ");
INSERT INTO kyu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Manárò èthǐ hésû lǔ, ‘Byacè, ahtè̌ba onehtuô̌ dû hò́ abashyé hò́!’ ");
INSERT INTO kyu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Rò khwí hésû èthǐ, ‘Vǎ hé thǐ, lò̌꤮ kayǎ dố atè̤one lò̌ cò́hò́ nuôtahe bèbè, ǔ lédyé è́htya pé̤pó̤ cò́ lǔ pǎ, manárò kayǎ dố atè̤ o to tôprè̤nuô, atè̤ oprè́ takiphúprè́ bèbè, ǔ ki phyéphekyǎphe lò̌ pó̤ lǔtè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Htuô̌rò, kayǎ dố a thè́hte vǎ rò a thè́zṳ̂́ nò̌htwǒ vǎ khwí to tahenuô, è́hyǎ lò̌ bíyě rò me̤thyěkyǎ lò̌ èthǐ dố vǎ mèthènyě yěnuô!’” ");
INSERT INTO kyu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesǔ héhtuô̌ phúnuôrò, a htya dố vǐ̤ Jerusalem rò a htecuố ré̤ a khǒpacè̤̌ dố nyě. ");
INSERT INTO kyu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bí a hyǎphûhò́ ná dò̌ Bethphage ná dò̌ Bethania dố a ophû ná Oliva so yětôdò̌ akhè̌nuô, Jesǔ nò̌hyǎ ré̤ a khǒpacè̤̌ thè́nyě̤. ");
INSERT INTO kyu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Rò a mecuốní̤ èthǐ ngó̤, “Hyǎnuô̌ré̤ lahyǎ dò̌ dố nyěnuô tôdò̌, thǐ hyǎ nuô̌nuô̌ ná thǐ ki myáhtye tathíphú tôduô̌ dố ǔ sidyánya̤ nò́hí lǔ tôphuố꤮ to tôduô̌ pǎ. Rò thǐ ki myáhtye ǔ cò̌klò̤ o è pǎ, rò ilyě è rò cwika̤ è bíyě ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kayǎ tôprè̤prè̤ ki sudyǎ thǐ, ‘Thǐ cuố ilyěkyǎtuố̤ tathíphú plye̤ me̤tě?’ A ki hérò, ‘Byacè lo è,’ hésû è phúnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Èthǐ cuố rò a myáhtye lò̌plǐ phú a héone pé̤ èthǐnuô tahe. ");
INSERT INTO kyu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bí èthǐ ilyě tathíphú plye̤ akhè̌nuô, ané̤byacè tahe hé èthǐ, “Thǐ cuốilyě tuố̤ tathíphúplye̤ me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Rò èthǐ hésû, “Byacè lo è.” ");
INSERT INTO kyu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Rò èthǐ cwika̤ní̤ tathíphú yěnuô dố Jesǔ a o. Htuô̌rò èthǐ idè̌htya lahyǎ aca̤klò̌ dố tathí nyá̤khu rò a nò̌htyasidyá Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bí Jesǔ sidyá tathíphú rò a htecuố akhè̌nuô, kayǎ tahe dè̌tǎ̤ ré̤ lahyǎ aca̤klò̌ tahe dố klyádè̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bí a hyǎphûhò́ ná vǐ̤ Jerusalem, bí klyá o dố Oliva sokhu rò a talwǒ̤tǎ̤ nuô̌hò́ dố vǐ̤kǔ yě akhè̌nuô, lò̌꤮ a khǒpacè̤̌ dố a krwǒ lò̌ lǔ nuôtômṳ cáhtya è́htǒhtuthè́ kè́kǒhtya lò̌ Cò́marya, me̤těhérò èthǐ yǒ myáhtye lò̌ tè̤pro̤tè̤prya̤ tahe akhu-akhyě, a è́htǒ lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Èthǐ htuthè́htya, “Cò́marya ki sò̌ridû khwí dố a hyǎ ná Byacè amwi̤ yětôprè̤ ní! Tè̤pě̤tè̤dwǒ ki o kuô̌dû dố mò́khu rò tè̤taryědu taryěhtǔ ki o kuô̌dû ná Cò́marya dố a o dố mò́khu akhǎlé̤ htyalô̌lố yětôprè̤ ní!” ");
INSERT INTO kyu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Htuô̌rò Pharisěophú o dố kayǎ bè́mṳ aklè̌ nuôtahe hé Jesǔ, “Thárá, nò̌othuôkyǎ nè̤ khǒpacè̤̌ yětahenuô, nò̌èhtǒ pǎ tǎ lahyǎ èthǐ tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Rò Jesǔ hésû èthǐ, “Vǎ hé thǐ, èthǐ ki othuôtakrû́kyǎ hénuôma, lò̤́ tahe ki è́htǒhtya kuô̌ke pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bí a hyǎphûhò́ ná vǐ̤ Jerusalem rò a myáhtye vǐ̤yě akhè̌nuô, a mèthèhtyětǎ̤. ");
INSERT INTO kyu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Rò a hé, “Yětônyě, nè̤ ki thè́gně bye ná ǔ phyéhyǎ pé̤ nè̤ tè̤pě̤tè̤dwǒ hénuôma aryá nyacò́, manárò khǒnyá̤yě nè̤ myáhtye cyá̤ kuô̌ǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tônyěnyě pǎnuô, shuốkhè̌ ki hyǎtuố̤ dố prè̤thè́hte nè̤ tahe ki hyǎ byáhtya bítava̤ lò̌ nè̤ ná vǐ̤ǔ htyalô̌ pǎ, rò èthǐ ki bòtǎ̤tṳ̂̌ tava̤bí lò̌ nè̤klyá pwǒ̤꤮ tôbǒ cò́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Htuô̌pǎrò èthǐ ki me̤pyékyǎ lò̌ nè̤ ná lò̌꤮ kayǎ o dố nè̤ vǐ̤kǔ nuôtahe pǎ. Bí lò̤́tômě prè́ nuô a ki oícû̌ ma pǎ cò́ lǔ to pǎ, me̤těhérò Cò́marya ki hyǎ me̤lwóhteka̤ nè̤ agněnuô, nè̤ dyathudyathè́ lǔ tè̤shuốtè̤khè̌ to akhu-akhyě, a ki me̤htwǒhtya phúnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Htuô̌rò Jesǔ cuốnuô̌ dố tè̤lǔtyǎ hǒkǔ rò a cuốnuô̌ vè̤́htekyǎ kayǎ ipri̤-isè̌tè̤ bínuô tahe. ");
INSERT INTO kyu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Rò a hé èthǐ, “Cò́marya alǎ̤angó̤ hé, ‘Vǎhi ma ǔ ki è́ è ná tè̤cò́bè̌ ahi,’ manárò thǐ cuốnò̌ htwǒhtya lò̤́hò́ è ná ‘Prè̤ehuôehí lé̤owóo akhǎlé̤ hò́.’” ");
INSERT INTO kyu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesǔ ithyóithyatǎ̤ ǔ dố tè̤lǔtyǎ hǒkǔ pwǒ̤꤮ tônyě cò́. Bwídukhu tahe, prè̤ithyó tè̤thyótè̤thya athárá tahe, ná prè̤ htwǒ kayǎ bè́mṳ a khuklò́khuklyǎ tahe thè́zṳ̂́ pṳ̌me̤thyě lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Manárò èthǐ tǒbè me̤ lǔ phútěnuô, a thè́gně lahyǎ aklyáaklǒ to, me̤těhérò kayǎ bè́mṳ tahenuô a ní̤dǎthyění̤dǎo cò́ lǔ tè̤hébè, rò a plwǒ latṳ̂̌ pǎ cò́ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tônyěkhè̌, Jesǔ o dố tè̤lǔtyǎ hǒkǔ rò a ithyóithyatǎ̤ kayǎ è́prè̤, rò a hésodônyǎ pé̤ ǔ ná tè̤thè́krṳ̂̌mila. Rò bínuôkhè̌, prè̤lǔtyǎ khuklò́ tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe, ná Judaphú aplò́amṳ khuklò́khuklyǎ tahe hyǎ dố lǔo. ");
INSERT INTO kyu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Rò a hé lǔ, “Hésoluô̌ pé̤ myá pè̤, nè̤ me̤tè̤ yětahe nuôma nè̤ cuốme̤ ná ǔpě a taryěshyosò̌ pě? Ǔpě nò̌me̤ nè̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Rò Jesǔ hésû èthǐ, “Ki héphúnuôrò, vǎ sudyǎ kuô̌ thǐ ngó̤ tômû̌, rò héluô̌ pé̤ kuô̌ vǎ. ");
INSERT INTO kyu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Giovanni Baptista plwǒ pé̤ ǔ htyě yěnuôma Cò́marya dyé lǔ taryěshyosò̌ è̌? Má̤torò prè̤lukayǎ dyé lǔ è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Èthǐ dônyǎ ní̤dyé khyělǔ, “Pè̤ tǒ hésû è phútě? Pè̤ ki hé, ‘Cò́marya dyé lǔ’ kihérò, a klyá sudyǎ nyǎ hò́ pè̤, ‘Kihéphúnuôrò thǐ zṳ̂́e lǔ to me̤tě?’ A klyá hé nyǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Má̤torò, ‘Prè̤lukayǎ dyé lǔ,’ pè̤ ki hé rò lò̌꤮ kayǎ bè́mṳ bíyě tahe yǒ zṳ̂́e ná Giovanni ma prè̤pro̤ tôprè̤ akhu-akhyě, èthǐ ki tá̤thyě pè̤ ná lò̤́ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Phúnuôrò èthǐ hésû, “Ǔpě dyé Giovanni taryěshyosò̌ dố a ki plwǒ pé̤ ǔ htyě yěnuô, pè̤ thè́gněto.” ");
INSERT INTO kyu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Rò Jesǔ hésû èthǐ, “Kihéphúnuôrò vǎ me̤tè̤ yětahe ná ǔpě taryěshyosò̌ pě nuô vǎ hésoluô̌ pé̤ thǐ toto.” ");
INSERT INTO kyu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Rò Jesǔ hésoluô̌ pé̤ kayǎ è́prè̤ ná ngó̤khákho tômû̌ rò a hé, “Bètôphuố kayǎ o tôprè̤, rò aprè́ dố a isò́iplû̌ ní̤dyé ná thòbǐthèmò̤́ tahenuô a o tôlé̤ rò a plwǒkhyǎekyǎ ná prè̤khyǎeprè́ tahe. Htuô̌rò a htecuố onyě̤kyǎ dố ké̤aruô tôké̤. ");
INSERT INTO kyu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bí thòbǐthè mǐhò́ akhè̌nuô, thyáphú a ki ní̤bèkuô̌ thòbǐthè dố a tǒkò ní̤bèkuô̌ nuôtaherò thòbǐthèphè byacè yě a nò̌hyǎkuô̌ a prè̤me̤tè̤phú tôprè̤ dố prè̤khyǎeprè́ nuôtahe a o. Manárò prè̤khyǎeprè́ yětahenuô, a mṳ̂̌sûpò̤sûhtuô̌ lǔlulé yětôprè̤ rò a plwǒka̤ kazuô̌klíkyǎ prè́ lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Phúnuô akhu-akhyě, a nò̌hyǎ tapleke alulé dố aruô tôprè̤ tadû́rò prè̤khyǎeprè́ yětahe mṳ̂̌sû khyěpó̤ lǔ, a me̤tarè̤̌kyǎ htuô̌ lǔ rò a plwǒka̤ kazuô̌klí kuô̌pó̤khyě lǔlǔ. ");
INSERT INTO kyu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Htuô̌rò a plwǒhyǎ pó̤ alulé thuô̌prè̤ tôprè̤, rò prè̤khyǎe thòbǐthèphè yětahenuô, a mṳ̂̌tapò̤̌lò́thò̌, mṳ̂̌cumṳ̂̌htyǎsû lò̌ lǔ rò vè̤́htekyǎ lǔ dố prè́klò̌. ");
INSERT INTO kyu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Rò thòbǐthèphè byacè hé, ‘Vǎ tǒbè me̤ phútě? Vǎ ki nò̌hyǎ ná vǎ phúprè̤khǔ dố vǎ mo̤ ní̤dyélố lǔ yětôprè̤ ma èthǐ ki dyaduzṳ̂́nyá̤ klò̌ lǔ pǎ kǒle,’ a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Manárò bí prè̤khyǎeprè́ yětahe myáhtye lǔ phúprè̤khǔ hyǎ akhè̌nuô, èthǐ hé ní̤dyé khyělǔ, ‘Yětôprè̤ ma prè́byacè aphúkhǔ dố a tǒ ní̤bè phúucè̌tazè̌ nuôtôprè̤ hò́. Cuố! Cuốme̤thyěkyǎ lǔ pó꤮! Rò a ucè̌tazè̌ yětahe nuô a ki htwǒ lò̌ pè̤tè̤ pǎ!’ ");
INSERT INTO kyu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Phúnuô akhu-akhyě, èthǐ cwitarṳ́ htekyǎ lǔ dố prè́klò̌ rò me̤thyěkyǎ lǔ. “Ki me̤phúnuôrò prè́byacè ki me̤ prè̤khyǎeprè́ yětahe phútě pǎ? ");
INSERT INTO kyu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A ki hyǎ me̤thyěkyǎ lò̌꤮ kayǎ nuôtahe rò a ki plwǒkhyǎe tapleke thòbǐthèphè yěnuô ná kayǎ dố aruô tahe pǎ.” Bí kayǎ è́prè̤ ní̤huô̌ tè̤hébèyě akhè̌nuô, èthǐ hé lahyǎ, “Pè̤ thè́zṳ̂́ nò̌htwǒhtya è phúnuô to!” ");
INSERT INTO kyu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesǔ myácuốtǒ èthǐ rò a sudyǎ èthǐ, “Kihéphúnuô rò lisǎsè̌ héone vǎrivǎkyǎ, ‘Kayǎ me̤htya hi rò lò̤́ dố èthǐ vǐkyǎ lǔ nuôtôměnuô, a htwǒhtya lò̤́ dố a tahtwóma lò̌ cò́ hitômě cò́,’ a hé phúyě rò angó̤lasá ma ǐtě?” A sudyǎ ǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Lò̌꤮ kayǎ dố a latǎ̤ dố lò̤́ nuôtômě alo̤ tahenuô, akrwí ki lakè̤́ prè́ pǎ, manárò lò̤́ nuôtômě ki latǎ̤ dố èthǐ alo̤ pǎ nuô, akrwíakrwó ki mû kaprǐ̤ lò̌ cò́ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Prè̤ithyó tè̤thyótè̤thya athárá tahe ná bwídukhu tahe thè́gně ná Jesǔ hékho èthǐ khukhyě tôphuốtuô̌ a thè́zṳ̂́ pṳ̂́ cò́ hò́ Jesǔ bínuô hò́. Manárò èthǐ thè́isě kayǎ bè́mṳ nuôtahe alé̤. ");
INSERT INTO kyu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Phúnuô akhu-akhyě, thyáphú èthǐ ki pṳ̂́ní̤ Jesǔ tè̤hébèthû́ngó̤ tahe, htuô̌to thyáphú èthǐ ki pṳ̂́thǔcuốkyǎ lǔ dố Romakhwí dố a o ná a taryěshyosò̌ ná a tè̤pro̤tè̤prya̤ yětôprè̤ a takhukǔ agněnuô, èthǐ opò̤́myá shuốkhè̌ tǎ̤tǒtǎ̤bè rò a nò̌cuố prè̤htû́myá tahe ki cyé̤me̤kho ané̤ phú kayǎcò́cû́ tahenuô rò èthǐ ki sudyǎ kho lahyǎ Jesǔ ngó̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kayǎ prè̤htû́myá yětahe sudyǎ Jesǔ, “Thárá꤮, pè̤ thè́gně ná nè̤ tè̤hébèhésû̌ tahe ná nè̤ tè̤ithyóithya tahe nuôma acò́ate̤, htuô̌to nè̤ myádumyápatí kuô̌ǔ to. Nè̤ ithyóithya ǔ phú atǒ ná Cò́marya aklyáaklǒ a tè̤má̤tè̤cò́ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Phúnuôrò héso pé̤myá pè̤, ma pè̤ tǒbè dyé Romakhwí amo-arǎ è̌? Ma to è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Manárò Jesǔ yǒ thè́gně ná èthǐ pṳ̌pṳ̂́ lǔ tè̤hébèthû́ akhu-akhyě, a hésû èthǐ, ");
INSERT INTO kyu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Dyéluô̌ pé̤ myá vǎ thǐrû̌zye tôbè. Dố rû̌zyelo̤ yěnuôma ǔpě khuklò́zǎ̤zo̤ ná ǔpě mwi̤ opě?” ");
INSERT INTO kyu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Rò èthǐ hésû lǔ, “Roma Khwí Caesare azǎ̤zo̤ ná amwi̤ o.” Rò a hésû èthǐ, “Ki me̤phúnuôrò, Khwídu Caesare atè̤ hérò dyé ná khwídunuô, Cò́marya atè̤ kihérò dyé ná Cò́marya nuô.” ");
INSERT INTO kyu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Rò èthǐ pṳ̂́ní̤ lǔ tè̤hébèthû́ dố ǔ è́prè̤ anyěhyǎ tômû̌꤮ to. Jesǔ hésû èthǐ phúyě akhu-akhyě a htetapa̤ lò̌plǐ cò́ èthǐ rò a o thuôkrû́kyǎ lò̌ prè́. ");
INSERT INTO kyu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saducěophú dố a zṳ̂́e ná kayǎthyě ihtòhtwǒprè̤ ka̤khyě to nuôtahe hyǎ dố Jesǔ o rò hyǎ sudyǎ lǔ ngó̤ tômû̌, ");
INSERT INTO kyu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Thárádu꤮, Mosè rǎkyǎ tè̤thyótè̤thya tômû̌ dố pè̤gně rò a hé, kayǎ tôprè̤prè̤ ki thyěkyǎ amělé̤, rò aphú ki okyǎ tôprè̤꤮ to hénuô, thyáphú aklwǐalyǎ ki okyǎ nuôrò, a puố̤prè̤khǔ bè phyédwó akhǐ okyǎyě, a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Khǒnyá̤rò puố̤ ná vyá̤ prè̤khǔ o thuô̌thyótôprè̤. A vyá̤prè̤́lố tôprè̤ phyé amě rò dốkhyěnuô a thyěkyǎ amě khǎlé̤, rò aphú okyǎ tôprè̤꤮ to akhu-akhyě apuố̤ dốkhyě tôprè̤ bèphyédwó akhǐ okyǎ yětôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Rò a puố̤prè̤khǔ nyě̤prè̤tôprè̤ phyédwó khyěthyá akhǐyě. ");
INSERT INTO kyu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Htuô̌rò a puố̤prè̤khǔ thuô̌prè̤tôprè̤ tuố̤dố thuô̌thyótôprè̤ yěnuô thyěkyǎ thyákuô̌ phúnuô, rò aphú okyǎ lahyǎ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dốkhyě rò prè̤mò yětôprè̤ thyěkyǎ kuô̌. ");
INSERT INTO kyu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Phúnuôrò shyé꤮ thyěihtòka̤khyě amò̤́nyě pǎ tônyěnuô, prè̤mò yětôprè̤ ki htwǒ bítě tôprè̤ amě pǎpě? Me̤těhérò èthǐ puố̤návyá̤ thuô̌thyótôprè̤ ní̤cû̌lò̌ lǔ prè̤mò yětôprè̤ nuô̌꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesǔ hésû èthǐ, “Yětôhtû̌nuô, ǔ phyéphúphyémě lahyǎ vǎ. ");
INSERT INTO kyu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Manárò kayǎ dố Cò́marya dyahò́ èthǐ ná a kò hò́ dố a ki thyě ihtòka̤khyě shyé꤮ nopǎ tôhtû̌ pǎ tahenuô, tè̤phyéphúphyémě opǎ to hò́. ");
INSERT INTO kyu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Èthǐ ki thyá ná tanémò́khuphú nuôtahe pǎ rò a thyě cyá̤ pǎ to. Èthǐ ihtò ka̤khyě dố tè̤thyě pǎ akhu-akhyě, èthǐ ma Cò́marya a phúmòphúkhǔ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Rò Mosè khyá lá̤lá̤lǐlǐ cò́ athè́ ná kayǎ dố a thyě htuô̌hò́ tahenuô, a ki ihtò htwǒprè̤ ka̤khyě pǎ, me̤těhérò Abraham ná Isaac ná Jacob yětahenuô, a thyěhtuô̌ nyě̤lǎhò́ tadû́rò lisǎsè̌kǔ hé o tôtó̤ ná bí mikyǎ̤htya cǎcuố̤ tôcuố̤ akhè̌nuô, Mosè è́ Byacè yěnuô, ‘Abraham a Cò́marya, Isaac a Cò́marya, ná Jacob a Cò́marya,’ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kayǎ pwǒ̤꤮ tôprè̤ ohtwǒprè̤ tacṳ́prè̤ lò̌ dố Cò́marya a mèthènyě akhu-akhyě, è ma kayǎthyě tahe a Cò́marya má̤to, kayǎ htwǒprè̤ tahe a Cò́marya.” ");
INSERT INTO kyu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Prè̤ithyó tè̤thyótè̤thya athárá tahe hé pó̤ è, “Thárá꤮ nè̤ hésû cyá̤ nyacò́ cò́.” ");
INSERT INTO kyu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Rò èthǐ sudyǎ plehyǎ bû pǎ lǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesǔ sudyǎ èthǐ, “Ǔ cuố hétuố̤ ná Krístu ma Davi aklwǐalyǎ ma phútě? ");
INSERT INTO kyu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Me̤těhérò bí Li Htuthè́htya akǔnuô, Davi ané̤byacè ní̤dû cuố rǎtuố̤, ‘Byacè hé vǎ Byacè, “Onyǎo dố vǎ takhu cò́htwó yětôkyě, ");
INSERT INTO kyu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","onyǎo tadû tuố̤dố vǎ me̤pé̤kyǎ lò̌lá̤takli lò̌ hò́ kayǎ dố a thè́hte nè̤ nuôtahe pǎní꤮. Vǎ ki nò̌htwǒ kayǎ dố a thè́hte nè̤ nuôtahe thyáná nè̤ khǎduô lé̤zí̤ dố nè̤ onyǎo rò nè̤ zí̤tǎ̤ ní̤dyé yěnuô pǎ.”’ ");
INSERT INTO kyu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Khwí Davi è́ Krístu ná ‘Byacè’ akhu-akhyě, a cuố htwǒ cyá̤ Khwí Davi aphúkhǔ phútě?” ");
INSERT INTO kyu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bí kayǎ è́prè̤ ní̤dǎ Jesǔ a tè̤hébè akhè̌nuô, a hé a khǒpacè̤̌ tahe, ");
INSERT INTO kyu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Rò̤ní̤ lahyǎ thǐné̤ ná prè̤ithyó tè̤thyótè̤thya athárá nuôtahe ní꤮. Èthǐ nuôtahema a thè́zṳ̂́ thyá lahyǎ ca̤cwo̤ karo̤htǔ rò a cuốka̤cuốhyǎ dố klè́kǔ rò a thè́zṳ̂́ nò̌ hébècè̤́hébènya̤ sû ǔ ná ané̤. Dố tè̤cò́bè̌hǒkǔ nuôbèbè, dố pwè̌kǔ nuôbèbè, èthǐ thè́zṳ̂́ onyǎo lahyǎ khǎlé̤ dố ǔ dyaduzṳ̂́nyá̤ní̤ è nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Èthǐ cuốlahǒe lahyaǒ lò̌ prè̤mòokryá tè̤ pwǒ̤꤮ tôcô. Thyáphú ǔ ki tane̤ní̤ èthǐ ná èthǐ ma kayǎsǎsè̌ tahe cò́ nuôrò, èthǐ kwǐcò́bè̌htǔ pé̤ ǔ. Kayǎ phúnuô tahenuô, tè̤cirya ki bè cyě̤ lốklò̌ cò́ ná ǔruô tahe pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bí Jesǔ myáhtya akhè̌, a myáhtye kayǎduzá̤ tahe hyǎ sunuô̌ lahyǎ a tè̤me̤lǔ tahe dố lé̤be-oplò́ rû̌tốkǔ dố tè̤lǔhǒdu akǔ. ");
INSERT INTO kyu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Htuô̌rò a myáhtye prè̤mòokryá sǒphásǒrya̤ tôprè̤ hyǎ sunuô̌ kuô̌ rû̌ talǐli̤ nyě̤myé. ");
INSERT INTO kyu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Rò Jesǔ hé, “Vǎ hécò́cò́꤮ thǐ, prè̤mòokryá nuôtôprè̤ sunuô̌ è́klò̌lố cò́ ná ǔruô tahehò́. ");
INSERT INTO kyu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Me̤těhérò lò̌꤮ a hyǎsunuô̌ rû̌ nuôtahema, a tè̤olốobǎ sû́lû̌ rò a hyǎsunuô̌ prè́ lahyǎ atè̤ o kyǎsò̌kyǎse kyǎ nuôtahe prè́. Manárò prè̤mòokryá yětôprè̤nuô a sǒphásǒrya̤ nyacò́ tadû́rò a hyǎsunuô̌ lò̌lá̤takli cò́ lò̌꤮ tè̤ dố a o ná lǔ yěnuô cò́.” ");
INSERT INTO kyu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jesǔ a khǒpacè̤̌ aklè̌ tahehenuô, a hébèdônyǎ ní̤dyé khyělǔ ná tè̤lǔhǒdu dố ǔ taritaryǎ twó̤ è ná lò̤́ ngṳdupri̤du tahe ná tǎ̤tè̤ dố ǔ lǔhtya ná Cò́marya nuôtahe akhu-akhyě atwó̤ nyacò́꤮ èthǐ dônyǎ ní̤dyé lǔ phúnuô tadû́rò Jesǔ hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Lò̌꤮ tè̤ dố thǐ myáhtye khǒnyá̤yě tahenuô, ǔ ki hyǎdò tǎ̤prò̤kyǎ lò̌ è pǎ. Lò̤́ yětahenuô a oícû̌ pǎ cò́ lǔ tômě꤮ to pǎnuô, shuốkhè̌ ki hyǎtuố̤ tônyě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Èthǐ sudyǎ, “Thárá, tè̤ yětahenuô a ki htwǒhtya bíkhè̌tě pǎ? Shuốkhè̌ kíré̤ hyǎtuố̤hò́ pǎ nuô tè̤pro̤tè̤prya̤ amáadyǎ tôcôcô ki oluô̌htyaré̤ pǎ è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesǔ hésû èthǐ, “Thyáphú ǔ ki ilolahǒ cuốní̤ tǎ thǐ tǎmé̤nuô, orò̤oryě̤ lahyǎ thǐné̤ ní꤮. Kayǎ dố a ki hyǎ dákwó lahǒ lahyǎ ané̤ ná vǎmwi̤ pǎnuô a o è́lǎ pǎ, rò a ki dákwó lahǒ lya̤ ní̤dyé lahyǎ ané̤, ‘Vǎ ma Krístu hò́,’ rò ‘Shuốkhè̌ phûtuố̤ hò́,’ phúnuô pǎ tadû́rò krwǒkuô̌ tǎ lahyǎ èthǐ akhyě tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bí thǐ ní̤huô̌ tè̤sátè̤pǎ̤ ná tè̤tarû̌tapyǎ ohtya akhè̌nuô, khyéthukhyéthè́ tǎ lahyǎ tǎmé̤ ní꤮. Me̤těhérò lò̌꤮ tè̤ yětahenuô, a bè ohtwǒhtya lò̌ré̤klò̌ nyǎpǎ tadû́rò hekhu tadû hyǎtuố̤ cò́ hò́nuô má̤híto.” ");
INSERT INTO kyu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesǔ hé plehyǎ pó̤, “Myěcô tôcô ná tôcô ki thè́htethè́hǎ lǔ pǎ. Htyěké̤ tôké̤ ná tôké̤ kisákipǎ̤ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tanéhtò́dǐ ki ohtyahtǒohtyalya̤ lò̌plǐ dố hekhuyě tôpho htuô̌ tôpho pǎ. Ké̤vǐ̤ké̤kò̌ ná tè̤sè̌ké̤rá̤ tahe ki ohtyahtǒohtyalya̤ è́lǎ dố khǎlé̤ è́pho pǎ. Tè̤taròthè́ thè́isě tahe ná tè̤amáadyǎ dố a tè̤pro̤tè̤prya̤ nyacò́ tahe ki oluô̌htya dố mò́lè̤̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Manárò bí tè̤yětahe htwǒhtya tyahíto akhè̌nuô, dố vǎmwi̤ akhu-akhyěrò ǔ ki pṳ̂́ thǐ ǔ ki me̤cyě̤me̤cṳ̂ thǐ pǎ, ǔ ki thǔcuố thǐ dố tè̤cò́bè̌hǒkǔ pǎ rò ǔ ki cirya thǐ pǎ, ǔ ki dò́tǎ̤ thǐ dố htò̌kǔ pǎ. Htuô̌rò ǔ ki thǔcuố thǐ dố khwí ná cò́phya tahe a mèthènyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yěma má̤hò́ thǐ ki ní̤bè tè̤shuốtè̤khè̌ dố thǐ ki hésodônyǎní̤ pé̤ ǔ ná vǎrivǎkyǎ nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Dyakṳ́dyakyǎ̤ one ré̤ tǎ thǐ thè́plò ná thǐ ki hébèsiplè́ ní̤dyé thǐné̤ phútěphútě pǎ nuô tǎmé̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Me̤těhérò, tè̤hébècyá̤hébèdè ná tè̤thítè̤phè́ dố kayǎ thè́hte thǐtahe ki hé ka̤khyěsû cyá̤ pǎ cò́ thǐ tôprè̤꤮ to tahenuô, vǎ ki dyédû thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Thǐ puố̤vyá̤, muố̤phè̌, klwǐlyǎ, khǒthyó tahe ki isè̌thyě ní̤dyédû thǐmwi̤ pǎ. Èthǐ ki me̤thyě thǐtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dố vǎkhuvǎkhyě rò kayǎ pwǒ̤꤮ tôprè̤ ki thè́hte lò̌ thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Manárò bí thǐ khuluô̤ tôbǒ prè́ pǎnuô, a sǐmé̤kyǎ pé̤ to. ");
INSERT INTO kyu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Oklò̤sò́ma lahyǎ rò thǐ ki me̤lwóhteka̤ ní̤dyédû thǐné̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Shyé꤮ thǐ myáhtyehò́ ná klyě tahe hyǎbòtava̤ hò́ vǐ̤ Jerusalem pǎ akhè̌nuô, thǐ bè thè́gně ná nyě̤tyato pǎ ma, ǔ ki me̤pyékyǎ è hò́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bínuôakhè̌, kayǎ o dố Judaké̤kǔ tahe bè hteklyacuố o dố sokhu pǎ. Kayǎ o dố vǐ̤duvǐ̤htǔkǔ tahenuô, a bè htecuốkyǎ pǎ, rò kayǎ o dố vǐ̤kǔ to tahenuô cuốkanuô̌ tǎ dố vǐ̤kǔ tǎmé̤ ní. ");
INSERT INTO kyu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Me̤těhérò, phú lisǎsè̌ rǎone tè̤cirya amò̤́nyěmò̤́thè̌ yětahe ari-akyǎ ki lốhtyabǎhtya pǎ agně prè́. ");
INSERT INTO kyu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mò̤́nyěmò̤́thè̌ bínuôkhè̌ pǎ ma, prè̤mò dố a o ná ahò́athè́ tahe ná muố̤ dố a o ná phúpatí dố a ǒnú pǎ lǔ tahenuô, ǔ ki thè́zò̤ ní̤dyé nyacò́ èthǐ pǎ. Tè̤cyě̤tè̤cṳ̂ ki hyǎ bè htyěké̤ yětôké̤ pǎ rò Cò́marya a tè̤cirya ki tǎ̤bè dố kayǎ yětômṳ akhu pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ǔ ki me̤thyě èthǐ tahehe ná nè́ pǎ, rò tahehenuô, ǔ ki pṳ̂́cwicuốkyǎ èthǐ dố ké̤pwǒ̤tôké̤ dố hekhu yěnuô pǎ. Judaphú má̤to tahe ki me̤cyě̤me̤cṳ̂ pé̤epé̤ǒ vǐ̤ Jerusalemphú tahe pǎ, rò a ki pố tuố̤dố èthǐ Judaphú má̤to tahe ashuốakhè̌ lốhtyabǎhtya hò́ tôphuố pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Tè̤mátè̤dyǎ khókhye tahe ki oluô̌htyaluô̌ dố tamò̤́kǔ, lè̌kǔ, sè thǐtahe akǔ pǎ. Dố hekhu yěnuô, htyě dố htyědutava̤ akǔ tahe yǒ háhó pra̤ tawò́tathû̌ shyonyacò́ akhu-akhyě, htyěké̤ pwǒ̤tôba ki taròthè́ thè́isě lò̌ rò a ki htetapa̤ lò̌plǐ cò́ èthǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tè̤yětahe ki htwǒhtya lò̌ cò́ hekhu tôbalò̌ pǎ, htuô̌to Cò́marya ki me̤kazikazuô̤̌ lò̌lò̌꤮ mò́lè̤̌ a tè̤pro̤tè̤prya̤ nuôtahe pǎ akhu-akhyě kayǎ tahe ki taròthè́ thè́isě lò̌plǐ cò́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Htuô̌rò èthǐ ki myáhtye lahyǎ prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎlya̤ dố ò́luố̤klè̌ pǎ, rò vǎ ki olốbǎ cò́ ná vǎ tè̤pro̤tè̤prya̤ ná vǎ tè̤taryědu taryěhtǔ dố ashyo-asò̌ yěnuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Shyé꤮ tè̤yětahe cáhtya me̤hò́ akhè̌pǎnuô, ihtò lahyǎ rò cò̤̌htya lahyǎ thǐ khuklò́, me̤těhérò, nyě̤tyato pǎma Cò́marya ki me̤lwóhteka̤ hò́ thǐ pǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesǔ hékhákho pé̤ èthǐ, “Tane̤myá lahyǎ kadwímò̤́ tômò̤́ ná thòmò̤́ ǐtětě꤮ bèbè nuô. ");
INSERT INTO kyu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Thǐ myáhtye ná alè dǎ dyácè̤́htyahò́ hénuô, thǐ thè́gně ná ké̤kṳ́khè̌ phûhyǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Phúnuôhò́ bí thǐ myáhtyehò́ tè̤yě tahe htwǒhtyahò́ akhè̌pǎnuô, thè́gně lahyǎ ná Cò́marya kíré̤ hyǎ pốhtyěpốké̤ phûhtya hò́ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Vǎ héluô̌cò́cò́꤮ cò́ thǐ, lò̌꤮ kayǎ dố a ohtwǒprè̤ khǒnyá̤yětôhtû̌ tahe thyělò̌ tyahíto nuô, tè̤yětahe ki htwǒhtya lò̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mò́khu ná hekhu ki sǐmé̤kyǎ pǎ tadû́rò vǎlǎ̤vǎngó̤ yětahenuô a sǐmé̤kyǎ pé̤ takhyá꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Rò̤ní̤ lahyǎ thǐné̤ ní. Bí thǐ emṳ̂ǒmṳ̂ akhè̌ thǐ me̤bò̌me̤bye tè̤ nuôtahe bèbè, thǐ kṳ́kyǎ̤ lahyǎ ná thǐ tè̤ohtwǒprè̤ dố hekhuyě tôhtû̌ tahenuô bèbè, me̤lò̌kyǎdě tǎ thǐ tè̤shuốtè̤khè̌ ná nuôtahe tǎmé̤ ní. Pǎma prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki hyǎtuố̤khyé dố thǐ o bí thǐ tane̤tuố̤ to nuôtônyě nuôtôthè̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Me̤těhérò tè̤cyě̤tè̤cṳ̂ ashuốakhè̌nuô athyáná itavǐ tôbanuô pǎ, a ki hyǎpṳ̂́ní̤ lò̌lò̌꤮ kayǎ o dố hekhu yětôba nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Thyáphú thǐ ki siplè́bè́ ryáryádèdè kyǎ ná tè̤ kíré̤ htwǒhtya yětahe pǎ, htuô̌to thyáphú thǐ ki ihtò dố prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě a mèthènyě pǎ nuôrò, thǎklyǎ rò kwǐcò́bè̌ lahyǎ pwǒ̤꤮ tôphuố ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesǔ ithyóithya tǎ̤ ǔ dố tè̤lǔtyǎ hǒkǔ pwǒ̤꤮ tônyě cò́. Rò bí mò̤́hélya̤ ashuốakhè̌nuô, a cuốhtya dố so dố ǔ è́ ná Oliva so yěnuôtômě alo̤, rò a o bínuô tuố̤dố mò̤́lǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kayǎ tahe thè́hyǎ ní̤dǎ lahyǎ a tè̤hésodônyǎ tahe rò a hyǎ ro̤mû́ lò̌plǐ dố tè̤lǔtyǎ hǒkǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pwè̌ekhò́mǔ sǒdǒ huô̌mûtapho dố ǔ è́ ná tè̤cuốtalwópwè̌ yěnuô, amò̤́nyěmò̤́thè̌ hyǎphû hò́. ");
INSERT INTO kyu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe thè́isě kayǎ bè́mṳ alé̤ akhu-akhyě, a myápṳ̌ klyá tôbǒbǒ dố a ki me̤thyěhuôkyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Htuô̌rò Juda dố ǔ è́pó̤ lǔmwi̤ ná Iscariot yětôprè̤nuô, khǐnéricyá̤ khuklò́ hyǎnuô̌ dố lǔ thè́plòkǔ. È ma a otố̤kuô̌ dố Byacè Jesǔ a khǒpacè̤̌ shyéthè́nyě̤ aklè̌ tôprè̤hò́. ");
INSERT INTO kyu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Phúnuô akhu-akhyě, Juda cuốodônyǎ ná bwídukhu tahe ná kayǎ opò̤́ tè̤lǔhǒdu khuklò́ tahe. Rò a cuốokúdônyǎ ní̤ èthǐ ná a ki isè̌tǎ̤kyǎ Jesǔ phútě pǎnuô ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Èthǐ thè́krṳ̂̌thè́lò̌ ò́lya̤sû Juda ná a ki dyé lǔ rû̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juda cṳ̌sû èthǐ. Htuô̌rò thyáphú ǔ ki thè́gně tǎ tôprè̤꤮ tǎmé̤ nuô, a cáhtya myápṳ̌ shuốkhè̌tǒ shuốkhè̌bè dố a ki isè̌tǎ̤kyǎní̤ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mò̤́nyěmò̤́thè̌ bèhò́ dố pwè̌ekhò́mǔ sǒdǒ huô̌mûtapho hyǎtuố̤hò́ rò Judaphú tahe me̤thyě lahyǎ thímíphú dố kiekiǒ ná tè̤cuốtalwópwè̌ agně. ");
INSERT INTO kyu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesǔ nò̌ Petru ná Giovanni rò a mecuốní̤ èthǐ ngó̤, “Cuố taritaryǎ one lahyǎ pè̤ lé̤elé̤ǒ tè̤cuốtalwópwè̌ sèesǎsè̌ mò̤́hé yěnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Èthǐ sudyǎ lǔ, “Nè̤ thè́zṳ̂́ nò̌taritaryǎ tǒ pè̤ bítě tôphotě?” ");
INSERT INTO kyu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesǔ hé èthǐ, “Ní̤dǎ lahyǎ, bí thǐ cuốnuô̌tuố̤hò́ dố vǐ̤kǔ akhè̌pǎnuô, thǐ ki myáhtyesû ná kayǎphè̌ hyǎdyá cò̤̌ka̤htyě ná thǒví tôprè̤ pǎ. Rò krwǒka̤ nuô̌kuô̌ cò́ lǔ dố a kanuô̌ ní̤dyé hitômě akǔnuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Rò sudyǎ hibyacènuô, ‘Thárá sudyǎ nè̤, hidò́kǔ dố sǐpré̤ agně dố vǎ ná vǎ khǒpacè̤̌ tahe ki e tè̤cuốtalwópwè̌ agně yěnuôma a o tǒbítě?’ Sudyǎ lǔ phúnuô ní. ");
INSERT INTO kyu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Htuô̌pǎrò a ki zṳ̌luô̌ thǐ hidò́kǔ khǎlé̤lyá̤ dố akhu nuôtôtó̤ dố a olốobǎ cò́ ná tǎ̤muô̌tǎ̤tè̤ dố pè̤ lo nuôtahe cò́ pǎ. Rò okyǎ lahyǎ bínuô rò taritaryǎ pé̤ lahyǎ pè̤ sèesèǒ bínuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Èthǐ htecuố rò èthǐ cuốmyáhtye má̤lakǒ cò́ phú Jesǔ héone èthǐ nuô cò́. Rò èthǐ cuố taritaryǎní̤ lahyǎ tè̤cuốtalwópwè̌ sèesǎsè̌ mò̤́hé agně bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bí shuốkhè̌ hyǎtuố̤hò́ dố tǒbè eǒ hò́ tè̤cuốtalwópwè̌ akhè̌nuô, Byacè Jesǔ ná prè̤dônyǎphú tahe cuố onyǎo tava̤ ró̤lò̌ lǔ dố lé̤edǐrè̤́ akhǎshyé. ");
INSERT INTO kyu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Rò a hé èthǐ, “Bí vǎ khyábè tyahí tè̤cyě̤tè̤cṳ̂ híto akhè̌nuô, vǎ thè́zṳ̂́ etố̤ǒtố̤kuô̌ nyacò́ tè̤cuốtalwópwè̌ yětôphuốnuô ná thǐ kanó̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Me̤těhérò, vǎ hé thǐ, Cò́marya ki hyǎihtaka̤ plû́htuô̌lò̌ hí akayǎ to rò a hyǎ htwǒkhwí rò pốní̤hí èthǐ tonuô, vǎ enò́kuô̌ pǎ tè̤cuốtalwópwè̌ sèesèǒ yěnuô ná thǐ to hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesǔ phyéhtya bě rò a hébwíhétaryěhtya Cò́marya htuô̌rò a hé, “Phyémò̌ běyě rò zṳ́tǎ̤ǒ pé̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Me̤těhérò vǎ hé thǐ, cáhtya khǒnyá̤yě tǎ̤plehyǎ tuố̤dố Cò́marya ki hyǎ pốhtyěpốké̤ pǎ tôphuốnuô, vǎ ǒnò́ kuô̌pǎ thòbǐthèhtyě yě tohò́.” ");
INSERT INTO kyu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Htuô̌rò Jesǔ phyé khò́mǔ rò a hébwíhétaryěhtya Cò́marya. Htuô̌rò a ibikyě khò́mǔ rò a dyétǎ̤ ná èthǐ. Rò a hé èthǐ, “Yěma vǎ né̤klò̤́ dố vǎ dyélya̤kyǎ dố thǐgně nuôhò́. E lahyǎ yě dố tè̤thè́né̤htya vǎ akǔ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bí a ehtuô̌hò́ mò̤́hésèe akhè̌nuô, a phyéhtyake běyě rò a me̤ thyákuô̌dû phú a me̤ khò́mǔnuô rò a hé, “Yěma vǎthwi dố a me̤klò̤me̤ma tè̤ò́lya̤ athè̌ rò a htwítǎ̤ dố thǐgně yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Manárò myá lahyǎ! Kayǎ dố a ki isè̌tǎ̤kyǎ vǎ yětôprè̤nuô, a otố̤kuô̌ ná vǎ bí lé̤edǐrè̤́ khǎshyé yěnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Prè̤lu aphúkhǔ má̤dû vǎyě a ki thyě phú Cò́marya a tè̤taze-one nuôpǎ tadû́rò kayǎ dố a ki isè̌tǎ̤kyǎ vǎ yětôprè̤nuô, a ki khyábè nyacò́ tè̤cyě̤cṳ̂ pǎ!” ");
INSERT INTO kyu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Rò èthǐ sudyǎ ní̤dyé lǔ tôprè̤ ná tôprè̤ rò a hé lahyǎ, bítě tôprè̤ ki isè̌tǎ̤kyǎ è pǎ ha? ");
INSERT INTO kyu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A khǒpacè̤̌ tahe krékryá̤ ní̤dyélǔ, dố pè̤klè̌ yěnuôma ǔpě ki htwǒdulố ǔ pǎ ha? Phúnuô, ");
INSERT INTO kyu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","rò Jesǔ hé èthǐ, “Judaphú má̤to tahe a khwícò́phya thǐ tahenuô, a nò̌e ní̤dyé lahyǎ a taryěshyosò̌ yěnuô dố htyěphúké̤phú tahe akhu rò prè̤pốtarítè̤ tahenuô, a thè́zṳ̂́ dố ǔ ki è́ èthǐ, ‘Prè̤ me̤bwíme̤taryě htyěphúké̤phú’ tahe phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Manárò thǐ yětahema thǐ bème̤ ní̤ kuô̌ǔ phúnuôto. Kayǎ dố a htwǒdulố ǔ dố thǐklè̌ tôprè̤prè̤nuô, a tǒbè htwǒ phú kayǎ dố a patílố tôprè̤nuô, htuô̌rò kayǎ dố a htwǒ khuklò́ tôprè̤prè̤nuô, a tǒbè htwǒ phú lulé tôprè̤nuô. ");
INSERT INTO kyu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kayǎ hekhuphú tahe tane̤ ná kayǎ onyǎo esèe dố dǐrè̤́ khǎshyé nuôma a htwǒ dulốǔ hò́, rò prè̤me̤tè̤phú dố a buôe kayǎ dố a onyǎ esè nuôtahe ma a htwǒ kayǎ dố a patílốǔ hò́ a tane̤ lahyǎ phúnuô. Manárò, vǎrò vǎ o dố thǐklè̌ phú lulé dố a buôebuôǒ ǔ tôprè̤ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Bí vǎ khyábè tè̤pyá̤tè̤sè̌ akhè̌nuô, thǐ okuô̌hò́ ná vǎ pwǒ̤꤮ tôphuố hò́. ");
INSERT INTO kyu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Phú vǎphè̌ nò̌pố vǎ nuô, vǎ nò̌pố kuô̌ thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Me̤těhérò thyáphú thǐ ki eǒ tố̤kuô̌ ná vǎ dố vǎ dǐrè̤́ khǎshyé dố vǎhtyěvǎké̤kǔ pǎ, htuô̌to thyáphú thǐ ki onyǎo tố̤nò́ kuô̌dû ná vǎ dố khuklyáhtè̌ htyalô̌ akhu pǎ rò thǐ ki cirya ní̤dû Israelphú shyényě̤muố̤ yěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simonè, Simonè, ní̤dǎ! Khǐnéricyá̤ khuklò́ cuốkwǐtadû ní̤ hò́ Cò́marya ná a ki plwǒhò́ khǐnéricyá̤ khuklò́ ki me̤myá lò̌ thǐ pwǒ̤prè̤ hò́. Rò a ki me̤myá thǐ phú prè̤me̤-elyá̤phú talè́ sè́ ní̤dyé abuố nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Manárò, Simonè, thyáphú nè̤ tè̤zṳ̂́tè̤nyá̤ ki pyékyǎ tǎmé̤ nuô, vǎ kwǐcò́bè̌ pé̤ dố nè̤gně. Htuô̌rò bí nè̤ thè́né̤lya̤ ka̤khyě khyěthyá hò́ nè̤né̤ pǎnuô, nè̤ tǒbè dyéhè̌dyérení̤ nè̤ puố̤vyá̤ tahe pǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simonè Petru hésû lǔ, “Byacè, vǎ tǒbè cuố tố̤kuô̌ ná nè̤ dố ǔ lé̤dò́tǎ̤ kayǎ a htò̌kǔnuô cò́ bèbè, má̤torò vǎ tǒbè thyě tố̤kuô̌ cò́ ná nè̤ bèbè, vǎ otaritaryǎ one hò́ vǎné̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Rò Jesǔ hésû lǔ, “Petru, vǎ hé nè̤, yětôthè̌ pǎ, bí shyěphè̌ i-uhtya tyahíto akhè̌nuô, nè̤ htébíkyǎ vǎ thuô̌phuố pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Htuô̌rò Jesǔ sudyǎ a khǒpacè̤̌ tahe, “Dố aré̤khè̌ nuô, vǎ nò̌cuố thǐ rò vǎ hé thǐ, rû̌htò̌ bèbè, pyě̤hó bèbè, má̤torò khuphá bèbè phyécuốní̤ tǎ lahyǎ tǎmé̤ ní꤮, vǎ hé thǐ phúnuô. Bínuôkhè̌ thǐ lonò́ pǎ nyǎ tôcôcô è̌?” Rò èthǐ hésû, “Pè̤ lonò́ tôcô꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Rò Jesǔ hésû èthǐ, “Manárò khǒnyá̤yě, ǔpě bèbè dố arû̌htò̌ má̤torò, apyě̤hó otahenuô tǒ phyécuốní̤ lahyǎ, rò kayǎ dố anè́ oto tahenuô tǒ isè̌kyǎ a ca̤klò̌du rò ipri̤cuốní̤ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Vǎ hé phúyě me̤těhénuôma lisǎsè̌ héone vǎrivǎkyǎ yěnuô, a bè lốhtyabǎhtya pǎ. Lisǎsè̌ hé, ‘Ǔ dyánuô̌ tố̤kuô̌ vǎ dố kayǎcyě̤ kayǎricyá̤ tahe aklè̌,’ vǎ hé thǐ yěnuô, a kíré̤ hyǎ lốhtyabǎhtya hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A khǒpacè̤̌ tahe hé, “Byacè, nè̤ myámò̌! Nè́ o bíyě nyě̤bè.” “Bánuô ma aní̤ hò́,” a hésû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesǔ o dố vǐ̤kǔ rò htecuố dố Oliva sokhu phú alé̤klǒ cuố ní̤dyé nuô, rò a khǒpacè̤̌ tahe krwǒcuố tố̤kuô̌ ná lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bí a cuốtuố̤hò́ dố sokhu akhè̌, a hé èthǐ, “Thyáphú thǐ ki cuốnuô̌ tố̤kuô̌ tǎ dố tè̤ilo-ilyá akǔ tǎmé̤nuô, kwǐcò́bè̌ lahyǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Htuô̌rò a htecuố taphǎye̤ ná èthǐ bá ǔ vǐcuốye̤ lò̤́ tômě nuô, rò a cuốdángṳ̂ kwǐcò́bè̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","A kwǐcò́bè̌ rò a hé, “Kố꤮ Phè̌ Cò́marya, nè̤ ki thè́plò tǒ hérò, phyé taphǎkyǎ pé̤ vǎ tè̤cyě̤tè̤cṳ̂ abělò̤́ yětôbè, manárò cṳ́꤮ dû vǎ thè́plò a tè̤thè́zṳ̂́ má̤to, cṳ́꤮ dû prè́ nè̤ thè́plò ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tanémò́khuphú tôprè̤ hyǎ oluô̌htya rò, a hyǎ dyéhè̌dyére lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A thè́plòkṳ́ thè́plòkyǎ̤ hyǎshyo rò, a lé kwǐcò́bè̌ shyolố pó̤pó̤. Rò akṳ́thǎ htwítǎ̤ dố hekhu rò a thyá cò́ ná thwitǎ̤mè̌ nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A kwǐcò́bè̌ htuô̌rò a ka̤khyětǒ khyěthyá dố a khǒpacè̤̌ tahe a o. A khǒpacè̤̌ tahe thè́plòkṳ́kyǎ̤ talwósû́lû̌ akhu-akhyě, Jesǔ ka̤myáhtye ná èthǐ omyění̤ sǒtapa̤ lò̌plǐ cò́ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesǔ hé èthǐ, “Thǐ omyě sǒtapa̤ lò̌ lahyǎ phútě? Thyáphú thǐ ki cuố latǎ̤nuô̌ tǎ dố tè̤ilo-ilyá akǔ tǎmé̤ nuô ihtòkwǐcò́bè̌ lò̌ mò̌ lahyǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bí Byacè Jesǔ hébè pǎprè́ akhè̌nuô, kayǎ bè́mṳ tômṳ hyǎtuố̤. Juda dố a khǒpacè̤̌ shyéthè́nyě̤ aklè̌ yětôprè̤nuô, a thǔhyǎ èthǐ dố Jesǔ a o, htuô̌rò a hyǎtǒ Jesǔ rò a hyǎnuô̤mû́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Manárò Jesǔ hé lǔ, “Juda꤮ yěma nè̤ isè̌tǎ̤kyǎ hò́ prè̤lukayǎ aphúkhǔ má̤hò́ vǎ yěnuô ná nè̤ tè̤nuô̤mû́ yěnuô hò́ è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","A khǒpacè̤̌ dố a okuô̌ ná lǔ tahenuô, a thè́gněhò́ ná ǔ kíré̤ pṳ̂́ hò́ Jesǔ hò́ akhu-akhyě, èthǐ sudyǎ lǔ, “Byacè, pè̤ tǒbè pǎ̤sû ná pè̤ nè́yě è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Rò dố èthǐ aklè̌ tôprè̤nuô, a pǎ̤tṳ̂̌kyǎ bwídukhulố a prè̤me̤tè̤phú tôprè̤ akhǎlè tôkhó. ");
INSERT INTO kyu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Manárò Jesǔ hé èthǐ, “Okuố lahyǎ, me̤pǎ tǎmé̤ hò́” htuô̌rò Jesǔ byáícû̌ ka̤khyě pé̤ khyěthyá kayǎ yětôprè̤ a khǎlèkuố̤ rò a zari̤ pé̤ khyěthyá lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Htuô̌rò prè̤lǔtyǎ khuklò́ nuôtahe ná kayǎ opò̤́ tè̤lǔhǒdu khuklò́ nuôtahe ná Judaphú muố̤prû̌muố̤prè̤́ khuklò́khuklyǎ dố a hyǎpṳ̂́ lǔ yětahenuô, Jesǔ hé èthǐ, “Thǐ hyǎpṳ̂́ lahyǎ vǎ tôkuôrò thǐ hyǎ cò́ ná nè́ ná imṳ̂̌ thǐtahe cò́ rò vǎ ma kayǎ cyě̤ricyá̤ dố a cuốpṳ̂́phezè́plè́ e ǔtè̤ tôprè̤ nyǎ è̌? ");
INSERT INTO kyu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Vǎ okuô̌ ná thǐ dố tè̤lǔtyǎ hǒkǔ nuô pwǒ̤꤮ tônyě cò́ rò thǐ pṳ̂́ vǎ toto, manárò bí khǐnéricyá̤ khuklò́ a taryěshyosò̌ pốtè̤ akhè̌yě, ashuốkhè̌ bèhò́ dố thǐ bè me̤nyǎ hò́ phúyě hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Èthǐ pṳ̂́ Jesǔ rò è́cuốkyǎ lǔ dố bwídukhulố tôprè̤ ahikǔ, rò Petru krwǒcuố lǒ kuô̌ lǔ dốkhyě. ");
INSERT INTO kyu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dố prè̤lǔtyǎdulố yětôprè̤ ahi vǐ̤klǎměkǔnuô, ǔ sû́kyǎ̤ o mi bínuô tôphè, rò Petru hyǎonyǎtǎ̤ tố̤kuô̌ ná kayǎ onyǎ iswími bínuô tahe. ");
INSERT INTO kyu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Prè̤me̤tè̤ prè̤mòphú tôprè̤ myárè̤̌tǎ̤tǎ̤ Petru onyǎo bí miphèshyé nuôrò a hé lǔ, “Yětôprè̤ ma má̤hò́ a krwǒkuô̌ Jesǔ akhyě nuôtôprè̤ vǎ꤮!” ");
INSERT INTO kyu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Manárò Petru htésû lǔ, “Mòmuố̤! Vǎ thè́gněnò́ lǔ to.” ");
INSERT INTO kyu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Dốkhyě taplô̤phúnuô, prè̤khǔ dố aruôtôprè̤ myáhtyeke è rò a hé lǔ, “Nè̤ ma tômṳmṳ꤮ tuô̌ prè́ ná èthǐ kayǎ nuôtahe prè́ vǎ!” Manárò Petru hésû lǔ, “Khǔphè̌, vǎ má̤ náto.” ");
INSERT INTO kyu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Htuô̌rò dốkhyě ashuốkhè̌ phûnyě̤hò́ tômû̌ akhè̌nuô, kayǎ dố aruôtôprè̤, hésò̌kadố cò́, “Kayǎ yětôprè̤ ma a otố̤kuô̌ ná Jesǔ nuôtôprè̤ hò́, vǎ héyě athû́ ná taki꤮ to, me̤těhérò è ma Galileaphú tôprè̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Manárò Petru hésû lǔ, “Khǔphè̌꤮, nè̤ hékryá꤮ ǐtě nuô, vǎ thè́gně to!” Bí a hébè pǎprè́ phúyě akhè̌nuônuô ná shyěphè̌ i-uhtya. ");
INSERT INTO kyu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Byacè tarí myácuố tǒdè̌ lǔ akhè̌, a tane̤htya tuố̤bè Byacè Jesǔ héonekyǎ lǔ ngó̤, “Yětôthè̌ pǎ, bí shyěphè̌ i-uhtya tyahíto nuô, nè̤ htébíkyǎré̤ vǎ thuô̌phuố pǎ,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Phúnuôrò a htecuốkyǎ dố aklò̌ rò a cuố nguố̤thyěnguố̤o cò́. ");
INSERT INTO kyu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kayǎ dố a opò̤́myá Jesǔ tahenuô, a hézò́hélě lǔ rò amṳ̂̌apò̤ lò̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Èthǐ cò̌bí Jesǔ mèthè rò sudyǎ lǔ, “Maǔpě mṳ̂̌ nè̤ pě? Pro̤ myámyá!” ");
INSERT INTO kyu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Htuô̌rò èthǐ pacyé̤ishyé hémǔmyá̤ricyá̤ lǔ ná ngó̤ dố aruôtahe nuô a o è́lǎpǎ. ");
INSERT INTO kyu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bí mò̤́lǐbǔhò́ akhè̌nuô, kayǎ htwǒ Judaphú aplò́amṳ a khuklò́khuklyǎ tahe, ná bwídukhu, ná prè̤ithyó tè̤thyótè̤thya athárá tahe hyǎ oplò́lò̌ lǔ tôphotuô̌, rò èthǐ è́hyǎ Jesǔ dố kayǎ htwǒdu tahe anyěhyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Rò èthǐ hé, “Héso pé̤myá pè̤, nè̤ ma Krístu dố Cò́marya nwóhtya è dố a ki me̤lwóhteka̤ prè̤lukayǎ nuôtôprè̤ hò́ è̌?” Rò a hésû èthǐ, “Vǎ ki hé pé̤ thǐ꤮ ma thǐ zṳ̂́e nyǎ ná vǎ toto. ");
INSERT INTO kyu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Vǎ ki sudyǎ thǐ꤮ ma thǐ hésû ná vǎ toto. ");
INSERT INTO kyu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Manárò cáhtya khǒnyá̤yě tǎ̤plehyǎ pǎnuô, prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ǔ ki dyéonyǎo è dố tè̤taryědu taryěhtǔ a Cò́marya takhu cò́htwó nuôtôkyě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Èthǐ pwǒ̤꤮ tôprè̤ hé, “Ki héphúnuô rò nè̤ ma Cò́marya aphúkhǔ tôprè̤ hò́ nuô̌?” Rò a hésû èthǐ, “Ò, a má̤lakǒ phú thǐ hé nuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Rò èthǐ hé lahyǎ, “Pè̤ cuố lo pǎ prè̤khyáthè́ phútě? A hé pé̤ pè̤ yěnuô, pè̤ ní̤huô̌ lò̌dûhò́ pwǒ̤꤮ tôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Htuô̌rò lò̌꤮ kayǎ htwǒdu yětahenuô, a ihtò rò a è́cuố Jesǔ dố Khwí Pilato anyěhyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Èthǐ be lahyǎ tè̤thû́ dố Jesǔ alo̤ rò a hé, “Pè̤ pṳ̂́ní̤ kayǎ yětôprè̤, me̤těhérò a thǔthû́ è́lǎ pè̤ kayǎ tahe aklyá, rò a hé ná lodyé ná Romakhwí amo-arǎ to, htuô̌to a hélya̤ní̤ pó̤ ané̤ ná vǎ ma Krístu dố a má̤dû khwí tôprè̤, a hé phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Khwí Pilato sudyǎ lǔ, “Nè̤ ma Judaphú akhwí tôprè̤ má̤lakǒ è̌?” Rò a hésû khwí, “Ò, a má̤lakǒ phú nè̤ hénuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Htuô̌rò Khwí Pilato hé bwídukhu tahe ná kayǎ bè́mṳ tahe, “Vǎ kíré̤ cirya kayǎ yětôprè̤nuô, vǎ myáhtye atè̤thû́ tôcô꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Manárò, èthǐ lé è́htǒhtya shyoshyoklò̌ pó̤, “A cuốlě me̤tarû̌tapyǎ lò̌ Judaphú tôké̤lè̤̌ ná a tè̤ithyóithya yěnuô. A cáhtya me̤ dố Galilea ké̤ rò a hyǎtuố̤hò́ bíyě hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bí Khwí Pilato ní̤huô̌ èthǐ hé ná Galilea ké̤, rò a sudyǎ èthǐ, “Kayǎ yětôprè̤ ma Galileaphú è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bí a thè́gně ná Jesǔ ma Galileaphú dố a o dố Khwí Herodè atè̤pố akhǎlé̤ akhè̌nuô, a nò̌thǔka̤khyě lǔ dố Khwí Herodè a o. Bínuôakhè̌ ma Khwí Herodè o dố vǐ̤ Jerusalem. ");
INSERT INTO kyu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bí Khwí Herodè myáhtye Jesǔ akhè̌nuô, a thè́krṳ̂̌thè́lò̌ nyacò́, me̤těhérò a ní̤huô̌ htuô̌hò́ Jesǔ ari-akyǎ rò a thè́zṳ̂́ myáhtye lǔ nuô anyě̤lǎhò́. A thè́zṳ̂́ myáhtye a ki me̤ tè̤pro̤tè̤prya̤ tôcôcô. ");
INSERT INTO kyu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Phúnuô akhu-akhyě Khwí Herodè sudyǎ è́lǎ Jesǔ tadû́rò Jesǔ hésû lǔ tômû̌꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bwídukhu tahe ná prè̤ithyó tè̤thyótè̤thya athárá dố a ihtòo lahyǎ bínuô tahe, myápṳ̌myávyá̤ pṳ̌ dya tadû cò́ Jesǔ tè̤thû́ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Khwí Herodè ná aklyěphú tahe nyě̤kruô̌ Jesǔ, hétakhwótakè lò̌plǐ Jesǔ, rò a thyáhtya pé̤ lǔ ca̤cwo̤twó̤ ca̤cwo̤ryá tôpṳ̂, rò Khwí Herodè nò̌thǔ ka̤khyě èthǐ dố Khwí Pilato a o. ");
INSERT INTO kyu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bínuôtônyěnuô, Khwí Herodè ná Khwí Pilato htwǒhtya khyělǔ khǒbò́thyó. Dố aré̤khè̌ nuôma èthǐ thè́htethè́hǎ ní̤dyé lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Khwí Pilato è́plò́ní̤ bwídukhu tahe ná kayǎ htwǒ prè̤pốtè̤ khuklò́khuklyǎ tahe ná kayǎ è́prè̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Rò a hé èthǐ, “Thǐ hyǎthǔ kayǎ yětôprè̤ dố vǎ o, rò thǐ hé ná a thǔthû́ kayǎ bè́mṳ tahe aklyá, thǐ hé phúnuô. Khǒnyá̤yě vǎ sudyǎce̤myá hò́ è dố thǐ mèthènyě hò́ tadû́rò phú thǐ kè̤ lǔ nuô, vǎ myáhtye atè̤thû́ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Khwí Herodè nò̌thǔka̤khyě khyěthyá lǔ dố pè̤ o me̤těhérò è myáhtye lǔtè̤thû́ tôcô꤮ toto. Kayǎ yětôprè̤nuô, atè̤thû́ o dố a tǒbè thyěnuô a o tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Phúnuô akhu-akhyě, vǎ ki nò̌plí ǔ ná è, htuô̌rò vǎ ki plwǒhteka̤kyǎ lǔ.” ");
INSERT INTO kyu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Kayǎ bè́mṳ è́htǒhtya lò̌, “Me̤thyěkyǎ è, plwǒhte pé̤ pè̤ dố Barabba nuô.” Dǎ cuốtalwópwè̌ ashuốakhè̌ hyǎtuố̤hò́ hénuô, pwè̌yě alé̤klǒ o ná Khwí Pilato bè plwǒhte pé̤ èthǐ kayǎ dố ǔ dò́tǎ̤ lǔ dố htò̌kǔ tahe aklè̌ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ǔ me̤súsá dố vǐ̤kǔ akhè̌nuô, Barabba yǒ cuốme̤súsá patố̤kuô̌ǔ akhu-akhyě, ǔ dò́tǎ̤ lǔ dố htò̌kǔ, htuô̌to ènuô a me̤thyěnò́ kayǎ tôprè̤prè̤.) ");
INSERT INTO kyu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Khwí Pilato thè́zṳ̂́ plwǒhtekyǎ Jesǔ rò a hé khyěthyápó̤ ná kayǎ bè́mṳ tahe, ");
INSERT INTO kyu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","manárò èthǐ è́htǒhtyasû tadû, “Mṳ̂̌thyěhtyakyǎ è dố krusulo̤ nuô! Mṳ̂̌thyěhtyakyǎ è dố krusulo̤ nuô!” ");
INSERT INTO kyu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Rò Khwí Pilato hépó̤ èthǐ thuô̌phuốtôphuố, “Mame̤těrò bè mṳ̂̌thyěhtyakyǎ lǔ? A me̤thû́ maǐtě? A me̤thû́tè̤ dố a tǒbè thyě cò́ nuô, vǎ myáhtye tôcô꤮ to. Vǎ ki nò̌mṳ̂̌ ǔ ná è rò vǎ ki plwǒka̤kyǎ è pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","A hé phúnuô tadû́rò èthǐ lé꤮ è́htǒhtyashyo klò̌lố pó̤ ná ki mṳ̂̌thyěhtyakyǎ Jesǔ dố krusulo̤. Rò dốkhyětadûnuô, èthǐ pé̤kyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Phúnuô akhu-akhyě, Khwí Pilato ciryakyǎ Jesǔ phú èthǐ kwǐ lǔ nuô prè́. ");
INSERT INTO kyu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Khwí Pilato plwǒhte pé̤ èthǐ kayǎphè̌ dố èthǐ thè́zṳ̂́ nò̌plwǒhte lǔ nuôtôprè̤. Kayǎphè̌ yětôprè̤ ma a me̤tarû̌tapyǎ tè̤, a me̤thyě ǔ rò ǔ dò́o lǔ dố htò̌kǔ. Htuô̌rò thyáphú èthǐ ki me̤ lǔ cṳ́꤮ dû èthǐ thè́zṳ̂́ me̤nuô rò a dyétǎ̤kyǎ Jesǔ dố èthǐ atakhukǔ. ");
INSERT INTO kyu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bí klyěphú è́cuốhò́ Jesǔ akhè̌nuô, èthǐ cuốtǎ̤sû ná kayǎ tôprè̤ dố amwi̤ ná Simonè. È ma vǐ̤ Cyreneophú tôprè̤, rò a o dố dò̌ hyǎ prè́ rò a hyǎnuô̌ dố vǐ̤kǔ. Bí a hyǎnuô̌ akhè̌nuô, klyěphú pṳ̂́sû lǔ rò èthǐ dyahtya Jesǔ krusu dố lǔplǎkhu, rò a nò̌zá lǔ rò a nò̌krwǒcuố kuô̌ lǔ dố Jesǔ akhyěkhu. ");
INSERT INTO kyu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kayǎ krwǒcuốplu krwǒcuốphè kuô̌lò̌ Jesǔ akhyě, rò dố kayǎ yětahe aklè̌nuô, prè̤mò dố a thè́plè̤̌nebè nyacò́ tahenuô, a opacuốtố̤kuô̌ bínuô, rò a nguố̤thyěnguố̤o lahyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesǔ tarícuố tǒ èthǐ rò a hécuố èthǐ, “Vǐ̤ Jerusalem phúmò thǐ꤮, nguố̤ tǎ dố vǎgně tǎmé̤, nguố̤ ní̤dyédû lahyǎ dố thǐgně ná thǐphúthǐlye̤ tahe agněnuô. ");
INSERT INTO kyu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Me̤těhérò, tè̤cyě̤tè̤cṳ̂ amò̤́nyěmò̤́thè̌ tahe ki hyǎtuố̤ pǎ rò ǔ ki hé lahyǎ, ‘Prè̤mòsǒphú ná prè̤mò dố aphú onò́ kuô̌ lahyǎ tôphuố꤮ to, ná prè̤mò dố a dyéǒnúnò́ dyé kuô̌ pacè̤̌ tôphuố꤮ to tahe ki ní̤bè nyacò́ tè̤sò̌ri!’ Ǔ ki hé lahyǎ phúyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bínuôkhè̌pǎ ‘Ǔ ki hé lahyǎ lá̤so tahe pǎ, “Latǎ̤prò̤ dố pè̤khuyě!” Htuô̌to a ki hé lahyǎ sophú tahe, “O tadwǒbíré̤ pè̤ ní꤮!”’ ");
INSERT INTO kyu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Vǎ dố athyáná thòthíthuô̌ yěnuô, èthǐ ki me̤cyě̤me̤cṳ̂ cò́ vǎ báyě kihérò, kayǎ dố aruô dố a thyá lahyǎ prè́ ná thòkrǎ tahenuô, èthǐ ki me̤cyě̤me̤cṳ̂lố pǎpǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Èthǐ cwicuốní̤ kuô̌ kayǎ dố a me̤thû́ htyěké̤ a tè̤thyótè̤thya thè́nyě̤lò̌ dố a ki mṳ̂̌thyěhtya tố̤kuô̌ ná Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Èthǐ cuốtuố̤ dố khǎlé̤ tôpho dố ǔ è́, “khuklò́krwí” khǎlé̤ yěnuô. Htuô̌rò èthǐ mṳ̂̌thyěhtya tố̤kuô̌ kayǎ me̤thû́ htyěké̤ a tè̤thyótè̤thya yěthè́nyě̤ ná Jesǔ dố krusulo̤. Tôprè̤ rò a mṳ̂̌thyěhtya lǔ dố Jesǔ cò́htwó tôkyě, tôprè̤ rò a mṳ̂̌thyěhtya lǔ dố cò́ci tôkyě. ");
INSERT INTO kyu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesǔ hé, “Phè̌꤮, plwǒkyǎ èthǐ tè̤thû́ ní꤮, me̤těhérò èthǐ me̤ tè̤phúyěnuô, a thè́gně ní̤dyé to.” Rò klyěphú tahe ki iběphyé ní̤ró̤lǔ Jesǔ hyeca̤ yěnuôrò èthǐ bò́ lahyǎ tè̤byǎbwí tôcô dố cṳ́꤮ dû a tǎ̤tǒ bítě tôprè̤ tǒ phyé bítě tôkyě tě phúnuôprè́. ");
INSERT INTO kyu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kayǎ tahe ihtòomyá lahyǎ pǎprè́ bínuô akhè̌, kayǎ dố a htwǒ khuklò́khuklyǎ tahe pacyé̤ishyé nyě̤kruô̌ lahyǎ Jesǔ, rò a hé lahyǎ, “È ma a me̤lwóhteka̤ cyá̤ dǎdu꤮ ǔ ni. È ki má̤lakǒ Krístu dố Cò́marya nwóhtya è nuôtôprè̤ kihérò, nò̌me̤lwóhteka̤ ní̤dyé kuô̌mò̌ ané̤nuô to.” ");
INSERT INTO kyu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Klyěphú nuôtahe bèbè, a nyě̤kruô̌ kuô̌ lò̌ lǔ. Èthǐ cuố dố Jesǔ a o rò a cuốdyéǒ lǔ htyězǎ̤taprè. ");
INSERT INTO kyu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Rò èthǐ hé lǔ, “Nè̤ ki má̤lakǒ Judaphú tahe akhwí kihérò me̤lwóhteka̤ ní̤dyé kuô̌mò̌ nè̤né̤ nuô to.” ");
INSERT INTO kyu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dố a khuklò́htè́nuô, ǔ rǎhtya o, “È ma Judaphú tahe akhwí.” ");
INSERT INTO kyu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kayǎ dố a me̤thû́ htyěké̤ a tè̤thyótè̤thya rò ǔ mṳ̂̌thyěhtya tố̤ lǔ ná Jesǔ yěthè́nyě̤ aklè̌ tôprè̤ nuô a pacyé̤ishyé Jesǔ, “Nè̤ ma Krístu má̤to è̌? Me̤lwóhteka̤ ní̤dyé kuô̌mò̌ nè̤né̤nuô, rò me̤lwóhteka̤ kuô̌mò̌ pè̤ to!” ");
INSERT INTO kyu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Manárò kayǎ me̤thû́ htyěké̤ a tè̤thyótè̤thya dố aruôtôprè̤ thè́prwǒ̤ lǔ rò a hé lǔ, “Nè̤ thè́isě kuô̌ǔ Cò́marya to è̌? Nè̤ ma nè̤ ní̤bè thyákuô̌dû tè̤cirya thyáná è yěnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pè̤ yěthè́nyě̤ ní̤bè tè̤cirya phú pè̤ me̤thû́htuô̌hò́ nuôtahe akhu-akhyě akòabè prè́. Manárò ènuô, a me̤thû́ kuô̌ǔ tôcô꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Htuô̌rò a hé Jesǔ, “Kố꤮ Jesǔ꤮, bí nè̤ hyǎpốhò́ phú khwí tôprè̤ hò́ akhè̌pǎnuô, thè́né̤htyabè tuố̤kuô̌ vǎ pǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Rò Jesǔ hésû è, “Vǎ hécò́cò́꤮ cò́ nè̤, yětônyě pǎnuô, nè̤ ki ka̤-o tố̤kuô̌dû ná vǎ dố Paradisǔ ké̤kǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bí mò̤́htuô shyényě̤mû̌ phûbèhò́ akhè̌nuô, tamò̤́ khítarṳ̂tǎ̤ tôké̤lè̤̌ tuố̤ cò́ dố mò̤́hélya̤ thuô̌mû̌ bè nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Rò ikè̤̌badu dố ǔ cò̤́tǎ̤tṳ̂̌bí lǔ dố tè̤lǔhǒdu akǔ yětôbanuô, a lazè̤̌ kahtyakalya̤ plû́kyǎ nyě̤kyě. ");
INSERT INTO kyu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesǔ cyé̤pryě̤ è́htǒhtyashyo rò a hé, “Kố꤮ phè̌꤮, vǎ dyélya̤kyǎhò́ vǎ thè́htwǒprè̤ dố nè̤ takhukǔ hò́,” a hé phúnuô htuô̌rò a thè́tǎ̤plû́kyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Roma klyětôzè̤ khuklò́ yětôprè̤ myáhtye tè̤me̤-ané̤ yětahe rò a htuthè́htya Cò́marya rò a hé, “Kayǎ yětôprè̤ ma kayǎcò́kayǎte̤ má̤lakǒ cò́ nyǎ hò́!” ");
INSERT INTO kyu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kayǎ è́prè̤ dố a hyǎ opò̤́myá rò a myáhtye tè̤me̤htwǒhtya ané̤ yětahenuô, a thè́plè̤̌ lò̌plǐ cò́ akhu-akhyě èthǐ htòlya̤ ní̤dyé lahyǎ ataǒ rò a ka̤ lahyǎ dố ahi. ");
INSERT INTO kyu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lò̌꤮ kayǎ dố a thè́gně Jesǔ tahe ná prè̤mò dố a o dố Galilea ké̤kǔ rò a krwǒ hyǎkuô̌ lǔ tahenuô, a cuố ihtòo lǒtaphǎye̤ rò a myá lahyǎ lò̌꤮ a htwǒhtya yětahe. ");
INSERT INTO kyu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kayǎ dố amwi̤ ná Joseph o tôprè̤. A o dố vǐ̤ Arimathea, Juda ké̤kǔ. È ma kayǎryá, kayǎcò́cû́ dố a opò̤́myásû̌ Cò́marya ahtyěaké̤ ki hyǎ pǎ tôprè̤. È ma a opatố̤kuô̌ dố kayǎ htwǒdu aplò́amṳkǔ tôprè̤ tadû́rò bí ǔ ò́lya̤ lò̌ ná ǔ ki cirya Jesǔ akhè̌nuô, a ò́lya̤ patố̤ kuô̌ǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A cuố dố Khwí Pilato a o rò a cuốkwǐ Jesǔ aluô̤̌to̤. ");
INSERT INTO kyu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Htuô̌rò a cuố cò̤̌tǎ̤ Jesǔ a luô̤̌to̤yě dố krusu alo̤ rò a bobí lǔ ná ikè̤̌báplǐ ngṳdu tôba htuô̌rò a cuốdyanuô̌ lǔ dố luô̤̌kǔ dố ǔ ikhûkǔnuô̌ o lǔ dố sorò̤̌lo̤ dố ǔ iluốnò́ hí ná luô̤̌ tôphuố híto yěnuô tôkǔ. ");
INSERT INTO kyu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mò̤́nyě nuôtônyě ma mò̤́nyǎ̤nyě dố ǔ taritaryǎ one lahyǎ Judaphú a Mò̤́nyěduô agně. Judaphú a Mò̤́nyěduô phûhyǎtuố̤hò́. ");
INSERT INTO kyu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Prè̤mò o dố Galilea ké̤ rò a krwǒhyǎkuô̌ Jesǔ akhyě yětahenuô, a krwǒhyǎkuô̌ ná Joseph rò a myátǒ̤ma ní̤kyǎ ǔ lé̤dyanuô̌ Jesǔ akhǎlé̤ yětôpho. ");
INSERT INTO kyu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Htuô̌rò èthǐ ka̤khyě dố hi rò a ka̤ taritaryǎ one lahyǎ htyěnuô̤mû́ ná myrra dố a ki hyǎ plò̤́ pé̤ lahyǎ ná luô̤̌to̤yě agně. Manárò bí Judaphú a Mò̤́nyěduô nuôtônyěnuô, Judaphú tahe a tè̤thyótè̤thya o ná èthǐ bè okuố akhu-akhyě, èthǐ okuố lò̌ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mò̤́nyě thuô̌thyótônyě kalúlố tônyě bí mò̤́lǐro̤mû́ akhè̌nuô, prè̤mò yětahe phyéní̤ htyěnuô̤mû́ dố èthǐ taritaryǎ one hò́ yětahe rò a hyǎ lahyǎ dố luô̤̌khu. ");
INSERT INTO kyu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Rò lò̤́ dố ǔ htulò̌bí lǔ ná luô̤̌kǔ nuôtôměnuô, èthǐ myáhtye ná ǔ htulò̌taphǎ cuốkyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Èthǐ nuô̌myá tadû́rò a myáhtye pǎ Jesǔ aluô̤̌to̤ to. ");
INSERT INTO kyu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bí èthǐ ihtò tane̤ tè̤ritè̤kyǎ yěakhè̌nuô, kayǎ dố a kû̌thyá hyeca̤ takhè̌rasǒ thè́nyě̤ oluô̌htyakhyé pé̤ èthǐ rò a hyǎihtòo dố èthǐ khǎshyé. ");
INSERT INTO kyu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Prè̤mò yětahe thè́isě talwósû́lû̌ rò a dángṳ̂lya̤ rò ngò̤taklwí vǐtǎ̤lò̌ amèthè dố hekhu, rò kayǎ yěthè́nyě̤ hé èthǐ, “Thǐ cuốmyápṳ̌ kayǎ htwǒprè̤ dố kayǎ thyě tahe aklè̌ me̤tě? ");
INSERT INTO kyu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesǔ opǎ bíyě to hò́, a ihtò htwǒprè̤ ka̤khyě hò́. Thè́né̤htya khyěthyá lahyǎ bí a o dố Galilea ké̤ akhè̌ rò a hésokyǎ htuô̌hò́ thǐ ngó̤ nuôtahenuô. ");
INSERT INTO kyu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě, ǔ ki dyétǎ̤kyǎ vǎ dố kayǎ tè̤thû́tè̤oraphú tahe a takhukǔ pǎ. Ǔ ki mṳ̂̌thyěhtya vǎ dố krusu alo̤ pǎ, rò bí thuô̌nyětônyě pǎnuô, vǎ ki ihtò htwǒprè̤ ka̤khyě khyěthyá pǎ.’” ");
INSERT INTO kyu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yětôphuốrò prè̤mò tahe thè́né̤htyabè khyě a tè̤héso onekyǎ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Rò èthǐ hteka̤kyǎ dố ahi rò a ka̤héso pé̤ lò̌ tè̤ritè̤kyǎ yě ná prè̤dônyǎphú shyétôprè̤ yěnuô ná kayǎ dố aruô dố a okuô̌ ná èthǐ lò̌꤮ plǐ bínuô tahe. ");
INSERT INTO kyu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Prè̤mò yětahe ma má̤hò́ Magdalena dò̌kǔmuố̤ Maria, Joanna ná Jakomo amuố̤ Maria thǐnuô tahe hò́. Èthǐ yětahe ná prè̤mò dố aruô tahe hésoluô̌ pé̤ prè̤dônyǎphú tahe ná tè̤ritè̤kyǎ yětahe. ");
INSERT INTO kyu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Manárò prè̤dônyǎphú yětahe tane̤ lahyǎ ná prè̤mò yětahe hébò̌hébye prè́ akhu-akhyě a zṳ̂́e kuô̌ èthǐ to. ");
INSERT INTO kyu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Manárò Petru ihtòklyahyǎ dố luô̤̌khu rò bí a hyǎngò̤myácǒ nuô̌ akhè̌nuô, a myáhtye tû́ ikè̤̌ báplǐhtǔ nuôtôba prè́. A hyǎmyá htuô̌ phúnuôrò a ka̤khyě khyěthyá dố hi. A cuốhtwǒhtya tuố̤ phúyě me̤tě a tane̤ rò a khyéthukhyéthè́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Bínuôtônyě hò́, Jesǔ a khǒpacè̤̌ thè́nyě̤ cuố dố dò̌ Emmao dố a oye̤ ná vǐ̤ Jerusalem ma a phû꤮ o thuô̌thyótômile. ");
INSERT INTO kyu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Rò èthǐ dônyǎcuố ní̤dyélǔ ná lò̌꤮ tè̤me̤htwǒhtya htuô̌hò́ ari-akyǎ yěnuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bí èthǐ hébèdônyǎ ní̤dyélǔ akhè̌nuô, Jesǔ hyǎphûkuô̌ dố èthǐ a o rò a cuố takro̤ kuô̌ ná èthǐ. ");
INSERT INTO kyu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Èthǐ myáhtye lǔ tadû́rò a thè́gně lahyǎ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesǔ hé èthǐ, “Thǐ hébèdônyǎcuố kryá lǔ ná tè̤ritè̤kyǎ ǐtětě?” Yětôphuốrò èthǐ ihtòokuố lahyǎ rò èthǐ mèthènuô, a thè́plè̤̌thè́zò̤ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bínuô aklè̌ tôprè̤ dố amwi̤ ná Cleopa yětôprè̤nuô a sudyǎ lǔ, “Dố vǐ̤ Jerusalem akǔ yěnuô, kayǎ htwǒsǐpré̤ ma a onyǎ prè́tû́ nè̤tôprè̤ nyǎ hò́. Pahéuô̌hénu rò ǔ me̤kryá꤮ maǐtě nuôma nè̤ thè́gně kuô̌ nyǎ ǔ tôcô꤮ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Rò Jesǔ sudyǎ lǔ, “Ǔ me̤ kryá꤮ ǐtě?” Rò èthǐ hésû lǔ, “Má̤hò́ vǐ̤ Nazarèphú Jesǔ ari-akyǎ nuô kǒkǒ꤮. È ma prè̤pro̤ tôprè̤. A tè̤hébèhésû̌ ná a tè̤phyétè̤me̤ dố Cò́marya ná prè̤lukayǎ lò̌꤮ plǐ anyěhyǎ nuô, a o ná tè̤pro̤tè̤prya̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Thyáphú pè̤ bwídukhu tahe ná pè̤ kayǎdu tahe ki cirya thyěkyǎ lǔ agněnuô a dyétǎ̤kyǎ lǔ dố Khwí Pilato a khadǎkǔ rò a mṳ̂̌thyěhtyakyǎ lǔ dố krusulo̤. ");
INSERT INTO kyu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Manárò pè̤ myásû̌ thè́lè̤ní̤ è ná a ki me̤lwóhteka̤ Israelphú tahe pǎ. Phúnuôhtuô̌to, yětônyěma tè̤me̤htwǒhtya ané̤ bǎhtyahò́ thuô̌nyě hò́. ");
INSERT INTO kyu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Prè̤mò dố pè̤klè̌ tahenuô, èthǐ hyǎ ro̤mû́ lahyǎ dố luô̤̌khu rò a ka̤ hékhyéhézû́ lò̌plǐ pè̤. ");
INSERT INTO kyu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Me̤těhérò èthǐ hyǎ rò a hyǎ myáhtye luô̤̌to̤ yěnuô to hénuô̌꤮. Èthǐ ka̤khyě rò a ka̤hé ná èthǐ myáhtye tanémò́khuphú tahe oluô̌htya pé̤ èthǐ, rò a hé èthǐ ná Jesǔ htwǒprè̤ ka̤khyě hò́, hénuô̌. ");
INSERT INTO kyu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Prè̤khǔ dố pè̤klè̌ tahehe klyahyǎmyá lahyǎ dố luô̤̌khu rò a myáhtye Jesǔ luô̤̌kǔ okò̌khǔkyǎ thyáná prè̤mò nuôtahe hénuôprè́ hénuô̌. Rò èthǐ myáhtye Jesǔ to, hénuô̌.” ");
INSERT INTO kyu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Phúnuô htuô̌rò Jesǔ hé èthǐ, “Kayǎ olốoklò̌ thǐ꤮ prè̤pro̤ tahe héonekyǎ ngó̤ tahenuô, thǐ zṳ̂́e pyá̤ nyacò́ vǎ꤮! ");
INSERT INTO kyu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Krístu tǒbè khyá tè̤cyě̤tè̤cṳ̂ yětahe htuô̌rò a ki cuốnuô̌ dố a tè̤taryědu taryěhtǔ akǔ pǎ má̤to è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Htuô̌rò Jesǔ hésodônyǎplǒ pé̤ èthǐ ná lisǎsè̌ héone htuô̌hò́ è ari-akyǎ cáhtya dố Mosè rǎkyǎ li nuôtahe ná lò̌꤮ prè̤pro̤ rǎkyǎone nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bí èthǐ cuốtuố̤phûhò́ ná dò̌ dố a kíré̤ cuố yětôdò̌ akhè̌nuô, Jesǔ me̤ phú a kíré̤ cuố talwókyǎ ná dò̌yěnuô. ");
INSERT INTO kyu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Manárò èthǐ è́ tadû lǔ rò a hé lǔ, “Nuô̌ okuốkuô̌ ná pè̤ bíyě hò́, mò̤́ kíré̤ phûtǎ̤hò́, pǎma mò̤́khí tatílè́ nè̤ he.” Phúnuô akhu-akhyě Jesǔ cuốnuô̌ okuốkuô̌ ná èthǐ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bí a onyǎ etố̤kuô̌sè ná èthǐ akhè̌nuô, a phyé khò́mǔ rò a hébwíhétaryěhtya Cò́marya htuô̌rò a ibikyě khò́mǔ rò a zṳ́e pé̤ ná èthǐ. ");
INSERT INTO kyu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Htuô̌rò èthǐ mèthè lǐhtya rò a thè́gně tǒ̤maní̤ khyě Jesǔ, rò tôphuốtuô̌ Byacè Jesǔ sǐmé̤ pé̤kyǎ dố èthǐ mèthènyě. ");
INSERT INTO kyu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Èthǐ hé ní̤dyé khyělǔ, “Bí a hébè ná pè̤ dố klyálo̤ akhè̌nuô bèbè, bí a hésodônyǎplǒ pé̤ pè̤ ná lisǎsè̌ a tè̤héso-one thǐtahe akhè̌nuô bèbè, dố pè̤ thè́plòkǔ nuô, a tapṳ̂́kazò̤́ thè́krṳ̂̌thè́lò̌htya cò́ phúnuô vǎhéto?” ");
INSERT INTO kyu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tôphuốtuô̌ èthǐ ihtòka̤ dố vǐ̤ Jerusalem. Rò èthǐ ka̤myáhtye ná prè̤dônyǎphú shyétôprè̤ ná ǔruô tahe oplò́ tố̤lò̌ lǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Prè̤dônyǎphú yětahe hé pé̤ kayǎ hyǎtuố̤ mópǎ yěthè́nyě̤, “Byacè ihtò htwǒprè̤ ka̤khyě má̤lakǒ cò́ hò́ meně. A dyéluô̌ pé̤ htuô̌hò́ ané̤ ná Simonè hò́!” ");
INSERT INTO kyu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A héhtuô̌phúnuô rò kayǎ yěthè́nyě̤ hésoluô̌ pé̤kuô̌ke èthǐ ná bí èthǐ cuố dố klyálo̤ akhè̌nuô, a me̤kryá pé̤ èthǐ phútě, htuô̌rò èthǐ thè́gněno prè́ Jesǔ bí a ibikyě khò́mǔ akhè̌nuô prè́, a héluô̌ pé̤ke èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bí kayǎ yěthè́nyě̤ hésopé̤ èthǐ ná tè̤ritè̤kyǎ yě akhè̌nuô, Jesǔ ané̤ Byacè ní̤dû hyǎihtò oluô̌khyé pé̤ dố èthǐ klǎměkǔ rò a hé èthǐ, “Tè̤thè́plò kacṳ́kabè́ ki okuô̌dû ná thǐ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Èthǐ tane̤ lahyǎ ná a myáhtye luô̤̌taprya̤ rò a thè́isě khyézû́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Rò Jesǔ hé èthǐ, “Thǐ tane̤ thè́isě lò̌ lahyǎ me̤tě? Thǐ thè́plò rarò̌rare lò̌ lahyǎ me̤tě? ");
INSERT INTO kyu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Thyáphú thǐ ki myáhtyethè́gně tǎ̤te̤ ná vǎ né̤klò̤́ o má̤lakǒ agněnuô, myámò̌ lahyǎ vǎ takhu ná vǎ khǎduôyě, hyǎphû̌myá lahyǎ mò̌ vǎné̤yě, me̤těhérò, luô̤̌taprya̤ nuôma, apháazye akrwíakrwó okuô̌ǔ phú vǎ yěnuô to.” ");
INSERT INTO kyu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A héhtuô̌ pé̤ èthǐ phúnuôrò a dyéluô̌ pé̤ èthǐ ná atakhu ná akhǎduô. ");
INSERT INTO kyu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Èthǐ thè́krṳ̂̌thè́lò̌ lahyǎ rò a htebíhtetapa̤ lò̌ lahyǎ lǔ akhu-akhyě, a zṳ̂́eryá lahyǎ híto. Htuô̌rò Jesǔ sudyǎ èthǐ, “Thǐ sèesèǒ o tôcôcô è̌?” ");
INSERT INTO kyu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Èthǐ dyé lǔ tè̤̌isû́ tôkwophú. ");
INSERT INTO kyu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Rò a phyésû rò a ehtyaluô̌ pé̤ dố èthǐ mèthènyě. ");
INSERT INTO kyu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Htuô̌rò a hé pé̤ èthǐ, “Bí vǎ okuô̌pǎ ná thǐ akhè̌nuô, lò̌꤮ ǔ rǎo htuô̌hò́ vǎrivǎkyǎ dố Mosè alikǔ nuôtahe bèbè, prè̤pro̤ rǎokyǎ nuôtahe bèbè, dố Li Htuthè́htya akǔ nuôtahe bèbè, a bè lốbǎhtya lò̌plǐ pwǒ̤꤮ tôcô pǎnuô, vǎ hésoluô̌ pé̤ htuô̌lò̌hò́ thǐ hò́.” ");
INSERT INTO kyu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Htuô̌rò thyáphú èthǐ ki thè́gněplǒphè́ryá lisǎsè̌ tahe agněnuô, a bámǒhtya pé̤hò́ èthǐ thè́plòtane̤ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Rò a hé pé̤ èthǐ, “Lisǎsè̌ héone, Krístu ki khyábè tè̤cyě̤tè̤cṳ̂ pǎ htuô̌rò thuô̌nyětônyě pǎnuô, a ki ihtòhtwǒprè̤ ka̤khyě dố tè̤thyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Htuô̌rò dố èmwi̤ akǔ rò ǔ ki hésodônyǎ tè̤za̤ ní̤ ari-akyǎ ná tè̤plwǒkyǎ tè̤thû́tè̤ora yěnuôtahe ari-akyǎ pǎ. Ǔ ki hésodônyǎ è dố myěcô pwǒ̤tôcô agně pǎ, rò ǔ ki cáhtya hésoré̤lố dố vǐ̤ Jerusalem akǔ nuôpǎ. ");
INSERT INTO kyu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Thǐ ma prè̤khyáthè́ dố a htwǒ pé̤ tè̤ritè̤kyǎ yětahe agně tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Rò vǎ ki nò̌hyǎlya̤ pé̤ thǐ phú vǎphè̌ ò́lya̤ one htuô̌hò́ nuôtôcô dố thǐlo̤ pǎ. Manárò thǐ ki ní̤bè hí tè̤taryěshyosò̌ dố a o dố mò́khuyě hyǎlya̤ tyahí dố thǐlo̤ to nuô, thǐ bè opò̤́tadû bí vǐ̤kǔ yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Htuô̌rò dốkhyěnuô, a è́cuố a khǒpacè̤̌ tahe dố vǐ̤klò̌, rò a è́cuốtuố̤ èthǐ dố dò̌ Bethania akhǎshyé, rò a zó̤htya atakhu rò a sò̌ri èthǐ. ");
INSERT INTO kyu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bí a sò̌ri pǎprè́ èthǐ akhè̌nuô, ǔ cò̤̌ka̤kahtya taphǎkyǎ lǔ dố mò́khu rò a dya-okyǎ kyǎ a khǒpacè̤̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Èthǐ cò́bucò́bè̌htya htuô̌ lǔ rò èthǐ thè́krṳ̂̌thè́lò̌ ka̤khyě lahyǎ dố vǐ̤ Jerusalem akǔ. ");
INSERT INTO kyu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Htuô̌rò èthǐ o dố tè̤lǔtyǎ hǒkǔ pwǒ̤꤮ tôphuố rò htuthè́ hébwíhétaryěhtya Cò́marya bínuô.");
INSERT INTO kyu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dố Cò́marya byálya̤ hí hekhu to akhè̌pǎnuô, ǔ è́ lǔ ná tè̤lǎ̤tè̤ngó̤ yětôprè̤nuô, a ohtuô̌dû hò́. Tè̤lǎ̤tè̤ngó̤ yěnuô a o kuô̌ ná Cò́marya rò tè̤lǎ̤tè̤ngó̤ yěnuôma má̤hò́ Cò́marya hò́. ");
INSERT INTO kyu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dố Cò́marya byálya̤ hí hekhu to akhè̌pǎnuô è otố̤kuô̌ ná Cò́marya dố kalúkhè̌ pǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cò́marya nò̌byálya̤ dǐtû́ lǔ tè̤pwǒ̤tôcô. Tè̤ dố a byálya̤ to nuô a o tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","È ma tè̤htwǒprè̤ a khǎshyékhǎrya̤ rò tè̤htwǒprè̤ yěnuô a dyé tè̤lǐ dố ǔ pwǒ̤꤮ tôprè̤ agně. ");
INSERT INTO kyu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","È ma athyáná tè̤lǐ rò a lǐtakhè̌ dố tè̤khítè̤lò̤ aklè̌ rò tè̤khítè̤lò̤ me̤pé̤kyǎ cyá̤ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Cò́marya nò̌hyǎ kayǎ tôprè̤ dố amwi̤ ná Giovanni Baptista. ");
INSERT INTO kyu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Thyáphú kayǎ pwǒ̤꤮ tôprè̤ ki ní̤huô̌ a tè̤hésodônyǎ tahe rò a ki zṳ̂́enyá̤e agněnuô, a hyǎ hésothè́gně pé̤ ǔ ná kayǎ dố Cò́marya nò̌hyǎlya̤ lǔ phú tè̤lǐ yěnuô tôprè̤ ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Giovanni nuôma tè̤lǐ má̤to. Manárò è ma prè̤ hyǎ hésothè́gně pé̤ ǔ ná tè̤lǐ ari-akyǎ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tè̤lǐ má̤lakǒ yěnuô, a kíré̤ hyǎnuô̌ hò́ dố hekhuyě hò́, rò a ki lǐtakhè̌ htyaluô̌ pé̤ ǔ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A hyǎ ohtwǒprè̤ htuô̌hò́ dố hekhuyě hò́. Rò a byálya̤ ní̤dû cò́ hekhuyě tadû́rò è ma kayǎ phútě tôprè̤nuô hekhuphú thè́gněplǒ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A hyǎ dố a htyěphúké̤phú ní̤dû yětahe a o tadû́rò akayǎ ní̤dû tahe è́sû lǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Manárò kayǎ dố a è́sû lǔ tahe rò a zṳ̂́enyá̤e lǔ tahenuô a dyéhtwǒhtya èthǐ ná Cò́marya a phúmòphúkhǔ tahe. ");
INSERT INTO kyu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Èthǐ htwǒhtya cyá̤ Cò́marya a phúmòphúkhǔ ná phú kayǎ lé̤klǒ opacè̤̌lya̤ ní̤dyé aphú nuôtahe má̤to. Htuô̌rò phú muố̤phè̌ a tè̤thè́zṳ̂́thè́lò̌ rò aphú o ní̤dyédû nuô má̤to. Má̤tôkhónuô, èthǐ htwǒhtya cyá̤ Cò́marya a phúmòphúkhǔ phú Cò́marya athè́plò oní̤dû nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kayǎ dố ǔ è́ è ná tè̤lǎ̤tè̤ngó̤ yětôprè̤nuô, a hyǎhtwǒ phú prè̤lukayǎ nuô rò a hyǎ ohtwǒprè̤ hò́ dố pè̤klè̌. Pè̤ myáhtyehò́ a tè̤taryědu taryěhtǔ. Cò́marya aphúkhǔ yǒ otû́ tôprè̤prè́ akhu-akhyě, è ní̤bè lò̌plǐ cò́ tè̤taryědu taryěhtǔ yě dố aphè̌o cò́. È ma kayǎ dố a lốbǎ ná tè̤bwítè̤taryě ná tè̤má̤tè̤cò́ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Giovanni hésothè́gně è ari-akyǎ rò a è́htǒhtya, “Phú vǎ héso htuô̌pé̤hò́ thǐ è ari-akyǎ, ‘Kayǎ dố a ki hyǎ dố vǎkhyěkhu pǎ tôprè̤nuô a taryěpro̤prya̤ duhtǔklò̌ cò́ ná vǎ pǎ, me̤těhérò bí vǎ opacè̤̌lya̤ híto akhè̌nuô, a one htuô̌dûhò́.’” ");
INSERT INTO kyu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Abwíataryě olốobǎ cò́ akhu-akhyě, pè̤ lò̌꤮ plǐ ní̤bè kuô̌dûhò́ tè̤bwítè̤taryě tôcô htuô̌ tôcô dố lǔo hò́. ");
INSERT INTO kyu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Cò́marya dyétǎ̤ tè̤thyótè̤thya ná Mosè rò Mosè dyétǎ̤ dǐtû́ ná pè̤, tadû́rò Jesǔ Krístu mamá̤ kayǎ dố a dyétǎ̤ pé̤ pè̤ tè̤bwítè̤taryě ná tè̤má̤tè̤cò́. ");
INSERT INTO kyu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ǔ myáhtyenò́ Cò́marya tôprè̤꤮ to tadû́rò, aphúkhǔ otû́ tôprè̤ yěnuôma má̤hò́ Cò́marya hò́ dố a otố̤kuô̌ ná a Phè̌ yě dyéluô̌htyahò́ pè̤ ná Cò́marya hò́. ");
INSERT INTO kyu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bètôphuố Judaphú khuklò́khuklyǎ dố a o dố vǐ̤ Jerusalem akǔ tahe nò̌cuố bwídu ná Leviphú dố a me̤cwó̤ tè̤lǔhǒdu tahe dố Giovanni a o rò a nò̌sudyǎ lǔ, “Nè̤ ma ǔpě?” Rò Giovanni héluô̌ thè́gně pé̤ èthǐ, ");
INSERT INTO kyu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","“Vǎ ma Messia má̤to.” A ò́lya̤ lá̤lá̤lǐlǐ sûpé̤ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Èthǐ sudyǎ pó̤, “Ki me̤phúnuôrò, nè̤ ma ǔpě? Nè̤ ma Prè̤pro̤ Elia è̌?” Rò Giovanni hésû èthǐ, “má̤to.” Htuô̌rò èthǐ sudyǎ pó̤, “Nè̤ ma prè̤pro̤ dố Cò́marya ò́lya̤ dố a ki nò̌hyǎlya̤ lǔ pǎ nuôtôprè̤ è̌?” Rò a hésû, “má̤to.” ");
INSERT INTO kyu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Htuô̌rò èthǐ hé, “Thyáphú pè̤ ki ka̤ héluô̌bè́ pé̤ kayǎ dố a nò̌cuố sudyǎ pè̤ tahe agněnuô, hésoluô̌ pé̤ pè̤ ná nè̤ ma ǔpě? Nè̤ hé ní̤dyé nè̤né̤ ná nè̤ ma ǔpě?” ");
INSERT INTO kyu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Giovanni hésû phú Prè̤pro̤ Isaiah hénuô, rò a hésû èthǐ, “Vǎ ma kayǎ tôprè̤ dố a è́htǒhtya dố ké̤sè̌htyěkya̤ lò̤́tamákhu, ‘Me̤cò́ one pé̤ lahyǎ Byacè lé̤hyǎ klyá agně ní꤮,’ a ki è́htǒ pé̤ ǔ nuôtôprè̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pharisěophú tahe nò̌hyǎ kayǎ yětahe dố Giovanni a o, ");
INSERT INTO kyu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","rò èthǐ hyǎ sudyǎ pó̤ Giovanni, “Nè̤ ki má̤ Krístu má̤toto, Prè̤pro̤ Elia má̤toto, prè̤pro̤ dố Cò́marya ò́lya̤ dố a nò̌hyǎ lǔ nuôtôprè̤ má̤toto kihérò nè̤ cuố plwǒ pé̤ tuố̤ ǔ htyě me̤tě?” Èthǐ hé lǔ phúnuô, ");
INSERT INTO kyu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Rò Giovanni hésû èthǐ, “Vǎ plwǒ pé̤ ǔ ná htyě tadû́rò dố thǐklè̌ nuô kayǎ o tôprè̤ manárò thǐ thè́gně lǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A hyǎ dố vǎkhyěkhu pǎ prè́ tadû́rò vǎ ki ilyěkyǎ pé̤ prè́ a khupháplye̤ pǎ prè́nuô vǎ kò ná lǔ to.” ");
INSERT INTO kyu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lò̌꤮ tè̤me̤-ané̤ yětahe nuôma, a htwǒhtya bí Jordano htyělyǎ̤muố̤ bè́rè̤̌, dò̌ Bethania, bí Giovanni lé̤plwǒ pé̤ ǔ htyě nuôtôpho. ");
INSERT INTO kyu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Dốkhyě tônyěnuô, Giovanni myáhtye Jesǔ hyǎ dố a o rò a hé, “Myámò̌, Cò́marya athímíphú dố a phyévǐkyǎ kyǎ prè̤lu hekhuphú a tè̤thû́tè̤ora tahe yěnuô tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Vǎ héso htuô̌hò́ thǐ, ‘Kayǎ tôprè̤ ki hyǎ dố vǎkhyěkhu pǎ prè́ tadû́rò a taryěpro̤prya̤ duhtǔklò̌ ná vǎ pǎ, me̤těhérò bí vǎ opacè̤̌lya̤ tyahíto nuô, a one htuô̌ré̤hò́.’ È ma má̤ kayǎ dố vǎ héso pé̤ thǐ nuôtôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kayǎ dố vǎ héso pé̤ thǐ dố aré̤khè̌ tôprè̤ nuôma ǔpěnuô vǎ thè́gněto tadû́rò thyáphú Israelphú ki thè́gně tǎ̤te̤ è agněnuô, vǎ hyǎ plwǒ pé̤ ǔ ná htyě prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Htuô̌rò Giovanni hésothè́gně pé̤ ǔ, “Vǎ myáhtye htuô̌hò́ Thè́ Sǎsè̌ Byacè o dố mò́khu hyǎlya̤ o dố lǔlo̤ thyáná htulwí̤ nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dố aré̤khè̌ nuôma vǎ thè́gněhí ná è ma kayǎ htwǒ phúyěnuô tôprè̤ híto tadû́rò Cò́marya dố a nò̌ vǎ dố vǎ ki plwǒ pé̤ ǔ ná htyě yětôprè̤nuô a hé vǎ, ‘Shyé꤮ nopǎ nuô, ki nè̤ myáhtye Thè́ Sǎsè̌ Byacè hyǎlya̤ o dố kayǎ tôprè̤ alo̤ pǎ hénuô è ma má̤hò́ kayǎ dố a ki plwǒ pé̤ ǔ ná Thè́ Sǎsè̌ Byacè pǎ nuôtôprè̤ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tè̤htwǒhtya phúyěnuô, vǎ myáhtye htuô̌hò́ akhu-akhyě, vǎ hésocò́ pé̤hò́ thǐ ná è ma Cò́marya aphúkhǔ má̤lakǒ tôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ano tônyěnuô Giovanni kahtò oró̤kuô̌ khyěthyá ná a khǒpacè̤̌ thè́nyě̤. ");
INSERT INTO kyu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","A myáhtye Jesǔ cuố dố klyálo̤ rò a hé, “Myámò̌ lahyǎ, Cò́marya athímíphú dố ǔ ki lǔhtya lǔ pǎ nuôtôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","A khǒpacè̤̌ yěthè́nyě̤ ní̤huô̌ Giovanni hébèngó̤ phúyě rò a krwǒcuốkuô̌ Jesǔ akhyě. ");
INSERT INTO kyu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bí Jesǔ tarí myáka̤khyě akhè̌, a myáhtye èthǐ krwǒcuốkuô̌ lǔ dố khyě rò a sudyǎ èthǐ, “Thǐ myápṳ̌ ǐtě?” Èthǐ hésû, “Rabbi, nè̤ omyěotǒ hi bítě tômětě?” (Rabbi angó̤lasá ma Thárá) ");
INSERT INTO kyu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Rò a hésû èthǐ, “Krwǒcuốmyá kuô̌dû vǎ,” Rò kayǎ yěthè́nyě̤ krwǒcuốmyá kuô̌ lǔ a lé̤omyě khǎlé̤. Èthǐ cuốmyáhtye kuô̌ lǔ lé̤o rò èthǐ okuô̌ lǔ bínuô tuố̤dố mò̤́khípaló̤. Jesǔ è́ èthǐ akhè̌nuôma a tǒbí mò̤́kwí̤lya̤ lwǐ̤mû̌ akhè̌nuô. ");
INSERT INTO kyu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Èthǐ ní̤huô̌ htuô̌ Giovanni Baptista hé, “Myámò̌ lahyǎ, Cò́marya athímíphú dố ǔ ki lǔhtya lǔ pǎ nuôtôprè̤,” phúnuô htuô̌rò èthǐ krwǒcuốkuô̌ Jesǔ akhyě. Dố a krwǒcuốkuô̌ Jesǔ akhyě yěthè́nyě̤ aklè̌nuô, tôprè̤ ma Simonè Petru apuố̤ Andrea prè́. ");
INSERT INTO kyu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A cuố myápṳ̌ ré̤lố avyá̤ Simonè rò a héso pé̤ lǔ, “Pè̤ myáhtyehò́ Messia hò́” (Messia angó̤lasá ma Krístu) ");
INSERT INTO kyu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","yětôphuốrò a thǔcuố Simonè dố Jesǔ a o. Jesǔ myá lǔ rò a hé lǔ, “Nè̤ ma Giovanni aphúkhǔ Simonè. Ǔ ki è́ nè̤ mwi̤ ná Kepha pǎ,” (Kepha angó̤lasá ma Petru). ");
INSERT INTO kyu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ano tônyě mò̤́lǐ akhè̌nuô, Jesǔ dyalya̤ hò́ athè́plò dố a ki cuố dố Galilea ké̤. A myáhtye Philipu rò a hé lǔ, “Cuố! Krwǒkuô̌ vǎkhyě rò htwǒhtyakuô̌ vǎ khǒpacè̤̌ ha.” ");
INSERT INTO kyu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philipu ma vǐ̤ Bethsaidaphú, a otố̤ thyákuô̌ hò́ vǐ̤ ná Andrea ná Petru o ní̤dyé vǐ̤nuô tôvǐ̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philipu myáhtye Nathanael rò a hé lǔ, “Pè̤ myáhtyehò́ kayǎ dố Mosè rǎ lǔrilǔkyǎ dố li tè̤thyótè̤thya akǔnuô ná prè̤pro̤ tahe rǎkuô̌ lǔrilǔkyǎ nuô tôprè̤ hò́. È ma Joseph aphúkhǔ Jesǔ rò è ma vǐ̤ Nazarèphú.” ");
INSERT INTO kyu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Rò Nathanael sudyǎ Philipu, “Tè̤twó̤tè̤ryá tôcôcô ohtya cyá̤ sálé̤ nyǎ dố vǐ̤ Nazarè akǔ è̌?” Rò Philipu hésû lǔ, “Cuố꤮, vǎ cuốzṳ̌ nè̤.” ");
INSERT INTO kyu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bí Jesǔ myáhtye Nathanael hyǎ dố lǔo akhè̌nuô, a hé Nathanael ari-akyǎ, “È ma Israelphú má̤lakǒ tôprè̤. A lahǒlahya kuô̌ǔ takhyá꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Rò Nathanael sudyǎ lǔ, “Nè̤ cuố thè́gně cyá̤ vǎ phútě?” A hé rò Jesǔ hésû lǔ, “Bí Philipu è́ tyahí nè̤ to akhè̌nuô, vǎ myáhtye nè̤ o bí kadwímò̤́lè̤̌ nuô.” ");
INSERT INTO kyu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael hésû lǔ, “Rabbi꤮ nè̤ ma Cò́marya aphúkhǔ má̤nyǎ hò́, nè̤ ma Israel akhwí má̤lakǒ cò́ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesǔ hé lǔ, “Vǎ hé nè̤ ná vǎ myáhtye nè̤ dố kadwímò̤́lè̤̌ nuôma nè̤ zṳ̂́e má̤lakǒ vǎ ná vǎ ma Cò́marya aphúkhǔ, Israel akhwí tôprè̤nuô è̌? Nè̤ ki myáhtyepó̤ tè̤pro̤tè̤prya̤ duklò̌lố cò́ ná yětahenuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Htuô̌rò Jesǔ hé èthǐ, “Vǎ hésocò́cò́ thǐ, thǐ ki myáhtye mò́khu bámǒ rò Cò́marya tanéphú tahe ki kahtya kalya̤ dố prè̤lu aphúkhǔ má̤hò́ vǎyě alo̤nuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Thuô̌nyě tônyěnuô pwè̌khǒmè̤̌ odố Galilea ké̤, vǐ̤ Canan akǔ tôphu, rò Jesǔ amuố̤ okuô̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pwè̌khǒmè̤̌ yěnuô, ǔ mehyǎ tố̤kuô̌ Jesǔ ná a khǒpacè̤̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bí thòbǐthèhtyězǎ̤ dố sǐpré̤ tahe agně lò̌kyǎhò́ akhè̌nuô, Jesǔ amuố̤ hésoluô̌ Jesǔ, “Èthǐ a thòbǐthèhtyězǎ̤ lò̌hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Rò Jesǔ hésû lǔ, “Muố̤꤮, nè̤ cuốhyǎ hésotuố̤ vǎ me̤tě? Shuốkhè̌ tuố̤hí dố vǎ ki dyéluô̌ vǎ tè̤pro̤tè̤prya̤ híto.” ");
INSERT INTO kyu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesǔ amuố̤ héso prè̤me̤tè̤phú tahe, “Ki a nò̌ thǐ tôcôcô hérò me̤pé̤ è ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tavǐtava̤ bínuô tôphonuô thǒdu o mě thuô̌thyó rò tôměnuô, ǔ zṳ̂nuô̌ ná htyě hénuôma a ní̤ pyǎ̤du nuô 80-120. Thǒdu yětahenuô, Judaphú tahe zṳ̂nuô̌o ná htyě rò èthǐ nò̌e ná a lé̤sǐplǐ ná takhu phú èthǐ tè̤cò́bucò́bè̌ lé̤klǒ o agně nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesǔ nò̌ prè̤me̤tè̤phú nuôtahe, “Zṳ̂nuô̌ bǎlò̌htyě dố thǒdu nuôtahe akǔnuô.” Rò èthǐ zṳ̂nuô̌ bǎlò̌ htuô̌rò, ");
INSERT INTO kyu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesǔ hé èthǐ, “Khǒnyá̤yě dûní̤htyě tôbě rò cuốdyé dố pwè̌khuklò́du dố a tari myákhwè ní̤pé̤ lò̌ ǔ tè̤pwǒ̤꤮ tôcô nuôtôprè̤ a o,” a hé. Rò èthǐ dûcuố pé̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pwè̌khuklò́du ǒmyá htyě dố a htwǒhtya thòbǐthèhtyězǎ̤ yěnuô. Manárò thòbǐthèhtyězǎ̤ yě a o bítě hyǎnuô a thè́gněto. (Prè̤me̤tè̤phú yětahe yǒ dûhtyě akhu-akhyě, a thè́gně prè́tû́ èthǐ yětahe prè́) rò pwè̌khuklò́du yětôprè̤ è́hyǎ prè̤khǒmè̤̌ prè̤khǔ, ");
INSERT INTO kyu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","rò a hé lǔ, “Ǔ pwǒ̤꤮ tôprè̤ lé̤klǒ dyéǒré̤ thòbǐthèhtyězǎ̤ dố avi-asû̌ tahe, htuô̌rò ǔ thè́ǒ bá꤮ tě rò ǔ ǒ htuô̌hò́ akhè̌nuô, ǔ dyéǒke thòbǐthèhtyězǎ̤ paě tahe. Manárò nè̤yě nè̤ be-odwó ní̤dyé tuố̤pǎ nè̤ thòbǐthèhtyězǎ̤ avi-asû̌ tahe tuố̤khǒnyá̤ cò́cò́.” ");
INSERT INTO kyu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesǔ me̤ tè̤pro̤tè̤prya̤ lú tè̤ tôphuốma bí vǐ̤ Canan, Galilea ké̤ yěnuôhò́, rò a dyéluô̌htya a tè̤lǐtè̤takhè̌ bínuô. Phúnuôrò a khǒpacè̤̌ tahe zṳ̂́ka̤nyá̤ka̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Htuô̌hò́ rò è ná amuố̤ ná apuố̤ tahe ná a khǒpacè̤̌ tahe lya̤ lahyǎ dố vǐ̤ Capernaum akǔ, rò èthǐ cuố o lahyǎ bínuô nyě̤thuô̌nyě. ");
INSERT INTO kyu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Má̤ dố Judaphú tè̤cuốtalwópwè̌ phûhyǎhò́ akhu-akhyě, Jesǔ cuố dố vǐ̤ Jerusalem. ");
INSERT INTO kyu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bí a hyǎtuố̤ dố tè̤lǔtyǎ hǒkǔ akhè̌nuô, a myáhtye kayǎ isè̌ pṳ́, thímí, htulwí̤ tahe ná kayǎ onyǎ htulya rû̌ dố dǐrè̤́ khǎshyé tahe. ");
INSERT INTO kyu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Phúnuôrò a me̤ suplye̤ iplí rò a vè̤́htekyǎ lò̌ thímí ná pṳ́ tahe dố tè̤lǔtyǎ hǒkǔ. Htuô̌rò a htulaklò̤̌kyǎ lò̌ ǔ lé̤htulya rû̌ a dǐrè̤́htyalô̌ nuôtahe rò a me̤ lṳpruốkyǎ lò̌plǐ èthǐ rû̌zye tahe. ");
INSERT INTO kyu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Htuô̌rò a hé kayǎ isè̌ htulwí̤ nuôtahe, “Cò̤̌hte taphǎkyǎ lò̌ yětahe. Nò̌htwǒhtya tǎ vǎphè̌ ahi yěnuô ná klè́ tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A khǒpacè̤̌ tahe tane̤htya tuố̤ lisǎsè̌kǔ hé, “Vǎ thè́plòshyo mo̤ní̤ nyacò́ nè̤hi. Vǎ tè̤thè́plòshyo mo̤ní̤ yěnuôma a ki û̌ lò̌kyǎ cò́ vǎ thyáná minuô cò́ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dố a me̤ phúyě akhu-akhyě, Judaphú khuklò́ tahe sudyǎ lǔ, “Thyáphú pè̤ ki thè́gně ná nè̤ ní̤bè tè̤taryěshyosò̌ dố nè̤ ki hyǎme̤ tè̤lṳpruốlṳpryǎ phúyě ma aní̤ prè́ agněnuô, nè̤ ki dyéluô̌ pé̤ pè̤ tè̤pro̤tè̤prya̤ ǐtětě pǎ tě?” ");
INSERT INTO kyu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesǔ hésû, “Me̤ tǎ̤prò̤kyǎ mò̌ tè̤lǔhǒdu yěnuô. Thuô̌nyě akǔ, vǎ ki isò́htya khyěthyá pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Htuô̌rò Judaphú sudyǎ lǔ, “Thuô̌nyě akǔ, nè̤ kíré̤ isò́htya htuô̌bè́ khyěthyá nyǎ pǎ è̌? Tè̤lǔhǒdu yěnuôma ǔ isò́htya ní̤ è ma anyě̤ cò́ ana lwǐ̤shyě ná thuô̌thyó cò́ meně꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Manárò bí Jesǔ hé ná tè̤lǔhǒdu ari-akyǎ akhè̌nuô ma a hélya̤ ní̤dyédû ané̤klò̤́ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Phúnuô akhu-akhyě bí Jesǔ htwǒprè̤ ka̤khyě khyěthyá dố tè̤thyě akhè̌nuô, a khǒpacè̤̌ tahe tane̤htya tuố̤bè khyěthyá dố a hébèkyǎ angó̤ yěnuô rò èthǐ zṳ̂́e lisǎsè̌ ná è héokyǎ angó̤ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bí Jesǔ opǎ bí vǐ̤ Jerusalem tè̤cuốtalwó pwè̌kǔ akhè̌nuô, ǔ myáhtye a me̤ tè̤pro̤tè̤prya̤ nuôtahe akhu-akhyě ǔ zṳ̂́e è́nyacò́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Manárò Jesǔ zṳ̂́ení̤ èthǐ to, me̤těhérò a thè́gně luplú lò̌plǐ hò́ ǔthè́plò hò́. ");
INSERT INTO kyu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ǔ lo hésoluô̌ pé̤ ná Jesǔ ná kayǎ pwǒ̤꤮ tôprè̤ ari-akyǎ to me̤těhérò Jesǔ thè́gně htuô̌dûhò́ ǔ pwǒ̤꤮ tôprè̤ athè́plò hò́. ");
INSERT INTO kyu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Judaphú khuklò́ dố amwi̤ ná Nicodemo o tôprè̤. È ma a otố̤kuô̌ dố Pharisěophú aplò́amṳ tahe akǔ. ");
INSERT INTO kyu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tôthè̌khè̌nuô Nicodemo hyǎ dố Jesǔ o rò a hé lǔ, “Thárá, pè̤ thè́gně ná nè̤ ma má̤ Thárá dố a o dố Cò́marya a ohyǎ tôprè̤. Pè̤ thè́gně ná Cò́marya ki okuô̌ ná kayǎ tôprè̤prè̤ to hénuôma a me̤cyá̤ tè̤pro̤tè̤prya̤ phú nè̤ me̤ yěnuô tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesǔ hésû lǔ, “Vǎ hésocò́cò́ nè̤, kayǎ dố a opacè̤̌lya̤ khyěthyá tôphuố꤮ to tahenuô, a myáhtyebè́ Cò́marya ahtyěaké̤ tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo sudyǎ lǔ, “Kayǎ duprè̤́hò́ tôprè̤nuô a cuố opacè̤̌lya̤ cyá̤ khyěthyá phútě? A ka̤ kanuô̌ khyěthyá dố a muố̤hò́kǔ rò a opacè̤̌lya̤ nyě̤phuốtôphuố ma a cyá̤ pǎnyǎ è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesǔ hésû lǔ, “Vǎ hésocò́cò́ nè̤, kayǎ dố a opacè̤̌lya̤ khyěthyá ná htyě ná Cò́marya a Thè́ Sǎsè̌ to tahenuô a nuô̌ní̤ cyá̤ dố Cò́marya ahtyěaké̤kǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Prè̤lu kayǎ opacè̤̌lya̤ ní̤dyé khyě prè̤lu kayǎ prè́. Manárò tè̤opacè̤̌lya̤ ná Thè́ Sǎsè̌ Byacè nuô, a dyé ohtwǒhtya taple ǔ dốthudốthè́ tôkyě. ");
INSERT INTO kyu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dố vǎ hé pé̤ nè̤, ‘Thǐ tǒbè opacè̤̌lya̤ pó̤ tôphuố,’ phúyěnuô akhu-akhyěrò, khyéthukhyéthè́ tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ké̤lathè́ nuô a lathè́cuố cṳ́꤮ dû atè̤ prè́. Nè̤ ní̤huô̌ apra̤ tadû́rò a o bítěhyǎ má̤torò a kíré̤ cuốtǒ bítě nuô nè̤ thè́gněto. Lò̌꤮ kayǎ opacè̤̌lya̤ ná Cò́marya a Thè́ Sǎsè̌ tahe nuôma a thyáphú nuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo sudyǎ lǔ, “A cuố htwǒhtya cyá̤ phútě?” ");
INSERT INTO kyu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesǔ hésû è, “Nè̤ htwǒ cò́ Israel a thárádu꤮ tôprè̤ vǎhéto, phúyěprè́ rò nè̤ cuố thè́gněto me̤tě? ");
INSERT INTO kyu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Vǎ hésocò́cò́ nè̤, pè̤ hé pé̤ ǔ tè̤ dố pè̤ thè́gně tahe, pè̤ dônyǎ pé̤ ǔ tè̤ dố pè̤ myáhtye tahe tadû́rò thǐ phyésû pè̤ tè̤hébè yěnuô tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Vǎ héso pé̤htuô̌hò́ thǐ ná hekhu ari-akyǎ yětahe tadû́rò thǐ zṳ̂́e vǎ to. Vǎ ki héso pé̤ pó̤ thǐ ná mò́khu ari-akyǎ tahe hénuôma thǐ kíré̤ zṳ̂́e cyá̤ vǎ phútě? ");
INSERT INTO kyu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kayǎ htyatuố̤nò́ dố mò́khu nuô a o tôprè̤꤮ to. Prè̤lu aphúkhǔ dố a o dố mò́khu hyǎlya̤ yětôprè̤ htyatuố̤ tû́꤮ dû prè́. ");
INSERT INTO kyu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Thyáphú kayǎ pwǒ̤꤮ tôprè̤ dố a zṳ̂́ka̤nyá̤ka̤ vǎ tahe, ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ talèkrè́ agněnuô, vǎ dố a má̤dûhò́ prè̤lu aphúkhǔ yě ǔ ki tahtwóhtya kuô̌dû vǎ phú Mosè mú꤮ nukhè̌ cò̤̌htya rṳ́talǐbyǎ zǎ̤zo̤ dố hihtûlo̤ rò a tahtwóhtya è dố ké̤sè̌htyěkya̤ lò̤́tamákhu nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Cò́marya mo̤ní̤ lò̌ cò́ prè̤lu hekhuphú lò̌꤮ plǐ. Lò̌꤮ kayǎ dố a zṳ̂́e aphúkhǔ tahenuô, thyáphú a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ rò a ki tuố̤ tǎ dố tè̤pyétè̤kyǎ tǎmé̤ nuô, a dyélya̤kyǎ aphúkhǔ o tû́ tôprè̤ yěnuô dố prè̤lu hekhuphú tahe agně. ");
INSERT INTO kyu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Me̤těhérò, Cò́marya nò̌hyǎlya̤ aphúkhǔ dố a ki cirya kayǎ hekhuphú agněnuô má̤to. Má̤tôkhónuô a nò̌hyǎ lǔ dố a ki hyǎ me̤lwóhteka̤ kayǎ hekhuphú agně nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kayǎ dố a zṳ̂́e phúkhǔ tahenuô, Cò́marya cirya èthǐ to. Kayǎ dố a zṳ̂́e phúkhǔ to tahenuô, Cò́marya cirya èthǐ hò́, me̤těhérò, a yǒ zṳ̂́e kuô̌ǔ Cò́marya aphúkhǔ dố a o tû́ tôprè̤꤮ tuô̌ yětôprè̤ to akhu-akhyě, a ciryahò́ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Me̤těrò èthǐ khyábè tè̤cirya hénuôma, Cò́marya atè̤lǐ hyǎnuô̌ dố hekhuyě tadû́rò prè̤lu hekhuphú tahe thè́zṳ̂́ tè̤lǐ yěnuô to me̤těhérò èthǐ yǒ me̤ tè̤mǔmyá̤ricyá̤ tahe akhu-akhyě, a mo̤ní̤klò̌ dố tè̤khítè̤lò̤. ");
INSERT INTO kyu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Lò̌꤮ kayǎ dố a me̤ tè̤mǔmyá̤ricyá̤ tahenuô, a thè́hte tè̤lǐ rò a hyǎ dố tè̤lǐ a o to, me̤těhérò kayǎ dố a me̤ tè̤mǔmyá̤ricyá̤ tahenuô, a thè́isě ná a tè̤thû́tè̤ora tahe oluô̌htya rò a hyǎtǒ to. ");
INSERT INTO kyu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Manárò kayǎ dố a me̤ tè̤cò́tè̤te̤ tahenuô, a hyǎtǒ dố tè̤lǐ a o, me̤těhérò thyáphú ǔ pwǒ̤꤮ tôprè̤ ki myáhtye luô̌ryá ná a me̤tè̤ tahenuô, atǒ ná Cò́marya athè́plò agněnuô, a hyǎtǒ dố tè̤lǐ o.” ");
INSERT INTO kyu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A héhtuô̌ lǔ rò, Jesǔ ná a khǒpacè̤̌ tahe htecuố dố Judaké̤. Rò a cuốo nyě̤rare kuô̌ ná a khǒpacè̤̌ tahe bínuô rò a cuốplwǒ pé̤ ǔ htyě. ");
INSERT INTO kyu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Giovanni plwǒ pé̤ kuô̌pó̤ ǔ htyě bí khǎlé̤ dố ǔ è́ ná Aenon nuôtôpho. Aenon ma a ophû ná dò̌ Salim htuô̌rò htyě oè́. Kayǎ hyǎ dố lǔo rò a plwǒ pé̤ èthǐ htyě. ");
INSERT INTO kyu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Yěma bí ǔ dò́tǎ̤ hí Giovanni dố htò̌kǔ híto akhè̌nuô) ");
INSERT INTO kyu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","bínuôakhè̌ Giovanni a khǒpacè̤̌ tahe ná Judaphú tôprè̤ krékryá̤ khyělǔ ná lé̤klǒlé̤khya oná tè̤me̤mwǒ̤plǐ phútě nuô ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Èthǐ cuố dố Giovanni a o rò a hé lǔ, “Thárá꤮ kayǎ dố a okuô̌ ná nè̤ bí Jordano htyěklǒ bè́rè̤̌ rò nè̤ khyáluô̌ pé̤ ǔ ná è ari-akyǎ nuôtôprè̤ ní꤮ khǒnyá̤yě a cuốplwǒ pé̤tuố̤ ǔ htyě rò ǔ cuố lò̌plǐ hò́ dố lǔo hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Rò Giovanni hésû lǔ, “Ǔpě bèbè Cò́marya ki dyétǎ̤ lǔ to nuô, a ní̤bè cyá̤ tè̤ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Vǎ héhtuô̌hò́ thǐ, ‘Vǎ ma Krístu má̤to tadû́rò Cò́marya nò̌hyǎ ré̤ vǎ dố ènyěhyǎ prè́.’ Vǎ héhtuô̌hò́ akhu-akhyě thǐ htwǒhò́ vǎ prè̤khyáthè́ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Vǎ ma athyáná prè̤krwǒkruô̌ khǒmè̤̌ prè̤khǔ tôprè̤nuô. Khǒmè̤̌ prè̤mò ma khǒmè̤̌ prè̤khǔ atè̤. Manárò prè̤krwǒkruô̌ nuôtôprè̤ kahtò ní̤dǎ khǒmè̤̌ prè̤khǔ hébè. A ní̤huô̌ lǔngó̤ akhu-akhyě, a thè́krṳ̂̌thè́lò̌ nyacò́. Phúnuôhò́ vǎ tè̤thè́krṳ̂̌ yěnuô a lốhtyabǎhtya hò́. ");
INSERT INTO kyu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","È ma a tǒbè loduklò̌, vǎ ma a tǒbè lo patíklò̌. ");
INSERT INTO kyu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Kayǎ o dố mò́khu hyǎ yětôprè̤nuô, aduklò̌ ná ǔ lò̌꤮ plǐ. Kayǎ o dố hekhu yětôprè̤nuô a thè́gně hébè prè́tû́ hekhu ari-akyǎ prè́. Kayǎ o dố mò́khu hyǎ yětôprè̤nuô aduklò̌ ná ǔ lò̌꤮ plǐ. ");
INSERT INTO kyu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A hésoluô̌ pé̤ ǔ ná lò̌꤮ a myáhtye nuôtahe ná lò̌꤮ a ní̤huô̌ nuôtahe. Manárò a hésoluô̌ pé̤ ǔ nuô ǔ ní̤dǎ phyésû lǔtè̤ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kayǎ dố a ní̤dǎ phyésû lǔ tè̤hésoluô̌ tahenuô a zṳ̂́e tǎ̤te̤ lahyǎ ná Cò́marya ma amá̤acò́. ");
INSERT INTO kyu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kayǎ dố Cò́marya nò̌tǎ̤ è tôprè̤nuô, Cò́marya dyé lốbǎ hò́ lǔ Thè́ Sǎsè̌ Byacè akhu-akhyě, a hébèprè́ Cò́marya alǎ̤angó̤ tahe prè́. ");
INSERT INTO kyu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Phè̌ Cò́marya mo̤ní̤ aphúkhǔ rò a dyétǎ̤lò̌ lǔ tè̤pwǒ̤꤮ tôcô dố a takhukǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kayǎ dố a zṳ̂́enyá̤e phúkhǔ yětôprè̤ tahenuô, a ní̤bè thè́htwǒprè̤ tacṳ́prè̤. Rò kayǎ dố a ní̤dǎ kuô̌ǔ to rò a zṳ̂́enyá̤e kuô̌ǔ phúkhǔyě to tahenuô, a ní̤bè kuô̌ǔ thè́htwǒprè̤ to. Cò́marya a tè̤cirya tǎ̤ o dố kayǎ nuôtahe alo̤.” ");
INSERT INTO kyu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pharisěophú tahe ní̤huô̌ ná Jesǔ a khǒpacè̤̌ oè́htya ná è́htya htuô̌rò a plwǒní̤è́ pé̤ klò̌ ǔ htyě ná Giovanni. ");
INSERT INTO kyu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ki hélakǒ ma, Jesǔ plwǒ pé̤ ǔ htyě tôprè̤꤮ to, a khǒpacè̤̌ tahe plwǒ shuô̌shuô̌ pé̤ ǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bí Jesǔ ní̤huô̌ ǔ dyá lǔzo̤ phúyě akhè̌, a htecuốkyǎ dố Judaké̤ htuô̌rò a ka̤khyě khyěthyá dố Galilea ké̤. ");
INSERT INTO kyu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bí a cuố akhè̌nuô, a tǒbè cuốbè́ ná Samaria ké̤. ");
INSERT INTO kyu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Phúnuôrò a cuốtuố̤ dố vǐ̤ Sykar dố a o bí Samaria ké̤kǔnuô. Vǐ̤ yětôvǐ̤nuô a ophû ná Jacob lé̤dyékyǎ aphúkhǔ Joseph hekhu khǎlé̤ nuôtôpho. ");
INSERT INTO kyu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob ahtyěklû o bínuô. Rò Jesǔ cuố thè́práladyá klyá akhu-akhyě a cuố onyǎokuố bí htyěklû nuôtôò akhǎshyé. Bínuôkhè̌ nuôma phû꤮ mò̤́htuô hò́. ");
INSERT INTO kyu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Rò Samaria muố̤ tôprè̤ hyǎdyáhtyě, rò Jesǔ hé lǔ, “Dyéǒ pé̤kuô̌ vǎ htyě to꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Bínuôkhè̌ ma a khǒpacè̤̌ htecuố ipri̤ lé̤e dố vǐ̤kǔ.) ");
INSERT INTO kyu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria muố̤ hésû lǔ, “Nè̤ ma Judaphú, vǎ ma Samariaphú, nè̤ cuố kwǐǒ tuố̤ vǎhtyě.” (A hé phúyě me̤těhérò Judaphú ná Samariaphú nuôma a rè̤̌ lǔ to.) ");
INSERT INTO kyu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesǔ hésû lǔ, “Nè̤ ki thè́gněbye Cò́marya a tè̤dyékrǎ shyězṳ́ htuô̌rò prè̤ dố a kwǐǒ nè̤htyě yětôprè̤ ma ǔpě nuô nè̤ ki thè́gně pó̤bye héma, nè̤ ki kwǐǒ vǎ htyě pǎ rò vǎ ki dyéǒ nè̤ htyě dố a dyé ǔ thè́htwǒprè̤ yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Prè̤mò nuôtôprè̤ hésû lǔ, “Thárá꤮ nè̤ cuố dyáhtya cyá̤ htyě dố a dyé ǔ thè́htwǒprè̤ yěnuô bítě pǎ? Nè̤ htyělé̤cò̤̌ rò a o toto, htyěklû yětôònuô a zǎ̤ nyacò́ tôkuôrò. ");
INSERT INTO kyu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Pè̤phè̌ Jacob dố꤮ nyénu dyékyǎ pè̤ htyěklûyě. Jacob ná aphúalye̤ ná a tè̤phútè̤lye̤ tahe dyáǒ htyěyě. Ma nè̤ duklò̌nyǎ ná pè̤phè̌ Jacob è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesǔ hésû lǔ, “Kayǎ dố a ǒhtyě yětahenuô, a thè́ǒ khyěthyá pǎ, ");
INSERT INTO kyu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","manárò kayǎ dố a ki ǒhtyě dố vǎ dyéǒ è pǎ yěnuô, a thè́ǒ pǎ htyě tôphuố꤮ to. Htyě dố vǎ ki dyéǒ è pǎ yěnuô, a ki htwǒhtya htyěhtekhu dố lǔkǔ pǎ. Rò a ki dyé lǔ thè́htwǒprè̤ tacṳ́prè̤ talèkrè́ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Prè̤mò yětôprè̤ hésû lǔ, “Thárá꤮, thyáphú vǎ ki thè́ǒ pǎ htyě tôphuố꤮ to, htuô̌rò thyáphú vǎ ki hyǎ dyáǒnò́ pǎ tǎ htyě bíyě tǎmé̤nuô dyémò̌ vǎ htyě dố nè̤ hé yěnuô.” ");
INSERT INTO kyu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesǔ hésû lǔ, “Ka̤ è́hyǎ nè̤vè̤ bíyě.” ");
INSERT INTO kyu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Rò a hésû Jesǔ, “Vǎvè̤ oto.” Jesǔ hésû lǔ, “Nè̤ hé ná nè̤vè̤ oto nuôma atǒ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nè̤vè̤ ohtuô̌hò́ nyǎ̤htû̌ rò prè̤khǔ dố nè̤o ní̤dyé khǒnyá̤yě tôprè̤ nuôma nè̤ vè̤ má̤to. Nè̤ héluô̌cò́ héluô̌te̤ pé̤ cò́ vǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Prè̤mòyě hé lǔ, “Thárá꤮ vǎ myáhtye thè́gně tǎ̤te̤hò́ ná nè̤ ma prè̤pro̤ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pè̤ klwǐlyǎ Samariaphú dố꤮ nyénu tahenuô, a cò́bè̌htya Cò́marya bí so yěnuôtômě alo̤. Manárò thǐ Judaphú tahenuô thǐ hé ná ǔ tǒbè cò́bè̌htya Cò́marya dố vǐ̤ Jerusalem akǔ nuô.” ");
INSERT INTO kyu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesǔ hésû lǔ, “Mòmuố̤꤮ zṳ̂́e vǎnuô, shuốkhè̌ ki hyǎtuố̤hò́ dố thǐ ki cò́bè̌htya Phè̌ Cò́marya pǎ. Manárò bí so yětômě alo̤ nuô bèbè, dố vǐ̤ Jerusalem akǔ yěnuô bèbè, ǔ lo hyǎcò́bè̌ pǎ bínuô tohò́. ");
INSERT INTO kyu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Thǐ Samariaphú tahenuô, thǐ cò́bè̌htya ǔpě nuô thǐ thè́gně tǎ̤te̤ ní̤dyé to. Manárò pè̤ Judaphú tahenuô, pè̤ cò́bè̌htya ǔpěnuô pè̤ thè́gně ní̤dyé, me̤těhérò tè̤me̤lwóhteka̤ nuô a ohtya dố pè̤ Judaphú aklè̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Manárò kayǎ dố a cò́bè̌ sǎprè̤́nyacè̌ Phè̌ Cò́marya tahenuô, shuốkhè̌ dố èthǐ ki cò́bè̌ dốthudốthè́ ná tè̤má̤tè̤cò́ nuô, a ki hyǎtuố̤ pǎ. A hyǎtuố̤ cò́ hò́ khǒnyá̤ hò́. Me̤těhérò Phè̌ Cò́marya myápṳ̌ kayǎ dố a cò́bè̌htya lǔ phúnuô tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Cò́marya ma má̤thumá̤thè́ rò kayǎ dố a cò́bè̌htya è tahenuô, a tǒbè cò́bè̌htya è phú Thè́ Sǎsè̌ Byacè zṳ̌klyázṳ̌klǒ è dố tè̤má̤tè̤cò́ akǔ nuô.” ");
INSERT INTO kyu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A hésû Jesǔ, “Vǎ thè́gně ná Messia (Dố ǔ è́ amwi̤ ná Krístu nuô) ki hyǎ pǎ, rò bí a hyǎtuố̤ pǎ akhè̌nuô, a ki hyǎhéso pé̤ pè̤ tè̤lò̌꤮ plǐ pǎ a hé phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesǔ hésû è, “Kayǎ dố a hébè ná nè̤ khǒnyá̤yě tôprè̤ nuôma má̤ nuôtôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bínuôakhè̌, Jesǔ a khǒpacè̤̌ tahe ka̤tuố̤ rò a khyéthukhyéthè́ nyacò́ dố a myáhtye Jesǔ hébè ná prè̤mò nuôtôprè̤. “Prè̤mò nuôtôprè̤ thè́zṳ̂́ ǐtě?” nuô, èthǐ sudyǎ lǔ tôprè̤꤮ to, htuô̌to “Byacè Jesǔ cuốhébè tuố̤ ná prè̤mò nuôtôprè̤ me̤tě?” nuô, èthǐ sudyǎ lǔ tôprè̤꤮ toto. ");
INSERT INTO kyu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Htuô̌rò prè̤mò yětôprè̤ bekyǎ ahtyěǒ rò a ka̤héso è́pé̤lǎ ǔ dố vǐ̤kǔnuô, ");
INSERT INTO kyu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Hyǎ myákuô̌ lahyǎ mò̌ vǎ kayǎ tôprè̤ lé! A hépro̤ lò̌plǐ cò́ lò̌ vǎ me̤htuô̌hò́ nuôtahe. È má̤ Krístu cò́ è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Phúnuô akhu-akhyě èthǐ o bí vǐ̤kǔ nuô rò a hyǎ lahyǎ dố Jesǔ a o. ");
INSERT INTO kyu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bínuôakhè̌, a khǒpacè̤̌ tahe kwǐthè́zò̤ Jesǔ, “Rabbi꤮, emò̌ sèe yě꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Manárò a hésû èthǐ, “Vǎ sèe lé̤e dố thǐ thè́gně tuố̤kuô̌ vǎ to nuô a o dû hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Phúnuô akhu-akhyě a khǒpacè̤̌ tahe sudyǎ ní̤dyé lǔ tôprè̤ htuô̌ tôprè̤, “Kayǎ tôprè̤prè̤ hyǎdyé htuô̌hò́ lǔ sèe è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesǔ hé èthǐ, “Vǎ me̤tǒ prè̤ dố a nò̌hyǎ vǎ yětôprè̤ a tè̤thè́zṳ̂́ rò vǎ me̤htuô̌kyǎ tè̤me̤ dố a dyé vǎ yěnuôma má̤hò́ vǎ sèe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Thǐ lé̤klǒ hé ní̤dyé lahyǎ, ‘A bǎhò́ lwǐ̤lè̌ pǎ ma shuốkhè̌ tǒ kè́hò́ buố pǎ.’ Tadû́rò vǎ hé thǐ, myátǎ̤te̤ lahyǎ kayǎ è́prè̤ dố athyáná lyá̤ yětahenuô, èthǐ ma athyáná buố mǐbǔ tǒkè́ lò̌plǐ hò́ rò shuốkhè̌ bèhò́ dố tǒ kè́ cò́ hò́ khǒnyá̤hò́. ");
INSERT INTO kyu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Khǒnyá̤yě cò́ bèbè, prè̤kè́buố tôprè̤nuô a ní̤bè akhwóakè rò a dya-oplò́ tè̤thètè̤phǒ tahe dố a má̤hò́ tè̤htwǒprè̤ tacṳ́prè̤ agně yěnuô hò́. Phúnuôrò prè̤isò́buố yě ná prè̤kè́buố yě thè́nyě̤lò̌ ki thè́krṳ̂̌ ró̤lò̌ lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Me̤phúnuôrò ngó̤dônyǎ hé, ‘Tôprè̤ rò isò́, tôprè̤ rò kè́’ nuôma atǒ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Vǎ nò̌cuố kè́hò́ thǐ buố dố lyá̤khu dố thǐ me̤nò́ ná thǐné̤ tôphuố꤮ to yětôlé̤ hò́. Kayǎ dố aruô tahe me̤htuô̌hò́ bínuô rò dố èthǐ me̤htuô̌ré̤ hò́ akhu-akhyě, thǐ cuố ní̤bè kuô̌ hò́ tè̤bwítè̤taryě bínuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Dố vǐ̤yě tôvǐ̤ akǔnuô Samariaphú zṳ̂́enyá̤e ka̤ è́lǎ Jesǔ, me̤těhérò má̤ dố prè̤mò nuôtôprè̤ khyáthè́ rò a hé, “A hépro̤ lò̌plǐ tè̤ dố vǎ me̤htuô̌hò́ tahenuô,” akhu-akhyě èthǐ zṳ̂́enyá̤e ka̤ è́lǎ. ");
INSERT INTO kyu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Phúnuô akhu-akhyě bí Samariaphú tahe hyǎtuố̤ dố Jesǔ o akhè̌, a kwǐthè́zò̤ lǔ ná a ki ka̤-okuô̌ ná èthǐ dố avǐ̤kǔ rò Jesǔ ka̤-okuô̌ ná èthǐ bínuô nyě̤nyě. ");
INSERT INTO kyu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ǔ hyǎ ní̤dǎ è́lǎ a tè̤dônyǎ tahe rò ǔ zṳ̂́ka̤nyá̤ka̤ ró̤lǎ. ");
INSERT INTO kyu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Èthǐ hé prè̤mò nuôtôprè̤, “Pè̤ zṳ̂́e Jesǔ khǒnyá̤yě nuôma má̤dố nè̤ héso pé̤ pè̤ akhu-akhyě nuô má̤to. Dố pè̤ ní̤huô̌ a tè̤hésodônyǎ ná pè̤né̤ htuô̌rò pè̤ thè́gně ná è ma Krístu dố a me̤lwóhteka̤ hekhuphú yěnuô tôprè̤ má̤lakǒ hò́, akhu-akhyě nuôprè́.” ");
INSERT INTO kyu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesǔ o bínuô nyě̤nyě htuô̌rò a htecuố dố Galilea ké̤. ");
INSERT INTO kyu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesǔ héhtuô̌ dû hò́, “Prè̤pro̤ nuô adò̌kǔphú ní̤dû dyazṳ̂́dyanyá̤ ní̤dyékuô̌ lǔ to.” ");
INSERT INTO kyu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bí a cuốtuố̤ dố Galilea ké̤ akhè̌nuô, Galileaphú bínuô tahe è́mo̤sû è, me̤těhérò èthǐ cuốnò́kuô̌ tè̤cuốtalwópwè̌ dố vǐ̤ Jerusalem akǔ rò a myáhtyenò́ lò̌ htuô̌hò́ Byacè Jesǔ me̤ tè̤pro̤tè̤prya̤ tè̤lò̌꤮ plǐ bí pwè̌khè̌ nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Htuô̌rò, Byacè Jesǔ ka̤khyě khyěthyá dố vǐ̤ Canan dố Galilea ké̤kǔ bí alé̤ me̤htwǒhtya htyě ná thòbǐthèhtyězǎ̤ nuô. Bí vǐ̤ Capernaum akǔ nuô, kayǎ htwǒ khwí a prè̤me̤tè̤phú khuklò́ otôprè̤ rò a phúprè̤khǔ thè́swí. ");
INSERT INTO kyu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bí a ní̤huô̌ hò́ ná Jesǔ o dố Judaké̤ rò a hyǎ dố Galilea ké̤ akhè̌nuô, a cuố dố lǔo rò a kwǐthè́zò̤ Jesǔ ná a ki krwǒka̤kuô̌ lǔ dố vǐ̤ Capernaum rò ka̤ zasǐmé̤ pé̤ lǔ phúkhǔ dố a kíré̤ thyětalí lǎhò́ yětôprè̤nuô. ");
INSERT INTO kyu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesǔ hé è, “Thǐ dǎmyáhtye pé̤pǎ tè̤pro̤tè̤prya̤ ná tè̤khyéthukhyéthè́ tahe to hérò, thǐ zṳ̂́e cò́ taki꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Htuô̌rò kayǎ htwǒ khuklò́du yětôprè̤nuô a hésû lǔ, “Byacè꤮ ka̤ kuô̌ná vǎ khǒnyá̤ bí vǎphú thyě tyahíto akhè̌yě,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Byacè Jesǔ hésû lǔ, “Ka̤khyě khyěthyá mò̌. Nè̤ phúprè̤khǔ ki omo̤ ka̤khyě dû pǎ.” Rò kayǎ htwǒ du yětôprè̤ zṳ̂́e Jesǔ a tè̤hébè rò a ka̤khyě khyěthyá dố ahi. ");
INSERT INTO kyu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bí a ka̤ dố klyálo̤ akhè̌nuô, a prè̤me̤tè̤phú tahe hyǎ lṳ̂sû è rò a héso lǔ, “Nè̤ phúprè̤khǔ omo̤ ka̤khyě hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A sudyǎ a prè̤me̤tè̤phú yětahe ná aphúkhǔ omo̤ ka̤khyě khyěthyá bíkhè̌tě rò èthǐ hésû lǔ, “A tè̤kṳ́ tǎ̤ bí pahénu mò̤́kwí̤lya̤ tômû̌ akhè̌nuô.” ");
INSERT INTO kyu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aphè̌ tane̤htya tuố̤bèkhyě aphú tè̤kṳ́ tǎ̤ ashuốkhè̌ nuôma, a tǒtû́ bí Byacè Jesǔ hé lǔ, “Nè̤ phúkhǔ ki omo̤ ka̤khyě dû pǎ shuốkhè̌ bínuô.” Dố yě akhu-akhyě è ná a hiphúphyǎphú tahe zṳ̂́ka̤nyá̤ka̤ lò̌plǐ Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yěnuôma Byacè Jesǔ o dố Judaké̤ rò htecuố khyěthyá dố Galilea ké̤ rò a dyéluô̌ atè̤me̤ tè̤pro̤tè̤prya̤ nyě̤phuốtôphuố yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Phúnuôhtuô̌rò, Jesǔ cuốkuô̌ Judaphú tahe apwè̌ dố vǐ̤ Jerusalem. ");
INSERT INTO kyu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Dố vǐ̤ Jerusalem akǔnuô htyěò o tôò. Htyěò nuôtôò nuô a ophû ná Thímílo̤ Kadǎkǔ rò Hebreo ngó̤ nuôma ǔ è́ ná Bethesda. Dố htyěò khuprǐ alo̤nuô ǔ isò́ tava̤ ná lé̤thû nyǎ̤mě. ");
INSERT INTO kyu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bí lé̤thû nuôtahe akǔnuô kayǎ mèthèlè̌, kayǎ khǎduôdá, ná kayǎ thyětôkyě tahe hyǎomyě ró̤ è́kú lǎ lahyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Èthǐ opò̤́ lahyǎ htyěkazuô̤̌ me̤těhérò Cò́marya a tanéphú hyǎlya̤ me̤kazuô̤̌ tamǒmǒ htyěyě rò bí htyě kazuô̤̌ akhè̌nuô, kayǎ dố a cuốnuô̌ ré̤lố dố htyěkǔ tôprè̤prè̤ nuô, atè̤swí sǐmé̤kyǎ.) ");
INSERT INTO kyu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kayǎ swí nyě̤hò́ thuô̌shyě ná nalwǐ̤thyó obínuô tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesǔ myáhtye a omyěkhû́o bínuô rò a thè́gně ná aswí nyě̤hò́ akhu-akhyě a sudyǎ lǔ, “Nè̤ thè́zṳ̂́ nò̌sǐmé̤ nè̤ tè̤sè̌ è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Rò a hésû Byacè, “Byacè꤮, bí ǔ me̤ kazuô̤̌ htyěò akhè̌nuô, kayǎ dố a ki cò̤̌nuô̌ vǎ dố htyěò akǔnuô a o tôprè̤꤮ to. Rò bí vǎ yácû́ cuốnuô̌ akhè̌nuô, kayǎ dố aruôtôprè̤ cuốnuô̌phe ré̤kyǎ hò́ vǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Byacè hé è, “Ihtò talǔní̤ nè̤ klolé̤myě rò cuốmò̌.” ");
INSERT INTO kyu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Atè̤swí sǐmé̤kyǎ cò́ tôphuốtuô̌ rò a talǔní̤ alé̤myě rò a cuố. Tè̤me̤-ané̤ yěnuô atǒ ná Judaphú a Mò̤́nyěduô akhu-akhyě, ");
INSERT INTO kyu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Judaphú khuklò́khuklyǎ tahe hé kayǎ dố atè̤sè̌ sǐmé̤ nuôtôprè̤, “Yětônyě ma Mò̤́nyěduô. Tè̤thyótè̤thya o ná nè̤ phyácuốní̤ nè̤ lé̤myě phúnuô ma aní̤ to.” ");
INSERT INTO kyu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Manárò a hésû èthǐ, “Kayǎ dố a zasǐmé̤ vǎ nuôtôprè̤ hé vǎ, ‘Talǔní̤ nè̤ klolé̤myě nuô rò cuốmò̌,’ a hé vǎ nuô̌꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Èthǐ sudyǎ lǔ, “Kayǎ dố a nò̌me̤ nè̤ phúyě tôprè̤nuô ma ǔpě?” ");
INSERT INTO kyu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Manárò Jesǔ ma ǔpě nuô kayǎ yětôprè̤ thè́gněto, me̤těhérò Byacè Jesǔ htecuố mé̤kyǎ dố kayǎ oró̤oè́ aklè̌. ");
INSERT INTO kyu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Anonuô, Jesǔ myáhtye khyěthyá è dố tè̤lǔhǒdu akǔ rò a hé lǔ, “Ní̤dǎ, vǎ hé nè̤, khǒnyá̤yě nè̤ tè̤swí sǐmé̤hò́. Thyáphú nè̤ ki myáhtyebè pǎ tǎ ná tè̤ dố acyě̤ lốklò̌ cò́ ná yě pǎ tǎmé̤nuô me̤pǎ tǎ tè̤thû́ tǎmé̤ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Htuô̌rò a htecuố héso pé̤ Judaphú khuklò́khuklyǎ tahe ná kayǎ dố a zasǐmé̤ vǎ tè̤swí nuôma amwi̤ ná Jesǔ hénuô̌꤮. ");
INSERT INTO kyu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Phúnuô akhu-akhyě, Jesǔ yǒ me̤ tè̤yětahe dố Mò̤́nyěduô khukhyě, Judaphú khuklò́khuklyǎ tahe cáhtya me̤súsáhyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesǔ hésû èthǐ, “Vǎphè̌ me̤ tè̤me̤ pwǒ̤꤮ phuố, a okuố tôphuố꤮ to rò vǎ tǒbè me̤kuô̌ phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dố Jesǔ hébè ngó̤ phúyě akhu-akhyě Judaphú khuklò́khuklyǎ tahe lé yácû́ pṳ̌me̤thyě shyolốklò̌ pó̤ ná dố aré̤khè̌ nuô. Má̤ prè́tû́ a me̤ talwótalye̤ tǒ okuố Mò̤́nyěduô a tè̤thyótè̤thya tû́dû yěnuô má̤to, a yǒ hé pó̤ ná Cò́marya mamá̤ aphè̌ ní̤dû rò a be krṳ̂nya̤ní̤ ané̤ ná Cò́marya akhu-akhyě èthǐ pṳ̌ me̤thyě lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Phúnuôrò, Jesǔ hésû èthǐ, “Vǎ hécò́cò́ thǐ, phúkhǔyě a me̤ cṳ́꤮ dû phú a thè́zṳ̂́me̤ nuôma aní̤ to. A me̤prè́ phú a myáhtye a Phè̌ Cò́marya me̤nuô tahe prè́. Phè̌ me̤tè̤ ǐtě bèbè, a phúkhǔ me̤ kuô̌dû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Me̤těhérò, phè̌ mo̤ní̤ aphúkhǔ rò a dyéluô̌ lǔ lò̌꤮ tè̤ dố a me̤ ná ané̤ nuôtahe. Aphè̌ ki dyéluô̌ lǔ tè̤me̤ dố adulốklò̌ pǎ cò́ ná yětahe pǎ rò thǐ ki khyéthukhyéthè́ nyacò́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Phú vǎphè̌ me̤htwǒprè̤ ka̤khyě kayǎ dố a thyě rò a dyé ǔ thè́htwǒprè̤ nuô, aphúkhǔyě a ki dyépé̤ kuô̌ǔ thè́htwǒprè̤ dố a thè́plòo thè́zṳ̂́ dyé pé̤ ǔ nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Phè̌ ané̤byacè ní̤dû cirya ǔ tôprè̤꤮ to. A dyétǎ̤ lốbǎ lò̌ tè̤cirya tahe dố aphúkhǔ khadǎkǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Me̤těhérò, thyáphú kayǎ lò̌꤮ plǐ ki bezṳ̂́benyá̤ aphúkhǔ phú ǔ bezṳ̂́benyá̤ phè̌nuô rò a dyétǎ̤ lò̌ tè̤cirya dố lǔ khadǎkǔ. Kayǎ dố a bezṳ̂́benyá̤ phúkhǔ to tahenuô, má̤hò́ a bezṳ̂́benyá̤ phè̌ dố a nò̌hyǎlya̤ lǔ nuôtôprè̤ to hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Vǎ hécò́cò́ thǐ, kayǎ dố a ní̤huô̌ vǎ lǎ̤ngó̤ yěrò a zṳ̂́enyá̤e prè̤ dố a nò̌hyǎlya̤ vǎ yětôprè̤ tahenuô, a ní̤bè thè́htwǒprè̤ tacṳ́prè̤ hò́. Rò a myáhtye bènò́pǎ tè̤cirya to. A cuố talwóbè́ hò́ ná tè̤thyě rò a cuốnuô̌ hò́ dố tè̤htwǒprè̤ akǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Vǎ hésocò́cò́ thǐ, shuốkhè̌ dố kayǎthyě tahe ki ní̤huô̌ Cò́marya aphúkhǔ ngó̤, rò kayǎ dố a ní̤huô̌ yětahe ki htwǒprè̤ pǎ nuô, a ki hyǎtuố̤ pǎ. A hyǎtuố̤ cò́hò́ khǒnyá̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Phú vǎphè̌ odû ná a taryěshyosò̌ dố a dyé cyá̤ ǔ thè́htwǒprè̤ nuô, phè̌yě a dyé kuô̌hò́ aphúkhǔyě a taryěshyosò̌ dố a dyé ǔ thè́htwǒprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Rò è ma prè̤lukayǎ aphúkhǔ akhu-akhyě, Cò́marya dyétǎ̤kuô̌ hò́ è taryěshyosò̌ dố a ki cirya kuô̌ǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Khyéthukhyéthè́ lahyǎ tǎmé̤, me̤těhérò shuốkhè̌ dố kayǎ odố luô̤̌kǔ lò̌꤮ plǐ tahe ki ní̤huô̌ Cò́marya aphúkhǔyě angó̤nuô a ki hyǎtuố̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bínuôakhè̌ pǎ, kayǎ o dố luô̤̌kǔ tahe ki ihtòhteka̤ lahyǎ pǎ. Kayǎ dố a me̤ryá tè̤ tahenuô a ki thyě ihtòka̤khyě rò htwǒprè̤ tacṳ́prè̤ talèkrè́ pǎ. Kayǎ dố a me̤ tè̤mǔmyá̤ tahenuô, a ki thyě ihtòka̤khyě htuô̌pǎ rò ǔ ki cirya èthǐ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Byacè Jesǔ héplehyǎ pó̤, “Vǎ me̤ cṳ́꤮ dû phú vǎ thè́zṳ̂́ me̤ nuôma aní̤ to. Vǎ cirya phú Phè̌ Cò́marya héso vǎ nuô prè́. Vǎ tè̤cirya nuôma atǒ prè́, me̤těhérò vǎ me̤ cṳ́꤮ dû vǎ thè́plònuô má̤to. Vǎ me̤prè́ phú prè̤ dố a nò̌hyǎlya̤ vǎ yětôprè̤ a tè̤thè́zṳ̂́ o nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Hékuốré̤, vǎ ki khyáluô̌ ní̤dyédû vǎrivǎkyǎ kihérò lé̤zṳ̂́ení̤ akhǎlé̤ o tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Manárò kayǎ dố a ki khyáluô̌ní̤ pé̤ thǐ ná vǎrivǎkyǎ nuô, a o tôprè̤. Rò vǎ thè́gně ná a khyáathè́ ná vǎrivǎkyǎ yěnuôma a má̤lakǒ cò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Thǐ nò̌cuố thǐkayǎ dố Giovanni a o rò a khyáathè́ ná vǎrivǎkyǎ nuôma amá̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Vǎ lo ná prè̤lukayǎ ki khyápé̤ vǎrivǎkyǎ tôprè̤꤮ to. Manárò thyáphú thǐ ki zṳ̂́e tè̤ dố è hé nuôtahe rò thǐ ki tuố̤kuô̌ǔ dố tè̤me̤lwóhteka̤ agněnuôrò, vǎ dyé thè́né̤ ka̤khyě khyěthyá thǐ ná Giovanni a hé vǎrivǎkyǎ yěnuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Giovanni nuô a lǐtakhè̌htya thyáná mikò̌ tômě dố a kyǎ̤htya nuô. Thǐ thè́luố̤ atè̤lǐ taplô̤taplyáphú prè́, angó̤lasá nuôma, a thè́hé ná thǐ thè́zṳ̂́ hyǎ ní̤dǎ a tè̤ithyó taplô̤taplyáphú prè́ a thè́hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Manárò vǎ tè̤khyáthè́ dố adulốklò̌ pǎ cò́ ná Giovanni a tè̤khyáthè́ yěnuô a o tahe. Vǎphè̌ dyé vǎ tè̤phyétè̤me̤ dố vǎ bè me̤htuô̌kyǎ, rò khǒnyá̤yě vǎ me̤ hò́ tè̤me̤ yětahe hò́. Tè̤me̤ yětahe nuôma, a khyáluô̌ hò́ athè́ ná vǎphè̌ nò̌hyǎ má̤lakǒ hò́ vǎ nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Rò phè̌ dố a nò̌hyǎ vǎ yětôprè̤nuô, a khyákuô̌ athè́ dố vǎgně. Thǐ ní̤huô̌nò́ ná atalǎ̤ to, htuô̌rò thǐ myáhtyenò́ ná amèthè tôphuố꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Cò́marya nò̌hyǎ cò́ vǎ tadû́rò thǐ zṳ̂́ení̤ kuô̌ vǎ to akhu-akhyě, Cò́marya alǎ̤angó̤ ohtwǒprè̤ kuô̌ dố thǐ thè́plòkǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Thǐ myápṳ̌thè́gně lahyǎ lisǎsè̌ tahe me̤těhérò thǐ tane̤ ná thǐ ki myáhtye thè́htwǒprè̤ tacṳ́prè̤ bí li yěnuôtahe akǔ pǎ. Lisǎsè̌ yětahe nuôma a khyáluô̌ pé̤hò́ athè́ ná vǎrivǎkyǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Manárò thyáphú thǐ ki ní̤bè kuô̌ǔ thè́htwǒprè̤ tacṳ́prè̤ agněnuô, thǐ thè́zṳ̂́ hyǎ kuô̌ lahyǎ dố vǎo to. ");
INSERT INTO kyu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Vǎ myápṳ̌ dố ǔ ki htuthè́htyaní̤ vǎ agněnuô má̤to. ");
INSERT INTO kyu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Manárò thǐ ma kayǎ phútě tahe nuôma vǎ thè́gně lò̌hò́ rò vǎ thè́gně, dố thǐ thè́plòkǔnuô, thǐ tè̤mo̤ Cò́marya oto. ");
INSERT INTO kyu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Vǎ hyǎhò́ ná vǎphè̌ amwi̤ tadû́rò thǐ è́sû vǎ to. Kayǎ dố aruôtôprè̤ ki hyǎ dố thǐo ná amwi̤ ní̤dû kihérò, thǐ è́sû mo̤ní̤ è. ");
INSERT INTO kyu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Thǐ thè́zṳ̂́ htuthè́ ní̤dyé lǔ tôprè̤ ná tôprè̤ tadû́rò tû́prè́ Cò́marya tôprè̤ ki htuthè́ní̤ thǐ agněnuô, thǐ myápṳ̌ kuô̌ lahyǎ ǔ to. Thǐ ki htuthè́ ní̤dyé khyědû lǔ phúyě kihérò thǐ cuố zṳ̂́e cyá̤ vǎ phútě? ");
INSERT INTO kyu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Tane̤ tǎ vǎ ná kayǎ tôprè̤ dố a ki dya thǐ tè̤thû́ dố phè̌ a mèthènyě nuôpǎ tǎmé̤. Mosè dố thǐ myásû̌ thè́lè̤ ní̤dyé lǔ nuôtôprè̤, ki dya thǐ tè̤thû́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Thǐ ki zṳ̂́e tǎ̤te̤ má̤lakǒ Mosè kihérò, thǐ ki zṳ̂́ekuô̌ nyǎ vǎ prè́, me̤těhérò prè̤ dố a rǎ vǎrivǎkyǎ ma è hò́. ");
INSERT INTO kyu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Manárò, má̤ dố thǐ zṳ̂́e a tè̤rǎkyǎ yěnuôtahe to akhu-akhyě, thǐ cuố zṳ̂́e cyá̤ vǎ tè̤hébè yětahe phútě?” ");
INSERT INTO kyu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Phúnuôhtuô̌rò, Jesǔ htecuốkyǎ dố Galilea htyěòdu abè́rè̤̌ tôkyě. (Ǔ è́ ná htyěòdu Tiberia ma amá̤má̤.) ");
INSERT INTO kyu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kayǎ bè́mṳ yǒ myáhtye htuô̌hò́ tè̤pro̤tè̤prya̤ dố Byacè cuố me̤sǐmé̤ pé̤ kayǎswí kayǎsè̌ tahe akhu-akhyě, èthǐ krwǒ cuốplucuốphè kuô̌ lò̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Rò Byacè Jesǔ htya dố solo̤ rò è ná a khǒpacè̤̌ tahe htya onyǎo lahyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bínuôakhè̌ Judaphú tè̤cuốtalwópwè̌ yě a phû꤮ bè hò́. ");
INSERT INTO kyu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bí Byacè Jesǔ tṳ́myá rò a myáhtye kayǎ tômṳdu hyǎ tǒ dố lǔo akhè̌, a hé Philipu, “Pè̤ ki cuố ipri̤ tǒpé̤ kayǎ yětahe lé̤e bítě è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A sudyǎ myábyeprè́ Philipu prè́. A kíré̤ me̤pé̤ èthǐ phútě pǎnuô, a tane̤ one htuô̌hò́ dố a thè́plòkǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philipu hésû, “Pè̤ ipri̤ lò̌ pé̤ cò́ èthǐ ná rû̌zye denari tôko khǎlé̤ cò́ ma, èthǐ e prè́ tôprè̤ tômû̌ nuô꤮ apòeto.” ");
INSERT INTO kyu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A khǒpacè̤̌ dố aruô tôprè̤ dố amwi̤ ná Andrea, a má̤dû Simonè Petru apuố̤ yětôprè̤ hé Byacè, ");
INSERT INTO kyu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Pacè̤̌ prè̤khǔphú o bíyě tôprè̤. Akhò́mǔ dố ǔ me̤ ná buốbali̤nuô a o nyǎ̤klò̤́ ná tè̤̌phú nyě̤bè. Manárò a ki pòe pé̤ kayǎ báprè̤tě?” ");
INSERT INTO kyu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Byacè Jesǔ hé, “Nò̌ onyǎo kayǎ nuôtahe,” a hé phúnuô. Khǎlé̤ bínuô tôpho ma mi̤thuô̌lè̌ duô̌twó̤ryálǎ. Rò shuô̌shuô̌prè́ lò̌꤮ prè̤khǔdu dố a onyǎtǎ̤ bínuô tahenuô, a phû꤮ odû nyǎ̤rí cò́. ");
INSERT INTO kyu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Byacè Jesǔ phyé khò́mǔ yětahe rò a hébwíhétaryěhtya Cò́marya. Htuô̌rò a dyétǎ̤ ná a khǒpacè̤̌ tahe rò èthǐ zṳ́tǎ̤ pé̤lò̌ ná kayǎ onyǎo bínuô tahe. A phyéke tè̤̌phúbí yěnyě̤bè rò a me̤ thyákuô̌ phú khò́mǔnuô. Rò kayǎ yětahe a thè́e kò́ cò́ bá꤮ těnuô a phyée lahyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bí èthǐ ekò́ǒbǎ lò̌htuô̌hò́ pwǒ̤꤮ tôprè̤ akhè̌nuô, Byacè Jesǔ hé a khǒpacè̤̌ tahe, “Phyédwóplò́ lò̌khyě sèe olốkyǎ nuôtahe, nò̌okyǎlố dě tǎmé̤,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Phúnuôrò a khǒpacè̤̌ tahe phyédwó khò́mǔ bali̤ nyǎ̤klò̤́ dố ǔ e htuô̌hò́ rò a okyǎlố tahenuô a obǎ pǎ cò́ ná krí̤nuô shyényě̤mě cò́. ");
INSERT INTO kyu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bí kayǎ yětahe myáhtyehtuô̌ Byacè Jesǔ me̤ tè̤pro̤tè̤prya̤ yětahe akhè̌nuô, èthǐ hé lahyǎ, “Prè̤pro̤ dố a kíré̤ hyǎlya̤ dố hekhuyě pǎ ǔ hé nuôma a má̤ nyǎ hò́ è hò́,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Byacè Jesǔ thè́gně ná èthǐ kíré̤ hyǎnò̌shyo htyahtwǒ lǔ ná khwí akhu-akhyě, a cuốhtya khókyǎ dố sokhu tû́dû tôprè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bí mò̤́hélya̤ hò́ akhè̌nuô, a khǒpacè̤̌ tahe tǎ̤kalya̤ cuố lahyǎ dố htyěòduhtû̌. ");
INSERT INTO kyu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Èthǐ tǎ̤ sidyání̤ thòklyě bínuô rò a htecuố lahyǎ dố vǐ̤ Capernaum. Vǐ̤ yěnuô a o dố htyěò bè́rè̤̌ tôkyě. Mò̤́khíhò́ tadû́rò Byacè Jesǔ ka̤tuố̤ kuô̌hí èthǐ to. ");
INSERT INTO kyu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ké̤lathè́ duhyǎ rò htyě háhódu háhósò̌ hyǎ. ");
INSERT INTO kyu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bí èthǐ khyǎcuốtuố̤ hò́ thuô̌mile, lwǐ̤mile hò́ akhè̌nuô, èthǐ myáhtye Byacè Jesǔ cuố dố htyěkhu rò hyǎphûtǒ èthǐ thòklyě. Rò èthǐ thè́isě taròthè́ lò̌plǐ cò́ lǔlé̤. ");
INSERT INTO kyu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Rò Byacè Jesǔ hé èthǐ, “Vǎprè́! Thè́isě lahyǎ tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yětôphuốrò èthǐ thè́krṳ̂̌thè́lò̌ è́sû lahyǎ Jesǔ dố thòklyěkǔ. Rò tôphuốtuô̌, thòklyěyě cuốtuố̤ gně dố htyěhtû̌ bí èthǐ lé̤cuốyě tôpho. ");
INSERT INTO kyu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Shyéparǒ tônyěnuô, kayǎ bè́mṳ dố a okyǎ dố htyěòdu bè́rè̤̌ tôkyě tahe thè́gně ná dố pahénukhè̌ nuô thòklyě okyǎprè́ tôbè prè́. Rò Byacè a khǒpacè̤̌ tahe sidyání̤ lahyǎ thòklyě nuôtôbè rò a htecuố ní̤dyédû lahyǎ prè́. Kayǎ bè́mṳ tahe thè́gně ná Byacè Jesǔ sidyácuố tố̤kuô̌ ná a khǒpacè̤̌ nuôtahe to, èthǐ htecuố ní̤dyédû lahyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Htuô̌rò thòklyě o dố vǐ̤ Tiberia rò a hyǎ tahenuô, a hyǎ okuố phû lahyǎ bí Byacè lé̤ hébwíhétaryě htya Cò́marya rò a buôe kayǎ bè́mṳ tahe ná khò́mǔ akhǎlé̤ nuôtôpho. ");
INSERT INTO kyu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bí kayǎ bè́mṳ tahe myáhtye pǎ Byacè Jesǔ ná a khǒpacè̤̌ tahe bínuô to akhè̌, thyáphú èthǐ ki cuố myápṳ̌ myáhtye Byacè Jesǔ agněnuô, èthǐ nuô̌ lahyǎ dố thòklyě tahe akǔ rò htecuố lahyǎ dố vǐ̤ Capernaum. ");
INSERT INTO kyu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bí èthǐ cuố myáhtyehò́ Jesǔ dố htyěòdu bè́rè̤̌ akhè̌nuô, a sudyǎ lǔ, “Rabbi, nè̤ hyǎtuố̤ bíyě bò́khè̌tě?” ");
INSERT INTO kyu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Byacè Jesǔ hésû èthǐ, “Vǎ hécò́cò́ thǐ, thǐ myáhtye vǎ me̤ tè̤pro̤tè̤prya̤ rò thǐ pṳ̌ vǎ má̤to. Thǐ ekò́ khò́mǔ rò thǐ pṳ̌ vǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Cyé̤pryě̤ rya̤pé̤ tǎ sèe lé̤elé̤ǒ dố a nuô̤thuô a thò̌pyé cyá̤ nuôtahe agně tǎmé̤. Cyé̤pryě̤ rya̤pé̤ sèesèǒ dố a ki dyé thǐ thè́htwǒprè̤ tacṳ́prè̤ yětahe agněnuô. Prè̤lukayǎ aphúkhǔyě, a ki dyé ǔ sèe phúnuô tahe pǎ, me̤těhérò Phè̌ Cò́marya dyéluô̌ hò́ ná a thè́plòo hò́ lǔ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Rò èthǐ sudyǎ lǔ, “Ki héphúnuô rò, thyáphú pè̤ ki me̤tǒ Cò́marya athè́plò rò pè̤ bème̤ kryá꤮ maǐtě?” ");
INSERT INTO kyu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Rò Byacè Jesǔ hésû èthǐ, “Zṳ̂́e lahyǎ vǎ dố Cò́marya nò̌hyǎ è yěnuô.” ");
INSERT INTO kyu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Phúnuôrò èthǐ sudyǎ lǔ, “Thyáphú pè̤ ki myáhtye tè̤pro̤tè̤prya̤ rò pè̤ ki zṳ̂́e agněnuô, nè̤ ki dyéluô̌ pé̤ pè̤ tè̤pro̤tè̤prya̤ ǐtětě pǎ? Nè̤ ki me̤pé̤ pè̤ matěpǎ è̌? ");
INSERT INTO kyu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Phú lisǎsè̌kǔ hé, ‘A dyée èthǐ ná sèe o dố mò́khu hyǎlya̤ tahe,’ lisǎsè̌kǔ héphúnuô rò, pè̤phyěpè̤phuô̌ dố꤮ nyénu tahe e lahyǎ khò́mǔ dố ǔ è́ ná mǎna dố ké̤sè̌htyěkya̤ lò̤́tamákhu nuô.” ");
INSERT INTO kyu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Byacè Jesǔ hésû èthǐ, “Vǎ hécò́cò́ thǐ, sèe odố mò́khu hyǎlya̤ nuôma, Mosè dyée èthǐ má̤to. Vǎphè̌ dyée èthǐ prè́. Khǒnyá̤rò a ki dyée hò́ thǐ sèe má̤lakǒ dố a o dố mò́khu hyǎlya̤ yěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Me̤těhérò Cò́marya asèe má̤lakǒ ma a o dố mò́khu hyǎlya̤ rò a dyé pé̤ prè̤lu hekhuphú thè́htwǒprè̤ nuôtôprè̤ hò́,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Rò èthǐ hé, “Byacè, pwǒ̤꤮ nyěnyě꤮ dyé pé̤ pè̤ sèe yěnuô.” ");
INSERT INTO kyu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Rò Byacè Jesǔ hésû èthǐ, “Vǎ ma sèe dố a dyé ǔ thè́htwǒprè̤ hò́. Kayǎ dố a hyǎtǒ dố vǎo nuô, a thè́vǐ̤thè́e pǎ tôphuố꤮ to. Kayǎ dố a zṳ̂́e vǎ nuô, a thè́ǒpǎ takhyá꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Manárò, phú vǎ héhtuô̌hò́ thǐnuô, thǐ myáhtye cò́ vǎ tadû́rò thǐ zṳ̂́e vǎ to. ");
INSERT INTO kyu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Lò̌꤮ kayǎ dố vǎphè̌ dyé vǎ tahenuô, a ki hyǎ dố vǎo pǎ. Ǔpěpě꤮ bèbè, a ki hyǎ dố vǎo nuô, vǎ vè̤́htekyǎ ná è taki꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Me̤těhérò vǎ odố mò́khu hyǎlya̤ rò vǎ hyǎme̤ cṳ́꤮ dû vǎ thè́plò phúnuô má̤to. Vǎ hyǎme̤ phú prè̤ dố a nò̌hyǎ vǎ yětôprè̤ a tè̤thè́zṳ̂́ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tè̤ dố atǒ prè̤ dố a nò̌hyǎ vǎ yětôprè̤ athè́plò ma matě hénuôma, lò̌꤮ kayǎ dố a dyé vǎ nuôtahe vǎ bèplwǒ lamé̤kyǎní̤ èthǐ to. Shyé꤮ mò̤́nyě dố khyětadûlố tônyě pǎnuô, vǎ bème̤ ihtòhtwǒprè̤ ka̤khyě èthǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Me̤těhérò, vǎphè̌ a tè̤thè́zṳ̂́ ma má̤hò́ lò̌꤮ kayǎ dố a myáhtye aphúkhǔ yě rò a zṳ̂́e tahenuô, a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤, rò vǎ ki me̤ ihtòhtwǒprè̤ ka̤khyě èthǐ shyé꤮ mò̤́nyě dốkhyě tadûlố nuôtônyě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Vǎ ma sèe odố mò́khu hyǎlya̤,” Byacè Jesǔ yǒ hé phúnuô akhu-akhyě, Judaphú tahe tamwǒ̤talè̌ lò̌plǐ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Èthǐ hé lahyǎ, “È ma Joseph aphúkhǔ Jesǔ hénuô tôprè̤ prè́ vǎhéto? Amuố̤aphè̌ ma pè̤ thè́gně prè́ vǎhé? Mame̤těrò a cuố hétuố̤ ní̤dyé ané̤, ‘Vǎ o dố mò́khu hyǎlya̤’ phútě?” ");
INSERT INTO kyu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Byacè Jesǔ hésû èthǐ, “Tamwǒ̤talè̌ pǎ tǎ lahyǎ tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ki má̤ ná vǎphè̌ dố a nò̌hyǎ vǎyě tôprè̤ ki nò̌hyǎ ǔ dố vǎo to hénuô, ǔ hyǎbè́ dố vǎ o tôprè̤꤮ to. Kayǎ dố a hyǎ dố vǎo tahenuô, vǎ ki me̤ ihtòhtwǒprè̤ ka̤khyě èthǐ shyé꤮ mò̤́nyě dốkhyě tadûlố tônyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Prè̤pro̤ tahe rǎokyǎ, ‘Cò́marya ki ithyóithya èthǐ lò̌꤮ plǐ pǎ.’ Lò̌꤮ kayǎ dố a ní̤huô̌ phè̌ a tè̤ithyóithya rò a hyǎ ithyóithya tè̤ dố lǔo tahenuô, a ki hyǎ dố vǎ o pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kayǎ myáhtyenò́ Phè̌ Cò́marya tôprè̤prè̤, vǎ thè́zṳ̂́ hé phúnuô má̤to. Ǔ myáhtyenò́ phè̌ tôprè̤꤮ to, myáhtyenò́ phè̌ ma tû́prè́ a o dố Cò́marya a o rò a hyǎlya̤ nuôtôprè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Vǎ hécò́cò́ thǐ, kayǎ dố a zṳ̂́enyá̤e vǎ tôprè̤prè̤ nuô, a ki ní̤bèhò́ thè́htwǒprè̤ tacṳ́prè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Vǎ ma sèe dố a dyé ǔ thè́htwǒprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Thǐ phyěphuô̌ dố꤮ nyénu tahe e khò́mǔmǎna tadû́rò a thyěpǎ lahyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Manárò, sèe o dố mò́khu hyǎlya̤ vǎ hé thǐ nuôma, a o bíyě. Ǔpěpě꤮ bèbè a ki e sèeyě hénuôma, a thyě pǎto. ");
INSERT INTO kyu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Vǎ ma sèe dố a dyé ǔ thè́htwǒprè̤ rò a o dố mò́khu hyǎlya̤. Ǔpěpě꤮ bèbè, a ki e sèe yěnuô, a ki htwǒprè̤ tacṳ́prè̤ pǎ. Sèe yěnuôma má̤hò́ vǎzye yěnuô hò́. Thyáphú prè̤lu hekhuphú ki htwǒprè̤ agněnuô vǎ dyélya̤kyǎ vǎ né̤klò̤́ yě dố èthǐgně hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judaphú tahe kréthyěkréo ní̤dyélǔ, “A cuố dyée cyá̤ pè̤ ná azye phútě?” ");
INSERT INTO kyu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Rò Byacè Jesǔ hésû èthǐ, “Vǎ hécò́cò́ thǐ, thǐ ki e prè̤lukayǎ aphúkhǔ yě azye to, thǐ ki ǒ lǔthwi to hénuô, thè́htwǒprè̤ o dố thǐkǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Manárò kayǎ dố a e vǎzye ǒ vǎthwi tahenuô, a ní̤bè thè́htwǒprè̤ tacṳ́prè̤, rò shyé꤮ mò̤́nyě tadû dố khyělố tônyě pǎnuô, vǎ ki me̤htwǒprè̤ ihtòka̤khyě lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Me̤těhérò vǎzye ma lé̤e má̤lakǒ, vǎthwi ma lé̤ǒ má̤lakǒ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kayǎ dố a e vǎzye ǒ vǎthwi tôprè̤prè̤ nuô, a ohtwǒprè̤ dố vǎkǔ, rò vǎ ohtwǒprè̤ dố èkǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Phú vǎphè̌ dố a nò̌hyǎ vǎyě tôprè̤ htwǒprè̤ nuô, dố èkhuèkhyě rò vǎ htwǒprè̤ kuô̌. Phúnuôrò kayǎ dố a e vǎzye tôprè̤prè̤ nuô, dố vǎkhuvǎkhyě rò a ki htwǒprè̤ kuô̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yěma sèe odố mò́khu hyǎ hò́. Thǐphyěthǐphuô̌ mú꤮ nukhè̌ tahe e khò́mǔmǎna tadû́rò a thyě lahyǎ prè́. Manárò kayǎ dố a e sèe dố vǎ hé pé̤ thǐ khǒnyá̤ yětahenuô a ki htwǒprè̤ tacṳ́prè̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Bí a ithyótǎ̤ ǔ dố vǐ̤ Capernaum tè̤cò́bè̌ hǒkǔ akhè̌nuô, a hé ǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Èthǐ ní̤huô̌ Byacè Jesǔ héphúnuô rò, a khǒpacè̤̌ è́prè̤ hé lahyǎ, “A tè̤ithyó yě apyá̤ nyacò́. Ǔpě tôprè̤ kíré̤ zṳ̂́ephyésû bè́kuô̌ a tè̤ithyóyě pě?” ");
INSERT INTO kyu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","A khǒpacè̤̌ tahe tamwǒ̤talè̌ lahyǎ phúyěnuô a thè́gně akhu-akhyě, a hé èthǐ, “Vǎ hé phúyě rò thǐ thè́plòpyé lò̌ lahyǎ ná vǎ tè̤ithyó yětahe è̌? ");
INSERT INTO kyu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ki me̤phúnuô hérò, thǐ myáhtye prè̤lukayǎ aphúkhǔyě ki ka̤kahtya khyěthyá dố akhǎlé̤ lé̤o pǎ hérò, thǐ ki tane̤ lahyǎ phútě pǎ? ");
INSERT INTO kyu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Thè́ Sǎsè̌ Byacè nuô a dyé thè́htwǒprè̤ tacṳ́prè̤. Prè̤lukayǎ nuô, a dyé cyá̤ thè́htwǒprè̤ tacṳ́prè̤ to. Ngó̤ dố vǎ hébè thǐ yětahe nuôma, Thè́ Sǎsè̌ Byacè a tè̤hébè tahe rò a dyébè́ ǔ thè́htwǒprè̤ tacṳ́prè̤. ");
INSERT INTO kyu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Manárò dố thǐklè̌ nuô, kayǎ dố a zṳ̂́e kuô̌ǔ tonuô a o tahe.” Me̤těhérò Byacè Jesǔ thè́gně pǎ cò́ dố akhǎshyé, dố èthǐklè̌ nuô a zṳ̂́e lǔ to, rò a ki isè̌tǎ̤kyǎ lǔ pǎnuô a otôprè̤nuô, a thè́gně rò a hé èthǐ phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A hé plehyǎ pó̤, “Dố thǐklè̌nuô kayǎ zṳ̂́e vǎ to otahe, tû́rò vǎ hé hò́ thǐ, phè̌ ki nò̌hyǎ ǔ dố vǎo to hénuô ǔ hyǎbè́ dố vǎo tôprè̤꤮ to, phúnuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Cáhtya bínuô rò a khǒpacè̤̌ tahe ka̤kyǎ è́lǎ rò krwǒkuô̌ pǎ lǔkhyě to. ");
INSERT INTO kyu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Rò a sudyǎ a khǒpacè̤̌ shyéthè́nyě̤ yětahe, “Thǐlě, thǐ thè́zṳ̂́ hteka̤kyǎ kuô̌ vǎlé̤ phúnuô vǎhéto?” A hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simonè Petru hé ka̤khyěsû lǔ, “Byacè, pè̤ kíré̤ cuốtǒ kuô̌ ǔpě? Tè̤ithyóithya dố a dyé pè̤ thè́htwǒprè̤ tacṳ́prè̤ nuô a o prè́tû́ dố nè̤o prè́. ");
INSERT INTO kyu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pè̤ zṳ̂́e rò pè̤ thè́gně ná nè̤ ma Cò́marya a prè̤sǎsè̌phú tôprè̤, rò a nò̌hyǎlya̤ nè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Htuô̌rò Byacè Jesǔ hésû èthǐ, “Vǎ nwóhtya htuô̌hò́ thǐ shyéthè́nyě̤, má̤to è̌? Manárò, dố thǐklè̌ nuô, khǐnéricyá̤ khuklò́ otôduô̌,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(A hé phúyěma a thè́zṳ̂́ hé Simonè Iscariot aphúkhǔ Juda. È ma a otố̤kuô̌ dố shyéthè́nyě̤yě aklè̌ tadû́rò dốkhyěnuô a isè̌tǎ̤kyǎ Byacè Jesǔ.) ");
INSERT INTO kyu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Byacè Jesǔ héhtuô̌ phúyě rò, a cuố dố Galilea ké̤ rò, a lě tôdò̌ htuô̌ tôdò̌ bínuô. Judaphú khuklò́khuklyǎ tahe yǒ myápṳ̌ me̤thyě lǔ akhu-akhyě, a thè́zṳ̂́ cuố dố Juda ké̤kǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Manárò, bínuôkhè̌, Judaphú apwè̌ isò́lé̤thû kíré̤ bè nuô a phûhyǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Phúnuôrò Byacè Jesǔ a puố̤prè̤khǔ tahe hé lǔ, “Thyáphú nè̤ khǒpacè̤̌ tahe ki myáhtyekuô̌ nè̤ me̤ tè̤pro̤tè̤prya̤ tahe agněnuôrò, nè̤ tǒkò htecuố khókyǎ ná bíyě rò cuố dố Juda ké̤kǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kayǎ dố a thè́zṳ̂́ mwi̤ luô̌htyěluô̌ké̤ hénuôma, a me̤huôme̤thwè́ tè̤ tôprè̤꤮ to. Nè̤ ki me̤nyǎ hò́ tè̤pro̤tè̤prya̤ phúnuôtahe hérò dyéluô̌ pé̤ kuô̌ǔ nè̤né̤ ná hekhu tôbalò̌ nuô kǒkǒ.” ");
INSERT INTO kyu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Me̤těhérò Byacè a puố̤prè̤khǔ ní̤dyédû tahecò́nuô꤮, a zṳ̂́e lǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A hé lǔ phúnuô akhu-akhyě, Byacè Jesǔ hé èthǐ, “Shuốkhè̌tǒ shuốkhè̌bènuô a hyǎtuố̤ dố vǎgně híto. Manárò dố thǐgněnuô thǐcuốthǐka̤ bíkhè̌tě ma aní̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Prè̤lu hekhuphú tahe thè́hte cyá̤ thǐ to. Manárò a thè́hte lahyǎ vǎ, me̤těhérò vǎ yǒ héhteluô̌ èthǐ me̤ tè̤mǔmyá̤ tahe nuô̌꤮. ");
INSERT INTO kyu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cuốdûmò̌ lahyǎ dố pwè̌kǔ nuô. Vǎ cuố híto, me̤těhérò shuốkhè̌tǒ shuốkhè̌bè hyǎtuố̤ dố vǎgně híto.” A hésû apuố̤ thǐtahe phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Byacè Jesǔ héhtuô̌ phúyě rò a okyǎ bí Galilea ké̤kǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Manárò bí a puố̤prè̤khǔ tahe htecuốkyǎ htuô̌hò́ akhè̌nuô, a hte cuốhuôcuốthwè́ kuô̌ dốkhyě, a cuốlá̤cuốlǐ to. ");
INSERT INTO kyu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judaphú khuklò́khuklyǎ tahenuô, “Jesǔ otǒ bítě?” A myápṳ̌ sudyǎ lahyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kayǎ bè́mṳ tahe dônyǎhuô dônyǎthwè́ è́nyacò́ lǔrilǔkyǎ. Tahehenuô, a hé lahyǎ, “È ma kayǎ ryá prè́.” Akhǒruô tahe hésû, “Aryá má̤to. A pṳ̌ ilolahǒ ǔ prè́,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ǔ yǒ thè́isě lahyǎ Judaphú khuklò́khuklyǎ tahe rò ǔ hélá̤hélǐ sûbû tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bí ǔ pwè̌ phû꤮ klǎměhò́ akhè̌nuô, Byacè Jesǔ cuốhtyanuô̌ dố tè̤lǔtyǎ hǒkǔ rò a cáhtya ithyóithya ǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judaphú khuklò́khuklyǎ tahe khyéthukhyéthè́ rò a hé lahyǎ, “A htyadyánò́ kuô̌ǔ dố Judaphú thyólihǒ a thárádu tahe a khadǎkǔ to tadû́rò a cuố thè́gně è́nyacò́ báyě nuôma a cuố ithyóní̤tǒ bítětě?” ");
INSERT INTO kyu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Rò Byacè Jesǔ hésû èthǐ, “Vǎ ithyó ǔ yětahe nuôma vǎ tè̤ithyóithya ní̤dû má̤to. Tè̤ithyó yětahe nuôma a hyǎ dố Cò́marya dố a nò̌hyǎ vǎyě tôprè̤ a o. ");
INSERT INTO kyu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kayǎ tôprè̤prè̤ ki thè́zṳ̂́ lṳ̂me̤tǒ Cò́marya athè́plò hénuô, tè̤ithyóithya yětahe nuôma a o dố Cò́marya a ohyǎ è̌? Má̤torò vǎ hébè ní̤dyédû ná vǎ taryěshyosò̌ è̌, nuô aklyá thè́gně nyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kayǎ dố a hébè ní̤dyédû ná a taryěshyosò̌ tôprè̤prè̤ nuô, a thè́zṳ̂́ nò̌htuthè́ní̤ ǔ ná ané̤ prè́. Manárò kayǎ dố a thè́zṳ̂́ nò̌htuthè́ní̤ ǔ ná prè̤ dố a nò̌hyǎ lǔ yětôprè̤prè̤ nuô, a hébècò́ prè́, a lahǒlahya ǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosè dyéhò́ thǐ tè̤thyótè̤thya vǎhéto? Manárò thǐ lṳ̂krwǒme̤ kuô̌ tè̤thyótè̤thya tôprè̤꤮ to. Thǐ pṳ̌ me̤thyě vǎ me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Khǐné me̤bè hò́ nè̤ hò́. Ǔpě tôprè̤ pṳ̌me̤thyě nè̤ pě?” Kayǎ bè́mṳ hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Rò Jesǔ hésû èthǐ, “Dố Mò̤́nyěduô akhè̌nuô, vǎ me̤ pé̤ thǐ tè̤pro̤tè̤prya̤ tôcô rò thǐ khyéthukhyéthè́ lò̌ cò́ pwǒ̤꤮ tôprè̤ vǎ! ");
INSERT INTO kyu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosè mekyǎ thǐ, lò̌꤮ thǐ phúprè̤khǔ tahenuô thǐ bè dû́talí lǔphá a hé rò thǐ dû́talí lahyǎ aphá bí Mò̤́nyěduô nuôtônyě. Ki héklyácò́ rò prè̤ dố a me̤ ré̤lố yěnuôma, Mosè má̤to. Thǐphyěthǐphuô̌ dố꤮ nyénu tahe cáhtya me̤ré̤lố prè́. ");
INSERT INTO kyu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Phúnuôrò thyáphú thǐ ki khè̌talwócuốtalye̤ tǎ Mosè a tè̤thyótè̤thya tǎmé̤ nuô, thǐ ki tǒ dû́talí lahyǎ thǐ phúprè̤khǔ tahe aphá bí Mò̤́nyěduô akhè̌nuô, kihérò thǐ dû́talí lahyǎ prè́. Phúnuôrò bí vǎ zasǐmé̤ kayǎswí kayǎsè̌ dố Mò̤́nyěduô akhè̌ rò thǐ cuố thè́plòdu vǎ me̤tě? ");
INSERT INTO kyu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dyatè̤thû́ tǎ ǔ phú thǐ myáhtye ǔ dố aklò̌ nuôtahe tǎmé̤. Má̤tôkhónuô, dyalya̤cò́ dyalya̤te̤ lahyǎ thǐ thè́plò dố thǐ ki ciryatǒ ciryabè ǔ nuô ní.” ");
INSERT INTO kyu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalemphú tahehe hé, “Judaphú khuklò́khuklyǎ pṳ̌ me̤thyě lǔ nuôma è hò́ è̌? ");
INSERT INTO kyu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Myámò̌lé, a hébècò́ dố kayǎ tôplutôphè anyěhyǎ cò́ rò ǔ hé tǎ̤tṳ̂̌ lǔ tôprè̤꤮ to. Khǒnyá̤yě ma pè̤ khuklò́khuklyǎ tahe thè́gně tǎ̤te̤ hyǎnyǎ hò́ ná è ma Messia tôprè̤ hò́, phúnuô è̌ ha? ");
INSERT INTO kyu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ǔ hé ná Krístu ki hyǎpǎ nuô, ǔ thè́gně adò̌aso tôprè̤꤮ to ǔ hé vǎhé, manárò èyě a o tǒ dò̌bítě nuô pè̤ thè́gně prè́yě.” Èthǐ hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bí Byacè Jesǔ ithyótǎ̤pǎ ǔ dố tè̤lǔtyǎ hǒkǔ akhè̌nuô, a è́htǒhtya, “Thǐ thè́gně vǎ nuôma amá̤vǎ. Vǎ o tǒ bítě hyǎ nuôma thǐ thè́gně má̤lakǒ nyǎ vǎ ni. Vǎ hyǎ cṳ́꤮ dû vǎ thè́plò má̤to. Prè̤ dố a nò̌hyǎ vǎ yětôprè̤ nuôma, thǐ thè́gně lǔ to. È ma prè̤ dố acò́ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Manárò vǎ thè́gně lǔ, me̤těhérò vǎ yǒ o dố lǔo hyǎ prè́ nuô̌꤮. Prè̤ nò̌hyǎ vǎ ma è prè́ nuô̌꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A héhtuô̌ phúnuôrò èthǐ pṳ̌htû́pṳ̂́ Byacè Jesǔ. Manárò shuốkhè̌ dố ǔ ki pṳ̂́ me̤thyě lǔ agněnuô, a hyǎtuố̤ híto akhu-akhyě ǔ pṳ̂́hí lǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Manárò ǔ zṳ̂́eró̤ zṳ̂́eè́ pǎnyǎ lǔ prè́. Èthǐ hé lahyǎ, “Shyé꤮ Krístu ǔ hé nuôtôprè̤ hyǎpǎ akhè̌nuô, a ki me̤ tè̤pro̤tè̤prya̤ è́klò̌pǎ cò́ ná yětôprè̤ pǎ è̌?” A hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Èthǐ hébèhuô hébèthwè́ ní̤dyélǔ ná Byacè Jesǔ Krístu ari-akyǎ phúyě akhè̌nuô, Pharisěophú tahe ní̤huô̌ rò èthǐ ná bwídukhu tahe nò̌cuốpṳ̂́ Byacè Jesǔ ná klyěphú dố a opò̤́ tè̤lǔhǒdu nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Byacè Jesǔ hé, “Vǎ otố̤ nyě̤kuô̌pǎ ná thǐ to. Nyě̤tyato pǎma vǎ ki ka̤khyě khyěthyá dố prè̤nò̌hyǎ vǎ yětôprè̤ a o hò́. ");
INSERT INTO kyu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Thǐ ki myápṳ̌thû́ lahyǎ vǎ pǎ, manárò thǐ myáhtye vǎ to. Dố vǎ lé̤o akhǎlé̤ nuô, thǐ cuố cyá̤ kuô̌ vǎ tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judaphú khuklò́khuklyǎ tahe hé ní̤dyé lǔ tôprè̤ ná tôprè̤ rò a hé lahyǎ, “Pè̤ myáhtye cyá̤ è to a hé nuôma, a kíré̤ tane̤ cuố tǒ bítě ha? Ma a kíré̤ cuố dố pè̤ Judaphú cuốo kuô̌ǔ dố Greekphú nuôtahe aklè̌ rò a kíré̤ cuố ithyóke Greekphú bínuôtahe è̌ ha? ");
INSERT INTO kyu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Htuô̌rò a hé, ‘Thǐ ki myápṳ̌ vǎ pǎ tadû́rò thǐ myáhtye vǎ to,’ a hé phúnuô htuô̌rò, a hé pó̤, ‘Dố vǎ lé̤o akhǎlé̤ nuô, thǐ cuố cyá̤ kuô̌ vǎ to,’ a hé phúnuôma a thè́zṳ̂́ hé ǐtě ha?” A hé ní̤dyé lǔ tôprè̤ ná tôprè̤ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bí pwè̌dulố dốkhyě tônyě akhè̌nuô, Byacè Jesǔ kahtò è́htǒ, “Lò̌꤮ kayǎ dố a thè́ǒ htyě tahenuô, nò̌hyǎ phyéǒ lahyǎ htyě dố vǎ oyě. ");
INSERT INTO kyu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ǔpěpě꤮ bèbè, dố a zṳ̂́enyá̤e vǎnuô, phú lisǎsè̌kǔ hé, htyě dố a dyé ǔ thè́htwǒprè̤ ahtyěklǒ yěnuô, a ki htwíhte dố lǔkǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Htyě dyé ǔ thè́htwǒprè̤ dố Byacè Jesǔ hé yěnuôma má̤ Thè́ Sǎsè̌ Byacè prè́. Ǔpěpě꤮ bèbè dố a zṳ̂́e lǔ tahenuô, a ki ní̤bè pǎ. Byacè Jesǔ ní̤bè hí tè̤taryědu taryěhtǔ to, me̤těhérò a thyě ihtòka̤khyě rò a ka̤ kahtya dố mò́khu híto. Phúnuôrò Cò́marya a Thè́ Sǎsè̌ hyǎnuô̌o dố èthǐ thè́plòkǔ tôprè̤ híto. ");
INSERT INTO kyu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bí kayǎ bè́mṳ ní̤huô̌ Byacè Jesǔ è́htǒ hé phúyě akhè̌nuô, tahehe rò a hé, “È ma prè̤pro̤ dố pè̤ opò̤́myásû̌ lǔ nuôtôprè̤ má̤nyǎ hò́.” A hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tahehe rò a hé, “Messia má̤nyǎ hò́,” manárò tahehenuô a hé, “Messia o dố Galilea ké̤ rò a ki hyǎ pǎ má̤to. ");
INSERT INTO kyu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lisǎsè̌kǔ hé, Messia ki hyǎ ohtya dố Khwí Davi aklwǐalyǎkǔ pǎ, a ki hyǎ opacè̤̌lya̤ dố Khwí Davi o ní̤dyé vǐ̤ Bethelehem akǔnuô pǎ, vǎhéto?” A hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Dố Krístu akhu-akhyěrò kayǎ bè́mṳ tahe tane̤ lṳkhókhyělǔ tômṳ ná tômṳ. ");
INSERT INTO kyu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tahehenuô a thè́zṳ̂́ pṳ̂́ lǔ, manárò ǔ pṳ̂́ lǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bí klyěphú opò̤́ tè̤lǔhǒdu tahe ka̤khyě khyěthyá dố bwídukhu tahe ná Pharisěophú tahe a o akhè̌nuô, a sudyǎ èthǐ, “Thǐ pṳ̂́ka̤ní̤ è to me̤tě?” A hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Klyěphú opò̤́ tè̤lǔhǒdu tahe hésû èthǐ, “Ǔ hébèdônyǎ thyáná ènuô a o tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Rò Pharisěophú tahe hétakèsû èthǐ, “Ma a ilo ní̤kuô̌ cò́ hò́ thǐ kǒ? ");
INSERT INTO kyu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Pè̤ dố a htwǒ tè̤cò́bucò́bè̌ a khuklò́khuklyǎ aklè̌ yětahenuô bèbè, Pharisěophú aklè̌ yětahe nuôbèbè, a zṳ̂́e kuô̌ lǔ nuôma a o nyǎ tôprè̤prè̤ è̌? ");
INSERT INTO kyu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A o tôprè̤꤮ to. Kayǎ bè́mṳ nuôtahe ma a thè́gně kuô̌ǔ Mosè a tè̤thyótè̤thya tôcô꤮ to akhu-akhyě, a cuố zṳ̂́ebò̌ zṳ̂́ebye dûgně lahyǎ prè́. Cò́marya ki cirya èthǐ pǎ,” Pharisěophú tahe hétakèsû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kayǎmwi̤ ná Nicodemo o tôprè̤. È ma a otố̤kuô̌ dố Pharisěophú aplò́amṳklè̌ tôprè̤. Dố aré̤khè̌ nuôma a hyǎnò́ dố Byacè Jesǔ a o. Rò Nicodemo yě sudyǎ èthǐ, ");
INSERT INTO kyu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kayǎ tôprè̤ me̤htuô̌hò́ kryá꤮ maǐtěnuô pè̤ ki ní̤huô̌hí a hé to, pè̤ ki myápṳ̌thè́gně htuô̌hí atè̤me̤ tahe híto nuô, pè̤ bè ciryaní̤ è to pè̤ tè̤thyótè̤thya ophúnuô, vǎhéto?” A sudyǎ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Èthǐ hésû lǔ, “Nè̤ ma꤮ Galilea ké̤phú prè́prè́. Myápṳ̌ rwó ka̤khyě khyěthyá mò̌ lisǎsè̌ nuô, nè̤ ki myáhtye thè́gně ná prè̤pro̤ nuôtôprè̤ ohtya dố Galilea ké̤kǔ pǎ má̤to.” ");
INSERT INTO kyu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Htuô̌rò kayǎ ka̤kyǎ lò̌ dố ahi pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Manárò Byacè Jesǔ rò a cuốhtyakyǎ dố Oliva sokhu. ");
INSERT INTO kyu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Anotôrǒ mò̤́lǐro̤mû́ akhè̌nuô, Byacè Jesǔ ka̤khyě khyěthyá dố tè̤lǔtyǎ hǒkǔ. Kayǎ pwǒ̤꤮ tôprè̤ hyǎ otava̤ lò̌plǐ lǔ. Htuô̌rò a onyǎtǎ̤ rò a ithyóithya èthǐ. ");
INSERT INTO kyu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Prè̤ithyó tè̤thyótè̤thya athárá tahe ná Pharisěophú tahenuô a pṳ̂́hyǎní̤ prè̤mò tôprè̤ dố Byacè Jesǔ a o. Èthǐ myáhtye lè́ní̤ prè̤mò yětôprè̤ bí a cuốthû́ prè̤khǔ akhè̌nuô. Èthǐ nò̌ihtòo prè̤mò yětôprè̤ dố kayǎ bè́mṳ a mèthènyě. ");
INSERT INTO kyu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Htuô̌rò a hé Byacè Jesǔ, “Thárá, prè̤mò yětôprè̤ ma pè̤ myáhtye lè́ní̤ cò́ lǔ bí a cuốthû́ prè̤khǔ akhè̌nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosè a tè̤thyótè̤thya akǔnuô, a mekyǎ pè̤ ná prè̤mò phúyě tahe nuôma tǒbè tá̤thyěkyǎ è ná lò̤́. Nè̤ kuô̌kelé꤮, nè̤ kíré̤ hékuô̌ phútě?” ");
INSERT INTO kyu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Thyáphú èthǐ pṳ̂́ní̤ Byacè Jesǔ a tè̤hébèthû́ ngó̤ tahe agněnuô, a hyǎpṳ̌ sudyǎ khobyeprè́ lahyǎ Jesǔ. Manárò Byacè Jesǔ onyǎ palo̤tǎ̤ rò a ngò̤lya̤ rǎ li ná akanò̌ dố hemûklè̌. ");
INSERT INTO kyu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Èthǐ yǒ sudyǎ htuô̌htuô̌ sudyǎ thyáthyá lǔ akhu-akhyě, a ihtò rò a hé èthǐ, “Kayǎ dố thǐklè̌ tôprè̤prè̤ nuô, a ki hé ní̤dyé ané̤ ná atè̤thû́ oto hénuô, tá̤ ré̤lốmò̌ prè̤mò yětôprè̤ ná lò̤́ nuô,” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Byacè Jesǔ onyǎtǎ̤ khyěthyá rò a rǎtǎ̤ khyěthyá li ná akanò̌ dố hemûklè̌. ");
INSERT INTO kyu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bí èthǐ ní̤huô̌hò́ Jesǔ héphúnuô akhè̌, èthǐ hteka̤kyǎ lò̌ tôprè̤ htuô̌ tôprè̤. A muố̤prè̤́ tahe hteka̤ ré̤lố ǔ. Dốkhyě rò prè̤mò nuôtôprè̤ ihtò okyǎ tû́kuô̌dû ná Jesǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Byacè Jesǔ ihtò rò a sudyǎ lǔ, “Mòmuố̤, èthǐ cuốtǒlò̌ bítě? Ǔ cirya pǎ nè̤ tôprè̤꤮ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Rò a hésû lǔ, “A opǎ tôprè̤꤮ to.” Rò Byacè Jesǔ hé lǔ, “Vǎ ma꤮ vǎ cirya nè̤ toto. Ka̤mò̌ rò me̤pǎ tǎ tè̤thû́ tǎmé̤ ní꤮,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Byacè Jesǔ hé khyěthyá kayǎ nuôtahe, “Vǎ ma hekhu atè̤lǐ. Kayǎ dố a krwǒ vǎkhyě tôprè̤prè̤ nuô, a cuố pǎ dố tè̤khítè̤lò̤ aklè̌ takhyá꤮ to. A ki ní̤bè tè̤lǐ dố a dyé lǔ thè́htwǒprè̤ athè̌ yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisěophú tahe hé lǔ, “Nè̤ hésoluô̌ ní̤ nè̤rinè̤kyǎ tahenuô lé̤zṳ̂́ení̤ akhǎlé̤ o náto. Mame̤těrò pè̤ zṳ̂́ení̤ nè̤ tè̤hébè to hérò nè̤ hébè ní̤dyé lò̌dû prè́ nè̤rinè̤kyǎ prè́,” èthǐ hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Byacè Jesǔ hésû èthǐ, “Vǎ hé ní̤dyé cò́ vǎrivǎkyǎ tadû́rò vǎ hé yětahe nuôma atǒ prè́ me̤těhérò vǎ obítěhyǎ nuô vǎ thè́gně ní̤dyé, vǎ kíré̤ cuố bítě pǎ nuô vǎ thè́gně ní̤dyé prè́. Manárò vǎ obítěhyǎ, tomaná, vǎ kíré̤ cuốtǒ bítě pǎnuô thǐ thè́gně to. ");
INSERT INTO kyu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Thǐ dǎcirya ǔ kihérò thǐ cirya ǔ phú prè̤lu hekhuphú alé̤klǒ me̤nuô prè́. Vǎ rò vǎ cirya ǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Manárò vǎ ki cirya ǔ hénuô, vǎ ki cirya cò́cò́te̤te̤ ǔ prè́, me̤těhérò vǎ cirya tû́dû tôprè̤ má̤to. Vǎ me̤ró̤ tố̤kuô̌ ná vǎphè̌ dố a nò̌hyǎ vǎ yětôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dố thǐ tè̤thyótè̤thya akǔ nuô, ǔ rǎo ná ki kayǎ thè́nyě̤ hébèhte thyálǔ hénuô, èthǐ tè̤hébè tahenuô ǔ dya ná a tǒhò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Vǎ hébè ní̤dyé vǎrivǎkyǎ vǎ. Vǎphè̌ dố a nò̌hyǎ vǎ yětôprè̤nuô, a hésodônyǎ ní̤kuô̌dû vǎrivǎkyǎkyǎ, phúnuôrò pè̤ thè́gně héhte thyálǔ prè́.” A hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","“Nè̤phè̌ otǒ bítě?” Èthǐ sudyǎ lǔ phúnuô. Rò a hésû èthǐ, “Vǎ rò thǐ thè́gně toto, vǎphè̌ rò thǐ thè́gně toto. Thǐ ki thè́gně vǎ kihérò thǐ thè́gně kuô̌dû vǎphè̌ prè́.” A hésû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Bí a ithyó ǔ dố tè̤lǔtyǎ hǒkǔ akhè̌nuô, a hé èthǐ phúnuô. Akhǎlé̤ lé̤ithyó ǔ dố tè̤lǔtyǎ hǒkǔ yěnuôma, a ophû ná lé̤be-oplò́ tè̤me̤lǔtố akhǎshyé. Manárò dố Cò́marya taritaryǎ one pé̤ Jesǔ dố ǔ ki me̤thyě lǔ agněnuô, a yǒ tuố̤ tyahíto akhu-akhyě, ǔ pṳ̂́ lǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Byacè Jesǔ hé pé̤ pó̤ èthǐ, “Vǎ ki htecuốhò́ pǎ, rò thǐ ki pṳ̌thû́ vǎ pǎ. Thǐ ki thyě pǎ tadû́rò Cò́marya plwǒkyǎ thǐ tè̤thû́ yětahe to. Bí vǎ lé̤cuố khǎlé̤ nuô thǐ cuốcyá̤to,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Phúnuôrò Judaphú khuklò́khuklyǎ tahe hé lǔ, “A hé ná bí èlé̤cuố akhǎlé̤ nuô, pè̤ cuốcyá̤to a hé phúnuôma a kíré̤ me̤thyě ní̤dyédû ané̤ pǎ è̌ ha?” A hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Byacè Jesǔ hé èthǐ, “Vǎrò mò́khu a htyěphúké̤phú tôprè̤, manárò thǐ ma hekhu a htyěphúké̤phú prè́. Lò̌꤮ thǐ tè̤tane̤ tahenuô, a ícû̌ lò̌ ná hekhu prè́. Lò̌꤮ vǎ tè̤tane̤ tahenuô, a ícû̌ ná mò́khu. ");
INSERT INTO kyu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Phúnuôrò, vǎ hé thǐ ná thǐ ki thyě pǎ tadû́rò Cò́marya plwǒkyǎ thǐ tè̤thû́ yětahe to vǎ hé thǐ nuôma yěhò́. Vǎ ma ǔpěnuô vǎ héso pé̤htuô̌hò́ thǐ rò thǐ ki zṳ̂́eto hénuô, thǐ ki thyě pǎ tadû́rò Cò́marya plwǒkyǎ thǐ tè̤thû́ yětahe to.” ");
INSERT INTO kyu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Èthǐ sudyǎ lǔ, “Nè̤ ma ǔpě?” Rò Byacè Jesǔ hésû èthǐ, “Vǎ ma ǔpěnuô, vǎ héhtuô̌hò́ thǐ dố kalúkhè̌ nuôpǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Vǎ ki hé thǐrithǐkyǎ hénuôma, a lé̤hé oè́lǎpǎ, htuô̌to vǎ lé̤dya thǐ tè̤thû́ nuô, a oè́lǎpǎpǎ. Manárò ngó̤ dố vǎ hé pé̤ prè̤lu hekhuphú yětahe nuôma má̤prè́ vǎ ní̤huô̌ dố prè̤ dố a nò̌hyǎ vǎ yěnuô tôprè̤ a o rò tè̤ dố a hé tahe nuôma a tǒprè́,” a hésû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Byacè Jesǔ hé pé̤ èthǐ ná aphè̌ ari-akyǎ nuô, èthǐ thè́gněplǒ lahyǎ to. ");
INSERT INTO kyu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dố èthǐ thè́gněplǒto akhu-akhyě Byacè Jesǔ hé èthǐ, “Shyé꤮ thǐ mṳ̂̌thyěhtya prè̤lu aphúkhǔ má̤ vǎyě dố krusu díkè hihtûlo̤ akhè̌pǎnuô, thǐ ki thè́gněno ná vǎ ma kayǎ dố vǎ hésoluô̌ htuô̌pé̤hò́ thǐ nuôtôprè̤ pǎ. Htuô̌to thǐ ki thè́gněhyǎ ná vǎ me̤ cṳ́꤮ dû vǎ thè́plò má̤to, rò vǎ hébèprè́ tè̤ dố vǎphè̌ ithyóithya vǎ nuôtahe prè́ nuô thǐ thè́gnědû pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Htuô̌rò prè̤ dố a nò̌hyǎ vǎ yětôprè̤nuô, a okuô̌ ná vǎ. Vǎ me̤tǒ lǔthè́plò pwǒ̤꤮ tôphuố cò́ akhu-akhyě a vǐkyǎ vǎ to.” ");
INSERT INTO kyu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bí ǔ ní̤huô̌ a hé phúyě akhè̌nuô, ǔ zṳ̂́enyá̤e è́nyacò́ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Byacè Jesǔ hé Judaphú dố a zṳ̂́enyá̤e lǔ nuôtahe, “Ki thǐ cṳ̌e pṳ̂́maní̤ vǎ tè̤ithyóithya yětahe hénuôma, thǐ htwǒhò́ vǎ khǒpacè̤̌ dố a tǎ̤te̤ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Rò thǐ ki thè́gně tè̤má̤tè̤cò́ pǎ. Rò tè̤má̤tè̤cò́ ki plwǒhte thǐ pǎ,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Èthǐ hésû lǔ, “Pè̤ ma Abraham aklwǐalyǎ tahe, pè̤ cuốhtwǒnò́ ná ǔcṳ̂́ tôphuố꤮ to. Nè̤ cuố hé tuố̤ ná tè̤má̤tè̤cò́ ki plwǒhte thǐ pǎ, phúnuô phútě?” Èthǐ sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Rò Byacè Jesǔ hésû èthǐ, “Vǎ hécò́cò́ thǐ, lò̌꤮ kayǎ dố a me̤ tè̤thû́ nuôtahe ma a htwǒhò́ tè̤thû́ acṳ̂́hò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cṳ̂́ hénuôma, a ocû̌ tố̤kuô̌ ná hibyacè nuôma aní̤ to. Manárò phúprè̤khǔ tôprè̤ hénuôma, a ocû̌ tố̤kuô̌ ná hiphúphyǎphú tacṳ́prè̤. ");
INSERT INTO kyu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Phúnuôrò Cò́marya aphúkhǔ má̤ vǎyě ki ilyě plwǒhtekyǎ hò́ thǐ ná tè̤thû́tè̤ora yě hénuô, thǐ ní̤bèhò́ tè̤palǎ má̤lakǒ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Thǐ htwǒ Abraham aklwǐalyǎ nuôma vǎ thè́gně prè́. Manárò vǎ ithyó thǐ rò thǐ khǎlèkǔ okuô̌ǔ to akhu-akhyě, thǐ pṳ̌me̤thyě vǎ. ");
INSERT INTO kyu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Vǎ hésoluô̌ pé̤ thǐ phú vǎphè̌ hésoluô̌ pé̤ vǎ nuôtahe. Thǐ kuô̌ke rò, thǐ me̤ phú thǐ ní̤huô̌ dố thǐphè̌ tahenuô a o.” A hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Èthǐ hésû lǔ, “Pè̤phè̌ ma Abraham.” Rò Byacè Jesǔ hésû èthǐ, “Thǐ ki má̤lakǒ Abraham aphú tahe hénuô, thǐ ki me̤ thyáphú è me̤nuô kǒkǒ. ");
INSERT INTO kyu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Vǎ hésoluô̌ pé̤ thǐ ná tè̤má̤tè̤cò́ dố vǎ ní̤huô̌ vǎphè̌ hésopé̤ vǎ nuôtahe tadû́rò thǐ pṳ̌me̤thyě vǎ. Abraham me̤nò́ phúnuô tôphuố꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Thǐ krwǒme̤kuô̌ phú thǐphè̌ shyětò̤́ me̤nuô cò́,” a hé èthǐ phúnuô. Rò èthǐ htésû, “Pè̤phè̌ otû́ Cò́marya tôprè̤꤮ tuô̌. Pè̤muố̤pè̤phè̌ cuốthû́cuốplá lǔ rò aphú o ní̤dyé pè̤ má̤to.” A htésû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Rò Byacè Jesǔ hésû èthǐ, “Thǐphè̌ ki má̤lakǒ Cò́marya hérò thǐ mo̤ní̤kǔ vǎ kǒkǒ, me̤těhérò vǎ o dố lǔo hyǎ rò khǒnyá̤yě vǎ hyǎo bíyěprè́yě. Vǎ hyǎ cṳ́꤮ dû vǎ thè́plò má̤to, vǎphè̌ nò̌hyǎ vǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Vǎ hé pé̤ thǐ rò thǐ cuố thè́gněplǒ cò́ taki꤮ to rò ma a me̤ cò́ phútě? Thǐ thè́gněplǒ to mame̤těhérò thǐ thè́zṳ̂́ ní̤dǎ cò́nyǎ vǎngó̤ taki꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Thǐphè̌ ma khǐnéricyá̤ khuklò́ dố ǔ è́ ná Satan nuôtôduô̌ hò́. Thǐ thè́zṳ̂́ krwǒme̤kuô̌ phú thǐphè̌ a tè̤thè́zṳ̂́ nuôprè́. Thǐphè̌ ma a htwǒ prè̤me̤thyě kayǎ dố kalúkhè̌ pǎ cò́. Tè̤má̤tè̤cò́ o dố lǔkǔ to akhu-akhyě, a ní̤dǎ krwǒme̤ kuô̌ǔ tè̤má̤tè̤cò́ to. Bí a hébè akhè̌nuô, a tè̤lahǒlahya tahe nuôma a htwǒ hò́ lǔ lé̤klǒ hò́. È ma kayǎ lahǒlahya tôprè̤ rò a htwǒ hò́ lò̌꤮ tè̤lahǒlahya tahe aphè̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Me̤těhérò vǎ yǒ hébè pé̤ thǐ tè̤má̤tè̤cò́ akhu-akhyě, thǐ zṳ̂́e to. ");
INSERT INTO kyu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Vǎ me̤tè̤ nuôma a thû́prè́ a hé rò a zṳ̌bè́ nuôma dố thǐklè̌ nuô a otôprè̤prè̤ è̌? Vǎ ki hébètè̤ dố amá̤acò́ taheprè́ kihérò mame̤tě rò thǐ zṳ̂́e vǎ to. ");
INSERT INTO kyu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Cò́marya aphúalye̤ tahe nuôma a thè́krṳ̂̌thè́lò̌ ní̤dǎ Cò́marya angó̤. Manárò thǐ ma Cò́marya phúmòphúkhǔ tahe má̤to akhu-akhyě, thǐ ní̤dǎ lǔngó̤ to.” ");
INSERT INTO kyu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Phúnuôrò Judaphú tahe hé Byacè Jesǔ, “Pè̤ hé nè̤, nè̤ ma Samariaphú tôprè̤, htuô̌rò khǐné me̤bè nè̤, pè̤ héphúnuô ma amá̤nyǎto è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Rò Byacè Jesǔ hésû èthǐ, “Khǐné me̤bè vǎ má̤to, vǎ bedubehtǔ vǎphè̌ rò thǐ bedubehtǔ vǎ to. ");
INSERT INTO kyu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Vǎ thè́zṳ̂́ nò̌htuthè́ ǔ ná vǎné̤ phúnuô má̤to. Manárò Cò́marya ma prè̤ dố a thè́zṳ̂́ htuthè́ní̤ vǎ. Prè̤ dố a ki cirya ǔ pǎnuôma è hò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Vǎ hécò́cò́ thǐ, kayǎ tôprè̤prè̤ ki a cṳ̌e ní̤dǎ vǎngó̤ hénuô, a thyěpǎ takhyá꤮ to,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judaphú tahe hé lǔ, “Khǒnyá̤rò pè̤ thè́gně tǎ̤te̤hò́ ná khǐné me̤bè nè̤ hò́. Abraham thyěhtuô̌hò́, prè̤pro̤ tahe꤮ ma a thyě htuô̌hò́hò́. Manárò nè̤ cuốhétuố̤ ná kayǎ tôprè̤prè̤ ki cṳ̌e ní̤dǎ vǎngó̤ hénuô, a thyěpǎ takhyá꤮ to, nè̤ hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ma nè̤ duklò̌nyǎ ná pè̤phè̌ Abraham è̌? È thyě htuô̌hò́, prè̤pro̤ tahe꤮ ma a thyě htuô̌hò́hò́. Nè̤ tane̤ ní̤dyé nè̤né̤ ná ǔpě?” Èthǐ hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Rò Byacè Jesǔ héka̤khyěsû èthǐ, “Vǎ ki htuthè́ ní̤dyé vǎné̤ kihérò vǎ tè̤htuthè́ yěnuô, lé̤zṳ̂́e thè́lè̤ní̤ ná tôcô꤮ to. Vǎphè̌ dố thǐ hé ní̤dyé ná thǐ Cò́marya yětôprè̤nuô, è ma prè̤me̤lǐ me̤takhè̌ vǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Thǐ thè́gně lǔ to tadû́rò vǎ thè́gně lǔ. Ki vǎ hé ná vǎ thè́gněnò́ lǔ to hérò, vǎ htwǒ kayǎ lahǒlahya thyáná thǐnuô hò́. Vǎ thè́gně tǎ̤te̤ cò́ è rò vǎ ní̤dǎ lǔngó̤. ");
INSERT INTO kyu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Thǐphè̌ Abraham thè́luố̤ myáhtye dố vǎ ki hyǎ dố hekhu yě. A myáhtyehò́ rò a thè́krṳ̂̌thè́lò̌ hò́,” a hésû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Rò Judaphú tahe hé lǔ, “Nanyǎ̤shyě꤮ rò nè̤ bǎ híto rò nè̤ cuố myáhtyenò́ Abraham phútě?” ");
INSERT INTO kyu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Rò Byacè Jesǔ hésû èthǐ, “Vǎ hécò́cò́ thǐ, Abraham ohíto akhè̌, vǎ one ré̤ htuô̌dû hò́,” a hésû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yětôphuốrò èthǐ ihtuô lahyǎ lò̤́ rò a kíré̤ tá̤thyě lahyǎ ná Byacè Jesǔ. Manárò Byacè Jesǔ cuố tadwǒuốbíkyǎ ané̤ rò a htecuốmé̤kyǎ bí tè̤lǔtyǎ hǒkǔnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Bí Byacè Jesǔ cuố dố klyálo̤ akhè̌, a myáhtye kayǎphè̌ mèthèkhí dố a muố̤hò́kǔ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A khǒpacè̤̌ tahe sudyǎ lǔ, “Thárá, kayǎphè̌ yětôprè̤ cuố mèthèkhí pǎ cò́ dố a muố̤hò́kǔ ma, dố ètè̤thû́ khukhyě è̌, má̤toròma, dố amuố̤aphè̌ tè̤thû́ khukhyě è̌?” A khǒpacè̤̌ tahe sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Rò a hésû, “A tè̤thû́ má̤toto, amuố̤aphè̌ tè̤thû́ má̤toto. Manárò thyáphú Cò́marya a tè̤pro̤tè̤prya̤ ki oluô̌htya dố è tè̤ohtwǒprè̤ akǔ rò a khí prè́. ");
INSERT INTO kyu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dǎ mò̤́khí híto nuô, pè̤ bè me̤ pé̤ prè̤ dố a nò̌hyǎ vǎ yětôprè̤ atè̤me̤. Mò̤́khí rò ǔ me̤cyá̤ pǎ tôprè̤꤮ to nuô, a ki hyǎtuố̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bí vǎ opǎ bí hekhuyě akhè̌nuô, vǎ ma hekhu atè̤lǐ rò a dyé ǔ tè̤thè́khuthè́gně dốthudốthè́ tôkyě tôprè̤ hò́,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","A héhtuô̌ phúnuô rò, a htuplátǎ̤ apli̤htyě dố hekhu rò a nícò́pè́ he ná apli̤htyě rò a kírè̤̌ dố kayǎphè̌ yětôprè̤ a mèthèplò lo̤. ");
INSERT INTO kyu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Rò a hé kayǎphè̌ mèthèkhí yětôprè̤, “Cuốmò̌, cuố plè̤́plǐkyǎ nè̤ mèthèyě dố Siloa htyěò nuô ní꤮” (Siloa angó̤lasá ma “nò̌cuố”). Yětôphuốrò kayǎphè̌ yětôprè̤ cuố plè̤́plǐkyǎ htuô̌ amèthè, rò a ka̤ akhè̌nuô, a mèthè lǐ hyǎ. ");
INSERT INTO kyu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Rò ahi khǎsò̌khǎshyé tahe ná kayǎ dố a myáhtyenò́ lǔ kwǐesè tahenuô, a sudyǎ ní̤dyé lǔ tôprè̤ htuô̌ tôprè̤, “Kayǎphè̌ mèthèkhí onyǎ kwǐesè nuôtôprè̤ ma èhò́ è̌?” A hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Rò tahehe nuô, a hé lahyǎ, “È hò́nuô̌.” Tahehe rò a hé lahyǎ, “È má̤to, a cô ná è phúnuôprè́,” ǔ hé lahyǎ phúnuô. Manárò ané̤byacè ní̤dû rò, a hé sò̌kadố ní̤dyé ané̤, “A kwǐesè nuôtôprè̤ ma vǎhò́,” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Rò nè̤ cuố mèthèlǐ ka̤khyě cyá̤ khyěthyá phútě?” Èthǐ sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Jesǔ hé nuôtôprè̤ nícò́pè́ hemû rò a kírè̤̌ dố vǎ mèthèplòlo̤. Rò a nò̌cuố plè̤́plǐkyǎ vǎ dố Siloa htyěò. Vǎ cuố plè̤́plǐkyǎ htuô̌ rò vǎ ka̤ akhè̌nuô, a lǐhyǎ pé̤ vǎ,” a hé pé̤ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Khǒnyá̤rò kayǎ nuôtôprè̤ obítě?” Èthǐ sudyǎ lǔ, rò. “Vǎ thè́gněto,” a hésû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Èthǐ è́cuố kayǎ mèthèkhínò́ tôphuố nuôtôprè̤ dố Pharisěophú tahe a o. ");
INSERT INTO kyu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bí Byacè Jesǔ nícò́pè́ hemû rò a me̤lǐka̤ kayǎphè̌ mèthèkhí nuôtôprè̤ ma a yǒ tǎ̤tǒ ná Mò̤́nyěduô nuôtônyě. ");
INSERT INTO kyu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Rò Pharisěophú tahe cuố sudyǎkuô̌ lahyǎ è ná a cuố mèthèlǐ ka̤ phútě nuô ari-akyǎ. Rò a hé pé̤ Pharisěophú tahe, “A kírè̤̌ paá dố vǎ mèthèplòlo̤ rò bí vǎ cuố plè̤́plǐkyǎ htuô̌ lǔ nuô vǎ mèthèlǐ ka̤khyě,” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharisěophú tahe hé, “È ma a o dố Cò́marya a o hyǎ má̤to, me̤těhérò a duô kuô̌ǔ Mò̤́nyěduô to nuô̌꤮.” Manárò tahehenuô a hé lahyǎ, “Prè̤oraphú tôprè̤ cuốme̤ cyá̤ tuố̤ tè̤pro̤tè̤prya̤ phúyě tahe phútě?” Phúnuôrò èthǐ thè́plò lṳkhó lò̌khyělǔ tômṳ ná tômṳ. ");
INSERT INTO kyu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dốkhyě rò èthǐ sudyǎ khyěthyá kayǎphè̌ mèthèkhínò́ tôphuố yětôprè̤, “È me̤ lǐ ka̤hò́ nè̤ mèthè hò́, phúnuôrò nè̤ ki hé è ná è ma a htwǒ kayǎ phútě tôprè̤ tě?” Rò a hésû èthǐ, “È ma prè̤pro̤ tôprè̤,” a hésû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","È ma mèthèkhínò́ htuô̌tôphuố rò khǒnyá̤yě a lǐ ka̤khyě nuô, Pharisěophú tahe zṳ̂́e nyǎ hí lǔ toto, rò a nò̌cuố è́ ke ǔ ná amuố̤aphè̌. ");
INSERT INTO kyu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Rò èthǐ sudyǎ amuố̤aphè̌, “Yěma thǐphú dố thǐ hé ní̤dyé è ná a mèthèkhí pǎ cò́ dố muố̤hò́kǔ nuôtôprè̤ è̌? Khǒnyá̤rò a cuố mèthèlǐ ka̤khyě cyá̤ phútě?” A sudyǎ amuố̤aphè̌ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","“È ma pè̤phú má̤lakǒ ni. A mèthèkhí má̤lakǒ pǎnyǎ dố muố̤hò́kǔ ni. ");
INSERT INTO kyu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Manárò khǒnyá̤yě, a mèthè lǐka̤khyě phútě, maǔpě me̤lǐ ka̤khyě pé̤ lǔ pě nuô pè̤ thè́gněto. Sudyǎ myádû ènuô. A dutǎ̤thè́né̤te̤ hò́. A hésûplǒ hésûphè́ cyá̤ ní̤dyéhò́ ané̤hò́,” èthǐ hésû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bínuôkhè̌ nuô, Judaphú khuklò́khuklyǎ tahe thè́plò sukǔ lò̌ lǔ, kayǎ tôprè̤prè̤ dǎhéhò́ ná Jesǔ ma Messia hénuôma, èthǐ vè̤́htekyǎ cò́ kayǎ dố a hé phúnuô tôprè̤ dố tè̤cò́bè̌ hǒklò̌ akhu-akhyě, amuố̤aphè̌ tahe thè́isě Judaphú khuklò́khuklyǎ tahe alé̤ rò, a hé lahyǎ ná pè̤ thè́gněkuô̌ to, a hé phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tû́rò amuố̤aphè̌ hé, “Sudyǎdû lǔ nuô, a dutǎ̤thè́né̤te̤ hò́,” a hé phúnuôma dố tè̤ritè̤kyǎ yě akhu-akhyě hò́. ");
INSERT INTO kyu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pharisěophú tahe è́hyǎ khyěthyá kayǎ mèthèkhínò́ yětôprè̤ rò èthǐ hé lǔ, “Ò́lya̤cò́cò́ dố Cò́marya anyěhyǎ nuô, pè̤ thè́gně ná kayǎ me̤lǐka̤ nè̤ mèthè nuôtôprè̤ ma prè̤ora-othyǎphú prè́,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Rò a hésû èthǐ, “Prè̤ora-othyǎphú má̤ è̌, má̤to è̌ nuô vǎ thè́gně to. Vǎ thè́gně prè́tû́ dố aré̤khè̌ vǎ mèthèkhí, khǒnyá̤rò vǎ mèthèlǐ hò́ yěnuô prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Htuô̌rò “È me̤kryá꤮ pé̤ nè̤ phútě? A me̤ lǐka̤ pé̤ nè̤ phútě?” Èthǐ sudyǎ khyěthyá lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Vǎ hé pé̤htuô̌hò́ thǐ rò thǐ ní̤dǎ to. Thǐ thè́zṳ̂́ ní̤huô̌ khyěthyá me̤tě? Thǐ thè́zṳ̂́ htwǒka̤kuô̌ a khǒpacè̤̌ è̌?” A hésû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yětôphuốrò, èthǐ thè́plòdu, hé takhwótakè lǔ, “Nè̤ ma èkhǒpacè̤̌. Pè̤ ma Mosè a khǒpacè̤̌ dû,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Cò́marya hébè ná Mosè mú꤮ nukhè̌ nuôma pè̤ thè́gně. Manárò kayǎ yětôprè̤, a otǒ bítěhyǎ nuô pè̤ thè́gněnò́ cò́ taki꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kayǎphè̌ yětôprè̤ hésû ka̤khyě pó̤ èthǐ, “Kayǎ yětôprè̤ a me̤lǐ ka̤khyě cyá̤ cò́ vǎ mèthèplò cò́ rò, a otǒ bítěhyǎ nuô pè̤ thè́gněto thǐ cuốhé tôkuôrò a tapa̤-ihû́ cò́nyǎ vǎhò́. ");
INSERT INTO kyu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Prè̤oraphú kwǐ tè̤me̤cwó̤ nuô, Cò́marya ní̤dǎ to nuôma pè̤ thè́gně. A ní̤dǎprè́ tû́ kayǎ dố a zṳ̂́e lǔ rò a me̤tǒ lǔthè́plò nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ǔ me̤lǐ ka̤ cyá̤ kayǎ mèthèkhí dố muố̤hò́kǔ nuô dố hekhu htwǒlú mò́khu htwǒthè̌ tuố̤khǒnyá̤ nuô pè̤ ní̤huô̌nò́ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kayǎ yětôprè̤ a odố Cò́marya a ohyǎ kimá̤to hénuôma, a me̤cyá̤ tôcô꤮ to,” a hé ka̤khyěsû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pharisěophú tahe hésû ka̤khyě lǔ, “Nè̤ tè̤thû́tè̤ora dupǎ cò́ dố nè̤ opacè̤̌lya̤ akhè̌ rò nè̤ cuố ithyó ka̤khyě pé̤ pè̤ phútě?” A hé lǔ phúnuôrò a vè̤́htekyǎ lǔ dố tè̤cò́bè̌ hǒklò̌. ");
INSERT INTO kyu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bí Jesǔ ní̤huô̌ ná ǔ vè̤́htekyǎhò́ kayǎ mèthèkhí yětôprè̤ akhè̌nuô, Byacè Jesǔ cuốpṳ̌ myáhtye lǔ rò a hé lǔ, “Nè̤ zṳ̂́e prè̤lukayǎ aphúkhǔ è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Rò a hésû Jesǔ, “Thárá, è ma ǔpě? Thyáphú vǎ ki zṳ̂́e è rò héluô̌ pé̤ vǎ,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Byacè Jesǔ hé lǔ, “Nè̤ myáhtye htuô̌hò́ è hò́. Nè̤ hébè lǔ khǒnyá̤ yětôprè̤ nuôma è hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Rò kayǎ yětôprè̤ hé lǔ, “Byacè, vǎ zṳ̂́e hò́,” a hé rò a dángṳ̂lya̤ cò́bè̌htya Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Rò Byacè Jesǔ hé lǔ, “Thyáphú prè̤lu hekhuphú tahe ki myáhtye lya̤ ní̤dyé atè̤thû́ agněnuôrò, vǎ hyǎlya̤ dố hekhuyě hò́. Kayǎ dố athyáná kayǎ mèthèkhí rò a thè́gněkuô̌ Cò́marya a tè̤má̤tè̤cò́ to tahenuô, vǎ ki me̤lǐ ka̤ èthǐ mèthè pǎ. Manárò kayǎ dố a hé lya̤ ní̤dyé ané̤ ná vǎ thè́gně htuô̌hò́ Cò́marya a tè̤má̤tè̤cò́ tahenuô, a ki htwǒ thyáná kayǎ mèthèkhí nuôtahe pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pharisěophú dố a o lahyǎ bínuô tahe ní̤huô̌ a hé phúyě rò a sudyǎ Jesǔ, “Nè̤ thè́ hé pè̤ ná pè̤ mèthèkhí kuô̌ phúnuô è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Rò Byacè Jesǔ hé èthǐ, “Thǐ ki mèthèkhí kihérò thǐ thè́gně tǎ̤te̤hí tè̤má̤tè̤cò́ to akhu-akhyě thǐ tè̤thû́ oto. Manárò khǒnyá̤yě thǐ hé ná thǐ mèthèlǐ akhu-akhyě, thǐ tè̤thû́o,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Byacè Jesǔ hékhongó̤, “Vǎ hécò́cò́ thǐ, kayǎ dố a hyǎnuô̌tǒ dố thímípo̤ a kadǎkǔ to tôprè̤prè̤, rò a ki hyǎhtya nuô̌bè́ dố aruô tôphopho hénuôma, prè̤ehuôehí, prè̤pṳ̂́phe zè́plè́e ǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Manárò kayǎ dố a hyǎ nuô̌tǒ dố kadǎkǔyě tôprè̤prè̤ nuôma prè̤kyě̤thímí má̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Prè̤opò̤́ kadǎkǔ yětôprè̤nuô, a ki bámǒsû pé̤ prè̤kyě̤thímí yětôprè̤ kadǎkǔ pǎ. Thímí tahe ní̤dǎ thè́gně lǔngó̤. Rò a è́hte ní̤dyé athímí tahe tôduô̌ ná amwi̤ tôcô, tôduô̌ ná amwi̤ tôcô dố apo̤klò̌ rò athímí tahe krwǒkuô̌ lò̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Athímí tahe yǒ tǒ̤ní̤ dyé lǔngó̤ akhu-akhyě, bí a è́hte htuô̌lò̌ hò́ athímí tahe dố apo̤klò̌ akhè̌nuô, è rò a cuố ré̤ dố nyě, athímí tahe rò a krwǒkuô̌ lò̌ lǔkhyě. ");
INSERT INTO kyu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Thímí yětahenuô, a krwǒkuô̌ kayǎ dố aruôtahe akhyěto, me̤těhérò èthǐ ní̤huô̌nò́ lǔngó̤ to, a thè́gněnò́ lǔ to akhu-akhyě, a klya taphǎkyǎ lò̌꤮ kayǎ dố aruô tahe alé̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Byacè Jesǔ dônyǎ pé̤ èthǐ ngó̤khákho yětôtó̤ tadû́rò èthǐ thè́gněplǒ lahyǎ angó̤lasá to. ");
INSERT INTO kyu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Phúnuô akhu-akhyě, Jesǔ hé khyěthyá, “Vǎ hécò́cò́ thǐ, vǎ ma thímípo̤ a kadǎkǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Lò̌꤮ kayǎ dố a hyǎ ré̤ dố vǎnyěhyǎ nuôtahe ma, prè̤ehuôehí, prè̤pṳ̂́phe zè́plè́e ǔ tahe prè́. Rò thímí tahe ní̤dǎ èthǐ ngó̤ to. ");
INSERT INTO kyu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Vǎ ma kadǎkǔ hò́. Lò̌꤮ kayǎ dố a hyǎnuô̌ dǐtû́ ná vǎ dố a má̤dû kadǎkǔ yětahe nuô, a ki ní̤bè tè̤me̤lwóhteka̤ pǎ. A ki hyǎhte hyǎnuô̌ rò a ki myáhtye a lé̤esè akhǎlé̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Prè̤ehuônuô a hyǎme̤tě hénuôma, thyáphú a ki hyǎ ehuôehí ní̤, a ki hyǎ me̤thyění̤ ǔ, a ki hyǎ me̤pyéme̤kyǎ ǔ agněprè́. Vǎ rò thyáphú ǔ ki ní̤ tè̤htwǒprè̤ htuô̌to thyáphú ǔ tè̤ohtwǒprè̤ ki lốbǎ tǎ̤pòtǎ̤pè̤̌ agně nuôrò vǎ hyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Vǎ ma prè̤kyě̤thímí dố aryá tôprè̤. Prè̤kyě̤thímí dố aryá tôprè̤nuô a dyélya̤kyǎ athè́plò htwǒprè̤ dố thímí tahe agně. ");
INSERT INTO kyu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ki dakèkyě̤e thímí ná ǔ hénuôma, thímí yětahenuô atè̤ má̤to akhu-akhyě, bí a myáhtye htwimi̤ hyǎ akhè̌, a dyakyǎ thímí rò a hteklyakyǎ prè́. Rò htwimi̤yě ki hyǎ a̤thyě pṳ̂́ekyǎ thímí pǎ, rò a hyǎ me̤ klyapruố klyapryǎkyǎ lò̌ thímí pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Prè̤ dakèkyě̤e thímí yětôprè̤nuô, a hteklya taphǎkyǎ, me̤těhérò a mo̤ ní̤dyé thímí yětahe to. ");
INSERT INTO kyu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Vǎ ma prè̤kyě̤thímí dố aryá tôprè̤. Vǎ thè́gně vǎ thímí rò vǎ thímí thè́gně vǎ. ");
INSERT INTO kyu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Athyáná nuôhò́, vǎphè̌ thè́gně vǎ rò vǎ thè́gně vǎphè̌, rò vǎ dyélya̤kyǎ vǎ thè́plò dố vǎ thímí tahe agně. ");
INSERT INTO kyu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Vǎ thímí dố aruô dố a o bí apo̤kǔ yětonuô a opǎ tahe. Vǎ bè è́ka̤ kuô̌ èthǐ pǎ. Èthǐ ki ní̤dǎkuô̌ vǎ ngó̤ pǎ, rò èthǐ ki ka̤ htwǒ tố̤ lò̌ lǔ thímí tômṳtuô̌, prè̤kyě̤thímí a Byacè tôprè̤꤮ tuô̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Vǎphè̌ mo̤ní̤ vǎ me̤těhérò thyáphú vǎ ki htwǒprè̤ ka̤khyě khyěthyá nuô, vǎ dyélya̤kyǎ vǎ thè́plò htwǒprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Vǎ ki nò̌me̤thyě ǔ ná vǎné̤ to hénuô, ǔ me̤thyě cyá̤ vǎ tôprè̤꤮ to. Vǎ dyélya̤kyǎ vǎ thè́plò yěnuôma, ǔ nò̌shyo vǎ tôprè̤꤮ to, vǎ thè́plò ná vǎ thè́plò dyélya̤ ní̤dyédû prè́. Vǎ o ná vǎ tè̤pro̤tè̤prya̤ dố vǎ thè́zṳ̂́ dyélya̤kyǎ vǎthè́ ma a ní̤ní̤, vǎ thè́zṳ̂́ phyédwókhyě è ma꤮ a ní̤ní̤ prè́. Vǎphè̌ mehyǎní̤ vǎ ngó̤ ná vǎ bème̤ phúyě,” a hé pé̤ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Dố a hébè phúnuô akhu-akhyě, Judaphú tahe lṳkhókyǎ khyělǔ nyě̤mṳ. ");
INSERT INTO kyu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kayǎ è́prè̤ hé, “È ma khǐné me̤bè lǔ rò a tamwǐ prè́. Cuố ní̤dǎ tuố̤ lǔngó̤ me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Manárò dố aruô tahenuô a hé kuô̌ke, “Khǐné me̤bè kayǎnuô a hébè me̤phúyě to. Khǐné me̤lǐka̤ cyá̤ nyǎ ǔmèthè è̌?” A hé lahyǎ phúnuô tahe. ");
INSERT INTO kyu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Bínuôkhè̌ dố vǐ̤ Jerusalem akǔnuô, a tǒná Judaphú thǐtahe me̤ pwè̌ tôpwè̌ dố ǔ è́ ná tè̤thè́né̤htya ka̤khyě tè̤be sǎsè̌ tè̤lǔhǒdu mú꤮ nukhè̌ nuô, a o tôpwè̌. ");
INSERT INTO kyu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Bínuôkhè̌ a tǒná ké̤ró̤khè̌ rò Jesǔ o bí tè̤lǔtyǎ hǒkǔnuô rò a cuốrwó bí khǎlé̤ tôpho dố ǔ è́ ná Khwí Solomo hidǎkuố nuôtôpho alè̤̌. ");
INSERT INTO kyu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judaphú tahe hyǎ oplu tava̤lò̌ lǔ rò a hé lǔ, “Nè̤ ma ǔpě nuô nè̤ hésoluô̌pé̤ pé̤ pè̤ tôphuố꤮ to, nè̤ nò̌opò̤́ myásû̌ nyě̤pó̤ pǎ cò́ pè̤ bá꤮ tě pǎ cò́? Nè̤ ki má̤lakǒ Krístu hérò hésoluô̌ pé̤ pè̤,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","“Vǎ héhtuô̌ pé̤ hò́ thǐ rò thǐ zṳ̂́eto. Tè̤pro̤tè̤prya̤ dố vǎ me̤ ná vǎphè̌ amwi̤ tahenuô, a hébè pé̤hò́ dố vǎgně hò́. ");
INSERT INTO kyu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Manárò thǐ yǒ htwǒ vǎ thímí má̤to akhu-akhyě, thǐ zṳ̂́e vǎ to. ");
INSERT INTO kyu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Vǎ thímí tahe nuôma a ní̤dǎ vǎ ngó̤. Vǎ thè́gně èthǐ, rò èthǐ krwǒ vǎkhyě. ");
INSERT INTO kyu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Vǎ dyé èthǐ thè́htwǒprè̤ tacṳ́prè̤. A ki thyě pǎ tôphuố꤮ to. Ǔ hyǎ cwihte cyá̤ pǎ èthǐ dố vǎ takhukǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Vǎphè̌ yěnuô aduklò̌ cò́ ná ǔ pwǒ̤꤮ tôprè̤. Thímí yětahe nuôma è dyé vǎ rò ǔ hyǎ cwihtekyǎ cyá̤ pǎ èthǐ dố vǎ phè̌ a takhukǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Vǎ ná vǎphè̌ ma tôprè̤꤮ tuô̌ prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Judaphú tahe ihtuôlya̤ khyěthyá lahyǎ lò̤́ rò kíré̤ tá̤thyě lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Manárò Byacè Jesǔ hé èthǐ, “Tè̤me̤ryá dố vǎphè̌ nò̌me̤ vǎ tahenuô, vǎ dyéluô̌ è́꤮ pé̤lǎhò́ thǐ hò́. Manárò thǐ kíré̤ tá̤tuố̤ vǎ ná vǎ me̤ tè̤ryá yětahe bítě tôcôtě?” A hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“Dố nè̤ tè̤me̤ryá yětahe akhu-akhyěrò pè̤ kíré̤ tá̤ nè̤ ná lò̤́ má̤to. Nè̤ yǒ hébèthû́ Cò́marya yěnuô prè́, me̤těhérò nè̤ htwǒ prè́ prè̤lu hekhuphú tôprè̤prè́ rò nè̤ cuố dákwó lya̤ ní̤dyé cò́ nè̤né̤ ná Cò́marya,” èthǐ hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Rò Byacè Jesǔ hésû èthǐ, “Dố thǐ tè̤thyótè̤thya akǔ nuô, a rǎo tômǎ̤, ‘Vǎ hé ná thǐ ma cò́marya tahe,’ a hé phúnuô vǎhéto? ");
INSERT INTO kyu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cò́marya alǎ̤angó̤ nuôma atǒabè tacṳ́prè̤ cò́. Ǔ htulya taple cyá̤ lǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Phúnuôrò phè̌ nwóhtya vǎ rò a nò̌hyǎlya̤ vǎ dố hekhuyě. Rò bí vǎ hé, ‘Vǎ ma Cò́marya aphúkhǔ tôprè̤’ akhè̌nuô, thǐ cuố hétuố̤ vǎ ná vǎ héthû́ Cò́marya phútě? ");
INSERT INTO kyu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Vǎ ki me̤tǒ phú vǎphè̌ me̤nuô to hérò zṳ̂́e tǎ vǎ tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Manárò ki vǎ me̤hò́ phú vǎphè̌ me̤nuô hérò thǐ ki zṳ̂́e lahyǎ cò́ taki꤮ to hénuô, patítadû rò thǐ tǒkò zṳ̂́e sálé̤ lahyǎ tè̤ dố vǎ me̤ tè̤pro̤tè̤prya̤ nuôtahe. Thǐ ki zṳ̂́e vǎ tè̤me̤ tahe hérò thǐ ki thè́gněhyǎ ná phè̌o dố vǎkǔ rò vǎ odố èkǔ pǎ,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Èthǐ thè́zṳ̂́ pṳ̂́ lǔ tadû́rò a htecuố taphǎkyǎ èthǐlé̤. ");
INSERT INTO kyu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Byacè Jesǔ ka̤khyě khyěthyá dố Jordano htyěklǒ bè́rè̤̌ tôkyě, bí Giovanni lé̤plwǒ ré̤lố pé̤ ǔ htyě akhǎlé̤ nuôtôpho, rò a ka̤-o bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kayǎ hyǎró̤hyǎè́ nyacò́ dố lǔo. Rò èthǐ hé ní̤dyé khyělǔ tôprè̤ htuô̌ tôprè̤, “Giovanni me̤luô̌ tè̤pro̤tè̤prya̤ tôcô꤮ to tadû́rò lò̌꤮ a hé kayǎ yětôprè̤ ari-akyǎ nuô, atǒ lò̌plǐcò́,” a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kayǎ bínuôtahe zṳ̂́enyá̤e ka̤ è́lǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kayǎmwi̤ ná Lazarú hé yětôprè̤nuô aswí. È ná a vyá̤prè̤mò Maria ná Martha ma a o lahyǎ dố dò̌ Bethania. ");
INSERT INTO kyu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria yětôprè̤ ma má̤hò́ a lyátǎ̤ htyěnuô̤mû́ dố Byacè a khǎduôlo̤ rò a htû́plǐ ná akhuluô̤ nuôtôprè̤ hò́. Lazarú dố aswí yětôprè̤ nuôma a puố̤prè̤khǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A vyá̤prè̤mò yěthè́nyě̤ nò̌cuố héso ǔ ná Jesǔ, rò èthǐ cuố hé Jesǔ, “Byacè, nè̤ khǒbò́thyómo̤ Lazarú thè́swí hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bí Jesǔ ní̤huô̌ tè̤ritè̤kyǎ yě akhè̌nuô, a hé, “Dố tè̤swíyě akhu-akhyě ǔ ki myáhtye Cò́marya alǐ atakhè̌ pǎ. Htuô̌to dố tè̤swíyě akhu-akhyěrò ǔ ki me̤lǐme̤takhè̌ kuô̌dû Cò́marya aphúkhǔ yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesǔ mo̤ní̤ lò̌plǐ Martha ná apuố̤prè̤mò, ná a puố̤prè̤khǔ Lazarú thè́thuô̌lò̌. ");
INSERT INTO kyu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Rò a ní̤huô̌ ná Lazarú swí tadû́rò a o tadû plehyǎpǎ bínuô nyě̤nyě. ");
INSERT INTO kyu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Htuô̌rò a hé a khǒpacè̤̌ tahe, “Pè̤ ka̤ dố Judaké̤ pó꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Manárò a khǒpacè̤̌ tahe hé lǔ, “Thárá, dố pǎnunu꤮ huprè́ rò Judaphú tahe thè́zṳ̂́ pṳ̌ tá̤ nè̤ ná lò̤́ rò nè̤ kíré̤ ka̤khyětǒ khyěthyá èthǐ bínuô ò?” ");
INSERT INTO kyu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesǔ hésû èthǐ, “Tônyě ma a o shyényě̤mû̌ ha vǎhé? Kayǎ tôprè̤prè̤ dố a cuốklyá dố mò̤́sè̌klè̌ yěnuô, a taphò̌ lakhû́ náto, me̤těhérò a yǒ myáhtye hekhu atè̤lǐ nuô̌. ");
INSERT INTO kyu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Manárò kayǎ tôprè̤prè̤ a ki cuố dố mò̤́khí hénuô, a ki taphò̌ lakhû́ pǎ, me̤těhérò a yǒ khí nuô̌.” ");
INSERT INTO kyu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","A héhtuô̌ phúyě rò, a hé plehyǎ pó̤ èthǐ, “Pè̤ khǒbò́thyó Lazarú omyění̤ sǒtapa̤ hò́, manárò vǎ ki cuố hturyǎ̤ ihtò lǔ.” A hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","“A ki omyění̤ sǒtapa̤ prè́ hérò, a omo̤-oryá hyǎkhyě dû pǎ kǒkǒ,” a khǒpacè̤̌ hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesǔ thè́zṳ̂́ hé angó̤lasá ná Lazarú thyě hò́ manárò èthǐ tane̤prè́ ná a omyění̤ phúnuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yětôphuốrò a héluô̌lǐ pé̤ èthǐ, “Lazarú thyěhò́, ");
INSERT INTO kyu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","manárò, vǎ okuô̌ ná Lazarú bínuô to rò vǎ thè́krṳ̂̌ prè́, me̤těhérò dố a htwǒhtya phúyě akhu-akhyě, thǐ tè̤zṳ̂́e vǎ ki duhtya ná duhtya pǎ. Tè̤yětahe htwǒhtya phúyě nuôma, a htwǒhtya dố a ki htwǒbwíhtwǒtaryě dố thǐgně prè́. Phúnuôrò cuố꤮, pè̤ cuốkuô̌ è pó꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomazo dố ǔ è́pó̤ lǔmwi̤ ná Didymo yětôprè̤ hé Jesǔ a khǒpacè̤̌ tahe, “Pè̤ cuốthyě ró̤kuô̌ ná pè̤ Byacè pó!” A hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bí Byacè Jesǔ cuốtuố̤ dố dò̌ Bethania akhè̌nuô, ǔ iluố Lazarú nuô a ohò́ lwǐ̤nyě hò́. ");
INSERT INTO kyu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Dò̌ Bethania yě a oye̤ ná vǐ̤ Jerusalem a phû꤮ o nyě̤mile. ");
INSERT INTO kyu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Martha ná Maria yě a puố̤prè̤khǔ thyě akhu-akhyě, ǔ hyǎ ilò̌ èthǐ, ǔ hyǎ okruô̌olè̤ è́kuô̌ lǎ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bí Martha ní̤huô̌ ná Byacè Jesǔ hyǎhò́ akhè̌nuô, a htecuố myásû lǔ. Manárò, Maria rò a okyǎ dố hi prè́. ");
INSERT INTO kyu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha hé Byacè Jesǔ Krístu, “Byacè, nè̤ ki okuô̌ ná pè̤ bíyě hénuôma, vǎ puố̤prè̤khǔ thyě cyá̤ ǐtě. ");
INSERT INTO kyu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Manárò, khǒnyá̤yě cò́ bèbè, vǎ thè́gně ná nè̤ kwǐ Cò́marya ǐtětě꤮ nuô, a ki dyé nè̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesǔ hésû lǔ, “Nè̤puố̤ ki htwǒprè̤ ka̤khyě khyěthyá pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Rò Martha hésû lǔ, “Bí ǔ pwǒ̤꤮ tôprè̤ ihtòka̤khyě lò̌ dố tè̤thyě dố khyělố tônyě pǎnuô, è ki thyěihtò ka̤kuô̌ pǎnuô vǎ thè́gně prè́,” a hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Byacè Jesǔ hé lǔ, “Vǎ ma prè̤ dố a me̤htwǒprè̤ ka̤khyě kayǎthyě tahe. Vǎ ma prè̤ dố a dyé ǔ thè́htwǒprè̤. Kayǎ dố a zṳ̂́e vǎ tahenuô, a thyě cò́ tadû́rò a ki htwǒprè̤ ka̤khyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Me̤těhérò kayǎ dố a zṳ̂́e vǎ tahenuô, a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ pǎ, a thyěpǎ tôphuố꤮ to. Vǎ héyě nè̤ zṳ̂́e è̌, Martha?” ");
INSERT INTO kyu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Ò, vǎ zṳ̂́e vǎ, Byacè,” a hésû phúnuô. “Vǎ zṳ̂́e má̤lakǒ cò́ ná nè̤ ma Messia má̤hò́ Cò́marya a phúprè̤khǔ dố a kíré̤ hyǎ dố hekhu yětôprè̤ nuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha héhtuô̌ phúnuôrò a ka̤ dố apuố̤ Maria o rò a ka̤ hébèhuô lǔ, “Thárá hyǎtuố̤ bíyě hò́, rò a sudyǎ ní̤dyé nè̤.” ");
INSERT INTO kyu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria ní̤huô̌ rò a tapluố̤taplyě htecuốtǒ Byacè Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Manárò bínuô akhè̌nuô, Jesǔ nuô̌hí dố dò̌kǔ to. A opǎprè́ bí Martha lé̤cuố myáhtye tǎ̤sû lǔ nuôtôpho prè́. ");
INSERT INTO kyu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bí Judaphú dố a hyǎ okruô̌olè̤, a hyǎ ilò̌ Maria thǐtahe myáhtye ná Maria ihtò htecuố tapluố̤taplyě akhè̌, èthǐ krwǒcuốkuô̌ lǔkhyě. Èthǐ tane̤ ná a kíré̤ hyǎnguố̤ dố luô̤̌khu. ");
INSERT INTO kyu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bí Maria cuốmyáhtye ná Jesǔ akhè̌nuô, a hyǎdángṳ̂lya̤ dố lǔkhǎduô khǎshyé rò a hé lǔ, “Byacè꤮ ki nè̤ okuô̌ ná pè̤ bíyě hénuôma, vǎ puố̤prè̤khǔ thyě cyá̤ ǐtě?” ");
INSERT INTO kyu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Bí Jesǔ myáhtye Maria ná Judaphú dố a krwǒ hyǎkuô̌ lǔ tahe nguố̤ akhè̌nuô, a thè́plè̤̌, a thè́muố̤ rò a thè́plòmo̤to. ");
INSERT INTO kyu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A sudyǎ èthǐ, “Thǐ cuố iluốtǒ lǔ bítě?” Rò èthǐ hésû lǔ, “Byacè, hyǎmyámò̌.” ");
INSERT INTO kyu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Rò Jesǔ nguố̤. ");
INSERT INTO kyu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Rò Judaphú tahe hé lahyǎ, “Myámò̌lé, a mo̤ cò́ lǔ bá꤮ těnuô.” ");
INSERT INTO kyu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Manárò tahehe rò a hé, “A me̤ lǐ cyá̤ cò́ ǔmèthè vǎ hé rò a cuố plwǒthyětuố̤ kayǎ yětôprè̤ phútě?” ");
INSERT INTO kyu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesǔ thè́plè̤̌ thè́muố̤ khyěthyá rò a cuốtǒ dố ǔ lé̤iluố nuô̌ lǔ dố lò̤́kǔ yěnuô a o. Luô̤̌kǔ yěnuô ǔ htulò̌bí lǔ ná lò̤́du tômě. ");
INSERT INTO kyu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Rò a hé ǔ, “Htulò̌ taphǎkyǎ lò̤́du yěnuô.” Manárò kayǎthyě yětôprè̤ a vyá̤prè̤mò Martha hésû lǔ, “Byacè, tuố̤khǒnyá̤ yěnuô, a thyě bǎhò́ lwǐ̤nyěhò́. A ki nuô̤thò̌nuô̤myá̤ lò̌hò́,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","“Vǎ héhtuô̌hò́ nè̤, nè̤ ki zṳ̂́e rò nè̤ ki myáhtye Cò́marya a tè̤lǐtè̤takhè̌ pǎ, vǎhéto?” Byacè Jesǔ hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Phúnuôrò èthǐ htulò̌ taphǎkyǎ lò̤́du nuôtômě. Rò Jesǔ tṳ́htya dố mò́lè̤̌ rò a hé, “Kố꤮ Phè̌, nè̤ ní̤dǎ vǎ tè̤kwǐcò́bè̌ akhu-akhyě, vǎ hébwíhétaryě nè̤. ");
INSERT INTO kyu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Vǎ thè́gně ná nè̤ ní̤dǎ vǎ tè̤kwǐcò́bè̌ pwǒ̤꤮ phuố. Manárò vǎ myá dố a ki htwǒbwí htwǒtaryě pé̤ kayǎ dố a ihtò bíyě tahe agně, rò thyáphú èthǐ ki zṳ̂́e ná nè̤ nò̌hyǎ vǎ agněnuôrò, vǎ hé phúyě prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bí Byacè Jesǔ kwǐcò́bè̌ htuô̌nuô, a è́htǒhtya, “Lazarú! Htemò̌!” ");
INSERT INTO kyu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Rò kayǎ thyě yětôprè̤ hte. Atakhu khǎduô tahenuô a talǔoma lò̌pǎ ná ikè̤̌ báplǐ rò amèthè nuô a bo tava̤bí lò̌pǎ ná ikè̤̌. Rò Jesǔ hé èthǐ, “Htulyěkyǎ pé̤ lǔ rò nò̌cuố è nuô.” ");
INSERT INTO kyu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judaphú dố a hyǎ olě kuô̌ Maria tahe myáhtye Jesǔ me̤yě akhu-akhyě a zṳ̂́ka̤nyá̤ka̤ è́lǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Manárò tahehe nuô a cuố dố Pharisěophú tahe a o rò a cuố hésoluô̌ pé̤ èthǐ ná Jesǔ me̤tè̤yě. ");
INSERT INTO kyu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Phúnuôrò bwídukhu tahe ná Pharisěophú tahe è́plò́ Judaphú khuklò́khuklyǎ dố aruô tahe rò okúokyá ní̤dyé lǔ. Rò èthǐ hé, “Pè̤ ki me̤phútě yě? Kayǎ yětôprè̤ me̤luô̌ pé̤ ǔ tè̤pro̤tè̤prya̤ è́lǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Pè̤ ki dya-o tadû è phúyě hénuôma, ǔ zṳ̂́e kuô̌lò̌ lǔ hò́. Htuô̌pǎrò Roma klyěphú tahe ki hyǎ pǎ rò hyǎ me̤pruốkyǎ lò̌ pè̤ tè̤lǔhǒduhǒ, pè̤ myěcôphúphú nyě̤côlò̌ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yětôphuốrò dố èthǐ aklè̌ nuô, kayǎmwi̤ ná Caipha otôprè̤. Bínuô tôna ma a htwǒ bwídukhulố. Rò a héhtya, “Thǐ thè́gně lahyǎ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Dố Judaphú myěcô yětômuố̤ tôcôlò̌ kíré̤pyékíré̤kyǎ lò̌ agněnuô, kayǎ yětôprè̤ ki thyěkyǎ dố Judaphú yětahe agně nuô aryáklò̌ nuôma, thǐ thè́gněto è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A hé phúyě nuôma a hé ní̤dyédû ná a tè̤cyá̤tè̤dè nuômá̤to. Cò́marya nò̌hébè lǔ prè́. Bínuô tôna akǔnuô, è yǒ htwǒ bwídukhulố rò a hépro̤ one ré̤ ná Jesǔ ki thyě dố Juda myěcôphú tahe agně pǎ, phúnuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Htuô̌rò a tè̤hépro̤ yěnuô, a tǒprè́tû́ Jesǔ ki thyě pé̤ dố Judaphú tahe agně nuômá̤to, a ki thyětuố̤ pé̤kuô̌ Cò́marya aphúalye̤ dố a o lahyǎ dố htyěké̤ aruô tahe agněgně. Thyáphú a ki me̤htwǒhtya kayǎ yětahe tômṳtuô̌ pǎ agněnuô, ǔ bè me̤thyě lǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Phúnuôrò, cáhtya bínuô tônyě tǎ̤plehyǎ rò kayǎ htwǒ Judaphú khuklò́khuklyǎ tahenuô, a pṳ̌ kreme̤thyě lahyǎ hò́ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Phúnuôrò, Jesǔ cuố nuô̌lá̤nuô̌lǐ pǎ dố Judaphú tahe aklè̌ to. A cuố okhókyǎ dố ké̤sè̌htyěkya̤ lò̤́tamákhu akhǎshyé khǎlé̤ tôpho. A cuố o ní̤dyé dò̌ yětôdò̌ nuôma ǔ è́ ná dò̌ Ephraim, a cuố otố̤ró̤ kuô̌ ná a khǒpacè̤̌ tahe bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judaphú pwè̌ dố ǔ è́ ná tè̤cuốtalwó pwè̌duyě a phûhyǎhò́ rò, kayǎ dò̌phúsophú otavǐtava̤ bínuô tahe htyaró̤ è́kú꤮ lǎ lahyǎ dố vǐ̤ Jerusalem. Bí pwè̌ bètyahíto akhè̌nuô, thyáphú èthǐ ki me̤ mwǒ̤plǐré̤ lahyǎ athè́plò phú tè̤cò́bè̌ lé̤klǒ o nuô rò a cuố ré̤ lahyǎ dố vǐ̤ Jerusalem prè́. ");
INSERT INTO kyu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Èthǐ myápṳ̌ lahyǎ Jesǔ. Rò bí èthǐ oplò́ tố̤lǔ dố tè̤lǔtyǎ hǒkǔ akhè̌nuô, a sudyǎ ní̤dyé khyělǔ tôprè̤ ná tôprè̤ rò a hé, “Thǐ tane̤ phútě? A hyǎ pwè̌ pǎ vǎhé?” ");
INSERT INTO kyu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bínuôakhè̌ prè̤lǔtyǎ khuklò́ tahe ná Pharisěophú tahenuô a hétǎ̤ lahyǎ angó̤, thyáphú pè̤ ki pṳ̂́ní̤ Jesǔ nuô rò, kayǎ dố a myáhtye lǔ tôprè̤prè̤ nuô, a tǒbè hésoluô̌ pé̤ pè̤. ");
INSERT INTO kyu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bí tè̤cuốtalwópwè̌ bètya híto anyě thuô̌thyó akhè̌nuô, Jesǔ cuố dố Lazarú o ní̤dyé dò̌ Bethania nuô. Lazarú yětôprè̤ nuôma má̤hò́ Jesǔ me̤ ihtòhtwǒprè̤ ka̤khyě lǔ nuôtôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ǔ taritaryǎ buôebuôǒsû Byacè Jesǔ ná dǐmò̤́hé rò Martha buôebuôǒ kuô̌ǔ bínuô. Lazarú onyǎ otố̤kuô̌ dố kayǎ onyǎ e lahyǎ dǐ bí dǐrè̤́ khǎshyé aklè̌ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bínuôakhè̌ Maria phyéhyǎní̤ htyěnuô̤mû́ dố ǔ è́ ná nardú yětôpyǎ̤. Htyěnuô̤mû́ yěnuôma angṳdu nyacò́ rò a phû꤮ lya̤htuô tôcǐ̤ khǎlé̤ cò́. A hyǎ lyátǎ̤ dố Byacè Jesǔ khǎduôlo̤ rò a htû́thǔkyǎ ná akhuluô̤. Htyěnuô̤mû́ yěnuô, a nuô̤mû́ cuốpye̤ lò̌ cò́ hi tômě cò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Manárò, dố a khǒpacè̤̌ aklè̌nuô, amwi̤ ná Juda Iscariot héyěnuô a otôprè̤. Dố khyě rò a isè̌kyǎ Byacè nuôtôprè̤ hò́, rò a hé, “Isè̌kyǎ htyěnuô̤mû́ rò a ní̤ rû̌ yěnuô cuốdyé ná kayǎ sǒphásǒrya̤phú nuôtahe to me̤tě? Nè̤ ki isè̌kyǎ ma a ní̤ cò́ rû̌zye denari thuô̌cwè̤́ cò́ meně!” ");
INSERT INTO kyu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A thè́zò̤ní̤ má̤lakǒ kayǎ sǒphásǒrya̤phú rò a hé phúyěnuô má̤to, me̤těhérò è ma a htwǒ prè̤ehuô. A bè pṳ̂́ pé̤ ǔ rû̌, sǎpé̤ ǔ rû̌pyě̤ rò a bò́phyéhuô tamǒmǒ rû̌ rò a nò̌e ní̤dyédû ná agněprè́. ");
INSERT INTO kyu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","“A o dû, me̤dídyǎ tǎ è tǎmé̤” Byacè Jesǔ héka̤khyěsû phúnuô. “A phyé odwó pé̤hò́ vǎ htyěnuô̤mû́ dố ǔ lé̤iluố vǎ pǎ tônyě agněhò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kayǎ sǒphásǒrya̤phú tahe otố̤kuô̌ ná thǐ pwǒ̤꤮ tôphuố cò́, manárò vǎyěnuô vǎ otố̤lǎ kuô̌ ná thǐ to.” ");
INSERT INTO kyu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judaphú bè́mṳdu tahe ní̤huô̌ ná Byacè Jesǔ obí dò̌ Bethania nuô rò a cuố lahyǎ bínuô. Èthǐ thè́zṳ̂́ hyǎmyáhtye lahyǎ tû́ Byacè Jesǔ nuô má̤to, èthǐ thè́zṳ̂́ hyǎ myáhtye tuố̤kuô̌ Lazarú dố Byacè Jesǔ me̤htwǒprè̤ ka̤khyě lǔ nuôtôprè̤prè̤. ");
INSERT INTO kyu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Phúnuô akhu-akhyě prè̤lǔtyǎ khuklò́ tahe tane̤ kreme̤thyě tố̤kuô̌ Lazarú. ");
INSERT INTO kyu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Me̤těhérò dố Lazarú akhu-akhyě, Judaphú è́prè̤ vǐkyǎ bwídukhu tahe rò htecuốkhó lahyǎ dố Jesǔ o rò zṳ̂́e lahyǎ Byacè Jesǔ akhu-akhyě a tane̤ kreme̤thyě tố̤kuô̌ lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Dốkhyě tônyěnuô, kayǎ bè́mṳ dố a hyǎ tè̤cuốtalwópwè̌ yětahe ní̤huô̌ lahyǎ ná Jesǔ hyǎ dố vǐ̤ Jerusalem yě dố klyálo̤ hò́ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Phúnuôrò a pṳ̂́ní̤ lahyǎ kanò̌dulè tahe rò a htecuố myásû lǔ, rò a è́htǒ lahyǎ, “Htuthè́htya lahyǎ Cò́marya!” “Cò́marya ki sò̌ri è dố a hyǎ ná Byacè amwi̤ yětôprè̤!” “Cò́marya ki sò̌ridû Israel akhwí yětôprè̤ ní꤮” ");
INSERT INTO kyu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Byacè Jesǔ phyéní̤ mya̤ò́lyǎ talóphú tôduô̌ rò a htya sidyání̤ lǔ. Rò yěma a me̤ lốbǎhò́ lisǎsè̌kǔ hé, ");
INSERT INTO kyu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kố꤮ Jerusalem vǐ̤phú thǐ꤮! Thè́isě tǎ lahyǎ tǎmé̤ ní! Myámò̌ lahyǎ, thǐ khwícò́phya dyání̤ mya̤ò́lyǎ talóphú rò a hyǎtǒkuô̌ dố thǐo hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Bínuôakhè̌ a khǒpacè̤̌ tahe thè́gněplǒhí tè̤me̤htwǒhtya angó̤lasá yětahe híto. Tè̤ yětahe nuôma a me̤ lốbǎhtyahò́ prè̤pro̤ a tè̤héone mú꤮ nukhè̌ tahehò́. Manárò, bí Byacè Jesǔ ka̤kahtya htuô̌hò́ dố mò́khu akhè̌nuô, èthǐ thè́né̤htyabè noprè́ ná a me̤ tè̤yětahenuô a tǒlò̌ ná prè̤pro̤ a tè̤héone mú꤮ nukhè̌ tahe. Rò a khǒpacè̤̌ tahe thè́né̤htya tuố̤bè ná a me̤tǒ pé̤lò̌ lǔ phú prè̤pro̤ héone nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kayǎ bè́mṳ dố a myáhtye Jesǔ è́hte Lazarú dố luô̤̌kǔ rò me̤htwǒprè̤ ka̤khyě lǔ tahenuô, èthǐ hésoluô̌ plehyǎ pé̤ pó̤ ǔ phú èthǐ myáhtye nuô. ");
INSERT INTO kyu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Èthǐ ní̤huô̌ lahyǎ ná Byacè Jesǔ me̤ tè̤pro̤tè̤prya̤ pé̤ ǔ tè̤yě akhu-akhyě, èthǐ htecuố myáplumyáphè lǔ ná tè̤ritè̤kyǎ yě akhu-akhyě hò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Phúnuôrò Pharisěophú tahe hé ní̤dyé lǔ tôprè̤ ná tôprè̤ phútě hérò, “Myámò̌lé! Pè̤ hépé̤ pǎ èthǐ tohò́. Hekhu tôbalò̌ krwǒkuô̌ lò̌ lǔkhyě hò́!” ");
INSERT INTO kyu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kayǎ cuố lahyǎ tè̤cuốtalwó pwè̌du dố a ki cuố cò́bè̌ Cò́marya dố vǐ̤ Jerusalem yětahe aklè̌nuô, Greek myěcôphú okuô̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Greekphú yětahenuô, a cuốtǒ dố Philipu a o, rò a hé lǔ, “Thárá, pè̤ thè́ myáhtye kuô̌lǎ Byacè Jesǔ.” Philipu ma vǐ̤ Bethsaida, Galilea ké̤phú tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philipu cuố héso pé̤ Andrea rò è ná Andrea cuố hésoluô̌ pé̤ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Rò Byacè Jesǔ hé, “Shuốkhè̌ hyǎtuố̤hò́ dố prè̤lukayǎ aphúkhǔyě ki ní̤bèhò́ tè̤taryědu taryěhtǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Vǎ hécò́cò́ thǐ, buốkǔlǎplò tôplònuô, ǔ ki iluố̤tǎ̤ lǔ dố hekhu to hénuô, a phè́htya a thèhtya cyá̤to. Manárò ǔ ki iluố̤tǎ̤ lǔ hénuô, a ki phè́htya thèhtya è́nyacò́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kayǎ dố a mo̤ ní̤dyé a thè́htwǒprè̤ dố hekhuyě tôprè̤prè̤ nuô, a ní̤bè thè́htwǒprè̤ tacṳ́prè̤ to. Manárò kayǎ dố a ki thè́lǒ ní̤dyé a thè́htwǒprè̤ dố hekhuyě to tôprè̤prè̤ nuô, a ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ǔpěpě꤮ bèbè dố a me̤ vǎ tè̤me̤ nuô, a bèkrwǒ vǎkhyě. Tû́ma, vǎ obítě꤮ tôpho bèbè, è ki okuô̌ bínuô pǎ. Vǎphè̌ ki me̤lǐme̤takhè̌ kayǎ dố a me̤ vǎ tè̤me̤ nuôtôprè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“A cyě̤ nyacò́ vǎ thè́plò. Vǎ tǒbè hé phútě? ‘Kố꤮ vǎphè̌ thè́dǒ, nò̌khyábè tǎ vǎ ná tè̤cyě̤tè̤cṳ̂ yě tǎmé̤ ní꤮’ vǎ tǒbè hé phúnuô è̌? Vǎ tǒbè hé phúnuô to. Vǎ hyǎlya̤ nyǎ hò́ dố tè̤yěnuô agněhò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kố꤮ phè̌, nè̤ taryěduhtǔ cò́ bá꤮ tě nuô, dyéluô̌ pé̤ ǔ ní꤮.” Yětôphuốrò ngó̤ o dố mò́khu hétǎ̤, “Vǎ dyéluô̌ htuô̌hò́ vǎ tè̤taryědu taryěhtǔ hò́, vǎ ki dyéluô̌ khyěthyá pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kayǎ bè́mṳ o lahyǎ bínuô tahe ní̤huô̌ lahyǎ apra̤yě rò tahehe nuô a hé lahyǎ, mò́krò̤̌ pra̤rû́pra̤tè́, tahehe rò a hé, mò́khu tanéphú hébètǎ̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","“Ngó̤pra̤htya yěnuôma thǐ lé̤ní̤bwí ní̤taryě agněprè́, vǎgně má̤to,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Khǒnyá̤rò shuốkhè̌ hyǎtuố̤hò́ dố ǔ ki cirya prè̤lu hekhuphú hò́. Khǒnyá̤rò shuốkhè̌ hyǎtuố̤hò́ dố ǔ ki vè̤́htekyǎ khǐnéricyá̤ khuklò́ Satan dố a pố kayǎ dố a zṳ̂́eto tahe yěnuô tôduô̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Manárò shyé꤮ ǔ mṳ̂̌thyěhtyalô̌hò́ vǎ dố krusu díkè hihtûlo̤ akhè̌pǎnuô, vǎ ki è́hyǎ lò̌ kayǎ pwǒ̤꤮ tôprè̤ dố vǎo pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A hé phúyě nuôma a thè́zṳ̂́ dyéluô̌ thè́gně pé̤ ǔ ná a ki thyě phútě pǎ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kayǎ bè́mṳ hésû, “Pè̤ ní̤huô̌nò́ tè̤thyótè̤thya hé ná Krístunuô a bè ohtwǒprè̤ tacṳ́prè̤ vǎ, rò nè̤ cuố hétuố̤, ‘Ǔ bè mṳ̂̌thyěhtya prè̤lukayǎ aphúkhǔyě dố hihtûlo̤’ phútě? ‘Prè̤lukayǎ aphúkhǔ’ ma ǔpě?” A hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yětôphuốrò Byacè Jesǔ hélya̤ ní̤dyé ané̤, “Tè̤lǐ yěnuô a okuô̌pó̤ ná thǐ taplô̤phú pǎprè́. Bí tè̤lǐ okuô̌pǎ ná thǐ akhè̌nuô, tarú cuốplehyǎ lahyǎ. Tè̤khí ki hyǎtuố̤ khyě thǐ pǎ. Kayǎ cuố dố tè̤khíklè̌ tôprè̤nuô, a cuốtǒ bítěnuô, a thè́gně ní̤dyé ané̤ to. ");
INSERT INTO kyu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Thyáphú thǐ ki htwǒhtya tè̤lǐphú tahenuô, bí tè̤lǐ okuô̌pǎ ná thǐ akhè̌yě, zṳ̂́e lahyǎ è ní꤮.” A hébè htuô̌ phúnuô rò a htecuố taphǎ uốkhókyǎ ná èthǐ. ");
INSERT INTO kyu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Byacè Jesǔ dyéluô̌ pé̤ cò́ èthǐ lò̌ tè̤me̤ tè̤pro̤tè̤prya̤ yětahe dố èthǐ mèthènyě cò́ tadû́rò a zṳ̂́e pǎnyǎhí lǔ toto. ");
INSERT INTO kyu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dố a zṳ̂́e phúyě to akhu-akhyě, atǒ lò̌hò́ Prè̤pro̤ Isaiah lé̤héone angó̤yě, “Kố꤮ phè̌, ǔpě zṳ̂́ehò́ pè̤ hésodônyǎ pé̤ ǔ yěnuô tahe pě? Nè̤ dyéluô̌ pé̤hò́ nè̤ tè̤pro̤tè̤prya̤ yě ná ǔpěhò́?” Prè̤pro̤ Isaiah héphúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Me̤těhérò èthǐ zṳ̂́ebè́ to hénuô, Prè̤pro̤ Isaiah hékuô̌pǎ, ");
INSERT INTO kyu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Thyáphú èthǐ ki ka̤khyětǒ tǎ lahyǎ Byacè tǎmé̤, htuô̌to thyáphú èthǐ nò̌zasǐmé̤ tǎ lahyǎ ané̤ ná Byacè tǎmé̤ nuôrò, Byacè me̤khíhò́ èthǐ mèthè, Byacè me̤pryě̤hò́ èthǐ thè́plò khukhyě èthǐ myáhtye cyá̤ ná amèthè to, èthǐ tane̤plǒbè́ lahyǎ ná athè́plò to.” A hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Prè̤pro̤ Isaiah héphúyě me̤těhérò a myáhtyenò́ Byacè Jesǔ a taryědutaryěhtǔ tû́rò a hé lǔrilǔkyǎ phúyě prè́. ");
INSERT INTO kyu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Manárò bínuôkhè̌ kayǎ zṳ̂́e ró̤è́lǎ Byacè Jesǔ. Judaphú khuklò́du khusuhtǔ aklè̌ tahenuô a zṳ̂́ekuô̌ cò́ lǔ cò́. Manárò thè́isě ná Pharisěophú tahe vè̤́htekyǎ èthǐ dố tè̤cò́bè̌ hǒklò̌ rò, èthǐ hésohte luô̌bû pé̤ ǔ ná atè̤zṳ̂́ to. ");
INSERT INTO kyu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Me̤těhérò, èthǐ thè́zṳ̂́ nò̌htuthè́ní̤ lahyǎ ané̤ ná prè̤lu kayǎ nuô adu lốklò̌ cò́ ná a thè́zṳ̂́ nò̌htuthè́ní̤ ané̤ ná Cò́marya cò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yětôphuốrò Byacè Jesǔ è́htǒhtya, “Bí kayǎ tôprè̤prè̤ zṳ̂́e vǎ akhè̌nuô, a zṳ̂́e tû́ vǎ má̤to, a zṳ̂́e tuố̤kuô̌hò́ prè̤ dố a nò̌hyǎlya̤ vǎyě tôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kayǎ dố a myáhtye vǎ nuô, a myáhtye kuô̌hò́ prè̤ dố a nò̌lya̤ vǎyě tôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Thyáphú lò̌꤮ kayǎ dố a zṳ̂́e vǎ tahe ki opǎ tǎ dố tè̤khíklè̌ tǎmé̤ nuô vǎ hyǎ lǐtakhè̌htya phú tè̤lǐ tômě dố hekhu yěnuôhò́. ");
INSERT INTO kyu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Kayǎ tôprè̤prè̤ ki ní̤huô̌ vǎlǎ̤vǎngó̤ rò a ki zṳ̂́eto hénuô, vǎ cirya lǔ to. Me̤těhérò, vǎ hyǎlya̤ dố hekhu yěnuôma, vǎ ki hyǎ cirya ǔ agněnuô má̤to, vǎ ki hyǎ me̤lwóhteka̤ ǔ agněprè́. ");
INSERT INTO kyu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kayǎ dố a htésû vǎ rò a phyésû kuô̌ vǎlǎ̤vǎngó̤ to tahenuô, prè̤cirya èthǐ a otôprè̤. Mò̤́nyěmò̤́thè̌ dốkhyělố tônyěpǎ nuô, ngó̤ dố vǎ hébè yětahe ki htwǒ èthǐ prè̤cirya tè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Me̤těhérò, vǎ hébè yěnuô, vǎ hébè ná vǎ taryěshyosò̌ ní̤dû nuô má̤to. Má̤tôkhónuô vǎ hébè phú vǎphè̌ dố a nò̌hyǎ vǎyě tôprè̤ nò̌hébè vǎ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Vǎ thè́gně ná vǎphè̌ a tè̤mekyǎngó̤ yěnuô a thǔcuố ǔ dố tè̤htwǒprè̤ tacṳ́prè̤. Phúnuôrò vǎ hé phú vǎphè̌ nò̌hé vǎ nuôtahe prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bí tè̤cuốtalwópwè̌ bètya híto akhè̌nuô, Byacè Jesǔ thè́gněhò́ ná shuốkhè̌ dố a ki bè vǐkyǎ hekhu rò a bè ka̤ dố aphè̌o nuô a hyǎtuố̤hò́. Rò a mo̤ní̤ a khǒpacè̤̌ dố a o dố hekhu yětahe pwǒ̤꤮ tôphuố cò́. A mo̤ tuố̤ cò́ èthǐ dố a tadû cò́. ");
INSERT INTO kyu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bínuôkhè̌ Byacè Jesǔ ná a khǒpacè̤̌ tahe e lahyǎ pǎ dǐ mò̤́hé. Rò Simonè Iscariot aphúkhǔ Juda Iscariot yětôprè̤nuô, thyáphú a ki isè̌tǎ̤kyǎ Byacè Jesǔ agněnuô, khǐnéricyá̤ khuklò́ Satan hébènuô̌ htuô̌hò́ angó̤ dố lǔ thè́plòkǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Byacè Jesǔ thè́gnědûhò́ ná aphè̌ dyétǎ̤ htuô̌lò̌hò́ lǔ tè̤pro̤prya̤ shyosò̌ dố tè̤lò̌꤮ plǐ akhu hò́. A thè́gně ná a o dố Cò́marya ohyǎ rò a ki ka̤khyě khyěthyá dố Cò́marya a o pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Phúnuôrò a kahtò dố èthǐ lé̤e dǐrè̤́ khǎshyé rò a plwókyǎ a ca̤klò̌htǔ htuô̌rò a cò̌ma anyá̤tǎ̤ ná khuhtǒ lé̤htû́thǔ tôba. ");
INSERT INTO kyu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A me̤htuô̌ phúnuôrò, a zṳ̂nuô̌ htyě dố bělò̤́ taè̌du kǔzǎ̤ tôbè akǔ rò a cáhtya sǐplǐ pé̤ a khǒpacè̤̌ tahe akhǎduô. Rò a htû́thǔkyǎ pé̤ èthǐ ná khuhtǒ dố a cò̌ dố a nyá̤tǎ̤kǔ nuôtôba. ");
INSERT INTO kyu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A cuốtǒ dố Simonè Petru a o rò a hésû lǔ, “Byacè nè̤ kíré̤ sǐplǐ vǎ khǎduô è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Rò Byacè Jesǔ héka̤khyěsû lǔ, “Vǎ cuốme̤ tuố̤ phúyě mame̤těhérò khǒnyá̤yě nè̤ thè́gně híto tadû́rò tônyěnyě pǎnuô, nè̤ thè́gněplǒdû pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“To꤮, nè̤ bè sǐplǐní̤ vǎ khǎduô taki꤮ to,” Petru hésû lǔ rò Byacè Jesǔ hé lǔ, “Vǎ ki sǐplǐní̤ nè̤ to hérò, nè̤ htwǒ vǎ khǒpacè̤̌ má̤to.” ");
INSERT INTO kyu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Rò Simonè Petru hé khyě, “Ki me̤phúnuôrò, Byacè, sǐplǐ tû́ tǎ vǎ khǎduô tǎmé̤. Sǐplǐ tuố̤ pé̤kuô̌ lò̌dû vǎ takhu ná vǎ khuklò́ yěnuô.” ");
INSERT INTO kyu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Rò Byacè Jesǔ hésû ka̤khyě lǔ, “Kayǎ dố a iluố̤ htuô̌hò́ htyě tôprè̤nuô, ané̤ tôprè̤lò̌ a plǐlò̌hò́, a lo sǐplǐ prè́tû́ akhǎduô prè́. Thǐ thè́plò mwǒ̤plǐthǐplo lò̌hò́ vǎ, manárò a mwǒ̤plǐthǐplo lò̌ pwǒ̤꤮ tôprè̤ to.” ");
INSERT INTO kyu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Me̤těhérò a thè́gně ná ǔ kíré̤ isè̌tǎ̤kyǎ lǔ tôprè̤ pǎ, tû́rò a hé ná thǐ mwǒ̤plǐthǐplo lò̌ pwǒ̤꤮ tôprè̤ to, a hé phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bí a sǐplǐ htuô̌hò́ èthǐ khǎduô akhè̌nuô, a thyáhtya khyěthyá aca̤klò̌ rò a ka̤khyě onyǎ khyěthyá dố akhǎlé̤. Rò a sudyǎ èthǐ, “Vǎ me̤ pé̤ thǐ phúyě nuôma thǐ thè́gněplǒ lahyǎ è̌?” A hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“‘Thárá,’ tomaná, ‘Byacè,’ thǐ è́ lahyǎ vǎ phúnuôma atǒ prè́, me̤těhérò vǎ htwǒ má̤lakǒ phú thǐ è́ vǎ nuônuô̌꤮. ");
INSERT INTO kyu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Phúnuôrò khǒnyá̤yě vǎ htwǒ thǐ Byacè thǐ Thárá cò́ rò vǎ ki sǐplǐ pé̤ thǐ khǎduô kihérò thǐ tǒ sǐplǐ pé̤kuô̌ lǔ khǎduô tôprè̤ ná tôprè̤ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Vǎ me̤kyǎ pé̤ thǐ lé̤krwǒ me̤byábû̌ yětôcô hò́. Thǐ tǒ krwǒme̤kuô̌ lahyǎ phú vǎ me̤ pé̤ thǐ yěnuô. ");
INSERT INTO kyu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Vǎ hécò́cò́ thǐ, lulénuô aduklò̌ ná abyacè tôprè̤꤮ to. Kayǎ dố ǔ nò̌ lǔ yětôprè̤nuô aduklò̌lố ná a nò̌ lǔ nuôtôprè̤nuô a o tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Khǒnyá̤rò thǐ thè́gně lahyǎ hò́ tè̤yětahe hò́. Thǐ ki ohtwǒprè̤ krwǒme̤ tè̤yětahe hénuô, thǐ ki ní̤bè tè̤sò̌ri. ");
INSERT INTO kyu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Vǎ thè́ hé lò̌plǐ thǐ pwǒ̤꤮ tôprè̤ phúnuô má̤to. Lò̌꤮ thǐ dố vǎ nwóhtya yětahe nuôma vǎ thè́gně ní̤dyé lò̌ thǐ pwǒ̤꤮ tôprè̤. Manárò thyáphú lisǎsè̌kǔ héone ki lốbǎhtya agněnuô, ‘Kayǎ dố a etố̤ǒtố̤kuô̌ tè̤ ná vǎ yětôprè̤ thè́hte vǎ rò a tapè̤̌ ka̤khyěkyǎ hò́ vǎ ná akhǎnuôkyǎ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Shyé꤮ a htwǒhtyahò́ pǎnuô, thyáphú thǐ ki zṳ̂́e ná vǎ ma Messia nuô tôprè̤hò́ nuôrò, vǎ hésoluô̌kyǎ pé̤ hò́ thǐ khǒnyá̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Vǎ hécò́cò́ thǐ, kayǎ tôprè̤prè̤ dố a è́mo̤sû kayǎ dố vǎ nò̌hyǎ è yětôprè̤ nuôma, a è́mo̤sû hò́ vǎ hò́. Kayǎ tôprè̤prè̤ dố a è́mo̤sû vǎ nuôma a è́mo̤sû hò́ prè̤ dố a nò̌hyǎ vǎyě nuôtôprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","A héhtuô̌ phúnuôrò, a sǒrya̤ nyacò́ lǔthè́plò rò a héhte luô̌lǐkyǎ pé̤ èthǐ, “Vǎ hécò́cò́ thǐ, dố thǐklè̌ yěnuô kayǎ dố a ki isè̌tǎ̤kyǎ vǎ pǎnuô a o tôprè̤,” a hélǐkyǎ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A khǒpacè̤̌ tahe myáotyá̤ ní̤dyé lò̌ lǔ tôprè̤ ná tôprè̤ rò a thè́zṳ̂́ hé bítě tôprè̤ nuô, a tane̤plǒ lahyǎ to, a hte tapa̤ lò̌plǐ cò́ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Dố a khǒpacè̤̌ aklè̌ dố a mo̤ ní̤dyé nyacò́ lǔ yětôprè̤nuô, a onyǎphû dố Byacè Jesǔ khǎshyé tôkyě. ");
INSERT INTO kyu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simonè Petru nuôcuố akhuklò́ dố a onyǎphû lǔ khǎshyé nuôtôprè̤ rò a hé lǔ, “Sudyǎ è nuô, a thè́zṳ̂́ hé maǔpě?” A héhuô cuố lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A taterè̤̌ Byacè Jesǔ rò a hé lǔ, “Byacè, nè̤ hé nuôtôprè̤ ma ǔpě?” A sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Byacè Jesǔ hé lǔ, “Vǎ tônuô̌ khò́mǔ tôkyě dố ithwíběkǔ rò vǎ dyérè̤̌ ná lǔ nuôtôprè̤ ma èhò́.” A héhtuô̌ phúnuô rò a phyé khò́mǔ tôkyě rò a tônuô̌ dố ithwíběkǔ rò a dyécuố ná Simonè aphúkhǔ Juda Iscariot. ");
INSERT INTO kyu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Juda phyéhtuô̌htuô̌ khò́mǔ, khǐnéricyá̤ khuklò́ hyǎnuô̌ dố lǔkǔ. “Nè̤ kíré̤ me̤ ǐtěnuô, cuố me̤pryǎmò̌,” Byacè Jesǔ hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mame̤těhérò Byacè Jesǔ cuố hétuố̤ lǔ phúyě me̤tě꤮ nuô, èthǐ o bí dǐrè̤́ khǎshyé nuôtahe thè́gně tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Juda yǒ pṳ̂́ pé̤ èthǐrû̌ khukhyě, èthǐ tahehe nuô, a tane̤ lahyǎ prè́ ná Byacè Jesǔ nò̌cuố ipri̤ lǔ ná tè̤ dố a lo ná pwè̌duyě agně tomaná a nò̌cuố dyé lǔ ná kayǎ sǒrya̤sǒpháphú tahe tè̤tôcôcô prè́, a tane̤ lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Juda phyéhtuô̌htuô̌ khò́mǔ, a htecuố cò́. Bínuôkhè̌ ma mò̤́khí hò́. ");
INSERT INTO kyu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Juda htecuố htuô̌hò́ akhè̌nuô, Byacè Jesǔ hé èthǐ, “Khǒnyá̤yě shuốkhè̌ hyǎtuố̤hò́ dố prè̤lukayǎ aphúkhǔ má̤hò́ vǎyě ki ní̤bèhò́ tè̤taryědu taryěhtǔ hò́. Cò́marya ki ní̤bè dǐtû́ tè̤taryědu taryěhtǔ dố prè̤lu kayǎ aphúkhǔyě a o hò́. ");
INSERT INTO kyu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Cò́marya ki ní̤bè dǐtû́ a tè̤taryědu taryěhtǔ dố è o kihérò Cò́marya ki me̤lǐme̤takhè̌ aphúkhǔyě ná ané̤ ní̤dû pǎ. A ki me̤lǐme̤takhè̌ cò́ lǔ khǒnyá̤cò́. ");
INSERT INTO kyu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Vǎphúvǎlye̤ thǐ, vǎ otố̤ nyě̤kuô̌pǎ ná thǐ tohò́. Thǐ ki myápṳ̌thû́ vǎ pǎ. Phú vǎ héhtuô̌hò́ Judaphú khuklò́khuklyǎ tahenuô, vǎ ki hé pé̤ pó̤ thǐ khǒnyá̤yě ná khǎlé̤ dố vǎ kíré̤ cuố yěnuô, thǐ cuốcyá̤to. ");
INSERT INTO kyu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Phúnuôrò khǒnyá̤yě vǎ ki mekyǎ thǐ ngó̤ athè̌ tômû̌. Mo̤ ní̤dyé lahyǎ lǔ tôprè̤ ná tôprè̤ ní꤮. Phú vǎ mo̤ ní̤dyé thǐnuô, thǐ bè mo̤ ní̤dyé lǔ tôprè̤ ná tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Thǐ ki mo̤ ní̤dyé lǔ tôprè̤ ná tôprè̤ hénuô, ǔ pwǒ̤꤮ tôprè̤ ki thè́gně ná thǐ htwǒ vǎ khǒpacè̤̌ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","“Byacè, nè̤ kíré̤ cuố bítě tôphotě pǎ?” Simonè Petru sudyǎ lǔ phúnuô. Rò Byacè Jesǔ hésû lǔ, “Khǎlé̤ dố vǎ kíré̤ cuố yětôphonuô, khǒnyá̤rò nè̤ krwǒcuố cyá̤ kuô̌hí vǎ to. Manárò nè̤ ki krwǒcuố kuô̌no vǎ dốkhyě pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Byacè, vǎ ki krwǒcuốkuô̌ nè̤ khǒnyá̤rò a cuố cyá̤tuố̤torò me̤tě? Vǎ o taritaryǎ onehò́ vǎné̤ ná vǎ ki thyě dố nè̤gněhò́ yě.” A sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yětôphuốrò Byacè Jesǔ hésû lǔ, “Nè̤ o taritaryǎ one hò́ nè̤né̤ ná nè̤ ki thyě dố vǎgně má̤lakǒ hò́ è̌? Vǎ hécò́cò́ nè̤, bí shyěphè̌ i-uhtya tyahíto nuô, nè̤ ki htébíkyǎsû ǔ ná vǎ thè́gněnò́ è to thuô̌phuố cò́ pǎ,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Byacè Jesǔ hé èthǐ, “Thè́plòkṳ́ thè́plòkyǎ̤ lahyǎ tǎmé̤ ní꤮. Zṳ̂́e lahyǎ Cò́marya rò zṳ̂́ekuô̌ lahyǎ vǎ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Dố vǎphè̌ ahikǔ nuô, hidò́kǔ lé̤o akhǎlé̤ o è́nyacò́. A ki omá̤to hérò, vǎ cuố hé tuố̤ thǐ me̤tě? Vǎ kíré̤ cuố taritaryǎ one pé̤ hò́ thǐ khǎlé̤ tôpho hò́. ");
INSERT INTO kyu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Vǎ cuố taritaryǎ pé̤ htuô̌ thǐ khǎlé̤ tôpho pǎ rò vǎ hyǎ khyěthyá dố thǐo pǎ. Thyáphú thǐ ki ka̤ otố̤kuô̌ ná vǎ bí vǎ lé̤ka̤-o akhǎlé̤ yěpǎnuô rò, vǎ hyǎ è́ka̤ khyěthyá dû thǐ pǎ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Klyá dố vǎ kíré̤ cuố yětôphonuô, thǐ thè́gněprè́,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomazo hé lǔ, “Byacè, nè̤ kíré̤ cuốtǒ bítě tôpho nuô pè̤ thè́gněto, phúnuôrò pè̤ cuố thè́gně cyá̤ klyá phútě?” ");
INSERT INTO kyu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Rò Byacè Jesǔ hésû lǔ, “Vǎ ma klyá ná tè̤má̤tè̤cò́ ná tè̤htwǒprè̤ hò́. Vǎ htwǒ pé̤hò́ ǔ klyácuố dố phè̌ a o akhu-akhyě, ǔpěpě꤮ bèbè, a ki cuố dǐtû́ ná vǎ to hénuô, a cuốtuố̤ cyá̤ dố phè̌ a o tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Thǐ ki thè́gně tǎ̤te̤hò́ vǎ hénuô, thǐ thè́gně tuố̤kuô̌ dûhò́ vǎphè̌ hò́. Cáhtya khǒnyá̤yě tǎ̤plehyǎnuô, thǐ klyá thè́gně nyǎhò́ vǎphè̌ hò́ rò thǐ klyá myáhtyenò́ nyǎ hò́ è hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philipu hé lǔ, “Byacè, nè̤ ki dyéluô̌ pé̤ tû́ pè̤ ná phè̌ hénuôma pòhò́.” ");
INSERT INTO kyu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Byacè Jesǔ hésû lǔ, “Philipu, vǎ otố̤kuô̌ ná thǐ nyě̤kú꤮ lǎ cò́hò́ rò ma nè̤ thè́gněnò́ nyǎ vǎ to è̌? Kayǎ dố a myáhtyenò́ vǎ nuô, a myáhtyenò́hò́ phè̌ hò́. Rò, ‘Dyéluô̌ pé̤ pè̤ ná phè̌,’ nè̤ cuốhétuố̤ phúnuô me̤tě? ");
INSERT INTO kyu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Vǎ okuô̌ dố phè̌kǔ rò phè̌ okuô̌ dố vǎkǔ nuôma, nè̤ zṳ̂́e nyǎto è̌? Vǎ hébè thǐ yěnuôma, vǎngó̤ ní̤dyédû má̤to. Vǎ me̤ tè̤ yětahe nuôma phè̌ dố a o dố vǎkǔyě tôprè̤ me̤ní̤ lò̌plǐ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bí vǎ hé pé̤ thǐ ná vǎ okuô̌ dố phè̌kǔ rò phè̌ okuô̌ dố vǎkǔ yěnuôma, tarú zṳ̂́e lahyǎ. Thǐ ki꤮ zṳ̂́elǎ vǎ to hérò, patítadû rò thǐ tǒ myá vǎ me̤ tè̤pro̤tè̤prya̤ dố vǎ dyéluô̌ htuô̌hò́ nuôtahe rò zṳ̂́etè̤ dố vǎ hé pé̤ thǐ yětahe nuô. ");
INSERT INTO kyu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Vǎ hécò́cò́ thǐ, kayǎ dố a zṳ̂́e vǎ tahenuô, a ki me̤tè̤ dố vǎ me̤htuô̌hò́ yěnuôtahe pǎ. Vǎ kíré̤ cuốhò́ dố phè̌ a o akhu-akhyě, a ki me̤du me̤lyá̤ me̤è́lố klò̌pǎ cò́ ná yětahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Dố vǎkhuvǎkhyě rò thyáphú ǔ ki me̤lǐme̤takhè̌htya vǎphè̌ agněnuô, thǐ kwǐtè̤ ǐtětě꤮ bèbè, thǐ ki kwǐ ná vǎmwi̤ hénuô, vǎ ki dyé thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Thǐ kwǐ tè̤ǐtětě꤮ bèbè, thǐ ki kwǐ ná vǎmwi̤ hénuô, vǎ ki me̤pé̤ thǐ phú thǐ kwǐnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Thǐ ki mo̤ vǎ hérò, thǐ ki ní̤dǎ cṳ̌e vǎ tè̤mekyǎngó̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Vǎ ki kwǐhtya phè̌ dố a ki thǔtǎ̤ pé̤ thǐ prè̤me̤cwó̤ thǐ tôprè̤ dố vǎ khǎlé̤ yěnuô pǎ. Rò a ki okuô̌ ná thǐ tacṳ́prè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","È ma má̤hò́ Thè́ Sǎsè̌ Byacè hò́. È ki ithyóithya zṳ̌klyázṳ̌klǒ thǐ ná tè̤má̤tè̤cò́ yěnuô pǎ. Prè̤lu hekhuphú tahe myáhtyenò́ lǔ toto, thè́gněnò́ lǔ toto akhu-akhyě, a è́sû lǔ to pǎ. Manárò thǐ thè́gněhò́ lǔ, me̤těhérò a ohtwǒprè̤ tố̤kuô̌ ná thǐ rò a ki hyǎo dố thǐ thè́plòkǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Vǎ dya-okryákyǎ thǐ to. Vǎ ki hyǎ khyěthyá dố thǐo pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Taplô̤phú akǔnuô, prè̤lu hekhuphú tahe myáhtye pǎ vǎ to. Manárò thǐrò, thǐ ki myáhtye vǎ pǎ. Vǎ htwǒprè̤ akhu-akhyěrò thǐ ki htwǒprè̤ kuô̌ pǎpǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bínuôtônyě pǎnuô, thǐ ki thè́gně ná vǎ o dố vǎphè̌ akǔ rò thǐ o dố vǎkǔ rò vǎ o dố thǐkǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kayǎ tôprè̤prè̤ dố a pṳ̂́maní̤ vǎ tè̤mekyǎngó̤ yětahe, rò a krwǒ ohtwǒprè̤ tahe nuôma má̤hò́ kayǎ tôprè̤ dố a mo̤ má̤hò́ vǎ hò́. Kayǎ dố a mo̤ vǎ nuô vǎphè̌ ki mo̤ní̤ lǔ pǎ. Vǎrò, vǎ ki mo̤ní̤kuô̌ è pǎ rò vǎ ki dyéluô̌ shyěklò̤́ cò́ è ná vǎné̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yětôphuốrò Juda (Juda Iscariot má̤to) hé, “Byacè, nè̤ thè́zṳ̂́ dyéluô̌ pé̤ pè̤ ná nè̤né̤ tadû́rò mame̤těrò nè̤ dyéluô̌ tuố̤pé̤kuô̌ prè̤lu hekhuphú tahe to me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Byacè Jesǔ hésû ka̤khyě lǔ, “Lò̌ kayǎ dố a mo̤ vǎ tahenuô, a ki me̤ phú vǎ hé lǔ nuô pǎ. Vǎphè̌ ki mo̤ní̤ èthǐ pǎ, rò pè̤ ki hyǎ dố èthǐ a o pǎ rò pè̤ ki hyǎ isò́ o cò́ pè̤hipè̤phyǎ dố a thè́plòkǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kayǎ tôprè̤prè̤ dố a mo̤ vǎ to nuô, a ní̤dǎ vǎ tè̤ithyóithya to. Ngó̤ dố thǐ ní̤huô̌ yětahe nuôma vǎngó̤ ní̤dû má̤to. Má̤dû phè̌ dố a nò̌hyǎ vǎ yětôprè̤ angó̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Bí vǎ okuô̌pǎ ná thǐ khǒnyá̤khè̌ yě, vǎ hésoluô̌ pé̤hò́ thǐ tè̤yětahe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Manárò, phè̌ ki nò̌hyǎ pé̤ thǐ prè̤me̤cwó̤ thǐ Thè́ Sǎsè̌ Byacè ná vǎmwi̤ pǎ. È ki ithyóithya pé̤ thǐ tè̤lò̌꤮ plǐ pǎ, htuô̌to lò̌ tè̤ dố vǎ héhtuô̌hò́ thǐ tahenuô, a ki dyéthè́né̤ ka̤khyě khyěthyá thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Vǎ dyakyǎ pé̤ thǐ thè́plò a tè̤kacṳ́kabè́ hò́. Rò vǎ dyé pé̤ hò́ thǐ vǎ tè̤kacṳ́kabè́ hò́. Vǎ dyé thǐ yěnuôma athyáná prè̤lukayǎ dyé thǐ nuôtahe má̤to. Thè́plòkṳ́ thè́plòkyǎ̤ tǎ lahyǎ tǎmé̤. Thè́isě tǎ lahyǎ tǎmé̤mé̤. ");
INSERT INTO kyu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Thǐ ní̤huô̌ htuô̌hò́ vǎ hé thǐ, ‘Vǎ cuốkyǎ thǐlé̤ pǎ tadû́rò vǎ ki ka̤tǒkuô̌ khyěthyá thǐ pǎ.’ Vǎ kíré̤ cuố dố phè̌ a o pǎ, vǎ hé thǐ phúyěnuô, thǐ ki mo̤ vǎ hérò thǐ thè́krṳ̂̌ prè́, me̤těhérò vǎphè̌ nuô aduklò̌ ná vǎ. ");
INSERT INTO kyu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Shyé꤮ a htwǒhtyahò́ pǎnuô, thyáphú thǐ ki zṳ̂́e agněnuôrò, vǎ héso one pé̤ cò́hò́ thǐ bí a htwǒhtya tyahíto yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Vǎ ki hébè nyě̤nyě̤ ná thǐ nuôma ashuốakhè̌ o è́ pǎtohò́. Khǐnéricyá̤ khuklò́ Satan dố a pố hekhu yětôduô̌nuô, a kíré̤ hyǎhò́. A tè̤taryěshyosò̌ yěnuô, a me̤ pé̤ ná vǎ to. ");
INSERT INTO kyu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Thyáphú prè̤lu hekhuphú ki thè́gněhyǎ lahyǎ ná vǎ mo̤ phè̌ agněnuô, vǎ me̤ tǒtû́prè́ phú phè̌ mehyǎ vǎ ngó̤ nuôtahe prè́. “Cuố꤮! Pè̤ htecuốhò́ pó!” ");
INSERT INTO kyu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Vǎ ma thòbǐthèmò̤́ dố a má̤lakǒ tômò̤́, vǎphè̌ ma prè́byacè. ");
INSERT INTO kyu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Thòbǐthèphyǎ dố a ícû̌ ná vǎ rò athèaphǒ hteto tahenuô, è ki pǎ̤kyǎ lò̌ pǎ. Aphyǎ dố athèaphǒhte tahenuô bèbè, thyáphú a ki thèhte è́htyapó̤ agněnuô a me̤lá̤kyǎ lò̌ke aphyǎ tahe. ");
INSERT INTO kyu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Thǐ mwǒ̤plǐbǔphuố hò́ ná vǎlǎ̤vǎngó̤ dố vǎ hé pé̤ thǐ yě akhu-akhyě prè́. ");
INSERT INTO kyu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Oklò̤sò́ma lahyǎ dố vǎkǔ rò vǎ ki oklò̤sò́ma dố thǐkǔ pǎ. Thòbǐthèphyǎ tôphyǎphyǎ dố a osò́ícû̌ma ná vǎ to nuô, a thèhtya cyá̤ ní̤dyédû ané̤ tôphyǎ꤮ to. Phúnuôhò́ thǐ ki oklò̤sò́ma dố vǎkǔ to hénuô, thǐ thèhtebè́ cyá̤ thòthè dố a má̤dû me̤tè̤ryá yěnuô tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Vǎ ma thòbǐthèmò̤́, thǐ ma aphyǎ tahe. Kayǎ dố a ki-o kisò́ dố vǎkǔ rò vǎ ki-o kisò́ dố èthǐ akǔ tahenuô, èthǐ ki thèhtyaphǒhtya è́nyacò́ pǎ. Me̤těhérò thǐ ki o ícû̌ ná vǎ to hénuô, thǐ me̤cyá̤ tè̤ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kayǎ tôprè̤prè̤ dố a oklò̤sò́ma dố vǎkǔ to nuô, athyáná thòphyǎ dố ǔ vǐhtekyǎ è dố aklò̌, rò a nókyǎkrǎkyǎ tahe nuôprè́. Thòphyǎ phúnuô tahenuô, ǔ ihtuôplò́ è rò ǔ vǐnuô̌kyǎ lǔ dố mikǔ rò ǔ isû́û̌kyǎ è prè́. ");
INSERT INTO kyu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Thǐ ki oklò̤sò́ma dố vǎkǔ, rò vǎlǎ̤vǎngó̤ ki osò́klò̤ma dố thǐkǔ kihérò thǐ thè́zṳ̂́kwǐ ǐtětě꤮ bèbè nuô, vǎ ki dyé thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Dố thǐ thèhtyaphǒhtya è́ thòthè dố a má̤hò́ me̤tè̤ryá yětahe akhu-akhyě, ǔ ki me̤lǐme̤takhè̌htya vǎphè̌ pǎ. Dố thǐ thèhtyaè́ phúnuô akhu-akhyě thǐ dyéluô̌hò́ ná thǐ htwǒ vǎ khǒpacè̤̌ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Vǎ mo̤kuô̌ thǐ phú vǎphè̌ mo̤ vǎ nuô, khǒnyá̤rò oklò̤sò́ma lahyǎ dố vǎ tè̤mo̤ akǔ yěnuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Thǐ ki ní̤dǎ cṳ̌e vǎ tè̤mekyǎngó̤ yětahe hénuôma thǐ oklò̤sò́ma hò́ dố vǎ tè̤mo̤ akǔ hò́. Thǐ ki me̤ phúyě hénuôma a thyáhò́ ná vǎ ní̤dǎ vǎphè̌ angó̤ rò vǎ oklò̤sò́ma dố a tè̤mo̤kǔ yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Thyáphú thǐ ki thè́luố̤phòphû̌ thyákuô̌ phú vǎ thè́luố̤phòphû̌ yě agněnuô, vǎ hésoluô̌ pé̤ hò́ thǐ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mo̤ ní̤dyé lǔ tôprè̤ ná tôprè̤ phú vǎ mo̤ ní̤dyé thǐ yěnuô ní꤮, yěma má̤hò́ vǎ tè̤mekyǎngó̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tè̤mo̤ dố aduklò̌lố ná kayǎ tôprè̤prè̤ dố a khyáthyěkyǎ cò́ athè́ dố a khǒbò́thyó tahe agněnuô a o pǎ to hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Thǐ ki me̤ phú vǎ mekyǎ thǐ ngó̤ yě hénuôma, thǐ htwǒhò́ vǎ khǒbò́thyó hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Vǎ è́ pǎ thǐ ná lulé to hò́, me̤těhérò lulé hénuôma a thè́gně ní̤dyé kuô̌ abyacè atè̤me̤ ari-akyǎ to. Vǎ ki è́khó hò́ thǐ ná thǐ ma vǎ khǒbò́thyó tahe hò́, me̤těhérò lò̌꤮ vǎ ní̤huô̌ tè̤ dố vǎphè̌ a o tahenuô, vǎ hésoluô̌ pé̤lò̌hò́ thǐ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Thǐ nwóhtya vǎ má̤to. Vǎ nwóhtya thǐ rò vǎ dyahtyahò́ thǐ dố thǐ ki htecuố lahyǎ rò cuố thèhtyaphǒhtya è́ lahyǎ. Vǎ dyahtyahò́ thǐ ná thǐ ki thèícû̌matuố̤ lahyǎ dố atadû. Thǐ ki me̤phúnuô tû́ma thǐ kwǐ ǐtětě꤮ bèbè, thǐ ki kwǐ ná vǎmwi̤ hénuô, phè̌ ki dyé thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Vǎ tè̤mekyǎngó̤ yěnuôma má̤hò́ mo̤ ní̤dyé lǔ tôprè̤ ná tôprè̤ yěnuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Prè̤lu hekhuphú tahe ki thè́hte thǐ hérò tane̤htya tuố̤bè lahyǎ ná a thè́hte ré̤htuô̌hò́ vǎ nuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Thǐ ki thyáná prè̤lu hekhuphú yětahe hénuô, a ki mo̤ ní̤dyé thǐ phú èthǐ kayǎ ní̤dû nuôtahe pǎ. Manárò thǐ rò, thǐ khódû ná èthǐ hò́. Vǎ nwóhtekhókyǎ hò́ thǐ dố prè̤lu hekhuphú tahe aklè̌ hò́. Èthǐ thè́hte thǐ akhǎshyékhǎrya̤ ma má̤hò́ dố thǐ yǒ khódû ná èthǐ hò́, htuô̌to vǎ yǒ nwóhtekhókyǎ hò́ thǐ ná èthǐ yě akhu-akhyěrò èthǐ thè́htethè́hǎ hò́ thǐ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Thè́né̤htyabè lahyǎ ngó̤ dố vǎ hé pé̤ thǐ, ‘Lulé duklò̌lố ná abyacè nuô a o tôprè̤꤮ to,’ yěnuô ní꤮. Èthǐ me̤cyě̤me̤cṳ̂ htuô̌hò́ vǎ akhu-akhyě, a ki me̤cyě̤me̤cṳ̂ kuô̌ ke thǐ pǎ. Èthǐ ki cṳ̌e ní̤dǎ htuô̌hò́ vǎngó̤ hénuô, a ki cṳ̌e ní̤dǎ kuô̌dû thǐngó̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Thǐ htwǒ vǎ khǒpacè̤̌ akhu-akhyě prè̤lu hekhuphú tahe ki me̤cyě̤ thǐ pǎ, me̤těhérò èthǐ thè́gně lahyǎ phè̌ dố a nò̌hyǎ vǎ yěnuô tôprè̤ to. ");
INSERT INTO kyu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Vǎ ki hyǎ hésodônyǎ pé̤ èthǐ to kihénuô, Cò́marya dya ná èthǐ tè̤thû́ to. Manárò khǒnyá̤yě vǎ hyǎ hésodônyǎ luô̌ pé̤ èthǐ akhu-akhyě, alé̤hé siplè́ ní̤dyé angó̤ ná atè̤thû́ agněnuô a opǎ tômû̌꤮ to hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kayǎ dố a thè́hte vǎ nuô a thè́hte tuố̤kuô̌hò́ vǎphè̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tè̤me̤ tè̤pro̤tè̤prya̤ dố ǔ me̤cyá̤ tôprè̤꤮ to yětahenuô, vǎ ki dyéluô̌ dố èthǐ aklè̌ to hénuô, èthǐ tè̤thû́ o takhyá꤮ to. Manárò, khǒnyá̤yě, èthǐ myáhtye tè̤me̤ tè̤pro̤tè̤prya̤ yětahe rò a thè́hte lò̌plǐ hò́ vǎ ná vǎphè̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Manárò yěnuôma, èthǐ me̤lốme̤bǎhtya pé̤hò́ phú lisǎsè̌ héo htuô̌hò́, ‘Vǎ me̤ thè́htethè́hǎnò́ èthǐ ná vǎné̤ tôcô꤮ to tadû́rò èthǐ thè́hte vǎ.’ ");
INSERT INTO kyu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Vǎ ki nò̌hyǎ prè̤me̤cwó̤tè̤ dố a o dố phè̌o yěnuô tôprè̤ dố thǐ o pǎ. È ma tè̤má̤tè̤cò́ a Thè́ Sǎsè̌ Byacè dố a o dố phè̌ a o hyǎ. Shyé꤮ a hyǎtuố̤ pǎnuô, a ki hésoluô̌ pé̤ thǐ ná vǎrivǎkyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Thǐ otố̤kuô̌ ná vǎ dố akhǎshyékhè̌ pǎ cò́ akhu-akhyě thǐ bè héso pé̤ kuô̌ǔ ná vǎrivǎkyǎ ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Thyáphú thǐ ki vǐkyǎ tǎ thǐ tè̤zṳ̂́tè̤nyá̤ tǎmé̤ nuô, vǎ hésoluô̌ lò̌pé̤ htuô̌hò́ thǐ tè̤yětahe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ǔ ki vè̤́htekyǎ thǐ dố tè̤cò́bè̌hǒ tahe aklò̌ pǎ. Kayǎ dố a me̤thyě thǐ tahenuô a tane̤ ní̤dyé ané̤, ‘Pè̤ me̤ hò́ Cò́marya atè̤me̤ hò́,’ shuốkhè̌ phúyěnuô, a ki hyǎtuố̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A cuố me̤tuố̤ lahyǎ phúyě me̤těhérò èthǐ thè́gněnò́ phè̌ tôphuố꤮ to, htuô̌rò a thè́gněnò́ vǎ tôphuố꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Shyé꤮ tè̤shuốtè̤khè̌ hyǎtuố̤hò́ pǎ akhè̌nuô, thǐ ki khyábè tè̤cyě̤tè̤cṳ̂ tahe pǎ. Thyáphú thǐ ki thè́né̤htyabè tuố̤ tè̤ dố vǎ dyérò̤ one thǐ tè̤yětahe agněnuôrò, vǎ héso-one pé̤ hò́ thǐ khǒnyá̤yě hò́. Dố akhǎshyékhè̌ nuôma vǎ yǒ okuô̌ ná thǐ akhu-akhyě vǎ hésoluô̌nò́ pé̤hí thǐ to.” ");
INSERT INTO kyu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Khǒnyá̤rò, vǎ ki ka̤hò́ dố prè̤ dố a nò̌hyǎ vǎ yětôprè̤ a o hò́. ‘Nè̤ kíré̤ cuốbítě tôphotě pǎnuô,’ thǐ sudyǎ vǎ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Vǎ héluô̌ pé̤ thǐ phúyě rò thǐ thè́plè̤̌thè́zò̤ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ki hé lò̌lò̌꤮ ngó̤ ma, vǎ cuốkyǎ thǐlé̤ ma aryá klò̌lố cò́ dố thǐgněcò́, me̤těhérò vǎ ki cuố to hénuô, prè̤me̤cwó̤ má̤hò́ Thè́ Sǎsè̌ Byacè yětôprè̤ hyǎ dố thǐo to. Manárò vǎ ki cuố hénuô, vǎ ki nò̌hyǎlya̤ ke lǔ dố thǐo pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bí Thè́ Sǎsè̌ Byacè hyǎtuố̤hò́ pǎ akhè̌nuô, a ki dyéthè́gně pé̤ prè̤lu hekhuphú tahe ná èthǐ me̤ tè̤thû́ pǎ, htuô̌rò a ki dyéthè́gně pé̤ pó̤ èthǐ ná tè̤cò́tè̤te̤ aklyá pǎ. Htuô̌to, a ki dyéthè́gně pé̤kuô̌pó̤ èthǐ ná Cò́marya ki cirya èthǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dố èthǐ zṳ̂́e vǎ to akhu-akhyě, a dyéthè́gněhò́ èthǐ ná èthǐ tè̤thû́ o hò́. ");
INSERT INTO kyu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Me̤těhérò, vǎ ki ka̤ dố phè̌ a o pǎ rò thǐ myáhtye pǎ vǎ to akhu-akhyě, Thè́ Sǎsè̌ Byacè ki dyéthè́gněplǒ pé̤ èthǐ ná tè̤cò́tè̤te̤ aklyáaklǒ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Cò́marya ciryahò́ khǐnéricyá̤ khuklò́ Satan dố a pố hekhu yětôduô̌ hò́ akhu-akhyě, a dyé thè́gněplǒ pé̤hò́ prè̤lu hekhuphú tahe ná Cò́marya ki cirya èthǐ pǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Tè̤ dố vǎ thè́zṳ̂́ hé pé̤ pó̤ thǐ tahenuô a o è́lǎpǎ, manárò thǐ thè́gněplǒbè́ lò̌híto. ");
INSERT INTO kyu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bí Thè́ Sǎsè̌ Byacè dố a dyéluô̌ tè̤má̤tè̤cò́ yě hyǎpǎ akhè̌nuô, a ki zṳ̌klyázṳ̌klǒ pé̤ thǐ ná lò̌ tè̤má̤tè̤cò́ nuôtahe pǎ. A ki hésoluô̌ pé̤ thǐ ná a tè̤tane̤ ní̤dûnuô má̤to. A ki hésoluô̌ pé̤ thǐ phú a ní̤huô̌ hyǎní̤ dố Cò́marya a o nuôtahe pǎ. A ki dyéluô̌ pé̤ thǐ ná tè̤ dố a htwǒhtya híto nuôtahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dố a hyǎ hésoluô̌ pé̤ thǐ ná lò̌ a ní̤huô̌ tè̤ dố vǎo nuôtahe akhu-akhyě, a ki me̤lǐme̤takhè̌ vǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lò̌꤮ tè̤ dố a o ná phè̌ tahe nuôma vǎtè̤ lò̌꤮ plǐ hò́. Tû́rò vǎ hé pé̤ thǐ ná Thè́ Sǎsè̌ Byacè ki hyǎ hésoluô̌ pé̤ thǐ lò̌꤮ a ní̤huô̌ tè̤ dố vǎ o nuôtahe pǎ, phúnuô hò́nuô̌.” ");
INSERT INTO kyu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Nyě̤tyato pǎma thǐ myáhtyenò́ pǎ vǎ to hò́, manárò nyě̤tyato khyěthyá pǎma thǐ myáhtye khyěthyá vǎ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","A khǒpacè̤̌ tahehe nuô, a sudyǎ ní̤dyé lǔ tôprè̤ ná tôprè̤ rò a hé lahyǎ, “A cuố hé tuố̤, ‘Nyě̤tyato pǎma thǐ myáhtyenò́ pǎ vǎ to hò́, manárò nyě̤tyato khyěthyá pǎma thǐ myáhtye khyěthyá vǎ pǎ’ a hé phúyěnuôma a thè́hé angó̤lasá phútě?” Htuô̌rò èthǐ hé lahyǎ, “‘Me̤těhérò vǎ kíré̤ cuố dố phè̌ a o hò́,’ a hé phúnuôma a thè́zṳ̂́ hé angó̤lasá phútětě?” ");
INSERT INTO kyu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Rò èthǐ ná èthǐ sudyǎ tadû ní̤dyé pǎlǔ, “‘Nyě̤tyato pǎma,’ a hé yětômû̌ nuôma a thè́hé ǐtě? A thè́zṳ̂́ hé matěnuô, pè̤ thè́gněplǒ htwópǎto hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Byacè Jesǔ thè́gně dố èthǐ thè́zṳ̂́ sudyǎ lǔ tè̤ritè̤kyǎ yě akhu-akhyěrò a hé èthǐ, “Vǎ hé pé̤ thǐ, ‘Nyě̤tyato pǎma thǐ myáhtyenò́ pǎ vǎ to hò́, manárò nyě̤tyato khyěthyá pǎma thǐ myáhtye khyěthyá vǎ pǎ,’ yěnuô vǎ thè́ hé angó̤lasá ǐtěnuô thǐ sudyǎ ní̤dyé khyělǔ tôprè̤ ná tôprè̤ vǎhéto? ");
INSERT INTO kyu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Vǎ hécò́cò́ thǐ, bí prè̤lu hekhuphú tahe ki thè́krṳ̂̌thè́lò̌ tapûlûsû cò́ pǎ akhè̌nuô, thǐ kinguố̤kihè lahyǎ pǎ. Dố vǎ khyábè tè̤cyě̤tè̤cṳ̂ akhu-akhyě, thǐ ki thè́plè̤̌nebè nyacò́ pǎ, manárò thǐ tè̤thè́plè̤̌nebè yěnuô a ki htwǒhtya taplekhó pé̤ke thǐ ná thǐ tè̤thè́luố̤phòphû̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Athyáná prè̤mò phúo hò́sè̌ nuô pǎ. Bí a hò́sè̌ akhè̌, a khyábè tè̤sǒphásǒrya̤ tadû́rò bí aphúohò́ akhè̌nuô, a sǒtapa̤kyǎ a tè̤sǒphásǒrya̤ tahe, me̤těhérò aphúoní̤ pacè̤̌phú tôprè̤ dố hekhuyě akhu-akhyě a thè́krṳ̂̌thè́lò̌ hyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tè̤ ki htwǒhtya thyákuô̌dû ná thǐ phúyěnuô pǎ. Khǒnyá̤rò thǐ ki thè́plè̤̌nebè pǎ, manárò vǎ ki myáhtye khyěthyá thǐ pǎ rò thǐ ki thè́krṳ̂̌thè́lò̌ nyacò́ pǎ. Htuô̌to ǔ phyékyǎ cyá̤ pǎ cò́ thǐ tè̤thè́krṳ̂̌thè́lò̌ tôprè̤꤮ cò́to pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bínuôtônyě pǎnuô, thǐ sudyǎ pǎ cò́ vǎ tôcô꤮ to hò́. Vǎ hécò́cò́ thǐ, thǐ ki kwǐ vǎphè̌ ǐtětě꤮ bèbè, thǐ ki kwǐ ná vǎmwi̤ hénuô, vǎphè̌ ki dyé thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tuố̤khǒnyá̤ yěnuô, thǐ kwǐ ná vǎmwi̤ tôcô꤮ to. Kwǐ lahyǎ, thǐ ki ní̤bè pǎ. Rò thǐ ki ní̤bè lốbǎ cò́ tè̤thè́luố̤phòphû̌ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Vǎ hébè pé̤ thǐ tè̤yětahe ná ngó̤khákho tahe. Manárò shuốkhè̌ dố vǎ lo hébè pǎ ná ngó̤khákho to nuô, a ki hyǎtuố̤ pǎ. Vǎ ki héluô̌lǐ pé̤lò̌ thǐ ná vǎphè̌ ari-akyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bínuôtônyě pǎnuô, thǐ kwǐcò́bè̌htya lahyǎ ná vǎmwi̤ pǎ. Rò vǎ lokwǐ pé̤ pǎ dố thǐgně to. ");
INSERT INTO kyu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Me̤těhérò vǎphè̌ mo̤ní̤ thǐ ná ané̤ ní̤dûcò́. Dố thǐ mo̤ní̤ hò́ vǎ, thǐ zṳ̂́ení̤ hò́ vǎ ná vǎ o dố phè̌ a o hyǎ akhu-akhyě, a mo̤ní̤ hò́ thǐ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Vǎ o dố phè̌o hyǎ rò vǎ hyǎlya̤ dố hekhuyě. Khǒnyá̤rò vǎ ki hteka̤kyǎ dố hekhuyě rò vǎ ki ka̤khyě khyěthyá dố vǎphè̌ a o.” ");
INSERT INTO kyu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yětôphuốrò a khǒpacè̤̌ tahe hé lǔ, “Khǒnyá̤ rò nè̤ hébè pǎ ná ngó̤khákho to rò a plǒryálǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pè̤ sudyǎ tyahí nè̤ tôcô꤮ to tadû́rò nè̤ thè́gně lò̌ré̤dûhò́ tè̤ dố pè̤ kíré̤ sudyǎ nè̤ nuôtahe hò́. Phúnuôrò khǒnyá̤yě pè̤ thè́gně ná nè̤ thè́gně lò̌ tè̤pwǒ̤tôcô. Dố nè̤ thè́gně phúyě akhu-akhyě, pè̤ zṳ̂́e ná nè̤ o dố Cò́marya a o hyǎlya̤ má̤nyǎ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Rò Byacè Jesǔ sudyǎ èthǐ, “Khǒnyá̤rò thǐ zṳ̂́e má̤lakǒ hò́ nuô̌꤮? ");
INSERT INTO kyu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Manárò shuốkhè̌ dố thǐ ki klyapruốklyapryǎ lò̌ pǎ, rò thǐ ki ka̤kyǎ lahyǎ dố thǐhi tôprè̤ ná tôprè̤ nuô, a ki hyǎtuố̤ pǎ. Hétǎ̤tǎ̤꤮ ma a hyǎtuố̤ cò́hò́. Thǐ pwǒ̤꤮ tôprè̤ ki dya-okyǎ tû́dû vǎ pǎ. Manárò vǎ otû́dû má̤to, me̤těhérò vǎphè̌ okuô̌ ná vǎ. ");
INSERT INTO kyu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Thyáphú thǐ ki ní̤bè tè̤thè́plò kacṳ́kabè́ agněnuô, vǎ hé pé̤ htuô̌ lò̌ hò́ thǐ lò̌꤮ yětahe hò́. Dố thǐ htwǒhtyahò́ tè̤tôcô꤮ tuô̌ ná vǎ akhu-akhyě, thǐ ní̤bèhò́ thè́plò a tè̤kacṳ́kabè́ hò́. Dố hekhu yěnuô, thǐ ki myáhtyebè ná tè̤pyá̤tè̤sè̌ tè̤cyě̤tè̤cṳ̂ pǎ, manárò dyashyodyasò̌ lahyǎ thǐ thè́plò ní꤮. Vǎ me̤pé̤ htuô̌hò́ hekhuné̤khu a taryěshyosò̌ yětahe hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Byacè Jesǔ héhtuô̌ phúyě rò a tṳ́htya dố mò́khu rò a kwǐcò́bè̌ rò a kwǐ phúyě, “Phè̌꤮, shuốkhè̌ hyǎtuố̤hò́. Thyáphú vǎ ki me̤lǐme̤takhè̌ htyaluô̌ nè̤nuô, me̤lǐme̤takhè̌ mò̌ vǎ má̤dû nè̤ phúkhǔyě. ");
INSERT INTO kyu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Me̤těhérò thyáphú lò̌꤮ kayǎ dố nè̤ dyé vǎ tahe ki ní̤bè thè́htwǒprè̤ tacṳ́prè̤ agněnuô, nè̤ dyé htuô̌lò̌hò́ vǎ tè̤taryěshyosò̌ dố vǎ ki pố lò̌ kayǎ yětahe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Cò́marya má̤ma tû́ nè̤ tôprè̤prè́, rò kayǎ dố a thè́gně nè̤ rò a thè́gně ná vǎ ma Jesǔ Krístu dố nè̤ plwǒhyǎ lǔ tôprè̤ tahe nuôma má̤hò́ tè̤thè́gně dố a dyé èthǐ thè́htwǒprè̤ tacṳ́prè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Vǎ me̤ pé̤ htuô̌lò̌ hò́ nè̤ tè̤me̤ dố nè̤ nò̌me̤ vǎ nuôtahe akhu-akhyě, vǎ me̤lǐme̤takhè̌ hò́ nè̤ dố hekhuyě hò́. ");
INSERT INTO kyu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Phè̌꤮, phú vǎ tè̤lǐtè̤takhè̌ otố̤kuô̌ ná nè̤ dố hekhu htwǒhtya tyahíto pǎ akhè̌nuô, dyékhyěmò̌ vǎ tè̤lǐtè̤takhè̌ yěnuô dố nè̤nyěhyǎ khǒnyá̤yě to.” ");
INSERT INTO kyu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kayǎ dố nè̤ nwóhtekhó èthǐ dố hekhuyě rò nè̤ dyé ná vǎ tahenuô vǎ dyéluô̌ pé̤hò́ èthǐ ná nè̤ hò́. Èthǐ tahe nuôma nè̤tè̤ hò́. Èthǐ tahenuô, nè̤ dyé ná vǎ rò èthǐ ní̤dǎ lahyǎ nè̤ngó̤. ");
INSERT INTO kyu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Khǒnyá̤rò lò̌꤮ tè̤ dố vǎhé vǎme̤ yětahenuô, a o dố nè̤o rò a hyǎ prè́nuô èthǐ thè́gně hò́. ");
INSERT INTO kyu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Me̤těhérò, tè̤ritè̤kyǎ dố nè̤ dyé vǎ nuôtahenuô, vǎ dyé ná èthǐ rò èthǐ phyésû htuô̌hò́. Èthǐ thè́gně tǎ̤te̤ hò́ ná vǎ o dố nè̤ o hyǎ rò èthǐ zṳ̂́e ná nè̤ nò̌hyǎ vǎ. ");
INSERT INTO kyu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Vǎ kwǐcò́bè̌ pé̤ dố èthǐ agně. Vǎ kwǐcò́bè̌ pé̤ prè̤lu hekhuphú nuôtahe agně má̤to. Manárò kayǎ dố nè̤ dyéhò́ vǎ tahenuô, nè̤tè̤ akhu-akhyě, vǎ kwǐcò́bè̌ pé̤ dố èthǐgně. ");
INSERT INTO kyu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Lò̌꤮ a o ná vǎ tahenuô, nè̤tè̤ hò́, rò lò̌꤮ a o ná nè̤ tahenuôma, vǎtè̤ hò́. Vǎ ní̤bè dǐtû́ tè̤lǐtakhè̌ dố èthǐ o. ");
INSERT INTO kyu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Vǎ o tadû pǎ dố hekhuyě to, manárò èthǐ yětahe ki o tadûpǎ dố hekhuyě pǎ. Vǎrò, vǎ ki ka̤khyě khyěthyá dố nè̤ o pǎ. Kố꤮ Phè̌ sǎsè̌! Thyáphú èthǐ ki olǔ ná thè́plò tômě꤮ cû̌ phú vǎ ná nè̤ olǔ ná thè́plò tômě꤮ cû̌ akǔnuô, takò́takè̤ bíní̤dû èthǐ ná nè̤mwi̤ dố apro̤aprya̤, nè̤mwi̤ dố nè̤ dyé vǎ yěnuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bí vǎ otố̤kuô̌ ná èthǐ akhè̌nuô, vǎ takò́takè̤bí ní̤dyé èthǐ hò́, vǎ opò̤́ myákhwèní̤ èthǐ ná mwi̤ dố nè̤ dyé vǎ nuô hò́. A lamé̤kyǎ ná tôprè̤꤮ to. Thyáphú lisǎsè̌ ki lốbǎhyǎ agněnuô, a lamé̤kyǎ tû́prè́ kayǎ nuôtôprè̤ dố ǔ dya one nyǎhò́ è dố a ki pyényǎ pǎ nuôtôprè̤ tû́dû prè́.” ");
INSERT INTO kyu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Vǎ hyǎhò́ dố nè̤ o khǒnyá̤ hò́. Thyáphú èthǐ ki olốbǎ ná tè̤thè́luố̤phòphû̌ agněnuô, bí vǎ opǎ bí hekhuyě akhè̌, vǎ héluô̌ pé̤ hò́ èthǐ ná tè̤yětahe hò́. ");
INSERT INTO kyu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Vǎ dyéthè́gně pé̤hò́ èthǐ ná nè̤lǎ̤nè̤ngó̤, rò kayǎ dố a zṳ̂́e vǎ to tahenuô, a thè́htethè́hǎ lò̌ èthǐ me̤těhérò phú vǎ oícû̌tố̤ ná hekhu to nuô, èthǐ thyákuô̌ hò́ ná vǎ akhu-akhyě, ǔ thè́htethè́hǎ lò̌ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Vǎ kwǐcò́bè̌ ná phyéhte taphǎkyǎ èthǐ ná hekhuyě phúnuô má̤to. Má̤tôkhónuô, vǎ kwǐcò́bè̌ ná nè̤ ki takò́takè̤ bíní̤ èthǐ ná kayǎcyě̤ kayǎricyá̤ dố ǔ è́ lǔ ná Satan yěnuô tôduô̌. ");
INSERT INTO kyu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Phú vǎ oícû̌tố̤ ná hekhu to nuô, èthǐ thyákuô̌dû ná vǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Me̤sǎsè̌ khòdû èthǐ ná nè̤lǎ̤nè̤ngó̤ dố acò́ yěnuô ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Phú nè̤ nò̌hyǎ vǎ dố hekhu yěnuô, vǎ nò̌cuốhò́ èthǐ dố hekhuphú yětahe a o hò́. ");
INSERT INTO kyu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Thyáphú èthǐ ki besǎsè̌ kuô̌ lahyǎ athè́ ná nè̤lǎ̤nè̤ngó̤ a tè̤má̤tè̤cò́ yěnuô rò, vǎ dyélya̤ lò̌lá̤takli htuô̌hò́ vǎ thè́htwǒprè̤ dố èthǐ akhǎlé̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Vǎ kwǐcò́bè̌ pé̤ tû́ vǎ khǒpacè̤̌ yětahe agněnuô má̤to. Èthǐ yětahe cuố khyáthè́ pǎ rò kayǎ dố a ní̤huô̌ rò a zṳ̂́enyá̤e ka̤ kuô̌ vǎ pǎ tahe agněbèbè, vǎ kwǐcò́bè̌ pé̤ tố̤kuô̌ lò̌ dố èthǐgněgně. ");
INSERT INTO kyu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kố꤮ phè̌, phú nè̤ o dố vǎkǔ, rò vǎ o dố nè̤kǔ yěnuô, thyáphú èthǐ lò̌꤮ plǐ ki okuô̌dû lǔ ná thè́plò tômětuô̌ rò, vǎ kwǐ thè́zò̤htya hò́ nè̤ hò́. Htuô̌to thyáphú prè̤lu hekhuphú tahe ki zṳ̂́e ná nè̤ nò̌hyǎlya̤ vǎ nuôrò, vǎ kwǐcò́bè̌ ná èthǐ ki okuốdû dố pè̤kǔ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Thyáphú èthǐ ki olǔ ná thè́plò tômě꤮ cû̌ phú vǎ ná nè̤ olǔ ná thè́plò tômě꤮ cû̌ akǔnuô rò, vǎ dyé hò́ èthǐ tè̤lǐtè̤takhè̌ dố nè̤ dyé vǎ yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Thyáphú èthǐ ki thè́plò ícû̌ryá lǔ tômětuô̌ agně, htuô̌to thyáphú prè̤lu hekhuphú tahe ki thè́gněhyǎ ná nè̤ nò̌hyǎlya̤ vǎ, rò nè̤ mo̤ní̤ prè̤ dố a zṳ̂́e vǎ tahe phú nè̤ mo̤ní̤ vǎ nuôrò, vǎ o dố èthǐ akǔ rò nè̤ o dố vǎkǔ.” ");
INSERT INTO kyu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Kố꤮ Phè̌, kayǎ dố nè̤ dyé ná vǎ yětahenuô, vǎ o bítě tôphonuô, vǎ thè́zṳ̂́ è́ okuô̌ èthǐ bínuô. Vǎ thè́zṳ̂́ dố èthǐ ki myáhtye vǎ tè̤lǐtè̤takhè̌ dố nè̤ dyé vǎ yětahe, me̤těhérò, nè̤ mo̤ pǎ vǎ dố pè̤ byálya̤ tyahí hekhu to akhè̌ pǎ cò́.” ");
INSERT INTO kyu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Phè̌ dố acò́ate̤꤮, prè̤lu hekhuphú tahe thè́gně nè̤ to tadû́rò vǎ thè́gně nè̤, htuô̌to kayǎ dố a zṳ̂́e vǎ yětahe thè́gně ná nè̤ nò̌hyǎ vǎ. ");
INSERT INTO kyu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Thyáphú nè̤ tè̤mo̤ vǎyě ki o dố èthǐ akǔ, htuô̌to thyáphú vǎ ki okuô̌ dố èthǐ akǔ agněnuô, vǎ dyéthè́gně pé̤hò́ èthǐ ná nè̤, rò vǎ ki dyéthè́gně plehyǎ pé̤ pó̤ èthǐ ná nè̤ pǎ,” Byacè Jesǔ kwǐcò́bè̌ rò a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","A kwǐcò́bè̌ htuô̌rò è ná a khǒpacè̤̌ tahe htecuốbè́ Kidro lyǎ̤zǎ̤krǎ nuôtôbǒ. Dố lyǎ̤ bè́rè̤̌ nuô, olivaphè prè́lé̤ otôlé̤. Rò è ná a khǒpacè̤̌ tahe cuốnuô̌ lahyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Byacè Jesǔ ná a khǒpacè̤̌ tahe cuố myáhtye tǎ̤sû tamǒmǒ ní̤dyé lǔ bí khǎlé̤ nuôtôpho akhu-akhyě, Juda dố a isè̌tǎ̤kyǎ Byacè Jesǔ yětôprè̤nuô, khǎlé̤ nuôtôpho ma a thè́gně prè́. ");
INSERT INTO kyu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Phúnuôrò, Juda cuố dố prè́nuô tôlé̤khu. Rò bwídukhu tahe ná Pharisěophú tahe nò̌hyǎ tố̤kuô̌ Roma klyěphú tahe ná klyěphú dố a opò̤́ tè̤lǔhǒdu nuôtahe ná Juda. Èthǐ phyéhyǎní̤ mikò̌ thǐtahe, mikyǎ̤ tarè́bǒ tahe ná takuô̤tabè̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tè̤ kíré̤ htwǒhtya ané̤ ná Jesǔ phútě nuô, a thè́gně lò̌plǐ akhu-akhyě a hyǎtǒ èthǐ rò a sudyǎ èthǐ, “Thǐ myápṳ̌ ǔpě?” ");
INSERT INTO kyu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Èthǐ hésû lǔ, “Pè̤ myápṳ̌ vǐ̤ Nazarèphú Jesǔ,” A hé rò Jesǔ hésû èthǐ, “Vǎ ma èhò́.” Rò Juda dố a isè̌tǎ̤kyǎ lǔ nuôtôprè̤ ihtò tố̤kuô̌ ná èthǐ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bí Byacè Jesǔ hé èthǐ, “Vǎ ma èhò́,” akhè̌nuô, èthǐ thyéka̤khyě rò a lakhû́tǎ̤ lò̌ dố hekhu. ");
INSERT INTO kyu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yětôphuốrò Byacè Jesǔ sudyǎ khyěthyá èthǐ, “Thǐ myápṳ̌ ǔpě?” Rò èthǐ hésû, “Pè̤ myápṳ̌ vǐ̤ Nazarèphú Jesǔ,” a hésû lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Vǎ héhtuô̌hò́ thǐ ná vǎ ma èhò́. Thǐ ki myápṳ̌ má̤ vǎ hérò plwǒka̤kyǎ kayǎ dố aruô nuôtahe,” a hésû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tè̤hébè yětômû̌nuô, a me̤ lốbǎhtya ngó̤ dố a héhtuô̌hò́, “Kayǎ dố nè̤ dyé vǎ tahenuô, a lamé̤kyǎnò́ tôprè̤꤮ to,” yěnuôhò́. ");
INSERT INTO kyu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yětôphuốrò Simonè Petru dố a phyéhyǎní̤ nè́ tôbè yětôprè̤ báhte anè́ rò a pǎ̤tṳ̂̌kyǎ bwídukhulố a prè̤me̤tè̤phú tôprè̤ a khǎlèkuố̤ dố cò́htwó tôkyě. Kayǎ yětôprè̤nuô amwi̤ ná Malko. ");
INSERT INTO kyu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Rò Byacè Jesǔ hé Petru, “Ryǎ̤nuô̌ dwókyǎ nè̤ nè́ dố aklokǔ nuô. Tè̤cyě̤tè̤cṳ̂ abělò̤́ dố vǎphè̌ nò̌ǒ vǎyě nuôma, vǎ tǒ ǒ nyǎ to è̌?” ");
INSERT INTO kyu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Htuô̌rò Roma klyěphú ná èthǐ klyěkhuklò́ tôprè̤ ná Juda klyěphú dố a opò̤́ tè̤lǔhǒdu tahe pṳ̂́ cò̌klò̤ma lò̌ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Rò a è́ cuố ré̤lố lǔ dố Anna ahi. È ma Caipha aprè̤́. Caipha ma bínuô tônakǔ a htwǒ bwídukhulố hò́. ");
INSERT INTO kyu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caipha ma kayǎ tôprè̤ dố a dyé thè́gněcwó̤ pé̤ Judaphú khuklò́khuklyǎ tahe, “Phû꤮ ná kayǎ lò̌꤮ plǐ ki thyělò̌ nuô, kayǎ yětôprè̤ ki thyěkyǎ nuôma aryáklò̌” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simonè Petru ná Jesǔ a khǒpacè̤̌ dố aruô tôprè̤nuô, a krwǒcuốkuô̌ Byacè akhyě. A khǒpacè̤̌ dố aruô yětôprè̤nuô, bwídukhulố yětôprè̤ thè́gně tǎ̤te̤ lǔ akhu-akhyě a cuốnuô̌kuô̌ ná Byacè Jesǔ dố bwídukhulố yětôprè̤ ahi vǐ̤kǔ. ");
INSERT INTO kyu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Manárò Petru ihtò okyǎ dố lo̤kadǎklò̌ prè́. A khǒpacè̤̌ dố aruô dố bwídukhulố thè́gně lǔ yětôprè̤nuô, a htekhyě rò a htehé prè̤opò̤́ lo̤kadǎ prè̤mòphú yětôprè̤ rò a è́nuô̌ Petru yě dố hivǐ̤kǔ. ");
INSERT INTO kyu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Prè̤mòphú opò̤́ kadǎ yětôprè̤ hé Petru, “Nè̤ ma nè̤ otố̤kuô̌ dố Jesǔ hénuô tôprè̤ a khǒpacè̤̌ nuôtahe aklè̌ tôprè̤ hò́, vǎhéto?” Rò a hésû lǔ, “Vǎ má̤to.” ");
INSERT INTO kyu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yǒ ké̤ró̤ rò prè̤me̤tè̤phú tahe ná klyěphú dố a opò̤́ tè̤lǔhǒdu tahe ihtòswí tava̤ lò̌plǐ mi. Rò Petru ihtòswí tố̤kuô̌ mi ná èthǐ. ");
INSERT INTO kyu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bwídukhulố nuôtôprè̤ sudyǎmyá Jesǔ ná a khǒpacè̤̌ tahe ari-akyǎ ná a tè̤ithyóithya tahe ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Byacè Jesǔ hésû lǔ, “Vǎ ithyóhuô ithyóthwè́nò́ ná ǔ to, vǎ ithyólá̤ithyólǐ ǔ dố kayǎ pwǒ̤꤮ tôprè̤ anyěhyǎ prè́. Lò̌꤮ Judaphú tahe lé̤hyǎ myáhtye tǎ̤sû ní̤ lǔ akhǎlé̤ dố tè̤cò́bè̌ hǒkǔ nuô bèbè, dố tè̤lǔtyǎ hǒkǔnuô bèbè vǎ ithyó ǔ pwǒ̤꤮ tôphuố cò́. ");
INSERT INTO kyu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Phúnuôrò nè̤ cuố sudyǎtuố̤ vǎ me̤tě? Sudyǎkuô̌ kayǎ dố a ní̤huô̌ vǎ tè̤dônyǎ nuôtahe kǒkǒ. Vǎ dônyǎ pé̤ èthǐ kryá꤮ me̤tě nuô, a thè́gně lò̌plǐ prè́,” Byacè Jesǔ héka̤khyěsû èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bí Byacè Jesǔ hé phúyě akhè̌nuô, klyěphú opò̤́ tè̤lǔhǒdu dố a ophû bí lǔkhǎshyé nuôtôprè̤ plyá̤ lǔ khǎlí̤shyé rò a hé lǔ, “Nè̤ cuố hésûtuố̤ bwídukhulố yětôprè̤ phúnuô me̤tě?” A hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Byacè Jesǔ hésû lǔ, “Vǎ ki hé thû́ hérò a thû́kryá꤮ ǐtěnuô, zṳ̌luô̌ pé̤myá vǎ, a ki tǒ hérò mame̤těrò nè̤ cuố plyá̤tuố̤ vǎ khǎlí̤shyé me̤tě?” A hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Htuô̌rò Anna cò̌klò̤ma pǎprè́ lǔ rò a nò̌thǔcuố ǔ ná Jesǔ dố bwídukhulố Caipha hé yětôprè̤ a o. ");
INSERT INTO kyu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simonè Petru iswílè̤ tadûpǎ mi bínuô. Rò kayǎ dố aruô tôprè̤ hé lǔ, “Nè̤ ma èkhǒpacè̤̌ vǎhéto?” A sudyǎ lǔ. Rò a hé ka̤khyěsû, “Vǎ má̤ náto.” ");
INSERT INTO kyu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Bwídukhulố a prè̤me̤tè̤phú dố apuố̤vyá̤ ná Petru pǎ̤tṳ̂̌ lǔ khǎlèkuố̤ nuôtôprè̤ sudyǎ lǔ, “Vǎ myáhtyenò́ nè̤ dố olivaphè tarè́kǔ nuôrò nè̤ otố̤kuô̌ ná Jesǔ vǎhéto?” A sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petru htésû bíkyǎ khyěthyá ná vǎ má̤to a héhtuô̌htuô̌ ná shyěphè̌ i-uhtya. ");
INSERT INTO kyu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yětôphuốrò Judaphú tahe o dố Caipha hi rò a è́cuố lahyǎ Byacè Jesǔ dố Roma Khwí Pilato hǒkǔ. Èthǐ è́cuố lǔ bí mò̤́lǐ ro̤mû́ akhè̌nuô. Judaphú tahe thè́zṳ̂́ o mwǒ̤plǐthǐplo lahyǎ ané̤ phú èthǐ tè̤cò́bè̌ lé̤klǒlé̤khya o nuô. Phúnuôrò èthǐ nuô̌ lahyǎ dố Khwí Pilato hǒkǔ to, me̤těhérò èthǐ ki nuô̌ hénuô, ǔ dyée èthǐ tè̤cuốtalwópwè̌ asèe mò̤́hé yěnuô to. ");
INSERT INTO kyu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Phúnuô akhu-akhyě, Khwí Pilato hte dố hǒklò̌ rò a myáhtye hébèsû ná èthǐ rò a sudyǎ èthǐ, “Thǐ cuố dyatè̤thû́ lǔ ná ǐtě akhu-akhyě tě?” ");
INSERT INTO kyu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Èthǐ hésû, “A ki me̤thû́ tè̤ to rò pè̤ è́hyǎ lǔ dố nè̤o takhyá꤮ to,” a hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Khwí Pilato hésû èthǐ, “È́ cuố ní̤dyédû lahyǎ rò cirya ní̤dyédû lahyǎ phú thǐ tè̤thyótè̤thya onuô.” Manárò Judaphú tahe hésû lǔ, “Pè̤ taryěshyosò̌ dố pè̤ bè cirya thyěkyǎ kayǎ nuô, a oto,” a hésû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A hé lahyǎ phúyě ma thyáphú a ki lốbǎhtya phú Byacè Jesǔ héone hékhokyǎ ná a kíré̤ thyě phútě tôcô pǎ nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Phúnuôrò Khwí Pilato nuô̌ dố ahǒkǔ rò a nò̌è́nuô̌ ǔ ná Byacè Jesǔ rò a sudyǎ lǔ, “Nè̤ ma Judaphú akhwí tôprè̤ má̤lakǒ è̌?” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Byacè Jesǔ hésû lǔ, “Yěma nè̤ tè̤tane̤ héhte ní̤dyédû è̌? Má̤torò kayǎ tôprè̤prè̤ hyǎdyá pé̤ nè̤ ná vǎrikyǎ è̌?” A sudyǎ ka̤khyěsû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Rò Khwí Pilato hé lǔ, “Nè̤ tane̤ vǎ ná Judaphú ò? Prè̤ dố a thǔhyǎ nè̤ dố vǎo tahe nuôma nè̤ myěcôphú ní̤dû ná nè̤ bwídukhu ní̤dû nuôtahe prè́. Nè̤ cuốme̤thû́ kryá꤮ ǐtětě?” Khwí Pilato sudyǎ lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Byacè Jesǔ hésû lǔ, “Vǎhtyěvǎké̤ ma bí hekhuyě má̤to. Ki a má̤ bí hekhuyě hénuô, thyáphú vǎ ki tuố̤dố Judaphú a khuklò́khuklyǎ yětahe a takhukǔ tǎmé̤ nuô, vǎkhǒ dố a krwǒkuô̌ vǎ tahe ki vû́sû htuô̌hò́ èthǐ kǒ. Phúnuôrò vǎhtyěvǎké̤ ma bí hekhuyěnuô má̤to.” A hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Khwí Pilato hé lǔ, “Ki héphúnuô hérò nè̤ htwǒ khwí tôprè̤ hò́ nuô̌?” A sudyǎ lǔ phúnuô. Byacè Jesǔ hésû lǔ, “Vǎ ma khwí tôprè̤ má̤lakǒ phú nè̤ hé nuôhò́. Thyáphú vǎ ki hésopé̤ ǔ ná tè̤má̤tè̤cò́ nuôrò, vǎ hyǎ opacè̤̌lya̤ dố hekhuyě hò́. Lò̌꤮ kayǎ okuô̌ dố tè̤má̤tè̤cò́ tôkyě tahenuô a ki ní̤dǎ vǎngó̤ pǎ.” A hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Khwí Pilato sudyǎ lǔ, “Tè̤má̤tè̤cò́ ma ǐtětě?” phúnuô. Rò Khwí Pilato htetǒ khyěthyá dố Judaphú yětahe a o rò a hé èthǐ, “Vǎ kíré̤ cirya è agněnuô vǎ myáhtye atè̤thû́ tôcô꤮ to.” A hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Manárò phú thǐ tè̤cò́bè̌ alé̤klǒ o ná bí thǐ me̤hò́ tè̤cuốtalwópwè̌ akhè̌nuô, vǎ plwǒhte pé̤ thǐ kayǎ tǎ̤ dố htò̌kǔ tôprè̤ pwǒ̤꤮ tôphuố. Phúnuôrò ma thǐ thè́zṳ̂́ plwǒhtekyǎ ‘Judaphú akhwídu yětôprè̤’ è̌?” A sudyǎ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Rò èthǐ è́htǒhtya lahyǎ, “Plwǒhte to. Plwǒhte dố Barabba nuô,” a hé lahyǎ phúnuô. Barabba ma prè̤pṳ̂́phe zè́plè́e ǔtè̤ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Phúnuôrò Khwí Pilato è́ Byacè Jesǔ rò a nò̌mṳ̂̌ ǔ ná suplye̤ iplí. ");
INSERT INTO kyu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Klyěphú tahe ikhu tava̤ thòshyámò̤́ thyáná khuklwǒ̤ nuôrò a klwǒ̤htya pé̤ ná Jesǔ. Rò a thyáhtya pé̤ lǔ ca̤cwo̤ taphèò́htǔ dố athyáná khwí lé̤thyá yětôba htuô̌rò, ");
INSERT INTO kyu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","a hyǎtǒ lǔ rò a hyǎhé ka̤khyěkhyě hyǎnyěnyělǔ, “Kố꤮ Juda akhwídu, ohtwǒprè̤ mò̤́nyě htǔdû ní꤮!” A hé lavilavò̌ kanǐkano htuô̌ lǔ phúnuô rò èthǐ plyá̤ lǔ khǎlí̤shyé. ");
INSERT INTO kyu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Khwí Pilato hyǎhte khyěthyá rò a hé Judaphú tahe, “Thyáphú thǐ ki thè́gně lahyǎ ná vǎ ce̤myá è rò vǎ myáhtye a me̤ tè̤thû́ tôcô꤮ to agněnuô, vǎ ki è́hteluô̌ pé̤ khyěthyá thǐ bíyě.” ");
INSERT INTO kyu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Byacè Jesǔ klwǒ̤htení̤ khuklwǒ̤ thòshyá rò thyáhtení̤ ca̤cwo̤ taphèò́htǔ tôba rò htetǒ èthǐ. Rò Khwí Pilato hé èthǐ, “Yělé, è ma kayǎ nuôtôprè̤ hò́.” A hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bwídukhu tahe ná klyěphú dố a opò̤́ tè̤lǔhǒdu tahe myáhtye lǔlǔ, “Mṳ̂̌thyěhtyakyǎ è dố krusu díkè hihtûlo̤ nuô, mṳ̂̌thyěhtyakyǎ è dố krusu díkè hihtûlo̤ nuô,” a è́htǒhtya lahyǎ phúnuô. Manárò Khwí Pilato hé èthǐ, “È́cuố ní̤dyédû lahyǎ rò mṳ̂̌thyěhtya ní̤dyédû lahyǎ dố hihtûlo̤ nuô. Dố vǎgně rò, tè̤thû́ dố vǎ ki cirya è nuô, vǎ ce̤myá è rò vǎ myáhtye tôcô꤮ to,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judaphú tahe hé tadû lahyǎ, “Pè̤ tè̤thyótè̤thya o ná è bèthyě prè́, me̤těhérò a dákwó lya̤ ní̤dyé ané̤ ná vǎ ma Cò́marya aphúkhǔ, a hé ní̤dyé ané̤ phúnuô.” A héhtya tadû lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Khwí Pilato ní̤huô̌ pó̤ ngó̤phúyě rò a lé thè́isě hyǎshyoshyo. ");
INSERT INTO kyu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A ka̤ kanuô̌ khyěthyá dố ahǒkǔ rò a nuô̌ sudyǎ Jesǔ, “Nè̤ obítě hyǎ?” Manárò Jesǔ héka̤khyěsû lǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Rò a hé Jesǔ, “Nè̤ héka̤khyěsû vǎ tôcô꤮ to me̤tě? Vǎ ní̤bè tè̤taryěshyosò̌ dố vǎ ki plwǒkyǎ nè̤ ma a ní̤ní̤, má̤torò vǎ ki mṳ̂̌thyěhtyakyǎ nè̤ dố hihtûlo̤ nuôma a ní̤ní̤ prè́ nuôma nè̤ thè́gně to è̌?” A hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Rò Byacè Jesǔ hésû lǔ, “Cò́marya ki dyétǎ̤ nè̤ taryěshyosò̌ yě tonuô, nè̤ ní̤bè cyá̤ to. Phúnuôrò kayǎ dố a dyétǎ̤kyǎ vǎ dố nè̤ takhukǔ yětahenuô, atè̤thû́ duklò̌lố pǎ cò́ ná nè̤.” ");
INSERT INTO kyu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cáhtya bí a héhtuô̌ phúnuô rò, Khwí Pilato yácû́ myápṳ̌ klyá dố a ki plwǒhtekyǎ Jesǔ. Manárò Judaphú tahe è́htǒ plehyǎ tadûpó̤, “Nè̤ ki plwǒhtekyǎ kayǎ nuôtôprè̤ héma, nè̤ ma Khwí Caesare akhǒbò́thyó má̤to. Kayǎ tôprè̤prè̤ dố a dákwó lya̤ ní̤dyé ané̤ ná khwí nuô, má̤hò́ kayǎ dố a htésû Khwí Caesare hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bí Khwí Pilato ní̤huô̌ èthǐ héphúyě akhè̌nuô, a è́hte Jesǔ rò a onyǎtǎ̤ dố tè̤cirya lé̤onyǎ khǎlé̤ dố ǔ è́, ǔ byáthye kayǎ lé̤cuố ná lò̤́. Hebreo ngó̤ ma a hé, Gabbatha. ");
INSERT INTO kyu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bínuô tônyě ma atǒ bí mò̤́htuôkhè̌ ǔ tari one tè̤cuốtalwópwè̌ agně nuôtônyě. Rò Khwí Pilato hé Judaphú tahe, “Yělé thǐkhwí,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Manárò èthǐ è́htǒhtya lahyǎ, “Me̤thyěkyǎ è, mṳ̂̌thyěhtyakyǎ lǔ dố krusu díkè hihtûlo̤ nuô.” Rò Khwí Pilato sudyǎ èthǐ, “Thǐ thè́zṳ̂́ nò̌ mṳ̂̌thyěhtyakyǎ vǎ ná thǐkhwíyě dố krusu díkè hihtûlo̤ è̌?” Rò bwídukhu tahe hé, “Pè̤ khwí oprè́tû́ Khwí Caesare tôprè̤ tuô̌. Pè̤khwí dố aruô ma a o tôprè̤꤮ to,” èthǐ hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dốkhyětadû rò Khwí Pilato dyétǎ̤kyǎ Jesǔ dố èthǐ atakhukǔ dố èthǐ ki mṳ̂̌thyěhtyakyǎ lǔ dố krusu díkè hihtûlo̤. Phúnuôrò klyěphú tahe pṳ̂́cuốkyǎ Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Rò a zácuố ní̤dyédû a krusu rò a htecuố dố khuklò́krwí akhǎlé̤. Khǎlé̤ yětôpho ma Hebreo ngó̤ hé, “Golgotha.” ");
INSERT INTO kyu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ǔ mṳ̂̌thyěhtyakyǎ lǔ dố krusu díkè hihtûlo̤ bínuô. Ǔ mṳ̂̌thyěhtya tố̤ lǔ ná kayǎ thè́nyě̤, tôkyě ná tôprè̤prè̤. Jesǔ rò a o dố aklǎměkǔ. ");
INSERT INTO kyu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Khwí Pilato nò̌rǎ ǔ tè̤mátè̤dyǎ aliplò rò a nò̌mṳ̂̌thyěhtya ǔ dố krusu díkè hihtûlo̤. Èthǐ rǎ liplòyě, “Judaphú tahe akhwí, vǐ̤ Nazarèphú Jesǔ” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ǔ mṳ̂̌thyěhtya Jesǔ yěnuô, a ophûprè́ ná vǐ̤ akhu-akhyě, Judaphú tahe hốmyá è́lǎ liyě. Rò liyěnuô ǔ rǎo lò̌plǐ ná Hebreo ngó̤ dố Judaphú hébè ní̤dyé yěnuô, ná Latin ngó̤ ná Greek myěcôphú angó̤. ");
INSERT INTO kyu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Prè̤lǔtyǎ khuklò́ tahe hé Khwí Pilato, “‘Judaphú tahe akhwí,’ rǎphúnuô tǎmé̤. Rǎ taple khyěthyá ná kayǎ yětôprè̤ ma a dákwólya̤ ní̤dyé ané̤ ná Judaphú tahe akhwí,” rǎ taple khyě phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Manárò Khwí Pilato hé lǔ, “Tè̤ dố vǎ rǎhtuô̌hò́ nuôma, a htuô̌hò́.” ");
INSERT INTO kyu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bí klyěphú tahe mṳ̂̌thyěhtya htuô̌hò́ lǔ dố hihtûlo̤ akhè̌nuô, klyěphú thè́lwǐ̤ yěnuô a phyé Byacè Jesǔ hyeca̤ tahe rò, a ibě ní̤dyé lǔ tôprè̤ tôba. Rò èthǐ phyé pó̤ lǔ ca̤cwo̤htǔ dố ǔ bò́cû̌ tǎ̤htǔplû́ prè́ lǔ rò ǔ lé̤isè́htû̌ lǔ oto yětôba. ");
INSERT INTO kyu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Èthǐ tôprè̤ ná tôprè̤ hé ní̤dyélǔ, “Pè̤ htò́zè̤̌ è to ha, ǔpě tǒ ní̤bèpě pǎnuô, pè̤ bò́ tè̤byǎbwí tôcô pó!” A hé ní̤dyé lǔ phúnuô. Thyáphú lisǎsè̌kǔ ki lốhtyabǎhtya rò tè̤htwǒ ané̤ phúyě prè́. Lisǎsè̌kǔ hé, “Èthǐ ibě phyé ní̤dyé lahyǎ vǎca̤ tahe hò́. Thyáphú èthǐ ki phyéní̤ vǎca̤ rò a bò́ lahyǎ tè̤byǎbwí hò́.” Rò klyěphú yětahenuô, a me̤ lahyǎ phúnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bí Byacè Jesǔ a krusu akhǎshyénuô, Byacè amuố̤ ná Byacè amuố̤ apuố̤prè̤mò, ná Clopa amě Maria ná Magdalena dò̌kǔmuố̤ Maria ihtò o lahyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Bí Byacè Jesǔ myáhtye amuố̤ ná a khǒpacè̤̌ dố a mo̤ ní̤dyé lǔ yětôprè̤ ihtò ophû ná lǔ akhè̌, a hé cuố amuố̤, “Muố̤꤮ khǒnyá̤yě kayǎ yětôprè̤ ma a htwǒhò́ nè̤phú hò́,” a hé cuố amuố̤ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Htuô̌rò a hé kuô̌ke a khǒpacè̤̌ nuôtôprè̤, “Khǒnyá̤yě vǎmuố̤rò a htwǒhò́ nè̤muố̤ hò́.” Cáhtya bínuô rò a khǒpacè̤̌ yětôprè̤ è́ka̤-o Byacè amuố̤yě dố ahi. ");
INSERT INTO kyu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","A héhtuô̌ phúnuô rò Byacè Jesǔ thè́gně ná a me̤htuô̌lò̌hò́ tè̤pwǒ̤꤮ tôcô hò́. Rò thyáphú lisǎsè̌ ki lốbǎhtya agněnuô, Byacè Jesǔ hé, “Vǎ thè́ǒ htyě” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Bínuô tôphonuô, htyězǎ̤shye o tôthǒ. Rò èthǐ klyacuốphyé tè̤tôcô dố athyáná phyáplyé rò a cuốcye̤nuô̌ dố htyězǎ̤shye thǒkǔ rò a cò̌klò̤ma dố thòphyǎ dố ǔ è́ ná hyssóphyǎyě alo̤ rò a tṳ́dyahtyatǒ dố Byacè a khǎulo̤. ");
INSERT INTO kyu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bí Byacè Jesǔ puô̤myá yě akhè̌nuô, a hé, “A htuô̌hò́.” Rò a khuklò́ tǎ̤ngò̤kyǎ, htuô̌rò a dyélya̤kyǎ athè́plò htwǒprè̤ dố Cò́marya a takhukǔ. ");
INSERT INTO kyu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bínuô tônyěnuô atǒ ná mò̤́nyě dố ǔ taritaryǎ one shyéparǒ Judaphú a Mò̤́nyěduô nuôtônyě agně. Mò̤́nyěduô yěnuôma má̤dû Mò̤́nyěduô dố a tǎ̤tǒ khódû bí pwè̌ dố ǔ è́ ná tè̤cuốtalwópwè̌ akhè̌nuô. Phúnuôrò Judaphú khuklò́du khusuhtǔ tahenuô, bí Mò̤́nyěduô akhè̌yě, èthǐ thè́zṳ̂́ dya-o luô̤̌to̤ yětahenuô dố krusu díkè hihtûlo̤ to. Thyáphú èthǐ ki thyěpryǎnuô rò, èthǐ cuố kwǐ Khwí Pilato dố a ki nò̌dòkè̤́kyǎ ǔ ná èthǐ nuôtahe akhapyǎ̤ rò ki phyétǎ̤kyǎ èthǐ dố krusu díkè hihtûlo̤. ");
INSERT INTO kyu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Phúnuôrò klyěphú tahe hyǎdòkè̤́ ré̤lố ǔ mṳ̂̌thyěhtya tố̤ná Jesǔ yěthè́nyě̤ aklè̌ tôprè̤. Htuô̌rò a cuố dòkè̤́ kuô̌pó̤ke a okyǎ nuôtôprè̤. ");
INSERT INTO kyu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Manárò bí èthǐ cuốtuố̤ dố Jesǔ o akhè̌nuô, èthǐ myáhtye ná a thyě htuô̌hò́ akhu-akhyě a dòkè̤́ lǔ khapyǎ̤ tôkhó꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Manárò klyěphú yětahe aklè̌ tôprè̤nuô, a sû̌ Jesǔ rò̤̌klè̌ ná tabyǎ rò tôphuốtuô̌ thwi ná htyě sátǎ̤hte. ");
INSERT INTO kyu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kayǎ dố a myáhtye a htwǒhtya phúyě tôprè̤nuô a hésoluô̌ pé̤ ǔ. Rò a héso luô̌tǒ pé̤ ǔ prè́. A thè́gně tǎ̤te̤ ní̤dyé ná a hé yěnuôma acò́ate̤ prè́. Thyáphú thǐ ki zṳ̂́e kuô̌ǔ nuô, a hésoluô̌ pé̤ thǐ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Thyáphú lisǎsè̌ ki lốbǎhtya agněnuô, tè̤yětahe htwǒhtya hò́. Lisǎsè̌kǔ hé, “Akrwí ki lakè̤́ní̤ tôbǒ꤮ to,” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Lisǎsè̌ dố aruôtôpho hé pó̤, “Èthǐ sû̌ ní̤dyélǔ ná tabyǎ yětôprè̤nuô, èthǐ ki myá lǔ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Htuô̌rò vǐ̤ Arimatheaphú Joseph cuốkwǐ Jesǔ aluô̤̌to̤ yě dố Khwí Pilato a o. Joseph ma Byacè Jesǔ a khǒpacè̤̌ tôprè̤, manárò a yǒ thè́isě Judaphú tahe alé̤ akhu-akhyě a htwǒhuôhtwǒthwè́ prè́ lǔ khǒpacè̤̌ prè́. A cuốkwǐ Khwí Pilato yěnuô, a cṳ̌ lǔ rò a hyǎ phyédwó cuốkyǎ Byacè aluô̤̌to̤ yě. ");
INSERT INTO kyu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo krwǒcuốkuô̌ ná è. Kayǎ dố a hyǎ olě kuô̌ Byacè Jesǔ dố mò̤́khíkhè̌ dố aré̤khè̌ nuôtôprè̤ ma Nicodemo hò́. A phyéhyǎní̤ lé̤plò̤́ nuô̤mû́ nyě̤cô dố ǔ è́, myrra ná alósa. A lya̤htuônuô, a phû꤮ o cò́ nyě̤shyě ná nyǎ̤cwè̤́ cò́. ");
INSERT INTO kyu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Èthǐ yěthè́nyě̤ phyé Jesǔ a luô̤̌to̤yě rò a bo talǔ ná ikè̤̌ báplǐ tôba rò a bobí talǔ tố̤ lǔ ná tè̤nuô̤mû́ nuôtahe. Judaphú alé̤klǒ iluố luô̤̌ nuôma a me̤ lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Bí ǔ lé̤mṳ̂̌thyěhtya Jesǔ dố krusu díkè hihtûlo̤ akhǎshyénuô, prè́ o tôlé̤. Dố prè́ nuôtôlé̤ akǔnuô, ǔ ikhûkǔnuô̌ othè̌ luô̤̌kǔ tôkǔ dố lò̤́kǔ, rò ǔ iluốnò́ hí ná luô̤̌tôprè̤꤮ híto. ");
INSERT INTO kyu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bínuô tônyěnuô atǒ ná mò̤́nyě dố ǔ taritaryǎ one shyéparǒ Judaphú a Mò̤́nyěduô nuôtônyě, htuô̌to luô̤̌kǔ yǒ ophû bínuô tôkǔ akhu-akhyě, èthǐ cuố iluốnuô̌kyǎ lǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Judaphú a Mò̤́nyěduô htuô̌ anotôrǒ mò̤́lǐ ro̤mû́ mò̤́khíò́pǎ akhè̌nuô, Magdalena dò̌kǔmuố̤ Maria hyǎ dố luô̤̌khu rò a myáhtye ná lò̤́du dố ǔ htulò̌bí lǔ ná luô̤̌kǔ nuôtôměnuô ǔ htulò̌taphǎ cuốkyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Rò a klyaka̤ dố Simonè Petru ná Jesǔ a khǒpacè̤̌ dố a mo̤ ní̤dyé lǔ dố aruôtôprè̤ a o rò a héso pé̤ èthǐ, “Èthǐ phyécuốkyǎmé̤ hò́ Byacè nuô dố luô̤̌kǔ hò́. Èthǐ cuốdya-otǒ lǔ bítě꤮ nuô pè̤ thè́gně to.” ");
INSERT INTO kyu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yětôphuốrò Petru ná Byacè a khǒpacè̤̌ dố aruô tôprè̤ klyahyǎ lahyǎ dố luô̤̌khu. ");
INSERT INTO kyu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Èthǐ klyahyǎ pró̤ lǔ prè́ tadû́rò Byacè a khǒpacè̤̌ dố aruô yětôprè̤ klyapryǎklò̌ ná Petru akhu-akhyě, a klyahyǎ tuố̤ré̤klò̌ lǔ dố luô̤̌khu. ");
INSERT INTO kyu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A hyǎ ngò̤myácǒnuô̌ dố luô̤̌kǔ rò a myáhtye ikè̤̌ báplǐhtǔ yě okyǎ bínuô, manárò a hyǎnuô̌ dố akǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yětôphuốrò Simonè Petru dố a klyahyǎ tǎ̤no dố lǔkhyěkhu yětôprè̤ hyǎtuố̤ rò a hyǎnuô̌ dố luô̤̌kǔ. Rò a myáhtye ikè̤̌ báplǐhtǔ nuôtôba okyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Htuô̌rò a myáhtye tuố̤kuô̌ khuhtǒ dố ǔ bobí pé̤ ná Byacè Jesǔ akhuklò́ nuôtôbaba. A khuhtǒphú yětôbanuô a otố̤kuô̌ ná ikè̤̌ báplǐhtǔ nuôtôba to. A botalǔ kyǎ khódû tôpho. ");
INSERT INTO kyu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dốkhyě rò a khǒpacè̤̌ dố a klyahyǎ tuố̤ré̤ dố luô̤̌khu yětôprè̤ hyǎnuô̌ dố akǔ. A hyǎ myáhtye rò a zṳ̂́e ná Jesǔ htwǒprè̤ ka̤khyě hò́. ");
INSERT INTO kyu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Lisǎsè̌ héone cò́hò́, Byacè Jesǔ ki thyě ihtòka̤khyě pǎ tadû́rò, tuố̤ cò́hò́ bínuôkhè̌nuô, phú lisǎsè̌ héone yěnuô, a khǒpacè̤̌ tahe thè́gněplǒ híto. ");
INSERT INTO kyu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Htuô̌rò èthǐ yěthè́nyě̤ ka̤khyě lahyǎ dố ahi. ");
INSERT INTO kyu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Manárò Maria rò a ihtò okyǎ bí luô̤̌kǔhtû̌nuô rò a nguố̤. Bí a nguố̤ khè̌, a ngò̤ takò̤ myácǒnuô̌ dố luô̤̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Rò a myáhtye mò́khu tanéphú thyání̤ hyeca̤bǔ thè́nyě̤ onyǎo dố Jesǔ luô̤̌to̤ lé̤o nuô. Tôprè̤ rò a o dố a khuklò́htè́ tôkyě, tôprè̤ rò a o dố a khǎzó̤ tôkyě. ");
INSERT INTO kyu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Rò èthǐ sudyǎ Maria, “Mòmuố̤, nè̤ nguố̤ me̤tě?” Rò Maria hé ka̤khyěsû èthǐ, “Èthǐ phyécuốkyǎmé̤ hò́ vǎ Byacè hò́, èthǐ cuốdya-o tǒ lǔ bítěnuô vǎ thè́gněto,” a hésû phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bí a tarí ka̤khyě akhè̌nuô, a myáhtye Byacè Jesǔ kahtòo dố lǔkhyěkhu tadû́rò a thè́gně ná Byacè Jesǔ má̤to. ");
INSERT INTO kyu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Mòmuố̤꤮, nè̤ nguố̤ me̤tě? Nè̤ myápṳ̌ ǔpě?” A sudyǎ lǔ phúnuô. Maria tane̤tyá̤ Byacè Jesǔ ná prè̤opò̤́ myákhwè tarè́ rò a hé lǔ, “Vyá̤, nè̤ ki phyécuố lǔ hérò nè̤ cuốdya-o tǒ lǔ bítě tôphonuô, héluô̌ pé̤ vǎ rò vǎ ki cuốphyékhyě è,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Maria,” Byacè Jesǔ hé lǔ phúnuô. Rò a tarí cuốtǒ lǔ rò a hésû lǔ ná Hebreo ngó̤ rò a hé, “Rabboni꤮.” (Angó̤lasá ma Thárá) ");
INSERT INTO kyu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Rò Byacè Jesǔ hé lǔ, “Pṳ̂́ tǎ vǎ mé̤, me̤těhérò vǎ ka̤ dố vǎphè̌ o híto. Cuố dố vǎ puố̤vyá̤ nuôtahe a o rò cuốhé pé̤ èthǐ, ‘Vǎ ki ka̤kahtya dố vǎphè̌ ma amá̤má̤, thǐ phè̌ ma amá̤má̤, vǎ Cò́marya ma amá̤má̤, thǐ Cò́marya ma amá̤má̤ yětôprè̤ a opǎ’” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdalena dò̌kǔmuố̤ Maria yě cuố dyásopé̤ a khǒpacè̤̌ tahe ná tè̤ritè̤kyǎ yě rò a hé pé̤ èthǐ, “Vǎ myáhtyehò́ Byacè hò́!” Rò a héluô̌ pé̤ èthǐ ná Byacè hé pé̤ lǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Bí Judaphú a Mò̤́nyěduô mò̤́katò̤ nuôtônyě htuô̌ shyéparǒ tônyě mò̤́khípaló̤ akhè̌nuô, a khǒpacè̤̌ tahe thè́isě lahyǎ Judaphú a khuklò́du tahe alé̤ rò a me̤ma lahyǎ kadǎ, rò bí èthǐ oplò́ tố̤lǔ dố hidò́kǔ akhè̌nuô, Byacè Jesǔ hyǎihtò oluô̌khyé pé̤ dố èthǐ klǎměkǔ rò a hé èthǐ, “Tè̤thè́plò kacṳ́kabè́ ki okuô̌dû ná thǐ ní꤮,” a hé èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A héhtuô̌ pé̤ èthǐ phúnuôrò a dyéluô̌ pé̤ èthǐ ná atakhu ná arò̤̌klè̌. Bí a khǒpacè̤̌ tahe myáhtye lǔ akhè̌nuô, a thè́krṳ̂̌thè́lò̌ tapa̤ lahyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Byacè Jesǔ hé khyěthyá èthǐ, “Tè̤thè́plò kacṳ́kabè́ ki odû ná thǐ ní꤮! Rò phú vǎphè̌ nò̌hyǎ vǎ nuô, vǎ nò̌cuốkuô̌ thǐ.” ");
INSERT INTO kyu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A héhtuô̌ phúnuôrò a thè́cuố dố èthǐkhu rò a hé èthǐ, “Phyésû lahyǎ Thè́ Sǎsè̌ Byacè yě. ");
INSERT INTO kyu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Thǐ ki plwǒkyǎ ǔtè̤thû́ tahe hérò ǔtè̤thû́ ki plwǒkyǎ pǎ. Thǐ ki plwǒkyǎ ǔtè̤thû́ to hérò, ǔtè̤thû́ ki plwǒkyǎ to.” ");
INSERT INTO kyu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Bí Jesǔ cuốnuô̌ oluô̌ pé̤ a khǒpacè̤̌ dố hikǔ akhè̌nuô, Thomazo dố ǔ è́pó̤ lǔmwi̤ ná Didymo yětôprè̤ okuô̌ ná èthǐ bínuô to. ");
INSERT INTO kyu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","A khǒpacè̤̌ yětahe hé Thomazo, “Pè̤ myáhtyehò́ Byacè hò́,” a hé pé̤ lǔ phúnuô. Manárò a hésû èthǐ, “Vǎ ki myáhtye lipana akhǎlé̤ cwè̌okyǎ dố a takhukǔ to, htuô̌rò vǎ ki kaǔbèní̤ lipana cwè̌khǎlé̤ ná vǎ kanò̌ to, vǎ ki phû̌bèní̤ arò̤̌klè̌ acwè̌ ná vǎ takhu to hénuô, vǎ zṳ̂́eto.” ");
INSERT INTO kyu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dốkhyě thuô̌thyótônyěnuô, Byacè Jesǔ a khǒpacè̤̌ tahe oplò́ tố̤khyělǔ dố hinuô tômě akǔ. Bínuôakhè̌ Thomazo otố̤kuô̌ ná èthǐ bínuô. Èthǐ me̤ma kadǎ tadû́rò Byacè Jesǔ hyǎnuô̌ ihtòo dố èthǐ klǎměkǔ rò a hé èthǐ, “Tè̤thè́plò kacṳ́kabè́ ki okuô̌dû ná thǐ ní꤮” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yětôphuốrò a hé Thomazo, “Hyǎmyámò̌ vǎ takhukǔyě, hyǎ rò kaǔmyádû ná nè̤ kanò̌ nuô. Zó̤hyǎ nè̤ takhunuô rò phû̌myádû vǎ rò̤̌klè̌ acwè̌yě. Thè́plò rare tǎmé̤. Tarú zṳ̂́enuô.” A hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","“Vǎ Byacè, vǎ Cò́marya,” Thomazo hésû lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Htuô̌rò Byacè Jesǔ hé lǔ, “Nè̤ yǒ myáhtye vǎ khukhyěrò nè̤ zṳ̂́e prè́. Kayǎ dố a myáhtye vǎ to rò a zṳ̂́e tahenuô a ki ní̤bè tè̤sò̌ri,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Byacè Jesǔ dyéluô̌ pé̤ tè̤me̤ tè̤pro̤tè̤prya̤ dố a khǒpacè̤̌ tahe anyěhyǎ dố ǔ rǎmánuô̌ tố̤ bí li yětôba akǔ to tahenuô a oè́lǎ pǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Manárò ǔ rǎo li yětôba ma thyáphú thǐ ki zṳ̂́e ná Jesǔ ma Messia, è ma Cò́marya aphúkhǔ tôprè̤, rò dố thǐ zṳ̂́e lǔ akhu-akhyěrò, thǐ ki ní̤bè thè́htwǒprè̤ agněnuô, ǔ rǎ pé̤ thǐ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dốkhyě nyě̤tyato nuô, Byacè Jesǔ oluô̌htya pé̤ a khǒpacè̤̌ tahe dố Tiberia htyěòduhtû̌. A oluô̌htya pé̤ lǔ phútě hérò, ");
INSERT INTO kyu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simonè Petru, Thomazo dố ǔ è́pó̤ lǔmwi̤ ná Didymo, ná Galilea ké̤ vǐ̤ Cananphú Nathanael ná Zebedeo aphúprè̤khǔ thè́nyě̤ ná Jesǔ a khǒpacè̤̌ dố aruô thè́nyě̤ cuố oplò́ ró̤lò̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simonè Petru hé èthǐ, “Vǎ cuốpṳ̂́e tè̤̌,” a hé rò, èthǐ hé lǔ, “Pè̤ cuốkuô̌ ná nè̤,” a hé lǔ phúnuô. Phúnuôrò èthǐ sidyání̤ thòklyě rò htecuố pṳ̂́e lahyǎ tè̤̌ tadû́rò tôthè̌꤮ tôthè̌ a ní̤ tôbè꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mò̤́lǐbǔhò́ rò Byacè Jesǔ ihtòo dố htyěhtû̌ nuô, manárò a khǒpacè̤̌ tahe thè́gně ná Jesǔ má̤to. ");
INSERT INTO kyu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","A sudyǎ èthǐ, “Khǒbò́thyó thǐ, tè̤̌ ní̤ sálé̤ è̌?” Rò èthǐ hésû lǔ, “Aní̤ tôbè꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Rò Jesǔ hé èthǐ, “Vǐtǎ̤ thǐ itavǐ dố thǐ thòklyě cò́htwó nuôtôkyě, tè̤̌ ní̤dû pǎ.” Rò bí èthǐ me̤phú a hé akhè̌nuô, tè̤̌ní̤ è́nyacò́ akhu-akhyě, a cwihtya pé̤ ní̤dyé pǎ cò́ a itavǐ dố thòklyěkǔ to. ");
INSERT INTO kyu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yětôphuốrò Jesǔ a khǒpacè̤̌ dố a mo̤ ní̤dyé yětôprè̤ hé Petru, “È ma Byacè nuô꤮” a hé pé̤ lǔ phúnuô. Bí Simonè Petru ní̤huô̌ lǔ hé, “È ma Byacè nuô꤮,” phúnuô akhè̌, tôphuốtuô̌ a thyáhtya khyěthyá aca̤ dố a plwókyǎ lǔ nuôtôba htuô̌rò a pá̤tǎ̤ dố htyěkǔ. ");
INSERT INTO kyu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A khǒbò́thyó dố a okyǎ dố thòklyěkǔ yětahenuô, a krwǒkhyǎka̤ kuô̌ lǔ. Èthǐ khyǎ cwitarṳ́ ka̤ní̤ itavǐ dố a ní̤bǎ ná tè̤̌ yěnuôtôba dố htyěhtû̌. Èthǐ oye̤ lǎ ná htyěhtû̌ to, a oye̤ prè́ aplè̤́ nyě̤zè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bí èthǐ ka̤bá ohò́ athòklyě dố khǒlǒkhu akhè̌nuô, èthǐ myáhtye ǔ isû́e tè̤̌ dố miklwókhu htuô̌ná khò́mǔ tahe. ");
INSERT INTO kyu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Byacè Jesǔ Krístu hé èthǐ, “Phyé hyǎpé̤myá vǎ tè̤̌ dố thǐ pṳ̂́ní̤ nuôtôklò́ bíyě tahe.” ");
INSERT INTO kyu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Rò Simonè Petru cuốhtyanuô̌ dố thòklyěkǔ rò a cwitarṳ́htya itavǐ dố a ní̤bǎ ná tè̤̌yě dố khǒlǒkhu. Lò̌꤮ tè̤̌bèdu dố a ní̤ nuôma a o tôzè̤ ná nyǎ̤shyě ná thuô̌bè. Tè̤̌ ní̤ è́nyacò́ tadû́rò itavǐ lazè̤̌ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Byacè Jesǔ hé èthǐ, “Hyǎ emò̌ lahyǎ.” Èthǐ thè́gněhò́ lahyǎ ná è ma Byacè Jesǔ akhu-akhyě, “Nè̤ ma ǔpě?” Èthǐ sudyǎ bû lahyǎ lǔ tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Byacè Jesǔ phyéní̤ khò́mǔ rò a cuốtǒ èthǐ rò a zṳ́e pé̤ èthǐ. Rò a phyéní̤ tè̤̌ rò a cuố zṳ́e pé̤kuô̌ èthǐ phúnuônuô. ");
INSERT INTO kyu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Byacè Jesǔ thyě ihtòhtwǒprè̤ ka̤khyě htuô̌rò a dyéluô̌ pé̤ ané̤ ná a khǒpacè̤̌ tahenuô, yě ma thuô̌phuốtôphuố hò́. ");
INSERT INTO kyu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Èthǐ e htuô̌rò, Byacè Jesǔ sudyǎ Simonè Petru, “Giovanni aphúkhǔ Simonè, nè̤ mo̤klò̌ má̤lakǒ vǎ ná kayǎ yětahe mo̤ vǎ nuô è̌?” A sudyǎ lǔ. Rò Simonè hésû lǔ, “Ò, Byacè, vǎ mo̤ nè̤ nuôma nè̤ thè́gnědû hò́,” a hé lǔ phúnuô. Byacè Jesǔ hé lǔ, “Myá buôení̤ vǎ thímíphú nuôtahe ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Rò Byacè Jesǔ sudyǎ khyěthyá lǔ, “Giovanni aphúkhǔ Simonè, nè̤ mo̤ má̤lakǒ vǎ è̌?” A sudyǎ lǔ. Rò a hésû Byacè, “Ò, Byacè, vǎ mo̤ nè̤ nuôma nè̤ thè́gnědûhò́.” Rò Byacè Jesǔ hésû lǔ, “Myákhwèní̤ vǎ thímídu nuôtahe ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Htuô̌rò a sudyǎ pó̤ lǔ thuô̌phuốtôphuố, “Giovanni aphúkhǔ Simonè, nè̤ mo̤ vǎ è̌?” Byacè Jesǔ yǒ sudyǎ lǔ, “Nè̤ mo̤ vǎ è̌?” nuô thuô̌phuốhò́ akhu-akhyě, a mo̤ lǔthè́plò to. Rò a hésû lǔ, “Byacè, nè̤ thè́gně lò̌ tè̤pwǒ̤tôcô, vǎ mo̤ nè̤ nuôma nè̤ thè́gně hò́,” a hé lǔ phúnuô, Rò Byacè Jesǔ hé lǔ, “Myá buôebuôǒní̤ vǎ thímídu nuôtahe ní꤮. ");
INSERT INTO kyu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Vǎ hécò́cò́ nè̤, bí nè̤ nacè̤́pǎ akhè̌, nè̤ nyá̤htyabè́ ní̤dyédû nè̤nyá̤htò́, nè̤ thè́zṳ̂́cuố bítě꤮ nuô nè̤ cuốbè́. Manárò shyé꤮ nè̤ muố̤prè̤́hò́ pǎnuô, nè̤ ki zó̤hte nè̤ takhu nyě̤khó pǎ. Ǔ ki cò̌klò̤ma nè̤ takhu rò ǔ ki cò̤̌cuố nè̤ dố khǎlé̤ dố nè̤ thè́zṳ̂́ cuố to nuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Byacè Jesǔ hé lǔ phúyě nuôma, a thè́ héluô̌ lǔ ná Petru ki thyě phútě pǎ rò Cò́marya alǐatakhè̌ ki oluô̌htya phútě pǎ agněnuô prè́. Htuô̌rò Byacè Jesǔ hé lǔ, “Krwǒ vǎkhyě.” ");
INSERT INTO kyu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bí Petru myáka̤khyě akhè̌nuô, a myáhtye Byacè Jesǔ a khǒpacè̤̌ dố a mo̤dyé lǔ nuôtôprè̤ krwǒkuô̌ èthǐkhyě. (È ma prè̤ dố a o taterè̤̌ Byacè Jesǔ bí èthǐ esèe mò̤́hé akhè̌ nuôtôprè̤ hò́, rò a sudyǎ lǔ, “Byacè, ǔpě kíré̤ isè̌tǎ̤kyǎ nè̤ pǎ pě?” nuôtôprè̤ hò́. Yěma Byacè Jesǔ thyěhíto akhè̌) ");
INSERT INTO kyu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","bí Petru myáhtye lǔ akhè̌nuô, a sudyǎ Jesǔ, “Byacè, èkuô̌lě, a ki htwǒhtyakuô̌ phútě pǎ?” A sudyǎ Jesǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Byacè Jesǔ hésû lǔ, “Vǎ ki thè́zṳ̂́ nò̌ohtwǒprè̤ tuố̤ lǔ dố vǎ hyǎpǎ kihérò, cṳ́ vǎ prè́. Nuôma nè̤ tè̤me̤ má̤to, nè̤ tè̤me̤ ma nè̤ bè krwǒkuô̌ vǎ prè́,” a hé lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dố Byacè Jesǔ hé phúyě akhu-akhyě, ngó̤ luô̌pasǐcuố bò̌byelò̌ dố puố̤vyá̤ prè̤zṳ̂́etè̤phú tahe aklè̌ ná a khǒpacè̤̌ nuôtôprè̤ a thyěto hénuô̌, a hé lahyǎ phúnuô. Manárò Byacè Jesǔ hé ná a thyěto phúnuô má̤to. A hé, “Vǎ ki thè́zṳ̂́ nò̌ohtwǒprè̤ tuố̤ lǔ dố vǎ hyǎpǎ kihénuô rò cṳ́ vǎ prè́, nuôma nè̤ tè̤me̤ má̤to,” a hé phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Prè̤ rǎmárǎdyǎ tè̤ yětahe ma vǎ dố a htwǒ Byacè Jesǔ a khǒpacè̤̌ yětôprè̤ prè́, rò a myáhtye lò̌lò̌꤮ tè̤me̤htwǒhtya ané̤ yětahe rò a rǎmárǎdyǎ prè́. A tè̤hésoluô̌ pé̤ yětahe nuôma atǒ lò̌ prè́ nuô pè̤ thè́gně. ");
INSERT INTO kyu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Khǒnyá̤yě, Byacè Jesǔ me̤tè̤ dố aruô tahenuô a oè́lǎpǎ. Ki rǎmárǎdyǎ lò̌lò̌꤮ a me̤ nuôtahe hénuôma, vǎ tane̤ ná hekhuyě tôbalò̌ cò́nuô, lé̤dyali akhǎlé̤ pòpǎ cò́to hò́.");
INSERT INTO kyu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Thárádu Theophilo, cáhtya bí Byacè Jesǔ me̤ Cò́marya atè̤me̤ nuôtônyě rò a tuố̤dố Cò́marya è́ka̤ kahtya lǔ nuôtônyě ari-akyǎ ná a tè̤ithyóithya lò̌꤮ plǐ tahenuô vǎ rǎmárǎdyǎ htuô̌lò̌hò́ dố li aré̤lố nuôtôba akǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Bí ǔ è́ka̤ kahtya tyahí è dố mò́khu híto nuô, dố Thè́ Sǎsè̌ Byacè a tè̤pro̤tè̤prya̤ akhu-akhyěrò a mekyǎ a Prè̤dônyǎphú dố a nwóhtya htuô̌hò́ lǔ nuôtahe ná èthǐ ki bè me̤tè̤ tahe ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A khyáthyěhtuô̌ ané̤ rò a ihtòhtwǒprè̤ ka̤khyě dố tè̤thyě htuô̌rò dốkhyě anyě lwǐ̤shyě akǔnuô, a dyéluô̌ pé̤ ané̤ ná a khǒpacè̤̌ tahe è́phuốlǎ, htuô̌rò a hésodônyǎ pé̤ èthǐ ná Cò́marya ahtyěaké̤ ari-akyǎ. A khǒpacè̤̌ tahe myáhtye è rò athè́plò rare pǎ lahyǎ to. Èthǐ zṳ̂́e sǎprè̤́nyacè̌ cò́ ná a htwǒprè̤ má̤lakǒ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tôphuốkhè̌ bí a eǒ tố̤kuô̌ ná a khǒpacè̤̌ yětahe akhè̌nuô, a mekyǎ èthǐ, “Htecuốkyǎ tǎ lahyǎ hí dố Jerusalem vǐ̤yě akǔnuô tǎ hímé̤. Opò̤́tadû lahyǎ bínuô tuố̤dố thǐ ní̤bè shyězṳ́ dố vǎ héso-one htuô̌hò́ thǐ ná vǎphè̌ ò́lya̤ dố a ki dyé thǐ pǎnuô ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Htuô̌to a hépó̤ èthǐ, “Giovanni plwǒ pé̤ ǔ ná htyě, manárò nyě̤tyato pǎnuô ǔ ki plwǒ pé̤ thǐ ná Thè́ Sǎsè̌ Byacè pǎ.” ");
INSERT INTO kyu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bí Prè̤dônyǎphú tahe hyǎ myáhtye tǎ̤sû khyěthyá lǔ dố Jesǔ o akhè̌nuô, a sudyǎ Jesǔ, “Byacè, khǒnyá̤yěma shuốkhè̌ bèhò́ dố nè̤ kíré̤ dyéka̤khyě hò́ Israelphú tahe ahtyěké̤ nuô hò́ è̌?” ");
INSERT INTO kyu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Rò Jesǔ hésû èthǐ, “Tè̤shuốtè̤khè̌ ná mò̤́nyěmò̤́thè̌ tahe nuôma a htwǒhtyadû ná phè̌ a taryěshyosò̌ prè́. A ki htwǒhtya bíkhè̌tě pǎ nuôma, thǐ lo thè́gně má̤to. ");
INSERT INTO kyu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Manárò bí Thè́ Sǎsè̌ Byacè hyǎlya̤hò́ dố thǐlo̤ pǎ akhè̌nuô, thǐ ki lốbǎ ná tè̤shyotè̤sò̌ pǎ rò thǐ ki htwǒhtya pé̤ vǎ prè̤khyáthè́ tahe dố vǐ̤ Jerusalem akǔ, ná Juda tôké̤꤮ lè̤̌, ná Samaria ké̤ htuô̌to a ki tuố̤ cò́dố hekhusǐba lò̌ cò́ pǎ,” a héphúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jesǔ hébè htuô̌rò bí a khǒpacè̤̌ tahe tṳ́htyamyá è akhè̌nuô, Cò́marya è́ka̤ kahtyakyǎ lǔ dố mò́khu. Ò́luố̤ tôba kuô̌bíkyǎ lǔ rò èthǐ myáhtye pǎ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bí èthǐ tṳ́htya sǒtapa̤ pǎ dố mò́lè̤̌ akhè̌nuô, kayǎthè́nyě̤ kû̌thyání̤ hyeca̤bǔ rò hyǎokahtò htyaluô̌khyé pé̤ dố èthǐ akhǎshyé. ");
INSERT INTO kyu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Rò a hé èthǐ, “Galileaphú thǐ꤮ thǐ cuố ihtòo tṳ́htya lahyǎ dố mò́lè̤̌ bíyě me̤tě? Jesǔ dố thǐ myáhtye ǔ è́ka̤ kahtyakyǎ è dố mò́khu yětôprè̤nuô a ki hyǎlya̤ thyá khyěthyá phú thǐ myáhtye a ka̤kahtya khǒnyá̤yěnuô pǎ.” ");
INSERT INTO kyu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Htuô̌rò a khǒpacè̤̌ tahe o dố Oliva sokhu rò a ka̤khyě khyěthyá lahyǎ dố vǐ̤ Jerusalem. Vǐ̤ Jerusalem yěnuôma a oye̤ ná soyě aklǐ zè̤thuô̌thyó ná shyéthuô̌thyó prè́. ");
INSERT INTO kyu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Èthǐ ka̤tuố̤ dố vǐ̤ Jerusalem akǔ rò a cuốhtyanuô̌ dố hi dố èthǐ lé̤cuốokuố ní̤dyé taplô̤taplyáphú yěnuôtômě dố akhunuô tôtó̤. Rò èthǐ yětahema kryá꤮ ǔpě hérò Petru, Giovanni, Jakomo, Andrea, Philipu, Thomazo, Bartholomeo, Matteo, Alphaeo aphúkhǔ Jakomo, Simonè dố a mo̤ ní̤dyé ahtyěaké̤ yětôprè̤ ná Jakomo aphúkhǔ Juda thǐtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Èthǐ yětahenuô a hyǎ myáhtye tǎ̤sû tǎ̤plò́ tamǒmǒ ná prè̤mò dố aruôtahe ná Jesǔ amuố̤ Maria ná Jesǔ a puố̤prè̤khǔ tahe rò èthǐ kwǐcò́bè̌ ró̤lò̌ lǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tônyěkhè̌nuô, prè̤zṳ̂́etè̤phú dố a phû꤮ o aprè̤ tôzè̤nyě̤shyě yěnuô a hyǎ okúokyá lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Rò Petru ihtòhé, “Puố̤vyá̤ thǐ꤮, lisǎsè̌ héone htuô̌hò́ Juda dố a zṳ̌ pé̤ ǔ klyá rò a nò̌pṳ̂́ ǔ ná Jesǔ yě ari-akyǎ. Rò Thè́ Sǎsè̌ Byacè nò̌hébè Khwí Davi ná èrièkyǎ yětahe nuôma a tǒbè lốhtyabǎhtya nyǎ prè́. ");
INSERT INTO kyu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","È ma a otố̤nò́kuô̌ dố pè̤ aplò́amṳkǔ tôprè̤ rò ǔ nwóhtya kuô̌ è dố a ki me̤tố̤kuô̌ tè̤ ná pè̤.” ");
INSERT INTO kyu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Rû̌ dố Juda me̤ní̤ dố tè̤mǔmyá̤ricyá̤ akǔ yěnuô a ipri̤ ná prè́ tôlé̤ rò a latǎ̤thyě hò́pò̤́phè́ dyé bínuô rò aphuô̌aprǎ̤ tahe tǎ̤hte lò̌. ");
INSERT INTO kyu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kayǎ o dố vǐ̤ Jerusalem tahe ní̤huô̌ lahyǎ tè̤me̤-ané̤ yě rò a è́ lahyǎ khǎlé̤ yětôpho amwi̤ ná angó̤ ní̤dû. Rò èthǐ è́ ná “Akeldama,” angó̤lasá ma a hé ná “Tè̤thwi ké̤lá̤khu”) ");
INSERT INTO kyu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ǔ rǎo dố Li Htuthè́htya akǔnuô rò a hé, ‘Ahi ki oryá̤kyǎ dû pǎ ní꤮ ǔ ki nuô̌o tǎ dố hiyě akǔnuô tôprè̤꤮ tǎmé̤ ní꤮.’ “Htuô̌rò a hépó̤, ‘Ǔ ki nuô̌me̤dû akhǎlé̤ tôprè̤ pǎ ní꤮.’ ");
INSERT INTO kyu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Phúnuôrò kayǎ tôprè̤prè̤ tǒbè nuô̌ otố̤kuô̌ ná pè̤ rò a ki khyá kuô̌ athè́ ná Byacè Jesǔ thyěihtò htwǒprè̤ ka̤khyěyě ari-akyǎ. Kayǎ dố pè̤ kíré̤ nwóhtya taple è yětôprè̤ nuôma, bí Jesǔ cuốtố̤khè̌tố̤ kuô̌pǎ ná pè̤ bí hekhuyě akhè̌, htuô̌to cáhtya bí Giovanni plwǒ pé̤ ǔ htyě tuố̤ hyǎ dố Cò́marya è́ka̤ kahtyakyǎ Byacè Jesǔ dố mò́khunuô, è ma bínuôkhè̌ a tǒbè má̤dû kayǎ dố a otố̤cuốtố̤ kuô̌ ná pè̤ pwǒ̤꤮ phuố tôprè̤,” Petru hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Rò èthǐ hésoluô̌htya kayǎ thè́nyě̤ dố amwi̤ ná Joseph, kayǎ tahehe è́ lǔ ná Barsabba (Má̤torò Justo) ná Mathia. ");
INSERT INTO kyu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Htuô̌rò èthǐ kwǐcò́bè̌ lahyǎ, “Kố꤮ Byacè꤮ nè̤ thè́gně dûhò́ kayǎ thè́plò a tè̤tane̤ tahe akhu-akhyě, dố kayǎ yěthè́nyě̤ aklè̌nuô nè̤ nwóhtya htuô̌hò́ è bítě tôprè̤, ");
INSERT INTO kyu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","htuô̌to kayǎ dố nè̤ nwóhtya htuô̌hò́ è yětôprè̤ thyáphú a ki phyéní̤ Prè̤dônyǎphú Juda dố a vǐkyǎ kyǎ a tè̤phyétè̤me̤ yětôprè̤ akhǎlé̤ nuô, dyéluô̌htya pé̤ pè̤ khǒnyá̤. Juda ma a thyěhò́ rò a cuố dûhò́ klyá dố a tǒkò cuố ná lǔ nuôhò́.” ");
INSERT INTO kyu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Htuô̌rò thyáphú èthǐ ki nwóhtya dố yěthè́nyě̤ aklè̌ tôprè̤ nuôrò èthǐ bò́ lahyǎ tè̤byǎbwí tôcô rò a tǎ̤tǒ dố Mathia rò ǔ sunuô̌ tố̤kuô̌ è dố Prè̤dônyǎphú shyétôprè̤ aplò́amṳyě akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bí mò̤́nyě dố ǔ è́ ná Pentecosto hyǎtuố̤hò́ akhè̌nuô, èthǐ lò̌꤮ plǐ hyǎ oplò́oplu ró̤lò̌ lǔ dố khǎlé̤ tôphotuô̌. ");
INSERT INTO kyu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tè̤pra̤rû́pra̤tè́ htya khyé dố mò́lè̤̌ rò a pra̤ thyácò́ná ké̤lathè́ lalyǎdu hyǎnuôrò a hyǎlya̤ nuô̌ dố èthǐ onyǎo ní̤dyé hinuô tômě akǔ rò a pra̤ lò̌ cò́ hitômě cò́. ");
INSERT INTO kyu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Htuô̌rò èthǐ myáhtye lahyǎ mikyǎ̤htya thyáná pli̤tahe rò a lṳsipryǎcuố lò̌ rò a cuố byáo lò̌ dố èthǐ tôprè̤ htuô̌ tôprè̤ alo̤. ");
INSERT INTO kyu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Èthǐ lốbǎ lò̌plǐ ná Thè́ Sǎsè̌ Byacè pwǒ̤꤮ tôprè̤ rò èthǐ hébèhte lò̌ ná ngó̤khókhye phú Thè́ Sǎsè̌ Byacè nò̌hébè èthǐ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bínuôakhè̌ Judaphú dố a bedu Cò́marya tahe o lahyǎ dố htyěké̤ pwǒ̤tôké̤ rò a hyǎ lahyǎ dố vǐ̤ Jerusalem rò a hyǎ o lahyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bí ǔ ní̤huô̌ tè̤pra̤rû́pra̤tè́ htyayě akhè̌, kayǎ tahe hyǎ oplò́pluphè tava̤ lò̌plǐ rò èthǐ khyéthukhyéthè́ lò̌plǐ cò́, me̤těhérò prè̤zṳ̂́etè̤phú tahe hébè ngó̤ tahenuô, lò̌꤮ kayǎ hyǎ bínuô tahe, tôprè̤ ná tôprè̤ ní̤huô̌ ní̤dyé lò̌ dû ná èthǐ angó̤ ní̤dû akhu-akhyě, a khyéthukhyéthè́ lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Rò èthǐ hé ní̤dyé khyělǔ, “Kayǎ dố a hébè tè̤ yětahe nuôma Galileaphú prè́ vǎhéto? ");
INSERT INTO kyu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mame̤těrò lò̌꤮ pè̤ yětahe cuốní̤huô̌ tuố̤ lò̌gně èthǐ hébè lò̌ ná pè̤ tôprè̤ ná tôprè̤ angó̤ phútětě? ");
INSERT INTO kyu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pè̤ yětahenuô, tahehe ma Pathiaphú, Medephú, Elamitephú, Mesopotamiaphú, Judaphú, Cappadociaphú, Pontusphú, Asiaphú, ");
INSERT INTO kyu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygiaphú, Pamphyliaphú, Egyptphú, Libyaphú dố a ophû ná vǐ̤ Cyreneo, rò pè̤ yětahehenuô a o dố vǐ̤ Roma rò a hyǎ olě. ");
INSERT INTO kyu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Pè̤ yětahe nuôma tahehe rò Judaphú, tahehe rò Judaphú má̤to tadû́rò pè̤ nuô̌kuô̌ dố Judaphú a tè̤cò́bucò́bè̌ akǔ.) Kayǎ dố aruô pó̤ tahe nuôma Creta klû́phú ná Arabiaphú thǐtahe. Manárò pè̤ pwǒ̤꤮ tôprè̤ cuốní̤huô̌ tuố̤ lò̌ èthǐ yětahe hésodônyǎ Cò́marya atè̤me̤ tè̤pro̤tè̤prya̤ tahe ná lò̌꤮ pè̤ yětahe angó̤ngó̤.” ");
INSERT INTO kyu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Èthǐ khyéthukhyéthè́ lò̌plǐ cò́ pwǒ̤꤮ tôprè̤ rò a tane̤plǒ pǎ cò́ lahyǎ to, rò èthǐ sudyǎ ní̤dyé lahyǎ lǔ, “Tè̤ cuốme̤ htwǒhtya tuố̤ ané̤ phúyě ma angó̤lasá hyǎ phútětě?” A hé ní̤dyé lǔ tôprè̤ ná tôprè̤ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Manárò kayǎ dố aruô tahehenuô a nyě̤kruô̌ prè̤zṳ̂́etè̤phú yětahe rò a hé lahyǎ, “Kayǎ yětahe ma a ǒmṳ̂ lahyǎ htyěsípré̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Htuô̌rò Petru dố a ihtòo tố̤kuô̌ ná Prè̤dônyǎphú shyétôprè̤ yětôprè̤nuô a è́htǒ hébè shyo pé̤ ǔ, “Puố̤vyá̤ Judaphú ná kayǎ o dố vǐ̤ Jerusalem akǔ lò̌꤮ plǐ thǐ꤮ ní̤dǎ lahyǎ! Vǎ ki héso pé̤ thǐ tè̤htwǒhtya yě angó̤lasá. ");
INSERT INTO kyu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Thǐ tane̤ lahyǎ ná kayǎ yětahe ǒmṳ̂htyě manárò amá̤to, mò̤́lǐ lwǐ̤thyótômû̌ bè mópǎprè́! ");
INSERT INTO kyu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tè̤htwǒhtya phúyě tahe nuôma a htwǒhtyahò́ phú Prè̤pro̤ Joel hésodônyǎ one htuô̌hò́ nuôtahe prè́. ");
INSERT INTO kyu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Cò́marya hé, yěma tè̤ dố vǎ ki nò̌htwǒhtya è bí mò̤́nyě dố khyětadûlố pǎ tahenuô hò́, vǎ ki klò̤̌lya̤ vǎ Thè́ Sǎsè̌ Byacè dố kayǎ hekhuphú lò̌꤮ plǐ tahe alo̤ pǎ꤮, thǐ phúmòphúkhǔ tahe ki hésoluô̌ one vǎ tè̤ritè̤kyǎ tahe pǎ, thǐ prè̤khǔphúthè tahe ki myáhtyelwó one pǎ, rò thǐ muố̤prè̤́ tahe ki omyěmyá̤lwó tè̤ tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mò̤́nyěmò̤́thè̌ hyǎtuố̤hò́ pǎ nuô, vǎ ki klò̤̌lya̤ vǎ Thè́ Sǎsè̌ dố vǎcṳ̂́ prè̤mòprè̤khǔ lò̌꤮ plǐ tahe alo̤ pǎ rò èthǐ ki hésoluô̌ pé̤ thǐ ná vǎ tè̤ritè̤kyǎ tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Vǎ ki dyéluô̌ tè̤me̤tapa̤ khyéthukhyéthè́ tahe dố mò́lè̤̌ pǎ, htuô̌to vǎ ki dyéluô̌htya tè̤me̤ tè̤pro̤tè̤prya̤ a tè̤mátè̤dyǎ tahe dố hekhu yě pǎpǎ, thwi, ná mi, ná mikhuô taò́htya ki ohtya dố hekhuyěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bí Byacè a mò̤́nyědu dố a lốbǎ ná tè̤taryědu taryěhtǔ yě hyǎtuố̤ tyahíto akhè̌nuô, tamò̤́ ki khítarṳ̂kyǎ pǎ, rò lè̌ ki li̤kathwíkyǎ phú thwinuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Rò bínuôakhè̌ pǎnuô kayǎ dố a è́htǒhtya dố Byacè a o tôprè̤prè̤nuô a ki ní̤bèdû tè̤me̤lwóhteka̤ pǎ,’ Prè̤pro̤ Joel hé phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Rò Petru hé pó̤, “Vǎkhǒ Israelphú thǐ꤮, ní̤dǎ lahyǎ vǎ tè̤hébèyě! Bí vǐ̤ Nazarèphú Jesǔ otố̤kuô̌ ná thǐ akhè̌nuô, a dyéluô̌ è́htuô̌ pé̤lǎhò́ thǐ tè̤me̤ tè̤pro̤tè̤prya̤ tahe ná tè̤me̤tapa̤ khyéthukhyéthè́ tahe ná tè̤me̤ tè̤pro̤tè̤prya̤ a tè̤mátè̤dyǎ dố Cò́marya dyépro̤dyéprya̤ lǔ yěnuôtahe hò́. Yěnuôma a dyéluô̌hò́ ná Jesǔ ma a o dố Cò́marya a ohyǎ phúnuô hò́. A me̤ pé̤ htuô̌lò̌hò́ tè̤me̤ yětahe nuôma thǐ thè́gně htuô̌dûhò́. ");
INSERT INTO kyu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Phú Cò́marya taritaryǎ one rò a thè́gněone htuô̌dûhò́ ná ǔ ki dyé tǎ̤kyǎ Jesǔ dố thǐ takhukǔ pǎ rò thǐ nò̌mṳ̂̌thyěhtya è ná kayǎcyě̤ kayǎricyá̤ tahe dố krusu alo̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Manárò Cò́marya me̤htwǒprè̤ ka̤khyě khyěthyá è dố tè̤thyě, rò a me̤lwóhteka̤ lǔ dố tè̤thyě a tè̤cyě̤tè̤cṳ̂ alè̤̌, me̤těhérò tè̤thyě amuố̤phè̌ pṳ̂́klò̤macyá̤ pǎ lǔ to hò́. ");
INSERT INTO kyu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Phuô̌ Davi héso-one htuô̌hò́ Krístu ari-akyǎ rò a hé, ‘Vǎ myáhtye Byacè o dố vǎ mèthènyě pwǒ̤꤮ tôphuố cò́. Cò́marya o dố vǎ takhu cò́htwó tôkyě akhu-akhyě ǔ me̤pyá̤me̤sè̌ cyá̤ vǎ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Phúnuôrò vǎ thè́plòmo̤ pwǒ̤꤮ tôphuố cò́, rò bí vǎ hébè akhè̌ vǎ hébè shuô̌shuô̌ cò́ ná tè̤thè́krṳ̂̌thè́lò̌ cò́. Htuô̌to vǎ né̤klò̤́ yěnuôbèbè, vǎ ohtwǒprè̤ dố tè̤myásû̌ akǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Vǎ thè́krṳ̂̌thè́lò̌ nyacò́, me̤těhérò nè̤ vǐtǎ̤kyǎ vǎ thè́htwǒprè̤ dố Luô̤̌ké̤nédò̌ to. Nè̤ nò̌thò̌nò̌lòkyǎ nè̤ kayǎsǎsè̌ yětôprè̤ dố luô̤̌kǔ to. ");
INSERT INTO kyu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nè̤ dyéluô̌ htuô̌hò́ vǎ klyá dố a thǔcuố vǎ dố tè̤htwǒprè̤ nuôtôbǒ hò́, nè̤ okuô̌ ná vǎ akhu-akhyě vǎ thè́krṳ̂̌thè́lò̌ nyacò́,’ Phuô̌ Davi hé phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Rò Petru hé khyěthyá, “Vǎ puố̤vyá̤ thǐ꤮, vǎ ki hésoluô̌ pé̤ thǐ ná pè̤ Phuô̌ Davi dố꤮ nyénu tôprè̤ ari-akyǎ. È thyě rò ǔ iluố htuô̌hò́ lǔ, rò aluô̤̌khunuô a o tadû pǎ bíyě tuố̤khǒnyá̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Phuô̌ Davi ma prè̤pro̤ tôprè̤. Cò́marya ò́lya̤ htuô̌hò́ lǔ ná dố aklwǐlyǎ aklè̌ tôprè̤nuô, Cò́marya ki nò̌htyahtwǒ lǔ ná khwí dố èkhǎlé̤ yěnuô pǎnuô, a thè́gně prè́. ");
INSERT INTO kyu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Phuô̌ Davi myáhtye-one ná Cò́marya ki me̤tè̤ pǎ akhu-akhyě a hébè one ré̤ Krístu dố Cò́marya nwóhtya è ná prè̤me̤lwóhteka̤ ǔ yětôprè̤ a tè̤thyěihtò htwǒprè̤ ka̤khyě ari-akyǎ rò a hé, Cò́marya vǐkyǎ kyǎ è dố Luô̤̌ké̤nédò̌ to. Htuô̌to a nò̌thò̌nò̌lòkyǎ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Cò́marya me̤htwǒprè̤ ka̤khyě htuô̌ Jesǔ yě dố tè̤thyě rò lò̌꤮ pè̤ yětahe nuôma pè̤ htwǒ pé̤ lǔ prè̤khyáthè́ dố pè̤ ki khyáluô̌ pé̤ ǔ ná atè̤thyě ihtòka̤khyě yě ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cò́marya bedubehtǔ Jesǔ rò a dya-o lǔ dố atakhu cò́htwó tôkyě, rò phú a Phè̌ Cò́marya ò́lya̤ htuô̌hò́ ná a ki dyé lǔ Thè́ Sǎsè̌ nuô a dyéhò́ lǔ hò́. Rò Jesǔ klò̤̌lya̤lyálya̤ hò́ tè̤ dố nè̤ myáhtye ní̤huô̌hò́ khǒnyá̤yě nuôtahe hò́. ");
INSERT INTO kyu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Phuô̌ Davi ané̤byacè ní̤dû htya tuố̤dố mò́khu to tadû́rò a hé, ‘Cò́marya hé vǎ Byacè, “Onyǎo dố vǎ takhu cò́htwó yětôkyě. ");
INSERT INTO kyu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Rò onyǎ tuố̤dố vǎ dyatǎ̤ prè̤ dố a thè́hte nè̤ yětôprè̤ dố nè̤ khanyělè̤̌ dố athyáná nè̤ khǎduô lé̤khè̌zí̤tǎ̤ yěnuô pǎ,”’ Phuô̌ Davi hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Phúnuô akhu-akhyě Israel aklwǐalyǎ lò̌꤮ plǐ thǐ꤮ thǐ bè thè́gně tǎ̤te̤ ná Jesǔ dố thǐ mṳ̂̌thyěhtya è dố krusulo̤ yětôprè̤nuô, Cò́marya dyéhtwǒhtya hò́ lǔ ná è ma Byacè ma amá̤má̤, Krístu ma amá̤má̤ hò́,” Petru hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bí kayǎ yětahe ní̤huô̌ Petru héso pé̤ èthǐ phúyě akhè̌nuô, èthǐ thè́plòsè̌ nyacò́ rò a héka̤khyěsû Petru ná Prè̤dônyǎphú dố aruôtahe, “Puố̤vyá̤ thǐ꤮, kihéphúnuôrò pè̤ tǒbè me̤phútě?” ");
INSERT INTO kyu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petru hé pé̤ èthǐ, “Thyáphú Cò́marya ki plwǒkyǎ thǐ tè̤thû́ tahenuô za̤ ní̤dû lahyǎ thǐné̤ pwǒ̤꤮ tôprè̤ rò plwǒ lahyǎ thǐné̤ ná htyě dố Jesǔ Krístu amwi̤ akǔnuô, tû́ma Cò́marya ki dyé thǐ shyězṳ́ má̤hò́ Thè́ Sǎsè̌ Byacè yěnuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Cò́marya a tè̤emaklò̤ yěnuôma, má̤ thǐgně ná thǐklwǐthǐlyǎ dốkhyě tahe agně, lò̌꤮ kayǎ dố a o dố htyěké̤ye̤ tahe agně ná lò̌꤮ kayǎ o dố Cò́marya è́hyǎ lǔ dố a o nuôtahe agně hò́.” ");
INSERT INTO kyu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petru hérò̤ one èthǐ è́mû̌lǎ, htuô̌to a dyéhè̌dyére èthǐ, “Me̤lwóhteka̤ lahyǎ thǐné̤ ná tè̤cirya dố a kíré̤ hyǎbè kayǎ mǔmyá̤ricyá̤ yětôhtû̌ nuôtahe ní!” ");
INSERT INTO kyu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kayǎ dố a zṳ̂́e Petru a tè̤hébèdônyǎ yětahenuô a plwǒka̤ lahyǎ ané̤ ná htyě, rò bínuôtônyěnuô, kayǎ zṳ̂́ka̤nyá̤ka̤ rò a ka̤kanuô̌ è́htya kuô̌ pó̤ èthǐ nuô, a phû꤮ o aprè̤ thuô̌rí cò́. ");
INSERT INTO kyu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Èthǐ phyéní̤ lahyǎ tè̤shuốtè̤khè̌ dố a ki ithyó thè́gněhtyaní̤ kuô̌ ané̤ dố Prè̤dônyǎphú tahe a o, rò èthǐ bò́thyókhè́khǒní̤ lǔ, eǒ ró̤lǔ rò kwǐcò́bè̌ ró̤lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Prè̤dônyǎphú tahe me̤luô̌ tè̤tapa̤ khyéthukhyéthè́ tahe ná tè̤me̤ tè̤pro̤tè̤prya̤ a tè̤mátè̤dyǎ tahe akhu-akhyě ǔpwǒ̤꤮ prè̤ thè́isě beduzṳ̂́nyá̤ lò̌plǐ Cò́marya cò́. ");
INSERT INTO kyu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Lò̌꤮ prè̤zṳ̂́etè̤phú tahenuô a otố̤oplò́ lǔ rò tè̤ dố a o ná èthǐ tahenuô, a zṳ́tǎ̤ me̤cwó̤ ní̤dyé lǔ tôprè̤ ná tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Èthǐ isè̌tǎ̤kyǎ a ucè̌tazè̌ ná a tǎ̤muô̌tǎ̤tè̤ tahe rò a me̤cwó̤ pé̤ ná kayǎ dố a lorû̌lohtè̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Èthǐ cuố okúokyá ró̤lǔ dố tè̤lǔhǒdu pwǒ̤꤮ tônyě rò èthǐ thè́plòshyo zṳ́ezṳ́ǒ pé̤ lǔ tôprè̤ ná tôprè̤ rò thè́krṳ̂̌thè́lò̌ eró̤ǒró̤lǔ dố èthǐ ahidò́hiphyǎ akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Èthǐ htuthè́htya Cò́marya rò ǔpwǒ̤꤮ prè̤ thè́plò okuô̌ èthǐ. Byacè beplò́ è́htya pé̤ èthǐ kayǎ dố a ní̤bè tè̤me̤lwóhteka̤ tahe dố èthǐ prè̤zṳ̂́etè̤plò́mṳ akǔ pwǒ̤꤮ tônyě cò́. ");
INSERT INTO kyu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bètônyě bí mò̤́hélya̤ thuô̌mû̌, ǔ tǒ kwǐcò́bè̌ ashuốkhè̌nuô, Petru ná Giovanni cuốhtya lahyǎ dố tè̤lǔhǒdu. ");
INSERT INTO kyu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Rò ǔ cò̤̌hyǎ kayǎ khǎduôdá dố a muố̤hò́kǔ tôprè̤ rò ǔ hyǎ dya-o è bí tè̤lǔhǒdu kadǎ akhǎshyé nuô. Kadǎ yěnuô ǔ è́ è ná “kadǎtwó̤.” Thyáphú a ki kwǐní̤kuô̌ rû̌ dố kayǎ hyǎnuô̌ dố tè̤lǔtyǎ hǒkǔ nuôtahe a o rò pwǒ̤nyěnyě ǔ cò̤̌hyǎ dya-o lǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bí a myáhtye Petru ná Giovanni kíré̤ nuô̌ dố tè̤lǔtyǎ hǒkǔ akhè̌nuô, a kwǐthè́zò̤ èthǐ dố a ki dyé pé̤ lǔ tè̤ tôcôcô. ");
INSERT INTO kyu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Rò èthǐ myátǎ̤ lǔ rò Petru hé lǔ, “Myácuốtǒ dố pè̤oyě!” ");
INSERT INTO kyu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Rò a kíré̤ ní̤bè tè̤ tôcôcô kǒle a tane̤ rò a myácuốtǒ Petru ná Giovanni. ");
INSERT INTO kyu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Manárò Petru hé lǔ, “Vǎrû̌vǎhtè̌ o tômyé꤮ to, manárò tè̤ dố a o ná vǎ yěnuô, vǎ ki dyé nè̤. Dố vǐ̤ Nazarèphú Jesǔ Krístu dố amwi̤ o ná tè̤pro̤prya̤ shyosò̌ yětôprè̤ khukhyěrò vǎ hé nè̤, kahtò cuốmò̌!” ");
INSERT INTO kyu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","A héhtuô̌ phúnuôrò a pṳ̂́ lǔtakhu cò́htwó rò a cwikahtò lǔlǔ ná tôphuốtuô̌ a khǎduôlè, akhǎduô shyědye ná akhǎduô mèthèplò tahe a shyohtyasò̌htya lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Rò a pá̤kahtò rò a kahtò cuốka̤cuốhyǎ htuô̌rò a cuốnuô̌ ró̤kuô̌ ná èthǐ dố tè̤lǔhǒdu akǔ rò a cuốka̤cuốhyǎ, pá̤ishye-iprû́ rò htuthè́htya Cò́marya. ");
INSERT INTO kyu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Lò̌꤮ kayǎ o bínuô tahe myáhtye lò̌ a cuốcyá̤ yěnuô ná a tè̤irǒhtuthè́htya Cò́marya yěnuô tahe. ");
INSERT INTO kyu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Rò èthǐ tǒ̤maní̤ lahyǎ lǔ ná è ma kayǎ onyǎkwǐe ǔrû̌ bí tè̤lǔhǒdu kadǎtwó̤ khǎshyé nuôtôprè̤ prè́. Dố a cuốcyá̤ khyěthyá phúyě akhu-akhyě èthǐ khyéthukhyéthè́ lò̌plǐ cò́ pwǒ̤꤮ tôprè̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bí kayǎ yětôprè̤ pṳ̂́ma taklố ní̤dyé Petru ná Giovanni bí khǎlé̤ tôpho dố ǔ è́ ná Solomo hilákû akhè̌nuô, kayǎ bínuô tahe khyéthukhyéthè́ rò klyahyǎ lahyǎ dố èthǐ a o. ");
INSERT INTO kyu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petru myáhtye èthǐ rò a hé èthǐ, “Vǎ khǒbò́thyó Israelphú thǐ꤮ thǐ cuố khyéthukhyéthè́ lahyǎ tè̤me̤ yětôcô alé̤ me̤tě? Thǐ cuố myáotyá̤ tuố̤ lò̌ pè̤ me̤tě? Kayǎ yětôprè̤ cuốcyá̤ yěnuôma thǐ tane̤ lahyǎ ná pè̤ me̤ pé̤ è ná pè̤ tè̤pro̤tè̤prya̤ nuô è̌? Thǐ tane̤ lahyǎ ná ma kayǎ sǎsè̌phú tahe akhu-akhyě phúnuô è̌? ");
INSERT INTO kyu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac ná Jacob tahe a Cò́marya ná pè̤ muố̤phè̌phyěphuô̌ dố꤮ nyénu tahe a Cò́marya dyéluô̌ htyahò́ a tè̤lǐtè̤takhè̌ ná alulé Jesǔ yěnuô hò́. Manárò thǐ dyétǎ̤kyǎ è dố kayǎ htwǒduhtwǒkhu tahe a takhukǔ rò bí Khwí Pilato cirya htuô̌hò́ dố a ki plwǒhtekyǎ lǔ akhè̌nuô, thǐ cṳ̌kuô̌ lǔ to. Dố khwí yětôprè̤ a mèthènyěnuô, thǐ htésû tapa̤ cò́ ǔ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","È ma kayǎsǎsè̌, kayǎcò́kayǎte̤ tôprè̤ tadû́rò thǐ vǐkyǎ è. Thǐ kwǐ Khwí Pilato, ‘Khyáthè́dǒ rò plwǒhte pé̤ pè̤ kayǎ dố a me̤thyě ǔ nuôtôprè̤.’ ");
INSERT INTO kyu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Thǐ me̤thyěkyǎhò́ kayǎ dố a dyé ǔ thè́htwǒprè̤ yěnuô tôprè̤ hò́, manárò Cò́marya me̤htwǒprè̤ ka̤khyě khyěthyá è dố tè̤thyě hò́, rò tè̤htwǒhtya-ané̤ phúyě nuôma pè̤ myáhtye cò́ hò́ ná pè̤né̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Thǐ myáhtyethè́gněhò́ ná kayǎ khǎduôdá yětôprè̤ nuôma má̤dố a zṳ̂́e Jesǔ amwi̤ akhu-akhyěrò a ryáka̤khyě prè́. Pè̤ thè́gně ná yěnuôma má̤ dố è zṳ̂́e Jesǔ akhu-akhyě, Jesǔ me̤ryá lò̌lá̤takli lò̌ cò́ lǔ phú thǐ lò̌꤮ plǐ myáhtye lò̌dûhò́ khǒnyá̤ yěnuôhò́. ");
INSERT INTO kyu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Puố̤vyá̤ thǐ꤮, khǒnyá̤rò, thǐ ná thǐ khuklò́khuklyǎ me̤thyě Jesǔ nuôma, thǐ yǒ thè́gně angó̤lasá to akhu-akhyěrò thǐ me̤ è prè́. ");
INSERT INTO kyu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Cò́marya héone htuô̌lò̌hò́ angó̤ ná prè̤pro̤ tahe lò̌꤮ plǐ hò́. Rò a héone pé̤ èthǐ ná Krístu bè khyábè nyǎ tè̤cyě̤tè̤cṳ̂ pǎ. Rò a lốhtyabǎhtya hò́ phú a hé yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Thyáphú Cò́marya ki plwǒkyǎ thǐ tè̤thû́nuô rò, za̤ ní̤dû lahyǎ thǐné̤ rò taklyé ka̤khyě khyěthyá lahyǎ dố Cò́marya a o. Thǐ ki me̤phúnuô hérò shyé꤮ shuốkhè̌tǒ shuốkhè̌bè hò́ pǎnuô Byacè Cò́marya ki dyéhè̌dyére khyě thǐ pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Rò a ki nò̌hyǎlya̤ pé̤ thǐ Jesǔ má̤dû Messia dố Cò́marya nwóhtya pé̤ htuô̌hò́ dố thǐgně yěnuô tôprè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Phú Cò́marya dyé thè́gněone htuô̌dûhò́ ná prè̤pro̤ sǎsè̌ mú꤮ nukhè̌ tahe ná Jesǔ yěnuô a tǒbè o dố mò́khu tuố̤dố Byacè Cò́marya me̤thè̌ ka̤khyě lò̌hò́ tè̤pwǒ̤꤮ tôcô akhè̌nuô pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Me̤těhérò Mosè hé, ‘Phú Cò́marya nò̌hyǎ vǎ nuô, a ki nò̌hyǎ prè̤pro̤ dố thǐ myěcôklè̌ tôprè̤ pǎ rò thǐ tǒbè ní̤dǎ cò́ angó̤ pwǒ̤꤮ tômû̌ cò́ pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kayǎ dố a ní̤dǎcṳ̌e kuô̌ prè̤pro̤ nuôtôprè̤ alǎ̤angó̤ to tahenuô, Cò́marya ki dyataphǎkyǎ èthǐ ná Cò́marya aphúalye̤ khǎlé̤ pǎ, htuô̌to a ki me̤pyékyǎ èthǐ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Cáhtya dố Samuelè htû̌khè̌ tuố̤dố lò̌꤮ prè̤pro̤ dố a hésodônyǎ Cò́marya ari-akyǎ dố khyě tahe ahtû̌khè̌nuô, a héso-one htuô̌ lò̌ hò́ tè̤ dố a ki htwǒhtya htû̌khè̌ khǒnyá̤khè̌ yětahe ari-akyǎ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Cò́marya a tè̤emaklò̤ dố a nò̌dyéluô̌tǎ̤ dǐtû́ prè̤pro̤ thǐ tahe nuôma thǐgně hò́. Htuô̌to Cò́marya ô̌lya̤ htuô̌hò́ ná thǐ muố̤phè̌phyěphuô̌ dố꤮ nyénu tahe nuô̌꤮ ma thǐgně otố̤kuô̌ hò́hò́. Phú Cò́marya héso-one htuô̌hò́ Abraham, ‘Vǎ ki sò̌ri dǐtû́ lò̌ hekhuphú yětahe lò̌꤮ plǐ ná nè̤ klwǐlyǎ kalya̤ nuôtôprè̤ akhyě pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bí Cò́marya nwóhtya alulé Jesǔ akhè̌nuô, a nò̌hyǎ ré̤ pé̤ lǔ dố thǐ o hò́. Thyáphú a ki sò̌ri thǐ rò a nò̌hyǎ lǔ phúnuô. Má̤ dố Cò́marya a taríkò́klò̌kyǎ thǐ pwǒ̤꤮ tôprè̤ ná tè̤mǔmyá̤ricyá̤ akhu-akhyě, Cò́marya a sò̌ri thǐ.” ");
INSERT INTO kyu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bí Petru ná Giovanni hébèpǎ ná kayǎ yětahe akhè̌nuô, bwídu tahe ná prè̤opò̤́ tè̤lǔhǒdu khuklò́ tôprè̤ ná Saducěophú tahe hyǎtuố̤ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Prè̤dônyǎphú yěthè́nyě̤ ithyóithya pé̤ ǔ ná Jesǔ htwǒprè̤ ka̤khyě dố tè̤thyě rò a zṳ̌luô̌plǒ pé̤ lò̌ ǔ ná kayǎthyě tahe ki htwǒprè̤ ka̤khyě thyákuô̌phú yěnuô pǎ akhu-akhyě, èthǐ nuôtahe thè́plòdu kayǎ nuôthè́nyě̤. ");
INSERT INTO kyu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rò èthǐ pṳ̂́ Prè̤dônyǎphú yěthè́nyě̤ rò a dò́tǎ̤ èthǐ dố htò̌kǔ. A pṳ̂́ èthǐ akhè̌nuô, yǒ mò̤́hélǎhò́ akhu-akhyě a dò́o tuố̤ èthǐ dố mò̤́lǐ. ");
INSERT INTO kyu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Manárò kayǎ dố a ní̤huô̌ èthǐ tè̤dônyǎ yětahenuô, a zṳ̂́enyá̤eka̤ è́lǎ Jesǔ. Dyá shuô̌shuô̌ prè́ prè̤khǔdu dố a zṳ̂́e Jesǔ tahenuô a phû꤮ o cò́ nyǎ̤rí cò́. ");
INSERT INTO kyu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A pṳ̂́htuô̌ èthǐ anotônyěnuô Judaphú a khuklò́du tahe ná muố̤prû̌muố̤prè̤́ dố a htwǒ khuklò́khuklyǎ tahe ná prè̤ithyó tè̤thyótè̤thya athárá tahe hyǎ okú tǎ̤sûtǎ̤plò́ khyělǔ dố vǐ̤ Jerusalem akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Èthǐ hyǎ okú myáhtyesû ná Caipha, Giovanni, Alexandro, bwídukhulố Anna ná kayǎ aruô dố aklwǐalyǎ ná bwídukhulố nuôtôprè̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Èthǐ nò̌kahtò Prè̤dônyǎphú yěthè́nyě̤ dố èthǐ mèthènyě rò a sudyǎ èthǐ, “Thǐ me̤ryá ka̤khyě khyěthyá kayǎ khǎduôdá nuôtôprè̤ phútě? Thǐ me̤phúyě nuôma thǐ me̤ ná ǔpě a tè̤pro̤tè̤prya̤ pě? Má̤torò thǐ cuố nò̌e ǔpě amwi̤ pě?” ");
INSERT INTO kyu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petru lốbǎhtya ná Thè́ Sǎsè̌ Byacè rò a hésû èthǐ, “Prè̤htwǒduhtwǒkhu thǐ꤮ ná muố̤prû̌muố̤prè̤́ dố a htwǒ khuklò́khuklyǎ thǐ꤮ ");
INSERT INTO kyu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","dố pè̤ me̤ryá ka̤khyě kayǎ khǎduôdá yětônyě tôprè̤ akhu-akhyě thǐce̤ thǐsudyǎ pè̤ phúnuô è̌? Pè̤ zalamé̤ka̤ lǔ phútě nuôma thǐ thè́zṳ̂́ thè́gně è̌? ");
INSERT INTO kyu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Lò̌꤮ thǐ yětahe bèbè, Israel aklwǐalyǎ lò̌꤮ plǐ bèbè, a tǒ thè́gně lahyǎ ná kayǎ khǎduôdá yětôprè̤ ihtòcuốcyá̤ ryáka̤khyě khyěthyá dố thǐ mèthènyě khǒnyá̤yě nuôma má̤dố vǐ̤ Nazarèphú Jesǔ Krístu amwi̤ a tè̤pro̤tè̤prya̤ akhu-akhyě prè́. Jesǔ Krístu ma thǐ mṳ̂̌thyěhtya è dố krusulo̤ nuôtôprè̤ hò́, manárò Cò́marya me̤htwǒprè̤ ka̤khyě khyěthyá è dố tè̤thyě hò́. ");
INSERT INTO kyu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesǔ ma, ‘A thyáná lò̤́ tômě dố thǐ byáhtya hi rò thǐ tá̤kyǎ è manárò dốkhyěnuô a htwǒhtya lò̤́ dố ǔ nò̌e è dố hiná̤ dố a lodulố ǔ tômě.’ ");
INSERT INTO kyu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Kayǎ dố a me̤lwóhteka̤ cyá̤ pè̤ ma tû́prè́ Jesǔ tôprè̤ prè́. Kayǎ aruô dố Cò́marya dyé èthǐ ná a ki me̤lwóhteka̤ pè̤ agněnuô, dố hekhu yětôba lò̌ cò́ nuô a o tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Judaphú dố a htwǒduhtwǒkhu tahenuô, a myáhtye ná Petru ná Giovanni thè́plòkhû̌hǎ rò a thè́gně ná èthǐ ma kayǎ cyá̤licyá̤lè má̤to htuô̌to èthǐ ma kayǎ mò̤́hémò̤́lǐphú prè́ tahe akhu-akhyě, a khyéthukhyéthè́ lahyǎ cò́. Htuô̌to èthǐ thè́gně pó̤ ná Petru ná Giovanni ma kayǎ dố a krwǒbò́thyó kuô̌ ná Jesǔ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Manárò èthǐ myáhtye ná kayǎ dố akhǎduô ryáka̤khyě nuôtôprè̤ kahtò o bí Petru ná Giovanni akhǎshyé akhu-akhyě èthǐ hécyá̤ pǎ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Htuô̌rò èthǐ nò̌htecuố tǎphǎkyǎ Petru ná Giovanni dố prè̤zṳ̂́etè̤plò́mṳ hidò́klò̌ rò èthǐ nuôtahe okúokyákyǎ tû́ dyédû lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Èthǐ sudyǎ ní̤dyélǔ, “Pè̤ tǒbè me̤ èthǐ phútě? Èthǐ me̤htwǒhtya tè̤pro̤tè̤prya̤ yětahenuô lò̌꤮ kayǎ o dố vǐ̤ Jerusalem akǔ yětahe thè́gně lò̌plǐ hò́ akhu-akhyě pè̤ ki hé ná amá̤to nuô a ní̤pǎto hò́. ");
INSERT INTO kyu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Manárò, thyáphú tè̤ritè̤kyǎ yě ki luô̌pasǐcuố pǎ tǎ dố kayǎ è́prè̤ aklè̌ tǎmé̤ nuô, pè̤ bè hé èthǐ ná bè hésodônyǎní̤ pé̤ pǎ ǔ ná Jesǔ amwi̤ tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Rò èthǐ è́kanuô̌ khyěthyá Petru ná Giovanni rò a hé èthǐ, “Jesǔ amwi̤ yěnuô, thǐ bè hébèní̤ pǎ toto, thǐ bè ithyóithyaní̤ pé̤ pǎ ǔ toto.” ");
INSERT INTO kyu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Manárò Petru ná Giovanni hésû èthǐ, “Ma pè̤ tǒbè ní̤dǎ thǐngó̤ è̌? Má̤torò pè̤ tǒbè ní̤dǎ Cò́marya angó̤ è̌ nuô, tane̤lya̤ ní̤dyé lahyǎ thǐné̤ dố Cò́marya a mèthènyě nuô. ");
INSERT INTO kyu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Me̤těhérò tè̤ dố pè̤ myáhtye ní̤huô̌ htuô̌hò́ tahenuô pè̤ ki hésoluô̌ pé̤ ǔ to hénuô, pè̤ ocyá̤ to.” ");
INSERT INTO kyu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Phúnuôrò Judaphú dố a htwǒ khuklò́khuklyǎ tahe lé dyérò̤dyéryě̤ shyosò̌ hyǎklò̌lố pó̤ èthǐ ná dố aré̤ano nuô cò́, htuô̌rò a plwǒka̤kyǎ èthǐ prè́. Èthǐ thè́gně ná kayǎ htuthè́htya lò̌plǐ Cò́marya ná èthǐ me̤htwǒhtya tè̤yětahe akhu-akhyě a ki cirya Petru ná Giovanni phútěnuô a tane̤plǒ lahyǎ to. ");
INSERT INTO kyu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kayǎphè̌ dố ǔ zasǐmé̤ tè̤pro̤tè̤prya̤ lǔ yětôprè̤nuô ana ohò́ lwǐ̤shyělố hò́. ");
INSERT INTO kyu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bí ǔ plwǒhtehò́ Petru ná Giovanni yěnuônuôná tôphuốtuô̌ èthǐ ka̤khyě dố a khǒbò́thyó tahe a o. Rò lò̌꤮ bwídukhu tahe ná muố̤prû̌muố̤prè̤́ dố a htwǒ khuklò́khuklyǎ tahe hékryá꤮ èthǐ phútě nuô, a ka̤dyáluô̌ pé̤ ná akhǒ yětahe. ");
INSERT INTO kyu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bí a khǒbò́thyó tahe ní̤huô̌ tè̤ritè̤kyǎ yě akhè̌nuô, èthǐ kwǐcò́bè̌ ró̤lò̌ lǔ dố thè́plò tômě꤮ cû̌ akǔ dố Cò́marya a o rò a hé, “Kố꤮ byacèdu, nè̤ ma prè̤ dố a byálya̤tělya̤ mò́khuhekhu, htyědutava̤ thǐtahe ná lò̌꤮ tè̤ dố a o dố tè̤yětahe akǔ lò̌꤮ plǐ tôprè̤! ");
INSERT INTO kyu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Thè́ Sǎsè̌ Byacè nò̌hébè dǐtû́ pè̤ Phuô̌ Davi, má̤hò́ nè̤lulé yěnuô, ‘Myěcôruô tahe cuố thè́plòdu li̤kathwí cò́ lahyǎ me̤tě? Mame̤těrò kayǎ tahe cuốkre me̤mǔmyá̤ lahyǎ tè̤ dố a kyǎdě tahe me̤tě? ");
INSERT INTO kyu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Hekhucò́phya tahe taritaryǎ one lahyǎ ané̤ dố a ki sá Cò́marya ná khwí dố Cò́marya nwóhtya lǔ dố a ki me̤lwóhteka̤ prè̤lu kayǎ yětôprè̤. Phúnuôhò́ prè̤pốtarítè̤ tahe okúokyá ró̤ní̤ lǔ dố a ki sátố̤ró̤kuô̌ tè̤ ná hekhu akhwí tahe.’ ");
INSERT INTO kyu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Khǒnyá̤rò dố vǐ̤kǔ yěnuô a htwǒhtyahò́ ané̤ phúnuô hò́! Me̤těhérò Khwí Herodè ná Khwí Pòntio Pilato okúokyá tǎ̤sû ná Judaphú má̤to tahe ná Judaphú tahe bí vǐ̤kǔyě. Rò a tane̤ me̤thyě ró̤lǔ Jesǔ má̤dû nè̤ lulésǎsè̌ dố nè̤ dyéhtwǒ è ná Krístu yěnuô tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dố nè̤ tè̤pro̤tè̤prya̤ akhu-akhyě ná tè̤ dố nè̤ dyalya̤ htuô̌hò́ nè̤ thè́plò dố a ki htwǒhtya pǎ tahe akhu-akhyě, kayǎ yětahe me̤ lahyǎ hò́ phú nè̤ taritaryǎ one htuô̌nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Manárò, Kố꤮ Byacè꤮, ní̤dǎ myámò̌ èthǐ hé taròthè́ thè́isě lahyǎ pè̤ khǒnyá̤yě tahenuô, htuô̌to thyáphú pè̤ htwǒ nè̤lulé yětahe ki hébèkhû̌hǎbû ryákuô̌ nè̤rinè̤kyǎ nuôrò, me̤cwó̤ré̤ pè̤. ");
INSERT INTO kyu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dyéluô̌ nè̤ taryěpro̤prya̤ dố a ki zasǐmé̤ ǔ agně, ná tè̤me̤ tè̤pro̤tè̤prya̤ tahe ná tè̤me̤ tapa̤khyéthu tahe, rò dố nè̤ lulésǎsè̌ Jesǔ yětôprè̤ amwi̤khyě rò nò̌oluô̌htya dû tè̤yětahe ní꤮.” ");
INSERT INTO kyu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bí èthǐ kwǐcò́bè̌ htuô̌hò́ akhè̌nuô, khǎlé̤ bí èthǐ lé̤oplò́ tố̤lǔ nuôtôpho a kazuô̤̌rúruô̤̌htya rò èthǐ lốbǎ lò̌plǐ ná Thè́ Sǎsè̌ Byacè pwǒ̤꤮ tôprè̤ rò èthǐ pwǒ̤꤮ tôprè̤ hésodônyǎ khû̌khû̌hǎhǎ pé̤ lahyǎ ǔ ná Cò́marya ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Prè̤ dố a zṳ̂́enyá̤etè̤ tahenuô èthǐ olǔ ná thè́plò tômě꤮ cû̌, tè̤tane̤ tôcô꤮ tuô̌. Èthǐ tǎ̤muô̌tǎ̤tè̤ tahenuô èthǐ dákwó ní̤dyé lahyǎ ná atè̤ tôprè̤꤮ to. Tè̤ dố a o ná èthǐ tahenuô èthǐ eró̤phyéró̤ khyělǔ. ");
INSERT INTO kyu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Prè̤dônyǎphú tahe khyáluô̌ pé̤ ǔ athè́ ná Byacè Jesǔ nyǎ̤kahtò htwǒprè̤ ka̤khyě ari-akyǎ yěnuô, a lốbǎ cò́ ná tè̤pro̤tè̤prya̤ ashyo-asò̌ htuô̌to Cò́marya klò̤̌lya̤lố klò̤̌lya̤bǎ pé̤ cò́ abwíataryě dố èthǐ lò̌꤮ plǐ alo̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dố prè̤zṳ̂́etè̤phú yětahe aklè̌nuô, kayǎ sǒphásǒrya̤ o tôprè̤꤮ to, me̤těhérò kayǎ dố a o ná htyěòlyá̤rò̤, náhináphyǎ tahenuô, a isè̌tǎ̤kyǎ rò a phyéhyǎní̤ lahyǎ rû̌ dố a isè̌tǎ̤ní̤ yětahe, ");
INSERT INTO kyu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","rò hyǎdyétǎ̤ lahyǎ rû̌yě dố Prè̤dônyǎphú tahe a takhukǔ rò èthǐ ibě pé̤ ná kayǎ dố a lorû̌lohtè̌ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Phúnuô akhu-akhyě kayǎ mwi̤ ná Joseph o tôprè̤, è ma Leviphú tôprè̤ rò a o pacè̤̌lya̤ dố Cyprú klû́khu, rò Prè̤dônyǎphú yětahe è́ lǔmwi̤ ná Barnaba (Angó̤lasá ma kayǎ dố a dyéhè̌dyére ǔ) ");
INSERT INTO kyu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","a isè̌kyǎ alyá̤ tôlé̤ rò a hyǎ dyétǎ̤ arû̌yě dố Prè̤dônyǎphú tahe a takhukǔ. ");
INSERT INTO kyu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Manárò kayǎ dố amwi̤ ná Anania otôprè̤. È ná amě Sapphira isè̌kyǎ ní̤dyé alyá̤ tôlé̤. ");
INSERT INTO kyu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Rû̌ dố èthǐ isè̌ní̤ yěnuô, amě thè́plòo thyákuô̌ ná lǔ dố èthǐ ki bekyǎ èthǐgně tahe rò a okyǎ dố aruô yětahenuô a hyǎdyé ná Prè̤dônyǎphú nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Rò Petru hé lǔ, “Anania꤮ nè̤ cuố nò̌pốtuố̤ nè̤né̤ ná khǐnéricyá̤ khuklò́ me̤tě? Nè̤ lahǒkyǎhò́ Thè́ Sǎsè̌ Byacè hò́. Nè̤ cuố bedwó uốkyǎ tuố̤lyá̤ ngṳ dố nè̤ isè̌ní̤ è aklè̌ nuôtahe me̤tě? ");
INSERT INTO kyu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bí nè̤ isè̌tǎ̤ tyahí nè̤lyá̤ to akhè̌nuô, lyá̤yě ma nè̤tè̤ ní̤dû má̤to è̌? Nè̤ isè̌htuô̌hò́ rò rû̌ dố nè̤ ní̤bè tahenuô꤮ ma nè̤tè̤ prè́prè́. Phúnuô rò nè̤ cuố belya̤tuố̤ nè̤ thè́plò dố nè̤ ki me̤phúyě me̤tě? Yěma nè̤ lahǒ kayǎ má̤to, nè̤ lahǒ cò́ hò́ Cò́marya hò́.” ");
INSERT INTO kyu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania ní̤huô̌ ngó̤ yěnuô ná tôphuốtuô̌ a lakhû́thyěkyǎ cò́. Rò lò̌꤮ kayǎ dố a ní̤huô̌thè́gně lahyǎ tè̤me̤htwǒhtya ané̤ yětahenuô a taròthè́ thè́isě lò̌plǐ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Prè̤khǔ phúdíphúthè tahe hyǎnuô̌tuố̤ rò a talǔbí lǔ ná ikè̤̌, rò èthǐ cò̤̌htekyǎ lǔ rò cuố iluốkyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Htuô̌rò a phû꤮ ohò́ thuô̌mû̌ akhè̌nuô, amě hyǎnuô̌ tuố̤dố Petru a o. Manárò dố pǎnunuô, a me̤kryá꤮ phútěnuô a thè́gně kuô̌ǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petru sudyǎ Sapphira, “Nè̤ hésoluô̌ pé̤ myá vǎ, lò̌꤮ nè̤ ná nè̤vè̤ isè̌ní̤ ucè̌tazè̌ angṳ nuôma rû̌ báyě nyǎprè́ è̌?” Rò a hésû, “Amá̤vǎ, lò̌꤮ plǐ nuôma báyě nyǎprè́ hò́.” ");
INSERT INTO kyu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phúnuôrò Petru hé lǔ, “Mame̤těrò nè̤ ná nè̤vè̤ cuố me̤myá tuố̤ Thè́ Sǎsè̌ Byacè me̤tě? Kayǎ cuốiluố nè̤vè̤ tahenuô, a ka̤tuố̤ mópǎprè́ bí kadǎhtû̌ yěnuô prè́ rò èthǐ ki cò̤̌cuố kuô̌ pó̤ nè̤ pǎ!” ");
INSERT INTO kyu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","A hé htuô̌rò tôphuốtuô̌ Sapphira lakhû́ thyětǎ̤kyǎ kuô̌ bí Petru khǎduô khǎshyé nuô. Prè̤khǔ phúdíphúthè tahe hyǎnuô̌ rò myáhtye ná a thyěhò́ akhu-akhyě èthǐ cò̤̌htecuốiluố tố̤kyǎ lǔ ná avè̤. ");
INSERT INTO kyu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Lò̌꤮ prè̤zṳ̂́etè̤ plò́mṳphú yětômṳlò̌ ná kayǎ dố aruô tahe ní̤huô̌thè́gně lahyǎ tè̤me̤htwǒhtya ané̤ yětaherò a thè́isě lahyǎ kanó̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tè̤me̤ tè̤pro̤tè̤prya̤ tahe bèbè, tè̤me̤ tapa̤khyéthu tahe bèbè, Prè̤dônyǎphú tahe me̤luô̌ pé̤ è́lǎ ǔ. Lò̌꤮ prè̤zṳ̂́etè̤phú tahe hyǎ myáhtye tǎ̤sû lǔ dố tè̤lǔhǒdu khǎlé̤ tôpho dố ǔ è́ ná Khwí Solomo hilákû yěnuô akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kayǎ dố a zṳ̂́enyá̤e to tahenuô a hyǎnuô̌ obû kuô̌ èthǐ tôprè̤꤮ to tadû́rò a htuthè́ ní̤dyé nyacò́ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Manárò prè̤mòprè̤khǔ dố a zṳ̂́e Byacè tahenuô, a hyǎnuô̌ró̤ è́htya ná è́htya kuô̌ dố èthǐ aplò́amṳ akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Prè̤dônyǎphú tahe yǒ me̤ tè̤pro̤tè̤prya̤ pé̤ hò́ ǔ tè̤yětahe akhu-akhyě, bí Petru cuốrwó klyákǔ bí èthǐ khǎshyé yě akhè̌nuô, thyáphú a zo̤uô ki tǎ̤bè prè̤swíprè̤sè̌ yětahe nuôrò, kayǎ tahe záhyǎní̤ lahyǎ kayǎswíkayǎsè̌ tahe rò a hyǎ dè̌lya̤ pé̤ èthǐ alé̤myě tahe, klo tahe dố klyádukǔ. ");
INSERT INTO kyu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kayǎ bè́mṳ dố a o tavǐtava̤ phû ná vǐ̤ Jerusalem nuôtahe záhyǎní̤ lahyǎ kayǎswíkayǎsè̌ tahe, má̤torò kayǎ dố khǐnémǔmyá̤ me̤bè lǔ tahe dố èthǐ a o rò a zasǐmé̤ pé̤ lò̌ cò́ ǔ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yětôphuốrò bwídukhulố tôprè̤ ná lò̌꤮ prè̤ dố a krwǒkuô̌ lǔkhyě dố a opanuô̌ tố̤kuô̌ dố Saducěophú aplò́amṳ bínuô tahe, thè́kháthè́hte tadû cò́ Prè̤dônyǎphú yětahe cò́. ");
INSERT INTO kyu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Èthǐ pṳ̂́ Prè̤dônyǎphú tahe rò dò́tǎ̤kyǎ èthǐ dố htò̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Manárò bí nuôtôthè̌nuô, Byacè tanémò́khuphú tôprè̤ hyǎbámǒ kadǎ rò a plwǒhtekyǎ Prè̤dônyǎphú yětahe rò a hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Cuốnuô̌ kahtòo lahyǎ dố tè̤lǔhǒdu avǐ̤kǔ nuô rò hésodônyǎ pé̤ lò̌ǔ ná tè̤ohtwǒprè̤ athè̌ yě ari-akyǎ nuô.” ");
INSERT INTO kyu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Prè̤dônyǎphú tahe ní̤dǎ mò́khutanéphú nuôtôprè̤ angó̤ rò, bí mò̤́lǐbǔ akhè̌nuô, èthǐ cuốnuô̌ lahyǎ dố tè̤lǔhǒdu a vǐ̤tarè́kǔ rò èthǐ cáhtya ithyóithyatǎ̤ lò̌ ǔ bínuô. Bwídukhulố tôprè̤ ná kayǎ dố a krwǒhyǎkuô̌ lǔkhyě tahe hyǎtuố̤ rò hyǎ è́plò́ lò̌ Juda khuklò́du tahe ná muố̤prû̌muố̤prè̤́ tahe rò èthǐ okúokyá lò̌ lǔ. Htuô̌rò a nò̌cuốè́hyǎ Prè̤dônyǎphú o dố htò̌kǔ nuôtahe dố èthǐ nyěhyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Manárò bí Juda klyěkhuklò́ tahe cuốnuô̌ dố ǔ lé̤dò́o èthǐ akhǎlé̤ akhè̌nuô, a myáhtye pǎ Prè̤dônyǎphú yětahe tôprè̤꤮ to akhu-akhyě, èthǐ ka̤héso khyě kayǎ htwǒ khuklò́khuklyǎ nuôtahe ná muố̤prû̌muố̤prè̤́ nuôtahe, rò a hé èthǐ, ");
INSERT INTO kyu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Bí pè̤ cuốtuố̤ dố ǔ lé̤dò́o akhǎlé̤ akhè̌nuô, pè̤ myáhtye ǔ ká̤ma oryálǎ kadǎ ná thò́. Htuô̌rò lò̌꤮ prè̤opò̤́ htò̌ yětahenuô, a kahtòopò̤́o lahyǎ bí kadǎhtû̌ nuô pwǒ̤꤮ tôprè̤ tadû́rò pè̤ bámǒ kadǎ rò pè̤ nuô̌myá dố akǔ akhè̌nuô, pè̤ myáhtye pǎ tôprè̤꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bí prè̤opò̤́ tè̤lǔhǒdu khuklò́ yětôprè̤ ná prè̤lǔtyǎ khuklò́ tahe ní̤huô̌ tè̤ritè̤kyǎ yě akhè̌nuô, a htetapa̤ lò̌plǐ lǔ rò a tane̤ lahyǎ ná ma a kíré̤ htwǒhtya kuô̌lò̌ pó̤ kryá꤮ ǐtě pǎ a tane̤ lò̌plǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Yětôphuốrò kayǎ hyǎnuô̌ tôprè̤ rò a hé èthǐ, “Ní̤dǎ lahyǎ꤮ thǐ dò́tǎ̤ kayǎ dố htò̌kǔ nuôtahe cuốo dố tè̤lǔhǒdu a vǐ̤tarè́kǔ nuô rò a ithyóithyatǎ̤ lò̌plǐ ǔ bínuô hò́.” ");
INSERT INTO kyu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Phúnuôrò prè̤opò̤́ tè̤lǔhǒdu khuklò́ yětôprè̤ ná a khǒpacè̤̌ tahe htecuố è́ka̤khyě Prè̤dônyǎphú nuôtahe. Manárò thè́isě ná ǔ vǐ èthǐ ná lò̤́ rò èthǐ me̤shyome̤sò̌ bû lǎ ná èthǐ to. ");
INSERT INTO kyu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Èthǐ thǔcuố Prè̤dônyǎphú yětahe dố Judaphú khuklò́khuklyǎ yětahe anyěhyǎ rò bwídukhulố yětôprè̤ sudyǎ ce̤myá èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","A hé èthǐ, “Pè̤ hétǎ̤héte̤ htuô̌hò́ thǐ ná ithyóithya pǎ tǎ ǔ ná kayǎ yětôprè̤ amwi̤ tǎmé̤ ní꤮, rò khǒnyá̤yě thǐ myámyá thǐ cuố me̤kryá꤮ hò́ ǐtětě! Thǐ ithyó pye̤cuố lò̌plǐ hò́ ǔ dố vǐ̤ Jerusalem akǔ yěnuô hò́. Kayǎ nuôtôprè̤ thyě nuôma pè̤ yětahe akhyě hò́, thǐ thè́zṳ̂́ dya lahyǎ pè̤ tè̤thû́ phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petru ná Prè̤dônyǎphú tahe hésû, “Phû꤮ ná kíré̤ ní̤dǎ prè̤lu kayǎ angó̤nuô, bè ní̤dǎ klò̌ dố Cò́marya angó̤. ");
INSERT INTO kyu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Thǐ mṳ̂̌thyěhtya htuô̌hò́ Jesǔ dố krusulo̤ rò pè̤phyěpè̤phuô̌ a Cò́marya yětôprè̤ me̤htwǒprè̤ ka̤khyě khyěthyá è dố tè̤thyě khǎlé̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Thyáphú Cò́marya ki dyé pé̤ Israelphú tahe tè̤za̤ ní̤dû né̤ ná tè̤plwǒkyǎ tè̤thû́ tahe agněnuô, a dya-ohò́ Jesǔ dố atakhu cò́htwó tôkyě phú kayǎ htwǒduhtwǒkhu tôprè̤ ná prè̤me̤lwóhteka̤ ǔ tôprè̤nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Pè̤ ma prè̤ dố a khyáluô̌ pé̤ ǔ thè́ ná tè̤yě tahe ari-akyǎ hò́. Phúnuôhò́ Thè́ Sǎsè̌ Byacè yě bèbè, a khyáluô̌ thyákuô̌ athè́ phúnuônuô. Thè́ Sǎsè̌ Byacè yěnuô Cò́marya dyétǎ̤ pé̤ ná kayǎ dố a ní̤dǎ lǔngó̤ nuôtahe agně prè́.” ");
INSERT INTO kyu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bí Judaphú khuklò́du khusuhtǔ tahe ná Judaphú muố̤prû̌muố̤prè̤́ dố a htwǒ khuklò́khuklyǎ tahe ní̤huô̌ tè̤hébèyě akhè̌nuô, a thè́plòdu kanó̤꤮ to. Rò a thè́zṳ̂́ kreme̤thyěkyǎ cò́ Prè̤dônyǎphú yětahe cò́. ");
INSERT INTO kyu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Manárò bí èthǐ aklè̌nuô Pharisěophú dố amwi̤ ná Gamalie otôprè̤. È ma tè̤thyótè̤thya athárá tôprè̤, htuô̌to è ma kayǎ tôprè̤ dố ǔ dyaduzṳ̂́nyá̤ní̤ lǔ. A ihtò dố kayǎ htwǒ khuklò́ tahe anyěhyǎ rò a nò̌è́hte khókyǎ lò̌ Prè̤dônyǎphú tahe dố aklò̌ taplô̤phú. ");
INSERT INTO kyu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Htuô̌rò a hé Judaphú dố a htwǒ khuklò́khuklyǎ tahe, “Khǒbò́thyó Israelphú thǐ꤮, thǐ kíré̤ me̤ kayǎ yětahe phútěnuô, tane̤ tǎ̤te̤ lahyǎ taki. ");
INSERT INTO kyu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tane̤htya tuố̤ lahyǎ ná dố aré̤khè̌ nuôma kayǎmwi̤ ná Theuda ohtya tôprè̤. A hélya̤ ní̤dyé ané̤ ná vǎ ma kayǎ htwǒdu tôprè̤. A khǒpacè̤̌ dố a krwǒkuô̌ lǔ nuô a phû꤮ o lwǐ̤zè̤ cò́, tadû́rò bí ǔ me̤thyěkyǎ htuô̌hò́ lǔ akhè̌nuô, a khǒpacè̤̌ tahe lṳpruốlṳpryǎ lò̌ prè́. Htuô̌rò a tè̤phyétè̤me̤ tahenuô a pyékyǎlò̌ bínuô prè́. ");
INSERT INTO kyu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Dốkhyě bí ǔ ihtuôplò́ htyěphúké̤phú amwi̤ tè̤rǎmárǎdyǎ akhè̌nuô, Galileaphú dố amwi̤ ná Juda héyěnuô tôprè̤ oluô̌htya khyěthyá. A cuố ilo-ilyání̤ è́lǎ kayǎ tadû́rò nyě̤tyatorò ǔ me̤thyěkyǎ lǔ rò a khǒpacè̤̌ tahe lṳpruốlṳpryǎkyǎ khyěthyá prè́. ");
INSERT INTO kyu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Phúnuôhò́ tè̤ritè̤kyǎ dố a htwǒhtya khǒnyá̤yě bèbè, vǎ thè́zṳ̂́ hé thǐ ná me̤ tǎ èthǐ tôcô꤮ tǎmé̤. Nò̌odû èthǐ phúnuô, me̤těhérò èthǐ tane̤ me̤tè̤ yětahenuô, ki má̤ prè́ a hyǎ dố prè̤lu kayǎ a tè̤tane̤ kihérò a pyékyǎ dû atè̤ pǎ꤮. ");
INSERT INTO kyu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Má̤torò tè̤me̤ yěnuô, a o dố Cò́marya a ohyǎ kihénuôma thǐ me̤pé̤ ná èthǐ to, thǐ vû́sû prè́ ná Cò́marya prè́ nuô, thǐ myáhtye shyěklò̤́ ná thǐné̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Prè̤ htwǒ Judaphú khuklò́dukhusuhtǔ tahe cṳ̌e kuô̌ Gamalie a tè̤dyétane̤cwó̤ yě rò a è́nuô̌ khyěthyá Prè̤dônyǎphú yětahe. Htuô̌rò a mṳ̂̌ èthǐ ná iplírwí̤ htuô̌rò a hé èthǐ ná thǐ bè dônyǎhésoní̤ pé̤ pǎ ǔ ná Jesǔ amwi̤ yěnuô to, a héhtuô̌ phúnuôrò a plwǒ ka̤kyǎ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Prè̤dônyǎphú tahe thè́krṳ̂̌thè́lò̌ htecuốkyǎ dố Judaphú khuklò́khuklyǎ yětahe a mèthènyě, me̤těhérò dố Jesǔ akhu-akhyěrò Cò́marya dya-o nyǎ hò́ èthǐ ná a bè khyábè ǔ me̤tarè̤̌ èthǐ phúyě nuôma a kò nyǎ hò́ phúnuô prè́. ");
INSERT INTO kyu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Rò dốkhyěnuô, èthǐ okuốkyǎ to. Dố tè̤lǔhǒdu akǔnuô bèbè, dố ǔhiǔphyǎ akǔnuô bèbè, pwǒ̤nyěnyě꤮ èthǐ ithyóithya plehyǎ pé̤ ǔ, èthǐ hésodônyǎ plehyǎ luô̌ pé̤ pó̤ ǔ ná tè̤thè́krṳ̂̌mila ari-akyǎ. Tè̤thè́krṳ̂̌mila ma má̤hò́ Jesǔ ma kayǎ dố a me̤lwóhteka̤ prè̤lu hekhuphú lò̌plǐ tôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Bínuô akhè̌, prè̤zṳ̂́etè̤phú tahe oè́htya ná oè́htya rò Helleniaphú tahe ná Judaphú dố a hébè ní̤dyédû angó̤ tahe krékhyělǔ. Helleniaphú tahe hé ná kayǎ dố a zṳ́ezṳ́ǒ sèesèǒ tônyě ná tônyě tahenuô a myátǎ̤phuô bè́khukyǎ èthǐ prè̤mòokryá tahe, a hé lahyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Phúnuôrò Prè̤dônyǎphú shyéthè́nyě̤yě, a è́plò́ lò̌ prè̤zṳ̂́etè̤phú tahe rò a hé èthǐ, “Pè̤ ki dya-okuốkyǎ tè̤hésodônyǎ pé̤ ǔ ná Cò́marya alǎ̤angó̤ yětahe rò pè̤ ki ibětǎ̤ pé̤ ǔ sèesèǒ nuôma a tǒto. ");
INSERT INTO kyu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Phúnuô akhu-akhyě puố̤vyá̤ thǐ꤮, nwóhtya lahyǎ kayǎ thuô̌thyótôprè̤ dố a lốbǎ ná Thè́ Sǎsè̌ Byacè ná tè̤thíphè́ tahe rò pè̤ ki nò̌me̤ èthǐ tè̤me̤ dố a bè zṳ́ezṳ́ǒ pé̤ ǔ sèesèǒ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pè̤ yětahe kuô̌ke rò pè̤ tǒbè dyélya̤ lò̌shuốlò̌khè̌ ke dố tè̤kwǐcò́bè̌ ná tè̤hésodônyǎ pé̤ ǔ ná Cò́marya alǎ̤angó̤ tôkyě.” ");
INSERT INTO kyu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lò̌꤮ kayǎ o dố aplò́amṳkǔ yětahe pwǒ̤꤮ tôprè̤ thè́plòtǒ kuô̌ lò̌plǐ ná Prè̤dônyǎphú hésoluô̌htya yětahe, rò èthǐ nwóhtya Stephano dố a lốbǎ ná tè̤zṳ̂́tè̤nyá̤ ná Thè́ Sǎsè̌ Byacè yětôprè̤, htuô̌rò a nwóhtya kuô̌pó̤ Philipu, Prochorus, Nicano, Timon, Pamena. Htuô̌rò a nwóhtyaní̤ Nicolaita, è ma Judaphú má̤to, è ma vǐ̤ Antiokophú tôprè̤ rò a kanuô̌ kuô̌ dố Juda a tè̤cò́bucò́bè̌ akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Èthǐ aplò́amṳyě thǔhyǎ kayǎyě thuô̌thyótôprè̤ dố Prè̤dônyǎphú tahe a o. Rò a kwǐcò́bè̌ pé̤ htuô̌ èthǐ rò a dyahtya lahyǎ atakhu dố èthǐ yětahe alo̤. ");
INSERT INTO kyu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Phúnuôrò Cò́marya alǎ̤angó̤yě a luô̌pasǐcuố ná cuố cò́. Htuô̌rò dố vǐ̤ Jerusalem akǔ nuô, kayǎ dố a zṳ̂́ka̤nyá̤ka̤tè̤ tahe oró̤oè́htya ná htya cò́. Htuô̌to bwídu tahenuô, a zṳ̂́ka̤nyá̤ka̤ è́ kuô̌ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephano dố a lốbǎ ná Cò́marya abwíataryě ná a tè̤pro̤tè̤prya̤ yětôprè̤nuô, a me̤luô̌ pé̤ ǔ o bínuô tahe ná tè̤me̤ tè̤pro̤tè̤prya̤ tahe ná tè̤me̤tapa̤ khyéthukhyéthè́ tahe bínuô. ");
INSERT INTO kyu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Manárò kayǎ dố a htésû lǔ nuô a o tahe. Èthǐ ma kayǎ tômṳ dố a nuô̌ otố̤kuô̌ dố (Phú ǔ è́ èthǐ ná) Judaphú dố a ní̤bè tè̤palǎ tahe a tè̤cò́bè̌hǒ aplò́amṳ. Èthǐ ma a o dố vǐ̤ Cyreneo ná vǐ̤ Alexandria akǔ. Èthǐ yětahe ná Judaphú dố aruôtahe dố a o dố Cilicia ké̤ ná Asia ké̤ thǐ tahenuô, a cáhtya krékryá̤sû Stephano. ");
INSERT INTO kyu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Manárò bí Stephano hébètè̤ akhè̌nuô, Thè́ Sǎsè̌ Byacè dyé lǔ tè̤thíphè́cyá̤dè tahe akhu-akhyě èthǐ kréka̤khyěsû cyá̤ pǎ lǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Phúnuôrò èthǐ cuố ilò̌huô kayǎ dố aruôtahe rò a nò̌hélahǒ èthǐ, “Pè̤ ní̤huô̌nò́ htuô̌hò́ Stephano yě, a htésû, a hébè mǔmyá̤ricyá̤ Mosè a tè̤thyótè̤thya tahe ná Cò́marya cò́.” ");
INSERT INTO kyu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Èthǐ cuố dố kayǎ bè́mṳ yětahe a o, ná Judaphú khuklò́khuklyǎ tahe, ná prè̤ithyó tè̤thyótè̤thya athárá tahe a o rò a cuố ryǎ̤mikuố rò a cuố nò̌me̤súsáhtya èthǐ. Rò kayǎ yětahe cuố pṳ̂́ Stephano rò cwihyǎ lǔ dố kayǎ htwǒ khuklò́khuklyǎ tahe a mèthènyě. ");
INSERT INTO kyu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Htuô̌rò èthǐ è́hyǎ kayǎ dố a ki khyálahǒní̤ athè́ ná Stephano ari-akyǎ tahe. Rò kayǎ yětahenuô a hé lahyǎ, “Kayǎ yětôprè̤ ma a hépyéhékyǎ lò̌plǐ pè̤ tè̤lǔhǒdu sǎsè̌ ná Mosè a tè̤thyótè̤thya tahe pwǒ̤꤮ tôphuố cò́ meně. ");
INSERT INTO kyu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pè̤ ní̤huô̌ a hé ná vǐ̤ Nazarèphú Jesǔ yě ki me̤tǎ̤prò̤kyǎ tè̤lǔhǒdu yěnuô pǎ rò a ki htulya taplekyǎ pè̤ lé̤klǒlé̤khya dố Mosè dyéokyǎ htuô̌hò́ pè̤ yěnuôtahe pǎ” a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Lò̌꤮ kayǎ dố a onyǎo bí kayǎ htwǒ khuklò́khuklyǎ akhǎlé̤ yěnuô tahe myátǎ̤tố̤ lò̌ Stephano, rò èthǐ myáhtye lǔ mèthènuô a thyácò́ná tanémò́khuphú amèthè nuô cò́. ");
INSERT INTO kyu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Bwídukhulố yětôprè̤ sudyǎ Stephano, “Phú kayǎ yětahe hé nè̤ yěnuôma, nè̤ hé má̤lakǒ nyǎ è̌?” ");
INSERT INTO kyu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Rò Stephano dyá pé̤ èthǐ, “Puố̤vyá̤muố̤phè̌ thǐ꤮ ní̤dǎ lahyǎ vǎ hé pé̤ thǐ yě! Bí pè̤phè̌ Abraham cuốo tyahí dố vǐ̤ Haran híto, rò a opǎ prè́ bí Mesopotamia akhè̌nuô, Cò́marya dố a lốbǎ ná tè̤taryědu taryěhtǔ yětôprè̤ oluô̌htya pé̤ lǔ dố a mèthènyě. ");
INSERT INTO kyu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Htuô̌rò a hé lǔ, ‘Dyakyǎ nè̤hinè̤phyǎ, nè̤phúnè̤lye̤ ná nè̤htyěnè̤ké̤ nuôtahe rò cuố o dố ké̤ dố vǎ ki dyéluô̌ nè̤ yěnuô pǎ ní.’ ");
INSERT INTO kyu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Phúnuôrò Abraham htecuốkyǎ bí Chaldea ké̤kǔ nuôrò a htecuốo dố vǐ̤ Haran. Bí aphè̌ thyěhtuô̌ rò dốkhyěnuô Cò́marya nò̌cuốo lǔ dố htyěké̤ bí thǐo ní̤dyé khǒnyá̤ yěnuôhò́. ");
INSERT INTO kyu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Rò Cò́marya dyétǎ̤ nò́hí Abraham prè́ tôlé̤꤮ to, bí tôkyěphú prè́nuô꤮ a dyé cò́ hí lǔ to, tadû́rò Cò́marya ò́lya̤ lǔ ná a ki dyé lǔ ké̤tôké̤ pǎ, rò ké̤yěnuô, a ki htwǒ Abraham ná aklwǐalyǎ kalya̤ dǐtû́ yětahe ahtyěaké̤ pǎ. Bí Cò́marya ò́lya̤ lǔ ngó̤yě akhè̌nuô, Abraham aphú o hí tôprè̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Cò́marya héokyǎ Abraham, ‘Nè̤klwǐnè̤lyǎ kalya̤ dǐtû́ tahenuô a ki cuốhtwǒ sǐpré̤ dố htyěruôké̤klò̌ tôké̤ pǎ, rò èthǐ ki cuốhtwǒ cṳ̂́ bínuô pǎ, rò ǔ ki me̤cyě̤me̤cṳ̂ èthǐ analwǐ̤zè̤ akǔ pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Manárò vǎ ki cirya kayǎ dố a nò̌htwǒ èthǐ cṳ̂́ nuôtahe pǎ. Rò dốkhyěpǎnuô, èthǐ ki hteka̤kyǎ ná ké̤bínuô tôké̤ pǎ rò èthǐ ki ka̤ cò́bucò́bè̌htya vǎ bí khǎlé̤ nuôtôpho pǎ,’ Cò́marya hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Htuô̌rò Cò́marya ò́lya̤ angó̤ ná Abraham tômû̌, rò a tè̤ô̌lya̤ a tè̤mátè̤dyǎ yěnuôma má̤hò́ Abraham lé̤klǒ me̤ tè̤dû́talíphá yěnuô hò́. Rò Abraham dû́talí ní̤dyé a phúprè̤khǔ Isaac phá bí a opacè̤̌lya̤ htuô̌ a bǎhtya athè̌ lwǐ̤thyó akhè̌nuô. Isaac me̤ dǐtû́ pé̤kuô̌ a phúprè̤khǔ Jacob phú aphè̌ me̤nuô. Htuô̌rò Jacob me̤ dǐtû́ pé̤ kuô̌pó̤ a phúprè̤khǔ shyéthè́nyě̤ phúnuônuô. Jacob aphúprè̤khǔ shyéthè́nyě̤ yěnuôma má̤hò́ pè̤ klwǐlyǎ shyényě̤muố̤ yětahe aphè̌ tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jacob aphúprè̤khǔ tahenuô, a thè́khwè́ ní̤dyé kuô̌ apuố̤ Joseph rò èthǐ isè̌cuốkyǎ lǔ dố a ki cuốhtwǒkyǎ cṳ̂́ dố Egypt ké̤. Manárò Cò́marya okuô̌ ná è. ");
INSERT INTO kyu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Htuô̌rò bí a sítôbè tè̤pyá̤tè̤sè̌ akhè̌nuô, Cò́marya me̤siplè́ lǔ pwǒ̤꤮ tôphuố cò́. Bí Joseph cuốtuố̤ dố Egypt ké̤ Khwí Pharao mèthènyě akhè̌nuô, Cò́marya dyé lǔ tè̤thítè̤phè́ ná Khwí Pharao a tè̤myádu khó ní̤dyédûlǔ tahe. Htuô̌rò Khwí Pharao nò̌pốní̤ lǔ ná Egypt ké̤ ná ahi-aphyǎ ná ahǒhtè̌ thǐtahe. ");
INSERT INTO kyu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Bínuôakhè̌ tè̤ovǐ̤okò̌ ohtya dố Egypt ké̤ ná dố Canan ké̤kǔ rò tè̤cyě̤tè̤cṳ̂du tadû tahe ohtwǒhtya tuố̤ cò́ dố pè̤phyěpè̤phuô̌ tahe lé̤elé̤ǒ o pǎ cò́ to cò́. ");
INSERT INTO kyu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Rò bí Jacob ní̤huô̌ ná buốhuô̌dǐ o dố Egypt ké̤ akhè̌nuô, a nò̌cuố ipri̤ pè̤phè̌ dố꤮ nyénu tahe sèesèǒ dố Egypt ké̤ aré̤lố tôphuố. ");
INSERT INTO kyu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bí èthǐ cuốhò́ nyě̤phuốtôphuố akhè̌nuô, Joseph dyéthè́gně èthǐ ná è ma èthǐ apuố̤ ní̤dû rò Khwí Pharao thè́gněhyǎ kuô̌dû Joseph apuố̤avyá̤, amuố̤aphè̌ yětahe. ");
INSERT INTO kyu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Htuô̌rò Joseph nò̌ka̤ è́hyǎ aphè̌ Jacob ná apuố̤vyá̤ klwǐlyǎ lò̌꤮ plǐ dố Egypt ké̤kǔ. Apuố̤vyá̤ klwǐlyǎ lò̌꤮ plǐ nuô, a o thuô̌thyótôshyě ná thè́nyǎ̤. ");
INSERT INTO kyu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Phúnuôrò Jacob ná aphúalye̤ tahe cuốo lahyǎ dố Egypt ké̤ rò è ná pè̤phè̌ dố꤮ nyénu tahe cuốthyělò̌ bínuô. ");
INSERT INTO kyu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Èthǐ luô̤̌to̤ tahenuô, ǔ phyéka̤ è dố vǐ̤ Shekem. Rò ǔ ka̤ iluố èthǐ bí Abraham ipri̤ onekyǎ ní̤dyé luô̤̌khu nuôtôpho. Luô̤̌khu dố vǐ̤ Shekem yěnuô Abraham ipri̤ dố Hamor aphú thǐtahe a o. ");
INSERT INTO kyu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Bí shuốkhè̌ phûhtyahò́ ná Cò́marya ki me̤lốme̤bǎhtya a tè̤emaklò̤ dố a ò́lya̤ htuô̌hò́ ná Abraham akhè̌nuô, pè̤ myěcôphú dố a o dố Egypt ké̤kǔ yětahenuô, a oró̤htya ná oró̤htya cò́. ");
INSERT INTO kyu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Dốkhyěnuô, khwí dố a thè́gně Joseph ari-akyǎ to tôprè̤nuô, a htya pốní̤ Egypt ké̤. ");
INSERT INTO kyu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Athè́plò cò́ dố pè̤ myěcôphú yětahe akhu to. A me̤cyě̤me̤cṳ̂ pè̤muố̤pè̤phè̌, pè̤phyěpè̤phuô̌ dố꤮ nyénu tahe, thyáphú pacè̤̌phú othè̌ nuôtahe ki thyěkyǎ agněnuô a nò̌cuố dyataphǎye̤kyǎ tadû pè̤myěcô phúothè̌ yětahe ná hi. ");
INSERT INTO kyu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mosè opacè̤̌lya̤ tǒkuô̌ bínuôakhè̌ hò́. È ma pacè̤̌phú dố a phè̌twó̤phè̌thǎryǎ dố Cò́marya anyěhyǎ tôprè̤. Amuố̤aphè̌ myákhwè ní̤dyélè́ lǔ dố hidò́kǔ thuô̌lè̌lè̌꤮ tuô̌ prè́. ");
INSERT INTO kyu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Rò bí ǔ cuốdya taphǎkyǎ è ná hi akhè̌nuô, Khwí Pharao aphúprè̤mò myáhtye lǔ rò a phyéka̤ buôdu íní̤dyé lǔ phú aphú ná ané̤ ní̤dû tôprè̤nuô. ");
INSERT INTO kyu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ǔ ithyóithyaní̤ Mosè ná Egyptphú a tè̤thítè̤phè́ pwǒ̤꤮ tôcô rò a tè̤hébèhésû̌ ná a tè̤phyétè̤me̤ tahenuô, a lốbǎ ná tè̤taryěshyosò̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Bí ana ohò́ lwǐ̤shyě akhè̌nuô, a belya̤ athè́plò ná a ki cuốolě kuô̌ amyěcô Israelphú tahe. ");
INSERT INTO kyu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A myáhtye Egyptphú tôprè̤ me̤nû̌me̤cá Israelphú tôprè̤ rò a cuố me̤cwó̤ pé̤kuô̌ Israelphú yětôprè̤. A me̤lyě̤sû ka̤khyě Egyptphú yětôprè̤ rò a me̤thyěkyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A tane̤ ná a myěcôphú ní̤dû tahe thè́gně ná Cò́marya ki nwóhtya è dố a ki me̤lwóhteka̤ní̤ èthǐ dố cṳ̂́khǎlé̤ pǎ tadû́rò èthǐ thè́gněsû kuô̌ lǔ to. ");
INSERT INTO kyu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Anotônyěnuô, a myáhtye Israelphú ná Israelphú thè́nyě̤ klyé ní̤dyé khyědû lǔ rò a cuố yácû́ me̤pě̤me̤dwǒ ka̤khyě pé̤ èthǐ rò a hé èthǐ, ‘Ní̤dǎ lahyǎ khǒbò́thyó thǐ꤮ thǐnáthǐ ní̤dûprè́ rò thǐ cuố vû́ní̤dyé lǔ me̤tě?’ ");
INSERT INTO kyu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Manárò kayǎ dố a me̤thû́me̤plá ré̤ akhǒ Israelphú ní̤dû yětôprè̤nuô, a shya taphǎ cuốkyǎ Mosè dố ahtû̌ rò a hé lǔ, ‘Maǔpě tôprè̤ dyé nè̤ taryěshyosò̌ dố nè̤ kibè pố pè̤ rò cirya pè̤ nuôpě? ");
INSERT INTO kyu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nè̤ thè́zṳ̂́ me̤thyěkuô̌ vǎ phú nè̤ me̤thyě Egyptphú dố pahénu nuôtôprè̤ è̌?’ ");
INSERT INTO kyu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Bí Mosè ní̤huô̌ ngó̤ yětômû̌ akhè̌nuô, a hteklya cuốo dố Midia ké̤ phú htyěruôké̤klò̌phú tôprè̤, rò a cuố phúoní̤ bínuô thè́nyě̤. ");
INSERT INTO kyu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Mosè cuốo bǎhò́ bínuô analwǐ̤shyě hò́ akhè̌, dố Sínai so khǎshyé, ké̤sè̌htyěkya̤ lò̤́tamákhu khǎlé̤ tôphonuô, miû̌htya cǎcuố̤ rò tanémò́khuphú tôprè̤ oluô̌htya pé̤ lǔ dố mikǔ dố a mèthènyě. ");
INSERT INTO kyu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosè myáhtye rò a khyéthukhyéthè́ rò a hyǎmyáphû tǎ̤te̤ lǔ rò a ní̤huô̌ Byacè ngó̤pra̤htya, ");
INSERT INTO kyu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Vǎ ma nè̤ muố̤phè̌phyěphuô̌ dố꤮ nyénu tahe a Cò́marya. Vǎ ma Abraham, Isaac, Jacob tahe a Cò́marya.’ Mosè thè́isě tanyǎ̤tadè cò́ rò a myábû pǎ cò́ to. ");
INSERT INTO kyu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Cò́marya hé pó̤ lǔ, ‘Khǎlé̤ bí nè̤ kahtòo ní̤dyé nuôtôpho ma hekhu dố asǎsè̌ akhu-akhyě plwóhtekyǎ nè̤khuphá nuô. ");
INSERT INTO kyu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Vǎ myěcôphú khyácyě̤khyácṳ̂ nyacò́ dố Egypt ké̤kǔ nuôma vǎ myáhtye hò́. Vǎ ní̤huô̌hò́ èthǐ tauô̌tasè̌ rò thyáphú vǎ ki me̤lwóhteka̤ èthǐ agněnuô, vǎ hyǎlya̤ hò́. Cuốcò́mò̌ khǒnyá̤, vǎ ki nò̌cuố nè̤ dố Egypt ké̤kǔ.’ ");
INSERT INTO kyu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mosè ma kayǎ tôprè̤ dố amyěcô Israelphú ní̤dû vǐkyǎ lǔ ná ngó̤ tômû̌ dố a hé lǔ, ‘Maǔpě tôprè̤ dyé nè̤ taryěshyosò̌ dố nè̤ ki bèpốní̤ pè̤ rò cirya pè̤ nuô pě?’ A hé lǔ phúnuô. Tanéphú oluô̌htya pé̤ lǔ dố cǎcuố̤kǔ akhu-akhyě, Cò́marya ané̤byacè ní̤dû nò̌cuố lǔ dố a ki pốní̤ a kayǎ bè́mṳ rò a ki me̤lwóhteka̤ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Dố Egypt ké̤kǔ nuô bèbè, dố Htyěli̤dutava̤ akǔnuô bèbè, Mosè dố a è́hteka̤kyǎ Judaphú tahe dố Egypt ké̤kǔ yětôprè̤nuô, a me̤luô̌ pé̤ èthǐ tè̤me̤ tè̤pro̤tè̤prya̤ tahe ná tè̤me̤tapa̤ khyéthukhyéthè́ tahe. Htuô̌to bí èthǐ ka̤ dố ké̤sè̌htyěkya̤ lò̤́tamákhu ana lwǐ̤shyě akǔnuô bèbè, a me̤luô̌ pé̤ ǔ tè̤pro̤tè̤prya̤ yětahehe. ");
INSERT INTO kyu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mosè ma kayǎ dố a hésoluô̌ pé̤ Israel aklwǐalyǎ tahe, ‘Cò́marya ki nò̌hyǎlya̤ prè̤pro̤ dố thǐo phú a nò̌hyǎ vǎ yěnuô pǎ, rò è ma thǐ myěcôphú ní̤dû prè́.’ ");
INSERT INTO kyu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosè ma kayǎ tôprè̤ dố a otố̤oplò́ ró̤kuô̌ lò̌ ná pè̤phyěpè̤phuô̌ dố ké̤sè̌htyěkya̤ lò̤́tamákhu nuôtôprè̤ hò́. A otố̤kuô̌ ná pè̤ muố̤phè̌phyěphuô̌ dố꤮ nyénu tahe ná tanémò́khuphú dố a hébè ní̤dyé lǔ dố Sínai sokhu nuôtôprè̤ hò́. Htuô̌rò è ma kayǎ tôprè̤ dố a ní̤bè Cò́marya alǎ̤angó̤ dố a htwǒprè̤ yětahe rò a ki dyélya̤ dǐtû́ pé̤ ná pè̤ yětahe nuô hò́. ");
INSERT INTO kyu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Tadû́rò pè̤ muố̤phè̌phyěphuô̌ dố꤮ nyénu tahenuô, a ní̤dǎ Mosè angó̤ to. Èthǐ betaná̤kyǎ lǔ rò èthǐ tane̤ thè́zṳ̂́ ka̤khyě dố Egypt ké̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Èthǐ hé Mosè avyá̤ Aròn, ‘Byá pé̤ pè̤ byacè tahe dố a kipốkithǔ ní̤ pè̤ tahe! Mosè dố a è́hteka̤ pè̤ dố Egypt ké̤kǔ yětôprè̤nuô, khǒnyá̤rò a me̤kryá꤮ ané̤ phútě nuô, pè̤ thè́gně pǎto hò́!’ ");
INSERT INTO kyu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Htuô̌rò bínuôkhè̌ èthǐ byá pṳ́phè̌phú zǎ̤zo̤ tôduô̌ rò a lǔhtyaní̤ lǔ rò èthǐ thè́krṳ̂̌thè́lò̌ me̤pwè̌ eǒ ní̤dyé, rò htuthè́htya ní̤dyé lahyǎ tè̤ dố a me̤ ní̤dyé lahyǎ ná atakhu yětahe. ");
INSERT INTO kyu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Phúnuôrò Cò́marya tarí kò́klò̌kyǎ èthǐ rò a dyéhtwǒhtyakyǎ èthǐ ná kayǎ dố a cò́bè̌htya tamò̤́, lè̌, sè dố mò́lè̤̌ tahe phú ǔ rǎokyǎ dố prè̤pro̤ tahe alikǔ nuô rò a hé, ‘Israelphú thǐ꤮! Bí thǐ o dố ké̤sè̌htyěkya̤ lò̤́tamákhu analwǐ̤shyěkǔ akhè̌, tè̤phútè̤lye̤ dố thǐ me̤thyě rò thǐ lǔtyǎhtya tahe nuôma thǐ lǔhtya ná vǎ má̤to. ");
INSERT INTO kyu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tè̤ dố thǐ zácuố ní̤dyé yěnuôma byacè dố ǔ è́ ná Molo yě alé̤thû ná thǐbyacè dố ǔ è́ ná Repha yě asè prè́. Tè̤nuôtahe ma má̤prè́ prè̤zo̤ dố thǐ byá ní̤dyé ná thǐ lé̤cò́bè̌htya agněprè́. Phúnuôrò vǎ ki nò̌cuốye̤kyǎ thǐ dố htyěruôké̤klò̌ dố aye̤klò̌ cò́ ná Babylonia ké̤ yěnuô pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Bí pè̤ muố̤phè̌phyěphuô̌ dố꤮ nyénu opǎ dố ké̤sè̌htyěkya̤ lò̤́tamákhu akhè̌nuô, èthǐ isò́ní̤ lahyǎ lé̤thû dố Cò́marya héluô̌ pé̤ èthǐ nuôtômě. A isò́htya lé̤thûduyě phú Cò́marya hésoluô̌ní̤ pé̤hò́ Mosè rò a dyéluô̌ pé̤htuô̌hò́ lǔ nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Dốkhyěnuô pè̤klwǐpè̤lyǎ yětahe ní̤bèkuô̌ lé̤thûduyě dố pè̤muố̤pè̤phè̌ tahe a o rò bí èthǐ cuốkuô̌ ná Joshua akhè̌nuô, a phyécuố ní̤dyé. Bí a nuô̌phyéní̤ hò́ ké̤ akhè̌nuô, èthǐ phyénuô̌tố̤ ní̤dyé lé̤thûdu yěnuô dố ké̤nuôtôba akǔ. Rò Cò́marya vè̤́hteré̤ pé̤kyǎ èthǐ myěcôruôphú dố a o bínuô tahe rò lé̤thû yěnuô a o bínuô tuố̤dố Davi htû̌khè̌. ");
INSERT INTO kyu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Cò́marya thè́plòoní̤ Davi rò Davi kwǐthè́zò̤ htyaní̤ lǔ dố a ki plwǒ isò́htya lǔ Jacob a Cò́marya lé̤oní̤hi agně tômě. ");
INSERT INTO kyu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Manárò kayǎ dố a isò́htyaní̤ pé̤ Cò́marya ahi yětômě nuôma Davi aphúkhǔ Solomo prè́. ");
INSERT INTO kyu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Manárò Cò́marya dố adulố yětôprè̤nuô hi dố prè̤lukayǎ me̤ ná atakhu nuô a oto. Phú prè̤pro̤ tôprè̤ héone ná ");
INSERT INTO kyu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Byacè Cò́marya hé, ‘Mò́khu ma vǎ khǎlé̤ lé̤onyǎ. Hekhu ma vǎ khǎduô lé̤zí̤ dyatǎ̤ tôcô. Thǐ kíré̤ isò́htya pé̤ vǎ hi phútě tôcôtě pǎ? Vǎ lé̤okhǎlé̤ otǒ bítě tôphotě? ");
INSERT INTO kyu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Lò̌꤮ yětahe ma vǎ me̤htwǒhtya ná vǎné̤ ní̤dû má̤to è̌?’” ");
INSERT INTO kyu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stephano hé pó̤, “Thǐ thè́plò pryě̤kadí cò́! Thǐ thè́plònuô a thyácò́ná kayǎ dố a thè́gně Cò́marya to tahe nuô cò́! Cò́marya alǎ̤angó̤ agně rò thǐ khǎlèkaò̌ kanó̤꤮ to! Thǐ krwǒme̤ thyácò́ná thǐ muố̤phè̌phyěphuô̌ dố꤮ nyénu tahe me̤nuô cò́, rò thǐ me̤dídyǎ tǎ̤tṳ̂̌ Thè́ Sǎsè̌ pwǒ̤꤮ tôphuố cò́! ");
INSERT INTO kyu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Thǐ muố̤phè̌phyěphuô̌ dố꤮ nyénu tahenuô, a me̤cyě̤me̤cṳ̂ lò̌ prè̤pro̤ tahe pwǒ̤꤮ tôphuố cò́. Cò́marya akayǎ dố a hyǎ héso one pé̤ ǔ ná Cò́marya alulé cò́te̤ dố a kíré̤ hyǎ pǎ yětôprè̤ ari-akyǎ tahenuô, thǐ muố̤phè̌phyěphuô̌ tahe me̤thyěkyǎ htuô̌ èthǐ hò́. Khǒnyá̤rò thǐ isè̌tǎ̤kyǎ Cò́marya alulé cò́te̤ yětôprè̤ hò́, htuô̌to thǐ me̤thyěkyǎ hò́ lǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Thǐ ní̤bèhò́ Mosè a tè̤thyótè̤thya dố Cò́marya dyétǎ̤ dǐtû́ ná mò́khutanéphú nuôtahe tadû́rò thǐ ní̤dǎ lǔngó̤ to,” Stephano hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bí kayǎ htwǒ khuklò́ tahe ní̤huô̌ Stephano a tè̤hébèyě akhè̌nuô, èthǐ thè́plòdu rò a a̤takrṳ̂ tǒdè̌cuố lahyǎ cò́ akhukhyě dố lǔo. ");
INSERT INTO kyu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Manárò Stephano rò, a lốbǎ ná Thè́ Sǎsè̌ Byacè. A tṳ́htya dố mò́khu rò a myáhtye Cò́marya alǐatakhè̌, htuô̌to a myáhtye Jesǔ kahtòo dố Cò́marya atakhu cò́htwó tôkyě. ");
INSERT INTO kyu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Rò Stephano hé èthǐ, “Myámò̌lé꤮! Vǎ myáhtye mò́khu omǒhtya rò prè̤lukayǎ aphúkhǔ kahtòo dố Cò́marya atakhu cò́htwó nuôtôkyě.” ");
INSERT INTO kyu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yětôphuốrò kayǎ htwǒ khuklò́ tahe è́htǒè́mo̤ rò ti̤bí lahyǎ akhǎlè ná akanò̌. Rò tôphuốtuô̌ a lwǒ̤ hyǎtǒ dố Stephano a o. ");
INSERT INTO kyu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Rò èthǐ cwihtecuốkyǎ Stephano dố vǐ̤klò̌ rò tá̤ lǔ ná lò̤́. Prè̤khyáthè́ thǐtahe dya-okyǎ èthǐ ca̤klò̌ tahe dố prè̤khǔphúthè dố amwi̤ ná Saulu yětôprè̤ a o rò a nò̌opò̤́myání̤ lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bí èthǐ tá̤ Stephano ná lò̤́ akhè̌, Stephano kwǐcò́bè̌htya Byacè rò a hé, “Byacè Jesǔ꤮, phyédwókyǎ vǎ thè́plò yě.” ");
INSERT INTO kyu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","A dángṳ̂lya̤ rò a è́htǒhtya, “Kố꤮ Byacè, plwǒkyǎré̤ èthǐ tè̤thû́ ní꤮” a hé htuô̌rò a thyěkyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ǔ me̤thyě Stephano yěnuô, Saulu sutǒ thyákuô̌ athè́plò ná prè̤me̤thyě Stephano nuôtahe rò a krwǒò́lya̤ thyákuô̌ phúnuô. Cáhtya bínuô tônyě tǎ̤plehyǎ rò kayǎ dố a o dố vǐ̤ Jerusalem akǔ rò a zṳ̂́enyá̤e Jesǔ tahenuô ǔ me̤cyě̤me̤cṳ̂ nyacò́ èthǐ cò́. Kayǎ dố a okyǎ dố vǐ̤ Jerusalem akǔ tahe nuôma tû́prè́ Prè̤dônyǎphú tahe prè́. Rò lò̌꤮ kayǎ dố a zṳ̂́enyá̤etè̤ tahenuô a hteklya cuốpruốcuốpryǎ lò̌plǐ dố Judaké̤ ná Samaria ké̤. ");
INSERT INTO kyu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Prè̤ mo̤ní̤ nyacò́ Cò́marya nuô a o tahe rò a cuố iluố dwókyǎ Stephano. Rò èthǐ nguố̤thyěnguố̤o lahyǎ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulu héyě tôprè̤nuô a yácû́ pṳ̌ me̤pyéme̤kyǎ Krístu a prè̤zṳ̂́etè̤ plò́mṳphú tahe. A cuốhtya nuô̌ dố hitômě htuô̌ tômě akǔ, rò a cuốcwi tarṳ́hte prè̤mòmò, prè̤khǔkhǔ dố a zṳ̂́enyá̤etè̤ tahe rò dò́nuô̌ èthǐ dố htò̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Prè̤zṳ̂́etè̤phú dố a klyacuốpruốcuốpryǎ kyǎ lò̌ lǔ tahenuô, a cuốtuố̤lò̌ dố khǎlé̤ pwǒ̤꤮ tôpho rò a cuốlě hésodônyǎ pé̤ ǔ ná Jesǔ a tè̤thè́krṳ̂̌mila ari-akyǎ yětahe. ");
INSERT INTO kyu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philipu cuốtuố̤ dố vǐ̤dulố dố a o dố Samaria ké̤kǔnuô tôvǐ̤. Rò a cuố hésodônyǎ pé̤ kayǎ o bínuô tahe ná Krístu ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kayǎ bè́mṳ tahe ní̤huô̌nò́ htuô̌hò́ Philipu a tè̤hésodônyǎ tahe, htuô̌rò èthǐ myáhtyenò́ htuô̌hò́ lǔ tè̤me̤ tè̤pro̤tè̤prya̤ tahe akhu-akhyě a ní̤dǎ ryányacò́ lǔ tè̤hébè tahe. ");
INSERT INTO kyu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Khǐnékhǐnò̌ mǔmyá̤ tahe è́htǒè́mo̤ htecuố taphǎkyǎ dố kayǎ tahe alo̤ nuô a o è́lǎ, htuô̌to a zasǐmé̤ è́ pé̤ lǎ kayǎ dố a thyětôkyě tahe ná kayǎ dố a khǎduôdá tahe. ");
INSERT INTO kyu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Phúnuô akhu-akhyě, vǐ̤kǔphú tahe thè́krṳ̂̌thè́lò̌ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Bí vǐ̤kǔnuô kayǎ dố amwi̤ ná Simonè o tôprè̤. A hé ní̤dyé ané̤ ná è ma a htwǒ khuklò́du khusuhtǔ tôprè̤, rò a cuốlě me̤tapa̤ khyéthukhyéthè́ htuô̌ è́ pé̤ lǎ hò́ Samariaphú tahe ná tè̤me̤ taple ǔmèthè tahe. ");
INSERT INTO kyu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Phúnuôrò lò̌꤮ kayǎ dố a htwǒduhtwǒkhu rò a o bí vǐ̤kǔ nuôtahe bèbè, kayǎ esè rya̤tè̤phú o bí vǐ̤kǔ nuôtahe bèbè, a ní̤dǎthyění̤dǎo lò̌plǐ cò́ lǔngó̤. Èthǐ hé lahyǎ, “Kayǎ yětôprè̤ ma Cò́marya a tè̤pro̤tè̤prya̤ dố ǔ è́ ná tè̤pro̤prya̤ dố adu-azǎ̤ nyǎhò́.” ");
INSERT INTO kyu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A me̤ khyéthukhyéthè́ pé̤ ǔ ná atè̤me̤ taple ǔmèthè bínuô ma anyě̤lǎhò́ akhu-akhyě, ǔ ní̤dǎthyění̤dǎo cò́ lǔngó̤. ");
INSERT INTO kyu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Manárò bí Philipu hésodônyǎ pé̤ èthǐ ná Cò́marya ahtyěaké̤ ari-akyǎ ná Jesǔ Krístu ari-akyǎ akhè̌nuô, prè̤mòmò, prè̤khǔkhǔ a zṳ̂́ka̤nyá̤ka̤ tè̤thè́krṳ̂̌mila rò plwǒka̤ lò̌ ané̤ ná htyě. ");
INSERT INTO kyu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simonè ané̤byacè ní̤dû a zṳ̂́enyá̤e kuô̌ Jesǔ rò a plwǒka̤kuô̌ ané̤ ná htyěhtyě, htuô̌to a cuốró̤ka̤ró̤ kuô̌ cò́ ná Philipu pwǒ̤꤮ tôphuố. Bí a myáhtye tè̤me̤tapa̤ khyéthukhyéthè́ dố adu-azǎ̤ tahe phúyě akhè̌nuô, a khyéthukhyéthè́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bí Prè̤dônyǎphú dố vǐ̤ Jerusalem akǔ tahe ní̤huô̌ ná Samariaphú tahe zṳ̂́e kuô̌ lahyǎ Cò́marya alǎ̤angó̤ akhè̌nuô, èthǐ nò̌cuố Petru ná Giovanni dố èthǐo. ");
INSERT INTO kyu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bí èthǐ hyǎtuố̤hò́ akhè̌, thyáphú Samariaphú tahe ki ní̤bèkuô̌ Thè́ Sǎsè̌ Byacè agněnuô, a kwǐcò́bè̌ pé̤ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Me̤těhérò Thè́ Sǎsè̌ hyǎlya̤ hí dố èthǐ alo̤ tôprè̤꤮ to. Èthǐ plwǒ tû́pǎprè́ lahyǎ ané̤ ná htyě dố Byacè Jesǔ amwi̤ akǔ pǎprè́. ");
INSERT INTO kyu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Phúnuôrò Petru ná Giovanni behtya atakhu dố èthǐ alo̤, rò èthǐ ní̤bè lahyǎ Thè́ Sǎsè̌ Byacè. ");
INSERT INTO kyu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Bí Prè̤dônyǎphú Petru ná Giovanni behtya atakhu dố prè̤zṳ̂́etè̤phú tahe alo̤ rò èthǐ ní̤bè Thè́ Sǎsè̌ Byacè akhè̌nuô, Simonè myáhtye rò a thè́zṳ̂́ dyé Petru ná Giovanni rû̌ rò a hé èthǐ, “Vǎ ki behtya kuô̌ vǎ takhu dố ǔpě tôprè̤ alo̤ pǎ nuô bèbè, thyáphú ǔ ki ní̤bèkuô̌ Thè́ Sǎsè̌ Byacè agněnuôrò, dyépé̤kuô̌ vǎ tè̤pro̤tè̤prya̤ yěnuôtôcô.” ");
INSERT INTO kyu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Rò Petru hésû lǔ, “Cò́marya a tè̤dyékrǎ shyězṳ́ yěnuô, ipri̤ è ná rû̌ ma aní̤ prè́, nè̤ tane̤ phúnuô akhu-akhyě, nè̤ ná nè̤rû̌ ki latǎ̤ tố̤dûlǔ dố Mò́rapò̤tya̤ kǔ ní꤮. ");
INSERT INTO kyu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nè̤ ma kayǎ dố a otố̤kuô̌ dố pè̤ tè̤phyétè̤me̤ akǔ má̤to, me̤těhérò nè̤ thè́plò yěnuô, acò́ dố Cò́marya a mèthènyě to. ");
INSERT INTO kyu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nè̤ thè́plò a tè̤tane̤ mǔmyá̤ricyá̤ yětahenuô, nè̤ tǒbè za̤ ní̤dû mò̌ è rò kwǐcò́bè̌ Cò́marya nuô. Bètǒbè꤮ ma Cò́marya plwǒkyǎ cyá̤ pǎ nè̤ tè̤tane̤thû́ yěnuô tahe pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Me̤těhérò vǎ myáhtye ná nè̤ thè́plò nuô a bǎtapí cò́ ná tè̤thè́htethè́hǎ rò nè̤ tè̤thû́tè̤ora cò̌klò̤ma nè̤ thyácò́ná ǔ tǎ̤ dố htò̌kǔ tôprè̤nuô cò́.” ");
INSERT INTO kyu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simonè hésû Petru ná Giovanni, “Thyáphú lò̌꤮ thǐ héhò́ yětahe ki tǎ̤bè tǎ vǎ tôcô꤮ tǎmé̤ nuô rò kwǐcò́bè̌ pé̤ lahyǎ vǎ dố Byacè o.” ");
INSERT INTO kyu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bí Petru ná Giovanni hésoluô̌ pé̤ ǔ ná tè̤ dố a thè́gně myáhtyenò́ htuô̌hò́ Jesǔ Krístu ari-akyǎ nuôtahe rò dônyǎluô̌ pé̤ htuô̌ ǔ ná Byacè alǎ̤angó̤ akhè̌nuô, èthǐ ka̤khyě khyěthyá dố vǐ̤ Jerusalem. Bí èthǐ ka̤ dố klyálo̤ akhè̌nuô, a lěka̤ dố Samaria dò̌ è́dò̌ rò a nuô̌ tôdò̌ hte tôdò̌ rò a lě hésodônyǎ luô̌ ka̤ pé̤ ǔ tè̤thè́krṳ̂̌mila. ");
INSERT INTO kyu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Byacè a tanémò́khuphú tôprè̤ hé Philipu, “Taritaryǎ one nè̤né̤ rò cuốpalya̤ rwópó̤ klyá cuố dố vǐ̤ Jerusalem rò a tǎ̤kalya̤ cuốrwó dố vǐ̤ Gaza nuôtôbǒ. Klyá yěnuôma ké̤sè̌htyěkya̤ lò̤́tamákhu aklyá.” ");
INSERT INTO kyu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Phúnuôrò Philipu o taritaryǎ ané̤ rò a htecuố. Bí a cuố dố klyálo̤ akhè̌nuô, a myáhtyesû ná Ethiopiaphú dố aswíkyǎ a dye tôprè̤. È ma a htwǒ khuklò́ rò a bè myákhwè pốtaríní̤ Ethiopia khwímuố̤ Candace arû̌htè̌ lò̌꤮ plǐ tôprè̤. A cuố cò́bucò́bè̌ htuô̌ dố vǐ̤ Jerusalem rò a ka̤khyě dố adò̌ ná tathíló̤. ");
INSERT INTO kyu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Bí a ka̤ dố klyálo̤ akhè̌nuô, a hố li dố Prè̤pro̤ Isaiah rǎo dố꤮ nyénu nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Thè́ Sǎsè̌ Byacè héso Philipu, “Cuố dố a tathíló̤ khǎshyénuô.” ");
INSERT INTO kyu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Rò Philipu klyacuố dố tathíló̤ khǎshyé rò bí a ní̤huô̌ a hố Prè̤pro̤ Isaiah li akhè̌nuô, a sudyǎ lǔ, “Nè̤ hố liyě nuôma, nè̤ thè́gně ní̤dyé sálé̤ angó̤lasá è̌?” ");
INSERT INTO kyu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Rò kayǎ htwǒ khuklò́ yětôprè̤ hésû lǔ, “Ǔ ki hésothè́gněplǒ pé̤ vǎ tôprè̤꤮ to hérò vǎ cuố thè́gněcyá̤ phútě?” A hé rò a è́htya sidyá pé̤ lǔ ló̤. ");
INSERT INTO kyu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kayǎ dố aswíkyǎ adye yětôprè̤ hố lisǎsè̌ tômǎ̤ dố a hé, “Ènuô athyáná thímí tôduô̌ dố ǔ cwicuố rò ǔ kíré̤ me̤thyě lǔ nuô, rò athyáná ǔ icǐ thímíphú asû dố a nguố̤ è́htǒè́mo̤ kuô̌ǔ tômû̌꤮ to tôduô̌, a hésû kuô̌ǔ ngó̤ tômû̌꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ǔ me̤tarè̤̌ lǔ rò ǔ ciryacò́ciryate̤ pé̤ lǔ to, kayǎ dố a dônyǎcyá̤ pé̤ ǔ ná a klwǐkalya̤ ari-akyǎ nuô a o tôprè̤꤮ to, me̤těhérò ǔ phyéka̤kyǎ lǔ thè́plòhtwǒprè̤ dố hekhuyě hò́.” ");
INSERT INTO kyu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kayǎ htwǒ khuklò́ yětôprè̤nuô, a sudyǎ Philipu, “Héso pé̤myá vǎ prè̤pro̤ yětôprè̤ hébè tè̤yě, ma a hé ní̤dyédû prè́ è ari-akyǎ prè́ è̌? Má̤toma a héní̤ ǔruô tôprè̤prè̤ ari-akyǎ è̌?” ");
INSERT INTO kyu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Phúnuôrò Philipu cáhtya hé pé̤ lǔ ná lisǎsè̌ yětômǎ̤ rò a hésoluô̌ní̤ pé̤ lǔ ná Jesǔ a tè̤thè́krṳ̂̌mila ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Rò bí èthǐ yěthè́nyě̤ cuố plehyǎ pó̤ dố nyě akhè̌nuô, èthǐ cuốtuố̤ dố htyěo akhǎlé̤ tôpho. Yětôphuốrò kayǎ htwǒ khuklò́ yětôprè̤nuô a hé lǔ, “Htyě o bíyě vǎ꤮! Vǎ ki thè́zṳ̂́ plwǒ vǎné̤ ná htyě hénuôma tè̤me̤dídyǎ tǎ̤tṳ̂̌ vǎklyá o tôcôcô è̌?” ");
INSERT INTO kyu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Philipu hésû lǔ, “Nè̤ ki zṳ̂́e lò̌thulò̌thè́ má̤lakǒ Jesǔ Krístu hénuôma, nè̤ plwǒ nè̤né̤ ná htyě ma aní̤ prè́.” A hé lǔ rò a hésûkhyě, “Jesǔ Krístu ma Cò́marya aphúkhǔ má̤lakǒ nuôma vǎ zṳ̂́e” a hésû phúnuô) ");
INSERT INTO kyu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","kayǎ htwǒ khuklò́khuklyǎ yětôprè̤nuô a è́ okuố prè̤vè̤́ tathíló̤ yětôprè̤. Rò Philipu ná kayǎ htwǒ khuklò́du yěthè́nyě̤ lò̌ hítǎ̤ dố htyěkǔ, rò Philipu plwǒ pé̤ a htwǒ khuklò́du yětôprè̤ ná htyě. ");
INSERT INTO kyu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bí èthǐ o dố htyěkǔ ka̤kahtya akhè̌nuô, Thè́ Sǎsè̌ Byacè cò̤̌cuố mé̤kyǎ Philipu. Kayǎ htwǒ khuklò́ yětôprè̤ myáhtye pǎ lǔ to tadû́rò a thè́krṳ̂̌thè́lò̌ rò a ka̤ plehyǎ lǎ dố adò̌. ");
INSERT INTO kyu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philipu thè́gně ní̤dyé ané̤ ná a cuốtuố̤ dố vǐ̤ Azoto akǔ rò a cuố plehyǎpó̤ dố vǐ̤ Caesarea. Bí a cuố dố klyálo̤ akhè̌nuô, a hésodônyǎ pé̤ ǔ ná Jesǔ Krístu a tè̤thè́krṳ̂̌mila ari-akyǎ yě pwǒ̤꤮ tôvǐ̤ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Bínuôakhè̌ Saulu hé thè́isě Byacè a khǒpacè̤̌ tahe dố a ki me̤thyě èthǐ. A cuố dố bwídukhulố tôprè̤ a o ");
INSERT INTO kyu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","rò a cuốkwǐthè́zò̤ lǔ ná a ki rǎcuốní̤ likhyáthè́ tahe rò a ki rǎcuố pé̤ Juda tè̤cò́bè̌hǒ dố a o dố vǐ̤ Damasco akǔ nuôtahe a o. Likhyáthè́ yětahenuô, a hé cuố èthǐ ná prè̤mò bèbè, prè̤khǔ bèbè, ǔpěpě꤮ bèbè, dǎ Saulu myáhtye ná èthǐ krwǒme̤kuô̌ Byacè Jesǔ aklyá tahe hénuô, a ki pṳ̂́ èthǐ pǎ rò a ki thǔka̤kyǎ èthǐ dố vǐ̤ Jerusalem pǎ, a rǎcuố phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulu cuố dố vǐ̤ Damasco rò bí a phû cuốtuố̤hò́ vǐ̤ akhè̌nuô, tè̤lǐtakhè̌ dố mò́khu sátakhè̌ tǎ̤tava̤ dố lǔ khǎshyé. ");
INSERT INTO kyu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Rò a lakhû́tǎ̤ dố hekhu rò a ní̤huô̌ ngó̤pra̤htya tômû̌ rò a hé lǔ, “Saulu, Saulu, nè̤ me̤cyě̤me̤cṳ̂ vǎ me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Rò Saulu sudyǎsû lǔ, “Byacè꤮ nè̤ ma ǔpě?” Rò ngó̤pra̤ yě héka̤khyěsû lǔ, “Vǎ ma Jesǔ dố nè̤ me̤cyě̤me̤cṳ̂ è nuôtôprè̤ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Manárò kahtòmò̌ rò cuốnuô̌ dố vǐ̤kǔ nuô. Nè̤ tǒ me̤kryá꤮ phútěnuô, ǔ ki hésodû nè̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kayǎ dố a krwǒcuốkuô̌ ná Saulu yětahenuô a ní̤huô̌ ngó̤pra̤ tadû́rò a myáhtye kayǎ tôprè̤꤮ to akhu-akhyě, tṳ̂̌꤮, a okuố lò̌ lahyǎ rò a tane̤plǒ hébè pǎ tôcô꤮ to. A htetapa̤ lò̌plǐ cò́ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulu kahtò rò a yácû́ myákalò̌hte tadû́rò a myáhtye tôcô꤮ to akhu-akhyě èthǐ cwicuố lǔ rò a thǔnuô̌ lǔ dố vǐ̤ Damasco akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Rò thuô̌nyěthuô̌thè̌ akǔ a myáhtyecyá̤to, htuô̌to ae-aǒ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Dố vǐ̤ Damasco akǔnuô prè̤zṳ̂́etè̤phú dố amwi̤ ná Anania o tôprè̤. A myáhtyelwóré̤ tè̤ rò dố a tè̤myáhtyelwóré̤ akǔyěnuô Byacè è́ è, “Anania!” Rò a té ka̤khyěsû, “Byacè vǎo prè́.” ");
INSERT INTO kyu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Rò Byacè hé lǔ, “O taritaryǎ mò̌ nè̤né̤ rò cuố mò̌ dố klyá nuôtôbǒ dố ǔ è́ amwi̤ ná klyácò́ hénuô tôbǒ rò cuố sudyǎ mò̌ vǐ̤ Tarsophú dố amwi̤ ná Saulu dố Juda ahikǔ nuô. Khǒnyá̤rò a kwǐcò́bè̌ hò́ tè̤. ");
INSERT INTO kyu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Rò a myáhtyelwóré̤ hò́, thyáphú a ki myáhtye ka̤khyě khyěthyá agněnuô, kayǎ dố amwi̤ ná Anania hénuô tôprè̤ hyǎ dố lǔo rò a hyǎ dyahtya atakhu dố lǔlo̤.” ");
INSERT INTO kyu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania hésû, “Byacè, kayǎ yětôprè̤ ari-akyǎ nuô, vǎ ní̤huô̌ ǔ è́prè̤ héhtuô̌pé̤ è́lǎ hò́ vǎ, a me̤cyě̤me̤cṳ̂ nè̤ kayǎsǎsè̌ o dố vǐ̤ Jerusalem akǔ nuôtahe, hévǎ. ");
INSERT INTO kyu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Htuô̌to, a hyǎ dố vǐ̤ Damasco yěnuôma a hyǎ dố a kíré̤ hyǎpṳ̂́ lò̌lò̌꤮ kayǎ dố a cò́bè̌ nè̤ nuôtahe prè́. Bwídukhu tahe dyé è taryěshyosò̌ meně.” ");
INSERT INTO kyu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Manárò Byacè hé lǔ, “Cuốmò̌, me̤těhérò vǎ nwóhtya hò́ è dố a ki hésodônyǎ pé̤ Judaphú má̤to tahe ná khwí tahe, ná Israelphú tahe ná vǎrivǎkyǎ pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Lò̌꤮ tè̤cyě̤tè̤cṳ̂ dố a tǒbè khyá dố vǎkhuvǎkhyě tahenuô vǎ ki dyéluô̌ sǐné̤ cò́dû lǔ ná vǎné̤ pǎ.” ");
INSERT INTO kyu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Phúnuôrò Anania cuốnuô̌ dố hi bí Saulu o ní̤dyé nuôtômě akǔ. Htuô̌rò a nuô̌dyahtya atakhu dố Saulu alo̤ rò a hé lǔ, “Puố̤vyá̤ Saulu, thyáphú nè̤ ki myáhtye ka̤khyě ryá khyěthyá, htuô̌rò thyáphú nè̤ ki lốbǎhtya ná Thè́ Sǎsè̌ Byacè agněnuô, Byacè Jesǔ dố a oluô̌htya pé̤ htuô̌hò́ nè̤ dố klyálo̤ nuôtôprè̤, nò̌hyǎ vǎ dố nè̤o hò́.” ");
INSERT INTO kyu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bínuô tôphuốtuô̌ tè̤ dố athyáná tè̤̌ba o dố lǔ mèthèplòlo̤ nuô latǎ̤kyǎ rò a myáhtye ka̤khyě khyěthyá. Yětôphuốrò a kahtò rò a cuố plwǒ ka̤khyě ané̤ ná htyě. ");
INSERT INTO kyu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ae-aǒ khyěthyá rò ahè̌are ohtya khyěthyá. Rò a okuô̌ ná prè̤zṳ̂́etè̤phú tahe bí vǐ̤ Damasco akǔnuô thuô̌lwǐ̤nyě. ");
INSERT INTO kyu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Rò tôphuốtuô̌ Saulu htecuố tǒdè̌ dố Juda tè̤cò́bè̌hǒ tahe akǔ rò a cuốhésodônyǎ pé̤ ǔ ná Jesǔ ma Cò́marya aphúkhǔ tôprè̤ ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lò̌꤮ kayǎ dố a ní̤huô̌ lǔ hébè tahenuô, a htetapa̤ lò̌plǐ èthǐ rò a hé lahyǎ, “È ma kayǎ dố a cuốlṳ̂ me̤thyě kayǎ dố a cò́bè̌ Jesǔ dố vǐ̤ Jerusalem akǔ nuôtahe tôprè̤ má̤to è̌? A hyǎ bíyě rò a ki hyǎpṳ̂́ kayǎ prè̤zṳ̂́etè̤phú tahe rò a kíré̤ thǔka̤ ǔ dố bwídukhu tahe a o vǎhéto?” ");
INSERT INTO kyu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulu a tè̤hésodônyǎ pé̤ ǔ yěnuô a taryěshyosò̌ duhyǎ ná duhyǎ cò́ rò a khyáluô̌ tǎ̤te̤ pé̤ ǔ ná Jesǔ ma Krístu má̤lakǒ cò́ tôprè̤ akhu-akhyě, tuố̤ cò́ dố Judaphú o bí vǐ̤ Damasco akǔ nuôtahe hésûka̤khyě cyá̤ pǎ cò́ lǔ tôcô꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mò̤́nyěmò̤́thè̌ nyěhyǎ hò́ taki rò Judaphú tahe okú tǎ̤sû ní̤dyé lǔ rò a tane̤ kreme̤thyě Saulu. ");
INSERT INTO kyu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Manárò ǔ hésoluô̌ thè́gně pé̤ lǔ ná ǔ ki kre me̤thyě lǔ pǎ, rò thyáphú ǔ ki me̤thyění̤ lǔ agněnuô ǔ opò̤́ bí vǐ̤ kadǎduhtû̌nuô mò̤́khíkhí mò̤́sè̌klè̌klè̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Manárò bí mò̤́khí akhè̌nuô, Saulu a khǒpacè̤̌ tahe sunuô̌ lǔ dố thu tômě akǔ rò a htya cya̤tǎ̤ lǔ dố vǐ̤ǔhtyalô̌ kadǎphú akǔ tôkǔ rò a cya̤tǎ̤kyǎ lǔ dố vǐ̤ǔdu klò̌tôkyě. ");
INSERT INTO kyu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulu ka̤ dố vǐ̤ Jerusalem rò a yácû́ bò́thyókhè́khǒ ané̤ ná prè̤zṳ̂́etè̤phú tahe tadû́rò èthǐ thè́isě lò̌plǐ lǔlé̤. È htwǒ hò́ prè̤zṳ̂́enyá̤ephú tôprè̤ hò́ tadû́rò èthǐ zṳ̂́e lǔ to. ");
INSERT INTO kyu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yětôphuốrò Barnaba me̤cwó̤ lǔ rò a è́cuố lǔ dố Prè̤dônyǎphú tahe a o. Rò a dyáluô̌ thè́gně pé̤ èthǐ ná Saulu myáhtyehò́ Byacè Jesǔ bí a cuố dố vǐ̤ Damasco akhè̌nuô, htuô̌rò Byacè hésoluô̌ pé̤ htuô̌hò́ lǔ ná è ari-akyǎ tahe. Htuô̌to Barnaba hésoluô̌ pé̤kuô̌ pó̤ èthǐ ná Saulu hésodônyǎ khû̌khû̌hǎhǎ pé̤ cò́ vǐ̤ Damascophú tahe ná Jesǔ ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Phúnuôrò Saulu otố̤ kuô̌ná èthǐ rò a cuố lě hésodônyǎ khû̌hǎ pé̤ cò́ ǔ ná Byacè ari-akyǎ dố vǐ̤ Jerusalem akǔ pwǒ̤꤮ tôpho. ");
INSERT INTO kyu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A dônyǎplǒ ka̤khyěhyǎnyě sû ná Helleniaphú tahe tadû́rò èthǐ yácû́ myápṳ̌ klyá dố a ki me̤thyě lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bí prè̤zṳ̂́etè̤phú tahe ní̤huô̌ tè̤ritè̤kyǎ yě akhè̌nuô, èthǐ è́hte cuốkyǎ Saulu dố vǐ̤ Caesarea rò thǔcuốkyǎ lǔ dố vǐ̤ Tarso. ");
INSERT INTO kyu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Phúnuôrò bínuôakhè̌ prè̤zṳ̂́etè̤ plò́mṳphú dố a o dố Judaké̤, Galilea ké̤, Samaria ké̤ yětahe akǔ tahe othuôokrě nò́kuô̌ no ǔ prè́. Dố Thè́ Sǎsè̌ Byacè akhu-akhyě prè̤zṳ̂́etè̤ plò́mṳphú tahe ahè̌are shyohtyasò̌htya, èthǐ ní̤hè̌ní̤re, èthǐ oró̤oè́htya rò ohtwǒprè̤ lahyǎ dố tè̤beduzṳ̂́nyá̤ Byacè akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petru cuốlě lò̌ khǎlé̤ pwǒ̤꤮ tôpho. Tôphuốpǎ rò a cuốolěo tố̤kuô̌ prè̤zṳ̂́enyá̤ephú dố a o dố vǐ̤ Lydda nuôtahe a o. ");
INSERT INTO kyu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Rò a cuố myáhtye tǎ̤sû ná kayǎ thyětôkyě dố amwi̤ ná Aenea o bínuô tôprè̤, a omyěkhû́ oprè́ dố lé̤myěkhu rò a kahtòbè́to nuô a o hò́ analwǐ̤thyó hò́. ");
INSERT INTO kyu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Rò Petru hé è, “Aenea꤮ Jesǔ Krístu zasǐmé̤hò́ nè̤ hò́. Ihtò mò̌ rò kè̤́klyédwó nè̤ lé̤myěnuô” rò Aenea kahtò tapluố̤taplyě cò́. ");
INSERT INTO kyu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lò̌꤮ kayǎ o dố vǐ̤ Lydda akǔ ná Sharòn nyekhu tahenuô a myáhtye tè̤me̤htwǒhtya phúyě akhu-akhyě a zṳ̂́ka̤nyá̤ka̤ kuô̌ lò̌plǐ Byacè. ");
INSERT INTO kyu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Bí vǐ̤ Joppa akǔnuô prè̤mò dố a zṳ̂́ka̤nyá̤ka̤ Jesǔ nuô a o tôprè̤ amwi̤ ná Tabitha (Greek ngó̤ ma amwi̤ ná Dorca, angó̤lasá ma takhyě tôduô̌) a tè̤shuốtè̤khè̌ lò̌꤮ plǐ nuô a me̤bwíme̤taryě pé̤ ǔruô htuô̌rò me̤cwó̤me̤kǒ pé̤ kayǎ sǒphásǒrya̤phú tahe. ");
INSERT INTO kyu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bínuôkhè̌ aswí rò a thyěkyǎ. Aluô̤̌to̤ yěnuô, ǔ iluố̤plǐiluố̤phuố ryá htuô̌hò́ ná htyě rò ǔ dya-o lǔ dố hidò́kǔ dố akhu tôtó̤. ");
INSERT INTO kyu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Vǐ̤ Lydda yěnuô, a ophû ná vǐ̤ Joppa akhu-akhyě, bí prè̤zṳ̂́etè̤phú tahe ní̤huô̌ ná Petru o dố vǐ̤ Lydda akhè̌nuô, èthǐ nò̌cuố kayǎ thè́nyě̤ dố lǔo rò a cuố kwǐthè́zò̤ lǔ, “Khyáthè́dǒ me̤pryǎpryǎ rò hyǎpryǎ dố pè̤ o hénuô̌!” ");
INSERT INTO kyu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Rò Petru taritaryǎhtyaní̤ ané̤ rò a htecuố ró̤kuô̌ ná èthǐ. A cuốtuố̤ dố èthǐo akhè̌nuô, èthǐ è́htya lǔ dố hidò́kǔ dố akhu tôtó̤. Rò lò̌꤮ prè̤mòokryá tahe o lahyǎ bínuô rò èthǐ kahtò nguố̤ tava̤ lò̌plǐ ná Petru rò a dyéluô̌ pé̤ Petru ná ca̤ ná ca̤klò̌ thǐtahe dố Dorca isè́ pé̤ èthǐ bí a ohtwǒprè̤ tố̤kuô̌pǎ ná èthǐ akhè̌ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petru nò̌htekyǎ lò̌ ǔ dố aklò̌ rò a dángṳ̂lya̤ kwǐcò́bè̌ tè̤. Htuô̌rò a tarí myácuố dố Dorca luô̤̌to̤ lé̤onuô rò a hé, “Tabitha꤮ kahtòmò̌” a hé rò Tabitha myákalò̌hte rò a myáhtye Petru akhè̌ a kahtò onyǎo. ");
INSERT INTO kyu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petru zó̤hyǎ atakhu rò a cwikahtò lǔ. Htuô̌rò a è́nuô̌ khyěthyá prè̤zṳ̂́etè̤phú tahe ná prè̤mòokryá tahe rò a dyéluô̌ èthǐ ná prè̤mò dố a htwǒprè̤ ka̤khyě khyěthyá yětôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tè̤ritè̤kyǎ yěnuô, a luô̌pasǐcuố tuố̤ lò̌ dố vǐ̤ Joppa tôké̤lè̤̌ rò ǔ zṳ̂́ka̤nyá̤ka̤ è́kuô̌lǎ Byacè. ");
INSERT INTO kyu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petru onyě̤kuô̌pó̤ ná èthǐ bínuô mò̤́nyěmò̤́thè̌ nyě̤kúkuô̌pǎ lǎ sálé̤ dố Simonè hi bí vǐ̤ Joppa akǔ nuô. Simonè ma kayǎ dố a me̤hte tǎ̤muô̌tǎ̤tè̤ yětahenuô ná tè̤mi̤tè̤myá̤ aphá tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Bí vǐ̤ Caesarea akǔ nuô klyěkhuklò́ dố amwi̤ ná Cornelio otôprè̤, è ma Roma klyětôzè̤ akhuklò́ dố ǔ è́ ná Itali klyěklǒ. ");
INSERT INTO kyu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","È ma kayǎ dố a mo̤ní̤ Cò́marya tôprè̤ rò è ná lò̌꤮ a hiphúphyǎphú tahenuô a beduzṳ̂́nyá̤ nyacò́ Cò́marya. A me̤cwó̤ è́nyacò́ kayǎ sǒphásǒrya̤phú tahe rò shuốkhè̌ dǎ tǒ kwǐcò́bè̌ hò́ hénuô, a kwǐcò́bè̌ pwǒ̤꤮ tôphuố cò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tônyěkhè̌ bí mò̤́hélya̤ thuô̌mû̌ phûbèhò́ akhè̌nuô, a myáhtyelwó one lǐphó cò́ Cò́marya a tanémò́khuphú tôprè̤ hyǎnuô̌ oluô̌khyé dố a hidò́kǔ rò a è́ lǔ, “Cornelio!” phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A myá otyá̤sû tanémò́khuphú rò a thè́isě kanó̤꤮ to rò “Byacè, nè̤ thè́zṳ̂́ hé vǎ ǐtě?” A sudyǎ tanémò́khuphú phúnuô, Rò tanémò́khuphú hésû è, “Cò́marya thè́plòohò́ nè̤, me̤těhérò nè̤ tè̤kwǐcò́bè̌ tahe ná nè̤ tè̤me̤cwó̤ kayǎ sǒphásǒrya̤phú tahenuô, a tuố̤htyahò́ dố Cò́marya a o thyáhò́ná nè̤ lǔhtya è nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Khǒnyá̤yě nò̌cuố è́hyǎmò̌ Simonè Petru ná kayǎ tahe dố vǐ̤ Joppa akǔ nuô. ");
INSERT INTO kyu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A cuốo dố Simonè dố a me̤phá nuôtôprè̤ ahi dố a o dố htyědutava̤htû̌ nuôtôprè̤.” ");
INSERT INTO kyu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Tanémò́khuphú htecuốkyǎ htuô̌rò, Cornelio è́hyǎ prè̤me̤tè̤phú dố a hidò́kǔ thè́nyě̤ ná klyěphú tôprè̤ dố a dyaduzṳ̂́nyá̤ Cò́marya rò a lé̤zṳ̂́e ní̤dyé lǔ yětôprè̤, rò a hésoluô̌ pé̤lò̌ èthǐ ná tè̤me̤htwǒhtya htuô̌hò́ ané̤ ná è yětahe, htuô̌rò a nò̌cuố èthǐ dố vǐ̤ Joppa. ");
INSERT INTO kyu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Dốkhyětônyě bí èthǐ cuốtuố̤phûhò́ ná vǐ̤ Joppa akhè̌nuô, Petru htya dố hikhuklwó tabye tômě akhu rò a htya kwǐcò́bè̌. Bínuô akhè̌ ma atǒ ná mò̤́phû kíré̤ htuôhò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A thè́ethè́ǒ rò ǔ taritaryǎ pé̤ lǔ sèe akhè̌ a myáhtyelwó tè̤tôcô. ");
INSERT INTO kyu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A myáhtye mò́khu lṳmǒhtya rò tè̤tôcô dố athyáná tahû̌ lyá̤du dố aná̤ o lwǐ̤ná̤ tôba rò ǔ cya̤tǎ̤ ènuô. ");
INSERT INTO kyu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lò̌꤮ tè̤phútè̤lye̤ dố a khǎduôo lwǐ̤khó nuôtahe ná lò̌꤮ tè̤phútè̤lye̤ dố a labácuố nuôtahe ná lò̌꤮ htuphúzuố̤phú dố a zuô̤ dố mò́lè̤̌ tahenuô a o lò̌plǐ dố tahû̌du yětôba akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ngó̤pra̤htya rò a hé lǔ, “Petru꤮ kahtò me̤thyěekyǎmò̌ tè̤yěnuôtahe.” ");
INSERT INTO kyu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Manárò Petru hésû, “Byacè꤮ vǎ e cò́nyǎ taki꤮ to, tè̤ dố ǔ dyahò́ è ná a sǎsè̌to nuôtahe bèbè, má̤torò a mwǒ̤plǐthǐplo to nuôtahe bèbè, vǎ enò́ è tôphuố꤮ to.” ");
INSERT INTO kyu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Rò ngó̤pra̤htya pó̤, “Tè̤ dố Cò́marya dǎhéhò́ ná a mwǒ̤plǐ prè́, rò ení̤ prè́ a hé nuôtahenuô, hé tǎ è ná a mǔmyá̤ tǎmé̤.” ");
INSERT INTO kyu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tahû̌du dố tè̤phútè̤lye̤ o dố lǔkǔ yětôbanuô, akuô̌ tǎ̤luô̌ bǎ pé̤ lǔ thuô̌phuố htuô̌rò ǔ cò̤̌htya mé̤kyǎ khyě è dố mò́khu. ");
INSERT INTO kyu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bí Petru tane̤myání̤ Cò́marya a tè̤dyéluô̌ è tè̤myáhtyelwó yě angó̤lasá akhè̌nuô, kayǎ dố Cornelio nò̌hyǎ lǔ tahenuô, a hyǎ sudyǎ myápṳ̌ Simonè ahi rò a hyǎkahtòo bí ahinyěhyǎ lo̤kadǎhtû̌nuô. ");
INSERT INTO kyu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Rò èthǐ sudyǎhtya, “Kayǎ mwi̤ ná Simonè Petru hénuô tôprè̤ ma a otǒ bíyě è̌?” ");
INSERT INTO kyu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Bí Petru tane̤ní̤pǎ tè̤myáhtyelwó yě akhè̌nuô, Thè́ Sǎsè̌ Byacè hé lǔ, “Simonè! Kayǎ hyǎmyápṳ̌ nè̤ thè́thuô̌. ");
INSERT INTO kyu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Phúnuô akhu-akhyě hítǎ̤mò̌ dố hilè̤̌ nuô, me̤ pyá̤zè̤́pyá̤sè̌ tǎmé̤, tarú krwǒcuốkuô̌ èthǐ nuôtahe akhyěnuô, me̤těhérò vǎ nò̌hyǎnyǎ èthǐ dố nè̤o.” ");
INSERT INTO kyu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phúnuôrò Petru hítǎ̤ dố hilè̤̌ rò a hé èthǐ, “Vǎ ma kayǎ dố thǐ hyǎ myápṳ̌ è nuôtôprè̤ hò́. Thǐ hyǎmyápṳ̌ vǎ me̤tě?” ");
INSERT INTO kyu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Rò èthǐ hésû, “Klyěkhuklò́ Cornelio nò̌hyǎ pè̤. È ma kayǎcò́kayǎte̤ tôprè̤, htuô̌to kayǎ dố a bezṳ̂́benyá̤lǎ Cò́marya tôprè̤. Judaphú tahe bezṳ̂́nyá̤ní̤ lò̌plǐ cò́ lǔ pwǒ̤꤮ tôprè̤ cò́. Thyáphú a ki ní̤huô̌nò́ kuô̌ nè̤ tè̤hébèhésû̌ tahenuô rò Cò́marya a tanémò́khuphú hyǎ hé lǔ ná bè cuố è́hyǎ nè̤ dố lǔhi.” ");
INSERT INTO kyu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Rò Petru è́ omyěsû èthǐ. Htuô̌rò parǒ tônyěnuô, Petru taritaryǎ ané̤ rò a krwǒcuốkuô̌ èthǐ. Prè̤zṳ̂́enyá̤ephú dố a o dố vǐ̤ Joppa akǔ tahe krwǒcuốkuô̌ lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Rò dốkhyě tônyěnuô èthǐ cuốtuố̤ dố vǐ̤ Caesarea bí Cornelio lé̤è́plò́ ní̤dyé apuố̤vyá̤ tatò tahe ná akhǒathyó tahe akhǎlé̤, rò èthǐ bínuôtahe opò̤́myásû̌ ní̤ lahyǎ Petru. ");
INSERT INTO kyu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bí Petru kíré̤ nuô̌ dố hidò́kǔ akhè̌nuô, Cornelio è́mo̤sû lǔ rò a dángṳ̂lya̤ ngò̤taklwítǎ̤ dố lǔ khǎduôshyé rò a cò́bè̌htya lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Manárò Petru nò̌kahtòkhyě è rò a hé lǔ, “Kahtòmò̌꤮ vǎ ma prè̤lu kayǎ thyáná nè̤ prè́.” ");
INSERT INTO kyu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bí Petru ná Cornelio hébè nánuô̌ dố hidò́kǔ akhè̌nuô, a myáhtye kayǎ hyǎoplu-ophè, oplò́one lahyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petru hé èthǐ, “Thǐ thè́gně dûhò́, pè̤ Judaphú a tè̤thyótè̤thya oná Judaphú tôprè̤ kíré̤ cuốbò́thyókhè́khǒ tố̤ná Judaphú má̤to tahe bèbè, a kíré̤ cuốolěo kuô̌ prè́ èthǐ bèbè, aní̤ to. Manárò Cò́marya dyéluô̌hò́ vǎ ná Judaphú má̤to tahe nuôma a mwǒ̤plǐ kuô̌ǔ to, má̤torò a sǎsè̌ kuô̌ǔ to hé tǎ lahyǎ tǎmé̤, pè̤ tǒbè bò́thyó lò̌plǐ èthǐ, Cò́marya dyéluô̌ vǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Phúnuô akhu-akhyě bí nè̤ è́hyǎ vǎ akhè̌nuô, vǎ hésû pǎ tôcô꤮ to, vǎ hyǎ tôphuốhyǎ prè́. Phúnuôrò khǒnyá̤yě vǎ thè́zṳ̂́ sudyǎ nè̤, nè̤ è́hyǎ vǎ me̤tě?” nuôprè́. ");
INSERT INTO kyu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Rò Cornelio hé pé̤ lǔ, “Bí a talwókyǎ thuô̌thè̌ mò̤́hélya̤ thuô̌mû̌ athyáná khǒnyá̤khè̌ yěnuôhò́, vǎ kwǐcò́bè̌ tè̤. Bínuôakhè̌, kayǎ kû̌thyání̤ hyeca̤ takhè̌plyarashyǐ tôprè̤ hyǎkahtòo khyé dố vǎ mèthènyě. ");
INSERT INTO kyu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Rò a hé vǎ, ‘Cornelio꤮ Cò́marya ní̤huô̌hò́ nè̤ tè̤kwǐcò́bè̌ hò́. A thè́né̤htyabè tuố̤ hò́ nè̤dyénè̤zṳ̌ pé̤ kayǎ sǒphásǒrya̤phú nuôtahe hò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nò̌cuốmò̌ kayǎ tahe rò nò̌cuốè́ èthǐ ná kayǎ tôprè̤ dố amwi̤ ná Simonè Petru dố a o dố vǐ̤ Joppa nuôtôprè̤. Khǒnyá̤rò a cuố okuốkuô̌ dố amwǐ̤ Simonè ahi hò́. Simonè yěnuôma ahi o dố htyědutava̤htû̌, è ma prè̤me̤phá tôprè̤.’ ");
INSERT INTO kyu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Phúnuôrò vǎ nò̌cuốè́ ǔ ná nè̤ tôphuốtuô̌ cò́, nè̤ hyǎtuố̤kuô̌ pè̤ rò aryá nyacò́. Thyáphú pè̤ ki ní̤huô̌nò́ kuô̌lò̌ Cò́marya hésotǎ̤ htuô̌hò́ nè̤ nuôtahe rò khǒnyá̤yě pè̤ hyǎ lò̌plǐ dố Cò́marya a mèthènyěhò́.” ");
INSERT INTO kyu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petru cáhtya hébè, “Khǒnyá̤rò vǎ thè́gně ná Cò́marya myádumyápatí ǔ tôprè̤꤮ to nuôma a má̤lakǒ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kayǎ myěcô ǐtětě꤮ bèbè, ki a bezṳ̂́benyá̤ Cò́marya rò a ki me̤tǒme̤bè tè̤ hénuôma Cò́marya è́mo̤sû èthǐ prè́. ");
INSERT INTO kyu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Thǐ thè́gně htuô̌dû hò́ tè̤ritè̤kyǎ dố Cò́marya nò̌hyǎ pé̤ Jesǔ dố Israel aklwǐalyǎ tahe agně rò a hyǎ hésoluô̌ pé̤ èthǐ ná tè̤thè́krṳ̂̌mila ari-akyǎ yěnuô hò́. Dố Jesǔ Krístu dố a htwǒ ǔ pwǒ̤꤮ tôprè̤ a Byacè yětôprè̤ akhu-akhyěrò pè̤ ní̤bèhò́ tè̤pě̤tè̤dwǒ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Dố Judaké̤ tôké̤lè̤̌ akǔnuô, Byacè Jesǔ me̤htuô̌hò́ kryá꤮ maǐtě nuôma thǐ thè́gně dû hò́. Bí Giovanni hésodônyǎ htuô̌pé̤hò́ ǔ ná plwǒhtyě ari-akyǎ akhè̌nuô, Jesǔ cáhtya me̤tè̤ dố Galilea ké̤kǔ. ");
INSERT INTO kyu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Htuô̌rò Cò́marya nwóhtya vǐ̤ Nazarèphú Jesǔ rò a dyé lǔ Thè́ Sǎsè̌ Byacè ná a tè̤pro̤tè̤prya̤ phútě nuô, thǐ thè́gně htuô̌dûhò́. Jesǔ lěcuố dố khǎlé̤ pwǒ̤꤮ tôpho rò cuố me̤bwíme̤taryě pé̤ ǔ, zasǐmé̤ka̤ kayǎ o dố khǐnéricyá̤ khuklò́ me̤nû̌me̤cá lǔ tahe, me̤těhérò Cò́marya okuô̌ ná è akhu-akhyě a me̤hò́ tè̤ phúnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Pè̤ ma kayǎ tahe dố a khyáluô̌ pé̤ lò̌ ǔ ná lò̌꤮ Jesǔ me̤htuô̌hò́ tè̤ dố Judaphú tahe o ní̤dyé ké̤ tahe, ná vǐ̤ Jerusalem akǔ yěnuôtahe ari-akyǎ prè́. Htuô̌rò èthǐ mṳ̂̌thyěhtyakyǎ Jesǔ dố krusu alo̤. ");
INSERT INTO kyu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Manárò bí thuô̌thè̌ tôthè̌nuô, Cò́marya me̤htwǒprè̤ ihtòka̤khyě khyěthyá lǔ dố tè̤thyě rò a dyéoluô̌htya khyěthyá lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A oluô̌htya pé̤ ǔ pwǒ̤꤮ tôprè̤ má̤to. A oluô̌htya pé̤ tû́prè́ Cò́marya nwóhtyahò́ pè̤ dố pè̤ ki htwǒhtya prè̤khyáthè́ yětahe nuôprè́. A thyěihtò ka̤khyě htuô̌hò́ akhè̌nuô, pè̤ yětahenuô, pè̤ eró̤ǒró̤ tố̤kuô̌ htuô̌hò́ ná lǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Rò a mekyǎ pó̤ pè̤ ná pè̤ ki cuố hésodônyǎ pé̤ ǔ ná tè̤thè́krṳ̂̌mila, htuô̌rò pè̤ ki cuốkhyáluô̌ pé̤ ǔ pè̤thè́ ná è ma kayǎ tôprè̤ dố Cò́marya nwóhtya lǔ rò è ma a ki htwǒ pé̤ kayǎ htwǒprè̤ tahe ná kayǎthyě tahe a prè̤ciryatè̤ pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Prè̤pro̤ pwǒ̤꤮ tôprè̤ hésodônyǎ one htuô̌hò́ è ari-akyǎ rò èthǐ hé, ‘Lò̌꤮ kayǎ dố a zṳ̂́enyá̤e lǔ tahenuô Cò́marya ki plwǒkyǎ dǐtû́ èthǐ atè̤thû́ ná èmwi̤khyě pǎ,’” Petru hé pé̤ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bí Petru hébè pǎprè́ akhè̌nuô, Thè́ Sǎsè̌ Byacè hyǎlya̤ dố kayǎ dố a ní̤dǎ tè̤ritè̤kyǎ yětahe alo̤ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Cò́marya cuố dyélya̤ tuố̤kuô̌ Thè́ Sǎsè̌ Byacè dố Judaphú má̤to yětahe alo̤ akhu-akhyě, Judaphú dố a zṳ̂́ka̤nyá̤ka̤ hò́ tè̤ rò a o lahyǎ dố vǐ̤ Joppa akǔ rò a hyǎ ró̤kuô̌ ná Petru yětahenuô a khyéthukhyéthè́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Me̤těhérò èthǐ ní̤huô̌ dû kayǎ yětahe hébè ná ngó̤khókhye tahe akhu-akhyě, èthǐ htuthè́htya lahyǎ Cò́marya. Htuô̌rò Petru hé, ");
INSERT INTO kyu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kayǎ yětahe ní̤bèkuô̌ Thè́ Sǎsè̌ Byacè phú pè̤ ní̤bè htuô̌hò́ yěnuôhò́. Me̤phúnuôrò èthǐ ki plwǒ ané̤ ná htyě agněnuô maǔpě tôprè̤ ki me̤tǎ̤tṳ̂̌cyá̤ èthǐ pě.” ");
INSERT INTO kyu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Phúnuô akhu-akhyě Petru hétǎ̤ngó̤ ná èthǐ ki plwǒ ané̤ ná htyě dố Jesǔ amwi̤ akǔ. Rò èthǐ kwǐthè́zò̤ Petru ná a okuô̌pó̤ ná èthǐ bínuô nyě̤thuô̌thè̌. ");
INSERT INTO kyu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Prè̤dônyǎphú ná prè̤zṳ̂́etè̤phú dố a o dố Judaké̤ pwǒ̤꤮ tôpho tahenuô, a ní̤huô̌ ná Judaphú má̤to tahe ní̤bè kuô̌hò́ Cò́marya alǎ̤angó̤. ");
INSERT INTO kyu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Phúnuôrò bí Petru cuố dố vǐ̤ Jerusalem akhè̌nuô, prè̤zṳ̂́enyá̤ephú dố a dû́talíphá tahenuô, a dya tè̤thû́ dố lǔkhu. ");
INSERT INTO kyu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Rò èthǐ hé Petru, “Nè̤ cuốolě tuố̤kuô̌ Judaphú má̤to dố a dû́talí kuô̌ǔ phá to tahe ahi rò nè̤ cuốecuốǒ tố̤kuô̌ tuố̤ ná èthǐ.” ");
INSERT INTO kyu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Rò Petru hésoluô̌plǒ pé̤lò̌ èthǐ tè̤ritè̤kyǎ dố a cá htwǒhtya lú dố akhǎshyé tuố̤dố atadû nuôtahe pwǒ̤tôcô. ");
INSERT INTO kyu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Rò a hésoluô̌plǒ pé̤ èthǐ, “Bí vǎ o dố vǐ̤ Joppa rò vǎ kwǐcò́bè̌ akhè̌nuô, vǎ myáhtyelwó tè̤tôcô. Vǎ tè̤myáhtyelwó yěnuô, a o dố mò́khu rò a cya̤tǎ̤ pé̤ vǎ thyáná tahû̌du dố aná̤ o lwǐ̤ná̤ tôbanuô. Htuô̌rò a cya̤tǎ̤ phûtatò bí vǎ khǎshyé. ");
INSERT INTO kyu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Vǎ myánuô̌ tǎ̤te̤ dố tahû̌du yěakǔnuô rò vǎ myáhtye tè̤phútè̤lye̤ dố akhǎduô o lwǐ̤khó tahe, tè̤mi̤tè̤myá̤ tahe ná tè̤phútè̤lye̤ dố alabácuố tahe ná htuphú dố a zuô̤ dố mò́lè̤̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yětôphuốrò vǎ ní̤huô̌ ngó̤pra̤htya rò a hé vǎ, ‘Petru, ihtò mṳ̂̌thyěekyǎ mò̌ tè̤yěnuôtahe.’ ");
INSERT INTO kyu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Manárò vǎ hésû, ‘Byacè꤮ vǎ e꤮ nyǎ ná taki꤮ to. Tè̤ dố ǔ be è ná a sǎsè̌ to tahe ná a mwǒ̤plǐ to tahenuô, vǎ enò́ ná tôphuố꤮ to.’ ");
INSERT INTO kyu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Rò ngó̤pra̤htya dố mò́khu yěnuô hé pó̤, ‘Cò́marya dǎhé ná a mwǒ̤plǐ hénuôma, a sǎsè̌ to, bè tane̤ ní̤ to.’ ");
INSERT INTO kyu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Rò a kuô̌tǎ̤ bǎ thuô̌phuố rò dốkhyělố tôphuốnuô, ǔ phyéhtya dwókyǎ è dố mò́khu. ");
INSERT INTO kyu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ǔ phyéhtyakyǎkyǎ ná tôphuốtuô̌ kayǎ vǐ̤ Caesareaphú thè́thuô̌ dố ǔ nò̌hyǎ èthǐ yětahenuô, ló꤮, a hyǎtuố̤ bí pè̤ lé̤cuốokuốní̤ hi nuôtômě. ");
INSERT INTO kyu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yětôphuốrò Thè́ Sǎsè̌ Byacè hé vǎ ná me̤pyá̤zè̤́pyá̤sè̌ tǎmé̤, krwǒcuố lè́kuô̌mò̌ èthǐnuô. Rò puố̤vyá̤ dố vǐ̤ Joppa aprè̤thuô̌thyó yě krwǒcuốkuô̌ ná vǎ tuố̤dố vǐ̤ Caesarea rò pè̤ nuô̌kuô̌ dố Cornelio ahikǔ pwǒ̤꤮ tôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Cornelio héso pé̤ pè̤ ná a myáhtye tanémò́khuphú tôprè̤ hyǎkahtòo dố a hidò́kǔ ari-akyǎ rò a hé lǔ, ‘Nò̌cuố kayǎ tôprè̤ dố vǐ̤ Joppa rò nò̌cuốè́hyǎ kayǎmwi̤ ná Simonè dố ǔ è́ pǎ lǔmwi̤ ná Petru nuôtôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A ki hébètè̤ ná nè̤ pǎ rò dố a hébè thǐ akhu-akhyě nè̤ ná nè̤ hiphúphyǎphú lò̌꤮ plǐ ki ní̤bè tè̤me̤lwóhteka̤ pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Rò bí vǎ cáhtya hébètè̤ akhè̌nuô, Thè́ Sǎsè̌ Byacè hyǎlya̤ dố èthǐ alo̤ phú a hyǎlya̤ htuô̌hò́ dố pè̤lo̤ dố kalúkhè̌ nuôtôphuố nuôhò́. ");
INSERT INTO kyu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yětôphuốrò vǎ thè́né̤htyabè tuố̤ tè̤hébè dố Byacè hékyǎ, ‘Giovanni plwǒ thǐ ná htyě tadû́rò ǔ ki plwǒ thǐ ná Thè́ Sǎsè̌ Byacè pǎ nuôtômû̌.’ ");
INSERT INTO kyu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Me̤phúnuôrò pè̤ zṳ̂́e Byacè Jesǔ Krístu rò Cò́marya dyé pè̤ shyězṳ́, phúnuôhò́ Judaphú má̤to dố a zṳ̂́e thyákuô̌ná pè̤ yětahenuô, Cò́marya ki dyé thyákuô̌ èthǐ shyězṳ́ phú a dyé htuô̌hò́ pè̤nuô kihérò vǎ ma kayǎ tôprè̤ dố a pṳ̌ me̤tǎ̤tṳ̂̌ Cò́marya aklyáaklǒ tôprè̤ è̌?”, Petru hé pé̤ èthǐ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bí èthǐ ní̤huô̌ tè̤ritè̤kyǎ yě akhè̌nuô, èthǐ pacyé̤ishyé pǎ Petru to, rò a htuthè́htya lahyǎ Cò́marya, “Ki a má̤lakǒ phúnuôhérò Cò́marya dyépé̤kuô̌hò́ Judaphú má̤to tahe tè̤shuốkhè̌ryá dố a ki za̤ ní̤dûkuô̌ lahyǎ ané̤ rò a ki ní̤bè kuô̌ lahyǎ thè́htwǒprè̤ hò́.” ");
INSERT INTO kyu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Dố ǔ me̤thyě Stephano akhu-akhyě, cáhtya bínuôrò ǔ me̤cyě̤me̤cṳ̂ kayǎ dố a zṳ̂́ka̤nyá̤ka̤ Jesǔ tahe phúnuôrò èthǐ lṳpruốlṳpryǎ cuố lò̌plǐ. Tahehenuô a cuốtuố̤ dố Phonicia ké̤, Cyprú klû́khu ná vǐ̤ Antioko. Èthǐ hésodônyǎ pé̤ tû́prè́ Judaphú thǐ tahenuô ná Cò́marya alǎ̤angó̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Manárò Cyprúklû́phú ná vǐ̤ Cyreneophú dố a zṳ̂́ka̤nyá̤ka̤tè̤ aklè̌ tahehenuô, a cuốtuố̤ dố vǐ̤ Antioko rò a hésodônyǎ pé̤ myěcôruô Greekphú tahe ná Jesǔ Krístu a tè̤thè́krṳ̂̌mila ari-akyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Rò Cò́marya a tè̤pro̤tè̤prya̤ o ná èthǐ akhu-akhyě kayǎ zṳ̂́ka̤pluka̤phè rò athè́plò htulya ka̤tǒ lahyǎ dố Byacè o. ");
INSERT INTO kyu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tè̤ritè̤kyǎ yě luô̌cuốtuố̤ dố Jerusalem prè̤zṳ̂́etè̤plò́mṳ a o akhu-akhyě èthǐ thǔcuố Barnaba dố vǐ̤ Antioko. ");
INSERT INTO kyu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Rò bí a cuốtuố̤ akhè̌, a cuốmyáhtye ná kayǎ yětahe ní̤bè Cò́marya abwíataryě akhu-akhyě a thè́krṳ̂̌thè́lò̌ nyacò́ rò thyáphú èthǐ ki ohtwǒprè̤ cò́ plehyǎ tadû ná Byacè rò, a dyéhè̌dyére shyakrwǒ kuô̌pó̤ èthǐ akhyě. ");
INSERT INTO kyu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba ma kayǎ dố aryá rò a lốbǎ ná Thè́ Sǎsè̌ Byacè tôprè̤. Rò è ma kayǎ dố a tè̤zṳ̂́tè̤nyá̤ sò̌ tôprè̤. Rò a me̤cwó̤ è́ pé̤lǎ ǔ rò ǔ zṳ̂́ka̤nyá̤ka̤ è́lǎ Byacè. ");
INSERT INTO kyu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Phúnuôhtuô̌rò dốkhyěnuô, Barnaba cuốmyápṳ̌ Saulu dố vǐ̤ Tarso akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bí a myáhtye lǔ akhè̌nuô, a è́ka̤ní̤ lǔ dố vǐ̤ Antioko. Rò èthǐ yěthè́nyě̤ ka̤-okú myáhtye tǎ̤sû ná prè̤zṳ̂́etè̤ plò́mṳphú bínuô tahe tôna꤮ hyǎ cò́. Rò a ithyóithyatǎ̤ ní̤è́ pé̤lǎ kayǎ obínuô tahe. Ǔ è́ré̤lố prè̤zṳ̂́etè̤phú tahe ná Krístuphú ma bí vǐ̤ Antioko yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bínuôakhè̌, prè̤pro̤ tahe o dố vǐ̤ Jerusalem rò a hyǎ dố vǐ̤ Antioko. ");
INSERT INTO kyu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Dố èthǐ aklè̌nuô amwi̤ ná Aghabu otôprè̤. Dố Thè́ Sǎsè̌ Byacè a tè̤pro̤tè̤prya̤ akhu-akhyě, a ihtò rò a hépro̤ one ngó̤ ná tè̤ovǐ̤okò̌ cyě̤cṳ̂ ki ohtya dố hekhusǐba lò̌ pǎ. (Yěnuôma a htwǒhtya bí Claudio htwǒ khwí akhè̌nuô.) ");
INSERT INTO kyu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Prè̤zṳ̂́etè̤phú pwǒ̤꤮ tôprè̤ belya̤ lahyǎ athè́plò ná a ki thǔcuố pé̤ kuô̌ tè̤me̤cwó̤ bá èthǐ dyébè́ nuô, dố èthǐ puố̤vyá̤ o dố Judaké̤kǔ nuôtahe. ");
INSERT INTO kyu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Phúnuôrò a thǔcuốní̤ rû̌yě ná Saulu ná Barnaba. Saulu ná Barnaba phyécuốní̤ rû̌yě rò a cuố dyétǎ̤ dǐtû́ dố prè̤zṳ̂́etè̤plò́mṳ muố̤prû̌muố̤prè̤́ dố a htwǒ khuklò́khuklyǎ tahe a takhukǔ. ");
INSERT INTO kyu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bínuôakhè̌ Khwí Herodè cáhtya me̤cyě̤me̤cṳ̂ prè̤zṳ̂́etè̤ plò́mṳphú tahe. ");
INSERT INTO kyu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Dố a hétǎ̤ angó̤ akhu-akhyě, ǔ sû̌thyěkyǎ Giovanni avyá̤ Jakomo ná nè́. ");
INSERT INTO kyu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A myáhtye ná a me̤tè̤ phúyěnuô, atǒ ná Judaphú tahe athè́plò akhu-akhyě, a hé tǎ̤pó̤ angó̤ ná bè pṳ̂́ pó̤ Petru. Tè̤me̤ yěnuô a htwǒhtya bí pwè̌khò́mǔ sǒdǒ huô̌mûtapho akhè̌nuô. ");
INSERT INTO kyu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ǔ pṳ̂́ htuô̌ Petru rò ǔ dò́tǎ̤ lǔ dố htò̌kǔ. Ǔ dyétǎ̤ klyěphú lwǐ̤mṳ atè̤me̤ dố èthǐ bè opò̤́ní̤ lǔ. Èthǐ opò̤́ tômṳ htuô̌ tômṳ. Tômṳnuô a o thè́lwǐ̤. Bí pwè̌ htuô̌hò́ akhè̌nuô, Khwí Herodè tane̤ ná a ki ce̤myá Petru rò a ki cirya lǔ dố kayǎ bè́mṳ a mèthènyě pǎ. ");
INSERT INTO kyu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Phúnuôrò ǔ dò́o tadû pǎ Petru dố htò̌kǔ. Manárò prè̤zṳ̂́etè̤ plò́mṳphú tahe thè́plòshyo kwǐcò́bè̌ pé̤ nyacò́ dố lǔgně. ");
INSERT INTO kyu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bí Khwí Herodè è́hte tyahí Petru dố kayǎ bè́mṳ a mèthènyě híto tôthè̌nuô, Petru omyěo dố klyěphú thè́nyě̤ aplèkǔ. Ǔ cò̌klò̤ma è ná suplye̤tò̤́htè́ nyě̤bǒ. Htuô̌to klyěphú tahe opò̤́ olò̌ bí lé̤dò́tǎ̤ ǔ htò̌ kadǎhtû̌nuô. ");
INSERT INTO kyu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Byacè a tanémò́khuphú tôprè̤ hyǎ kahtò oluô̌khyé bínuô rò a lǐhtya lò̌ bí Petru o ní̤dyé a po̤kǔnuô. Tanémò́khuphú plyá̤ Petru plǎkhu rò a hturyǎ̤kahtò lǔ rò a hé lǔ, “kahtòpryǎmò̌” tôphuốtuô̌ suplye̤tò̤́htè́ o dố Petru atakhu nyě̤khólò̌ akǔ yěnuô a latǎ̤ plwóhtekyǎ lò̌ ní̤dyédû ané̤. ");
INSERT INTO kyu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Htuô̌rò tanémò́khuphú hé lǔ, “Nyá̤htya nè̤ nyá̤htò́ rò dyání̤ nè̤ khuphánuô.” Rò Petru krwǒme̤kuô̌ phú tanémò́khuphú hé è nuô. Rò a hé pó̤ lǔ, “Ihtò́htyaní̤ nè̤ ikè̤̌nuô rò krwǒcuốkuô̌ vǎkhyěyě.” ");
INSERT INTO kyu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Rò Petru krwǒhte kuô̌ lǔkhyě tuố̤dố htò̌klò̌. Manárò tanémò́khuphú me̤pé̤ lǔ phú yěnuôma a má̤lakǒ è̌, má̤to è̌ nuô Petru thè́gně tǎ̤te̤ to. A tane̤prè́ ná a myáhtyelwótè̤ prè́. ");
INSERT INTO kyu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Èthǐ cuốtalwóbè́kyǎhtuô̌ prè̤opò̤́kadǎ aré̤lố tôtó̤ htuô̌rò a cuố talwóbè́ pó̤ nyě̤tó̤tôtó̤. Dốkhyělố rò a cuốtuố̤ dố kadǎ dố ǔ me̤ è ná tò̤́htè́ nuôtôkǔ. Kadǎkǔ yětôkǔnuô ma a cuốluplú nuô̌tǒ cò́ dố vǐ̤kǔ rò a lṳmǒhtya pé̤ ní̤dyédû èthǐ prè́, rò èthǐ htecuốkyǎ bí kadǎ yěnuôtôkǔ. Rò èthǐ krwǒcuốrwó prè́ vǐ̤kǔklyá yětôbǒ rò tanémò́khuphú lamé̤khyékyǎ pé̤ Petru. ");
INSERT INTO kyu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","A lamé̤htuô̌ pé̤ lǔ tû́rò Petru thè́gněno prè́ tè̤htwǒhtya-ané̤ ná èyě prè́ rò a hé, “Khǒnyá̤yě vǎ thè́gněhò́ ná tè̤me̤htwǒhtya ané̤ phúyěnuôma a má̤lakǒ cò́. Byacè Cò́marya nò̌hyǎ a tanémò́khuphú rò a hyǎ me̤siplè́ htekyǎ vǎ dố Khwí Herodè a taryěshyosò̌ alè̤̌, htuô̌to a hyǎ me̤lwóhteka̤ vǎ dố Judaphú dố a myásû̌ dố a ki me̤cyě̤ vǎ tahe a takhukǔ.” ");
INSERT INTO kyu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Bí a thè́gněhyǎhò́ ná tè̤me̤htwǒhtya ané̤yě ma a má̤lakǒ cò́ hò́ akhè̌nuô, a cuố dố Giovanni dố ǔ è́pó̤ amwi̤ ná Marko yětôprè̤ amuố̤ Maria ahi, rò bínuôkhè̌nuô, a tǒtû́ ná ǔ hyǎ oplò́oplu kwǐcò́bè̌ ró̤lò̌ lǔ bínuô. ");
INSERT INTO kyu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petru ka̤dò kadǎdu dố hinyěhyǎnuô tôkǔ rò thyáphú èthǐ ki thè́gně ná maǔpě dò kadǎ pě nuô rò lulé prè̤mòphú dố amwi̤ ná Rhoda hé yětôprè̤ cuốmyásû lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rò a thè́gně Petru talǎ̤ rò a thè́krṳ̂̌ talwósû́lû̌ rò a sǒtapa̤ bámǒ pé̤ lǔ kadǎ rò a klyakanuô̌ héso pé̤ èthǐ ná Petru kahtòo dố aklò̌nuô. ");
INSERT INTO kyu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Ma nè̤ tamwǐ è̌?” Èthǐ hésû Rhoda phúnuô, tadû́rò a má̤lakǒ cò́ Rhoda hésǎprè̤́sû èthǐ phúnuô. “Petru azo̤ prè́kǒ” èthǐ hésû ka̤khyě lǔ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bínuôakhè̌ Petru dò plehyǎ pó̤ kadǎ rò èthǐ bámǒ kadǎ rò a myáhtye Petru rò èthǐ khyéthukhyéthè́ kanó̤꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petru thè́zṳ̂́ nò̌thuôthuô꤮ o èthǐ rò a vû́vyá̤luô̌ pé̤ èthǐ ná atakhu. Rò a héso pé̤ èthǐ ná Byacè Cò́marya me̤siplè́hte kryá꤮ è dố htò̌kǔ phútě ari-akyǎ. Rò a hé, “Héso pé̤kuô̌ Jakomo ná lò̌꤮ prè̤zṳ̂́etè̤phú dố aruô nuôtahe ná tè̤ritè̤kyǎ yěnuô ní꤮,” Petru héhtuô̌kyǎ pé̤ èthǐ phúnuô rò a htecuốkyǎ dố aruô tôpho. ");
INSERT INTO kyu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mò̤́lǐbǔ hò́ rò prè̤opò̤́ htò̌ tahe tane̤ thè́plòsúsá nyacò́ rò a hé ní̤dyé khyě lǔ, “Petru cuốhteplè́cyá̤ phútětě?” ");
INSERT INTO kyu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Khwí Herodè hétǎ̤ angó̤, a nò̌ myápṳ̌ khyěthyá aklyěphú tahe ná Petru tadû́rò èthǐ myáhtye pǎ lǔ to. Phúnuô akhu-akhyě a cuố ce̤myá prè̤opò̤́ htò̌ yětahe rò a hétǎ̤kyǎ angó̤ ná me̤thyěkyǎ prè̤opò̤́ htò̌ nuôtahe. Tè̤htwǒhtya-ané̤ phúnuô htuô̌rò dốkhyěnuô Khwí Herodè htecuốkyǎ bí Judaké̤nuô rò a htecuố okuố dố vǐ̤ Caesarea. ");
INSERT INTO kyu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Khwí Herodè thè́plòdu nyacò́ vǐ̤ Tyrephú tahe ná vǐ̤ Sidophú tahe. Phúnuôkhukhyěrò thyáphú èthǐ ki cuốmyáhtye hébèní̤ ná Khwí Herodè yěnuôrò èthǐ vǐ̤phú tahe cuốró̤lǔ dố Khwí Herodè a o. Aré̤lố rò èthǐ cuốhébè plǒré̤ ná Blasto dố a ki me̤cwó̤ pé̤ èthǐ agně, me̤těhérò è ma a htwǒ prè̤zṳ̌klyázṳ̌klǒ cwó̤ khwí rò kayǎ dố khwí zṳ̂́ení̤ lǔ tôprè̤. Dốkhyě rò èthǐ cuốkwǐ tè̤pě̤tè̤dwǒ dố khwí a o, me̤těhérò khwí yětôprè̤ ahtyěaké̤ nuô, a me̤cwó̤ pé̤ èthǐ htyěphúké̤phú ná sèesèǒ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tônyěkhè̌ bí ǔ nwóhtya khódû hò́ Khwí Herodè akhè̌nuô, akû̌athyáhtyaní̤ khwíhyeca̤ rò a onyǎo dố khwí a khuklyáhtè̌htyalô̌khu rò a hébètǎ̤ kayǎ bè́mṳ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Rò èthǐ è́htǒhtya, “Khwí dố a hébè yětôprè̤ ma prè̤lukayǎ má̤to. Má̤cò́dû cò́marya tôprè̤ cò́hò́.” ");
INSERT INTO kyu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tôphuốtuô̌, Byacè a tanémò́khuphú tôprè̤ me̤swíme̤sè̌ Khwí Herodè, me̤těhérò a tǒ htuthè́htya Cò́marya tadû́rò a cuố nò̌htuthè́htya ané̤ ná prè̤lukayǎ. Rò zǎ̤ ethyěkyǎ lǔ. ");
INSERT INTO kyu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Manárò Cò́marya alǎ̤angó̤nuô, a luô̌pasǐcuố ye̤ plehyǎpó̤ dố nyě rò ǔ zṳ̂́ka̤nyá̤ka̤ è́htya ná è́htya cò́. ");
INSERT INTO kyu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Rò Barnaba ná Saulu me̤htuô̌ atè̤me̤ bí vǐ̤ Jerusalem akǔ nuôrò a è́ní̤ Giovanni dố ǔ è́pó̤ lǔmwi̤ ná Marko yětôprè̤ rò a hteka̤kyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Prè̤zṳ̂́etè̤plò́mṳ bí vǐ̤ Antioko akǔnuô prè̤pro̤ ná Thárá o tahe. Maǔpě hénuôma Barnaba, Simeonè (Dố ǔ è́ lǔ ná kayǎzyelò̤) ná Lucio (Vǐ̤ Cyreneophú), Menaen (Ǔ buô duhtya ró̤kuô̌ è ná Khwí Herodè) ná Saulu yětahe hò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bí èthǐ cò́bucò́bè̌htya Byacè rò duôe sèesèǒ akhè̌nuô, Thè́ Sǎsè̌ Byacè hé èthǐ, “Nwóhte khókyǎ pé̤ vǎ Barnaba ná Saulu nuô. Me̤těhérò vǎ nwóhtya one htuô̌hò́ èthǐ dố a ki bè me̤ vǎ tè̤me̤.” ");
INSERT INTO kyu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Èthǐ duôe sèesèǒ rò a kwǐcò́bè̌, htuô̌rò èthǐ dyahtya atakhu dố Saulu ná Barnaba alo̤ rò a nò̌htecuố èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnaba ná Saulu cuố phú Thè́ Sǎsè̌ Byacè nò̌cuố èthǐ nuô. Èthǐ tǎ̤lya̤cuố dố vǐ̤ Seleucia bí ǔ lé̤ka̤báo thòklyědu akhǎlé̤ nuôtôpho rò èthǐ htya sidyání̤ lahyǎ thòklyědu bínuô rò htecuố dố Cyprú klû́. ");
INSERT INTO kyu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bí èthǐ cuốtuố̤ dố vǐ̤ Salami akhè̌nuô, a cuố hésodônyǎ pé̤ ǔ ná Cò́marya alǎ̤angó̤ dố Judaphú tè̤cò́bè̌hǒ tahe akǔ. Giovanni Marko cuố tố̤kuô̌ ná èthǐ rò a me̤cwó̤kuô̌ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Èthǐ cuốhtyanuô̌ dố Cyprú klû́khu rò a cuố luplú tuố̤dố vǐ̤ Papho o dố klû́tadû nuôtôvǐ̤. Èthǐ myáhtye tǎ̤sû ná Juda prè̤pro̤ lahǒlahyaphú dố a cuốlě dyéluô̌ pé̤ ǔ ná tè̤me̤taple ǔmèthè tôprè̤. Amwi̤ ná Bar‑Jesǔ. ");
INSERT INTO kyu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","È ma a me̤pé̤ khwídu Sergio tè̤me̤. Khwídu Sergio ma kayǎ dố a dè tôprè̤. A thè́zṳ̂́ ní̤huô̌ Cò́marya alǎ̤angó̤ rò a è́hyǎ Barnaba ná Saulu. ");
INSERT INTO kyu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Manárò kayǎ me̤taple ǔ mèthè Elyma yětôprè̤nuô, (Yěma Bar‑Jesǔ amwi̤ ná Greek ngó̤), thyáphú khwídu kizṳ̂́kinyá̤ kuô̌ tǎmé̤ nuôrò, a pṳ̌ me̤dídyǎ tǎ̤tṳ̂̌ èthǐ. ");
INSERT INTO kyu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Bínuô Saulu (Ǔ thè́gně kuô̌pó̤ èmwi̤ ná Paulu) yětôprè̤nuô, a lốbǎ ná Thè́ Sǎsè̌ Byacè. Rò a myárè̤̌ tǒdè̌ kayǎ me̤taple ǔmèthè nuôtôprè̤. ");
INSERT INTO kyu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Rò a hé lǔ, “Nè̤ ma prè̤ dố a me̤ khǐnéricyá̤ khuklò́ atè̤me̤ tôprè̤. Nè̤ ma kayǎ dố a thè́hte lò̌꤮ tè̤ dố acò́ate̤ nuôtahe. Nè̤ lốbǎ cò́ ná tè̤lahǒlahya ná tè̤mǔmyá̤ricyá̤ pwǒ̤tôcô, nè̤ pṳ̌ me̤taplò̌taple lahǒ lò̌ Byacè a tè̤má̤tè̤cò́ yěnuô pwǒ̤꤮ tôphuố cò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Khǒnyá̤yě Byacè ki cirya nè̤, nè̤ ki mèthèkhí pǎ, Cò́marya ki nò̌lǐka̤khyě nè̤ to hénuô, nè̤ ki myáhtyecyá̤ pǎ tè̤lǐ tohò́.” Rò amèthè ò́ruố̤kyǎ rò a khíkyǎ tôphuốkhí cò́. Rò akluốaphû̌ cuốprè́ rò a myápṳ̌ kayǎ dố a ki pṳ̂́cwithǔcuố lǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bí khwídu yětôprè̤ myáhtye tè̤me̤htwǒhtya ané̤ phúyě akhè̌nuô, a zṳ̂́ka̤nyá̤ka̤ kuô̌ Jesǔ. A ní̤huô̌ ǔ ithyó pé̤ lǔ Byacè ari-akyǎ rò a khyéthukhyéthè́ nyacò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulu ná kayǎ dố a cuố tố̤kuô̌ ná lǔ tahe sidyácuốní̤ thòklyědu bí vǐ̤ Papho nuôrò htecuố dố vǐ̤ Perga dố a o dố Pamphylia ké̤kǔnuô. Cuốtuố̤ bínuô rò Giovanni Marko htecuố khókyǎ ná èthǐ rò a ka̤khyě dố vǐ̤ Jerusalem. ");
INSERT INTO kyu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Èthǐ odố vǐ̤ Perga rò htecuố lahyǎ dố vǐ̤ Antioko o dố Pisidia ké̤kǔnuô tôvǐ̤. Rò bí Judaphú Mò̤́nyěduô bè akhè̌nuô, èthǐ cuốnuô̌ onyǎo dố tè̤cò́bè̌hǒkǔ. ");
INSERT INTO kyu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bí ǔ hốhtyahtuô̌hò́ Mosè ali tè̤thyótè̤thya ná li dố prè̤pro̤ rǎone nuôtahe akhè̌nuô, tè̤cò́bè̌hǒ khuklò́ tahe nò̌cuốsudyǎ kayǎ tôprè̤ ná èthǐ rò a hé èthǐ, “Puố̤vyá̤ thǐ꤮, thǐ lé̤dyéhè̌dyére kayǎ bè́mṳ yětahe ki o tômû̌mû̌ hérò, pè̤ thè́zṳ̂́ nò̌dyéhè̌dyére thǐ.” ");
INSERT INTO kyu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulu ihtò rò a vû́vyá̤luô̌ atakhu. Me̤těhénuôrò a thè́zṳ̂́ nò̌thuôthuô꤮ o kayǎ yětahe rò a cáhtya hébè, “Puố̤vyá̤ Israel aklwǐalyǎ thǐtahe ná Judaphú má̤to rò a cò́bucò́bè̌htya Cò́marya bíyě thǐtahe lò̌꤮ plǐ thǐ꤮, ní̤dǎ lahyǎ. ");
INSERT INTO kyu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Judaphú a Cò́marya nwóhtya pè̤ muố̤phè̌phyěphuô̌ dố꤮ nyénu tahe rò bí èthǐ cuốokuốlè́ dố Egypt ké̤ akhè̌nuô, a dyé htwǒhtya èthǐ ná kayǎ myěcôdu tôcô. Cò́marya è́hteka̤kyǎ èthǐ dố Egypt ké̤kǔ ná a tè̤pro̤tè̤prya̤ dố adu-azǎ̤ yěnuô hò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Rò a bè khyáthè́plòhtǔní̤ èthǐ dố ké̤sè̌htyěkya̤ lò̤́tamákhu nuô analwǐ̤shyě cò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kayǎ myěcôphú thuô̌thyótômyě dố a o dố Canan ké̤kǔ tahenuô Cò́marya me̤pé̤kyǎ pé̤ èthǐ, rò a dyé ké̤yětôba ná Israelphú rò a htwǒ hò́ èthǐké̤. ");
INSERT INTO kyu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tè̤ dố a ki htwǒhtya phúyěnuô, anyě̤ cò́ ana lwǐ̤zè̤nyǎ̤shyě cò́. “Phúnuô htuô̌rò dốkhyěnuô, a tuố̤hyǎ tyahí dố Prè̤pro̤ Samuelè htwǒhtya tyahí khuklò́du akhè̌ tonuô, Cò́marya dyétǎ̤ pé̤ èthǐ prè̤ciryatè̤ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Htuô̌rò èthǐ kwǐ Samuelè ná a ki nwóhtya pé̤ èthǐ khwí dố a ki pốní̤ pé̤ èthǐ tôprè̤. Rò Cò́marya nwóhtya pé̤ èthǐ ná Kish aphúkhǔ Saulu. È ma Benjamino aklwǐalyǎ rò a htwǒ pé̤ èthǐ khwí analwǐ̤shyě. ");
INSERT INTO kyu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dốkhyěrò Cò́marya dyatǎ̤kyǎ Saulu dố khwí akhǎlé̤ rò a nò̌htwǒhtyake Davi ná èthǐ khwí. Davi ari-akyǎ yěnuô Cò́marya héhtuô̌hò́, ‘Vǎ myáhtyehtuô̌hò́ Jesse aphúkhǔ Davi ma kayǎ tôprè̤ dố a me̤mo̤nyacò́ vǎ thè́plò rò a ki me̤ lò̌plǐ phú vǎ thè́zṳ̂́ nò̌me̤ lǔ nuô pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Phú Cò́marya ò́lya̤ one htuô̌hò́ ná a ki nò̌hyǎlya̤ Jesǔ phú prè̤me̤lwóhteka̤ Israel aklwǐalyǎ thǐtahe agně tôprè̤ pǎ nuô, a ki ohtwǒhtya dố Davi aklwǐalyǎ tǎ̤palya̤ dǐtû́ yěnuô pǎ a hé phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Bí Jesǔ hyǎ tyahíto nuô, Giovanni hésodônyǎ pé̤lò̌ Israelphú tahe ná èthǐ ki za̤ ní̤dû lahyǎ ané̤ rò a ki plwǒka̤ lahyǎ ané̤ ná htyě, phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Bí Giovanni me̤ atè̤me̤ kíré̤ phû htuô̌hò́ akhè̌nuô, a héso pé̤ kayǎ bè́mṳ tahe, ‘Thǐ tane̤ vǎ ná ǔpě? Vǎ ma kayǎ dố thǐ opò̤́myásû̌ aklyá nuôtôprè̤ má̤to. Nuôtôprè̤ ma a ki hyǎ dố vǎkhyěkhu pǎ, rò vǎ ki htulyě pé̤prè́ lǔ khupháplye̤ prè́ nuô̌꤮ vǎ kò ná è to.’ ");
INSERT INTO kyu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Puố̤vyá̤ Abraham aklwǐalyǎ thǐtahe ná Judaphú má̤to dố a o bíyě rò a cò́bucò́bè̌htya kuô̌ Cò́marya tahe lò̌꤮ plǐ thǐ꤮, tè̤me̤lwóhteka̤ ari-akyǎ yěnuô, ǔ thǔhyǎ pé̤ dố pè̤gně prè́. ");
INSERT INTO kyu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Me̤těhérò vǐ̤ Jerusalemphú tahe ná èthǐ akhuklò́ tahenuô a thè́gně kuô̌ lǔ ná è ma prè̤me̤lwóhteka̤ a Byacè tôprè̤ phúnuôto. Htuô̌to prè̤pro̤tahe alǎ̤angó̤ dố ǔ hốluô̌htya è bí Judaphú a Mò̤́nyěduô pwǒ̤꤮ tôphuố nuôtahe bèbè, èthǐ thè́gně tǎ̤plú kuô̌ǔ angó̤lasá to. Phúnuôrò thyáphú prè̤pro̤ tahe alǎ̤angó̤ ki lốhtyabǎhtya agněnuô, a nò̌cirya thyěkyǎ hò́ Jesǔ prè́. ");
INSERT INTO kyu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tè̤thû́tè̤plá dố a ki cirya thyěkyǎ Jesǔ agněnuôma a myáhtye tôcô꤮ to tadû́rò ǔ nò̌shyo Khwí Pilato dố a ki ciryathyěkyǎ lǔ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bí èthǐ me̤htuô̌ lò̌hò́ phú lisǎsè̌ héone lǔrilǔkyǎ akhè̌nuô, èthǐ cuốphyétǎ̤kyǎ lǔ dố krusulo̤ rò èthǐ cuốsunuô̌kyǎ lǔ dố luô̤̌kǔ. ");
INSERT INTO kyu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Manárò Cò́marya me̤htwǒprè̤ ihtòka̤khyě khyěthyá lǔ dố tè̤thyě. ");
INSERT INTO kyu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Htuô̌rò Byacè Jesǔ yě a dyéluô̌ mò̤́nyěmò̤́thè̌ nyě̤kú꤮ pé̤lǎ sálé̤ ané̤ ná kayǎ dố a cáhtya krwǒkuô̌ lǔkhyě, cáhtya dố Galilea ké̤ tuố̤dố vǐ̤ Jerusalem nuôtahe. Khǒnyá̤rò, èthǐ htwǒhtyahò́ prè̤khyáathè́ dố lǔgně rò a cuố khyápé̤hò́ Israelphú tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Khǒnyá̤rò pè̤ héso pé̤ thǐ tè̤thè́krṳ̂̌mila: Tè̤ dố Cò́marya ò́lya̤ pé̤ htuô̌hò́ ná pè̤phyěpè̤phuô̌ dố꤮ nyénu nuôtahe, ");
INSERT INTO kyu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","khǒnyá̤rò a me̤lốbǎ pé̤hò́ pè̤ hò́ ma dố Cò́marya me̤-ihtò htwǒprè̤ ka̤khyě khyěthyá hò́ Jesǔ dố tè̤thyě hò́. Pè̤ ma pè̤ klwǐlyǎ tǎ̤kalya̤ dố pè̤phyěpè̤phuô̌ yětahe a o hò́ rò a me̤lốbǎ pé̤hò́ pè̤ hò́. Phú ǔ rǎo dố Li Htuthè́htya amǎ̤du nyě̤tó̤tôtó̤ akǔnuô a hé, ‘Nè̤ ma vǎphúkhǔ, yětônyěrò, vǎ htwǒ hò́ nè̤phè̌ hò́.’ ");
INSERT INTO kyu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Cò́marya me̤-ihtò htwǒprè̤ ka̤khyě Krístu dố tè̤thyě hò́ rò athò̌alò cyá̤ pǎto hò́. Cò́marya hé, ‘Vǎ ki dyé thǐ tè̤sò̌ri dố asǎsè̌ ná atǎ̤ate̤ tahe phú vǎ ò́lya̤nuôlya̤ htuô̌hò́ Davi dố vǎ ki dyé è pǎ nuôtahe pǎ.’ ");
INSERT INTO kyu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Phú prè̤rǎli irǒ htuthè́htya hé pó̤, ‘Nè̤ nò̌thò̌nò̌lòkyǎ nè̤ lulésǎsè̌ yětôprè̤ dố luô̤̌kǔ to.’ ");
INSERT INTO kyu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Me̤těhérò Cò́marya taze-onekyǎ pé̤ Davi mú꤮ nukhè̌ rò Davi me̤htuô̌kyǎ bí ahtû̌khè̌ nuô, rò dốkhyěnuô a thyěkyǎ. Rò ǔ iluốtǎ̤tố̤ lǔ ná aphè̌ dố꤮ nyénu tahe rò ané̤klò̤́ thò̌kyǎ bínuô. ");
INSERT INTO kyu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Manárò kayǎ dố Cò́marya dyé htwǒprè̤ ka̤khyě è tôprè̤nuô athò̌alò to. ");
INSERT INTO kyu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Phúnuô akhu-akhyě, puố̤vyá̤ lò̌꤮ plǐ thǐ꤮ vǎ thè́zṳ̂́ nò̌thè́gně tǎ̤te̤ kuô̌ thǐ ná ǔ hésodônyǎ pé̤ thǐ tè̤plwǒkyǎ thǐ tè̤thû́ nuôma má̤dố Jesǔ Krístu akhu-akhyě prè́. ");
INSERT INTO kyu_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Dố Jesǔ me̤htuô̌hò́ akhu-akhyě, kayǎ dố a zṳ̂́e Jesǔ pwǒ̤꤮ tôprè̤ nuô Cò́marya plwǒkyǎ lò̌hò́ lǔtè̤thû́ rò a dyacò́dyate̤kyǎ lǔ hò́. Dố thǐ krwǒlṳ̂ me̤kuô̌ Mosè a tè̤thyótè̤thya akhu-akhyě, Cò́marya plwǒkyǎcyá̤ thǐ tè̤thû́ nuôtahe taki꤮ to. ");
INSERT INTO kyu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Phúnuôrò rò̤ní̤ lahyǎ thǐné̤, me̤těhérò thǐ ki me̤htwǒhtya tǎ thǐné̤ phú prè̤pro̤ tahe héone htuô̌hò́ nuôtahe tǎmé̤. ");
INSERT INTO kyu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Prè̤pro̤ hé, ‘Thǐ dố a hébè takhwótakè dûgně tahe thǐ꤮, ní̤dǎ lahyǎ! Khyéthukhyéthè́ rò thyěkyǎ lahyǎ mò̌. Me̤těhérò, bí thǐ htû̌khè̌ yěnuô vǎ ki me̤pé̤ thǐ tè̤tôcôcô dố ǔ héso pé̤ cò́ thǐ pǎ manárò thǐ zṳ̂́e kuô̌ǔ taki꤮ to yěnuô pǎ,’ prè̤pro̤ hé phúnuô.” ");
INSERT INTO kyu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bí Paulu ná Barnaba htecuốkyǎ dố tè̤cò́bè̌hǒkǔ akhè̌nuô, kayǎ bè́mṳ tahe nò̌hyǎpó̤ èthǐ shyé꤮ Judaphú a Mò̤́nyěduô bè khyěthyá dốkhyě thuô̌thyótônyě pǎ rò a nò̌hésodônyǎ è́htya pó̤ èthǐ ná tè̤ritè̤kyǎ thǐtahe. ");
INSERT INTO kyu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Rò bí ǔ cò́bè̌ htuô̌hò́ dố tè̤cò́bè̌hǒkǔ akhè̌nuô, Judaphú tahe ná Judaphú má̤to dố a zṳ̂́ka̤nyá̤ka̤ kuô̌ Judaphú a tè̤cò́bucò́bè̌ tahenuô, a krwǒplukrwǒphè kuô̌lò̌ Paulu ná Barnaba akhyě. Rò èthǐ hébè dyéhè̌dyére shyosò̌htya kayǎ dố a krwǒkuô̌ lǔkhyě nuôtahe ná a ki ohtwǒprè̤ thè́lè̤ plehyǎ ní̤kuô̌ lahyǎ ané̤ dố Cò́marya abwíataryě akǔ. ");
INSERT INTO kyu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Dốkhyě thuô̌thyótônyě bí Judaphú a Mò̤́nyěduô bè khyěthyá akhè̌nuô, kayǎ dố a hyǎ ní̤dǎkuô̌ Byacè Cò́marya alǎ̤angó̤ tahenuô a phû꤮ lò̌ cò́ tôvǐ̤lò̌ cò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bí Judaphú tahe myáhtye kayǎ hyǎró̤hyǎè́ akhè̌nuô, èthǐ thè́kothè́khwè́ ní̤kuô̌ nyacò́ Paulu rò a htésû pacyé̤ishyékyǎ Paulu a tè̤hébèhésû̌ tahe. ");
INSERT INTO kyu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Htuô̌rò Paulu ná Barnaba lé hébè khû̌hǎlố pó̤pó̤ cò́, rò a hé, “Pè̤ tǒbè hésodônyǎ ré̤lố pé̤ thǐ ná Cò́marya alǎ̤angó̤. Manárò thǐ zṳ̂́enyá̤e pè̤ tè̤dônyǎ yěnuô to akhu-akhyě, thǐ ciryalya̤ ní̤dyédû hò́ thǐné̤ phú kayǎ dố a kò ní̤bè kuô̌ǔ thè́htwǒprè̤ tacṳ́prè̤ to nuôtahe hò́. Phúnuôrò pè̤ ki dyakyǎ thǐ rò pè̤ ki cuố dố Judaphú má̤to tahe a o. ");
INSERT INTO kyu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Me̤těhérò, Byacè mekyǎ pè̤ angó̤, ‘Thyáphú hekhusǐbalò̌ ki ní̤bè kuô̌ǔ tè̤me̤lwóhteka̤ agněnuô, vǎ nò̌htwǒhtyahò́ thǐ phú tè̤lǐ tômě dố Judaphú má̤to tahe agně hò́.’” Byacè hékyǎ phúnuô. ");
INSERT INTO kyu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bí Judaphú má̤to yětahe ní̤huô̌nò́ kuô̌ hò́ tè̤yě akhè̌nuô, èthǐ thè́krṳ̂̌ rò htuthè́htya Byacè alǎ̤angó̤ yětahe hò́. Rò kayǎ dố Cò́marya nwóhtya hò́ èthǐ dố a ki ní̤bèkuô̌ thè́htwǒprè̤ tacṳ́prè̤ tahenuô, a htwǒka̤ lahyǎ prè̤zṳ̂́etè̤phú tahe hò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Byacè Cò́marya alǎ̤angó̤ yěnuô, ǔ bè hésodônyǎ luô̌pasǐcuố lò̌ è tôké̤lè̤̌ hò́. ");
INSERT INTO kyu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Manárò thyáphú ǔ ki me̤cyě̤me̤cṳ̂ Paulu ná Barnaba yěnuôrò Judaphú thǐ tahenuô, a nò̌shyo shyakrwǒ prè̤mò dố a cò́bè̌ Cò́marya rò a htwǒ khuklò́ tahe, ná prè̤khǔ dố a htwǒ khuklò́ dố vǐ̤kǔ nuôtahe, rò a nò̌cuốryǎ̤ dǐtû́ pó̤ kayǎ yětahe mikuố. Rò èthǐ vè̤́htekyǎ Paulu ná Barnaba dố èthǐ ké̤kǔ. ");
INSERT INTO kyu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Phúnuôrò Prè̤dônyǎphú tahe thuô̌tǎ̤kyǎ hemû dố a khanyělè̤̌. Yěma a dyéluô̌kyǎ vǐ̤kǔphú bínuô tahe ná tè̤mátè̤dyǎ tôcô hò́, me̤těhérò èthǐ vǐ̤kǔphú tahenuô, a htésû vè̤́htekyǎ èthǐ, rò èthǐ htecuốkyǎ dố vǐ̤ Iconio. ");
INSERT INTO kyu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Rò prè̤zṳ̂́etè̤phú o bí Pisidia ké̤, vǐ̤ Antioko akǔ tahenuô, èthǐ thè́krṳ̂̌thè́lò̌ nyacò́ rò a lốbǎ lahyǎ cò́ ná Thè́ Sǎsè̌ Byacè. ");
INSERT INTO kyu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Phú èthǐ me̤htuô̌hò́ dố vǐ̤ Antioko akǔnuô, Paulu ná Barnaba cuốnuô̌ dố Judaphú tahe tè̤